/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_1_kvt_bf16_nqpkv_8_m_8_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000019440ULL, 0x00000000000190c0ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f34314944327961ULL, 0x6f6c66625f766e5fULL,
0x326a4c3236317461ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL,
0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x336a4c4536316a4cULL, 0x4c49746132454532ULL,
0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4534366aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL,
0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL,
0x4d6e4974736e4939ULL, 0x4c45326a4c497461ULL, 0x45346a4c4545326aULL, 0x7461324545316a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL, 0x6a4c4532336a4c45ULL,
0x4c49746132454538ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x4545386a4c45386aULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x36316a4c4545346aULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x65746e695f5f2400ULL, 0x245f305f6c616e72ULL,
0x735f616475635f5fULL, 0x5f7063725f30326dULL, 0x665f7a74665f6e72ULL, 0x70776f6c735f3233ULL,
0x695f5f2400687461ULL, 0x5f6c616e7265746eULL, 0x6475635f5f245f31ULL, 0x735f30376d735f61ULL,
0x5f636e79736c6668ULL, 0x2400705f796c6662ULL, 0x6e7265746e695f5fULL, 0x5f5f245f325f6c61ULL,
0x376d735f61647563ULL, 0x79736c6668735f30ULL, 0x705f7864695f636eULL, 0x65746e695f5f2400ULL,
0x245f335f6c616e72ULL, 0x735f616475635f5fULL, 0x65746f765f30376dULL, 0x6c61625f636e7973ULL,
0x6c65722e00746f6cULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x240061686d5f6c65ULL, 0x6d5f6c656e72656bULL, 0x426d656d73246168ULL,
0x2e00667542657479ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x2e006d617261705fULL, 0x72665f6775626564ULL, 0x6c65722e00656d61ULL, 0x665f67756265642eULL,
0x65722e00656d6172ULL, 0x67756265642e616cULL, 0x2e00656d6172665fULL, 0x612e6c65722e766eULL,
0x0000006e6f697463ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c0001000000adULL, 0x000000000000002cULL, 0x0000000000000010ULL, 0x000c0001000000ebULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x000c00010000016bULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000c0001000001b5ULL, 0x0000000000000010ULL, 0x0000000000000004ULL, 0x000c0001000001fbULL,
0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c000100000242ULL, 0x0000000000000008ULL,
0x0000000000000004ULL, 0x000c000100000288ULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000c0001000002d6ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c000100000324ULL,
0x0000000000000020ULL, 0x0000000000000004ULL, 0x000c00010000036aULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c0001000003afULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000b0022000003f5ULL, 0x0000000000017800ULL, 0x0000000000000170ULL, 0x000b002200000428ULL,
0x0000000000017970ULL, 0x0000000000000040ULL, 0x000b002200000453ULL, 0x00000000000179b0ULL,
0x0000000000000050ULL, 0x000b00220000047dULL, 0x0000000000017a00ULL, 0x0000000000000100ULL,
0x000a0003000004ebULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000400030000050bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000700030000053bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL, 0x0000000000017b00ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0001780000000000ULL, 0x0000040400000000ULL, 0x810c000001440400ULL,
0x005cac0400288080ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL,
0xcc08288080c90828ULL, 0x2880808608288080ULL, 0x0003102880828016ULL, 0x9200000000000000ULL,
0x0000220028808086ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL, 0x0001780000000000ULL,
0x0000017000000000ULL, 0x0000000000000000ULL, 0x00000054ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL,
0x8a08288080860828ULL, 0x288080c908288080ULL, 0x808808288080cc08ULL, 0x1028808280162880ULL,
0x0000000000000003ULL, 0x2200288080889200ULL, 0x0000001cffffffffULL, 0x000000f000000000ULL,
0x0001797000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080820828808081ULL, 0xc908288080860828ULL, 0x288080cc08288080ULL, 0x0003102880828016ULL,
0x9200000000000000ULL, 0x00002200288080ccULL, 0x0000002cffffffffULL, 0x0000017800000000ULL,
0x000179b000000000ULL, 0x0000005000000000ULL, 0x0000100400000000ULL, 0x8082288080cc0900ULL,
0x0000000000002880ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL, 0xcc08288080860828ULL,
0x288080c908288080ULL, 0x0003102880828016ULL, 0x9200000000000000ULL, 0x00002200288080c9ULL,
0x0000002cffffffffULL, 0x0000020800000000ULL, 0x00017a0000000000ULL, 0x0000010000000000ULL,
0x0000180400000000ULL, 0x8082288080c90900ULL, 0x0000000000002880ULL, 0x0000001800082f04ULL,
0x00082304000000ccULL, 0x0000000000000014ULL, 0x0000001400081204ULL, 0x0008110400000000ULL,
0x0000000000000014ULL, 0x0000001300082304ULL, 0x0008120400000000ULL, 0x0000000000000013ULL,
0x0000001300081104ULL, 0x0008230400000000ULL, 0x0000000000000012ULL, 0x0000001200081204ULL,
0x0008110400000000ULL, 0x0000000000000012ULL, 0x0000001100082304ULL, 0x0008120400000000ULL,
0x0000000000000011ULL, 0x0000001100081104ULL, 0x0008230400000000ULL, 0x0000000000000018ULL,
0x0000001800081204ULL, 0x0008110400000000ULL, 0x0000000000000018ULL, 0x0000007b00043704ULL,
0x00080a0400003501ULL, 0x0048016000000015ULL, 0x000c170400481903ULL, 0x0040000600000000ULL,
0x000c17040021f000ULL, 0x0038000500000000ULL, 0x000c17040021f000ULL, 0x0030000400000000ULL,
0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040061f000ULL, 0x0010000200000000ULL,
0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL,
0x00ff1b030011f000ULL, 0x0000002000043104ULL, 0xffffffff01cc2904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x000000f001cc2804ULL, 0x0000039000000110ULL, 0x000020c0000012b0ULL, 0x0000224000002150ULL,
0x000025c0000023b0ULL, 0x00002660000025f0ULL, 0x00002c20000026d0ULL, 0x0000374000003710ULL,
0x00003820000037b0ULL, 0x00004a8000003d20ULL, 0x00004c2000004b10ULL, 0x00004f9000004d80ULL,
0x0000503000004fc0ULL, 0x00005330000050a0ULL, 0x00005e5000005e20ULL, 0x00005f3000005ec0ULL,
0x00006fa000006240ULL, 0x0000713000007020ULL, 0x000074a000007290ULL, 0x00007540000074d0ULL,
0x00007840000075b0ULL, 0x0000836000008330ULL, 0x00008440000083d0ULL, 0x000094b000008750ULL,
0x0000964000009530ULL, 0x000099b0000097a0ULL, 0x00009a50000099e0ULL, 0x00009d8000009ac0ULL,
0x0000a8a00000a870ULL, 0x0000a9800000a910ULL, 0x0000ae600000ae50ULL, 0x0000cf700000b5c0ULL,
0x0000d5f00000cfb0ULL, 0x0000dcd00000d630ULL, 0x00015900000158c0ULL, 0x0001592000015910ULL,
0x0001599000015970ULL, 0x000159c0000159b0ULL, 0x000166a000016640ULL, 0x0001678000016710ULL,
0x0001688000016800ULL, 0x0001697000016900ULL, 0x00016a30000169d0ULL, 0x00016b1000016aa0ULL,
0x00016c0000016b90ULL, 0x00016cf000016c80ULL, 0x00016db000016d50ULL, 0x00016e9000016e20ULL,
0x00016f8000016f10ULL, 0x0001707000017000ULL, 0x00017130000170d0ULL, 0x00017210000171a0ULL,
0x0001730000017290ULL, 0x000173f000017380ULL, 0x000174d000017460ULL, 0x000175d000017550ULL,
0x000176d000017650ULL, 0x000177d000017750ULL, 0x000002b002003904ULL, 0x0001c600000000ffULL,
0x000002e0003f0100ULL, 0x0001c60800000003ULL, 0x00000310003f0120ULL, 0x0001c68800000003ULL,
0x000004a0003f0120ULL, 0x0001c600000000ffULL, 0x000005a0003f0107ULL, 0x0001c68c00000000ULL,
0x00000650003f0102ULL, 0x0001c68800000000ULL, 0x00001df0003f0101ULL, 0x0001c60800000000ULL,
0x00001e10003f0101ULL, 0x0001c60c00000000ULL, 0x00001fe0003f0105ULL, 0x0001c60c00000000ULL,
0x00003cd0003f0105ULL, 0x0001c688000000ffULL, 0x00004800003f0101ULL, 0x0001c62800000000ULL,
0x00004820003f0101ULL, 0x0001c62c00000000ULL, 0x000049f0003f0105ULL, 0x0001c62c00000000ULL,
0x00006200003f0105ULL, 0x0001c690000000ffULL, 0x00006d20003f0101ULL, 0x0001c64800000000ULL,
0x00006d40003f0101ULL, 0x0001c64c00000000ULL, 0x00006f10003f0105ULL, 0x0001c64c00000000ULL,
0x00008710003f0105ULL, 0x0001c698000000ffULL, 0x00009230003f0101ULL, 0x0001c66800000000ULL,
0x00009250003f0101ULL, 0x0001c66c00000000ULL, 0x00009420003f0105ULL, 0x0001c66c00000000ULL,
0x0000ac50003f0105ULL, 0x0001c6a0000000ffULL, 0x0000dfe0003f0101ULL, 0x0001c600000000ffULL,
0x0000f620003f0101ULL, 0x0001c604000000ffULL, 0x0000f7f0003f0105ULL, 0x0001c604000000ffULL,
0x00014df0003f0105ULL, 0x000000000000002eULL, 0x00014e10003f0101ULL, 0x000000040000002eULL,
0x00014fe0003f0105ULL, 0x000000040000002eULL, 0x00016490003f0105ULL, 0x0001c60800000002ULL,
0x000164f0003f0101ULL, 0x0001c61000000002ULL, 0x00016550003f0101ULL, 0x0001c61800000002ULL,
0x000165c0003f0101ULL, 0x0001c62000000002ULL, 0x00033803003f0101ULL, 0x0000df5000101c04ULL,
0x0000f8d00000f850ULL, 0x0000040100016600ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL,
0x0000000000041e04ULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000274ULL,
0x0000001800000002ULL, 0x00000000000001e4ULL, 0x0000001800000002ULL, 0x0000000000000164ULL,
0x0000001800000002ULL, 0x00000000000000dcULL, 0x0000001800000002ULL, 0x0000000000000044ULL,
0x0000001800000002ULL, 0x000000000000024fULL, 0x0000001800000002ULL, 0x00000000000001bfULL,
0x0000001800000002ULL, 0x0000000000000141ULL, 0x0000001800000002ULL, 0x00000000000000b7ULL,
0x0000001800000002ULL, 0x000000000001c700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000037919ULL, 0x000e620000002100ULL,
0x0000000000147806ULL, 0x000fe200038e0000ULL, 0x0000460000067ab9ULL, 0x000fe20000000a00ULL,
0x00000000000479c3ULL, 0x000ea20000002500ULL, 0x0000000000057919ULL, 0x000ee20000002300ULL,
0x0000001400077300ULL, 0x000f2600000e0000ULL, 0x0000000000027919ULL, 0x000f280000002200ULL,
0x0000000000787919ULL, 0x000f220000002600ULL, 0x0000001400147309ULL, 0x000ee60000000000ULL,
0x0000000000087919ULL, 0x000f280000000000ULL, 0x0000000000117919ULL, 0x000f220000002700ULL,
0x00000005ff7b7819ULL, 0x002fc60000011603ULL, 0x0000000000047919ULL, 0x000e620000000000ULL,
0x00000004ff7c7e24ULL, 0x004fc6000f8e00ffULL, 0x00001fff05007589ULL, 0x0085e200000e0000ULL,
0x0000010005027a24ULL, 0x010fc600078e0202ULL, 0x00001fff7b7b7589ULL, 0x000ee200000e0000ULL,
0x0000000002037a24ULL, 0x000fe400078e0203ULL, 0x00005800ff027624ULL, 0x000fe200078e00ffULL,
0x000000080700720cULL, 0x000fe40003f02070ULL, 0x000000ff0300720cULL, 0x040fe20003f25270ULL,
0x0000000802057824ULL, 0x004fe200078e00ffULL, 0x0000000f0300780cULL, 0x040fe20003f44070ULL,
0x0000000878027824ULL, 0x000fe200078e00ffULL, 0x000000030300780cULL, 0x000fc40003f64070ULL,
0x0000007f0300780cULL, 0x000fe20003f84070ULL, 0x0000001105057224ULL, 0x000fe400078e0202ULL,
0x00000010040e7824ULL, 0x002fc800078e00ffULL, 0x7fffff80ff079424ULL, 0x000fe200078e00ffULL,
0x000001f00e137812ULL, 0x000fe200078ec0ffULL, 0x3fffffc0ff08a424ULL, 0x000fe200078e00ffULL,
0x0000007b00067211ULL, 0x008fe200078e10ffULL, 0x7fffff60ff0db424ULL, 0x000fe200078e00ffULL,
0x7fffffc00009a802ULL, 0x000fe20000000f00ULL, 0xff317217ff12c424ULL, 0x000fe200078e00ffULL,
0x3fffff60000cb802ULL, 0x000fe20000000f00ULL, 0x00000002060a7824ULL, 0x000fe400078e00ffULL,
0x3fffff80ff069424ULL, 0x000fc400078e00ffULL, 0x000000010a027824ULL, 0x040fe200078e0204ULL,
0x000000080a0b7817ULL, 0x040fe20007800000ULL, 0x000000200a0f7824ULL, 0x040fe200078e00ffULL,
0x000000010a107810ULL, 0x000fe20007ffe0ffULL, 0x01c60006ff009388ULL, 0x0003e40000000a00ULL,
0x000000010b0b7824ULL, 0x000fe200078e0a0aULL, 0xffffffe00f0f7812ULL, 0x000fe200078ee202ULL,
0x01c608080300a388ULL, 0x0005e20000008a00ULL, 0x00000200ff027424ULL, 0x000fe400078e00ffULL,
0x000000ff0b00720cULL, 0x040fe20003f23070ULL, 0x01c6880c0300b388ULL, 0x000fe20000008a00ULL,
0x000000010b00780cULL, 0x000fe20003f43070ULL, 0x0000000105077824ULL, 0x002fc400078e020aULL,
0x01c400120300c388ULL, 0x000fe20000004800ULL, 0x000000100f0f7824ULL, 0x000fe400078e00ffULL,
0x00005c0007067625ULL, 0x000fe200078e0002ULL, 0x0000001005097210ULL, 0x004fc60007ffe0ffULL,
0x0000000110057824ULL, 0x000fe200078e0204ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00005c0009087625ULL, 0x000fe200078e0002ULL, 0x00000013060a7210ULL, 0x080fe40007f7e0ffULL,
0x80000014ff037210ULL, 0x000fe20007ffe0ffULL, 0x0000002010107824ULL, 0x000fe200078e00ffULL,
0x0000001308087210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff0b7224ULL, 0x000fc400018e0607ULL,
0x00000004ff067424ULL, 0x000fe200078e00ffULL, 0xffffffe010057812ULL, 0x000fe200078ee205ULL,
0x000000ffff097224ULL, 0x000fe200020e0609ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0f7faeULL, 0x0003e2000c901c46ULL, 0x0000600011067625ULL, 0x000fc800078e0006ULL,
0x0000001005057824ULL, 0x000fca00078e00ffULL, 0x0000000008057faeULL, 0x0003e8000d101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x01c60403ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01c60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000006067a7981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0000720cULL, 0x000fc40003f05270ULL,
0x000000ff7a797810ULL, 0x004fc80007ffe0ffULL, 0x00000008ff797819ULL, 0x000fce0000011679ULL,
0x0000d9f000008947ULL, 0x000fea0003800000ULL, 0x000000037b007819ULL, 0x000fe200000006ffULL,
0x00000003ff037424ULL, 0x002fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01c68c0300ff738cULL, 0x0003e20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000017c087810ULL, 0x000fe20007ffe0ffULL, 0x0000000211067824ULL, 0x000fe200078e00ffULL,
0x0000580078037a10ULL, 0x002fe20007ffe0ffULL, 0x000001007c077824ULL, 0x000fe200078e00ffULL,
0x000000790800720cULL, 0x000fe20003f06070ULL, 0x01c6880000ff7f8cULL, 0x0003e4000c80043fULL,
0x0000580006067a24ULL, 0x000fc800078e0203ULL, 0x0000620006127a24ULL, 0x000fcc00078e0207ULL,
0x000005a000008947ULL, 0x000fea0003800000ULL, 0x000000077a037217ULL, 0x002fe20007800000ULL,
0x000000087b097824ULL, 0x000fe200078e00ffULL, 0x00000003ff057819ULL, 0x100fe40000011604ULL,
0x0000000307037210ULL, 0x000fe40007ffe1ffULL, 0xfffffff809077812ULL, 0x100fe200078ee204ULL,
0x0000000105087824ULL, 0x000fe200078e0204ULL, 0x0000002003037817ULL, 0x000fe20003800000ULL,
0x0000000112097824ULL, 0x000fe200078e0205ULL, 0x00000004050a7810ULL, 0x000fc40007ffe0ffULL,
0x00000008050d7810ULL, 0x040fe40007ffe0ffULL, 0x0000000c050f7810ULL, 0x000fe20007ffe0ffULL,
0x000000010a0c7824ULL, 0x100fe200078e0204ULL, 0x00000007080b7812ULL, 0x000fe200078ec0ffULL,
0x00005e0009087625ULL, 0x000fe200078e0002ULL, 0x000000030500720cULL, 0x000fe40003f06070ULL,
0x000140007b147811ULL, 0x000fe200078e68ffULL, 0x000000080a157824ULL, 0x000fe200078e00ffULL,
0x0ffffff80b0b7812ULL, 0x100fe200078ef804ULL, 0x000000080d177824ULL, 0x040fe200078e00ffULL,
0x000000040d0e7210ULL, 0x000fe20007ffe0ffULL, 0x000000010f107824ULL, 0x000fe200078e0204ULL,
0xfffffff815157812ULL, 0x000fe200078ee20cULL, 0x000000080f197824ULL, 0x000fe200078e00ffULL,
0xfffffff817177812ULL, 0x000fe200078ee20eULL, 0x0000001007087825ULL, 0x000fe200078e0008ULL,
0x00000010050c7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff819197812ULL, 0x000fe200078ee210ULL,
0x000000100b0b7824ULL, 0x100fe200078e0214ULL, 0x00000014050e7810ULL, 0x000fe20007ffe0ffULL,
0x0000001017177824ULL, 0x100fe200078e0214ULL, 0x0000001805107810ULL, 0x000fe20007ffe0ffULL,
0x0000001019197824ULL, 0x000fe200078e0214ULL, 0x0000001c05057810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080b7faeULL, 0x0003e2000c101c46ULL,
0x000000030d00720cULL, 0x080fe20003f26070ULL, 0x000000080e1b7824ULL, 0x000fe200078e00ffULL,
0x000000030a00720cULL, 0x080fe20003f06070ULL, 0x00000008101d7824ULL, 0x000fe200078e00ffULL,
0x000000030f00720cULL, 0x080fe20003f46070ULL, 0x0000000805217824ULL, 0x040fe200078e00ffULL,
0x000000030c00720cULL, 0x080fe20003f66070ULL, 0x0000000112117824ULL, 0x000fe200078e020eULL,
0x000000030e00720cULL, 0x080fe20003f86070ULL, 0x0000000112137824ULL, 0x000fe200078e0210ULL,
0x000000031000720cULL, 0x080fe20003fa6070ULL, 0x00000001120b7824ULL, 0x042fe200078e020dULL,
0x000000030500720cULL, 0x000fe20003fc6070ULL, 0x00000001120d7824ULL, 0x040fe200078e020fULL,
0x0000000a12097210ULL, 0x000fe20007ffe0ffULL, 0x000000010e087824ULL, 0x000fe200078e0204ULL,
0x000000030c167819ULL, 0x000fe200000006ffULL, 0x00000001120f7824ULL, 0x040fe200078e020cULL,
0x00000005121f7210ULL, 0x000fe20007ffe0ffULL, 0x000000010c037824ULL, 0x000fe200078e0204ULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee208ULL, 0x00000001100a7824ULL, 0x100fe200078e0204ULL,
0x0000001415157211ULL, 0x000fe200078e20ffULL, 0x00000001050c7824ULL, 0x000fe200078e0204ULL,
0xfffffff816057812ULL, 0x000fe200078ee203ULL, 0x00005e0009087625ULL, 0x000fe200078e0002ULL,
0xfffffff81d1d7812ULL, 0x000fc400078ee20aULL, 0xfffffff821217812ULL, 0x000fe200078ee20cULL,
0x00005e000b0a7625ULL, 0x000fe200078e0002ULL, 0x000000141d1d7211ULL, 0x000fc600078e20ffULL,
0x00005e000d0c7625ULL, 0x000fc800078e0002ULL, 0x00005e000f0e7625ULL, 0x000fc800078e0002ULL,
0x00005e0011107625ULL, 0x000fc800078e0002ULL, 0x00005e0013127625ULL, 0x000fc800078e0002ULL,
0x00005e001f027625ULL, 0x000fc800078e0002ULL, 0x0000001007087825ULL, 0x000fc800078e0008ULL,
0x00000010070a7825ULL, 0x040fe200078e000aULL, 0x0000000008157faeULL, 0x0003e6000c101c46ULL,
0x00000010070c7825ULL, 0x040fe200078e000cULL, 0x000000000a177faeULL, 0x0003e6000c901c46ULL,
0x00000010070e7825ULL, 0x000fe200078e000eULL, 0x000000000c197faeULL, 0x0003e6000d101c46ULL,
0x0000001005057824ULL, 0x000fc400078e0214ULL, 0x0000001007107825ULL, 0x000fc600078e0010ULL,
0x000000000e057faeULL, 0x0003e2000d901c46ULL, 0x000000101b1b7824ULL, 0x000fe400078e0214ULL,
0x0000001007127825ULL, 0x000fc600078e0012ULL, 0x00000000101b7faeULL, 0x0003e2000e101c46ULL,
0x0000001007027825ULL, 0x000fc600078e0002ULL, 0x00000000121d7faeULL, 0x0003e2000e901c46ULL,
0x0000001021217824ULL, 0x000fca00078e0214ULL, 0x0000000002217faeULL, 0x0003e2000f101c46ULL,
0x000004d000007947ULL, 0x000fea0003800000ULL, 0x0000000404057811ULL, 0x042fe200078fe8ffULL,
0x000000087b1d7824ULL, 0x000fe200078e00ffULL, 0x0000001404137811ULL, 0x040fe400078fe8ffULL,
0x00000008040d7811ULL, 0x040fe200078fe8ffULL, 0x0000000105037824ULL, 0x140fe200078e0204ULL,
0x0000000c040f7811ULL, 0x040fe200078fe8ffULL, 0x0000000805087824ULL, 0x000fe200078e00ffULL,
0x0000001004117811ULL, 0x000fe200078fe8ffULL, 0x0000000813157824ULL, 0x040fe200078e00ffULL,
0x00000004130a7210ULL, 0x080fe20007ffe0ffULL, 0x000000080f0b7824ULL, 0x000fe200078e00ffULL,
0xfffffff808077812ULL, 0x000fe200078ee203ULL, 0x000000010d037824ULL, 0x140fe200078e0204ULL,
0x000000030d167819ULL, 0x000fe200000006ffULL, 0x000000010f087824ULL, 0x000fe200078e0204ULL,
0xfffffff8151c7812ULL, 0x000fe200078ee20aULL, 0x0000000111097824ULL, 0x040fe200078e0204ULL,
0x0000001804157811ULL, 0x040fe200078fe8ffULL, 0x00000008111a7824ULL, 0x000fe200078e00ffULL,
0x0000001c04197811ULL, 0x000fe200078fe8ffULL, 0x00000001120d7824ULL, 0x000fe200078e020dULL,
0xfffffff816167812ULL, 0x000fe200078ee203ULL, 0x0000000112177824ULL, 0x040fe200078e0215ULL,
0xfffffff80b187812ULL, 0x000fe200078ee208ULL, 0x00000001120b7824ULL, 0x000fe200078e0205ULL,
0x0000000404037211ULL, 0x000fe200078fe8ffULL, 0x0000000115057824ULL, 0x100fe200078e0204ULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee209ULL, 0x00000001190a7824ULL, 0x000fe200078e0204ULL,
0x00000003151e7819ULL, 0x000fe200000006ffULL, 0x0000000819157824ULL, 0x000fe200078e00ffULL,
0x0000001204097211ULL, 0x000fe200078fe8ffULL, 0x0000000112117824ULL, 0x040fe200078e0211ULL,
0x0000000f120f7210ULL, 0x040fe20007ffe0ffULL, 0x0000000112137824ULL, 0x040fe200078e0213ULL,
0x0000000703037812ULL, 0x000fe200078ec0ffULL, 0x00000001121b7824ULL, 0x000fe200078e0219ULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee205ULL, 0x00005e0009087625ULL, 0x000fe200078e0002ULL,
0xfffffff815207812ULL, 0x000fc400078ee20aULL, 0xfffffff81d197812ULL, 0x100fe200078ee204ULL,
0x00005e000b0a7625ULL, 0x080fe200078e0002ULL, 0x000140007b217811ULL, 0x000fe400078e68ffULL,
0x0ffffff803057812ULL, 0x000fe200078ef804ULL, 0x00005e000d0c7625ULL, 0x080fe200078e0002ULL,
0x0000002107077211ULL, 0x080fe400078e20ffULL, 0x000000211e1f7211ULL, 0x000fe200078e20ffULL,
0x00005e000f0e7625ULL, 0x000fc800078e0002ULL, 0x00005e0011107625ULL, 0x000fc800078e0002ULL,
0x00005e0013127625ULL, 0x000fc800078e0002ULL, 0x00005e0017147625ULL, 0x000fc800078e0002ULL,
0x00005e001b027625ULL, 0x000fc800078e0002ULL, 0x0000001019087825ULL, 0x000fc800078e0008ULL,
0x0000001005057824ULL, 0x000fe400078e0221ULL, 0x00000010190a7825ULL, 0x000fc600078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008057faeULL, 0x0003e2000b901c46ULL,
0x00000010190c7825ULL, 0x000fc600078e000cULL, 0x000000000a077faeULL, 0x0003e2000b901c46ULL,
0x00000010190e7825ULL, 0x000fc800078e000eULL, 0x0000001019107825ULL, 0x000fc800078e0010ULL,
0x0000001019127825ULL, 0x000fc800078e0012ULL, 0x0000001019147825ULL, 0x000fc800078e0014ULL,
0x0000001019027825ULL, 0x000fc800078e0002ULL, 0x0000001016177824ULL, 0x100fe400078e0221ULL,
0x0000001018197824ULL, 0x100fe400078e0221ULL, 0x000000101a1b7824ULL, 0x100fe200078e0221ULL,
0x000000000c177faeULL, 0x0003e2000b901c46ULL, 0x000000101c1d7824ULL, 0x100fe400078e0221ULL,
0x0000001020217824ULL, 0x000fe200078e0221ULL, 0x000000000e197faeULL, 0x0003e8000b901c46ULL,
0x00000000101b7faeULL, 0x0003e8000b901c46ULL, 0x00000000121d7faeULL, 0x0003e8000b901c46ULL,
0x00000000141f7faeULL, 0x0003e8000b901c46ULL, 0x0000000002217faeULL, 0x0003e4000b901c46ULL,
0x000000797c00720cULL, 0x000fe20003f06070ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xff317217ff437424ULL, 0x000fe200078e00ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x000000ffff057224ULL, 0x002fe200078e00ffULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00009a5000000947ULL, 0x000fea0003800000ULL, 0xff317217ff437424ULL, 0x000fe200078e00ffULL,
0x000000ff00237202ULL, 0x000fc40000000f00ULL, 0x000001007c037824ULL, 0x000fca00078e00ffULL,
0x0000007a0300720cULL, 0x000fda0003f06070ULL, 0x000099c000000947ULL, 0x020fea0003800000ULL,
0x000000017c027810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000000790200720cULL, 0x000fe40003f26070ULL, 0x000000207c377811ULL, 0x000fca00078e40ffULL,
0x0000620006317a24ULL, 0x000fcc00078e0237ULL, 0x000005b000009947ULL, 0x000fea0003800000ULL,
0x00000003ff337819ULL, 0x100fe20000011604ULL, 0x00000200ff397424ULL, 0x000fe200078e00ffULL,
0x000000377a027217ULL, 0x000fe40007800000ULL, 0x00000004332d7810ULL, 0x000fe40007ffe0ffULL,
0x0000000704037812ULL, 0x000fe400078ec0ffULL, 0x0000000237027210ULL, 0x000fe20007ffe1ffULL,
0x000000012d1e7824ULL, 0x000fe200078e0204ULL, 0x000150007b347811ULL, 0x000fe200078e68ffULL,
0x000000082d2f7824ULL, 0x000fe200078e00ffULL, 0x00000020022c7817ULL, 0x000fe20003800000ULL,
0x0000000100357824ULL, 0x000fe200078e0203ULL, 0x00000008333b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000133037824ULL, 0x000fe200078e0231ULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee21eULL,
0x00000001331e7824ULL, 0x040fe200078e0204ULL, 0x0000002c3300720cULL, 0x080fe20003f06070ULL,
0x00005e0003027625ULL, 0x000fe200078e0039ULL, 0x0000002c2d00720cULL, 0x000fc40003f46070ULL,
0x000000071e1f7812ULL, 0x000fe200078ec0ffULL, 0x000000012d1e7824ULL, 0x000fe200078e0231ULL,
0x0000000c333f7810ULL, 0x000fe20007ffe0ffULL, 0x0000001035027825ULL, 0x000fe200078e0002ULL,
0x0ffffff81f2d7812ULL, 0x000fe400078ef804ULL, 0x000000342f2f7211ULL, 0x000fe200078e20ffULL,
0x00005e001e1e7625ULL, 0x000fe200078e0039ULL, 0x0000001033457810ULL, 0x040fe40007ffe0ffULL,
0x0000001433477810ULL, 0x000fe20007ffe0ffULL, 0x000000102d2d7824ULL, 0x000fe200078e0234ULL,
0x0000001833497810ULL, 0x000fe20007ffe0ffULL, 0x00000010351e7825ULL, 0x000fe200078e001eULL,
0x0000001c33337810ULL, 0x000fc40007ffe0ffULL, 0x000000043b2e7210ULL, 0x040fe20007ffe0ffULL,
0x000000083b3d7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000022d7faeULL, 0x0003e2000c101c46ULL, 0x000000013f307824ULL, 0x000fe200078e0204ULL,
0x0000002c3b00720cULL, 0x080fe20003f06070ULL, 0x000000083f417824ULL, 0x000fe200078e00ffULL,
0x000000001e2f7faeULL, 0x0005e2000d101c46ULL, 0x0000000847387824ULL, 0x000fe200078e00ffULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee22eULL, 0x00000008493a7824ULL, 0x000fe200078e00ffULL,
0xfffffff841417812ULL, 0x000fe200078ee230ULL, 0x00000008333c7824ULL, 0x000fe200078e00ffULL,
0x0000002c3f00720cULL, 0x080fe20003f46070ULL, 0x00000001472e7824ULL, 0x100fe200078e0231ULL,
0x0000002c4500720cULL, 0x0c0fe20003f66070ULL, 0x0000000145037824ULL, 0x102fe200078e0204ULL,
0x0000002c4700720cULL, 0x080fe20003f86070ULL, 0x00000001492d7824ULL, 0x140fe200078e0204ULL,
0x0000002c4900720cULL, 0x080fe20003fa6070ULL, 0x00000001471f7824ULL, 0x104fe200078e0204ULL,
0x0000002c3300720cULL, 0x040fe20003fc6070ULL, 0x00000001332f7824ULL, 0x000fe200078e0204ULL,
0x0000000345367819ULL, 0x000fe200000006ffULL, 0x000000013b027824ULL, 0x100fe200078e0231ULL,
0x0000003133327210ULL, 0x000fe20007ffe0ffULL, 0x000000013f1e7824ULL, 0x000fe200078e0231ULL,
0xfffffff8363b7812ULL, 0x000fe200078ee203ULL, 0x00000001452c7824ULL, 0x000fe200078e0231ULL,
0xfffffff8383f7812ULL, 0x000fe200078ee21fULL, 0x0000000149307824ULL, 0x000fe200078e0231ULL,
0xfffffff83a457812ULL, 0x000fe200078ee22dULL, 0x00005e0002027625ULL, 0x000fe200078e0039ULL,
0xfffffff83c477812ULL, 0x000fc600078ee22fULL, 0x00005e001e1e7625ULL, 0x000fc800078e0039ULL,
0x00005e002c2c7625ULL, 0x000fc800078e0039ULL, 0x00005e002e2e7625ULL, 0x000fc800078e0039ULL,
0x00005e0030307625ULL, 0x000fc800078e0039ULL, 0x00005e0032327625ULL, 0x000fc800078e0039ULL,
0x0000001035027825ULL, 0x000fc800078e0002ULL, 0x00000010351e7825ULL, 0x000fc800078e001eULL,
0x00000010352c7825ULL, 0x000fc800078e002cULL, 0x00000010352e7825ULL, 0x000fc800078e002eULL,
0x0000001035307825ULL, 0x000fc800078e0030ULL, 0x0000001035327825ULL, 0x000fe200078e0032ULL,
0x000000343d357211ULL, 0x000fc600078e20ffULL, 0x0000001041397824ULL, 0x100fe200078e0234ULL,
0x0000003447417211ULL, 0x000fe200078e20ffULL, 0x000000103b3b7824ULL, 0x100fe200078e0234ULL,
0x0000000002357faeULL, 0x0003e2000c101c46ULL, 0x000000103f3d7824ULL, 0x100fe400078e0234ULL,
0x00000010453f7824ULL, 0x000fe200078e0234ULL, 0x000000001e397faeULL, 0x0003e8000d101c46ULL,
0x000000002c3b7faeULL, 0x0003e8000d901c46ULL, 0x000000002e3d7faeULL, 0x0003e8000e101c46ULL,
0x00000000303f7faeULL, 0x0003e8000e901c46ULL, 0x0000000032417faeULL, 0x0003e2000f101c46ULL,
0x000004e000007947ULL, 0x000fea0003800000ULL, 0x00000004041e7811ULL, 0x040fe200078fe8ffULL,
0x00000200ff397424ULL, 0x000fe200078e00ffULL, 0x00000008042c7811ULL, 0x000fc400078fe8ffULL,
0x0000000c042e7811ULL, 0x000fe200078fe8ffULL, 0x000000011e027824ULL, 0x000fe200078e0204ULL,
0x0000001004307811ULL, 0x000fe200078fe8ffULL, 0x000000081e037824ULL, 0x000fe200078e00ffULL,
0x0000001404327811ULL, 0x000fe200078fe8ffULL, 0x000000082c2f7824ULL, 0x000fe200078e00ffULL,
0x0000001c04357811ULL, 0x000fe200078fe8ffULL, 0x000000082e3e7824ULL, 0x000fe200078e00ffULL,
0xfffffff8033a7812ULL, 0x000fe200078ee202ULL, 0x000000012c027824ULL, 0x100fe200078e0204ULL,
0x000000042e037210ULL, 0x080fe20007ffe0ffULL, 0x00000001301f7824ULL, 0x000fe200078e0204ULL,
0x0000000332427819ULL, 0x000fe200000006ffULL, 0x0000000830407824ULL, 0x000fe200078e00ffULL,
0xfffffff82f3c7812ULL, 0x000fe200078ee202ULL, 0x00000001322d7824ULL, 0x100fe200078e0204ULL,
0x00000018042f7811ULL, 0x000fe200078fe8ffULL, 0x0000000835467824ULL, 0x000fe200078e00ffULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee203ULL, 0x000000011e1e7824ULL, 0x100fe200078e0231ULL,
0x0000000404037211ULL, 0x000fe200078fe8ffULL, 0x000000012f347824ULL, 0x040fe200078e0231ULL,
0x000000032f447819ULL, 0x040fe200000006ffULL, 0x000000012f337824ULL, 0x100fe200078e0204ULL,
0xfffffff840407812ULL, 0x000fe200078ee21fULL, 0x00000001352f7824ULL, 0x000fe200078e0204ULL,
0xfffffff842427812ULL, 0x000fe200078ee22dULL, 0x000000012c2c7824ULL, 0x100fe200078e0231ULL,
0x00000007041f7812ULL, 0x000fe200078ec0ffULL, 0x000000012e2e7824ULL, 0x100fe200078e0231ULL,
0x0000003104027211ULL, 0x080fe200078fe8ffULL, 0x0000000132327824ULL, 0x100fe200078e0231ULL,
0x00000007032d7812ULL, 0x000fe200078ec0ffULL, 0x0000000135387824ULL, 0x000fe200078e0231ULL,
0x0000003130307210ULL, 0x000fe20007ffe0ffULL, 0x00005e0002027625ULL, 0x000fe200078e0039ULL,
0x0000001f003b7210ULL, 0x000fc40007ffe0ffULL, 0xfffffff844447812ULL, 0x000fe200078ee233ULL,
0x00005e001e1e7625ULL, 0x080fe200078e0039ULL, 0xfffffff846467812ULL, 0x000fe400078ee22fULL,
0x0ffffff82d367812ULL, 0x000fe200078ef804ULL, 0x00005e002c2c7625ULL, 0x000fe200078e0039ULL,
0x000150007b4b7811ULL, 0x000fc600078e68ffULL, 0x00005e002e2e7625ULL, 0x000fe200078e0039ULL,
0x0000004b3e417211ULL, 0x000fc600078e20ffULL, 0x00005e0030307625ULL, 0x000fc800078e0039ULL,
0x00005e0032327625ULL, 0x000fc800078e0039ULL, 0x00005e0034347625ULL, 0x000fc800078e0039ULL,
0x00005e0038387625ULL, 0x000fc800078e0039ULL, 0x000000103b027825ULL, 0x000fc800078e0002ULL,
0x000000103b1e7825ULL, 0x000fc800078e001eULL, 0x000000103b2c7825ULL, 0x000fc800078e002cULL,
0x000000103b2e7825ULL, 0x000fc800078e002eULL, 0x000000103b307825ULL, 0x000fc800078e0030ULL,
0x000000103b327825ULL, 0x000fc800078e0032ULL, 0x000000103b347825ULL, 0x000fc800078e0034ULL,
0x000000103b387825ULL, 0x000fc800078e0038ULL, 0x00000010363b7824ULL, 0x100fe400078e024bULL,
0x000000103a3d7824ULL, 0x100fe400078e024bULL, 0x000000103c3f7824ULL, 0x100fe200078e024bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000023b7faeULL, 0x0003e2000b901c46ULL,
0x0000001040457824ULL, 0x100fe400078e024bULL, 0x0000001042477824ULL, 0x100fe200078e024bULL,
0x000000001e3d7faeULL, 0x0003e2000b901c46ULL, 0x0000001044497824ULL, 0x000fe200078e024bULL,
0x0000004b464b7211ULL, 0x000fc400078e20ffULL, 0x000000002c3f7faeULL, 0x0003e8000b901c46ULL,
0x000000002e417faeULL, 0x0003e8000b901c46ULL, 0x0000000030457faeULL, 0x0003e8000b901c46ULL,
0x0000000032477faeULL, 0x0003e8000b901c46ULL, 0x0000000034497faeULL, 0x0003e8000b901c46ULL,
0x00000000384b7faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01c60800002c7f8cULL, 0x0022a4000c80043fULL,
0x0000000000027805ULL, 0x000fc40000015200ULL, 0x01c60c00001f7984ULL, 0x000ee40000000800ULL,
0x800000001fff7812ULL, 0x00cfc4000780482dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff2e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000001e7805ULL, 0x000fcc0000015200ULL,
0x0000001e022f7210ULL, 0x000fca0007f1e1ffULL, 0x000000011f1f7824ULL, 0x000fe200000e0e03ULL,
0x003d09002f00780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402f00780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1e7819ULL, 0x000fc8000001141fULL, 0x0000002f1e1e7211ULL, 0x000fca00078110ffULL,
0x000000ffff1f7224ULL, 0x000fca00000e061fULL, 0x000000021e1e7819ULL, 0x000fc8000000121fULL,
0x0000001e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012e2e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01c60c00001f7984ULL, 0x000ea40000000800ULL, 0x800000001fff7812ULL, 0x004fe4000780482dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000404367819ULL, 0x000fe400000006ffULL,
0x00000001ff027819ULL, 0x000fe40000011604ULL, 0x0000007036367812ULL, 0x000fe400078ec0ffULL,
0x0000000c02037812ULL, 0x000fca00078ec0ffULL, 0x0000000136367824ULL, 0x000fca00078e0203ULL,
0x01c00000361e7984ULL, 0x000ea80000000800ULL, 0x01c20000362c7984ULL, 0x0006620000000800ULL,
0x000000431e00720bULL, 0x004fe20003f1d000ULL, 0x000145527f007947ULL, 0x000fd8000b800000ULL,
0x0000000000027806ULL, 0x008fc800000e0100ULL, 0x0000ffff022e7812ULL, 0x000fe2000784c0ffULL,
0x0000045000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe40003f0e170ULL,
0x0000004300487202ULL, 0x000fd20000000f00ULL, 0x000004100000a947ULL, 0x000fea0003800000ULL,
0x000000ff7b00720cULL, 0x000fe40003f45270ULL, 0x000000431e00720bULL, 0x000fe20003f74000ULL,
0x000145227f007947ULL, 0x000fd8000b800000ULL, 0x00000000001f7806ULL, 0x000fc400018e0100ULL,
0x0000001e43487209ULL, 0x000fe20007810000ULL, 0x0000035000017945ULL, 0x000fe20003800000ULL,
0x000099101f027816ULL, 0x000fc600000000ffULL, 0x01c400483600a388ULL, 0x0005e20000000800ULL,
0x000000ff0200720cULL, 0x000fda0003f45270ULL, 0x000003000000a947ULL, 0x000fea0003800000ULL,
0x8000004843027221ULL, 0x004fe20000010000ULL, 0x000000ff1fff7812ULL, 0x000fe2000784c0ffULL,
0x0000017000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b02027820ULL, 0x000fc80000410000ULL,
0x00000002002d7308ULL, 0x0004ec0000000800ULL, 0x000001300000a947ULL, 0x000fea0003800000ULL,
0x00000002ff027819ULL, 0x004fe20000011604ULL, 0x000144927f007947ULL, 0x000fea000b800000ULL,
0x00001f022d027589ULL, 0x0084e400000e0000ULL, 0x0000000218187220ULL, 0x088fe40000410000ULL,
0x0000000219197220ULL, 0x080fe40000410000ULL, 0x0000000214147220ULL, 0x000fc40000410000ULL,
0x0000000215157220ULL, 0x080fe40000410000ULL, 0x0000000210107220ULL, 0x080fe40000410000ULL,
0x0000000211117220ULL, 0x080fe40000410000ULL, 0x000000020c0c7220ULL, 0x080fe40000410000ULL,
0x000000020d0d7220ULL, 0x080fe40000410000ULL, 0x0000000208087220ULL, 0x000fc40000410000ULL,
0x0000000209097220ULL, 0x080fe40000410000ULL, 0x0000000224247220ULL, 0x080fe40000410000ULL,
0x0000000225257220ULL, 0x080fe40000410000ULL, 0x0000000228287220ULL, 0x080fe40000410000ULL,
0x0000000229297220ULL, 0x080fe40000410000ULL, 0x0000000220207220ULL, 0x000fc40000410000ULL,
0x0000000221217220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff001fff7812ULL, 0x000fe2000784c0ffULL, 0x0000002d05057220ULL, 0x008fd80000410000ULL,
0x000001300000a947ULL, 0x000fea0003800000ULL, 0x0000000804027811ULL, 0x004fe200078ff0ffULL,
0x000143927f007947ULL, 0x000fea000b800000ULL, 0x00001f022d027589ULL, 0x0004e400000e0000ULL,
0x000000021a1a7220ULL, 0x088fe40000410000ULL, 0x000000021b1b7220ULL, 0x080fe40000410000ULL,
0x0000000216167220ULL, 0x080fe40000410000ULL, 0x0000000217177220ULL, 0x080fe40000410000ULL,
0x0000000212127220ULL, 0x080fe40000410000ULL, 0x0000000213137220ULL, 0x000fc40000410000ULL,
0x000000020e0e7220ULL, 0x080fe40000410000ULL, 0x000000020f0f7220ULL, 0x080fe40000410000ULL,
0x000000020a0a7220ULL, 0x080fe40000410000ULL, 0x000000020b0b7220ULL, 0x080fe40000410000ULL,
0x0000000226267220ULL, 0x080fe40000410000ULL, 0x0000000227277220ULL, 0x000fc40000410000ULL,
0x000000022a2a7220ULL, 0x080fe40000410000ULL, 0x000000022b2b7220ULL, 0x080fe40000410000ULL,
0x0000000222227220ULL, 0x080fe40000410000ULL, 0x0000000223237220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff2eff7812ULL, 0x000fda000784601fULL,
0x800000481e1e2221ULL, 0x000fe20000010000ULL, 0x000000000000281cULL, 0x000fc60003f0f070ULL,
0x3fb8aa3b1e1e2820ULL, 0x000fc80000410000ULL, 0x0000001e00072308ULL, 0x000ea40000000800ULL,
0x000000072c2c2220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000019000007945ULL, 0x000fe20003800000ULL,
0x000000052c057221ULL, 0x002fe20000010000ULL, 0x0000016000008947ULL, 0x000fea0003800000ULL,
0x00000007ff02723eULL, 0x000fe400000010ffULL, 0x00000002ff1f7819ULL, 0x000fe40000011604ULL,
0x00005410021e7816ULL, 0x000fe20000000002ULL, 0x000141f27f007947ULL, 0x000fea000b800000ULL,
0x00001f1f1e1c7589ULL, 0x0002a400000e0000ULL, 0x000000081f1d7810ULL, 0x000fe20007ffe0ffULL,
0x000142427f007947ULL, 0x000fea000b800000ULL, 0x00001f1d1e1d7589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000101f027810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4a7224ULL, 0x000fe200078e001eULL, 0x00002670004c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff4b7424ULL, 0x000fc400078e00ffULL, 0xffffffffff4d7424ULL, 0x000fc400078e00ffULL,
0x0001534000007944ULL, 0x00efea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000181f027810ULL, 0x000fe20007ffe0ffULL, 0x0000001fff4b7424ULL, 0x000fe200078e00ffULL,
0x0000001e004a7202ULL, 0x004fe20000000f00ULL, 0xffffffffff4d7424ULL, 0x000fe200078e00ffULL,
0x000026e0004c7802ULL, 0x000fc40000000f00ULL, 0x000152d000007944ULL, 0x00afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000007041f7812ULL, 0x042fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000804317812ULL, 0x000fe400078ec0ffULL,
0x000000081f037812ULL, 0x000fc800078ef804ULL, 0x0000000304307211ULL, 0x000fe200078fe0ffULL,
0x00000008032d7824ULL, 0x000fca00078e00ffULL, 0xfffffff82d387812ULL, 0x000fc800078ee230ULL,
0x00012000382c7811ULL, 0x000fca00078e20ffULL, 0x0000000731317812ULL, 0x000fe200078ef804ULL,
0x000000002c2c783bULL, 0x000e620000000200ULL, 0x00000002303d7810ULL, 0x000fe40007ffe0ffULL,
0x0000003104027211ULL, 0x000fe200078fe0ffULL, 0x0000000831337824ULL, 0x040fe200078e00ffULL,
0x0000000331397819ULL, 0x040fe200000006ffULL, 0x00000008313b7824ULL, 0x040fe200078e00ffULL,
0x00000002021e7810ULL, 0x048fe20007ffe0ffULL, 0x0000000831357824ULL, 0x000fe200078e00ffULL,
0x0000000402327810ULL, 0x000fc40007ffe0ffULL, 0xfffffff839397812ULL, 0x000fe400078ee202ULL,
0xfffffff833337812ULL, 0x000fe400078ee21eULL, 0x0000000602027810ULL, 0x000fe40007ffe0ffULL,
0x000140007b1e7811ULL, 0x000fe400078e68ffULL, 0xfffffff83b3b7812ULL, 0x000fe400078ee232ULL,
0xfffffff835357812ULL, 0x000fe200078ee202ULL, 0x0000001039397824ULL, 0x100fe200078e021eULL,
0x0000000303027819ULL, 0x000fe200000006ffULL, 0x00000010333a7824ULL, 0x100fe200078e021eULL,
0x0000001e353c7211ULL, 0x000fe200078e20ffULL, 0x000000103b3b7824ULL, 0x000fe200078e021eULL,
0x000000003960783bULL, 0x000ee20000004200ULL, 0x0000001031037812ULL, 0x000fc400078efcffULL,
0xfffffff8023d7812ULL, 0x000fe200078ee23dULL, 0x000000003a58783bULL, 0x000f220000004200ULL,
0x0000000304027211ULL, 0x000fe200078fe0ffULL, 0x0000000803337824ULL, 0x000fe200078e00ffULL,
0x000120003d447811ULL, 0x000fe200078e20ffULL, 0x000000003b5c783bULL, 0x000fe20000004200ULL,
0x0000000803327824ULL, 0x040fe200078e00ffULL, 0x0000000202437810ULL, 0x040fe20007ffe0ffULL,
0x0000000803347824ULL, 0x040fe200078e00ffULL, 0x000000003c50783bULL, 0x000fe20000004200ULL,
0x0000000402497810ULL, 0x040fe20007ffe0ffULL, 0x0000001c2c2c0231ULL, 0x086fe200003400ffULL,
0x0000000303407819ULL, 0x000fe200000006ffULL, 0x000000004444783bULL, 0x000e620000000200ULL,
0xfffffff833337812ULL, 0x000fe200078ee202ULL, 0x0000001c2e2e0231ULL, 0x000fe200003400ffULL,
0x0000000602357810ULL, 0x000fe20007ffe0ffULL, 0x0000001d2d2d0231ULL, 0x080fe200003400ffULL,
0xfffffff832437812ULL, 0x000fe200078ee243ULL, 0x00000010333e7824ULL, 0x100fe200078e021eULL,
0xfffffff834497812ULL, 0x000fe200078ee249ULL, 0x0000001d2f2f0231ULL, 0x000fe200003400ffULL,
0xfffffff840357812ULL, 0x000fe200078ee235ULL, 0x00000010433f7824ULL, 0x100fe200078e021eULL,
0x000000003e64783bULL, 0x000ea20000004200ULL, 0x0000001049407824ULL, 0x000fe200078e021eULL,
0x0000001e35417211ULL, 0x000fc400078e20ffULL, 0x000000003f68783bULL, 0x000ea20000004200ULL,
0x0000002037037810ULL, 0x000fc60007ffe0ffULL, 0x000000004054783bULL, 0x000ea80000004200ULL,
0x00000000414c783bULL, 0x000ea20000004200ULL, 0x000000622c14723cULL, 0x048f700000041814ULL,
0x000000582c10723cULL, 0x050f700000041810ULL, 0x0000005a2c0c723cULL, 0x000f62000004180cULL,
0x0000001c44440231ULL, 0x002fc400003400ffULL, 0x0000001c46460231ULL, 0x000fe400003400ffULL,
0x0000001d45450231ULL, 0x080fe400003400ffULL, 0x0000001d47470231ULL, 0x000fe200003400ffULL,
0x0000005c2c58723cULL, 0x040ff00000041808ULL, 0x0000005e2c24723cULL, 0x040f700000041824ULL,
0x000000602c18723cULL, 0x040f700000041818ULL, 0x000000502c5c723cULL, 0x040f700000041828ULL,
0x000000522c20723cULL, 0x000b6e0000041820ULL, 0x00006200062d7a24ULL, 0x020fe200078e0203ULL,
0x000000664408723cULL, 0x044b700000041814ULL, 0x000000684414723cULL, 0x040b700000041810ULL,
0x0000006a4410723cULL, 0x040b70000004180cULL, 0x000000564428723cULL, 0x040b700000041824ULL,
0x000000644418723cULL, 0x040b700000041818ULL, 0x00000054440c723cULL, 0x040b700000041858ULL,
0x0000004c4424723cULL, 0x040b70000004185cULL, 0x0000004e4444723cULL, 0x000b620000041820ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000059000009947ULL, 0x000fca0003800000ULL,
0x00000003ff2f7819ULL, 0x120fe20000011604ULL, 0x00000200ff4d7424ULL, 0x000fe200078e00ffULL,
0x000000037a027217ULL, 0x000fe20007800000ULL, 0x00000001004b7824ULL, 0x000fe200078e021fULL,
0x000000042f237810ULL, 0x040fe40007ffe0ffULL, 0x0000000c2f557810ULL, 0x040fe20007ffe0ffULL,
0x0000000102027824ULL, 0x000fe200078e0a03ULL, 0x000000082f4f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000123037824ULL, 0x100fe200078e0204ULL, 0x000000102f597810ULL, 0x000fe20007ffe0ffULL,
0x00000008232c7824ULL, 0x000fe200078e00ffULL, 0x000000044f207210ULL, 0x080fe20007ffe0ffULL,
0x0000000155217824ULL, 0x000fe200078e0204ULL, 0x0000000459227210ULL, 0x080fe20007ffe0ffULL,
0x00000008552e7824ULL, 0x000fe200078e00ffULL, 0xfffffff82c517812ULL, 0x000fe200078ee203ULL,
0x000000084f537824ULL, 0x000fe200078e00ffULL, 0x000000042f037210ULL, 0x000fe20007ffe0ffULL,
0x00000008595b7824ULL, 0x000fe200078e00ffULL, 0x00000020022c7817ULL, 0x000fe20003800000ULL,
0x000000012f027824ULL, 0x000fe200078e022dULL, 0xfffffff82e577812ULL, 0x000fe200078ee221ULL,
0x0000001051517824ULL, 0x000fe200078e021eULL, 0xfffffff853537812ULL, 0x000fe200078ee220ULL,
0x0000000123207824ULL, 0x000fe200078e022dULL, 0x0000000703217812ULL, 0x000fe200078ec0ffULL,
0x00005e0002027625ULL, 0x000fe200078e004dULL, 0xfffffff85b5b7812ULL, 0x000fc400078ee222ULL,
0x0000002c2f00720cULL, 0x080fe20003f46070ULL, 0x000000014f227824ULL, 0x000fe200078e022dULL,
0x0000002c2300720cULL, 0x080fe20003f66070ULL, 0x000000104b027825ULL, 0x000fe200078e0002ULL,
0x0000002c4f00720cULL, 0x000fe40003f86070ULL, 0x000000142f5d7810ULL, 0x000fe20007ffe0ffULL,
0x00005e0022227625ULL, 0x080fe200078e004dULL, 0x0ffffff8214f7812ULL, 0x000fe400078ef804ULL,
0x000000045d2e7210ULL, 0x000fe20007ffe0ffULL, 0x00005e0020207625ULL, 0x000fe200078e004dULL,
0x000000182f617810ULL, 0x000fc40007ffe0ffULL, 0x0000001e53537211ULL, 0x000fe200078e20ffULL,
0x000000085d5f7824ULL, 0x000fe200078e00ffULL, 0x0000001c2f2f7810ULL, 0x000fe20007ffe0ffULL,
0x000000104f4f7824ULL, 0x000fe200078e021eULL, 0x0000002c6100720cULL, 0x080fe20003fa6070ULL,
0x000000104b207825ULL, 0x000fe200078e0020ULL, 0xfffffff85f5f7812ULL, 0x000fe400078ee22eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000024f7faeULL, 0x0003e2000d101c46ULL,
0x000000104b227825ULL, 0x000fe200078e0022ULL, 0x0000002c5500720cULL, 0x000fc40003f46070ULL,
0x0000000020517faeULL, 0x0005e2000d901c46ULL, 0x00000001612e7824ULL, 0x000fe200078e0204ULL,
0x0000002c5900720cULL, 0x080fe20003f66070ULL, 0x0000000861637824ULL, 0x000fe200078e00ffULL,
0x0000000022537faeULL, 0x0007e2000e101c46ULL, 0x0000002c5d00720cULL, 0x080fe20003f86070ULL,
0x0000001057577824ULL, 0x000fe200078e021eULL, 0x0000002c2f00720cULL, 0x000fe20003fc6070ULL,
0x0000000155027824ULL, 0x102fe200078e022dULL, 0xfffffff8634f7812ULL, 0x000fe200078ee22eULL,
0x00000001612c7824ULL, 0x100fe200078e022dULL, 0x000000042f327210ULL, 0x040fe20007ffe0ffULL,
0x000000012f2e7824ULL, 0x100fe200078e022dULL, 0x0000002d59207210ULL, 0x004fe20007ffe0ffULL,
0x000000082f517824ULL, 0x000fe200078e00ffULL, 0x0000001e5f5f7211ULL, 0x000fe200078e20ffULL,
0x000000015d227824ULL, 0x008fc400078e022dULL, 0x00005e0002027625ULL, 0x000fc800078e004dULL,
0x00005e0020207625ULL, 0x000fc800078e004dULL, 0x00005e0022227625ULL, 0x000fc800078e004dULL,
0x00005e002c2c7625ULL, 0x000fc800078e004dULL, 0x00005e002e2e7625ULL, 0x000fe200078e004dULL,
0xfffffff8514d7812ULL, 0x000fc600078ee232ULL, 0x000000104b027825ULL, 0x000fc800078e0002ULL,
0x000000104b207825ULL, 0x000fe200078e0020ULL, 0x0000000002577faeULL, 0x0003e6000d101c46ULL,
0x000000105b5b7824ULL, 0x000fe400078e021eULL, 0x000000104b227825ULL, 0x000fc600078e0022ULL,
0x00000000205b7faeULL, 0x0003e2000d901c46ULL, 0x000000104b2c7825ULL, 0x000fc600078e002cULL,
0x00000000225f7faeULL, 0x0003e2000e101c46ULL, 0x000000104f4f7824ULL, 0x000fe400078e021eULL,
0x000000104b2e7825ULL, 0x000fc600078e002eULL, 0x000000002c4f7faeULL, 0x0003e2000e901c46ULL,
0x000000104d4d7824ULL, 0x000fca00078e021eULL, 0x000000002e4d7faeULL, 0x0003e2000f101c46ULL,
0x000004c000007947ULL, 0x000fea0003800000ULL, 0x0000000804227811ULL, 0x020fe200078fe8ffULL,
0x0000000100517824ULL, 0x000fe200078e021fULL, 0x0000000c042c7811ULL, 0x040fe400078fe8ffULL,
0x0000000404207811ULL, 0x000fe200078fe8ffULL, 0x0000000122037824ULL, 0x100fe200078e0204ULL,
0x00000010042e7811ULL, 0x000fe200078fe8ffULL, 0x0000000822327824ULL, 0x000fe200078e00ffULL,
0x000000032c347819ULL, 0x040fe200000006ffULL, 0x000000012c217824ULL, 0x100fe200078e0204ULL,
0x0000000320557819ULL, 0x040fe200000006ffULL, 0x0000000120027824ULL, 0x100fe200078e0204ULL,
0xfffffff832577812ULL, 0x000fe200078ee203ULL, 0x000000012e237824ULL, 0x000fe200078e0204ULL,
0xfffffff834597812ULL, 0x000fe200078ee221ULL, 0x000000082e427824ULL, 0x000fe200078e00ffULL,
0x0000001404037811ULL, 0x000fe200078fe8ffULL, 0x0000000120207824ULL, 0x100fe200078e022dULL,
0x0000001c04347811ULL, 0x000fe200078fe8ffULL, 0x0000000122227824ULL, 0x100fe200078e022dULL,
0x00000018042f7811ULL, 0x000fe200078fe8ffULL, 0x000000012c2c7824ULL, 0x100fe200078e022dULL,
0x0000000404217211ULL, 0x080fe200078fe8ffULL, 0x00000001034a7824ULL, 0x100fe200078e022dULL,
0xfffffff855557812ULL, 0x000fe200078ee202ULL, 0x00000001344e7824ULL, 0x000fe200078e022dULL,
0xfffffff8425b7812ULL, 0x000fe200078ee223ULL, 0x0000000103237824ULL, 0x140fe200078e0204ULL,
0x0000002d04027211ULL, 0x080fe200078fe8ffULL, 0x0000000803427824ULL, 0x000fe200078e00ffULL,
0x00000200004f7802ULL, 0x000fe20000000f00ULL, 0x000000012f327824ULL, 0x040fe200078e0204ULL,
0x0000002d2e2e7210ULL, 0x080fe20007ffe0ffULL, 0x000000082f5f7824ULL, 0x040fe200078e00ffULL,
0x0000002d2f4c7210ULL, 0x000fe20007ffe0ffULL, 0x00005e0002027625ULL, 0x000fe200078e004fULL,
0x00000004342d7210ULL, 0x000fc40007ffe0ffULL, 0x0000000721217812ULL, 0x000fe200078ec0ffULL,
0x0000000834347824ULL, 0x000fe200078e00ffULL, 0xfffffff8425d7812ULL, 0x000fe200078ee223ULL,
0x00005e0022227625ULL, 0x080fe200078e004fULL, 0x0ffffff821537812ULL, 0x000fe400078ef804ULL,
0xfffffff834617812ULL, 0x000fe200078ee22dULL, 0x00005e0020207625ULL, 0x080fe200078e004fULL,
0xfffffff85f5f7812ULL, 0x000fe400078ee232ULL, 0x0000001e57577211ULL, 0x080fe200078e20ffULL,
0x00005e002c2c7625ULL, 0x000fe200078e004fULL, 0x0000001e5f5f7211ULL, 0x000fc600078e20ffULL,
0x00005e002e2e7625ULL, 0x000fc800078e004fULL, 0x00005e004a4a7625ULL, 0x000fc800078e004fULL,
0x0000001051027825ULL, 0x000fc800078e0002ULL, 0x00005e004c4c7625ULL, 0x000fc800078e004fULL,
0x0000001053537824ULL, 0x000fe400078e021eULL, 0x00005e004e4e7625ULL, 0x000fc600078e004fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002537faeULL, 0x0003e2000b901c46ULL,
0x0000001055557824ULL, 0x000fe400078e021eULL, 0x0000001051207825ULL, 0x000fc800078e0020ULL,
0x0000001051227825ULL, 0x040fe200078e0022ULL, 0x0000000020557faeULL, 0x0003e6000b901c46ULL,
0x00000010512c7825ULL, 0x000fe200078e002cULL, 0x0000000022577faeULL, 0x0003e6000b901c46ULL,
0x0000001059597824ULL, 0x000fe400078e021eULL, 0x00000010512e7825ULL, 0x000fc600078e002eULL,
0x000000002c597faeULL, 0x0003e2000b901c46ULL, 0x000000105b5b7824ULL, 0x000fe400078e021eULL,
0x00000010514a7825ULL, 0x000fc600078e004aULL, 0x000000002e5b7faeULL, 0x0003e2000b901c46ULL,
0x000000105d5d7824ULL, 0x000fe400078e021eULL, 0x00000010514c7825ULL, 0x000fc600078e004cULL,
0x000000004a5d7faeULL, 0x0003e2000b901c46ULL, 0x00000010514e7825ULL, 0x000fc600078e004eULL,
0x000000004c5f7faeULL, 0x0003e2000b901c46ULL, 0x0000001061617824ULL, 0x000fca00078e021eULL,
0x000000004e617faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000019000007945ULL, 0x000fe20003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000016000008947ULL, 0x000fea0003800000ULL, 0x00000007ff02723eULL, 0x002fe400000010ffULL,
0x00000002ff217819ULL, 0x000fe40000011604ULL, 0x0000541002207816ULL, 0x000fe20000000002ULL,
0x000131a27f007947ULL, 0x000fea000b800000ULL, 0x00001f21201c7589ULL, 0x0002a400000e0000ULL,
0x0000000821027810ULL, 0x000fe20007ffe0ffULL, 0x000131f27f007947ULL, 0x000fea000b800000ULL,
0x00001f02201d7589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001021027810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff4a7224ULL, 0x000fe200078e0020ULL,
0x0000001f004b7802ULL, 0x000fe20000000f00ULL, 0xffffffffff4d7424ULL, 0x000fe200078e00ffULL,
0x000037c0004c7802ULL, 0x000fc40000000f00ULL, 0x000141f000007944ULL, 0x006fea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001821027810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff4a7224ULL, 0x004fe200078e0020ULL, 0xffffffff004d7802ULL, 0x000fe20000000f00ULL,
0x0000001fff4b7424ULL, 0x000fe200078e00ffULL, 0x00003830004c7802ULL, 0x000fc40000000f00ULL,
0x0001418000007944ULL, 0x002fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000081f027812ULL, 0x00afe200078ef804ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000004302c7810ULL, 0x000fc60007ffe0ffULL, 0x0000000802037824ULL, 0x000fca00078e00ffULL,
0xfffffff8032c7812ULL, 0x000fe400078ee22cULL, 0x0000000804037812ULL, 0x000fe400078ec0ffULL,
0x000120002c507811ULL, 0x000fc400078e20ffULL, 0x0000000703207812ULL, 0x000fe200078ef804ULL,
0x0000000831237824ULL, 0x040fe200078e00ffULL, 0x0000003104037211ULL, 0x000fe200078fe0ffULL,
0x00000008312e7824ULL, 0x040fe200078e00ffULL, 0x0000000331317819ULL, 0x000fe200000006ffULL,
0x0000000820327824ULL, 0x000fe200078e00ffULL, 0x0000000603207810ULL, 0x040fe20007ffe0ffULL,
0x000000005050783bULL, 0x000e620000000200ULL, 0x0000000203227810ULL, 0x000fc40007ffe0ffULL,
0x0000000403217810ULL, 0x000fe40007ffe0ffULL, 0xfffffff8322d7812ULL, 0x000fe400078ee203ULL,
0x000010001e427810ULL, 0x000fe40007ffe0ffULL, 0xfffffff823037812ULL, 0x000fe400078ee220ULL,
0xfffffff831237812ULL, 0x000fe200078ee222ULL, 0x000000102d2d7824ULL, 0x100fe200078e0242ULL,
0xfffffff82e217812ULL, 0x000fe200078ee221ULL, 0x0000001033327824ULL, 0x100fe200078e0242ULL,
0x0000000630317810ULL, 0x000fe20007ffe0ffULL, 0x00000010232e7824ULL, 0x100fe200078e0242ULL,
0x000000002d6c783bULL, 0x000ee20000004200ULL, 0x00000010212f7824ULL, 0x100fe200078e0242ULL,
0x0000000302027819ULL, 0x000fe200000006ffULL, 0x0000001003307824ULL, 0x100fe200078e0242ULL,
0x000000002e58783bULL, 0x000f220000004200ULL, 0x0000001049347824ULL, 0x100fe200078e0242ULL,
0xfffffff802317812ULL, 0x000fe200078ee231ULL, 0x0000001035357824ULL, 0x000fe200078e0242ULL,
0x000000002f54783bULL, 0x000fe20000004200ULL, 0x0000004243337211ULL, 0x000fc400078e20ffULL,
0x0001200031207811ULL, 0x000fe200078e20ffULL, 0x000000003060783bULL, 0x000fe80000004200ULL,
0x000000003268783bULL, 0x000fe80000004200ULL, 0x000000002020783bULL, 0x000ea40000000200ULL,
0x0000001c50500231ULL, 0x006fc400003400ffULL, 0x00000000345c783bULL, 0x000e620000004200ULL,
0x0000001c52520231ULL, 0x000fe400003400ffULL, 0x0000001d51510231ULL, 0x080fe200003400ffULL,
0x000000003364783bULL, 0x000ea20000004200ULL, 0x0000001d53530231ULL, 0x000fc600003400ffULL,
0x00000000354c783bULL, 0x000e680000004200ULL, 0x0000006c5018723cULL, 0x048ff00000041818ULL,
0x0000006e5008723cULL, 0x040f700000041808ULL, 0x00000058506c723cULL, 0x010fe20000041814ULL,
0x0000001c20200231ULL, 0x000fc400003400ffULL, 0x0000001c22220231ULL, 0x000fca00003400ffULL,
0x000000545070723cULL, 0x000fe2000004180cULL, 0x0000001d21210231ULL, 0x080fe400003400ffULL,
0x0000001d23230231ULL, 0x000fca00003400ffULL, 0x000000565028723cULL, 0x040f700000041828ULL,
0x0000005a5058723cULL, 0x040f700000041810ULL, 0x000000605054723cULL, 0x040f700000041824ULL,
0x000000625044723cULL, 0x000f700000041844ULL, 0x0000006a2014723cULL, 0x060b700000041808ULL,
0x0000005e2024723cULL, 0x042b700000041828ULL, 0x000000682018723cULL, 0x040b700000041818ULL,
0x000000642010723cULL, 0x044b70000004186cULL, 0x00000066200c723cULL, 0x040b700000041858ULL,
0x0000005c2008723cULL, 0x040b700000041870ULL, 0x0000004c2028723cULL, 0x040b700000041854ULL,
0x0000004e2020723cULL, 0x000b620000041844ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x0000002037037810ULL, 0x000fe20007ffe0ffULL, 0x01c68800ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff437224ULL, 0x000fc400078e0048ULL, 0x0000007a0300720cULL, 0x000fda0003f06070ULL,
0x00006f5000000947ULL, 0x000fea0003800000ULL, 0x0000004037037810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00006200064b7a24ULL, 0x000fe200078e0203ULL,
0x0000059000009947ULL, 0x000fea0003800000ULL, 0x00000003ff467819ULL, 0x020fe20000011604ULL,
0x0000000100517824ULL, 0x000fe200078e021fULL, 0x000000037a027217ULL, 0x000fe40007800000ULL,
0x00000004464a7810ULL, 0x000fe40007ffe0ffULL, 0x00000200004f7802ULL, 0x000fe20000000f00ULL,
0x0000000102027824ULL, 0x000fe200078e0a03ULL, 0x000000044a437210ULL, 0x040fe20007ffe0ffULL,
0x000000084a447824ULL, 0x000fe200078e00ffULL, 0x00000008464c7810ULL, 0x040fe20007ffe0ffULL,
0x0000000146037824ULL, 0x040fe200078e024bULL, 0x0000000c464e7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff844497812ULL, 0x000fe200078ee243ULL, 0x0000000146447824ULL, 0x100fe200078e0204ULL,
0x0000002002437817ULL, 0x000fe20003800000ULL, 0x00005e0003027625ULL, 0x000fe200078e004fULL,
0x0000001846527810ULL, 0x000fe40007ffe0ffULL, 0x0000000744457812ULL, 0x000fe200078ec0ffULL,
0x000000014a447824ULL, 0x000fe200078e024bULL, 0x000000434600720cULL, 0x080fe20003f06070ULL,
0x000000084c537824ULL, 0x000fe200078e00ffULL, 0x000000434a00720cULL, 0x000fe20003f46070ULL,
0x000000014e4d7824ULL, 0x100fe200078e0204ULL, 0x0ffffff845477812ULL, 0x000fe200078ef804ULL,
0x00005e0044447625ULL, 0x000fe200078e004fULL, 0x000000044c4a7210ULL, 0x000fc40007ffe0ffULL,
0x0000004247477211ULL, 0x000fe200078e20ffULL, 0x000000084e507824ULL, 0x000fe200078e00ffULL,
0xfffffff853537812ULL, 0x000fe200078ee24aULL, 0x0000001051027825ULL, 0x000fe200078e0002ULL,
0x0000001c46547810ULL, 0x040fe40007ffe0ffULL, 0x00000010464a7810ULL, 0x000fe20007ffe0ffULL,
0x0000001049497824ULL, 0x000fe200078e0242ULL, 0xfffffff850557812ULL, 0x000fe200078ee24dULL,
0x0000001051447825ULL, 0x000fe200078e0044ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002477faeULL, 0x0003e2000c101c46ULL, 0x0000001446507810ULL, 0x000fc40007ffe0ffULL,
0x000000434c00720cULL, 0x080fe20003f06070ULL, 0x0000000044497faeULL, 0x0005e2000d101c46ULL,
0x000000434e00720cULL, 0x080fe20003f46070ULL, 0x000000084a567824ULL, 0x000fe200078e00ffULL,
0x000000435200720cULL, 0x080fe40003fa6070ULL, 0x000000435400720cULL, 0x080fe40003fc6070ULL,
0x000000434a00720cULL, 0x000fe20003f66070ULL, 0x000000014c027824ULL, 0x102fe200078e024bULL,
0x0000004b4a467210ULL, 0x000fe20007ffe0ffULL, 0x00000001524c7824ULL, 0x100fe200078e024bULL,
0x000000435000720cULL, 0x000fe20003f86070ULL, 0x000000014e447824ULL, 0x104fe200078e024bULL,
0x0000000452457210ULL, 0x080fe20007ffe0ffULL, 0x00000001544e7824ULL, 0x000fe200078e024bULL,
0x0000000450437210ULL, 0x000fe20007ffe0ffULL, 0x0000000154477824ULL, 0x000fc400078e0204ULL,
0x000000014a037824ULL, 0x000fe400078e0204ULL, 0x0000000852527824ULL, 0x000fe400078e00ffULL,
0x0000000854547824ULL, 0x000fe200078e00ffULL, 0xfffffff856577812ULL, 0x000fe200078ee203ULL,
0x00000001504a7824ULL, 0x000fe200078e024bULL, 0xfffffff8525b7812ULL, 0x000fe200078ee245ULL,
0x0000000850507824ULL, 0x000fe200078e00ffULL, 0xfffffff8545d7812ULL, 0x000fe200078ee247ULL,
0x00005e0002027625ULL, 0x000fc600078e004fULL, 0xfffffff850597812ULL, 0x000fe200078ee243ULL,
0x00005e0044447625ULL, 0x000fe200078e004fULL, 0x0000004253437211ULL, 0x000fc600078e20ffULL,
0x00005e0046467625ULL, 0x000fc800078e004fULL, 0x00005e004a4a7625ULL, 0x000fc800078e004fULL,
0x00005e004c4c7625ULL, 0x000fc800078e004fULL, 0x00005e004e4e7625ULL, 0x000fc800078e004fULL,
0x0000001051027825ULL, 0x000fc800078e0002ULL, 0x0000001051447825ULL, 0x040fe200078e0044ULL,
0x0000000002437faeULL, 0x0003e6000c101c46ULL, 0x0000001051467825ULL, 0x000fc800078e0046ULL,
0x00000010514a7825ULL, 0x000fc800078e004aULL, 0x00000010514c7825ULL, 0x000fc800078e004cULL,
0x00000010514e7825ULL, 0x000fc800078e004eULL, 0x0000001055497824ULL, 0x100fe200078e0242ULL,
0x000000425b557211ULL, 0x000fe200078e20ffULL, 0x0000001057517824ULL, 0x100fe400078e0242ULL,
0x0000001059537824ULL, 0x100fe200078e0242ULL, 0x0000000044497faeULL, 0x0003e2000d101c46ULL,
0x000000105d577824ULL, 0x000fc600078e0242ULL, 0x0000000046517faeULL, 0x0003e8000d901c46ULL,
0x000000004a537faeULL, 0x0003e8000e101c46ULL, 0x000000004c557faeULL, 0x0003e8000e901c46ULL,
0x000000004e577faeULL, 0x0003e2000f101c46ULL, 0x000004c000007947ULL, 0x000fea0003800000ULL,
0x0000000804467811ULL, 0x060fe200078fe8ffULL, 0x00000200ff537424ULL, 0x000fe200078e00ffULL,
0x0000000c044a7811ULL, 0x000fe200078fe8ffULL, 0x0000000100577824ULL, 0x000fe200078e021fULL,
0x0000000404447811ULL, 0x000fe200078fe8ffULL, 0x00000008464e7824ULL, 0x000fe200078e00ffULL,
0x00000010044c7811ULL, 0x000fe200078fe8ffULL, 0x000000014a437824ULL, 0x100fe200078e0204ULL,
0x0000000446037210ULL, 0x080fe20007ffe0ffULL, 0x000000084a507824ULL, 0x000fe200078e00ffULL,
0x0000001804477811ULL, 0x000fe200078fe8ffULL, 0x0000000144027824ULL, 0x000fe200078e0204ULL,
0xfffffff84e557812ULL, 0x000fe200078ee203ULL, 0x0000000844497824ULL, 0x000fe200078e00ffULL,
0x000000044c457210ULL, 0x0c0fe20007ffe0ffULL, 0x000000084c527824ULL, 0x000fe200078e00ffULL,
0x0000001404037811ULL, 0x040fe200078fe8ffULL, 0x0000000847567824ULL, 0x040fe200078e00ffULL,
0x0000001c044f7811ULL, 0x000fe200078fe8ffULL, 0x0000000146467824ULL, 0x000fe200078e024bULL,
0xfffffff850597812ULL, 0x000fe200078ee243ULL, 0x0000000147507824ULL, 0x100fe200078e024bULL,
0x0000000404437211ULL, 0x080fe200078fe8ffULL, 0x0000000803547824ULL, 0x000fe200078e00ffULL,
0xfffffff849497812ULL, 0x000fe200078ee202ULL, 0x000000014a4a7824ULL, 0x000fe200078e024bULL,
0xfffffff8525b7812ULL, 0x000fe200078ee245ULL, 0x0000000103457824ULL, 0x100fe200078e0204ULL,
0x00000004474d7210ULL, 0x000fe20007ffe0ffULL, 0x000000014f477824ULL, 0x040fe200078e0204ULL,
0x0000004b04027211ULL, 0x080fe200078fe8ffULL, 0x000000014c4c7824ULL, 0x100fe200078e024bULL,
0x0000004b44447210ULL, 0x080fe20007ffe0ffULL, 0x000000014f527824ULL, 0x000fe200078e024bULL,
0x0000004b034e7210ULL, 0x000fe20007ffe0ffULL, 0x00005e0002027625ULL, 0x000fe200078e0053ULL,
0x000000034f587819ULL, 0x000fc400000006ffULL, 0x0000000743437812ULL, 0x000fe200078ec0ffULL,
0x00005e004a4a7625ULL, 0x080fe200078e0053ULL, 0xfffffff8545d7812ULL, 0x000fe400078ee245ULL,
0xfffffff8565f7812ULL, 0x000fe200078ee24dULL, 0x00005e0044447625ULL, 0x080fe200078e0053ULL,
0xfffffff858617812ULL, 0x000fe400078ee247ULL, 0x0ffffff843437812ULL, 0x000fe200078ef804ULL,
0x00005e0046467625ULL, 0x000fc800078e0053ULL, 0x00005e004c4c7625ULL, 0x000fc800078e0053ULL,
0x00005e004e4e7625ULL, 0x000fc800078e0053ULL, 0x00005e0050507625ULL, 0x000fc800078e0053ULL,
0x00005e0052527625ULL, 0x000fc800078e0053ULL, 0x0000001057027825ULL, 0x000fc800078e0002ULL,
0x0000001043437824ULL, 0x100fe400078e0242ULL, 0x0000001049497824ULL, 0x000fe400078e0242ULL,
0x0000001057447825ULL, 0x000fe200078e0044ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002437faeULL, 0x0003e6000b901c46ULL, 0x0000001055557824ULL, 0x000fe200078e0242ULL,
0x0000000044497faeULL, 0x0003e2000b901c46ULL, 0x0000001057467825ULL, 0x000fc800078e0046ULL,
0x00000010574a7825ULL, 0x040fe200078e004aULL, 0x0000000046557faeULL, 0x0003e6000b901c46ULL,
0x00000010574c7825ULL, 0x000fc800078e004cULL, 0x00000010574e7825ULL, 0x000fc800078e004eULL,
0x0000001057507825ULL, 0x000fc800078e0050ULL, 0x0000001057527825ULL, 0x000fe200078e0052ULL,
0x0000004259577211ULL, 0x000fc600078e20ffULL, 0x000000105b597824ULL, 0x100fe400078e0242ULL,
0x000000105d5b7824ULL, 0x100fe200078e0242ULL, 0x000000004a577faeULL, 0x0003e2000b901c46ULL,
0x000000105f5d7824ULL, 0x000fe200078e0242ULL, 0x00000042615f7211ULL, 0x000fe400078e20ffULL,
0x000000004c597faeULL, 0x0003e8000b901c46ULL, 0x000000004e5b7faeULL, 0x0003e8000b901c46ULL,
0x00000000505d7faeULL, 0x0003e8000b901c46ULL, 0x00000000525f7faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01c6280000467f8cULL, 0x0022a4000c80043fULL, 0x0000000000027805ULL, 0x000fc40000015200ULL,
0x01c62c0000437984ULL, 0x000ee40000000800ULL, 0x8000000043ff7812ULL, 0x00cfc40007804847ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff497224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000447805ULL, 0x000fcc0000015200ULL, 0x0000004402447210ULL, 0x000fca0007f1e1ffULL,
0x0000000145457824ULL, 0x000fe200000e0e03ULL, 0x003d09004400780cULL, 0x000fc80003f06070ULL,
0x000000ff4500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404400780cULL, 0x000fc80003f06070ULL, 0x000000ff4500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff437819ULL, 0x000fc80000011445ULL,
0x0000004443437211ULL, 0x000fca00078110ffULL, 0x000000ffff447224ULL, 0x000fca00000e0645ULL,
0x0000000243437819ULL, 0x000fc80000001244ULL, 0x000000430000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000149497810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01c62c0000437984ULL, 0x000ea40000000800ULL,
0x8000000043ff7812ULL, 0x004fe40007804847ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x01c0800036457984ULL, 0x000ea80000000800ULL, 0x01c2800036447984ULL, 0x0006620000000800ULL,
0x000000484500720bULL, 0x004fe20003f1d000ULL, 0x00011f227f007947ULL, 0x000fd8000b800000ULL,
0x0000000000467806ULL, 0x008fc800000e0100ULL, 0x0000ffff46ff7812ULL, 0x000fe2000784c0ffULL,
0x0000046000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff437224ULL, 0x000fd400078e0048ULL, 0x000004200000a947ULL, 0x000fea0003800000ULL,
0x000000017b00780cULL, 0x000fe40003f05270ULL, 0x000000484500720bULL, 0x000fe20003f54000ULL,
0x00011ef27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000437806ULL, 0x000fc400010e0100ULL,
0x0000004845038209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x0000991043027816ULL, 0x000fc600000000ffULL, 0x01c4800336008388ULL, 0x0005e20000000800ULL,
0x000000ff0200720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000004845037209ULL, 0x004fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff43ff7812ULL, 0x000fc6000780c0ffULL, 0x0000004803027221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b02027820ULL, 0x000fc80000410000ULL, 0x00000002004e7308ULL, 0x000ea40000000800ULL,
0x0000004e05057220ULL, 0x004fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff027819ULL, 0x000fe20000011604ULL, 0x00011e427f007947ULL, 0x000fea000b800000ULL,
0x00001f024e027589ULL, 0x0004e400000e0000ULL, 0x0000000218187220ULL, 0x088fe40000410000ULL,
0x0000000219197220ULL, 0x080fe40000410000ULL, 0x0000000214147220ULL, 0x080fe40000410000ULL,
0x0000000215157220ULL, 0x000fc40000410000ULL, 0x0000000210107220ULL, 0x080fe40000410000ULL,
0x0000000211117220ULL, 0x080fe40000410000ULL, 0x000000020c0c7220ULL, 0x080fe40000410000ULL,
0x000000020d0d7220ULL, 0x080fe40000410000ULL, 0x0000000208087220ULL, 0x080fe40000410000ULL,
0x0000000209097220ULL, 0x000fc40000410000ULL, 0x0000000224247220ULL, 0x080fe40000410000ULL,
0x0000000225257220ULL, 0x080fe40000410000ULL, 0x0000000228287220ULL, 0x080fe40000410000ULL,
0x0000000229297220ULL, 0x080fe40000410000ULL, 0x0000000220207220ULL, 0x080fe40000410000ULL,
0x0000000221217220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0043ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000804027811ULL, 0x000fe200078ff0ffULL, 0x00011d527f007947ULL, 0x000fea000b800000ULL,
0x00001f024e027589ULL, 0x0006a400000e0000ULL, 0x000000021a1a7220ULL, 0x084fe40000410000ULL,
0x000000021b1b7220ULL, 0x080fe40000410000ULL, 0x0000000216167220ULL, 0x080fe40000410000ULL,
0x0000000217177220ULL, 0x080fe40000410000ULL, 0x0000000212127220ULL, 0x080fe40000410000ULL,
0x0000000213137220ULL, 0x000fc40000410000ULL, 0x000000020e0e7220ULL, 0x080fe40000410000ULL,
0x000000020f0f7220ULL, 0x080fe40000410000ULL, 0x000000020a0a7220ULL, 0x080fe40000410000ULL,
0x000000020b0b7220ULL, 0x080fe40000410000ULL, 0x0000000226267220ULL, 0x080fe40000410000ULL,
0x0000000227277220ULL, 0x000fc40000410000ULL, 0x000000022a2a7220ULL, 0x080fe40000410000ULL,
0x000000022b2b7220ULL, 0x080fe40000410000ULL, 0x0000000222227220ULL, 0x080fe40000410000ULL,
0x0000000223237220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff43ff7812ULL, 0x000fe40007800846ULL, 0x0000004845437209ULL, 0x000fd60007810000ULL,
0x8000004345450221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b45450820ULL, 0x000fc80000410000ULL,
0x0000004500070308ULL, 0x000ea40000000800ULL, 0x0000000744440220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000019000007945ULL, 0x000fe20003800000ULL, 0x0000000544057221ULL, 0x002fe20000010000ULL,
0x0000016000008947ULL, 0x000fea0003800000ULL, 0x00000007ff02723eULL, 0x000fe400000010ffULL,
0x00000002ff457819ULL, 0x000fe40000011604ULL, 0x0000541002447816ULL, 0x000fe20000000002ULL,
0x00011bb27f007947ULL, 0x000fea000b800000ULL, 0x00001f45441c7589ULL, 0x0002a400000e0000ULL,
0x0000000845027810ULL, 0x000fe20007ffe0ffULL, 0x00011c027f007947ULL, 0x000fea000b800000ULL,
0x00001f02441d7589ULL, 0x0002e400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001045027810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff4a7224ULL, 0x000fe200078e0044ULL,
0xffffffff004d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff4b7424ULL, 0x000fe200078e00ffULL,
0x00005040004c7802ULL, 0x000fc40000000f00ULL, 0x0001297000007944ULL, 0x00cfea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001845027810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff4a7224ULL, 0x004fe200078e0044ULL, 0x000050b0004c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff4b7424ULL, 0x000fc400078e00ffULL, 0xffffffffff4d7424ULL, 0x000fc400078e00ffULL,
0x0001290000007944ULL, 0x008fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00012800385c7811ULL, 0x000fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000003b68783bULL, 0x000fe20000004200ULL, 0x000128003d447811ULL, 0x002fe400078e20ffULL,
0x0000006037037810ULL, 0x000fe20007ffe0ffULL, 0x000000005c5c783bULL, 0x000e680000000200ULL,
0x000000003960783bULL, 0x000fe80000004200ULL, 0x000000003a64783bULL, 0x000fe80000004200ULL,
0x000000003c54783bULL, 0x000fe80000004200ULL, 0x000000004444783bULL, 0x000f280000000200ULL,
0x00000000404c783bULL, 0x008ee80000004200ULL, 0x000000003e58783bULL, 0x000ea80000004200ULL,
0x000000004148783bULL, 0x004ea80000004200ULL, 0x000000003f50783bULL, 0x000ea20000004200ULL,
0x0000001c5c5c0231ULL, 0x002fc400003400ffULL, 0x0000001c5e5e0231ULL, 0x000fe400003400ffULL,
0x0000001d5d5d0231ULL, 0x080fe400003400ffULL, 0x0000001d5f5f0231ULL, 0x000fce00003400ffULL,
0x0000006a5c24723cULL, 0x000f620000041824ULL, 0x0000001c44440231ULL, 0x090fe400003400ffULL,
0x0000001c46460231ULL, 0x000fe400003400ffULL, 0x0000001d45450231ULL, 0x000fc600003400ffULL,
0x000000605c18723cULL, 0x000f620000041818ULL, 0x0000001d47470231ULL, 0x000fce00003400ffULL,
0x000000625c14723cULL, 0x040f700000041814ULL, 0x000000645c10723cULL, 0x040ff00000041810ULL,
0x000000545c28723cULL, 0x040f700000041828ULL, 0x000000665c64723cULL, 0x040f70000004180cULL,
0x000000685c60723cULL, 0x040f700000041808ULL, 0x000000565c54723cULL, 0x000f700000041820ULL,
0x0000004e4420723cULL, 0x068f700000041824ULL, 0x000000584408723cULL, 0x040f700000041818ULL,
0x0000005a440c723cULL, 0x040f700000041814ULL, 0x000000484424723cULL, 0x044b6e0000041828ULL,
0x0000620006497a24ULL, 0x020fe200078e0203ULL, 0x000000504410723cULL, 0x040b700000041810ULL,
0x000000524414723cULL, 0x040b700000041864ULL, 0x0000004c4418723cULL, 0x040b700000041860ULL,
0x0000004a4428723cULL, 0x000b620000041854ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000059000009947ULL, 0x000fca0003800000ULL, 0x00000003ff4b7819ULL, 0x120fe20000011604ULL,
0x00000200ff4f7424ULL, 0x000fe200078e00ffULL, 0x000000037a027217ULL, 0x000fe20007800000ULL,
0x00000001004d7824ULL, 0x000fe200078e021fULL, 0x000000044b477810ULL, 0x000fe40007ffe0ffULL,
0x0000000203027210ULL, 0x000fe40007ffe1ffULL, 0x0000000c4b577810ULL, 0x000fe20007ffe0ffULL,
0x0000000147037824ULL, 0x100fe200078e0204ULL, 0x000000084b517810ULL, 0x000fe20007ffe0ffULL,
0x0000000847487824ULL, 0x000fe200078e00ffULL, 0x000000104b5b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000157457824ULL, 0x100fe200078e0204ULL, 0x0000000351557819ULL, 0x000fe200000006ffULL,
0x00000008574a7824ULL, 0x000fe200078e00ffULL, 0xfffffff848537812ULL, 0x000fe200078ee203ULL,
0x0000000151447824ULL, 0x100fe200078e0204ULL, 0x000000035b5d7819ULL, 0x000fe200000006ffULL,
0x000000014b037824ULL, 0x100fe200078e0204ULL, 0x0000002002487817ULL, 0x000fe20003800000ULL,
0x000000015b467824ULL, 0x000fe200078e0204ULL, 0xfffffff84a597812ULL, 0x000fe200078ee245ULL,
0x0000001053537824ULL, 0x000fe200078e021eULL, 0x000000494b027210ULL, 0x000fc40007ffe0ffULL,
0xfffffff855557812ULL, 0x000fe200078ee244ULL, 0x0000000147447824ULL, 0x100fe200078e0249ULL,
0x0000000703457812ULL, 0x000fe200078ec0ffULL, 0x00005e0002027625ULL, 0x000fe200078e004fULL,
0xfffffff85d5d7812ULL, 0x000fe400078ee246ULL, 0x000000484b00720cULL, 0x080fe20003f46070ULL,
0x0000000151467824ULL, 0x000fe200078e0249ULL, 0x000000484700720cULL, 0x080fe20003f66070ULL,
0x000000104d027825ULL, 0x000fe200078e0002ULL, 0x000000485100720cULL, 0x000fc40003f86070ULL,
0x0ffffff845517812ULL, 0x100fe200078ef804ULL, 0x00005e0044447625ULL, 0x080fe200078e004fULL,
0x000000144b5f7810ULL, 0x040fe40007ffe0ffULL, 0x000000184b637810ULL, 0x000fe20007ffe0ffULL,
0x00005e0046467625ULL, 0x000fe200078e004fULL, 0x000000035f617819ULL, 0x000fe400000006ffULL,
0x0000001c4b4b7810ULL, 0x000fe20007ffe0ffULL, 0x000000015f4a7824ULL, 0x000fe200078e0204ULL,
0x000000486300720cULL, 0x080fe20003fa6070ULL, 0x0000001051517824ULL, 0x000fe200078e021eULL,
0x000000484b00720cULL, 0x000fe20003fc6070ULL, 0x000000104d447825ULL, 0x000fe200078e0044ULL,
0xfffffff861617812ULL, 0x000fc400078ee24aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002517faeULL, 0x0003e2000d101c46ULL, 0x0000001055557824ULL, 0x000fe200078e021eULL,
0x00000004634a7210ULL, 0x000fe20007ffe0ffULL, 0x000000104d467825ULL, 0x000fe200078e0046ULL,
0x0000000044537faeULL, 0x0005e2000d901c46ULL, 0x000000485700720cULL, 0x080fe40003f46070ULL,
0x0000000863657824ULL, 0x000fe200078e00ffULL, 0x0000000046557faeULL, 0x0007e2000e101c46ULL,
0x000000485b00720cULL, 0x080fe20003f66070ULL, 0x000000014b4c7824ULL, 0x000fe200078e0204ULL,
0x000000485f00720cULL, 0x000fe20003f86070ULL, 0x0000000157027824ULL, 0x102fe200078e0249ULL,
0xfffffff865517812ULL, 0x000fe200078ee24aULL, 0x0000000163487824ULL, 0x000fc400078e0249ULL,
0x000000015b447824ULL, 0x104fe200078e0249ULL, 0x000000034b537819ULL, 0x040fe200000006ffULL,
0x000000014b4a7824ULL, 0x000fe200078e0249ULL, 0x0000001e51517211ULL, 0x000fe200078e20ffULL,
0x00005e0002027625ULL, 0x000fe200078e004fULL, 0x000000495f467210ULL, 0x008fc60007ffe0ffULL,
0x00005e0044447625ULL, 0x000fc800078e004fULL, 0x00005e0046467625ULL, 0x000fc800078e004fULL,
0x00005e0048487625ULL, 0x000fc800078e004fULL, 0x00005e004a4a7625ULL, 0x000fe200078e004fULL,
0xfffffff8534f7812ULL, 0x000fc600078ee24cULL, 0x000000104d027825ULL, 0x000fc800078e0002ULL,
0x0000001059597824ULL, 0x000fe400078e021eULL, 0x000000104d447825ULL, 0x000fc600078e0044ULL,
0x0000000002597faeULL, 0x0003e2000d101c46ULL, 0x000000105d5d7824ULL, 0x000fe400078e021eULL,
0x000000104d467825ULL, 0x000fc600078e0046ULL, 0x00000000445d7faeULL, 0x0003e2000d901c46ULL,
0x0000001061617824ULL, 0x000fe400078e021eULL, 0x000000104d487825ULL, 0x000fc600078e0048ULL,
0x0000000046617faeULL, 0x0003e2000e101c46ULL, 0x000000104d4a7825ULL, 0x000fc600078e004aULL,
0x0000000048517faeULL, 0x0003e2000e901c46ULL, 0x000000104f4f7824ULL, 0x000fca00078e021eULL,
0x000000004a4f7faeULL, 0x0003e2000f101c46ULL, 0x000004c000007947ULL, 0x000fea0003800000ULL,
0x0000000804467811ULL, 0x060fe200078fe8ffULL, 0x00000200ff517424ULL, 0x000fe200078e00ffULL,
0x0000000c04487811ULL, 0x000fe200078fe8ffULL, 0x0000000100537824ULL, 0x000fe200078e021fULL,
0x0000000404447811ULL, 0x000fe200078fe8ffULL, 0x00000008464c7824ULL, 0x000fe200078e00ffULL,
0x00000010044a7811ULL, 0x000fe200078fe8ffULL, 0x0000000148457824ULL, 0x100fe200078e0204ULL,
0x0000000446037210ULL, 0x080fe20007ffe0ffULL, 0x00000008484e7824ULL, 0x000fe200078e00ffULL,
0x000000044a477210ULL, 0x080fe20007ffe0ffULL, 0x0000000144027824ULL, 0x000fe200078e0204ULL,
0xfffffff84c597812ULL, 0x000fe200078ee203ULL, 0x0000000844577824ULL, 0x000fe200078e00ffULL,
0xfffffff84e5b7812ULL, 0x000fe200078ee245ULL, 0x000000084a507824ULL, 0x000fe200078e00ffULL,
0x0000001404037811ULL, 0x000fe200078fe8ffULL, 0x0000000146467824ULL, 0x100fe200078e0249ULL,
0x00000018044b7811ULL, 0x000fe200078fe8ffULL, 0x0000000148487824ULL, 0x100fe200078e0249ULL,
0x0000001c044f7811ULL, 0x000fe200078fe8ffULL, 0x000000014a4a7824ULL, 0x100fe200078e0249ULL,
0x0000000404457211ULL, 0x000fe200078fe8ffULL, 0x0000000803527824ULL, 0x000fe200078e00ffULL,
0xfffffff857577812ULL, 0x000fe200078ee202ULL, 0x000000014b4e7824ULL, 0x000fe200078e0249ULL,
0xfffffff8505d7812ULL, 0x000fe200078ee247ULL, 0x0000000103477824ULL, 0x100fe200078e0204ULL,
0x0000004904027211ULL, 0x080fe200078fe8ffULL, 0x000000014f507824ULL, 0x000fe200078e0249ULL,
0x0000004944447210ULL, 0x080fe20007ffe0ffULL, 0x000000084b547824ULL, 0x000fe200078e00ffULL,
0x00000049034c7210ULL, 0x000fe20007ffe0ffULL, 0x000000014f497824ULL, 0x000fe200078e0204ULL,
0x0000000745457812ULL, 0x000fe200078ec0ffULL, 0x00005e0002027625ULL, 0x000fe200078e0051ULL,
0x000000034f567819ULL, 0x000fc400000006ffULL, 0x000000044b4d7210ULL, 0x000fe20007ffe0ffULL,
0x00005e004a4a7625ULL, 0x080fe200078e0051ULL, 0x0ffffff845557812ULL, 0x000fe400078ef804ULL,
0xfffffff8525f7812ULL, 0x000fe200078ee247ULL, 0x00005e0044447625ULL, 0x080fe200078e0051ULL,
0xfffffff856637812ULL, 0x000fe400078ee249ULL, 0xfffffff854617812ULL, 0x000fe200078ee24dULL,
0x00005e0046467625ULL, 0x000fe200078e0051ULL, 0x0000001e5b5b7211ULL, 0x000fc400078e20ffULL,
0x0000001e63637211ULL, 0x000fe200078e20ffULL, 0x00005e0048487625ULL, 0x000fc800078e0051ULL,
0x00005e004c4c7625ULL, 0x000fc800078e0051ULL, 0x0000001053027825ULL, 0x000fc800078e0002ULL,
0x00005e004e4e7625ULL, 0x000fc800078e0051ULL, 0x0000001055557824ULL, 0x000fe400078e021eULL,
0x00005e0050507625ULL, 0x000fc600078e0051ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002557faeULL, 0x0003e2000b901c46ULL, 0x0000001057577824ULL, 0x000fe400078e021eULL,
0x0000001053447825ULL, 0x000fc800078e0044ULL, 0x0000001059597824ULL, 0x000fe200078e021eULL,
0x0000000044577faeULL, 0x0003e2000b901c46ULL, 0x0000001053467825ULL, 0x000fc800078e0046ULL,
0x0000001053487825ULL, 0x040fe200078e0048ULL, 0x0000000046597faeULL, 0x0003e6000b901c46ULL,
0x00000010534a7825ULL, 0x000fe200078e004aULL, 0x00000000485b7faeULL, 0x0003e6000b901c46ULL,
0x000000105d5d7824ULL, 0x000fe400078e021eULL, 0x00000010534c7825ULL, 0x000fc600078e004cULL,
0x000000004a5d7faeULL, 0x0003e2000b901c46ULL, 0x000000105f5f7824ULL, 0x000fe400078e021eULL,
0x00000010534e7825ULL, 0x000fc600078e004eULL, 0x000000004c5f7faeULL, 0x0003e2000b901c46ULL,
0x0000001061617824ULL, 0x000fe400078e021eULL, 0x0000001053507825ULL, 0x000fc600078e0050ULL,
0x000000004e617faeULL, 0x0003e8000b901c46ULL, 0x0000000050637faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000019000007945ULL, 0x000fe20003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000016000008947ULL, 0x000fea0003800000ULL,
0x00000007ff02723eULL, 0x002fe400000010ffULL, 0x00000002ff457819ULL, 0x000fe40000011604ULL,
0x0000541002447816ULL, 0x000fe20000000002ULL, 0x00010e127f007947ULL, 0x000fea000b800000ULL,
0x00001f45441c7589ULL, 0x0002a400000e0000ULL, 0x0000000845027810ULL, 0x000fe20007ffe0ffULL,
0x00010e627f007947ULL, 0x000fea000b800000ULL, 0x00001f02441d7589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001045027810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff4a7224ULL, 0x000fe200078e0044ULL, 0xffffffff004d7802ULL, 0x000fe20000000f00ULL,
0x0000001fff4b7424ULL, 0x000fe200078e00ffULL, 0x00005ed0004c7802ULL, 0x000fc40000000f00ULL,
0x00011ae000007944ULL, 0x006fea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001845027810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff4a7224ULL, 0x004fe200078e0044ULL,
0x00005f40004c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff4b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff4d7424ULL, 0x000fc400078e00ffULL, 0x00011a7000007944ULL, 0x002fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000128002c5c7811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000002d60783bULL, 0x002fe20000004200ULL,
0x0001280031447811ULL, 0x008fc600078e20ffULL, 0x000000005c5c783bULL, 0x000e680000000200ULL,
0x000000002f68783bULL, 0x000fe80000004200ULL, 0x000000002e64783bULL, 0x000fe80000004200ULL,
0x000000003054783bULL, 0x000fe80000004200ULL, 0x000000004444783bULL, 0x000ee80000000200ULL,
0x000000003258783bULL, 0x000f280000004200ULL, 0x00000000344c783bULL, 0x000ea80000004200ULL,
0x000000003350783bULL, 0x000ea80000004200ULL, 0x000000003548783bULL, 0x004ea20000004200ULL,
0x0000001c5c5c0231ULL, 0x002fc400003400ffULL, 0x0000001c5e5e0231ULL, 0x000fe400003400ffULL,
0x0000001d5d5d0231ULL, 0x080fe400003400ffULL, 0x0000001d5f5f0231ULL, 0x000fce00003400ffULL,
0x000000605c08723cULL, 0x000f620000041808ULL, 0x0000001c44440231ULL, 0x088fe400003400ffULL,
0x0000001c46460231ULL, 0x000fe400003400ffULL, 0x0000001d45450231ULL, 0x000fc600003400ffULL,
0x000000625c0c723cULL, 0x000f62000004180cULL, 0x0000001d47470231ULL, 0x000fce00003400ffULL,
0x000000685c60723cULL, 0x040ff00000041818ULL, 0x0000006a5c20723cULL, 0x040f700000041820ULL,
0x000000645c10723cULL, 0x040f700000041810ULL, 0x000000545c68723cULL, 0x040ff00000041824ULL,
0x000000665c64723cULL, 0x040f700000041814ULL, 0x000000565c54723cULL, 0x000f700000041828ULL,
0x000000584418723cULL, 0x070b700000041808ULL, 0x0000005a4414723cULL, 0x040b70000004180cULL,
0x0000004e4424723cULL, 0x040b700000041820ULL, 0x000000504410723cULL, 0x040b700000041810ULL,
0x00000052440c723cULL, 0x040b700000041864ULL, 0x0000004c4408723cULL, 0x040b700000041860ULL,
0x000000484428723cULL, 0x044b700000041868ULL, 0x0000004a4420723cULL, 0x000b620000041854ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x0000006037037810ULL, 0x000fe20007ffe0ffULL,
0x01c69000ffff7f8cULL, 0x000fe6000c80043fULL, 0x0000007a0300720cULL, 0x000fda0003f06070ULL,
0x00004a3000000947ULL, 0x000fea0003800000ULL, 0x0000008037037810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000620006477a24ULL, 0x020fe200078e0203ULL,
0x0000059000009947ULL, 0x000fea0003800000ULL, 0x00000003ff497819ULL, 0x000fe20000011604ULL,
0x00000001004f7824ULL, 0x000fe200078e021fULL, 0x000000037a027217ULL, 0x000fe40007800000ULL,
0x00000004494b7810ULL, 0x000fe40007ffe0ffULL, 0x00000200004d7802ULL, 0x000fe20000000f00ULL,
0x0000000102027824ULL, 0x000fe200078e0a03ULL, 0x000000044b447210ULL, 0x040fe20007ffe0ffULL,
0x000000084b517824ULL, 0x000fe200078e00ffULL, 0x0000000849537810ULL, 0x040fe20007ffe0ffULL,
0x0000000149037824ULL, 0x000fe200078e0247ULL, 0x0000002002467817ULL, 0x000fc40003800000ULL,
0xfffffff851517812ULL, 0x000fe200078ee244ULL, 0x0000000149447824ULL, 0x040fe200078e0204ULL,
0x000000464900720cULL, 0x080fe20003f06070ULL, 0x00005e0003027625ULL, 0x000fe200078e004dULL,
0x000000464b00720cULL, 0x040fe40003f46070ULL, 0x0000000744457812ULL, 0x000fe200078ec0ffULL,
0x000000014b447824ULL, 0x000fe200078e0247ULL, 0x0000000c49577810ULL, 0x000fe20007ffe0ffULL,
0x000000104f027825ULL, 0x000fe200078e0002ULL, 0x0ffffff8454b7812ULL, 0x000fc400078ef804ULL,
0x00000010495b7810ULL, 0x000fe20007ffe0ffULL, 0x00005e0044447625ULL, 0x000fe200078e004dULL,
0x000000424b4b7211ULL, 0x000fe400078e20ffULL, 0x00000014495d7810ULL, 0x000fe20007ffe0ffULL,
0x0000001051517824ULL, 0x000fe200078e0242ULL, 0x00000018495f7810ULL, 0x000fe20007ffe0ffULL,
0x000000104f447825ULL, 0x000fe200078e0044ULL, 0x0000000453487210ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000024b7faeULL, 0x0003e2000c101c46ULL,
0x0000001c49497810ULL, 0x000fe20007ffe0ffULL, 0x0000000853557824ULL, 0x040fe200078e00ffULL,
0x000000465300720cULL, 0x080fe20003f06070ULL, 0x00000001574a7824ULL, 0x040fe200078e0204ULL,
0x0000000044517faeULL, 0x0005e2000d101c46ULL, 0x0000000857597824ULL, 0x000fe200078e00ffULL,
0xfffffff855557812ULL, 0x000fe200078ee248ULL, 0x000000085b4e7824ULL, 0x000fe200078e00ffULL,
0x000000465700720cULL, 0x080fe20003f46070ULL, 0x000000085d507824ULL, 0x000fe200078e00ffULL,
0xfffffff859597812ULL, 0x000fe200078ee24aULL, 0x000000015b037824ULL, 0x142fe200078e0204ULL,
0x000000465b00720cULL, 0x080fe20003f66070ULL, 0x0000000153027824ULL, 0x100fe200078e0247ULL,
0x000000465d00720cULL, 0x0c0fe20003f86070ULL, 0x000000015d487824ULL, 0x100fe200078e0247ULL,
0x000000465f00720cULL, 0x080fe20003fa6070ULL, 0x0000000157447824ULL, 0x104fe200078e0247ULL,
0x000000464900720cULL, 0x000fe20003fc6070ULL, 0x000000015f4a7824ULL, 0x100fe200078e0247ULL,
0x000000475b467210ULL, 0x000fe20007ffe0ffULL, 0x00000001494c7824ULL, 0x000fe200078e0247ULL,
0x000000045d457210ULL, 0x080fe20007ffe0ffULL, 0x000000085f527824ULL, 0x040fe200078e00ffULL,
0x000000045f477210ULL, 0x000fe20007ffe0ffULL, 0x00000001494b7824ULL, 0x040fe200078e0204ULL,
0xfffffff84e517812ULL, 0x000fe200078ee203ULL, 0x0000000849547824ULL, 0x000fe200078e00ffULL,
0xfffffff850537812ULL, 0x000fe200078ee245ULL, 0x00005e0002027625ULL, 0x000fe200078e004dULL,
0xfffffff852577812ULL, 0x000fc400078ee247ULL, 0xfffffff8545b7812ULL, 0x000fe200078ee24bULL,
0x00005e0044447625ULL, 0x080fe200078e004dULL, 0x0000004255557211ULL, 0x080fe400078e20ffULL,
0x0000004257577211ULL, 0x000fe200078e20ffULL, 0x00005e0046467625ULL, 0x000fc800078e004dULL,
0x00005e0048487625ULL, 0x000fc800078e004dULL, 0x00005e004a4a7625ULL, 0x000fc800078e004dULL,
0x00005e004c4c7625ULL, 0x000fc800078e004dULL, 0x000000104f027825ULL, 0x000fc800078e0002ULL,
0x000000104f447825ULL, 0x000fe200078e0044ULL, 0x0000000002557faeULL, 0x0003e6000c101c46ULL,
0x0000001059597824ULL, 0x000fe400078e0242ULL, 0x000000104f467825ULL, 0x000fc600078e0046ULL,
0x0000000044597faeULL, 0x0003e2000d101c46ULL, 0x0000001051517824ULL, 0x000fe400078e0242ULL,
0x000000104f487825ULL, 0x000fc600078e0048ULL, 0x0000000046517faeULL, 0x0003e2000d901c46ULL,
0x0000001053537824ULL, 0x000fe400078e0242ULL, 0x000000104f4a7825ULL, 0x000fc600078e004aULL,
0x0000000048537faeULL, 0x0003e2000e101c46ULL, 0x000000104f4c7825ULL, 0x000fc600078e004cULL,
0x000000004a577faeULL, 0x0003e2000e901c46ULL, 0x000000105b5b7824ULL, 0x000fca00078e0242ULL,
0x000000004c5b7faeULL, 0x0003e2000f101c46ULL, 0x000004c000007947ULL, 0x000fea0003800000ULL,
0x0000000804467811ULL, 0x040fe200078fe8ffULL, 0x00000200ff517424ULL, 0x000fe200078e00ffULL,
0x0000000c04487811ULL, 0x000fe200078fe8ffULL, 0x0000000100537824ULL, 0x000fe200078e021fULL,
0x0000000404447811ULL, 0x000fe200078fe8ffULL, 0x00000008464c7824ULL, 0x000fe200078e00ffULL,
0x00000010044a7811ULL, 0x000fe200078fe8ffULL, 0x0000000148457824ULL, 0x100fe200078e0204ULL,
0x0000000446037210ULL, 0x080fe20007ffe0ffULL, 0x00000008484e7824ULL, 0x000fe200078e00ffULL,
0x000000044a497210ULL, 0x080fe20007ffe0ffULL, 0x0000000144027824ULL, 0x000fe200078e0204ULL,
0xfffffff84c597812ULL, 0x000fe200078ee203ULL, 0x0000000844577824ULL, 0x000fe200078e00ffULL,
0x00000018044b7811ULL, 0x000fe200078fe8ffULL, 0x000000084a507824ULL, 0x000fe200078e00ffULL,
0x0000001c044f7811ULL, 0x000fe200078fe8ffULL, 0x0000000146467824ULL, 0x000fe200078e0247ULL,
0xfffffff84e5b7812ULL, 0x000fe200078ee245ULL, 0x0000000148487824ULL, 0x100fe200078e0247ULL,
0x0000001404037811ULL, 0x000fe200078fe8ffULL, 0x000000014a4a7824ULL, 0x100fe200078e0247ULL,
0x0000000404457211ULL, 0x000fe200078fe8ffULL, 0x000000014b4e7824ULL, 0x000fe200078e0247ULL,
0xfffffff857577812ULL, 0x000fe200078ee202ULL, 0x0000000803527824ULL, 0x000fe200078e00ffULL,
0xfffffff8505d7812ULL, 0x000fe200078ee249ULL, 0x000000014f507824ULL, 0x000fe200078e0247ULL,
0x0000004704027211ULL, 0x080fe200078fe8ffULL, 0x0000000103497824ULL, 0x100fe200078e0204ULL,
0x0000004744447210ULL, 0x080fe20007ffe0ffULL, 0x000000084b547824ULL, 0x000fe200078e00ffULL,
0x00000047034c7210ULL, 0x000fe20007ffe0ffULL, 0x000000014f477824ULL, 0x000fe200078e0204ULL,
0x0000000745457812ULL, 0x000fe200078ec0ffULL, 0x00005e0002027625ULL, 0x000fe200078e0051ULL,
0x000000034f567819ULL, 0x000fc400000006ffULL, 0x000000044b4d7210ULL, 0x000fe20007ffe0ffULL,
0x00005e004a4a7625ULL, 0x080fe200078e0051ULL, 0x0ffffff845557812ULL, 0x000fe400078ef804ULL,
0xfffffff856637812ULL, 0x000fe200078ee247ULL, 0x00005e0044447625ULL, 0x080fe200078e0051ULL,
0xfffffff8525f7812ULL, 0x000fe400078ee249ULL, 0xfffffff854617812ULL, 0x000fe200078ee24dULL,
0x00005e0046467625ULL, 0x000fe200078e0051ULL, 0x000000425b5b7211ULL, 0x000fc400078e20ffULL,
0x0000004263637211ULL, 0x000fe200078e20ffULL, 0x00005e0048487625ULL, 0x000fc800078e0051ULL,
0x00005e004c4c7625ULL, 0x000fc800078e0051ULL, 0x0000001053027825ULL, 0x000fc800078e0002ULL,
0x00005e004e4e7625ULL, 0x000fc800078e0051ULL, 0x0000001055557824ULL, 0x000fe400078e0242ULL,
0x00005e0050507625ULL, 0x000fc600078e0051ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002557faeULL, 0x0003e2000b901c46ULL, 0x0000001057577824ULL, 0x000fe400078e0242ULL,
0x0000001053447825ULL, 0x000fc800078e0044ULL, 0x0000001059597824ULL, 0x000fe200078e0242ULL,
0x0000000044577faeULL, 0x0003e2000b901c46ULL, 0x0000001053467825ULL, 0x000fc800078e0046ULL,
0x0000001053487825ULL, 0x040fe200078e0048ULL, 0x0000000046597faeULL, 0x0003e6000b901c46ULL,
0x00000010534a7825ULL, 0x000fe200078e004aULL, 0x00000000485b7faeULL, 0x0003e6000b901c46ULL,
0x000000105d5d7824ULL, 0x000fe400078e0242ULL, 0x00000010534c7825ULL, 0x000fc600078e004cULL,
0x000000004a5d7faeULL, 0x0003e2000b901c46ULL, 0x000000105f5f7824ULL, 0x000fe400078e0242ULL,
0x00000010534e7825ULL, 0x000fc600078e004eULL, 0x000000004c5f7faeULL, 0x0003e2000b901c46ULL,
0x0000001061617824ULL, 0x000fe400078e0242ULL, 0x0000001053507825ULL, 0x000fc600078e0050ULL,
0x000000004e617faeULL, 0x0003e8000b901c46ULL, 0x0000000050637faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01c6480000467f8cULL, 0x0022a4000c80043fULL, 0x0000000000027805ULL, 0x000fc40000015200ULL,
0x01c64c0000457984ULL, 0x000ee40000000800ULL, 0x8000000045ff7812ULL, 0x00cfe40007804847ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff487224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000447805ULL, 0x000fcc0000015200ULL, 0x0000004402497210ULL, 0x000fca0007f1e1ffULL,
0x0000000145457824ULL, 0x000fe200000e0e03ULL, 0x003d09004900780cULL, 0x000fc80003f06070ULL,
0x000000ff4500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404900780cULL, 0x000fc80003f06070ULL, 0x000000ff4500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff447819ULL, 0x000fc80000011445ULL,
0x0000004944447211ULL, 0x000fca00078110ffULL, 0x000000ffff457224ULL, 0x000fca00000e0645ULL,
0x0000000244447819ULL, 0x000fc80000001245ULL, 0x000000440000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000148487810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01c64c0000457984ULL, 0x000ea40000000800ULL,
0x8000000045ff7812ULL, 0x004fe40007804847ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x01c1000036447984ULL, 0x000ea80000000800ULL, 0x01c3000036467984ULL, 0x0006620000000800ULL,
0x000000434400720bULL, 0x004fe20003f1d000ULL, 0x0000fd827f007947ULL, 0x000fd8000b800000ULL,
0x0000000000457806ULL, 0x008fc800000e0100ULL, 0x0000ffff45ff7812ULL, 0x000fe2000784c0ffULL,
0x0000045000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fd60003f0e170ULL,
0x000004200000a947ULL, 0x000fea0003800000ULL, 0x000000027b00780cULL, 0x000fe40003f05270ULL,
0x000000434400720bULL, 0x000fe20003f54000ULL, 0x0000fd627f007947ULL, 0x000fd8000b800000ULL,
0x0000000000487806ULL, 0x000fc400010e0100ULL, 0x0000004443038209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x0000991048027816ULL, 0x000fc600000000ffULL,
0x01c5000336008388ULL, 0x0005e20000000800ULL, 0x000000ff0200720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000004443027209ULL, 0x004fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff48ff7812ULL, 0x000fc6000780c0ffULL,
0x8000000243027221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b02027820ULL, 0x000fc80000410000ULL,
0x00000002004e7308ULL, 0x000ea40000000800ULL, 0x0000004e05057220ULL, 0x004fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff027819ULL, 0x000fe20000011604ULL,
0x0000fcb27f007947ULL, 0x000fea000b800000ULL, 0x00001f024e027589ULL, 0x0004e400000e0000ULL,
0x0000000218187220ULL, 0x088fe40000410000ULL, 0x0000000219197220ULL, 0x080fe40000410000ULL,
0x0000000214147220ULL, 0x080fe40000410000ULL, 0x0000000215157220ULL, 0x000fc40000410000ULL,
0x0000000210107220ULL, 0x080fe40000410000ULL, 0x0000000211117220ULL, 0x080fe40000410000ULL,
0x000000020c0c7220ULL, 0x080fe40000410000ULL, 0x000000020d0d7220ULL, 0x080fe40000410000ULL,
0x0000000208087220ULL, 0x080fe40000410000ULL, 0x0000000209097220ULL, 0x000fc40000410000ULL,
0x0000000224247220ULL, 0x080fe40000410000ULL, 0x0000000225257220ULL, 0x080fe40000410000ULL,
0x0000000228287220ULL, 0x080fe40000410000ULL, 0x0000000229297220ULL, 0x080fe40000410000ULL,
0x0000000220207220ULL, 0x080fe40000410000ULL, 0x0000000221217220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0048ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000804027811ULL, 0x000fe200078ff0ffULL,
0x0000fbc27f007947ULL, 0x000fea000b800000ULL, 0x00001f024e027589ULL, 0x0006a400000e0000ULL,
0x000000021a1a7220ULL, 0x084fe40000410000ULL, 0x000000021b1b7220ULL, 0x080fe40000410000ULL,
0x0000000216167220ULL, 0x080fe40000410000ULL, 0x0000000217177220ULL, 0x080fe40000410000ULL,
0x0000000212127220ULL, 0x080fe40000410000ULL, 0x0000000213137220ULL, 0x000fc40000410000ULL,
0x000000020e0e7220ULL, 0x080fe40000410000ULL, 0x000000020f0f7220ULL, 0x080fe40000410000ULL,
0x000000020a0a7220ULL, 0x080fe40000410000ULL, 0x000000020b0b7220ULL, 0x080fe40000410000ULL,
0x0000000226267220ULL, 0x080fe40000410000ULL, 0x0000000227277220ULL, 0x000fc40000410000ULL,
0x000000022a2a7220ULL, 0x080fe40000410000ULL, 0x000000022b2b7220ULL, 0x080fe40000410000ULL,
0x0000000222227220ULL, 0x080fe40000410000ULL, 0x0000000223237220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff48ff7812ULL, 0x000fe40007800845ULL,
0x0000004443437209ULL, 0x000fd60007810000ULL, 0x8000004344440221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b44440820ULL, 0x000fc80000410000ULL, 0x0000004400070308ULL, 0x000ea40000000800ULL,
0x0000000746460220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000019000007945ULL, 0x000fe20003800000ULL,
0x0000000546057221ULL, 0x002fe20000010000ULL, 0x0000016000008947ULL, 0x000fea0003800000ULL,
0x00000007ff02723eULL, 0x000fe400000010ffULL, 0x00000002ff457819ULL, 0x000fe40000011604ULL,
0x0000541002447816ULL, 0x000fe20000000002ULL, 0x0000fa227f007947ULL, 0x000fea000b800000ULL,
0x00001f45441c7589ULL, 0x0002a400000e0000ULL, 0x0000000845027810ULL, 0x000fe20007ffe0ffULL,
0x0000fa727f007947ULL, 0x000fea000b800000ULL, 0x00001f02441d7589ULL, 0x0002e400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001045027810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff4a7224ULL, 0x000fe200078e0044ULL, 0x00007550004c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff4b7424ULL, 0x000fc400078e00ffULL, 0xffffffffff4d7424ULL, 0x000fc400078e00ffULL,
0x0001046000007944ULL, 0x00cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001845027810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff4b7424ULL, 0x000fe200078e00ffULL,
0x00000044004a7202ULL, 0x004fe20000000f00ULL, 0xffffffffff4d7424ULL, 0x000fe200078e00ffULL,
0x000075c0004c7802ULL, 0x000fc40000000f00ULL, 0x000103f000007944ULL, 0x008fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00013000385c7811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000003b68783bULL, 0x000fe20000004200ULL,
0x000130003d447811ULL, 0x002fe400078e20ffULL, 0x000000a037037810ULL, 0x000fe20007ffe0ffULL,
0x000000005c5c783bULL, 0x000e680000000200ULL, 0x000000003960783bULL, 0x000fe80000004200ULL,
0x000000003a64783bULL, 0x000fe80000004200ULL, 0x000000003c54783bULL, 0x000fe80000004200ULL,
0x000000004444783bULL, 0x000f280000000200ULL, 0x00000000404c783bULL, 0x008ee80000004200ULL,
0x000000003e58783bULL, 0x000ea80000004200ULL, 0x000000004148783bULL, 0x004ea80000004200ULL,
0x000000003f50783bULL, 0x000ea20000004200ULL, 0x0000001c5c5c0231ULL, 0x002fc400003400ffULL,
0x0000001c5e5e0231ULL, 0x000fe400003400ffULL, 0x0000001d5d5d0231ULL, 0x080fe400003400ffULL,
0x0000001d5f5f0231ULL, 0x000fce00003400ffULL, 0x0000006a5c24723cULL, 0x000f620000041824ULL,
0x0000001c44440231ULL, 0x090fe400003400ffULL, 0x0000001c46460231ULL, 0x000fe400003400ffULL,
0x0000001d45450231ULL, 0x000fc600003400ffULL, 0x000000605c18723cULL, 0x000f620000041818ULL,
0x0000001d47470231ULL, 0x000fce00003400ffULL, 0x000000625c14723cULL, 0x040f700000041814ULL,
0x000000645c10723cULL, 0x040ff00000041810ULL, 0x000000545c28723cULL, 0x040f700000041828ULL,
0x000000665c64723cULL, 0x040f70000004180cULL, 0x000000685c60723cULL, 0x040f700000041808ULL,
0x000000565c54723cULL, 0x000f700000041820ULL, 0x0000004e4420723cULL, 0x068f700000041824ULL,
0x000000584408723cULL, 0x040f700000041818ULL, 0x0000005a440c723cULL, 0x040f700000041814ULL,
0x000000484424723cULL, 0x044b6e0000041828ULL, 0x0000620006497a24ULL, 0x020fe200078e0203ULL,
0x000000504410723cULL, 0x040b700000041810ULL, 0x000000524414723cULL, 0x040b700000041864ULL,
0x0000004c4418723cULL, 0x040b700000041860ULL, 0x0000004a4428723cULL, 0x000b620000041854ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000059000009947ULL, 0x000fca0003800000ULL,
0x00000003ff4b7819ULL, 0x120fe20000011604ULL, 0x00000200ff4f7424ULL, 0x000fe200078e00ffULL,
0x000000037a027217ULL, 0x000fe40007800000ULL, 0x000000044b477810ULL, 0x040fe40007ffe0ffULL,
0x000000084b517810ULL, 0x040fe20007ffe0ffULL, 0x0000000102027824ULL, 0x000fe200078e0a03ULL,
0x0000000c4b577810ULL, 0x000fe20007ffe0ffULL, 0x0000000847487824ULL, 0x040fe200078e00ffULL,
0x0000000447037210ULL, 0x080fe20007ffe0ffULL, 0x0000000151447824ULL, 0x100fe200078e0204ULL,
0x000000104b5b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000851557824ULL, 0x000fe200078e00ffULL,
0xfffffff848537812ULL, 0x000fe200078ee203ULL, 0x00000008574a7824ULL, 0x040fe200078e00ffULL,
0x0000000457457210ULL, 0x000fe20007ffe0ffULL, 0x000000014b037824ULL, 0x100fe200078e0204ULL,
0x0000002002487817ULL, 0x000fe20003800000ULL, 0x000000015b467824ULL, 0x000fe200078e0204ULL,
0xfffffff855557812ULL, 0x000fe200078ee244ULL, 0x000000085b5d7824ULL, 0x000fe200078e00ffULL,
0xfffffff84a597812ULL, 0x000fe200078ee245ULL, 0x000000014b027824ULL, 0x000fe200078e0249ULL,
0x0000000703457812ULL, 0x000fe200078ec0ffULL, 0x0000001053537824ULL, 0x000fe200078e021eULL,
0x0000004947447210ULL, 0x000fe20007ffe0ffULL, 0x00005e0002027625ULL, 0x000fe200078e004fULL,
0xfffffff85d5d7812ULL, 0x000fc400078ee246ULL, 0x000000484b00720cULL, 0x080fe20003f46070ULL,
0x0000000151467824ULL, 0x000fe200078e0249ULL, 0x000000484700720cULL, 0x080fe20003f66070ULL,
0x0000001055557824ULL, 0x000fe200078e021eULL, 0x000000485100720cULL, 0x000fe20003f86070ULL,
0x00005e0046467625ULL, 0x080fe200078e004fULL, 0x000000144b5f7810ULL, 0x000fe40007ffe0ffULL,
0x0ffffff845517812ULL, 0x000fe200078ef804ULL, 0x00005e0044447625ULL, 0x000fe200078e004fULL,
0x0000001f004d7210ULL, 0x000fc40007ffe0ffULL, 0x0000001e51517211ULL, 0x000fe200078e20ffULL,
0x000000015f4a7824ULL, 0x000fe200078e0204ULL, 0x000000184b637810ULL, 0x000fe20007ffe0ffULL,
0x000000085f617824ULL, 0x000fe200078e00ffULL, 0x0000001c4b4b7810ULL, 0x000fe20007ffe0ffULL,
0x000000104d027825ULL, 0x000fe200078e0002ULL, 0x0000000363657819ULL, 0x000fe400000006ffULL,
0xfffffff861617812ULL, 0x000fe200078ee24aULL, 0x000000104d447825ULL, 0x000fe200078e0044ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002517faeULL, 0x0003e2000d101c46ULL,
0x000000485700720cULL, 0x000fc40003f46070ULL, 0x000000104d467825ULL, 0x000fe200078e0046ULL,
0x0000000044537faeULL, 0x0005e2000d901c46ULL, 0x000000485b00720cULL, 0x080fe40003f66070ULL,
0x00000001634a7824ULL, 0x100fe200078e0204ULL, 0x0000000046557faeULL, 0x0007e2000e101c46ULL,
0x000000485f00720cULL, 0x080fe20003f86070ULL, 0x000000014b4c7824ULL, 0x000fe200078e0204ULL,
0x000000486300720cULL, 0x080fe20003fa6070ULL, 0x0000000157027824ULL, 0x102fe200078e0249ULL,
0x000000484b00720cULL, 0x000fe20003fc6070ULL, 0x000000105d5d7824ULL, 0x000fe200078e021eULL,
0x0000004963487210ULL, 0x000fe20007ffe0ffULL, 0x000000015b447824ULL, 0x104fe200078e0249ULL,
0xfffffff865517812ULL, 0x000fe200078ee24aULL, 0x000000014b4a7824ULL, 0x100fe200078e0249ULL,
0x0000001e59597211ULL, 0x000fe200078e20ffULL, 0x000000015f467824ULL, 0x008fc400078e0249ULL,
0x00005e0002027625ULL, 0x000fc800078e004fULL, 0x000000084b537824ULL, 0x000fe400078e00ffULL,
0x00005e0044447625ULL, 0x000fc800078e004fULL, 0x00005e0046467625ULL, 0x000fc800078e004fULL,
0x00005e0048487625ULL, 0x000fc800078e004fULL, 0x00005e004a4a7625ULL, 0x000fe200078e004fULL,
0xfffffff8534f7812ULL, 0x000fc600078ee24cULL, 0x000000104d027825ULL, 0x000fe200078e0002ULL,
0x0000001e4f4f7211ULL, 0x000fc600078e20ffULL, 0x000000104d447825ULL, 0x040fe200078e0044ULL,
0x0000000002597faeULL, 0x0003e6000d101c46ULL, 0x000000104d467825ULL, 0x000fe200078e0046ULL,
0x00000000445d7faeULL, 0x0003e6000d901c46ULL, 0x0000001061617824ULL, 0x000fe400078e021eULL,
0x000000104d487825ULL, 0x000fc600078e0048ULL, 0x0000000046617faeULL, 0x0003e2000e101c46ULL,
0x0000001051517824ULL, 0x000fe400078e021eULL, 0x000000104d4a7825ULL, 0x000fc600078e004aULL,
0x0000000048517faeULL, 0x0003e8000e901c46ULL, 0x000000004a4f7faeULL, 0x0003e2000f101c46ULL,
0x000004c000007947ULL, 0x000fea0003800000ULL, 0x0000000804467811ULL, 0x060fe200078fe8ffULL,
0x00000200ff517424ULL, 0x000fe200078e00ffULL, 0x0000000c04487811ULL, 0x000fe200078fe8ffULL,
0x0000000100537824ULL, 0x000fe200078e021fULL, 0x0000000404447811ULL, 0x000fe200078fe8ffULL,
0x0000000146037824ULL, 0x100fe200078e0204ULL, 0x00000010044a7811ULL, 0x000fe200078fe8ffULL,
0x0000000148457824ULL, 0x100fe200078e0204ULL, 0x00000003464c7819ULL, 0x000fe200000006ffULL,
0x00000008484e7824ULL, 0x000fe200078e00ffULL, 0x000000034a507819ULL, 0x000fe200000006ffULL,
0x0000000144027824ULL, 0x100fe200078e0204ULL, 0xfffffff84c597812ULL, 0x000fe200078ee203ULL,
0x0000000844577824ULL, 0x000fe200078e00ffULL, 0xfffffff84e5b7812ULL, 0x000fe200078ee245ULL,
0x000000014a477824ULL, 0x000fe200078e0204ULL, 0x0000001404037811ULL, 0x000fe200078fe8ffULL,
0x0000000144447824ULL, 0x100fe200078e0249ULL, 0x00000018044b7811ULL, 0x000fe200078fe8ffULL,
0x0000000148487824ULL, 0x100fe200078e0249ULL, 0x0000001c044f7811ULL, 0x000fe200078fe8ffULL,
0x000000014a4a7824ULL, 0x100fe200078e0249ULL, 0x0000000404457211ULL, 0x080fe200078fe8ffULL,
0x00000001034c7824ULL, 0x000fe200078e0249ULL, 0xfffffff857577812ULL, 0x000fe200078ee202ULL,
0x0000000803527824ULL, 0x000fe200078e00ffULL, 0xfffffff8505d7812ULL, 0x000fe200078ee247ULL,
0x000000014b4e7824ULL, 0x100fe200078e0249ULL, 0x0000004904027211ULL, 0x080fe200078fe8ffULL,
0x000000014f507824ULL, 0x040fe200078e0249ULL, 0x0000004946467210ULL, 0x000fe20007ffe0ffULL,
0x000000014f497824ULL, 0x100fe200078e0204ULL, 0x0000000745457812ULL, 0x000fe200078ec0ffULL,
0x000000084f567824ULL, 0x000fe200078e00ffULL, 0x0000000403477210ULL, 0x000fe20007ffe0ffULL,
0x000000014b4d7824ULL, 0x140fe200078e0204ULL, 0x000000034b547819ULL, 0x000fe200000006ffULL,
0x00005e0002027625ULL, 0x000fe200078e0051ULL, 0x0ffffff845557812ULL, 0x000fc400078ef804ULL,
0xfffffff8525f7812ULL, 0x000fe200078ee247ULL, 0x00005e0044447625ULL, 0x080fe200078e0051ULL,
0xfffffff856637812ULL, 0x000fe400078ee249ULL, 0xfffffff854617812ULL, 0x000fe200078ee24dULL,
0x00005e0046467625ULL, 0x080fe200078e0051ULL, 0x0000001e55557211ULL, 0x080fe400078e20ffULL,
0x0000001e5d5d7211ULL, 0x000fe200078e20ffULL, 0x00005e0048487625ULL, 0x000fc800078e0051ULL,
0x00005e004a4a7625ULL, 0x000fc800078e0051ULL, 0x00005e004c4c7625ULL, 0x000fc800078e0051ULL,
0x0000001053027825ULL, 0x000fc800078e0002ULL, 0x00005e004e4e7625ULL, 0x080fe200078e0051ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002557faeULL, 0x0003e6000b901c46ULL,
0x00005e0050507625ULL, 0x000fc800078e0051ULL, 0x0000001057577824ULL, 0x000fe400078e021eULL,
0x0000001053447825ULL, 0x000fc800078e0044ULL, 0x0000001059597824ULL, 0x000fe200078e021eULL,
0x0000000044577faeULL, 0x0003e2000b901c46ULL, 0x0000001053467825ULL, 0x000fc800078e0046ULL,
0x0000001053487825ULL, 0x000fe200078e0048ULL, 0x0000000046597faeULL, 0x0003e6000b901c46ULL,
0x000000105b5b7824ULL, 0x000fe400078e021eULL, 0x00000010534a7825ULL, 0x000fc600078e004aULL,
0x00000000485b7faeULL, 0x0003e2000b901c46ULL, 0x00000010534c7825ULL, 0x000fc600078e004cULL,
0x000000004a5d7faeULL, 0x0003e2000b901c46ULL, 0x000000105f5f7824ULL, 0x000fe400078e021eULL,
0x00000010534e7825ULL, 0x000fc600078e004eULL, 0x000000004c5f7faeULL, 0x0003e2000b901c46ULL,
0x0000001061617824ULL, 0x000fe400078e021eULL, 0x0000001053507825ULL, 0x000fc600078e0050ULL,
0x000000004e617faeULL, 0x0003e2000b901c46ULL, 0x0000001063637824ULL, 0x000fca00078e021eULL,
0x0000000050637faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000019000007945ULL, 0x000fe20003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000016000008947ULL, 0x000fea0003800000ULL, 0x00000007ff02723eULL, 0x002fe400000010ffULL,
0x00000002ff457819ULL, 0x000fe40000011604ULL, 0x0000541002447816ULL, 0x000fe20000000002ULL,
0x0000ec827f007947ULL, 0x000fea000b800000ULL, 0x00001f45441c7589ULL, 0x0002a400000e0000ULL,
0x0000000845027810ULL, 0x000fe20007ffe0ffULL, 0x0000ecd27f007947ULL, 0x000fea000b800000ULL,
0x00001f02441d7589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001045027810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff4a7224ULL, 0x000fe200078e0044ULL,
0x000083e0004c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff4b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff4d7424ULL, 0x000fc400078e00ffULL, 0x0000f5d000007944ULL, 0x006fea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001845027810ULL, 0x008fe20007ffe0ffULL,
0x0000001fff4b7424ULL, 0x000fe200078e00ffULL, 0x00000044004a7202ULL, 0x004fe20000000f00ULL,
0xffffffffff4d7424ULL, 0x000fe200078e00ffULL, 0x00008450004c7802ULL, 0x000fc40000000f00ULL,
0x0000f56000007944ULL, 0x002fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000130002c5c7811ULL, 0x000fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000002d60783bULL, 0x002fe20000004200ULL, 0x0001300031447811ULL, 0x008fc600078e20ffULL,
0x000000005c5c783bULL, 0x000e680000000200ULL, 0x000000002f68783bULL, 0x000fe80000004200ULL,
0x000000002e64783bULL, 0x000fe80000004200ULL, 0x000000003054783bULL, 0x000fe80000004200ULL,
0x000000004444783bULL, 0x000ee80000000200ULL, 0x000000003258783bULL, 0x000f280000004200ULL,
0x00000000344c783bULL, 0x000ea80000004200ULL, 0x000000003350783bULL, 0x000ea80000004200ULL,
0x000000003548783bULL, 0x004ea20000004200ULL, 0x0000001c5c5c0231ULL, 0x002fc400003400ffULL,
0x0000001c5e5e0231ULL, 0x000fe400003400ffULL, 0x0000001d5d5d0231ULL, 0x080fe400003400ffULL,
0x0000001d5f5f0231ULL, 0x000fce00003400ffULL, 0x000000605c08723cULL, 0x000f620000041808ULL,
0x0000001c44440231ULL, 0x088fe400003400ffULL, 0x0000001c46460231ULL, 0x000fe400003400ffULL,
0x0000001d45450231ULL, 0x000fc600003400ffULL, 0x000000625c0c723cULL, 0x000f62000004180cULL,
0x0000001d47470231ULL, 0x000fce00003400ffULL, 0x000000685c60723cULL, 0x040ff00000041818ULL,
0x0000006a5c20723cULL, 0x040f700000041820ULL, 0x000000645c10723cULL, 0x040f700000041810ULL,
0x000000545c68723cULL, 0x040ff00000041824ULL, 0x000000665c64723cULL, 0x040f700000041814ULL,
0x000000565c54723cULL, 0x000f700000041828ULL, 0x000000584418723cULL, 0x070b700000041808ULL,
0x0000005a4414723cULL, 0x040b70000004180cULL, 0x0000004e4424723cULL, 0x040b700000041820ULL,
0x000000504410723cULL, 0x040b700000041810ULL, 0x00000052440c723cULL, 0x040b700000041864ULL,
0x0000004c4408723cULL, 0x040b700000041860ULL, 0x000000484428723cULL, 0x044b700000041868ULL,
0x0000004a4420723cULL, 0x000b620000041854ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x000000a037037810ULL, 0x000fe20007ffe0ffULL, 0x01c69800ffff7f8cULL, 0x000fe6000c80043fULL,
0x0000007a0300720cULL, 0x000fda0003f06070ULL, 0x0000252000000947ULL, 0x000fea0003800000ULL,
0x000000c037377810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000620006457a24ULL, 0x020fe200078e0237ULL, 0x0000059000009947ULL, 0x000fea0003800000ULL,
0x000000377a027217ULL, 0x000fe20007800000ULL, 0x00000200ff4f7424ULL, 0x000fe200078e00ffULL,
0x00000003ff447819ULL, 0x100fe20000011604ULL, 0x0000000100517824ULL, 0x000fe200078e021fULL,
0x0000000237027210ULL, 0x000fe40007ffe1ffULL, 0x00000008444a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000144467824ULL, 0x100fe200078e0204ULL, 0x0000002002377817ULL, 0x000fe20003800000ULL,
0x0000000144037824ULL, 0x040fe200078e0245ULL, 0x0000000c444c7810ULL, 0x000fe20007ffe0ffULL,
0x000000014a497824ULL, 0x000fe200078e0204ULL, 0x0000000746477812ULL, 0x000fe200078ec0ffULL,
0x00005e0003027625ULL, 0x000fe200078e004fULL, 0x000000374400720cULL, 0x000fc40003f06070ULL,
0x0ffffff847477812ULL, 0x000fe200078ef804ULL, 0x000000084a4e7824ULL, 0x000fe200078e00ffULL,
0x0000000444487810ULL, 0x000fe20007ffe0ffULL, 0x000000084c507824ULL, 0x040fe200078e00ffULL,
0x000000044c4b7210ULL, 0x080fe20007ffe0ffULL, 0x0000001051027825ULL, 0x000fe200078e0002ULL,
0xfffffff84e557812ULL, 0x000fe400078ee249ULL, 0x0000000448467210ULL, 0x000fe20007ffe0ffULL,
0x0000001047477824ULL, 0x100fe200078e0242ULL, 0xfffffff850577812ULL, 0x000fe200078ee24bULL,
0x0000000848537824ULL, 0x000fe200078e00ffULL, 0x00000010444e7810ULL, 0x040fe20007ffe0ffULL,
0x0000001055557824ULL, 0x000fe200078e0242ULL, 0x0000001444507810ULL, 0x040fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002477faeULL, 0x0003e2000c101c46ULL,
0x0000001c44547810ULL, 0x000fc40007ffe0ffULL, 0x0000001844527810ULL, 0x000fe40007ffe0ffULL,
0xfffffff853537812ULL, 0x000fe200078ee246ULL, 0x000000014c467824ULL, 0x100fe200078e0245ULL,
0x000000374800720cULL, 0x080fe40003f06070ULL, 0x000000374a00720cULL, 0x080fe20003f26070ULL,
0x0000001053537824ULL, 0x000fe200078e0242ULL, 0x000000374c00720cULL, 0x080fe20003f46070ULL,
0x0000000148027824ULL, 0x102fe200078e0245ULL, 0x000000374e00720cULL, 0x040fe20003f66070ULL,
0x000000014e487824ULL, 0x100fe200078e0245ULL, 0x000000454a447210ULL, 0x080fe20007ffe0ffULL,
0x000000014e037824ULL, 0x140fe200078e0204ULL, 0x000000034e567819ULL, 0x000fe200000006ffULL,
0x00000001504a7824ULL, 0x100fe200078e0245ULL, 0x00000045524c7210ULL, 0x000fe20007ffe0ffULL,
0x00000001544e7824ULL, 0x000fe200078e0245ULL, 0x000000375200720cULL, 0x0c0fe20003fa6070ULL,
0x0000000152457824ULL, 0x100fe200078e0204ULL, 0x000000375000720cULL, 0x0c0fe20003f86070ULL,
0x0000000150477824ULL, 0x000fe200078e0204ULL, 0x000000375400720cULL, 0x000fe20003fc6070ULL,
0x0000000852527824ULL, 0x000fe200078e00ffULL, 0x0000000454497210ULL, 0x000fe20007ffe0ffULL,
0x0000000850507824ULL, 0x000fe200078e00ffULL, 0xfffffff856377812ULL, 0x000fe200078ee203ULL,
0x0000000854547824ULL, 0x000fe200078e00ffULL, 0xfffffff8525b7812ULL, 0x000fe200078ee245ULL,
0x00005e0002027625ULL, 0x000fe200078e004fULL, 0xfffffff850597812ULL, 0x000fc400078ee247ULL,
0xfffffff8545d7812ULL, 0x000fe200078ee249ULL, 0x00005e0044447625ULL, 0x080fe200078e004fULL,
0x0000004257577211ULL, 0x080fe400078e20ffULL, 0x000000425d5d7211ULL, 0x000fe200078e20ffULL,
0x00005e0046467625ULL, 0x000fc800078e004fULL, 0x00005e0048487625ULL, 0x000fc800078e004fULL,
0x00005e004a4a7625ULL, 0x000fc800078e004fULL, 0x00005e004c4c7625ULL, 0x000fc800078e004fULL,
0x00005e004e4e7625ULL, 0x000fc800078e004fULL, 0x0000001051027825ULL, 0x000fc800078e0002ULL,
0x0000001051447825ULL, 0x040fe200078e0044ULL, 0x0000000002537faeULL, 0x0003e6000c101c46ULL,
0x0000001051467825ULL, 0x040fe200078e0046ULL, 0x0000000044557faeULL, 0x0003e6000c901c46ULL,
0x0000001051487825ULL, 0x000fe200078e0048ULL, 0x0000000046577faeULL, 0x0003e6000d101c46ULL,
0x0000001037377824ULL, 0x000fc400078e0242ULL, 0x00000010514a7825ULL, 0x000fc600078e004aULL,
0x0000000048377faeULL, 0x0003e2000d901c46ULL, 0x0000001059597824ULL, 0x000fe400078e0242ULL,
0x00000010514c7825ULL, 0x000fc600078e004cULL, 0x000000004a597faeULL, 0x0003e2000e101c46ULL,
0x000000105b5b7824ULL, 0x000fe400078e0242ULL, 0x00000010514e7825ULL, 0x000fc600078e004eULL,
0x000000004c5b7faeULL, 0x0003e8000e901c46ULL, 0x000000004e5d7faeULL, 0x0003e2000f101c46ULL,
0x000004c000007947ULL, 0x000fea0003800000ULL, 0x0000000804467811ULL, 0x040fe200078fe8ffULL,
0x00000200ff517424ULL, 0x000fe200078e00ffULL, 0x00000010044a7811ULL, 0x040fe400078fe8ffULL,
0x0000000404447811ULL, 0x000fe200078fe8ffULL, 0x0000000146037824ULL, 0x100fe200078e0204ULL,
0x0000000c04487811ULL, 0x000fe200078fe8ffULL, 0x000000014a477824ULL, 0x100fe200078e0204ULL,
0x00000003464c7819ULL, 0x000fe200000006ffULL, 0x0000000144027824ULL, 0x100fe200078e0204ULL,
0x000000034a507819ULL, 0x000fe200000006ffULL, 0x0000000844557824ULL, 0x000fe200078e00ffULL,
0xfffffff84c577812ULL, 0x000fe200078ee203ULL, 0x0000000148377824ULL, 0x000fe200078e0204ULL,
0x0000001404037811ULL, 0x000fe200078fe8ffULL, 0x00000008484e7824ULL, 0x000fe200078e00ffULL,
0x00000018044b7811ULL, 0x000fe200078fe8ffULL, 0x0000000144447824ULL, 0x100fe200078e0245ULL,
0x0000001c044f7811ULL, 0x000fe200078fe8ffULL, 0x0000000148487824ULL, 0x000fe200078e0245ULL,
0xfffffff8505b7812ULL, 0x000fe200078ee247ULL, 0x000000014a4a7824ULL, 0x100fe200078e0245ULL,
0xfffffff855557812ULL, 0x000fe200078ee202ULL, 0x00000001034c7824ULL, 0x000fe200078e0245ULL,
0xfffffff84e597812ULL, 0x000fe200078ee237ULL, 0x000000014b4e7824ULL, 0x100fe200078e0245ULL,
0x0000000404477211ULL, 0x0c0fe200078fe8ffULL, 0x000000014f507824ULL, 0x040fe200078e0245ULL,
0x0000004504027211ULL, 0x080fe200078fe8ffULL, 0x000000084f567824ULL, 0x040fe200078e00ffULL,
0x0000004546467210ULL, 0x000fe20007ffe0ffULL, 0x000000014f457824ULL, 0x100fe200078e0204ULL,
0x0000000747477812ULL, 0x000fe200078ec0ffULL, 0x0000000803527824ULL, 0x040fe200078e00ffULL,
0x0000000403497210ULL, 0x000fe20007ffe0ffULL, 0x000000014b4d7824ULL, 0x040fe200078e0204ULL,
0x000000034b547819ULL, 0x000fe200000006ffULL, 0x00005e0002027625ULL, 0x000fe200078e0051ULL,
0xfffffff856617812ULL, 0x000fc400078ee245ULL, 0x0ffffff847537812ULL, 0x000fe200078ef804ULL,
0x00005e0044447625ULL, 0x080fe200078e0051ULL, 0xfffffff8525d7812ULL, 0x000fe400078ee249ULL,
0xfffffff8545f7812ULL, 0x000fe200078ee24dULL, 0x0000000100377824ULL, 0x000fe200078e021fULL,
0x0000004253537211ULL, 0x080fe200078e20ffULL, 0x00005e0046467625ULL, 0x000fe200078e0051ULL,
0x000000425b5b7211ULL, 0x000fc600078e20ffULL, 0x00005e0048487625ULL, 0x000fc800078e0051ULL,
0x00005e004a4a7625ULL, 0x000fc800078e0051ULL, 0x00005e004c4c7625ULL, 0x000fc800078e0051ULL,
0x0000001037027825ULL, 0x000fc800078e0002ULL, 0x00005e004e4e7625ULL, 0x080fe200078e0051ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002537faeULL, 0x0003e6000b901c46ULL,
0x00005e0050507625ULL, 0x000fc800078e0051ULL, 0x0000001037447825ULL, 0x000fc800078e0044ULL,
0x0000001055557824ULL, 0x000fe400078e0242ULL, 0x0000001037467825ULL, 0x000fc600078e0046ULL,
0x0000000044557faeULL, 0x0003e2000b901c46ULL, 0x0000001057577824ULL, 0x000fe400078e0242ULL,
0x0000001037487825ULL, 0x000fc600078e0048ULL, 0x0000000046577faeULL, 0x0003e2000b901c46ULL,
0x0000001059597824ULL, 0x000fe400078e0242ULL, 0x00000010374a7825ULL, 0x000fc600078e004aULL,
0x0000000048597faeULL, 0x0003e2000b901c46ULL, 0x00000010374c7825ULL, 0x000fc600078e004cULL,
0x000000004a5b7faeULL, 0x0003e2000b901c46ULL, 0x000000105d5d7824ULL, 0x000fe400078e0242ULL,
0x00000010374e7825ULL, 0x000fc600078e004eULL, 0x000000004c5d7faeULL, 0x0003e2000b901c46ULL,
0x000000105f5f7824ULL, 0x000fe400078e0242ULL, 0x0000001037507825ULL, 0x000fc600078e0050ULL,
0x000000004e5f7faeULL, 0x0003e2000b901c46ULL, 0x0000001061617824ULL, 0x000fca00078e0242ULL,
0x0000000050617faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01c6680000467f8cULL, 0x0022a4000c80043fULL,
0x0000000000027805ULL, 0x000fc40000015200ULL, 0x01c66c0000377984ULL, 0x000ee40000000800ULL,
0x8000000037ff7812ULL, 0x00cfe40007804847ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ff00487202ULL, 0x000fe20000000f00ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000447805ULL, 0x000fcc0000015200ULL,
0x0000004402427210ULL, 0x000fca0007f1e1ffULL, 0x0000000145447824ULL, 0x000fe200000e0e03ULL,
0x003d09004200780cULL, 0x000fc80003f06070ULL, 0x000000ff4400720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404200780cULL, 0x000fc80003f06070ULL,
0x000000ff4400720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff377819ULL, 0x000fc80000011444ULL, 0x0000004237377211ULL, 0x000fca00078110ffULL,
0x000000ffff427224ULL, 0x000fca00000e0644ULL, 0x0000000237377819ULL, 0x000fc80000001242ULL,
0x000000370000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000148487810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01c66c0000377984ULL, 0x000ea40000000800ULL, 0x8000000037ff7812ULL, 0x004fe40007804847ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x01c1800036427984ULL, 0x000ea80000000800ULL,
0x01c3800036447984ULL, 0x0006620000000800ULL, 0x000000434200720bULL, 0x004fe20003f1d000ULL,
0x0000dbf27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000377806ULL, 0x008fc800000e0100ULL,
0x0000ffff37ff7812ULL, 0x000fe2000782c0ffULL, 0x0000045000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fd60003f0e170ULL, 0x0000042000009947ULL, 0x000fea0003800000ULL,
0x000000037b00780cULL, 0x000fe40003f05270ULL, 0x000000434200720bULL, 0x000fe20003f34000ULL,
0x0000dbd27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000467806ULL, 0x000fc400008e0100ULL,
0x0000004342038209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x0000991046027816ULL, 0x000fc600000000ffULL, 0x01c5800336008388ULL, 0x0005e20000000800ULL,
0x000000ff0200720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000004342027209ULL, 0x004fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff46ff7812ULL, 0x000fc6000780c0ffULL, 0x0000004302027221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b02027820ULL, 0x000fc80000410000ULL, 0x0000000200367308ULL, 0x000ea40000000800ULL,
0x0000003605057220ULL, 0x004fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff027819ULL, 0x000fe20000011604ULL, 0x0000db227f007947ULL, 0x000fea000b800000ULL,
0x00001f0236027589ULL, 0x0004e400000e0000ULL, 0x0000000218187220ULL, 0x088fe40000410000ULL,
0x0000000219197220ULL, 0x080fe40000410000ULL, 0x0000000214147220ULL, 0x080fe40000410000ULL,
0x0000000215157220ULL, 0x000fc40000410000ULL, 0x0000000210107220ULL, 0x080fe40000410000ULL,
0x0000000211117220ULL, 0x080fe40000410000ULL, 0x000000020c0c7220ULL, 0x080fe40000410000ULL,
0x000000020d0d7220ULL, 0x080fe40000410000ULL, 0x0000000208087220ULL, 0x080fe40000410000ULL,
0x0000000209097220ULL, 0x000fc40000410000ULL, 0x0000000224247220ULL, 0x080fe40000410000ULL,
0x0000000225257220ULL, 0x080fe40000410000ULL, 0x0000000228287220ULL, 0x080fe40000410000ULL,
0x0000000229297220ULL, 0x080fe40000410000ULL, 0x0000000220207220ULL, 0x080fe40000410000ULL,
0x0000000221217220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0046ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000804027811ULL, 0x000fe200078ff0ffULL, 0x0000da327f007947ULL, 0x000fea000b800000ULL,
0x00001f0236027589ULL, 0x0006a400000e0000ULL, 0x000000021a1a7220ULL, 0x084fe40000410000ULL,
0x000000021b1b7220ULL, 0x080fe40000410000ULL, 0x0000000216167220ULL, 0x080fe40000410000ULL,
0x0000000217177220ULL, 0x080fe40000410000ULL, 0x0000000212127220ULL, 0x080fe40000410000ULL,
0x0000000213137220ULL, 0x000fc40000410000ULL, 0x000000020e0e7220ULL, 0x080fe40000410000ULL,
0x000000020f0f7220ULL, 0x080fe40000410000ULL, 0x000000020a0a7220ULL, 0x080fe40000410000ULL,
0x000000020b0b7220ULL, 0x080fe40000410000ULL, 0x0000000226267220ULL, 0x080fe40000410000ULL,
0x0000000227277220ULL, 0x000fc40000410000ULL, 0x000000022a2a7220ULL, 0x080fe40000410000ULL,
0x000000022b2b7220ULL, 0x080fe40000410000ULL, 0x0000000222227220ULL, 0x080fe40000410000ULL,
0x0000000223237220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff46ff7812ULL, 0x000fe40007800837ULL, 0x0000004342437209ULL, 0x000fd60007810000ULL,
0x8000004342420221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b42420820ULL, 0x000fc80000410000ULL,
0x0000004200070308ULL, 0x000ea40000000800ULL, 0x0000000744440220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000019000007945ULL, 0x000fe20003800000ULL, 0x0000000544057221ULL, 0x002fe20000010000ULL,
0x0000016000008947ULL, 0x000fea0003800000ULL, 0x00000007ff02723eULL, 0x000fe400000010ffULL,
0x00000002ff377819ULL, 0x000fe40000011604ULL, 0x0000541002367816ULL, 0x008fe20000000002ULL,
0x0000d8927f007947ULL, 0x000fea000b800000ULL, 0x00001f37361c7589ULL, 0x0002a400000e0000ULL,
0x0000000837027810ULL, 0x000fe20007ffe0ffULL, 0x0000d8e27f007947ULL, 0x000fea000b800000ULL,
0x00001f02361d7589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001037027810ULL, 0x008fe20007ffe0ffULL, 0x0000001fff4b7424ULL, 0x000fe200078e00ffULL,
0x00000036004a7202ULL, 0x000fe20000000f00ULL, 0xffffffffff4d7424ULL, 0x000fe200078e00ffULL,
0x00009a60004c7802ULL, 0x000fc40000000f00ULL, 0x0000df5000007944ULL, 0x006fea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001837027810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff4a7224ULL, 0x004fe200078e0036ULL, 0x0000001f004b7802ULL, 0x000fe20000000f00ULL,
0xffffffffff4d7424ULL, 0x000fe200078e00ffULL, 0x00009ad0004c7802ULL, 0x000fc40000000f00ULL,
0x0000dee000007944ULL, 0x002fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0001380038387811ULL, 0x000fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000003a4c783bULL, 0x000fe20000004200ULL, 0x000138003d3d7811ULL, 0x000fc400078e20ffULL,
0x000003007c027a10ULL, 0x008fe20007ffe0ffULL, 0x000000003844783bULL, 0x000ee60000000200ULL,
0x0000000102367810ULL, 0x042fe20007ffe0ffULL, 0x000000003b50783bULL, 0x000fe20000004200ULL,
0x0000010002037824ULL, 0x000fe400078e00ffULL, 0x000000793600720cULL, 0x000fe20003f26070ULL,
0x000000003948783bULL, 0x004fe80000004200ULL, 0x000000003c54783bULL, 0x000fe80000004200ULL,
0x000000003d58783bULL, 0x000e680000000200ULL, 0x000000004064783bULL, 0x000ea80000004200ULL,
0x000000003e5c783bULL, 0x000f280000004200ULL, 0x000000004168783bULL, 0x000ea80000004200ULL,
0x000000003f60783bULL, 0x000ea20000004200ULL, 0x0000001c44440231ULL, 0x008fc400003400ffULL,
0x0000001c46460231ULL, 0x000fe400003400ffULL, 0x0000001d45450231ULL, 0x080fe400003400ffULL,
0x0000001d47470231ULL, 0x000fce00003400ffULL, 0x0000004c4410723cULL, 0x000fe20000041810ULL,
0x0000001c58580231ULL, 0x082fe400003400ffULL, 0x0000001c5a5a0231ULL, 0x000fe400003400ffULL,
0x0000001d59590231ULL, 0x000fc600003400ffULL, 0x000000524424723cULL, 0x000f620000041824ULL,
0x0000001d5b5b0231ULL, 0x000fce00003400ffULL, 0x000000484418723cULL, 0x040f700000041818ULL,
0x0000004a4414723cULL, 0x040f700000041814ULL, 0x0000004e444c723cULL, 0x040ff0000004180cULL,
0x000000504438723cULL, 0x040ff00000041808ULL, 0x000000544428723cULL, 0x040f700000041828ULL,
0x000000564444723cULL, 0x000f700000041820ULL, 0x000000665820723cULL, 0x064f700000041824ULL,
0x0000005c5808723cULL, 0x050f700000041818ULL, 0x0000005e580c723cULL, 0x040f700000041814ULL,
0x000000685824723cULL, 0x040f700000041828ULL, 0x000000605810723cULL, 0x040f700000041810ULL,
0x000000625814723cULL, 0x040f70000004184cULL, 0x000000645818723cULL, 0x040b6e0000041838ULL,
0x0000620006397a24ULL, 0x020fe200078e0203ULL, 0x0000006a5828723cULL, 0x000b620000041844ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000059000009947ULL, 0x000fca0003800000ULL,
0x00000003ff387819ULL, 0x120fe20000011604ULL, 0x0000000100417824ULL, 0x000fe200078e021fULL,
0x000000037a027217ULL, 0x000fe20007800000ULL, 0x00000200ff3f7424ULL, 0x000fe200078e00ffULL,
0x00000004383a7810ULL, 0x040fe40007ffe0ffULL, 0x00000008383c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000102027824ULL, 0x000fe200078e0a03ULL, 0x000000033a3d7819ULL, 0x040fe200000006ffULL,
0x000000013a367824ULL, 0x000fe200078e0204ULL, 0x0000000c383e7810ULL, 0x040fe20007ffe0ffULL,
0x0000000138037824ULL, 0x000fe200078e0239ULL, 0x00000020021f7817ULL, 0x000fc40003800000ULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee236ULL, 0x00005e0003027625ULL, 0x000fe200078e003fULL,
0x0000000438367210ULL, 0x040fe40007ffe0ffULL, 0x0000001f3800720cULL, 0x080fe20003f26070ULL,
0x000000013e407824ULL, 0x100fe200078e0204ULL, 0x0000000736377812ULL, 0x000fe200078ec0ffULL,
0x000000013a367824ULL, 0x040fe200078e0239ULL, 0x0000001f3a00720cULL, 0x000fe20003f46070ULL,
0x000000013c3a7824ULL, 0x100fe200078e0204ULL, 0x0ffffff8373b7812ULL, 0x000fe200078ef804ULL,
0x00005e0036367625ULL, 0x000fe200078e003fULL, 0x000000033c457819ULL, 0x000fc400000006ffULL,
0x0000001e3d3d7211ULL, 0x000fe200078e20ffULL, 0x000000083e477824ULL, 0x000fe200078e00ffULL,
0xfffffff845457812ULL, 0x000fe200078ee23aULL, 0x0000001041027825ULL, 0x000fe200078e0002ULL,
0x00000010383a7810ULL, 0x040fe40007ffe0ffULL, 0xfffffff847477812ULL, 0x000fe200078ee240ULL,
0x000000103b3b7824ULL, 0x000fe200078e021eULL, 0x0000001438407810ULL, 0x040fe20007ffe0ffULL,
0x0000001041367825ULL, 0x000fe200078e0036ULL, 0x0000001838427810ULL, 0x000fc40007ffe0ffULL,
0x0000001c38447810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000023b7faeULL, 0x0003e2000c901c46ULL, 0x0000001f3c00720cULL, 0x080fe20003f26070ULL,
0x000000013a387824ULL, 0x040fe200078e0239ULL, 0x0000001f3a00720cULL, 0x080fe20003f66070ULL,
0x00000000363d7faeULL, 0x0005e2000d101c46ULL, 0x0000001f3e00720cULL, 0x080fe20003f46070ULL,
0x000000083a467824ULL, 0x000fe200078e00ffULL, 0x0000001f4000720cULL, 0x080fe20003f86070ULL,
0x0000001045457824ULL, 0x000fe200078e021eULL, 0x0000001f4200720cULL, 0x000fc40003fa6070ULL,
0x0000001f4400720cULL, 0x000fe20003fc6070ULL, 0x000000013c027824ULL, 0x102fe200078e0239ULL,
0x000000043a037210ULL, 0x000fe20007ffe0ffULL, 0x00000001403a7824ULL, 0x100fe200078e0239ULL,
0x0000001e47477211ULL, 0x000fe200078e20ffULL, 0x000000013e367824ULL, 0x004fe200078e0239ULL,
0xfffffff8461f7812ULL, 0x000fe200078ee203ULL, 0x0000000140377824ULL, 0x140fe200078e0204ULL,
0x0000000340407819ULL, 0x000fe200000006ffULL, 0x00000001423c7824ULL, 0x100fe400078e0239ULL,
0x00000001443e7824ULL, 0x000fe200078e0239ULL, 0xfffffff840497812ULL, 0x000fe200078ee237ULL,
0x0000000142397824ULL, 0x140fe200078e0204ULL, 0x0000000342427819ULL, 0x000fe200000006ffULL,
0x00000001443b7824ULL, 0x000fc400078e0204ULL, 0x0000000844447824ULL, 0x000fe200078e00ffULL,
0xfffffff8424b7812ULL, 0x000fe200078ee239ULL, 0x00005e0002027625ULL, 0x000fc600078e003fULL,
0xfffffff8444d7812ULL, 0x000fe200078ee23bULL, 0x00005e0036367625ULL, 0x000fc600078e003fULL,
0x0000001e4d4d7211ULL, 0x000fe200078e20ffULL, 0x00005e0038387625ULL, 0x000fc800078e003fULL,
0x00005e003a3a7625ULL, 0x000fc800078e003fULL, 0x00005e003c3c7625ULL, 0x000fc800078e003fULL,
0x00005e003e3e7625ULL, 0x000fc800078e003fULL, 0x0000001041027825ULL, 0x000fc800078e0002ULL,
0x0000001041367825ULL, 0x040fe200078e0036ULL, 0x0000000002457faeULL, 0x0003e6000c901c46ULL,
0x0000001041387825ULL, 0x000fe200078e0038ULL, 0x0000000036477faeULL, 0x0003e6000d101c46ULL,
0x000000101f1f7824ULL, 0x000fe400078e021eULL, 0x00000010413a7825ULL, 0x000fc600078e003aULL,
0x00000000381f7faeULL, 0x0003e2000d901c46ULL, 0x0000001049497824ULL, 0x000fe400078e021eULL,
0x00000010413c7825ULL, 0x000fc600078e003cULL, 0x000000003a497faeULL, 0x0003e2000e101c46ULL,
0x000000104b4b7824ULL, 0x000fe400078e021eULL, 0x00000010413e7825ULL, 0x000fc600078e003eULL,
0x000000003c4b7faeULL, 0x0003e8000e901c46ULL, 0x000000003e4d7faeULL, 0x0003e2000f101c46ULL,
0x000004c000007947ULL, 0x000fea0003800000ULL, 0x0000000804387811ULL, 0x060fe200078fe8ffULL,
0x00000200ff457424ULL, 0x000fe200078e00ffULL, 0x0000000c043a7811ULL, 0x000fe200078fe8ffULL,
0x00000001001f7824ULL, 0x000fe200078e021fULL, 0x0000000404367811ULL, 0x000fe200078fe8ffULL,
0x0000000138037824ULL, 0x140fe200078e0204ULL, 0x00000003383e7819ULL, 0x000fe200000006ffULL,
0x000000013a377824ULL, 0x100fe200078e0204ULL, 0x00000010043c7811ULL, 0x000fe200078fe8ffULL,
0x000000083a407824ULL, 0x000fe200078e00ffULL, 0xfffffff83e4b7812ULL, 0x000fe200078ee203ULL,
0x0000000136027824ULL, 0x100fe200078e0204ULL, 0x0000001404037811ULL, 0x000fe200078fe8ffULL,
0x0000000836497824ULL, 0x000fe200078e00ffULL, 0x00000018043d7811ULL, 0x000fe200078fe8ffULL,
0x000000013c3b7824ULL, 0x000fe200078e0204ULL, 0x0000001c04417811ULL, 0x000fe200078fe8ffULL,
0x0000000136367824ULL, 0x000fe200078e0239ULL, 0xfffffff8404d7812ULL, 0x000fe200078ee237ULL,
0x000000013a3a7824ULL, 0x100fe200078e0239ULL, 0x000000033c427819ULL, 0x040fe200000006ffULL,
0x000000013c3c7824ULL, 0x100fe200078e0239ULL, 0x0000000404377211ULL, 0x0c0fe200078fe8ffULL,
0x00000001033e7824ULL, 0x100fe200078e0239ULL, 0xfffffff849497812ULL, 0x000fe200078ee202ULL,
0x000000013d407824ULL, 0x100fe200078e0239ULL, 0x0000003904027211ULL, 0x080fe200078fe8ffULL,
0x0000000141447824ULL, 0x040fe200078e0239ULL, 0x0000003938387210ULL, 0x000fe20007ffe0ffULL,
0x0000000141397824ULL, 0x140fe200078e0204ULL, 0xfffffff8424f7812ULL, 0x000fe200078ee23bULL,
0x0000000841487824ULL, 0x000fe200078e00ffULL, 0x0000000737377812ULL, 0x000fe200078ec0ffULL,
0x0000000803427824ULL, 0x040fe200078e00ffULL, 0x00000004033b7210ULL, 0x000fe20007ffe0ffULL,
0x000000013d3f7824ULL, 0x140fe200078e0204ULL, 0x000000033d467819ULL, 0x000fe200000006ffULL,
0x00005e0002027625ULL, 0x000fe200078e0045ULL, 0x0ffffff837477812ULL, 0x000fc400078ef804ULL,
0xfffffff848557812ULL, 0x000fe200078ee239ULL, 0x00005e0036367625ULL, 0x080fe200078e0045ULL,
0xfffffff842517812ULL, 0x000fe400078ee23bULL, 0xfffffff846537812ULL, 0x000fe200078ee23fULL,
0x00005e0038387625ULL, 0x080fe200078e0045ULL, 0x0000001e47477211ULL, 0x080fe400078e20ffULL,
0x0000001e4f4f7211ULL, 0x000fe200078e20ffULL, 0x00005e003a3a7625ULL, 0x000fc800078e0045ULL,
0x00005e003c3c7625ULL, 0x000fc800078e0045ULL, 0x00005e003e3e7625ULL, 0x000fc800078e0045ULL,
0x000000101f027825ULL, 0x000fc800078e0002ULL, 0x00005e0040407625ULL, 0x080fe200078e0045ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002477faeULL, 0x0003e6000b901c46ULL,
0x00005e0044447625ULL, 0x000fc800078e0045ULL, 0x000000101f367825ULL, 0x000fc800078e0036ULL,
0x0000001049497824ULL, 0x000fe400078e021eULL, 0x000000101f387825ULL, 0x000fc600078e0038ULL,
0x0000000036497faeULL, 0x0003e2000b901c46ULL, 0x000000104b4b7824ULL, 0x000fe400078e021eULL,
0x000000101f3a7825ULL, 0x000fc600078e003aULL, 0x00000000384b7faeULL, 0x0003e2000b901c46ULL,
0x000000104d4d7824ULL, 0x000fe400078e021eULL, 0x000000101f3c7825ULL, 0x000fc600078e003cULL,
0x000000003a4d7faeULL, 0x0003e2000b901c46ULL, 0x000000101f3e7825ULL, 0x000fc600078e003eULL,
0x000000003c4f7faeULL, 0x0003e2000b901c46ULL, 0x0000001051517824ULL, 0x000fe400078e021eULL,
0x000000101f407825ULL, 0x000fc600078e0040ULL, 0x000000003e517faeULL, 0x0003e2000b901c46ULL,
0x0000001053537824ULL, 0x000fe400078e021eULL, 0x000000101f447825ULL, 0x000fc600078e0044ULL,
0x0000000040537faeULL, 0x0003e2000b901c46ULL, 0x0000001055557824ULL, 0x000fca00078e021eULL,
0x0000000044557faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000019000007945ULL, 0x000fe20003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000016000008947ULL, 0x000fea0003800000ULL, 0x00000007ff02723eULL, 0x002fe400000010ffULL,
0x00000002ff1f7819ULL, 0x000fe40000011604ULL, 0x00005410021e7816ULL, 0x000fe20000000002ULL,
0x0000cac27f007947ULL, 0x000fea000b800000ULL, 0x00001f1f1e1c7589ULL, 0x0002a400000e0000ULL,
0x000000081f027810ULL, 0x000fe20007ffe0ffULL, 0x0000cb127f007947ULL, 0x000fea000b800000ULL,
0x00001f021e1d7589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000101f027810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff4a7224ULL, 0x000fe200078e001eULL,
0x0000a920004c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff4b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff4d7424ULL, 0x000fc400078e00ffULL, 0x0000d09000007944ULL, 0x006fea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000181f027810ULL, 0x008fe20007ffe0ffULL,
0x0000001fff4b7424ULL, 0x000fe200078e00ffULL, 0x0000001e004a7202ULL, 0x004fe20000000f00ULL,
0xffffffffff4d7424ULL, 0x000fe200078e00ffULL, 0x0000a990004c7802ULL, 0x000fc40000000f00ULL,
0x0000d02000007944ULL, 0x002fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000138002c2c7811ULL, 0x000fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000002e44783bULL, 0x002fe20000004200ULL, 0x0001380031317811ULL, 0x000fc600078e20ffULL,
0x000000002c38783bULL, 0x000e680000000200ULL, 0x000000002d3c783bULL, 0x000fe80000004200ULL,
0x000000002f48783bULL, 0x004fe80000004200ULL, 0x00000000304c783bULL, 0x000fe80000004200ULL,
0x000000003150783bULL, 0x000ea80000000200ULL, 0x000000003254783bULL, 0x000f280000004200ULL,
0x00000000345c783bULL, 0x000ee80000004200ULL, 0x000000003358783bULL, 0x0002e80000004200ULL,
0x000000003560783bULL, 0x000ee20000004200ULL, 0x0000001c38380231ULL, 0x002fc400003400ffULL,
0x0000001c3a3a0231ULL, 0x000fe400003400ffULL, 0x0000001d39390231ULL, 0x080fe400003400ffULL,
0x0000001d3b3b0231ULL, 0x000fce00003400ffULL, 0x000000443810723cULL, 0x000fe20000041810ULL,
0x0000001c50500231ULL, 0x084fe400003400ffULL, 0x0000001c52520231ULL, 0x000fe400003400ffULL,
0x0000001d51510231ULL, 0x000fc600003400ffULL, 0x0000003c3808723cULL, 0x000f620000041808ULL,
0x0000001d53530231ULL, 0x000fce00003400ffULL, 0x0000003e380c723cULL, 0x040f70000004180cULL,
0x000000463844723cULL, 0x040ff00000041814ULL, 0x00000048382c723cULL, 0x040ff00000041818ULL,
0x0000004a3820723cULL, 0x040f700000041820ULL, 0x0000004c3830723cULL, 0x040f700000041824ULL,
0x0000004e3838723cULL, 0x000f700000041828ULL, 0x000000545018723cULL, 0x070b700000041808ULL,
0x000000565014723cULL, 0x040b70000004180cULL, 0x0000005e5024723cULL, 0x048b700000041820ULL,
0x000000585010723cULL, 0x040b700000041810ULL, 0x0000005a500c723cULL, 0x040b700000041844ULL,
0x0000005c5008723cULL, 0x040b70000004182cULL, 0x000000605028723cULL, 0x040b700000041830ULL,
0x000000625020723cULL, 0x000b620000041838ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x01c6a000ffff7f8cULL, 0x000fe4000c80043fULL,
0x000003007c7c7a10ULL, 0x000fc80007ffe0ffULL, 0x000000797c00720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff65d000007947ULL, 0x000fea000383ffffULL,
0x00000000002c7919ULL, 0x020e620000002500ULL, 0x0000000a001f7202ULL, 0x000fe20000000f00ULL,
0x000000ffff1e7224ULL, 0x000fe400078e000bULL, 0x000000ffff0a7224ULL, 0x000fe400078e0008ULL,
0x000000ffff1c7224ULL, 0x000fe400078e000fULL, 0x000000ffff1d7224ULL, 0x000fe200078e000eULL,
0x000000792c00720cULL, 0x002fda0003f06070ULL, 0x0000035000000947ULL, 0x000fea0003800000ULL,
0x0180000005027810ULL, 0x000fe20007ffe0ffULL, 0x000000d000007945ULL, 0x000fe60003800000ULL,
0x7f80000002027812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0200780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x0000000500327202ULL, 0x000fe40000000f00ULL,
0x0000ada000067802ULL, 0x000fc40000000f00ULL, 0x0000ca6000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff027224ULL, 0x00cfe200078e0004ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000500027308ULL, 0x000e640000001000ULL, 0xbf80000002037423ULL, 0x002fc80000000005ULL,
0x800000ff03037221ULL, 0x000fc80000010100ULL, 0x0000000302027223ULL, 0x000fc40000000002ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000ea80000000000ULL,
0x0000000000047919ULL, 0x000ee20000000000ULL, 0x00000002ff037819ULL, 0x004fe40000011603ULL,
0x0000000804077811ULL, 0x008fc800078ff0ffULL, 0x00001f0302037589ULL, 0x000ea800000e0000ULL,
0x00001f0702047589ULL, 0x000ee200000e0000ULL, 0x0000001803187220ULL, 0x044fe40000410000ULL,
0x0000001903197220ULL, 0x040fe40000410000ULL, 0x0000001403147220ULL, 0x040fe40000410000ULL,
0x0000001503157220ULL, 0x000fc40000410000ULL, 0x0000001003107220ULL, 0x040fe40000410000ULL,
0x0000001103117220ULL, 0x040fe40000410000ULL, 0x0000000c030c7220ULL, 0x040fe40000410000ULL,
0x0000000d030d7220ULL, 0x040fe40000410000ULL, 0x0000000a030a7220ULL, 0x040fe40000410000ULL,
0x0000000903097220ULL, 0x000fc40000410000ULL, 0x0000002403247220ULL, 0x040fe40000410000ULL,
0x0000002503257220ULL, 0x040fe40000410000ULL, 0x0000002803287220ULL, 0x040fe40000410000ULL,
0x0000002903297220ULL, 0x040fe40000410000ULL, 0x0000002003207220ULL, 0x040fe40000410000ULL,
0x0000002103217220ULL, 0x000fc40000410000ULL, 0x0000001a041a7220ULL, 0x048fe40000410000ULL,
0x0000001b041b7220ULL, 0x040fe40000410000ULL, 0x0000001604167220ULL, 0x040fe40000410000ULL,
0x0000001704177220ULL, 0x040fe40000410000ULL, 0x0000001204127220ULL, 0x040fe40000410000ULL,
0x0000001304137220ULL, 0x000fc40000410000ULL, 0x0000001d041d7220ULL, 0x040fe40000410000ULL,
0x0000001c041c7220ULL, 0x040fe40000410000ULL, 0x0000001f041f7220ULL, 0x040fe40000410000ULL,
0x0000001e041e7220ULL, 0x040fe40000410000ULL, 0x0000002604267220ULL, 0x040fe40000410000ULL,
0x0000002704277220ULL, 0x000fc40000410000ULL, 0x0000002a042a7220ULL, 0x040fe40000410000ULL,
0x0000002b042b7220ULL, 0x040fe40000410000ULL, 0x0000002204227220ULL, 0x040fe40000410000ULL,
0x0000002304237220ULL, 0x000fc40000410000ULL, 0x00000000002d7919ULL, 0x000ea20000000000ULL,
0x000000181904723eULL, 0x000fe400000010ffULL, 0x000000141506723eULL, 0x000fe200000010ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000c0d08723eULL, 0x000fc400000010ffULL,
0x0000001a1b0d723eULL, 0x000fe400000010ffULL, 0x00000016170e723eULL, 0x000fe400000010ffULL,
0x000000101107723eULL, 0x000fe400000010ffULL, 0x00000020210c723eULL, 0x000fe400000010ffULL,
0x0000001d1c10723eULL, 0x000fe400000010ffULL, 0x0000001f1e11723eULL, 0x000fc400000010ffULL,
0x00000002ff197819ULL, 0x004fe4000001162dULL, 0x000000222314723eULL, 0x000fe400000010ffULL,
0x0000000119027810ULL, 0x040fe20007ffe0ffULL, 0x0000000819157824ULL, 0x040fe200078e00ffULL,
0x0000000219037810ULL, 0x040fe20007ffe0ffULL, 0x00000008191a7824ULL, 0x040fe200078e00ffULL,
0x0000000319177819ULL, 0x040fe200000006ffULL, 0x00000008191b7824ULL, 0x000fe200078e00ffULL,
0xfffffff815187812ULL, 0x000fe200078ee202ULL, 0x00000008191e7824ULL, 0x040fe200078e00ffULL,
0x0000000319027810ULL, 0x040fe20007ffe0ffULL, 0x0000000819207824ULL, 0x040fe200078e00ffULL,
0x0000000619167810ULL, 0x000fc40007ffe0ffULL, 0xfffffff81a1a7812ULL, 0x000fe400078ee203ULL,
0xfffffff8171c7812ULL, 0x000fe200078ee202ULL, 0x000008007b027824ULL, 0x000fe200078e00ffULL,
0x0000000419037810ULL, 0x040fe40007ffe0ffULL, 0x0000000519157810ULL, 0x000fe40007ffe0ffULL,
0xfffffff81b227812ULL, 0x000fe400078ee216ULL, 0x00000012130f723eULL, 0x000fc400000010ffULL,
0x0000000319167819ULL, 0x000fe400000006ffULL, 0x000000262712723eULL, 0x000fe400000010ffULL,
0x000000082d267811ULL, 0x000fe400078ff0ffULL, 0xfffffff81e1e7812ULL, 0x000fe400078ee203ULL,
0xfffffff820207812ULL, 0x000fe400078ee215ULL, 0x0000000a0909723eULL, 0x000fc400000010ffULL,
0xfffffff816167812ULL, 0x000fe400078ee219ULL, 0x000000022d157819ULL, 0x000fe400000006ffULL,
0x0001200002037810ULL, 0x000fe40007ffe0ffULL, 0x00000024250a723eULL, 0x000fe200000010ffULL,
0x0000000819247824ULL, 0x040fe200078e00ffULL, 0xffffffff19177810ULL, 0x000fe20007ffe0ffULL,
0x0000000826197824ULL, 0x000fe200078e00ffULL, 0x0000000c15157812ULL, 0x000fe200078ec0ffULL,
0x0000001016167824ULL, 0x000fe200078e0203ULL, 0xfffffff824247812ULL, 0x000fe200078ee217ULL,
0x0000001018187824ULL, 0x100fe200078e0203ULL, 0x000000031c1c7211ULL, 0x080fe200078e20ffULL,
0x000000101a1a7824ULL, 0x100fe200078e0203ULL, 0xfffffff819267812ULL, 0x000fe200078ee226ULL,
0x0000001020207824ULL, 0x100fe200078e0203ULL, 0x0000000324247211ULL, 0x000fe200078e20ffULL,
0x000000101e1e7824ULL, 0x000fe200078e0203ULL, 0x0000001a151a7210ULL, 0x000fe20007ffe0ffULL,
0x0000000116177824ULL, 0x000fe200078e0215ULL, 0x00000028290b723eULL, 0x000fe200000010ffULL,
0x0000001022227824ULL, 0x100fe200078e0203ULL, 0x0000002a2b13723eULL, 0x000fe200000010ffULL,
0x0000000115197824ULL, 0x040fe200078e0218ULL, 0x0000000417007388ULL, 0x0005e20000000800ULL,
0x00000001151b7824ULL, 0x040fe200078e021cULL, 0x0000002215227210ULL, 0x040fe20007ffe0ffULL,
0x00000001151d7824ULL, 0x000fe200078e0220ULL, 0x0000000619007388ULL, 0x0005e20000000800ULL,
0x0000001026267824ULL, 0x000fc400078e0203ULL, 0x00000001151e7824ULL, 0x040fe200078e021eULL,
0x000000071a007388ULL, 0x0005e20000000800ULL, 0x00000300ff207624ULL, 0x000fe400078e00ffULL,
0x00000001151f7824ULL, 0x040fe200078e0224ULL, 0x000000081b007388ULL, 0x0005e20000000800ULL,
0x0000000115267824ULL, 0x000fe200078e0226ULL, 0x000000012000780cULL, 0x000fe40003f05270ULL,
0x000000091e007388ULL, 0x0005e80000000800ULL, 0x0000000a1d007388ULL, 0x0005e80000000800ULL,
0x0000000b22007388ULL, 0x0005e80000000800ULL, 0x0000000c1f007388ULL, 0x0005e80000000800ULL,
0x0000000d26007388ULL, 0x0005e80000000800ULL, 0x0004000e19007388ULL, 0x0005e80000000800ULL,
0x0004000f1a007388ULL, 0x0005e80000000800ULL, 0x000400101b007388ULL, 0x0005e80000000800ULL,
0x000400111e007388ULL, 0x0005e80000000800ULL, 0x000400121d007388ULL, 0x0005e80000000800ULL,
0x0004001322007388ULL, 0x0005e80000000800ULL, 0x000400141f007388ULL, 0x0005e20000000800ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000270000008947ULL, 0x000fea0003800000ULL,
0x0000580000047a02ULL, 0x004fe20000000f00ULL, 0x0000000000087919ULL, 0x000ea80000002700ULL,
0x00000000000b7919ULL, 0x000ea20000002600ULL, 0x0000640004047a24ULL, 0x000fc600078e02ffULL,
0x0000000000067919ULL, 0x000ee20000000000ULL, 0x0000030004097a24ULL, 0x040fe200078e02ffULL,
0x0000000f04077811ULL, 0x000fc800078e10ffULL, 0xfffffff007107812ULL, 0x000fca00078ec0ffULL,
0x0000008009127824ULL, 0x000fc800078e0210ULL, 0x0000008009097824ULL, 0x000fe400078e0212ULL,
0x0000580008047a24ULL, 0x004fc600078e020bULL, 0x0000007f09097810ULL, 0x000fe20007ffe0ffULL,
0x0000030004077a24ULL, 0x000fc600078e02ffULL, 0xffffff8009117812ULL, 0x000fe200078ec0ffULL,
0x00000010060a7824ULL, 0x048fe200078e0202ULL, 0x00000020060b7810ULL, 0x000fe40007ffe0ffULL,
0x0000002c070c7210ULL, 0x000fe40007ffe0ffULL, 0x0000680011097a10ULL, 0x000fe20007f1e0ffULL,
0x012000000a147984ULL, 0x000ea60000000c00ULL, 0x000000090c087211ULL, 0x000fe200078260ffULL,
0x00006900ff097624ULL, 0x000fe200000e06ffULL, 0x00006800101c7a10ULL, 0x000fe20007f1e0ffULL,
0x012200000a187984ULL, 0x0006660000000c00ULL, 0x000000090c097211ULL, 0x000fe200008f64ffULL,
0x00006900ff1e7624ULL, 0x000fe200000e06ffULL, 0x000000ff7b00720cULL, 0x000fc60003f25270ULL,
0x000004007b087825ULL, 0x000fcc00078e0008ULL, 0x000000100b0a7825ULL, 0x008fc800078e0008ULL,
0x0000001006087825ULL, 0x000fe200078e0008ULL, 0x0000011000001947ULL, 0x000fea0003800000ULL,
0x00000000000e7919ULL, 0x000ee20000000000ULL, 0x000000070c0d7819ULL, 0x000fe200000006ffULL,
0x000000100e0f7824ULL, 0x008fe200078e00ffULL, 0x00000001ff1d7819ULL, 0x000fe4000001160eULL,
0x000068000d0e7a10ULL, 0x000fe40007b5e012ULL, 0x000000700f137812ULL, 0x000fe400078ec0ffULL,
0x00000019ff0f7819ULL, 0x000fc4000001160cULL, 0x0000000c1d0c7812ULL, 0x000fe400078ec0ffULL,
0x0000001c130d7210ULL, 0x000fe4000791e00dULL, 0x000069000f1d7a10ULL, 0x000fe400017e64ffULL,
0x0000000e0c0e7210ULL, 0x040fe40007c7e013ULL, 0x0000000d0c0c7210ULL, 0x000fe40007f5e0ffULL,
0x0000001eff0d7210ULL, 0x000fc400007e240fULL, 0x0000001dff0f7210ULL, 0x000fc60001fe84ffULL,
0x000000ffff0d7224ULL, 0x000fca00010e060dULL, 0x000000430c007986ULL, 0x0007e8000c101906ULL,
0x000000050e007986ULL, 0x0007e4000c101906ULL, 0x000000ff0600720cULL, 0x000fe20003f05270ULL,
0x0000001408007986ULL, 0x004fe2000c101d06ULL, 0x0000016000007945ULL, 0x000fe40003800000ULL,
0x000000ff7b00720cULL, 0x000fe20000705670ULL, 0x000000180a007986ULL, 0x002fe8000c101d06ULL,
0x0000000000007b1dULL, 0x000ff00000000000ULL, 0x0000011000000947ULL, 0x000fea0003800000ULL,
0x00000004ff057424ULL, 0x008fe200078e00ffULL, 0xffffffff20097810ULL, 0x000fc60007ffe0ffULL,
0x0000680004047625ULL, 0x000fe200078e0005ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000009040479a8ULL, 0x000ea400099ee1c6ULL, 0x000000090400720cULL, 0x004fc80003f05270ULL,
0x00000001ff087807ULL, 0x000fe20000000000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000008ff007388ULL, 0x0003e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000ff047984ULL, 0x000ea40000000000ULL,
0x000000ff0400720cULL, 0x004fda0003f05270ULL, 0x0000224000008947ULL, 0x000fea0003800000ULL,
0x000000ff7b00720cULL, 0x000fda0003f05270ULL, 0x00000a5000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x000001b000008947ULL, 0x000fea0003800000ULL,
0x0000001006057824ULL, 0x008fe200078e00ffULL, 0x00000001ff087819ULL, 0x002fe40000011606ULL,
0x0000001c07047211ULL, 0x000fe400078038ffULL, 0x0000007005097812ULL, 0x000fe400078ec0ffULL,
0x0000000c08087812ULL, 0x000fe400078ec0ffULL, 0x0000001e07057211ULL, 0x000fe400000f3cffULL,
0x0000000408047210ULL, 0x000fc8000791e009ULL, 0x00000005ff057210ULL, 0x000fca00007e24ffULL,
0x0000000604087981ULL, 0x000328000c1e1900ULL, 0x0000800604097981ULL, 0x000322000c1e1900ULL,
0x000000022000780cULL, 0x000fda0003f05270ULL, 0x000000f000008947ULL, 0x000fea0003800000ULL,
0x00010006040b7981ULL, 0x002322000c1e1900ULL, 0x000000042000780cULL, 0x000fda0003f06070ULL,
0x000000c000008947ULL, 0x000fea0003800000ULL, 0x00018006040d7981ULL, 0x002322000c1e1900ULL,
0x000000042000780cULL, 0x000fda0003f05270ULL, 0x0000009000008947ULL, 0x000fea0003800000ULL,
0x00020006040f7981ULL, 0x002322000c1e1900ULL, 0x000000062000780cULL, 0x000fda0003f06070ULL,
0x0000006000008947ULL, 0x000fea0003800000ULL, 0x0002800604137981ULL, 0x002322000c1e1900ULL,
0x000000062000780cULL, 0x000fda0003f05270ULL, 0x0000003000008947ULL, 0x000fea0003800000ULL,
0x000000082000780cULL, 0x002fe20003f06070ULL, 0x0003000604157981ULL, 0x000318000c1e1900ULL,
0x0003800604170981ULL, 0x000324000c1e1900ULL, 0x0000000720047810ULL, 0x002fc80007ffe0ffULL,
0x00000003ff0a7819ULL, 0x000fc80000011604ULL, 0x000000ff0a00720cULL, 0x000fda0003f05270ULL,
0x000007d000008947ULL, 0x000fea0003800000ULL, 0x00000010071b7211ULL, 0x000fe200078038ffULL,
0x000000ffff197224ULL, 0x010fe200078e0008ULL, 0x000000ff000e7202ULL, 0x008fe20000000f00ULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x000068001b1b7a10ULL, 0x000fe40007f3e0ffULL,
0x000000ff070c7211ULL, 0x000fe400000f3cffULL, 0x000007801b1b7810ULL, 0x000fc80007f5e0ffULL,
0x00006900ff0c7a10ULL, 0x000fc400017e240cULL, 0x000003000e007a0cULL, 0x000fe20003f26070ULL,
0x0000000104047890ULL, 0x000fcc000fffe03fULL, 0x000000040a007c0cULL, 0x000fcc000bf03070ULL,
0x000006d000001947ULL, 0x012fea0003800000ULL, 0x000000080e047810ULL, 0x040fe40007ffe0ffULL,
0x000000010e057810ULL, 0x000fe40007ffe0ffULL, 0x0000030004007a0cULL, 0x000fe40003f26070ULL,
0x0000030005007a0cULL, 0x000fe40003f46070ULL, 0x0000001908087209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001006047824ULL, 0x000fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011606ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x000000041b047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e060cULL, 0xfffc800604197981ULL, 0x000326000c1e1900ULL,
0x000005f000002947ULL, 0x000fea0003800000ULL, 0x000000090e047810ULL, 0x042fe40007ffe0ffULL,
0x000000020e057810ULL, 0x000fe40007ffe0ffULL, 0x0000030004007a0cULL, 0x000fe40003f26070ULL,
0x0000030005007a0cULL, 0x000fe40003f46070ULL, 0x0000000908087209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000000406047819ULL, 0x000fe400000006ffULL,
0x00000001ff057819ULL, 0x000fe40000011606ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x000000041b047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e060cULL, 0xfffd000604097981ULL, 0x000326000c1e1900ULL,
0x0000051000002947ULL, 0x000fea0003800000ULL, 0x0000000a0e047810ULL, 0x042fe40007ffe0ffULL,
0x000000030e057810ULL, 0x000fe40007ffe0ffULL, 0x0000030004007a0cULL, 0x000fe40003f26070ULL,
0x0000030005007a0cULL, 0x000fe40003f46070ULL, 0x0000000b08087209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001006047824ULL, 0x000fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011606ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x000000041b047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e060cULL, 0xfffd8006040b7981ULL, 0x000326000c1e1900ULL,
0x0000043000002947ULL, 0x000fea0003800000ULL, 0x0000000b0e047810ULL, 0x042fe40007ffe0ffULL,
0x000000040e057810ULL, 0x000fe40007ffe0ffULL, 0x0000030004007a0cULL, 0x000fe40003f26070ULL,
0x0000030005007a0cULL, 0x000fe40003f46070ULL, 0x0000000d08087209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000000406047819ULL, 0x000fe400000006ffULL,
0x00000001ff057819ULL, 0x000fe40000011606ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x000000041b047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e060cULL, 0xfffe0006040d7981ULL, 0x000326000c1e1900ULL,
0x0000035000002947ULL, 0x000fea0003800000ULL, 0x0000000c0e047810ULL, 0x042fe40007ffe0ffULL,
0x000000050e057810ULL, 0x000fe40007ffe0ffULL, 0x0000030004007a0cULL, 0x000fe40003f26070ULL,
0x0000030005007a0cULL, 0x000fe40003f46070ULL, 0x0000000f08087209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001006047824ULL, 0x000fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011606ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x000000041b047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e060cULL, 0xfffe8006040f7981ULL, 0x000326000c1e1900ULL,
0x0000027000002947ULL, 0x000fea0003800000ULL, 0x0000000d0e047810ULL, 0x042fe40007ffe0ffULL,
0x000000060e057810ULL, 0x000fe40007ffe0ffULL, 0x0000030004007a0cULL, 0x000fe40003f26070ULL,
0x0000030005007a0cULL, 0x000fe40003f46070ULL, 0x0000001308087209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000000406047819ULL, 0x000fe400000006ffULL,
0x00000001ff057819ULL, 0x000fe40000011606ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x000000041b047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e060cULL, 0xffff000604137981ULL, 0x000326000c1e1900ULL,
0x0000019000002947ULL, 0x000fea0003800000ULL, 0x0000000e0e047810ULL, 0x042fe40007ffe0ffULL,
0x000000070e057810ULL, 0x000fe40007ffe0ffULL, 0x0000030004007a0cULL, 0x000fe40003f26070ULL,
0x0000030005007a0cULL, 0x000fe40003f46070ULL, 0x0000001508087209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001006047824ULL, 0x000fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011606ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x000000041b047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e060cULL, 0xffff800604157981ULL, 0x000326000c1e1900ULL,
0x000000b000002947ULL, 0x000fea0003800000ULL, 0x0000000f0e047810ULL, 0x002fe40007ffe0ffULL,
0x0000001708087209ULL, 0x000fe40007810000ULL, 0x0000030004007a0cULL, 0x000fda0003f26070ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000000406047819ULL, 0x000fe400000006ffULL,
0x00000001ff057819ULL, 0x000fe40000011606ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x000000041b047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e060cULL, 0x0000000604177981ULL, 0x000326000c1e1900ULL,
0x000004001b1b7810ULL, 0x000fe40007f3e0ffULL, 0x000000080e0e7810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e060cULL, 0xfffff8b000008947ULL, 0x000fea000383ffffULL,
0x0000000000067919ULL, 0x000ea40000000000ULL, 0x0000001006047824ULL, 0x006fe200078e00ffULL,
0x00000001ff057819ULL, 0x008fc80000011606ULL, 0x0000007004047812ULL, 0x000fe400078ec0ffULL,
0x0000000c05057812ULL, 0x000fc800078ec0ffULL, 0x0000000504057210ULL, 0x000fca0007ffe0ffULL,
0x0000000805007388ULL, 0x0103e40000000800ULL, 0x0000680011047a10ULL, 0x000fe20007f1e0ffULL,
0x000004007b3f7824ULL, 0x040fe200078e00ffULL, 0x00000016ff417819ULL, 0x000fe2000001167bULL,
0x00000010060a7824ULL, 0x040fe200078e00ffULL, 0x00000001ff0b7819ULL, 0x000fe20000011606ULL,
0x00006900ff057624ULL, 0x00afe200000e06ffULL, 0x000000070600780cULL, 0x000fe20003f04070ULL,
0x000010007b117824ULL, 0x000fe200078e00ffULL, 0x0000680010427a10ULL, 0x000fe20007f5e0ffULL,
0x0000100007087825ULL, 0x000fe200078e0004ULL, 0x000000700a0a7812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000003f08087210ULL, 0x000fe20007f3e0ffULL,
0x00006900ff447624ULL, 0x000fe200010e06ffULL, 0x0000000c0b0b7812ULL, 0x000fe200078ec0ffULL,
0x000000107b158824ULL, 0x100fe200078e0206ULL, 0x00000042070e8211ULL, 0x000fe200078438ffULL,
0x0000000109097824ULL, 0x000fe200008e0641ULL, 0x00006800123e7a10ULL, 0x000fe20007f3e0ffULL,
0x000000107b178824ULL, 0x000fe200078e0206ULL, 0x0000000b0a147210ULL, 0x000fe20007ffe0ffULL,
0x0000001006137824ULL, 0x040fe200078e0211ULL, 0x00006900ff407a10ULL, 0x000fe20000ffe4ffULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000003e070c8211ULL, 0x040fe200078238ffULL,
0x0000000014107984ULL, 0x0002a20000000800ULL, 0x00000020060b7810ULL, 0x040fe20007ffe0ffULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x00000040070d8211ULL, 0x000fe200008f3cffULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000300ff007a0cULL, 0x000fe20003f25270ULL,
0x000000100b0a7825ULL, 0x100fe200078e0008ULL, 0x00000044070f8211ULL, 0x000fe200010f3cffULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x0000458015158811ULL, 0x000fe200078e20ffULL,
0x0000001006087825ULL, 0x040fe200078e0008ULL, 0x0000418017178811ULL, 0x000fe200078e20ffULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x00000010060c8825ULL, 0x040fe200078e000cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000008137faeULL, 0x0007e2000b901c46ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x00000010060e8825ULL, 0x000fe200078e000eULL,
0x003800000a137faeULL, 0x0007e2000b901c46ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x000000000c158faeULL, 0x0003e2000b901c46ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x000000ff00327202ULL, 0x000fe20000000f00ULL,
0x000000000e178faeULL, 0x0009e8000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000000127805ULL, 0x008fe2000001ff00ULL, 0x0000000000147805ULL, 0x002fe2000001ff00ULL,
0x0000000000167805ULL, 0x010fe2000001ff00ULL, 0x00000be000009947ULL, 0x000fea0003800000ULL,
0x0000000107077810ULL, 0x004fe20007ffe0ffULL, 0x000000ffff127224ULL, 0x000fc400078e00ffULL,
0x00000001ff477424ULL, 0x000fca00078e00ffULL, 0x0000030047007a0cULL, 0x000fda0003f06070ULL,
0x000001f000000947ULL, 0x000fea0003800000ULL, 0x000000070600780cULL, 0x040fe20003f44070ULL,
0x0000100007087825ULL, 0x000fe200078e0004ULL, 0x00000001470c7812ULL, 0x040fe400078ec0ffULL,
0x0000002006397810ULL, 0x000fe20007ffe0ffULL, 0x00000800470a7824ULL, 0x000fe200078e00ffULL,
0x0000003f08087210ULL, 0x000fc80007f1e0ffULL, 0x000008000a0a7812ULL, 0x000fe400078ec0ffULL,
0x0000004109097210ULL, 0x000fe200007fe4ffULL, 0x000000027b0da824ULL, 0x100fe200078e020cULL,
0x00000042070ea211ULL, 0x000fe200078238ffULL, 0x000000027b0fa824ULL, 0x000fe200078e020cULL,
0x0000003e070ca211ULL, 0x000fe200078038ffULL, 0x00000001110b7824ULL, 0x000fe200078e020aULL,
0x000000060d35a211ULL, 0x000fe200078e18ffULL, 0x000000080f37a824ULL, 0x000fe200078e0206ULL,
0x00000040070da211ULL, 0x040fe200000f3cffULL, 0x0000001006337824ULL, 0x000fe200078e020bULL,
0x00000044070fa211ULL, 0x000fe200008f3cffULL, 0x00000010390a7825ULL, 0x000fe200078e0008ULL,
0x000045803535a811ULL, 0x000fc400078e20ffULL, 0x000041803737a811ULL, 0x000fe200078e20ffULL,
0x0000001006087825ULL, 0x000fc800078e0008ULL, 0x00000010060ca825ULL, 0x040fe200078e000cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000008337faeULL, 0x0003e6000b901c46ULL,
0x00000010060ea825ULL, 0x000fe200078e000eULL, 0x003800000a337faeULL, 0x0003e8000b901c46ULL,
0x000000000c35afaeULL, 0x0003e8000b901c46ULL, 0x000000000e37afaeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffff47087810ULL, 0x002fc40007ffe0ffULL,
0x00000004060b7819ULL, 0x000fe400000006ffULL, 0x00000001ff0c7819ULL, 0x100fe20000011606ULL,
0x0000008008097824ULL, 0x000fe200078e00ffULL, 0x000000700b0b7812ULL, 0x000fe400078ec0ffULL,
0x0000000c0c0c7812ULL, 0x000fe400078ec0ffULL, 0x00000080090a7812ULL, 0x000fe400078ec0ffULL,
0x00000002ff387819ULL, 0x000fc40000011606ULL, 0x0000000b08087819ULL, 0x000fe200000006ffULL,
0x000001007b0a7824ULL, 0x000fe200078e020aULL, 0x00000008383c7810ULL, 0x040fe20007ffe0ffULL,
0x00000008380d7824ULL, 0x000fe200078e00ffULL, 0x0000080008087812ULL, 0x000fe200078ec0ffULL,
0x00000008380f7824ULL, 0x000fe200078e00ffULL, 0x0000000a0c0a7210ULL, 0x000fe20007ffe00bULL,
0x00000004060b7824ULL, 0x000fe200078e00ffULL, 0xfffffff80d0d7812ULL, 0x000fe200078ee238ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x004180000a097984ULL, 0x000e620000000800ULL,
0x0000000c0b467812ULL, 0x000fe200078ec0ffULL, 0x000000083c0b7824ULL, 0x000fe200078e00ffULL,
0x0000018011087810ULL, 0x000fe20007ffe008ULL, 0x004580000a0e7984ULL, 0x000ea20000000800ULL,
0x00000001380c7810ULL, 0x040fe20007ffe0ffULL, 0x0000000838337824ULL, 0x040fe200078e00ffULL,
0xfffffff80b0b7812ULL, 0x000fe200078ee23cULL, 0x0000000838367824ULL, 0x040fe200078e00ffULL,
0xfffffff80f0f7812ULL, 0x000fe200078ee20cULL, 0x0000000838377824ULL, 0x040fe200078e00ffULL,
0x00000002380c7810ULL, 0x040fe20007ffe0ffULL, 0x000000100b0b7824ULL, 0x000fe200078e0208ULL,
0x0000000338347810ULL, 0x040fe20007ffe0ffULL, 0x0000000838437824ULL, 0x040fe200078e00ffULL,
0xfffffff833337812ULL, 0x000fe200078ee20cULL, 0x0000000838457824ULL, 0x000fe200078e00ffULL,
0x0000000b460c7210ULL, 0x000fc40007ffe0ffULL, 0x00000004380b7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff837377812ULL, 0x000fe200078ee234ULL, 0x000000000c397984ULL, 0x0007e20000000800ULL,
0xfffffff8363d7812ULL, 0x000fe200078ee20bULL, 0x00000010330b7824ULL, 0x000fe200078e0208ULL,
0x0000000538347810ULL, 0x040fe40007ffe0ffULL, 0x00000003383b7819ULL, 0x000fe200000006ffULL,
0x00000001460b7824ULL, 0x000fe200078e020bULL, 0x0000030047007a0cULL, 0x000fc40003f06070ULL,
0xffffffff380c7810ULL, 0x008fe40007ffe0ffULL, 0x0000000107077810ULL, 0x000fe40007ffe0ffULL,
0xfffffff845457812ULL, 0x000fe400078ee20cULL, 0x0000000147477810ULL, 0x000fe20007ffe0ffULL,
0x00000009100a7221ULL, 0x002fe20000010100ULL, 0x000000080d097211ULL, 0x000fc600078e20ffULL,
0x3fb8aa3b0a0d7820ULL, 0x000fe40000410000ULL, 0x0000000146097824ULL, 0x040fe400078e0209ULL,
0x000000100f0a7824ULL, 0x000fe400078e0208ULL, 0x0000000d000d7308ULL, 0x000ea20000000800ULL,
0x0000000009357984ULL, 0x0002e20000000800ULL, 0x00000001460a7824ULL, 0x000fca00078e020aULL,
0x000000000a367984ULL, 0x000fe20000000800ULL, 0x0000000837097211ULL, 0x002fc600078e20ffULL,
0x000400000a3a7984ULL, 0x0003e40000000800ULL, 0x0000000146097824ULL, 0x000fe400078e0209ULL,
0x000000000b377984ULL, 0x000fe20000000800ULL, 0x0000000e0d0f7220ULL, 0x004fe20000410000ULL,
0xfffffff83b0d7812ULL, 0x000fe400078ee234ULL, 0x000400000b3b7984ULL, 0x000fe20000000800ULL,
0x00000006380e7810ULL, 0x000fe20007ffe0ffULL, 0x000000103d0a7824ULL, 0x002fe200078e0208ULL,
0x000000080d0c7211ULL, 0x000fe200078e20ffULL, 0x00001f380f337589ULL, 0x000e6200000e0000ULL,
0xfffffff843437812ULL, 0x000fe200078ee20eULL, 0x00000001460a7824ULL, 0x040fe200078e020aULL,
0x0000000c460c7210ULL, 0x000fe20007ffe0ffULL, 0x00001f3c0f347589ULL, 0x000ea200000e0000ULL,
0x000000320f327221ULL, 0x000fc40000010000ULL, 0x00000010430d7824ULL, 0x100fe200078e0208ULL,
0x0000000009387984ULL, 0x000f220000000800ULL, 0x0000001045087824ULL, 0x000fe400078e0208ULL,
0x00000001460d7824ULL, 0x040fe200078e020dULL, 0x00040000093c7984ULL, 0x0007220000000800ULL,
0x0000000146087824ULL, 0x000fc600078e0208ULL, 0x000000000a0b7984ULL, 0x000f220000000800ULL,
0x00005410ff0e7816ULL, 0x108fe40000000035ULL, 0x00007610ff097816ULL, 0x000fe20000000035ULL,
0x000400000a3d7984ULL, 0x0007240000000800ULL, 0x000000330e317223ULL, 0x082fe40000010031ULL,
0x000400000c357984ULL, 0x000e620000000800ULL, 0x0000003309307223ULL, 0x000fe20000010030ULL,
0x00007610ff097816ULL, 0x000fc40000000039ULL, 0x00005410ff0a7816ULL, 0x008fe20000000039ULL,
0x000000000c0e7984ULL, 0x000fe40000000800ULL, 0x00000034092e7223ULL, 0x084fe2000001002eULL,
0x00007610ff097816ULL, 0x100fe20000000036ULL, 0x000000340a2f7223ULL, 0x080fe2000001002fULL,
0x00005410ff0a7816ULL, 0x000fe20000000036ULL, 0x00000000080c7984ULL, 0x000fe40000000800ULL,
0x00000033092c7223ULL, 0x080fe2000001002cULL, 0x00007610ff097816ULL, 0x100fe2000000003aULL,
0x000000330a2d7223ULL, 0x080fe2000001002dULL, 0x00005410ff0a7816ULL, 0x000fe2000000003aULL,
0x000400000d367984ULL, 0x000ea40000000800ULL, 0x00000034092a7223ULL, 0x080fe2000001002aULL,
0x00007610ff097816ULL, 0x000fe20000000037ULL, 0x000000340a2b7223ULL, 0x000fe2000001002bULL,
0x00005410ff0a7816ULL, 0x000fe20000000037ULL, 0x000000000d0f7984ULL, 0x000fe40000000800ULL,
0x0000003309287223ULL, 0x080fe20000010028ULL, 0x00007610ff097816ULL, 0x000fe2000000003bULL,
0x000000330a297223ULL, 0x000fe20000010029ULL, 0x00005410ff0a7816ULL, 0x000fc6000000003bULL,
0x0000003409267223ULL, 0x080fe20000010026ULL, 0x00007610ff097816ULL, 0x010fe20000000038ULL,
0x000000340a277223ULL, 0x000fe40000010027ULL, 0x00040000080a7984ULL, 0x0007240000000800ULL,
0x0000003309247223ULL, 0x000fe20000010024ULL, 0x00007610ff097816ULL, 0x000fe4000000003cULL,
0x00005410ff087816ULL, 0x008fc60000000038ULL, 0x0000003409227223ULL, 0x000fe20000010022ULL,
0x00007610ff097816ULL, 0x000fe2000000000bULL, 0x0000003308257223ULL, 0x000fe20000010025ULL,
0x00005410ff087816ULL, 0x000fc6000000003cULL, 0x0000003309207223ULL, 0x000fe20000010020ULL,
0x00007610ff097816ULL, 0x000fe2000000003dULL, 0x0000003408237223ULL, 0x000fe20000010023ULL,
0x00005410ff087816ULL, 0x000fc6000000000bULL, 0x00000034091e7223ULL, 0x000fe2000001001eULL,
0x00005410ff097816ULL, 0x002fe20000000035ULL, 0x0000003308217223ULL, 0x000fe20000010021ULL,
0x00005410ff087816ULL, 0x000fc6000000003dULL, 0x00000034091c7223ULL, 0x080fe2000001001cULL,
0x00005410ff097816ULL, 0x004fe20000000036ULL, 0x00000034081f7223ULL, 0x000fe2000001001fULL,
0x00005410ff087816ULL, 0x000fc6000000000eULL, 0x00000034091a7223ULL, 0x000fe2000001001aULL,
0x00005410ff097816ULL, 0x000fe2000000000cULL, 0x0000003308177223ULL, 0x000fe20000010017ULL,
0x00007610ff087816ULL, 0x000fc6000000000eULL, 0x0000003309187223ULL, 0x080fe20000010018ULL,
0x00007610ff097816ULL, 0x000fe2000000000cULL, 0x00000033081d7223ULL, 0x000fe2000001001dULL,
0x00007610ff087816ULL, 0x000fc60000000035ULL, 0x0000003309167223ULL, 0x000fe20000010016ULL,
0x00005410ff097816ULL, 0x010fe2000000000aULL, 0x0000003408157223ULL, 0x000fe20000010015ULL,
0x00005410ff087816ULL, 0x000fc6000000000fULL, 0x0000003409147223ULL, 0x000fe20000010014ULL,
0x00007610ff097816ULL, 0x000fe2000000000aULL, 0x0000003308137223ULL, 0x000fe20000010013ULL,
0x00007610ff087816ULL, 0x000fc6000000000fULL, 0x0000003409127223ULL, 0x000fe40000010012ULL,
0x00000033081b7223ULL, 0x000fe2000001001bULL, 0x00007610ff087816ULL, 0x000fca0000000036ULL,
0x0000003408197223ULL, 0x000fe20000010019ULL, 0xfffff45000008947ULL, 0x000fea000383ffffULL,
0x0180000032047810ULL, 0x004fe20007ffe0ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x7f80000004047812ULL, 0x000fe200078ec0ffULL, 0x000000a000007945ULL, 0x000fe60003800000ULL,
0x01ffffff0400780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x0000d54000067802ULL, 0x000fc40000000f00ULL, 0x0000a2c000007944ULL, 0x000fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000003200057308ULL, 0x000e640000001000ULL,
0xbf80000005047423ULL, 0x002fc80000000032ULL, 0x800000ff04047221ULL, 0x000fc80000010100ULL,
0x0000000405047223ULL, 0x000fc40000000005ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000097919ULL, 0x000f280000000000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000002ff0b7819ULL, 0x010fc40000011609ULL, 0x00000008090d7811ULL, 0x000fe400078ff0ffULL,
0x000000040b0f7810ULL, 0x040fe20007ffe0ffULL, 0x00001f0b04067589ULL, 0x00cea200000e0000ULL,
0x000000080b117824ULL, 0x040fe200078e00ffULL, 0x000000020b0c7810ULL, 0x040fe20007ffe0ffULL,
0x000000080b107824ULL, 0x000fe200078e00ffULL, 0x00001f0d04077589ULL, 0x00072200000e0000ULL,
0x000000080d347824ULL, 0x000fe200078e00ffULL, 0x000000030b0e7810ULL, 0x040fe20007ffe0ffULL,
0x000000080b327824ULL, 0x002fe200078e00ffULL, 0xfffffff810107812ULL, 0x000fc400078ee20fULL,
0x000000050b0f7810ULL, 0x000fe40007ffe0ffULL, 0x0000000209097819ULL, 0x000fe200000006ffULL,
0x0000001010107824ULL, 0x000fe200078e0203ULL, 0xfffffff834347812ULL, 0x000fe400078ee20dULL,
0x0000000c09097812ULL, 0x000fc600078ec0ffULL, 0x0000001034347824ULL, 0x000fe400078e0203ULL,
0x0000003106317220ULL, 0x044fe40000410000ULL, 0x0000003006307220ULL, 0x040fe40000410000ULL,
0x0000002d062d7220ULL, 0x040fe40000410000ULL, 0x0000002c062c7220ULL, 0x000fe20000410000ULL,
0x000000313030723eULL, 0x000fe200000010ffULL, 0x0000002906297220ULL, 0x000fc40000410000ULL,
0x0000002806287220ULL, 0x000fe20000410000ULL, 0x0000002d2c2c723eULL, 0x000fe200000010ffULL,
0x0000002506257220ULL, 0x040fe40000410000ULL, 0x0000002406247220ULL, 0x000fe20000410000ULL,
0x000000292828723eULL, 0x000fe200000010ffULL, 0x0000002106217220ULL, 0x040fe40000410000ULL,
0x0000002006207220ULL, 0x000fe20000410000ULL, 0x000000252424723eULL, 0x000fe200000010ffULL,
0x0000001706177220ULL, 0x000fc40000410000ULL, 0x0000001d06047220ULL, 0x008fe20000410000ULL,
0x000000212020723eULL, 0x000fe200000010ffULL, 0x0000001306137220ULL, 0x040fe40000410000ULL,
0x0000001b06087220ULL, 0x040fe20000410000ULL, 0x000000030b1b7819ULL, 0x040fe200000006ffULL,
0x0000001806187220ULL, 0x000fe20000410000ULL, 0x000000170404723eULL, 0x000fe200000010ffULL,
0x0000001606057220ULL, 0x000fe20000410000ULL, 0x000000010b067810ULL, 0x000fe20007ffe0ffULL,
0x0000002f072f7220ULL, 0x010fe20000410000ULL, 0xfffffff81b0c7812ULL, 0x000fe200078ee20cULL,
0x0000002e072e7220ULL, 0x000fe20000410000ULL, 0xfffffff8110a7812ULL, 0x000fe200078ee206ULL,
0x000000080b067824ULL, 0x040fe200078e00ffULL, 0x000000060b117810ULL, 0x000fe20007ffe0ffULL,
0x0000002b072b7220ULL, 0x000fe20000410000ULL, 0xffffffff0b1b7810ULL, 0x000fe20007ffe0ffULL,
0x0000002a072a7220ULL, 0x040fe20000410000ULL, 0xfffffff806067812ULL, 0x000fe200078ee20bULL,
0x0000002707277220ULL, 0x040fe20000410000ULL, 0xfffffff832327812ULL, 0x000fe200078ee21bULL,
0x0000002607267220ULL, 0x040fe20000410000ULL, 0x000000130808723eULL, 0x000fe200000010ffULL,
0x0000002307237220ULL, 0x040fe20000410000ULL, 0x0000000332327211ULL, 0x000fe200078e20ffULL,
0x0000002207227220ULL, 0x000fe20000410000ULL, 0x000000180505723eULL, 0x000fe200000010ffULL,
0x0000001f071f7220ULL, 0x040fe20000410000ULL, 0x0000002f2e2e723eULL, 0x000fe200000010ffULL,
0x0000001e071e7220ULL, 0x040fe20000410000ULL, 0x0000002b2a2a723eULL, 0x000fe200000010ffULL,
0x0000001c071c7220ULL, 0x040fe20000410000ULL, 0x000000272626723eULL, 0x000fe200000010ffULL,
0x0000001507157220ULL, 0x040fe20000410000ULL, 0x000000232222723eULL, 0x000fe200000010ffULL,
0x0000001a071a7220ULL, 0x040fe20000410000ULL, 0x0000001f1e1e723eULL, 0x000fe200000010ffULL,
0x0000001907197220ULL, 0x000fe20000410000ULL, 0x0000001c1515723eULL, 0x000fe200000010ffULL,
0x0000001407147220ULL, 0x000fc40000410000ULL, 0x0000001207077220ULL, 0x000fe20000410000ULL,
0x000000030b127819ULL, 0x040fe200000006ffULL, 0x000000080b1d7824ULL, 0x000fe200078e00ffULL,
0x0000001a1919723eULL, 0x000fe200000010ffULL, 0x000000080b167824ULL, 0x000fe200078e00ffULL,
0xfffffff812127812ULL, 0x000fe200078ee20fULL, 0x0000001006067824ULL, 0x100fe200078e0203ULL,
0xfffffff81d0e7812ULL, 0x000fe200078ee20eULL, 0x000000100a0a7824ULL, 0x000fe200078e0203ULL,
0xfffffff816167812ULL, 0x000fe200078ee211ULL, 0x000000100c0c7824ULL, 0x100fe200078e0203ULL,
0x000000030e0e7211ULL, 0x000fe200078e20ffULL, 0x0000001012127824ULL, 0x100fe200078e0203ULL,
0x000000140707723eULL, 0x000fe200000010ffULL, 0x0000001016167824ULL, 0x000fe200078e0203ULL,
0x0000000c090d7210ULL, 0x000fe20007ffe0ffULL, 0x0000000106037824ULL, 0x000fc400078e0209ULL,
0x00000001090b7824ULL, 0x040fe200078e020aULL, 0x0000001609167210ULL, 0x040fe20007ffe0ffULL,
0x00000001090f7824ULL, 0x040fe200078e020eULL, 0x0000003003007388ULL, 0x0003e20000000800ULL,
0x0000000109117824ULL, 0x040fe400078e0210ULL, 0x0000000109127824ULL, 0x040fe200078e0212ULL,
0x0000002c0b007388ULL, 0x0003e20000000800ULL, 0x0000000109327824ULL, 0x040fe400078e0232ULL,
0x0000000109097824ULL, 0x000fe200078e0234ULL, 0x000000280d007388ULL, 0x0003e80000000800ULL,
0x000000240f007388ULL, 0x0003e80000000800ULL, 0x0000002011007388ULL, 0x0003e80000000800ULL,
0x0000000412007388ULL, 0x0003e80000000800ULL, 0x0000000816007388ULL, 0x0003e80000000800ULL,
0x0000000532007388ULL, 0x0003e80000000800ULL, 0x0000002e09007388ULL, 0x0003e80000000800ULL,
0x0004002a0b007388ULL, 0x0003e80000000800ULL, 0x000400260d007388ULL, 0x0003e80000000800ULL,
0x000400220f007388ULL, 0x0003e80000000800ULL, 0x0004001e11007388ULL, 0x0003e80000000800ULL,
0x0004001512007388ULL, 0x0003e80000000800ULL, 0x0004001916007388ULL, 0x0003e80000000800ULL,
0x0004000732007388ULL, 0x0003e20000000800ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00000000000c7919ULL, 0x00cea20000000000ULL, 0x00000000000579c3ULL, 0x000ee20000002700ULL,
0x0000580000047ab9ULL, 0x000fc40000000800ULL, 0x0000000000067919ULL, 0x000f220000002600ULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x000000200c0d7810ULL, 0x006fc60007ffe0ffULL,
0x00000005040472a4ULL, 0x008fe2000f8e023fULL, 0x00000003ff077819ULL, 0x100fe4000001160cULL,
0x00000003ff037819ULL, 0x000fe4000001160dULL, 0x000000070c0f7812ULL, 0x000fe200078ec0ffULL,
0x0000000107057824ULL, 0x000fe200078e020cULL, 0x000000030d047210ULL, 0x000fc80007ffe0ffULL,
0x0000000705057812ULL, 0x000fe400078ec0ffULL, 0x0000000704047812ULL, 0x000fe400078ec0ffULL,
0x0ffffff805097812ULL, 0x000fe400078ef80cULL, 0x0ffffff804057812ULL, 0x000fe400078ef80dULL,
0x000000070d0d7812ULL, 0x000fe200078ec0ffULL, 0x0000001009087824ULL, 0x100fe400078e0202ULL,
0x0000001005057824ULL, 0x000fe200078e0202ULL, 0x1ffffff80d0d7812ULL, 0x000fe200078ef800ULL,
0x0000000806027824ULL, 0x050fe200078e00ffULL, 0x0000000306067819ULL, 0x000fe200000006ffULL,
0x0120000008087984ULL, 0x000e660000000c00ULL, 0xfffffff802027812ULL, 0x000fe200078ee207ULL,
0x0120000005107984ULL, 0x0004e20000000c00ULL, 0xfffffff806037812ULL, 0x000fc400078ee203ULL,
0x0000000402077c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000403067c10ULL, 0x000fc6000ff3e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x00005a0007027a11ULL, 0x040fe200078048ffULL,
0x000000ffff057224ULL, 0x004fe200008e06ffULL, 0x00005a0006047a11ULL, 0x040fe400078248ffULL,
0x00005b0007037a11ULL, 0x000fe400000f4c0cULL, 0x1ffffff80f077812ULL, 0x000fe400078ef800ULL,
0x00005b0006057a11ULL, 0x000fc600008f4c05ULL, 0x0000001007027825ULL, 0x000fc800078e0002ULL,
0x000000100d047825ULL, 0x000fe200078e0004ULL, 0x0000000802007986ULL, 0x002fe8000c101d06ULL,
0x0000001004007986ULL, 0x008fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000017c007810ULL, 0x000fe20007ffe0ffULL,
0x0000000211117824ULL, 0x000fe200078e00ffULL, 0x000000067b2f7819ULL, 0x000fe200000006ffULL,
0x01c60000ff067f8cULL, 0x000ea2000c80043fULL, 0x000000790000720cULL, 0x000fe20003f06070ULL,
0x0000580011787a24ULL, 0x000fc400078e0278ULL, 0x000001007c037824ULL, 0x002fc800078e022fULL,
0x00006200781e7a24ULL, 0x000fcc00078e0203ULL, 0x00000b8000008947ULL, 0x000fea0003800000ULL,
0x00000003ff277819ULL, 0x100fe40000011604ULL, 0x000000037a007217ULL, 0x000fe40007800000ULL,
0x00000008270b7810ULL, 0x040fe20007ffe0ffULL, 0x000000011e097824ULL, 0x000fe200078e0227ULL,
0x0000000427057810ULL, 0x040fe20007ffe0ffULL, 0x0000000100007824ULL, 0x000fe200078e0a03ULL,
0x0000000c270d7810ULL, 0x000fe20007ffe0ffULL, 0x000000010b087824ULL, 0x140fe200078e0204ULL,
0x000000700e297812ULL, 0x000fe200078ec0ffULL, 0x000000080b1f7824ULL, 0x000fe200078e00ffULL,
0x00000003050c7819ULL, 0x040fe200000006ffULL, 0x0000000105037824ULL, 0x100fe200078e0204ULL,
0x0000001027117810ULL, 0x000fe20007ffe0ffULL, 0x000000010d0a7824ULL, 0x000fe200078e0204ULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee208ULL, 0x00005e0009087625ULL, 0x000fe200078e0002ULL,
0xfffffff80c1b7812ULL, 0x000fc400078ee203ULL, 0x000000030d217819ULL, 0x000fe200000006ffULL,
0x000000011e037824ULL, 0x000fe200078e0205ULL, 0x00000008290e7210ULL, 0x000fe40007f1e0ffULL,
0x000000000500720cULL, 0x000fe20003f86070ULL, 0x0000000111057824ULL, 0x000fe200078e0204ULL,
0xfffffff821217812ULL, 0x000fe200078ee20aULL, 0x000000ffff0f7224ULL, 0x000fe200000e0609ULL,
0x00000003110a7819ULL, 0x000fe200000006ffULL, 0x00005e0003087625ULL, 0x000fe200078e0002ULL,
0x000000000b00720cULL, 0x000fc40003f46070ULL, 0xfffffff80a237812ULL, 0x000fe200078ee205ULL,
0x000000011e0b7824ULL, 0x040fe200078e020bULL, 0x0000000829107210ULL, 0x000fe20007f3e0ffULL,
0x000000011e037824ULL, 0x040fe200078e020dULL, 0x0000001427197810ULL, 0x000fe20007ffe0ffULL,
0x00005e000b0a7625ULL, 0x000fe200078e0002ULL, 0x000000001100720cULL, 0x000fe40003f06070ULL,
0x000000111e057210ULL, 0x000fe20007ffe0ffULL, 0x000000ffff117224ULL, 0x000fe200008e0609ULL,
0x0000000a29127210ULL, 0x000fe20007fbe0ffULL, 0x00005e0003087625ULL, 0x000fe200078e0002ULL,
0x000000000d00720cULL, 0x000fc40003f66070ULL, 0x00000018272b7810ULL, 0x000fe20007ffe0ffULL,
0x000000011e0d7824ULL, 0x000fe200078e0219ULL, 0x0000000829147210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff137224ULL, 0x000fe200028e060bULL, 0x0000001c272d7810ULL, 0x000fe20007ffe0ffULL,
0x00005e00050a7625ULL, 0x000fe200078e0002ULL, 0x0000000427057210ULL, 0x000fe40007ffe0ffULL,
0x000020007b1c7811ULL, 0x000fe200078e70ffULL, 0x00005e000d0c7625ULL, 0x000fe200078e0002ULL,
0x0000000a29167210ULL, 0x000fc40007fbe0ffULL, 0x0000000705057812ULL, 0x000fe200078ec0ffULL,
0x000000011e037824ULL, 0x040fe200078e022bULL, 0x0000000c290c7210ULL, 0x000fe20007fde0ffULL,
0x000000ffff157224ULL, 0x000fe200008e0609ULL, 0x000000001900720cULL, 0x000fe20003f26070ULL,
0x00005e0003087625ULL, 0x000fe200078e0002ULL, 0x0000000dff0d7210ULL, 0x000fe400037fe4ffULL,
0x0ffffff805037812ULL, 0x100fe200078ef804ULL, 0x000000ffff177224ULL, 0x000fe200028e060bULL,
0x0000000829187210ULL, 0x000fe20007fde0ffULL, 0x00000001190a7824ULL, 0x000fe200078e0204ULL,
0x000000002700720cULL, 0x000fe20003fa6070ULL, 0x0000000819257824ULL, 0x000fe200078e00ffULL,
0x0000001c03037211ULL, 0x000fe200078e20ffULL, 0x000000ffff197224ULL, 0x000fe200030e0609ULL,
0x00000020271d7810ULL, 0x000fe20007ffe0ffULL, 0x000000011e097824ULL, 0x000fe200078e022dULL,
0xfffffff825257812ULL, 0x000fe200078ee20aULL, 0x000000101b057824ULL, 0x000fe200078e021cULL,
0x000000042b207210ULL, 0x000fe20007ffe0ffULL, 0x00005e0009087625ULL, 0x000fc800078e0002ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e037faeULL, 0x0003e2000e901c46ULL,
0x000000011e0b7824ULL, 0x000fe200078e021dULL, 0x00000008291a7210ULL, 0x000fe20007fde0ffULL,
0x000000012d087824ULL, 0x040fe200078e0204ULL, 0x0000000010057faeULL, 0x0007e2000e101c46ULL,
0x000000002d00720cULL, 0x000fe20003f86070ULL, 0x00005e000b0a7625ULL, 0x000fe200078e0002ULL,
0x00000009ff1b7210ULL, 0x000fe400037fe4ffULL, 0x000000002b00720cULL, 0x000fe20003fa6070ULL,
0x000000082d2d7824ULL, 0x000fe200078e00ffULL, 0x0000000a290a7210ULL, 0x000fe20007fde0ffULL,
0x000000082b2b7824ULL, 0x000fc400078e00ffULL, 0x000000101f037824ULL, 0x002fe200078e021cULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee208ULL, 0x0000001021057824ULL, 0x008fe200078e021cULL,
0x0000002427117810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0b7224ULL, 0x000fe200030e060bULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee220ULL, 0x0000000012037faeULL, 0x0003e2000d101c46ULL,
0x000000111e097210ULL, 0x000fe20007ffe0ffULL, 0x000000011d0f7824ULL, 0x000fe200078e0204ULL,
0x000000001100720cULL, 0x000fe20003f46070ULL, 0x000000081d207824ULL, 0x000fe200078e00ffULL,
0x0000000014057faeULL, 0x0007e2000d901c46ULL, 0x00005e0009087625ULL, 0x000fe200078e0002ULL,
0x000000001d00720cULL, 0x000fc40003f66070ULL, 0x00000028271d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000111107824ULL, 0x000fe200078e0204ULL, 0x00000008290e7210ULL, 0x000fe20007fde0ffULL,
0x0000001023037824ULL, 0x102fe200078e021cULL, 0x0000000311117819ULL, 0x000fe400000006ffULL,
0xfffffff820137812ULL, 0x000fe200078ee20fULL, 0x000000ffff0f7224ULL, 0x000fe200030e0609ULL,
0x0000001c2b097211ULL, 0x000fe200078e20ffULL, 0x0000001025057824ULL, 0x008fe200078e021cULL,
0xfffffff811157812ULL, 0x000fe200078ee210ULL, 0x000000102d117824ULL, 0x100fe200078e021cULL,
0x0000000016037faeULL, 0x0003e2000c101c46ULL, 0x0000001013137824ULL, 0x100fe200078e021cULL,
0x000000031d087819ULL, 0x000fe200000006ffULL, 0x0000001015157824ULL, 0x000fe200078e021cULL,
0x000000000c057faeULL, 0x0007e2000c901c46ULL, 0x0000002c271f7810ULL, 0x000fc40007ffe0ffULL,
0x0000003027217810ULL, 0x040fe20007ffe0ffULL, 0x0000000018097faeULL, 0x0009e2000e901c46ULL,
0x0000003427237810ULL, 0x040fe40007ffe0ffULL, 0x0000003827257810ULL, 0x000fe20007ffe0ffULL,
0x000000011d037824ULL, 0x102fe200078e0204ULL, 0x000000001a117faeULL, 0x0003e2000e101c46ULL,
0x0000003c27277810ULL, 0x000fe20007ffe0ffULL, 0x000000081f177824ULL, 0x000fe200078e00ffULL,
0x000000001d00720cULL, 0x080fe20003fc6070ULL, 0x000000000a137faeULL, 0x0005e2000d901c46ULL,
0x000000001f00720cULL, 0x080fe20003fa6070ULL, 0x0000000121057824ULL, 0x048fe200078e0204ULL,
0x000000002100720cULL, 0x080fe20003f86070ULL, 0x000000011e097824ULL, 0x010fe200078e021dULL,
0x000000000e157faeULL, 0x0007e2000d101c46ULL, 0x000000002300720cULL, 0x0c0fe20003f66070ULL,
0x0000000823197824ULL, 0x000fe200078e00ffULL, 0x000000002500720cULL, 0x0c0fe20003f26070ULL,
0x00000008251b7824ULL, 0x002fe200078e00ffULL, 0x000000002700720cULL, 0x000fc40003f06070ULL,
0xfffffff808137812ULL, 0x004fe200078ee203ULL, 0x00005e0009087625ULL, 0x000fe200078e0002ULL,
0x000000041f007210ULL, 0x000fe40007ffe0ffULL, 0x0000000321107819ULL, 0x000fe200000006ffULL,
0x000000011e0b7824ULL, 0x040fe200078e021fULL, 0x00000008290c7210ULL, 0x000fe20007f5e0ffULL,
0x000000011e037824ULL, 0x000fe200078e0221ULL, 0xfffffff817177812ULL, 0x000fe200078ee200ULL,
0x00005e000b0a7625ULL, 0x000fe200078e0002ULL, 0xfffffff810157812ULL, 0x008fc400078ee205ULL,
0x000000271e057210ULL, 0x040fe20007ffe0ffULL, 0x000000ffff0d7224ULL, 0x000fe200010e0609ULL,
0x0000000a290e7210ULL, 0x000fe20007f5e0ffULL, 0x00005e0003087625ULL, 0x000fe200078e0002ULL,
0x0000000327127819ULL, 0x000fe400000006ffULL, 0x0000001c17177211ULL, 0x000fe200078e20ffULL,
0x0000000123007824ULL, 0x000fe200078e0204ULL, 0x000000231e237210ULL, 0x040fe20007ffe0ffULL,
0x000000ffff0f7224ULL, 0x000fe200010e060bULL, 0x0000000829107210ULL, 0x000fe20007f5e0ffULL,
0x000000011e037824ULL, 0x000fe200078e0225ULL, 0xfffffff819197812ULL, 0x000fe200078ee200ULL,
0x00005e00230a7625ULL, 0x000fc800078e0002ULL, 0x000000ffff117224ULL, 0x000fe200010e0609ULL,
0x0000000a290a7210ULL, 0x000fe20007f5e0ffULL, 0x00005e0003087625ULL, 0x000fc800078e0002ULL,
0x0000000127037824ULL, 0x100fe400078e0204ULL, 0x0000000125007824ULL, 0x000fe400078e0204ULL,
0x000000ffff0b7224ULL, 0x000fe200010e060bULL, 0x0000000829047210ULL, 0x000fe20007f5e0ffULL,
0x0000001013137824ULL, 0x000fe200078e021cULL, 0xfffffff8121d7812ULL, 0x000fe200078ee203ULL,
0x00005e0005027625ULL, 0x000fe200078e0002ULL, 0xfffffff81b1b7812ULL, 0x000fe400078ee200ULL,
0x0000001c1d1d7211ULL, 0x000fe200078e20ffULL, 0x000000ffff057224ULL, 0x000fe200010e0609ULL,
0x0000000229027210ULL, 0x000fe20007f5e0ffULL, 0x0000001015157824ULL, 0x100fe200078e021cULL,
0x000000000c137faeULL, 0x0003e2000f101c46ULL, 0x0000001019197824ULL, 0x000fc400078e021cULL,
0x000000101b1b7824ULL, 0x000fe200078e021cULL, 0x000000000e177faeULL, 0x0003e2000e901c46ULL,
0x000000ffff037224ULL, 0x000fc600010e0603ULL, 0x0000000010157faeULL, 0x0003e8000e101c46ULL,
0x000000000a197faeULL, 0x0003e8000d901c46ULL, 0x00000000041b7faeULL, 0x0003e8000c901c46ULL,
0x00000000021d7faeULL, 0x0003e2000c101c46ULL, 0x00000a4000007947ULL, 0x000fea0003800000ULL,
0x0000001004197811ULL, 0x040fe400078fe8ffULL, 0x00000004040b7811ULL, 0x000fc400078fe8ffULL,
0x0000000419087210ULL, 0x0c0fe20007ffe0ffULL, 0x0000000819117824ULL, 0x000fe200078e00ffULL,
0x00000008040d7811ULL, 0x040fe200078fe8ffULL, 0x000000010b007824ULL, 0x040fe200078e0204ULL,
0x00000014041b7811ULL, 0x040fe200078fe8ffULL, 0x000000080b097824ULL, 0x000fe200078e00ffULL,
0xfffffff811207812ULL, 0x000fe200078ee208ULL, 0x000000080d1a7824ULL, 0x000fe200078e00ffULL,
0x0000002004117811ULL, 0x000fe200078fe8ffULL, 0x000000081b227824ULL, 0x000fe200078e00ffULL,
0x000000040d037210ULL, 0x000fc40007ffe0ffULL, 0xfffffff809187812ULL, 0x000fe200078ee200ULL,
0x0000000811137824ULL, 0x040fe200078e00ffULL, 0x0000000411007210ULL, 0x080fe40007ffe0ffULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee203ULL, 0x000000011b037824ULL, 0x000fe200078e0204ULL,
0x0000001c041f7811ULL, 0x040fe400078fe8ffULL, 0xfffffff813007812ULL, 0x000fe400078ee200ULL,
0x0000002404137811ULL, 0x040fe200078fe8ffULL, 0x000000011f087824ULL, 0x140fe200078e0204ULL,
0x0000000c040f7811ULL, 0x000fe200078fe8ffULL, 0x000000081f097824ULL, 0x000fe200078e00ffULL,
0xfffffff822227812ULL, 0x000fe200078ee203ULL, 0x0000000113037824ULL, 0x140fe200078e0204ULL,
0x0000003004257811ULL, 0x040fe200078fe8ffULL, 0x00000008130c7824ULL, 0x000fe200078e00ffULL,
0x00000018041d7811ULL, 0x040fe200078fe8ffULL, 0x000000010f057824ULL, 0x000fe200078e0204ULL,
0xfffffff809267812ULL, 0x000fe200078ee208ULL, 0x000000080f1c7824ULL, 0x000fe200078e00ffULL,
0x0000002c04177811ULL, 0x000fe200078fe8ffULL, 0x0000000825167824ULL, 0x040fe200078e00ffULL,
0x0000000425097210ULL, 0x080fe20007ffe0ffULL, 0x000000081d247824ULL, 0x000fe200078e00ffULL,
0xfffffff80c0c7812ULL, 0x000fe200078ee203ULL, 0x0000000117087824ULL, 0x040fe200078e0204ULL,
0x0000000404037211ULL, 0x000fe200078fe8ffULL, 0x0000000817217824ULL, 0x000fe200078e00ffULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee205ULL, 0x000000011e3f7824ULL, 0x000fe200078e0225ULL,
0x0000002804157811ULL, 0x000fc400078fe8ffULL, 0x000000041d057210ULL, 0x000fe40007ffe0ffULL,
0xfffffff816167812ULL, 0x000fe200078ee209ULL, 0x0000000815127824ULL, 0x000fe200078e00ffULL,
0x0000001e04097211ULL, 0x040fe400078fe8ffULL, 0x0000003404277811ULL, 0x040fe400078fe8ffULL,
0x0000003804297811ULL, 0x040fe400078fe8ffULL, 0x00000007032d7812ULL, 0x000fe200078ec0ffULL,
0x000000010d037824ULL, 0x100fe200078e021eULL, 0x0000003c042b7811ULL, 0x000fe200078fe8ffULL,
0x00000001190d7824ULL, 0x100fe200078e021eULL, 0xfffffff824247812ULL, 0x000fe200078ee205ULL,
0x000000011d197824ULL, 0x000fe200078e021eULL, 0x0000000415057210ULL, 0x000fe20007ffe0ffULL,
0x000000011e1d7824ULL, 0x040fe200078e0211ULL, 0xfffffff821147812ULL, 0x000fe200078ee208ULL,
0x000000011e217824ULL, 0x000fe200078e0215ULL, 0x0ffffff82d257812ULL, 0x100fe200078ef804ULL,
0x00000001270a7824ULL, 0x100fe200078e0204ULL, 0x000000700e4f7812ULL, 0x000fe200078ec0ffULL,
0x0000000129117824ULL, 0x000fe200078e0204ULL, 0xfffffff812127812ULL, 0x000fe200078ee205ULL,
0x00005e0009087625ULL, 0x000fe200078e0002ULL, 0x000020007b4d7811ULL, 0x000fc400078e70ffULL,
0x0000002b1e4b7210ULL, 0x000fe20007ffe0ffULL, 0x000000012b047824ULL, 0x040fe200078e0204ULL,
0x0000004f08107210ULL, 0x000fe20007f1e0ffULL, 0x000000082b157824ULL, 0x000fe200078e00ffULL,
0x0000004d16417211ULL, 0x080fe200078e20ffULL, 0x000000010b057824ULL, 0x000fe200078e021eULL,
0x0000001e0f0b7210ULL, 0x080fe20007ffe0ffULL, 0x0000000829287824ULL, 0x000fe200078e00ffULL,
0xfffffff815157812ULL, 0x000fe200078ee204ULL, 0x000000011b0f7824ULL, 0x000fe200078e021eULL,
0x0000001e1f1b7210ULL, 0x000fe20007ffe0ffULL, 0x000000011e437824ULL, 0x000fe200078e0227ULL,
0x0000000327277819ULL, 0x000fe200000006ffULL, 0x00005e0005047625ULL, 0x000fe200078e0002ULL,
0x0000004d25257211ULL, 0x000fc400078e20ffULL, 0xfffffff8270e7812ULL, 0x000fe200078ee20aULL,
0x000000011e1f7824ULL, 0x000fe200078e0213ULL, 0xfffffff828137812ULL, 0x000fe200078ee211ULL,
0x000000ffff117224ULL, 0x000fe200000e0609ULL, 0x0000004d202d7211ULL, 0x080fe200078e20ffULL,
0x00005e0003087625ULL, 0x080fe200078e0002ULL, 0x0000004d00377211ULL, 0x000fe400078e20ffULL,
0x000000171e237210ULL, 0x000fe20007ffe0ffULL, 0x000000100c397824ULL, 0x100fe200078e024dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010257faeULL, 0x0003e2000b901c46ULL,
0x00000010123b7824ULL, 0x000fe200078e024dULL, 0x0000004f04127210ULL, 0x000fe20007f1e0ffULL,
0x00005e000d0c7625ULL, 0x000fc800078e0002ULL, 0x00005e000b0a7625ULL, 0x000fc800078e0002ULL,
0x00000010143d7824ULL, 0x100fe200078e024dULL, 0x0000004f08147210ULL, 0x000fe20007f3e0ffULL,
0x0000001013497824ULL, 0x100fe200078e024dULL, 0x00000005ff137210ULL, 0x000fe200007fe4ffULL,
0x0000001018277824ULL, 0x100fe200078e024dULL, 0x0000004f0c187210ULL, 0x080fe20007f1e0ffULL,
0x000000100e457824ULL, 0x000fe200078e024dULL, 0x0000004f0a167210ULL, 0x000fe20007f5e0ffULL,
0x00005e000f0e7625ULL, 0x000fe200078e0002ULL, 0x0000000012277faeULL, 0x0003e6000b901c46ULL,
0x000000011e477824ULL, 0x000fc400078e0229ULL, 0x00005e0019047625ULL, 0x000fc800078e0002ULL,
0x000000101a297824ULL, 0x100fe400078e024dULL, 0x000000101c2b7824ULL, 0x100fe400078e024dULL,
0x0000001022317824ULL, 0x100fe400078e024dULL, 0x0000001024337824ULL, 0x100fe400078e024dULL,
0x0000001026357824ULL, 0x100fe400078e024dULL, 0x00000010154d7824ULL, 0x000fc400078e024dULL,
0x000000ffff157224ULL, 0x000fe200008e0609ULL, 0x0000004f0e1a7210ULL, 0x000fe20007f3e0ffULL,
0x00005e001b087625ULL, 0x000fc600078e0002ULL, 0x0000000fff1b7210ULL, 0x000fe20000ffe4ffULL,
0x000000ffff197224ULL, 0x000fe200000e060dULL, 0x0000004f041c7210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff177224ULL, 0x000fe200010e060bULL, 0x0000004f081e7210ULL, 0x080fe20007f3e0ffULL,
0x00005e001d0a7625ULL, 0x080fe200078e0002ULL, 0x0000000014297faeULL, 0x0003e6000b901c46ULL,
0x00005e001f0c7625ULL, 0x080fe200078e0002ULL, 0x00000000162b7faeULL, 0x0003e6000b901c46ULL,
0x000000ffff1d7224ULL, 0x000fe200000e0605ULL, 0x0000004f0a207210ULL, 0x080fe20007f1e0ffULL,
0x00005e0023047625ULL, 0x080fe200078e0002ULL, 0x00000000182d7faeULL, 0x0003e6000b901c46ULL,
0x00005e00210e7625ULL, 0x080fe200078e0002ULL, 0x000000001a317faeULL, 0x0003e6000b901c46ULL,
0x000000ffff1f7224ULL, 0x000fe200008e0609ULL, 0x0000004f0c227210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff217224ULL, 0x000fe200000e060bULL, 0x0000004f04047210ULL, 0x080fe20007f1e0ffULL,
0x00005e003f087625ULL, 0x080fe200078e0002ULL, 0x0000004f0e0e7210ULL, 0x000fe20007f5e0ffULL,
0x000000001c337faeULL, 0x0003e2000b901c46ULL, 0x0000000dff237210ULL, 0x000fe20000ffe4ffULL,
0x00005e00430a7625ULL, 0x000fc400078e0002ULL, 0x000000001e357faeULL, 0x0003e4000b901c46ULL,
0x00005e00470c7625ULL, 0x080fe200078e0002ULL, 0x0000004f0a0a7210ULL, 0x000fe20007f3e0ffULL,
0x0000000020377faeULL, 0x0003e4000b901c46ULL, 0x00005e004b027625ULL, 0x000fe200078e0002ULL,
0x0000000bff0b7210ULL, 0x000fe20000ffe4ffULL, 0x0000000022397faeULL, 0x0003e4000b901c46ULL,
0x000000ffff057224ULL, 0x000fe200000e0605ULL, 0x0000004f08087210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200010e060fULL, 0x0000004f0c0c7210ULL, 0x000fc40007f5e0ffULL,
0x0000004f02027210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff097224ULL, 0x000fe200000e0609ULL,
0x000000000e3b7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff0d7224ULL, 0x000fe400010e060dULL,
0x000000ffff037224ULL, 0x000fe200018e0603ULL, 0x00000000043d7faeULL, 0x0003e8000b901c46ULL,
0x0000000008417faeULL, 0x0003e8000b901c46ULL, 0x000000000a457faeULL, 0x0003e8000b901c46ULL,
0x000000000c497faeULL, 0x0003e8000b901c46ULL, 0x00000000024d7faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000027805ULL, 0x002fc40000015200ULL,
0x01c60400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x006fc40007804807ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff087224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000047805ULL, 0x000fcc0000015200ULL, 0x0000000402097210ULL, 0x000fc80007f1e1ffULL,
0x0000000503057210ULL, 0x000fe400007fe5ffULL, 0x003d09000900780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400900780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011405ULL,
0x0000000900007211ULL, 0x000fca00078110ffULL, 0x000000ffff057224ULL, 0x000fca00000e0605ULL,
0x0000000200007819ULL, 0x000fc80000001205ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000108087810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01c60400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000797c00720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000e620000000000ULL, 0x0001c6887b2e7811ULL, 0x040fe200078e18ffULL,
0x000000207b027824ULL, 0x000fe200078e00ffULL, 0xffffffff792d7810ULL, 0x000fc40007ffe0ffULL,
0x000001007c037824ULL, 0x000fe200078e022fULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x000000037a00720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x00cfea0003800000ULL,
0x000000017c047810ULL, 0x000fe20007ffe0ffULL, 0x00006200782a7a24ULL, 0x000fc600078e0203ULL,
0x000000790400720cULL, 0x000fda0003f06070ULL, 0x00000a9000008947ULL, 0x000fea0003800000ULL,
0x00000003ff1d7819ULL, 0x102fe40000011600ULL, 0x0ffffff800a57812ULL, 0x000fe400078ec0ffULL,
0x000000041d097810ULL, 0x040fe40007ffe0ffULL, 0x0000000c1d0d7810ULL, 0x040fe40007ffe0ffULL,
0x000000101d0f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000809157824ULL, 0x040fe200078e00ffULL,
0x0000000009047210ULL, 0x080fe20007ffe0ffULL, 0x000000080d087824ULL, 0x000fe200078e00ffULL,
0x000000081d0b7810ULL, 0x000fe20007ffe0ffULL, 0x000000010f067824ULL, 0x000fe200078e0200ULL,
0x000000141d1f7810ULL, 0x000fe20007ffe0ffULL, 0x000000080f1b7824ULL, 0x000fe200078e00ffULL,
0x000000000d057210ULL, 0x000fe20007ffe0ffULL, 0x000000080b177824ULL, 0x000fe200078e00ffULL,
0x0000001c1d277810ULL, 0x000fe20007ffe0ffULL, 0x000000081f0a7824ULL, 0x000fe200078e00ffULL,
0xfffffff815157812ULL, 0x000fe200078ee204ULL, 0x000000010b047824ULL, 0x000fe200078e0200ULL,
0x000000201d2b7810ULL, 0x000fc40007ffe0ffULL, 0x000000001f077210ULL, 0x080fe40007ffe0ffULL,
0xfffffff808197812ULL, 0x000fe200078ee205ULL, 0x0000000827087824ULL, 0x000fe200078e00ffULL,
0x000000181d237810ULL, 0x000fe20007ffe0ffULL, 0x000000082b317824ULL, 0x000fe200078e00ffULL,
0x000000241d337810ULL, 0x000fe40007ffe0ffULL, 0x0000000027057210ULL, 0x080fe20007ffe0ffULL,
0x0000000823257824ULL, 0x000fe200078e00ffULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee206ULL,
0x000000012b067824ULL, 0x000fe200078e0200ULL, 0xfffffff817177812ULL, 0x000fe200078ee204ULL,
0x0000000123047824ULL, 0x000fe200078e0200ULL, 0xfffffff80a217812ULL, 0x000fe200078ee207ULL,
0x00000008330a7824ULL, 0x040fe200078e00ffULL, 0x0000000033077210ULL, 0x000fc40007ffe0ffULL,
0xfffffff808297812ULL, 0x000fe200078ee205ULL, 0x000000017a057824ULL, 0x000fe200078e0a03ULL,
0xfffffff831317812ULL, 0x000fe400078ee206ULL, 0xfffffff825257812ULL, 0x000fe200078ee204ULL,
0x00000200ff047424ULL, 0x000fe200078e00ffULL, 0xfffffff80a357812ULL, 0x000fe200078ee207ULL,
0x000000011d077824ULL, 0x040fe200078e022aULL, 0x000000001d067210ULL, 0x000fe40007ffe0ffULL,
0x0000000700a77812ULL, 0x000fc400078ec0ffULL, 0x000000050900720cULL, 0x0c0fe20003f46070ULL,
0x0000000109097824ULL, 0x100fe200078e022aULL, 0x000000051d00720cULL, 0x080fe40003f26070ULL,
0x000000050b00720cULL, 0x0c0fe20003f66070ULL, 0x000000010b0b7824ULL, 0x000fe200078e022aULL,
0x000000050d00720cULL, 0x080fe20003f86070ULL, 0x00005e0009087625ULL, 0x000fe200078e0004ULL,
0x00000007a5117812ULL, 0x000fe400078ef806ULL, 0x0000002a0d0d7210ULL, 0x000fe20007ffe0ffULL,
0x00005e0007067625ULL, 0x000fe200078e0004ULL, 0x000000050f00720cULL, 0x000fc40003fa6070ULL,
0x000040007b127811ULL, 0x000fe200078e70ffULL, 0x000000010f0f7824ULL, 0x000fe200078e022aULL,
0x00000008a7137812ULL, 0x000fe200078efcffULL, 0x00005e000b0a7625ULL, 0x000fe200078e0004ULL,
0x0000001217177211ULL, 0x000fc600078e20ffULL, 0x00005e000d0c7625ULL, 0x000fc800078e0004ULL,
0x00005e000f0e7625ULL, 0x000fc800078e0004ULL, 0x0000001013067825ULL, 0x000fc800078e0006ULL,
0x0000001011117824ULL, 0x100fe400078e0212ULL, 0x0000001015157824ULL, 0x000fe400078e0212ULL,
0x0000001013087825ULL, 0x000fe200078e0008ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006117faeULL, 0x0003e2000c901c46ULL, 0x000000051f00720cULL, 0x080fe40003f26070ULL,
0x00000010130a7825ULL, 0x000fe200078e000aULL, 0x0000000008157faeULL, 0x0005e2000d101c46ULL,
0x000000052300720cULL, 0x000fc40003f46070ULL, 0x0000001019197824ULL, 0x000fe200078e0212ULL,
0x000000000a177faeULL, 0x0007e2000d901c46ULL, 0x00000010130c7825ULL, 0x000fe200078e000cULL,
0x000000052700720cULL, 0x000fc60003f66070ULL, 0x000000101b1b7824ULL, 0x000fe200078e0212ULL,
0x000000000c197faeULL, 0x0009e2000e101c46ULL, 0x00000010130e7825ULL, 0x000fe200078e000eULL,
0x0000002a23097210ULL, 0x004fe40007ffe0ffULL, 0x000000052b00720cULL, 0x080fe20003f86070ULL,
0x000000011f077824ULL, 0x102fe200078e022aULL, 0x000000000e1b7faeULL, 0x0003e2000e901c46ULL,
0x0000000127157824ULL, 0x000fe200078e022aULL, 0x000000053300720cULL, 0x000fe20003fa6070ULL,
0x00005e0007067625ULL, 0x000fe200078e0004ULL, 0x000000301d1f7810ULL, 0x000fc40007ffe0ffULL,
0x000000381d237810ULL, 0x000fe20007ffe0ffULL, 0x000000012b177824ULL, 0x008fe400078e022aULL,
0x00005e0009087625ULL, 0x000fe200078e0004ULL, 0x0000002a330f7210ULL, 0x002fc60007ffe0ffULL,
0x00005e00150a7625ULL, 0x000fe200078e0004ULL, 0x0000002c1d1b7810ULL, 0x000fc60007ffe0ffULL,
0x00005e00170c7625ULL, 0x010fc800078e0004ULL, 0x0000001021117824ULL, 0x000fe200078e0212ULL,
0x000000341d217810ULL, 0x000fe20007ffe0ffULL, 0x0000001013067825ULL, 0x000fc800078e0006ULL,
0x00005e000f0e7625ULL, 0x000fe200078e0004ULL, 0x0000000006117faeULL, 0x0003e6000c901c46ULL,
0x0000001025157824ULL, 0x000fe200078e0212ULL, 0x0000003c1d257810ULL, 0x000fe20007ffe0ffULL,
0x0000001013087825ULL, 0x000fc600078e0008ULL, 0x000000052500720cULL, 0x080fe20003fc6070ULL,
0x0000001029177824ULL, 0x000fe200078e0212ULL, 0x0000000008157faeULL, 0x0005e2000d101c46ULL,
0x00000010130a7825ULL, 0x000fe200078e000aULL, 0x0000001235077211ULL, 0x002fe400078e20ffULL,
0x000000281d117810ULL, 0x000fe20007ffe0ffULL, 0x0000001031197824ULL, 0x000fe200078e0212ULL,
0x000000000a177faeULL, 0x0003e2000d901c46ULL, 0x00000010130c7825ULL, 0x000fe200078e000cULL,
0x000000051100720cULL, 0x000fc40003f26070ULL, 0x000000051b00720cULL, 0x080fe20003f46070ULL,
0x00000010130e7825ULL, 0x000fe200078e000eULL, 0x000000000c197faeULL, 0x0007e2000e101c46ULL,
0x000000031b087819ULL, 0x004fe400000006ffULL, 0x0000000111067824ULL, 0x040fe200078e0200ULL,
0x000000000e077faeULL, 0x0005e2000e901c46ULL, 0x0000000811097824ULL, 0x000fe200078e00ffULL,
0x000000051f00720cULL, 0x0c0fe20003f66070ULL, 0x000000081f177824ULL, 0x002fe200078e00ffULL,
0x000000052100720cULL, 0x080fe20003f86070ULL, 0x00000008231d7824ULL, 0x040fe200078e00ffULL,
0x000000052300720cULL, 0x000fe20003fa6070ULL, 0x000000011f0b7824ULL, 0x000fe200078e022aULL,
0xfffffff809057812ULL, 0x000fe200078ee206ULL, 0x0000000125097824ULL, 0x100fe200078e0200ULL,
0x00000003210a7819ULL, 0x000fe200000006ffULL, 0x000000011f067824ULL, 0x100fe200078e0200ULL,
0x00000003250c7819ULL, 0x008fe200000006ffULL, 0x000000011b077824ULL, 0x004fe200078e0200ULL,
0x0000002a210d7210ULL, 0x000fe20007ffe0ffULL, 0x00000001230f7824ULL, 0x100fe200078e022aULL,
0xfffffff80c277812ULL, 0x000fe200078ee209ULL, 0x000000011b097824ULL, 0x000fe200078e022aULL,
0xfffffff808157812ULL, 0x000fe200078ee207ULL, 0x0000000121077824ULL, 0x000fe200078e0200ULL,
0xfffffff817177812ULL, 0x000fe200078ee206ULL, 0x0000000123087824ULL, 0x000fe200078e0200ULL,
0x00000012271b7211ULL, 0x000fe200078e20ffULL, 0x00005e000d0c7625ULL, 0x000fe200078e0004ULL,
0xfffffff80a197812ULL, 0x000fc400078ee207ULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee208ULL,
0x0000000111077824ULL, 0x100fe400078e022aULL, 0x0000000125117824ULL, 0x000fe400078e022aULL,
0x00005e0007067625ULL, 0x000fc800078e0004ULL, 0x00005e0009087625ULL, 0x000fc800078e0004ULL,
0x00005e000b0a7625ULL, 0x000fc800078e0004ULL, 0x00005e000f0e7625ULL, 0x000fc800078e0004ULL,
0x00005e0011107625ULL, 0x000fc800078e0004ULL, 0x0000001013067825ULL, 0x000fc800078e0006ULL,
0x0000001013087825ULL, 0x000fc800078e0008ULL, 0x00000010130a7825ULL, 0x000fc800078e000aULL,
0x00000010130c7825ULL, 0x000fc800078e000cULL, 0x00000010130e7825ULL, 0x000fc800078e000eULL,
0x0000001013107825ULL, 0x000fe200078e0010ULL, 0x0000001215137211ULL, 0x000fc600078e20ffULL,
0x0000001005057824ULL, 0x100fe400078e0212ULL, 0x0000001017157824ULL, 0x100fe400078e0212ULL,
0x0000001019177824ULL, 0x100fe200078e0212ULL, 0x0000000006057faeULL, 0x0003e2000c901c46ULL,
0x000000101d197824ULL, 0x000fc600078e0212ULL, 0x0000000008137faeULL, 0x0003e8000d101c46ULL,
0x000000000a157faeULL, 0x0003e8000d901c46ULL, 0x000000000c177faeULL, 0x0003e8000e101c46ULL,
0x000000000e197faeULL, 0x0003e8000e901c46ULL, 0x00000000101b7faeULL, 0x0003e2000f101c46ULL,
0x0000096000007947ULL, 0x000fea0003800000ULL, 0x0000000c000d7811ULL, 0x042fe400078fe8ffULL,
0x0000000400097811ULL, 0x000fc400078fe8ffULL, 0x00000008000b7811ULL, 0x040fe200078fe8ffULL,
0x000000010d067824ULL, 0x140fe200078e0200ULL, 0x0000001800137811ULL, 0x040fe200078fe8ffULL,
0x000000080d2b7824ULL, 0x000fe200078e00ffULL, 0x0000001c00157811ULL, 0x040fe200078fe8ffULL,
0x0000000109047824ULL, 0x140fe200078e0200ULL, 0x00000010000f7811ULL, 0x040fe200078fe8ffULL,
0x0000000809277824ULL, 0x000fe200078e00ffULL, 0x000000030b087819ULL, 0x040fe200000006ffULL,
0x000000010b057824ULL, 0x000fe200078e0200ULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee206ULL,
0x0000000113067824ULL, 0x100fe200078e0200ULL, 0x0000001400117811ULL, 0x040fe200078fe8ffULL,
0x0000000115077824ULL, 0x000fe200078e0200ULL, 0xfffffff827277812ULL, 0x000fe200078ee204ULL,
0x00000008150a7824ULL, 0x000fe200078e00ffULL, 0x0000000313357819ULL, 0x000fe200000006ffULL,
0x000000010f047824ULL, 0x000fe200078e0200ULL, 0x00000028001b7811ULL, 0x040fe200078fe8ffULL,
0x0000000109097824ULL, 0x100fe200078e022aULL, 0x0000002c001d7811ULL, 0x040fe200078fe8ffULL,
0x000000010b0b7824ULL, 0x100fe200078e022aULL, 0x000000030f317819ULL, 0x000fe200000006ffULL,
0x000000010d0d7824ULL, 0x100fe200078e022aULL, 0x0000002000177811ULL, 0x000fe200078fe8ffULL,
0x0000000113137824ULL, 0x000fe200078e022aULL, 0xfffffff808297812ULL, 0x000fe200078ee205ULL,
0x0000000111057824ULL, 0x000fe200078e0200ULL, 0xfffffff835357812ULL, 0x000fe200078ee206ULL,
0x0000000811087824ULL, 0x000fe200078e00ffULL, 0xfffffff80a377812ULL, 0x000fe200078ee207ULL,
0x000000011b067824ULL, 0x100fe200078e0200ULL, 0x0000002400197811ULL, 0x000fe200078fe8ffULL,
0x000000011d077824ULL, 0x000fe200078e0200ULL, 0xfffffff831317812ULL, 0x000fe200078ee204ULL,
0x000000081d0a7824ULL, 0x000fe200078e00ffULL, 0x000000031b3d7819ULL, 0x000fe200000006ffULL,
0x0000000117047824ULL, 0x040fe200078e0200ULL, 0x0000000317397819ULL, 0x000fe200000006ffULL,
0x0000000111117824ULL, 0x000fe200078e022aULL, 0xfffffff808337812ULL, 0x000fe200078ee205ULL,
0x0000000119057824ULL, 0x000fe200078e0200ULL, 0xfffffff83d3d7812ULL, 0x000fe200078ee206ULL,
0x0000000819087824ULL, 0x000fe200078e00ffULL, 0xfffffff80a3f7812ULL, 0x000fe200078ee207ULL,
0x0000000115157824ULL, 0x000fe200078e022aULL, 0xfffffff839397812ULL, 0x000fe200078ee204ULL,
0x00000200ff047424ULL, 0x000fe200078e00ffULL, 0x0000002a00077211ULL, 0x040fe200078fe8ffULL,
0x0000000119197824ULL, 0x100fe200078e022aULL, 0x0000000000067211ULL, 0x040fe200078fe8ffULL,
0x000000011b1b7824ULL, 0x000fe200078e022aULL, 0x0ffffff800a57812ULL, 0x000fc400078ec0ffULL,
0x0000000700a77812ULL, 0x000fe400078ec0ffULL, 0xfffffff8083b7812ULL, 0x000fe400078ee205ULL,
0x00000007a5057812ULL, 0x000fe200078ef806ULL, 0x00005e0007067625ULL, 0x000fe200078e0004ULL,
0x00000008a7257812ULL, 0x000fe400078efcffULL, 0x000040007b247811ULL, 0x000fe400078e70ffULL,
0x00000030001f7811ULL, 0x040fe200078fe8ffULL, 0x0000001025067825ULL, 0x000fe200078e0006ULL,
0x0000003400217811ULL, 0x000fc400078fe8ffULL, 0x0000003800237811ULL, 0x040fe200078fe8ffULL,
0x000000081f417824ULL, 0x000fe200078e00ffULL, 0x0000003c00477811ULL, 0x000fe200078fe8ffULL,
0x00000001210a7824ULL, 0x100fe200078e0200ULL, 0x0000002405057211ULL, 0x000fe200078e20ffULL,
0x0000000821437824ULL, 0x000fe200078e00ffULL, 0x000000001f087210ULL, 0x080fe20007ffe0ffULL,
0x0000000823457824ULL, 0x040fe200078e00ffULL, 0x00000000230c7210ULL, 0x000fe20007ffe0ffULL,
0x00000001470e7824ULL, 0x000fe200078e0200ULL, 0x0000002a0f0f7210ULL, 0x000fe20007ffe0ffULL,
0x0000000847497824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006057faeULL, 0x0003e2000b901c46ULL, 0xfffffff841417812ULL, 0x000fc400078ee208ULL,
0xfffffff843437812ULL, 0x000fe400078ee20aULL, 0xfffffff845457812ULL, 0x000fe400078ee20cULL,
0x0000002a17177210ULL, 0x000fe40007ffe0ffULL, 0xfffffff849497812ULL, 0x000fe200078ee20eULL,
0x00005e0009067625ULL, 0x002fc800078e0004ULL, 0x00005e000b087625ULL, 0x000fc800078e0004ULL,
0x000000011d057824ULL, 0x000fe200078e022aULL, 0x0000002a1f1d7210ULL, 0x000fe20007ffe0ffULL,
0x00005e000d0a7625ULL, 0x000fc800078e0004ULL, 0x00005e000f0c7625ULL, 0x000fc800078e0004ULL,
0x00000001211f7824ULL, 0x000fe400078e022aULL, 0x00005e00110e7625ULL, 0x000fc800078e0004ULL,
0x0000000123217824ULL, 0x000fe400078e022aULL, 0x00005e0013107625ULL, 0x000fc800078e0004ULL,
0x0000000147237824ULL, 0x000fe400078e022aULL, 0x00005e0015127625ULL, 0x000fc800078e0004ULL,
0x00005e0017147625ULL, 0x000fc800078e0004ULL, 0x00005e0019167625ULL, 0x000fc800078e0004ULL,
0x00005e001b187625ULL, 0x000fc800078e0004ULL, 0x00005e00051a7625ULL, 0x000fe200078e0004ULL,
0x0000002427057211ULL, 0x000fc600078e20ffULL, 0x00005e001d1c7625ULL, 0x000fc800078e0004ULL,
0x00005e001f1e7625ULL, 0x000fc800078e0004ULL, 0x00005e0021207625ULL, 0x000fc800078e0004ULL,
0x00005e0023227625ULL, 0x000fc800078e0004ULL, 0x0000001025067825ULL, 0x000fc800078e0006ULL,
0x0000001025087825ULL, 0x040fe200078e0008ULL, 0x0000000006057faeULL, 0x0003e6000b901c46ULL,
0x00000010250a7825ULL, 0x000fc800078e000aULL, 0x00000010250c7825ULL, 0x000fc800078e000cULL,
0x00000010250e7825ULL, 0x000fc800078e000eULL, 0x0000001025107825ULL, 0x000fc800078e0010ULL,
0x0000001025127825ULL, 0x000fc800078e0012ULL, 0x0000001025147825ULL, 0x000fc800078e0014ULL,
0x0000001025167825ULL, 0x000fc800078e0016ULL, 0x0000001025187825ULL, 0x000fc800078e0018ULL,
0x00000010251a7825ULL, 0x000fc800078e001aULL, 0x00000010251c7825ULL, 0x000fc800078e001cULL,
0x00000010251e7825ULL, 0x000fc800078e001eULL, 0x0000001025207825ULL, 0x000fc800078e0020ULL,
0x0000001025227825ULL, 0x000fc800078e0022ULL, 0x0000001029257824ULL, 0x100fe400078e0224ULL,
0x000000102b277824ULL, 0x100fe200078e0224ULL, 0x00000024332b7211ULL, 0x080fe200078e20ffULL,
0x0000001031297824ULL, 0x100fe200078e0224ULL, 0x0000000008257faeULL, 0x0003e2000b901c46ULL,
0x0000001035317824ULL, 0x100fe400078e0224ULL, 0x0000001037337824ULL, 0x100fe200078e0224ULL,
0x000000000a277faeULL, 0x0003e2000b901c46ULL, 0x0000001039357824ULL, 0x100fe200078e0224ULL,
0x000000243b377211ULL, 0x080fe200078e20ffULL, 0x000000103d397824ULL, 0x100fe200078e0224ULL,
0x000000000c297faeULL, 0x0003e2000b901c46ULL, 0x000000103f3b7824ULL, 0x100fe200078e0224ULL,
0x00000024433f7211ULL, 0x000fe200078e20ffULL, 0x00000010413d7824ULL, 0x100fe200078e0224ULL,
0x000000000e2b7faeULL, 0x0003e2000b901c46ULL, 0x0000001045417824ULL, 0x000fc400078e0224ULL,
0x0000001049437824ULL, 0x000fe200078e0224ULL, 0x0000000010317faeULL, 0x0003e8000b901c46ULL,
0x0000000012337faeULL, 0x0003e8000b901c46ULL, 0x0000000014357faeULL, 0x0003e8000b901c46ULL,
0x0000000016377faeULL, 0x0003e8000b901c46ULL, 0x0000000018397faeULL, 0x0003e8000b901c46ULL,
0x000000001a3b7faeULL, 0x0003e8000b901c46ULL, 0x000000001c3d7faeULL, 0x0003e8000b901c46ULL,
0x000000001e3f7faeULL, 0x0003e8000b901c46ULL, 0x0000000020417faeULL, 0x0003e8000b901c46ULL,
0x0000000022437faeULL, 0x0003e4000b901c46ULL, 0x00000004ff077819ULL, 0x102fe20000011600ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000003ff057819ULL, 0x000fc40000011600ULL,
0x00000008a7067812ULL, 0x000fe200078ef800ULL, 0x0000000807087824ULL, 0x000fe200078e00ffULL,
0x00000001050c7812ULL, 0x000fe400078ec0ffULL, 0x0000000e7ba67819ULL, 0x000fe200000006ffULL,
0x0000000106077824ULL, 0x000fe200078e0207ULL, 0xfffffff8081d7812ULL, 0x000fe200078ee2a7ULL,
0x0000002006087824ULL, 0x000fe200078e00ffULL, 0x00002000a6287810ULL, 0x000fe20007ffe0ffULL,
0x00000020060e7824ULL, 0x000fe200078e00ffULL, 0x000000031d4b7819ULL, 0x040fe200000006ffULL,
0x000000010c2c7824ULL, 0x000fe200078e021dULL, 0xffffffe008087812ULL, 0x000fe200078ee207ULL,
0x00000020061f7824ULL, 0x000fe200078e00ffULL, 0x000000201d537810ULL, 0x040fe20007ffe0ffULL,
0x000000081d327824ULL, 0x000fe200078e00ffULL, 0xfffffff84b4b7812ULL, 0x000fe200078ee22cULL,
0x0000001008087824ULL, 0x000fe200078e00ffULL, 0x000000031d147819ULL, 0x000fe200000006ffULL,
0x000000010c297824ULL, 0x000fe200078e0253ULL, 0x000000022c2b7810ULL, 0x000fe20007ffe0ffULL,
0x000000104ba87824ULL, 0x000fe200078e0228ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000000808783bULL, 0x000fe20000000200ULL,
0x00000002070d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000853487824ULL, 0x040fe200078e00ffULL,
0xfffffff8142b7812ULL, 0x000fe200078ee22bULL, 0x00000000a810783bULL, 0x000e620000000200ULL,
0x0000000353147819ULL, 0x000fe400000006ffULL, 0x000000101d517810ULL, 0x000fe40007ffe0ffULL,
0xffffffe00e0d7812ULL, 0x000fc400078ee20dULL, 0xfffffff814297812ULL, 0x000fe200078ee229ULL,
0x000000010c497824ULL, 0x000fe200078e0251ULL, 0x000000282b927211ULL, 0x000fe200078e20ffULL,
0x00000008510e7824ULL, 0x000fe200078e00ffULL, 0x000000301d557810ULL, 0x000fe20007ffe0ffULL,
0x000000100d207824ULL, 0x000fe200078e00ffULL, 0x000000122c317810ULL, 0x000fe20007ffe0ffULL,
0x0000001029947824ULL, 0x100fe200078e0228ULL, 0xfffffff80e497812ULL, 0x000fe200078ee249ULL,
0x000000009234783bULL, 0x000fe20000000200ULL, 0x000000010c337824ULL, 0x000fe200078e0255ULL,
0x000000222c7d7810ULL, 0x040fe20007ffe0ffULL, 0x0000000855167824ULL, 0x000fe200078e00ffULL,
0x000000002020783bULL, 0x000ea20000000200ULL, 0x0000001049957824ULL, 0x000fe200078e0228ULL,
0x000000322c6b7810ULL, 0x000fc40007ffe0ffULL, 0x000000009424783bULL, 0x000fe20000000200ULL,
0xfffffff816337812ULL, 0x000fe400078ee233ULL, 0x00000003551c7819ULL, 0x000fe200000006ffULL,
0x00000000950c783bULL, 0x000ee20000000200ULL, 0x000000142c857810ULL, 0x000fe20007ffe0ffULL,
0x0000001033937824ULL, 0x100fe200078e0228ULL, 0xfffffff81c6b7812ULL, 0x000fe400078ee26bULL,
0x00000004071c7810ULL, 0x000fe40007ffe0ffULL, 0x000000009338783bULL, 0x000fe20000000200ULL,
0x000000106b8f7824ULL, 0x000fe200078e0228ULL, 0x00000003511e7819ULL, 0x000fc400000006ffULL,
0x000000242c697810ULL, 0x040fe20007ffe0ffULL, 0x000000100844723cULL, 0x042b6200000418ffULL,
0x000000008f4c783bULL, 0x000fe20000000200ULL, 0x000000042c817810ULL, 0x040fe40007ffe0ffULL,
0x000000342c837810ULL, 0x000fe40007ffe0ffULL, 0xffffffe01f1c7812ULL, 0x000fe400078ee21cULL,
0x0000000351107819ULL, 0x020fe200000006ffULL, 0x000000120818723cULL, 0x000b6200000418ffULL,
0xfffffff81e857812ULL, 0x000fc400078ee285ULL, 0xfffffff810317812ULL, 0x000fe200078ee231ULL,
0x0000000853107824ULL, 0x000fe200078e00ffULL, 0x000000062c877810ULL, 0x040fe20007ffe0ffULL,
0x00000010858d7824ULL, 0x100fe200078e0228ULL, 0x000000162c8b7810ULL, 0x000fe20007ffe0ffULL,
0x0000001031917824ULL, 0x100fe200078e0228ULL, 0xfffffff8107d7812ULL, 0x000fe400078ee27dULL,
0xfffffff832877812ULL, 0x000fe200078ee287ULL, 0x0000000851327824ULL, 0x000fe200078e00ffULL,
0x000000009114783bULL, 0x000fe20000000200ULL, 0x000000107d907824ULL, 0x100fe200078e0228ULL,
0x000000342044723cULL, 0x004fe20000041844ULL, 0x000000262ca97810ULL, 0x040fe20007ffe0ffULL,
0x0000001087867824ULL, 0x000fe200078e0228ULL, 0x000000362c897810ULL, 0x000fe20007ffe0ffULL,
0x000000009010783bULL, 0x020e620000000200ULL, 0x00000008552c7824ULL, 0x000fe200078e00ffULL,
0xfffffff8328b7812ULL, 0x000fc400078ee28bULL, 0x0000000c086c723cULL, 0x008fe200000418ffULL,
0xfffffff848a97812ULL, 0x000fe200078ee2a9ULL, 0x000000008658783bULL, 0x000fe20000000200ULL,
0xfffffff82c897812ULL, 0x000fe200078ee289ULL, 0x000000108b827824ULL, 0x100fe400078e0228ULL,
0x00000010a9807824ULL, 0x000fe200078e0228ULL, 0x00000028897f7211ULL, 0x000fe200078e20ffULL,
0x000000362018723cULL, 0x000ff00000041818ULL, 0x000000240834723cULL, 0x040b6e00000418ffULL,
0x0000000853247824ULL, 0x020fe200078e00ffULL, 0x0000000e0840723cULL, 0x000fe200000418ffULL,
0x000000008050783bULL, 0x000fe60000000200ULL, 0xfffffff824697812ULL, 0x000fc800078ee269ULL,
0x00000026080c723cULL, 0x000b6200000418ffULL, 0x00000010698c7824ULL, 0x000fcc00078e0228ULL,
0x0000000855267824ULL, 0x020fe200078e00ffULL, 0x000000102034723cULL, 0x002be20000041834ULL,
0x000000008254783bULL, 0x000fe60000000200ULL, 0xfffffff826837812ULL, 0x000fe400078ee283ULL,
0x000000008c24783bULL, 0x000fe20000000200ULL, 0x000000081d107824ULL, 0x020fe200078e00ffULL,
0x00000038083c723cULL, 0x000f6200000418ffULL, 0x0000002883887211ULL, 0x000fc600078e20ffULL,
0xfffffff810817812ULL, 0x000fc800078ee281ULL, 0x000000122010723cULL, 0x000be2000004180cULL,
0x00000028818e7211ULL, 0x000fcc00078e20ffULL, 0x000000101c0c7824ULL, 0x020fe200078e00ffULL,
0x0000003a0808723cULL, 0x000b6200000418ffULL, 0x00000006071c7810ULL, 0x000fe20007ffe0ffULL,
0x000000008d38783bULL, 0x020fe60000000200ULL, 0xffffffe01f307812ULL, 0x000fe200078ee21cULL,
0x000000000c0c783bULL, 0x000e640000000200ULL, 0x00000014206c723cULL, 0x040f62000004186cULL,
0x0000000430307819ULL, 0x000fe200000006ffULL, 0x00000000881c783bULL, 0x000fec0000000200ULL,
0x000000162014723cULL, 0x040b640000041840ULL, 0x000000008e40783bULL, 0x020eac0000000200ULL,
0x0000004c203c723cULL, 0x040f70000004183cULL, 0x0000004e2020723cULL, 0x000b640000041808ULL,
0x00000000304c783bULL, 0x020ee80000000200ULL, 0x000000007f08783bULL, 0x000f240000000200ULL,
0x000000380c6c723cULL, 0x042ff0000004186cULL, 0x000000240c34723cULL, 0x040ff00000041834ULL,
0x000000400c44723cULL, 0x044f700000041844ULL, 0x000000420c18723cULL, 0x040f700000041818ULL,
0x0000003a0c14723cULL, 0x040f700000041814ULL, 0x000000260c10723cULL, 0x040f700000041810ULL,
0x0000001c0c3c723cULL, 0x040f70000004183cULL, 0x0000001e0c0c723cULL, 0x000f700000041820ULL,
0x000000584c44723cULL, 0x068b700000041844ULL, 0x000000544c6c723cULL, 0x040b70000004186cULL,
0x000000504c34723cULL, 0x040b700000041834ULL, 0x0000005a4c58723cULL, 0x040b700000041818ULL,
0x000000564c54723cULL, 0x040b700000041814ULL, 0x000000524c50723cULL, 0x040b700000041810ULL,
0x000000084c3c723cULL, 0x050b70000004183cULL, 0x0000000a4c4c723cULL, 0x000b62000004180cULL,
0x00000a4000008947ULL, 0x000fce0003800000ULL, 0x0000000405097810ULL, 0x060fe20007ffe0ffULL,
0x0000000105087824ULL, 0x040fe200078e0200ULL, 0x800000037a2c7210ULL, 0x000fe20007ffe0ffULL,
0x0000000105bf7824ULL, 0x040fe200078e022aULL, 0x00000008050b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000109a47824ULL, 0x000fe200078e0200ULL, 0x0000002c0500720cULL, 0x000fe20003f26070ULL,
0x00000008090d7824ULL, 0x000fe200078e00ffULL, 0x00000007a5a57812ULL, 0x000fe200078ef808ULL,
0x000000080b087824ULL, 0x000fe200078e00ffULL, 0x0000001405117810ULL, 0x000fe20007ffe0ffULL,
0x00005e00bfbe7625ULL, 0x000fe200078e0004ULL, 0xfffffff80da47812ULL, 0x000fc400078ee2a4ULL,
0x0000000c050d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000111a07824ULL, 0x100fe200078e0200ULL,
0x000000000ba37210ULL, 0x080fe20007ffe0ffULL, 0x0000000811157824ULL, 0x000fe200078e00ffULL,
0x00000010a75f7812ULL, 0x000fe200078efcffULL, 0x000000010da27824ULL, 0x000fe200078e0200ULL,
0x00000010050f7810ULL, 0x000fe20007ffe0ffULL, 0x000000080d137824ULL, 0x000fe200078e00ffULL,
0xfffffff808a37812ULL, 0x000fe200078ee2a3ULL, 0x00000010a5087824ULL, 0x000fe200078e0228ULL,
0x000000000fa17210ULL, 0x000fe20007ffe0ffULL, 0x000000105f1a7825ULL, 0x000fe200078e00beULL,
0xfffffff813a27812ULL, 0x000fc400078ee2a2ULL, 0x0000001805137810ULL, 0x000fe20007ffe0ffULL,
0x000000080f0a7824ULL, 0x000fe200078e00ffULL, 0xfffffff815a07812ULL, 0x000fe200078ee2a0ULL,
0x0000000109bd7824ULL, 0x100fe200078e022aULL, 0x0000001c05157810ULL, 0x040fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a087faeULL, 0x0003e2000c901c46ULL,
0x0000002005177810ULL, 0x000fe20007ffe0ffULL, 0x000000010db97824ULL, 0x000fe200078e022aULL,
0x0000002a0bbb7210ULL, 0x000fe20007ffe0ffULL, 0x00000001139f7824ULL, 0x000fe200078e0200ULL,
0x0000002405197810ULL, 0x000fe20007ffe0ffULL, 0x00005e00bdbc7625ULL, 0x000fe200078e0004ULL,
0x0000002c0900720cULL, 0x000fc40003f26070ULL, 0xfffffff80aa17812ULL, 0x000fe200078ee2a1ULL,
0x00000008130a7824ULL, 0x000fe200078e00ffULL, 0x0000002c0b00720cULL, 0x080fe20003f46070ULL,
0x000000010fb77824ULL, 0x000fe200078e022aULL, 0x0000002c0d00720cULL, 0x000fe20003f66070ULL,
0x00000008151d7824ULL, 0x040fe200078e00ffULL, 0x00000000159e7210ULL, 0x000fe20007ffe0ffULL,
0x00000001179d7824ULL, 0x000fe200078e0200ULL, 0x0000002c0f00720cULL, 0x000fe20003f86070ULL,
0x00000008170c7824ULL, 0x000fe200078e00ffULL, 0x00000000199c7210ULL, 0x000fe20007ffe0ffULL,
0x00005e00bbba7625ULL, 0x000fe200078e0004ULL, 0xfffffff80a9f7812ULL, 0x000fc400078ee29fULL,
0x00000028a40a7211ULL, 0x000fe200078e20ffULL, 0x00000008191f7824ULL, 0x000fe200078e00ffULL,
0xfffffff81d9e7812ULL, 0x000fe200078ee29eULL, 0x00005e00b9b87625ULL, 0x080fe200078e0004ULL,
0xfffffff80c9d7812ULL, 0x000fe400078ee29dULL, 0xfffffff81f9c7812ULL, 0x000fe200078ee29cULL,
0x00005e00b7b67625ULL, 0x000fe200078e0004ULL, 0x0000002c1100720cULL, 0x000fe40003fa6070ULL,
0x0000002a19ad7210ULL, 0x000fe20007ffe0ffULL, 0x000000105f1a7825ULL, 0x002fe200078e00bcULL,
0x00000028a0127211ULL, 0x000fc600078e20ffULL, 0x00000010a30c7824ULL, 0x000fe200078e0228ULL,
0x000000001a0a7faeULL, 0x0003e2000c901c46ULL, 0x000000105f1c7825ULL, 0x000fe200078e00baULL,
0x0000002c1300720cULL, 0x000fc60003f26070ULL, 0x0000000111b57824ULL, 0x000fe200078e022aULL,
0x000000001c0c7faeULL, 0x0005e2000d101c46ULL, 0x00000010a20e7824ULL, 0x000fe200078e0228ULL,
0x0000002c1500720cULL, 0x000fe20003f46070ULL, 0x000000105f1e7825ULL, 0x000fe200078e00b8ULL,
0x00000028051b7810ULL, 0x002fc60007ffe0ffULL, 0x0000000113b37824ULL, 0x000fe200078e022aULL,
0x000000001e0e7faeULL, 0x0003e2000d901c46ULL, 0x00000010a1107824ULL, 0x000fe200078e0228ULL,
0x0000002c1700720cULL, 0x000fe20003f66070ULL, 0x000000105f207825ULL, 0x000fe200078e00b6ULL,
0x0000002c051d7810ULL, 0x004fe40007ffe0ffULL, 0x000000289c1a7211ULL, 0x000fe200078e20ffULL,
0x0000000115b17824ULL, 0x000fe200078e022aULL, 0x0000000020107faeULL, 0x0005e2000e101c46ULL,
0x00005e00b5b47625ULL, 0x000fe200078e0004ULL, 0x0000002c1900720cULL, 0x000fc40003f86070ULL,
0x00000030051f7810ULL, 0x002fe20007ffe0ffULL, 0x0000000117af7824ULL, 0x000fe400078e022aULL,
0x00005e00b3b27625ULL, 0x000fe200078e0004ULL, 0x0000002a1fc77210ULL, 0x000fc60007ffe0ffULL,
0x00005e00b1b07625ULL, 0x000fe200078e0004ULL, 0x0000003405217810ULL, 0x004fc60007ffe0ffULL,
0x00005e00afae7625ULL, 0x000fe200078e0004ULL, 0x0000000021987210ULL, 0x000fc60007ffe0ffULL,
0x000000105f227825ULL, 0x000fc800078e00b4ULL, 0x00005e00adac7625ULL, 0x000fe200078e0004ULL,
0x0000000022127faeULL, 0x0003e6000e901c46ULL, 0x000000109f147824ULL, 0x000fe400078e0228ULL,
0x000000105f247825ULL, 0x000fc800078e00b2ULL, 0x000000109e167824ULL, 0x000fe200078e0228ULL,
0x0000000024147faeULL, 0x0005e2000c901c46ULL, 0x000000105f267825ULL, 0x000fe200078e00b0ULL,
0x0000003805237810ULL, 0x002fe40007ffe0ffULL, 0x0000002c1b00720cULL, 0x080fe20003f26070ULL,
0x000000109d187824ULL, 0x000fe200078e0228ULL, 0x0000000026167faeULL, 0x0003e2000d101c46ULL,
0x000000105f387825ULL, 0x000fe200078e00aeULL, 0x0000002c1d00720cULL, 0x080fe40003f46070ULL,
0x0000002c2300720cULL, 0x080fe20003fa6070ULL, 0x000000105f3a7825ULL, 0x000fe200078e00acULL,
0x0000003c05257810ULL, 0x004fe20007ffe0ffULL, 0x0000000038187faeULL, 0x0005e2000d901c46ULL,
0x0000002c1f00720cULL, 0x080fe20003f66070ULL, 0x000000011b9b7824ULL, 0x000fe200078e0200ULL,
0x0000002c2500720cULL, 0x080fe20003fc6070ULL, 0x000000081b1c7824ULL, 0x000fe200078e00ffULL,
0x000000031d277819ULL, 0x002fe200000006ffULL, 0x000000011bab7824ULL, 0x100fe200078e022aULL,
0x000000003a1a7faeULL, 0x0003e2000e101c46ULL, 0x000000011dc97824ULL, 0x040fe200078e022aULL,
0xfffffff81c9b7812ULL, 0x000fe200078ee29bULL, 0x000000011d9a7824ULL, 0x100fe200078e0200ULL,
0x0000002c2100720cULL, 0x000fe20003f86070ULL, 0x000000011f997824ULL, 0x000fe200078e0200ULL,
0x0000000025967210ULL, 0x000fe20007ffe0ffULL, 0x000000081f1e7824ULL, 0x000fe200078e00ffULL,
0xfffffff8279a7812ULL, 0x000fe200078ee29aULL, 0x0000000821397824ULL, 0x004fc400078e00ffULL,
0x00005e00abaa7625ULL, 0x000fe200078e0004ULL, 0xfffffff81e997812ULL, 0x000fe400078ee299ULL,
0xfffffff839987812ULL, 0x000fe200078ee298ULL, 0x0000000121c57824ULL, 0x000fe200078e022aULL,
0x000000289a1e7211ULL, 0x000fe200078e20ffULL, 0x0000000123977824ULL, 0x040fe400078e0200ULL,
0x0000000823207824ULL, 0x040fe400078e00ffULL, 0x0000000123c37824ULL, 0x000fc400078e022aULL,
0x0000000125c17824ULL, 0x000fe200078e022aULL, 0xfffffff820977812ULL, 0x000fe200078ee297ULL,
0x00005e00c9c87625ULL, 0x000fc800078e0004ULL, 0x00000008253b7824ULL, 0x002fe400078e00ffULL,
0x00005e00c7c67625ULL, 0x000fc600078e0004ULL, 0xfffffff83b967812ULL, 0x000fe200078ee296ULL,
0x00005e00c5c47625ULL, 0x000fc800078e0004ULL, 0x00005e00c3c27625ULL, 0x000fc800078e0004ULL,
0x000000109b1c7824ULL, 0x000fe400078e0228ULL, 0x000000105f267825ULL, 0x000fc800078e00aaULL,
0x00005e00c1c07625ULL, 0x000fe200078e0004ULL, 0x00000000261c7faeULL, 0x0003e6000c901c46ULL,
0x000000105f5c7825ULL, 0x000fc800078e00c8ULL, 0x0000001099207824ULL, 0x000fe200078e0228ULL,
0x000000005c1e7faeULL, 0x0005e2000d101c46ULL, 0x000000105f427825ULL, 0x000fe200078e00c6ULL,
0x0000002896267211ULL, 0x002fc600078e20ffULL, 0x0000001098227824ULL, 0x000fe200078e0228ULL,
0x0000000042207faeULL, 0x0005e2000d901c46ULL, 0x000000105f407825ULL, 0x000fc800078e00c4ULL,
0x0000001097247824ULL, 0x000fe200078e0228ULL, 0x0000000040227faeULL, 0x0005e2000e101c46ULL,
0x000000105f3a7825ULL, 0x000fc800078e00c2ULL, 0x000000105f387825ULL, 0x000fe200078e00c0ULL,
0x000000003a247faeULL, 0x0005e8000e901c46ULL, 0x0000000038267faeULL, 0x0005e2000f101c46ULL,
0x0000092000007947ULL, 0x000fea0003800000ULL, 0x0000000c050d7810ULL, 0x060fe20007ffe0ffULL,
0x0000000105087824ULL, 0x140fe200078e0200ULL, 0x0000000405097810ULL, 0x040fe40007ffe0ffULL,
0x0000001c05157810ULL, 0x000fe20007ffe0ffULL, 0x000000010da27824ULL, 0x100fe200078e0200ULL,
0x00000008050b7810ULL, 0x000fe20007ffe0ffULL, 0x000000080d117824ULL, 0x000fe200078e00ffULL,
0x0000001805137810ULL, 0x000fe20007ffe0ffULL, 0x0000000109a47824ULL, 0x000fe200078e0200ULL,
0x000000000ba37210ULL, 0x080fe20007ffe0ffULL, 0x00000008090f7824ULL, 0x000fe200078e00ffULL,
0xfffffff811a27812ULL, 0x000fe200078ee2a2ULL, 0x00000001159e7824ULL, 0x000fe200078e0200ULL,
0x0000001405117810ULL, 0x000fe20007ffe0ffULL, 0x0000000815197824ULL, 0x000fe200078e00ffULL,
0xfffffff80fa47812ULL, 0x000fe200078ee2a4ULL, 0x000000080b0a7824ULL, 0x000fe200078e00ffULL,
0x00000010050f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000111a07824ULL, 0x000fe200078e0200ULL,
0xfffffff8199e7812ULL, 0x000fe200078ee29eULL, 0x0000000811177824ULL, 0x000fe200078e00ffULL,
0x0000002405197810ULL, 0x000fe20007ffe0ffULL, 0x0000000109bd7824ULL, 0x100fe200078e022aULL,
0x0000002c051d7810ULL, 0x000fe20007ffe0ffULL, 0x000000010bbb7824ULL, 0x000fe200078e022aULL,
0x00000007a5a57812ULL, 0x000fe200078ef808ULL, 0x000000080f087824ULL, 0x000fe200078e00ffULL,
0xfffffff80aa37812ULL, 0x000fe200078ee2a3ULL, 0x00000008130a7824ULL, 0x000fe200078e00ffULL,
0xfffffff817a07812ULL, 0x000fe200078ee2a0ULL, 0x00000001199c7824ULL, 0x100fe200078e0200ULL,
0x000000000fa17210ULL, 0x080fe20007ffe0ffULL, 0x00000008191f7824ULL, 0x000fe200078e00ffULL,
0x00000000139f7210ULL, 0x000fe20007ffe0ffULL, 0x000000011d9a7824ULL, 0x000fe200078e0200ULL,
0x0000002005177810ULL, 0x000fe20007ffe0ffULL, 0x000000081d217824ULL, 0x000fe200078e00ffULL,
0x00000028051b7810ULL, 0x000fe20007ffe0ffULL, 0x000000010fb77824ULL, 0x100fe200078e022aULL,
0x0000002a05bf7210ULL, 0x000fe20007ffe0ffULL, 0x0000000111b57824ULL, 0x000fe200078e022aULL,
0xfffffff808a17812ULL, 0x000fe200078ee2a1ULL, 0x0000000817087824ULL, 0x000fe200078e00ffULL,
0xfffffff80a9f7812ULL, 0x000fe200078ee29fULL, 0x000000081b0a7824ULL, 0x000fe200078e00ffULL,
0xfffffff81f9c7812ULL, 0x000fe200078ee29cULL, 0x00005e00bfbe7625ULL, 0x000fe200078e0004ULL,
0x00000000179d7210ULL, 0x000fc40007ffe0ffULL, 0x000000001b9b7210ULL, 0x000fe20007ffe0ffULL,
0x00005e00bdbc7625ULL, 0x080fe200078e0004ULL, 0xfffffff8219a7812ULL, 0x000fe400078ee29aULL,
0x00000010a75f7812ULL, 0x000fe200078efcffULL, 0x00005e00bbba7625ULL, 0x000fe200078e0004ULL,
0x00000030051f7810ULL, 0x040fe40007ffe0ffULL, 0x0000003405217810ULL, 0x000fe20007ffe0ffULL,
0x000000105f267825ULL, 0x000fe200078e00beULL, 0x0000003805237810ULL, 0x000fc40007ffe0ffULL,
0x0000003c05257810ULL, 0x000fe20007ffe0ffULL, 0x000000011f997824ULL, 0x100fe200078e0200ULL,
0x0000002a0db97210ULL, 0x080fe20007ffe0ffULL, 0x0000000121987824ULL, 0x000fe200078e0200ULL,
0xfffffff8089d7812ULL, 0x000fe200078ee29dULL, 0x00000010a5087824ULL, 0x000fe200078e0228ULL,
0xfffffff80a9b7812ULL, 0x000fe200078ee29bULL, 0x000000081f0a7824ULL, 0x000fe200078e00ffULL,
0x0000002a13b37210ULL, 0x000fe20007ffe0ffULL, 0x0000000123977824ULL, 0x100fe200078e0200ULL,
0x0000000321397819ULL, 0x000fe200000006ffULL, 0x00000008230c7824ULL, 0x000fe200078e00ffULL,
0x00000003253b7819ULL, 0x040fe200000006ffULL, 0x0000000125967824ULL, 0x000fe200078e0200ULL,
0xfffffff80a997812ULL, 0x000fe200078ee299ULL, 0x00005e00b9b87625ULL, 0x000fe200078e0004ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026087faeULL, 0x0003e2000b901c46ULL,
0x0000002a1bab7210ULL, 0x000fc40007ffe0ffULL, 0x00005e00b7b67625ULL, 0x080fe200078e0004ULL,
0xfffffff839987812ULL, 0x000fe400078ee298ULL, 0xfffffff80c977812ULL, 0x000fe200078ee297ULL,
0x0000000115b17824ULL, 0x000fe200078e022aULL, 0xfffffff83b967812ULL, 0x000fe200078ee296ULL,
0x00005e00b5b47625ULL, 0x000fe200078e0004ULL, 0x00000028a30c7211ULL, 0x000fe400078e20ffULL,
0x0000002a21c57210ULL, 0x000fe20007ffe0ffULL, 0x0000000117af7824ULL, 0x100fe200078e022aULL,
0x000000289c1a7211ULL, 0x080fe200078e20ffULL, 0x0000000119ad7824ULL, 0x000fe200078e022aULL,
0x0000002899207211ULL, 0x000fe200078e20ffULL, 0x00000010a40a7824ULL, 0x000fc400078e0228ULL,
0x000000105f267825ULL, 0x002fc800078e00bcULL, 0x00005e00b3b27625ULL, 0x000fe200078e0004ULL,
0x00000000260a7faeULL, 0x0003e6000b901c46ULL, 0x000000105f387825ULL, 0x000fc800078e00baULL,
0x00005e00b1b07625ULL, 0x000fe200078e0004ULL, 0x00000000380c7faeULL, 0x0005e6000b901c46ULL,
0x00000010a20e7824ULL, 0x000fe400078e0228ULL, 0x000000105f3a7825ULL, 0x000fc800078e00b8ULL,
0x00005e00afae7625ULL, 0x000fe200078e0004ULL, 0x000000003a0e7faeULL, 0x0007e6000b901c46ULL,
0x00000010a1107824ULL, 0x000fe400078e0228ULL, 0x000000105f407825ULL, 0x000fc800078e00b6ULL,
0x00005e00adac7625ULL, 0x000fe200078e0004ULL, 0x0000000040107faeULL, 0x0009e6000b901c46ULL,
0x00000010a0127824ULL, 0x000fe400078e0228ULL, 0x000000105f427825ULL, 0x000fc800078e00b4ULL,
0x00005e00abaa7625ULL, 0x000fe200078e0004ULL, 0x0000000042127faeULL, 0x0005e6000b901c46ULL,
0x000000011dc97824ULL, 0x000fe400078e022aULL, 0x000000109f147824ULL, 0x000fe400078e0228ULL,
0x000000105f267825ULL, 0x002fc800078e00b2ULL, 0x000000011fc77824ULL, 0x000fe200078e022aULL,
0x0000000026147faeULL, 0x0003e2000b901c46ULL, 0x000000109e167824ULL, 0x000fe400078e0228ULL,
0x000000105f387825ULL, 0x004fc800078e00b0ULL, 0x000000109d187824ULL, 0x000fe200078e0228ULL,
0x0000000038167faeULL, 0x0005e2000b901c46ULL, 0x000000105f3a7825ULL, 0x008fc800078e00aeULL,
0x0000000123c37824ULL, 0x000fe200078e022aULL, 0x000000003a187faeULL, 0x0007e2000b901c46ULL,
0x000000105f407825ULL, 0x010fc800078e00acULL, 0x0000000125c17824ULL, 0x000fe200078e022aULL,
0x00000000401a7faeULL, 0x0009e2000b901c46ULL, 0x00005e00c9c87625ULL, 0x000fc800078e0004ULL,
0x000000109b1c7824ULL, 0x000fe400078e0228ULL, 0x000000105f427825ULL, 0x000fc800078e00aaULL,
0x00005e00c7c67625ULL, 0x080fe200078e0004ULL, 0x00000000421c7faeULL, 0x0003e6000b901c46ULL,
0x00005e00c5c47625ULL, 0x000fc800078e0004ULL, 0x00005e00c3c27625ULL, 0x000fc800078e0004ULL,
0x00005e00c1c07625ULL, 0x000fc800078e0004ULL, 0x000000109a1e7824ULL, 0x000fe400078e0228ULL,
0x000000105f5c7825ULL, 0x000fc800078e00c8ULL, 0x000000105f427825ULL, 0x042fe200078e00c6ULL,
0x000000005c1e7faeULL, 0x0003e6000b901c46ULL, 0x0000001098227824ULL, 0x000fe200078e0228ULL,
0x0000000042207faeULL, 0x0003e2000b901c46ULL, 0x000000105f407825ULL, 0x010fc800078e00c4ULL,
0x0000001097247824ULL, 0x000fe200078e0228ULL, 0x0000000040227faeULL, 0x0003e2000b901c46ULL,
0x000000105f3a7825ULL, 0x008fc800078e00c2ULL, 0x0000001096267824ULL, 0x000fe200078e0228ULL,
0x000000003a247faeULL, 0x0003e2000b901c46ULL, 0x000000105f387825ULL, 0x004fca00078e00c0ULL,
0x0000000038267faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000807277810ULL, 0x000fe40007ffe0ffULL, 0x0000000506287819ULL, 0x000fe400000006ffULL,
0x00004000a6a67810ULL, 0x000fe40007ffe0ffULL, 0xffffffe028287812ULL, 0x000fe400078ee227ULL,
0x000000a629297211ULL, 0x080fe200078e20ffULL, 0x000000104b277824ULL, 0x100fe200078e02a6ULL,
0x0000000a072c7810ULL, 0x000fe20007ffe0ffULL, 0x00000010285c7824ULL, 0x006fe200078e00ffULL,
0x000000a669847211ULL, 0x000fe200078e20ffULL, 0x00000010332a7824ULL, 0x000fc400078e02a6ULL,
0x0000002006337824ULL, 0x000fe400078e00ffULL, 0x0000001049287824ULL, 0x100fe400078e02a6ULL,
0x000000102b2b7824ULL, 0x000fe200078e02a6ULL, 0xffffffe0332c7812ULL, 0x000fe200078ee22cULL,
0x000000107d7d7824ULL, 0x000fe200078e02a6ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000002738783bULL, 0x000fe20000000200ULL, 0x000000042c407819ULL, 0x000fe200000006ffULL,
0x00000010312c7824ULL, 0x100fe400078e02a6ULL, 0x000000005c5c783bULL, 0x000e620000000200ULL,
0x000000106b7e7824ULL, 0x100fe400078e02a6ULL, 0x0000001081817824ULL, 0x100fe200078e02a6ULL,
0x000000002948783bULL, 0x000ea20000000200ULL, 0x0000001085857824ULL, 0x100fe400078e02a6ULL,
0x0000001083837824ULL, 0x100fe200078e02a6ULL, 0x000000002b70783bULL, 0x000fe20000000200ULL,
0x0000001087877824ULL, 0x000fc400078e02a6ULL, 0x000000108b8b7824ULL, 0x100fe200078e02a6ULL,
0x000000004040783bULL, 0x000ee20000000200ULL, 0x00000010a98a7824ULL, 0x100fe400078e02a6ULL,
0x0000001089897824ULL, 0x000fe200078e02a6ULL, 0x000000002864783bULL, 0x000f280000000200ULL,
0x000000002a60783bULL, 0x000ee80000000200ULL, 0x000000002c30783bULL, 0x000fe80000000200ULL,
0x000000008174783bULL, 0x000fe80000000200ULL, 0x000000008568783bULL, 0x000fe20000000200ULL,
0x000000385c44723cULL, 0x042f700000041844ULL, 0x0000003a5c58723cULL, 0x040b640000041858ULL,
0x000000007d38783bULL, 0x020e6c0000000200ULL, 0x000000485c34723cULL, 0x044f700000041834ULL,
0x0000004a5c50723cULL, 0x000b640000041850ULL, 0x000000007e48783bULL, 0x020eac0000000200ULL,
0x000000704044723cULL, 0x048ff00000041844ULL, 0x000000724070723cULL, 0x000bee0000041858ULL,
0x0000000c07587810ULL, 0x020fe20007ffe0ffULL, 0x000000645c6c723cULL, 0x010f62000004186cULL,
0x0000000506597819ULL, 0x000fc800000006ffULL, 0xffffffe059587812ULL, 0x000fc600078ee258ULL,
0x000000665c54723cULL, 0x040b640000041854ULL, 0x0000001058587824ULL, 0x000fe200078e00ffULL,
0x000000008464783bULL, 0x020fea0000000200ULL, 0x000000605c3c723cULL, 0x040f70000004183cULL,
0x000000625c4c723cULL, 0x000b64000004184cULL, 0x00000000585c783bULL, 0x020ee80000000200ULL,
0x000000008360783bULL, 0x000f240000000200ULL, 0x000000384034723cULL, 0x042fe40000041834ULL,
0x000000008758783bULL, 0x000fec0000000200ULL, 0x0000003a4038723cULL, 0x040bee0000041850ULL,
0x0000002006517824ULL, 0x020fe200078e00ffULL, 0x0000000e07507810ULL, 0x000fe20007ffe0ffULL,
0x00000030406c723cULL, 0x000f66000004186cULL, 0xffffffe051507812ULL, 0x000fca00078ee250ULL,
0x000000324030723cULL, 0x040b640000041854ULL, 0x000000008b54783bULL, 0x020fec0000000200ULL,
0x00000048403c723cULL, 0x044b6e000004183cULL, 0x0000000450487819ULL, 0x020fe200000006ffULL,
0x0000004a4040723cULL, 0x000b62000004184cULL, 0x000000008a50783bULL, 0x000fe80000000200ULL,
0x000000004848783bULL, 0x020e660000000200ULL, 0x000000745c44723cULL, 0x048f620000041844ULL,
0x00000000894c783bULL, 0x000eae0000000200ULL, 0x000000765c70723cULL, 0x040f700000041870ULL,
0x000000685c6c723cULL, 0x040f70000004186cULL, 0x0000006a5c30723cULL, 0x040f700000041830ULL,
0x000000645c34723cULL, 0x040f700000041834ULL, 0x000000665c38723cULL, 0x040f700000041838ULL,
0x000000605c3c723cULL, 0x050f70000004183cULL, 0x000000625c40723cULL, 0x000f700000041840ULL,
0x000000584844723cULL, 0x062b700000041844ULL, 0x0000005a4870723cULL, 0x040b700000041870ULL,
0x00000054486c723cULL, 0x040b70000004186cULL, 0x000000564830723cULL, 0x040b700000041830ULL,
0x000000504834723cULL, 0x040b700000041834ULL, 0x000000524838723cULL, 0x040b700000041838ULL,
0x0000004c483c723cULL, 0x044b70000004183cULL, 0x0000004e4848723cULL, 0x000b620000041840ULL,
0x0000046000008947ULL, 0x000fce0003800000ULL, 0x800000037a407210ULL, 0x020fe20007ffe0ffULL,
0x00000010a5a57824ULL, 0x100fe200078e02a6ULL, 0x00000018a7a77812ULL, 0x000fe200078efcffULL,
0x00000010a4417824ULL, 0x100fe200078e02a6ULL, 0x000000400500720cULL, 0x080fe20003f06070ULL,
0x00000010a3a37824ULL, 0x000fe200078e02a6ULL, 0x000000400900720cULL, 0x080fe20003f26070ULL,
0x00000010a7be7825ULL, 0x000fe200078e00beULL, 0x000000400f00720cULL, 0x000fc40003f46070ULL,
0x000000401100720cULL, 0x080fe20003f66070ULL, 0x00000010a7bc7825ULL, 0x000fe200078e00bcULL,
0x000000401300720cULL, 0x080fe40003f86070ULL, 0x000000401500720cULL, 0x080fe20003fa6070ULL,
0x00000010a7ba7825ULL, 0x000fe200078e00baULL, 0x000000401700720cULL, 0x080fe20003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000bea57faeULL, 0x0003e2000c101c46ULL,
0x000000400b00720cULL, 0x000fe20003f06070ULL, 0x00000010a7b87825ULL, 0x000fe200078e00b8ULL,
0x000000a6a2437211ULL, 0x000fe200078e20ffULL, 0x00000000bc417faeULL, 0x0005e2000c901c46ULL,
0x000000400d00720cULL, 0x000fe20003f26070ULL, 0x00000010a1a17824ULL, 0x000fe200078e02a6ULL,
0x000000a69e4f7211ULL, 0x080fe200078e20ffULL, 0x00000010a7b67825ULL, 0x000fe200078e00b6ULL,
0x000000a69a537211ULL, 0x000fc400078e20ffULL, 0x000000a696557211ULL, 0x000fe200078e20ffULL,
0x00000010a04d7824ULL, 0x000fe400078e02a6ULL, 0x00000010a7b47825ULL, 0x000fe200078e00b4ULL,
0x00000000baa37faeULL, 0x0003e2000c101c46ULL, 0x000000401900720cULL, 0x080fe40003f06070ULL,
0x000000109f9f7824ULL, 0x000fe200078e02a6ULL, 0x00000000b8437faeULL, 0x0003e2000c901c46ULL,
0x00000010a7b27825ULL, 0x000fe200078e00b2ULL, 0x000000401b00720cULL, 0x000fc40003f26070ULL,
0x00000000b6a17faeULL, 0x0003e2000d101c46ULL, 0x00000010a7b07825ULL, 0x000fe200078e00b0ULL,
0x000000401d00720cULL, 0x080fe40003f46070ULL, 0x00000000b44d7faeULL, 0x0003e2000d901c46ULL,
0x000000109d9d7824ULL, 0x000fe200078e02a6ULL, 0x000000401f00720cULL, 0x080fe20003f66070ULL,
0x00000010a7ae7825ULL, 0x000fe200078e00aeULL, 0x00000000b29f7faeULL, 0x0003e2000e101c46ULL,
0x000000402100720cULL, 0x080fe40003f86070ULL, 0x000000109c517824ULL, 0x000fe200078e02a6ULL,
0x00000000b04f7faeULL, 0x0003e2000e901c46ULL, 0x000000402300720cULL, 0x000fe20003fa6070ULL,
0x00000010a7ac7825ULL, 0x000fc400078e00acULL, 0x00000000ae9d7faeULL, 0x0003e2000f101c46ULL,
0x000000402500720cULL, 0x000fe20003fc6070ULL, 0x000000109b9b7824ULL, 0x000fe400078e02a6ULL,
0x00000010a7aa7825ULL, 0x040fe200078e00aaULL, 0x00000000ac517faeULL, 0x0003e6000c101c46ULL,
0x00000010a7c87825ULL, 0x000fe200078e00c8ULL, 0x00000000aa9b7faeULL, 0x0003e6000c901c46ULL,
0x0000001099997824ULL, 0x000fe200078e02a6ULL, 0x00000000c8537faeULL, 0x0003e2000d101c46ULL,
0x00000010a7c67825ULL, 0x000fc800078e00c6ULL, 0x0000001098417824ULL, 0x004fe200078e02a6ULL,
0x00000000c6997faeULL, 0x0003e2000d901c46ULL, 0x00000010a7c47825ULL, 0x000fc800078e00c4ULL,
0x0000001097977824ULL, 0x000fe200078e02a6ULL, 0x00000000c4417faeULL, 0x0003e2000e101c46ULL,
0x00000010a7c27825ULL, 0x000fc800078e00c2ULL, 0x00000010a7c07825ULL, 0x000fe200078e00c0ULL,
0x00000000c2977faeULL, 0x0003e8000e901c46ULL, 0x00000000c0557faeULL, 0x0003e2000f101c46ULL,
0x0000034000007947ULL, 0x000fea0003800000ULL, 0x00000018a7a77812ULL, 0x000fe200078efcffULL,
0x00000010a5a57824ULL, 0x100fe200078e02a6ULL, 0x000000a6a2437211ULL, 0x0a0fe200078e20ffULL,
0x00000010a4417824ULL, 0x000fe200078e02a6ULL, 0x000000a69e4f7211ULL, 0x080fe200078e20ffULL,
0x00000010a7be7825ULL, 0x000fe200078e00beULL, 0x000000a69a537211ULL, 0x000fc400078e20ffULL,
0x000000a696577211ULL, 0x000fe200078e20ffULL, 0x00000010a7bc7825ULL, 0x000fe200078e00bcULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000bea57faeULL, 0x0003e6000b901c46ULL,
0x00000010a3a37824ULL, 0x000fe200078e02a6ULL, 0x00000000bc417faeULL, 0x0003e2000b901c46ULL,
0x00000010a7ba7825ULL, 0x000fc800078e00baULL, 0x00000010a7b87825ULL, 0x000fe200078e00b8ULL,
0x00000000baa37faeULL, 0x0003e6000b901c46ULL, 0x00000010a1a17824ULL, 0x000fe200078e02a6ULL,
0x00000000b8437faeULL, 0x0003e2000b901c46ULL, 0x00000010a7b67825ULL, 0x000fc800078e00b6ULL,
0x00000010a04d7824ULL, 0x000fe200078e02a6ULL, 0x00000000b6a17faeULL, 0x0003e2000b901c46ULL,
0x00000010a7b47825ULL, 0x000fc800078e00b4ULL, 0x000000109f9f7824ULL, 0x000fe200078e02a6ULL,
0x00000000b44d7faeULL, 0x0003e2000b901c46ULL, 0x00000010a7b27825ULL, 0x000fc800078e00b2ULL,
0x00000010a7b07825ULL, 0x000fe200078e00b0ULL, 0x00000000b29f7faeULL, 0x0003e6000b901c46ULL,
0x000000109d9d7824ULL, 0x000fe200078e02a6ULL, 0x00000000b04f7faeULL, 0x0003e2000b901c46ULL,
0x00000010a7ae7825ULL, 0x000fc800078e00aeULL, 0x000000109c517824ULL, 0x000fe200078e02a6ULL,
0x00000000ae9d7faeULL, 0x0003e2000b901c46ULL, 0x00000010a7ac7825ULL, 0x000fc800078e00acULL,
0x000000109b9b7824ULL, 0x000fe200078e02a6ULL, 0x00000000ac517faeULL, 0x0003e2000b901c46ULL,
0x00000010a7aa7825ULL, 0x000fc800078e00aaULL, 0x00000010a7c87825ULL, 0x000fe200078e00c8ULL,
0x00000000aa9b7faeULL, 0x0003e6000b901c46ULL, 0x0000001099997824ULL, 0x000fe200078e02a6ULL,
0x00000000c8537faeULL, 0x0003e2000b901c46ULL, 0x00000010a7c67825ULL, 0x000fc800078e00c6ULL,
0x0000001098557824ULL, 0x000fe200078e02a6ULL, 0x00000000c6997faeULL, 0x0003e2000b901c46ULL,
0x00000010a7c47825ULL, 0x000fc800078e00c4ULL, 0x0000001097977824ULL, 0x000fe200078e02a6ULL,
0x00000000c4557faeULL, 0x0003e2000b901c46ULL, 0x00000010a7c27825ULL, 0x000fc800078e00c2ULL,
0x00000010a7c07825ULL, 0x000fe200078e00c0ULL, 0x00000000c2977faeULL, 0x0003e8000b901c46ULL,
0x00000000c0577faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000002006417824ULL, 0x042fe200078e00ffULL, 0x0000001007407810ULL, 0x040fe20007ffe0ffULL,
0x00000020064d7824ULL, 0x000fe200078e00ffULL, 0x00000012074c7810ULL, 0x000fe40007ffe0ffULL,
0xffffffe041407812ULL, 0x000fc400078ee240ULL, 0xffffffe04d4c7812ULL, 0x000fc600078ee24cULL,
0x0000001040587824ULL, 0x000fe200078e00ffULL, 0x000000044c4c7819ULL, 0x000fe200000006ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000005858783bULL, 0x000fe80000000200ULL,
0x000000009540783bULL, 0x000e680000000200ULL, 0x00000000a864783bULL, 0x000ea80000000200ULL,
0x000000004c4c783bULL, 0x000fe80000000200ULL, 0x000000009150783bULL, 0x000ee80000000200ULL,
0x000000009460783bULL, 0x000f280000000200ULL, 0x00000000935c783bULL, 0x000ee80000000200ULL,
0x000000009254783bULL, 0x000ee80000000200ULL, 0x000000008674783bULL, 0x000fe80000000200ULL,
0x000000008268783bULL, 0x000fe20000000200ULL, 0x00000040586c723cULL, 0x042f70000004186cULL,
0x000000645844723cULL, 0x044f700000041844ULL, 0x000000665870723cULL, 0x040b640000041870ULL,
0x000000009064783bULL, 0x020e6c0000000200ULL, 0x000000425830723cULL, 0x000b640000041830ULL,
0x000000008f40783bULL, 0x020eac0000000200ULL, 0x000000504c6c723cULL, 0x008bee000004186cULL,
0x0000002006517824ULL, 0x020fe200078e00ffULL, 0x000000605834723cULL, 0x010f620000041834ULL,
0x0000001407507810ULL, 0x000fc80007ffe0ffULL, 0xffffffe051507812ULL, 0x000fc600078ee250ULL,
0x000000625838723cULL, 0x040b640000041838ULL, 0x000000008860783bULL, 0x020fec0000000200ULL,
0x0000005c583c723cULL, 0x040b6e000004183cULL, 0x00000010505c7824ULL, 0x020fe200078e00ffULL,
0x0000005e5848723cULL, 0x000b640000041848ULL, 0x000000008c58783bULL, 0x020fe80000000200ULL,
0x000000005c5c783bULL, 0x000fe40000000200ULL, 0x000000544c44723cULL, 0x040f700000041844ULL,
0x000000564c70723cULL, 0x040b640000041870ULL, 0x000000008d54783bULL, 0x020eec0000000200ULL,
0x000000524c30723cULL, 0x040b640000041830ULL, 0x000000008e50783bULL, 0x020f2c0000000200ULL,
0x000000644c34723cULL, 0x042b6e0000041834ULL, 0x0000002006657824ULL, 0x020fe200078e00ffULL,
0x0000001607647810ULL, 0x000fe20007ffe0ffULL, 0x000000664c38723cULL, 0x000f660000041838ULL,
0xffffffe065647812ULL, 0x000fca00078ee264ULL, 0x000000404c3c723cULL, 0x044b6e000004183cULL,
0x0000000464407819ULL, 0x020fe200000006ffULL, 0x000000424c48723cULL, 0x000b620000041848ULL,
0x000000008064783bULL, 0x000fe80000000200ULL, 0x000000004040783bULL, 0x020e660000000200ULL,
0x000000545c6c723cULL, 0x048fe2000004186cULL, 0x000000007f4c783bULL, 0x000eae0000000200ULL,
0x000000505c44723cULL, 0x050f700000041844ULL, 0x000000525c70723cULL, 0x040f700000041870ULL,
0x000000565c30723cULL, 0x040f700000041830ULL, 0x000000585c34723cULL, 0x040f700000041834ULL,
0x0000005a5c38723cULL, 0x040f700000041838ULL, 0x000000605c3c723cULL, 0x040f70000004183cULL,
0x000000625c48723cULL, 0x000f700000041848ULL, 0x000000744044723cULL, 0x062f700000041844ULL,
0x000000764070723cULL, 0x040f700000041870ULL, 0x00000068406c723cULL, 0x040f70000004186cULL,
0x0000006a4030723cULL, 0x040f700000041830ULL, 0x000000644034723cULL, 0x040f700000041834ULL,
0x000000664038723cULL, 0x040f700000041838ULL, 0x0000004c403c723cULL, 0x044f70000004183cULL,
0x0000004e4048723cULL, 0x000b6e0000041848ULL, 0x000003007c407a10ULL, 0x020fc80007ffe0ffULL,
0x0000000140427810ULL, 0x040fe20007ffe0ffULL, 0x00000100404d7824ULL, 0x000fc600078e022fULL,
0x000000794200720cULL, 0x000fe20003f06070ULL, 0x00006200785c7a24ULL, 0x000fd800078e024dULL,
0x0000068000008947ULL, 0x000fea0003800000ULL, 0x0000004d7a417217ULL, 0x000fe20007800000ULL,
0x0000000105437824ULL, 0x100fe400078e025cULL, 0x000000010d4f7824ULL, 0x000fe400078e025cULL,
0x00000001415a7824ULL, 0x000fe200078e0a4dULL, 0x0000000400417819ULL, 0x000fe200000006ffULL,
0x00005e0043427625ULL, 0x000fc600078e0004ULL, 0x0000007041417812ULL, 0x000fe200078ec0ffULL,
0x00000001094d7824ULL, 0x100fe200078e025cULL, 0x0000005a0b00720cULL, 0x040fe20003f86070ULL,
0x000000010b0b7824ULL, 0x000fe200078e025cULL, 0x0000004241507210ULL, 0x000fe20007f1e0ffULL,
0x00005e004d4c7625ULL, 0x000fe200078e0004ULL, 0x0000005a0500720cULL, 0x000fe40003f66070ULL,
0x00000043ff517210ULL, 0x000fe200007fe4ffULL, 0x00005e000b427625ULL, 0x000fe200078e0004ULL,
0x0000004c41527210ULL, 0x000fc40007f1e0ffULL, 0x0000005a0900720cULL, 0x000fe20003f46070ULL,
0x000000010f057824ULL, 0x100fe200078e025cULL, 0x0000004241547210ULL, 0x000fe20007f3e0ffULL,
0x00005e004f4e7625ULL, 0x000fe200078e0004ULL, 0x0000005a0d00720cULL, 0x000fe40003fa6070ULL,
0x00000043ff557210ULL, 0x000fe20000ffe4ffULL, 0x0000000111097824ULL, 0x100fe200078e025cULL,
0x0000004e414e7210ULL, 0x000fe20007fde0ffULL, 0x000000ffff537224ULL, 0x000fe200000e064dULL,
0x0000005a0f00720cULL, 0x000fe20003f06070ULL, 0x00005e00054c7625ULL, 0x080fe200078e0004ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000050087faeULL, 0x0003e6000d901c46ULL,
0x00005e0009427625ULL, 0x000fe200078e0004ULL, 0x0000004c41567210ULL, 0x000fe20007f3e0ffULL,
0x00000000520a7faeULL, 0x0005e2000d101c46ULL, 0x0000005a1300720cULL, 0x000fe20003f46070ULL,
0x000000ffff4f7224ULL, 0x000fe200030e064fULL, 0x0000004241587210ULL, 0x000fe20007fde0ffULL,
0x0000000115097824ULL, 0x100fe200078e025cULL, 0x0000004dff577210ULL, 0x000fe20000ffe4ffULL,
0x0000000113057824ULL, 0x000fe200078e025cULL, 0x0000005a1100720cULL, 0x000fe20003f26070ULL,
0x000000ffff597224ULL, 0x000fe200030e0643ULL, 0x00000000540c7faeULL, 0x0007e2000e101c46ULL,
0x00005e0009427625ULL, 0x000fe200078e0004ULL, 0x0000005c17097210ULL, 0x000fc40007ffe0ffULL,
0x000000004e0e7faeULL, 0x0009e2000e901c46ULL, 0x00005e00054c7625ULL, 0x000fe200078e0004ULL,
0x0000004241427210ULL, 0x000fe40007fde0ffULL, 0x0000000056107faeULL, 0x0009e2000c101c46ULL,
0x00000001190b7824ULL, 0x000fe200078e025cULL, 0x0000004c414c7210ULL, 0x000fe20007f7e0ffULL,
0x00005e0009087625ULL, 0x002fe200078e0004ULL, 0x0000000058127faeULL, 0x0003e2000c901c46ULL,
0x0000005a1b00720cULL, 0x000fe40003f06070ULL, 0x00005e000b0a7625ULL, 0x004fe200078e0004ULL,
0x00000008410c7210ULL, 0x008fc40007f3e0ffULL, 0x0000005a1700720cULL, 0x000fe20003fa6070ULL,
0x000000011b1b7824ULL, 0x100fe200078e025cULL, 0x00000009ff0d7210ULL, 0x000fe20000ffe4ffULL,
0x000000ffff437224ULL, 0x000fe200030e0643ULL, 0x0000000a410e7210ULL, 0x010fe20007fde0ffULL,
0x000000ffff4d7224ULL, 0x000fe200018e064dULL, 0x0000005a1500720cULL, 0x000fe20003f66070ULL,
0x00005e001b087625ULL, 0x000fe200078e0004ULL, 0x0000005a1900720cULL, 0x000fe40003f86070ULL,
0x000000004c147faeULL, 0x0005e2000d101c46ULL, 0x000000011d057824ULL, 0x000fe200078e025cULL,
0x0000000841107210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200030e060bULL,
0x0000005a1d00720cULL, 0x000fe20003f26070ULL, 0x00005e00050a7625ULL, 0x000fe200078e0004ULL,
0x00000009ff117210ULL, 0x000fc400017fe4ffULL, 0x0000005a1f00720cULL, 0x040fe20003f46070ULL,
0x000000011f057824ULL, 0x100fe200078e025cULL, 0x0000000a41127210ULL, 0x002fe20007fde0ffULL,
0x0000000121157824ULL, 0x000fe200078e025cULL, 0x0000000042167faeULL, 0x0003e2000d901c46ULL,
0x00005e0005087625ULL, 0x000fc600078e0004ULL, 0x000000000c187faeULL, 0x0003e2000e901c46ULL,
0x0000000123057824ULL, 0x100fe200078e025cULL, 0x0000000841147210ULL, 0x004fe20007f7e0ffULL,
0x000000ffff137224ULL, 0x000fe200030e060bULL, 0x000000000e1a7faeULL, 0x0003e2000e101c46ULL,
0x00005e00150a7625ULL, 0x000fe200078e0004ULL, 0x00000009ff157210ULL, 0x000fe40001ffe4ffULL,
0x0000005a2100720cULL, 0x000fe20003f66070ULL, 0x00005e0005087625ULL, 0x000fe200078e0004ULL,
0x0000000a410a7210ULL, 0x000fe20007fde0ffULL, 0x00000000101c7faeULL, 0x0003e2000c101c46ULL,
0x0000005a2300720cULL, 0x000fe20003f86070ULL, 0x0000000125177824ULL, 0x000fe200078e025cULL,
0x0000000841087210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff0b7224ULL, 0x000fe200030e060bULL,
0x00000000121e7faeULL, 0x0003e2000c901c46ULL, 0x00005e0017047625ULL, 0x000fc600078e0004ULL,
0x0000000014207faeULL, 0x0003e2000d101c46ULL, 0x000000ffff097224ULL, 0x000fe200028e0609ULL,
0x0000005a2500720cULL, 0x000fe40003fa6070ULL, 0x0000000441047210ULL, 0x000fe20007fde0ffULL,
0x000000000a227faeULL, 0x0003e8000d901c46ULL, 0x000000ffff057224ULL, 0x000fe200030e0605ULL,
0x0000000008247faeULL, 0x0003ea000e101c46ULL, 0x0000000004267faeULL, 0x0003e2000e901c46ULL,
0x0000055000007947ULL, 0x000fea0003800000ULL, 0x0000005c05437210ULL, 0x080fe20007ffe0ffULL,
0x0000001000057824ULL, 0x000fe200078e00ffULL, 0x0000005c0f537210ULL, 0x080fe20007ffe0ffULL,
0x00000001094d7824ULL, 0x000fe200078e025cULL, 0x0000005c175b7210ULL, 0x000fe20007ffe0ffULL,
0x00005e0043427625ULL, 0x000fe200078e0004ULL, 0x0000007005057812ULL, 0x000fc400078ec0ffULL,
0x0000005c1d617210ULL, 0x000fe20007ffe0ffULL, 0x00005e004d4c7625ULL, 0x000fe200078e0004ULL,
0x0000004205427210ULL, 0x000fe40007f1e0ffULL, 0x0000005c25697210ULL, 0x000fe20007ffe0ffULL,
0x000000010b4f7824ULL, 0x000fe400078e025cULL, 0x000000ffff437224ULL, 0x000fe200000e0643ULL,
0x0000004c054c7210ULL, 0x000fe20007f1e0ffULL, 0x00005e0053527625ULL, 0x000fc600078e0004ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000042087faeULL, 0x0003e2000b901c46ULL,
0x00005e004f4e7625ULL, 0x000fc800078e0004ULL, 0x0000000113577824ULL, 0x100fe200078e025cULL,
0x0000004e054e7210ULL, 0x000fe20007f3e0ffULL, 0x0000000111557824ULL, 0x000fe400078e025cULL,
0x000000ffff4d7224ULL, 0x000fe200000e064dULL, 0x0000005205527210ULL, 0x000fe20007f1e0ffULL,
0x00005e0057567625ULL, 0x000fc600078e0004ULL, 0x000000004c0a7faeULL, 0x0003e2000b901c46ULL,
0x00005e0055547625ULL, 0x000fc800078e0004ULL, 0x0000000115597824ULL, 0x100fe400078e025cULL,
0x000000010d517824ULL, 0x000fe400078e025cULL, 0x000000ffff537224ULL, 0x000fe200000e0653ULL,
0x0000005605567210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff4f7224ULL, 0x000fe200008e064fULL,
0x0000005405547210ULL, 0x000fe20007f3e0ffULL, 0x00005e005b5a7625ULL, 0x000fc600078e0004ULL,
0x000000004e0c7faeULL, 0x0003e2000b901c46ULL, 0x00005e0059587625ULL, 0x000fc800078e0004ULL,
0x00000001195d7824ULL, 0x000fe400078e025cULL, 0x00005e0051507625ULL, 0x000fc800078e0004ULL,
0x000000011b5f7824ULL, 0x100fe200078e025cULL, 0x0000005005507210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff577224ULL, 0x000fe200000e0657ULL, 0x0000005a055a7210ULL, 0x000fe20007f1e0ffULL,
0x000000011f637824ULL, 0x100fe200078e025cULL, 0x00000051ff517210ULL, 0x000fe200017fe4ffULL,
0x0000000121657824ULL, 0x100fe400078e025cULL, 0x0000000123677824ULL, 0x000fe400078e025cULL,
0x000000ffff557224ULL, 0x000fe200008e0655ULL, 0x0000005805587210ULL, 0x000fe20007f3e0ffULL,
0x00005e005d5c7625ULL, 0x080fe200078e0004ULL, 0x00000000500e7faeULL, 0x0003e4000b901c46ULL,
0x00000059ff597210ULL, 0x000fe20000ffe4ffULL, 0x00005e0061607625ULL, 0x000fe200078e0004ULL,
0x0000005c055c7210ULL, 0x000fe20007f3e0ffULL, 0x0000000052107faeULL, 0x0003e4000b901c46ULL,
0x00005e005f5e7625ULL, 0x000fc400078e0004ULL, 0x0000000054127faeULL, 0x0003e4000b901c46ULL,
0x000000ffff5b7224ULL, 0x000fe200000e065bULL, 0x0000006005607210ULL, 0x000fe20007f1e0ffULL,
0x00005e0063627625ULL, 0x000fe200078e0004ULL, 0x0000005e055e7210ULL, 0x000fe20007f5e0ffULL,
0x0000000056147faeULL, 0x0003e2000b901c46ULL, 0x00000061ff617210ULL, 0x000fe200007fe4ffULL,
0x00005e0065647625ULL, 0x080fe400078e0004ULL, 0x0000000058167faeULL, 0x0003e4000b901c46ULL,
0x00005e0067667625ULL, 0x000fc400078e0004ULL, 0x000000005a187faeULL, 0x0003e4000b901c46ULL,
0x00005e0069687625ULL, 0x000fe200078e0004ULL, 0x0000006205047210ULL, 0x000fc60007f1e0ffULL,
0x000000ffff5d7224ULL, 0x000fe200008e065dULL, 0x0000006405627210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff5f7224ULL, 0x000fe200010e065fULL, 0x0000006605647210ULL, 0x040fe40007f5e0ffULL,
0x0000006805667210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff057224ULL, 0x000fe200000e0663ULL,
0x000000005c1a7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff637224ULL, 0x000fe400008e0665ULL,
0x000000ffff657224ULL, 0x000fe200010e0667ULL, 0x00000069ff677210ULL, 0x000fe20001ffe4ffULL,
0x000000005e1c7faeULL, 0x0003e8000b901c46ULL, 0x00000000601e7faeULL, 0x0003e8000b901c46ULL,
0x0000000004207faeULL, 0x0003e8000b901c46ULL, 0x0000000062227faeULL, 0x0003e8000b901c46ULL,
0x0000000064247faeULL, 0x0003e8000b901c46ULL, 0x0000000066267faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000002006057824ULL, 0x042fe200078e00ffULL,
0x0000001807047810ULL, 0x000fe20007ffe0ffULL, 0x0000002006087824ULL, 0x000fc600078e00ffULL,
0xffffffe005047812ULL, 0x000fe400078ee204ULL, 0x0000001a07057810ULL, 0x000fc60007ffe0ffULL,
0x0000001004047824ULL, 0x000fe200078e00ffULL, 0xffffffe008057812ULL, 0x000fc800078ee205ULL,
0x0000000405057819ULL, 0x000fe200000006ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000000410783bULL, 0x0003e80000000200ULL, 0x00000000280c783bULL, 0x000ea80000000200ULL,
0x000000002724783bULL, 0x000ee20000000200ULL, 0x0000001c07047810ULL, 0x042fe40007ffe0ffULL,
0x0000001e07077810ULL, 0x000fe20007ffe0ffULL, 0x000000002914783bULL, 0x000e680000000200ULL,
0x000000002a18783bULL, 0x000f280000000200ULL, 0x000000002b1c783bULL, 0x000fe80000000200ULL,
0x000000000508783bULL, 0x000e680000000200ULL, 0x000000002c20783bULL, 0x000e680000000200ULL,
0x000000007e4c783bULL, 0x000fe20000000200ULL, 0x0000000c106c723cULL, 0x044bee000004186cULL,
0x00000020060d7824ULL, 0x020fe200078e00ffULL, 0x000000241044723cULL, 0x008f680000041844ULL,
0xffffffe00d047812ULL, 0x000fc800078ee204ULL, 0x000000261070723cULL, 0x040b620000041870ULL,
0x0000001004047824ULL, 0x000fe200078e00ffULL, 0x000000007d24783bULL, 0x020eac0000000200ULL,
0x0000000e1030723cULL, 0x040b640000041830ULL, 0x00000000040c783bULL, 0x020fec0000000200ULL,
0x000000141034723cULL, 0x042f700000041834ULL, 0x000000161038723cULL, 0x040b640000041838ULL,
0x000000008114783bULL, 0x020e680000000200ULL, 0x000000008380783bULL, 0x000fe40000000200ULL,
0x00000018103c723cULL, 0x050b6e000004183cULL, 0x0000002006187824ULL, 0x020fe200078e00ffULL,
0x0000001a1048723cULL, 0x000b640000041848ULL, 0x000000008510783bULL, 0x020ee40000000200ULL,
0xffffffe018187812ULL, 0x000fc400078ee207ULL, 0x000000008404783bULL, 0x000f240000000200ULL,
0x0000001c0844723cULL, 0x000f620000041844ULL, 0x0000000418187819ULL, 0x000fcc00000006ffULL,
0x000000001818783bULL, 0x000fe20000000200ULL, 0x0000001e0870723cULL, 0x040b660000041870ULL,
0x000000008b1c783bULL, 0x020fea0000000200ULL, 0x00000020086c723cULL, 0x040f70000004186cULL,
0x000000220830723cULL, 0x040b640000041830ULL, 0x000000008920783bULL, 0x020fec0000000200ULL,
0x000000240834723cULL, 0x044f700000041834ULL, 0x000000260838723cULL, 0x040f700000041838ULL,
0x0000004c083c723cULL, 0x040f70000004183cULL, 0x0000004e0848723cULL, 0x000b640000041848ULL,
0x000000008708783bULL, 0x020eac0000000200ULL, 0x000000140c44723cULL, 0x042f700000041844ULL,
0x000000160c70723cULL, 0x040b640000041870ULL, 0x000000008a14783bULL, 0x020e6c0000000200ULL,
0x000000100c6c723cULL, 0x048f70000004186cULL, 0x000000120c30723cULL, 0x040f700000041830ULL,
0x000000040c34723cULL, 0x050ff00000041834ULL, 0x000000060c38723cULL, 0x040ff00000041838ULL,
0x000000800c3c723cULL, 0x040ff0000004183cULL, 0x000000820c48723cULL, 0x000ff00000041848ULL,
0x000000081844723cULL, 0x044f700000041844ULL, 0x0000000a1870723cULL, 0x040f700000041870ULL,
0x0000001c186c723cULL, 0x060f70000004186cULL, 0x0000001e1830723cULL, 0x000f620000041830ULL,
0x3d80000044447820ULL, 0x000fc40000410000ULL, 0x3d80000045457820ULL, 0x000fe40000410000ULL,
0x3d80000046467820ULL, 0x000fe40000410000ULL, 0x3d80000047477820ULL, 0x000fe20000410000ULL,
0x000000141834723cULL, 0x002f620000041834ULL, 0x3d80000070707820ULL, 0x000fe40000410000ULL,
0x3d80000071717820ULL, 0x000fe40000410000ULL, 0x3d80000072727820ULL, 0x000fc40000410000ULL,
0x3d80000073737820ULL, 0x000fe20000410000ULL, 0x000000161838723cULL, 0x040f640000041838ULL,
0x3d8000006c6c7820ULL, 0x020fe40000410000ULL, 0x3d8000006d6d7820ULL, 0x000fe40000410000ULL,
0x3d8000006e6e7820ULL, 0x000fe40000410000ULL, 0x3d8000006f6f7820ULL, 0x000fe20000410000ULL,
0x00000020183c723cULL, 0x000f62000004183cULL, 0x3d80000030307820ULL, 0x000fc40000410000ULL,
0x3d80000031317820ULL, 0x000fe40000410000ULL, 0x3d80000032327820ULL, 0x000fe40000410000ULL,
0x3d80000033337820ULL, 0x000fe20000410000ULL, 0x000000221848723cULL, 0x000f620000041848ULL,
0x3d80000034347820ULL, 0x000fe40000410000ULL, 0x3d80000035357820ULL, 0x000fe40000410000ULL,
0x3d80000036367820ULL, 0x000fc40000410000ULL, 0x3d80000037377820ULL, 0x000fe40000410000ULL,
0x3d80000038387820ULL, 0x000fe40000410000ULL, 0x3d80000039397820ULL, 0x000fe40000410000ULL,
0x3d8000003a3a7820ULL, 0x000fe40000410000ULL, 0x3d8000003b3b7820ULL, 0x000fe40000410000ULL,
0x3d8000003c3c7820ULL, 0x020fc40000410000ULL, 0x3d8000003d3d7820ULL, 0x000fe40000410000ULL,
0x3d8000003e3e7820ULL, 0x000fe40000410000ULL, 0x3d8000003f3f7820ULL, 0x000fe40000410000ULL,
0x3d80000048487820ULL, 0x000fe40000410000ULL, 0x3d80000049497820ULL, 0x000fe40000410000ULL,
0x3d8000004a4a7820ULL, 0x000fc40000410000ULL, 0x3d8000004b4b7820ULL, 0x000fe20000410000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000002e087f8cULL, 0x0002a4000c80043fULL,
0x0000000000047805ULL, 0x000fc40000015200ULL, 0x000004002e077984ULL, 0x000ee40000000800ULL,
0x8000000007ff7812ULL, 0x00cfe40007804809ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x00000006040b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09000b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011407ULL, 0x0000000b06067211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000206067819ULL, 0x000fc80000001207ULL,
0x000000060000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004002e077984ULL, 0x000ea40000000800ULL, 0x8000000007ff7812ULL, 0x004fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000200157819ULL, 0x000fe400000006ffULL,
0x0000002d7c00720cULL, 0x000fe40003f05270ULL, 0xfffffff015147812ULL, 0x000fca00078ec0ffULL,
0x000000807b147824ULL, 0x000fca00078e0214ULL, 0x01c4000014047984ULL, 0x0004e20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x0000000200087824ULL, 0x000fe400078e00ffULL,
0x000000017a0c7824ULL, 0x000fc600078e0a03ULL, 0x0000000608087812ULL, 0x000fc800078ec0ffULL,
0x0000000108037812ULL, 0x040fe400078efcffULL, 0x0000000808097812ULL, 0x040fe400078efcffULL,
0x0000000c0300720cULL, 0x080fe40003f26070ULL, 0x0000001008037812ULL, 0x000fe400078efcffULL,
0x0000000c0900720cULL, 0x080fe40003f06070ULL, 0x0000000c0300720cULL, 0x000fc40003fc6070ULL,
0x0000001108097812ULL, 0x040fe400078efcffULL, 0x0000001808037812ULL, 0x040fe400078efcffULL,
0x0000000c0800720cULL, 0x0c0fe40003f46070ULL, 0x0000000c0900720cULL, 0x080fe40003fa6070ULL,
0x0000000c0300720cULL, 0x000fe40003f66070ULL, 0x00000009080a7812ULL, 0x000fc400078efcffULL,
0x0000001908097812ULL, 0x040fe400078efcffULL, 0x0000002008037812ULL, 0x000fe400078efcffULL,
0xff80000046467808ULL, 0x000fe40005000000ULL, 0xff80000044447808ULL, 0x000fe40005000000ULL,
0xff80000047477808ULL, 0x000fe40004800000ULL, 0xff80000045457808ULL, 0x000fc40004800000ULL,
0x0000000c0a00720cULL, 0x080fe40003f86070ULL, 0x0000000c0900720cULL, 0x080fe40003f46070ULL,
0x0000000c0300720cULL, 0x000fe40003f26070ULL, 0x0000002108097812ULL, 0x040fe400078efcffULL,
0x0000002808037812ULL, 0x000fe400078efcffULL, 0xff80000072727808ULL, 0x000fc40004000000ULL,
0xff80000070707808ULL, 0x000fe40004000000ULL, 0xff80000073737808ULL, 0x000fe40006000000ULL,
0xff80000071717808ULL, 0x000fe40006000000ULL, 0x0000000c0900720cULL, 0x080fe40003f06070ULL,
0x0000000c0300720cULL, 0x000fe40003f86070ULL, 0x0000002908097812ULL, 0x000fc400078efcffULL,
0x0000003008037812ULL, 0x000fe400078efcffULL, 0xff8000006e6e7808ULL, 0x000fe40007000000ULL,
0xff8000006c6c7808ULL, 0x000fe40007000000ULL, 0xff8000006f6f7808ULL, 0x000fe40006800000ULL,
0xff8000006d6d7808ULL, 0x000fe40006800000ULL, 0x0000000c0900720cULL, 0x000fc40003fc6070ULL,
0x0000000c0300720cULL, 0x000fe40003fa6070ULL, 0x0000003108097812ULL, 0x040fe400078efcffULL,
0x0000003808037812ULL, 0x040fe400078efcffULL, 0x0000003908087812ULL, 0x000fe400078efcffULL,
0xff80000032327808ULL, 0x000fe40005800000ULL, 0xff80000030307808ULL, 0x000fc40005800000ULL,
0xff80000033337808ULL, 0x000fe40005000000ULL, 0xff80000031317808ULL, 0x000fe40005000000ULL,
0xff80000036367808ULL, 0x000fe40004800000ULL, 0xff80000034347808ULL, 0x000fe40004800000ULL,
0x0000000c0900720cULL, 0x080fe40003f66070ULL, 0x0000000c0300720cULL, 0x000fc40003f46070ULL,
0x0000000c0800720cULL, 0x000fe40003f26070ULL, 0xff80000037377808ULL, 0x000fe40004000000ULL,
0xff80000035357808ULL, 0x000fe40004000000ULL, 0xff8000003a3a7808ULL, 0x000fe40006000000ULL,
0xff80000038387808ULL, 0x000fe40006000000ULL, 0xff8000003b3b7808ULL, 0x000fc40007000000ULL,
0xff80000039397808ULL, 0x000fe40007000000ULL, 0xff8000003e3e7808ULL, 0x000fe40006800000ULL,
0xff8000003c3c7808ULL, 0x000fe40006800000ULL, 0xff8000003f3f7808ULL, 0x000fe40005800000ULL,
0xff8000003d3d7808ULL, 0x000fe40005800000ULL, 0xff8000004a4a7808ULL, 0x000fc40005000000ULL,
0xff80000048487808ULL, 0x000fe40005000000ULL, 0xff8000004b4b7808ULL, 0x000fe40004800000ULL,
0xff80000049497808ULL, 0x000fc40004800000ULL, 0x000000440400720bULL, 0x008fe40003f1e000ULL,
0x000000460500720bULL, 0x000fe40003f3e000ULL, 0x0000000444047208ULL, 0x000fe40004000000ULL,
0x0000000546087208ULL, 0x000fc40004800000ULL, 0x000000450400720bULL, 0x000fe40003f1e000ULL,
0x000000470800720bULL, 0x000fe40003f3e000ULL, 0x0000000445037208ULL, 0x000fe40004000000ULL,
0x0000000847057208ULL, 0x000fe40004800000ULL, 0x000000700300720bULL, 0x000fe40003f1e000ULL,
0x000000720500720bULL, 0x000fc40003f3e000ULL, 0x0000000370047208ULL, 0x000fe40004000000ULL,
0x0000000572087208ULL, 0x000fe40004800000ULL, 0x000000710400720bULL, 0x000fe40003f1e000ULL,
0x000000730800720bULL, 0x000fe40003f3e000ULL, 0x0000000471037208ULL, 0x000fe40004000000ULL,
0x0000000873057208ULL, 0x000fc40004800000ULL, 0x0000006c0300720bULL, 0x000fe40003f1e000ULL,
0x0000006e0500720bULL, 0x000fe40003f3e000ULL, 0x000000036c047208ULL, 0x000fe40004000000ULL,
0x000000056e087208ULL, 0x000fe40004800000ULL, 0x0000006d0400720bULL, 0x000fe40003f1e000ULL,
0x0000006f0800720bULL, 0x000fc40003f3e000ULL, 0x000000046d037208ULL, 0x000fe40004000000ULL,
0x000000086f057208ULL, 0x000fe40004800000ULL, 0x000000300300720bULL, 0x000fe40003f1e000ULL,
0x000000320500720bULL, 0x000fe40003f3e000ULL, 0x0000000330047208ULL, 0x000fe40004000000ULL,
0x0000000532087208ULL, 0x000fc40004800000ULL, 0x000000310400720bULL, 0x000fe40003f1e000ULL,
0x000000330800720bULL, 0x000fe40003f3e000ULL, 0x0000000431037208ULL, 0x000fe40004000000ULL,
0x0000000833057208ULL, 0x000fe40004800000ULL, 0x000000340300720bULL, 0x000fe40003f1e000ULL,
0x000000360500720bULL, 0x000fc40003f3e000ULL, 0x0000000334047208ULL, 0x000fe40004000000ULL,
0x0000000536087208ULL, 0x000fe40004800000ULL, 0x000000350400720bULL, 0x000fe40003f1e000ULL,
0x000000370800720bULL, 0x000fe40003f3e000ULL, 0x0000000435037208ULL, 0x000fe40004000000ULL,
0x0000000837057208ULL, 0x000fc40004800000ULL, 0x000000380300720bULL, 0x000fe40003f1e000ULL,
0x0000003a0500720bULL, 0x000fe40003f3e000ULL, 0x0000000338047208ULL, 0x000fe40004000000ULL,
0x000000053a087208ULL, 0x000fe40004800000ULL, 0x000000390400720bULL, 0x000fe40003f1e000ULL,
0x0000003b0800720bULL, 0x000fc40003f3e000ULL, 0x0000000439037208ULL, 0x000fe40004000000ULL,
0x000000083b057208ULL, 0x000fe40004800000ULL, 0x0000003c0300720bULL, 0x000fe40003f1e000ULL,
0x0000003e0500720bULL, 0x000fe40003f3e000ULL, 0x000000033c047208ULL, 0x000fe40004000000ULL,
0x000000053e087208ULL, 0x000fc40004800000ULL, 0x0000003d0400720bULL, 0x000fe40003f1e000ULL,
0x0000003f0800720bULL, 0x000fe40003f3e000ULL, 0x000000043d037208ULL, 0x000fe40004000000ULL,
0x000000083f057208ULL, 0x000fe40004800000ULL, 0x000000480300720bULL, 0x000fe40003f1e000ULL,
0x0000004a0500720bULL, 0x000fc40003f3e000ULL, 0x0000000348047208ULL, 0x000fe40004000000ULL,
0x000000054a087208ULL, 0x000fe40004800000ULL, 0x000000490400720bULL, 0x000fe40003f1e000ULL,
0x0000004b0800720bULL, 0x000fe40003f3e000ULL, 0x00000004490a7208ULL, 0x000fe40004000000ULL,
0x000000084b0c7208ULL, 0x000fe20004800000ULL, 0x00001b627f007947ULL, 0x000fec000b800000ULL,
0x0c401f000a037f89ULL, 0x00066400000e0000ULL, 0x000000030a00720bULL, 0x006fc80003f1e000ULL,
0x0000000a030e7208ULL, 0x000fe20004000000ULL, 0x00001b827f007947ULL, 0x000fea000b800000ULL,
0x0c401f000c037f89ULL, 0x000e6800000e0000ULL, 0x0c401f0006057f89ULL, 0x000ea800000e0000ULL,
0x0c401f0007047f89ULL, 0x000f2200000e0000ULL, 0x000000030c00720bULL, 0x002fc40003f1e000ULL,
0x000000050600720bULL, 0x004fe40003f3e000ULL, 0x0000000c03037208ULL, 0x000fe40004000000ULL,
0x0000000605087208ULL, 0x000fe40004800000ULL, 0x0c201f000e057f89ULL, 0x000e6200000e0000ULL,
0x000000040700720bULL, 0x010fc60003f1e000ULL, 0x0c201f00030a7f89ULL, 0x008ea200000e0000ULL,
0x0000000704167208ULL, 0x000fc60004000000ULL, 0x0c201f0008097f89ULL, 0x000ee800000e0000ULL,
0x0c201f0016177f89ULL, 0x0002e400000e0000ULL, 0x000000050e00720bULL, 0x002fe40003f1e000ULL,
0x0000000a0300720bULL, 0x004fe40003f3e000ULL, 0x0000000e05047208ULL, 0x000fc40004000000ULL,
0x000000090800720bULL, 0x008fe40003f5e000ULL, 0x000000030a057208ULL, 0x000fe40004800000ULL,
0x0000000809067208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b04037820ULL, 0x000fe20000410000ULL,
0x3f80000000047882ULL, 0x000fe20000000000ULL, 0x3fb8aa3b05077820ULL, 0x000fe20000410000ULL,
0x0000000400207c02ULL, 0x000fe20008000f00ULL, 0x3fb8aa3b45457823ULL, 0x100fe20000010803ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b71717823ULL, 0x100fe20000010803ULL,
0x3f8000002020783eULL, 0x000fe200000010ffULL, 0x3fb8aa3b44447823ULL, 0x100fe20000010803ULL,
0x00000002ff197819ULL, 0x000fe20000011600ULL, 0x3fb8aa3b70707823ULL, 0x000fe20000010803ULL,
0x0000004500457308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b46467823ULL, 0x100fe20000010807ULL,
0x00000001191b7810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b47477823ULL, 0x100fe20000010807ULL,
0x00000003191f7819ULL, 0x000fe200000006ffULL, 0x3fb8aa3b72727823ULL, 0x100fe20000010807ULL,
0x0000000c15227812ULL, 0x000fe200078ec0ffULL, 0x3fb8aa3b73737823ULL, 0x000fe20000010807ULL,
0x0000004400087308ULL, 0x000ea20000000800ULL, 0x000000ffff217224ULL, 0x000fe200078e0020ULL,
0x0000000300ff7812ULL, 0x000fe2000780c0ffULL, 0x3fb8aa3b6d6d7823ULL, 0x100fe20000010803ULL,
0x000000171600720bULL, 0x000fe20003f3e000ULL, 0x3fb8aa3b31317823ULL, 0x000fc40000010803ULL,
0x3fb8aa3b6c6c7823ULL, 0x100fe20000010803ULL, 0x00000070000a7308ULL, 0x002fe20000000800ULL,
0x3fb8aa3b30307823ULL, 0x000fe40000010803ULL, 0x3fb8aa3b6e6e7823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b6f6f7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b32327823ULL, 0x100fe20000010807ULL,
0x0000007100717308ULL, 0x000e620000000800ULL, 0x000000084508723eULL, 0x004fe200000010ffULL,
0x3fb8aa3b33337823ULL, 0x000fc40000010807ULL, 0x3fb8aa3b35357823ULL, 0x100fe40000010803ULL,
0x3fb8aa3b39397823ULL, 0x100fe40000010803ULL, 0x0000004600097308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b34347823ULL, 0x100fe40000010803ULL, 0x3fb8aa3b38387823ULL, 0x000fe40000010803ULL,
0x3fb8aa3b36367823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b37377823ULL, 0x100fe20000010807ULL,
0x0000004700187308ULL, 0x000ea20000000800ULL, 0x0000000a710a723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b3a3a7823ULL, 0x000fc40000010807ULL, 0x3fb8aa3b3b3b7823ULL, 0x000fe40000010807ULL,
0x3fb8aa3b3c3c7823ULL, 0x100fe40000010803ULL, 0x00000072000b7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b3d3d7823ULL, 0x100fe40000010803ULL, 0x3fb8aa3b48487823ULL, 0x000fe40000010803ULL,
0x3fb8aa3b3e3e7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b3f3f7823ULL, 0x100fe20000010807ULL,
0x00000073001a7308ULL, 0x000e620000000800ULL, 0x000000091809723eULL, 0x004fe200000010ffULL,
0x3fb8aa3b4a4a7823ULL, 0x000fc40000010807ULL, 0x3fb8aa3b49037823ULL, 0x000fe40000010803ULL,
0x3fb8aa3b4b077823ULL, 0x000fe40000010807ULL, 0x0000006c000c7308ULL, 0x000fe20000000800ULL,
0x00000008191d7824ULL, 0x040fe400078e00ffULL, 0x00000008192c7824ULL, 0x000fe200078e00ffULL,
0x0000000b1a0b723eULL, 0x002fc800000010ffULL, 0x0000006d006d7308ULL, 0x000e660000000800ULL,
0x000000200824723cULL, 0x000f6a00000418ffULL, 0x00000030000e7308ULL, 0x000ff00000000800ULL,
0x0000003100317308ULL, 0x000ea20000000800ULL, 0x0000000c6d0c723eULL, 0x002fce00000010ffULL,
0x0000006e000d7308ULL, 0x000ff00000000800ULL, 0x0000006f001c7308ULL, 0x000e620000000800ULL,
0x0000000e310e723eULL, 0x004fce00000010ffULL, 0x00000032000f7308ULL, 0x000ff00000000800ULL,
0x00000033001e7308ULL, 0x000ea20000000800ULL, 0x0000000d1c0d723eULL, 0x002fe200000010ffULL,
0x00000008191c7824ULL, 0x000fca00078e00ffULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee219ULL,
0x0000003400107308ULL, 0x0003e20000000800ULL, 0x0000000f1e0f723eULL, 0x004fce00000010ffULL,
0x0000003500357308ULL, 0x000ea20000000800ULL, 0x00000008191e7824ULL, 0x040fe200078e00ffULL,
0x0000000319347819ULL, 0x042fe200000006ffULL, 0x000000200c24723cULL, 0x020f660000041824ULL,
0xfffffff81e1e7812ULL, 0x000fe400078ee21bULL, 0x0000003800127308ULL, 0x0003e20000000800ULL,
0x00000004191b7810ULL, 0x000fc80007ffe0ffULL, 0xfffffff82c2c7812ULL, 0x000fe400078ee21bULL,
0xffffffff191b7810ULL, 0x000fe20007ffe0ffULL, 0x0000003900397308ULL, 0x000ee20000000800ULL,
0x000000103510723eULL, 0x004fe200000010ffULL, 0x000000ffff387224ULL, 0x002fe200078e0020ULL,
0xfffffff834347812ULL, 0x000fca00078ee21bULL, 0x0000003600117308ULL, 0x000ff00000000800ULL,
0x0000003700187308ULL, 0x000e620000000800ULL, 0x000000123912723eULL, 0x008fe400000010ffULL,
0x0000002000397202ULL, 0x000fca0000000f00ULL, 0x0000003a00137308ULL, 0x000ff00000000800ULL,
0x0000003b001a7308ULL, 0x000ea20000000800ULL, 0x000000111811723eULL, 0x002fe400000010ffULL,
0x0000000219187810ULL, 0x000fc80007ffe0ffULL, 0xfffffff81d287812ULL, 0x000fe200078ee218ULL,
0x0000003c003c7308ULL, 0x000fe20000000800ULL, 0x0000000519187810ULL, 0x040fe40007ffe0ffULL,
0x00000008191d7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff81f307812ULL, 0x000fe400078ee218ULL,
0x000000131a13723eULL, 0x004fe200000010ffULL, 0x0000003d003d7308ULL, 0x000e620000000800ULL,
0x00000003191a7810ULL, 0x000fe20007ffe0ffULL, 0x000000081d367824ULL, 0x000fc600078e00ffULL,
0xfffffff81f2a7812ULL, 0x000fe200078ee21aULL, 0x000000201024723cULL, 0x020b620000041824ULL,
0x00000006191a7810ULL, 0x000fe20007ffe0ffULL, 0x0000004800487308ULL, 0x000fe20000000800ULL,
0xfffffff836367812ULL, 0x000fc800078ee21dULL, 0x0000000819217824ULL, 0x020fc600078e00ffULL,
0x0000000300037308ULL, 0x000ea20000000800ULL, 0x0000003c3d18723eULL, 0x002fe400000010ffULL,
0xfffffff821327812ULL, 0x000fca00078ee21aULL, 0x0000003e003e7308ULL, 0x000ff00000000800ULL,
0x0000003f003f7308ULL, 0x000e620000000800ULL, 0x00000048031a723eULL, 0x004fe400000010ffULL,
0x000120007b037811ULL, 0x000fc800078e58ffULL, 0x0000000334217211ULL, 0x080fe200078e20ffULL,
0x0000004a004a7308ULL, 0x000fe20000000800ULL, 0x000000101e157824ULL, 0x100fe200078e0203ULL,
0x000000032c1e7211ULL, 0x000fe200078e20ffULL, 0x000000102a1d7824ULL, 0x100fe200078e0203ULL,
0x0000002122217210ULL, 0x000fe20007ffe0ffULL, 0x00000010301f7824ULL, 0x000fe400078e0203ULL,
0x0000000122157824ULL, 0x000fe200078e0215ULL, 0x0000000700077308ULL, 0x000ea20000000800ULL,
0x0000003e3f19723eULL, 0x002fe200000010ffULL, 0x0000001032207824ULL, 0x000fe200078e0203ULL,
0x0000001d221d7210ULL, 0x040fe20007ffe0ffULL, 0x00000001221e7824ULL, 0x000fc400078e021eULL,
0x00000001221f7824ULL, 0x040fe400078e021fULL, 0x0000000122207824ULL, 0x000fe200078e0220ULL,
0x0000004a071b723eULL, 0x004fe200000010ffULL, 0x000000101c077824ULL, 0x100fe400078e0203ULL,
0x00000010281c7824ULL, 0x000fe400078e0203ULL, 0x0000000122077824ULL, 0x040fe400078e0207ULL,
0x000000381824723cULL, 0x000f620000041824ULL, 0x00000001221c7824ULL, 0x000fc400078e021cULL,
0x0000001036037824ULL, 0x000fe200078e0203ULL, 0x0000000807007388ULL, 0x0003e60000000800ULL,
0x0000000122227824ULL, 0x000fe200078e0203ULL, 0x0000000a15007388ULL, 0x0005e80000000800ULL,
0x0000000c1c007388ULL, 0x0005e20000000800ULL, 0x0000001617077208ULL, 0x002fc60004800000ULL,
0x0000000e1d007388ULL, 0x0005e80000000800ULL, 0x000000101e007388ULL, 0x0005e80000000800ULL,
0x000000121f007388ULL, 0x0005e20000000800ULL, 0x000000ffff257224ULL, 0x020fc600078e0026ULL,
0x0000001820007388ULL, 0x0005e80000000800ULL, 0x0000001a21007388ULL, 0x0005e80000000800ULL,
0x0000000922007388ULL, 0x0005e80000000800ULL, 0x0004000b15007388ULL, 0x0005e80000000800ULL,
0x0004000d1c007388ULL, 0x0005e80000000800ULL, 0x0004000f1d007388ULL, 0x0005e80000000800ULL,
0x000400111e007388ULL, 0x0005e80000000800ULL, 0x000400131f007388ULL, 0x0005e80000000800ULL,
0x0004001920007388ULL, 0x0005e80000000800ULL, 0x0004001b21007388ULL, 0x0005e80000000800ULL,
0x01c0000414008388ULL, 0x0005e80000000c00ULL, 0x01c2002414008388ULL, 0x0005e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01c6080002ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01c6100002ff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01c6180002ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000794000720cULL, 0x000fe20003f06070ULL,
0x01c6200002ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ffff7c7224ULL, 0x000fd600078e0040ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffff92a000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff027807ULL, 0x008fe20004000000ULL,
0xffffffffff477424ULL, 0x000fe200078e00ffULL, 0x0001665000497802ULL, 0x000fc40000000f00ULL,
0x000013b000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff027224ULL, 0x000fe200078e0047ULL,
0xfffeba6000007947ULL, 0x000fea000383ffffULL, 0x00000001ff027807ULL, 0x000fe20005800000ULL,
0xffffffffff477424ULL, 0x000fe200078e00ffULL, 0x000166b000497802ULL, 0x000fc40000000f00ULL,
0x0000135000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff1f7224ULL, 0x000fe200078e0047ULL,
0xfffeba9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4a7224ULL, 0x008fe200078e002dULL,
0x0000001f004b7802ULL, 0x000fe20000000f00ULL, 0xffffffffff4d7424ULL, 0x000fe200078e00ffULL,
0x00016720004c7802ULL, 0x000fc40000000f00ULL, 0x0000129000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff027224ULL, 0x004fe200078e004aULL, 0xfffebb1000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4a7224ULL, 0x000fe200078e002dULL, 0x0000001f004b7802ULL, 0x000fe20000000f00ULL,
0xffffffffff4d7424ULL, 0x000fe200078e00ffULL, 0x00016790004c7802ULL, 0x000fc40000000f00ULL,
0x0000122000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff027224ULL, 0x004fe200078e004aULL,
0xfffebc1000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4a7224ULL, 0x000fe200078e001eULL,
0x0000001f00027202ULL, 0x000fe20000000f00ULL, 0x0000001fff4b7424ULL, 0x000fe200078e00ffULL,
0x00016810004c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff4d7424ULL, 0x000fc400078e00ffULL,
0x000011a000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff1c7224ULL, 0x004fe200078e004aULL,
0xfffebda000007947ULL, 0x000fea000383ffffULL, 0x0000001d00027202ULL, 0x000fe20000000f00ULL,
0x000000ffff4a7224ULL, 0x000fe200078e001eULL, 0x00016890004c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff4b7424ULL, 0x000fc400078e00ffULL, 0xffffffffff4d7424ULL, 0x000fc400078e00ffULL,
0x0000112000007944ULL, 0x006fea0003c00000ULL, 0x0000004a001d7202ULL, 0x004fe20000000f00ULL,
0xfffebd5000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4a7224ULL, 0x000fe200078e0020ULL,
0x0000001f004b7802ULL, 0x000fe20000000f00ULL, 0x000000ffff027224ULL, 0x000fe200078e0021ULL,
0x00016910004c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff4d7424ULL, 0x000fc400078e00ffULL,
0x000010a000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff1c7224ULL, 0x004fe200078e004aULL,
0xfffecdf000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4a7224ULL, 0x000fe200078e0020ULL,
0x0000001f004b7802ULL, 0x000fe20000000f00ULL, 0xffffffffff4d7424ULL, 0x000fe200078e00ffULL,
0x00016980004c7802ULL, 0x000fc40000000f00ULL, 0x0000103000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff1d7224ULL, 0x004fe200078e004aULL, 0xfffecdb000007947ULL, 0x000fea000383ffffULL,
0x00000001ff027807ULL, 0x008fe40004000000ULL, 0xffffffff00477802ULL, 0x000fc40000000f00ULL,
0x000169e000497802ULL, 0x000fc40000000f00ULL, 0x0000102000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff467224ULL, 0x000fe200078e0047ULL, 0xfffee09000007947ULL, 0x000fea000383ffffULL,
0x00000001ff027807ULL, 0x000fe20005000000ULL, 0xffffffffff477424ULL, 0x000fe200078e00ffULL,
0x00016a4000497802ULL, 0x000fc40000000f00ULL, 0x00000fc000007944ULL, 0x002fea0003c00000ULL,
0x0000004700437202ULL, 0x000fe20000000f00ULL, 0xfffee0c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4a7224ULL, 0x000fe200078e004eULL, 0x00016ab0004c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff4b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff4d7424ULL, 0x000fc400078e00ffULL,
0x00000f0000007944ULL, 0x002fea0003c00000ULL, 0x0000004a00027202ULL, 0x004fe20000000f00ULL,
0xfffee16000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4a7224ULL, 0x000fe200078e004eULL,
0x00016b20004c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff4b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff4d7424ULL, 0x000fc400078e00ffULL, 0x00000e9000007944ULL, 0x006fea0003c00000ULL,
0x0000004a00027202ULL, 0x004fe20000000f00ULL, 0xfffee25000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4a7224ULL, 0x000fe200078e0044ULL, 0xffffffff004d7802ULL, 0x000fe20000000f00ULL,
0x000000ffff027224ULL, 0x000fe200078e0045ULL, 0x00016ba0004c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff4b7424ULL, 0x000fc400078e00ffULL, 0x00000e1000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff1c7224ULL, 0x004fe200078e004aULL, 0xfffee3e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4a7224ULL, 0x000fe200078e0044ULL, 0xffffffff004d7802ULL, 0x000fe20000000f00ULL,
0x0000001fff4b7424ULL, 0x000fe200078e00ffULL, 0x00016c10004c7802ULL, 0x000fc40000000f00ULL,
0x00000da000007944ULL, 0x00efea0003c00000ULL, 0x000000ffff1d7224ULL, 0x004fe200078e004aULL,
0xfffee3a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4a7224ULL, 0x000fe200078e0044ULL,
0xffffffff004d7802ULL, 0x000fe20000000f00ULL, 0x000000ffff027224ULL, 0x000fe200078e0045ULL,
0x00016c90004c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff4b7424ULL, 0x000fc400078e00ffULL,
0x00000d2000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff1c7224ULL, 0x004fe200078e004aULL,
0xfffef18000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4a7224ULL, 0x000fe200078e0044ULL,
0xffffffff004d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff4b7424ULL, 0x000fe200078e00ffULL,
0x00016d00004c7802ULL, 0x000fc40000000f00ULL, 0x00000cb000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff1d7224ULL, 0x004fe200078e004aULL, 0xfffef14000007947ULL, 0x000fea000383ffffULL,
0x00000001ff027807ULL, 0x008fe40004000000ULL, 0xffffffff00477802ULL, 0x000fc40000000f00ULL,
0x00016d6000497802ULL, 0x000fc40000000f00ULL, 0x00000ca000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff457224ULL, 0x000fe200078e0047ULL, 0xffff023000007947ULL, 0x000fea000383ffffULL,
0x00000001ff027807ULL, 0x000fe20005000000ULL, 0xffffffffff477424ULL, 0x000fe200078e00ffULL,
0x00016dc000497802ULL, 0x000fc40000000f00ULL, 0x00000c4000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff487224ULL, 0x000fe200078e0047ULL, 0xffff025000007947ULL, 0x000fea000383ffffULL,
0x0000004e004a7202ULL, 0x000fe20000000f00ULL, 0x0000001fff4b7424ULL, 0x000fe200078e00ffULL,
0x00016e30004c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff4d7424ULL, 0x000fc400078e00ffULL,
0x00000b8000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff027224ULL, 0x004fe200078e004aULL,
0xffff02f000007947ULL, 0x000fea000383ffffULL, 0x0000004e004a7202ULL, 0x000fe20000000f00ULL,
0x0000001fff4b7424ULL, 0x000fe200078e00ffULL, 0x00016ea0004c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff4d7424ULL, 0x000fc400078e00ffULL, 0x00000b1000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff027224ULL, 0x004fe200078e004aULL, 0xffff03e000007947ULL, 0x000fea000383ffffULL,
0x00000044004a7202ULL, 0x000fe20000000f00ULL, 0x000000ffff027224ULL, 0x000fe200078e0045ULL,
0x00016f20004c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff4b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff4d7424ULL, 0x000fc400078e00ffULL, 0x00000a9000007944ULL, 0x008fea0003c00000ULL,
0x0000004a001c7202ULL, 0x004fe20000000f00ULL, 0xffff057000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4a7224ULL, 0x000fe200078e0044ULL, 0x00016f90004c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff4b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff4d7424ULL, 0x000fc400078e00ffULL,
0x00000a2000007944ULL, 0x00efea0003c00000ULL, 0x0000004a001d7202ULL, 0x004fe20000000f00ULL,
0xffff053000007947ULL, 0x000fea000383ffffULL, 0x00000044004a7202ULL, 0x000fe20000000f00ULL,
0x000000ffff027224ULL, 0x000fe200078e0045ULL, 0x00017010004c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff4b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff4d7424ULL, 0x000fc400078e00ffULL,
0x000009a000007944ULL, 0x000fea0003c00000ULL, 0x0000004a001c7202ULL, 0x004fe20000000f00ULL,
0xffff131000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4a7224ULL, 0x000fe200078e0044ULL,
0x00017080004c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff4b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff4d7424ULL, 0x000fc400078e00ffULL, 0x0000093000007944ULL, 0x006fea0003c00000ULL,
0x0000004a001d7202ULL, 0x004fe20000000f00ULL, 0xffff12d000007947ULL, 0x000fea000383ffffULL,
0x00000001ff027807ULL, 0x008fe20004000000ULL, 0xffffffffff477424ULL, 0x000fe200078e00ffULL,
0x000170e000497802ULL, 0x000fc40000000f00ULL, 0x0000092000007944ULL, 0x002fea0003c00000ULL,
0x0000004700377202ULL, 0x000fe20000000f00ULL, 0xffff23c000007947ULL, 0x000fea000383ffffULL,
0x00000001ff027807ULL, 0x000fe20004800000ULL, 0xffffffffff477424ULL, 0x000fe200078e00ffULL,
0x0001714000497802ULL, 0x000fc40000000f00ULL, 0x000008c000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff467224ULL, 0x000fe200078e0047ULL, 0xffff23e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4a7224ULL, 0x000fe200078e0036ULL, 0x0000001f004b7802ULL, 0x000fe20000000f00ULL,
0xffffffffff4d7424ULL, 0x000fe200078e00ffULL, 0x000171b0004c7802ULL, 0x000fc40000000f00ULL,
0x0000080000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff027224ULL, 0x004fe200078e004aULL,
0xffff248000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4a7224ULL, 0x000fe200078e0036ULL,
0x0000001f004b7802ULL, 0x000fe20000000f00ULL, 0xffffffffff4d7424ULL, 0x000fe200078e00ffULL,
0x00017220004c7802ULL, 0x000fc40000000f00ULL, 0x0000079000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff027224ULL, 0x004fe200078e004aULL, 0xffff257000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4a7224ULL, 0x000fe200078e0036ULL, 0x0000003700027202ULL, 0x000fe20000000f00ULL,
0x0000001fff4b7424ULL, 0x000fe200078e00ffULL, 0x000172a0004c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff4d7424ULL, 0x000fc400078e00ffULL, 0x0000071000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff1c7224ULL, 0x004fe200078e004aULL, 0xffff270000007947ULL, 0x000fea000383ffffULL,
0x00000036004a7202ULL, 0x000fe20000000f00ULL, 0x0000001fff4b7424ULL, 0x000fe200078e00ffULL,
0x00017310004c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff4d7424ULL, 0x000fc400078e00ffULL,
0x000006a000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff1d7224ULL, 0x004fe200078e004aULL,
0xffff26c000007947ULL, 0x000fea000383ffffULL, 0x0000001e004a7202ULL, 0x000fe20000000f00ULL,
0x000000ffff027224ULL, 0x000fe200078e001fULL, 0x00017390004c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff4b7424ULL, 0x000fc400078e00ffULL, 0xffffffffff4d7424ULL, 0x000fc400078e00ffULL,
0x0000062000007944ULL, 0x000fea0003c00000ULL, 0x0000004a001c7202ULL, 0x004fe20000000f00ULL,
0xffff34d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4a7224ULL, 0x000fe200078e001eULL,
0x00017400004c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff4b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff4d7424ULL, 0x000fc400078e00ffULL, 0x000005b000007944ULL, 0x006fea0003c00000ULL,
0x0000004a001d7202ULL, 0x004fe20000000f00ULL, 0xffff349000007947ULL, 0x000fea000383ffffULL,
0x00000002000b7802ULL, 0x000fe20000000f00ULL, 0x0000001fff037424ULL, 0x000fe200078e00ffULL,
0x0001747000087802ULL, 0x000fe20000000f00ULL, 0xffffffffff107424ULL, 0x000fc400078e00ffULL,
0x0000050000007944ULL, 0x006fea0003c00000ULL, 0xffffe45000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0a7224ULL, 0x008fe200078e000cULL, 0x00000002000b7802ULL, 0x000fe20000000f00ULL,
0x0000001fff037424ULL, 0x000fe200078e00ffULL, 0x000174e000087802ULL, 0x000fe20000000f00ULL,
0xffffffffff107424ULL, 0x000fc400078e00ffULL, 0x0000049000007944ULL, 0x000fea0003c00000ULL,
0x000000030c00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0a7224ULL, 0x002fe200078e0006ULL,
0x00000002000b7802ULL, 0x000fe20000000f00ULL, 0xffffffffff107424ULL, 0x000fe200078e00ffULL,
0x0000000c030c7208ULL, 0x000fe20004000000ULL, 0x0000001fff037424ULL, 0x000fe200078e00ffULL,
0x0001756000087802ULL, 0x000fc40000000f00ULL, 0x0000041000007944ULL, 0x000fea0003c00000ULL,
0x000000030600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0a7224ULL, 0x002fe200078e0007ULL,
0x00000002000b7802ULL, 0x000fe20000000f00ULL, 0xffffffffff107424ULL, 0x000fe200078e00ffULL,
0x0000000603067208ULL, 0x000fe20004000000ULL, 0x0000001fff037424ULL, 0x000fe200078e00ffULL,
0x000175e000087802ULL, 0x000fc40000000f00ULL, 0x0000039000007944ULL, 0x000fea0003c00000ULL,
0x000000030700720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0a7224ULL, 0x002fe200078e000eULL,
0x00000001000b7802ULL, 0x000fe20000000f00ULL, 0xffffffffff107424ULL, 0x000fe200078e00ffULL,
0x0000000703167208ULL, 0x000fe20004000000ULL, 0x0000001fff037424ULL, 0x000fe200078e00ffULL,
0x0001766000087802ULL, 0x000fc40000000f00ULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x000000030e00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0a7224ULL, 0x002fe200078e000cULL,
0x00000001000b7802ULL, 0x000fe20000000f00ULL, 0xffffffffff107424ULL, 0x000fe200078e00ffULL,
0x0000000e03047208ULL, 0x000fe20004000000ULL, 0x0000001fff037424ULL, 0x000fe200078e00ffULL,
0x000176e000087802ULL, 0x000fc40000000f00ULL, 0x0000029000007944ULL, 0x000fea0003c00000ULL,
0x000000030c00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0a7224ULL, 0x002fe200078e0006ULL,
0x00000001000b7802ULL, 0x000fe20000000f00ULL, 0xffffffffff107424ULL, 0x000fe200078e00ffULL,
0x0000000c03057208ULL, 0x000fe20004000000ULL, 0x0000001fff037424ULL, 0x000fe200078e00ffULL,
0x0001776000087802ULL, 0x000fc40000000f00ULL, 0x0000021000007944ULL, 0x000fea0003c00000ULL,
0x000000030600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0a7224ULL, 0x002fe200078e0016ULL,
0x00000001000b7802ULL, 0x000fe20000000f00ULL, 0xffffffffff107424ULL, 0x000fe200078e00ffULL,
0x0000000603067208ULL, 0x000fe20004000000ULL, 0x0000001fff037424ULL, 0x000fe200078e00ffULL,
0x000177e000087802ULL, 0x000fc40000000f00ULL, 0x0000019000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff177224ULL, 0x004fe200078e0003ULL, 0xffffe23000007947ULL, 0x000fea000383ffffULL,
0x0180000032047810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000004077812ULL, 0x000fc800078ec0ffULL, 0x018000000700780cULL, 0x000fda0003f05070ULL,
0x0000003200048308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0700720cULL, 0x040fe40003f25070ULL, 0x008000000700780cULL, 0x000fe40003f02070ULL,
0x00000001ff077807ULL, 0x000fe40000800000ULL, 0x00000001ff047807ULL, 0x004fc80004000000ULL,
0x0000000407ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff32ff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff047807ULL, 0x000fc80000000000ULL,
0x0000000407ff7212ULL, 0x000fe4000780c0ffULL, 0x8000000032077812ULL, 0x000fd600078ec0ffULL,
0x0080000007040812ULL, 0x000fe400078efcffULL, 0x0000000700048202ULL, 0x000fe20000000f00ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000003200047308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000ff077424ULL, 0x000fc800078e00ffULL,
0xfffe869006007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff097424ULL, 0x000fe200078e00ffULL,
0x0000001000007348ULL, 0x000fe80003800000ULL, 0x0c00000b0a037389ULL, 0x0002a200000e0003ULL,
0xfffe865008007950ULL, 0x000fea0003c3ffffULL, 0x0000004d00007348ULL, 0x000fe80003800000ULL,
0x000000024a4a7389ULL, 0x0002a200000e004bULL, 0x0000000000037802ULL, 0x000fe20000000f00ULL,
0x000000ffff027224ULL, 0x002fc800078e004cULL, 0xfffe860002007950ULL, 0x000fea0003c3ffffULL,
0x000000010200780cULL, 0x000fe20003f65070ULL, 0x0000004700007348ULL, 0x000fe80003800000ULL,
0x00000000ff037424ULL, 0x000fd000078e00ffULL, 0x0000000000027806ULL, 0x000fc800058e0100ULL,
0x0000004702477212ULL, 0x000fe200078ec0ffULL, 0x000000ffff027224ULL, 0x000fc800078e0049ULL,
0xfffe859002007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000001ULL, 0x0000000800000001ULL, 0x0000000100000001ULL, 0x0000000800000004ULL,
0x0000001000000001ULL, 0x0000000300000001ULL, 0x0000000400000004ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x000000000000054aULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000006a8ULL,
0x0000000000000258ULL, 0x0000001800000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000900ULL,
0x0000000000000298ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000b98ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c58ULL,
0x0000000000000670ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000012c8ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000012d8ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000007bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001368ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x000000000000136cULL,
0x00000000000001a8ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001580ULL,
0x0000000000017b00ULL, 0xcc00001800000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x0000000100000089ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000019080ULL,
0x000000000000003cULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x00000000000190c0ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x0000000000019440ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001368ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000017d18ULL,
0x0000000000017d18ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000019080ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000019440ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_1_kvt_bf16_nqpkv_8_m_8_sm_80_cubin_len = 103712;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
