/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_1_kvt_bf16_nqpkv_8_m_8_sm_86_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000018f40ULL, 0x0000000000018bc0ULL, 0x0038004000560556ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f34314944327961ULL, 0x6f6c66625f766e5fULL,
0x326a4c3236317461ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL,
0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x336a4c4536316a4cULL, 0x4c49746132454532ULL,
0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45346a4c4534366aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL,
0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL,
0x4d6e4974736e4939ULL, 0x4c45326a4c497461ULL, 0x45346a4c4545326aULL, 0x7461324545316a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL, 0x6a4c4532336a4c45ULL,
0x4c49746132454538ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x4545386a4c45386aULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x36316a4c4545346aULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x65746e695f5f2400ULL, 0x245f305f6c616e72ULL,
0x735f616475635f5fULL, 0x5f7063725f30326dULL, 0x665f7a74665f6e72ULL, 0x70776f6c735f3233ULL,
0x695f5f2400687461ULL, 0x5f6c616e7265746eULL, 0x6475635f5f245f31ULL, 0x735f30376d735f61ULL,
0x5f636e79736c6668ULL, 0x2400705f796c6662ULL, 0x6e7265746e695f5fULL, 0x5f5f245f325f6c61ULL,
0x376d735f61647563ULL, 0x79736c6668735f30ULL, 0x705f7864695f636eULL, 0x65746e695f5f2400ULL,
0x245f335f6c616e72ULL, 0x735f616475635f5fULL, 0x65746f765f30376dULL, 0x6c61625f636e7973ULL,
0x6c65722e00746f6cULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x240061686d5f6c65ULL, 0x6d5f6c656e72656bULL, 0x426d656d73246168ULL,
0x2e00667542657479ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x2e006d617261705fULL, 0x72665f6775626564ULL, 0x6c65722e00656d61ULL, 0x665f67756265642eULL,
0x65722e00656d6172ULL, 0x67756265642e616cULL, 0x2e00656d6172665fULL, 0x612e6c65722e766eULL,
0x0000006e6f697463ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c0001000000adULL, 0x000000000000002cULL, 0x0000000000000010ULL, 0x000c0001000000ebULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x000c00010000016bULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000c0001000001b5ULL, 0x0000000000000010ULL, 0x0000000000000004ULL, 0x000c0001000001fbULL,
0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c000100000242ULL, 0x0000000000000008ULL,
0x0000000000000004ULL, 0x000c000100000288ULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000c0001000002d6ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c000100000324ULL,
0x0000000000000020ULL, 0x0000000000000004ULL, 0x000c00010000036aULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c0001000003afULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000b0022000003f5ULL, 0x0000000000017230ULL, 0x0000000000000190ULL, 0x000b002200000428ULL,
0x00000000000173c0ULL, 0x0000000000000040ULL, 0x000b002200000453ULL, 0x0000000000017400ULL,
0x0000000000000050ULL, 0x000b00220000047dULL, 0x0000000000017450ULL, 0x0000000000000130ULL,
0x000a0003000004ebULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000400030000050bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000700030000053bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL, 0x0000000000017580ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0001723000000000ULL, 0x0000040400000000ULL, 0x810c000001440400ULL,
0x005b380400288080ULL, 0x0000000000000000ULL, 0x00000074ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8408288080820828ULL, 0x2880808808288080ULL, 0x809b082880808c08ULL, 0x08288080a5082880ULL,
0x8080bb08288080b8ULL, 0xda08288080d90828ULL, 0x2880808608288080ULL, 0x0003102880828016ULL,
0x9200000000000000ULL, 0x0000220028808086ULL, 0x00000034ffffffffULL, 0x0000007000000000ULL,
0x0001723000000000ULL, 0x0000019000000000ULL, 0x0000580400000000ULL, 0x8087288080840900ULL,
0x0900000004042880ULL, 0x2880808428808086ULL, 0x00000074ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8408288080820828ULL, 0x2880808608288080ULL, 0x808c082880808808ULL, 0x082880809b082880ULL,
0x8080b808288080a5ULL, 0xda08288080bb0828ULL, 0x2880808e08288080ULL, 0x0003102880828016ULL,
0x9200000000000000ULL, 0x000022002880808eULL, 0x0000001cffffffffULL, 0x0000013000000000ULL,
0x000173c000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x00000074ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8408288080820828ULL, 0x2880808608288080ULL, 0x808c082880808808ULL,
0x082880809b082880ULL, 0x8080b808288080a5ULL, 0xd908288080bb0828ULL, 0x288080da08288080ULL,
0x0003102880828016ULL, 0x9200000000000000ULL, 0x00002200288080daULL, 0x0000002cffffffffULL,
0x000001d800000000ULL, 0x0001740000000000ULL, 0x0000005000000000ULL, 0x0000100400000000ULL,
0x8088288080da0900ULL, 0x0000000000002880ULL, 0x00000074ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8408288080820828ULL, 0x2880808608288080ULL, 0x809b082880808c08ULL, 0x08288080a5082880ULL,
0x8080bb08288080b8ULL, 0xda08288080d90828ULL, 0x2880808808288080ULL, 0x0003102880828016ULL,
0x9200000000000000ULL, 0x0000220028808088ULL, 0x0000001cffffffffULL, 0x0000029000000000ULL,
0x0001745000000000ULL, 0x0000013000000000ULL, 0x0000000000000000ULL, 0x0000001800082f04ULL,
0x000823040000007aULL, 0x0000000000000014ULL, 0x0000001400081204ULL, 0x0008110400000000ULL,
0x0000000000000014ULL, 0x0000001300082304ULL, 0x0008120400000000ULL, 0x0000000000000013ULL,
0x0000001300081104ULL, 0x0008230400000000ULL, 0x0000000000000012ULL, 0x0000001200081204ULL,
0x0008110400000000ULL, 0x0000000000000012ULL, 0x0000001100082304ULL, 0x0008120400000000ULL,
0x0000000000000011ULL, 0x0000001100081104ULL, 0x0008230400000000ULL, 0x0000000000000018ULL,
0x0000001800081204ULL, 0x0008110400000000ULL, 0x0000000000000018ULL, 0x0000007b00043704ULL,
0x00080a0400003501ULL, 0x0048016000000015ULL, 0x000c170400481903ULL, 0x0040000600000000ULL,
0x000c17040021f000ULL, 0x0038000500000000ULL, 0x000c17040021f000ULL, 0x0030000400000000ULL,
0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040061f000ULL, 0x0010000200000000ULL,
0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL,
0x00ff1b030011f000ULL, 0x0000002000043104ULL, 0xffffffff01cc2904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x000000e001cc2804ULL, 0x0000033000000100ULL, 0x000020f0000012d0ULL, 0x0000227000002180ULL,
0x000025f0000023e0ULL, 0x0000267000002620ULL, 0x00002c10000026c0ULL, 0x0000373000003700ULL,
0x000037d000003780ULL, 0x00004a3000003cd0ULL, 0x00004bd000004ac0ULL, 0x00004f4000004d30ULL,
0x00004fc000004f70ULL, 0x000052a000005010ULL, 0x00005dc000005d90ULL, 0x00005e6000005e10ULL,
0x00006ed000006170ULL, 0x0000706000006f50ULL, 0x000073d0000071c0ULL, 0x0000745000007400ULL,
0x00007730000074a0ULL, 0x0000825000008220ULL, 0x000082f0000082a0ULL, 0x0000936000008600ULL,
0x000094f0000093e0ULL, 0x0000986000009650ULL, 0x000098e000009890ULL, 0x00009bf000009930ULL,
0x0000a7100000a6e0ULL, 0x0000a7b00000a760ULL, 0x0000ac800000ac70ULL, 0x0000cde00000b3e0ULL,
0x0000d4200000cdf0ULL, 0x0000daf00000d460ULL, 0x000157c000015780ULL, 0x000157e0000157d0ULL,
0x0001585000015830ULL, 0x0001588000015870ULL, 0x0001655000016500ULL, 0x000165f0000165a0ULL,
0x000166b000016650ULL, 0x0001676000016710ULL, 0x00016800000167b0ULL, 0x0001689000016840ULL,
0x00016940000168f0ULL, 0x000169f0000169a0ULL, 0x00016a9000016a40ULL, 0x00016b2000016ad0ULL,
0x00016bd000016b80ULL, 0x00016c8000016c30ULL, 0x00016d2000016cd0ULL, 0x00016dc000016d70ULL,
0x00016e7000016e20ULL, 0x00016f2000016ed0ULL, 0x00016fc000016f70ULL, 0x0001708000017020ULL,
0x00017140000170e0ULL, 0x00017200000171a0ULL, 0x0000023002003904ULL, 0x00014600000000ffULL,
0x000002c0003f0100ULL, 0x000146080000000dULL, 0x00000300003f0120ULL, 0x000146880000000dULL,
0x000004a0003f0120ULL, 0x00014600000000ffULL, 0x000005a0003f0107ULL, 0x0001468c00000042ULL,
0x00000650003f0102ULL, 0x0001468800000042ULL, 0x00001e10003f0101ULL, 0x0001460800000042ULL,
0x00001e30003f0101ULL, 0x0001460c00000042ULL, 0x00002000003f0105ULL, 0x0001460c00000042ULL,
0x00003c80003f0105ULL, 0x00014688000000ffULL, 0x000047b0003f0101ULL, 0x0001462800000042ULL,
0x000047d0003f0101ULL, 0x0001462c00000042ULL, 0x000049a0003f0105ULL, 0x0001462c00000042ULL,
0x00006130003f0105ULL, 0x00014690000000ffULL, 0x00006c50003f0101ULL, 0x0001464800000042ULL,
0x00006c70003f0101ULL, 0x0001464c00000042ULL, 0x00006e40003f0105ULL, 0x0001464c00000042ULL,
0x000085c0003f0105ULL, 0x00014698000000ffULL, 0x000090e0003f0101ULL, 0x0001466800000042ULL,
0x00009100003f0101ULL, 0x0001466c00000042ULL, 0x000092d0003f0105ULL, 0x0001466c00000042ULL,
0x0000aa80003f0105ULL, 0x000146a0000000ffULL, 0x0000de00003f0101ULL, 0x00014600000000ffULL,
0x0000e8e0003f0101ULL, 0x00014604000000ffULL, 0x0000eab0003f0105ULL, 0x00014604000000ffULL,
0x00014c90003f0105ULL, 0x0000000000000018ULL, 0x00014cb0003f0101ULL, 0x0000000400000018ULL,
0x00014e80003f0105ULL, 0x0000000400000018ULL, 0x00016360003f0105ULL, 0x0001460800000015ULL,
0x000163c0003f0101ULL, 0x0001461000000015ULL, 0x00016420003f0101ULL, 0x0001461800000015ULL,
0x00016490003f0101ULL, 0x0001462000000015ULL, 0x00033803003f0101ULL, 0x0000dd7000101c04ULL,
0x0000eb900000eb10ULL, 0x00000401000164d0ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL,
0x0000000000041e04ULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000324ULL,
0x0000001800000002ULL, 0x000000000000026cULL, 0x0000001800000002ULL, 0x00000000000001c4ULL,
0x0000001800000002ULL, 0x0000000000000104ULL, 0x0000001800000002ULL, 0x0000000000000044ULL,
0x0000001800000002ULL, 0x00000000000002ffULL, 0x0000001800000002ULL, 0x0000000000000247ULL,
0x0000001800000002ULL, 0x000000000000019fULL, 0x0000001800000002ULL, 0x00000000000000dfULL,
0x0000001800000002ULL, 0x0000000000014700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x00000000000d7919ULL, 0x000e620000002100ULL,
0x0000000000167806ULL, 0x000fe200038e0000ULL, 0x0000460000067ab9ULL, 0x000fe20000000a00ULL,
0x00000000000479c3ULL, 0x000ea20000002500ULL, 0x0000000000037919ULL, 0x000ee20000002300ULL,
0x0000001600057300ULL, 0x000f2600000e0000ULL, 0x0000000000027919ULL, 0x000ea80000002200ULL,
0x0000000000127919ULL, 0x000f220000002600ULL, 0x0000001600167309ULL, 0x000ea60000000000ULL,
0x0000000000437919ULL, 0x000f280000002700ULL, 0x0000000000067919ULL, 0x000f220000000000ULL,
0x00000005ff007819ULL, 0x002fc6000001160dULL, 0x00000000000c7919ULL, 0x000e680000000000ULL,
0x00001fff03077589ULL, 0x0087e200000e0000ULL, 0x0000010003027a24ULL, 0x004fc600078e0202ULL,
0x00001fff00007589ULL, 0x000ea200000e0000ULL, 0x00000000020d7a24ULL, 0x000fe400078e020dULL,
0x00005800ff027624ULL, 0x000fc600078e00ffULL, 0x000000ff0d00720cULL, 0x040fe20003f25270ULL,
0x0000000802037824ULL, 0x008fe200078e00ffULL, 0x0000000f0d00780cULL, 0x040fe20003f44070ULL,
0x0000000812027824ULL, 0x010fe200078e00ffULL, 0x0000007f0d00780cULL, 0x040fe40003f84070ULL,
0x000000030d00780cULL, 0x000fe20003f64070ULL, 0x0000004303087224ULL, 0x000fe200078e0202ULL,
0x000000060500720cULL, 0x000fe20003f02070ULL, 0x000000100c107824ULL, 0x002fc800078e00ffULL,
0x3fffff80ff029424ULL, 0x000fe200078e00ffULL, 0x000001f010157812ULL, 0x000fe200078ec0ffULL,
0x7fffff80ff039424ULL, 0x000fe200078e00ffULL, 0x0000000007047211ULL, 0x004fe200078e10ffULL,
0xff317217ff14c424ULL, 0x000fe200078e00ffULL, 0x7fffffc00005a802ULL, 0x000fe20000000f00ULL,
0x7fffff60ff0fb424ULL, 0x000fe200078e00ffULL, 0x01460002ff009388ULL, 0x0003e20000000a00ULL,
0x0000000204097824ULL, 0x000fe200078e00ffULL, 0x3fffff60000eb802ULL, 0x000fe20000000f00ULL,
0x3fffffc0ff04a424ULL, 0x000fe200078e00ffULL, 0x014400140d00c388ULL, 0x000fe20000004800ULL,
0x0000000109067824ULL, 0x040fe200078e020cULL, 0x00000008090a7817ULL, 0x040fe20007800000ULL,
0x0000002009117824ULL, 0x040fe200078e00ffULL, 0x0000000109137810ULL, 0x000fe20007ffe0ffULL,
0x014608040d00a388ULL, 0x000fe20000008a00ULL, 0x0000000108037824ULL, 0x002fc400078e0209ULL,
0xffffffe011117812ULL, 0x000fe200078ee206ULL, 0x00000200ff067424ULL, 0x000fe200078e00ffULL,
0x0146880e0d00b388ULL, 0x000fe20000008a00ULL, 0x000000010a0b7824ULL, 0x000fe400078e0a09ULL,
0x00005c0003027625ULL, 0x080fe200078e0006ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000001308057210ULL, 0x000fe20007ffe0ffULL, 0x0000000113097824ULL, 0x000fe200078e020cULL,
0x000000ff0b00720cULL, 0x000fe20003f23070ULL, 0x0000002013147824ULL, 0x000fe200078e00ffULL,
0x000000010b00780cULL, 0x000fe20003f43070ULL, 0x00005c0005047625ULL, 0x000fe200078e0006ULL,
0x0000001502087210ULL, 0x000fc40007f7e0ffULL, 0xffffffe014027812ULL, 0x000fe200078ee209ULL,
0x0000001011117824ULL, 0x000fe200078e00ffULL, 0x00000015040a7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff097224ULL, 0x000fe200018e0603ULL, 0x80000016ff0d7210ULL, 0x000fe20007ffe0ffULL,
0x0000001002037824ULL, 0x000fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x000fe200020e0605ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008117faeULL, 0x0003e2000c901c46ULL,
0x00000004ff047424ULL, 0x000fe400078e00ffULL, 0x00000004ff027e24ULL, 0x000fe2000f8e00ffULL,
0x000000000a037faeULL, 0x0003e2000d101c46ULL, 0x0000600043047625ULL, 0x000fc600078e0004ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0146040dffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01460000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000604037981ULL, 0x002ea2000c1e1900ULL, 0x000000ff0700720cULL, 0x000fc40003f05270ULL,
0x000000ff030d7810ULL, 0x004fc80007ffe0ffULL, 0x00000008ff0d7819ULL, 0x000fce000001160dULL,
0x0000d81000008947ULL, 0x000fea0003800000ULL, 0x0000000300427819ULL, 0x000fe200000006ffULL,
0x00000003ff057424ULL, 0x000fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01468c0542ff738cULL, 0x0003e20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000102087810ULL, 0x000fe20007ffe0ffULL, 0x0000000243437824ULL, 0x000fe200078e00ffULL,
0x0000580012047a10ULL, 0x000fe20007ffe0ffULL, 0x00000100020a7824ULL, 0x000fe200078e00ffULL,
0x0000000d0800720cULL, 0x000fe20003f06070ULL, 0x0146880042ff7f8cULL, 0x0005e4000c80043fULL,
0x0000580043437a24ULL, 0x000fc800078e0204ULL, 0x0000620043227a24ULL, 0x000fcc00078e020aULL,
0x000005a000008947ULL, 0x000fea0003800000ULL, 0x0000000a03047217ULL, 0x004fe20007800000ULL,
0x0000000800157824ULL, 0x000fe200078e00ffULL, 0x00000003ff087819ULL, 0x100fe4000001160cULL,
0x000000040a047210ULL, 0x000fe40007ffe1ffULL, 0x00000008080e7810ULL, 0x040fe20007ffe0ffULL,
0x0000000108097824ULL, 0x000fe200078e020cULL, 0x0000002004077817ULL, 0x000fe20003800000ULL,
0x0000000122057824ULL, 0x002fe200078e0208ULL, 0x0000000c08107810ULL, 0x000fe20007ffe0ffULL,
0x000000080e167824ULL, 0x000fe200078e00ffULL, 0x0000000709097812ULL, 0x000fe200078ec0ffULL,
0x00005e0005047625ULL, 0x000fe200078e0006ULL, 0x00000004080a7810ULL, 0x000fc40007ffe0ffULL,
0x000000070800720cULL, 0x000fe20003f06070ULL, 0x0000000110117824ULL, 0x100fe200078e020cULL,
0x0000c00000147811ULL, 0x000fe200078e68ffULL, 0x0000000810187824ULL, 0x000fe200078e00ffULL,
0xfffffff815157812ULL, 0x100fe200078ee20cULL, 0x000000010a0b7824ULL, 0x140fe200078e020cULL,
0x0ffffff809097812ULL, 0x000fe200078ef80cULL, 0x000000080a127824ULL, 0x000fe200078e00ffULL,
0x0000000c0e0f7210ULL, 0x000fe20007ffe0ffULL, 0x0000001015047825ULL, 0x000fe200078e0004ULL,
0xfffffff8181b7812ULL, 0x000fc400078ee211ULL, 0xfffffff816197812ULL, 0x000fe200078ee20fULL,
0x0000001009097824ULL, 0x100fe200078e0214ULL, 0x00000010080f7810ULL, 0x000fe20007ffe0ffULL,
0x000000101b1b7824ULL, 0x000fe200078e0214ULL, 0xfffffff812177812ULL, 0x000fe200078ee20bULL,
0x00000001220b7824ULL, 0x000fe200078e0210ULL, 0x0000001408117810ULL, 0x040fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004097faeULL, 0x0003e2000c101c46ULL,
0x0000001808127810ULL, 0x040fe20007ffe0ffULL, 0x0000001019197824ULL, 0x000fe200078e0214ULL,
0x0000001c08167810ULL, 0x000fe20007ffe0ffULL, 0x0000000111087824ULL, 0x140fe200078e020cULL,
0x000000070a00720cULL, 0x080fe20003f06070ULL, 0x00000008111f7824ULL, 0x000fe200078e00ffULL,
0x000000030f1d7819ULL, 0x040fe200000006ffULL, 0x0000000812237824ULL, 0x000fe200078e00ffULL,
0x000000070e00720cULL, 0x080fe20003f26070ULL, 0x0000000816277824ULL, 0x000fe200078e00ffULL,
0x000000071000720cULL, 0x080fe20003f46070ULL, 0x000000010f047824ULL, 0x042fe200078e020cULL,
0x0000000a22057210ULL, 0x040fe20007ffe0ffULL, 0x0000000122097824ULL, 0x000fe200078e020eULL,
0x000000070f00720cULL, 0x080fe20003f66070ULL, 0x00000001120a7824ULL, 0x100fe200078e020cULL,
0x000000071100720cULL, 0x080fe20003f86070ULL, 0x00000001160e7824ULL, 0x000fe200078e020cULL,
0x000000071200720cULL, 0x080fe20003fa6070ULL, 0x0000000122137824ULL, 0x000fe200078e0211ULL,
0x000000071600720cULL, 0x000fe20003fc6070ULL, 0x0000000122077824ULL, 0x000fe200078e020fULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee204ULL, 0x00005e0005047625ULL, 0x000fe200078e0006ULL,
0xfffffff81f1f7812ULL, 0x000fc400078ee208ULL, 0x0000001622257210ULL, 0x040fe20007ffe0ffULL,
0x0000000122217824ULL, 0x000fe200078e0212ULL, 0xfffffff823237812ULL, 0x000fe200078ee20aULL,
0x00005e0009087625ULL, 0x000fe200078e0006ULL, 0xfffffff827277812ULL, 0x000fe400078ee20eULL,
0x0000001417177211ULL, 0x000fe200078e20ffULL, 0x00005e000b0a7625ULL, 0x000fe200078e0006ULL,
0x0000001423237211ULL, 0x000fc600078e20ffULL, 0x00005e00070e7625ULL, 0x000fc800078e0006ULL,
0x00005e0013107625ULL, 0x000fc800078e0006ULL, 0x00005e0021127625ULL, 0x000fc800078e0006ULL,
0x00005e0025067625ULL, 0x000fc800078e0006ULL, 0x0000001015047825ULL, 0x000fc800078e0004ULL,
0x0000001015087825ULL, 0x040fe200078e0008ULL, 0x0000000004177faeULL, 0x0003e6000c101c46ULL,
0x00000010150a7825ULL, 0x040fe200078e000aULL, 0x0000000008197faeULL, 0x0003e6000c901c46ULL,
0x00000010150e7825ULL, 0x000fe200078e000eULL, 0x000000000a1b7faeULL, 0x0003e6000d101c46ULL,
0x000000101d1d7824ULL, 0x000fc400078e0214ULL, 0x0000001015107825ULL, 0x000fc600078e0010ULL,
0x000000000e1d7faeULL, 0x0003e2000d901c46ULL, 0x000000101f1f7824ULL, 0x000fe400078e0214ULL,
0x0000001015127825ULL, 0x000fc600078e0012ULL, 0x00000000101f7faeULL, 0x0003e2000e101c46ULL,
0x0000001015067825ULL, 0x000fc600078e0006ULL, 0x0000000012237faeULL, 0x0003e2000e901c46ULL,
0x0000001027277824ULL, 0x000fca00078e0214ULL, 0x0000000006277faeULL, 0x0003e2000f101c46ULL,
0x000004d000007947ULL, 0x000fea0003800000ULL, 0x000000040c097811ULL, 0x004fe200078fe8ffULL,
0x00000008001d7824ULL, 0x000fe200078e00ffULL, 0x000000080c0b7811ULL, 0x040fe400078fe8ffULL,
0x000000140c137811ULL, 0x040fe200078fe8ffULL, 0x0000000109047824ULL, 0x040fe200078e020cULL,
0x0000000c0c0f7811ULL, 0x040fe200078fe8ffULL, 0x0000000809057824ULL, 0x002fe200078e00ffULL,
0x000000030b157819ULL, 0x000fe200000006ffULL, 0x0000000813177824ULL, 0x000fe200078e00ffULL,
0x000000100c117811ULL, 0x040fe200078fe8ffULL, 0x000000080f1c7824ULL, 0x000fe200078e00ffULL,
0xfffffff805187812ULL, 0x000fe200078ee204ULL, 0x000000010b047824ULL, 0x100fe200078e020cULL,
0x0000000c13087210ULL, 0x080fe20007ffe0ffULL, 0x000000010f057824ULL, 0x100fe200078e020cULL,
0x0000001c0c197811ULL, 0x040fe200078fe8ffULL, 0x0000000111077824ULL, 0x000fe200078e020cULL,
0xfffffff8151a7812ULL, 0x000fe200078ee204ULL, 0x00000008111e7824ULL, 0x000fe200078e00ffULL,
0x000000180c157811ULL, 0x040fe200078fe8ffULL, 0x00000001190a7824ULL, 0x040fe200078e020cULL,
0x0000000c0c047211ULL, 0x000fe200078fe8ffULL, 0x00000008191f7824ULL, 0x000fe200078e00ffULL,
0xfffffff817207812ULL, 0x000fe200078ee208ULL, 0x0000000122177824ULL, 0x000fe200078e0215ULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee205ULL, 0x0000000115087824ULL, 0x040fe200078e020cULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee207ULL, 0x0000000122097824ULL, 0x000fe200078e0209ULL,
0x000000220c057211ULL, 0x000fe200078fe8ffULL, 0x00000001220b7824ULL, 0x040fe200078e020bULL,
0x0000000f220f7210ULL, 0x040fe20007ffe0ffULL, 0x0000000122117824ULL, 0x040fe200078e0211ULL,
0x0000000315157819ULL, 0x000fe200000006ffULL, 0x0000000122137824ULL, 0x000fe200078e0213ULL,
0x0000000704077812ULL, 0x000fe200078ec0ffULL, 0x00000001221b7824ULL, 0x000fe200078e0219ULL,
0xfffffff815227812ULL, 0x000fe200078ee208ULL, 0x00005e0005047625ULL, 0x000fe200078e0006ULL,
0xfffffff81f247812ULL, 0x000fc400078ee20aULL, 0x0ffffff807167812ULL, 0x100fe200078ef80cULL,
0x00005e0009087625ULL, 0x080fe200078e0006ULL, 0xfffffff81d197812ULL, 0x000fe400078ee20cULL,
0x0000c00000257811ULL, 0x000fe200078e68ffULL, 0x00005e000b0a7625ULL, 0x000fc600078e0006ULL,
0x0000002522237211ULL, 0x000fe200078e20ffULL, 0x00005e000f0e7625ULL, 0x000fc800078e0006ULL,
0x00005e0011107625ULL, 0x000fc800078e0006ULL, 0x00005e0013127625ULL, 0x000fc800078e0006ULL,
0x00005e0017147625ULL, 0x000fc800078e0006ULL, 0x00005e001b067625ULL, 0x000fc800078e0006ULL,
0x0000001019047825ULL, 0x000fc800078e0004ULL, 0x0000001019087825ULL, 0x000fc800078e0008ULL,
0x00000010190a7825ULL, 0x000fc800078e000aULL, 0x00000010190e7825ULL, 0x000fc800078e000eULL,
0x0000001019107825ULL, 0x000fc800078e0010ULL, 0x0000001019127825ULL, 0x000fc800078e0012ULL,
0x0000001019147825ULL, 0x000fc800078e0014ULL, 0x0000001019067825ULL, 0x000fe200078e0006ULL,
0x0000002518197211ULL, 0x000fc600078e20ffULL, 0x0000001016177824ULL, 0x100fe400078e0225ULL,
0x000000101a1b7824ULL, 0x100fe400078e0225ULL, 0x000000101c1d7824ULL, 0x100fe200078e0225ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004177faeULL, 0x0003e2000b901c46ULL,
0x000000101e1f7824ULL, 0x100fe400078e0225ULL, 0x0000001020217824ULL, 0x100fe200078e0225ULL,
0x0000000008197faeULL, 0x0003e2000b901c46ULL, 0x0000001024257824ULL, 0x000fc600078e0225ULL,
0x000000000a1b7faeULL, 0x0003e8000b901c46ULL, 0x000000000e1d7faeULL, 0x0003e8000b901c46ULL,
0x00000000101f7faeULL, 0x0003e8000b901c46ULL, 0x0000000012217faeULL, 0x0003e8000b901c46ULL,
0x0000000014237faeULL, 0x0003e8000b901c46ULL, 0x0000000006257faeULL, 0x0003e4000b901c46ULL,
0x0000000d0200720cULL, 0x000fe20003f06070ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xff317217ff587424ULL, 0x000fe200078e00ffULL, 0x0000000000067805ULL, 0x002fe2000001ff00ULL,
0x000000ffff417224ULL, 0x000fe200078e00ffULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000988000000947ULL, 0x000fea0003800000ULL, 0x0000001fff407424ULL, 0x000fe200078e00ffULL,
0xffffffff003f7802ULL, 0x000fe20000000f00ULL, 0xff317217ff587424ULL, 0x000fc400078e00ffULL,
0x000000ffff077224ULL, 0x000fc400078e00ffULL, 0x0000010002087824ULL, 0x020fca00078e00ffULL,
0x000000030800720cULL, 0x000fda0003f06070ULL, 0x000097d000000947ULL, 0x000fea0003800000ULL,
0x0000000102087810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000000d0800720cULL, 0x000fe40003f26070ULL, 0x00000020023e7811ULL, 0x000fca00078e40ffULL,
0x0000620043277a24ULL, 0x000fcc00078e023eULL, 0x000005b000009947ULL, 0x000fea0003800000ULL,
0x00000003ff297819ULL, 0x100fe2000001160cULL, 0x00000200ff2d7424ULL, 0x000fe200078e00ffULL,
0x0000003e03097217ULL, 0x000fe40007800000ULL, 0x00000004290f7810ULL, 0x040fe20007ffe0ffULL,
0x00000001290a7824ULL, 0x000fe200078e020cULL, 0x000000070c0b7812ULL, 0x000fe200078ec0ffULL,
0x0000000109097824ULL, 0x000fe200078e0a3eULL, 0x000000030f257819ULL, 0x040fe200000006ffULL,
0x000000010f087824ULL, 0x000fe200078e020cULL, 0x0000d000002a7811ULL, 0x000fe200078e68ffULL,
0x00000001422b7824ULL, 0x000fe200078e020bULL, 0x00000020090e7817ULL, 0x000fc40003800000ULL,
0xfffffff825257812ULL, 0x000fe400078ee208ULL, 0x0000002729087210ULL, 0x000fe40007ffe0ffULL,
0x000000070a0b7812ULL, 0x000fe200078ec0ffULL, 0x000000010f0a7824ULL, 0x000fe200078e0227ULL,
0x0000000e2900720cULL, 0x080fe20003f06070ULL, 0x00005e0008087625ULL, 0x080fe200078e002dULL,
0x0000000e0f00720cULL, 0x000fe40003f46070ULL, 0x0ffffff80b0f7812ULL, 0x000fe200078ef80cULL,
0x00005e000a0a7625ULL, 0x000fe200078e002dULL, 0x00000008292f7810ULL, 0x000fc40007ffe0ffULL,
0x0000000c29337810ULL, 0x000fe20007ffe0ffULL, 0x000000102b087825ULL, 0x000fe200078e0008ULL,
0x0000001029377810ULL, 0x040fe40007ffe0ffULL, 0x0000001429397810ULL, 0x000fe20007ffe0ffULL,
0x000000100f0f7824ULL, 0x100fe200078e022aULL, 0x00000018293d7810ULL, 0x000fe20007ffe0ffULL,
0x0000001025257824ULL, 0x000fe200078e022aULL, 0x0000001c29297810ULL, 0x000fe20007ffe0ffULL,
0x000000102b0a7825ULL, 0x000fe200078e000aULL, 0x0000000333357819ULL, 0x000fe200000006ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080f7faeULL, 0x0003e2000c101c46ULL,
0x0000000e2f00720cULL, 0x0c0fe20003f06070ULL, 0x000000012f247824ULL, 0x100fe200078e020cULL,
0x0000000e3700720cULL, 0x080fe20003f66070ULL, 0x000000082f317824ULL, 0x000fe200078e00ffULL,
0x000000000a257faeULL, 0x0005e2000d101c46ULL, 0x0000000133267824ULL, 0x140fe200078e020cULL,
0x0000000e3300720cULL, 0x080fe20003f46070ULL, 0x00000008372c7824ULL, 0x000fe200078e00ffULL,
0x0000000e3900720cULL, 0x080fe20003f86070ULL, 0x000000083d307824ULL, 0x040fe200078e00ffULL,
0x0000000e3d00720cULL, 0x080fe20003fa6070ULL, 0x0000000137097824ULL, 0x102fe200078e020cULL,
0x0000000e2900720cULL, 0x000fe20003fc6070ULL, 0x000000013d0f7824ULL, 0x000fe200078e020cULL,
0xfffffff831317812ULL, 0x000fe200078ee224ULL, 0x0000000829327824ULL, 0x000fe200078e00ffULL,
0xfffffff835357812ULL, 0x000fe200078ee226ULL, 0x00000001390b7824ULL, 0x004fe200078e020cULL,
0x00000027370e7210ULL, 0x000fe20007ffe0ffULL, 0x000000012f087824ULL, 0x100fe200078e0227ULL,
0x00000003392e7819ULL, 0x000fe200000006ffULL, 0x00000001330a7824ULL, 0x100fe200078e0227ULL,
0x0000000c29257210ULL, 0x000fe20007ffe0ffULL, 0x0000000139247824ULL, 0x000fe200078e0227ULL,
0xfffffff82c2f7812ULL, 0x000fe200078ee209ULL, 0x000000013d267824ULL, 0x000fe200078e0227ULL,
0xfffffff82e337812ULL, 0x000fe200078ee20bULL, 0x0000000129287824ULL, 0x000fe200078e0227ULL,
0xfffffff830377812ULL, 0x000fe200078ee20fULL, 0x00005e0008087625ULL, 0x000fe200078e002dULL,
0xfffffff832397812ULL, 0x000fc600078ee225ULL, 0x00005e000a0a7625ULL, 0x000fc800078e002dULL,
0x00005e000e0e7625ULL, 0x000fc800078e002dULL, 0x00005e0024247625ULL, 0x000fc800078e002dULL,
0x00005e0026267625ULL, 0x000fc800078e002dULL, 0x00005e0028287625ULL, 0x000fc800078e002dULL,
0x000000102b087825ULL, 0x000fc800078e0008ULL, 0x000000102b0a7825ULL, 0x000fc800078e000aULL,
0x000000102b0e7825ULL, 0x000fc800078e000eULL, 0x000000102b247825ULL, 0x000fc800078e0024ULL,
0x000000102b267825ULL, 0x000fc800078e0026ULL, 0x000000102b287825ULL, 0x000fc800078e0028ULL,
0x00000010312b7824ULL, 0x100fe200078e022aULL, 0x0000002a33317211ULL, 0x000fe200078e20ffULL,
0x00000010352d7824ULL, 0x100fe400078e022aULL, 0x000000102f2f7824ULL, 0x100fe200078e022aULL,
0x00000000082b7faeULL, 0x0003e2000c101c46ULL, 0x0000001037337824ULL, 0x100fe400078e022aULL,
0x0000001039357824ULL, 0x000fe200078e022aULL, 0x000000000a2d7faeULL, 0x0003e8000d101c46ULL,
0x000000000e2f7faeULL, 0x0003e8000d901c46ULL, 0x0000000024317faeULL, 0x0003e8000e101c46ULL,
0x0000000026337faeULL, 0x0003e8000e901c46ULL, 0x0000000028357faeULL, 0x0003e2000f101c46ULL,
0x000004e000007947ULL, 0x000fea0003800000ULL, 0x000000040c0a7811ULL, 0x040fe200078fe8ffULL,
0x00000200ff2d7424ULL, 0x000fe200078e00ffULL, 0x000000080c0e7811ULL, 0x000fc400078fe8ffULL,
0x0000000c0c247811ULL, 0x000fe200078fe8ffULL, 0x000000010a087824ULL, 0x000fe200078e020cULL,
0x000000100c267811ULL, 0x000fe200078fe8ffULL, 0x000000080a097824ULL, 0x000fe200078e00ffULL,
0x000000140c287811ULL, 0x000fe200078fe8ffULL, 0x000000080e257824ULL, 0x000fe200078e00ffULL,
0x0000001c0c2b7811ULL, 0x000fe200078fe8ffULL, 0x0000000824347824ULL, 0x040fe200078e00ffULL,
0xfffffff809307812ULL, 0x000fe200078ee208ULL, 0x0000000124097824ULL, 0x100fe200078e020cULL,
0x0000000c0e087210ULL, 0x080fe20007ffe0ffULL, 0x00000001260b7824ULL, 0x140fe200078e020cULL,
0x0000000326367819ULL, 0x000fe200000006ffULL, 0x00000001280f7824ULL, 0x040fe200078e020cULL,
0xfffffff825327812ULL, 0x000fe200078ee208ULL, 0x00000008283c7824ULL, 0x000fe200078e00ffULL,
0x000000180c257811ULL, 0x000fe200078fe8ffULL, 0x000000082b4e7824ULL, 0x000fe200078e00ffULL,
0xfffffff834347812ULL, 0x000fe200078ee209ULL, 0x000000010a0a7824ULL, 0x100fe200078e0227ULL,
0x0000000c0c097211ULL, 0x080fe200078fe8ffULL, 0x00000001252a7824ULL, 0x040fe200078e0227ULL,
0x0000000c25297210ULL, 0x040fe20007ffe0ffULL, 0x00000008254c7824ULL, 0x000fe200078e00ffULL,
0xfffffff836367812ULL, 0x000fe200078ee20bULL, 0x000000012b257824ULL, 0x000fe200078e020cULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee20fULL, 0x0000000124247824ULL, 0x100fe200078e0227ULL,
0x000000070c0b7812ULL, 0x000fe200078ec0ffULL, 0x0000000126267824ULL, 0x100fe200078e0227ULL,
0x000000270c087211ULL, 0x080fe200078fe8ffULL, 0x0000000128287824ULL, 0x100fe200078e0227ULL,
0x00000007090f7812ULL, 0x000fe200078ec0ffULL, 0x000000012b2c7824ULL, 0x000fe200078e0227ULL,
0x000000270e0e7210ULL, 0x000fe20007ffe0ffULL, 0x00005e0008087625ULL, 0x000fe200078e002dULL,
0x0000000b422f7210ULL, 0x000fc40007ffe0ffULL, 0xfffffff84c4c7812ULL, 0x000fe200078ee229ULL,
0x00005e000a0a7625ULL, 0x080fe200078e002dULL, 0xfffffff84e4e7812ULL, 0x000fe400078ee225ULL,
0x0ffffff80f2e7812ULL, 0x000fe200078ef80cULL, 0x00005e000e0e7625ULL, 0x000fe200078e002dULL,
0x0000d000004d7811ULL, 0x000fc600078e68ffULL, 0x00005e0024247625ULL, 0x000fe200078e002dULL,
0x0000004d36377211ULL, 0x000fc600078e20ffULL, 0x00005e0026267625ULL, 0x000fc800078e002dULL,
0x00005e0028287625ULL, 0x000fc800078e002dULL, 0x00005e002a2a7625ULL, 0x000fc800078e002dULL,
0x00005e002c2c7625ULL, 0x000fc800078e002dULL, 0x000000102f087825ULL, 0x000fc800078e0008ULL,
0x000000102f0a7825ULL, 0x000fc800078e000aULL, 0x000000102f0e7825ULL, 0x000fc800078e000eULL,
0x000000102f247825ULL, 0x000fc800078e0024ULL, 0x000000102f267825ULL, 0x000fc800078e0026ULL,
0x000000102f287825ULL, 0x000fc800078e0028ULL, 0x000000102f2a7825ULL, 0x000fc800078e002aULL,
0x000000102f2c7825ULL, 0x000fc800078e002cULL, 0x000000102e2f7824ULL, 0x100fe400078e024dULL,
0x0000001030317824ULL, 0x100fe400078e024dULL, 0x0000001032337824ULL, 0x100fe200078e024dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000082f7faeULL, 0x0003e2000b901c46ULL,
0x0000001034357824ULL, 0x100fe400078e024dULL, 0x000000103c397824ULL, 0x100fe200078e024dULL,
0x000000000a317faeULL, 0x0003e2000b901c46ULL, 0x000000104c3d7824ULL, 0x000fc400078e024dULL,
0x000000104e4d7824ULL, 0x000fe200078e024dULL, 0x000000000e337faeULL, 0x0003e8000b901c46ULL,
0x0000000024357faeULL, 0x0003e8000b901c46ULL, 0x0000000026377faeULL, 0x0003e8000b901c46ULL,
0x0000000028397faeULL, 0x0003e8000b901c46ULL, 0x000000002a3d7faeULL, 0x0003e8000b901c46ULL,
0x000000002c4d7faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01460800420e7f8cULL, 0x0022a4000c80043fULL,
0x0000000000087805ULL, 0x000fc40000015200ULL, 0x01460c00420b7984ULL, 0x000ee40000000800ULL,
0x800000000bff7812ULL, 0x00cfc4000780480fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff247224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a08257210ULL, 0x000fc80007f1e1ffULL, 0x0000000b090b7210ULL, 0x000fe400007fe5ffULL,
0x003d09002500780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402500780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0a7819ULL, 0x000fc8000001140bULL, 0x000000250a0a7211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060bULL, 0x000000020a0a7819ULL, 0x000fc8000000120bULL,
0x0000000a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000124247810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01460c00420b7984ULL, 0x000ea40000000800ULL, 0x800000000bff7812ULL, 0x004fe4000780480fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000100c3d7824ULL, 0x000fe200078e00ffULL,
0x00000001ff087819ULL, 0x000fe2000001160cULL, 0xffffffffff3c7424ULL, 0x000fc600078e00ffULL,
0x000000703d3d7812ULL, 0x000fe400078ec0ffULL, 0x0000000c08087812ULL, 0x000fca00078ec0ffULL,
0x000000013d3d7824ULL, 0x000fca00078e0208ULL, 0x014000003d0b7984ULL, 0x000ea80000000800ULL,
0x014200003d0a7984ULL, 0x0006620000000800ULL, 0x000000580b00720bULL, 0x004fe20003f1d000ULL,
0x000143f27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000087806ULL, 0x008fc800000e0100ULL,
0x0000ffff080f7812ULL, 0x000fe2000784c0ffULL, 0x0000045000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe20003f0e170ULL, 0x000000ffff707224ULL, 0x000fd400078e0058ULL,
0x000004100000a947ULL, 0x000fea0003800000ULL, 0x000000ff0000720cULL, 0x000fe40003f45270ULL,
0x000000580b00720bULL, 0x000fe20003f74000ULL, 0x000143b27f007947ULL, 0x000fd8000b800000ULL,
0x00000000000e7806ULL, 0x000fc400018e0100ULL, 0x0000000b58707209ULL, 0x000fe20007810000ULL,
0x0000035000017945ULL, 0x000fe20003800000ULL, 0x000099100e087816ULL, 0x000fc600000000ffULL,
0x014400703d00a388ULL, 0x0005e20000000800ULL, 0x000000ff0800720cULL, 0x000fda0003f45270ULL,
0x000003000000a947ULL, 0x000fea0003800000ULL, 0x8000007058087221ULL, 0x004fe20000010000ULL,
0x000000ff0eff7812ULL, 0x000fe2000784c0ffULL, 0x0000017000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b08087820ULL, 0x000fc80000410000ULL, 0x0000000800257308ULL, 0x0004ec0000000800ULL,
0x000001300000a947ULL, 0x000fea0003800000ULL, 0x00000002ff087819ULL, 0x004fe2000001160cULL,
0x000143127f007947ULL, 0x000fea000b800000ULL, 0x00001f0825087589ULL, 0x0084e400000e0000ULL,
0x0000000810107220ULL, 0x088fe20000410000ULL, 0x0000000811117220ULL, 0x080fe20000410000ULL,
0x0000000818187220ULL, 0x080fe20000410000ULL, 0x0000000819197220ULL, 0x080fe20000410000ULL,
0x0000000814147220ULL, 0x080fe20000410000ULL, 0x0000000815157220ULL, 0x080fe20000410000ULL,
0x000000081c1c7220ULL, 0x080fe20000410000ULL, 0x000000081d1d7220ULL, 0x080fe20000410000ULL,
0x0000000820207220ULL, 0x080fe20000410000ULL, 0x0000000821217220ULL, 0x080fe20000410000ULL,
0x0000000848487220ULL, 0x080fe20000410000ULL, 0x0000000849497220ULL, 0x080fe20000410000ULL,
0x0000000844447220ULL, 0x080fe20000410000ULL, 0x0000000845457220ULL, 0x080fe20000410000ULL,
0x0000000804047220ULL, 0x080fe20000410000ULL, 0x0000000805057220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff000eff7812ULL, 0x000fe2000784c0ffULL,
0x0000002541417220ULL, 0x008fd80000410000ULL, 0x000001300000a947ULL, 0x000fea0003800000ULL,
0x000000080c087811ULL, 0x004fe200078ff0ffULL, 0x000141f27f007947ULL, 0x000fea000b800000ULL,
0x00001f0825087589ULL, 0x0004e400000e0000ULL, 0x0000000812127220ULL, 0x088fe20000410000ULL,
0x0000000813137220ULL, 0x080fe20000410000ULL, 0x000000081a1a7220ULL, 0x080fe20000410000ULL,
0x000000081b1b7220ULL, 0x080fe20000410000ULL, 0x0000000816167220ULL, 0x080fe20000410000ULL,
0x0000000817177220ULL, 0x080fe20000410000ULL, 0x000000081e1e7220ULL, 0x080fe20000410000ULL,
0x000000081f1f7220ULL, 0x080fe20000410000ULL, 0x0000000822227220ULL, 0x080fe20000410000ULL,
0x0000000823237220ULL, 0x080fe20000410000ULL, 0x000000084a4a7220ULL, 0x080fe20000410000ULL,
0x000000084b4b7220ULL, 0x080fe20000410000ULL, 0x0000000846467220ULL, 0x080fe20000410000ULL,
0x0000000847477220ULL, 0x080fe20000410000ULL, 0x0000000806067220ULL, 0x080fe20000410000ULL,
0x0000000807077220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff0fff7812ULL, 0x000fda000784600eULL, 0x800000700b0b2221ULL, 0x000fe20000010000ULL,
0x000000000000281cULL, 0x000fc60003f0f070ULL, 0x3fb8aa3b0b0b2820ULL, 0x000fc80000410000ULL,
0x0000000b003a2308ULL, 0x000ea40000000800ULL, 0x0000003a0a0a2220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000015000007945ULL, 0x000fe20003800000ULL, 0x000000410a417221ULL, 0x002fe20000010000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x0000003aff08723eULL, 0x000fe400000010ffULL,
0x00000002ff0a7819ULL, 0x000fe4000001160cULL, 0x00005410080b7816ULL, 0x000fe20000000008ULL,
0x000140327f007947ULL, 0x000fea000b800000ULL, 0x00001f0a0b3b7589ULL, 0x0002a400000e0000ULL,
0x000000080a387810ULL, 0x000fe20007ffe0ffULL, 0x000140627f007947ULL, 0x000fea000b800000ULL,
0x00001f380b387589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000100a087810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff597224ULL, 0x000fe200078e000bULL,
0x00002680005a7802ULL, 0x000fc40000000f00ULL, 0x00014d8000007944ULL, 0x00efea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000180a087810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff597224ULL, 0x004fe200078e000bULL, 0x000026d0005a7802ULL, 0x000fc40000000f00ULL,
0x00014d3000007944ULL, 0x00afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000070c397812ULL, 0x040fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000080c277812ULL, 0x000fc400078ec0ffULL, 0x00000008390f7812ULL, 0x000fc800078ef80cULL,
0x0000000f0c267211ULL, 0x000fe400078fe0ffULL, 0x000000030f377819ULL, 0x000fc800000006ffULL,
0xfffffff837377812ULL, 0x000fc800078ee226ULL, 0x0000a00037087811ULL, 0x000fca00078e20ffULL,
0x0000000727277812ULL, 0x000fe200078ef80cULL, 0x000000000808783bULL, 0x00ae620000000200ULL,
0x0000c00000367811ULL, 0x000fe400078e68ffULL, 0x000000270c0e7211ULL, 0x000fe200078fe0ffULL,
0x0000000827357824ULL, 0x040fe200078e00ffULL, 0x0000000226317810ULL, 0x000fe20007ffe0ffULL,
0x0000000827257824ULL, 0x040fe200078e00ffULL, 0x000000020e247810ULL, 0x040fe20007ffe0ffULL,
0x0000000827337824ULL, 0x000fe200078e00ffULL, 0xfffffff835357812ULL, 0x000fe200078ee20eULL,
0x0000000827297824ULL, 0x000fe200078e00ffULL, 0x000000040e287810ULL, 0x000fc40007ffe0ffULL,
0x000000060e0e7810ULL, 0x000fe20007ffe0ffULL, 0x0000001035357824ULL, 0x000fe200078e0236ULL,
0xfffffff825257812ULL, 0x000fe400078ee224ULL, 0xfffffff833337812ULL, 0x000fe400078ee228ULL,
0xfffffff829297812ULL, 0x000fe200078ee20eULL, 0x0000001025347824ULL, 0x100fe200078e0236ULL,
0x000000030f0e7819ULL, 0x000fe200000006ffULL, 0x0000001033337824ULL, 0x100fe200078e0236ULL,
0x000000003564783bULL, 0x000ee20000004200ULL, 0x0000001029327824ULL, 0x000fe200078e0236ULL,
0x00000010270f7812ULL, 0x000fc400078efcffULL, 0x000000003428783bULL, 0x000f220000004200ULL,
0xfffffff80e317812ULL, 0x000fe400078ee231ULL, 0x000000080f257824ULL, 0x040fe200078e00ffULL,
0x000000003358783bULL, 0x004fe20000004200ULL, 0x0000000f0c0e7211ULL, 0x000fe200078fe0ffULL,
0x000000080f2c7824ULL, 0x040fe200078e00ffULL, 0x000000030f2d7819ULL, 0x040fe200000006ffULL,
0x00000000324c783bULL, 0x000fe20000004200ULL, 0x000000080f2f7824ULL, 0x000fe200078e00ffULL,
0x000000020e247810ULL, 0x000fc40007ffe0ffULL, 0x000000040e0f7810ULL, 0x040fe20007ffe0ffULL,
0x0000003b08080231ULL, 0x082fe200003400ffULL, 0xfffffff825257812ULL, 0x000fe200078ee20eULL,
0x0000003b0a0a0231ULL, 0x000fe200003400ffULL, 0x0000a00031507811ULL, 0x000fe200078e20ffULL,
0x0000003809090231ULL, 0x080fe200003400ffULL, 0x000000060e0e7810ULL, 0x000fe20007ffe0ffULL,
0x0000001025307824ULL, 0x000fe200078e0236ULL, 0xfffffff82c0f7812ULL, 0x000fe200078ee20fULL,
0x000000380b0b0231ULL, 0x000fe200003400ffULL, 0xfffffff82f0e7812ULL, 0x000fe200078ee20eULL,
0x000000005050783bULL, 0x000e620000000200ULL, 0xfffffff82d247812ULL, 0x000fe200078ee224ULL,
0x000000100f2e7824ULL, 0x000fc400078e0236ULL, 0x000000100e2d7824ULL, 0x000fe200078e0236ULL,
0x00000036242f7211ULL, 0x000fe200078e20ffULL, 0x000000003068783bULL, 0x000ea80000004200ULL,
0x000000002f60783bULL, 0x000ea20000004200ULL, 0x000000640810723cULL, 0x048fe60000041810ULL,
0x000000002e5c783bULL, 0x000ee80000004200ULL, 0x000000002d54783bULL, 0x000ea20000004200ULL,
0x000000660818723cULL, 0x040f700000041818ULL, 0x000000280864723cULL, 0x050f700000041814ULL,
0x0000002a081c723cULL, 0x000f62000004181cULL, 0x0000003b50500231ULL, 0x002fc400003400ffULL,
0x0000003b52520231ULL, 0x000fe400003400ffULL, 0x0000003851510231ULL, 0x000fc600003400ffULL,
0x000000580820723cULL, 0x000f620000041820ULL, 0x0000003853530231ULL, 0x000fce00003400ffULL,
0x0000005a0848723cULL, 0x040f700000041848ULL, 0x0000004c0828723cULL, 0x040f700000041844ULL,
0x0000004e0804723cULL, 0x000f700000041804ULL, 0x0000006a5014723cULL, 0x064f700000041818ULL,
0x000000685010723cULL, 0x040f700000041810ULL, 0x000000605018723cULL, 0x040f700000041864ULL,
0x00000062501c723cULL, 0x040f70000004181cULL, 0x0000005c5020723cULL, 0x048f700000041820ULL,
0x0000005e5044723cULL, 0x040f700000041848ULL, 0x00000054504c723cULL, 0x040f700000041828ULL,
0x000000565050723cULL, 0x000b6e0000041804ULL, 0x000000203e047810ULL, 0x020fca0007ffe0ffULL,
0x00006200430b7a24ULL, 0x000fe200078e0204ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000059000009947ULL, 0x000fea0003800000ULL, 0x00000003ff297819ULL, 0x000fe2000001160cULL,
0x00000200ff497424ULL, 0x000fe200078e00ffULL, 0x0000000403057217ULL, 0x000fe20007800000ULL,
0x00000001422b7824ULL, 0x000fe200078e0239ULL, 0x00000008294b7810ULL, 0x040fe40007ffe0ffULL,
0x0000000c29597810ULL, 0x000fe20007ffe0ffULL, 0x0000000105057824ULL, 0x000fe200078e0a04ULL,
0x0000000429097810ULL, 0x000fe20007ffe0ffULL, 0x000000014b067824ULL, 0x100fe200078e020cULL,
0x00000010295d7810ULL, 0x000fe20007ffe0ffULL, 0x000000084b577824ULL, 0x000fe200078e00ffULL,
0x0000000309557819ULL, 0x000fe200000006ffULL, 0x0000000159077824ULL, 0x000fe200078e020cULL,
0x0000000c5d087210ULL, 0x000fe20007ffe0ffULL, 0x00000008590a7824ULL, 0x000fe200078e00ffULL,
0xfffffff857577812ULL, 0x000fe200078ee206ULL, 0x0000000109047824ULL, 0x100fe200078e020cULL,
0x0000001429617810ULL, 0x040fe20007ffe0ffULL, 0x0000000129067824ULL, 0x000fe200078e020cULL,
0xfffffff80a5b7812ULL, 0x000fe200078ee207ULL, 0x000000085d5f7824ULL, 0x000fe200078e00ffULL,
0xfffffff855557812ULL, 0x000fe200078ee204ULL, 0x0000000161287824ULL, 0x000fe200078e020cULL,
0x00000020050a7817ULL, 0x000fe20003800000ULL, 0x0000000861637824ULL, 0x000fe200078e00ffULL,
0x0000000b29047210ULL, 0x000fe20007ffe0ffULL, 0x0000001055557824ULL, 0x000fe200078e0236ULL,
0x0000000706077812ULL, 0x000fe200078ec0ffULL, 0x0000000109067824ULL, 0x100fe200078e020bULL,
0xfffffff85f5f7812ULL, 0x000fe200078ee208ULL, 0x000000014b087824ULL, 0x000fe200078e020bULL,
0x0000000a2900720cULL, 0x080fe20003f46070ULL, 0x00005e0004047625ULL, 0x000fe200078e0049ULL,
0x0000000a0900720cULL, 0x000fc40003f66070ULL, 0x0000000a4b00720cULL, 0x000fe20003f86070ULL,
0x00005e0008087625ULL, 0x080fe200078e0049ULL, 0x0ffffff8074b7812ULL, 0x000fe400078ef80cULL,
0x0000001829657810ULL, 0x000fe20007ffe0ffULL, 0x00005e0006067625ULL, 0x000fe200078e0049ULL,
0x000000364b4b7211ULL, 0x000fe400078e20ffULL, 0xfffffff863637812ULL, 0x000fe200078ee228ULL,
0x000000102b047825ULL, 0x000fe200078e0004ULL, 0x0000001c29297810ULL, 0x000fc40007ffe0ffULL,
0x0000000a6500720cULL, 0x080fe20003fa6070ULL, 0x000000102b067825ULL, 0x000fe200078e0006ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000044b7faeULL, 0x0003e2000d101c46ULL,
0x0000000a5900720cULL, 0x080fe40003f46070ULL, 0x0000001057577824ULL, 0x000fe200078e0236ULL,
0x0000000006557faeULL, 0x0005e2000d901c46ULL, 0x000000102b087825ULL, 0x000fe200078e0008ULL,
0x0000000a5d00720cULL, 0x080fe40003f66070ULL, 0x0000000a2900720cULL, 0x080fe20003fc6070ULL,
0x0000000165287824ULL, 0x040fe200078e020cULL, 0x0000000008577faeULL, 0x0007e2000e101c46ULL,
0x0000000865677824ULL, 0x000fe200078e00ffULL, 0x0000000b59047210ULL, 0x002fe20007ffe0ffULL,
0x000000105b5b7824ULL, 0x000fe200078e0236ULL, 0x0000000a6100720cULL, 0x000fe20003f86070ULL,
0x00000001650a7824ULL, 0x100fe200078e020bULL, 0xfffffff8674b7812ULL, 0x000fe200078ee228ULL,
0x000000015d067824ULL, 0x104fe200078e020bULL, 0x0000000c292a7210ULL, 0x040fe20007ffe0ffULL,
0x0000000129287824ULL, 0x000fe200078e020bULL, 0x000000364b4b7211ULL, 0x000fe200078e20ffULL,
0x0000000829557824ULL, 0x000fc400078e00ffULL, 0x0000000161087824ULL, 0x008fe400078e020bULL,
0x00005e0004047625ULL, 0x000fc800078e0049ULL, 0x00005e0006067625ULL, 0x000fc800078e0049ULL,
0x00005e0008087625ULL, 0x000fc800078e0049ULL, 0x00005e000a0a7625ULL, 0x000fc800078e0049ULL,
0x00005e0028287625ULL, 0x000fe200078e0049ULL, 0xfffffff855497812ULL, 0x000fc600078ee22aULL,
0x000000102b047825ULL, 0x000fc800078e0004ULL, 0x000000102b067825ULL, 0x000fe200078e0006ULL,
0x00000000045b7faeULL, 0x0003e6000d101c46ULL, 0x000000105f5f7824ULL, 0x000fe400078e0236ULL,
0x000000102b087825ULL, 0x000fc600078e0008ULL, 0x00000000065f7faeULL, 0x0003e2000d901c46ULL,
0x0000001063637824ULL, 0x000fe400078e0236ULL, 0x000000102b0a7825ULL, 0x000fc600078e000aULL,
0x0000000008637faeULL, 0x0003e2000e101c46ULL, 0x000000102b287825ULL, 0x000fc600078e0028ULL,
0x000000000a4b7faeULL, 0x0003e2000e901c46ULL, 0x0000001049497824ULL, 0x000fca00078e0236ULL,
0x0000000028497faeULL, 0x0003e2000f101c46ULL, 0x000004c000007947ULL, 0x000fea0003800000ULL,
0x000000080c087811ULL, 0x040fe200078fe8ffULL, 0x00000200ff4b7424ULL, 0x000fe200078e00ffULL,
0x0000000c0c0a7811ULL, 0x040fe400078fe8ffULL, 0x000000040c067811ULL, 0x000fe200078fe8ffULL,
0x0000000108057824ULL, 0x100fe200078e020cULL, 0x000000100c287811ULL, 0x000fe200078fe8ffULL,
0x000000010a077824ULL, 0x100fe200078e020cULL, 0x00000003082a7819ULL, 0x000fe200000006ffULL,
0x000000080a2c7824ULL, 0x000fe200078e00ffULL, 0x000000180c297811ULL, 0x000fe200078fe8ffULL,
0x0000000106047824ULL, 0x100fe200078e020cULL, 0xfffffff82a5b7812ULL, 0x000fe200078ee205ULL,
0x0000000806597824ULL, 0x000fe200078e00ffULL, 0xfffffff82c5d7812ULL, 0x000fe200078ee207ULL,
0x0000000128097824ULL, 0x000fe200078e020cULL, 0x000000140c057811ULL, 0x000fe200078fe8ffULL,
0x0000000828487824ULL, 0x000fe200078e00ffULL, 0x0000001c0c2c7811ULL, 0x000fe200078fe8ffULL,
0x0000000106067824ULL, 0x100fe200078e020bULL, 0x0000000c0c077211ULL, 0x080fe200078fe8ffULL,
0x0000000108087824ULL, 0x100fe200078e020bULL, 0xfffffff859597812ULL, 0x000fe200078ee204ULL,
0x000000010a0a7824ULL, 0x000fe200078e020bULL, 0xfffffff8485f7812ULL, 0x000fe200078ee209ULL,
0x00000001052a7824ULL, 0x100fe200078e020bULL, 0x0000000b0c047211ULL, 0x080fe200078fe8ffULL,
0x0000000129487824ULL, 0x100fe200078e020bULL, 0x0000000b28287210ULL, 0x000fe20007ffe0ffULL,
0x000000012c4a7824ULL, 0x040fe200078e020bULL, 0x0000000707077812ULL, 0x000fe200078ec0ffULL,
0x0000000105097824ULL, 0x100fe200078e020cULL, 0x0000000c292b7210ULL, 0x000fe20007ffe0ffULL,
0x0000000805547824ULL, 0x000fe200078e00ffULL, 0x0ffffff807577812ULL, 0x100fe200078ef80cULL,
0x000000012c0b7824ULL, 0x000fe200078e020cULL, 0x0000003942557210ULL, 0x000fe20007ffe0ffULL,
0x000000082c2c7824ULL, 0x000fe200078e00ffULL, 0xfffffff854617812ULL, 0x000fe200078ee209ULL,
0x0000000829567824ULL, 0x000fe200078e00ffULL, 0x0000003657577211ULL, 0x000fe200078e20ffULL,
0x00005e0004047625ULL, 0x000fe200078e004bULL, 0xfffffff82c657812ULL, 0x000fc400078ee20bULL,
0xfffffff856637812ULL, 0x000fe200078ee22bULL, 0x00005e0006067625ULL, 0x000fe200078e004bULL,
0x0000003661617211ULL, 0x000fc600078e20ffULL, 0x00005e0008087625ULL, 0x000fc800078e004bULL,
0x00005e000a0a7625ULL, 0x000fc800078e004bULL, 0x00005e0028287625ULL, 0x000fc800078e004bULL,
0x00005e002a2a7625ULL, 0x000fc800078e004bULL, 0x0000001055047825ULL, 0x000fc800078e0004ULL,
0x00005e0048487625ULL, 0x080fe200078e004bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004577faeULL, 0x0003e6000b901c46ULL, 0x00005e004a4a7625ULL, 0x000fc800078e004bULL,
0x0000001059597824ULL, 0x000fe400078e0236ULL, 0x0000001055067825ULL, 0x000fc800078e0006ULL,
0x000000105b5b7824ULL, 0x000fe200078e0236ULL, 0x0000000006597faeULL, 0x0003e2000b901c46ULL,
0x0000001055087825ULL, 0x000fc800078e0008ULL, 0x00000010550a7825ULL, 0x000fe200078e000aULL,
0x00000000085b7faeULL, 0x0003e6000b901c46ULL, 0x000000105d5d7824ULL, 0x000fe400078e0236ULL,
0x0000001055287825ULL, 0x000fc600078e0028ULL, 0x000000000a5d7faeULL, 0x0003e2000b901c46ULL,
0x000000105f5f7824ULL, 0x000fe400078e0236ULL, 0x00000010552a7825ULL, 0x000fc600078e002aULL,
0x00000000285f7faeULL, 0x0003e2000b901c46ULL, 0x0000001055487825ULL, 0x000fc600078e0048ULL,
0x000000002a617faeULL, 0x0003e2000b901c46ULL, 0x0000001063637824ULL, 0x000fe400078e0236ULL,
0x00000010554a7825ULL, 0x000fc600078e004aULL, 0x0000000048637faeULL, 0x0003e2000b901c46ULL,
0x0000001065657824ULL, 0x000fca00078e0236ULL, 0x000000004a657faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000015000007945ULL, 0x000fe20003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x0000003aff04723eULL, 0x002fe400000010ffULL, 0x00000002ff057819ULL, 0x000fe4000001160cULL,
0x0000541004047816ULL, 0x000fe20000000004ULL, 0x00012fe27f007947ULL, 0x000fea000b800000ULL,
0x00001f05043b7589ULL, 0x0002a400000e0000ULL, 0x0000000805087810ULL, 0x000fe20007ffe0ffULL,
0x000130127f007947ULL, 0x000fea000b800000ULL, 0x00001f0804387589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001005087810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff597224ULL, 0x000fe200078e0004ULL, 0x00003790005a7802ULL, 0x000fc40000000f00ULL,
0x00013c7000007944ULL, 0x006fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001805087810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff597224ULL, 0x004fe200078e0004ULL,
0x000037e0005a7802ULL, 0x000fc40000000f00ULL, 0x00013c2000007944ULL, 0x002fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000839047812ULL, 0x00afe200078ef80cULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000004262c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000304057819ULL, 0x000fc800000006ffULL, 0xfffffff8052c7812ULL, 0x000fe400078ee22cULL,
0x000000080c057812ULL, 0x000fe400078ec0ffULL, 0x0000a0002c547811ULL, 0x000fc400078e20ffULL,
0x0000000705067812ULL, 0x000fe200078ef80cULL, 0x0000000827287824ULL, 0x040fe200078e00ffULL,
0x000000270c057211ULL, 0x000fe200078fe0ffULL, 0x0000000827097824ULL, 0x000fe200078e00ffULL,
0x00001000362b7810ULL, 0x000fe20007ffe0ffULL, 0x00000008062a7824ULL, 0x000fe200078e00ffULL,
0x0000000605067810ULL, 0x000fe20007ffe0ffULL, 0x0000000827087824ULL, 0x000fe200078e00ffULL,
0x0000000205077810ULL, 0x000fe20007ffe0ffULL, 0x000000005454783bULL, 0x000e620000000200ULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee205ULL, 0x000000100f0f7824ULL, 0x100fe200078e022bULL,
0x0000000405057810ULL, 0x000fe20007ffe0ffULL, 0x0000001024247824ULL, 0x100fe200078e022bULL,
0xfffffff809067812ULL, 0x000fe200078ee206ULL, 0x000000100e0e7824ULL, 0x000fe200078e022bULL,
0xfffffff828287812ULL, 0x000fe200078ee205ULL, 0x0000000804057824ULL, 0x000fe200078e00ffULL,
0xfffffff808087812ULL, 0x000fe200078ee207ULL, 0x0000001006277824ULL, 0x100fe200078e022bULL,
0x0000002b2a2a7211ULL, 0x080fe200078e20ffULL, 0x0000001028287824ULL, 0x100fe200078e022bULL,
0x0000000626267810ULL, 0x000fe20007ffe0ffULL, 0x0000001008297824ULL, 0x000fe200078e022bULL,
0x00000000275c783bULL, 0x000ee20000004200ULL, 0x0000002b25257211ULL, 0x000fc400078e20ffULL,
0xfffffff805267812ULL, 0x000fe200078ee226ULL, 0x000000002a58783bULL, 0x004ea60000004200ULL,
0x0000a00026047811ULL, 0x000fe200078e20ffULL, 0x000000002860783bULL, 0x000f280000004200ULL,
0x000000002964783bULL, 0x000fe80000004200ULL, 0x000000000404783bULL, 0x000f280000000200ULL,
0x000000000f48783bULL, 0x000f280000004200ULL, 0x00000000256c783bULL, 0x000f220000004200ULL,
0x0000003b54540231ULL, 0x002fc400003400ffULL, 0x0000003b56560231ULL, 0x080fe200003400ffULL,
0x000000002468783bULL, 0x000e620000004200ULL, 0x0000003855550231ULL, 0x080fe400003400ffULL,
0x0000003857570231ULL, 0x000fe200003400ffULL, 0x000000000e08783bULL, 0x000e6c0000004200ULL,
0x0000005c544c723cULL, 0x048ff0000004184cULL, 0x000000585410723cULL, 0x044ff00000041810ULL,
0x000000605420723cULL, 0x010f620000041820ULL, 0x0000003b04040231ULL, 0x000fc400003400ffULL,
0x0000003b06060231ULL, 0x000fe400003400ffULL, 0x0000003805050231ULL, 0x080fe400003400ffULL,
0x0000003807070231ULL, 0x000fe200003400ffULL, 0x0000005a5458723cULL, 0x040ff00000041814ULL,
0x000000625444723cULL, 0x040f700000041844ULL, 0x000000645414723cULL, 0x040f700000041818ULL,
0x00000066541c723cULL, 0x040f70000004181cULL, 0x0000005e5450723cULL, 0x000f700000041850ULL,
0x000000480420723cULL, 0x060b700000041820ULL, 0x0000004a0448723cULL, 0x040b700000041844ULL,
0x0000006c0410723cULL, 0x040b700000041810ULL, 0x0000006e0418723cULL, 0x040b700000041858ULL,
0x000000680414723cULL, 0x042b700000041814ULL, 0x0000006a041c723cULL, 0x040b70000004181cULL,
0x000000080444723cULL, 0x040b70000004184cULL, 0x0000000a0404723cULL, 0x000b620000041850ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x000000203e087810ULL, 0x020fe20007ffe0ffULL,
0x01468800ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff587224ULL, 0x000fc400078e0070ULL,
0x000000030800720cULL, 0x000fda0003f06070ULL, 0x00006dd000000947ULL, 0x000fea0003800000ULL,
0x000000403e0a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000620043517a24ULL, 0x000fe200078e020aULL, 0x0000059000009947ULL, 0x000fea0003800000ULL,
0x00000003ff537819ULL, 0x000fe2000001160cULL, 0x00000200ff557424ULL, 0x000fe200078e00ffULL,
0x0000000a03087217ULL, 0x000fe20007800000ULL, 0x0000000142577824ULL, 0x000fe200078e0239ULL,
0x00000004534d7810ULL, 0x040fe40007ffe0ffULL, 0x0000000853597810ULL, 0x000fe20007ffe0ffULL,
0x0000000108087824ULL, 0x000fe200078e0a0aULL, 0x0000000c4d097210ULL, 0x0c0fe20007ffe0ffULL,
0x000000084d507824ULL, 0x000fe200078e00ffULL, 0x0000000c530a7210ULL, 0x000fe20007ffe0ffULL,
0x0000000159527824ULL, 0x040fe200078e020cULL, 0x00000020084c7817ULL, 0x000fe20003800000ULL,
0x00000008595d7824ULL, 0x000fe200078e00ffULL, 0xfffffff850507812ULL, 0x000fe200078ee209ULL,
0x0000000153097824ULL, 0x040fe200078e0251ULL, 0x0000000c535b7810ULL, 0x000fc40007ffe0ffULL,
0x000000070a0b7812ULL, 0x000fe200078ec0ffULL, 0x000000014d0a7824ULL, 0x000fe200078e0251ULL,
0x0000004c5300720cULL, 0x080fe20003f06070ULL, 0x00005e0009087625ULL, 0x080fe200078e0055ULL,
0x0000004c4d00720cULL, 0x000fe40003f46070ULL, 0x0ffffff80b4e7812ULL, 0x000fe200078ef80cULL,
0x00005e000a0a7625ULL, 0x000fe200078e0055ULL, 0x0000000c5b567210ULL, 0x000fe40007ffe0ffULL,
0xfffffff85d547812ULL, 0x000fe200078ee252ULL, 0x000000085b5f7824ULL, 0x000fe200078e00ffULL,
0x00000010535d7810ULL, 0x000fe20007ffe0ffULL, 0x0000001057087825ULL, 0x000fe200078e0008ULL,
0x0000001853617810ULL, 0x000fc40007ffe0ffULL, 0xfffffff85f567812ULL, 0x000fe200078ee256ULL,
0x000000104e4d7824ULL, 0x100fe200078e022bULL, 0x00000014535f7810ULL, 0x040fe20007ffe0ffULL,
0x00000010504f7824ULL, 0x000fe200078e022bULL, 0x0000001c53537810ULL, 0x000fe20007ffe0ffULL,
0x00000010570a7825ULL, 0x000fe200078e000aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000084d7faeULL, 0x0003e2000c101c46ULL, 0x0000004c5900720cULL, 0x080fe40003f06070ULL,
0x000000085d587824ULL, 0x000fe200078e00ffULL, 0x000000000a4f7faeULL, 0x0005e2000d101c46ULL,
0x000000085f5a7824ULL, 0x000fe200078e00ffULL, 0x0000004c5b00720cULL, 0x080fe20003f46070ULL,
0x00000008535e7824ULL, 0x000fe200078e00ffULL, 0x0000004c5d00720cULL, 0x080fe20003f66070ULL,
0x000000015f4e7824ULL, 0x140fe200078e0251ULL, 0x0000004c5f00720cULL, 0x080fe20003f86070ULL,
0x0000000161507824ULL, 0x140fe200078e0251ULL, 0x0000004c6100720cULL, 0x080fe20003fa6070ULL,
0x000000015d097824ULL, 0x102fe200078e020cULL, 0x0000004c5300720cULL, 0x000fe20003fc6070ULL,
0x00000001614d7824ULL, 0x100fe200078e020cULL, 0x000000515b0a7210ULL, 0x004fe20007ffe0ffULL,
0x00000001534f7824ULL, 0x000fe200078e020cULL, 0x0000000c5f0b7210ULL, 0x000fe20007ffe0ffULL,
0x0000000159087824ULL, 0x100fe200078e0251ULL, 0x00000003615c7819ULL, 0x000fe200000006ffULL,
0x000000015d4c7824ULL, 0x000fe200078e0251ULL, 0xfffffff858587812ULL, 0x000fe200078ee209ULL,
0x0000000153527824ULL, 0x000fe200078e0251ULL, 0xfffffff85a5a7812ULL, 0x000fe200078ee20bULL,
0x00005e0008087625ULL, 0x000fe200078e0055ULL, 0xfffffff85c5c7812ULL, 0x000fc400078ee24dULL,
0xfffffff85e5e7812ULL, 0x000fe200078ee24fULL, 0x00005e000a0a7625ULL, 0x000fe200078e0055ULL,
0x0000002b58597211ULL, 0x000fc600078e20ffULL, 0x00005e004c4c7625ULL, 0x000fc800078e0055ULL,
0x00005e004e4e7625ULL, 0x000fc800078e0055ULL, 0x00005e0050507625ULL, 0x000fc800078e0055ULL,
0x00005e0052527625ULL, 0x000fc800078e0055ULL, 0x0000001054557824ULL, 0x000fe400078e022bULL,
0x0000001057087825ULL, 0x000fc800078e0008ULL, 0x00000010570a7825ULL, 0x040fe200078e000aULL,
0x0000000008557faeULL, 0x0003e6000c101c46ULL, 0x00000010574c7825ULL, 0x000fc800078e004cULL,
0x00000010574e7825ULL, 0x000fc800078e004eULL, 0x0000001057507825ULL, 0x000fc800078e0050ULL,
0x0000001057527825ULL, 0x000fc800078e0052ULL, 0x0000001056577824ULL, 0x100fe400078e022bULL,
0x000000105a5b7824ULL, 0x100fe400078e022bULL, 0x000000105c5d7824ULL, 0x100fe200078e022bULL,
0x000000000a577faeULL, 0x0003e2000d101c46ULL, 0x000000105e5f7824ULL, 0x000fc600078e022bULL,
0x000000004c597faeULL, 0x0003e8000d901c46ULL, 0x000000004e5b7faeULL, 0x0003e8000e101c46ULL,
0x00000000505d7faeULL, 0x0003e8000e901c46ULL, 0x00000000525f7faeULL, 0x0003e2000f101c46ULL,
0x000004c000007947ULL, 0x000fea0003800000ULL, 0x000000040c0a7811ULL, 0x040fe200078fe8ffULL,
0x00000200ff577424ULL, 0x000fe200078e00ffULL, 0x000000080c4c7811ULL, 0x000fe200078fe8ffULL,
0x00000001425f7824ULL, 0x000fe200078e0239ULL, 0x0000000c0c4e7811ULL, 0x000fe200078fe8ffULL,
0x000000010a087824ULL, 0x100fe200078e020cULL, 0x000000100c507811ULL, 0x000fe200078fe8ffULL,
0x000000014c097824ULL, 0x100fe200078e020cULL, 0x000000030a4f7819ULL, 0x000fe200000006ffULL,
0x000000084c5c7824ULL, 0x000fe200078e00ffULL, 0x0000000c504d7210ULL, 0x080fe20007ffe0ffULL,
0x000000014e0b7824ULL, 0x040fe200078e020cULL, 0xfffffff84f5a7812ULL, 0x000fe200078ee208ULL,
0x000000084e5e7824ULL, 0x000fe200078e00ffULL, 0xfffffff85c5c7812ULL, 0x000fe200078ee209ULL,
0x0000000850607824ULL, 0x000fe200078e00ffULL, 0x000000140c097811ULL, 0x000fe200078fe8ffULL,
0x000000010a0a7824ULL, 0x100fe200078e0251ULL, 0x000000180c4f7811ULL, 0x000fe200078fe8ffULL,
0x000000014e4e7824ULL, 0x100fe200078e0251ULL, 0x0000001c0c557811ULL, 0x000fe200078fe8ffULL,
0x0000000150507824ULL, 0x000fe200078e0251ULL, 0xfffffff85e5e7812ULL, 0x000fe200078ee20bULL,
0x000000014f547824ULL, 0x040fe200078e0251ULL, 0x0000000c0c0b7211ULL, 0x080fe200078fe8ffULL,
0x000000014f537824ULL, 0x100fe200078e020cULL, 0xfffffff860607812ULL, 0x000fe200078ee24dULL,
0x00000001094d7824ULL, 0x000fe200078e020cULL, 0x000000510c087211ULL, 0x080fe200078fe8ffULL,
0x000000084f647824ULL, 0x000fe200078e00ffULL, 0x000000514c4c7210ULL, 0x000fe20007ffe0ffULL,
0x0000000855667824ULL, 0x000fe200078e00ffULL, 0x0000000309627819ULL, 0x040fe200000006ffULL,
0x0000000109527824ULL, 0x100fe200078e0251ULL, 0x0000000c554f7210ULL, 0x040fe20007ffe0ffULL,
0x0000000155567824ULL, 0x000fe200078e0251ULL, 0x000000070b0b7812ULL, 0x000fe200078ec0ffULL,
0x00005e0008087625ULL, 0x000fe200078e0057ULL, 0xfffffff862627812ULL, 0x000fc400078ee24dULL,
0xfffffff864647812ULL, 0x000fe200078ee253ULL, 0x00005e004c4c7625ULL, 0x080fe200078e0057ULL,
0xfffffff866667812ULL, 0x000fe400078ee24fULL, 0x0ffffff80b587812ULL, 0x000fe200078ef80cULL,
0x00005e000a0a7625ULL, 0x000fc800078e0057ULL, 0x00005e004e4e7625ULL, 0x000fc800078e0057ULL,
0x00005e0050507625ULL, 0x000fc800078e0057ULL, 0x00005e0052527625ULL, 0x000fc800078e0057ULL,
0x00005e0054547625ULL, 0x000fc800078e0057ULL, 0x00005e0056567625ULL, 0x000fc800078e0057ULL,
0x000000105f087825ULL, 0x000fc800078e0008ULL, 0x0000001058597824ULL, 0x100fe400078e022bULL,
0x000000105a5b7824ULL, 0x000fe400078e022bULL, 0x000000105f0a7825ULL, 0x040fe200078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008597faeULL, 0x0003e6000b901c46ULL,
0x000000105c5d7824ULL, 0x000fe200078e022bULL, 0x000000000a5b7faeULL, 0x0003e2000b901c46ULL,
0x000000105f4c7825ULL, 0x000fc800078e004cULL, 0x000000105f4e7825ULL, 0x040fe200078e004eULL,
0x000000004c5d7faeULL, 0x0003e6000b901c46ULL, 0x000000105f507825ULL, 0x000fc800078e0050ULL,
0x000000105f527825ULL, 0x000fc800078e0052ULL, 0x000000105f547825ULL, 0x000fc800078e0054ULL,
0x000000105f567825ULL, 0x000fe200078e0056ULL, 0x0000002b5e5f7211ULL, 0x000fc600078e20ffULL,
0x0000001060617824ULL, 0x100fe400078e022bULL, 0x0000001062637824ULL, 0x100fe200078e022bULL,
0x000000004e5f7faeULL, 0x0003e2000b901c46ULL, 0x0000001064657824ULL, 0x100fe400078e022bULL,
0x0000001066677824ULL, 0x000fe200078e022bULL, 0x0000000050617faeULL, 0x0003e8000b901c46ULL,
0x0000000052637faeULL, 0x0003e8000b901c46ULL, 0x0000000054657faeULL, 0x0003e8000b901c46ULL,
0x0000000056677faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01462800424c7f8cULL, 0x0022a4000c80043fULL,
0x0000000000087805ULL, 0x000fc40000015200ULL, 0x01462c00420b7984ULL, 0x000ee40000000800ULL,
0x800000000bff7812ULL, 0x00cfc4000780484dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ff004e7202ULL, 0x000fe20000000f00ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a084f7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e09ULL,
0x003d09004f00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404f00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0a7819ULL, 0x000fc8000001140bULL, 0x0000004f0a0a7211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060bULL, 0x000000020a0a7819ULL, 0x000fc8000000120bULL,
0x0000000a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000014e4e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01462c00420b7984ULL, 0x000ea40000000800ULL, 0x800000000bff7812ULL, 0x004fe4000780484dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x014080003d0b7984ULL, 0x000ea80000000800ULL,
0x014280003d0a7984ULL, 0x0006620000000800ULL, 0x000000700b00720bULL, 0x004fe20003f1d000ULL,
0x00011d627f007947ULL, 0x000fd8000b800000ULL, 0x00000000004c7806ULL, 0x008fc800000e0100ULL,
0x0000ffff4cff7812ULL, 0x000fe2000784c0ffULL, 0x0000046000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe20003f0e170ULL, 0x000000ffff587224ULL, 0x000fd400078e0070ULL,
0x000004200000a947ULL, 0x000fea0003800000ULL, 0x000000010000780cULL, 0x000fe40003f05270ULL,
0x000000700b00720bULL, 0x000fe20003f54000ULL, 0x00011d227f007947ULL, 0x000fd8000b800000ULL,
0x00000000004d7806ULL, 0x000fc400010e0100ULL, 0x000000700b088209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x000099104d097816ULL, 0x000fc600000000ffULL,
0x014480083d008388ULL, 0x0005e20000000800ULL, 0x000000ff0900720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x000000700b097209ULL, 0x004fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff4dff7812ULL, 0x000fc6000780c0ffULL,
0x0000007009087221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b08087820ULL, 0x000fc80000410000ULL,
0x00000008004e7308ULL, 0x000ea40000000800ULL, 0x0000004e41417220ULL, 0x004fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff087819ULL, 0x000fe2000001160cULL,
0x00011c527f007947ULL, 0x000fea000b800000ULL, 0x00001f084e087589ULL, 0x0004e400000e0000ULL,
0x0000000810107220ULL, 0x088fe20000410000ULL, 0x0000000811117220ULL, 0x080fe20000410000ULL,
0x0000000818187220ULL, 0x080fe20000410000ULL, 0x0000000819197220ULL, 0x080fe20000410000ULL,
0x0000000814147220ULL, 0x080fe20000410000ULL, 0x0000000815157220ULL, 0x080fe20000410000ULL,
0x000000081c1c7220ULL, 0x080fe20000410000ULL, 0x000000081d1d7220ULL, 0x080fe20000410000ULL,
0x0000000820207220ULL, 0x080fe20000410000ULL, 0x0000000821217220ULL, 0x080fe20000410000ULL,
0x0000000848487220ULL, 0x080fe20000410000ULL, 0x0000000849497220ULL, 0x080fe20000410000ULL,
0x0000000844447220ULL, 0x080fe20000410000ULL, 0x0000000845457220ULL, 0x080fe20000410000ULL,
0x0000000804047220ULL, 0x080fe20000410000ULL, 0x0000000805057220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff004dff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000080c087811ULL, 0x000fe200078ff0ffULL,
0x00011b427f007947ULL, 0x000fea000b800000ULL, 0x00001f084e087589ULL, 0x0006a400000e0000ULL,
0x0000000812127220ULL, 0x084fe20000410000ULL, 0x0000000813137220ULL, 0x080fe20000410000ULL,
0x000000081a1a7220ULL, 0x080fe20000410000ULL, 0x000000081b1b7220ULL, 0x080fe20000410000ULL,
0x0000000816167220ULL, 0x080fe20000410000ULL, 0x0000000817177220ULL, 0x080fe20000410000ULL,
0x000000081e1e7220ULL, 0x080fe20000410000ULL, 0x000000081f1f7220ULL, 0x080fe20000410000ULL,
0x0000000822227220ULL, 0x080fe20000410000ULL, 0x0000000823237220ULL, 0x080fe20000410000ULL,
0x000000084a4a7220ULL, 0x080fe20000410000ULL, 0x000000084b4b7220ULL, 0x080fe20000410000ULL,
0x0000000846467220ULL, 0x080fe20000410000ULL, 0x0000000847477220ULL, 0x080fe20000410000ULL,
0x0000000806067220ULL, 0x080fe20000410000ULL, 0x0000000807077220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff4dff7812ULL, 0x000fe4000780084cULL,
0x000000700b587209ULL, 0x000fd60007810000ULL, 0x800000580b0b0221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b0b0b0820ULL, 0x000fc80000410000ULL, 0x0000000b003a0308ULL, 0x000ea40000000800ULL,
0x0000003a0a0a0220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000015000007945ULL, 0x000fe20003800000ULL,
0x000000410a417221ULL, 0x002fe20000010000ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x0000003aff08723eULL, 0x000fe400000010ffULL, 0x00000002ff0b7819ULL, 0x000fe4000001160cULL,
0x00005410080a7816ULL, 0x000fe20000000008ULL, 0x000119827f007947ULL, 0x000fea000b800000ULL,
0x00001f0b0a3b7589ULL, 0x0002a400000e0000ULL, 0x000000080b087810ULL, 0x000fe20007ffe0ffULL,
0x000119b27f007947ULL, 0x000fea000b800000ULL, 0x00001f080a387589ULL, 0x0002e400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000100b087810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff597224ULL, 0x000fe200078e000aULL, 0x00004fd0005a7802ULL, 0x000fc40000000f00ULL,
0x0001243000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000180b087810ULL, 0x002fe40007ffe0ffULL, 0x0000000a00597202ULL, 0x004fc40000000f00ULL,
0x00005020005a7802ULL, 0x000fc40000000f00ULL, 0x000123e000007944ULL, 0x008fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000a80037607811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000000356c783bULL, 0x000fe20000004200ULL,
0x0000a80031087811ULL, 0x002fc600078e20ffULL, 0x000000006060783bULL, 0x000e680000000200ULL,
0x000000003470783bULL, 0x000fe80000004200ULL, 0x000000003364783bULL, 0x000fe80000004200ULL,
0x000000003268783bULL, 0x000fe80000004200ULL, 0x000000000808783bULL, 0x000f280000000200ULL,
0x00000000305c783bULL, 0x000ee80000004200ULL, 0x000000002f54783bULL, 0x000ea80000004200ULL,
0x000000002e50783bULL, 0x000ea80000004200ULL, 0x000000002d4c783bULL, 0x008ee20000004200ULL,
0x0000003b60600231ULL, 0x006fc400003400ffULL, 0x0000003b62620231ULL, 0x000fe400003400ffULL,
0x0000003861610231ULL, 0x080fe400003400ffULL, 0x0000003863630231ULL, 0x000fce00003400ffULL,
0x0000006c6010723cULL, 0x000fe20000041810ULL, 0x0000003b08080231ULL, 0x090fe400003400ffULL,
0x0000003b0a0a0231ULL, 0x000fe400003400ffULL, 0x0000003809090231ULL, 0x000fc600003400ffULL,
0x0000006e6018723cULL, 0x000f620000041818ULL, 0x000000380b0b0231ULL, 0x000fce00003400ffULL,
0x00000070606c723cULL, 0x040f700000041814ULL, 0x00000072601c723cULL, 0x040f70000004181cULL,
0x000000646020723cULL, 0x040f700000041820ULL, 0x000000686044723cULL, 0x040f700000041844ULL,
0x0000006a6004723cULL, 0x040f700000041804ULL, 0x000000666048723cULL, 0x000f700000041848ULL,
0x0000005e0814723cULL, 0x060f700000041818ULL, 0x000000540818723cULL, 0x040f70000004186cULL,
0x000000560854723cULL, 0x040f70000004181cULL, 0x00000050081c723cULL, 0x040f700000041820ULL,
0x0000004c0820723cULL, 0x048f700000041844ULL, 0x0000004e084c723cULL, 0x040b6e0000041804ULL,
0x000000603e067810ULL, 0x020fe20007ffe0ffULL, 0x0000005c0810723cULL, 0x040f700000041810ULL,
0x000000520850723cULL, 0x000b6e0000041848ULL, 0x00006200430b7a24ULL, 0x020fe200078e0206ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000059000009947ULL, 0x000fea0003800000ULL,
0x00000003ff457819ULL, 0x000fe2000001160cULL, 0x00000200ff497424ULL, 0x000fe200078e00ffULL,
0x0000000603047217ULL, 0x000fe40007800000ULL, 0x0000000445097810ULL, 0x040fe40007ffe0ffULL,
0x0000000c455d7810ULL, 0x040fe20007ffe0ffULL, 0x0000000104047824ULL, 0x000fe200078e0a06ULL,
0x00000008454b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000109057824ULL, 0x100fe200078e020cULL,
0x0000001045617810ULL, 0x000fe20007ffe0ffULL, 0x00000008090a7824ULL, 0x000fe200078e00ffULL,
0x000000034b5b7819ULL, 0x000fe200000006ffULL, 0x000000015d077824ULL, 0x100fe200078e020cULL,
0x0000001445657810ULL, 0x000fe20007ffe0ffULL, 0x000000085d447824ULL, 0x000fe200078e00ffULL,
0xfffffff80a597812ULL, 0x000fe200078ee205ULL, 0x000000014b067824ULL, 0x100fe200078e020cULL,
0x00000020040a7817ULL, 0x000fe20003800000ULL, 0x0000000161087824ULL, 0x040fe200078e020cULL,
0xfffffff8445f7812ULL, 0x000fe200078ee207ULL, 0x0000000861637824ULL, 0x000fe200078e00ffULL,
0xfffffff85b5b7812ULL, 0x000fe200078ee206ULL, 0x0000000145057824ULL, 0x040fe200078e020cULL,
0x0000000a4500720cULL, 0x040fe20003f46070ULL, 0x0000000145047824ULL, 0x100fe200078e020bULL,
0xfffffff863637812ULL, 0x000fe200078ee208ULL, 0x0000000109067824ULL, 0x000fe200078e020bULL,
0x0000000705077812ULL, 0x000fe200078ec0ffULL, 0x00005e0004047625ULL, 0x000fe200078e0049ULL,
0x0000000b4b087210ULL, 0x000fc40007ffe0ffULL, 0x0000000a0900720cULL, 0x080fe20003f66070ULL,
0x0000000165447824ULL, 0x100fe200078e020cULL, 0x0000000a4b00720cULL, 0x000fe20003f86070ULL,
0x00005e0008087625ULL, 0x000fe200078e0049ULL, 0x0ffffff8074b7812ULL, 0x000fe400078ef80cULL,
0x0000003942477210ULL, 0x000fe20007ffe0ffULL, 0x00005e0006067625ULL, 0x000fe200078e0049ULL,
0x0000001845697810ULL, 0x000fe40007ffe0ffULL, 0x000000365b5b7211ULL, 0x000fe200078e20ffULL,
0x0000000865677824ULL, 0x000fe200078e00ffULL, 0x0000001c45457810ULL, 0x000fe20007ffe0ffULL,
0x0000001047047825ULL, 0x000fe200078e0004ULL, 0x0000000a6900720cULL, 0x000fc40003fa6070ULL,
0xfffffff867677812ULL, 0x000fe200078ee244ULL, 0x000000104b4b7824ULL, 0x100fe200078e0236ULL,
0x0000000a4500720cULL, 0x000fe20003fc6070ULL, 0x0000001059597824ULL, 0x000fe200078e0236ULL,
0x000000365f5f7211ULL, 0x000fe200078e20ffULL, 0x0000001047067825ULL, 0x000fe200078e0006ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000044b7faeULL, 0x0003e2000d101c46ULL,
0x0000000a5d00720cULL, 0x080fe40003f46070ULL, 0x0000001047087825ULL, 0x000fe200078e0008ULL,
0x0000000006597faeULL, 0x0005e2000d901c46ULL, 0x0000000a6100720cULL, 0x000fc40003f66070ULL,
0x0000000169447824ULL, 0x040fe200078e020cULL, 0x00000000085b7faeULL, 0x0007e2000e101c46ULL,
0x00000008696b7824ULL, 0x000fe200078e00ffULL, 0x0000000a6500720cULL, 0x000fe20003f86070ULL,
0x00000001690a7824ULL, 0x100fe400078e020bULL, 0x000000015d047824ULL, 0x102fe200078e020bULL,
0xfffffff86b4b7812ULL, 0x000fe200078ee244ULL, 0x0000000145447824ULL, 0x100fe400078e020bULL,
0x0000000161067824ULL, 0x004fc400078e020bULL, 0x0000000145467824ULL, 0x000fe200078e020cULL,
0x0000000b65087210ULL, 0x008fe20007ffe0ffULL, 0x0000000845597824ULL, 0x000fe400078e00ffULL,
0x00005e0004047625ULL, 0x000fc800078e0049ULL, 0x00005e0006067625ULL, 0x000fc800078e0049ULL,
0x00005e0008087625ULL, 0x000fc800078e0049ULL, 0x00005e000a0a7625ULL, 0x000fc800078e0049ULL,
0x00005e0044447625ULL, 0x000fe200078e0049ULL, 0xfffffff859497812ULL, 0x000fc600078ee246ULL,
0x0000001047047825ULL, 0x000fc800078e0004ULL, 0x0000001047067825ULL, 0x000fe200078e0006ULL,
0x00000000045f7faeULL, 0x0003e6000d101c46ULL, 0x0000001063637824ULL, 0x000fe400078e0236ULL,
0x0000001047087825ULL, 0x000fc600078e0008ULL, 0x0000000006637faeULL, 0x0003e2000d901c46ULL,
0x0000001067677824ULL, 0x000fe400078e0236ULL, 0x00000010470a7825ULL, 0x000fc600078e000aULL,
0x0000000008677faeULL, 0x0003e2000e101c46ULL, 0x000000104b4b7824ULL, 0x000fe400078e0236ULL,
0x0000001047447825ULL, 0x000fc600078e0044ULL, 0x000000000a4b7faeULL, 0x0003e2000e901c46ULL,
0x0000001049497824ULL, 0x000fca00078e0236ULL, 0x0000000044497faeULL, 0x0003e2000f101c46ULL,
0x000004c000007947ULL, 0x000fea0003800000ULL, 0x000000080c087811ULL, 0x040fe200078fe8ffULL,
0x00000200ff4b7424ULL, 0x000fe200078e00ffULL, 0x0000000c0c0a7811ULL, 0x000fe200078fe8ffULL,
0x0000000142597824ULL, 0x000fe200078e0239ULL, 0x000000040c067811ULL, 0x000fe200078fe8ffULL,
0x0000000108057824ULL, 0x100fe200078e020cULL, 0x000000100c447811ULL, 0x000fe200078fe8ffULL,
0x0000000808467824ULL, 0x000fe200078e00ffULL, 0x000000030a487819ULL, 0x040fe200000006ffULL,
0x000000010a077824ULL, 0x100fe200078e020cULL, 0x0000000c06047210ULL, 0x0c0fe20007ffe0ffULL,
0x00000008065d7824ULL, 0x000fe200078e00ffULL, 0xfffffff8465f7812ULL, 0x000fe200078ee205ULL,
0x0000000144097824ULL, 0x000fe200078e020cULL, 0xfffffff848617812ULL, 0x000fe200078ee207ULL,
0x00000008444a7824ULL, 0x000fe200078e00ffULL, 0x000000140c057811ULL, 0x000fe200078fe8ffULL,
0x0000000108087824ULL, 0x100fe200078e020bULL, 0x000000180c457811ULL, 0x000fe200078fe8ffULL,
0x000000010a0a7824ULL, 0x100fe200078e020bULL, 0x0000000c0c077211ULL, 0x080fe200078fe8ffULL,
0x0000000144447824ULL, 0x100fe200078e020bULL, 0x0000001c0c497811ULL, 0x000fe200078fe8ffULL,
0x0000000105467824ULL, 0x000fe200078e020bULL, 0xfffffff85d5d7812ULL, 0x000fe200078ee204ULL,
0x00000008055a7824ULL, 0x000fe200078e00ffULL, 0xfffffff84a637812ULL, 0x000fe200078ee209ULL,
0x0000000145487824ULL, 0x000fe200078e020bULL, 0x0000000b0c047211ULL, 0x080fe200078fe8ffULL,
0x00000008495e7824ULL, 0x000fe200078e00ffULL, 0x0000000b06067210ULL, 0x080fe20007ffe0ffULL,
0x0000000145477824ULL, 0x100fe200078e020cULL, 0x0000000b494a7210ULL, 0x040fe20007ffe0ffULL,
0x00000001490b7824ULL, 0x100fe200078e020cULL, 0x0000000707077812ULL, 0x000fe200078ec0ffULL,
0x00000008455c7824ULL, 0x000fe200078e00ffULL, 0x0000000c05097210ULL, 0x000fe20007ffe0ffULL,
0x00005e0004047625ULL, 0x000fe200078e004bULL, 0x0ffffff8075b7812ULL, 0x000fc400078ef80cULL,
0xfffffff85a657812ULL, 0x000fe200078ee209ULL, 0x00005e0006067625ULL, 0x080fe200078e004bULL,
0xfffffff85e697812ULL, 0x000fe400078ee20bULL, 0xfffffff85c677812ULL, 0x000fe200078ee247ULL,
0x00005e0008087625ULL, 0x080fe200078e004bULL, 0x000000365f5f7211ULL, 0x080fe400078e20ffULL,
0x0000003669697211ULL, 0x000fe200078e20ffULL, 0x00005e000a0a7625ULL, 0x000fc800078e004bULL,
0x00005e0044447625ULL, 0x000fc800078e004bULL, 0x00005e0046467625ULL, 0x000fc800078e004bULL,
0x0000001059047825ULL, 0x000fc800078e0004ULL, 0x00005e0048487625ULL, 0x000fc800078e004bULL,
0x000000105b5b7824ULL, 0x000fe400078e0236ULL, 0x00005e004a4a7625ULL, 0x000fc600078e004bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000045b7faeULL, 0x0003e2000b901c46ULL,
0x000000105d5d7824ULL, 0x000fe400078e0236ULL, 0x0000001059067825ULL, 0x000fc800078e0006ULL,
0x0000001059087825ULL, 0x040fe200078e0008ULL, 0x00000000065d7faeULL, 0x0003e6000b901c46ULL,
0x00000010590a7825ULL, 0x000fe200078e000aULL, 0x00000000085f7faeULL, 0x0003e6000b901c46ULL,
0x0000001061617824ULL, 0x000fe400078e0236ULL, 0x0000001059447825ULL, 0x000fc600078e0044ULL,
0x000000000a617faeULL, 0x0003e2000b901c46ULL, 0x0000001063637824ULL, 0x000fe400078e0236ULL,
0x0000001059467825ULL, 0x000fc600078e0046ULL, 0x0000000044637faeULL, 0x0003e2000b901c46ULL,
0x0000001065657824ULL, 0x000fe400078e0236ULL, 0x0000001059487825ULL, 0x000fc600078e0048ULL,
0x0000000046657faeULL, 0x0003e2000b901c46ULL, 0x0000001067677824ULL, 0x000fe400078e0236ULL,
0x00000010594a7825ULL, 0x000fc600078e004aULL, 0x0000000048677faeULL, 0x0003e8000b901c46ULL,
0x000000004a697faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000015000007945ULL, 0x000fe20003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x0000003aff04723eULL, 0x002fe400000010ffULL,
0x00000002ff057819ULL, 0x000fe4000001160cULL, 0x0000541004047816ULL, 0x000fe20000000004ULL,
0x00010be27f007947ULL, 0x000fea000b800000ULL, 0x00001f05043b7589ULL, 0x0002a400000e0000ULL,
0x0000000805087810ULL, 0x000fe20007ffe0ffULL, 0x00010c127f007947ULL, 0x000fea000b800000ULL,
0x00001f0804387589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001005087810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff597224ULL, 0x000fe200078e0004ULL,
0x00005e20005a7802ULL, 0x000fc40000000f00ULL, 0x000115e000007944ULL, 0x006fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001805087810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff597224ULL, 0x004fe200078e0004ULL, 0x00005e70005a7802ULL, 0x000fc40000000f00ULL,
0x0001159000007944ULL, 0x002fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000a8002c607811ULL, 0x000fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000002a6c783bULL, 0x000fe20000004200ULL, 0x0000a80026047811ULL, 0x00afc600078e20ffULL,
0x000000006060783bULL, 0x000e680000000200ULL, 0x000000002970783bULL, 0x000fe80000004200ULL,
0x000000002864783bULL, 0x000fe80000004200ULL, 0x000000002768783bULL, 0x000fe80000004200ULL,
0x000000000404783bULL, 0x000ee80000000200ULL, 0x000000002444783bULL, 0x000f280000004200ULL,
0x000000000f48783bULL, 0x000ea80000004200ULL, 0x00000000255c783bULL, 0x000ea80000004200ULL,
0x000000000e08783bULL, 0x000ea40000004200ULL, 0x0000003b60600231ULL, 0x006fc400003400ffULL,
0x0000003b62620231ULL, 0x000fe400003400ffULL, 0x0000003861610231ULL, 0x080fe400003400ffULL,
0x0000003863630231ULL, 0x000fce00003400ffULL, 0x0000006c6010723cULL, 0x000fe20000041810ULL,
0x0000003b04040231ULL, 0x088fe400003400ffULL, 0x0000003b06060231ULL, 0x000fe400003400ffULL,
0x0000003805050231ULL, 0x000fc600003400ffULL, 0x0000006e606c723cULL, 0x000fe20000041814ULL,
0x0000003807070231ULL, 0x000fce00003400ffULL, 0x000000706014723cULL, 0x040f700000041818ULL,
0x000000726070723cULL, 0x040f700000041854ULL, 0x000000646054723cULL, 0x040f70000004181cULL,
0x000000666050723cULL, 0x040f700000041850ULL, 0x000000686064723cULL, 0x040f700000041820ULL,
0x0000006a604c723cULL, 0x000f70000004184cULL, 0x000000440414723cULL, 0x070b700000041814ULL,
0x00000046041c723cULL, 0x040b700000041870ULL, 0x000000480420723cULL, 0x040b700000041854ULL,
0x0000005c0410723cULL, 0x040b700000041810ULL, 0x0000005e0418723cULL, 0x040b70000004186cULL,
0x0000004a0448723cULL, 0x040b700000041850ULL, 0x000000080444723cULL, 0x040b700000041864ULL,
0x0000000a0404723cULL, 0x000b62000004184cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x000000603e087810ULL, 0x020fe20007ffe0ffULL, 0x01469000ffff7f8cULL, 0x000fe6000c80043fULL,
0x000000030800720cULL, 0x000fda0003f06070ULL, 0x0000493000000947ULL, 0x000fea0003800000ULL,
0x000000803e0a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00006200434d7a24ULL, 0x000fe200078e020aULL, 0x0000059000009947ULL, 0x000fea0003800000ULL,
0x00000003ff4f7819ULL, 0x100fe2000001160cULL, 0x00000200ff537424ULL, 0x000fe200078e00ffULL,
0x0000000a03087217ULL, 0x000fe20007800000ULL, 0x0000000142557824ULL, 0x000fe200078e0239ULL,
0x000000044f517810ULL, 0x040fe40007ffe0ffULL, 0x000000080a087210ULL, 0x000fe20007ffe1ffULL,
0x000000014f0a7824ULL, 0x140fe200078e020cULL, 0x000000084f597810ULL, 0x000fe20007ffe0ffULL,
0x0000000151097824ULL, 0x140fe200078e020cULL, 0x00000020084c7817ULL, 0x000fe20003800000ULL,
0x0000000851507824ULL, 0x000fe200078e00ffULL, 0x000000070a0b7812ULL, 0x000fe200078ec0ffULL,
0x0000000159527824ULL, 0x000fe200078e020cULL, 0x0000004d510a7210ULL, 0x000fe20007ffe0ffULL,
0x00000008595d7824ULL, 0x000fe200078e00ffULL, 0xfffffff850507812ULL, 0x000fe200078ee209ULL,
0x000000014f097824ULL, 0x040fe200078e024dULL, 0x0000000c4f5b7810ULL, 0x000fc40007ffe0ffULL,
0x0000004c4f00720cULL, 0x080fe20003f06070ULL, 0x00005e0009087625ULL, 0x080fe200078e0053ULL,
0x0000004c5100720cULL, 0x080fe40003f46070ULL, 0x0ffffff80b4e7812ULL, 0x000fe200078ef80cULL,
0x00005e000a0a7625ULL, 0x000fe200078e0053ULL, 0xfffffff85d547812ULL, 0x000fe400078ee252ULL,
0x0000002b4e517211ULL, 0x000fe200078e20ffULL, 0x000000015b567824ULL, 0x000fe200078e020cULL,
0x000000104f5d7810ULL, 0x000fe20007ffe0ffULL, 0x000000085b5f7824ULL, 0x000fe200078e00ffULL,
0x000000184f617810ULL, 0x000fe20007ffe0ffULL, 0x0000001055087825ULL, 0x000fe200078e0008ULL,
0x0000004c5d00720cULL, 0x000fc40003f66070ULL, 0xfffffff85f567812ULL, 0x000fe200078ee256ULL,
0x0000001050577824ULL, 0x000fe200078e022bULL, 0x000000144f5f7810ULL, 0x000fe20007ffe0ffULL,
0x00000010550a7825ULL, 0x000fe200078e000aULL, 0x0000001c4f4f7810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008517faeULL, 0x0003e2000c101c46ULL,
0x0000004c5900720cULL, 0x080fe20003f06070ULL, 0x000000015f4e7824ULL, 0x140fe200078e024dULL,
0x0000004c5f00720cULL, 0x080fe20003f86070ULL, 0x000000000a577faeULL, 0x0005e2000d101c46ULL,
0x0000004c5b00720cULL, 0x080fe20003f46070ULL, 0x000000014f527824ULL, 0x100fe200078e024dULL,
0x0000004c6100720cULL, 0x080fe20003fa6070ULL, 0x000000085d5a7824ULL, 0x000fe200078e00ffULL,
0x0000004c4f00720cULL, 0x000fe20003fc6070ULL, 0x000000015d4c7824ULL, 0x100fe200078e024dULL,
0x0000004d61507210ULL, 0x000fe20007ffe0ffULL, 0x0000000159087824ULL, 0x102fe200078e024dULL,
0x0000000c5d097210ULL, 0x000fe20007ffe0ffULL, 0x000000085f5c7824ULL, 0x000fe200078e00ffULL,
0x000000034f607819ULL, 0x000fe200000006ffULL, 0x000000015b0a7824ULL, 0x004fe200078e024dULL,
0xfffffff85a5a7812ULL, 0x000fe200078ee209ULL, 0x000000015f0b7824ULL, 0x000fc400078e020cULL,
0x00000001614d7824ULL, 0x140fe400078e020cULL, 0x00000008615e7824ULL, 0x000fe200078e00ffULL,
0xfffffff85c5c7812ULL, 0x000fe200078ee20bULL, 0x000000014f517824ULL, 0x000fe400078e020cULL,
0x00005e0008087625ULL, 0x080fe200078e0053ULL, 0xfffffff85e5e7812ULL, 0x000fe400078ee24dULL,
0xfffffff860607812ULL, 0x000fe200078ee251ULL, 0x00005e000a0a7625ULL, 0x000fe200078e0053ULL,
0x0000002b5e5d7211ULL, 0x000fc600078e20ffULL, 0x00005e004c4c7625ULL, 0x000fc800078e0053ULL,
0x00005e004e4e7625ULL, 0x000fc800078e0053ULL, 0x00005e0050507625ULL, 0x000fc800078e0053ULL,
0x00005e0052527625ULL, 0x000fc800078e0053ULL, 0x0000001054577824ULL, 0x000fe400078e022bULL,
0x0000001055087825ULL, 0x000fc800078e0008ULL, 0x00000010550a7825ULL, 0x040fe200078e000aULL,
0x0000000008577faeULL, 0x0003e6000c101c46ULL, 0x00000010554c7825ULL, 0x000fc800078e004cULL,
0x00000010554e7825ULL, 0x000fc800078e004eULL, 0x0000001055507825ULL, 0x000fc800078e0050ULL,
0x0000001055527825ULL, 0x000fc800078e0052ULL, 0x0000001056557824ULL, 0x100fe400078e022bULL,
0x000000105a597824ULL, 0x100fe400078e022bULL, 0x000000105c5b7824ULL, 0x100fe200078e022bULL,
0x000000000a557faeULL, 0x0003e2000d101c46ULL, 0x00000010605f7824ULL, 0x000fc600078e022bULL,
0x000000004c597faeULL, 0x0003e8000d901c46ULL, 0x000000004e5b7faeULL, 0x0003e8000e101c46ULL,
0x00000000505d7faeULL, 0x0003e8000e901c46ULL, 0x00000000525f7faeULL, 0x0003e2000f101c46ULL,
0x000004c000007947ULL, 0x000fea0003800000ULL, 0x000000040c0a7811ULL, 0x040fe200078fe8ffULL,
0x00000200ff577424ULL, 0x000fe200078e00ffULL, 0x000000080c4c7811ULL, 0x000fc400078fe8ffULL,
0x0000000c0c4e7811ULL, 0x000fe200078fe8ffULL, 0x000000010a087824ULL, 0x100fe200078e020cULL,
0x000000100c507811ULL, 0x000fe200078fe8ffULL, 0x000000080a517824ULL, 0x000fe200078e00ffULL,
0x000000034c5e7819ULL, 0x040fe200000006ffULL, 0x000000014c097824ULL, 0x100fe200078e020cULL,
0x0000001c0c557811ULL, 0x000fe200078fe8ffULL, 0x000000014e0b7824ULL, 0x040fe200078e020cULL,
0xfffffff8515c7812ULL, 0x000fe200078ee208ULL, 0x000000084e607824ULL, 0x000fe200078e00ffULL,
0xfffffff85e5e7812ULL, 0x000fe200078ee209ULL, 0x00000001504f7824ULL, 0x100fe200078e020cULL,
0x000000140c097811ULL, 0x000fe200078fe8ffULL, 0x0000000850627824ULL, 0x000fe200078e00ffULL,
0x000000180c517811ULL, 0x000fe200078fe8ffULL, 0x000000010a0a7824ULL, 0x000fe200078e024dULL,
0xfffffff860607812ULL, 0x000fe200078ee20bULL, 0x000000014c4c7824ULL, 0x100fe200078e024dULL,
0x0000000c0c0b7211ULL, 0x080fe200078fe8ffULL, 0x000000014e4e7824ULL, 0x000fe200078e024dULL,
0xfffffff862627812ULL, 0x000fe200078ee24fULL, 0x0000000109527824ULL, 0x100fe200078e024dULL,
0x0000004d0c087211ULL, 0x080fe200078fe8ffULL, 0x0000000151547824ULL, 0x100fe200078e024dULL,
0x0000004d50507210ULL, 0x000fe20007ffe0ffULL, 0x0000000155567824ULL, 0x000fe200078e024dULL,
0x0000000c51537210ULL, 0x000fe20007ffe0ffULL, 0x00000001094f7824ULL, 0x100fe200078e020cULL,
0x000000070b0b7812ULL, 0x000fe200078ec0ffULL, 0x0000000809647824ULL, 0x000fe200078e00ffULL,
0x0000003942597210ULL, 0x000fe20007ffe0ffULL, 0x0000000851667824ULL, 0x000fe200078e00ffULL,
0x0ffffff80b5a7812ULL, 0x100fe200078ef80cULL, 0x00000001554d7824ULL, 0x040fe200078e020cULL,
0xfffffff864647812ULL, 0x000fe200078ee24fULL, 0x0000000855687824ULL, 0x000fe200078e00ffULL,
0xfffffff866667812ULL, 0x000fe200078ee253ULL, 0x00005e0008087625ULL, 0x000fe200078e0057ULL,
0x0000002b5a5b7211ULL, 0x000fc400078e20ffULL, 0xfffffff868687812ULL, 0x000fe200078ee24dULL,
0x00005e000a0a7625ULL, 0x000fe200078e0057ULL, 0x0000002b64637211ULL, 0x000fc600078e20ffULL,
0x00005e004c4c7625ULL, 0x000fc800078e0057ULL, 0x00005e004e4e7625ULL, 0x000fc800078e0057ULL,
0x00005e0050507625ULL, 0x000fc800078e0057ULL, 0x00005e0052527625ULL, 0x000fc800078e0057ULL,
0x00005e0054547625ULL, 0x000fc800078e0057ULL, 0x00005e0056567625ULL, 0x000fc800078e0057ULL,
0x0000001059087825ULL, 0x000fc800078e0008ULL, 0x000000105c5d7824ULL, 0x000fe200078e022bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000085b7faeULL, 0x0003e2000b901c46ULL,
0x00000010590a7825ULL, 0x000fc800078e000aULL, 0x000000105e5f7824ULL, 0x000fe200078e022bULL,
0x000000000a5d7faeULL, 0x0003e2000b901c46ULL, 0x00000010594c7825ULL, 0x000fc800078e004cULL,
0x00000010594e7825ULL, 0x040fe200078e004eULL, 0x000000004c5f7faeULL, 0x0003e6000b901c46ULL,
0x0000001059507825ULL, 0x000fc800078e0050ULL, 0x0000001059527825ULL, 0x000fc800078e0052ULL,
0x0000001059547825ULL, 0x000fc800078e0054ULL, 0x0000001059567825ULL, 0x000fc800078e0056ULL,
0x0000001060597824ULL, 0x100fe400078e022bULL, 0x0000001062617824ULL, 0x100fe400078e022bULL,
0x0000001066657824ULL, 0x100fe200078e022bULL, 0x000000004e597faeULL, 0x0003e2000b901c46ULL,
0x0000001068677824ULL, 0x000fc600078e022bULL, 0x0000000050617faeULL, 0x0003e8000b901c46ULL,
0x0000000052637faeULL, 0x0003e8000b901c46ULL, 0x0000000054657faeULL, 0x0003e8000b901c46ULL,
0x0000000056677faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01464800424c7f8cULL, 0x0022a4000c80043fULL,
0x0000000000087805ULL, 0x000fc40000015200ULL, 0x01464c00420b7984ULL, 0x000ee40000000800ULL,
0x800000000bff7812ULL, 0x00cfc4000780484dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a084f7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e09ULL,
0x003d09004f00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404f00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0a7819ULL, 0x000fc8000001140bULL, 0x0000004f0a0a7211ULL, 0x000fc800078110ffULL,
0x0000000bff0b7210ULL, 0x000fc800007fe4ffULL, 0x000000020a0a7819ULL, 0x000fc8000000120bULL,
0x0000000a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000014e4e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01464c00420b7984ULL, 0x000ea40000000800ULL, 0x800000000bff7812ULL, 0x004fe4000780484dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x014100003d0b7984ULL, 0x000ea80000000800ULL,
0x014300003d0a7984ULL, 0x0006620000000800ULL, 0x000000580b00720bULL, 0x004fe20003f1d000ULL,
0x0000fb527f007947ULL, 0x000fd8000b800000ULL, 0x00000000004c7806ULL, 0x008fc800000e0100ULL,
0x0000ffff4cff7812ULL, 0x000fe2000784c0ffULL, 0x0000045000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fd60003f0e170ULL, 0x000004200000a947ULL, 0x000fea0003800000ULL,
0x000000020000780cULL, 0x000fe40003f05270ULL, 0x000000580b00720bULL, 0x000fe20003f54000ULL,
0x0000fb227f007947ULL, 0x000fd8000b800000ULL, 0x00000000004d7806ULL, 0x000fc400010e0100ULL,
0x0000000b58088209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x000099104d097816ULL, 0x000fc600000000ffULL, 0x014500083d008388ULL, 0x0005e20000000800ULL,
0x000000ff0900720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000000b58097209ULL, 0x004fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff4dff7812ULL, 0x000fc6000780c0ffULL, 0x8000000958087221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b08087820ULL, 0x000fc80000410000ULL, 0x00000008004e7308ULL, 0x000ea40000000800ULL,
0x0000004e41417220ULL, 0x004fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff087819ULL, 0x000fe2000001160cULL, 0x0000fa527f007947ULL, 0x000fea000b800000ULL,
0x00001f084e087589ULL, 0x0004e400000e0000ULL, 0x0000000810107220ULL, 0x088fe20000410000ULL,
0x0000000811117220ULL, 0x080fe20000410000ULL, 0x0000000818187220ULL, 0x080fe20000410000ULL,
0x0000000819197220ULL, 0x080fe20000410000ULL, 0x0000000814147220ULL, 0x080fe20000410000ULL,
0x0000000815157220ULL, 0x080fe20000410000ULL, 0x000000081c1c7220ULL, 0x080fe20000410000ULL,
0x000000081d1d7220ULL, 0x080fe20000410000ULL, 0x0000000820207220ULL, 0x080fe20000410000ULL,
0x0000000821217220ULL, 0x080fe20000410000ULL, 0x0000000848487220ULL, 0x080fe20000410000ULL,
0x0000000849497220ULL, 0x080fe20000410000ULL, 0x0000000844447220ULL, 0x080fe20000410000ULL,
0x0000000845457220ULL, 0x080fe20000410000ULL, 0x0000000804047220ULL, 0x080fe20000410000ULL,
0x0000000805057220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff004dff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000080c087811ULL, 0x000fe200078ff0ffULL, 0x0000f9427f007947ULL, 0x000fea000b800000ULL,
0x00001f084e087589ULL, 0x0006a400000e0000ULL, 0x0000000812127220ULL, 0x084fe20000410000ULL,
0x0000000813137220ULL, 0x080fe20000410000ULL, 0x000000081a1a7220ULL, 0x080fe20000410000ULL,
0x000000081b1b7220ULL, 0x080fe20000410000ULL, 0x0000000816167220ULL, 0x080fe20000410000ULL,
0x0000000817177220ULL, 0x080fe20000410000ULL, 0x000000081e1e7220ULL, 0x080fe20000410000ULL,
0x000000081f1f7220ULL, 0x080fe20000410000ULL, 0x0000000822227220ULL, 0x080fe20000410000ULL,
0x0000000823237220ULL, 0x080fe20000410000ULL, 0x000000084a4a7220ULL, 0x080fe20000410000ULL,
0x000000084b4b7220ULL, 0x080fe20000410000ULL, 0x0000000846467220ULL, 0x080fe20000410000ULL,
0x0000000847477220ULL, 0x080fe20000410000ULL, 0x0000000806067220ULL, 0x080fe20000410000ULL,
0x0000000807077220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff4dff7812ULL, 0x000fe4000780084cULL, 0x0000000b58587209ULL, 0x000fd60007810000ULL,
0x800000580b0b0221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b0b0b0820ULL, 0x000fc80000410000ULL,
0x0000000b003a0308ULL, 0x000ea40000000800ULL, 0x0000003a0a0a0220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000015000007945ULL, 0x000fe20003800000ULL, 0x000000410a417221ULL, 0x002fe20000010000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x0000003aff08723eULL, 0x000fe400000010ffULL,
0x00000002ff0b7819ULL, 0x000fe4000001160cULL, 0x00005410080a7816ULL, 0x000fe20000000008ULL,
0x0000f7827f007947ULL, 0x000fea000b800000ULL, 0x00001f0b0a3b7589ULL, 0x0002a400000e0000ULL,
0x000000080b087810ULL, 0x000fe20007ffe0ffULL, 0x0000f7b27f007947ULL, 0x000fea000b800000ULL,
0x00001f080a387589ULL, 0x0002e400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000100b087810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff597224ULL, 0x000fe200078e000aULL,
0x00007460005a7802ULL, 0x000fc40000000f00ULL, 0x0000ffa000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000180b087810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff597224ULL, 0x004fe200078e000aULL, 0x000074b0005a7802ULL, 0x000fc40000000f00ULL,
0x0000ff5000007944ULL, 0x008fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000b00037607811ULL, 0x000fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000000356c783bULL, 0x000fe20000004200ULL, 0x0000b00031087811ULL, 0x002fc600078e20ffULL,
0x000000006060783bULL, 0x000e680000000200ULL, 0x000000003470783bULL, 0x000fe80000004200ULL,
0x000000003364783bULL, 0x000fe80000004200ULL, 0x000000003268783bULL, 0x000fe80000004200ULL,
0x000000000808783bULL, 0x000f280000000200ULL, 0x00000000305c783bULL, 0x000ee80000004200ULL,
0x000000002f54783bULL, 0x000ea80000004200ULL, 0x000000002e50783bULL, 0x000ea80000004200ULL,
0x000000002d4c783bULL, 0x008ee20000004200ULL, 0x0000003b60600231ULL, 0x006fc400003400ffULL,
0x0000003b62620231ULL, 0x000fe400003400ffULL, 0x0000003861610231ULL, 0x080fe400003400ffULL,
0x0000003863630231ULL, 0x000fce00003400ffULL, 0x0000006c6010723cULL, 0x000fe20000041810ULL,
0x0000003b08080231ULL, 0x090fe400003400ffULL, 0x0000003b0a0a0231ULL, 0x000fe400003400ffULL,
0x0000003809090231ULL, 0x000fc600003400ffULL, 0x0000006e6018723cULL, 0x000f620000041818ULL,
0x000000380b0b0231ULL, 0x000fce00003400ffULL, 0x00000070606c723cULL, 0x040f700000041814ULL,
0x00000072601c723cULL, 0x040f70000004181cULL, 0x000000646020723cULL, 0x040f700000041820ULL,
0x000000686044723cULL, 0x040f700000041844ULL, 0x0000006a6004723cULL, 0x040f700000041804ULL,
0x000000666048723cULL, 0x000f700000041848ULL, 0x0000005e0814723cULL, 0x060f700000041818ULL,
0x000000540818723cULL, 0x040f70000004186cULL, 0x000000560854723cULL, 0x040f70000004181cULL,
0x00000050081c723cULL, 0x040f700000041820ULL, 0x0000004c0820723cULL, 0x048f700000041844ULL,
0x0000004e084c723cULL, 0x040b6e0000041804ULL, 0x000000a03e067810ULL, 0x020fe20007ffe0ffULL,
0x0000005c0810723cULL, 0x040f700000041810ULL, 0x000000520850723cULL, 0x000b6e0000041848ULL,
0x00006200430b7a24ULL, 0x020fe200078e0206ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000059000009947ULL, 0x000fea0003800000ULL, 0x00000003ff457819ULL, 0x000fe2000001160cULL,
0x00000200ff497424ULL, 0x000fe200078e00ffULL, 0x0000000603047217ULL, 0x000fe20007800000ULL,
0x0000000142477824ULL, 0x000fe200078e0239ULL, 0x0000000445097810ULL, 0x040fe40007ffe0ffULL,
0x0000000c455d7810ULL, 0x040fe20007ffe0ffULL, 0x0000000104047824ULL, 0x000fe200078e0a06ULL,
0x00000008454b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000109057824ULL, 0x140fe200078e020cULL,
0x00000003090a7819ULL, 0x000fe200000006ffULL, 0x000000015d077824ULL, 0x100fe200078e020cULL,
0x0000001045617810ULL, 0x000fe20007ffe0ffULL, 0x000000085d447824ULL, 0x000fe200078e00ffULL,
0xfffffff80a597812ULL, 0x000fe200078ee205ULL, 0x000000014b067824ULL, 0x100fe200078e020cULL,
0x0000000c61087210ULL, 0x000fe20007ffe0ffULL, 0x000000084b5b7824ULL, 0x000fe200078e00ffULL,
0x00000020040a7817ULL, 0x000fe20003800000ULL, 0x0000000145057824ULL, 0x040fe200078e020cULL,
0x0000000b45047210ULL, 0x000fe20007ffe0ffULL, 0x0000000861637824ULL, 0x000fe200078e00ffULL,
0xfffffff8445f7812ULL, 0x000fe200078ee207ULL, 0x0000001059597824ULL, 0x000fe200078e0236ULL,
0xfffffff85b5b7812ULL, 0x000fe200078ee206ULL, 0x0000000109067824ULL, 0x000fe200078e020bULL,
0x0000000705077812ULL, 0x000fe200078ec0ffULL, 0x00005e0004047625ULL, 0x000fe200078e0049ULL,
0xfffffff863637812ULL, 0x000fc400078ee208ULL, 0x0000000a4500720cULL, 0x080fe20003f46070ULL,
0x000000014b087824ULL, 0x000fe200078e020bULL, 0x0000001445657810ULL, 0x000fe20007ffe0ffULL,
0x0000001047047825ULL, 0x000fe200078e0004ULL, 0x0000000a0900720cULL, 0x080fe40003f66070ULL,
0x0000000a4b00720cULL, 0x000fe20003f86070ULL, 0x00005e0008087625ULL, 0x080fe200078e0049ULL,
0x0ffffff8074b7812ULL, 0x000fe400078ef80cULL, 0x0000001845697810ULL, 0x000fe20007ffe0ffULL,
0x00005e0006067625ULL, 0x000fe200078e0049ULL, 0x000000364b4b7211ULL, 0x000fc400078e20ffULL,
0x0000001c45457810ULL, 0x000fe20007ffe0ffULL, 0x0000000165447824ULL, 0x000fe200078e020cULL,
0x0000000a6900720cULL, 0x080fe20003fa6070ULL, 0x0000000865677824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000044b7faeULL, 0x0003e2000d101c46ULL,
0x0000001047067825ULL, 0x000fe200078e0006ULL, 0x0000000a5d00720cULL, 0x080fe40003f46070ULL,
0xfffffff867677812ULL, 0x000fe200078ee244ULL, 0x000000105b5b7824ULL, 0x000fe200078e0236ULL,
0x0000000006597faeULL, 0x0005e2000d901c46ULL, 0x0000001047087825ULL, 0x000fe200078e0008ULL,
0x0000000a6100720cULL, 0x000fc40003f66070ULL, 0x0000000a4500720cULL, 0x080fe20003fc6070ULL,
0x0000000169447824ULL, 0x000fe200078e020cULL, 0x0000000b5d047210ULL, 0x002fe20007ffe0ffULL,
0x00000008696b7824ULL, 0x000fe200078e00ffULL, 0x00000000085b7faeULL, 0x0003e2000e101c46ULL,
0x0000000a6500720cULL, 0x000fe20003f86070ULL, 0x00000001690a7824ULL, 0x100fe200078e020bULL,
0x0000000c45467210ULL, 0x000fe20007ffe0ffULL, 0x0000000161067824ULL, 0x104fe200078e020bULL,
0xfffffff86b4b7812ULL, 0x000fe200078ee244ULL, 0x0000000145447824ULL, 0x000fc400078e020bULL,
0x0000000845597824ULL, 0x000fe200078e00ffULL, 0x000000364b4b7211ULL, 0x000fe200078e20ffULL,
0x00005e0004047625ULL, 0x000fc800078e0049ULL, 0x0000000165087824ULL, 0x002fe400078e020bULL,
0x00005e0006067625ULL, 0x000fc800078e0049ULL, 0x00005e0008087625ULL, 0x000fc800078e0049ULL,
0x00005e000a0a7625ULL, 0x000fc800078e0049ULL, 0x00005e0044447625ULL, 0x000fe200078e0049ULL,
0xfffffff859497812ULL, 0x000fc600078ee246ULL, 0x0000001047047825ULL, 0x000fc800078e0004ULL,
0x000000105f5f7824ULL, 0x000fe400078e0236ULL, 0x0000001047067825ULL, 0x000fc600078e0006ULL,
0x00000000045f7faeULL, 0x0003e2000d101c46ULL, 0x0000001063637824ULL, 0x000fe400078e0236ULL,
0x0000001047087825ULL, 0x000fc600078e0008ULL, 0x0000000006637faeULL, 0x0003e2000d901c46ULL,
0x0000001067677824ULL, 0x000fe400078e0236ULL, 0x00000010470a7825ULL, 0x000fc600078e000aULL,
0x0000000008677faeULL, 0x0003e2000e101c46ULL, 0x0000001047447825ULL, 0x000fc600078e0044ULL,
0x000000000a4b7faeULL, 0x0003e2000e901c46ULL, 0x0000001049497824ULL, 0x000fca00078e0236ULL,
0x0000000044497faeULL, 0x0003e2000f101c46ULL, 0x000004c000007947ULL, 0x000fea0003800000ULL,
0x000000080c087811ULL, 0x040fe200078fe8ffULL, 0x00000200ff4b7424ULL, 0x000fe200078e00ffULL,
0x0000000c0c0a7811ULL, 0x040fe400078fe8ffULL, 0x000000040c067811ULL, 0x000fe200078fe8ffULL,
0x0000000108057824ULL, 0x100fe200078e020cULL, 0x000000100c447811ULL, 0x000fe200078fe8ffULL,
0x000000010a077824ULL, 0x100fe200078e020cULL, 0x0000000308467819ULL, 0x000fe200000006ffULL,
0x000000080a487824ULL, 0x000fe200078e00ffULL, 0x000000180c457811ULL, 0x000fe200078fe8ffULL,
0x0000000106047824ULL, 0x100fe200078e020cULL, 0xfffffff8465f7812ULL, 0x000fe200078ee205ULL,
0x00000008065d7824ULL, 0x000fe200078e00ffULL, 0xfffffff848617812ULL, 0x000fe200078ee207ULL,
0x0000000144097824ULL, 0x000fe200078e020cULL, 0x000000140c057811ULL, 0x000fe200078fe8ffULL,
0x00000008444a7824ULL, 0x000fe200078e00ffULL, 0x0000001c0c497811ULL, 0x000fe200078fe8ffULL,
0x0000000106067824ULL, 0x100fe200078e020bULL, 0x0000000c0c077211ULL, 0x080fe200078fe8ffULL,
0x0000000108087824ULL, 0x100fe200078e020bULL, 0xfffffff85d5d7812ULL, 0x000fe200078ee204ULL,
0x000000010a0a7824ULL, 0x000fe200078e020bULL, 0xfffffff84a637812ULL, 0x000fe200078ee209ULL,
0x0000000105467824ULL, 0x140fe200078e020bULL, 0x0000000b0c047211ULL, 0x080fe200078fe8ffULL,
0x0000000105097824ULL, 0x140fe200078e020cULL, 0x0000000b44447210ULL, 0x000fe20007ffe0ffULL,
0x00000008055a7824ULL, 0x000fe200078e00ffULL, 0x0000000707077812ULL, 0x000fe200078ec0ffULL,
0x0000000145487824ULL, 0x140fe200078e020bULL, 0x0000000c45477210ULL, 0x000fe20007ffe0ffULL,
0x00000001494a7824ULL, 0x000fe200078e020bULL, 0x0ffffff8075b7812ULL, 0x100fe200078ef80cULL,
0x00000001490b7824ULL, 0x040fe200078e020cULL, 0x0000003942597210ULL, 0x000fe20007ffe0ffULL,
0x00000008495e7824ULL, 0x000fe200078e00ffULL, 0xfffffff85a657812ULL, 0x000fe200078ee209ULL,
0x00000008455c7824ULL, 0x000fe200078e00ffULL, 0x000000365b5b7211ULL, 0x000fe200078e20ffULL,
0x00005e0004047625ULL, 0x000fe200078e004bULL, 0xfffffff85e697812ULL, 0x000fc400078ee20bULL,
0xfffffff85c677812ULL, 0x000fe200078ee247ULL, 0x00005e0006067625ULL, 0x000fe200078e004bULL,
0x0000003665657211ULL, 0x000fc600078e20ffULL, 0x00005e0008087625ULL, 0x000fc800078e004bULL,
0x00005e000a0a7625ULL, 0x000fc800078e004bULL, 0x00005e0044447625ULL, 0x000fc800078e004bULL,
0x00005e0046467625ULL, 0x000fc800078e004bULL, 0x0000001059047825ULL, 0x000fc800078e0004ULL,
0x00005e0048487625ULL, 0x080fe200078e004bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000045b7faeULL, 0x0003e6000b901c46ULL, 0x00005e004a4a7625ULL, 0x000fc800078e004bULL,
0x000000105d5d7824ULL, 0x000fe400078e0236ULL, 0x0000001059067825ULL, 0x000fc800078e0006ULL,
0x000000105f5f7824ULL, 0x000fe200078e0236ULL, 0x00000000065d7faeULL, 0x0003e2000b901c46ULL,
0x0000001059087825ULL, 0x000fc800078e0008ULL, 0x00000010590a7825ULL, 0x000fe200078e000aULL,
0x00000000085f7faeULL, 0x0003e6000b901c46ULL, 0x0000001061617824ULL, 0x000fe400078e0236ULL,
0x0000001059447825ULL, 0x000fc600078e0044ULL, 0x000000000a617faeULL, 0x0003e2000b901c46ULL,
0x0000001063637824ULL, 0x000fe400078e0236ULL, 0x0000001059467825ULL, 0x000fc600078e0046ULL,
0x0000000044637faeULL, 0x0003e2000b901c46ULL, 0x0000001059487825ULL, 0x000fc600078e0048ULL,
0x0000000046657faeULL, 0x0003e2000b901c46ULL, 0x0000001067677824ULL, 0x000fe400078e0236ULL,
0x00000010594a7825ULL, 0x000fc600078e004aULL, 0x0000000048677faeULL, 0x0003e2000b901c46ULL,
0x0000001069697824ULL, 0x000fca00078e0236ULL, 0x000000004a697faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000015000007945ULL, 0x000fe20003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x0000003aff04723eULL, 0x002fe400000010ffULL, 0x00000002ff057819ULL, 0x000fe4000001160cULL,
0x0000541004047816ULL, 0x000fe20000000004ULL, 0x0000e9e27f007947ULL, 0x000fea000b800000ULL,
0x00001f05043b7589ULL, 0x0002a400000e0000ULL, 0x0000000805087810ULL, 0x000fe20007ffe0ffULL,
0x0000ea127f007947ULL, 0x000fea000b800000ULL, 0x00001f0804387589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001005087810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff597224ULL, 0x000fe200078e0004ULL, 0x000082b0005a7802ULL, 0x000fc40000000f00ULL,
0x0000f15000007944ULL, 0x006fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001805087810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff597224ULL, 0x004fe200078e0004ULL,
0x00008300005a7802ULL, 0x000fc40000000f00ULL, 0x0000f10000007944ULL, 0x002fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000b0002c607811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000002a6c783bULL, 0x000fe20000004200ULL,
0x0000b00026047811ULL, 0x00afc600078e20ffULL, 0x000000006060783bULL, 0x000e680000000200ULL,
0x000000002970783bULL, 0x000fe80000004200ULL, 0x000000002864783bULL, 0x000fe80000004200ULL,
0x000000002768783bULL, 0x000fe80000004200ULL, 0x000000000404783bULL, 0x000ee80000000200ULL,
0x000000002444783bULL, 0x000f280000004200ULL, 0x000000000f48783bULL, 0x000ea80000004200ULL,
0x00000000255c783bULL, 0x000ea80000004200ULL, 0x000000000e08783bULL, 0x000ea40000004200ULL,
0x0000003b60600231ULL, 0x006fc400003400ffULL, 0x0000003b62620231ULL, 0x000fe400003400ffULL,
0x0000003861610231ULL, 0x080fe400003400ffULL, 0x0000003863630231ULL, 0x000fce00003400ffULL,
0x0000006c6010723cULL, 0x000fe20000041810ULL, 0x0000003b04040231ULL, 0x088fe400003400ffULL,
0x0000003b06060231ULL, 0x000fe400003400ffULL, 0x0000003805050231ULL, 0x000fc600003400ffULL,
0x0000006e606c723cULL, 0x000fe20000041814ULL, 0x0000003807070231ULL, 0x000fce00003400ffULL,
0x000000706014723cULL, 0x040f700000041818ULL, 0x000000726070723cULL, 0x040f700000041854ULL,
0x000000646054723cULL, 0x040f70000004181cULL, 0x000000666050723cULL, 0x040f700000041850ULL,
0x000000686064723cULL, 0x040f700000041820ULL, 0x0000006a604c723cULL, 0x000f70000004184cULL,
0x000000440414723cULL, 0x070b700000041814ULL, 0x00000046041c723cULL, 0x040b700000041870ULL,
0x000000480420723cULL, 0x040b700000041854ULL, 0x0000005c0410723cULL, 0x040b700000041810ULL,
0x0000005e0418723cULL, 0x040b70000004186cULL, 0x0000004a0448723cULL, 0x040b700000041850ULL,
0x000000080444723cULL, 0x040b700000041864ULL, 0x0000000a0404723cULL, 0x000b62000004184cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x000000a03e087810ULL, 0x020fe20007ffe0ffULL,
0x01469800ffff7f8cULL, 0x000fe6000c80043fULL, 0x000000030800720cULL, 0x000fda0003f06070ULL,
0x000024a000000947ULL, 0x000fea0003800000ULL, 0x000000c03e3e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00006200430b7a24ULL, 0x000fe200078e023eULL,
0x0000059000009947ULL, 0x000fea0003800000ULL, 0x0000003e03087217ULL, 0x000fe20007800000ULL,
0x00000200ff557424ULL, 0x000fe200078e00ffULL, 0x00000003ff4d7819ULL, 0x000fe4000001160cULL,
0x0000003942577210ULL, 0x000fe20007ffe0ffULL, 0x0000000108087824ULL, 0x000fe200078e0a3eULL,
0x000000044d517810ULL, 0x040fe20007ffe0ffULL, 0x000000014d3e7824ULL, 0x040fe200078e020cULL,
0x000000084d537810ULL, 0x040fe20007ffe0ffULL, 0x000000014d097824ULL, 0x000fe200078e020bULL,
0x00000020080a7817ULL, 0x000fe20003800000ULL, 0x00000008515b7824ULL, 0x000fe200078e00ffULL,
0x0000000c4d597810ULL, 0x000fe20007ffe0ffULL, 0x00005e0009087625ULL, 0x000fe200078e0055ULL,
0x000000073e4f7812ULL, 0x000fc400078ec0ffULL, 0x0000000a4d00720cULL, 0x000fe20003f06070ULL,
0x00000001534e7824ULL, 0x100fe200078e020cULL, 0x0ffffff84f3e7812ULL, 0x100fe200078ef80cULL,
0x00000008535d7824ULL, 0x000fe200078e00ffULL, 0x0000000c514c7210ULL, 0x000fe20007ffe0ffULL,
0x0000000159507824ULL, 0x040fe200078e020cULL, 0x00000003595f7819ULL, 0x000fe200000006ffULL,
0x0000001057087825ULL, 0x000fe200078e0008ULL, 0xfffffff85d567812ULL, 0x000fe400078ee24eULL,
0xfffffff85f5a7812ULL, 0x000fe200078ee250ULL, 0x000000103e4f7824ULL, 0x000fe200078e022bULL,
0xfffffff85b3e7812ULL, 0x000fe200078ee24cULL, 0x00000001594c7824ULL, 0x000fe200078e020bULL,
0x000000104d5b7810ULL, 0x000fc40007ffe0ffULL, 0x000000144d5d7810ULL, 0x040fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000084f7faeULL, 0x0003e2000c101c46ULL,
0x000000184d5f7810ULL, 0x000fe20007ffe0ffULL, 0x000000085b5c7824ULL, 0x000fe200078e00ffULL,
0x0000001c4d617810ULL, 0x000fe20007ffe0ffULL, 0x000000015d507824ULL, 0x100fe200078e020bULL,
0x0000000a5100720cULL, 0x080fe20003f06070ULL, 0x000000015f527824ULL, 0x100fe200078e020bULL,
0x0000000a5300720cULL, 0x080fe20003f26070ULL, 0x0000000161547824ULL, 0x100fe200078e020bULL,
0x0000000a5900720cULL, 0x080fe20003f46070ULL, 0x000000015d4d7824ULL, 0x100fe200078e020cULL,
0x0000000a5b00720cULL, 0x080fe20003f66070ULL, 0x0000000151087824ULL, 0x102fe200078e020bULL,
0x0000000a5d00720cULL, 0x080fe20003f86070ULL, 0x000000015b097824ULL, 0x100fe200078e020cULL,
0x0000000a5f00720cULL, 0x0c0fe20003fa6070ULL, 0x000000085f607824ULL, 0x000fe200078e00ffULL,
0x0000000a6100720cULL, 0x000fe20003fc6070ULL, 0x00000001530a7824ULL, 0x000fe200078e020bULL,
0x0000000b5b4e7210ULL, 0x000fe20007ffe0ffULL, 0x000000015f0b7824ULL, 0x000fe200078e020cULL,
0x000000035d5e7819ULL, 0x000fe200000006ffULL, 0x0000000861627824ULL, 0x040fe200078e00ffULL,
0x0000000c614f7210ULL, 0x000fe20007ffe0ffULL, 0x00005e0050507625ULL, 0x000fe200078e0055ULL,
0xfffffff85c5c7812ULL, 0x000fc400078ee209ULL, 0xfffffff85e5e7812ULL, 0x000fe200078ee24dULL,
0x00005e0008087625ULL, 0x080fe200078e0055ULL, 0xfffffff860607812ULL, 0x000fe400078ee20bULL,
0xfffffff862627812ULL, 0x000fe200078ee24fULL, 0x00005e000a0a7625ULL, 0x000fe200078e0055ULL,
0x0000002b5c5d7211ULL, 0x000fc600078e20ffULL, 0x00005e004c4c7625ULL, 0x000fc800078e0055ULL,
0x00005e004e4e7625ULL, 0x000fc800078e0055ULL, 0x00005e0052527625ULL, 0x000fc800078e0055ULL,
0x00005e0054547625ULL, 0x000fc800078e0055ULL, 0x0000001057087825ULL, 0x000fc800078e0008ULL,
0x00000010570a7825ULL, 0x000fc800078e000aULL, 0x00000010574c7825ULL, 0x000fc800078e004cULL,
0x00000010574e7825ULL, 0x000fc800078e004eULL, 0x0000001057507825ULL, 0x000fc800078e0050ULL,
0x0000001057527825ULL, 0x000fc800078e0052ULL, 0x0000001057547825ULL, 0x000fc800078e0054ULL,
0x000000103e577824ULL, 0x100fe400078e022bULL, 0x0000001056597824ULL, 0x100fe400078e022bULL,
0x000000105a5b7824ULL, 0x100fe200078e022bULL, 0x0000000008577faeULL, 0x0003e2000c101c46ULL,
0x000000105e5f7824ULL, 0x100fe400078e022bULL, 0x0000001060617824ULL, 0x100fe200078e022bULL,
0x000000000a597faeULL, 0x0003e2000c901c46ULL, 0x00000010622b7824ULL, 0x000fc600078e022bULL,
0x000000004c5b7faeULL, 0x0003e8000d101c46ULL, 0x000000004e5d7faeULL, 0x0003e8000d901c46ULL,
0x00000000505f7faeULL, 0x0003e8000e101c46ULL, 0x0000000052617faeULL, 0x0003e8000e901c46ULL,
0x00000000542b7faeULL, 0x0003e2000f101c46ULL, 0x000004c000007947ULL, 0x000fea0003800000ULL,
0x000000040c0a7811ULL, 0x040fe200078fe8ffULL, 0x00000200ff577424ULL, 0x000fe200078e00ffULL,
0x000000080c4c7811ULL, 0x000fe200078fe8ffULL, 0x0000000142597824ULL, 0x000fe200078e0239ULL,
0x0000000c0c4e7811ULL, 0x000fe200078fe8ffULL, 0x000000010a087824ULL, 0x100fe200078e020cULL,
0x000000100c507811ULL, 0x000fe200078fe8ffULL, 0x000000014c097824ULL, 0x100fe200078e020cULL,
0x000000030a4f7819ULL, 0x000fe200000006ffULL, 0x000000084c5c7824ULL, 0x000fe200078e00ffULL,
0x0000000c504d7210ULL, 0x080fe20007ffe0ffULL, 0x000000014e3e7824ULL, 0x040fe200078e020cULL,
0xfffffff84f5a7812ULL, 0x000fe200078ee208ULL, 0x000000084e517824ULL, 0x000fe200078e00ffULL,
0xfffffff85c5c7812ULL, 0x000fe200078ee209ULL, 0x0000000850607824ULL, 0x000fe200078e00ffULL,
0x000000140c097811ULL, 0x000fe200078fe8ffULL, 0x000000010a0a7824ULL, 0x100fe200078e020bULL,
0x000000180c4f7811ULL, 0x000fe200078fe8ffULL, 0x000000014e4e7824ULL, 0x100fe200078e020bULL,
0x0000001c0c537811ULL, 0x000fe200078fe8ffULL, 0x0000000150507824ULL, 0x100fe200078e020bULL,
0xfffffff8515e7812ULL, 0x000fe200078ee23eULL, 0x0000000109527824ULL, 0x100fe200078e020bULL,
0x0000000c0c3e7211ULL, 0x080fe200078fe8ffULL, 0x000000014f547824ULL, 0x000fe200078e020bULL,
0xfffffff860607812ULL, 0x000fe200078ee24dULL, 0x00000001094d7824ULL, 0x100fe200078e020cULL,
0x0000000b0c087211ULL, 0x080fe200078fe8ffULL, 0x000000014f517824ULL, 0x040fe200078e020cULL,
0x0000000b4c4c7210ULL, 0x000fe20007ffe0ffULL, 0x000000084f647824ULL, 0x000fe200078e00ffULL,
0x0000000309627819ULL, 0x000fe200000006ffULL, 0x0000000153567824ULL, 0x040fe200078e020bULL,
0x0000000c534f7210ULL, 0x040fe20007ffe0ffULL, 0x0000000853667824ULL, 0x000fe200078e00ffULL,
0x000000073e0b7812ULL, 0x000fe200078ec0ffULL, 0x00005e0008087625ULL, 0x000fe200078e0057ULL,
0xfffffff862627812ULL, 0x000fc400078ee24dULL, 0xfffffff864647812ULL, 0x000fe200078ee251ULL,
0x00005e004c4c7625ULL, 0x080fe200078e0057ULL, 0xfffffff866667812ULL, 0x000fe400078ee24fULL,
0x0ffffff80b3e7812ULL, 0x000fe200078ef80cULL, 0x00005e000a0a7625ULL, 0x000fe200078e0057ULL,
0x0000002b5e5f7211ULL, 0x000fc600078e20ffULL, 0x00005e004e4e7625ULL, 0x000fc800078e0057ULL,
0x00005e0050507625ULL, 0x000fc800078e0057ULL, 0x00005e0052527625ULL, 0x000fc800078e0057ULL,
0x00005e0054547625ULL, 0x000fc800078e0057ULL, 0x00005e0056567625ULL, 0x000fc800078e0057ULL,
0x0000001059087825ULL, 0x000fc800078e0008ULL, 0x00000010590a7825ULL, 0x000fc800078e000aULL,
0x00000010594c7825ULL, 0x000fc800078e004cULL, 0x00000010594e7825ULL, 0x000fc800078e004eULL,
0x0000001059507825ULL, 0x000fc800078e0050ULL, 0x0000001059527825ULL, 0x000fc800078e0052ULL,
0x0000001059547825ULL, 0x000fc800078e0054ULL, 0x0000001059567825ULL, 0x000fc800078e0056ULL,
0x000000103e597824ULL, 0x100fe400078e022bULL, 0x000000105a5b7824ULL, 0x100fe400078e022bULL,
0x000000105c5d7824ULL, 0x100fe200078e022bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008597faeULL, 0x0003e2000b901c46ULL, 0x0000001060617824ULL, 0x100fe400078e022bULL,
0x0000001062637824ULL, 0x100fe200078e022bULL, 0x000000000a5b7faeULL, 0x0003e2000b901c46ULL,
0x0000001064657824ULL, 0x000fc400078e022bULL, 0x00000010662b7824ULL, 0x000fe200078e022bULL,
0x000000004c5d7faeULL, 0x0003e8000b901c46ULL, 0x000000004e5f7faeULL, 0x0003e8000b901c46ULL,
0x0000000050617faeULL, 0x0003e8000b901c46ULL, 0x0000000052637faeULL, 0x0003e8000b901c46ULL,
0x0000000054657faeULL, 0x0003e8000b901c46ULL, 0x00000000562b7faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01466800424c7f8cULL, 0x0022a4000c80043fULL, 0x0000000000087805ULL, 0x000fc40000015200ULL,
0x01466c00420b7984ULL, 0x000ee40000000800ULL, 0x800000000bff7812ULL, 0x00cfc4000780484dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ff003e7202ULL, 0x000fe20000000f00ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a082b7210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e09ULL, 0x003d09002b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0a7819ULL, 0x000fc8000001140bULL,
0x0000002b0a0a7211ULL, 0x000fca00078110ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e060bULL,
0x000000020a0a7819ULL, 0x000fc8000000120bULL, 0x0000000a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01466c00420b7984ULL, 0x000ea40000000800ULL,
0x800000000bff7812ULL, 0x004fe4000780484dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x014180003d0b7984ULL, 0x000ea80000000800ULL, 0x014380003d0a7984ULL, 0x0006620000000800ULL,
0x000000580b00720bULL, 0x004fe20003f1d000ULL, 0x0000d9527f007947ULL, 0x000fd8000b800000ULL,
0x00000000002b7806ULL, 0x008fc800000e0100ULL, 0x0000ffff2bff7812ULL, 0x000fe2000782c0ffULL,
0x0000045000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fd60003f0e170ULL,
0x0000042000009947ULL, 0x000fea0003800000ULL, 0x000000030000780cULL, 0x000fe40003f05270ULL,
0x000000580b00720bULL, 0x000fe20003f34000ULL, 0x0000d9227f007947ULL, 0x000fd8000b800000ULL,
0x00000000003c7806ULL, 0x000fc400008e0100ULL, 0x000000580b088209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x000099103c097816ULL, 0x000fc600000000ffULL,
0x014580083d008388ULL, 0x0005e20000000800ULL, 0x000000ff0900720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x000000580b097209ULL, 0x004fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff3cff7812ULL, 0x000fc6000780c0ffULL,
0x0000005809087221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b08087820ULL, 0x000fc80000410000ULL,
0x00000008003e7308ULL, 0x000ea40000000800ULL, 0x0000003e41417220ULL, 0x004fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff087819ULL, 0x000fe2000001160cULL,
0x0000d8627f007947ULL, 0x000fea000b800000ULL, 0x00001f083e087589ULL, 0x0004e400000e0000ULL,
0x0000000810107220ULL, 0x088fe20000410000ULL, 0x0000000811117220ULL, 0x080fe20000410000ULL,
0x0000000818187220ULL, 0x080fe20000410000ULL, 0x0000000819197220ULL, 0x080fe20000410000ULL,
0x0000000814147220ULL, 0x080fe20000410000ULL, 0x0000000815157220ULL, 0x080fe20000410000ULL,
0x000000081c1c7220ULL, 0x080fe20000410000ULL, 0x000000081d1d7220ULL, 0x080fe20000410000ULL,
0x0000000820207220ULL, 0x080fe20000410000ULL, 0x0000000821217220ULL, 0x080fe20000410000ULL,
0x0000000848487220ULL, 0x080fe20000410000ULL, 0x0000000849497220ULL, 0x080fe20000410000ULL,
0x0000000844447220ULL, 0x080fe20000410000ULL, 0x0000000845457220ULL, 0x080fe20000410000ULL,
0x0000000804047220ULL, 0x080fe20000410000ULL, 0x0000000805057220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff003cff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000080c087811ULL, 0x000fe200078ff0ffULL,
0x0000d7527f007947ULL, 0x000fea000b800000ULL, 0x00001f083e087589ULL, 0x0006a400000e0000ULL,
0x0000000812127220ULL, 0x084fe20000410000ULL, 0x0000000813137220ULL, 0x080fe20000410000ULL,
0x000000081a1a7220ULL, 0x080fe20000410000ULL, 0x000000081b1b7220ULL, 0x080fe20000410000ULL,
0x0000000816167220ULL, 0x080fe20000410000ULL, 0x0000000817177220ULL, 0x080fe20000410000ULL,
0x000000081e1e7220ULL, 0x080fe20000410000ULL, 0x000000081f1f7220ULL, 0x080fe20000410000ULL,
0x0000000822227220ULL, 0x080fe20000410000ULL, 0x0000000823237220ULL, 0x080fe20000410000ULL,
0x000000084a4a7220ULL, 0x080fe20000410000ULL, 0x000000084b4b7220ULL, 0x080fe20000410000ULL,
0x0000000846467220ULL, 0x080fe20000410000ULL, 0x0000000847477220ULL, 0x080fe20000410000ULL,
0x0000000806067220ULL, 0x080fe20000410000ULL, 0x0000000807077220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff3cff7812ULL, 0x000fe4000780082bULL,
0x000000580b587209ULL, 0x000fd60007810000ULL, 0x800000580b0b0221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b0b0b0820ULL, 0x000fc80000410000ULL, 0x0000000b003a0308ULL, 0x000ea40000000800ULL,
0x0000003a0a0a0220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000015000007945ULL, 0x000fe20003800000ULL,
0x000000410a417221ULL, 0x002fe20000010000ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x0000003aff08723eULL, 0x000fe400000010ffULL, 0x00000002ff0b7819ULL, 0x000fe4000001160cULL,
0x00005410080a7816ULL, 0x000fe20000000008ULL, 0x0000d5927f007947ULL, 0x000fea000b800000ULL,
0x00001f0b0a3b7589ULL, 0x0002a400000e0000ULL, 0x000000080b087810ULL, 0x000fe20007ffe0ffULL,
0x0000d5c27f007947ULL, 0x000fea000b800000ULL, 0x00001f080a387589ULL, 0x0002e400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000100b087810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff597224ULL, 0x000fe200078e000aULL, 0x000098f0005a7802ULL, 0x000fc40000000f00ULL,
0x0000db1000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000180b087810ULL, 0x002fe40007ffe0ffULL, 0x0000000a00597202ULL, 0x004fc40000000f00ULL,
0x00009940005a7802ULL, 0x000fc40000000f00ULL, 0x0000dac000007944ULL, 0x008fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000b80037377811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000003550783bULL, 0x000fe20000004200ULL,
0x0000b80031087811ULL, 0x002fc600078e20ffULL, 0x00000000374c783bULL, 0x000e680000000200ULL,
0x000000003454783bULL, 0x000fe80000004200ULL, 0x00000000335c783bULL, 0x000fe80000004200ULL,
0x000000003260783bULL, 0x000fe80000004200ULL, 0x000000000808783bULL, 0x000f280000000200ULL,
0x000000003064783bULL, 0x0006a80000004200ULL, 0x000000002f68783bULL, 0x000ea80000004200ULL,
0x000000002e6c783bULL, 0x000ea80000004200ULL, 0x000000002d70783bULL, 0x000ea40000004200ULL,
0x0000003b4c4c0231ULL, 0x006fc400003400ffULL, 0x0000003b4e4e0231ULL, 0x000fe400003400ffULL,
0x000000384d4d0231ULL, 0x088fe400003400ffULL, 0x000000384f4f0231ULL, 0x000fce00003400ffULL,
0x000000504c10723cULL, 0x000f620000041810ULL, 0x0000003b08080231ULL, 0x090fe400003400ffULL,
0x0000003b0a0a0231ULL, 0x000fe400003400ffULL, 0x0000003809090231ULL, 0x000fc600003400ffULL,
0x000000524c18723cULL, 0x000f620000041818ULL, 0x000000380b0b0231ULL, 0x000fce00003400ffULL,
0x000000564c1c723cULL, 0x040f70000004181cULL, 0x0000005c4c20723cULL, 0x040f700000041820ULL,
0x000000604c30723cULL, 0x040ff00000041844ULL, 0x000000544c14723cULL, 0x040f700000041814ULL,
0x0000005e4c48723cULL, 0x040f700000041848ULL, 0x000000624c44723cULL, 0x000f700000041804ULL,
0x000000640804723cULL, 0x060f700000041810ULL, 0x000000660810723cULL, 0x040f700000041818ULL,
0x0000006a0818723cULL, 0x040f70000004181cULL, 0x0000006c081c723cULL, 0x040f700000041820ULL,
0x000000680814723cULL, 0x040f700000041814ULL, 0x0000006e0820723cULL, 0x040f700000041848ULL,
0x000000700830723cULL, 0x040f700000041830ULL, 0x000000720844723cULL, 0x000b6e0000041844ULL,
0x0000030002087a10ULL, 0x020fc80007ffe0ffULL, 0x00000001080a7810ULL, 0x000fc80007ffe0ffULL,
0x0000000d0a00720cULL, 0x000fe20003f26070ULL, 0x00000100080a7824ULL, 0x000fc800078e00ffULL,
0x00006200432d7a24ULL, 0x000fe200078e020aULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000059000009947ULL, 0x000fea0003800000ULL, 0x00000003ff2e7819ULL, 0x000fe2000001160cULL,
0x00000200ff497424ULL, 0x000fe200078e00ffULL, 0x0000000a03087217ULL, 0x000fe40007800000ULL,
0x000000042e347810ULL, 0x040fe40007ffe0ffULL, 0x0000000c2e3e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000108087824ULL, 0x000fe200078e0a0aULL, 0x0000003942397210ULL, 0x000fe20007ffe0ffULL,
0x0000000134097824ULL, 0x100fe200078e020cULL, 0x000000182e4a7810ULL, 0x000fe20007ffe0ffULL,
0x00000008343c7824ULL, 0x000fe200078e00ffULL, 0x00000020082b7817ULL, 0x000fe20003800000ULL,
0x000000012e0a7824ULL, 0x140fe200078e020cULL, 0x0000001c2e4c7810ULL, 0x000fe20007ffe0ffULL,
0x000000013e3d7824ULL, 0x000fe200078e020cULL, 0xfffffff83c357812ULL, 0x000fe200078ee209ULL,
0x000000012e097824ULL, 0x100fe200078e022dULL, 0x000000070a0b7812ULL, 0x000fe200078ec0ffULL,
0x00000001340a7824ULL, 0x000fe200078e022dULL, 0x000000082e3c7810ULL, 0x040fe20007ffe0ffULL,
0x00005e0009087625ULL, 0x000fe200078e0049ULL, 0x0000002b2e00720cULL, 0x000fc40003f26070ULL,
0x0000002b3400720cULL, 0x000fe20003f46070ULL, 0x000000083c377824ULL, 0x000fe200078e00ffULL,
0x0ffffff80b2f7812ULL, 0x000fe200078ef80cULL, 0x00005e000a0a7625ULL, 0x000fe200078e0049ULL,
0x0000000c3c347210ULL, 0x000fe40007ffe0ffULL, 0x0000003635357211ULL, 0x000fe200078e20ffULL,
0x000000083e487824ULL, 0x000fe200078e00ffULL, 0xfffffff837377812ULL, 0x000fe200078ee234ULL,
0x0000001039087825ULL, 0x000fe200078e0008ULL, 0x000000102e347810ULL, 0x000fc40007ffe0ffULL,
0xfffffff8484b7812ULL, 0x000fe200078ee23dULL, 0x000000102f2f7824ULL, 0x000fe200078e0236ULL,
0x000000142e487810ULL, 0x000fe20007ffe0ffULL, 0x00000010390a7825ULL, 0x000fe200078e000aULL,
0x0000002b3400720cULL, 0x080fe40003f66070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000082f7faeULL, 0x0003e2000c901c46ULL, 0x0000002b3c00720cULL, 0x080fe20003f26070ULL,
0x00000001342e7824ULL, 0x000fe200078e022dULL, 0x0000002b4800720cULL, 0x080fe20003f86070ULL,
0x000000000a357faeULL, 0x0005e2000d101c46ULL, 0x0000002b3e00720cULL, 0x080fe20003f46070ULL,
0x00000008484e7824ULL, 0x000fe200078e00ffULL, 0x0000002b4a00720cULL, 0x080fe20003fa6070ULL,
0x000000104b4b7824ULL, 0x000fe200078e0236ULL, 0x0000002b4c00720cULL, 0x000fc40003fc6070ULL,
0x0000003637377211ULL, 0x000fe200078e20ffULL, 0x000000013c087824ULL, 0x102fe400078e022dULL,
0x0000000134097824ULL, 0x100fe400078e020cULL, 0x000000013e0a7824ULL, 0x104fe200078e022dULL,
0x00000003343e7819ULL, 0x000fe200000006ffULL, 0x0000000148347824ULL, 0x140fe400078e022dULL,
0x00000001480b7824ULL, 0x100fe200078e020cULL, 0x0000002d4c487210ULL, 0x000fe20007ffe0ffULL,
0x000000014a3c7824ULL, 0x000fe200078e022dULL, 0xfffffff83e2b7812ULL, 0x000fe200078ee209ULL,
0x000000014a2f7824ULL, 0x000fe200078e020cULL, 0xfffffff84e2d7812ULL, 0x000fe200078ee20bULL,
0x000000084a4a7824ULL, 0x000fc400078e00ffULL, 0x000000014c357824ULL, 0x040fe400078e020cULL,
0x000000084c4c7824ULL, 0x000fe200078e00ffULL, 0xfffffff84a4d7812ULL, 0x000fe200078ee22fULL,
0x00005e0008087625ULL, 0x000fc600078e0049ULL, 0xfffffff84c4f7812ULL, 0x000fe200078ee235ULL,
0x00005e000a0a7625ULL, 0x000fc600078e0049ULL, 0x000000364f4f7211ULL, 0x000fe200078e20ffULL,
0x00005e002e2e7625ULL, 0x000fc800078e0049ULL, 0x00005e0034347625ULL, 0x000fc800078e0049ULL,
0x00005e003c3c7625ULL, 0x000fc800078e0049ULL, 0x00005e0048487625ULL, 0x000fc800078e0049ULL,
0x0000001039087825ULL, 0x000fc800078e0008ULL, 0x00000010390a7825ULL, 0x040fe200078e000aULL,
0x0000000008377faeULL, 0x0003e6000c901c46ULL, 0x00000010392e7825ULL, 0x000fe200078e002eULL,
0x000000000a4b7faeULL, 0x0003e6000d101c46ULL, 0x000000102b2b7824ULL, 0x000fe400078e0236ULL,
0x0000001039347825ULL, 0x000fc600078e0034ULL, 0x000000002e2b7faeULL, 0x0003e2000d901c46ULL,
0x000000102d2d7824ULL, 0x000fe400078e0236ULL, 0x00000010393c7825ULL, 0x000fc600078e003cULL,
0x00000000342d7faeULL, 0x0003e2000e101c46ULL, 0x000000104d4d7824ULL, 0x000fe400078e0236ULL,
0x0000001039487825ULL, 0x000fc600078e0048ULL, 0x000000003c4d7faeULL, 0x0003e8000e901c46ULL,
0x00000000484f7faeULL, 0x0003e2000f101c46ULL, 0x000004c000007947ULL, 0x000fea0003800000ULL,
0x000000080c2e7811ULL, 0x000fe200078fe8ffULL, 0x0000000142397824ULL, 0x000fe200078e0239ULL,
0x0000000c0c347811ULL, 0x040fe400078fe8ffULL, 0x000000100c3c7811ULL, 0x000fe200078fe8ffULL,
0x000000012e097824ULL, 0x100fe200078e020cULL, 0x000000040c0a7811ULL, 0x000fe200078fe8ffULL,
0x000000082e3e7824ULL, 0x000fe200078e00ffULL, 0x0000000c340b7210ULL, 0x0c0fe20007ffe0ffULL,
0x0000000834487824ULL, 0x000fe200078e00ffULL, 0x000000180c2f7811ULL, 0x000fe200078fe8ffULL,
0x000000013c2b7824ULL, 0x100fe200078e020cULL, 0xfffffff83e4f7812ULL, 0x000fe200078ee209ULL,
0x000000083c4a7824ULL, 0x000fe200078e00ffULL, 0x000000140c097811ULL, 0x000fe200078fe8ffULL,
0x000000010a087824ULL, 0x100fe200078e020cULL, 0xfffffff848517812ULL, 0x000fe200078ee20bULL,
0x000000080a377824ULL, 0x000fe200078e00ffULL, 0x0000001c0c3d7811ULL, 0x040fe200078fe8ffULL,
0x00000008093e7824ULL, 0x000fe200078e00ffULL, 0x0000000c0c0b7211ULL, 0x000fe200078fe8ffULL,
0x000000012f357824ULL, 0x100fe200078e020cULL, 0xfffffff84a537812ULL, 0x000fe200078ee22bULL,
0x00000001092b7824ULL, 0x000fe200078e020cULL, 0xfffffff837377812ULL, 0x000fe200078ee208ULL,
0x000000012f4a7824ULL, 0x100fe200078e022dULL, 0x0000002d0c087211ULL, 0x080fe200078fe8ffULL,
0x000000083d507824ULL, 0x000fe200078e00ffULL, 0x00000200004d7802ULL, 0x000fe20000000f00ULL,
0x000000010a0a7824ULL, 0x100fe200078e022dULL, 0x000000032f4e7819ULL, 0x000fe200000006ffULL,
0x000000013d2f7824ULL, 0x100fe200078e020cULL, 0x000000070b0b7812ULL, 0x000fe200078ec0ffULL,
0x000000012e2e7824ULL, 0x100fe200078e022dULL, 0x0000002d09487210ULL, 0x000fe20007ffe0ffULL,
0x0000000134347824ULL, 0x000fe200078e022dULL, 0xfffffff850577812ULL, 0x000fe200078ee22fULL,
0x000000013c3c7824ULL, 0x000fe200078e022dULL, 0xfffffff84e557812ULL, 0x000fe200078ee235ULL,
0x000000013d4c7824ULL, 0x000fe200078e022dULL, 0xfffffff83e2d7812ULL, 0x000fe200078ee22bULL,
0x00005e0008087625ULL, 0x000fe200078e004dULL, 0x0ffffff80b2b7812ULL, 0x000fc400078ef80cULL,
0x0000003637377211ULL, 0x080fe200078e20ffULL, 0x00005e000a0a7625ULL, 0x000fe200078e004dULL,
0x0000003655557211ULL, 0x000fc600078e20ffULL, 0x00005e002e2e7625ULL, 0x000fc800078e004dULL,
0x00005e0034347625ULL, 0x000fc800078e004dULL, 0x00005e003c3c7625ULL, 0x000fc800078e004dULL,
0x00005e0048487625ULL, 0x000fc800078e004dULL, 0x0000001039087825ULL, 0x000fc800078e0008ULL,
0x00005e004a4a7625ULL, 0x000fc800078e004dULL, 0x000000102b2b7824ULL, 0x000fe400078e0236ULL,
0x00005e004c4c7625ULL, 0x000fc600078e004dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000082b7faeULL, 0x0003e2000b901c46ULL, 0x00000010390a7825ULL, 0x000fc800078e000aULL,
0x00000010392e7825ULL, 0x000fe200078e002eULL, 0x000000000a377faeULL, 0x0003e6000b901c46ULL,
0x000000104f4f7824ULL, 0x000fe400078e0236ULL, 0x0000001039347825ULL, 0x000fc600078e0034ULL,
0x000000002e4f7faeULL, 0x0003e2000b901c46ULL, 0x0000001051517824ULL, 0x000fe400078e0236ULL,
0x00000010393c7825ULL, 0x000fc600078e003cULL, 0x0000000034517faeULL, 0x0003e2000b901c46ULL,
0x0000001053537824ULL, 0x000fe400078e0236ULL, 0x0000001039487825ULL, 0x000fc600078e0048ULL,
0x000000003c537faeULL, 0x0003e2000b901c46ULL, 0x000000102d2d7824ULL, 0x000fe400078e0236ULL,
0x00000010394a7825ULL, 0x000fc600078e004aULL, 0x00000000482d7faeULL, 0x0003e2000b901c46ULL,
0x00000010394c7825ULL, 0x000fc600078e004cULL, 0x000000004a557faeULL, 0x0003e2000b901c46ULL,
0x0000001057577824ULL, 0x000fca00078e0236ULL, 0x000000004c577faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000015000007945ULL, 0x000fe20003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x0000003aff08723eULL, 0x002fe400000010ffULL, 0x00000002ff0b7819ULL, 0x000fe4000001160cULL,
0x00005410080a7816ULL, 0x000fe20000000008ULL, 0x0000c7c27f007947ULL, 0x000fea000b800000ULL,
0x00001f0b0a3b7589ULL, 0x0002a400000e0000ULL, 0x000000080b087810ULL, 0x000fe20007ffe0ffULL,
0x0000c7f27f007947ULL, 0x000fea000b800000ULL, 0x00001f080a387589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000100b087810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff597224ULL, 0x000fe200078e000aULL, 0x0000a770005a7802ULL, 0x000fc40000000f00ULL,
0x0000cc9000007944ULL, 0x006fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000180b087810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff597224ULL, 0x004fe200078e000aULL,
0x0000a7c0005a7802ULL, 0x000fc40000000f00ULL, 0x0000cc4000007944ULL, 0x002fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000b8002c2c7811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000002a08783bULL, 0x00afe20000004200ULL,
0x0000b80026267811ULL, 0x000fc600078e20ffULL, 0x000000002c2c783bULL, 0x000e680000000200ULL,
0x000000002934783bULL, 0x000fe80000004200ULL, 0x000000002848783bULL, 0x000fe80000004200ULL,
0x00000000274c783bULL, 0x000fe80000004200ULL, 0x000000002650783bULL, 0x000ee80000000200ULL,
0x000000002554783bULL, 0x000f280000004200ULL, 0x00000000245c783bULL, 0x0004a80000004200ULL,
0x000000000f60783bULL, 0x000ea80000004200ULL, 0x000000000e64783bULL, 0x000f220000004200ULL,
0x0000003b2c2c0231ULL, 0x006fc400003400ffULL, 0x0000003b2e2e0231ULL, 0x000fe400003400ffULL,
0x000000382d2d0231ULL, 0x080fe400003400ffULL, 0x000000382f2f0231ULL, 0x000fce00003400ffULL,
0x000000082c04723cULL, 0x000f620000041804ULL, 0x0000003b50500231ULL, 0x088fe400003400ffULL,
0x0000003b52520231ULL, 0x000fe400003400ffULL, 0x0000003851510231ULL, 0x000fc600003400ffULL,
0x000000342c14723cULL, 0x000fe20000041814ULL, 0x0000003853530231ULL, 0x000fce00003400ffULL,
0x000000482c24723cULL, 0x040ff0000004181cULL, 0x0000000a2c08723cULL, 0x040f700000041810ULL,
0x000000362c34723cULL, 0x040f700000041818ULL, 0x0000004a2c48723cULL, 0x040f700000041820ULL,
0x0000004c2c30723cULL, 0x040f700000041830ULL, 0x0000004e2c2c723cULL, 0x000f700000041844ULL,
0x000000545010723cULL, 0x070b700000041804ULL, 0x000000565018723cULL, 0x040b700000041808ULL,
0x0000005c5014723cULL, 0x040b700000041814ULL, 0x0000005e501c723cULL, 0x040b700000041834ULL,
0x000000605020723cULL, 0x040b700000041824ULL, 0x000000625048723cULL, 0x040b700000041848ULL,
0x000000645044723cULL, 0x040b700000041830ULL, 0x000000665004723cULL, 0x000b62000004182cULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0146a000ffff7f8cULL, 0x000fe4000c80043fULL, 0x0000030002027a10ULL, 0x000fc80007ffe0ffULL,
0x0000000d0200720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffff67c000007947ULL, 0x000fea000383ffffULL, 0x0000000000267919ULL, 0x020e620000002500ULL,
0x000000ffff247224ULL, 0x000fe200078e0007ULL, 0x0000000600257202ULL, 0x000fe20000000f00ULL,
0x000000ffff0b7224ULL, 0x000fe400078e0005ULL, 0x000000ffff0c7224ULL, 0x000fe200078e0004ULL,
0x0000000d2600720cULL, 0x002fda0003f06070ULL, 0x0000035000000947ULL, 0x000fea0003800000ULL,
0x0180000041027810ULL, 0x000fe20007ffe0ffULL, 0x000000d000007945ULL, 0x000fe60003800000ULL,
0x7f80000002027812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0200780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff327224ULL, 0x000fe200078e0041ULL,
0x0000abc000067802ULL, 0x000fc40000000f00ULL, 0x0000c67000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff027224ULL, 0x000fe200078e0007ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000004100027308ULL, 0x000e640000001000ULL, 0xbf80000002037423ULL, 0x002fc80000000041ULL,
0x800000ff03037221ULL, 0x000fc80000010100ULL, 0x0000000302027223ULL, 0x000fc40000000002ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000ea80000000000ULL,
0x0000000000047919ULL, 0x000ee20000000000ULL, 0x00000002ff037819ULL, 0x004fe40000011603ULL,
0x0000000804057811ULL, 0x008fc800078ff0ffULL, 0x00001f0302037589ULL, 0x000ea800000e0000ULL,
0x00001f0502047589ULL, 0x000ee200000e0000ULL, 0x0000001003107220ULL, 0x044fe20000410000ULL,
0x0000001103117220ULL, 0x040fe20000410000ULL, 0x0000001803187220ULL, 0x040fe20000410000ULL,
0x0000001903197220ULL, 0x040fe20000410000ULL, 0x0000001403147220ULL, 0x040fe20000410000ULL,
0x0000001503157220ULL, 0x040fe20000410000ULL, 0x0000001c031c7220ULL, 0x040fe20000410000ULL,
0x0000001d031d7220ULL, 0x040fe20000410000ULL, 0x0000002003207220ULL, 0x040fe20000410000ULL,
0x0000002103217220ULL, 0x040fe20000410000ULL, 0x0000004803487220ULL, 0x040fe20000410000ULL,
0x0000004903497220ULL, 0x040fe20000410000ULL, 0x0000004403447220ULL, 0x040fe20000410000ULL,
0x0000004503457220ULL, 0x040fe20000410000ULL, 0x0000000c030c7220ULL, 0x040fe20000410000ULL,
0x0000000b030b7220ULL, 0x000fe20000410000ULL, 0x0000001204127220ULL, 0x048fe20000410000ULL,
0x0000001304137220ULL, 0x040fe20000410000ULL, 0x0000001a041a7220ULL, 0x040fe20000410000ULL,
0x0000001b041b7220ULL, 0x040fe20000410000ULL, 0x0000001604167220ULL, 0x040fe20000410000ULL,
0x0000001704177220ULL, 0x040fe20000410000ULL, 0x0000001e041e7220ULL, 0x040fe20000410000ULL,
0x0000001f041f7220ULL, 0x040fe20000410000ULL, 0x0000002204227220ULL, 0x040fe20000410000ULL,
0x0000002304237220ULL, 0x040fe20000410000ULL, 0x0000004a044a7220ULL, 0x040fe20000410000ULL,
0x0000004b044b7220ULL, 0x040fe20000410000ULL, 0x0000004604467220ULL, 0x040fe20000410000ULL,
0x0000004704477220ULL, 0x040fe20000410000ULL, 0x0000002504257220ULL, 0x040fe20000410000ULL,
0x0000002404247220ULL, 0x000fc20000410000ULL, 0x0000000000277919ULL, 0x000ea20000000000ULL,
0x000000181905723eULL, 0x000fc400000010ffULL, 0x000000141506723eULL, 0x000fe200000010ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000001a1b0d723eULL, 0x000fe400000010ffULL,
0x00000016170e723eULL, 0x000fe400000010ffULL, 0x0000001c1d07723eULL, 0x000fc400000010ffULL,
0x0000001e1f0f723eULL, 0x000fe200000010ffULL, 0x00000300ff1f7624ULL, 0x000fe200078e00ffULL,
0x000000202108723eULL, 0x000fe400000010ffULL, 0x0000000c0b0b723eULL, 0x000fe400000010ffULL,
0x00000012130c723eULL, 0x000fe400000010ffULL, 0x00000002ff197819ULL, 0x004fe40000011627ULL,
0x000000252413723eULL, 0x000fc400000010ffULL, 0x0000000119027810ULL, 0x040fe20007ffe0ffULL,
0x0000000819187824ULL, 0x040fe200078e00ffULL, 0x0000000319157819ULL, 0x040fe200000006ffULL,
0x0000000819177824ULL, 0x040fe200078e00ffULL, 0x0000000219037810ULL, 0x040fe20007ffe0ffULL,
0x00000008191b7824ULL, 0x000fe200078e00ffULL, 0xfffffff815167812ULL, 0x000fe200078ee202ULL,
0x00000008191c7824ULL, 0x040fe200078e00ffULL, 0x0000000319027810ULL, 0x040fe40007ffe0ffULL,
0x0000000519147810ULL, 0x000fc40007ffe0ffULL, 0xfffffff818187812ULL, 0x000fe400078ee203ULL,
0xfffffff8171a7812ULL, 0x000fe200078ee202ULL, 0x0000080000027824ULL, 0x000fe200078e00ffULL,
0xfffffff81b1e7812ULL, 0x000fe200078ee214ULL, 0x0000000819147824ULL, 0x040fe200078e00ffULL,
0x0000000419037810ULL, 0x040fe40007ffe0ffULL, 0x0000000619157810ULL, 0x040fe40007ffe0ffULL,
0x0000000319207819ULL, 0x000fc400000006ffULL, 0xfffffff81c1c7812ULL, 0x000fe400078ee203ULL,
0x0000000827247811ULL, 0x000fe400078ff0ffULL, 0xfffffff814147812ULL, 0x000fe400078ee219ULL,
0x0000a00002037810ULL, 0x000fe40007ffe0ffULL, 0x000000101104723eULL, 0x000fe400000010ffULL,
0xfffffff820207812ULL, 0x000fe200078ee215ULL, 0x0000001014147824ULL, 0x100fe200078e0203ULL,
0x000000222310723eULL, 0x000fe200000010ffULL, 0x0000000819227824ULL, 0x000fe200078e00ffULL,
0x0000000227157819ULL, 0x000fe200000006ffULL, 0x0000001016167824ULL, 0x100fe200078e0203ULL,
0xffffffff19177810ULL, 0x000fe20007ffe0ffULL, 0x0000000824197824ULL, 0x000fe200078e00ffULL,
0x0000000c15157812ULL, 0x000fe200078ec0ffULL, 0x0000001018187824ULL, 0x000fe200078e0203ULL,
0xfffffff822227812ULL, 0x000fe200078ee217ULL, 0x000000101a1a7824ULL, 0x100fe200078e0203ULL,
0xfffffff819247812ULL, 0x000fe200078ee224ULL, 0x000000101e1e7824ULL, 0x100fe200078e0203ULL,
0x000000031c1c7211ULL, 0x000fe200078e20ffULL, 0x0000000115167824ULL, 0x000fe200078e0216ULL,
0x0000001514177210ULL, 0x000fe20007ffe0ffULL, 0x0000001020207824ULL, 0x100fe200078e0203ULL,
0x000000484909723eULL, 0x000fe200000010ffULL, 0x0000000115197824ULL, 0x040fe200078e0218ULL,
0x0000001e151e7210ULL, 0x040fe20007ffe0ffULL, 0x0000001022227824ULL, 0x100fe200078e0203ULL,
0x0000000417007388ULL, 0x0005e20000000800ULL, 0x00000001151a7824ULL, 0x000fe200078e021aULL,
0x00000044450a723eULL, 0x000fe200000010ffULL, 0x0000001024247824ULL, 0x000fe200078e0203ULL,
0x0000000516007388ULL, 0x0005e20000000800ULL, 0x00000001151b7824ULL, 0x000fe200078e021cULL,
0x000000011f00780cULL, 0x000fe20003f05270ULL, 0x00000001151d7824ULL, 0x040fe200078e0220ULL,
0x0000000619007388ULL, 0x0005e20000000800ULL, 0x0000000115227824ULL, 0x000fe200078e0222ULL,
0x0000004a4b11723eULL, 0x000fe200000010ffULL, 0x0000000115157824ULL, 0x000fe200078e0224ULL,
0x000000071a007388ULL, 0x0005e20000000800ULL, 0x000000464712723eULL, 0x000fc600000010ffULL,
0x000000081b007388ULL, 0x0005e80000000800ULL, 0x000000091e007388ULL, 0x0005e80000000800ULL,
0x0000000a1d007388ULL, 0x0005e80000000800ULL, 0x0000000b22007388ULL, 0x0005e80000000800ULL,
0x0000000c15007388ULL, 0x0005e80000000800ULL, 0x0004000d16007388ULL, 0x0005e80000000800ULL,
0x0004000e19007388ULL, 0x0005e80000000800ULL, 0x0004000f1a007388ULL, 0x0005e80000000800ULL,
0x000400101b007388ULL, 0x0005e80000000800ULL, 0x000400111e007388ULL, 0x0005e80000000800ULL,
0x000400121d007388ULL, 0x0005e80000000800ULL, 0x0004001322007388ULL, 0x0005e20000000800ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000270000008947ULL, 0x000fea0003800000ULL,
0x0000580000047a02ULL, 0x004fe20000000f00ULL, 0x0000000000067919ULL, 0x000ea80000002700ULL,
0x00000000000b7919ULL, 0x000ea20000002600ULL, 0x0000640004047a24ULL, 0x000fc600078e02ffULL,
0x0000000000077919ULL, 0x000ee20000000000ULL, 0x0000030004097a24ULL, 0x040fe200078e02ffULL,
0x0000000f04057811ULL, 0x000fc800078e10ffULL, 0xfffffff0050e7812ULL, 0x000fca00078ec0ffULL,
0x0000008009107824ULL, 0x000fc800078e020eULL, 0x0000008009097824ULL, 0x000fe400078e0210ULL,
0x0000580006067a24ULL, 0x004fc600078e020bULL, 0x0000007f09097810ULL, 0x000fe20007ffe0ffULL,
0x0000030006117a24ULL, 0x000fc600078e02ffULL, 0xffffff80090f7812ULL, 0x000fe200078ec0ffULL,
0x0000001007087824ULL, 0x048fe200078e0202ULL, 0x0000002007097810ULL, 0x000fe20007ffe0ffULL,
0x00000001110a7824ULL, 0x000fe200078e0226ULL, 0x000068000f057a10ULL, 0x000fe40007f1e0ffULL,
0x00a0000008147984ULL, 0x000ea40000000c00ULL, 0x000000050a047211ULL, 0x000fe400078260ffULL,
0x00006900ff057a10ULL, 0x000fe200007fe4ffULL, 0x00a2000008187984ULL, 0x0006620000000c00ULL,
0x000068000e127a10ULL, 0x000fc40007f1e0ffULL, 0x000000050a057211ULL, 0x000fe400008f64ffULL,
0x000000ff0000720cULL, 0x040fe20003f25270ULL, 0x00006900ff1c7624ULL, 0x000fe400000e06ffULL,
0x0000040000047825ULL, 0x000fcc00078e0004ULL, 0x0000001009087825ULL, 0x008fc800078e0004ULL,
0x0000001007047825ULL, 0x000fe200078e0004ULL, 0x0000011000001947ULL, 0x000fea0003800000ULL,
0x00000000000c7919ULL, 0x000ee20000000000ULL, 0x000000800a0b7824ULL, 0x000fe400078e00ffULL,
0x000000100c0d7824ULL, 0x008fe200078e00ffULL, 0x00000001ff1d7819ULL, 0x000fe4000001160cULL,
0x000068000b0c7a10ULL, 0x000fe40007b5e010ULL, 0x000000700d137812ULL, 0x000fe400078ec0ffULL,
0x00000019ff0d7819ULL, 0x000fc4000001160aULL, 0x0000000c1d0a7812ULL, 0x000fe400078ec0ffULL,
0x00000012130b7210ULL, 0x000fe4000791e00bULL, 0x000069000d1d7a10ULL, 0x000fe400017e64ffULL,
0x0000000c0a0c7210ULL, 0x040fe40007c7e013ULL, 0x0000000b0a0a7210ULL, 0x000fe40007f5e0ffULL,
0x0000001cff0b7210ULL, 0x000fc400007e240dULL, 0x0000001dff0d7210ULL, 0x000fc60001fe84ffULL,
0x000000ffff0b7224ULL, 0x000fca00010e060bULL, 0x000000580a007986ULL, 0x0007e8000c101906ULL,
0x000000410c007986ULL, 0x0007e4000c101906ULL, 0x000000ff0700720cULL, 0x000fe20003f05270ULL,
0x0000001404007986ULL, 0x004fe2000c101d06ULL, 0x0000016000007945ULL, 0x000fe40003800000ULL,
0x000000ff0000720cULL, 0x000fe20000705670ULL, 0x0000001808007986ULL, 0x002fe8000c101d06ULL,
0x0000000000007b1dULL, 0x000ff00000000000ULL, 0x0000011000000947ULL, 0x000fea0003800000ULL,
0x0000000400057802ULL, 0x000fe40000000f00ULL, 0xffffffff1f097810ULL, 0x000fc60007ffe0ffULL,
0x0000680006047625ULL, 0x000fe200078e0005ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000009040479a8ULL, 0x000ea400099ee1c6ULL, 0x000000090400720cULL, 0x004fc80003f05270ULL,
0x00000001ff067807ULL, 0x000fe20000000000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000006ff007388ULL, 0x0003e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000ff047984ULL, 0x000ea40000000000ULL,
0x000000ff0400720cULL, 0x004fda0003f05270ULL, 0x0000224000008947ULL, 0x000fea0003800000ULL,
0x000000ff0000720cULL, 0x000fda0003f05270ULL, 0x00000a5000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x000001b000008947ULL, 0x000fea0003800000ULL,
0x0000001007057824ULL, 0x000fe200078e00ffULL, 0x00000001ff067819ULL, 0x002fe40000011607ULL,
0x0000001211047211ULL, 0x000fe400078038ffULL, 0x0000007005097812ULL, 0x000fe400078ec0ffULL,
0x0000000c06067812ULL, 0x000fe400078ec0ffULL, 0x0000001c11057211ULL, 0x000fe400000f3cffULL,
0x0000000406047210ULL, 0x000fc8000791e009ULL, 0x00000005ff057210ULL, 0x000fca00007e24ffULL,
0x0000000604067981ULL, 0x000328000c1e1900ULL, 0x0000800604097981ULL, 0x000322000c1e1900ULL,
0x000000021f00780cULL, 0x000fda0003f05270ULL, 0x000000f000008947ULL, 0x000fea0003800000ULL,
0x00010006040b7981ULL, 0x00a322000c1e1900ULL, 0x000000041f00780cULL, 0x000fda0003f06070ULL,
0x000000c000008947ULL, 0x000fea0003800000ULL, 0x00018006040d7981ULL, 0x002322000c1e1900ULL,
0x000000041f00780cULL, 0x000fda0003f05270ULL, 0x0000009000008947ULL, 0x000fea0003800000ULL,
0x0002000604137981ULL, 0x002322000c1e1900ULL, 0x000000061f00780cULL, 0x000fda0003f06070ULL,
0x0000006000008947ULL, 0x000fea0003800000ULL, 0x0002800604157981ULL, 0x002322000c1e1900ULL,
0x000000061f00780cULL, 0x000fda0003f05270ULL, 0x0000003000008947ULL, 0x000fea0003800000ULL,
0x000000081f00780cULL, 0x002fe20003f06070ULL, 0x0003000604177981ULL, 0x000318000c1e1900ULL,
0x0003800604190981ULL, 0x000324000c1e1900ULL, 0x000000071f047810ULL, 0x002fc80007ffe0ffULL,
0x00000003ff087819ULL, 0x000fc80000011604ULL, 0x000000ff0800720cULL, 0x000fda0003f05270ULL,
0x000007d000008947ULL, 0x000fea0003800000ULL, 0x0000000e111d7211ULL, 0x000fe200078038ffULL,
0x000000ffff0c7224ULL, 0x008fe200078e00ffULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0x000000ffff1b7224ULL, 0x010fe200078e0006ULL, 0x000068001d1d7a10ULL, 0x000fe40007f3e0ffULL,
0x000000ff110a7211ULL, 0x000fe400000f3cffULL, 0x000007801d1d7810ULL, 0x000fc80007f5e0ffULL,
0x00006900ff0a7a10ULL, 0x000fc400017e240aULL, 0x000003000c007a0cULL, 0x000fe20003f26070ULL,
0x0000000104047890ULL, 0x000fcc000fffe03fULL, 0x0000000408007c0cULL, 0x000fcc000bf03070ULL,
0x000006d000001947ULL, 0x012fea0003800000ULL, 0x000000080c047810ULL, 0x040fe40007ffe0ffULL,
0x000000010c057810ULL, 0x000fe40007ffe0ffULL, 0x0000030004007a0cULL, 0x000fe40003f26070ULL,
0x0000030005007a0cULL, 0x000fe40003f46070ULL, 0x0000001b06067209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001007047824ULL, 0x000fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011607ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x000000041d047210ULL, 0x000fc80007f3e0ffULL,
0x0000000aff057210ULL, 0x000fca0000ffe4ffULL, 0xfffc8006041b7981ULL, 0x000328000c1e1900ULL,
0x000005f000002947ULL, 0x000fea0003800000ULL, 0x000000090c047810ULL, 0x042fe40007ffe0ffULL,
0x000000020c057810ULL, 0x000fe40007ffe0ffULL, 0x0000030004007a0cULL, 0x000fe40003f26070ULL,
0x0000030005007a0cULL, 0x000fe40003f46070ULL, 0x0000000906067209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001007047824ULL, 0x000fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011607ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x000000041d047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e060aULL, 0xfffd000604097981ULL, 0x000326000c1e1900ULL,
0x0000051000002947ULL, 0x000fea0003800000ULL, 0x0000000a0c047810ULL, 0x042fe40007ffe0ffULL,
0x000000030c057810ULL, 0x000fe40007ffe0ffULL, 0x0000030004007a0cULL, 0x000fe40003f26070ULL,
0x0000030005007a0cULL, 0x000fe40003f46070ULL, 0x0000000b06067209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001007047824ULL, 0x000fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011607ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x000000041d047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e060aULL, 0xfffd8006040b7981ULL, 0x000326000c1e1900ULL,
0x0000043000002947ULL, 0x000fea0003800000ULL, 0x0000000b0c047810ULL, 0x042fe40007ffe0ffULL,
0x000000040c057810ULL, 0x000fe40007ffe0ffULL, 0x0000030004007a0cULL, 0x000fe40003f26070ULL,
0x0000030005007a0cULL, 0x000fe40003f46070ULL, 0x0000000d06067209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000000407047819ULL, 0x000fe400000006ffULL,
0x00000001ff057819ULL, 0x000fe40000011607ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x000000041d047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e060aULL, 0xfffe0006040d7981ULL, 0x000326000c1e1900ULL,
0x0000035000002947ULL, 0x000fea0003800000ULL, 0x0000000c0c047810ULL, 0x042fe40007ffe0ffULL,
0x000000050c057810ULL, 0x000fe40007ffe0ffULL, 0x0000030004007a0cULL, 0x000fe40003f26070ULL,
0x0000030005007a0cULL, 0x000fe40003f46070ULL, 0x0000001306067209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001007047824ULL, 0x000fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011607ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x000000041d047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e060aULL, 0xfffe800604137981ULL, 0x000326000c1e1900ULL,
0x0000027000002947ULL, 0x000fea0003800000ULL, 0x0000000d0c047810ULL, 0x042fe40007ffe0ffULL,
0x000000060c057810ULL, 0x000fe40007ffe0ffULL, 0x0000030004007a0cULL, 0x000fe40003f26070ULL,
0x0000030005007a0cULL, 0x000fe40003f46070ULL, 0x0000001506067209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001007047824ULL, 0x000fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011607ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x000000041d047210ULL, 0x000fc80007f3e0ffULL,
0x0000000aff057210ULL, 0x000fca0000ffe4ffULL, 0xffff000604157981ULL, 0x000328000c1e1900ULL,
0x0000019000002947ULL, 0x000fea0003800000ULL, 0x0000000e0c047810ULL, 0x042fe40007ffe0ffULL,
0x000000070c057810ULL, 0x000fe40007ffe0ffULL, 0x0000030004007a0cULL, 0x000fe40003f26070ULL,
0x0000030005007a0cULL, 0x000fe40003f46070ULL, 0x0000001706067209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001007047824ULL, 0x000fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011607ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x000000041d047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e060aULL, 0xffff800604177981ULL, 0x000326000c1e1900ULL,
0x000000b000002947ULL, 0x000fea0003800000ULL, 0x0000000f0c047810ULL, 0x002fe40007ffe0ffULL,
0x0000001906067209ULL, 0x000fe40007810000ULL, 0x0000030004007a0cULL, 0x000fda0003f26070ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001007047824ULL, 0x000fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011607ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x000000041d047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e060aULL, 0x0000000604197981ULL, 0x000326000c1e1900ULL,
0x000004001d1d7810ULL, 0x000fe40007f3e0ffULL, 0x000000080c0c7810ULL, 0x000fe40007ffe0ffULL,
0x0000000aff0a7210ULL, 0x000fe20000ffe4ffULL, 0xfffff8b000008947ULL, 0x000fea000383ffffULL,
0x0000000000077919ULL, 0x000ea40000000000ULL, 0x0000001007047824ULL, 0x006fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011607ULL, 0x0000007004047812ULL, 0x000fe400078ec0ffULL,
0x0000000c05057812ULL, 0x000fca00078ec0ffULL, 0x0000000104057824ULL, 0x000fca00078e0205ULL,
0x0000000605007388ULL, 0x0103e40000000800ULL, 0x000068000f047a10ULL, 0x000fe20007f1e0ffULL,
0x0000001007067824ULL, 0x042fe200078e00ffULL, 0x0000000a003d7819ULL, 0x040fe200000006ffULL,
0x0000100000127824ULL, 0x000fe200078e00ffULL, 0x00000016ff3f7819ULL, 0x000fe20000011600ULL,
0x00006900ff057624ULL, 0x000fe200000e06ffULL, 0x000000070700780cULL, 0x040fe20003f04070ULL,
0x0000001007137824ULL, 0x000fe200078e0212ULL, 0x00000001ff0a7819ULL, 0x008fe20000011607ULL,
0x0000100011087825ULL, 0x000fe200078e0004ULL, 0x0000007006067812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000003d08087210ULL, 0x000fe20007f3e0ffULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000000c0a0b7812ULL, 0x000fe200078ec0ffULL,
0x0000001000158824ULL, 0x000fe200078e0207ULL, 0x000068000e447a10ULL, 0x000fe20007f5e0ffULL,
0x0000000109097824ULL, 0x000fe200008e063fULL, 0x00006800103e7a10ULL, 0x000fe20007f3e0ffULL,
0x0000000106067824ULL, 0x000fe200078e020bULL, 0x00000020070b7810ULL, 0x000fe20007ffe0ffULL,
0x00006900ff467624ULL, 0x000fe200010e06ffULL, 0x00006900ff407a10ULL, 0x000fe20000ffe4ffULL,
0x0000001000178824ULL, 0x000fe200078e0207ULL, 0x0000003e110c8211ULL, 0x000fe200078238ffULL,
0x000000100b0a7825ULL, 0x100fe200078e0008ULL, 0x00000044110e8211ULL, 0x040fe200078438ffULL,
0x0000000006067984ULL, 0x000e620000000800ULL, 0x00000040110d8211ULL, 0x000fe200008f3cffULL,
0x0000001007087825ULL, 0x000fe200078e0008ULL, 0x00000300ff007a0cULL, 0x000fe20003f25270ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x00000046110f8211ULL, 0x000fe200010f3cffULL,
0x00000010070c8825ULL, 0x000fe200078e000cULL, 0x0000458015158811ULL, 0x000fe200078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000008137faeULL, 0x0005e2000b901c46ULL,
0x0000418017178811ULL, 0x000fe200078e20ffULL, 0x00000010070e8825ULL, 0x000fe200078e000eULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x003800000a137faeULL, 0x0005e2000b901c46ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff107224ULL, 0x000fe200078e00ffULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x000000000c158faeULL, 0x0007e2000b901c46ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x000000000e178faeULL, 0x0009e2000b901c46ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000ff00137202ULL, 0x004fe20000000f00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x008fe2000001ff00ULL,
0x000000ffff327224ULL, 0x000fe200078e00ffULL, 0x0000000000167805ULL, 0x010fe2000001ff00ULL,
0x00000bc000009947ULL, 0x000fea0003800000ULL, 0x0000000111117810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff107224ULL, 0x000fc400078e00ffULL, 0x00000001ff437424ULL, 0x000fca00078e00ffULL,
0x0000030043007a0cULL, 0x000fda0003f06070ULL, 0x000001f000000947ULL, 0x000fea0003800000ULL,
0x000000070700780cULL, 0x000fe20003f44070ULL, 0x0000100011087825ULL, 0x000fe200078e0004ULL,
0x00000001430d7812ULL, 0x000fe400078ec0ffULL, 0x0000002007397810ULL, 0x000fe20007ffe0ffULL,
0x00000800430a7824ULL, 0x000fe200078e00ffULL, 0x0000003d08087210ULL, 0x000fc80007f1e0ffULL,
0x000008000a0b7812ULL, 0x000fe400078ec0ffULL, 0x0000003f09097210ULL, 0x000fe200007fe4ffULL,
0x000000020034a824ULL, 0x140fe200078e020dULL, 0x0000003e110ca211ULL, 0x040fe200078038ffULL,
0x000000020036a824ULL, 0x000fe200078e020dULL, 0x00000044110ea211ULL, 0x040fe200078238ffULL,
0x00000001120a7824ULL, 0x000fe200078e020bULL, 0x00000040110da211ULL, 0x040fe200000f3cffULL,
0x000000083434a824ULL, 0x000fe200078e0207ULL, 0x00000046110fa211ULL, 0x000fe200008f3cffULL,
0x0000001007337824ULL, 0x000fe200078e020aULL, 0x000000073636a211ULL, 0x000fe200078e18ffULL,
0x00000010390a7825ULL, 0x000fe200078e0008ULL, 0x000045803435a811ULL, 0x000fc400078e20ffULL,
0x000041803637a811ULL, 0x000fe200078e20ffULL, 0x0000001007087825ULL, 0x000fc800078e0008ULL,
0x00000010070ca825ULL, 0x040fe200078e000cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000008337faeULL, 0x0005e6000b901c46ULL, 0x00000010070ea825ULL, 0x000fe200078e000eULL,
0x003800000a337faeULL, 0x0005e8000b901c46ULL, 0x000000000c35afaeULL, 0x0005e8000b901c46ULL,
0x000000000e37afaeULL, 0x0005e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffff43087810ULL, 0x004fe20007ffe0ffULL, 0x00000010070a7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0b7819ULL, 0x000fc40000011607ULL, 0x00000002ff3c7819ULL, 0x000fe20000011607ULL,
0x0000008008097824ULL, 0x000fe200078e00ffULL, 0x000000700a0a7812ULL, 0x000fe200078ec0ffULL,
0x0000080008087824ULL, 0x000fe200078e00ffULL, 0x0000000c0b0b7812ULL, 0x000fe200078ec0ffULL,
0x000000083c387824ULL, 0x040fe200078e00ffULL, 0x0000008009097812ULL, 0x000fe200078ec0ffULL,
0x000000083c4a7824ULL, 0x040fe200078e00ffULL, 0x000000033c0d7819ULL, 0x040fe200000006ffULL,
0x000000083c377824ULL, 0x040fe200078e00ffULL, 0x000000083c507810ULL, 0x000fe20007ffe0ffULL,
0x0000010000097824ULL, 0x000fe200078e0209ULL, 0x000000013c0c7810ULL, 0x000fc40007ffe0ffULL,
0x000000043c337810ULL, 0x000fe20007ffe0ffULL, 0x00000008500f7824ULL, 0x000fe200078e00ffULL,
0x000000090b0a7210ULL, 0x000fe20007ffe00aULL, 0x0000000407097824ULL, 0x000fe200078e00ffULL,
0xfffffff80d367812ULL, 0x000fe200078ee20cULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x004180000a0b7984ULL, 0x000ea20000000800ULL, 0x0000000c09417812ULL, 0x000fe400078ec0ffULL,
0x0000080008097812ULL, 0x000fe200078ec0ffULL, 0x004580000a0e7984ULL, 0x0007e20000000800ULL,
0xfffffff80d087812ULL, 0x000fe400078ee23cULL, 0x0000018012097810ULL, 0x000fe40007ffe009ULL,
0x000000023c0c7810ULL, 0x040fe40007ffe0ffULL, 0x000000033c487819ULL, 0x000fe200000006ffULL,
0x0000001008087824ULL, 0x000fe200078e0209ULL, 0xfffffff80f0a7812ULL, 0x008fc400078ee250ULL,
0xfffffff80d3a7812ULL, 0x000fe200078ee20cULL, 0x0000000141087824ULL, 0x040fe200078e0208ULL,
0x000000090a0a7211ULL, 0x000fe400078e20ffULL, 0x000000033c0f7810ULL, 0x000fe40007ffe0ffULL,
0x0000000008347984ULL, 0x0007220000000800ULL, 0x00000001410c7824ULL, 0x000fe200078e020aULL,
0xfffffff848487812ULL, 0x000fe200078ee233ULL, 0x00000010360a7824ULL, 0x000fe200078e0209ULL,
0xfffffff838367812ULL, 0x000fc400078ee20fULL, 0x000000000c387984ULL, 0x0003e20000000800ULL,
0x00000001410a7824ULL, 0x040fe200078e020aULL, 0x000000053c337810ULL, 0x000fe20007ffe0ffULL,
0x0000001036087824ULL, 0x008fe200078e0209ULL, 0x000000033c4c7819ULL, 0x000fe400000006ffULL,
0x000000000a357984ULL, 0x000fe20000000800ULL, 0xfffffff84a4a7812ULL, 0x000fe200078ee233ULL,
0x0000000141087824ULL, 0x000fe200078e0208ULL, 0xffffffff3c0c7810ULL, 0x002fe20007ffe0ffULL,
0x000400000a397984ULL, 0x0003e20000000800ULL, 0x0000030043007a0cULL, 0x000fe20003f06070ULL,
0x0000000b060b7221ULL, 0x004fe20000010100ULL, 0xfffffff8374e7812ULL, 0x000fe200078ee20cULL,
0x00040000083b7984ULL, 0x000fe20000000800ULL, 0x000000094a0c7211ULL, 0x000fe200078e20ffULL,
0x3fb8aa3b0b0b7820ULL, 0x000fe20000410000ULL, 0x00000010480a7824ULL, 0x002fe200078e0209ULL,
0x0000000008377984ULL, 0x0009e20000000800ULL, 0x0000000111117810ULL, 0x000fe20007ffe0ffULL,
0x0000000b000d7308ULL, 0x0002a20000000800ULL, 0x00000001410a7824ULL, 0x000fe200078e020aULL,
0x0000000143437810ULL, 0x000fe20007ffe0ffULL, 0x00000001410c7824ULL, 0x000fc400078e020cULL,
0x000000103a0b7824ULL, 0x002fc800078e0209ULL, 0x00000001410b7824ULL, 0x000fe200078e020bULL,
0x00005410ff087816ULL, 0x010fe20000000034ULL, 0x0000000e0d0f7220ULL, 0x004fe20000410000ULL,
0x000000063c0d7810ULL, 0x000fe40007ffe0ffULL, 0x000000000b367984ULL, 0x000fe20000000800ULL,
0x000000320f327221ULL, 0x000fe20000010000ULL, 0xfffffff84c4c7812ULL, 0x000fe400078ee20dULL,
0x00001f3c0f0e7589ULL, 0x000e6800000e0000ULL, 0x00001f500f337589ULL, 0x000ea200000e0000ULL,
0x000000104c0d7824ULL, 0x000fc400078e0209ULL, 0x000000104e097824ULL, 0x000fe200078e0209ULL,
0x000400000b3a7984ULL, 0x0007240000000800ULL, 0x0000000d410d7210ULL, 0x040fe20007ffe0ffULL,
0x0000000141097824ULL, 0x000fe200078e0209ULL, 0x000000000a0f7984ULL, 0x000f220000000800ULL,
0x00007610ff0b7816ULL, 0x008fc60000000034ULL, 0x000400000a3c7984ULL, 0x000ee80000000800ULL,
0x000000000c347984ULL, 0x000ee20000000800ULL, 0x0000000e0b307223ULL, 0x082fe20000010030ULL,
0x0000000e08317223ULL, 0x000fe20000010031ULL, 0x00007610ff0b7816ULL, 0x100fe20000000038ULL,
0x000000000d0a7984ULL, 0x000fe20000000800ULL, 0x00005410ff087816ULL, 0x000fc60000000038ULL,
0x000000330b2e7223ULL, 0x084fe2000001002eULL, 0x00007610ff0b7816ULL, 0x000fe20000000035ULL,
0x00000033082f7223ULL, 0x080fe2000001002fULL, 0x00005410ff087816ULL, 0x000fe20000000035ULL,
0x000400000c387984ULL, 0x000e640000000800ULL, 0x0000000e0b2c7223ULL, 0x080fe2000001002cULL,
0x00007610ff0b7816ULL, 0x000fe20000000039ULL, 0x0000000e082d7223ULL, 0x080fe2000001002dULL,
0x00005410ff087816ULL, 0x000fe20000000039ULL, 0x000400000d357984ULL, 0x000ea40000000800ULL,
0x000000330b2a7223ULL, 0x080fe2000001002aULL, 0x00007610ff0b7816ULL, 0x100fe20000000036ULL,
0x00000033082b7223ULL, 0x000fe2000001002bULL, 0x00005410ff087816ULL, 0x000fe20000000036ULL,
0x00000000090c7984ULL, 0x000e640000000800ULL, 0x0000000e0b287223ULL, 0x000fc40000010028ULL,
0x0000000e08297223ULL, 0x000fe20000010029ULL, 0x00040000090b7984ULL, 0x0006a20000000800ULL,
0x00005410ff087816ULL, 0x010fca000000003aULL, 0x0000003308277223ULL, 0x000fe20000010027ULL,
0x00005410ff087816ULL, 0x000fe40000000037ULL, 0x00007610ff097816ULL, 0x008fc6000000003aULL,
0x0000000e08257223ULL, 0x000fe20000010025ULL, 0x00005410ff087816ULL, 0x000fe2000000003bULL,
0x0000003309267223ULL, 0x000fe20000010026ULL, 0x00007610ff097816ULL, 0x000fc60000000037ULL,
0x0000003308237223ULL, 0x000fe20000010023ULL, 0x00005410ff087816ULL, 0x000fe2000000000fULL,
0x0000000e09247223ULL, 0x000fe20000010024ULL, 0x00007610ff097816ULL, 0x000fc6000000003bULL,
0x0000000e08217223ULL, 0x000fe20000010021ULL, 0x00005410ff087816ULL, 0x000fe2000000003cULL,
0x0000003309227223ULL, 0x000fe20000010022ULL, 0x00007610ff097816ULL, 0x000fc6000000000fULL,
0x00000033081f7223ULL, 0x000fe2000001001fULL, 0x00005410ff087816ULL, 0x000fe20000000034ULL,
0x0000000e09207223ULL, 0x000fe20000010020ULL, 0x00007610ff097816ULL, 0x000fc6000000003cULL,
0x0000000e08177223ULL, 0x000fe20000010017ULL, 0x00007610ff087816ULL, 0x000fe20000000034ULL,
0x00000033091e7223ULL, 0x000fe2000001001eULL, 0x00005410ff097816ULL, 0x002fc60000000038ULL,
0x0000000e081d7223ULL, 0x000fe2000001001dULL, 0x00007610ff087816ULL, 0x000fe20000000038ULL,
0x00000033091c7223ULL, 0x000fe2000001001cULL, 0x00005410ff097816ULL, 0x004fc60000000035ULL,
0x0000003308157223ULL, 0x080fe20000010015ULL, 0x00005410ff087816ULL, 0x000fe2000000000aULL,
0x00000033091a7223ULL, 0x000fe2000001001aULL, 0x00005410ff097816ULL, 0x000fc6000000000cULL,
0x0000000e08137223ULL, 0x080fe20000010013ULL, 0x00007610ff087816ULL, 0x000fe2000000000aULL,
0x0000000e09187223ULL, 0x000fe20000010018ULL, 0x00007610ff097816ULL, 0x000fc6000000000cULL,
0x0000000e081b7223ULL, 0x080fe2000001001bULL, 0x00007610ff087816ULL, 0x000fe20000000035ULL,
0x0000000e09167223ULL, 0x000fe20000010016ULL, 0x00005410ff097816ULL, 0x000fc6000000000bULL,
0x0000003308197223ULL, 0x080fe40000010019ULL, 0x0000003309147223ULL, 0x000fe20000010014ULL,
0x00007610ff097816ULL, 0x000fca000000000bULL, 0x0000003309107223ULL, 0x000fe20000010010ULL,
0xfffff47000008947ULL, 0x000fea000383ffffULL, 0x0180000032007810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x7f80000000007812ULL, 0x000fe200078ec0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x0000d35000067802ULL, 0x002fc40000000f00ULL,
0x00009ee000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff007224ULL, 0x000fe200078e0007ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000003200057308ULL, 0x000ea40000001000ULL,
0xbf80000005007423ULL, 0x004fc80000000032ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000005007223ULL, 0x000fc40000000005ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000087919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000002ff097819ULL, 0x004fc40000011608ULL, 0x00000008080b7811ULL, 0x040fe200078ff0ffULL,
0x0000000408087824ULL, 0x000fe200078e00ffULL, 0x00000003090d7810ULL, 0x040fe20007ffe0ffULL,
0x00001f0900047589ULL, 0x000ea200000e0000ULL, 0x0000000809117824ULL, 0x040fe200078e00ffULL,
0x00000003090e7819ULL, 0x040fe200000006ffULL, 0x0000000809127824ULL, 0x040fe200078e00ffULL,
0x00001f0b00077589ULL, 0x00072200000e0000ULL, 0x00000004090f7810ULL, 0x000fe20007ffe0ffULL,
0x000000080b347824ULL, 0x000fe200078e00ffULL, 0x00000002090c7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff80e0e7812ULL, 0x000fe400078ee20dULL, 0x00000005090d7810ULL, 0x040fe40007ffe0ffULL,
0x0000000309327819ULL, 0x002fe200000006ffULL, 0x000000100e0e7824ULL, 0x000fe200078e0203ULL,
0xfffffff812127812ULL, 0x000fe400078ee20dULL, 0xfffffff834347812ULL, 0x000fc600078ee20bULL,
0x0000001012127824ULL, 0x100fe400078e0203ULL, 0x0000001034347824ULL, 0x000fe200078e0203ULL,
0x0000003104317220ULL, 0x044fe20000410000ULL, 0x0000003004307220ULL, 0x040fe20000410000ULL,
0x0000002d042d7220ULL, 0x040fe20000410000ULL, 0x0000002c042c7220ULL, 0x040fe20000410000ULL,
0x0000002904297220ULL, 0x040fe20000410000ULL, 0x0000002804287220ULL, 0x040fe20000410000ULL,
0x0000002504257220ULL, 0x040fe20000410000ULL, 0x0000002404247220ULL, 0x040fe20000410000ULL,
0x0000002104217220ULL, 0x040fe20000410000ULL, 0x0000002004207220ULL, 0x040fe20000410000ULL,
0x0000001704177220ULL, 0x040fe20000410000ULL, 0x0000001d04007220ULL, 0x048fe20000410000ULL,
0x0000001304137220ULL, 0x040fe20000410000ULL, 0x0000001b04067220ULL, 0x040fe20000410000ULL,
0x0000001804187220ULL, 0x040fe20000410000ULL, 0x0000001604057220ULL, 0x000fe20000410000ULL,
0x0000000109047810ULL, 0x000fe20007ffe0ffULL, 0x0000002f072f7220ULL, 0x050fe20000410000ULL,
0x0000002e072e7220ULL, 0x040fe20000410000ULL, 0x0000002b072b7220ULL, 0x040fe20000410000ULL,
0x0000002a072a7220ULL, 0x040fe20000410000ULL, 0x0000002707277220ULL, 0x040fe20000410000ULL,
0x0000002607267220ULL, 0x040fe20000410000ULL, 0x0000002307237220ULL, 0x040fe20000410000ULL,
0x0000002207227220ULL, 0x040fe20000410000ULL, 0x0000001f071f7220ULL, 0x040fe20000410000ULL,
0x0000001e071e7220ULL, 0x040fe20000410000ULL, 0x0000001c071c7220ULL, 0x040fe20000410000ULL,
0x0000001507157220ULL, 0x040fe20000410000ULL, 0x0000001a071a7220ULL, 0x040fe20000410000ULL,
0x0000001907197220ULL, 0x040fe20000410000ULL, 0x0000001407147220ULL, 0x040fe20000410000ULL,
0x0000001007077220ULL, 0x000fe20000410000ULL, 0x0000000809107824ULL, 0x000fe200078e00ffULL,
0xfffffff8110a7812ULL, 0x000fe200078ee204ULL, 0x0000000809047824ULL, 0x040fe200078e00ffULL,
0xffffffff09117810ULL, 0x040fe20007ffe0ffULL, 0x00000008091b7824ULL, 0x040fe200078e00ffULL,
0xfffffff810107812ULL, 0x000fe200078ee20fULL, 0x0000000809167824ULL, 0x040fe200078e00ffULL,
0x00000006090f7810ULL, 0x000fe20007ffe0ffULL, 0x000000100a0a7824ULL, 0x000fe200078e0203ULL,
0xfffffff804047812ULL, 0x000fe200078ee209ULL, 0x0000001010107824ULL, 0x000fe200078e0203ULL,
0xfffffff81b0c7812ULL, 0x000fc400078ee20cULL, 0xfffffff816167812ULL, 0x000fe200078ee20fULL,
0x0000001004047824ULL, 0x000fe200078e0203ULL, 0xfffffff832327812ULL, 0x000fe400078ee211ULL,
0x0000000c08097812ULL, 0x000fe200078ec0ffULL, 0x0000001016167824ULL, 0x000fe200078e0203ULL,
0x000000030c0c7211ULL, 0x080fe400078e20ffULL, 0x0000000332327211ULL, 0x000fe200078e20ffULL,
0x0000000104037824ULL, 0x000fe200078e0209ULL, 0x000000313030723eULL, 0x000fe200000010ffULL,
0x00000001090b7824ULL, 0x040fe200078e020aULL, 0x0000002d2c2c723eULL, 0x000fe200000010ffULL,
0x00000001090d7824ULL, 0x040fe200078e020cULL, 0x000000292828723eULL, 0x000fe200000010ffULL,
0x0000000109117824ULL, 0x040fe200078e0210ULL, 0x000000252424723eULL, 0x000fe200000010ffULL,
0x0000000109127824ULL, 0x040fe200078e0212ULL, 0x0000000e090f7210ULL, 0x040fe20007ffe0ffULL,
0x0000003003007388ULL, 0x0003e20000000800ULL, 0x000000212020723eULL, 0x000fe200000010ffULL,
0x0000000109167824ULL, 0x040fe200078e0216ULL, 0x000000170000723eULL, 0x000fe200000010ffULL,
0x0000002c0b007388ULL, 0x0003e20000000800ULL, 0x000000130606723eULL, 0x000fe200000010ffULL,
0x0000000109327824ULL, 0x000fe200078e0232ULL, 0x000000180505723eULL, 0x000fe200000010ffULL,
0x000000280d007388ULL, 0x0003e20000000800ULL, 0x0000002f2e2e723eULL, 0x000fc400000010ffULL,
0x0000003409097210ULL, 0x000fe20007ffe0ffULL, 0x000000240f007388ULL, 0x0003e20000000800ULL,
0x0000002b2a2a723eULL, 0x000fe400000010ffULL, 0x000000272626723eULL, 0x000fe200000010ffULL,
0x0000002011007388ULL, 0x0003e20000000800ULL, 0x000000232222723eULL, 0x000fe400000010ffULL,
0x0000001f1e1e723eULL, 0x000fe200000010ffULL, 0x0000000012007388ULL, 0x0003e20000000800ULL,
0x0000001c1515723eULL, 0x000fc400000010ffULL, 0x0000001a1919723eULL, 0x000fe200000010ffULL,
0x0000000616007388ULL, 0x0003e20000000800ULL, 0x000000140707723eULL, 0x000fc600000010ffULL,
0x0000000532007388ULL, 0x0003e80000000800ULL, 0x0000002e09007388ULL, 0x0003e80000000800ULL,
0x0004002a0b007388ULL, 0x0003e80000000800ULL, 0x000400260d007388ULL, 0x0003e80000000800ULL,
0x000400220f007388ULL, 0x0003e80000000800ULL, 0x0004001e11007388ULL, 0x0003e80000000800ULL,
0x0004001512007388ULL, 0x0003e80000000800ULL, 0x0004001916007388ULL, 0x0003e80000000800ULL,
0x0004000732007388ULL, 0x0003e20000000800ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000000000077919ULL, 0x006e620000000000ULL, 0x00000000000579c3ULL, 0x000ea20000002700ULL,
0x0000580000047ab9ULL, 0x000fc40000000800ULL, 0x0000000000047919ULL, 0x000f220000002600ULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x00000020070d7810ULL, 0x00afc60007ffe0ffULL,
0x00000005040472a4ULL, 0x004fe2000f8e023fULL, 0x00000003ff067819ULL, 0x000fe40000011607ULL,
0x00000003ff037819ULL, 0x000fe4000001160dULL, 0x00000003040f7819ULL, 0x010fe200000006ffULL,
0x0000000106057824ULL, 0x000fe400078e0207ULL, 0x000000010d007824ULL, 0x000fe400078e0203ULL,
0x0000000804047824ULL, 0x000fe200078e00ffULL, 0x0000000705087812ULL, 0x000fc400078ec0ffULL,
0x0000000700007812ULL, 0x000fe400078ec0ffULL, 0x0ffffff808097812ULL, 0x000fe400078ef807ULL,
0x0ffffff800057812ULL, 0x000fe400078ef80dULL, 0xfffffff80f007812ULL, 0x000fe200078ee206ULL,
0x0000001009087824ULL, 0x100fe200078e0202ULL, 0xfffffff804037812ULL, 0x000fe200078ee203ULL,
0x0000001005057824ULL, 0x000fe200078e0202ULL, 0x0000000400067c10ULL, 0x000fc4000ff1e0ffULL,
0x0000000403007c10ULL, 0x000fe2000ff3e0ffULL, 0x00a0000008087984ULL, 0x000e620000000c00ULL,
0x0000000707077812ULL, 0x000fe200078ec0ffULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x00005a0006027a11ULL, 0x040fe200078048ffULL, 0x00a0000005107984ULL, 0x0004e20000000c00ULL,
0x000000070d0d7812ULL, 0x000fe400078ec0ffULL, 0x00005b0006037a11ULL, 0x000fe400000f4c03ULL,
0x1ffffff807077812ULL, 0x000fc400078ef842ULL, 0x1ffffff80d0d7812ULL, 0x000fe200078ef842ULL,
0x000000ffff057224ULL, 0x004fe200008e06ffULL, 0x00005a0000047a11ULL, 0x000fe200078248ffULL,
0x0000001007027825ULL, 0x000fc600078e0002ULL, 0x00005b0000057a11ULL, 0x000fca00008f4c05ULL,
0x000000100d047825ULL, 0x000fe200078e0004ULL, 0x0000000802007986ULL, 0x002fe8000c101d06ULL,
0x0000001004007986ULL, 0x008fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000102047810ULL, 0x000fe20007ffe0ffULL,
0x0000000243437824ULL, 0x000fe200078e00ffULL, 0x0000000600057819ULL, 0x000fe200000006ffULL,
0x01460000ff087f8cULL, 0x000e62000c80043fULL, 0x0000000d0400720cULL, 0x000fe20003f06070ULL,
0x0000580043047a24ULL, 0x000fc400078e0212ULL, 0x0000010002147824ULL, 0x000fc800078e0205ULL,
0x00006200042d7a24ULL, 0x000fcc00078e0214ULL, 0x0000059000008947ULL, 0x000fea0003800000ULL,
0x00000002ff1e7819ULL, 0x000fe4000001160cULL, 0x0000001403077217ULL, 0x000fe40007800000ULL,
0x000000081e167810ULL, 0x040fe20007ffe0ffULL, 0x000000012d0b7824ULL, 0x000fe200078e021eULL,
0x000000181e227810ULL, 0x000fe20007ffe0ffULL, 0x0000000107077824ULL, 0x000fe200078e0a14ULL,
0x0000003010237812ULL, 0x000fe200078ec0ffULL, 0x000000012d0f7824ULL, 0x040fe200078e0216ULL,
0x000000222d137210ULL, 0x000fe20007ffe0ffULL, 0x00005e000b0a7625ULL, 0x000fe200078e0006ULL,
0x000000201e1a7810ULL, 0x000fc40007ffe0ffULL, 0x000000101e207810ULL, 0x000fe20007ffe0ffULL,
0x00005e000f0e7625ULL, 0x000fe200078e0006ULL, 0x000000230a147210ULL, 0x080fe40007f1e0ffULL,
0x0000000c0c1b7211ULL, 0x000fe200078fe8ffULL, 0x00005e0013127625ULL, 0x080fe200078e0006ULL,
0x000000230e0e7210ULL, 0x080fe40007f3e0ffULL, 0x000000031b1b7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff157224ULL, 0x000fe200000e060bULL, 0x000000281e1c7810ULL, 0x000fe20007ffe0ffULL,
0x000000012d0b7824ULL, 0x000fe200078e021aULL, 0x00002000001d7811ULL, 0x000fe200078e68ffULL,
0x000000ffff0f7224ULL, 0x000fe200008e060fULL, 0x0000002312127210ULL, 0x000fe20007f3e0ffULL,
0x00005e000b0a7625ULL, 0x000fe200078e0006ULL, 0x0ffffffc1b0c7812ULL, 0x000fc400078ef80cULL,
0x000000072000720cULL, 0x080fe20003fa6070ULL, 0x000000012d117824ULL, 0x000fe200078e0220ULL,
0x000000072200720cULL, 0x080fe20003f86070ULL, 0x000000ffff137224ULL, 0x000fe200008e0613ULL,
0x000000071600720cULL, 0x040fe20003f26070ULL, 0x0000000416187824ULL, 0x000fe200078e00ffULL,
0x000000230a167210ULL, 0x000fe20007f5e0ffULL, 0x00005e0011107625ULL, 0x080fe200078e0006ULL,
0x000000071a00720cULL, 0x000fe40003f66070ULL, 0xfffffffc180a7812ULL, 0x000fe200078ee21bULL,
0x000000ffff177224ULL, 0x000fe200010e060bULL, 0x0000002310107210ULL, 0x000fe20007f1e0ffULL,
0x000000012d0b7824ULL, 0x000fe200078e021cULL, 0x0000001d0a217211ULL, 0x000fe200078e20ffULL,
0x000000100c1f7824ULL, 0x000fe200078e021dULL, 0x00000011ff117210ULL, 0x000fe200007fe4ffULL,
0x00005e000b0a7625ULL, 0x000fe200078e0006ULL, 0x000000071e00720cULL, 0x000fc40003f06070ULL,
0x000000301e0c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000420207824ULL, 0x000fe200078e00ffULL,
0x000000230a187210ULL, 0x000fe40007fde0ffULL, 0x000000381e1e7810ULL, 0x000fe40007ffe0ffULL,
0x000000071c00720cULL, 0x080fe20003f46070ULL, 0x000000ffff197224ULL, 0x000fe400030e060bULL,
0x000000012d0b7824ULL, 0x000fe400078e020cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000141f7faeULL, 0x0005e2000c101c46ULL, 0x000000071e00720cULL, 0x000fe20003f06070ULL,
0x00005e000b0a7625ULL, 0x000fc400078e0006ULL, 0x000000000e217faeULL, 0x0007e2000c901c46ULL,
0x000000070c00720cULL, 0x000fe20003f26070ULL, 0x000000012d077824ULL, 0x000fe200078e021eULL,
0x000000230a0a7210ULL, 0x000fe40007fde0ffULL, 0x000000021e1e7819ULL, 0x000fe200000006ffULL,
0x00005e0007067625ULL, 0x000fe200078e0006ULL, 0x000000021a147819ULL, 0x004fc600000006ffULL,
0x000000041c1a7824ULL, 0x000fe200078e00ffULL, 0xfffffffc1e1e7812ULL, 0x100fe200078ee21bULL,
0x00000004220e7824ULL, 0x008fe200078e00ffULL, 0xfffffffc14147812ULL, 0x100fe200078ee21bULL,
0x000000040c1c7824ULL, 0x000fe200078e00ffULL, 0xfffffffc200c7812ULL, 0x000fe200078ee21bULL,
0x000000ffff0b7224ULL, 0x000fe200030e060bULL, 0xfffffffc0e0e7812ULL, 0x100fe400078ee21bULL,
0xfffffffc1a1a7812ULL, 0x000fe200078ee21bULL, 0x000000100c0f7824ULL, 0x000fe200078e021dULL,
0xfffffffc1c1c7812ULL, 0x000fe200078ee21bULL, 0x000000100e157824ULL, 0x100fe200078e021dULL,
0x0000002306067210ULL, 0x000fe20007fde0ffULL, 0x00000010141b7824ULL, 0x100fe200078e021dULL,
0x0000001d1a1f7211ULL, 0x000fe200078e20ffULL, 0x000000101c217824ULL, 0x100fe200078e021dULL,
0x00000000100f7faeULL, 0x0005e2000e901c46ULL, 0x000000101e1d7824ULL, 0x000fc400078e021dULL,
0x000000ffff077224ULL, 0x000fe200030e0607ULL, 0x0000000012157faeULL, 0x0005e8000e101c46ULL,
0x00000000161b7faeULL, 0x0005e8000d901c46ULL, 0x00000000181f7faeULL, 0x0005e8000d101c46ULL,
0x000000000a217faeULL, 0x0005e8000c901c46ULL, 0x00000000061d7faeULL, 0x0005e2000c101c46ULL,
0x000004d000007947ULL, 0x000fea0003800000ULL, 0x000000100c0a7811ULL, 0x040fe400078ff0ffULL,
0x0000002d0c0b7211ULL, 0x000fc400078ff0ffULL, 0x0000003010317812ULL, 0x000fe200078ec0ffULL,
0x000000012d0f7824ULL, 0x000fe200078e020aULL, 0x0000000c0c077211ULL, 0x000fe200078fe8ffULL,
0x000000040a1a7824ULL, 0x000fe200078e00ffULL, 0x000000080c167811ULL, 0x040fe200078ff0ffULL,
0x00005e000b0a7625ULL, 0x000fe200078e0006ULL, 0x000000180c0e7811ULL, 0x040fe400078ff0ffULL,
0x000000280c127811ULL, 0x040fe400078ff0ffULL, 0x000000300c137811ULL, 0x040fe200078ff0ffULL,
0x000000012d117824ULL, 0x040fe200078e020eULL, 0x000000200c107811ULL, 0x040fe200078ff0ffULL,
0x000000012d257824ULL, 0x040fe200078e0212ULL, 0x000000380c147811ULL, 0x000fe200078ff0ffULL,
0x000000012d297824ULL, 0x000fe200078e0213ULL, 0x0000000307157812ULL, 0x000fe200078ec0ffULL,
0x000000012d077824ULL, 0x040fe200078e0216ULL, 0x000000102d217210ULL, 0x000fe20007ffe0ffULL,
0x000000040e0e7824ULL, 0x000fe200078e00ffULL, 0x0000000216167819ULL, 0x000fe200000006ffULL,
0x0000000410107824ULL, 0x000fe200078e00ffULL, 0x00000002131e7819ULL, 0x000fe200000006ffULL,
0x00000004121c7824ULL, 0x000fe200078e00ffULL, 0x0ffffffc15187812ULL, 0x000fe200078ef80cULL,
0x000000012d2d7824ULL, 0x000fe200078e0214ULL, 0xfffffffc160c7812ULL, 0x000fe200078ee215ULL,
0x0000000414207824ULL, 0x000fe200078e00ffULL, 0x000000310a147210ULL, 0x000fc40007f1e0ffULL,
0xfffffffc1a127812ULL, 0x100fe400078ee215ULL, 0xfffffffc0e137812ULL, 0x100fe200078ee215ULL,
0x00005e000f0e7625ULL, 0x080fe200078e0006ULL, 0xfffffffc10167812ULL, 0x100fe400078ee215ULL,
0xfffffffc1c177812ULL, 0x100fe200078ee215ULL, 0x00005e0011107625ULL, 0x080fe200078e0006ULL,
0xfffffffc1e197812ULL, 0x100fe400078ee215ULL, 0xfffffffc201a7812ULL, 0x000fe200078ee215ULL,
0x000000ffff157224ULL, 0x000fe200000e060bULL, 0x00002000002f7811ULL, 0x000fe200078e68ffULL,
0x00005e00070a7625ULL, 0x000fc600078e0006ULL, 0x0000002f192b7211ULL, 0x000fe200078e20ffULL,
0x0000001016237824ULL, 0x100fe200078e022fULL, 0x000000310a167210ULL, 0x080fe20007f1e0ffULL,
0x0000001018337824ULL, 0x100fe200078e022fULL, 0x000000310e187210ULL, 0x000fe20007f3e0ffULL,
0x0000001017277824ULL, 0x000fe200078e022fULL, 0x0000002f0c1b7211ULL, 0x000fe200078e20ffULL,
0x000000ffff177224ULL, 0x000fe200000e060bULL, 0x0000003110107210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff197224ULL, 0x000fe200008e060fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014337faeULL, 0x0005e2000b901c46ULL, 0x00000010121d7824ULL, 0x000fc400078e022fULL,
0x00000010131f7824ULL, 0x000fe200078e022fULL, 0x00000000161b7faeULL, 0x0005e2000b901c46ULL,
0x00005e00210a7625ULL, 0x000fc600078e0006ULL, 0x00000000181d7faeULL, 0x0005e2000b901c46ULL,
0x00005e00250e7625ULL, 0x000fc800078e0006ULL, 0x00005e0029127625ULL, 0x000fe200078e0006ULL,
0x000000310e0e7210ULL, 0x000fc60007f3e0ffULL, 0x00005e002d067625ULL, 0x000fe200078e0006ULL,
0x0000003112127210ULL, 0x000fc60007f5e0ffULL, 0x000000ffff117224ULL, 0x000fe200000e0611ULL,
0x000000310a0a7210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e060fULL,
0x0000003106067210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff137224ULL, 0x000fe200010e0613ULL,
0x0000000bff0b7210ULL, 0x000fe200007fe4ffULL, 0x000000101a2f7824ULL, 0x000fe200078e022fULL,
0x00000000101f7faeULL, 0x0005e2000b901c46ULL, 0x000000ffff077224ULL, 0x000fc600018e0607ULL,
0x000000000a237faeULL, 0x0005e8000b901c46ULL, 0x000000000e277faeULL, 0x0005e8000b901c46ULL,
0x00000000122b7faeULL, 0x0005e8000b901c46ULL, 0x00000000062f7faeULL, 0x0005e4000b901c46ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000067805ULL, 0x004fc40000015200ULL,
0x01460400ff0b7984ULL, 0x000ea40000000800ULL, 0x800000000bff7812ULL, 0x006fc40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a060f7210ULL, 0x000fc80007f1e1ffULL,
0x0000000b070b7210ULL, 0x000fe400007fe5ffULL, 0x003d09000f00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400f00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0a7819ULL, 0x000fc8000001140bULL,
0x0000000f0a0a7211ULL, 0x000fca00078110ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e060bULL,
0x000000020a0a7819ULL, 0x000fc8000000120bULL, 0x0000000a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01460400ff0b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000d0200720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000197919ULL, 0x000e620000000000ULL, 0x0001468800187811ULL, 0x040fe200078e18ffULL,
0x0000002000157824ULL, 0x000fe200078e00ffULL, 0xffffffff0d177810ULL, 0x000fc40007ffe0ffULL,
0x0000010002167824ULL, 0x000fe200078e0205ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x000000160300720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x00cfea0003800000ULL,
0x0000000102067810ULL, 0x000fe20007ffe0ffULL, 0x00006200041c7a24ULL, 0x000fe400078e0216ULL,
0x00000200ff147424ULL, 0x000fe200078e00ffULL, 0x0000000d0600720cULL, 0x000fda0003f06070ULL,
0x0000052000008947ULL, 0x000fea0003800000ULL, 0x00000002ff137819ULL, 0x002fe40000011619ULL,
0x0000001919087211ULL, 0x000fe400078fe8ffULL, 0x00000008130f7810ULL, 0x040fe20007ffe0ffULL,
0x0000000113097824ULL, 0x100fe200078e021cULL, 0x8000001603067210ULL, 0x000fe40007ffe0ffULL,
0x00000003191a7812ULL, 0x000fe200078ec0ffULL, 0x000000010f0b7824ULL, 0x000fe200078e021cULL,
0x0ffffffc19077812ULL, 0x000fe200078ec0ffULL, 0x000000040f117824ULL, 0x000fe200078e00ffULL,
0x00000003080e7812ULL, 0x000fe200078ec0ffULL, 0x00005e0009087625ULL, 0x000fe200078e0014ULL,
0x000000061300720cULL, 0x000fc40003f26070ULL, 0x000000060f00720cULL, 0x000fe20003f46070ULL,
0x00005e000b0a7625ULL, 0x000fe200078e0014ULL, 0x000000041a1b7812ULL, 0x000fe400078efcffULL,
0x00003000000c7811ULL, 0x000fe400078e68ffULL, 0x000000070e0f7212ULL, 0x000fe200078efcffULL,
0x000000101b087825ULL, 0x000fe200078e0008ULL, 0xfffffffc11117812ULL, 0x000fe400078ee20eULL,
0x00000010131d7810ULL, 0x000fe20007ffe0ffULL, 0x000000100f0f7824ULL, 0x000fe200078e020cULL,
0x0000000c11117211ULL, 0x000fe200078e20ffULL, 0x000000101b0a7825ULL, 0x000fe200078e000aULL,
0x00000018131f7810ULL, 0x000fc40007ffe0ffULL, 0x0000002013257810ULL, 0x040fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080f7faeULL, 0x0003e2000c901c46ULL,
0x0000002813297810ULL, 0x000fe20007ffe0ffULL, 0x000000041d217824ULL, 0x000fe200078e00ffULL,
0x0000003813317810ULL, 0x040fe20007ffe0ffULL, 0x000000000a117faeULL, 0x0005e2000d101c46ULL,
0x00000030132d7810ULL, 0x000fe20007ffe0ffULL, 0x000000041f237824ULL, 0x040fe200078e00ffULL,
0x000000061f00720cULL, 0x080fe20003f46070ULL, 0x0000000425277824ULL, 0x000fe200078e00ffULL,
0x000000022d2f7819ULL, 0x000fe200000006ffULL, 0x00000004292b7824ULL, 0x000fe200078e00ffULL,
0x000000061d00720cULL, 0x000fe20003f26070ULL, 0x0000000431337824ULL, 0x000fe200078e00ffULL,
0xfffffffc21217812ULL, 0x000fe200078ee20eULL, 0x000000011d097824ULL, 0x002fe200078e021cULL,
0xfffffffc23237812ULL, 0x000fe200078ee20eULL, 0x000000011f0b7824ULL, 0x104fe200078e021cULL,
0x0000001c29117210ULL, 0x000fe20007ffe0ffULL, 0x00000001250f7824ULL, 0x000fe200078e021cULL,
0xfffffffc27277812ULL, 0x000fe200078ee20eULL, 0x000000012d137824ULL, 0x000fe200078e021cULL,
0xfffffffc2b2b7812ULL, 0x000fe200078ee20eULL, 0x00000001311f7824ULL, 0x000fe200078e021cULL,
0xfffffffc2f2f7812ULL, 0x100fe200078ee20eULL, 0x00005e0009087625ULL, 0x000fe200078e0014ULL,
0xfffffffc33337812ULL, 0x000fc400078ee20eULL, 0x000000062500720cULL, 0x000fe20003f66070ULL,
0x00005e000b0a7625ULL, 0x000fe200078e0014ULL, 0x000000062900720cULL, 0x080fe40003f86070ULL,
0x000000062d00720cULL, 0x000fe20003fa6070ULL, 0x00005e000f0e7625ULL, 0x000fe200078e0014ULL,
0x000000063100720cULL, 0x000fc60003fc6070ULL, 0x00005e0011107625ULL, 0x000fc800078e0014ULL,
0x00005e0013127625ULL, 0x000fc800078e0014ULL, 0x00005e001f1e7625ULL, 0x000fc800078e0014ULL,
0x000000101b087825ULL, 0x000fc800078e0008ULL, 0x000000101b0a7825ULL, 0x000fc800078e000aULL,
0x000000101b0e7825ULL, 0x000fc800078e000eULL, 0x000000101b107825ULL, 0x000fc800078e0010ULL,
0x000000101b127825ULL, 0x000fc800078e0012ULL, 0x000000101b1e7825ULL, 0x000fc800078e001eULL,
0x00000010211b7824ULL, 0x100fe200078e020cULL, 0x0000000c27217211ULL, 0x000fe200078e20ffULL,
0x00000010231d7824ULL, 0x100fe400078e020cULL, 0x000000102b237824ULL, 0x100fe200078e020cULL,
0x00000000081b7faeULL, 0x0003e2000c901c46ULL, 0x000000102f257824ULL, 0x100fe400078e020cULL,
0x0000001033277824ULL, 0x000fe200078e020cULL, 0x000000000a1d7faeULL, 0x0003e8000d101c46ULL,
0x000000000e217faeULL, 0x0003e8000d901c46ULL, 0x0000000010237faeULL, 0x0003e8000e101c46ULL,
0x0000000012257faeULL, 0x0003e8000e901c46ULL, 0x000000001e277faeULL, 0x0003e2000f101c46ULL,
0x0000047000007947ULL, 0x000fea0003800000ULL, 0x00000008190f7811ULL, 0x042fe400078ff0ffULL,
0x0000001019117811ULL, 0x000fc400078ff0ffULL, 0x0000003019237811ULL, 0x000fe200078ff0ffULL,
0x000000010f0b7824ULL, 0x100fe200078e021cULL, 0x0000001819137811ULL, 0x000fe200078ff0ffULL,
0x0000000411297824ULL, 0x000fe200078e00ffULL, 0x00000028191d7811ULL, 0x000fe200078ff0ffULL,
0x0000000123217824ULL, 0x100fe200078e021cULL, 0x0000003819257811ULL, 0x000fe200078ff0ffULL,
0x00000004132b7824ULL, 0x000fe200078e00ffULL, 0x00000020191b7811ULL, 0x000fe200078ff0ffULL,
0x000000011d1f7824ULL, 0x100fe200078e021cULL, 0x0000001919067211ULL, 0x000fe200078fe8ffULL,
0x000000041d1d7824ULL, 0x000fe200078e00ffULL, 0x000000020f277819ULL, 0x000fe200000006ffULL,
0x00000001110f7824ULL, 0x100fe200078e021cULL, 0x0000000223317819ULL, 0x000fe200000006ffULL,
0x0000000113117824ULL, 0x100fe200078e021cULL, 0x0000001c19097211ULL, 0x080fe200078ff0ffULL,
0x0000000125237824ULL, 0x000fe200078e021cULL, 0x0000001c1b137210ULL, 0x040fe20007ffe0ffULL,
0x000000041b2f7824ULL, 0x000fe200078e00ffULL, 0x0000000306067812ULL, 0x000fe200078ec0ffULL,
0x0000000425257824ULL, 0x000fe200078e00ffULL, 0x00000003191a7812ULL, 0x000fe200078ec0ffULL,
0x00005e0009087625ULL, 0x000fe200078e0014ULL, 0x0ffffffc19077812ULL, 0x000fc400078ec0ffULL,
0xfffffffc270c7812ULL, 0x100fe200078ee206ULL, 0x00005e000b0a7625ULL, 0x080fe200078e0014ULL,
0xfffffffc29247812ULL, 0x100fe400078ee206ULL, 0xfffffffc2b267812ULL, 0x100fe200078ee206ULL,
0x00005e000f0e7625ULL, 0x080fe200078e0014ULL, 0xfffffffc2f287812ULL, 0x100fe400078ee206ULL,
0xfffffffc1d2a7812ULL, 0x100fe200078ee206ULL, 0x00005e0011107625ULL, 0x000fe200078e0014ULL,
0xfffffffc312c7812ULL, 0x000fc400078ee206ULL, 0xfffffffc252e7812ULL, 0x000fe200078ee206ULL,
0x00005e0013127625ULL, 0x080fe200078e0014ULL, 0x00003000002d7811ULL, 0x000fe400078e68ffULL,
0x000000041a1b7812ULL, 0x000fe200078efcffULL, 0x00005e001f1e7625ULL, 0x080fe200078e0014ULL,
0x0000000706067212ULL, 0x000fe400078efcffULL, 0x0000002d241d7211ULL, 0x000fe200078e20ffULL,
0x00005e0021207625ULL, 0x000fc800078e0014ULL, 0x00005e0023227625ULL, 0x000fc800078e0014ULL,
0x000000101b087825ULL, 0x000fc800078e0008ULL, 0x000000101b0a7825ULL, 0x000fc800078e000aULL,
0x000000101b0e7825ULL, 0x000fc800078e000eULL, 0x000000101b107825ULL, 0x000fc800078e0010ULL,
0x000000101b127825ULL, 0x000fc800078e0012ULL, 0x000000101b1e7825ULL, 0x000fc800078e001eULL,
0x000000101b207825ULL, 0x000fc800078e0020ULL, 0x000000101b227825ULL, 0x000fc800078e0022ULL,
0x00000010062f7824ULL, 0x100fe400078e022dULL, 0x000000100c1b7824ULL, 0x100fe400078e022dULL,
0x0000001026257824ULL, 0x100fe200078e022dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000082f7faeULL, 0x0003e2000b901c46ULL, 0x0000001028277824ULL, 0x100fe400078e022dULL,
0x000000102a297824ULL, 0x100fe200078e022dULL, 0x000000000a1b7faeULL, 0x0003e2000b901c46ULL,
0x000000102c2b7824ULL, 0x000fe200078e022dULL, 0x0000002d2e2d7211ULL, 0x000fc400078e20ffULL,
0x000000000e1d7faeULL, 0x0003e8000b901c46ULL, 0x0000000010257faeULL, 0x0003e8000b901c46ULL,
0x0000000012277faeULL, 0x0003e8000b901c46ULL, 0x000000001e297faeULL, 0x0003e8000b901c46ULL,
0x00000000202b7faeULL, 0x0003e8000b901c46ULL, 0x00000000222d7faeULL, 0x0003e4000b901c46ULL,
0x00000004ff127819ULL, 0x102fe20000011619ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000719067812ULL, 0x000fe200078ec0ffULL, 0x00002000000c7824ULL, 0x000fe200078e00ffULL,
0x00000003ff4e7819ULL, 0x100fe20000011619ULL, 0x0000000812097824ULL, 0x000fe200078e00ffULL,
0x0000000806137812ULL, 0x000fc400078ef819ULL, 0x000000014e087812ULL, 0x000fe400078ec0ffULL,
0xfffffff809097812ULL, 0x000fe200078ee206ULL, 0x0000000113127824ULL, 0x040fe200078e0212ULL,
0x000020000c117810ULL, 0x000fe20007ffe0ffULL, 0x00000020130b7824ULL, 0x000fe200078e00ffULL,
0x0000001009217810ULL, 0x040fe20007ffe0ffULL, 0x00000004090e7824ULL, 0x040fe200078e00ffULL,
0x0000002009237810ULL, 0x040fe20007ffe0ffULL, 0x0000000409397824ULL, 0x040fe200078e00ffULL,
0x0000003009357810ULL, 0x000fe20007ffe0ffULL, 0x00000004214d7824ULL, 0x000fe200078e00ffULL,
0x00000008090f7211ULL, 0x080fe200078ff8ffULL, 0x0000000421367824ULL, 0x040fe200078e00ffULL,
0x0000000821107211ULL, 0x080fe200078ff8ffULL, 0x00000004354b7824ULL, 0x000fe200078e00ffULL,
0x0000000823207211ULL, 0x000fe200078ff8ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000223097819ULL, 0x000fe200000006ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0xffffffe00b067812ULL, 0x000fe200078ee212ULL, 0x0000000423237824ULL, 0x000fe200078e00ffULL,
0xfffffffc0e0e7812ULL, 0x000fe400078ee20fULL, 0x0000000835227211ULL, 0x000fe200078ff8ffULL,
0x0000001006067824ULL, 0x000fe200078e00ffULL, 0xfffffffc4d4d7812ULL, 0x000fe200078ee210ULL,
0x000000100e1b7824ULL, 0x100fe200078e0211ULL, 0xfffffffc094c7812ULL, 0x000fe200078ee220ULL,
0x0000000435357824ULL, 0x000fe200078e00ffULL, 0xfffffffc4b4b7812ULL, 0x000fe200078ee222ULL,
0x000000104d1d7824ULL, 0x100fe200078e0211ULL, 0x000000000608783bULL, 0x0003e20000000200ULL,
0x000000104c1e7824ULL, 0x000fe200078e0211ULL, 0x000000114b1f7211ULL, 0x000fc400078e20ffULL,
0x000000001b30783bULL, 0x000ea20000000200ULL, 0x0000000513377819ULL, 0x000fe400000006ffULL,
0x0000000212347810ULL, 0x000fe20007ffe0ffULL, 0x000000001d2c783bULL, 0x000ee20000000200ULL,
0x0000000210497810ULL, 0x000fe40007ffe0ffULL, 0x00000002204a7810ULL, 0x000fe20007ffe0ffULL,
0x000000001e28783bULL, 0x000f220000000200ULL, 0x0000000222067810ULL, 0x002fe40007ffe0ffULL,
0xffffffe037347812ULL, 0x000fe200078ee234ULL, 0x000000001f24783bULL, 0x000e620000000200ULL,
0xfffffffc36497812ULL, 0x000fc400078ee249ULL, 0x000000020f487810ULL, 0x000fe20007ffe0ffULL,
0x0000001034347824ULL, 0x000fe200078e00ffULL, 0xfffffffc234a7812ULL, 0x000fe200078ee24aULL,
0x0000001049217824ULL, 0x100fe200078e0211ULL, 0xfffffffc35067812ULL, 0x000fe400078ee206ULL,
0xfffffffc39487812ULL, 0x000fe200078ee248ULL, 0x000000104a227824ULL, 0x100fe200078e0211ULL,
0x000000003450783bULL, 0x0009e20000000200ULL, 0x0000001006237824ULL, 0x000fe200078e0211ULL,
0x0000001148207211ULL, 0x000fc400078e20ffULL, 0x000000002158783bULL, 0x000e680000000200ULL,
0x00000000225c783bULL, 0x000e680000000200ULL, 0x000000002360783bULL, 0x000e680000000200ULL,
0x000000002054783bULL, 0x000e620000000200ULL, 0x000000300844723cULL, 0x044ff000000418ffULL,
0x000000320840723cULL, 0x040ff000000418ffULL, 0x0000002c0830723cULL, 0x048f7000000418ffULL,
0x000000280834723cULL, 0x050f7000000418ffULL, 0x0000002a0838723cULL, 0x040f7000000418ffULL,
0x0000002e082c723cULL, 0x040ff000000418ffULL, 0x00000024083c723cULL, 0x042f7000000418ffULL,
0x000000260808723cULL, 0x000f7000000418ffULL, 0x000000585028723cULL, 0x060b700000041830ULL,
0x0000005c5030723cULL, 0x040b700000041834ULL, 0x0000005e5034723cULL, 0x040b700000041838ULL,
0x000000605038723cULL, 0x040b70000004183cULL, 0x000000545044723cULL, 0x040b700000041844ULL,
0x000000565040723cULL, 0x040b700000041840ULL, 0x0000005a502c723cULL, 0x040b70000004182cULL,
0x00000062503c723cULL, 0x000b620000041808ULL, 0x000004f000008947ULL, 0x000fce0003800000ULL,
0x00000002ff277819ULL, 0x100fe20000011619ULL, 0x000000014e107824ULL, 0x000fe200078e0219ULL,
0x8000001603267210ULL, 0x000fc40007ffe0ffULL, 0x00000008270b7810ULL, 0x060fe20007ffe0ffULL,
0x0000000127097824ULL, 0x140fe200078e021cULL, 0x0000000310107812ULL, 0x000fe400078ec0ffULL,
0x000000262700720cULL, 0x080fe20003f26070ULL, 0x000000010b0f7824ULL, 0x040fe200078e021cULL,
0x000000260b00720cULL, 0x040fe20003f46070ULL, 0x000000040b4f7824ULL, 0x000fe200078e00ffULL,
0x000000081a557812ULL, 0x000fe200078efcffULL, 0x00005e0009087625ULL, 0x000fe200078e0014ULL,
0x0000000710257212ULL, 0x000fc400078efcffULL, 0xfffffffc4f247812ULL, 0x000fe200078ee210ULL,
0x00005e000f0a7625ULL, 0x000fe200078e0014ULL, 0x00000010274f7810ULL, 0x000fe40007ffe0ffULL,
0x0000001124077211ULL, 0x000fe200078e20ffULL, 0x0000001055087825ULL, 0x000fe200078e0008ULL,
0x0000001827577810ULL, 0x040fe40007ffe0ffULL, 0x0000002027597810ULL, 0x000fe20007ffe0ffULL,
0x00000010250f7824ULL, 0x000fe200078e0211ULL, 0x00000028275b7810ULL, 0x000fe20007ffe0ffULL,
0x00000010550a7825ULL, 0x000fe200078e000aULL, 0x00000030275d7810ULL, 0x000fc40007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080f7faeULL, 0x0003e2000c901c46ULL,
0x00000038275f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000159277824ULL, 0x100fe200078e021cULL,
0x000000264f00720cULL, 0x080fe20003f26070ULL, 0x000000000a077faeULL, 0x0005e2000d101c46ULL,
0x000000265700720cULL, 0x080fe20003f46070ULL, 0x000000015d517824ULL, 0x100fe200078e021cULL,
0x000000265b00720cULL, 0x080fe20003f86070ULL, 0x000000015f537824ULL, 0x000fe200078e021cULL,
0x000000265900720cULL, 0x000fe20003f66070ULL, 0x00005e0051507625ULL, 0x000fe200078e0014ULL,
0x000000265d00720cULL, 0x000fc40003fa6070ULL, 0x000000265f00720cULL, 0x000fe20003fc6070ULL,
0x000000014f097824ULL, 0x002fe200078e021cULL, 0x0000000259597819ULL, 0x000fe200000006ffULL,
0x000000044f077824ULL, 0x004fe200078e00ffULL, 0x0000001c5b4f7210ULL, 0x000fe20007ffe0ffULL,
0x00005e0009087625ULL, 0x000fe200078e0014ULL, 0xfffffffc59547812ULL, 0x100fe400078ee210ULL,
0xfffffffc07247812ULL, 0x000fe200078ee210ULL, 0x00000001570b7824ULL, 0x040fe400078e021cULL,
0x0000000457577824ULL, 0x000fc400078e00ffULL, 0x000000045b5b7824ULL, 0x000fe400078e00ffULL,
0x000000045d5d7824ULL, 0x000fe400078e00ffULL, 0x00005e000b0a7625ULL, 0x000fe200078e0014ULL,
0xfffffffc5b567812ULL, 0x100fe400078ee210ULL, 0xfffffffc5d587812ULL, 0x100fe200078ee210ULL,
0x0000001024077824ULL, 0x000fe200078e0211ULL, 0xfffffffc57247812ULL, 0x000fe200078ee210ULL,
0x0000001055087825ULL, 0x000fc800078e0008ULL, 0x000000045f5f7824ULL, 0x000fe200078e00ffULL,
0x0000000008077faeULL, 0x0003e2000c901c46ULL, 0x00005e0027267625ULL, 0x000fc600078e0014ULL,
0xfffffffc5f5a7812ULL, 0x000fe200078ee210ULL, 0x00005e004f4e7625ULL, 0x000fc800078e0014ULL,
0x00005e0053527625ULL, 0x000fe200078e0014ULL, 0x0000001154097211ULL, 0x002fc600078e20ffULL,
0x00000010550a7825ULL, 0x000fc800078e000aULL, 0x0000001024077824ULL, 0x000fe400078e0211ULL,
0x0000001055267825ULL, 0x000fc600078e0026ULL, 0x000000000a077faeULL, 0x0003e2000d101c46ULL,
0x00000010554e7825ULL, 0x000fc600078e004eULL, 0x0000000026097faeULL, 0x0003e2000d901c46ULL,
0x0000001055507825ULL, 0x000fc800078e0050ULL, 0x0000001055527825ULL, 0x000fc800078e0052ULL,
0x0000001056557824ULL, 0x100fe400078e0211ULL, 0x0000001058577824ULL, 0x100fe400078e0211ULL,
0x000000105a597824ULL, 0x000fe200078e0211ULL, 0x000000004e557faeULL, 0x0003e8000e101c46ULL,
0x0000000050577faeULL, 0x0003e8000e901c46ULL, 0x0000000052597faeULL, 0x0003e2000f101c46ULL,
0x0000044000007947ULL, 0x000fea0003800000ULL, 0x00000008190b7811ULL, 0x060fe200078ff0ffULL,
0x000000014e107824ULL, 0x000fe200078e0219ULL, 0x0000001c19097211ULL, 0x000fc400078ff0ffULL,
0x0000001c0b0f7210ULL, 0x040fe20007ffe0ffULL, 0x000000040b0b7824ULL, 0x000fe200078e00ffULL,
0x0000001019257811ULL, 0x000fe200078ff0ffULL, 0x00005e0009087625ULL, 0x080fe200078e0014ULL,
0x0000000310107812ULL, 0x000fe400078ec0ffULL, 0x00000018195d7811ULL, 0x000fe200078ff0ffULL,
0x0000000125277824ULL, 0x100fe200078e021cULL, 0x00000020195f7811ULL, 0x000fe200078ff0ffULL,
0x0000000425597824ULL, 0x000fe200078e00ffULL, 0x0000002819617811ULL, 0x000fe200078ff0ffULL,
0x000000015d4f7824ULL, 0x000fe200078e021cULL, 0xfffffffc0b247812ULL, 0x000fe200078ee210ULL,
0x00005e000f0a7625ULL, 0x000fe200078e0014ULL, 0x000000081a5b7812ULL, 0x000fc400078efcffULL,
0x0000000710257212ULL, 0x000fe200078efcffULL, 0x000000045d5d7824ULL, 0x000fe200078e00ffULL,
0x0000003019637811ULL, 0x000fe200078ff0ffULL, 0x0000000161537824ULL, 0x000fe200078e021cULL,
0x0000003819657811ULL, 0x000fe200078ff0ffULL, 0x00005e0027267625ULL, 0x000fe200078e0014ULL,
0x0000001c5f517210ULL, 0x000fe40007ffe0ffULL, 0xfffffffc59587812ULL, 0x000fe200078ee210ULL,
0x000000045f5f7824ULL, 0x000fe400078e00ffULL, 0x000000105b087825ULL, 0x000fe200078e0008ULL,
0x0000001158597211ULL, 0x000fc400078e20ffULL, 0xfffffffc5f587812ULL, 0x000fe200078ee210ULL,
0x00000010250f7824ULL, 0x100fe400078e0211ULL, 0x0000000461617824ULL, 0x000fe400078e00ffULL,
0x0000000163557824ULL, 0x140fe200078e021cULL, 0x0000000263637819ULL, 0x000fe200000006ffULL,
0x0000000165577824ULL, 0x000fe200078e021cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080f7faeULL, 0x0003e2000b901c46ULL, 0x0000001024077824ULL, 0x000fe200078e0211ULL,
0xfffffffc5d247812ULL, 0x000fe200078ee210ULL, 0x000000105b0a7825ULL, 0x000fe200078e000aULL,
0xfffffffc615a7812ULL, 0x000fc600078ee210ULL, 0x00005e004f4e7625ULL, 0x080fe200078e0014ULL,
0x000000000a077faeULL, 0x0005e6000b901c46ULL, 0x0000000465657824ULL, 0x000fe200078e00ffULL,
0xfffffffc63087812ULL, 0x002fe200078ee210ULL, 0x00005e0051507625ULL, 0x000fc800078e0014ULL,
0x00005e0053527625ULL, 0x000fe200078e0014ULL, 0xfffffffc650a7812ULL, 0x004fc600078ee210ULL,
0x00005e0055547625ULL, 0x000fc800078e0014ULL, 0x000000105b267825ULL, 0x000fc800078e0026ULL,
0x00005e0057567625ULL, 0x000fe200078e0014ULL, 0x0000000026597faeULL, 0x0003e6000b901c46ULL,
0x000000105b4e7825ULL, 0x000fc800078e004eULL, 0x0000001024077824ULL, 0x000fe400078e0211ULL,
0x000000105b507825ULL, 0x000fe200078e0050ULL, 0x0000001108277211ULL, 0x002fc600078e20ffULL,
0x0000001058097824ULL, 0x000fe200078e0211ULL, 0x000000004e077faeULL, 0x0003e2000b901c46ULL,
0x000000105b527825ULL, 0x000fc600078e0052ULL, 0x0000000050097faeULL, 0x0003e2000b901c46ULL,
0x000000105a0b7824ULL, 0x000fe400078e0211ULL, 0x000000105b547825ULL, 0x000fc600078e0054ULL,
0x00000000520b7faeULL, 0x0003e2000b901c46ULL, 0x000000105b567825ULL, 0x000fc600078e0056ULL,
0x0000000054277faeULL, 0x0003e2000b901c46ULL, 0x000000100a597824ULL, 0x000fca00078e0211ULL,
0x0000000056597faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000002013087824ULL, 0x040fe200078e00ffULL, 0x0000000412077810ULL, 0x002fe20007ffe0ffULL,
0x0000002013097824ULL, 0x000fe200078e00ffULL, 0x000030000c247810ULL, 0x000fe40007ffe0ffULL,
0xffffffe008077812ULL, 0x000fe400078ee207ULL, 0x000000244d0c7211ULL, 0x000fe200078e20ffULL,
0x000000100e0e7824ULL, 0x000fe200078e0224ULL, 0x0000000612087810ULL, 0x000fe20007ffe0ffULL,
0x0000001007077824ULL, 0x000fc400078e00ffULL, 0x000000104c0b7824ULL, 0x000fe200078e0224ULL,
0xffffffe009087812ULL, 0x000fe200078ee208ULL, 0x000000104b0a7824ULL, 0x100fe400078e0224ULL,
0x0000001048097824ULL, 0x100fe200078e0224ULL, 0x0000000408487819ULL, 0x000fe200000006ffULL,
0x0000001049087824ULL, 0x100fe400078e0224ULL, 0x0000001006067824ULL, 0x000fe200078e0224ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000000e68783bULL, 0x000fe80000000200ULL,
0x000000000754783bULL, 0x0002a80000000200ULL, 0x000000000c6c783bULL, 0x000ee80000000200ULL,
0x000000000b5c783bULL, 0x000f220000000200ULL, 0x000000104a077824ULL, 0x002fc600078e0224ULL,
0x000000000a58783bULL, 0x000e680000000200ULL, 0x000000000964783bULL, 0x000fe80000000200ULL,
0x000000004848783bULL, 0x000e680000000200ULL, 0x000000000860783bULL, 0x000e680000000200ULL,
0x000000000750783bULL, 0x000e680000000200ULL, 0x00000000064c783bULL, 0x000e620000000200ULL,
0x000000685444723cULL, 0x044ff00000041844ULL, 0x0000006a5440723cULL, 0x040f700000041840ULL,
0x0000006c5468723cULL, 0x048f700000041828ULL, 0x0000005c5470723cULL, 0x050ff00000041830ULL,
0x0000006e546c723cULL, 0x040f70000004182cULL, 0x0000005e545c723cULL, 0x040f700000041834ULL,
0x000000585474723cULL, 0x042f700000041838ULL, 0x0000005a5454723cULL, 0x000f70000004183cULL,
0x00000066482c723cULL, 0x060b700000041840ULL, 0x000000644828723cULL, 0x040b700000041844ULL,
0x000000604830723cULL, 0x040b700000041868ULL, 0x000000624834723cULL, 0x040b70000004186cULL,
0x000000504838723cULL, 0x040b700000041870ULL, 0x00000052483c723cULL, 0x040b70000004185cULL,
0x0000004c4840723cULL, 0x040b700000041874ULL, 0x0000004e4848723cULL, 0x000b620000041854ULL,
0x000004c000008947ULL, 0x000fce0003800000ULL, 0x00000002ff4d7819ULL, 0x020fe20000011619ULL,
0x0000000103467824ULL, 0x000fe200078e0a16ULL, 0x0000000c1a537812ULL, 0x000fe200078efcffULL,
0x0000001025257824ULL, 0x000fe200078e0224ULL, 0x000000084d457810ULL, 0x000fc40007ffe0ffULL,
0x0000001c4d277210ULL, 0x040fe40007ffe0ffULL, 0x000000464d00720cULL, 0x080fe20003f26070ULL,
0x0000000145477824ULL, 0x040fe200078e021cULL, 0x000000464500720cULL, 0x040fe20003f46070ULL,
0x00000004454f7824ULL, 0x000fe200078e00ffULL, 0x000000184d577810ULL, 0x000fe20007ffe0ffULL,
0x00005e0027267625ULL, 0x080fe200078e0014ULL, 0x000000204d597810ULL, 0x040fe40007ffe0ffULL,
0x000000284d5b7810ULL, 0x000fe20007ffe0ffULL, 0x00005e0047447625ULL, 0x000fe200078e0014ULL,
0xfffffffc4f477812ULL, 0x000fc400078ee210ULL, 0x000000104d4f7810ULL, 0x000fe20007ffe0ffULL,
0x0000001053267825ULL, 0x000fe200078e0026ULL, 0x000000304d5d7810ULL, 0x040fe40007ffe0ffULL,
0x000000384d5f7810ULL, 0x000fe20007ffe0ffULL, 0x0000001047477824ULL, 0x000fe200078e0224ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026257faeULL, 0x0003e2000c901c46ULL,
0x0000001053447825ULL, 0x000fe200078e0044ULL, 0x000000464f00720cULL, 0x080fe40003f26070ULL,
0x000000465900720cULL, 0x080fe20003f66070ULL, 0x000000044f557824ULL, 0x000fe200078e00ffULL,
0x0000000044477faeULL, 0x0005e2000d101c46ULL, 0x000000015b4d7824ULL, 0x100fe200078e021cULL,
0x000000465700720cULL, 0x080fe20003f46070ULL, 0x000000015f517824ULL, 0x000fe200078e021cULL,
0x000000465b00720cULL, 0x000fe20003f86070ULL, 0x00005e004d4c7625ULL, 0x000fe200078e0014ULL,
0x0000001c4f277210ULL, 0x002fc40007ffe0ffULL, 0x0000001c5d4f7210ULL, 0x000fe20007ffe0ffULL,
0x00005e0051507625ULL, 0x000fe200078e0014ULL, 0x000000465d00720cULL, 0x080fe40003fa6070ULL,
0x000000465f00720cULL, 0x000fe20003fc6070ULL, 0x0000000157457824ULL, 0x004fe200078e021cULL,
0xfffffffc55557812ULL, 0x000fe200078ee210ULL, 0x0000000159477824ULL, 0x000fe400078e021cULL,
0x00005e0027267625ULL, 0x000fc800078e0014ULL, 0x00005e0045447625ULL, 0x000fc800078e0014ULL,
0x00005e0047467625ULL, 0x000fc800078e0014ULL, 0x00005e004f4e7625ULL, 0x000fc800078e0014ULL,
0x0000001053267825ULL, 0x000fc800078e0026ULL, 0x0000001053447825ULL, 0x000fc800078e0044ULL,
0x0000001053467825ULL, 0x000fc800078e0046ULL, 0x00000010534c7825ULL, 0x000fc800078e004cULL,
0x00000010534e7825ULL, 0x000fc800078e004eULL, 0x0000001053507825ULL, 0x000fc800078e0050ULL,
0x0000000457537824ULL, 0x000fe400078e00ffULL, 0x0000000459577824ULL, 0x000fe200078e00ffULL,
0x000000025b597819ULL, 0x000fe200000006ffULL, 0x000000045d5b7824ULL, 0x000fe200078e00ffULL,
0xfffffffc53537812ULL, 0x000fe200078ee210ULL, 0x0000001055557824ULL, 0x000fe200078e0224ULL,
0xfffffffc57577812ULL, 0x100fe200078ee210ULL, 0x000000045f5d7824ULL, 0x000fe200078e00ffULL,
0xfffffffc59597812ULL, 0x100fe400078ee210ULL, 0xfffffffc5b5b7812ULL, 0x100fe200078ee210ULL,
0x0000000026557faeULL, 0x0003e2000c901c46ULL, 0xfffffffc5d5d7812ULL, 0x000fe200078ee210ULL,
0x0000001053277824ULL, 0x102fe200078e0224ULL, 0x0000002459557211ULL, 0x000fe200078e20ffULL,
0x0000001057537824ULL, 0x000fc400078e0224ULL, 0x000000105b577824ULL, 0x100fe200078e0224ULL,
0x0000000044277faeULL, 0x0003e2000d101c46ULL, 0x000000105d597824ULL, 0x000fc600078e0224ULL,
0x0000000046537faeULL, 0x0003e8000d901c46ULL, 0x000000004c557faeULL, 0x0003e8000e101c46ULL,
0x000000004e577faeULL, 0x0003e8000e901c46ULL, 0x0000000050597faeULL, 0x0003e2000f101c46ULL,
0x0000041000007947ULL, 0x000fea0003800000ULL, 0x0000001c19277211ULL, 0x000fe200078ff0ffULL,
0x0000001025257824ULL, 0x000fe200078e0224ULL, 0x0000000c1a597812ULL, 0x000fc400078efcffULL,
0x0000000819457811ULL, 0x020fe200078ff0ffULL, 0x00005e0027267625ULL, 0x000fe200078e0014ULL,
0x00000010194d7811ULL, 0x040fe400078ff0ffULL, 0x00000018195b7811ULL, 0x000fe200078ff0ffULL,
0x0000000145477824ULL, 0x000fe200078e021cULL, 0x00000020195d7811ULL, 0x000fe200078ff0ffULL,
0x0000001059267825ULL, 0x000fe200078e0026ULL, 0x00000028195f7811ULL, 0x040fe400078ff0ffULL,
0x0000003019617811ULL, 0x000fe200078ff0ffULL, 0x000000044d577824ULL, 0x000fe200078e00ffULL,
0x0000000245557819ULL, 0x000fe200000006ffULL, 0x000000014d457824ULL, 0x100fe200078e021cULL,
0x0000003819637811ULL, 0x000fe200078ff0ffULL, 0x000000015b4d7824ULL, 0x100fe200078e021cULL,
0x0000001c5f517210ULL, 0x000fe20007ffe0ffULL, 0x000000015d4f7824ULL, 0x100fe200078e021cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026257faeULL, 0x0003e2000b901c46ULL,
0x0000000161537824ULL, 0x000fe200078e021cULL, 0xfffffffc55557812ULL, 0x000fe200078ee210ULL,
0x0000000163657824ULL, 0x000fe200078e021cULL, 0xfffffffc57577812ULL, 0x000fe200078ee210ULL,
0x00005e0045447625ULL, 0x000fc800078e0014ULL, 0x0000001055557824ULL, 0x000fe400078e0224ULL,
0x0000001059447825ULL, 0x000fc800078e0044ULL, 0x00005e0047267625ULL, 0x002fc800078e0014ULL,
0x00005e004d467625ULL, 0x000fc800078e0014ULL, 0x00005e004f4c7625ULL, 0x000fc800078e0014ULL,
0x00005e00514e7625ULL, 0x000fc800078e0014ULL, 0x00005e0053507625ULL, 0x000fc800078e0014ULL,
0x00005e0065527625ULL, 0x000fc800078e0014ULL, 0x0000001059267825ULL, 0x000fc800078e0026ULL,
0x0000001059467825ULL, 0x040fe200078e0046ULL, 0x0000000026557faeULL, 0x0003e6000b901c46ULL,
0x00000010594c7825ULL, 0x000fc800078e004cULL, 0x00000010594e7825ULL, 0x000fc800078e004eULL,
0x0000001059507825ULL, 0x000fc800078e0050ULL, 0x0000001059527825ULL, 0x000fe200078e0052ULL,
0x000000025b597819ULL, 0x000fc600000006ffULL, 0x000000045d5b7824ULL, 0x000fe200078e00ffULL,
0xfffffffc59597812ULL, 0x100fe200078ee210ULL, 0x000000045f5d7824ULL, 0x000fe400078e00ffULL,
0x00000004615f7824ULL, 0x000fe200078e00ffULL, 0xfffffffc5b5b7812ULL, 0x100fe200078ee210ULL,
0x0000000463617824ULL, 0x000fe200078e00ffULL, 0xfffffffc5d5d7812ULL, 0x000fe200078ee210ULL,
0x0000001057577824ULL, 0x000fe200078e0224ULL, 0xfffffffc5f5f7812ULL, 0x100fe400078ee210ULL,
0xfffffffc61617812ULL, 0x000fe200078ee210ULL, 0x000000105d557824ULL, 0x002fe200078e0224ULL,
0x0000000044577faeULL, 0x0003e2000b901c46ULL, 0x0000002459277211ULL, 0x000fc400078e20ffULL,
0x0000001061597824ULL, 0x000fc600078e0224ULL, 0x0000000046277faeULL, 0x0005e2000b901c46ULL,
0x000000105b457824ULL, 0x102fe400078e0224ULL, 0x000000105f577824ULL, 0x000fc600078e0224ULL,
0x000000004c457faeULL, 0x0005e8000b901c46ULL, 0x000000004e557faeULL, 0x0005e8000b901c46ULL,
0x0000000050577faeULL, 0x0005e8000b901c46ULL, 0x0000000052597faeULL, 0x0005e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000812267810ULL, 0x000fe20007ffe0ffULL,
0x0000002013447824ULL, 0x042fe200078e00ffULL, 0x0000000513277819ULL, 0x004fc800000006ffULL,
0xffffffe027267812ULL, 0x000fe400078ee226ULL, 0x0000000a12277810ULL, 0x000fc60007ffe0ffULL,
0x0000001026267824ULL, 0x000fe200078e00ffULL, 0xffffffe044277812ULL, 0x000fca00078ee227ULL,
0x0000001027277824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000001b68783bULL, 0x000fe80000000200ULL, 0x000000002660783bULL, 0x000e680000000200ULL,
0x000000001d6c783bULL, 0x000ea80000000200ULL, 0x000000001e64783bULL, 0x000ee80000000200ULL,
0x000000001f5c783bULL, 0x000f280000000200ULL, 0x000000002058783bULL, 0x000fe80000000200ULL,
0x000000002744783bULL, 0x000ee80000000200ULL, 0x000000002154783bULL, 0x000ee80000000200ULL,
0x000000002250783bULL, 0x000ee80000000200ULL, 0x00000000234c783bULL, 0x000ee20000000200ULL,
0x000000686028723cULL, 0x042f700000041828ULL, 0x0000006a602c723cULL, 0x040f70000004182cULL,
0x0000006c6030723cULL, 0x044f700000041830ULL, 0x0000006e6034723cULL, 0x040f700000041834ULL,
0x000000646038723cULL, 0x048f700000041838ULL, 0x00000066603c723cULL, 0x040f70000004183cULL,
0x0000005c6040723cULL, 0x050f700000041840ULL, 0x0000005e6048723cULL, 0x000f700000041848ULL,
0x000000584428723cULL, 0x060b700000041828ULL, 0x0000005a442c723cULL, 0x040b70000004182cULL,
0x000000544430723cULL, 0x040b700000041830ULL, 0x000000564434723cULL, 0x040b700000041834ULL,
0x000000504438723cULL, 0x040b700000041838ULL, 0x00000052443c723cULL, 0x040b70000004183cULL,
0x0000004c4440723cULL, 0x040b700000041840ULL, 0x0000004e4444723cULL, 0x000b620000041848ULL,
0x000004b000008947ULL, 0x000fce0003800000ULL, 0x00000002ff4b7819ULL, 0x020fe20000011619ULL,
0x00000001034a7824ULL, 0x000fe200078e0a16ULL, 0x000000101a537812ULL, 0x000fc400078efcffULL,
0x0000001c4b277210ULL, 0x040fe40007ffe0ffULL, 0x000000084b497810ULL, 0x040fe40007ffe0ffULL,
0x0000004a4b00720cULL, 0x000fe20003f26070ULL, 0x00005e0027267625ULL, 0x000fe200078e0014ULL,
0x0000004a4900720cULL, 0x000fe40003f46070ULL, 0x000000184b577810ULL, 0x000fe20007ffe0ffULL,
0x00000001494d7824ULL, 0x000fe200078e021cULL, 0x000000204b597810ULL, 0x000fe20007ffe0ffULL,
0x00000004494f7824ULL, 0x000fe200078e00ffULL, 0x000000284b5b7810ULL, 0x000fe20007ffe0ffULL,
0x00005e004d487625ULL, 0x000fe200078e0014ULL, 0x000000304b5d7810ULL, 0x000fc40007ffe0ffULL,
0xfffffffc4f4c7812ULL, 0x000fe200078ee210ULL, 0x0000001053267825ULL, 0x000fe200078e0026ULL,
0x000000104b4f7810ULL, 0x040fe40007ffe0ffULL, 0x000000384b5f7810ULL, 0x000fe20007ffe0ffULL,
0x000000104c4d7824ULL, 0x000fe200078e0211ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000260f7faeULL, 0x0003e2000c901c46ULL, 0x0000001053487825ULL, 0x000fe200078e0048ULL,
0x000000024f557819ULL, 0x040fe400000006ffULL, 0x0000004a4f00720cULL, 0x080fe20003f26070ULL,
0x00000001594b7824ULL, 0x000fe200078e021cULL, 0x00000000484d7faeULL, 0x0005e2000d101c46ULL,
0x0000004a5700720cULL, 0x000fc40003f46070ULL, 0x0000001c5f517210ULL, 0x000fe40007ffe0ffULL,
0xfffffffc55527812ULL, 0x000fe200078ee210ULL, 0x000000014f277824ULL, 0x102fe200078e021cULL,
0x0000004a5900720cULL, 0x080fe20003f66070ULL, 0x000000015d4f7824ULL, 0x100fe200078e021cULL,
0x0000004a5b00720cULL, 0x000fe20003f86070ULL, 0x00005e0027267625ULL, 0x000fe200078e0014ULL,
0x0000004a5d00720cULL, 0x080fe40003fa6070ULL, 0x0000004a5f00720cULL, 0x000fe20003fc6070ULL,
0x0000000157497824ULL, 0x104fe200078e021cULL, 0x000000025d5d7819ULL, 0x000fe200000006ffULL,
0x000000015b4d7824ULL, 0x000fc400078e021cULL, 0x0000000457577824ULL, 0x000fe200078e00ffULL,
0xfffffffc5d587812ULL, 0x100fe200078ee210ULL, 0x0000000459597824ULL, 0x000fe400078e00ffULL,
0x000000045b5b7824ULL, 0x000fe400078e00ffULL, 0x00005e0049487625ULL, 0x080fe200078e0014ULL,
0xfffffffc59547812ULL, 0x100fe400078ee210ULL, 0xfffffffc5b567812ULL, 0x000fe200078ee210ULL,
0x00005e004b4a7625ULL, 0x000fc800078e0014ULL, 0x00005e004d4c7625ULL, 0x000fc800078e0014ULL,
0x00005e004f4e7625ULL, 0x000fc800078e0014ULL, 0x00005e0051507625ULL, 0x000fc800078e0014ULL,
0x0000001052557824ULL, 0x000fe200078e0211ULL, 0xfffffffc57527812ULL, 0x000fe200078ee210ULL,
0x0000001053267825ULL, 0x000fe200078e0026ULL, 0x0000001158577211ULL, 0x000fc600078e20ffULL,
0x000000045f5f7824ULL, 0x000fe200078e00ffULL, 0x0000000026557faeULL, 0x0003e2000c901c46ULL,
0x0000001053487825ULL, 0x000fc600078e0048ULL, 0xfffffffc5f5a7812ULL, 0x000fe200078ee210ULL,
0x00000010534a7825ULL, 0x000fc800078e004aULL, 0x00000010534c7825ULL, 0x000fc800078e004cULL,
0x00000010534e7825ULL, 0x000fc800078e004eULL, 0x0000001053507825ULL, 0x000fc800078e0050ULL,
0x0000001052277824ULL, 0x102fe400078e0211ULL, 0x0000001054537824ULL, 0x100fe400078e0211ULL,
0x0000001056557824ULL, 0x100fe200078e0211ULL, 0x0000000048277faeULL, 0x0003e2000d101c46ULL,
0x000000105a597824ULL, 0x000fc600078e0211ULL, 0x000000004a537faeULL, 0x0003e8000d901c46ULL,
0x000000004c557faeULL, 0x0003e8000e101c46ULL, 0x000000004e577faeULL, 0x0003e8000e901c46ULL,
0x0000000050597faeULL, 0x0003e2000f101c46ULL, 0x0000040000007947ULL, 0x000fea0003800000ULL,
0x0000001c19277211ULL, 0x000fe400078ff0ffULL, 0x000000101a557812ULL, 0x020fc400078efcffULL,
0x0000000819497811ULL, 0x000fe200078ff0ffULL, 0x00005e0027267625ULL, 0x000fe200078e0014ULL,
0x00000010194d7811ULL, 0x040fe400078ff0ffULL, 0x00000018195b7811ULL, 0x000fe200078ff0ffULL,
0x00000001494b7824ULL, 0x000fe200078e021cULL, 0x00000020195d7811ULL, 0x000fe200078ff0ffULL,
0x0000001055267825ULL, 0x000fe200078e0026ULL, 0x00000028195f7811ULL, 0x040fe400078ff0ffULL,
0x0000003019617811ULL, 0x000fe200078ff0ffULL, 0x0000000449597824ULL, 0x000fe200078e00ffULL,
0x0000003819637811ULL, 0x000fe200078ff0ffULL, 0x000000014d497824ULL, 0x140fe200078e021cULL,
0x000000024d657819ULL, 0x000fe200000006ffULL, 0x000000015b4d7824ULL, 0x100fe200078e021cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000260f7faeULL, 0x0003e2000b901c46ULL,
0x000000015d4f7824ULL, 0x100fe200078e021cULL, 0x0000001c63577210ULL, 0x000fe20007ffe0ffULL,
0x000000015f517824ULL, 0x000fe200078e021cULL, 0xfffffffc59547812ULL, 0x000fe200078ee210ULL,
0x0000000161537824ULL, 0x000fe200078e021cULL, 0xfffffffc65567812ULL, 0x000fe200078ee210ULL,
0x00005e0049487625ULL, 0x000fe200078e0014ULL, 0x000000025f5f7819ULL, 0x000fc600000006ffULL,
0x000000045b5b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc5f587812ULL, 0x000fe200078ee210ULL,
0x00005e004b267625ULL, 0x002fc800078e0014ULL, 0x00005e004d4a7625ULL, 0x000fc800078e0014ULL,
0x00005e004f4c7625ULL, 0x000fc800078e0014ULL, 0x00005e00514e7625ULL, 0x000fc800078e0014ULL,
0x00005e0053507625ULL, 0x000fc800078e0014ULL, 0x000000045d5d7824ULL, 0x000fe400078e00ffULL,
0x00005e0057527625ULL, 0x000fc800078e0014ULL, 0x0000001054577824ULL, 0x000fe200078e0211ULL,
0xfffffffc5b547812ULL, 0x000fe200078ee210ULL, 0x0000001055267825ULL, 0x000fc800078e0026ULL,
0x0000000461617824ULL, 0x000fe200078e00ffULL, 0x0000000026577faeULL, 0x0003e2000b901c46ULL,
0x0000000463637824ULL, 0x000fe400078e00ffULL, 0x0000001056597824ULL, 0x000fe200078e0211ULL,
0xfffffffc5d567812ULL, 0x000fe200078ee210ULL, 0x0000001055487825ULL, 0x000fe200078e0048ULL,
0xfffffffc615a7812ULL, 0x000fc600078ee210ULL, 0x00000010554a7825ULL, 0x000fe200078e004aULL,
0x0000000048597faeULL, 0x0005e2000b901c46ULL, 0xfffffffc63267812ULL, 0x002fe400078ee210ULL,
0x0000001054277824ULL, 0x000fe400078e0211ULL, 0x00000010554c7825ULL, 0x000fc600078e004cULL,
0x000000004a277faeULL, 0x0003e2000b901c46ULL, 0x00000010554e7825ULL, 0x000fc800078e004eULL,
0x0000001055507825ULL, 0x000fc800078e0050ULL, 0x0000001055527825ULL, 0x000fe200078e0052ULL,
0x0000001158557211ULL, 0x000fc600078e20ffULL, 0x0000001056497824ULL, 0x104fe400078e0211ULL,
0x000000105a577824ULL, 0x100fe400078e0211ULL, 0x0000001026597824ULL, 0x000fe200078e0211ULL,
0x000000004c497faeULL, 0x0003e8000b901c46ULL, 0x000000004e557faeULL, 0x0003e8000b901c46ULL,
0x0000000050577faeULL, 0x0003e8000b901c46ULL, 0x0000000052597faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000002013277824ULL, 0x002fe200078e00ffULL,
0x0000000c12267810ULL, 0x000fc40007ffe0ffULL, 0x0000000513487819ULL, 0x000fe400000006ffULL,
0xffffffe027267812ULL, 0x000fe400078ee226ULL, 0x0000000e12277810ULL, 0x000fc60007ffe0ffULL,
0x0000001026267824ULL, 0x000fe200078e00ffULL, 0xffffffe048277812ULL, 0x000fca00078ee227ULL,
0x0000001027277824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000000e68783bULL, 0x000fe80000000200ULL, 0x000000002660783bULL, 0x000e680000000200ULL,
0x000000000c6c783bULL, 0x000ea80000000200ULL, 0x000000000b64783bULL, 0x000ee80000000200ULL,
0x000000000a5c783bULL, 0x000f280000000200ULL, 0x000000000958783bULL, 0x000fe80000000200ULL,
0x000000002748783bULL, 0x000ee80000000200ULL, 0x000000000854783bULL, 0x000ee80000000200ULL,
0x000000000750783bULL, 0x000ee80000000200ULL, 0x00000000064c783bULL, 0x000ee20000000200ULL,
0x000000686028723cULL, 0x042f700000041828ULL, 0x0000006a602c723cULL, 0x040f70000004182cULL,
0x0000006c6030723cULL, 0x044f700000041830ULL, 0x0000006e6034723cULL, 0x040f700000041834ULL,
0x000000646038723cULL, 0x048f700000041838ULL, 0x00000066603c723cULL, 0x040f70000004183cULL,
0x0000005c6040723cULL, 0x050f700000041840ULL, 0x0000005e6044723cULL, 0x000f700000041844ULL,
0x000000584828723cULL, 0x060b700000041828ULL, 0x0000005a482c723cULL, 0x040b70000004182cULL,
0x000000544830723cULL, 0x040b700000041830ULL, 0x000000564834723cULL, 0x040b700000041834ULL,
0x000000504838723cULL, 0x040b700000041838ULL, 0x00000052483c723cULL, 0x040b70000004183cULL,
0x0000004c4840723cULL, 0x040b700000041840ULL, 0x0000004e4844723cULL, 0x000b620000041844ULL,
0x000004b000008947ULL, 0x000fce0003800000ULL, 0x00000002ff4b7819ULL, 0x020fe20000011619ULL,
0x00000001034a7824ULL, 0x000fe200078e0a16ULL, 0x000000141a537812ULL, 0x000fc400078efcffULL,
0x000000084b497810ULL, 0x040fe20007ffe0ffULL, 0x000000014b277824ULL, 0x140fe200078e021cULL,
0x0000004a4b00720cULL, 0x080fe40003f26070ULL, 0x00000002494f7819ULL, 0x040fe200000006ffULL,
0x00000001494d7824ULL, 0x040fe200078e021cULL, 0x0000004a4900720cULL, 0x000fe20003f46070ULL,
0x00005e0027267625ULL, 0x080fe200078e0014ULL, 0x000000184b577810ULL, 0x040fe40007ffe0ffULL,
0x000000204b597810ULL, 0x000fe20007ffe0ffULL, 0x00005e004d487625ULL, 0x000fe200078e0014ULL,
0xfffffffc4f4d7812ULL, 0x000fc400078ee210ULL, 0x000000104b4f7810ULL, 0x000fe20007ffe0ffULL,
0x0000001053267825ULL, 0x000fe200078e0026ULL, 0x000000284b5b7810ULL, 0x040fe40007ffe0ffULL,
0x000000304b5d7810ULL, 0x000fe20007ffe0ffULL, 0x000000104d4d7824ULL, 0x000fe200078e0224ULL,
0x000000384b5f7810ULL, 0x000fe20007ffe0ffULL, 0x0000001053487825ULL, 0x000fe200078e0048ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026257faeULL, 0x0003e2000c901c46ULL,
0x0000004a4f00720cULL, 0x040fe40003f26070ULL, 0x000000044f557824ULL, 0x000fe200078e00ffULL,
0x00000000484d7faeULL, 0x0005e2000d101c46ULL, 0x0000001c594b7210ULL, 0x000fe20007ffe0ffULL,
0x000000015f517824ULL, 0x000fe200078e021cULL, 0x0000004a5700720cULL, 0x000fc40003f46070ULL,
0x0000004a5900720cULL, 0x000fe20003f66070ULL, 0x00005e0051507625ULL, 0x000fe200078e0014ULL,
0x0000004a5b00720cULL, 0x080fe40003f86070ULL, 0x0000004a5d00720cULL, 0x080fe20003fa6070ULL,
0x000000014f277824ULL, 0x102fe200078e021cULL, 0x0000004a5f00720cULL, 0x000fe20003fc6070ULL,
0x0000000157497824ULL, 0x004fe200078e021cULL, 0xfffffffc55557812ULL, 0x000fe200078ee210ULL,
0x000000015b4d7824ULL, 0x100fe400078e021cULL, 0x000000015d4f7824ULL, 0x000fc400078e021cULL,
0x00005e0027267625ULL, 0x000fc800078e0014ULL, 0x00005e0049487625ULL, 0x000fc800078e0014ULL,
0x00005e004b4a7625ULL, 0x000fc800078e0014ULL, 0x00005e004d4c7625ULL, 0x000fc800078e0014ULL,
0x00005e004f4e7625ULL, 0x000fc800078e0014ULL, 0x0000001053267825ULL, 0x000fc800078e0026ULL,
0x0000001053487825ULL, 0x000fc800078e0048ULL, 0x00000010534a7825ULL, 0x000fc800078e004aULL,
0x00000010534c7825ULL, 0x000fc800078e004cULL, 0x00000010534e7825ULL, 0x000fc800078e004eULL,
0x0000001053507825ULL, 0x000fe200078e0050ULL, 0x0000000257537819ULL, 0x000fc600000006ffULL,
0x0000000459577824ULL, 0x000fe200078e00ffULL, 0xfffffffc53537812ULL, 0x100fe200078ee210ULL,
0x000000045b597824ULL, 0x000fe400078e00ffULL, 0x000000045d5b7824ULL, 0x000fe200078e00ffULL,
0xfffffffc57577812ULL, 0x100fe200078ee210ULL, 0x000000045f5d7824ULL, 0x000fe200078e00ffULL,
0xfffffffc59597812ULL, 0x000fe200078ee210ULL, 0x0000001055557824ULL, 0x000fe200078e0224ULL,
0xfffffffc5b5b7812ULL, 0x000fe200078ee210ULL, 0x0000001057577824ULL, 0x000fe200078e0224ULL,
0xfffffffc5d5d7812ULL, 0x000fe200078ee210ULL, 0x0000001059597824ULL, 0x100fe200078e0224ULL,
0x0000002453537211ULL, 0x000fe200078e20ffULL, 0x000000105b5b7824ULL, 0x100fe200078e0224ULL,
0x0000000026557faeULL, 0x0003e2000c901c46ULL, 0x000000105d5d7824ULL, 0x000fc600078e0224ULL,
0x0000000048537faeULL, 0x0003e8000d101c46ULL, 0x000000004a577faeULL, 0x0003e8000d901c46ULL,
0x000000004c597faeULL, 0x0003e8000e101c46ULL, 0x000000004e5b7faeULL, 0x0003e8000e901c46ULL,
0x00000000505d7faeULL, 0x0003e2000f101c46ULL, 0x0000040000007947ULL, 0x000fea0003800000ULL,
0x0000001c19277211ULL, 0x000fe400078ff0ffULL, 0x000000141a557812ULL, 0x020fc400078efcffULL,
0x0000000819497811ULL, 0x000fe200078ff0ffULL, 0x00005e0027267625ULL, 0x000fe200078e0014ULL,
0x00000010194d7811ULL, 0x040fe400078ff0ffULL, 0x00000018195b7811ULL, 0x000fe200078ff0ffULL,
0x0000000449577824ULL, 0x000fe200078e00ffULL, 0x00000020195d7811ULL, 0x000fe200078ff0ffULL,
0x0000001055267825ULL, 0x000fe200078e0026ULL, 0x00000028195f7811ULL, 0x040fe400078ff0ffULL,
0x0000003019617811ULL, 0x000fe200078ff0ffULL, 0x000000044d597824ULL, 0x000fe200078e00ffULL,
0x0000001c494b7210ULL, 0x080fe20007ffe0ffULL, 0x000000014d497824ULL, 0x100fe200078e021cULL,
0x0000003819637811ULL, 0x000fe200078ff0ffULL, 0x000000015b4d7824ULL, 0x100fe200078e021cULL,
0x0000001c5d4f7210ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026257faeULL, 0x0003e2000b901c46ULL, 0x000000015f517824ULL, 0x000fe200078e021cULL,
0xfffffffc57577812ULL, 0x000fe200078ee210ULL, 0x0000000161537824ULL, 0x000fe200078e021cULL,
0xfffffffc59597812ULL, 0x000fe200078ee210ULL, 0x0000000163657824ULL, 0x040fe200078e021cULL,
0x0000000263637819ULL, 0x000fe200000006ffULL, 0x00005e0049487625ULL, 0x000fe200078e0014ULL,
0x0000002459597211ULL, 0x000fc600078e20ffULL, 0x0000001057577824ULL, 0x000fe400078e0224ULL,
0x00005e004b267625ULL, 0x002fc800078e0014ULL, 0x00005e004d4a7625ULL, 0x000fc800078e0014ULL,
0x00005e004f4c7625ULL, 0x000fc800078e0014ULL, 0x00005e00514e7625ULL, 0x000fc800078e0014ULL,
0x00005e0053507625ULL, 0x000fc800078e0014ULL, 0x00005e0065527625ULL, 0x000fc800078e0014ULL,
0x0000001055267825ULL, 0x000fc800078e0026ULL, 0x0000001055487825ULL, 0x040fe200078e0048ULL,
0x0000000026577faeULL, 0x0003e6000b901c46ULL, 0x00000010554a7825ULL, 0x040fe200078e004aULL,
0x0000000048597faeULL, 0x0005e6000b901c46ULL, 0x00000010554c7825ULL, 0x000fc800078e004cULL,
0x00000010554e7825ULL, 0x000fe200078e004eULL, 0xfffffffc63277812ULL, 0x002fc600078ee210ULL,
0x0000001055507825ULL, 0x000fe200078e0050ULL, 0x0000002427277211ULL, 0x000fc600078e20ffULL,
0x0000001055527825ULL, 0x000fc800078e0052ULL, 0x000000045b557824ULL, 0x000fe400078e00ffULL,
0x000000045d5b7824ULL, 0x000fe400078e00ffULL, 0x000000045f5d7824ULL, 0x000fe200078e00ffULL,
0xfffffffc55557812ULL, 0x100fe200078ee210ULL, 0x00000004615f7824ULL, 0x000fe200078e00ffULL,
0xfffffffc5b5b7812ULL, 0x100fe400078ee210ULL, 0xfffffffc5d5d7812ULL, 0x000fe200078ee210ULL,
0x0000001055557824ULL, 0x000fe200078e0224ULL, 0xfffffffc5f5f7812ULL, 0x000fe200078ee210ULL,
0x000000105b5b7824ULL, 0x000fc400078e0224ULL, 0x000000105d5d7824ULL, 0x100fe200078e0224ULL,
0x000000004a557faeULL, 0x0005e2000b901c46ULL, 0x000000105f5f7824ULL, 0x000fc600078e0224ULL,
0x000000004c5b7faeULL, 0x0005e8000b901c46ULL, 0x000000004e5d7faeULL, 0x0005e8000b901c46ULL,
0x00000000505f7faeULL, 0x0005e8000b901c46ULL, 0x0000000052277faeULL, 0x0005e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000002013277824ULL, 0x046fe200078e00ffULL,
0x0000001012267810ULL, 0x000fe20007ffe0ffULL, 0x0000002013487824ULL, 0x000fc600078e00ffULL,
0xffffffe027267812ULL, 0x000fe400078ee226ULL, 0x0000001212277810ULL, 0x000fc60007ffe0ffULL,
0x0000001026267824ULL, 0x000fe200078e00ffULL, 0xffffffe048277812ULL, 0x000fca00078ee227ULL,
0x0000001027277824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000001b68783bULL, 0x000fe80000000200ULL, 0x000000002660783bULL, 0x000e680000000200ULL,
0x000000001d6c783bULL, 0x000ea80000000200ULL, 0x000000001e64783bULL, 0x000ee80000000200ULL,
0x000000001f5c783bULL, 0x000f280000000200ULL, 0x000000002058783bULL, 0x000fe80000000200ULL,
0x000000002748783bULL, 0x000ee80000000200ULL, 0x000000002154783bULL, 0x000ee80000000200ULL,
0x000000002250783bULL, 0x000ee80000000200ULL, 0x00000000234c783bULL, 0x000ee20000000200ULL,
0x000000686028723cULL, 0x042f700000041828ULL, 0x0000006a602c723cULL, 0x040f70000004182cULL,
0x0000006c6030723cULL, 0x044f700000041830ULL, 0x0000006e6034723cULL, 0x040f700000041834ULL,
0x000000646038723cULL, 0x048f700000041838ULL, 0x00000066603c723cULL, 0x040f70000004183cULL,
0x0000005c6040723cULL, 0x050f700000041840ULL, 0x0000005e6044723cULL, 0x000f700000041844ULL,
0x000000584828723cULL, 0x060b700000041828ULL, 0x0000005a482c723cULL, 0x040b70000004182cULL,
0x000000544830723cULL, 0x040b700000041830ULL, 0x000000564834723cULL, 0x040b700000041834ULL,
0x000000504838723cULL, 0x040b700000041838ULL, 0x00000052483c723cULL, 0x040b70000004183cULL,
0x0000004c4840723cULL, 0x040b700000041840ULL, 0x0000004e4844723cULL, 0x000b620000041844ULL,
0x000004b000008947ULL, 0x000fce0003800000ULL, 0x00000002ff4b7819ULL, 0x020fe40000011619ULL,
0x80000016034a7210ULL, 0x000fc40007ffe0ffULL, 0x000000084b497810ULL, 0x040fe20007ffe0ffULL,
0x000000014b277824ULL, 0x140fe200078e021cULL, 0x0000004a4b00720cULL, 0x000fe40003f26070ULL,
0x000000181a537812ULL, 0x000fe200078efcffULL, 0x00005e0027267625ULL, 0x000fe200078e0014ULL,
0x0000004a4900720cULL, 0x000fe40003f46070ULL, 0x000000184b577810ULL, 0x000fe20007ffe0ffULL,
0x00000001494d7824ULL, 0x000fe200078e021cULL, 0x000000204b597810ULL, 0x000fe20007ffe0ffULL,
0x00000004494f7824ULL, 0x000fe200078e00ffULL, 0x000000284b5b7810ULL, 0x000fe20007ffe0ffULL,
0x00005e004d487625ULL, 0x000fe200078e0014ULL, 0x000000304b5d7810ULL, 0x000fc40007ffe0ffULL,
0xfffffffc4f4c7812ULL, 0x000fe200078ee210ULL, 0x0000001053267825ULL, 0x000fe200078e0026ULL,
0x000000104b4f7810ULL, 0x040fe40007ffe0ffULL, 0x000000384b5f7810ULL, 0x000fe20007ffe0ffULL,
0x000000104c4d7824ULL, 0x000fe200078e0211ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000260f7faeULL, 0x0003e2000c901c46ULL, 0x0000001053487825ULL, 0x000fe200078e0048ULL,
0x0000004a4f00720cULL, 0x080fe40003f26070ULL, 0x0000004a5900720cULL, 0x080fe20003f66070ULL,
0x000000044f557824ULL, 0x000fe200078e00ffULL, 0x00000000484d7faeULL, 0x0005e2000d101c46ULL,
0x0000004a5700720cULL, 0x080fe20003f46070ULL, 0x00000001594b7824ULL, 0x100fe200078e021cULL,
0x0000004a5d00720cULL, 0x000fe20003fa6070ULL, 0x000000015f517824ULL, 0x000fe200078e021cULL,
0xfffffffc55527812ULL, 0x000fe200078ee210ULL, 0x0000000459597824ULL, 0x000fe200078e00ffULL,
0x0000001c4f277210ULL, 0x002fe20007ffe0ffULL, 0x00005e0051507625ULL, 0x000fe200078e0014ULL,
0x0000001c5d4f7210ULL, 0x000fc40007ffe0ffULL, 0x0000004a5b00720cULL, 0x000fe20003f86070ULL,
0x00005e0027267625ULL, 0x000fe200078e0014ULL, 0x0000004a5f00720cULL, 0x000fe40003fc6070ULL,
0xfffffffc59547812ULL, 0x000fe200078ee210ULL, 0x0000000157497824ULL, 0x104fe400078e021cULL,
0x000000015b4d7824ULL, 0x040fe200078e021cULL, 0x000000025b5b7819ULL, 0x000fe200000006ffULL,
0x0000000457577824ULL, 0x000fe400078e00ffULL, 0x000000045d5d7824ULL, 0x000fe200078e00ffULL,
0xfffffffc5b567812ULL, 0x000fe200078ee210ULL, 0x00005e0049487625ULL, 0x000fc600078e0014ULL,
0xfffffffc5d587812ULL, 0x000fe200078ee210ULL, 0x00005e004b4a7625ULL, 0x000fc800078e0014ULL,
0x00005e004d4c7625ULL, 0x000fc800078e0014ULL, 0x00005e004f4e7625ULL, 0x000fc800078e0014ULL,
0x0000001052557824ULL, 0x000fe200078e0211ULL, 0xfffffffc57527812ULL, 0x000fe200078ee210ULL,
0x0000001053267825ULL, 0x000fc800078e0026ULL, 0x000000045f5f7824ULL, 0x000fe200078e00ffULL,
0x0000000026557faeULL, 0x0003e2000c901c46ULL, 0x0000001053487825ULL, 0x000fc600078e0048ULL,
0xfffffffc5f5a7812ULL, 0x000fe200078ee210ULL, 0x00000010534a7825ULL, 0x000fc800078e004aULL,
0x00000010534c7825ULL, 0x000fe200078e004cULL, 0x0000001156557211ULL, 0x002fc600078e20ffULL,
0x00000010534e7825ULL, 0x000fc800078e004eULL, 0x0000001053507825ULL, 0x000fc800078e0050ULL,
0x0000001052277824ULL, 0x100fe400078e0211ULL, 0x0000001054537824ULL, 0x100fe400078e0211ULL,
0x0000001058577824ULL, 0x100fe200078e0211ULL, 0x0000000048277faeULL, 0x0003e2000d101c46ULL,
0x000000105a597824ULL, 0x000fc600078e0211ULL, 0x000000004a537faeULL, 0x0003e8000d901c46ULL,
0x000000004c557faeULL, 0x0003e8000e101c46ULL, 0x000000004e577faeULL, 0x0003e8000e901c46ULL,
0x0000000050597faeULL, 0x0003e2000f101c46ULL, 0x0000040000007947ULL, 0x000fea0003800000ULL,
0x0000001c19277211ULL, 0x000fe400078ff0ffULL, 0x000000181a557812ULL, 0x020fc400078efcffULL,
0x0000000819497811ULL, 0x000fe200078ff0ffULL, 0x00005e0027267625ULL, 0x000fe200078e0014ULL,
0x00000010194d7811ULL, 0x040fe400078ff0ffULL, 0x00000018195b7811ULL, 0x000fe200078ff0ffULL,
0x00000001494b7824ULL, 0x000fe200078e021cULL, 0x00000020195d7811ULL, 0x000fe200078ff0ffULL,
0x0000001055267825ULL, 0x000fe200078e0026ULL, 0x00000028195f7811ULL, 0x040fe400078ff0ffULL,
0x0000003019617811ULL, 0x000fe200078ff0ffULL, 0x0000000449597824ULL, 0x000fe200078e00ffULL,
0x0000003819637811ULL, 0x000fe200078ff0ffULL, 0x000000044d657824ULL, 0x040fe200078e00ffULL,
0x0000001c4d497210ULL, 0x080fe20007ffe0ffULL, 0x000000015b4d7824ULL, 0x100fe200078e021cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000260f7faeULL, 0x0003e2000b901c46ULL,
0x000000015d4f7824ULL, 0x100fe200078e021cULL, 0x0000001c61537210ULL, 0x000fe20007ffe0ffULL,
0x000000015f517824ULL, 0x000fe200078e021cULL, 0xfffffffc59547812ULL, 0x000fe200078ee210ULL,
0x0000000163577824ULL, 0x000fe200078e021cULL, 0xfffffffc65567812ULL, 0x000fe200078ee210ULL,
0x00005e0049487625ULL, 0x000fe200078e0014ULL, 0x000000025d5d7819ULL, 0x000fc600000006ffULL,
0x000000045b5b7824ULL, 0x000fe400078e00ffULL, 0x00005e004b267625ULL, 0x002fc800078e0014ULL,
0x00005e004d4a7625ULL, 0x000fc800078e0014ULL, 0x00005e004f4c7625ULL, 0x000fc800078e0014ULL,
0x00005e00514e7625ULL, 0x000fc800078e0014ULL, 0x00005e0053507625ULL, 0x000fc800078e0014ULL,
0x00005e0057527625ULL, 0x000fc800078e0014ULL, 0x000000045f5f7824ULL, 0x000fe400078e00ffULL,
0x0000001054577824ULL, 0x000fe200078e0211ULL, 0xfffffffc5b547812ULL, 0x000fe200078ee210ULL,
0x0000001055267825ULL, 0x000fe200078e0026ULL, 0xfffffffc5f587812ULL, 0x000fc600078ee210ULL,
0x0000000461617824ULL, 0x000fe200078e00ffULL, 0x0000000026577faeULL, 0x0003e2000b901c46ULL,
0x0000000463637824ULL, 0x000fe400078e00ffULL, 0x0000001056597824ULL, 0x000fe200078e0211ULL,
0xfffffffc5d567812ULL, 0x000fe200078ee210ULL, 0x0000001055487825ULL, 0x000fe200078e0048ULL,
0xfffffffc615a7812ULL, 0x000fc600078ee210ULL, 0x00000010554a7825ULL, 0x000fe200078e004aULL,
0x0000000048597faeULL, 0x0005e2000b901c46ULL, 0xfffffffc63267812ULL, 0x002fe400078ee210ULL,
0x0000001054277824ULL, 0x000fe400078e0211ULL, 0x00000010554c7825ULL, 0x000fc600078e004cULL,
0x000000004a277faeULL, 0x0003e2000b901c46ULL, 0x00000010554e7825ULL, 0x000fe200078e004eULL,
0x0000001156497211ULL, 0x004fc600078e20ffULL, 0x0000001055507825ULL, 0x000fc800078e0050ULL,
0x0000001055527825ULL, 0x000fe200078e0052ULL, 0x000000004c497faeULL, 0x0003e6000b901c46ULL,
0x0000001058557824ULL, 0x100fe400078e0211ULL, 0x000000105a577824ULL, 0x100fe400078e0211ULL,
0x0000001026597824ULL, 0x000fe200078e0211ULL, 0x000000004e557faeULL, 0x0003e8000b901c46ULL,
0x0000000050577faeULL, 0x0003e8000b901c46ULL, 0x0000000052597faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000002013277824ULL, 0x042fe200078e00ffULL,
0x0000001412267810ULL, 0x000fe20007ffe0ffULL, 0x0000002013487824ULL, 0x000fc600078e00ffULL,
0xffffffe027267812ULL, 0x000fe400078ee226ULL, 0x0000001612277810ULL, 0x000fe40007ffe0ffULL,
0x0000000426267819ULL, 0x000fe400000006ffULL, 0xffffffe048277812ULL, 0x000fca00078ee227ULL,
0x0000001027277824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000000e68783bULL, 0x000fe80000000200ULL, 0x000000002660783bULL, 0x000e680000000200ULL,
0x000000000c6c783bULL, 0x000ea80000000200ULL, 0x000000000b64783bULL, 0x000ee80000000200ULL,
0x000000000a5c783bULL, 0x000f280000000200ULL, 0x000000000958783bULL, 0x000fe80000000200ULL,
0x000000002748783bULL, 0x000ee80000000200ULL, 0x000000000854783bULL, 0x000ee80000000200ULL,
0x000000000750783bULL, 0x000ee80000000200ULL, 0x00000000064c783bULL, 0x000ee20000000200ULL,
0x000000686028723cULL, 0x042f700000041828ULL, 0x0000006a602c723cULL, 0x040f70000004182cULL,
0x0000006c6030723cULL, 0x044f700000041830ULL, 0x0000006e6034723cULL, 0x040f700000041834ULL,
0x000000646038723cULL, 0x048f700000041838ULL, 0x00000066603c723cULL, 0x040f70000004183cULL,
0x0000005c6040723cULL, 0x050f700000041840ULL, 0x0000005e6044723cULL, 0x000f700000041844ULL,
0x000000584828723cULL, 0x060b700000041828ULL, 0x0000005a482c723cULL, 0x040b70000004182cULL,
0x000000544830723cULL, 0x040b700000041830ULL, 0x000000564834723cULL, 0x040b700000041834ULL,
0x000000504838723cULL, 0x040b700000041838ULL, 0x00000052483c723cULL, 0x040b70000004183cULL,
0x0000004c4840723cULL, 0x040b700000041840ULL, 0x0000004e4844723cULL, 0x000b620000041844ULL,
0x000004b000008947ULL, 0x000fce0003800000ULL, 0x00000002ff497819ULL, 0x020fe20000011619ULL,
0x0000000103487824ULL, 0x000fe200078e0a16ULL, 0x0000001c1a537812ULL, 0x000fc400078efcffULL,
0x00000008494b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000149277824ULL, 0x040fe200078e021cULL,
0x000000484900720cULL, 0x040fe40003f06070ULL, 0x00000010494d7810ULL, 0x000fe20007ffe0ffULL,
0x00005e0027267625ULL, 0x000fe200078e0014ULL, 0x0000002049517810ULL, 0x040fe40007ffe0ffULL,
0x0000002849557810ULL, 0x040fe40007ffe0ffULL, 0x0000003049577810ULL, 0x000fe20007ffe0ffULL,
0x0000001053267825ULL, 0x000fe200078e0026ULL, 0x00000018494f7810ULL, 0x000fc40007ffe0ffULL,
0x0000003849597810ULL, 0x000fe20007ffe0ffULL, 0x000000014d497824ULL, 0x100fe200078e021cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026257faeULL, 0x0003e2000c101c46ULL,
0x000000484b00720cULL, 0x080fe20003f06070ULL, 0x00000001515b7824ULL, 0x000fe200078e021cULL,
0x000000484d00720cULL, 0x080fe20003f26070ULL, 0x0000000455617824ULL, 0x000fe200078e00ffULL,
0x000000485100720cULL, 0x0c0fe20003f66070ULL, 0x0000000451517824ULL, 0x000fe200078e00ffULL,
0x000000484f00720cULL, 0x000fe20003f46070ULL, 0x0000000457657824ULL, 0x000fe200078e00ffULL,
0xfffffffc61617812ULL, 0x100fe200078ee210ULL, 0x0000000459697824ULL, 0x000fe200078e00ffULL,
0xfffffffc51517812ULL, 0x100fe200078ee210ULL, 0x000000044b277824ULL, 0x042fe200078e00ffULL,
0x0000001c4b257210ULL, 0x080fe20007ffe0ffULL, 0x000000044d4b7824ULL, 0x000fe200078e00ffULL,
0x0000001c4f4d7210ULL, 0x040fe20007ffe0ffULL, 0x000000044f4f7824ULL, 0x000fe200078e00ffULL,
0xfffffffc27277812ULL, 0x000fe200078ee210ULL, 0x0000000157637824ULL, 0x000fe200078e021cULL,
0xfffffffc4b4b7812ULL, 0x000fe200078ee210ULL, 0x00000010515d7824ULL, 0x000fe200078e0224ULL,
0xfffffffc65657812ULL, 0x000fe200078ee210ULL, 0x0000001061617824ULL, 0x000fe200078e0224ULL,
0xfffffffc4f4f7812ULL, 0x000fc400078ee210ULL, 0xfffffffc69697812ULL, 0x000fe200078ee210ULL,
0x0000001065657824ULL, 0x100fe200078e0224ULL, 0x000000485500720cULL, 0x080fe40003f86070ULL,
0x000000485700720cULL, 0x080fe20003fa6070ULL, 0x000000104b577824ULL, 0x100fe200078e0224ULL,
0x000000485900720cULL, 0x000fe20003fc6070ULL, 0x00005e005b4a7625ULL, 0x000fe200078e0014ULL,
0x0000001c555f7210ULL, 0x080fe40007ffe0ffULL, 0x0000001c59677210ULL, 0x000fe20007ffe0ffULL,
0x0000001027557824ULL, 0x000fe200078e0224ULL, 0x000000244f597211ULL, 0x000fe200078e20ffULL,
0x00005e0049267625ULL, 0x000fe200078e0014ULL, 0x0000002469697211ULL, 0x000fc600078e20ffULL,
0x00005e0025247625ULL, 0x000fc800078e0014ULL, 0x00005e004d487625ULL, 0x000fc800078e0014ULL,
0x00005e005f4c7625ULL, 0x000fc800078e0014ULL, 0x00005e00634e7625ULL, 0x000fc800078e0014ULL,
0x00005e0067507625ULL, 0x000fc800078e0014ULL, 0x0000001053247825ULL, 0x000fc800078e0024ULL,
0x0000001053267825ULL, 0x040fe200078e0026ULL, 0x0000000024557faeULL, 0x0003e6000c101c46ULL,
0x0000001053487825ULL, 0x040fe200078e0048ULL, 0x0000000026577faeULL, 0x0003e6000c901c46ULL,
0x00000010534a7825ULL, 0x040fe200078e004aULL, 0x0000000048597faeULL, 0x0003e6000d101c46ULL,
0x00000010534c7825ULL, 0x040fe200078e004cULL, 0x000000004a5d7faeULL, 0x0003e6000d901c46ULL,
0x00000010534e7825ULL, 0x040fe200078e004eULL, 0x000000004c617faeULL, 0x0003e6000e101c46ULL,
0x0000001053507825ULL, 0x000fe200078e0050ULL, 0x000000004e657faeULL, 0x0003e8000e901c46ULL,
0x0000000050697faeULL, 0x0003e2000f101c46ULL, 0x0000040000007947ULL, 0x000fea0003800000ULL,
0x0000001c19277211ULL, 0x040fe400078ff0ffULL, 0x0000000819497811ULL, 0x020fc400078ff0ffULL,
0x0000001c1a537812ULL, 0x000fe200078efcffULL, 0x00005e0027267625ULL, 0x000fe200078e0014ULL,
0x00000010194d7811ULL, 0x040fe400078ff0ffULL, 0x00000018194f7811ULL, 0x000fe200078ff0ffULL,
0x00000001494b7824ULL, 0x000fe200078e021cULL, 0x0000002819557811ULL, 0x000fe200078ff0ffULL,
0x00000004495d7824ULL, 0x000fe200078e00ffULL, 0x0000002019517811ULL, 0x000fe200078ff0ffULL,
0x0000001053267825ULL, 0x000fe200078e0026ULL, 0x0000003819597811ULL, 0x000fc400078ff0ffULL,
0x0000003019577811ULL, 0x000fe200078ff0ffULL, 0x000000014d497824ULL, 0x140fe200078e021cULL,
0x000000024d617819ULL, 0x000fe200000006ffULL, 0x000000014f4d7824ULL, 0x100fe200078e021cULL,
0x0000000257657819ULL, 0x000fe200000006ffULL, 0x00000001555f7824ULL, 0x000fe200078e021cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026257faeULL, 0x0003e2000b901c46ULL,
0x000000044f4f7824ULL, 0x000fe200078e00ffULL, 0xfffffffc65657812ULL, 0x000fe200078ee210ULL,
0x00000001515b7824ULL, 0x040fe200078e021cULL, 0x0000000251517819ULL, 0x000fe200000006ffULL,
0x0000000455557824ULL, 0x000fe200078e00ffULL, 0xfffffffc4f4f7812ULL, 0x100fe200078ee210ULL,
0x0000000459697824ULL, 0x000fe200078e00ffULL, 0xfffffffc51517812ULL, 0x000fe200078ee210ULL,
0x0000000157637824ULL, 0x100fe200078e021cULL, 0x0000002465657211ULL, 0x000fe200078e20ffULL,
0x0000000159677824ULL, 0x000fe200078e021cULL, 0xfffffffc61277812ULL, 0x002fe200078ee210ULL,
0x000000104f597824ULL, 0x000fe200078e0224ULL, 0xfffffffc5d257812ULL, 0x000fe200078ee210ULL,
0x00000010515d7824ULL, 0x000fe200078e0224ULL, 0xfffffffc55617812ULL, 0x100fe200078ee210ULL,
0x00005e00634e7625ULL, 0x000fe200078e0014ULL, 0xfffffffc69697812ULL, 0x000fc400078ee210ULL,
0x0000002427577211ULL, 0x000fe200078e20ffULL, 0x0000001025557824ULL, 0x100fe400078e0224ULL,
0x0000001061617824ULL, 0x100fe400078e0224ULL, 0x0000001069697824ULL, 0x000fe400078e0224ULL,
0x00005e004b247625ULL, 0x000fc800078e0014ULL, 0x00005e0049267625ULL, 0x000fc800078e0014ULL,
0x00005e004d487625ULL, 0x000fc800078e0014ULL, 0x00005e005b4a7625ULL, 0x000fc800078e0014ULL,
0x00005e005f4c7625ULL, 0x000fc800078e0014ULL, 0x00005e0067507625ULL, 0x000fc800078e0014ULL,
0x0000001053247825ULL, 0x000fc800078e0024ULL, 0x0000001053267825ULL, 0x040fe200078e0026ULL,
0x0000000024557faeULL, 0x0003e6000b901c46ULL, 0x0000001053487825ULL, 0x040fe200078e0048ULL,
0x0000000026577faeULL, 0x0003e6000b901c46ULL, 0x00000010534a7825ULL, 0x040fe200078e004aULL,
0x0000000048597faeULL, 0x0003e6000b901c46ULL, 0x00000010534c7825ULL, 0x040fe200078e004cULL,
0x000000004a5d7faeULL, 0x0003e6000b901c46ULL, 0x00000010534e7825ULL, 0x040fe200078e004eULL,
0x000000004c617faeULL, 0x0003e6000b901c46ULL, 0x0000001053507825ULL, 0x000fe200078e0050ULL,
0x000000004e657faeULL, 0x0003e8000b901c46ULL, 0x0000000050697faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000002013257824ULL, 0x002fe200078e00ffULL,
0x00000018121a7810ULL, 0x000fc40007ffe0ffULL, 0x0000001a121c7810ULL, 0x000fe40007ffe0ffULL,
0xffffffe0251a7812ULL, 0x000fe400078ee21aULL, 0x0000000513597819ULL, 0x000fc600000006ffULL,
0x000000101a1a7824ULL, 0x000fe200078e00ffULL, 0xffffffe0591c7812ULL, 0x000fca00078ee21cULL,
0x000000101c1c7824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000001a24783bULL, 0x0003e80000000200ULL, 0x000000001d4c783bULL, 0x000ea80000000200ULL,
0x000000001e50783bULL, 0x000ee20000000200ULL, 0x00000300021a7a10ULL, 0x002fc60007ffe0ffULL,
0x000000001b48783bULL, 0x000e680000000200ULL, 0x000000001f54783bULL, 0x000f280000000200ULL,
0x000000001c58783bULL, 0x000fe80000000200ULL, 0x000000002160783bULL, 0x000f280000000200ULL,
0x000000002264783bULL, 0x000f280000000200ULL, 0x00000000205c783bULL, 0x000f280000000200ULL,
0x000000002368783bULL, 0x0003220000000200ULL, 0x0000004c2430723cULL, 0x044f700000041830ULL,
0x00000052243c723cULL, 0x048f70000004183cULL, 0x000000482428723cULL, 0x042f700000041828ULL,
0x0000004a242c723cULL, 0x040f70000004182cULL, 0x0000004e2434723cULL, 0x040f700000041834ULL,
0x000000502438723cULL, 0x040f700000041838ULL, 0x000000542440723cULL, 0x050f700000041840ULL,
0x000000562444723cULL, 0x000f700000041844ULL, 0x000000605820723cULL, 0x060f700000041830ULL,
0x000000665830723cULL, 0x040b6e000004183cULL, 0x000000011a3c7810ULL, 0x060fe20007ffe0ffULL,
0x0000005c581c723cULL, 0x000b620000041828ULL, 0x000001001a3e7824ULL, 0x000fc400078e0205ULL,
0x0000000d3c00720cULL, 0x000fe40003f06070ULL, 0x00006200044c7a24ULL, 0x000fc600078e023eULL,
0x0000005e5824723cULL, 0x040b70000004182cULL, 0x000000625828723cULL, 0x040b700000041834ULL,
0x00000064582c723cULL, 0x040b700000041838ULL, 0x000000685834723cULL, 0x040b700000041840ULL,
0x0000006a5838723cULL, 0x000b620000041844ULL, 0x0000055000008947ULL, 0x000fce0003800000ULL,
0x00000002ff4a7819ULL, 0x000fe20000011619ULL, 0x00000010193c7824ULL, 0x000fe200078e00ffULL,
0x0000003e031b7217ULL, 0x000fc40007800000ULL, 0x0000004c4a3d7210ULL, 0x040fe40007ffe0ffULL,
0x000000084a487810ULL, 0x000fe20007ffe0ffULL, 0x000000011b1b7824ULL, 0x000fe200078e0a3eULL,
0x000000303c4d7812ULL, 0x000fe200078ec0ffULL, 0x00005e003d3c7625ULL, 0x080fe200078e0014ULL,
0x000000104a4e7810ULL, 0x040fe40007ffe0ffULL, 0x000000184a4f7810ULL, 0x000fe20007ffe0ffULL,
0x00000001483f7824ULL, 0x100fe200078e024cULL, 0x0000004d3c427210ULL, 0x020fe20007f1e0ffULL,
0x000000014e417824ULL, 0x000fe200078e024cULL, 0x0000001b4800720cULL, 0x000fe20003f26070ULL,
0x00005e003f3e7625ULL, 0x000fe200078e0014ULL, 0x0000003dff437210ULL, 0x000fc400007fe4ffULL,
0x0000000248497819ULL, 0x000fe200000006ffULL, 0x00005e00413c7625ULL, 0x080fe200078e0014ULL,
0x0000004d3e447210ULL, 0x080fe40007f1e0ffULL, 0x000000204a507810ULL, 0x000fe20007ffe0ffULL,
0x000000014f477824ULL, 0x000fe200078e024cULL, 0x0000004d3c467210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff457224ULL, 0x000fe200000e063fULL, 0xfffffffc493c7812ULL, 0x000fe200078ee210ULL,
0x00005e00473e7625ULL, 0x000fe200078e0014ULL, 0x0000001b4a00720cULL, 0x000fc40003f06070ULL,
0x000000304a517810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff477224ULL, 0x000fe200010e063dULL,
0x0000004d3e487210ULL, 0x000fe20007f5e0ffULL, 0x0000000150417824ULL, 0x100fe200078e024cULL,
0x000000284a3e7810ULL, 0x040fe40007ffe0ffULL, 0x000000384a527810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff497224ULL, 0x000fe200010e063fULL, 0x000000113c3f7211ULL, 0x000fe200078e20ffULL,
0x000000013e3d7824ULL, 0x000fe200078e024cULL, 0x0000001b4e00720cULL, 0x080fe20003fa6070ULL,
0x00005e0041407625ULL, 0x000fe200078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000420f7faeULL, 0x0003e2000c101c46ULL, 0x0000001b4f00720cULL, 0x000fc40003f86070ULL,
0x00005e003d3c7625ULL, 0x080fe200078e0014ULL, 0x0000004d40407210ULL, 0x000fe20007f7e0ffULL,
0x00000000443f7faeULL, 0x0005e2000c901c46ULL, 0x0000001b3e00720cULL, 0x000fe40003f46070ULL,
0x0000004d3c4a7210ULL, 0x000fe20007fde0ffULL, 0x000000ffff417224ULL, 0x000fe200018e0641ULL,
0x0000001b5000720cULL, 0x080fe40003f66070ULL, 0x0000001b5100720cULL, 0x0c0fe20003f26070ULL,
0x000000ffff4b7224ULL, 0x000fe200030e063dULL, 0x0000001b5200720cULL, 0x000fe20003f06070ULL,
0x00000001513d7824ULL, 0x000fe200078e024cULL, 0x000000024f4f7819ULL, 0x000fe200000006ffULL,
0x000000044e0f7824ULL, 0x002fe200078e00ffULL, 0x0000000251517819ULL, 0x000fe200000006ffULL,
0x00005e003d3c7625ULL, 0x000fe200078e0014ULL, 0xfffffffc4f447812ULL, 0x004fc400078ee210ULL,
0xfffffffc0f427812ULL, 0x000fe200078ee210ULL, 0x00000001523f7824ULL, 0x000fe200078e024cULL,
0x0000004d3c3c7210ULL, 0x000fe20007fde0ffULL, 0x00000004501b7824ULL, 0x000fe200078e00ffULL,
0xfffffffc51507812ULL, 0x100fe200078ee210ULL, 0x000000043e437824ULL, 0x000fe200078e00ffULL,
0x00000011420f7211ULL, 0x000fe200078e20ffULL, 0x0000000452457824ULL, 0x000fe200078e00ffULL,
0xfffffffc1b4c7812ULL, 0x100fe200078ee210ULL, 0x00005e003f3e7625ULL, 0x000fe200078e0014ULL,
0xfffffffc434e7812ULL, 0x100fe200078ee210ULL, 0x00000000460f7faeULL, 0x0003e2000e901c46ULL,
0xfffffffc45527812ULL, 0x000fe200078ee210ULL, 0x000000ffff3d7224ULL, 0x000fe200030e063dULL,
0x0000004d3e107210ULL, 0x000fe20007fde0ffULL, 0x00000010441b7824ULL, 0x100fe200078e0211ULL,
0x00000011504d7211ULL, 0x000fe200078e20ffULL, 0x000000104c437824ULL, 0x000fc400078e0211ULL,
0x000000104e457824ULL, 0x100fe200078e0211ULL, 0x00000000481b7faeULL, 0x0003e2000e101c46ULL,
0x00000010524f7824ULL, 0x000fe400078e0211ULL, 0x000000ffff117224ULL, 0x000fe200030e063fULL,
0x0000000040437faeULL, 0x0003e8000d901c46ULL, 0x000000004a457faeULL, 0x0003e8000d101c46ULL,
0x000000003c4d7faeULL, 0x0003e8000c901c46ULL, 0x00000000104f7faeULL, 0x0003e2000c101c46ULL,
0x0000049000007947ULL, 0x000fea0003800000ULL, 0x00000010191b7824ULL, 0x040fe200078e00ffULL,
0x0000004c193d7211ULL, 0x000fc400078ff0ffULL, 0x00000008193f7811ULL, 0x040fe400078ff0ffULL,
0x0000001019417811ULL, 0x020fe200078ff0ffULL, 0x00005e003d3c7625ULL, 0x000fe200078e0014ULL,
0x0000001819437811ULL, 0x040fe400078ff0ffULL, 0x0000002019457811ULL, 0x000fe200078ff0ffULL,
0x000000043f557824ULL, 0x000fe200078e00ffULL, 0x000000301b517812ULL, 0x000fe200078ec0ffULL,
0x0000000441577824ULL, 0x000fe200078e00ffULL, 0x0000004c3f1b7210ULL, 0x080fe20007ffe0ffULL,
0x00000001413f7824ULL, 0x100fe200078e024cULL, 0x0000003019497811ULL, 0x000fe200078ff0ffULL,
0x0000000443597824ULL, 0x040fe200078e00ffULL, 0x0000004c43417210ULL, 0x080fe20007ffe0ffULL,
0x0000000145437824ULL, 0x100fe200078e024cULL, 0x0000002819477811ULL, 0x000fe200078ff0ffULL,
0x0000000445457824ULL, 0x000fe200078e00ffULL, 0x0000003819537811ULL, 0x000fe200078ff0ffULL,
0x00000001494d7824ULL, 0x040fe200078e024cULL, 0x000000513c447210ULL, 0x000fe20007f1e0ffULL,
0x0000000449497824ULL, 0x000fe200078e00ffULL, 0x0000004c474b7210ULL, 0x0c0fe20007ffe0ffULL,
0x0000000447477824ULL, 0x000fe200078e00ffULL, 0x0000004c534f7210ULL, 0x040fe20007ffe0ffULL,
0x0000000453537824ULL, 0x000fe200078e00ffULL, 0xfffffffc454a7812ULL, 0x100fe200078ee210ULL,
0x000000ffff457224ULL, 0x000fe200000e063dULL, 0xfffffffc57467812ULL, 0x100fe200078ee210ULL,
0x00005e001b3c7625ULL, 0x000fe200078e0014ULL, 0xfffffffc59487812ULL, 0x000fc400078ee210ULL,
0xfffffffc55427812ULL, 0x100fe200078ee210ULL, 0x00005e003f3e7625ULL, 0x080fe200078e0014ULL,
0xfffffffc474c7812ULL, 0x100fe200078ee210ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000440f7faeULL, 0x0003e2000b901c46ULL, 0xfffffffc494e7812ULL, 0x100fe200078ee210ULL,
0x00005e0041407625ULL, 0x000fe200078e0014ULL, 0xfffffffc53107812ULL, 0x000fe400078ee210ULL,
0x0000001146537211ULL, 0x000fe200078e20ffULL, 0x0000001048557824ULL, 0x100fe200078e0211ULL,
0x000000513c467210ULL, 0x080fe20007f1e0ffULL, 0x00000010421b7824ULL, 0x100fe200078e0211ULL,
0x000000513e487210ULL, 0x000fe20007f3e0ffULL, 0x000000104a577824ULL, 0x100fe200078e0211ULL,
0x000000114e5b7211ULL, 0x000fe200078e20ffULL, 0x000000104c597824ULL, 0x000fc400078e0211ULL,
0x00000010105d7824ULL, 0x000fe400078e0211ULL, 0x000000ffff477224ULL, 0x000fe200000e063dULL,
0x0000005140407210ULL, 0x000fe20007f1e0ffULL, 0x00005e0043107625ULL, 0x000fc600078e0014ULL,
0x00000041ff417210ULL, 0x000fe200007fe4ffULL, 0x000000ffff497224ULL, 0x000fe200008e063fULL,
0x0000005110107210ULL, 0x080fe20007f1e0ffULL, 0x00005e004b3c7625ULL, 0x080fe200078e0014ULL,
0x00000000461b7faeULL, 0x0003e6000b901c46ULL, 0x00005e004d3e7625ULL, 0x080fe200078e0014ULL,
0x000000513c3c7210ULL, 0x080fe20007f3e0ffULL, 0x0000000048537faeULL, 0x0003e4000b901c46ULL,
0x00005e004f427625ULL, 0x000fe200078e0014ULL, 0x000000513e3e7210ULL, 0x080fe20007f5e0ffULL,
0x0000000040557faeULL, 0x0003e4000b901c46ULL, 0x000000ffff117224ULL, 0x000fe200000e0611ULL,
0x0000005142427210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff3d7224ULL, 0x000fc400008e063dULL,
0x000000ffff3f7224ULL, 0x000fe200010e063fULL, 0x00000043ff437210ULL, 0x000fe20001ffe4ffULL,
0x0000000010577faeULL, 0x0003e8000b901c46ULL, 0x000000003c597faeULL, 0x0003e8000b901c46ULL,
0x000000003e5b7faeULL, 0x0003e8000b901c46ULL, 0x00000000425d7faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000002013107824ULL, 0x042fe200078e00ffULL,
0x0000001c120f7810ULL, 0x040fe20007ffe0ffULL, 0x0000002013137824ULL, 0x000fe200078e00ffULL,
0x0000001e12127810ULL, 0x000fc40007ffe0ffULL, 0xffffffe0100f7812ULL, 0x000fe400078ee20fULL,
0xffffffe013147812ULL, 0x000fc600078ee212ULL, 0x000000100f0f7824ULL, 0x000fe200078e00ffULL,
0x0000000414147819ULL, 0x000fe200000006ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000000e40783bULL, 0x000fe80000000200ULL, 0x000000000f3c783bULL, 0x000e680000000200ULL,
0x000000000c44783bULL, 0x000ea80000000200ULL, 0x000000000b10783bULL, 0x000ee80000000200ULL,
0x000000000a48783bULL, 0x000f280000000200ULL, 0x000000000950783bULL, 0x000fe80000000200ULL,
0x00000000144c783bULL, 0x000ee80000000200ULL, 0x000000000854783bULL, 0x000ee80000000200ULL,
0x000000000658783bULL, 0x000fe20000000200ULL, 0x000000403c1c723cULL, 0x042f70000004181cULL,
0x000000423c24723cULL, 0x040b640000041824ULL, 0x000000000740783bULL, 0x020e6c0000000200ULL,
0x000000443c20723cULL, 0x044f700000041820ULL, 0x000000463c28723cULL, 0x040f700000041828ULL,
0x000000103c2c723cULL, 0x048ff0000004182cULL, 0x000000123c30723cULL, 0x040ff00000041830ULL,
0x000000483c34723cULL, 0x050ff00000041834ULL, 0x0000004a3c38723cULL, 0x000ff00000041838ULL,
0x000000504c1c723cULL, 0x040f70000004181cULL, 0x000000524c24723cULL, 0x040f700000041824ULL,
0x000000544c20723cULL, 0x060f700000041820ULL, 0x000000564c28723cULL, 0x000f620000041828ULL,
0x3d8000001c1c7820ULL, 0x000fe20000410000ULL, 0x3d8000001d1d7820ULL, 0x000fe20000410000ULL,
0x3d8000001e1e7820ULL, 0x000fe20000410000ULL, 0x3d8000001f1f7820ULL, 0x000fc80000410000ULL,
0x000000404c2c723cULL, 0x002f62000004182cULL, 0x3d80000024247820ULL, 0x000fe20000410000ULL,
0x3d80000025257820ULL, 0x000fe20000410000ULL, 0x3d80000026267820ULL, 0x000fe20000410000ULL,
0x3d80000027277820ULL, 0x000fc80000410000ULL, 0x000000424c30723cULL, 0x000f640000041830ULL,
0x3d80000020207820ULL, 0x020fe20000410000ULL, 0x3d80000021217820ULL, 0x000fe20000410000ULL,
0x3d80000022227820ULL, 0x000fe20000410000ULL, 0x3d80000023237820ULL, 0x000fc60000410000ULL,
0x000000584c34723cULL, 0x000f620000041834ULL, 0x3d80000028287820ULL, 0x000fe20000410000ULL,
0x3d80000029297820ULL, 0x000fe20000410000ULL, 0x3d8000002a2a7820ULL, 0x000fe20000410000ULL,
0x3d8000002b2b7820ULL, 0x000fc80000410000ULL, 0x0000005a4c38723cULL, 0x000f620000041838ULL,
0x3d8000002c2c7820ULL, 0x000fe20000410000ULL, 0x3d8000002d2d7820ULL, 0x000fe20000410000ULL,
0x3d8000002e2e7820ULL, 0x000fe20000410000ULL, 0x3d8000002f2f7820ULL, 0x000fc80000410000ULL,
0x3d80000030307820ULL, 0x000fe20000410000ULL, 0x3d80000031317820ULL, 0x000fe20000410000ULL,
0x3d80000032327820ULL, 0x000fe20000410000ULL, 0x3d80000033337820ULL, 0x000fca0000410000ULL,
0x3d80000034347820ULL, 0x020fe20000410000ULL, 0x3d80000035357820ULL, 0x000fe20000410000ULL,
0x3d80000036367820ULL, 0x000fe20000410000ULL, 0x3d80000037377820ULL, 0x000fca0000410000ULL,
0x3d80000038387820ULL, 0x000fe20000410000ULL, 0x3d80000039397820ULL, 0x000fe20000410000ULL,
0x3d8000003a3a7820ULL, 0x000fe20000410000ULL, 0x3d8000003b3b7820ULL, 0x000fe20000410000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000180a7f8cULL, 0x0002a4000c80043fULL,
0x0000000000067805ULL, 0x000fc40000015200ULL, 0x0000040018097984ULL, 0x000ee40000000800ULL,
0x8000000009ff7812ULL, 0x00cfe4000780480bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fcc0000015200ULL,
0x00000008060f7210ULL, 0x000fca0007f1e1ffULL, 0x0000000109097824ULL, 0x000fe200000e0e07ULL,
0x003d09000f00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400f00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc80000011409ULL, 0x0000000f08087211ULL, 0x000fca00078110ffULL,
0x000000ffff097224ULL, 0x000fca00000e0609ULL, 0x0000000208087819ULL, 0x000fc80000001209ULL,
0x000000080000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040018097984ULL, 0x000ea40000000800ULL, 0x8000000009ff7812ULL, 0x004fe4000780480bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000219077819ULL, 0x000fe400000006ffULL,
0x000000170200720cULL, 0x000fe40003f05270ULL, 0xfffffff007097812ULL, 0x000fca00078ec0ffULL,
0x0000008000067824ULL, 0x000fca00078e0209ULL, 0x0144000006087984ULL, 0x0004e20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x0000000219027824ULL, 0x000fe400078e00ffULL,
0x0000000103117824ULL, 0x000fc600078e0a16ULL, 0x0000000602027812ULL, 0x000fc800078ec0ffULL,
0x00000001020c7812ULL, 0x040fe400078efcffULL, 0x00000008020e7812ULL, 0x000fe400078efcffULL,
0x000000110c00720cULL, 0x080fe40003f26070ULL, 0x00000010020c7812ULL, 0x000fe400078efcffULL,
0x000000110e00720cULL, 0x080fe40003f06070ULL, 0x000000110c00720cULL, 0x000fc40003fc6070ULL,
0x00000011020e7812ULL, 0x040fe400078efcffULL, 0x00000018020c7812ULL, 0x040fe400078efcffULL,
0x000000110200720cULL, 0x080fe40003f46070ULL, 0x000000110e00720cULL, 0x080fe40003fa6070ULL,
0x000000110c00720cULL, 0x000fe40003f66070ULL, 0x00000009020f7812ULL, 0x000fc400078efcffULL,
0x00000019020e7812ULL, 0x040fe400078efcffULL, 0x00000020020c7812ULL, 0x000fe400078efcffULL,
0xff8000001e1e7808ULL, 0x000fe40005000000ULL, 0xff8000001c1c7808ULL, 0x000fe40005000000ULL,
0xff8000001f1f7808ULL, 0x000fe40004800000ULL, 0xff8000001d1d7808ULL, 0x000fc40004800000ULL,
0x000000110f00720cULL, 0x080fe40003f86070ULL, 0x000000110e00720cULL, 0x080fe40003f46070ULL,
0x000000110c00720cULL, 0x000fe40003f26070ULL, 0x00000021020e7812ULL, 0x040fe400078efcffULL,
0x00000028020c7812ULL, 0x000fe400078efcffULL, 0xff80000026267808ULL, 0x000fc40004000000ULL,
0xff80000024247808ULL, 0x000fe40004000000ULL, 0xff80000027277808ULL, 0x000fe40006000000ULL,
0xff80000025257808ULL, 0x000fe40006000000ULL, 0x000000110e00720cULL, 0x080fe40003f06070ULL,
0x000000110c00720cULL, 0x000fe40003f86070ULL, 0x00000029020e7812ULL, 0x000fc400078efcffULL,
0x00000030020c7812ULL, 0x000fe400078efcffULL, 0xff80000022227808ULL, 0x000fe40007000000ULL,
0xff80000020207808ULL, 0x000fe40007000000ULL, 0xff80000023237808ULL, 0x000fe40006800000ULL,
0xff80000021217808ULL, 0x000fe40006800000ULL, 0x000000110e00720cULL, 0x000fc40003fc6070ULL,
0x000000110c00720cULL, 0x000fe40003fa6070ULL, 0x00000031020e7812ULL, 0x040fe400078efcffULL,
0x00000038020c7812ULL, 0x040fe400078efcffULL, 0x0000003902027812ULL, 0x000fe400078efcffULL,
0xff8000002a2a7808ULL, 0x000fe40005800000ULL, 0xff80000028287808ULL, 0x000fc40005800000ULL,
0xff8000002b2b7808ULL, 0x000fe40005000000ULL, 0xff80000029297808ULL, 0x000fe40005000000ULL,
0xff8000002e2e7808ULL, 0x000fe40004800000ULL, 0xff8000002c2c7808ULL, 0x000fe40004800000ULL,
0x000000110e00720cULL, 0x080fe40003f66070ULL, 0x000000110c00720cULL, 0x000fc40003f46070ULL,
0x000000110200720cULL, 0x000fe40003f26070ULL, 0xff8000002f2f7808ULL, 0x000fe40004000000ULL,
0xff8000002d2d7808ULL, 0x000fe40004000000ULL, 0xff80000032327808ULL, 0x000fe40006000000ULL,
0xff80000030307808ULL, 0x000fe40006000000ULL, 0xff80000033337808ULL, 0x000fc40007000000ULL,
0xff80000031317808ULL, 0x000fe40007000000ULL, 0xff80000036367808ULL, 0x000fe40006800000ULL,
0xff80000034347808ULL, 0x000fe40006800000ULL, 0xff80000037377808ULL, 0x000fe40005800000ULL,
0xff80000035357808ULL, 0x000fe40005800000ULL, 0xff8000003a3a7808ULL, 0x000fc40005000000ULL,
0xff80000038387808ULL, 0x000fe40005000000ULL, 0xff8000003b3b7808ULL, 0x000fe40004800000ULL,
0xff80000039397808ULL, 0x000fc40004800000ULL, 0x0000001c0800720bULL, 0x008fe20003f1e000ULL,
0xffffffffff1b7424ULL, 0x000fe200078e00ffULL, 0x0000001e0900720bULL, 0x000fe40003f3e000ULL,
0x000000081c087208ULL, 0x000fe40004000000ULL, 0x000000091e027208ULL, 0x000fc40004800000ULL,
0x0000001d0800720bULL, 0x000fe40003f1e000ULL, 0x0000001f0200720bULL, 0x000fe40003f3e000ULL,
0x000000081d097208ULL, 0x000fe40004000000ULL, 0x000000021f0f7208ULL, 0x000fe40004800000ULL,
0x000000240900720bULL, 0x000fe40003f1e000ULL, 0x000000260f00720bULL, 0x000fc40003f3e000ULL,
0x0000000924027208ULL, 0x000fe40004000000ULL, 0x0000000f26087208ULL, 0x000fe40004800000ULL,
0x000000250200720bULL, 0x000fe40003f1e000ULL, 0x000000270800720bULL, 0x000fe40003f3e000ULL,
0x0000000225097208ULL, 0x000fe40004000000ULL, 0x00000008270f7208ULL, 0x000fc40004800000ULL,
0x000000200900720bULL, 0x000fe40003f1e000ULL, 0x000000220f00720bULL, 0x000fe40003f3e000ULL,
0x0000000920027208ULL, 0x000fe40004000000ULL, 0x0000000f22087208ULL, 0x000fe40004800000ULL,
0x000000210200720bULL, 0x000fe40003f1e000ULL, 0x000000230800720bULL, 0x000fc40003f3e000ULL,
0x0000000221097208ULL, 0x000fe40004000000ULL, 0x00000008230f7208ULL, 0x000fe40004800000ULL,
0x000000280900720bULL, 0x000fe40003f1e000ULL, 0x0000002a0f00720bULL, 0x000fe40003f3e000ULL,
0x0000000928027208ULL, 0x000fe40004000000ULL, 0x0000000f2a087208ULL, 0x000fc40004800000ULL,
0x000000290200720bULL, 0x000fe40003f1e000ULL, 0x0000002b0800720bULL, 0x000fe40003f3e000ULL,
0x0000000229097208ULL, 0x000fe40004000000ULL, 0x000000082b0f7208ULL, 0x000fe40004800000ULL,
0x0000002c0900720bULL, 0x000fe40003f1e000ULL, 0x0000002e0f00720bULL, 0x000fc40003f3e000ULL,
0x000000092c027208ULL, 0x000fe40004000000ULL, 0x0000000f2e087208ULL, 0x000fe40004800000ULL,
0x0000002d0200720bULL, 0x000fe40003f1e000ULL, 0x0000002f0800720bULL, 0x000fe40003f3e000ULL,
0x000000022d097208ULL, 0x000fe40004000000ULL, 0x000000082f0f7208ULL, 0x000fc40004800000ULL,
0x000000300900720bULL, 0x000fe40003f1e000ULL, 0x000000320f00720bULL, 0x000fe40003f3e000ULL,
0x0000000930027208ULL, 0x000fe40004000000ULL, 0x0000000f32087208ULL, 0x000fe40004800000ULL,
0x000000310200720bULL, 0x000fe40003f1e000ULL, 0x000000330800720bULL, 0x000fc40003f3e000ULL,
0x0000000231097208ULL, 0x000fe40004000000ULL, 0x00000008330f7208ULL, 0x000fe40004800000ULL,
0x000000340900720bULL, 0x000fe40003f1e000ULL, 0x000000360f00720bULL, 0x000fe40003f3e000ULL,
0x0000000934027208ULL, 0x000fe40004000000ULL, 0x0000000f36087208ULL, 0x000fc40004800000ULL,
0x000000350200720bULL, 0x000fe40003f1e000ULL, 0x000000370800720bULL, 0x000fe40003f3e000ULL,
0x0000000235097208ULL, 0x000fe40004000000ULL, 0x00000008370f7208ULL, 0x000fe40004800000ULL,
0x000000380900720bULL, 0x000fe40003f1e000ULL, 0x0000003a0f00720bULL, 0x000fc40003f3e000ULL,
0x0000000938027208ULL, 0x000fe40004000000ULL, 0x0000000f3a087208ULL, 0x000fe40004800000ULL,
0x000000390200720bULL, 0x000fe40003f1e000ULL, 0x0000003b0800720bULL, 0x000fe40003f3e000ULL,
0x0000001f00127802ULL, 0x000fe40000000f00ULL, 0x00000002390c7208ULL, 0x000fc40004000000ULL,
0x000000083b137208ULL, 0x000fe20004800000ULL, 0x000017d27f007947ULL, 0x000fea000b800000ULL,
0x0c401f000c027f89ULL, 0x00066400000e0000ULL, 0x000000020c00720bULL, 0x006fc80003f1e000ULL,
0x0000000c02107208ULL, 0x000fe20004000000ULL, 0x000017d27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0013027f89ULL, 0x000e6800000e0000ULL, 0x0c401f000a097f89ULL, 0x000ea800000e0000ULL,
0x0c401f000b087f89ULL, 0x000f2200000e0000ULL, 0x000000021300720bULL, 0x002fc40003f1e000ULL,
0x000000090a00720bULL, 0x004fe40003f3e000ULL, 0x0000001302027208ULL, 0x000fe40004000000ULL,
0x0000000a090c7208ULL, 0x008fe40004800000ULL, 0x0c201f0010097f89ULL, 0x000e6200000e0000ULL,
0x000000080b00720bULL, 0x010fc60003f1e000ULL, 0x0c201f00020f7f89ULL, 0x000ea200000e0000ULL,
0x0000000b08147208ULL, 0x000fc60004000000ULL, 0x0c201f000c117f89ULL, 0x000ee800000e0000ULL,
0x0c201f00141b7f89ULL, 0x0002e400000e0000ULL, 0x000000091000720bULL, 0x002fe40003f1e000ULL,
0x0000000f0200720bULL, 0x004fe40003f3e000ULL, 0x0000001009087208ULL, 0x000fc40004000000ULL,
0x000000110c00720bULL, 0x008fe40003f5e000ULL, 0x000000020f097208ULL, 0x000fe40004800000ULL,
0x0000000c110a7208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b08027820ULL, 0x000fe20000410000ULL,
0x3fb8aa3b090c7820ULL, 0x000fe20000410000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0x0000000319ff7812ULL, 0x000fe2000780c0ffULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe20000010802ULL,
0x3fb8aa3b25257823ULL, 0x100fe20000010802ULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe20000010802ULL,
0x3fb8aa3b24247823ULL, 0x000fe20000010802ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b26267823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b27277823ULL, 0x000fe2000001080cULL, 0x0000001c00107308ULL, 0x000fe20000000800ULL,
0x00000004ff3c7e24ULL, 0x000fe2000f8e00ffULL, 0x3fb8aa3b20207823ULL, 0x100fe20000010802ULL,
0x3fb8aa3b21217823ULL, 0x100fe20000010802ULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010802ULL,
0x3fb8aa3b29297823ULL, 0x000fe20000010802ULL, 0x3f8000003c3c783eULL, 0x000fe200000010ffULL,
0x3fb8aa3b22227823ULL, 0x100fe2000001080cULL, 0x0000001d001d7308ULL, 0x000e620000000800ULL,
0x3fb8aa3b23237823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b2a2a7823ULL, 0x000fe2000001080cULL,
0x000000ffff3d7224ULL, 0x000fe200078e003cULL, 0x3fb8aa3b2b2b7823ULL, 0x000fe2000001080cULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe20000010802ULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe20000010802ULL, 0x0000002400127308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b30307823ULL, 0x100fe20000010802ULL, 0x3fb8aa3b31317823ULL, 0x000fe20000010802ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b32327823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b33337823ULL, 0x000fe2000001080cULL,
0x3fb8aa3b34347823ULL, 0x100fe20000010802ULL, 0x0000002500257308ULL, 0x000ea20000000800ULL,
0x000000101d10723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b35357823ULL, 0x100fe20000010802ULL,
0x3fb8aa3b38387823ULL, 0x000fe20000010802ULL, 0x3fb8aa3b36367823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b37377823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b3a3a7823ULL, 0x000fe2000001080cULL,
0x3fb8aa3b39027823ULL, 0x000fe20000010802ULL, 0x0000001e00117308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b3b0c7823ULL, 0x000fe2000001080cULL, 0x0000001b1400720bULL, 0x000fcc0003f3e000ULL,
0x0000001f000e7308ULL, 0x000e620000000800ULL, 0x000000122512723eULL, 0x004fce00000010ffULL,
0x0000002600137308ULL, 0x000ff00000000800ULL, 0x0000002700167308ULL, 0x000ea20000000800ULL,
0x000000110e11723eULL, 0x002fe400000010ffULL, 0x00000002ff0e7819ULL, 0x000fc80000011619ULL,
0x000000010e0f7810ULL, 0x040fe20007ffe0ffULL, 0x0000002000207308ULL, 0x000fe20000000800ULL,
0x000000080e3b7824ULL, 0x040fe400078e00ffULL, 0x000000080e417824ULL, 0x040fe400078e00ffULL,
0x000000080e3f7824ULL, 0x000fe200078e00ffULL, 0x000000131613723eULL, 0x004fe400000010ffULL,
0x0000002100217308ULL, 0x000e620000000800ULL, 0x000000030e167819ULL, 0x000fc800000006ffULL,
0x0000003c1024723cULL, 0x000f6600000418ffULL, 0x0000002800287308ULL, 0x000ff00000000800ULL,
0x0000002900297308ULL, 0x000ea20000000800ULL, 0x00000020211c723eULL, 0x002fce00000010ffULL,
0x0000002200227308ULL, 0x000ff00000000800ULL, 0x0000002300237308ULL, 0x000e620000000800ULL,
0x00000028291e723eULL, 0x004fe200000010ffULL, 0x000000080e287824ULL, 0x000fcc00078e00ffULL,
0x0000002a002a7308ULL, 0x000ff00000000800ULL, 0x0000002b001f7308ULL, 0x000ea20000000800ULL,
0x00000022231d723eULL, 0x002fce00000010ffULL, 0x0000002c002c7308ULL, 0x000fe20000000800ULL,
0x0000002a1f1f723eULL, 0x004fce00000010ffULL, 0x0000002d002d7308ULL, 0x000e620000000800ULL,
0x0000003c1c24723cULL, 0x020f6e0000041824ULL, 0x0000003000307308ULL, 0x000ff00000000800ULL,
0x0000003100317308ULL, 0x000ea20000000800ULL, 0x0000002c2d20723eULL, 0x002fc400000010ffULL,
0x000000030e2d7819ULL, 0x000fc800000006ffULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee20eULL,
0x0000002e002e7308ULL, 0x000ff00000000800ULL, 0x0000002f002f7308ULL, 0x000e620000000800ULL,
0x000000303122723eULL, 0x004fe200000010ffULL, 0x000000080e317824ULL, 0x000fcc00078e00ffULL,
0x0000003200327308ULL, 0x000ff00000000800ULL, 0x0000003300237308ULL, 0x0004e20000000800ULL,
0x0000002e2f21723eULL, 0x002fe400000010ffULL, 0x0000000c072f7812ULL, 0x000fca00078ec0ffULL,
0x0000003400347308ULL, 0x000fe20000000800ULL, 0xfffffff816337812ULL, 0x004fe400078ee20fULL,
0x000000030e0f7810ULL, 0x040fe40007ffe0ffULL, 0x000000040e167810ULL, 0x000fe40007ffe0ffULL,
0xfffffff828397812ULL, 0x000fe200078ee20fULL, 0x0000003500357308ULL, 0x000e620000000800ULL,
0x000000322323723eULL, 0x008fe400000010ffULL, 0xfffffff83b3b7812ULL, 0x000fc400078ee216ULL,
0x000000060e167810ULL, 0x000fc60007ffe0ffULL, 0x0000003c2028723cULL, 0x020b620000041824ULL,
0x0000003800387308ULL, 0x000fe20000000800ULL, 0xfffffff83f3f7812ULL, 0x000fca00078ee216ULL,
0x000000080e257810ULL, 0x060fe20007ffe0ffULL, 0x000000080e3d7824ULL, 0x040fe200078e00ffULL,
0x00000002000b7308ULL, 0x0004e20000000800ULL, 0xffffffff0e247810ULL, 0x000fc80007ffe0ffULL,
0xfffffff841417812ULL, 0x000fe400078ee224ULL, 0x000000343524723eULL, 0x002fe200000010ffULL,
0x0000003600367308ULL, 0x000fe20000000800ULL, 0x000000020e027810ULL, 0x044fe20007ffe0ffULL,
0x000000ffff347224ULL, 0x100fe400078e003cULL, 0x000000ffff357224ULL, 0x000fe200078e003cULL,
0xfffffff831317812ULL, 0x000fe400078ee202ULL, 0x000000050e027810ULL, 0x000fe20007ffe0ffULL,
0x0000003700377308ULL, 0x000e620000000800ULL, 0x00000003250e7819ULL, 0x000fc400000006ffULL,
0x000000380b26723eULL, 0x008fe400000010ffULL, 0xfffffff80e437812ULL, 0x000fe400078ee225ULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee202ULL, 0x0000003a003a7308ULL, 0x000fe20000000800ULL,
0x0000a00000027811ULL, 0x000fc800078e58ffULL, 0x00000002330b7211ULL, 0x080fe200078e20ffULL,
0x000000102d077824ULL, 0x100fe200078e0202ULL, 0x00000002432e7211ULL, 0x000fe200078e20ffULL,
0x0000000c000f7308ULL, 0x0004e20000000800ULL, 0x000000363725723eULL, 0x002fe200000010ffULL,
0x00000010390e7824ULL, 0x100fe200078e0202ULL, 0x000000072f077210ULL, 0x000fe20007ffe0ffULL,
0x000000103d167824ULL, 0x100fe200078e0202ULL, 0x0000002e2f2e7210ULL, 0x000fe20007ffe0ffULL,
0x000000103f2c7824ULL, 0x100fe400078e0202ULL, 0x00000010412d7824ULL, 0x100fe200078e0202ULL,
0x0000001007007388ULL, 0x0003e20000000800ULL, 0x00000010310c7824ULL, 0x004fc400078e0202ULL,
0x000000012f0e7824ULL, 0x040fe400078e020eULL, 0x000000012f0c7824ULL, 0x000fe200078e020cULL,
0x0000003a0f27723eULL, 0x008fe200000010ffULL, 0x000000103b0f7824ULL, 0x000fe400078e0202ULL,
0x000000012f027824ULL, 0x000fe200078e020bULL, 0x000000141b0b7208ULL, 0x000fe20004800000ULL,
0x000000012f167824ULL, 0x040fe200078e0216ULL, 0x0000000f2f0f7210ULL, 0x040fe20007ffe0ffULL,
0x000000342428723cULL, 0x000f620000041828ULL, 0x000000012f2c7824ULL, 0x040fe200078e022cULL,
0x0000001202007388ULL, 0x0003e20000000800ULL, 0x000000012f2d7824ULL, 0x000fc600078e022dULL,
0x0000001c0c007388ULL, 0x0003e80000000800ULL, 0x0000001e0e007388ULL, 0x0003e80000000800ULL,
0x000000200f007388ULL, 0x0003e80000000800ULL, 0x0000002216007388ULL, 0x0003e80000000800ULL,
0x000000242c007388ULL, 0x0003e40000000800ULL, 0x000000ffff297224ULL, 0x020fc400078e002aULL,
0x000000262d007388ULL, 0x0003e80000000800ULL, 0x000000112e007388ULL, 0x0003e80000000800ULL,
0x0004001302007388ULL, 0x0003e80000000800ULL, 0x0004001d0c007388ULL, 0x0003e80000000800ULL,
0x0004001f0e007388ULL, 0x0003e80000000800ULL, 0x000400210f007388ULL, 0x0003e80000000800ULL,
0x0004002316007388ULL, 0x0003e80000000800ULL, 0x000400252c007388ULL, 0x0003e80000000800ULL,
0x000400272d007388ULL, 0x0003e80000000800ULL, 0x0140000806008388ULL, 0x0003e80000000c00ULL,
0x0142002806008388ULL, 0x0003e20000000a00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0146080015ff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0146100015ff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0146180015ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000d1a00720cULL, 0x000fe20003f06070ULL, 0x0146200015ff7f8cULL, 0x0003e4000c80043fULL,
0x000000ffff027224ULL, 0x002fd400078e001aULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffff869000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff097807ULL, 0x008fe40004000000ULL, 0x0001651000087802ULL, 0x000fc40000000f00ULL,
0x00000f4000007944ULL, 0x002fea0003c00000ULL, 0x0000004d00087202ULL, 0x000fe20000000f00ULL,
0xfffebbd000007947ULL, 0x000fea000383ffffULL, 0x00000001ff097807ULL, 0x000fe40005800000ULL,
0x0001656000087802ULL, 0x000fc40000000f00ULL, 0x00000ef000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x000fe200078e004dULL, 0xfffebc1000007947ULL, 0x000fea000383ffffULL,
0x000000ffff597224ULL, 0x008fe200078e0025ULL, 0x000165b0005a7802ULL, 0x000fc40000000f00ULL,
0x00000e5000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e0059ULL,
0xfffebcb000007947ULL, 0x000fea000383ffffULL, 0x0000002500597202ULL, 0x000fe40000000f00ULL,
0x00016600005a7802ULL, 0x000fc40000000f00ULL, 0x00000e0000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e0059ULL, 0xfffebdd000007947ULL, 0x000fea000383ffffULL,
0x000000ffff597224ULL, 0x000fe200078e000bULL, 0x00016660005a7802ULL, 0x000fe20000000f00ULL,
0x000000ffff087224ULL, 0x000fc400078e000aULL, 0x00000da000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff3b7224ULL, 0x004fe200078e0059ULL, 0xfffebf8000007947ULL, 0x000fea000383ffffULL,
0x0000003800087202ULL, 0x000fe20000000f00ULL, 0x000000ffff597224ULL, 0x000fe200078e000bULL,
0x000166c0005a7802ULL, 0x000fc40000000f00ULL, 0x00000d4000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff387224ULL, 0x004fe200078e0059ULL, 0xfffebf5000007947ULL, 0x000fea000383ffffULL,
0x000000ffff597224ULL, 0x000fe200078e0004ULL, 0x00016720005a7802ULL, 0x000fe20000000f00ULL,
0x000000ffff087224ULL, 0x000fc400078e0005ULL, 0x00000ce000007944ULL, 0x000fea0003c00000ULL,
0x00000059003b7202ULL, 0x004fe20000000f00ULL, 0xfffecfd000007947ULL, 0x000fea000383ffffULL,
0x000000ffff597224ULL, 0x000fe200078e0004ULL, 0x00016770005a7802ULL, 0x000fc40000000f00ULL,
0x00000c9000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff387224ULL, 0x004fe200078e0059ULL,
0xfffecfb000007947ULL, 0x000fea000383ffffULL, 0x00000001ff097807ULL, 0x008fe40004000000ULL,
0x000167c000087802ULL, 0x000fc40000000f00ULL, 0x00000c9000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff4c7224ULL, 0x000fe200078e004dULL, 0xfffee26000007947ULL, 0x000fea000383ffffULL,
0x00000001ff097807ULL, 0x000fe40005000000ULL, 0x0001681000087802ULL, 0x000fc40000000f00ULL,
0x00000c4000007944ULL, 0x002fea0003c00000ULL, 0xfffee2b000007947ULL, 0x000fea000383ffffULL,
0x0000004e00597202ULL, 0x000fe40000000f00ULL, 0x00016850005a7802ULL, 0x000fc40000000f00ULL,
0x00000bb000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e0059ULL,
0xfffee37000007947ULL, 0x000fea000383ffffULL, 0x000000ffff597224ULL, 0x000fe200078e004eULL,
0x000168a0005a7802ULL, 0x000fc40000000f00ULL, 0x00000b6000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e0059ULL, 0xfffee48000007947ULL, 0x000fea000383ffffULL,
0x000000ffff597224ULL, 0x000fe200078e000aULL, 0x0000000b00087202ULL, 0x000fc40000000f00ULL,
0x00016900005a7802ULL, 0x000fc40000000f00ULL, 0x00000b0000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff3b7224ULL, 0x004fe200078e0059ULL, 0xfffee63000007947ULL, 0x000fea000383ffffULL,
0x000000ffff597224ULL, 0x000fe200078e000aULL, 0x00016950005a7802ULL, 0x000fc40000000f00ULL,
0x00000ab000007944ULL, 0x00efea0003c00000ULL, 0x000000ffff387224ULL, 0x004fe200078e0059ULL,
0xfffee61000007947ULL, 0x000fea000383ffffULL, 0x000000ffff597224ULL, 0x000fe200078e0004ULL,
0x000169b0005a7802ULL, 0x000fe20000000f00ULL, 0x000000ffff087224ULL, 0x000fc400078e0005ULL,
0x00000a5000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff3b7224ULL, 0x004fe200078e0059ULL,
0xfffef3d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff597224ULL, 0x000fe200078e0004ULL,
0x00016a00005a7802ULL, 0x000fc40000000f00ULL, 0x00000a0000007944ULL, 0x006fea0003c00000ULL,
0x0000005900387202ULL, 0x004fe20000000f00ULL, 0xfffef3b000007947ULL, 0x000fea000383ffffULL,
0x00000001ff097807ULL, 0x008fe40004000000ULL, 0x00016a5000087802ULL, 0x000fc40000000f00ULL,
0x00000a0000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff4c7224ULL, 0x000fe200078e004dULL,
0xffff047000007947ULL, 0x000fea000383ffffULL, 0x00000001ff097807ULL, 0x000fe40005000000ULL,
0x00016aa000087802ULL, 0x000fc40000000f00ULL, 0x000009b000007944ULL, 0x002fea0003c00000ULL,
0xffff04b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff597224ULL, 0x000fe200078e004eULL,
0x00016ae0005a7802ULL, 0x000fc40000000f00ULL, 0x0000092000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e0059ULL, 0xffff057000007947ULL, 0x000fea000383ffffULL,
0x000000ffff597224ULL, 0x000fe200078e004eULL, 0x00016b30005a7802ULL, 0x000fc40000000f00ULL,
0x000008d000007944ULL, 0x006fea0003c00000ULL, 0x0000005900087202ULL, 0x004fe20000000f00ULL,
0xffff068000007947ULL, 0x000fea000383ffffULL, 0x000000ffff597224ULL, 0x000fe200078e000aULL,
0x00016b90005a7802ULL, 0x000fe20000000f00ULL, 0x000000ffff087224ULL, 0x000fc400078e000bULL,
0x0000087000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff3b7224ULL, 0x004fe200078e0059ULL,
0xffff083000007947ULL, 0x000fea000383ffffULL, 0x000000ffff597224ULL, 0x000fe200078e000aULL,
0x00016be0005a7802ULL, 0x000fc40000000f00ULL, 0x0000082000007944ULL, 0x00efea0003c00000ULL,
0x0000005900387202ULL, 0x004fe20000000f00ULL, 0xffff081000007947ULL, 0x000fea000383ffffULL,
0x000000ffff597224ULL, 0x000fe200078e0004ULL, 0x00016c40005a7802ULL, 0x000fe20000000f00ULL,
0x000000ffff087224ULL, 0x000fc400078e0005ULL, 0x000007c000007944ULL, 0x000fea0003c00000ULL,
0x00000059003b7202ULL, 0x004fe20000000f00ULL, 0xffff15d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff597224ULL, 0x000fe200078e0004ULL, 0x00016c90005a7802ULL, 0x000fc40000000f00ULL,
0x0000077000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff387224ULL, 0x004fe200078e0059ULL,
0xffff15b000007947ULL, 0x000fea000383ffffULL, 0x00000001ff097807ULL, 0x008fe40004000000ULL,
0x00016ce000087802ULL, 0x000fc40000000f00ULL, 0x0000077000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff2b7224ULL, 0x000fe200078e004dULL, 0xffff267000007947ULL, 0x000fea000383ffffULL,
0x00000001ff097807ULL, 0x000fe40004800000ULL, 0x00016d3000087802ULL, 0x000fc40000000f00ULL,
0x0000072000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff3c7224ULL, 0x000fe200078e004dULL,
0xffff26a000007947ULL, 0x000fea000383ffffULL, 0x0000003e00597202ULL, 0x000fe40000000f00ULL,
0x00016d80005a7802ULL, 0x000fc40000000f00ULL, 0x0000068000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e0059ULL, 0xffff276000007947ULL, 0x000fea000383ffffULL,
0x000000ffff597224ULL, 0x000fe200078e003eULL, 0x00016dd0005a7802ULL, 0x000fc40000000f00ULL,
0x0000063000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e0059ULL,
0xffff287000007947ULL, 0x000fea000383ffffULL, 0x000000ffff597224ULL, 0x000fe200078e000aULL,
0x0000000b00087202ULL, 0x000fc40000000f00ULL, 0x00016e30005a7802ULL, 0x000fc40000000f00ULL,
0x000005d000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff3b7224ULL, 0x004fe200078e0059ULL,
0xffff2a2000007947ULL, 0x000fea000383ffffULL, 0x000000ffff597224ULL, 0x000fe200078e000aULL,
0x00016e80005a7802ULL, 0x000fc40000000f00ULL, 0x0000058000007944ULL, 0x00efea0003c00000ULL,
0x000000ffff387224ULL, 0x004fe200078e0059ULL, 0xffff2a0000007947ULL, 0x000fea000383ffffULL,
0x000000ffff597224ULL, 0x000fe200078e000aULL, 0x00016ee0005a7802ULL, 0x000fe20000000f00ULL,
0x000000ffff087224ULL, 0x000fc400078e000bULL, 0x0000052000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff3b7224ULL, 0x004fe200078e0059ULL, 0xffff37f000007947ULL, 0x000fea000383ffffULL,
0x0000000a00597202ULL, 0x000fe40000000f00ULL, 0x00016f30005a7802ULL, 0x000fc40000000f00ULL,
0x000004d000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff387224ULL, 0x004fe200078e0059ULL,
0xffff37d000007947ULL, 0x000fea000383ffffULL, 0x00000002ff117424ULL, 0x000fe200078e00ffULL,
0x00016f80000e7802ULL, 0x000fc40000000f00ULL, 0x0000044000007944ULL, 0x006fea0003c00000ULL,
0xffffe80000007947ULL, 0x000fea000383ffffULL, 0x000000ffff0c7224ULL, 0x008fe200078e0013ULL,
0x0000000200117802ULL, 0x000fc40000000f00ULL, 0x00016fd0000e7802ULL, 0x000fc40000000f00ULL,
0x000003f000007944ULL, 0x000fea0003c00000ULL, 0x000000021300720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0c7224ULL, 0x002fe200078e000aULL, 0x00017030000e7802ULL, 0x000fe20000000f00ULL,
0x00000002ff117424ULL, 0x000fe200078e00ffULL, 0x0000001302097208ULL, 0x000fc80004000000ULL,
0x0000039000007944ULL, 0x000fea0003c00000ULL, 0x000000020a00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0c7224ULL, 0x002fe200078e000bULL, 0x0000000200117802ULL, 0x000fe40000000f00ULL,
0x0000000a02137208ULL, 0x000fe40004000000ULL, 0x00017090000e7802ULL, 0x000fc40000000f00ULL,
0x0000033000007944ULL, 0x000fea0003c00000ULL, 0x000000020b00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0c7224ULL, 0x002fe200078e0010ULL, 0x000170f0000e7802ULL, 0x000fe20000000f00ULL,
0x00000001ff117424ULL, 0x000fe200078e00ffULL, 0x0000000b02147208ULL, 0x000fc80004000000ULL,
0x000002d000007944ULL, 0x000fea0003c00000ULL, 0x000000021000720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0c7224ULL, 0x002fe200078e0009ULL, 0x0000000100117802ULL, 0x000fc40000000f00ULL,
0x0000001002087208ULL, 0x000fe40004000000ULL, 0x00017150000e7802ULL, 0x000fc40000000f00ULL,
0x0000027000007944ULL, 0x000fea0003c00000ULL, 0x000000020900720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0c7224ULL, 0x002fe200078e0013ULL, 0x000171b0000e7802ULL, 0x000fe20000000f00ULL,
0x00000001ff117424ULL, 0x000fe200078e00ffULL, 0x0000000902097208ULL, 0x000fc80004000000ULL,
0x0000021000007944ULL, 0x000fea0003c00000ULL, 0x000000021300720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0c7224ULL, 0x002fe200078e0014ULL, 0x0000000100117802ULL, 0x000fe40000000f00ULL,
0x00000013020a7208ULL, 0x000fc40004000000ULL, 0x00017210000e7802ULL, 0x000fc40000000f00ULL,
0x000001b000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff1b7224ULL, 0x006fe200078e0002ULL,
0xffffe6c000007947ULL, 0x000fea000383ffffULL, 0x0180000032047810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000004057812ULL, 0x000fc800078ec0ffULL,
0x018000000500780cULL, 0x000fda0003f05070ULL, 0x0000003200048308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0500720cULL, 0x040fe40003f25070ULL,
0x008000000500780cULL, 0x000fe40003f02070ULL, 0x00000001ff057807ULL, 0x000fe40000800000ULL,
0x00000001ff047807ULL, 0x004fc80004000000ULL, 0x0000000405ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff32ff7812ULL, 0x000fc8000780c0ffULL,
0x00000001ff047807ULL, 0x000fc80000000000ULL, 0x0000000405ff7212ULL, 0x000fe4000780c0ffULL,
0x8000000032057812ULL, 0x000fd600078ec0ffULL, 0x0080000005040812ULL, 0x000fe200078efcffULL,
0x000000ffff048224ULL, 0x000fe200078e0005ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000003200047308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000400077202ULL, 0x00cfe20000000f00ULL, 0x000000ffff047224ULL, 0x000fe400078e0006ULL,
0x00000000ff057424ULL, 0x000fc800078e00ffULL, 0xfffe8c4004007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000001b00007348ULL, 0x000fe80003800000ULL,
0x0c0000110c027389ULL, 0x0002a200000e0012ULL, 0xfffe8c000e007950ULL, 0x000fea0003c3ffffULL,
0x0000003f00007348ULL, 0x000fe80003800000ULL, 0x0000000859597389ULL, 0x0002a200000e0040ULL,
0x00000000ff097424ULL, 0x000fe200078e00ffULL, 0x0000005a00087202ULL, 0x002fc80000000f00ULL,
0xfffe8bb008007950ULL, 0x000fea0003c3ffffULL, 0x000000010900780cULL, 0x000fe20003f65070ULL,
0x0000003c00007348ULL, 0x000fd80003800000ULL, 0x0000000000097806ULL, 0x000fc800058e0100ULL,
0x0000003c094d7212ULL, 0x000fe200078ec0ffULL, 0x00000000ff097424ULL, 0x000fc800078e00ffULL,
0xfffe8b5008007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000001ULL, 0x0000000800000002ULL, 0x0000000100000001ULL, 0x0000000800000004ULL,
0x0000001000000001ULL, 0x0000000300000001ULL, 0x0000000400000004ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x000000000000054aULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000006a8ULL,
0x0000000000000258ULL, 0x0000001800000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000900ULL,
0x0000000000000338ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c38ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000cf8ULL,
0x0000000000000670ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001368ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001378ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000007bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001408ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x000000000000140cULL,
0x00000000000001a8ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001600ULL,
0x0000000000017580ULL, 0x7a00001800000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x0000000100000089ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000018b80ULL,
0x000000000000003cULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000018bc0ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x0000000000018f40ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001408ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000017778ULL,
0x0000000000017778ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000018b80ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000018f40ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_1_kvt_bf16_nqpkv_8_m_8_sm_86_cubin_len = 102432;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
