/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_1_kvt_bf16_nqpkv_8_m_8_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000017018ULL, 0x0000000000016c98ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x766e2e0000000000ULL, 0x2e6c61626f6c672eULL, 0x65722e0074696e69ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6e6f632e766e2e00ULL, 0x000033746e617473ULL, 0x536d656d73000000ULL, 0x2e766e2e00657a69ULL,
0x692e6c61626f6c67ULL, 0x4e5a5a5f0074696eULL, 0x7473336164756334ULL, 0x5f5f38345f5f3364ULL,
0x31326c6961746564ULL, 0x676e6f7274735f5fULL, 0x726564726f5f7265ULL, 0x696945616475635fULL,
0x726f66785f5f3745ULL, 0x374b4e5a5a5f006dULL, 0x4944327961727241ULL, 0x326a4c45326a4c66ULL,
0x624c497461324545ULL, 0x6a664b5245454530ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x326a4c66495f5349ULL, 0x6a4c4545326a4c45ULL,
0x324545386a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f30534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x625f766e5f5f3431ULL,
0x32363174616f6c66ULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6a49636556334944ULL, 0x316a4c4545346a4cULL, 0x324545386a4c4536ULL, 0x454531624c497461ULL,
0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL,
0x4944327961727241ULL, 0x6a4c6a4963655633ULL, 0x4536316a4c454534ULL, 0x6132454532336a4cULL,
0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4534366a4c4545ULL,
0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL,
0x45326a4c45326a4cULL, 0x316a4c45316a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL,
0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL,
0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL, 0x4c4545326a4c4532ULL, 0x4545316a4c45346aULL,
0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x32336a4c4545346aULL,
0x61324545386a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x6a4c45386a4c4545ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL,
0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL, 0x30624c4974613245ULL, 0x5f31534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x0000000000676e69ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x65746e695f5f2400ULL, 0x245f305f6c616e72ULL, 0x735f616475635f5fULL,
0x5f7063725f30326dULL, 0x665f7a74665f6e72ULL, 0x70776f6c735f3233ULL, 0x6c65722e00687461ULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x742e616c65722e00ULL, 0x6e72656b2e747865ULL,
0x240061686d5f6c65ULL, 0x6d5f6c656e72656bULL, 0x426d656d73246168ULL, 0x2e00667542657479ULL,
0x72665f6775626564ULL, 0x6c65722e00656d61ULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL,
0x67756265642e616cULL, 0x2e00656d6172665fULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000100000098ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b0003000000a1ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b0001000000b1ULL, 0x000000000000002cULL, 0x0000000000000010ULL, 0x000b0001000000efULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000b000100000128ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x000b00010000016fULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000b0001000001b9ULL, 0x0000000000000010ULL, 0x0000000000000004ULL, 0x000b0001000001ffULL,
0x0000000000000028ULL, 0x0000000000000004ULL, 0x000b000100000246ULL, 0x0000000000000008ULL,
0x0000000000000004ULL, 0x000b00010000028cULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000b0001000002daULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000b000100000328ULL,
0x0000000000000020ULL, 0x0000000000000004ULL, 0x000b00010000036eULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b0001000003b3ULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a00220000040eULL,
0x0000000000015980ULL, 0x0000000000000200ULL, 0x0004000300000484ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000a101200000040ULL, 0x0000000000000000ULL, 0x0000000000015b80ULL,
0x000d0003000004b4ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000024ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001598000000000ULL, 0x0000200400000000ULL, 0x01a0288080810c00ULL, 0x0000003cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080820828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808292ULL,
0x0000001cffffffffULL, 0x0000006000000000ULL, 0x0001598000000000ULL, 0x0000020000000000ULL,
0x0000000000000000ULL, 0x0000001400082f04ULL, 0x0008230400000080ULL, 0x0000000000000012ULL,
0x0000001200081204ULL, 0x00081104000000a0ULL, 0x000000a000000012ULL, 0x0000001400082304ULL,
0x0008120400000000ULL, 0x000000a000000014ULL, 0x0000001400081104ULL, 0x00043704000000a0ULL,
0x000c17040000007bULL, 0x0040000600000000ULL, 0x000c17040021f000ULL, 0x0038000500000000ULL,
0x000c17040021f000ULL, 0x0030000400000000ULL, 0x000c17040011f000ULL, 0x0018000300000000ULL,
0x000c17040061f000ULL, 0x0010000200000000ULL, 0x000c17040021f000ULL, 0x0008000100000000ULL,
0x000c17040021f000ULL, 0x0000000000000000ULL, 0x00801b030011f000ULL, 0x0000ba3000083104ULL,
0x00f429040000bef0ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x00f42804ffffffffULL,
0x00000150000000d0ULL, 0x0000158000000690ULL, 0x0000239000002320ULL, 0x0000259000002450ULL,
0x0000281000002800ULL, 0x0000386000002cf0ULL, 0x00003c2000003870ULL, 0x000048d000004860ULL,
0x00004af0000049b0ULL, 0x00004cd000004cc0ULL, 0x00005aa000004f70ULL, 0x00005d8000005ab0ULL,
0x00006a20000069b0ULL, 0x00006c4000006b00ULL, 0x00006e2000006e10ULL, 0x00007bf0000070c0ULL,
0x00007ed000007c00ULL, 0x00008b7000008b00ULL, 0x00008d9000008c50ULL, 0x00008f7000008f60ULL,
0x00009d6000009250ULL, 0x0000a18000009d70ULL, 0x0000a6800000a190ULL, 0x0000bef00000ba30ULL,
0x0000c3d00000c390ULL, 0x0000c8f00000c8d0ULL, 0x00014d600000cd70ULL, 0x0001504000014e10ULL,
0x000154a0000150c0ULL, 0x000155c0000154d0ULL, 0x01f0390400015630ULL, 0x000000ff000001c0ULL,
0x000401000001c600ULL, 0x00000002000002a0ULL, 0x003f01000001c608ULL, 0x00000002000003b0ULL,
0x003f01000001c688ULL, 0x000000ff000006f0ULL, 0x000601070001c600ULL, 0x0000005c00000880ULL,
0x000601010001c688ULL, 0x0000005c000020e0ULL, 0x000601010001c608ULL, 0x0000005c00002100ULL,
0x000601090001c608ULL, 0x0000005c00002270ULL, 0x000601090001c608ULL, 0x000000ff00003b60ULL,
0x000601010001c688ULL, 0x0000005c00004670ULL, 0x000601010001c628ULL, 0x0000005c00004690ULL,
0x000601090001c628ULL, 0x0000005c00004800ULL, 0x000601090001c628ULL, 0x000000ff00005ce0ULL,
0x000601010001c690ULL, 0x0000005c000067d0ULL, 0x000601010001c648ULL, 0x0000005c000067f0ULL,
0x000601090001c648ULL, 0x0000005c00006960ULL, 0x000601090001c648ULL, 0x000000ff00007e10ULL,
0x000601010001c698ULL, 0x0000005c00008920ULL, 0x000601010001c668ULL, 0x0000005c00008940ULL,
0x000601090001c668ULL, 0x0000005c00008ab0ULL, 0x000601090001c668ULL, 0x000000ff00009f60ULL,
0x000601010001c6a0ULL, 0x000000ff0000d050ULL, 0x000601010001c600ULL, 0x000000ff0000e6f0ULL,
0x000601090001c600ULL, 0x000000ff0000e860ULL, 0x000601090001c600ULL, 0x000000ff000141c0ULL,
0x000801010001c688ULL, 0x000000ff00014450ULL, 0x000801090001c688ULL, 0x000000ff000145c0ULL,
0x000801090001c688ULL, 0x000000ff00015920ULL, 0x000901010001c608ULL, 0x000000ff00015930ULL,
0x000901010001c610ULL, 0x000000ff00015940ULL, 0x000901010001c618ULL, 0x000000ff00015950ULL,
0x000901010001c620ULL, 0x00101c0400033803ULL, 0x0000e8a00000cff0ULL, 0x000159700000e8f0ULL,
0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL, 0x00080a0400481903ULL,
0x0048021000000015ULL, 0x00000000000000bcULL, 0x0000001400000002ULL, 0x0000000000015980ULL,
0x0000000000000044ULL, 0x0000001400000002ULL, 0x0000000000000000ULL, 0x0000000000000098ULL,
0x0000001400000002ULL, 0x0000000000000000ULL, 0x000000000001c700ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e620000000800ULL, 0x0000000000037919ULL, 0x000ea20000002100ULL,
0x00000300000d7ab9ULL, 0x000fe20000000800ULL, 0x0000010000047ab9ULL, 0x000fca0000000800ULL,
0x00008800ff047b82ULL, 0x000ee20000000a00ULL, 0x0000000000077919ULL, 0x000f220000002300ULL,
0x000001a000007945ULL, 0x000fe20003800000ULL, 0xffffff6001017836ULL, 0x002fe20000000000ULL,
0x0000000000027919ULL, 0x000f280000002200ULL, 0x00000000000779c3ULL, 0x000e620000002700ULL,
0x00000000000c7919ULL, 0x000e6e0000000000ULL, 0x00000000000879c3ULL, 0x000e620000002600ULL,
0x00000005ff007819ULL, 0x004fcc0000011603ULL, 0x00001fff00007589ULL, 0x000ea200000e0000ULL,
0x0000000407027c24ULL, 0x010fe2000f8e0202ULL, 0x0000000000047ab9ULL, 0x000fc60000000800ULL,
0x0000000402067c24ULL, 0x000fca000f8e0203ULL, 0x000000ff0600720cULL, 0x040fe40003f05270ULL,
0x0000000f0600780cULL, 0x040fe40003f24070ULL, 0x000000030600780cULL, 0x000fe40003f44070ULL,
0x00000000000e72caULL, 0x004fe400000e0000ULL, 0x00001fff07007589ULL, 0x00046a00000e0000ULL,
0x0000000000240947ULL, 0x00aff00003800000ULL, 0x00000000000579c3ULL, 0x000ee20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x001fff00000a7882ULL, 0x000fe20000000000ULL,
0x7ffc0000000b7882ULL, 0x000fe20000000000ULL, 0x0000065405047896ULL, 0x008fe20008000004ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000000073c6ULL, 0x000ef40000000000ULL,
0x01c6000a043f75b2ULL, 0x0006e40008000100ULL, 0x0000000000007918ULL, 0x00cfe20000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000381947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ee20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x008fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000406027c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000020612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ee40000000000ULL, 0x01c60804063f75b2ULL, 0x0006f00008000100ULL,
0xfffffffd00e81947ULL, 0x00cfea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000382947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000ee20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x008fc60008000004ULL,
0x7ffb000000057882ULL, 0x000fc60000000000ULL, 0x0000000406027c11ULL, 0x000fe2000f8e18ffULL,
0x001ffec000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000020612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000ee40000000000ULL,
0x01c68804063f75b2ULL, 0x0006f00008000100ULL, 0xfffffffd00e81947ULL, 0x00cfea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000a79c3ULL, 0x000ee20000008800ULL,
0x0000000e00027c11ULL, 0x002fe2000f8e10ffULL, 0x0000840000097ab9ULL, 0x000fe20000000800ULL,
0x0000000308047899ULL, 0x000fe2000800063fULL, 0x0000007f0600780cULL, 0x000fe20003f04070ULL,
0x0000000309057899ULL, 0x000fe2000800063fULL, 0x0000000202037824ULL, 0x000fe200078e00ffULL,
0x0000040000067882ULL, 0x000fe20000000000ULL, 0x000000100c177824ULL, 0x000fe200078e00ffULL,
0x00000007050472a4ULL, 0x000fe2000f8e0204ULL, 0x0000000103097836ULL, 0x000fe20000000000ULL,
0x0000000803027848ULL, 0x000fe20007fe0000ULL, 0x0000000103087824ULL, 0x140fe200078e020cULL,
0x00000005030d7819ULL, 0x000fe200000006ffULL, 0x00000001090a7824ULL, 0x000fc400078e020cULL,
0x0000000102077824ULL, 0x004fe200078e0a03ULL, 0xffffffe00d087812ULL, 0x000fe200078ee208ULL,
0x0000000403037c36ULL, 0x000fe20008000000ULL, 0xff317217000d8802ULL, 0x000fe20000000f00ULL,
0x00000004090b7c36ULL, 0x000fe20008000000ULL, 0x000000ff0700720cULL, 0x000fe20003f23070ULL,
0x0000020003027825ULL, 0x100fe200078e0004ULL, 0x000000010700780cULL, 0x000fe20003f43070ULL,
0x000006540a067896ULL, 0x008fe40008000006ULL, 0x000002000b047825ULL, 0x000fe200078e0004ULL,
0x000001f0170b7812ULL, 0x000fe200078ec0ffULL, 0x0001c60006047890ULL, 0x000fc4000fffe03fULL,
0x0000002009097824ULL, 0x000fe200078e00ffULL, 0x0000000b02027210ULL, 0x000fe20007f7e0ffULL,
0x00008200000a7ab9ULL, 0x000fe20000000a00ULL, 0x0000000b04047210ULL, 0x000fe40007f9e0ffULL,
0xffffffe0090a7812ULL, 0x000fe200078ee20aULL, 0x000000ffff037224ULL, 0x000fe200018e0603ULL,
0x0000000606068c11ULL, 0x000fe2000f8e10ffULL, 0x000000ffff057224ULL, 0x000fe200020e0605ULL,
0x0000000608077c11ULL, 0x000fe4000f8e20ffULL, 0x000000060a097c11ULL, 0x000fe2000f8e20ffULL,
0x01c4000d06008388ULL, 0x0003e20000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002077faeULL, 0x0003e8000c901c4aULL,
0x0000000004097faeULL, 0x0003e2000d101c4aULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000ffffff79a7ULL, 0x000fe40008200404ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a84ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00008c0000047ab9ULL, 0x000fc40000000a00ULL,
0x00000004070478a5ULL, 0x000fcc000f8e0004ULL, 0x0000000400027c02ULL, 0x002fe20008000f00ULL,
0x00000005ff037e24ULL, 0x000fca000f8e00ffULL, 0x0000000a02027981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0000720cULL, 0x000fe20003f05270ULL, 0x00000000000479c3ULL, 0x000e620000002500ULL,
0x00000000021172caULL, 0x004fda00000e0000ULL, 0x000000ff11057890ULL, 0x000fc8000fffe03fULL,
0x000000083f057899ULL, 0x000fe20008011605ULL, 0x000000c800088947ULL, 0x002ff60003800000ULL,
0x00000001040c7890ULL, 0x000fe2000fffe03fULL, 0x00000004ff037424ULL, 0x000fe200078e00ffULL,
0x000000030e127899ULL, 0x000fe4000800063fULL, 0x000000050c00728cULL, 0x000fe4000bf06070ULL,
0x0000000908087290ULL, 0x000fe4000fffe03fULL, 0x0000000107077899ULL, 0x000fe2000800063fULL,
0x00000012ff5c7e24ULL, 0x000fe2000f8e00ffULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x00000008040c7899ULL, 0x000fc4000800063fULL, 0x00000009070772a4ULL, 0x000fe2000f8e0208ULL,
0x01c688035cff79a7ULL, 0x0003e40008500006ULL, 0x00008e0000087ab9ULL, 0x000fe40000000800ULL,
0x00000008070972a4ULL, 0x000fca000f8e020cULL, 0x00000004007c8947ULL, 0x000fee0003800000ULL,
0x0000000c1100728cULL, 0x000fe2000bf01070ULL, 0x00008a00ff107b82ULL, 0x000ea20000000a00ULL,
0x00000003ff037819ULL, 0x102fe2000001160cULL, 0x8000000cff007e24ULL, 0x000fe2000f8e02ffULL,
0x0000000c11087287ULL, 0x000fe4000c000000ULL, 0x000000030e0c7899ULL, 0x000fe2000800063fULL,
0x0000000403097836ULL, 0x000fe20000000000ULL, 0x0000001803197810ULL, 0x000fe20007ffe0ffULL,
0x00000008030b7836ULL, 0x000fe20000000000ULL, 0x0000000800057c02ULL, 0x000fe20008000f00ULL,
0x0000000c030f7836ULL, 0x000fe20000000000ULL, 0x0000000309077819ULL, 0x040fe200000006ffULL,
0x0000000109027824ULL, 0x100fe200078e020cULL, 0x0000002005007446ULL, 0x000fe20003800000ULL,
0x000000010b047824ULL, 0x140fe200078e020cULL, 0x000000060e087291ULL, 0x000fe2000f8e683fULL,
0x000000080b0d7824ULL, 0x000fe200078e00ffULL, 0xfffffff807127812ULL, 0x000fe200078ee202ULL,
0x000000010f057824ULL, 0x040fe200078e020cULL, 0x0000000c03027210ULL, 0x000fe20007ffe0ffULL,
0x000000080f167824ULL, 0x000fe200078e00ffULL, 0xfffffff80d147812ULL, 0x000fe200078ee204ULL,
0x0000000cff0d7e24ULL, 0x000fe2000f8e00ffULL, 0x000000000300720cULL, 0x000fe20003f06070ULL,
0x0000001003137836ULL, 0x000fe20000000000ULL, 0xfffffff816167812ULL, 0x000fe200078ee205ULL,
0x0000000903057c36ULL, 0x000fe20008000000ULL, 0x0000000702077812ULL, 0x000fe200078ec0ffULL,
0x0000001403157836ULL, 0x000fe20000000000ULL, 0x0001400008087890ULL, 0x000fe2000fffe03fULL,
0x0000001c031b7836ULL, 0x000fe20000000000ULL, 0xfffffff80d0d7812ULL, 0x000fe200078ee20cULL,
0x0000020005027825ULL, 0x004fe200078e0010ULL, 0x0ffffff807077812ULL, 0x000fc400078ef80cULL,
0x00000003151d7819ULL, 0x000fe200000006ffULL, 0x0000000119057824ULL, 0x000fe200078e020cULL,
0x0000000807077c11ULL, 0x000fe2000f8e20ffULL, 0x000000100d027825ULL, 0x000fe200078e0002ULL,
0x000000000f00720cULL, 0x080fe40003f46070ULL, 0x000000001900720cULL, 0x0c0fe20003fa6070ULL,
0x00000008191a7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002077faeULL, 0x0003e2000c101c4aULL, 0x0000000115067824ULL, 0x100fe200078e020cULL,
0x000000000900720cULL, 0x080fe20003f06070ULL, 0x0000000113047824ULL, 0x140fe200078e020cULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee205ULL, 0x0000000813177824ULL, 0x000fe200078e00ffULL,
0x0000000909097c10ULL, 0x000fe2000fffe0ffULL, 0x000000011b087824ULL, 0x000fe200078e020cULL,
0x000000000b00720cULL, 0x080fe20003f26070ULL, 0x000000081b1f7824ULL, 0x000fe200078e00ffULL,
0x000000001300720cULL, 0x080fe20003f66070ULL, 0x000000090b057c36ULL, 0x000fe20008000000ULL,
0x0000000919197c10ULL, 0x000fe2000fffe0ffULL, 0x000000090f0f7c36ULL, 0x000fe20008000000ULL,
0x000000001b00720cULL, 0x080fe20003fc6070ULL, 0x0000000913137c36ULL, 0x000fe20008000000ULL,
0xfffffff81d187812ULL, 0x000fe200078ee206ULL, 0x00000009150b7c36ULL, 0x000fe20008000000ULL,
0xfffffff817177812ULL, 0x000fe200078ee204ULL, 0x000000091b1b7c36ULL, 0x000fe20008000000ULL,
0xfffffff81f1c7812ULL, 0x000fe200078ee208ULL, 0x0000020009027825ULL, 0x002fe200078e0010ULL,
0x000000001500720cULL, 0x000fc40003f86070ULL, 0x0000000814157c11ULL, 0x000fe2000f8e20ffULL,
0x000002000f067825ULL, 0x100fe200078e0010ULL, 0x0000000817177c11ULL, 0x000fe4000f8e20ffULL,
0x000000081c1d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000020005047825ULL, 0x000fc800078e0010ULL,
0x0000020013087825ULL, 0x000fe200078e0010ULL, 0x0000000812137c11ULL, 0x000fc6000f8e20ffULL,
0x000002000b0a7825ULL, 0x000fc800078e0010ULL, 0x00000200190e7825ULL, 0x000fe200078e0010ULL,
0x0000000818197c11ULL, 0x000fc6000f8e20ffULL, 0x000002001b107825ULL, 0x000fe200078e0010ULL,
0x000000081a1b7c11ULL, 0x000fc6000f8e20ffULL, 0x000000100d027825ULL, 0x000fc800078e0002ULL,
0x000000100d047825ULL, 0x040fe200078e0004ULL, 0x0000000002137faeULL, 0x0003e6000c101c4aULL,
0x000000100d067825ULL, 0x040fe200078e0006ULL, 0x0000000004157faeULL, 0x0003e6000c901c4aULL,
0x000000100d087825ULL, 0x000fc800078e0008ULL, 0x000000100d0a7825ULL, 0x000fc800078e000aULL,
0x000000100d0e7825ULL, 0x000fc800078e000eULL, 0x000000100d107825ULL, 0x000fe200078e0010ULL,
0x00000008160d7c11ULL, 0x000fca000f8e20ffULL, 0x00000000060d7faeULL, 0x0003e8000d101c4aULL,
0x0000000008177faeULL, 0x0003e8000d901c4aULL, 0x000000000a197faeULL, 0x0003e8000e101c4aULL,
0x000000000e1b7faeULL, 0x0003e8000e901c4aULL, 0x00000000101d7faeULL, 0x0003e2000f101c4aULL,
0x0000000400407947ULL, 0x000fea0003800000ULL, 0x000000080c097811ULL, 0x040fe200078fe8ffULL,
0x00008a00ff127b82ULL, 0x000ea20000000a00ULL, 0x000000040c077811ULL, 0x040fe200078fe8ffULL,
0x000000030e0c7899ULL, 0x000fe2000800063fULL, 0x00000003090d7819ULL, 0x040fe200000006ffULL,
0x0000000109027824ULL, 0x100fe200078e020cULL, 0x0000000c0c0b7811ULL, 0x040fe200078fe8ffULL,
0x0000000107007824ULL, 0x140fe200078e020cULL, 0x000000180c117811ULL, 0x040fe200078fe8ffULL,
0x0000000807057824ULL, 0x000fe200078e00ffULL, 0xfffffff80d167812ULL, 0x000fe200078ee202ULL,
0x000000010b037824ULL, 0x142fe200078e020cULL, 0x000000100c0d7811ULL, 0x040fe200078fe8ffULL,
0x000000080b187824ULL, 0x000fe200078e00ffULL, 0xfffffff805147812ULL, 0x000fe200078ee200ULL,
0x00000008111e7824ULL, 0x000fe200078e00ffULL, 0x0000001c0c157811ULL, 0x040fe200078fe8ffULL,
0x000000010d007824ULL, 0x140fe200078e020cULL, 0xfffffff818187812ULL, 0x000fe200078ee203ULL,
0x000000080d057824ULL, 0x000fe200078e00ffULL, 0x000000140c0f7811ULL, 0x040fe200078fe8ffULL,
0x0000000111037824ULL, 0x100fe200078e020cULL, 0x0000000315197819ULL, 0x040fe200000006ffULL,
0x0000000115047824ULL, 0x000fe200078e020cULL, 0xfffffff8051a7812ULL, 0x000fe200078ee200ULL,
0x000000080f177824ULL, 0x000fe200078e00ffULL, 0x0000000c0c007211ULL, 0x000fe200078fe8ffULL,
0x0000000907077c36ULL, 0x000fe20008000000ULL, 0xfffffff81e1e7812ULL, 0x000fe200078ee203ULL,
0x0000000909097c36ULL, 0x000fe20008000000ULL, 0x0000000700057812ULL, 0x000fe200078ec0ffULL,
0x000000060e087291ULL, 0x000fe2000f8e683fULL, 0x0000000c0f027210ULL, 0x000fe20007ffe0ffULL,
0x000000090b0b7c36ULL, 0x000fe20008000000ULL, 0xfffffff819207812ULL, 0x000fe200078ee204ULL,
0x0000000cff197e24ULL, 0x000fe2000f8e00ffULL, 0x000000090c037c11ULL, 0x000fe2000f8fe8ffULL,
0x000000090d0d7c36ULL, 0x000fe20008000000ULL, 0x000000090f0f7c10ULL, 0x000fe2000fffe0ffULL,
0x0000000911117c36ULL, 0x000fe20008000000ULL, 0x0ffffff805007812ULL, 0x000fe200078ef80cULL,
0x0000000915157c36ULL, 0x000fe20008000000ULL, 0xfffffff8171c7812ULL, 0x000fe200078ee202ULL,
0x0000020007047825ULL, 0x004fe200078e0012ULL, 0x0001400008087890ULL, 0x000fe2000fffe03fULL,
0xfffffff819197812ULL, 0x000fc400078ee20cULL, 0x0000020009067825ULL, 0x000fc600078e0012ULL,
0x0000000816177c11ULL, 0x000fe2000f8e20ffULL, 0x0000020003027825ULL, 0x100fe200078e0012ULL,
0x000000081a1b7c11ULL, 0x000fe4000f8e20ffULL, 0x000000081c1d7c11ULL, 0x000fe2000f8e20ffULL,
0x000002000b087825ULL, 0x100fe200078e0012ULL, 0x000000081e1f7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000820217c11ULL, 0x000fe2000f8e20ffULL, 0x000002000d0a7825ULL, 0x000fe200078e0012ULL,
0x00000008000d7c11ULL, 0x000fc6000f8e20ffULL, 0x000002000f0e7825ULL, 0x000fc800078e0012ULL,
0x0000020011107825ULL, 0x000fc800078e0012ULL, 0x0000020015127825ULL, 0x000fe200078e0012ULL,
0x0000000814157c11ULL, 0x000fc6000f8e20ffULL, 0x0000001019027825ULL, 0x000fc800078e0002ULL,
0x0000001019047825ULL, 0x040fe200078e0004ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000020d7faeULL, 0x0003e6000b901c4aULL, 0x0000001019067825ULL, 0x040fe200078e0006ULL,
0x0000000004157faeULL, 0x0003e6000b901c4aULL, 0x0000001019087825ULL, 0x040fe200078e0008ULL,
0x0000000006177faeULL, 0x0003e6000b901c4aULL, 0x00000010190a7825ULL, 0x000fc800078e000aULL,
0x00000010190e7825ULL, 0x000fc800078e000eULL, 0x0000001019107825ULL, 0x000fc800078e0010ULL,
0x0000001019127825ULL, 0x000fe200078e0012ULL, 0x0000000818197c11ULL, 0x000fca000f8e20ffULL,
0x0000000008197faeULL, 0x0003e8000b901c4aULL, 0x000000000a1b7faeULL, 0x0003e8000b901c4aULL,
0x000000000e1d7faeULL, 0x0003e8000b901c4aULL, 0x00000000101f7faeULL, 0x0003e8000b901c4aULL,
0x0000000012217faeULL, 0x0003e4000b901c4aULL, 0x000000050400728cULL, 0x000fe2000bf06070ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xff317217ff0d7424ULL, 0x002fe200078e00ffULL,
0x000000ff000b7202ULL, 0x000fe40000000f00ULL, 0x0000000000327805ULL, 0x000fe4000001ff00ULL,
0x0000000000307805ULL, 0x000fe4000001ff00ULL, 0x000000000000781cULL, 0x000fe40003f0f008ULL,
0x00000000003e7805ULL, 0x000fc4000001ff00ULL, 0x00000000003c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fe4000001ff00ULL, 0x0000000000247805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x00000000001e7805ULL, 0x000fc4000001ff00ULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000167805ULL, 0x000fe4000001ff00ULL, 0x0000000000147805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x00000000002a7805ULL, 0x000fc4000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000008800cc0947ULL, 0x000fec0003800000ULL, 0xff317217ff0d7424ULL, 0x000fe400078e00ffULL,
0x000000ffff337224ULL, 0x000fce00078e00ffULL, 0x0000000804097899ULL, 0x000fc8000800063fULL,
0x000000110900728cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000008800a40947ULL, 0x000fea0003800000ULL, 0x0000000104087890ULL, 0x000fe2000fffe03fULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x000000050800728cULL, 0x000fe4000bf06070ULL,
0x00000020090f7890ULL, 0x000fe2000fffe03fULL, 0x00008e00000c7ab9ULL, 0x000fc60000000800ULL,
0x000000000000781cULL, 0x000fe20003f2f008ULL, 0x0000000c070c72a4ULL, 0x000fd8000f8e020fULL,
0x0000000400789947ULL, 0x000fea0003800000ULL, 0x0000000f1100728cULL, 0x000fe2000bf01070ULL,
0x00000003ff097819ULL, 0x100fe2000001160cULL, 0x8000000fff007e24ULL, 0x000fe4000f8e02ffULL,
0x0000000f11087287ULL, 0x000fe2000c000000ULL, 0x0000000809197810ULL, 0x000fe20007ffe0ffULL,
0x0000000409117836ULL, 0x000fe20000000000ULL, 0x0000001409377810ULL, 0x000fe20007ffe0ffULL,
0x0000000c091b7836ULL, 0x000fe20000000000ULL, 0x0000000319077819ULL, 0x000fe200000006ffULL,
0x00000008ff037e24ULL, 0x000fe2000f8e00ffULL, 0x000000060e087291ULL, 0x000fe2000f8e683fULL,
0x0000000111027824ULL, 0x100fe200078e020cULL, 0x0000000337417819ULL, 0x000fe200000006ffULL,
0x0000000811137824ULL, 0x000fe200078e00ffULL, 0x0000002003007446ULL, 0x000fe20003800000ULL,
0x0000000119047824ULL, 0x100fe200078e020cULL, 0x0001500008087890ULL, 0x000fe2000fffe03fULL,
0x0000001009357836ULL, 0x000fe20000000000ULL, 0xfffffff813137812ULL, 0x000fe200078ee202ULL,
0x000000081b347824ULL, 0x040fe200078e00ffULL, 0x00008a00ff027b82ULL, 0x000e620000000a00ULL,
0xfffffff8070a7812ULL, 0x000fe200078ee204ULL, 0x000000011b077824ULL, 0x100fe200078e020cULL,
0x000000070c047812ULL, 0x000fe200078ec0ffULL, 0x00000008350f7824ULL, 0x000fe200078e00ffULL,
0x0000000c350e7210ULL, 0x000fe20007ffe0ffULL, 0x0000001809397836ULL, 0x000fe20000000000ULL,
0xfffffff834347812ULL, 0x000fe200078ee207ULL, 0x0000001204077c36ULL, 0x000fe20008000000ULL,
0xfffffff80f367812ULL, 0x000fe200078ee20eULL, 0x0000000109047824ULL, 0x100fe200078e020cULL,
0x000000001100720cULL, 0x080fe20003f46070ULL, 0x0000000c090f7c36ULL, 0x000fe20008000000ULL,
0x000000000900720cULL, 0x080fe20003f06070ULL, 0x0000001c093b7836ULL, 0x000fe20000000000ULL,
0x0000000704097812ULL, 0x000fe200078ec0ffULL, 0x0000000c11117c36ULL, 0x000fe20008000000ULL,
0x0000000813137c11ULL, 0x000fe2000f8e20ffULL, 0x0000000137047824ULL, 0x100fe200078e020cULL,
0x0ffffff809097812ULL, 0x000fe200078ef80cULL, 0x0000000139127824ULL, 0x000fe200078e020cULL,
0x000000003700720cULL, 0x080fe20003f86070ULL, 0x0000000839437824ULL, 0x000fe200078e00ffULL,
0x0000000809097c11ULL, 0x000fe2000f8e20ffULL, 0x000002000f0e7825ULL, 0x002fe200078e0002ULL,
0x000000003500720cULL, 0x000fc40003f66070ULL, 0x000000003900720cULL, 0x080fe20003fa6070ULL,
0x0000020011107825ULL, 0x000fe200078e0002ULL, 0xfffffff843387812ULL, 0x000fe400078ee212ULL,
0x000000003b00720cULL, 0x000fe20003fc6070ULL, 0x00000010070e7825ULL, 0x000fe200078e000eULL,
0xfffffff841047812ULL, 0x000fc600078ee204ULL, 0x0000001007107825ULL, 0x000fe200078e0010ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e097faeULL, 0x0003e2000c101c4aULL,
0x000000001900720cULL, 0x080fe40003f06070ULL, 0x000000013b187824ULL, 0x040fe200078e020cULL,
0x0000000010137faeULL, 0x0005e2000d101c4aULL, 0x000000083b457824ULL, 0x000fe200078e00ffULL,
0x000000001b00720cULL, 0x000fe20003f46070ULL, 0x0000000c1b1b7c36ULL, 0x000fe20008000000ULL,
0x0000000c19197c10ULL, 0x000fe2000fffe0ffULL, 0x0000000c35357c36ULL, 0x000fe20008000000ULL,
0xfffffff8453a7812ULL, 0x000fe200078ee218ULL, 0x0000000c37097c36ULL, 0x002fc40008000000ULL,
0x0000000c39377c36ULL, 0x000fe20008000000ULL, 0x0000000c3b397c10ULL, 0x000fe2000fffe0ffULL,
0x00000200190e7825ULL, 0x000fe200078e0002ULL, 0x000000083a3b7c11ULL, 0x000fc6000f8e20ffULL,
0x000002001b107825ULL, 0x004fc800078e0002ULL, 0x0000020035127825ULL, 0x000fe200078e0002ULL,
0x0000000836357c11ULL, 0x000fc6000f8e20ffULL, 0x0000020009187825ULL, 0x000fe200078e0002ULL,
0x000000080a097c11ULL, 0x000fc6000f8e20ffULL, 0x00000200371a7825ULL, 0x000fe200078e0002ULL,
0x0000000804377c11ULL, 0x000fc6000f8e20ffULL, 0x0000020039027825ULL, 0x000fe200078e0002ULL,
0x0000000838397c11ULL, 0x000fc6000f8e20ffULL, 0x00000010070e7825ULL, 0x000fc800078e000eULL,
0x0000001007107825ULL, 0x040fe200078e0010ULL, 0x000000000e097faeULL, 0x0003e6000c101c4aULL,
0x0000001007127825ULL, 0x000fc800078e0012ULL, 0x0000001007187825ULL, 0x000fc800078e0018ULL,
0x00000010071a7825ULL, 0x000fc800078e001aULL, 0x0000001007027825ULL, 0x000fe200078e0002ULL,
0x0000000834077c11ULL, 0x000fca000f8e20ffULL, 0x0000000010077faeULL, 0x0003e8000d101c4aULL,
0x0000000012357faeULL, 0x0003e8000d901c4aULL, 0x0000000018377faeULL, 0x0003e8000e101c4aULL,
0x000000001a397faeULL, 0x0003e8000e901c4aULL, 0x00000000023b7faeULL, 0x0003e2000f101c4aULL,
0x00000004003c7947ULL, 0x000fea0003800000ULL, 0x000000080c137811ULL, 0x040fe200078fe8ffULL,
0x000000060e087291ULL, 0x000fe2000f8e683fULL, 0x0000000c0c197811ULL, 0x040fe400078fe8ffULL,
0x000000040c117811ULL, 0x040fe200078fe8ffULL, 0x0000000113027824ULL, 0x140fe200078e020cULL,
0x0000000c19037210ULL, 0x000fe20007ffe0ffULL, 0x0000000813397824ULL, 0x000fe200078e00ffULL,
0x000000140c357811ULL, 0x040fe200078fe8ffULL, 0x0000000819387824ULL, 0x000fe200078e00ffULL,
0x000000100c1b7811ULL, 0x040fe200078fe8ffULL, 0x0000000111007824ULL, 0x140fe200078e020cULL,
0xfffffff839397812ULL, 0x000fe200078ee202ULL, 0x0000000811077824ULL, 0x000fe200078e00ffULL,
0xfffffff838387812ULL, 0x000fe200078ee203ULL, 0x0000000135047824ULL, 0x100fe200078e020cULL,
0x00008a00ff027b82ULL, 0x000e620000000a00ULL, 0x000000180c377811ULL, 0x040fe200078fe8ffULL,
0x000000081b417824ULL, 0x000fe200078e00ffULL, 0x0000001c0c477811ULL, 0x040fe200078fe8ffULL,
0x0000000c11117c36ULL, 0x000fe20008000000ULL, 0x0000000335437819ULL, 0x000fe200000006ffULL,
0x00000008370e7824ULL, 0x000fe200078e00ffULL, 0xfffffff8070a7812ULL, 0x000fe200078ee200ULL,
0x000000011b007824ULL, 0x100fe200078e020cULL, 0xfffffff843437812ULL, 0x000fe200078ee204ULL,
0x0000000137077824ULL, 0x100fe200078e020cULL, 0x0000000c0c047211ULL, 0x040fe200078fe8ffULL,
0x0000000147097824ULL, 0x040fe200078e020cULL, 0x0000000c0c0f7c11ULL, 0x040fe2000f8fe8ffULL,
0x00000008473a7824ULL, 0x000fe200078e00ffULL, 0xfffffff841417812ULL, 0x000fe200078ee200ULL,
0x0000000c13137c36ULL, 0x000fe20008000000ULL, 0x0000000c35357c10ULL, 0x000fe2000fffe0ffULL,
0x0000000c19197c36ULL, 0x000fe20008000000ULL, 0xfffffff80e457812ULL, 0x000fe200078ee207ULL,
0x0000000c1b1b7c36ULL, 0x000fe20008000000ULL, 0xfffffff83a3a7812ULL, 0x000fe200078ee209ULL,
0x0000000c37377c36ULL, 0x000fe20008000000ULL, 0x000000070c007812ULL, 0x000fe200078ec0ffULL,
0x0000000c47077c36ULL, 0x000fe20008000000ULL, 0x0000000704097812ULL, 0x000fe200078ec0ffULL,
0x0001500008087890ULL, 0x000fe2000fffe03fULL, 0x000002000f0e7825ULL, 0x002fe200078e0002ULL,
0x00000012003b7c10ULL, 0x000fc4000fffe0ffULL, 0x0ffffff809097812ULL, 0x000fe200078ef80cULL,
0x0000020011107825ULL, 0x100fe200078e0002ULL, 0x0000000839397c11ULL, 0x000fe4000f8e20ffULL,
0x0000000841417c11ULL, 0x000fe2000f8e20ffULL, 0x0000020013127825ULL, 0x100fe200078e0002ULL,
0x0000000843437c11ULL, 0x000fe4000f8e20ffULL, 0x0000000845457c11ULL, 0x000fe2000f8e20ffULL,
0x0000020019187825ULL, 0x000fe200078e0002ULL, 0x000000083a477c11ULL, 0x000fc6000f8e20ffULL,
0x000002001b1a7825ULL, 0x000fc800078e0002ULL, 0x0000020035347825ULL, 0x000fc800078e0002ULL,
0x0000020037367825ULL, 0x000fc800078e0002ULL, 0x0000020007027825ULL, 0x000fe200078e0002ULL,
0x0000000809077c11ULL, 0x000fe4000f8e20ffULL, 0x000000080a097c11ULL, 0x000fe2000f8e20ffULL,
0x000000103b0e7825ULL, 0x000fc800078e000eULL, 0x000000103b107825ULL, 0x040fe200078e0010ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e077faeULL, 0x0003e6000b901c4aULL,
0x000000103b127825ULL, 0x040fe200078e0012ULL, 0x0000000010097faeULL, 0x0003e6000b901c4aULL,
0x000000103b187825ULL, 0x040fe200078e0018ULL, 0x0000000012397faeULL, 0x0003e6000b901c4aULL,
0x000000103b1a7825ULL, 0x000fc800078e001aULL, 0x000000103b347825ULL, 0x000fc800078e0034ULL,
0x000000103b367825ULL, 0x000fc800078e0036ULL, 0x000000103b027825ULL, 0x000fe200078e0002ULL,
0x00000008383b7c11ULL, 0x000fca000f8e20ffULL, 0x00000000183b7faeULL, 0x0003e8000b901c4aULL,
0x000000001a417faeULL, 0x0003e8000b901c4aULL, 0x0000000034437faeULL, 0x0003e8000b901c4aULL,
0x0000000036457faeULL, 0x0003e8000b901c4aULL, 0x0000000002477faeULL, 0x0003e4000b901c4aULL,
0x00000001ff117424ULL, 0x002fe200078e00ffULL, 0x00000000000079afULL, 0x000e2a0000000000ULL,
0x01c608115c1079a7ULL, 0x0002a40008500006ULL, 0x0000000000027805ULL, 0x000fce0000015200ULL,
0x01c608115c0075a7ULL, 0x004ea40008000146ULL, 0x00000000005c0947ULL, 0x004fea0003800000ULL,
0x000000ffff047224ULL, 0x000fce00078e00ffULL, 0x000000100400780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000000e7805ULL, 0x000fce0000015200ULL,
0x0000000e02077210ULL, 0x000fc80007f1e1ffULL, 0x0000000f030e7210ULL, 0x000fe400007fe5ffULL,
0x003d09000700780cULL, 0x000fc80003f06070ULL, 0x000000ff0e00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400700780cULL, 0x000fc80003f06070ULL,
0x000000ff0e00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc8000001140eULL, 0x0000000700007211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e060eULL, 0x0000000200007819ULL, 0x000fc80000001207ULL,
0x000000000000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000104047836ULL, 0x000fce0000000000ULL, 0x01c608115c0075a7ULL, 0x000ea40008000146ULL,
0xfffffffc00a88947ULL, 0x004fea000383ffffULL, 0x000000100c0a7824ULL, 0x000fe200078e00ffULL,
0x00000001ff007819ULL, 0x000fe2000001160cULL, 0x000000ffff097224ULL, 0x000fc600078e000dULL,
0x000000700a0a7812ULL, 0x000fe400078ec0ffULL, 0x0000000c00037812ULL, 0x000fc800078ec0ffULL,
0x00000006030a7c10ULL, 0x000fca000fffe00aULL, 0x01c000000a007984ULL, 0x000ea80000000800ULL,
0x01c200000a117984ULL, 0x0006e20000000800ULL, 0x0000000d0000720bULL, 0x004fda0003f1d000ULL,
0x0000000000027806ULL, 0x000fe400000e0100ULL, 0x000000000000781cULL, 0x000fe40003f0e170ULL,
0x0000ffff02037812ULL, 0x000fda000784c0ffULL, 0x0000000000e8a947ULL, 0x00afea0003800000ULL,
0x0000000d0000720bULL, 0x000fe40003f54000ULL, 0x0000000eff007c0cULL, 0x000fe4000bf65270ULL,
0x000000000d097209ULL, 0x000fd20007810000ULL, 0x0000000000047806ULL, 0x000fe400010e0100ULL,
0x01c400090a00b388ULL, 0x0003e40000000800ULL, 0x0000991004027816ULL, 0x000fc800000000ffULL,
0x000000ff0200720cULL, 0x000fda0003f45270ULL, 0x0000000000b0a947ULL, 0x002fea0003800000ULL,
0x800000090d027221ULL, 0x000fe20000010000ULL, 0x000000ff04ff7812ULL, 0x040fe4000784c0ffULL,
0x0000ff0004ff7812ULL, 0x000fe2000786c0ffULL, 0x3fb8aa3b02027820ULL, 0x000fc80000410000ULL,
0x0000000200077308ULL, 0x0002ac0000000800ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x00000002ff027819ULL, 0x002fcc000001160cULL, 0x00001f0207027589ULL, 0x004e6400000e0000ULL,
0x0000000228287220ULL, 0x082fe20000410000ULL, 0x0000000229297220ULL, 0x080fe20000410000ULL,
0x000000022c2c7220ULL, 0x080fe20000410000ULL, 0x000000022d2d7220ULL, 0x080fe20000410000ULL,
0x0000000214147220ULL, 0x080fe20000410000ULL, 0x0000000215157220ULL, 0x080fe20000410000ULL,
0x000000021c1c7220ULL, 0x080fe20000410000ULL, 0x000000021d1d7220ULL, 0x080fe20000410000ULL,
0x0000000220207220ULL, 0x080fe20000410000ULL, 0x0000000221217220ULL, 0x080fe20000410000ULL,
0x0000000224247220ULL, 0x080fe20000410000ULL, 0x0000000225257220ULL, 0x080fe20000410000ULL,
0x000000023c3c7220ULL, 0x080fe20000410000ULL, 0x000000023d3d7220ULL, 0x080fe20000410000ULL,
0x0000000230307220ULL, 0x080fe20000410000ULL, 0x0000000231317220ULL, 0x000fce0000410000ULL,
0x000000070b0b7220ULL, 0x004fe20000410000ULL, 0x000000000048b947ULL, 0x000fec0003800000ULL,
0x000000080c027811ULL, 0x002fcc00078ff0ffULL, 0x00001f0207027589ULL, 0x000e6400000e0000ULL,
0x000000022a2a7220ULL, 0x082fe20000410000ULL, 0x000000022b2b7220ULL, 0x080fe20000410000ULL,
0x000000022e2e7220ULL, 0x080fe20000410000ULL, 0x000000022f2f7220ULL, 0x080fe20000410000ULL,
0x0000000216167220ULL, 0x080fe20000410000ULL, 0x0000000217177220ULL, 0x080fe20000410000ULL,
0x000000021e1e7220ULL, 0x080fe20000410000ULL, 0x000000021f1f7220ULL, 0x080fe20000410000ULL,
0x0000000222227220ULL, 0x080fe20000410000ULL, 0x0000000223237220ULL, 0x080fe20000410000ULL,
0x0000000226267220ULL, 0x080fe20000410000ULL, 0x0000000227277220ULL, 0x080fe20000410000ULL,
0x000000023e3e7220ULL, 0x080fe20000410000ULL, 0x000000023f3f7220ULL, 0x080fe20000410000ULL,
0x0000000232327220ULL, 0x080fe20000410000ULL, 0x0000000233337220ULL, 0x000fce0000410000ULL,
0x0000ffff03ff7812ULL, 0x000fda0007846004ULL, 0x8000000900002221ULL, 0x000fe20000010000ULL,
0x000000000000281cULL, 0x000fc60003f0f070ULL, 0x3fb8aa3b00002820ULL, 0x000fc80000410000ULL,
0x0000000000082308ULL, 0x000ea40000000800ULL, 0x0000000811112220ULL, 0x004fce0000410000ULL,
0x000000070c5d7812ULL, 0x000fe200078ec0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000085d137812ULL, 0x000fe400078ef80cULL, 0x000000080c037812ULL, 0x040fe400078ec0ffULL,
0x000000130c077211ULL, 0x000fe400078fe0ffULL, 0x0000000313527819ULL, 0x000fe400000006ffULL,
0x0000000703037812ULL, 0x000fe400078ef80cULL, 0xfffffff852527812ULL, 0x000fc400078ee207ULL,
0x000000030c027211ULL, 0x002fe200078fe0ffULL, 0x0000000803197824ULL, 0x000fe200078e00ffULL,
0x0000000652527c11ULL, 0x000fe2000f8e20ffULL, 0x0000000000188947ULL, 0x000fec0003800000ULL,
0x00000002ff0d7819ULL, 0x000fe4000001160cULL, 0x00000008ff00723eULL, 0x000fc600000010ffULL,
0x000000080d057836ULL, 0x000fe20000000000ULL, 0x0000541000007816ULL, 0x000fca0000000000ULL,
0x00001f0d00067589ULL, 0x0002a800000e0000ULL, 0x00001f0500057589ULL, 0x0002e400000e0000ULL,
0x012000005234783bULL, 0x0002e20000000200ULL, 0x0000000000108947ULL, 0x000fea0003800000ULL,
0x0000000634347232ULL, 0x08cfe40000200000ULL, 0x0000000636367232ULL, 0x000fe40000200000ULL,
0x0000000535357232ULL, 0x080fe40000200000ULL, 0x0000000537377232ULL, 0x000fce0000200000ULL,
0x00000008030d7824ULL, 0x042fe200078e00ffULL, 0x000000060e087291ULL, 0x000fe2000f8e683fULL,
0x0000000402107836ULL, 0x000fe20000000000ULL, 0x00000002020f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000803007824ULL, 0x000fe200078e00ffULL, 0x0001400008147890ULL, 0x000fe2000fffe03fULL,
0xfffffff8190e7812ULL, 0x000fe200078ee202ULL, 0x0000000813597824ULL, 0x000fe200078e00ffULL,
0xfffffff80d107812ULL, 0x000fe200078ee210ULL, 0x00000006020d7836ULL, 0x000fe20000000000ULL,
0xfffffff8000f7812ULL, 0x000fc400078ee20fULL, 0x0000001410567c11ULL, 0x000fe4000f8e20ffULL,
0xfffffff8000d7812ULL, 0x000fe200078ee20dULL, 0x0000000207007836ULL, 0x000fe20000000000ULL,
0x000000140e517c11ULL, 0x000fe2000f8e20ffULL, 0x000000005618783bULL, 0x000e620000004200ULL,
0x000000140d577c11ULL, 0x000fe4000f8e20ffULL, 0x000000140f547c11ULL, 0x000fe2000f8e20ffULL,
0x000000005144783bULL, 0x000fe20000004200ULL, 0x0000001003037812ULL, 0x000fc400078efcffULL,
0xfffffff859597812ULL, 0x000fe200078ee200ULL, 0x000000005738783bULL, 0x000f220000004200ULL,
0x000000030c047211ULL, 0x000fe400078fe0ffULL, 0x0000000303127819ULL, 0x000fe200000006ffULL,
0x000000005440783bULL, 0x000f620000004200ULL, 0x0000000404027810ULL, 0x000fe20007ffe0ffULL,
0x0000000604007836ULL, 0x000fe20000000000ULL, 0x0000000659597c11ULL, 0x000fe2000f8e20ffULL,
0x000000183420723cULL, 0x00afec0000041820ULL, 0x0000001a3424723cULL, 0x000fec0000041824ULL,
0x000000383418723cULL, 0x010fec000004183cULL, 0x000000443428723cULL, 0x000fe20000041828ULL,
0x00000008033d7824ULL, 0x000fc400078e00ffULL, 0x0000000803397824ULL, 0x040fe400078e00ffULL,
0x00000008033f7824ULL, 0x000fe200078e00ffULL, 0x00000046342c723cULL, 0x000fe2000004182cULL,
0x0000000204037836ULL, 0x000fe20000000000ULL, 0xfffffff839047812ULL, 0x000fe400078ee204ULL,
0xfffffff83d027812ULL, 0x000fe400078ee202ULL, 0x000000403414723cULL, 0x020fe20000041814ULL,
0xfffffff812037812ULL, 0x000fc400078ee203ULL, 0xfffffff83f007812ULL, 0x000fe400078ee200ULL,
0x0000001403557c11ULL, 0x000fe2000f8e20ffULL, 0x00000042341c723cULL, 0x000fe2000004181cULL,
0x0000001402537c11ULL, 0x000fe4000f8e20ffULL, 0x0000001404587c11ULL, 0x000fc6000f8e20ffULL,
0x0000003a3430723cULL, 0x000fe20000041830ULL, 0x012000005934783bULL, 0x0002e20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000108947ULL, 0x000fde0003800000ULL,
0x0000000634347232ULL, 0x08cfe40000200000ULL, 0x0000000636367232ULL, 0x000fe40000200000ULL,
0x0000000535357232ULL, 0x080fe40000200000ULL, 0x0000000537377232ULL, 0x000fce0000200000ULL,
0x0000001400507c11ULL, 0x000fe2000f8e20ffULL, 0x00000000583c783bULL, 0x000f220000004200ULL,
0x0000004009107890ULL, 0x000fe2000fffe03fULL, 0x0000000b110b7221ULL, 0x000fe20000010000ULL,
0x00008e00000c7ab9ULL, 0x000fe20000000800ULL, 0x000000005544783bULL, 0x000f620000004200ULL,
0x0000000c071372a4ULL, 0x000fc6000f8e0210ULL, 0x000000005340783bULL, 0x000f680000004200ULL,
0x000000005038783bULL, 0x000f620000004200ULL, 0x0000003c3428723cULL, 0x018fec0000041828ULL,
0x0000003e342c723cULL, 0x000fec000004182cULL, 0x000000443414723cULL, 0x022fec0000041814ULL,
0x00000046341c723cULL, 0x000fec000004181cULL, 0x000000403420723cULL, 0x000fec0000041820ULL,
0x000000423424723cULL, 0x000fec0000041824ULL, 0x00000038343c723cULL, 0x004fec0000041818ULL,
0x0000003a3430723cULL, 0x000fe20000041830ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000400749947ULL, 0x000fde0003800000ULL,
0x000000101100728cULL, 0x000fe2000bf01070ULL, 0x00000003ff197819ULL, 0x000fe2000001160cULL,
0x80000010ff387e24ULL, 0x000fe2000f8e02ffULL, 0x00008a0000167ab9ULL, 0x000fe20000000a00ULL,
0x00000010110f7287ULL, 0x000fe2000c000000ULL, 0x00000014194b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000419357836ULL, 0x000fe40000000000ULL, 0x0000000c19417836ULL, 0x000fe40000000000ULL,
0x0000000fff1b7e24ULL, 0x000fe2000f8e00ffULL, 0x0000000c35117210ULL, 0x000fe20007ffe0ffULL,
0x00000008353a7824ULL, 0x000fc400078e00ffULL, 0x0000001019497836ULL, 0x000fe20000000000ULL,
0x000000201b387446ULL, 0x000fe20003800038ULL, 0x00000008191b7836ULL, 0x000fe20000000000ULL,
0xfffffff83a3a7812ULL, 0x000fe200078ee211ULL, 0x0000000141127824ULL, 0x100fe200078e020cULL,
0x0000000c49187210ULL, 0x000fe20007ffe0ffULL, 0x000000011b117824ULL, 0x100fe200078e020cULL,
0x000000381900720cULL, 0x080fe20003f46070ULL, 0x000000081b1a7824ULL, 0x000fe200078e00ffULL,
0x000000383500720cULL, 0x080fe20003f66070ULL, 0x0000000841377824ULL, 0x000fe200078e00ffULL,
0x000000381b00720cULL, 0x080fe20003f86070ULL, 0x0000000849397824ULL, 0x000fe200078e00ffULL,
0xfffffff81a3b7812ULL, 0x000fe200078ee211ULL, 0x00000018194d7836ULL, 0x000fe20000000000ULL,
0xfffffff837427812ULL, 0x000fe200078ee212ULL, 0x0000001319377c36ULL, 0x000fe20008000000ULL,
0x0000000c191a7210ULL, 0x000fe20007ffe0ffULL, 0x0000001c194f7836ULL, 0x000fe20000000000ULL,
0xfffffff839447812ULL, 0x000fe200078ee218ULL, 0x00000016ff187e24ULL, 0x000fe2000f8e00ffULL,
0x0000001700197c02ULL, 0x000fe20008000f00ULL, 0x0000001335357c36ULL, 0x000fe20008000000ULL,
0x0ffffff80c117812ULL, 0x000fe200078ec0ffULL, 0x000000131b1b7c36ULL, 0x000fe20008000000ULL,
0x000000143a457c11ULL, 0x000fe2000f8e20ffULL, 0x000000014b407824ULL, 0x040fe200078e020cULL,
0x0000000711397812ULL, 0x000fe200078ef81aULL, 0x000000084b437824ULL, 0x000fe200078e00ffULL,
0x000000143b477c11ULL, 0x000fe2000f8e20ffULL, 0x0000020037367825ULL, 0x000fe200078e0018ULL,
0x000000384d00720cULL, 0x000fc40003fa6070ULL, 0xfffffff843407812ULL, 0x000fe200078ee240ULL,
0x000000125d127c36ULL, 0x000fe20008000000ULL, 0x0000001439437c11ULL, 0x000fe2000f8e20ffULL,
0x0000020035347825ULL, 0x100fe200078e0018ULL, 0x000000384f00720cULL, 0x000fe40003fc6070ULL,
0x0000000c4f487210ULL, 0x000fe20007ffe0ffULL, 0x000002001b1a7825ULL, 0x000fc800078e0018ULL,
0x0000001012367825ULL, 0x000fc800078e0036ULL, 0x0000001012347825ULL, 0x040fe200078e0034ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000036437faeULL, 0x0003e2000d101c4aULL,
0x000000384100720cULL, 0x080fe40003f46070ULL, 0x00000010121a7825ULL, 0x000fe200078e001aULL,
0x0000000034457faeULL, 0x0005e2000d901c4aULL, 0x000000384900720cULL, 0x080fe40003f66070ULL,
0x00000013413b7c36ULL, 0x000fe20008000000ULL, 0x000000001a477faeULL, 0x0007e2000e101c4aULL,
0x0000001349397c36ULL, 0x000fe20008000000ULL, 0x000000384b00720cULL, 0x000fe20003f86070ULL,
0x000000134b417c36ULL, 0x000fe20008000000ULL, 0x000000134d437c10ULL, 0x002fe2000fffe0ffULL,
0x000000014d467824ULL, 0x000fc400078e020cULL, 0x000000084d5b7824ULL, 0x000fe400078e00ffULL,
0x000000134f457c36ULL, 0x004fe40008000000ULL, 0x000002003b3a7825ULL, 0x000fe200078e0018ULL,
0xfffffff85b467812ULL, 0x000fc600078ee246ULL, 0x000000084f5f7824ULL, 0x000fe200078e00ffULL,
0x0000001446477c11ULL, 0x008fe2000f8e20ffULL, 0x0000020039387825ULL, 0x000fc600078e0018ULL,
0xfffffff85f487812ULL, 0x000fe200078ee248ULL, 0x0000020041367825ULL, 0x100fe200078e0018ULL,
0x0000001442417c11ULL, 0x000fe4000f8e20ffULL, 0x0000001448497c11ULL, 0x000fe2000f8e20ffULL,
0x0000020043347825ULL, 0x000fe200078e0018ULL, 0x0000001444437c11ULL, 0x000fc6000f8e20ffULL,
0x00000200451a7825ULL, 0x000fe200078e0018ULL, 0x0000001440457c11ULL, 0x000fc6000f8e20ffULL,
0x00000010123a7825ULL, 0x000fc800078e003aULL, 0x0000001012387825ULL, 0x040fe200078e0038ULL,
0x000000003a417faeULL, 0x0003e6000d101c4aULL, 0x0000001012367825ULL, 0x040fe200078e0036ULL,
0x0000000038437faeULL, 0x0003e6000d901c4aULL, 0x0000001012347825ULL, 0x040fe200078e0034ULL,
0x0000000036457faeULL, 0x0003e6000e101c4aULL, 0x00000010121a7825ULL, 0x000fe200078e001aULL,
0x0000000034477faeULL, 0x0003e8000e901c4aULL, 0x000000001a497faeULL, 0x0003e2000f101c4aULL,
0x0000000400307947ULL, 0x000fea0003800000ULL, 0x00008a00ff187b82ULL, 0x000e620000000a00ULL,
0x000000040c1b7811ULL, 0x040fe400078fe8ffULL, 0x000000080c357811ULL, 0x040fe400078fe8ffULL,
0x000000100c457811ULL, 0x040fe200078fe8ffULL, 0x000000011b117824ULL, 0x140fe200078e020cULL,
0x0000000c0c3b7811ULL, 0x040fe200078fe8ffULL, 0x000000081b127824ULL, 0x000fe200078e00ffULL,
0x000000140c4d7811ULL, 0x040fe200078fe8ffULL, 0x00000001451a7824ULL, 0x100fe200078e020cULL,
0x00000003353a7819ULL, 0x000fe200000006ffULL, 0x0000000845417824ULL, 0x000fe200078e00ffULL,
0xfffffff812397812ULL, 0x000fe200078ee211ULL, 0x0000000135117824ULL, 0x100fe200078e020cULL,
0x0000000c4d347210ULL, 0x000fe20007ffe0ffULL, 0x000000013b127824ULL, 0x040fe200078e020cULL,
0xfffffff841467812ULL, 0x000fe200078ee21aULL, 0x000000083b377824ULL, 0x000fe200078e00ffULL,
0xfffffff83a3a7812ULL, 0x000fe200078ee211ULL, 0x000000084d437824ULL, 0x000fe200078e00ffULL,
0x0000000c0c1a7211ULL, 0x040fe200078fe8ffULL, 0x000000131b1b7c36ULL, 0x000fe20008000000ULL,
0x0ffffff80c117812ULL, 0x040fe200078ec0ffULL, 0x0000001335357c36ULL, 0x000fe20008000000ULL,
0xfffffff837447812ULL, 0x000fe200078ee212ULL, 0x000000125d127c36ULL, 0x000fe20008000000ULL,
0x000000130c377c11ULL, 0x000fc4000f8fe8ffULL, 0xfffffff843487812ULL, 0x000fe200078ee234ULL,
0x0000020035347825ULL, 0x102fe200078e0018ULL, 0x0000000711387812ULL, 0x000fe400078ef81aULL,
0x000000180c4f7811ULL, 0x040fe200078fe8ffULL, 0x000002001b1a7825ULL, 0x100fe200078e0018ULL,
0x0000001c0c5b7811ULL, 0x000fe400078fe8ffULL, 0x0000001438477c11ULL, 0x000fe2000f8e20ffULL,
0x0000020037367825ULL, 0x000fe200078e0018ULL, 0x0000001439497c11ULL, 0x000fc4000f8e20ffULL,
0x0000000c4f4a7210ULL, 0x000fe20007ffe0ffULL, 0x0000001012407825ULL, 0x000fe200078e001aULL,
0x000000143a4b7c11ULL, 0x000fc6000f8e20ffULL, 0x0000001012427825ULL, 0x000fe200078e0034ULL,
0x0000001345357c10ULL, 0x000fc6000fffe0ffULL, 0x000000133b1b7c36ULL, 0x000fe40008000000ULL,
0x0000001012367825ULL, 0x000fc800078e0036ULL, 0x000000134d3b7c36ULL, 0x000fe20008000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000036477faeULL, 0x0003e2000b901c4aULL,
0x000000134f397c36ULL, 0x000fe40008000000ULL, 0x000000084f5f7824ULL, 0x000fe200078e00ffULL,
0x0000000040497faeULL, 0x0005e2000b901c4aULL, 0x000000135b457c36ULL, 0x000fe40008000000ULL,
0x000002001b1a7825ULL, 0x000fe200078e0018ULL, 0xfffffff85f4a7812ULL, 0x000fe200078ee24aULL,
0x00000000424b7faeULL, 0x0007e4000b901c4aULL, 0x000000015b4c7824ULL, 0x040fe200078e020cULL,
0x000000144a477c11ULL, 0x002fe2000f8e20ffULL, 0x000000085b617824ULL, 0x000fc400078e00ffULL,
0x0000020035347825ULL, 0x100fe200078e0018ULL, 0x0000001444417c11ULL, 0x004fe4000f8e20ffULL,
0xfffffff8614c7812ULL, 0x000fe200078ee24cULL, 0x000002003b3a7825ULL, 0x000fe200078e0018ULL,
0x0000001446437c11ULL, 0x008fc6000f8e20ffULL, 0x0000020039387825ULL, 0x000fe200078e0018ULL,
0x000000144c497c11ULL, 0x000fc6000f8e20ffULL, 0x0000020045367825ULL, 0x000fe200078e0018ULL,
0x0000001448457c11ULL, 0x000fc6000f8e20ffULL, 0x00000010121a7825ULL, 0x000fc800078e001aULL,
0x0000001012347825ULL, 0x040fe200078e0034ULL, 0x000000001a417faeULL, 0x0003e6000b901c4aULL,
0x00000010123a7825ULL, 0x040fe200078e003aULL, 0x0000000034437faeULL, 0x0003e6000b901c4aULL,
0x0000001012387825ULL, 0x040fe200078e0038ULL, 0x000000003a457faeULL, 0x0003e6000b901c4aULL,
0x0000001012367825ULL, 0x000fe200078e0036ULL, 0x0000000038477faeULL, 0x0003e8000b901c4aULL,
0x0000000036497faeULL, 0x0003e4000b901c4aULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000004071a7836ULL, 0x002fe20000000000ULL, 0x00000003131b7819ULL, 0x000fc800000006ffULL,
0xfffffff81b1a7812ULL, 0x000fc800078ee21aULL, 0x000000061a4f7c11ULL, 0x000fe2000f8e20ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000000000188947ULL, 0x000fea0003800000ULL,
0x00000002ff1b7819ULL, 0x000fe4000001160cULL, 0x00000008ff05723eULL, 0x000fc600000010ffULL,
0x000000081b357836ULL, 0x000fe20000000000ULL, 0x00005410051a7816ULL, 0x000fca0000000005ULL,
0x00001f1b1a067589ULL, 0x0002a800000e0000ULL, 0x00001f351a057589ULL, 0x0002e400000e0000ULL,
0x012000004f34783bULL, 0x0022e20000000200ULL, 0x0000000000108947ULL, 0x000fea0003800000ULL,
0x0000000634347232ULL, 0x08cfe40000200000ULL, 0x0000000636367232ULL, 0x000fe40000200000ULL,
0x0000000535357232ULL, 0x080fe40000200000ULL, 0x0000000537377232ULL, 0x000fce0000200000ULL,
0x00015000080f7890ULL, 0x000fe2000fffe03fULL, 0x0000000607077836ULL, 0x000fca0000000000ULL,
0x0000000f0f4d7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000f0e4e7c11ULL, 0x000fe2000f8e20ffULL,
0x00000008130e7824ULL, 0x000fe200078e00ffULL, 0x0000000f104c7c11ULL, 0x000fe2000f8e20ffULL,
0x000000004d38783bULL, 0x000f220000004200ULL, 0x0000000f0d0f7c11ULL, 0x000fe4000f8e20ffULL,
0xfffffff80e077812ULL, 0x000fe200078ee207ULL, 0x000000004e48783bULL, 0x000f620000004200ULL,
0x0000000f04047c11ULL, 0x000fc4000f8e20ffULL, 0x0000000607077c11ULL, 0x000fe2000f8e20ffULL,
0x000000004c40783bULL, 0x000f620000004200ULL, 0x0000000f03037c11ULL, 0x000fe4000f8e20ffULL,
0x0000000f02027c11ULL, 0x000fe2000f8e20ffULL, 0x000000000f44783bULL, 0x000f620000004200ULL,
0x000000383414723cULL, 0x018fec0000041814ULL, 0x000000483428723cULL, 0x022fec0000041828ULL,
0x0000004a342c723cULL, 0x000fec000004182cULL, 0x0000003a341c723cULL, 0x000fec000004181cULL,
0x000000403420723cULL, 0x000fec0000041820ULL, 0x000000423424723cULL, 0x000fec0000041824ULL,
0x00000044343c723cULL, 0x004fec000004183cULL, 0x000000463430723cULL, 0x000fe20000041830ULL,
0x012000000734783bULL, 0x0002a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000108947ULL, 0x000fde0003800000ULL, 0x0000000634347232ULL, 0x084fe40000200000ULL,
0x0000000636367232ULL, 0x000fe40000200000ULL, 0x0000000535357232ULL, 0x080fe40000200000ULL,
0x0000000537377232ULL, 0x000fce0000200000ULL, 0x0000000f00007c11ULL, 0x000fe2000f8e20ffULL,
0x000000000448783bULL, 0x000ee20000004200ULL, 0x000000111000728cULL, 0x000fe2000bf06070ULL,
0x00000001ff137424ULL, 0x000fe200078e00ffULL, 0x00000009000d7202ULL, 0x000fe20000000f00ULL,
0x000000000344783bULL, 0x000f260000004200ULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x000000000240783bULL, 0x000f680000004200ULL, 0x000000000038783bULL, 0x000f220000004200ULL,
0x01c68813ffff79a7ULL, 0x0007e40008500006ULL, 0x000000483428723cULL, 0x00cfec0000041828ULL,
0x0000004a342c723cULL, 0x000fec000004182cULL, 0x000000443414723cULL, 0x010fec0000041814ULL,
0x00000046341c723cULL, 0x000fec000004181cULL, 0x000000403420723cULL, 0x022fec0000041820ULL,
0x000000423424723cULL, 0x000fec0000041824ULL, 0x00000038343c723cULL, 0x000fec000004183cULL,
0x0000003a3430723cULL, 0x000fe20000041830ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000006000fc0947ULL, 0x000fde0003800000ULL, 0x0000006009107890ULL, 0x000fe2000fffe03fULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000000c070872a4ULL, 0x000fe2000f8e0210ULL,
0x0000000400609947ULL, 0x000ff60003800000ULL, 0x000000101100728cULL, 0x000fe2000bf01070ULL,
0x00000003ff1b7819ULL, 0x100fe2000001160cULL, 0x80000010ff447e24ULL, 0x000fe4000f8e02ffULL,
0x00000010110c7287ULL, 0x000fe2000c000000ULL, 0x0000000c1b4b7810ULL, 0x000fe20007ffe0ffULL,
0x000000041b417836ULL, 0x000fe40000000000ULL, 0x000000011b0e7824ULL, 0x100fe400078e020cULL,
0x000000081b497836ULL, 0x000fe20000000000ULL, 0x0000000c00357c02ULL, 0x000fe20008000f00ULL,
0x000000101b5b7836ULL, 0x000fe20000000000ULL, 0x0000000711467812ULL, 0x000fe200078ef80eULL,
0x00000001410d7824ULL, 0x140fe200078e020cULL, 0x0000002035447446ULL, 0x000fe20003800044ULL,
0x00000008411a7824ULL, 0x000fe200078e00ffULL, 0x000000034b117819ULL, 0x000fe200000006ffULL,
0x0000000149107824ULL, 0x100fe200078e020cULL, 0x000000444100720cULL, 0x080fe20003f06070ULL,
0x0000000849377824ULL, 0x000fe200078e00ffULL, 0xfffffff81a477812ULL, 0x000fe200078ee20dULL,
0x000000141b5f7836ULL, 0x000fe20000000000ULL, 0x000000441b00720cULL, 0x080fe20003fc6070ULL,
0x000000181b617836ULL, 0x000fe20000000000ULL, 0xfffffff837487812ULL, 0x000fe200078ee210ULL,
0x000000014b0e7824ULL, 0x100fe200078e020cULL, 0x0000000849397c10ULL, 0x000fe2000fffe0ffULL,
0x000000015b427824ULL, 0x140fe200078e020cULL, 0x0000000c610d7210ULL, 0x000fe20007ffe0ffULL,
0x000000085b357824ULL, 0x000fe200078e00ffULL, 0xfffffff8110e7812ULL, 0x000fe200078ee20eULL,
0x0000001c1b637836ULL, 0x000fe20000000000ULL, 0x0000000f47477c11ULL, 0x000fe2000f8e20ffULL,
0x000000081b3b7c36ULL, 0x000fe20008000000ULL, 0xfffffff835427812ULL, 0x000fe200078ee242ULL,
0x0000000841417c36ULL, 0x000fe20008000000ULL, 0x0000000863457c10ULL, 0x000fe2000fffe0ffULL,
0x000000015f437824ULL, 0x000fe200078e020cULL, 0x000000444900720cULL, 0x080fe20003f46070ULL,
0x000000085f107824ULL, 0x000fe200078e00ffULL, 0x000000444b00720cULL, 0x080fe20003f66070ULL,
0x00000008611a7824ULL, 0x000fe200078e00ffULL, 0x000000445b00720cULL, 0x000fe20003f86070ULL,
0x000002003b3a7825ULL, 0x000fe200078e0018ULL, 0xfffffff810437812ULL, 0x000fc400078ee243ULL,
0xfffffff81a0d7812ULL, 0x000fe200078ee20dULL, 0x000000084b377c36ULL, 0x000fe20008000000ULL,
0x000000445f00720cULL, 0x000fe20003fa6070ULL, 0x000000085b357c36ULL, 0x000fe20008000000ULL,
0x0000000f48497c11ULL, 0x000fe2000f8e20ffULL, 0x000000085f1b7c36ULL, 0x000fe20008000000ULL,
0x0000000f43437c11ULL, 0x000fe2000f8e20ffULL, 0x0000000861117c36ULL, 0x000fe20008000000ULL,
0x0000000f0d0d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000020041407825ULL, 0x000fc800078e0018ULL,
0x0000020039387825ULL, 0x000fc800078e0018ULL, 0x0000020037367825ULL, 0x000fc800078e0018ULL,
0x0000020035347825ULL, 0x000fc800078e0018ULL, 0x000002001b1a7825ULL, 0x000fc800078e0018ULL,
0x0000020011107825ULL, 0x000fc800078e0018ULL, 0x0000020045187825ULL, 0x000fe200078e0018ULL,
0x0000000f46457c11ULL, 0x000fc6000f8e20ffULL, 0x00000010123a7825ULL, 0x000fc800078e003aULL,
0x0000001012407825ULL, 0x040fe200078e0040ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a457faeULL, 0x0003e2000f101c4aULL, 0x000000446100720cULL, 0x080fe40003fc6070ULL,
0x00000001634a7824ULL, 0x040fe200078e020cULL, 0x0000000040477faeULL, 0x0005e2000c101c4aULL,
0x0000000863657824ULL, 0x040fe200078e00ffULL, 0x000000446300720cULL, 0x000fe20003f06070ULL,
0x0000001012387825ULL, 0x000fc600078e0038ULL, 0xfffffff8654a7812ULL, 0x000fe200078ee24aULL,
0x0000001012367825ULL, 0x000fe200078e0036ULL, 0x0000000f0e3b7c11ULL, 0x002fe2000f8e20ffULL,
0x0000000038497faeULL, 0x0003e2000d101c4aULL, 0x0000000f4a457c11ULL, 0x000fe2000f8e20ffULL,
0x0000001012347825ULL, 0x000fe200078e0034ULL, 0x0000000f42417c11ULL, 0x004fe2000f8e20ffULL,
0x00000000363b7faeULL, 0x0003e4000d901c4aULL, 0x00000010121a7825ULL, 0x040fe400078e001aULL,
0x0000000034417faeULL, 0x0003e4000e101c4aULL, 0x0000001012107825ULL, 0x000fc400078e0010ULL,
0x000000001a437faeULL, 0x0003e4000e901c4aULL, 0x0000001012187825ULL, 0x000fe400078e0018ULL,
0x00000000100d7faeULL, 0x0003e8000f101c4aULL, 0x0000000018457faeULL, 0x0003e2000c101c4aULL,
0x0000000400247947ULL, 0x000fea0003800000ULL, 0x000000080c397811ULL, 0x040fe400078fe8ffULL,
0x000000100c377811ULL, 0x040fe400078fe8ffULL, 0x000000040c357811ULL, 0x040fe200078fe8ffULL,
0x00000008391b7824ULL, 0x000fe200078e00ffULL, 0x0000000c0c0e7211ULL, 0x040fe200078fe8ffULL,
0x0000000137427824ULL, 0x100fe200078e020cULL, 0x0000000c391a7210ULL, 0x000fe20007ffe0ffULL,
0x00000001350d7824ULL, 0x000fe200078e020cULL, 0x00000003373b7819ULL, 0x000fe200000006ffULL,
0x0000000835447824ULL, 0x000fe200078e00ffULL, 0x0000000711107812ULL, 0x000fe200078ef80eULL,
0x0000000839397c36ULL, 0x000fe20008000000ULL, 0xfffffff81b467812ULL, 0x000fe200078ee21aULL,
0x0000000837377c36ULL, 0x000fe20008000000ULL, 0x000000180c117811ULL, 0x040fe200078fe8ffULL,
0x0000020039387825ULL, 0x000fe200078e0018ULL, 0x000000140c1b7811ULL, 0x000fc400078fe8ffULL,
0xfffffff83b427812ULL, 0x000fe200078ee242ULL, 0x0000000811347824ULL, 0x000fe200078e00ffULL,
0x0000000c0c417811ULL, 0x040fe200078fe8ffULL, 0x000000011b0e7824ULL, 0x140fe200078e020cULL,
0x000000080c3b7c11ULL, 0x040fe2000f8fe8ffULL, 0x000000081b457824ULL, 0x000fe200078e00ffULL,
0xfffffff844447812ULL, 0x000fe200078ee20dULL, 0x00000001110d7824ULL, 0x100fe200078e020cULL,
0x0000000835357c10ULL, 0x000fe2000fffe0ffULL, 0x0000000141437824ULL, 0x040fe200078e020cULL,
0x0000001c0c477811ULL, 0x000fe200078fe8ffULL, 0x00000008411a7824ULL, 0x000fe200078e00ffULL,
0xfffffff8340d7812ULL, 0x000fe200078ee20dULL, 0x000002003b3a7825ULL, 0x000fe200078e0018ULL,
0x0000000811117c10ULL, 0x000fc4000fffe0ffULL, 0xfffffff8450e7812ULL, 0x000fe200078ee20eULL,
0x0000000841417c36ULL, 0x000fe20008000000ULL, 0xfffffff81a437812ULL, 0x000fe200078ee243ULL,
0x000000081b1b7c36ULL, 0x000fe20008000000ULL, 0x0000000f0d0d7c11ULL, 0x000fe2000f8e20ffULL,
0x0000020035347825ULL, 0x000fe200078e0018ULL, 0x0000000f43437c11ULL, 0x000fc6000f8e20ffULL,
0x0000000847457c36ULL, 0x000fe40008000000ULL, 0x0000000147487824ULL, 0x040fe400078e020cULL,
0x0000000847497824ULL, 0x000fe200078e00ffULL, 0x0000000f10477c11ULL, 0x000fe2000f8e20ffULL,
0x0000020041407825ULL, 0x000fc600078e0018ULL, 0xfffffff849487812ULL, 0x000fe200078ee248ULL,
0x00000010123a7825ULL, 0x000fe200078e003aULL, 0x0000000f46497c11ULL, 0x000fe4000f8e20ffULL,
0x0000000f484b7c11ULL, 0x000fe2000f8e20ffULL, 0x0000020037367825ULL, 0x100fe200078e0018ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a477faeULL, 0x0003e6000b901c4aULL,
0x000002001b1a7825ULL, 0x000fc800078e0018ULL, 0x0000020011107825ULL, 0x000fc800078e0018ULL,
0x0000020045187825ULL, 0x000fe200078e0018ULL, 0x0000000f44457c11ULL, 0x000fe4000f8e20ffULL,
0x0000000f423b7c11ULL, 0x002fe2000f8e20ffULL, 0x0000001012347825ULL, 0x000fe200078e0034ULL,
0x0000000f0e477c11ULL, 0x000fc6000f8e20ffULL, 0x0000001012387825ULL, 0x040fe200078e0038ULL,
0x0000000034457faeULL, 0x0003e6000b901c4aULL, 0x0000001012407825ULL, 0x040fe200078e0040ULL,
0x0000000038497faeULL, 0x0003e6000b901c4aULL, 0x0000001012367825ULL, 0x040fe200078e0036ULL,
0x0000000040437faeULL, 0x0003e6000b901c4aULL, 0x00000010121a7825ULL, 0x040fe200078e001aULL,
0x00000000363b7faeULL, 0x0003e6000b901c4aULL, 0x0000001012107825ULL, 0x040fe200078e0010ULL,
0x000000001a477faeULL, 0x0003e6000b901c4aULL, 0x0000001012187825ULL, 0x000fe200078e0018ULL,
0x00000000100d7faeULL, 0x0003e8000b901c4aULL, 0x00000000184b7faeULL, 0x0003e4000b901c4aULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x01c628135c1879a7ULL, 0x0022a40008500006ULL,
0x0000000000107805ULL, 0x000fce0000015200ULL, 0x01c628195c0075a7ULL, 0x004ea40008000146ULL,
0x00000000005c0947ULL, 0x004fea0003800000ULL, 0x000000ffff1a7224ULL, 0x000fce00078e00ffULL,
0x000000101a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x002fcc0000015200ULL, 0x00000012100e7210ULL, 0x000fc80007f1e1ffULL,
0x0000001311127210ULL, 0x000fe400007fe5ffULL, 0x003d09000e00780cULL, 0x000fc80003f06070ULL,
0x000000ff1200720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400e00780cULL, 0x000fc80003f06070ULL, 0x000000ff1200720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff0d7819ULL, 0x000fc80000011412ULL,
0x0000000e0d0d7211ULL, 0x000fca00078110ffULL, 0x000000ffff0e7224ULL, 0x000fca00000e0612ULL,
0x000000020d0d7819ULL, 0x000fc8000000120eULL, 0x0000000d0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011a1a7836ULL, 0x000fce0000000000ULL,
0x01c628195c0075a7ULL, 0x000ea40008000146ULL, 0xfffffffc00a88947ULL, 0x004fea000383ffffULL,
0x01c080000a107984ULL, 0x000ea20000000800ULL, 0x000000ffff0d7224ULL, 0x000fc600078e0009ULL,
0x01c280000a0e7984ULL, 0x0006e20000000800ULL, 0x000000091000720bULL, 0x004fda0003f1d000ULL,
0x0000000000127806ULL, 0x000fe400000e0100ULL, 0x000000000000781cULL, 0x000fe40003f0e170ULL,
0x0000ffff12ff7812ULL, 0x000fda000784c0ffULL, 0x0000000000f0a947ULL, 0x00afea0003800000ULL,
0x000000010e00788cULL, 0x000fe2000bf05270ULL, 0x000000091000720bULL, 0x000fca0003f14000ULL,
0x000000000000781cULL, 0x000fd00003f4f008ULL, 0x0000000000137806ULL, 0x000fc800000e0100ULL,
0x0000991013117816ULL, 0x000fe400000000ffULL, 0x00000009100da209ULL, 0x000fe40007810000ULL,
0x000000ff1100720cULL, 0x000fc60003f05270ULL, 0x01c4800d0a00a388ULL, 0x0003f40000000800ULL,
0x0000000000b48947ULL, 0x002fea0003800000ULL, 0x0000000910187209ULL, 0x000fe40007810000ULL,
0x000000ff13ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0013ff7812ULL, 0x000fe2000784c0ffULL,
0x00000009180d7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b0d0d7820ULL, 0x000fc80000410000ULL,
0x0000000d00187308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff0d7819ULL, 0x002fcc000001160cULL, 0x00001f0d180d7589ULL, 0x004e6400000e0000ULL,
0x0000000d28287220ULL, 0x082fe20000410000ULL, 0x0000000d29297220ULL, 0x080fe20000410000ULL,
0x0000000d2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000d2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000d14147220ULL, 0x080fe20000410000ULL, 0x0000000d15157220ULL, 0x080fe20000410000ULL,
0x0000000d1c1c7220ULL, 0x080fe20000410000ULL, 0x0000000d1d1d7220ULL, 0x080fe20000410000ULL,
0x0000000d20207220ULL, 0x080fe20000410000ULL, 0x0000000d21217220ULL, 0x080fe20000410000ULL,
0x0000000d24247220ULL, 0x080fe20000410000ULL, 0x0000000d25257220ULL, 0x080fe20000410000ULL,
0x0000000d3c3c7220ULL, 0x080fe20000410000ULL, 0x0000000d3d3d7220ULL, 0x080fe20000410000ULL,
0x0000000d30307220ULL, 0x080fe20000410000ULL, 0x0000000d31317220ULL, 0x000fce0000410000ULL,
0x000000180b0b7220ULL, 0x004fe20000410000ULL, 0x000000000048a947ULL, 0x000fec0003800000ULL,
0x000000080c0d7811ULL, 0x002fcc00078ff0ffULL, 0x00001f0d180d7589ULL, 0x000e6400000e0000ULL,
0x0000000d2a2a7220ULL, 0x082fe20000410000ULL, 0x0000000d2b2b7220ULL, 0x080fe20000410000ULL,
0x0000000d2e2e7220ULL, 0x080fe20000410000ULL, 0x0000000d2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000d16167220ULL, 0x080fe20000410000ULL, 0x0000000d17177220ULL, 0x080fe20000410000ULL,
0x0000000d1e1e7220ULL, 0x080fe20000410000ULL, 0x0000000d1f1f7220ULL, 0x080fe20000410000ULL,
0x0000000d22227220ULL, 0x080fe20000410000ULL, 0x0000000d23237220ULL, 0x080fe20000410000ULL,
0x0000000d26267220ULL, 0x080fe20000410000ULL, 0x0000000d27277220ULL, 0x080fe20000410000ULL,
0x0000000d3e3e7220ULL, 0x080fe20000410000ULL, 0x0000000d3f3f7220ULL, 0x080fe20000410000ULL,
0x0000000d32327220ULL, 0x080fe20000410000ULL, 0x0000000d33337220ULL, 0x000fce0000410000ULL,
0x0000ffff13ff7812ULL, 0x000fe40007800812ULL, 0x00000009100d7209ULL, 0x002fd60007810000ULL,
0x8000000d10100221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b10100820ULL, 0x000fc80000410000ULL,
0x0000001000080308ULL, 0x000e640000000800ULL, 0x000000080e0e0220ULL, 0x002fce0000410000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000000000188947ULL, 0x000fea0003800000ULL,
0x00000002ff067819ULL, 0x000fe4000001160cULL, 0x00000008ff05723eULL, 0x000fc600000010ffULL,
0x0000000806107836ULL, 0x000fe20000000000ULL, 0x0000541005097816ULL, 0x000fca0000000005ULL,
0x00001f0609067589ULL, 0x0002a800000e0000ULL, 0x00001f1009057589ULL, 0x0002e400000e0000ULL,
0x012800005210783bULL, 0x0022e20000000200ULL, 0x0000000000108947ULL, 0x000fea0003800000ULL,
0x0000000610107232ULL, 0x08cfe40000200000ULL, 0x0000000612127232ULL, 0x000fe40000200000ULL,
0x0000000511117232ULL, 0x080fe40000200000ULL, 0x0000000513137232ULL, 0x000fce0000200000ULL,
0x000000005140783bULL, 0x000f280000004200ULL, 0x000000005438783bULL, 0x000f680000004200ULL,
0x000000005634783bULL, 0x000f680000004200ULL, 0x000000005718783bULL, 0x000f620000004200ULL,
0x000000401028723cULL, 0x018fec0000041828ULL, 0x00000042102c723cULL, 0x000fec000004182cULL,
0x000000381014723cULL, 0x022fec0000041814ULL, 0x0000003a101c723cULL, 0x000fec000004181cULL,
0x000000341020723cULL, 0x000fec0000041820ULL, 0x000000361024723cULL, 0x000fec0000041824ULL,
0x00000018103c723cULL, 0x004fec000004183cULL, 0x0000001a1030723cULL, 0x000fe20000041830ULL,
0x012800005910783bULL, 0x0002a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000108947ULL, 0x000fde0003800000ULL, 0x0000000610107232ULL, 0x084fe40000200000ULL,
0x0000000612127232ULL, 0x000fe40000200000ULL, 0x0000000511117232ULL, 0x080fe40000200000ULL,
0x0000000513137232ULL, 0x000fce0000200000ULL, 0x000000005840783bULL, 0x000ee20000004200ULL,
0x0000008009107890ULL, 0x000fe2000fffe03fULL, 0x0000000b0e0b7221ULL, 0x000fe20000010000ULL,
0x00008e0000087ab9ULL, 0x000fe20000000800ULL, 0x000000005538783bULL, 0x000f220000004200ULL,
0x00000008071372a4ULL, 0x000fc6000f8e0210ULL, 0x000000005334783bULL, 0x000f680000004200ULL,
0x000000005018783bULL, 0x000f220000004200ULL, 0x000000401028723cULL, 0x00cfec0000041828ULL,
0x00000042102c723cULL, 0x000fec000004182cULL, 0x000000381014723cULL, 0x010fec0000041814ULL,
0x0000003a101c723cULL, 0x000fec000004181cULL, 0x000000341020723cULL, 0x022fec0000041820ULL,
0x000000361024723cULL, 0x000fec0000041824ULL, 0x00000018103c723cULL, 0x000fec000004183cULL,
0x0000001a1030723cULL, 0x000fe20000041830ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000400749947ULL, 0x000fde0003800000ULL,
0x000000101100728cULL, 0x000fe2000bf01070ULL, 0x00000003ff117819ULL, 0x000fe2000001160cULL,
0x80000010ff347e24ULL, 0x000fe2000f8e02ffULL, 0x00008a0000167ab9ULL, 0x000fe20000000a00ULL,
0x00000010110c7287ULL, 0x000fe2000c000000ULL, 0x0000000411197810ULL, 0x000fe20007ffe0ffULL,
0x0000000c11397836ULL, 0x000fe20000000000ULL, 0x0000001811497810ULL, 0x000fe20007ffe0ffULL,
0x0000001011457836ULL, 0x000fe40000000000ULL, 0x0000000cff137e24ULL, 0x000fc4000f8e00ffULL,
0x0000000119097824ULL, 0x140fe400078e020cULL, 0x0000000819367824ULL, 0x000fe200078e00ffULL,
0x0000002013347446ULL, 0x000fe20003800034ULL, 0x00000001390e7824ULL, 0x140fe200078e020cULL,
0x0000000811137810ULL, 0x000fe20007ffe0ffULL, 0x00000008391b7824ULL, 0x000fe200078e00ffULL,
0xfffffff836367812ULL, 0x000fe200078ee209ULL, 0x0000000145107824ULL, 0x100fe200078e020cULL,
0x0000000313127819ULL, 0x040fe200000006ffULL, 0x0000000113097824ULL, 0x100fe200078e020cULL,
0xfffffff81b3a7812ULL, 0x000fe200078ee20eULL, 0x0000000845357824ULL, 0x000fe200078e00ffULL,
0x000000341100720cULL, 0x0c0fe20003f46070ULL, 0x0000001411477836ULL, 0x000fe20000000000ULL,
0xfffffff812377812ULL, 0x000fe200078ee209ULL, 0x0000000111127824ULL, 0x000fe200078e020cULL,
0xfffffff835407812ULL, 0x000fe200078ee210ULL, 0x00000013111b7c36ULL, 0x000fe20008000000ULL,
0x000000341900720cULL, 0x080fe20003f66070ULL, 0x0000001c114b7836ULL, 0x000fe20000000000ULL,
0x000000341300720cULL, 0x000fe20003f86070ULL, 0x00000016ff107e24ULL, 0x000fe2000f8e00ffULL,
0x0ffffff80c097812ULL, 0x000fe200078ec0ffULL, 0x00000017ff117e24ULL, 0x000fe2000f8e00ffULL,
0x0000001313137c10ULL, 0x000fe2000fffe0ffULL, 0x0000001319197c36ULL, 0x000fe20008000000ULL,
0x0000000c47387210ULL, 0x000fe20007ffe0ffULL, 0x00000008473b7824ULL, 0x000fe200078e00ffULL,
0x0000000709357812ULL, 0x000fe200078ef812ULL, 0x000002001b1a7825ULL, 0x000fe200078e0010ULL,
0x0000001436417c11ULL, 0x000fc4000f8e20ffULL, 0xfffffff83b387812ULL, 0x000fe200078ee238ULL,
0x000000125d0e7c36ULL, 0x000fe20008000000ULL, 0x00000014353b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000020019187825ULL, 0x100fe200078e0010ULL, 0x0000001437437c11ULL, 0x000fe4000f8e20ffULL,
0x0000001339377c10ULL, 0x000fe2000fffe0ffULL, 0x0000020013127825ULL, 0x000fe200078e0010ULL,
0x000000344900720cULL, 0x080fe40003fa6070ULL, 0x000000344b00720cULL, 0x000fe20003fc6070ULL,
0x000000100e1a7825ULL, 0x000fc800078e001aULL, 0x000000100e187825ULL, 0x040fe200078e0018ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a3b7faeULL, 0x0003e2000d101c4aULL,
0x000000343900720cULL, 0x080fe40003f46070ULL, 0x000000100e127825ULL, 0x000fe200078e0012ULL,
0x0000000018417faeULL, 0x0005e2000d901c4aULL, 0x000000344500720cULL, 0x080fe40003f66070ULL,
0x0000001345357c36ULL, 0x000fe20008000000ULL, 0x0000000012437faeULL, 0x0007e2000e101c4aULL,
0x0000001347397c36ULL, 0x000fe20008000000ULL, 0x000000344700720cULL, 0x000fe20003f86070ULL,
0x0000000149427824ULL, 0x000fc400078e020cULL, 0x00000013493b7c36ULL, 0x002fe40008000000ULL,
0x00000008495b7824ULL, 0x000fe400078e00ffULL, 0x000000134b417c36ULL, 0x004fe40008000000ULL,
0x0000020037367825ULL, 0x000fe200078e0010ULL, 0xfffffff85b427812ULL, 0x000fc600078ee242ULL,
0x000000014b447824ULL, 0x040fe200078e020cULL, 0x0000001442437c11ULL, 0x008fe2000f8e20ffULL,
0x000000084b5f7824ULL, 0x000fe400078e00ffULL, 0x0000020035347825ULL, 0x000fc600078e0010ULL,
0xfffffff85f447812ULL, 0x000fe200078ee244ULL, 0x00000200391a7825ULL, 0x100fe200078e0010ULL,
0x000000143a397c11ULL, 0x000fe4000f8e20ffULL, 0x0000001444457c11ULL, 0x000fe2000f8e20ffULL,
0x000002003b187825ULL, 0x000fe200078e0010ULL, 0x00000014403b7c11ULL, 0x000fc6000f8e20ffULL,
0x0000020041127825ULL, 0x000fe200078e0010ULL, 0x0000001438417c11ULL, 0x000fc6000f8e20ffULL,
0x000000100e367825ULL, 0x000fc800078e0036ULL, 0x000000100e347825ULL, 0x040fe200078e0034ULL,
0x0000000036397faeULL, 0x0003e6000d101c4aULL, 0x000000100e1a7825ULL, 0x040fe200078e001aULL,
0x00000000343b7faeULL, 0x0003e6000d901c4aULL, 0x000000100e187825ULL, 0x040fe200078e0018ULL,
0x000000001a417faeULL, 0x0003e6000e101c4aULL, 0x000000100e127825ULL, 0x000fe200078e0012ULL,
0x0000000018437faeULL, 0x0003e8000e901c4aULL, 0x0000000012457faeULL, 0x0003e2000f101c4aULL,
0x0000000400307947ULL, 0x000fea0003800000ULL, 0x00008a00ff107b82ULL, 0x000e620000000a00ULL,
0x000000040c137811ULL, 0x040fe400078fe8ffULL, 0x000000080c197811ULL, 0x040fe400078fe8ffULL,
0x0000000c13097210ULL, 0x000fe20007ffe0ffULL, 0x00000008130e7824ULL, 0x000fe200078e00ffULL,
0x000000100c417811ULL, 0x040fe200078fe8ffULL, 0x0000000819367824ULL, 0x040fe200078e00ffULL,
0x0000000c0c377811ULL, 0x040fe200078fe8ffULL, 0x0000001313137c36ULL, 0x000fe20008000000ULL,
0xfffffff80e357812ULL, 0x000fe200078ee209ULL, 0x0000000119097824ULL, 0x100fe200078e020cULL,
0x000000140c497811ULL, 0x040fe200078fe8ffULL, 0x0000000141127824ULL, 0x100fe200078e020cULL,
0x00000003371b7819ULL, 0x000fe200000006ffULL, 0x0000000841397824ULL, 0x000fe200078e00ffULL,
0xfffffff836367812ULL, 0x000fe200078ee209ULL, 0x00000001370e7824ULL, 0x100fe200078e020cULL,
0x0ffffff80c097812ULL, 0x040fe200078ec0ffULL, 0x0000000149187824ULL, 0x040fe200078e020cULL,
0xfffffff839427812ULL, 0x000fe200078ee212ULL, 0x00000008493b7824ULL, 0x000fe200078e00ffULL,
0x0000000c0c127211ULL, 0x000fe200078fe8ffULL, 0x0000001319197c36ULL, 0x000fe20008000000ULL,
0xfffffff81b407812ULL, 0x000fc400078ee20eULL, 0x000000130c1b7c11ULL, 0x040fe4000f8fe8ffULL,
0x0000000709347812ULL, 0x000fe200078ef812ULL, 0x0000020013127825ULL, 0x102fe200078e0010ULL,
0xfffffff83b447812ULL, 0x000fe400078ee218ULL, 0x000000125d0e7c10ULL, 0x000fe2000fffe0ffULL,
0x0000020019187825ULL, 0x100fe200078e0010ULL, 0x000000180c4b7811ULL, 0x040fe400078fe8ffULL,
0x0000001c0c5b7811ULL, 0x000fe200078fe8ffULL, 0x000002001b1a7825ULL, 0x000fe200078e0010ULL,
0x0000001435457c11ULL, 0x000fc4000f8e20ffULL, 0x0000001434437c11ULL, 0x000fe2000f8e20ffULL,
0x000000100e387825ULL, 0x000fe200078e0012ULL, 0x000000134b357c10ULL, 0x000fe4000fffe0ffULL,
0x0000001436477c11ULL, 0x000fe2000f8e20ffULL, 0x000000100e3a7825ULL, 0x000fe200078e0018ULL,
0x0000000c5b487210ULL, 0x000fc60007ffe0ffULL, 0x0000001337137c36ULL, 0x000fe40008000000ULL,
0x0000001341197c36ULL, 0x000fe40008000000ULL, 0x000000100e1a7825ULL, 0x000fc800078e001aULL,
0x0000001349377c36ULL, 0x000fe20008000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a437faeULL, 0x0003e2000b901c4aULL, 0x000000014b467824ULL, 0x040fe400078e020cULL,
0x000000084b5f7824ULL, 0x000fe200078e00ffULL, 0x0000000038457faeULL, 0x0005e2000b901c4aULL,
0x000000135b417c36ULL, 0x000fe40008000000ULL, 0x0000020013127825ULL, 0x100fe200078e0010ULL,
0xfffffff85f467812ULL, 0x000fe200078ee246ULL, 0x000000003a477faeULL, 0x0007e4000b901c4aULL,
0x000000085b617824ULL, 0x000fe200078e00ffULL, 0x0000001446437c11ULL, 0x002fe2000f8e20ffULL,
0x0000020019187825ULL, 0x000fc600078e0010ULL, 0xfffffff861487812ULL, 0x000fe200078ee248ULL,
0x0000020037367825ULL, 0x100fe200078e0010ULL, 0x0000001440397c11ULL, 0x004fe4000f8e20ffULL,
0x0000001448457c11ULL, 0x000fe2000f8e20ffULL, 0x0000020035347825ULL, 0x000fe200078e0010ULL,
0x00000014423b7c11ULL, 0x008fc6000f8e20ffULL, 0x00000200411a7825ULL, 0x000fe200078e0010ULL,
0x0000001444417c11ULL, 0x000fc6000f8e20ffULL, 0x000000100e127825ULL, 0x000fc800078e0012ULL,
0x000000100e187825ULL, 0x040fe200078e0018ULL, 0x0000000012397faeULL, 0x0003e6000b901c4aULL,
0x000000100e367825ULL, 0x040fe200078e0036ULL, 0x00000000183b7faeULL, 0x0003e6000b901c4aULL,
0x000000100e347825ULL, 0x040fe200078e0034ULL, 0x0000000036417faeULL, 0x0003e6000b901c4aULL,
0x000000100e1a7825ULL, 0x000fe200078e001aULL, 0x0000000034437faeULL, 0x0003e8000b901c4aULL,
0x000000001a457faeULL, 0x0003e4000b901c4aULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000000000188947ULL, 0x000fea0003800000ULL,
0x00000002ff137819ULL, 0x002fe4000001160cULL, 0x00000008ff05723eULL, 0x000fc600000010ffULL,
0x0000000813197836ULL, 0x000fe20000000000ULL, 0x0000541005127816ULL, 0x000fca0000000005ULL,
0x00001f1312067589ULL, 0x0002a800000e0000ULL, 0x00001f1912057589ULL, 0x0002e400000e0000ULL,
0x012800004f18783bULL, 0x0022e20000000200ULL, 0x0000000000108947ULL, 0x000fea0003800000ULL,
0x0000000618187232ULL, 0x08cfe40000200000ULL, 0x000000061a1a7232ULL, 0x000fe40000200000ULL,
0x0000000519197232ULL, 0x080fe40000200000ULL, 0x000000051b1b7232ULL, 0x000fce0000200000ULL,
0x000000004e44783bULL, 0x000f280000004200ULL, 0x000000004d40783bULL, 0x000f680000004200ULL,
0x000000004c38783bULL, 0x000f680000004200ULL, 0x000000000f34783bULL, 0x000f620000004200ULL,
0x000000441828723cULL, 0x018fec0000041828ULL, 0x00000046182c723cULL, 0x000fec000004182cULL,
0x000000401814723cULL, 0x022fec0000041814ULL, 0x00000042181c723cULL, 0x000fec000004181cULL,
0x000000381820723cULL, 0x000fec0000041820ULL, 0x0000003a1824723cULL, 0x000fec0000041824ULL,
0x00000034183c723cULL, 0x004fec000004183cULL, 0x000000361830723cULL, 0x000fe20000041830ULL,
0x012800000718783bULL, 0x0002a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000108947ULL, 0x000fde0003800000ULL, 0x0000000618187232ULL, 0x084fe40000200000ULL,
0x000000061a1a7232ULL, 0x000fe40000200000ULL, 0x0000000519197232ULL, 0x080fe40000200000ULL,
0x000000051b1b7232ULL, 0x000fce0000200000ULL, 0x000000000034783bULL, 0x000ee20000004200ULL,
0x000000111000728cULL, 0x000fc6000bf06070ULL, 0x000000000444783bULL, 0x000f260000004200ULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x000000000340783bULL, 0x000f680000004200ULL,
0x000000000238783bULL, 0x000f620000004200ULL, 0x00000034183c723cULL, 0x00cfec000004183cULL,
0x000000441828723cULL, 0x010fe20000041828ULL, 0x00000001ff357424ULL, 0x000fc800078e00ffULL,
0x01c69035ffff79a7ULL, 0x0005e20008500006ULL, 0x00000046182c723cULL, 0x000fec000004182cULL,
0x000000401814723cULL, 0x022fec0000041814ULL, 0x00000042181c723cULL, 0x000fec000004181cULL,
0x000000381820723cULL, 0x000fec0000041820ULL, 0x0000003a1824723cULL, 0x000fec0000041824ULL,
0x000000361830723cULL, 0x000fe20000041830ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000004000a40947ULL, 0x004fde0003800000ULL, 0x000000a009107890ULL, 0x000fe2000fffe03fULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x00000008070872a4ULL, 0x000fe2000f8e0210ULL,
0x0000000400609947ULL, 0x000ff60003800000ULL, 0x000000101100728cULL, 0x000fe2000bf01070ULL,
0x00000003ff137819ULL, 0x100fe2000001160cULL, 0x80000010ff447e24ULL, 0x000fe4000f8e02ffULL,
0x00000010110c7287ULL, 0x000fe2000c000000ULL, 0x0000000413417810ULL, 0x000fe20007ffe0ffULL,
0x0000000813497836ULL, 0x000fe20000000000ULL, 0x00000014135f7810ULL, 0x000fe20007ffe0ffULL,
0x00000010135b7836ULL, 0x000fe20000000000ULL, 0x0000000341477819ULL, 0x000fe200000006ffULL,
0x0000000cff1b7e24ULL, 0x000fe2000f8e00ffULL, 0x00000008133b7c10ULL, 0x000fe2000fffe0ffULL,
0x0000000149197824ULL, 0x000fc400078e020cULL, 0x0000000849487824ULL, 0x000fe200078e00ffULL,
0x000000201b447446ULL, 0x000fe20003800044ULL, 0x0000000c134b7836ULL, 0x000fe20000000000ULL,
0x000000035b1b7819ULL, 0x000fe200000006ffULL, 0x0000000113127824ULL, 0x100fe200078e020cULL,
0xfffffff848487812ULL, 0x000fe200078ee219ULL, 0x0000000141187824ULL, 0x140fe200078e020cULL,
0x000000444100720cULL, 0x080fe20003f06070ULL, 0x000000015b427824ULL, 0x100fe200078e020cULL,
0x0000000709467812ULL, 0x000fe200078ef812ULL, 0x0000001813617836ULL, 0x000fe20000000000ULL,
0xfffffff847477812ULL, 0x000fe200078ee218ULL, 0x000000014b347824ULL, 0x140fe200078e020cULL,
0xfffffff81b427812ULL, 0x000fe200078ee242ULL, 0x000000084b197824ULL, 0x000fe200078e00ffULL,
0x000000441300720cULL, 0x080fe20003fc6070ULL, 0x0000001c13637836ULL, 0x000fe20000000000ULL,
0x000000085b1b7c10ULL, 0x000fe2000fffe0ffULL, 0x0000000841417c36ULL, 0x000fe20008000000ULL,
0xfffffff819347812ULL, 0x000fe200078ee234ULL, 0x000000015f437824ULL, 0x100fe200078e020cULL,
0x0000000f47477c11ULL, 0x000fe2000f8e20ffULL, 0x000000085f127824ULL, 0x000fe200078e00ffULL,
0x000000444900720cULL, 0x080fe20003f46070ULL, 0x0000000161097824ULL, 0x000fe200078e020cULL,
0x000000444b00720cULL, 0x080fe20003f66070ULL, 0x0000000861187824ULL, 0x000fe200078e00ffULL,
0xfffffff812437812ULL, 0x000fe200078ee243ULL, 0x000002003b3a7825ULL, 0x000fe200078e0010ULL,
0x000000445b00720cULL, 0x000fc40003f86070ULL, 0xfffffff818097812ULL, 0x000fe200078ee209ULL,
0x0000000849397c36ULL, 0x000fe20008000000ULL, 0x000000445f00720cULL, 0x000fe20003fa6070ULL,
0x000000084b377c36ULL, 0x000fe20008000000ULL, 0x0000000363657819ULL, 0x000fe200000006ffULL,
0x000000085f197c36ULL, 0x000fe20008000000ULL, 0x0000000f48497c11ULL, 0x000fe2000f8e20ffULL,
0x0000000861137c36ULL, 0x000fe20008000000ULL, 0x0000000f43437c11ULL, 0x000fe2000f8e20ffULL,
0x0000000863457c36ULL, 0x000fe20008000000ULL, 0x0000000f09097c11ULL, 0x000fe2000f8e20ffULL,
0x0000020041407825ULL, 0x000fc800078e0010ULL, 0x0000020039387825ULL, 0x000fc800078e0010ULL,
0x0000020037367825ULL, 0x000fc800078e0010ULL, 0x000002001b1a7825ULL, 0x000fc800078e0010ULL,
0x0000020019187825ULL, 0x000fc800078e0010ULL, 0x0000020013127825ULL, 0x000fc800078e0010ULL,
0x0000020045107825ULL, 0x000fe200078e0010ULL, 0x0000000f46457c11ULL, 0x000fc6000f8e20ffULL,
0x000000100e3a7825ULL, 0x000fc800078e003aULL, 0x000000100e407825ULL, 0x040fe200078e0040ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a457faeULL, 0x0003e2000f101c4aULL,
0x000000446100720cULL, 0x080fe40003fc6070ULL, 0x00000001634a7824ULL, 0x040fe200078e020cULL,
0x0000000040477faeULL, 0x0005e2000c101c4aULL, 0x000000446300720cULL, 0x000fe20003f06070ULL,
0x000000100e387825ULL, 0x040fe400078e0038ULL, 0xfffffff8654a7812ULL, 0x000fe400078ee24aULL,
0x000000100e367825ULL, 0x000fe200078e0036ULL, 0x0000000038497faeULL, 0x0007e2000d101c4aULL,
0x0000000f343b7c11ULL, 0x002fc4000f8e20ffULL, 0x000000100e1a7825ULL, 0x000fe200078e001aULL,
0x0000000f4a457c11ULL, 0x000fe4000f8e20ffULL, 0x0000000f42417c11ULL, 0x004fe2000f8e20ffULL,
0x000000100e187825ULL, 0x040fe200078e0018ULL, 0x00000000363b7faeULL, 0x0007e6000d901c4aULL,
0x000000100e127825ULL, 0x040fe200078e0012ULL, 0x000000001a417faeULL, 0x0007e6000e101c4aULL,
0x000000100e107825ULL, 0x000fe200078e0010ULL, 0x0000000018437faeULL, 0x0007e8000e901c4aULL,
0x0000000012097faeULL, 0x0007e8000f101c4aULL, 0x0000000010457faeULL, 0x0007e2000c101c4aULL,
0x0000000400247947ULL, 0x000fea0003800000ULL, 0x000000040c1b7811ULL, 0x040fe400078fe8ffULL,
0x000000080c397811ULL, 0x040fe400078fe8ffULL, 0x000000100c377811ULL, 0x040fe200078fe8ffULL,
0x000000011b137824ULL, 0x140fe200078e020cULL, 0x0000000c0c127211ULL, 0x040fe200078fe8ffULL,
0x000000081b447824ULL, 0x000fe200078e00ffULL, 0x0000000c0c417811ULL, 0x040fe200078fe8ffULL,
0x0000000139187824ULL, 0x140fe200078e020cULL, 0x0000000709127812ULL, 0x000fe200078ef812ULL,
0x0000000839197824ULL, 0x000fe200078e00ffULL, 0xfffffff844447812ULL, 0x000fe200078ee213ULL,
0x0000000137427824ULL, 0x140fe200078e020cULL, 0x000000180c137811ULL, 0x040fe200078fe8ffULL,
0x00000008373b7824ULL, 0x000fe200078e00ffULL, 0xfffffff819467812ULL, 0x000fe200078ee218ULL,
0x0000000841187824ULL, 0x000fe200078e00ffULL, 0x000000140c197811ULL, 0x040fe200078fe8ffULL,
0x0000000113097824ULL, 0x140fe200078e020cULL, 0xfffffff83b427812ULL, 0x000fe200078ee242ULL,
0x00000008131a7824ULL, 0x000fe200078e00ffULL, 0x000000080c3b7c11ULL, 0x040fe2000f8fe8ffULL,
0x0000000119347824ULL, 0x040fe200078e020cULL, 0x0000000c41437210ULL, 0x000fe20007ffe0ffULL,
0x000000081b1b7c36ULL, 0x000fe20008000000ULL, 0x0000000319457819ULL, 0x000fe200000006ffULL,
0x0000000839397c36ULL, 0x000fe20008000000ULL, 0x0000001c0c477811ULL, 0x000fe200078fe8ffULL,
0x000002003b3a7825ULL, 0x000fe200078e0010ULL, 0x0000000841417c10ULL, 0x000fc4000fffe0ffULL,
0xfffffff81a097812ULL, 0x000fe200078ee209ULL, 0x0000000837377c36ULL, 0x000fe20008000000ULL,
0xfffffff845347812ULL, 0x000fe200078ee234ULL, 0x0000000819197c36ULL, 0x000fe20008000000ULL,
0x0000000c47487210ULL, 0x000fe20007ffe0ffULL, 0x0000000813137c36ULL, 0x000fe20008000000ULL,
0xfffffff818437812ULL, 0x000fe200078ee243ULL, 0x000002001b1a7825ULL, 0x000fe200078e0010ULL,
0x0000000f09097c11ULL, 0x000fe4000f8e20ffULL, 0x0000000f43437c11ULL, 0x000fe2000f8e20ffULL,
0x0000000847457c36ULL, 0x000fc40008000000ULL, 0x0000000847497824ULL, 0x000fe200078e00ffULL,
0x0000000f12477c11ULL, 0x000fe2000f8e20ffULL, 0x0000020039387825ULL, 0x000fc600078e0010ULL,
0xfffffff849487812ULL, 0x000fe200078ee248ULL, 0x0000020041407825ULL, 0x000fe200078e0010ULL,
0x0000000f46497c11ULL, 0x000fe4000f8e20ffULL, 0x0000000f484b7c11ULL, 0x000fe2000f8e20ffULL,
0x000000100e3a7825ULL, 0x000fc800078e003aULL, 0x0000020037367825ULL, 0x100fe200078e0010ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a477faeULL, 0x0003e6000b901c4aULL,
0x0000020019187825ULL, 0x000fc800078e0010ULL, 0x0000020013127825ULL, 0x000fc800078e0010ULL,
0x0000020045107825ULL, 0x000fe200078e0010ULL, 0x0000000f44457c11ULL, 0x000fe4000f8e20ffULL,
0x0000000f423b7c11ULL, 0x002fe2000f8e20ffULL, 0x000000100e1a7825ULL, 0x000fe200078e001aULL,
0x0000000f34477c11ULL, 0x000fc6000f8e20ffULL, 0x000000100e387825ULL, 0x040fe200078e0038ULL,
0x000000001a457faeULL, 0x0003e6000b901c4aULL, 0x000000100e407825ULL, 0x040fe200078e0040ULL,
0x0000000038497faeULL, 0x0003e6000b901c4aULL, 0x000000100e367825ULL, 0x040fe200078e0036ULL,
0x0000000040437faeULL, 0x0003e6000b901c4aULL, 0x000000100e187825ULL, 0x040fe200078e0018ULL,
0x00000000363b7faeULL, 0x0003e6000b901c4aULL, 0x000000100e127825ULL, 0x040fe200078e0012ULL,
0x0000000018477faeULL, 0x0003e6000b901c4aULL, 0x000000100e107825ULL, 0x000fe200078e0010ULL,
0x0000000012097faeULL, 0x0003e8000b901c4aULL, 0x00000000104b7faeULL, 0x0003e4000b901c4aULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x01c648355c1879a7ULL, 0x00a2a40008500006ULL,
0x0000000000107805ULL, 0x000fce0000015200ULL, 0x01c648195c0075a7ULL, 0x004ea40008000146ULL,
0x00000000005c0947ULL, 0x004fea0003800000ULL, 0x000000ffff1a7224ULL, 0x000fce00078e00ffULL,
0x000000101a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fce0000015200ULL, 0x00000012100e7210ULL, 0x000fca0007f1e1ffULL,
0x0000000113127824ULL, 0x000fe200000e0e11ULL, 0x003d09000e00780cULL, 0x000fc80003f06070ULL,
0x000000ff1200720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400e00780cULL, 0x000fc80003f06070ULL, 0x000000ff1200720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff097819ULL, 0x000fc80000011412ULL,
0x0000000e09097211ULL, 0x000fca00078110ffULL, 0x000000ffff0e7224ULL, 0x000fca00000e0612ULL,
0x0000000209097819ULL, 0x000fc8000000120eULL, 0x000000090000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011a1a7810ULL, 0x000fce0007ffe0ffULL,
0x01c648195c0075a7ULL, 0x000ea40008000146ULL, 0xfffffffc00a88947ULL, 0x004fea000383ffffULL,
0x01c100000a0e7984ULL, 0x000ea80000000800ULL, 0x01c300000a097984ULL, 0x0006e20000000800ULL,
0x0000000d0e00720bULL, 0x004fda0003f1d000ULL, 0x0000000000127806ULL, 0x000fe400000e0100ULL,
0x000000000000781cULL, 0x000fe40003f0e170ULL, 0x0000ffff12ff7812ULL, 0x000fda000784c0ffULL,
0x0000000000f0a947ULL, 0x00afea0003800000ULL, 0x000000020e00788cULL, 0x000fe2000bf05270ULL,
0x0000000d0e00720bULL, 0x000fca0003f14000ULL, 0x000000000000781cULL, 0x000fd00003f4f008ULL,
0x0000000000137806ULL, 0x000fc800000e0100ULL, 0x0000991013107816ULL, 0x000fe400000000ffULL,
0x0000000e0d11a209ULL, 0x000fe40007810000ULL, 0x000000ff1000720cULL, 0x000fc60003f05270ULL,
0x01c500110a00a388ULL, 0x0003f40000000800ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x0000000e0d107209ULL, 0x000fe40007810000ULL, 0x000000ff13ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0013ff7812ULL, 0x000fe2000784c0ffULL, 0x800000100d107221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL, 0x0000001000187308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff117819ULL, 0x000fca000001160cULL,
0x00001f1118107589ULL, 0x006e6400000e0000ULL, 0x0000001028287220ULL, 0x082fe20000410000ULL,
0x0000001029297220ULL, 0x080fe20000410000ULL, 0x000000102c2c7220ULL, 0x080fe20000410000ULL,
0x000000102d2d7220ULL, 0x080fe20000410000ULL, 0x0000001014147220ULL, 0x080fe20000410000ULL,
0x0000001015157220ULL, 0x080fe20000410000ULL, 0x000000101c1c7220ULL, 0x080fe20000410000ULL,
0x000000101d1d7220ULL, 0x080fe20000410000ULL, 0x0000001020207220ULL, 0x080fe20000410000ULL,
0x0000001021217220ULL, 0x080fe20000410000ULL, 0x0000001024247220ULL, 0x080fe20000410000ULL,
0x0000001025257220ULL, 0x080fe20000410000ULL, 0x000000103c3c7220ULL, 0x080fe20000410000ULL,
0x000000103d3d7220ULL, 0x080fe20000410000ULL, 0x0000001030307220ULL, 0x080fe20000410000ULL,
0x0000001031317220ULL, 0x000fce0000410000ULL, 0x000000180b0b7220ULL, 0x004fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x000000080c117811ULL, 0x000fca00078ff0ffULL,
0x00001f1118107589ULL, 0x002e6400000e0000ULL, 0x000000102a2a7220ULL, 0x082fe20000410000ULL,
0x000000102b2b7220ULL, 0x080fe20000410000ULL, 0x000000102e2e7220ULL, 0x080fe20000410000ULL,
0x000000102f2f7220ULL, 0x080fe20000410000ULL, 0x0000001016167220ULL, 0x080fe20000410000ULL,
0x0000001017177220ULL, 0x080fe20000410000ULL, 0x000000101e1e7220ULL, 0x080fe20000410000ULL,
0x000000101f1f7220ULL, 0x080fe20000410000ULL, 0x0000001022227220ULL, 0x080fe20000410000ULL,
0x0000001023237220ULL, 0x080fe20000410000ULL, 0x0000001026267220ULL, 0x080fe20000410000ULL,
0x0000001027277220ULL, 0x080fe20000410000ULL, 0x000000103e3e7220ULL, 0x080fe20000410000ULL,
0x000000103f3f7220ULL, 0x080fe20000410000ULL, 0x0000001032327220ULL, 0x080fe20000410000ULL,
0x0000001033337220ULL, 0x000fce0000410000ULL, 0x0000ffff13ff7812ULL, 0x000fe40007800812ULL,
0x0000000e0d0d7209ULL, 0x000fd60007810000ULL, 0x8000000d0e0e0221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b0e0e0820ULL, 0x000fc80000410000ULL, 0x0000000e00080308ULL, 0x000ea40000000800ULL,
0x0000000809090220ULL, 0x004fce0000410000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000000188947ULL, 0x000fea0003800000ULL, 0x00000002ff117819ULL, 0x000fe4000001160cULL,
0x00000008ff05723eULL, 0x000fc600000010ffULL, 0x0000000811137836ULL, 0x000fe20000000000ULL,
0x00005410050e7816ULL, 0x000fca0000000005ULL, 0x00001f110e067589ULL, 0x0004e800000e0000ULL,
0x00001f130e057589ULL, 0x00046400000e0000ULL, 0x013000005210783bULL, 0x0062a20000000200ULL,
0x0000000000108947ULL, 0x000fea0003800000ULL, 0x0000000610107232ULL, 0x08cfe40000200000ULL,
0x0000000612127232ULL, 0x000fe40000200000ULL, 0x0000000511117232ULL, 0x080fe40000200000ULL,
0x0000000513137232ULL, 0x000fce0000200000ULL, 0x000000005140783bULL, 0x000f280000004200ULL,
0x000000005438783bULL, 0x000f680000004200ULL, 0x000000005634783bULL, 0x000f680000004200ULL,
0x000000005718783bULL, 0x000f620000004200ULL, 0x000000401028723cULL, 0x014fec0000041828ULL,
0x00000042102c723cULL, 0x000fec000004182cULL, 0x000000381014723cULL, 0x022fec0000041814ULL,
0x0000003a101c723cULL, 0x000fec000004181cULL, 0x000000341020723cULL, 0x008fec0000041820ULL,
0x000000361024723cULL, 0x000fec0000041824ULL, 0x00000018103c723cULL, 0x000fec000004183cULL,
0x0000001a1030723cULL, 0x000fe20000041830ULL, 0x013000005910783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000108947ULL, 0x000fde0003800000ULL,
0x0000000610107232ULL, 0x084fe40000200000ULL, 0x0000000612127232ULL, 0x000fe40000200000ULL,
0x0000000511117232ULL, 0x080fe40000200000ULL, 0x0000000513137232ULL, 0x000fce0000200000ULL,
0x000000005840783bULL, 0x000ee20000004200ULL, 0x000000c009107890ULL, 0x000fe2000fffe03fULL,
0x0000000b090b7221ULL, 0x000fe20000010000ULL, 0x00008e0000087ab9ULL, 0x000fe20000000800ULL,
0x000000005538783bULL, 0x000f220000004200ULL, 0x00000008071372a4ULL, 0x000fc6000f8e0210ULL,
0x000000005334783bULL, 0x000f680000004200ULL, 0x000000005018783bULL, 0x000f220000004200ULL,
0x000000401028723cULL, 0x00cfec0000041828ULL, 0x00000042102c723cULL, 0x000fec000004182cULL,
0x000000381014723cULL, 0x010fec0000041814ULL, 0x0000003a101c723cULL, 0x000fec000004181cULL,
0x000000341020723cULL, 0x022fec0000041820ULL, 0x000000361024723cULL, 0x000fec0000041824ULL,
0x00000018103c723cULL, 0x000fec000004183cULL, 0x0000001a1030723cULL, 0x000fe20000041830ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000400749947ULL, 0x000fde0003800000ULL, 0x000000101100728cULL, 0x000fe2000bf01070ULL,
0x00000003ff117819ULL, 0x000fe2000001160cULL, 0x80000010ff347e24ULL, 0x000fe2000f8e02ffULL,
0x00008a0000167ab9ULL, 0x000fe20000000a00ULL, 0x00000010110c7287ULL, 0x000fe2000c000000ULL,
0x0000001411477810ULL, 0x000fe20007ffe0ffULL, 0x0000000411197836ULL, 0x000fe40000000000ULL,
0x0000000c11397836ULL, 0x000fe40000000000ULL, 0x0000000cff137e24ULL, 0x000fe2000f8e00ffULL,
0x0000000c19097210ULL, 0x000fe20007ffe0ffULL, 0x0000000819367824ULL, 0x000fc400078e00ffULL,
0x0000001011457836ULL, 0x000fe20000000000ULL, 0x0000002013347446ULL, 0x000fe20003800034ULL,
0x0000000811137836ULL, 0x000fe20000000000ULL, 0xfffffff836367812ULL, 0x000fe200078ee209ULL,
0x00000001390e7824ULL, 0x100fe200078e020cULL, 0x0000000c45107210ULL, 0x000fe20007ffe0ffULL,
0x0000000113097824ULL, 0x100fe200078e020cULL, 0x000000341100720cULL, 0x080fe20003f46070ULL,
0x0000000813127824ULL, 0x000fe200078e00ffULL, 0x000000341900720cULL, 0x080fe20003f66070ULL,
0x00000008391b7824ULL, 0x000fe200078e00ffULL, 0x000000341300720cULL, 0x080fe20003f86070ULL,
0x0000000845357824ULL, 0x000fe200078e00ffULL, 0xfffffff812377812ULL, 0x000fe200078ee209ULL,
0x0000001811497836ULL, 0x000fe20000000000ULL, 0xfffffff81b3a7812ULL, 0x000fe200078ee20eULL,
0x00000013111b7c36ULL, 0x000fe20008000000ULL, 0x0000000c11127210ULL, 0x000fe20007ffe0ffULL,
0x0000001c114b7836ULL, 0x000fe20000000000ULL, 0xfffffff835407812ULL, 0x000fe200078ee210ULL,
0x00000016ff107e24ULL, 0x000fe2000f8e00ffULL, 0x0000001700117c02ULL, 0x000fe20008000f00ULL,
0x0000001319197c36ULL, 0x000fe20008000000ULL, 0x0ffffff80c097812ULL, 0x000fe200078ec0ffULL,
0x0000001313137c36ULL, 0x000fe20008000000ULL, 0x0000001436417c11ULL, 0x000fe2000f8e20ffULL,
0x0000000147387824ULL, 0x040fe200078e020cULL, 0x0000000709357812ULL, 0x000fe200078ef812ULL,
0x00000008473b7824ULL, 0x000fe200078e00ffULL, 0x0000001437437c11ULL, 0x000fe2000f8e20ffULL,
0x000002001b1a7825ULL, 0x000fe200078e0010ULL, 0x000000344900720cULL, 0x000fc40003fa6070ULL,
0xfffffff83b387812ULL, 0x000fe200078ee238ULL, 0x000000125d0e7c36ULL, 0x000fe20008000000ULL,
0x00000014353b7c11ULL, 0x000fe2000f8e20ffULL, 0x0000020019187825ULL, 0x100fe200078e0010ULL,
0x000000344b00720cULL, 0x000fe40003fc6070ULL, 0x0000000c4b447210ULL, 0x000fe20007ffe0ffULL,
0x0000020013127825ULL, 0x000fc800078e0010ULL, 0x000000100e1a7825ULL, 0x000fc800078e001aULL,
0x000000100e187825ULL, 0x040fe200078e0018ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a3b7faeULL, 0x0003e2000d101c4aULL, 0x000000343900720cULL, 0x080fe40003f46070ULL,
0x000000100e127825ULL, 0x000fe200078e0012ULL, 0x0000000018417faeULL, 0x0005e2000d901c4aULL,
0x000000344500720cULL, 0x080fe40003f66070ULL, 0x0000001339377c36ULL, 0x000fe20008000000ULL,
0x0000000012437faeULL, 0x0007e2000e101c4aULL, 0x0000001345357c36ULL, 0x000fe20008000000ULL,
0x000000344700720cULL, 0x000fe20003f86070ULL, 0x0000001347397c36ULL, 0x000fe20008000000ULL,
0x00000013493b7c10ULL, 0x002fe2000fffe0ffULL, 0x0000000149427824ULL, 0x000fc400078e020cULL,
0x00000008495b7824ULL, 0x000fe400078e00ffULL, 0x000000134b417c36ULL, 0x004fe40008000000ULL,
0x0000020037367825ULL, 0x000fe200078e0010ULL, 0xfffffff85b427812ULL, 0x000fc600078ee242ULL,
0x000000084b5f7824ULL, 0x000fe200078e00ffULL, 0x0000001442437c11ULL, 0x008fe2000f8e20ffULL,
0x0000020035347825ULL, 0x000fc600078e0010ULL, 0xfffffff85f447812ULL, 0x000fe200078ee244ULL,
0x00000200391a7825ULL, 0x100fe200078e0010ULL, 0x000000143a397c11ULL, 0x000fe4000f8e20ffULL,
0x0000001444457c11ULL, 0x000fe2000f8e20ffULL, 0x000002003b187825ULL, 0x000fe200078e0010ULL,
0x00000014403b7c11ULL, 0x000fc6000f8e20ffULL, 0x0000020041127825ULL, 0x000fe200078e0010ULL,
0x0000001438417c11ULL, 0x000fc6000f8e20ffULL, 0x000000100e367825ULL, 0x000fc800078e0036ULL,
0x000000100e347825ULL, 0x040fe200078e0034ULL, 0x0000000036397faeULL, 0x0003e6000d101c4aULL,
0x000000100e1a7825ULL, 0x040fe200078e001aULL, 0x00000000343b7faeULL, 0x0003e6000d901c4aULL,
0x000000100e187825ULL, 0x040fe200078e0018ULL, 0x000000001a417faeULL, 0x0003e6000e101c4aULL,
0x000000100e127825ULL, 0x000fe200078e0012ULL, 0x0000000018437faeULL, 0x0003e8000e901c4aULL,
0x0000000012457faeULL, 0x0003e2000f101c4aULL, 0x0000000400307947ULL, 0x000fea0003800000ULL,
0x00008a00ff107b82ULL, 0x000e620000000a00ULL, 0x000000040c137811ULL, 0x040fe400078fe8ffULL,
0x000000080c197811ULL, 0x040fe400078fe8ffULL, 0x000000100c417811ULL, 0x040fe200078fe8ffULL,
0x0000000113097824ULL, 0x140fe200078e020cULL, 0x0000000c0c377811ULL, 0x040fe200078fe8ffULL,
0x00000008130e7824ULL, 0x000fe200078e00ffULL, 0x000000140c497811ULL, 0x040fe200078fe8ffULL,
0x0000000141127824ULL, 0x100fe200078e020cULL, 0x0000000319367819ULL, 0x000fe200000006ffULL,
0x0000000841397824ULL, 0x000fe200078e00ffULL, 0xfffffff80e357812ULL, 0x000fe200078ee209ULL,
0x0000000119097824ULL, 0x100fe200078e020cULL, 0x0000000c49187210ULL, 0x000fe20007ffe0ffULL,
0x00000001370e7824ULL, 0x040fe200078e020cULL, 0xfffffff839427812ULL, 0x000fe200078ee212ULL,
0x00000008371b7824ULL, 0x000fe200078e00ffULL, 0xfffffff836367812ULL, 0x000fe200078ee209ULL,
0x00000008493b7824ULL, 0x000fe200078e00ffULL, 0x0000000c0c127211ULL, 0x040fe200078fe8ffULL,
0x0000001313137c36ULL, 0x000fe20008000000ULL, 0x0ffffff80c097812ULL, 0x040fe200078ec0ffULL,
0x0000001319197c36ULL, 0x000fe20008000000ULL, 0xfffffff81b407812ULL, 0x000fe200078ee20eULL,
0x000000125d0e7c36ULL, 0x000fe20008000000ULL, 0x000000130c1b7c11ULL, 0x000fc4000f8fe8ffULL,
0xfffffff83b447812ULL, 0x000fe200078ee218ULL, 0x0000020019187825ULL, 0x102fe200078e0010ULL,
0x0000000709347812ULL, 0x000fe400078ef812ULL, 0x000000180c4b7811ULL, 0x040fe200078fe8ffULL,
0x0000020013127825ULL, 0x100fe200078e0010ULL, 0x0000001c0c5b7811ULL, 0x000fe400078fe8ffULL,
0x0000001434437c11ULL, 0x000fe2000f8e20ffULL, 0x000002001b1a7825ULL, 0x000fe200078e0010ULL,
0x0000001435457c11ULL, 0x000fc4000f8e20ffULL, 0x0000000c4b467210ULL, 0x000fe20007ffe0ffULL,
0x000000100e387825ULL, 0x000fe200078e0012ULL, 0x0000001436477c11ULL, 0x000fc6000f8e20ffULL,
0x000000100e3a7825ULL, 0x000fe200078e0018ULL, 0x0000001341197c10ULL, 0x000fc6000fffe0ffULL,
0x0000001337137c36ULL, 0x000fe40008000000ULL, 0x000000100e1a7825ULL, 0x000fc800078e001aULL,
0x0000001349377c36ULL, 0x000fe20008000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a437faeULL, 0x0003e2000b901c4aULL, 0x000000134b357c36ULL, 0x000fe40008000000ULL,
0x000000084b5f7824ULL, 0x000fe200078e00ffULL, 0x0000000038457faeULL, 0x0005e2000b901c4aULL,
0x000000135b417c36ULL, 0x000fe40008000000ULL, 0x0000020013127825ULL, 0x000fe200078e0010ULL,
0xfffffff85f467812ULL, 0x000fe200078ee246ULL, 0x000000003a477faeULL, 0x0007e4000b901c4aULL,
0x000000015b487824ULL, 0x040fe200078e020cULL, 0x0000001446437c11ULL, 0x002fe2000f8e20ffULL,
0x000000085b617824ULL, 0x000fc400078e00ffULL, 0x0000020019187825ULL, 0x100fe200078e0010ULL,
0x0000001440397c11ULL, 0x004fe4000f8e20ffULL, 0xfffffff861487812ULL, 0x000fe200078ee248ULL,
0x0000020037367825ULL, 0x000fe200078e0010ULL, 0x00000014423b7c11ULL, 0x008fc6000f8e20ffULL,
0x0000020035347825ULL, 0x000fe200078e0010ULL, 0x0000001448457c11ULL, 0x000fc6000f8e20ffULL,
0x00000200411a7825ULL, 0x000fe200078e0010ULL, 0x0000001444417c11ULL, 0x000fc6000f8e20ffULL,
0x000000100e127825ULL, 0x000fc800078e0012ULL, 0x000000100e187825ULL, 0x040fe200078e0018ULL,
0x0000000012397faeULL, 0x0003e6000b901c4aULL, 0x000000100e367825ULL, 0x040fe200078e0036ULL,
0x00000000183b7faeULL, 0x0003e6000b901c4aULL, 0x000000100e347825ULL, 0x040fe200078e0034ULL,
0x0000000036417faeULL, 0x0003e6000b901c4aULL, 0x000000100e1a7825ULL, 0x000fe200078e001aULL,
0x0000000034437faeULL, 0x0003e8000b901c4aULL, 0x000000001a457faeULL, 0x0003e4000b901c4aULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000000188947ULL, 0x000fea0003800000ULL, 0x00000002ff137819ULL, 0x002fe4000001160cULL,
0x00000008ff05723eULL, 0x000fc600000010ffULL, 0x0000000813197836ULL, 0x000fe20000000000ULL,
0x0000541005127816ULL, 0x000fca0000000005ULL, 0x00001f1312067589ULL, 0x0002a800000e0000ULL,
0x00001f1912057589ULL, 0x0002e400000e0000ULL, 0x013000004f18783bULL, 0x0022e20000000200ULL,
0x0000000000108947ULL, 0x000fea0003800000ULL, 0x0000000618187232ULL, 0x08cfe40000200000ULL,
0x000000061a1a7232ULL, 0x000fe40000200000ULL, 0x0000000519197232ULL, 0x080fe40000200000ULL,
0x000000051b1b7232ULL, 0x000fce0000200000ULL, 0x000000004e44783bULL, 0x000f280000004200ULL,
0x000000004d40783bULL, 0x000f680000004200ULL, 0x000000004c38783bULL, 0x000f680000004200ULL,
0x000000000f34783bULL, 0x000f620000004200ULL, 0x000000441828723cULL, 0x018fec0000041828ULL,
0x00000046182c723cULL, 0x000fec000004182cULL, 0x000000401814723cULL, 0x022fec0000041814ULL,
0x00000042181c723cULL, 0x000fec000004181cULL, 0x000000381820723cULL, 0x000fec0000041820ULL,
0x0000003a1824723cULL, 0x000fec0000041824ULL, 0x00000034183c723cULL, 0x004fec000004183cULL,
0x000000361830723cULL, 0x000fe20000041830ULL, 0x013000000718783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000108947ULL, 0x000fde0003800000ULL,
0x0000000618187232ULL, 0x084fe40000200000ULL, 0x000000061a1a7232ULL, 0x000fe40000200000ULL,
0x0000000519197232ULL, 0x080fe40000200000ULL, 0x000000051b1b7232ULL, 0x000fce0000200000ULL,
0x000000000444783bULL, 0x000ee20000004200ULL, 0x000000111000728cULL, 0x000fe2000bf06070ULL,
0x0000000100137802ULL, 0x000fe40000000f00ULL, 0x000000000340783bULL, 0x000f260000004200ULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x000000000238783bULL, 0x000f680000004200ULL,
0x000000000034783bULL, 0x000f220000004200ULL, 0x01c69813ffff79a7ULL, 0x0007e40008500006ULL,
0x000000441828723cULL, 0x00cfec0000041828ULL, 0x00000046182c723cULL, 0x000fec000004182cULL,
0x000000401814723cULL, 0x010fec0000041814ULL, 0x00000042181c723cULL, 0x000fec000004181cULL,
0x000000381820723cULL, 0x022fec0000041820ULL, 0x0000003a1824723cULL, 0x000fec0000041824ULL,
0x00000034183c723cULL, 0x000fec000004183cULL, 0x000000361830723cULL, 0x000fe20000041830ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000002000500947ULL, 0x000fde0003800000ULL,
0x000000e009097890ULL, 0x000fe2000fffe03fULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x00000008070872a4ULL, 0x000fe2000f8e0209ULL, 0x0000000400609947ULL, 0x000ff60003800000ULL,
0x000000091100728cULL, 0x000fe2000bf01070ULL, 0x00000003ff197819ULL, 0x100fe2000001160cULL,
0x80000009ff467e24ULL, 0x000fe4000f8e02ffULL, 0x00000009110c7287ULL, 0x000fe2000c000000ULL,
0x0000000819497810ULL, 0x000fe20007ffe0ffULL, 0x0000000119127824ULL, 0x100fe200078e020cULL,
0x0000001819617810ULL, 0x000fe20007ffe0ffULL, 0x0000000c194b7836ULL, 0x000fe20000000000ULL,
0x00000008493b7c10ULL, 0x000fe2000fffe0ffULL, 0x0000000cff1b7e24ULL, 0x000fe2000f8e00ffULL,
0x0000000709427812ULL, 0x000fe200078ef812ULL, 0x0000000149127824ULL, 0x000fc400078e020cULL,
0x0000000419477836ULL, 0x000fe20000000000ULL, 0x000000201b467446ULL, 0x000fe20003800046ULL,
0x00000010195b7836ULL, 0x000fe20000000000ULL, 0x00000003491b7819ULL, 0x000fe200000006ffULL,
0x000000014b187824ULL, 0x100fe200078e020cULL, 0x000000461900720cULL, 0x080fe20003fc6070ULL,
0x000000084b357824ULL, 0x000fe200078e00ffULL, 0xfffffff81b4a7812ULL, 0x000fe200078ee212ULL,
0x0000000147097824ULL, 0x140fe200078e020cULL, 0x000000464700720cULL, 0x0c0fe20003fa6070ULL,
0x0000000847487824ULL, 0x000fe200078e00ffULL, 0xfffffff835127812ULL, 0x000fe200078ee218ULL,
0x00000014195f7836ULL, 0x000fe20000000000ULL, 0x000000464900720cULL, 0x080fe20003f86070ULL,
0x000000015b447824ULL, 0x140fe200078e020cULL, 0xfffffff848487812ULL, 0x000fe200078ee209ULL,
0x000000085b1b7824ULL, 0x000fe200078e00ffULL, 0x0000000c61097210ULL, 0x000fe20007ffe0ffULL,
0x0000001c19637836ULL, 0x000fe20000000000ULL, 0x000000464b00720cULL, 0x080fe20003f66070ULL,
0x0000000819397c36ULL, 0x000fe20008000000ULL, 0xfffffff81b447812ULL, 0x000fe200078ee244ULL,
0x000000015f457824ULL, 0x040fe200078e020cULL, 0x0000000863437c10ULL, 0x000fe2000fffe0ffULL,
0x000000085f187824ULL, 0x000fe200078e00ffULL, 0x000000465b00720cULL, 0x080fe20003f46070ULL,
0x00000008611a7824ULL, 0x000fe200078e00ffULL, 0x000000465f00720cULL, 0x000fe20003f26070ULL,
0x0000020039387825ULL, 0x000fe200078e0010ULL, 0xfffffff818457812ULL, 0x000fc400078ee245ULL,
0xfffffff81a097812ULL, 0x000fe200078ee209ULL, 0x0000000847417c36ULL, 0x000fe20008000000ULL,
0x0000000f42477c11ULL, 0x000fe2000f8e20ffULL, 0x000000084b377c36ULL, 0x000fe20008000000ULL,
0x000000466100720cULL, 0x000fe20003f06070ULL, 0x000000085b357c36ULL, 0x000fe20008000000ULL,
0x0000000f48497c11ULL, 0x000fe2000f8e20ffULL, 0x000000085f1b7c36ULL, 0x000fe20008000000ULL,
0x0000000f45457c11ULL, 0x000fe2000f8e20ffULL, 0x0000000861197c36ULL, 0x000fe20008000000ULL,
0x0000000f09097c11ULL, 0x000fe2000f8e20ffULL, 0x0000020041407825ULL, 0x000fc800078e0010ULL,
0x000002003b3a7825ULL, 0x000fc800078e0010ULL, 0x0000020037367825ULL, 0x000fc800078e0010ULL,
0x0000020035347825ULL, 0x000fc800078e0010ULL, 0x000002001b1a7825ULL, 0x000fc800078e0010ULL,
0x0000020019187825ULL, 0x000fc800078e0010ULL, 0x0000020043107825ULL, 0x000fc800078e0010ULL,
0x000000100e427825ULL, 0x000fc800078e0038ULL, 0x00000001635a7824ULL, 0x040fe200078e020cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000042477faeULL, 0x0003e2000f101c4aULL,
0x0000000863657824ULL, 0x040fe200078e00ffULL, 0x000000466300720cULL, 0x000fe20003fc6070ULL,
0x000000100e387825ULL, 0x000fe200078e0040ULL, 0x0000000f4a417c11ULL, 0x000fe4000f8e20ffULL,
0xfffffff8655a7812ULL, 0x000fe200078ee25aULL, 0x000000100e3a7825ULL, 0x000fe200078e003aULL,
0x0000000038497faeULL, 0x0005e4000e901c4aULL, 0x0000000f5a4b7c11ULL, 0x000fe2000f8e20ffULL,
0x000000100e367825ULL, 0x000fe200078e0036ULL, 0x0000000f12437c11ULL, 0x002fe2000f8e20ffULL,
0x000000003a417faeULL, 0x0005e2000e101c4aULL, 0x0000000f44477c11ULL, 0x000fe2000f8e20ffULL,
0x000000100e347825ULL, 0x000fc400078e0034ULL, 0x0000000036437faeULL, 0x0005e4000d901c4aULL,
0x000000100e1a7825ULL, 0x040fe400078e001aULL, 0x0000000034477faeULL, 0x0005e4000d101c4aULL,
0x000000100e187825ULL, 0x040fe400078e0018ULL, 0x000000001a457faeULL, 0x0005e4000c901c4aULL,
0x000000100e107825ULL, 0x000fc400078e0010ULL, 0x0000000018097faeULL, 0x0005e8000c101c4aULL,
0x00000000104b7faeULL, 0x0005e2000f101c4aULL, 0x0000000400247947ULL, 0x000fea0003800000ULL,
0x000000040c357811ULL, 0x040fe400078fe8ffULL, 0x000000080c397811ULL, 0x040fe400078fe8ffULL,
0x000000100c377811ULL, 0x040fe200078fe8ffULL, 0x0000000135197824ULL, 0x140fe200078e020cULL,
0x0000000c391a7210ULL, 0x000fe20007ffe0ffULL, 0x0000000835447824ULL, 0x000fe200078e00ffULL,
0x00000003373b7819ULL, 0x000fe200000006ffULL, 0x00000008391b7824ULL, 0x000fe200078e00ffULL,
0x0000000c0c127211ULL, 0x040fe200078fe8ffULL, 0x0000000137427824ULL, 0x000fe200078e020cULL,
0xfffffff844447812ULL, 0x000fe200078ee219ULL, 0x0000000839397c36ULL, 0x000fe20008000000ULL,
0xfffffff81b467812ULL, 0x000fe200078ee21aULL, 0x0000000837377c36ULL, 0x000fe20008000000ULL,
0x000000180c197811ULL, 0x040fe200078fe8ffULL, 0x0000020039387825ULL, 0x000fe200078e0010ULL,
0x000000140c1b7811ULL, 0x000fc400078fe8ffULL, 0xfffffff83b427812ULL, 0x000fe200078ee242ULL,
0x0000000819347824ULL, 0x000fe200078e00ffULL, 0x0000000c0c417811ULL, 0x040fe200078fe8ffULL,
0x000000081b457824ULL, 0x000fe200078e00ffULL, 0x000000080c3b7c11ULL, 0x040fe2000f8fe8ffULL,
0x0000020037367825ULL, 0x000fe200078e0010ULL, 0x0000000709187812ULL, 0x000fe400078ef812ULL,
0x0000000835357c10ULL, 0x000fe2000fffe0ffULL, 0x0000000119097824ULL, 0x100fe200078e020cULL,
0x0000001c0c477811ULL, 0x000fe200078fe8ffULL, 0x000000011b127824ULL, 0x100fe200078e020cULL,
0x0000000819197c10ULL, 0x000fe2000fffe0ffULL, 0x0000000141437824ULL, 0x040fe200078e020cULL,
0xfffffff834097812ULL, 0x000fe200078ee209ULL, 0x00000008411a7824ULL, 0x000fe200078e00ffULL,
0xfffffff845127812ULL, 0x000fe200078ee212ULL, 0x000002003b3a7825ULL, 0x000fe200078e0010ULL,
0x0000000f09097c11ULL, 0x000fc4000f8e20ffULL, 0xfffffff81a437812ULL, 0x000fe200078ee243ULL,
0x0000000841417c36ULL, 0x000fe40008000000ULL, 0x000000081b1b7c36ULL, 0x000fe20008000000ULL,
0x0000000f43437c11ULL, 0x000fe2000f8e20ffULL, 0x0000020035347825ULL, 0x000fc800078e0010ULL,
0x0000000847457c36ULL, 0x000fe40008000000ULL, 0x0000000147487824ULL, 0x040fe400078e020cULL,
0x0000000847497824ULL, 0x000fe200078e00ffULL, 0x0000000f18477c11ULL, 0x000fe2000f8e20ffULL,
0x0000020041407825ULL, 0x000fc600078e0010ULL, 0xfffffff849487812ULL, 0x000fe200078ee248ULL,
0x000000100e3a7825ULL, 0x000fe200078e003aULL, 0x0000000f46497c11ULL, 0x000fe4000f8e20ffULL,
0x0000000f484b7c11ULL, 0x000fe2000f8e20ffULL, 0x000002001b1a7825ULL, 0x100fe200078e0010ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a477faeULL, 0x0003e6000b901c4aULL,
0x0000020019187825ULL, 0x000fc800078e0010ULL, 0x0000020045107825ULL, 0x000fe200078e0010ULL,
0x0000000f44457c11ULL, 0x000fc6000f8e20ffULL, 0x000000100e347825ULL, 0x000fe200078e0034ULL,
0x0000000f423b7c11ULL, 0x002fe4000f8e20ffULL, 0x0000000f12477c11ULL, 0x000fe2000f8e20ffULL,
0x000000100e387825ULL, 0x040fe200078e0038ULL, 0x0000000034457faeULL, 0x0003e6000b901c4aULL,
0x000000100e407825ULL, 0x040fe200078e0040ULL, 0x0000000038497faeULL, 0x0003e6000b901c4aULL,
0x000000100e367825ULL, 0x040fe200078e0036ULL, 0x0000000040437faeULL, 0x0003e6000b901c4aULL,
0x000000100e1a7825ULL, 0x040fe200078e001aULL, 0x00000000363b7faeULL, 0x0003e6000b901c4aULL,
0x000000100e187825ULL, 0x040fe200078e0018ULL, 0x000000001a477faeULL, 0x0003e6000b901c4aULL,
0x000000100e107825ULL, 0x000fe200078e0010ULL, 0x0000000018097faeULL, 0x0003e8000b901c4aULL,
0x00000000104b7faeULL, 0x0003e4000b901c4aULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x01c668135c1879a7ULL, 0x0062a40008500006ULL, 0x0000000000107805ULL, 0x000fce0000015200ULL,
0x01c668195c0075a7ULL, 0x004ea40008000146ULL, 0x00000000005c0947ULL, 0x004fea0003800000ULL,
0x000000ffff1a7224ULL, 0x000fce00078e00ffULL, 0x000000101a00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x002fcc0000015200ULL,
0x00000012100e7210ULL, 0x000fc80007f1e1ffULL, 0x0000001311127210ULL, 0x000fe400007fe5ffULL,
0x003d09000e00780cULL, 0x000fc80003f06070ULL, 0x000000ff1200720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400e00780cULL, 0x000fc80003f06070ULL,
0x000000ff1200720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff097819ULL, 0x000fc80000011412ULL, 0x0000000e09097211ULL, 0x000fca00078110ffULL,
0x000000ffff0e7224ULL, 0x000fca00000e0612ULL, 0x0000000209097819ULL, 0x000fc8000000120eULL,
0x000000090000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011a1a7836ULL, 0x000fce0000000000ULL, 0x01c668195c0075a7ULL, 0x000ea40008000146ULL,
0xfffffffc00a88947ULL, 0x004fea000383ffffULL, 0x01c180000a0e7984ULL, 0x000ea80000000800ULL,
0x01c380000a097984ULL, 0x0006e20000000800ULL, 0x0000000d0e00720bULL, 0x004fda0003f1d000ULL,
0x0000000000127806ULL, 0x000fe400000e0100ULL, 0x000000000000781cULL, 0x000fe40003f0e170ULL,
0x0000ffff12ff7812ULL, 0x000fda000782c0ffULL, 0x0000000000f09947ULL, 0x00afea0003800000ULL,
0x000000030e00788cULL, 0x000fe2000bf05270ULL, 0x0000000d0e00720bULL, 0x000fca0003f14000ULL,
0x000000000000781cULL, 0x000fd00003f2f008ULL, 0x0000000000137806ULL, 0x000fc800000e0100ULL,
0x0000991013107816ULL, 0x000fe400000000ffULL, 0x0000000d0e119209ULL, 0x000fe40007810000ULL,
0x000000ff1000720cULL, 0x000fc60003f05270ULL, 0x01c580110a009388ULL, 0x0003f40000000800ULL,
0x0000000000b48947ULL, 0x002fea0003800000ULL, 0x0000000d0e0a7209ULL, 0x000fe40007810000ULL,
0x000000ff13ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0013ff7812ULL, 0x000fe2000782c0ffULL,
0x0000000d0a0a7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b0a0a7820ULL, 0x000fc80000410000ULL,
0x0000000a00107308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff117819ULL, 0x000fca000001160cULL, 0x00001f11100a7589ULL, 0x006e6400000e0000ULL,
0x0000000a28287220ULL, 0x082fe20000410000ULL, 0x0000000a29297220ULL, 0x080fe20000410000ULL,
0x0000000a2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000a2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000a14147220ULL, 0x080fe20000410000ULL, 0x0000000a15157220ULL, 0x080fe20000410000ULL,
0x0000000a1c1c7220ULL, 0x080fe20000410000ULL, 0x0000000a1d1d7220ULL, 0x080fe20000410000ULL,
0x0000000a20207220ULL, 0x080fe20000410000ULL, 0x0000000a21217220ULL, 0x080fe20000410000ULL,
0x0000000a24247220ULL, 0x080fe20000410000ULL, 0x0000000a25257220ULL, 0x080fe20000410000ULL,
0x0000000a3c3c7220ULL, 0x080fe20000410000ULL, 0x0000000a3d3d7220ULL, 0x080fe20000410000ULL,
0x0000000a30307220ULL, 0x080fe20000410000ULL, 0x0000000a31317220ULL, 0x000fce0000410000ULL,
0x000000100b0b7220ULL, 0x004fe20000410000ULL, 0x0000000000489947ULL, 0x000fec0003800000ULL,
0x000000080c117811ULL, 0x000fca00078ff0ffULL, 0x00001f11100a7589ULL, 0x002e6400000e0000ULL,
0x0000000a2a2a7220ULL, 0x082fe20000410000ULL, 0x0000000a2b2b7220ULL, 0x080fe20000410000ULL,
0x0000000a2e2e7220ULL, 0x080fe20000410000ULL, 0x0000000a2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000a16167220ULL, 0x080fe20000410000ULL, 0x0000000a17177220ULL, 0x080fe20000410000ULL,
0x0000000a1e1e7220ULL, 0x080fe20000410000ULL, 0x0000000a1f1f7220ULL, 0x080fe20000410000ULL,
0x0000000a22227220ULL, 0x080fe20000410000ULL, 0x0000000a23237220ULL, 0x080fe20000410000ULL,
0x0000000a26267220ULL, 0x080fe20000410000ULL, 0x0000000a27277220ULL, 0x080fe20000410000ULL,
0x0000000a3e3e7220ULL, 0x080fe20000410000ULL, 0x0000000a3f3f7220ULL, 0x080fe20000410000ULL,
0x0000000a32327220ULL, 0x080fe20000410000ULL, 0x0000000a33337220ULL, 0x000fce0000410000ULL,
0x0000ffff13ff7812ULL, 0x000fe40007800812ULL, 0x0000000d0e0d7209ULL, 0x000fd60007810000ULL,
0x8000000d0e0e0221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b0e0e0820ULL, 0x000fc80000410000ULL,
0x0000000e00080308ULL, 0x000ea40000000800ULL, 0x0000000809090220ULL, 0x004fce0000410000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000000000188947ULL, 0x000fea0003800000ULL,
0x00000002ff117819ULL, 0x000fe4000001160cULL, 0x00000008ff05723eULL, 0x000fc600000010ffULL,
0x0000000811137836ULL, 0x000fe20000000000ULL, 0x00005410050a7816ULL, 0x002fca0000000005ULL,
0x00001f110a067589ULL, 0x0002a800000e0000ULL, 0x00001f130a057589ULL, 0x0002e400000e0000ULL,
0x013800005210783bULL, 0x0022e20000000200ULL, 0x0000000000108947ULL, 0x000fea0003800000ULL,
0x0000000610107232ULL, 0x08cfe40000200000ULL, 0x0000000612127232ULL, 0x000fe40000200000ULL,
0x0000000511117232ULL, 0x080fe40000200000ULL, 0x0000000513137232ULL, 0x000fce0000200000ULL,
0x000000005118783bULL, 0x000f280000004200ULL, 0x000000005434783bULL, 0x000f680000004200ULL,
0x000000005638783bULL, 0x000f680000004200ULL, 0x000000005740783bULL, 0x000f620000004200ULL,
0x000000181028723cULL, 0x018fec0000041828ULL, 0x0000001a1018723cULL, 0x000fe2000004182cULL,
0x01380000592c783bULL, 0x0006ea0000000200ULL, 0x000000341014723cULL, 0x022fec0000041814ULL,
0x00000036101c723cULL, 0x000fec000004181cULL, 0x000000381020723cULL, 0x000fec0000041820ULL,
0x0000003a1024723cULL, 0x000fec0000041824ULL, 0x00000040103c723cULL, 0x004fec000004183cULL,
0x000000421010723cULL, 0x000fe20000041830ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000108947ULL, 0x000fde0003800000ULL, 0x000000062c2c7232ULL, 0x088fe40000200000ULL,
0x000000062e2e7232ULL, 0x000fe40000200000ULL, 0x000000052d2d7232ULL, 0x080fe40000200000ULL,
0x000000052f2f7232ULL, 0x000fce0000200000ULL, 0x000000005330783bULL, 0x000e620000004200ULL,
0x000000040d087290ULL, 0x000fe2000fffe03fULL, 0x0000000b090b7221ULL, 0x000fe40000010000ULL,
0x000000005858783bULL, 0x008ea20000004200ULL, 0x0000000108097890ULL, 0x000fe4000fffe03fULL,
0x0000000808087899ULL, 0x000fe2000800063fULL, 0x000000005554783bULL, 0x000ee20000004200ULL,
0x000000050900728cULL, 0x000fc6000bf06070ULL, 0x000000005050783bULL, 0x000f220000004200ULL,
0x00008e0000097ab9ULL, 0x000fe40000000800ULL, 0x000000000000781cULL, 0x000fe20003f2f008ULL,
0x00000009070972a4ULL, 0x000fe2000f8e0208ULL, 0x000000302c20723cULL, 0x002fec0000041820ULL,
0x000000582c28723cULL, 0x004fec0000041828ULL, 0x0000005a2c18723cULL, 0x000fec0000041818ULL,
0x000000542c14723cULL, 0x008fec0000041814ULL, 0x000000562c1c723cULL, 0x000fec000004181cULL,
0x000000322c24723cULL, 0x000fec0000041824ULL, 0x000000502c3c723cULL, 0x010fec000004183cULL,
0x000000522c10723cULL, 0x000fe20000041810ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x00000004006c9947ULL, 0x000fde0003800000ULL,
0x000000081100728cULL, 0x000fe2000bf01070ULL, 0x00008a00ff2c7b82ULL, 0x000e620000000a00ULL,
0x00000003ff0a7819ULL, 0x000fe2000001160cULL, 0x80000008ff097e24ULL, 0x000fe2000f8e02ffULL,
0x00000008110c7287ULL, 0x000fe2000c000000ULL, 0x000000125d5d7c36ULL, 0x000fe40008000000ULL,
0x000000040a317836ULL, 0x000fe40000000000ULL, 0x0000000c0a357836ULL, 0x000fe20000000000ULL,
0x0000000c000e7c02ULL, 0x000fe20008000f00ULL, 0x0000000831337824ULL, 0x000fc400078e00ffULL,
0x00000001352f7824ULL, 0x140fe200078e020cULL, 0x000000200e097446ULL, 0x000fe20003800009ULL,
0x000000080a347836ULL, 0x000fe20000000000ULL, 0x0000000c310e7210ULL, 0x000fe20007ffe0ffULL,
0x000000100a367836ULL, 0x000fe20000000000ULL, 0x00000003353a7819ULL, 0x000fe200000006ffULL,
0x00000001342e7824ULL, 0x100fe200078e020cULL, 0xfffffff833327812ULL, 0x000fe200078ee20eULL,
0x000000010a0e7824ULL, 0x100fe200078e020cULL, 0xfffffff83a3a7812ULL, 0x000fe200078ee22fULL,
0x0000000834377824ULL, 0x000fe200078e00ffULL, 0x000000090a2f7c10ULL, 0x000fe2000fffe0ffULL,
0x0000000136307824ULL, 0x040fe200078e020cULL, 0x000000093100720cULL, 0x080fe20003f46070ULL,
0x0000000836397824ULL, 0x000fe200078e00ffULL, 0x000000090a00720cULL, 0x000fe20003f26070ULL,
0x0000000931317c36ULL, 0x000fe20008000000ULL, 0x000000070e337812ULL, 0x000fe200078ec0ffULL,
0x000000140a3b7836ULL, 0x000fe20000000000ULL, 0xfffffff837387812ULL, 0x000fe200078ee22eULL,
0x000002002f2e7825ULL, 0x002fe200078e002cULL, 0xfffffff839407812ULL, 0x000fc400078ee230ULL,
0x0ffffff833337812ULL, 0x000fe200078ef80cULL, 0x0000020031307825ULL, 0x000fe200078e002cULL,
0x0000001432397c11ULL, 0x000fe4000f8e20ffULL, 0x0000001433377c11ULL, 0x000fe2000f8e20ffULL,
0x000000105d2e7825ULL, 0x000fe200078e002eULL, 0x000000093600720cULL, 0x080fe40003f66070ULL,
0x000000093b00720cULL, 0x080fe20003f86070ULL, 0x000000105d307825ULL, 0x000fe200078e0030ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002e377faeULL, 0x0003e2000c901c4aULL,
0x000000093400720cULL, 0x000fc40003f26070ULL, 0x000000180a417836ULL, 0x000fe20000000000ULL,
0x0000000030397faeULL, 0x0005e2000d101c4aULL, 0x0000001c0a427836ULL, 0x000fe20000000000ULL,
0x000000093500720cULL, 0x080fe20003f46070ULL, 0x0000000935337c36ULL, 0x000fe20008000000ULL,
0x000000094100720cULL, 0x080fe20003fa6070ULL, 0x0000000936357c36ULL, 0x000fe20008000000ULL,
0x000000094200720cULL, 0x040fe20003fc6070ULL, 0x0000000934097c36ULL, 0x000fe20008000000ULL,
0x0000000c3b0a7210ULL, 0x000fe20007ffe0ffULL, 0x000000093b377c36ULL, 0x002fe20008000000ULL,
0x0000000342447819ULL, 0x000fe200000006ffULL, 0x000000083b457824ULL, 0x000fe200078e00ffULL,
0x0000000941397c10ULL, 0x004fe2000fffe0ffULL, 0x00000200092e7825ULL, 0x000fe200078e002cULL,
0x0000001438097c11ULL, 0x000fc4000f8e20ffULL, 0xfffffff8450a7812ULL, 0x000fe200078ee20aULL,
0x00000001410e7824ULL, 0x040fe400078e020cULL, 0x0000000841477824ULL, 0x000fe200078e00ffULL,
0x000000140a417c11ULL, 0x000fe2000f8e20ffULL, 0x00000009423b7c36ULL, 0x000fe40008000000ULL,
0x0000020033307825ULL, 0x000fe200078e002cULL, 0xfffffff8470e7812ULL, 0x000fc600078ee20eULL,
0x0000000142437824ULL, 0x000fe400078e020cULL, 0x0000020035327825ULL, 0x000fc600078e002cULL,
0xfffffff844447812ULL, 0x000fe200078ee243ULL, 0x0000020037347825ULL, 0x100fe200078e002cULL,
0x000000140e437c11ULL, 0x000fe4000f8e20ffULL, 0x0000001444457c11ULL, 0x000fe2000f8e20ffULL,
0x0000020039367825ULL, 0x000fe200078e002cULL, 0x000000143a397c11ULL, 0x000fc6000f8e20ffULL,
0x000002003b2c7825ULL, 0x000fe200078e002cULL, 0x00000014403b7c11ULL, 0x000fc6000f8e20ffULL,
0x000000105d2e7825ULL, 0x000fc800078e002eULL, 0x000000105d307825ULL, 0x040fe200078e0030ULL,
0x000000002e097faeULL, 0x0003e6000c901c4aULL, 0x000000105d327825ULL, 0x040fe200078e0032ULL,
0x0000000030397faeULL, 0x0003e6000d101c4aULL, 0x000000105d347825ULL, 0x040fe200078e0034ULL,
0x00000000323b7faeULL, 0x0003e6000d901c4aULL, 0x000000105d367825ULL, 0x040fe200078e0036ULL,
0x0000000034417faeULL, 0x0003e6000e101c4aULL, 0x000000105d2c7825ULL, 0x000fe200078e002cULL,
0x0000000036437faeULL, 0x0003e8000e901c4aULL, 0x000000002c457faeULL, 0x0003e2000f101c4aULL,
0x0000000400307947ULL, 0x000fea0003800000ULL, 0x000000080c337811ULL, 0x040fe200078fe8ffULL,
0x000000125d5d7c36ULL, 0x000fe20008000000ULL, 0x000000040c317811ULL, 0x040fe400078fe8ffULL,
0x00000003332d7819ULL, 0x040fe200000006ffULL, 0x00000001330e7824ULL, 0x100fe200078e020cULL,
0x0000000c0c357811ULL, 0x040fe200078fe8ffULL, 0x0000000131097824ULL, 0x140fe200078e020cULL,
0x000000100c377811ULL, 0x040fe200078fe8ffULL, 0x00000008310a7824ULL, 0x000fe200078e00ffULL,
0xfffffff82d0e7812ULL, 0x000fe200078ee20eULL, 0x0000000835407824ULL, 0x000fe200078e00ffULL,
0x00008a00ff2c7b82ULL, 0x000e620000000a00ULL, 0x00000001372e7824ULL, 0x100fe200078e020cULL,
0xfffffff80a0a7812ULL, 0x000fe200078ee209ULL, 0x0000000135097824ULL, 0x100fe200078e020cULL,
0x000000140c397811ULL, 0x040fe200078fe8ffULL, 0x00000008372f7824ULL, 0x000fe200078e00ffULL,
0x0000001c0c437811ULL, 0x040fe200078fe8ffULL, 0x0000000931317c36ULL, 0x000fe20008000000ULL,
0x000000180c3b7811ULL, 0x040fe200078fe8ffULL, 0x0000000839447824ULL, 0x000fe200078e00ffULL,
0xfffffff840407812ULL, 0x000fe200078ee209ULL, 0x0000000933337c36ULL, 0x000fe20008000000ULL,
0xfffffff82f427812ULL, 0x000fe200078ee22eULL, 0x00000001432f7824ULL, 0x100fe200078e020cULL,
0x0000000c39097210ULL, 0x000fe20007ffe0ffULL, 0x000000013b2e7824ULL, 0x000fe200078e020cULL,
0x0000000343487819ULL, 0x000fe200000006ffULL, 0x000000083b417824ULL, 0x000fe200078e00ffULL,
0xfffffff844447812ULL, 0x000fe200078ee209ULL, 0x0000000935357c36ULL, 0x000fe20008000000ULL,
0x0000000c0c097211ULL, 0x040fe200078fe8ffULL, 0x0000000939397c36ULL, 0x000fe20008000000ULL,
0xfffffff848487812ULL, 0x000fe200078ee22fULL, 0x000000093b3b7c36ULL, 0x000fe20008000000ULL,
0x000000090c2f7c11ULL, 0x000fe2000f8fe8ffULL, 0x0000020031307825ULL, 0x002fe200078e002cULL,
0xfffffff841467812ULL, 0x000fc400078ee22eULL, 0x0000000709417812ULL, 0x000fe200078ec0ffULL,
0x000002002f2e7825ULL, 0x100fe200078e002cULL, 0x0000000937377c10ULL, 0x000fe4000fffe0ffULL,
0x0ffffff841417812ULL, 0x000fe200078ef80cULL, 0x0000000943097c36ULL, 0x000fe20008000000ULL,
0x000000140e437c11ULL, 0x000fe2000f8e20ffULL, 0x0000020033327825ULL, 0x100fe200078e002cULL,
0x0000001441417c11ULL, 0x000fe4000f8e20ffULL, 0x0000001440457c11ULL, 0x000fe2000f8e20ffULL,
0x0000020035347825ULL, 0x000fe200078e002cULL, 0x0000001442477c11ULL, 0x000fc4000f8e20ffULL,
0x0000001444497c11ULL, 0x000fe2000f8e20ffULL, 0x0000020037367825ULL, 0x100fe200078e002cULL,
0x00000014464b7c11ULL, 0x000fe4000f8e20ffULL, 0x0000001448517c11ULL, 0x000fe2000f8e20ffULL,
0x0000020039387825ULL, 0x000fc800078e002cULL, 0x000002003b3a7825ULL, 0x000fc800078e002cULL,
0x00000200092c7825ULL, 0x000fe200078e002cULL, 0x000000140a097c11ULL, 0x000fc6000f8e20ffULL,
0x000000105d2e7825ULL, 0x000fc800078e002eULL, 0x000000105d307825ULL, 0x040fe200078e0030ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002e417faeULL, 0x0003e6000b901c4aULL,
0x000000105d327825ULL, 0x040fe200078e0032ULL, 0x0000000030097faeULL, 0x0003e6000b901c4aULL,
0x000000105d347825ULL, 0x040fe200078e0034ULL, 0x0000000032437faeULL, 0x0003e6000b901c4aULL,
0x000000105d367825ULL, 0x040fe200078e0036ULL, 0x0000000034457faeULL, 0x0003e6000b901c4aULL,
0x000000105d387825ULL, 0x040fe200078e0038ULL, 0x0000000036477faeULL, 0x0003e6000b901c4aULL,
0x000000105d3a7825ULL, 0x040fe200078e003aULL, 0x0000000038497faeULL, 0x0003e6000b901c4aULL,
0x000000105d2c7825ULL, 0x000fe200078e002cULL, 0x000000003a4b7faeULL, 0x0003e8000b901c4aULL,
0x000000002c517faeULL, 0x0003e4000b901c4aULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000000000188947ULL, 0x000fea0003800000ULL,
0x00000002ff067819ULL, 0x000fe4000001160cULL, 0x00000008ff05723eULL, 0x000fc600000010ffULL,
0x00000008060a7836ULL, 0x000fe20000000000ULL, 0x0000541005097816ULL, 0x002fca0000000005ULL,
0x00001f0609067589ULL, 0x0002a800000e0000ULL, 0x00001f0a09057589ULL, 0x0002e400000e0000ULL,
0x013800004f2c783bULL, 0x0022e20000000200ULL, 0x0000000000108947ULL, 0x000fea0003800000ULL,
0x000000062c2c7232ULL, 0x08cfe40000200000ULL, 0x000000062e2e7232ULL, 0x000fe40000200000ULL,
0x000000052d2d7232ULL, 0x080fe40000200000ULL, 0x000000052f2f7232ULL, 0x000fce0000200000ULL,
0x000000000f30783bULL, 0x000f280000004200ULL, 0x000000004e38783bULL, 0x000f680000004200ULL,
0x000000004d40783bULL, 0x000f680000004200ULL, 0x000000004c34783bULL, 0x000f620000004200ULL,
0x000000302c3c723cULL, 0x018fec000004183cULL, 0x000000322c10723cULL, 0x000fe20000041810ULL,
0x013800000730783bULL, 0x0006ea0000000200ULL, 0x000000382c28723cULL, 0x022fec0000041828ULL,
0x0000003a2c18723cULL, 0x000fec0000041818ULL, 0x000000402c14723cULL, 0x000fec0000041814ULL,
0x000000422c1c723cULL, 0x000fec000004181cULL, 0x000000342c20723cULL, 0x004fec0000041820ULL,
0x000000362c24723cULL, 0x000fe20000041824ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000108947ULL, 0x000fde0003800000ULL, 0x0000000630307232ULL, 0x088fe40000200000ULL,
0x0000000632327232ULL, 0x000fe40000200000ULL, 0x0000000531317232ULL, 0x080fe40000200000ULL,
0x0000000533337232ULL, 0x000fce0000200000ULL, 0x00000000042c783bULL, 0x0002a80000004200ULL,
0x000000000334783bULL, 0x000f280000004200ULL, 0x000000000238783bULL, 0x000f620000004200ULL,
0x0000000100047802ULL, 0x002fc60000000f00ULL, 0x000000000040783bULL, 0x000e620000004200ULL,
0x01c6a004ffff79a7ULL, 0x0003e20008500006ULL, 0x0000002c3028723cULL, 0x00cfec0000041828ULL,
0x0000002e302c723cULL, 0x000fec0000041818ULL, 0x000000343014723cULL, 0x010fec0000041814ULL,
0x00000036301c723cULL, 0x000fec000004181cULL, 0x000000383020723cULL, 0x020fec0000041820ULL,
0x0000003a3024723cULL, 0x000fec0000041824ULL, 0x00000040303c723cULL, 0x002fec000004183cULL,
0x000000423030723cULL, 0x000fde0000041810ULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000040d047290ULL, 0x000fc8000fffe03fULL, 0x000000050400728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0xffffff74003c8947ULL, 0x000fea000383ffffULL,
0x00000000001479c3ULL, 0x000e640000002500ULL, 0x000000051400728cULL, 0x002fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000c80947ULL, 0x000fea0003800000ULL,
0x018000000b007836ULL, 0x000fca0000000000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x000000ffff367224ULL, 0x000fe200078e000bULL, 0x0000a0f000027802ULL, 0x000fce0000000f00ULL,
0x000000b800247944ULL, 0x000fea0003c00000ULL, 0x0000000000107947ULL, 0x000fea0003800000ULL,
0x0000000b00007308ULL, 0x000e640000001000ULL, 0xbf80000000027423ULL, 0x002fc8000000000bULL,
0x800000ff02037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fce0000000000ULL,
0x0000000000037919ULL, 0x000f240000000000ULL, 0x00000002ff057819ULL, 0x010fe40000011603ULL,
0x0000000803037811ULL, 0x000fe200078ff0ffULL, 0x0000000000007948ULL, 0x00cfea0003800000ULL,
0x00001f0500027589ULL, 0x000ea800000e0000ULL, 0x00001f0300037589ULL, 0x000ee200000e0000ULL,
0x0000002802287220ULL, 0x044fe20000410000ULL, 0x0000002902297220ULL, 0x040fe20000410000ULL,
0x0000002c022c7220ULL, 0x040fe20000410000ULL, 0x0000002d022d7220ULL, 0x040fe20000410000ULL,
0x0000001402147220ULL, 0x040fe20000410000ULL, 0x0000001502157220ULL, 0x040fe20000410000ULL,
0x0000001c021c7220ULL, 0x040fe20000410000ULL, 0x0000001d021d7220ULL, 0x040fe20000410000ULL,
0x0000002002207220ULL, 0x040fe20000410000ULL, 0x0000002102217220ULL, 0x040fe20000410000ULL,
0x0000002402247220ULL, 0x040fe20000410000ULL, 0x0000002502257220ULL, 0x040fe20000410000ULL,
0x0000003c023c7220ULL, 0x040fe20000410000ULL, 0x0000003d023d7220ULL, 0x040fe20000410000ULL,
0x0000003002307220ULL, 0x040fe20000410000ULL, 0x0000003102317220ULL, 0x000fe20000410000ULL,
0x0000002a032a7220ULL, 0x048fe20000410000ULL, 0x0000002b032b7220ULL, 0x040fe20000410000ULL,
0x0000002e032e7220ULL, 0x040fe20000410000ULL, 0x0000002f032f7220ULL, 0x040fe20000410000ULL,
0x0000001603167220ULL, 0x040fe20000410000ULL, 0x0000001703177220ULL, 0x040fe20000410000ULL,
0x0000001e031e7220ULL, 0x040fe20000410000ULL, 0x0000001f031f7220ULL, 0x040fe20000410000ULL,
0x0000002203227220ULL, 0x040fe20000410000ULL, 0x0000002303237220ULL, 0x040fe20000410000ULL,
0x0000002603267220ULL, 0x040fe20000410000ULL, 0x0000002703277220ULL, 0x040fe20000410000ULL,
0x0000003e033e7220ULL, 0x040fe20000410000ULL, 0x0000003f033f7220ULL, 0x040fe20000410000ULL,
0x0000003203327220ULL, 0x040fe20000410000ULL, 0x0000003303337220ULL, 0x000fce0000410000ULL,
0x0000000000007919ULL, 0x000ea20000000000ULL, 0x000000060e067291ULL, 0x000fe2000f8e583fULL,
0x000000202110723eULL, 0x000fe200000010ffULL, 0x000000010d00788cULL, 0x000fe2000bf05270ULL,
0x000000242511723eULL, 0x000fe200000010ffULL, 0x0001200006167890ULL, 0x000fe2000fffe03fULL,
0x0000003c3d12723eULL, 0x000fe200000010ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000781cULL, 0x000fc40003f0f008ULL, 0x000000303113723eULL, 0x000fe400000010ffULL,
0x000000161716723eULL, 0x000fe400000010ffULL, 0x0000001e1f17723eULL, 0x000fe400000010ffULL,
0x000000222318723eULL, 0x000fe400000010ffULL, 0x000000262719723eULL, 0x000fe400000010ffULL,
0x0000003e3f1a723eULL, 0x000fc400000010ffULL, 0x00000032331b723eULL, 0x000fe400000010ffULL,
0x00000003ff037819ULL, 0x004fe40000011600ULL, 0xfffffff8ff057812ULL, 0x000fe400078ee200ULL,
0x0000000303027812ULL, 0x000fe400078ec0ffULL, 0x00000003050f7819ULL, 0x040fe200000006ffULL,
0x0000000805077836ULL, 0x000fe40000000000ULL, 0x0000000805087824ULL, 0x000fc400078e00ffULL,
0x0000000102057824ULL, 0x040fe400078e0205ULL, 0x0000000102067824ULL, 0x000fe400078e0207ULL,
0x0000000807097824ULL, 0x040fe200078e00ffULL, 0x0000000405047810ULL, 0x000fe20007ffe0ffULL,
0x00000008070a7824ULL, 0x000fe200078e00ffULL, 0xfffffff808027812ULL, 0x000fe200078ee205ULL,
0x0000000c05077836ULL, 0x000fe20000000000ULL, 0xfffffff80f087812ULL, 0x000fe400078ee204ULL,
0xfffffff809097812ULL, 0x000fc400078ee206ULL, 0xfffffff80a0a7812ULL, 0x000fe400078ee207ULL,
0x000000282904723eULL, 0x000fe400000010ffULL, 0x0000002c2d05723eULL, 0x000fe400000010ffULL,
0x000000141506723eULL, 0x000fe400000010ffULL, 0x0000001c1d07723eULL, 0x000fe400000010ffULL,
0x0000001602027c11ULL, 0x000fc4000f8e20ffULL, 0x0000001608087c11ULL, 0x000fe4000f8e20ffULL,
0x0000002a2b14723eULL, 0x000fe200000010ffULL, 0x0000000402007844ULL, 0x0005e20000000200ULL,
0x0000002e2f15723eULL, 0x000fe400000010ffULL, 0x0000001609097c11ULL, 0x000fe2000f8e20ffULL,
0x0000001008007844ULL, 0x0005e20000000200ULL, 0x000000160a0a7c11ULL, 0x000fc6000f8e20ffULL,
0x0000001409007844ULL, 0x0005e80000000200ULL, 0x000000180a007844ULL, 0x0005e20000000200ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000002400b88947ULL, 0x000fea0003800000ULL,
0x00000000000979c3ULL, 0x000fe20000002700ULL, 0x0000900000047ab9ULL, 0x000fe20000000800ULL,
0x0000840000077ab9ULL, 0x000fe20000000800ULL, 0x0000000eff007c0cULL, 0x000fe2000bf05270ULL,
0x00000004070472a4ULL, 0x000fe2000f8e023fULL, 0x0000000600027c11ULL, 0x004fe2000f8e20ffULL,
0x0000940000107ab9ULL, 0x000fe40000000a00ULL, 0x00000000000579c3ULL, 0x000ea40000002600ULL,
0x00000007090972a4ULL, 0x004fc4000f8e0205ULL, 0x0000000f04077891ULL, 0x000fe4000f8e103fULL,
0x0000000d091572a4ULL, 0x000fe4000f8e023fULL, 0xfffffff007077892ULL, 0x000fe4000f8ec03fULL,
0x0000000d040472a4ULL, 0x000fe4000f8e023fULL, 0x0000001007177290ULL, 0x000fe4000ff1e03fULL,
0x00000014150c7290ULL, 0x000fc4000fffe03fULL, 0x0000000704187291ULL, 0x000fe4000f8e383fULL,
0x000000113f197290ULL, 0x000fe200087fe43fULL, 0x0000000000480947ULL, 0x000ff60003800000ULL,
0x000000070c057899ULL, 0x000fe2000800063fULL, 0x0000001000047824ULL, 0x000fe200078e00ffULL,
0x000000193f087899ULL, 0x000fe2000801160cULL, 0x00000001ff057819ULL, 0x000fc60000011600ULL,
0x00000005ff077e24ULL, 0x000fe2000f8e00ffULL, 0x0000007004067812ULL, 0x000fe200078ec0ffULL,
0x0000001005057290ULL, 0x000fe2000f91e018ULL, 0x0000000c05057812ULL, 0x000fe400078ec0ffULL,
0x0000001706047c10ULL, 0x000fe2000fa3e007ULL, 0x00000008ff077e24ULL, 0x000fe2000f8e00ffULL,
0x0000001108087290ULL, 0x000fe200087e243fULL, 0x0000000505067c10ULL, 0x000fe4000fd9e006ULL,
0x0000000405047210ULL, 0x000fc40007f7e0ffULL, 0x00000019ff057c10ULL, 0x000fe40008fe4407ULL,
0x00000008ff077c10ULL, 0x000fe4000a7ea4ffULL, 0x00000005ff057210ULL, 0x000fca0001ffe4ffULL,
0x0000000d04007986ULL, 0x0005e8000c10190aULL, 0x0000000b06007986ULL, 0x0005e4000c10190aULL,
0x0000001804047291ULL, 0x000fe2000f8e383fULL, 0x0120000002087984ULL, 0x004ea20000000c00ULL,
0x000000ff0000720cULL, 0x000fe20000705670ULL, 0x00000020000d7836ULL, 0x000fe20000000000ULL,
0x0000007f04047890ULL, 0x000fe2000fffe03fULL, 0x0122000002107984ULL, 0x000ee20000000c00ULL,
0x000002e000007945ULL, 0x000fe40003800000ULL, 0xffffff8004087892ULL, 0x000fc8000f8ec03fULL,
0x0000001008047290ULL, 0x000fc8000ff1e03fULL, 0x000000113f057290ULL, 0x000fe400087fe43fULL,
0x000000040c047291ULL, 0x000fc8000f80603fULL, 0x000000050c057291ULL, 0x000fc800080f643fULL,
0x000004000e0478a5ULL, 0x000fcc000f8e0004ULL, 0x00000004ff067e24ULL, 0x000fe4000f8e00ffULL,
0x00000005ff077e24ULL, 0x000fe4000f8e00ffULL, 0x0000001000047825ULL, 0x000fc800078e0006ULL,
0x000000100d067825ULL, 0x000fe200078e0006ULL, 0x0000000804007986ULL, 0x0045e8000c101d0aULL,
0x0000001006007986ULL, 0x0085e2000c101d0aULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000007c0947ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000000075abULL, 0x000fec0000000000ULL, 0x00000000ff00798fULL, 0x000fe20002000000ULL,
0x0000940000047ab9ULL, 0x000fe20000000a00ULL, 0xffffffff0d0c7890ULL, 0x000fe4000fffe03fULL,
0x00000004090478a5ULL, 0x000fc8000f8e0004ULL, 0x0000000cff077e24ULL, 0x004fe4000f8e00ffULL,
0x0000000400047c02ULL, 0x000fe20008000f00ULL, 0x00000005ff057e24ULL, 0x000fca000f8e00ffULL,
0x00000007040479a8ULL, 0x00052200099ee1caULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000000075abULL, 0x000fec0000000000ULL, 0x00000000ff00798fULL, 0x000fe20002000000ULL,
0x00000000000579c3ULL, 0x000ee20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x0000000c04007c0cULL, 0x010fc8000bf05270ULL, 0x00000001ff027807ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x008fd20008000004ULL, 0x00000002ff007988ULL, 0x0007e60008000004ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000479c3ULL, 0x000f220000008800ULL,
0x0000040000097882ULL, 0x000fce0000000000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000065404097896ULL, 0x010fd20008000009ULL, 0x00000009ff027984ULL, 0x008ee40008000000ULL,
0x000000ff0200720cULL, 0x008fda0003f05270ULL, 0x0000002000388947ULL, 0x000fea0003800000ULL,
0x0000000eff007c0cULL, 0x000fda000bf05270ULL, 0x0000000800f00947ULL, 0x000fea0003800000ULL,
0x0000000dff007c0cULL, 0x000fda000bf05270ULL, 0x0000000000848947ULL, 0x000fea0003800000ULL,
0x0000001000027824ULL, 0x000fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fe20000011600ULL,
0x0000001715047291ULL, 0x000fc6000f80383fULL, 0x0000007002027812ULL, 0x000fe200078ec0ffULL,
0x0000001915057291ULL, 0x000fe200080f3c3fULL, 0x0000000c03037812ULL, 0x000fc800078ec0ffULL,
0x0000000403027c10ULL, 0x000fc8000f91e002ULL, 0x00000005ff037c10ULL, 0x000fca00087e24ffULL,
0x0000000a02047981ULL, 0x004528000c1e1900ULL, 0x0000800a02057981ULL, 0x000522000c1e1900ULL,
0x000000020d00788cULL, 0x000fcc000bf05270ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000508947ULL, 0x004fea0003800000ULL, 0x0001000a02077981ULL, 0x000522000c1e1900ULL,
0x000000040d00788cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000408947ULL, 0x004fea0003800000ULL, 0x0001800a02097981ULL, 0x000522000c1e1900ULL,
0x000000040d00788cULL, 0x000fcc000bf05270ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000308947ULL, 0x004fea0003800000ULL, 0x0002000a020b7981ULL, 0x000522000c1e1900ULL,
0x000000060d00788cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000208947ULL, 0x004fea0003800000ULL, 0x0002800a020d7981ULL, 0x000522000c1e1900ULL,
0x000000060d00788cULL, 0x000fcc000bf05270ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000108947ULL, 0x004fea0003800000ULL, 0x000000080d00788cULL, 0x000fe2000bf06070ULL,
0x0003000a020f7981ULL, 0x00052a000c1e1900ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0003800a02110981ULL, 0x000524000c1e1900ULL, 0x000000070d047890ULL, 0x000fc8000fffe03fULL,
0x000000033f0c7899ULL, 0x000fcc0008011604ULL, 0x0000000cff007c0cULL, 0x000fda000bf05270ULL,
0x0000000800388947ULL, 0x000fea0003800000ULL, 0x00000007150f7291ULL, 0x000fe2000f80383fULL,
0x000000ffff137224ULL, 0x014fe200078e0004ULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0x0000003f00057c82ULL, 0x000fe20008000000ULL, 0x000000100f0f7290ULL, 0x000fe4000ff3e03fULL,
0x0000003f15137291ULL, 0x000fe400080f3c3fULL, 0x000007800f0f7890ULL, 0x000fc8000ff1e03fULL,
0x000000133f137290ULL, 0x000fd800087e2411ULL, 0x0000000d0400728cULL, 0x000fe4000bf06070ULL,
0x0000000105057890ULL, 0x000fc8000fffe03fULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x0000000c0500728cULL, 0x000fd8000bf06070ULL, 0x0000000400f00947ULL, 0x014fea0003800000ULL,
0x00000008041a7890ULL, 0x000fe2000fffe03fULL, 0x0000001304047209ULL, 0x000fc60007810000ULL,
0x0000000d1a00728cULL, 0x000fcc000bf26070ULL, 0x000000000000781cULL, 0x000fda0003f0f018ULL,
0x00000000001c0947ULL, 0x000fea0003800000ULL, 0x0000001000027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011600ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x0000000f02027c10ULL, 0x000fc8000ff1e0ffULL,
0x00000013ff037c10ULL, 0x000fca00087fe4ffULL, 0xfffc800a02137981ULL, 0x000528000c1e1900ULL,
0x00000001041a7890ULL, 0x000fc8000fffe03fULL, 0x0000000d1a00728cULL, 0x000fcc000bf26070ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x0000000400b00947ULL, 0x000fea0003800000ULL,
0x00000009041a7890ULL, 0x000fe2000fffe03fULL, 0x0000000504047209ULL, 0x000fc60007810000ULL,
0x0000000d1a00728cULL, 0x000fcc000bf26070ULL, 0x000000000000781cULL, 0x000fda0003f0f018ULL,
0x00000000001c0947ULL, 0x000fea0003800000ULL, 0x0000001000027824ULL, 0x004fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011600ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x0000000f02027c10ULL, 0x000fca000ff1e0ffULL,
0x00000013ff037e24ULL, 0x000fca00080e06ffULL, 0xfffd000a02057981ULL, 0x000526000c1e1900ULL,
0x00000002041a7890ULL, 0x000fc8000fffe03fULL, 0x0000000d1a00728cULL, 0x000fcc000bf26070ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x0000000400700947ULL, 0x000fea0003800000ULL,
0x0000000a041a7890ULL, 0x000fe2000fffe03fULL, 0x0000000704047209ULL, 0x000fc60007810000ULL,
0x0000000d1a00728cULL, 0x000fcc000bf26070ULL, 0x000000000000781cULL, 0x000fda0003f0f018ULL,
0x00000000001c0947ULL, 0x000fea0003800000ULL, 0x0000001000027824ULL, 0x004fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011600ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x0000000f02027c10ULL, 0x000fca000ff1e0ffULL,
0x00000013ff037e24ULL, 0x000fca00080e06ffULL, 0xfffd800a02077981ULL, 0x000526000c1e1900ULL,
0x00000003041a7890ULL, 0x000fc8000fffe03fULL, 0x0000000d1a00728cULL, 0x000fcc000bf26070ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x0000000400300947ULL, 0x000fea0003800000ULL,
0x0000000b041a7890ULL, 0x000fe2000fffe03fULL, 0x0000000904047209ULL, 0x000fc60007810000ULL,
0x0000000d1a00728cULL, 0x000fcc000bf26070ULL, 0x000000000000781cULL, 0x000fda0003f0f018ULL,
0x00000000001c0947ULL, 0x000fea0003800000ULL, 0x0000000400027819ULL, 0x004fe400000006ffULL,
0x00000001ff037819ULL, 0x000fe40000011600ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x0000000f02027c10ULL, 0x000fca000ff1e0ffULL,
0x00000013ff037e24ULL, 0x000fca00080e06ffULL, 0xfffe000a02097981ULL, 0x000526000c1e1900ULL,
0x00000004041a7890ULL, 0x000fc8000fffe03fULL, 0x0000000d1a00728cULL, 0x000fcc000bf26070ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x0000000000f00947ULL, 0x000fea0003800000ULL,
0x0000000c041a7890ULL, 0x000fe2000fffe03fULL, 0x0000000b04047209ULL, 0x000fc60007810000ULL,
0x0000000d1a00728cULL, 0x000fcc000bf26070ULL, 0x000000000000781cULL, 0x000fda0003f0f018ULL,
0x00000000001c0947ULL, 0x000fea0003800000ULL, 0x0000001000027824ULL, 0x004fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011600ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x0000000f02027c10ULL, 0x000fca000ff1e0ffULL,
0x00000013ff037e24ULL, 0x000fca00080e06ffULL, 0xfffe800a020b7981ULL, 0x000526000c1e1900ULL,
0x00000005041a7890ULL, 0x000fc8000fffe03fULL, 0x0000000d1a00728cULL, 0x000fcc000bf26070ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x0000000000b00947ULL, 0x000fea0003800000ULL,
0x0000000d041a7890ULL, 0x000fe2000fffe03fULL, 0x0000000d04047209ULL, 0x000fc60007810000ULL,
0x0000000d1a00728cULL, 0x000fcc000bf26070ULL, 0x000000000000781cULL, 0x000fda0003f0f018ULL,
0x00000000001c0947ULL, 0x000fea0003800000ULL, 0x0000001000027824ULL, 0x004fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011600ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x0000000f02027c10ULL, 0x000fc8000ff1e0ffULL,
0x00000013ff037c10ULL, 0x000fca00087fe4ffULL, 0xffff000a020d7981ULL, 0x000528000c1e1900ULL,
0x00000006041a7890ULL, 0x000fc8000fffe03fULL, 0x0000000d1a00728cULL, 0x000fcc000bf26070ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x0000000000700947ULL, 0x000fea0003800000ULL,
0x0000000e041a7890ULL, 0x000fe2000fffe03fULL, 0x0000000f04047209ULL, 0x000fc60007810000ULL,
0x0000000d1a00728cULL, 0x000fcc000bf26070ULL, 0x000000000000781cULL, 0x000fda0003f0f018ULL,
0x00000000001c0947ULL, 0x000fea0003800000ULL, 0x0000001000027824ULL, 0x004fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011600ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x0000000f02027c10ULL, 0x000fca000ff1e0ffULL,
0x00000013ff037e24ULL, 0x000fca00080e06ffULL, 0xffff800a020f7981ULL, 0x000526000c1e1900ULL,
0x00000007041a7890ULL, 0x000fc8000fffe03fULL, 0x0000000d1a00728cULL, 0x000fcc000bf26070ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x0000000000300947ULL, 0x000fea0003800000ULL,
0x0000000f041a7890ULL, 0x000fe2000fffe03fULL, 0x0000001104047209ULL, 0x000fc60007810000ULL,
0x0000000d1a00728cULL, 0x000fcc000bf26070ULL, 0x000000000000781cULL, 0x000fda0003f0f018ULL,
0x00000000001c0947ULL, 0x000fea0003800000ULL, 0x0000001000027824ULL, 0x004fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011600ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x0000000f02027c10ULL, 0x000fca000ff1e0ffULL,
0x00000013ff037e24ULL, 0x000fca00080e06ffULL, 0x0000000a02117981ULL, 0x000526000c1e1900ULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x000004000f0f7890ULL, 0x000fe4000ff3e03fULL,
0x0000000804047890ULL, 0x000fe4000fffe03fULL, 0x000000133f137290ULL, 0x000fd00008ffe43fULL,
0xfffffff400e88947ULL, 0x000fea000383ffffULL, 0x0000000000007919ULL, 0x000ee40000000000ULL,
0x0000000400027819ULL, 0x00cfe400000006ffULL, 0x00000001ff037819ULL, 0x000fe40000011600ULL,
0x0000007002027812ULL, 0x000fe400078ec0ffULL, 0x0000000c03037812ULL, 0x000fc800078ec0ffULL,
0x0000000903037c10ULL, 0x000fca000fffe002ULL, 0x0000000403007388ULL, 0x0105e40000000800ULL,
0x0000940000047ab9ULL, 0x000fe20000000a00ULL, 0x000000070000780cULL, 0x040fe20003f04070ULL,
0x00000004081a7290ULL, 0x000fe2000ff3e03fULL, 0x00000015ff0b7e24ULL, 0x004fe2000f8e00ffULL,
0x0000000418217290ULL, 0x000fe2000ff1e03fULL, 0x0000001000027824ULL, 0x000fe200078e00ffULL,
0x00000004070f7290ULL, 0x000fe2000ff5e03fULL, 0x00000001ff037819ULL, 0x000fe20000011600ULL,
0x000000053f1b7290ULL, 0x000fe20008ffe43fULL, 0x0000002000077836ULL, 0x000fe20000000000ULL,
0x000000053f227290ULL, 0x000fe200087fe43fULL, 0x0000007002027812ULL, 0x000fe200078ec0ffULL,
0x000000053f137290ULL, 0x000fe200097fe43fULL, 0x0000000c03037812ULL, 0x000fe200078ec0ffULL,
0x0000000a0e1f7899ULL, 0x000fe2000800063fULL, 0x000000210b088c11ULL, 0x040fe2000f8238ffULL,
0x00001000150478a5ULL, 0x000fe2000f8e001aULL, 0x0000000f0b0a8c11ULL, 0x040fe2000f8438ffULL,
0x000000163f207899ULL, 0x000fe2000801160eULL, 0x000000220b098c11ULL, 0x000fe200088f3cffULL,
0x0000001f040c7290ULL, 0x000fe2000ff1e03fULL, 0x0000000dff007c0cULL, 0x000fe2000bf25270ULL,
0x000000090e1c7291ULL, 0x000fc4000f8e603fULL, 0x0000000903147c10ULL, 0x000fe2000fffe002ULL,
0x0000002005047290ULL, 0x000fe200087fe43fULL, 0x000000130b0b8c11ULL, 0x000fe200090f3cffULL,
0x0000000cff047e24ULL, 0x000fe2000f8e00ffULL, 0x00000000003f7886ULL, 0x000fe20000000000ULL,
0x0000001c000d7c11ULL, 0x040fe2000f8e20ffULL, 0x0000001000088825ULL, 0x040fe200078e0008ULL,
0x0000000400057c02ULL, 0x000fe20008000f00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000090e048291ULL, 0x000fe2000f8e403fULL, 0x0000001007067825ULL, 0x100fe200078e0004ULL,
0x000000090e058291ULL, 0x000fe2000f8e403fULL, 0x0000000014147984ULL, 0x000ea20000000800ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000001000047825ULL, 0x040fe200078e0004ULL,
0x00000004000f8c11ULL, 0x000fc4000f8e20ffULL, 0x0000000000247805ULL, 0x000fe4000001ff00ULL,
0x0000000500118c11ULL, 0x040fe2000f8e20ffULL, 0x00000010000a8825ULL, 0x000fe200078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00180000040d7faeULL, 0x0007e2000b901c4aULL,
0x0000000000267805ULL, 0x000fe4000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x000000ffff157224ULL, 0x000fe200078e00ffULL, 0x00380000060d7faeULL, 0x0007e2000b901c4aULL,
0x0000000000287805ULL, 0x000fc4000001ff00ULL, 0x00000000002a7805ULL, 0x000fe4000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x04580000080f8faeULL, 0x0007e2000b901c4aULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x041800000a118faeULL, 0x0007e2000b901c4aULL,
0x00000000001e7805ULL, 0x000fc4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x000000ffff347224ULL, 0x000fe400078e00ffULL, 0x000000ffff367224ULL, 0x002fe200078e00ffULL,
0x0000000800c09947ULL, 0x000fec0003800000ULL, 0xfffffff8ff057812ULL, 0x008fe200078ee200ULL,
0x000000090e047291ULL, 0x000fe2000f8e403fULL, 0x00000003ff047819ULL, 0x100fe20000011600ULL,
0x000000ffff157224ULL, 0x000fe200078e00ffULL, 0x00000002ff3a7819ULL, 0x000fe20000011600ULL,
0x0000000805077836ULL, 0x000fe20000000000ULL, 0x0000000304047812ULL, 0x000fe200078ec0ffULL,
0x0000000805097824ULL, 0x000fe200078e00ffULL, 0x000000083a357810ULL, 0x000fe20007ffe0ffULL,
0x0000000807067824ULL, 0x040fe200078e00ffULL, 0x0000000704377210ULL, 0x000fe20007ffe0ffULL,
0x0000000104047824ULL, 0x000fe200078e0205ULL, 0x00000001151d7890ULL, 0x000fe2000fffe03fULL,
0x0000000807087824ULL, 0x000fe200078e00ffULL, 0xfffffff806377812ULL, 0x000fe200078ee237ULL,
0x0000000805067824ULL, 0x000fe200078e00ffULL, 0x0000000404397810ULL, 0x000fe20007ffe0ffULL,
0x0000000c043b7836ULL, 0x000fe20000000000ULL, 0xfffffff809387812ULL, 0x000fe200078ee204ULL,
0x00000004ff3d7e24ULL, 0x000fe2000f8e00ffULL, 0xfffffff806397812ULL, 0x000fe200078ee239ULL,
0x00000001001e7882ULL, 0x000fe20000000000ULL, 0xfffffff8083b7812ULL, 0x000fce00078ee23bULL,
0x0000000d1e00728cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000980947ULL, 0x000fea0003800000ULL, 0x000000070000780cULL, 0x000fe20003f44070ULL,
0x000010001d0478a5ULL, 0x000fe4000f8e001aULL, 0x0000001dff047e24ULL, 0x000fe2000f8e00ffULL,
0x000000011e247892ULL, 0x000fe2000f8ec03fULL, 0x0000002000077836ULL, 0x000fe20000000000ULL,
0x0000001f04237290ULL, 0x000fe4000ff1e03fULL, 0x0000000b1e0c7899ULL, 0x000fe4000800063fULL,
0x0000002005047290ULL, 0x000fe200087fe43fULL, 0x00000024ff0c7e24ULL, 0x000fe2000f8e00ffULL,
0x000008000c0c7892ULL, 0x000fe2000f8ec03fULL, 0x00000000003f7886ULL, 0x000fe20001020000ULL,
0x000000210408ac11ULL, 0x000fc4000f8038ffULL, 0x0000000c1c0c7290ULL, 0x000fe2000fffe03fULL,
0x0000000f040aac11ULL, 0x040fe2000f8238ffULL, 0x00000004ff057e24ULL, 0x000fe2000f8e00ffULL,
0x000000090e059291ULL, 0x000fe2000f8e403fULL, 0x000000220409ac11ULL, 0x040fe200080f3cffULL,
0x000000090e249291ULL, 0x000fe2000f8e403fULL, 0x00000013040bac11ULL, 0x000fe200088f3cffULL,
0x00000023ff047e24ULL, 0x000fe2000f8e00ffULL, 0x0000000c000d7c11ULL, 0x040fe2000f8e20ffULL,
0x000000100008a825ULL, 0x000fe200078e0008ULL, 0x00000005003dac02ULL, 0x000fc60008000f00ULL,
0x0000001007067825ULL, 0x000fc800078e0004ULL, 0x000000800c0fa824ULL, 0x000fe400078e023dULL,
0x00000024ff3dae24ULL, 0x000fe4000f8e00ffULL, 0x0000001000047825ULL, 0x040fe200078e0004ULL,
0x0000000f000fa211ULL, 0x000fc600078e20ffULL, 0x000000800c11a824ULL, 0x000fe200078e023dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00180000040d7faeULL, 0x0003e2000b901c4aULL,
0x00000010000aa825ULL, 0x000fc600078e000aULL, 0x00380000060d7faeULL, 0x0003e2000b901c4aULL,
0x000000100011a824ULL, 0x000fc600078e0211ULL, 0x04580000080fafaeULL, 0x0003e8000b901c4aULL,
0x041800000a11afaeULL, 0x0003e4000b901c4aULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffff1e047890ULL, 0x000fe4000fffe03fULL, 0x0000000d1e00728cULL, 0x000fe4000bf06070ULL,
0x0000000704057899ULL, 0x000fe4000800063fULL, 0x0000000b04047899ULL, 0x000fe4000800063fULL,
0x0000008005057892ULL, 0x000fe2000f8ec03fULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x0000080004047892ULL, 0x000fc4000f8ec03fULL, 0x000000011d1d7890ULL, 0x000fe4000fffe03fULL,
0x0000000502047c10ULL, 0x002fe2000fffe03dULL, 0x000001801c047890ULL, 0x000fe4000fffe004ULL,
0x000000011e1e7890ULL, 0x000fe4000fffe03fULL, 0x00000001033c7824ULL, 0x000fe400078e0204ULL,
0x0000000438047c11ULL, 0x000fe2000f8e20ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x004180003c0d7984ULL, 0x000e620000000800ULL, 0x000000043b107c11ULL, 0x000fe4000f8e20ffULL,
0x0000000439087c11ULL, 0x000fe2000f8e20ffULL, 0x004580003c3f7984ULL, 0x000fe20000000800ULL,
0x00000004370c7c11ULL, 0x000fc6000f8e20ffULL, 0x000000000404783bULL, 0x000ee80000000200ULL,
0x000000000808783bULL, 0x000f220000000200ULL, 0x0000000d14117221ULL, 0x006fc60000010100ULL,
0x000000000c0c783bULL, 0x000e620000000200ULL, 0x3fb8aa3b11407820ULL, 0x000fc60000410000ULL,
0x000000001010783bULL, 0x000ea20000000200ULL, 0x00007632063e7816ULL, 0x048fe4000000003eULL,
0x0000004000407308ULL, 0x000ee20000000800ULL, 0x0000001006417819ULL, 0x000fe200000006ffULL,
0x0001000008437824ULL, 0x010fe200078e00ffULL, 0x00007632053c7816ULL, 0x000fe2000000003cULL,
0x000100000a457824ULL, 0x040fe200078e00ffULL, 0x0000763207067816ULL, 0x000fe20000000006ULL,
0x0001000005057824ULL, 0x000fe200078e00ffULL, 0x000076320a427816ULL, 0x000fe20000000042ULL,
0x0001000007077824ULL, 0x000fe200078e00ffULL, 0x000076320b0a7816ULL, 0x040fe2000000000aULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x000000100b0b7819ULL, 0x000fe200000006ffULL,
0x0001000006067824ULL, 0x000fe200078e00ffULL, 0x000000103c3c7819ULL, 0x000fe200000006ffULL,
0x000100000a0a7824ULL, 0x000fc400078e00ffULL, 0x0000003f404d7220ULL, 0x008fe20000410000ULL,
0x00010000043f7824ULL, 0x040fe200078e00ffULL, 0x0000763204047816ULL, 0x000fe40000000004ULL,
0x000000364d367221ULL, 0x000fe20000010000ULL, 0x00001f3a4d4e7589ULL, 0x000ee200000e0000ULL,
0x0000763208407816ULL, 0x000fe20000000040ULL, 0x0001000004047824ULL, 0x000fe200078e00ffULL,
0x0000763209087816ULL, 0x040fe20000000008ULL, 0x00001f354d4d7589ULL, 0x000f2200000e0000ULL,
0x0000001042427819ULL, 0x000fe200000006ffULL, 0x0001000009097824ULL, 0x000fc400078e00ffULL,
0x0001000040407824ULL, 0x000fe400078e00ffULL, 0x0001000008087824ULL, 0x000fe200078e00ffULL,
0x000076320d467816ULL, 0x042fe20000000046ULL, 0x000100000d487824ULL, 0x000fe200078e00ffULL,
0x000076320f477816ULL, 0x040fe20000000047ULL, 0x000100000f4a7824ULL, 0x000fe200078e00ffULL,
0x0000763211497816ULL, 0x044fe20000000049ULL, 0x00010000114c7824ULL, 0x000fe200078e00ffULL,
0x0000763212117816ULL, 0x040fe20000000011ULL, 0x00010000124b7824ULL, 0x000fe200078e00ffULL,
0x000076320c447816ULL, 0x040fe20000000044ULL, 0x000100000c0c7824ULL, 0x000fe200078e00ffULL,
0x000076320e0d7816ULL, 0x040fe2000000000dULL, 0x000100000e0e7824ULL, 0x000fe200078e00ffULL,
0x00007632100f7816ULL, 0x000fe2000000000fULL, 0x0000004e04337223ULL, 0x088fe20000010033ULL,
0x0000763213127816ULL, 0x000fe20000000012ULL, 0x0000004e05327223ULL, 0x080fe20000010032ULL,
0x0000001010107819ULL, 0x000fe200000006ffULL, 0x0000004e072e7223ULL, 0x000fe2000001002eULL,
0x0000001047477819ULL, 0x000fe200000006ffULL, 0x0001000013137824ULL, 0x000fc400078e00ffULL,
0x0000004e3f347223ULL, 0x080fe20000010034ULL, 0x0001000044057824ULL, 0x000fe400078e00ffULL,
0x0000004e3c317223ULL, 0x080fe20000010031ULL, 0x0001000046077824ULL, 0x000fe400078e00ffULL,
0x0000004e41307223ULL, 0x080fe20000010030ULL, 0x000100000d0d7824ULL, 0x000fe400078e00ffULL,
0x0000004e3e2f7223ULL, 0x000fe2000001002fULL, 0x000100000f0f7824ULL, 0x000fc400078e00ffULL,
0x0000004e062d7223ULL, 0x080fe2000001002dULL, 0x0001000049497824ULL, 0x000fe400078e00ffULL,
0x0000004e432c7223ULL, 0x080fe2000001002cULL, 0x0001000011047824ULL, 0x000fe400078e00ffULL,
0x0000004e402b7223ULL, 0x080fe2000001002bULL, 0x0001000012127824ULL, 0x000fe400078e00ffULL,
0x0000004e092a7223ULL, 0x080fe2000001002aULL, 0x0000004e08297223ULL, 0x080fe20000010029ULL,
0x0000004e45287223ULL, 0x080fe20000010028ULL, 0x0000004e42277223ULL, 0x080fe20000010027ULL,
0x0000004e0b267223ULL, 0x080fe20000010026ULL, 0x0000004e0a257223ULL, 0x000fe20000010025ULL,
0x0000004d0c237223ULL, 0x090fe20000010023ULL, 0x0000004d05227223ULL, 0x080fe20000010022ULL,
0x0000004d48217223ULL, 0x080fe20000010021ULL, 0x0000004d07207223ULL, 0x080fe20000010020ULL,
0x0000004d0e1f7223ULL, 0x080fe2000001001fULL, 0x0000004d0d1e7223ULL, 0x080fe2000001001eULL,
0x0000004d4a1d7223ULL, 0x080fe2000001001dULL, 0x0000004d471c7223ULL, 0x080fe2000001001cULL,
0x0000004d101b7223ULL, 0x080fe2000001001bULL, 0x0000004d0f1a7223ULL, 0x080fe2000001001aULL,
0x0000004d4c197223ULL, 0x080fe20000010019ULL, 0x0000004d49247223ULL, 0x080fe20000010024ULL,
0x0000004d4b187223ULL, 0x080fe20000010018ULL, 0x0000004d04177223ULL, 0x080fe20000010017ULL,
0x0000004d13167223ULL, 0x080fe20000010016ULL, 0x0000004d12157223ULL, 0x000fe20000010015ULL,
0xfffffff4009c8947ULL, 0x000fec000383ffffULL, 0x0180000036007810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x0000c82000027802ULL, 0x000fce0000000f00ULL, 0x0000009000587944ULL, 0x00cfea0003c00000ULL,
0x000000ffff027224ULL, 0x00cfe200078e0000ULL, 0x0000000000107947ULL, 0x000fec0003800000ULL,
0x0000003600037308ULL, 0x000e640000001000ULL, 0xbf80000003007423ULL, 0x002fc80000000036ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003027223ULL, 0x000fce0000000003ULL,
0x0000000000007919ULL, 0x000f240000000000ULL, 0x00000002ff037819ULL, 0x010fe40000011600ULL,
0x00000008000d7811ULL, 0x008fe400078ff0ffULL, 0xfffffff8ff0f7812ULL, 0x000fe200078ee200ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x00001f0302037589ULL, 0x000ee200000e0000ULL,
0x000000080f117836ULL, 0x000fc60000000000ULL, 0x00001f0d020d7589ULL, 0x00096200000e0000ULL,
0x000000080f127824ULL, 0x040fe400078e00ffULL, 0x000000080f137824ULL, 0x000fe200078e00ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000003403047220ULL, 0x048fe20000410000ULL,
0x0000003303337220ULL, 0x040fe20000410000ULL, 0x0000003203057220ULL, 0x040fe20000410000ULL,
0x0000003103067220ULL, 0x040fe20000410000ULL, 0x0000003003307220ULL, 0x040fe20000410000ULL,
0x0000002f032f7220ULL, 0x040fe20000410000ULL, 0x0000002e03077220ULL, 0x040fe20000410000ULL,
0x0000002d03087220ULL, 0x040fe20000410000ULL, 0x0000002c032c7220ULL, 0x040fe20000410000ULL,
0x0000002b032b7220ULL, 0x040fe20000410000ULL, 0x0000002a03097220ULL, 0x040fe20000410000ULL,
0x0000002903027220ULL, 0x050fe20000410000ULL, 0x00000028030a7220ULL, 0x040fe20000410000ULL,
0x0000002703277220ULL, 0x040fe20000410000ULL, 0x00000026030b7220ULL, 0x040fe20000410000ULL,
0x00000025030c7220ULL, 0x000fe20000410000ULL, 0x00000003ff037819ULL, 0x000fe20000011600ULL,
0x000000230d237220ULL, 0x062fe20000410000ULL, 0x000000220d227220ULL, 0x040fe20000410000ULL,
0x000000210d217220ULL, 0x000fe20000410000ULL, 0x00000003030e7812ULL, 0x000fe200078ec0ffULL,
0x000000200d207220ULL, 0x040fe20000410000ULL, 0x0000001f0d1f7220ULL, 0x040fe20000410000ULL,
0x0000001e0d1e7220ULL, 0x040fe20000410000ULL, 0x0000000f0e0f7210ULL, 0x000fe20007ffe0ffULL,
0x0000001d0d1d7220ULL, 0x040fe20000410000ULL, 0x0000001c0d1c7220ULL, 0x040fe20000410000ULL,
0x0000001b0d1b7220ULL, 0x040fe20000410000ULL, 0x0000001a0d1a7220ULL, 0x040fe20000410000ULL,
0x000000190d197220ULL, 0x040fe20000410000ULL, 0x000000240d247220ULL, 0x040fe20000410000ULL,
0x000000180d187220ULL, 0x040fe20000410000ULL, 0x000000170d177220ULL, 0x040fe20000410000ULL,
0x000000160d167220ULL, 0x000fe20000410000ULL, 0x000000010e107824ULL, 0x000fc400078e0211ULL,
0x000000150d0d7220ULL, 0x000fe20000410000ULL, 0x000000040f0e7836ULL, 0x000fe20000000000ULL,
0x000000050605723eULL, 0x000fe200000010ffULL, 0x0000000811157824ULL, 0x000fe200078e00ffULL,
0x000000043304723eULL, 0x000fe200000010ffULL, 0x0000000811267824ULL, 0x000fe200078e00ffULL,
0x0000000c0f117810ULL, 0x000fe40007ffe0ffULL, 0xfffffff8120f7812ULL, 0x000fe400078ee20fULL,
0xfffffff8130e7812ULL, 0x000fc400078ee20eULL, 0xfffffff815147812ULL, 0x004fe400078ee210ULL,
0xfffffff826157812ULL, 0x000fe400078ee211ULL, 0x000000302f06723eULL, 0x000fe400000010ffULL,
0x000000070807723eULL, 0x000fe400000010ffULL, 0x000000160f0f7c11ULL, 0x000fe4000f8e20ffULL,
0x0000002c2b08723eULL, 0x000fc400000010ffULL, 0x000000090209723eULL, 0x000fe200000010ffULL,
0x000000040f007844ULL, 0x0003e20000000200ULL, 0x0000000a270a723eULL, 0x000fe400000010ffULL,
0x0000000b0c0b723eULL, 0x000fe400000010ffULL, 0x000000160e0e7c11ULL, 0x000fe4000f8e20ffULL,
0x000000232210723eULL, 0x000fe400000010ffULL, 0x000000212011723eULL, 0x000fe200000010ffULL,
0x000000080e007844ULL, 0x0003e20000000200ULL, 0x0000001f1e12723eULL, 0x000fc400000010ffULL,
0x0000001d1c13723eULL, 0x000fe400000010ffULL, 0x0000001614147c11ULL, 0x000fe4000f8e20ffULL,
0x0000001b1a1c723eULL, 0x000fe400000010ffULL, 0x00000019241d723eULL, 0x000fe200000010ffULL,
0x0000001014007844ULL, 0x0003e20000000200ULL, 0x00000018171e723eULL, 0x000fe400000010ffULL,
0x000000160d1f723eULL, 0x000fc400000010ffULL, 0x0000001615157c11ULL, 0x000fca000f8e20ffULL,
0x0000001c15007844ULL, 0x0003e20000000200ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000002000117836ULL, 0x006fe20000000000ULL, 0x0000000000057919ULL, 0x000e620000002600ULL,
0x0000000103067824ULL, 0x000fe200078e0200ULL, 0x00000000000579c3ULL, 0x000ea20000002700ULL,
0x0000840000047ab9ULL, 0x000fe20000000800ULL, 0x00000003ff027819ULL, 0x000fe20000011611ULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x0000000706077812ULL, 0x000fe200078ec0ffULL,
0x00000012ff127e24ULL, 0x000fe4000f8e00ffULL, 0x0000000111047824ULL, 0x000fe200078e0202ULL,
0x0ffffff807077812ULL, 0x000fc800078ef800ULL, 0x0000000704047812ULL, 0x000fe400078ec0ffULL,
0x0000000607087c11ULL, 0x000fe4000f8e20ffULL, 0x0ffffff804047812ULL, 0x000fe400078ef811ULL,
0x0000000700077812ULL, 0x000fe400078ec0ffULL, 0x0000000604047c11ULL, 0x000fe2000f8e20ffULL,
0x0120000008087984ULL, 0x000ee20000000c00ULL, 0x0000000711007812ULL, 0x000fe200078ec0ffULL,
0x00000005040472a4ULL, 0x004fc4000f8e023fULL, 0x01200000040c7984ULL, 0x0005220000000c00ULL,
0x1ffffff807077812ULL, 0x000fe400078ef812ULL, 0x1ffffff800117812ULL, 0x000fe200078ef812ULL,
0x0000000805067824ULL, 0x042fe200078e00ffULL, 0x0000000305057819ULL, 0x000fc800000006ffULL,
0xfffffff806037812ULL, 0x000fe400078ee203ULL, 0xfffffff805027812ULL, 0x000fe400078ee202ULL,
0x0000000403037c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000402057c10ULL, 0x000fe2000ff3e0ffULL,
0x0000860000047ab9ULL, 0x000fe40000000a00ULL, 0x000000ffff107224ULL, 0x000fe200000e06ffULL,
0x0000000403027c11ULL, 0x000fe2000f8048ffULL, 0x000000ffff067224ULL, 0x000fe200008e06ffULL,
0x0000000405047c11ULL, 0x004fc4000f8248ffULL, 0x0000000503037c11ULL, 0x000fe400080f4c10ULL,
0x0000000505057c11ULL, 0x000fe200088f4c06ULL, 0x0000001007027825ULL, 0x000fc800078e0002ULL,
0x0000001011047825ULL, 0x000fe200078e0004ULL, 0x0000000802007986ULL, 0x008fe8000c101d0aULL,
0x0000000c04007986ULL, 0x010fe2000c101d0aULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001040c7890ULL, 0x000fe2000fffe03fULL, 0x00000001ff027424ULL, 0x000fe200078e00ffULL,
0x0000000107077899ULL, 0x000fe4000800063fULL, 0x000000050c00728cULL, 0x000fe4000bf06070ULL,
0x000000060e127899ULL, 0x000fe2000800063fULL, 0x01c60002ff0279a7ULL, 0x000e620008500006ULL,
0x00000009070772a4ULL, 0x000fe4000f8e0208ULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x0000001204097291ULL, 0x000fe2000f8e403fULL, 0x00008e00000c7ab9ULL, 0x000fc60000000800ULL,
0x0000000c070c72a4ULL, 0x000fd0000f8e0209ULL, 0x0000000800ec8947ULL, 0x000fea0003800000ULL,
0x00000003ff077819ULL, 0x000fe2000001160cULL, 0x000000091100728cULL, 0x000fc6000bf01070ULL,
0x00000004070b7810ULL, 0x000fe20007ffe0ffULL, 0x00000008070f7836ULL, 0x000fe20000000000ULL,
0x0000000911087287ULL, 0x000fe2000c000000ULL, 0x0000000c07117836ULL, 0x000fe40000000000ULL,
0x000000010f047824ULL, 0x140fe200078e020cULL, 0x000000030f057819ULL, 0x000fe200000006ffULL,
0x000000010b007824ULL, 0x140fe200078e020cULL, 0x0000000809087290ULL, 0x000fe2000fffe13fULL,
0x000000080b1b7824ULL, 0x000fe200078e00ffULL, 0xfffffff8051c7812ULL, 0x000fe200078ee204ULL,
0x0000000811097824ULL, 0x040fe200078e00ffULL, 0x00008a00ff047b82ULL, 0x000ea20000000a00ULL,
0x00000010070d7836ULL, 0x000fe20000000000ULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee200ULL,
0x0000000111007824ULL, 0x140fe200078e020cULL, 0x0000000811007c0cULL, 0x000fe2000bf06070ULL,
0x0000001407197836ULL, 0x000fe20000000000ULL, 0x0000000c0d067210ULL, 0x000fe20007ffe0ffULL,
0x000000080d137824ULL, 0x000fe200078e00ffULL, 0xfffffff8091e7812ULL, 0x000fe200078ee200ULL,
0x0000001c07257836ULL, 0x000fe20000000000ULL, 0x0000000c19007210ULL, 0x000fe20007ffe0ffULL,
0x0000000819097824ULL, 0x000fe200078e00ffULL, 0xfffffff813207812ULL, 0x000fe200078ee206ULL,
0x0000001807217836ULL, 0x000fe20000000000ULL, 0x0000000325137819ULL, 0x040fe200000006ffULL,
0x0000000125087824ULL, 0x100fe200078e020cULL, 0xfffffff809227812ULL, 0x000fe200078ee200ULL,
0x0000000c07097c36ULL, 0x000fe20008000000ULL, 0x0000000c11117c10ULL, 0x000fe2000fffe0ffULL,
0x0000000121067824ULL, 0x040fe200078e020cULL, 0xfffffff813247812ULL, 0x000fe200078ee208ULL,
0x0000000821237824ULL, 0x000fe200078e00ffULL, 0x0000007017007812ULL, 0x000fe200078ec0ffULL,
0x00000020071d7836ULL, 0x000fe20000000000ULL, 0x000000080b007c0cULL, 0x000fe2000bf46070ULL,
0x0000020009087825ULL, 0x004fe200078e0004ULL, 0xfffffff823237812ULL, 0x000fe200078ee206ULL,
0x000000060e097291ULL, 0x000fe2000f8e703fULL, 0x000000080f007c0cULL, 0x000fe2000bf26070ULL,
0x0000000c0b0b7c36ULL, 0x000fe20008000000ULL, 0x0000000800127210ULL, 0x000fe20007f7e0ffULL,
0x000000011d067824ULL, 0x040fe200078e020cULL, 0x0000200009097890ULL, 0x000fe2000fffe03fULL,
0x000000081d137824ULL, 0x000fc400078e00ffULL, 0x0000020011107825ULL, 0x000fc600078e0004ULL,
0xfffffff813067812ULL, 0x000fe200078ee206ULL, 0x000002000b0a7825ULL, 0x000fe200078e0004ULL,
0x0000001000107210ULL, 0x000fe40007fbe0ffULL, 0x000000091b1b7c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff137224ULL, 0x000fe200018e0609ULL, 0x0000000a00147210ULL, 0x000fe20007f7e0ffULL,
0x0000000107087824ULL, 0x000fe400078e020cULL, 0x0000000c0d097c36ULL, 0x000fe40008000000ULL,
0x000000ffff117224ULL, 0x000fe200028e0611ULL, 0x000000080d007c0cULL, 0x000fe2000bfa6070ULL,
0x000000ffff157224ULL, 0x000fe200018e060bULL, 0x00000007080d7812ULL, 0x000fe200078ec0ffULL,
0x00000024071f7836ULL, 0x000fe20000000000ULL, 0x0000000807007c0cULL, 0x000fe2000bf66070ULL,
0x0000020009087825ULL, 0x000fe200078e0004ULL, 0x0ffffff80d0d7812ULL, 0x000fc400078ef80cULL,
0x0000000c190b7c10ULL, 0x000fe2000fffe0ffULL, 0x0000000c0f0f7c36ULL, 0x000fe20008000000ULL,
0x0000000800167210ULL, 0x000fe20007fde0ffULL, 0x000000011f177824ULL, 0x000fe200078e020cULL,
0x000000090d0d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000081f1a7824ULL, 0x000fe400078e00ffULL,
0x000002000f0e7825ULL, 0x100fe400078e0004ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000120d7faeULL, 0x0005e2000d901c4aULL, 0xfffffff81a1a7812ULL, 0x000fe200078ee217ULL,
0x000002000b0a7825ULL, 0x000fe200078e0004ULL, 0x0000000e000e7210ULL, 0x000fe20007f9e0ffULL,
0x00000000141b7faeULL, 0x0007e2000d101c4aULL, 0x0000000821007c0cULL, 0x000fe2000bf66070ULL,
0x000000ffff177224ULL, 0x000fe200030e0609ULL, 0x0000000a00187210ULL, 0x000fe20007fde0ffULL,
0x0000000c21097c36ULL, 0x000fe20008000000ULL, 0x0000000fff0f7210ULL, 0x000fe200027fe4ffULL,
0x0000002807217836ULL, 0x000fe20000000000ULL, 0x0000000819007c0cULL, 0x000fe2000bf86070ULL,
0x0000020009087825ULL, 0x000fe200078e0004ULL, 0x0000000bff197210ULL, 0x000fc400037fe4ffULL,
0x000000091c0d7c11ULL, 0x004fe2000f8e20ffULL, 0x0000000121137824ULL, 0x040fe200078e020cULL,
0x0000000800127210ULL, 0x000fe20007fde0ffULL, 0x0000000821267824ULL, 0x000fe200078e00ffULL,
0x000000091e1b7c11ULL, 0x008fe2000f8e20ffULL, 0x0000000c250b7c36ULL, 0x000fe20008000000ULL,
0x000000000e0d7faeULL, 0x0005e2000c901c4aULL, 0x000000081d007c0cULL, 0x000fe4000bf26070ULL,
0x000002000b0a7825ULL, 0x100fe200078e0004ULL, 0xfffffff8261c7812ULL, 0x000fe200078ee213ULL,
0x00000000101b7faeULL, 0x0007e2000c101c4aULL, 0x00000009ff137210ULL, 0x000fe200037fe4ffULL,
0x0000000c1d097c36ULL, 0x000fe20008000000ULL, 0x0000000a00147210ULL, 0x000fe20007fde0ffULL,
0x0000002c071d7836ULL, 0x000fe20000000000ULL, 0x000000081f007c0cULL, 0x000fe2000bf06070ULL,
0x0000020009087825ULL, 0x000fe200078e0004ULL, 0x00000009200d7c11ULL, 0x004fc4000f8e20ffULL,
0x0000000c1d0f7210ULL, 0x000fe20007ffe0ffULL, 0x000000ffff157224ULL, 0x000fe200030e060bULL,
0x00000008000e7210ULL, 0x000fe20007fde0ffULL, 0x000000081d1e7824ULL, 0x000fe200078e00ffULL,
0x00000009221b7c11ULL, 0x008fe2000f8e20ffULL, 0x0000000c1f0b7c36ULL, 0x000fe20008000000ULL,
0x00000030071f7810ULL, 0x000fe20007ffe0ffULL, 0x00000000160d7faeULL, 0x0005e2000e901c4aULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee20fULL, 0x000002000b0a7825ULL, 0x000fe200078e0004ULL,
0x0000000825007c0cULL, 0x000fe2000bf46070ULL, 0x00000000181b7faeULL, 0x0007e2000e101c4aULL,
0x000000081d007c0cULL, 0x000fe2000bf86070ULL, 0x000000ffff0f7224ULL, 0x000fe200030e0609ULL,
0x0000000a00107210ULL, 0x000fe20007fde0ffULL, 0x0000000c21097c36ULL, 0x000fe20008000000ULL,
0x0000000821007c0cULL, 0x000fe2000bfa6070ULL, 0x000000081f207824ULL, 0x000fc400078e00ffULL,
0x0000020009087825ULL, 0x000fe200078e0004ULL, 0x00000009230d7c11ULL, 0x004fc6000f8e20ffULL,
0x000000ffff117224ULL, 0x000fe200030e060bULL, 0x0000000800167210ULL, 0x000fe20007fde0ffULL,
0x000000011f177824ULL, 0x000fe200078e020cULL, 0x0000000924197c11ULL, 0x008fe2000f8e20ffULL,
0x0000000c1d0b7c36ULL, 0x000fe20008000000ULL, 0x00000000120d7faeULL, 0x0005e2000d901c4aULL,
0x00000034071b7836ULL, 0x000fe20000000000ULL, 0xfffffff8201d7812ULL, 0x000fe200078ee217ULL,
0x000002000b0a7825ULL, 0x000fe200078e0004ULL, 0x0000000014197faeULL, 0x0007e2000d101c4aULL,
0x000000081f007c0cULL, 0x000fc4000bf66070ULL, 0x000000ffff177224ULL, 0x000fe200030e0609ULL,
0x0000000c1f097c10ULL, 0x000fe2000fffe0ffULL, 0x000000011b187824ULL, 0x040fe200078e020cULL,
0x0000000a000a7210ULL, 0x000fe20007fde0ffULL, 0x00000038071f7836ULL, 0x000fe20000000000ULL,
0x000000031b0d7819ULL, 0x004fe200000006ffULL, 0x0000020009087825ULL, 0x000fe200078e0004ULL,
0x000000081b007c0cULL, 0x000fe4000bf46070ULL, 0xfffffff80d187812ULL, 0x000fe200078ee218ULL,
0x000000ffff0b7224ULL, 0x000fe200030e060bULL, 0x0000000800127210ULL, 0x000fe20007fde0ffULL,
0x0000000c1b1b7c36ULL, 0x000fe20008000000ULL, 0x00000009060d7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000c1f157c36ULL, 0x008fe20008000000ULL, 0x0000000c1f147210ULL, 0x000fe20007ffe0ffULL,
0x000000ffff137224ULL, 0x000fe200030e0609ULL, 0x000000091d1d7c11ULL, 0x000fe2000f8e20ffULL,
0x000002001b087825ULL, 0x000fe200078e0004ULL, 0x000000000e0d7faeULL, 0x0005e2000c901c4aULL,
0x000000081f007c0cULL, 0x000fc4000bf26070ULL, 0x0000003c07197836ULL, 0x000fe20000000000ULL,
0x0000000800087210ULL, 0x000fe20007fde0ffULL, 0x0000020015067825ULL, 0x000fe200078e0004ULL,
0x000000091a157c11ULL, 0x000fe4000f8e20ffULL, 0x0000000c190c7210ULL, 0x000fe20007ffe0ffULL,
0x0000000c191b7c36ULL, 0x000fe40008000000ULL, 0x000000ffff097224ULL, 0x000fe200030e0609ULL,
0x0000000600067210ULL, 0x000fe20007fde0ffULL, 0x000000081f1f7824ULL, 0x000fe200078e00ffULL,
0x0000000010157faeULL, 0x0007e2000c101c4aULL, 0x000002001b047825ULL, 0x000fe200078e0004ULL,
0x0000000819007c0cULL, 0x000fc4000bf06070ULL, 0xfffffff81f147812ULL, 0x000fe200078ee214ULL,
0x00000008190f7824ULL, 0x004fe200078e00ffULL, 0x000000091c0d7c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff077224ULL, 0x000fe200030e0607ULL, 0x0000000400047210ULL, 0x000fe40007fde0ffULL,
0xfffffff80f0c7812ULL, 0x000fe200078ee20cULL, 0x00000000160d7faeULL, 0x0005e2000e901c4aULL,
0x000000091e0f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff057224ULL, 0x000fe200030e0605ULL,
0x0000000918117c11ULL, 0x008fc4000f8e20ffULL, 0x0000000914157c11ULL, 0x000fe2000f8e20ffULL,
0x000000000a0f7faeULL, 0x0005e2000e101c4aULL, 0x000000090c197c11ULL, 0x000fc6000f8e20ffULL,
0x00000000121d7faeULL, 0x0005e8000d901c4aULL, 0x0000000008117faeULL, 0x0005e8000d101c4aULL,
0x0000000006157faeULL, 0x0005e8000c901c4aULL, 0x0000000004197faeULL, 0x0005e2000c101c4aULL,
0x0000000800987947ULL, 0x000fea0003800000ULL, 0x0000000c0c1d7811ULL, 0x040fe200078fe8ffULL,
0x000000060e087291ULL, 0x000fe2000f8e703fULL, 0x000000080c1b7811ULL, 0x040fe400078fe8ffULL,
0x000000100c1f7811ULL, 0x040fe200078fe8ffULL, 0x000000011d147824ULL, 0x140fe200078e020cULL,
0x000000200c277811ULL, 0x040fe200078fe8ffULL, 0x000000081d077824ULL, 0x000fe200078e00ffULL,
0x0000002c0c2d7811ULL, 0x040fe200078fe8ffULL, 0x000000081b057824ULL, 0x000fe200078e00ffULL,
0x0000000c1b167210ULL, 0x000fe20007ffe0ffULL, 0x000000011f137824ULL, 0x100fe200078e020cULL,
0x000000140c217811ULL, 0x040fe200078fe8ffULL, 0x00000001270b7824ULL, 0x100fe200078e020cULL,
0x000000031f047819ULL, 0x000fe200000006ffULL, 0x0000000827067824ULL, 0x000fe200078e00ffULL,
0xfffffff807147812ULL, 0x000fe200078ee214ULL, 0x000000012d087824ULL, 0x140fe200078e020cULL,
0x0000001c0c257811ULL, 0x040fe200078fe8ffULL, 0x000000082d077824ULL, 0x000fe200078e00ffULL,
0xfffffff805167812ULL, 0x000fe200078ee216ULL, 0x0000000121127824ULL, 0x140fe200078e020cULL,
0xfffffff804137812ULL, 0x000fe200078ee213ULL, 0x0000000821057824ULL, 0x000fe200078e00ffULL,
0x000000240c297811ULL, 0x040fe200078fe8ffULL, 0x0000000825047824ULL, 0x000fe200078e00ffULL,
0x000000040c197811ULL, 0x040fe200078fe8ffULL, 0x0000000c1b1b7c36ULL, 0x000fe20008000000ULL,
0x0000000c250d7210ULL, 0x000fe20007ffe0ffULL, 0x00000001290a7824ULL, 0x100fe200078e020cULL,
0xfffffff8060b7812ULL, 0x000fe200078ee20bULL, 0x0000000119157824ULL, 0x140fe200078e020cULL,
0x000000280c2b7811ULL, 0x040fe200078fe8ffULL, 0x0000000819007824ULL, 0x000fe200078e00ffULL,
0xfffffff807087812ULL, 0x000fe200078ee208ULL, 0x0000000c19197c36ULL, 0x000fe20008000000ULL,
0x00008a00ff067b82ULL, 0x000ea20000000a00ULL, 0xfffffff805127812ULL, 0x000fe200078ee212ULL,
0x000000012b097824ULL, 0x140fe200078e020cULL, 0xfffffff8040d7812ULL, 0x000fe200078ee20dULL,
0x000000082b047824ULL, 0x000fe200078e00ffULL, 0x0000000329057819ULL, 0x000fe200000006ffULL,
0x0000000c21217c36ULL, 0x000fe20008000000ULL, 0x000000340c317811ULL, 0x040fe200078fe8ffULL,
0x0000000c25257c36ULL, 0x000fe20008000000ULL, 0x000000180c237811ULL, 0x040fe200078fe8ffULL,
0x0000000c1f1f7c36ULL, 0x000fe20008000000ULL, 0xfffffff8050a7812ULL, 0x000fe200078ee20aULL,
0x00000001310e7824ULL, 0x140fe200078e020cULL, 0xfffffff800157812ULL, 0x000fe200078ee215ULL,
0x0000000831057824ULL, 0x000fe200078e00ffULL, 0xfffffff804097812ULL, 0x000fe200078ee209ULL,
0x00000001230f7824ULL, 0x040fe200078e020cULL, 0x000000300c2f7811ULL, 0x040fe200078fe8ffULL,
0x0000000823007824ULL, 0x000fe200078e00ffULL, 0x0000000c0c047211ULL, 0x000fe200078fe8ffULL,
0x0000000c23237c36ULL, 0x000fe20008000000ULL, 0xfffffff8050e7812ULL, 0x000fe200078ee20eULL,
0x000000082f117824ULL, 0x000fe200078e00ffULL, 0x0000000704057812ULL, 0x000fe200078ec0ffULL,
0x000002001b1a7825ULL, 0x104fe200078e0006ULL, 0xfffffff8000f7812ULL, 0x000fe200078ee20fULL,
0x0000200008087890ULL, 0x000fe2000fffe03fULL, 0x0000000c2f007210ULL, 0x000fe20007ffe0ffULL,
0x0000020021207825ULL, 0x000fe200078e0006ULL, 0x0000003c0c357811ULL, 0x000fc400078fe8ffULL,
0x0ffffff805347812ULL, 0x000fe200078ef80cULL, 0x0000020023227825ULL, 0x000fe200078e0006ULL,
0x0000000c0c057c11ULL, 0x040fe4000f8fe8ffULL, 0xfffffff811007812ULL, 0x000fe200078ee200ULL,
0x0000000135117824ULL, 0x000fe200078e020cULL, 0x0000007017177812ULL, 0x000fe200078ec0ffULL,
0x0000000835187824ULL, 0x000fe200078e00ffULL, 0x0000000c1d1d7c10ULL, 0x000fe2000fffe0ffULL,
0x0000020005047825ULL, 0x000fe200078e0006ULL, 0x000000380c337811ULL, 0x000fc400078fe8ffULL,
0xfffffff818117812ULL, 0x000fe200078ee211ULL, 0x0000020019187825ULL, 0x100fe200078e0006ULL,
0x0000001704047210ULL, 0x000fe40007f1e0ffULL, 0x0000000c27277c10ULL, 0x000fe2000fffe0ffULL,
0x000002001d1c7825ULL, 0x000fe200078e0006ULL, 0x0000001718187210ULL, 0x000fe40007f3e0ffULL,
0x0000000333377819ULL, 0x000fe200000006ffULL, 0x000000ffff057224ULL, 0x000fe200000e0605ULL,
0x000000171a1a7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff197224ULL, 0x000fe200008e0619ULL,
0x000000171c1c7210ULL, 0x000fe20007f3e0ffULL, 0x0000000c29297c36ULL, 0x000fe20008000000ULL,
0x0000001bff1b7210ULL, 0x000fe200007fe4ffULL, 0x0000020025247825ULL, 0x000fe200078e0006ULL,
0x0000001720207210ULL, 0x000fc40007f1e0ffULL, 0x0000000c31317c10ULL, 0x000fe2000fffe0ffULL,
0x0000000c2b2b7c36ULL, 0x000fe20008000000ULL, 0x0000000815157c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff1d7224ULL, 0x000fe200008e061dULL, 0x0000001722227210ULL, 0x000fe20007f3e0ffULL,
0x000002001f1e7825ULL, 0x100fe200078e0006ULL, 0x0000000813137c11ULL, 0x000fe4000f8e20ffULL,
0x0000000812397c11ULL, 0x000fe2000f8e20ffULL, 0x0000020029287825ULL, 0x000fe200078e0006ULL,
0x000000171e1e7210ULL, 0x000fc40007f5e0ffULL, 0x000000080f0f7c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff217224ULL, 0x000fe200000e0621ULL, 0x0000001724247210ULL, 0x000fe20007f1e0ffULL,
0x000002002b2a7825ULL, 0x000fe200078e0006ULL, 0x000000080d0d7c11ULL, 0x000fe4000f8e20ffULL,
0x00000025ff257210ULL, 0x000fe200007fe4ffULL, 0x0000000c2d2d7c36ULL, 0x000fe20008000000ULL,
0x000000172a2a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000c2f2f7c36ULL, 0x000fe20008000000ULL,
0x000000080b0b7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff237224ULL, 0x000fe200008e0623ULL,
0x0000001728287210ULL, 0x000fe20007f3e0ffULL, 0x0000000133107824ULL, 0x000fe200078e020cULL,
0x0000000809097c11ULL, 0x000fe2000f8e20ffULL, 0x0000020027267825ULL, 0x000fe200078e0006ULL,
0x0000000811117c11ULL, 0x000fc4000f8e20ffULL, 0xfffffff837107812ULL, 0x000fe200078ee210ULL,
0x000002002d2c7825ULL, 0x000fe200078e0006ULL, 0x0000000814377c11ULL, 0x000fc6000f8e20ffULL,
0x0000000c33337c36ULL, 0x000fe40008000000ULL, 0x000002002f2e7825ULL, 0x000fc800078e0006ULL,
0x0000000c35357c36ULL, 0x000fe40008000000ULL, 0x000000ffff1f7224ULL, 0x000fe200010e061fULL,
0x0000001726267210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff297224ULL, 0x000fe200008e0629ULL,
0x000000172c2c7210ULL, 0x000fe20007f3e0ffULL, 0x0000020031307825ULL, 0x000fc800078e0006ULL,
0x0000020033327825ULL, 0x000fc800078e0006ULL, 0x000000ffff2b7224ULL, 0x000fe200000e062bULL,
0x000000172e2e7210ULL, 0x000fe20007f1e0ffULL, 0x0000020035067825ULL, 0x000fe200078e0006ULL,
0x0000000816357c11ULL, 0x000fe4000f8e20ffULL, 0x0000002fff2f7210ULL, 0x000fe200007fe4ffULL,
0x000000ffff277224ULL, 0x000fe200010e0627ULL, 0x0000001732327210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff2d7224ULL, 0x000fe200008e062dULL, 0x0000001730307210ULL, 0x000fe40007f3e0ffULL,
0x0000001706067210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff337224ULL, 0x000fe200000e0633ULL,
0x0000000834177c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff317224ULL, 0x000fc400008e0631ULL,
0x000000ffff077224ULL, 0x000fe400010e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004177faeULL, 0x0005e8000b901c4aULL, 0x0000000018157faeULL, 0x0007e8000b901c4aULL,
0x000000001a357faeULL, 0x000fe8000b901c4aULL, 0x000000001c377faeULL, 0x000fe2000b901c4aULL,
0x000000080a057c11ULL, 0x004fc6000f8e20ffULL, 0x000000001e137faeULL, 0x0005e2000b901c4aULL,
0x0000000800157c11ULL, 0x008fc6000f8e20ffULL, 0x0000000020397faeULL, 0x000fe8000b901c4aULL,
0x00000000220f7faeULL, 0x0007e2000b901c4aULL, 0x0000000808137c11ULL, 0x004fc6000f8e20ffULL,
0x00000000240d7faeULL, 0x0005e8000b901c4aULL, 0x00000000260b7faeULL, 0x0003e2000b901c4aULL,
0x000000080e0f7c11ULL, 0x008fc6000f8e20ffULL, 0x0000000028057faeULL, 0x0003e2000b901c4aULL,
0x00000008100d7c11ULL, 0x004fc6000f8e20ffULL, 0x000000002a097faeULL, 0x0003e8000b901c4aULL,
0x000000002c137faeULL, 0x0003e8000b901c4aULL, 0x000000002e157faeULL, 0x0003e8000b901c4aULL,
0x00000000300f7faeULL, 0x0003e8000b901c4aULL, 0x00000000320d7faeULL, 0x0003e8000b901c4aULL,
0x0000000006117faeULL, 0x0003e4000b901c4aULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000000047805ULL, 0x006fe20000015200ULL, 0x01c60003ff0075a7ULL, 0x000ee40008000146ULL,
0x00000000005c0947ULL, 0x00efea0003800000ULL, 0x000000ffff087224ULL, 0x000fce00078e00ffULL,
0x000000100800780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604097210ULL, 0x000fc80007f1e1ffULL,
0x0000000705077210ULL, 0x000fe400007fe5ffULL, 0x003d09000900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011407ULL,
0x0000000900007211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000200007819ULL, 0x000fc80000001207ULL, 0x000000000000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000108087836ULL, 0x000fce0000000000ULL,
0x01c60003ff0075a7ULL, 0x000e640008000146ULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000050400728cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000707919ULL, 0x000e640000000000ULL,
0x0000001204097291ULL, 0x000fc8000f8e403fULL, 0x000000091100728cULL, 0x000fcc000bf04070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x000000000000894dULL, 0x002fea0003800000ULL,
0x0000000104087890ULL, 0x000fe2000fffe03fULL, 0x00008e0000107ab9ULL, 0x000fc60000000800ULL,
0x000000050800728cULL, 0x000fe4000bf06070ULL, 0x00000010071372a4ULL, 0x000fc8000f8e0209ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000800b08947ULL, 0x000fea0003800000ULL,
0x00000003ff0b7819ULL, 0x102fe20000011670ULL, 0x80000009110c7290ULL, 0x000fe2000fffe03fULL,
0x0ffffff8706a7812ULL, 0x040fe200078ec0ffULL, 0x00008a0000147ab9ULL, 0x000fe20000000a00ULL,
0x0000000c0b137810ULL, 0x000fe20007ffe0ffULL, 0x000000040b0d7836ULL, 0x000fe20000000000ULL,
0x000000280b297810ULL, 0x000fe20007ffe0ffULL, 0x000000080b117836ULL, 0x000fe20000000000ULL,
0x0000007013037210ULL, 0x000fe20007ffe0ffULL, 0x0000000813047824ULL, 0x000fe200078e00ffULL,
0x000000380b317810ULL, 0x000fe20007ffe0ffULL, 0x000000010d007824ULL, 0x100fe200078e0270ULL,
0x0000000c0b007c0cULL, 0x000fe2000bf26070ULL, 0x000000080d177824ULL, 0x000fe200078e00ffULL,
0xfffffff8041b7812ULL, 0x000fe200078ee203ULL, 0x0000000111027824ULL, 0x140fe200078e0270ULL,
0x00000014000e7c02ULL, 0x000fe20008000f00ULL, 0x0000000811197824ULL, 0x000fe200078e00ffULL,
0xfffffff817177812ULL, 0x000fe200078ee200ULL, 0x000000180b217836ULL, 0x000fe20000000000ULL,
0x000000060e087291ULL, 0x000fe2000f8e703fULL, 0x000000100b157836ULL, 0x000fe20000000000ULL,
0xfffffff819197812ULL, 0x000fe200078ee202ULL, 0x000000140b1f7836ULL, 0x000fe20000000000ULL,
0x0000000321187819ULL, 0x040fe200000006ffULL, 0x0000000121037824ULL, 0x100fe200078e0270ULL,
0x0000007015007210ULL, 0x000fe20007ffe0ffULL, 0x00000008151d7824ULL, 0x000fe200078e00ffULL,
0x0000000c0d007c0cULL, 0x000fe2000bf46070ULL, 0x000000011f027824ULL, 0x140fe200078e0270ULL,
0xfffffff818187812ULL, 0x000fe200078ee203ULL, 0x000000081f057824ULL, 0x000fe200078e00ffULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee200ULL, 0x000000240b277836ULL, 0x000fe20000000000ULL,
0x0000000c11007c0cULL, 0x000fe2000bf66070ULL, 0x0000001c0b237836ULL, 0x000fe20000000000ULL,
0xfffffff805167812ULL, 0x000fe200078ee202ULL, 0x000000200b257836ULL, 0x000fe20000000000ULL,
0x00004000080f7890ULL, 0x000fe2000fffe03fULL, 0x0000000127037824ULL, 0x100fe200078e0270ULL,
0x0000000323057819ULL, 0x000fe200000006ffULL, 0x00000008271e7824ULL, 0x000fe200078e00ffULL,
0x0000000c13007c0cULL, 0x000fe2000bf86070ULL, 0x0000000123007824ULL, 0x100fe200078e0270ULL,
0x0000000c15007c0cULL, 0x000fe2000bfa6070ULL, 0x000000300b2d7836ULL, 0x000fe20000000000ULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee203ULL, 0x0000000125027824ULL, 0x140fe200078e0270ULL,
0xfffffff8051a7812ULL, 0x000fe200078ee200ULL, 0x0000000825077824ULL, 0x000fe200078e00ffULL,
0x0000001315157c10ULL, 0x000fe2000fffe0ffULL, 0x0000002c0b2b7836ULL, 0x000fe20000000000ULL,
0x0000000f17177c11ULL, 0x000fe2000f8e20ffULL, 0x0000000129087824ULL, 0x140fe200078e0270ULL,
0xfffffff8071c7812ULL, 0x000fe200078ee202ULL, 0x0000000829037824ULL, 0x000fe200078e00ffULL,
0x000000702b067210ULL, 0x000fe20007ffe0ffULL, 0x0000003c0b337836ULL, 0x000fe20000000000ULL,
0x0000000f19197c11ULL, 0x000fe2000f8e20ffULL, 0x000000012d057824ULL, 0x140fe200078e0270ULL,
0xfffffff803087812ULL, 0x000fe200078ee208ULL, 0x000000082d007824ULL, 0x000fe200078e00ffULL,
0x0000000f1b1b7c11ULL, 0x000fe2000f8e20ffULL, 0x000000082b077824ULL, 0x000fe200078e00ffULL,
0x0000000f1d1d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000133027824ULL, 0x140fe200078e0270ULL,
0xfffffff800057812ULL, 0x000fe200078ee205ULL, 0x0000000833097824ULL, 0x000fe200078e00ffULL,
0x0000000331007819ULL, 0x040fe200000006ffULL, 0x000000340b2f7836ULL, 0x000fe20000000000ULL,
0xfffffff807067812ULL, 0x000fe200078ee206ULL, 0x0000000131037824ULL, 0x100fe200078e0270ULL,
0xfffffff809027812ULL, 0x000fe200078ee202ULL, 0x000000012f047824ULL, 0x100fe200078e0270ULL,
0x0000000c33007c0cULL, 0x000fe2000bfc6070ULL, 0x000000082f077824ULL, 0x000fe200078e00ffULL,
0xfffffff800037812ULL, 0x000fe200078ee203ULL, 0x000000010b097824ULL, 0x000fe200078e0270ULL,
0x0000000770007812ULL, 0x000fe200078ec0ffULL, 0x000000130b0b7c36ULL, 0x000fe20008000000ULL,
0xfffffff807047812ULL, 0x000fe200078ee204ULL, 0x00000015ff0f7e24ULL, 0x000fe2000f8e00ffULL,
0x0000000800077812ULL, 0x000fe200078efcffULL, 0x000000130d0d7c36ULL, 0x000fe20008000000ULL,
0x000000076a097812ULL, 0x000fe200078ef809ULL, 0x0000001311117c36ULL, 0x000fe20008000000ULL,
0x0000000f05057c11ULL, 0x000fe2000f8e20ffULL, 0x000002000b0a7825ULL, 0x000fe200078e000eULL,
0x0000000f09097c11ULL, 0x000fc4000f8e20ffULL, 0x0000000f03037c11ULL, 0x000fe2000f8e20ffULL,
0x000002000d0c7825ULL, 0x000fc800078e000eULL, 0x0000020011107825ULL, 0x000fc800078e000eULL,
0x0000001313137c36ULL, 0x000fe40008000000ULL, 0x00000010070a7825ULL, 0x000fc800078e000aULL,
0x00000010070c7825ULL, 0x000fe200078e000cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a097faeULL, 0x000fe2000c901c4aULL, 0x0000000c1f007c0cULL, 0x000fe4000bf26070ULL,
0x0000020013127825ULL, 0x100fe200078e000eULL, 0x000000000c177faeULL, 0x0003e2000d101c4aULL,
0x0000000c21007c0cULL, 0x000fe4000bf46070ULL, 0x0000020015147825ULL, 0x000fc800078e000eULL,
0x0000001007107825ULL, 0x000fc800078e0010ULL, 0x000000131f1f7c36ULL, 0x000fe20008000000ULL,
0x0000000010197faeULL, 0x0005e2000d901c4aULL, 0x0000001007127825ULL, 0x000fe200078e0012ULL,
0x0000000c23007c0cULL, 0x000fe4000bf66070ULL, 0x0000001327177c10ULL, 0x002fe2000fffe0ffULL,
0x0000001321217c36ULL, 0x000fe20008000000ULL, 0x00000000121b7faeULL, 0x0003e2000e101c4aULL,
0x0000001007147825ULL, 0x000fe200078e0014ULL, 0x0000000c25007c0cULL, 0x000fc6000bf86070ULL,
0x0000001323237c36ULL, 0x000fe20008000000ULL, 0x00000000141d7faeULL, 0x0007e2000e901c4aULL,
0x000002001f0a7825ULL, 0x100fe200078e000eULL, 0x0000000c27007c0cULL, 0x000fe4000bfa6070ULL,
0x0000000f1a197c11ULL, 0x004fe2000f8e20ffULL, 0x0000001325097c36ULL, 0x000fe20008000000ULL,
0x0000000f1c1b7c11ULL, 0x002fe2000f8e20ffULL, 0x00000200210c7825ULL, 0x000fc800078e000eULL,
0x0000020023107825ULL, 0x000fe200078e000eULL, 0x0000000f1e1d7c11ULL, 0x008fc6000f8e20ffULL,
0x0000020009127825ULL, 0x000fe200078e000eULL, 0x0000000f16097c11ULL, 0x000fc6000f8e20ffULL,
0x0000020017147825ULL, 0x000fe200078e000eULL, 0x0000000f18177c11ULL, 0x000fc6000f8e20ffULL,
0x00000010070a7825ULL, 0x000fc800078e000aULL, 0x00000010070c7825ULL, 0x000fe200078e000cULL,
0x000000000a097faeULL, 0x000fe2000c901c4aULL, 0x0000000c29007c0cULL, 0x000fe4000bf26070ULL,
0x0000001007107825ULL, 0x000fe200078e0010ULL, 0x000000000c177faeULL, 0x0003e2000d101c4aULL,
0x0000000c2b007c0cULL, 0x000fe4000bf46070ULL, 0x0000001007127825ULL, 0x000fe200078e0012ULL,
0x0000000010197faeULL, 0x0005e2000d901c4aULL, 0x0000000c2d007c0cULL, 0x000fc4000bf66070ULL,
0x0000001007147825ULL, 0x000fe200078e0014ULL, 0x00000000121b7faeULL, 0x0007e2000e101c4aULL,
0x0000000c2f007c0cULL, 0x000fe4000bf86070ULL, 0x00000013291f7c36ULL, 0x000fe20008000000ULL,
0x0000001331177c10ULL, 0x002fe2000fffe0ffULL, 0x000000132b217c36ULL, 0x000fe20008000000ULL,
0x00000000141d7faeULL, 0x0003e2000e901c4aULL, 0x000000132d237c36ULL, 0x000fe20008000000ULL,
0x0000000c31007c0cULL, 0x000fe2000bfa6070ULL, 0x000000132f097c36ULL, 0x000fc40008000000ULL,
0x0000001333197c36ULL, 0x004fe20008000000ULL, 0x0000000f021b7c11ULL, 0x008fe2000f8e20ffULL,
0x000002001f0a7825ULL, 0x000fc800078e000eULL, 0x00000200210c7825ULL, 0x000fc800078e000eULL,
0x0000020017147825ULL, 0x002fc800078e000eULL, 0x0000020023107825ULL, 0x000fc800078e000eULL,
0x0000020009127825ULL, 0x000fe200078e000eULL, 0x0000000f08097c11ULL, 0x000fc6000f8e20ffULL,
0x0000020019167825ULL, 0x000fe200078e000eULL, 0x0000000f04197c11ULL, 0x000fc6000f8e20ffULL,
0x00000010070a7825ULL, 0x000fc800078e000aULL, 0x00000010070c7825ULL, 0x040fe200078e000cULL,
0x000000000a097faeULL, 0x0003e6000c901c4aULL, 0x0000001007107825ULL, 0x000fc800078e0010ULL,
0x0000001007127825ULL, 0x000fc800078e0012ULL, 0x0000001007147825ULL, 0x000fc800078e0014ULL,
0x0000001007167825ULL, 0x000fe200078e0016ULL, 0x0000000f06077c11ULL, 0x000fca000f8e20ffULL,
0x000000000c077faeULL, 0x0003e8000d101c4aULL, 0x0000000010057faeULL, 0x0003e8000d901c4aULL,
0x0000000012197faeULL, 0x0003e8000e101c4aULL, 0x0000000014037faeULL, 0x0003e8000e901c4aULL,
0x00000000161b7faeULL, 0x0003e2000f101c4aULL, 0x00000008005c7947ULL, 0x000fea0003800000ULL,
0x0000000470177811ULL, 0x042fe200078fe8ffULL, 0x00008a00ff0e7b82ULL, 0x000e620000000a00ULL,
0x0000000c701b7811ULL, 0x040fe200078fe8ffULL, 0x000000060e087291ULL, 0x000fe2000f8e703fULL,
0x0000000870197811ULL, 0x040fe200078fe8ffULL, 0x0000000117037824ULL, 0x140fe200078e0270ULL,
0x0000001c70237811ULL, 0x040fe200078fe8ffULL, 0x0000000817007824ULL, 0x000fe200078e00ffULL,
0x00000014701f7811ULL, 0x040fe200078fe8ffULL, 0x000000011b027824ULL, 0x140fe200078e0270ULL,
0x0000001870217811ULL, 0x040fe200078fe8ffULL, 0x000000081b077824ULL, 0x000fe200078e00ffULL,
0x0000000319057819ULL, 0x040fe200000006ffULL, 0x0000000119047824ULL, 0x100fe200078e0270ULL,
0x00000010701d7811ULL, 0x040fe200078fe8ffULL, 0x0000000123097824ULL, 0x100fe200078e0270ULL,
0xfffffff800037812ULL, 0x000fe200078ee203ULL, 0x000000081f007824ULL, 0x000fe200078e00ffULL,
0xfffffff807027812ULL, 0x000fe200078ee202ULL, 0x00000001210a7824ULL, 0x140fe200078e0270ULL,
0x0000002870297811ULL, 0x040fe200078fe8ffULL, 0x0000000821077824ULL, 0x000fe200078e00ffULL,
0x0000000323067819ULL, 0x000fe200000006ffULL, 0x000000011d0c7824ULL, 0x100fe200078e0270ULL,
0x000000701f0b7210ULL, 0x000fe20007ffe0ffULL, 0x0000000829117824ULL, 0x000fe200078e00ffULL,
0x0000002470277811ULL, 0x040fe200078fe8ffULL, 0x00004000080f7890ULL, 0x000fe2000fffe03fULL,
0xfffffff805047812ULL, 0x000fe200078ee204ULL, 0x000000081d057824ULL, 0x000fe200078e00ffULL,
0x0000002070257811ULL, 0x040fe200078fe8ffULL, 0x0000001317177c36ULL, 0x000fe20008000000ULL,
0xfffffff806097812ULL, 0x000fe200078ee209ULL, 0x0000001319197c36ULL, 0x000fe20008000000ULL,
0x0000002c702b7811ULL, 0x040fe200078fe8ffULL, 0x0000000125087824ULL, 0x100fe200078e0270ULL,
0xfffffff8000b7812ULL, 0x000fe200078ee20bULL, 0x0000000827007824ULL, 0x040fe200078e00ffULL,
0xfffffff8070a7812ULL, 0x000fe200078ee20aULL, 0x0000000127077824ULL, 0x100fe200078e0270ULL,
0x0000007029067210ULL, 0x000fe20007ffe0ffULL, 0x00000008250d7824ULL, 0x000fe200078e00ffULL,
0xfffffff8050c7812ULL, 0x000fe200078ee20cULL, 0x000000012b057824ULL, 0x040fe200078e0270ULL,
0xfffffff811067812ULL, 0x000fe200078ee206ULL, 0x000000082b107824ULL, 0x000fe200078e00ffULL,
0x0000001370117c11ULL, 0x040fe2000f8fe8ffULL, 0x000000131b1b7c36ULL, 0x000fe20008000000ULL,
0xfffffff800077812ULL, 0x000fe200078ee207ULL, 0x000000131f1f7c36ULL, 0x000fe20008000000ULL,
0xfffffff80d087812ULL, 0x000fe200078ee208ULL, 0x0000001321217c36ULL, 0x000fe20008000000ULL,
0x0000000770007812ULL, 0x040fe200078ec0ffULL, 0x0000001323237c36ULL, 0x000fe20008000000ULL,
0x00000070700d7211ULL, 0x040fe200078fe8ffULL, 0x0000001325257c36ULL, 0x000fe20008000000ULL,
0x0ffffff8706a7812ULL, 0x040fe200078ec0ffULL, 0x0000001329297c36ULL, 0x000fe20008000000ULL,
0xfffffff810057812ULL, 0x000fe200078ee205ULL, 0x0000020011107825ULL, 0x002fe200078e000eULL,
0x00000030702d7811ULL, 0x000fc400078fe8ffULL, 0x0000000800337812ULL, 0x000fe400078efcffULL,
0x00000034702f7811ULL, 0x040fe200078fe8ffULL, 0x000000012d127824ULL, 0x000fe200078e0270ULL,
0x000000076a0d7812ULL, 0x000fe200078ef80dULL, 0x0000001033147825ULL, 0x000fe200078e0010ULL,
0x0000003870317811ULL, 0x040fe400078fe8ffULL, 0x0000003c70357811ULL, 0x000fe200078fe8ffULL,
0x000000012f167824ULL, 0x100fe200078e0270ULL, 0x0000000f0d137c11ULL, 0x000fe2000f8e20ffULL,
0x000000082f397824ULL, 0x000fe200078e00ffULL, 0x000000032d377819ULL, 0x000fe200000006ffULL,
0x0000000131187824ULL, 0x040fe200078e0270ULL, 0x00000070351a7210ULL, 0x000fe20007ffe0ffULL,
0x00000008313b7824ULL, 0x000fe200078e00ffULL, 0x000000131d1d7c10ULL, 0x000fe2000fffe0ffULL,
0x00000008353d7824ULL, 0x000fe200078e00ffULL, 0xfffffff837117812ULL, 0x000fe200078ee212ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014137faeULL, 0x0003e2000b901c4aULL,
0xfffffff839127812ULL, 0x000fc400078ee216ULL, 0xfffffff83b107812ULL, 0x000fe400078ee218ULL,
0xfffffff83d0d7812ULL, 0x000fe400078ee21aULL, 0x0000001327277c10ULL, 0x000fe4000fffe0ffULL,
0x0000000f03037c11ULL, 0x000fe4000f8e20ffULL, 0x0000000f0b0b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000020017147825ULL, 0x002fe200078e000eULL, 0x0000000f0a377c11ULL, 0x000fc4000f8e20ffULL,
0x0000000f09097c11ULL, 0x000fe2000f8e20ffULL, 0x0000020019167825ULL, 0x100fe200078e000eULL,
0x0000000f08397c11ULL, 0x000fe4000f8e20ffULL, 0x0000000f07077c11ULL, 0x000fe2000f8e20ffULL,
0x000000132b137c36ULL, 0x000fe20008000000ULL, 0x0000000f063b7c11ULL, 0x000fe2000f8e20ffULL,
0x000002001b187825ULL, 0x100fe200078e000eULL, 0x0000000f05057c11ULL, 0x000fe4000f8e20ffULL,
0x0000000f11117c11ULL, 0x000fe2000f8e20ffULL, 0x000000132d2b7c36ULL, 0x000fe20008000000ULL,
0x0000000f0d0d7c11ULL, 0x000fe2000f8e20ffULL, 0x000002001d1a7825ULL, 0x000fc800078e000eULL,
0x000000132f2d7c36ULL, 0x000fe20008000000ULL, 0x00000013312f7c10ULL, 0x000fe2000fffe0ffULL,
0x000002001f1c7825ULL, 0x000fc800078e000eULL, 0x00000200211e7825ULL, 0x000fc800078e000eULL,
0x0000001335317c36ULL, 0x000fe20008000000ULL, 0x0000000f0c357c11ULL, 0x000fe2000f8e20ffULL,
0x0000020023207825ULL, 0x000fc800078e000eULL, 0x0000020025227825ULL, 0x000fc800078e000eULL,
0x0000020027247825ULL, 0x000fc800078e000eULL, 0x0000020029267825ULL, 0x000fc800078e000eULL,
0x0000020013287825ULL, 0x000fe200078e000eULL, 0x0000000f04137c11ULL, 0x000fc6000f8e20ffULL,
0x000002002b2a7825ULL, 0x000fc800078e000eULL, 0x000002002d2c7825ULL, 0x000fc800078e000eULL,
0x000002002f2e7825ULL, 0x000fc800078e000eULL, 0x0000020031307825ULL, 0x000fc800078e000eULL,
0x0000001033147825ULL, 0x000fc800078e0014ULL, 0x0000001033167825ULL, 0x040fe200078e0016ULL,
0x0000000014037faeULL, 0x0003e6000b901c4aULL, 0x0000001033187825ULL, 0x040fe200078e0018ULL,
0x0000000016137faeULL, 0x000fe6000b901c4aULL, 0x00000010331a7825ULL, 0x000fc800078e001aULL,
0x00000010331c7825ULL, 0x000fe200078e001cULL, 0x0000000f12037c11ULL, 0x002fc6000f8e20ffULL,
0x00000010331e7825ULL, 0x000fc800078e001eULL, 0x0000001033207825ULL, 0x000fc800078e0020ULL,
0x0000001033227825ULL, 0x000fc800078e0022ULL, 0x0000001033247825ULL, 0x000fc800078e0024ULL,
0x0000001033267825ULL, 0x000fc800078e0026ULL, 0x0000001033287825ULL, 0x000fc800078e0028ULL,
0x00000010332a7825ULL, 0x000fc800078e002aULL, 0x00000010332c7825ULL, 0x000fc800078e002cULL,
0x00000010332e7825ULL, 0x000fc800078e002eULL, 0x0000001033307825ULL, 0x000fe200078e0030ULL,
0x0000000f02337c11ULL, 0x000fca000f8e20ffULL, 0x0000000018337faeULL, 0x000fe8000b901c4aULL,
0x000000001a357faeULL, 0x000fe8000b901c4aULL, 0x000000001c0b7faeULL, 0x0003e8000b901c4aULL,
0x000000001e377faeULL, 0x0005e8000b901c4aULL, 0x0000000020097faeULL, 0x0005e8000b901c4aULL,
0x0000000022397faeULL, 0x0005e2000b901c4aULL, 0x0000000f100b7c11ULL, 0x002fc6000f8e20ffULL,
0x0000000024077faeULL, 0x0005e8000b901c4aULL, 0x00000000263b7faeULL, 0x0005e8000b901c4aULL,
0x0000000028057faeULL, 0x0005e8000b901c4aULL, 0x000000002a117faeULL, 0x0005e8000b901c4aULL,
0x000000002c037faeULL, 0x0005e8000b901c4aULL, 0x000000002e0b7faeULL, 0x0005e8000b901c4aULL,
0x00000000300d7faeULL, 0x0005e4000b901c4aULL, 0x00000004ff037819ULL, 0x106fe20000011670ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000003ff047819ULL, 0x000fe20000011670ULL,
0x0000200008087890ULL, 0x000fe2000fffe03fULL, 0x0000000800027812ULL, 0x000fe200078ef870ULL,
0x0000000803057824ULL, 0x000fe200078e00ffULL, 0x0000000104097812ULL, 0x000fc600078ec0ffULL,
0x0000000102037824ULL, 0x040fe200078e0203ULL, 0xfffffff805327812ULL, 0x000fe200078ee200ULL,
0x0000002002047824ULL, 0x040fe400078e00ffULL, 0x00000020020b7824ULL, 0x000fe200078e00ffULL,
0x0000003209317210ULL, 0x000fe20007ffe0ffULL, 0x00000008323e7824ULL, 0x040fe200078e00ffULL,
0xffffffe004047812ULL, 0x000fe200078ee203ULL, 0x00000008320a7824ULL, 0x000fe200078e00ffULL,
0x0000000231717810ULL, 0x000fe20007ffe0ffULL, 0x0000001032307836ULL, 0x000fe20000000000ULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee231ULL, 0x00000020320d7836ULL, 0x000fe20000000000ULL,
0x0000000604047c11ULL, 0x000fe2000f8e20ffULL, 0x00000001096c7824ULL, 0x000fe200078e0230ULL,
0x000000083e087c11ULL, 0x000fe2000f8e20ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000000404783bULL, 0x000fe20000000200ULL, 0xfffffff80a717812ULL, 0x000fe200078ee271ULL,
0x0000000830157824ULL, 0x000fe200078e00ffULL, 0x0000000d09667210ULL, 0x000fe20007ffe0ffULL,
0x000000000810783bULL, 0x000e620000000200ULL, 0x00000008710c7c11ULL, 0x000fe2000f8e20ffULL,
0x00000022311c7836ULL, 0x000fe20000000000ULL, 0x0000001231727810ULL, 0x000fe20007ffe0ffULL,
0x0000400801007387ULL, 0x0005e20000100800ULL, 0x000000080d1d7824ULL, 0x040fe400078e00ffULL,
0xfffffff815727812ULL, 0x000fe200078ee272ULL, 0x0000640c01007387ULL, 0x000fe20000100800ULL,
0x0000003231337836ULL, 0x000fe20000000000ULL, 0xfffffff81d1c7812ULL, 0x000fe200078ee21cULL,
0x000000080d3a7824ULL, 0x000fe200078e00ffULL, 0x000000000c18783bULL, 0x0007e20000000200ULL,
0x0000000203087836ULL, 0x004fe20000000000ULL, 0x000000081c1e7c11ULL, 0x000fc8000f8e20ffULL,
0xffffffe00b087812ULL, 0x000fe200078ee208ULL, 0x00000008300b7824ULL, 0x000fe400078e00ffULL,
0x00000030320c7836ULL, 0x008fe20000000000ULL, 0x0000000608087c11ULL, 0x000fe4000f8e20ffULL,
0xfffffff80b6c7812ULL, 0x000fe200078ee26cULL, 0x000000080d0b7824ULL, 0x000fe200078e00ffULL,
0x000000030c387819ULL, 0x000fe200000006ffULL, 0x000000000844783bULL, 0x0004e20000000200ULL,
0x00000001095d7824ULL, 0x000fc400078e020cULL, 0x000000080c0a7824ULL, 0x000fe200078e00ffULL,
0xfffffff80b667812ULL, 0x000fe400078ee266ULL, 0xfffffff838397812ULL, 0x000fe200078ee233ULL,
0x0000000830387824ULL, 0x000fe200078e00ffULL, 0x000000086c087c11ULL, 0x004fe4000f8e20ffULL,
0xfffffff80a5d7812ULL, 0x000fe200078ee25dULL, 0x000000100434723cULL, 0x002fe400000418ffULL,
0x0000440801007387ULL, 0x000fe20000100800ULL, 0x000000085d147c11ULL, 0x000fc4000f8e20ffULL,
0x000000030c337819ULL, 0x000fe200000006ffULL, 0x000000000828783bULL, 0x0003e20000000200ULL,
0x000000120410723cULL, 0x000fe200000418ffULL, 0x0000000330307819ULL, 0x000fe200000006ffULL,
0x000000080c0c7824ULL, 0x000fe200078e00ffULL, 0x000000001420783bULL, 0x000ea20000000200ULL,
0x0000000866087c11ULL, 0x002fca000f8e20ffULL, 0x0000500801007387ULL, 0x000fe80000100800ULL,
0x000000000808783bULL, 0x000e680000000200ULL, 0x0000581401007387ULL, 0x0009e20000100800ULL,
0x000000184434723cULL, 0x008fec0000041834ULL, 0x0000001a4418723cULL, 0x000fe20000041810ULL,
0x0000000872147c11ULL, 0x010fe2000f8e20ffULL, 0x000000001e10783bULL, 0x000fe80000000200ULL,
0x0000841401007387ULL, 0x000fe80000100800ULL, 0x000000001414783bULL, 0x000ee80000000200ULL,
0x0000141c01007387ULL, 0x000fe20000100800ULL, 0x00000020042c723cULL, 0x004fe600000418ffULL,
0x0000781e01007387ULL, 0x0005e80000100800ULL, 0x0000000839207c11ULL, 0x000fe2000f8e20ffULL,
0x0000183901007387ULL, 0x0009e20000100800ULL, 0x000000080424723cULL, 0x002fe600000418ffULL,
0x0000702001007387ULL, 0x000fe60000100800ULL, 0x00000028041c723cULL, 0x004fec00000418ffULL,
0x0000002a0428723cULL, 0x000fec00000418ffULL, 0x0000000a0408723cULL, 0x000fec00000418ffULL,
0x000000220404723cULL, 0x000fe200000418ffULL, 0x000000002020783bULL, 0x000e6a0000000200ULL,
0x00000014441c723cULL, 0x008fec000004181cULL, 0x000000164414723cULL, 0x000fec0000041828ULL,
0x000000104424723cULL, 0x000fe20000041824ULL, 0x0000002002297824ULL, 0x000fc400078e00ffULL,
0x0000000403287836ULL, 0x000fe40000000000ULL, 0x00000008322b7824ULL, 0x040fe400078e00ffULL,
0x0000000431107836ULL, 0x000fe20000000000ULL, 0xffffffe029287812ULL, 0x000fe200078ee228ULL,
0x0000002431297836ULL, 0x000fe20000000000ULL, 0x0000001431117810ULL, 0x000fe20007ffe0ffULL,
0x00000034312a7836ULL, 0x000fe20000000000ULL, 0xfffffff82b3b7812ULL, 0x000fe200078ee210ULL,
0x0000000832327824ULL, 0x000fe200078e00ffULL, 0xfffffff8383d7812ULL, 0x000fe200078ee211ULL,
0x00000020022b7824ULL, 0x000fe200078e00ffULL, 0xfffffff83a3c7812ULL, 0x000fe200078ee229ULL,
0x000000124410723cULL, 0x000fe20000041808ULL, 0xfffffff833397812ULL, 0x010fe200078ee22aULL,
0x00001c3b01007387ULL, 0x0005e20000100800ULL, 0x000000083d297c11ULL, 0x000fc4000f8e20ffULL,
0x000000083c337c11ULL, 0x000fe2000f8e20ffULL, 0x0000203d01007387ULL, 0x000fe20000100800ULL,
0x0000000628087c11ULL, 0x000fe2000f8e20ffULL, 0x00000020442c723cULL, 0x002fe2000004182cULL,
0x00000008392a7c11ULL, 0x000fe2000f8e20ffULL, 0x00000000294c783bULL, 0x000fe20000000200ULL,
0x0000000603287836ULL, 0x000fe20000000000ULL, 0x000000083b3b7c11ULL, 0x004fe4000f8e20ffULL,
0x000000000808783bULL, 0x000e620000000200ULL, 0x000000080d217824ULL, 0x000fe200078e00ffULL,
0xffffffe02b287812ULL, 0x000fe200078ee228ULL, 0x00000016310d7836ULL, 0x000fe20000000000ULL,
0x000000003b50783bULL, 0x000ea20000000200ULL, 0x0000002631207836ULL, 0x000fe20000000000ULL,
0x000000224444723cULL, 0x000fe20000041804ULL, 0x0000000628387c11ULL, 0x000fe2000f8e20ffULL,
0x000000003348783bULL, 0x000ee80000000200ULL, 0x000000002a40783bULL, 0x000f280000000200ULL,
0x0000243c01007387ULL, 0x000fe80000100800ULL, 0x0000283901007387ULL, 0x000be80000100800ULL,
0x0000603b01007387ULL, 0x000fe80000100800ULL, 0x00006c2901007387ULL, 0x0003e20000100800ULL,
0xfffffff830397812ULL, 0x020fc600078ee20dULL, 0x0000803301007387ULL, 0x000be80000100800ULL,
0x0000882a01007387ULL, 0x0005e20000100800ULL, 0x0000000631297836ULL, 0x002fe20000000000ULL,
0x0000003631317810ULL, 0x000fe20007ffe0ffULL, 0x0000004c081c723cULL, 0x000fe2000004181cULL,
0xfffffff821337812ULL, 0x020fe400078ee220ULL, 0xfffffff832297812ULL, 0x000fc400078ee229ULL,
0xfffffff80c2a7812ULL, 0x004fe200078ee231ULL, 0x000000500834723cULL, 0x000fe20000041834ULL,
0x00000008292b7c11ULL, 0x000fe2000f8e20ffULL, 0x00002c2901007387ULL, 0x000fe20000100800ULL,
0x00000008390c7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000833057c11ULL, 0x000fe2000f8e20ffULL,
0x0000303901007387ULL, 0x000fe20000100800ULL, 0x000000082a047c11ULL, 0x000fe2000f8e20ffULL,
0x000000480824723cULL, 0x008fe40000041824ULL, 0x0000343301007387ULL, 0x000fe80000100800ULL,
0x0000382a01007387ULL, 0x000fe20000100800ULL, 0x000000520818723cULL, 0x000fe60000041818ULL,
0x0000902b01007387ULL, 0x000fe60000100800ULL, 0x0000004e0814723cULL, 0x000fe20000041814ULL,
0x00008c0c01007387ULL, 0x000fe80000100800ULL, 0x000000002b30783bULL, 0x000fe20000000200ULL,
0x0000004a0810723cULL, 0x000fe60000041810ULL, 0x0000940501007387ULL, 0x000fe60000100800ULL,
0x00000040082c723cULL, 0x010fe2000004182cULL, 0x000000003838783bULL, 0x000e680000000200ULL,
0x000000000c20783bULL, 0x000ea20000000200ULL, 0x000000420808723cULL, 0x000fe20000041844ULL,
0x00000003ff417819ULL, 0x000fc40000011670ULL, 0x000000000528783bULL, 0x000ee80000000200ULL,
0x0000980401007387ULL, 0x000fe80000100800ULL, 0x000000000404783bULL, 0x000f220000000200ULL,
0x000000303834723cULL, 0x002fec0000041834ULL, 0x00000020381c723cULL, 0x004fec000004181cULL,
0x000000283824723cULL, 0x008fec0000041824ULL, 0x000000323830723cULL, 0x000fec0000041818ULL,
0x000000223820723cULL, 0x000fec0000041814ULL, 0x0000002a3828723cULL, 0x000fec0000041810ULL,
0x00000004382c723cULL, 0x010fec000004182cULL, 0x000000063838723cULL, 0x000fe20000041808ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000800a48947ULL, 0x000fde0003800000ULL,
0x0000000141077824ULL, 0x140fe200078e0270ULL, 0x80000009110c7290ULL, 0x000fe2000fffe03fULL,
0x0000000c41067836ULL, 0x000fe20000000000ULL, 0x00000010003f7812ULL, 0x000fe200078efcffULL,
0x0000000441047836ULL, 0x000fe20000000000ULL, 0x000000076a6a7812ULL, 0x000fe200078ef807ULL,
0x0000000806097824ULL, 0x000fe200078e00ffULL, 0x0000001041077810ULL, 0x000fe20007ffe0ffULL,
0x00000001046d7824ULL, 0x140fe200078e0270ULL, 0x00000070066e7210ULL, 0x000fe20007ffe0ffULL,
0x0000000804087824ULL, 0x000fe200078e00ffULL, 0x0000000c41007c0cULL, 0x000fe2000bf26070ULL,
0x00000001076b7824ULL, 0x140fe200078e0270ULL, 0xfffffff8096e7812ULL, 0x000fe200078ee26eULL,
0x00000008070c7824ULL, 0x000fe200078e00ffULL, 0xfffffff8086d7812ULL, 0x000fe200078ee26dULL,
0x0000001441087836ULL, 0x000fe20000000000ULL, 0x0000001841097810ULL, 0x000fe20007ffe0ffULL,
0x0000001341557c36ULL, 0x000fe20008000000ULL, 0xfffffff80c6b7812ULL, 0x000fe200078ee26bULL,
0x0000000841057836ULL, 0x000fe20000000000ULL, 0x0000007009687210ULL, 0x000fe20007ffe0ffULL,
0x0000000108697824ULL, 0x000fe200078e0270ULL, 0x000000086a147c11ULL, 0x000fe2000f8e20ffULL,
0x00000008080c7824ULL, 0x000fe200078e00ffULL, 0x0000001305517c10ULL, 0x000fe2000fffe0ffULL,
0x00000008090d7824ULL, 0x000fe200078e00ffULL, 0x0000003041587810ULL, 0x000fe20007ffe0ffULL,
0x0000020055547825ULL, 0x000fe200078e000eULL, 0xfffffff80c697812ULL, 0x000fe200078ee269ULL,
0x0000101401007387ULL, 0x0003e20000100800ULL, 0xfffffff80d687812ULL, 0x000fe200078ee268ULL,
0x00000001056f7824ULL, 0x040fe200078e0270ULL, 0x0000000c05007c0cULL, 0x040fe2000bf46070ULL,
0x00000008050a7824ULL, 0x000fe200078e00ffULL, 0x0000000c06007c0cULL, 0x000fe2000bf66070ULL,
0x000000103f0c7825ULL, 0x000fe200078e0054ULL, 0x000000086d1b7c11ULL, 0x000fc4000f8e20ffULL,
0xfffffff80a6f7812ULL, 0x000fe200078ee26fULL, 0x0000001c410a7836ULL, 0x000fe20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c147faeULL, 0x0005e2000c901c4aULL,
0x00000020410b7836ULL, 0x000fe20000000000ULL, 0x0000000c04007c0cULL, 0x000fe2000bf26070ULL,
0x0000001304537c36ULL, 0x000fe20008000000ULL, 0x0000000c07007c0cULL, 0x000fe2000bf86070ULL,
0x000000010a677824ULL, 0x140fe200078e0270ULL, 0x000000030b127819ULL, 0x040fe200000006ffULL,
0x000000080a107824ULL, 0x000fe200078e00ffULL, 0x0000000c08007c0cULL, 0x000fe2000bfa6070ULL,
0x000000010b657824ULL, 0x000fe200078e0270ULL, 0x000000086f1a7c11ULL, 0x000fe2000f8e20ffULL,
0x0000020053527825ULL, 0x000fe200078e000eULL, 0xfffffff810677812ULL, 0x000fe200078ee267ULL,
0x00000c1b01007387ULL, 0x000fe20000100800ULL, 0xfffffff812657812ULL, 0x000fe200078ee265ULL,
0x00000024415b7836ULL, 0x000fe20000000000ULL, 0x000000086e197c11ULL, 0x000fe2000f8e20ffULL,
0x00000028415a7836ULL, 0x000fe20000000000ULL, 0x000000130a477c10ULL, 0x000fe2000fffe0ffULL,
0x0000002c41597836ULL, 0x000fe20000000000ULL, 0x000000086b187c11ULL, 0x000fe2000f8e20ffULL,
0x00000013064f7c36ULL, 0x000fe20008000000ULL, 0x00000008697d7c11ULL, 0x000fe2000f8e20ffULL,
0x000000015b647824ULL, 0x140fe200078e0270ULL, 0x0000007059627210ULL, 0x000fe20007ffe0ffULL,
0x000000085b117824ULL, 0x000fe200078e00ffULL, 0x00000008687c7c11ULL, 0x000fe2000f8e20ffULL,
0x000000015a637824ULL, 0x040fe200078e0270ULL, 0x00000008677b7c11ULL, 0x000fe2000f8e20ffULL,
0x000000085a107824ULL, 0x000fe200078e00ffULL, 0xfffffff811647812ULL, 0x000fe200078ee264ULL,
0x0000020051507825ULL, 0x000fe200078e000eULL, 0x00000008657a7c11ULL, 0x000fe2000f8e20ffULL,
0x0000081a01007387ULL, 0x000fe20000100800ULL, 0xfffffff810637812ULL, 0x000fe200078ee263ULL,
0x0000000859137824ULL, 0x000fe200078e00ffULL, 0x0000000864797c11ULL, 0x000fe2000f8e20ffULL,
0x0000000158617824ULL, 0x040fe200078e0270ULL, 0x0000041901007387ULL, 0x000fe20000100800ULL,
0x0000000858127824ULL, 0x000fe200078e00ffULL, 0xfffffff813627812ULL, 0x000fe200078ee262ULL,
0x000002004f4e7825ULL, 0x000fe200078e000eULL, 0x0000001801007387ULL, 0x0007e20000100800ULL,
0x0000000863787c11ULL, 0x000fc4000f8e20ffULL, 0x000000103f0c7825ULL, 0x004fe200078e0052ULL,
0xfffffff812617812ULL, 0x000fe400078ee261ULL, 0x0000000862777c11ULL, 0x000fe2000f8e20ffULL,
0x00000013074d7c36ULL, 0x000fe20008000000ULL, 0x000000000c1b7faeULL, 0x000fe2000c901c4aULL,
0x00000013084b7c36ULL, 0x000fe20008000000ULL, 0x0000000c09007c0cULL, 0x000fe2000bf26070ULL,
0x0000001309497c36ULL, 0x000fe20008000000ULL, 0x0000000861767c11ULL, 0x000fe2000f8e20ffULL,
0x000000103f107825ULL, 0x000fc800078e0050ULL, 0x000002004d4c7825ULL, 0x000fe200078e000eULL,
0x00000000101a7faeULL, 0x000fe2000d101c4aULL, 0x0000000c0a007c0cULL, 0x000fe4000bf46070ULL,
0x000000103f127825ULL, 0x000fc800078e004eULL, 0x000002004b4a7825ULL, 0x100fe200078e000eULL,
0x0000000012197faeULL, 0x0005e2000d901c4aULL, 0x0000000c0b007c0cULL, 0x000fe4000bf66070ULL,
0x0000020049487825ULL, 0x000fc800078e000eULL, 0x000000130b457c36ULL, 0x000fe40008000000ULL,
0x000000103f147825ULL, 0x002fc800078e004cULL, 0x000000103f167825ULL, 0x000fe200078e004aULL,
0x0000000014187faeULL, 0x000fe2000e101c4aULL, 0x0000000c5b007c0cULL, 0x000fe4000bf86070ULL,
0x0000020047467825ULL, 0x000fe200078e000eULL, 0x00000000167d7faeULL, 0x0003e6000e901c4aULL,
0x000000103f127825ULL, 0x004fc800078e0048ULL, 0x0000020045447825ULL, 0x000fe200078e000eULL,
0x00000000127c7faeULL, 0x0005e2000c901c4aULL, 0x0000000c5a007c0cULL, 0x000fe4000bf26070ULL,
0x000000135b107c36ULL, 0x000fe20008000000ULL, 0x0000001358167c10ULL, 0x002fe2000fffe0ffULL,
0x000000103f0c7825ULL, 0x000fc800078e0046ULL, 0x0000020010107825ULL, 0x000fe200078e000eULL,
0x000000000c7b7faeULL, 0x0003e2000d101c4aULL, 0x0000000c59007c0cULL, 0x000fe4000bf46070ULL,
0x000000103f127825ULL, 0x004fc800078e0044ULL, 0x000000135a157c36ULL, 0x000fe20008000000ULL,
0x00000000127a7faeULL, 0x0005e2000d901c4aULL, 0x0000001359147c36ULL, 0x000fe20008000000ULL,
0x0000000c58007c0cULL, 0x000fe2000bf66070ULL, 0x0000020016167825ULL, 0x000fc800078e000eULL,
0x000000103f0c7825ULL, 0x002fc800078e0010ULL, 0x0000003c415c7836ULL, 0x000fe20000000000ULL,
0x000000000c797faeULL, 0x0003e2000e101c4aULL, 0x0000020015127825ULL, 0x004fc600078e000eULL,
0x000000705c5e7210ULL, 0x000fe20007ffe0ffULL, 0x0000020014147825ULL, 0x000fc800078e000eULL,
0x000000103f187825ULL, 0x008fc800078e0012ULL, 0x000000103f0c7825ULL, 0x002fe200078e0014ULL,
0x0000000018787faeULL, 0x0003e6000c901c4aULL, 0x000000135c567c36ULL, 0x000fe20008000000ULL,
0x000000000c777faeULL, 0x0005e6000d101c4aULL, 0x0000020056567825ULL, 0x000fc800078e000eULL,
0x000000103f187825ULL, 0x002fc800078e0016ULL, 0x00000034410c7836ULL, 0x004fe20000000000ULL,
0x0000000018767faeULL, 0x0003e6000d901c4aULL, 0x000000010c607824ULL, 0x040fe200078e0270ULL,
0x0000000c0c007c0cULL, 0x040fe2000bf26070ULL, 0x000000080c0d7824ULL, 0x000fca00078e00ffULL,
0xfffffff80d607812ULL, 0x000fe200078ee260ULL, 0x000000130c187c36ULL, 0x002fe20008000000ULL,
0x00000038410d7810ULL, 0x000fe40007ffe0ffULL, 0x0000000860757c11ULL, 0x000fe2000f8e20ffULL,
0x0000020018187825ULL, 0x000fc800078e000eULL, 0x000000010d5f7824ULL, 0x000fe400078e0270ULL,
0x000000103f1a7825ULL, 0x000fca00078e0018ULL, 0x000000001a757faeULL, 0x0003e2000c901c4aULL,
0x0000000c0d007c0cULL, 0x040fe2000bf26070ULL, 0x000000080d1a7824ULL, 0x002fca00078e00ffULL,
0xfffffff81a5f7812ULL, 0x000fe200078ee25fULL, 0x000000130d1a7c36ULL, 0x000fc60008000000ULL,
0x000000085f747c11ULL, 0x000fe2000f8e20ffULL, 0x000002001a1a7825ULL, 0x000fc800078e000eULL,
0x000000103f3c7825ULL, 0x000fca00078e001aULL, 0x000000003c747faeULL, 0x0003e2000c901c4aULL,
0x0000000c5c007c0cULL, 0x040fe2000bf26070ULL, 0x000000085c3c7824ULL, 0x002fca00078e00ffULL,
0xfffffff83c5e7812ULL, 0x000fe200078ee25eULL, 0x000000103f3c7825ULL, 0x000fc600078e0056ULL,
0x000000085e737c11ULL, 0x000fca000f8e20ffULL, 0x000000003c737faeULL, 0x0003e2000c901c4aULL,
0x00000008005c7947ULL, 0x000fea0003800000ULL, 0x0000000441047836ULL, 0x000fe20000000000ULL,
0x00000010003f7812ULL, 0x000fe200078efcffULL, 0x0000000141057824ULL, 0x100fe200078e0270ULL,
0x0000002c41597810ULL, 0x000fe20007ffe0ffULL, 0x0000000804067824ULL, 0x000fe200078e00ffULL,
0x00000070046d7210ULL, 0x000fe20007ffe0ffULL, 0x0000001041077836ULL, 0x000fe20000000000ULL,
0x000000076a6a7812ULL, 0x000fe200078ef805ULL, 0x0000000841057836ULL, 0x000fe20000000000ULL,
0xfffffff8066d7812ULL, 0x000fe200078ee26dULL, 0x0000000c41067836ULL, 0x000fe20000000000ULL,
0x00000003070a7819ULL, 0x000fe200000006ffULL, 0x0000000805087824ULL, 0x000fe200078e00ffULL,
0x00000070056f7210ULL, 0x000fe20007ffe0ffULL, 0x00000001066e7824ULL, 0x100fe200078e0270ULL,
0x000000086a127c11ULL, 0x000fe2000f8e20ffULL, 0x0000000806097824ULL, 0x000fe200078e00ffULL,
0xfffffff8086f7812ULL, 0x000fe200078ee26fULL, 0x00000001076b7824ULL, 0x100fe200078e0270ULL,
0x000000086d137c11ULL, 0x000fe2000f8e20ffULL, 0x0000001441087836ULL, 0x000fe20000000000ULL,
0xfffffff8096e7812ULL, 0x000fe200078ee26eULL, 0x0000001841097836ULL, 0x000fe20000000000ULL,
0xfffffff80a6b7812ULL, 0x000fe200078ee26bULL, 0x0000001c410a7836ULL, 0x000fe20000000000ULL,
0x00000003080c7819ULL, 0x040fe200000006ffULL, 0x0000000109687824ULL, 0x140fe200078e0270ULL,
0x0000101201007387ULL, 0x0003e20000100800ULL, 0x00000008090b7824ULL, 0x000fe200078e00ffULL,
0x00000013084b7c10ULL, 0x000fe2000fffe0ffULL, 0x0000000108697824ULL, 0x100fe200078e0270ULL,
0x00000c1301007387ULL, 0x0005e20000100800ULL, 0x000000010a677824ULL, 0x140fe200078e0270ULL,
0xfffffff80b687812ULL, 0x000fe200078ee268ULL, 0x000000080a107824ULL, 0x000fe200078e00ffULL,
0x00000020410b7810ULL, 0x000fe20007ffe0ffULL, 0x00000024415b7836ULL, 0x000fe20000000000ULL,
0xfffffff80c697812ULL, 0x000fe200078ee269ULL, 0x0000001341557c36ULL, 0x000fe20008000000ULL,
0xfffffff810677812ULL, 0x000fe200078ee267ULL, 0x00000028415a7836ULL, 0x000fe20000000000ULL,
0x000000705b647210ULL, 0x000fe20007ffe0ffULL, 0x000000010b657824ULL, 0x000fe200078e0270ULL,
0x00000008697d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000080b0c7824ULL, 0x000fe200078e00ffULL,
0x00000008687c7c11ULL, 0x000fe2000f8e20ffULL, 0x000000085b0d7824ULL, 0x000fe200078e00ffULL,
0x00000008677b7c11ULL, 0x000fe2000f8e20ffULL, 0x0000020055547825ULL, 0x000fe200078e000eULL,
0xfffffff80c657812ULL, 0x000fc400078ee265ULL, 0xfffffff80d647812ULL, 0x000fe200078ee264ULL,
0x000000015a637824ULL, 0x040fe200078e0270ULL, 0x00000008657a7c11ULL, 0x000fe2000f8e20ffULL,
0x000000085a107824ULL, 0x000fe200078e00ffULL, 0x0000000864797c11ULL, 0x000fe2000f8e20ffULL,
0x0000001304537c36ULL, 0x000fe40008000000ULL, 0x0000003041587836ULL, 0x000fe20000000000ULL,
0xfffffff810637812ULL, 0x000fe200078ee263ULL, 0x0000001305517c36ULL, 0x000fe40008000000ULL,
0x000000103f0c7825ULL, 0x000fe200078e0054ULL, 0x0000007058617210ULL, 0x000fc40007ffe0ffULL,
0x0000000863787c11ULL, 0x000fe2000f8e20ffULL, 0x0000020053527825ULL, 0x000fe200078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c127faeULL, 0x0003e6000b901c4aULL,
0x0000000159627824ULL, 0x040fe400078e0270ULL, 0x0000000859117824ULL, 0x000fe400078e00ffULL,
0x0000000858107824ULL, 0x000fe400078e00ffULL, 0x0000020051507825ULL, 0x000fe200078e000eULL,
0xfffffff811627812ULL, 0x000fc400078ee262ULL, 0xfffffff810617812ULL, 0x000fe200078ee261ULL,
0x00000013064f7c36ULL, 0x000fe20008000000ULL, 0x000000086f127c11ULL, 0x002fe2000f8e20ffULL,
0x00000013074d7c36ULL, 0x000fe20008000000ULL, 0x0000000862777c11ULL, 0x000fe2000f8e20ffULL,
0x000000103f0c7825ULL, 0x000fe200078e0052ULL, 0x0000000861767c11ULL, 0x000fe2000f8e20ffULL,
0x0000081201007387ULL, 0x0003e40000100800ULL, 0x000002004f4e7825ULL, 0x000fe400078e000eULL,
0x000000000c137faeULL, 0x0005e4000b901c4aULL, 0x000000103f107825ULL, 0x000fc800078e0050ULL,
0x000002004d4c7825ULL, 0x000fe200078e000eULL, 0x0000000010127faeULL, 0x0003e6000b901c4aULL,
0x0000001309497c36ULL, 0x000fe40008000000ULL, 0x000000130a477c36ULL, 0x000fe20008000000ULL,
0x000000086e137c11ULL, 0x004fe2000f8e20ffULL, 0x000000103f0c7825ULL, 0x000fc800078e004eULL,
0x000002004b4a7825ULL, 0x000fe200078e000eULL, 0x000000086b127c11ULL, 0x002fe2000f8e20ffULL,
0x0000041301007387ULL, 0x000fe40000100800ULL, 0x000000103f107825ULL, 0x000fe400078e004cULL,
0x000000000c137faeULL, 0x0003e4000b901c4aULL, 0x0000020049487825ULL, 0x100fe400078e000eULL,
0x0000001201007387ULL, 0x0005e40000100800ULL, 0x0000020047467825ULL, 0x000fc400078e000eULL,
0x0000000010127faeULL, 0x0005e4000b901c4aULL, 0x000000130b447c36ULL, 0x000fe40008000000ULL,
0x000000103f0c7825ULL, 0x002fc800078e0048ULL, 0x0000020044447825ULL, 0x000fc800078e000eULL,
0x000000103f127825ULL, 0x004fc800078e004aULL, 0x000000103f107825ULL, 0x000fe200078e0046ULL,
0x00000000127d7faeULL, 0x0003e6000b901c4aULL, 0x000000135b147c36ULL, 0x000fe20008000000ULL,
0x000000000c7c7faeULL, 0x000fe2000b901c4aULL, 0x0000001359177c36ULL, 0x000fe40008000000ULL,
0x0000001358167c36ULL, 0x000fe20008000000ULL, 0x00000000107b7faeULL, 0x0005e2000b901c4aULL,
0x0000003c415c7836ULL, 0x000fe20000000000ULL, 0x000000135a127c10ULL, 0x002fc6000fffe0ffULL,
0x000000135c567c36ULL, 0x000fe40008000000ULL, 0x000000015c5e7824ULL, 0x000fe400078e0270ULL,
0x0000020012127825ULL, 0x000fc800078e000eULL, 0x0000020014107825ULL, 0x004fc800078e000eULL,
0x000000103f147825ULL, 0x000fc800078e0044ULL, 0x000000103f0c7825ULL, 0x040fe200078e0010ULL,
0x00000000147a7faeULL, 0x0003e6000b901c4aULL, 0x000000103f187825ULL, 0x000fe200078e0012ULL,
0x000000000c797faeULL, 0x0005e6000b901c4aULL, 0x0000020056567825ULL, 0x100fe200078e000eULL,
0x0000000018787faeULL, 0x0007e6000b901c4aULL, 0x0000020017147825ULL, 0x002fc800078e000eULL,
0x0000020016167825ULL, 0x000fc800078e000eULL, 0x000000103f0c7825ULL, 0x004fc800078e0014ULL,
0x000000103f187825ULL, 0x008fe200078e0016ULL, 0x000000000c777faeULL, 0x0003e8000b901c4aULL,
0x0000000018767faeULL, 0x0005e2000b901c4aULL, 0x00000034410c7836ULL, 0x002fc80000000000ULL,
0x000000130c187c36ULL, 0x004fe20008000000ULL, 0x000000030c0d7819ULL, 0x040fe200000006ffULL,
0x000000010c607824ULL, 0x000fe400078e0270ULL, 0x0000020018187825ULL, 0x000fc600078e000eULL,
0xfffffff80d607812ULL, 0x000fe200078ee260ULL, 0x00000038410d7836ULL, 0x000fe40000000000ULL,
0x000000103f1a7825ULL, 0x000fe200078e0018ULL, 0x0000000860757c11ULL, 0x000fc6000f8e20ffULL,
0x000000010d5f7824ULL, 0x040fe400078e0270ULL, 0x000000001a757faeULL, 0x0003e4000b901c4aULL,
0x000000080d1b7824ULL, 0x002fe200078e00ffULL, 0x000000130d1a7c10ULL, 0x000fc8000fffe0ffULL,
0xfffffff81b5f7812ULL, 0x000fe200078ee25fULL, 0x000002001a1a7825ULL, 0x000fc600078e000eULL,
0x000000085f747c11ULL, 0x000fe2000f8e20ffULL, 0x000000103f3c7825ULL, 0x000fca00078e001aULL,
0x000000003c747faeULL, 0x0003e4000b901c4aULL, 0x000000085c3c7824ULL, 0x002fca00078e00ffULL,
0xfffffff83c5e7812ULL, 0x000fe200078ee25eULL, 0x000000103f3c7825ULL, 0x000fc600078e0056ULL,
0x000000085e737c11ULL, 0x000fca000f8e20ffULL, 0x000000003c737faeULL, 0x0003e4000b901c4aULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000020023d7824ULL, 0x002fe200078e00ffULL,
0x00000008033c7810ULL, 0x000fe40007ffe0ffULL, 0x0000000f3e407c11ULL, 0x000fe4000f8e20ffULL,
0xffffffe03d3c7812ULL, 0x000fc600078ee23cULL, 0x00007c4001007387ULL, 0x000fe20000100800ULL,
0x000000063c3c7c11ULL, 0x000fe2000f8e20ffULL, 0x000080400000791aULL, 0x000fca0000000000ULL,
0x000000003c3c783bULL, 0x000fe80000000200ULL, 0x000000004040783bULL, 0x000e640000000200ULL,
0x000000403c34723cULL, 0x002fec0000041834ULL, 0x000000423c30723cULL, 0x000fe20000041830ULL,
0x0000000f6c417c11ULL, 0x000fc4000f8e20ffULL, 0x00001800016c7983ULL, 0x000ea20000300800ULL,
0x0000000f66667c11ULL, 0x000fc6000f8e20ffULL, 0x0000744101007387ULL, 0x000fe80000100800ULL,
0x000000004140783bULL, 0x000e680000000200ULL, 0x0000686601007387ULL, 0x000fe20000100800ULL,
0x000000403c1c723cULL, 0x002fec000004181cULL, 0x000000423c20723cULL, 0x000fe20000041820ULL,
0x000000006640783bULL, 0x0002e40000000200ULL, 0x0000000f5d667c11ULL, 0x002fc4000f8e20ffULL,
0x00001400015d7983ULL, 0x000f280000300800ULL, 0x00005c6601007387ULL, 0x000fe20000100800ULL,
0x000000403c24723cULL, 0x008fec0000041824ULL, 0x000000423c28723cULL, 0x000fe20000041828ULL,
0x000000006640783bULL, 0x0002e80000000200ULL, 0x00001c0001667983ULL, 0x002f620000300800ULL,
0x0000000f71717c11ULL, 0x000fe2000f8e20ffULL, 0x000000403c2c723cULL, 0x008fec000004182cULL,
0x000000423c38723cULL, 0x000fe20000041838ULL, 0x000000007140783bULL, 0x000fec0000000200ULL,
0x0000000a033c7836ULL, 0x000fc40000000000ULL, 0x00000020023d7824ULL, 0x000fca00078e00ffULL,
0xffffffe03d3c7812ULL, 0x000fc800078ee23cULL, 0x000000063c3c7c11ULL, 0x000fcc000f8e20ffULL,
0x000000003c3c783bULL, 0x000e680000000200ULL, 0x0000547101007387ULL, 0x0007e40000100800ULL,
0x0000000f72717c11ULL, 0x008fe2000f8e20ffULL, 0x000000403c34723cULL, 0x002fec0000041834ULL,
0x000000423c30723cULL, 0x000fe20000041830ULL, 0x000000007140783bULL, 0x000e680000000200ULL,
0x00004c7101007387ULL, 0x000fe80000100800ULL, 0x0000280001727983ULL, 0x000ee20000300800ULL,
0x000000403c1c723cULL, 0x002fec000004181cULL, 0x000000423c20723cULL, 0x000fe20000041820ULL,
0x0000000f5d5d7c11ULL, 0x010fca000f8e20ffULL, 0x000000005d40783bULL, 0x000e680000000200ULL,
0x0000485d01007387ULL, 0x0005e40000100800ULL, 0x0000000f6c5d7c11ULL, 0x004fe2000f8e20ffULL,
0x000000403c24723cULL, 0x002fec0000041824ULL, 0x000000423c28723cULL, 0x000fe20000041828ULL,
0x000000005d40783bULL, 0x000e680000000200ULL, 0x00003c5d01007387ULL, 0x000be80000100800ULL,
0x00002c0001717983ULL, 0x000ea80000300800ULL, 0x00003000016c7983ULL, 0x000f220000300800ULL,
0x0000000f665d7c11ULL, 0x020fc6000f8e20ffULL, 0x0000340001667983ULL, 0x000f620000300800ULL,
0x000000403c2c723cULL, 0x002fec000004182cULL, 0x000000423c3c723cULL, 0x000fee0000041838ULL,
0x0000000c03387836ULL, 0x000fe20000000000ULL, 0x0000000502397819ULL, 0x000fc800000006ffULL,
0xffffffe039387812ULL, 0x000fc800078ee238ULL, 0x0000000638387c11ULL, 0x000fca000f8e20ffULL,
0x000000003840783bULL, 0x000fe80000000200ULL, 0x000000005d38783bULL, 0x000e680000000200ULL,
0x00001c5d01007387ULL, 0x0007e80000100800ULL, 0x00003800015d7983ULL, 0x008ee20000300800ULL,
0x000000384034723cULL, 0x002fec0000041834ULL, 0x0000003a4038723cULL, 0x000fe20000041830ULL,
0x0000200001337983ULL, 0x000eac0000300800ULL, 0x0000000f33337c11ULL, 0x004fca000f8e20ffULL,
0x0000183301007387ULL, 0x000fe80000100800ULL, 0x000000003330783bULL, 0x000e640000000200ULL,
0x00000030401c723cULL, 0x002fec000004181cULL, 0x000000324030723cULL, 0x000fe20000041820ULL,
0x0000240001237983ULL, 0x000ea20000300800ULL, 0x0000000f72727c11ULL, 0x000fc4000f8e20ffULL,
0x0000000f71717c11ULL, 0x000fe4000f8e20ffULL, 0x0000000f6c6c7c11ULL, 0x010fe4000f8e20ffULL,
0x0000000f66667c11ULL, 0x020fe4000f8e20ffULL, 0x0000000f5d5d7c11ULL, 0x008fe4000f8e20ffULL,
0x0000000f23237c11ULL, 0x004fca000f8e20ffULL, 0x0000142301007387ULL, 0x000fe80000100800ULL,
0x000000002320783bULL, 0x000e640000000200ULL, 0x000000204024723cULL, 0x002fec0000041824ULL,
0x000000224028723cULL, 0x000fe20000041828ULL, 0x000000007220783bULL, 0x000e6a0000000200ULL,
0x00000020402c723cULL, 0x002fee000004182cULL, 0x0000000e03207836ULL, 0x000fc40000000000ULL,
0x0000002002217824ULL, 0x000fe200078e00ffULL, 0x00000022403c723cULL, 0x000fe8000004183cULL,
0xffffffe021207812ULL, 0x000fc800078ee220ULL, 0x0000000620407c11ULL, 0x000fe4000f8e20ffULL,
0x000000007120783bULL, 0x000fe80000000200ULL, 0x000000004040783bULL, 0x000e640000000200ULL,
0x000000204034723cULL, 0x002fec0000041834ULL, 0x000000224038723cULL, 0x000fe20000041838ULL,
0x000000006c20783bULL, 0x000e6a0000000200ULL, 0x00000020401c723cULL, 0x002fec000004181cULL,
0x000000224030723cULL, 0x000fe20000041830ULL, 0x000000006620783bULL, 0x000e6a0000000200ULL,
0x000000204024723cULL, 0x002fec0000041824ULL, 0x000000224028723cULL, 0x000fe20000041828ULL,
0x000000005d20783bULL, 0x000e6a0000000200ULL, 0x00000020402c723cULL, 0x002fec000004182cULL,
0x00000022403c723cULL, 0x000fe2000004183cULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x00000004001c8947ULL, 0x000fde0003800000ULL, 0x8000000911087290ULL, 0x000fe2000fffe03fULL,
0x00000003ff217819ULL, 0x000fe40000011670ULL, 0x0000001800207812ULL, 0x000fe400078efcffULL,
0x0000000f6a6a7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000821007c0cULL, 0x000fe2000bf06070ULL,
0x0000001020547825ULL, 0x040fe200078e0054ULL, 0x0000000f6d6d7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000f6f6f7c11ULL, 0x000fe2000f8e20ffULL, 0x0000001020527825ULL, 0x000fe200078e0052ULL,
0x0000000f6e6e7c11ULL, 0x000fc4000f8e20ffULL, 0x0000000f6b6b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000001020507825ULL, 0x000fe200078e0050ULL, 0x0000000808007c0cULL, 0x000fe4000bf26070ULL,
0x000000080a007c0cULL, 0x000fe2000bf46070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000546a7faeULL, 0x0003e2000c101c4aULL, 0x0000000804007c0cULL, 0x000fe2000bf06070ULL,
0x00000010204e7825ULL, 0x040fe200078e004eULL, 0x000000080b007c0cULL, 0x000fe4000bf66070ULL,
0x0000000f69697c11ULL, 0x000fe2000f8e20ffULL, 0x00000010204c7825ULL, 0x000fe200078e004cULL,
0x0000000f68687c11ULL, 0x000fc4000f8e20ffULL, 0x0000000f67677c11ULL, 0x000fe2000f8e20ffULL,
0x00000010204a7825ULL, 0x000fe200078e004aULL, 0x0000000f65657c11ULL, 0x000fe4000f8e20ffULL,
0x000000080c007c0cULL, 0x000fe2000bf86070ULL, 0x00000000526d7faeULL, 0x0003e2000c101c4aULL,
0x0000000805007c0cULL, 0x000fe2000bf06070ULL, 0x0000001020487825ULL, 0x000fe200078e0048ULL,
0x000000080d007c0cULL, 0x000fe4000bfa6070ULL, 0x000000085c007c0cULL, 0x000fe2000bfc6070ULL,
0x0000001020467825ULL, 0x000fe200078e0046ULL, 0x0000000f64647c11ULL, 0x000fc4000f8e20ffULL,
0x0000000f63637c11ULL, 0x000fe2000f8e20ffULL, 0x0000001020447825ULL, 0x000fe200078e0044ULL,
0x0000000f62237c11ULL, 0x000fe4000f8e20ffULL, 0x0000000f61617c11ULL, 0x000fe2000f8e20ffULL,
0x00000000506f7faeULL, 0x0003e2000c101c4aULL, 0x0000000806007c0cULL, 0x000fe2000bf06070ULL,
0x0000001020107825ULL, 0x000fe200078e0010ULL, 0x0000000f60417c11ULL, 0x000fe4000f8e20ffULL,
0x0000000f5f5f7c11ULL, 0x000fe2000f8e20ffULL, 0x0000001020127825ULL, 0x000fe200078e0012ULL,
0x0000000f5e437c11ULL, 0x000fc6000f8e20ffULL, 0x0000001020147825ULL, 0x000fc800078e0014ULL,
0x000000004e6e7faeULL, 0x0003e2000c101c4aULL, 0x0000000807007c0cULL, 0x000fe2000bf06070ULL,
0x0000001020167825ULL, 0x000fc800078e0016ULL, 0x0000001020187825ULL, 0x000fc800078e0018ULL,
0x00000010201a7825ULL, 0x000fc800078e001aULL, 0x000000004c6b7faeULL, 0x0003e2000c101c4aULL,
0x0000000809007c0cULL, 0x000fe2000bf06070ULL, 0x0000001020207825ULL, 0x000fe400078e0056ULL,
0x000000004a697faeULL, 0x0003e2000c901c4aULL, 0x000000085a007c0cULL, 0x000fd2000bf26070ULL,
0x0000000048687faeULL, 0x0003e2000c101c4aULL, 0x000000085b007c0cULL, 0x000fc6000bf06070ULL,
0x0000000046677faeULL, 0x0003e2000d101c4aULL, 0x0000000859007c0cULL, 0x000fc6000bf46070ULL,
0x0000000044657faeULL, 0x0003e2000d901c4aULL, 0x0000000858007c0cULL, 0x000fca000bf66070ULL,
0x0000000010647faeULL, 0x0003e8000c101c4aULL, 0x0000000012637faeULL, 0x0003e8000c901c4aULL,
0x0000000014237faeULL, 0x0003e8000d101c4aULL, 0x0000000016617faeULL, 0x0003e8000d901c4aULL,
0x0000000018417faeULL, 0x0003e8000e101c4aULL, 0x000000001a5f7faeULL, 0x0003e8000e901c4aULL,
0x0000000020437faeULL, 0x0003e2000f101c4aULL, 0x0000000000d07947ULL, 0x000fea0003800000ULL,
0x0000001800207812ULL, 0x000fe400078efcffULL, 0x0000000f6a6a7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000f6d6d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000001020547825ULL, 0x000fe200078e0054ULL,
0x0000000f6f6f7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000f6e6e7c11ULL, 0x000fe2000f8e20ffULL,
0x0000001020527825ULL, 0x040fe200078e0052ULL, 0x0000000f6b6b7c11ULL, 0x000fe2000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000546a7faeULL, 0x0003e2000b901c4aULL,
0x0000000f69697c11ULL, 0x000fe2000f8e20ffULL, 0x0000001020507825ULL, 0x000fe200078e0050ULL,
0x0000000f68687c11ULL, 0x000fe2000f8e20ffULL, 0x00000000526d7faeULL, 0x0003e2000b901c4aULL,
0x0000000f67677c11ULL, 0x000fe2000f8e20ffULL, 0x00000010204e7825ULL, 0x000fe200078e004eULL,
0x0000000f65657c11ULL, 0x000fe2000f8e20ffULL, 0x00000000506f7faeULL, 0x0003e2000b901c4aULL,
0x0000000f64647c11ULL, 0x000fe2000f8e20ffULL, 0x00000010204c7825ULL, 0x000fe200078e004cULL,
0x0000000f63637c11ULL, 0x000fe2000f8e20ffULL, 0x000000004e6e7faeULL, 0x0003e2000b901c4aULL,
0x0000000f62237c11ULL, 0x000fe2000f8e20ffULL, 0x00000010204a7825ULL, 0x000fe200078e004aULL,
0x0000000f61617c11ULL, 0x000fe2000f8e20ffULL, 0x000000004c6b7faeULL, 0x0003e2000b901c4aULL,
0x0000000f60417c11ULL, 0x000fe2000f8e20ffULL, 0x0000001020487825ULL, 0x000fe200078e0048ULL,
0x0000000f5f5f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000004a697faeULL, 0x0003e2000b901c4aULL,
0x0000000f5e437c11ULL, 0x000fe2000f8e20ffULL, 0x0000001020467825ULL, 0x000fc400078e0046ULL,
0x0000000048687faeULL, 0x0003e4000b901c4aULL, 0x0000001020447825ULL, 0x040fe400078e0044ULL,
0x0000000046677faeULL, 0x0003e4000b901c4aULL, 0x0000001020107825ULL, 0x040fe400078e0010ULL,
0x0000000044657faeULL, 0x0003e4000b901c4aULL, 0x0000001020127825ULL, 0x000fc400078e0012ULL,
0x0000000010647faeULL, 0x0003e4000b901c4aULL, 0x0000001020147825ULL, 0x040fe400078e0014ULL,
0x0000000012637faeULL, 0x0003e4000b901c4aULL, 0x0000001020167825ULL, 0x040fe400078e0016ULL,
0x0000000014237faeULL, 0x0003e4000b901c4aULL, 0x0000001020187825ULL, 0x000fc400078e0018ULL,
0x0000000016617faeULL, 0x0003e4000b901c4aULL, 0x00000010201a7825ULL, 0x040fe400078e001aULL,
0x0000000018417faeULL, 0x0003e4000b901c4aULL, 0x0000001020207825ULL, 0x000fe400078e0056ULL,
0x000000001a5f7faeULL, 0x0003e8000b901c4aULL, 0x0000000020437faeULL, 0x0003e4000b901c4aULL,
0x0000400001137983ULL, 0x002ea80000300800ULL, 0x0000440001127983ULL, 0x000ee80000300800ULL,
0x00005000011b7983ULL, 0x000f680000300800ULL, 0x00005800011a7983ULL, 0x000f680000300800ULL,
0x0000640001457983ULL, 0x000f620000300800ULL, 0x0000001003107836ULL, 0x000fc40000000000ULL,
0x0000002002117824ULL, 0x000fe200078e00ffULL, 0x0000840001527983ULL, 0x000f680000300800ULL,
0x00007800014b7983ULL, 0x000f620000300800ULL, 0xffffffe011107812ULL, 0x000fc600078ee210ULL,
0x00007000014a7983ULL, 0x000f620000300800ULL, 0x0000000610147c11ULL, 0x000fc6000f8e20ffULL,
0x0000600001497983ULL, 0x000f680000300800ULL, 0x00006c0001487983ULL, 0x000f680000300800ULL,
0x0000800001517983ULL, 0x000f680000300800ULL, 0x00008800014f7983ULL, 0x000f680000300800ULL,
0x00009000014e7983ULL, 0x000f680000300800ULL, 0x00008c00014d7983ULL, 0x000f680000300800ULL,
0x00009400014c7983ULL, 0x000f680000300800ULL, 0x0000980001507983ULL, 0x000f680000300800ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000001203187810ULL, 0x000fe20007ffe0ffULL,
0x0000002002197824ULL, 0x000fc400078e00ffULL, 0x0000100001547983ULL, 0x0003280000100800ULL,
0x00000c0001537983ULL, 0x0003220000100800ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000001414783bULL, 0x000fe20000000200ULL, 0xffffffe019447812ULL, 0x000fc600078ee218ULL,
0x000000001340783bULL, 0x004ea80000000200ULL, 0x000000001210783bULL, 0x008ee80000000200ULL,
0x000000001b20783bULL, 0x020f680000000200ULL, 0x000000001a18783bULL, 0x000e620000000200ULL,
0x000000401434723cULL, 0x004fec0000041834ULL, 0x000000421440723cULL, 0x000fee0000041838ULL,
0x0000000644387c11ULL, 0x000fc4000f8e20ffULL, 0x000000004544783bULL, 0x000fe80000000200ULL,
0x000000003838783bULL, 0x000ea20000000200ULL, 0x00000010141c723cULL, 0x008fec000004181cULL,
0x000000121430723cULL, 0x000fe20000041830ULL, 0x000000005210783bULL, 0x0006aa0000000200ULL,
0x000000201424723cULL, 0x020fe20000041824ULL, 0x0000080001527983ULL, 0x00872a0000100800ULL,
0x000000221428723cULL, 0x000fec0000041828ULL, 0x00000018142c723cULL, 0x002fec000004182cULL,
0x0000001a143c723cULL, 0x000fe2000004183cULL, 0x000000004b18783bULL, 0x000fec0000000200ULL,
0x0000001403147836ULL, 0x000fc40000000000ULL, 0x0000002002157824ULL, 0x000fca00078e00ffULL,
0xffffffe015207812ULL, 0x000fe200078ee214ULL, 0x000000443834723cULL, 0x004fe20000041834ULL,
0x000000004a14783bULL, 0x000fe40000000200ULL, 0x0000000620207c11ULL, 0x000fc6000f8e20ffULL,
0x000000463840723cULL, 0x000fe20000041840ULL, 0x000000004944783bULL, 0x000fe80000000200ULL,
0x000000002020783bULL, 0x000fe80000000200ULL, 0x000000004848783bULL, 0x000e620000000200ULL,
0x00000010381c723cULL, 0x000fec000004181cULL, 0x000000123830723cULL, 0x000fe20000041830ULL,
0x000000005110783bULL, 0x0005680000000200ULL, 0x0000040001517983ULL, 0x00471a0000100800ULL,
0x00000048201c723cULL, 0x002fec000004181cULL, 0x0000004a2030723cULL, 0x000fe20000041830ULL,
0x000000005048783bULL, 0x0003e80000000200ULL, 0x0000000001507983ULL, 0x0027220000100800ULL,
0x00000014382c723cULL, 0x000fec000004182cULL, 0x00000016383c723cULL, 0x000fe2000004183cULL,
0x000000004f14783bULL, 0x000e6a0000000200ULL, 0x000000183824723cULL, 0x000fee0000041824ULL,
0x0000001603187836ULL, 0x000fe20000000000ULL, 0x0000000502197819ULL, 0x000fe200000006ffULL,
0x0000001a3828723cULL, 0x000fe20000041828ULL, 0x000000004d38783bULL, 0x000fe40000000200ULL,
0xffffffe019187812ULL, 0x000fc800078ee218ULL, 0x0000000618187c11ULL, 0x000fe2000f8e20ffULL,
0x000000442034723cULL, 0x000fea0000041834ULL, 0x000000001818783bULL, 0x000ea20000000200ULL,
0x000000462040723cULL, 0x000fe60000041840ULL, 0x000000004e44783bULL, 0x000ee80000000200ULL,
0x000000004c4c783bULL, 0x000ee20000000200ULL, 0x000000040d0c7290ULL, 0x000fe2000fffe03fULL,
0x000000102024723cULL, 0x020fe60000041824ULL, 0x000000010c087890ULL, 0x000fc6000fffe03fULL,
0x000000122028723cULL, 0x000fec0000041828ULL, 0x00000014202c723cULL, 0x002fec000004182cULL,
0x00000016203c723cULL, 0x000fe2000004183cULL, 0x000000050800728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x000000120c0f7291ULL, 0x000fe2000f8e403fULL,
0x00000003ff557819ULL, 0x000fe20000011670ULL, 0x00000038181c723cULL, 0x004fe4000004181cULL,
0x00000010071072a4ULL, 0x000fc8000f8e020fULL, 0x000000441834723cULL, 0x008fec0000041834ULL,
0x000000461840723cULL, 0x000fec0000041840ULL, 0x0000003a1830723cULL, 0x000fec0000041830ULL,
0x0000004c1824723cULL, 0x000fec0000041824ULL, 0x0000004e1828723cULL, 0x000fec0000041828ULL,
0x00000048182c723cULL, 0x000fec000004182cULL, 0x0000004a183c723cULL, 0x000fe2000004183cULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000400a48947ULL, 0x000fde0003800000ULL,
0x0000000f1100728cULL, 0x000fe2000bf01070ULL, 0x0000001055497c36ULL, 0x000fe20008000000ULL,
0x00000004704a7819ULL, 0x000fe200000006ffULL, 0x0000001004397c36ULL, 0x000fe20008000000ULL,
0x0000000f11087287ULL, 0x000fe2000c000000ULL, 0x0000020049487825ULL, 0x100fe200078e000eULL,
0x000000704a4a7812ULL, 0x000fe400078ec0ffULL, 0x000000080f087290ULL, 0x000fe2000fffe13fULL,
0x0000001005117c36ULL, 0x000fe20008000000ULL, 0x000000484a487210ULL, 0x000fe20007f1e0ffULL,
0x0000020039387825ULL, 0x000fe200078e000eULL, 0x000000100b237c10ULL, 0x000fc4000fffe0ffULL,
0x0000000805007c0cULL, 0x000fe2000bfa6070ULL, 0x0000020011107825ULL, 0x000fe200078e000eULL,
0x0000000855007c0cULL, 0x000fe4000bf46070ULL, 0x0000000804007c0cULL, 0x000fe2000bf66070ULL,
0x00000010061b7c36ULL, 0x000fe20008000000ULL, 0x000000384a387210ULL, 0x000fe20007fde0ffULL,
0x0000001007057c36ULL, 0x000fe20008000000ULL, 0x0000000806007c0cULL, 0x000fe2000bf26070ULL,
0x000000ffff497224ULL, 0x000fe200000e0649ULL, 0x000000104a107210ULL, 0x000fe20007f1e0ffULL,
0x000002001b1a7825ULL, 0x000fe200078e000eULL, 0x0000000807007c0cULL, 0x000fc4000bf86070ULL,
0x00000011ff117210ULL, 0x000fe200007fe4ffULL, 0x0000020005047825ULL, 0x000fe200078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000048547faeULL, 0x010fe2000d101c4aULL,
0x000000100c137c10ULL, 0x000fe4000fffe0ffULL, 0x0000001008477c36ULL, 0x000fe20008000000ULL,
0x000000044a047210ULL, 0x000fe20007f1e0ffULL, 0x0000001009457c36ULL, 0x000fe40008000000ULL,
0x000000ffff397224ULL, 0x000fe200030e0639ULL, 0x0000001a4a1a7210ULL, 0x000fe20007fde0ffULL,
0x0000020047467825ULL, 0x000fc600078e000eULL, 0x0000000038537faeULL, 0x0003e2000d901c4aULL,
0x0000020045447825ULL, 0x000fe200078e000eULL, 0x0000000809007c0cULL, 0x000fe4000bf66070ULL,
0x0000000010527faeULL, 0x0005e2000e901c4aULL, 0x000000100a3b7c36ULL, 0x000fe40008000000ULL,
0x000000ffff1b7224ULL, 0x000fe200030e061bULL, 0x000000464a467210ULL, 0x000fe20007fde0ffULL,
0x000000ffff057224ULL, 0x000fe200000e0605ULL, 0x0000000808007c0cULL, 0x000fe2000bf06070ULL,
0x000000105b217c36ULL, 0x000fe20008000000ULL, 0x000000444a087210ULL, 0x000fe20007f5e0ffULL,
0x000002003b3a7825ULL, 0x000fe200078e000eULL, 0x000000001a517faeULL, 0x000fe2000c901c4aULL,
0x000000080b007c0cULL, 0x000fc4000bf26070ULL, 0x0000020021207825ULL, 0x000fe200078e000eULL,
0x0000000004507faeULL, 0x0007e6000e101c4aULL, 0x000000ffff477224ULL, 0x000fe200030e0647ULL,
0x0000003a4a387210ULL, 0x002fe20007fde0ffULL, 0x0000001059177c36ULL, 0x000fe20008000000ULL,
0x000000204a107210ULL, 0x004fe20007fbe0ffULL, 0x0000020023227825ULL, 0x000fe200078e000eULL,
0x0000003bff397210ULL, 0x000fe200037fe4ffULL, 0x00000000467d7faeULL, 0x0005e2000c101c4aULL,
0x000000085a007c0cULL, 0x000fe2000bf06070ULL, 0x000000ffff097224ULL, 0x000fe200010e0645ULL,
0x000000080a007c0cULL, 0x000fe2000bf46070ULL, 0x000000105a197c36ULL, 0x000fe20008000000ULL,
0x000000224a0a7210ULL, 0x000fe20007fde0ffULL, 0x0000020017167825ULL, 0x000fe200078e000eULL,
0x00000000087c7faeULL, 0x0005e6000d901c4aULL, 0x0000001058157c36ULL, 0x000fc40008000000ULL,
0x000000100d077c36ULL, 0x000fe40008000000ULL, 0x0000020019187825ULL, 0x000fe400078e000eULL,
0x00000000387b7faeULL, 0x0005e2000d101c4aULL, 0x0000000858007c0cULL, 0x000fe2000bf46070ULL,
0x000000ffff117224ULL, 0x000fe200028e0621ULL, 0x000000164a167210ULL, 0x000fe20007fbe0ffULL,
0x0000020015147825ULL, 0x000fe200078e000eULL, 0x000000184a047210ULL, 0x008fc60007f9e0ffULL,
0x0000020013127825ULL, 0x000fe200078e000eULL, 0x000000144a147210ULL, 0x000fc60007f7e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200030e0623ULL, 0x000000085b007c0cULL, 0x000fe2000bfc6070ULL,
0x0000020007067825ULL, 0x000fe200078e000eULL, 0x00000015ff157210ULL, 0x000fe40001ffe4ffULL,
0x000000000a7a7faeULL, 0x0005e2000c901c4aULL, 0x000000ffff177224ULL, 0x000fe200028e0617ULL,
0x000000124a127210ULL, 0x000fe20007fbe0ffULL, 0x000000105c4b7c36ULL, 0x000fe20008000000ULL,
0x000000064a067210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff057224ULL, 0x000fe200020e0619ULL,
0x0000000859007c0cULL, 0x000fe2000bf86070ULL, 0x000002004b0e7825ULL, 0x000fe200078e000eULL,
0x000000080c007c0cULL, 0x000fe2000bf66070ULL, 0x0000000010797faeULL, 0x0005e4000f101c4aULL,
0x000000ffff137224ULL, 0x000fe200028e0613ULL, 0x000000080d007c0cULL, 0x000fe2000bfa6070ULL,
0x000000ffff077224ULL, 0x000fe200008e0607ULL, 0x000000085c007c0cULL, 0x000fe2000bf26070ULL,
0x0000000004787faeULL, 0x0005e2000c101c4aULL, 0x0000000e4a4a7210ULL, 0x000fc60007fde0ffULL,
0x0000000016777faeULL, 0x0005e4000e101c4aULL, 0x000000ffff4b7224ULL, 0x000fe400030e060fULL,
0x0000000014767faeULL, 0x0005e8000d101c4aULL, 0x0000000012757faeULL, 0x0005e8000d901c4aULL,
0x0000000006747faeULL, 0x0005e8000e901c4aULL, 0x000000004a737faeULL, 0x0005e2000c901c4aULL,
0x0000000400547947ULL, 0x000fea0003800000ULL, 0x0000001004397c36ULL, 0x000fe20008000000ULL,
0x00000010053b7c10ULL, 0x000fe2000fffe0ffULL, 0x0000001070047824ULL, 0x000fe200078e00ffULL,
0x000000100a217c10ULL, 0x000fe2000fffe0ffULL, 0x0000001055237c36ULL, 0x000fe20008000000ULL,
0x000000105c477c10ULL, 0x000fe2000fffe0ffULL, 0x0000001006457c36ULL, 0x000fe20008000000ULL,
0x0000007004047812ULL, 0x000fe200078ec0ffULL, 0x0000020023227825ULL, 0x000fc800078e000eULL,
0x0000020039387825ULL, 0x000fe200078e000eULL, 0x0000002204227210ULL, 0x000fc60007f1e0ffULL,
0x000002003b3a7825ULL, 0x000fe200078e000eULL, 0x0000003804387210ULL, 0x000fc60007f3e0ffULL,
0x0000001007177c36ULL, 0x000fe20008000000ULL, 0x0000003a043a7210ULL, 0x000fe20007f5e0ffULL,
0x0000020045447825ULL, 0x000fe200078e000eULL, 0x0000001058077c10ULL, 0x000fc6000fffe0ffULL,
0x0000001008197c36ULL, 0x000fe20008000000ULL, 0x0000004404447210ULL, 0x000fe20007f7e0ffULL,
0x00000010091b7c36ULL, 0x000fe40008000000ULL, 0x0000020017167825ULL, 0x000fc800078e000eULL,
0x000000100b0b7c36ULL, 0x000fe40008000000ULL, 0x0000020019187825ULL, 0x000fc800078e000eULL,
0x000002001b1a7825ULL, 0x000fc800078e000eULL, 0x0000020021207825ULL, 0x000fc800078e000eULL,
0x000000105b117c36ULL, 0x000fe40008000000ULL, 0x000000105a137c36ULL, 0x000fe40008000000ULL,
0x0000001059157c36ULL, 0x000fe40008000000ULL, 0x000000100c097c36ULL, 0x000fe40008000000ULL,
0x000000100d057c36ULL, 0x000fe40008000000ULL, 0x000000ffff237224ULL, 0x000fe200000e0623ULL,
0x0000001604167210ULL, 0x000fe20007f1e0ffULL, 0x000002000b0c7825ULL, 0x000fc600078e000eULL,
0x00000017ff177210ULL, 0x000fe200007fe4ffULL, 0x000000ffff397224ULL, 0x000fe200008e0639ULL,
0x0000001804187210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fe200010e063bULL,
0x0000001a041a7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff457224ULL, 0x000fe200018e0645ULL,
0x0000002004207210ULL, 0x000fe20007f7e0ffULL, 0x0000020011107825ULL, 0x100fe200078e000eULL,
0x0000000c040c7210ULL, 0x000fe20007f1e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000022547faeULL, 0x0103e4000b901c4aULL, 0x0000020013127825ULL, 0x000fc400078e000eULL,
0x0000000038537faeULL, 0x0003e4000b901c4aULL, 0x0000020015147825ULL, 0x100fe400078e000eULL,
0x000000003a527faeULL, 0x0003e4000b901c4aULL, 0x0000020007067825ULL, 0x000fe400078e000eULL,
0x0000000044517faeULL, 0x0003e4000b901c4aULL, 0x000000ffff197224ULL, 0x000fe200008e0619ULL,
0x0000001004107210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff1b7224ULL, 0x000fe200010e061bULL,
0x0000001204127210ULL, 0x000fe20007f5e0ffULL, 0x0000020009087825ULL, 0x000fe200078e000eULL,
0x00000011ff117210ULL, 0x000fe20000ffe4ffULL, 0x0000000016507faeULL, 0x0003e4000b901c4aULL,
0x000000ffff217224ULL, 0x000fe200018e0621ULL, 0x0000001404147210ULL, 0x000fe20007f7e0ffULL,
0x00000200050a7825ULL, 0x100fe200078e000eULL, 0x0000000804087210ULL, 0x000fe20007f3e0ffULL,
0x00000000187d7faeULL, 0x0003e4000b901c4aULL, 0x00000200470e7825ULL, 0x000fc400078e000eULL,
0x000000001a7c7faeULL, 0x0003e4000b901c4aULL, 0x000000ffff0d7224ULL, 0x000fe200000e060dULL,
0x0000000604067210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff137224ULL, 0x000fe200010e0613ULL,
0x0000000a040a7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff157224ULL, 0x000fe200018e0615ULL,
0x0000000e04047210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff077224ULL, 0x000fe200000e0607ULL,
0x00000000207b7faeULL, 0x0003e2000b901c4aULL, 0x000000ffff097224ULL, 0x000fe200008e0609ULL,
0x0000000bff0b7210ULL, 0x000fe200017fe4ffULL, 0x000000ffff057224ULL, 0x000fe200018e060fULL,
0x000000000c7a7faeULL, 0x0003e8000b901c4aULL, 0x0000000010797faeULL, 0x0003e8000b901c4aULL,
0x0000000012787faeULL, 0x0003e8000b901c4aULL, 0x0000000014777faeULL, 0x0003e8000b901c4aULL,
0x0000000006767faeULL, 0x0003e8000b901c4aULL, 0x0000000008757faeULL, 0x0003e8000b901c4aULL,
0x000000000a747faeULL, 0x0003e8000b901c4aULL, 0x0000000004737faeULL, 0x0003e4000b901c4aULL,
0x00007c0001067983ULL, 0x006ea80000300800ULL, 0x00007400010c7983ULL, 0x000ee80000300800ULL,
0x0000680001107983ULL, 0x000f280000300800ULL, 0x00005c0001167983ULL, 0x000f680000300800ULL,
0x0000540001197983ULL, 0x000f680000300800ULL, 0x00004c0001387983ULL, 0x000f680000300800ULL,
0x00004800013b7983ULL, 0x000f680000300800ULL, 0x00003c00013a7983ULL, 0x000f680000300800ULL,
0x00001c0001397983ULL, 0x000f620000300800ULL, 0x0000001803047836ULL, 0x000fc40000000000ULL,
0x0000002002057824ULL, 0x000fe200078e00ffULL, 0x0000180001497983ULL, 0x000f680000300800ULL,
0x0000140001487983ULL, 0x000f620000300800ULL, 0xffffffe005047812ULL, 0x000fc600078ee204ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000604047c11ULL, 0x000fe2000f8e20ffULL,
0x0000001a03147836ULL, 0x000fe20000000000ULL, 0x0000000502157819ULL, 0x000fe200000006ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xffffffe015187812ULL, 0x000fe200078ee214ULL,
0x000000006c6c783bULL, 0x000fe60000000200ULL, 0x0000000618207c11ULL, 0x000fe2000f8e20ffULL,
0x000000005d5c783bULL, 0x000fea0000000200ULL, 0x000000002020783bULL, 0x000fe20000000200ULL,
0x000000060e087291ULL, 0x000fc6000f8e183fULL, 0x000000000608783bULL, 0x004fe80000000200ULL,
0x000000000404783bULL, 0x000e680000000200ULL, 0x000000000c0c783bULL, 0x008ea80000000200ULL,
0x000000001010783bULL, 0x010ee80000000200ULL, 0x000000001614783bULL, 0x020f280000000200ULL,
0x000000001918783bULL, 0x000f620000000200ULL, 0x000000080434723cULL, 0x002fec0000041834ULL,
0x0000000c041c723cULL, 0x004fee000004181cULL, 0x0000001c030c7836ULL, 0x000fc40000000000ULL,
0x00000020020d7824ULL, 0x000fe200078e00ffULL, 0x0000000a0440723cULL, 0x000fe20000041840ULL,
0x000000003808783bULL, 0x0002aa0000000200ULL, 0x0000000e0430723cULL, 0x000fe20000041830ULL,
0xffffffe00d387812ULL, 0x002fca00078ee20cULL, 0x000000100424723cULL, 0x008fe20000041824ULL,
0x000000003b0c783bULL, 0x000e6a0000000200ULL, 0x000000120428723cULL, 0x000fe20000041828ULL,
0x000000003a10783bULL, 0x000ee20000000200ULL, 0x0000000638447c11ULL, 0x000fc8000f8e20ffULL,
0x00000014042c723cULL, 0x010fe2000004182cULL, 0x000000003938783bULL, 0x000fe80000000200ULL,
0x000000004444783bULL, 0x000fe20000000200ULL, 0x00000016043c723cULL, 0x000fe6000004183cULL,
0x000000004904783bULL, 0x000f260000000200ULL, 0x000000182034723cULL, 0x020fe20000041834ULL,
0x000000004814783bULL, 0x000f620000000200ULL, 0x0000001e03037836ULL, 0x000fc40000000000ULL,
0x0000002002027824ULL, 0x000fe200078e00ffULL, 0x000000007148783bULL, 0x000fe20000000200ULL,
0x0000001a2040723cULL, 0x000fe60000041840ULL, 0x000000007218783bULL, 0x000f620000000200ULL,
0xffffffe002037812ULL, 0x000fe400078ee203ULL, 0x00000008201c723cULL, 0x004fe4000004181cULL,
0x0000000603037c11ULL, 0x000fc8000f8e20ffULL, 0x0000000a2030723cULL, 0x000fe20000041830ULL,
0x000000000308783bULL, 0x000eaa0000000200ULL, 0x0000000c2024723cULL, 0x002fec0000041824ULL,
0x0000000e2028723cULL, 0x000fe20000041828ULL, 0x00000000660c783bULL, 0x000e6a0000000200ULL,
0x00000010202c723cULL, 0x008fec000004182cULL, 0x00000012203c723cULL, 0x000fec000004183cULL,
0x00000004441c723cULL, 0x010fec000004181cULL, 0x000000064430723cULL, 0x000fec0000041830ULL,
0x000000144410723cULL, 0x020fec0000041824ULL, 0x000000384434723cULL, 0x000fec0000041834ULL,
0x0000003a4440723cULL, 0x000fec0000041840ULL, 0x000000164428723cULL, 0x000fec0000041828ULL,
0x000000184404723cULL, 0x000fec000004182cULL, 0x0000001a443c723cULL, 0x000fe2000004183cULL,
0x0000000100267802ULL, 0x000fca0000000f00ULL, 0x0000006c0814723cULL, 0x004fe2000004181cULL,
0x01c68826ff2679a7ULL, 0x000eaa0008500008ULL, 0x0000000c0810723cULL, 0x002fec0000041810ULL,
0x000000480834723cULL, 0x000fec0000041834ULL, 0x0000004a0840723cULL, 0x000fec0000041840ULL,
0x0000006e086c723cULL, 0x000fec0000041830ULL, 0x0000000e080c723cULL, 0x000fec0000041828ULL,
0x0000005c0804723cULL, 0x000fec0000041804ULL, 0x0000005e0808723cULL, 0x000fe2000004183cULL,
0x3d800000141f7820ULL, 0x000fe20000410000ULL, 0x3d80000010217820ULL, 0x000fe20000410000ULL,
0x3d800000111d7820ULL, 0x000fe20000410000ULL, 0x3d800000151e7820ULL, 0x000fe20000410000ULL,
0x3d80000034257820ULL, 0x000fe20000410000ULL, 0x3d80000035227820ULL, 0x000fe20000410000ULL,
0x3d80000036187820ULL, 0x000fe20000410000ULL, 0x3d80000037037820ULL, 0x000fe20000410000ULL,
0x3d80000040237820ULL, 0x000fe20000410000ULL, 0x3d80000041207820ULL, 0x000fe20000410000ULL,
0x3d80000042197820ULL, 0x000fe20000410000ULL, 0x3d8000000c1c7820ULL, 0x000fe20000410000ULL,
0x3d8000000d147820ULL, 0x000fe20000410000ULL, 0x3d8000000e107820ULL, 0x000fe20000410000ULL,
0x3d8000000f117820ULL, 0x000fe20000410000ULL, 0x3d800000431a7820ULL, 0x000fe20000410000ULL,
0x3d80000016167820ULL, 0x000fe20000410000ULL, 0x3d80000017177820ULL, 0x000fe20000410000ULL,
0x3d8000006c6c7820ULL, 0x000fe20000410000ULL, 0x3d8000006d6d7820ULL, 0x000fe20000410000ULL,
0x3d8000006e6e7820ULL, 0x000fe20000410000ULL, 0x3d8000006f6f7820ULL, 0x000fe20000410000ULL,
0x3d80000012127820ULL, 0x000fe20000410000ULL, 0x3d80000013137820ULL, 0x000fe20000410000ULL,
0x3d800000041b7820ULL, 0x000fe20000410000ULL, 0x3d80000005157820ULL, 0x000fe20000410000ULL,
0x3d800000060f7820ULL, 0x000fe20000410000ULL, 0x3d800000070c7820ULL, 0x000fe20000410000ULL,
0x3d80000008087820ULL, 0x000fe20000410000ULL, 0x3d80000009097820ULL, 0x000fe20000410000ULL,
0x3d8000000a0d7820ULL, 0x000fe20000410000ULL, 0x3d8000000b0e7820ULL, 0x000fe20000410000ULL,
0x0000000000047805ULL, 0x000fe20000015200ULL, 0x01c68827ff0075a7ULL, 0x004e640008000148ULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff0a7224ULL, 0x000fce00078e00ffULL,
0x000000100a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x00000006040b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff027819ULL, 0x000fc80000011407ULL,
0x0000000b02027211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000202027819ULL, 0x000fc80000001207ULL, 0x000000020000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000010a0a7836ULL, 0x000fce0000000000ULL,
0x01c68827ff0075a7ULL, 0x000e640008000148ULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0xffffffff050f7890ULL, 0x000fe2000fffe03fULL, 0x0000000270027819ULL, 0x000fe200000006ffULL,
0x000000060e087291ULL, 0x000fe4000f8e383fULL, 0x0000000f0400728cULL, 0x000fe2000bf05270ULL,
0xfffffff002027812ULL, 0x000fca00078ec0ffULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x01c4000802047984ULL, 0x0002980008000c00ULL, 0x0000000400080947ULL, 0x002fea0003800000ULL,
0x00000002700a7824ULL, 0x000fe200078e00ffULL, 0x8000000911097290ULL, 0x000fc8000fffe03fULL,
0x000000060a0a7812ULL, 0x000fc800078ec0ffULL, 0x000000010a0b7812ULL, 0x040fe400078efcffULL,
0x000000080a247812ULL, 0x040fe400078efcffULL, 0x000000090b007c0cULL, 0x000fe4000bf26070ULL,
0x000000100a0b7812ULL, 0x000fe400078efcffULL, 0x0000000924007c0cULL, 0x000fe4000bf06070ULL,
0x000000090b007c0cULL, 0x000fc4000bfc6070ULL, 0x000000110a247812ULL, 0x040fe400078efcffULL,
0x000000180a0b7812ULL, 0x040fe400078efcffULL, 0x000000090a007c0cULL, 0x000fe4000bf46070ULL,
0x0000000924007c0cULL, 0x000fe4000bfa6070ULL, 0x000000090b007c0cULL, 0x000fe4000bf66070ULL,
0x000000090a267812ULL, 0x000fc400078efcffULL, 0x000000190a247812ULL, 0x040fe400078efcffULL,
0x000000200a0b7812ULL, 0x000fe400078efcffULL, 0xff80000018187808ULL, 0x000fe40005000000ULL,
0xff80000025257808ULL, 0x000fe40005000000ULL, 0xff80000003037808ULL, 0x000fe40004800000ULL,
0xff80000022227808ULL, 0x000fc40004800000ULL, 0x0000000926007c0cULL, 0x000fe4000bf86070ULL,
0x0000000924007c0cULL, 0x000fe4000bf46070ULL, 0x000000090b007c0cULL, 0x000fe4000bf26070ULL,
0x000000210a247812ULL, 0x040fe400078efcffULL, 0x000000280a0b7812ULL, 0x000fe400078efcffULL,
0xff80000019197808ULL, 0x000fc40004000000ULL, 0xff80000023237808ULL, 0x000fe40004000000ULL,
0xff8000001a1a7808ULL, 0x000fe40006000000ULL, 0xff80000020207808ULL, 0x000fe40006000000ULL,
0x0000000924007c0cULL, 0x000fe4000bf06070ULL, 0x000000090b007c0cULL, 0x000fe4000bf86070ULL,
0x000000290a247812ULL, 0x000fc400078efcffULL, 0x000000300a0b7812ULL, 0x000fe400078efcffULL,
0xff80000016167808ULL, 0x000fe40007000000ULL, 0xff8000001f1f7808ULL, 0x000fe40007000000ULL,
0xff80000017177808ULL, 0x000fe40006800000ULL, 0xff8000001e1e7808ULL, 0x000fe40006800000ULL,
0x0000000924007c0cULL, 0x000fc4000bfc6070ULL, 0x000000090b007c0cULL, 0x000fe4000bfa6070ULL,
0x000000310a247812ULL, 0x040fe400078efcffULL, 0x000000380a0b7812ULL, 0x040fe400078efcffULL,
0x000000390a0a7812ULL, 0x000fe400078efcffULL, 0xff8000006e6e7808ULL, 0x000fe40005800000ULL,
0xff8000006c6c7808ULL, 0x000fc40005800000ULL, 0xff8000006f6f7808ULL, 0x000fe40005000000ULL,
0xff8000006d6d7808ULL, 0x000fe40005000000ULL, 0xff80000012127808ULL, 0x000fe40004800000ULL,
0xff80000021217808ULL, 0x000fe40004800000ULL, 0x0000000924007c0cULL, 0x000fe4000bf66070ULL,
0x000000090b007c0cULL, 0x000fc4000bf46070ULL, 0x000000090a007c0cULL, 0x000fe4000bf26070ULL,
0xff80000013137808ULL, 0x000fe40004000000ULL, 0xff8000001d1d7808ULL, 0x000fe40004000000ULL,
0xff80000010107808ULL, 0x000fe40006000000ULL, 0xff8000001c1c7808ULL, 0x000fe40006000000ULL,
0xff80000011117808ULL, 0x000fc40007000000ULL, 0xff80000014147808ULL, 0x000fe40007000000ULL,
0xff8000000f0f7808ULL, 0x000fe40006800000ULL, 0xff8000001b1b7808ULL, 0x000fe40006800000ULL,
0xff8000000c0c7808ULL, 0x000fe40005800000ULL, 0xff80000015157808ULL, 0x000fe40005800000ULL,
0xff8000000d0d7808ULL, 0x000fc40005000000ULL, 0xff80000008087808ULL, 0x000fe40005000000ULL,
0xff8000000e0e7808ULL, 0x000fe40004800000ULL, 0xff80000009097808ULL, 0x000fce0004800000ULL,
0x000000250400720bULL, 0x004fe20003f1e000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0x00000003ff2c7819ULL, 0x000fe20000011670ULL, 0x000000050c00728cULL, 0x000fe2000bf06070ULL,
0x00000004250b7208ULL, 0x000fe20004000000ULL, 0x000000060e097291ULL, 0x000fc6000f8e283fULL,
0x000000220b00720bULL, 0x000fc80003f1e000ULL, 0x0000000b22047208ULL, 0x000fc80004000000ULL,
0x000000230400720bULL, 0x000fc80003f1e000ULL, 0x00000004230b7208ULL, 0x000fc80004000000ULL,
0x000000200b00720bULL, 0x000fc80003f1e000ULL, 0x0000000b20047208ULL, 0x000fc80004000000ULL,
0x0000001f0400720bULL, 0x000fc80003f1e000ULL, 0x000000041f0b7208ULL, 0x000fc80004000000ULL,
0x0000001e0b00720bULL, 0x000fc80003f1e000ULL, 0x0000000b1e0b7208ULL, 0x000fc80004000000ULL,
0x0000006c0b00720bULL, 0x000fc80003f1e000ULL, 0x0000000b6c047208ULL, 0x000fc80004000000ULL,
0x0000006d0400720bULL, 0x000fc80003f1e000ULL, 0x000000046d047208ULL, 0x000fc80004000000ULL,
0x000000210400720bULL, 0x000fc80003f1e000ULL, 0x0000000421047208ULL, 0x000fc80004000000ULL,
0x0000001d0400720bULL, 0x000fc80003f1e000ULL, 0x000000041d0b7208ULL, 0x000fc80004000000ULL,
0x0000001c0b00720bULL, 0x000fc80003f1e000ULL, 0x0000000b1c0b7208ULL, 0x000fe40004000000ULL,
0x000000180500720bULL, 0x000fe40003f1e000ULL, 0x000000140b00720bULL, 0x000fe40003f3e000ULL,
0x0000000518047208ULL, 0x000fe40004000000ULL, 0x0000000b140a7208ULL, 0x000fe40004800000ULL,
0x000000030400720bULL, 0x000fc40003f1e000ULL, 0x0000001b0a00720bULL, 0x000fe40003f3e000ULL,
0x0000000403047208ULL, 0x000fe40004000000ULL, 0x0000000a1b0a7208ULL, 0x000fe40004800000ULL,
0x000000190400720bULL, 0x000fe40003f1e000ULL, 0x000000150a00720bULL, 0x000fe40003f3e000ULL,
0x0000000419057208ULL, 0x000fc40004000000ULL, 0x0000000a150b7208ULL, 0x000fe40004800000ULL,
0x0000001a0500720bULL, 0x000fe40003f1e000ULL, 0x000000080b00720bULL, 0x000fe40003f3e000ULL,
0x000000051a057208ULL, 0x000fe40004000000ULL, 0x0000000b08047208ULL, 0x000fe40004800000ULL,
0x000000160500720bULL, 0x000fc40003f1e000ULL, 0x000000090400720bULL, 0x000fc80003f3e000ULL,
0x00000004090a7208ULL, 0x000fe40004800000ULL, 0x0000000516047208ULL, 0x000fc60004000000ULL,
0x0c401f000a0b7f89ULL, 0x000e6200000e0000ULL, 0x000000170400720bULL, 0x000fc80003f1e000ULL,
0x0000000417057208ULL, 0x000fc80004000000ULL, 0x0000006e0500720bULL, 0x000fc80003f1e000ULL,
0x000000056e047208ULL, 0x000fc80004000000ULL, 0x0000006f0400720bULL, 0x000fc80003f1e000ULL,
0x000000046f057208ULL, 0x000fe40004000000ULL, 0x0000000b0a00720bULL, 0x002fe40003f3e000ULL,
0x000000120500720bULL, 0x000fe40003f1e000ULL, 0x0000000a0b0b7208ULL, 0x000fe40004800000ULL,
0x0000000512047208ULL, 0x000fc60004000000ULL, 0x0c201f000b247f89ULL, 0x000e6200000e0000ULL,
0x000000130400720bULL, 0x000fc80003f1e000ULL, 0x0000000413057208ULL, 0x000fc80004000000ULL,
0x000000100500720bULL, 0x000fc80003f1e000ULL, 0x0000000510047208ULL, 0x000fc80004000000ULL,
0x000000110400720bULL, 0x000fc80003f1e000ULL, 0x00000004110a7208ULL, 0x000fe40004000000ULL,
0x000000240b00720bULL, 0x002fe40003f3e000ULL, 0x0000000f0a00720bULL, 0x000fe40003f1e000ULL,
0x0000000b24047208ULL, 0x000fe40004800000ULL, 0x0000000a0f057208ULL, 0x000fc60004000000ULL,
0x3fb8aa3b04247820ULL, 0x000fe20000410000ULL, 0x0000000c0500720bULL, 0x000fc60003f1e000ULL,
0x3fb8aa3b14147823ULL, 0x100fe20000010824ULL, 0x000000050c0a7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b25257823ULL, 0x100fe20000010824ULL, 0x3fb8aa3b22227823ULL, 0x100fe20000010824ULL,
0x3fb8aa3b23237823ULL, 0x100fe20000010824ULL, 0x0000000d0a00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010824ULL, 0x0000001400277308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe20000010824ULL, 0x0000000a0d057208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b09097823ULL, 0x100fe20000010824ULL, 0x3fb8aa3b08087823ULL, 0x100fe20000010824ULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe20000010824ULL, 0x0000000e0500720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010824ULL, 0x0000002500257308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b6c6c7823ULL, 0x100fe20000010824ULL, 0x000000050e057208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b6d6d7823ULL, 0x100fe20000010824ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010824ULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe20000010824ULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe20000010824ULL,
0x0c401f00050a7f89ULL, 0x000e6200000e0000ULL, 0x0000002200227308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b15157823ULL, 0x000fce0000010824ULL, 0x0000002300237308ULL, 0x000ff00000000800ULL,
0x0000002000207308ULL, 0x000ee20000000800ULL, 0x0000000a0500720bULL, 0x002fce0003f1e000ULL,
0x0000000900247308ULL, 0x000fe20000000800ULL, 0x000000050a057208ULL, 0x000fca0004000000ULL,
0x0c201f00050a7f89ULL, 0x000e6400000e0000ULL, 0x0000001d00267308ULL, 0x000ff00000000800ULL,
0x00000008001d7308ULL, 0x0005f00000000800ULL, 0x0000001500287308ULL, 0x000fe20000000800ULL,
0x000000252208723eULL, 0x004fc400000010ffULL, 0x0000000a0500720bULL, 0x002fca0003f1e000ULL,
0x0000001f001f7308ULL, 0x000fe20000000800ULL, 0x000000050a057208ULL, 0x000fe40004000000ULL,
0x00000023200a723eULL, 0x008fc600000010ffULL, 0x3fb8aa3b05297820ULL, 0x000fe40000410000ULL,
0x0000001e001e7308ULL, 0x000fe40000000800ULL, 0x3fb8aa3b19197823ULL, 0x100fe20000010829ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe20000010829ULL, 0x3fb8aa3b18187823ULL, 0x100fe20000010829ULL,
0x3fb8aa3b03037823ULL, 0x100fe20000010829ULL, 0x3fb8aa3b16167823ULL, 0x100fe20000010829ULL,
0x3fb8aa3b17177823ULL, 0x100fe20000010829ULL, 0x00000018000b7308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b6e6e7823ULL, 0x100fe20000010829ULL, 0x3fb8aa3b6f6f7823ULL, 0x100fe20000010829ULL,
0x3fb8aa3b11227823ULL, 0x100fe20000010829ULL, 0x3fb8aa3b0f0f7823ULL, 0x100fe20000010829ULL,
0x3fb8aa3b0d257823ULL, 0x000fc60000010829ULL, 0x0000000300147308ULL, 0x0004e20000000800ULL,
0x00000004ff187e24ULL, 0x002fe2000f8e00ffULL, 0x000000060e047291ULL, 0x000fc8000f8e583fULL,
0x3f8000001818783eULL, 0x000fe200000010ffULL, 0x0001200004047890ULL, 0x000fe2000fffe03fULL,
0x0000001900197308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b12037823ULL, 0x004fe20000010829ULL,
0x0000000b1409723eULL, 0x008fcc00000010ffULL, 0x0000001a001a7308ULL, 0x000e700000000800ULL,
0x00000016002a7308ULL, 0x000fe20000000800ULL, 0x000000191a0b723eULL, 0x002fe200000010ffULL,
0x000000ffff197224ULL, 0x000fcc00078e0018ULL, 0x00000017002b7308ULL, 0x0002a20000000800ULL,
0x3fb8aa3b131a7823ULL, 0x000fce0000010829ULL, 0x0000006c006c7308ULL, 0x000fe20000000800ULL,
0x000000180814723cULL, 0x002fe200000418ffULL, 0x0000002a2b11723eULL, 0x004fcc00000010ffULL,
0x0000006d006d7308ULL, 0x000e620000000800ULL, 0x3fb8aa3b10197823ULL, 0x100fe20000010829ULL,
0x0000001f1e10723eULL, 0x000fe200000010ffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0018ULL,
0x00000018002b7202ULL, 0x000fe20000000f00ULL, 0x3fb8aa3b0c1e7823ULL, 0x100fe20000010829ULL,
0x3fb8aa3b0e297823ULL, 0x000fe40000010829ULL, 0x0000006e006e7308ULL, 0x000fe20000000800ULL,
0x0000006c6d12723eULL, 0x002fce00000010ffULL, 0x0000006f006f7308ULL, 0x000e700000000800ULL,
0x0000001900197308ULL, 0x000fe20000000800ULL, 0x0000006e6f13723eULL, 0x002fce00000010ffULL,
0x0000002200227308ULL, 0x000fe20000000800ULL, 0x0000002a1014723cULL, 0x000fee0000041814ULL,
0x0000002100217308ULL, 0x000e700000000800ULL, 0x0000001c001c7308ULL, 0x000ea20000000800ULL,
0x00000021260c723eULL, 0x002fce00000010ffULL, 0x0000000300207308ULL, 0x0003e20000000800ULL,
0x000000032c217812ULL, 0x000fe400078ec0ffULL, 0x0000001000267202ULL, 0x000fe40000000f00ULL,
0x0000001c270e723eULL, 0x004fc600000010ffULL, 0x0000001a00237308ULL, 0x0004e20000000800ULL,
0x0c401f0006037f89ULL, 0x002e6200000e0000ULL, 0x000000ffff277224ULL, 0x000fcc00078e0012ULL,
0x0000000f001f7308ULL, 0x0009e20000000800ULL, 0x0c401f00071a7f89ULL, 0x004ea200000e0000ULL,
0x00000020230d723eULL, 0x008fcc00000010ffULL, 0x0000001e002a7308ULL, 0x0007620000000800ULL,
0x00000019220f723eULL, 0x010fe200000010ffULL, 0x000000ffff197224ULL, 0x000fcc00078e0018ULL,
0x0000002500257308ULL, 0x000fe20000000800ULL, 0x000000180c14723cULL, 0x000fe20000041814ULL,
0x000000030600720bULL, 0x002fe40003f1e000ULL, 0x0000001d241e723eULL, 0x008fc600000010ffULL,
0x000000ffff247224ULL, 0x000fe200078e0018ULL, 0x0000000603067208ULL, 0x000fe20004000000ULL,
0x0000002900207308ULL, 0x0002e20000000800ULL, 0x0000001f2a1d723eULL, 0x020fe200000010ffULL,
0x000000ffff2b7224ULL, 0x000fe200078e001eULL, 0x0000001a0700720bULL, 0x004fe20003f3e000ULL,
0x0c201f0006037f89ULL, 0x000ea200000e0000ULL, 0xfffffff8ff197812ULL, 0x000fe400078ee200ULL,
0x000000071a077208ULL, 0x000fe20004800000ULL, 0x0000001b001b7308ULL, 0x000f220000000800ULL,
0x000000ffff297224ULL, 0x002fe200078e000eULL, 0x0000001d000e7202ULL, 0x000fe20000000f00ULL,
0x00000001211a7824ULL, 0x000fe200078e0219ULL, 0x0c201f0007007f89ULL, 0x000e6200000e0000ULL,
0x0000000819227824ULL, 0x000fe200078e00ffULL, 0x00000025201f723eULL, 0x008fe200000010ffULL,
0x000000ffff257224ULL, 0x000fc400078e0018ULL, 0x0000000819207836ULL, 0x000fe20000000000ULL,
0x0000000319197819ULL, 0x000fc600000006ffULL, 0x0000000820187824ULL, 0x000fe200078e00ffULL,
0x0000001b281c723eULL, 0x010fe200000010ffULL, 0x000000041a1b7836ULL, 0x000fe20000000000ULL,
0x0000002021217210ULL, 0x000fe20007ffe0ffULL, 0x000000ffff287224ULL, 0x000fe200078e000cULL,
0x0000001c002a7202ULL, 0x000fe20000000f00ULL, 0x000000ffff0c7224ULL, 0x000fe200078e000dULL,
0x000000030600720bULL, 0x004fe20003f1e000ULL, 0x000000241c14723cULL, 0x000fe20000041814ULL,
0xfffffff818217812ULL, 0x000fe200078ee221ULL, 0x000000ffff0d7224ULL, 0x000fe200078e000fULL,
0xfffffff819187812ULL, 0x000fe200078ee21aULL, 0x0000000c1a1a7836ULL, 0x000fe20000000000ULL,
0x0000000603067208ULL, 0x000fe20004000000ULL, 0x000000ffff0f7224ULL, 0x000fe200078e001fULL,
0x0000000370ff7812ULL, 0x000fe2000780c0ffULL, 0x000000ffff247224ULL, 0x000fe200078e0008ULL,
0xfffffff8221b7812ULL, 0x000fe200078ee21bULL, 0x000000ffff257224ULL, 0x000fe200078e000aULL,
0x0000000418187c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff087224ULL, 0x000fe200078e0009ULL,
0x000000000700720bULL, 0x002fe20003f3e000ULL, 0x000000ffff097224ULL, 0x000fe200078e000bULL,
0x000000041b1b7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff0b7224ULL, 0x000fe200078e0013ULL,
0x0000000421217c11ULL, 0x000fe2000f8e20ffULL, 0x0000002418007844ULL, 0x0003e20000000200ULL,
0x00000011000a7202ULL, 0x000fe20000000f00ULL, 0x0000000820157824ULL, 0x000fe200078e00ffULL,
0x0000000700077208ULL, 0x000fe20004800000ULL, 0x000000281b007844ULL, 0x0003e20000000200ULL,
0x00000001ff007424ULL, 0x000fc400078e00ffULL, 0xfffffff8151a7812ULL, 0x000fe200078ee21aULL,
0x000000ffff157224ULL, 0x000fe200078e0016ULL, 0x0000000821007844ULL, 0x0003e40000000200ULL,
0x000000041a1a7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000c00047c82ULL, 0x000fc80008000000ULL,
0x0000000c1a007844ULL, 0x0003e80000000200ULL, 0x01c0000402008988ULL, 0x0003e80008000c08ULL,
0x01c2001402008988ULL, 0x0003e20008000a08ULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x01c60800ffff79a7ULL, 0x0003e20008500009ULL, 0x01c61000ffff79a7ULL, 0x0003e20008500009ULL,
0x01c61800ffff79a7ULL, 0x0003e20008500009ULL, 0x01c62000ffff79a7ULL, 0x0003f20008500009ULL,
0xffffff8c00d48947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0180000036007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000007945ULL, 0x000fe60003800000ULL,
0x7f80000000037812ULL, 0x000fc800078ec0ffULL, 0x018000000300780cULL, 0x000fda0003f05070ULL,
0x0000003600008308ULL, 0x0002a20000001000ULL, 0x0000000000388947ULL, 0x000fea0003800000ULL,
0x000000ff0300720cULL, 0x040fe40003f25070ULL, 0x008000000300780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x007fffff36ff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fe4000780c0ffULL, 0x8000000036037812ULL, 0x000fd600078ec0ffULL,
0x0080000003000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0003ULL,
0x0000000000047947ULL, 0x000fec0003800000ULL, 0x0000003600007308ULL, 0x0004e40000001000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffffea402447950ULL, 0x000fea0003c3ffffULL, 0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000001ULL, 0x0000000800000001ULL, 0x0000000100000001ULL, 0x0000000800000004ULL,
0x0000001000000001ULL, 0x0000000300000001ULL, 0x0000000400000004ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000111ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000017bULL, 0x00000000000004cdULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000648ULL, 0x0000000000000210ULL,
0x0000001400000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000c8ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000858ULL, 0x00000000000000d0ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000928ULL, 0x0000000000000054ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000097cULL, 0x00000000000004acULL,
0x0000000a00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000004000000b2ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000e28ULL, 0x0000000000000000ULL,
0x0000000a00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000e6ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000e28ULL, 0x0000000000000048ULL,
0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000007bULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000e70ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL,
0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000000e80ULL, 0x0000000000015b80ULL,
0x0000001400000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000008dULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000016a00ULL, 0x000000000000003cULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000016a40ULL, 0x0000000000000400ULL,
0x0000000a00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000001000000f8ULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000016a40ULL, 0x0000000000000258ULL,
0x0000000a00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL,
0x0000000000017018ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000017018ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000000e70ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x0000000000000008ULL,
0x0000000500000001ULL, 0x0000000000000e80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000015b80ULL, 0x0000000000015b80ULL, 0x0000000000000008ULL, 0x0000000600000001ULL,
0x0000000000016a00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x0000000000000440ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000016a40ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000258ULL, 0x0000000000000258ULL,
0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_1_kvt_bf16_nqpkv_8_m_8_sm_90_cubin_len = 94568;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
