/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_1_kvt_bf16_pagedKV_128_nqpkv_8_m_8_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001a8a0ULL, 0x000000000001a520ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x766e2e0000000000ULL, 0x2e6c61626f6c672eULL, 0x65722e0074696e69ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6e6f632e766e2e00ULL, 0x000033746e617473ULL, 0x536d656d73000000ULL, 0x2e766e2e00657a69ULL,
0x692e6c61626f6c67ULL, 0x4e5a5a5f0074696eULL, 0x7473336164756334ULL, 0x5f5f38345f5f3364ULL,
0x31326c6961746564ULL, 0x676e6f7274735f5fULL, 0x726564726f5f7265ULL, 0x696945616475635fULL,
0x726f66785f5f3745ULL, 0x374b4e5a5a5f006dULL, 0x4944327961727241ULL, 0x326a4c45326a4c66ULL,
0x624c497461324545ULL, 0x6a664b5245454530ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x326a4c66495f5349ULL, 0x6a4c4545326a4c45ULL,
0x324545386a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f30534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x625f766e5f5f3431ULL,
0x32363174616f6c66ULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6a49636556334944ULL, 0x316a4c4545346a4cULL, 0x324545386a4c4536ULL, 0x454531624c497461ULL,
0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL,
0x4944327961727241ULL, 0x6a4c6a4963655633ULL, 0x4536316a4c454534ULL, 0x6132454532336a4cULL,
0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4534366a4c4545ULL,
0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL,
0x45326a4c45326a4cULL, 0x316a4c45316a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL,
0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL,
0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL, 0x4c4545326a4c4532ULL, 0x4545316a4c45346aULL,
0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x32336a4c4545346aULL,
0x61324545386a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x6a4c45386a4c4545ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL,
0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL, 0x30624c4974613245ULL, 0x5f31534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x0000000000676e69ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x65746e695f5f2400ULL, 0x245f305f6c616e72ULL, 0x735f616475635f5fULL,
0x5f7063725f30326dULL, 0x665f7a74665f6e72ULL, 0x70776f6c735f3233ULL, 0x6c65722e00687461ULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x742e616c65722e00ULL, 0x6e72656b2e747865ULL,
0x240061686d5f6c65ULL, 0x6d5f6c656e72656bULL, 0x426d656d73246168ULL, 0x2e00667542657479ULL,
0x72665f6775626564ULL, 0x6c65722e00656d61ULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL,
0x67756265642e616cULL, 0x2e00656d6172665fULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000100000098ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b0003000000a1ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b0001000000b1ULL, 0x000000000000002cULL, 0x0000000000000010ULL, 0x000b0001000000efULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000b000100000128ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x000b00010000016fULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000b0001000001b9ULL, 0x0000000000000010ULL, 0x0000000000000004ULL, 0x000b0001000001ffULL,
0x0000000000000028ULL, 0x0000000000000004ULL, 0x000b000100000246ULL, 0x0000000000000008ULL,
0x0000000000000004ULL, 0x000b00010000028cULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000b0001000002daULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000b000100000328ULL,
0x0000000000000020ULL, 0x0000000000000004ULL, 0x000b00010000036eULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b0001000003b3ULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a00220000040eULL,
0x00000000000191b0ULL, 0x0000000000000250ULL, 0x0004000300000484ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000a101200000040ULL, 0x0000000000000000ULL, 0x0000000000019400ULL,
0x000d0003000004b4ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000024ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000191b000000000ULL, 0x0000200400000000ULL, 0x0190288080810c00ULL, 0x0000003cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080840828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808492ULL,
0x0000001cffffffffULL, 0x0000006000000000ULL, 0x000191b000000000ULL, 0x0000025000000000ULL,
0x0000000000000000ULL, 0x0000001400082f04ULL, 0x0008230400000080ULL, 0x0000000000000012ULL,
0x0000001200081204ULL, 0x0008110400000090ULL, 0x0000009000000012ULL, 0x0000001400082304ULL,
0x0008120400000000ULL, 0x0000009000000014ULL, 0x0000001400081104ULL, 0x0004370400000090ULL,
0x000c17040000007bULL, 0x0048000600000000ULL, 0x000c17040021f000ULL, 0x0040000500000000ULL,
0x000c17040021f000ULL, 0x0038000400000000ULL, 0x000c17040011f000ULL, 0x0018000300000000ULL,
0x000c17040081f000ULL, 0x0010000200000000ULL, 0x000c17040021f000ULL, 0x0008000100000000ULL,
0x000c17040021f000ULL, 0x0000000000000000ULL, 0x00801b030011f000ULL, 0x0000d8c000083104ULL,
0x00f429040000dd80ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x00f42804ffffffffULL,
0x00000110000000d0ULL, 0x000019b000000690ULL, 0x00002b0000002a80ULL, 0x00002d0000002bc0ULL,
0x00002f8000002f70ULL, 0x000042b000003430ULL, 0x00004670000042c0ULL, 0x00005740000056d0ULL,
0x0000596000005820ULL, 0x00005b4000005b30ULL, 0x00006c0000005de0ULL, 0x00006ee000006c10ULL,
0x00007ea000007e30ULL, 0x000080c000007f80ULL, 0x000082a000008290ULL, 0x0000935000008510ULL,
0x0000963000009360ULL, 0x0000a7000000a690ULL, 0x0000a9200000a7e0ULL, 0x0000ab000000aaf0ULL,
0x0000bc000000ade0ULL, 0x0000c0100000bc10ULL, 0x0000c5100000c020ULL, 0x0000dd800000d8c0ULL,
0x0000e2500000e210ULL, 0x0000e7900000e770ULL, 0x000185900000ec10ULL, 0x0001887000018640ULL,
0x00018c6000018930ULL, 0x00018e7000018d30ULL, 0x01f0390400018ed0ULL, 0x000000ff000001c0ULL,
0x000401000001c600ULL, 0x00000002000002a0ULL, 0x003f01000001c608ULL, 0x00000002000003b0ULL,
0x003f01000001c688ULL, 0x000000ff000006f0ULL, 0x000401070001c600ULL, 0x0000005800000870ULL,
0x000401010001c688ULL, 0x0000005800002850ULL, 0x000401010001c608ULL, 0x0000005800002870ULL,
0x000401090001c608ULL, 0x00000058000029e0ULL, 0x000401090001c608ULL, 0x000000ff000045c0ULL,
0x000401010001c688ULL, 0x00000058000054b0ULL, 0x000401010001c628ULL, 0x0000005800005500ULL,
0x000401090001c628ULL, 0x0000005800005670ULL, 0x000401090001c628ULL, 0x000000ff00006e50ULL,
0x000401010001c690ULL, 0x0000005800007c50ULL, 0x000401010001c648ULL, 0x0000005800007c70ULL,
0x000401090001c648ULL, 0x0000005800007de0ULL, 0x000401090001c648ULL, 0x000000ff000095a0ULL,
0x000401010001c698ULL, 0x000000580000a480ULL, 0x000401010001c668ULL, 0x000000580000a4d0ULL,
0x000401090001c668ULL, 0x000000580000a640ULL, 0x000401090001c668ULL, 0x000000ff0000be00ULL,
0x000401010001c6a0ULL, 0x000000ff0000eed0ULL, 0x000401010001c600ULL, 0x000000ff00010c80ULL,
0x000401090001c600ULL, 0x000000ff00010df0ULL, 0x000401090001c600ULL, 0x000000ff000179f0ULL,
0x000801010001c688ULL, 0x000000ff00017c60ULL, 0x000801090001c688ULL, 0x000000ff00017dd0ULL,
0x000801090001c688ULL, 0x000000ff00019150ULL, 0x000d01010001c608ULL, 0x000000ff00019160ULL,
0x000d01010001c610ULL, 0x000000ff00019170ULL, 0x000d01010001c618ULL, 0x000000ff00019180ULL,
0x000d01010001c620ULL, 0x00101c0400033803ULL, 0x00010e300000ee90ULL, 0x000191a000010e90ULL,
0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL, 0x00080a0400501903ULL,
0x0050021000000015ULL, 0x00000000000000bcULL, 0x0000001400000002ULL, 0x00000000000191b0ULL,
0x0000000000000044ULL, 0x0000001400000002ULL, 0x0000000000000000ULL, 0x0000000000000098ULL,
0x0000001400000002ULL, 0x0000000000000000ULL, 0x000000000001c700ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e620000000800ULL, 0x0000000000067919ULL, 0x000ea20000002100ULL,
0x0000030000107ab9ULL, 0x000fe20000000800ULL, 0x0000010000047ab9ULL, 0x000fca0000000800ULL,
0x00008800ff047b82ULL, 0x000ee20000000a00ULL, 0x0000000000087919ULL, 0x000f220000002300ULL,
0x000001a000007945ULL, 0x000fe20003800000ULL, 0xffffff7001017836ULL, 0x002fe20000000000ULL,
0x0000000000037919ULL, 0x000f280000002200ULL, 0x00000000000879c3ULL, 0x000e620000002700ULL,
0x0000000000007919ULL, 0x000e6e0000000000ULL, 0x00000000000a79c3ULL, 0x000e620000002600ULL,
0x00000005ff027819ULL, 0x004fcc0000011606ULL, 0x00001fff02027589ULL, 0x000ea200000e0000ULL,
0x0000000408037c24ULL, 0x010fe2000f8e0203ULL, 0x0000000000047ab9ULL, 0x000fc60000000800ULL,
0x0000000403077c24ULL, 0x000fe4000f8e0206ULL, 0x00001fff08067589ULL, 0x00026600000e0000ULL,
0x000000ff0700720cULL, 0x040fe40003f05270ULL, 0x0000000f0700780cULL, 0x040fe40003f24070ULL,
0x000000030700780cULL, 0x000fe40003f44070ULL, 0x00000000021172caULL, 0x004fce00000e0000ULL,
0x0000000000240947ULL, 0x00aff00003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x001fff0000067882ULL, 0x000fe20000000000ULL,
0x7ffc000000077882ULL, 0x000fe20000000000ULL, 0x0000065405047896ULL, 0x004fe20008000004ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000000073c6ULL, 0x000eb40000000000ULL,
0x01c60006043f75b2ULL, 0x0004a40008000100ULL, 0x0000000000007918ULL, 0x004fe20000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000381947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000407027c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000020612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ea40000000000ULL, 0x01c60804063f75b2ULL, 0x0004b00008000100ULL,
0xfffffffd00e81947ULL, 0x004fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000382947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000ea20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x004fc60008000004ULL,
0x7ffb000000057882ULL, 0x000fc60000000000ULL, 0x0000000407027c11ULL, 0x000fe2000f8e18ffULL,
0x001ffec000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000020612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000ea40000000000ULL,
0x01c68804063f75b2ULL, 0x0004b00008000100ULL, 0xfffffffd00e81947ULL, 0x004fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000679c3ULL, 0x000ea20000008800ULL,
0x0000001106027c11ULL, 0x002fe2000f8e10ffULL, 0x0000840000127ab9ULL, 0x000fe20000000800ULL,
0x000000030a047899ULL, 0x000fe2000800063fULL, 0x0000007f0700780cULL, 0x000fe20003f04070ULL,
0x0000000312057899ULL, 0x000fe2000800063fULL, 0x0000000202037824ULL, 0x000fe200078e00ffULL,
0x00008200000e7ab9ULL, 0x000fe20000000a00ULL, 0x00000010000d7824ULL, 0x000fe200078e00ffULL,
0x00000008050472a4ULL, 0x000fe2000f8e0204ULL, 0x00000001030b7836ULL, 0x000fe20000000000ULL,
0x0000000803027848ULL, 0x000fe20007fe0000ULL, 0x0000000103097824ULL, 0x000fc400078e0200ULL,
0x00000020030a7824ULL, 0x000fe400078e00ffULL, 0x0000000102087824ULL, 0x000fe400078e0a03ULL,
0x0000000403037c36ULL, 0x000fe20008000000ULL, 0xffffffe00a097812ULL, 0x000fe200078ee209ULL,
0x000000040b0f7c36ULL, 0x000fe20008000000ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x0000020003027825ULL, 0x100fe200078e0004ULL, 0x000000ff0800720cULL, 0x040fe20003f23070ULL,
0x0000065406047896ULL, 0x004fe20008000004ULL, 0x000000010800780cULL, 0x000fe20003f43070ULL,
0x000002000f047825ULL, 0x000fe200078e0004ULL, 0x000001f00d0f7812ULL, 0x000fe200078ec0ffULL,
0x0001c60004057890ULL, 0x000fc4000fffe03fULL, 0x000000010b0a7824ULL, 0x040fe200078e0200ULL,
0x0000000f02027210ULL, 0x000fe20007f7e0ffULL, 0x000000200b0b7824ULL, 0x000fe200078e00ffULL,
0x0000000f04047210ULL, 0x000fe20007f9e0ffULL, 0xff317217ff0c8424ULL, 0x000fe200078e00ffULL,
0x0000000407078c11ULL, 0x000fe2000f8e10ffULL, 0x000000ffff037224ULL, 0x000fe200018e0603ULL,
0xffffffe00b0a7812ULL, 0x000fe200078ee20aULL, 0x000000ffff057224ULL, 0x000fe200020e0605ULL,
0x0000000409097c11ULL, 0x000fe2000f8e20ffULL, 0x01c4000c07008388ULL, 0x0003e20000000800ULL,
0x000000040a0b7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002097faeULL, 0x0003e8000c901c4eULL,
0x00000000040b7faeULL, 0x0003e2000d101c4eULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000ffffff79a7ULL, 0x000fe40008200405ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a85ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00008e0000067ab9ULL, 0x000fc40000000a00ULL,
0x00000004080678a5ULL, 0x000fcc000f8e0006ULL, 0x00000006ff027e24ULL, 0x002fe4000f8e00ffULL,
0x00000007ff037e24ULL, 0x000fca000f8e00ffULL, 0x0000000e02027981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0600720cULL, 0x000fe20003f05270ULL, 0x00000000000579c3ULL, 0x000e620000002500ULL,
0x00000000021472caULL, 0x004fda00000e0000ULL, 0x0000007f14067890ULL, 0x000fe4000fffe03fULL,
0x000000ff14077890ULL, 0x000fe4000fffe03fULL, 0x000000073f067899ULL, 0x000fe40008011606ULL,
0x000000083f077899ULL, 0x000fe20008011607ULL, 0x000000e400a88947ULL, 0x002ff60003800000ULL,
0x0000000105097899ULL, 0x000fe2000800063fULL, 0x00000004ff037424ULL, 0x000fe200078e00ffULL,
0x0000000311137899ULL, 0x000fe4000800063fULL, 0x000000060900728cULL, 0x000fe2000bf06070ULL,
0xffffffff00177882ULL, 0x000fc60000000000ULL, 0x00000013ff587e24ULL, 0x000fe4000f8e00ffULL,
0x000000000000781cULL, 0x000fe40003f0f008ULL, 0x01c6880358ff79a7ULL, 0x0003f60008500004ULL,
0x0000000000280947ULL, 0x002fea0003800000ULL, 0x00009000000d7ab9ULL, 0x000fe20000000800ULL,
0x00000001080b7899ULL, 0x000fe4000800063fULL, 0x0000000d090c7290ULL, 0x000fc8000fffe03fULL,
0x0000000d0b0b72a4ULL, 0x000fc6000f8e020cULL, 0x00008c00000c7ab9ULL, 0x000fe40000000a00ULL,
0x000000040b0c78a5ULL, 0x000fcc000f8e000cULL, 0x0000000cff027e24ULL, 0x000fe4000f8e00ffULL,
0x0000000dff037e24ULL, 0x000fca000f8e00ffULL, 0x0000000e02027981ULL, 0x000ea4000c1e1900ULL,
0x00000000021772caULL, 0x004fde00000e0000ULL, 0x00000001050b7890ULL, 0x000fe4000fffe03fULL,
0x000000070a0a7899ULL, 0x000fe4000800063fULL, 0x000000070b00728cULL, 0x000fe4000bf06070ULL,
0x00000012170b72a4ULL, 0x000fc8000f8e023fULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x000000070b0c7899ULL, 0x000fd8000800063fULL, 0x0000000400e48947ULL, 0x000fea0003800000ULL,
0x00000000000e7919ULL, 0x000e620000002600ULL, 0x00000003ff0b7819ULL, 0x000fe20000011600ULL,
0x00000008050b7899ULL, 0x000fe2000800063fULL, 0x00008a0000187ab9ULL, 0x000fc60000000a00ULL,
0x000000040b057836ULL, 0x000fe20000000000ULL, 0x0000000b1400728cULL, 0x000fe2000bf01070ULL,
0x000000080b077836ULL, 0x000fe40000000000ULL, 0x0000000105027824ULL, 0x140fe200078e0200ULL,
0x0000000b140d7287ULL, 0x000fe2000c000000ULL, 0x00000008050d7824ULL, 0x000fe400078e00ffULL,
0x0000000c0b097836ULL, 0x000fe40000000000ULL, 0x0000000107037824ULL, 0x040fe200078e0200ULL,
0xfffffff80d147812ULL, 0x000fe200078ee202ULL, 0x0000000807167824ULL, 0x000fc400078e00ffULL,
0x000000100b117836ULL, 0x000fe40000000000ULL, 0x0000000109027824ULL, 0x140fe200078e0200ULL,
0xfffffff816167812ULL, 0x000fe200078ee203ULL, 0x00000008090d7824ULL, 0x000fe400078e00ffULL,
0x000000140b177836ULL, 0x000fe40000000000ULL, 0x0000000111037824ULL, 0x040fe200078e0200ULL,
0xfffffff80d187812ULL, 0x000fe200078ee202ULL, 0x00000008111a7824ULL, 0x000fc400078e00ffULL,
0x0000000117027824ULL, 0x140fe400078e0200ULL, 0x00000008171b7824ULL, 0x000fe200078e00ffULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee203ULL, 0x0000001c0b1d7836ULL, 0x000fe40000000000ULL,
0x000000180b197836ULL, 0x000fe20000000000ULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee202ULL,
0x000000011d037824ULL, 0x040fe400078e0200ULL, 0x000000081d1e7824ULL, 0x000fc400078e00ffULL,
0x000000800e0e7824ULL, 0x002fe400078e020bULL, 0x0000000119027824ULL, 0x040fe200078e0200ULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee203ULL, 0x00000008190d7824ULL, 0x000fe200078e00ffULL,
0x0000000c0e037c10ULL, 0x000fe2000ff1e0ffULL, 0x8000000bff127e24ULL, 0x000fe2000f8e02ffULL,
0x00000004110b7291ULL, 0x000fe2000f8e683fULL, 0x000000040e047836ULL, 0x000fe20000000000ULL,
0xfffffff80d1c7812ULL, 0x000fe200078ee202ULL, 0x0000000dff0d7e24ULL, 0x000fe2000f8e00ffULL,
0x00000003110d7899ULL, 0x000fe2000800063fULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x0000001803027c11ULL, 0x040fe2000f8048ffULL, 0x000000080e067836ULL, 0x000fe20000000000ULL,
0x000000200d127446ULL, 0x000fe20003800012ULL, 0x000000140e0c7836ULL, 0x000fe20000000000ULL,
0x0000001903037c11ULL, 0x000fe200080f4c08ULL, 0x000140000b0b7890ULL, 0x000fe2000fffe03fULL,
0x0000000c040a7c10ULL, 0x000fc4000ff3e0ffULL, 0x000000120500720cULL, 0x080fe20003f06070ULL,
0x0000000c0e057836ULL, 0x000fe20000000000ULL, 0x0000000c06087c10ULL, 0x000fe2000ff5e0ffULL,
0x000000ffff137224ULL, 0x000fe200008e06ffULL, 0x000000180a047c11ULL, 0x000fe4000f8248ffULL,
0x0000000c050d7c10ULL, 0x000fe2000ff7e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200010e06ffULL,
0x0000001808067c11ULL, 0x000fe4000f8448ffULL, 0x000000190a057c11ULL, 0x000fe200088f4c13ULL,
0x000000ffff107224ULL, 0x000fe200018e06ffULL, 0x000000120700720cULL, 0x000fe20003f26070ULL,
0x000000100e0a7836ULL, 0x000fe20000000000ULL, 0x0000001908077c11ULL, 0x000fe200090f4c0fULL,
0x000000010b0f7824ULL, 0x000fe200078e0200ULL, 0x000000180d087c11ULL, 0x000fc4000f8648ffULL,
0x000000120900720cULL, 0x000fe40003f46070ULL, 0x000000190d097c11ULL, 0x000fe400098f4c10ULL,
0x0000000c0c0d7c10ULL, 0x000fe4000ff9e0ffULL, 0x0000000c0a137c10ULL, 0x000fe4000ff7e0ffULL,
0x000000070f0f7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff107224ULL, 0x000fe200020e06ffULL,
0x000000180d0c7c11ULL, 0x000fe2000f8848ffULL, 0x000000ffff207224ULL, 0x000fe200018e06ffULL,
0x00000018130a7c11ULL, 0x000fc4000f8648ffULL, 0x000000190d0d7c11ULL, 0x000fe2000a0f4c10ULL,
0x000000180e107836ULL, 0x000fe20000000000ULL, 0x000000120b00720cULL, 0x000fe20003fa6070ULL,
0x0000001c0e0e7836ULL, 0x000fe20000000000ULL, 0x00000019130b7c11ULL, 0x000fe200098f4c20ULL,
0x0000000dff137e24ULL, 0x000fe2000f8e00ffULL, 0x0ffffff80f0f7812ULL, 0x000fe400078ef800ULL,
0x0000000c10107c10ULL, 0x000fe4000ff7e0ffULL, 0x0000000b0f157c11ULL, 0x000fc4000f8e20ffULL,
0xfffffff813137812ULL, 0x000fe200078ee200ULL, 0x000000ffff0f7224ULL, 0x000fe200018e06ffULL,
0x0000000c0e1f7c10ULL, 0x000fe4000ff9e0ffULL, 0x00000018100e7c11ULL, 0x040fe2000f8c48ffULL,
0x0000001013027825ULL, 0x000fe200078e0002ULL, 0x000000121100720cULL, 0x080fe40003f66070ULL,
0x00000019100f7c11ULL, 0x000fe2000b0f4c0fULL, 0x000000ffff207224ULL, 0x000fe200020e06ffULL,
0x000000181f107c11ULL, 0x000fe2000f8848ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002157faeULL, 0x0003e2000e901c4eULL, 0x000000121700720cULL, 0x000fe20003fc6070ULL,
0x0000001013047825ULL, 0x000fe200078e0004ULL, 0x000000191f117c11ULL, 0x000fc4000a0f4c20ULL,
0x000000121900720cULL, 0x080fe20003fa6070ULL, 0x0000001013067825ULL, 0x000fe200078e0006ULL,
0x000000121d00720cULL, 0x000fe40003f86070ULL, 0x0000000b14177c11ULL, 0x000fe2000f8e20ffULL,
0x0000001013087825ULL, 0x000fe200078e0008ULL, 0x0000000b16197c11ULL, 0x000fe4000f8e20ffULL,
0x0000000b1b1b7c11ULL, 0x000fe2000f8e20ffULL, 0x0000001013027825ULL, 0x002fe200078e000cULL,
0x0000000004177faeULL, 0x0003e2000c101c4eULL, 0x0000000b1c157c11ULL, 0x000fc4000f8e20ffULL,
0x00000010130c7825ULL, 0x040fe200078e000eULL, 0x0000000006197faeULL, 0x0003e2000c901c4eULL,
0x0000000b1e1d7c11ULL, 0x000fe4000f8e20ffULL, 0x00000010130e7825ULL, 0x000fe200078e0010ULL,
0x0000000b18117c11ULL, 0x000fc6000f8e20ffULL, 0x00000010130a7825ULL, 0x000fe200078e000aULL,
0x0000000b1a137c11ULL, 0x000fe2000f8e20ffULL, 0x0000000008117faeULL, 0x0003e8000d101c4eULL,
0x000000000a137faeULL, 0x0003e8000d901c4eULL, 0x00000000021b7faeULL, 0x0003e8000f101c4eULL,
0x000000000c157faeULL, 0x0003e8000e901c4eULL, 0x000000000e1d7faeULL, 0x0003e2000e101c4eULL,
0x0000000400a07947ULL, 0x000fea0003800000ULL, 0x0000000400037811ULL, 0x040fe200078fe8ffULL,
0x00008a0000187ab9ULL, 0x000fe20000000a00ULL, 0x0000000800057811ULL, 0x040fe200078fe8ffULL,
0x00000003110d7899ULL, 0x000fe2000800063fULL, 0x0000000c00077811ULL, 0x040fe200078fe8ffULL,
0x0000000103027824ULL, 0x140fe200078e0200ULL, 0x00000010000d7811ULL, 0x040fe200078fe8ffULL,
0x0000000803097824ULL, 0x000fe200078e00ffULL, 0x00000014000f7811ULL, 0x040fe200078fe8ffULL,
0x0000000105047824ULL, 0x100fe200078e0200ULL, 0x0000001c00137811ULL, 0x040fe200078fe8ffULL,
0x00000008070b7824ULL, 0x000fe200078e00ffULL, 0xfffffff809127812ULL, 0x000fe200078ee202ULL,
0x0000000805097824ULL, 0x000fe200078e00ffULL, 0x0000001800117811ULL, 0x040fe200078fe8ffULL,
0x0000000107027824ULL, 0x100fe200078e0200ULL, 0x00000000000a7211ULL, 0x000fe200078fe8ffULL,
0x000000080f197824ULL, 0x000fe200078e00ffULL, 0xfffffff809147812ULL, 0x000fe200078ee204ULL,
0x000000080d097824ULL, 0x040fe200078e00ffULL, 0xfffffff80b167812ULL, 0x000fe200078ee202ULL,
0x000000010d027824ULL, 0x100fe200078e0200ULL, 0x00000004110b7291ULL, 0x000fe2000f8e683fULL,
0x000000010f047824ULL, 0x000fc400078e0200ULL, 0x0000000113067824ULL, 0x140fe200078e0200ULL,
0xfffffff809187812ULL, 0x000fe200078ee202ULL, 0x00000008130b7824ULL, 0x000fe200078e00ffULL,
0x0000000a00027c11ULL, 0x000fe2000f8fe8ffULL, 0x0000000a03037c36ULL, 0x000fe20008000000ULL,
0xfffffff819197812ULL, 0x000fe200078ee204ULL, 0x0000000111047824ULL, 0x040fe200078e0200ULL,
0x0000000c02087c10ULL, 0x000fe2000ff1e0ffULL, 0x0000000811097824ULL, 0x000fe200078e00ffULL,
0xfffffff80b1c7812ULL, 0x000fe200078ee206ULL, 0x0000000a05057c36ULL, 0x000fe20008000000ULL,
0x0000000c03067c10ULL, 0x000fe2000ff3e0ffULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0xfffffff8091a7812ULL, 0x000fe200078ee204ULL, 0x0000000a07077c36ULL, 0x000fe20008000000ULL,
0x0000001808027c11ULL, 0x000fe2000f8048ffULL, 0x000000ffff097224ULL, 0x000fe200008e06ffULL,
0x0000001806047c11ULL, 0x000fe2000f8248ffULL, 0x0000000a0d0d7c36ULL, 0x000fe20008000000ULL,
0x0000001908037c11ULL, 0x000fe200080f4c03ULL, 0x0000000a0f0f7c36ULL, 0x000fe20008000000ULL,
0x0000000c050b7c10ULL, 0x000fe2000ff1e0ffULL, 0x0000000a11117c36ULL, 0x000fe20008000000ULL,
0x0000001906057c11ULL, 0x000fe200088f4c09ULL, 0x0000000a13137c36ULL, 0x000fe20008000000ULL,
0x0000000c07097c10ULL, 0x000fe2000ff3e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x000000180b067c11ULL, 0x000fe2000f8048ffULL, 0x0000000dff1b7e24ULL, 0x000fe2000f8e00ffULL,
0x000140000b0b7890ULL, 0x000fe2000fffe03fULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x0000001809087c11ULL, 0x000fc4000f8248ffULL, 0x000000190b077c11ULL, 0x000fe400080f4c0eULL,
0x0000001909097c11ULL, 0x000fe400088f4c0cULL, 0x0000000c0d157c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000c0f0d7c10ULL, 0x000fe4000ff3e0ffULL, 0x000000070a0b7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff247224ULL, 0x000fe200000e06ffULL, 0x0000000c110f7c10ULL, 0x000fe2000ff5e0ffULL,
0x000000ffff227224ULL, 0x000fe200008e06ffULL, 0x0000000c13117c10ULL, 0x000fc4000ff7e0ffULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee200ULL, 0x000000ffff207224ULL, 0x000fe200010e06ffULL,
0x0ffffff80b0b7812ULL, 0x000fe200078ef800ULL, 0x000000ffff1e7224ULL, 0x000fe200018e06ffULL,
0x00000018150a7c11ULL, 0x000fe2000f8048ffULL, 0x000000101b027825ULL, 0x000fe200078e0002ULL,
0x000000180d0c7c11ULL, 0x000fe4000f8248ffULL, 0x000000180f0e7c11ULL, 0x000fe2000f8448ffULL,
0x000000101b047825ULL, 0x000fe200078e0004ULL, 0x0000001811107c11ULL, 0x000fc4000f8648ffULL,
0x0000000b0b137c11ULL, 0x000fe2000f8e20ffULL, 0x000000101b067825ULL, 0x000fe200078e0006ULL,
0x00000019150b7c11ULL, 0x000fe400080f4c24ULL, 0x000000190d0d7c11ULL, 0x000fe200088f4c22ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002137faeULL, 0x0003e2000b901c4eULL,
0x000000190f0f7c11ULL, 0x000fe200090f4c20ULL, 0x000000101b087825ULL, 0x000fe200078e0008ULL,
0x0000001911117c11ULL, 0x000fe400098f4c1eULL, 0x0000000b12157c11ULL, 0x000fe2000f8e20ffULL,
0x000000101b0a7825ULL, 0x000fe200078e000aULL, 0x0000000b14177c11ULL, 0x000fc4000f8e20ffULL,
0x0000000b19197c11ULL, 0x000fe2000f8e20ffULL, 0x000000101b0c7825ULL, 0x040fe200078e000cULL,
0x0000000004157faeULL, 0x0005e2000b901c4eULL, 0x0000000b16037c11ULL, 0x002fe4000f8e20ffULL,
0x0000000b18137c11ULL, 0x000fe2000f8e20ffULL, 0x000000101b0e7825ULL, 0x040fe200078e000eULL,
0x0000000006177faeULL, 0x0005e2000b901c4eULL, 0x0000000b1c1d7c11ULL, 0x000fe4000f8e20ffULL,
0x000000101b107825ULL, 0x000fe200078e0010ULL, 0x0000000b1a1b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000008037faeULL, 0x0005e8000b901c4eULL, 0x000000000a137faeULL, 0x0005e8000b901c4eULL,
0x000000000c197faeULL, 0x0005e8000b901c4eULL, 0x000000000e1b7faeULL, 0x0005e8000b901c4eULL,
0x00000000101d7faeULL, 0x0005e4000b901c4eULL, 0x000000070500728cULL, 0x000fe2000bf06070ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xff317217ff097424ULL, 0x006fe200078e00ffULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff027224ULL, 0x000fe200078e00ffULL,
0x00000000001c7805ULL, 0x000fe4000001ff00ULL, 0x000000000000781cULL, 0x000fe40003f0f008ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fc4000001ff00ULL,
0x0000000000267805ULL, 0x000fe4000001ff00ULL, 0x0000000000247805ULL, 0x000fe4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fc4000001ff00ULL,
0x0000000000467805ULL, 0x000fe4000001ff00ULL, 0x0000000000447805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x0000000000367805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x000000a400740947ULL, 0x000fec0003800000ULL, 0x0000000108087899ULL, 0x000fe2000800063fULL,
0xff317217ff097424ULL, 0x000fe200078e00ffULL, 0x00009000000b7ab9ULL, 0x000fe20000000800ULL,
0x000000ffff1f7224ULL, 0x000fe200078e00ffULL, 0x0000000b080872a4ULL, 0x000fd8000f8e020bULL,
0x00000008050c7899ULL, 0x000fc8000800063fULL, 0x000000140c00728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x000000a400400947ULL, 0x000fea0003800000ULL,
0x00000001050b7890ULL, 0x000fe2000fffe03fULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x000000070b00728cULL, 0x000fc6000bf06070ULL, 0x00008400000b7ab9ULL, 0x000fe40000000800ULL,
0x0000000b170b72a4ULL, 0x000fe2000f8e023fULL, 0x000000000000781cULL, 0x000fc60003f2f008ULL,
0x000000070b0d7899ULL, 0x000fc6000800063fULL, 0x00000009000b7c82ULL, 0x000fce0008000000ULL,
0x0000000400e09947ULL, 0x000fea0003800000ULL, 0x00000003ff177819ULL, 0x100fe20000011600ULL,
0x000000200a157890ULL, 0x000fe4000fffe03fULL, 0x000000200c0c7890ULL, 0x000fe4000fffe03fULL,
0x0000000417137836ULL, 0x000fe20000000000ULL, 0x00008a0000187ab9ULL, 0x000fe20000000a00ULL,
0x0000000817187836ULL, 0x000fe20000000000ULL, 0x0000000c1400728cULL, 0x000fe2000bf01070ULL,
0x0000000113037824ULL, 0x040fe400078e0200ULL, 0x0000000813087824ULL, 0x000fe200078e00ffULL,
0x0000000c14127287ULL, 0x000fe2000c000000ULL, 0x0000000c171b7836ULL, 0x000fc40000000000ULL,
0x0000000118047824ULL, 0x140fe200078e0200ULL, 0xfffffff8083d7812ULL, 0x000fe200078ee203ULL,
0x00000008180b7824ULL, 0x000fe400078e00ffULL, 0x000000011b037824ULL, 0x140fe400078e0200ULL,
0x000000081b0a7824ULL, 0x000fe200078e00ffULL, 0xfffffff80b3a7812ULL, 0x000fe200078ee204ULL,
0x0000001017387836ULL, 0x000fe40000000000ULL, 0x00000014173c7836ULL, 0x000fe20000000000ULL,
0xfffffff80a037812ULL, 0x000fe200078ee203ULL, 0x0000000138047824ULL, 0x000fc400078e0200ULL,
0x00000008380b7824ULL, 0x000fe400078e00ffULL, 0x00000015170a7c36ULL, 0x000fe40008000000ULL,
0x000000013c087824ULL, 0x140fe200078e0200ULL, 0xfffffff80b047812ULL, 0x000fe200078ee204ULL,
0x000000083c0d7824ULL, 0x000fe200078e00ffULL, 0x0000000d0a0b7c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001c173f7836ULL, 0x000fe40000000000ULL, 0x00000015130a7c36ULL, 0x000fe20008000000ULL,
0xfffffff80d087812ULL, 0x000fe200078ee208ULL, 0x000000013f0d7824ULL, 0x000fc400078e0200ULL,
0x000000083f407824ULL, 0x000fe400078e00ffULL, 0x000000ffff0c7224ULL, 0x000fe200000e06ffULL,
0x000000180b107c11ULL, 0x040fe2000f8048ffULL, 0x00000018173e7836ULL, 0x000fe20000000000ULL,
0xfffffff840407812ULL, 0x000fe200078ee20dULL, 0x8000000cff157e24ULL, 0x000fe2000f8e02ffULL,
0x000000190b117c11ULL, 0x000fe200080f4c0cULL, 0x000000013e147824ULL, 0x040fe200078e0200ULL,
0x0000000d0a0d7c10ULL, 0x000fe2000ff1e0ffULL, 0x000000083e0f7824ULL, 0x000fe200078e00ffULL,
0x00000004110c7291ULL, 0x000fe2000f8e683fULL, 0x00000015180a7c36ULL, 0x000fc40008000000ULL,
0x00000012ff127e24ULL, 0x000fe2000f8e00ffULL, 0xfffffff80f147812ULL, 0x000fe200078ee214ULL,
0x000000151b0b7c36ULL, 0x000fe20008000000ULL, 0x0000000d0a0f7c10ULL, 0x000fe2000ff5e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x000000180d0c7c11ULL, 0x040fe2000f8048ffULL,
0x000150000c0c7890ULL, 0x000fe2000fffe03fULL, 0x0000002012157446ULL, 0x000fe20003800015ULL,
0x000000ffff127224ULL, 0x000fe200010e06ffULL, 0x0000000d0b0b7c10ULL, 0x000fe4000ff7e0ffULL,
0x000000190d0d7c11ULL, 0x000fc400080f4c0eULL, 0x000000180f0e7c11ULL, 0x000fe2000f8048ffULL,
0x000000ffff167224ULL, 0x000fe200018e06ffULL, 0x000000180b0a7c11ULL, 0x000fe4000f8448ffULL,
0x000000190f0f7c11ULL, 0x000fe200080f4c12ULL, 0x0000001538127c36ULL, 0x000fe20008000000ULL,
0x000000190b0b7c11ULL, 0x000fe400090f4c16ULL, 0x000000151300720cULL, 0x080fe40003fa6070ULL,
0x000000151700720cULL, 0x040fe20003f46070ULL, 0x0000000117177824ULL, 0x000fe200078e0200ULL,
0x0000000d12137c10ULL, 0x000fc4000ff7e0ffULL, 0x000000151800720cULL, 0x000fe40003f06070ULL,
0x0000000717197812ULL, 0x000fe200078ec0ffULL, 0x000000ffff187224ULL, 0x000fe200018e06ffULL,
0x0000001813127c11ULL, 0x040fe2000f8648ffULL, 0x000000153c177c36ULL, 0x000fe20008000000ULL,
0x0000000700167812ULL, 0x000fe400078ec0ffULL, 0x0000001913137c11ULL, 0x000fe200098f4c18ULL,
0x000000153e187c36ULL, 0x000fe20008000000ULL, 0x0000000d17177c10ULL, 0x000fe2000ff7e0ffULL,
0x0000001316397c36ULL, 0x000fe20008000000ULL, 0x0ffffff819197812ULL, 0x000fc400078ef800ULL,
0x000000151b00720cULL, 0x000fe20003f86070ULL, 0x000000ffff1a7224ULL, 0x000fe200018e06ffULL,
0x0000001817167c11ULL, 0x000fe2000f8648ffULL, 0x0000001039107825ULL, 0x000fe200078e0010ULL,
0x0000000c193b7c11ULL, 0x000fe4000f8e20ffULL, 0x0000001917177c11ULL, 0x000fe200098f4c1aULL,
0x000000153f197c36ULL, 0x000fe20008000000ULL, 0x0000000d181a7c10ULL, 0x000fe2000ff7e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000103b7faeULL, 0x0003e2000d101c4eULL,
0x0000000c3d3d7c11ULL, 0x000fe2000f8e20ffULL, 0x00000010390c7825ULL, 0x000fe200078e000cULL,
0x0000000d191b7c10ULL, 0x000fc4000ff5e0ffULL, 0x000000181a187c11ULL, 0x000fe2000f8c48ffULL,
0x000000ffff197224ULL, 0x000fe200018e06ffULL, 0x000000153800720cULL, 0x080fe20003f66070ULL,
0x000000ffff387224ULL, 0x000fe200010e06ffULL, 0x000000000c3d7faeULL, 0x0005e2000e901c4eULL,
0x000000153e00720cULL, 0x080fe20003fa6070ULL, 0x00000010390e7825ULL, 0x000fe200078e000eULL,
0x000000191a197c11ULL, 0x000fe4000b0f4c19ULL, 0x000000181b1a7c11ULL, 0x000fe2000f8448ffULL,
0x0000001039107825ULL, 0x002fe200078e0016ULL, 0x000000153c00720cULL, 0x000fc40003fc6070ULL,
0x000000191b1b7c11ULL, 0x000fe200090f4c38ULL, 0x00000010390a7825ULL, 0x000fe200078e000aULL,
0x000000153f00720cULL, 0x000fe40003f46070ULL, 0x0000000c3a157c11ULL, 0x000fe2000f8e20ffULL,
0x0000001039167825ULL, 0x000fe200078e0018ULL, 0x0000000c03037c11ULL, 0x000fe4000f8e20ffULL,
0x0000000c04197c11ULL, 0x000fe2000f8e20ffULL, 0x0000001039127825ULL, 0x000fe200078e0012ULL,
0x000000000e157faeULL, 0x0003e2000c101c4eULL, 0x0000000c403b7c11ULL, 0x000fc4000f8e20ffULL,
0x00000010390c7825ULL, 0x004fe200078e001aULL, 0x0000000c081b7c11ULL, 0x000fe2000f8e20ffULL,
0x000000000a037faeULL, 0x0003e2000e101c4eULL, 0x0000000c14397c11ULL, 0x000fc6000f8e20ffULL,
0x0000000012197faeULL, 0x0003e8000d901c4eULL, 0x00000000101b7faeULL, 0x0003e8000f101c4eULL,
0x0000000016397faeULL, 0x0003e8000e901c4eULL, 0x000000000c3b7faeULL, 0x0003e2000d101c4eULL,
0x0000000400a07947ULL, 0x000fea0003800000ULL, 0x00000004000b7811ULL, 0x040fe200078fe8ffULL,
0x000000200a127890ULL, 0x000fe2000fffe03fULL, 0x00000008000f7811ULL, 0x040fe200078fe8ffULL,
0x00008a0000187ab9ULL, 0x000fe20000000a00ULL, 0x0000000c00117811ULL, 0x040fe200078fe8ffULL,
0x000000010b037824ULL, 0x140fe200078e0200ULL, 0x0000001000137811ULL, 0x040fe200078fe8ffULL,
0x000000080b387824ULL, 0x000fe200078e00ffULL, 0x0000001400157811ULL, 0x040fe200078fe8ffULL,
0x000000010f047824ULL, 0x140fe200078e0200ULL, 0x0000001800177811ULL, 0x040fe200078fe8ffULL,
0x000000080f397824ULL, 0x000fe200078e00ffULL, 0xfffffff838387812ULL, 0x000fe200078ee203ULL,
0x0000000111037824ULL, 0x140fe200078e0200ULL, 0x0000001c00197811ULL, 0x040fe200078fe8ffULL,
0x00000008113a7824ULL, 0x000fe200078e00ffULL, 0xfffffff839397812ULL, 0x000fe200078ee204ULL,
0x0000000113047824ULL, 0x140fe200078e0200ULL, 0x00000004110c7291ULL, 0x000fe2000f8e683fULL,
0x00000008133d7824ULL, 0x000fe200078e00ffULL, 0xfffffff83a3a7812ULL, 0x000fe200078ee203ULL,
0x0000000115087824ULL, 0x140fe200078e0200ULL, 0x0000001200037c11ULL, 0x040fe2000f8fe8ffULL,
0x00000008153f7824ULL, 0x000fe200078e00ffULL, 0xfffffff83d3d7812ULL, 0x000fe200078ee204ULL,
0x000000120b047c36ULL, 0x000fe20008000000ULL, 0x00000007001a7812ULL, 0x000fe200078ec0ffULL,
0x00000001170d7824ULL, 0x140fe200078e0200ULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee208ULL,
0x0000000817107824ULL, 0x000fe200078e00ffULL, 0x0000000d03087c10ULL, 0x000fe2000ff1e0ffULL,
0x00000001190e7824ULL, 0x040fe200078e0200ULL, 0x0000000d04047c10ULL, 0x000fe2000ff5e0ffULL,
0x0000000819437824ULL, 0x000fe200078e00ffULL, 0xfffffff810417812ULL, 0x000fe200078ee20dULL,
0x000000ffff0b7224ULL, 0x000fe200000e06ffULL, 0x00000018080c7c11ULL, 0x000fe2000f8048ffULL,
0x000000ffff037224ULL, 0x000fe200010e06ffULL, 0x00000018040a7c11ULL, 0x000fe2000f8448ffULL,
0x000150000c0c7890ULL, 0x000fe2000fffe03fULL, 0x00000019080d7c11ULL, 0x000fe200080f4c0bULL,
0x0000001213087c36ULL, 0x000fe20008000000ULL, 0x00000019040b7c11ULL, 0x000fe200090f4c03ULL,
0x000000120f037c36ULL, 0x000fe20008000000ULL, 0xfffffff843437812ULL, 0x000fe200078ee20eULL,
0x0000001211047c36ULL, 0x000fe20008000000ULL, 0x0000000d08087c10ULL, 0x000fe2000ff9e0ffULL,
0x00000012150e7c36ULL, 0x000fe20008000000ULL, 0x0000000d03137c10ULL, 0x000fe2000ff5e0ffULL,
0x000000131a3b7c36ULL, 0x000fe20008000000ULL, 0x0000000d04117c10ULL, 0x000fe2000ff7e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200020e06ffULL, 0x0000000d0e037c10ULL, 0x000fe2000ff1e0ffULL,
0x000000ffff187224ULL, 0x000fe200010e06ffULL, 0x0000001813147c11ULL, 0x000fe2000f8448ffULL,
0x000000ffff167224ULL, 0x000fe200018e06ffULL, 0x0000001811127c11ULL, 0x000fe2000f8648ffULL,
0x000000ffff047224ULL, 0x000fe200000e06ffULL, 0x0000001808107c11ULL, 0x000fe2000f8848ffULL,
0x000000103b0c7825ULL, 0x000fe200078e000cULL, 0x00000018030e7c11ULL, 0x000fc4000f8048ffULL,
0x0000001913157c11ULL, 0x000fe200090f4c18ULL, 0x000000103b0a7825ULL, 0x000fe200078e000aULL,
0x0000001911137c11ULL, 0x000fe400098f4c16ULL, 0x0000001908117c11ULL, 0x000fe2000a0f4c0fULL,
0x000000103b147825ULL, 0x000fe200078e0014ULL, 0x00000019030f7c11ULL, 0x000fe400080f4c04ULL,
0x0000000000167211ULL, 0x000fe200078fe8ffULL, 0x0000001217037c36ULL, 0x000fe20008000000ULL,
0x0000000c39397c11ULL, 0x000fe2000f8e20ffULL, 0x0000001219047c36ULL, 0x000fe20008000000ULL,
0x0000000716197812ULL, 0x000fe200078ec0ffULL, 0x000000103b127825ULL, 0x000fe200078e0012ULL,
0x0000000d03087c10ULL, 0x000fc4000ff1e0ffULL, 0x0000000d04047c10ULL, 0x000fe2000ff5e0ffULL,
0x000000103b107825ULL, 0x000fe200078e0010ULL, 0x0ffffff8191b7812ULL, 0x000fe400078ef800ULL,
0x0000000c3d3d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff177224ULL, 0x000fe200000e06ffULL,
0x0000001808167c11ULL, 0x000fe2000f8048ffULL, 0x000000ffff037224ULL, 0x000fe200010e06ffULL,
0x0000001804187c11ULL, 0x000fe2000f8448ffULL, 0x000000103b0e7825ULL, 0x000fe200078e000eULL,
0x0000001908177c11ULL, 0x000fc400080f4c17ULL, 0x0000001904197c11ULL, 0x000fe400090f4c03ULL,
0x0000000c1b037c11ULL, 0x000fe2000f8e20ffULL, 0x000000103b167825ULL, 0x000fe200078e0016ULL,
0x0000000c381b7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000c3f3f7c11ULL, 0x000fe2000f8e20ffULL,
0x000000103b187825ULL, 0x000fe200078e0018ULL, 0x0000000c3a3b7c11ULL, 0x000fe2000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c037faeULL, 0x0003e2000b901c4eULL,
0x0000000c41417c11ULL, 0x000fc4000f8e20ffULL, 0x0000000c43437c11ULL, 0x000fe2000f8e20ffULL,
0x000000000a1b7faeULL, 0x0003e8000b901c4eULL, 0x0000000014397faeULL, 0x0003e8000b901c4eULL,
0x00000000123b7faeULL, 0x0003e8000b901c4eULL, 0x00000000103d7faeULL, 0x0003e8000b901c4eULL,
0x000000000e3f7faeULL, 0x0003e8000b901c4eULL, 0x0000000016417faeULL, 0x0003e8000b901c4eULL,
0x0000000018437faeULL, 0x0003e4000b901c4eULL, 0x00000001ff0f7424ULL, 0x002fe200078e00ffULL,
0x00000000000079afULL, 0x000e2a0000000000ULL, 0x01c6080f580e79a7ULL, 0x0002a40008500004ULL,
0x00000000000a7805ULL, 0x000fce0000015200ULL, 0x01c6080f580075a7ULL, 0x004ea40008000144ULL,
0x00000000005c0947ULL, 0x004fea0003800000ULL, 0x000000ffff087224ULL, 0x000fce00078e00ffULL,
0x000000100800780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000000c7805ULL, 0x000fce0000015200ULL, 0x0000000c0a047210ULL, 0x000fca0007f1e1ffULL,
0x000000010d0c7824ULL, 0x000fe200000e0e0bULL, 0x003d09000400780cULL, 0x000fc80003f06070ULL,
0x000000ff0c00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400400780cULL, 0x000fc80003f06070ULL, 0x000000ff0c00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc8000001140cULL,
0x0000000403037211ULL, 0x000fca00078110ffULL, 0x000000ffff047224ULL, 0x000fca00000e060cULL,
0x0000000203037819ULL, 0x000fc80000001204ULL, 0x000000030000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000108087836ULL, 0x000fce0000000000ULL,
0x01c6080f580075a7ULL, 0x000ea40008000144ULL, 0xfffffffc00a88947ULL, 0x004fea000383ffffULL,
0x0000001000037824ULL, 0x000fe200078e00ffULL, 0x00000001ff047819ULL, 0x000fc80000011600ULL,
0x0000007003037812ULL, 0x000fe400078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ec0ffULL,
0x0000000404037c10ULL, 0x000fca000fffe003ULL, 0x01c0000003087984ULL, 0x000ea80000000800ULL,
0x01c2000003127984ULL, 0x0006e20000000800ULL, 0x000000090800720bULL, 0x004fda0003f1d000ULL,
0x0000000000047806ULL, 0x000fe400000e0100ULL, 0x000000000000781cULL, 0x000fe40003f0e170ULL,
0x0000ffff040b7812ULL, 0x000fe2000784c0ffULL, 0x000000ffff047224ULL, 0x000fd800078e0009ULL,
0x0000000000e8a947ULL, 0x00afea0003800000ULL, 0x000000090800720bULL, 0x000fe40003f54000ULL,
0x00000011ff007c0cULL, 0x000fe4000bf65270ULL, 0x0000000809047209ULL, 0x000fd20007810000ULL,
0x00000000000c7806ULL, 0x000fe400010e0100ULL, 0x01c400040300b388ULL, 0x0003e40000000800ULL,
0x000099100c0a7816ULL, 0x000fc800000000ffULL, 0x000000ff0a00720cULL, 0x000fda0003f45270ULL,
0x0000000000b0a947ULL, 0x002fea0003800000ULL, 0x8000000409097221ULL, 0x000fe20000010000ULL,
0x000000ff0cff7812ULL, 0x040fe4000784c0ffULL, 0x0000ff000cff7812ULL, 0x000fe2000786c0ffULL,
0x3fb8aa3b09097820ULL, 0x000fc80000410000ULL, 0x00000009000a7308ULL, 0x0002ac0000000800ULL,
0x000000000048a947ULL, 0x000fea0003800000ULL, 0x00000002ff097819ULL, 0x002fcc0000011600ULL,
0x00001f090a097589ULL, 0x004e6400000e0000ULL, 0x0000000934347220ULL, 0x082fe20000410000ULL,
0x0000000935357220ULL, 0x080fe20000410000ULL, 0x0000000930307220ULL, 0x080fe20000410000ULL,
0x0000000931317220ULL, 0x080fe20000410000ULL, 0x0000000944447220ULL, 0x080fe20000410000ULL,
0x0000000945457220ULL, 0x080fe20000410000ULL, 0x000000092c2c7220ULL, 0x080fe20000410000ULL,
0x000000092d2d7220ULL, 0x080fe20000410000ULL, 0x0000000928287220ULL, 0x080fe20000410000ULL,
0x0000000929297220ULL, 0x080fe20000410000ULL, 0x0000000924247220ULL, 0x080fe20000410000ULL,
0x0000000925257220ULL, 0x080fe20000410000ULL, 0x0000000920207220ULL, 0x080fe20000410000ULL,
0x0000000921217220ULL, 0x080fe20000410000ULL, 0x000000091c1c7220ULL, 0x080fe20000410000ULL,
0x000000091d1d7220ULL, 0x000fce0000410000ULL, 0x0000000a02027220ULL, 0x004fe20000410000ULL,
0x000000000048b947ULL, 0x000fec0003800000ULL, 0x0000000800097811ULL, 0x002fcc00078ff0ffULL,
0x00001f090a097589ULL, 0x000e6400000e0000ULL, 0x0000000936367220ULL, 0x082fe20000410000ULL,
0x0000000937377220ULL, 0x080fe20000410000ULL, 0x0000000932327220ULL, 0x080fe20000410000ULL,
0x0000000933337220ULL, 0x080fe20000410000ULL, 0x0000000946467220ULL, 0x080fe20000410000ULL,
0x0000000947477220ULL, 0x080fe20000410000ULL, 0x000000092e2e7220ULL, 0x080fe20000410000ULL,
0x000000092f2f7220ULL, 0x080fe20000410000ULL, 0x000000092a2a7220ULL, 0x080fe20000410000ULL,
0x000000092b2b7220ULL, 0x080fe20000410000ULL, 0x0000000926267220ULL, 0x080fe20000410000ULL,
0x0000000927277220ULL, 0x080fe20000410000ULL, 0x0000000922227220ULL, 0x080fe20000410000ULL,
0x0000000923237220ULL, 0x080fe20000410000ULL, 0x000000091e1e7220ULL, 0x080fe20000410000ULL,
0x000000091f1f7220ULL, 0x000fce0000410000ULL, 0x0000ffff0bff7812ULL, 0x000fda000784600cULL,
0x8000000408082221ULL, 0x000fe20000010000ULL, 0x000000000000281cULL, 0x000fc60003f0f070ULL,
0x3fb8aa3b08082820ULL, 0x000fc80000410000ULL, 0x0000000800052308ULL, 0x000ea40000000800ULL,
0x0000000512122220ULL, 0x004fce0000410000ULL, 0x0000000700597812ULL, 0x000fe200078ec0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000000859097812ULL, 0x002fe400078ef800ULL,
0x00000008000b7812ULL, 0x040fe400078ec0ffULL, 0x0000000900087211ULL, 0x000fe200078fe0ffULL,
0x00000008090d7824ULL, 0x000fe200078e00ffULL, 0x000000070b0b7812ULL, 0x000fc800078ef800ULL,
0xfffffff80d4e7812ULL, 0x000fe200078ee208ULL, 0x000000080b0f7824ULL, 0x000fe200078e00ffULL,
0x0000000b000c7211ULL, 0x000fe400078fe0ffULL, 0x000000044e4e7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000000188947ULL, 0x000fec0003800000ULL, 0x00000002ff0d7819ULL, 0x000fe40000011600ULL,
0x00000005ff06723eULL, 0x000fc600000010ffULL, 0x000000080d077836ULL, 0x000fe20000000000ULL,
0x00005410060a7816ULL, 0x000fca0000000006ULL, 0x00001f0d0a067589ULL, 0x0002a800000e0000ULL,
0x00001f070a077589ULL, 0x0002e400000e0000ULL, 0x012000004e14783bULL, 0x0002e20000000200ULL,
0x0000000000108947ULL, 0x000fea0003800000ULL, 0x0000000614147232ULL, 0x08cfe40000200000ULL,
0x0000000616167232ULL, 0x000fe40000200000ULL, 0x0000000715157232ULL, 0x080fe40000200000ULL,
0x0000000717177232ULL, 0x000fce0000200000ULL, 0x000000080b0a7824ULL, 0x042fe200078e00ffULL,
0x00000004110c7291ULL, 0x000fe2000f8e683fULL, 0x000000040c117836ULL, 0x000fe20000000000ULL,
0xfffffff80f0f7812ULL, 0x000fe200078ee20cULL, 0x000000080b0d7824ULL, 0x040fe200078e00ffULL,
0x000140000c187890ULL, 0x000fe2000fffe03fULL, 0x000000020c107836ULL, 0x000fe20000000000ULL,
0xfffffff80a117812ULL, 0x000fe200078ee211ULL, 0x000000060c0a7836ULL, 0x000fe20000000000ULL,
0x000000100b0b7812ULL, 0x000fe200078efcffULL, 0x0000000809557824ULL, 0x000fe200078e00ffULL,
0xfffffff80d107812ULL, 0x000fe200078ee210ULL, 0x00000002080c7836ULL, 0x000fe20000000000ULL,
0xfffffff80d0a7812ULL, 0x000fe200078ee20aULL, 0x000000080b137824ULL, 0x000fe200078e00ffULL,
0x0000001811527c11ULL, 0x000fc4000f8e20ffULL, 0x000000180a537c11ULL, 0x000fe4000f8e20ffULL,
0x000000180f4d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000005238783bULL, 0x000e620000004200ULL,
0x0000001810507c11ULL, 0x000fe4000f8e20ffULL, 0xfffffff855557812ULL, 0x000fe200078ee20cULL,
0x000000005318783bULL, 0x000f220000004200ULL, 0x0000000b000c7211ULL, 0x000fe400078fe0ffULL,
0x0000000455557c11ULL, 0x000fe2000f8e20ffULL, 0x000000004d40783bULL, 0x000f640000004200ULL,
0x000000020c0e7836ULL, 0x000fc40000000000ULL, 0x00000000503c783bULL, 0x000f620000004200ULL,
0x000000040c0d7836ULL, 0x000fe20000000000ULL, 0x000000381428723cULL, 0x00afec0000041828ULL,
0x000000181420723cULL, 0x010fe20000041820ULL, 0x000000080b387824ULL, 0x000fca00078e00ffULL,
0x0000001a141c723cULL, 0x000fe2000004181cULL, 0x000000080b197824ULL, 0x040fe400078e00ffULL,
0x000000080b187824ULL, 0x000fe400078e00ffULL, 0x000000060c0b7836ULL, 0x000fe20000000000ULL,
0xfffffff8130c7812ULL, 0x000fe200078ee20cULL, 0x000000401434723cULL, 0x020fe20000041834ULL,
0xfffffff8190e7812ULL, 0x000fe400078ee20eULL, 0xfffffff8180d7812ULL, 0x000fc400078ee20dULL,
0x012000005518783bULL, 0x0002e20000000200ULL, 0x000000421430723cULL, 0x000fe20000041830ULL,
0xfffffff8380b7812ULL, 0x000fe400078ee20bULL, 0x000000180e517c11ULL, 0x000fe4000f8e20ffULL,
0x000000180d4f7c11ULL, 0x000fe2000f8e20ffULL, 0x0000003c1444723cULL, 0x004fe20000041844ULL,
0x000000180c547c11ULL, 0x000fca000f8e20ffULL, 0x0000003e142c723cULL, 0x000fec000004182cULL,
0x0000003a1424723cULL, 0x000fe20000041824ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000108947ULL, 0x002fde0003800000ULL, 0x0000000618187232ULL, 0x088fe40000200000ULL,
0x000000061a1a7232ULL, 0x000fe40000200000ULL, 0x0000000719197232ULL, 0x080fe40000200000ULL,
0x000000071b1b7232ULL, 0x000fce0000200000ULL, 0x000000180b4c7c11ULL, 0x000fe2000f8e20ffULL,
0x000000005114783bULL, 0x000e620000004200ULL, 0x0000000212027221ULL, 0x000fc60000010000ULL,
0x000000004f38783bULL, 0x000ea80000004200ULL, 0x00000000543c783bULL, 0x000f280000004200ULL,
0x000000004c40783bULL, 0x000f620000004200ULL, 0x000000141844723cULL, 0x00afec0000041844ULL,
0x00000016182c723cULL, 0x000fec000004182cULL, 0x000000381828723cULL, 0x004fec0000041828ULL,
0x0000003a1824723cULL, 0x000fec0000041824ULL, 0x0000003c1834723cULL, 0x010fec0000041834ULL,
0x0000003e1830723cULL, 0x000fec0000041830ULL, 0x000000401820723cULL, 0x020fec0000041820ULL,
0x00000042181c723cULL, 0x000fe2000004181cULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000400d49947ULL, 0x000fde0003800000ULL,
0x00000003ff197819ULL, 0x100fe20000011600ULL, 0x000000400a167890ULL, 0x000fe4000fffe03fULL,
0x0000004005127891ULL, 0x000fe4000f8e403fULL, 0x00000004191b7836ULL, 0x000fe20000000000ULL,
0x00008a00001a7ab9ULL, 0x000fe20000000a00ULL, 0x0000000819577836ULL, 0x000fe20000000000ULL,
0x000000121400728cULL, 0x000fe2000bf01070ULL, 0x000000011b127824ULL, 0x040fe400078e0200ULL,
0x000000081b3d7824ULL, 0x000fe200078e00ffULL, 0x0000001214157287ULL, 0x000fe2000c000000ULL,
0x00000014193f7836ULL, 0x000fc40000000000ULL, 0x0000000157567824ULL, 0x140fe200078e0200ULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee212ULL, 0x0000000857137824ULL, 0x000fe400078e00ffULL,
0x000000013f417824ULL, 0x100fe200078e0200ULL, 0x000000183d5d7c11ULL, 0x000fe2000f8e20ffULL,
0x000000083f127824ULL, 0x000fe200078e00ffULL, 0xfffffff813567812ULL, 0x000fe200078ee256ULL,
0x0000000c195b7836ULL, 0x000fe40000000000ULL, 0x00000010194b7836ULL, 0x000fe20000000000ULL,
0xfffffff812417812ULL, 0x000fe200078ee241ULL, 0x000000015b3e7824ULL, 0x040fe200078e0200ULL,
0x00000018565f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000085b137824ULL, 0x000fe200078e00ffULL,
0x0000001841417c11ULL, 0x000fe2000f8e20ffULL, 0x0000001619127c36ULL, 0x000fc40008000000ULL,
0x000000014b407824ULL, 0x040fe200078e0200ULL, 0xfffffff8133e7812ULL, 0x000fe200078ee23eULL,
0x000000084b157824ULL, 0x000fe200078e00ffULL, 0x0000000d12137c10ULL, 0x000fe2000ff5e0ffULL,
0x000000161b127c36ULL, 0x000fe40008000000ULL, 0x0000001819437836ULL, 0x000fe20000000000ULL,
0xfffffff815407812ULL, 0x000fe200078ee240ULL, 0x000000ffff147224ULL, 0x000fe200010e06ffULL,
0x0000001a133a7c11ULL, 0x000fe2000f8448ffULL, 0x0000001c19497836ULL, 0x000fc40000000000ULL,
0x0000000143427824ULL, 0x000fe200078e0200ULL, 0x0000001b133b7c11ULL, 0x000fe200090f4c14ULL,
0x0000000843157824ULL, 0x000fe200078e00ffULL, 0x0000000d12147c10ULL, 0x000fe2000ff5e0ffULL,
0x0000000149487824ULL, 0x040fe400078e0200ULL, 0x0000000849177824ULL, 0x000fe200078e00ffULL,
0xfffffff815427812ULL, 0x000fe200078ee242ULL, 0x80000012ff4a7e24ULL, 0x000fe4000f8e02ffULL,
0x00000015ff137e24ULL, 0x000fe2000f8e00ffULL, 0xfffffff817487812ULL, 0x000fe200078ee248ULL,
0x0000001657127c36ULL, 0x000fc40008000000ULL, 0x000000ffff177224ULL, 0x000fe200010e06ffULL,
0x00000020134a7446ULL, 0x000fe2000380004aULL, 0x000000165b137c36ULL, 0x000fe20008000000ULL,
0x0000000d12157c10ULL, 0x000fe2000ff9e0ffULL, 0x000000164b127c36ULL, 0x000fe20008000000ULL,
0x0000001a14387c11ULL, 0x040fe2000f8448ffULL, 0x00000001193c7824ULL, 0x000fe200078e0200ULL,
0x0000000d13137c10ULL, 0x000fe2000ffbe0ffULL, 0x000000ffff187224ULL, 0x000fe200020e06ffULL,
0x0000001b14397c11ULL, 0x000fe400090f4c17ULL, 0x0000001a151a7c11ULL, 0x000fe2000f8448ffULL,
0x000000ffff167224ULL, 0x000fe200028e06ffULL, 0x0000004a1b00720cULL, 0x000fc40003f66070ULL,
0x0000001b151b7c11ULL, 0x000fe200090f4c18ULL, 0x000000163f187c36ULL, 0x000fe20008000000ULL,
0x0000000d12127c10ULL, 0x000fe4000ff5e0ffULL, 0x0000001a13147c11ULL, 0x000fe4000f8848ffULL,
0x0000004a5700720cULL, 0x000fe20003fa6070ULL, 0x000000ffff177224ULL, 0x000fe200010e06ffULL,
0x0000001b13157c11ULL, 0x000fe2000a0f4c16ULL, 0x0000001643577c36ULL, 0x000fe20008000000ULL,
0x0000001a12167c11ULL, 0x000fc4000f8c48ffULL, 0x0ffffff800137812ULL, 0x000fe400078ec0ffULL,
0x0000004a1900720cULL, 0x080fe40003f86070ULL, 0x0000001b12177c11ULL, 0x000fe2000b0f4c17ULL,
0x0000001359127c36ULL, 0x000fe20008000000ULL, 0x00000007133c7812ULL, 0x000fe400078ef83cULL,
0x0000004a5b00720cULL, 0x000fe20003f46070ULL, 0x00000010123a7825ULL, 0x000fe200078e003aULL,
0x000000183c5b7c11ULL, 0x000fc4000f8e20ffULL, 0x0000000d18197c10ULL, 0x000fe2000ffde0ffULL,
0x00000010123c7825ULL, 0x040fe400078e0038ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a5b7faeULL, 0x0003e2000e101c4eULL, 0x0000000d57397c10ULL, 0x000fe2000ff9e0ffULL,
0x000000ffff5a7224ULL, 0x000fe200030e06ffULL, 0x0000001a19187c11ULL, 0x040fe2000f8c48ffULL,
0x0000001649387c36ULL, 0x000fe20008000000ULL, 0x000000003c5d7faeULL, 0x0005e2000d901c4eULL,
0x000000ffff567224ULL, 0x000fe200020e06ffULL, 0x0000001b19197c11ULL, 0x000fe2000b0f4c5aULL,
0x00000010121a7825ULL, 0x000fe200078e001aULL, 0x0000000d38577c10ULL, 0x000fc4000ff7e0ffULL,
0x0000001a39387c11ULL, 0x000fe2000f8c48ffULL, 0x0000001012147825ULL, 0x040fe200078e0014ULL,
0x0000004a4b00720cULL, 0x080fe20003f86070ULL, 0x000000001a5f7faeULL, 0x0007e2000e901c4eULL,
0x0000001b39397c11ULL, 0x000fe2000b0f4c56ULL, 0x000000ffff567224ULL, 0x000fe200018e06ffULL,
0x0000001a573a7c11ULL, 0x002fe2000f8648ffULL, 0x0000001012167825ULL, 0x040fe200078e0016ULL,
0x0000004a3f00720cULL, 0x080fe40003fc6070ULL, 0x0000004a4300720cULL, 0x000fe20003fa6070ULL,
0x0000001012187825ULL, 0x000fe200078e0018ULL, 0x0000001b573b7c11ULL, 0x000fc400098f4c56ULL,
0x0000004a4900720cULL, 0x000fe20003f66070ULL, 0x0000001012387825ULL, 0x000fe200078e0038ULL,
0x000000183e3d7c11ULL, 0x004fe4000f8e20ffULL, 0x00000018403f7c11ULL, 0x000fe2000f8e20ffULL,
0x00000010123a7825ULL, 0x000fe200078e003aULL, 0x0000001842437c11ULL, 0x000fe2000f8e20ffULL,
0x00000000143d7faeULL, 0x0007e2000d101c4eULL, 0x0000001848497c11ULL, 0x000fc6000f8e20ffULL,
0x00000000163f7faeULL, 0x0007e8000e101c4eULL, 0x0000000018417faeULL, 0x0007e8000f101c4eULL,
0x0000000038437faeULL, 0x0007e8000e901c4eULL, 0x000000003a497faeULL, 0x0007e2000d901c4eULL,
0x0000000400947947ULL, 0x000fea0003800000ULL, 0x0000000c00197811ULL, 0x040fe200078fe8ffULL,
0x000000400a127890ULL, 0x000fe2000fffe03fULL, 0x0000000800157811ULL, 0x040fe200078fe8ffULL,
0x00008a00001a7ab9ULL, 0x000fe20000000a00ULL, 0x0000001c004b7811ULL, 0x040fe200078fe8ffULL,
0x0000000119487824ULL, 0x140fe200078e0200ULL, 0x0000000400137811ULL, 0x040fe200078fe8ffULL,
0x0000000819397824ULL, 0x000fe200078e00ffULL, 0x00000010001b7811ULL, 0x040fe200078fe8ffULL,
0x0000000115127824ULL, 0x140fe200078e0200ULL, 0x0000001800497811ULL, 0x040fe200078fe8ffULL,
0x0000000815577824ULL, 0x000fe200078e00ffULL, 0xfffffff839487812ULL, 0x000fe200078ee248ULL,
0x000000014b437824ULL, 0x140fe200078e0200ULL, 0x0000001400397811ULL, 0x040fe200078fe8ffULL,
0x000000084b147824ULL, 0x000fe200078e00ffULL, 0xfffffff857577812ULL, 0x000fe200078ee212ULL,
0x00000001131a7824ULL, 0x100fe200078e0200ULL, 0x0000000000567211ULL, 0x000fe200078fe8ffULL,
0x0000000139417824ULL, 0x140fe200078e0200ULL, 0xfffffff814437812ULL, 0x000fe200078ee243ULL,
0x0000000839127824ULL, 0x000fe200078e00ffULL, 0x0000001857577c11ULL, 0x000fe2000f8e20ffULL,
0x0000001215147c36ULL, 0x000fe20008000000ULL, 0x00000018485b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000813177824ULL, 0x000fe200078e00ffULL, 0xfffffff812417812ULL, 0x000fe200078ee241ULL,
0x0000001213137c36ULL, 0x000fe20008000000ULL, 0x0000001200127c11ULL, 0x000fe2000f8fe8ffULL,
0x000000011b407824ULL, 0x140fe200078e0200ULL, 0x0000000d14147c10ULL, 0x000fe2000ff9e0ffULL,
0x000000081b3b7824ULL, 0x000fe200078e00ffULL, 0xfffffff8171a7812ULL, 0x000fe200078ee21aULL,
0x0000000149427824ULL, 0x040fe200078e0200ULL, 0x0000000d12167c10ULL, 0x000fe2000ff5e0ffULL,
0x0000000849177824ULL, 0x000fe200078e00ffULL, 0x0000000d13127c10ULL, 0x000fe2000ff7e0ffULL,
0x000000ffff137224ULL, 0x000fe200020e06ffULL, 0x0000001a143a7c11ULL, 0x000fc4000f8848ffULL,
0xfffffff83b407812ULL, 0x000fe200078ee240ULL, 0x000000ffff157224ULL, 0x000fe200018e06ffULL,
0xfffffff817427812ULL, 0x000fe200078ee242ULL, 0x000000ffff177224ULL, 0x000fe200010e06ffULL,
0x0000001a123c7c11ULL, 0x000fe4000f8648ffULL, 0x0000001b143b7c11ULL, 0x000fe2000a0f4c13ULL,
0x000000121b137c36ULL, 0x000fe20008000000ULL, 0x0000001a163e7c11ULL, 0x000fe2000f8448ffULL,
0x0000001239147c36ULL, 0x000fe20008000000ULL, 0x0000001b123d7c11ULL, 0x000fe200098f4c15ULL,
0x0000001219127c36ULL, 0x000fe20008000000ULL, 0x0000001b163f7c11ULL, 0x000fe200090f4c17ULL,
0x00000012491b7c36ULL, 0x000fe20008000000ULL, 0x0000000d13177c10ULL, 0x000fc4000ff7e0ffULL,
0x0000000d12157c10ULL, 0x000fe4000ff5e0ffULL, 0x0000000d14127c10ULL, 0x000fe2000ff9e0ffULL,
0x000000ffff387224ULL, 0x000fe200018e06ffULL, 0x0000001a17167c11ULL, 0x000fe2000f8648ffULL,
0x000000ffff4a7224ULL, 0x000fe200010e06ffULL, 0x0000001a15147c11ULL, 0x000fe2000f8448ffULL,
0x000000ffff197224ULL, 0x000fe200020e06ffULL, 0x0000001b17177c11ULL, 0x000fe200098f4c38ULL,
0x000000124b387c36ULL, 0x000fe20008000000ULL, 0x0ffffff800137812ULL, 0x000fc400078ec0ffULL,
0x0000001b15157c11ULL, 0x000fe400090f4c4aULL, 0x0000001a12187c11ULL, 0x040fe4000f8848ffULL,
0x0000000713567812ULL, 0x000fe400078ef856ULL, 0x0000000d1b1b7c10ULL, 0x000fe4000ff5e0ffULL,
0x0000000d38397c10ULL, 0x000fe4000ff7e0ffULL, 0x0000001b12197c11ULL, 0x000fe2000a0f4c19ULL,
0x0000001359127c36ULL, 0x000fe20008000000ULL, 0x0000001856497c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff567224ULL, 0x000fe200010e06ffULL, 0x000000181a4b7c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff4a7224ULL, 0x000fe200018e06ffULL, 0x0000001a1b1a7c11ULL, 0x000fe2000f8448ffULL,
0x00000010123e7825ULL, 0x000fe200078e003eULL, 0x0000001a39387c11ULL, 0x000fc4000f8648ffULL,
0x0000001b1b1b7c11ULL, 0x000fe200090f4c56ULL, 0x00000010123c7825ULL, 0x000fe200078e003cULL,
0x0000001b39397c11ULL, 0x000fe200098f4c4aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e497faeULL, 0x0003e2000b901c4eULL, 0x00000018405d7c11ULL, 0x000fe2000f8e20ffULL,
0x00000010123a7825ULL, 0x000fe200078e003aULL, 0x0000001841417c11ULL, 0x000fe2000f8e20ffULL,
0x000000003c4b7faeULL, 0x0003e2000b901c4eULL, 0x00000018425f7c11ULL, 0x000fe2000f8e20ffULL,
0x0000001012147825ULL, 0x040fe200078e0014ULL, 0x0000001843437c11ULL, 0x000fe2000f8e20ffULL,
0x000000003a577faeULL, 0x0003e4000b901c4eULL, 0x0000001012167825ULL, 0x000fc400078e0016ULL,
0x00000000145b7faeULL, 0x0003e4000b901c4eULL, 0x0000001012187825ULL, 0x040fe400078e0018ULL,
0x00000000165d7faeULL, 0x0003e4000b901c4eULL, 0x00000010121a7825ULL, 0x040fe400078e001aULL,
0x0000000018417faeULL, 0x0003e4000b901c4eULL, 0x0000001012387825ULL, 0x000fc400078e0038ULL,
0x000000001a5f7faeULL, 0x0003e8000b901c4eULL, 0x0000000038437faeULL, 0x0003e4000b901c4eULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000408147836ULL, 0x00afe40000000000ULL,
0x0000000809157824ULL, 0x000fca00078e00ffULL, 0xfffffff815147812ULL, 0x000fc800078ee214ULL,
0x00000004144b7c11ULL, 0x000fe2000f8e20ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000000188947ULL, 0x000fea0003800000ULL, 0x00000002ff157819ULL, 0x000fe40000011600ULL,
0x00000005ff06723eULL, 0x000fc600000010ffULL, 0x0000000815077836ULL, 0x000fe20000000000ULL,
0x0000541006147816ULL, 0x000fca0000000006ULL, 0x00001f1514067589ULL, 0x0002a800000e0000ULL,
0x00001f0714077589ULL, 0x0002e400000e0000ULL, 0x012000004b14783bULL, 0x0022e20000000200ULL,
0x0000000000108947ULL, 0x000fea0003800000ULL, 0x0000000614147232ULL, 0x08cfe40000200000ULL,
0x0000000616167232ULL, 0x000fe40000200000ULL, 0x0000000715157232ULL, 0x080fe40000200000ULL,
0x0000000717177232ULL, 0x000fce0000200000ULL, 0x000150000c167890ULL, 0x000fe2000fffe03fULL,
0x0000000608087836ULL, 0x000fe40000000000ULL, 0x0000000809097824ULL, 0x000fc600078e00ffULL,
0x000000160f4a7c11ULL, 0x000fe4000f8e20ffULL, 0x0000001610497c11ULL, 0x000fe4000f8e20ffULL,
0x0000001611487c11ULL, 0x000fe2000f8e20ffULL, 0x000000004a40783bULL, 0x000f220000004200ULL,
0x000000160a0f7c11ULL, 0x000fe4000f8e20ffULL, 0xfffffff809087812ULL, 0x000fe200078ee208ULL,
0x000000004918783bULL, 0x000f620000004200ULL, 0x000000160c0c7c11ULL, 0x000fc4000f8e20ffULL,
0x0000000408087c11ULL, 0x000fe2000f8e20ffULL, 0x000000004838783bULL, 0x000f620000004200ULL,
0x000000160e0e7c11ULL, 0x000fe4000f8e20ffULL, 0x000000160d0d7c11ULL, 0x000fe2000f8e20ffULL,
0x000000000f3c783bULL, 0x000f620000004200ULL, 0x000000401434723cULL, 0x018fec0000041834ULL,
0x000000421430723cULL, 0x000fec0000041830ULL, 0x000000181444723cULL, 0x022fec0000041844ULL,
0x0000001a142c723cULL, 0x000fec000004182cULL, 0x000000381428723cULL, 0x000fec0000041828ULL,
0x0000003a1424723cULL, 0x000fec0000041824ULL, 0x0000003c1420723cULL, 0x004fec0000041820ULL,
0x0000003e141c723cULL, 0x000fe2000004181cULL, 0x012000000814783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000108947ULL, 0x000fde0003800000ULL,
0x0000000614147232ULL, 0x084fe40000200000ULL, 0x0000000616167232ULL, 0x000fe40000200000ULL,
0x0000000715157232ULL, 0x080fe40000200000ULL, 0x0000000717177232ULL, 0x000fce0000200000ULL,
0x000000160b0b7c11ULL, 0x000fe2000f8e20ffULL, 0x000000000c40783bULL, 0x000ee20000004200ULL,
0x00000040050c7891ULL, 0x000fe2000f8e403fULL, 0x00000001ff117424ULL, 0x000fe400078e00ffULL,
0x000000000e3c783bULL, 0x000f220000004200ULL, 0x000000140c00728cULL, 0x000fe2000bf06070ULL,
0x000000ffff097224ULL, 0x000fe400078e0004ULL, 0x000000000d38783bULL, 0x000f660000004200ULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x000000000b18783bULL, 0x000f220000004200ULL,
0x01c68811ffff79a7ULL, 0x0007e40008500004ULL, 0x000000401434723cULL, 0x00cfec0000041834ULL,
0x000000421430723cULL, 0x000fec0000041830ULL, 0x0000003c1444723cULL, 0x010fec0000041844ULL,
0x0000003e142c723cULL, 0x000fec000004182cULL, 0x000000381428723cULL, 0x022fec0000041828ULL,
0x0000003a1424723cULL, 0x000fec0000041824ULL, 0x000000181420723cULL, 0x000fec0000041820ULL,
0x0000001a141c723cULL, 0x000fe2000004181cULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x00000078000c0947ULL, 0x000fde0003800000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000400c89947ULL, 0x000fea0003800000ULL, 0x00000003ff1b7819ULL, 0x100fe20000011600ULL,
0x000000200c0c7890ULL, 0x000fe4000fffe03fULL, 0x000000600a157890ULL, 0x000fe4000fffe03fULL,
0x000000041b3d7836ULL, 0x000fe20000000000ULL, 0x0000000c1400728cULL, 0x000fe2000bf01070ULL,
0x000000011b0a7824ULL, 0x100fe400078e0200ULL, 0x000000013d3c7824ULL, 0x040fe200078e0200ULL,
0x0000000c14127287ULL, 0x000fe2000c000000ULL, 0x000000083d097824ULL, 0x000fe200078e00ffULL,
0x00000007133f7812ULL, 0x000fe200078ef80aULL, 0x0000000c1b197836ULL, 0x000fc40000000000ULL,
0x000000101b5d7836ULL, 0x000fe20000000000ULL, 0xfffffff8093c7812ULL, 0x000fe200078ee23cULL,
0x0000000119137824ULL, 0x100fe200078e0200ULL, 0x000000163f617c11ULL, 0x000fe2000f8e20ffULL,
0x0000000819147824ULL, 0x000fe400078e00ffULL, 0x000000015d107824ULL, 0x040fe400078e0200ULL,
0x000000085d097824ULL, 0x000fe200078e00ffULL, 0xfffffff814137812ULL, 0x000fe200078ee213ULL,
0x000000081b5f7836ULL, 0x000fc40000000000ULL, 0x000000181b577836ULL, 0x000fe20000000000ULL,
0xfffffff809107812ULL, 0x000fe200078ee210ULL, 0x000000015f417824ULL, 0x100fe200078e0200ULL,
0x0000001613137c11ULL, 0x000fe2000f8e20ffULL, 0x000000085f0a7824ULL, 0x000fe400078e00ffULL,
0x0000000157097824ULL, 0x040fe400078e0200ULL, 0x0000000857147824ULL, 0x000fe200078e00ffULL,
0xfffffff80a417812ULL, 0x000fe200078ee241ULL, 0x000000141b5b7836ULL, 0x000fc40000000000ULL,
0x8000000cff427e24ULL, 0x000fe2000f8e02ffULL, 0xfffffff814097812ULL, 0x000fe200078ee209ULL,
0x000000015b0a7824ULL, 0x100fe200078e0200ULL, 0x0000001641417c11ULL, 0x000fe2000f8e20ffULL,
0x000000085b157824ULL, 0x000fe200078e00ffULL, 0x0000001609097c11ULL, 0x000fe2000f8e20ffULL,
0x000000151b147c36ULL, 0x000fe40008000000ULL, 0x00000012ff177e24ULL, 0x000fe2000f8e00ffULL,
0xfffffff8150a7812ULL, 0x000fe200078ee20aULL, 0x0000001c1b437836ULL, 0x000fe20000000000ULL,
0x0000000d14167c10ULL, 0x000fe2000ff1e0ffULL, 0x000000153d157c36ULL, 0x000fe20008000000ULL,
0x0000002017427446ULL, 0x000fe20003800042ULL, 0x0000000143407824ULL, 0x000fc400078e0200ULL,
0x0000000843397824ULL, 0x000fe200078e00ffULL, 0x0000000d15157c10ULL, 0x000fe2000ff5e0ffULL,
0x000000ffff177224ULL, 0x000fe200000e06ffULL, 0x0000001a16387c11ULL, 0x040fe2000f8048ffULL,
0x000000155f147c36ULL, 0x000fe20008000000ULL, 0xfffffff839407812ULL, 0x000fe200078ee240ULL,
0x000000ffff187224ULL, 0x000fe200010e06ffULL, 0x0000001b16397c11ULL, 0x000fe400080f4c17ULL,
0x0000000d14167c10ULL, 0x000fe2000ff1e0ffULL, 0x0000001519147c36ULL, 0x000fe20008000000ULL,
0x0000001a153a7c11ULL, 0x000fc4000f8648ffULL, 0x000000421b00720cULL, 0x080fe20003f46070ULL,
0x000000ffff177224ULL, 0x000fe200000e06ffULL, 0x0000001b153b7c11ULL, 0x000fe200098f4c18ULL,
0x000000155d157c36ULL, 0x000fe20008000000ULL, 0x0000001a161a7c11ULL, 0x040fe4000f8048ffULL,
0x0000000d143e7c10ULL, 0x000fe4000ff7e0ffULL, 0x0000001b161b7c11ULL, 0x000fe200080f4c17ULL,
0x000000155b177c36ULL, 0x000fe20008000000ULL, 0x0000000d15187c10ULL, 0x000fe2000ff1e0ffULL,
0x000000ffff157224ULL, 0x000fe200018e06ffULL, 0x0000001a3e147c11ULL, 0x000fe2000f8648ffULL,
0x00000010121a7825ULL, 0x000fe200078e001aULL, 0x000000423d00720cULL, 0x000fc40003fa6070ULL,
0x0000001b3e157c11ULL, 0x000fe200098f4c15ULL, 0x000000ffff3d7224ULL, 0x000fe200000e06ffULL,
0x0000000d17567c10ULL, 0x000fe2000ff7e0ffULL, 0x00000010123e7825ULL, 0x000fe200078e0038ULL,
0x0000001a18167c11ULL, 0x040fe4000f8848ffULL, 0x000000425f00720cULL, 0x080fe20003f06070ULL,
0x000000ffff5f7224ULL, 0x000fe200018e06ffULL, 0x0000001b18177c11ULL, 0x000fe2000a0f4c3dULL,
0x00000015573d7c36ULL, 0x000fe20008000000ULL, 0x0000001a56187c11ULL, 0x040fe2000f8648ffULL,
0x0000001543387c36ULL, 0x000fe20008000000ULL, 0x000000421900720cULL, 0x000fe20003f86070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e617faeULL, 0x0003e2000d101c4eULL,
0x0000001b56197c11ULL, 0x000fe200098f4c5fULL, 0x0000001012147825ULL, 0x000fe200078e0014ULL,
0x0000000d3d397c10ULL, 0x000fc4000ff7e0ffULL, 0x0000000d38567c10ULL, 0x000fe2000ff5e0ffULL,
0x0000001012167825ULL, 0x000fe200078e0016ULL, 0x000000163c5f7c11ULL, 0x000fe4000f8e20ffULL,
0x0000001a39387c11ULL, 0x000fe2000f8c48ffULL, 0x000000ffff5a7224ULL, 0x000fe200018e06ffULL,
0x000000425d00720cULL, 0x080fe20003f66070ULL, 0x00000010123c7825ULL, 0x000fe200078e003aULL,
0x000000160a3f7c11ULL, 0x002fe4000f8e20ffULL, 0x0000001b39397c11ULL, 0x000fe2000b0f4c5aULL,
0x000000ffff3b7224ULL, 0x000fe200010e06ffULL, 0x0000001a563a7c11ULL, 0x000fe2000f8448ffULL,
0x000000003c5f7faeULL, 0x0003e2000e901c4eULL, 0x000000425b00720cULL, 0x080fe20003fc6070ULL,
0x0000001012187825ULL, 0x000fe200078e0018ULL, 0x000000425700720cULL, 0x080fe20003fa6070ULL,
0x000000001a417faeULL, 0x0005e2000c101c4eULL, 0x0000001b563b7c11ULL, 0x000fe200090f4c3bULL,
0x0000001012387825ULL, 0x000fe200078e0038ULL, 0x000000424300720cULL, 0x000fe20003f46070ULL,
0x0000000014137faeULL, 0x0005e2000e101c4eULL, 0x0000001640437c11ULL, 0x000fe2000f8e20ffULL,
0x00000010123a7825ULL, 0x000fe200078e003aULL, 0x00000016103d7c11ULL, 0x002fca000f8e20ffULL,
0x00000000163d7faeULL, 0x0005e8000d901c4eULL, 0x00000000183f7faeULL, 0x0005e8000f101c4eULL,
0x0000000038097faeULL, 0x0005e8000e901c4eULL, 0x000000003a437faeULL, 0x0005e2000d101c4eULL,
0x0000000400887947ULL, 0x000fea0003800000ULL, 0x0000000400157811ULL, 0x040fe200078fe8ffULL,
0x000000600a0c7890ULL, 0x000fe2000fffe03fULL, 0x0000001c005f7811ULL, 0x040fe400078fe8ffULL,
0x00000000000a7211ULL, 0x040fe200078fe8ffULL, 0x0000000115427824ULL, 0x140fe200078e0200ULL,
0x0000000800177811ULL, 0x040fe200078fe8ffULL, 0x0000000815097824ULL, 0x000fe200078e00ffULL,
0x0000001000577811ULL, 0x040fe200078fe8ffULL, 0x000000085f167824ULL, 0x000fe200078e00ffULL,
0x0000000c00197811ULL, 0x040fe200078fe8ffULL, 0x0000000117437824ULL, 0x100fe200078e0200ULL,
0xfffffff809427812ULL, 0x000fe200078ee242ULL, 0x000000015f097824ULL, 0x100fe200078e0200ULL,
0x0000000713417812ULL, 0x000fe200078ef80aULL, 0x0000000817107824ULL, 0x000fe200078e00ffULL,
0x00000014005b7811ULL, 0x040fe200078fe8ffULL, 0x0000000157137824ULL, 0x140fe200078e0200ULL,
0xfffffff816097812ULL, 0x000fe200078ee209ULL, 0x0000000857147824ULL, 0x000fe200078e00ffULL,
0xfffffff810437812ULL, 0x000fe200078ee243ULL, 0x0000000c17167c36ULL, 0x000fe20008000000ULL,
0x00000018005d7811ULL, 0x040fe200078fe8ffULL, 0x0000000c19177c36ULL, 0x000fe20008000000ULL,
0xfffffff814137812ULL, 0x000fe200078ee213ULL, 0x0000000119407824ULL, 0x140fe200078e0200ULL,
0x0000000c00147c11ULL, 0x000fe2000f8fe8ffULL, 0x00000008191b7824ULL, 0x000fe200078e00ffULL,
0x0000000d17177c10ULL, 0x000fe2000ff1e0ffULL, 0x0000000c15157c36ULL, 0x000fe20008000000ULL,
0x0000000d16167c10ULL, 0x000fe2000ff9e0ffULL, 0x000000015b107824ULL, 0x140fe200078e0200ULL,
0xfffffff81b407812ULL, 0x000fe200078ee240ULL, 0x000000085b1b7824ULL, 0x000fe200078e00ffULL,
0x0000000d141a7c10ULL, 0x000fe2000ff5e0ffULL, 0x000000ffff147224ULL, 0x000fe200000e06ffULL,
0x0000000d15187c10ULL, 0x000fe2000ff7e0ffULL, 0x000000ffff157224ULL, 0x000fe200020e06ffULL,
0x0000001a173a7c11ULL, 0x000fe2000f8048ffULL, 0x000000015d0a7824ULL, 0x040fe200078e0200ULL,
0x0000001a163e7c11ULL, 0x000fe2000f8848ffULL, 0x000000085d397824ULL, 0x000fe200078e00ffULL,
0xfffffff81b107812ULL, 0x000fe200078ee210ULL, 0x000000ffff1b7224ULL, 0x000fe200010e06ffULL,
0x0000001b173b7c11ULL, 0x000fe200080f4c14ULL, 0x000000ffff197224ULL, 0x000fe200018e06ffULL,
0x0000001a1a387c11ULL, 0x000fe2000f8448ffULL, 0x0000000c57147c36ULL, 0x000fe20008000000ULL,
0x0000001b163f7c11ULL, 0x000fe2000a0f4c15ULL, 0x0000000c5b157c36ULL, 0x000fe20008000000ULL,
0x0000001a183c7c11ULL, 0x000fe2000f8648ffULL, 0x0000000c5d167c36ULL, 0x000fe20008000000ULL,
0xfffffff8390a7812ULL, 0x000fe200078ee20aULL, 0x0000000c5f177c36ULL, 0x000fe20008000000ULL,
0x0000001b1a397c11ULL, 0x000fe200090f4c1bULL, 0x00000010123e7825ULL, 0x000fe200078e003eULL,
0x0000001b183d7c11ULL, 0x000fc400098f4c19ULL, 0x0000000d141b7c10ULL, 0x000fe2000ff5e0ffULL,
0x0000001012387825ULL, 0x040fe200078e0038ULL, 0x0000000d15157c10ULL, 0x000fe4000ff7e0ffULL,
0x0000000d16577c10ULL, 0x000fe2000ff9e0ffULL, 0x000000ffff5e7224ULL, 0x000fe200010e06ffULL,
0x0000000d17197c10ULL, 0x000fe2000ff1e0ffULL, 0x000000ffff5c7224ULL, 0x000fe200018e06ffULL,
0x0000001a1b1a7c11ULL, 0x000fe2000f8448ffULL, 0x000000ffff5a7224ULL, 0x000fe200020e06ffULL,
0x0000001a15147c11ULL, 0x000fe2000f8648ffULL, 0x000000ffff567224ULL, 0x000fe200000e06ffULL,
0x0000001a57167c11ULL, 0x000fe2000f8848ffULL, 0x00000010123c7825ULL, 0x000fe200078e003cULL,
0x0000001a19187c11ULL, 0x000fc4000f8048ffULL, 0x0000001b1b1b7c11ULL, 0x000fe200090f4c5eULL,
0x00000010123a7825ULL, 0x040fe200078e003aULL, 0x0000001b15157c11ULL, 0x000fe400098f4c5cULL,
0x0000001b57177c11ULL, 0x000fe2000a0f4c5aULL, 0x00000010121a7825ULL, 0x000fe200078e001aULL,
0x0000001641417c11ULL, 0x000fe4000f8e20ffULL, 0x0000001642577c11ULL, 0x000fe2000f8e20ffULL,
0x0000001012147825ULL, 0x040fe200078e0014ULL, 0x0000001b19197c11ULL, 0x000fe200080f4c56ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000038417faeULL, 0x0003e2000b901c4eULL,
0x0000001643437c11ULL, 0x000fe2000f8e20ffULL, 0x0000001012167825ULL, 0x000fe200078e0016ULL,
0x00000016405b7c11ULL, 0x000fe2000f8e20ffULL, 0x000000003c577faeULL, 0x0003e2000b901c4eULL,
0x0000001613137c11ULL, 0x000fe2000f8e20ffULL, 0x0000001012187825ULL, 0x000fe200078e0018ULL,
0x00000016105d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000003e437faeULL, 0x0003e2000b901c4eULL,
0x000000160a5f7c11ULL, 0x000fc4000f8e20ffULL, 0x0000001609097c11ULL, 0x000fe2000f8e20ffULL,
0x000000003a5b7faeULL, 0x0003e8000b901c4eULL, 0x000000001a137faeULL, 0x0003e8000b901c4eULL,
0x00000000145d7faeULL, 0x0003e8000b901c4eULL, 0x00000000165f7faeULL, 0x0003e8000b901c4eULL,
0x0000000018097faeULL, 0x0003e4000b901c4eULL, 0x00000001090d7892ULL, 0x000fe2000f8ec03fULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffff100c7891ULL, 0x000fe4000f8e083fULL,
0x000000010d00788cULL, 0x000fc8000bf05070ULL, 0x000000010c157887ULL, 0x000fc8000c000000ULL,
0x0000001509097290ULL, 0x000fc8000fffe03fULL, 0x000000060900728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fca0003f0f008ULL, 0x0000001508128290ULL, 0x000fe2000fffe00bULL,
0x00008c00000c8ab9ULL, 0x000fc60000000a00ULL, 0x00000004120c88a5ULL, 0x000fcc000f8e000cULL,
0x0000000cff127e24ULL, 0x000fe4000f8e00ffULL, 0x0000000dff137e24ULL, 0x006fca000f8e00ffULL,
0x0000000e12128981ULL, 0x000ea2000c1e1900ULL, 0x01c62811581479a7ULL, 0x0002e20008500004ULL,
0xffffffff00177882ULL, 0x000fe20000000000ULL, 0x00000000120c82caULL, 0x004fda00000e0000ULL,
0x0000000c00178c82ULL, 0x000fe20008000000ULL, 0x0000000000107805ULL, 0x002fe20000015200ULL,
0x01c62815580075a7ULL, 0x008e640008000144ULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff167224ULL, 0x000fce00078e00ffULL, 0x000000101600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x00000012100a7210ULL, 0x000fca0007f1e1ffULL, 0x0000000113127824ULL, 0x000fe200000e0e11ULL,
0x003d09000a00780cULL, 0x000fc80003f06070ULL, 0x000000ff1200720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400a00780cULL, 0x000fc80003f06070ULL,
0x000000ff1200720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff097819ULL, 0x000fc80000011412ULL, 0x0000000a09097211ULL, 0x000fca00078110ffULL,
0x000000ffff0a7224ULL, 0x000fca00000e0612ULL, 0x0000000209097819ULL, 0x000fc8000000120aULL,
0x000000090000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000116167836ULL, 0x000fce0000000000ULL, 0x01c62815580075a7ULL, 0x000e640008000144ULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x01c0800003117984ULL, 0x000e620000000800ULL,
0x000000ffff097224ULL, 0x000fc600078e0004ULL, 0x01c28000030a7984ULL, 0x0004a20000000800ULL,
0x000000041100720bULL, 0x002fda0003f1d000ULL, 0x0000000000127806ULL, 0x000fe400000e0100ULL,
0x000000000000781cULL, 0x000fe40003f0e170ULL, 0x0000ffff12ff7812ULL, 0x000fda000784c0ffULL,
0x0000000000f0a947ULL, 0x004fea0003800000ULL, 0x000000011100788cULL, 0x000fe2000bf05270ULL,
0x000000041100720bULL, 0x000fca0003f14000ULL, 0x000000000000781cULL, 0x000fd00003f4f008ULL,
0x0000000000137806ULL, 0x000fc800000e0100ULL, 0x0000991013097816ULL, 0x000fe400000000ffULL,
0x000000041110a209ULL, 0x000fe40007810000ULL, 0x000000ff0900720cULL, 0x000fc60003f05270ULL,
0x01c480100300a388ULL, 0x0003f40000000800ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x0000000411097209ULL, 0x000fe40007810000ULL, 0x000000ff13ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0013ff7812ULL, 0x000fe2000784c0ffULL, 0x0000000409097221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b09097820ULL, 0x000fc80000410000ULL, 0x0000000900157308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff107819ULL, 0x000fca0000011600ULL,
0x00001f1015097589ULL, 0x006e6400000e0000ULL, 0x0000000934347220ULL, 0x082fe20000410000ULL,
0x0000000935357220ULL, 0x080fe20000410000ULL, 0x0000000930307220ULL, 0x080fe20000410000ULL,
0x0000000931317220ULL, 0x080fe20000410000ULL, 0x0000000944447220ULL, 0x080fe20000410000ULL,
0x0000000945457220ULL, 0x080fe20000410000ULL, 0x000000092c2c7220ULL, 0x080fe20000410000ULL,
0x000000092d2d7220ULL, 0x080fe20000410000ULL, 0x0000000928287220ULL, 0x080fe20000410000ULL,
0x0000000929297220ULL, 0x080fe20000410000ULL, 0x0000000924247220ULL, 0x080fe20000410000ULL,
0x0000000925257220ULL, 0x080fe20000410000ULL, 0x0000000920207220ULL, 0x080fe20000410000ULL,
0x0000000921217220ULL, 0x080fe20000410000ULL, 0x000000091c1c7220ULL, 0x080fe20000410000ULL,
0x000000091d1d7220ULL, 0x000fce0000410000ULL, 0x0000001502027220ULL, 0x004fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x0000000800107811ULL, 0x000fca00078ff0ffULL,
0x00001f1015097589ULL, 0x002e6400000e0000ULL, 0x0000000936367220ULL, 0x082fe20000410000ULL,
0x0000000937377220ULL, 0x080fe20000410000ULL, 0x0000000932327220ULL, 0x080fe20000410000ULL,
0x0000000933337220ULL, 0x080fe20000410000ULL, 0x0000000946467220ULL, 0x080fe20000410000ULL,
0x0000000947477220ULL, 0x080fe20000410000ULL, 0x000000092e2e7220ULL, 0x080fe20000410000ULL,
0x000000092f2f7220ULL, 0x080fe20000410000ULL, 0x000000092a2a7220ULL, 0x080fe20000410000ULL,
0x000000092b2b7220ULL, 0x080fe20000410000ULL, 0x0000000926267220ULL, 0x080fe20000410000ULL,
0x0000000927277220ULL, 0x080fe20000410000ULL, 0x0000000922227220ULL, 0x080fe20000410000ULL,
0x0000000923237220ULL, 0x080fe20000410000ULL, 0x000000091e1e7220ULL, 0x080fe20000410000ULL,
0x000000091f1f7220ULL, 0x000fce0000410000ULL, 0x0000ffff13ff7812ULL, 0x000fe40007800812ULL,
0x0000000411097209ULL, 0x002fd60007810000ULL, 0x8000000911110221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b11110820ULL, 0x000fc80000410000ULL, 0x0000001100050308ULL, 0x000e640000000800ULL,
0x000000050a0a0220ULL, 0x002fce0000410000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000000188947ULL, 0x000fea0003800000ULL, 0x00000002ff117819ULL, 0x000fe40000011600ULL,
0x00000005ff04723eULL, 0x000fc600000010ffULL, 0x0000000811077836ULL, 0x000fe20000000000ULL,
0x0000541004047816ULL, 0x000fca0000000004ULL, 0x00001f1104067589ULL, 0x0002a800000e0000ULL,
0x00001f0704077589ULL, 0x0002e400000e0000ULL, 0x012800004e10783bULL, 0x0022e20000000200ULL,
0x0000000000108947ULL, 0x000fea0003800000ULL, 0x0000000610107232ULL, 0x08cfe40000200000ULL,
0x0000000612127232ULL, 0x000fe40000200000ULL, 0x0000000711117232ULL, 0x080fe40000200000ULL,
0x0000000713137232ULL, 0x000fce0000200000ULL, 0x000000004d3c783bULL, 0x000f280000004200ULL,
0x000000005038783bULL, 0x000f680000004200ULL, 0x000000005218783bULL, 0x000f680000004200ULL,
0x000000005314783bULL, 0x000f620000004200ULL, 0x0000003c1034723cULL, 0x018fec0000041834ULL,
0x0000003e1030723cULL, 0x000fec0000041830ULL, 0x000000381044723cULL, 0x022fec0000041844ULL,
0x0000003a102c723cULL, 0x000fec000004182cULL, 0x000000181028723cULL, 0x000fec0000041828ULL,
0x0000001a1024723cULL, 0x000fec0000041824ULL, 0x000000141020723cULL, 0x004fec0000041820ULL,
0x00000016101c723cULL, 0x000fe2000004181cULL, 0x012800005510783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000108947ULL, 0x000fde0003800000ULL,
0x0000000610107232ULL, 0x084fe40000200000ULL, 0x0000000612127232ULL, 0x000fe40000200000ULL,
0x0000000711117232ULL, 0x080fe40000200000ULL, 0x0000000713137232ULL, 0x000fce0000200000ULL,
0x00000000543c783bULL, 0x000ee20000004200ULL, 0x00008400000c7ab9ULL, 0x000fe20000000800ULL,
0x000000020a027221ULL, 0x000fe20000010000ULL, 0x0000000c170c72a4ULL, 0x000fe2000f8e023fULL,
0x000000005138783bULL, 0x000f260000004200ULL, 0x000000070c0d7899ULL, 0x000fe2000800063fULL,
0x000000004f18783bULL, 0x000f680000004200ULL, 0x000000004c14783bULL, 0x000f220000004200ULL,
0x0000003c1034723cULL, 0x00cfec0000041834ULL, 0x0000003e1030723cULL, 0x000fec0000041830ULL,
0x000000381044723cULL, 0x010fec0000041844ULL, 0x0000003a102c723cULL, 0x000fec000004182cULL,
0x000000181028723cULL, 0x022fec0000041828ULL, 0x0000001a1024723cULL, 0x000fec0000041824ULL,
0x000000141020723cULL, 0x000fec0000041820ULL, 0x00000016101c723cULL, 0x000fe2000004181cULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000400d09947ULL, 0x000fde0003800000ULL, 0x00000003ff157819ULL, 0x000fe20000011600ULL,
0x00000080050c7891ULL, 0x000fe2000f8e403fULL, 0x00008a00001a7ab9ULL, 0x000fc60000000a00ULL,
0x0000000415177836ULL, 0x000fe20000000000ULL, 0x0000000c1400728cULL, 0x000fe2000bf01070ULL,
0x00000014153b7836ULL, 0x000fe40000000000ULL, 0x0000000117047824ULL, 0x140fe200078e0200ULL,
0x0000000c14127287ULL, 0x000fe2000c000000ULL, 0x0000000817397824ULL, 0x000fe400078e00ffULL,
0x0000000815577836ULL, 0x000fe40000000000ULL, 0x000000013b3d7824ULL, 0x040fe200078e0200ULL,
0xfffffff839397812ULL, 0x000fe200078ee204ULL, 0x000000083b047824ULL, 0x000fc400078e00ffULL,
0x0000000157567824ULL, 0x100fe200078e0200ULL, 0x00000018395d7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000857117824ULL, 0x000fe200078e00ffULL, 0xfffffff8043d7812ULL, 0x000fe200078ee23dULL,
0x0000000c155b7836ULL, 0x000fe40000000000ULL, 0x0000000a15047c36ULL, 0x000fe20008000000ULL,
0xfffffff811567812ULL, 0x000fe200078ee256ULL, 0x0000001015437836ULL, 0x000fe20000000000ULL,
0x000000183d3d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000015b3a7824ULL, 0x140fe200078e0200ULL,
0x0000000d040a7c10ULL, 0x000fe2000ff5e0ffULL, 0x000000085b117824ULL, 0x000fe200078e00ffULL,
0x00000018565f7c11ULL, 0x000fe2000f8e20ffULL, 0x00000001433c7824ULL, 0x000fc400078e0200ULL,
0x0000000843137824ULL, 0x000fe200078e00ffULL, 0xfffffff8113a7812ULL, 0x000fe200078ee23aULL,
0x00000018153f7836ULL, 0x000fe40000000000ULL, 0x000000ffff117224ULL, 0x000fe200010e06ffULL,
0xfffffff8133c7812ULL, 0x000fe200078ee23cULL, 0x000000013f3e7824ULL, 0x040fe200078e0200ULL,
0x0000001a0a1a7c11ULL, 0x040fe2000f8448ffULL, 0x000000083f137824ULL, 0x000fe400078e00ffULL,
0x0000000a17047c36ULL, 0x000fe20008000000ULL, 0x0000001b0a1b7c11ULL, 0x000fe200090f4c11ULL,
0x0000001c15417836ULL, 0x000fe20000000000ULL, 0xfffffff8133e7812ULL, 0x000fe200078ee23eULL,
0x8000000cff427e24ULL, 0x000fe2000f8e02ffULL, 0x0000000d04107c10ULL, 0x000fe2000ff5e0ffULL,
0x00000012ff137e24ULL, 0x000fc4000f8e00ffULL, 0x0000000a57047c36ULL, 0x000fe40008000000ULL,
0x0000000141407824ULL, 0x040fe200078e0200ULL, 0x0000002013427446ULL, 0x000fe20003800042ULL,
0x0000000841197824ULL, 0x000fe200078e00ffULL, 0x0000000d04137c10ULL, 0x000fe2000ff9e0ffULL,
0x000000ffff117224ULL, 0x000fe200010e06ffULL, 0x0000001a10187c11ULL, 0x040fe2000f8448ffULL,
0x0000000a5b0a7c36ULL, 0x000fe20008000000ULL, 0xfffffff819407812ULL, 0x000fe200078ee240ULL,
0x0000000a43047c36ULL, 0x000fe20008000000ULL, 0x0000001b10197c11ULL, 0x000fe200090f4c11ULL,
0x0000000a3b147c36ULL, 0x000fe20008000000ULL, 0x0000000d0a117c10ULL, 0x000fe2000ffbe0ffULL,
0x000000ffff0a7224ULL, 0x000fe200020e06ffULL, 0x0000001a13167c11ULL, 0x000fc4000f8448ffULL,
0x000000421700720cULL, 0x080fe20003f66070ULL, 0x000000ffff127224ULL, 0x000fe200028e06ffULL,
0x0000001b13177c11ULL, 0x000fe400090f4c0aULL, 0x0000001a11107c11ULL, 0x040fe4000f8848ffULL,
0x0000000d040a7c10ULL, 0x000fe4000ff5e0ffULL, 0x0000001b11117c11ULL, 0x000fe4000a0f4c12ULL,
0x000000421500720cULL, 0x040fe20003f86070ULL, 0x000000ffff137224ULL, 0x000fe200010e06ffULL,
0x0000001a0a127c11ULL, 0x000fe2000f8c48ffULL, 0x0000000115157824ULL, 0x000fe200078e0200ULL,
0x0ffffff800047812ULL, 0x000fc400078ec0ffULL, 0x0000001b0a137c11ULL, 0x000fe2000b0f4c13ULL,
0x00000013590a7c36ULL, 0x000fe20008000000ULL, 0x0000000704387812ULL, 0x000fe400078ef815ULL,
0x000000425b00720cULL, 0x080fe20003f46070ULL, 0x000000100a1a7825ULL, 0x000fe200078e001aULL,
0x000000425700720cULL, 0x000fe40003fa6070ULL, 0x00000018385b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000a3f577c36ULL, 0x000fe20008000000ULL, 0x0000000d14157c10ULL, 0x000fe2000ffde0ffULL,
0x000000100a387825ULL, 0x000fc400078e0018ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a5b7faeULL, 0x0003e2000e101c4eULL, 0x0000000d57197c10ULL, 0x000fe2000ff9e0ffULL,
0x000000ffff5a7224ULL, 0x000fe200030e06ffULL, 0x0000001a15147c11ULL, 0x040fe2000f8c48ffULL,
0x0000000a41187c36ULL, 0x000fe20008000000ULL, 0x00000000385d7faeULL, 0x0005e2000d901c4eULL,
0x000000ffff567224ULL, 0x000fe200020e06ffULL, 0x0000001b15157c11ULL, 0x000fe2000b0f4c5aULL,
0x000000100a167825ULL, 0x040fe200078e0016ULL, 0x0000000d18577c10ULL, 0x000fe4000ff7e0ffULL,
0x0000001a19187c11ULL, 0x000fe2000f8c48ffULL, 0x000000100a107825ULL, 0x040fe200078e0010ULL,
0x000000424300720cULL, 0x080fe20003f86070ULL, 0x00000000165f7faeULL, 0x0007e2000e901c4eULL,
0x0000001b19197c11ULL, 0x000fe2000b0f4c56ULL, 0x000000ffff567224ULL, 0x000fe200018e06ffULL,
0x0000001a571a7c11ULL, 0x002fe2000f8648ffULL, 0x000000100a127825ULL, 0x000fe200078e0012ULL,
0x000000423b00720cULL, 0x000fc40003fc6070ULL, 0x000000423f00720cULL, 0x080fe20003fa6070ULL,
0x000000100a147825ULL, 0x040fe200078e0014ULL, 0x0000001b571b7c11ULL, 0x000fe400098f4c56ULL,
0x000000424100720cULL, 0x000fe20003f66070ULL, 0x000000100a187825ULL, 0x000fe200078e0018ULL,
0x000000183a397c11ULL, 0x004fe4000f8e20ffULL, 0x000000183c3b7c11ULL, 0x000fe2000f8e20ffULL,
0x000000100a1a7825ULL, 0x000fe200078e001aULL, 0x000000183e3f7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000010397faeULL, 0x0007e2000d101c4eULL, 0x0000001840417c11ULL, 0x000fc6000f8e20ffULL,
0x00000000123b7faeULL, 0x0007e8000e101c4eULL, 0x00000000143d7faeULL, 0x0007e8000f101c4eULL,
0x00000000183f7faeULL, 0x0007e8000e901c4eULL, 0x000000001a417faeULL, 0x0007e2000d901c4eULL,
0x0000000400907947ULL, 0x000fea0003800000ULL, 0x0000000400117811ULL, 0x040fe200078fe8ffULL,
0x00008a00001a7ab9ULL, 0x000fe20000000a00ULL, 0x0000000800137811ULL, 0x040fe400078fe8ffULL,
0x0000001000197811ULL, 0x040fe200078fe8ffULL, 0x0000000111167824ULL, 0x140fe200078e0200ULL,
0x0000001800437811ULL, 0x040fe200078fe8ffULL, 0x0000000811157824ULL, 0x000fe200078e00ffULL,
0x0000000c00177811ULL, 0x040fe200078fe8ffULL, 0x0000000113047824ULL, 0x100fe200078e0200ULL,
0x0000001400417811ULL, 0x040fe200078fe8ffULL, 0x00000001193f7824ULL, 0x100fe200078e0200ULL,
0xfffffff815167812ULL, 0x000fe200078ee216ULL, 0x0000000813157824ULL, 0x000fe200078e00ffULL,
0x0000000a00107c11ULL, 0x040fe2000f8fe8ffULL, 0x00000008190a7824ULL, 0x000fe200078e00ffULL,
0x0000001c00577811ULL, 0x000fe200078fe8ffULL, 0x00000001433d7824ULL, 0x140fe200078e0200ULL,
0xfffffff815567812ULL, 0x000fe200078ee204ULL, 0x0000000843047824ULL, 0x000fe200078e00ffULL,
0xfffffff80a3f7812ULL, 0x000fe200078ee23fULL, 0x0000000a110a7c36ULL, 0x000fe20008000000ULL,
0x0000000d10107c10ULL, 0x000fe2000ff5e0ffULL, 0x0000000117407824ULL, 0x140fe200078e0200ULL,
0xfffffff8043d7812ULL, 0x000fe200078ee23dULL, 0x0000000a13047c36ULL, 0x000fe20008000000ULL,
0x0000000d0a0a7c10ULL, 0x000fe2000ff7e0ffULL, 0x00000008171b7824ULL, 0x000fe200078e00ffULL,
0x000000183f3f7c11ULL, 0x000fe2000f8e20ffULL, 0x00000001413e7824ULL, 0x140fe200078e0200ULL,
0x0000000d04047c10ULL, 0x000fe2000ff9e0ffULL, 0x0000000841157824ULL, 0x000fe200078e00ffULL,
0xfffffff81b407812ULL, 0x000fe200078ee240ULL, 0x000000ffff137224ULL, 0x000fe200018e06ffULL,
0x0000001a0a387c11ULL, 0x040fe2000f8648ffULL, 0x00000001573c7824ULL, 0x040fe200078e0200ULL,
0xfffffff8153e7812ULL, 0x000fe200078ee23eULL, 0x00000008571b7824ULL, 0x000fe200078e00ffULL,
0x0000001b0a397c11ULL, 0x000fe200098f4c13ULL, 0x000000ffff157224ULL, 0x000fe200010e06ffULL,
0x0000001a103a7c11ULL, 0x000fe2000f8448ffULL, 0x000000ffff117224ULL, 0x000fe200020e06ffULL,
0x0000001a041a7c11ULL, 0x000fe2000f8848ffULL, 0x0000000a17177c36ULL, 0x000fe20008000000ULL,
0xfffffff81b3c7812ULL, 0x000fe200078ee23cULL, 0x0000000a19137c36ULL, 0x000fe20008000000ULL,
0x0000001b103b7c11ULL, 0x000fe200090f4c15ULL, 0x0000000a410a7c36ULL, 0x000fe20008000000ULL,
0x0000001b041b7c11ULL, 0x000fe2000a0f4c11ULL, 0x0000000a43437c36ULL, 0x000fe20008000000ULL,
0x0000000d17117c10ULL, 0x000fe2000ff5e0ffULL, 0x0000000a57197c36ULL, 0x000fe20008000000ULL,
0x0000000d13137c10ULL, 0x000fc4000ff7e0ffULL, 0x0000000000177211ULL, 0x040fe200078fe8ffULL,
0x000000ffff427224ULL, 0x000fe200010e06ffULL, 0x0ffffff800047812ULL, 0x000fe200078ec0ffULL,
0x000000ffff187224ULL, 0x000fe200018e06ffULL, 0x0000000d0a0a7c10ULL, 0x000fe4000ff9e0ffULL,
0x0000001a11107c11ULL, 0x000fe4000f8448ffULL, 0x0000000704177812ULL, 0x000fe200078ef817ULL,
0x000000ffff157224ULL, 0x000fe200020e06ffULL, 0x0000001a13127c11ULL, 0x000fc4000f8648ffULL,
0x0000001b11117c11ULL, 0x000fe400090f4c42ULL, 0x0000001817417c11ULL, 0x000fe4000f8e20ffULL,
0x0000001a0a147c11ULL, 0x000fe4000f8848ffULL, 0x0000001b13137c11ULL, 0x000fe400098f4c18ULL,
0x0000000d43177c10ULL, 0x000fe4000ff5e0ffULL, 0x0000000d19197c10ULL, 0x000fc4000ff7e0ffULL,
0x0000001b0a157c11ULL, 0x000fe2000a0f4c15ULL, 0x00000013590a7c36ULL, 0x000fe20008000000ULL,
0x0000001856577c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff567224ULL, 0x000fe200010e06ffULL,
0x0000001816437c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff427224ULL, 0x000fe200018e06ffULL,
0x0000001a17167c11ULL, 0x000fe2000f8448ffULL, 0x000000100a3a7825ULL, 0x040fe200078e003aULL,
0x0000001a19187c11ULL, 0x000fe4000f8648ffULL, 0x0000001b17177c11ULL, 0x000fe200090f4c56ULL,
0x000000100a387825ULL, 0x000fe200078e0038ULL, 0x0000001b19197c11ULL, 0x000fe200098f4c42ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a417faeULL, 0x0003e2000b901c4eULL,
0x00000018405b7c11ULL, 0x000fe2000f8e20ffULL, 0x000000100a1a7825ULL, 0x000fe200078e001aULL,
0x000000183e5d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000038437faeULL, 0x0003e2000b901c4eULL,
0x000000183d3d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000100a107825ULL, 0x000fe200078e0010ULL,
0x000000183c5f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000001a577faeULL, 0x0003e4000b901c4eULL,
0x000000100a127825ULL, 0x000fc400078e0012ULL, 0x00000000105b7faeULL, 0x0003e4000b901c4eULL,
0x000000100a147825ULL, 0x040fe400078e0014ULL, 0x00000000123f7faeULL, 0x0003e4000b901c4eULL,
0x000000100a167825ULL, 0x040fe400078e0016ULL, 0x00000000145d7faeULL, 0x0003e4000b901c4eULL,
0x000000100a187825ULL, 0x000fc400078e0018ULL, 0x00000000163d7faeULL, 0x0003e8000b901c4eULL,
0x00000000185f7faeULL, 0x0003e4000b901c4eULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000000000188947ULL, 0x000fea0003800000ULL,
0x00000002ff117819ULL, 0x00afe40000011600ULL, 0x00000005ff06723eULL, 0x000fc600000010ffULL,
0x0000000811077836ULL, 0x000fe20000000000ULL, 0x0000541006107816ULL, 0x000fca0000000006ULL,
0x00001f1110067589ULL, 0x0002a800000e0000ULL, 0x00001f0710077589ULL, 0x0002e400000e0000ULL,
0x012800004b10783bULL, 0x00a2e20000000200ULL, 0x0000000000108947ULL, 0x000fea0003800000ULL,
0x0000000610107232ULL, 0x08cfe40000200000ULL, 0x0000000612127232ULL, 0x000fe40000200000ULL,
0x0000000711117232ULL, 0x080fe40000200000ULL, 0x0000000713137232ULL, 0x000fce0000200000ULL,
0x000000004a3c783bULL, 0x000f280000004200ULL, 0x000000004938783bULL, 0x000f680000004200ULL,
0x000000004818783bULL, 0x000f680000004200ULL, 0x000000000f14783bULL, 0x000f620000004200ULL,
0x0000003c1034723cULL, 0x018fec0000041834ULL, 0x0000003e1030723cULL, 0x000fec0000041830ULL,
0x000000381044723cULL, 0x022fec0000041844ULL, 0x0000003a102c723cULL, 0x000fec000004182cULL,
0x000000181028723cULL, 0x000fec0000041828ULL, 0x0000001a1024723cULL, 0x000fec0000041824ULL,
0x000000141020723cULL, 0x004fec0000041820ULL, 0x00000016101c723cULL, 0x000fe2000004181cULL,
0x012800000810783bULL, 0x0002a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000108947ULL, 0x000fde0003800000ULL, 0x0000000610107232ULL, 0x084fe40000200000ULL,
0x0000000612127232ULL, 0x000fe40000200000ULL, 0x0000000711117232ULL, 0x080fe40000200000ULL,
0x0000000713137232ULL, 0x000fce0000200000ULL, 0x000000000b14783bULL, 0x000ee20000004200ULL,
0x00000080050c7891ULL, 0x000fc6000f8e403fULL, 0x000000000c3c783bULL, 0x000f220000004200ULL,
0x000000140c00728cULL, 0x000fc6000bf06070ULL, 0x000000000e38783bULL, 0x000f660000004200ULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x000000000d18783bULL, 0x000f620000004200ULL,
0x000000141020723cULL, 0x00cfec0000041820ULL, 0x0000003c1034723cULL, 0x010fe20000041834ULL,
0x00000001ff157424ULL, 0x000fc800078e00ffULL, 0x01c69015ffff79a7ULL, 0x0005e20008500004ULL,
0x0000003e1030723cULL, 0x000fec0000041830ULL, 0x000000381044723cULL, 0x022fec0000041844ULL,
0x0000003a102c723cULL, 0x000fec000004182cULL, 0x000000181028723cULL, 0x000fec0000041828ULL,
0x0000001a1024723cULL, 0x000fec0000041824ULL, 0x00000016101c723cULL, 0x000fe2000004181cULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000004c00f00947ULL, 0x004fde0003800000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000400c89947ULL, 0x000fea0003800000ULL,
0x00000003ff1b7819ULL, 0x100fe20000011600ULL, 0x000000200c0c7890ULL, 0x000fe4000fffe03fULL,
0x000000200a197890ULL, 0x000fe4000fffe03fULL, 0x000000011b117824ULL, 0x100fe200078e0200ULL,
0x0000000c1400728cULL, 0x000fe2000bf01070ULL, 0x000000081b5f7836ULL, 0x000fe40000000000ULL,
0x0000000c1b177836ULL, 0x000fe20000000000ULL, 0x00000007043d7812ULL, 0x000fe200078ef811ULL,
0x000000041b3b7836ULL, 0x000fe20000000000ULL, 0x0000000c14127287ULL, 0x000fe2000c000000ULL,
0x000000015f417824ULL, 0x000fc400078e0200ULL, 0x000000085f107824ULL, 0x000fe400078e00ffULL,
0x0000000117047824ULL, 0x140fe400078e0200ULL, 0x0000000817117824ULL, 0x000fe200078e00ffULL,
0xfffffff810417812ULL, 0x000fe200078ee241ULL, 0x000000141b437836ULL, 0x000fe40000000000ULL,
0x000000181b577836ULL, 0x000fe20000000000ULL, 0xfffffff811047812ULL, 0x000fe200078ee204ULL,
0x000000013b3a7824ULL, 0x000fe200078e0200ULL, 0x0000001641417c11ULL, 0x000fe2000f8e20ffULL,
0x000000083b137824ULL, 0x000fc400078e00ffULL, 0x000000101b5b7836ULL, 0x000fe40000000000ULL,
0x00000001433e7824ULL, 0x140fe200078e0200ULL, 0xfffffff8133a7812ULL, 0x000fe200078ee23aULL,
0x0000000843117824ULL, 0x000fe400078e00ffULL, 0x00000001573f7824ULL, 0x140fe200078e0200ULL,
0x000000163a617c11ULL, 0x000fe2000f8e20ffULL, 0x0000000857107824ULL, 0x000fe200078e00ffULL,
0xfffffff8113e7812ULL, 0x000fe200078ee23eULL, 0x000000015b147824ULL, 0x000fc400078e0200ULL,
0x000000085b137824ULL, 0x000fe200078e00ffULL, 0xfffffff8103f7812ULL, 0x000fe200078ee23fULL,
0x000000191b107c36ULL, 0x000fe40008000000ULL, 0x000000193b117c36ULL, 0x000fe20008000000ULL,
0xfffffff813147812ULL, 0x000fe200078ee214ULL, 0x8000000cff427e24ULL, 0x000fe2000f8e02ffULL,
0x0000000d10107c10ULL, 0x000fe2000ff1e0ffULL, 0x00000012ff137e24ULL, 0x000fe2000f8e00ffULL,
0x0000000d11117c10ULL, 0x000fe2000ff5e0ffULL, 0x0000001c1b5d7836ULL, 0x000fe20000000000ULL,
0x000000163f3f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000195f167c36ULL, 0x000fe20008000000ULL,
0x0000002013427446ULL, 0x000fe20003800042ULL, 0x000000015d407824ULL, 0x000fe200078e0200ULL,
0x0000001a11387c11ULL, 0x000fe2000f8648ffULL, 0x000000085d197824ULL, 0x000fe200078e00ffULL,
0x000000423b00720cULL, 0x080fe20003fa6070ULL, 0x000000ffff137224ULL, 0x000fe200000e06ffULL,
0x0000001a10187c11ULL, 0x040fe2000f8048ffULL, 0x000000ffff127224ULL, 0x000fe200010e06ffULL,
0xfffffff819407812ULL, 0x000fe200078ee240ULL, 0x00000019433b7c36ULL, 0x000fe20008000000ULL,
0x0000001b10197c11ULL, 0x000fe200080f4c13ULL, 0x00000019575a7c36ULL, 0x000fe20008000000ULL,
0x0000001b11397c11ULL, 0x000fe200098f4c12ULL, 0x0000001917117c36ULL, 0x000fe20008000000ULL,
0x0000000d16107c10ULL, 0x000fe2000ff1e0ffULL, 0x000000195b127c36ULL, 0x000fe20008000000ULL,
0x000000421b00720cULL, 0x000fc40003f46070ULL, 0x0000000d11117c10ULL, 0x000fe2000ff7e0ffULL,
0x000000ffff137224ULL, 0x000fe200000e06ffULL, 0x0000001a101a7c11ULL, 0x000fc6000f8048ffULL,
0x000000ffff3c7224ULL, 0x000fe200018e06ffULL, 0x0000001b101b7c11ULL, 0x000fe400080f4c13ULL,
0x0000000d12137c10ULL, 0x000fe4000ff1e0ffULL, 0x0000001a11107c11ULL, 0x000fe2000f8648ffULL,
0x000000100a1a7825ULL, 0x000fe200078e001aULL, 0x0000001a13127c11ULL, 0x000fe4000f8848ffULL,
0x0000001b11117c11ULL, 0x000fe200098f4c3cULL, 0x000000ffff167224ULL, 0x000fe200000e06ffULL,
0x0000000d3b3b7c10ULL, 0x000fc4000ff7e0ffULL, 0x000000425f00720cULL, 0x080fe20003f06070ULL,
0x000000100a107825ULL, 0x040fe200078e0010ULL, 0x0000001b13137c11ULL, 0x000fe4000a0f4c16ULL,
0x000000163d5f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff567224ULL, 0x000fe200018e06ffULL,
0x0000001a3b167c11ULL, 0x000fe2000f8648ffULL, 0x000000100a3c7825ULL, 0x040fe200078e0018ULL,
0x000000421700720cULL, 0x000fe40003f86070ULL, 0x0000001b3b177c11ULL, 0x000fe200098f4c56ULL,
0x000000195d187c36ULL, 0x000fe20008000000ULL, 0x0000000d5a197c10ULL, 0x000fe2000ff7e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c5f7faeULL, 0x000fe2000d101c4eULL,
0x000000100a3a7825ULL, 0x000fc400078e0038ULL, 0x0000000d18567c10ULL, 0x000fe4000ff5e0ffULL,
0x000000ffff5a7224ULL, 0x000fe200018e06ffULL, 0x0000001a19187c11ULL, 0x000fe2000f8c48ffULL,
0x000000003a617faeULL, 0x0003e2000e901c4eULL, 0x000000ffff397224ULL, 0x000fe200010e06ffULL,
0x0000001a56387c11ULL, 0x000fe2000f8448ffULL, 0x000000100a127825ULL, 0x040fe200078e0012ULL,
0x000000425b00720cULL, 0x080fe20003f66070ULL, 0x000000001a417faeULL, 0x0007e2000c101c4eULL,
0x0000001b19197c11ULL, 0x000fe2000b0f4c5aULL, 0x000000100a167825ULL, 0x000fe200078e0016ULL,
0x000000424300720cULL, 0x000fc40003fc6070ULL, 0x000000425700720cULL, 0x080fe20003fa6070ULL,
0x000000100a187825ULL, 0x000fe200078e0018ULL, 0x0000001b56397c11ULL, 0x000fe400090f4c39ULL,
0x000000425d00720cULL, 0x000fe40003f46070ULL, 0x00000016043b7c11ULL, 0x002fe2000f8e20ffULL,
0x000000100a387825ULL, 0x000fe200078e0038ULL, 0x00000016143d7c11ULL, 0x000fe4000f8e20ffULL,
0x000000163e437c11ULL, 0x000fe2000f8e20ffULL, 0x00000000103b7faeULL, 0x0007e2000e101c4eULL,
0x0000001640577c11ULL, 0x000fc6000f8e20ffULL, 0x00000000123d7faeULL, 0x0007e8000d901c4eULL,
0x0000000016437faeULL, 0x0007e8000f101c4eULL, 0x00000000183f7faeULL, 0x0007e8000e901c4eULL,
0x0000000038577faeULL, 0x0007e2000d101c4eULL, 0x0000000400887947ULL, 0x000fea0003800000ULL,
0x0000000800137811ULL, 0x040fe200078fe8ffULL, 0x000000200a0c7890ULL, 0x000fe2000fffe03fULL,
0x0000000400117811ULL, 0x040fe400078fe8ffULL, 0x0000001000397811ULL, 0x040fe200078fe8ffULL,
0x0000000113437824ULL, 0x140fe200078e0200ULL, 0x0000001400577811ULL, 0x040fe200078fe8ffULL,
0x0000000813107824ULL, 0x000fe200078e00ffULL, 0x0000000c00197811ULL, 0x040fe200078fe8ffULL,
0x0000000111427824ULL, 0x140fe200078e0200ULL, 0x00000018005b7811ULL, 0x040fe200078fe8ffULL,
0x0000000811177824ULL, 0x000fe200078e00ffULL, 0xfffffff810437812ULL, 0x000fe200078ee243ULL,
0x00000001393f7824ULL, 0x140fe200078e0200ULL, 0x0000000000417211ULL, 0x040fe200078fe8ffULL,
0x0000000839107824ULL, 0x000fe200078e00ffULL, 0xfffffff817427812ULL, 0x000fe200078ee242ULL,
0x00000001573e7824ULL, 0x140fe200078e0200ULL, 0x0000001c005d7811ULL, 0x040fe200078fe8ffULL,
0x0000000857177824ULL, 0x000fe200078e00ffULL, 0xfffffff8103f7812ULL, 0x000fe200078ee23fULL,
0x0000000c11187c36ULL, 0x000fe20008000000ULL, 0x0000000704417812ULL, 0x000fe200078ef841ULL,
0x0000000c13127c36ULL, 0x000fe20008000000ULL, 0xfffffff8173e7812ULL, 0x000fe200078ee23eULL,
0x0000000c19107c36ULL, 0x000fe20008000000ULL, 0x0000000c00177c11ULL, 0x000fe2000f8fe8ffULL,
0x0000000119407824ULL, 0x140fe200078e0200ULL, 0x0000000d18187c10ULL, 0x000fe2000ff7e0ffULL,
0x00000008191b7824ULL, 0x000fe200078e00ffULL, 0x0000000d12127c10ULL, 0x000fe2000ff9e0ffULL,
0x000000015b147824ULL, 0x100fe200078e0200ULL, 0x0000000d10107c10ULL, 0x000fe2000ff1e0ffULL,
0x000000015d047824ULL, 0x000fe200078e0200ULL, 0xfffffff81b407812ULL, 0x000fe200078ee240ULL,
0x000000085b1b7824ULL, 0x000fe200078e00ffULL, 0x0000000d17177c10ULL, 0x000fe2000ff5e0ffULL,
0x000000085d3b7824ULL, 0x000fe200078e00ffULL, 0x0000001641417c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff197224ULL, 0x000fe200018e06ffULL, 0x0000001a181a7c11ULL, 0x000fe2000f8648ffULL,
0x000000ffff137224ULL, 0x000fe200020e06ffULL, 0x0000001a123a7c11ULL, 0x000fe2000f8848ffULL,
0x000000ffff117224ULL, 0x000fe200000e06ffULL, 0x0000001a103c7c11ULL, 0x000fe2000f8048ffULL,
0x000000ffff387224ULL, 0x000fe200010e06ffULL, 0xfffffff81b147812ULL, 0x000fe200078ee214ULL,
0x0000000c39397c36ULL, 0x000fe20008000000ULL, 0xfffffff83b047812ULL, 0x000fc400078ee204ULL,
0x0000001a17167c11ULL, 0x040fe4000f8448ffULL, 0x0000001b181b7c11ULL, 0x000fe200098f4c19ULL,
0x0000000c57197c36ULL, 0x000fe20008000000ULL, 0x0000001b123b7c11ULL, 0x000fe2000a0f4c13ULL,
0x0000000c5b137c36ULL, 0x000fe20008000000ULL, 0x0000001b103d7c11ULL, 0x000fe200080f4c11ULL,
0x0000000c5d117c36ULL, 0x000fe20008000000ULL, 0x0000001b17177c11ULL, 0x000fe200090f4c38ULL,
0x000000100a1a7825ULL, 0x000fe200078e001aULL, 0x0000000d39397c10ULL, 0x000fc4000ff5e0ffULL,
0x0000000d19197c10ULL, 0x000fe2000ff7e0ffULL, 0x000000100a167825ULL, 0x040fe200078e0016ULL,
0x0000000d13137c10ULL, 0x000fe4000ff9e0ffULL, 0x0000000d11117c10ULL, 0x000fe2000ff1e0ffULL,
0x000000ffff5e7224ULL, 0x000fe200010e06ffULL, 0x0000001a39387c11ULL, 0x000fe2000f8448ffULL,
0x000000ffff5c7224ULL, 0x000fe200018e06ffULL, 0x0000001a19187c11ULL, 0x000fe2000f8648ffULL,
0x000000ffff5a7224ULL, 0x000fe200020e06ffULL, 0x0000001a13127c11ULL, 0x000fe2000f8848ffULL,
0x000000ffff567224ULL, 0x000fe200000e06ffULL, 0x0000001a11107c11ULL, 0x000fe2000f8048ffULL,
0x000000100a3a7825ULL, 0x040fe200078e003aULL, 0x0000001b39397c11ULL, 0x000fe200090f4c5eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016417faeULL, 0x0003e2000b901c4eULL,
0x0000001b19197c11ULL, 0x000fe200098f4c5cULL, 0x000000100a3c7825ULL, 0x000fe200078e003cULL,
0x0000001b13137c11ULL, 0x000fc4000a0f4c5aULL, 0x0000001642577c11ULL, 0x000fe2000f8e20ffULL,
0x000000100a387825ULL, 0x040fe200078e0038ULL, 0x0000001b11117c11ULL, 0x000fe400080f4c56ULL,
0x0000001643437c11ULL, 0x000fe2000f8e20ffULL, 0x000000100a187825ULL, 0x000fe200078e0018ULL,
0x00000016405b7c11ULL, 0x000fe2000f8e20ffULL, 0x000000001a577faeULL, 0x0003e2000b901c4eULL,
0x000000163f3f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000100a127825ULL, 0x000fe200078e0012ULL,
0x000000163e5d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000003a437faeULL, 0x0003e2000b901c4eULL,
0x00000016145f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000100a107825ULL, 0x000fe200078e0010ULL,
0x0000001604617c11ULL, 0x000fe2000f8e20ffULL, 0x000000003c5b7faeULL, 0x0003e8000b901c4eULL,
0x00000000383f7faeULL, 0x0003e8000b901c4eULL, 0x00000000185d7faeULL, 0x0003e8000b901c4eULL,
0x00000000125f7faeULL, 0x0003e8000b901c4eULL, 0x0000000010617faeULL, 0x0003e4000b901c4eULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x01c64815581479a7ULL, 0x0004640008500004ULL,
0x0000000000107805ULL, 0x00afce0000015200ULL, 0x01c64815580075a7ULL, 0x000e640008000144ULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff0a7224ULL, 0x000fce00078e00ffULL,
0x000000100a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fce0000015200ULL, 0x0000001210177210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc80000011413ULL,
0x0000001704047211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000204047819ULL, 0x000fc80000001213ULL, 0x000000040000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000010a0a7836ULL, 0x000fce0000000000ULL,
0x01c64815580075a7ULL, 0x000e640008000144ULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x01c10000030a7984ULL, 0x000e680000000800ULL, 0x01c3000003047984ULL, 0x0006e20000000800ULL,
0x000000090a00720bULL, 0x002fda0003f1d000ULL, 0x0000000000127806ULL, 0x000fe400000e0100ULL,
0x000000000000781cULL, 0x000fe40003f0e170ULL, 0x0000ffff12ff7812ULL, 0x000fda000784c0ffULL,
0x0000000000f0a947ULL, 0x00cfea0003800000ULL, 0x000000021100788cULL, 0x000fe2000bf05270ULL,
0x000000090a00720bULL, 0x000fca0003f14000ULL, 0x000000000000781cULL, 0x000fd00003f4f008ULL,
0x0000000000137806ULL, 0x000fc800000e0100ULL, 0x0000991013117816ULL, 0x000fe400000000ffULL,
0x0000000a0910a209ULL, 0x000fe40007810000ULL, 0x000000ff1100720cULL, 0x000fc60003f05270ULL,
0x01c500100300a388ULL, 0x0003f40000000800ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x0000000a09107209ULL, 0x000fe40007810000ULL, 0x000000ff13ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0013ff7812ULL, 0x000fe2000784c0ffULL, 0x8000001009107221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL, 0x0000001000117308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff107819ULL, 0x002fcc0000011600ULL,
0x00001f1011107589ULL, 0x004e6400000e0000ULL, 0x0000001034347220ULL, 0x082fe20000410000ULL,
0x0000001035357220ULL, 0x080fe20000410000ULL, 0x0000001030307220ULL, 0x080fe20000410000ULL,
0x0000001031317220ULL, 0x080fe20000410000ULL, 0x0000001044447220ULL, 0x080fe20000410000ULL,
0x0000001045457220ULL, 0x080fe20000410000ULL, 0x000000102c2c7220ULL, 0x080fe20000410000ULL,
0x000000102d2d7220ULL, 0x080fe20000410000ULL, 0x0000001028287220ULL, 0x080fe20000410000ULL,
0x0000001029297220ULL, 0x080fe20000410000ULL, 0x0000001024247220ULL, 0x080fe20000410000ULL,
0x0000001025257220ULL, 0x080fe20000410000ULL, 0x0000001020207220ULL, 0x080fe20000410000ULL,
0x0000001021217220ULL, 0x080fe20000410000ULL, 0x000000101c1c7220ULL, 0x080fe20000410000ULL,
0x000000101d1d7220ULL, 0x000fce0000410000ULL, 0x0000001102027220ULL, 0x004fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x0000000800107811ULL, 0x002fcc00078ff0ffULL,
0x00001f1011107589ULL, 0x000e6400000e0000ULL, 0x0000001036367220ULL, 0x082fe20000410000ULL,
0x0000001037377220ULL, 0x080fe20000410000ULL, 0x0000001032327220ULL, 0x080fe20000410000ULL,
0x0000001033337220ULL, 0x080fe20000410000ULL, 0x0000001046467220ULL, 0x080fe20000410000ULL,
0x0000001047477220ULL, 0x080fe20000410000ULL, 0x000000102e2e7220ULL, 0x080fe20000410000ULL,
0x000000102f2f7220ULL, 0x080fe20000410000ULL, 0x000000102a2a7220ULL, 0x080fe20000410000ULL,
0x000000102b2b7220ULL, 0x080fe20000410000ULL, 0x0000001026267220ULL, 0x080fe20000410000ULL,
0x0000001027277220ULL, 0x080fe20000410000ULL, 0x0000001022227220ULL, 0x080fe20000410000ULL,
0x0000001023237220ULL, 0x080fe20000410000ULL, 0x000000101e1e7220ULL, 0x080fe20000410000ULL,
0x000000101f1f7220ULL, 0x000fce0000410000ULL, 0x0000ffff13ff7812ULL, 0x000fe40007800812ULL,
0x0000000a09097209ULL, 0x000fd60007810000ULL, 0x800000090a0a0221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b0a0a0820ULL, 0x000fc80000410000ULL, 0x0000000a00050308ULL, 0x000ea40000000800ULL,
0x0000000504040220ULL, 0x004fce0000410000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000000188947ULL, 0x000fea0003800000ULL, 0x00000002ff117819ULL, 0x000fe40000011600ULL,
0x00000005ff06723eULL, 0x000fc600000010ffULL, 0x0000000811077836ULL, 0x000fe20000000000ULL,
0x00005410060a7816ULL, 0x000fca0000000006ULL, 0x00001f110a067589ULL, 0x0004e800000e0000ULL,
0x00001f070a077589ULL, 0x00046400000e0000ULL, 0x013000004e10783bULL, 0x0062a20000000200ULL,
0x0000000000108947ULL, 0x000fea0003800000ULL, 0x0000000610107232ULL, 0x08cfe40000200000ULL,
0x0000000612127232ULL, 0x000fe40000200000ULL, 0x0000000711117232ULL, 0x080fe40000200000ULL,
0x0000000713137232ULL, 0x000fce0000200000ULL, 0x000000004d3c783bULL, 0x000f280000004200ULL,
0x000000005038783bULL, 0x000f680000004200ULL, 0x000000005218783bULL, 0x000f680000004200ULL,
0x000000005314783bULL, 0x000f620000004200ULL, 0x0000003c1034723cULL, 0x014fec0000041834ULL,
0x0000003e1030723cULL, 0x000fec0000041830ULL, 0x000000381044723cULL, 0x022fec0000041844ULL,
0x0000003a102c723cULL, 0x000fec000004182cULL, 0x000000181028723cULL, 0x008fec0000041828ULL,
0x0000001a1024723cULL, 0x000fec0000041824ULL, 0x000000141020723cULL, 0x000fec0000041820ULL,
0x00000016101c723cULL, 0x000fe2000004181cULL, 0x013000005510783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000108947ULL, 0x000fde0003800000ULL,
0x0000000610107232ULL, 0x084fe40000200000ULL, 0x0000000612127232ULL, 0x000fe40000200000ULL,
0x0000000711117232ULL, 0x080fe40000200000ULL, 0x0000000713137232ULL, 0x000fce0000200000ULL,
0x00000000543c783bULL, 0x000ee20000004200ULL, 0x0000000204027221ULL, 0x000fc60000010000ULL,
0x000000005138783bULL, 0x000f280000004200ULL, 0x000000004f18783bULL, 0x000f680000004200ULL,
0x000000004c14783bULL, 0x000f220000004200ULL, 0x0000003c1034723cULL, 0x00cfec0000041834ULL,
0x0000003e1030723cULL, 0x000fec0000041830ULL, 0x000000381044723cULL, 0x010fec0000041844ULL,
0x0000003a102c723cULL, 0x000fec000004182cULL, 0x000000181028723cULL, 0x022fec0000041828ULL,
0x0000001a1024723cULL, 0x000fec0000041824ULL, 0x000000141020723cULL, 0x000fec0000041820ULL,
0x00000016101c723cULL, 0x000fe2000004181cULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000400d49947ULL, 0x000fde0003800000ULL,
0x00000003ff157819ULL, 0x100fe20000011600ULL, 0x000000400a197890ULL, 0x000fe4000fffe03fULL,
0x000000c0050c7891ULL, 0x000fe4000f8e403fULL, 0x0000000415137836ULL, 0x000fe20000000000ULL,
0x00008a00001a7ab9ULL, 0x000fe20000000a00ULL, 0x00000014153b7836ULL, 0x000fe20000000000ULL,
0x0000000c1400728cULL, 0x000fe2000bf01070ULL, 0x0000000113047824ULL, 0x140fe400078e0200ULL,
0x0000000813117824ULL, 0x000fe200078e00ffULL, 0x0000000c14127287ULL, 0x000fe2000c000000ULL,
0x000000013b3d7824ULL, 0x000fc400078e0200ULL, 0x0000000815397836ULL, 0x000fe20000000000ULL,
0xfffffff811387812ULL, 0x000fe200078ee204ULL, 0x000000083b047824ULL, 0x000fe400078e00ffULL,
0x0000000139567824ULL, 0x140fe200078e0200ULL, 0x00000018385d7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000839177824ULL, 0x000fe200078e00ffULL, 0xfffffff8043d7812ULL, 0x000fe200078ee23dULL,
0x0000000c15577836ULL, 0x000fe40000000000ULL, 0x0000001915047c36ULL, 0x000fe20008000000ULL,
0xfffffff817567812ULL, 0x000fe200078ee256ULL, 0x0000001015437836ULL, 0x000fe20000000000ULL,
0x000000183d3d7c11ULL, 0x000fe2000f8e20ffULL, 0x00000001573a7824ULL, 0x140fe200078e0200ULL,
0x0000000d04047c10ULL, 0x000fe2000ff5e0ffULL, 0x0000000857117824ULL, 0x000fe200078e00ffULL,
0x00000018565f7c11ULL, 0x000fe2000f8e20ffULL, 0x00000001433c7824ULL, 0x000fc400078e0200ULL,
0x0000000843177824ULL, 0x000fe200078e00ffULL, 0xfffffff8113a7812ULL, 0x000fe200078ee23aULL,
0x00000018153f7836ULL, 0x000fe40000000000ULL, 0x000000ffff117224ULL, 0x000fe200010e06ffULL,
0xfffffff8173c7812ULL, 0x000fe200078ee23cULL, 0x000000013f407824ULL, 0x040fe200078e0200ULL,
0x0000001a041a7c11ULL, 0x040fe2000f8448ffULL, 0x000000083f177824ULL, 0x000fe400078e00ffULL,
0x00000019130a7c36ULL, 0x000fe20008000000ULL, 0x0000001b041b7c11ULL, 0x000fe200090f4c11ULL,
0x0000001c15417836ULL, 0x000fe20000000000ULL, 0xfffffff817407812ULL, 0x000fe200078ee240ULL,
0x8000000cff427e24ULL, 0x000fe2000f8e02ffULL, 0x0000000d0a047c10ULL, 0x000fe2000ff5e0ffULL,
0x00000012ff177e24ULL, 0x000fc4000f8e00ffULL, 0x00000019390a7c36ULL, 0x000fe40008000000ULL,
0x00000001413e7824ULL, 0x040fe200078e0200ULL, 0x0000002017427446ULL, 0x000fe20003800042ULL,
0x0000000841197824ULL, 0x000fe200078e00ffULL, 0x0000000d0a0a7c10ULL, 0x000fe2000ff9e0ffULL,
0x000000ffff117224ULL, 0x000fe200010e06ffULL, 0x0000001a04187c11ULL, 0x040fe2000f8448ffULL,
0x0000001957107c36ULL, 0x000fe20008000000ULL, 0xfffffff8193e7812ULL, 0x000fe200078ee23eULL,
0x0000001943127c36ULL, 0x000fe20008000000ULL, 0x0000001b04197c11ULL, 0x000fc400090f4c11ULL,
0x000000421300720cULL, 0x000fe20003f66070ULL, 0x000000ffff137224ULL, 0x000fe200020e06ffULL,
0x0000000d10047c10ULL, 0x000fe4000ffbe0ffULL, 0x0000001a0a167c11ULL, 0x000fe4000f8448ffULL,
0x0000001a04107c11ULL, 0x000fe2000f8848ffULL, 0x000000ffff117224ULL, 0x000fe200028e06ffULL,
0x0000001b0a177c11ULL, 0x000fe400090f4c13ULL, 0x0000000d120a7c10ULL, 0x000fc4000ff5e0ffULL,
0x0000001b04117c11ULL, 0x000fe4000a0f4c11ULL, 0x000000421500720cULL, 0x0c0fe20003f86070ULL,
0x000000ffff137224ULL, 0x000fe200010e06ffULL, 0x0000001a0a127c11ULL, 0x000fe2000f8c48ffULL,
0x0000000115157824ULL, 0x000fe200078e0200ULL, 0x0ffffff800047812ULL, 0x000fe400078ec0ffULL,
0x000000423900720cULL, 0x000fe20003fa6070ULL, 0x000000193b397c36ULL, 0x000fe20008000000ULL,
0x0000001b0a137c11ULL, 0x000fe2000b0f4c13ULL, 0x00000013590a7c36ULL, 0x000fe20008000000ULL,
0x0000000704147812ULL, 0x000fc400078ef815ULL, 0x000000425700720cULL, 0x000fe20003f46070ULL,
0x000000100a1a7825ULL, 0x000fe200078e001aULL, 0x00000018145b7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000d39157c10ULL, 0x000fe2000ffde0ffULL, 0x000000193f577c36ULL, 0x000fe40008000000ULL,
0x000000100a387825ULL, 0x040fe200078e0018ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a5b7faeULL, 0x0003e4000e101c4eULL, 0x0000000d57197c10ULL, 0x000fe2000ff9e0ffULL,
0x000000ffff5a7224ULL, 0x000fe200030e06ffULL, 0x0000001a15147c11ULL, 0x040fe2000f8c48ffULL,
0x0000001941187c36ULL, 0x000fe20008000000ULL, 0x00000000385d7faeULL, 0x0005e2000d901c4eULL,
0x000000ffff567224ULL, 0x000fe200020e06ffULL, 0x0000001b15157c11ULL, 0x000fe2000b0f4c5aULL,
0x000000100a167825ULL, 0x000fe200078e0016ULL, 0x0000000d18577c10ULL, 0x000fc4000ff7e0ffULL,
0x0000001a19187c11ULL, 0x000fe2000f8c48ffULL, 0x000000100a107825ULL, 0x040fe200078e0010ULL,
0x000000424300720cULL, 0x080fe20003f86070ULL, 0x00000000165f7faeULL, 0x0007e2000e901c4eULL,
0x0000001b19197c11ULL, 0x000fe2000b0f4c56ULL, 0x000000ffff567224ULL, 0x000fe200018e06ffULL,
0x0000001a571a7c11ULL, 0x002fe2000f8648ffULL, 0x000000100a127825ULL, 0x040fe200078e0012ULL,
0x000000423b00720cULL, 0x080fe40003fc6070ULL, 0x000000423f00720cULL, 0x000fe20003fa6070ULL,
0x000000100a147825ULL, 0x000fe200078e0014ULL, 0x0000001b571b7c11ULL, 0x000fc400098f4c56ULL,
0x000000424100720cULL, 0x000fe20003f66070ULL, 0x000000100a187825ULL, 0x000fe200078e0018ULL,
0x000000183a397c11ULL, 0x004fe4000f8e20ffULL, 0x000000183c3b7c11ULL, 0x000fe2000f8e20ffULL,
0x000000100a1a7825ULL, 0x000fe200078e001aULL, 0x00000018403f7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000010397faeULL, 0x0007e2000d101c4eULL, 0x000000183e417c11ULL, 0x000fc6000f8e20ffULL,
0x00000000123b7faeULL, 0x0007e8000e101c4eULL, 0x00000000143d7faeULL, 0x0007e8000f101c4eULL,
0x00000000183f7faeULL, 0x0007e8000e901c4eULL, 0x000000001a417faeULL, 0x0007e2000d901c4eULL,
0x0000000400947947ULL, 0x000fea0003800000ULL, 0x0000000800137811ULL, 0x040fe200078fe8ffULL,
0x000000400a0c7890ULL, 0x000fe2000fffe03fULL, 0x0000001000197811ULL, 0x040fe200078fe8ffULL,
0x00008a00001a7ab9ULL, 0x000fe20000000a00ULL, 0x0000001800437811ULL, 0x040fe200078fe8ffULL,
0x0000000113047824ULL, 0x140fe200078e0200ULL, 0x0000000400117811ULL, 0x040fe200078fe8ffULL,
0x00000008131b7824ULL, 0x000fe200078e00ffULL, 0x0000001400417811ULL, 0x040fe200078fe8ffULL,
0x00000001193f7824ULL, 0x140fe200078e0200ULL, 0x0000000c00177811ULL, 0x040fe200078fe8ffULL,
0x00000008190a7824ULL, 0x000fe200078e00ffULL, 0xfffffff81b567812ULL, 0x000fe200078ee204ULL,
0x00000001433d7824ULL, 0x140fe200078e0200ULL, 0x0000000c00107c11ULL, 0x040fe2000f8fe8ffULL,
0x0000000843047824ULL, 0x000fe200078e00ffULL, 0xfffffff80a3f7812ULL, 0x000fe200078ee23fULL,
0x0000000c110a7c36ULL, 0x000fe20008000000ULL, 0x0000001c00577811ULL, 0x000fe200078fe8ffULL,
0x0000000111167824ULL, 0x140fe200078e0200ULL, 0xfffffff8043d7812ULL, 0x000fe200078ee23dULL,
0x0000000811157824ULL, 0x000fe200078e00ffULL, 0x0000000d0a0a7c10ULL, 0x000fe2000ff7e0ffULL,
0x0000000c13047c36ULL, 0x000fe20008000000ULL, 0x0000000d10107c10ULL, 0x000fe2000ff5e0ffULL,
0x00000001413e7824ULL, 0x140fe200078e0200ULL, 0xfffffff815167812ULL, 0x000fe200078ee216ULL,
0x0000000841157824ULL, 0x000fe200078e00ffULL, 0x0000000d04047c10ULL, 0x000fe2000ff9e0ffULL,
0x0000000117407824ULL, 0x100fe200078e0200ULL, 0x000000183f3f7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000817397824ULL, 0x000fe200078e00ffULL, 0xfffffff8153e7812ULL, 0x000fe200078ee23eULL,
0x000000ffff137224ULL, 0x000fe200018e06ffULL, 0x0000001a0a387c11ULL, 0x040fe2000f8648ffULL,
0x00000001573c7824ULL, 0x040fe200078e0200ULL, 0xfffffff839407812ULL, 0x000fe200078ee240ULL,
0x00000008571b7824ULL, 0x000fe200078e00ffULL, 0x0000001b0a397c11ULL, 0x000fe200098f4c13ULL,
0x000000ffff157224ULL, 0x000fe200010e06ffULL, 0x0000001a103a7c11ULL, 0x000fe2000f8448ffULL,
0x000000ffff117224ULL, 0x000fe200020e06ffULL, 0x0000001a041a7c11ULL, 0x000fe2000f8848ffULL,
0x0000000c17177c36ULL, 0x000fe20008000000ULL, 0xfffffff81b3c7812ULL, 0x000fe200078ee23cULL,
0x0000000c19137c36ULL, 0x000fe20008000000ULL, 0x0000001b103b7c11ULL, 0x000fe200090f4c15ULL,
0x0000000c410a7c36ULL, 0x000fe20008000000ULL, 0x0000001b041b7c11ULL, 0x000fe2000a0f4c11ULL,
0x0000000c43437c36ULL, 0x000fe20008000000ULL, 0x0000000d17117c10ULL, 0x000fe2000ff5e0ffULL,
0x0000000c57197c36ULL, 0x000fe20008000000ULL, 0x0000000d13137c10ULL, 0x000fc4000ff7e0ffULL,
0x0000000000177211ULL, 0x040fe200078fe8ffULL, 0x000000ffff427224ULL, 0x000fe200010e06ffULL,
0x0ffffff800047812ULL, 0x000fe200078ec0ffULL, 0x000000ffff187224ULL, 0x000fe200018e06ffULL,
0x0000000d0a0a7c10ULL, 0x000fe4000ff9e0ffULL, 0x0000001a11107c11ULL, 0x000fe4000f8448ffULL,
0x0000000704177812ULL, 0x000fe200078ef817ULL, 0x000000ffff157224ULL, 0x000fe200020e06ffULL,
0x0000001a13127c11ULL, 0x000fc4000f8648ffULL, 0x0000001b11117c11ULL, 0x000fe400090f4c42ULL,
0x0000001817417c11ULL, 0x000fe4000f8e20ffULL, 0x0000001a0a147c11ULL, 0x000fe4000f8848ffULL,
0x0000001b13137c11ULL, 0x000fe400098f4c18ULL, 0x0000000d43177c10ULL, 0x000fe4000ff5e0ffULL,
0x0000000d19197c10ULL, 0x000fc4000ff7e0ffULL, 0x0000001b0a157c11ULL, 0x000fe2000a0f4c15ULL,
0x00000013590a7c36ULL, 0x000fe20008000000ULL, 0x0000001856577c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff567224ULL, 0x000fe200010e06ffULL, 0x0000001816437c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff427224ULL, 0x000fe200018e06ffULL, 0x0000001a17167c11ULL, 0x000fe2000f8448ffULL,
0x000000100a3a7825ULL, 0x040fe200078e003aULL, 0x0000001a19187c11ULL, 0x000fe4000f8648ffULL,
0x0000001b17177c11ULL, 0x000fe200090f4c56ULL, 0x000000100a387825ULL, 0x000fe200078e0038ULL,
0x0000001b19197c11ULL, 0x000fe200098f4c42ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a417faeULL, 0x0003e2000b901c4eULL, 0x00000018405b7c11ULL, 0x000fe2000f8e20ffULL,
0x000000100a1a7825ULL, 0x000fe200078e001aULL, 0x000000183e5d7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000038437faeULL, 0x0003e2000b901c4eULL, 0x000000183d3d7c11ULL, 0x000fe2000f8e20ffULL,
0x000000100a107825ULL, 0x000fe200078e0010ULL, 0x000000183c5f7c11ULL, 0x000fe2000f8e20ffULL,
0x000000001a577faeULL, 0x0003e4000b901c4eULL, 0x000000100a127825ULL, 0x000fc400078e0012ULL,
0x00000000105b7faeULL, 0x0003e4000b901c4eULL, 0x000000100a147825ULL, 0x040fe400078e0014ULL,
0x00000000123f7faeULL, 0x0003e4000b901c4eULL, 0x000000100a167825ULL, 0x040fe400078e0016ULL,
0x00000000145d7faeULL, 0x0003e4000b901c4eULL, 0x000000100a187825ULL, 0x000fc400078e0018ULL,
0x00000000163d7faeULL, 0x0003e8000b901c4eULL, 0x00000000185f7faeULL, 0x0003e4000b901c4eULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000000188947ULL, 0x000fea0003800000ULL, 0x00000002ff117819ULL, 0x00afe40000011600ULL,
0x00000005ff06723eULL, 0x000fc600000010ffULL, 0x0000000811077836ULL, 0x000fe20000000000ULL,
0x0000541006107816ULL, 0x000fca0000000006ULL, 0x00001f1110067589ULL, 0x0002a800000e0000ULL,
0x00001f0710077589ULL, 0x0002e400000e0000ULL, 0x013000004b10783bULL, 0x00a2e20000000200ULL,
0x0000000000108947ULL, 0x000fea0003800000ULL, 0x0000000610107232ULL, 0x08cfe40000200000ULL,
0x0000000612127232ULL, 0x000fe40000200000ULL, 0x0000000711117232ULL, 0x080fe40000200000ULL,
0x0000000713137232ULL, 0x000fce0000200000ULL, 0x000000004a3c783bULL, 0x000f280000004200ULL,
0x000000004938783bULL, 0x000f680000004200ULL, 0x000000004818783bULL, 0x000f680000004200ULL,
0x000000000f14783bULL, 0x000f620000004200ULL, 0x0000003c1034723cULL, 0x018fec0000041834ULL,
0x0000003e1030723cULL, 0x000fec0000041830ULL, 0x000000381044723cULL, 0x022fec0000041844ULL,
0x0000003a102c723cULL, 0x000fec000004182cULL, 0x000000181028723cULL, 0x000fec0000041828ULL,
0x0000001a1024723cULL, 0x000fec0000041824ULL, 0x000000141020723cULL, 0x004fec0000041820ULL,
0x00000016101c723cULL, 0x000fe2000004181cULL, 0x013000000810783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000108947ULL, 0x000fde0003800000ULL,
0x0000000610107232ULL, 0x084fe40000200000ULL, 0x0000000612127232ULL, 0x000fe40000200000ULL,
0x0000000711117232ULL, 0x080fe40000200000ULL, 0x0000000713137232ULL, 0x000fce0000200000ULL,
0x000000000b14783bULL, 0x000ee20000004200ULL, 0x000000c0050c7891ULL, 0x000fc6000f8e403fULL,
0x000000000c3c783bULL, 0x000f220000004200ULL, 0x000000140c00728cULL, 0x000fc6000bf06070ULL,
0x000000000e38783bULL, 0x000f660000004200ULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x000000000d18783bULL, 0x000f620000004200ULL, 0x000000141020723cULL, 0x00cfec0000041820ULL,
0x0000003c1034723cULL, 0x010fe20000041834ULL, 0x00000001ff157424ULL, 0x000fc800078e00ffULL,
0x01c69815ffff79a7ULL, 0x0005e20008500004ULL, 0x0000003e1030723cULL, 0x000fec0000041830ULL,
0x000000381044723cULL, 0x022fec0000041844ULL, 0x0000003a102c723cULL, 0x000fec000004182cULL,
0x000000181028723cULL, 0x000fec0000041828ULL, 0x0000001a1024723cULL, 0x000fec0000041824ULL,
0x00000016101c723cULL, 0x000fe2000004181cULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x00000028001c0947ULL, 0x004fde0003800000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000400c89947ULL, 0x000fea0003800000ULL, 0x00000003ff137819ULL, 0x100fe20000011600ULL,
0x000000600a127890ULL, 0x000fe4000fffe03fULL, 0x000000200c097890ULL, 0x000fe4000fffe03fULL,
0x0000000413197836ULL, 0x000fe40000000000ULL, 0x0000000113117824ULL, 0x100fe200078e0200ULL,
0x000000091400728cULL, 0x000fe2000bf01070ULL, 0x0000000119427824ULL, 0x040fe400078e0200ULL,
0x0000000819177824ULL, 0x000fe200078e00ffULL, 0x0000000704167812ULL, 0x000fe200078ef811ULL,
0x0000000c135d7836ULL, 0x000fe20000000000ULL, 0x00000009140c7287ULL, 0x000fe2000c000000ULL,
0x00000008135b7836ULL, 0x000fe20000000000ULL, 0xfffffff817427812ULL, 0x000fe200078ee242ULL,
0x0000001013177836ULL, 0x000fc40000000000ULL, 0x000000015d047824ULL, 0x140fe400078e0200ULL,
0x000000085d117824ULL, 0x000fe400078e00ffULL, 0x0000000117147824ULL, 0x140fe400078e0200ULL,
0x00000008171b7824ULL, 0x000fe200078e00ffULL, 0xfffffff811047812ULL, 0x000fe200078ee204ULL,
0x000000015b417824ULL, 0x040fe400078e0200ULL, 0x000000085b107824ULL, 0x000fe200078e00ffULL,
0xfffffff81b147812ULL, 0x000fe200078ee214ULL, 0x0000001213117c36ULL, 0x000fc40008000000ULL,
0x0000001413577836ULL, 0x000fe20000000000ULL, 0xfffffff810417812ULL, 0x000fe200078ee241ULL,
0x00000018131b7836ULL, 0x000fe20000000000ULL, 0x0000000d11117c10ULL, 0x000fe2000ff1e0ffULL,
0x00000001573e7824ULL, 0x100fe200078e0200ULL, 0x0000001641417c11ULL, 0x000fe2000f8e20ffULL,
0x0000000857397824ULL, 0x000fe400078e00ffULL, 0x000000011b3f7824ULL, 0x040fe400078e0200ULL,
0x000000081b107824ULL, 0x000fe200078e00ffULL, 0xfffffff8393e7812ULL, 0x000fe200078ee23eULL,
0x000000ffff127224ULL, 0x000fe200000e06ffULL, 0x0000001a113c7c11ULL, 0x040fe2000f8048ffULL,
0x80000009ff567e24ULL, 0x000fe2000f8e02ffULL, 0xfffffff8103f7812ULL, 0x000fe200078ee23fULL,
0x0000000cff397e24ULL, 0x000fe2000f8e00ffULL, 0x0000001b113d7c11ULL, 0x000fe200080f4c12ULL,
0x0000001219107c36ULL, 0x000fe20008000000ULL, 0x000000163f3f7c11ULL, 0x000fe2000f8e20ffULL,
0x000000125b187c36ULL, 0x000fe20008000000ULL, 0x0000002039567446ULL, 0x000fe20003800056ULL,
0x0000001c13437836ULL, 0x000fe20000000000ULL, 0x0000000d10107c10ULL, 0x000fe2000ff3e0ffULL,
0x000000100a3c7825ULL, 0x000fe200078e003cULL, 0x0000000d18117c10ULL, 0x000fc4000ff5e0ffULL,
0x000000561300720cULL, 0x080fe20003fa6070ULL, 0x0000000143407824ULL, 0x040fe200078e0200ULL,
0x0000001a10387c11ULL, 0x040fe2000f8048ffULL, 0x00000008433b7824ULL, 0x000fe400078e00ffULL,
0x000000ffff137224ULL, 0x000fe200008e06ffULL, 0x0000001a113a7c11ULL, 0x040fe2000f8248ffULL,
0x000000ffff127224ULL, 0x000fe200010e06ffULL, 0xfffffff83b407812ULL, 0x000fe200078ee240ULL,
0x000000125d187c36ULL, 0x000fe20008000000ULL, 0x0000001b10397c11ULL, 0x000fe200080f4c13ULL,
0x00000012435c7c36ULL, 0x000fe20008000000ULL, 0x0000001b113b7c11ULL, 0x000fe200088f4c12ULL,
0x0000001217117c36ULL, 0x000fe20008000000ULL, 0x0000000d18107c10ULL, 0x000fe2000ff5e0ffULL,
0x0000001257127c36ULL, 0x000fe20008000000ULL, 0x000000561900720cULL, 0x000fe20003f06070ULL,
0x000000100a387825ULL, 0x000fe200078e0038ULL, 0x0000000d11117c10ULL, 0x000fc4000ff7e0ffULL,
0x000000565b00720cULL, 0x080fe20003f26070ULL, 0x000000ffff137224ULL, 0x000fe200010e06ffULL,
0x0000001a10187c11ULL, 0x040fe2000f8448ffULL, 0x000000ffff1a7224ULL, 0x000fe400018e06ffULL,
0x000000121b5b7c36ULL, 0x000fe20008000000ULL, 0x0000001b10197c11ULL, 0x000fe200090f4c13ULL,
0x000000100a3a7825ULL, 0x040fe200078e003aULL, 0x0000000d12137c10ULL, 0x000fe4000ff9e0ffULL,
0x0000001a11107c11ULL, 0x000fe2000f8648ffULL, 0x000000100a187825ULL, 0x000fe200078e0018ULL,
0x000000565d00720cULL, 0x000fc40003f46070ULL, 0x0000001b11117c11ULL, 0x000fe200098f4c1aULL,
0x000000ffff5a7224ULL, 0x000fe200020e06ffULL, 0x0000000d5b1a7c10ULL, 0x000fe4000ff7e0ffULL,
0x0000001a13127c11ULL, 0x040fe2000f8848ffULL, 0x000000100a107825ULL, 0x000fe200078e0010ULL,
0x00000016165d7c11ULL, 0x000fe4000f8e20ffULL, 0x0000001b13137c11ULL, 0x000fe2000a0f4c5aULL,
0x000000ffff5b7224ULL, 0x000fe200018e06ffULL, 0x0000000d5c5a7c10ULL, 0x000fe2000ff9e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c5d7faeULL, 0x0003e2000e901c4eULL,
0x0000001a1a167c11ULL, 0x000fe2000f8c48ffULL, 0x000000100a127825ULL, 0x000fe200078e0012ULL,
0x000000561700720cULL, 0x000fc40003f66070ULL, 0x0000001b1a177c11ULL, 0x000fe2000b0f4c5bULL,
0x000000ffff5b7224ULL, 0x000fe200020e06ffULL, 0x0000001a5a1a7c11ULL, 0x000fe4000f8848ffULL,
0x000000565700720cULL, 0x080fe20003fc6070ULL, 0x000000100a167825ULL, 0x000fe200078e0016ULL,
0x000000561b00720cULL, 0x080fe40003fa6070ULL, 0x0000001b5a1b7c11ULL, 0x000fe4000a0f4c5bULL,
0x000000564300720cULL, 0x000fc40003f86070ULL, 0x0000001642437c11ULL, 0x000fe2000f8e20ffULL,
0x000000100a1a7825ULL, 0x000fe200078e001aULL, 0x00000016043d7c11ULL, 0x002fe4000f8e20ffULL,
0x0000001614577c11ULL, 0x000fe2000f8e20ffULL, 0x0000000038437faeULL, 0x0003e2000c101c4eULL,
0x000000163e5b7c11ULL, 0x000fe4000f8e20ffULL, 0x00000016405d7c11ULL, 0x000fe2000f8e20ffULL,
0x000000003a417faeULL, 0x0003e8000c901c4eULL, 0x00000000183d7faeULL, 0x0003e8000d101c4eULL,
0x0000000010577faeULL, 0x0003e8000d901c4eULL, 0x00000000125b7faeULL, 0x0003e8000f101c4eULL,
0x00000000163f7faeULL, 0x0003e8000e901c4eULL, 0x000000001a5d7faeULL, 0x0003e2000e101c4eULL,
0x0000000400887947ULL, 0x000fea0003800000ULL, 0x0000000800137811ULL, 0x040fe200078fe8ffULL,
0x000000600a097890ULL, 0x000fe2000fffe03fULL, 0x0000000400117811ULL, 0x040fe400078fe8ffULL,
0x0000001000397811ULL, 0x040fe200078fe8ffULL, 0x0000000113437824ULL, 0x140fe200078e0200ULL,
0x0000001400577811ULL, 0x040fe200078fe8ffULL, 0x0000000813107824ULL, 0x000fe200078e00ffULL,
0x0000000c00197811ULL, 0x040fe200078fe8ffULL, 0x0000000111427824ULL, 0x140fe200078e0200ULL,
0x00000018005b7811ULL, 0x040fe200078fe8ffULL, 0x0000000811177824ULL, 0x000fe200078e00ffULL,
0xfffffff810437812ULL, 0x000fe200078ee243ULL, 0x00000001393f7824ULL, 0x140fe200078e0200ULL,
0x0000000000417211ULL, 0x040fe200078fe8ffULL, 0x0000000839107824ULL, 0x000fe200078e00ffULL,
0xfffffff817427812ULL, 0x000fe200078ee242ULL, 0x00000001573e7824ULL, 0x140fe200078e0200ULL,
0x0000001c005d7811ULL, 0x040fe200078fe8ffULL, 0x0000000857177824ULL, 0x000fe200078e00ffULL,
0xfffffff8103f7812ULL, 0x000fe200078ee23fULL, 0x0000000911187c36ULL, 0x000fe20008000000ULL,
0x0000000704417812ULL, 0x000fe200078ef841ULL, 0x0000000913127c36ULL, 0x000fe20008000000ULL,
0xfffffff8173e7812ULL, 0x000fe200078ee23eULL, 0x0000000919107c36ULL, 0x000fe20008000000ULL,
0x0000000900177c11ULL, 0x000fe2000f8fe8ffULL, 0x0000000119407824ULL, 0x140fe200078e0200ULL,
0x0000000d18187c10ULL, 0x000fe2000ff3e0ffULL, 0x00000008191b7824ULL, 0x000fe200078e00ffULL,
0x0000000d12127c10ULL, 0x000fe2000ff5e0ffULL, 0x000000015b147824ULL, 0x100fe200078e0200ULL,
0x0000000d10107c10ULL, 0x000fe2000ff7e0ffULL, 0x000000015d047824ULL, 0x000fe200078e0200ULL,
0xfffffff81b407812ULL, 0x000fe200078ee240ULL, 0x000000085b1b7824ULL, 0x000fe200078e00ffULL,
0x0000000d17177c10ULL, 0x000fe2000ff1e0ffULL, 0x000000085d3b7824ULL, 0x000fe200078e00ffULL,
0x0000001641417c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff197224ULL, 0x000fe200008e06ffULL,
0x0000001a181a7c11ULL, 0x000fe2000f8248ffULL, 0x000000ffff137224ULL, 0x000fe200010e06ffULL,
0x0000001a123a7c11ULL, 0x000fe2000f8448ffULL, 0x000000ffff117224ULL, 0x000fe200018e06ffULL,
0x0000001a103c7c11ULL, 0x000fe2000f8648ffULL, 0x000000ffff387224ULL, 0x000fe200000e06ffULL,
0xfffffff81b147812ULL, 0x000fe200078ee214ULL, 0x0000000939397c36ULL, 0x000fe20008000000ULL,
0xfffffff83b047812ULL, 0x000fc400078ee204ULL, 0x0000001a17167c11ULL, 0x040fe4000f8048ffULL,
0x0000001b181b7c11ULL, 0x000fe200088f4c19ULL, 0x0000000957197c36ULL, 0x000fe20008000000ULL,
0x0000001b123b7c11ULL, 0x000fe200090f4c13ULL, 0x000000095b137c36ULL, 0x000fe20008000000ULL,
0x0000001b103d7c11ULL, 0x000fe200098f4c11ULL, 0x000000095d117c36ULL, 0x000fe20008000000ULL,
0x0000001b17177c11ULL, 0x000fe200080f4c38ULL, 0x000000100a1a7825ULL, 0x000fe200078e001aULL,
0x0000000d39397c10ULL, 0x000fc4000ff1e0ffULL, 0x0000000d19197c10ULL, 0x000fe2000ff3e0ffULL,
0x000000100a167825ULL, 0x040fe200078e0016ULL, 0x0000000d13137c10ULL, 0x000fe4000ff5e0ffULL,
0x0000000d11117c10ULL, 0x000fe2000ff7e0ffULL, 0x000000ffff5e7224ULL, 0x000fe200000e06ffULL,
0x0000001a39387c11ULL, 0x000fe2000f8048ffULL, 0x000000ffff5c7224ULL, 0x000fe200008e06ffULL,
0x0000001a19187c11ULL, 0x000fe2000f8248ffULL, 0x000000ffff5a7224ULL, 0x000fe200010e06ffULL,
0x0000001a13127c11ULL, 0x000fe2000f8448ffULL, 0x000000ffff567224ULL, 0x000fe200018e06ffULL,
0x0000001a11107c11ULL, 0x000fe2000f8648ffULL, 0x000000100a3a7825ULL, 0x040fe200078e003aULL,
0x0000001b39397c11ULL, 0x000fe200080f4c5eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016417faeULL, 0x0003e2000b901c4eULL, 0x0000001b19197c11ULL, 0x000fe200088f4c5cULL,
0x000000100a3c7825ULL, 0x000fe200078e003cULL, 0x0000001b13137c11ULL, 0x000fc400090f4c5aULL,
0x0000001642577c11ULL, 0x000fe2000f8e20ffULL, 0x000000100a387825ULL, 0x040fe200078e0038ULL,
0x0000001b11117c11ULL, 0x000fe400098f4c56ULL, 0x0000001643437c11ULL, 0x000fe2000f8e20ffULL,
0x000000100a187825ULL, 0x000fe200078e0018ULL, 0x00000016405b7c11ULL, 0x000fe2000f8e20ffULL,
0x000000001a577faeULL, 0x0003e2000b901c4eULL, 0x000000163f3f7c11ULL, 0x000fe2000f8e20ffULL,
0x000000100a127825ULL, 0x000fe200078e0012ULL, 0x000000163e5d7c11ULL, 0x000fe2000f8e20ffULL,
0x000000003a437faeULL, 0x0003e2000b901c4eULL, 0x00000016145f7c11ULL, 0x000fe2000f8e20ffULL,
0x000000100a107825ULL, 0x000fe200078e0010ULL, 0x0000001604617c11ULL, 0x000fe2000f8e20ffULL,
0x000000003c5b7faeULL, 0x0003e8000b901c4eULL, 0x00000000383f7faeULL, 0x0003e8000b901c4eULL,
0x00000000185d7faeULL, 0x0003e8000b901c4eULL, 0x00000000125f7faeULL, 0x0003e8000b901c4eULL,
0x0000000010617faeULL, 0x0003e4000b901c4eULL, 0x000000150b0b7290ULL, 0x000fe2000fffe03fULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffff10097891ULL, 0x000fe4000f8e083fULL,
0x000000010b0c7892ULL, 0x000fc8000f8ec03fULL, 0x000000010c00788cULL, 0x000fc8000bf05070ULL,
0x0000000109097887ULL, 0x000fc8000c000000ULL, 0x000000090b097290ULL, 0x000fc8000fffe03fULL,
0x000000060900728cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fca0003f0f008ULL,
0x00000008090b8290ULL, 0x000fe2000fffe03fULL, 0x00008c00000c8ab9ULL, 0x000fc60000000a00ULL,
0x000000040b0c88a5ULL, 0x000fcc000f8e000cULL, 0x0000000cff107e24ULL, 0x002fe4000f8e00ffULL,
0x0000000dff117e24ULL, 0x000fca000f8e00ffULL, 0x0000000e10108981ULL, 0x000ea2000c1e1900ULL,
0x01c66815581479a7ULL, 0x000e620008500004ULL, 0xffffffff00177882ULL, 0x000fe20000000000ULL,
0x00000000100b82caULL, 0x004fda00000e0000ULL, 0x0000000b00178c82ULL, 0x000fe20008000000ULL,
0x0000000000107805ULL, 0x000fe20000015200ULL, 0x01c66815580075a7ULL, 0x002e640008000144ULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff0a7224ULL, 0x000fce00078e00ffULL,
0x000000100a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x0000001210177210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc80000011413ULL,
0x0000001704047211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000204047819ULL, 0x000fc80000001213ULL, 0x000000040000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000010a0a7836ULL, 0x000fce0000000000ULL,
0x01c66815580075a7ULL, 0x000e640008000144ULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x01c18000030a7984ULL, 0x000e680000000800ULL, 0x01c3800003047984ULL, 0x0004a20000000800ULL,
0x000000090a00720bULL, 0x002fda0003f1d000ULL, 0x0000000000127806ULL, 0x000fe400000e0100ULL,
0x000000000000781cULL, 0x000fe40003f0e170ULL, 0x0000ffff12ff7812ULL, 0x000fda000782c0ffULL,
0x0000000000f09947ULL, 0x004fea0003800000ULL, 0x000000031100788cULL, 0x000fe2000bf05270ULL,
0x000000090a00720bULL, 0x000fca0003f14000ULL, 0x000000000000781cULL, 0x000fd00003f2f008ULL,
0x0000000000137806ULL, 0x000fc800000e0100ULL, 0x0000991013117816ULL, 0x000fe400000000ffULL,
0x000000090a109209ULL, 0x000fe40007810000ULL, 0x000000ff1100720cULL, 0x000fc60003f05270ULL,
0x01c5801003009388ULL, 0x0003f40000000800ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x000000090a107209ULL, 0x000fe40007810000ULL, 0x000000ff13ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0013ff7812ULL, 0x000fe2000782c0ffULL, 0x0000000910037221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b03037820ULL, 0x000fc80000410000ULL, 0x0000000300117308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff107819ULL, 0x000fca0000011600ULL,
0x00001f1011037589ULL, 0x006e6400000e0000ULL, 0x0000000334347220ULL, 0x082fe20000410000ULL,
0x0000000335357220ULL, 0x080fe20000410000ULL, 0x0000000330307220ULL, 0x080fe20000410000ULL,
0x0000000331317220ULL, 0x080fe20000410000ULL, 0x0000000344447220ULL, 0x080fe20000410000ULL,
0x0000000345457220ULL, 0x080fe20000410000ULL, 0x000000032c2c7220ULL, 0x080fe20000410000ULL,
0x000000032d2d7220ULL, 0x080fe20000410000ULL, 0x0000000328287220ULL, 0x080fe20000410000ULL,
0x0000000329297220ULL, 0x080fe20000410000ULL, 0x0000000324247220ULL, 0x080fe20000410000ULL,
0x0000000325257220ULL, 0x080fe20000410000ULL, 0x0000000320207220ULL, 0x080fe20000410000ULL,
0x0000000321217220ULL, 0x080fe20000410000ULL, 0x000000031c1c7220ULL, 0x080fe20000410000ULL,
0x000000031d1d7220ULL, 0x000fce0000410000ULL, 0x0000001102027220ULL, 0x004fe20000410000ULL,
0x0000000000489947ULL, 0x000fec0003800000ULL, 0x0000000800107811ULL, 0x000fca00078ff0ffULL,
0x00001f1011037589ULL, 0x002e6400000e0000ULL, 0x0000000336367220ULL, 0x082fe20000410000ULL,
0x0000000337377220ULL, 0x080fe20000410000ULL, 0x0000000332327220ULL, 0x080fe20000410000ULL,
0x0000000333337220ULL, 0x080fe20000410000ULL, 0x0000000346467220ULL, 0x080fe20000410000ULL,
0x0000000347477220ULL, 0x080fe20000410000ULL, 0x000000032e2e7220ULL, 0x080fe20000410000ULL,
0x000000032f2f7220ULL, 0x080fe20000410000ULL, 0x000000032a2a7220ULL, 0x080fe20000410000ULL,
0x000000032b2b7220ULL, 0x080fe20000410000ULL, 0x0000000326267220ULL, 0x080fe20000410000ULL,
0x0000000327277220ULL, 0x080fe20000410000ULL, 0x0000000322227220ULL, 0x080fe20000410000ULL,
0x0000000323237220ULL, 0x080fe20000410000ULL, 0x000000031e1e7220ULL, 0x080fe20000410000ULL,
0x000000031f1f7220ULL, 0x000fce0000410000ULL, 0x0000ffff13ff7812ULL, 0x000fe40007800812ULL,
0x000000090a097209ULL, 0x000fd60007810000ULL, 0x800000090a0a0221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b0a0a0820ULL, 0x000fc80000410000ULL, 0x0000000a00050308ULL, 0x000ea40000000800ULL,
0x0000000504040220ULL, 0x004fce0000410000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000000188947ULL, 0x000fea0003800000ULL, 0x00000002ff067819ULL, 0x000fe40000011600ULL,
0x00000005ff03723eULL, 0x002fc600000010ffULL, 0x00000008060a7836ULL, 0x000fe20000000000ULL,
0x0000541003037816ULL, 0x000fca0000000003ULL, 0x00001f0603067589ULL, 0x0002a800000e0000ULL,
0x00001f0a03077589ULL, 0x0002e400000e0000ULL, 0x013800004e10783bULL, 0x0002e20000000200ULL,
0x0000000000108947ULL, 0x000fea0003800000ULL, 0x0000000610107232ULL, 0x08cfe40000200000ULL,
0x0000000612127232ULL, 0x000fe40000200000ULL, 0x0000000711117232ULL, 0x080fe40000200000ULL,
0x0000000713137232ULL, 0x000fce0000200000ULL, 0x000000004d14783bULL, 0x000f280000004200ULL,
0x000000005018783bULL, 0x000f680000004200ULL, 0x000000005238783bULL, 0x000f680000004200ULL,
0x00000000533c783bULL, 0x000f620000004200ULL, 0x000000141034723cULL, 0x018fec0000041834ULL,
0x000000181044723cULL, 0x022fec0000041844ULL, 0x000000161014723cULL, 0x000fec0000041830ULL,
0x0000001a1018723cULL, 0x000fec000004182cULL, 0x000000381028723cULL, 0x000fec0000041828ULL,
0x0000003a1024723cULL, 0x000fec0000041824ULL, 0x0000003c1020723cULL, 0x004fec0000041820ULL,
0x0000003e1010723cULL, 0x000fe2000004181cULL, 0x01380000551c783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000108947ULL, 0x000fde0003800000ULL,
0x000000061c1c7232ULL, 0x084fe40000200000ULL, 0x000000061e1e7232ULL, 0x000fe40000200000ULL,
0x000000071d1d7232ULL, 0x080fe40000200000ULL, 0x000000071f1f7232ULL, 0x000fce0000200000ULL,
0x000000004f2c783bULL, 0x000ee20000004200ULL, 0x00000005100b7290ULL, 0x000fe2000fffe03fULL,
0x0000000204027221ULL, 0x000fe40000010000ULL, 0x000000005454783bULL, 0x002e620000004200ULL,
0x000000010b0c7890ULL, 0x000fc6000fffe03fULL, 0x000000005150783bULL, 0x000f220000004200ULL,
0x000000070c00728cULL, 0x000fc6000bf06070ULL, 0x000000004c4c783bULL, 0x000f620000004200ULL,
0x00008400000c7ab9ULL, 0x000fe40000000800ULL, 0x000000000000781cULL, 0x000fe20003f2f008ULL,
0x0000000c170c72a4ULL, 0x000fc8000f8e023fULL, 0x000000070c0c7899ULL, 0x000fe2000800063fULL,
0x0000002c1c28723cULL, 0x00cfec0000041828ULL, 0x000000541c34723cULL, 0x002fec0000041834ULL,
0x000000561c14723cULL, 0x000fec0000041814ULL, 0x000000501c44723cULL, 0x010fec0000041844ULL,
0x000000521c18723cULL, 0x000fec0000041818ULL, 0x0000002e1c24723cULL, 0x000fec0000041824ULL,
0x0000004c1c20723cULL, 0x020fec0000041820ULL, 0x0000004e1c10723cULL, 0x000fe20000041810ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000400d09947ULL, 0x000fde0003800000ULL, 0x00000003ff337819ULL, 0x100fe20000011600ULL,
0x000000080b0b7899ULL, 0x000fe2000800063fULL, 0x0000001359597c36ULL, 0x000fe20008000000ULL,
0x00008a00001a7ab9ULL, 0x000fe40000000a00ULL, 0x00000004332d7836ULL, 0x000fe20000000000ULL,
0x0000000b1400728cULL, 0x000fe2000bf01070ULL, 0x0000000833417836ULL, 0x000fe40000000000ULL,
0x000000012d037824ULL, 0x040fe200078e0200ULL, 0x0000000b140d7287ULL, 0x000fe2000c000000ULL,
0x000000082d4c7824ULL, 0x000fc400078e00ffULL, 0x0000000c334d7836ULL, 0x000fe40000000000ULL,
0x00000014333b7836ULL, 0x000fe20000000000ULL, 0xfffffff84c4c7812ULL, 0x000fe200078ee203ULL,
0x00000001413a7824ULL, 0x140fe400078e0200ULL, 0x0000000841037824ULL, 0x000fe400078e00ffULL,
0x000000014d397824ULL, 0x140fe400078e0200ULL, 0x000000084d047824ULL, 0x000fe200078e00ffULL,
0xfffffff8033a7812ULL, 0x000fe200078ee23aULL, 0x000000013b0a7824ULL, 0x000fc400078e0200ULL,
0x000000083b1d7824ULL, 0x000fe200078e00ffULL, 0xfffffff804397812ULL, 0x000fe200078ee239ULL,
0x00000010333d7836ULL, 0x000fe40000000000ULL, 0x00000018333f7836ULL, 0x000fe20000000000ULL,
0xfffffff81d0a7812ULL, 0x000fe200078ee20aULL, 0x000000013d387824ULL, 0x100fe200078e0200ULL,
0x0000001839397c11ULL, 0x000fe2000f8e20ffULL, 0x000000083d037824ULL, 0x000fe400078e00ffULL,
0x000000013f047824ULL, 0x000fc400078e0200ULL, 0x000000083f1d7824ULL, 0x000fe200078e00ffULL,
0xfffffff803387812ULL, 0x000fe200078ee238ULL, 0x0000001c334f7836ULL, 0x000fe40000000000ULL,
0x0000000a331f7c36ULL, 0x000fe20008000000ULL, 0xfffffff81d047812ULL, 0x000fe200078ee204ULL,
0x000000014f037824ULL, 0x040fe400078e0200ULL, 0x000000084f1c7824ULL, 0x000fe200078e00ffULL,
0x0000000c1f1f7c10ULL, 0x000fe2000ff3e0ffULL, 0x0000000a2d1d7c36ULL, 0x000fc40008000000ULL,
0x8000000bff3e7e24ULL, 0x000fe2000f8e02ffULL, 0xfffffff81c037812ULL, 0x000fe200078ee203ULL,
0x0000000a411c7c36ULL, 0x000fe20008000000ULL, 0x0000000c1d1d7c10ULL, 0x000fe2000ff5e0ffULL,
0x0000000dff2f7e24ULL, 0x000fe2000f8e00ffULL, 0x0000001803037c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff2c7224ULL, 0x000fe200008e06ffULL, 0x0000000c1c1c7c10ULL, 0x000fe2000ff7e0ffULL,
0x000000ffff1e7224ULL, 0x000fe200010e06ffULL, 0x0000001a1d2e7c11ULL, 0x000fe2000f8448ffULL,
0x0000000a3b407c36ULL, 0x000fe20008000000ULL, 0x0000001a1f307c11ULL, 0x000fe2000f8248ffULL,
0x0000000a3f427c36ULL, 0x000fe20008000000ULL, 0x000000202f3e7446ULL, 0x000fc4000380003eULL,
0x0000001b1d2f7c11ULL, 0x000fe200090f4c1eULL, 0x000000ffff1d7224ULL, 0x000fe200018e06ffULL,
0x0000001b1f317c11ULL, 0x000fe200088f4c2cULL, 0x0000000a3d1e7c36ULL, 0x000fe20008000000ULL,
0x0000001a1c2c7c11ULL, 0x040fe2000f8248ffULL, 0x0000000a4d1f7c36ULL, 0x000fe20008000000ULL,
0x0000003e2d00720cULL, 0x000fe20003fa6070ULL, 0x00000010592e7825ULL, 0x000fe200078e002eULL,
0x0000001b1c2d7c11ULL, 0x000fe400088f4c1dULL, 0x0000000c1e1d7c10ULL, 0x000fc4000ff9e0ffULL,
0x0000000c1f1f7c10ULL, 0x000fe2000ff7e0ffULL, 0x00000010592c7825ULL, 0x000fe200078e002cULL,
0x0000003e3300720cULL, 0x080fe40003f46070ULL, 0x0000003e4100720cULL, 0x000fe20003f26070ULL,
0x0000000133337824ULL, 0x000fe400078e0200ULL, 0x000000ffff327224ULL, 0x000fe200020e06ffULL,
0x0000001a1d1c7c11ULL, 0x000fe2000f8848ffULL, 0x000000ffff3c7224ULL, 0x000fe200018e06ffULL,
0x0000001a1f1e7c11ULL, 0x000fc4000f8648ffULL, 0x0000000733337812ULL, 0x000fe400078ec0ffULL,
0x0000001b1d1d7c11ULL, 0x000fe4000a0f4c32ULL, 0x0000001b1f1f7c11ULL, 0x000fe400098f4c3cULL,
0x0ffffff833327812ULL, 0x000fe200078ef800ULL, 0x00000010591c7825ULL, 0x040fe200078e001cULL,
0x0000000c40337c10ULL, 0x000fe4000ff7e0ffULL, 0x0000001832437c11ULL, 0x000fe2000f8e20ffULL,
0x0000001059407825ULL, 0x000fe200078e0030ULL, 0x0000003e4d00720cULL, 0x000fc40003f86070ULL,
0x000000184c4d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff3c7224ULL, 0x000fe200018e06ffULL,
0x0000001a33327c11ULL, 0x000fe2000f8648ffULL, 0x0000000a4f307c36ULL, 0x000fe20008000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000040437faeULL, 0x000fe2000d101c4eULL,
0x00000010591e7825ULL, 0x000fe200078e001eULL, 0x0000001b33337c11ULL, 0x000fe400098f4c3cULL,
0x0000000c42317c10ULL, 0x000fe2000ff7e0ffULL, 0x000000002e4d7faeULL, 0x0003e2000e901c4eULL,
0x0000000c30427c10ULL, 0x000fe2000ff5e0ffULL, 0x0000001059327825ULL, 0x000fe200078e0032ULL,
0x0000001a31307c11ULL, 0x000fc4000f8c48ffULL, 0x0000003e3f00720cULL, 0x080fe20003fa6070ULL,
0x000000ffff3c7224ULL, 0x000fe200018e06ffULL, 0x0000003e3d00720cULL, 0x080fe20003f66070ULL,
0x000000ffff3d7224ULL, 0x000fe200010e06ffULL, 0x000000180a3f7c11ULL, 0x000fe4000f8e20ffULL,
0x0000001b31317c11ULL, 0x000fe4000b0f4c3cULL, 0x0000001a423c7c11ULL, 0x040fe4000f8448ffULL,
0x0000003e3b00720cULL, 0x000fe20003fc6070ULL, 0x0000001059307825ULL, 0x000fe200078e0030ULL,
0x0000001b423d7c11ULL, 0x000fc400090f4c3dULL, 0x0000003e4f00720cULL, 0x000fe40003f46070ULL,
0x000000183a3b7c11ULL, 0x000fe2000f8e20ffULL, 0x00000010592e7825ULL, 0x002fe200078e003cULL,
0x00000018383d7c11ULL, 0x000fe4000f8e20ffULL, 0x0000001804417c11ULL, 0x000fe2000f8e20ffULL,
0x000000002c3b7faeULL, 0x0003e8000c901c4eULL, 0x000000001e397faeULL, 0x0003e8000e101c4eULL,
0x000000001c3d7faeULL, 0x0003e8000d901c4eULL, 0x00000000323f7faeULL, 0x0003e8000f101c4eULL,
0x0000000030417faeULL, 0x0003e8000e901c4eULL, 0x000000002e037faeULL, 0x0003e2000d101c4eULL,
0x0000000400907947ULL, 0x000fea0003800000ULL, 0x00000008001f7811ULL, 0x040fe200078fe8ffULL,
0x00008a00001a7ab9ULL, 0x000fe20000000a00ULL, 0x0000001000337811ULL, 0x040fe200078fe8ffULL,
0x0000001359597c36ULL, 0x000fe20008000000ULL, 0x0000000c002d7811ULL, 0x040fe200078fe8ffULL,
0x000000011f047824ULL, 0x140fe200078e0200ULL, 0x00000004001d7811ULL, 0x040fe200078fe8ffULL,
0x000000081f437824ULL, 0x000fe200078e00ffULL, 0x0000001400397811ULL, 0x040fe200078fe8ffULL,
0x00000001331c7824ULL, 0x140fe200078e0200ULL, 0x00000018003f7811ULL, 0x040fe200078fe8ffULL,
0x0000000833317824ULL, 0x000fe200078e00ffULL, 0xfffffff843437812ULL, 0x000fe200078ee204ULL,
0x000000012d0a7824ULL, 0x140fe200078e0200ULL, 0x0000001c004d7811ULL, 0x040fe200078fe8ffULL,
0x000000082d2f7824ULL, 0x000fe200078e00ffULL, 0xfffffff831047812ULL, 0x000fe200078ee21cULL,
0x000000011d037824ULL, 0x140fe200078e0200ULL, 0x0000000a001c7c11ULL, 0x040fe2000f8fe8ffULL,
0x000000081d1e7824ULL, 0x000fe200078e00ffULL, 0xfffffff82f0a7812ULL, 0x000fe200078ee20aULL,
0x00000001393c7824ULL, 0x140fe200078e0200ULL, 0x0000000c1c1c7c10ULL, 0x000fe2000ff3e0ffULL,
0x00000008392f7824ULL, 0x000fe200078e00ffULL, 0xfffffff81e417812ULL, 0x000fe200078ee203ULL,
0x000000013f037824ULL, 0x140fe200078e0200ULL, 0x0000000000317211ULL, 0x000fe200078fe8ffULL,
0x000000083f1e7824ULL, 0x000fe200078e00ffULL, 0xfffffff82f3c7812ULL, 0x000fe200078ee23cULL,
0x000000014d3d7824ULL, 0x000fe200078e0200ULL, 0x0000000731317812ULL, 0x000fe200078ec0ffULL,
0x000000084d2c7824ULL, 0x000fe200078e00ffULL, 0xfffffff81e037812ULL, 0x000fe200078ee203ULL,
0x0000000a1d2f7c36ULL, 0x000fe20008000000ULL, 0x0000001841417c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff1d7224ULL, 0x000fe200008e06ffULL, 0xfffffff82c3d7812ULL, 0x000fe200078ee23dULL,
0x0000000a1f1f7c36ULL, 0x000fe20008000000ULL, 0x0000001a1c2c7c11ULL, 0x040fe2000f8248ffULL,
0x0000000a2d1e7c36ULL, 0x000fe20008000000ULL, 0x0000000c2f2f7c10ULL, 0x000fe2000ff5e0ffULL,
0x0000000a333b7c36ULL, 0x000fe20008000000ULL, 0x0000001b1c2d7c11ULL, 0x000fe200088f4c1dULL,
0x0000000a39397c36ULL, 0x000fe20008000000ULL, 0x0000000c1f1f7c10ULL, 0x000fe2000ff7e0ffULL,
0x000000ffff387224ULL, 0x000fe200010e06ffULL, 0x0000000c1e1d7c10ULL, 0x000fe2000ff9e0ffULL,
0x0000000a3f337c36ULL, 0x000fe20008000000ULL, 0x0000001a1f1e7c11ULL, 0x000fe2000f8448ffULL,
0x000000ffff327224ULL, 0x000fe200018e06ffULL, 0x0000001a1d1c7c11ULL, 0x000fe2000f8648ffULL,
0x000000ffff307224ULL, 0x000fe200020e06ffULL, 0x0000001a2f2e7c11ULL, 0x000fe2000f8248ffULL,
0x0000000a4d4d7c36ULL, 0x000fe20008000000ULL, 0x0000001b1f1f7c11ULL, 0x000fe200090f4c32ULL,
0x00000010592c7825ULL, 0x000fe200078e002cULL, 0x0000001b1d1d7c11ULL, 0x000fc400098f4c30ULL,
0x0000000c3b3b7c10ULL, 0x000fe2000ff5e0ffULL, 0x00000010591e7825ULL, 0x000fe200078e001eULL,
0x0000000c39397c10ULL, 0x000fe4000ff7e0ffULL, 0x0000001b2f2f7c11ULL, 0x000fe200088f4c38ULL,
0x000000ffff4c7224ULL, 0x000fe200010e06ffULL, 0x0ffffff831307812ULL, 0x000fe200078ef800ULL,
0x000000ffff427224ULL, 0x000fe200018e06ffULL, 0x0000000c33337c10ULL, 0x000fe2000ff9e0ffULL,
0x00000010592e7825ULL, 0x000fe200078e002eULL, 0x0000000c4d317c10ULL, 0x000fc4000ff3e0ffULL,
0x0000001a3b3a7c11ULL, 0x000fe2000f8448ffULL, 0x000000ffff407224ULL, 0x000fe200020e06ffULL,
0x0000001a39387c11ULL, 0x000fe2000f8648ffULL, 0x000000ffff3e7224ULL, 0x000fe200008e06ffULL,
0x00000018303f7c11ULL, 0x000fe2000f8e20ffULL, 0x00000010591c7825ULL, 0x000fe200078e001cULL,
0x0000001a33327c11ULL, 0x000fe4000f8848ffULL, 0x0000001a31307c11ULL, 0x000fe2000f8248ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c3f7faeULL, 0x0003e2000b901c4eULL,
0x0000001b3b3b7c11ULL, 0x000fc400090f4c4cULL, 0x0000001b39397c11ULL, 0x000fe200098f4c42ULL,
0x000000002e417faeULL, 0x0005e2000b901c4eULL, 0x0000001b33337c11ULL, 0x000fe2000a0f4c40ULL,
0x00000010593a7825ULL, 0x000fe200078e003aULL, 0x0000001b31317c11ULL, 0x000fe400088f4c3eULL,
0x0000001843437c11ULL, 0x000fe2000f8e20ffULL, 0x0000001059387825ULL, 0x040fe200078e0038ULL,
0x000000183c4d7c11ULL, 0x000fe4000f8e20ffULL, 0x000000180a2d7c11ULL, 0x002fe2000f8e20ffULL,
0x0000001059327825ULL, 0x000fe200078e0032ULL, 0x00000018043f7c11ULL, 0x000fe2000f8e20ffULL,
0x000000001e437faeULL, 0x0005e2000b901c4eULL, 0x0000001803037c11ULL, 0x000fe2000f8e20ffULL,
0x0000001059307825ULL, 0x000fe200078e0030ULL, 0x000000183d3d7c11ULL, 0x000fe2000f8e20ffULL,
0x000000001c2d7faeULL, 0x0005e8000b901c4eULL, 0x000000003a3f7faeULL, 0x0005e8000b901c4eULL,
0x00000000384d7faeULL, 0x0005e8000b901c4eULL, 0x0000000032037faeULL, 0x0005e8000b901c4eULL,
0x00000000303d7faeULL, 0x0005e4000b901c4eULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000000000188947ULL, 0x000fea0003800000ULL,
0x00000002ff067819ULL, 0x000fe40000011600ULL, 0x00000005ff03723eULL, 0x006fc600000010ffULL,
0x0000000806047836ULL, 0x000fe20000000000ULL, 0x0000541003037816ULL, 0x000fca0000000003ULL,
0x00001f0603067589ULL, 0x0002a800000e0000ULL, 0x00001f0403077589ULL, 0x0002e400000e0000ULL,
0x013800004b1c783bULL, 0x0062a20000000200ULL, 0x0000000000108947ULL, 0x000fea0003800000ULL,
0x000000061c1c7232ULL, 0x084fe40000200000ULL, 0x000000061e1e7232ULL, 0x000fe40000200000ULL,
0x000000071d1d7232ULL, 0x088fe40000200000ULL, 0x000000071f1f7232ULL, 0x000fce0000200000ULL,
0x000000004a38783bULL, 0x000f280000004200ULL, 0x00000000493c783bULL, 0x000f680000004200ULL,
0x000000004830783bULL, 0x000f680000004200ULL, 0x000000000f2c783bULL, 0x000f620000004200ULL,
0x000000381c34723cULL, 0x014fec0000041834ULL, 0x0000003a1c14723cULL, 0x000fec0000041814ULL,
0x0000003c1c44723cULL, 0x022fec0000041844ULL, 0x0000003e1c18723cULL, 0x000fec0000041818ULL,
0x000000301c28723cULL, 0x008fec0000041828ULL, 0x000000321c24723cULL, 0x000fec0000041824ULL,
0x0000002c1c20723cULL, 0x000fec0000041820ULL, 0x0000002e1c10723cULL, 0x000fe20000041810ULL,
0x01380000081c783bULL, 0x0002a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000108947ULL, 0x000fde0003800000ULL, 0x000000061c1c7232ULL, 0x084fe40000200000ULL,
0x000000061e1e7232ULL, 0x000fe40000200000ULL, 0x000000071d1d7232ULL, 0x080fe40000200000ULL,
0x000000071f1f7232ULL, 0x000fce0000200000ULL, 0x000000000c30783bULL, 0x000ee20000004200ULL,
0x00000001ff037424ULL, 0x000fc600078e00ffULL, 0x000000000e2c783bULL, 0x000f280000004200ULL,
0x000000000d38783bULL, 0x000f680000004200ULL, 0x000000000b3c783bULL, 0x000f620000004200ULL,
0x01c6a003ffff79a7ULL, 0x0007e40008500004ULL, 0x000000301c34723cULL, 0x00cfec0000041834ULL,
0x0000002c1c44723cULL, 0x010fec0000041844ULL, 0x000000321c30723cULL, 0x000fec0000041814ULL,
0x0000002e1c2c723cULL, 0x000fec0000041818ULL, 0x000000381c28723cULL, 0x022fec0000041828ULL,
0x0000003a1c24723cULL, 0x000fec0000041824ULL, 0x0000003c1c20723cULL, 0x000fec0000041820ULL,
0x0000003e1c1c723cULL, 0x000fde0000041810ULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x0000000510057290ULL, 0x000fc8000fffe03fULL, 0x000000070500728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0xffffff5800a08947ULL, 0x000fea000383ffffULL,
0x00000000001479c3ULL, 0x000e640000002500ULL, 0x000000071400728cULL, 0x002fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000c40947ULL, 0x000fea0003800000ULL,
0x0180000002007836ULL, 0x000fca0000000000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x00000000000c0947ULL, 0x000fea0003800000ULL,
0x0000bf8000047802ULL, 0x000fce0000000f00ULL, 0x000000d0008c7944ULL, 0x000fea0003c00000ULL,
0x0000000000107947ULL, 0x000fea0003800000ULL, 0x0000000200037308ULL, 0x000e640000001000ULL,
0xbf80000003007423ULL, 0x002fc80000000002ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fce0000000003ULL, 0x0000000000047919ULL, 0x000f240000000000ULL,
0x00000002ff037819ULL, 0x010fe40000011604ULL, 0x0000000804057811ULL, 0x000fe200078ff0ffULL,
0x0000000000007948ULL, 0x00cfea0003800000ULL, 0x00001f0300037589ULL, 0x000ea800000e0000ULL,
0x00001f0500047589ULL, 0x000ee200000e0000ULL, 0x0000003403347220ULL, 0x044fe20000410000ULL,
0x0000003503357220ULL, 0x040fe20000410000ULL, 0x0000003003307220ULL, 0x040fe20000410000ULL,
0x0000003103317220ULL, 0x040fe20000410000ULL, 0x0000004403447220ULL, 0x040fe20000410000ULL,
0x0000004503457220ULL, 0x040fe20000410000ULL, 0x0000002c032c7220ULL, 0x040fe20000410000ULL,
0x0000002d032d7220ULL, 0x040fe20000410000ULL, 0x0000002803287220ULL, 0x040fe20000410000ULL,
0x0000002903297220ULL, 0x040fe20000410000ULL, 0x0000002403247220ULL, 0x040fe20000410000ULL,
0x0000002503257220ULL, 0x040fe20000410000ULL, 0x0000002003207220ULL, 0x040fe20000410000ULL,
0x0000002103217220ULL, 0x040fe20000410000ULL, 0x0000001c031c7220ULL, 0x040fe20000410000ULL,
0x0000001d031d7220ULL, 0x000fe20000410000ULL, 0x0000003604367220ULL, 0x048fe20000410000ULL,
0x0000003704377220ULL, 0x040fe20000410000ULL, 0x0000003204327220ULL, 0x040fe20000410000ULL,
0x0000003304337220ULL, 0x040fe20000410000ULL, 0x0000004604467220ULL, 0x040fe20000410000ULL,
0x0000004704477220ULL, 0x040fe20000410000ULL, 0x0000002e042e7220ULL, 0x040fe20000410000ULL,
0x0000002f042f7220ULL, 0x040fe20000410000ULL, 0x0000002a042a7220ULL, 0x040fe20000410000ULL,
0x0000002b042b7220ULL, 0x040fe20000410000ULL, 0x0000002604267220ULL, 0x040fe20000410000ULL,
0x0000002704277220ULL, 0x040fe20000410000ULL, 0x0000002204227220ULL, 0x040fe20000410000ULL,
0x0000002304237220ULL, 0x040fe20000410000ULL, 0x0000001e041e7220ULL, 0x040fe20000410000ULL,
0x0000001f041f7220ULL, 0x000fce0000410000ULL, 0x0000000000007919ULL, 0x000ea20000000000ULL,
0x0000000411067291ULL, 0x000fe2000f8e583fULL, 0x00000028290c723eULL, 0x000fe200000010ffULL,
0x000000011000788cULL, 0x000fe2000bf05270ULL, 0x00000020210e723eULL, 0x000fe200000010ffULL,
0x0001200006167890ULL, 0x000fe2000fffe03fULL, 0x0000001c1d0f723eULL, 0x000fe200000010ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000781cULL, 0x000fc40003f0f008ULL,
0x000000363710723eULL, 0x000fe400000010ffULL, 0x000000323311723eULL, 0x000fe400000010ffULL,
0x000000464712723eULL, 0x000fe400000010ffULL, 0x0000002e2f13723eULL, 0x000fe400000010ffULL,
0x0000002a2b14723eULL, 0x000fe400000010ffULL, 0x000000262715723eULL, 0x000fc400000010ffULL,
0x000000222316723eULL, 0x000fe400000010ffULL, 0x0000001e1f17723eULL, 0x000fe400000010ffULL,
0x00000003ff037819ULL, 0x004fe40000011600ULL, 0xfffffff8ff057812ULL, 0x000fe400078ee200ULL,
0x0000000303047812ULL, 0x000fc600078ec0ffULL, 0x0000000805077836ULL, 0x000fe40000000000ULL,
0x0000000805087824ULL, 0x040fe400078e00ffULL, 0x00000008050d7824ULL, 0x000fe400078e00ffULL,
0x0000000104057824ULL, 0x040fe400078e0205ULL, 0x0000000104067824ULL, 0x000fe400078e0207ULL,
0x0000000405047836ULL, 0x000fe20000000000ULL, 0xfffffff808087812ULL, 0x000fe200078ee205ULL,
0x00000008070b7824ULL, 0x000fc400078e00ffULL, 0x0000000807187824ULL, 0x000fe200078e00ffULL,
0xfffffff80d0a7812ULL, 0x000fe200078ee204ULL, 0x0000000c05077836ULL, 0x000fe20000000000ULL,
0xfffffff80b0b7812ULL, 0x000fe400078ee206ULL, 0x000000343504723eULL, 0x000fe400000010ffULL,
0xfffffff818187812ULL, 0x000fe400078ee207ULL, 0x000000303105723eULL, 0x000fe400000010ffULL,
0x000000444506723eULL, 0x000fc400000010ffULL, 0x0000002c2d07723eULL, 0x000fe400000010ffULL,
0x0000001608087c11ULL, 0x000fe4000f8e20ffULL, 0x00000024250d723eULL, 0x000fe400000010ffULL,
0x000000160a0a7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000408007844ULL, 0x0005e20000000200ULL,
0x000000160b0b7c11ULL, 0x000fe4000f8e20ffULL, 0x0000001618187c11ULL, 0x000fe2000f8e20ffULL,
0x0000000c0a007844ULL, 0x0005e80000000200ULL, 0x000000100b007844ULL, 0x0005e80000000200ULL,
0x0000001418007844ULL, 0x0005e20000000200ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000002400bc8947ULL, 0x000fea0003800000ULL, 0x00000000000979c3ULL, 0x000fe20000002700ULL,
0x0000920000047ab9ULL, 0x000fe20000000800ULL, 0x0000840000077ab9ULL, 0x000fe20000000800ULL,
0x00000011ff007c0cULL, 0x000fe2000bf05270ULL, 0x00000004070472a4ULL, 0x000fe2000f8e023fULL,
0x0000000600087c11ULL, 0x004fe2000f8e20ffULL, 0x00009600000c7ab9ULL, 0x000fe40000000a00ULL,
0x00000000000579c3ULL, 0x000ea40000002600ULL, 0x00000007090972a4ULL, 0x004fc4000f8e0205ULL,
0x0000000f04077891ULL, 0x000fe4000f8e103fULL, 0x00000010091572a4ULL, 0x000fe4000f8e023fULL,
0xfffffff007077892ULL, 0x000fe4000f8ec03fULL, 0x00000010040472a4ULL, 0x000fe4000f8e023fULL,
0x0000000c07177290ULL, 0x000fe4000ff1e03fULL, 0x00000014150a7290ULL, 0x000fc4000fffe03fULL,
0x0000000704187291ULL, 0x000fe4000f8e383fULL, 0x0000000d3f197290ULL, 0x000fe200087fe43fULL,
0x0000000000480947ULL, 0x000ff60003800000ULL, 0x000000070a057899ULL, 0x000fe2000800063fULL,
0x0000001000047824ULL, 0x000fe200078e00ffULL, 0x000000193f087899ULL, 0x000fe2000801160aULL,
0x00000001ff057819ULL, 0x000fc60000011600ULL, 0x00000005ff077e24ULL, 0x000fe2000f8e00ffULL,
0x0000007004067812ULL, 0x000fe200078ec0ffULL, 0x0000000c05057290ULL, 0x000fe2000f91e018ULL,
0x0000000c05057812ULL, 0x000fe400078ec0ffULL, 0x0000001706047c10ULL, 0x000fe2000fa3e007ULL,
0x00000008ff077e24ULL, 0x000fe2000f8e00ffULL, 0x0000000d08087290ULL, 0x000fe200087e243fULL,
0x0000000505067c10ULL, 0x000fe4000fd9e006ULL, 0x0000000405047210ULL, 0x000fc40007f7e0ffULL,
0x00000019ff057c10ULL, 0x000fe40008fe4407ULL, 0x00000008ff077c10ULL, 0x000fc6000a7ea4ffULL,
0x000000ffff057224ULL, 0x000fca00018e0605ULL, 0x0000000904007986ULL, 0x0005e8000c10190eULL,
0x0000000206007986ULL, 0x0005e4000c10190eULL, 0x0000001804047291ULL, 0x000fe2000f8e383fULL,
0x01200000080c7984ULL, 0x000ee20000000c00ULL, 0x000000ff0000720cULL, 0x000fe20000705670ULL,
0x0000002000097836ULL, 0x004fe20000000000ULL, 0x0000007f04047890ULL, 0x000fe2000fffe03fULL,
0x0122000008107984ULL, 0x000ea20000000c00ULL, 0x000002e000007945ULL, 0x000fe40003800000ULL,
0xffffff8004087892ULL, 0x000fc8000f8ec03fULL, 0x0000000c08047290ULL, 0x000fc8000ff1e03fULL,
0x0000000d3f057290ULL, 0x000fe400087fe43fULL, 0x000000040a047291ULL, 0x000fc8000f80603fULL,
0x000000050a057291ULL, 0x000fc800080f643fULL, 0x00000400110478a5ULL, 0x000fcc000f8e0004ULL,
0x00000004ff067e24ULL, 0x000fe4000f8e00ffULL, 0x00000005ff077e24ULL, 0x000fe4000f8e00ffULL,
0x0000001000047825ULL, 0x000fc800078e0006ULL, 0x0000001009067825ULL, 0x000fe200078e0006ULL,
0x0000000c04007986ULL, 0x0087e8000c101d0eULL, 0x0000001006007986ULL, 0x0047e2000c101d0eULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000007c0947ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000000075abULL, 0x000fec0000000000ULL,
0x00000000ff00798fULL, 0x000fe20002000000ULL, 0x0000960000047ab9ULL, 0x000fe20000000a00ULL,
0xffffffff100a7890ULL, 0x000fe4000fffe03fULL, 0x00000004090478a5ULL, 0x000fc8000f8e0004ULL,
0x0000000aff077e24ULL, 0x008fe4000f8e00ffULL, 0x00000004ff047e24ULL, 0x000fe4000f8e00ffULL,
0x00000005ff057e24ULL, 0x000fca000f8e00ffULL, 0x00000007040479a8ULL, 0x00052200099ee1ceULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000000075abULL, 0x000fec0000000000ULL,
0x00000000ff00798fULL, 0x000fe20002000000ULL, 0x00000000000579c3ULL, 0x000ee20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x0000000a04007c0cULL, 0x010fc8000bf05270ULL,
0x00000001ff027807ULL, 0x002fe20000000000ULL, 0x0000065405047896ULL, 0x008fd20008000004ULL,
0x00000002ff007988ULL, 0x0003e60008000004ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000479c3ULL, 0x000f220000008800ULL, 0x0000040000097882ULL, 0x000fce0000000000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000065404097896ULL, 0x010fd20008000009ULL,
0x00000009ff027984ULL, 0x002e640008000000ULL, 0x000000ff0200720cULL, 0x002fda0003f05270ULL,
0x00000020003c8947ULL, 0x000fea0003800000ULL, 0x00000011ff007c0cULL, 0x000fda000bf05270ULL,
0x0000000800f00947ULL, 0x000fea0003800000ULL, 0x00000010ff007c0cULL, 0x000fda000bf05270ULL,
0x0000000000848947ULL, 0x000fea0003800000ULL, 0x0000001000027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fe20000011600ULL, 0x0000001715047291ULL, 0x000fc6000f80383fULL,
0x0000007002027812ULL, 0x000fe200078ec0ffULL, 0x0000001915057291ULL, 0x000fe200080f3c3fULL,
0x0000000c03037812ULL, 0x000fc800078ec0ffULL, 0x0000000403027c10ULL, 0x000fc8000f91e002ULL,
0x00000005ff037c10ULL, 0x000fca00087e24ffULL, 0x0000000e02067981ULL, 0x008328000c1e1900ULL,
0x0000800e02077981ULL, 0x004322000c1e1900ULL, 0x000000021000788cULL, 0x000fcc000bf05270ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000508947ULL, 0x002fea0003800000ULL,
0x0001000e02097981ULL, 0x000322000c1e1900ULL, 0x000000041000788cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000408947ULL, 0x002fea0003800000ULL,
0x0001800e020b7981ULL, 0x000322000c1e1900ULL, 0x000000041000788cULL, 0x000fcc000bf05270ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000308947ULL, 0x002fea0003800000ULL,
0x0002000e020d7981ULL, 0x000322000c1e1900ULL, 0x000000061000788cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000208947ULL, 0x002fea0003800000ULL,
0x0002800e020f7981ULL, 0x000322000c1e1900ULL, 0x000000061000788cULL, 0x000fcc000bf05270ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000108947ULL, 0x002fea0003800000ULL,
0x000000081000788cULL, 0x000fe2000bf06070ULL, 0x0003000e02117981ULL, 0x00032a000c1e1900ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0003800e02130981ULL, 0x000324000c1e1900ULL,
0x0000000710047890ULL, 0x000fc8000fffe03fULL, 0x000000033f0a7899ULL, 0x000fcc0008011604ULL,
0x0000000aff007c0cULL, 0x000fda000bf05270ULL, 0x0000000800388947ULL, 0x000fea0003800000ULL,
0x00000007150b7291ULL, 0x000fe2000f80383fULL, 0x000000ffff057224ULL, 0x01cfe200078e0006ULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x0000003f00057c82ULL, 0x000fe20008000000ULL,
0x0000000c0b0b7290ULL, 0x000fe4000ff3e03fULL, 0x0000003f15127291ULL, 0x000fe400080f3c3fULL,
0x000007800b0b7890ULL, 0x000fc8000ff1e03fULL, 0x000000123f127290ULL, 0x000fd800087e240dULL,
0x000000100400728cULL, 0x000fe4000bf06070ULL, 0x0000000105057890ULL, 0x000fc8000fffe03fULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x0000000a0500728cULL, 0x000fd8000bf06070ULL,
0x0000000400f00947ULL, 0x012fea0003800000ULL, 0x00000008041a7890ULL, 0x000fe2000fffe03fULL,
0x0000000506067209ULL, 0x000fc60007810000ULL, 0x000000101a00728cULL, 0x000fcc000bf26070ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x00000000001c0947ULL, 0x000fea0003800000ULL,
0x0000001000027824ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011600ULL,
0x0000007002027812ULL, 0x000fc800078ec0ffULL, 0x0000000c02027812ULL, 0x000fc800078ef803ULL,
0x0000000b02027c10ULL, 0x000fca000ff1e0ffULL, 0x00000012ff037e24ULL, 0x000fca00080e06ffULL,
0xfffc800e02057981ULL, 0x000326000c1e1900ULL, 0x00000001041a7890ULL, 0x000fc8000fffe03fULL,
0x000000101a00728cULL, 0x000fcc000bf26070ULL, 0x000000000000781cULL, 0x000fda0003f0f018ULL,
0x0000000400b00947ULL, 0x000fea0003800000ULL, 0x00000009041a7890ULL, 0x000fe2000fffe03fULL,
0x0000000706067209ULL, 0x000fc60007810000ULL, 0x000000101a00728cULL, 0x000fcc000bf26070ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x00000000001c0947ULL, 0x000fea0003800000ULL,
0x0000001000027824ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011600ULL,
0x0000007002027812ULL, 0x000fc800078ec0ffULL, 0x0000000c02027812ULL, 0x000fc800078ef803ULL,
0x0000000b02027c10ULL, 0x000fca000ff1e0ffULL, 0x00000012ff037e24ULL, 0x000fca00080e06ffULL,
0xfffd000e02077981ULL, 0x000326000c1e1900ULL, 0x00000002041a7890ULL, 0x000fc8000fffe03fULL,
0x000000101a00728cULL, 0x000fcc000bf26070ULL, 0x000000000000781cULL, 0x000fda0003f0f018ULL,
0x0000000400700947ULL, 0x000fea0003800000ULL, 0x0000000a041a7890ULL, 0x000fe2000fffe03fULL,
0x0000000906067209ULL, 0x000fc60007810000ULL, 0x000000101a00728cULL, 0x000fcc000bf26070ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x00000000001c0947ULL, 0x000fea0003800000ULL,
0x0000001000027824ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011600ULL,
0x0000007002027812ULL, 0x000fc800078ec0ffULL, 0x0000000c02027812ULL, 0x000fc800078ef803ULL,
0x0000000b02027c10ULL, 0x000fca000ff1e0ffULL, 0x00000012ff037e24ULL, 0x000fca00080e06ffULL,
0xfffd800e02097981ULL, 0x000326000c1e1900ULL, 0x00000003041a7890ULL, 0x000fc8000fffe03fULL,
0x000000101a00728cULL, 0x000fcc000bf26070ULL, 0x000000000000781cULL, 0x000fda0003f0f018ULL,
0x0000000400300947ULL, 0x000fea0003800000ULL, 0x0000000b041a7890ULL, 0x000fe2000fffe03fULL,
0x0000000b06067209ULL, 0x000fc60007810000ULL, 0x000000101a00728cULL, 0x000fcc000bf26070ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x00000000001c0947ULL, 0x000fea0003800000ULL,
0x0000001000027824ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011600ULL,
0x0000007002027812ULL, 0x000fc800078ec0ffULL, 0x0000000c02027812ULL, 0x000fc800078ef803ULL,
0x0000000b02027c10ULL, 0x000fca000ff1e0ffULL, 0x00000012ff037e24ULL, 0x000fca00080e06ffULL,
0xfffe000e020b7981ULL, 0x000326000c1e1900ULL, 0x00000004041a7890ULL, 0x000fc8000fffe03fULL,
0x000000101a00728cULL, 0x000fcc000bf26070ULL, 0x000000000000781cULL, 0x000fda0003f0f018ULL,
0x0000000000f00947ULL, 0x000fea0003800000ULL, 0x0000000c041a7890ULL, 0x000fe2000fffe03fULL,
0x0000000d06067209ULL, 0x000fc60007810000ULL, 0x000000101a00728cULL, 0x000fcc000bf26070ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x00000000001c0947ULL, 0x000fea0003800000ULL,
0x0000001000027824ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011600ULL,
0x0000007002027812ULL, 0x000fc800078ec0ffULL, 0x0000000c02027812ULL, 0x000fc800078ef803ULL,
0x0000000b02027c10ULL, 0x000fca000ff1e0ffULL, 0x00000012ff037e24ULL, 0x000fca00080e06ffULL,
0xfffe800e020d7981ULL, 0x000326000c1e1900ULL, 0x00000005041a7890ULL, 0x000fc8000fffe03fULL,
0x000000101a00728cULL, 0x000fcc000bf26070ULL, 0x000000000000781cULL, 0x000fda0003f0f018ULL,
0x0000000000b00947ULL, 0x000fea0003800000ULL, 0x0000000d041a7890ULL, 0x000fe2000fffe03fULL,
0x0000000f06067209ULL, 0x000fc60007810000ULL, 0x000000101a00728cULL, 0x000fcc000bf26070ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x00000000001c0947ULL, 0x000fea0003800000ULL,
0x0000001000027824ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011600ULL,
0x0000007002027812ULL, 0x000fc800078ec0ffULL, 0x0000000c02027812ULL, 0x000fc800078ef803ULL,
0x0000000b02027c10ULL, 0x000fca000ff1e0ffULL, 0x00000012ff037e24ULL, 0x000fca00080e06ffULL,
0xffff000e020f7981ULL, 0x000326000c1e1900ULL, 0x00000006041a7890ULL, 0x000fc8000fffe03fULL,
0x000000101a00728cULL, 0x000fcc000bf26070ULL, 0x000000000000781cULL, 0x000fda0003f0f018ULL,
0x0000000000700947ULL, 0x000fea0003800000ULL, 0x0000000e041a7890ULL, 0x000fe2000fffe03fULL,
0x0000001106067209ULL, 0x000fc60007810000ULL, 0x000000101a00728cULL, 0x000fcc000bf26070ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x00000000001c0947ULL, 0x000fea0003800000ULL,
0x0000001000027824ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011600ULL,
0x0000007002027812ULL, 0x000fc800078ec0ffULL, 0x0000000c02027812ULL, 0x000fc800078ef803ULL,
0x0000000b02027c10ULL, 0x000fca000ff1e0ffULL, 0x00000012ff037e24ULL, 0x000fca00080e06ffULL,
0xffff800e02117981ULL, 0x000326000c1e1900ULL, 0x00000007041a7890ULL, 0x000fc8000fffe03fULL,
0x000000101a00728cULL, 0x000fcc000bf26070ULL, 0x000000000000781cULL, 0x000fda0003f0f018ULL,
0x0000000000300947ULL, 0x000fea0003800000ULL, 0x0000000f041a7890ULL, 0x000fe2000fffe03fULL,
0x0000001306067209ULL, 0x000fc60007810000ULL, 0x000000101a00728cULL, 0x000fcc000bf26070ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x00000000001c0947ULL, 0x000fea0003800000ULL,
0x0000001000027824ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011600ULL,
0x0000007002027812ULL, 0x000fc800078ec0ffULL, 0x0000000c02027812ULL, 0x000fc800078ef803ULL,
0x0000000b02027c10ULL, 0x000fca000ff1e0ffULL, 0x00000012ff037e24ULL, 0x000fca00080e06ffULL,
0x0000000e02137981ULL, 0x000326000c1e1900ULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x000004000b0b7890ULL, 0x000fe4000ff3e03fULL, 0x0000000804047890ULL, 0x000fe4000fffe03fULL,
0x000000123f127290ULL, 0x000fd00008ffe43fULL, 0xfffffff400e88947ULL, 0x000fea000383ffffULL,
0x0000000000007919ULL, 0x000f640000000000ULL, 0x0000001000027824ULL, 0x022fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011600ULL, 0x0000007002027812ULL, 0x000fe400078ec0ffULL,
0x0000000c03037812ULL, 0x000fc800078ec0ffULL, 0x0000000903037c10ULL, 0x000fca000fffe002ULL,
0x0000000603007388ULL, 0x0103e40000000800ULL, 0x0000960000047ab9ULL, 0x000fe20000000a00ULL,
0x000000070000780cULL, 0x040fe20003f04070ULL, 0x00000004081a7290ULL, 0x000fe2000ff3e03fULL,
0x00000015ff0b7e24ULL, 0x000fe2000f8e00ffULL, 0x0000000418217290ULL, 0x000fe2000ff1e03fULL,
0x0000001000027824ULL, 0x000fe200078e00ffULL, 0x00000004070b7290ULL, 0x000fe2000ff5e03fULL,
0x00000001ff037819ULL, 0x002fe20000011600ULL, 0x000000053f1b7290ULL, 0x000fe20008ffe43fULL,
0x0000002000077836ULL, 0x00cfe20000000000ULL, 0x000000053f227290ULL, 0x000fe200087fe43fULL,
0x0000007002027812ULL, 0x000fe200078ec0ffULL, 0x000000053f127290ULL, 0x000fe200097fe43fULL,
0x0000000c03037812ULL, 0x000fe200078ec0ffULL, 0x0000000a111f7899ULL, 0x000fe2000800063fULL,
0x000000210b088c11ULL, 0x040fe2000f8238ffULL, 0x00001000150478a5ULL, 0x000fe2000f8e001aULL,
0x0000000b0b0a8c11ULL, 0x040fe2000f8438ffULL, 0x000000163f207899ULL, 0x000fe20008011611ULL,
0x000000220b098c11ULL, 0x000fe200088f3cffULL, 0x0000001f040a7290ULL, 0x000fe2000ff1e03fULL,
0x00000010ff007c0cULL, 0x000fe2000bf25270ULL, 0x00000009111c7291ULL, 0x000fc4000f8e603fULL,
0x0000000903147c10ULL, 0x000fe2000fffe002ULL, 0x0000002005047290ULL, 0x000fe200087fe43fULL,
0x000000120b0b8c11ULL, 0x000fe200090f3cffULL, 0x0000000aff047e24ULL, 0x000fe2000f8e00ffULL,
0x00000000003f7886ULL, 0x000fe20000000000ULL, 0x0000001c000d7c11ULL, 0x040fe2000f8e20ffULL,
0x0000001000088825ULL, 0x040fe200078e0008ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000004ff057e24ULL, 0x000fe2000f8e00ffULL, 0x0000000911048291ULL, 0x000fe2000f8e403fULL,
0x00000010000a8825ULL, 0x040fe200078e000aULL, 0x0000000911058291ULL, 0x000fe2000f8e403fULL,
0x0000000014147984ULL, 0x000e620000000800ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000001007067825ULL, 0x000fe200078e0004ULL, 0x00000004000f8c11ULL, 0x000fc4000f8e20ffULL,
0x0000000000247805ULL, 0x000fe4000001ff00ULL, 0x0000000500118c11ULL, 0x040fe2000f8e20ffULL,
0x0000001000047825ULL, 0x000fe200078e0004ULL, 0x0000000000267805ULL, 0x000fe4000001ff00ULL,
0x0000000000187805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x000000ffff157224ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00180000040d7faeULL, 0x0005e2000b901c4eULL, 0x00000000002a7805ULL, 0x000fc4000001ff00ULL,
0x00000000001a7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00380000060d7faeULL, 0x0005e2000b901c4eULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x04580000080f8faeULL, 0x0005e2000b901c4eULL, 0x0000000000307805ULL, 0x000fc4000001ff00ULL,
0x0000000000207805ULL, 0x000fe4000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x041800000a118faeULL, 0x0005e2000b901c4eULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x000000ffff347224ULL, 0x000fe400078e00ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000ffff367224ULL, 0x000fe200078e00ffULL, 0x0000000800c09947ULL, 0x000fec0003800000ULL,
0x00000003ff047819ULL, 0x104fe20000011600ULL, 0x0000000911047291ULL, 0x000fe2000f8e403fULL,
0xfffffff8ff057812ULL, 0x000fe200078ee200ULL, 0x000000ffff157224ULL, 0x000fe200078e00ffULL,
0x0000000304047812ULL, 0x000fe200078ec0ffULL, 0x00000001151d7890ULL, 0x000fe2000fffe03fULL,
0x00000002ff3a7819ULL, 0x000fe20000011600ULL, 0x0000000805077836ULL, 0x000fe20000000000ULL,
0x00000001001e7882ULL, 0x000fe20000000000ULL, 0x0000000805097824ULL, 0x000fe400078e00ffULL,
0x0000000104377824ULL, 0x000fc400078e0207ULL, 0x0000000807067824ULL, 0x040fe400078e00ffULL,
0x0000000104047824ULL, 0x000fe400078e0205ULL, 0x0000000807087824ULL, 0x000fe200078e00ffULL,
0xfffffff806377812ULL, 0x000fe200078ee237ULL, 0x0000000805067824ULL, 0x000fe200078e00ffULL,
0xfffffff809387812ULL, 0x000fe200078ee204ULL, 0x0000000404397836ULL, 0x000fe40000000000ULL,
0x0000000c043b7836ULL, 0x000fc40000000000ULL, 0x00000004ff3d7e24ULL, 0x000fe2000f8e00ffULL,
0xfffffff806397812ULL, 0x000fe200078ee239ULL, 0x000000083a357836ULL, 0x000fe20000000000ULL,
0xfffffff8083b7812ULL, 0x000fce00078ee23bULL, 0x000000101e00728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000980947ULL, 0x000fea0003800000ULL,
0x000000070000780cULL, 0x000fe20003f44070ULL, 0x000010001d0478a5ULL, 0x000fe4000f8e001aULL,
0x0000001dff047e24ULL, 0x000fe2000f8e00ffULL, 0x000000011e247892ULL, 0x000fe2000f8ec03fULL,
0x0000002000077836ULL, 0x000fe20000000000ULL, 0x0000001f04237290ULL, 0x000fe4000ff1e03fULL,
0x0000000b1e0a7899ULL, 0x000fe4000800063fULL, 0x0000002005047290ULL, 0x000fe200087fe43fULL,
0x00000024ff0c7e24ULL, 0x000fe2000f8e00ffULL, 0x000008000a0a7892ULL, 0x000fe2000f8ec03fULL,
0x00000000003f7886ULL, 0x000fe20001020000ULL, 0x000000210408ac11ULL, 0x000fc4000f8038ffULL,
0x0000000a1c0a7290ULL, 0x000fe2000fffe03fULL, 0x0000000b040aac11ULL, 0x040fe2000f8238ffULL,
0x00000004ff057e24ULL, 0x000fe2000f8e00ffULL, 0x0000000911059291ULL, 0x000fe2000f8e403fULL,
0x000000220409ac11ULL, 0x040fe200080f3cffULL, 0x0000000911249291ULL, 0x000fe2000f8e403fULL,
0x00000012040bac11ULL, 0x000fe200088f3cffULL, 0x00000023ff047e24ULL, 0x000fe2000f8e00ffULL,
0x0000000a000d7c11ULL, 0x000fe2000f8e20ffULL, 0x00000005ff3dae24ULL, 0x000fe4000f8e00ffULL,
0x0000001007067825ULL, 0x000fc800078e0004ULL, 0x000000800c0fa824ULL, 0x000fe400078e023dULL,
0x00000024ff3dae24ULL, 0x000fe4000f8e00ffULL, 0x0000001000047825ULL, 0x000fc800078e0004ULL,
0x000000800c11a824ULL, 0x000fe200078e023dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00180000040d7faeULL, 0x0005e2000b901c4eULL, 0x000000100008a825ULL, 0x000fc600078e0008ULL,
0x00380000060d7faeULL, 0x0005e2000b901c4eULL, 0x00000010000fa824ULL, 0x040fe400078e020fULL,
0x00000010000aa825ULL, 0x000fc600078e000aULL, 0x04580000080fafaeULL, 0x0005e2000b901c4eULL,
0x000000100011a824ULL, 0x000fca00078e0211ULL, 0x041800000a11afaeULL, 0x0005e4000b901c4eULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffff1e047890ULL, 0x000fe4000fffe03fULL,
0x000000101e00728cULL, 0x000fe4000bf06070ULL, 0x0000000704057899ULL, 0x000fe4000800063fULL,
0x0000000b04047899ULL, 0x000fe4000800063fULL, 0x0000008005057892ULL, 0x000fe2000f8ec03fULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x0000080004047892ULL, 0x000fc4000f8ec03fULL,
0x000000011d1d7890ULL, 0x000fe4000fffe03fULL, 0x0000000502047c10ULL, 0x004fe2000fffe03dULL,
0x000001801c047890ULL, 0x000fe4000fffe004ULL, 0x000000011e1e7890ULL, 0x000fe4000fffe03fULL,
0x00000001033c7824ULL, 0x000fe400078e0204ULL, 0x0000000438047c11ULL, 0x000fe2000f8e20ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x004180003c0d7984ULL, 0x000ea20000000800ULL,
0x000000043b107c11ULL, 0x000fe4000f8e20ffULL, 0x0000000439087c11ULL, 0x000fe2000f8e20ffULL,
0x004580003c3f7984ULL, 0x000fe20000000800ULL, 0x00000004370c7c11ULL, 0x000fc6000f8e20ffULL,
0x000000000404783bULL, 0x000ee80000000200ULL, 0x000000000808783bULL, 0x000f220000000200ULL,
0x0000000d14117221ULL, 0x006fc60000010100ULL, 0x000000000c0c783bULL, 0x000e620000000200ULL,
0x3fb8aa3b11407820ULL, 0x000fc60000410000ULL, 0x000000001010783bULL, 0x000ea20000000200ULL,
0x00007632063e7816ULL, 0x048fe2000000003eULL, 0x0001000006417824ULL, 0x000fe200078e00ffULL,
0x0000004000407308ULL, 0x000ee20000000800ULL, 0x00007632053c7816ULL, 0x000fe2000000003cULL,
0x0001000008437824ULL, 0x010fe200078e00ffULL, 0x0000763207067816ULL, 0x000fe20000000006ULL,
0x000100000a457824ULL, 0x040fe200078e00ffULL, 0x000076320a427816ULL, 0x000fe20000000042ULL,
0x0001000005057824ULL, 0x000fe200078e00ffULL, 0x000076320b0a7816ULL, 0x000fe2000000000aULL,
0x0001000007077824ULL, 0x000fc400078e00ffULL, 0x000100000b0b7824ULL, 0x000fe400078e00ffULL,
0x000100003c3c7824ULL, 0x000fe400078e00ffULL, 0x000100003e3e7824ULL, 0x000fe400078e00ffULL,
0x0000003f404d7220ULL, 0x008fe20000410000ULL, 0x00010000043f7824ULL, 0x040fe200078e00ffULL,
0x0000763204047816ULL, 0x000fe20000000004ULL, 0x0001000006067824ULL, 0x000fe400078e00ffULL,
0x000000364d367221ULL, 0x000fe20000010000ULL, 0x00001f3a4d4e7589ULL, 0x000ee200000e0000ULL,
0x0000763208407816ULL, 0x000fe20000000040ULL, 0x0001000004047824ULL, 0x000fe200078e00ffULL,
0x0000763209087816ULL, 0x040fe20000000008ULL, 0x00001f354d4d7589ULL, 0x000f2200000e0000ULL,
0x0001000009097824ULL, 0x000fc400078e00ffULL, 0x0001000040407824ULL, 0x000fe400078e00ffULL,
0x0001000008087824ULL, 0x000fe400078e00ffULL, 0x0001000042427824ULL, 0x000fe200078e00ffULL,
0x000076320d467816ULL, 0x042fe20000000046ULL, 0x000100000d487824ULL, 0x000fe200078e00ffULL,
0x000076320f477816ULL, 0x040fe20000000047ULL, 0x000100000f4a7824ULL, 0x000fe200078e00ffULL,
0x0000763211497816ULL, 0x044fe20000000049ULL, 0x00010000114c7824ULL, 0x000fe200078e00ffULL,
0x0000763212117816ULL, 0x040fe20000000011ULL, 0x00010000124b7824ULL, 0x000fe200078e00ffULL,
0x000076320c447816ULL, 0x040fe20000000044ULL, 0x000100000c0c7824ULL, 0x000fe200078e00ffULL,
0x000076320e0d7816ULL, 0x040fe2000000000dULL, 0x000100000e0e7824ULL, 0x000fe200078e00ffULL,
0x00007632100f7816ULL, 0x000fe2000000000fULL, 0x0000004e04337223ULL, 0x088fe20000010033ULL,
0x0000763213127816ULL, 0x000fe20000000012ULL, 0x0000004e05327223ULL, 0x080fe20000010032ULL,
0x0000004e072e7223ULL, 0x000fe2000001002eULL, 0x0001000010107824ULL, 0x000fc400078e00ffULL,
0x0000004e3f347223ULL, 0x080fe20000010034ULL, 0x0001000013137824ULL, 0x000fe400078e00ffULL,
0x0000004e3c317223ULL, 0x080fe20000010031ULL, 0x000100000a0a7824ULL, 0x000fe400078e00ffULL,
0x0000004e41307223ULL, 0x080fe20000010030ULL, 0x0001000044057824ULL, 0x000fe400078e00ffULL,
0x0000004e3e2f7223ULL, 0x000fe2000001002fULL, 0x0001000046077824ULL, 0x000fc400078e00ffULL,
0x0000004e062d7223ULL, 0x080fe2000001002dULL, 0x000100000d0d7824ULL, 0x000fe400078e00ffULL,
0x0000004e432c7223ULL, 0x080fe2000001002cULL, 0x0001000047477824ULL, 0x000fe400078e00ffULL,
0x0000004e402b7223ULL, 0x080fe2000001002bULL, 0x000100000f0f7824ULL, 0x000fe400078e00ffULL,
0x0000004e092a7223ULL, 0x000fe2000001002aULL, 0x0001000049497824ULL, 0x000fc400078e00ffULL,
0x0000004e08297223ULL, 0x080fe20000010029ULL, 0x0001000011047824ULL, 0x000fe400078e00ffULL,
0x0000004e45287223ULL, 0x080fe20000010028ULL, 0x0001000012127824ULL, 0x000fe400078e00ffULL,
0x0000004e42277223ULL, 0x080fe20000010027ULL, 0x0000004e0b267223ULL, 0x080fe20000010026ULL,
0x0000004e0a257223ULL, 0x000fe20000010025ULL, 0x0000004d0c237223ULL, 0x090fe20000010023ULL,
0x0000004d05227223ULL, 0x080fe20000010022ULL, 0x0000004d48217223ULL, 0x080fe20000010021ULL,
0x0000004d07207223ULL, 0x080fe20000010020ULL, 0x0000004d0e1f7223ULL, 0x080fe2000001001fULL,
0x0000004d0d1e7223ULL, 0x080fe2000001001eULL, 0x0000004d4a1d7223ULL, 0x080fe2000001001dULL,
0x0000004d471c7223ULL, 0x080fe2000001001cULL, 0x0000004d101b7223ULL, 0x080fe2000001001bULL,
0x0000004d0f1a7223ULL, 0x080fe2000001001aULL, 0x0000004d4c197223ULL, 0x080fe20000010019ULL,
0x0000004d49247223ULL, 0x080fe20000010024ULL, 0x0000004d4b187223ULL, 0x080fe20000010018ULL,
0x0000004d04177223ULL, 0x080fe20000010017ULL, 0x0000004d13167223ULL, 0x080fe20000010016ULL,
0x0000004d12157223ULL, 0x000fe20000010015ULL, 0xfffffff4009c8947ULL, 0x000fec000383ffffULL,
0x0180000036007836ULL, 0x000fe20000000000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000000000140947ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe200078e0036ULL,
0x0000e6c000047802ULL, 0x004fce0000000f00ULL, 0x000000a800bc7944ULL, 0x002fea0003c00000ULL,
0x000000ffff027224ULL, 0x00efe200078e0000ULL, 0x0000000000107947ULL, 0x000fec0003800000ULL,
0x0000003600037308ULL, 0x000ee40000001000ULL, 0xbf80000003007423ULL, 0x008fc80000000036ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003027223ULL, 0x000fce0000000003ULL,
0x0000000000007919ULL, 0x000ee40000000000ULL, 0x00000002ff037819ULL, 0x008fe40000011600ULL,
0x00000008000d7811ULL, 0x004fe400078ff0ffULL, 0xfffffff8ff0f7812ULL, 0x000fe200078ee200ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x00001f0302037589ULL, 0x000ea200000e0000ULL,
0x000000080f117836ULL, 0x000fc60000000000ULL, 0x00001f0d020d7589ULL, 0x00072200000e0000ULL,
0x000000080f127824ULL, 0x040fe400078e00ffULL, 0x000000080f137824ULL, 0x000fe200078e00ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000003403047220ULL, 0x044fe20000410000ULL,
0x0000003303337220ULL, 0x040fe20000410000ULL, 0x0000003203057220ULL, 0x040fe20000410000ULL,
0x0000003103067220ULL, 0x040fe20000410000ULL, 0x0000003003307220ULL, 0x040fe20000410000ULL,
0x0000002f032f7220ULL, 0x040fe20000410000ULL, 0x0000002e03077220ULL, 0x040fe20000410000ULL,
0x0000002d03087220ULL, 0x040fe20000410000ULL, 0x0000002c032c7220ULL, 0x040fe20000410000ULL,
0x0000002b032b7220ULL, 0x040fe20000410000ULL, 0x0000002a03097220ULL, 0x040fe20000410000ULL,
0x0000002903027220ULL, 0x048fe20000410000ULL, 0x00000028030a7220ULL, 0x040fe20000410000ULL,
0x0000002703277220ULL, 0x040fe20000410000ULL, 0x00000026030b7220ULL, 0x040fe20000410000ULL,
0x00000025030c7220ULL, 0x000fe20000410000ULL, 0x00000003ff037819ULL, 0x000fe20000011600ULL,
0x000000230d237220ULL, 0x050fe20000410000ULL, 0x000000220d227220ULL, 0x040fe20000410000ULL,
0x000000210d217220ULL, 0x000fe20000410000ULL, 0x00000003030e7812ULL, 0x000fe200078ec0ffULL,
0x000000200d207220ULL, 0x040fe20000410000ULL, 0x0000001f0d1f7220ULL, 0x040fe20000410000ULL,
0x0000001e0d1e7220ULL, 0x040fe20000410000ULL, 0x0000001d0d1d7220ULL, 0x000fe20000410000ULL,
0x000000010e0f7824ULL, 0x000fc400078e020fULL, 0x0000001c0d1c7220ULL, 0x040fe20000410000ULL,
0x0000001b0d1b7220ULL, 0x040fe20000410000ULL, 0x0000001a0d1a7220ULL, 0x040fe20000410000ULL,
0x000000190d197220ULL, 0x040fe20000410000ULL, 0x000000240d247220ULL, 0x040fe20000410000ULL,
0x000000180d187220ULL, 0x040fe20000410000ULL, 0x000000170d177220ULL, 0x040fe20000410000ULL,
0x000000160d167220ULL, 0x040fe20000410000ULL, 0x000000010e107824ULL, 0x000fe400078e0211ULL,
0x000000150d0d7220ULL, 0x000fe20000410000ULL, 0x000000040f0e7836ULL, 0x000fe20000000000ULL,
0x000000050605723eULL, 0x000fe200000010ffULL, 0x0000000811157824ULL, 0x000fe200078e00ffULL,
0x000000043304723eULL, 0x000fe200000010ffULL, 0x0000000811267824ULL, 0x000fe200078e00ffULL,
0xfffffff8130e7812ULL, 0x000fe200078ee20eULL, 0x0000000c0f117836ULL, 0x000fe20000000000ULL,
0xfffffff8120f7812ULL, 0x000fc400078ee20fULL, 0xfffffff815147812ULL, 0x002fe400078ee210ULL,
0xfffffff826157812ULL, 0x000fe400078ee211ULL, 0x000000302f06723eULL, 0x000fe400000010ffULL,
0x000000070807723eULL, 0x000fe400000010ffULL, 0x000000160f0f7c11ULL, 0x000fe4000f8e20ffULL,
0x0000002c2b08723eULL, 0x000fc400000010ffULL, 0x000000090209723eULL, 0x000fe200000010ffULL,
0x000000040f007844ULL, 0x0003e20000000200ULL, 0x0000000a270a723eULL, 0x000fe400000010ffULL,
0x0000000b0c0b723eULL, 0x000fe400000010ffULL, 0x000000160e0e7c11ULL, 0x000fe4000f8e20ffULL,
0x000000232210723eULL, 0x000fe400000010ffULL, 0x000000212011723eULL, 0x000fe200000010ffULL,
0x000000080e007844ULL, 0x0003e20000000200ULL, 0x0000001f1e12723eULL, 0x000fc400000010ffULL,
0x0000001d1c13723eULL, 0x000fe400000010ffULL, 0x0000001614147c11ULL, 0x000fe4000f8e20ffULL,
0x0000001b1a1c723eULL, 0x000fe400000010ffULL, 0x00000019241d723eULL, 0x000fe200000010ffULL,
0x0000001014007844ULL, 0x0003e20000000200ULL, 0x00000018171e723eULL, 0x000fe400000010ffULL,
0x000000160d1f723eULL, 0x000fc400000010ffULL, 0x0000001615157c11ULL, 0x000fca000f8e20ffULL,
0x0000001c15007844ULL, 0x0003e20000000200ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000002000117836ULL, 0x00efe20000000000ULL, 0x0000000000057919ULL, 0x000e620000002600ULL,
0x0000000103067824ULL, 0x000fe200078e0200ULL, 0x00000000000579c3ULL, 0x000ea20000002700ULL,
0x0000840000047ab9ULL, 0x000fe20000000800ULL, 0x00000003ff027819ULL, 0x000fe20000011611ULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x0000000706077812ULL, 0x000fe200078ec0ffULL,
0x00000013ff127e24ULL, 0x000fe4000f8e00ffULL, 0x0000000111047824ULL, 0x000fe200078e0202ULL,
0x0ffffff807077812ULL, 0x000fc800078ef800ULL, 0x0000000704047812ULL, 0x000fe400078ec0ffULL,
0x0000000607087c11ULL, 0x000fe4000f8e20ffULL, 0x0ffffff804047812ULL, 0x000fe400078ef811ULL,
0x0000000700077812ULL, 0x000fe400078ec0ffULL, 0x0000000604047c11ULL, 0x000fe2000f8e20ffULL,
0x0120000008087984ULL, 0x000ee20000000c00ULL, 0x0000000711007812ULL, 0x000fe200078ec0ffULL,
0x00000005040472a4ULL, 0x004fc4000f8e023fULL, 0x01200000040c7984ULL, 0x0005220000000c00ULL,
0x1ffffff807077812ULL, 0x000fe400078ef812ULL, 0x1ffffff800117812ULL, 0x000fe200078ef812ULL,
0x0000000805067824ULL, 0x042fe400078e00ffULL, 0x0000000805057824ULL, 0x000fc600078e00ffULL,
0xfffffff806037812ULL, 0x000fe400078ee203ULL, 0xfffffff805027812ULL, 0x000fe400078ee202ULL,
0x0000000403037c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000402057c10ULL, 0x000fe2000ff3e0ffULL,
0x0000860000047ab9ULL, 0x000fe40000000a00ULL, 0x000000ffff107224ULL, 0x000fe200000e06ffULL,
0x0000000403027c11ULL, 0x000fe2000f8048ffULL, 0x000000ffff067224ULL, 0x000fe200008e06ffULL,
0x0000000405047c11ULL, 0x004fc4000f8248ffULL, 0x0000000503037c11ULL, 0x000fe400080f4c10ULL,
0x0000000505057c11ULL, 0x000fe200088f4c06ULL, 0x0000001007027825ULL, 0x000fc800078e0002ULL,
0x0000001011047825ULL, 0x000fe200078e0004ULL, 0x0000000802007986ULL, 0x008fe8000c101d0eULL,
0x0000000c04007986ULL, 0x010fe2000c101d0eULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x000000013f097899ULL, 0x000fe20008011611ULL, 0x00000001ff027424ULL, 0x000fc600078e00ffULL,
0x0000000905097291ULL, 0x000fc6000f8e083fULL, 0x01c60002ff0279a7ULL, 0x000e620008500004ULL,
0x000000060900728cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fca0003f0f008ULL,
0x00000001080b8899ULL, 0x000fe2000800063fULL, 0x00009000000c8ab9ULL, 0x000fc60000000800ULL,
0x0000000c0b0b82a4ULL, 0x000fc6000f8e0209ULL, 0x00008c00000c8ab9ULL, 0x000fe40000000a00ULL,
0x000000040b0c88a5ULL, 0x000fcc000f8e000cULL, 0x0000000cff047e24ULL, 0x000fe4000f8e00ffULL,
0x0000000dff057e24ULL, 0x000fca000f8e00ffULL, 0x0000000e04048981ULL, 0x000ea2000c1e1900ULL,
0x00000001050b7890ULL, 0x000fe4000fffe03fULL, 0x0000000611187899ULL, 0x000fe4000800063fULL,
0x000000070b00728cULL, 0x000fe4000bf26070ULL, 0x000000070a0a7899ULL, 0x000fe4000800063fULL,
0x00000018050d7291ULL, 0x000fe4000f8e403fULL, 0x00000007120b7899ULL, 0x000fe2000800063fULL,
0xffffffff00197882ULL, 0x000fe20000000000ULL, 0x000000400a127892ULL, 0x000fe2000f8ef80dULL,
0x00000000040c82caULL, 0x004fc400000e0000ULL, 0x000000000000781cULL, 0x000fd60003f0f018ULL,
0x0000000c00198c82ULL, 0x000fe40008000000ULL, 0x0000000b191372a4ULL, 0x000fe2000f8e023fULL,
0x0000000c00ac8947ULL, 0x002ff60003800000ULL, 0x00000003ff057819ULL, 0x000fe20000011600ULL,
0x0000000d1400728cULL, 0x000fe2000bf01070ULL, 0x00008a0000167ab9ULL, 0x000fc60000000a00ULL,
0x0000000405097836ULL, 0x000fe20000000000ULL, 0x0000000d140c7287ULL, 0x000fe2000c000000ULL,
0x0000001205047c36ULL, 0x000fe40008000000ULL, 0x00000008050b7836ULL, 0x000fe20000000000ULL,
0x0000000c0d0c7290ULL, 0x000fe2000fffe13fULL, 0x0000000109067824ULL, 0x140fe200078e0200ULL,
0x00000013040e7c10ULL, 0x000fe2000ff1e0ffULL, 0x00000008090f7824ULL, 0x000fe200078e00ffULL,
0x00000004110d7291ULL, 0x000fe2000f8e703fULL, 0x000000010b077824ULL, 0x100fe200078e0200ULL,
0x0000000c09007c0cULL, 0x000fe2000bf46070ULL, 0x000000080b167824ULL, 0x040fe200078e00ffULL,
0xfffffff80f147812ULL, 0x000fe200078ee206ULL, 0x000000120b067c36ULL, 0x000fe20008000000ULL,
0x000000160e0f7c11ULL, 0x040fe2000f8248ffULL, 0x0000000c05117836ULL, 0x000fe20000000000ULL,
0xfffffff816167812ULL, 0x000fe200078ee207ULL, 0x0000001209047c36ULL, 0x000fe20008000000ULL,
0x0000001306127c10ULL, 0x000fe2000ff9e0ffULL, 0x000000ffff077224ULL, 0x000fe200000e06ffULL,
0x0000000c0b007c0cULL, 0x000fe2000bf06070ULL, 0x0000000111087824ULL, 0x140fe200078e0200ULL,
0x00000013040a7c10ULL, 0x000fe2000ff7e0ffULL, 0x0000000811137824ULL, 0x040fe200078e00ffULL,
0x000000170e0e7c11ULL, 0x000fe200088f4c07ULL, 0x0000001005157836ULL, 0x000fe20000000000ULL,
0x0000000c11007c0cULL, 0x000fe2000bf26070ULL, 0x000000ffff077224ULL, 0x000fe200020e06ffULL,
0xfffffff813187812ULL, 0x000fe200078ee208ULL, 0x0000001215067c36ULL, 0x000fe20008000000ULL,
0x0000001612137c11ULL, 0x000fe2000f8848ffULL, 0x000000ffff097224ULL, 0x000fe200018e06ffULL,
0x000000160a0b7c11ULL, 0x000fe2000f8648ffULL, 0x0000001211047c36ULL, 0x000fe20008000000ULL,
0x0000001712127c11ULL, 0x000fe2000a0f4c07ULL, 0x0000000115087824ULL, 0x140fe200078e0200ULL,
0x0000001306067c10ULL, 0x000fe2000ff9e0ffULL, 0x00000008151b7824ULL, 0x040fe200078e00ffULL,
0x000000170a0a7c11ULL, 0x000fe200098f4c09ULL, 0x000020000d0d7890ULL, 0x000fe2000fffe03fULL,
0x0000001304047c10ULL, 0x000fe2000ff7e0ffULL, 0x000000ffff077224ULL, 0x000fe200020e06ffULL,
0x0000001606197c11ULL, 0x000fe2000f8a48ffULL, 0x0000001c051d7836ULL, 0x000fe20000000000ULL,
0x0000000c15007c0cULL, 0x000fe2000bf86070ULL, 0x000000ffff097224ULL, 0x000fe200018e06ffULL,
0x0000001604117c11ULL, 0x000fe2000f8648ffULL, 0x0000001405157836ULL, 0x000fe20000000000ULL,
0x0000001706107c11ULL, 0x000fe2000a8f4c07ULL, 0x0000000105067824ULL, 0x000fe200078e0200ULL,
0x00000017040c7c11ULL, 0x000fe200098f4c09ULL, 0x00000008151c7824ULL, 0x000fe200078e00ffULL,
0x000000700d047812ULL, 0x000fe200078ec0ffULL, 0x000000081d217824ULL, 0x000fe200078e00ffULL,
0x0000000706097812ULL, 0x000fc400078ec0ffULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee208ULL,
0x0000001215087c36ULL, 0x000fe20008000000ULL, 0x0000000f04067210ULL, 0x000fe20007fbe0ffULL,
0x00000001150f7824ULL, 0x000fe200078e0200ULL, 0x0000000c05007c0cULL, 0x000fe4000bf66070ULL,
0x0ffffff8090d7812ULL, 0x000fe200078ef800ULL, 0x000000ffff077224ULL, 0x000fe200028e060eULL,
0x00000013080e7c10ULL, 0x000fe4000ffde0ffULL, 0x0000000b04087210ULL, 0x000fc40007fbe0ffULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee20fULL, 0x000000ffff0b7224ULL, 0x000fe200030e06ffULL,
0x000000160e177c11ULL, 0x040fe2000f8c48ffULL, 0x000000ffff097224ULL, 0x000fe200028e060aULL,
0x0000000d0d0d7c11ULL, 0x000fe4000f8e20ffULL, 0x000000170e0e7c11ULL, 0x000fe2000b0f4c0bULL,
0x00000018050b7836ULL, 0x000fe20000000000ULL, 0x0000000d140f7c11ULL, 0x000fe2000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060d7faeULL, 0x0003e2000d901c4eULL,
0x0000000c15007c0cULL, 0x000fe2000bfa6070ULL, 0x000000120b0a7c36ULL, 0x000fe20008000000ULL,
0x0000000c0b007c0cULL, 0x040fe2000bf66070ULL, 0x00000000080f7faeULL, 0x0005e2000d101c4eULL,
0x000000010b1a7824ULL, 0x000fc400078e0200ULL, 0x000000130a147c10ULL, 0x000fe2000ff5e0ffULL,
0x000000080b1f7824ULL, 0x000fc600078e00ffULL, 0x0000001614157c11ULL, 0x000fe2000f8c48ffULL,
0x000000ffff0b7224ULL, 0x000fe200010e06ffULL, 0x00000013040a7210ULL, 0x000fe20007f5e0ffULL,
0x000000121d067c36ULL, 0x002fe20008000000ULL, 0x0000000d160d7c11ULL, 0x000fe2000f8e20ffULL,
0x000000011d087824ULL, 0x044fe200078e0200ULL, 0x0000001714147c11ULL, 0x000fe2000b0f4c0bULL,
0x000000ffff0b7224ULL, 0x000fe200010e0612ULL, 0x0000001306127c10ULL, 0x000fe4000ffde0ffULL,
0x0000001104067210ULL, 0x000fe20007f5e0ffULL, 0x0000002405117836ULL, 0x000fe20000000000ULL,
0xfffffff821217812ULL, 0x000fe200078ee208ULL, 0x000000ffff097224ULL, 0x000fe200030e06ffULL,
0x0000001612137c11ULL, 0x000fe2000f8c48ffULL, 0x000000ffff077224ULL, 0x000fe200010e060cULL,
0x0000000d180f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000000a0d7faeULL, 0x0003e2000c101c4eULL,
0x0000001712127c11ULL, 0x000fe2000b0f4c09ULL, 0x0000002005097836ULL, 0x000fe20000000000ULL,
0xfffffff81f207812ULL, 0x000fe200078ee21aULL, 0x00000000060f7faeULL, 0x0005e2000c901c4eULL,
0x0000000c1d007c0cULL, 0x000fe2000bf46070ULL, 0x0000001209087c36ULL, 0x000fe20008000000ULL,
0x0000000c09007c0cULL, 0x040fe2000bf06070ULL, 0x00000001090c7824ULL, 0x000fc400078e0200ULL,
0x00000008091d7824ULL, 0x000fe200078e00ffULL, 0x00000013081a7c10ULL, 0x000fe2000ff3e0ffULL,
0x00000012110a7c36ULL, 0x002fe40008000000ULL, 0x00000008110d7824ULL, 0x040fe200078e00ffULL,
0x000000161a1f7c11ULL, 0x000fe2000f8c48ffULL, 0x000000ffff097224ULL, 0x000fe200008e06ffULL,
0x0000001904087210ULL, 0x000fe40007f3e0ffULL, 0x0000000d1c0f7c11ULL, 0x004fe4000f8e20ffULL,
0x000000171a1a7c11ULL, 0x000fe2000b0f4c09ULL, 0x000000ffff097224ULL, 0x000fe200008e0610ULL,
0x000000130a187c10ULL, 0x000fe2000ffde0ffULL, 0x00000001110a7824ULL, 0x000fe200078e0200ULL,
0x0000001704067210ULL, 0x000fc40007f3e0ffULL, 0xfffffff81d0c7812ULL, 0x000fe200078ee20cULL,
0x000000ffff0b7224ULL, 0x000fe200030e06ffULL, 0x0000001618197c11ULL, 0x040fe2000f8c48ffULL,
0x000000ffff077224ULL, 0x000fe200008e060eULL, 0xfffffff80d0e7812ULL, 0x000fe400078ee20aULL,
0x0000001718187c11ULL, 0x000fe2000b0f4c0bULL, 0x00000028050b7836ULL, 0x000fe20000000000ULL,
0x0000000d1b0d7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000c11007c0cULL, 0x000fe2000bf26070ULL,
0x000000120b0a7c36ULL, 0x000fc40008000000ULL, 0x00000000080d7faeULL, 0x0003e2000e101c4eULL,
0x0000002c05117836ULL, 0x000fe20000000000ULL, 0x0000000c0b007c0cULL, 0x040fe2000bf86070ULL,
0x000000010b107824ULL, 0x040fe200078e0200ULL, 0x00000000060f7faeULL, 0x0005e2000e901c4eULL,
0x000000130a1e7c10ULL, 0x000fe2000ffbe0ffULL, 0x000000080b1b7824ULL, 0x000fc600078e00ffULL,
0x000000161e177c11ULL, 0x040fe2000f8c48ffULL, 0x000000ffff0b7224ULL, 0x000fe200028e06ffULL,
0x00000015040a7210ULL, 0x000fe20007fbe0ffULL, 0x0000001211087c36ULL, 0x002fe20008000000ULL,
0xfffffff81b107812ULL, 0x000fe200078ee210ULL, 0x00000008110d7824ULL, 0x040fe200078e00ffULL,
0x000000171e1e7c11ULL, 0x000fe2000b0f4c0bULL, 0x000000ffff0b7224ULL, 0x000fe200028e0614ULL,
0x00000013081c7c10ULL, 0x000fe2000ffde0ffULL, 0x0000000111087824ULL, 0x000fe200078e0200ULL,
0x0000001304067210ULL, 0x004fe20007fbe0ffULL, 0x0000003405137836ULL, 0x000fe20000000000ULL,
0x0000000d210f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff097224ULL, 0x000fe200030e06ffULL,
0x000000161c1d7c11ULL, 0x000fe2000f8c48ffULL, 0x000000ffff077224ULL, 0x000fe200028e0612ULL,
0xfffffff80d127812ULL, 0x000fc400078ee208ULL, 0x000000171c1c7c11ULL, 0x000fe2000b0f4c09ULL,
0x0000003005097836ULL, 0x000fe20000000000ULL, 0x0000000d200d7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000c11007c0cULL, 0x000fe2000bfa6070ULL, 0x0000001209087c36ULL, 0x000fe40008000000ULL,
0x000000000a0d7faeULL, 0x0003e2000d901c4eULL, 0x0000000109117824ULL, 0x040fe200078e0200ULL,
0x0000000c09007c0cULL, 0x040fe2000bf66070ULL, 0x0000000809147824ULL, 0x000fe200078e00ffULL,
0x00000000060f7faeULL, 0x0005e2000d101c4eULL, 0x00000013081b7c10ULL, 0x000fc6000ff5e0ffULL,
0xfffffff814147812ULL, 0x000fe200078ee211ULL, 0x0000003c05117836ULL, 0x000fe20000000000ULL,
0x000000161b157c11ULL, 0x000fe2000f8c48ffULL, 0x000000ffff167224ULL, 0x000fe200010e06ffULL,
0x0000001f04087210ULL, 0x000fe20007f5e0ffULL, 0x00000012130a7c36ULL, 0x002fe40008000000ULL,
0x00000008130d7824ULL, 0x000fe200078e00ffULL, 0x000000171b1b7c11ULL, 0x000fe2000b0f4c16ULL,
0x000000ffff097224ULL, 0x000fe200010e061aULL, 0x000000130a1a7c10ULL, 0x000fe2000ffde0ffULL,
0x00000001130a7824ULL, 0x000fe200078e0200ULL, 0x0000001904067210ULL, 0x004fc40007f5e0ffULL,
0x0000000d0e0f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff0b7224ULL, 0x000fe200030e06ffULL,
0x000000161a197c11ULL, 0x040fe2000f8c48ffULL, 0x000000ffff077224ULL, 0x000fe200010e0618ULL,
0xfffffff80d167812ULL, 0x000fe400078ee20aULL, 0x000000171a1a7c11ULL, 0x000fe2000b0f4c0bULL,
0x00000038050b7836ULL, 0x000fe20000000000ULL, 0x0000000d0c0d7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000c13007c0cULL, 0x000fe2000bf46070ULL, 0x000000120b0a7c36ULL, 0x000fc40008000000ULL,
0x00000000080d7faeULL, 0x0003e2000c101c4eULL, 0x000000010b057824ULL, 0x140fe200078e0200ULL,
0x0000000c0b007c0cULL, 0x040fe2000bf06070ULL, 0x000000080b0c7824ULL, 0x000fe200078e00ffULL,
0x00000000060f7faeULL, 0x0005e2000c901c4eULL, 0x000000130a187c10ULL, 0x000fe2000ffde0ffULL,
0x0000000111007824ULL, 0x000fe200078e0200ULL, 0x00000017040a7210ULL, 0x000fe40007f3e0ffULL,
0xfffffff80c057812ULL, 0x000fe200078ee205ULL, 0x000000ffff137224ULL, 0x000fe200030e06ffULL,
0x0000001618177c11ULL, 0x000fe2000f8c48ffULL, 0x000000ffff0b7224ULL, 0x000fe200008e061eULL,
0x0000001d04087210ULL, 0x002fc40007f3e0ffULL, 0x0000001718187c11ULL, 0x000fe2000b0f4c13ULL,
0x0000001211067c36ULL, 0x004fe40008000000ULL, 0x000000ffff097224ULL, 0x000fe400008e061cULL,
0x0000000811137824ULL, 0x040fe200078e00ffULL, 0x00000013060c7c10ULL, 0x000fe4000ffde0ffULL,
0x0000001504067210ULL, 0x000fe40007f3e0ffULL, 0xfffffff813007812ULL, 0x000fe200078ee200ULL,
0x000000ffff0f7224ULL, 0x000fe200030e06ffULL, 0x0000000d12137c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff077224ULL, 0x000fe200008e061bULL, 0x0000000c11007c0cULL, 0x000fc4000bf26070ULL,
0x0000000d10117c11ULL, 0x000fe4000f8e20ffULL, 0x0000000d14157c11ULL, 0x000fe4000f8e20ffULL,
0x000000160c0d7c11ULL, 0x040fe2000f8c48ffULL, 0x000000000a117faeULL, 0x0003e2000e101c4eULL,
0x00000017040e7210ULL, 0x000fe40007f9e0ffULL, 0x000000170c107c11ULL, 0x000fe2000b0f4c0fULL,
0x0000000008137faeULL, 0x0003e2000e901c4eULL, 0x0000000d16177c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff0f7224ULL, 0x000fe200020e0618ULL, 0x0000000d001b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000006157faeULL, 0x0003e2000d901c4eULL, 0x00000019040c7210ULL, 0x000fc40007f7e0ffULL,
0x0000000d04047210ULL, 0x000fe40007fbe0ffULL, 0x0000000d05197c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff0d7224ULL, 0x000fe400018e061aULL, 0x000000ffff057224ULL, 0x000fc600028e0610ULL,
0x000000000c177faeULL, 0x0003e8000d101c4eULL, 0x000000000e197faeULL, 0x0003e8000c101c4eULL,
0x00000000041b7faeULL, 0x0003e2000c901c4eULL, 0x0000000c00587947ULL, 0x000fea0003800000ULL,
0x0000000c00297811ULL, 0x040fe200078fe8ffULL, 0x00008a0000167ab9ULL, 0x000fe20000000a00ULL,
0x0000000800277811ULL, 0x040fe200078fe8ffULL, 0x00000004110c7291ULL, 0x000fe2000f8e703fULL,
0x00000010002b7811ULL, 0x040fe200078fe8ffULL, 0x0000000129107824ULL, 0x140fe200078e0200ULL,
0x00000018002f7811ULL, 0x040fe200078fe8ffULL, 0x0000000829077824ULL, 0x000fe200078e00ffULL,
0x0000002000177811ULL, 0x040fe200078fe8ffULL, 0x0000000127117824ULL, 0x140fe200078e0200ULL,
0x0000001c00337811ULL, 0x040fe200078fe8ffULL, 0x0000000827047824ULL, 0x000fe200078e00ffULL,
0xfffffff807107812ULL, 0x000fe200078ee210ULL, 0x000000012b0f7824ULL, 0x140fe200078e0200ULL,
0x0000002400197811ULL, 0x040fe200078fe8ffULL, 0x000000082b067824ULL, 0x000fe200078e00ffULL,
0x00000028001b7811ULL, 0x040fe200078fe8ffULL, 0x000000012f0a7824ULL, 0x140fe200078e0200ULL,
0x0000000400157811ULL, 0x040fe200078fe8ffULL, 0x000000082f077824ULL, 0x000fe200078e00ffULL,
0xfffffff804117812ULL, 0x000fe200078ee211ULL, 0x0000000117087824ULL, 0x140fe200078e0200ULL,
0xfffffff8060f7812ULL, 0x000fe200078ee20fULL, 0x00000008170b7824ULL, 0x000fe200078e00ffULL,
0xfffffff8070a7812ULL, 0x000fe200078ee20aULL, 0x0000000133097824ULL, 0x140fe200078e0200ULL,
0x00000030001f7811ULL, 0x040fe200078fe8ffULL, 0x0000000833047824ULL, 0x000fe200078e00ffULL,
0xfffffff80b087812ULL, 0x000fe200078ee208ULL, 0x0000000119077824ULL, 0x140fe200078e0200ULL,
0x00000014002d7811ULL, 0x040fe200078fe8ffULL, 0x00000008190c7824ULL, 0x000fe200078e00ffULL,
0xfffffff804097812ULL, 0x000fe200078ee209ULL, 0x000000011b067824ULL, 0x140fe200078e0200ULL,
0x0000002c001d7811ULL, 0x040fe200078fe8ffULL, 0x000000081b0b7824ULL, 0x000fe200078e00ffULL,
0xfffffff80c077812ULL, 0x000fe200078ee207ULL, 0x0000000115127824ULL, 0x140fe200078e0200ULL,
0x00000000000c7211ULL, 0x040fe200078fe8ffULL, 0x0000000815057824ULL, 0x000fe200078e00ffULL,
0xfffffff80b067812ULL, 0x000fe200078ee206ULL, 0x000000011f047824ULL, 0x140fe200078e0200ULL,
0x00000012000b7c11ULL, 0x000fe2000f8fe8ffULL, 0x000000081f137824ULL, 0x000fe200078e00ffULL,
0xfffffff805127812ULL, 0x000fe200078ee212ULL, 0x000000012d0e7824ULL, 0x140fe200078e0200ULL,
0x000000130b3e7c10ULL, 0x000fe2000ff1e0ffULL, 0x000000082d057824ULL, 0x000fe200078e00ffULL,
0xfffffff813047812ULL, 0x000fe200078ee204ULL, 0x000000081d147824ULL, 0x040fe200078e00ffULL,
0x000000070c137812ULL, 0x000fe200078ec0ffULL, 0x000000122b167c36ULL, 0x000fe20008000000ULL,
0xfffffff8050e7812ULL, 0x000fe200078ee20eULL, 0x000000011d057824ULL, 0x100fe200078e0200ULL,
0x0ffffff813407812ULL, 0x000fe200078ef800ULL, 0x000000ffff137224ULL, 0x000fe200000e06ffULL,
0x0000003800237811ULL, 0x000fe200078fe8ffULL, 0x0000001217177c36ULL, 0x000fe20008000000ULL,
0x000000163e317c11ULL, 0x040fe2000f8048ffULL, 0x000000121d1d7c36ULL, 0x000fe20008000000ULL,
0xfffffff814057812ULL, 0x000fe200078ee205ULL, 0x00000001230b7824ULL, 0x140fe200078e0200ULL,
0x000000173e3e7c11ULL, 0x000fe200080f4c13ULL, 0x0000000823147824ULL, 0x000fe200078e00ffULL,
0x0000001316167c10ULL, 0x000fe2000ff7e0ffULL, 0x0000001215137c36ULL, 0x000fe20008000000ULL,
0x0000003400217811ULL, 0x000fe200078fe8ffULL, 0x0000001229157c36ULL, 0x000fe20008000000ULL,
0xfffffff8140b7812ULL, 0x000fe200078ee20bULL, 0x0000001227147c36ULL, 0x000fe20008000000ULL,
0x00000013133d7c10ULL, 0x000fe2000ff1e0ffULL, 0x000000ffff137224ULL, 0x000fe200018e06ffULL,
0x0000001315157c10ULL, 0x000fe2000ff5e0ffULL, 0x00000001210c7824ULL, 0x000fe200078e0200ULL,
0x00000013143b7c10ULL, 0x000fe2000ff3e0ffULL, 0x000000ffff1a7224ULL, 0x000fe200000e06ffULL,
0x00000016161e7c11ULL, 0x040fe2000f8648ffULL, 0x000000ffff147224ULL, 0x000fe200010e06ffULL,
0x00000016151c7c11ULL, 0x040fe2000f8448ffULL, 0x000000ffff187224ULL, 0x000fe200008e06ffULL,
0x0000001716387c11ULL, 0x000fe200098f4c13ULL, 0x000000122d137c36ULL, 0x000fe20008000000ULL,
0x0000001715397c11ULL, 0x000fe200090f4c14ULL, 0x0000001233157c36ULL, 0x000fe20008000000ULL,
0x000000163d3c7c11ULL, 0x000fe2000f8048ffULL, 0x000000122f147c36ULL, 0x000fe20008000000ULL,
0x000000163b3a7c11ULL, 0x000fe2000f8248ffULL, 0x0000001219197c36ULL, 0x000fe20008000000ULL,
0x0000001315157c10ULL, 0x000fe2000ff5e0ffULL, 0x000000121b1b7c36ULL, 0x000fe20008000000ULL,
0x0000003c00257811ULL, 0x000fe200078fe8ffULL, 0x0000000821357824ULL, 0x000fe200078e00ffULL,
0x000000173d3d7c11ULL, 0x000fe200080f4c1aULL, 0x000000ffff167224ULL, 0x000fe200010e06ffULL,
0x0000001313137c10ULL, 0x000fe2000ff1e0ffULL, 0x0000000125007824ULL, 0x000fe200078e0200ULL,
0x000000173b3b7c11ULL, 0x000fe200088f4c18ULL, 0x0000000825377824ULL, 0x000fe200078e00ffULL,
0x00000013142d7c10ULL, 0x000fe2000ff3e0ffULL, 0x000000ffff1a7224ULL, 0x000fe200000e06ffULL,
0x0000001317177c10ULL, 0x000fe2000ff7e0ffULL, 0x0000001225257c36ULL, 0x000fe20008000000ULL,
0x0000001615297c11ULL, 0x000fe2000f8448ffULL, 0x000000ffff187224ULL, 0x000fe200008e06ffULL,
0x0000001613207c11ULL, 0x000fe2000f8048ffULL, 0x000000ffff147224ULL, 0x000fe200018e06ffULL,
0x00000017152b7c11ULL, 0x000fe200090f4c16ULL, 0x000000121f1f7c36ULL, 0x000fe20008000000ULL,
0x000000162d227c11ULL, 0x000fe2000f8248ffULL, 0x0000001221217c36ULL, 0x000fe20008000000ULL,
0x0000001617247c11ULL, 0x000fe2000f8648ffULL, 0x0000001223237c36ULL, 0x000fe20008000000ULL,
0x000000131d1d7c10ULL, 0x000fe2000ff5e0ffULL, 0x000020000c0c7890ULL, 0x000fe2000fffe03fULL,
0xfffffff837007812ULL, 0x000fc400078ee200ULL, 0x0000001713377c11ULL, 0x000fe400080f4c1aULL,
0x0000001319197c10ULL, 0x000fe4000ff1e0ffULL, 0x000000172d2d7c11ULL, 0x000fe400088f4c18ULL,
0x0000001717277c11ULL, 0x000fe200098f4c14ULL, 0x000000ffff147224ULL, 0x000fe200010e06ffULL,
0x000000131b1b7c10ULL, 0x000fe2000ff3e0ffULL, 0x000000ffff167224ULL, 0x000fe200000e06ffULL,
0x000000161d2a7c11ULL, 0x000fc4000f8448ffULL, 0xfffffff8350c7812ULL, 0x000fe200078ee20cULL,
0x000000ffff367224ULL, 0x000fe200008e06ffULL, 0x0000001619267c11ULL, 0x000fe4000f8048ffULL,
0x000000171d357c11ULL, 0x000fe400090f4c14ULL, 0x000000161b287c11ULL, 0x000fe4000f8248ffULL,
0x0000001325257c10ULL, 0x000fe4000ff5e0ffULL, 0x000000131f1f7c10ULL, 0x000fc4000ff7e0ffULL,
0x0000001719137c11ULL, 0x000fe200080f4c16ULL, 0x000000ffff167224ULL, 0x000fe200010e06ffULL,
0x0000001321217c10ULL, 0x000fe2000ff1e0ffULL, 0x000000ffff347224ULL, 0x000fe200018e06ffULL,
0x000000171b367c11ULL, 0x000fe400088f4c36ULL, 0x0000001323237c10ULL, 0x000fe2000ff3e0ffULL,
0x000000ffff147224ULL, 0x000fe200000e06ffULL, 0x0000001625327c11ULL, 0x000fe4000f8448ffULL,
0x000000161f2c7c11ULL, 0x000fe2000f8648ffULL, 0x000000ffff187224ULL, 0x000fe200008e06ffULL,
0x000000700d3f7812ULL, 0x000fc400078ec0ffULL, 0x00000016212e7c11ULL, 0x000fe4000f8048ffULL,
0x0000001725337c11ULL, 0x000fe400090f4c16ULL, 0x000000171f347c11ULL, 0x000fe400098f4c34ULL,
0x0000001623307c11ULL, 0x000fe4000f8248ffULL, 0x0000003a3f1a7210ULL, 0x000fe40007f5e0ffULL,
0x0000001c3f1c7210ULL, 0x000fc40007f7e0ffULL, 0x00000017212f7c11ULL, 0x000fe200080f4c14ULL,
0x000000ffff1b7224ULL, 0x000fe200010e063bULL, 0x000000313f147210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff1d7224ULL, 0x000fe200018e0639ULL, 0x0000001723317c11ULL, 0x000fe400088f4c18ULL,
0x0000003c3f187210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff157224ULL, 0x000fe200000e063eULL,
0x000000243f247210ULL, 0x000fe40007f5e0ffULL, 0x000000263f267210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff197224ULL, 0x000fe200008e063dULL, 0x0000001e3f1e7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff257224ULL, 0x000fe200010e0627ULL, 0x000000293f167210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff277224ULL, 0x000fe200018e0613ULL, 0x0000000c400d7c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff1f7224ULL, 0x000fe200028e0638ULL, 0x000000203f207210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff177224ULL, 0x000fe200008e062bULL, 0x000000223f227210ULL, 0x000fe20007f1e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000140d7faeULL, 0x0003e2000b901c4eULL,
0x0000000c12137c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff217224ULL, 0x000fe200020e0637ULL,
0x0000000c11117c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff237224ULL, 0x000fe200000e062dULL,
0x0000000c10297c11ULL, 0x000fe2000f8e20ffULL, 0x0000000018137faeULL, 0x000fe2000b901c4eULL,
0x0000000c0f0f7c11ULL, 0x000fc4000f8e20ffULL, 0x000000283f287210ULL, 0x000fe20007fbe0ffULL,
0x000000001a117faeULL, 0x000fe2000b901c4eULL, 0x0000000c0e2b7c11ULL, 0x000fe4000f8e20ffULL,
0x0000002a3f2a7210ULL, 0x000fe20007f9e0ffULL, 0x000000001c297faeULL, 0x0005e2000b901c4eULL,
0x0000000c0a2d7c11ULL, 0x000fe4000f8e20ffULL, 0x0000002c3f2c7210ULL, 0x000fe20007f1e0ffULL,
0x000000001e0f7faeULL, 0x000fe2000b901c4eULL, 0x0000000c09097c11ULL, 0x000fc4000f8e20ffULL,
0x0000002e3f2e7210ULL, 0x000fe20007f3e0ffULL, 0x00000000202b7faeULL, 0x0007e2000b901c4eULL,
0x0000000c080d7c11ULL, 0x002fe4000f8e20ffULL, 0x000000303f307210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff297224ULL, 0x004fe200028e0636ULL, 0x0000000c07077c11ULL, 0x000fe2000f8e20ffULL,
0x00000000222d7faeULL, 0x0003e2000b901c4eULL, 0x000000323f327210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff2f7224ULL, 0x000fe200008e062fULL, 0x0000000c06117c11ULL, 0x000fe2000f8e20ffULL,
0x0000000016097faeULL, 0x0009e2000b901c4eULL, 0x0000000c05057c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff2b7224ULL, 0x008fe200020e0635ULL, 0x0000000c040f7c11ULL, 0x000fe2000f8e20ffULL,
0x00000000240d7faeULL, 0x000fe2000b901c4eULL, 0x0000000c0b0b7c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff317224ULL, 0x000fc400010e0631ULL, 0x000000ffff2d7224ULL, 0x002fe200000e0634ULL,
0x0000000026077faeULL, 0x0003e2000b901c4eULL, 0x000000ffff337224ULL, 0x000fe200018e0633ULL,
0x0000000c0c097c11ULL, 0x010fe4000f8e20ffULL, 0x0000000028117faeULL, 0x0005e8000b901c4eULL,
0x000000002a057faeULL, 0x0005e2000b901c4eULL, 0x0000000c00077c11ULL, 0x002fc6000f8e20ffULL,
0x000000002c0f7faeULL, 0x0005e8000b901c4eULL, 0x000000002e097faeULL, 0x0005e8000b901c4eULL,
0x00000000300b7faeULL, 0x0005e8000b901c4eULL, 0x0000000032077faeULL, 0x0005e4000b901c4eULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000000047805ULL, 0x006fe20000015200ULL,
0x01c60003ff0075a7ULL, 0x000ee40008000144ULL, 0x00000000005c0947ULL, 0x00efea0003800000ULL,
0x000000ffff087224ULL, 0x000fce00078e00ffULL, 0x000000100800780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x0000000604097210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09000900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011407ULL, 0x0000000900007211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000200007819ULL, 0x000fc80000001207ULL,
0x000000000000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000108087836ULL, 0x000fce0000000000ULL, 0x01c60003ff0075a7ULL, 0x000e640008000144ULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000070500728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000900000127ab9ULL, 0x000fe40000000800ULL, 0x00000012081272a4ULL, 0x000fd8000f8e023fULL,
0x0000001805137291ULL, 0x000fc8000f8e403fULL, 0x000000131400728cULL, 0x000fcc000bf04070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x000000000000894dULL, 0x002fea0003800000ULL,
0x0000000105087890ULL, 0x000fe2000fffe03fULL, 0x0000000000487919ULL, 0x000e620000000000ULL,
0x000000190b1a72a4ULL, 0x000fe4000f8e023fULL, 0x000000070800728cULL, 0x000fe4000bf06070ULL,
0x0000004013087892ULL, 0x000fc8000f8ec03fULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x000000080a087290ULL, 0x000fd8000fffe03fULL, 0x0000000c00688947ULL, 0x000fea0003800000ULL,
0x00000003ff187819ULL, 0x102fe20000011648ULL, 0x80000013140d7290ULL, 0x000fe2000fffe03fULL,
0x0ffffff848687812ULL, 0x000fe200078ec0ffULL, 0x00008a0000167ab9ULL, 0x000fe20000000a00ULL,
0x00000004110c7291ULL, 0x000fe2000f8e703fULL, 0x0000000418027836ULL, 0x000fe40000000000ULL,
0x0000000818007c36ULL, 0x000fe20008000000ULL, 0x000040000c157890ULL, 0x000fe2000fffe03fULL,
0x0000000102037824ULL, 0x040fe200078e0248ULL, 0x0000000d02007c0cULL, 0x040fe2000bf86070ULL,
0x0000000802047824ULL, 0x000fc400078e00ffULL, 0x0000000c181b7836ULL, 0x000fe40000000000ULL,
0x00000010181c7836ULL, 0x000fe20000000000ULL, 0xfffffff8041f7812ULL, 0x000fe200078ee203ULL,
0x0000000818037836ULL, 0x000fe20000000000ULL, 0x0000001a00047c10ULL, 0x000fe2000ff3e0ffULL,
0x0000000802007c36ULL, 0x000fe20008000000ULL, 0x000000151f1f7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000803027c36ULL, 0x000fe20008000000ULL, 0x0000000d03007c0cULL, 0x040fe2000bfa6070ULL,
0x0000000103067824ULL, 0x140fe200078e0248ULL, 0x0000001a00007c10ULL, 0x000fe2000ff5e0ffULL,
0x0000000803217824ULL, 0x000fe200078e00ffULL, 0x0000001a02027c10ULL, 0x000fe2000ff7e0ffULL,
0x000000ffff057224ULL, 0x000fe200008e06ffULL, 0x0000001604167c11ULL, 0x000fe2000f8248ffULL,
0x000000ffff037224ULL, 0x000fe200010e06ffULL, 0x0000001600107c11ULL, 0x000fe2000f8448ffULL,
0x0000001418227836ULL, 0x000fe20000000000ULL, 0x0000001704177c11ULL, 0x000fe200088f4c05ULL,
0x0000001818247836ULL, 0x000fe20000000000ULL, 0x0000001700117c11ULL, 0x000fe200090f4c03ULL,
0x000000ffff037224ULL, 0x000fe200018e06ffULL, 0x0000001602147c11ULL, 0x040fe2000f8248ffULL,
0x000000081b007c36ULL, 0x000fe20008000000ULL, 0xfffffff821217812ULL, 0x000fe200078ee206ULL,
0x0000002418277836ULL, 0x000fe20000000000ULL, 0x0000001702157c11ULL, 0x000fe200088f4c03ULL,
0x000000081c027c36ULL, 0x000fe20008000000ULL, 0x0000001a00007c10ULL, 0x000fe2000ff5e0ffULL,
0x0000000822037c36ULL, 0x000fe20008000000ULL, 0x0000001521217c11ULL, 0x000fe2000f8e20ffULL,
0x0000001c18257836ULL, 0x000fe20000000000ULL, 0x0000001a02047c10ULL, 0x000fe2000ff7e0ffULL,
0x000000ffff077224ULL, 0x000fe200010e06ffULL, 0x0000001a03037c10ULL, 0x000fe2000ff3e0ffULL,
0x0000002018267836ULL, 0x000fe20000000000ULL, 0x0000001600127c11ULL, 0x000fe2000f8448ffULL,
0x000000ffff057224ULL, 0x000fe200018e06ffULL, 0x00000016040a7c11ULL, 0x000fe2000f8648ffULL,
0x000000ffff027224ULL, 0x000fe200008e06ffULL, 0x0000001700137c11ULL, 0x000fe200090f4c07ULL,
0x0000000824007c36ULL, 0x000fe20008000000ULL, 0x0000001603087c11ULL, 0x040fe2000f8248ffULL,
0x00000001180f7824ULL, 0x000fe200078e0248ULL, 0x00000017040b7c11ULL, 0x000fe200098f4c05ULL,
0x0000002818287836ULL, 0x000fe20000000000ULL, 0x0000001703097c11ULL, 0x000fe200088f4c02ULL,
0x0000000827037c36ULL, 0x000fe20008000000ULL, 0x0000001a00047c10ULL, 0x000fe2000ff3e0ffULL,
0x0000000825007c36ULL, 0x000fe20008000000ULL, 0x00000007681d7812ULL, 0x000fe200078ef80fULL,
0x0000000826027c36ULL, 0x000fc40008000000ULL, 0x000000ffff057224ULL, 0x000fe200008e06ffULL,
0x00000016040c7c11ULL, 0x040fe2000f8248ffULL, 0x000000011b1e7824ULL, 0x140fe200078e0248ULL,
0x0000001a00077c10ULL, 0x000fe2000ff5e0ffULL, 0x000000081b237824ULL, 0x000fe200078e00ffULL,
0x00000017040d7c11ULL, 0x000fe200088f4c05ULL, 0x0000002c18297836ULL, 0x000fe20000000000ULL,
0x0000001a03037c10ULL, 0x000fe2000ff3e0ffULL, 0x000000ffff1a7224ULL, 0x000fe200010e06ffULL,
0x0000001a02057c10ULL, 0x000fe2000ff7e0ffULL, 0x000000011c207824ULL, 0x040fe200078e0248ULL,
0x0000001607067c11ULL, 0x000fe2000f8448ffULL, 0x000000ffff007224ULL, 0x000fe200008e06ffULL,
0x0000001603027c11ULL, 0x000fe2000f8248ffULL, 0x000000ffff0e7224ULL, 0x000fe200018e06ffULL,
0x0000001605047c11ULL, 0x000fe2000f8648ffULL, 0x000000081c2b7824ULL, 0x000fe200078e00ffULL,
0x0000001703037c11ULL, 0x000fe200088f4c00ULL, 0x00000034182a7836ULL, 0x000fe20000000000ULL,
0x0000001707077c11ULL, 0x000fc400090f4c1aULL, 0x0000000748007812ULL, 0x000fe400078ec0ffULL,
0x0000000d18007c0cULL, 0x000fe4000bf46070ULL, 0x0000001705057c11ULL, 0x000fe200098f4c0eULL,
0x00000008280e7c36ULL, 0x000fe20008000000ULL, 0x0000000800197812ULL, 0x000fe400078efcffULL,
0x0000000d1b007c0cULL, 0x000fe4000bf66070ULL, 0x0000001a0e0f7c10ULL, 0x000fe2000ffde0ffULL,
0x00000010191a7825ULL, 0x000fe200078e0016ULL, 0x000000151d1d7c11ULL, 0x000fc4000f8e20ffULL,
0x0000000d1c007c0cULL, 0x000fe2000bf26070ULL, 0x000000ffff1c7224ULL, 0x000fe200030e06ffULL,
0xfffffff8231e7812ULL, 0x000fe200078ee21eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a1d7faeULL, 0x0003e2000d101c4eULL, 0x000000160f0e7c11ULL, 0x040fe2000f8c48ffULL,
0x0000000829167c36ULL, 0x000fe20008000000ULL, 0x0000000d22007c0cULL, 0x040fe2000bf46070ULL,
0x0000000122237824ULL, 0x040fe200078e0248ULL, 0x000000170f0f7c11ULL, 0x000fe2000b0f4c1cULL,
0x0000000822227824ULL, 0x000fe200078e00ffULL, 0x0000001a16177c10ULL, 0x000fe2000ffde0ffULL,
0x0000001019107825ULL, 0x000fe200078e0010ULL, 0xfffffff82b207812ULL, 0x000fc400078ee220ULL,
0xfffffff822237812ULL, 0x000fe200078ee223ULL, 0x0000003018227836ULL, 0x000fe20000000000ULL,
0x00000000101f7faeULL, 0x0005e2000e101c4eULL, 0x000000ffff1c7224ULL, 0x000fe200030e06ffULL,
0x0000001617167c11ULL, 0x000fe2000f8c48ffULL, 0x0000001019147825ULL, 0x000fe200078e0014ULL,
0x000000151e1b7c11ULL, 0x002fe4000f8e20ffULL, 0x0000001717177c11ULL, 0x000fe2000b0f4c1cULL,
0x00000008221a7c36ULL, 0x000fe20008000000ULL, 0x0000000014217faeULL, 0x0003e2000e901c4eULL,
0x0000000d24007c0cULL, 0x040fe2000bfa6070ULL, 0x00000001241c7824ULL, 0x140fe200078e0248ULL,
0x0000000d25007c0cULL, 0x040fe2000bf86070ULL, 0x00000008242b7824ULL, 0x000fe200078e00ffULL,
0x0000001a1a1a7c10ULL, 0x000fe2000ffde0ffULL, 0x00000001251d7824ULL, 0x000fe200078e0248ULL,
0x00000015231f7c11ULL, 0x004fe2000f8e20ffULL, 0x0000000825247824ULL, 0x000fe200078e00ffULL,
0xfffffff82b1c7812ULL, 0x000fe200078ee21cULL, 0x000000ffff117224ULL, 0x000fe200030e06ffULL,
0x000000161a107c11ULL, 0x000fe2000f8c48ffULL, 0x0000001019147825ULL, 0x002fe200078e0012ULL,
0xfffffff8241e7812ULL, 0x000fc400078ee21dULL, 0x00000015201d7c11ULL, 0x000fe2000f8e20ffULL,
0x000000082a127c36ULL, 0x000fe20008000000ULL, 0x000000171a117c11ULL, 0x000fe2000b0f4c11ULL,
0x0000003818207836ULL, 0x000fe20000000000ULL, 0x00000000141b7faeULL, 0x0003e2000d901c4eULL,
0x00000010190a7825ULL, 0x040fe200078e000aULL, 0x0000001a12137c10ULL, 0x000fe4000ffde0ffULL,
0x0000000d26007c0cULL, 0x000fe2000bf66070ULL, 0x0000001019087825ULL, 0x000fe200078e0008ULL,
0x000000000a1d7faeULL, 0x0005e2000c901c4eULL, 0x0000000d28007c0cULL, 0x000fc4000bf26070ULL,
0x000000ffff1a7224ULL, 0x000fe200030e06ffULL, 0x00000000081f7faeULL, 0x0007e2000d101c4eULL,
0x0000001613127c11ULL, 0x040fe2000f8c48ffULL, 0x0000000820147c36ULL, 0x002fe20008000000ULL,
0x000000151c157c11ULL, 0x000fe2000f8e20ffULL, 0x0000003c18237836ULL, 0x000fe20000000000ULL,
0x0000001713137c11ULL, 0x000fe2000b0f4c1aULL, 0x0000000126217824ULL, 0x140fe200078e0248ULL,
0x0000001a14147c10ULL, 0x000fe2000ff5e0ffULL, 0x0000000826267824ULL, 0x000fe200078e00ffULL,
0x0000000d27007c0cULL, 0x040fe2000bfc6070ULL, 0x00000001271a7824ULL, 0x000fc400078e0248ULL,
0x000000ffff0b7224ULL, 0x004fe200010e06ffULL, 0x0000001614087c11ULL, 0x048fe2000f8448ffULL,
0x00000010190c7825ULL, 0x000fe200078e000cULL, 0xfffffff826217812ULL, 0x000fe400078ee221ULL,
0x0000001714097c11ULL, 0x000fe200090f4c0bULL, 0x0000000827277824ULL, 0x000fe200078e00ffULL,
0x000000000c157faeULL, 0x0003e2000e901c4eULL, 0x00000001281b7824ULL, 0x040fe200078e0248ULL,
0x00000015211d7c11ULL, 0x000fe2000f8e20ffULL, 0x00000008230a7c36ULL, 0x000fe20008000000ULL,
0xfffffff8271a7812ULL, 0x000fe200078ee21aULL, 0x0000000828287824ULL, 0x000fe200078e00ffULL,
0x0000000d29007c0cULL, 0x000fe2000bf46070ULL, 0x0000001019067825ULL, 0x000fe200078e0006ULL,
0x0000001a0a0b7c10ULL, 0x000fc4000ffbe0ffULL, 0xfffffff828187812ULL, 0x000fe200078ee21bULL,
0x0000001019047825ULL, 0x040fe200078e0004ULL, 0x000000151e1b7c11ULL, 0x000fe4000f8e20ffULL,
0x000000151a1f7c11ULL, 0x000fe2000f8e20ffULL, 0x0000001019027825ULL, 0x000fe400078e0002ULL,
0x00000000061b7faeULL, 0x0005e2000e101c4eULL, 0x0000000d2a007c0cULL, 0x000fe2000bf86070ULL,
0x000000ffff147224ULL, 0x000fe200028e06ffULL, 0x000000160b0a7c11ULL, 0x000fe2000f8a48ffULL,
0x00000001291c7824ULL, 0x040fe200078e0248ULL, 0x00000000041d7faeULL, 0x000fe2000d901c4eULL,
0x0000000829297824ULL, 0x000fe200078e00ffULL, 0x000000170b0b7c11ULL, 0x000fe2000a8f4c14ULL,
0x00000001220c7824ULL, 0x142fe200078e0248ULL, 0x00000000021f7faeULL, 0x0003e2000f101c4eULL,
0x0000000822157824ULL, 0x000fe200078e00ffULL, 0x0000000d23007c0cULL, 0x000fe2000bfc6070ULL,
0x000000012a0d7824ULL, 0x100fe200078e0248ULL, 0x0000000d22007c0cULL, 0x000fe2000bf66070ULL,
0x000000082a2a7824ULL, 0x000fe200078e00ffULL, 0x0000000d20007c0cULL, 0x040fe2000bfa6070ULL,
0x0000000120147824ULL, 0x040fe200078e0248ULL, 0xfffffff8291c7812ULL, 0x000fe200078ee21cULL,
0x0000000820077824ULL, 0x004fe200078e00ffULL, 0xfffffff8150c7812ULL, 0x000fe200078ee20cULL,
0x00000010190e7825ULL, 0x000fe200078e000eULL, 0xfffffff82a0d7812ULL, 0x000fc400078ee20dULL,
0xfffffff807147812ULL, 0x000fe200078ee214ULL, 0x0000000123027824ULL, 0x042fe200078e0248ULL,
0x0000001518077c11ULL, 0x000fe2000f8e20ffULL, 0x0000000823237824ULL, 0x000fe200078e00ffULL,
0x000000150d0d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000001019167825ULL, 0x040fe200078e0016ULL,
0x0000001514157c11ULL, 0x000fe2000f8e20ffULL, 0x000000000e077faeULL, 0x0003e2000c901c4eULL,
0xfffffff823067812ULL, 0x000fe200078ee202ULL, 0x0000001019027825ULL, 0x000fe200078e0008ULL,
0x000000151c097c11ULL, 0x000fc6000f8e20ffULL, 0x0000001019047825ULL, 0x040fe200078e000aULL,
0x000000150c0b7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000016097faeULL, 0x0003e4000d101c4eULL,
0x0000001019107825ULL, 0x000fc800078e0010ULL, 0x0000001019127825ULL, 0x000fe200078e0012ULL,
0x0000001506197c11ULL, 0x000fe2000f8e20ffULL, 0x00000000100b7faeULL, 0x0003e8000d901c4eULL,
0x00000000120d7faeULL, 0x0003e8000e101c4eULL, 0x0000000002157faeULL, 0x0003e8000e901c4eULL,
0x0000000004197faeULL, 0x0003e2000f101c4eULL, 0x0000000c001c7947ULL, 0x000fea0003800000ULL,
0x0000000448057811ULL, 0x042fe200078fe8ffULL, 0x00008a0000167ab9ULL, 0x000fe20000000a00ULL,
0x0000000848067811ULL, 0x040fe200078fe8ffULL, 0x00000004110c7291ULL, 0x000fe2000f8e703fULL,
0x0000000c48077811ULL, 0x040fe200078fe8ffULL, 0x0000000105267824ULL, 0x140fe200078e0248ULL,
0x0000001848107811ULL, 0x040fe200078fe8ffULL, 0x0000000805037824ULL, 0x000fe200078e00ffULL,
0x0000001048087811ULL, 0x000fe200078fe8ffULL, 0x0000000106257824ULL, 0x100fe200078e0248ULL,
0x0000001c48117811ULL, 0x000fe200078fe8ffULL, 0x0000000806007824ULL, 0x000fe200078e00ffULL,
0xfffffff803267812ULL, 0x000fe200078ee226ULL, 0x0000000107247824ULL, 0x140fe200078e0248ULL,
0x00000028481b7811ULL, 0x000fe200078fe8ffULL, 0x0000000807037824ULL, 0x000fe200078e00ffULL,
0xfffffff800257812ULL, 0x000fe200078ee225ULL, 0x0000000110217824ULL, 0x100fe200078e0248ULL,
0x0000002048137811ULL, 0x000fe200078fe8ffULL, 0x0000000810007824ULL, 0x000fe200078e00ffULL,
0xfffffff803247812ULL, 0x000fe200078ee224ULL, 0x0000000108237824ULL, 0x100fe200078e0248ULL,
0x0000002c48277811ULL, 0x000fe200078fe8ffULL, 0x0000000808027824ULL, 0x000fe200078e00ffULL,
0xfffffff800217812ULL, 0x000fe200078ee221ULL, 0x0000000111207824ULL, 0x140fe200078e0248ULL,
0x00000014480b7811ULL, 0x040fe200078fe8ffULL, 0x0000000811037824ULL, 0x000fe200078e00ffULL,
0xfffffff802237812ULL, 0x000fe200078ee223ULL, 0x000000011b1d7824ULL, 0x140fe200078e0248ULL,
0x00000030482d7811ULL, 0x040fe200078fe8ffULL, 0x000000081b007824ULL, 0x000fe200078e00ffULL,
0xfffffff803207812ULL, 0x000fe200078ee220ULL, 0x00000001131f7824ULL, 0x140fe200078e0248ULL,
0x00000024481a7811ULL, 0x040fe200078fe8ffULL, 0x0000000813027824ULL, 0x000fe200078e00ffULL,
0xfffffff8001d7812ULL, 0x000fe200078ee21dULL, 0x00000001271c7824ULL, 0x140fe200078e0248ULL,
0x0000000848007c11ULL, 0x040fe2000f8fe8ffULL, 0x0000000827037824ULL, 0x000fe200078e00ffULL,
0xfffffff8021f7812ULL, 0x000fe200078ee21fULL, 0x000000010b227824ULL, 0x140fe200078e0248ULL,
0x00000038482f7811ULL, 0x000fe200078fe8ffULL, 0x000000080b097824ULL, 0x000fe200078e00ffULL,
0xfffffff8031c7812ULL, 0x000fe200078ee21cULL, 0x000000012d157824ULL, 0x140fe200078e0248ULL,
0x0000001a00037c10ULL, 0x000fe2000ff3e0ffULL, 0x000000082d027824ULL, 0x000fe200078e00ffULL,
0xfffffff809227812ULL, 0x000fe200078ee222ULL, 0x000000011a1e7824ULL, 0x100fe200078e0248ULL,
0x00000034482e7811ULL, 0x000fe200078fe8ffULL, 0x000000081a097824ULL, 0x000fe200078e00ffULL,
0xfffffff802157812ULL, 0x000fe200078ee215ULL, 0x000000012f0d7824ULL, 0x140fe200078e0248ULL,
0x0000003c48307811ULL, 0x000fe200078fe8ffULL, 0x000000082f007824ULL, 0x000fe200078e00ffULL,
0xfffffff8091e7812ULL, 0x000fe200078ee21eULL, 0x000000ffff047224ULL, 0x000fe200008e06ffULL,
0x0000001603027c11ULL, 0x040fe2000f8248ffULL, 0x000000012e147824ULL, 0x040fe200078e0248ULL,
0xfffffff8000d7812ULL, 0x000fe200078ee20dULL, 0x000000082e097824ULL, 0x000fe200078e00ffULL,
0x0000001703037c11ULL, 0x000fe200088f4c04ULL, 0x0000000805007c36ULL, 0x000fe20008000000ULL,
0x00000048482b7211ULL, 0x000fe200078fe8ffULL, 0x0000000806047c36ULL, 0x000fe20008000000ULL,
0xfffffff809147812ULL, 0x000fe200078ee214ULL, 0x0000000807057c36ULL, 0x000fe20008000000ULL,
0x0000001a00077c10ULL, 0x000fe2000ff3e0ffULL, 0x00000001300c7824ULL, 0x040fe200078e0248ULL,
0x0000001a04067c10ULL, 0x000fe2000ff5e0ffULL, 0x0000000830097824ULL, 0x000fe200078e00ffULL,
0x0000001a05057c10ULL, 0x000fe2000ff7e0ffULL, 0x000000ffff0a7224ULL, 0x000fe200008e06ffULL,
0x0000001607167c11ULL, 0x000fe2000f8248ffULL, 0x0000000808007c36ULL, 0x000fe20008000000ULL,
0xfffffff8090c7812ULL, 0x000fe200078ee20cULL, 0x000000ffff097224ULL, 0x000fe200010e06ffULL,
0x00000016060e7c11ULL, 0x000fe2000f8448ffULL, 0x000000ffff047224ULL, 0x000fe200018e06ffULL,
0x0000001605087c11ULL, 0x000fe2000f8648ffULL, 0x000040000c157890ULL, 0x000fe2000fffe03fULL,
0x0000001707177c11ULL, 0x000fc400088f4c0aULL, 0x0000001a00077c10ULL, 0x000fe2000ff3e0ffULL,
0x000000080b007c36ULL, 0x000fe20008000000ULL, 0x00000017060f7c11ULL, 0x000fe400090f4c09ULL,
0x0000001705097c11ULL, 0x000fe200098f4c04ULL, 0x0000000810047c36ULL, 0x000fe20008000000ULL,
0x0ffffff848687812ULL, 0x000fe200078ec0ffULL, 0x0000000811057c36ULL, 0x000fe20008000000ULL,
0x0000001a00117c10ULL, 0x000fe2000ff5e0ffULL, 0x000000ffff0a7224ULL, 0x000fe200008e06ffULL,
0x0000001607067c11ULL, 0x000fc4000f8248ffULL, 0x0000001a04007c10ULL, 0x000fe2000ff7e0ffULL,
0x000000ffff127224ULL, 0x000fe200010e06ffULL, 0x0000001707077c11ULL, 0x000fe400088f4c0aULL,
0x0000001611187c11ULL, 0x040fe2000f8248ffULL, 0x000000ffff0b7224ULL, 0x000fe200018e06ffULL,
0x0000001a05057c10ULL, 0x000fe4000ff9e0ffULL, 0x0000001600107c11ULL, 0x040fe4000f8448ffULL,
0x0000001711197c11ULL, 0x000fe200088f4c12ULL, 0x000000ffff0a7224ULL, 0x000fe200020e06ffULL,
0x0000001700117c11ULL, 0x000fe200090f4c0bULL, 0x0000000813007c36ULL, 0x000fe20008000000ULL,
0x0000001605047c11ULL, 0x000fe2000f8648ffULL, 0x000000081b0b7c36ULL, 0x000fe20008000000ULL,
0x0000001525257c11ULL, 0x000fc4000f8e20ffULL, 0x0000001705057c11ULL, 0x000fe200098f4c0aULL,
0x000000081a0a7c36ULL, 0x000fe20008000000ULL, 0x0000001a001b7c10ULL, 0x000fe2000ff3e0ffULL,
0x0000000827007c36ULL, 0x000fe20008000000ULL, 0x0000001a0b0b7c10ULL, 0x000fe4000ff7e0ffULL,
0x0000001a0a137c10ULL, 0x000fe2000ff5e0ffULL, 0x000000ffff2c7224ULL, 0x000fe200008e06ffULL,
0x0000001a00007c10ULL, 0x000fe2000ff9e0ffULL, 0x000000ffff287224ULL, 0x000fe200018e06ffULL,
0x000000161b1a7c11ULL, 0x000fe2000f8248ffULL, 0x000000ffff2a7224ULL, 0x000fe200010e06ffULL,
0x000000160b0a7c11ULL, 0x000fe2000f8648ffULL, 0x000000ffff277224ULL, 0x000fe200020e06ffULL,
0x000000171b1b7c11ULL, 0x000fe200088f4c2cULL, 0x000000082f2c7c36ULL, 0x000fe20008000000ULL,
0x000000170b0b7c11ULL, 0x000fc400098f4c28ULL, 0x0000001613127c11ULL, 0x040fe4000f8448ffULL,
0x0000001600287c11ULL, 0x040fe4000f8248ffULL, 0x0000001713137c11ULL, 0x000fe200090f4c2aULL,
0x000000082d2a7c36ULL, 0x000fe20008000000ULL, 0x0000001700297c11ULL, 0x000fe200088f4c27ULL,
0x00000008302d7c36ULL, 0x000fe20008000000ULL, 0x0000000768277812ULL, 0x000fe200078ef82bULL,
0x000000082e2b7c36ULL, 0x000fe20008000000ULL, 0x0000000748007812ULL, 0x000fc400078ec0ffULL,
0x0000001a2a357c10ULL, 0x000fe4000ff5e0ffULL, 0x0000001a2b337c10ULL, 0x000fe4000ff7e0ffULL,
0x0000001a2c2f7c10ULL, 0x000fe2000ff9e0ffULL, 0x000000ffff387224ULL, 0x000fe200010e06ffULL,
0x0000001a2d317c10ULL, 0x000fe2000ff3e0ffULL, 0x000000ffff367224ULL, 0x000fe200018e06ffULL,
0x0000000800377812ULL, 0x000fe200078efcffULL, 0x000000ffff347224ULL, 0x000fe200020e06ffULL,
0x00000016352a7c11ULL, 0x000fe2000f8448ffULL, 0x000000ffff327224ULL, 0x000fe200008e06ffULL,
0x00000016332c7c11ULL, 0x000fe2000f8648ffULL, 0x0000001037027825ULL, 0x000fe200078e0002ULL,
0x000000162f2e7c11ULL, 0x000fc4000f8848ffULL, 0x0000001527277c11ULL, 0x000fe2000f8e20ffULL,
0x0000001037167825ULL, 0x000fe200078e0016ULL, 0x0000001631307c11ULL, 0x000fe4000f8248ffULL,
0x00000017352b7c11ULL, 0x000fe200090f4c38ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002277faeULL, 0x0003e2000b901c4eULL, 0x00000017332d7c11ULL, 0x000fe200098f4c36ULL,
0x00000010370e7825ULL, 0x000fe200078e000eULL, 0x000000172f2f7c11ULL, 0x000fe4000a0f4c34ULL,
0x0000001731317c11ULL, 0x000fe200088f4c32ULL, 0x0000001037087825ULL, 0x000fe200078e0008ULL,
0x0000001523237c11ULL, 0x000fc4000f8e20ffULL, 0x0000001522337c11ULL, 0x000fe2000f8e20ffULL,
0x0000001037067825ULL, 0x000fe200078e0006ULL, 0x0000001521217c11ULL, 0x000fe4000f8e20ffULL,
0x0000001526277c11ULL, 0x002fe2000f8e20ffULL, 0x0000001037027825ULL, 0x000fe200078e002aULL,
0x0000001520357c11ULL, 0x000fe4000f8e20ffULL, 0x000000151f1f7c11ULL, 0x000fe2000f8e20ffULL,
0x00000010372a7825ULL, 0x000fe200078e002cULL, 0x0000000016277faeULL, 0x000fe2000b901c4eULL,
0x000000151d1d7c11ULL, 0x000fc4000f8e20ffULL, 0x00000010372c7825ULL, 0x000fe200078e002eULL,
0x000000000e257faeULL, 0x0005e2000b901c4eULL, 0x0000001515157c11ULL, 0x000fe4000f8e20ffULL,
0x00000010372e7825ULL, 0x000fe200078e0030ULL, 0x0000001524317c11ULL, 0x000fe4000f8e20ffULL,
0x000000150d0d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000001037187825ULL, 0x040fe400078e0018ULL,
0x0000000008317faeULL, 0x0007e4000b901c4eULL, 0x0000001037107825ULL, 0x040fe200078e0010ULL,
0x000000150c0f7c11ULL, 0x004fe2000f8e20ffULL, 0x0000000006237faeULL, 0x0005e4000b901c4eULL,
0x0000001037047825ULL, 0x000fc400078e0004ULL, 0x0000000018337faeULL, 0x0003e4000b901c4eULL,
0x00000010371a7825ULL, 0x040fe400078e001aULL, 0x0000000010217faeULL, 0x0003e2000b901c4eULL,
0x0000001514097c11ULL, 0x008fe2000f8e20ffULL, 0x0000001037127825ULL, 0x040fe200078e0012ULL,
0x000000151c077c11ULL, 0x004fe2000f8e20ffULL, 0x0000000004357faeULL, 0x0003e4000b901c4eULL,
0x00000010370a7825ULL, 0x000fc400078e000aULL, 0x000000001a1f7faeULL, 0x0003e4000b901c4eULL,
0x0000001037287825ULL, 0x000fe200078e0028ULL, 0x000000151e377c11ULL, 0x000fca000f8e20ffULL,
0x0000000012377faeULL, 0x0003e8000b901c4eULL, 0x000000000a1d7faeULL, 0x0003e8000b901c4eULL,
0x0000000028077faeULL, 0x0003e8000b901c4eULL, 0x0000000002157faeULL, 0x0003e8000b901c4eULL,
0x000000002a097faeULL, 0x0003e8000b901c4eULL, 0x000000002c0d7faeULL, 0x0003e8000b901c4eULL,
0x000000002e0f7faeULL, 0x0003e4000b901c4eULL, 0x00000004ff037819ULL, 0x102fe20000011648ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000003ff047819ULL, 0x000fe20000011648ULL,
0x000020000c0c7890ULL, 0x000fe2000fffe03fULL, 0x0000000800027812ULL, 0x000fe200078ef848ULL,
0x0000000803057824ULL, 0x000fe200078e00ffULL, 0x0000000104087812ULL, 0x000fc600078ec0ffULL,
0x0000000102037824ULL, 0x040fe200078e0203ULL, 0xfffffff805247812ULL, 0x000fe200078ee200ULL,
0x0000002002047824ULL, 0x040fe400078e00ffULL, 0x00000020020a7824ULL, 0x000fe400078e00ffULL,
0x0000000108347824ULL, 0x000fe200078e0224ULL, 0xffffffe004047812ULL, 0x000fe200078ee203ULL,
0x0000000824057824ULL, 0x040fe400078e00ffULL, 0x00000008240b7824ULL, 0x000fe200078e00ffULL,
0x0000000404047c11ULL, 0x000fe2000f8e20ffULL, 0x00000002346e7836ULL, 0x000fe20000000000ULL,
0xfffffff8054a7812ULL, 0x000fe200078ee234ULL, 0x0000001024357836ULL, 0x000fe20000000000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000000c4a097c11ULL, 0x000fe2000f8e20ffULL,
0x000000000404783bULL, 0x000fe20000000200ULL, 0xfffffff80b6e7812ULL, 0x000fe200078ee26eULL,
0x0000000108697824ULL, 0x000fe400078e0235ULL, 0x00000000090c783bULL, 0x000e620000000200ULL,
0x0000000c6e107c11ULL, 0x000fe2000f8e20ffULL, 0x0000002024367836ULL, 0x000fe40000000000ULL,
0x0000440901007387ULL, 0x0005e20000100800ULL, 0x0000003024377836ULL, 0x000fc40000000000ULL,
0x0000000108657824ULL, 0x040fe200078e0236ULL, 0x000000001014783bULL, 0x000fe20000000200ULL,
0x00000001086d7824ULL, 0x000fe400078e0237ULL, 0x0000000837087824ULL, 0x000fe200078e00ffULL,
0x0000601001007387ULL, 0x0007e20000100800ULL, 0x00000012346f7836ULL, 0x000fe40000000000ULL,
0x0000000203097836ULL, 0x004fe20000000000ULL, 0xfffffff8086d7812ULL, 0x000fe200078ee26dULL,
0x0000002234707836ULL, 0x000fc40000000000ULL, 0x0000000836257824ULL, 0x040fe200078e00ffULL,
0xffffffe00a097812ULL, 0x000fe200078ee209ULL, 0x00000008350a7824ULL, 0x000fe200078e00ffULL,
0x0000000c6d117c11ULL, 0x000fe2000f8e20ffULL, 0x0000000835107824ULL, 0x008fe200078e00ffULL,
0x0000000409097c11ULL, 0x000fe2000f8e20ffULL, 0x0000003234727836ULL, 0x000fe20000000000ULL,
0xfffffff80a697812ULL, 0x000fe200078ee269ULL, 0x00000008360a7824ULL, 0x000fe200078e00ffULL,
0xfffffff8106f7812ULL, 0x000fe200078ee26fULL, 0x00000000091c783bULL, 0x0004e20000000200ULL,
0xfffffff825707812ULL, 0x000fe200078ee270ULL, 0x0000000837257824ULL, 0x000fe200078e00ffULL,
0xfffffff80a657812ULL, 0x000fe200078ee265ULL, 0x000000001120783bULL, 0x000f220000000200ULL,
0x0000000c6f107c11ULL, 0x000fe2000f8e20ffULL, 0x00000008243e7824ULL, 0x000fe200078e00ffULL,
0x0000000c70267c11ULL, 0x000fe2000f8e20ffULL, 0x00000006343d7836ULL, 0x000fe20000000000ULL,
0x0000000c69097c11ULL, 0x004fe2000f8e20ffULL, 0x0000000c0440723cULL, 0x002fe200000418ffULL,
0xfffffff825727812ULL, 0x000fc600078ee272ULL, 0x00004c0901007387ULL, 0x000fe20000100800ULL,
0xfffffff83e3d7812ULL, 0x000fe200078ee23dULL, 0x0000000e040c723cULL, 0x000fe400000418ffULL,
0x000000000918783bULL, 0x0002a20000000200ULL, 0x0000000c3d3f7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000c65097c11ULL, 0x002fca000f8e20ffULL, 0x0000540901007387ULL, 0x000fe80000100800ULL,
0x000000000908783bULL, 0x000e680000000200ULL, 0x00005c1101007387ULL, 0x000fe20000100800ULL,
0x000000141c40723cULL, 0x008fe60000041840ULL, 0x0000781001007387ULL, 0x000fe60000100800ULL,
0x000000161c14723cULL, 0x000fe2000004180cULL, 0x000000001010783bULL, 0x000ee80000000200ULL,
0x00000000260c783bULL, 0x000f620000000200ULL, 0x000000200438723cULL, 0x010fe600000418ffULL,
0x0000702601007387ULL, 0x0009e60000100800ULL, 0x000000180428723cULL, 0x004fe200000418ffULL,
0x0000000835207824ULL, 0x000fc400078e00ffULL, 0x0000000837217824ULL, 0x000fe400078e00ffULL,
0x0000000835357824ULL, 0x000fe200078e00ffULL, 0x0000001a0418723cULL, 0x000fe200000418ffULL,
0x0000000c72267c11ULL, 0x010fe2000f8e20ffULL, 0x0000000837377824ULL, 0x000fc800078e00ffULL,
0x00000000262c783bULL, 0x000ea80000000200ULL, 0x00006c2601007387ULL, 0x0009e20000100800ULL,
0x000000080430723cULL, 0x002fec00000418ffULL, 0x0000000a0408723cULL, 0x000fec00000418ffULL,
0x000000101c28723cULL, 0x008fec0000041828ULL, 0x000000121c10723cULL, 0x000fec0000041818ULL,
0x0000000c1c30723cULL, 0x020fe20000041830ULL, 0x0000002002197824ULL, 0x000fc400078e00ffULL,
0x0000000403187836ULL, 0x000fe40000000000ULL, 0x00000008241b7824ULL, 0x000fe200078e00ffULL,
0x000000220404723cULL, 0x000fe200000418ffULL, 0x00000004340c7836ULL, 0x000fe20000000000ULL,
0xffffffe019187812ULL, 0x000fe200078ee218ULL, 0x00000014340d7836ULL, 0x000fe40000000000ULL,
0x0000002434197836ULL, 0x000fe20000000000ULL, 0xfffffff81b257812ULL, 0x000fe200078ee20cULL,
0x0000000836227824ULL, 0x000fe200078e00ffULL, 0xfffffff820277812ULL, 0x000fe200078ee20dULL,
0x00000034341a7836ULL, 0x000fe20000000000ULL, 0x0000000e1c0c723cULL, 0x000fe20000041808ULL,
0x0000102501007387ULL, 0x0003e20000100800ULL, 0xfffffff822267812ULL, 0x010fe200078ee219ULL,
0x0000002002197824ULL, 0x000fe200078e00ffULL, 0xfffffff821237812ULL, 0x000fe200078ee21aULL,
0x0000142701007387ULL, 0x000fe20000100800ULL, 0x0000000c27207c11ULL, 0x000fe2000f8e20ffULL,
0x0000002c1c38723cULL, 0x004fe20000041838ULL, 0x0000000418087c11ULL, 0x000fe2000f8e20ffULL,
0x0000182601007387ULL, 0x000fe20000100800ULL, 0x0000000c261b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000603187836ULL, 0x000fe20000000000ULL, 0x0000000c25257c11ULL, 0x002fe2000f8e20ffULL,
0x00001c2301007387ULL, 0x000fe20000100800ULL, 0x0000000c231a7c11ULL, 0x000fe2000f8e20ffULL,
0x00000016342c7836ULL, 0x000fe20000000000ULL, 0xffffffe0193c7812ULL, 0x000fe200078ee218ULL,
0x0000642501007387ULL, 0x000fe20000100800ULL, 0x0000000836367824ULL, 0x000fe200078e00ffULL,
0x0000002e1c1c723cULL, 0x000fe20000041804ULL, 0x00000026342d7836ULL, 0x000fe20000000000ULL,
0x00000000254c783bULL, 0x000fe20000000200ULL, 0x0000003634347836ULL, 0x000fe20000000000ULL,
0xfffffff835457812ULL, 0x000fc400078ee22cULL, 0x0000682001007387ULL, 0x000fe20000100800ULL,
0xfffffff8364b7812ULL, 0x000fe400078ee22dULL, 0xfffffff837497812ULL, 0x000fe200078ee234ULL,
0x000000002024783bULL, 0x000fe20000000200ULL, 0x0000000c452c7c11ULL, 0x000fe4000f8e20ffULL,
0x000000043c447c11ULL, 0x000fe2000f8e20ffULL, 0x0000741b01007387ULL, 0x000fe20000100800ULL,
0x0000000c4b057c11ULL, 0x000fe4000f8e20ffULL, 0x0000000c49047c11ULL, 0x000fe2000f8e20ffULL,
0x000000000808783bULL, 0x000e680000000200ULL, 0x000000001b20783bULL, 0x000ea80000000200ULL,
0x00007c1a01007387ULL, 0x000fe80000100800ULL, 0x000000001a18783bULL, 0x000ee80000000200ULL,
0x0000203d01007387ULL, 0x000fe80000100800ULL, 0x0000244501007387ULL, 0x000fe80000100800ULL,
0x0000284b01007387ULL, 0x000fe80000100800ULL, 0x0000304901007387ULL, 0x000fe80000100800ULL,
0x0000843f01007387ULL, 0x000fe80000100800ULL, 0x0000802c01007387ULL, 0x000fe80000100800ULL,
0x0000880501007387ULL, 0x000fe20000100800ULL, 0x0000004c0840723cULL, 0x002fe60000041840ULL,
0x000000004444783bULL, 0x000fe60000000200ULL, 0x000000240828723cULL, 0x000fe20000041828ULL,
0x000000003f3c783bULL, 0x000e620000000200ULL, 0x00000003ff4c7819ULL, 0x000fc60000011648ULL,
0x000000002c2c783bULL, 0x000f220000000200ULL, 0x000000200830723cULL, 0x004fe60000041830ULL,
0x000000000534783bULL, 0x000ea60000000200ULL, 0x0000004e0814723cULL, 0x000fe20000041814ULL,
0x00008c0401007387ULL, 0x000fe80000100800ULL, 0x000000000404783bULL, 0x000f620000000200ULL,
0x000000260810723cULL, 0x000fe20000041810ULL, 0x00000000004d7919ULL, 0x000eaa0000000000ULL,
0x00000022080c723cULL, 0x000fec000004180cULL, 0x000000180838723cULL, 0x008fec0000041838ULL,
0x0000001a0808723cULL, 0x000fec000004181cULL, 0x0000003c4440723cULL, 0x002fec0000041840ULL,
0x0000002c4428723cULL, 0x010fec0000041828ULL, 0x000000344430723cULL, 0x004fec0000041830ULL,
0x0000003e443c723cULL, 0x000fec0000041814ULL, 0x0000002e442c723cULL, 0x000fec0000041810ULL,
0x000000364434723cULL, 0x000fec000004180cULL, 0x000000044438723cULL, 0x020fec0000041838ULL,
0x000000064444723cULL, 0x000fe20000041808ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000c00608947ULL, 0x000fde0003800000ULL, 0x000000014c057824ULL, 0x100fe200078e024dULL,
0x80000013140d7290ULL, 0x000fe2000fffe03fULL, 0x000000084c527836ULL, 0x000fe20000000000ULL,
0x00000010004b7812ULL, 0x000fe200078efcffULL, 0x000000104c507836ULL, 0x000fe20000000000ULL,
0x0000000768687812ULL, 0x000fe200078ef805ULL, 0x00000001526c7824ULL, 0x140fe400078e024dULL,
0x0000000852057824ULL, 0x000fe200078e00ffULL, 0x0000000c68247c11ULL, 0x000fe2000f8e20ffULL,
0x0000000150677824ULL, 0x000fc400078e024dULL, 0x0000000850067824ULL, 0x000fe200078e00ffULL,
0xfffffff8056c7812ULL, 0x000fe200078ee26cULL, 0x0000000c4c517836ULL, 0x000fe20000000000ULL,
0x00000c2401007387ULL, 0x0003e20000100800ULL, 0x0000001c4c057836ULL, 0x000fe20000000000ULL,
0xfffffff806677812ULL, 0x000fe200078ee267ULL, 0x00000001516a7824ULL, 0x140fe200078e024dULL,
0x0000000c6c4f7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000851077824ULL, 0x000fe200078e00ffULL,
0x0000000c677d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000105637824ULL, 0x000fc400078e024dULL,
0x0000000805067824ULL, 0x000fe200078e00ffULL, 0xfffffff8076a7812ULL, 0x000fe200078ee26aULL,
0x000000144c277836ULL, 0x000fe40000000000ULL, 0x000000244c597836ULL, 0x000fe20000000000ULL,
0xfffffff806637812ULL, 0x000fe200078ee263ULL, 0x000000044c537836ULL, 0x000fe20000000000ULL,
0x0000000c6a4e7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000127667824ULL, 0x000fe200078e024dULL,
0x0000000c637a7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000827077824ULL, 0x000fc400078e00ffULL,
0x000000184c267836ULL, 0x000fe40000000000ULL, 0x0000000159617824ULL, 0x140fe200078e024dULL,
0xfffffff807667812ULL, 0x000fe200078ee266ULL, 0x0000000859067824ULL, 0x000fe400078e00ffULL,
0x00000008510c7c36ULL, 0x000fe20008000000ULL, 0x0000000c667c7c11ULL, 0x000fe2000f8e20ffULL,
0x00000001536b7824ULL, 0x140fe200078e024dULL, 0xfffffff806617812ULL, 0x000fe200078ee261ULL,
0x0000000853047824ULL, 0x000fe200078e00ffULL, 0x0000001a0c0d7c10ULL, 0x000fe2000ff3e0ffULL,
0x000000284c587836ULL, 0x000fe20000000000ULL, 0x0000000c61787c11ULL, 0x000fe2000f8e20ffULL,
0x0000002c4c577836ULL, 0x000fe20000000000ULL, 0xfffffff8046b7812ULL, 0x000fe200078ee26bULL,
0x0000000126647824ULL, 0x000fc400078e024dULL, 0x0000000826097824ULL, 0x000fe200078e00ffULL,
0x0000000c6b547c11ULL, 0x000fe2000f8e20ffULL, 0x0000000158607824ULL, 0x140fe400078e024dULL,
0x0000000858077824ULL, 0x000fe200078e00ffULL, 0xfffffff809647812ULL, 0x000fe200078ee264ULL,
0x00000001575f7824ULL, 0x140fe200078e024dULL, 0x0000085401007387ULL, 0x0005e20000100800ULL,
0x0000000857087824ULL, 0x000fe200078e00ffULL, 0xfffffff807607812ULL, 0x000fe200078ee260ULL,
0x000000304c567836ULL, 0x000fe20000000000ULL, 0x0000000c647b7c11ULL, 0x000fe2000f8e20ffULL,
0x000000084c067c36ULL, 0x000fe20008000000ULL, 0xfffffff8085f7812ULL, 0x000fe200078ee25fULL,
0x000000204c047836ULL, 0x000fe20000000000ULL, 0x0000000c60777c11ULL, 0x000fe2000f8e20ffULL,
0x00000001565e7824ULL, 0x140fe200078e024dULL, 0x0000001a06077c10ULL, 0x000fe2000ff5e0ffULL,
0x0000000856097824ULL, 0x000fe200078e00ffULL, 0x0000000c5f767c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff147224ULL, 0x000fe200008e06ffULL, 0x000000160d0c7c11ULL, 0x040fe2000f8248ffULL,
0x0000000104627824ULL, 0x040fe200078e024dULL, 0xfffffff8095e7812ULL, 0x000fe200078ee25eULL,
0x00000008040b7824ULL, 0x000fe200078e00ffULL, 0x000000170d0d7c11ULL, 0x000fe200088f4c14ULL,
0x0000000853087c36ULL, 0x000fe20008000000ULL, 0x0000000c5e757c11ULL, 0x000fe2000f8e20ffULL,
0x00000008520a7c36ULL, 0x000fe20008000000ULL, 0xfffffff80b627812ULL, 0x000fe200078ee262ULL,
0x000000ffff0e7224ULL, 0x000fe200010e06ffULL, 0x0000001a08097c10ULL, 0x000fe2000ff7e0ffULL,
0x0000000805147c36ULL, 0x000fe20008000000ULL, 0x0000001a0a0b7c10ULL, 0x000fe2000ff9e0ffULL,
0x00000008581b7c36ULL, 0x000fe20008000000ULL, 0x0000001607067c11ULL, 0x040fe2000f8448ffULL,
0x000000ffff107224ULL, 0x000fe200018e06ffULL, 0x0000001a14157c10ULL, 0x000fe2000ff3e0ffULL,
0x000000ffff127224ULL, 0x000fe200020e06ffULL, 0x0000001707077c11ULL, 0x000fe200090f4c0eULL,
0x00000008500e7c36ULL, 0x000fe20008000000ULL, 0x0000001609087c11ULL, 0x000fe2000f8648ffULL,
0x000000ffff1c7224ULL, 0x000fe200008e06ffULL, 0x000000160b0a7c11ULL, 0x000fe2000f8848ffULL,
0x00000008571d7c36ULL, 0x000fe20008000000ULL, 0x0000001709097c11ULL, 0x000fe200098f4c10ULL,
0x0000000827107c36ULL, 0x000fe20008000000ULL, 0x000000170b0b7c11ULL, 0x000fe2000a0f4c12ULL,
0x0000000826127c36ULL, 0x000fe20008000000ULL, 0x0000001a0e0f7c10ULL, 0x000fe2000ff5e0ffULL,
0x0000000804177c36ULL, 0x000fe20008000000ULL, 0x0000001615147c11ULL, 0x040fe2000f8248ffULL,
0x0000000859197c36ULL, 0x000fe20008000000ULL, 0x0000001a10117c10ULL, 0x000fe2000ff7e0ffULL,
0x000000ffff167224ULL, 0x000fe200010e06ffULL, 0x0000001715157c11ULL, 0x000fe200088f4c1cULL,
0x000000104b1e7825ULL, 0x000fe200078e0006ULL, 0x0000000d4c007c0cULL, 0x000fe2000bf26070ULL,
0x0000044f01007387ULL, 0x0007e20000100800ULL, 0x0000001a12137c10ULL, 0x000fe2000ff9e0ffULL,
0x000000ffff187224ULL, 0x000fe200018e06ffULL, 0x000000160f0e7c11ULL, 0x000fe2000f8448ffULL,
0x000000344c557836ULL, 0x000fe20000000000ULL, 0x0000001611107c11ULL, 0x000fe2000f8648ffULL,
0x000000ffff1a7224ULL, 0x000fe200020e06ffULL, 0x000000170f0f7c11ULL, 0x000fe200090f4c16ULL,
0x00000001555d7824ULL, 0x100fe200078e024dULL, 0x0000001a1b1b7c10ULL, 0x000fe2000ff5e0ffULL,
0x0000003c4c5a7836ULL, 0x000fe20000000000ULL, 0x0000001613127c11ULL, 0x000fe2000f8848ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e247faeULL, 0x0009e2000c901c4eULL,
0x0000001711117c11ULL, 0x000fe200098f4c18ULL, 0x000000ffff227224ULL, 0x000fe200010e06ffULL,
0x0000001713137c11ULL, 0x000fe2000a0f4c1aULL, 0x000000015a5b7824ULL, 0x000fe200078e024dULL,
0x0000001a1d1d7c10ULL, 0x000fe2000ff7e0ffULL, 0x000000104b487825ULL, 0x000fe200078e0010ULL,
0x0000001a17177c10ULL, 0x000fe2000ff9e0ffULL, 0x0000004e01007387ULL, 0x0007e20000100800ULL,
0x000000161b1a7c11ULL, 0x000fe2000f8448ffULL, 0x000000ffff237224ULL, 0x000fe200018e06ffULL,
0x0000001a19197c10ULL, 0x000fe2000ffbe0ffULL, 0x000000ffff207224ULL, 0x000fe200020e06ffULL,
0x0000000d53007c0cULL, 0x000fe2000bf26070ULL, 0x000000104b1e7825ULL, 0x010fe200078e0008ULL,
0x000000171b1b7c11ULL, 0x000fc400090f4c22ULL, 0x000000161d1c7c11ULL, 0x000fe2000f8648ffULL,
0x000000ffff217224ULL, 0x000fe200028e06ffULL, 0x0000000d52007c0cULL, 0x000fe2000bf46070ULL,
0x000000104b247825ULL, 0x002fe200078e000eULL, 0x0000001617167c11ULL, 0x000fe4000f8848ffULL,
0x0000001619187c11ULL, 0x000fe4000f8a48ffULL, 0x000000171d1d7c11ULL, 0x000fe200098f4c23ULL,
0x000000001e547faeULL, 0x0003e2000c901c4eULL, 0x0000001717177c11ULL, 0x000fe2000a0f4c20ULL,
0x000000104b227825ULL, 0x000fe200078e000cULL, 0x0000000d51007c0cULL, 0x000fc4000bf66070ULL,
0x0000001719197c11ULL, 0x000fe2000a8f4c21ULL, 0x000000104b207825ULL, 0x000fe200078e000aULL,
0x0000000d50007c0cULL, 0x000fe4000bf86070ULL, 0x0000000d27007c0cULL, 0x000fe4000bfa6070ULL,
0x00000000204f7faeULL, 0x0009e2000d101c4eULL, 0x00000008561f7c36ULL, 0x002fe20008000000ULL,
0x0000000d26007c0cULL, 0x000fe2000bf46070ULL, 0x000000384c547836ULL, 0x004fe20000000000ULL,
0x0000000c62797c11ULL, 0x000fe2000f8e20ffULL, 0x00000000224e7faeULL, 0x0003e2000d901c4eULL,
0x0000001a1f1f7c10ULL, 0x000fe2000ff3e0ffULL, 0x00000001545c7824ULL, 0x000fe200078e024dULL,
0x0000000d05007c0cULL, 0x000fe2000bf66070ULL, 0x00000000247d7faeULL, 0x0005e2000e101c4eULL,
0x0000000d04007c0cULL, 0x000fe2000bf86070ULL, 0x000000104b207825ULL, 0x010fc400078e0012ULL,
0x00000000487c7faeULL, 0x0009e4000e901c4eULL, 0x000000104b227825ULL, 0x042fe400078e0014ULL,
0x00000000207b7faeULL, 0x0003e2000d101c4eULL, 0x0000000d58007c0cULL, 0x000fe2000bf46070ULL,
0x000000104b247825ULL, 0x004fe400078e0016ULL, 0x00000000227a7faeULL, 0x0005e2000d901c4eULL,
0x0000000d57007c0cULL, 0x000fe2000bf66070ULL, 0x000000ffff487224ULL, 0x010fe200008e06ffULL,
0x000000161f1e7c11ULL, 0x000fe2000f8248ffULL, 0x0000000024797faeULL, 0x000fe2000e101c4eULL,
0x0000000d56007c0cULL, 0x000fc4000bf86070ULL, 0x000000171f1f7c11ULL, 0x000fe200088f4c48ULL,
0x000000104b207825ULL, 0x002fe200078e001aULL, 0x0000000d59007c0cULL, 0x000fc6000bf26070ULL,
0x000000104b227825ULL, 0x004fd400078e0018ULL, 0x0000000022787faeULL, 0x0003e8000c901c4eULL,
0x0000000020777faeULL, 0x0005e2000d101c4eULL, 0x000000104b227825ULL, 0x002fc800078e001cULL,
0x000000104b207825ULL, 0x004fe200078e001eULL, 0x0000000022767faeULL, 0x0003e8000d901c4eULL,
0x0000000020757faeULL, 0x0005e2000e101c4eULL, 0x0000000854237c36ULL, 0x002fe40008000000ULL,
0x0000000855207824ULL, 0x004fc600078e00ffULL, 0x0000001a23237c10ULL, 0x000fe2000ff5e0ffULL,
0x0000000855217c36ULL, 0x000fe20008000000ULL, 0xfffffff8205d7812ULL, 0x000fe200078ee25dULL,
0x0000000854207824ULL, 0x000fc600078e00ffULL, 0x0000001a21217c10ULL, 0x000fe2000ff3e0ffULL,
0x000000ffff247224ULL, 0x000fe200010e06ffULL, 0x0000000c5d747c11ULL, 0x000fe4000f8e20ffULL,
0xfffffff8205c7812ULL, 0x000fe200078ee25cULL, 0x000000ffff227224ULL, 0x000fe200008e06ffULL,
0x0000001621207c11ULL, 0x040fe4000f8248ffULL, 0x0000000c5c737c11ULL, 0x000fe4000f8e20ffULL,
0x0000001721217c11ULL, 0x000fc400088f4c22ULL, 0x0000000d55007c0cULL, 0x000fe4000bf26070ULL,
0x0000001623227c11ULL, 0x000fc8000f8448ffULL, 0x0000001723237c11ULL, 0x000fe200090f4c24ULL,
0x000000104b247825ULL, 0x000fe200078e0020ULL, 0x0000000d54007c0cULL, 0x000fca000bf46070ULL,
0x0000000024747faeULL, 0x0003e4000c901c4eULL, 0x000000104b247825ULL, 0x002fcc00078e0022ULL,
0x0000000024737faeULL, 0x0003e4000d101c4eULL, 0x000000085a257c36ULL, 0x002fca0008000000ULL,
0x0000001a25257c10ULL, 0x000fca000ff3e0ffULL, 0x000000ffff487224ULL, 0x000fe200008e06ffULL,
0x0000001625247c11ULL, 0x000fc8000f8248ffULL, 0x0000001725257c11ULL, 0x000fe200088f4c48ULL,
0x000000085a487824ULL, 0x040fe200078e00ffULL, 0x0000000d5a007c0cULL, 0x000fc8000bf26070ULL,
0xfffffff8485b7812ULL, 0x000fe200078ee25bULL, 0x000000104b487825ULL, 0x000fc600078e0024ULL,
0x0000000c5b717c11ULL, 0x000fca000f8e20ffULL, 0x0000000048717faeULL, 0x0007e2000c901c4eULL,
0x0000000c00187947ULL, 0x000fea0003800000ULL, 0x000000014c057824ULL, 0x100fe200078e024dULL,
0x00000010004b7812ULL, 0x000fe200078efcffULL, 0x0000000c4c517836ULL, 0x000fe40000000000ULL,
0x000000084c527836ULL, 0x000fe20000000000ULL, 0x0000000768687812ULL, 0x000fe200078ef805ULL,
0x00000001516a7824ULL, 0x140fe400078e024dULL, 0x0000000851057824ULL, 0x000fe200078e00ffULL,
0x0000000c68227c11ULL, 0x000fe2000f8e20ffULL, 0x00000001526c7824ULL, 0x000fc400078e024dULL,
0x0000000852077824ULL, 0x000fe200078e00ffULL, 0xfffffff8056a7812ULL, 0x000fe200078ee26aULL,
0x000000144c277836ULL, 0x000fe20000000000ULL, 0x00000c2201007387ULL, 0x0003e20000100800ULL,
0x0000001c4c057836ULL, 0x000fe20000000000ULL, 0xfffffff8076c7812ULL, 0x000fe200078ee26cULL,
0x000000044c537836ULL, 0x000fe20000000000ULL, 0x0000000c6a487c11ULL, 0x000fe2000f8e20ffULL,
0x0000000127667824ULL, 0x040fe200078e024dULL, 0x0000000c6c497c11ULL, 0x000fe2000f8e20ffULL,
0x0000000827077824ULL, 0x000fc400078e00ffULL, 0x0000000105637824ULL, 0x140fe400078e024dULL,
0x0000000805067824ULL, 0x000fe200078e00ffULL, 0xfffffff807667812ULL, 0x000fe200078ee266ULL,
0x00000001536b7824ULL, 0x140fe400078e024dULL, 0x0000000853047824ULL, 0x000fe200078e00ffULL,
0xfffffff806637812ULL, 0x000fe200078ee263ULL, 0x000000184c267836ULL, 0x000fe20000000000ULL,
0x0000000c667c7c11ULL, 0x000fe2000f8e20ffULL, 0x000000244c597836ULL, 0x000fe20000000000ULL,
0xfffffff8046b7812ULL, 0x000fe200078ee26bULL, 0x000000104c507836ULL, 0x000fe20000000000ULL,
0x0000000c637a7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000126647824ULL, 0x040fe200078e024dULL,
0x0000000c6b4e7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000826077824ULL, 0x000fc400078e00ffULL,
0x0000000159617824ULL, 0x140fe400078e024dULL, 0x0000000859067824ULL, 0x000fe200078e00ffULL,
0xfffffff807647812ULL, 0x000fe200078ee264ULL, 0x0000000150677824ULL, 0x140fe200078e024dULL,
0x0000084e01007387ULL, 0x000fe20000100800ULL, 0x0000000850047824ULL, 0x000fe200078e00ffULL,
0xfffffff806617812ULL, 0x000fe200078ee261ULL, 0x000000284c587836ULL, 0x000fe20000000000ULL,
0x0000000c647b7c11ULL, 0x000fe2000f8e20ffULL, 0x0000002c4c577836ULL, 0x000fe20000000000ULL,
0xfffffff804677812ULL, 0x000fe200078ee267ULL, 0x0000000158607824ULL, 0x140fe200078e024dULL,
0x0000000c61787c11ULL, 0x000fe2000f8e20ffULL, 0x0000000858077824ULL, 0x000fe200078e00ffULL,
0x0000000c677d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000084c067c36ULL, 0x000fe20008000000ULL,
0x0000044901007387ULL, 0x000fe20000100800ULL, 0x000000204c047836ULL, 0x000fe20000000000ULL,
0xfffffff807607812ULL, 0x000fe200078ee260ULL, 0x00000001575f7824ULL, 0x140fe200078e024dULL,
0x0000001a06077c10ULL, 0x000fe2000ff3e0ffULL, 0x0000000857087824ULL, 0x000fe200078e00ffULL,
0x0000000c60777c11ULL, 0x000fe2000f8e20ffULL, 0x0000000104627824ULL, 0x040fe200078e024dULL,
0x0000004801007387ULL, 0x0005e20000100800ULL, 0x0000000804097824ULL, 0x000fe200078e00ffULL,
0xfffffff8085f7812ULL, 0x000fe200078ee25fULL, 0x0000000853067c36ULL, 0x000fc40008000000ULL,
0x0000000852087c36ULL, 0x000fe20008000000ULL, 0xfffffff809627812ULL, 0x000fe200078ee262ULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x0000001a06097c10ULL, 0x000fe2000ff5e0ffULL,
0x000000304c567836ULL, 0x000fe20000000000ULL, 0x0000001a080b7c10ULL, 0x000fe2000ff7e0ffULL,
0x0000000826127c36ULL, 0x000fe20008000000ULL, 0x0000001607067c11ULL, 0x000fe2000f8248ffULL,
0x000000ffff0e7224ULL, 0x000fe200010e06ffULL, 0x0000001609087c11ULL, 0x000fe2000f8448ffULL,
0x000000ffff107224ULL, 0x000fe200018e06ffULL, 0x000000160b0a7c11ULL, 0x000fe2000f8648ffULL,
0x00000001565e7824ULL, 0x040fe200078e024dULL, 0x0000001707077c11ULL, 0x000fe200088f4c0cULL,
0x00000008560d7824ULL, 0x000fe200078e00ffULL, 0x0000001709097c11ULL, 0x000fe200090f4c0eULL,
0x00000008510c7c36ULL, 0x000fe20008000000ULL, 0x000000170b0b7c11ULL, 0x000fe200098f4c10ULL,
0x00000008500e7c36ULL, 0x000fe20008000000ULL, 0xfffffff80d5e7812ULL, 0x000fe200078ee25eULL,
0x0000000827107c36ULL, 0x000fe20008000000ULL, 0x0000001a0c0d7c10ULL, 0x000fe2000ff5e0ffULL,
0x0000000805157c36ULL, 0x000fe20008000000ULL, 0x0000001a0e0f7c10ULL, 0x000fe2000ff7e0ffULL,
0x0000000804177c36ULL, 0x000fe20008000000ULL, 0x0000001a10117c10ULL, 0x000fe2000ff9e0ffULL,
0x000000ffff147224ULL, 0x000fe200010e06ffULL, 0x0000001a12137c10ULL, 0x000fe2000ff3e0ffULL,
0x000000ffff167224ULL, 0x000fe200018e06ffULL, 0x000000160d0c7c11ULL, 0x000fe2000f8448ffULL,
0x000000ffff187224ULL, 0x000fe200020e06ffULL, 0x000000160f0e7c11ULL, 0x000fe2000f8648ffULL,
0x000000ffff1a7224ULL, 0x000fe200008e06ffULL, 0x0000001611107c11ULL, 0x000fe2000f8848ffULL,
0x0000000859197c36ULL, 0x000fe20008000000ULL, 0x0000001613127c11ULL, 0x000fe2000f8248ffULL,
0x00000008581b7c36ULL, 0x000fe20008000000ULL, 0x000000170d0d7c11ULL, 0x000fe200090f4c14ULL,
0x000000104b1c7825ULL, 0x000fe200078e0006ULL, 0x000000170f0f7c11ULL, 0x000fc400098f4c16ULL,
0x0000001711117c11ULL, 0x000fe2000a0f4c18ULL, 0x000000344c557836ULL, 0x000fe20000000000ULL,
0x0000001713137c11ULL, 0x000fe200088f4c1aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c227faeULL, 0x0007e2000b901c4eULL, 0x0000001a15157c10ULL, 0x000fe2000ff5e0ffULL,
0x000000104b247825ULL, 0x000fe200078e0010ULL, 0x0000001a17177c10ULL, 0x000fe4000ff7e0ffULL,
0x0000001a19197c10ULL, 0x000fe2000ff9e0ffULL, 0x000000ffff1e7224ULL, 0x000fe200010e06ffULL,
0x0000001a1b1b7c10ULL, 0x000fe2000ff3e0ffULL, 0x000000ffff1f7224ULL, 0x000fe200018e06ffULL,
0x0000001615147c11ULL, 0x000fe2000f8448ffULL, 0x000000ffff207224ULL, 0x000fe200020e06ffULL,
0x0000001617167c11ULL, 0x000fe2000f8648ffULL, 0x000000ffff217224ULL, 0x000fe200008e06ffULL,
0x0000001619187c11ULL, 0x000fe2000f8848ffULL, 0x000000104b1c7825ULL, 0x008fe200078e0008ULL,
0x000000161b1a7c11ULL, 0x000fc4000f8248ffULL, 0x0000001715157c11ULL, 0x000fe200090f4c1eULL,
0x000000104b227825ULL, 0x002fe200078e000eULL, 0x0000001717177c11ULL, 0x000fe200098f4c1fULL,
0x000000001c4e7faeULL, 0x0003e2000b901c4eULL, 0x0000001719197c11ULL, 0x000fe2000a0f4c20ULL,
0x000000104b1e7825ULL, 0x000fe200078e000aULL, 0x000000171b1b7c11ULL, 0x000fe400088f4c21ULL,
0x0000000c62797c11ULL, 0x000fe2000f8e20ffULL, 0x000000104b207825ULL, 0x000fe200078e000cULL,
0x000000001e497faeULL, 0x0007e2000b901c4eULL, 0x0000000c5f767c11ULL, 0x000fc4000f8e20ffULL,
0x0000000c5e757c11ULL, 0x000fe2000f8e20ffULL, 0x0000000020487faeULL, 0x0009e2000b901c4eULL,
0x000000104b1c7825ULL, 0x002fc600078e0012ULL, 0x00000000227d7faeULL, 0x0003e2000b901c4eULL,
0x00000001555d7824ULL, 0x000fe400078e024dULL, 0x000000384c547836ULL, 0x000fe20000000000ULL,
0x00000000247c7faeULL, 0x000fe2000b901c4eULL, 0x000000104b1e7825ULL, 0x008fc600078e0014ULL,
0x000000001c7b7faeULL, 0x0007e2000b901c4eULL, 0x000000104b207825ULL, 0x010fc600078e0016ULL,
0x000000001e7a7faeULL, 0x0009e2000b901c4eULL, 0x0000000857237c36ULL, 0x002fe40008000000ULL,
0x0000000856227c36ULL, 0x000fe20008000000ULL, 0x0000000020797faeULL, 0x0003e2000b901c4eULL,
0x0000003c4c5a7836ULL, 0x000fe40000000000ULL, 0x00000001545c7824ULL, 0x100fe200078e024dULL,
0x0000001a231d7c10ULL, 0x008fe2000ff3e0ffULL, 0x000000015a5b7824ULL, 0x000fe200078e024dULL,
0x0000001a221f7c10ULL, 0x010fc6000ff5e0ffULL, 0x000000ffff247224ULL, 0x000fe200008e06ffULL,
0x000000161d1c7c11ULL, 0x000fe2000f8248ffULL, 0x000000104b227825ULL, 0x000fc600078e001aULL,
0x000000171d1d7c11ULL, 0x000fe200088f4c24ULL, 0x000000104b207825ULL, 0x002fc800078e0018ULL,
0x000000ffff257224ULL, 0x000fe200010e06ffULL, 0x0000000020787faeULL, 0x0003e2000b901c4eULL,
0x000000161f1e7c11ULL, 0x000fc6000f8448ffULL, 0x0000000022777faeULL, 0x0007e2000b901c4eULL,
0x000000171f1f7c11ULL, 0x000fe200090f4c25ULL, 0x000000085a257c36ULL, 0x000fca0008000000ULL,
0x0000001a25257c10ULL, 0x000fe2000ff5e0ffULL, 0x000000104b207825ULL, 0x002fc800078e001cULL,
0x000000104b227825ULL, 0x008fe200078e001eULL, 0x0000000020767faeULL, 0x0003e6000b901c4eULL,
0x000000ffff487224ULL, 0x004fe200010e06ffULL, 0x0000000022757faeULL, 0x0005e2000b901c4eULL,
0x0000000855217c36ULL, 0x002fe40008000000ULL, 0x0000000855207824ULL, 0x000fe400078e00ffULL,
0x0000000854237c36ULL, 0x004fe20008000000ULL, 0x0000001a21217c10ULL, 0x000fc4000ff3e0ffULL,
0xfffffff8205d7812ULL, 0x000fc600078ee25dULL, 0x000000ffff227224ULL, 0x000fe200008e06ffULL,
0x0000001621207c11ULL, 0x000fe4000f8248ffULL, 0x0000000c5d747c11ULL, 0x000fe4000f8e20ffULL,
0x0000001721217c11ULL, 0x000fe400088f4c22ULL, 0x0000001a23237c10ULL, 0x000fca000ff3e0ffULL,
0x000000ffff247224ULL, 0x000fe200008e06ffULL, 0x0000001623227c11ULL, 0x000fc8000f8248ffULL,
0x0000001723237c11ULL, 0x000fe400088f4c24ULL, 0x0000001625247c11ULL, 0x000fc8000f8248ffULL,
0x0000001725257c11ULL, 0x000fe200088f4c48ULL, 0x000000104b487825ULL, 0x000fca00078e0020ULL,
0x0000000048747faeULL, 0x0003e4000b901c4eULL, 0x0000000854487824ULL, 0x002fca00078e00ffULL,
0xfffffff8485c7812ULL, 0x000fe200078ee25cULL, 0x000000104b487825ULL, 0x000fc600078e0022ULL,
0x0000000c5c737c11ULL, 0x000fca000f8e20ffULL, 0x0000000048737faeULL, 0x0003e4000b901c4eULL,
0x000000085a487824ULL, 0x002fca00078e00ffULL, 0xfffffff8485b7812ULL, 0x000fe200078ee25bULL,
0x000000104b487825ULL, 0x000fc600078e0024ULL, 0x0000000c5b717c11ULL, 0x000fca000f8e20ffULL,
0x0000000048717faeULL, 0x0003e4000b901c4eULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000803487836ULL, 0x00afe20000000000ULL, 0x000000154a4c7c11ULL, 0x000fe2000f8e20ffULL,
0x0000002002497824ULL, 0x000fe200078e00ffULL, 0x0000001569697c11ULL, 0x000fe4000f8e20ffULL,
0x0000001565657c11ULL, 0x000fe2000f8e20ffULL, 0x0000584c01007387ULL, 0x000fe20000100800ULL,
0xffffffe049487812ULL, 0x000fc600078ee248ULL, 0x0000506901007387ULL, 0x000fe20000100800ULL,
0x0000000448487c11ULL, 0x000fc6000f8e20ffULL, 0x0000486501007387ULL, 0x000fe20000100800ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000004848783bULL, 0x000fe80000000200ULL,
0x000000004c4c783bULL, 0x000e640000000200ULL, 0x0000004c4840723cULL, 0x002fec0000041840ULL,
0x0000004e483c723cULL, 0x000fe2000004183cULL, 0x00000000694c783bULL, 0x000e6a0000000200ULL,
0x0000004c4828723cULL, 0x002fec0000041828ULL, 0x0000004e482c723cULL, 0x000fe2000004182cULL,
0x00000000654c783bULL, 0x0002a40000000200ULL, 0x000000156d657c11ULL, 0x002fca000f8e20ffULL,
0x0000406501007387ULL, 0x000fe80000100800ULL, 0x0000100001697983ULL, 0x000ee20000300800ULL,
0x0000004c4830723cULL, 0x004fec0000041830ULL, 0x0000004e4834723cULL, 0x000fe20000041834ULL,
0x00000000654c783bULL, 0x0002a40000000200ULL, 0x000000156e657c11ULL, 0x002fc6000f8e20ffULL,
0x0000004c4838723cULL, 0x004fec0000041838ULL, 0x0000004e4844723cULL, 0x000fe20000041844ULL,
0x00000000654c783bULL, 0x000fec0000000200ULL, 0x0000000a03487836ULL, 0x000fc40000000000ULL,
0x0000002002497824ULL, 0x000fca00078e00ffULL, 0xffffffe049487812ULL, 0x000fc800078ee248ULL,
0x0000000448487c11ULL, 0x000fcc000f8e20ffULL, 0x000000004848783bULL, 0x000e680000000200ULL,
0x00003c6501007387ULL, 0x0005e40000100800ULL, 0x000000156f657c11ULL, 0x004fe2000f8e20ffULL,
0x0000004c4840723cULL, 0x002fec0000041840ULL, 0x0000004e483c723cULL, 0x000fe2000004183cULL,
0x00000000654c783bULL, 0x000e680000000200ULL, 0x0000386501007387ULL, 0x0005e80000100800ULL,
0x00001c00016f7983ULL, 0x000f220000300800ULL, 0x0000001570657c11ULL, 0x004fc6000f8e20ffULL,
0x0000180001707983ULL, 0x000ea80000300800ULL, 0x0000346501007387ULL, 0x000fe20000100800ULL,
0x0000004c4828723cULL, 0x002fec0000041828ULL, 0x0000004e482c723cULL, 0x000fe2000004182cULL,
0x00000000654c783bULL, 0x0003640000000200ULL, 0x0000001572657c11ULL, 0x002fc4000f8e20ffULL,
0x0000140001727983ULL, 0x000f280000300800ULL, 0x00002c6501007387ULL, 0x000fe80000100800ULL,
0x00002000016e7983ULL, 0x000f280000300800ULL, 0x00002400016d7983ULL, 0x000f220000300800ULL,
0x0000004c4830723cULL, 0x020fec0000041830ULL, 0x0000004e4834723cULL, 0x000fe20000041834ULL,
0x00000000654c783bULL, 0x0006640000000200ULL, 0x0000001569657c11ULL, 0x008fc4000f8e20ffULL,
0x0000280001697983ULL, 0x000ee20000300800ULL, 0x0000004c4838723cULL, 0x002fec0000041838ULL,
0x0000004e4848723cULL, 0x000fee0000041844ULL, 0x0000000c03447836ULL, 0x000fc40000000000ULL,
0x0000002002457824ULL, 0x000fca00078e00ffULL, 0xffffffe045447812ULL, 0x000fc800078ee244ULL,
0x00000004444c7c11ULL, 0x000fe2000f8e20ffULL, 0x0000106501007387ULL, 0x000fe80000100800ULL,
0x000000006544783bULL, 0x0003e80000000200ULL, 0x000000004c4c783bULL, 0x000f680000000200ULL,
0x0000300001657983ULL, 0x002ee20000300800ULL, 0x000000444c40723cULL, 0x020fec0000041840ULL,
0x000000464c44723cULL, 0x000fe2000004183cULL, 0x0000001570707c11ULL, 0x004fc4000f8e20ffULL,
0x0000001572727c11ULL, 0x010fca000f8e20ffULL, 0x00000000723c783bULL, 0x000e620000000200ULL,
0x000000156f6f7c11ULL, 0x000fe2000f8e20ffULL, 0x0000003c4c28723cULL, 0x002fec0000041828ULL,
0x0000003e4c3c723cULL, 0x000fe2000004182cULL, 0x00000000702c783bULL, 0x000e6a0000000200ULL,
0x0000002c4c30723cULL, 0x002fec0000041830ULL, 0x0000002e4c34723cULL, 0x000fe20000041834ULL,
0x000000006f2c783bULL, 0x000e620000000200ULL, 0x000000156e6e7c11ULL, 0x000fc8000f8e20ffULL,
0x0000002c4c38723cULL, 0x002fee0000041838ULL, 0x0000000e032c7836ULL, 0x000fe40000000000ULL,
0x00000020022d7824ULL, 0x000fe200078e00ffULL, 0x0000002e4c48723cULL, 0x000fe80000041848ULL,
0xffffffe02d2c7812ULL, 0x000fc800078ee22cULL, 0x000000042c4c7c11ULL, 0x000fe4000f8e20ffULL,
0x000000006e2c783bULL, 0x000fe80000000200ULL, 0x000000004c4c783bULL, 0x000e620000000200ULL,
0x000000156d6d7c11ULL, 0x000fe4000f8e20ffULL, 0x0000001569697c11ULL, 0x008fe2000f8e20ffULL,
0x0000002c4c40723cULL, 0x002fec0000041840ULL, 0x0000002e4c44723cULL, 0x000fe20000041844ULL,
0x000000006d2c783bULL, 0x000e620000000200ULL, 0x0000001565657c11ULL, 0x000fc8000f8e20ffULL,
0x0000002c4c28723cULL, 0x002fec0000041828ULL, 0x0000002e4c3c723cULL, 0x000fe2000004183cULL,
0x00000000692c783bULL, 0x000e6a0000000200ULL, 0x0000002c4c30723cULL, 0x002fec0000041830ULL,
0x0000002e4c34723cULL, 0x000fe20000041834ULL, 0x00000000652c783bULL, 0x000e6a0000000200ULL,
0x0000002c4c38723cULL, 0x002fec0000041838ULL, 0x0000002e4c48723cULL, 0x000fe20000041848ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000400208947ULL, 0x000fde0003800000ULL,
0x00000000002d7919ULL, 0x000e620000000000ULL, 0x8000001314087290ULL, 0x000fe2000fffe03fULL,
0x00000018002c7812ULL, 0x000fe400078efcffULL, 0x0000001568687c11ULL, 0x000fe4000f8e20ffULL,
0x000000156b6b7c11ULL, 0x000fe2000f8e20ffULL, 0x000000102c067825ULL, 0x000fe200078e0006ULL,
0x000000156c6c7c11ULL, 0x000fe4000f8e20ffULL, 0x000000156a6a7c11ULL, 0x000fe2000f8e20ffULL,
0x000000102c087825ULL, 0x000fe200078e0008ULL, 0x0000001567677c11ULL, 0x000fc4000f8e20ffULL,
0x0000000827007c0cULL, 0x000fe2000bf26070ULL, 0x000000102c0a7825ULL, 0x000fe200078e000aULL,
0x0000000805007c0cULL, 0x000fe4000bf46070ULL, 0x0000000804007c0cULL, 0x000fe2000bf66070ULL,
0x000000102c0c7825ULL, 0x000fe200078e000cULL, 0x0000001566667c11ULL, 0x000fe4000f8e20ffULL,
0x0000001564647c11ULL, 0x000fe2000f8e20ffULL, 0x000000102c0e7825ULL, 0x000fe200078e000eULL,
0x0000001563637c11ULL, 0x000fc4000f8e20ffULL, 0x0000001562627c11ULL, 0x000fe2000f8e20ffULL,
0x000000102c107825ULL, 0x000fe200078e0010ULL, 0x0000000855007c0cULL, 0x000fe4000bf86070ULL,
0x0000000854007c0cULL, 0x000fe2000bfa6070ULL, 0x000000102c127825ULL, 0x000fe200078e0012ULL,
0x00000003ff2d7819ULL, 0x002fe4000001162dULL, 0x000000085a007c0cULL, 0x000fe2000bfc6070ULL,
0x000000102c147825ULL, 0x000fe200078e0014ULL, 0x000000082d007c0cULL, 0x000fc4000bf06070ULL,
0x0000001561617c11ULL, 0x000fe2000f8e20ffULL, 0x000000102c167825ULL, 0x000fe200078e0016ULL,
0x0000001560607c11ULL, 0x000fe4000f8e20ffULL, 0x000000155f5f7c11ULL, 0x000fe2000f8e20ffULL,
0x000000102c187825ULL, 0x040fe200078e0018ULL, 0x000000155d5d7c11ULL, 0x000fe4000f8e20ffULL,
0x000000155b5b7c11ULL, 0x000fe2000f8e20ffULL, 0x000000102c1a7825ULL, 0x040fe400078e001aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006687faeULL, 0x0003e2000c101c4eULL,
0x0000000853007c0cULL, 0x000fe2000bf06070ULL, 0x000000102c1c7825ULL, 0x000fc800078e001cULL,
0x000000102c1e7825ULL, 0x000fc800078e001eULL, 0x000000102c207825ULL, 0x000fe200078e0020ULL,
0x000000155e077c11ULL, 0x002fc6000f8e20ffULL, 0x00000000086b7faeULL, 0x0003e2000c101c4eULL,
0x0000000852007c0cULL, 0x000fe2000bf06070ULL, 0x000000102c227825ULL, 0x000fc800078e0022ULL,
0x000000102c247825ULL, 0x000fe200078e0024ULL, 0x000000155c097c11ULL, 0x002fce000f8e20ffULL,
0x000000000a6c7faeULL, 0x0003e2000c101c4eULL, 0x0000000851007c0cULL, 0x000fda000bf06070ULL,
0x000000000c6a7faeULL, 0x0003e2000c101c4eULL, 0x0000000850007c0cULL, 0x000fda000bf06070ULL,
0x000000000e677faeULL, 0x0003e2000c101c4eULL, 0x0000000826007c0cULL, 0x000fc6000bf06070ULL,
0x0000000010667faeULL, 0x0003e2000c901c4eULL, 0x0000000858007c0cULL, 0x000fd2000bf26070ULL,
0x0000000012647faeULL, 0x0003e2000c101c4eULL, 0x0000000859007c0cULL, 0x000fc6000bf06070ULL,
0x0000000014637faeULL, 0x0003e2000d101c4eULL, 0x0000000857007c0cULL, 0x000fc6000bf46070ULL,
0x0000000016627faeULL, 0x0003e2000d901c4eULL, 0x0000000856007c0cULL, 0x000fca000bf66070ULL,
0x0000000018617faeULL, 0x0003e8000c101c4eULL, 0x000000001a607faeULL, 0x0003e8000c901c4eULL,
0x000000001c5f7faeULL, 0x0003e8000d101c4eULL, 0x000000001e077faeULL, 0x0003e8000d901c4eULL,
0x00000000205d7faeULL, 0x0003e8000e101c4eULL, 0x0000000022097faeULL, 0x0003e8000e901c4eULL,
0x00000000245b7faeULL, 0x0003e2000f101c4eULL, 0x0000000000d07947ULL, 0x000fea0003800000ULL,
0x00000018002c7812ULL, 0x000fe400078efcffULL, 0x0000001568687c11ULL, 0x000fe4000f8e20ffULL,
0x000000156b6b7c11ULL, 0x000fe2000f8e20ffULL, 0x000000102c067825ULL, 0x000fe200078e0006ULL,
0x000000156c6c7c11ULL, 0x000fe4000f8e20ffULL, 0x000000156a6a7c11ULL, 0x000fe2000f8e20ffULL,
0x000000102c087825ULL, 0x000fe200078e0008ULL, 0x0000001567677c11ULL, 0x000fe2000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006687faeULL, 0x0003e2000b901c4eULL,
0x0000001566667c11ULL, 0x000fe2000f8e20ffULL, 0x000000102c0a7825ULL, 0x000fe200078e000aULL,
0x0000001564647c11ULL, 0x000fe2000f8e20ffULL, 0x00000000086b7faeULL, 0x0005e2000b901c4eULL,
0x0000001563637c11ULL, 0x000fe2000f8e20ffULL, 0x000000102c0c7825ULL, 0x000fe200078e000cULL,
0x0000001562627c11ULL, 0x000fe2000f8e20ffULL, 0x000000000a6c7faeULL, 0x0007e2000b901c4eULL,
0x0000001561617c11ULL, 0x000fe2000f8e20ffULL, 0x000000102c0e7825ULL, 0x000fe200078e000eULL,
0x0000001560607c11ULL, 0x000fe2000f8e20ffULL, 0x000000000c6a7faeULL, 0x0007e2000b901c4eULL,
0x000000155f5f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000102c107825ULL, 0x000fe200078e0010ULL,
0x000000155e077c11ULL, 0x002fe2000f8e20ffULL, 0x000000000e677faeULL, 0x0007e2000b901c4eULL,
0x000000155d5d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000102c127825ULL, 0x000fe200078e0012ULL,
0x000000155c097c11ULL, 0x004fe2000f8e20ffULL, 0x0000000010667faeULL, 0x0007e2000b901c4eULL,
0x000000155b5b7c11ULL, 0x000fe2000f8e20ffULL, 0x000000102c147825ULL, 0x000fc400078e0014ULL,
0x0000000012647faeULL, 0x0007e4000b901c4eULL, 0x000000102c167825ULL, 0x040fe400078e0016ULL,
0x0000000014637faeULL, 0x0007e4000b901c4eULL, 0x000000102c187825ULL, 0x040fe400078e0018ULL,
0x0000000016627faeULL, 0x0007e4000b901c4eULL, 0x000000102c1a7825ULL, 0x000fc400078e001aULL,
0x0000000018617faeULL, 0x0007e4000b901c4eULL, 0x000000102c1c7825ULL, 0x040fe400078e001cULL,
0x000000001a607faeULL, 0x0007e4000b901c4eULL, 0x000000102c1e7825ULL, 0x040fe400078e001eULL,
0x000000001c5f7faeULL, 0x0007e4000b901c4eULL, 0x000000102c207825ULL, 0x000fc400078e0020ULL,
0x000000001e077faeULL, 0x0007e4000b901c4eULL, 0x000000102c227825ULL, 0x040fe400078e0022ULL,
0x00000000205d7faeULL, 0x0007e4000b901c4eULL, 0x000000102c247825ULL, 0x000fe400078e0024ULL,
0x0000000022097faeULL, 0x0007e8000b901c4eULL, 0x00000000245b7faeULL, 0x0007e4000b901c4eULL,
0x00004400010b7983ULL, 0x00aea80000300800ULL, 0x00004c00010a7983ULL, 0x000ee80000300800ULL,
0x0000540001137983ULL, 0x000f280000300800ULL, 0x00005c0001127983ULL, 0x000f680000300800ULL,
0x00006000011c7983ULL, 0x000ea80000300800ULL, 0x0000780001247983ULL, 0x000ee20000300800ULL,
0x0000000910097291ULL, 0x000fc6000f8e083fULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000060900728cULL, 0x000fc6000bf06070ULL, 0x0000700001237983ULL, 0x000ee20000300800ULL,
0x0000001003087836ULL, 0x000fe40000000000ULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x0000002002097824ULL, 0x000fe200078e00ffULL, 0x00006c0001227983ULL, 0x000ee60000300800ULL,
0x0000000912088291ULL, 0x000fe2000f8e083fULL, 0x00008c00000c8ab9ULL, 0x000fe20000000a00ULL,
0xffffffe009087812ULL, 0x000fc400078ee208ULL, 0x00000004080c88a5ULL, 0x000fe2000f8e000cULL,
0x0000001203107836ULL, 0x000fe20000000000ULL, 0x0000640001217983ULL, 0x000ee20000300800ULL,
0x00000004080c7c11ULL, 0x000fe2000f8e20ffULL, 0x0000002002117824ULL, 0x000fe400078e00ffULL,
0x0000000cff067e24ULL, 0x000fe2000f8e00ffULL, 0x0000680001207983ULL, 0x000ee20000300800ULL,
0x0000000dff077e24ULL, 0x000fe2000f8e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000e06068981ULL, 0x0002e8000c1e1900ULL, 0x000000000c0c783bULL, 0x000fe80000000200ULL,
0x00007400012f7983ULL, 0x000ee20000300800ULL, 0xffffffe011077812ULL, 0x002fc600078ee210ULL,
0x00007c00012e7983ULL, 0x000ee80000300800ULL, 0x00008400012d7983ULL, 0x000ee80000300800ULL,
0x00008000012c7983ULL, 0x000ee80000300800ULL, 0x0000880001257983ULL, 0x000ee80000300800ULL,
0x000000001314783bULL, 0x010fe80000000200ULL, 0x000000001210783bULL, 0x020e680000000200ULL,
0x000000000b18783bULL, 0x004ea80000000200ULL, 0x000000000a08783bULL, 0x008ee80000000200ULL,
0x000000001c1c783bULL, 0x000fe20000000200ULL, 0x000000100c38723cULL, 0x002fec0000041838ULL,
0x000000120c48723cULL, 0x000fe20000041848ULL, 0x000000002410783bULL, 0x0003e80000000200ULL,
0x00008c0001247983ULL, 0x002f680000300800ULL, 0x00000c00014f7983ULL, 0x0003280000100800ULL,
0x00000800014e7983ULL, 0x0003280000100800ULL, 0x00000400014d7983ULL, 0x0003280000100800ULL,
0x00000000014c7983ULL, 0x0003220000100800ULL, 0x0000000407077c11ULL, 0x000fe2000f8e20ffULL,
0x000000180c40723cULL, 0x004fec0000041840ULL, 0x0000001a0c44723cULL, 0x000fe20000041844ULL,
0x000000000718783bULL, 0x000eaa0000000200ULL, 0x000000080c28723cULL, 0x008fec0000041828ULL,
0x0000000a0c3c723cULL, 0x000fe2000004183cULL, 0x000000002208783bULL, 0x000fea0000000200ULL,
0x000000140c30723cULL, 0x000fec0000041830ULL, 0x000000160c34723cULL, 0x000fe20000041834ULL,
0x00000000230c783bULL, 0x000ee20000000200ULL, 0x0000001403147836ULL, 0x000fc40000000000ULL,
0x0000002002157824ULL, 0x000fca00078e00ffULL, 0xffffffe015147812ULL, 0x000fc800078ee214ULL,
0x0000000414147c11ULL, 0x000fe2000f8e20ffULL, 0x0000001c1840723cULL, 0x004fea0000041840ULL,
0x000000001414783bULL, 0x000fe20000000200ULL, 0x0000001e1844723cULL, 0x000fe60000041844ULL,
0x00000000211c783bULL, 0x000ea80000000200ULL, 0x000000002020783bULL, 0x000e620000000200ULL,
0x000000101828723cULL, 0x000fec0000041828ULL, 0x00000012183c723cULL, 0x000fe2000004183cULL,
0x000000002f10783bULL, 0x000e6a0000000200ULL, 0x0000000c1830723cULL, 0x008fec0000041830ULL,
0x0000000e1834723cULL, 0x000fe20000041834ULL, 0x000000002e0c783bULL, 0x000ee20000000200ULL,
0x0000001603077836ULL, 0x000fc80000000000ULL, 0x000000081838723cULL, 0x000fee0000041838ULL,
0x0000002002087824ULL, 0x000fe200078e00ffULL, 0x0000000a1848723cULL, 0x000fe20000041848ULL,
0x000000002c18783bULL, 0x000fe60000000200ULL, 0xffffffe008077812ULL, 0x000fc800078ee207ULL,
0x0000000407077c11ULL, 0x000fe2000f8e20ffULL, 0x0000001c1440723cULL, 0x004fe80000041840ULL,
0x000000000708783bULL, 0x000fe40000000200ULL, 0x0000001e1444723cULL, 0x000fe40000041844ULL,
0x000000002d1c783bULL, 0x000ea80000000200ULL, 0x000000201428723cULL, 0x002fe20000041828ULL,
0x00000000252c783bULL, 0x0002aa0000000200ULL, 0x00000022143c723cULL, 0x000fe2000004183cULL,
0x00000005100c7290ULL, 0x000fca000fffe03fULL, 0x000000101430723cULL, 0x000fe20000041830ULL,
0x000000010c157890ULL, 0x000fca000fffe03fULL, 0x000000121434723cULL, 0x000fec0000041834ULL,
0x0000000c1438723cULL, 0x008fec0000041838ULL, 0x0000000e1448723cULL, 0x000fe20000041848ULL,
0x000000071500728cULL, 0x000fe2000bf26070ULL, 0x0000000000257919ULL, 0x002e620000000000ULL,
0x00000000061a82caULL, 0x000fc800000e0000ULL, 0x000000000000781cULL, 0x000fe20003f0f018ULL,
0x000000180c0d7291ULL, 0x000fe2000f8e403fULL, 0xffffffff00197882ULL, 0x000fc60000000000ULL,
0x000000400d087892ULL, 0x000fe2000f8ec03fULL, 0x0000001c0840723cULL, 0x004fe60000041840ULL,
0x0000001a00198c82ULL, 0x000fe20008000000ULL, 0x000000080a157290ULL, 0x000fe4000fffe03fULL,
0x0000001e0844723cULL, 0x000fe20000041844ULL, 0x0000000b191a72a4ULL, 0x000fca000f8e023fULL,
0x000000180828723cULL, 0x000fec0000041828ULL, 0x0000001a083c723cULL, 0x000fec000004183cULL,
0x0000002c0830723cULL, 0x000fec0000041830ULL, 0x0000002e0834723cULL, 0x000fe20000041834ULL,
0x000000002420783bULL, 0x0204e40000000200ULL, 0x0000000000247919ULL, 0x004ea60000000000ULL,
0x000000200838723cULL, 0x008fe20000041838ULL, 0x00000003ff247819ULL, 0x004fca0000011624ULL,
0x000000220848723cULL, 0x000fe20000041848ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000800648947ULL, 0x002fde0003800000ULL, 0x0000001524067c36ULL, 0x000fe20008000000ULL,
0x0000000d1400728cULL, 0x000fe2000bf01070ULL, 0x0000001552077c36ULL, 0x000fe40008000000ULL,
0x00000010250c7824ULL, 0x000fe200078e00ffULL, 0x0000001a06107c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001553067c36ULL, 0x000fe20008000000ULL, 0x0000001a07077c10ULL, 0x000fe2000ff7e0ffULL,
0x0000000d14087287ULL, 0x000fe2000c000000ULL, 0x000000700c0c7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff097224ULL, 0x000fe200000e06ffULL, 0x0000001610117c11ULL, 0x040fe2000f8048ffULL,
0x000000ffff0a7224ULL, 0x000fe200018e06ffULL, 0x0000001a060e7c10ULL, 0x000fe2000ff3e0ffULL,
0x0000001551067c36ULL, 0x000fe20008000000ULL, 0x0000001710107c11ULL, 0x000fe200080f4c09ULL,
0x000000080d087290ULL, 0x000fe2000fffe13fULL, 0x000000160e0f7c11ULL, 0x000fe2000f8048ffULL,
0x000000ffff097224ULL, 0x000fe200008e06ffULL, 0x00000016070b7c11ULL, 0x000fe2000f8248ffULL,
0x0000001527087c36ULL, 0x000fc40008000000ULL, 0x0000000853007c0cULL, 0x000fe4000bf46070ULL,
0x000000170e0e7c11ULL, 0x000fe400080f4c09ULL, 0x0000001a06127c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001550067c36ULL, 0x000fe20008000000ULL, 0x00000017070a7c11ULL, 0x000fe400088f4c0aULL,
0x0000000824007c0cULL, 0x000fe2000bf26070ULL, 0x000000ffff077224ULL, 0x000fe200000e06ffULL,
0x00000016120d7c11ULL, 0x000fc4000f8048ffULL, 0x0000001a08147c10ULL, 0x000fe2000ffde0ffULL,
0x0000001526087c36ULL, 0x000fe20008000000ULL, 0x0000001712127c11ULL, 0x000fe400080f4c07ULL,
0x0000001a06167c10ULL, 0x000fe4000ff1e0ffULL, 0x000000110c067210ULL, 0x000fe40007f7e0ffULL,
0x0000000852007c0cULL, 0x000fe2000bfa6070ULL, 0x000000ffff097224ULL, 0x000fe200000e06ffULL,
0x0000001616197c11ULL, 0x000fe2000f8048ffULL, 0x000000ffff077224ULL, 0x000fe200018e0610ULL,
0x0000000851007c0cULL, 0x000fc4000bf86070ULL, 0x0000001716167c11ULL, 0x000fe200080f4c09ULL,
0x000000ffff097224ULL, 0x000fe200030e06ffULL, 0x0000001614117c11ULL, 0x040fe2000f8048ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000064f7faeULL, 0x0103e2000c901c4eULL,
0x0000001a08107c10ULL, 0x000fe4000ff3e0ffULL, 0x0000001714147c11ULL, 0x000fe400080f4c09ULL,
0x0000000b0c087210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200008e06ffULL,
0x0000000850007c0cULL, 0x000fc4000bf66070ULL, 0x0000000827007c0cULL, 0x000fe2000bf26070ULL,
0x000000ffff097224ULL, 0x000fe200000e060aULL, 0x0000000826007c0cULL, 0x000fe2000bf06070ULL,
0x00000015050a7c36ULL, 0x000fe20008000000ULL, 0x0000000f0c067210ULL, 0x002fca0007fde0ffULL,
0x000000ffff077224ULL, 0x000fe200030e060eULL, 0x00000016100f7c11ULL, 0x000fc8000f8c48ffULL,
0x0000001710107c11ULL, 0x000fe2000b0f4c0bULL, 0x00000000064e7faeULL, 0x000fe2000d101c4eULL,
0x0000001a0a177c10ULL, 0x000fe4000ffde0ffULL, 0x0000000d0c0a7210ULL, 0x000fe20007f5e0ffULL,
0x00000015040d7c36ULL, 0x000fe20008000000ULL, 0x00000000084d7faeULL, 0x0003e2000e901c4eULL,
0x000000ffff0e7224ULL, 0x000fe200030e06ffULL, 0x0000001617157c11ULL, 0x000fe2000f8a48ffULL,
0x000000ffff0b7224ULL, 0x000fe200010e0612ULL, 0x0000001a0d0d7c10ULL, 0x000fc4000ffde0ffULL,
0x0000001717177c11ULL, 0x000fe4000a8f4c0eULL, 0x000000160d137c11ULL, 0x000fe2000f8a48ffULL,
0x000000ffff127224ULL, 0x000fe200030e06ffULL, 0x0000000805007c0cULL, 0x000fe2000bf46070ULL,
0x0000001559057c36ULL, 0x000fe20008000000ULL, 0x000000190c087210ULL, 0x002fe20007fde0ffULL,
0x000000000a4c7faeULL, 0x0003e2000e101c4eULL, 0x000000170d127c11ULL, 0x000fe4000a8f4c12ULL,
0x000000110c067210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff097224ULL, 0x000fe200030e0616ULL,
0x0000001a05057c10ULL, 0x000fc4000ff9e0ffULL, 0x0000000859007c0cULL, 0x000fe2000bfc6070ULL,
0x000000ffff077224ULL, 0x000fe200028e0614ULL, 0x0000000804007c0cULL, 0x000fe2000bfa6070ULL,
0x0000001558047c36ULL, 0x000fe20008000000ULL, 0x00000000087d7faeULL, 0x0005e2000d901c4eULL,
0x000000ffff0e7224ULL, 0x000fe200020e06ffULL, 0x0000001605117c11ULL, 0x000fe2000f8848ffULL,
0x00000015570a7c36ULL, 0x002fe20008000000ULL, 0x0000001a04167c10ULL, 0x000fe2000ff7e0ffULL,
0x00000000067c7faeULL, 0x0003e2000c901c4eULL, 0x0000000f0c047210ULL, 0x000fc40007f3e0ffULL,
0x00000017050e7c11ULL, 0x000fe2000a0f4c0eULL, 0x000000ffff0b7224ULL, 0x000fe200018e06ffULL,
0x0000001a0a0a7c10ULL, 0x000fe2000ff9e0ffULL, 0x000000ffff057224ULL, 0x000fe200008e0610ULL,
0x00000016160f7c11ULL, 0x000fe2000f8648ffULL, 0x0000001556087c36ULL, 0x004fe20008000000ULL,
0x0000000858007c0cULL, 0x000fe2000bf26070ULL, 0x000000ffff097224ULL, 0x000fe200020e06ffULL,
0x0000001716167c11ULL, 0x000fe200098f4c0bULL, 0x00000000047b7faeULL, 0x0005e2000c101c4eULL,
0x0000001a08147c10ULL, 0x000fe2000ff9e0ffULL, 0x0000001554067c36ULL, 0x002fe20008000000ULL,
0x000000160a0d7c11ULL, 0x000fc4000f8648ffULL, 0x000000150c087210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff077224ULL, 0x000fe200020e06ffULL, 0x000000170a107c11ULL, 0x000fe400098f4c09ULL,
0x000000130c0a7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff097224ULL, 0x000fe200000e0617ULL,
0x0000001614157c11ULL, 0x040fe2000f8048ffULL, 0x0000001555047c36ULL, 0x004fe20008000000ULL,
0x0000000857007c0cULL, 0x000fe2000bf86070ULL, 0x000000ffff0b7224ULL, 0x000fe200018e0612ULL,
0x0000001714147c11ULL, 0x000fe200080f4c07ULL, 0x00000000087a7faeULL, 0x0003e2000d101c4eULL,
0x0000001a04127c10ULL, 0x000fc4000ff1e0ffULL, 0x000000110c047210ULL, 0x000fe20007f5e0ffULL,
0x000000000a797faeULL, 0x0005e2000e901c4eULL, 0x0000000856007c0cULL, 0x000fe2000bf66070ULL,
0x000000ffff077224ULL, 0x000fe200000e06ffULL, 0x0000001612137c11ULL, 0x040fe2000f8048ffULL,
0x000000ffff057224ULL, 0x000fe200010e060eULL, 0x0000001a06117c10ULL, 0x000fe4000ff5e0ffULL,
0x0000001712127c11ULL, 0x000fe400080f4c07ULL, 0x0000000f0c067210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200010e06ffULL, 0x0000000d0c087210ULL, 0x002fe20007f1e0ffULL,
0x000000155a0a7c36ULL, 0x004fe20008000000ULL, 0x00000016110f7c11ULL, 0x040fe2000f8448ffULL,
0x000000ffff077224ULL, 0x000fe200028e0616ULL, 0x0000000004787faeULL, 0x0003e2000f101c4eULL,
0x000000ffff097224ULL, 0x000fe200000e0610ULL, 0x0000001711117c11ULL, 0x000fc400090f4c0eULL,
0x0000001a0a107c10ULL, 0x000fe2000ff5e0ffULL, 0x0000000006777faeULL, 0x0005e2000c901c4eULL,
0x0000000855007c0cULL, 0x000fe4000bfa6070ULL, 0x00000016100d7c11ULL, 0x000fe2000f8c48ffULL,
0x0000000008767faeULL, 0x0005e2000e101c4eULL, 0x000000ffff0b7224ULL, 0x000fe200010e06ffULL,
0x000000150c0a7210ULL, 0x000fe40007f9e0ffULL, 0x000000130c0e7210ULL, 0x000fe40007f5e0ffULL,
0x0000000854007c0cULL, 0x000fc4000bf06070ULL, 0x0000001710107c11ULL, 0x000fe2000b0f4c0bULL,
0x000000ffff0b7224ULL, 0x000fe200020e0614ULL, 0x000000085a007c0cULL, 0x000fe4000bf26070ULL,
0x0000000f0c047210ULL, 0x002fe20007f9e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200010e0612ULL,
0x0000000d0c0c7210ULL, 0x000fe20007f5e0ffULL, 0x000000000a757faeULL, 0x0005e4000d901c4eULL,
0x000000ffff057224ULL, 0x000fe400020e0611ULL, 0x000000ffff0d7224ULL, 0x000fe200010e0610ULL,
0x000000000e747faeULL, 0x0005e8000e901c4eULL, 0x0000000004737faeULL, 0x0005e8000c101c4eULL,
0x000000000c717faeULL, 0x0005e2000c901c4eULL, 0x0000000800147947ULL, 0x000fea0003800000ULL,
0x0000001524067c36ULL, 0x000fe40008000000ULL, 0x0000001553537c36ULL, 0x000fe40008000000ULL,
0x0000001552527c36ULL, 0x000fe20008000000ULL, 0x0000001a06107c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001551517c36ULL, 0x000fe20008000000ULL, 0x0000001a53537c10ULL, 0x000fe2000ff3e0ffULL,
0x0000001550507c36ULL, 0x000fe20008000000ULL, 0x0000001a52527c10ULL, 0x000fe2000ff5e0ffULL,
0x000000ffff077224ULL, 0x000fe200000e06ffULL, 0x0000001610087c11ULL, 0x040fe2000f8048ffULL,
0x000000ffff0a7224ULL, 0x000fe200008e06ffULL, 0x0000001653067c11ULL, 0x040fe2000f8248ffULL,
0x0000001527277c36ULL, 0x000fe20008000000ULL, 0x0000001710107c11ULL, 0x000fe200080f4c07ULL,
0x000000ffff097224ULL, 0x000fe200010e06ffULL, 0x0000001753077c11ULL, 0x000fe200088f4c0aULL,
0x0000001526267c36ULL, 0x000fe20008000000ULL, 0x0000001a51517c10ULL, 0x000fe2000ff3e0ffULL,
0x0000001504047c36ULL, 0x000fe20008000000ULL, 0x00000016520a7c11ULL, 0x040fe2000f8048ffULL,
0x0000001505057c36ULL, 0x000fe20008000000ULL, 0x0000001a50507c10ULL, 0x000fe2000ff5e0ffULL,
0x000000ffff147224ULL, 0x000fe200008e06ffULL, 0x0000001a27277c10ULL, 0x000fe2000ff7e0ffULL,
0x0000001559597c36ULL, 0x000fe20008000000ULL, 0x0000001752097c11ULL, 0x000fe200080f4c09ULL,
0x000000ffff0d7224ULL, 0x000fe200010e06ffULL, 0x0000001651127c11ULL, 0x000fe2000f8048ffULL,
0x000000ffff167224ULL, 0x000fe200018e06ffULL, 0x00000016270e7c11ULL, 0x000fe2000f8448ffULL,
0x0000001558587c36ULL, 0x000fe20008000000ULL, 0x00000017510b7c11ULL, 0x000fe200080f4c14ULL,
0x0000001557577c36ULL, 0x000fe20008000000ULL, 0x0000001a26117c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001556567c36ULL, 0x000fe20008000000ULL, 0x00000016500c7c11ULL, 0x040fe2000f8248ffULL,
0x0000001555557c36ULL, 0x000fe20008000000ULL, 0x00000017270f7c11ULL, 0x000fe200090f4c16ULL,
0x000000155a5a7c36ULL, 0x000fe20008000000ULL, 0x0000001a04157c10ULL, 0x000fe2000ff5e0ffULL,
0x000000ffff047224ULL, 0x000fe200000e06ffULL, 0x00000017500d7c11ULL, 0x000fe200088f4c0dULL,
0x0000001554547c36ULL, 0x000fe20008000000ULL, 0x0000001a05057c10ULL, 0x000fe2000ff3e0ffULL,
0x000000ffff187224ULL, 0x000fe200010e06ffULL, 0x0000001611267c11ULL, 0x000fe2000f8048ffULL,
0x0000001025257824ULL, 0x000fe200078e00ffULL, 0x0000001615147c11ULL, 0x000fe2000f8448ffULL,
0x000000ffff167224ULL, 0x000fe200008e06ffULL, 0x0000001711117c11ULL, 0x000fc400080f4c04ULL,
0x0000001a59597c10ULL, 0x000fe4000ff1e0ffULL, 0x0000001605247c11ULL, 0x000fe4000f8248ffULL,
0x0000001715157c11ULL, 0x000fe200090f4c18ULL, 0x000000ffff047224ULL, 0x000fe200000e06ffULL,
0x0000001705137c11ULL, 0x000fe400088f4c16ULL, 0x0000001659167c11ULL, 0x000fe4000f8048ffULL,
0x0000001a58587c10ULL, 0x000fc4000ff3e0ffULL, 0x0000001a57577c10ULL, 0x000fe4000ff5e0ffULL,
0x0000001a56567c10ULL, 0x000fe2000ff7e0ffULL, 0x000000ffff197224ULL, 0x000fe200008e06ffULL,
0x0000001759177c11ULL, 0x000fe200080f4c04ULL, 0x000000ffff047224ULL, 0x000fe200010e06ffULL,
0x0000001658187c11ULL, 0x000fe2000f8048ffULL, 0x000000ffff1d7224ULL, 0x000fe200018e06ffULL,
0x00000016561c7c11ULL, 0x000fe4000f8448ffULL, 0x00000016571a7c11ULL, 0x000fc4000f8248ffULL,
0x0000001758197c11ULL, 0x000fe400080f4c19ULL, 0x00000017561d7c11ULL, 0x000fe400090f4c1dULL,
0x0000001a55557c10ULL, 0x000fe4000ff1e0ffULL, 0x0000001a5a5a7c10ULL, 0x000fe4000ff5e0ffULL,
0x00000017571b7c11ULL, 0x000fe200088f4c04ULL, 0x000000ffff047224ULL, 0x000fe200000e06ffULL,
0x0000001a54547c10ULL, 0x000fe2000ff3e0ffULL, 0x000000ffff237224ULL, 0x000fe200010e06ffULL,
0x00000016551e7c11ULL, 0x000fc4000f8048ffULL, 0x000000165a227c11ULL, 0x000fe2000f8448ffULL,
0x000000ffff217224ULL, 0x000fe200008e06ffULL, 0x0000007025257812ULL, 0x000fe400078ec0ffULL,
0x0000001654207c11ULL, 0x000fe4000f8248ffULL, 0x00000017551f7c11ULL, 0x000fe400080f4c04ULL,
0x000000175a237c11ULL, 0x000fe400090f4c23ULL, 0x0000000825047210ULL, 0x000fc40007f5e0ffULL,
0x0000001754217c11ULL, 0x000fe400088f4c21ULL, 0x0000000625067210ULL, 0x000fe20007fde0ffULL,
0x000000ffff057224ULL, 0x000fe200010e0610ULL, 0x0000000a25087210ULL, 0x000fe40007f3e0ffULL,
0x00000012250a7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff077224ULL, 0x000fe200030e0607ULL,
0x0000000c250c7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff097224ULL, 0x000fe200008e0609ULL,
0x0000000e250e7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e060bULL,
0x0000002625107210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200028e060dULL,
0x0000002425127210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200020e060fULL,
0x0000001425147210ULL, 0x000fe20007f3e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000044f7faeULL, 0x0103e2000b901c4eULL, 0x0000001625167210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff117224ULL, 0x000fe200018e0611ULL, 0x0000001825187210ULL, 0x000fe20007fbe0ffULL,
0x00000000064e7faeULL, 0x0003e2000b901c4eULL, 0x0000001a251a7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff137224ULL, 0x000fe200010e0613ULL, 0x0000001c251c7210ULL, 0x000fe20007f7e0ffULL,
0x00000000084d7faeULL, 0x0003e2000b901c4eULL, 0x0000001e251e7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff157224ULL, 0x000fe200008e0615ULL, 0x0000002025207210ULL, 0x000fe20007f3e0ffULL,
0x000000000a4c7faeULL, 0x0003e2000b901c4eULL, 0x000000ffff177224ULL, 0x000fe200000e0617ULL,
0x0000002225227210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff197224ULL, 0x000fe200028e0619ULL,
0x000000000c7d7faeULL, 0x0003e2000b901c4eULL, 0x000000ffff1b7224ULL, 0x000fc400020e061bULL,
0x000000ffff1d7224ULL, 0x000fe200018e061dULL, 0x000000000e7c7faeULL, 0x0003e2000b901c4eULL,
0x000000ffff1f7224ULL, 0x000fe400010e061fULL, 0x000000ffff217224ULL, 0x000fe200008e0621ULL,
0x00000000107b7faeULL, 0x0003e2000b901c4eULL, 0x000000ffff237224ULL, 0x000fc600000e0623ULL,
0x00000000127a7faeULL, 0x0003e8000b901c4eULL, 0x0000000014797faeULL, 0x0003e8000b901c4eULL,
0x0000000016787faeULL, 0x0003e8000b901c4eULL, 0x0000000018777faeULL, 0x0003e8000b901c4eULL,
0x000000001a767faeULL, 0x0003e8000b901c4eULL, 0x000000001c757faeULL, 0x0003e8000b901c4eULL,
0x000000001e747faeULL, 0x0003e8000b901c4eULL, 0x0000000020737faeULL, 0x0003e8000b901c4eULL,
0x0000000022717faeULL, 0x0003e4000b901c4eULL, 0x0000580001067983ULL, 0x006ea80000300800ULL,
0x00005000010c7983ULL, 0x000ee80000300800ULL, 0x0000480001107983ULL, 0x000f280000300800ULL,
0x0000400001167983ULL, 0x000f680000300800ULL, 0x00003c0001197983ULL, 0x000f680000300800ULL,
0x0000380001207983ULL, 0x000f680000300800ULL, 0x0000340001237983ULL, 0x000f680000300800ULL,
0x00002c0001227983ULL, 0x000f680000300800ULL, 0x0000100001217983ULL, 0x000f620000300800ULL,
0x0000001803047836ULL, 0x000fe20000000000ULL, 0x0000000411087291ULL, 0x000fe2000f8e183fULL,
0x0000002002057824ULL, 0x000fe200078e00ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000001a03147836ULL, 0x000fc40000000000ULL, 0x0000002002157824ULL, 0x000fe200078e00ffULL,
0xffffffe005047812ULL, 0x000fc800078ee204ULL, 0x0000000404047c11ULL, 0x000fe4000f8e20ffULL,
0xffffffe015187812ULL, 0x000fc800078ee214ULL, 0x00000004181c7c11ULL, 0x000fe2000f8e20ffULL,
0x000080400000791aULL, 0x000fca0000000000ULL, 0x000000001c1c783bULL, 0x000fe80000000200ULL,
0x000000006e2c783bULL, 0x000fe80000000200ULL, 0x000000006564783bULL, 0x000fe80000000200ULL,
0x000000000608783bULL, 0x004fe80000000200ULL, 0x000000000404783bULL, 0x000e680000000200ULL,
0x000000000c0c783bULL, 0x008ea80000000200ULL, 0x000000001010783bULL, 0x010ee80000000200ULL,
0x000000001614783bULL, 0x020f280000000200ULL, 0x000000001918783bULL, 0x000f620000000200ULL,
0x000000080440723cULL, 0x002fec0000041840ULL, 0x0000000c0428723cULL, 0x004fec0000041828ULL,
0x0000000a0444723cULL, 0x000fe20000041844ULL, 0x0000001c030c7836ULL, 0x000fe20000000000ULL,
0x000000002008783bULL, 0x0002a20000000200ULL, 0x00000020020d7824ULL, 0x000fc400078e00ffULL,
0x0000001e03037836ULL, 0x000fe20000000000ULL, 0x0000000e043c723cULL, 0x000fe2000004183cULL,
0x0000002002027824ULL, 0x000fe200078e00ffULL, 0xffffffe00d207812ULL, 0x002fc800078ee20cULL,
0x000000100430723cULL, 0x008fe20000041830ULL, 0x00000000230c783bULL, 0x000e620000000200ULL,
0x0000000420247c11ULL, 0x000fe4000f8e20ffULL, 0xffffffe002037812ULL, 0x000fe400078ee203ULL,
0x000000120434723cULL, 0x000fe20000041834ULL, 0x000000002210783bULL, 0x000ee20000000200ULL,
0x0000000403037c11ULL, 0x000fc8000f8e20ffULL, 0x000000140438723cULL, 0x010fe20000041838ULL,
0x000000002424783bULL, 0x000fe80000000200ULL, 0x000000002120783bULL, 0x000fe20000000200ULL,
0x000000160448723cULL, 0x000fe60000041848ULL, 0x000000007204783bULL, 0x000f260000000200ULL,
0x000000181c40723cULL, 0x020fe20000041840ULL, 0x000000007014783bULL, 0x000f6a0000000200ULL,
0x0000001a1c44723cULL, 0x000fe20000041844ULL, 0x000000006f18783bULL, 0x000f2a0000000200ULL,
0x000000081c28723cULL, 0x004fec0000041828ULL, 0x0000000a1c3c723cULL, 0x000fe2000004183cULL,
0x000000000308783bULL, 0x000fea0000000200ULL, 0x0000000c1c30723cULL, 0x002fec0000041830ULL,
0x0000000e1c34723cULL, 0x000fe20000041834ULL, 0x00000000690c783bULL, 0x000fea0000000200ULL,
0x000000101c38723cULL, 0x008fec0000041838ULL, 0x000000121c48723cULL, 0x000fe20000041848ULL,
0x000000006d10783bULL, 0x000e6a0000000200ULL, 0x000000042428723cULL, 0x010fec0000041828ULL,
0x00000006243c723cULL, 0x000fec000004183cULL, 0x000000142430723cULL, 0x020fec0000041830ULL,
0x000000202440723cULL, 0x000fec0000041840ULL, 0x000000222444723cULL, 0x000fec0000041844ULL,
0x000000162434723cULL, 0x000fec0000041834ULL, 0x000000182404723cULL, 0x000fec0000041838ULL,
0x0000001a2448723cULL, 0x000fec0000041848ULL, 0x000000100818723cULL, 0x002fec0000041828ULL,
0x000000120814723cULL, 0x000fe2000004183cULL, 0x00000001ff2a7424ULL, 0x000fca00078e00ffULL,
0x0000000c0810723cULL, 0x000fe20000041830ULL, 0x01c6882aff2a79a7ULL, 0x000e6a0008500008ULL,
0x0000002c0840723cULL, 0x000fec0000041840ULL, 0x0000002e0844723cULL, 0x000fe20000041844ULL,
0x3d80000019217820ULL, 0x000fe20000410000ULL, 0x3d80000018227820ULL, 0x000fe20000410000ULL,
0x3d8000001a1a7820ULL, 0x000fe20000410000ULL, 0x3d8000001b1b7820ULL, 0x000fc40000410000ULL,
0x0000000e080c723cULL, 0x000fe20000041834ULL, 0x3d80000014257820ULL, 0x000fe20000410000ULL,
0x3d80000015207820ULL, 0x000fe20000410000ULL, 0x3d80000016167820ULL, 0x000fe20000410000ULL,
0x3d80000017177820ULL, 0x000fe40000410000ULL, 0x000000640804723cULL, 0x000fe20000041804ULL,
0x3d80000010247820ULL, 0x000fe20000410000ULL, 0x3d800000111f7820ULL, 0x000fe20000410000ULL,
0x3d80000012127820ULL, 0x000fe20000410000ULL, 0x3d80000013137820ULL, 0x000fc40000410000ULL,
0x000000660808723cULL, 0x000fe20000041848ULL, 0x3d80000040297820ULL, 0x000fe20000410000ULL,
0x3d80000041267820ULL, 0x000fe20000410000ULL, 0x3d800000421c7820ULL, 0x000fe20000410000ULL,
0x3d80000043037820ULL, 0x000fe40000410000ULL, 0x3d80000044277820ULL, 0x000fe20000410000ULL,
0x3d80000045237820ULL, 0x000fe20000410000ULL, 0x3d800000461d7820ULL, 0x000fe20000410000ULL,
0x3d800000471e7820ULL, 0x000fc60000410000ULL, 0x3d8000000c197820ULL, 0x000fe20000410000ULL,
0x3d8000000d147820ULL, 0x000fe20000410000ULL, 0x3d8000000e107820ULL, 0x000fe20000410000ULL,
0x3d8000000f117820ULL, 0x000fc60000410000ULL, 0x3d80000004187820ULL, 0x000fe20000410000ULL,
0x3d80000005157820ULL, 0x000fe20000410000ULL, 0x3d800000060f7820ULL, 0x000fe20000410000ULL,
0x3d800000070c7820ULL, 0x000fc60000410000ULL, 0x3d80000008087820ULL, 0x000fe20000410000ULL,
0x3d80000009097820ULL, 0x000fe20000410000ULL, 0x3d8000000a0d7820ULL, 0x000fe20000410000ULL,
0x3d8000000b0e7820ULL, 0x000fe20000410000ULL, 0x0000000000047805ULL, 0x000fe20000015200ULL,
0x01c6882bff0075a7ULL, 0x002e640008000148ULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff0a7224ULL, 0x000fce00078e00ffULL, 0x000000100a00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x00000006040b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09000b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff027819ULL, 0x000fc80000011407ULL, 0x0000000b02027211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000202027819ULL, 0x000fc80000001207ULL,
0x000000020000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000010a0a7836ULL, 0x000fce0000000000ULL, 0x01c6882bff0075a7ULL, 0x000e640008000148ULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000000317919ULL, 0x000e620000000000ULL,
0xffffffff070d7890ULL, 0x000fe4000fffe03fULL, 0x0000000411087291ULL, 0x000fe4000f8e383fULL,
0x0000000d0500728cULL, 0x000fcc000bf05270ULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x0000000431027824ULL, 0x002fca00078e00ffULL, 0xfffffff002027812ULL, 0x000fca00078ec0ffULL,
0x01c4000802047984ULL, 0x0002a40008000c00ULL, 0x0000000400080947ULL, 0x000fea0003800000ULL,
0x00000002310a7824ULL, 0x000fe200078e00ffULL, 0x8000001314137290ULL, 0x000fc8000fffe03fULL,
0x000000060a0a7812ULL, 0x000fc800078ec0ffULL, 0x000000010a0b7812ULL, 0x040fe400078efcffULL,
0x000000080a287812ULL, 0x040fe400078efcffULL, 0x000000130b007c0cULL, 0x000fe4000bf26070ULL,
0x000000100a0b7812ULL, 0x000fe400078efcffULL, 0x0000001328007c0cULL, 0x000fe4000bf06070ULL,
0x000000130b007c0cULL, 0x000fc4000bfc6070ULL, 0x000000110a287812ULL, 0x040fe400078efcffULL,
0x000000180a0b7812ULL, 0x040fe400078efcffULL, 0x000000130a007c0cULL, 0x000fe4000bf46070ULL,
0x0000001328007c0cULL, 0x000fe4000bfa6070ULL, 0x000000130b007c0cULL, 0x000fe4000bf66070ULL,
0x000000090a2a7812ULL, 0x000fc400078efcffULL, 0x000000190a287812ULL, 0x040fe400078efcffULL,
0x000000200a0b7812ULL, 0x000fe400078efcffULL, 0xff8000001c1c7808ULL, 0x000fe40005000000ULL,
0xff80000029297808ULL, 0x000fe40005000000ULL, 0xff80000003037808ULL, 0x000fe40004800000ULL,
0xff80000026267808ULL, 0x000fc40004800000ULL, 0x000000132a007c0cULL, 0x000fe4000bf86070ULL,
0x0000001328007c0cULL, 0x000fe4000bf46070ULL, 0x000000130b007c0cULL, 0x000fe4000bf26070ULL,
0x000000210a287812ULL, 0x040fe400078efcffULL, 0x000000280a0b7812ULL, 0x000fe400078efcffULL,
0xff8000001d1d7808ULL, 0x000fc40004000000ULL, 0xff80000027277808ULL, 0x000fe40004000000ULL,
0xff8000001e1e7808ULL, 0x000fe40006000000ULL, 0xff80000023237808ULL, 0x000fe40006000000ULL,
0x0000001328007c0cULL, 0x000fe4000bf06070ULL, 0x000000130b007c0cULL, 0x000fe4000bf86070ULL,
0x000000290a287812ULL, 0x000fc400078efcffULL, 0x000000300a0b7812ULL, 0x000fe400078efcffULL,
0xff8000001a1a7808ULL, 0x000fe40007000000ULL, 0xff80000022227808ULL, 0x000fe40007000000ULL,
0xff8000001b1b7808ULL, 0x000fe40006800000ULL, 0xff80000021217808ULL, 0x000fe40006800000ULL,
0x0000001328007c0cULL, 0x000fc4000bfc6070ULL, 0x000000130b007c0cULL, 0x000fe4000bfa6070ULL,
0x000000310a287812ULL, 0x040fe400078efcffULL, 0x000000380a0b7812ULL, 0x040fe400078efcffULL,
0x000000390a0a7812ULL, 0x000fe400078efcffULL, 0xff80000016167808ULL, 0x000fe40005800000ULL,
0xff80000025257808ULL, 0x000fc40005800000ULL, 0xff80000017177808ULL, 0x000fe40005000000ULL,
0xff80000020207808ULL, 0x000fe40005000000ULL, 0xff80000012127808ULL, 0x000fe40004800000ULL,
0xff80000024247808ULL, 0x000fe40004800000ULL, 0x0000001328007c0cULL, 0x000fe4000bf66070ULL,
0x000000130b007c0cULL, 0x000fc4000bf46070ULL, 0x000000130a007c0cULL, 0x000fe4000bf26070ULL,
0xff80000013137808ULL, 0x000fe40004000000ULL, 0xff8000001f1f7808ULL, 0x000fe40004000000ULL,
0xff80000010107808ULL, 0x000fe40006000000ULL, 0xff80000019197808ULL, 0x000fe40006000000ULL,
0xff80000011117808ULL, 0x000fc40007000000ULL, 0xff80000014147808ULL, 0x000fe40007000000ULL,
0xff8000000f0f7808ULL, 0x000fe40006800000ULL, 0xff80000018187808ULL, 0x000fe40006800000ULL,
0xff8000000c0c7808ULL, 0x000fe40005800000ULL, 0xff80000015157808ULL, 0x000fe40005800000ULL,
0xff8000000d0d7808ULL, 0x000fc40005000000ULL, 0xff80000008087808ULL, 0x000fe40005000000ULL,
0xff8000000e0e7808ULL, 0x000fe40004800000ULL, 0xff80000009097808ULL, 0x000fce0004800000ULL,
0x000000290400720bULL, 0x004fe20003f1e000ULL, 0x3f80000000057882ULL, 0x000fe20000000000ULL,
0x0000000000327919ULL, 0x000ea20000000000ULL, 0x000000070c00728cULL, 0x000fe2000bf06070ULL,
0x00000004290b7208ULL, 0x000fe20004000000ULL, 0x00000004110d7291ULL, 0x000fc6000f8e283fULL,
0x000000260b00720bULL, 0x000fc80003f1e000ULL, 0x0000000b26047208ULL, 0x000fc80004000000ULL,
0x000000270400720bULL, 0x000fc80003f1e000ULL, 0x0000000427047208ULL, 0x000fc80004000000ULL,
0x000000230400720bULL, 0x000fc80003f1e000ULL, 0x00000004230b7208ULL, 0x000fc80004000000ULL,
0x000000220b00720bULL, 0x000fe40003f1e000ULL, 0x00000003ff327819ULL, 0x004fe40000011632ULL,
0x0000000b22047208ULL, 0x000fc80004000000ULL, 0x000000210400720bULL, 0x000fc80003f1e000ULL,
0x0000000421047208ULL, 0x000fc80004000000ULL, 0x000000250400720bULL, 0x000fc80003f1e000ULL,
0x00000004250b7208ULL, 0x000fc80004000000ULL, 0x000000200b00720bULL, 0x000fc80003f1e000ULL,
0x0000000b200b7208ULL, 0x000fc80004000000ULL, 0x000000240b00720bULL, 0x000fc80003f1e000ULL,
0x0000000b24047208ULL, 0x000fc80004000000ULL, 0x0000001f0400720bULL, 0x000fc80003f1e000ULL,
0x000000041f047208ULL, 0x000fc80004000000ULL, 0x000000190400720bULL, 0x000fc80003f1e000ULL,
0x00000004190b7208ULL, 0x000fe40004000000ULL, 0x0000001c0500720bULL, 0x000fe40003f1e000ULL,
0x000000140b00720bULL, 0x000fe40003f3e000ULL, 0x000000051c047208ULL, 0x000fe40004000000ULL,
0x0000000b140b7208ULL, 0x000fe40004800000ULL, 0x000000030400720bULL, 0x000fc40003f1e000ULL,
0x000000180b00720bULL, 0x000fe40003f3e000ULL, 0x0000000403047208ULL, 0x000fe40004000000ULL,
0x0000000b180a7208ULL, 0x000fe40004800000ULL, 0x0000001d0400720bULL, 0x000fe40003f1e000ULL,
0x000000150a00720bULL, 0x000fe40003f3e000ULL, 0x000000041d057208ULL, 0x000fc40004000000ULL,
0x0000000a150b7208ULL, 0x000fe40004800000ULL, 0x0000001e0500720bULL, 0x000fe40003f1e000ULL,
0x000000080b00720bULL, 0x000fe40003f3e000ULL, 0x000000051e057208ULL, 0x000fe40004000000ULL,
0x0000000b08047208ULL, 0x000fe40004800000ULL, 0x0000001a0500720bULL, 0x000fc40003f1e000ULL,
0x000000090400720bULL, 0x000fc80003f3e000ULL, 0x00000004090a7208ULL, 0x000fe40004800000ULL,
0x000000051a047208ULL, 0x000fc60004000000ULL, 0x0c401f000a0b7f89ULL, 0x000ea200000e0000ULL,
0x0000001b0400720bULL, 0x000fc80003f1e000ULL, 0x000000041b057208ULL, 0x000fc80004000000ULL,
0x000000160500720bULL, 0x000fc80003f1e000ULL, 0x0000000516047208ULL, 0x000fc80004000000ULL,
0x000000170400720bULL, 0x000fc80003f1e000ULL, 0x0000000417057208ULL, 0x000fe40004000000ULL,
0x0000000b0a00720bULL, 0x004fe40003f3e000ULL, 0x000000120500720bULL, 0x000fe40003f1e000ULL,
0x0000000a0b0b7208ULL, 0x000fe40004800000ULL, 0x0000000512047208ULL, 0x000fc60004000000ULL,
0x0c201f000b287f89ULL, 0x000ea200000e0000ULL, 0x000000130400720bULL, 0x000fc80003f1e000ULL,
0x0000000413057208ULL, 0x000fc80004000000ULL, 0x000000100500720bULL, 0x000fc80003f1e000ULL,
0x0000000510047208ULL, 0x000fc80004000000ULL, 0x000000110400720bULL, 0x000fc80003f1e000ULL,
0x00000004110a7208ULL, 0x000fe40004000000ULL, 0x000000280b00720bULL, 0x004fe40003f3e000ULL,
0x0000000f0a00720bULL, 0x000fe40003f1e000ULL, 0x0000000b28047208ULL, 0x000fe40004800000ULL,
0x0000000a0f057208ULL, 0x000fc60004000000ULL, 0x3fb8aa3b04287820ULL, 0x000fe20000410000ULL,
0x0000000c0500720bULL, 0x000fc60003f1e000ULL, 0x3fb8aa3b29297823ULL, 0x100fe20000010828ULL,
0x000000050c0a7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010828ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010828ULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010828ULL,
0x0000000d0a00720bULL, 0x000fe20003f1e000ULL, 0x0000002900297308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b18187823ULL, 0x100fe20000010828ULL, 0x3fb8aa3b19197823ULL, 0x100fe20000010828ULL,
0x0000000a0d057208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b08087823ULL, 0x100fe20000010828ULL,
0x3fb8aa3b09097823ULL, 0x100fe20000010828ULL, 0x3fb8aa3b22227823ULL, 0x100fe20000010828ULL,
0x0000000e0500720bULL, 0x000fe20003f1e000ULL, 0x0000002600267308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b21217823ULL, 0x100fe20000010828ULL, 0x3fb8aa3b25257823ULL, 0x100fe20000010828ULL,
0x000000050e057208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b20207823ULL, 0x100fe20000010828ULL,
0x3fb8aa3b24247823ULL, 0x100fe20000010828ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010828ULL,
0x3fb8aa3b14147823ULL, 0x100fe20000010828ULL, 0x0c401f00050a7f89ULL, 0x000ee200000e0000ULL,
0x0000002700277308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b15157823ULL, 0x000fce0000010828ULL,
0x00000023002a7308ULL, 0x000f300000000800ULL, 0x00000018002b7308ULL, 0x000be20000000800ULL,
0x0000000a0500720bULL, 0x008fce0003f1e000ULL, 0x0000001900237308ULL, 0x0007e20000000800ULL,
0x00000005ff187e24ULL, 0x022fe2000f8e00ffULL, 0x0000000411057291ULL, 0x000fe2000f8e583fULL,
0x000000050a057208ULL, 0x000fc60004000000ULL, 0x3f8000001818783eULL, 0x000fe200000010ffULL,
0x0001200005057890ULL, 0x000fe2000fffe03fULL, 0x0c201f00050a7f89ULL, 0x000e6200000e0000ULL,
0x00000008002d7308ULL, 0x0005e40000000800ULL, 0x000000ffff197224ULL, 0x008fcc00078e0018ULL,
0x0000000900287308ULL, 0x000fe20000000800ULL, 0x000000292608723eULL, 0x004fce00000010ffULL,
0x00000014002c7308ULL, 0x000fe20000000800ULL, 0x0000000a0500720bULL, 0x002fce0003f1e000ULL,
0x00000015002e7308ULL, 0x000fe20000000800ULL, 0x000000050a057208ULL, 0x000fe40004000000ULL,
0x000000272a0a723eULL, 0x010fc600000010ffULL, 0x3fb8aa3b052f7820ULL, 0x000fe40000410000ULL,
0x0000002200227308ULL, 0x000fe40000000800ULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe2000001082fULL,
0x3fb8aa3b03037823ULL, 0x100fe2000001082fULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe2000001082fULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe2000001082fULL, 0x3fb8aa3b16167823ULL, 0x100fe2000001082fULL,
0x3fb8aa3b17177823ULL, 0x100fe2000001082fULL, 0x0000001c001c7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe2000001082fULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe2000001082fULL,
0x3fb8aa3b12267823ULL, 0x100fe2000001082fULL, 0x3fb8aa3b0f0f7823ULL, 0x000fc8000001082fULL,
0x0000000300037308ULL, 0x000e700000000800ULL, 0x0000001d000b7308ULL, 0x000fe20000000800ULL,
0x0000001c0309723eULL, 0x002fce00000010ffULL, 0x0000001e001e7308ULL, 0x000e620000000800ULL,
0x3fb8aa3b13037823ULL, 0x100fe2000001082fULL, 0x3fb8aa3b111c7823ULL, 0x000fcc000001082fULL,
0x0000001600307308ULL, 0x000fe20000000800ULL, 0x0000000b1e0b723eULL, 0x002fce00000010ffULL,
0x00000017001d7308ULL, 0x0002a20000000800ULL, 0x3fb8aa3b0d1e7823ULL, 0x000fce000001082fULL,
0x0000002100217308ULL, 0x000ee20000000800ULL, 0x000000180814723cULL, 0x002fe200000418ffULL,
0x000000301d13723eULL, 0x004fcc00000010ffULL, 0x0000002500257308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b10197823ULL, 0x000fe2000001082fULL, 0x000000222110723eULL, 0x008fcc00000010ffULL,
0x0000002000207308ULL, 0x000e620000000800ULL, 0x000000ffff217224ULL, 0x000fce00078e0018ULL,
0x0000001a001a7308ULL, 0x000fe20000000800ULL, 0x000000252012723eULL, 0x002fce00000010ffULL,
0x0000001b001b7308ULL, 0x000e620000000800ULL, 0x000000ffff207224ULL, 0x100fe400078e0018ULL,
0x000000ffff257224ULL, 0x000fca00078e0018ULL, 0x0000001900197308ULL, 0x000fe20000000800ULL,
0x0000001a1b11723eULL, 0x002fce00000010ffULL, 0x0000001c001c7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b0c1b7823ULL, 0x100fe2000001082fULL, 0x3fb8aa3b0e2f7823ULL, 0x000fe2000001082fULL,
0x0c401f00071a7f89ULL, 0x000e6200000e0000ULL, 0x000000232c0e723eULL, 0x000fe200000010ffULL,
0x000000201014723cULL, 0x000fe60000041814ULL, 0x0000002400247308ULL, 0x000fe20000000800ULL,
0x000000ffff297224ULL, 0x000fce00078e000eULL, 0x0000001f001f7308ULL, 0x000eb00000000800ULL,
0x0000002600267308ULL, 0x000fe20000000800ULL, 0x0000001a0700720bULL, 0x002fe40003f3e000ULL,
0x000000241f0c723eULL, 0x004fca00000010ffULL, 0x0000000300277308ULL, 0x0002a20000000800ULL,
0x000000ffff247224ULL, 0x000fe200078e0018ULL, 0x000000071a077208ULL, 0x000fcc0004800000ULL,
0x0000000f001d7308ULL, 0x0007e20000000800ULL, 0x0c401f0006037f89ULL, 0x002e6200000e0000ULL,
0x00000026270d723eULL, 0x004fcc00000010ffULL, 0x0000001b00207308ULL, 0x000ea20000000800ULL,
0x000000191c0f723eULL, 0x008fe200000010ffULL, 0x000000ffff197224ULL, 0x000fe200078e0018ULL,
0x0000002b2e1c723eULL, 0x000fe200000010ffULL, 0x000000ffff267224ULL, 0x000fe400078e0010ULL,
0x000000ffff277224ULL, 0x000fe400078e0012ULL, 0x0000001e00217308ULL, 0x0007e20000000800ULL,
0x000000180c14723cULL, 0x000fe20000041814ULL, 0x000000ffff2a7224ULL, 0x000fe200078e001cULL,
0x0000001d201d723eULL, 0x004fca00000010ffULL, 0x0000002f00227308ULL, 0x000ea20000000800ULL,
0x000000030600720bULL, 0x002fe40003f1e000ULL, 0xfffffff8ff197812ULL, 0x000fe200078ee200ULL,
0x000000ffff0e7224ULL, 0x000fe200078e001dULL, 0x0000000603067208ULL, 0x000fe40004000000ULL,
0x0000002d281e723eULL, 0x008fe200000010ffULL, 0x0000000819207836ULL, 0x000fe20000000000ULL,
0x0000000332007812ULL, 0x000fe200078ec0ffULL, 0x0c201f0006037f89ULL, 0x000e6200000e0000ULL,
0x000000ffff287224ULL, 0x000fc400078e000cULL, 0x0000000820187824ULL, 0x000fe200078e00ffULL,
0x00000021221f723eULL, 0x004fe200000010ffULL, 0x00000001001a7824ULL, 0x040fe400078e0219ULL,
0x0000000100217824ULL, 0x000fe400078e0220ULL, 0x0c201f0007007f89ULL, 0x000ea200000e0000ULL,
0x0000000819227824ULL, 0x040fe200078e00ffULL, 0x000000241c14723cULL, 0x000fe20000041814ULL,
0x0000000819197824ULL, 0x000fe200078e00ffULL, 0xfffffff818217812ULL, 0x000fe200078ee221ULL,
0x000000041a1b7836ULL, 0x000fc60000000000ULL, 0x000000ffff2b7224ULL, 0x000fe200078e001eULL,
0xfffffff819187812ULL, 0x000fe200078ee21aULL, 0x0000000c1a1a7836ULL, 0x000fe20000000000ULL,
0xfffffff8221b7812ULL, 0x000fe200078ee21bULL, 0x000000ffff247224ULL, 0x000fe200078e0008ULL,
0x0000000518187c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff257224ULL, 0x000fe200078e000aULL,
0x000000030600720bULL, 0x002fe20003f1e000ULL, 0x000000ffff087224ULL, 0x000fe200078e0009ULL,
0x000000051b1b7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff097224ULL, 0x000fe200078e000bULL,
0x0000000603067208ULL, 0x000fe20004000000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e000dULL,
0x0000000331ff7812ULL, 0x000fe2000780c0ffULL, 0x000000ffff0a7224ULL, 0x000fe200078e0011ULL,
0x0000000521217c11ULL, 0x000fe2000f8e20ffULL, 0x0000000820157824ULL, 0x000fe200078e00ffULL,
0x000000000700720bULL, 0x004fe20003f3e000ULL, 0x000000ffff0b7224ULL, 0x000fe200078e0013ULL,
0x0000002418007844ULL, 0x0003e20000000200ULL, 0x000000ffff0d7224ULL, 0x000fe200078e000fULL,
0xfffffff8151a7812ULL, 0x000fe200078ee21aULL, 0x000000ffff0f7224ULL, 0x000fe200078e001fULL,
0x0000000700077208ULL, 0x000fe20004800000ULL, 0x000000ffff157224ULL, 0x000fe200078e0016ULL,
0x000000051a1a7c11ULL, 0x000fe2000f8e20ffULL, 0x000000281b007844ULL, 0x0003e20000000200ULL,
0x00000001ff007424ULL, 0x000fe200078e00ffULL, 0x0000000c00057c82ULL, 0x000fc40008000000ULL,
0x0000000821007844ULL, 0x0003e80000000200ULL, 0x0000000c1a007844ULL, 0x0003e80000000200ULL,
0x01c0000402008988ULL, 0x0003e80008000c08ULL, 0x01c2001402008988ULL, 0x0003e20008000a08ULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x01c60800ffff79a7ULL, 0x0003e2000850000dULL,
0x01c61000ffff79a7ULL, 0x0003e2000850000dULL, 0x01c61800ffff79a7ULL, 0x0003e2000850000dULL,
0x01c62000ffff79a7ULL, 0x0003f2000850000dULL, 0xffffff7c00308947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0180000002007836ULL, 0x000fe20000000000ULL,
0x0000013000007945ULL, 0x000fe80003800000ULL, 0x7f80000000037812ULL, 0x000fc800078ec0ffULL,
0x018000000300780cULL, 0x000fda0003f05070ULL, 0x0000000200008308ULL, 0x0002a20000001000ULL,
0x0000000000388947ULL, 0x000fea0003800000ULL, 0x000000ff0300720cULL, 0x040fe40003f25070ULL,
0x008000000300780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x007fffff02ff7812ULL, 0x000fc8000780c0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fe4000780c0ffULL,
0x8000000002037812ULL, 0x000fd600078ec0ffULL, 0x0080000003000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0003ULL, 0x0000000000047947ULL, 0x000fec0003800000ULL,
0x0000000200007308ULL, 0x0004e40000001000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000ff057424ULL, 0x000fc800078e00ffULL, 0xfffffe6c04387950ULL, 0x000fea0003c3ffffULL,
0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000001ULL, 0x0000000800000001ULL, 0x0000000100000001ULL, 0x0000000800000004ULL,
0x0000001000000001ULL, 0x0000000300000001ULL, 0x0000000400000004ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x0000000000000111ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000017bULL,
0x00000000000004cdULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000648ULL,
0x0000000000000210ULL, 0x0000001400000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000858ULL,
0x00000000000000d0ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000928ULL,
0x0000000000000054ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000097cULL,
0x00000000000004acULL, 0x0000000a00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000004000000b2ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000e28ULL,
0x0000000000000000ULL, 0x0000000a00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000004000000e6ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000e28ULL,
0x0000000000000048ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x000000010000007bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000e70ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000000e80ULL,
0x0000000000019400ULL, 0x0000001400000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000008dULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001a280ULL,
0x000000000000003cULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001a2c0ULL,
0x0000000000000400ULL, 0x0000000a00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x00000001000000f8ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x000000000001a2c0ULL,
0x0000000000000260ULL, 0x0000000a00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000400000006ULL, 0x000000000001a8a0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x000000000001a8a0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000000e70ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000000e80ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000019400ULL, 0x0000000000019400ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x000000000001a280ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000040ULL, 0x0000000000000440ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x000000000001a2c0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000260ULL,
0x0000000000000260ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_1_kvt_bf16_pagedKV_128_nqpkv_8_m_8_sm_90_cubin_len = 109040;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
