/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_1_kvt_bf16_pagedKV_64_nqpkv_8_m_8_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001c640ULL, 0x000000000001c2c0ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f34314944327961ULL, 0x6f6c66625f766e5fULL,
0x326a4c3236317461ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL,
0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x336a4c4536316a4cULL, 0x4c49746132454532ULL,
0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4534366aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL,
0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL,
0x4d6e4974736e4939ULL, 0x4c45326a4c497461ULL, 0x45346a4c4545326aULL, 0x7461324545316a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL, 0x6a4c4532336a4c45ULL,
0x4c49746132454538ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x4545386a4c45386aULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x36316a4c4545346aULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x65746e695f5f2400ULL, 0x245f305f6c616e72ULL,
0x735f616475635f5fULL, 0x5f7063725f30326dULL, 0x665f7a74665f6e72ULL, 0x70776f6c735f3233ULL,
0x695f5f2400687461ULL, 0x5f6c616e7265746eULL, 0x6475635f5f245f31ULL, 0x735f30376d735f61ULL,
0x5f636e79736c6668ULL, 0x2400705f796c6662ULL, 0x6e7265746e695f5fULL, 0x5f5f245f325f6c61ULL,
0x376d735f61647563ULL, 0x79736c6668735f30ULL, 0x705f7864695f636eULL, 0x65746e695f5f2400ULL,
0x245f335f6c616e72ULL, 0x735f616475635f5fULL, 0x65746f765f30376dULL, 0x6c61625f636e7973ULL,
0x6c65722e00746f6cULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x240061686d5f6c65ULL, 0x6d5f6c656e72656bULL, 0x426d656d73246168ULL,
0x2e00667542657479ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x2e006d617261705fULL, 0x72665f6775626564ULL, 0x6c65722e00656d61ULL, 0x665f67756265642eULL,
0x65722e00656d6172ULL, 0x67756265642e616cULL, 0x2e00656d6172665fULL, 0x612e6c65722e766eULL,
0x0000006e6f697463ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c0001000000adULL, 0x000000000000002cULL, 0x0000000000000010ULL, 0x000c0001000000ebULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x000c00010000016bULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000c0001000001b5ULL, 0x0000000000000010ULL, 0x0000000000000004ULL, 0x000c0001000001fbULL,
0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c000100000242ULL, 0x0000000000000008ULL,
0x0000000000000004ULL, 0x000c000100000288ULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000c0001000002d6ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c000100000324ULL,
0x0000000000000020ULL, 0x0000000000000004ULL, 0x000c00010000036aULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c0001000003afULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000b0022000003f5ULL, 0x000000000001a9c0ULL, 0x0000000000000190ULL, 0x000b002200000428ULL,
0x000000000001ab50ULL, 0x0000000000000040ULL, 0x000b002200000453ULL, 0x000000000001ab90ULL,
0x0000000000000040ULL, 0x000b00220000047dULL, 0x000000000001abd0ULL, 0x0000000000000130ULL,
0x000a0003000004ebULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000400030000050bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000700030000053bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL, 0x000000000001ad00ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0001a9c000000000ULL, 0x0000040400000000ULL, 0x810c000001480400ULL,
0x0069180400288080ULL, 0x0000000000000000ULL, 0x00000064ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8c08288080840828ULL, 0x2880809008288080ULL, 0x809a082880809208ULL, 0x082880809b082880ULL,
0x8082801628808088ULL, 0x0000000000031028ULL, 0x2880808892000000ULL, 0x0000000000002200ULL,
0x00000034ffffffffULL, 0x0000007000000000ULL, 0x0001a9c000000000ULL, 0x0000019000000000ULL,
0x0000580400000000ULL, 0x8087288080840900ULL, 0x0900000004042880ULL, 0x2880808428808088ULL,
0x00000054ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080880828808081ULL, 0x9a082880808c0828ULL, 0x2880809b08288080ULL,
0x8280162880809008ULL, 0x0000000003102880ULL, 0x8080909200000000ULL, 0x0000000000220028ULL,
0x0000001cffffffffULL, 0x0000012000000000ULL, 0x0001ab5000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x00000054ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080880828808081ULL, 0x92082880808c0828ULL,
0x2880809a08288080ULL, 0x8090082880809b08ULL, 0x1028808280162880ULL, 0x0000000000000003ULL,
0x2200288080909200ULL, 0x0000001cffffffffULL, 0x000001a800000000ULL, 0x0001ab9000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x00000054ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080880828808081ULL,
0x90082880808c0828ULL, 0x2880809a08288080ULL, 0x8092082880809b08ULL, 0x1028808280162880ULL,
0x0000000000000003ULL, 0x2200288080929200ULL, 0x0000002cffffffffULL, 0x0000023000000000ULL,
0x0001abd000000000ULL, 0x0000013000000000ULL, 0x0000180400000000ULL, 0x8090288080920900ULL,
0x0000000000002880ULL, 0x0000001800082f04ULL, 0x00082304000000ddULL, 0x0000000000000014ULL,
0x0000001400081204ULL, 0x0008110400000000ULL, 0x0000000000000014ULL, 0x0000001300082304ULL,
0x0008120400000000ULL, 0x0000000000000013ULL, 0x0000001300081104ULL, 0x0008230400000000ULL,
0x0000000000000012ULL, 0x0000001200081204ULL, 0x0008110400000000ULL, 0x0000000000000012ULL,
0x0000001100082304ULL, 0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000001100081104ULL,
0x0008230400000000ULL, 0x0000000000000018ULL, 0x0000001800081204ULL, 0x0008110400000000ULL,
0x0000000000000018ULL, 0x0000007b00043704ULL, 0x00080a0400003501ULL, 0x0050016000000015ULL,
0x000c170400501903ULL, 0x0048000600000000ULL, 0x000c17040021f000ULL, 0x0040000500000000ULL,
0x000c17040021f000ULL, 0x0038000400000000ULL, 0x000c17040011f000ULL, 0x0018000300000000ULL,
0x000c17040081f000ULL, 0x0010000200000000ULL, 0x000c17040021f000ULL, 0x0008000100000000ULL,
0x000c17040021f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0x0000002000043104ULL,
0xffffffff01cc2904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0000010001cc2804ULL, 0x0000036000000120ULL,
0x0000287000001690ULL, 0x000029f000002900ULL, 0x00002d7000002b60ULL, 0x00002e0000002da0ULL,
0x000033b000002e60ULL, 0x000041c000004190ULL, 0x0000428000004220ULL, 0x00005810000046e0ULL,
0x000059b0000058a0ULL, 0x00005d2000005b10ULL, 0x00005db000005d50ULL, 0x000060a000005e10ULL,
0x00006eb000006e80ULL, 0x00006f7000006f10ULL, 0x000083a000007270ULL, 0x0000853000008420ULL,
0x000088a000008690ULL, 0x00008930000088d0ULL, 0x00008c2000008990ULL, 0x00009a3000009a00ULL,
0x00009af000009a90ULL, 0x0000af2000009df0ULL, 0x0000b0b00000afa0ULL, 0x0000b4200000b210ULL,
0x0000b4b00000b450ULL, 0x0000b7d00000b510ULL, 0x0000c5e00000c5b0ULL, 0x0000c6a00000c640ULL,
0x0000cb400000cb30ULL, 0x0000ec700000d2a0ULL, 0x0000f3000000eca0ULL, 0x0000f9d00000f340ULL,
0x00018ce000018ca0ULL, 0x00018d0000018cf0ULL, 0x00018d7000018d10ULL, 0x00018db000018d90ULL,
0x00019a8000019a20ULL, 0x00019b3000019ae0ULL, 0x00019bf000019b90ULL, 0x00019cc000019c60ULL,
0x00019d8000019d20ULL, 0x00019e3000019de0ULL, 0x00019ef000019e90ULL, 0x00019fc000019f60ULL,
0x0001a0800001a020ULL, 0x0001a1200001a0d0ULL, 0x0001a1e00001a180ULL, 0x0001a2b00001a250ULL,
0x0001a3700001a310ULL, 0x0001a4200001a3d0ULL, 0x0001a4e00001a480ULL, 0x0001a5b00001a550ULL,
0x0001a6900001a620ULL, 0x0001a7900001a710ULL, 0x0001a8900001a810ULL, 0x0001a9900001a910ULL,
0x000001f002003904ULL, 0x0001c600000000ffULL, 0x00000260003f0100ULL, 0x0001c6080000000fULL,
0x00000320003f0120ULL, 0x0001c6880000000fULL, 0x000004b0003f0120ULL, 0x0001c600000000ffULL,
0x00000630003f0107ULL, 0x0001c68c00000002ULL, 0x000006c0003f0102ULL, 0x0001c68800000002ULL,
0x000025a0003f0101ULL, 0x0001c60800000002ULL, 0x000025c0003f0101ULL, 0x0001c60c00000002ULL,
0x00002790003f0105ULL, 0x0001c60c00000002ULL, 0x000046a0003f0105ULL, 0x0001c688000000ffULL,
0x00005590003f0101ULL, 0x0001c62800000002ULL, 0x000055b0003f0101ULL, 0x0001c62c00000002ULL,
0x00005780003f0105ULL, 0x0001c62c00000002ULL, 0x00007240003f0105ULL, 0x0001c690000000ffULL,
0x00008120003f0101ULL, 0x0001c64800000002ULL, 0x00008140003f0101ULL, 0x0001c64c00000002ULL,
0x00008310003f0105ULL, 0x0001c64c00000002ULL, 0x00009dc0003f0105ULL, 0x0001c698000000ffULL,
0x0000aca0003f0101ULL, 0x0001c66800000002ULL, 0x0000acc0003f0101ULL, 0x0001c66c00000002ULL,
0x0000ae90003f0105ULL, 0x0001c66c00000002ULL, 0x0000c970003f0105ULL, 0x0001c6a0000000ffULL,
0x0000fd50003f0101ULL, 0x0001c600000000ffULL, 0x00011990003f0101ULL, 0x0001c604000000ffULL,
0x00011b60003f0105ULL, 0x0001c604000000ffULL, 0x000181d0003f0105ULL, 0x00000000000000d6ULL,
0x000181f0003f0101ULL, 0x00000004000000d6ULL, 0x000183c0003f0105ULL, 0x00000004000000d6ULL,
0x00019870003f0105ULL, 0x0001c608000000d7ULL, 0x000198d0003f0101ULL, 0x0001c610000000d7ULL,
0x00019930003f0101ULL, 0x0001c618000000d7ULL, 0x000199a0003f0101ULL, 0x0001c620000000d7ULL,
0x00033803003f0101ULL, 0x0000fc5000101c04ULL, 0x00011c5000011bc0ULL, 0x00000401000199e0ULL,
0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x00000000000002a4ULL, 0x0000001800000002ULL, 0x000000000000021cULL,
0x0000001800000002ULL, 0x0000000000000194ULL, 0x0000001800000002ULL, 0x00000000000000f4ULL,
0x0000001800000002ULL, 0x0000000000000044ULL, 0x0000001800000002ULL, 0x0000000000000281ULL,
0x0000001800000002ULL, 0x00000000000001f9ULL, 0x0000001800000002ULL, 0x000000000000016cULL,
0x0000001800000002ULL, 0x00000000000000cbULL, 0x0000001800000002ULL, 0x000000000001c700ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x00000000000f7919ULL, 0x000e620000002100ULL,
0x0000000000117806ULL, 0x000fe200038e0000ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x00000000000b7919ULL, 0x000ea20000002300ULL, 0x0000001100047300ULL, 0x000fe200000e0000ULL,
0x0000000304057899ULL, 0x000fe4000800063fULL, 0x0000000000007919ULL, 0x000ea20000002200ULL,
0x0000460000067ab9ULL, 0x000fc60000000a00ULL, 0x0000000000097919ULL, 0x000ee20000000000ULL,
0x0000001100157309ULL, 0x000f260000000000ULL, 0x0000000000057919ULL, 0x000ee80000000000ULL,
0x0000000000127919ULL, 0x000ee20000002600ULL, 0x00000005ff0a7819ULL, 0x002fc6000001160fULL,
0x0000000000da7919ULL, 0x000e620000002700ULL, 0x000000ffff157224ULL, 0x010fc600078e0a15ULL,
0x00001fff0a0a7589ULL, 0x000fe200000e0000ULL, 0x000001000b007a24ULL, 0x004fc600078e0200ULL,
0x00001fff0b0b7589ULL, 0x000ea200000e0000ULL, 0x00000000000f7a24ULL, 0x000fe200078e020fULL,
0x000000090400720cULL, 0x008fe20003f02070ULL, 0x0000001005107824ULL, 0x000fc600078e00ffULL,
0x000000ff0f00720cULL, 0x040fe40003f25270ULL, 0x0000000f0f00780cULL, 0x040fe20003f44070ULL,
0x0000000812097824ULL, 0x000fe200078e00ffULL, 0x0000007f0f00780cULL, 0x000fe40003f64070ULL,
0x000001f010117812ULL, 0x000fce00078ec0ffULL, 0x3fffff80ff029424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff039424ULL, 0x000fe400078e00ffULL, 0x000000040b007824ULL, 0x004fe400078e020aULL,
0x3fffffc0ff06a424ULL, 0x000fe200078e00ffULL, 0x01c60002ff009388ULL, 0x0005e20000000a00ULL,
0x0000000200047824ULL, 0x000fe200078e00ffULL, 0x000000030f00780cULL, 0x000fe20003f24070ULL,
0x7fffffc0ff07a424ULL, 0x000fc400078e00ffULL, 0x0000000104007824ULL, 0x040fe200078e0205ULL,
0x00000001040c7810ULL, 0x040fe20007ffe0ffULL, 0x00000020040d7824ULL, 0x040fe200078e00ffULL,
0x01c608060f00a388ULL, 0x0007e20000008a00ULL, 0xff317217ff14b424ULL, 0x000fe200078e00ffULL,
0x0000000804037817ULL, 0x004fe20007800000ULL, 0x000000200c137824ULL, 0x000fe200078e00ffULL,
0xffffffe00d0e7812ULL, 0x000fe200078ee200ULL, 0x00000005da007c24ULL, 0x002fe2000f8e0209ULL,
0x01c400140f00b388ULL, 0x000fe20000004800ULL, 0x3fffff60ff089424ULL, 0x000fe200078e00ffULL,
0x00000000000579c3ULL, 0x000e620000002500ULL, 0x7fffff60ff099424ULL, 0x000fc400078e00ffULL,
0x0000000100027824ULL, 0x140fe400078e0204ULL, 0x00000200ff077424ULL, 0x008fe200078e00ffULL,
0x01c688080f009388ULL, 0x000fe20000008a00ULL, 0x00000001030d7824ULL, 0x000fe400078e0a04ULL,
0x0000000100067824ULL, 0x000fe400078e020cULL, 0x00005c0002027625ULL, 0x080fe200078e0007ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00005c0006067625ULL, 0x000fe200078e0007ULL,
0x000000ff0d00720cULL, 0x000fc40003f23070ULL, 0x000000010d00780cULL, 0x000fe20003f43070ULL,
0x000000010c007824ULL, 0x000fe200078e0205ULL, 0x00000011020c7210ULL, 0x080fe20007f7e0ffULL,
0x000000100e0f7824ULL, 0x000fe200078e00ffULL, 0x0000001106067210ULL, 0x000fe20007f9e0ffULL,
0x00000005ff097e24ULL, 0x002fe2000f8e00ffULL, 0xffffffe013007812ULL, 0x000fe200078ee200ULL,
0x000000ffff0d7224ULL, 0x000fe400018e0603ULL, 0x000000ffff077224ULL, 0x000fe400020e0607ULL,
0x0000001000117824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c0f7faeULL, 0x0003e2000c901c46ULL, 0x000000ffff007224ULL, 0x000fc400078e0015ULL,
0x00000004ff137424ULL, 0x000fe200078e00ffULL, 0x0000000006117faeULL, 0x0003e6000d101c46ULL,
0x00006200da027625ULL, 0x000fe200078e0013ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x01c60400ffff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01c60000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000602087981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0b00720cULL, 0x000fc40003f05270ULL, 0x0000003f08b77810ULL, 0x044fe40007ffe0ffULL,
0x000000ff08077810ULL, 0x002fe40007ffe0ffULL, 0x00000006ffb77819ULL, 0x000fe400000116b7ULL,
0x00000008ff077819ULL, 0x000fca0000011607ULL, 0x0000f6c000008947ULL, 0x000fea0003800000ULL,
0x0000000409007824ULL, 0x000fe400078e00ffULL, 0x000000080a027824ULL, 0x000fe400078e00ffULL,
0x00000003ff0b7424ULL, 0x000fe200078e00ffULL, 0x000000b70000720cULL, 0x000fda0003f06070ULL,
0x0000640000048a10ULL, 0x000fe20007ffe0ffULL, 0x00000002da038824ULL, 0x000fc800078e00ffULL,
0x0000640003048a24ULL, 0x000fe400078e0204ULL, 0xffffffffff037424ULL, 0x000fe200078e00ffULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01c68c0b02ff738cULL, 0x0003e20000000000ULL,
0x00006000040c8625ULL, 0x000fe200078e0013ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000060c038981ULL, 0x000ea2000c1e1900ULL, 0x0000000109047810ULL, 0x000fc60007ffe0ffULL,
0x01c6880002ff7f8cULL, 0x0007e2000c80043fULL, 0x000000070400720cULL, 0x000fe20003f06070ULL,
0x0000004012047824ULL, 0x000fe400078e00ffULL, 0x0000580003067a24ULL, 0x004fc800078e02ffULL,
0x0000004006237824ULL, 0x000fcc00078e00ffULL, 0x0000073000008947ULL, 0x000fea0003800000ULL,
0x00000100090b7824ULL, 0x00afe200078e00ffULL, 0x00000003ff117819ULL, 0x000fc80000011605ULL,
0x0000000b08067217ULL, 0x000fe40007800000ULL, 0x0000000811157810ULL, 0x040fe40007ffe0ffULL,
0x0000000411137810ULL, 0x040fe20007ffe0ffULL, 0x0000000106067824ULL, 0x000fe200078e0a0bULL,
0x0000001011187810ULL, 0x040fe20007ffe0ffULL, 0x00000040120b7824ULL, 0x000fe200078e0211ULL,
0x0000000c11177810ULL, 0x000fe20007ffe0ffULL, 0x00000001150d7824ULL, 0x100fe200078e0205ULL,
0x0000001411197810ULL, 0x000fe20007ffe0ffULL, 0x00000008151e7824ULL, 0x000fe200078e00ffULL,
0x0000000b23107210ULL, 0x000fe20007f1e0ffULL, 0x00000001130c7824ULL, 0x000fe200078e0205ULL,
0x000000100b127810ULL, 0x000fe20007ffe0ffULL, 0x00000008130f7824ULL, 0x000fe200078e00ffULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee20dULL, 0x00000001180e7824ULL, 0x140fe200078e0205ULL,
0x000000140b147810ULL, 0x000fe20007ffe0ffULL, 0x00000008181d7824ULL, 0x000fe200078e00ffULL,
0xfffffff80f1c7812ULL, 0x000fe200078ee20cULL, 0x00000001170d7824ULL, 0x100fe200078e0205ULL,
0x000000180b167810ULL, 0x000fe20007ffe0ffULL, 0x0000000817207824ULL, 0x000fe200078e00ffULL,
0xfffffff81d227812ULL, 0x000fe200078ee20eULL, 0x00000001190f7824ULL, 0x000fe200078e0205ULL,
0x000000040b0e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000819247824ULL, 0x000fe200078e00ffULL,
0xfffffff820207812ULL, 0x000fe200078ee20dULL, 0x000000ffff1b7224ULL, 0x000fe200000e06ffULL,
0x00005e00100c7a11ULL, 0x000fc400078048ffULL, 0xfffffff824247812ULL, 0x000fe400078ee20fULL,
0x00005f00100d7a11ULL, 0x000fe400000f4c1bULL, 0x00000018111b7810ULL, 0x000fe40007ffe0ffULL,
0x000000080b0f7810ULL, 0x000fe40007ffe0ffULL, 0x0000000e23287210ULL, 0x000fe20007f9e0ffULL,
0x000000081b267824ULL, 0x000fe200078e00ffULL, 0x0000000c0b107810ULL, 0x000fc40007ffe0ffULL,
0x0000001c0b1a7810ULL, 0x000fe20007ffe0ffULL, 0x000000011b0b7824ULL, 0x000fe200078e0205ULL,
0x0000000f231d7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200020e06ffULL,
0x0000001c11217810ULL, 0x000fe40007ffe0ffULL, 0x00005e00280e7a11ULL, 0x000fe400078c48ffULL,
0xfffffff826267812ULL, 0x000fe200078ee20bULL, 0x00000001210b7824ULL, 0x040fe200078e0205ULL,
0x00005f00280f7a11ULL, 0x000fe200030f4c0fULL, 0x0000000821287824ULL, 0x000fe200078e00ffULL,
0x0000001223297210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff127224ULL, 0x000fe200010e06ffULL,
0x00000010231f7210ULL, 0x000fc40007f1e0ffULL, 0xfffffff828287812ULL, 0x000fe200078ee20bULL,
0x00000001110b7824ULL, 0x000fe200078e0205ULL, 0x0000002006067817ULL, 0x000fe40003800000ULL,
0x0000001423277210ULL, 0x040fe40007f7e0ffULL, 0x0000001623257210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff167224ULL, 0x000fe200000e06ffULL, 0x00005e001d107a11ULL, 0x000fe400078c48ffULL,
0x0000001a23237210ULL, 0x000fe20007f9e0ffULL, 0x000000080a1a7824ULL, 0x000fe200078e00ffULL,
0x000000070b147812ULL, 0x000fe200078ec0ffULL, 0x000000ffff2c7224ULL, 0x000fe200028e06ffULL,
0x000000061100720cULL, 0x000fe20003f46070ULL, 0x000000ffff2a7224ULL, 0x000fe200020e06ffULL,
0x00005f001d117a11ULL, 0x000fc400030f4c12ULL, 0x00005e001f127a11ULL, 0x000fe400078c48ffULL,
0x000140000a1d7811ULL, 0x000fe400078e68ffULL, 0x0ffffff814147812ULL, 0x100fe400078ef805ULL,
0xfffffff81a0b7812ULL, 0x000fe200078ee205ULL, 0x000000ffff1a7224ULL, 0x000fe200018e06ffULL,
0x000000061300720cULL, 0x080fe40003f06070ULL, 0x00005f001f137a11ULL, 0x000fe200030f4c16ULL,
0x00000010141f7824ULL, 0x000fe200078e021dULL, 0x00005e0029147a11ULL, 0x000fe200078c48ffULL,
0x000000ffff167224ULL, 0x000fe200008e06ffULL, 0x000000061500720cULL, 0x080fe20003f26070ULL,
0x000000100b0c7825ULL, 0x000fe200078e000cULL, 0x000000061700720cULL, 0x000fc40003f66070ULL,
0x00005f0029157a11ULL, 0x000fe200030f4c16ULL, 0x0000001026297824ULL, 0x100fe200078e021dULL,
0x00005e0027167a11ULL, 0x000fe200078c48ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c1f7faeULL, 0x0003e2000d101c46ULL, 0x000000061800720cULL, 0x000fe40003f46070ULL,
0x00005e0025187a11ULL, 0x000fe400078a48ffULL, 0x00005f0027177a11ULL, 0x000fe200030f4c1aULL,
0x0000001024277824ULL, 0x000fe200078e021dULL, 0x00005e00231a7a11ULL, 0x000fc400078c48ffULL,
0x000000061900720cULL, 0x080fe40003f86070ULL, 0x00005f0025197a11ULL, 0x000fe200028f4c2cULL,
0x000000101c1f7824ULL, 0x002fe200078e021dULL, 0x000000061b00720cULL, 0x080fe20003fa6070ULL,
0x000000100b0c7825ULL, 0x000fe200078e000eULL, 0x00005f00231b7a11ULL, 0x000fe400030f4c2aULL,
0x000000062100720cULL, 0x000fe20003fc6070ULL, 0x000000101e217824ULL, 0x000fe200078e021dULL,
0x000000000c1f7faeULL, 0x0003e2000c101c46ULL, 0x000000100b0e7825ULL, 0x000fc800078e0010ULL,
0x0000001020237824ULL, 0x000fe200078e021dULL, 0x000000000e217faeULL, 0x0003e2000c901c46ULL,
0x000000100b107825ULL, 0x000fc800078e0012ULL, 0x0000001022257824ULL, 0x000fe200078e021dULL,
0x0000000010237faeULL, 0x0003e2000d901c46ULL, 0x000000100b127825ULL, 0x000fc800078e0014ULL,
0x000000100b147825ULL, 0x040fe200078e0016ULL, 0x0000000012257faeULL, 0x0003e6000d101c46ULL,
0x000000100b167825ULL, 0x040fe200078e0018ULL, 0x0000000014277faeULL, 0x0003e6000e101c46ULL,
0x00000010281d7824ULL, 0x000fe200078e021dULL, 0x0000000016297faeULL, 0x0003e2000e901c46ULL,
0x000000100b187825ULL, 0x000fca00078e001aULL, 0x00000000181d7faeULL, 0x0003e2000f101c46ULL,
0x0000065000007947ULL, 0x000fea0003800000ULL, 0x00000004050b7811ULL, 0x04afe400078fe8ffULL,
0x0000000c050f7811ULL, 0x040fe400078fe8ffULL, 0x00000008050e7811ULL, 0x000fe200078fe8ffULL,
0x000000010b067824ULL, 0x100fe200078e0205ULL, 0x0000001405157811ULL, 0x000fe200078fe8ffULL,
0x000000080b117824ULL, 0x000fe200078e00ffULL, 0x0000001805177811ULL, 0x000fe200078fe8ffULL,
0x000000010f0d7824ULL, 0x140fe200078e0205ULL, 0x000140000a297811ULL, 0x000fe200078e68ffULL,
0x000000080f127824ULL, 0x000fe200078e00ffULL, 0xfffffff811107812ULL, 0x000fe200078ee206ULL,
0x000000010e0c7824ULL, 0x040fe200078e0205ULL, 0x0000000405067211ULL, 0x000fe200078fe8ffULL,
0x000000080e137824ULL, 0x000fe200078e00ffULL, 0xfffffff812127812ULL, 0x000fe200078ee20dULL,
0x00000001150d7824ULL, 0x100fe200078e0205ULL, 0x0000000623197210ULL, 0x000fe20007f1e0ffULL,
0x0000000815167824ULL, 0x000fe200078e00ffULL, 0xfffffff813117812ULL, 0x000fe200078ee20cULL,
0x0000000117187824ULL, 0x000fe200078e0205ULL, 0x0000001005137811ULL, 0x000fe200078fe8ffULL,
0x000000ffff1a7224ULL, 0x000fe200000e06ffULL, 0x00005e00190c7a11ULL, 0x000fe200078048ffULL,
0x00000008171d7824ULL, 0x000fe200078e00ffULL, 0xfffffff816167812ULL, 0x000fe200078ee20dULL,
0x0000000113067824ULL, 0x000fe200078e0205ULL, 0x00005f00190d7a11ULL, 0x000fe200000f4c1aULL,
0x00000008131b7824ULL, 0x000fe200078e00ffULL, 0x0000001c05197811ULL, 0x000fe200078fe8ffULL,
0x00000001040b7824ULL, 0x040fe200078e020bULL, 0xfffffff81d187812ULL, 0x000fe200078ee218ULL,
0x00000001040f7824ULL, 0x040fe200078e020fULL, 0xfffffff81b147812ULL, 0x000fe200078ee206ULL,
0x00000001041a7824ULL, 0x040fe200078e0219ULL, 0x0000000505067211ULL, 0x000fe200078fe8ffULL,
0x00000001040e7824ULL, 0x040fe200078e020eULL, 0x0000000b231d7210ULL, 0x040fe20007fde0ffULL,
0x0000000104137824ULL, 0x000fe200078e0213ULL, 0x0000000706067812ULL, 0x000fe200078ec0ffULL,
0x0000000104157824ULL, 0x040fe200078e0215ULL, 0x0000000f23227210ULL, 0x000fe20007f9e0ffULL,
0x00000001190b7824ULL, 0x000fe200078e0205ULL, 0x0000001a231b7210ULL, 0x000fe20007f3e0ffULL,
0x0000000819267824ULL, 0x000fe200078e00ffULL, 0x0000000e23247210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff1a7224ULL, 0x000fe200030e06ffULL, 0x00005e001d0e7a11ULL, 0x000fe200078c48ffULL,
0x0000000104177824ULL, 0x000fe200078e0217ULL, 0x0000001323207210ULL, 0x000fe20007f7e0ffULL,
0x0000001012217824ULL, 0x000fe200078e0229ULL, 0x0ffffff806067812ULL, 0x000fe200078ef805ULL,
0x00000010111f7824ULL, 0x000fe200078e0229ULL, 0x00000015231e7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff157224ULL, 0x000fe200020e06ffULL, 0xfffffff826137812ULL, 0x000fe200078ee20bULL,
0x00000010060b7824ULL, 0x100fe200078e0229ULL, 0x00005f001d0f7a11ULL, 0x000fe200030f4c1aULL,
0x000000080a1a7824ULL, 0x000fe200078e00ffULL, 0x00005e0022127a11ULL, 0x000fe200078848ffULL,
0x00000010101d7824ULL, 0x100fe200078e0229ULL, 0x00000017231c7210ULL, 0x000fe20007f5e0ffULL,
0x0000001014237824ULL, 0x000fe200078e0229ULL, 0xfffffff81a2b7812ULL, 0x000fe200078ee205ULL,
0x0000001016257824ULL, 0x000fc400078e0229ULL, 0x0000001018277824ULL, 0x100fe400078e0229ULL,
0x000000ffff117224ULL, 0x000fe200028e06ffULL, 0x00005e0024107a11ULL, 0x000fe200078a48ffULL,
0x0000001013297824ULL, 0x000fe200078e0229ULL, 0x00005f0022137a11ULL, 0x000fe200020f4c15ULL,
0x000000ffff157224ULL, 0x000fe200018e06ffULL, 0x00005e0020147a11ULL, 0x000fe200078648ffULL,
0x000000ffff177224ULL, 0x000fe200000e06ffULL, 0x00005e001e167a11ULL, 0x000fe200078048ffULL,
0x000000ffff197224ULL, 0x000fe200010e06ffULL, 0x00005f0024117a11ULL, 0x000fe200028f4c11ULL,
0x000000ffff067224ULL, 0x000fe200008e06ffULL, 0x00005e001c187a11ULL, 0x000fe200078448ffULL,
0x000000102b0c7825ULL, 0x000fe200078e000cULL, 0x00005e001b1a7a11ULL, 0x000fc400078248ffULL,
0x00005f0020157a11ULL, 0x000fe200018f4c15ULL, 0x000000102b0e7825ULL, 0x040fe200078e000eULL,
0x00005f001e177a11ULL, 0x000fe200000f4c17ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c0b7faeULL, 0x0003e2000b901c46ULL, 0x00005f001c197a11ULL, 0x000fe200010f4c19ULL,
0x000000102b107825ULL, 0x000fe200078e0010ULL, 0x00005f001b1b7a11ULL, 0x000fe200008f4c06ULL,
0x000000000e1d7faeULL, 0x0003e4000b901c46ULL, 0x000000102b127825ULL, 0x040fe400078e0012ULL,
0x00000000101f7faeULL, 0x0003e4000b901c46ULL, 0x000000102b147825ULL, 0x000fc400078e0014ULL,
0x0000000012217faeULL, 0x0003e4000b901c46ULL, 0x000000102b167825ULL, 0x040fe400078e0016ULL,
0x0000000014237faeULL, 0x0003e4000b901c46ULL, 0x000000102b187825ULL, 0x040fe400078e0018ULL,
0x0000000016257faeULL, 0x0003e4000b901c46ULL, 0x000000102b1a7825ULL, 0x000fc400078e001aULL,
0x0000000018277faeULL, 0x0003e8000b901c46ULL, 0x000000001a297faeULL, 0x0003e4000b901c46ULL,
0x000000070900720cULL, 0x000fe20003f06070ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xff317217ff337424ULL, 0x000fe200078e00ffULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x000000ffff067224ULL, 0x000fe200078e00ffULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x002fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000b3d000000947ULL, 0x000fea0003800000ULL, 0x00000002dada7824ULL, 0x000fe400078e00ffULL,
0x00006400ff0b7624ULL, 0x000fc400078e00ffULL, 0xff317217ff337424ULL, 0x000fe400078e00ffULL,
0x000000ffff477224ULL, 0x000fe400078e00ffULL, 0x00006400da0b7624ULL, 0x000fc400078e020bULL,
0x0000010009117824ULL, 0x020fca00078e00ffULL, 0x000000081100720cULL, 0x000fda0003f06070ULL,
0x0000b31000000947ULL, 0x000fea0003800000ULL, 0x0000000109107810ULL, 0x000fe20007ffe0ffULL,
0x0000580003037a24ULL, 0x000fe200078e02ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000000071000720cULL, 0x000fe20003f26070ULL, 0x0000004003277824ULL, 0x000fd800078e00ffULL,
0x0000074000009947ULL, 0x000fea0003800000ULL, 0x00000003ff1e7819ULL, 0x100fe40000011605ULL,
0x0000002004187810ULL, 0x000fe40007ffe0ffULL, 0x0000002009037811ULL, 0x000fe400078e40ffULL,
0x000000041e2a7810ULL, 0x040fe20007ffe0ffULL, 0x000000011e117824ULL, 0x000fe200078e0218ULL,
0x0000000308107217ULL, 0x000fe40007800000ULL, 0x000000081e2c7810ULL, 0x000fe20007ffe0ffULL,
0x000000012a137824ULL, 0x000fe200078e0205ULL, 0x0000001127117210ULL, 0x000fe20007f1e0ffULL,
0x0000000110037824ULL, 0x000fe200078e0a03ULL, 0x0000000c1e2e7810ULL, 0x000fe20007ffe0ffULL,
0x000000082a207824ULL, 0x000fe200078e00ffULL, 0x000000101e307810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff127224ULL, 0x000fe200000e06ffULL, 0x00005e0011107a11ULL, 0x040fe200078048ffULL,
0x000000012c1c7824ULL, 0x000fe200078e0205ULL, 0xfffffff8202b7812ULL, 0x000fe200078ee213ULL,
0x000000082c2d7824ULL, 0x000fe200078e00ffULL, 0x00005f0011117a11ULL, 0x000fe200000f4c12ULL,
0x000000011e127824ULL, 0x100fe200078e0205ULL, 0x0000000705137812ULL, 0x000fe200078ec0ffULL,
0x000000012e1f7824ULL, 0x040fe200078e0205ULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee21cULL,
0x000000082e227824ULL, 0x000fe200078e00ffULL, 0x00000007121c7812ULL, 0x000fe200078ec0ffULL,
0x000000012a127824ULL, 0x000fe200078e0218ULL, 0x0000002003037817ULL, 0x000fe20003800000ULL,
0x0000000102297824ULL, 0x000fe200078e0213ULL, 0x0ffffff81c1d7812ULL, 0x100fe200078ef805ULL,
0x0000000130207824ULL, 0x040fe200078e0205ULL, 0x0000001227137210ULL, 0x000fe20007f5e0ffULL,
0x0000000830317824ULL, 0x000fe200078e00ffULL, 0x000000031e00720cULL, 0x000fe20003f06070ULL,
0x0000001029107825ULL, 0x000fe200078e0010ULL, 0x000150000a287811ULL, 0x000fc400078e68ffULL,
0x000000141e327810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff1c7224ULL, 0x000fe200010e06ffULL,
0x00005e0013127a11ULL, 0x000fe200078448ffULL, 0x000000101d1d7824ULL, 0x000fe200078e0228ULL,
0x000000181e4c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000132217824ULL, 0x000fe200078e0205ULL,
0x00005f0013137a11ULL, 0x000fe200010f4c1cULL, 0x000000012c1c7824ULL, 0x100fe200078e0218ULL,
0x0000001c1e4e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000832247824ULL, 0x000fe200078e00ffULL,
0xfffffff8222f7812ULL, 0x000fe200078ee21fULL, 0x000000012e1e7824ULL, 0x000fe200078e0218ULL,
0x0000001c27267210ULL, 0x000fe20007f5e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000101d7faeULL, 0x0003e2000c101c46ULL, 0xfffffff831317812ULL, 0x000fe200078ee220ULL,
0x00000001301f7824ULL, 0x100fe200078e0218ULL, 0xfffffff8244d7812ULL, 0x000fe200078ee221ULL,
0x0000000132207824ULL, 0x100fe200078e0218ULL, 0x0000001e27247210ULL, 0x040fe20007f7e0ffULL,
0x000000014c217824ULL, 0x000fe200078e0218ULL, 0x00005e00261c7a11ULL, 0x000fe200078c48ffULL,
0x000000084c4f7824ULL, 0x000fe200078e00ffULL, 0x0000001f27227210ULL, 0x040fe20007f1e0ffULL,
0x000000014e1f7824ULL, 0x040fe200078e0205ULL, 0x0000002027237210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff117224ULL, 0x002fe200010e06ffULL, 0x0000002127257210ULL, 0x000fe20007fbe0ffULL,
0x000000084e207824ULL, 0x000fc400078e00ffULL, 0x000000014c107824ULL, 0x000fe200078e0205ULL,
0x00005f00261d7a11ULL, 0x000fe200030f4c11ULL, 0x000000ffff117224ULL, 0x000fe200018e06ffULL,
0x00005e00241e7a11ULL, 0x000fe200078c48ffULL, 0x000000ffff217224ULL, 0x000fe200000e06ffULL,
0xfffffff820517812ULL, 0x000fe200078ee21fULL, 0x000000014e187824ULL, 0x000fe200078e0218ULL,
0x000000032a00720cULL, 0x000fe20003f66070ULL, 0x000000102b2b7824ULL, 0x000fe200078e0228ULL,
0x00005f00241f7a11ULL, 0x000fe400030f4c11ULL, 0x00005e0022207a11ULL, 0x000fc400078c48ffULL,
0xfffffff84f4f7812ULL, 0x000fe200078ee210ULL, 0x0000001029107825ULL, 0x000fe200078e0012ULL,
0x00005f0022217a11ULL, 0x000fe400030f4c21ULL, 0x00005e0023227a11ULL, 0x000fe200078c48ffULL,
0x000000ffff127224ULL, 0x000fe200020e06ffULL, 0x0000001827187210ULL, 0x000fe20007f5e0ffULL,
0x00000000102b7faeULL, 0x0003e2000d901c46ULL, 0x000000032c00720cULL, 0x000fe40003f06070ULL,
0x00005f0023237a11ULL, 0x000fe200030f4c12ULL, 0x000000ffff127224ULL, 0x000fe200028e06ffULL,
0x00005e0025247a11ULL, 0x000fe200078a48ffULL, 0x000000ffff137224ULL, 0x000fe200010e06ffULL,
0x00005e0018267a11ULL, 0x000fc400078c48ffULL, 0x000000032e00720cULL, 0x080fe40003f66070ULL,
0x000000033000720cULL, 0x080fe20003f86070ULL, 0x0000001029107825ULL, 0x002fe200078e001cULL,
0x000000033200720cULL, 0x080fe40003f46070ULL, 0x00005f0025257a11ULL, 0x000fe200028f4c12ULL,
0x000000102f2b7824ULL, 0x000fe200078e0228ULL, 0x000000034c00720cULL, 0x000fe20003fa6070ULL,
0x00000010291c7825ULL, 0x000fe200078e0020ULL, 0x00005f0018277a11ULL, 0x000fc400030f4c13ULL,
0x000000034e00720cULL, 0x000fe20003fc6070ULL, 0x000000102d037824ULL, 0x000fe400078e0228ULL,
0x0000001029127825ULL, 0x000fc600078e001eULL, 0x0000000010037faeULL, 0x0003e2000c101c46ULL,
0x00000010312d7824ULL, 0x100fe400078e0228ULL, 0x000000104d2f7824ULL, 0x000fe200078e0228ULL,
0x00000000122b7faeULL, 0x0003e2000d901c46ULL, 0x00000010291e7825ULL, 0x000fc600078e0022ULL,
0x000000001c2d7faeULL, 0x0003e2000e101c46ULL, 0x000000104f317824ULL, 0x000fe400078e0228ULL,
0x0000001029207825ULL, 0x000fe200078e0024ULL, 0x000000001e2f7faeULL, 0x0003e6000d101c46ULL,
0x00000010514d7824ULL, 0x000fe200078e0228ULL, 0x0000000020317faeULL, 0x0003e2000e901c46ULL,
0x0000001029227825ULL, 0x000fca00078e0026ULL, 0x00000000224d7faeULL, 0x0003e2000f101c46ULL,
0x0000066000007947ULL, 0x000fea0003800000ULL, 0x00000008051d7811ULL, 0x040fe400078fe8ffULL,
0x0000000405107811ULL, 0x040fe400078fe8ffULL, 0x00000010051f7811ULL, 0x000fe200078fe8ffULL,
0x000000011d117824ULL, 0x100fe200078e0205ULL, 0x0000000c051e7811ULL, 0x000fe200078fe8ffULL,
0x000000081d287824ULL, 0x000fe200078e00ffULL, 0x0000001405217811ULL, 0x000fe200078fe8ffULL,
0x0000000110037824ULL, 0x000fe200078e0205ULL, 0x0000002004207810ULL, 0x000fe20007ffe0ffULL,
0x0000000810267824ULL, 0x000fe200078e00ffULL, 0xfffffff828287812ULL, 0x000fe200078ee211ULL,
0x000000011f117824ULL, 0x000fe200078e0205ULL, 0x0000001805237811ULL, 0x000fe200078fe8ffULL,
0x000000081f2c7824ULL, 0x000fe200078e00ffULL, 0xfffffff826267812ULL, 0x000fe200078ee203ULL,
0x000000011e037824ULL, 0x040fe200078e0205ULL, 0x0000001c05247811ULL, 0x000fe200078fe8ffULL,
0x000000081e2a7824ULL, 0x000fe200078e00ffULL, 0xfffffff82c2c7812ULL, 0x000fe200078ee211ULL,
0x0000000121117824ULL, 0x040fe200078e0205ULL, 0x000150000a4f7811ULL, 0x000fe200078e68ffULL,
0x00000008212e7824ULL, 0x000fe200078e00ffULL, 0xfffffff82a2a7812ULL, 0x000fe200078ee203ULL,
0x0000000110107824ULL, 0x000fe200078e0220ULL, 0x0000002005037211ULL, 0x000fe200078fe8ffULL,
0x0000000123137824ULL, 0x040fe200078e0205ULL, 0xfffffff82e2e7812ULL, 0x000fe200078ee211ULL,
0x0000000823307824ULL, 0x000fe200078e00ffULL, 0x0000000327117210ULL, 0x040fe20007f1e0ffULL,
0x0000000124297824ULL, 0x040fe200078e0205ULL, 0x0000001027037210ULL, 0x000fe20007f5e0ffULL,
0x0000000824327824ULL, 0x000fe200078e00ffULL, 0xfffffff830307812ULL, 0x000fe200078ee213ULL,
0x000000ffff1c7224ULL, 0x000fe200000e06ffULL, 0x00005e0011107a11ULL, 0x000fe200078048ffULL,
0x000000ffff187224ULL, 0x000fe200010e06ffULL, 0x00005e0003127a11ULL, 0x000fe200078448ffULL,
0x000000102a2d7824ULL, 0x100fe200078e024fULL, 0x00005f0011117a11ULL, 0x000fe200000f4c1cULL,
0x00000010282b7824ULL, 0x000fe200078e024fULL, 0x00005f0003137a11ULL, 0x000fe200010f4c18ULL,
0x000000011d037824ULL, 0x100fe200078e0220ULL, 0x00000005051c7211ULL, 0x040fe200078fe8ffULL,
0x000000011e187824ULL, 0x100fe200078e0220ULL, 0x0000000705517812ULL, 0x000fe200078ec0ffULL,
0x00000001211d7824ULL, 0x100fe200078e0220ULL, 0x000000071c227812ULL, 0x000fe200078ec0ffULL,
0x000000011f1c7824ULL, 0x100fe200078e0220ULL, 0x0000000327037210ULL, 0x000fe20007f9e0ffULL,
0x00000001231e7824ULL, 0x100fe200078e0220ULL, 0x0ffffff822227812ULL, 0x000fe200078ef805ULL,
0x00000001241f7824ULL, 0x000fe200078e0220ULL, 0x0000001c27217210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff207224ULL, 0x000fe200020e06ffULL, 0x00005e00031c7a11ULL, 0x000fe200078c48ffULL,
0x0000000102517824ULL, 0x000fe200078e0251ULL, 0x0000001827247210ULL, 0x040fe20007f1e0ffULL,
0x000000102c2f7824ULL, 0x000fe200078e024fULL, 0x0000001d27237210ULL, 0x000fe20007f5e0ffULL,
0x0000001051107825ULL, 0x000fe200078e0010ULL, 0x00005f00031d7a11ULL, 0x000fc400030f4c20ULL,
0x0000001f27187210ULL, 0x040fe20007fbe0ffULL, 0x0000001022037824ULL, 0x000fe200078e024fULL,
0x0000001e27257210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff1f7224ULL, 0x000fe200000e06ffULL,
0x00005e00241e7a11ULL, 0x040fe200078048ffULL, 0x000000ffff227224ULL, 0x000fe200018e06ffULL,
0x00005e0021207a11ULL, 0x040fe200078648ffULL, 0x000000ffff2a7224ULL, 0x000fe200010e06ffULL,
0x00005f00241f7a11ULL, 0x000fe200000f4c1fULL, 0x000000ffff287224ULL, 0x000fe200020e06ffULL,
0x00005f0021217a11ULL, 0x000fe200018f4c22ULL, 0x000000ffff277224ULL, 0x000fe200028e06ffULL,
0xfffffff832327812ULL, 0x000fe200078ee229ULL, 0x0000001026297824ULL, 0x000fe200078e024fULL,
0x00005e0023227a11ULL, 0x000fe200078048ffULL, 0x0000001051127825ULL, 0x000fe200078e0012ULL,
0x00005e0025247a11ULL, 0x000fe200078448ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010037faeULL, 0x0003e2000b901c46ULL, 0x00005e0018267a11ULL, 0x040fe200078648ffULL,
0x00000010511c7825ULL, 0x000fe200078e001cULL, 0x00005f0023237a11ULL, 0x000fe200000f4c2aULL,
0x0000000012297faeULL, 0x0003e2000b901c46ULL, 0x00005f0025257a11ULL, 0x000fe200010f4c28ULL,
0x00000010511e7825ULL, 0x040fe200078e001eULL, 0x00005f0018277a11ULL, 0x000fe200018f4c27ULL,
0x000000001c2b7faeULL, 0x0003e4000b901c46ULL, 0x0000001051207825ULL, 0x000fc400078e0020ULL,
0x000000001e2d7faeULL, 0x0003e4000b901c46ULL, 0x000000102e317824ULL, 0x000fe400078e024fULL,
0x0000001051227825ULL, 0x040fe200078e0022ULL, 0x00000000202f7faeULL, 0x0003e6000b901c46ULL,
0x00000010304d7824ULL, 0x000fe200078e024fULL, 0x0000000022317faeULL, 0x0003e2000b901c46ULL,
0x0000001051247825ULL, 0x000fc800078e0024ULL, 0x00000010324f7824ULL, 0x000fe200078e024fULL,
0x00000000244d7faeULL, 0x0003e2000b901c46ULL, 0x0000001051267825ULL, 0x000fca00078e0026ULL,
0x00000000264f7faeULL, 0x0003e4000b901c46ULL, 0x00000004ff117424ULL, 0x002fe200078e00ffULL,
0x0000000300107812ULL, 0x000fe200078ec0ffULL, 0x00000300ff037624ULL, 0x000fc600078e00ffULL,
0x000000031000780cULL, 0x000fe20003f05270ULL, 0xfffffffd11037424ULL, 0x000fca00078e0203ULL,
0x0000000103037807ULL, 0x000fca0004000000ULL, 0x0000000100007824ULL, 0x000fe400078e0203ULL,
0xffffffffff037424ULL, 0x000fc600078e00ffULL, 0x000000b70000720cULL, 0x000fda0003f06070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0000000100107824ULL, 0x000fc800078e020bULL,
0x0000600010107625ULL, 0x000fca00078e0011ULL, 0x0000000610037981ULL, 0x000324000c1e1900ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01c60800021c7f8cULL, 0x0004e4000c80043fULL, 0x0000000000107805ULL, 0x002fc40000015200ULL,
0x01c60c0002137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x00afe4000780481dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff187224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x00000012101f7210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09001f00780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401f00780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011413ULL,
0x0000001f12127211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000212127819ULL, 0x000fc80000001213ULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000118187810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01c60c0002137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe4000780481dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001005187824ULL, 0x000fe200078e00ffULL, 0x00000001ff107819ULL, 0x000fc80000011605ULL,
0x0000007018187812ULL, 0x000fe400078ec0ffULL, 0x0000000c10117812ULL, 0x000fca00078ec0ffULL,
0x0000000118187824ULL, 0x000fca00078e0211ULL, 0x01c00000181c7984ULL, 0x000e680000000800ULL,
0x01c20000181d7984ULL, 0x0006a20000000800ULL, 0x000000331c00720bULL, 0x002fe20003f1d000ULL,
0x000171827f007947ULL, 0x000fd8000b800000ULL, 0x0000000000107806ULL, 0x008fc800000e0100ULL,
0x0000ffff101f7812ULL, 0x000fe2000784c0ffULL, 0x0000045000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe20003f0e170ULL, 0x000000ffff707224ULL, 0x000fd400078e0033ULL,
0x000004100000a947ULL, 0x000fea0003800000ULL, 0x000000ff0a00720cULL, 0x000fe40003f45270ULL,
0x000000331c00720bULL, 0x000fe20003f74000ULL, 0x000171527f007947ULL, 0x000fd8000b800000ULL,
0x00000000001e7806ULL, 0x000fc400018e0100ULL, 0x0000001c33707209ULL, 0x000fe20007810000ULL,
0x0000035000017945ULL, 0x000fe20003800000ULL, 0x000099101e107816ULL, 0x000fc600000000ffULL,
0x01c400701800a388ULL, 0x0003e20000000800ULL, 0x000000ff1000720cULL, 0x000fda0003f45270ULL,
0x000003000000a947ULL, 0x000fea0003800000ULL, 0x8000007033107221ULL, 0x002fe20000010000ULL,
0x000000ff1eff7812ULL, 0x000fe2000784c0ffULL, 0x0000017000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL, 0x0000001000657308ULL, 0x0002ec0000000800ULL,
0x000001300000a947ULL, 0x000fea0003800000ULL, 0x00000002ff647819ULL, 0x000fe20000011605ULL,
0x000170c27f007947ULL, 0x000fea000b800000ULL, 0x00001f6465127589ULL, 0x00866400000e0000ULL,
0x0000001214147220ULL, 0x086fe40000410000ULL, 0x0000001215157220ULL, 0x080fe40000410000ULL,
0x000000120c0c7220ULL, 0x000fc40000410000ULL, 0x000000120d0d7220ULL, 0x080fe40000410000ULL,
0x0000001234347220ULL, 0x080fe40000410000ULL, 0x0000001235357220ULL, 0x080fe40000410000ULL,
0x0000001238387220ULL, 0x080fe40000410000ULL, 0x0000001239397220ULL, 0x080fe40000410000ULL,
0x0000001240407220ULL, 0x000fc40000410000ULL, 0x0000001241417220ULL, 0x080fe40000410000ULL,
0x000000123c3c7220ULL, 0x080fe40000410000ULL, 0x000000123d3d7220ULL, 0x080fe40000410000ULL,
0x0000001248487220ULL, 0x080fe40000410000ULL, 0x0000001249497220ULL, 0x080fe40000410000ULL,
0x0000001244447220ULL, 0x000fc40000410000ULL, 0x0000001245457220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff001eff7812ULL, 0x000fe2000784c0ffULL,
0x0000006506067220ULL, 0x008fd80000410000ULL, 0x000001300000a947ULL, 0x000fea0003800000ULL,
0x0000000805647811ULL, 0x000fe200078ff0ffULL, 0x00016fa27f007947ULL, 0x000fea000b800000ULL,
0x00001f6465127589ULL, 0x00066400000e0000ULL, 0x0000001216167220ULL, 0x086fe40000410000ULL,
0x0000001217177220ULL, 0x080fe40000410000ULL, 0x000000120e0e7220ULL, 0x080fe40000410000ULL,
0x000000120f0f7220ULL, 0x080fe40000410000ULL, 0x0000001236367220ULL, 0x080fe40000410000ULL,
0x0000001237377220ULL, 0x000fc40000410000ULL, 0x000000123a3a7220ULL, 0x080fe40000410000ULL,
0x000000123b3b7220ULL, 0x080fe40000410000ULL, 0x0000001242427220ULL, 0x080fe40000410000ULL,
0x0000001243437220ULL, 0x080fe40000410000ULL, 0x000000123e3e7220ULL, 0x080fe40000410000ULL,
0x000000123f3f7220ULL, 0x000fc40000410000ULL, 0x000000124a4a7220ULL, 0x080fe40000410000ULL,
0x000000124b4b7220ULL, 0x080fe40000410000ULL, 0x0000001246467220ULL, 0x080fe40000410000ULL,
0x0000001247477220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff1fff7812ULL, 0x000fda000784601eULL, 0x800000701c1c2221ULL, 0x000fe20000010000ULL,
0x000000000000281cULL, 0x000fc60003f0f070ULL, 0x3fb8aa3b1c1c2820ULL, 0x000fc80000410000ULL,
0x0000001c00192308ULL, 0x000e640000000800ULL, 0x000000191d1d2220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000017000007945ULL, 0x000fe20003800000ULL, 0x000000061d067221ULL, 0x004fe20000010000ULL,
0x0000014000008947ULL, 0x000fea0003800000ULL, 0x00000019ff10723eULL, 0x000fe400000010ffULL,
0x00000002ff1c7819ULL, 0x000fe40000011605ULL, 0x0000541010657816ULL, 0x008fe20000000010ULL,
0x00016de27f007947ULL, 0x000fea000b800000ULL, 0x00001f1c651b7589ULL, 0x0002a400000e0000ULL,
0x000000081c647810ULL, 0x002fe20007ffe0ffULL, 0x00016e227f007947ULL, 0x000fea000b800000ULL,
0x00001f64651a7589ULL, 0x0002e400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000101c647810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff137424ULL, 0x000fe200078e00ffULL,
0x00002e1000107802ULL, 0x000fe20000000f00ULL, 0xffffffffff127424ULL, 0x000fc400078e00ffULL,
0x00017d8000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000181c647810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff137424ULL, 0x000fe200078e00ffULL,
0x00002e7000107802ULL, 0x000fe20000000f00ULL, 0xffffffffff127424ULL, 0x004fc400078e00ffULL,
0x00017d2000007944ULL, 0x018fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000007051d7812ULL, 0x040fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000805107812ULL, 0x000fc400078ec0ffULL, 0x000000081d207812ULL, 0x000fc800078ef805ULL,
0x00000020052c7211ULL, 0x000fe200078fe0ffULL, 0x0000000820117824ULL, 0x000fca00078e00ffULL,
0xfffffff8111c7812ULL, 0x000fc800078ee22cULL, 0x000120001c117811ULL, 0x000fc800078e20ffULL,
0x0000000710227812ULL, 0x000fe200078ef805ULL, 0x0000580003717a24ULL, 0x010fe200078e02ffULL,
0x000000001110783bULL, 0x006e620000000200ULL, 0x000000022c237810ULL, 0x000fe40007ffe0ffULL,
0x00000022051e7211ULL, 0x000fe200078fe0ffULL, 0x00000008221f7824ULL, 0x040fe400078e00ffULL,
0x0000000822247824ULL, 0x000fe200078e00ffULL, 0x000000021e337810ULL, 0x000fe20007ffe0ffULL,
0x0000000822267824ULL, 0x000fe200078e00ffULL, 0x000000041e2d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000822217824ULL, 0x000fe200078e00ffULL, 0x000000061e2e7810ULL, 0x000fe20007ffe0ffULL,
0x0000004071717824ULL, 0x000fe200078e00ffULL, 0xfffffff81f1f7812ULL, 0x000fc400078ee21eULL,
0x000140000a1e7811ULL, 0x000fe400078e68ffULL, 0xfffffff824337812ULL, 0x000fe400078ee233ULL,
0xfffffff8262d7812ULL, 0x000fe200078ee22dULL, 0x0000000820267824ULL, 0x000fe200078e00ffULL,
0xfffffff8212e7812ULL, 0x000fe200078ee22eULL, 0x000000101f1f7824ULL, 0x100fe200078e021eULL,
0x0000001022247812ULL, 0x000fe200078efcffULL, 0x0000001033207824ULL, 0x100fe200078e021eULL,
0xfffffff826237812ULL, 0x000fe200078ee223ULL, 0x000000102d217824ULL, 0x100fe200078e021eULL,
0x000000001f4c783bULL, 0x000ea20000004200ULL, 0x000000102e227824ULL, 0x000fe200078e021eULL,
0x0000002405257211ULL, 0x000fe200078fe0ffULL, 0x0000000824327824ULL, 0x040fe200078e00ffULL,
0x000000002054783bULL, 0x000ee20000004200ULL, 0x0000000824267824ULL, 0x040fe200078e00ffULL,
0x0001200023287811ULL, 0x000fe200078e20ffULL, 0x0000000824277824ULL, 0x040fe200078e00ffULL,
0x00000000215c783bULL, 0x000fe20000004200ULL, 0x0000000824507824ULL, 0x000fe200078e00ffULL,
0x00000002252f7810ULL, 0x000fc40007ffe0ffULL, 0x000000002258783bULL, 0x000fe20000004200ULL,
0x0000000425307810ULL, 0x040fe20007ffe0ffULL, 0x0000001b10100231ULL, 0x082fe200003400ffULL,
0x0000000625317810ULL, 0x000fe20007ffe0ffULL, 0x000000002828783bULL, 0x000e620000000200ULL,
0xfffffff832327812ULL, 0x000fe200078ee225ULL, 0x0000001b12120231ULL, 0x000fe200003400ffULL,
0xfffffff8262f7812ULL, 0x000fe200078ee22fULL, 0x0000001a11110231ULL, 0x088fe200003400ffULL,
0xfffffff827307812ULL, 0x000fe200078ee230ULL, 0x0000001032247824ULL, 0x100fe200078e021eULL,
0xfffffff850317812ULL, 0x000fe200078ee231ULL, 0x000000102f257824ULL, 0x100fe200078e021eULL,
0x0000001a13130231ULL, 0x000fe200003400ffULL, 0x0000001030267824ULL, 0x100fe200078e021eULL,
0x000000002460783bULL, 0x000ee20000004200ULL, 0x0000001031277824ULL, 0x000fc600078e021eULL,
0x000000002568783bULL, 0x000ee80000004200ULL, 0x000000002664783bULL, 0x000ee80000004200ULL,
0x000000002750783bULL, 0x000ee20000004200ULL, 0x0000004c1014723cULL, 0x044f700000041814ULL,
0x0000004e100c723cULL, 0x040f70000004180cULL, 0x00000054104c723cULL, 0x000f620000041834ULL,
0x0000001b28280231ULL, 0x002fc400003400ffULL, 0x0000001b2a2a0231ULL, 0x000fe400003400ffULL,
0x0000001a29290231ULL, 0x080fe400003400ffULL, 0x0000001a2b2b0231ULL, 0x000fe200003400ffULL,
0x000000561054723cULL, 0x040ff00000041838ULL, 0x0000005c1040723cULL, 0x040f700000041840ULL,
0x0000005e103c723cULL, 0x040f70000004183cULL, 0x000000581048723cULL, 0x040f700000041848ULL,
0x0000005a1010723cULL, 0x000f700000041844ULL, 0x000000602838723cULL, 0x068b700000041814ULL,
0x000000622834723cULL, 0x040b70000004180cULL, 0x00000068285c723cULL, 0x040b70000004184cULL,
0x000000642860723cULL, 0x040b700000041840ULL, 0x0000006a2868723cULL, 0x040b700000041854ULL,
0x000000662858723cULL, 0x040b70000004183cULL, 0x000000502848723cULL, 0x040b700000041848ULL,
0x000000522840723cULL, 0x000b620000041810ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000071000009947ULL, 0x000fca0003800000ULL, 0x00000003ff177819ULL, 0x020fe20000011605ULL,
0x00000001023d7824ULL, 0x000fe200078e021dULL, 0x00000040090d7811ULL, 0x000fe400078e40ffULL,
0x0000000417137810ULL, 0x040fe40007ffe0ffULL, 0x0000000817157810ULL, 0x000fe40007ffe0ffULL,
0x0000000d080c7217ULL, 0x000fe20007800000ULL, 0x00000001130f7824ULL, 0x100fe200078e0205ULL,
0x0000000c17297810ULL, 0x000fe20007ffe0ffULL, 0x0000000813127824ULL, 0x000fe200078e00ffULL,
0x0000001417537810ULL, 0x000fe20007ffe0ffULL, 0x0000000115107824ULL, 0x000fe200078e0205ULL,
0x00000010174f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000815477824ULL, 0x000fe200078e00ffULL,
0xfffffff8122b7812ULL, 0x000fe200078ee20fULL, 0x000000010c0e7824ULL, 0x000fe200078e0a0dULL,
0x0000001817577810ULL, 0x000fe20007ffe0ffULL, 0x00000001290c7824ULL, 0x100fe200078e0205ULL,
0xfffffff847477812ULL, 0x000fe200078ee210ULL, 0x00000008294d7824ULL, 0x000fe200078e00ffULL,
0x0000001c17677810ULL, 0x000fe20007ffe0ffULL, 0x00000001530f7824ULL, 0x140fe200078e0205ULL,
0x000000200e3c7817ULL, 0x000fe20003800000ULL, 0x0000000853127824ULL, 0x000fe200078e00ffULL,
0xfffffff84d4d7812ULL, 0x000fe200078ee20cULL, 0x000000014f0d7824ULL, 0x000fe200078e0205ULL,
0x0000003c1500720cULL, 0x000fe20003fa6070ULL, 0x000000084f107824ULL, 0x000fe200078e00ffULL,
0xfffffff812557812ULL, 0x000fe200078ee20fULL, 0x00000001040c7824ULL, 0x000fc400078e0217ULL,
0x00000001570f7824ULL, 0x040fe200078e0205ULL, 0xfffffff810517812ULL, 0x000fe200078ee20dULL,
0x0000000857147824ULL, 0x000fe200078e00ffULL, 0x0000000c710d7210ULL, 0x000fe20007f5e0ffULL,
0x0000000104107824ULL, 0x000fe400078e0213ULL, 0x0000000167117824ULL, 0x040fe200078e0205ULL,
0xfffffff814657812ULL, 0x000fe200078ee20fULL, 0x0000000867167824ULL, 0x000fe200078e00ffULL,
0x00000010710f7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff127224ULL, 0x000fe200010e06ffULL,
0x00005e000d0c7a11ULL, 0x040fe200078448ffULL, 0x0000000104107824ULL, 0x000fe200078e0215ULL,
0xfffffff8166d7812ULL, 0x000fe200078ee211ULL, 0x000000ffff147224ULL, 0x000fe200018e06ffULL,
0x00005f000d0d7a11ULL, 0x000fe200010f4c12ULL, 0x0000000104127824ULL, 0x000fe200078e0229ULL,
0x0000001071117210ULL, 0x000fe20007f9e0ffULL, 0x000000102b457824ULL, 0x000fe200078e021eULL,
0x00005e000f0e7a11ULL, 0x000fe200078448ffULL, 0x000000103d0c7825ULL, 0x000fe200078e000cULL,
0x0000003c1300720cULL, 0x000fc40003f66070ULL, 0x00005f000f0f7a11ULL, 0x000fe200010f4c14ULL,
0x000000ffff167224ULL, 0x000fe200020e06ffULL, 0x00005e0011107a11ULL, 0x000fe200078448ffULL,
0x0000000104147824ULL, 0x040fe200078e024fULL, 0x0000001271137210ULL, 0x000fe20007f9e0ffULL,
0x000000103d0e7825ULL, 0x000fe200078e000eULL, 0x00005f0011117a11ULL, 0x000fe400010f4c16ULL,
0x0000001471157210ULL, 0x000fe20007fde0ffULL, 0x000000ffff167224ULL, 0x000fe200020e06ffULL,
0x00005e0013127a11ULL, 0x000fe200078448ffULL, 0x0000001047477824ULL, 0x000fe200078e021eULL,
0x0000003c1700720cULL, 0x040fe20003f86070ULL, 0x0000000117177824ULL, 0x000fe200078e0205ULL,
0x00005f0013137a11ULL, 0x000fe200010f4c16ULL, 0x000000ffff287224ULL, 0x000fe200030e06ffULL,
0x00005e0015147a11ULL, 0x000fe200078c48ffULL, 0x0000000104167824ULL, 0x000fe200078e0253ULL,
0x00000007172a7812ULL, 0x000fe200078ec0ffULL, 0x000000103d107825ULL, 0x000fe200078e0010ULL,
0x00005f0015157a11ULL, 0x000fc400030f4c28ULL, 0x0000003c2900720cULL, 0x000fe20003f46070ULL,
0x0000000104287824ULL, 0x000fe200078e0257ULL, 0x0000001671177210ULL, 0x000fe20007fde0ffULL,
0x000000104d4d7824ULL, 0x100fe200078e021eULL, 0x0ffffff82a297812ULL, 0x000fe200078ef805ULL,
0x0000001051517824ULL, 0x100fe400078e021eULL, 0x000000ffff2a7224ULL, 0x000fe200030e06ffULL,
0x00005e0017167a11ULL, 0x000fe200078c48ffULL, 0x00000010293f7824ULL, 0x100fe400078e021eULL,
0x0000001055557824ULL, 0x000fe200078e021eULL, 0x00005f0017177a11ULL, 0x000fe200030f4c2aULL,
0x00000001042a7824ULL, 0x000fe200078e0267ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c3f7faeULL, 0x0003e2000e101c46ULL, 0x0000002871297210ULL, 0x000fe20007f9e0ffULL,
0x0000001065657824ULL, 0x000fc400078e021eULL, 0x000000000e457faeULL, 0x0005e2000d901c46ULL,
0x0000002a712b7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff2a7224ULL, 0x000fe200020e06ffULL,
0x00005e0029287a11ULL, 0x000fe200078c48ffULL, 0x0000000010477faeULL, 0x0007e2000e901c46ULL,
0x0000003c4f00720cULL, 0x080fe20003f86070ULL, 0x000000ffff3e7224ULL, 0x000fe200018e06ffULL,
0x00005f0029297a11ULL, 0x000fe200030f4c2aULL, 0x000000103d0c7825ULL, 0x002fe200078e0012ULL,
0x00005e002b2a7a11ULL, 0x000fe400078648ffULL, 0x0000003c5300720cULL, 0x080fe20003fc6070ULL,
0x000000103d0e7825ULL, 0x004fe200078e0014ULL, 0x0000003c5700720cULL, 0x080fe20003fa6070ULL,
0x000000000c4d7faeULL, 0x0007e2000d101c46ULL, 0x00005f002b2b7a11ULL, 0x000fe200018f4c3eULL,
0x000000103d127825ULL, 0x000fe200078e0016ULL, 0x0000003c6700720cULL, 0x000fe20003f66070ULL,
0x000000000e517faeULL, 0x0007e4000e101c46ULL, 0x000000103d147825ULL, 0x000fc800078e0028ULL,
0x000000103d167825ULL, 0x000fe200078e002aULL, 0x0000000012557faeULL, 0x0007e6000f101c46ULL,
0x000000106d6d7824ULL, 0x000fe200078e021eULL, 0x0000000014657faeULL, 0x0007e8000e901c46ULL,
0x00000000166d7faeULL, 0x0007e2000d901c46ULL, 0x0000063000007947ULL, 0x000fea0003800000ULL,
0x0000000c05117811ULL, 0x060fe200078fe8ffULL, 0x00000001023d7824ULL, 0x000fe200078e021dULL,
0x0000001005177811ULL, 0x000fc400078fe8ffULL, 0x00000008050f7811ULL, 0x000fe200078fe8ffULL,
0x0000000111107824ULL, 0x100fe200078e0205ULL, 0x00000004050e7811ULL, 0x000fe200078fe8ffULL,
0x00000008114d7824ULL, 0x000fe200078e00ffULL, 0x00000018052a7811ULL, 0x000fe200078fe8ffULL,
0x0000000117127824ULL, 0x100fe200078e0205ULL, 0x0000001c052b7811ULL, 0x000fe200078fe8ffULL,
0x00000008174f7824ULL, 0x000fe200078e00ffULL, 0x0000001405297811ULL, 0x000fe200078fe8ffULL,
0x000000010f0d7824ULL, 0x100fe200078e0205ULL, 0xfffffff84d4d7812ULL, 0x000fe200078ee210ULL,
0x000000080f147824ULL, 0x000fe200078e00ffULL, 0xfffffff84f4f7812ULL, 0x000fe200078ee212ULL,
0x000000010e0c7824ULL, 0x040fe200078e0205ULL, 0x0000000505157211ULL, 0x000fe200078fe8ffULL,
0x000000080e457824ULL, 0x000fe200078e00ffULL, 0xfffffff814477812ULL, 0x000fe200078ee20dULL,
0x000000012a107824ULL, 0x000fc400078e0205ULL, 0x000000082a537824ULL, 0x000fe200078e00ffULL,
0xfffffff845457812ULL, 0x000fe200078ee20cULL, 0x000000012b127824ULL, 0x100fe200078e0205ULL,
0x00000004050c7211ULL, 0x000fe200078fe8ffULL, 0x000000082b557824ULL, 0x000fe200078e00ffULL,
0xfffffff853537812ULL, 0x000fe200078ee210ULL, 0x00000001290d7824ULL, 0x040fe400078e0205ULL,
0x0000000829147824ULL, 0x000fe200078e00ffULL, 0xfffffff855557812ULL, 0x000fe200078ee212ULL,
0x0000000104107824ULL, 0x000fc400078e020eULL, 0x0000000104127824ULL, 0x000fe200078e020fULL,
0xfffffff814517812ULL, 0x000fe200078ee20dULL, 0x0000000104147824ULL, 0x000fe200078e0211ULL,
0x000000710c0d7210ULL, 0x080fe20007f5e0ffULL, 0x00000001042a7824ULL, 0x000fe200078e022aULL,
0x00000071100f7210ULL, 0x080fe20007f7e0ffULL, 0x00000001043c7824ULL, 0x000fe200078e022bULL,
0x0000007112117210ULL, 0x080fe20007f9e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200010e06ffULL,
0x00005e000d0c7a11ULL, 0x040fe200078448ffULL, 0x000000ffff287224ULL, 0x000fe200018e06ffULL,
0x0000007114137210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff167224ULL, 0x000fe200020e06ffULL,
0x00005f000d0d7a11ULL, 0x000fe200010f4c0eULL, 0x0000001045457824ULL, 0x000fe200078e021eULL,
0x00005e0011107a11ULL, 0x000fe200078648ffULL, 0x000000ffff147224ULL, 0x000fe200028e06ffULL,
0x00005e000f0e7a11ULL, 0x000fe200078448ffULL, 0x000000103d0c7825ULL, 0x000fe200078e000cULL,
0x00005e0013127a11ULL, 0x000fc400078848ffULL, 0x00005f0011117a11ULL, 0x000fe200018f4c16ULL,
0x0000000104167824ULL, 0x040fe200078e0217ULL, 0x00005f000f0f7a11ULL, 0x000fe200010f4c28ULL,
0x0000000104287824ULL, 0x000fe200078e0229ULL, 0x00005f0013137a11ULL, 0x000fe200020f4c14ULL,
0x0000001047477824ULL, 0x000fe200078e021eULL, 0x0000000715147812ULL, 0x000fe200078ec0ffULL,
0x000000103d0e7825ULL, 0x040fe200078e000eULL, 0x0000007116157210ULL, 0x080fe40007f9e0ffULL,
0x0000007128177210ULL, 0x080fe20007fbe0ffULL, 0x000000103d107825ULL, 0x000fe200078e0010ULL,
0x000000712a297210ULL, 0x000fc40007f5e0ffULL, 0x000000713c2b7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff467224ULL, 0x000fe200020e06ffULL, 0x0ffffff8143f7812ULL, 0x000fe200078ef805ULL,
0x000000ffff447224ULL, 0x000fe200028e06ffULL, 0x00005e0015147a11ULL, 0x000fe200078848ffULL,
0x000000ffff3e7224ULL, 0x000fe200010e06ffULL, 0x00005e0017167a11ULL, 0x000fe200078a48ffULL,
0x000000ffff3c7224ULL, 0x000fe200018e06ffULL, 0x00005e0029287a11ULL, 0x000fe200078448ffULL,
0x000000103f3f7824ULL, 0x000fe200078e021eULL, 0x00005e002b2a7a11ULL, 0x000fe200078648ffULL,
0x000000103d127825ULL, 0x000fe200078e0012ULL, 0x00005f0015157a11ULL, 0x000fc400020f4c46ULL,
0x00005f0017177a11ULL, 0x000fe200028f4c44ULL, 0x000000104d4d7824ULL, 0x000fe200078e021eULL,
0x00005f0029297a11ULL, 0x000fe200010f4c3eULL, 0x000000103d147825ULL, 0x000fe200078e0014ULL,
0x00005f002b2b7a11ULL, 0x000fe200018f4c3cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c3f7faeULL, 0x0003e4000b901c46ULL, 0x000000104f4f7824ULL, 0x000fe400078e021eULL,
0x000000103d167825ULL, 0x000fe200078e0016ULL, 0x000000000e457faeULL, 0x0003e6000b901c46ULL,
0x0000001051517824ULL, 0x000fe200078e021eULL, 0x0000000010477faeULL, 0x0003e2000b901c46ULL,
0x000000103d287825ULL, 0x000fc600078e0028ULL, 0x00000000124d7faeULL, 0x0003e2000b901c46ULL,
0x0000001053537824ULL, 0x000fe400078e021eULL, 0x000000103d2a7825ULL, 0x000fe200078e002aULL,
0x00000000144f7faeULL, 0x0003e6000b901c46ULL, 0x0000001055557824ULL, 0x000fe200078e021eULL,
0x0000000016517faeULL, 0x0003e8000b901c46ULL, 0x0000000028537faeULL, 0x0003e8000b901c46ULL,
0x000000002a557faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000017000007945ULL, 0x000fe20003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000014000008947ULL, 0x000fea0003800000ULL, 0x00000019ff0c723eULL, 0x00afe400000010ffULL,
0x00000002ff0e7819ULL, 0x000fe40000011605ULL, 0x000054100c657816ULL, 0x000fe2000000000cULL,
0x00015a927f007947ULL, 0x000fea000b800000ULL, 0x00001f0e651b7589ULL, 0x0002a400000e0000ULL,
0x000000080e647810ULL, 0x002fe20007ffe0ffULL, 0x00015ad27f007947ULL, 0x000fea000b800000ULL,
0x00001f64651a7589ULL, 0x0002e400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000100e647810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff137424ULL, 0x000fe200078e00ffULL,
0x0000423000107802ULL, 0x000fe20000000f00ULL, 0xffffffffff127424ULL, 0x000fc400078e00ffULL,
0x0001696000007944ULL, 0x00cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000180e647810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff137424ULL, 0x000fe200078e00ffULL,
0x0000429000107802ULL, 0x000fe20000000f00ULL, 0xffffffffff127424ULL, 0x004fc400078e00ffULL,
0x0001690000007944ULL, 0x008fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000081d0d7812ULL, 0x00afe200078ef805ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000042c287810ULL, 0x000fc40007ffe0ffULL, 0x00000008050c7812ULL, 0x000fe200078ec0ffULL,
0x000000080d0f7824ULL, 0x000fca00078e00ffULL, 0xfffffff80f287812ULL, 0x000fc800078ee228ULL,
0x00012000284c7811ULL, 0x000fca00078e20ffULL, 0x000000070c0c7812ULL, 0x000fe200078ef805ULL,
0x000000004c4c783bULL, 0x000e620000000200ULL, 0x000010001e297810ULL, 0x000fe20007ffe0ffULL,
0x000000080d0d7824ULL, 0x000fe200078e00ffULL, 0x0000000c050e7211ULL, 0x000fe200078fe0ffULL,
0x000000080c0f7824ULL, 0x000fe200078e00ffULL, 0x000000062c0c7810ULL, 0x000fe20007ffe0ffULL,
0x00000010332a7824ULL, 0x100fe400078e0229ULL, 0x000000102d2b7824ULL, 0x100fe200078e0229ULL,
0xfffffff80f0e7812ULL, 0x000fe200078ee20eULL, 0x000000102e2c7824ULL, 0x100fe200078e0229ULL,
0x000000002a6c783bULL, 0x000ee20000004200ULL, 0xfffffff80d2e7812ULL, 0x000fe200078ee20cULL,
0x000000102f2f7824ULL, 0x000fc400078e0229ULL, 0x000000100e2d7824ULL, 0x100fe200078e0229ULL,
0x000000002b64783bULL, 0x000fe20000004200ULL, 0x000120002e0c7811ULL, 0x000fe200078e20ffULL,
0x0000001030307824ULL, 0x100fe400078e0229ULL, 0x000000002c50783bULL, 0x000fe20000004200ULL,
0x0000001031317824ULL, 0x100fe400078e0229ULL, 0x0000001032327824ULL, 0x000fe200078e0229ULL,
0x000000002d54783bULL, 0x000fe80000004200ULL, 0x000000000c0c783bULL, 0x000f280000000200ULL,
0x000000002f44783bULL, 0x000ea80000004200ULL, 0x00000000303c783bULL, 0x000ea80000004200ULL,
0x000000003114783bULL, 0x000ea40000004200ULL, 0x0000001b4c4c0231ULL, 0x006fc400003400ffULL,
0x0000001b4e4e0231ULL, 0x000fe200003400ffULL, 0x000000003210783bULL, 0x000e620000004200ULL,
0x0000001a4d4d0231ULL, 0x080fe400003400ffULL, 0x0000001a4f4f0231ULL, 0x000fce00003400ffULL,
0x0000006c4c5c723cULL, 0x048f70000004185cULL, 0x0000006e4c68723cULL, 0x000f620000041868ULL,
0x0000001b0c0c0231ULL, 0x010fce00003400ffULL, 0x000000644c60723cULL, 0x000f620000041860ULL,
0x0000001b0e0e0231ULL, 0x000fe400003400ffULL, 0x0000001a0d0d0231ULL, 0x080fe400003400ffULL,
0x0000001a0f0f0231ULL, 0x000fc600003400ffULL, 0x000000664c58723cULL, 0x040ff00000041858ULL,
0x000000504c48723cULL, 0x040f700000041848ULL, 0x000000524c64723cULL, 0x040f700000041840ULL,
0x000000544c50723cULL, 0x040f700000041838ULL, 0x000000564c4c723cULL, 0x000f700000041834ULL,
0x000000440c34723cULL, 0x060b70000004185cULL, 0x000000460c38723cULL, 0x040b700000041868ULL,
0x0000003c0c40723cULL, 0x040b700000041860ULL, 0x000000140c48723cULL, 0x040b700000041848ULL,
0x000000160c44723cULL, 0x040b700000041864ULL, 0x0000003e0c3c723cULL, 0x040b700000041858ULL,
0x000000100c14723cULL, 0x042b700000041850ULL, 0x000000120c0c723cULL, 0x000b62000004184cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x0000004009117811ULL, 0x020fe200078e40ffULL,
0x01c68800ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff337224ULL, 0x000fc400078e0070ULL,
0x000000081100720cULL, 0x000fda0003f06070ULL, 0x000082a000000947ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000072000009947ULL, 0x000fea0003800000ULL,
0x00000003ff4e7819ULL, 0x000fe20000011605ULL, 0x0000000102597824ULL, 0x000fe200078e021dULL,
0x00000020044f7810ULL, 0x000fe40007ffe0ffULL, 0x0000006009037811ULL, 0x000fe400078e40ffULL,
0x000000044e507810ULL, 0x040fe20007ffe0ffULL, 0x000000014e107824ULL, 0x000fe200078e024fULL,
0x0000000308127217ULL, 0x000fe40007800000ULL, 0x000000084e567810ULL, 0x000fe20007ffe0ffULL,
0x0000000150137824ULL, 0x000fe200078e0205ULL, 0x0000007110117210ULL, 0x080fe20007f1e0ffULL,
0x0000000112127824ULL, 0x000fe200078e0a03ULL, 0x0000000c4e587810ULL, 0x040fe20007ffe0ffULL,
0x000000014e037824ULL, 0x040fe200078e0205ULL, 0x000000144e627810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4c7224ULL, 0x000fe200000e06ffULL, 0x00005e0011107a11ULL, 0x040fe200078048ffULL,
0x0000000850547824ULL, 0x000fe200078e00ffULL, 0x000000104e5e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000150527824ULL, 0x000fe200078e024fULL, 0x00005f0011117a11ULL, 0x000fe200000f4c4cULL,
0x0000000156337824ULL, 0x040fe200078e0205ULL, 0x00000007034c7812ULL, 0x000fe200078ec0ffULL,
0x00000008565a7824ULL, 0x000fe200078e00ffULL, 0xfffffff854547812ULL, 0x000fe200078ee213ULL,
0x00000001584d7824ULL, 0x100fe200078e0205ULL, 0x0ffffff84c4c7812ULL, 0x100fe200078ef805ULL,
0x00000008585c7824ULL, 0x000fe200078e00ffULL, 0x0000007152137210ULL, 0x000fe20007f5e0ffULL,
0x0000000162527824ULL, 0x000fe200078e0205ULL, 0xfffffff85a5a7812ULL, 0x000fe200078ee233ULL,
0x000000104c337824ULL, 0x000fe200078e0229ULL, 0x0000002012037817ULL, 0x000fe20003800000ULL,
0x000000ffff4c7224ULL, 0x000fe200010e06ffULL, 0x00005e0013127a11ULL, 0x000fe200078448ffULL,
0x0000000862537824ULL, 0x000fe200078e00ffULL, 0x000000034e00720cULL, 0x000fe20003f06070ULL,
0x0000001059107825ULL, 0x000fe200078e0010ULL, 0x00005f0013137a11ULL, 0x000fc400010f4c4cULL,
0xfffffff85c5c7812ULL, 0x000fe200078ee24dULL, 0x00000001564c7824ULL, 0x100fe200078e024fULL,
0x000000184e687810ULL, 0x000fe20007ffe0ffULL, 0x0000000162647824ULL, 0x100fe200078e024fULL,
0x0000001c4e6c7810ULL, 0x000fe20007ffe0ffULL, 0x00000001584e7824ULL, 0x100fe200078e024fULL,
0x000000714c4d7210ULL, 0x080fe20007f5e0ffULL, 0x00000001686a7824ULL, 0x100fe200078e024fULL,
0xfffffff853667812ULL, 0x000fe200078ee252ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010337faeULL, 0x0003e2000c101c46ULL, 0x000000015e527824ULL, 0x100fe200078e024fULL,
0x00005e004d4c7a11ULL, 0x000fe200078c48ffULL, 0x000000016c6e7824ULL, 0x000fe200078e024fULL,
0x000000714e4f7210ULL, 0x080fe20007f7e0ffULL, 0x000000015e517824ULL, 0x000fe200078e0205ULL,
0x0000007164537210ULL, 0x080fe20007f9e0ffULL, 0x000000085e607824ULL, 0x000fe200078e00ffULL,
0x000000716a557210ULL, 0x000fe20007fbe0ffULL, 0x0000000868647824ULL, 0x000fc400078e00ffULL,
0x000000086c6a7824ULL, 0x000fe200078e00ffULL, 0xfffffff860607812ULL, 0x000fe200078ee251ULL,
0x000000ffff107224ULL, 0x002fe200010e06ffULL, 0x0000007152517210ULL, 0x080fe20007f1e0ffULL,
0x0000000168117824ULL, 0x100fe200078e0205ULL, 0x000000716e717210ULL, 0x000fe20007f5e0ffULL,
0x000000016c337824ULL, 0x000fe200078e0205ULL, 0x00005f004d4d7a11ULL, 0x000fe200030f4c10ULL,
0x000000ffff107224ULL, 0x000fe200018e06ffULL, 0x000000035000720cULL, 0x000fe20003f66070ULL,
0x000000ffff527224ULL, 0x000fe200000e06ffULL, 0x00005e004f4e7a11ULL, 0x000fc400078c48ffULL,
0xfffffff864647812ULL, 0x000fe400078ee211ULL, 0x00005f004f4f7a11ULL, 0x000fe200030f4c10ULL,
0x0000001059107825ULL, 0x000fe200078e0012ULL, 0x00005e0051507a11ULL, 0x040fe400078c48ffULL,
0xfffffff86a6a7812ULL, 0x000fe200078ee233ULL, 0x0000001054337824ULL, 0x100fe200078e0229ULL,
0x00005f0051517a11ULL, 0x000fe200030f4c52ULL, 0x000000ffff127224ULL, 0x000fe200020e06ffULL,
0x00005e0053527a11ULL, 0x040fe200078c48ffULL, 0x000000106a5b7824ULL, 0x000fe200078e0229ULL,
0x0000000010337faeULL, 0x0003e2000d901c46ULL, 0x000000035800720cULL, 0x080fe20003f66070ULL,
0x000000ffff587224ULL, 0x000fe200028e06ffULL, 0x00005f0053537a11ULL, 0x000fe200030f4c12ULL,
0x000000ffff127224ULL, 0x000fe200010e06ffULL, 0x000000035600720cULL, 0x000fc40003f06070ULL,
0x00005e0055547a11ULL, 0x000fe400078a48ffULL, 0x00005e0071567a11ULL, 0x000fe400078c48ffULL,
0x000000035e00720cULL, 0x080fe20003f86070ULL, 0x0000001059107825ULL, 0x002fe200078e004cULL,
0x000000036200720cULL, 0x080fe40003f46070ULL, 0x00005f0055557a11ULL, 0x000fe200028f4c58ULL,
0x00000010594c7825ULL, 0x000fe200078e0050ULL, 0x000000036800720cULL, 0x000fc40003fa6070ULL,
0x00005f0071577a11ULL, 0x000fe200030f4c12ULL, 0x0000001059127825ULL, 0x000fe200078e004eULL,
0x000000036c00720cULL, 0x000fc60003fc6070ULL, 0x000000105a037824ULL, 0x000fe400078e0229ULL,
0x00000010594e7825ULL, 0x000fc600078e0052ULL, 0x0000000010037faeULL, 0x0003e2000c101c46ULL,
0x0000001059507825ULL, 0x000fc800078e0054ULL, 0x000000105c337824ULL, 0x000fe400078e0229ULL,
0x0000001059527825ULL, 0x000fc600078e0056ULL, 0x0000000012337faeULL, 0x0003e2000d901c46ULL,
0x0000001060557824ULL, 0x100fe400078e0229ULL, 0x0000001066577824ULL, 0x100fe400078e0229ULL,
0x0000001064597824ULL, 0x000fe200078e0229ULL, 0x000000004c557faeULL, 0x0003e8000e101c46ULL,
0x000000004e577faeULL, 0x0003e8000d101c46ULL, 0x0000000050597faeULL, 0x0003e8000e901c46ULL,
0x00000000525b7faeULL, 0x0003e2000f101c46ULL, 0x0000064000007947ULL, 0x000fea0003800000ULL,
0x0000000405037811ULL, 0x040fe200078fe8ffULL, 0x00000001025b7824ULL, 0x000fe200078e021dULL,
0x00000010054f7811ULL, 0x000fc400078fe8ffULL, 0x0000000805337811ULL, 0x000fe200078fe8ffULL,
0x0000000103107824ULL, 0x140fe200078e0205ULL, 0x0000002004507810ULL, 0x000fe20007ffe0ffULL,
0x0000000803117824ULL, 0x000fe200078e00ffULL, 0x0000000c054d7811ULL, 0x000fe200078fe8ffULL,
0x000000014f127824ULL, 0x100fe200078e0205ULL, 0x0000001805537811ULL, 0x000fe200078fe8ffULL,
0x000000084f517824ULL, 0x000fe200078e00ffULL, 0xfffffff811607812ULL, 0x000fe200078ee210ULL,
0x0000000133107824ULL, 0x140fe400078e0205ULL, 0x0000000833137824ULL, 0x000fe200078e00ffULL,
0xfffffff851667812ULL, 0x000fe200078ee212ULL, 0x0000000103127824ULL, 0x000fe200078e0250ULL,
0x0000001405517811ULL, 0x000fe200078fe8ffULL, 0x000000014d117824ULL, 0x100fe200078e0205ULL,
0xfffffff813627812ULL, 0x000fe200078ee210ULL, 0x000000084d647824ULL, 0x000fe200078e00ffULL,
0x0000005005107211ULL, 0x000fe200078fe8ffULL, 0x0000000151137824ULL, 0x040fe200078e0205ULL,
0x0000007112037210ULL, 0x080fe20007f5e0ffULL, 0x0000000851687824ULL, 0x000fe200078e00ffULL,
0xfffffff864647812ULL, 0x000fe200078ee211ULL, 0x0000000153527824ULL, 0x000fe200078e0205ULL,
0x0000007110117210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff4c7224ULL, 0x000fe200010e06ffULL,
0x00005e0003127a11ULL, 0x000fe200078448ffULL, 0x0000000853557824ULL, 0x000fe200078e00ffULL,
0xfffffff868687812ULL, 0x000fe200078ee213ULL, 0x000000ffff4e7224ULL, 0x000fe200000e06ffULL,
0x00005e0011107a11ULL, 0x000fe200078048ffULL, 0x0000000153567824ULL, 0x000fe200078e0250ULL,
0x00005f0003137a11ULL, 0x000fe200010f4c4cULL, 0x00000001334c7824ULL, 0x000fe200078e0250ULL,
0x00005f0011117a11ULL, 0x000fe200000f4c4eULL, 0x000000014d4e7824ULL, 0x000fe200078e0250ULL,
0xfffffff8556a7812ULL, 0x000fe200078ee252ULL, 0x000000014f527824ULL, 0x100fe200078e0250ULL,
0x0000001c05557811ULL, 0x000fe200078fe8ffULL, 0x0000000151547824ULL, 0x000fe200078e0250ULL,
0x000000714c4d7210ULL, 0x080fe20007f7e0ffULL, 0x000000105b107825ULL, 0x000fe200078e0010ULL,
0x000000714e4f7210ULL, 0x000fc40007f1e0ffULL, 0x0000007152517210ULL, 0x080fe20007f5e0ffULL,
0x0000000155507824ULL, 0x000fe200078e0250ULL, 0x00005e004d4c7a11ULL, 0x000fe200078c48ffULL,
0x000000ffff4e7224ULL, 0x000fe200018e06ffULL, 0x0000007156037210ULL, 0x080fe20007f7e0ffULL,
0x0000000155567824ULL, 0x040fe200078e0205ULL, 0x0000007154337210ULL, 0x080fe20007fbe0ffULL,
0x0000000855557824ULL, 0x000fe200078e00ffULL, 0x0000007150717210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff547224ULL, 0x000fe200000e06ffULL, 0x00005f004d4d7a11ULL, 0x000fe200030f4c4eULL,
0x000000ffff527224ULL, 0x000fe200010e06ffULL, 0x0000000505537211ULL, 0x000fe200078fe8ffULL,
0x000000ffff5c7224ULL, 0x000fe200028e06ffULL, 0x00005e004f4e7a11ULL, 0x000fe200078048ffULL,
0x000000ffff5a7224ULL, 0x000fe200018e06ffULL, 0x00005e0051507a11ULL, 0x000fe200078448ffULL,
0x000000ffff587224ULL, 0x000fe200020e06ffULL, 0x00000007535e7812ULL, 0x000fe200078ec0ffULL,
0x000000105b127825ULL, 0x000fe200078e0012ULL, 0xfffffff8556c7812ULL, 0x000fc400078ee256ULL,
0x00005f004f4f7a11ULL, 0x000fe200000f4c54ULL, 0x0000001062597824ULL, 0x000fe200078e0229ULL,
0x00005f0051517a11ULL, 0x000fe200010f4c52ULL, 0x000000105b4c7825ULL, 0x000fe200078e004cULL,
0x00005e0033527a11ULL, 0x000fe400078048ffULL, 0x00005e0003547a11ULL, 0x000fe200078448ffULL,
0x000000105b4e7825ULL, 0x000fe200078e004eULL, 0x00005e0071567a11ULL, 0x000fe400078648ffULL,
0x0ffffff85e5e7812ULL, 0x000fe200078ef805ULL, 0x000000105b507825ULL, 0x000fe200078e0050ULL,
0x00005f0033537a11ULL, 0x000fc400000f4c5cULL, 0x00005f0003557a11ULL, 0x000fe200010f4c5aULL,
0x000000105e037824ULL, 0x100fe200078e0229ULL, 0x00005f0071577a11ULL, 0x000fe200018f4c58ULL,
0x0000001060337824ULL, 0x000fe400078e0229ULL, 0x000000105b527825ULL, 0x040fe200078e0052ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010037faeULL, 0x0003e6000b901c46ULL,
0x000000105b547825ULL, 0x040fe200078e0054ULL, 0x0000000012337faeULL, 0x0003e6000b901c46ULL,
0x000000105b567825ULL, 0x000fe200078e0056ULL, 0x000000004c597faeULL, 0x0003e6000b901c46ULL,
0x00000010645b7824ULL, 0x000fc400078e0229ULL, 0x00000010665d7824ULL, 0x100fe400078e0229ULL,
0x00000010685f7824ULL, 0x100fe200078e0229ULL, 0x000000004e5b7faeULL, 0x0003e2000b901c46ULL,
0x000000106a617824ULL, 0x100fe400078e0229ULL, 0x000000106c637824ULL, 0x000fe200078e0229ULL,
0x00000000505d7faeULL, 0x0003e8000b901c46ULL, 0x00000000525f7faeULL, 0x0003e8000b901c46ULL,
0x0000000054617faeULL, 0x0003e8000b901c46ULL, 0x0000000056637faeULL, 0x0003e4000b901c46ULL,
0x00000300ff037624ULL, 0x002fe200078e00ffULL, 0x0000000300107812ULL, 0x000fc800078ec0ffULL,
0x000000031000780cULL, 0x000fe40003f05270ULL, 0xfffffffd03037811ULL, 0x000fc800078e10ffULL,
0x0000000103037807ULL, 0x000fca0004000000ULL, 0x0000000100007824ULL, 0x000fe400078e0203ULL,
0xffffffffff037424ULL, 0x000fc600078e00ffULL, 0x000000b70000720cULL, 0x000fda0003f06070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x0000000100107824ULL, 0x000fe400078e020bULL,
0x00000004ff117424ULL, 0x000fc800078e00ffULL, 0x0000600010107625ULL, 0x000fca00078e0011ULL,
0x0000000610037981ULL, 0x000324000c1e1900ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01c62800024c7f8cULL, 0x0004e4000c80043fULL,
0x0000000000107805ULL, 0x002fc40000015200ULL, 0x01c62c0002137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x00afe4000780484dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x0000001210337210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e11ULL,
0x003d09003300780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403300780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff127819ULL, 0x000fc80000011413ULL, 0x0000003312127211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0613ULL, 0x0000000212127819ULL, 0x000fc80000001213ULL,
0x000000120000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000014e4e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01c62c0002137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe4000780484dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x01c08000184d7984ULL, 0x000e680000000800ULL,
0x01c28000184c7984ULL, 0x0006a20000000800ULL, 0x000000704d00720bULL, 0x002fe20003f1d000ULL,
0x000144e27f007947ULL, 0x000fd8000b800000ULL, 0x00000000004e7806ULL, 0x008fc800000e0100ULL,
0x0000ffff4eff7812ULL, 0x000fe2000784c0ffULL, 0x0000046000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe20003f0e170ULL, 0x000000ffff337224ULL, 0x000fd400078e0070ULL,
0x000004200000a947ULL, 0x000fea0003800000ULL, 0x000000010a00780cULL, 0x000fe40003f05270ULL,
0x000000704d00720bULL, 0x000fe20003f54000ULL, 0x000144b27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000337806ULL, 0x000fc400010e0100ULL, 0x000000704d118209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x0000991033107816ULL, 0x000fc600000000ffULL,
0x01c4801118008388ULL, 0x0003e20000000800ULL, 0x000000ff1000720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x000000704d117209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff33ff7812ULL, 0x000fc6000780c0ffULL,
0x0000007011107221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL,
0x0000001000657308ULL, 0x000e640000000800ULL, 0x0000006506067220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff647819ULL, 0x000fe20000011605ULL,
0x000144027f007947ULL, 0x000fea000b800000ULL, 0x00001f6465127589ULL, 0x0002e400000e0000ULL,
0x0000001214147220ULL, 0x08cfe40000410000ULL, 0x0000001215157220ULL, 0x080fe40000410000ULL,
0x000000120c0c7220ULL, 0x080fe40000410000ULL, 0x000000120d0d7220ULL, 0x000fc40000410000ULL,
0x0000001234347220ULL, 0x080fe40000410000ULL, 0x0000001235357220ULL, 0x080fe40000410000ULL,
0x0000001238387220ULL, 0x080fe40000410000ULL, 0x0000001239397220ULL, 0x080fe40000410000ULL,
0x0000001240407220ULL, 0x080fe40000410000ULL, 0x0000001241417220ULL, 0x000fc40000410000ULL,
0x000000123c3c7220ULL, 0x080fe40000410000ULL, 0x000000123d3d7220ULL, 0x080fe40000410000ULL,
0x0000001248487220ULL, 0x080fe40000410000ULL, 0x0000001249497220ULL, 0x080fe40000410000ULL,
0x0000001244447220ULL, 0x080fe40000410000ULL, 0x0000001245457220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0033ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000805647811ULL, 0x002fe200078ff0ffULL,
0x000142f27f007947ULL, 0x000fea000b800000ULL, 0x00001f6465127589ULL, 0x0002e400000e0000ULL,
0x0000001216167220ULL, 0x08cfe40000410000ULL, 0x0000001217177220ULL, 0x080fe40000410000ULL,
0x000000120e0e7220ULL, 0x080fe40000410000ULL, 0x000000120f0f7220ULL, 0x080fe40000410000ULL,
0x0000001236367220ULL, 0x080fe40000410000ULL, 0x0000001237377220ULL, 0x000fc40000410000ULL,
0x000000123a3a7220ULL, 0x080fe40000410000ULL, 0x000000123b3b7220ULL, 0x080fe40000410000ULL,
0x0000001242427220ULL, 0x080fe40000410000ULL, 0x0000001243437220ULL, 0x080fe40000410000ULL,
0x000000123e3e7220ULL, 0x080fe40000410000ULL, 0x000000123f3f7220ULL, 0x000fc40000410000ULL,
0x000000124a4a7220ULL, 0x080fe40000410000ULL, 0x000000124b4b7220ULL, 0x080fe40000410000ULL,
0x0000001246467220ULL, 0x080fe40000410000ULL, 0x0000001247477220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff33ff7812ULL, 0x000fe4000780084eULL,
0x000000704d337209ULL, 0x000fd60007810000ULL, 0x800000334d4d0221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b4d4d0820ULL, 0x000fc80000410000ULL, 0x0000004d00190308ULL, 0x000e640000000800ULL,
0x000000194c4c0220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000017000007945ULL, 0x000fe20003800000ULL,
0x000000064c067221ULL, 0x004fe20000010000ULL, 0x0000014000008947ULL, 0x000fea0003800000ULL,
0x00000019ff10723eULL, 0x000fe400000010ffULL, 0x00000002ff4c7819ULL, 0x000fe40000011605ULL,
0x0000541010657816ULL, 0x000fe20000000010ULL, 0x000141327f007947ULL, 0x000fea000b800000ULL,
0x00001f4c651b7589ULL, 0x0002a400000e0000ULL, 0x000000084c647810ULL, 0x002fe20007ffe0ffULL,
0x000141727f007947ULL, 0x000fea000b800000ULL, 0x00001f64651a7589ULL, 0x0002e400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000104c647810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff137424ULL, 0x000fe200078e00ffULL, 0x00005dc000107802ULL, 0x000fe20000000f00ULL,
0xffffffffff127424ULL, 0x000fc400078e00ffULL, 0x00014dd000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000184c647810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff137424ULL, 0x000fe200078e00ffULL, 0x00005e2000107802ULL, 0x000fe20000000f00ULL,
0xffffffffff127424ULL, 0x004fc400078e00ffULL, 0x00014d7000007944ULL, 0x018fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000128001c587811ULL, 0x000fcc00078e20ffULL, 0x000000005858783bULL, 0x000e620000000200ULL,
0x00012800234c7811ULL, 0x000fe200078e20ffULL, 0x0000580003707a24ULL, 0x010fc400078e02ffULL,
0x000000001f68783bULL, 0x000ee40000004200ULL, 0x0000004070707824ULL, 0x000fe400078e00ffULL,
0x00000000206c783bULL, 0x000fe80000004200ULL, 0x000000002160783bULL, 0x000fe80000004200ULL,
0x000000002264783bULL, 0x002fe80000004200ULL, 0x000000004c4c783bULL, 0x000e680000000200ULL,
0x000000002450783bULL, 0x000ea80000004200ULL, 0x00000000255c783bULL, 0x000ea80000004200ULL,
0x000000002654783bULL, 0x000ea80000004200ULL, 0x000000002710783bULL, 0x004ea20000004200ULL,
0x0000001b58580231ULL, 0x000fc400003400ffULL, 0x0000001b5a5a0231ULL, 0x000fe400003400ffULL,
0x0000001a59590231ULL, 0x088fe400003400ffULL, 0x0000001a5b5b0231ULL, 0x000fce00003400ffULL,
0x000000685814723cULL, 0x000f620000041814ULL, 0x0000001b4c4c0231ULL, 0x002fce00003400ffULL,
0x0000006a580c723cULL, 0x000f62000004180cULL, 0x0000001b4e4e0231ULL, 0x000fe400003400ffULL,
0x0000001a4d4d0231ULL, 0x080fe400003400ffULL, 0x0000001a4f4f0231ULL, 0x000fc600003400ffULL,
0x0000006e5838723cULL, 0x040f700000041838ULL, 0x000000605840723cULL, 0x040ff00000041840ULL,
0x00000062583c723cULL, 0x040ff0000004183cULL, 0x0000006c5834723cULL, 0x040f700000041834ULL,
0x000000645860723cULL, 0x040f700000041848ULL, 0x000000665844723cULL, 0x000f700000041844ULL,
0x000000504c58723cULL, 0x060b700000041814ULL, 0x000000524c50723cULL, 0x040b70000004180cULL,
0x0000005e4c14723cULL, 0x040b700000041838ULL, 0x0000005c4c34723cULL, 0x040b700000041834ULL,
0x000000544c0c723cULL, 0x040b700000041840ULL, 0x000000564c48723cULL, 0x040b70000004183cULL,
0x000000104c38723cULL, 0x044b700000041860ULL, 0x000000124c4c723cULL, 0x000b620000041844ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000071000009947ULL, 0x000fca0003800000ULL,
0x00000003ff437819ULL, 0x020fe20000011605ULL, 0x0000000102557824ULL, 0x000fe200078e021dULL,
0x0000008009117811ULL, 0x000fe400078e40ffULL, 0x0000000843417810ULL, 0x040fe40007ffe0ffULL,
0x0000001108107217ULL, 0x000fe40007800000ULL, 0x00000004433f7810ULL, 0x000fe20007ffe0ffULL,
0x00000001413c7824ULL, 0x000fe200078e0205ULL, 0x0000001043637810ULL, 0x000fe20007ffe0ffULL,
0x00000008415f7824ULL, 0x000fe200078e00ffULL, 0x0000001443677810ULL, 0x040fe20007ffe0ffULL,
0x0000000110127824ULL, 0x000fe200078e0a11ULL, 0x0000000c43457810ULL, 0x000fe20007ffe0ffULL,
0x000000013f137824ULL, 0x100fe200078e0205ULL, 0xfffffff85f5f7812ULL, 0x000fe200078ee23cULL,
0x000000083f3e7824ULL, 0x000fe200078e00ffULL, 0x00000018436b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000163117824ULL, 0x000fe200078e0205ULL, 0x0000001c43717810ULL, 0x000fe20007ffe0ffULL,
0x00000008633c7824ULL, 0x000fe200078e00ffULL, 0xfffffff83e477812ULL, 0x000fe200078ee213ULL,
0x0000000167137824ULL, 0x040fe200078e0205ULL, 0x0000002012547817ULL, 0x000fe20003800000ULL,
0x00000008673e7824ULL, 0x000fe200078e00ffULL, 0xfffffff83c657812ULL, 0x000fe200078ee211ULL,
0x0000000104117824ULL, 0x000fe200078e0243ULL, 0x000000544100720cULL, 0x000fe20003fa6070ULL,
0x0000000145107824ULL, 0x040fe200078e0205ULL, 0xfffffff83e697812ULL, 0x000fe200078ee213ULL,
0x0000000845617824ULL, 0x000fe200078e00ffULL, 0x0000007011117210ULL, 0x000fe20007f5e0ffULL,
0x0000000104137824ULL, 0x000fc400078e023fULL, 0x000000016b3d7824ULL, 0x100fe200078e0205ULL,
0xfffffff861617812ULL, 0x000fe200078ee210ULL, 0x000000086b407824ULL, 0x000fe200078e00ffULL,
0x0000007013137210ULL, 0x080fe20007f7e0ffULL, 0x000000ffff3c7224ULL, 0x000fe200010e06ffULL,
0x00005e0011107a11ULL, 0x000fe200078448ffULL, 0x00000001713e7824ULL, 0x000fe200078e0205ULL,
0xfffffff8406f7812ULL, 0x000fe200078ee23dULL, 0x00000001043d7824ULL, 0x040fe200078e0241ULL,
0x00005f0011117a11ULL, 0x000fe200010f4c3cULL, 0x0000000871737824ULL, 0x000fe200078e00ffULL,
0x00005e0013127a11ULL, 0x000fe200078448ffULL, 0x000000ffff3c7224ULL, 0x000fe200018e06ffULL,
0x000000703d3d7210ULL, 0x000fe20007f9e0ffULL, 0x0000000104417824ULL, 0x040fe200078e0263ULL,
0x000000543f00720cULL, 0x000fe20003f66070ULL, 0x00000001043f7824ULL, 0x000fe200078e0245ULL,
0xfffffff873737812ULL, 0x000fe200078ee23eULL, 0x000000ffff3e7224ULL, 0x000fe200020e06ffULL,
0x00005f0013137a11ULL, 0x000fe200010f4c3cULL, 0x0000001055107825ULL, 0x000fe200078e0010ULL,
0x000000703f3f7210ULL, 0x000fc40007f9e0ffULL, 0x00005e003d3c7a11ULL, 0x000fe200078448ffULL,
0x00000001046d7824ULL, 0x040fe200078e026bULL, 0x0000007041417210ULL, 0x000fe20007fde0ffULL,
0x000000ffff407224ULL, 0x000fe200020e06ffULL, 0x000000544300720cULL, 0x0c0fe20003f86070ULL,
0x0000000143437824ULL, 0x000fe200078e0205ULL, 0x00005f003d3d7a11ULL, 0x000fe200010f4c3eULL,
0x000000ffff427224ULL, 0x000fe200030e06ffULL, 0x00005e003f3e7a11ULL, 0x000fe200078448ffULL,
0x00000010475d7824ULL, 0x000fe200078e021eULL, 0x0000000743447812ULL, 0x000fe200078ec0ffULL,
0x0000000104437824ULL, 0x000fe200078e0267ULL, 0x00005f003f3f7a11ULL, 0x000fe200010f4c40ULL,
0x0000001055127825ULL, 0x000fe200078e0012ULL, 0x000000544500720cULL, 0x000fc40003f46070ULL,
0x0ffffff844457812ULL, 0x000fe200078ef805ULL, 0x0000000104477824ULL, 0x000fe200078e0271ULL,
0x00005e0041407a11ULL, 0x000fe200078c48ffULL, 0x000000105f5f7824ULL, 0x100fe400078e021eULL,
0x0000001045577824ULL, 0x000fe200078e021eULL, 0x00005f0041417a11ULL, 0x000fe200030f4c42ULL,
0x00000010553c7825ULL, 0x000fe200078e003cULL, 0x0000007043437210ULL, 0x080fe40007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010577faeULL, 0x0003e2000e101c46ULL,
0x000000706d457210ULL, 0x000fe20007f9e0ffULL, 0x0000001061617824ULL, 0x000fc400078e021eULL,
0x000000ffff447224ULL, 0x000fe200030e06ffULL, 0x00005e0043427a11ULL, 0x000fe200078c48ffULL,
0x00000000125d7faeULL, 0x0005e2000d901c46ULL, 0x0000007047477210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff467224ULL, 0x000fe200020e06ffULL, 0x00005f0043437a11ULL, 0x000fe200030f4c44ULL,
0x000000003c5f7faeULL, 0x0007e2000e901c46ULL, 0x00005e0045447a11ULL, 0x000fe200078c48ffULL,
0x000000ffff567224ULL, 0x000fe200018e06ffULL, 0x000000546300720cULL, 0x000fe20003f86070ULL,
0x0000001055107825ULL, 0x002fe200078e003eULL, 0x00005f0045457a11ULL, 0x000fc400030f4c46ULL,
0x00005e0047467a11ULL, 0x000fe200078648ffULL, 0x0000001055127825ULL, 0x004fe200078e0040ULL,
0x000000546700720cULL, 0x080fe20003fc6070ULL, 0x0000000010617faeULL, 0x0007e2000d101c46ULL,
0x000000546b00720cULL, 0x080fe20003fa6070ULL, 0x0000001065657824ULL, 0x000fe200078e021eULL,
0x00005f0047477a11ULL, 0x000fe200018f4c56ULL, 0x00000010553e7825ULL, 0x000fe200078e0042ULL,
0x000000547100720cULL, 0x000fe40003f66070ULL, 0x0000000012657faeULL, 0x0007e2000e101c46ULL,
0x0000001069697824ULL, 0x000fc400078e021eULL, 0x0000001055407825ULL, 0x000fc600078e0044ULL,
0x000000003e697faeULL, 0x0007e2000f101c46ULL, 0x000000106f6f7824ULL, 0x000fe400078e021eULL,
0x0000001055427825ULL, 0x000fc600078e0046ULL, 0x00000000406f7faeULL, 0x0007e2000e901c46ULL,
0x0000001073737824ULL, 0x000fca00078e021eULL, 0x0000000042737faeULL, 0x0007e2000d901c46ULL,
0x0000063000007947ULL, 0x000fea0003800000ULL, 0x0000000c053e7811ULL, 0x060fe200078fe8ffULL,
0x0000000102557824ULL, 0x000fe200078e021dULL, 0x0000001005437811ULL, 0x040fe400078fe8ffULL,
0x0000001c05477811ULL, 0x040fe200078fe8ffULL, 0x000000013e137824ULL, 0x140fe200078e0205ULL,
0x0000000405107811ULL, 0x040fe200078fe8ffULL, 0x000000083e427824ULL, 0x000fe200078e00ffULL,
0x00000008053c7811ULL, 0x000fe200078fe8ffULL, 0x00000001433d7824ULL, 0x000fe200078e0205ULL,
0x0000001805467811ULL, 0x000fe200078fe8ffULL, 0x0000000843447824ULL, 0x000fe200078e00ffULL,
0xfffffff842617812ULL, 0x000fe200078ee213ULL, 0x0000000847427824ULL, 0x000fe200078e00ffULL,
0x0000001405457811ULL, 0x000fe200078fe8ffULL, 0x0000000110117824ULL, 0x000fe200078e0205ULL,
0xfffffff844637812ULL, 0x000fe200078ee23dULL, 0x00000001473d7824ULL, 0x000fe200078e0205ULL,
0x0000000505417211ULL, 0x000fe200078fe8ffULL, 0x0000000810407824ULL, 0x000fc400078e00ffULL,
0x00000001043f7824ULL, 0x000fe200078e023eULL, 0xfffffff842697812ULL, 0x000fe200078ee23dULL,
0x00000001043d7824ULL, 0x000fe200078e023cULL, 0xfffffff8405d7812ULL, 0x000fe200078ee211ULL,
0x000000013c127824ULL, 0x140fe200078e0205ULL, 0x0000000405117211ULL, 0x000fe200078fe8ffULL,
0x000000083c5f7824ULL, 0x000fe200078e00ffULL, 0x000000703d3d7210ULL, 0x080fe20007f9e0ffULL,
0x0000000146137824ULL, 0x140fe200078e0205ULL, 0x000000703f3f7210ULL, 0x080fe20007fbe0ffULL,
0x0000000846407824ULL, 0x000fe200078e00ffULL, 0xfffffff85f5f7812ULL, 0x000fe200078ee212ULL,
0x0000000145127824ULL, 0x000fe200078e0205ULL, 0x0000007011117210ULL, 0x000fe20007f5e0ffULL,
0x0000000845657824ULL, 0x000fe200078e00ffULL, 0xfffffff840677812ULL, 0x000fe200078ee213ULL,
0x0000000104137824ULL, 0x000fc400078e0210ULL, 0x000000ffff427224ULL, 0x000fe200020e06ffULL,
0x00005e003f3e7a11ULL, 0x000fe200078848ffULL, 0x000000ffff407224ULL, 0x000fe200028e06ffULL,
0xfffffff865657812ULL, 0x000fe200078ee212ULL, 0x000000ffff127224ULL, 0x000fe200010e06ffULL,
0x0000007013137210ULL, 0x080fe20007f7e0ffULL, 0x0000000104477824ULL, 0x040fe200078e0247ULL,
0x00005e0011107a11ULL, 0x000fe200078448ffULL, 0x000000105d5d7824ULL, 0x000fe200078e021eULL,
0x00005f003f3f7a11ULL, 0x000fe200020f4c40ULL, 0x000000ffff447224ULL, 0x000fe200018e06ffULL,
0x0000000741407812ULL, 0x000fe200078ec0ffULL, 0x0000000104417824ULL, 0x040fe200078e0243ULL,
0x00005f0011117a11ULL, 0x000fe200010f4c12ULL, 0x0000000104437824ULL, 0x040fe200078e0245ULL,
0x00005e0013127a11ULL, 0x000fe200078448ffULL, 0x0000000104457824ULL, 0x000fe200078e0246ULL,
0x00005e003d3c7a11ULL, 0x000fe200078648ffULL, 0x0000001055107825ULL, 0x000fe200078e0010ULL,
0x0000007041417210ULL, 0x000fc40007f9e0ffULL, 0x00005f0013137a11ULL, 0x000fe200010f4c44ULL,
0x000000105f5f7824ULL, 0x000fe200078e021eULL, 0x0000007043437210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff5e7224ULL, 0x000fe200020e06ffULL, 0x00005f003d3d7a11ULL, 0x000fe200018f4c42ULL,
0x0000001055127825ULL, 0x000fe200078e0012ULL, 0x0000007045457210ULL, 0x080fe40007f5e0ffULL,
0x0000007047477210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff5c7224ULL, 0x000fe200028e06ffULL,
0x0ffffff840577812ULL, 0x000fe200078ef805ULL, 0x000000ffff567224ULL, 0x000fe200010e06ffULL,
0x00005e0041407a11ULL, 0x000fe200078848ffULL, 0x000000ffff547224ULL, 0x000fe200018e06ffULL,
0x00005e0043427a11ULL, 0x000fe200078a48ffULL, 0x0000001057577824ULL, 0x000fe200078e021eULL,
0x00005e0045447a11ULL, 0x000fe200078448ffULL, 0x00000010553c7825ULL, 0x000fe200078e003cULL,
0x00005e0047467a11ULL, 0x000fc400078648ffULL, 0x00005f0041417a11ULL, 0x000fe200020f4c5eULL,
0x00000010553e7825ULL, 0x000fe200078e003eULL, 0x00005f0043437a11ULL, 0x000fe200028f4c5cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010577faeULL, 0x0003e2000b901c46ULL,
0x00005f0045457a11ULL, 0x000fe200010f4c56ULL, 0x0000001061617824ULL, 0x000fe200078e021eULL,
0x00005f0047477a11ULL, 0x000fe200018f4c54ULL, 0x0000001055407825ULL, 0x000fe200078e0040ULL,
0x00000000125d7faeULL, 0x0003e6000b901c46ULL, 0x0000001063637824ULL, 0x000fe200078e021eULL,
0x000000003c5f7faeULL, 0x0003e2000b901c46ULL, 0x0000001055427825ULL, 0x000fc600078e0042ULL,
0x000000003e617faeULL, 0x0003e2000b901c46ULL, 0x0000001065657824ULL, 0x000fe400078e021eULL,
0x0000001055447825ULL, 0x000fe200078e0044ULL, 0x0000000040637faeULL, 0x0003e6000b901c46ULL,
0x0000001067677824ULL, 0x000fe200078e021eULL, 0x0000000042657faeULL, 0x0003e2000b901c46ULL,
0x0000001055467825ULL, 0x000fc600078e0046ULL, 0x0000000044677faeULL, 0x0003e2000b901c46ULL,
0x0000001069697824ULL, 0x000fca00078e021eULL, 0x0000000046697faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000017000007945ULL, 0x000fe20003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000014000008947ULL, 0x000fea0003800000ULL,
0x00000019ff10723eULL, 0x00afe400000010ffULL, 0x00000002ff3c7819ULL, 0x000fe40000011605ULL,
0x0000541010657816ULL, 0x000fe20000000010ULL, 0x000130a27f007947ULL, 0x000fea000b800000ULL,
0x00001f3c651b7589ULL, 0x0002a400000e0000ULL, 0x000000083c647810ULL, 0x002fe20007ffe0ffULL,
0x000130e27f007947ULL, 0x000fea000b800000ULL, 0x00001f64651a7589ULL, 0x0002e400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000103c647810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff137424ULL, 0x000fe200078e00ffULL, 0x00006f2000107802ULL, 0x000fe20000000f00ULL,
0xffffffffff127424ULL, 0x000fc400078e00ffULL, 0x00013c7000007944ULL, 0x00cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000183c647810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff137424ULL, 0x000fe200078e00ffULL, 0x00006f8000107802ULL, 0x000fe20000000f00ULL,
0xffffffffff127424ULL, 0x004fc400078e00ffULL, 0x00013c1000007944ULL, 0x008fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00012800285c7811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000002d68783bULL, 0x00afe20000004200ULL,
0x000128002e107811ULL, 0x000fc600078e20ffULL, 0x000000005c5c783bULL, 0x000e680000000200ULL,
0x000000002a6c783bULL, 0x000fe80000004200ULL, 0x000000002b60783bULL, 0x000fe80000004200ULL,
0x000000002c64783bULL, 0x000fe80000004200ULL, 0x000000001010783bULL, 0x004ea80000000200ULL,
0x000000002f40783bULL, 0x000ee80000004200ULL, 0x00000000303c783bULL, 0x000f280000004200ULL,
0x000000003144783bULL, 0x000ee80000004200ULL, 0x000000003254783bULL, 0x000ee20000004200ULL,
0x0000001b5c5c0231ULL, 0x002fc400003400ffULL, 0x0000001b5e5e0231ULL, 0x000fe400003400ffULL,
0x0000001a5d5d0231ULL, 0x080fe400003400ffULL, 0x0000001a5f5f0231ULL, 0x000fce00003400ffULL,
0x000000685c58723cULL, 0x000fe20000041858ULL, 0x0000001b10100231ULL, 0x084fe400003400ffULL,
0x0000001b12120231ULL, 0x000fe400003400ffULL, 0x0000001a11110231ULL, 0x000fc600003400ffULL,
0x0000006a5c50723cULL, 0x000fe20000041850ULL, 0x0000001a13130231ULL, 0x000fce00003400ffULL,
0x0000006c5c34723cULL, 0x040f700000041834ULL, 0x000000605c68723cULL, 0x040ff0000004180cULL,
0x0000006e5c6c723cULL, 0x040f700000041814ULL, 0x000000625c60723cULL, 0x040ff00000041848ULL,
0x000000645c48723cULL, 0x040f700000041838ULL, 0x000000665c4c723cULL, 0x000f70000004184cULL,
0x000000401034723cULL, 0x068b700000041834ULL, 0x000000421038723cULL, 0x040b70000004186cULL,
0x0000003c1040723cULL, 0x050b700000041868ULL, 0x000000441048723cULL, 0x040b700000041848ULL,
0x000000541014723cULL, 0x040b700000041858ULL, 0x00000056100c723cULL, 0x040b700000041850ULL,
0x0000003e103c723cULL, 0x040b700000041860ULL, 0x000000461044723cULL, 0x000b62000004184cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x0000008009117811ULL, 0x020fe200078e40ffULL,
0x01c69000ffff7f8cULL, 0x000fe6000c80043fULL, 0x000000081100720cULL, 0x000fda0003f06070ULL,
0x0000571000000947ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000072000009947ULL, 0x000fea0003800000ULL, 0x00000003ff4e7819ULL, 0x000fe20000011605ULL,
0x0000000102597824ULL, 0x000fe200078e021dULL, 0x00000020044f7810ULL, 0x000fe40007ffe0ffULL,
0x000000a009037811ULL, 0x000fe400078e40ffULL, 0x000000044e507810ULL, 0x040fe20007ffe0ffULL,
0x000000014e117824ULL, 0x000fe200078e024fULL, 0x0000000308127217ULL, 0x000fe40007800000ULL,
0x000000084e547810ULL, 0x000fe20007ffe0ffULL, 0x0000000150137824ULL, 0x040fe200078e0205ULL,
0x0000007011117210ULL, 0x080fe20007f1e0ffULL, 0x0000000850527824ULL, 0x000fe200078e00ffULL,
0x0000000c4e567810ULL, 0x000fe20007ffe0ffULL, 0x0000000112127824ULL, 0x000fe200078e0a03ULL,
0x000000104e5c7810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff4c7224ULL, 0x000fe200000e06ffULL,
0x00005e0011107a11ULL, 0x040fe200078048ffULL, 0x000000014e037824ULL, 0x000fe200078e0205ULL,
0xfffffff852527812ULL, 0x000fe200078ee213ULL, 0x00000001544d7824ULL, 0x040fe200078e0205ULL,
0x00005f0011117a11ULL, 0x000fe200000f4c4cULL, 0x0000000854587824ULL, 0x000fe200078e00ffULL,
0x00000007034c7812ULL, 0x000fe200078ec0ffULL, 0x0000000150137824ULL, 0x000fe200078e024fULL,
0x0000002012037817ULL, 0x000fe20003800000ULL, 0x00000008565a7824ULL, 0x000fe200078e00ffULL,
0xfffffff858587812ULL, 0x000fe200078ee24dULL, 0x00000001564d7824ULL, 0x100fe200078e0205ULL,
0x0ffffff84c4c7812ULL, 0x100fe200078ef805ULL, 0x000000015c537824ULL, 0x040fe200078e0205ULL,
0x0000007013137210ULL, 0x000fe20007f5e0ffULL, 0x000000085c5e7824ULL, 0x000fe200078e00ffULL,
0x000000034e00720cULL, 0x000fe20003f06070ULL, 0x000000104c517824ULL, 0x000fe200078e0229ULL,
0x000000144e607810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff4c7224ULL, 0x000fe200010e06ffULL,
0xfffffff85a5a7812ULL, 0x000fe200078ee24dULL, 0x00000001544d7824ULL, 0x000fe200078e024fULL,
0x00005e0013127a11ULL, 0x040fe200078448ffULL, 0x0000000160557824ULL, 0x000fe200078e0205ULL,
0xfffffff85e5e7812ULL, 0x000fe200078ee253ULL, 0x0000000860627824ULL, 0x000fe200078e00ffULL,
0x00005f0013137a11ULL, 0x000fe200010f4c4cULL, 0x0000001059107825ULL, 0x000fe200078e0010ULL,
0x000000184e647810ULL, 0x000fc40007ffe0ffULL, 0x0000001c4e687810ULL, 0x000fe20007ffe0ffULL,
0x0000000156537824ULL, 0x000fe200078e024fULL, 0x000000704d4d7210ULL, 0x080fe20007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010517faeULL, 0x0003e2000c101c46ULL,
0xfffffff862627812ULL, 0x000fe200078ee255ULL, 0x000000015c557824ULL, 0x100fe200078e024fULL,
0x00005e004d4c7a11ULL, 0x000fe200078c48ffULL, 0x0000000160577824ULL, 0x100fe400078e024fULL,
0x00000001645b7824ULL, 0x100fe400078e024fULL, 0x00000001685d7824ULL, 0x000fe200078e024fULL,
0x00000070534f7210ULL, 0x080fe20007f7e0ffULL, 0x0000000864667824ULL, 0x040fe200078e00ffULL,
0x0000007057537210ULL, 0x080fe20007f9e0ffULL, 0x000000ffff107224ULL, 0x002fe200010e06ffULL,
0x0000007055517210ULL, 0x080fe20007f1e0ffULL, 0x0000000164117824ULL, 0x000fe200078e0205ULL,
0x000000705b557210ULL, 0x000fe20007fbe0ffULL, 0x00000010525b7824ULL, 0x000fe200078e0229ULL,
0x00005f004d4d7a11ULL, 0x000fe200030f4c10ULL, 0x000000ffff107224ULL, 0x000fe200018e06ffULL,
0x00005e004f4e7a11ULL, 0x040fe200078c48ffULL, 0x000000ffff527224ULL, 0x000fe200000e06ffULL,
0x000000035000720cULL, 0x000fe20003f66070ULL, 0x0000000168577824ULL, 0x040fe200078e0205ULL,
0x00005f004f4f7a11ULL, 0x000fe200030f4c10ULL, 0x00000008686a7824ULL, 0x000fe200078e00ffULL,
0x00005e0051507a11ULL, 0x000fc400078c48ffULL, 0xfffffff866667812ULL, 0x000fe200078ee211ULL,
0x0000001059107825ULL, 0x000fe200078e0012ULL, 0x00005f0051517a11ULL, 0x000fe400030f4c52ULL,
0x00005e0053527a11ULL, 0x000fe200078c48ffULL, 0x000000ffff127224ULL, 0x000fe200020e06ffULL,
0x000000705d707210ULL, 0x000fe20007f5e0ffULL, 0x00000000105b7faeULL, 0x0003e2000d901c46ULL,
0x000000035400720cULL, 0x080fe40003f06070ULL, 0x00005f0053537a11ULL, 0x000fe200030f4c12ULL,
0x000000ffff127224ULL, 0x000fe200028e06ffULL, 0x000000035600720cULL, 0x000fe20003f66070ULL,
0x000000ffff137224ULL, 0x000fe200010e06ffULL, 0x00005e0055547a11ULL, 0x000fc400078a48ffULL,
0x00005e0070567a11ULL, 0x000fe400078c48ffULL, 0x000000035c00720cULL, 0x080fe20003f86070ULL,
0x0000001059107825ULL, 0x042fe200078e004cULL, 0xfffffff86a6a7812ULL, 0x000fe400078ee257ULL,
0x000000036000720cULL, 0x080fe20003f46070ULL, 0x00000010594c7825ULL, 0x000fe200078e0050ULL,
0x00005f0055557a11ULL, 0x000fe400028f4c12ULL, 0x000000036400720cULL, 0x080fe20003fa6070ULL,
0x00000010665b7824ULL, 0x000fe200078e0229ULL, 0x00005f0070577a11ULL, 0x000fe200030f4c13ULL,
0x0000001059127825ULL, 0x000fe200078e004eULL, 0x000000036800720cULL, 0x000fc60003fc6070ULL,
0x0000001058037824ULL, 0x000fe400078e0229ULL, 0x00000010594e7825ULL, 0x000fc600078e0052ULL,
0x0000000010037faeULL, 0x0003e2000c101c46ULL, 0x0000001059507825ULL, 0x000fc800078e0054ULL,
0x0000001059527825ULL, 0x000fc800078e0056ULL, 0x000000105a557824ULL, 0x100fe400078e0229ULL,
0x000000105e577824ULL, 0x100fe400078e0229ULL, 0x0000001062597824ULL, 0x100fe200078e0229ULL,
0x0000000012557faeULL, 0x0003e2000d901c46ULL, 0x000000106a5d7824ULL, 0x000fc600078e0229ULL,
0x000000004c577faeULL, 0x0003e8000e101c46ULL, 0x000000004e597faeULL, 0x0003e8000d101c46ULL,
0x00000000505b7faeULL, 0x0003e8000e901c46ULL, 0x00000000525d7faeULL, 0x0003e2000f101c46ULL,
0x0000064000007947ULL, 0x000fea0003800000ULL, 0x0000000405037811ULL, 0x000fe400078fe8ffULL,
0x0000002004507810ULL, 0x000fc40007ffe0ffULL, 0x0000000c054f7811ULL, 0x000fe200078fe8ffULL,
0x0000000103107824ULL, 0x100fe200078e0205ULL, 0x00000008054d7811ULL, 0x000fe200078fe8ffULL,
0x0000000803117824ULL, 0x000fe200078e00ffULL, 0x0000001005517811ULL, 0x000fe200078fe8ffULL,
0x0000000103037824ULL, 0x000fe200078e0250ULL, 0x0000001405527811ULL, 0x000fe200078fe8ffULL,
0x000000084f627824ULL, 0x000fe200078e00ffULL, 0xfffffff8115e7812ULL, 0x000fe200078ee210ULL,
0x000000014f117824ULL, 0x100fe200078e0205ULL, 0x0000007003037210ULL, 0x000fe20007f5e0ffULL,
0x000000014d107824ULL, 0x000fe200078e0205ULL, 0x0000001805547811ULL, 0x000fe200078fe8ffULL,
0x000000084d137824ULL, 0x000fe200078e00ffULL, 0xfffffff862627812ULL, 0x000fe200078ee211ULL,
0x0000000151127824ULL, 0x100fe200078e0205ULL, 0x0000005005117211ULL, 0x000fe200078fe8ffULL,
0x0000000851537824ULL, 0x000fe200078e00ffULL, 0xfffffff813607812ULL, 0x000fe200078ee210ULL,
0x0000000152137824ULL, 0x140fe200078e0205ULL, 0x0000007011117210ULL, 0x080fe20007f1e0ffULL,
0x0000000852667824ULL, 0x000fe200078e00ffULL, 0xfffffff853647812ULL, 0x000fe200078ee212ULL,
0x000000ffff4c7224ULL, 0x000fe200010e06ffULL, 0x00005e0003127a11ULL, 0x000fe200078448ffULL,
0x0000000154537824ULL, 0x000fe200078e0205ULL, 0xfffffff866667812ULL, 0x000fe200078ee213ULL,
0x0000000854687824ULL, 0x000fe200078e00ffULL, 0x0000001c05567811ULL, 0x000fe200078fe8ffULL,
0x000000014d4d7824ULL, 0x000fe200078e0250ULL, 0x00005f0003137a11ULL, 0x000fe200010f4c4cULL,
0x000000ffff4e7224ULL, 0x000fe200000e06ffULL, 0x00005e0011107a11ULL, 0x000fe200078048ffULL,
0x0000000151037824ULL, 0x100fe200078e0250ULL, 0xfffffff868687812ULL, 0x000fe200078ee253ULL,
0x000000014f4f7824ULL, 0x100fe200078e0250ULL, 0x000000704d4d7210ULL, 0x080fe20007f7e0ffULL,
0x0000000152537824ULL, 0x000fe200078e0250ULL, 0x00005f0011117a11ULL, 0x000fe200000f4c4eULL,
0x0000000154557824ULL, 0x100fe200078e0250ULL, 0x0000007003037210ULL, 0x080fe20007f5e0ffULL,
0x0000000156517824ULL, 0x040fe200078e0250ULL, 0x000000704f4f7210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff4e7224ULL, 0x000fe200018e06ffULL, 0x0000007053537210ULL, 0x080fe20007fbe0ffULL,
0x00000008566a7824ULL, 0x040fe200078e00ffULL, 0x0000007055557210ULL, 0x080fe20007f7e0ffULL,
0x000000ffff527224ULL, 0x000fe200010e06ffULL, 0x0000007051707210ULL, 0x000fe20007f9e0ffULL,
0x0000000156517824ULL, 0x000fe200078e0205ULL, 0x00005e004d4c7a11ULL, 0x000fe200078c48ffULL,
0x000000ffff547224ULL, 0x000fe200000e06ffULL, 0x00005e0003507a11ULL, 0x000fe200078448ffULL,
0x000000ffff587224ULL, 0x000fe200018e06ffULL, 0x0000000505567211ULL, 0x000fe200078fe8ffULL,
0x000000ffff5a7224ULL, 0x000fe200028e06ffULL, 0x00005f004d4d7a11ULL, 0x000fe200030f4c4eULL,
0x000000105e5b7824ULL, 0x100fe200078e0229ULL, 0x00005e004f4e7a11ULL, 0x000fe200078048ffULL,
0x00000010605d7824ULL, 0x000fe200078e0229ULL, 0xfffffff86a6a7812ULL, 0x000fe200078ee251ULL,
0x00000010645f7824ULL, 0x100fe200078e0229ULL, 0x00005f0003517a11ULL, 0x000fe200010f4c52ULL,
0x000000ffff037224ULL, 0x000fe200020e06ffULL, 0x00000007565c7812ULL, 0x000fe200078ec0ffULL,
0x0000001066617824ULL, 0x100fe200078e0229ULL, 0x00005e0070567a11ULL, 0x000fe200078648ffULL,
0x0000001068637824ULL, 0x100fe200078e0229ULL, 0x00005f004f4f7a11ULL, 0x000fe200000f4c54ULL,
0x000000106a657824ULL, 0x000fe200078e0229ULL, 0x00005e0053527a11ULL, 0x000fc400078048ffULL,
0x00005e0055547a11ULL, 0x000fe400078448ffULL, 0x0ffffff85c5c7812ULL, 0x000fe400078ef805ULL,
0x00005f0070577a11ULL, 0x000fe200018f4c03ULL, 0x0000000102037824ULL, 0x000fe200078e021dULL,
0x00005f0053537a11ULL, 0x000fe200000f4c5aULL, 0x000000105c597824ULL, 0x000fe200078e0229ULL,
0x00005f0055557a11ULL, 0x000fe200010f4c58ULL, 0x0000001003107825ULL, 0x000fc800078e0010ULL,
0x0000001003127825ULL, 0x040fe200078e0012ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010597faeULL, 0x0003e6000b901c46ULL, 0x00000010034c7825ULL, 0x040fe200078e004cULL,
0x00000000125b7faeULL, 0x0003e6000b901c46ULL, 0x00000010034e7825ULL, 0x040fe200078e004eULL,
0x000000004c5d7faeULL, 0x0003e6000b901c46ULL, 0x0000001003507825ULL, 0x000fc800078e0050ULL,
0x0000001003527825ULL, 0x000fc800078e0052ULL, 0x0000001003547825ULL, 0x000fc800078e0054ULL,
0x0000001003567825ULL, 0x000fc800078e0056ULL, 0x0000001062037824ULL, 0x000fca00078e0229ULL,
0x000000004e037faeULL, 0x0003e8000b901c46ULL, 0x00000000505f7faeULL, 0x0003e8000b901c46ULL,
0x0000000052617faeULL, 0x0003e8000b901c46ULL, 0x0000000054637faeULL, 0x0003e8000b901c46ULL,
0x0000000056657faeULL, 0x0003e4000b901c46ULL, 0x00000300ff037624ULL, 0x002fe200078e00ffULL,
0x0000000300107812ULL, 0x000fc800078ec0ffULL, 0x000000031000780cULL, 0x000fe40003f05270ULL,
0xfffffffd03037811ULL, 0x000fc800078e10ffULL, 0x0000000103037807ULL, 0x000fca0004000000ULL,
0x0000000100007824ULL, 0x000fe400078e0203ULL, 0xffffffffff037424ULL, 0x000fc600078e00ffULL,
0x000000b70000720cULL, 0x000fda0003f06070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x0000000100107824ULL, 0x000fe400078e020bULL, 0x00000004ff117424ULL, 0x000fc800078e00ffULL,
0x0000600010107625ULL, 0x000fca00078e0011ULL, 0x0000000610037981ULL, 0x000324000c1e1900ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01c64800024c7f8cULL, 0x0004e4000c80043fULL, 0x0000000000107805ULL, 0x002fc40000015200ULL,
0x01c64c0002137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x00afe4000780484dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff4e7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x00000012104f7210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09004f00780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404f00780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011413ULL,
0x0000004f12127211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000212127819ULL, 0x000fc80000001213ULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000014e4e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01c64c0002137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe4000780484dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x01c10000184c7984ULL, 0x000e680000000800ULL, 0x01c30000184d7984ULL, 0x0006a20000000800ULL,
0x000000334c00720bULL, 0x002fe20003f1d000ULL, 0x00011c527f007947ULL, 0x000fd8000b800000ULL,
0x00000000004e7806ULL, 0x008fc800000e0100ULL, 0x0000ffff4eff7812ULL, 0x000fe2000784c0ffULL,
0x0000045000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fd60003f0e170ULL,
0x000004200000a947ULL, 0x000fea0003800000ULL, 0x000000020a00780cULL, 0x000fe40003f05270ULL,
0x000000334c00720bULL, 0x000fe20003f54000ULL, 0x00011c327f007947ULL, 0x000fd8000b800000ULL,
0x00000000004f7806ULL, 0x000fc400010e0100ULL, 0x0000004c33118209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x000099104f107816ULL, 0x000fc600000000ffULL,
0x01c5001118008388ULL, 0x0003e20000000800ULL, 0x000000ff1000720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000004c33107209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff4fff7812ULL, 0x000fc6000780c0ffULL,
0x8000001033107221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL,
0x0000001000657308ULL, 0x000e640000000800ULL, 0x0000006506067220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff647819ULL, 0x000fe20000011605ULL,
0x00011b727f007947ULL, 0x000fea000b800000ULL, 0x00001f6465127589ULL, 0x0002e400000e0000ULL,
0x0000001214147220ULL, 0x08cfe40000410000ULL, 0x0000001215157220ULL, 0x080fe40000410000ULL,
0x000000120c0c7220ULL, 0x080fe40000410000ULL, 0x000000120d0d7220ULL, 0x000fc40000410000ULL,
0x0000001234347220ULL, 0x080fe40000410000ULL, 0x0000001235357220ULL, 0x080fe40000410000ULL,
0x0000001238387220ULL, 0x080fe40000410000ULL, 0x0000001239397220ULL, 0x080fe40000410000ULL,
0x0000001240407220ULL, 0x080fe40000410000ULL, 0x0000001241417220ULL, 0x000fc40000410000ULL,
0x000000123c3c7220ULL, 0x080fe40000410000ULL, 0x000000123d3d7220ULL, 0x080fe40000410000ULL,
0x0000001248487220ULL, 0x080fe40000410000ULL, 0x0000001249497220ULL, 0x080fe40000410000ULL,
0x0000001244447220ULL, 0x080fe40000410000ULL, 0x0000001245457220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff004fff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000805647811ULL, 0x002fe200078ff0ffULL,
0x00011a627f007947ULL, 0x000fea000b800000ULL, 0x00001f6465127589ULL, 0x0002e400000e0000ULL,
0x0000001216167220ULL, 0x08cfe40000410000ULL, 0x0000001217177220ULL, 0x080fe40000410000ULL,
0x000000120e0e7220ULL, 0x080fe40000410000ULL, 0x000000120f0f7220ULL, 0x080fe40000410000ULL,
0x0000001236367220ULL, 0x080fe40000410000ULL, 0x0000001237377220ULL, 0x000fc40000410000ULL,
0x000000123a3a7220ULL, 0x080fe40000410000ULL, 0x000000123b3b7220ULL, 0x080fe40000410000ULL,
0x0000001242427220ULL, 0x080fe40000410000ULL, 0x0000001243437220ULL, 0x080fe40000410000ULL,
0x000000123e3e7220ULL, 0x080fe40000410000ULL, 0x000000123f3f7220ULL, 0x000fc40000410000ULL,
0x000000124a4a7220ULL, 0x080fe40000410000ULL, 0x000000124b4b7220ULL, 0x080fe40000410000ULL,
0x0000001246467220ULL, 0x080fe40000410000ULL, 0x0000001247477220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff4fff7812ULL, 0x000fe4000780084eULL,
0x0000004c33337209ULL, 0x000fd60007810000ULL, 0x800000334c4c0221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b4c4c0820ULL, 0x000fc80000410000ULL, 0x0000004c00190308ULL, 0x000e640000000800ULL,
0x000000194d4d0220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000017000007945ULL, 0x000fe20003800000ULL,
0x000000064d067221ULL, 0x004fe20000010000ULL, 0x0000014000008947ULL, 0x000fea0003800000ULL,
0x00000019ff10723eULL, 0x000fe400000010ffULL, 0x00000002ff4c7819ULL, 0x000fe40000011605ULL,
0x0000541010657816ULL, 0x000fe20000000010ULL, 0x000118a27f007947ULL, 0x000fea000b800000ULL,
0x00001f4c651b7589ULL, 0x0002a400000e0000ULL, 0x000000084c647810ULL, 0x002fe20007ffe0ffULL,
0x000118e27f007947ULL, 0x000fea000b800000ULL, 0x00001f64651a7589ULL, 0x0002e400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000104c647810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff137424ULL, 0x000fe200078e00ffULL, 0x0000894000107802ULL, 0x000fe20000000f00ULL,
0xffffffffff127424ULL, 0x000fc400078e00ffULL, 0x0001225000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000184c647810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff137424ULL, 0x000fe200078e00ffULL, 0x000089a000107802ULL, 0x000fe20000000f00ULL,
0xffffffffff127424ULL, 0x004fc400078e00ffULL, 0x000121f000007944ULL, 0x018fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000130001c547811ULL, 0x000fcc00078e20ffULL, 0x000000005454783bULL, 0x000e620000000200ULL,
0x0001300023507811ULL, 0x000fc600078e20ffULL, 0x000000001f68783bULL, 0x000ee80000004200ULL,
0x00000000206c783bULL, 0x000fe80000004200ULL, 0x000000002160783bULL, 0x000fe80000004200ULL,
0x000000002264783bULL, 0x002fe80000004200ULL, 0x000000005050783bULL, 0x000e680000000200ULL,
0x00000000244c783bULL, 0x000ea80000004200ULL, 0x00000000255c783bULL, 0x000ea80000004200ULL,
0x000000002658783bULL, 0x000ea80000004200ULL, 0x000000002710783bULL, 0x004ea20000004200ULL,
0x0000001b54540231ULL, 0x000fc400003400ffULL, 0x0000001b56560231ULL, 0x000fe400003400ffULL,
0x0000001a55550231ULL, 0x088fe400003400ffULL, 0x0000001a57570231ULL, 0x000fce00003400ffULL,
0x000000685414723cULL, 0x000f620000041814ULL, 0x0000001b50500231ULL, 0x002fce00003400ffULL,
0x0000006a540c723cULL, 0x000f62000004180cULL, 0x0000001b52520231ULL, 0x000fe400003400ffULL,
0x0000001a51510231ULL, 0x080fe400003400ffULL, 0x0000001a53530231ULL, 0x000fc600003400ffULL,
0x0000006c5434723cULL, 0x040b6e0000041834ULL, 0x00005800036c7a24ULL, 0x030fe200078e02ffULL,
0x000000605468723cULL, 0x000fe60000041840ULL, 0x000000406c6c7824ULL, 0x000fca00078e00ffULL,
0x00000062543c723cULL, 0x040ff0000004183cULL, 0x0000006e5438723cULL, 0x040f700000041838ULL,
0x000000645460723cULL, 0x040f700000041848ULL, 0x000000665444723cULL, 0x000f700000041844ULL,
0x0000004c5054723cULL, 0x040b700000041814ULL, 0x0000004e504c723cULL, 0x040b70000004180cULL,
0x0000005c5040723cULL, 0x040b700000041834ULL, 0x0000005e5048723cULL, 0x060b700000041838ULL,
0x000000585034723cULL, 0x040b700000041868ULL, 0x0000005a5014723cULL, 0x040b70000004183cULL,
0x00000010500c723cULL, 0x044b700000041860ULL, 0x000000125050723cULL, 0x000b620000041844ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000071000009947ULL, 0x000fca0003800000ULL,
0x00000003ff3f7819ULL, 0x020fe20000011605ULL, 0x0000000102597824ULL, 0x000fe200078e021dULL,
0x000000c009117811ULL, 0x000fe400078e40ffULL, 0x000000083f3d7810ULL, 0x040fe40007ffe0ffULL,
0x0000001108107217ULL, 0x000fe40007800000ULL, 0x000000043f3b7810ULL, 0x000fe20007ffe0ffULL,
0x000000013d387824ULL, 0x000fe200078e0205ULL, 0x000000103f637810ULL, 0x000fe20007ffe0ffULL,
0x000000083d5f7824ULL, 0x000fe200078e00ffULL, 0x000000143f677810ULL, 0x040fe20007ffe0ffULL,
0x0000000110127824ULL, 0x000fe200078e0a11ULL, 0x0000000c3f457810ULL, 0x000fe20007ffe0ffULL,
0x000000013b137824ULL, 0x100fe200078e0205ULL, 0xfffffff85f5f7812ULL, 0x000fe200078ee238ULL,
0x000000083b3a7824ULL, 0x000fe200078e00ffULL, 0x000000183f6b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000163117824ULL, 0x000fe200078e0205ULL, 0x0000001c3f717810ULL, 0x000fe20007ffe0ffULL,
0x0000000863387824ULL, 0x000fe200078e00ffULL, 0xfffffff83a477812ULL, 0x000fe200078ee213ULL,
0x0000000167137824ULL, 0x040fe200078e0205ULL, 0x0000002012587817ULL, 0x000fe20003800000ULL,
0x00000008673a7824ULL, 0x000fe200078e00ffULL, 0xfffffff838657812ULL, 0x000fe200078ee211ULL,
0x0000000104117824ULL, 0x000fe200078e023fULL, 0x000000583d00720cULL, 0x000fe20003fa6070ULL,
0x0000000145107824ULL, 0x040fe200078e0205ULL, 0xfffffff83a697812ULL, 0x000fe200078ee213ULL,
0x0000000845617824ULL, 0x000fe200078e00ffULL, 0x0000006c11117210ULL, 0x000fe20007f5e0ffULL,
0x0000000104137824ULL, 0x000fc400078e023bULL, 0x000000016b397824ULL, 0x100fe200078e0205ULL,
0xfffffff861617812ULL, 0x000fe200078ee210ULL, 0x000000086b3c7824ULL, 0x000fe200078e00ffULL,
0x0000006c13137210ULL, 0x080fe20007f7e0ffULL, 0x000000ffff387224ULL, 0x000fe200010e06ffULL,
0x00005e0011107a11ULL, 0x000fe200078448ffULL, 0x00000001713a7824ULL, 0x000fe200078e0205ULL,
0xfffffff83c6f7812ULL, 0x000fe200078ee239ULL, 0x0000000104397824ULL, 0x040fe200078e023dULL,
0x00005f0011117a11ULL, 0x000fe200010f4c38ULL, 0x0000000871737824ULL, 0x000fe200078e00ffULL,
0x00005e0013127a11ULL, 0x000fe200078448ffULL, 0x000000ffff387224ULL, 0x000fe200018e06ffULL,
0x0000006c39397210ULL, 0x000fe20007f9e0ffULL, 0x00000001043d7824ULL, 0x040fe200078e0263ULL,
0x000000583b00720cULL, 0x000fe20003f66070ULL, 0x00000001043b7824ULL, 0x000fe200078e0245ULL,
0xfffffff873737812ULL, 0x000fe200078ee23aULL, 0x000000ffff3a7224ULL, 0x000fe200020e06ffULL,
0x00005f0013137a11ULL, 0x000fe200010f4c38ULL, 0x0000001059107825ULL, 0x000fe200078e0010ULL,
0x0000006c3b3b7210ULL, 0x000fc40007f9e0ffULL, 0x00005e0039387a11ULL, 0x000fe200078448ffULL,
0x00000001046d7824ULL, 0x040fe200078e026bULL, 0x0000006c3d3d7210ULL, 0x000fe20007fde0ffULL,
0x000000ffff3c7224ULL, 0x000fe200020e06ffULL, 0x000000583f00720cULL, 0x0c0fe20003f86070ULL,
0x000000013f3f7824ULL, 0x000fe200078e0205ULL, 0x00005f0039397a11ULL, 0x000fe200010f4c3aULL,
0x000000ffff3e7224ULL, 0x000fe200030e06ffULL, 0x00005e003b3a7a11ULL, 0x000fe200078448ffULL,
0x00000010475d7824ULL, 0x000fe200078e021eULL, 0x000000073f447812ULL, 0x000fe200078ec0ffULL,
0x00000001043f7824ULL, 0x000fe200078e0267ULL, 0x00005f003b3b7a11ULL, 0x000fe200010f4c3cULL,
0x0000001059127825ULL, 0x000fe200078e0012ULL, 0x000000584500720cULL, 0x000fc40003f46070ULL,
0x0ffffff844457812ULL, 0x000fe200078ef805ULL, 0x0000000104477824ULL, 0x000fe200078e0271ULL,
0x00005e003d3c7a11ULL, 0x000fe200078c48ffULL, 0x000000105f5f7824ULL, 0x100fe400078e021eULL,
0x00000010455b7824ULL, 0x000fe200078e021eULL, 0x00005f003d3d7a11ULL, 0x000fe200030f4c3eULL,
0x0000001059387825ULL, 0x000fe200078e0038ULL, 0x0000006c3f3f7210ULL, 0x080fe40007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000105b7faeULL, 0x0003e2000e101c46ULL,
0x0000006c6d457210ULL, 0x000fe20007f9e0ffULL, 0x0000001061617824ULL, 0x000fc400078e021eULL,
0x000000ffff447224ULL, 0x000fe200030e06ffULL, 0x00005e003f3e7a11ULL, 0x000fe200078c48ffULL,
0x00000000125d7faeULL, 0x0005e2000d901c46ULL, 0x0000006c47477210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff467224ULL, 0x000fe200020e06ffULL, 0x00005f003f3f7a11ULL, 0x000fe200030f4c44ULL,
0x00000000385f7faeULL, 0x0007e2000e901c46ULL, 0x00005e0045447a11ULL, 0x000fe200078c48ffULL,
0x000000ffff5a7224ULL, 0x000fe200018e06ffULL, 0x000000586300720cULL, 0x000fe20003f86070ULL,
0x0000001059107825ULL, 0x002fe200078e003aULL, 0x00005f0045457a11ULL, 0x000fc400030f4c46ULL,
0x00005e0047467a11ULL, 0x000fe200078648ffULL, 0x0000001059127825ULL, 0x004fe200078e003cULL,
0x000000586700720cULL, 0x080fe20003fc6070ULL, 0x0000000010617faeULL, 0x0007e2000d101c46ULL,
0x000000586b00720cULL, 0x080fe20003fa6070ULL, 0x0000001065657824ULL, 0x000fe200078e021eULL,
0x00005f0047477a11ULL, 0x000fe200018f4c5aULL, 0x00000010593a7825ULL, 0x000fe200078e003eULL,
0x000000587100720cULL, 0x000fe40003f66070ULL, 0x0000000012657faeULL, 0x0007e2000e101c46ULL,
0x0000001069697824ULL, 0x000fc400078e021eULL, 0x00000010593c7825ULL, 0x000fc600078e0044ULL,
0x000000003a697faeULL, 0x0007e2000f101c46ULL, 0x000000106f6f7824ULL, 0x000fe400078e021eULL,
0x00000010593e7825ULL, 0x000fc600078e0046ULL, 0x000000003c6f7faeULL, 0x0007e2000e901c46ULL,
0x0000001073737824ULL, 0x000fca00078e021eULL, 0x000000003e737faeULL, 0x0007e2000d901c46ULL,
0x0000063000007947ULL, 0x000fea0003800000ULL, 0x0000000c053a7811ULL, 0x060fe200078fe8ffULL,
0x0000000102597824ULL, 0x000fe200078e021dULL, 0x00000010053f7811ULL, 0x040fe400078fe8ffULL,
0x0000001c05477811ULL, 0x040fe200078fe8ffULL, 0x000000013a137824ULL, 0x140fe200078e0205ULL,
0x0000000405107811ULL, 0x040fe200078fe8ffULL, 0x000000083a3e7824ULL, 0x000fe200078e00ffULL,
0x0000000805387811ULL, 0x000fe200078fe8ffULL, 0x000000013f397824ULL, 0x000fe200078e0205ULL,
0x0000001805467811ULL, 0x000fe200078fe8ffULL, 0x000000083f447824ULL, 0x000fe200078e00ffULL,
0xfffffff83e617812ULL, 0x000fe200078ee213ULL, 0x00000008473e7824ULL, 0x000fe200078e00ffULL,
0x0000001405457811ULL, 0x000fe200078fe8ffULL, 0x0000000110117824ULL, 0x000fe200078e0205ULL,
0xfffffff844637812ULL, 0x000fe200078ee239ULL, 0x0000000147397824ULL, 0x000fe200078e0205ULL,
0x00000005053d7211ULL, 0x000fe200078fe8ffULL, 0x00000008103c7824ULL, 0x000fc400078e00ffULL,
0x00000001043b7824ULL, 0x000fe200078e023aULL, 0xfffffff83e697812ULL, 0x000fe200078ee239ULL,
0x0000000104397824ULL, 0x000fe200078e0238ULL, 0xfffffff83c5d7812ULL, 0x000fe200078ee211ULL,
0x0000000138127824ULL, 0x140fe200078e0205ULL, 0x0000000405117211ULL, 0x000fe200078fe8ffULL,
0x00000008385f7824ULL, 0x000fe200078e00ffULL, 0x0000006c39397210ULL, 0x080fe20007f9e0ffULL,
0x0000000146137824ULL, 0x140fe200078e0205ULL, 0x0000006c3b3b7210ULL, 0x080fe20007fbe0ffULL,
0x00000008463c7824ULL, 0x000fe200078e00ffULL, 0xfffffff85f5f7812ULL, 0x000fe200078ee212ULL,
0x0000000145127824ULL, 0x000fe200078e0205ULL, 0x0000006c11117210ULL, 0x000fe20007f5e0ffULL,
0x0000000845657824ULL, 0x000fe200078e00ffULL, 0xfffffff83c677812ULL, 0x000fe200078ee213ULL,
0x0000000104137824ULL, 0x000fc400078e0210ULL, 0x000000ffff3e7224ULL, 0x000fe200020e06ffULL,
0x00005e003b3a7a11ULL, 0x000fe200078848ffULL, 0x000000ffff3c7224ULL, 0x000fe200028e06ffULL,
0xfffffff865657812ULL, 0x000fe200078ee212ULL, 0x000000ffff127224ULL, 0x000fe200010e06ffULL,
0x0000006c13137210ULL, 0x080fe20007f7e0ffULL, 0x0000000104477824ULL, 0x040fe200078e0247ULL,
0x00005e0011107a11ULL, 0x000fe200078448ffULL, 0x000000105d5d7824ULL, 0x000fe200078e021eULL,
0x00005f003b3b7a11ULL, 0x000fe200020f4c3cULL, 0x000000ffff447224ULL, 0x000fe200018e06ffULL,
0x000000073d3c7812ULL, 0x000fe200078ec0ffULL, 0x00000001043d7824ULL, 0x040fe200078e023fULL,
0x00005f0011117a11ULL, 0x000fe200010f4c12ULL, 0x00000001043f7824ULL, 0x040fe200078e0245ULL,
0x00005e0013127a11ULL, 0x000fe200078448ffULL, 0x0000000104457824ULL, 0x000fe200078e0246ULL,
0x00005e0039387a11ULL, 0x000fe200078648ffULL, 0x0000001059107825ULL, 0x000fe200078e0010ULL,
0x0000006c3d3d7210ULL, 0x000fc40007f9e0ffULL, 0x00005f0013137a11ULL, 0x000fe200010f4c44ULL,
0x000000105f5f7824ULL, 0x000fe200078e021eULL, 0x0000006c3f3f7210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff5e7224ULL, 0x000fe200020e06ffULL, 0x00005f0039397a11ULL, 0x000fe200018f4c3eULL,
0x0000001059127825ULL, 0x000fe200078e0012ULL, 0x0000006c45457210ULL, 0x080fe40007f5e0ffULL,
0x0000006c47477210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff5c7224ULL, 0x000fe200028e06ffULL,
0x0ffffff83c5b7812ULL, 0x000fe200078ef805ULL, 0x000000ffff5a7224ULL, 0x000fe200010e06ffULL,
0x00005e003d3c7a11ULL, 0x000fe200078848ffULL, 0x000000ffff587224ULL, 0x000fe200018e06ffULL,
0x00005e003f3e7a11ULL, 0x000fe200078a48ffULL, 0x000000105b5b7824ULL, 0x000fe200078e021eULL,
0x00005e0045447a11ULL, 0x000fe200078448ffULL, 0x0000001059387825ULL, 0x000fe200078e0038ULL,
0x00005e0047467a11ULL, 0x000fc400078648ffULL, 0x00005f003d3d7a11ULL, 0x000fe200020f4c5eULL,
0x00000010593a7825ULL, 0x000fe200078e003aULL, 0x00005f003f3f7a11ULL, 0x000fe200028f4c5cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000105b7faeULL, 0x0003e2000b901c46ULL,
0x00005f0045457a11ULL, 0x000fe200010f4c5aULL, 0x0000001061617824ULL, 0x000fe200078e021eULL,
0x00005f0047477a11ULL, 0x000fe200018f4c58ULL, 0x00000010593c7825ULL, 0x000fe200078e003cULL,
0x00000000125d7faeULL, 0x0003e6000b901c46ULL, 0x0000001063637824ULL, 0x000fe200078e021eULL,
0x00000000385f7faeULL, 0x0003e2000b901c46ULL, 0x00000010593e7825ULL, 0x000fc600078e003eULL,
0x000000003a617faeULL, 0x0003e2000b901c46ULL, 0x0000001065657824ULL, 0x000fe400078e021eULL,
0x0000001059447825ULL, 0x000fe200078e0044ULL, 0x000000003c637faeULL, 0x0003e6000b901c46ULL,
0x0000001067677824ULL, 0x000fe200078e021eULL, 0x000000003e657faeULL, 0x0003e2000b901c46ULL,
0x0000001059467825ULL, 0x000fc600078e0046ULL, 0x0000000044677faeULL, 0x0003e2000b901c46ULL,
0x0000001069697824ULL, 0x000fca00078e021eULL, 0x0000000046697faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000017000007945ULL, 0x000fe20003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000014000008947ULL, 0x000fea0003800000ULL,
0x00000019ff10723eULL, 0x00afe400000010ffULL, 0x00000002ff387819ULL, 0x000fe40000011605ULL,
0x0000541010657816ULL, 0x000fe20000000010ULL, 0x000108127f007947ULL, 0x000fea000b800000ULL,
0x00001f38651b7589ULL, 0x0002a400000e0000ULL, 0x0000000838647810ULL, 0x002fe20007ffe0ffULL,
0x000108527f007947ULL, 0x000fea000b800000ULL, 0x00001f64651a7589ULL, 0x0002e400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x0000001038647810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff137424ULL, 0x000fe200078e00ffULL, 0x00009aa000107802ULL, 0x000fe20000000f00ULL,
0xffffffffff127424ULL, 0x000fc400078e00ffULL, 0x000110f000007944ULL, 0x00cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x0000001838647810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff137424ULL, 0x000fe200078e00ffULL, 0x00009b0000107802ULL, 0x000fe20000000f00ULL,
0xffffffffff127424ULL, 0x004fc400078e00ffULL, 0x0001109000007944ULL, 0x008fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00013000285c7811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000002a68783bULL, 0x00afe20000004200ULL,
0x000130002e107811ULL, 0x000fc600078e20ffULL, 0x000000005c5c783bULL, 0x000e680000000200ULL,
0x000000002d70783bULL, 0x000fe80000004200ULL, 0x000000002b60783bULL, 0x000fe80000004200ULL,
0x000000002c64783bULL, 0x000fe80000004200ULL, 0x000000001010783bULL, 0x004ea80000000200ULL,
0x000000002f38783bULL, 0x000ee80000004200ULL, 0x00000000303c783bULL, 0x000f280000004200ULL,
0x000000003144783bULL, 0x000ee80000004200ULL, 0x000000003258783bULL, 0x000ee20000004200ULL,
0x0000001b5c5c0231ULL, 0x002fc400003400ffULL, 0x0000001b5e5e0231ULL, 0x000fe400003400ffULL,
0x0000001a5d5d0231ULL, 0x080fe400003400ffULL, 0x0000001a5f5f0231ULL, 0x000fce00003400ffULL,
0x000000685c40723cULL, 0x000f620000041840ULL, 0x0000001b10100231ULL, 0x084fe400003400ffULL,
0x0000001b12120231ULL, 0x000fe400003400ffULL, 0x0000001a11110231ULL, 0x000fc600003400ffULL,
0x000000705c54723cULL, 0x000fe20000041854ULL, 0x0000001a13130231ULL, 0x000fce00003400ffULL,
0x000000725c4c723cULL, 0x040ff0000004184cULL, 0x0000006a5c68723cULL, 0x040ff00000041848ULL,
0x000000605c48723cULL, 0x040f700000041834ULL, 0x000000625c70723cULL, 0x040ff00000041814ULL,
0x000000645c60723cULL, 0x040f70000004180cULL, 0x000000665c50723cULL, 0x000f700000041850ULL,
0x000000381034723cULL, 0x068b700000041840ULL, 0x0000003c1040723cULL, 0x050b700000041848ULL,
0x000000441048723cULL, 0x040b700000041860ULL, 0x000000581014723cULL, 0x040b700000041854ULL,
0x0000005a100c723cULL, 0x040b70000004184cULL, 0x0000003a1038723cULL, 0x040b700000041868ULL,
0x0000003e103c723cULL, 0x040b700000041870ULL, 0x000000461044723cULL, 0x000b620000041850ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x000000c009117811ULL, 0x020fe200078e40ffULL,
0x01c69800ffff7f8cULL, 0x000fe6000c80043fULL, 0x000000081100720cULL, 0x000fda0003f06070ULL,
0x00002b9000000947ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000072000009947ULL, 0x000fea0003800000ULL, 0x00000003ff527819ULL, 0x100fe40000011605ULL,
0x0000002004137810ULL, 0x000fe40007ffe0ffULL, 0x0000000452567810ULL, 0x040fe40007ffe0ffULL,
0x0000000852587810ULL, 0x040fe40007ffe0ffULL, 0x0000001052627810ULL, 0x000fe20007ffe0ffULL,
0x0000000156117824ULL, 0x100fe200078e0205ULL, 0x0000000c525e7810ULL, 0x000fe20007ffe0ffULL,
0x00000008565a7824ULL, 0x000fe200078e00ffULL, 0x000000e009037811ULL, 0x000fe200078e40ffULL,
0x0000000158127824ULL, 0x000fe200078e0205ULL, 0x0000001452667810ULL, 0x000fe20007ffe0ffULL,
0x00000008584d7824ULL, 0x000fe200078e00ffULL, 0xfffffff85a5a7812ULL, 0x000fe200078ee211ULL,
0x0000000152117824ULL, 0x000fe200078e0213ULL, 0x0000000308107217ULL, 0x000fe20007800000ULL,
0x0000000862647824ULL, 0x040fe200078e00ffULL, 0xfffffff84d5c7812ULL, 0x000fe200078ee212ULL,
0x00000001624d7824ULL, 0x100fe200078e0205ULL, 0x0000006c11117210ULL, 0x000fe20007f1e0ffULL,
0x000000015e4c7824ULL, 0x000fe200078e0205ULL, 0x00000018526a7810ULL, 0x000fe20007ffe0ffULL,
0x000000085e4f7824ULL, 0x000fe200078e00ffULL, 0xfffffff864647812ULL, 0x000fe200078ee24dULL,
0x00000001664e7824ULL, 0x000fe200078e0205ULL, 0x0000001c52707810ULL, 0x000fe20007ffe0ffULL,
0x0000000866517824ULL, 0x000fe200078e00ffULL, 0xfffffff84f607812ULL, 0x000fe200078ee24cULL,
0x00000001564d7824ULL, 0x000fc400078e0213ULL, 0x0000000110037824ULL, 0x000fe200078e0a03ULL,
0xfffffff851687812ULL, 0x000fe200078ee24eULL, 0x000000ffff127224ULL, 0x000fe200000e06ffULL,
0x00005e0011107a11ULL, 0x000fe200078048ffULL, 0x00000001584f7824ULL, 0x100fe200078e0213ULL,
0x0000002003037817ULL, 0x000fe20003800000ULL, 0x000000015e517824ULL, 0x100fe200078e0213ULL,
0x00005f0011117a11ULL, 0x000fe200000f4c12ULL, 0x0000000162537824ULL, 0x100fe400078e0213ULL,
0x0000000166557824ULL, 0x000fc400078e0213ULL, 0x000000016a577824ULL, 0x100fe400078e0213ULL,
0x0000000170597824ULL, 0x000fe200078e0213ULL, 0x0000006c4d137210ULL, 0x080fe20007f7e0ffULL,
0x000000016a507824ULL, 0x100fe200078e0205ULL, 0x0000006c4f4d7210ULL, 0x080fe20007f1e0ffULL,
0x0000000170547824ULL, 0x000fe200078e0205ULL, 0x0000006c514f7210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff4c7224ULL, 0x000fe200018e06ffULL, 0x0000006c53517210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff4e7224ULL, 0x000fe200000e06ffULL, 0x0000006c55537210ULL, 0x080fe20007f7e0ffULL,
0x00000010605d7824ULL, 0x100fe200078e0229ULL, 0x0000006c57557210ULL, 0x080fe20007fbe0ffULL,
0x000000086a577824ULL, 0x000fe200078e00ffULL, 0x00005e0013127a11ULL, 0x000fe200078c48ffULL,
0x00000010645f7824ULL, 0x000fe200078e0229ULL, 0x0000006c596c7210ULL, 0x000fe20007f9e0ffULL,
0x0000000870597824ULL, 0x000fe200078e00ffULL, 0xfffffff8576e7812ULL, 0x000fe200078ee250ULL,
0x0000000152507824ULL, 0x000fe200078e0205ULL, 0x00005f0013137a11ULL, 0x000fe200030f4c4cULL,
0x000000ffff577224ULL, 0x000fe200020e06ffULL, 0x00005e004d4c7a11ULL, 0x000fe200078048ffULL,
0x0000001068617824ULL, 0x000fe200078e0229ULL, 0xfffffff859727812ULL, 0x000fe200078ee254ULL,
0x0000000102597824ULL, 0x000fe200078e021dULL, 0x0000000750547812ULL, 0x000fe200078ec0ffULL,
0x000000ffff507224ULL, 0x000fe200010e06ffULL, 0x00005f004d4d7a11ULL, 0x000fe200000f4c4eULL,
0x0000001059107825ULL, 0x000fe200078e0010ULL, 0x00005e004f4e7a11ULL, 0x000fc400078c48ffULL,
0x000000035200720cULL, 0x080fe20003f46070ULL, 0x000000ffff527224ULL, 0x000fe200008e06ffULL,
0x0ffffff854547812ULL, 0x000fe200078ef805ULL, 0x000000106e637824ULL, 0x100fe200078e0229ULL,
0x00005f004f4f7a11ULL, 0x000fe400030f4c50ULL, 0x00005e0051507a11ULL, 0x040fe200078c48ffULL,
0x00000010545b7824ULL, 0x000fe200078e0229ULL, 0x000000035800720cULL, 0x080fe20003f26070ULL,
0x000000ffff547224ULL, 0x000fe200018e06ffULL, 0x00005f0051517a11ULL, 0x000fe200030f4c52ULL,
0x000000ffff587224ULL, 0x000fe200028e06ffULL, 0x00005e0053527a11ULL, 0x000fe200078c48ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000105b7faeULL, 0x0003e2000d101c46ULL,
0x000000035600720cULL, 0x000fc40003f06070ULL, 0x00005f0053537a11ULL, 0x000fe400030f4c54ULL,
0x00005e0055547a11ULL, 0x000fe400078a48ffULL, 0x00005e006c567a11ULL, 0x000fe400078c48ffULL,
0x000000035e00720cULL, 0x080fe40003f66070ULL, 0x000000036200720cULL, 0x080fe20003f46070ULL,
0x0000001059107825ULL, 0x002fe200078e0012ULL, 0x000000036600720cULL, 0x000fc40003f86070ULL,
0x00005f0055557a11ULL, 0x000fe200028f4c58ULL, 0x000000105c5b7824ULL, 0x000fe200078e0229ULL,
0x000000036a00720cULL, 0x080fe20003fa6070ULL, 0x0000001059127825ULL, 0x040fe200078e004cULL,
0x00005f006c577a11ULL, 0x000fe400030f4c57ULL, 0x000000037000720cULL, 0x000fe20003fc6070ULL,
0x000000105a037824ULL, 0x000fe400078e0229ULL, 0x00000010594c7825ULL, 0x000fc600078e004eULL,
0x0000000010037faeULL, 0x0003e2000c101c46ULL, 0x00000010594e7825ULL, 0x000fc600078e0050ULL,
0x00000000125b7faeULL, 0x0003e2000c901c46ULL, 0x0000001059507825ULL, 0x000fc600078e0052ULL,
0x000000004c5d7faeULL, 0x0003e2000d901c46ULL, 0x0000001059527825ULL, 0x000fc600078e0054ULL,
0x000000004e5f7faeULL, 0x0003e2000d101c46ULL, 0x0000001072297824ULL, 0x000fe400078e0229ULL,
0x0000001059547825ULL, 0x000fe200078e0056ULL, 0x0000000050617faeULL, 0x0003e8000e101c46ULL,
0x0000000052637faeULL, 0x0003e8000e901c46ULL, 0x0000000054297faeULL, 0x0003e2000f101c46ULL,
0x0000064000007947ULL, 0x000fea0003800000ULL, 0x00000004054d7811ULL, 0x040fe400078fe8ffULL,
0x0000000c054f7811ULL, 0x000fc400078fe8ffULL, 0x00000008054e7811ULL, 0x000fe200078fe8ffULL,
0x000000014d037824ULL, 0x140fe200078e0205ULL, 0x00000020044c7810ULL, 0x000fe20007ffe0ffULL,
0x000000084d507824ULL, 0x000fe200078e00ffULL, 0x0000001005517811ULL, 0x000fe200078fe8ffULL,
0x000000084f547824ULL, 0x000fe200078e00ffULL, 0x0000001405537811ULL, 0x000fe200078fe8ffULL,
0x000000014e107824ULL, 0x000fe200078e0205ULL, 0xfffffff850507812ULL, 0x000fe200078ee203ULL,
0x000000014f037824ULL, 0x000fe200078e0205ULL, 0x0000001805557811ULL, 0x040fe200078fe8ffULL,
0x000000084e117824ULL, 0x000fe200078e00ffULL, 0x0000000505137211ULL, 0x000fe200078fe8ffULL,
0x0000000853587824ULL, 0x000fe200078e00ffULL, 0xfffffff854547812ULL, 0x000fe200078ee203ULL,
0x0000000155577824ULL, 0x100fe200078e0205ULL, 0x0000004c05037211ULL, 0x000fe200078fe8ffULL,
0x00000008555a7824ULL, 0x000fe200078e00ffULL, 0xfffffff811527812ULL, 0x000fe200078ee210ULL,
0x0000000151107824ULL, 0x000fe200078e0205ULL, 0x0000006c03037210ULL, 0x080fe20007f1e0ffULL,
0x0000000851117824ULL, 0x040fe200078e00ffULL, 0xfffffff85a5a7812ULL, 0x000fe200078ee257ULL,
0x0000000151517824ULL, 0x000fe200078e024cULL, 0x0000001c05577811ULL, 0x000fe200078fe8ffULL,
0x000000ffff127224ULL, 0x000fe200000e06ffULL, 0xfffffff811567812ULL, 0x000fe200078ee210ULL,
0x0000000153117824ULL, 0x100fe200078e0205ULL, 0x00005e0003107a11ULL, 0x000fe200078048ffULL,
0x0000000157597824ULL, 0x000fe200078e0205ULL, 0x0000006c51517210ULL, 0x080fe20007f5e0ffULL,
0x00000008575c7824ULL, 0x000fe200078e00ffULL, 0xfffffff858587812ULL, 0x000fe200078ee211ULL,
0x0000000153537824ULL, 0x000fe200078e024cULL, 0x00005f0003117a11ULL, 0x000fe200000f4c12ULL,
0x000000014f037824ULL, 0x100fe200078e024cULL, 0x0000000713127812ULL, 0x000fe200078ec0ffULL,
0x000000014d137824ULL, 0x100fe200078e024cULL, 0xfffffff85c5c7812ULL, 0x000fe200078ee259ULL,
0x000000014e4d7824ULL, 0x100fe200078e024cULL, 0x0ffffff8124e7812ULL, 0x000fe200078ef805ULL,
0x0000000155557824ULL, 0x100fe200078e024cULL, 0x0000006c13137210ULL, 0x080fe20007f9e0ffULL,
0x00000001574f7824ULL, 0x000fe200078e024cULL, 0x0000006c03037210ULL, 0x080fe20007f7e0ffULL,
0x00000010505b7824ULL, 0x100fe200078e0229ULL, 0x0000006c4d4d7210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff4c7224ULL, 0x000fe200020e06ffULL, 0x0000006c53537210ULL, 0x080fe20007f1e0ffULL,
0x000000104e597824ULL, 0x100fe200078e0229ULL, 0x0000006c55557210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff507224ULL, 0x000fe200018e06ffULL, 0x00005e0013127a11ULL, 0x000fe200078c48ffULL,
0x00000010525d7824ULL, 0x100fe200078e0229ULL, 0x0000006c4f6c7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff527224ULL, 0x000fe200008e06ffULL, 0x00005e00034e7a11ULL, 0x000fe200078648ffULL,
0x0000001056617824ULL, 0x100fe200078e0229ULL, 0x00005f0013137a11ULL, 0x000fe200030f4c4cULL,
0x00000010545f7824ULL, 0x100fe200078e0229ULL, 0x00005f00034f7a11ULL, 0x000fe200018f4c50ULL,
0x000000ffff037224ULL, 0x000fe200020e06ffULL, 0x00005e004d4c7a11ULL, 0x040fe200078248ffULL,
0x0000001058637824ULL, 0x100fe200078e0229ULL, 0x00005e006c567a11ULL, 0x000fe200078648ffULL,
0x000000105a657824ULL, 0x100fe200078e0229ULL, 0x00005f004d4d7a11ULL, 0x000fe200008f4c52ULL,
0x000000105c297824ULL, 0x000fe200078e0229ULL, 0x00005e0051507a11ULL, 0x000fe200078248ffULL,
0x000000ffff5c7224ULL, 0x000fe200010e06ffULL, 0x00005f006c577a11ULL, 0x000fe200018f4c03ULL,
0x000000ffff5a7224ULL, 0x000fe200000e06ffULL, 0x00005e0053527a11ULL, 0x000fe200078048ffULL,
0x000000ffff587224ULL, 0x000fe200028e06ffULL, 0x00005e0055547a11ULL, 0x000fe200078448ffULL,
0x0000000102037824ULL, 0x000fe200078e021dULL, 0x00005f0051517a11ULL, 0x000fc400008f4c5cULL,
0x00005f0053537a11ULL, 0x000fe200000f4c5aULL, 0x0000001003107825ULL, 0x000fe200078e0010ULL,
0x00005f0055557a11ULL, 0x000fc600010f4c58ULL, 0x0000001003127825ULL, 0x040fe200078e0012ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010597faeULL, 0x0003e6000b901c46ULL,
0x00000010034c7825ULL, 0x040fe200078e004cULL, 0x00000000125b7faeULL, 0x0003e6000b901c46ULL,
0x00000010034e7825ULL, 0x040fe200078e004eULL, 0x000000004c5d7faeULL, 0x0003e6000b901c46ULL,
0x0000001003507825ULL, 0x040fe200078e0050ULL, 0x000000004e5f7faeULL, 0x0003e6000b901c46ULL,
0x0000001003527825ULL, 0x040fe200078e0052ULL, 0x0000000050617faeULL, 0x0003e6000b901c46ULL,
0x0000001003547825ULL, 0x040fe200078e0054ULL, 0x0000000052637faeULL, 0x0003e6000b901c46ULL,
0x0000001003567825ULL, 0x000fe200078e0056ULL, 0x0000000054657faeULL, 0x0003e8000b901c46ULL,
0x0000000056297faeULL, 0x0003e4000b901c46ULL, 0x00000300ff037624ULL, 0x002fe200078e00ffULL,
0x0000000300107812ULL, 0x000fc800078ec0ffULL, 0x000000031000780cULL, 0x000fe40003f05270ULL,
0xfffffffd03037811ULL, 0x000fc800078e10ffULL, 0x0000000103037807ULL, 0x000fca0004000000ULL,
0x0000000100007824ULL, 0x000fe400078e0203ULL, 0xffffffffff037424ULL, 0x000fc600078e00ffULL,
0x000000b70000720cULL, 0x000fda0003f06070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x0000000100107824ULL, 0x000fe400078e020bULL, 0x00000004ff117424ULL, 0x000fc800078e00ffULL,
0x0000600010107625ULL, 0x000fca00078e0011ULL, 0x0000000610037981ULL, 0x000324000c1e1900ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01c66800024c7f8cULL, 0x0004e4000c80043fULL, 0x0000000000107805ULL, 0x002fc40000015200ULL,
0x01c66c0002137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x00afe4000780484dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff4e7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x0000001210297210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09002900780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402900780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011413ULL,
0x0000002912127211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000212127819ULL, 0x000fc80000001213ULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000014e4e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01c66c0002137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe4000780484dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x01c18000184c7984ULL, 0x000e680000000800ULL, 0x01c3800018297984ULL, 0x0006a20000000800ULL,
0x000000334c00720bULL, 0x002fe20003f1d000ULL, 0x0000f3c27f007947ULL, 0x000fd8000b800000ULL,
0x00000000004d7806ULL, 0x008fc800000e0100ULL, 0x0000ffff4dff7812ULL, 0x000fe2000782c0ffULL,
0x0000045000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fd60003f0e170ULL,
0x0000042000009947ULL, 0x000fea0003800000ULL, 0x000000030a00780cULL, 0x000fe40003f05270ULL,
0x000000334c00720bULL, 0x000fe20003f34000ULL, 0x0000f3a27f007947ULL, 0x000fd8000b800000ULL,
0x00000000004e7806ULL, 0x000fc400008e0100ULL, 0x000000334c118209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x000099104e107816ULL, 0x000fc600000000ffULL,
0x01c5801118008388ULL, 0x0003e20000000800ULL, 0x000000ff1000720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x000000334c107209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff4eff7812ULL, 0x000fc6000780c0ffULL,
0x0000003310107221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL,
0x0000001000657308ULL, 0x000e640000000800ULL, 0x0000006506067220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff647819ULL, 0x000fe20000011605ULL,
0x0000f2f27f007947ULL, 0x000fea000b800000ULL, 0x00001f6465127589ULL, 0x0002e400000e0000ULL,
0x0000001214147220ULL, 0x08cfe40000410000ULL, 0x0000001215157220ULL, 0x080fe40000410000ULL,
0x000000120c0c7220ULL, 0x080fe40000410000ULL, 0x000000120d0d7220ULL, 0x000fc40000410000ULL,
0x0000001234347220ULL, 0x080fe40000410000ULL, 0x0000001235357220ULL, 0x080fe40000410000ULL,
0x0000001238387220ULL, 0x080fe40000410000ULL, 0x0000001239397220ULL, 0x080fe40000410000ULL,
0x0000001240407220ULL, 0x080fe40000410000ULL, 0x0000001241417220ULL, 0x000fc40000410000ULL,
0x000000123c3c7220ULL, 0x080fe40000410000ULL, 0x000000123d3d7220ULL, 0x080fe40000410000ULL,
0x0000001248487220ULL, 0x080fe40000410000ULL, 0x0000001249497220ULL, 0x080fe40000410000ULL,
0x0000001244447220ULL, 0x080fe40000410000ULL, 0x0000001245457220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff004eff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000805647811ULL, 0x002fe200078ff0ffULL,
0x0000f1e27f007947ULL, 0x000fea000b800000ULL, 0x00001f6465127589ULL, 0x0002e400000e0000ULL,
0x0000001216167220ULL, 0x08cfe40000410000ULL, 0x0000001217177220ULL, 0x080fe40000410000ULL,
0x000000120e0e7220ULL, 0x080fe40000410000ULL, 0x000000120f0f7220ULL, 0x080fe40000410000ULL,
0x0000001236367220ULL, 0x080fe40000410000ULL, 0x0000001237377220ULL, 0x000fc40000410000ULL,
0x000000123a3a7220ULL, 0x080fe40000410000ULL, 0x000000123b3b7220ULL, 0x080fe40000410000ULL,
0x0000001242427220ULL, 0x080fe40000410000ULL, 0x0000001243437220ULL, 0x080fe40000410000ULL,
0x000000123e3e7220ULL, 0x080fe40000410000ULL, 0x000000123f3f7220ULL, 0x000fc40000410000ULL,
0x000000124a4a7220ULL, 0x080fe40000410000ULL, 0x000000124b4b7220ULL, 0x080fe40000410000ULL,
0x0000001246467220ULL, 0x080fe40000410000ULL, 0x0000001247477220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff4eff7812ULL, 0x000fe4000780084dULL,
0x000000334c337209ULL, 0x000fd60007810000ULL, 0x800000334c4c0221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b4c4c0820ULL, 0x000fc80000410000ULL, 0x0000004c00190308ULL, 0x000e640000000800ULL,
0x0000001929290220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000017000007945ULL, 0x000fe20003800000ULL,
0x0000000629067221ULL, 0x004fe20000010000ULL, 0x0000014000008947ULL, 0x000fea0003800000ULL,
0x00000019ff10723eULL, 0x000fe400000010ffULL, 0x00000002ff187819ULL, 0x000fe40000011605ULL,
0x0000541010657816ULL, 0x000fe20000000010ULL, 0x0000f0227f007947ULL, 0x000fea000b800000ULL,
0x00001f18651b7589ULL, 0x0002a400000e0000ULL, 0x0000000818647810ULL, 0x002fe20007ffe0ffULL,
0x0000f0627f007947ULL, 0x000fea000b800000ULL, 0x00001f64651a7589ULL, 0x0002e400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x0000001018647810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff137424ULL, 0x000fe200078e00ffULL, 0x0000b4c000107802ULL, 0x000fe20000000f00ULL,
0xffffffffff127424ULL, 0x000fc400078e00ffULL, 0x0000f6d000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x0000001818647810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff137424ULL, 0x000fe200078e00ffULL, 0x0000b52000107802ULL, 0x000fe20000000f00ULL,
0xffffffffff127424ULL, 0x004fc400078e00ffULL, 0x0000f67000007944ULL, 0x018fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000138001c1c7811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000002054783bULL, 0x000fe20000004200ULL,
0x0001380023107811ULL, 0x000fc600078e20ffULL, 0x000000001c4c783bULL, 0x000e680000000200ULL,
0x000000001f50783bULL, 0x000fe80000004200ULL, 0x000000002158783bULL, 0x000fe80000004200ULL,
0x00000000225c783bULL, 0x0007e80000004200ULL, 0x000000001010783bULL, 0x006e680000000200ULL,
0x000000002564783bULL, 0x000ea80000004200ULL, 0x000000002460783bULL, 0x000ea80000004200ULL,
0x000000002668783bULL, 0x000ea80000004200ULL, 0x00000000276c783bULL, 0x0004a20000004200ULL,
0x0000001b4c4c0231ULL, 0x000fc400003400ffULL, 0x0000001b4e4e0231ULL, 0x000fe400003400ffULL,
0x0000001a4d4d0231ULL, 0x088fe400003400ffULL, 0x0000001a4f4f0231ULL, 0x000fce00003400ffULL,
0x000000544c20723cULL, 0x000fe20000041834ULL, 0x0000001b10100231ULL, 0x082fe400003400ffULL,
0x0000001b12120231ULL, 0x000fe400003400ffULL, 0x0000001a11110231ULL, 0x000fc600003400ffULL,
0x000000564c38723cULL, 0x000f620000041838ULL, 0x0000001a13130231ULL, 0x000fce00003400ffULL,
0x000000504c14723cULL, 0x040f700000041814ULL, 0x000000584c34723cULL, 0x040ff00000041840ULL,
0x0000005a4c3c723cULL, 0x040f70000004183cULL, 0x000000524c50723cULL, 0x040f70000004180cULL,
0x0000005c4c48723cULL, 0x040f700000041848ULL, 0x0000005e4c40723cULL, 0x000f700000041844ULL,
0x000000661024723cULL, 0x064f700000041838ULL, 0x00000060100c723cULL, 0x040f700000041814ULL,
0x0000006a1038723cULL, 0x040f70000004183cULL, 0x000000621014723cULL, 0x040f700000041850ULL,
0x000000641020723cULL, 0x040f700000041820ULL, 0x000000681034723cULL, 0x040f700000041834ULL,
0x0000006c103c723cULL, 0x040f700000041848ULL, 0x0000006e1040723cULL, 0x000b6e0000041840ULL,
0x0000030009117a10ULL, 0x020fe20007ffe0ffULL, 0x0000580003127a24ULL, 0x010fc600078e02ffULL,
0x0000000111107810ULL, 0x000fe20007ffe0ffULL, 0x0000004012477824ULL, 0x000fc600078e00ffULL,
0x000000071000720cULL, 0x000fe20003f26070ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000071000009947ULL, 0x000fea0003800000ULL, 0x0000010011117824ULL, 0x000fe200078e00ffULL,
0x00000003ff4b7819ULL, 0x000fe20000011605ULL, 0x00000001024f7824ULL, 0x000fc600078e021dULL,
0x0000001108107217ULL, 0x000fe20007800000ULL, 0x000000014b4a7824ULL, 0x040fe200078e0205ULL,
0x000000084b557810ULL, 0x040fe40007ffe0ffULL, 0x0000000c4b597810ULL, 0x040fe20007ffe0ffULL,
0x0000000110187824ULL, 0x000fe200078e0a11ULL, 0x000000044b517810ULL, 0x000fe20007ffe0ffULL,
0x0000000155107824ULL, 0x100fe200078e0205ULL, 0x000000104b5d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000855577824ULL, 0x000fe200078e00ffULL, 0x000000184b657810ULL, 0x000fe20007ffe0ffULL,
0x0000000159117824ULL, 0x000fe200078e0205ULL, 0x000000144b617810ULL, 0x000fe20007ffe0ffULL,
0x00000008591c7824ULL, 0x000fe200078e00ffULL, 0xfffffff857577812ULL, 0x000fe200078ee210ULL,
0x0000000104107824ULL, 0x000fe200078e024bULL, 0x0000001c4b697810ULL, 0x000fe20007ffe0ffULL,
0x0000000151127824ULL, 0x040fe200078e0205ULL, 0xfffffff81c5b7812ULL, 0x000fe200078ee211ULL,
0x0000000851537824ULL, 0x000fe200078e00ffULL, 0x0000004710117210ULL, 0x080fe20007f3e0ffULL,
0x0000000104107824ULL, 0x000fe200078e0251ULL, 0x0000002018187817ULL, 0x000fe20003800000ULL,
0x000000085d5f7824ULL, 0x000fe200078e00ffULL, 0xfffffff853537812ULL, 0x000fe200078ee212ULL,
0x000000015d127824ULL, 0x100fe200078e0205ULL, 0x0000004710137210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff447224ULL, 0x000fe200008e06ffULL, 0x00005e0011107a11ULL, 0x000fe200078248ffULL,
0x0000000165297824ULL, 0x100fe200078e0205ULL, 0xfffffff85f5f7812ULL, 0x000fe200078ee212ULL,
0x000000ffff1c7224ULL, 0x000fe200010e06ffULL, 0x00005e0013127a11ULL, 0x000fe200078448ffULL,
0x0000000865487824ULL, 0x000fe200078e00ffULL, 0x00005f0011117a11ULL, 0x000fe200008f4c44ULL,
0x00000001611f7824ULL, 0x000fe200078e0205ULL, 0x00005f0013137a11ULL, 0x000fe200010f4c1cULL,
0x00000001041c7824ULL, 0x000fe200078e0255ULL, 0xfffffff848677812ULL, 0x000fe200078ee229ULL,
0x0000000861467824ULL, 0x000fe200078e00ffULL, 0x000000074a4a7812ULL, 0x000fe200078ec0ffULL,
0x0000000104447824ULL, 0x000fe200078e0259ULL, 0x000000471c457210ULL, 0x080fe20007f7e0ffULL,
0x0000000104487824ULL, 0x000fe200078e025dULL, 0xfffffff846637812ULL, 0x000fe200078ee21fULL,
0x00000001044c7824ULL, 0x000fe200078e0261ULL, 0x00000047441c7210ULL, 0x080fe20007f3e0ffULL,
0x00000001044e7824ULL, 0x040fe200078e0265ULL, 0x00005e0045447a11ULL, 0x000fe200078c48ffULL,
0x0000000104507824ULL, 0x000fe200078e0269ULL, 0x0000004748487210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff467224ULL, 0x000fe200018e06ffULL, 0x000000474c497210ULL, 0x080fe20007f7e0ffULL,
0x00000001694c7824ULL, 0x000fe200078e0205ULL, 0x000000474e297210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff1d7224ULL, 0x000fe200010e06ffULL, 0x00000047501f7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff477224ULL, 0x000fe200008e06ffULL, 0x00005f0045457a11ULL, 0x000fe200030f4c46ULL,
0x00000008696b7824ULL, 0x000fe200078e00ffULL, 0x00005e001c467a11ULL, 0x000fe200078c48ffULL,
0x000000104f107825ULL, 0x000fe200078e0010ULL, 0x000000184b00720cULL, 0x000fc40003f26070ULL,
0x00005f001c477a11ULL, 0x000fe200030f4c47ULL, 0x0000001053537824ULL, 0x000fe200078e021eULL,
0x00005e00481c7a11ULL, 0x000fe200078c48ffULL, 0x000000104f127825ULL, 0x000fe200078e0012ULL,
0x0ffffff84a4b7812ULL, 0x000fe400078ef805ULL, 0x00005f00481d7a11ULL, 0x000fe200030f4c1dULL,
0x000000ffff4a7224ULL, 0x000fe200018e06ffULL, 0x000000185100720cULL, 0x080fe20003f46070ULL,
0x000000104b4d7824ULL, 0x000fe200078e021eULL, 0x00005e0049487a11ULL, 0x000fe200078c48ffULL,
0x000000ffff4e7224ULL, 0x000fe200020e06ffULL, 0xfffffff86b6b7812ULL, 0x000fe200078ee24cULL,
0x000000ffff4c7224ULL, 0x000fe200028e06ffULL, 0x00005f0049497a11ULL, 0x000fe200030f4c4aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000104d7faeULL, 0x0003e2000c901c46ULL,
0x00005e00294a7a11ULL, 0x000fe200078c48ffULL, 0x0000001057577824ULL, 0x100fe200078e021eULL,
0x000000185500720cULL, 0x080fe20003f26070ULL, 0x000000105b5b7824ULL, 0x000fe200078e021eULL,
0x00005f00294b7a11ULL, 0x000fe200030f4c4cULL, 0x0000000012537faeULL, 0x0005e2000d101c46ULL,
0x00005e001f4c7a11ULL, 0x000fe200078848ffULL, 0x000000105f5f7824ULL, 0x100fe200078e021eULL,
0x000000185900720cULL, 0x080fe20003f66070ULL, 0x0000001063637824ULL, 0x000fe200078e021eULL,
0x000000185d00720cULL, 0x080fe20003fa6070ULL, 0x000000104f107825ULL, 0x002fe200078e0044ULL,
0x000000186100720cULL, 0x000fc40003fc6070ULL, 0x000000186500720cULL, 0x080fe20003f46070ULL,
0x0000001067677824ULL, 0x000fe200078e021eULL, 0x00005f001f4d7a11ULL, 0x000fe200020f4c4eULL,
0x000000104f127825ULL, 0x004fe200078e0046ULL, 0x000000186900720cULL, 0x000fe20003f86070ULL,
0x0000000010577faeULL, 0x0003e4000c901c46ULL, 0x000000106b6b7824ULL, 0x000fe400078e021eULL,
0x000000104f1c7825ULL, 0x040fe200078e001cULL, 0x00000000125b7faeULL, 0x0003e6000d901c46ULL,
0x000000104f1e7825ULL, 0x040fe200078e0048ULL, 0x000000001c5f7faeULL, 0x0003e6000e901c46ULL,
0x000000104f447825ULL, 0x040fe200078e004aULL, 0x000000001e637faeULL, 0x0003e6000f101c46ULL,
0x000000104f467825ULL, 0x000fe200078e004cULL, 0x0000000044677faeULL, 0x0003e8000d101c46ULL,
0x00000000466b7faeULL, 0x0003e2000e101c46ULL, 0x0000063000007947ULL, 0x000fea0003800000ULL,
0x0000000405117811ULL, 0x040fe400078fe8ffULL, 0x0000000805297811ULL, 0x000fc400078fe8ffULL,
0x0000000c05447811ULL, 0x000fe200078fe8ffULL, 0x0000000111107824ULL, 0x100fe200078e0205ULL,
0x0000001005457811ULL, 0x000fe200078fe8ffULL, 0x00000008114d7824ULL, 0x000fe200078e00ffULL,
0x0000001405487811ULL, 0x000fe200078fe8ffULL, 0x00000008294f7824ULL, 0x000fe200078e00ffULL,
0x0000001805497811ULL, 0x000fe200078fe8ffULL, 0x0000000144127824ULL, 0x140fe200078e0205ULL,
0xfffffff84d4d7812ULL, 0x000fe200078ee210ULL, 0x0000000129107824ULL, 0x000fe200078e0205ULL,
0x0000001c054b7811ULL, 0x000fe200078fe8ffULL, 0x0000000844517824ULL, 0x000fc400078e00ffULL,
0x0000000145137824ULL, 0x100fe200078e0205ULL, 0xfffffff84f4f7812ULL, 0x000fe200078ee210ULL,
0x0000000845187824ULL, 0x000fe200078e00ffULL, 0x0000000405107211ULL, 0x000fe200078fe8ffULL,
0x00000001491f7824ULL, 0x000fe200078e0205ULL, 0xfffffff851517812ULL, 0x000fe200078ee212ULL,
0x0000000104127824ULL, 0x000fe200078e0211ULL, 0x0000004710117210ULL, 0x000fe20007f3e0ffULL,
0x0000000849467824ULL, 0x000fe200078e00ffULL, 0xfffffff8185b7812ULL, 0x000fe200078ee213ULL,
0x0000000148137824ULL, 0x000fc400078e0205ULL, 0x0000000848187824ULL, 0x000fe200078e00ffULL,
0xfffffff8465f7812ULL, 0x000fe200078ee21fULL, 0x000000ffff1c7224ULL, 0x000fe200008e06ffULL,
0x00005e0011107a11ULL, 0x040fe200078248ffULL, 0x0000000104467824ULL, 0x000fe200078e0245ULL,
0xfffffff8185d7812ULL, 0x000fe200078ee213ULL, 0x0000000104447824ULL, 0x000fe200078e0244ULL,
0x0000004712137210ULL, 0x000fe20007f5e0ffULL, 0x0000000104487824ULL, 0x040fe200078e0248ULL,
0x00005f0011117a11ULL, 0x000fe200008f4c1cULL, 0x00000001041c7824ULL, 0x040fe200078e0229ULL,
0x00000005051f7211ULL, 0x000fe200078fe8ffULL, 0x000000ffff187224ULL, 0x000fe200010e06ffULL,
0x00005e0013127a11ULL, 0x040fe200078448ffULL, 0x00000001044a7824ULL, 0x000fe200078e0249ULL,
0x000000471c457210ULL, 0x080fe20007f9e0ffULL, 0x00000001044c7824ULL, 0x000fe200078e024bULL,
0x00005f0013137a11ULL, 0x000fe200010f4c18ULL, 0x000000014b4e7824ULL, 0x100fe200078e0205ULL,
0x000000071f187812ULL, 0x000fe200078ec0ffULL, 0x000000084b537824ULL, 0x000fe200078e00ffULL,
0x0000004746497210ULL, 0x080fe20007f7e0ffULL, 0x000000ffff467224ULL, 0x000fe200020e06ffULL,
0x00000047441f7210ULL, 0x080fe20007f5e0ffULL, 0x000000104d557824ULL, 0x100fe200078e021eULL,
0x00005e0045447a11ULL, 0x000fe200078c48ffULL, 0x000000104f577824ULL, 0x100fe200078e021eULL,
0x0ffffff8184b7812ULL, 0x000fe200078ef805ULL, 0x0000001051597824ULL, 0x100fe200078e021eULL,
0x0000004748297210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff487224ULL, 0x000fe200010e06ffULL,
0x000000474a1c7210ULL, 0x080fe20007f9e0ffULL, 0x000000105b5b7824ULL, 0x100fe200078e021eULL,
0x000000474c187210ULL, 0x000fe20007fbe0ffULL, 0x000000105d5d7824ULL, 0x000fe200078e021eULL,
0xfffffff853477812ULL, 0x000fe200078ee24eULL, 0x000000104b537824ULL, 0x000fe200078e021eULL,
0x00005f0045457a11ULL, 0x000fe200030f4c46ULL, 0x000000105f5f7824ULL, 0x100fe200078e021eULL,
0x00005e001f467a11ULL, 0x000fe200078448ffULL, 0x0000001047617824ULL, 0x000fc400078e021eULL,
0x000000ffff507224ULL, 0x000fe200018e06ffULL, 0x00005f001f477a11ULL, 0x000fe200010f4c48ULL,
0x0000000102517824ULL, 0x000fe200078e021dULL, 0x00005e0049487a11ULL, 0x000fe200078448ffULL,
0x000000ffff1e7224ULL, 0x000fe200008e06ffULL, 0x00005e00294a7a11ULL, 0x000fe200078248ffULL,
0x000000ffff1f7224ULL, 0x000fe200020e06ffULL, 0x00005e001c4c7a11ULL, 0x000fe200078648ffULL,
0x000000ffff1d7224ULL, 0x000fe200028e06ffULL, 0x00005e00184e7a11ULL, 0x000fe200078848ffULL,
0x0000001051107825ULL, 0x000fe200078e0010ULL, 0x00005f0049497a11ULL, 0x000fc400010f4c50ULL,
0x00005f00294b7a11ULL, 0x000fe200008f4c1eULL, 0x0000001051127825ULL, 0x040fe200078e0012ULL,
0x00005f001c4d7a11ULL, 0x000fe200018f4c1fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010537faeULL, 0x0003e2000b901c46ULL, 0x00005f00184f7a11ULL, 0x000fe200020f4c1dULL,
0x00000010511c7825ULL, 0x040fe400078e0044ULL, 0x0000000012557faeULL, 0x0003e4000b901c46ULL,
0x00000010511e7825ULL, 0x040fe400078e0046ULL, 0x000000001c577faeULL, 0x0003e4000b901c46ULL,
0x0000001051447825ULL, 0x000fc400078e0048ULL, 0x000000001e597faeULL, 0x0003e4000b901c46ULL,
0x0000001051467825ULL, 0x040fe400078e004aULL, 0x00000000445b7faeULL, 0x0003e4000b901c46ULL,
0x0000001051487825ULL, 0x040fe400078e004cULL, 0x00000000465d7faeULL, 0x0003e4000b901c46ULL,
0x00000010514a7825ULL, 0x000fc400078e004eULL, 0x00000000485f7faeULL, 0x0003e8000b901c46ULL,
0x000000004a617faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000017000007945ULL, 0x000fe20003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000014000008947ULL, 0x000fea0003800000ULL, 0x00000019ff10723eULL, 0x002fe400000010ffULL,
0x00000002ff187819ULL, 0x000fe40000011605ULL, 0x0000541010657816ULL, 0x000fe20000000010ULL,
0x0000df627f007947ULL, 0x000fea000b800000ULL, 0x00001f18651b7589ULL, 0x0002a400000e0000ULL,
0x0000000818647810ULL, 0x002fe20007ffe0ffULL, 0x0000dfa27f007947ULL, 0x000fea000b800000ULL,
0x00001f64651a7589ULL, 0x0002e400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x0000001018647810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff137424ULL, 0x000fe200078e00ffULL,
0x0000c65000107802ULL, 0x000fe20000000f00ULL, 0xffffffffff127424ULL, 0x000fc400078e00ffULL,
0x0000e54000007944ULL, 0x00cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x0000001818647810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff137424ULL, 0x000fe200078e00ffULL,
0x0000c6b000107802ULL, 0x000fe20000000f00ULL, 0xffffffffff127424ULL, 0x004fc400078e00ffULL,
0x0000e4e000007944ULL, 0x008fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0001380028287811ULL, 0x000fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000002d1c783bULL, 0x002fe20000004200ULL, 0x000138002e2e7811ULL, 0x000fc600078e20ffULL,
0x000000002810783bULL, 0x004e680000000200ULL, 0x000000002b48783bULL, 0x000fe80000004200ULL,
0x000000002a44783bULL, 0x000fe80000004200ULL, 0x000000002c4c783bULL, 0x000fe80000004200ULL,
0x000000002e50783bULL, 0x000ea80000000200ULL, 0x000000003254783bULL, 0x000f280000004200ULL,
0x00000000305c783bULL, 0x000ee80000004200ULL, 0x000000002f58783bULL, 0x0002e80000004200ULL,
0x000000003160783bULL, 0x000ee20000004200ULL, 0x0000001b10100231ULL, 0x002fc400003400ffULL,
0x0000001b12120231ULL, 0x000fe400003400ffULL, 0x0000001a11110231ULL, 0x088fe400003400ffULL,
0x0000001a13130231ULL, 0x000fce00003400ffULL, 0x0000001c100c723cULL, 0x000f62000004180cULL,
0x0000001b50500231ULL, 0x084fe400003400ffULL, 0x0000001b52520231ULL, 0x000fe400003400ffULL,
0x0000001a51510231ULL, 0x000fc600003400ffULL, 0x000000481028723cULL, 0x000fe20000041834ULL,
0x0000001a53530231ULL, 0x000fce00003400ffULL, 0x0000001e101c723cULL, 0x040ff00000041814ULL,
0x000000441020723cULL, 0x040ff00000041820ULL, 0x000000461024723cULL, 0x040ff00000041824ULL,
0x0000004a1048723cULL, 0x040f700000041838ULL, 0x0000004c102c723cULL, 0x040f70000004183cULL,
0x0000004e1010723cULL, 0x000f700000041840ULL, 0x000000545014723cULL, 0x070b70000004180cULL,
0x0000005e503c723cULL, 0x040b700000041848ULL, 0x00000056500c723cULL, 0x040b70000004181cULL,
0x000000585034723cULL, 0x040b700000041820ULL, 0x0000005a5038723cULL, 0x040b700000041824ULL,
0x0000005c5040723cULL, 0x040b700000041828ULL, 0x000000605048723cULL, 0x040b70000004182cULL,
0x000000625044723cULL, 0x000b620000041810ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x01c6a000ffff7f8cULL, 0x000fe4000c80043fULL,
0x0000030009097a10ULL, 0x000fc80007ffe0ffULL, 0x000000070900720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff4c8000007947ULL, 0x000fea000383ffffULL,
0x0000000000287919ULL, 0x020e620000002500ULL, 0x000000ffff107224ULL, 0x000fe400078e000fULL,
0x000000ffff0f7224ULL, 0x000fe200078e000eULL, 0x000000072800720cULL, 0x002fda0003f06070ULL,
0x0000034000000947ULL, 0x000fea0003800000ULL, 0x0180000006007810ULL, 0x000fe20007ffe0ffULL,
0x000000c000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x0000ca8000087802ULL, 0x000fc40000000f00ULL, 0x0000df4000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff007224ULL, 0x000fe200078e0007ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000600037308ULL, 0x000e640000001000ULL, 0xbf80000003007423ULL, 0x002fc80000000006ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003007223ULL, 0x000fc40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000ea80000000000ULL,
0x0000000000047919ULL, 0x000ee20000000000ULL, 0x00000002ff037819ULL, 0x004fe40000011603ULL,
0x0000000804057811ULL, 0x008fc800078ff0ffULL, 0x00001f0300037589ULL, 0x000ea800000e0000ULL,
0x00001f0500047589ULL, 0x000ee200000e0000ULL, 0x0000001403147220ULL, 0x044fe40000410000ULL,
0x0000001503157220ULL, 0x040fe40000410000ULL, 0x0000000c030c7220ULL, 0x040fe40000410000ULL,
0x0000000d030d7220ULL, 0x000fc40000410000ULL, 0x0000003403347220ULL, 0x040fe40000410000ULL,
0x0000003503357220ULL, 0x040fe40000410000ULL, 0x0000003803387220ULL, 0x040fe40000410000ULL,
0x0000003903397220ULL, 0x040fe40000410000ULL, 0x0000004003407220ULL, 0x040fe40000410000ULL,
0x0000004103417220ULL, 0x000fc40000410000ULL, 0x0000003c033c7220ULL, 0x040fe40000410000ULL,
0x0000003d033d7220ULL, 0x040fe40000410000ULL, 0x0000004803487220ULL, 0x040fe40000410000ULL,
0x0000004903497220ULL, 0x040fe40000410000ULL, 0x0000004403447220ULL, 0x040fe40000410000ULL,
0x0000004503457220ULL, 0x000fc40000410000ULL, 0x0000001604167220ULL, 0x048fe40000410000ULL,
0x0000001704177220ULL, 0x040fe40000410000ULL, 0x0000000f040f7220ULL, 0x040fe40000410000ULL,
0x0000001004107220ULL, 0x040fe40000410000ULL, 0x0000003604367220ULL, 0x040fe40000410000ULL,
0x0000003704377220ULL, 0x000fc40000410000ULL, 0x0000003a043a7220ULL, 0x040fe40000410000ULL,
0x0000003b043b7220ULL, 0x040fe40000410000ULL, 0x0000004204427220ULL, 0x040fe40000410000ULL,
0x0000004304437220ULL, 0x040fe40000410000ULL, 0x0000003e043e7220ULL, 0x040fe40000410000ULL,
0x0000003f043f7220ULL, 0x000fc40000410000ULL, 0x0000004a044a7220ULL, 0x040fe40000410000ULL,
0x0000004b044b7220ULL, 0x040fe40000410000ULL, 0x0000004604467220ULL, 0x040fe40000410000ULL,
0x0000004704477220ULL, 0x000fc40000410000ULL, 0x00000000001b7919ULL, 0x000ea20000000000ULL,
0x00000016170e723eULL, 0x000fe400000010ffULL, 0x000000141504723eULL, 0x000fe200000010ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000c0d05723eULL, 0x000fc400000010ffULL,
0x000000343507723eULL, 0x000fe400000010ffULL, 0x000000383908723eULL, 0x000fe400000010ffULL,
0x000000404109723eULL, 0x000fe400000010ffULL, 0x0000003c3d0b723eULL, 0x000fe400000010ffULL,
0x00000048490c723eULL, 0x000fe400000010ffULL, 0x00000044450d723eULL, 0x000fc400000010ffULL,
0x00000002ff1d7819ULL, 0x004fe4000001161bULL, 0x000000081b267811ULL, 0x000fe400078ff0ffULL,
0x000000011d007810ULL, 0x040fe20007ffe0ffULL, 0x000000081d177824ULL, 0x040fe200078e00ffULL,
0x000000021d037810ULL, 0x040fe20007ffe0ffULL, 0x000000081d1a7824ULL, 0x040fe200078e00ffULL,
0x000000051d167810ULL, 0x040fe20007ffe0ffULL, 0x000000081d197824ULL, 0x000fe200078e00ffULL,
0xfffffff817187812ULL, 0x000fe200078ee200ULL, 0x000000081d1f7824ULL, 0x040fe200078e00ffULL,
0x000000031d007810ULL, 0x040fe20007ffe0ffULL, 0x000000081d227824ULL, 0x040fe200078e00ffULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee203ULL, 0x000000081d1e7824ULL, 0x040fe200078e00ffULL,
0x000000061d177810ULL, 0x040fe20007ffe0ffULL, 0x000000081d247824ULL, 0x000fe200078e00ffULL,
0xfffffff8191c7812ULL, 0x000fe200078ee200ULL, 0x000008000a007824ULL, 0x000fe200078e00ffULL,
0xfffffff81f207812ULL, 0x000fe200078ee216ULL, 0x000000081d167824ULL, 0x040fe200078e00ffULL,
0x000000041d037810ULL, 0x000fc40007ffe0ffULL, 0xfffffff822227812ULL, 0x000fe200078ee217ULL,
0x000000041b177824ULL, 0x000fe200078e00ffULL, 0xfffffff81e1e7812ULL, 0x000fe400078ee203ULL,
0xfffffff816167812ULL, 0x000fe400078ee21dULL, 0x0001200000037810ULL, 0x000fe40007ffe0ffULL,
0xffffffff1d197810ULL, 0x000fe20007ffe0ffULL, 0x00000008261d7824ULL, 0x000fe200078e00ffULL,
0x0000000c17177812ULL, 0x000fe200078ec0ffULL, 0x0000001016167824ULL, 0x000fe200078e0203ULL,
0xfffffff824247812ULL, 0x000fe200078ee219ULL, 0x0000001018187824ULL, 0x100fe200078e0203ULL,
0xfffffff81d267812ULL, 0x000fe200078ee226ULL, 0x000000101a1a7824ULL, 0x100fe200078e0203ULL,
0x0000000f100f723eULL, 0x000fe200000010ffULL, 0x000000101c1c7824ULL, 0x100fe200078e0203ULL,
0x000000363710723eULL, 0x000fe200000010ffULL, 0x000000101e1e7824ULL, 0x000fe200078e0203ULL,
0x0000003a3b11723eULL, 0x000fe200000010ffULL, 0x0000000116197824ULL, 0x000fe200078e0217ULL,
0x000000424312723eULL, 0x000fe200000010ffULL, 0x0000001020207824ULL, 0x100fe200078e0203ULL,
0x0000003e3f13723eULL, 0x000fe200000010ffULL, 0x0000000117187824ULL, 0x000fe200078e0218ULL,
0x0000000419007388ULL, 0x0005e20000000800ULL, 0x0000001022227824ULL, 0x100fe200078e0203ULL,
0x0000004a4b14723eULL, 0x000fe200000010ffULL, 0x00000001171a7824ULL, 0x000fe200078e021aULL,
0x0000000518007388ULL, 0x0005e20000000800ULL, 0x0000001024247824ULL, 0x100fe200078e0203ULL,
0x000000464715723eULL, 0x000fe200000010ffULL, 0x00000001171c7824ULL, 0x000fe200078e021cULL,
0x000000071a007388ULL, 0x0005e20000000800ULL, 0x0000001026267824ULL, 0x000fc400078e0203ULL,
0x00000001171e7824ULL, 0x040fe200078e021eULL, 0x000000081c007388ULL, 0x0005e20000000800ULL,
0x00000300ff1d7624ULL, 0x000fe400078e00ffULL, 0x0000000117207824ULL, 0x040fe200078e0220ULL,
0x000000091e007388ULL, 0x0005e20000000800ULL, 0x00000001171b7824ULL, 0x000fe200078e0222ULL,
0x000000011d00780cULL, 0x000fe20003f05270ULL, 0x0000000117247824ULL, 0x040fe200078e0224ULL,
0x0000000b20007388ULL, 0x0005e20000000800ULL, 0x0000000117177824ULL, 0x000fc600078e0226ULL,
0x0000000c1b007388ULL, 0x0005e80000000800ULL, 0x0000000d24007388ULL, 0x0005e80000000800ULL,
0x0000000e17007388ULL, 0x0005e80000000800ULL, 0x0004000f18007388ULL, 0x0005e80000000800ULL,
0x000400101a007388ULL, 0x0005e80000000800ULL, 0x000400111c007388ULL, 0x0005e80000000800ULL,
0x000400121e007388ULL, 0x0005e80000000800ULL, 0x0004001320007388ULL, 0x0005e80000000800ULL,
0x000400141b007388ULL, 0x0005e80000000800ULL, 0x0004001524007388ULL, 0x0005e20000000800ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000272000008947ULL, 0x000fea0003800000ULL,
0x00005800ff047624ULL, 0x004fe200078e00ffULL, 0x00000000000b7919ULL, 0x000ea60000002700ULL,
0x0000660004047a24ULL, 0x000fe200078e02ffULL, 0x00000000000c7919ULL, 0x000ea60000002600ULL,
0x0000030004097a24ULL, 0x040fe200078e02ffULL, 0x0000000f04057811ULL, 0x000fe200078e10ffULL,
0x0000000000077919ULL, 0x000ee60000000000ULL, 0xfffffff005107812ULL, 0x000fca00078ec0ffULL,
0x0000008009127824ULL, 0x000fc800078e0210ULL, 0x0000008009097824ULL, 0x000fca00078e0212ULL,
0x0000007f09097810ULL, 0x000fe20007ffe0ffULL, 0x000058000b0b7a24ULL, 0x004fc600078e020cULL,
0xffffff8009117812ULL, 0x000fe200078ec0ffULL, 0x000003000b137a24ULL, 0x000fe200078e02ffULL,
0x0000002007097810ULL, 0x048fe20007ffe0ffULL, 0x0000001007087824ULL, 0x000fe200078e0200ULL,
0x00006a0011057a10ULL, 0x000fe20007f1e0ffULL, 0x00000001130c7824ULL, 0x000fc600078e0228ULL,
0x0120000008147984ULL, 0x000ea40000000c00ULL, 0x000000050c047211ULL, 0x000fe200078260ffULL,
0x00006b00ff057624ULL, 0x000fe200000e06ffULL, 0x00006a00101c7a10ULL, 0x000fe20007f1e0ffULL,
0x0122000008187984ULL, 0x0006660000000c00ULL, 0x000000050c057211ULL, 0x000fe200008f64ffULL,
0x00006b00ff1e7624ULL, 0x000fe200000e06ffULL, 0x000000ff0a00720cULL, 0x000fc60003f25270ULL,
0x000004000a047825ULL, 0x000fcc00078e0004ULL, 0x0000001009087825ULL, 0x008fc800078e0004ULL,
0x0000001007047825ULL, 0x000fe200078e0004ULL, 0x0000011000001947ULL, 0x000fea0003800000ULL,
0x00000000000e7919ULL, 0x000ee20000000000ULL, 0x000000800c0d7824ULL, 0x000fe400078e00ffULL,
0x000000100e0f7824ULL, 0x008fe200078e00ffULL, 0x00000001ff207819ULL, 0x000fe4000001160eULL,
0x00006a000d0e7a10ULL, 0x000fe40007b5e012ULL, 0x000000700f1f7812ULL, 0x000fe400078ec0ffULL,
0x00000019ff0f7819ULL, 0x000fc4000001160cULL, 0x0000000c20207812ULL, 0x000fe400078ec0ffULL,
0x0000001c1f0d7210ULL, 0x000fe4000791e00dULL, 0x00006b000f217a10ULL, 0x000fe400017e64ffULL,
0x0000000d200c7210ULL, 0x040fe40007f5e0ffULL, 0x0000001eff0d7210ULL, 0x000fe400007e240fULL,
0x0000000e200e7210ULL, 0x000fc60007c7e01fULL, 0x000000ffff0d7224ULL, 0x000fe200010e060dULL,
0x00000021ff0f7210ULL, 0x000fc80001fe84ffULL, 0x000000330c007986ULL, 0x0007e8000c101906ULL,
0x000000060e007986ULL, 0x0007e4000c101906ULL, 0x000000ff0700720cULL, 0x000fe20003f05270ULL,
0x0000001404007986ULL, 0x004fe2000c101d06ULL, 0x0000016000007945ULL, 0x000fe40003800000ULL,
0x000000ff0a00720cULL, 0x000fe20000705670ULL, 0x0000001808007986ULL, 0x002fe8000c101d06ULL,
0x0000000000007b1dULL, 0x000ff00000000000ULL, 0x0000011000000947ULL, 0x000fea0003800000ULL,
0x00000004ff047424ULL, 0x000fe200078e00ffULL, 0xffffffff1d097810ULL, 0x000fc60007ffe0ffULL,
0x00006a000b047625ULL, 0x000fe200078e0004ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000009040479a8ULL, 0x000ea400099ee1c6ULL, 0x000000090400720cULL, 0x004fc80003f05270ULL,
0x00000001ff067807ULL, 0x008fe20000000000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000006ff007388ULL, 0x0003e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000ff047984ULL, 0x000ea40000000000ULL,
0x000000ff0400720cULL, 0x004fda0003f05270ULL, 0x0000226000008947ULL, 0x000fea0003800000ULL,
0x000000ff0a00720cULL, 0x000fda0003f05270ULL, 0x00000a5000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x000001b000008947ULL, 0x000fea0003800000ULL,
0x0000001007057824ULL, 0x000fe200078e00ffULL, 0x00000001ff067819ULL, 0x00afe40000011607ULL,
0x0000001c13047211ULL, 0x000fe400078038ffULL, 0x0000007005097812ULL, 0x000fe400078ec0ffULL,
0x0000000c06067812ULL, 0x000fe400078ec0ffULL, 0x0000001e13057211ULL, 0x000fe400000f3cffULL,
0x0000000406047210ULL, 0x000fc8000791e009ULL, 0x00000005ff057210ULL, 0x000fca00007e24ffULL,
0x0000000604067981ULL, 0x000328000c1e1900ULL, 0x0000800604097981ULL, 0x000322000c1e1900ULL,
0x000000021d00780cULL, 0x000fda0003f05270ULL, 0x000000f000008947ULL, 0x000fea0003800000ULL,
0x00010006040b7981ULL, 0x002322000c1e1900ULL, 0x000000041d00780cULL, 0x000fda0003f06070ULL,
0x000000c000008947ULL, 0x000fea0003800000ULL, 0x00018006040d7981ULL, 0x002322000c1e1900ULL,
0x000000041d00780cULL, 0x000fda0003f05270ULL, 0x0000009000008947ULL, 0x000fea0003800000ULL,
0x00020006040f7981ULL, 0x002322000c1e1900ULL, 0x000000061d00780cULL, 0x000fda0003f06070ULL,
0x0000006000008947ULL, 0x000fea0003800000ULL, 0x0002800604157981ULL, 0x002322000c1e1900ULL,
0x000000061d00780cULL, 0x000fda0003f05270ULL, 0x0000003000008947ULL, 0x000fea0003800000ULL,
0x000000081d00780cULL, 0x002fe20003f06070ULL, 0x0003000604177981ULL, 0x000318000c1e1900ULL,
0x0003800604190981ULL, 0x000324000c1e1900ULL, 0x000000071d047810ULL, 0x002fc80007ffe0ffULL,
0x00000003ff087819ULL, 0x000fc80000011604ULL, 0x000000ff0800720cULL, 0x000fda0003f05270ULL,
0x000007d000008947ULL, 0x000fea0003800000ULL, 0x00000010131d7211ULL, 0x000fe200078038ffULL,
0x000000ffff0e7224ULL, 0x008fe200078e00ffULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0x000000ffff1b7224ULL, 0x010fe200078e0006ULL, 0x00006a001d1d7a10ULL, 0x000fe40007f3e0ffULL,
0x000000ff130c7211ULL, 0x000fe400000f3cffULL, 0x000007801d1d7810ULL, 0x000fc80007f5e0ffULL,
0x00006b00ff0c7a10ULL, 0x000fc400017e240cULL, 0x000003000e007a0cULL, 0x000fe20003f26070ULL,
0x0000000104047890ULL, 0x000fcc000fffe03fULL, 0x0000000408007c0cULL, 0x000fcc000bf03070ULL,
0x000006d000001947ULL, 0x012fea0003800000ULL, 0x000000080e047810ULL, 0x040fe40007ffe0ffULL,
0x000000010e057810ULL, 0x000fe40007ffe0ffULL, 0x0000030004007a0cULL, 0x000fe40003f26070ULL,
0x0000030005007a0cULL, 0x000fe40003f46070ULL, 0x0000001b06067209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001007047824ULL, 0x000fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011607ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x000000041d047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e060cULL, 0xfffc8006041b7981ULL, 0x000326000c1e1900ULL,
0x000005f000002947ULL, 0x000fea0003800000ULL, 0x000000090e047810ULL, 0x042fe40007ffe0ffULL,
0x000000020e057810ULL, 0x000fe40007ffe0ffULL, 0x0000030004007a0cULL, 0x000fe40003f26070ULL,
0x0000030005007a0cULL, 0x000fe40003f46070ULL, 0x0000000906067209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001007047824ULL, 0x000fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011607ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x000000041d047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e060cULL, 0xfffd000604097981ULL, 0x000326000c1e1900ULL,
0x0000051000002947ULL, 0x000fea0003800000ULL, 0x0000000a0e047810ULL, 0x042fe40007ffe0ffULL,
0x000000030e057810ULL, 0x000fe40007ffe0ffULL, 0x0000030004007a0cULL, 0x000fe40003f26070ULL,
0x0000030005007a0cULL, 0x000fe40003f46070ULL, 0x0000000b06067209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001007047824ULL, 0x000fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011607ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x000000041d047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e060cULL, 0xfffd8006040b7981ULL, 0x000326000c1e1900ULL,
0x0000043000002947ULL, 0x000fea0003800000ULL, 0x0000000b0e047810ULL, 0x042fe40007ffe0ffULL,
0x000000040e057810ULL, 0x000fe40007ffe0ffULL, 0x0000030004007a0cULL, 0x000fe40003f26070ULL,
0x0000030005007a0cULL, 0x000fe40003f46070ULL, 0x0000000d06067209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001007047824ULL, 0x000fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011607ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x000000041d047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e060cULL, 0xfffe0006040d7981ULL, 0x000326000c1e1900ULL,
0x0000035000002947ULL, 0x000fea0003800000ULL, 0x0000000c0e047810ULL, 0x042fe40007ffe0ffULL,
0x000000050e057810ULL, 0x000fe40007ffe0ffULL, 0x0000030004007a0cULL, 0x000fe40003f26070ULL,
0x0000030005007a0cULL, 0x000fe40003f46070ULL, 0x0000000f06067209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001007047824ULL, 0x000fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011607ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x000000041d047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e060cULL, 0xfffe8006040f7981ULL, 0x000326000c1e1900ULL,
0x0000027000002947ULL, 0x000fea0003800000ULL, 0x0000000d0e047810ULL, 0x042fe40007ffe0ffULL,
0x000000060e057810ULL, 0x000fe40007ffe0ffULL, 0x0000030004007a0cULL, 0x000fe40003f26070ULL,
0x0000030005007a0cULL, 0x000fe40003f46070ULL, 0x0000001506067209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001007047824ULL, 0x000fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011607ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x000000041d047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e060cULL, 0xffff000604157981ULL, 0x000326000c1e1900ULL,
0x0000019000002947ULL, 0x000fea0003800000ULL, 0x0000000e0e047810ULL, 0x042fe40007ffe0ffULL,
0x000000070e057810ULL, 0x000fe40007ffe0ffULL, 0x0000030004007a0cULL, 0x000fe40003f26070ULL,
0x0000030005007a0cULL, 0x000fe40003f46070ULL, 0x0000001706067209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001007047824ULL, 0x000fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011607ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x000000041d047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e060cULL, 0xffff800604177981ULL, 0x000326000c1e1900ULL,
0x000000b000002947ULL, 0x000fea0003800000ULL, 0x0000000f0e047810ULL, 0x002fe40007ffe0ffULL,
0x0000001906067209ULL, 0x000fe40007810000ULL, 0x0000030004007a0cULL, 0x000fda0003f26070ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001007047824ULL, 0x000fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011607ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x000000041d047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e060cULL, 0x0000000604197981ULL, 0x000326000c1e1900ULL,
0x000004001d1d7810ULL, 0x000fe40007f3e0ffULL, 0x000000080e0e7810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e060cULL, 0xfffff8b000008947ULL, 0x000fea000383ffffULL,
0x0000000000077919ULL, 0x000ea40000000000ULL, 0x0000001007047824ULL, 0x006fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011607ULL, 0x0000007004047812ULL, 0x000fe400078ec0ffULL,
0x0000000c05057812ULL, 0x000fca00078ec0ffULL, 0x0000000104057824ULL, 0x000fca00078e0205ULL,
0x0000000605007388ULL, 0x0103e40000000800ULL, 0x00006a0011047a10ULL, 0x000fe20007f1e0ffULL,
0x000004000a3f7824ULL, 0x000fe200078e00ffULL, 0x00000016ff417819ULL, 0x000fe2000001160aULL,
0x0000001007067824ULL, 0x04afe200078e00ffULL, 0x00006a0010427a10ULL, 0x000fe20007f5e0ffULL,
0x00006b00ff057624ULL, 0x000fe200000e06ffULL, 0x000000070700780cULL, 0x000fe20003f04070ULL,
0x000010000a147824ULL, 0x000fe200078e00ffULL, 0x00000001ff0b7819ULL, 0x000fe20000011607ULL,
0x0000100013087825ULL, 0x000fe200078e0004ULL, 0x0000007006067812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000003f08087210ULL, 0x000fe20007f3e0ffULL,
0x00006b00ff447624ULL, 0x000fe200010e06ffULL, 0x0000000c0b0b7812ULL, 0x000fe200078ec0ffULL,
0x000000100a158824ULL, 0x000fe200078e0207ULL, 0x00000020070d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000109097824ULL, 0x000fe200008e0641ULL, 0x00006a00123e7a10ULL, 0x000fe20007f3e0ffULL,
0x0000000106067824ULL, 0x000fe200078e020bULL, 0x0000004213108211ULL, 0x000fe200078438ffULL,
0x000000100a178824ULL, 0x000fe200078e0207ULL, 0x0000458015158811ULL, 0x000fe200078e20ffULL,
0x00006b00ff407624ULL, 0x000fe200008e06ffULL, 0x0000003e130e8211ULL, 0x000fe200078238ffULL,
0x000000100d0c7825ULL, 0x000fe200078e0008ULL, 0x0000004413118211ULL, 0x040fe200010f3cffULL,
0x0000000006067984ULL, 0x000e620000000800ULL, 0x00000040130f8211ULL, 0x000fe200008f3cffULL,
0x00000010070b7824ULL, 0x040fe200078e0214ULL, 0x00000300ff007a0cULL, 0x000fe20003f25270ULL,
0x0000001007087825ULL, 0x000fe200078e0008ULL, 0x0000418017178811ULL, 0x000fe200078e20ffULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x00000010070e8825ULL, 0x040fe200078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00180000080b7faeULL, 0x0005e2000b901c46ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x0000001007108825ULL, 0x000fe200078e0010ULL,
0x003800000c0b7faeULL, 0x0005e2000b901c46ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x000000ffff127224ULL, 0x000fe200078e00ffULL,
0x000000000e158faeULL, 0x0007e2000b901c46ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000000010178faeULL, 0x0009e2000b901c46ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000ffff0b7224ULL, 0x004fe200078e00ffULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x000000ffff157224ULL, 0x008fe200078e00ffULL, 0x0000000000167805ULL, 0x010fe2000001ff00ULL,
0x00000bd000009947ULL, 0x000fea0003800000ULL, 0x0000000113137810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff127224ULL, 0x000fc400078e00ffULL, 0x00000001ff497424ULL, 0x000fca00078e00ffULL,
0x0000030049007a0cULL, 0x000fda0003f06070ULL, 0x000001f000000947ULL, 0x000fea0003800000ULL,
0x000000070700780cULL, 0x000fe20003f44070ULL, 0x0000100013087825ULL, 0x000fe200078e0004ULL,
0x00000001490f7812ULL, 0x000fe400078ec0ffULL, 0x00000020073b7810ULL, 0x000fe20007ffe0ffULL,
0x00000800490c7824ULL, 0x000fe200078e00ffULL, 0x0000003f08087210ULL, 0x000fc80007f1e0ffULL,
0x000008000c0d7812ULL, 0x000fe200078ec0ffULL, 0x0000000109097824ULL, 0x000fe400000e0641ULL,
0x000000020a34a824ULL, 0x140fe200078e020fULL, 0x0000003e130ea211ULL, 0x040fe200078038ffULL,
0x000000020a36a824ULL, 0x000fe200078e020fULL, 0x000000421310a211ULL, 0x040fe200078238ffULL,
0x00000001140c7824ULL, 0x000fe200078e020dULL, 0x00000040130fa211ULL, 0x040fe200000f3cffULL,
0x000000083434a824ULL, 0x100fe200078e0207ULL, 0x000000441311a211ULL, 0x000fe200008f3cffULL,
0x000000083636a824ULL, 0x000fc400078e0207ULL, 0x0000001007357824ULL, 0x000fe200078e020cULL,
0x000045803437a811ULL, 0x000fe200078e20ffULL, 0x000000103b0c7825ULL, 0x000fe200078e0008ULL,
0x000041803639a811ULL, 0x000fc600078e20ffULL, 0x0000001007087825ULL, 0x000fc800078e0008ULL,
0x00000010070ea825ULL, 0x040fe200078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000008357faeULL, 0x0005e6000b901c46ULL, 0x000000100710a825ULL, 0x000fe200078e0010ULL,
0x003800000c357faeULL, 0x0005e8000b901c46ULL, 0x000000000e37afaeULL, 0x0005e8000b901c46ULL,
0x000000001039afaeULL, 0x0005e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffff49087810ULL, 0x004fe20007ffe0ffULL, 0x00000010070c7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fc40000011607ULL, 0x00000002ff3d7819ULL, 0x000fe20000011607ULL,
0x0000008008097824ULL, 0x000fe200078e00ffULL, 0x000000700c0c7812ULL, 0x000fe200078ec0ffULL,
0x0000080008087824ULL, 0x000fe200078e00ffULL, 0x0000000c0d0d7812ULL, 0x000fe200078ec0ffULL,
0x000000083d367824ULL, 0x000fe200078e00ffULL, 0x0000008009097812ULL, 0x000fe200078ec0ffULL,
0x000000083d0f7824ULL, 0x040fe200078e00ffULL, 0x000000083d457810ULL, 0x040fe20007ffe0ffULL,
0x000000083d387824ULL, 0x040fe200078e00ffULL, 0x000000013d0e7810ULL, 0x040fe20007ffe0ffULL,
0x000001000a097824ULL, 0x000fe200078e0209ULL, 0x000000033d117810ULL, 0x040fe20007ffe0ffULL,
0x000000083d3a7824ULL, 0x000fe200078e00ffULL, 0xfffffff80f347812ULL, 0x000fe200078ee20eULL,
0x000000083d3c7824ULL, 0x000fe200078e00ffULL, 0x000000090d0c7210ULL, 0x000fe20007ffe00cULL,
0x0000000407097824ULL, 0x000fe200078e00ffULL, 0x000000023d0e7810ULL, 0x000fe20007ffe0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x004180000c0d7984ULL, 0x000ea20000000800ULL,
0x0000000c09437812ULL, 0x000fe200078ec0ffULL, 0x000000083d477824ULL, 0x040fe200078e00ffULL,
0x0000080008097812ULL, 0x000fe200078ec0ffULL, 0x004580000c107984ULL, 0x0007220000000800ULL,
0xfffffff836087812ULL, 0x000fe200078ee23dULL, 0x000000083d467824ULL, 0x000fe200078e00ffULL,
0x0000018014097810ULL, 0x000fe40007ffe009ULL, 0xfffffff80f367812ULL, 0x000fe400078ee20eULL,
0x000000043d377810ULL, 0x000fe20007ffe0ffULL, 0x00000008450c7824ULL, 0x008fe200078e00ffULL,
0x0000030049007a0cULL, 0x000fe20003f06070ULL, 0x0000001008087824ULL, 0x000fe200078e0209ULL,
0x0000000113137810ULL, 0x000fc40007ffe0ffULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee245ULL,
0x0000000143087824ULL, 0x000fe200078e0208ULL, 0x0000000149497810ULL, 0x000fc60007ffe0ffULL,
0x000000100c0c7824ULL, 0x100fe200078e0209ULL, 0x0000000008357984ULL, 0x0006660000000800ULL,
0x00000001430e7824ULL, 0x040fe400078e020cULL, 0x00000010340c7824ULL, 0x000fe200078e0209ULL,
0xfffffff838347812ULL, 0x000fe400078ee211ULL, 0x000000000e397984ULL, 0x0005e20000000800ULL,
0x00000001430c7824ULL, 0x000fe200078e020cULL, 0x000000053d117810ULL, 0x000fe20007ffe0ffULL,
0x0000001034087824ULL, 0x008fe200078e0209ULL, 0xfffffff83a387812ULL, 0x000fc400078ee237ULL,
0x000400000c3a7984ULL, 0x000fe20000000800ULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee211ULL,
0x0000000143087824ULL, 0x000fe200078e0208ULL, 0xffffffff3d0e7810ULL, 0x004fe20007ffe0ffULL,
0x0000000d060d7221ULL, 0x002fc60000010100ULL, 0xfffffff847487812ULL, 0x000fe200078ee20eULL,
0x3fb8aa3b0d0d7820ULL, 0x000fe40000410000ULL, 0x000000103c0e7824ULL, 0x100fe400078e0209ULL,
0x0000000d000f7308ULL, 0x0003220000000800ULL, 0x00040000083c7984ULL, 0x000fe20000000800ULL,
0x00000001430e7824ULL, 0x040fe400078e020eULL, 0x00000010360d7824ULL, 0x002fe400078e0209ULL,
0x000000000c367984ULL, 0x0003e40000000800ULL, 0x00000001430d7824ULL, 0x000fc400078e020dULL,
0x000000100f107220ULL, 0x010fe20000410000ULL, 0x000000063d0f7810ULL, 0x000fe40007ffe0ffULL,
0x000000000d377984ULL, 0x000fe20000000800ULL, 0x00000010380c7824ULL, 0x002fe400078e0209ULL,
0x0000003310337221ULL, 0x000fe20000010000ULL, 0x00001f3d10117589ULL, 0x000e6200000e0000ULL,
0x00000001430c7824ULL, 0x000fe200078e020cULL, 0xfffffff846467812ULL, 0x000fe400078ee20fULL,
0x00001f4510347589ULL, 0x000ea600000e0000ULL, 0x00000010460f7824ULL, 0x100fe200078e0209ULL,
0x000400000d3b7984ULL, 0x0007220000000800ULL, 0x0000001048097824ULL, 0x000fc400078e0209ULL,
0x00000001430f7824ULL, 0x040fe200078e020fULL, 0x0000000008387984ULL, 0x0003220000000800ULL,
0x0000000143097824ULL, 0x000fe200078e0209ULL, 0x00005410ff0d7816ULL, 0x108fe40000000035ULL,
0x000000000c107984ULL, 0x000ee20000000800ULL, 0x00007610ff087816ULL, 0x002fc60000000035ULL,
0x000400000c3d7984ULL, 0x000e620000000800ULL, 0x000000110d327223ULL, 0x080fe20000010032ULL,
0x00005410ff0d7816ULL, 0x000fe20000000039ULL, 0x0000001108317223ULL, 0x080fe20000010031ULL,
0x00007610ff087816ULL, 0x000fe20000000039ULL, 0x000000000e357984ULL, 0x000e640000000800ULL,
0x000000340d307223ULL, 0x084fe20000010030ULL, 0x00005410ff0d7816ULL, 0x100fe20000000036ULL,
0x00000034082f7223ULL, 0x080fe2000001002fULL, 0x00007610ff087816ULL, 0x000fe20000000036ULL,
0x000400000e397984ULL, 0x000ea40000000800ULL, 0x000000110d2e7223ULL, 0x080fe2000001002eULL,
0x00005410ff0d7816ULL, 0x100fe2000000003aULL, 0x00000011082d7223ULL, 0x080fe2000001002dULL,
0x00007610ff087816ULL, 0x000fe2000000003aULL, 0x000000000f0c7984ULL, 0x000ea40000000800ULL,
0x000000340d2c7223ULL, 0x080fe2000001002cULL, 0x00005410ff0d7816ULL, 0x000fe20000000037ULL,
0x00000034082b7223ULL, 0x080fe2000001002bULL, 0x00007610ff087816ULL, 0x000fe20000000037ULL,
0x000400000f367984ULL, 0x000ea40000000800ULL, 0x000000110d2a7223ULL, 0x080fe2000001002aULL,
0x00005410ff0d7816ULL, 0x010fe2000000003bULL, 0x0000001108297223ULL, 0x000fe20000010029ULL,
0x00007610ff087816ULL, 0x000fe2000000003bULL, 0x00000000090e7984ULL, 0x000f240000000800ULL,
0x000000340d287223ULL, 0x000fc40000010028ULL, 0x00040000090d7984ULL, 0x0007220000000800ULL,
0x0000003408277223ULL, 0x000fe20000010027ULL, 0x00007610ff087816ULL, 0x000fca0000000038ULL,
0x0000001108257223ULL, 0x000fe20000010025ULL, 0x00005410ff097816ULL, 0x008fe40000000038ULL,
0x00007610ff087816ULL, 0x000fc6000000003cULL, 0x0000001109267223ULL, 0x000fe20000010026ULL,
0x00005410ff097816ULL, 0x000fe2000000003cULL, 0x0000003408237223ULL, 0x000fe20000010023ULL,
0x00007610ff087816ULL, 0x000fc60000000010ULL, 0x0000003409247223ULL, 0x000fe20000010024ULL,
0x00005410ff097816ULL, 0x000fe20000000010ULL, 0x0000001108217223ULL, 0x000fe20000010021ULL,
0x00007610ff087816ULL, 0x002fc6000000003dULL, 0x0000001109227223ULL, 0x000fe20000010022ULL,
0x00005410ff097816ULL, 0x000fe2000000003dULL, 0x00000034081f7223ULL, 0x000fe2000001001fULL,
0x00005410ff087816ULL, 0x000fc60000000035ULL, 0x0000003409207223ULL, 0x000fe20000010020ULL,
0x00007610ff097816ULL, 0x000fe20000000035ULL, 0x0000001108177223ULL, 0x000fe20000010017ULL,
0x00005410ff087816ULL, 0x004fc60000000039ULL, 0x00000011091e7223ULL, 0x000fe2000001001eULL,
0x00007610ff097816ULL, 0x000fe2000000000cULL, 0x00000034081d7223ULL, 0x000fe2000001001dULL,
0x00007610ff087816ULL, 0x000fc60000000039ULL, 0x00000011091c7223ULL, 0x000fe2000001001cULL,
0x00007610ff097816ULL, 0x000fe20000000036ULL, 0x0000003408157223ULL, 0x000fe20000010015ULL,
0x00005410ff087816ULL, 0x000fc6000000000cULL, 0x00000034091a7223ULL, 0x000fe2000001001aULL,
0x00007610ff097816ULL, 0x010fe2000000000eULL, 0x00000011080b7223ULL, 0x000fe2000001000bULL,
0x00005410ff087816ULL, 0x000fc60000000036ULL, 0x0000001109187223ULL, 0x000fe20000010018ULL,
0x00005410ff097816ULL, 0x000fe2000000000dULL, 0x00000034081b7223ULL, 0x000fe2000001001bULL,
0x00005410ff087816ULL, 0x000fc6000000000eULL, 0x0000003409167223ULL, 0x000fe20000010016ULL,
0x00007610ff097816ULL, 0x000fe2000000000dULL, 0x0000001108197223ULL, 0x000fc80000010019ULL,
0x0000003409127223ULL, 0x000fe20000010012ULL, 0xfffff46000008947ULL, 0x000fea000383ffffULL,
0x0180000033047810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x7f80000004047812ULL, 0x000fe200078ec0ffULL, 0x000000c000007945ULL, 0x000fe60003800000ULL,
0x01ffffff0400780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff067224ULL, 0x002fe200078e0033ULL, 0x0000f23000087802ULL, 0x000fc40000000f00ULL,
0x0000b79000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff047224ULL, 0x000fe200078e0007ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000003300047308ULL, 0x000ea40000001000ULL,
0xbf80000004057423ULL, 0x004fc80000000033ULL, 0x800000ff05057221ULL, 0x000fc80000010100ULL,
0x0000000504047223ULL, 0x000fc40000000004ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000077919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000002ff097819ULL, 0x004fc40000011607ULL, 0x00000008070d7811ULL, 0x040fe200078ff0ffULL,
0x0000000407077824ULL, 0x000fe200078e00ffULL, 0x00000002090a7810ULL, 0x040fe20007ffe0ffULL,
0x00001f0904057589ULL, 0x000ea200000e0000ULL, 0x00000008090f7824ULL, 0x040fe200078e00ffULL,
0x00000003090c7810ULL, 0x040fe20007ffe0ffULL, 0x0000000809117824ULL, 0x040fe200078e00ffULL,
0x00001f0d04067589ULL, 0x002e6200000e0000ULL, 0x0000000809137824ULL, 0x040fe200078e00ffULL,
0x00000004090e7810ULL, 0x040fe20007ffe0ffULL, 0x0000000809107824ULL, 0x000fe200078e00ffULL,
0xfffffff8110a7812ULL, 0x000fe200078ee20aULL, 0x0000000809147824ULL, 0x000fe200078e00ffULL,
0xfffffff8130c7812ULL, 0x000fe200078ee20cULL, 0x000000080d347824ULL, 0x000fe200078e00ffULL,
0x0000000609117810ULL, 0x040fe20007ffe0ffULL, 0x000000100a0a7824ULL, 0x100fe200078e0203ULL,
0xffffffff09137810ULL, 0x000fe20007ffe0ffULL, 0x000000100c0c7824ULL, 0x000fe200078e0203ULL,
0x0000000c07077812ULL, 0x000fc400078ec0ffULL, 0xfffffff814147812ULL, 0x000fe400078ee213ULL,
0xfffffff834347812ULL, 0x000fe200078ee20dULL, 0x00000001070a7824ULL, 0x000fe400078e020aULL,
0x0000001014147824ULL, 0x000fe400078e0203ULL, 0x0000003205327220ULL, 0x044fe40000410000ULL,
0x0000003105317220ULL, 0x040fe40000410000ULL, 0x0000002e052e7220ULL, 0x000fc40000410000ULL,
0x0000002d052d7220ULL, 0x000fe20000410000ULL, 0x000000323131723eULL, 0x000fe200000010ffULL,
0x0000002a052a7220ULL, 0x040fe40000410000ULL, 0x0000002905297220ULL, 0x000fe20000410000ULL,
0x0000002e2d2d723eULL, 0x000fe200000010ffULL, 0x0000002605267220ULL, 0x040fe40000410000ULL,
0x0000002505257220ULL, 0x000fe20000410000ULL, 0x0000002a2929723eULL, 0x000fe200000010ffULL,
0x0000002205227220ULL, 0x000fc40000410000ULL, 0x0000002105217220ULL, 0x000fe20000410000ULL,
0x000000262525723eULL, 0x000fe200000010ffULL, 0x0000001705177220ULL, 0x040fe40000410000ULL,
0x0000001e051e7220ULL, 0x000fe20000410000ULL, 0x000000222121723eULL, 0x000fe200000010ffULL,
0x0000000b050b7220ULL, 0x040fe40000410000ULL, 0x0000001c051c7220ULL, 0x040fe20000410000ULL,
0x000000171e17723eULL, 0x000fe200000010ffULL, 0x0000001905197220ULL, 0x000fc40000410000ULL,
0x0000001805187220ULL, 0x000fe20000410000ULL, 0x0000000b1c0b723eULL, 0x000fe200000010ffULL,
0x0000003006307220ULL, 0x042fe40000410000ULL, 0x0000002f062f7220ULL, 0x000fe20000410000ULL,
0x000000191818723eULL, 0x000fe200000010ffULL, 0x0000002c062c7220ULL, 0x040fe40000410000ULL,
0x0000002b062b7220ULL, 0x040fe20000410000ULL, 0x000000302f2f723eULL, 0x000fe200000010ffULL,
0x0000002806287220ULL, 0x000fc40000410000ULL, 0x0000002706277220ULL, 0x040fe20000410000ULL,
0x0000002c2b2b723eULL, 0x000fe200000010ffULL, 0x0000002406247220ULL, 0x040fe40000410000ULL,
0x0000002306237220ULL, 0x040fe20000410000ULL, 0x000000282727723eULL, 0x000fe200000010ffULL,
0x0000002006207220ULL, 0x040fe40000410000ULL, 0x0000001f061f7220ULL, 0x040fe20000410000ULL,
0x000000242323723eULL, 0x000fe200000010ffULL, 0x0000001d061d7220ULL, 0x000fc40000410000ULL,
0x0000001506047220ULL, 0x040fe20000410000ULL, 0x000000201f1f723eULL, 0x000fe200000010ffULL,
0x0000001b061b7220ULL, 0x040fe40000410000ULL, 0x0000001a061a7220ULL, 0x000fe20000410000ULL,
0x0000001d0404723eULL, 0x000fe200000010ffULL, 0x0000001606167220ULL, 0x040fe40000410000ULL,
0x0000001206057220ULL, 0x000fe20000410000ULL, 0x0000000109067810ULL, 0x040fe20007ffe0ffULL,
0x0000000809157824ULL, 0x040fe200078e00ffULL, 0x0000001b1a1a723eULL, 0x000fe200000010ffULL,
0x0000000809127824ULL, 0x000fe200078e00ffULL, 0xfffffff80f087812ULL, 0x000fe200078ee206ULL,
0x0000000809067824ULL, 0x040fe200078e00ffULL, 0x00000005090f7810ULL, 0x000fe20007ffe0ffULL,
0x00000001070c7824ULL, 0x000fe200078e020cULL, 0xfffffff8150e7812ULL, 0x000fe200078ee20eULL,
0x0000001008087824ULL, 0x000fe200078e0203ULL, 0xfffffff806067812ULL, 0x000fe200078ee209ULL,
0x0000001034347824ULL, 0x000fe200078e0203ULL, 0xfffffff810107812ULL, 0x000fe200078ee20fULL,
0x000000100e0e7824ULL, 0x000fe200078e0203ULL, 0xfffffff812127812ULL, 0x000fe200078ee211ULL,
0x0000001006067824ULL, 0x100fe200078e0203ULL, 0x000000160505723eULL, 0x000fe200000010ffULL,
0x0000001010107824ULL, 0x000fc400078e0203ULL, 0x0000000106067824ULL, 0x000fe400078e0207ULL,
0x0000000107087824ULL, 0x040fe400078e0208ULL, 0x0000001012127824ULL, 0x000fe200078e0203ULL,
0x0000003106007388ULL, 0x0003e20000000800ULL, 0x00000001070e7824ULL, 0x040fe400078e020eULL,
0x0000000107107824ULL, 0x040fe200078e0210ULL, 0x0000002d08007388ULL, 0x0003e20000000800ULL,
0x0000000107127824ULL, 0x000fc400078e0212ULL, 0x0000000107147824ULL, 0x040fe200078e0214ULL,
0x000000290a007388ULL, 0x0003e20000000800ULL, 0x0000000107347824ULL, 0x000fc600078e0234ULL,
0x000000250c007388ULL, 0x0003e80000000800ULL, 0x000000210e007388ULL, 0x0003e80000000800ULL,
0x0000001710007388ULL, 0x0003e80000000800ULL, 0x0000000b12007388ULL, 0x0003e80000000800ULL,
0x0000001814007388ULL, 0x0003e80000000800ULL, 0x0000002f34007388ULL, 0x0003e80000000800ULL,
0x0004002b08007388ULL, 0x0003e80000000800ULL, 0x000400270a007388ULL, 0x0003e80000000800ULL,
0x000400230c007388ULL, 0x0003e80000000800ULL, 0x0004001f0e007388ULL, 0x0003e80000000800ULL,
0x0004000410007388ULL, 0x0003e80000000800ULL, 0x0004001a12007388ULL, 0x0003e80000000800ULL,
0x0004000514007388ULL, 0x0003e20000000800ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000000000077919ULL, 0x004ea20000000000ULL, 0x00000000000579c3ULL, 0x000f220000002700ULL,
0x0000580000047ab9ULL, 0x000fc40000000800ULL, 0x0000000000067919ULL, 0x00ae620000002600ULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x00000020070d7810ULL, 0x004fc60007ffe0ffULL,
0x00000005040472a4ULL, 0x010fe2000f8e023fULL, 0x00000003ff0c7819ULL, 0x000fe40000011607ULL,
0x00000003ff037819ULL, 0x000fe2000001160dULL, 0x00000008060f7824ULL, 0x002fe400078e00ffULL,
0x000000010c057824ULL, 0x000fe400078e0207ULL, 0x000000010d047824ULL, 0x000fe400078e0203ULL,
0x0000000806067824ULL, 0x000fe200078e00ffULL, 0x0000000705087812ULL, 0x000fc400078ec0ffULL,
0x0000000704047812ULL, 0x000fe400078ec0ffULL, 0x0ffffff808097812ULL, 0x000fe400078ef807ULL,
0x0ffffff804057812ULL, 0x000fe400078ef80dULL, 0xfffffff806037812ULL, 0x000fe200078ee203ULL,
0x0000001009087824ULL, 0x100fe200078e0200ULL, 0x000000070d0d7812ULL, 0x000fe200078ec0ffULL,
0x0000001005057824ULL, 0x000fe200078e0200ULL, 0xfffffff80f007812ULL, 0x000fc400078ee20cULL,
0x00000007070f7812ULL, 0x000fe200078ec0ffULL, 0x0120000008087984ULL, 0x000e620000000c00ULL,
0x00000004000c7c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000403007c10ULL, 0x000fe2000ff3e0ffULL,
0x0120000005107984ULL, 0x0004e20000000c00ULL, 0x1ffffff80d0d7812ULL, 0x000fe200078ef802ULL,
0x000000ffff037224ULL, 0x000fe200000e06ffULL, 0x00005a000c047a11ULL, 0x000fe200078048ffULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0x00005a0000067a11ULL, 0x000fc400078248ffULL,
0x00005b000c057a11ULL, 0x004fe400000f4c03ULL, 0x1ffffff80f037812ULL, 0x000fe400078ef802ULL,
0x00005b0000077a11ULL, 0x000fc600008f4c07ULL, 0x0000001003027825ULL, 0x000fc800078e0004ULL,
0x000000100d047825ULL, 0x000fe200078e0006ULL, 0x0000000802007986ULL, 0x002fe8000c101d06ULL,
0x0000001004007986ULL, 0x008fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0000000409bd7824ULL, 0x000fe400078e020aULL, 0xffffffffff037424ULL, 0x000fc600078e00ffULL,
0x000000b7bd00720cULL, 0x000fda0003f06070ULL, 0x00000002da0e8824ULL, 0x000fc800078e00ffULL,
0x000064000e0e8a24ULL, 0x000fc800078e02bdULL, 0x000060000e0e8625ULL, 0x000fe200078e0013ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000060e038981ULL, 0x000ea2000c1e1900ULL,
0x0000000109007810ULL, 0x000fe20007ffe0ffULL, 0x0000000604047899ULL, 0x000fe2000800063fULL,
0x000000400ad87824ULL, 0x000fe200078e00ffULL, 0x01c60000ff0c7f8cULL, 0x000e62000c80043fULL,
0x000000070000720cULL, 0x000fe20003f06070ULL, 0x0000004012067824ULL, 0x000fe400078e00ffULL,
0x0000000403007c24ULL, 0x004fd4000f8e02ffULL, 0x00000e9000008947ULL, 0x000fea0003800000ULL,
0x00000100090b7824ULL, 0x002fe200078e02d8ULL, 0x00000003ff217819ULL, 0x000fe40000011605ULL,
0x0000007010257812ULL, 0x000fe400078ec0ffULL, 0x0000000b08027217ULL, 0x000fe20007800000ULL,
0x0000004012237824ULL, 0x000fe200078e0221ULL, 0x0000000421047810ULL, 0x040fe40007ffe0ffULL,
0x00000008210e7810ULL, 0x040fe20007ffe0ffULL, 0x0000000102027824ULL, 0x000fe200078e0a0bULL,
0x0000001021137810ULL, 0x000fe20007ffe0ffULL, 0x00000001040b7824ULL, 0x140fe200078e0205ULL,
0x0000000c23197810ULL, 0x000fe20007ffe0ffULL, 0x0000000804167824ULL, 0x040fe200078e00ffULL,
0x000000020400720cULL, 0x080fe20003f86070ULL, 0x000000010e047824ULL, 0x040fe200078e0205ULL,
0x000000020e00720cULL, 0x040fe20003f66070ULL, 0x000000080e0f7824ULL, 0x000fe200078e00ffULL,
0xfffffff816167812ULL, 0x000fe200078ee20bULL, 0x0000000113147824ULL, 0x000fe200078e0205ULL,
0x0000000c210b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000813157824ULL, 0x000fe200078e00ffULL,
0xfffffff80f187812ULL, 0x000fc400078ee204ULL, 0x000000020b00720cULL, 0x0c0fe20003f46070ULL,
0x000000010b047824ULL, 0x100fe200078e0205ULL, 0xfffffff8151c7812ULL, 0x000fe200078ee214ULL,
0x000000080b0f7824ULL, 0x000fe200078e00ffULL, 0x00000004230b7810ULL, 0x000fe40007ffe0ffULL,
0x0000001421157810ULL, 0x000fe40007ffe0ffULL, 0xfffffff80f1a7812ULL, 0x000fe400078ee204ULL,
0x0000002300047210ULL, 0x040fe20007f1e0ffULL, 0x0000000115177824ULL, 0x040fe200078e0205ULL,
0x0000000b00127210ULL, 0x000fe20007fbe0ffULL, 0x00000008151e7824ULL, 0x000fe200078e00ffULL,
0x00005e00040e7a11ULL, 0x000fe200078248ffULL, 0x000000ffff0f7224ULL, 0x000fe200000e06ffULL,
0x000000021300720cULL, 0x000fe20003f06070ULL, 0x000000ffff0b7224ULL, 0x000fe200028e06ffULL,
0x00005e0012117a11ULL, 0x000fc400078a48ffULL, 0x00005f0004047a11ULL, 0x000fe200008f4c0fULL,
0x00000001210f7824ULL, 0x000fe200078e0205ULL, 0x0000000e250e7210ULL, 0x000fe40007f3e0ffULL,
0x0000000823137810ULL, 0x000fe40007ffe0ffULL, 0x000000070f147812ULL, 0x000fe200078ec0ffULL,
0x000000ffff0f7224ULL, 0x000fe200008e0604ULL, 0x00005f0012127a11ULL, 0x000fe400028f4c0bULL,
0x0000001300137210ULL, 0x000fc40007fde0ffULL, 0x0000001125107210ULL, 0x000fe40007f3e0ffULL,
0x000000022100720cULL, 0x080fe20003fa6070ULL, 0x000000ffff047224ULL, 0x000fe200030e06ffULL,
0x000020000a0b7811ULL, 0x000fe200078e70ffULL, 0x000000ffff117224ULL, 0x000fe200008e0612ULL,
0x0ffffff814147812ULL, 0x000fe400078ef805ULL, 0x00005e0013127a11ULL, 0x000fe400078c48ffULL,
0x000000021500720cULL, 0x000fe20003f26070ULL, 0x0000001014157824ULL, 0x000fe200078e020bULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee217ULL, 0x0000001016177824ULL, 0x000fe200078e020bULL,
0x00005f0013137a11ULL, 0x000fc400030f4c04ULL, 0x0000001821047810ULL, 0x040fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e157faeULL, 0x0003e2000e901c46ULL,
0x0000001c21167810ULL, 0x000fe40007ffe0ffULL, 0x0000001225127210ULL, 0x000fe20007fbe0ffULL,
0x0000000010177faeULL, 0x0005e2000e101c46ULL, 0x0000000104147824ULL, 0x140fe200078e0205ULL,
0x000000020400720cULL, 0x040fe20003f86070ULL, 0x00000008041b7824ULL, 0x000fe200078e00ffULL,
0x0000001900047210ULL, 0x000fe20007fde0ffULL, 0x0000000116197824ULL, 0x000fc400078e0205ULL,
0x0000000816227824ULL, 0x000fe200078e00ffULL, 0xfffffff81b207812ULL, 0x000fe200078ee214ULL,
0x000000ffff0f7224ULL, 0x002fe200030e06ffULL, 0x00005e00040e7a11ULL, 0x000fe200078c48ffULL,
0x000000ffff137224ULL, 0x000fe200028e0613ULL, 0x0000001023177810ULL, 0x004fe20007ffe0ffULL,
0x0000001018117824ULL, 0x000fe200078e020bULL, 0x00005f0004047a11ULL, 0x000fe200030f4c0fULL,
0x000000101a157824ULL, 0x000fe200078e020bULL, 0x0000000e250e7210ULL, 0x000fe40007fde0ffULL,
0xfffffff822227812ULL, 0x000fe200078ee219ULL, 0x0000000012117faeULL, 0x0003e2000d901c46ULL,
0x0000001423197810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0f7224ULL, 0x000fe200030e0604ULL,
0x0000001700177210ULL, 0x000fc40007f7e0ffULL, 0x0000001900147210ULL, 0x000fe40007fde0ffULL,
0x000000021600720cULL, 0x000fe20003fa6070ULL, 0x000000ffff187224ULL, 0x000fe200018e06ffULL,
0x0000002021047810ULL, 0x000fe20007ffe0ffULL, 0x000000000e157faeULL, 0x0005e2000d101c46ULL,
0x00005e0017167a11ULL, 0x040fe200078648ffULL, 0x000000ffff137224ULL, 0x002fe200030e06ffULL,
0x00005e0014117a11ULL, 0x000fe200078c48ffULL, 0x0000000104107824ULL, 0x040fe200078e0205ULL,
0x00005f0017177a11ULL, 0x000fe200018f4c18ULL, 0x0000000804197824ULL, 0x000fe200078e00ffULL,
0x00005f0014147a11ULL, 0x000fc400030f4c13ULL, 0x0000002421127810ULL, 0x000fe40007ffe0ffULL,
0x000000020400720cULL, 0x000fe40003f46070ULL, 0x0000001823157810ULL, 0x004fe20007ffe0ffULL,
0x0000000112137824ULL, 0x040fe200078e0205ULL, 0x00000016250e7210ULL, 0x000fe20007f7e0ffULL,
0x0000000812187824ULL, 0x000fe200078e00ffULL, 0x0000001500167210ULL, 0x000fe20007fde0ffULL,
0x000000101c157824ULL, 0x000fe200078e020bULL, 0xfffffff819047812ULL, 0x000fe200078ee210ULL,
0x000000ffff0f7224ULL, 0x000fe200018e0617ULL, 0x0000001125107210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff177224ULL, 0x000fe200030e06ffULL, 0x00005e0016197a11ULL, 0x000fc400078c48ffULL,
0x0000001c231b7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff117224ULL, 0x000fe200018e0614ULL,
0xfffffff818147812ULL, 0x000fe200078ee213ULL, 0x000000000e157faeULL, 0x0003e2000c101c46ULL,
0x00005f0016137a11ULL, 0x000fe200030f4c17ULL, 0x000000101e177824ULL, 0x000fe200078e020bULL,
0x000000021200720cULL, 0x000fe40003f66070ULL, 0x0000002821127810ULL, 0x000fe40007ffe0ffULL,
0x0000000010177faeULL, 0x0005e2000c901c46ULL, 0x0000001b001a7210ULL, 0x000fc40007fde0ffULL,
0x0000000112167824ULL, 0x040fe200078e0205ULL, 0x000000021200720cULL, 0x040fe20003f26070ULL,
0x00000008121d7824ULL, 0x000fe200078e00ffULL, 0x0000001925127210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff0f7224ULL, 0x002fe200030e06ffULL, 0x00005e001a0e7a11ULL, 0x000fe200078c48ffULL,
0x0000001022157824ULL, 0x000fe200078e020bULL, 0x0000002c21187810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff137224ULL, 0x000fe200000e0613ULL, 0x0000002023177810ULL, 0x004fe20007ffe0ffULL,
0x0000001020117824ULL, 0x000fe200078e020bULL, 0x00005f001a0f7a11ULL, 0x000fe200030f4c0fULL,
0x0000000118197824ULL, 0x040fe200078e0205ULL, 0x0000000e250e7210ULL, 0x000fe20007fde0ffULL,
0x00000008181c7824ULL, 0x000fe200078e00ffULL, 0x0000000012117faeULL, 0x0003e2000e101c46ULL,
0x00000017001a7210ULL, 0x000fc40007f9e0ffULL, 0x0000002423177810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0f7224ULL, 0x000fe200030e060fULL, 0xfffffff81d167812ULL, 0x000fe200078ee216ULL,
0x000000ffff1d7224ULL, 0x000fe200020e06ffULL, 0x00005e001a1b7a11ULL, 0x000fe400078848ffULL,
0x0000003021107810ULL, 0x000fe20007ffe0ffULL, 0x000000000e157faeULL, 0x0005e2000e901c46ULL,
0x0000001700177210ULL, 0x000fe40007fde0ffULL, 0x000000021800720cULL, 0x000fc40003f06070ULL,
0x00005f001a137a11ULL, 0x002fe200020f4c1dULL, 0x000000ffff127224ULL, 0x000fe200030e06ffULL,
0xfffffff81c187812ULL, 0x000fe200078ee219ULL, 0x0000000110197824ULL, 0x040fe200078e0205ULL,
0x000000021000720cULL, 0x040fe20003fa6070ULL, 0x00000008101c7824ULL, 0x000fe200078e00ffULL,
0x00005e0017107a11ULL, 0x000fe400078c48ffULL, 0x0000001b250e7210ULL, 0x004fe40007f9e0ffULL,
0x0000002823117810ULL, 0x000fc40007ffe0ffULL, 0x00005f0017157a11ULL, 0x000fe200030f4c12ULL,
0x000000ffff0f7224ULL, 0x000fe200020e0613ULL, 0x0000001025107210ULL, 0x000fe20007f9e0ffULL,
0x0000001014177824ULL, 0x000fe200078e020bULL, 0x0000003421127810ULL, 0x040fe40007ffe0ffULL,
0x00000011001f7210ULL, 0x000fe20007fde0ffULL, 0x000000ffff117224ULL, 0x000fe200020e0615ULL,
0xfffffff81c1a7812ULL, 0x000fe200078ee219ULL, 0x0000000112137824ULL, 0x040fe200078e0205ULL,
0x000000021200720cULL, 0x040fe20003f86070ULL, 0x00000008121c7824ULL, 0x000fe200078e00ffULL,
0x0000003c21147810ULL, 0x040fe20007ffe0ffULL, 0x0000001004157824ULL, 0x000fe200078e020bULL,
0x0000003821047810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff1e7224ULL, 0x000fe200030e06ffULL,
0x00005e001f197a11ULL, 0x000fc400078c48ffULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee213ULL,
0x000000000e157faeULL, 0x0003e2000d101c46ULL, 0x00005f001f1f7a11ULL, 0x000fe400030f4c1eULL,
0x0000002c23137810ULL, 0x000fe20007ffe0ffULL, 0x0000000010177faeULL, 0x0005e2000d901c46ULL,
0x0000001925127210ULL, 0x000fe20007f5e0ffULL, 0x0000001016197824ULL, 0x000fe200078e020bULL,
0x00000013001d7210ULL, 0x000fc60007f7e0ffULL, 0x000000ffff137224ULL, 0x000fe200010e061fULL,
0x00005e001d1b7a11ULL, 0x000fe200078c48ffULL, 0x000000ffff1e7224ULL, 0x000fe200018e06ffULL,
0x00000030230f7810ULL, 0x002fe20007ffe0ffULL, 0x00000008140e7824ULL, 0x000fe200078e00ffULL,
0x0000000012197faeULL, 0x0003e2000c901c46ULL, 0x000000020400720cULL, 0x0c0fe20003f66070ULL,
0x0000000804157824ULL, 0x000fe200078e00ffULL, 0x0000000f000f7210ULL, 0x000fe20007f3e0ffULL,
0x000000101c177824ULL, 0x004fe200078e020bULL, 0x000000021400720cULL, 0x000fe20003f46070ULL,
0x0000000104027824ULL, 0x100fe200078e0205ULL, 0x00005f001d117a11ULL, 0x000fe200030f4c1eULL,
0x0000000114057824ULL, 0x000fe200078e0205ULL, 0x00005e000f107a11ULL, 0x000fe200078c48ffULL,
0x000000ffff147224ULL, 0x000fe200008e06ffULL, 0x0000001b25047210ULL, 0x000fc40007f3e0ffULL,
0xfffffff80e0e7812ULL, 0x000fe400078ee205ULL, 0x00005f000f127a11ULL, 0x002fe200030f4c14ULL,
0x000000ffff057224ULL, 0x000fe200008e0611ULL, 0x0000003423117810ULL, 0x000fe20007ffe0ffULL,
0x00000010180f7824ULL, 0x100fe200078e020bULL, 0xfffffff815027812ULL, 0x000fe400078ee202ULL,
0x0000001100147210ULL, 0x000fe40007f3e0ffULL, 0x0000003823137810ULL, 0x040fe20007ffe0ffULL,
0x00000000040f7faeULL, 0x0003e2000c101c46ULL, 0x0000003c23157810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff1b7224ULL, 0x000fe200008e06ffULL, 0x00005e0014117a11ULL, 0x000fe200078248ffULL,
0x0000001002197824ULL, 0x000fe200078e020bULL, 0x0000001300137210ULL, 0x000fc40007f1e0ffULL,
0x00005f0014147a11ULL, 0x000fe400008f4c1bULL, 0x0000001500007210ULL, 0x000fe20007fde0ffULL,
0x000000101a157824ULL, 0x100fe200078e020bULL, 0x0000001025047210ULL, 0x002fe20007f3e0ffULL,
0x000000100e0b7824ULL, 0x000fe400078e020bULL, 0x000000ffff027224ULL, 0x000fe200000e06ffULL,
0x00005e0013107a11ULL, 0x000fe200078048ffULL, 0x000000ffff0f7224ULL, 0x000fe400030e06ffULL,
0x000000ffff057224ULL, 0x000fe200008e0612ULL, 0x00005e0000127a11ULL, 0x000fc400078c48ffULL,
0x00000011250e7210ULL, 0x000fe40007f3e0ffULL, 0x00005f0013027a11ULL, 0x000fe200000f4c02ULL,
0x0000000004157faeULL, 0x0003e2000e901c46ULL, 0x00005f0000007a11ULL, 0x000fe200030f4c0fULL,
0x000000ffff0f7224ULL, 0x000fe200008e0614ULL, 0x0000001025107210ULL, 0x040fe40007f1e0ffULL,
0x0000001225127210ULL, 0x000fe40007f3e0ffULL, 0x000000000e177faeULL, 0x0003e2000e101c46ULL,
0x000000ffff117224ULL, 0x000fc400000e0602ULL, 0x000000ffff137224ULL, 0x000fc600008e0600ULL,
0x0000000010197faeULL, 0x0003e8000d901c46ULL, 0x00000000120b7faeULL, 0x0003e2000d101c46ULL,
0x00000d4000007947ULL, 0x000fea0003800000ULL, 0x0000000405187811ULL, 0x042fe400078fe8ffULL,
0x00000008051b7811ULL, 0x040fe400078fe8ffULL, 0x00000010051f7811ULL, 0x040fe200078fe8ffULL,
0x0000000118027824ULL, 0x140fe200078e0205ULL, 0x0000000c051d7811ULL, 0x040fe200078fe8ffULL,
0x00000008180f7824ULL, 0x000fe200078e00ffULL, 0x0000001405207811ULL, 0x000fe200078fe8ffULL,
0x000000011b047824ULL, 0x100fe200078e0205ULL, 0x0000001805237811ULL, 0x000fe200078fe8ffULL,
0x000000081b117824ULL, 0x000fe200078e00ffULL, 0xfffffff80f227812ULL, 0x000fe200078ee202ULL,
0x000000011f027824ULL, 0x100fe200078e0205ULL, 0x0000001c05257811ULL, 0x000fe200078fe8ffULL,
0x000000081f0f7824ULL, 0x000fe200078e00ffULL, 0xfffffff811247812ULL, 0x000fe200078ee204ULL,
0x000000011d0b7824ULL, 0x100fe200078e0205ULL, 0x00000024050e7811ULL, 0x000fe200078fe8ffULL,
0x000000081d267824ULL, 0x000fe200078e00ffULL, 0xfffffff80f287812ULL, 0x000fe200078ee202ULL,
0x0000000120047824ULL, 0x040fe200078e0205ULL, 0x0000002005027811ULL, 0x000fe200078fe8ffULL,
0x0000000820117824ULL, 0x000fe200078e00ffULL, 0xfffffff826267812ULL, 0x000fe200078ee20bULL,
0x00000001230b7824ULL, 0x100fe200078e0205ULL, 0x0000002c05137811ULL, 0x000fe200078fe8ffULL,
0x00000008232c7824ULL, 0x000fe200078e00ffULL, 0xfffffff8112a7812ULL, 0x000fe200078ee204ULL,
0x0000000102047824ULL, 0x040fe200078e0205ULL, 0x0000000605477211ULL, 0x000fe200078fe8ffULL,
0x0000000802117824ULL, 0x000fe200078e00ffULL, 0xfffffff82c2c7812ULL, 0x000fe200078ee20bULL,
0x00000001250f7824ULL, 0x100fe200078e0205ULL, 0x0000003405177811ULL, 0x000fe200078fe8ffULL,
0x00000008252e7824ULL, 0x000fe200078e00ffULL, 0xfffffff811047812ULL, 0x000fe200078ee204ULL,
0x000000010e0b7824ULL, 0x040fe200078e0205ULL, 0x0000002805117811ULL, 0x000fe200078fe8ffULL,
0x000000080e127824ULL, 0x000fe200078e00ffULL, 0xfffffff82e2e7812ULL, 0x000fe200078ee20fULL,
0x0000000113147824ULL, 0x000fe200078e0205ULL, 0x0000000047477210ULL, 0x080fe20007f1e0ffULL,
0x0000000813197824ULL, 0x000fe200078e00ffULL, 0xfffffff8120f7812ULL, 0x000fe200078ee20bULL,
0x00000001110b7824ULL, 0x000fe200078e0205ULL, 0x0000003005157811ULL, 0x000fe200078fe8ffULL,
0x0000000811127824ULL, 0x000fe200078e00ffULL, 0xfffffff819147812ULL, 0x000fe200078ee214ULL,
0x0000000106457824ULL, 0x000fe200078e0218ULL, 0x0000003805197811ULL, 0x000fe200078fe8ffULL,
0x00000008171a7824ULL, 0x040fe200078e00ffULL, 0xfffffff812127812ULL, 0x000fe200078ee20bULL,
0x00000001170b7824ULL, 0x000fe200078e0205ULL, 0x0000000045457210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff1e7224ULL, 0x000fe200000e06ffULL, 0x00005e0047467a11ULL, 0x040fe200078048ffULL,
0x0000000106437824ULL, 0x000fe200078e021bULL, 0xfffffff81a187812ULL, 0x000fe200078ee20bULL,
0x00000001061f7824ULL, 0x040fe200078e021fULL, 0x00005f0047477a11ULL, 0x000fe200000f4c1eULL,
0x000000ffff1c7224ULL, 0x000fe200008e06ffULL, 0x00005e0045447a11ULL, 0x000fe200078248ffULL,
0x0000000115167824ULL, 0x100fe200078e0205ULL, 0x0000000043437210ULL, 0x080fe20007f1e0ffULL,
0x0000000815217824ULL, 0x000fe200078e00ffULL, 0x000000001f3c7210ULL, 0x080fe20007f5e0ffULL,
0x00000001190b7824ULL, 0x000fe200078e0205ULL, 0x00005f0045457a11ULL, 0x000fe200008f4c1cULL,
0x00000008191a7824ULL, 0x000fe200078e00ffULL, 0xfffffff821167812ULL, 0x000fe200078ee216ULL,
0x00000001061d7824ULL, 0x000fe200078e021dULL, 0x00000005051e7211ULL, 0x000fe200078fe8ffULL,
0x000000ffff1c7224ULL, 0x000fe200000e06ffULL, 0xfffffff81a1a7812ULL, 0x000fe200078ee20bULL,
0x0000000106217824ULL, 0x040fe200078e0220ULL, 0x000000001d407210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200010e06ffULL, 0x00005e0043427a11ULL, 0x040fe200078048ffULL,
0x0000000106237824ULL, 0x000fe200078e0223ULL, 0x00005e003c3a7a11ULL, 0x000fe200078448ffULL,
0x000000ffff1b7224ULL, 0x000fe200008e06ffULL, 0x00005f0043437a11ULL, 0x000fe200000f4c1cULL,
0x0000000106257824ULL, 0x000fe200078e0225ULL, 0x00005e00403e7a11ULL, 0x000fe200078248ffULL,
0x0000000106137824ULL, 0x040fe200078e0213ULL, 0x0000000021387210ULL, 0x080fe20007f1e0ffULL,
0x0000000106157824ULL, 0x000fe200078e0215ULL, 0x00005f003c3c7a11ULL, 0x000fe200010f4c0bULL,
0x00000001060b7824ULL, 0x000fe200078e0202ULL, 0x00005f0040407a11ULL, 0x000fe200008f4c1bULL,
0x000000ffff1b7224ULL, 0x000fe200000e06ffULL, 0x0000000023347210ULL, 0x080fe20007f3e0ffULL,
0x0000000106117824ULL, 0x040fe200078e0211ULL, 0x0000000025307210ULL, 0x000fe20007f5e0ffULL,
0x0000000106177824ULL, 0x000fe200078e0217ULL, 0x00005e0038367a11ULL, 0x000fe200078048ffULL,
0x000000ffff1f7224ULL, 0x000fe200008e06ffULL, 0x0000000b000b7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff1d7224ULL, 0x000fe200010e06ffULL, 0x00005f0038387a11ULL, 0x000fe200000f4c1bULL,
0x0000000106197824ULL, 0x000fe200078e0219ULL, 0x00005e00301b7a11ULL, 0x000fe200078248ffULL,
0x000000ffff027224ULL, 0x000fe200018e06ffULL, 0x00005e000b1c7a11ULL, 0x000fc400078448ffULL,
0x00005f0030307a11ULL, 0x000fe400008f4c1dULL, 0x00005f000b1d7a11ULL, 0x000fe200010f4c02ULL,
0x00000001060b7824ULL, 0x000fe200078e020eULL, 0x0000003c05027811ULL, 0x000fe400078fe8ffULL,
0x00005e0034327a11ULL, 0x000fe400078048ffULL, 0x000000071e1e7812ULL, 0x000fe200078ec0ffULL,
0x00000001020e7824ULL, 0x000fe200078e0205ULL, 0x0000000b000b7210ULL, 0x000fc40007f9e0ffULL,
0x00005f0034347a11ULL, 0x000fe200000f4c1fULL, 0x00000008021f7824ULL, 0x000fe200078e00ffULL,
0x0ffffff81e207812ULL, 0x000fe200078ef805ULL, 0x0000000106057824ULL, 0x000fe200078e0202ULL,
0x000020000a417811ULL, 0x000fe200078e70ffULL, 0x000000ffff027224ULL, 0x000fe200020e06ffULL,
0x0000001300137210ULL, 0x040fe40007f1e0ffULL, 0x0000001500157210ULL, 0x000fe20007f3e0ffULL,
0x000000102e317824ULL, 0x100fe200078e0241ULL, 0x00005e000b1e7a11ULL, 0x000fe200078c48ffULL,
0x0000001022257824ULL, 0x100fe200078e0241ULL, 0x0000001100117210ULL, 0x000fe20007f7e0ffULL,
0x0000001024277824ULL, 0x100fe200078e0241ULL, 0xfffffff81f0e7812ULL, 0x000fe200078ee20eULL,
0x000000ffff2e7224ULL, 0x000fe200008e06ffULL, 0x00005f000b1f7a11ULL, 0x000fe200030f4c02ULL,
0x000000ffff027224ULL, 0x000fe200000e06ffULL, 0x0000001700177210ULL, 0x000fe20007f5e0ffULL,
0x0000001004337824ULL, 0x100fe200078e0241ULL, 0x0000001900197210ULL, 0x000fe20007f9e0ffULL,
0x00000010200b7824ULL, 0x100fe200078e0241ULL, 0x00005e0013227a11ULL, 0x000fe200078048ffULL,
0x000000ffff047224ULL, 0x000fe200018e06ffULL, 0x00005e0015247a11ULL, 0x000fe200078248ffULL,
0x000000102c2f7824ULL, 0x100fe200078e0241ULL, 0x0000000500007210ULL, 0x000fe20007fbe0ffULL,
0x0000001026297824ULL, 0x100fe200078e0241ULL, 0x00005e0011207a11ULL, 0x000fe200078648ffULL,
0x000000ffff2c7224ULL, 0x000fe200010e06ffULL, 0x00005f0013237a11ULL, 0x000fe200000f4c02ULL,
0x00000010282b7824ULL, 0x100fe200078e0241ULL, 0x00005f00152e7a11ULL, 0x000fe200008f4c2eULL,
0x000000ffff027224ULL, 0x000fe200020e06ffULL, 0x0000007010497812ULL, 0x000fe200078ec0ffULL,
0x000000102a2d7824ULL, 0x100fe200078e0241ULL, 0x00005e0017267a11ULL, 0x000fe200078248ffULL,
0x000000ffff057224ULL, 0x000fe200028e06ffULL, 0x00005f0011217a11ULL, 0x000fe200018f4c04ULL,
0x000000100f357824ULL, 0x100fe200078e0241ULL, 0x00005e0019287a11ULL, 0x000fe200078448ffULL,
0x0000001012377824ULL, 0x100fe200078e0241ULL, 0x00005e00002a7a11ULL, 0x000fe200078648ffULL,
0x0000001014397824ULL, 0x100fe200078e0241ULL, 0x0000004649047210ULL, 0x000fe20007f1e0ffULL,
0x00000010163b7824ULL, 0x100fe200078e0241ULL, 0x00005f00172c7a11ULL, 0x000fe200008f4c2cULL,
0x00000010183d7824ULL, 0x100fe200078e0241ULL, 0x00005f0019027a11ULL, 0x000fe200010f4c02ULL,
0x000000101a3f7824ULL, 0x000fe200078e0241ULL, 0x00005f0000007a11ULL, 0x000fe200018f4c05ULL,
0x000000100e417824ULL, 0x000fe200078e0241ULL, 0x00000044490e7210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff057224ULL, 0x000fe200000e0647ULL, 0x0000004249107210ULL, 0x000fc40007f5e0ffULL,
0x0000003e49127210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e0645ULL,
0x0000003a49147210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff117224ULL, 0x000fe200010e0643ULL,
0x0000003649167210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff137224ULL, 0x000fe200018e0640ULL,
0x0000003249187210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff157224ULL, 0x000fe200028e063cULL,
0x0000001b491a7210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff177224ULL, 0x000fe200020e0638ULL,
0x0000001c491c7210ULL, 0x040fe20007f5e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040b7faeULL, 0x0003e2000b901c46ULL, 0x0000001e491e7210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff197224ULL, 0x000fe200000e0634ULL, 0x0000002049207210ULL, 0x040fe20007fbe0ffULL,
0x000000000e257faeULL, 0x0005e2000b901c46ULL, 0x0000002249227210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff1b7224ULL, 0x000fe200008e0630ULL, 0x0000002449247210ULL, 0x040fe20007f1e0ffULL,
0x0000000010277faeULL, 0x0007e2000b901c46ULL, 0x0000002649267210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff1d7224ULL, 0x000fe200010e061dULL, 0x0000002849287210ULL, 0x040fe20007f5e0ffULL,
0x0000000012297faeULL, 0x0009e2000b901c46ULL, 0x000000ffff1f7224ULL, 0x000fe200018e061fULL,
0x0000002a492a7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff217224ULL, 0x000fe200028e0621ULL,
0x00000000142b7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff237224ULL, 0x000fc400020e0623ULL,
0x000000ffff257224ULL, 0x004fe200000e062eULL, 0x00000000162d7faeULL, 0x0005e2000b901c46ULL,
0x000000ffff277224ULL, 0x008fc600008e062cULL, 0x00000000182f7faeULL, 0x0005e2000b901c46ULL,
0x000000ffff297224ULL, 0x010fc600010e0602ULL, 0x000000001a317faeULL, 0x0005e2000b901c46ULL,
0x000000ffff2b7224ULL, 0x002fc600018e0600ULL, 0x000000001c337faeULL, 0x0005e8000b901c46ULL,
0x000000001e357faeULL, 0x0005e8000b901c46ULL, 0x0000000020377faeULL, 0x0005e8000b901c46ULL,
0x0000000022397faeULL, 0x0005e8000b901c46ULL, 0x00000000243b7faeULL, 0x0005e8000b901c46ULL,
0x00000000263d7faeULL, 0x0005e8000b901c46ULL, 0x00000000283f7faeULL, 0x0005e8000b901c46ULL,
0x000000002a417faeULL, 0x0005e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000047805ULL, 0x002fc40000015200ULL, 0x01c60400ff0b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fc4000780480dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff027224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000e7805ULL, 0x000fcc0000015200ULL,
0x0000000e040b7210ULL, 0x000fca0007f1e1ffULL, 0x000000010f0e7824ULL, 0x000fe200000e0e05ULL,
0x003d09000b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0e00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0e00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc8000001140eULL, 0x0000000b00007211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060eULL, 0x0000000200007819ULL, 0x000fc8000000120bULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000102027810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01c60400ff0b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fe4000780480dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000070900720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000e620000000000ULL,
0x00006400dada7a24ULL, 0x000fe200078e02ffULL, 0x0001c6880ad67811ULL, 0x040fe200078e18ffULL,
0x000000200ad77824ULL, 0x000fe200078e00ffULL, 0xffffffff07d97810ULL, 0x000fc40007ffe0ffULL,
0x0000010009047824ULL, 0x004fe200078e02d8ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x000000040800720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x008fea0003800000ULL,
0x0000000109007810ULL, 0x000fe20007ffe0ffULL, 0x0000000403467c24ULL, 0x000fc6000f8e02ffULL,
0x000000070000720cULL, 0x000fda0003f06070ULL, 0x00000d8000008947ULL, 0x000fea0003800000ULL,
0x00000003ff337819ULL, 0x006fe20000011605ULL, 0x0000000108007824ULL, 0x000fe200078e0a04ULL,
0x0ffffff805a17812ULL, 0x000fe400078ec0ffULL, 0x0000000433037810ULL, 0x040fe20007ffe0ffULL,
0x00000001060f7824ULL, 0x040fe200078e0233ULL, 0x0000000c332d7810ULL, 0x040fe40007ffe0ffULL,
0x0000000833297810ULL, 0x000fe20007ffe0ffULL, 0x0000000103027824ULL, 0x040fe200078e0205ULL,
0x000000000300720cULL, 0x040fe20003f26070ULL, 0x00000008032b7824ULL, 0x000fe200078e00ffULL,
0x000000460f0f7210ULL, 0x080fe20007f9e0ffULL, 0x00000001060d7824ULL, 0x040fe200078e0203ULL,
0x0000001433357810ULL, 0x000fe20007ffe0ffULL, 0x0000000106037824ULL, 0x040fe200078e022dULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee202ULL, 0x00000001060b7824ULL, 0x000fe200078e0229ULL,
0x000000460d0d7210ULL, 0x080fe20007fbe0ffULL, 0x000000ffff107224ULL, 0x000fe200020e06ffULL,
0x0000004603027210ULL, 0x080fe20007f7e0ffULL, 0x00000008292f7824ULL, 0x000fe200078e00ffULL,
0x000000460b0b7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200028e06ffULL,
0x00005e000d187a11ULL, 0x000fe200078a48ffULL, 0x000000ffff037224ULL, 0x000fe200018e06ffULL,
0x00005e000f167a11ULL, 0x000fe200078848ffULL, 0x000000ffff0c7224ULL, 0x000fe200010e06ffULL,
0x00005e00021c7a11ULL, 0x000fe200078648ffULL, 0x000000082d2a7824ULL, 0x000fe200078e00ffULL,
0x0000001033317810ULL, 0x000fe20007ffe0ffULL, 0x00000001352c7824ULL, 0x000fe200078e0205ULL,
0x0000001c33397810ULL, 0x000fc40007ffe0ffULL, 0x00005f000d197a11ULL, 0x000fe200028f4c0eULL,
0x00000001060d7824ULL, 0x040fe200078e0235ULL, 0x00005e000b1a7a11ULL, 0x000fe400078448ffULL,
0x00005f000f177a11ULL, 0x000fe200020f4c10ULL, 0x00000001060f7824ULL, 0x000fe200078e0231ULL,
0x00005f00021d7a11ULL, 0x000fe200018f4c03ULL, 0x0000000106037824ULL, 0x000fe200078e0239ULL,
0x0000001833377810ULL, 0x000fe40007ffe0ffULL, 0x00005f000b1b7a11ULL, 0x000fc400010f4c0cULL,
0x000000460d0d7210ULL, 0x080fe20007fbe0ffULL, 0x00000001060b7824ULL, 0x000fe200078e0237ULL,
0x000000460f0f7210ULL, 0x080fe40007f9e0ffULL, 0x0000004603027210ULL, 0x080fe20007f7e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200028e06ffULL, 0x000000460b0b7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff147224ULL, 0x000fe200020e06ffULL, 0x00005e000d207a11ULL, 0x000fe200078a48ffULL,
0x000000ffff037224ULL, 0x000fe200018e06ffULL, 0x00000028333f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0c7224ULL, 0x000fe200010e06ffULL, 0x00005e000f1e7a11ULL, 0x000fc400078848ffULL,
0x00005e0002107a11ULL, 0x000fe400078648ffULL, 0x00000020333b7810ULL, 0x040fe40007ffe0ffULL,
0x0000002c33417810ULL, 0x000fe40007ffe0ffULL, 0x00005f000d217a11ULL, 0x000fe200028f4c0eULL,
0x00000001060d7824ULL, 0x040fe200078e023fULL, 0x00005e000b127a11ULL, 0x000fe400078448ffULL,
0x00005f000f1f7a11ULL, 0x000fe200020f4c14ULL, 0x00000001060f7824ULL, 0x000fe200078e0241ULL,
0x00005f0002117a11ULL, 0x000fe200018f4c03ULL, 0x0000000106037824ULL, 0x000fe200078e023bULL,
0x00000024333d7810ULL, 0x000fc40007ffe0ffULL, 0x00005f000b137a11ULL, 0x000fe400010f4c0cULL,
0x0000000d460d7210ULL, 0x000fe20007f5e0ffULL, 0x00000001060b7824ULL, 0x000fe200078e023dULL,
0x0000000346157210ULL, 0x040fe40007f9e0ffULL, 0x0000000f46027210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff147224ULL, 0x000fe200010e06ffULL, 0x00005e000d0e7a11ULL, 0x000fe200078448ffULL,
0x000000ffff287224ULL, 0x000fe200020e06ffULL, 0x0000000b460b7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff037224ULL, 0x000fe200018e06ffULL, 0x00005e0015227a11ULL, 0x000fc400078848ffULL,
0x00005e00020c7a11ULL, 0x040fe200078648ffULL, 0x000000ffff267224ULL, 0x000fe200028e06ffULL,
0x0000003033437810ULL, 0x000fe40007ffe0ffULL, 0x00005f000d0f7a11ULL, 0x000fe200010f4c14ULL,
0x0000000133147824ULL, 0x100fe200078e0205ULL, 0x00005f0015237a11ULL, 0x000fe200020f4c28ULL,
0x0000000129287824ULL, 0x040fe200078e0205ULL, 0x00005f00020d7a11ULL, 0x000fe200018f4c03ULL,
0x0000000106157824ULL, 0x000fe200078e0243ULL, 0x000000002900720cULL, 0x000fe20003f66070ULL,
0x000000012d297824ULL, 0x000fe200078e0205ULL, 0x00005e000b247a11ULL, 0x000fc400078a48ffULL,
0x0000000705037812ULL, 0x000fe400078ec0ffULL, 0x0000003433457810ULL, 0x040fe40007ffe0ffULL,
0x000000003300720cULL, 0x080fe40003f46070ULL, 0x000000002d00720cULL, 0x000fe40003f86070ULL,
0x00005f000b257a11ULL, 0x000fe400028f4c26ULL, 0xfffffff82f2d7812ULL, 0x000fc400078ee228ULL,
0x000040000a027811ULL, 0x000fe400078e70ffULL, 0x00000008030b7812ULL, 0x000fe400078efcffULL,
0x00000007a1277812ULL, 0x000fe200078ef814ULL, 0x000000102b2b7824ULL, 0x100fe200078e0202ULL,
0xfffffff82a2f7812ULL, 0x000fe200078ee229ULL, 0x0000000106297824ULL, 0x000fe200078e0245ULL,
0x0000001546157210ULL, 0x040fe20007fbe0ffULL, 0x0000001027277824ULL, 0x000fe200078e0202ULL,
0x0000003833477810ULL, 0x000fe20007ffe0ffULL, 0x000000100b167825ULL, 0x000fe200078e0016ULL,
0x0000002946297210ULL, 0x000fc40007fde0ffULL, 0x0000003c33337810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x000fe200028e06ffULL, 0x00005e0015147a11ULL, 0x000fe200078a48ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016277faeULL, 0x0003e2000d101c46ULL,
0x000000ffff287224ULL, 0x000fe200030e06ffULL, 0x000000003500720cULL, 0x080fe20003f46070ULL,
0x00000001312a7824ULL, 0x000fe200078e0205ULL, 0x00005f0015157a11ULL, 0x000fe200028f4c26ULL,
0x000000102d2d7824ULL, 0x100fe200078e0202ULL, 0x00005e0029267a11ULL, 0x000fe200078c48ffULL,
0x000000102f2f7824ULL, 0x000fe200078e0202ULL, 0x000000003100720cULL, 0x040fe20003fa6070ULL,
0x0000000831317824ULL, 0x000fc400078e00ffULL, 0x0000000835357824ULL, 0x000fe200078e00ffULL,
0x00005f0029277a11ULL, 0x002fe200030f4c28ULL, 0x000000100b167825ULL, 0x000fe200078e0018ULL,
0xfffffff831317812ULL, 0x000fe400078ee22aULL, 0xfffffff835357812ULL, 0x000fe200078ee22cULL,
0x0000000106197824ULL, 0x000fe200078e0247ULL, 0x00000000162b7faeULL, 0x0003e2000c901c46ULL,
0x0000001031317824ULL, 0x000fe200078e0202ULL, 0x000000003700720cULL, 0x040fe20003f26070ULL,
0x00000001372c7824ULL, 0x000fe200078e0205ULL, 0x0000001946297210ULL, 0x000fe20007fde0ffULL,
0x000000100b187825ULL, 0x000fc800078e001cULL, 0x000000ffff2a7224ULL, 0x000fe200030e06ffULL,
0x00005e0029287a11ULL, 0x000fe200078c48ffULL, 0x00000001061d7824ULL, 0x000fe400078e0233ULL,
0x000000100b167825ULL, 0x002fe200078e001aULL, 0x00005f0029297a11ULL, 0x000fe400030f4c2aULL,
0x0000001d461d7210ULL, 0x000fe20007fde0ffULL, 0x000000100b1a7825ULL, 0x000fe200078e001eULL,
0x00000000162d7faeULL, 0x0003e2000d901c46ULL, 0x000000003d00720cULL, 0x000fc40003f66070ULL,
0x0000000837377824ULL, 0x000fe200078e00ffULL, 0x00000000182f7faeULL, 0x0005e2000e101c46ULL,
0x00000001391e7824ULL, 0x100fe200078e0205ULL, 0x000000003b00720cULL, 0x0c0fe20003f86070ULL,
0x000000013b1f7824ULL, 0x100fe200078e0205ULL, 0x000000001a317faeULL, 0x0007e2000e901c46ULL,
0x000000003900720cULL, 0x040fe20003fa6070ULL, 0x0000000839397824ULL, 0x000fe200078e00ffULL,
0xfffffff8372b7812ULL, 0x000fe200078ee22cULL, 0x000000013d177824ULL, 0x002fe400078e0205ULL,
0x000000083b2a7824ULL, 0x000fe200078e00ffULL, 0xfffffff8392d7812ULL, 0x000fe200078ee21eULL,
0x000000083d187824ULL, 0x004fc400078e00ffULL, 0x000000ffff167224ULL, 0x000fe200030e06ffULL,
0x00005e001d1c7a11ULL, 0x000fe200078c48ffULL, 0x000000102b2b7824ULL, 0x000fe200078e0202ULL,
0xfffffff818177812ULL, 0x000fe200078ee217ULL, 0x000000100b127825ULL, 0x000fe200078e0012ULL,
0xfffffff82a2f7812ULL, 0x000fe400078ee21fULL, 0x00005f001d1d7a11ULL, 0x000fe200030f4c16ULL,
0x0000001017317824ULL, 0x108fe200078e0202ULL, 0x000000003300720cULL, 0x000fe20003fc6070ULL,
0x00000010351f7824ULL, 0x000fc400078e0202ULL, 0x000000100b167825ULL, 0x000fc800078e0020ULL,
0x000000102d2d7824ULL, 0x000fe200078e0202ULL, 0x00000000161f7faeULL, 0x0003e2000d101c46ULL,
0x000000100b107825ULL, 0x000fe200078e0010ULL, 0x000000004100720cULL, 0x080fe40003f46070ULL,
0x00000000122b7faeULL, 0x0005e2000c901c46ULL, 0x000000102f2f7824ULL, 0x000fe200078e0202ULL,
0x000000003f00720cULL, 0x080fe20003f26070ULL, 0x000000100b187825ULL, 0x000fe200078e0022ULL,
0x00000000102d7faeULL, 0x0007e2000e901c46ULL, 0x000000004700720cULL, 0x000fc40003fa6070ULL,
0x000000100b1a7825ULL, 0x000fe200078e0024ULL, 0x00000000182f7faeULL, 0x0009e2000e101c46ULL,
0x000000004500720cULL, 0x080fe40003f86070ULL, 0x000000013f1e7824ULL, 0x140fe200078e0205ULL,
0x000000001a317faeULL, 0x0005e2000d901c46ULL, 0x000000083f3f7824ULL, 0x000fe200078e00ffULL,
0x000000004300720cULL, 0x000fe20003f66070ULL, 0x0000000141207824ULL, 0x040fe400078e0205ULL,
0x0000000841417824ULL, 0x000fc400078e00ffULL, 0x0000000143007824ULL, 0x100fe200078e0205ULL,
0xfffffff83f197812ULL, 0x010fe200078ee21eULL, 0x00000008431f7824ULL, 0x002fe400078e00ffULL,
0x0000000147117824ULL, 0x108fe200078e0205ULL, 0xfffffff8411b7812ULL, 0x004fe200078ee220ULL,
0x0000000847167824ULL, 0x000fe200078e00ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee200ULL,
0x0000000145107824ULL, 0x040fe400078e0205ULL, 0x0000000845217824ULL, 0x000fe200078e00ffULL,
0xfffffff816117812ULL, 0x000fe200078ee211ULL, 0x0000000133127824ULL, 0x000fc400078e0205ULL,
0x0000000833257824ULL, 0x000fe200078e00ffULL, 0xfffffff821217812ULL, 0x000fe200078ee210ULL,
0x0000001019197824ULL, 0x000fe400078e0202ULL, 0x000000100b0e7825ULL, 0x000fe200078e000eULL,
0xfffffff825257812ULL, 0x000fc600078ee212ULL, 0x000000101b1b7824ULL, 0x000fe200078e0202ULL,
0x000000000e197faeULL, 0x0003e2000c901c46ULL, 0x000000100b0c7825ULL, 0x000fc800078e000cULL,
0x000000101f1f7824ULL, 0x100fe200078e0202ULL, 0x000000000c1b7faeULL, 0x0003e2000d101c46ULL,
0x0000001011237824ULL, 0x000fe400078e0202ULL, 0x000000100b147825ULL, 0x000fc800078e0014ULL,
0x0000001021217824ULL, 0x000fe200078e0202ULL, 0x00000000141f7faeULL, 0x0003e2000d901c46ULL,
0x000000100b107825ULL, 0x000fc800078e0026ULL, 0x000000100b127825ULL, 0x000fe200078e0028ULL,
0x0000000010217faeULL, 0x0003e6000e101c46ULL, 0x0000001025257824ULL, 0x000fe200078e0202ULL,
0x0000000012237faeULL, 0x0003e2000e901c46ULL, 0x000000100b167825ULL, 0x000fca00078e001cULL,
0x0000000016257faeULL, 0x0003e2000f101c46ULL, 0x00000c5000007947ULL, 0x000fea0003800000ULL,
0x00000004050b7811ULL, 0x042fe400078fe8ffULL, 0x0000000c05117811ULL, 0x040fe400078fe8ffULL,
0x0000000805107811ULL, 0x000fe200078fe8ffULL, 0x000000010b007824ULL, 0x100fe200078e0205ULL,
0x0000001005157811ULL, 0x000fe200078fe8ffULL, 0x000000080b0d7824ULL, 0x000fe200078e00ffULL,
0x0000001805197811ULL, 0x004fe200078fe8ffULL, 0x0000000111037824ULL, 0x100fe200078e0205ULL,
0x0000001405177811ULL, 0x000fe200078fe8ffULL, 0x0000000811147824ULL, 0x000fe200078e00ffULL,
0xfffffff80d0e7812ULL, 0x000fe200078ee200ULL, 0x0000000110027824ULL, 0x040fe200078e0205ULL,
0x0000001c051b7811ULL, 0x000fe200078fe8ffULL, 0x00000008100f7824ULL, 0x000fe200078e00ffULL,
0xfffffff814147812ULL, 0x000fe200078ee203ULL, 0x0000000115007824ULL, 0x100fe200078e0205ULL,
0x00000024051f7811ULL, 0x000fe200078fe8ffULL, 0x00000008150d7824ULL, 0x000fe200078e00ffULL,
0xfffffff80f127812ULL, 0x000fe200078ee202ULL, 0x0000000119037824ULL, 0x100fe200078e0205ULL,
0x00000020051d7811ULL, 0x000fe200078fe8ffULL, 0x00000008191a7824ULL, 0x000fe200078e00ffULL,
0xfffffff80d167812ULL, 0x000fe200078ee200ULL, 0x0000000117027824ULL, 0x000fe200078e0205ULL,
0x0000002805217811ULL, 0x000fe200078fe8ffULL, 0x00000008170f7824ULL, 0x000fe200078e00ffULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee203ULL, 0x000000011b007824ULL, 0x100fe200078e0205ULL,
0x0000003005257811ULL, 0x000fe200078fe8ffULL, 0x000000081b0d7824ULL, 0x000fe200078e00ffULL,
0xfffffff80f187812ULL, 0x000fe200078ee202ULL, 0x000000011f037824ULL, 0x100fe200078e0205ULL,
0x0000002c05237811ULL, 0x000fe200078fe8ffULL, 0x000000081f207824ULL, 0x000fe200078e00ffULL,
0xfffffff80d1c7812ULL, 0x000fe200078ee200ULL, 0x000000011d027824ULL, 0x000fe200078e0205ULL,
0x0000003405277811ULL, 0x000fe200078fe8ffULL, 0x000000081d0f7824ULL, 0x000fe200078e00ffULL,
0xfffffff820207812ULL, 0x000fe200078ee203ULL, 0x0000000121007824ULL, 0x100fe200078e0205ULL,
0x0000003805297811ULL, 0x000fe200078fe8ffULL, 0x00000008210d7824ULL, 0x000fe200078e00ffULL,
0xfffffff80f1e7812ULL, 0x000fe200078ee202ULL, 0x0000000125037824ULL, 0x100fe200078e0205ULL,
0x0000003c052b7811ULL, 0x000fe200078fe8ffULL, 0x0000000825267824ULL, 0x000fe200078e00ffULL,
0xfffffff80d227812ULL, 0x000fe200078ee200ULL, 0x0000000123027824ULL, 0x000fe200078e0205ULL,
0x0ffffff805a17812ULL, 0x000fe200078ec0ffULL, 0x00000008230f7824ULL, 0x000fe200078e00ffULL,
0xfffffff826267812ULL, 0x000fe200078ee203ULL, 0x0000000127007824ULL, 0x100fe200078e0205ULL,
0x0000000605037211ULL, 0x000fe200078fe8ffULL, 0x00000008270d7824ULL, 0x000fe200078e00ffULL,
0xfffffff80f247812ULL, 0x000fe200078ee202ULL, 0x0000000129027824ULL, 0x140fe200078e0205ULL,
0x000040000a497811ULL, 0x000fe200078e70ffULL, 0x00000008290f7824ULL, 0x000fe200078e00ffULL,
0xfffffff80d287812ULL, 0x000fe200078ee200ULL, 0x000000012b0d7824ULL, 0x000fe200078e0205ULL,
0x0000004603007210ULL, 0x080fe20007f3e0ffULL, 0x000000082b2c7824ULL, 0x000fe200078e00ffULL,
0xfffffff80f2a7812ULL, 0x000fe200078ee202ULL, 0x00000001060f7824ULL, 0x000fe200078e020bULL,
0x0000000505027211ULL, 0x000fe200078fe8ffULL, 0x000000ffff037224ULL, 0x000fe200008e06ffULL,
0x00005e00000c7a11ULL, 0x000fe200078248ffULL, 0x0000000106117824ULL, 0x000fe200078e0211ULL,
0xfffffff82c2c7812ULL, 0x000fe200078ee20dULL, 0x0000001014317824ULL, 0x000fe200078e0249ULL,
0x00005f00000d7a11ULL, 0x000fe200008f4c03ULL, 0x0000000106037824ULL, 0x000fe200078e0210ULL,
0x00000007a1027812ULL, 0x000fe200078ef802ULL, 0x000000100e2d7824ULL, 0x100fe200078e0249ULL,
0x000000460f0f7210ULL, 0x080fe20007f3e0ffULL, 0x00000010122f7824ULL, 0x100fe200078e0249ULL,
0x0000004611007210ULL, 0x080fe20007f7e0ffULL, 0x00000010020b7824ULL, 0x000fe200078e0249ULL,
0x0000004603027210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff147224ULL, 0x000fe200008e06ffULL,
0x00005e000f0e7a11ULL, 0x040fe200078248ffULL, 0x000000ffff037224ULL, 0x000fe200018e06ffULL,
0x00005e0000127a11ULL, 0x000fe200078648ffULL, 0x00000001061b7824ULL, 0x000fe200078e021bULL,
0x00005f000f0f7a11ULL, 0x000fe200008f4c14ULL, 0x000000ffff117224ULL, 0x000fe200010e06ffULL,
0x00005f0000137a11ULL, 0x000fe200018f4c03ULL, 0x0000000106157824ULL, 0x040fe200078e0215ULL,
0x000000461b007210ULL, 0x000fe20007f3e0ffULL, 0x0000000106177824ULL, 0x000fe200078e0217ULL,
0x00005e0002107a11ULL, 0x000fe200078448ffULL, 0x0000000106197824ULL, 0x000fc400078e0219ULL,
0x000000101a377824ULL, 0x000fe200078e0249ULL, 0x00005f0002117a11ULL, 0x000fe200010f4c11ULL,
0x000000ffff037224ULL, 0x000fe200008e06ffULL, 0x0000004615157210ULL, 0x080fe20007f5e0ffULL,
0x0000000106237824ULL, 0x000fe200078e0223ULL, 0x00005e00001a7a11ULL, 0x000fe200078248ffULL,
0x000000101e3b7824ULL, 0x100fe200078e0249ULL, 0x0000004617177210ULL, 0x080fe20007f7e0ffULL,
0x000000101c397824ULL, 0x000fe200078e0249ULL, 0x0000004619027210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff1e7224ULL, 0x000fe200010e06ffULL, 0x00005f00001b7a11ULL, 0x000fe200008f4c03ULL,
0x0000001016337824ULL, 0x000fe200078e0249ULL, 0x0000004623007210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff1c7224ULL, 0x000fe200018e06ffULL, 0x00005e0015147a11ULL, 0x000fe200078448ffULL,
0x00000001061d7824ULL, 0x000fe200078e021dULL, 0x00005e0017167a11ULL, 0x000fe200078648ffULL,
0x0000001018357824ULL, 0x000fe200078e0249ULL, 0x00005f0015157a11ULL, 0x000fe200010f4c1eULL,
0x000000ffff197224ULL, 0x000fe200020e06ffULL, 0x00005e0002187a11ULL, 0x000fe200078848ffULL,
0x00000001061f7824ULL, 0x040fe200078e021fULL, 0x00005f0017177a11ULL, 0x000fe200018f4c1cULL,
0x0000000106217824ULL, 0x000fe200078e0221ULL, 0x000000461d1d7210ULL, 0x080fe20007f5e0ffULL,
0x00000010223f7824ULL, 0x000fe200078e0249ULL, 0x00005f0002197a11ULL, 0x000fe200020f4c19ULL,
0x000000ffff037224ULL, 0x000fe200008e06ffULL, 0x00005e0000227a11ULL, 0x000fe200078248ffULL,
0x0000001026437824ULL, 0x100fe200078e0249ULL, 0x000000461f1f7210ULL, 0x080fe20007f7e0ffULL,
0x0000001024417824ULL, 0x000fe200078e0249ULL, 0x0000004621027210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff267224ULL, 0x000fe200010e06ffULL, 0x00005f0000237a11ULL, 0x000fe200008f4c03ULL,
0x000000ffff247224ULL, 0x000fe200018e06ffULL, 0x0000000705037812ULL, 0x000fe200078ec0ffULL,
0x0000000106257824ULL, 0x000fe200078e0225ULL, 0x00005e001d1c7a11ULL, 0x000fe200078448ffULL,
0x00000010203d7824ULL, 0x000fe200078e0249ULL, 0x00005e001f1e7a11ULL, 0x000fe200078648ffULL,
0x000000ffff217224ULL, 0x000fe200020e06ffULL, 0x00005e0002207a11ULL, 0x000fe200078848ffULL,
0x0000000106277824ULL, 0x040fe200078e0227ULL, 0x00000008034b7812ULL, 0x000fe200078efcffULL,
0x0000000106297824ULL, 0x040fe200078e0229ULL, 0x00005f001d1d7a11ULL, 0x000fe200010f4c26ULL,
0x00000001062b7824ULL, 0x000fe200078e022bULL, 0x00005f001f1f7a11ULL, 0x000fe200018f4c24ULL,
0x000000104b0c7825ULL, 0x000fe200078e000cULL, 0x0000004625257210ULL, 0x000fc40007f5e0ffULL,
0x00005f0002217a11ULL, 0x000fe200020f4c21ULL, 0x0000001028457824ULL, 0x100fe200078e0249ULL,
0x0000004627277210ULL, 0x080fe20007f7e0ffULL, 0x000000102a477824ULL, 0x000fe200078e0249ULL,
0x0000004629027210ULL, 0x080fe20007f9e0ffULL, 0x000000104b0e7825ULL, 0x000fe200078e000eULL,
0x000000462b007210ULL, 0x000fe20007f3e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c0b7faeULL, 0x0003e4000b901c46ULL, 0x000000102c497824ULL, 0x000fe400078e0249ULL,
0x000000ffff2e7224ULL, 0x000fe200010e06ffULL, 0x00005e0025247a11ULL, 0x000fe200078448ffULL,
0x000000104b107825ULL, 0x000fe200078e0010ULL, 0x000000000e2d7faeULL, 0x0005e4000b901c46ULL,
0x00005f0025257a11ULL, 0x000fe200010f4c2eULL, 0x000000ffff2c7224ULL, 0x000fe200018e06ffULL,
0x00005e0027267a11ULL, 0x000fe200078648ffULL, 0x000000104b127825ULL, 0x000fe200078e0012ULL,
0x00000000102f7faeULL, 0x0005e4000b901c46ULL, 0x00005f0027277a11ULL, 0x000fe200018f4c2cULL,
0x000000ffff297224ULL, 0x000fe200020e06ffULL, 0x00005e0002287a11ULL, 0x040fe200078848ffULL,
0x000000104b147825ULL, 0x040fe200078e0014ULL, 0x0000000012317faeULL, 0x0005e4000b901c46ULL,
0x00005f0002297a11ULL, 0x000fe200020f4c29ULL, 0x000000ffff2b7224ULL, 0x000fe200008e06ffULL,
0x00005e00002a7a11ULL, 0x040fe200078248ffULL, 0x000000104b167825ULL, 0x040fe200078e0016ULL,
0x0000000014337faeULL, 0x0005e4000b901c46ULL, 0x00005f00002b7a11ULL, 0x000fe200008f4c2bULL,
0x000000104b187825ULL, 0x040fe200078e0018ULL, 0x0000000016357faeULL, 0x0005e6000b901c46ULL,
0x000000104b1a7825ULL, 0x040fe200078e001aULL, 0x0000000018377faeULL, 0x0005e6000b901c46ULL,
0x000000104b1c7825ULL, 0x040fe200078e001cULL, 0x000000001a397faeULL, 0x0005e6000b901c46ULL,
0x000000104b1e7825ULL, 0x040fe200078e001eULL, 0x000000001c3b7faeULL, 0x0005e6000b901c46ULL,
0x000000104b207825ULL, 0x040fe200078e0020ULL, 0x000000001e3d7faeULL, 0x0005e6000b901c46ULL,
0x000000104b0c7825ULL, 0x042fe200078e0022ULL, 0x00000000203f7faeULL, 0x0005e6000b901c46ULL,
0x000000104b227825ULL, 0x040fe200078e0024ULL, 0x000000000c417faeULL, 0x0005e6000b901c46ULL,
0x000000104b247825ULL, 0x040fe200078e0026ULL, 0x0000000022437faeULL, 0x0005e6000b901c46ULL,
0x000000104b267825ULL, 0x040fe200078e0028ULL, 0x0000000024457faeULL, 0x0005e6000b901c46ULL,
0x000000104b287825ULL, 0x000fe200078e002aULL, 0x0000000026477faeULL, 0x0005e8000b901c46ULL,
0x0000000028497faeULL, 0x0005e4000b901c46ULL, 0x00000004ff0b7819ULL, 0x100fe20000011605ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000003ffd57819ULL, 0x100fe20000011605ULL,
0x000040000a567824ULL, 0x000fe200078e00ffULL, 0x0000000803027812ULL, 0x000fe200078ef805ULL,
0x000000080b007824ULL, 0x000fe200078e00ffULL, 0x00000001d5107812ULL, 0x006fc400078ec0ffULL,
0x0000200056a37810ULL, 0x000fe20007ffe0ffULL, 0x0000002002127824ULL, 0x000fe200078e00ffULL,
0xfffffff800297812ULL, 0x000fe200078ee203ULL, 0x0000000102007824ULL, 0x040fe400078e020bULL,
0x00000020020b7824ULL, 0x000fe200078e00ffULL, 0x00000030293b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000110387824ULL, 0x040fe200078e0229ULL, 0x0000001029397810ULL, 0x040fe20007ffe0ffULL,
0x0000000829d17824ULL, 0x000fe200078e00ffULL, 0xffffffe00b0b7812ULL, 0x000fe200078ee200ULL,
0x0000000110ce7824ULL, 0x000fe200078e023bULL, 0x0000000238cd7810ULL, 0x000fe20007ffe0ffULL,
0x000000083b197824ULL, 0x000fe200078e00ffULL, 0xfffffff8d1d17812ULL, 0x000fe200078ee238ULL,
0x000000100b0b7824ULL, 0x000fe200078e00ffULL, 0x0000000200117810ULL, 0x000fe20007ffe0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000010d1b87824ULL, 0x000fe200078e02a3ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000000b0c783bULL, 0x0003e20000000200ULL,
0x0000000829187824ULL, 0x000fe200078e00ffULL, 0xfffffff819ce7812ULL, 0x000fe200078ee2ceULL,
0x0000000110d07824ULL, 0x000fe200078e0239ULL, 0x00000000b814783bULL, 0x000ea20000000200ULL,
0x0000000839137824ULL, 0x000fe200078e00ffULL, 0xfffffff818cd7812ULL, 0x000fe200078ee2cdULL,
0x00000010cebb7824ULL, 0x000fe200078e02a3ULL, 0x00000020290b7810ULL, 0x042fe20007ffe0ffULL,
0x00000008293d7824ULL, 0x000fe200078e00ffULL, 0xffffffe012117812ULL, 0x000fe200078ee211ULL,
0x00000010cdbc7824ULL, 0x000fe200078e02a3ULL, 0x00000000bb20783bULL, 0x000e620000000200ULL,
0x0000000110cf7824ULL, 0x000fe200078e020bULL, 0xfffffff813d07812ULL, 0x000fe200078ee2d0ULL,
0x000000080b187824ULL, 0x000fe200078e00ffULL, 0x00000000bc1c783bULL, 0x000fe20000000200ULL,
0x0000001011247824ULL, 0x000fe200078e00ffULL, 0x0000002238cb7810ULL, 0x000fe20007ffe0ffULL,
0x00000010d0b97824ULL, 0x000fe200078e02a3ULL, 0xfffffff818cf7812ULL, 0x000fc400078ee2cfULL,
0x0000001238cc7810ULL, 0x040fe20007ffe0ffULL, 0x000000002424783bULL, 0x000ee20000000200ULL,
0x0000003238ca7810ULL, 0x040fe20007ffe0ffULL, 0x00000010cfba7824ULL, 0x000fe200078e02a3ULL,
0x0000000438777810ULL, 0x040fe20007ffe0ffULL, 0x00000000b910783bULL, 0x000fe20000000200ULL,
0x0000001438757810ULL, 0x040fe40007ffe0ffULL, 0x0000002438767810ULL, 0x040fe20007ffe0ffULL,
0x00000000ba2c783bULL, 0x000f220000000200ULL, 0x0000003438747810ULL, 0x000fc40007ffe0ffULL,
0x0000000638ac7810ULL, 0x040fe40007ffe0ffULL, 0x0000001638ab7810ULL, 0x040fe40007ffe0ffULL,
0x0000002638aa7810ULL, 0x040fe40007ffe0ffULL, 0x0000003638b07810ULL, 0x000fe40007ffe0ffULL,
0xfffffff83dac7812ULL, 0x000fe200078ee2acULL, 0x000000140c80723cULL, 0x004b6800000418ffULL,
0x00000010acc97824ULL, 0x000fc600078e02a3ULL, 0x000000080b147824ULL, 0x020fe200078e00ffULL,
0x000000160c30723cULL, 0x040b6200000418ffULL, 0x0000000839157824ULL, 0x000fe200078e00ffULL,
0x00000000c964783bULL, 0x000fe40000000200ULL, 0xfffffff814cb7812ULL, 0x000fe400078ee2cbULL,
0xfffffff815cc7812ULL, 0x000fe400078ee2ccULL, 0x000000200c50723cULL, 0x002be200000418ffULL,
0x00000010cbbf7824ULL, 0x000fc400078e02a3ULL, 0x00000010ccbe7824ULL, 0x000fc600078e02a3ULL,
0x00000000bf14783bULL, 0x020e620000000200ULL, 0x000000083b217824ULL, 0x000fe200078e00ffULL,
0x0000001c2480723cULL, 0x008fe20000041880ULL, 0x0000000400207810ULL, 0x000fe20007ffe0ffULL,
0x00000000be18783bULL, 0x000ea40000000200ULL, 0xfffffff821ca7812ULL, 0x000fe200078ee2caULL,
0x0000002002217824ULL, 0x000fc600078e00ffULL, 0x0000002c0c48723cULL, 0x010f6200000418ffULL,
0x00000010cac07824ULL, 0x000fe200078e02a3ULL, 0xffffffe021207812ULL, 0x000fe200078ee220ULL,
0x000000083b217824ULL, 0x040fe400078e00ffULL, 0x000000083b3b7824ULL, 0x000fe200078e00ffULL,
0x00000000c034783bULL, 0x000ee40000000200ULL, 0x0000001e241c723cULL, 0x000fe20000041830ULL,
0xfffffff821747812ULL, 0x000fe200078ee274ULL, 0x0000002002217824ULL, 0x000fe200078e00ffULL,
0xfffffff83bb07812ULL, 0x000fc600078ee2b0ULL, 0x0000001074c87824ULL, 0x100fe400078e02a3ULL,
0x000000100c40723cULL, 0x000f6200000418ffULL, 0x00000010b0d47824ULL, 0x000fce00078e02a3ULL,
0x000000120c30723cULL, 0x040ff000000418ffULL, 0x0000002e0c10723cULL, 0x040f7000000418ffULL,
0x000000220c0c723cULL, 0x000b6e00000418ffULL, 0x0000000839227824ULL, 0x020fe200078e00ffULL,
0x000000142448723cULL, 0x002be80000041848ULL, 0xfffffff822757812ULL, 0x000fc600078ee275ULL,
0x0000000829147824ULL, 0x020fe200078e00ffULL, 0x000000182440723cULL, 0x044f620000041840ULL,
0x000000080b157824ULL, 0x000fe400078e00ffULL, 0x0000001075c27824ULL, 0x000fe200078e02a3ULL,
0xfffffff814777812ULL, 0x000fe200078ee277ULL, 0x000000080b0b7824ULL, 0x000fe200078e00ffULL,
0xfffffff815767812ULL, 0x000fe400078ee276ULL, 0x000000162414723cULL, 0x000be20000041810ULL,
0x0000001077c17824ULL, 0x100fe200078e02a3ULL, 0x00000000c22c783bULL, 0x000fe20000000200ULL,
0x0000001076c77824ULL, 0x000fe200078e02a3ULL, 0xfffffff80baa7812ULL, 0x000fc600078ee2aaULL,
0x0000001020107824ULL, 0x020fe200078e00ffULL, 0x0000000600207810ULL, 0x000fe20007ffe0ffULL,
0x0000001a2418723cULL, 0x040b620000041830ULL, 0x00000000c728783bULL, 0x000fe20000000200ULL,
0x00000010aad37824ULL, 0x000fe200078e02a3ULL, 0xffffffe0213a7812ULL, 0x000fe400078ee220ULL,
0x000000001010783bULL, 0x000e660000000200ULL, 0x000000342450723cULL, 0x008b640000041850ULL,
0x00000000c130783bULL, 0x020ea20000000200ULL, 0x000000103a3a7824ULL, 0x000fc600078e00ffULL,
0x00000000c820783bULL, 0x000ee20000000200ULL, 0x0000000839347824ULL, 0x000fe200078e00ffULL,
0x000000362424723cULL, 0x000b64000004180cULL, 0x000000003a5c783bULL, 0x000f240000000200ULL,
0xfffffff834ab7812ULL, 0x000fe400078ee2abULL, 0x00000000d360783bULL, 0x000fe60000000200ULL,
0x00000010abd27824ULL, 0x000fe200078e02a3ULL, 0x00000000d40c783bULL, 0x020fe80000000200ULL,
0x00000000d23c783bULL, 0x000ee20000000200ULL, 0x0000002c1040723cULL, 0x042ff00000041840ULL,
0x000000301080723cULL, 0x044f700000041880ULL, 0x000000281048723cULL, 0x040f700000041848ULL,
0x00000032101c723cULL, 0x040f70000004181cULL, 0x0000002e1018723cULL, 0x040f700000041818ULL,
0x0000002a1014723cULL, 0x040f700000041814ULL, 0x000000201050723cULL, 0x048f700000041850ULL,
0x000000221010723cULL, 0x000f700000041824ULL, 0x000000645c80723cULL, 0x070b700000041880ULL,
0x0000003c5c40723cULL, 0x040b700000041840ULL, 0x000000605c48723cULL, 0x040b700000041848ULL,
0x000000665c64723cULL, 0x040b70000004181cULL, 0x0000003e5c3c723cULL, 0x040b700000041818ULL,
0x000000625c60723cULL, 0x040b700000041814ULL, 0x0000000c5c50723cULL, 0x040b700000041850ULL,
0x0000000e5c5c723cULL, 0x000b620000041810ULL, 0x00000d4000008947ULL, 0x000fce0003800000ULL,
0x00000008d50c7810ULL, 0x060fe20007ffe0ffULL, 0x00000001d50e7824ULL, 0x040fe200078e0205ULL,
0x00000004d50b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000106a27824ULL, 0x000fe200078e02d5ULL,
0x0000000cd50d7810ULL, 0x000fe20007ffe0ffULL, 0x000000010c9d7824ULL, 0x140fe200078e0205ULL,
0x00000007a1a17812ULL, 0x000fe200078ef80eULL, 0x000000080c127824ULL, 0x000fe200078e00ffULL,
0x00000010d50e7810ULL, 0x000fe20007ffe0ffULL, 0x000000010b9f7824ULL, 0x000fe200078e0205ULL,
0x00000014d50f7810ULL, 0x000fe20007ffe0ffULL, 0x000000080b107824ULL, 0x000fe200078e00ffULL,
0xfffffff8129d7812ULL, 0x000fe200078ee29dULL, 0x000000010e997824ULL, 0x040fe200078e0205ULL,
0x0000001cd5117810ULL, 0x000fe20007ffe0ffULL, 0x000000080e127824ULL, 0x000fe200078e00ffULL,
0xfffffff8109f7812ULL, 0x000fe200078ee29fULL, 0x000000010d9b7824ULL, 0x040fe200078e0205ULL,
0x00000046a2157210ULL, 0x080fe20007f3e0ffULL, 0x000000080d107824ULL, 0x000fe200078e00ffULL,
0xfffffff812997812ULL, 0x000fe200078ee299ULL, 0x000000010f977824ULL, 0x000fe200078e0205ULL,
0x00000020d5127810ULL, 0x000fe20007ffe0ffULL, 0x000000080f147824ULL, 0x000fe200078e00ffULL,
0xfffffff8109b7812ULL, 0x000fe200078ee29bULL, 0x0000000106a07824ULL, 0x000fe200078e020bULL,
0x00000018d5107810ULL, 0x000fe20007ffe0ffULL, 0x0000000111937824ULL, 0x040fe200078e0205ULL,
0xfffffff814977812ULL, 0x000fe200078ee297ULL, 0x0000000811167824ULL, 0x000fe200078e00ffULL,
0x00000046a0177210ULL, 0x080fe20007f5e0ffULL, 0x0000000112917824ULL, 0x040fe200078e0205ULL,
0x00000024d5137810ULL, 0x000fe20007ffe0ffULL, 0x0000000812187824ULL, 0x000fe200078e00ffULL,
0xfffffff816937812ULL, 0x000fe200078ee293ULL, 0x0000000110957824ULL, 0x040fe200078e0205ULL,
0x0000001003557812ULL, 0x000fe200078efcffULL, 0x0000000810147824ULL, 0x000fe200078e00ffULL,
0xfffffff818917812ULL, 0x000fe200078ee291ULL, 0x000000ffff167224ULL, 0x000fe200008e06ffULL,
0x00005e0015207a11ULL, 0x000fe200078248ffULL, 0x000000ffff187224ULL, 0x000fe200010e06ffULL,
0xfffffff814957812ULL, 0x000fe200078ee295ULL, 0x00000001069e7824ULL, 0x040fe200078e020cULL,
0x00005e0017227a11ULL, 0x000fe200078448ffULL, 0x0000000106987824ULL, 0x040fe200078e020fULL,
0x00000028d5147810ULL, 0x000fe20007ffe0ffULL, 0x00000001069c7824ULL, 0x040fe200078e020dULL,
0x00005f0015217a11ULL, 0x000fe200008f4c16ULL, 0x00000001069a7824ULL, 0x000fe200078e020eULL,
0x00005f0017237a11ULL, 0x000fe200010f4c18ULL, 0x00000001148d7824ULL, 0x000fe200078e0205ULL,
0x000000469e157210ULL, 0x080fe20007f5e0ffULL, 0x00000008141c7824ULL, 0x000fe200078e00ffULL,
0x00000046981b7210ULL, 0x080fe20007f3e0ffULL, 0x0000000106967824ULL, 0x000fe200078e0210ULL,
0x000000469c177210ULL, 0x080fe20007f7e0ffULL, 0x000000ffff167224ULL, 0x000fe200010e06ffULL,
0xfffffff81c8d7812ULL, 0x000fe200078ee28dULL, 0x000000ffff1c7224ULL, 0x000fe200008e06ffULL,
0x00005e0015247a11ULL, 0x000fe200078448ffULL, 0x000000ffff187224ULL, 0x000fe200018e06ffULL,
0x00005e001b2a7a11ULL, 0x000fe200078248ffULL, 0x0000000106907824ULL, 0x000fe200078e0213ULL,
0x00005e0017267a11ULL, 0x000fe200078648ffULL, 0x00000001138f7824ULL, 0x040fe200078e0205ULL,
0x000000469a197210ULL, 0x080fe20007f9e0ffULL, 0x00000008131a7824ULL, 0x000fe200078e00ffULL,
0x00005f0015257a11ULL, 0x000fe200010f4c16ULL, 0x0000000106947824ULL, 0x000fe200078e0211ULL,
0x0000004696157210ULL, 0x000fe20007f5e0ffULL, 0x0000000106927824ULL, 0x000fe200078e0212ULL,
0x00005f001b2b7a11ULL, 0x000fe200008f4c1cULL, 0x00000001084c7824ULL, 0x000fe200078e0a04ULL,
0x00005f0017277a11ULL, 0x000fe200018f4c18ULL, 0x000000ffff167224ULL, 0x000fe200010e06ffULL,
0x00000090461b7210ULL, 0x000fe20007f3e0ffULL, 0x00000001068e7824ULL, 0x000fe200078e0214ULL,
0xfffffff81a8f7812ULL, 0x000fe200078ee28fULL, 0x000000ffff1a7224ULL, 0x000fe200020e06ffULL,
0x0000004694177210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff1c7224ULL, 0x000fe200008e06ffULL,
0x00005e0019287a11ULL, 0x000fe200078848ffULL, 0x00000010a1b67824ULL, 0x100fe200078e02a3ULL,
0x00005e00152c7a11ULL, 0x000fe200078448ffULL, 0x000000ffff187224ULL, 0x000fe200018e06ffULL,
0x00005e001b327a11ULL, 0x000fe200078248ffULL, 0x000000109fb57824ULL, 0x100fe200078e02a3ULL,
0x00005f0019297a11ULL, 0x000fe200020f4c1aULL, 0x000000109db47824ULL, 0x100fe200078e02a3ULL,
0x00005e00172e7a11ULL, 0x000fe200078648ffULL, 0x000000109bb37824ULL, 0x100fe200078e02a3ULL,
0x0000009246197210ULL, 0x000fe20007f9e0ffULL, 0x0000001099b27824ULL, 0x100fe200078e02a3ULL,
0x00005f00152d7a11ULL, 0x000fe200010f4c16ULL, 0x0000001097b17824ULL, 0x100fe200078e02a3ULL,
0x00000030d5167810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff1a7224ULL, 0x000fe200020e06ffULL,
0x00005f001b337a11ULL, 0x000fe200008f4c1cULL, 0x0000001095af7824ULL, 0x100fe200078e02a3ULL,
0x00005f00172f7a11ULL, 0x000fe200018f4c18ULL, 0x00000001068a7824ULL, 0x040fe200078e0216ULL,
0x0000004cd500720cULL, 0x000fe20003f26070ULL, 0x0000001093ae7824ULL, 0x100fe200078e02a3ULL,
0x00000034d5177810ULL, 0x000fe20007ffe0ffULL, 0x0000001091ad7824ULL, 0x100fe200078e02a3ULL,
0x00005e0019307a11ULL, 0x000fe200078848ffULL, 0x000000108fa97824ULL, 0x000fe200078e02a3ULL,
0x0000002cd5157810ULL, 0x000fe20007ffe0ffULL, 0x0000000106887824ULL, 0x000fe200078e0217ULL,
0x00005f0019317a11ULL, 0x000fe200020f4c1aULL, 0x0000001055187825ULL, 0x000fe200078e0020ULL,
0x0000008a461e7210ULL, 0x000fc40007f5e0ffULL, 0x00000088463b7210ULL, 0x000fe20007f7e0ffULL,
0x00000001068c7824ULL, 0x000fe200078e0215ULL, 0x0000008e461a7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff1f7224ULL, 0x000fe200010e06ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018b67faeULL, 0x0003e2000c901c46ULL, 0x00005e001e387a11ULL, 0x000fe200078448ffULL,
0x000000ffff447224ULL, 0x000fe200018e06ffULL, 0x0000008c461c7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff1b7224ULL, 0x000fe200020e06ffULL, 0x0000004c0b00720cULL, 0x000fe20003f26070ULL,
0x000000108da87824ULL, 0x000fe200078e02a3ULL, 0x00005e003b3a7a11ULL, 0x000fe200078648ffULL,
0x000000ffff1d7224ULL, 0x000fe200028e06ffULL, 0x00005e001a347a11ULL, 0x000fe200078848ffULL,
0x00000001158b7824ULL, 0x000fe200078e0205ULL, 0x00005f001e397a11ULL, 0x000fe200010f4c1fULL,
0x0000001055187825ULL, 0x002fe200078e0022ULL, 0x00005e001c367a11ULL, 0x000fc400078a48ffULL,
0x0000004c0c00720cULL, 0x080fe20003f46070ULL, 0x00000010551e7825ULL, 0x000fe200078e0028ULL,
0x00005f003b3b7a11ULL, 0x000fe200018f4c44ULL, 0x0000000018b57faeULL, 0x0003e2000c901c46ULL,
0x00005f001a357a11ULL, 0x000fe200020f4c1bULL, 0x00000010551a7825ULL, 0x000fe200078e0024ULL,
0x0000004c0d00720cULL, 0x080fe40003f66070ULL, 0x00005f001c377a11ULL, 0x000fe200028f4c1dULL,
0x00000010551c7825ULL, 0x000fe200078e0026ULL, 0x0000004c0e00720cULL, 0x000fc40003f86070ULL,
0x0000004c0f00720cULL, 0x080fe20003fa6070ULL, 0x0000001055447825ULL, 0x000fe200078e002aULL,
0x0000004c1000720cULL, 0x080fe20003f26070ULL, 0x000000001ab47faeULL, 0x0005e2000d101c46ULL,
0x0000004c1100720cULL, 0x080fe20003f46070ULL, 0x0000001055187825ULL, 0x002fe400078e002cULL,
0x000000001cb37faeULL, 0x0003e2000d901c46ULL, 0x0000004c1200720cULL, 0x080fe20003f66070ULL,
0x0000000116897824ULL, 0x000fe400078e0205ULL, 0x000000001eb27faeULL, 0x0007e2000e101c46ULL,
0x0000004c1300720cULL, 0x000fc60003f86070ULL, 0x0000000044b17faeULL, 0x0009e2000e901c46ULL,
0x0000004c1400720cULL, 0x080fe20003fa6070ULL, 0x00000010551a7825ULL, 0x044fe400078e002eULL,
0x0000000018af7faeULL, 0x0005e4000c901c46ULL, 0x00000010551c7825ULL, 0x002fe400078e0030ULL,
0x000000001aae7faeULL, 0x0003e2000d101c46ULL, 0x0000004c1700720cULL, 0x000fe20003f46070ULL,
0x00000010551e7825ULL, 0x008fc400078e0032ULL, 0x000000001cad7faeULL, 0x0007e2000d901c46ULL,
0x0000004c1600720cULL, 0x080fe20003f66070ULL, 0x0000001055447825ULL, 0x010fe200078e0034ULL,
0x00000038d5187810ULL, 0x044fe20007ffe0ffULL, 0x000000001ea97faeULL, 0x0005e2000e101c46ULL,
0x0000003cd5197810ULL, 0x000fe40007ffe0ffULL, 0x0000004c1500720cULL, 0x080fe20003f86070ULL,
0x00000001061a7824ULL, 0x002fe200078e0218ULL, 0x0000000044a87faeULL, 0x0003e2000e901c46ULL,
0x0000000818477824ULL, 0x040fe200078e00ffULL, 0x0000004c1800720cULL, 0x000fe20003f26070ULL,
0x00000001191d7824ULL, 0x008fe200078e0205ULL, 0x0000001a461b7210ULL, 0x000fe20007fbe0ffULL,
0x00000008151e7824ULL, 0x004fc600078e00ffULL, 0x00005e001b847a11ULL, 0x000fe200078c48ffULL,
0x000000ffff1c7224ULL, 0x000fe200028e06ffULL, 0x0000004c1900720cULL, 0x000fe20003fa6070ULL,
0x00000001171f7824ULL, 0x000fe200078e0205ULL, 0xfffffff81e8b7812ULL, 0x000fe200078ee28bULL,
0x0000000816447824ULL, 0x002fe200078e00ffULL, 0x00005f001b857a11ULL, 0x000fe200030f4c1cULL,
0x00000001061b7824ULL, 0x000fe400078e0219ULL, 0x00000008171e7824ULL, 0x000fe200078e00ffULL,
0xfffffff844897812ULL, 0x000fe200078ee289ULL, 0x00000001181c7824ULL, 0x000fe200078e0205ULL,
0x0000001b46467210ULL, 0x000fe20007fde0ffULL, 0x0000000819447824ULL, 0x000fe200078e00ffULL,
0xfffffff81e1f7812ULL, 0x000fe200078ee21fULL, 0x000000108ba77824ULL, 0x100fe200078e02a3ULL,
0xfffffff8471c7812ULL, 0x000fe200078ee21cULL, 0x000000ffff457224ULL, 0x000fe200030e06ffULL,
0x00005e0046867a11ULL, 0x000fe200078c48ffULL, 0x0000001089a67824ULL, 0x000fe200078e02a3ULL,
0xfffffff8441d7812ULL, 0x000fe200078ee21dULL, 0x000000101fa57824ULL, 0x000fe200078e02a3ULL,
0x00005f0046877a11ULL, 0x000fe200030f4c45ULL, 0x0000001055447825ULL, 0x000fc800078e0036ULL,
0x0000001055467825ULL, 0x040fe200078e0038ULL, 0x0000000044a77faeULL, 0x0003e6000e101c46ULL,
0x00000010554c7825ULL, 0x040fe200078e003aULL, 0x0000000046a67faeULL, 0x0003e6000d901c46ULL,
0x000000101ca47824ULL, 0x000fe200078e02a3ULL, 0x000000004ca57faeULL, 0x0003e2000d101c46ULL,
0x00000010554e7825ULL, 0x000fc800078e0084ULL, 0x000000101da37824ULL, 0x000fe200078e02a3ULL,
0x000000004ea47faeULL, 0x0003e2000c901c46ULL, 0x0000001055547825ULL, 0x000fca00078e0086ULL,
0x0000000054a37faeULL, 0x0003e2000e901c46ULL, 0x00000c2000007947ULL, 0x000fea0003800000ULL,
0x00000001d50e7824ULL, 0x060fe200078e0205ULL, 0x00000004d50b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000106a27824ULL, 0x000fe200078e02d5ULL, 0x00000008d50c7810ULL, 0x000fe40007ffe0ffULL,
0x00000007a1a17812ULL, 0x000fe200078ef80eULL, 0x000000010b9f7824ULL, 0x100fe200078e0205ULL,
0x0000000cd50d7810ULL, 0x000fe20007ffe0ffULL, 0x000000080b0e7824ULL, 0x000fe200078e00ffULL,
0x00000014d50f7810ULL, 0x040fe20007ffe0ffULL, 0x000000010c9d7824ULL, 0x040fe200078e0205ULL,
0x0000001cd5117810ULL, 0x000fe20007ffe0ffULL, 0x000000080c107824ULL, 0x000fe200078e00ffULL,
0xfffffff80e9f7812ULL, 0x000fe200078ee29fULL, 0x000000010d9b7824ULL, 0x000fe200078e0205ULL,
0x00000010d50e7810ULL, 0x000fe20007ffe0ffULL, 0x000000080d127824ULL, 0x000fe200078e00ffULL,
0xfffffff8109d7812ULL, 0x000fe200078ee29dULL, 0x000000010f977824ULL, 0x100fe200078e0205ULL,
0x00000018d5107810ULL, 0x040fe20007ffe0ffULL, 0x000000010e997824ULL, 0x000fe200078e0205ULL,
0xfffffff8129b7812ULL, 0x000fe200078ee29bULL, 0x000000080e127824ULL, 0x000fe200078e00ffULL,
0x00000024d5137810ULL, 0x000fe20007ffe0ffULL, 0x000000080f147824ULL, 0x000fe200078e00ffULL,
0x0000002cd5157810ULL, 0x000fe20007ffe0ffULL, 0x0000000110957824ULL, 0x000fe200078e0205ULL,
0xfffffff812997812ULL, 0x000fe200078ee299ULL, 0x0000000810167824ULL, 0x000fe200078e00ffULL,
0xfffffff814977812ULL, 0x000fe200078ee297ULL, 0x0000000111937824ULL, 0x000fe200078e0205ULL,
0x00000020d5127810ULL, 0x000fe20007ffe0ffULL, 0x0000000811147824ULL, 0x000fe200078e00ffULL,
0xfffffff816957812ULL, 0x000fe200078ee295ULL, 0x00000001138f7824ULL, 0x100fe200078e0205ULL,
0x00000034d5177810ULL, 0x040fe20007ffe0ffULL, 0x0000000112917824ULL, 0x000fe200078e0205ULL,
0xfffffff814937812ULL, 0x000fe200078ee293ULL, 0x0000000812167824ULL, 0x000fe200078e00ffULL,
0x00000028d5147810ULL, 0x000fe20007ffe0ffULL, 0x0000000813187824ULL, 0x000fe200078e00ffULL,
0x0000003cd5197810ULL, 0x000fe20007ffe0ffULL, 0x00000001158b7824ULL, 0x000fe200078e0205ULL,
0xfffffff816917812ULL, 0x000fe200078ee291ULL, 0x00000001148d7824ULL, 0x000fe200078e0205ULL,
0xfffffff8188f7812ULL, 0x000fe200078ee28fULL, 0x0000000814187824ULL, 0x000fe200078e00ffULL,
0x00000030d5167810ULL, 0x000fe20007ffe0ffULL, 0x00000008151a7824ULL, 0x000fe200078e00ffULL,
0x0000001003577812ULL, 0x000fe200078efcffULL, 0x00000001171f7824ULL, 0x000fe200078e0205ULL,
0xfffffff8188d7812ULL, 0x000fe200078ee28dULL, 0x0000000116897824ULL, 0x000fe200078e0205ULL,
0xfffffff81a8b7812ULL, 0x000fe200078ee28bULL, 0x00000008161c7824ULL, 0x000fe200078e00ffULL,
0x00000038d5187810ULL, 0x000fe20007ffe0ffULL, 0x00000008171a7824ULL, 0x000fc400078e00ffULL,
0x00000001191d7824ULL, 0x040fe200078e0205ULL, 0xfffffff81c897812ULL, 0x000fe200078ee289ULL,
0x00000008191e7824ULL, 0x000fe200078e00ffULL, 0xfffffff81a1f7812ULL, 0x000fe200078ee21fULL,
0x0000000106a07824ULL, 0x000fe200078e020bULL, 0x00000046a21a7210ULL, 0x080fe20007f3e0ffULL,
0x00000001181c7824ULL, 0x000fe200078e0205ULL, 0xfffffff81e1d7812ULL, 0x000fe200078ee21dULL,
0x00000008181b7824ULL, 0x000fe200078e00ffULL, 0x00000046a01e7210ULL, 0x000fe20007f5e0ffULL,
0x00000001069e7824ULL, 0x000fc400078e020cULL, 0x00000001069c7824ULL, 0x000fe200078e020dULL,
0xfffffff81b1c7812ULL, 0x000fe200078ee21cULL, 0x000000ffff1b7224ULL, 0x000fe200008e06ffULL,
0x000000469e257210ULL, 0x080fe20007f7e0ffULL, 0x000000ffff237224ULL, 0x000fe200010e06ffULL,
0x000000469c277210ULL, 0x080fe20007f9e0ffULL, 0x00000001069a7824ULL, 0x000fe200078e020eULL,
0x00005e001a207a11ULL, 0x000fe200078248ffULL, 0x000000ffff287224ULL, 0x000fe200018e06ffULL,
0x00005e001e227a11ULL, 0x000fe200078448ffULL, 0x000000ffff2a7224ULL, 0x000fe200020e06ffULL,
0x00005f001a217a11ULL, 0x000fe200008f4c1bULL, 0x0000000106987824ULL, 0x000fe200078e020fULL,
0x00005f001e237a11ULL, 0x000fe200010f4c23ULL, 0x0000000106967824ULL, 0x040fe200078e0210ULL,
0x00005e0025247a11ULL, 0x000fe200078648ffULL, 0x0000000106947824ULL, 0x040fe200078e0211ULL,
0x00005e0027267a11ULL, 0x000fe200078848ffULL, 0x0000000106927824ULL, 0x000fe200078e0212ULL,
0x000000469a1a7210ULL, 0x080fe20007f5e0ffULL, 0x0000000106907824ULL, 0x040fe200078e0213ULL,
0x00005f0025257a11ULL, 0x000fe200018f4c28ULL, 0x00000001068e7824ULL, 0x000fe200078e0214ULL,
0x00005f0027277a11ULL, 0x000fe200020f4c2aULL, 0x000000ffff1b7224ULL, 0x000fe200010e06ffULL,
0x00000046981e7210ULL, 0x080fe20007f7e0ffULL, 0x00000001068c7824ULL, 0x000fe200078e0215ULL,
0x00000046962d7210ULL, 0x080fe20007f9e0ffULL, 0x0000000106887824ULL, 0x000fe200078e0217ULL,
0x00000046942f7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff2b7224ULL, 0x000fe200018e06ffULL,
0x00005e001a287a11ULL, 0x000fe200078448ffULL, 0x000000ffff307224ULL, 0x000fe200020e06ffULL,
0x00005e001e2a7a11ULL, 0x000fe200078648ffULL, 0x000000ffff327224ULL, 0x000fe200008e06ffULL,
0x00005f001a297a11ULL, 0x000fe200010f4c1bULL, 0x00000001068a7824ULL, 0x000fe200078e0216ULL,
0x00005e002d2c7a11ULL, 0x000fe200078848ffULL, 0x00000010a1b67824ULL, 0x000fe200078e02a3ULL,
0x00000092461a7210ULL, 0x000fe20007f5e0ffULL, 0x0000001057447825ULL, 0x000fe200078e0020ULL,
0x00005e002f2e7a11ULL, 0x000fc400078248ffULL, 0x00005f001e2b7a11ULL, 0x000fe200018f4c2bULL,
0x000000ffff1b7224ULL, 0x000fe200010e06ffULL, 0x00005f002d2d7a11ULL, 0x000fe200020f4c30ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000044b67faeULL, 0x0003e2000b901c46ULL,
0x00005f002f2f7a11ULL, 0x000fe200008f4c32ULL, 0x000000109fb57824ULL, 0x100fe200078e02a3ULL,
0x00000090461e7210ULL, 0x040fe20007f7e0ffULL, 0x000000109db47824ULL, 0x100fe200078e02a3ULL,
0x0000008e46357210ULL, 0x040fe20007f9e0ffULL, 0x000000109bb37824ULL, 0x000fe200078e02a3ULL,
0x0000008c46377210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff337224ULL, 0x000fe200018e06ffULL,
0x00005e001a307a11ULL, 0x000fe200078448ffULL, 0x000000ffff387224ULL, 0x000fe200020e06ffULL,
0x00005e001e327a11ULL, 0x000fe200078648ffULL, 0x000000ffff3a7224ULL, 0x000fe200008e06ffULL,
0x00005f001a317a11ULL, 0x000fe200010f4c1bULL, 0x00000001061a7824ULL, 0x040fe200078e0218ULL,
0x00005e0035347a11ULL, 0x000fe200078848ffULL, 0x00000001061b7824ULL, 0x000fe200078e0219ULL,
0x00005e0037367a11ULL, 0x000fe200078248ffULL, 0x0000001057447825ULL, 0x002fe200078e0022ULL,
0x00005f001e337a11ULL, 0x000fc400018f4c33ULL, 0x00005f0035357a11ULL, 0x000fe200020f4c38ULL,
0x0000001099b27824ULL, 0x100fe200078e02a3ULL, 0x00005f0037377a11ULL, 0x000fe200008f4c3aULL,
0x0000001097b17824ULL, 0x000fe200078e02a3ULL, 0x00000088463b7210ULL, 0x040fe20007f7e0ffULL,
0x0000001057547825ULL, 0x000fe200078e002aULL, 0x0000001a46477210ULL, 0x040fe20007f9e0ffULL,
0x0000000044b57faeULL, 0x0003e2000b901c46ULL, 0x0000001b464d7210ULL, 0x040fe20007f3e0ffULL,
0x0000001095af7824ULL, 0x000fe200078e02a3ULL, 0x0000008a461e7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff467224ULL, 0x000fe200018e06ffULL, 0x00005e003b3a7a11ULL, 0x000fe200078648ffULL,
0x000000ffff4c7224ULL, 0x000fe200020e06ffULL, 0x00005e0047847a11ULL, 0x000fe200078848ffULL,
0x000000ffff4e7224ULL, 0x000fe200008e06ffULL, 0x00005e004d867a11ULL, 0x000fe200078248ffULL,
0x000000ffff397224ULL, 0x000fe200010e06ffULL, 0x00005f003b3b7a11ULL, 0x000fe200018f4c46ULL,
0x0000001057447825ULL, 0x002fe200078e002cULL, 0x00005f0047857a11ULL, 0x000fc400020f4c4cULL,
0x00005f004d877a11ULL, 0x000fe200008f4c4eULL, 0x0000001057467825ULL, 0x000fe200078e0024ULL,
0x00005e001e387a11ULL, 0x000fc600078448ffULL, 0x00000010574c7825ULL, 0x040fe200078e0026ULL,
0x0000000046b47faeULL, 0x0003e2000b901c46ULL, 0x00005f001e397a11ULL, 0x000fe400010f4c39ULL,
0x00000010574e7825ULL, 0x000fe200078e0028ULL, 0x000000004cb37faeULL, 0x0005e6000b901c46ULL,
0x0000001093ae7824ULL, 0x100fe200078e02a3ULL, 0x000000004eb27faeULL, 0x0007e2000b901c46ULL,
0x0000001091ad7824ULL, 0x000fc400078e02a3ULL, 0x000000108fa97824ULL, 0x000fe200078e02a3ULL,
0x0000000054b17faeULL, 0x0009e2000b901c46ULL, 0x0000001057467825ULL, 0x002fc600078e002eULL,
0x0000000044af7faeULL, 0x0003e2000b901c46ULL, 0x00000010574c7825ULL, 0x004fc600078e0030ULL,
0x0000000046ae7faeULL, 0x0005e2000b901c46ULL, 0x00000010574e7825ULL, 0x008fc600078e0032ULL,
0x000000004cad7faeULL, 0x0007e2000b901c46ULL, 0x000000108da87824ULL, 0x000fe400078e02a3ULL,
0x0000001057547825ULL, 0x010fe200078e0034ULL, 0x000000004ea97faeULL, 0x0009e6000b901c46ULL,
0x000000108ba77824ULL, 0x000fe200078e02a3ULL, 0x0000000054a87faeULL, 0x0007e2000b901c46ULL,
0x0000001057447825ULL, 0x002fc800078e0036ULL, 0x0000001089a67824ULL, 0x000fe200078e02a3ULL,
0x0000000044a77faeULL, 0x0003e2000b901c46ULL, 0x0000001057467825ULL, 0x004fc800078e0038ULL,
0x000000101fa57824ULL, 0x000fe200078e02a3ULL, 0x0000000046a67faeULL, 0x0003e2000b901c46ULL,
0x00000010574c7825ULL, 0x008fc800078e003aULL, 0x000000101ca47824ULL, 0x000fe200078e02a3ULL,
0x000000004ca57faeULL, 0x0003e2000b901c46ULL, 0x00000010574e7825ULL, 0x010fc800078e0084ULL,
0x000000101da37824ULL, 0x000fe200078e02a3ULL, 0x000000004ea47faeULL, 0x0003e2000b901c46ULL,
0x0000001057547825ULL, 0x000fca00078e0086ULL, 0x0000000054a37faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000002002457824ULL, 0x002fe200078e00ffULL,
0x0000000800447810ULL, 0x000fe20007ffe0ffULL, 0x0000002002467824ULL, 0x000fe200078e00ffULL,
0x00004000561e7810ULL, 0x000fe40007ffe0ffULL, 0xffffffe045447812ULL, 0x000fe400078ee244ULL,
0x0000000a00457810ULL, 0x000fe20007ffe0ffULL, 0x00000010d1d17824ULL, 0x100fe400078e021eULL,
0x0000001044447824ULL, 0x000fe200078e00ffULL, 0xffffffe046457812ULL, 0x000fe200078ee245ULL,
0x00000010d0d07824ULL, 0x000fc400078e021eULL, 0x00000010cfcf7824ULL, 0x100fe400078e021eULL,
0x0000001045547824ULL, 0x000fe400078e00ffULL, 0x00000010cdcd7824ULL, 0x100fe400078e021eULL,
0x00000010cece7824ULL, 0x100fe400078e021eULL, 0x00000010cccc7824ULL, 0x000fe200078e021eULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000000d14c783bULL, 0x000fe20000000200ULL,
0x00000010cbcb7824ULL, 0x100fe400078e021eULL, 0x00000010caca7824ULL, 0x100fe200078e021eULL,
0x000000004468783bULL, 0x000e620000000200ULL, 0x0000001077c67824ULL, 0x100fe400078e021eULL,
0x0000001075c57824ULL, 0x100fe200078e021eULL, 0x00000000d070783bULL, 0x000ea20000000200ULL,
0x0000001076c47824ULL, 0x100fe400078e021eULL, 0x0000001074c37824ULL, 0x100fe200078e021eULL,
0x00000000cf58783bULL, 0x000ee20000000200ULL, 0x00000010acac7824ULL, 0x000fc400078e021eULL,
0x00000010abab7824ULL, 0x100fe200078e021eULL, 0x00000000cd7c783bULL, 0x000fe20000000200ULL,
0x00000010aaaa7824ULL, 0x100fe400078e021eULL, 0x00000010b0b07824ULL, 0x000fe200078e021eULL,
0x000000005454783bULL, 0x000f280000000200ULL, 0x00000000ce6c783bULL, 0x000ee80000000200ULL,
0x00000000cc44783bULL, 0x000ee80000000200ULL, 0x00000000c578783bULL, 0x000fe80000000200ULL,
0x00000000c474783bULL, 0x000fe20000000200ULL, 0x0000004c6880723cULL, 0x042f700000041880ULL,
0x0000004e6864723cULL, 0x040b640000041864ULL, 0x00000000cb4c783bULL, 0x020e6c0000000200ULL,
0x000000706840723cULL, 0x044f700000041840ULL, 0x000000586848723cULL, 0x048ff00000041848ULL,
0x0000005a6860723cULL, 0x040be40000041860ULL, 0x00000000ca58783bULL, 0x020eac0000000200ULL,
0x00000072683c723cULL, 0x000b64000004183cULL, 0x00000000c370783bULL, 0x020fec0000000200ULL,
0x0000007c5480723cULL, 0x050ff00000041880ULL, 0x0000007e547c723cULL, 0x000bee0000041864ULL,
0x0000002002657824ULL, 0x020fe200078e00ffULL, 0x0000000c00647810ULL, 0x000fe20007ffe0ffULL,
0x0000006c6850723cULL, 0x000f660000041850ULL, 0xffffffe065647812ULL, 0x000fca00078ee264ULL,
0x0000006e685c723cULL, 0x000b62000004185cULL, 0x0000001064647824ULL, 0x000fe200078e00ffULL,
0x00000000ac68783bULL, 0x020fe80000000200ULL, 0x00000000646c783bULL, 0x000ee40000000200ULL,
0x000000445440723cULL, 0x040f640000041840ULL, 0x00000000ab64783bULL, 0x000fec0000000200ULL,
0x000000465444723cULL, 0x040b64000004183cULL, 0x00000000c63c783bULL, 0x020f2c0000000200ULL,
0x0000004c5448723cULL, 0x042f700000041848ULL, 0x0000004e544c723cULL, 0x040b6e0000041860ULL,
0x0000002002617824ULL, 0x020fe200078e00ffULL, 0x0000000e00607810ULL, 0x000fe20007ffe0ffULL,
0x000000585450723cULL, 0x004b660000041850ULL, 0xffffffe061607812ULL, 0x000fca00078ee260ULL,
0x0000005a5454723cULL, 0x000b64000004185cULL, 0x0000001060587824ULL, 0x020fe200078e00ffULL,
0x00000000b05c783bULL, 0x000fe80000000200ULL, 0x00000000aa60783bULL, 0x000fe20000000200ULL,
0x000000786c40723cULL, 0x048fe60000041840ULL, 0x000000005858783bULL, 0x000e6a0000000200ULL,
0x0000003c6c80723cULL, 0x050f700000041880ULL, 0x0000003e6c7c723cULL, 0x040f70000004187cULL,
0x0000007a6c44723cULL, 0x040f700000041844ULL, 0x000000746c48723cULL, 0x040f700000041848ULL,
0x000000766c4c723cULL, 0x040f70000004184cULL, 0x000000706c50723cULL, 0x040f700000041850ULL,
0x000000726c54723cULL, 0x000f700000041854ULL, 0x000000685880723cULL, 0x062b700000041880ULL,
0x0000006a587c723cULL, 0x040b70000004187cULL, 0x000000645840723cULL, 0x040b700000041840ULL,
0x000000665844723cULL, 0x040b700000041844ULL, 0x000000605848723cULL, 0x040b700000041848ULL,
0x00000062584c723cULL, 0x040b70000004184cULL, 0x0000005c5850723cULL, 0x040b700000041850ULL,
0x0000005e5854723cULL, 0x000b620000041854ULL, 0x0000046000008947ULL, 0x000fce0003800000ULL,
0x00000001083c7824ULL, 0x000fe200078e0a04ULL, 0x0000001803037812ULL, 0x000fe200078efcffULL,
0x00000010a1a17824ULL, 0x000fc400078e021eULL, 0x000000109f9f7824ULL, 0x000fe200078e021eULL,
0x0000003cd500720cULL, 0x080fe20003f06070ULL, 0x0000001003207825ULL, 0x000fe200078e0020ULL,
0x0000003c0b00720cULL, 0x080fe40003f26070ULL, 0x0000003c0e00720cULL, 0x080fe20003f46070ULL,
0x0000001003227825ULL, 0x000fe200078e0022ULL, 0x0000003c0f00720cULL, 0x080fe40003f66070ULL,
0x0000003c1000720cULL, 0x080fe20003f86070ULL, 0x000000109d9d7824ULL, 0x000fe200078e021eULL,
0x0000003c1100720cULL, 0x080fe20003fa6070ULL, 0x0000001003247825ULL, 0x000fe200078e0024ULL,
0x0000003c1200720cULL, 0x080fe20003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020a17faeULL, 0x0003e2000c101c46ULL, 0x0000003c0c00720cULL, 0x000fe20003f06070ULL,
0x000000109b9b7824ULL, 0x000fc400078e021eULL, 0x00000000229f7faeULL, 0x0005e2000c901c46ULL,
0x0000003c0d00720cULL, 0x000fe20003f26070ULL, 0x0000001003267825ULL, 0x000fc800078e0026ULL,
0x0000001099997824ULL, 0x000fe400078e021eULL, 0x0000001003287825ULL, 0x000fe400078e0028ULL,
0x00000000249d7faeULL, 0x0005e2000c101c46ULL, 0x0000003c1300720cULL, 0x080fe20003f06070ULL,
0x0000001097977824ULL, 0x000fe400078e021eULL, 0x00000010032a7825ULL, 0x000fe200078e002aULL,
0x00000000269b7faeULL, 0x0005e2000c901c46ULL, 0x0000003c1400720cULL, 0x000fc40003f26070ULL,
0x0000001095957824ULL, 0x000fe200078e021eULL, 0x0000000028997faeULL, 0x0005e2000d101c46ULL,
0x00000010032c7825ULL, 0x000fe200078e002cULL, 0x0000003c1500720cULL, 0x080fe40003f46070ULL,
0x000000002a977faeULL, 0x0005e2000d901c46ULL, 0x0000001093937824ULL, 0x000fe200078e021eULL,
0x0000003c1600720cULL, 0x080fe20003f66070ULL, 0x00000010032e7825ULL, 0x000fe200078e002eULL,
0x000000002c957faeULL, 0x0005e2000e101c46ULL, 0x0000003c1700720cULL, 0x000fc40003f86070ULL,
0x0000001091917824ULL, 0x000fe200078e021eULL, 0x000000002e937faeULL, 0x0005e2000e901c46ULL,
0x0000001003307825ULL, 0x000fe200078e0030ULL, 0x0000003c1800720cULL, 0x000fc60003fa6070ULL,
0x000000108f8f7824ULL, 0x000fe200078e021eULL, 0x0000000030917faeULL, 0x0005e2000f101c46ULL,
0x0000003c1900720cULL, 0x000fe20003fc6070ULL, 0x0000001003327825ULL, 0x000fc800078e0032ULL,
0x000000108d8d7824ULL, 0x000fe200078e021eULL, 0x00000000328f7faeULL, 0x0005e2000c101c46ULL,
0x0000001003347825ULL, 0x000fc800078e0034ULL, 0x000000108b8b7824ULL, 0x000fe200078e021eULL,
0x00000000348d7faeULL, 0x0005e2000c901c46ULL, 0x0000001003367825ULL, 0x000fc800078e0036ULL,
0x0000001089897824ULL, 0x000fe200078e021eULL, 0x00000000368b7faeULL, 0x0005e2000d101c46ULL,
0x0000001003387825ULL, 0x000fc800078e0038ULL, 0x000000101f1f7824ULL, 0x000fe200078e021eULL,
0x0000000038897faeULL, 0x0005e2000d901c46ULL, 0x00000010033a7825ULL, 0x000fc800078e003aULL,
0x000000101c217824ULL, 0x002fe200078e021eULL, 0x000000003a1f7faeULL, 0x0005e2000e101c46ULL,
0x0000001003847825ULL, 0x000fc800078e0084ULL, 0x000000101d1d7824ULL, 0x000fe200078e021eULL,
0x0000000084217faeULL, 0x0005e2000e901c46ULL, 0x0000001003867825ULL, 0x000fca00078e0086ULL,
0x00000000861d7faeULL, 0x0005e2000f101c46ULL, 0x0000034000007947ULL, 0x000fea0003800000ULL,
0x0000001803037812ULL, 0x000fe200078efcffULL, 0x00000010a1a17824ULL, 0x100fe400078e021eULL,
0x000000109f9f7824ULL, 0x000fe400078e021eULL, 0x0000001003207825ULL, 0x000fc800078e0020ULL,
0x0000001003227825ULL, 0x000fe200078e0022ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020a17faeULL, 0x0003e6000b901c46ULL, 0x000000109d9d7824ULL, 0x000fe200078e021eULL,
0x00000000229f7faeULL, 0x0003e2000b901c46ULL, 0x0000001003247825ULL, 0x000fc800078e0024ULL,
0x000000109b9b7824ULL, 0x000fe200078e021eULL, 0x00000000249d7faeULL, 0x0003e2000b901c46ULL,
0x0000001003267825ULL, 0x000fc800078e0026ULL, 0x0000001099997824ULL, 0x000fe200078e021eULL,
0x00000000269b7faeULL, 0x0003e2000b901c46ULL, 0x0000001003287825ULL, 0x000fc800078e0028ULL,
0x0000001097977824ULL, 0x000fe200078e021eULL, 0x0000000028997faeULL, 0x0003e2000b901c46ULL,
0x00000010032a7825ULL, 0x000fc800078e002aULL, 0x0000001095957824ULL, 0x000fe200078e021eULL,
0x000000002a977faeULL, 0x0003e2000b901c46ULL, 0x00000010032c7825ULL, 0x000fc800078e002cULL,
0x0000001093937824ULL, 0x000fe200078e021eULL, 0x000000002c957faeULL, 0x0003e2000b901c46ULL,
0x00000010032e7825ULL, 0x000fc800078e002eULL, 0x0000001091917824ULL, 0x000fe200078e021eULL,
0x000000002e937faeULL, 0x0003e2000b901c46ULL, 0x0000001003307825ULL, 0x000fc800078e0030ULL,
0x000000108f8f7824ULL, 0x000fe200078e021eULL, 0x0000000030917faeULL, 0x0003e2000b901c46ULL,
0x0000001003327825ULL, 0x000fc800078e0032ULL, 0x000000108d8d7824ULL, 0x000fe200078e021eULL,
0x00000000328f7faeULL, 0x0003e2000b901c46ULL, 0x0000001003347825ULL, 0x000fc800078e0034ULL,
0x000000108b8b7824ULL, 0x000fe200078e021eULL, 0x00000000348d7faeULL, 0x0003e2000b901c46ULL,
0x0000001003367825ULL, 0x000fc800078e0036ULL, 0x0000001089897824ULL, 0x000fe200078e021eULL,
0x00000000368b7faeULL, 0x0003e2000b901c46ULL, 0x0000001003387825ULL, 0x000fc800078e0038ULL,
0x000000101f1f7824ULL, 0x000fe200078e021eULL, 0x0000000038897faeULL, 0x0003e2000b901c46ULL,
0x00000010033a7825ULL, 0x000fc800078e003aULL, 0x000000101c3d7824ULL, 0x000fe200078e021eULL,
0x000000003a1f7faeULL, 0x0003e2000b901c46ULL, 0x0000001003847825ULL, 0x000fc800078e0084ULL,
0x000000101d1d7824ULL, 0x000fe200078e021eULL, 0x00000000843d7faeULL, 0x0003e2000b901c46ULL,
0x0000001003867825ULL, 0x000fca00078e0086ULL, 0x00000000861d7faeULL, 0x0003e4000b901c46ULL,
0x00000004ff217424ULL, 0x006fe200078e00ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffffff037424ULL, 0x000fe400078e00ffULL, 0x0000030021bd7a24ULL, 0x000fca00078e02bdULL,
0x000000b7bd00720cULL, 0x000fda0003f06070ULL, 0x00000002da208824ULL, 0x000fe200078e02bdULL,
0x00000010001c7810ULL, 0x000fe20007ffe0ffULL, 0x00000020021d7824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000600020208625ULL, 0x000fe200078e0021ULL,
0xffffffe01d1c7812ULL, 0x000fe200078ee21cULL, 0x00000000b838783bULL, 0x000fe80000000200ULL,
0x0000000620038981ULL, 0x0002a2000c1e1900ULL, 0x000000101c2c7824ULL, 0x000fe200078e00ffULL,
0x0000001200227810ULL, 0x000fe20007ffe0ffULL, 0x0000002002237824ULL, 0x000fe200078e00ffULL,
0x00000000b91c783bULL, 0x000fe80000000200ULL, 0x000000002c2c783bULL, 0x000ee20000000200ULL,
0xffffffe023227812ULL, 0x000fc600078ee222ULL, 0x00000000ba34783bULL, 0x000f240000000200ULL,
0x0000001022227824ULL, 0x000fe400078e00ffULL, 0x00000000be24783bULL, 0x000fe80000000200ULL,
0x000000002220783bULL, 0x002e680000000200ULL, 0x00000000bb30783bULL, 0x000e680000000200ULL,
0x00000000bc28783bULL, 0x000e680000000200ULL, 0x00000000c958783bULL, 0x020fe80000000200ULL,
0x00000000d23c783bULL, 0x000fe20000000200ULL, 0x0000001c2c40723cULL, 0x048f700000041840ULL,
0x000000382c80723cULL, 0x040f700000041880ULL, 0x0000003a2c7c723cULL, 0x040b64000004187cULL,
0x00000000bf38783bULL, 0x020eec0000000200ULL, 0x0000001e2c44723cULL, 0x040b640000041844ULL,
0x00000000c01c783bULL, 0x020eec0000000200ULL, 0x000000342c48723cULL, 0x010f700000041848ULL,
0x000000242040723cULL, 0x002bee0000041840ULL, 0x0000002002257824ULL, 0x020fe200078e00ffULL,
0x0000001400247810ULL, 0x000fe20007ffe0ffULL, 0x000000362c4c723cULL, 0x000b64000004184cULL,
0x00000000c834783bULL, 0x020fe20000000200ULL, 0xffffffe025247812ULL, 0x000fca00078ee224ULL,
0x000000302c50723cULL, 0x040b6e0000041850ULL, 0x0000001024307824ULL, 0x020fe200078e00ffULL,
0x000000322c54723cULL, 0x000b640000041854ULL, 0x00000000c72c783bULL, 0x020fe80000000200ULL,
0x000000003030783bULL, 0x000fe40000000200ULL, 0x000000282080723cULL, 0x040f700000041880ULL,
0x0000002a207c723cULL, 0x040b64000004187cULL, 0x00000000c228783bULL, 0x020e6c0000000200ULL,
0x000000262044723cULL, 0x040b640000041844ULL, 0x00000000c124783bULL, 0x020f2c0000000200ULL,
0x000000382048723cULL, 0x048b6e0000041848ULL, 0x0000002002397824ULL, 0x020fe200078e00ffULL,
0x0000001600387810ULL, 0x000fe20007ffe0ffULL, 0x0000003a204c723cULL, 0x000f66000004184cULL,
0xffffffe039387812ULL, 0x000fca00078ee238ULL, 0x0000001c2050723cULL, 0x040b6e0000041850ULL,
0x00000010381c7824ULL, 0x020fe200078e00ffULL, 0x0000001e2054723cULL, 0x000b620000041854ULL,
0x00000000d338783bULL, 0x000fe80000000200ULL, 0x000000001c1c783bULL, 0x020ee60000000200ULL,
0x000000283040723cULL, 0x042fe20000041840ULL, 0x00000000d420783bULL, 0x000e6e0000000200ULL,
0x000000243080723cULL, 0x050f700000041880ULL, 0x00000026307c723cULL, 0x040f70000004187cULL,
0x0000002a3044723cULL, 0x040f700000041844ULL, 0x0000002c3048723cULL, 0x040f700000041848ULL,
0x0000002e304c723cULL, 0x040f70000004184cULL, 0x000000343050723cULL, 0x040f700000041850ULL,
0x000000363054723cULL, 0x000f700000041854ULL, 0x000000581c80723cULL, 0x068f700000041880ULL,
0x0000005a1c7c723cULL, 0x040f70000004187cULL, 0x0000003c1c40723cULL, 0x040f700000041840ULL,
0x0000003e1c44723cULL, 0x040f700000041844ULL, 0x000000381c48723cULL, 0x040f700000041848ULL,
0x0000003a1c4c723cULL, 0x040f70000004184cULL, 0x000000201c50723cULL, 0x042f700000041850ULL,
0x000000221c54723cULL, 0x000b620000041854ULL, 0x0000000403257c24ULL, 0x004fcc000f8e02ffULL,
0x00000300091c7a10ULL, 0x020fc80007ffe0ffULL, 0x000000011c1e7810ULL, 0x000fc80007ffe0ffULL,
0x000000071e00720cULL, 0x000fda0003f06070ULL, 0x0000089000008947ULL, 0x000fea0003800000ULL,
0x00000025a2587210ULL, 0x080fe40007f1e0ffULL, 0x000000259c3b7210ULL, 0x080fe40007f7e0ffULL,
0x000000259a397210ULL, 0x080fe20007f9e0ffULL, 0x000000ffff1d7224ULL, 0x000fe200000e06ffULL,
0x00000025a03e7210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff207224ULL, 0x000fe200018e06ffULL,
0x00005e00583f7a11ULL, 0x000fe200078048ffULL, 0x000000ffff1e7224ULL, 0x000fe200020e06ffULL,
0x000000259e3c7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff237224ULL, 0x000fe200008e06ffULL,
0x00005f0058587a11ULL, 0x000fc400000f4c1dULL, 0x00005e0039217a11ULL, 0x040fe200078648ffULL,
0x000000ffff1d7224ULL, 0x000fe200010e06ffULL, 0x00005e003e3d7a11ULL, 0x000fe400078048ffULL,
0x00005e003c1f7a11ULL, 0x000fe400078248ffULL, 0x00005f0039397a11ULL, 0x000fe400018f4c1eULL,
0x00005f003e3e7a11ULL, 0x000fe400000f4c23ULL, 0x0000002592337210ULL, 0x000fc40007f7e0ffULL,
0x00005e003b3a7a11ULL, 0x040fe400078448ffULL, 0x00005f003c3c7a11ULL, 0x000fe200008f4c1dULL,
0x000000ffff1e7224ULL, 0x000fe200018e06ffULL, 0x0000002598387210ULL, 0x080fe40007f1e0ffULL,
0x0000002596377210ULL, 0x080fe40007f3e0ffULL, 0x00005f003b3b7a11ULL, 0x000fe200010f4c20ULL,
0x000000ffff1d7224ULL, 0x000fe200000e06ffULL, 0x0000002594357210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff227224ULL, 0x000fe200008e06ffULL, 0x00005e0033327a11ULL, 0x000fc400078648ffULL,
0x00005e0038237a11ULL, 0x000fe200078048ffULL, 0x000000ffff207224ULL, 0x000fe200010e06ffULL,
0x0000002590317210ULL, 0x080fe40007f9e0ffULL, 0x00005e0037367a11ULL, 0x000fe400078248ffULL,
0x00005f0033337a11ULL, 0x000fe200018f4c1eULL, 0x000000ffff1e7224ULL, 0x000fe200020e06ffULL,
0x00005f0038387a11ULL, 0x000fe200000f4c1dULL, 0x000001001c1d7824ULL, 0x000fe200078e02d8ULL,
0x000000258e2f7210ULL, 0x000fc40007f7e0ffULL, 0x00005e0035347a11ULL, 0x000fe400078448ffULL,
0x00005f0037377a11ULL, 0x000fe200008f4c22ULL, 0x000000ffff227224ULL, 0x000fe200018e06ffULL,
0x000000258c2d7210ULL, 0x080fe40007f1e0ffULL, 0x000000258a2b7210ULL, 0x000fe40007f3e0ffULL,
0x00005e0031307a11ULL, 0x000fe400078c48ffULL, 0x00005f0035357a11ULL, 0x000fe200010f4c20ULL,
0x000000ffff207224ULL, 0x000fe200000e06ffULL, 0x00005f0031317a11ULL, 0x000fe200030f4c1eULL,
0x000000ffff1e7224ULL, 0x000fe200008e06ffULL, 0x00005e002f2e7a11ULL, 0x000fc400078648ffULL,
0x0000002588297210ULL, 0x080fe40007f5e0ffULL, 0x000000251a277210ULL, 0x000fe40007f9e0ffULL,
0x00005e002d2c7a11ULL, 0x000fe400078048ffULL, 0x0000001d081a7217ULL, 0x000fe40007800000ULL,
0x00005e002b2a7a11ULL, 0x000fe400078248ffULL, 0x000000251b1b7210ULL, 0x000fe20007fbe0ffULL,
0x000000011a247824ULL, 0x000fe200078e0a1dULL, 0x00005f002f2f7a11ULL, 0x000fe200018f4c22ULL,
0x0000001005227824ULL, 0x000fe200078e00ffULL, 0x00005f002d2d7a11ULL, 0x000fe200000f4c20ULL,
0x000000ffff207224ULL, 0x000fe200010e06ffULL, 0x00005f002b2b7a11ULL, 0x000fe200008f4c1eULL,
0x000000ffff1e7224ULL, 0x000fe200020e06ffULL, 0x00005e0029287a11ULL, 0x000fe200078048ffULL,
0x000000ffff1a7224ULL, 0x000fe200028e06ffULL, 0x00005e0027267a11ULL, 0x000fc400078248ffULL,
0x00005e001b1d7a11ULL, 0x000fe400078448ffULL, 0x0000007022597812ULL, 0x000fe400078ec0ffULL,
0x00005f0029297a11ULL, 0x000fe400000f4c20ULL, 0x00005f0027277a11ULL, 0x000fe400008f4c1eULL,
0x00000024d500720cULL, 0x000fe40003f06070ULL, 0x00005f001b257a11ULL, 0x000fc400010f4c1aULL,
0x000000240b00720cULL, 0x080fe40003f26070ULL, 0x0000003f591a7210ULL, 0x040fe40007f7e0ffULL,
0x000000240c00720cULL, 0x080fe40003f46070ULL, 0x0000003d590c7210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff1b7224ULL, 0x000fe200018e0658ULL, 0x0000001f591e7210ULL, 0x000fe40007fbe0ffULL,
0x000000240d00720cULL, 0x080fe20003f66070ULL, 0x000000ffff0d7224ULL, 0x000fe200020e063eULL,
0x000000240e00720cULL, 0x000fe20003f86070ULL, 0x000000ffff1f7224ULL, 0x000fe200028e063cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001ab67faeULL, 0x0003e2000c101c46ULL,
0x0000003a590e7210ULL, 0x000fc40007f1e0ffULL, 0x000000240f00720cULL, 0x080fe20003fa6070ULL,
0x000000000cb57faeULL, 0x0005e2000c901c46ULL, 0x0000002159207210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200000e063bULL, 0x000000241000720cULL, 0x080fe20003f06070ULL,
0x000000001eb47faeULL, 0x0007e2000d101c46ULL, 0x0000002359227210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff217224ULL, 0x000fe200008e0639ULL, 0x000000241100720cULL, 0x080fe20003f26070ULL,
0x000000000eb37faeULL, 0x0009e4000d901c46ULL, 0x000000ffff237224ULL, 0x000fe200010e0638ULL,
0x000000241200720cULL, 0x000fe20003f46070ULL, 0x0000000020b27faeULL, 0x0007e2000e101c46ULL,
0x00000036590c7210ULL, 0x004fc40007f9e0ffULL, 0x0000003259127210ULL, 0x040fe20007f7e0ffULL,
0x0000000022b17faeULL, 0x0007e2000e901c46ULL, 0x0000003459107210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff0d7224ULL, 0x000fe200020e0637ULL, 0x000000241300720cULL, 0x080fe20003f86070ULL,
0x000000ffff137224ULL, 0x000fe200018e0633ULL, 0x000000241500720cULL, 0x080fe20003f66070ULL,
0x000000ffff117224ULL, 0x000fe200028e0635ULL, 0x000000241400720cULL, 0x000fe20003fa6070ULL,
0x000000000caf7faeULL, 0x0005e2000c101c46ULL, 0x00000030590e7210ULL, 0x010fc40007f1e0ffULL,
0x0000002e59147210ULL, 0x000fe20007fde0ffULL, 0x0000000010ae7faeULL, 0x0009e2000c901c46ULL,
0x000000241600720cULL, 0x080fe20003f26070ULL, 0x000000ffff0f7224ULL, 0x000fe200000e0631ULL,
0x000000241700720cULL, 0x000fe20003f06070ULL, 0x0000000012ad7faeULL, 0x0007e2000d101c46ULL,
0x0000002c591a7210ULL, 0x042fe20007f5e0ffULL, 0x000000ffff157224ULL, 0x000fe400030e062fULL,
0x000000000ea97faeULL, 0x0003e2000e101c46ULL, 0x0000002a590c7210ULL, 0x044fe20007f9e0ffULL,
0x000000ffff1b7224ULL, 0x000fe200010e062dULL, 0x000000241800720cULL, 0x000fe20003f46070ULL,
0x0000000014a87faeULL, 0x0003e2000e901c46ULL, 0x0000002859107210ULL, 0x010fe20007fbe0ffULL,
0x000000ffff0d7224ULL, 0x000fc400020e062bULL, 0x000000001aa77faeULL, 0x0003e2000d901c46ULL,
0x000000241900720cULL, 0x000fe20003f66070ULL, 0x000000ffff117224ULL, 0x000fe200028e0629ULL,
0x0000002659127210ULL, 0x048fe20007f9e0ffULL, 0x000000000ca67faeULL, 0x0003e2000c901c46ULL,
0x0000001d59167210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff137224ULL, 0x000fe200020e0627ULL,
0x0000000010a57faeULL, 0x0003e2000c101c46ULL, 0x000000ffff177224ULL, 0x000fc600028e0625ULL,
0x0000000012a47faeULL, 0x0003e8000d101c46ULL, 0x0000000016a37faeULL, 0x0003e2000d901c46ULL,
0x0000075000007947ULL, 0x000fea0003800000ULL, 0x00000025a2a27210ULL, 0x080fe40007f1e0ffULL,
0x00000025a0a07210ULL, 0x080fe40007f3e0ffULL, 0x000000259a9a7210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e06ffULL, 0x00005e00a20c7a11ULL, 0x000fe200078048ffULL,
0x000000ffff0d7224ULL, 0x000fe200008e06ffULL, 0x00005e00a00e7a11ULL, 0x000fe200078248ffULL,
0x000000ffff117224ULL, 0x000fe200010e06ffULL, 0x0000002598987210ULL, 0x000fc40007f7e0ffULL,
0x00005f00a20b7a11ULL, 0x000fe400000f4c0bULL, 0x000000259e9e7210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff137224ULL, 0x000fe200018e06ffULL, 0x00005e009a147a11ULL, 0x000fe400078448ffULL,
0x00005f00a0a07a11ULL, 0x000fe200008f4c0dULL, 0x000000ffff0d7224ULL, 0x000fe200000e06ffULL,
0x000000259c9c7210ULL, 0x000fe40007f3e0ffULL, 0x00005e0098167a11ULL, 0x000fc400078648ffULL,
0x00005f009a9a7a11ULL, 0x000fe200010f4c11ULL, 0x000000ffff0f7224ULL, 0x000fe200008e06ffULL,
0x00005e009e107a11ULL, 0x000fe400078048ffULL, 0x0000002592927210ULL, 0x080fe40007f5e0ffULL,
0x00005f0098987a11ULL, 0x000fe400018f4c13ULL, 0x00005e009c127a11ULL, 0x000fe200078248ffULL,
0x000000ffff117224ULL, 0x000fe200010e06ffULL, 0x0000002590907210ULL, 0x000fc40007f7e0ffULL,
0x00005f009e9e7a11ULL, 0x000fe400000f4c0dULL, 0x0000002596967210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff137224ULL, 0x000fe200018e06ffULL, 0x00005e0092207a11ULL, 0x000fe400078448ffULL,
0x00005f009c9c7a11ULL, 0x000fe200008f4c0fULL, 0x000000ffff0d7224ULL, 0x000fe200000e06ffULL,
0x0000002594947210ULL, 0x000fe40007f3e0ffULL, 0x00005e0090227a11ULL, 0x000fc400078648ffULL,
0x00005f0092927a11ULL, 0x000fe200010f4c11ULL, 0x000000ffff0f7224ULL, 0x000fe200008e06ffULL,
0x00005e0096187a11ULL, 0x000fe400078048ffULL, 0x000000258e8e7210ULL, 0x080fe40007f5e0ffULL,
0x00005f0090907a11ULL, 0x000fe400018f4c13ULL, 0x00005e00941e7a11ULL, 0x000fe400078248ffULL,
0x000000258c8c7210ULL, 0x000fc40007f7e0ffULL, 0x00005f0096967a11ULL, 0x000fe200000f4c0dULL,
0x000000ffff0d7224ULL, 0x000fe200010e06ffULL, 0x000000258a8a7210ULL, 0x080fe40007fbe0ffULL,
0x00005e008e247a11ULL, 0x000fe400078448ffULL, 0x00005f0094947a11ULL, 0x000fe200008f4c0fULL,
0x000000ffff0f7224ULL, 0x000fe200018e06ffULL, 0x000000251b1b7210ULL, 0x080fe20007f7e0ffULL,
0x000000ffff117224ULL, 0x000fe200028e06ffULL, 0x00005f008e8e7a11ULL, 0x000fe200010f4c0dULL,
0x00000010050d7824ULL, 0x000fe200078e00ffULL, 0x000000251a1a7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff2e7224ULL, 0x000fe200018e06ffULL, 0x00005e008a287a11ULL, 0x000fc400078a48ffULL,
0x0000002588887210ULL, 0x000fe40007f1e0ffULL, 0x00005e008c267a11ULL, 0x000fe400078848ffULL,
0x00005f008a8a7a11ULL, 0x000fe200028f4c11ULL, 0x000000ffff117224ULL, 0x000fe200008e06ffULL,
0x00005e001b307a11ULL, 0x000fe400078448ffULL, 0x00005f008c8c7a11ULL, 0x000fe200020f4c0fULL,
0x000000ffff0f7224ULL, 0x000fe200000e06ffULL, 0x000000700d2d7812ULL, 0x000fc400078ec0ffULL,
0x00005e001a2c7a11ULL, 0x000fe400078248ffULL, 0x00005e00882a7a11ULL, 0x000fe400078048ffULL,
0x00005f001b2e7a11ULL, 0x000fe400010f4c2eULL, 0x0000000c2d0c7210ULL, 0x040fe40007f5e0ffULL,
0x00005f001a1d7a11ULL, 0x000fe400008f4c11ULL, 0x0000000e2d0e7210ULL, 0x000fe20007fde0ffULL,
0x000000ffff0d7224ULL, 0x000fe200010e060bULL, 0x00005f0088887a11ULL, 0x000fc400000f4c0fULL,
0x000000102d107210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200030e06a0ULL,
0x000000122d127210ULL, 0x040fe20007f1e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000cb67faeULL, 0x0003e2000b901c46ULL, 0x000000142d147210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff117224ULL, 0x000fe200008e069eULL, 0x000000162d167210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff137224ULL, 0x000fe200000e069cULL, 0x000000182d187210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff157224ULL, 0x000fe200028e069aULL, 0x0000001e2d1a7210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff177224ULL, 0x000fe200020e0698ULL, 0x000000202d1e7210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff197224ULL, 0x000fe200018e0696ULL, 0x000000222d207210ULL, 0x040fe20007f1e0ffULL,
0x000000000eb57faeULL, 0x0003e2000b901c46ULL, 0x000000242d227210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff1b7224ULL, 0x000fe200010e0694ULL, 0x000000262d247210ULL, 0x040fe20007f9e0ffULL,
0x0000000010b47faeULL, 0x0003e2000b901c46ULL, 0x000000282d267210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff1f7224ULL, 0x000fe200008e0692ULL, 0x0000002a2d287210ULL, 0x040fe20007f5e0ffULL,
0x0000000012b37faeULL, 0x0003e2000b901c46ULL, 0x0000002c2d2a7210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff217224ULL, 0x000fe200000e0690ULL, 0x000000302d2c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000014b27faeULL, 0x0003e2000b901c46ULL, 0x000000ffff237224ULL, 0x000fc400028e068eULL,
0x000000ffff257224ULL, 0x000fe200020e068cULL, 0x0000000016b17faeULL, 0x0003e2000b901c46ULL,
0x000000ffff277224ULL, 0x000fe400018e068aULL, 0x000000ffff297224ULL, 0x000fe200010e0688ULL,
0x0000000018af7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff2b7224ULL, 0x000fe400008e061dULL,
0x000000ffff2d7224ULL, 0x000fe200000e062eULL, 0x000000001aae7faeULL, 0x0003e8000b901c46ULL,
0x000000001ead7faeULL, 0x0003e8000b901c46ULL, 0x0000000020a97faeULL, 0x0003e8000b901c46ULL,
0x0000000022a87faeULL, 0x0003e8000b901c46ULL, 0x0000000024a77faeULL, 0x0003e8000b901c46ULL,
0x0000000026a67faeULL, 0x0003e8000b901c46ULL, 0x0000000028a57faeULL, 0x0003e8000b901c46ULL,
0x000000002aa47faeULL, 0x0003e8000b901c46ULL, 0x000000002ca37faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000020020c7824ULL, 0x002fe200078e00ffULL,
0x00000018000b7810ULL, 0x000fc80007ffe0ffULL, 0xffffffe00c0b7812ULL, 0x000fca00078ee20bULL,
0x000000100b0b7824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000000d110783bULL, 0x000fe80000000200ULL, 0x000000000b0c783bULL, 0x0002a80000000200ULL,
0x00000000d014783bULL, 0x000ee80000000200ULL, 0x00000000cf24783bULL, 0x000f220000000200ULL,
0x0000001c000b7810ULL, 0x002fc60007ffe0ffULL, 0x00000000ce18783bULL, 0x000e680000000200ULL,
0x00000000cd28783bULL, 0x000fe80000000200ULL, 0x00000000cc2c783bULL, 0x000fe80000000200ULL,
0x00000000cb30783bULL, 0x000fe80000000200ULL, 0x00000000ca20783bULL, 0x000fe80000000200ULL,
0x00000000c3c0783bULL, 0x000fe80000000200ULL, 0x00000000acac783bULL, 0x000fe20000000200ULL,
0x000000100c80723cULL, 0x044b660000041880ULL, 0x00000000b0b0783bULL, 0x000fe80000000200ULL,
0x0000002002117824ULL, 0x020fe200078e00ffULL, 0x0000001a00107810ULL, 0x040fe20007ffe0ffULL,
0x000000120c7c723cULL, 0x000b62000004187cULL, 0x0000001e00007810ULL, 0x000fc40007ffe0ffULL,
0xffffffe011107812ULL, 0x000fca00078ee210ULL, 0x0000001010107824ULL, 0x000fe200078e00ffULL,
0x000000140c40723cULL, 0x048b6a0000041840ULL, 0x000000001010783bULL, 0x020ea40000000200ULL,
0x0000002002147824ULL, 0x000fe200078e00ffULL, 0x000000160c44723cULL, 0x000b680000041844ULL,
0xffffffe0140b7812ULL, 0x000fc800078ee20bULL, 0x000000240c48723cULL, 0x010f620000041848ULL,
0x000000100b0b7824ULL, 0x000fca00078e00ffULL, 0x000000000b14783bULL, 0x020fe40000000200ULL,
0x000000260c4c723cULL, 0x040b64000004184cULL, 0x00000000c624783bULL, 0x020eec0000000200ULL,
0x000000180c50723cULL, 0x042b6e0000041850ULL, 0x0000002002197824ULL, 0x020fe200078e00ffULL,
0x0000001a0c54723cULL, 0x000b640000041854ULL, 0x00000000c50c783bULL, 0x020e640000000200ULL,
0xffffffe019007812ULL, 0x000fc400078ee200ULL, 0x00000000c418783bULL, 0x000f240000000200ULL,
0x000000281080723cULL, 0x004f620000041880ULL, 0x0000001000007824ULL, 0x000fce00078e00ffULL,
0x0000002a107c723cULL, 0x040f70000004187cULL, 0x0000002c1040723cULL, 0x040f700000041840ULL,
0x0000002e1044723cULL, 0x040f700000041844ULL, 0x000000301048723cULL, 0x040f700000041848ULL,
0x00000032104c723cULL, 0x040f70000004184cULL, 0x000000201050723cULL, 0x040f700000041850ULL,
0x000000221054723cULL, 0x000b640000041854ULL, 0x000000000010783bULL, 0x020ea80000000200ULL,
0x00000000ab20783bULL, 0x000ea40000000200ULL, 0x000000241480723cULL, 0x048f700000041880ULL,
0x00000026147c723cULL, 0x040b64000004187cULL, 0x00000000aa24783bULL, 0x020eec0000000200ULL,
0x0000000c1440723cULL, 0x042f700000041840ULL, 0x0000000e1444723cULL, 0x040f700000041844ULL,
0x000000181448723cULL, 0x050ff00000041848ULL, 0x0000001a144c723cULL, 0x040ff0000004184cULL,
0x000000c01450723cULL, 0x040ff00000041850ULL, 0x000000c21454723cULL, 0x000ff00000041854ULL,
0x000000ac1080723cULL, 0x044f700000041880ULL, 0x000000ae107c723cULL, 0x040f70000004187cULL,
0x000000201040723cULL, 0x060f700000041840ULL, 0x000000221044723cULL, 0x000f620000041844ULL,
0x3d80000080807820ULL, 0x000fc40000410000ULL, 0x3d80000081817820ULL, 0x000fe40000410000ULL,
0x3d80000082827820ULL, 0x000fe40000410000ULL, 0x3d80000083837820ULL, 0x000fe20000410000ULL,
0x000000241048723cULL, 0x008f620000041848ULL, 0x3d8000007c7c7820ULL, 0x000fe40000410000ULL,
0x3d8000007d7d7820ULL, 0x000fe40000410000ULL, 0x3d8000007e7e7820ULL, 0x000fc40000410000ULL,
0x3d8000007f7f7820ULL, 0x000fe20000410000ULL, 0x00000026104c723cULL, 0x040f64000004184cULL,
0x3d80000040407820ULL, 0x020fe40000410000ULL, 0x3d80000041417820ULL, 0x000fe40000410000ULL,
0x3d80000042427820ULL, 0x000fe40000410000ULL, 0x3d80000043437820ULL, 0x000fe20000410000ULL,
0x000000b01050723cULL, 0x000f620000041850ULL, 0x3d80000044447820ULL, 0x000fc40000410000ULL,
0x3d80000045457820ULL, 0x000fe40000410000ULL, 0x3d80000046467820ULL, 0x000fe40000410000ULL,
0x3d80000047477820ULL, 0x000fe20000410000ULL, 0x000000b21054723cULL, 0x000f620000041854ULL,
0x3d80000048487820ULL, 0x000fe40000410000ULL, 0x3d80000049497820ULL, 0x000fe40000410000ULL,
0x3d8000004a4a7820ULL, 0x000fc40000410000ULL, 0x3d8000004b4b7820ULL, 0x000fe40000410000ULL,
0x3d8000004c4c7820ULL, 0x000fe40000410000ULL, 0x3d8000004d4d7820ULL, 0x000fe40000410000ULL,
0x3d8000004e4e7820ULL, 0x000fe40000410000ULL, 0x3d8000004f4f7820ULL, 0x000fe40000410000ULL,
0x3d80000050507820ULL, 0x020fc40000410000ULL, 0x3d80000051517820ULL, 0x000fe40000410000ULL,
0x3d80000052527820ULL, 0x000fe40000410000ULL, 0x3d80000053537820ULL, 0x000fe40000410000ULL,
0x3d80000054547820ULL, 0x000fe40000410000ULL, 0x3d80000055557820ULL, 0x000fe40000410000ULL,
0x3d80000056567820ULL, 0x000fc40000410000ULL, 0x3d80000057577820ULL, 0x000fe20000410000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000d6107f8cULL, 0x0002a4000c80043fULL,
0x00000000000c7805ULL, 0x000fc40000015200ULL, 0x00000400d60b7984ULL, 0x000ee40000000800ULL,
0x800000000bff7812ULL, 0x00cfe40007804811ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff027224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000e7805ULL, 0x000fcc0000015200ULL,
0x0000000e0c0b7210ULL, 0x000fca0007f1e1ffULL, 0x000000010f0e7824ULL, 0x000fe200000e0e0dULL,
0x003d09000b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0e00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0e00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc8000001140eULL, 0x0000000b00007211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060eULL, 0x0000000200007819ULL, 0x000fc8000000120bULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000102027810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000400d60b7984ULL, 0x000ea40000000800ULL, 0x800000000bff7812ULL, 0x004fe40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000405027824ULL, 0x000fe200078e00ffULL,
0x000000d90900720cULL, 0x000fc80003f05270ULL, 0xfffffff0020b7812ULL, 0x000fca00078ec0ffULL,
0x000000800a007824ULL, 0x000fca00078e020bULL, 0x01c40000000c7984ULL, 0x0004e20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x0000000205097824ULL, 0x000fe400078e00ffULL,
0x0000000108117824ULL, 0x000fc600078e0a04ULL, 0x0000000609097812ULL, 0x000fc800078ec0ffULL,
0x0000000109047812ULL, 0x040fe400078efcffULL, 0x00000008090b7812ULL, 0x040fe400078efcffULL,
0x000000110400720cULL, 0x080fe40003f26070ULL, 0x0000001009047812ULL, 0x000fe400078efcffULL,
0x000000110b00720cULL, 0x080fe40003f06070ULL, 0x000000110400720cULL, 0x000fc40003fc6070ULL,
0x00000011090b7812ULL, 0x040fe400078efcffULL, 0x0000001809047812ULL, 0x040fe400078efcffULL,
0x000000110900720cULL, 0x080fe40003f46070ULL, 0x000000110b00720cULL, 0x080fe40003fa6070ULL,
0x000000110400720cULL, 0x000fe40003f66070ULL, 0x0000000909107812ULL, 0x000fc400078efcffULL,
0x00000019090b7812ULL, 0x040fe400078efcffULL, 0x0000002009047812ULL, 0x000fe400078efcffULL,
0xff80000082827808ULL, 0x000fe40005000000ULL, 0xff80000080807808ULL, 0x000fe40005000000ULL,
0xff80000083837808ULL, 0x000fe40004800000ULL, 0xff80000081817808ULL, 0x000fc40004800000ULL,
0x000000111000720cULL, 0x080fe40003f86070ULL, 0x000000110b00720cULL, 0x080fe40003f46070ULL,
0x000000110400720cULL, 0x000fe40003f26070ULL, 0x00000021090b7812ULL, 0x040fe400078efcffULL,
0x0000002809047812ULL, 0x000fe400078efcffULL, 0xff8000007e7e7808ULL, 0x000fc40004000000ULL,
0xff8000007c7c7808ULL, 0x000fe40004000000ULL, 0xff8000007f7f7808ULL, 0x000fe40006000000ULL,
0xff8000007d7d7808ULL, 0x000fe40006000000ULL, 0x000000110b00720cULL, 0x080fe40003f06070ULL,
0x000000110400720cULL, 0x000fe40003f86070ULL, 0x00000029090b7812ULL, 0x000fc400078efcffULL,
0x0000003009047812ULL, 0x000fe400078efcffULL, 0xff80000042427808ULL, 0x000fe40007000000ULL,
0xff80000040407808ULL, 0x000fe40007000000ULL, 0xff80000043437808ULL, 0x000fe40006800000ULL,
0xff80000041417808ULL, 0x000fe40006800000ULL, 0x000000110b00720cULL, 0x000fc40003fc6070ULL,
0x000000110400720cULL, 0x000fe40003fa6070ULL, 0x00000031090b7812ULL, 0x040fe400078efcffULL,
0x0000003809047812ULL, 0x040fe400078efcffULL, 0x0000003909097812ULL, 0x000fe400078efcffULL,
0xff80000046467808ULL, 0x000fe40005800000ULL, 0xff80000044447808ULL, 0x000fc40005800000ULL,
0xff80000047477808ULL, 0x000fe40005000000ULL, 0xff80000045457808ULL, 0x000fe40005000000ULL,
0xff8000004a4a7808ULL, 0x000fe40004800000ULL, 0xff80000048487808ULL, 0x000fe40004800000ULL,
0x000000110b00720cULL, 0x080fe40003f66070ULL, 0x000000110400720cULL, 0x000fc40003f46070ULL,
0x000000110900720cULL, 0x000fe40003f26070ULL, 0xff8000004b4b7808ULL, 0x000fe40004000000ULL,
0xff80000049497808ULL, 0x000fe40004000000ULL, 0xff8000004e4e7808ULL, 0x000fe40006000000ULL,
0xff8000004c4c7808ULL, 0x000fe40006000000ULL, 0xff8000004f4f7808ULL, 0x000fc40007000000ULL,
0xff8000004d4d7808ULL, 0x000fe40007000000ULL, 0xff80000052527808ULL, 0x000fe40006800000ULL,
0xff80000050507808ULL, 0x000fe40006800000ULL, 0xff80000053537808ULL, 0x000fe40005800000ULL,
0xff80000051517808ULL, 0x000fe40005800000ULL, 0xff80000056567808ULL, 0x000fc40005000000ULL,
0xff80000054547808ULL, 0x000fe40005000000ULL, 0xff80000057577808ULL, 0x000fe40004800000ULL,
0xff80000055557808ULL, 0x000fc40004800000ULL, 0x000000800c00720bULL, 0x008fe40003f1e000ULL,
0x000000820d00720bULL, 0x000fe40003f3e000ULL, 0x0000000c800c7208ULL, 0x000fe40004000000ULL,
0x0000000d82047208ULL, 0x000fc40004800000ULL, 0x000000810c00720bULL, 0x000fe40003f1e000ULL,
0x000000830400720bULL, 0x000fe40003f3e000ULL, 0x0000000c81097208ULL, 0x000fe40004000000ULL,
0x00000004830b7208ULL, 0x000fe40004800000ULL, 0x0000007c0900720bULL, 0x000fe40003f1e000ULL,
0x0000007e0b00720bULL, 0x000fc40003f3e000ULL, 0x000000097c047208ULL, 0x000fe40004000000ULL,
0x0000000b7e0c7208ULL, 0x000fe40004800000ULL, 0x0000007d0400720bULL, 0x000fe40003f1e000ULL,
0x0000007f0c00720bULL, 0x000fe40003f3e000ULL, 0x000000047d097208ULL, 0x000fe40004000000ULL,
0x0000000c7f0b7208ULL, 0x000fc40004800000ULL, 0x000000400900720bULL, 0x000fe40003f1e000ULL,
0x000000420b00720bULL, 0x000fe40003f3e000ULL, 0x0000000940047208ULL, 0x000fe40004000000ULL,
0x0000000b420c7208ULL, 0x000fe40004800000ULL, 0x000000410400720bULL, 0x000fe40003f1e000ULL,
0x000000430c00720bULL, 0x000fc40003f3e000ULL, 0x0000000441097208ULL, 0x000fe40004000000ULL,
0x0000000c430b7208ULL, 0x000fe40004800000ULL, 0x000000440900720bULL, 0x000fe40003f1e000ULL,
0x000000460b00720bULL, 0x000fe40003f3e000ULL, 0x0000000944047208ULL, 0x000fe40004000000ULL,
0x0000000b460c7208ULL, 0x000fc40004800000ULL, 0x000000450400720bULL, 0x000fe40003f1e000ULL,
0x000000470c00720bULL, 0x000fe40003f3e000ULL, 0x0000000445097208ULL, 0x000fe40004000000ULL,
0x0000000c470b7208ULL, 0x000fe40004800000ULL, 0x000000480900720bULL, 0x000fe40003f1e000ULL,
0x0000004a0b00720bULL, 0x000fc40003f3e000ULL, 0x0000000948047208ULL, 0x000fe40004000000ULL,
0x0000000b4a0c7208ULL, 0x000fe40004800000ULL, 0x000000490400720bULL, 0x000fe40003f1e000ULL,
0x0000004b0c00720bULL, 0x000fe40003f3e000ULL, 0x0000000449097208ULL, 0x000fe40004000000ULL,
0x0000000c4b0b7208ULL, 0x000fc40004800000ULL, 0x0000004c0900720bULL, 0x000fe40003f1e000ULL,
0x0000004e0b00720bULL, 0x000fe40003f3e000ULL, 0x000000094c047208ULL, 0x000fe40004000000ULL,
0x0000000b4e0c7208ULL, 0x000fe40004800000ULL, 0x0000004d0400720bULL, 0x000fe40003f1e000ULL,
0x0000004f0c00720bULL, 0x000fc40003f3e000ULL, 0x000000044d097208ULL, 0x000fe40004000000ULL,
0x0000000c4f0b7208ULL, 0x000fe40004800000ULL, 0x000000500900720bULL, 0x000fe40003f1e000ULL,
0x000000520b00720bULL, 0x000fe40003f3e000ULL, 0x0000000950047208ULL, 0x000fe40004000000ULL,
0x0000000b520c7208ULL, 0x000fc40004800000ULL, 0x000000510400720bULL, 0x000fe40003f1e000ULL,
0x000000530c00720bULL, 0x000fe40003f3e000ULL, 0x0000000451097208ULL, 0x000fe40004000000ULL,
0x0000000c530b7208ULL, 0x000fe40004800000ULL, 0x000000540900720bULL, 0x000fe40003f1e000ULL,
0x000000560b00720bULL, 0x000fc40003f3e000ULL, 0x0000000954047208ULL, 0x000fe40004000000ULL,
0x0000000b560c7208ULL, 0x000fe40004800000ULL, 0x000000550400720bULL, 0x000fe40003f1e000ULL,
0x000000570c00720bULL, 0x000fe40003f3e000ULL, 0x0000000455097208ULL, 0x000fe40004000000ULL,
0x0000000c570b7208ULL, 0x000fe20004800000ULL, 0x000019427f007947ULL, 0x000fec000b800000ULL,
0x0c401f0009047f89ULL, 0x00066400000e0000ULL, 0x000000040900720bULL, 0x006fc80003f1e000ULL,
0x0000000904137208ULL, 0x000fe20004000000ULL, 0x000019627f007947ULL, 0x000fea000b800000ULL,
0x0c401f000b047f89ULL, 0x000e6800000e0000ULL, 0x0c401f000e097f89ULL, 0x008ea800000e0000ULL,
0x0c401f000f0c7f89ULL, 0x000ee800000e0000ULL, 0x0c201f00130d7f89ULL, 0x000f2200000e0000ULL,
0x000000040b00720bULL, 0x002fc40003f1e000ULL, 0x000000090e00720bULL, 0x004fe40003f3e000ULL,
0x0000000b04047208ULL, 0x000fe40004000000ULL, 0x0000000e09097208ULL, 0x000fe40004800000ULL,
0x0000000c0f00720bULL, 0x008fe20003f1e000ULL, 0x0c201f0004117f89ULL, 0x000e6600000e0000ULL,
0x0000000f0c0b7208ULL, 0x000fe20004000000ULL, 0x0c201f0009107f89ULL, 0x000ea200000e0000ULL,
0x0000000d1300720bULL, 0x010fc60003f1e000ULL, 0x0c201f000b1e7f89ULL, 0x0006e200000e0000ULL,
0x000000130d0c7208ULL, 0x000fe40004000000ULL, 0x000000110400720bULL, 0x002fe40003f3e000ULL,
0x000000100900720bULL, 0x004fe40003f5e000ULL, 0x00000004110d7208ULL, 0x000fe40004800000ULL,
0x00000009100e7208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b0c047820ULL, 0x008fe20000410000ULL,
0x3f80000000057882ULL, 0x000fe20000000000ULL, 0x3fb8aa3b0d0f7820ULL, 0x000fe20000410000ULL,
0x00000002ff1d7819ULL, 0x000fe20000011605ULL, 0x3fb8aa3b81817823ULL, 0x100fe20000010804ULL,
0x0000000305ff7812ULL, 0x000fe2000780c0ffULL, 0x3fb8aa3b7d7d7823ULL, 0x100fe20000010804ULL,
0x000000041d217810ULL, 0x040fe20007ffe0ffULL, 0x3fb8aa3b80807823ULL, 0x100fe20000010804ULL,
0x000000011d1f7810ULL, 0x040fe20007ffe0ffULL, 0x3fb8aa3b7c7c7823ULL, 0x100fe20000010804ULL,
0x0000008100817308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b82827823ULL, 0x100fe2000001080fULL,
0xffffffff1d2b7810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b83837823ULL, 0x100fe2000001080fULL,
0x000000061d297810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b7e7e7823ULL, 0x100fe2000001080fULL,
0x0000001e0b00720bULL, 0x000fe20003f3e000ULL, 0x3fb8aa3b7f7f7823ULL, 0x000fe2000001080fULL,
0x0000008000107308ULL, 0x000ea20000000800ULL, 0x00000005ff2c7e24ULL, 0x000fe2000f8e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b41417823ULL, 0x000fc40000010804ULL,
0x3fb8aa3b45457823ULL, 0x100fe20000010804ULL, 0x3f8000002c2c783eULL, 0x000fe200000010ffULL,
0x3fb8aa3b40407823ULL, 0x100fe20000010804ULL, 0x0000007c00127308ULL, 0x002fe20000000800ULL,
0x3fb8aa3b44447823ULL, 0x000fe40000010804ULL, 0x000000ffff2d7224ULL, 0x000fe400078e002cULL,
0x3fb8aa3b42427823ULL, 0x100fe4000001080fULL, 0x3fb8aa3b43437823ULL, 0x100fe2000001080fULL,
0x0000007d007d7308ULL, 0x000e620000000800ULL, 0x000000108110723eULL, 0x004fe200000010ffULL,
0x3fb8aa3b46467823ULL, 0x000fc4000001080fULL, 0x3fb8aa3b47477823ULL, 0x100fe4000001080fULL,
0x3fb8aa3b49497823ULL, 0x100fe40000010804ULL, 0x0000008200117308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b4d4d7823ULL, 0x100fe40000010804ULL, 0x3fb8aa3b48487823ULL, 0x100fe40000010804ULL,
0x3fb8aa3b4c4c7823ULL, 0x000fe40000010804ULL, 0x3fb8aa3b4a4a7823ULL, 0x100fe2000001080fULL,
0x0000008300207308ULL, 0x000ea20000000800ULL, 0x000000127d12723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b4b4b7823ULL, 0x000fc4000001080fULL, 0x3fb8aa3b4e4e7823ULL, 0x100fe4000001080fULL,
0x3fb8aa3b4f4f7823ULL, 0x000fe4000001080fULL, 0x0000007e00137308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b50507823ULL, 0x100fe40000010804ULL, 0x3fb8aa3b51517823ULL, 0x100fe40000010804ULL,
0x3fb8aa3b54547823ULL, 0x000fe40000010804ULL, 0x000000081d237824ULL, 0x040fe200078e00ffULL,
0x0000007f00227308ULL, 0x000e620000000800ULL, 0x000000112011723eULL, 0x004fe200000010ffULL,
0x000000081d387824ULL, 0x000fc400078e00ffULL, 0x3fb8aa3b55047823ULL, 0x000fe40000010804ULL,
0x3fb8aa3b52527823ULL, 0x000fe2000001080fULL, 0xfffffff838387812ULL, 0x000fe200078ee221ULL,
0x0000004000147308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b53537823ULL, 0x100fe4000001080fULL,
0x3fb8aa3b56567823ULL, 0x100fe4000001080fULL, 0x3fb8aa3b570f7823ULL, 0x000fe4000001080fULL,
0x000000081d2e7824ULL, 0x040fe200078e00ffULL, 0x000000132213723eULL, 0x002fe200000010ffULL,
0x0000004100417308ULL, 0x000e620000000800ULL, 0x000000081d347824ULL, 0x000fc400078e00ffULL,
0xfffffff82e2e7812ULL, 0x000fe200078ee21fULL, 0x000000081d3a7824ULL, 0x040fe200078e00ffULL,
0x000000021d1f7810ULL, 0x040fe20007ffe0ffULL, 0x0000002c1030723cULL, 0x000f6400000418ffULL,
0x0000004400167308ULL, 0x000fe20000000800ULL, 0xfffffff834347812ULL, 0x000fe400078ee21fULL,
0x000000051d1f7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff83a3a7812ULL, 0x000fc400078ee22bULL,
0x0000000c022b7812ULL, 0x000fe200078ec0ffULL, 0x0000004500457308ULL, 0x000ea20000000800ULL,
0x000000144114723eULL, 0x002fce00000010ffULL, 0x0000004200157308ULL, 0x000ff00000000800ULL,
0x0000004300287308ULL, 0x000e620000000800ULL, 0x000000164516723eULL, 0x004fce00000010ffULL,
0x0000004600177308ULL, 0x000ff00000000800ULL, 0x00000047002a7308ULL, 0x000ea20000000800ULL,
0x000000152815723eULL, 0x002fce00000010ffULL, 0x0000004800187308ULL, 0x000fe20000000800ULL,
0x000000172a17723eULL, 0x004fce00000010ffULL, 0x0000004900497308ULL, 0x000e620000000800ULL,
0x000000081d2a7824ULL, 0x000fe200078e00ffULL, 0x0000002c1430723cULL, 0x020f680000041830ULL,
0xfffffff82a2a7812ULL, 0x000fe400078ee21dULL, 0x0000004c001a7308ULL, 0x000ff00000000800ULL,
0x0000004d004d7308ULL, 0x000ea20000000800ULL, 0x000000184918723eULL, 0x002fce00000010ffULL,
0x0000004a00197308ULL, 0x000ff00000000800ULL, 0x0000004b00207308ULL, 0x000e620000000800ULL,
0x0000001a4d1a723eULL, 0x004fce00000010ffULL, 0x0000004e001b7308ULL, 0x000ff00000000800ULL,
0x0000004f00227308ULL, 0x000ea20000000800ULL, 0x000000192019723eULL, 0x002fe400000010ffULL,
0x000000031d207810ULL, 0x000fc80007ffe0ffULL, 0xfffffff823367812ULL, 0x000fe200078ee220ULL,
0x0000000400097308ULL, 0x000fe20000000800ULL, 0x0000001b221b723eULL, 0x004fce00000010ffULL,
0x0000005000247308ULL, 0x000fe20000000800ULL, 0x0000002c1820723cULL, 0x020b6e0000041830ULL,
0x0000005100517308ULL, 0x000e620000000800ULL, 0x000000081d2d7810ULL, 0x060fe20007ffe0ffULL,
0x000000081d307824ULL, 0x000fcc00078e00ffULL, 0x0000005400267308ULL, 0x000ea20000000800ULL,
0x000000081d327824ULL, 0x000fe400078e00ffULL, 0x000000082d3c7824ULL, 0x000fe200078e00ffULL,
0xfffffff830307812ULL, 0x000fe400078ee21fULL, 0xfffffff832327812ULL, 0x000fe400078ee229ULL,
0x0000005200257308ULL, 0x000fe20000000800ULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee22dULL,
0x000000ffff2d7224ULL, 0x000fe200078e002cULL, 0x000000245124723eULL, 0x002fca00000010ffULL,
0x0000005300047308ULL, 0x000e620000000800ULL, 0x000000260926723eULL, 0x004fe400000010ffULL,
0x000120000a097811ULL, 0x000fca00078e58ffULL, 0x0000005600277308ULL, 0x000fe20000000800ULL,
0x000000102a027824ULL, 0x100fe400078e0209ULL, 0x00000010341d7824ULL, 0x100fe400078e0209ULL,
0x00000010361f7824ULL, 0x100fe400078e0209ULL, 0x0000001032297824ULL, 0x100fe200078e0209ULL,
0x0000000f00287308ULL, 0x0004e20000000800ULL, 0x000000250425723eULL, 0x002fe200000010ffULL,
0x000000102e047824ULL, 0x000fc400078e0209ULL, 0x000000012b1d7824ULL, 0x040fe400078e021dULL,
0x000000012b047824ULL, 0x040fe400078e0204ULL, 0x000000103a2a7824ULL, 0x100fe400078e0209ULL,
0x000000012b0f7824ULL, 0x044fe400078e0202ULL, 0x0000001030027824ULL, 0x000fe400078e0209ULL,
0x000000012b1f7824ULL, 0x000fe200078e021fULL, 0x000000100f007388ULL, 0x0003e20000000800ULL,
0x000000272827723eULL, 0x008fe200000010ffULL, 0x0000001038287824ULL, 0x000fc400078e0209ULL,
0x000000103c097824ULL, 0x000fe200078e0209ULL, 0x0000001204007388ULL, 0x0005e20000000800ULL,
0x000000012b287824ULL, 0x040fe400078e0228ULL, 0x0000002c242c723cULL, 0x000b620000041820ULL,
0x000000012b027824ULL, 0x040fe200078e0202ULL, 0x000000141d007388ULL, 0x0005e20000000800ULL,
0x000000012b297824ULL, 0x040fe200078e0229ULL, 0x0000000b1e0f7208ULL, 0x002fe20004800000ULL,
0x000000012b2a7824ULL, 0x040fe200078e022aULL, 0x000000161f007388ULL, 0x0005e20000000800ULL,
0x000000012b207824ULL, 0x020fc600078e0209ULL, 0x0000001828007388ULL, 0x0005e80000000800ULL,
0x0000001a02007388ULL, 0x0005e80000000800ULL, 0x0000002429007388ULL, 0x0005e80000000800ULL,
0x000000262a007388ULL, 0x0005e40000000800ULL, 0x000000ffff2d7224ULL, 0x000fc400078e002eULL,
0x0000001120007388ULL, 0x0005e80000000800ULL, 0x0004001304007388ULL, 0x0005e80000000800ULL,
0x000400151d007388ULL, 0x0005e80000000800ULL, 0x000400171f007388ULL, 0x0005e80000000800ULL,
0x0004001928007388ULL, 0x0005e80000000800ULL, 0x0004001b02007388ULL, 0x0005e80000000800ULL,
0x0004002529007388ULL, 0x0005e80000000800ULL, 0x000400272a007388ULL, 0x0005e80000000800ULL,
0x01c0000c00008388ULL, 0x0005e80000000c00ULL, 0x01c2002c00008388ULL, 0x0005e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01c60800d7ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01c61000d7ff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01c61800d7ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000071c00720cULL, 0x000fe20003f06070ULL,
0x01c62000d7ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ffff097224ULL, 0x000fd600078e001cULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffff824000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff107807ULL, 0x008fe20004000000ULL,
0xffffffffff4f7424ULL, 0x000fe200078e00ffULL, 0x00019a3000127802ULL, 0x000fc40000000f00ULL,
0x000011a000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff107224ULL, 0x000fe200078e004fULL,
0xfffe8e3000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x000fe20005800000ULL,
0xffffffffff4f7424ULL, 0x000fe200078e00ffULL, 0x00019a9000127802ULL, 0x000fc40000000f00ULL,
0x0000114000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff1e7224ULL, 0x000fe200078e004fULL,
0xfffe8e6000007947ULL, 0x000fea000383ffffULL, 0x0000001fff137424ULL, 0x000fe200078e00ffULL,
0x00019af000107802ULL, 0x002fe20000000f00ULL, 0xffffffffff127424ULL, 0x000fc400078e00ffULL,
0x000010a000007944ULL, 0x01cfea0003c00000ULL, 0xfffe8f0000007947ULL, 0x000fea000383ffffULL,
0x0000001fff137424ULL, 0x000fe200078e00ffULL, 0x00019b4000107802ULL, 0x002fe20000000f00ULL,
0xffffffffff127424ULL, 0x000fc400078e00ffULL, 0x0000105000007944ULL, 0x014fea0003c00000ULL,
0xfffe902000007947ULL, 0x000fea000383ffffULL, 0x000000ffff647224ULL, 0x000fe200078e001cULL,
0x00019ba000107802ULL, 0x000fe20000000f00ULL, 0x0000001fff137424ULL, 0x000fc400078e00ffULL,
0xffffffffff127424ULL, 0x000fc400078e00ffULL, 0x00000ff000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff1b7224ULL, 0x004fe200078e0012ULL, 0xfffe91c000007947ULL, 0x000fea000383ffffULL,
0x0000001fff137424ULL, 0x000fe200078e00ffULL, 0x00019c0000107802ULL, 0x000fe20000000f00ULL,
0xffffffffff127424ULL, 0x000fc400078e00ffULL, 0x00000f9000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff1a7224ULL, 0x004fe200078e0012ULL, 0xfffe919000007947ULL, 0x000fea000383ffffULL,
0x000000ffff647224ULL, 0x000fe200078e000eULL, 0x00019c7000107802ULL, 0x000fe20000000f00ULL,
0x0000001fff137424ULL, 0x000fe400078e00ffULL, 0xffffffffff127424ULL, 0x000fc400078e00ffULL,
0x00000f2000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff1b7224ULL, 0x004fe200078e0012ULL,
0xfffea51000007947ULL, 0x000fea000383ffffULL, 0x0000001fff137424ULL, 0x000fe200078e00ffULL,
0x00019cd000107802ULL, 0x000fe20000000f00ULL, 0xffffffffff127424ULL, 0x000fc400078e00ffULL,
0x00000ec000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff1a7224ULL, 0x004fe200078e0012ULL,
0xfffea4e000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x008fe20004000000ULL,
0xffffffffff4f7424ULL, 0x000fe200078e00ffULL, 0x00019d3000127802ULL, 0x000fc40000000f00ULL,
0x00000ea000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff4e7224ULL, 0x000fe200078e004fULL,
0xfffebad000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x000fe20005000000ULL,
0xffffffffff4f7424ULL, 0x000fe200078e00ffULL, 0x00019d9000127802ULL, 0x000fc40000000f00ULL,
0x00000e4000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff337224ULL, 0x000fe200078e004fULL,
0xfffebb0000007947ULL, 0x000fea000383ffffULL, 0x0000001fff137424ULL, 0x000fe200078e00ffULL,
0x00019df000107802ULL, 0x000fe20000000f00ULL, 0xffffffffff127424ULL, 0x000fc400078e00ffULL,
0x00000da000007944ULL, 0x014fea0003c00000ULL, 0xfffebbc000007947ULL, 0x000fea000383ffffULL,
0x0000001fff137424ULL, 0x000fe200078e00ffULL, 0x00019e4000107802ULL, 0x000fe20000000f00ULL,
0xffffffffff127424ULL, 0x000fc400078e00ffULL, 0x00000d5000007944ULL, 0x014fea0003c00000ULL,
0xfffebcd000007947ULL, 0x000fea000383ffffULL, 0x000000ffff647224ULL, 0x000fe200078e004cULL,
0x00019ea000107802ULL, 0x000fe20000000f00ULL, 0x0000001fff137424ULL, 0x000fc400078e00ffULL,
0xffffffffff127424ULL, 0x000fc400078e00ffULL, 0x00000cf000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff1b7224ULL, 0x004fe200078e0012ULL, 0xfffebe7000007947ULL, 0x000fea000383ffffULL,
0x0000001fff137424ULL, 0x000fe200078e00ffULL, 0x00019f0000107802ULL, 0x000fe20000000f00ULL,
0xffffffffff127424ULL, 0x000fc400078e00ffULL, 0x00000c9000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff1a7224ULL, 0x004fe200078e0012ULL, 0xfffebe4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff647224ULL, 0x000fe200078e003cULL, 0x00019f7000107802ULL, 0x000fe20000000f00ULL,
0x0000001fff137424ULL, 0x000fe400078e00ffULL, 0xffffffffff127424ULL, 0x000fc400078e00ffULL,
0x00000c2000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff1b7224ULL, 0x004fe200078e0012ULL,
0xfffecf0000007947ULL, 0x000fea000383ffffULL, 0x0000001fff137424ULL, 0x000fe200078e00ffULL,
0x00019fd000107802ULL, 0x000fe20000000f00ULL, 0xffffffffff127424ULL, 0x000fc400078e00ffULL,
0x00000bc000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff1a7224ULL, 0x004fe200078e0012ULL,
0xfffeced000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x008fe20004000000ULL,
0xffffffffff4f7424ULL, 0x000fe200078e00ffULL, 0x0001a03000127802ULL, 0x000fc40000000f00ULL,
0x00000ba000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff4e7224ULL, 0x000fe200078e004fULL,
0xfffee36000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x000fe20005000000ULL,
0xffffffffff4f7424ULL, 0x000fe200078e00ffULL, 0x0001a09000127802ULL, 0x000fc40000000f00ULL,
0x00000b4000007944ULL, 0x014fea0003c00000ULL, 0xfffee39000007947ULL, 0x000fea000383ffffULL,
0x0000001fff137424ULL, 0x000fe200078e00ffULL, 0x0001a0e000107802ULL, 0x000fe20000000f00ULL,
0xffffffffff127424ULL, 0x000fc400078e00ffULL, 0x00000ab000007944ULL, 0x014fea0003c00000ULL,
0xfffee45000007947ULL, 0x000fea000383ffffULL, 0x0000001fff137424ULL, 0x000fe200078e00ffULL,
0x0001a13000107802ULL, 0x000fe20000000f00ULL, 0xffffffffff127424ULL, 0x000fc400078e00ffULL,
0x00000a6000007944ULL, 0x014fea0003c00000ULL, 0xfffee56000007947ULL, 0x000fea000383ffffULL,
0x000000ffff647224ULL, 0x000fe200078e004cULL, 0x0001a19000107802ULL, 0x000fe20000000f00ULL,
0x0000001fff137424ULL, 0x000fc400078e00ffULL, 0xffffffffff127424ULL, 0x000fc400078e00ffULL,
0x00000a0000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff1b7224ULL, 0x004fe200078e0012ULL,
0xfffee70000007947ULL, 0x000fea000383ffffULL, 0x0000001fff137424ULL, 0x000fe200078e00ffULL,
0x0001a1f000107802ULL, 0x000fe20000000f00ULL, 0xffffffffff127424ULL, 0x000fc400078e00ffULL,
0x000009a000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff1a7224ULL, 0x004fe200078e0012ULL,
0xfffee6d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff647224ULL, 0x000fe200078e0038ULL,
0x0001a26000107802ULL, 0x000fe20000000f00ULL, 0x0000001fff137424ULL, 0x000fe400078e00ffULL,
0xffffffffff127424ULL, 0x000fc400078e00ffULL, 0x0000093000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff1b7224ULL, 0x004fe200078e0012ULL, 0xfffef79000007947ULL, 0x000fea000383ffffULL,
0x0000001fff137424ULL, 0x000fe200078e00ffULL, 0x0001a2c000107802ULL, 0x000fe20000000f00ULL,
0xffffffffff127424ULL, 0x000fc400078e00ffULL, 0x000008d000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff1a7224ULL, 0x004fe200078e0012ULL, 0xfffef76000007947ULL, 0x000fea000383ffffULL,
0x00000001ff107807ULL, 0x008fe20004000000ULL, 0xffffffffff4f7424ULL, 0x000fe200078e00ffULL,
0x0001a32000127802ULL, 0x000fc40000000f00ULL, 0x000008b000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff4d7224ULL, 0x000fe200078e004fULL, 0xffff0bf000007947ULL, 0x000fea000383ffffULL,
0x00000001ff107807ULL, 0x000fe20004800000ULL, 0xffffffffff4f7424ULL, 0x000fe200078e00ffULL,
0x0001a38000127802ULL, 0x000fc40000000f00ULL, 0x0000085000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff4e7224ULL, 0x000fe200078e004fULL, 0xffff0c1000007947ULL, 0x000fea000383ffffULL,
0x0000001fff137424ULL, 0x000fe200078e00ffULL, 0x0001a3e000107802ULL, 0x000fe20000000f00ULL,
0xffffffffff127424ULL, 0x000fc400078e00ffULL, 0x000007b000007944ULL, 0x014fea0003c00000ULL,
0xffff0cd000007947ULL, 0x000fea000383ffffULL, 0x0000001fff137424ULL, 0x000fe200078e00ffULL,
0x0001a43000107802ULL, 0x000fe20000000f00ULL, 0xffffffffff127424ULL, 0x000fc400078e00ffULL,
0x0000076000007944ULL, 0x014fea0003c00000ULL, 0xffff0de000007947ULL, 0x000fea000383ffffULL,
0x000000ffff647224ULL, 0x000fe200078e0018ULL, 0x0001a49000107802ULL, 0x000fe20000000f00ULL,
0x0000001fff137424ULL, 0x000fc400078e00ffULL, 0xffffffffff127424ULL, 0x000fc400078e00ffULL,
0x0000070000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff1b7224ULL, 0x004fe200078e0012ULL,
0xffff0f8000007947ULL, 0x000fea000383ffffULL, 0x0000001fff137424ULL, 0x000fe200078e00ffULL,
0x0001a4f000107802ULL, 0x000fe20000000f00ULL, 0xffffffffff127424ULL, 0x000fc400078e00ffULL,
0x000006a000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff1a7224ULL, 0x004fe200078e0012ULL,
0xffff0f5000007947ULL, 0x000fea000383ffffULL, 0x000000ffff647224ULL, 0x000fe200078e0018ULL,
0x0001a56000107802ULL, 0x000fe20000000f00ULL, 0x0000001fff137424ULL, 0x000fe400078e00ffULL,
0xffffffffff127424ULL, 0x000fc400078e00ffULL, 0x0000063000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff1b7224ULL, 0x004fe200078e0012ULL, 0xffff204000007947ULL, 0x000fea000383ffffULL,
0x0000001fff137424ULL, 0x000fe200078e00ffULL, 0x0001a5c000107802ULL, 0x000fe20000000f00ULL,
0xffffffffff127424ULL, 0x000fc400078e00ffULL, 0x000005d000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff1a7224ULL, 0x004fe200078e0012ULL, 0xffff201000007947ULL, 0x000fea000383ffffULL,
0x00000002ff127424ULL, 0x000fe200078e00ffULL, 0x0001a63000107802ULL, 0x000fe20000000f00ULL,
0x0000001fff047424ULL, 0x000fc400078e00ffULL, 0xffffffffff177424ULL, 0x000fc400078e00ffULL,
0x0000052000007944ULL, 0x006fea0003c00000ULL, 0xffffe67000007947ULL, 0x000fea000383ffffULL,
0x000000ffff097224ULL, 0x008fe200078e000bULL, 0x0001a6a000107802ULL, 0x000fe20000000f00ULL,
0x00000002ff127424ULL, 0x000fe400078e00ffULL, 0x0000001fff047424ULL, 0x000fe400078e00ffULL,
0xffffffffff177424ULL, 0x000fc400078e00ffULL, 0x000004b000007944ULL, 0x000fea0003c00000ULL,
0x000000040b00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff097224ULL, 0x002fe200078e000eULL,
0x0001a72000107802ULL, 0x000fe20000000f00ULL, 0x00000002ff127424ULL, 0x000fe200078e00ffULL,
0x0000000b040d7208ULL, 0x000fe20004000000ULL, 0x0000001fff047424ULL, 0x000fc400078e00ffULL,
0xffffffffff177424ULL, 0x000fc400078e00ffULL, 0x0000043000007944ULL, 0x000fea0003c00000ULL,
0x000000040e00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff097224ULL, 0x002fe200078e000fULL,
0x0001a7a000107802ULL, 0x000fe20000000f00ULL, 0x00000002ff127424ULL, 0x000fe200078e00ffULL,
0x0000000e04157208ULL, 0x000fe20004000000ULL, 0x0000001fff047424ULL, 0x000fe400078e00ffULL,
0xffffffffff177424ULL, 0x000fc400078e00ffULL, 0x000003b000007944ULL, 0x000fea0003c00000ULL,
0x000000040f00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff097224ULL, 0x002fe200078e0013ULL,
0x0001a82000107802ULL, 0x000fe20000000f00ULL, 0x00000001ff127424ULL, 0x000fe200078e00ffULL,
0x0000000f040b7208ULL, 0x000fe20004000000ULL, 0x0000001fff047424ULL, 0x000fc400078e00ffULL,
0xffffffffff177424ULL, 0x000fc400078e00ffULL, 0x0000033000007944ULL, 0x000fea0003c00000ULL,
0x000000041300720bULL, 0x004fe20003f1e000ULL, 0x000000ffff097224ULL, 0x002fe200078e000dULL,
0x0001a8a000107802ULL, 0x000fe20000000f00ULL, 0x00000001ff127424ULL, 0x000fe200078e00ffULL,
0x00000013040c7208ULL, 0x000fe20004000000ULL, 0x0000001fff047424ULL, 0x000fe400078e00ffULL,
0xffffffffff177424ULL, 0x000fc400078e00ffULL, 0x000002b000007944ULL, 0x000fea0003c00000ULL,
0x000000040d00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff097224ULL, 0x002fe200078e0015ULL,
0x0001a92000107802ULL, 0x000fe20000000f00ULL, 0x00000001ff127424ULL, 0x000fe200078e00ffULL,
0x0000000d040d7208ULL, 0x000fe20004000000ULL, 0x0000001fff047424ULL, 0x000fc400078e00ffULL,
0xffffffffff177424ULL, 0x000fc400078e00ffULL, 0x0000023000007944ULL, 0x000fea0003c00000ULL,
0x000000041500720bULL, 0x004fe20003f1e000ULL, 0x000000ffff097224ULL, 0x002fe200078e000bULL,
0x0001a9a000107802ULL, 0x000fe20000000f00ULL, 0x00000001ff127424ULL, 0x000fe200078e00ffULL,
0x00000015040e7208ULL, 0x000fe20004000000ULL, 0x0000001fff047424ULL, 0x000fe400078e00ffULL,
0xffffffffff177424ULL, 0x000fc400078e00ffULL, 0x000001b000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff1e7224ULL, 0x004fe200078e0004ULL, 0xffffe45000007947ULL, 0x000fea000383ffffULL,
0x0180000006047810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000004057812ULL, 0x000fc800078ec0ffULL, 0x018000000500780cULL, 0x000fda0003f05070ULL,
0x0000000600048308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0500720cULL, 0x040fe40003f25070ULL, 0x008000000500780cULL, 0x000fe40003f02070ULL,
0x00000001ff057807ULL, 0x000fe40000800000ULL, 0x00000001ff047807ULL, 0x004fc80004000000ULL,
0x0000000405ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff06ff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff047807ULL, 0x000fc80000000000ULL,
0x0000000405ff7212ULL, 0x000fe4000780c0ffULL, 0x8000000006057812ULL, 0x000fd600078ec0ffULL,
0x0080000005040812ULL, 0x000fe200078efcffULL, 0x000000ffff048224ULL, 0x000fe200078e0005ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000600047308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff077224ULL, 0x00cfe400078e0004ULL,
0x000000ffff047224ULL, 0x000fe400078e0008ULL, 0x00000000ff057424ULL, 0x000fc800078e00ffULL,
0xfffe54b004007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff117424ULL, 0x000fe200078e00ffULL,
0x0000001700007348ULL, 0x000fe80003800000ULL, 0x0c00001209047389ULL, 0x0002a200000e0004ULL,
0xfffe547010007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff117424ULL, 0x000fe200078e00ffULL,
0x0000001200007348ULL, 0x000fe80003800000ULL, 0x0000006465127389ULL, 0x0002a200000e0013ULL,
0xfffe543010007950ULL, 0x000fea0003c3ffffULL, 0x000000011000780cULL, 0x000fe20003f65070ULL,
0x0000004f00007348ULL, 0x000fe80003800000ULL, 0x00000000ff117424ULL, 0x000fd000078e00ffULL,
0x0000000000107806ULL, 0x000fc800058e0100ULL, 0x0000004f104f7212ULL, 0x000fe200078ec0ffULL,
0x000000ffff107224ULL, 0x000fc800078e0012ULL, 0xfffe53c010007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000001ULL, 0x0000000800000001ULL, 0x0000000100000001ULL, 0x0000000800000004ULL,
0x0000001000000001ULL, 0x0000000300000001ULL, 0x0000000400000004ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x000000000000054aULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000006a8ULL,
0x0000000000000258ULL, 0x0000001800000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000900ULL,
0x00000000000002c8ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000bc8ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c88ULL,
0x0000000000000670ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000012f8ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001308ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000007bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001398ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x000000000000139cULL,
0x00000000000001b0ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001580ULL,
0x000000000001ad00ULL, 0xdd00001800000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x0000000100000089ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001c280ULL,
0x000000000000003cULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001c2c0ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x000000000001c640ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001398ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000001aee8ULL,
0x000000000001aee8ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x000000000001c280ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x000000000001c640ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_1_kvt_bf16_pagedKV_64_nqpkv_8_m_8_sm_80_cubin_len = 116512;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
