/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_1_kvt_e4m3_nqpkv_8_m_8_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001dd50ULL, 0x000000000001d9d0ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f34314944327961ULL, 0x6f6c66625f766e5fULL,
0x326a4c3236317461ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL,
0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x336a4c4536316a4cULL, 0x4c49746132454532ULL,
0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45346a4c4534366aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL,
0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL,
0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL, 0x45326a4c4545316aULL, 0x7461324545316a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x4939494432796172ULL, 0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL,
0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL,
0x4c4545346a4c6a49ULL, 0x36316a4c4532336aULL, 0x624c497461324545ULL, 0x31534b5245454531ULL,
0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL,
0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL, 0x4c4545326a4c4532ULL, 0x4545316a4c45326aULL,
0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x45386a4c4545346aULL,
0x7461324545386a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL,
0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL,
0x6a4c4536316a4c45ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5f2400676e696469ULL, 0x616e7265746e695fULL, 0x635f5f245f305f6cULL,
0x30326d735f616475ULL, 0x5f6e725f7063725fULL, 0x5f3233665f7a7466ULL, 0x68746170776f6c73ULL,
0x65746e695f5f2400ULL, 0x245f315f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL,
0x6c66625f636e7973ULL, 0x695f5f2400705f79ULL, 0x5f6c616e7265746eULL, 0x6475635f5f245f32ULL,
0x735f30376d735f61ULL, 0x5f636e79736c6668ULL, 0x5f2400705f786469ULL, 0x616e7265746e695fULL,
0x635f5f245f335f6cULL, 0x30376d735f616475ULL, 0x6e797365746f765fULL, 0x746f6c6c61625f63ULL,
0x742e616c65722e00ULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL,
0x5f6c656e72656b2eULL, 0x72656b240061686dULL, 0x2461686d5f6c656eULL, 0x657479426d656d73ULL,
0x2e766e2e00667542ULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x61705f0061686d5fULL,
0x6265642e006d6172ULL, 0x656d6172665f6775ULL, 0x65642e6c65722e00ULL, 0x6d6172665f677562ULL,
0x2e616c65722e0065ULL, 0x72665f6775626564ULL, 0x2e766e2e00656d61ULL, 0x697463612e6c6572ULL,
0x0000000000006e6fULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c0001000000adULL, 0x0000000000000034ULL, 0x0000000000000010ULL, 0x000c0001000000ebULL,
0x000000000000001cULL, 0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c00010000016bULL, 0x000000000000002cULL, 0x0000000000000004ULL,
0x000c0001000001b5ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c0001000001fbULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000242ULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000c000100000288ULL, 0x0000000000000030ULL, 0x0000000000000004ULL,
0x000c0001000002d6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c000100000324ULL,
0x0000000000000018ULL, 0x0000000000000004ULL, 0x000c000100000372ULL, 0x000000000000000cULL,
0x0000000000000004ULL, 0x000c0001000003b9ULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000c000100000407ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c00010000044cULL,
0x0000000000000020ULL, 0x0000000000000004ULL, 0x000b002200000492ULL, 0x000000000001bbc0ULL,
0x0000000000000180ULL, 0x000b0022000004c5ULL, 0x000000000001bd40ULL, 0x0000000000000040ULL,
0x000b0022000004f0ULL, 0x000000000001bd80ULL, 0x0000000000000040ULL, 0x000b00220000051aULL,
0x000000000001bdc0ULL, 0x0000000000000140ULL, 0x000a000300000588ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00040003000005a8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00070003000005d8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL,
0x0000000000000000ULL, 0x000000000001bf00ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0001bbc000000000ULL,
0x0000040400000000ULL, 0x810c0000015c0400ULL, 0x006d880400288080ULL, 0x0000000000000000ULL,
0x0000007cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8808288080820828ULL, 0x2880808908288080ULL,
0x8090082880808e08ULL, 0x0828808092082880ULL, 0x80809e0828808093ULL, 0xc608288080c20828ULL,
0x288080d208288080ULL, 0x808408288080d508ULL, 0x1028808280162880ULL, 0x0000000000000003ULL,
0x2200288080849200ULL, 0x00000034ffffffffULL, 0x0000007000000000ULL, 0x0001bbc000000000ULL,
0x0000018000000000ULL, 0x0000480400000000ULL, 0x8080288080820900ULL, 0x0900000010042880ULL,
0x2880808228808084ULL, 0x0000007cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8408288080820828ULL,
0x2880808908288080ULL, 0x8090082880808e08ULL, 0x0828808092082880ULL, 0x80809e0828808093ULL,
0xc608288080c20828ULL, 0x288080d508288080ULL, 0x8280162880808808ULL, 0x0000000003102880ULL,
0x8080889200000000ULL, 0x0000000000220028ULL, 0x0000001cffffffffULL, 0x0000013800000000ULL,
0x0001bd4000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000007cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8408288080820828ULL, 0x2880808808288080ULL, 0x808e082880808908ULL,
0x0828808090082880ULL, 0x8080930828808092ULL, 0xc6082880809e0828ULL, 0x288080d208288080ULL,
0x80c208288080d508ULL, 0x1028808280162880ULL, 0x0000000000000003ULL, 0x2200288080c29200ULL,
0x0000001cffffffffULL, 0x000001e800000000ULL, 0x0001bd8000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x0000007cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8408288080820828ULL,
0x2880808808288080ULL, 0x808e082880808908ULL, 0x0828808090082880ULL, 0x8080930828808092ULL,
0xc2082880809e0828ULL, 0x288080d208288080ULL, 0x80c608288080d508ULL, 0x1028808280162880ULL,
0x0000000000000003ULL, 0x2200288080c69200ULL, 0x0000002cffffffffULL, 0x0000029800000000ULL,
0x0001bdc000000000ULL, 0x0000014000000000ULL, 0x0000180400000000ULL, 0x80c2288080c60900ULL,
0x0000000000002880ULL, 0x0000001a00082f04ULL, 0x0008230400000096ULL, 0x0000000000000016ULL,
0x0000001600081204ULL, 0x0008110400000000ULL, 0x0000000000000016ULL, 0x0000001500082304ULL,
0x0008120400000000ULL, 0x0000000000000015ULL, 0x0000001500081104ULL, 0x0008230400000000ULL,
0x0000000000000014ULL, 0x0000001400081204ULL, 0x0008110400000000ULL, 0x0000000000000014ULL,
0x0000001300082304ULL, 0x0008120400000000ULL, 0x0000000000000013ULL, 0x0000001300081104ULL,
0x0008230400000000ULL, 0x000000000000001aULL, 0x0000001a00081204ULL, 0x0008110400000000ULL,
0x000000000000001aULL, 0x0000007b00043704ULL, 0x0000001700080a04ULL, 0x0048190300480160ULL,
0x00000000000c1704ULL, 0x0021f00000400006ULL, 0x00000000000c1704ULL, 0x0021f00000380005ULL,
0x00000000000c1704ULL, 0x0011f00000300004ULL, 0x00000000000c1704ULL, 0x0061f00000180003ULL,
0x00000000000c1704ULL, 0x0021f00000100002ULL, 0x00000000000c1704ULL, 0x0021f00000080001ULL,
0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x0004310400ff1b03ULL, 0x0198290400000020ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0000010001982804ULL,
0x0000046000000120ULL, 0x00001d3000001c80ULL, 0x00001f9000001e20ULL, 0x00002410000023e0ULL,
0x000024b000002460ULL, 0x0000493000004900ULL, 0x000049d000004980ULL, 0x00006ed000006e40ULL,
0x0000714000006fe0ULL, 0x000075e0000075b0ULL, 0x0000768000007630ULL, 0x0000993000009900ULL,
0x000099d000009980ULL, 0x0000bdc00000bd30ULL, 0x0000c0300000bed0ULL, 0x0000c4d00000c4a0ULL,
0x0000c5700000c520ULL, 0x0000e8200000e7f0ULL, 0x0000e8c00000e870ULL, 0x00010cc000010c30ULL,
0x00010f3000010dd0ULL, 0x000113d0000113a0ULL, 0x0001147000011420ULL, 0x0001374000013710ULL,
0x000137e000013790ULL, 0x000150a000015090ULL, 0x0001a11000015850ULL, 0x0001a1600001a150ULL,
0x0001a1c00001a170ULL, 0x0001a2000001a1e0ULL, 0x0001ae600001a210ULL, 0x0001af100001aeb0ULL,
0x0001afd00001af70ULL, 0x0001b0900001b030ULL, 0x0001b1300001b0e0ULL, 0x0001b1d00001b180ULL,
0x0001b2800001b220ULL, 0x0001b3300001b2d0ULL, 0x0001b3d00001b380ULL, 0x0001b4600001b420ULL,
0x0001b5100001b4b0ULL, 0x0001b5c00001b560ULL, 0x0001b6600001b610ULL, 0x0001b7000001b6b0ULL,
0x0001b7b00001b750ULL, 0x0001b8600001b800ULL, 0x0001b9000001b8b0ULL, 0x0001b9c00001b960ULL,
0x0001ba800001ba20ULL, 0x0001bb400001bae0ULL, 0x060039040001bba0ULL, 0x000000ff00000200ULL,
0x003f010000010600ULL, 0x0000000f00000250ULL, 0x003f012000010608ULL, 0x0000000f000002f0ULL,
0x003f012000010688ULL, 0x0000000f00000400ULL, 0x003f0120000106a8ULL, 0x000000ff00000430ULL,
0x003f0100000106b8ULL, 0x000000ff00000500ULL, 0x003f010700010600ULL, 0x0000001400000600ULL,
0x003f01020001068cULL, 0x0000001400000690ULL, 0x003f010100010688ULL, 0x000000ff00000d10ULL,
0x003f0107000106a8ULL, 0x000000ff00000e30ULL, 0x003f0101000106a8ULL, 0x000000ff00000e90ULL,
0x003f0101000106b8ULL, 0x000000ff00000fc0ULL, 0x003f0105000106bcULL, 0x000000ff00001190ULL,
0x003f0105000106bcULL, 0x000000ff000018c0ULL, 0x003f0107000106b0ULL, 0x000000ff00001940ULL,
0x003f0101000106b0ULL, 0x00000014000019a0ULL, 0x003f010100010608ULL, 0x00000014000019c0ULL,
0x003f01050001060cULL, 0x0000001400001b90ULL, 0x003f01050001060cULL, 0x000000ff00002140ULL,
0x003f0105000106acULL, 0x000000ff00002310ULL, 0x003f0105000106acULL, 0x000000ff00003d10ULL,
0x003f0101000106b8ULL, 0x000000ff00003d40ULL, 0x003f0105000106bcULL, 0x000000ff00003f00ULL,
0x003f0105000106bcULL, 0x000000ff000045e0ULL, 0x003f0107000106a8ULL, 0x000000ff00004660ULL,
0x003f0101000106a8ULL, 0x000000ff00004680ULL, 0x003f0105000106b4ULL, 0x000000ff00004850ULL,
0x003f0105000106b4ULL, 0x000000ff00006160ULL, 0x003f0101000106b8ULL, 0x000000ff000061d0ULL,
0x003f010100010688ULL, 0x000000ff00006230ULL, 0x003f0105000106bcULL, 0x000000ff00006400ULL,
0x003f0105000106bcULL, 0x000000ff00006ae0ULL, 0x003f0107000106b0ULL, 0x000000ff00006b60ULL,
0x003f0101000106b0ULL, 0x0000001400006bc0ULL, 0x003f010100010628ULL, 0x0000001400006be0ULL,
0x003f01050001062cULL, 0x0000001400006db0ULL, 0x003f01050001062cULL, 0x000000ff00007310ULL,
0x003f0105000106acULL, 0x000000ff000074e0ULL, 0x003f0105000106acULL, 0x000000ff00008d00ULL,
0x003f0101000106b8ULL, 0x000000ff00008d30ULL, 0x003f0105000106bcULL, 0x000000ff00008ef0ULL,
0x003f0105000106bcULL, 0x000000ff000095d0ULL, 0x003f0107000106a8ULL, 0x000000ff00009650ULL,
0x003f0101000106a8ULL, 0x000000ff00009680ULL, 0x003f0105000106b4ULL, 0x000000ff00009850ULL,
0x003f0105000106b4ULL, 0x000000ff0000b060ULL, 0x003f0101000106b8ULL, 0x000000ff0000b0d0ULL,
0x003f010100010690ULL, 0x000000ff0000b120ULL, 0x003f0105000106bcULL, 0x000000ff0000b2f0ULL,
0x003f0105000106bcULL, 0x000000ff0000b9d0ULL, 0x003f0107000106b0ULL, 0x000000ff0000ba50ULL,
0x003f0101000106b0ULL, 0x000000140000bab0ULL, 0x003f010100010648ULL, 0x000000140000bad0ULL,
0x003f01050001064cULL, 0x000000140000bca0ULL, 0x003f01050001064cULL, 0x000000ff0000c200ULL,
0x003f0105000106acULL, 0x000000ff0000c3d0ULL, 0x003f0105000106acULL, 0x000000ff0000dbf0ULL,
0x003f0101000106b8ULL, 0x000000ff0000dc20ULL, 0x003f0105000106bcULL, 0x000000ff0000dde0ULL,
0x003f0105000106bcULL, 0x000000ff0000e4c0ULL, 0x003f0107000106a8ULL, 0x000000ff0000e540ULL,
0x003f0101000106a8ULL, 0x000000ff0000e570ULL, 0x003f0105000106b4ULL, 0x000000ff0000e740ULL,
0x003f0105000106b4ULL, 0x000000ff0000ff50ULL, 0x003f0101000106b8ULL, 0x000000ff0000ffc0ULL,
0x003f010100010698ULL, 0x000000ff00010020ULL, 0x003f0105000106bcULL, 0x000000ff000101f0ULL,
0x003f0105000106bcULL, 0x000000ff000108d0ULL, 0x003f0107000106b0ULL, 0x000000ff00010950ULL,
0x003f0101000106b0ULL, 0x00000014000109b0ULL, 0x003f010100010668ULL, 0x00000014000109d0ULL,
0x003f01050001066cULL, 0x0000001400010ba0ULL, 0x003f01050001066cULL, 0x000000ff00011100ULL,
0x003f0105000106acULL, 0x000000ff000112d0ULL, 0x003f0105000106acULL, 0x000000ff00012af0ULL,
0x003f0101000106b8ULL, 0x000000ff00012b20ULL, 0x003f0105000106bcULL, 0x000000ff00012ce0ULL,
0x003f0105000106bcULL, 0x000000ff000133e0ULL, 0x003f0107000106a8ULL, 0x000000ff00013460ULL,
0x003f0101000106a8ULL, 0x000000ff00013490ULL, 0x003f0105000106b4ULL, 0x000000ff00013660ULL,
0x003f0105000106b4ULL, 0x000000ff00014e70ULL, 0x003f0101000106b8ULL, 0x000000ff00014ed0ULL,
0x003f0101000106a0ULL, 0x000000ff00015a60ULL, 0x003f010100010600ULL, 0x000000ff00016550ULL,
0x003f010500010604ULL, 0x000000ff00016720ULL, 0x003f010500010604ULL, 0x000000ff00016aa0ULL,
0x003f010100010600ULL, 0x000000ff00016ad0ULL, 0x003f010500010604ULL, 0x000000ff00016c90ULL,
0x003f010500010604ULL, 0x0000001700019540ULL, 0x003f010100000000ULL, 0x0000001700019640ULL,
0x003f010500000004ULL, 0x0000001700019810ULL, 0x003f010500000004ULL, 0x0000001a0001acc0ULL,
0x003f010100000000ULL, 0x0000001a0001ad20ULL, 0x003f010100000008ULL, 0x0000001a0001ad80ULL,
0x003f010100000010ULL, 0x0000001a0001adf0ULL, 0x003f010100000018ULL, 0x00101c0400053803ULL,
0x00016cf0000159b0ULL, 0x0001ae3000016da0ULL, 0x000c050400000401ULL, 0x0000000100000100ULL,
0x00041e0400000001ULL, 0x0000000000000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x0000000000000334ULL, 0x0000001a00000002ULL, 0x0000000000000284ULL, 0x0000001a00000002ULL,
0x00000000000001d4ULL, 0x0000001a00000002ULL, 0x000000000000010cULL, 0x0000001a00000002ULL,
0x0000000000000044ULL, 0x0000001a00000002ULL, 0x0000000000000311ULL, 0x0000001a00000002ULL,
0x0000000000000261ULL, 0x0000001a00000002ULL, 0x00000000000001acULL, 0x0000001a00000002ULL,
0x00000000000000e9ULL, 0x0000001a00000002ULL, 0x0000000000010700ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x00000000000f7919ULL, 0x000e620000002100ULL,
0x0000000000137806ULL, 0x000fe200038e0000ULL, 0x00005800ff057624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000027919ULL, 0x000ea20000002300ULL,
0x0000001300067300ULL, 0x000ee200000e0000ULL, 0x0000000805057824ULL, 0x000fe400078e00ffULL,
0x0000000000037919ULL, 0x000f220000002200ULL, 0x00000200ff0b7424ULL, 0x000fc600078e00ffULL,
0x0000000000177919ULL, 0x000ee20000000000ULL, 0x0000001300137309ULL, 0x000ea60000000000ULL,
0x0000000000127919ULL, 0x000ee80000002600ULL, 0x0000000000107919ULL, 0x000ee20000002700ULL,
0x00000005ff187819ULL, 0x002fc6000001160fULL, 0x0000000000077919ULL, 0x000e680000000000ULL,
0x00001fff020d7589ULL, 0x0045e200000e0000ULL, 0x0000010002007a24ULL, 0x010fc600078e0203ULL,
0x00001fff18187589ULL, 0x000f2200000e0000ULL, 0x00000000000f7a24ULL, 0x000fe400078e020fULL,
0x00000010170c7824ULL, 0x008fe400078e00ffULL, 0x0000000812007824ULL, 0x000fe200078e00ffULL,
0x000000ff0f00720cULL, 0x040fe40003f25270ULL, 0x0000000f0f00780cULL, 0x000fe20003f44070ULL,
0x0000001005007224ULL, 0x000fe200078e0200ULL, 0x000000030f00780cULL, 0x000fc40003f64070ULL,
0x0000007f0f00780cULL, 0x000fe40003f84070ULL, 0x000000070600720cULL, 0x002fca0003f02070ULL,
0x3fffff80ff029424ULL, 0x004fe400078e00ffULL, 0x7fffff80ff039424ULL, 0x000fe400078e00ffULL,
0x000000040d047824ULL, 0x010fe400078e0218ULL, 0x7fffffc0ff05a424ULL, 0x000fe200078e00ffULL,
0x01060002ff009388ULL, 0x0003e20000000a00ULL, 0x0000000204087824ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff04a424ULL, 0x000fc400078e00ffULL, 0x0000000108097824ULL, 0x040fe400078e0217ULL,
0x00000020080e7824ULL, 0x000fe200078e00ffULL, 0x010608040f00a388ULL, 0x0005e20000008a00ULL,
0x000000010f00780cULL, 0x000fe20003f44070ULL, 0x0000000100027824ULL, 0x002fe400078e0208ULL,
0xffffffe00e0e7812ULL, 0x000fe200078ee209ULL, 0x3fffff60ff06b424ULL, 0x000fe200078e00ffULL,
0x0000000808097817ULL, 0x000fe20007800000ULL, 0x7fffff60ff07b424ULL, 0x000fc400078e00ffULL,
0xff317217ff0ac424ULL, 0x000fe400078e00ffULL, 0x0000000109097824ULL, 0x000fe200078e0a08ULL,
0x0000000108087810ULL, 0x000fe20007ffe0ffULL, 0x010688060f00b388ULL, 0x0003e20000008a00ULL,
0x00005c0002027625ULL, 0x000fe400078e000bULL, 0x000000ff0900720cULL, 0x040fe20003f63070ULL,
0x0104000a0f00c388ULL, 0x0007e20000004800ULL, 0x0000000100047824ULL, 0x004fe200078e0208ULL,
0x000000010900780cULL, 0x000fe20003f83070ULL, 0x0000000108007824ULL, 0x000fc400078e0217ULL,
0x0000002008117824ULL, 0x000fe400078e00ffULL, 0x00005c0004047625ULL, 0x000fe200078e000bULL,
0x000001f00c077812ULL, 0x002fe400078ec0ffULL, 0xffffffe011007812ULL, 0x000fe200078ee200ULL,
0x3fffff00ff08a424ULL, 0x000fe200078e00ffULL, 0x0000000702067210ULL, 0x080fe20007fbe0ffULL,
0x7fffff00ff09a424ULL, 0x000fe200078e00ffULL, 0x0000000704047210ULL, 0x000fe20007fde0ffULL,
0x3fffff80ff0a9424ULL, 0x008fc400078e00ffULL, 0x7fffff80ff0b9424ULL, 0x000fe200078e00ffULL,
0x0106a8080f00a388ULL, 0x000fe20000008a00ULL, 0x000000ffff027224ULL, 0x000fe400078e0a13ULL,
0x000000ffff077224ULL, 0x000fe200028e0603ULL, 0x0106b80aff009388ULL, 0x000fe20000000a00ULL,
0x000000100e117824ULL, 0x000fe400078e00ffULL, 0x000000ffff057224ULL, 0x000fe200030e0605ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000001000137824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006117faeULL, 0x0003e2000d901c46ULL,
0x000000ffff007224ULL, 0x000fc400078e0002ULL, 0x00000004ff037424ULL, 0x000fe200078e00ffULL,
0x0000000004137faeULL, 0x0003e6000e101c46ULL, 0x0000600010027625ULL, 0x000fe200078e0003ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x01060400ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01060000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000602157981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0d00720cULL, 0x000fc40003f05270ULL,
0x000000ff15007810ULL, 0x006fc80007ffe0ffULL, 0x00000008ff167819ULL, 0x000fce0000011600ULL,
0x000153f000008947ULL, 0x000fea0003800000ULL, 0x0000000818147824ULL, 0x000fe400078e00ffULL,
0x00000003ff037424ULL, 0x000fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01068c0314ff738cULL, 0x0003e20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000001ff0000780cULL, 0x000fe20003f04070ULL, 0x0000000210137824ULL, 0x000fe200078e00ffULL,
0x0000580012007a10ULL, 0x000fe20007ffe0ffULL, 0x0106880014ff7f8cULL, 0x0005e8000c80043fULL,
0x0000580013137a24ULL, 0x000fcc00078e0200ULL, 0x0000038000000947ULL, 0x000fea0003800000ULL,
0x0000001415037217ULL, 0x006fe20007800000ULL, 0x00000100ff0f7424ULL, 0x000fe200078e00ffULL,
0x00000004ff007819ULL, 0x100fe40000011617ULL, 0x000000f00c0d7812ULL, 0x000fe200078ec0ffULL,
0x0000000103037824ULL, 0x000fe200078e0a14ULL, 0x0000000200047810ULL, 0x000fe20007ffe0ffULL,
0x0000000114027824ULL, 0x000fe200078e0200ULL, 0x0000000400057810ULL, 0x040fe40007ffe0ffULL,
0x000000030000720cULL, 0x080fe20003f66070ULL, 0x0000001002097824ULL, 0x000fe200078e00ffULL,
0x0000000600087810ULL, 0x000fe20007ffe0ffULL, 0x0000000102007824ULL, 0x000fe200078e0217ULL,
0x000000030400720cULL, 0x080fe20003f46070ULL, 0x0000000114047824ULL, 0x040fe200078e0204ULL,
0x000000030500720cULL, 0x080fe20003f26070ULL, 0x0000000114067824ULL, 0x000fe200078e0205ULL,
0x000000030800720cULL, 0x000fe20003f06070ULL, 0x0000620013027a24ULL, 0x000fe200078e0202ULL,
0xfffffff009007812ULL, 0x000fe200078ee200ULL, 0x0000000104057824ULL, 0x000fc400078e0217ULL,
0x00000010040a7824ULL, 0x000fe400078e00ffULL, 0x0000000114087824ULL, 0x000fe400078e0208ULL,
0x0000000106077824ULL, 0x000fe200078e0217ULL, 0xfffffff00a0a7812ULL, 0x000fe200078ee205ULL,
0x00000010060e7824ULL, 0x000fe400078e00ffULL, 0x00005e0002027625ULL, 0x000fc600078e000fULL,
0xfffffff00e0e7812ULL, 0x000fe200078ee207ULL, 0x0000620013047a24ULL, 0x040fe200078e0204ULL,
0x0000000d02027210ULL, 0x000fe20007fbe0ffULL, 0x0000620013067a24ULL, 0x040fe400078e0206ULL,
0x0000620013097a24ULL, 0x000fe400078e0208ULL, 0x00005e0004047625ULL, 0x000fc800078e000fULL,
0x00000001080b7824ULL, 0x000fe200078e0217ULL, 0x0000000d04047210ULL, 0x000fe20007f9e0ffULL,
0x00000010080c7824ULL, 0x000fe400078e00ffULL, 0x00005e0006067625ULL, 0x000fc600078e000fULL,
0xfffffff00c0c7812ULL, 0x000fe200078ee20bULL, 0x00005e0009087625ULL, 0x000fe200078e000fULL,
0x0000c000000b7811ULL, 0x000fe400078e20ffULL, 0x0000c0000e0f7811ULL, 0x000fe200078e20ffULL,
0x000000ffff037224ULL, 0x000fe200028e0603ULL, 0x0000000d06067210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff057224ULL, 0x000fe200020e0605ULL, 0x0000000d08087210ULL, 0x000fe40007fde0ffULL,
0x0000c0000a0d7811ULL, 0x000fe200078e20ffULL, 0x000000ffff077224ULL, 0x000fe200028e0607ULL,
0x0000c0000c117811ULL, 0x000fe200078e20ffULL, 0x000000ffff097224ULL, 0x000fe200030e0609ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000020b7faeULL, 0x0003e8000d901c46ULL,
0x00000000040d7faeULL, 0x0003e8000d101c46ULL, 0x00000000060f7faeULL, 0x0003e8000c901c46ULL,
0x0000000008117faeULL, 0x0003e2000c101c46ULL, 0x000002d000007947ULL, 0x000fea0003800000ULL,
0x0000001417007211ULL, 0x004fe200078fe0ffULL, 0x00000100ff097424ULL, 0x000fe200078e00ffULL,
0x000000f00c0f7812ULL, 0x000fc400078ec0ffULL, 0x0000000200047810ULL, 0x040fe20007ffe0ffULL,
0x0000000100027824ULL, 0x140fe200078e0217ULL, 0x0000000400067810ULL, 0x040fe20007ffe0ffULL,
0x0000001000077824ULL, 0x000fe400078e00ffULL, 0x0000000104037824ULL, 0x142fe400078e0217ULL,
0x0000001004087824ULL, 0x000fe200078e00ffULL, 0xfffffff0070a7812ULL, 0x000fe200078ee202ULL,
0x0000620013027a24ULL, 0x000fe200078e0200ULL, 0x0000000600007810ULL, 0x000fe20007ffe0ffULL,
0x0000000106057824ULL, 0x000fe200078e0217ULL, 0xfffffff0080d7812ULL, 0x000fe200078ee203ULL,
0x00000010060e7824ULL, 0x000fc400078e00ffULL, 0x00005e0002027625ULL, 0x000fe200078e0009ULL,
0x0000c0000d0d7811ULL, 0x000fe400078e20ffULL, 0xfffffff00e0e7812ULL, 0x000fe200078ee205ULL,
0x0000620013047a24ULL, 0x040fe200078e0204ULL, 0x0000000f02027210ULL, 0x000fe20007f1e0ffULL,
0x0000620013067a24ULL, 0x040fe400078e0206ULL, 0x0000620013087a24ULL, 0x000fe400078e0200ULL,
0x00005e0004047625ULL, 0x000fc800078e0009ULL, 0x00005e0006067625ULL, 0x000fe200078e0009ULL,
0x0000000f04047210ULL, 0x000fc60007f3e0ffULL, 0x00000001000b7824ULL, 0x000fe400078e0217ULL,
0x00005e0008087625ULL, 0x000fc800078e0009ULL, 0x0000001000007824ULL, 0x000fe200078e00ffULL,
0x0000000f08087210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff037224ULL, 0x000fe200000e0603ULL,
0x0000000f06067210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff057224ULL, 0x000fe200008e0605ULL,
0xfffffff000007812ULL, 0x000fe200078ee20bULL, 0x000000ffff097224ULL, 0x000fe200010e0609ULL,
0x0000c0000a0b7811ULL, 0x000fe200078e20ffULL, 0x000000ffff077224ULL, 0x000fe200000e0607ULL,
0x0000c0000e0f7811ULL, 0x000fe400078e20ffULL, 0x0000c00000117811ULL, 0x000fe200078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000020b7faeULL, 0x0003e8000b901c46ULL,
0x00000000040d7faeULL, 0x0003e8000b901c46ULL, 0x00000000060f7faeULL, 0x0003e8000b901c46ULL,
0x0000000008117faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000ff1600720cULL, 0x000fe20003f05270ULL, 0x000000ffff127224ULL, 0x000fe200078e00ffULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x000000ffff257224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff2a7f8cULL, 0x000ea2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b800ff027f8cULL, 0x002e62000c80043fULL,
0x000000ffff247224ULL, 0x000fe200078e00ffULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x00013ff000008947ULL, 0x000fea0003800000ULL,
0x000000ffff467224ULL, 0x002fe400078e0003ULL, 0xff317217ff407424ULL, 0x000fc400078e00ffULL,
0x000000ffff117224ULL, 0x000fe400078e00ffULL, 0x000000ffff2f7224ULL, 0x000fc400078e00ffULL,
0x0000010011007824ULL, 0x000fca00078e00ffULL, 0x000000150000720cULL, 0x000fda0003f06070ULL,
0x00013f4000000947ULL, 0x004fea0003800000ULL, 0x0000000000027805ULL, 0x000fc40000015200ULL,
0x0106bc00ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804846ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff067224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000047805ULL, 0x000fcc0000015200ULL, 0x0000000402077210ULL, 0x000fca0007f1e1ffULL,
0x0000000105057824ULL, 0x000fe200000e0e03ULL, 0x003d09000700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011405ULL,
0x0000000700007211ULL, 0x000fca00078110ffULL, 0x000000ffff057224ULL, 0x000fca00000e0605ULL,
0x0000000200007819ULL, 0x000fc80000001205ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000106067810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106bc00ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007804846ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000111037810ULL, 0x040fe40007ffe0ffULL, 0x0000002011107811ULL, 0x000fe400078e40ffULL,
0x000000160300720cULL, 0x000fc60003f26070ULL, 0x0000620013077a24ULL, 0x000fd400078e0210ULL,
0x000003b000009947ULL, 0x000fea0003800000ULL, 0x0000001015037217ULL, 0x000fe40007800000ULL,
0x00000004ff007819ULL, 0x000fc60000011617ULL, 0x0000000103037824ULL, 0x000fe200078e0a10ULL,
0x0000000200057810ULL, 0x000fe20007ffe0ffULL, 0x0000000114027824ULL, 0x000fc600078e0200ULL,
0x0000000314037217ULL, 0x040fe20007800000ULL, 0x0000000114067824ULL, 0x000fe400078e0205ULL,
0x0000000102047824ULL, 0x140fe400078e0217ULL, 0x0000000103037824ULL, 0x000fe400078e0a14ULL,
0x00000010020d7824ULL, 0x000fe400078e00ffULL, 0x00000001060b7824ULL, 0x040fe200078e0217ULL,
0x000000030500720cULL, 0x080fe20003f66070ULL, 0x00000010060c7824ULL, 0x000fe200078e00ffULL,
0x0000000400057810ULL, 0x000fe20007ffe0ffULL, 0x0000000102027824ULL, 0x000fe200078e0207ULL,
0x000000030000720cULL, 0x000fc40003f86070ULL, 0xfffffff00d0e7812ULL, 0x000fe200078ee204ULL,
0x0000001017047824ULL, 0x000fe200078e00ffULL, 0xfffffff00c197812ULL, 0x000fe200078ee20bULL,
0x00000100ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000000600007810ULL, 0x000fe20007ffe0ffULL,
0x00000001140c7824ULL, 0x000fe200078e0205ULL, 0x000000030500720cULL, 0x080fe40003f46070ULL,
0x000000030000720cULL, 0x000fe20003f06070ULL, 0x00005e0002027625ULL, 0x000fe200078e000bULL,
0x000000f0040f7812ULL, 0x000fc600078ec0ffULL, 0x0000000106047824ULL, 0x100fe400078e0207ULL,
0x0000000114287824ULL, 0x000fe400078e0200ULL, 0x000000010c007824ULL, 0x040fe400078e0207ULL,
0x000000010c0d7824ULL, 0x040fe400078e0217ULL, 0x000000100c1a7824ULL, 0x000fe200078e00ffULL,
0x0000000f020c7210ULL, 0x000fe20007fbe0ffULL, 0x00005e0004047625ULL, 0x000fc600078e000bULL,
0xfffffff01a1a7812ULL, 0x000fe200078ee20dULL, 0x0000000128067824ULL, 0x000fe400078e0207ULL,
0x000000ffff0d7224ULL, 0x000fe200028e0603ULL, 0x0000000f04047210ULL, 0x000fe20007fbe0ffULL,
0x00005e0000027625ULL, 0x000fc800078e000bULL, 0x00005e0006067625ULL, 0x000fc800078e000bULL,
0x0000000128007824ULL, 0x000fe200078e0217ULL, 0x0000000f06067210ULL, 0x080fe20007fde0ffULL,
0x00000010280b7824ULL, 0x000fe400078e00ffULL, 0x000000ffff057224ULL, 0x000fe200028e0605ULL,
0x0000000f02027210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff077224ULL, 0x000fe200030e0607ULL,
0xfffffff00b007812ULL, 0x000fe400078ee200ULL, 0x0000e0000e0b7811ULL, 0x000fe200078e20ffULL,
0x000000ffff037224ULL, 0x000fe200028e0603ULL, 0x0000e000190f7811ULL, 0x000fc400078e20ffULL,
0x0000e0001a197811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c0b7faeULL, 0x0003e2000e101c46ULL, 0x0000e000001b7811ULL, 0x000fc600078e20ffULL,
0x00000000040f7faeULL, 0x0003e8000d901c46ULL, 0x0000000002197faeULL, 0x0003e8000d101c46ULL,
0x00000000061b7faeULL, 0x0003e2000c101c46ULL, 0x000002e000007947ULL, 0x000fea0003800000ULL,
0x0000001417007211ULL, 0x000fe200078fe0ffULL, 0x00000100ff0d7424ULL, 0x000fc600078e00ffULL,
0x0000000200047810ULL, 0x040fe20007ffe0ffULL, 0x0000000100027824ULL, 0x140fe200078e0217ULL,
0x0000000400067810ULL, 0x040fe20007ffe0ffULL, 0x00000010000b7824ULL, 0x000fe400078e00ffULL,
0x0000000104037824ULL, 0x040fe400078e0217ULL, 0x00000010040c7824ULL, 0x000fe200078e00ffULL,
0xfffffff00b0e7812ULL, 0x000fe200078ee202ULL, 0x0000000100027824ULL, 0x040fe200078e0207ULL,
0x0000000600007810ULL, 0x000fe20007ffe0ffULL, 0x0000000106057824ULL, 0x000fe200078e0217ULL,
0xfffffff00c0f7812ULL, 0x000fe200078ee203ULL, 0x0000001017037824ULL, 0x000fc400078e00ffULL,
0x00000010061a7824ULL, 0x000fe200078e00ffULL, 0x0000e0000f0f7811ULL, 0x000fe200078e20ffULL,
0x0000000104047824ULL, 0x000fe200078e0207ULL, 0x000000f0030b7812ULL, 0x000fe200078ec0ffULL,
0x00005e0002027625ULL, 0x000fe200078e000dULL, 0xfffffff01a197812ULL, 0x000fc600078ee205ULL,
0x0000000106067824ULL, 0x100fe200078e0207ULL, 0x0000000b02027210ULL, 0x000fe20007f1e0ffULL,
0x00000001000c7824ULL, 0x000fe200078e0207ULL, 0x0000e00019197811ULL, 0x000fe200078e20ffULL,
0x00005e0004047625ULL, 0x000fc800078e000dULL, 0x00005e0006067625ULL, 0x000fe200078e000dULL,
0x0000000b04047210ULL, 0x000fc60007f5e0ffULL, 0x00005e000c0c7625ULL, 0x000fc800078e000dULL,
0x00000001001a7824ULL, 0x000fe200078e0217ULL, 0x0000000b0c0c7210ULL, 0x080fe20007f7e0ffULL,
0x00000010001b7824ULL, 0x000fe400078e00ffULL, 0x000000ffff037224ULL, 0x000fe200000e0603ULL,
0x0000000b06067210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff057224ULL, 0x000fe200010e0605ULL,
0xfffffff01b1a7812ULL, 0x000fe200078ee21aULL, 0x000000ffff0d7224ULL, 0x000fe200018e060dULL,
0x0000e0000e0b7811ULL, 0x000fe200078e20ffULL, 0x000000ffff077224ULL, 0x000fe200000e0607ULL,
0x0000e0001a1b7811ULL, 0x000fc600078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000020b7faeULL, 0x0003e8000b901c46ULL, 0x00000000040f7faeULL, 0x0003e8000b901c46ULL,
0x0000000006197faeULL, 0x0003e8000b901c46ULL, 0x000000000c1b7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff1a7f8cULL, 0x002e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106080014067f8cULL, 0x0006a4000c80043fULL, 0x0000000000027805ULL, 0x000fc40000015200ULL,
0x01060c0014057984ULL, 0x000f240000000800ULL, 0x8000000005ff7812ULL, 0x014fc40007804807ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000047805ULL, 0x000fcc0000015200ULL, 0x00000004020b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000105057824ULL, 0x000fe200000e0e03ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011405ULL,
0x0000000b00007211ULL, 0x000fca00078110ffULL, 0x000000ffff057224ULL, 0x000fca00000e0605ULL,
0x0000000200007819ULL, 0x000fc80000001205ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01060c0014057984ULL, 0x000ea40000000800ULL,
0x8000000005ff7812ULL, 0x004fe40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000010170f7824ULL, 0x000fe200078e00ffULL, 0x00000001ff007819ULL, 0x000fe20000011617ULL,
0xffffffffff0d7424ULL, 0x000fc600078e00ffULL, 0x0000000c00037812ULL, 0x000fe400078ec0ffULL,
0x000000700f0e7812ULL, 0x000fca00078ec0ffULL, 0x000000010e0e7824ULL, 0x000fca00078e0203ULL,
0x010000000e037984ULL, 0x000ea80000000800ULL, 0x010200000e057984ULL, 0x0006620000000800ULL,
0x000000400300720bULL, 0x004fe20003f1d000ULL, 0x000191c27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000007806ULL, 0x008fc800000e0100ULL, 0x0000ffff00077812ULL, 0x000fe2000780c0ffULL,
0x0000047000007945ULL, 0x000fe20003800000ULL, 0x00000001ff007424ULL, 0x000fe400078e00ffULL,
0x000000ffff4d7224ULL, 0x000fc400078e0040ULL, 0x0000001fff0c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff0b7424ULL, 0x000fca00078e00ffULL, 0x0000041000008947ULL, 0x000fea0003800000ULL,
0x000000ff1800720cULL, 0x000fe40003f05270ULL, 0x000000400300720bULL, 0x000fe20003f54000ULL,
0x000191627f007947ULL, 0x000fd8000b800000ULL, 0x0000000000027806ULL, 0x000fc400010e0100ULL,
0x00000003404d7209ULL, 0x000fe20007810000ULL, 0x0000035000017945ULL, 0x000fe20003800000ULL,
0x0000991002047816ULL, 0x000fc600000000ffULL, 0x0104004d0e008388ULL, 0x0005e20000000800ULL,
0x000000ff0400720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x8000004d40047221ULL, 0x004fe20000010000ULL, 0x000000ff02ff7812ULL, 0x000fe2000780c0ffULL,
0x0000017000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b04047820ULL, 0x000fc80000410000ULL,
0x0000000400197308ULL, 0x0004ec0000000800ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff047819ULL, 0x004fe20000011617ULL, 0x000190c27f007947ULL, 0x000fea000b800000ULL,
0x00001f0419047589ULL, 0x0084e400000e0000ULL, 0x0000000430307220ULL, 0x088fe20000410000ULL,
0x0000000431317220ULL, 0x080fe20000410000ULL, 0x0000000434347220ULL, 0x080fe20000410000ULL,
0x0000000435357220ULL, 0x080fe20000410000ULL, 0x0000000438387220ULL, 0x080fe20000410000ULL,
0x0000000439397220ULL, 0x080fe20000410000ULL, 0x000000043c3c7220ULL, 0x080fe20000410000ULL,
0x000000043d3d7220ULL, 0x080fe20000410000ULL, 0x0000000424247220ULL, 0x080fe20000410000ULL,
0x0000000425257220ULL, 0x080fe20000410000ULL, 0x0000000420207220ULL, 0x080fe20000410000ULL,
0x0000000421217220ULL, 0x080fe20000410000ULL, 0x000000041c1c7220ULL, 0x080fe20000410000ULL,
0x000000041d1d7220ULL, 0x080fe20000410000ULL, 0x000000042c2c7220ULL, 0x080fe20000410000ULL,
0x000000042d2d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0002ff7812ULL, 0x000fe2000780c0ffULL, 0x0000001912127220ULL, 0x008fd80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000817047811ULL, 0x004fe200078ff0ffULL,
0x00018fb27f007947ULL, 0x000fea000b800000ULL, 0x00001f0419047589ULL, 0x0004e400000e0000ULL,
0x0000000432327220ULL, 0x088fe20000410000ULL, 0x0000000433337220ULL, 0x080fe20000410000ULL,
0x0000000436367220ULL, 0x080fe20000410000ULL, 0x0000000437377220ULL, 0x080fe20000410000ULL,
0x000000043a3a7220ULL, 0x080fe20000410000ULL, 0x000000043b3b7220ULL, 0x080fe20000410000ULL,
0x000000043e3e7220ULL, 0x080fe20000410000ULL, 0x000000043f3f7220ULL, 0x080fe20000410000ULL,
0x0000000426267220ULL, 0x080fe20000410000ULL, 0x0000000427277220ULL, 0x080fe20000410000ULL,
0x0000000422227220ULL, 0x080fe20000410000ULL, 0x0000000423237220ULL, 0x080fe20000410000ULL,
0x000000041e1e7220ULL, 0x080fe20000410000ULL, 0x000000041f1f7220ULL, 0x080fe20000410000ULL,
0x000000042e2e7220ULL, 0x080fe20000410000ULL, 0x000000042f2f7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff07ff7812ULL, 0x000fda0007806002ULL,
0x8000004d03030221ULL, 0x000fe20000010000ULL, 0x00007610ff000816ULL, 0x000fc60000000000ULL,
0x3fb8aa3b03030820ULL, 0x000fc80000410000ULL, 0x00000003000a0308ULL, 0x000ea40000000800ULL,
0x0000000a05050220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001205127221ULL, 0x002fc20000010000ULL, 0x0000000000027805ULL, 0x000fcc0000015200ULL,
0x0106ac00ff047984ULL, 0x000e640000000800ULL, 0x8000000004ff7812ULL, 0x002fe4000780482bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff067224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000047805ULL, 0x000fcc0000015200ULL, 0x0000000402077210ULL, 0x000fca0007f1e1ffULL,
0x0000000105057824ULL, 0x000fe200000e0e03ULL, 0x003d09000700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc80000011405ULL,
0x0000000704047211ULL, 0x000fca00078110ffULL, 0x000000ffff057224ULL, 0x000fca00000e0605ULL,
0x0000000204047819ULL, 0x000fc80000001205ULL, 0x000000040000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000106067810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106ac00ff047984ULL, 0x000e640000000800ULL,
0x8000000004ff7812ULL, 0x002fe4000780482bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991000007816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0000720cULL, 0x000fda0003f45270ULL, 0x0000012000002947ULL, 0x000fea0003800000ULL,
0x0000000aff00723eULL, 0x000fe400000010ffULL, 0x00000002ff037819ULL, 0x000fe40000011617ULL,
0x0000541000007816ULL, 0x000fe20000000000ULL, 0x00018bc27f007947ULL, 0x000fea000b800000ULL,
0x00001f0300097589ULL, 0x0002a400000e0000ULL, 0x0000000803087810ULL, 0x000fe20007ffe0ffULL,
0x00018bf27f007947ULL, 0x000fea000b800000ULL, 0x00001f0800087589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001003557810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff527224ULL, 0x000fe200078e0000ULL, 0x0000247000427802ULL, 0x000fc40000000f00ULL,
0x0001991000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001803557810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff527224ULL, 0x004fe200078e0000ULL,
0x000024c000427802ULL, 0x000fc40000000f00ULL, 0x000198c000007944ULL, 0x008fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000817507812ULL, 0x000fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000004ff077819ULL, 0x000fc40000011617ULL,
0x0000000750507812ULL, 0x000fe400078ef817ULL, 0x00000007174c7812ULL, 0x000fe200078ec0ffULL,
0x0000000418537824ULL, 0x000fe400078e0207ULL, 0x0000001050037824ULL, 0x002fe200078e00ffULL,
0x000000084c4c7812ULL, 0x000fe200078ef817ULL, 0x0000000150007824ULL, 0x008fc800078e0253ULL,
0x00000001074f7824ULL, 0x000fe200078e024cULL, 0xfffffff003067812ULL, 0x000fe400078ee200ULL,
0x0000000218007811ULL, 0x000fe400078e10ffULL, 0x0000c00006067811ULL, 0x000fc600078e20ffULL,
0x0000000107517824ULL, 0x000fe400078e0200ULL, 0x000000000648783bULL, 0x000e640000004200ULL,
0x0000000150027824ULL, 0x000fca00078e0251ULL, 0xfffffff003027812ULL, 0x000fe400078ee202ULL,
0x000000024f037810ULL, 0x000fe40007ffe0ffULL, 0x0000c00002057811ULL, 0x000fe400078e20ffULL,
0x0000001050027812ULL, 0x000fc600078efcffULL, 0x000000000544783bULL, 0x000ee20000004200ULL,
0x00000000024e7210ULL, 0x040fe20007ffe007ULL, 0x0000000153197824ULL, 0x000fe400078e0202ULL,
0x0000001002047824ULL, 0x000fe400078e00ffULL, 0x000000084c007824ULL, 0x000fe400078e00ffULL,
0x0000001002297824ULL, 0x000fe200078e00ffULL, 0xfffffff004197812ULL, 0x000fe400078ee219ULL,
0xfffffff800037812ULL, 0x000fc400078ee203ULL, 0x0000c00019047811ULL, 0x000fe400078e20ffULL,
0xfffffff0294e7812ULL, 0x000fc600078ee24eULL, 0x000000000440783bULL, 0x000f220000004200ULL,
0x0000c0004e027811ULL, 0x000fe400078e20ffULL, 0x000000ff48527812ULL, 0x006fc600078ec0ffULL,
0x000000000228783bULL, 0x000e620000004200ULL, 0x00000010ff007819ULL, 0x100fe40000011648ULL,
0x0000ffff4a6b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff00007812ULL, 0x000fe400078ec0ffULL,
0x00000018ff7b7819ULL, 0x000fe40000011648ULL, 0x00000000ff00723eULL, 0x000fe400020006ffULL,
0x0000ffff48917812ULL, 0x000fc400078ec0ffULL, 0x000000ff49487812ULL, 0x000fe200078ec0ffULL,
0x20000000ff7d7230ULL, 0x000fe20000004100ULL, 0x0000ffff446e7812ULL, 0x008fe400078ec0ffULL,
0x0000ffff45717812ULL, 0x000fe400078ec0ffULL, 0x00000008ff007819ULL, 0x000fe4000001166eULL,
0x0000ffff4b6c7812ULL, 0x000fe400078ec0ffULL, 0x00000000ff00723eULL, 0x000fc400020006ffULL,
0x0000ffff47937812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5a7819ULL, 0x000fe20000011649ULL,
0x20000000ff737230ULL, 0x000fe20000004100ULL, 0x00000008ff007819ULL, 0x000fe40000011693ULL,
0x00000018ff7f7819ULL, 0x000fe40000011649ULL, 0x00000010ff6d7819ULL, 0x010fe40000011640ULL,
0x000000ff40697812ULL, 0x000fc400078ec0ffULL, 0x00000018ff687819ULL, 0x000fe40000011640ULL,
0x0000ffff407a7812ULL, 0x000fe400078ec0ffULL, 0x00000052ff40723eULL, 0x000fe400020006ffULL,
0x00000010ff797819ULL, 0x000fe40000011641ULL, 0x000000ff416a7812ULL, 0x000fe200078ec0ffULL,
0x20000040ff7c7230ULL, 0x000fe20000004100ULL, 0x00000008ff407819ULL, 0x000fc4000001166bULL,
0x00000018ff7e7819ULL, 0x000fe40000011641ULL, 0x00000040ff40723eULL, 0x000fe400020006ffULL,
0x0000ffff41707812ULL, 0x000fe400078ec0ffULL, 0x00000048ff41723eULL, 0x000fe200020006ffULL,
0x20000040ff847230ULL, 0x000fe20000004100ULL, 0x00000008ff407819ULL, 0x000fe40000011671ULL,
0x00000000ff00723eULL, 0x000fe200020006ffULL, 0x20000041ff807230ULL, 0x000fe20000004100ULL,
0x00000040ff40723eULL, 0x000fc400020006ffULL, 0x00000008ff417819ULL, 0x000fe2000001166cULL,
0x20000000ff6e7230ULL, 0x000fe20000004100ULL, 0x0000ffff49927812ULL, 0x000fe200078ec0ffULL,
0x20000040ff747230ULL, 0x000fe20000004100ULL, 0x00000041ff41723eULL, 0x000fe200020006ffULL,
0x000000084c407824ULL, 0x000fe200078e00ffULL, 0x00000010ff777819ULL, 0x100fe4000001164aULL,
0x000000ff4a837812ULL, 0x000fe200078ec0ffULL, 0x20000041ff867230ULL, 0x000fe20000004100ULL,
0x00000018ff497819ULL, 0x000fc4000001164aULL, 0x0000ffff46727812ULL, 0x000fe400078ec0ffULL,
0x00000010ff787819ULL, 0x100fe4000001164bULL, 0x000000ff4b857812ULL, 0x000fe400078ec0ffULL,
0x00000018ff4a7819ULL, 0x000fe4000001164bULL, 0x00000018ff4b7819ULL, 0x000fe40000011644ULL,
0x00000008ff417819ULL, 0x000fc40000011672ULL, 0xfffffff840007812ULL, 0x000fe400078ee24fULL,
0x00000010ff5d7819ULL, 0x100fe40000011645ULL, 0x000000ff455f7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff5e7819ULL, 0x000fe40000011645ULL, 0x0000004bff4b723eULL, 0x000fe400020006ffULL,
0x00000010ff6f7819ULL, 0x000fc40000011642ULL, 0x000000ff42877812ULL, 0x040fe200078ec0ffULL,
0x2000004bff647230ULL, 0x000fe20000004100ULL, 0x00000018ff827819ULL, 0x000fe40000011642ULL,
0x0000ffff42457812ULL, 0x000fe400078ec0ffULL, 0x000000ff47677812ULL, 0x000fe400078ec0ffULL,
0x000000ff43427812ULL, 0x000fe400078ec0ffULL, 0x00000041ff41723eULL, 0x000fc400020006ffULL,
0x0000a00000407811ULL, 0x000fe400078e20ffULL, 0x00000010ff5b7819ULL, 0x000fe20000011644ULL,
0x20000041ff6c7230ULL, 0x000fe20000004100ULL, 0x000000ff445c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff607819ULL, 0x100fe40000011646ULL, 0x000000ff46627812ULL, 0x000fe400078ec0ffULL,
0x00000018ff617819ULL, 0x000fc40000011646ULL, 0x00000067ff4b723eULL, 0x000fe400020006ffULL,
0x00000010ff467819ULL, 0x100fe40000011643ULL, 0x00000018ff887819ULL, 0x000fe20000011643ULL,
0x2000004bff4b7230ULL, 0x000fe20000004100ULL, 0x0000ffff43447812ULL, 0x000fe400078ec0ffULL,
0x00000042ff67723eULL, 0x000fe400020006ffULL, 0x000000004040783bULL, 0x000ea20000000200ULL,
0x00000069ff69723eULL, 0x000fc400020006ffULL, 0x000000ff5a5a7812ULL, 0x000fe200078ec0ffULL,
0x20000067ff677230ULL, 0x000fe20000004100ULL, 0x0000006aff6b723eULL, 0x000fe200020006ffULL,
0x20000069ff6a7230ULL, 0x000fe20000004100ULL, 0x0000007eff69723eULL, 0x000fe400020006ffULL,
0x0000005aff5a723eULL, 0x000fe200020006ffULL, 0x2000006bff6b7230ULL, 0x000fe20000004100ULL,
0x0000007bff7e723eULL, 0x000fe200020006ffULL, 0x20000069ff697230ULL, 0x000fe20000004100ULL,
0x00000008ff7b7819ULL, 0x000fe20000011691ULL, 0x2000005aff817230ULL, 0x000fe20000004100ULL,
0x000000ff77777812ULL, 0x000fe200078ec0ffULL, 0x2000007eff7e7230ULL, 0x000fe20000004100ULL,
0x0000007bff7b723eULL, 0x000fc400020006ffULL, 0x00000010ff7c7819ULL, 0x000fe4000001167cULL,
0x00000010ff7d7819ULL, 0x000fe2000001167dULL, 0x2000007bff7b7230ULL, 0x000fe20000004100ULL,
0x00000010ff807819ULL, 0x000fe40000011680ULL, 0x00000010ff817819ULL, 0x000fe40000011681ULL,
0x000000ff78787812ULL, 0x000fe400078ec0ffULL, 0x00000077ff77723eULL, 0x000fc400020006ffULL,
0x00000083ff83723eULL, 0x000fe400020006ffULL, 0x00000049ff49723eULL, 0x000fe200020006ffULL,
0x20000077ff777230ULL, 0x000fe20000004100ULL, 0x00000010ff547819ULL, 0x102fe2000001162bULL,
0x20000083ff837230ULL, 0x000fe20000004100ULL, 0x000000ff2b907812ULL, 0x040fe400078ec0ffULL,
0x00000018ff8f7819ULL, 0x000fe2000001162bULL, 0x000000094040a231ULL, 0x084fe200003400ffULL,
0x0000ffff2b527812ULL, 0x000fe200078ec0ffULL, 0x000000094242a231ULL, 0x000fe200003400ffULL,
0x00000085ff85723eULL, 0x000fe200020006ffULL, 0x000000084141a231ULL, 0x080fe200003400ffULL,
0x000010547d7c7816ULL, 0x000fe2000000007cULL, 0x000000084343a231ULL, 0x000fe200003400ffULL,
0x000000ff79797812ULL, 0x000fe200078ec0ffULL, 0x20000085ff857230ULL, 0x000fe20000004100ULL,
0x0000004aff2b723eULL, 0x000fc400020006ffULL, 0x00001054817d7816ULL, 0x000fe40000000080ULL,
0x000000ff5b5b7812ULL, 0x000fe200078ec0ffULL, 0x2000002bff2b7230ULL, 0x000fe20000004100ULL,
0x000000ff5d5d7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff7a7819ULL, 0x000fe2000001167aULL,
0x0000007c4030723cULL, 0x000b620000041830ULL, 0x00000078ff78723eULL, 0x000fe400020006ffULL,
0x00000010ff7e7819ULL, 0x000fc4000001167eULL, 0x00000010ff7b7819ULL, 0x000fe2000001167bULL,
0x20000078ff787230ULL, 0x000fe20000004100ULL, 0x00000010ff597819ULL, 0x100fe40000011629ULL,
0x000000ff298c7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff8b7819ULL, 0x000fe40000011629ULL,
0x0000ffff29577812ULL, 0x000fe400078ec0ffULL, 0x00000010ff567819ULL, 0x000fc4000001162aULL,
0x000000ff2a8e7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff8d7819ULL, 0x000fe4000001162aULL,
0x0000ffff2a557812ULL, 0x000fe200078ec0ffULL, 0x20000049ff2a7230ULL, 0x000fe20000004100ULL,
0x00000079ff79723eULL, 0x000fe400020006ffULL, 0x00000010ff487819ULL, 0x100fe40000011628ULL,
0x000000ff288a7812ULL, 0x000fe200078ec0ffULL, 0x20000079ff7d7230ULL, 0x020fe20000004100ULL,
0x00000018ff897819ULL, 0x000fc40000011628ULL, 0x0000ffff28587812ULL, 0x000fe400078ec0ffULL,
0x0000005fff29723eULL, 0x000fe400020006ffULL, 0x000000ff6f6f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff637819ULL, 0x000fe20000011647ULL, 0x20000029ff297230ULL, 0x000fe20000004100ULL,
0x0000005cff28723eULL, 0x000fe400020006ffULL, 0x0000005bff5b723eULL, 0x000fc400020006ffULL,
0x0000005dff5d723eULL, 0x000fe200020006ffULL, 0x20000028ff287230ULL, 0x000fe20000004100ULL,
0x0000007aff7a723eULL, 0x000fe200020006ffULL, 0x2000005bff767230ULL, 0x000fe20000004100ULL,
0x000010547e7e7816ULL, 0x000fe2000000007bULL, 0x2000005dff757230ULL, 0x000fe20000004100ULL,
0x00000008ff7b7819ULL, 0x000fe20000011670ULL, 0x2000007aff7c7230ULL, 0x000fe20000004100ULL,
0x00000010ff707819ULL, 0x000fe40000011677ULL, 0x00000010ff837819ULL, 0x000fc40000011683ULL,
0x0000006fff77723eULL, 0x000fe400020006ffULL, 0x000000ff63637812ULL, 0x000fe400078ec0ffULL,
0x00000010ff797819ULL, 0x000fe40000011685ULL, 0x00000010ff6f7819ULL, 0x000fe4000001162aULL,
0x00000010ff2a7819ULL, 0x000fe4000001162bULL, 0x00000010ff857819ULL, 0x000fc40000011686ULL,
0x00000010ff7a7819ULL, 0x000fe40000011678ULL, 0x0000105470787816ULL, 0x000fe20000000083ULL,
0x20000077ff707230ULL, 0x000fe20000004100ULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x000010542a857816ULL, 0x000fe40000000085ULL, 0x00000010ff777819ULL, 0x000fe20000011629ULL,
0x20000063ff717230ULL, 0x000fe20000004100ULL, 0x00000010ff287819ULL, 0x000fc40000011628ULL,
0x00000010ff297819ULL, 0x000fe40000011676ULL, 0x00000010ff2a7819ULL, 0x000fe40000011675ULL,
0x0000a000032b7811ULL, 0x000fe400078e20ffULL, 0x0000005eff5e723eULL, 0x000fe400020006ffULL,
0x00000082ff63723eULL, 0x000fe400020006ffULL, 0x0000007fff82723eULL, 0x000fe200020006ffULL,
0x2000005eff657230ULL, 0x000fe20000004100ULL, 0x0000105429767816ULL, 0x000fe20000000028ULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x000010542a777816ULL, 0x000fe20000000077ULL,
0x20000082ff827230ULL, 0x000fe20000004100ULL, 0x00000008ff7f7819ULL, 0x000fe20000011692ULL,
0x000000002b28783bULL, 0x000e620000000200ULL, 0x000000ff60607812ULL, 0x000fc400078ec0ffULL,
0x00000010ff847819ULL, 0x000fe20000011684ULL, 0x000000764024723cULL, 0x000fe20000041824ULL,
0x000000ff46467812ULL, 0x000fe400078ec0ffULL, 0x00000018ff667819ULL, 0x000fe40000011647ULL,
0x0000007fff7f723eULL, 0x000fe400020006ffULL, 0x00000062ff47723eULL, 0x000fe400020006ffULL,
0x00000060ff60723eULL, 0x000fe200020006ffULL, 0x2000007fff7f7230ULL, 0x000fe20000004100ULL,
0x000010546f847816ULL, 0x000fe20000000084ULL, 0x20000047ff477230ULL, 0x000fe20000004100ULL,
0x00000046ff6f723eULL, 0x000fe200020006ffULL, 0x20000060ff727230ULL, 0x000fe20000004100ULL,
0x00000010ff467819ULL, 0x000fc40000011665ULL, 0x00000010ff657819ULL, 0x000fe20000011674ULL,
0x2000006fff747230ULL, 0x000fe20000004100ULL, 0x00000010ff647819ULL, 0x000fe20000011664ULL,
0x00000084403c723cULL, 0x000fe2000004183cULL, 0x00000010ff737819ULL, 0x000fe40000011673ULL,
0x00000008ff457819ULL, 0x000fe40000011645ULL, 0x00000061ff4a723eULL, 0x000fe400020006ffULL,
0x00000066ff49723eULL, 0x000fc400020006ffULL, 0x0000105446657816ULL, 0x000fe20000000065ULL,
0x2000004aff4a7230ULL, 0x000fe20000004100ULL, 0x00000010ff827819ULL, 0x000fe20000011682ULL,
0x20000049ff497230ULL, 0x000fe20000004100ULL, 0x00000010ff7f7819ULL, 0x000fe4000001167fULL,
0x0000105464647816ULL, 0x000fe20000000073ULL, 0x000000092828a231ULL, 0x082fe200003400ffULL,
0x00000008ff467819ULL, 0x000fe20000011644ULL, 0x000000092a2aa231ULL, 0x000fe200003400ffULL,
0x00000045ff45723eULL, 0x000fe200020006ffULL, 0x000000082929a231ULL, 0x080fe200003400ffULL,
0x00000010ff477819ULL, 0x000fe20000011647ULL, 0x000000082b2ba231ULL, 0x000fe200003400ffULL,
0x00000010ff4b7819ULL, 0x000fe2000001164bULL, 0x20000045ff6f7230ULL, 0x000fe20000004100ULL,
0x00000010ff727819ULL, 0x000fc40000011672ULL, 0x00000010ff447819ULL, 0x000fe40000011671ULL,
0x00001054827f7816ULL, 0x000fe4000000007fULL, 0x0000105472727816ULL, 0x000fe40000000047ULL,
0x0000105444737816ULL, 0x000fe4000000004bULL, 0x00000046ff71723eULL, 0x000fe200020006ffULL,
0x0000007e4034723cULL, 0x000f620000041834ULL, 0x000000ff48487812ULL, 0x000fc400078ec0ffULL,
0x000000ff6d6d7812ULL, 0x000fe200078ec0ffULL, 0x20000071ff717230ULL, 0x000fe20000004100ULL,
0x00000010ff6c7819ULL, 0x000fe4000001166cULL, 0x00000010ff6e7819ULL, 0x000fe2000001166eULL,
0x000000644044723cULL, 0x000be20000041820ULL, 0x0000006dff6d723eULL, 0x000fe400020006ffULL,
0x000010547a797816ULL, 0x000fe40000000079ULL, 0x000000ff59597812ULL, 0x000fe200078ec0ffULL,
0x2000006dff6d7230ULL, 0x000fe20000004100ULL, 0x00000010ff217819ULL, 0x020fc4000001164aULL,
0x00000010ff237819ULL, 0x000fe20000011649ULL, 0x000000784038723cULL, 0x040f620000041838ULL,
0x00000048ff22723eULL, 0x000fe400020006ffULL, 0x0000105421207816ULL, 0x000fe4000000006cULL,
0x00000068ff68723eULL, 0x000fe400020006ffULL, 0x0000105423217816ULL, 0x000fe2000000006eULL,
0x000000724048723cULL, 0x000b62000004181cULL, 0x0000007bff7b723eULL, 0x000fe200020006ffULL,
0x20000068ff687230ULL, 0x000fe20000004100ULL, 0x00000059ff59723eULL, 0x000fc400020006ffULL,
0x00000087ff66723eULL, 0x000fe200020006ffULL, 0x2000007bff7b7230ULL, 0x000fe20000004100ULL,
0x00000008ff1c7819ULL, 0x020fe20000011658ULL, 0x000000204040723cULL, 0x000b62000004182cULL,
0x00000010ff6a7819ULL, 0x000fe2000001166aULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x0000001cff1d723eULL, 0x000fe200020006ffULL, 0x20000022ff587230ULL, 0x000fe20000004100ULL,
0x00000010ff6d7819ULL, 0x000fe4000001166dULL, 0x20000059ff2e7230ULL, 0x020fe20000004100ULL,
0x00000010ff217819ULL, 0x000fe2000001166bULL, 0x2000001dff597230ULL, 0x000fe20000004100ULL,
0x00000010ff1c7819ULL, 0x000fc4000001167dULL, 0x00000008ff577819ULL, 0x000fe40000011657ULL,
0x00000010ff1d7819ULL, 0x000fe40000011668ULL, 0x00000010ff7c7819ULL, 0x000fe4000001167cULL,
0x00000010ff1e7819ULL, 0x000fe40000011669ULL, 0x00000010ff7b7819ULL, 0x000fe4000001167bULL,
0x0000008bff5f723eULL, 0x000fc400020006ffULL, 0x000010546d207816ULL, 0x000fe4000000006aULL,
0x000010541c217816ULL, 0x000fe20000000021ULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x00000057ff57723eULL, 0x000fe400020006ffULL, 0x000000ff56567812ULL, 0x000fe400078ec0ffULL,
0x000010541d1c7816ULL, 0x000fe2000000007cULL, 0x20000057ff577230ULL, 0x000fe20000004100ULL,
0x000000ff54547812ULL, 0x000fe200078ec0ffULL, 0x000000202820723cULL, 0x000b620000041830ULL,
0x00000008ff557819ULL, 0x000fc40000011655ULL, 0x00000008ff527819ULL, 0x000fe40000011652ULL,
0x000010541e1d7816ULL, 0x000fe4000000007bULL, 0x00000010ff667819ULL, 0x000fe40000011666ULL,
0x00000010ff1f7819ULL, 0x000fe40000011670ULL, 0x00000088ff62723eULL, 0x000fe400020006ffULL,
0x0000008aff60723eULL, 0x000fc400020006ffULL, 0x0000008cff61723eULL, 0x000fe200020006ffULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x00000089ff5e723eULL, 0x000fe200020006ffULL,
0x20000060ff607230ULL, 0x000fe20000004100ULL, 0x0000008eff5d723eULL, 0x000fe200020006ffULL,
0x20000061ff617230ULL, 0x000fe20000004100ULL, 0x00000090ff5c723eULL, 0x000fe200020006ffULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x0000008dff5b723eULL, 0x000fe200020006ffULL,
0x2000005dff5d7230ULL, 0x000fe20000004100ULL, 0x0000008fff5a723eULL, 0x000fe200020006ffULL,
0x2000005cff5c7230ULL, 0x000fe20000004100ULL, 0x00000056ff56723eULL, 0x000fe200020006ffULL,
0x2000005bff5b7230ULL, 0x000fe20000004100ULL, 0x00000054ff54723eULL, 0x000fe200020006ffULL,
0x2000005aff5a7230ULL, 0x000fe20000004100ULL, 0x00000055ff55723eULL, 0x000fe200020006ffULL,
0x20000056ff567230ULL, 0x000fe20000004100ULL, 0x00000052ff52723eULL, 0x000fe200020006ffULL,
0x20000054ff547230ULL, 0x000fe20000004100ULL, 0x000010541f307816ULL, 0x020fe20000000066ULL,
0x20000055ff557230ULL, 0x000fe20000004100ULL, 0x0000001c281c723cULL, 0x000b620000041834ULL,
0x00000010ff577819ULL, 0x000fe20000011657ULL, 0x20000052ff527230ULL, 0x000fe20000004100ULL,
0x00000010ff317819ULL, 0x000fc40000011667ULL, 0x00000010ff747819ULL, 0x000fe40000011674ULL,
0x00000010ff347819ULL, 0x020fe4000001165fULL, 0x00000010ff2c7819ULL, 0x000fe40000011663ULL,
0x00001054345f7816ULL, 0x000fe40000000057ULL, 0x00000010ff627819ULL, 0x000fe40000011662ULL,
0x00000010ff6f7819ULL, 0x000fc4000001166fULL, 0x00000010ff2d7819ULL, 0x000fe40000011671ULL,
0x00000010ff607819ULL, 0x000fe40000011660ULL, 0x00000010ff617819ULL, 0x000fe40000011661ULL,
0x00000010ff2f7819ULL, 0x000fe40000011658ULL, 0x00000010ff2e7819ULL, 0x000fe4000001162eULL,
0x00000010ff5e7819ULL, 0x000fc4000001165eULL, 0x00000010ff597819ULL, 0x000fe40000011659ULL,
0x00000010ff5d7819ULL, 0x000fe4000001165dULL, 0x00000010ff567819ULL, 0x000fe40000011656ULL,
0x00000010ff577819ULL, 0x000fe4000001165cULL, 0x00000010ff547819ULL, 0x000fe40000011654ULL,
0x00000010ff347819ULL, 0x000fc4000001165bULL, 0x00000010ff557819ULL, 0x000fe40000011655ULL,
0x00000010ff5a7819ULL, 0x000fe4000001165aULL, 0x00000010ff357819ULL, 0x000fe40000011652ULL,
0x0000105474317816ULL, 0x000fe40000000031ULL, 0x000010542c2c7816ULL, 0x000fe4000000006fULL,
0x00001054622d7816ULL, 0x000fc4000000002dULL, 0x000010542f607816ULL, 0x000fe20000000060ULL,
0x000000302830723cULL, 0x040b620000041838ULL, 0x000010542e617816ULL, 0x000fe40000000061ULL,
0x000010545e5e7816ULL, 0x000fe40000000059ULL, 0x0000105456567816ULL, 0x000fe4000000005dULL,
0x0000105454577816ULL, 0x000fe20000000057ULL, 0x0000002c282c723cULL, 0x000b62000004183cULL,
0x0000105434347816ULL, 0x000fc40000000055ULL, 0x000010545a357816ULL, 0x000fca0000000035ULL,
0x000000602824723cULL, 0x040b700000041824ULL, 0x0000005e2844723cULL, 0x040b700000041844ULL,
0x000000562848723cULL, 0x040b700000041848ULL, 0x000000342834723cULL, 0x000b620000041840ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff387f8cULL, 0x020e62000c80043fULL,
0x000000ffff3a7224ULL, 0x000fce00078e00ffULL, 0x0000000000287805ULL, 0x000fc40000015200ULL,
0x0106bc00ff2b7984ULL, 0x000ea40000000800ULL, 0x800000002bff7812ULL, 0x006fc40007804839ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a283b7210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2b7824ULL, 0x000fe200000e0e29ULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff2a7819ULL, 0x000fc8000001142bULL, 0x0000003b2a2a7211ULL, 0x000fca00078110ffULL,
0x000000ffff2b7224ULL, 0x000fca00000e062bULL, 0x000000022a2a7819ULL, 0x000fc8000000122bULL,
0x0000002a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013a3a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106bc00ff2b7984ULL, 0x000e640000000800ULL, 0x800000002bff7812ULL, 0x002fe40007804839ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000020102a7810ULL, 0x000fca0007ffe0ffULL,
0x0000620013397a24ULL, 0x000fe200078e022aULL, 0x0000039000009947ULL, 0x000fea0003800000ULL,
0x0000000114387824ULL, 0x000fe200078e0207ULL, 0x0000002a15287217ULL, 0x000fe20007800000ULL,
0x00000100ff3d7424ULL, 0x000fe200078e00ffULL, 0x0000000407437810ULL, 0x040fe20007ffe0ffULL,
0x0000000138297824ULL, 0x040fe200078e0217ULL, 0x0000000207417810ULL, 0x000fe20007ffe0ffULL,
0x00000010383e7824ULL, 0x000fe200078e00ffULL, 0x000000f00f3f7812ULL, 0x000fe200078ec0ffULL,
0x00000001282b7824ULL, 0x000fe400078e0a2aULL, 0x00000001143c7824ULL, 0x000fe200078e0243ULL,
0xfffffff03e3e7812ULL, 0x000fe200078ee229ULL, 0x0000000138287824ULL, 0x000fe200078e0239ULL,
0x0000002b142b7217ULL, 0x000fe20007800000ULL, 0x000000013c3a7824ULL, 0x000fc400078e0217ULL,
0x000000103c557824ULL, 0x000fe400078e00ffULL, 0x00000001142a7824ULL, 0x000fe400078e0241ULL,
0x00005e0028287625ULL, 0x000fe200078e003dULL, 0xfffffff055427812ULL, 0x000fe400078ee23aULL,
0x0000000607557810ULL, 0x000fe20007ffe0ffULL, 0x000000012a387824ULL, 0x000fe200078e0217ULL,
0x0000003f283a7210ULL, 0x000fe20007f1e0ffULL, 0x000000102a3b7824ULL, 0x000fc400078e00ffULL,
0x000000012a287824ULL, 0x100fe400078e0239ULL, 0x000000013c2a7824ULL, 0x000fe200078e0239ULL,
0xfffffff03b407812ULL, 0x000fe200078ee238ULL, 0x000000ffff3b7224ULL, 0x000fe400000e0629ULL,
0x00005e0028287625ULL, 0x000fc800078e003dULL, 0x0000000114527824ULL, 0x000fe200078e0255ULL,
0x0000003f28287210ULL, 0x000fe20007fbe0ffULL, 0x000000012b3c7824ULL, 0x000fe400078e0a14ULL,
0x00005e002a2a7625ULL, 0x000fc600078e003dULL, 0x0000003c4100720cULL, 0x080fe20003f66070ULL,
0x0000000152387824ULL, 0x000fe200078e0239ULL, 0x0000003f2a2a7210ULL, 0x000fe20007fde0ffULL,
0x0000000152417824ULL, 0x000fe200078e0217ULL, 0x0000003c0700720cULL, 0x080fe20003f86070ULL,
0x00005e0038387625ULL, 0x000fe200078e003dULL, 0x0000003c4300720cULL, 0x080fe40003f06070ULL,
0x0000c0003e3d7811ULL, 0x000fe200078e20ffULL, 0x000000ffff297224ULL, 0x000fe200028e0629ULL,
0x0000003c5500720cULL, 0x000fe20003fa6070ULL, 0x0000001052527824ULL, 0x000fc400078e00ffULL,
0x000000ffff2b7224ULL, 0x000fe200030e062bULL, 0x0000003f38387210ULL, 0x000fe40007fde0ffULL,
0xfffffff0523c7812ULL, 0x000fe200078ee241ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a3d7faeULL, 0x0003e2000e101c46ULL, 0x0000c000403f7811ULL, 0x000fe200078e20ffULL,
0x000000ffff397224ULL, 0x000fe200030e0639ULL, 0x0000c00042417811ULL, 0x000fe400078e20ffULL,
0x0000c0003c437811ULL, 0x000fe200078e20ffULL, 0x00000000283f7faeULL, 0x0003e8000d901c46ULL,
0x000000002a417faeULL, 0x0003e8000c101c46ULL, 0x0000000038437faeULL, 0x0003e2000e901c46ULL,
0x000002d000007947ULL, 0x000fea0003800000ULL, 0x0000000114387824ULL, 0x000fe200078e0207ULL,
0x000000f00f417812ULL, 0x000fe200078ec0ffULL, 0x00000100ff3f7424ULL, 0x000fc400078e00ffULL,
0x00000001383a7824ULL, 0x040fe200078e0217ULL, 0x0000000238287810ULL, 0x040fe20007ffe0ffULL,
0x00000010383b7824ULL, 0x040fe200078e00ffULL, 0x00000004382a7810ULL, 0x000fc60007ffe0ffULL,
0x0000000128297824ULL, 0x000fe200078e0217ULL, 0xfffffff03b427812ULL, 0x000fe200078ee23aULL,
0x00000001383a7824ULL, 0x040fe200078e0239ULL, 0x0000000638387810ULL, 0x000fe20007ffe0ffULL,
0x00000010283c7824ULL, 0x000fe200078e00ffULL, 0x0000c00042437811ULL, 0x000fe200078e20ffULL,
0x000000012a2b7824ULL, 0x040fe400078e0217ULL, 0x000000102a3e7824ULL, 0x000fe200078e00ffULL,
0xfffffff03c3c7812ULL, 0x000fe200078ee229ULL, 0x00005e003a3a7625ULL, 0x000fc600078e003fULL,
0xfffffff03e3e7812ULL, 0x000fe200078ee22bULL, 0x0000000139287824ULL, 0x040fe200078e0228ULL,
0x000000413a3a7210ULL, 0x000fe20007f7e0ffULL, 0x00000001392a7824ULL, 0x040fe400078e022aULL,
0x0000000139397824ULL, 0x000fe400078e0238ULL, 0x00005e0028287625ULL, 0x000fc800078e003fULL,
0x00000001383d7824ULL, 0x000fe200078e0217ULL, 0x0000004128287210ULL, 0x000fe20007f1e0ffULL,
0x0000001038407824ULL, 0x000fe400078e00ffULL, 0x00005e002a2a7625ULL, 0x000fc600078e003fULL,
0xfffffff040407812ULL, 0x000fe200078ee23dULL, 0x00005e0039387625ULL, 0x000fe200078e003fULL,
0x0000c0003c3d7811ULL, 0x000fe400078e20ffULL, 0x0000c0003e3f7811ULL, 0x000fe200078e20ffULL,
0x000000ffff3b7224ULL, 0x000fe200018e063bULL, 0x000000412a2a7210ULL, 0x080fe20007f7e0ffULL,
0x000000ffff297224ULL, 0x000fe200000e0629ULL, 0x0000004138387210ULL, 0x000fe40007f9e0ffULL,
0x0000c00040417811ULL, 0x000fe200078e20ffULL, 0x000000ffff2b7224ULL, 0x000fe200018e062bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a437faeULL, 0x0003e2000b901c46ULL,
0x000000ffff397224ULL, 0x000fc600020e0639ULL, 0x00000000283d7faeULL, 0x0003e8000b901c46ULL,
0x000000002a3f7faeULL, 0x0003e8000b901c46ULL, 0x0000000038417faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff2a7f8cULL, 0x000e64000c80043fULL, 0x0000000000287805ULL, 0x000fc40000015200ULL,
0x0106b400ff397984ULL, 0x000ea40000000800ULL, 0x8000000039ff7812ULL, 0x004fc4000780481bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fcc0000015200ULL, 0x00000038283b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000139397824ULL, 0x000fe200000e0e29ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff2a7819ULL, 0x002fc80000011439ULL,
0x0000003b2a2a7211ULL, 0x000fca00078110ffULL, 0x000000ffff397224ULL, 0x000fca00000e0639ULL,
0x000000022a2a7819ULL, 0x000fc80000001239ULL, 0x0000002a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013a3a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106b400ff397984ULL, 0x000ea40000000800ULL,
0x8000000039ff7812ULL, 0x004fe4000780481bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000014000007945ULL, 0x000fe20003800000ULL, 0x0000012000002947ULL, 0x000fea0003800000ULL,
0x0000000aff08723eULL, 0x000fe400000010ffULL, 0x00000002ff1b7819ULL, 0x000fe40000011617ULL,
0x00005410081a7816ULL, 0x000fe20000000008ULL, 0x000167627f007947ULL, 0x000fea000b800000ULL,
0x00001f1b1a097589ULL, 0x0004e400000e0000ULL, 0x000000081b557810ULL, 0x002fe20007ffe0ffULL,
0x000167927f007947ULL, 0x000fea000b800000ULL, 0x00001f551a087589ULL, 0x0002a400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000101b557810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff527224ULL, 0x000fe200078e001aULL, 0x0000499000427802ULL, 0x000fc40000000f00ULL,
0x000173f000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000181b557810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff527224ULL, 0x004fe200078e001aULL,
0x000049e000427802ULL, 0x000fc40000000f00ULL, 0x000173a000007944ULL, 0x008fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000150517824ULL, 0x040fe200078e0251ULL,
0x0000e00019197811ULL, 0x000fe200078e20ffULL, 0x00000010502a7824ULL, 0x042fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000150537824ULL, 0x040fe200078e0253ULL,
0x000000044f1b7810ULL, 0x044fe20007ffe0ffULL, 0x00000010501a7824ULL, 0x000fe200078e00ffULL,
0xfffffff02a2a7812ULL, 0x000fe200078ee251ULL, 0x000000084c387824ULL, 0x040fe200078e00ffULL,
0x000000064f287810ULL, 0x000fe20007ffe0ffULL, 0x000000084c397824ULL, 0x000fe200078e00ffULL,
0xfffffff01a297812ULL, 0x000fe200078ee253ULL, 0x000000001940783bULL, 0x000e620000004200ULL,
0x0000e0002a2a7811ULL, 0x000fc400078e20ffULL, 0x0000e00029297811ULL, 0x000fe400078e20ffULL,
0x0000e0004e1a7811ULL, 0x000fe200078e20ffULL, 0x000000002a3c783bULL, 0x000ea20000004200ULL,
0xfffffff8381b7812ULL, 0x000fe400078ee21bULL, 0xfffffff839287812ULL, 0x000fe200078ee228ULL,
0x000000002954783bULL, 0x000f280000004200ULL, 0x000000001a38783bULL, 0x000ee20000004200ULL,
0x000000ff404c7812ULL, 0x002fc400078ec0ffULL, 0x0000ffff40627812ULL, 0x000fe400078ec0ffULL,
0x000000ff414f7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff737819ULL, 0x104fe4000001163cULL,
0x000000ff3c817812ULL, 0x040fe400078ec0ffULL, 0x00000018ff807819ULL, 0x000fe4000001163cULL,
0x0000ffff3c707812ULL, 0x000fc400078ec0ffULL, 0x00000010ff717819ULL, 0x100fe4000001163dULL,
0x000000ff3d837812ULL, 0x040fe400078ec0ffULL, 0x00000018ff827819ULL, 0x000fe4000001163dULL,
0x0000ffff3d6f7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff3d7819ULL, 0x000fe4000001163eULL,
0x000000ff3e857812ULL, 0x000fc400078ec0ffULL, 0x00000018ff847819ULL, 0x000fe4000001163eULL,
0x0000ffff3e6d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff3c7819ULL, 0x100fe4000001163fULL,
0x000000ff3f877812ULL, 0x040fe400078ec0ffULL, 0x00000018ff867819ULL, 0x000fe4000001163fULL,
0x0000ffff3f6e7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff3e7819ULL, 0x100fe40000011640ULL,
0x00000018ff3f7819ULL, 0x000fe40000011640ULL, 0x00000010ff407819ULL, 0x100fe40000011641ULL,
0x00000018ff4e7819ULL, 0x000fe40000011641ULL, 0x0000ffff41647812ULL, 0x000fe400078ec0ffULL,
0x00000010ff727819ULL, 0x010fc40000011654ULL, 0x000000ff545a7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff767819ULL, 0x000fe40000011654ULL, 0x0000ffff54887812ULL, 0x000fe400078ec0ffULL,
0x00000010ff7a7819ULL, 0x100fe40000011656ULL, 0x000000ff567c7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff7b7819ULL, 0x000fc40000011656ULL, 0x0000ffff56747812ULL, 0x000fe400078ec0ffULL,
0x00000010ff417819ULL, 0x100fe40000011642ULL, 0x000000ff42507812ULL, 0x040fe400078ec0ffULL,
0x00000018ff527819ULL, 0x000fe40000011642ULL, 0x0000ffff428a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff777819ULL, 0x000fc40000011655ULL, 0x000000ff55797812ULL, 0x040fe400078ec0ffULL,
0x00000018ff787819ULL, 0x000fe40000011655ULL, 0x0000ffff55897812ULL, 0x000fe400078ec0ffULL,
0x00000010ff427819ULL, 0x100fe40000011643ULL, 0x000000ff43547812ULL, 0x000fe400078ec0ffULL,
0x00000018ff537819ULL, 0x000fc40000011643ULL, 0x0000ffff438b7812ULL, 0x000fe400078ec0ffULL,
0x000000ff38567812ULL, 0x048fe400078ec0ffULL, 0x00000010ff437819ULL, 0x100fe40000011638ULL,
0x00000018ff557819ULL, 0x000fe40000011638ULL, 0x0000ffff386c7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff387819ULL, 0x000fc40000011639ULL, 0x00000056ff56723eULL, 0x000fe400020006ffULL,
0x00000055ff55723eULL, 0x000fe400020006ffULL, 0x00000038ff38723eULL, 0x000fe200020006ffULL,
0x20000056ff597230ULL, 0x000fe20000004100ULL, 0x00000010ff6b7819ULL, 0x000fe20000011639ULL,
0x20000055ff567230ULL, 0x000fe20000004100ULL, 0x000000ff39587812ULL, 0x000fe200078ec0ffULL,
0x20000038ff557230ULL, 0x000fe20000004100ULL, 0x00000008ff387819ULL, 0x000fc40000011662ULL,
0x0000ffff39657812ULL, 0x000fe400078ec0ffULL, 0x00000018ff397819ULL, 0x000fe4000001163aULL,
0x00000038ff38723eULL, 0x000fe400020006ffULL, 0x0000004eff4e723eULL, 0x000fe400020006ffULL,
0x00000039ff39723eULL, 0x000fe200020006ffULL, 0x20000038ff687230ULL, 0x000fe20000004100ULL,
0x00000008ff387819ULL, 0x000fe2000001168aULL, 0x2000004eff677230ULL, 0x000fe20000004100ULL,
0x00000054ff54723eULL, 0x000fe200020006ffULL, 0x20000039ff4e7230ULL, 0x000fe20000004100ULL,
0x00000008ff397819ULL, 0x000fc40000011664ULL, 0x000000ff3a5f7812ULL, 0x000fe200078ec0ffULL,
0x20000054ff617230ULL, 0x000fe20000004100ULL, 0x00000038ff38723eULL, 0x000fe400020006ffULL,
0x000000ff3e3e7812ULL, 0x000fe400078ec0ffULL, 0x00000039ff39723eULL, 0x000fe400020006ffULL,
0x00000053ff53723eULL, 0x000fe400020006ffULL, 0x0000005fff54723eULL, 0x000fe200020006ffULL,
0x20000038ff5f7230ULL, 0x000fe20000004100ULL, 0x0000003eff3e723eULL, 0x000fe200020006ffULL,
0x20000039ff697230ULL, 0x000fe20000004100ULL, 0x0000005aff38723eULL, 0x000fe200020006ffULL,
0x20000053ff5e7230ULL, 0x000fe20000004100ULL, 0x00000010ff667819ULL, 0x000fe2000001163aULL,
0x2000003eff537230ULL, 0x000fe20000004100ULL, 0x0000ffff3a5c7812ULL, 0x000fe200078ec0ffULL,
0x20000038ff3e7230ULL, 0x000fe20000004100ULL, 0x00000018ff3a7819ULL, 0x000fe2000001163bULL,
0x20000054ff547230ULL, 0x000fe20000004100ULL, 0x00000008ff397819ULL, 0x000fc4000001168bULL,
0x0000004fff4f723eULL, 0x000fe400020006ffULL, 0x0000004cff4c723eULL, 0x000fe400020006ffULL,
0x000000ff3b607812ULL, 0x000fe400078ec0ffULL, 0x0000003aff3a723eULL, 0x000fe200020006ffULL,
0x2000004cff517230ULL, 0x000fe20000004100ULL, 0x00000039ff39723eULL, 0x000fe400020006ffULL,
0x0000a0001b387811ULL, 0x000fe200078e20ffULL, 0x2000003aff4c7230ULL, 0x000fe20000004100ULL,
0x00000050ff63723eULL, 0x000fe200020006ffULL, 0x2000004fff507230ULL, 0x000fe20000004100ULL,
0x00000010ff7d7819ULL, 0x000fc40000011657ULL, 0x000000ff577f7812ULL, 0x040fe200078ec0ffULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x00000018ff7e7819ULL, 0x000fe40000011657ULL,
0x0000ffff57757812ULL, 0x000fe400078ec0ffULL, 0x00000060ff4f723eULL, 0x000fe200020006ffULL,
0x20000039ff607230ULL, 0x000fe20000004100ULL, 0x00000010ff5b7819ULL, 0x000fe4000001163bULL,
0x0000ffff3b577812ULL, 0x000fe200078ec0ffULL, 0x2000004fff4f7230ULL, 0x000fe20000004100ULL,
0x000000003838783bULL, 0x000e620000000200ULL, 0x0000003fff3f723eULL, 0x000fc400020006ffULL,
0x000000ff40407812ULL, 0x000fe400078ec0ffULL, 0x000000ff41417812ULL, 0x000fe200078ec0ffULL,
0x2000003fff6a7230ULL, 0x000fe20000004100ULL, 0x00000052ff52723eULL, 0x000fe400020006ffULL,
0x00000040ff40723eULL, 0x000fe400020006ffULL, 0x00000041ff41723eULL, 0x000fe200020006ffULL,
0x20000052ff5d7230ULL, 0x000fe20000004100ULL, 0x000000ff723f7812ULL, 0x000fe200078ec0ffULL,
0x20000040ff527230ULL, 0x000fe20000004100ULL, 0x000000ff77777812ULL, 0x000fe200078ec0ffULL,
0x20000041ff647230ULL, 0x000fe20000004100ULL, 0x000000ff43437812ULL, 0x000fc400078ec0ffULL,
0x00000008ff407819ULL, 0x000fe40000011688ULL, 0x0000003fff3f723eULL, 0x000fe400020006ffULL,
0x000000ff42427812ULL, 0x000fe400078ec0ffULL, 0x00000079ff79723eULL, 0x000fe200020006ffULL,
0x2000003fff3f7230ULL, 0x000fe20000004100ULL, 0x00000008ff417819ULL, 0x000fe40000011689ULL,
0x00000077ff77723eULL, 0x000fe200020006ffULL, 0x20000079ff797230ULL, 0x000fe20000004100ULL,
0x00000043ff43723eULL, 0x000fc400020006ffULL, 0x00000076ff76723eULL, 0x000fe200020006ffULL,
0x20000077ff777230ULL, 0x000fe20000004100ULL, 0x00000040ff40723eULL, 0x000fe200020006ffULL,
0x20000043ff5a7230ULL, 0x000fe20000004100ULL, 0x00000042ff42723eULL, 0x000fe200020006ffULL,
0x20000076ff767230ULL, 0x000fe20000004100ULL, 0x00000078ff78723eULL, 0x000fe200020006ffULL,
0x20000040ff407230ULL, 0x000fe20000004100ULL, 0x00000041ff41723eULL, 0x000fe200020006ffULL,
0x20000042ff627230ULL, 0x000fe20000004100ULL, 0x000000ff7a7a7812ULL, 0x000fe200078ec0ffULL,
0x20000078ff787230ULL, 0x000fe20000004100ULL, 0x000000ff7d7d7812ULL, 0x000fe200078ec0ffULL,
0x20000041ff437230ULL, 0x000fe20000004100ULL, 0x00000010ff3e7819ULL, 0x000fe2000001163eULL,
0x000000093838a231ULL, 0x082fe200003400ffULL, 0x00000010ff3f7819ULL, 0x000fe2000001163fULL,
0x000000093a3aa231ULL, 0x000fe200003400ffULL, 0x00000010ff797819ULL, 0x000fe20000011679ULL,
0x000000083939a231ULL, 0x080fe200003400ffULL, 0x00000010ff427819ULL, 0x000fe20000011677ULL,
0x000000083b3ba231ULL, 0x000fe200003400ffULL, 0x00000008ff747819ULL, 0x000fc40000011674ULL,
0x00000008ff757819ULL, 0x000fe40000011675ULL, 0x0000007cff7c723eULL, 0x000fe400020006ffULL,
0x0000007fff7f723eULL, 0x000fe400020006ffULL, 0x0000007aff7a723eULL, 0x000fe200020006ffULL,
0x2000007cff7c7230ULL, 0x000fe20000004100ULL, 0x0000007dff7d723eULL, 0x000fe200020006ffULL,
0x2000007fff7f7230ULL, 0x000fe20000004100ULL, 0x000010543f3e7816ULL, 0x000fe2000000003eULL,
0x2000007aff7a7230ULL, 0x000fe20000004100ULL, 0x00000010ff417819ULL, 0x000fe20000011676ULL,
0x2000007dff7d7230ULL, 0x000fe20000004100ULL, 0x00000010ff407819ULL, 0x000fc40000011640ULL,
0x00001054423f7816ULL, 0x000fe40000000079ULL, 0x00000010ff787819ULL, 0x000fe40000011678ULL,
0x00000010ff437819ULL, 0x000fe40000011643ULL, 0x0000007bff7b723eULL, 0x000fe200020006ffULL,
0x0000003e3820723cULL, 0x000be20000041820ULL, 0x0000007eff7e723eULL, 0x000fe400020006ffULL,
0x00000074ff74723eULL, 0x000fe200020006ffULL, 0x2000007bff7b7230ULL, 0x000fe20000004100ULL,
0x00000075ff75723eULL, 0x000fe200020006ffULL, 0x2000007eff7e7230ULL, 0x000fe20000004100ULL,
0x0000105441407816ULL, 0x000fe20000000040ULL, 0x20000074ff747230ULL, 0x000fe20000004100ULL,
0x0000105478417816ULL, 0x000fe20000000043ULL, 0x20000075ff757230ULL, 0x000fe20000004100ULL,
0x000000ff73737812ULL, 0x000fc400078ec0ffULL, 0x000000ff3d3e7812ULL, 0x020fe400078ec0ffULL,
0x00000010ff7c7819ULL, 0x000fe2000001167cULL, 0x00000040381c723cULL, 0x000b62000004181cULL,
0x00000010ff3f7819ULL, 0x000fe4000001167fULL, 0x00000010ff3d7819ULL, 0x000fe4000001167aULL,
0x00000010ff427819ULL, 0x000fe4000001167dULL, 0x00000073ff73723eULL, 0x000fc400020006ffULL,
0x0000003eff43723eULL, 0x000fe400020006ffULL, 0x00000010ff7b7819ULL, 0x000fe2000001167bULL,
0x20000073ff737230ULL, 0x000fe20000004100ULL, 0x00000010ff7e7819ULL, 0x000fe4000001167eULL,
0x00000010ff747819ULL, 0x000fe40000011674ULL, 0x00000010ff417819ULL, 0x020fe20000011675ULL,
0x20000043ff757230ULL, 0x000fe20000004100ULL, 0x000010543d3e7816ULL, 0x000fc4000000007cULL,
0x00001054423f7816ULL, 0x000fe4000000003fULL, 0x000000ff3c3c7812ULL, 0x000fe400078ec0ffULL,
0x000000ff71717812ULL, 0x000fe400078ec0ffULL, 0x000010547b407816ULL, 0x000fe40000000074ULL,
0x000010547e417816ULL, 0x000fe40000000041ULL, 0x0000003cff42723eULL, 0x000fc400020006ffULL,
0x0000a00028747811ULL, 0x000fe200078e20ffULL, 0x0000003e383c723cULL, 0x040b620000041830ULL,
0x00000081ff81723eULL, 0x000fe400020006ffULL, 0x00000083ff83723eULL, 0x000fe400020006ffULL,
0x00000071ff71723eULL, 0x000fe200020006ffULL, 0x20000081ff817230ULL, 0x000fe20000004100ULL,
0x00000010ff307819ULL, 0x020fe20000011673ULL, 0x20000042ff737230ULL, 0x000fe20000004100ULL,
0x00000085ff85723eULL, 0x000fe200020006ffULL, 0x000000403840723cULL, 0x000b62000004182cULL,
0x20000083ff837230ULL, 0x000fe20000004100ULL, 0x00000000742c783bULL, 0x020e620000000200ULL,
0x20000071ff717230ULL, 0x000fe20000004100ULL, 0x00000010ff817819ULL, 0x000fe20000011681ULL,
0x20000085ff857230ULL, 0x000fe20000004100ULL, 0x00000010ff317819ULL, 0x000fc40000011683ULL,
0x00000010ff327819ULL, 0x000fe40000011671ULL, 0x00000087ff87723eULL, 0x000fe400020006ffULL,
0x0000105430307816ULL, 0x000fe40000000081ULL, 0x0000105432317816ULL, 0x000fe20000000031ULL,
0x20000087ff877230ULL, 0x000fe20000004100ULL, 0x00000008ff6d7819ULL, 0x000fe4000001166dULL,
0x00000008ff6e7819ULL, 0x000fc4000001166eULL, 0x00000084ff84723eULL, 0x000fe200020006ffULL,
0x000000303824723cULL, 0x000be20000041824ULL, 0x00000086ff86723eULL, 0x000fe400020006ffULL,
0x0000006dff6d723eULL, 0x000fe200020006ffULL, 0x20000084ff727230ULL, 0x000fe20000004100ULL,
0x0000006eff6e723eULL, 0x000fe200020006ffULL, 0x20000086ff867230ULL, 0x000fe20000004100ULL,
0x00000008ff707819ULL, 0x000fe20000011670ULL, 0x2000006dff6d7230ULL, 0x000fe20000004100ULL,
0x00000010ff857819ULL, 0x000fe20000011685ULL, 0x2000006eff6e7230ULL, 0x000fe20000004100ULL,
0x00000010ff317819ULL, 0x020fc40000011687ULL, 0x00000010ff307819ULL, 0x000fe40000011675ULL,
0x00000010ff327819ULL, 0x000fe40000011673ULL, 0x00000080ff80723eULL, 0x000fe400020006ffULL,
0x00000070ff70723eULL, 0x000fe400020006ffULL, 0x00000008ff6f7819ULL, 0x000fe2000001166fULL,
0x20000080ff807230ULL, 0x000fe20000004100ULL, 0x0000105430307816ULL, 0x000fe20000000085ULL,
0x20000070ff707230ULL, 0x000fe20000004100ULL, 0x0000105432317816ULL, 0x000fe20000000031ULL,
0x000000092c2ca231ULL, 0x082fe200003400ffULL, 0x00000010ff727819ULL, 0x000fe20000011672ULL,
0x000000092e2ea231ULL, 0x000fe200003400ffULL, 0x00000010ff737819ULL, 0x000fe20000011686ULL,
0x000000082d2da231ULL, 0x080fe200003400ffULL, 0x00000010ff6d7819ULL, 0x000fe2000001166dULL,
0x000000303848723cULL, 0x000be20000041848ULL, 0x00000010ff6e7819ULL, 0x000fe2000001166eULL,
0x000000082f2fa231ULL, 0x000fe200003400ffULL, 0x00000082ff82723eULL, 0x000fc400020006ffULL,
0x0000006fff6f723eULL, 0x000fe400020006ffULL, 0x0000105472727816ULL, 0x000fe2000000006dULL,
0x20000082ff827230ULL, 0x000fe20000004100ULL, 0x0000105473737816ULL, 0x000fe2000000006eULL,
0x2000006fff6f7230ULL, 0x000fe20000004100ULL, 0x00000010ff517819ULL, 0x000fe40000011651ULL,
0x00000010ff317819ULL, 0x020fe40000011650ULL, 0x00000010ff307819ULL, 0x000fc40000011653ULL,
0x00000010ff527819ULL, 0x000fe40000011652ULL, 0x00000010ff337819ULL, 0x000fe40000011680ULL,
0x00000010ff707819ULL, 0x000fe40000011670ULL, 0x0000105430307816ULL, 0x000fe40000000051ULL,
0x0000105452317816ULL, 0x000fe40000000031ULL, 0x00000010ff827819ULL, 0x000fe20000011682ULL,
0x000000723850723cULL, 0x000be20000041834ULL, 0x00000010ff6f7819ULL, 0x000fc4000001166fULL,
0x0000105433707816ULL, 0x000fe40000000070ULL, 0x00000010ff337819ULL, 0x000fe4000001166aULL,
0x00000010ff327819ULL, 0x000fe40000011667ULL, 0x00000010ff687819ULL, 0x000fe40000011668ULL,
0x00000010ff357819ULL, 0x020fe40000011669ULL, 0x0000105482717816ULL, 0x000fc4000000006fULL,
0x0000105433347816ULL, 0x000fe40000000068ULL, 0x0000105432357816ULL, 0x000fe40000000035ULL,
0x00000008ff6c7819ULL, 0x000fe2000001166cULL, 0x000000703844723cULL, 0x000b620000041844ULL,
0x00000010ff637819ULL, 0x000fe40000011663ULL, 0x00000010ff647819ULL, 0x000fe40000011664ULL,
0x00000010ff627819ULL, 0x000fc40000011662ULL, 0x00000010ff397819ULL, 0x020fe20000011661ULL,
0x000000342c34723cULL, 0x040b62000004181cULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x00000010ff5f7819ULL, 0x000fe4000001165fULL, 0x0000006cff6c723eULL, 0x000fe400020006ffULL,
0x00000010ff1c7819ULL, 0x020fe2000001165dULL, 0x000000302c30723cULL, 0x000f620000041820ULL,
0x00000010ff1d7819ULL, 0x000fe20000011660ULL, 0x2000006cff6c7230ULL, 0x000fe20000004100ULL,
0x00000008ff657819ULL, 0x000fc40000011665ULL, 0x000000ff66667812ULL, 0x000fe400078ec0ffULL,
0x0000105464387816ULL, 0x000fe40000000063ULL, 0x0000105462397816ULL, 0x000fe40000000039ULL,
0x000000ff6b6b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff5b5b7812ULL, 0x000fe400078ec0ffULL,
0x000010541c1c7816ULL, 0x000fe2000000005fULL, 0x000000382c38723cULL, 0x000f62000004183cULL,
0x000010545e1d7816ULL, 0x000fc4000000001dULL, 0x00000008ff5c7819ULL, 0x000fe4000001165cULL,
0x00000008ff577819ULL, 0x000fe40000011657ULL, 0x00000065ff65723eULL, 0x000fe200020006ffULL,
0x0000001c2c3c723cULL, 0x000b620000041840ULL, 0x00000066ff66723eULL, 0x000fe400020006ffULL,
0x00000058ff58723eULL, 0x000fe200020006ffULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x0000006bff6b723eULL, 0x000fe200020006ffULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x0000005bff1e723eULL, 0x000fe200020006ffULL, 0x20000058ff587230ULL, 0x000fe20000004100ULL,
0x0000005cff5c723eULL, 0x000fe200020006ffULL, 0x2000006bff6b7230ULL, 0x000fe20000004100ULL,
0x00000057ff57723eULL, 0x000fe200020006ffULL, 0x2000001eff1e7230ULL, 0x000fe20000004100ULL,
0x00000010ff1d7819ULL, 0x020fe20000011656ULL, 0x2000005cff5c7230ULL, 0x000fe20000004100ULL,
0x00000010ff6c7819ULL, 0x000fe2000001166cULL, 0x20000057ff577230ULL, 0x000fe20000004100ULL,
0x00000010ff1c7819ULL, 0x000fc40000011655ULL, 0x00000010ff217819ULL, 0x000fe40000011665ULL,
0x000010541d207816ULL, 0x000fe4000000006cULL, 0x00000010ff547819ULL, 0x000fe40000011654ULL,
0x00000010ff1d7819ULL, 0x000fe40000011666ULL, 0x00000010ff597819ULL, 0x000fe40000011659ULL,
0x00000010ff587819ULL, 0x000fc40000011658ULL, 0x00000010ff5a7819ULL, 0x000fe4000001165aULL,
0x00000010ff5b7819ULL, 0x000fe4000001166bULL, 0x00000010ff4f7819ULL, 0x000fe4000001164fULL,
0x00000010ff1e7819ULL, 0x000fe4000001161eULL, 0x00000010ff1f7819ULL, 0x000fe4000001164eULL,
0x00000010ff5c7819ULL, 0x000fc4000001165cULL, 0x00000010ff4c7819ULL, 0x000fe4000001164cULL,
0x00000010ff577819ULL, 0x000fe40000011657ULL, 0x000010541c217816ULL, 0x000fe40000000021ULL,
0x000010541d1c7816ULL, 0x000fe40000000054ULL, 0x000010545a5a7816ULL, 0x000fe40000000059ULL,
0x000010545b5b7816ULL, 0x000fe20000000058ULL, 0x000000202c20723cULL, 0x000b620000041844ULL,
0x000010541e1d7816ULL, 0x000fc4000000004fULL, 0x000010541f5c7816ULL, 0x000fe4000000005cULL,
0x000010544c5d7816ULL, 0x000fc60000000057ULL, 0x0000005a2c24723cULL, 0x040b700000041824ULL,
0x0000001c2c1c723cULL, 0x040b700000041848ULL, 0x0000005c2c2c723cULL, 0x000b620000041850ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff407f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000002010407810ULL, 0x002fe20007ffe0ffULL, 0x01068800ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff467224ULL, 0x020fc400078e0041ULL, 0x000000154000720cULL, 0x000fe20003f06070ULL,
0x000000ffff407224ULL, 0x000fd800078e004dULL, 0x0000ecd000000947ULL, 0x000fea0003800000ULL,
0x0000000000407805ULL, 0x000fc40000015200ULL, 0x0106bc00ff437984ULL, 0x000e640000000800ULL,
0x8000000043ff7812ULL, 0x002fe40007804846ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff447224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000427805ULL, 0x000fcc0000015200ULL,
0x0000004240457210ULL, 0x000fca0007f1e1ffULL, 0x0000000143437824ULL, 0x000fe200000e0e41ULL,
0x003d09004500780cULL, 0x000fc80003f06070ULL, 0x000000ff4300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404500780cULL, 0x000fc80003f06070ULL,
0x000000ff4300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff427819ULL, 0x000fc80000011443ULL, 0x0000004542427211ULL, 0x000fca00078110ffULL,
0x000000ffff437224ULL, 0x000fca00000e0643ULL, 0x0000000242427819ULL, 0x000fc80000001243ULL,
0x000000420000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000144447810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106bc00ff437984ULL, 0x000e640000000800ULL, 0x8000000043ff7812ULL, 0x002fe40007804846ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000004010427810ULL, 0x000fca0007ffe0ffULL,
0x0000620013457a24ULL, 0x000fe200078e0242ULL, 0x0000039000009947ULL, 0x000fea0003800000ULL,
0x0000000407517810ULL, 0x000fe20007ffe0ffULL, 0x0000000114447824ULL, 0x040fe200078e0207ULL,
0x0000004215407217ULL, 0x000fe40007800000ULL, 0x00000002074f7810ULL, 0x040fe20007ffe0ffULL,
0x0000000114487824ULL, 0x000fe200078e0251ULL, 0x0000000607537810ULL, 0x000fe20007ffe0ffULL,
0x0000000144437824ULL, 0x100fe200078e0217ULL, 0x000000f00f4b7812ULL, 0x000fe200078ec0ffULL,
0x0000000148497824ULL, 0x000fc400078e0217ULL, 0x00000010484e7824ULL, 0x000fe400078e00ffULL,
0x00000010444a7824ULL, 0x000fe400078e00ffULL, 0x0000000140417824ULL, 0x000fe200078e0a42ULL,
0xfffffff04e4e7812ULL, 0x000fe200078ee249ULL, 0x0000000114467824ULL, 0x000fe200078e024fULL,
0xfffffff04a4a7812ULL, 0x000fe200078ee243ULL, 0x00000100ff497424ULL, 0x000fe200078e00ffULL,
0x0000004114437217ULL, 0x000fe20007800000ULL, 0x0000000144407824ULL, 0x000fc400078e0245ULL,
0x0000000146477824ULL, 0x040fe400078e0217ULL, 0x00000010464c7824ULL, 0x000fe400078e00ffULL,
0x0000000114507824ULL, 0x000fe400078e0253ULL, 0x0000000146427824ULL, 0x000fe200078e0245ULL,
0xfffffff04c4c7812ULL, 0x000fe200078ee247ULL, 0x00005e0040407625ULL, 0x000fc800078e0049ULL,
0x0000000148447824ULL, 0x100fe200078e0245ULL, 0x0000004b40467210ULL, 0x000fe20007f1e0ffULL,
0x0000000143487824ULL, 0x000fe400078e0a14ULL, 0x0000000150457824ULL, 0x040fe400078e0245ULL,
0x0000000150477824ULL, 0x000fe200078e0217ULL, 0x000000480700720cULL, 0x080fe20003f66070ULL,
0x00005e0042427625ULL, 0x000fe200078e0049ULL, 0x000000484f00720cULL, 0x000fe40003f46070ULL,
0x0000e0004e4f7811ULL, 0x000fe200078e20ffULL, 0x0000001050507824ULL, 0x000fe200078e00ffULL,
0x0000004b42427210ULL, 0x000fc80007f9e0ffULL, 0xfffffff050507812ULL, 0x000fe200078ee247ULL,
0x000000ffff477224ULL, 0x000fe200000e0641ULL, 0x000000485100720cULL, 0x000fe20003f06070ULL,
0x00005e0044407625ULL, 0x000fe200078e0049ULL, 0x0000e00050517811ULL, 0x000fc600078e20ffULL,
0x00005e0045447625ULL, 0x000fe200078e0049ULL, 0x0000004b40407210ULL, 0x080fe40007fbe0ffULL,
0x0000e0004a497811ULL, 0x000fe200078e20ffULL, 0x000000ffff437224ULL, 0x000fe200020e0643ULL,
0x000000485300720cULL, 0x000fe20003f86070ULL, 0x000000ffff417224ULL, 0x000fe200028e0641ULL,
0x0000004b44447210ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000046497faeULL, 0x0003e2000d901c46ULL, 0x0000e0004c4b7811ULL, 0x000fc600078e20ffULL,
0x000000ffff457224ULL, 0x000fe400030e0645ULL, 0x00000000424b7faeULL, 0x0003e8000d101c46ULL,
0x00000000404f7faeULL, 0x0003e8000c101c46ULL, 0x0000000044517faeULL, 0x0003e2000e101c46ULL,
0x000002d000007947ULL, 0x000fea0003800000ULL, 0x0000000114407824ULL, 0x000fe200078e0207ULL,
0x000000f00f4b7812ULL, 0x000fe200078ec0ffULL, 0x00000100ff497424ULL, 0x000fc400078e00ffULL,
0x0000000140417824ULL, 0x140fe200078e0217ULL, 0x0000000440447810ULL, 0x040fe20007ffe0ffULL,
0x0000001040487824ULL, 0x040fe200078e00ffULL, 0x0000000240427810ULL, 0x040fe40007ffe0ffULL,
0x00000006404e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000144467824ULL, 0x000fe200078e0217ULL,
0xfffffff048487812ULL, 0x000fe200078ee241ULL, 0x0000001044477824ULL, 0x000fe400078e00ffULL,
0x0000000142437824ULL, 0x000fe200078e0217ULL, 0x0000e00048517811ULL, 0x000fe200078e20ffULL,
0x00000010424a7824ULL, 0x000fe200078e00ffULL, 0xfffffff0474c7812ULL, 0x000fe200078ee246ULL,
0x0000000140467824ULL, 0x000fc400078e0245ULL, 0x0000000142407824ULL, 0x000fe200078e0245ULL,
0xfffffff04a4a7812ULL, 0x000fe200078ee243ULL, 0x00005e0046467625ULL, 0x000fc800078e0049ULL,
0x0000000144427824ULL, 0x100fe200078e0245ULL, 0x0000004b46467210ULL, 0x000fe20007f5e0ffULL,
0x000000014e447824ULL, 0x000fe400078e0245ULL, 0x00005e0040407625ULL, 0x000fc800078e0049ULL,
0x00005e0042427625ULL, 0x000fe200078e0049ULL, 0x0000004b40407210ULL, 0x000fc60007f1e0ffULL,
0x000000014e4f7824ULL, 0x000fe400078e0217ULL, 0x00005e0044447625ULL, 0x000fe200078e0049ULL,
0x0000e0004a497811ULL, 0x000fc600078e20ffULL, 0x000000104e4e7824ULL, 0x000fe200078e00ffULL,
0x0000004b44447210ULL, 0x080fe20007f7e0ffULL, 0x000000ffff477224ULL, 0x000fe200010e0647ULL,
0x0000004b42427210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff417224ULL, 0x000fe200000e0641ULL,
0xfffffff04e4f7812ULL, 0x000fe200078ee24fULL, 0x000000ffff457224ULL, 0x000fe200018e0645ULL,
0x0000e0004c4b7811ULL, 0x000fe200078e20ffULL, 0x000000ffff437224ULL, 0x000fe200010e0643ULL,
0x0000e0004f4f7811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000046517faeULL, 0x0003e8000b901c46ULL, 0x0000000040497faeULL, 0x0003e8000b901c46ULL,
0x00000000424b7faeULL, 0x0003e8000b901c46ULL, 0x00000000444f7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff4e7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106280014447f8cULL, 0x0004e4000c80043fULL, 0x0000000000407805ULL, 0x000fc40000015200ULL,
0x01062c0014437984ULL, 0x000f240000000800ULL, 0x8000000043ff7812ULL, 0x018fc40007804845ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff467224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000427805ULL, 0x000fcc0000015200ULL, 0x0000004240477210ULL, 0x000fca0007f1e1ffULL,
0x0000000143437824ULL, 0x000fe200000e0e41ULL, 0x003d09004700780cULL, 0x000fc80003f06070ULL,
0x000000ff4300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404700780cULL, 0x000fc80003f06070ULL, 0x000000ff4300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff427819ULL, 0x000fc80000011443ULL,
0x0000004742427211ULL, 0x000fca00078110ffULL, 0x000000ffff437224ULL, 0x000fca00000e0643ULL,
0x0000000242427819ULL, 0x000fc80000001243ULL, 0x000000420000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000146467810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01062c0014437984ULL, 0x000ee40000000800ULL,
0x8000000043ff7812ULL, 0x008fe40007804845ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x010080000e447984ULL, 0x000ee80000000800ULL, 0x010280000e417984ULL, 0x0004620000000800ULL,
0x0000004d4400720bULL, 0x008fe20003f1d000ULL, 0x000142d27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000457806ULL, 0x004fc800000e0100ULL, 0x0000ffff45ff7812ULL, 0x000fe2000780c0ffULL,
0x0000048000007945ULL, 0x000fe20003800000ULL, 0x00000001ff467424ULL, 0x000fc400078e00ffULL,
0x000000ffff407224ULL, 0x000fd200078e004dULL, 0x0000044000008947ULL, 0x000fea0003800000ULL,
0x000000011800780cULL, 0x000fe40003f05270ULL, 0x0000004d4400720bULL, 0x000fe20003f54000ULL,
0x000142927f007947ULL, 0x000fd8000b800000ULL, 0x0000000000407806ULL, 0x000fc400010e0100ULL,
0x0000004d44438209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x0000991040427816ULL, 0x000fc600000000ffULL, 0x010480430e008388ULL, 0x0005e20000000800ULL,
0x000000ff4200720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000004d44427209ULL, 0x004fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff40ff7812ULL, 0x000fc6000780c0ffULL, 0x0000004d42427221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b42427820ULL, 0x000fc80000410000ULL, 0x0000004200477308ULL, 0x000ea40000000800ULL,
0x0000004712127220ULL, 0x004fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff557819ULL, 0x000fe20000011617ULL, 0x000141d27f007947ULL, 0x000fea000b800000ULL,
0x00001f5547427589ULL, 0x0004e400000e0000ULL, 0x0000004230307220ULL, 0x088fe20000410000ULL,
0x0000004231317220ULL, 0x080fe20000410000ULL, 0x0000004234347220ULL, 0x080fe20000410000ULL,
0x0000004235357220ULL, 0x080fe20000410000ULL, 0x0000004238387220ULL, 0x080fe20000410000ULL,
0x0000004239397220ULL, 0x080fe20000410000ULL, 0x000000423c3c7220ULL, 0x080fe20000410000ULL,
0x000000423d3d7220ULL, 0x080fe20000410000ULL, 0x0000004224247220ULL, 0x080fe20000410000ULL,
0x0000004225257220ULL, 0x080fe20000410000ULL, 0x0000004220207220ULL, 0x080fe20000410000ULL,
0x0000004221217220ULL, 0x080fe20000410000ULL, 0x000000421c1c7220ULL, 0x080fe20000410000ULL,
0x000000421d1d7220ULL, 0x080fe20000410000ULL, 0x000000422c2c7220ULL, 0x080fe20000410000ULL,
0x000000422d2d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0040ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000817557811ULL, 0x006fe200078ff0ffULL, 0x000140c27f007947ULL, 0x000fea000b800000ULL,
0x00001f5547427589ULL, 0x0002a400000e0000ULL, 0x0000004232327220ULL, 0x084fe20000410000ULL,
0x0000004233337220ULL, 0x080fe20000410000ULL, 0x0000004236367220ULL, 0x080fe20000410000ULL,
0x0000004237377220ULL, 0x080fe20000410000ULL, 0x000000423a3a7220ULL, 0x080fe20000410000ULL,
0x000000423b3b7220ULL, 0x080fe20000410000ULL, 0x000000423e3e7220ULL, 0x080fe20000410000ULL,
0x000000423f3f7220ULL, 0x080fe20000410000ULL, 0x0000004226267220ULL, 0x080fe20000410000ULL,
0x0000004227277220ULL, 0x080fe20000410000ULL, 0x0000004222227220ULL, 0x080fe20000410000ULL,
0x0000004223237220ULL, 0x080fe20000410000ULL, 0x000000421e1e7220ULL, 0x080fe20000410000ULL,
0x000000421f1f7220ULL, 0x080fe20000410000ULL, 0x000000422e2e7220ULL, 0x080fe20000410000ULL,
0x000000422f2f7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff40ff7812ULL, 0x000fe20007800845ULL, 0x00000001ff467424ULL, 0x000fe200078e00ffULL,
0x0000004d44407209ULL, 0x000fd60007810000ULL, 0x8000004044440221ULL, 0x000fe20000010000ULL,
0x00007610ff460816ULL, 0x000fc60000000046ULL, 0x3fb8aa3b44440820ULL, 0x000fc80000410000ULL,
0x00000044000a0308ULL, 0x000ea40000000800ULL, 0x0000000a41410220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001241127221ULL, 0x002fc20000010000ULL,
0x0000000000427805ULL, 0x000fcc0000015200ULL, 0x0106ac00ff447984ULL, 0x000e640000000800ULL,
0x8000000044ff7812ULL, 0x002fe4000780482bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff477224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104700780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000447805ULL, 0x000fcc0000015200ULL,
0x0000004442447210ULL, 0x000fca0007f1e1ffULL, 0x0000000145457824ULL, 0x000fe200000e0e43ULL,
0x003d09004400780cULL, 0x000fc80003f06070ULL, 0x000000ff4500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404400780cULL, 0x000fc80003f06070ULL,
0x000000ff4500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff417819ULL, 0x000fc80000011445ULL, 0x0000004441417211ULL, 0x000fca00078110ffULL,
0x000000ffff447224ULL, 0x000fca00000e0645ULL, 0x0000000241417819ULL, 0x000fc80000001244ULL,
0x000000410000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000147477810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106ac00ff447984ULL, 0x000e640000000800ULL, 0x8000000044ff7812ULL, 0x002fe4000780482bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009910462b7816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff2b00720cULL, 0x000fda0003f45270ULL,
0x0000012000002947ULL, 0x000fea0003800000ULL, 0x0000000aff08723eULL, 0x000fe400000010ffULL,
0x00000002ff447819ULL, 0x000fe40000011617ULL, 0x00005410082b7816ULL, 0x000fe20000000008ULL,
0x00013ca27f007947ULL, 0x000fea000b800000ULL, 0x00001f442b097589ULL, 0x0002a400000e0000ULL,
0x0000000844557810ULL, 0x002fe20007ffe0ffULL, 0x00013cd27f007947ULL, 0x000fea000b800000ULL,
0x00001f552b087589ULL, 0x0002e400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001044557810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff527224ULL, 0x000fe200078e002bULL,
0x0000764000427802ULL, 0x000fc40000000f00ULL, 0x0001474000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001844557810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff527224ULL, 0x004fe200078e002bULL, 0x0000769000427802ULL, 0x000fc40000000f00ULL,
0x000146f000007944ULL, 0x008fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000000654783bULL, 0x002e680000004200ULL,
0x000000000550783bULL, 0x004ea80000004200ULL, 0x000000000244783bULL, 0x000f280000004200ULL,
0x000000000448783bULL, 0x000ee20000004200ULL, 0x00000010ff737819ULL, 0x002fc40000011654ULL,
0x000000ff542b7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff4c7819ULL, 0x000fe40000011654ULL,
0x0000ffff54887812ULL, 0x000fe400078ec0ffULL, 0x00000010ff547819ULL, 0x100fe40000011655ULL,
0x000000ff55597812ULL, 0x000fe400078ec0ffULL, 0x00000018ff587819ULL, 0x000fc40000011655ULL,
0x0000ffff55897812ULL, 0x000fe400078ec0ffULL, 0x00000010ff777819ULL, 0x100fe40000011656ULL,
0x000000ff565a7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff557819ULL, 0x000fe40000011656ULL,
0x0000ffff568a7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff7d7819ULL, 0x004fc40000011651ULL,
0x000000ff51607812ULL, 0x040fe400078ec0ffULL, 0x00000018ff5f7819ULL, 0x000fe40000011651ULL,
0x0000ffff518d7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff567819ULL, 0x000fe40000011657ULL,
0x00000010ff5e7819ULL, 0x010fe40000011644ULL, 0x000000ff44837812ULL, 0x000fc400078ec0ffULL,
0x00000018ff827819ULL, 0x000fe40000011644ULL, 0x0000ffff44517812ULL, 0x000fe400078ec0ffULL,
0x00000018ff447819ULL, 0x000fe40000011645ULL, 0x00000056ff56723eULL, 0x000fe400020006ffULL,
0x00000044ff44723eULL, 0x000fe400020006ffULL, 0x00000010ff787819ULL, 0x000fe20000011657ULL,
0x20000056ff6e7230ULL, 0x000fe20000004100ULL, 0x000000ff575b7812ULL, 0x040fe200078ec0ffULL,
0x20000044ff567230ULL, 0x000fe20000004100ULL, 0x0000ffff578b7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff7c7819ULL, 0x100fe40000011650ULL, 0x000000ff505c7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff577819ULL, 0x000fe40000011650ULL, 0x0000ffff508c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff507819ULL, 0x000fe40000011645ULL, 0x000000ff45857812ULL, 0x000fc400078ec0ffULL,
0x0000ffff45437812ULL, 0x000fe400078ec0ffULL, 0x000000ff52627812ULL, 0x000fe400078ec0ffULL,
0x00000018ff457819ULL, 0x100fe40000011646ULL, 0x00000010ff4d7819ULL, 0x000fe40000011646ULL,
0x000000ff46867812ULL, 0x040fe400078ec0ffULL, 0x0000ffff46427812ULL, 0x000fc400078ec0ffULL,
0x00000018ff467819ULL, 0x000fe40000011647ULL, 0x00000008ff447819ULL, 0x000fe40000011688ULL,
0x00000010ff807819ULL, 0x100fe40000011652ULL, 0x00000018ff617819ULL, 0x000fe40000011652ULL,
0x0000ffff528e7812ULL, 0x000fe400078ec0ffULL, 0x0000002bff72723eULL, 0x000fc400020006ffULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x00000045ff45723eULL, 0x000fe200020006ffULL,
0x20000072ff727230ULL, 0x000fe20000004100ULL, 0x00000010ff817819ULL, 0x100fe20000011653ULL,
0x20000062ff667230ULL, 0x000fe20000004100ULL, 0x000000ff53637812ULL, 0x040fe400078ec0ffULL,
0x00000018ff527819ULL, 0x000fe40000011653ULL, 0x0000ffff538f7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff417819ULL, 0x000fe40000011647ULL, 0x000000ff47877812ULL, 0x040fe400078ec0ffULL,
0x0000ffff472b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff847819ULL, 0x108fe40000011648ULL,
0x000000ff48747812ULL, 0x000fe400078ec0ffULL, 0x00000018ff537819ULL, 0x000fc40000011648ULL,
0x0000ffff48907812ULL, 0x000fe400078ec0ffULL, 0x000000ff54547812ULL, 0x000fe400078ec0ffULL,
0x00000046ff47723eULL, 0x000fe400020006ffULL, 0x00000044ff44723eULL, 0x000fe400020006ffULL,
0x00000010ff487819ULL, 0x000fe4000001164aULL, 0x000000ff4a7b7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff7a7819ULL, 0x000fe4000001164aULL, 0x0000ffff4a677812ULL, 0x000fe400078ec0ffULL,
0x00000008ff467819ULL, 0x000fe40000011689ULL, 0x0000004cff4a723eULL, 0x000fe200020006ffULL,
0x20000045ff4c7230ULL, 0x000fe20000004100ULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x00000018ff767819ULL, 0x000fe20000011649ULL, 0x2000004aff4a7230ULL, 0x000fe20000004100ULL,
0x00000074ff62723eULL, 0x000fe200020006ffULL, 0x20000044ff747230ULL, 0x000fe20000004100ULL,
0x00000054ff45723eULL, 0x000fe200020006ffULL, 0x20000047ff547230ULL, 0x000fe20000004100ULL,
0x00000046ff46723eULL, 0x000fe200020006ffULL, 0x20000060ff6b7230ULL, 0x000fe20000004100ULL,
0x000000ff77447812ULL, 0x000fe200078ec0ffULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x000000ff78787812ULL, 0x000fe200078ec0ffULL, 0x20000046ff777230ULL, 0x000fe20000004100ULL,
0x00000008ff477819ULL, 0x000fc4000001168aULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x00000076ff60723eULL, 0x000fe200020006ffULL, 0x20000045ff767230ULL, 0x000fe20000004100ULL,
0x0000005aff5a723eULL, 0x000fe200020006ffULL, 0x20000063ff657230ULL, 0x000fe20000004100ULL,
0x00000061ff61723eULL, 0x000fe200020006ffULL, 0x20000060ff607230ULL, 0x000fe20000004100ULL,
0x00000044ff45723eULL, 0x000fe200020006ffULL, 0x2000005aff707230ULL, 0x000fe20000004100ULL,
0x000000ff49797812ULL, 0x000fe200078ec0ffULL, 0x20000061ff637230ULL, 0x000fe20000004100ULL,
0x00000078ff46723eULL, 0x000fe200020006ffULL, 0x20000045ff787230ULL, 0x000fe20000004100ULL,
0x00000047ff47723eULL, 0x000fc400020006ffULL, 0x0000a80000447811ULL, 0x000fe400078e20ffULL,
0x00000079ff61723eULL, 0x000fe200020006ffULL, 0x20000047ff797230ULL, 0x000fe20000004100ULL,
0x0000007aff5a723eULL, 0x000fe200020006ffULL, 0x20000046ff7a7230ULL, 0x000fe20000004100ULL,
0x000000ff73737812ULL, 0x000fe200078ec0ffULL, 0x000000004444783bULL, 0x000e620000000200ULL,
0x00000059ff59723eULL, 0x000fe200020006ffULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x00000073ff73723eULL, 0x000fe200020006ffULL, 0x20000061ff617230ULL, 0x000fe20000004100ULL,
0x00000010ff6a7819ULL, 0x100fe2000001164bULL, 0x20000059ff757230ULL, 0x000fe20000004100ULL,
0x000000ff4b7f7812ULL, 0x000fe200078ec0ffULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x00000018ff7e7819ULL, 0x000fc4000001164bULL, 0x0000ffff4b5d7812ULL, 0x000fe400078ec0ffULL,
0x00000058ff4b723eULL, 0x000fe400020006ffULL, 0x00000085ff58723eULL, 0x000fe400020006ffULL,
0x0000005fff5f723eULL, 0x000fe200020006ffULL, 0x2000004bff4b7230ULL, 0x000fe20000004100ULL,
0x00000008ff857819ULL, 0x000fe20000011690ULL, 0x20000058ff587230ULL, 0x000fe20000004100ULL,
0x00000010ff6f7819ULL, 0x000fe20000011649ULL, 0x2000005fff697230ULL, 0x000fe20000004100ULL,
0x0000005bff5b723eULL, 0x000fc400020006ffULL, 0x00000053ff53723eULL, 0x000fe400020006ffULL,
0x0000ffff49497812ULL, 0x000fe200078ec0ffULL, 0x2000005bff717230ULL, 0x000fe20000004100ULL,
0x00000085ff85723eULL, 0x000fe200020006ffULL, 0x20000053ff5f7230ULL, 0x000fe20000004100ULL,
0x00000010ff727819ULL, 0x000fe40000011672ULL, 0x00000010ff737819ULL, 0x000fe40000011673ULL,
0x00000010ff757819ULL, 0x000fc40000011675ULL, 0x00000010ff767819ULL, 0x000fe40000011676ULL,
0x00000008ff497819ULL, 0x000fe20000011649ULL, 0x000000094444a231ULL, 0x082fe200003400ffULL,
0x0000007bff5b723eULL, 0x000fe200020006ffULL, 0x000000094646a231ULL, 0x000fe200003400ffULL,
0x00000086ff53723eULL, 0x000fe200020006ffULL, 0x000000084545a231ULL, 0x080fe200003400ffULL,
0x00000008ff7b7819ULL, 0x000fe2000001168bULL, 0x000000084747a231ULL, 0x000fe200003400ffULL,
0x000000ff6f867812ULL, 0x000fe200078ec0ffULL, 0x20000085ff6f7230ULL, 0x000fe20000004100ULL,
0x0000105473727816ULL, 0x000fe20000000072ULL, 0x2000005bff5b7230ULL, 0x000fe20000004100ULL,
0x0000105476737816ULL, 0x000fe20000000075ULL, 0x20000053ff537230ULL, 0x000fe20000004100ULL,
0x00000049ff85723eULL, 0x000fc400020006ffULL, 0x000000ff48767812ULL, 0x000fe400078ec0ffULL,
0x00000010ff497819ULL, 0x000fe2000001164aULL, 0x20000085ff857230ULL, 0x000fe20000004100ULL,
0x00000010ff487819ULL, 0x000fe4000001164bULL, 0x00000010ff747819ULL, 0x000fe40000011674ULL,
0x00000010ff757819ULL, 0x000fe40000011677ULL, 0x00000055ff55723eULL, 0x000fc400020006ffULL,
0x0000007bff7b723eULL, 0x000fe400020006ffULL, 0x000000ff7c7c7812ULL, 0x000fe200078ec0ffULL,
0x20000055ff6d7230ULL, 0x000fe20000004100ULL, 0x0000105449747816ULL, 0x000fe20000000074ULL,
0x2000007bff7b7230ULL, 0x000fe20000004100ULL, 0x0000105448757816ULL, 0x000fe40000000075ULL,
0x000000724448723cULL, 0x000be20000041830ULL, 0x00000010ff707819ULL, 0x000fe40000011670ULL,
0x0000007cff7c723eULL, 0x000fc400020006ffULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x00000010ff317819ULL, 0x020fe20000011678ULL, 0x2000007cff7c7230ULL, 0x000fe20000004100ULL,
0x00000010ff307819ULL, 0x000fe2000001166dULL, 0x2000005cff6c7230ULL, 0x000fe20000004100ULL,
0x0000105431707816ULL, 0x000fe20000000070ULL, 0x000000744434723cULL, 0x000f620000041834ULL,
0x00000010ff6e7819ULL, 0x000fe4000001166eULL, 0x00000010ff797819ULL, 0x000fc40000011679ULL,
0x00000010ff317819ULL, 0x000fe4000001167bULL, 0x0000105430307816ULL, 0x000fe40000000079ULL,
0x000010546e317816ULL, 0x000fe40000000031ULL, 0x0000007eff59723eULL, 0x000fe400020006ffULL,
0x00000010ff337819ULL, 0x000fe4000001167cULL, 0x0000a80003327811ULL, 0x000fe200078e20ffULL,
0x00000030443c723cULL, 0x000be2000004183cULL, 0x000000ff7d7e7812ULL, 0x000fe200078ec0ffULL,
0x20000059ff597230ULL, 0x000fe20000004100ULL, 0x00000010ff6c7819ULL, 0x000fc4000001166cULL,
0x0000007eff7e723eULL, 0x000fe400020006ffULL, 0x00001054336c7816ULL, 0x000fe4000000006cULL,
0x000000003230783bULL, 0x020e620000000200ULL, 0x0000007fff5c723eULL, 0x000fe200020006ffULL,
0x2000007eff7e7230ULL, 0x000fe20000004100ULL, 0x00000008ff7f7819ULL, 0x000fe4000001168dULL,
0x00000057ff57723eULL, 0x000fe200020006ffULL, 0x2000005cff5c7230ULL, 0x000fe20000004100ULL,
0x00000082ff55723eULL, 0x000fc400020006ffULL, 0x000000ff80807812ULL, 0x000fe200078ec0ffULL,
0x20000057ff687230ULL, 0x000fe20000004100ULL, 0x000000ff81827812ULL, 0x000fe200078ec0ffULL,
0x20000055ff557230ULL, 0x000fe20000004100ULL, 0x000000ff6a6a7812ULL, 0x000fe400078ec0ffULL,
0x0000007fff7f723eULL, 0x000fe400020006ffULL, 0x00000008ff677819ULL, 0x000fe40000011667ULL,
0x00000080ff80723eULL, 0x000fe200020006ffULL, 0x2000007fff7f7230ULL, 0x000fe20000004100ULL,
0x00000082ff82723eULL, 0x000fc400020006ffULL, 0x00000083ff57723eULL, 0x000fe200020006ffULL,
0x20000080ff807230ULL, 0x000fe20000004100ULL, 0x0000006aff6a723eULL, 0x000fe200020006ffULL,
0x20000082ff827230ULL, 0x000fe20000004100ULL, 0x00000010ff6b7819ULL, 0x000fe2000001166bULL,
0x20000057ff577230ULL, 0x000fe20000004100ULL, 0x00000010ff7e7819ULL, 0x000fe2000001167eULL,
0x2000006aff727230ULL, 0x000fe20000004100ULL, 0x00000008ff7d7819ULL, 0x000fe4000001168cULL,
0x00000008ff817819ULL, 0x000fc4000001168eULL, 0x00000008ff837819ULL, 0x000fe4000001168fULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x00000008ff5d7819ULL, 0x000fe2000001165dULL,
0x000000093030a231ULL, 0x082fe200003400ffULL, 0x000010547e6d7816ULL, 0x000fe2000000006bULL,
0x20000067ff6a7230ULL, 0x000fe20000004100ULL, 0x00000052ff52723eULL, 0x000fe200020006ffULL,
0x000000093232a231ULL, 0x000fe200003400ffULL, 0x0000007dff7d723eULL, 0x000fe200020006ffULL,
0x000000083131a231ULL, 0x080fe200003400ffULL, 0x00000081ff81723eULL, 0x000fe200020006ffULL,
0x20000052ff647230ULL, 0x000fe20000004100ULL, 0x00000083ff83723eULL, 0x000fe200020006ffULL,
0x2000007dff7d7230ULL, 0x000fe20000004100ULL, 0x000000ff5e6b7812ULL, 0x000fe200078ec0ffULL,
0x20000081ff817230ULL, 0x000fe20000004100ULL, 0x00000010ff5e7819ULL, 0x000fe20000011669ULL,
0x20000083ff837230ULL, 0x000fe20000004100ULL, 0x00000010ff697819ULL, 0x000fe2000001167fULL,
0x0000006c4424723cULL, 0x000fe20000041824ULL, 0x0000005dff67723eULL, 0x000fe200020006ffULL,
0x000000083333a231ULL, 0x000fe200003400ffULL, 0x00000010ff667819ULL, 0x000fc40000011666ULL,
0x00000010ff657819ULL, 0x000fe40000011665ULL, 0x00000010ff5d7819ULL, 0x000fe40000011680ULL,
0x00000010ff827819ULL, 0x000fe40000011682ULL, 0x000010545e697816ULL, 0x000fe20000000069ULL,
0x20000067ff5e7230ULL, 0x000fe20000004100ULL, 0x000010545d667816ULL, 0x000fe40000000066ULL,
0x0000105482677816ULL, 0x000fc40000000065ULL, 0x000000ff50657812ULL, 0x000fe400078ec0ffULL,
0x00000008ff5d7819ULL, 0x000fe40000011651ULL, 0x00000010ff717819ULL, 0x000fe20000011671ULL,
0x00000066441c723cULL, 0x000fe2000004181cULL, 0x00000010ff7a7819ULL, 0x000fe4000001167aULL,
0x00000010ff687819ULL, 0x000fe40000011668ULL, 0x00000010ff7d7819ULL, 0x000fc4000001167dULL,
0x00000010ff507819ULL, 0x000fe40000011663ULL, 0x00000010ff647819ULL, 0x000fe40000011664ULL,
0x00000010ff817819ULL, 0x000fe40000011681ULL, 0x00000010ff517819ULL, 0x000fe40000011683ULL,
0x000010547a717816ULL, 0x000fe40000000071ULL, 0x0000105468687816ULL, 0x000fc4000000007dULL,
0x0000105450507816ULL, 0x000fe40000000081ULL, 0x0000105464517816ULL, 0x000fe20000000051ULL,
0x000000704438723cULL, 0x040f620000041838ULL, 0x00000010ff607819ULL, 0x000fe40000011660ULL,
0x00000010ff6f7819ULL, 0x000fe4000001166fULL, 0x00000008ff437819ULL, 0x000fe40000011643ULL,
0x00000065ff65723eULL, 0x000fe200020006ffULL, 0x000000684420723cULL, 0x000f620000041820ULL,
0x00000043ff43723eULL, 0x000fc400020006ffULL, 0x000000ff84847812ULL, 0x000fe200078ec0ffULL,
0x20000065ff657230ULL, 0x000fe20000004100ULL, 0x000000ff4d4d7812ULL, 0x000fe200078ec0ffULL,
0x20000043ff437230ULL, 0x000fe20000004100ULL, 0x00000008ff427819ULL, 0x000fe20000011642ULL,
0x00000050442c723cULL, 0x000b62000004182cULL, 0x00000008ff2b7819ULL, 0x000fe4000001162bULL,
0x00000087ff52723eULL, 0x000fe400020006ffULL, 0x00000084ff84723eULL, 0x000fc400020006ffULL,
0x00000010ff447819ULL, 0x020fe2000001165fULL, 0x20000052ff527230ULL, 0x000fe20000004100ULL,
0x00000010ff457819ULL, 0x000fe20000011685ULL, 0x20000084ff847230ULL, 0x000fe20000004100ULL,
0x0000105444447816ULL, 0x000fe4000000006fULL, 0x0000105460457816ULL, 0x000fe40000000045ULL,
0x00000086ff86723eULL, 0x000fe400020006ffULL, 0x00000076ff76723eULL, 0x000fc400020006ffULL,
0x0000006bff6b723eULL, 0x000fe200020006ffULL, 0x000000443034723cULL, 0x000b620000041834ULL,
0x0000005dff63723eULL, 0x000fe200020006ffULL, 0x20000086ff867230ULL, 0x000fe20000004100ULL,
0x0000004dff4d723eULL, 0x000fe200020006ffULL, 0x20000076ff767230ULL, 0x000fe20000004100ULL,
0x00000010ff6a7819ULL, 0x000fe2000001166aULL, 0x2000006bff6c7230ULL, 0x000fe20000004100ULL,
0x000000ff41447812ULL, 0x020fe200078ec0ffULL, 0x20000063ff647230ULL, 0x000fe20000004100ULL,
0x00000010ff417819ULL, 0x000fe2000001165aULL, 0x2000004dff4d7230ULL, 0x000fe20000004100ULL,
0x00000044ff44723eULL, 0x000fc400020006ffULL, 0x00000042ff42723eULL, 0x000fe400020006ffULL,
0x0000002bff2b723eULL, 0x000fe200020006ffULL, 0x20000044ff447230ULL, 0x000fe20000004100ULL,
0x00001054416a7816ULL, 0x000fe2000000006aULL, 0x20000042ff417230ULL, 0x000fe20000004100ULL,
0x00000010ff587819ULL, 0x000fe20000011658ULL, 0x2000002bff2b7230ULL, 0x000fe20000004100ULL,
0x00000010ff657819ULL, 0x000fe40000011665ULL, 0x00000010ff567819ULL, 0x000fc40000011656ULL,
0x00000010ff437819ULL, 0x000fe40000011643ULL, 0x00001054656d7816ULL, 0x000fe40000000058ULL,
0x0000105456657816ULL, 0x000fe40000000043ULL, 0x00000010ff627819ULL, 0x000fe40000011662ULL,
0x00000010ff617819ULL, 0x000fe40000011661ULL, 0x00000010ff5d7819ULL, 0x000fc40000011684ULL,
0x00000010ff867819ULL, 0x000fe40000011686ULL, 0x00000010ff5b7819ULL, 0x000fe4000001165bULL,
0x00000010ff5c7819ULL, 0x000fe4000001165cULL, 0x00000010ff767819ULL, 0x000fe40000011676ULL,
0x00000010ff777819ULL, 0x000fe40000011672ULL, 0x00000010ff597819ULL, 0x000fc40000011659ULL,
0x00000010ff5e7819ULL, 0x000fe4000001165eULL, 0x00000010ff577819ULL, 0x000fe40000011657ULL,
0x00000010ff6c7819ULL, 0x000fe4000001166cULL, 0x00000010ff557819ULL, 0x000fe40000011655ULL,
0x00000010ff647819ULL, 0x000fe40000011664ULL, 0x00000010ff537819ULL, 0x000fc40000011653ULL,
0x00000010ff427819ULL, 0x000fe4000001164dULL, 0x00000010ff437819ULL, 0x000fe40000011652ULL,
0x00000010ff447819ULL, 0x000fe40000011644ULL, 0x00000010ff4c7819ULL, 0x000fe4000001164cULL,
0x00000010ff417819ULL, 0x000fe40000011641ULL, 0x00000010ff547819ULL, 0x000fc40000011654ULL,
0x00000010ff2b7819ULL, 0x000fe4000001162bULL, 0x000010545d627816ULL, 0x000fe40000000062ULL,
0x0000105486637816ULL, 0x000fe40000000061ULL, 0x0000105476767816ULL, 0x000fe4000000005bULL,
0x0000105477777816ULL, 0x000fe4000000005cULL, 0x00001054596b7816ULL, 0x000fe2000000005eULL,
0x000000623048723cULL, 0x000b620000041848ULL, 0x000010546c6c7816ULL, 0x000fc40000000057ULL,
0x0000105455647816ULL, 0x000fe40000000064ULL, 0x0000105442427816ULL, 0x000fe40000000053ULL,
0x0000105444437816ULL, 0x000fe20000000043ULL, 0x000000763038723cULL, 0x000b620000041838ULL,
0x000010544c4c7816ULL, 0x000fe40000000041ULL, 0x00001054544d7816ULL, 0x000fca000000002bULL,
0x0000006a303c723cULL, 0x040b70000004183cULL, 0x0000006c3024723cULL, 0x040b700000041824ULL,
0x000000643020723cULL, 0x040b700000041820ULL, 0x00000042301c723cULL, 0x040b70000004181cULL,
0x0000004c302c723cULL, 0x000b62000004182cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff427f8cULL, 0x020e62000c80043fULL, 0x000000ffff417224ULL, 0x000fce00078e00ffULL,
0x0000000000307805ULL, 0x000fc40000015200ULL, 0x0106bc00ff2b7984ULL, 0x000ea40000000800ULL,
0x800000002bff7812ULL, 0x006fc40007804843ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104100780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x000fcc0000015200ULL, 0x0000003230327210ULL, 0x000fca0007f1e1ffULL,
0x0000000133337824ULL, 0x000fe200000e0e31ULL, 0x003d09003200780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403200780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff2b7819ULL, 0x000fc80000011433ULL,
0x000000322b2b7211ULL, 0x000fca00078110ffULL, 0x000000ffff327224ULL, 0x000fca00000e0633ULL,
0x000000022b2b7819ULL, 0x000fc80000001232ULL, 0x0000002b0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000141417810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106bc00ff2b7984ULL, 0x000e640000000800ULL,
0x800000002bff7812ULL, 0x002fe40007804843ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000006010307810ULL, 0x000fca0007ffe0ffULL, 0x0000620013427a24ULL, 0x000fe200078e0230ULL,
0x0000039000009947ULL, 0x000fea0003800000ULL, 0x00000030152b7217ULL, 0x000fe20007800000ULL,
0x0000000114317824ULL, 0x040fe200078e0207ULL, 0x0000000407517810ULL, 0x040fe20007ffe0ffULL,
0x00000100ff437424ULL, 0x000fe200078e00ffULL, 0x00000002074d7810ULL, 0x000fe20007ffe0ffULL,
0x000000012b2b7824ULL, 0x000fe200078e0a30ULL, 0x000000f00f417812ULL, 0x000fe200078ec0ffULL,
0x0000000114457824ULL, 0x040fe400078e0251ULL, 0x0000000131307824ULL, 0x040fe200078e0242ULL,
0x0000002b142b7217ULL, 0x000fe20007800000ULL, 0x0000000131327824ULL, 0x000fc400078e0217ULL,
0x0000001031477824ULL, 0x000fe400078e00ffULL, 0x0000000145447824ULL, 0x040fe400078e0217ULL,
0x0000001045537824ULL, 0x000fe200078e00ffULL, 0xfffffff047477812ULL, 0x000fe200078ee232ULL,
0x00005e0030307625ULL, 0x000fc600078e0043ULL, 0xfffffff053507812ULL, 0x000fe200078ee244ULL,
0x0000000114327824ULL, 0x000fe200078e024dULL, 0x0000004130447210ULL, 0x000fe20007f1e0ffULL,
0x000000012b467824ULL, 0x000fe200078e0a14ULL, 0x0000000607537810ULL, 0x000fe20007ffe0ffULL,
0x0000000132307824ULL, 0x140fe200078e0242ULL, 0x0000c00047477811ULL, 0x000fe200078e20ffULL,
0x0000000132337824ULL, 0x040fe200078e0217ULL, 0x000000460700720cULL, 0x080fe20003f86070ULL,
0x00000010324c7824ULL, 0x000fe200078e00ffULL, 0x000000464d00720cULL, 0x000fe20003f66070ULL,
0x0000000145327824ULL, 0x000fc400078e0242ULL, 0x000000ffff457224ULL, 0x000fe200000e0631ULL,
0xfffffff04c4c7812ULL, 0x000fe200078ee233ULL, 0x00005e0030307625ULL, 0x000fe200078e0043ULL,
0x000000465100720cULL, 0x000fc60003f06070ULL, 0x00000001142b7824ULL, 0x000fe200078e0253ULL,
0x0000004130307210ULL, 0x000fe20007fbe0ffULL, 0x00005e0032327625ULL, 0x000fe200078e0043ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000044477faeULL, 0x0003e6000e101c46ULL,
0x000000012b427824ULL, 0x000fe200078e0242ULL, 0x0000004132327210ULL, 0x000fe20007fde0ffULL,
0x000000ffff317224ULL, 0x000fe200028e0631ULL, 0x000000465300720cULL, 0x000fe20003fa6070ULL,
0x00005e0042427625ULL, 0x000fc800078e0043ULL, 0x000000012b4d7824ULL, 0x040fe400078e0217ULL,
0x000000102b527824ULL, 0x000fe200078e00ffULL, 0x0000c0004c2b7811ULL, 0x000fe200078e20ffULL,
0x000000ffff337224ULL, 0x000fe200030e0633ULL, 0x0000004142427210ULL, 0x000fe40007fde0ffULL,
0xfffffff0524d7812ULL, 0x000fe200078ee24dULL, 0x00000000302b7faeULL, 0x0003e2000d901c46ULL,
0x0000c00050417811ULL, 0x000fe200078e20ffULL, 0x000000ffff437224ULL, 0x000fe200030e0643ULL,
0x0000c0004d4d7811ULL, 0x000fc600078e20ffULL, 0x0000000032417faeULL, 0x0003e8000c101c46ULL,
0x00000000424d7faeULL, 0x0003e2000e901c46ULL, 0x000002d000007947ULL, 0x000fea0003800000ULL,
0x00000001142b7824ULL, 0x000fc800078e0207ULL, 0x000000012b307824ULL, 0x140fe200078e0217ULL,
0x000000042b337810ULL, 0x040fe20007ffe0ffULL, 0x000000102b437824ULL, 0x040fe200078e00ffULL,
0x000000022b317810ULL, 0x040fe20007ffe0ffULL, 0x000000012b447824ULL, 0x040fe200078e0242ULL,
0x000000062b2b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000133417824ULL, 0x100fe200078e0217ULL,
0xfffffff043467812ULL, 0x000fe200078ee230ULL, 0x00000010334c7824ULL, 0x000fe400078e00ffULL,
0x0000000131327824ULL, 0x000fc400078e0217ULL, 0x0000001031477824ULL, 0x000fe200078e00ffULL,
0xfffffff04c4c7812ULL, 0x000fe200078ee241ULL, 0x00000100ff437424ULL, 0x000fe200078e00ffULL,
0x000000f00f417812ULL, 0x000fe200078ec0ffULL, 0x0000000131307824ULL, 0x000fe200078e0242ULL,
0xfffffff047477812ULL, 0x000fe200078ee232ULL, 0x00005e0044447625ULL, 0x000fc600078e0043ULL,
0x0000c00047477811ULL, 0x000fe200078e20ffULL, 0x0000000133327824ULL, 0x100fe200078e0242ULL,
0x0000004144447210ULL, 0x000fe20007f7e0ffULL, 0x000000012b427824ULL, 0x000fe400078e0242ULL,
0x00005e0030307625ULL, 0x000fc800078e0043ULL, 0x00005e0032327625ULL, 0x000fe200078e0043ULL,
0x0000004130307210ULL, 0x000fc60007f1e0ffULL, 0x00005e0042427625ULL, 0x000fc800078e0043ULL,
0x000000012b4d7824ULL, 0x040fe200078e0217ULL, 0x0000004142427210ULL, 0x080fe20007f9e0ffULL,
0x000000102b507824ULL, 0x000fe200078e00ffULL, 0x0000c000462b7811ULL, 0x000fe200078e20ffULL,
0x000000ffff457224ULL, 0x000fe200018e0645ULL, 0x0000004132327210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff317224ULL, 0x000fe200000e0631ULL, 0xfffffff0504d7812ULL, 0x000fe200078ee24dULL,
0x000000ffff437224ULL, 0x000fe200020e0643ULL, 0x0000c0004c417811ULL, 0x000fe200078e20ffULL,
0x000000ffff337224ULL, 0x000fe200018e0633ULL, 0x0000c0004d4d7811ULL, 0x000fe200078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000442b7faeULL, 0x0003e8000b901c46ULL,
0x0000000030477faeULL, 0x0003e8000b901c46ULL, 0x0000000032417faeULL, 0x0003e8000b901c46ULL,
0x00000000424d7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff307f8cULL, 0x000e64000c80043fULL,
0x000000ffff2b7224ULL, 0x002fc400078e0031ULL, 0x0000000000307805ULL, 0x000fca0000015200ULL,
0x0106b400ff337984ULL, 0x000e640000000800ULL, 0x8000000033ff7812ULL, 0x002fc4000780484fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff427224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x000fcc0000015200ULL, 0x0000003230417210ULL, 0x000fca0007f1e1ffULL,
0x0000000133337824ULL, 0x000fe200000e0e31ULL, 0x003d09004100780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404100780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff327819ULL, 0x000fc80000011433ULL,
0x0000004132327211ULL, 0x000fca00078110ffULL, 0x000000ffff337224ULL, 0x000fca00000e0633ULL,
0x0000000232327819ULL, 0x000fc80000001233ULL, 0x000000320000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000142427810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106b400ff337984ULL, 0x000e640000000800ULL,
0x8000000033ff7812ULL, 0x002fe4000780484fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000014000007945ULL, 0x000fe20003800000ULL, 0x0000012000002947ULL, 0x000fea0003800000ULL,
0x0000000aff08723eULL, 0x000fe400000010ffULL, 0x00000002ff317819ULL, 0x000fe40000011617ULL,
0x0000541008307816ULL, 0x000fe20000000008ULL, 0x00011a027f007947ULL, 0x000fea000b800000ULL,
0x00001f3130097589ULL, 0x0002a400000e0000ULL, 0x0000000831557810ULL, 0x002fe20007ffe0ffULL,
0x00011a327f007947ULL, 0x000fea000b800000ULL, 0x00001f5530087589ULL, 0x0002e400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001031557810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff527224ULL, 0x000fe200078e0030ULL, 0x0000999000427802ULL, 0x000fc40000000f00ULL,
0x000123f000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001831557810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff527224ULL, 0x004fe200078e0030ULL,
0x000099e000427802ULL, 0x000fc40000000f00ULL, 0x000123a000007944ULL, 0x008fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000002950783bULL, 0x004ea80000004200ULL, 0x000000002a4c783bULL, 0x000f280000004200ULL,
0x000000001a30783bULL, 0x002e680000004200ULL, 0x000000001944783bULL, 0x000ee20000004200ULL,
0x00000010ff737819ULL, 0x004fc40000011651ULL, 0x00000010ff717819ULL, 0x100fe40000011650ULL,
0x000000ff4e5e7812ULL, 0x010fe400078ec0ffULL, 0x000000ff73737812ULL, 0x000fe400078ec0ffULL,
0x000000ff50417812ULL, 0x040fe400078ec0ffULL, 0x00000018ff547819ULL, 0x000fe40000011650ULL,
0x0000ffff50887812ULL, 0x000fc400078ec0ffULL, 0x0000005eff5e723eULL, 0x000fe400020006ffULL,
0x000000ff51567812ULL, 0x040fe400078ec0ffULL, 0x00000018ff557819ULL, 0x000fe20000011651ULL,
0x2000005eff657230ULL, 0x000fe20000004100ULL, 0x0000ffff51897812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5d7819ULL, 0x002fe40000011630ULL, 0x000000ff30847812ULL, 0x000fc400078ec0ffULL,
0x00000018ff817819ULL, 0x000fe40000011630ULL, 0x0000ffff30507812ULL, 0x000fe400078ec0ffULL,
0x00000010ff777819ULL, 0x100fe40000011652ULL, 0x000000ff52577812ULL, 0x040fe400078ec0ffULL,
0x00000018ff517819ULL, 0x000fe40000011652ULL, 0x0000ffff528a7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff767819ULL, 0x008fe40000011645ULL, 0x00000018ff307819ULL, 0x000fe40000011631ULL,
0x00000073ff73723eULL, 0x000fe400020006ffULL, 0x00000010ff787819ULL, 0x100fe40000011653ULL,
0x000000ff53587812ULL, 0x000fe400078ec0ffULL, 0x00000018ff527819ULL, 0x000fc40000011653ULL,
0x0000ffff538b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff7b7819ULL, 0x100fe4000001164cULL,
0x000000ff4c597812ULL, 0x040fe400078ec0ffULL, 0x00000018ff537819ULL, 0x000fe4000001164cULL,
0x0000ffff4c8c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff7d7819ULL, 0x000fc4000001164dULL,
0x000000ff4d5b7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff5a7819ULL, 0x000fe4000001164dULL,
0x0000ffff4d8d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff827819ULL, 0x100fe4000001164fULL,
0x000000ff4f607812ULL, 0x000fe400078ec0ffULL, 0x00000018ff5f7819ULL, 0x000fc4000001164fULL,
0x0000ffff4f8f7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff4d7819ULL, 0x000fe4000001164eULL,
0x00000010ff4f7819ULL, 0x000fe40000011631ULL, 0x000000ff31857812ULL, 0x040fe400078ec0ffULL,
0x0000ffff314c7812ULL, 0x000fe400078ec0ffULL, 0x00000054ff54723eULL, 0x000fc400020006ffULL,
0x00000018ff317819ULL, 0x000fe40000011632ULL, 0x00000076ff5e723eULL, 0x000fe200020006ffULL,
0x20000073ff767230ULL, 0x000fe20000004100ULL, 0x00000030ff30723eULL, 0x000fe200020006ffULL,
0x20000054ff6f7230ULL, 0x000fe20000004100ULL, 0x00000010ff6b7819ULL, 0x000fe20000011645ULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x000000ff45797812ULL, 0x040fe200078ec0ffULL,
0x20000030ff547230ULL, 0x000fe20000004100ULL, 0x0000ffff456e7812ULL, 0x000fc400078ec0ffULL,
0x00000041ff45723eULL, 0x000fe400020006ffULL, 0x00000008ff737819ULL, 0x000fe4000001168bULL,
0x0000004dff4d723eULL, 0x000fe200020006ffULL, 0x20000045ff727230ULL, 0x000fe20000004100ULL,
0x00000031ff31723eULL, 0x000fe400020006ffULL, 0x00000010ff7f7819ULL, 0x000fe2000001164eULL,
0x2000004dff627230ULL, 0x000fe20000004100ULL, 0x0000ffff4e8e7812ULL, 0x000fe200078ec0ffULL,
0x20000031ff4d7230ULL, 0x000fe20000004100ULL, 0x000000ff44747812ULL, 0x000fc400078ec0ffULL,
0x000000ff467c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff4e7819ULL, 0x000fe40000011632ULL,
0x000000ff32867812ULL, 0x040fe400078ec0ffULL, 0x0000ffff32437812ULL, 0x000fe400078ec0ffULL,
0x00000008ff307819ULL, 0x000fe40000011688ULL, 0x00000073ff73723eULL, 0x000fc400020006ffULL,
0x00000018ff327819ULL, 0x000fe40000011633ULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x0000005bff45723eULL, 0x000fe400020006ffULL, 0x00000018ff617819ULL, 0x000fe20000011644ULL,
0x2000005fff637230ULL, 0x000fe20000004100ULL, 0x0000005aff5a723eULL, 0x000fe200020006ffULL,
0x20000045ff457230ULL, 0x000fe20000004100ULL, 0x00000074ff74723eULL, 0x000fc400020006ffULL,
0x0000007cff5b723eULL, 0x000fe200020006ffULL, 0x2000005aff677230ULL, 0x000fe20000004100ULL,
0x00000053ff53723eULL, 0x000fe400020006ffULL, 0x00000030ff30723eULL, 0x000fe200020006ffULL,
0x2000005bff5b7230ULL, 0x000fe20000004100ULL, 0x00000008ff317819ULL, 0x000fe20000011689ULL,
0x20000053ff667230ULL, 0x000fe20000004100ULL, 0x000000ff7b7c7812ULL, 0x000fe200078ec0ffULL,
0x20000073ff7b7230ULL, 0x000fe20000004100ULL, 0x000000ff47807812ULL, 0x000fc400078ec0ffULL,
0x00000032ff32723eULL, 0x000fe400020006ffULL, 0x00000008ff737819ULL, 0x000fe4000001168dULL,
0x00000055ff55723eULL, 0x000fe200020006ffULL, 0x20000032ff537230ULL, 0x000fe20000004100ULL,
0x00000061ff5f723eULL, 0x000fe200020006ffULL, 0x20000074ff617230ULL, 0x000fe20000004100ULL,
0x00000031ff31723eULL, 0x000fe200020006ffULL, 0x20000030ff747230ULL, 0x000fe20000004100ULL,
0x00000080ff5a723eULL, 0x000fe200020006ffULL, 0x20000055ff707230ULL, 0x000fe20000004100ULL,
0x000000ff77307812ULL, 0x000fe200078ec0ffULL, 0x20000031ff777230ULL, 0x000fe20000004100ULL,
0x000000ff7f807812ULL, 0x000fe200078ec0ffULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x00000073ff73723eULL, 0x000fe200020006ffULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x000000ff78787812ULL, 0x000fc400078ec0ffULL, 0x00000008ff327819ULL, 0x000fe4000001168aULL,
0x00000057ff57723eULL, 0x000fe400020006ffULL, 0x00000058ff58723eULL, 0x000fe400020006ffULL,
0x00000060ff60723eULL, 0x000fe200020006ffULL, 0x20000057ff6c7230ULL, 0x000fe20000004100ULL,
0x00000081ff55723eULL, 0x000fe200020006ffULL, 0x20000058ff6d7230ULL, 0x000fe20000004100ULL,
0x00000010ff427819ULL, 0x000fe20000011633ULL, 0x20000060ff647230ULL, 0x000fe20000004100ULL,
0x000000ff33877812ULL, 0x040fe200078ec0ffULL, 0x20000055ff557230ULL, 0x000fe20000004100ULL,
0x0000ffff33417812ULL, 0x000fc400078ec0ffULL, 0x00000030ff31723eULL, 0x000fe400020006ffULL,
0x00000080ff81723eULL, 0x000fe200020006ffULL, 0x20000073ff807230ULL, 0x000fe20000004100ULL,
0x00000018ff7a7819ULL, 0x000fe40000011646ULL, 0x00000018ff7e7819ULL, 0x000fe20000011647ULL,
0x20000081ff817230ULL, 0x000fe20000004100ULL, 0x00000078ff33723eULL, 0x000fe200020006ffULL,
0x20000031ff787230ULL, 0x000fe20000004100ULL, 0x00000032ff32723eULL, 0x000fc400020006ffULL,
0x0000a8001b307811ULL, 0x000fe400078e20ffULL, 0x00000010ff837819ULL, 0x000fe40000011644ULL,
0x0000ffff44907812ULL, 0x000fe400078ec0ffULL, 0x00000056ff56723eULL, 0x000fe400020006ffULL,
0x00000008ff737819ULL, 0x000fe4000001168fULL, 0x00000010ff447819ULL, 0x000fe20000011647ULL,
0x20000056ff757230ULL, 0x000fe20000004100ULL, 0x0000ffff475c7812ULL, 0x000fc400078ec0ffULL,
0x00000059ff47723eULL, 0x000fe400020006ffULL, 0x00000079ff60723eULL, 0x000fe200020006ffULL,
0x20000032ff797230ULL, 0x000fe20000004100ULL, 0x0000007aff58723eULL, 0x000fe200020006ffULL,
0x20000033ff7a7230ULL, 0x000fe20000004100ULL, 0x0000007eff59723eULL, 0x000fe200020006ffULL,
0x000000003030783bULL, 0x000e620000000200ULL, 0x00000084ff57723eULL, 0x000fe200020006ffULL,
0x20000047ff477230ULL, 0x000fe20000004100ULL, 0x000000ff7d7e7812ULL, 0x000fe200078ec0ffULL,
0x20000060ff607230ULL, 0x000fe20000004100ULL, 0x000000ff83847812ULL, 0x000fe200078ec0ffULL,
0x20000059ff597230ULL, 0x000fe20000004100ULL, 0x00000073ff73723eULL, 0x000fe200020006ffULL,
0x20000057ff577230ULL, 0x000fe20000004100ULL, 0x00000008ff7d7819ULL, 0x000fe2000001168cULL,
0x20000058ff587230ULL, 0x000fe20000004100ULL, 0x00000085ff56723eULL, 0x000fc400020006ffULL,
0x0000007eff7e723eULL, 0x000fe400020006ffULL, 0x00000084ff85723eULL, 0x000fe200020006ffULL,
0x20000073ff847230ULL, 0x000fe20000004100ULL, 0x0000007dff7d723eULL, 0x000fe200020006ffULL,
0x2000007eff7f7230ULL, 0x000fe20000004100ULL, 0x00000010ff737819ULL, 0x000fe20000011675ULL,
0x20000085ff857230ULL, 0x000fe20000004100ULL, 0x00000010ff707819ULL, 0x000fe20000011670ULL,
0x2000007dff7e7230ULL, 0x000fe20000004100ULL, 0x00000010ff757819ULL, 0x000fe20000011677ULL,
0x20000056ff567230ULL, 0x000fe20000004100ULL, 0x00000052ff52723eULL, 0x000fc400020006ffULL,
0x000000ff82827812ULL, 0x000fe400078ec0ffULL, 0x00000010ff6f7819ULL, 0x000fe2000001166fULL,
0x20000052ff697230ULL, 0x000fe20000004100ULL, 0x00000010ff747819ULL, 0x000fe40000011674ULL,
0x00000008ff7d7819ULL, 0x000fe4000001168eULL, 0x0000105470757816ULL, 0x000fe40000000075ULL,
0x000000ff44707812ULL, 0x000fc400078ec0ffULL, 0x00000010ff447819ULL, 0x000fe2000001166dULL,
0x000000093030a231ULL, 0x082fe200003400ffULL, 0x00000082ff82723eULL, 0x000fe200020006ffULL,
0x000000093232a231ULL, 0x000fe200003400ffULL, 0x000010546f747816ULL, 0x000fe20000000074ULL,
0x000000083131a231ULL, 0x080fe200003400ffULL, 0x00000010ff6c7819ULL, 0x000fe2000001166cULL,
0x20000082ff837230ULL, 0x000fe20000004100ULL, 0x00000010ff6d7819ULL, 0x000fe20000011678ULL,
0x000000083333a231ULL, 0x000fe200003400ffULL, 0x0000007dff7d723eULL, 0x000fc400020006ffULL,
0x00000010ff6f7819ULL, 0x000fe4000001167aULL, 0x00000010ff6a7819ULL, 0x000fe20000011646ULL,
0x2000007dff827230ULL, 0x000fe20000004100ULL, 0x0000ffff46467812ULL, 0x000fe200078ec0ffULL,
0x000000743034723cULL, 0x000fe20000041834ULL, 0x0000007cff7c723eULL, 0x000fe400020006ffULL,
0x00000086ff52723eULL, 0x000fe400020006ffULL, 0x000010546d6c7816ULL, 0x000fe2000000006cULL,
0x2000007cff7c7230ULL, 0x000fe20000004100ULL, 0x00000008ff867819ULL, 0x000fe20000011690ULL,
0x20000052ff527230ULL, 0x000fe20000004100ULL, 0x000010546f6d7816ULL, 0x000fc40000000044ULL,
0x00000010ff447819ULL, 0x000fe40000011669ULL, 0x000000ff6b7d7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff467819ULL, 0x000fe20000011646ULL, 0x0000006c3038723cULL, 0x000fe20000041838ULL,
0x00000010ff697819ULL, 0x000fe4000001167bULL, 0x00000086ff86723eULL, 0x000fe400020006ffULL,
0x0000007dff7d723eULL, 0x000fc400020006ffULL, 0x00000046ff6f723eULL, 0x000fe200020006ffULL,
0x20000086ff6b7230ULL, 0x000fe20000004100ULL, 0x0000105444697816ULL, 0x000fe40000000069ULL,
0x00000010ff477819ULL, 0x000fe20000011647ULL, 0x2000006fff6f7230ULL, 0x000fe20000004100ULL,
0x00000010ff457819ULL, 0x000fe40000011645ULL, 0x00000010ff447819ULL, 0x000fe4000001167fULL,
0x0000a80028467811ULL, 0x000fc400078e20ffULL, 0x00000051ff51723eULL, 0x000fe400020006ffULL,
0x00000010ff7c7819ULL, 0x000fe4000001167cULL, 0x00000008ff867819ULL, 0x000fe2000001166eULL,
0x2000007dff6e7230ULL, 0x000fe20000004100ULL, 0x000000ff71717812ULL, 0x000fe200078ec0ffULL,
0x20000051ff687230ULL, 0x000fe20000004100ULL, 0x000010547c7c7816ULL, 0x000fe40000000047ULL,
0x00001054447d7816ULL, 0x000fc40000000045ULL, 0x000000004644783bULL, 0x000e620000000200ULL,
0x00000071ff71723eULL, 0x000fe400020006ffULL, 0x00000010ff687819ULL, 0x000fe40000011668ULL,
0x00000010ff797819ULL, 0x000fe20000011679ULL, 0x20000071ff717230ULL, 0x000fe20000004100ULL,
0x00000010ff727819ULL, 0x000fe20000011672ULL, 0x0000007c3024723cULL, 0x000fe20000041824ULL,
0x0000105468687816ULL, 0x000fe40000000079ULL, 0x00000010ff717819ULL, 0x000fc40000011671ULL,
0x00000010ff767819ULL, 0x000fe40000011676ULL, 0x0000105471727816ULL, 0x000fe20000000072ULL,
0x00000068303c723cULL, 0x040be2000004183cULL, 0x0000105476737816ULL, 0x000fe40000000073ULL,
0x00000010ff7e7819ULL, 0x000fe4000001167eULL, 0x00000010ff7f7819ULL, 0x000fe40000011680ULL,
0x000000ff5d697812ULL, 0x020fe200078ec0ffULL, 0x000000723048723cULL, 0x000f620000041848ULL,
0x00000008ff687819ULL, 0x000fc4000001165cULL, 0x00000010ff5d7819ULL, 0x000fe40000011666ULL,
0x00000010ff5c7819ULL, 0x000fe40000011667ULL, 0x000010545d7e7816ULL, 0x000fe4000000007eULL,
0x000010545c7f7816ULL, 0x000fe4000000007fULL, 0x00000010ff5d7819ULL, 0x000fe40000011664ULL,
0x00000010ff657819ULL, 0x000fc40000011665ULL, 0x00000010ff5c7819ULL, 0x000fe20000011681ULL,
0x000000094444a231ULL, 0x082fe200003400ffULL, 0x00000010ff647819ULL, 0x000fe20000011683ULL,
0x000000094646a231ULL, 0x000fe200003400ffULL, 0x000010545c5c7816ULL, 0x000fe20000000065ULL,
0x000000084545a231ULL, 0x080fe200003400ffULL, 0x00001054645d7816ULL, 0x000fe2000000005dULL,
0x000000084747a231ULL, 0x000fe200003400ffULL, 0x000000ff4f657812ULL, 0x000fe200078ec0ffULL,
0x0000007e3020723cULL, 0x000f620000041820ULL, 0x00000008ff647819ULL, 0x000fc40000011650ULL,
0x00000010ff4f7819ULL, 0x000fe40000011662ULL, 0x00000010ff507819ULL, 0x000fe40000011663ULL,
0x00000010ff827819ULL, 0x000fe20000011682ULL, 0x0000005c301c723cULL, 0x000b62000004181cULL,
0x00000010ff837819ULL, 0x000fe40000011684ULL, 0x000010544f827816ULL, 0x000fe40000000082ULL,
0x0000105450837816ULL, 0x000fc40000000083ULL, 0x00000010ff617819ULL, 0x000fe40000011661ULL,
0x00000010ff5d7819ULL, 0x020fe40000011660ULL, 0x00000010ff507819ULL, 0x000fe20000011685ULL,
0x00000082302c723cULL, 0x000b62000004182cULL, 0x00000010ff6e7819ULL, 0x000fe4000001166eULL,
0x00000068ff68723eULL, 0x000fe400020006ffULL, 0x00001054505c7816ULL, 0x000fc40000000061ULL,
0x000010546e5d7816ULL, 0x000fe2000000005dULL, 0x20000068ff687230ULL, 0x000fe20000004100ULL,
0x000000ff4e4e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff307819ULL, 0x020fe4000001165fULL,
0x00000010ff6b7819ULL, 0x000fe4000001166bULL, 0x00000069ff69723eULL, 0x000fe400020006ffULL,
0x00000065ff65723eULL, 0x000fc400020006ffULL, 0x0000004eff50723eULL, 0x000fe200020006ffULL,
0x20000069ff697230ULL, 0x000fe20000004100ULL, 0x00001054304e7816ULL, 0x000fe2000000006bULL,
0x20000065ff657230ULL, 0x000fe20000004100ULL, 0x0000005c4430723cULL, 0x000b620000041848ULL,
0x00000008ff437819ULL, 0x000fe20000011643ULL, 0x20000050ff507230ULL, 0x000fe20000004100ULL,
0x00000010ff577819ULL, 0x000fe40000011657ULL, 0x00000087ff51723eULL, 0x000fe400020006ffULL,
0x000000ff42487812ULL, 0x020fc400078ec0ffULL, 0x00000010ff427819ULL, 0x000fe20000011659ULL,
0x20000051ff517230ULL, 0x000fe20000004100ULL, 0x00000010ff597819ULL, 0x000fe40000011668ULL,
0x00000048ff4a723eULL, 0x000fe400020006ffULL, 0x00000043ff49723eULL, 0x000fe400020006ffULL,
0x0000105442597816ULL, 0x000fe20000000059ULL, 0x2000004aff4a7230ULL, 0x000fe20000004100ULL,
0x00000010ff437819ULL, 0x000fe20000011656ULL, 0x20000049ff497230ULL, 0x000fe20000004100ULL,
0x00000010ff427819ULL, 0x000fc40000011669ULL, 0x00000010ff487819ULL, 0x000fe40000011665ULL,
0x000000ff6a6a7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff4c7819ULL, 0x000fe4000001164cULL,
0x00000008ff417819ULL, 0x000fe40000011641ULL, 0x0000105442427816ULL, 0x000fe40000000057ULL,
0x0000105448437816ULL, 0x000fc40000000043ULL, 0x00000086ff86723eULL, 0x000fe400020006ffULL,
0x0000006aff6a723eULL, 0x000fe400020006ffULL, 0x00000070ff70723eULL, 0x000fe200020006ffULL,
0x000000424424723cULL, 0x000b620000041824ULL, 0x00000064ff64723eULL, 0x000fe200020006ffULL,
0x20000086ff867230ULL, 0x000fe20000004100ULL, 0x0000004cff4c723eULL, 0x000fe200020006ffULL,
0x2000006aff6a7230ULL, 0x000fe20000004100ULL, 0x00000041ff48723eULL, 0x000fe200020006ffULL,
0x20000070ff707230ULL, 0x000fe20000004100ULL, 0x00000010ff437819ULL, 0x020fe20000011651ULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x00000010ff4a7819ULL, 0x000fe2000001164aULL,
0x2000004cff4c7230ULL, 0x000fe20000004100ULL, 0x00000010ff497819ULL, 0x000fe20000011649ULL,
0x20000048ff4b7230ULL, 0x000fe20000004100ULL, 0x000010544a437816ULL, 0x000fc40000000043ULL,
0x00000010ff487819ULL, 0x000fe4000001164dULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x00000010ff4f7819ULL, 0x000fe40000011686ULL, 0x00000010ff5b7819ULL, 0x000fe4000001165bULL,
0x00000010ff5a7819ULL, 0x000fe4000001165aULL, 0x00000010ff6a7819ULL, 0x000fc4000001166aULL,
0x00000010ff6b7819ULL, 0x000fe40000011670ULL, 0x00000010ff587819ULL, 0x000fe40000011658ULL,
0x00000010ff6f7819ULL, 0x000fe4000001166fULL, 0x00000010ff557819ULL, 0x000fe40000011655ULL,
0x00000010ff647819ULL, 0x000fe40000011664ULL, 0x00000010ff657819ULL, 0x000fc40000011654ULL,
0x00000010ff4c7819ULL, 0x000fe4000001164cULL, 0x00000010ff527819ULL, 0x000fe40000011652ULL,
0x00000010ff417819ULL, 0x000fe40000011650ULL, 0x00000010ff4a7819ULL, 0x000fe40000011653ULL,
0x00000010ff4b7819ULL, 0x000fe4000001164bULL, 0x0000105448487816ULL, 0x000fc40000000049ULL,
0x000010545e4f7816ULL, 0x000fe4000000004fULL, 0x000010546a6a7816ULL, 0x000fe4000000005bULL,
0x000010546b6b7816ULL, 0x000fe4000000005aULL, 0x0000105458587816ULL, 0x000fe2000000006fULL,
0x0000004e4434723cULL, 0x000b620000041834ULL, 0x0000105455647816ULL, 0x000fe40000000064ULL,
0x0000105465657816ULL, 0x000fc4000000004cULL, 0x0000105441427816ULL, 0x000fe40000000052ULL,
0x000010544a497816ULL, 0x000fe2000000004bULL, 0x0000006a4438723cULL, 0x040b700000041838ULL,
0x00000058443c723cULL, 0x040b70000004183cULL, 0x000000644420723cULL, 0x040b700000041820ULL,
0x00000042441c723cULL, 0x040b70000004181cULL, 0x00000048442c723cULL, 0x000b62000004182cULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff427f8cULL, 0x020e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000006010427810ULL, 0x002fe20007ffe0ffULL, 0x01069000ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff467224ULL, 0x000fc400078e0043ULL, 0x000000154200720cULL, 0x000fda0003f06070ULL,
0x00009de000000947ULL, 0x000fea0003800000ULL, 0x0000000000427805ULL, 0x000fc40000015200ULL,
0x0106bc00ff417984ULL, 0x000e640000000800ULL, 0x8000000041ff7812ULL, 0x002fe40007804846ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff477224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104700780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000447805ULL, 0x000fcc0000015200ULL, 0x0000004442447210ULL, 0x000fca0007f1e1ffULL,
0x0000000145457824ULL, 0x000fe200000e0e43ULL, 0x003d09004400780cULL, 0x000fc80003f06070ULL,
0x000000ff4500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404400780cULL, 0x000fc80003f06070ULL, 0x000000ff4500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff417819ULL, 0x000fc80000011445ULL,
0x0000004441417211ULL, 0x000fca00078110ffULL, 0x000000ffff447224ULL, 0x000fca00000e0645ULL,
0x0000000241417819ULL, 0x000fc80000001244ULL, 0x000000410000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000147477810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106bc00ff417984ULL, 0x000e640000000800ULL,
0x8000000041ff7812ULL, 0x002fe40007804846ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000008010427810ULL, 0x000fca0007ffe0ffULL, 0x0000620013477a24ULL, 0x000fe200078e0242ULL,
0x0000039000009947ULL, 0x000fea0003800000ULL, 0x00000002074f7810ULL, 0x040fe20007ffe0ffULL,
0x0000000114447824ULL, 0x040fe200078e0207ULL, 0x0000000407517810ULL, 0x000fe20007ffe0ffULL,
0x00000100ff4b7424ULL, 0x000fe200078e00ffULL, 0x0000004215417217ULL, 0x000fe20007800000ULL,
0x0000000114467824ULL, 0x000fe200078e024fULL, 0x0000000607537810ULL, 0x000fe20007ffe0ffULL,
0x0000000144437824ULL, 0x000fe200078e0217ULL, 0x000000f00f4d7812ULL, 0x000fe200078ec0ffULL,
0x0000000114487824ULL, 0x000fc400078e0251ULL, 0x00000010444c7824ULL, 0x040fe400078e00ffULL,
0x0000000141417824ULL, 0x000fe400078e0a42ULL, 0x0000000144427824ULL, 0x000fe200078e0247ULL,
0xfffffff04c4c7812ULL, 0x000fe200078ee243ULL, 0x0000000146457824ULL, 0x100fe200078e0217ULL,
0x0000004114417217ULL, 0x000fe20007800000ULL, 0x00000010464e7824ULL, 0x000fe400078e00ffULL,
0x0000000148497824ULL, 0x000fc400078e0217ULL, 0x0000001048507824ULL, 0x000fe200078e00ffULL,
0xfffffff04e4e7812ULL, 0x000fe200078ee245ULL, 0x0000000146447824ULL, 0x000fe400078e0247ULL,
0x00000001144a7824ULL, 0x000fe200078e0253ULL, 0xfffffff050507812ULL, 0x000fe200078ee249ULL,
0x00005e0042427625ULL, 0x000fc800078e004bULL, 0x00005e0044447625ULL, 0x000fc800078e004bULL,
0x0000000148467824ULL, 0x000fe200078e0247ULL, 0x0000004d42487210ULL, 0x080fe20007f1e0ffULL,
0x000000014a497824ULL, 0x000fe200078e0217ULL, 0x0000004d44447210ULL, 0x000fe20007f9e0ffULL,
0x000000104a527824ULL, 0x040fe400078e00ffULL, 0x000000014a477824ULL, 0x000fe400078e0247ULL,
0x00000001414a7824ULL, 0x000fe200078e0a14ULL, 0xfffffff052527812ULL, 0x000fe200078ee249ULL,
0x000000ffff497224ULL, 0x000fe200000e0643ULL, 0x0000e0004c417811ULL, 0x000fe200078e20ffULL,
0x00005e0046427625ULL, 0x000fe200078e004bULL, 0x0000004a0700720cULL, 0x000fc40003f66070ULL,
0x0000004a4f00720cULL, 0x080fe20003f46070ULL, 0x00005e0047467625ULL, 0x000fe200078e004bULL,
0x0000004a5100720cULL, 0x080fe40003f06070ULL, 0x0000004d42427210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff457224ULL, 0x000fe200020e0645ULL, 0x0000004a5300720cULL, 0x000fe40003f86070ULL,
0x0000004d46467210ULL, 0x000fe20007fde0ffULL, 0x000000ffff437224ULL, 0x000fe200028e0643ULL,
0x0000e0004e4b7811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000048417faeULL, 0x0003e2000d901c46ULL, 0x0000e000504d7811ULL, 0x000fe200078e20ffULL,
0x000000ffff477224ULL, 0x000fe200030e0647ULL, 0x0000e000524f7811ULL, 0x000fe200078e20ffULL,
0x00000000444b7faeULL, 0x0003e8000d101c46ULL, 0x00000000424d7faeULL, 0x0003e8000c101c46ULL,
0x00000000464f7faeULL, 0x0003e2000e101c46ULL, 0x000002d000007947ULL, 0x000fea0003800000ULL,
0x0000000114427824ULL, 0x000fe200078e0207ULL, 0x000000f00f4b7812ULL, 0x000fc600078ec0ffULL,
0x0000000142417824ULL, 0x140fe200078e0217ULL, 0x0000000442467810ULL, 0x040fe20007ffe0ffULL,
0x00000010424a7824ULL, 0x040fe200078e00ffULL, 0x0000000242447810ULL, 0x040fe40007ffe0ffULL,
0x00000006424e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000146457824ULL, 0x000fe200078e0217ULL,
0xfffffff04a4a7812ULL, 0x000fe200078ee241ULL, 0x0000001046487824ULL, 0x000fe400078e00ffULL,
0x00000100ff417424ULL, 0x000fc400078e00ffULL, 0x0000000144437824ULL, 0x000fe200078e0217ULL,
0xfffffff0484d7812ULL, 0x000fe200078ee245ULL, 0x0000000142487824ULL, 0x000fe400078e0247ULL,
0x00000010444c7824ULL, 0x000fe200078e00ffULL, 0x0000e0004d4d7811ULL, 0x000fe200078e20ffULL,
0x00005e0048487625ULL, 0x000fc600078e0041ULL, 0xfffffff04c4c7812ULL, 0x000fe200078ee243ULL,
0x0000000144427824ULL, 0x100fe200078e0247ULL, 0x0000004b48487210ULL, 0x000fe20007f5e0ffULL,
0x0000000146447824ULL, 0x100fe400078e0247ULL, 0x000000014e467824ULL, 0x000fe400078e0247ULL,
0x00005e0042427625ULL, 0x000fc800078e0041ULL, 0x00005e0044447625ULL, 0x000fe200078e0041ULL,
0x0000004b42427210ULL, 0x000fc60007f1e0ffULL, 0x000000014e4f7824ULL, 0x000fe400078e0217ULL,
0x00005e0046467625ULL, 0x000fe200078e0041ULL, 0x0000e0004a417811ULL, 0x000fc600078e20ffULL,
0x000000104e4e7824ULL, 0x000fe200078e00ffULL, 0x0000004b46467210ULL, 0x080fe20007f7e0ffULL,
0x000000ffff497224ULL, 0x000fe200010e0649ULL, 0x0000004b44447210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff437224ULL, 0x000fe200000e0643ULL, 0xfffffff04e4f7812ULL, 0x000fe200078ee24fULL,
0x000000ffff477224ULL, 0x000fe200018e0647ULL, 0x0000e0004c4b7811ULL, 0x000fe200078e20ffULL,
0x000000ffff457224ULL, 0x000fe200010e0645ULL, 0x0000e0004f4f7811ULL, 0x000fe200078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000048417faeULL, 0x0003e8000b901c46ULL,
0x00000000424b7faeULL, 0x0003e8000b901c46ULL, 0x00000000444d7faeULL, 0x0003e8000b901c46ULL,
0x00000000464f7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b000ff487f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106480014467f8cULL, 0x0004e4000c80043fULL,
0x0000000000427805ULL, 0x000fc40000015200ULL, 0x01064c0014417984ULL, 0x000f240000000800ULL,
0x8000000041ff7812ULL, 0x018fc40007804847ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000447805ULL, 0x000fcc0000015200ULL,
0x0000004442447210ULL, 0x000fca0007f1e1ffULL, 0x0000000145457824ULL, 0x000fe200000e0e43ULL,
0x003d09004400780cULL, 0x000fc80003f06070ULL, 0x000000ff4500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404400780cULL, 0x000fc80003f06070ULL,
0x000000ff4500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff417819ULL, 0x000fc80000011445ULL, 0x0000004441417211ULL, 0x000fca00078110ffULL,
0x000000ffff447224ULL, 0x000fca00000e0645ULL, 0x0000000241417819ULL, 0x000fc80000001244ULL,
0x000000410000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000014a4a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01064c0014417984ULL, 0x000ee40000000800ULL, 0x8000000041ff7812ULL, 0x008fe40007804847ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x010100000e417984ULL, 0x000ee80000000800ULL,
0x010300000e457984ULL, 0x0004620000000800ULL, 0x000000404100720bULL, 0x008fe20003f1d000ULL,
0x0000f6827f007947ULL, 0x000fd8000b800000ULL, 0x0000000000447806ULL, 0x004fc800000e0100ULL,
0x0000ffff44ff7812ULL, 0x000fe2000780c0ffULL, 0x0000048000007945ULL, 0x000fe20003800000ULL,
0x00000001ff467424ULL, 0x000fc400078e00ffULL, 0x000000ffff4a7224ULL, 0x000fd200078e0040ULL,
0x0000044000008947ULL, 0x000fea0003800000ULL, 0x000000021800780cULL, 0x000fe40003f05270ULL,
0x000000404100720bULL, 0x000fe20003f54000ULL, 0x0000f6427f007947ULL, 0x000fd8000b800000ULL,
0x0000000000477806ULL, 0x000fc400010e0100ULL, 0x0000004140438209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x0000991047427816ULL, 0x000fc600000000ffULL,
0x010500430e008388ULL, 0x0005e20000000800ULL, 0x000000ff4200720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000004140437209ULL, 0x004fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff47ff7812ULL, 0x000fc6000780c0ffULL,
0x8000004340427221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b42427820ULL, 0x000fc80000410000ULL,
0x00000042004b7308ULL, 0x000ea40000000800ULL, 0x0000004b12127220ULL, 0x004fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff557819ULL, 0x000fe20000011617ULL,
0x0000f5727f007947ULL, 0x000fea000b800000ULL, 0x00001f554b427589ULL, 0x0004e400000e0000ULL,
0x0000004230307220ULL, 0x088fe20000410000ULL, 0x0000004231317220ULL, 0x080fe20000410000ULL,
0x0000004234347220ULL, 0x080fe20000410000ULL, 0x0000004235357220ULL, 0x080fe20000410000ULL,
0x0000004238387220ULL, 0x080fe20000410000ULL, 0x0000004239397220ULL, 0x080fe20000410000ULL,
0x000000423c3c7220ULL, 0x080fe20000410000ULL, 0x000000423d3d7220ULL, 0x080fe20000410000ULL,
0x0000004224247220ULL, 0x080fe20000410000ULL, 0x0000004225257220ULL, 0x080fe20000410000ULL,
0x0000004220207220ULL, 0x080fe20000410000ULL, 0x0000004221217220ULL, 0x080fe20000410000ULL,
0x000000421c1c7220ULL, 0x080fe20000410000ULL, 0x000000421d1d7220ULL, 0x080fe20000410000ULL,
0x000000422c2c7220ULL, 0x080fe20000410000ULL, 0x000000422d2d7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0047ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000817557811ULL, 0x006fe200078ff0ffULL,
0x0000f4627f007947ULL, 0x000fea000b800000ULL, 0x00001f554b427589ULL, 0x0002a400000e0000ULL,
0x0000004232327220ULL, 0x084fe20000410000ULL, 0x0000004233337220ULL, 0x080fe20000410000ULL,
0x0000004236367220ULL, 0x080fe20000410000ULL, 0x0000004237377220ULL, 0x080fe20000410000ULL,
0x000000423a3a7220ULL, 0x080fe20000410000ULL, 0x000000423b3b7220ULL, 0x080fe20000410000ULL,
0x000000423e3e7220ULL, 0x080fe20000410000ULL, 0x000000423f3f7220ULL, 0x080fe20000410000ULL,
0x0000004226267220ULL, 0x080fe20000410000ULL, 0x0000004227277220ULL, 0x080fe20000410000ULL,
0x0000004222227220ULL, 0x080fe20000410000ULL, 0x0000004223237220ULL, 0x080fe20000410000ULL,
0x000000421e1e7220ULL, 0x080fe20000410000ULL, 0x000000421f1f7220ULL, 0x080fe20000410000ULL,
0x000000422e2e7220ULL, 0x080fe20000410000ULL, 0x000000422f2f7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff47ff7812ULL, 0x000fe20007800844ULL,
0x00000001ff467424ULL, 0x000fe200078e00ffULL, 0x00000041404a7209ULL, 0x000fd60007810000ULL,
0x8000004a41410221ULL, 0x000fe20000010000ULL, 0x00007610ff460816ULL, 0x000fc60000000046ULL,
0x3fb8aa3b41410820ULL, 0x000fc80000410000ULL, 0x00000041000a0308ULL, 0x000ea40000000800ULL,
0x0000000a45450220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001245127221ULL, 0x002fc20000010000ULL, 0x0000000000407805ULL, 0x000fcc0000015200ULL,
0x0106ac00ff427984ULL, 0x000e640000000800ULL, 0x8000000042ff7812ULL, 0x002fe4000780482bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff447224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000427805ULL, 0x000fcc0000015200ULL, 0x0000004240457210ULL, 0x000fca0007f1e1ffULL,
0x0000000143437824ULL, 0x000fe200000e0e41ULL, 0x003d09004500780cULL, 0x000fc80003f06070ULL,
0x000000ff4300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404500780cULL, 0x000fc80003f06070ULL, 0x000000ff4300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff427819ULL, 0x000fc80000011443ULL,
0x0000004542427211ULL, 0x000fca00078110ffULL, 0x000000ffff437224ULL, 0x000fca00000e0643ULL,
0x0000000242427819ULL, 0x000fc80000001243ULL, 0x000000420000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000144447810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106ac00ff427984ULL, 0x000e640000000800ULL,
0x8000000042ff7812ULL, 0x002fe4000780482bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009910462b7816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff2b00720cULL, 0x000fda0003f45270ULL, 0x0000012000002947ULL, 0x000fea0003800000ULL,
0x0000000aff08723eULL, 0x000fe400000010ffULL, 0x00000002ff407819ULL, 0x000fe40000011617ULL,
0x00005410082b7816ULL, 0x000fe20000000008ULL, 0x0000f0427f007947ULL, 0x000fea000b800000ULL,
0x00001f402b097589ULL, 0x0002a400000e0000ULL, 0x0000000840557810ULL, 0x002fe20007ffe0ffULL,
0x0000f0727f007947ULL, 0x000fea000b800000ULL, 0x00001f552b087589ULL, 0x0002e400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001040557810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff527224ULL, 0x000fe200078e002bULL, 0x0000c53000427802ULL, 0x000fc40000000f00ULL,
0x0000f85000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001840557810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff527224ULL, 0x004fe200078e002bULL,
0x0000c58000427802ULL, 0x000fc40000000f00ULL, 0x0000f80000007944ULL, 0x008fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000000650783bULL, 0x004ea80000004200ULL, 0x00000000054c783bULL, 0x000f280000004200ULL,
0x000000000240783bULL, 0x000e680000004200ULL, 0x000000000444783bULL, 0x000ee20000004200ULL,
0x00000010ff737819ULL, 0x004fc40000011651ULL, 0x000000ff51577812ULL, 0x040fe400078ec0ffULL,
0x00000018ff567819ULL, 0x000fe40000011651ULL, 0x0000ffff518a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff547819ULL, 0x100fe40000011650ULL, 0x000000ff502b7812ULL, 0x002fe400078ec0ffULL,
0x00000018ff557819ULL, 0x000fc40000011650ULL, 0x0000ffff50897812ULL, 0x000fe400078ec0ffULL,
0x00000010ff7d7819ULL, 0x110fe4000001164dULL, 0x000000ff4d5f7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff5c7819ULL, 0x000fe4000001164dULL, 0x0000ffff4d8e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff807819ULL, 0x000fc4000001164eULL, 0x000000ff4e617812ULL, 0x040fe400078ec0ffULL,
0x00000018ff607819ULL, 0x000fe4000001164eULL, 0x0000ffff4e8f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5e7819ULL, 0x100fe40000011640ULL, 0x000000ff40857812ULL, 0x000fe400078ec0ffULL,
0x00000018ff837819ULL, 0x000fc40000011640ULL, 0x0000ffff40517812ULL, 0x000fe400078ec0ffULL,
0x00000018ff4e7819ULL, 0x000fe4000001164fULL, 0x00000010ff507819ULL, 0x100fe40000011641ULL,
0x000000ff41867812ULL, 0x040fe400078ec0ffULL, 0x00000018ff407819ULL, 0x000fe40000011641ULL,
0x0000ffff414d7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff417819ULL, 0x000fe40000011642ULL,
0x00000010ff777819ULL, 0x100fe40000011652ULL, 0x000000ff52597812ULL, 0x040fe400078ec0ffULL,
0x00000018ff587819ULL, 0x000fe40000011652ULL, 0x0000ffff528b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff787819ULL, 0x000fc40000011653ULL, 0x000000ff535a7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff527819ULL, 0x000fe40000011653ULL, 0x0000ffff538c7812ULL, 0x000fe400078ec0ffULL,
0x0000005fff5f723eULL, 0x000fe400020006ffULL, 0x0000004eff4e723eULL, 0x000fe400020006ffULL,
0x00000010ff7c7819ULL, 0x100fe2000001164cULL, 0x2000005fff6b7230ULL, 0x000fe20000004100ULL,
0x000000ff4c5b7812ULL, 0x000fe200078ec0ffULL, 0x2000004eff647230ULL, 0x000fe20000004100ULL,
0x00000018ff537819ULL, 0x000fc4000001164cULL, 0x0000ffff4c8d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff817819ULL, 0x000fe4000001164fULL, 0x000000ff4f627812ULL, 0x040fe400078ec0ffULL,
0x0000ffff4f907812ULL, 0x000fe400078ec0ffULL, 0x00000040ff40723eULL, 0x000fe400020006ffULL,
0x00000041ff41723eULL, 0x000fc400020006ffULL, 0x00000018ff747819ULL, 0x008fe40000011644ULL,
0x00000010ff4f7819ULL, 0x000fe20000011642ULL, 0x20000041ff4e7230ULL, 0x000fe20000004100ULL,
0x000000ff42877812ULL, 0x040fe400078ec0ffULL, 0x0000ffff424c7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff427819ULL, 0x000fe40000011643ULL, 0x000000ff54547812ULL, 0x000fc400078ec0ffULL,
0x00000010ff6a7819ULL, 0x100fe40000011647ULL, 0x000000ff47827812ULL, 0x040fe400078ec0ffULL,
0x00000018ff7f7819ULL, 0x000fe40000011647ULL, 0x0000ffff475d7812ULL, 0x000fe400078ec0ffULL,
0x000000ff73737812ULL, 0x000fe400078ec0ffULL, 0x00000056ff47723eULL, 0x000fe200020006ffULL,
0x20000040ff567230ULL, 0x000fe20000004100ULL, 0x0000002bff72723eULL, 0x000fc400020006ffULL,
0x00000062ff62723eULL, 0x000fe200020006ffULL, 0x20000047ff477230ULL, 0x000fe20000004100ULL,
0x00000074ff5f723eULL, 0x000fe200020006ffULL, 0x20000072ff727230ULL, 0x000fe20000004100ULL,
0x00000010ff4b7819ULL, 0x000fe20000011643ULL, 0x20000062ff657230ULL, 0x000fe20000004100ULL,
0x000000ff43887812ULL, 0x040fe200078ec0ffULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x0000ffff432b7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff417819ULL, 0x000fc40000011689ULL,
0x00000042ff74723eULL, 0x000fe400020006ffULL, 0x00000054ff40723eULL, 0x000fe400020006ffULL,
0x000000ff44767812ULL, 0x000fe200078ec0ffULL, 0x20000074ff547230ULL, 0x000fe20000004100ULL,
0x00000073ff42723eULL, 0x000fe200020006ffULL, 0x20000040ff737230ULL, 0x000fe20000004100ULL,
0x00000008ff437819ULL, 0x000fe4000001168aULL, 0x00000041ff41723eULL, 0x000fc400020006ffULL,
0x00000076ff62723eULL, 0x000fe200020006ffULL, 0x20000042ff767230ULL, 0x000fe20000004100ULL,
0x00000043ff43723eULL, 0x000fe200020006ffULL, 0x20000041ff747230ULL, 0x000fe20000004100ULL,
0x000000ff77407812ULL, 0x000fe200078ec0ffULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x000000ff78787812ULL, 0x000fe200078ec0ffULL, 0x20000043ff777230ULL, 0x000fe20000004100ULL,
0x00000008ff427819ULL, 0x000fe4000001168bULL, 0x00000061ff61723eULL, 0x000fc400020006ffULL,
0x00000060ff60723eULL, 0x000fe400020006ffULL, 0x00000040ff41723eULL, 0x000fe200020006ffULL,
0x20000061ff667230ULL, 0x000fe20000004100ULL, 0x000000ff457a7812ULL, 0x000fe200078ec0ffULL,
0x20000060ff637230ULL, 0x000fe20000004100ULL, 0x00000018ff797819ULL, 0x000fe40000011645ULL,
0x00000078ff43723eULL, 0x000fe200020006ffULL, 0x20000041ff787230ULL, 0x000fe20000004100ULL,
0x00000042ff42723eULL, 0x000fc400020006ffULL, 0x0000b00000407811ULL, 0x000fe400078e20ffULL,
0x0000007aff61723eULL, 0x000fe200020006ffULL, 0x20000043ff7a7230ULL, 0x000fe20000004100ULL,
0x00000079ff60723eULL, 0x000fe200020006ffULL, 0x20000042ff797230ULL, 0x000fe20000004100ULL,
0x00000057ff57723eULL, 0x000fe200020006ffULL, 0x000000004040783bULL, 0x000e620000000200ULL,
0x0000ffff44917812ULL, 0x000fe200078ec0ffULL, 0x20000060ff607230ULL, 0x000fe20000004100ULL,
0x00000010ff847819ULL, 0x000fe20000011644ULL, 0x20000057ff757230ULL, 0x000fe20000004100ULL,
0x00000085ff57723eULL, 0x000fe200020006ffULL, 0x20000061ff617230ULL, 0x000fe20000004100ULL,
0x00000010ff447819ULL, 0x000fc40000011646ULL, 0x000000ff467e7812ULL, 0x040fe200078ec0ffULL,
0x20000057ff577230ULL, 0x000fe20000004100ULL, 0x00000018ff7b7819ULL, 0x000fe40000011646ULL,
0x0000ffff46677812ULL, 0x000fe400078ec0ffULL, 0x00000008ff857819ULL, 0x000fe40000011691ULL,
0x00000010ff6f7819ULL, 0x000fe40000011645ULL, 0x00000055ff46723eULL, 0x000fc400020006ffULL,
0x0000005aff5a723eULL, 0x000fe400020006ffULL, 0x00000058ff58723eULL, 0x000fe200020006ffULL,
0x20000046ff467230ULL, 0x000fe20000004100ULL, 0x0000ffff45457812ULL, 0x000fe200078ec0ffULL,
0x2000005aff717230ULL, 0x000fe20000004100ULL, 0x00000085ff85723eULL, 0x000fe200020006ffULL,
0x20000058ff6d7230ULL, 0x000fe20000004100ULL, 0x00000010ff727819ULL, 0x000fe40000011672ULL,
0x00000010ff737819ULL, 0x000fc40000011673ULL, 0x00000010ff757819ULL, 0x000fe40000011675ULL,
0x00000010ff767819ULL, 0x000fe40000011676ULL, 0x00000008ff457819ULL, 0x000fe40000011645ULL,
0x00000059ff59723eULL, 0x000fe200020006ffULL, 0x000000094040a231ULL, 0x082fe200003400ffULL,
0x0000007bff5a723eULL, 0x000fe200020006ffULL, 0x000000094242a231ULL, 0x000fe200003400ffULL,
0x00000086ff58723eULL, 0x000fe200020006ffULL, 0x000000084141a231ULL, 0x080fe200003400ffULL,
0x00000008ff7b7819ULL, 0x000fe2000001168cULL, 0x000000084343a231ULL, 0x000fe200003400ffULL,
0x000000ff6f867812ULL, 0x000fe200078ec0ffULL, 0x20000085ff6f7230ULL, 0x000fe20000004100ULL,
0x0000105473727816ULL, 0x000fe20000000072ULL, 0x20000059ff707230ULL, 0x000fe20000004100ULL,
0x0000105476737816ULL, 0x000fe20000000075ULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x00000045ff85723eULL, 0x000fe200020006ffULL, 0x20000058ff587230ULL, 0x000fe20000004100ULL,
0x000000ff44767812ULL, 0x000fc400078ec0ffULL, 0x00000010ff457819ULL, 0x000fe20000011646ULL,
0x20000085ff857230ULL, 0x000fe20000004100ULL, 0x00000010ff447819ULL, 0x000fe40000011647ULL,
0x00000010ff747819ULL, 0x000fe40000011674ULL, 0x00000010ff757819ULL, 0x000fe40000011677ULL,
0x00000052ff52723eULL, 0x000fe400020006ffULL, 0x0000007bff7b723eULL, 0x000fc400020006ffULL,
0x000000ff7c7c7812ULL, 0x000fe200078ec0ffULL, 0x20000052ff6e7230ULL, 0x000fe20000004100ULL,
0x0000105445747816ULL, 0x000fe20000000074ULL, 0x2000007bff7b7230ULL, 0x000fe20000004100ULL,
0x0000105444757816ULL, 0x000fe40000000075ULL, 0x000000724044723cULL, 0x000be20000041830ULL,
0x00000010ff707819ULL, 0x000fe40000011670ULL, 0x0000007cff7c723eULL, 0x000fe400020006ffULL,
0x0000005bff5b723eULL, 0x000fc400020006ffULL, 0x00000010ff317819ULL, 0x020fe20000011678ULL,
0x2000007cff7c7230ULL, 0x000fe20000004100ULL, 0x00000010ff307819ULL, 0x000fe2000001166dULL,
0x2000005bff6c7230ULL, 0x000fe20000004100ULL, 0x0000105431707816ULL, 0x000fe20000000070ULL,
0x000000744034723cULL, 0x000f620000041834ULL, 0x00000010ff6e7819ULL, 0x000fe4000001166eULL,
0x00000010ff797819ULL, 0x000fe40000011679ULL, 0x00000010ff317819ULL, 0x000fc4000001167bULL,
0x0000105430307816ULL, 0x000fe40000000079ULL, 0x000010546e317816ULL, 0x000fe40000000031ULL,
0x0000007eff5b723eULL, 0x000fe400020006ffULL, 0x00000010ff337819ULL, 0x000fe4000001167cULL,
0x0000b00003327811ULL, 0x000fe200078e20ffULL, 0x00000030403c723cULL, 0x000be2000004183cULL,
0x000000ff7d7e7812ULL, 0x000fe200078ec0ffULL, 0x2000005bff5b7230ULL, 0x000fe20000004100ULL,
0x00000010ff6c7819ULL, 0x000fc4000001166cULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x0000007eff7e723eULL, 0x000fe400020006ffULL, 0x00001054336c7816ULL, 0x000fe2000000006cULL,
0x2000005cff697230ULL, 0x000fe20000004100ULL, 0x000000003230783bULL, 0x020e620000000200ULL,
0x0000007fff59723eULL, 0x000fe200020006ffULL, 0x2000007eff7e7230ULL, 0x000fe20000004100ULL,
0x00000008ff7f7819ULL, 0x000fe4000001168eULL, 0x00000082ff5c723eULL, 0x000fe200020006ffULL,
0x20000059ff597230ULL, 0x000fe20000004100ULL, 0x000000ff80807812ULL, 0x000fc400078ec0ffULL,
0x000000ff81827812ULL, 0x000fe200078ec0ffULL, 0x2000005cff5c7230ULL, 0x000fe20000004100ULL,
0x000000ff6a6a7812ULL, 0x000fe400078ec0ffULL, 0x0000007fff7f723eULL, 0x000fe400020006ffULL,
0x00000008ff677819ULL, 0x000fe40000011667ULL, 0x00000080ff80723eULL, 0x000fe200020006ffULL,
0x2000007fff7f7230ULL, 0x000fe20000004100ULL, 0x00000082ff82723eULL, 0x000fc400020006ffULL,
0x00000083ff55723eULL, 0x000fe200020006ffULL, 0x20000080ff807230ULL, 0x000fe20000004100ULL,
0x0000006aff6a723eULL, 0x000fe200020006ffULL, 0x20000082ff827230ULL, 0x000fe20000004100ULL,
0x00000010ff6b7819ULL, 0x000fe2000001166bULL, 0x20000055ff557230ULL, 0x000fe20000004100ULL,
0x00000010ff7e7819ULL, 0x000fe2000001167eULL, 0x2000006aff727230ULL, 0x000fe20000004100ULL,
0x00000008ff7d7819ULL, 0x000fe4000001168dULL, 0x00000008ff817819ULL, 0x000fc4000001168fULL,
0x00000008ff837819ULL, 0x000fe40000011690ULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x00000008ff5d7819ULL, 0x000fe4000001165dULL, 0x000010547e6d7816ULL, 0x000fe2000000006bULL,
0x20000067ff6a7230ULL, 0x000fe20000004100ULL, 0x00000053ff53723eULL, 0x000fe200020006ffULL,
0x000000093030a231ULL, 0x082fe200003400ffULL, 0x0000007dff7d723eULL, 0x000fe200020006ffULL,
0x000000093232a231ULL, 0x000fe200003400ffULL, 0x00000081ff81723eULL, 0x000fe200020006ffULL,
0x20000053ff687230ULL, 0x000fe20000004100ULL, 0x00000083ff83723eULL, 0x000fe200020006ffULL,
0x2000007dff7d7230ULL, 0x000fe20000004100ULL, 0x000000ff5e6b7812ULL, 0x000fe200078ec0ffULL,
0x20000081ff817230ULL, 0x000fe20000004100ULL, 0x00000010ff5e7819ULL, 0x000fe20000011669ULL,
0x20000083ff837230ULL, 0x000fe20000004100ULL, 0x00000010ff697819ULL, 0x000fe2000001167fULL,
0x0000006c4024723cULL, 0x000fe20000041824ULL, 0x0000005dff67723eULL, 0x000fe200020006ffULL,
0x000000083131a231ULL, 0x080fe200003400ffULL, 0x00000010ff667819ULL, 0x000fe20000011666ULL,
0x000000083333a231ULL, 0x000fe200003400ffULL, 0x00000010ff657819ULL, 0x000fc40000011665ULL,
0x00000010ff5d7819ULL, 0x000fe40000011680ULL, 0x00000010ff827819ULL, 0x000fe40000011682ULL,
0x000010545e697816ULL, 0x000fe20000000069ULL, 0x20000067ff5e7230ULL, 0x000fe20000004100ULL,
0x000010545d667816ULL, 0x000fe40000000066ULL, 0x0000105482677816ULL, 0x000fe40000000065ULL,
0x000000ff50657812ULL, 0x000fc400078ec0ffULL, 0x00000008ff5d7819ULL, 0x000fe40000011651ULL,
0x00000010ff717819ULL, 0x000fe20000011671ULL, 0x00000066401c723cULL, 0x000fe2000004181cULL,
0x00000010ff7a7819ULL, 0x000fe4000001167aULL, 0x00000010ff687819ULL, 0x000fe40000011668ULL,
0x00000010ff7d7819ULL, 0x000fe4000001167dULL, 0x00000010ff507819ULL, 0x000fc40000011663ULL,
0x00000010ff647819ULL, 0x000fe40000011664ULL, 0x00000010ff817819ULL, 0x000fe40000011681ULL,
0x00000010ff517819ULL, 0x000fe40000011683ULL, 0x000010547a717816ULL, 0x000fe40000000071ULL,
0x0000105468687816ULL, 0x000fe4000000007dULL, 0x0000105450507816ULL, 0x000fc40000000081ULL,
0x0000105464517816ULL, 0x000fe20000000051ULL, 0x000000704038723cULL, 0x040f620000041838ULL,
0x00000010ff607819ULL, 0x000fe40000011660ULL, 0x00000010ff6f7819ULL, 0x000fe4000001166fULL,
0x00000008ff4d7819ULL, 0x000fe4000001164dULL, 0x000000ff84847812ULL, 0x000fe200078ec0ffULL,
0x000000684020723cULL, 0x000f620000041820ULL, 0x000000ff4f4f7812ULL, 0x000fc400078ec0ffULL,
0x000000ff4b4b7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff4c7819ULL, 0x000fe4000001164cULL,
0x00000008ff2b7819ULL, 0x000fe2000001162bULL, 0x00000050402c723cULL, 0x000b62000004182cULL,
0x00000065ff65723eULL, 0x000fe400020006ffULL, 0x0000004dff4d723eULL, 0x000fe400020006ffULL,
0x00000087ff53723eULL, 0x000fe200020006ffULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x00000010ff407819ULL, 0x020fe2000001165fULL, 0x2000004dff4d7230ULL, 0x000fe20000004100ULL,
0x00000010ff417819ULL, 0x000fe20000011685ULL, 0x20000053ff537230ULL, 0x000fe20000004100ULL,
0x0000105440407816ULL, 0x000fc4000000006fULL, 0x0000105460417816ULL, 0x000fe40000000041ULL,
0x00000088ff52723eULL, 0x000fe400020006ffULL, 0x00000084ff84723eULL, 0x000fe400020006ffULL,
0x00000086ff86723eULL, 0x000fe200020006ffULL, 0x000000403034723cULL, 0x000b620000041834ULL,
0x00000076ff76723eULL, 0x000fe200020006ffULL, 0x20000052ff527230ULL, 0x000fe20000004100ULL,
0x0000006bff6b723eULL, 0x000fe200020006ffULL, 0x20000084ff847230ULL, 0x000fe20000004100ULL,
0x0000005dff63723eULL, 0x000fe200020006ffULL, 0x20000086ff867230ULL, 0x000fe20000004100ULL,
0x0000004fff4f723eULL, 0x000fe200020006ffULL, 0x20000076ff767230ULL, 0x000fe20000004100ULL,
0x0000004bff4b723eULL, 0x000fe200020006ffULL, 0x2000006bff6c7230ULL, 0x000fe20000004100ULL,
0x0000004cff4c723eULL, 0x000fe200020006ffULL, 0x20000063ff647230ULL, 0x000fe20000004100ULL,
0x0000002bff2b723eULL, 0x000fe200020006ffULL, 0x2000004fff4f7230ULL, 0x000fe20000004100ULL,
0x00000010ff417819ULL, 0x020fe2000001165aULL, 0x2000004bff4b7230ULL, 0x000fe20000004100ULL,
0x00000010ff6a7819ULL, 0x000fe2000001166aULL, 0x2000004cff4c7230ULL, 0x000fe20000004100ULL,
0x00000010ff587819ULL, 0x000fe20000011658ULL, 0x2000002bff437230ULL, 0x000fe20000004100ULL,
0x00000010ff657819ULL, 0x000fc40000011665ULL, 0x00001054416a7816ULL, 0x000fe4000000006aULL,
0x00000010ff567819ULL, 0x000fe40000011656ULL, 0x00000010ff4d7819ULL, 0x000fe4000001164dULL,
0x00000010ff627819ULL, 0x000fe40000011662ULL, 0x00000010ff617819ULL, 0x000fe40000011661ULL,
0x00000010ff5d7819ULL, 0x000fc40000011684ULL, 0x00000010ff867819ULL, 0x000fe40000011686ULL,
0x00000010ff5b7819ULL, 0x000fe4000001165bULL, 0x00000010ff5c7819ULL, 0x000fe4000001165cULL,
0x00000010ff767819ULL, 0x000fe40000011676ULL, 0x00000010ff777819ULL, 0x000fe40000011672ULL,
0x00000010ff597819ULL, 0x000fc40000011659ULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x00000010ff577819ULL, 0x000fe40000011657ULL, 0x00000010ff6c7819ULL, 0x000fe4000001166cULL,
0x00000010ff557819ULL, 0x000fe40000011655ULL, 0x00000010ff647819ULL, 0x000fe40000011664ULL,
0x00000010ff537819ULL, 0x000fc40000011653ULL, 0x00000010ff407819ULL, 0x000fe4000001164fULL,
0x00000010ff417819ULL, 0x000fe40000011652ULL, 0x00000010ff427819ULL, 0x000fe4000001164bULL,
0x00000010ff2b7819ULL, 0x000fe4000001164eULL, 0x00000010ff4c7819ULL, 0x000fe4000001164cULL,
0x00000010ff547819ULL, 0x000fc40000011654ULL, 0x00000010ff437819ULL, 0x000fe40000011643ULL,
0x00001054656d7816ULL, 0x000fe40000000058ULL, 0x0000105456657816ULL, 0x000fe4000000004dULL,
0x000010545d627816ULL, 0x000fe40000000062ULL, 0x0000105486637816ULL, 0x000fe40000000061ULL,
0x0000105476767816ULL, 0x000fc4000000005bULL, 0x0000105477777816ULL, 0x000fe4000000005cULL,
0x00001054596b7816ULL, 0x000fe2000000005eULL, 0x000000623044723cULL, 0x040b620000041844ULL,
0x000010546c6c7816ULL, 0x000fe40000000057ULL, 0x0000105455647816ULL, 0x000fe40000000064ULL,
0x0000105440407816ULL, 0x000fe40000000053ULL, 0x0000105442417816ULL, 0x000fe20000000041ULL,
0x000000763038723cULL, 0x000b620000041838ULL, 0x000010542b4c7816ULL, 0x000fc4000000004cULL,
0x00001054544d7816ULL, 0x000fca0000000043ULL, 0x0000006a303c723cULL, 0x040b70000004183cULL,
0x0000006c3024723cULL, 0x040b700000041824ULL, 0x000000643020723cULL, 0x040b700000041820ULL,
0x00000040301c723cULL, 0x040b70000004181cULL, 0x0000004c302c723cULL, 0x000b62000004182cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff407f8cULL, 0x020e62000c80043fULL,
0x000000ffff427224ULL, 0x000fce00078e00ffULL, 0x0000000000307805ULL, 0x000fc40000015200ULL,
0x0106bc00ff2b7984ULL, 0x000ea40000000800ULL, 0x800000002bff7812ULL, 0x006fc40007804841ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fcc0000015200ULL,
0x0000003230327210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003200780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403200780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff2b7819ULL, 0x000fc80000011433ULL, 0x000000322b2b7211ULL, 0x000fca00078110ffULL,
0x000000ffff327224ULL, 0x000fca00000e0633ULL, 0x000000022b2b7819ULL, 0x000fc80000001232ULL,
0x0000002b0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000142427810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106bc00ff2b7984ULL, 0x000e640000000800ULL, 0x800000002bff7812ULL, 0x002fe40007804841ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000a010307810ULL, 0x000fca0007ffe0ffULL,
0x0000620013407a24ULL, 0x000fe200078e0230ULL, 0x0000039000009947ULL, 0x000fea0003800000ULL,
0x00000030152b7217ULL, 0x000fe20007800000ULL, 0x0000000114317824ULL, 0x040fe200078e0207ULL,
0x0000000407517810ULL, 0x040fe20007ffe0ffULL, 0x00000100ff417424ULL, 0x000fe200078e00ffULL,
0x00000002074f7810ULL, 0x000fe20007ffe0ffULL, 0x000000012b2b7824ULL, 0x000fe200078e0a30ULL,
0x000000f00f4b7812ULL, 0x000fe200078ec0ffULL, 0x0000000114437824ULL, 0x040fe400078e0251ULL,
0x0000000131307824ULL, 0x040fe200078e0240ULL, 0x0000002b142b7217ULL, 0x000fe20007800000ULL,
0x0000000131327824ULL, 0x000fc400078e0217ULL, 0x00000010314d7824ULL, 0x000fe400078e00ffULL,
0x0000000143427824ULL, 0x040fe400078e0217ULL, 0x0000001043537824ULL, 0x000fe200078e00ffULL,
0xfffffff04d4d7812ULL, 0x000fe200078ee232ULL, 0x00005e0030307625ULL, 0x000fc600078e0041ULL,
0xfffffff053507812ULL, 0x000fe200078ee242ULL, 0x0000000114327824ULL, 0x000fe200078e024fULL,
0x0000004b30427210ULL, 0x000fe20007f1e0ffULL, 0x000000012b4c7824ULL, 0x000fe200078e0a14ULL,
0x0000000607537810ULL, 0x000fe20007ffe0ffULL, 0x0000000132307824ULL, 0x140fe200078e0240ULL,
0x0000c0004d4d7811ULL, 0x000fe200078e20ffULL, 0x0000000132337824ULL, 0x040fe200078e0217ULL,
0x0000004c0700720cULL, 0x080fe20003f86070ULL, 0x00000010324e7824ULL, 0x000fe200078e00ffULL,
0x0000004c4f00720cULL, 0x000fe20003f66070ULL, 0x0000000143327824ULL, 0x000fc400078e0240ULL,
0x000000ffff437224ULL, 0x000fe200000e0631ULL, 0xfffffff04e4e7812ULL, 0x000fe200078ee233ULL,
0x00005e0030307625ULL, 0x000fe200078e0041ULL, 0x0000004c5100720cULL, 0x000fc60003f06070ULL,
0x00000001142b7824ULL, 0x000fe200078e0253ULL, 0x0000004b30307210ULL, 0x000fe20007fbe0ffULL,
0x00005e0032327625ULL, 0x000fe200078e0041ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000424d7faeULL, 0x0003e6000e101c46ULL, 0x000000012b407824ULL, 0x000fe200078e0240ULL,
0x0000004b32327210ULL, 0x000fe20007fde0ffULL, 0x000000ffff317224ULL, 0x000fe200028e0631ULL,
0x0000004c5300720cULL, 0x000fe20003fa6070ULL, 0x00005e0040407625ULL, 0x000fc800078e0041ULL,
0x000000012b4f7824ULL, 0x040fe400078e0217ULL, 0x000000102b527824ULL, 0x000fe200078e00ffULL,
0x0000c0004e2b7811ULL, 0x000fe200078e20ffULL, 0x000000ffff337224ULL, 0x000fe200030e0633ULL,
0x0000004b40407210ULL, 0x000fe40007fde0ffULL, 0xfffffff0524f7812ULL, 0x000fe200078ee24fULL,
0x00000000302b7faeULL, 0x0003e2000d901c46ULL, 0x0000c000504b7811ULL, 0x000fe200078e20ffULL,
0x000000ffff417224ULL, 0x000fe200030e0641ULL, 0x0000c0004f4f7811ULL, 0x000fc600078e20ffULL,
0x00000000324b7faeULL, 0x0003e8000c101c46ULL, 0x00000000404f7faeULL, 0x0003e2000e901c46ULL,
0x000002d000007947ULL, 0x000fea0003800000ULL, 0x00000001142b7824ULL, 0x000fe200078e0207ULL,
0x000000f00f4b7812ULL, 0x000fc600078ec0ffULL, 0x000000012b307824ULL, 0x140fe200078e0217ULL,
0x000000042b337810ULL, 0x040fe20007ffe0ffULL, 0x000000102b437824ULL, 0x040fe200078e00ffULL,
0x000000022b317810ULL, 0x040fe20007ffe0ffULL, 0x000000012b427824ULL, 0x040fe200078e0240ULL,
0x000000062b2b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000133417824ULL, 0x100fe200078e0217ULL,
0xfffffff0434c7812ULL, 0x000fe200078ee230ULL, 0x00000010334e7824ULL, 0x000fe400078e00ffULL,
0x0000000131327824ULL, 0x000fc400078e0217ULL, 0x00000010314d7824ULL, 0x040fe200078e00ffULL,
0xfffffff04e4e7812ULL, 0x000fe200078ee241ULL, 0x00000100ff417424ULL, 0x000fe400078e00ffULL,
0x0000000131307824ULL, 0x000fe200078e0240ULL, 0xfffffff04d4d7812ULL, 0x000fe200078ee232ULL,
0x00005e0042427625ULL, 0x000fc600078e0041ULL, 0x0000c0004d4d7811ULL, 0x000fe200078e20ffULL,
0x0000000133327824ULL, 0x100fe200078e0240ULL, 0x0000004b42427210ULL, 0x000fe20007f7e0ffULL,
0x000000012b407824ULL, 0x000fe400078e0240ULL, 0x00005e0030307625ULL, 0x000fc800078e0041ULL,
0x00005e0032327625ULL, 0x000fe200078e0041ULL, 0x0000004b30307210ULL, 0x000fc60007f1e0ffULL,
0x00005e0040407625ULL, 0x000fc800078e0041ULL, 0x000000012b4f7824ULL, 0x040fe200078e0217ULL,
0x0000004b40407210ULL, 0x080fe20007f9e0ffULL, 0x000000102b507824ULL, 0x000fe200078e00ffULL,
0x0000c0004c2b7811ULL, 0x000fe200078e20ffULL, 0x000000ffff437224ULL, 0x000fe200018e0643ULL,
0x0000004b32327210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff317224ULL, 0x000fe200000e0631ULL,
0xfffffff0504f7812ULL, 0x000fe200078ee24fULL, 0x000000ffff417224ULL, 0x000fe200020e0641ULL,
0x0000c0004e4b7811ULL, 0x000fe200078e20ffULL, 0x000000ffff337224ULL, 0x000fe200018e0633ULL,
0x0000c0004f4f7811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000422b7faeULL, 0x0003e8000b901c46ULL, 0x00000000304d7faeULL, 0x0003e8000b901c46ULL,
0x00000000324b7faeULL, 0x0003e8000b901c46ULL, 0x00000000404f7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff307f8cULL, 0x000e64000c80043fULL, 0x000000ffff2b7224ULL, 0x002fc400078e0031ULL,
0x0000000000307805ULL, 0x000fca0000015200ULL, 0x0106b400ff337984ULL, 0x000e640000000800ULL,
0x8000000033ff7812ULL, 0x002fc40007804849ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff407224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fcc0000015200ULL,
0x0000003230417210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09004100780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404100780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000004132327211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000140407810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106b400ff337984ULL, 0x000e640000000800ULL, 0x8000000033ff7812ULL, 0x002fe40007804849ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000014000007945ULL, 0x000fe20003800000ULL,
0x0000012000002947ULL, 0x000fea0003800000ULL, 0x0000000aff08723eULL, 0x000fe400000010ffULL,
0x00000002ff317819ULL, 0x000fe40000011617ULL, 0x0000541008307816ULL, 0x000fe20000000008ULL,
0x0000cda27f007947ULL, 0x000fea000b800000ULL, 0x00001f3130097589ULL, 0x0002a400000e0000ULL,
0x0000000831557810ULL, 0x002fe20007ffe0ffULL, 0x0000cdd27f007947ULL, 0x000fea000b800000ULL,
0x00001f5530087589ULL, 0x0002e400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001031557810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff527224ULL, 0x000fe200078e0030ULL,
0x0000e88000427802ULL, 0x000fc40000000f00ULL, 0x0000d50000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001831557810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff527224ULL, 0x004fe200078e0030ULL, 0x0000e8d000427802ULL, 0x000fc40000000f00ULL,
0x0000d4b000007944ULL, 0x008fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000002950783bULL, 0x004ea80000004200ULL,
0x000000002a4c783bULL, 0x000f280000004200ULL, 0x000000001a30783bULL, 0x002e680000004200ULL,
0x000000001940783bULL, 0x000ee20000004200ULL, 0x00000010ff737819ULL, 0x004fc40000011651ULL,
0x00000010ff717819ULL, 0x100fe40000011650ULL, 0x000000ff4e5e7812ULL, 0x010fe400078ec0ffULL,
0x000000ff73737812ULL, 0x000fe400078ec0ffULL, 0x000000ff50487812ULL, 0x040fe400078ec0ffULL,
0x00000018ff547819ULL, 0x000fe40000011650ULL, 0x0000ffff50887812ULL, 0x000fc400078ec0ffULL,
0x0000005eff5e723eULL, 0x000fe400020006ffULL, 0x000000ff51567812ULL, 0x040fe400078ec0ffULL,
0x00000018ff557819ULL, 0x000fe20000011651ULL, 0x2000005eff657230ULL, 0x000fe20000004100ULL,
0x0000ffff51897812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5d7819ULL, 0x002fe40000011630ULL,
0x000000ff30847812ULL, 0x000fc400078ec0ffULL, 0x00000018ff817819ULL, 0x000fe40000011630ULL,
0x0000ffff30507812ULL, 0x000fe400078ec0ffULL, 0x00000010ff777819ULL, 0x100fe40000011652ULL,
0x000000ff52577812ULL, 0x040fe400078ec0ffULL, 0x00000018ff517819ULL, 0x000fe40000011652ULL,
0x0000ffff528a7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff767819ULL, 0x008fe40000011641ULL,
0x00000018ff307819ULL, 0x000fe40000011631ULL, 0x00000073ff73723eULL, 0x000fe400020006ffULL,
0x00000010ff787819ULL, 0x100fe40000011653ULL, 0x000000ff53587812ULL, 0x000fe400078ec0ffULL,
0x00000018ff527819ULL, 0x000fc40000011653ULL, 0x0000ffff538b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff7b7819ULL, 0x100fe4000001164cULL, 0x000000ff4c597812ULL, 0x040fe400078ec0ffULL,
0x00000018ff537819ULL, 0x000fe4000001164cULL, 0x0000ffff4c8c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff7d7819ULL, 0x000fc4000001164dULL, 0x000000ff4d5b7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff5a7819ULL, 0x000fe4000001164dULL, 0x0000ffff4d8d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff827819ULL, 0x100fe4000001164fULL, 0x000000ff4f607812ULL, 0x000fe400078ec0ffULL,
0x00000018ff5f7819ULL, 0x000fc4000001164fULL, 0x0000ffff4f8f7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff4d7819ULL, 0x000fe4000001164eULL, 0x00000010ff4f7819ULL, 0x000fe40000011631ULL,
0x000000ff31857812ULL, 0x040fe400078ec0ffULL, 0x0000ffff314c7812ULL, 0x000fe400078ec0ffULL,
0x00000054ff54723eULL, 0x000fc400020006ffULL, 0x00000018ff317819ULL, 0x000fe40000011632ULL,
0x00000076ff5e723eULL, 0x000fe200020006ffULL, 0x20000073ff767230ULL, 0x000fe20000004100ULL,
0x00000030ff30723eULL, 0x000fe200020006ffULL, 0x20000054ff6f7230ULL, 0x000fe20000004100ULL,
0x00000010ff6b7819ULL, 0x000fe20000011641ULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x000000ff41797812ULL, 0x040fe200078ec0ffULL, 0x20000030ff547230ULL, 0x000fe20000004100ULL,
0x0000ffff416e7812ULL, 0x000fc400078ec0ffULL, 0x00000048ff41723eULL, 0x000fe400020006ffULL,
0x00000008ff737819ULL, 0x000fe4000001168bULL, 0x0000004dff4d723eULL, 0x000fe200020006ffULL,
0x20000041ff727230ULL, 0x000fe20000004100ULL, 0x00000031ff31723eULL, 0x000fe400020006ffULL,
0x00000010ff7f7819ULL, 0x000fe2000001164eULL, 0x2000004dff627230ULL, 0x000fe20000004100ULL,
0x0000ffff4e8e7812ULL, 0x000fe200078ec0ffULL, 0x20000031ff4d7230ULL, 0x000fe20000004100ULL,
0x000000ff40747812ULL, 0x000fc400078ec0ffULL, 0x000000ff427c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4e7819ULL, 0x000fe40000011632ULL, 0x000000ff32867812ULL, 0x040fe400078ec0ffULL,
0x0000ffff324b7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff307819ULL, 0x000fe40000011688ULL,
0x00000073ff73723eULL, 0x000fc400020006ffULL, 0x00000018ff327819ULL, 0x000fe40000011633ULL,
0x0000005fff5f723eULL, 0x000fe400020006ffULL, 0x0000005bff41723eULL, 0x000fe400020006ffULL,
0x00000018ff617819ULL, 0x000fe20000011640ULL, 0x2000005fff637230ULL, 0x000fe20000004100ULL,
0x0000005aff5a723eULL, 0x000fe200020006ffULL, 0x20000041ff417230ULL, 0x000fe20000004100ULL,
0x00000074ff74723eULL, 0x000fc400020006ffULL, 0x0000007cff5b723eULL, 0x000fe200020006ffULL,
0x2000005aff677230ULL, 0x000fe20000004100ULL, 0x00000053ff53723eULL, 0x000fe400020006ffULL,
0x00000030ff30723eULL, 0x000fe200020006ffULL, 0x2000005bff5b7230ULL, 0x000fe20000004100ULL,
0x00000008ff317819ULL, 0x000fe20000011689ULL, 0x20000053ff667230ULL, 0x000fe20000004100ULL,
0x000000ff7b7c7812ULL, 0x000fe200078ec0ffULL, 0x20000073ff7b7230ULL, 0x000fe20000004100ULL,
0x000000ff43807812ULL, 0x000fc400078ec0ffULL, 0x00000032ff32723eULL, 0x000fe400020006ffULL,
0x00000008ff737819ULL, 0x000fe4000001168dULL, 0x00000055ff55723eULL, 0x000fe200020006ffULL,
0x20000032ff537230ULL, 0x000fe20000004100ULL, 0x00000061ff5f723eULL, 0x000fe200020006ffULL,
0x20000074ff617230ULL, 0x000fe20000004100ULL, 0x00000031ff31723eULL, 0x000fe200020006ffULL,
0x20000030ff747230ULL, 0x000fe20000004100ULL, 0x00000080ff5a723eULL, 0x000fe200020006ffULL,
0x20000055ff707230ULL, 0x000fe20000004100ULL, 0x000000ff77307812ULL, 0x000fe200078ec0ffULL,
0x20000031ff777230ULL, 0x000fe20000004100ULL, 0x000000ff7f807812ULL, 0x000fe200078ec0ffULL,
0x2000005fff5f7230ULL, 0x000fe20000004100ULL, 0x00000073ff73723eULL, 0x000fe200020006ffULL,
0x2000005aff5a7230ULL, 0x000fe20000004100ULL, 0x000000ff78787812ULL, 0x000fc400078ec0ffULL,
0x00000008ff327819ULL, 0x000fe4000001168aULL, 0x00000057ff57723eULL, 0x000fe400020006ffULL,
0x00000058ff58723eULL, 0x000fe400020006ffULL, 0x00000060ff60723eULL, 0x000fe200020006ffULL,
0x20000057ff6c7230ULL, 0x000fe20000004100ULL, 0x00000081ff55723eULL, 0x000fe200020006ffULL,
0x20000058ff6d7230ULL, 0x000fe20000004100ULL, 0x00000010ff497819ULL, 0x000fe20000011633ULL,
0x20000060ff647230ULL, 0x000fe20000004100ULL, 0x000000ff33877812ULL, 0x040fe200078ec0ffULL,
0x20000055ff557230ULL, 0x000fe20000004100ULL, 0x0000ffff33487812ULL, 0x000fc400078ec0ffULL,
0x00000030ff31723eULL, 0x000fe400020006ffULL, 0x00000080ff81723eULL, 0x000fe200020006ffULL,
0x20000073ff807230ULL, 0x000fe20000004100ULL, 0x00000018ff7a7819ULL, 0x000fe40000011642ULL,
0x00000018ff7e7819ULL, 0x000fe20000011643ULL, 0x20000081ff817230ULL, 0x000fe20000004100ULL,
0x00000078ff33723eULL, 0x000fe200020006ffULL, 0x20000031ff787230ULL, 0x000fe20000004100ULL,
0x00000032ff32723eULL, 0x000fc400020006ffULL, 0x0000b0001b307811ULL, 0x000fe400078e20ffULL,
0x00000010ff837819ULL, 0x000fe40000011640ULL, 0x0000ffff40907812ULL, 0x000fe400078ec0ffULL,
0x00000056ff56723eULL, 0x000fe400020006ffULL, 0x00000008ff737819ULL, 0x000fe4000001168fULL,
0x00000010ff407819ULL, 0x000fe20000011643ULL, 0x20000056ff757230ULL, 0x000fe20000004100ULL,
0x0000ffff435c7812ULL, 0x000fc400078ec0ffULL, 0x00000059ff43723eULL, 0x000fe400020006ffULL,
0x00000079ff60723eULL, 0x000fe200020006ffULL, 0x20000032ff797230ULL, 0x000fe20000004100ULL,
0x0000007aff58723eULL, 0x000fe200020006ffULL, 0x20000033ff7a7230ULL, 0x000fe20000004100ULL,
0x0000007eff59723eULL, 0x000fe200020006ffULL, 0x000000003030783bULL, 0x000e620000000200ULL,
0x00000084ff57723eULL, 0x000fe200020006ffULL, 0x20000043ff437230ULL, 0x000fe20000004100ULL,
0x000000ff7d7e7812ULL, 0x000fe200078ec0ffULL, 0x20000060ff607230ULL, 0x000fe20000004100ULL,
0x000000ff83847812ULL, 0x000fe200078ec0ffULL, 0x20000059ff597230ULL, 0x000fe20000004100ULL,
0x00000073ff73723eULL, 0x000fe200020006ffULL, 0x20000057ff577230ULL, 0x000fe20000004100ULL,
0x00000008ff7d7819ULL, 0x000fe2000001168cULL, 0x20000058ff587230ULL, 0x000fe20000004100ULL,
0x00000085ff56723eULL, 0x000fc400020006ffULL, 0x0000007eff7e723eULL, 0x000fe400020006ffULL,
0x00000084ff85723eULL, 0x000fe200020006ffULL, 0x20000073ff847230ULL, 0x000fe20000004100ULL,
0x0000007dff7d723eULL, 0x000fe200020006ffULL, 0x2000007eff7f7230ULL, 0x000fe20000004100ULL,
0x00000010ff737819ULL, 0x000fe20000011675ULL, 0x20000085ff857230ULL, 0x000fe20000004100ULL,
0x00000010ff707819ULL, 0x000fe20000011670ULL, 0x2000007dff7e7230ULL, 0x000fe20000004100ULL,
0x00000010ff757819ULL, 0x000fe20000011677ULL, 0x20000056ff567230ULL, 0x000fe20000004100ULL,
0x00000052ff52723eULL, 0x000fc400020006ffULL, 0x000000ff82827812ULL, 0x000fe400078ec0ffULL,
0x00000010ff6f7819ULL, 0x000fe2000001166fULL, 0x20000052ff697230ULL, 0x000fe20000004100ULL,
0x00000010ff747819ULL, 0x000fe40000011674ULL, 0x00000008ff7d7819ULL, 0x000fe4000001168eULL,
0x0000105470757816ULL, 0x000fe40000000075ULL, 0x000000ff40707812ULL, 0x000fc400078ec0ffULL,
0x00000010ff407819ULL, 0x000fe2000001166dULL, 0x000000093030a231ULL, 0x082fe200003400ffULL,
0x00000082ff82723eULL, 0x000fe200020006ffULL, 0x000000093232a231ULL, 0x000fe200003400ffULL,
0x000010546f747816ULL, 0x000fe20000000074ULL, 0x000000083131a231ULL, 0x080fe200003400ffULL,
0x00000010ff6c7819ULL, 0x000fe2000001166cULL, 0x20000082ff837230ULL, 0x000fe20000004100ULL,
0x00000010ff6d7819ULL, 0x000fe20000011678ULL, 0x000000083333a231ULL, 0x000fe200003400ffULL,
0x0000007dff7d723eULL, 0x000fc400020006ffULL, 0x00000010ff6f7819ULL, 0x000fe4000001167aULL,
0x00000010ff6a7819ULL, 0x000fe20000011642ULL, 0x2000007dff827230ULL, 0x000fe20000004100ULL,
0x0000ffff42427812ULL, 0x000fe200078ec0ffULL, 0x000000743034723cULL, 0x000fe20000041834ULL,
0x0000007cff7c723eULL, 0x000fe400020006ffULL, 0x00000086ff52723eULL, 0x000fe400020006ffULL,
0x000010546d6c7816ULL, 0x000fe2000000006cULL, 0x2000007cff7c7230ULL, 0x000fe20000004100ULL,
0x00000008ff867819ULL, 0x000fe20000011690ULL, 0x20000052ff527230ULL, 0x000fe20000004100ULL,
0x000010546f6d7816ULL, 0x000fc40000000040ULL, 0x00000010ff407819ULL, 0x000fe40000011669ULL,
0x000000ff6b7d7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff427819ULL, 0x000fe20000011642ULL,
0x0000006c3038723cULL, 0x000fe20000041838ULL, 0x00000010ff697819ULL, 0x000fe4000001167bULL,
0x00000086ff86723eULL, 0x000fe400020006ffULL, 0x0000007dff7d723eULL, 0x000fc400020006ffULL,
0x00000042ff6f723eULL, 0x000fe200020006ffULL, 0x20000086ff6b7230ULL, 0x000fe20000004100ULL,
0x0000105440697816ULL, 0x000fe40000000069ULL, 0x00000010ff437819ULL, 0x000fe20000011643ULL,
0x2000006fff6f7230ULL, 0x000fe20000004100ULL, 0x00000010ff417819ULL, 0x000fe40000011641ULL,
0x00000010ff407819ULL, 0x000fe4000001167fULL, 0x0000b00028427811ULL, 0x000fc400078e20ffULL,
0x00000051ff51723eULL, 0x000fe400020006ffULL, 0x00000010ff7c7819ULL, 0x000fe4000001167cULL,
0x00000008ff867819ULL, 0x000fe2000001166eULL, 0x2000007dff6e7230ULL, 0x000fe20000004100ULL,
0x000000ff71717812ULL, 0x000fe200078ec0ffULL, 0x20000051ff687230ULL, 0x000fe20000004100ULL,
0x000010547c7c7816ULL, 0x000fe40000000043ULL, 0x00001054407d7816ULL, 0x000fc40000000041ULL,
0x000000004240783bULL, 0x000e620000000200ULL, 0x00000071ff71723eULL, 0x000fe400020006ffULL,
0x00000010ff687819ULL, 0x000fe40000011668ULL, 0x00000010ff797819ULL, 0x000fe20000011679ULL,
0x20000071ff717230ULL, 0x000fe20000004100ULL, 0x00000010ff727819ULL, 0x000fe20000011672ULL,
0x0000007c3024723cULL, 0x000fe20000041824ULL, 0x0000105468687816ULL, 0x000fe40000000079ULL,
0x00000010ff717819ULL, 0x000fc40000011671ULL, 0x00000010ff767819ULL, 0x000fe40000011676ULL,
0x0000105471727816ULL, 0x000fe20000000072ULL, 0x00000068303c723cULL, 0x040be2000004183cULL,
0x0000105476737816ULL, 0x000fe40000000073ULL, 0x00000010ff7e7819ULL, 0x000fe4000001167eULL,
0x00000010ff7f7819ULL, 0x000fe40000011680ULL, 0x000000ff5d697812ULL, 0x020fe200078ec0ffULL,
0x000000723044723cULL, 0x000f620000041844ULL, 0x00000008ff687819ULL, 0x000fc4000001165cULL,
0x00000010ff5d7819ULL, 0x000fe40000011666ULL, 0x00000010ff5c7819ULL, 0x000fe40000011667ULL,
0x000010545d7e7816ULL, 0x000fe4000000007eULL, 0x000010545c7f7816ULL, 0x000fe4000000007fULL,
0x00000010ff5d7819ULL, 0x000fe40000011664ULL, 0x00000010ff657819ULL, 0x000fc40000011665ULL,
0x00000010ff5c7819ULL, 0x000fe20000011681ULL, 0x000000094040a231ULL, 0x082fe200003400ffULL,
0x00000010ff647819ULL, 0x000fe20000011683ULL, 0x000000094242a231ULL, 0x000fe200003400ffULL,
0x000010545c5c7816ULL, 0x000fe20000000065ULL, 0x000000084141a231ULL, 0x080fe200003400ffULL,
0x00001054645d7816ULL, 0x000fe2000000005dULL, 0x000000084343a231ULL, 0x000fe200003400ffULL,
0x000000ff4f657812ULL, 0x000fe200078ec0ffULL, 0x0000007e3020723cULL, 0x000fe20000041820ULL,
0x00000008ff647819ULL, 0x000fc40000011650ULL, 0x00000010ff4f7819ULL, 0x000fe40000011662ULL,
0x00000010ff507819ULL, 0x000fe40000011663ULL, 0x00000010ff827819ULL, 0x000fe20000011682ULL,
0x0000005c301c723cULL, 0x000b62000004181cULL, 0x00000010ff837819ULL, 0x000fe40000011684ULL,
0x000010544f827816ULL, 0x000fe40000000082ULL, 0x0000105450837816ULL, 0x000fc40000000083ULL,
0x00000010ff617819ULL, 0x000fe40000011661ULL, 0x00000010ff5d7819ULL, 0x020fe40000011660ULL,
0x00000010ff507819ULL, 0x000fe20000011685ULL, 0x00000082302c723cULL, 0x000b62000004182cULL,
0x00000010ff6e7819ULL, 0x000fe4000001166eULL, 0x00000068ff68723eULL, 0x000fe400020006ffULL,
0x00001054505c7816ULL, 0x000fc40000000061ULL, 0x000010546e5d7816ULL, 0x000fe2000000005dULL,
0x20000068ff687230ULL, 0x000fe20000004100ULL, 0x000000ff4e4e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff307819ULL, 0x020fe4000001165fULL, 0x00000010ff6b7819ULL, 0x000fe4000001166bULL,
0x00000069ff69723eULL, 0x000fe400020006ffULL, 0x00000065ff65723eULL, 0x000fc400020006ffULL,
0x0000004eff50723eULL, 0x000fe200020006ffULL, 0x20000069ff697230ULL, 0x000fe20000004100ULL,
0x00001054304e7816ULL, 0x000fe2000000006bULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x0000005c4030723cULL, 0x000b620000041844ULL, 0x00000008ff4c7819ULL, 0x000fe2000001164cULL,
0x20000050ff507230ULL, 0x000fe20000004100ULL, 0x000000ff49497812ULL, 0x000fe400078ec0ffULL,
0x00000010ff577819ULL, 0x000fe40000011657ULL, 0x00000010ff447819ULL, 0x020fc40000011659ULL,
0x00000010ff597819ULL, 0x000fe40000011668ULL, 0x00000010ff457819ULL, 0x000fe40000011656ULL,
0x0000105444597816ULL, 0x000fe40000000059ULL, 0x00000010ff447819ULL, 0x000fe40000011669ULL,
0x00000010ff467819ULL, 0x000fe40000011665ULL, 0x00000087ff51723eULL, 0x000fc400020006ffULL,
0x0000004cff4c723eULL, 0x000fe400020006ffULL, 0x00000049ff49723eULL, 0x000fe200020006ffULL,
0x20000051ff517230ULL, 0x000fe20000004100ULL, 0x000000ff6a6a7812ULL, 0x000fe200078ec0ffULL,
0x2000004cff4c7230ULL, 0x000fe20000004100ULL, 0x00000008ff4b7819ULL, 0x000fe2000001164bULL,
0x20000049ff497230ULL, 0x000fe20000004100ULL, 0x0000105444447816ULL, 0x000fe40000000057ULL,
0x0000105446457816ULL, 0x000fc40000000045ULL, 0x00000008ff487819ULL, 0x000fe40000011648ULL,
0x00000086ff86723eULL, 0x000fe400020006ffULL, 0x0000006aff6a723eULL, 0x000fe200020006ffULL,
0x000000444024723cULL, 0x000b620000041824ULL, 0x00000070ff70723eULL, 0x000fe200020006ffULL,
0x20000086ff867230ULL, 0x000fe20000004100ULL, 0x00000064ff64723eULL, 0x000fe200020006ffULL,
0x2000006aff6a7230ULL, 0x000fe20000004100ULL, 0x0000004bff4b723eULL, 0x000fe200020006ffULL,
0x20000070ff707230ULL, 0x000fe20000004100ULL, 0x00000048ff48723eULL, 0x000fe200020006ffULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x00000010ff527819ULL, 0x000fe20000011652ULL,
0x2000004bff4b7230ULL, 0x000fe20000004100ULL, 0x00000010ff457819ULL, 0x020fe20000011650ULL,
0x20000048ff487230ULL, 0x000fe20000004100ULL, 0x00000010ff657819ULL, 0x000fc40000011654ULL,
0x00000010ff4c7819ULL, 0x000fe4000001164cULL, 0x00000010ff517819ULL, 0x000fe40000011651ULL,
0x00000010ff467819ULL, 0x000fe40000011649ULL, 0x0000105445447816ULL, 0x000fe40000000052ULL,
0x0000105465657816ULL, 0x000fe4000000004cULL, 0x0000105446457816ULL, 0x000fc40000000051ULL,
0x00000010ff5e7819ULL, 0x000fe4000001165eULL, 0x00000010ff4f7819ULL, 0x000fe40000011686ULL,
0x00000010ff5b7819ULL, 0x000fe2000001165bULL, 0x00000044401c723cULL, 0x000b62000004181cULL,
0x00000010ff5a7819ULL, 0x000fe4000001165aULL, 0x00000010ff6a7819ULL, 0x000fe4000001166aULL,
0x00000010ff6b7819ULL, 0x000fc40000011670ULL, 0x00000010ff587819ULL, 0x000fe40000011658ULL,
0x00000010ff6f7819ULL, 0x000fe4000001166fULL, 0x00000010ff557819ULL, 0x000fe40000011655ULL,
0x00000010ff647819ULL, 0x000fe40000011664ULL, 0x00000010ff467819ULL, 0x000fe4000001164dULL,
0x00000010ff4b7819ULL, 0x000fc4000001164bULL, 0x00000010ff4c7819ULL, 0x000fe40000011653ULL,
0x00000010ff477819ULL, 0x000fe40000011648ULL, 0x000010545e4f7816ULL, 0x000fe4000000004fULL,
0x000010546a6a7816ULL, 0x000fe4000000005bULL, 0x000010546b6b7816ULL, 0x000fe4000000005aULL,
0x0000105458587816ULL, 0x000fe2000000006fULL, 0x0000004e4034723cULL, 0x000b620000041834ULL,
0x0000105455647816ULL, 0x000fc40000000064ULL, 0x0000105446467816ULL, 0x000fe4000000004bULL,
0x000010544c477816ULL, 0x000fc60000000047ULL, 0x0000006a4038723cULL, 0x040b700000041838ULL,
0x00000058403c723cULL, 0x040b70000004183cULL, 0x000000644020723cULL, 0x040b700000041820ULL,
0x00000046402c723cULL, 0x000b62000004182cULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff407f8cULL, 0x020e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000a010407810ULL, 0x002fe20007ffe0ffULL,
0x01069800ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff467224ULL, 0x000fc400078e0041ULL,
0x000000154000720cULL, 0x000fe20003f06070ULL, 0x000000ffff407224ULL, 0x000fd800078e004aULL,
0x00004ee000000947ULL, 0x000fea0003800000ULL, 0x0000000000407805ULL, 0x000fc40000015200ULL,
0x0106bc00ff437984ULL, 0x000e640000000800ULL, 0x8000000043ff7812ULL, 0x002fe40007804846ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff447224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000427805ULL, 0x000fcc0000015200ULL, 0x0000004240457210ULL, 0x000fca0007f1e1ffULL,
0x0000000143437824ULL, 0x000fe200000e0e41ULL, 0x003d09004500780cULL, 0x000fc80003f06070ULL,
0x000000ff4300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404500780cULL, 0x000fc80003f06070ULL, 0x000000ff4300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff427819ULL, 0x000fc80000011443ULL,
0x0000004542427211ULL, 0x000fca00078110ffULL, 0x000000ffff437224ULL, 0x000fca00000e0643ULL,
0x0000000242427819ULL, 0x000fc80000001243ULL, 0x000000420000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000144447810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106bc00ff437984ULL, 0x000e640000000800ULL,
0x8000000043ff7812ULL, 0x002fe40007804846ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000c010427810ULL, 0x000fca0007ffe0ffULL, 0x0000620013437a24ULL, 0x000fe200078e0242ULL,
0x0000039000009947ULL, 0x000fea0003800000ULL, 0x0000004215407217ULL, 0x000fe20007800000ULL,
0x0000000114447824ULL, 0x000fe200078e0207ULL, 0x00000004074d7810ULL, 0x040fe40007ffe0ffULL,
0x0000000207457810ULL, 0x040fe20007ffe0ffULL, 0x0000000140417824ULL, 0x000fe200078e0a42ULL,
0x00000006074f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000114487824ULL, 0x040fe400078e024dULL,
0x0000000114427824ULL, 0x040fe200078e0245ULL, 0x0000004114417217ULL, 0x000fe20007800000ULL,
0x0000000144407824ULL, 0x000fc400078e0217ULL, 0x00000010444b7824ULL, 0x000fe400078e00ffULL,
0x0000000148477824ULL, 0x140fe400078e0217ULL, 0x00000010484e7824ULL, 0x000fe200078e00ffULL,
0xfffffff04b4b7812ULL, 0x000fe200078ee240ULL, 0x0000000142467824ULL, 0x040fe400078e0217ULL,
0x0000001042497824ULL, 0x000fe200078e00ffULL, 0xfffffff04e4e7812ULL, 0x000fe200078ee247ULL,
0x0000000114507824ULL, 0x000fe200078e024fULL, 0x0000e0004b4b7811ULL, 0x000fe200078e20ffULL,
0x00000100ff477424ULL, 0x000fe200078e00ffULL, 0xfffffff0494c7812ULL, 0x000fe200078ee246ULL,
0x0000000144407824ULL, 0x100fe200078e0243ULL, 0x000000f00f497812ULL, 0x000fe200078ec0ffULL,
0x0000000142427824ULL, 0x000fc400078e0243ULL, 0x0000000148447824ULL, 0x100fe400078e0243ULL,
0x0000000150467824ULL, 0x040fe400078e0243ULL, 0x0000000150437824ULL, 0x040fe400078e0217ULL,
0x0000001050507824ULL, 0x000fe400078e00ffULL, 0x0000000141487824ULL, 0x000fe400078e0a14ULL,
0x00005e0040407625ULL, 0x000fe200078e0047ULL, 0xfffffff050507812ULL, 0x000fc400078ee243ULL,
0x000000484500720cULL, 0x080fe20003f46070ULL, 0x00005e0042427625ULL, 0x000fe200078e0047ULL,
0x0000004940407210ULL, 0x000fe40007fbe0ffULL, 0x000000480700720cULL, 0x080fe20003f66070ULL,
0x00005e0044447625ULL, 0x080fe200078e0047ULL, 0x000000484d00720cULL, 0x080fe40003f26070ULL,
0x000000484f00720cULL, 0x000fe20003f06070ULL, 0x00005e0046467625ULL, 0x000fe200078e0047ULL,
0x0000004942427210ULL, 0x000fc40007f9e0ffULL, 0x0000e0004e4d7811ULL, 0x000fe200078e20ffULL,
0x000000ffff417224ULL, 0x000fe200028e0641ULL, 0x0000004944447210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff437224ULL, 0x000fe200020e0643ULL, 0x0000004946467210ULL, 0x000fe40007fde0ffULL,
0x0000e0004c497811ULL, 0x000fe200078e20ffULL, 0x000000ffff457224ULL, 0x000fe200028e0645ULL,
0x0000e000504f7811ULL, 0x000fe200078e20ffULL, 0x000000ffff477224ULL, 0x000fe200030e0647ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000404b7faeULL, 0x0003e8000d901c46ULL,
0x0000000042497faeULL, 0x0003e8000d101c46ULL, 0x00000000444d7faeULL, 0x0003e8000c901c46ULL,
0x00000000464f7faeULL, 0x0003e2000c101c46ULL, 0x000002d000007947ULL, 0x000fea0003800000ULL,
0x0000000114407824ULL, 0x000fe200078e0207ULL, 0x000000f00f497812ULL, 0x000fc600078ec0ffULL,
0x0000000140417824ULL, 0x140fe200078e0217ULL, 0x00000004404c7810ULL, 0x040fe20007ffe0ffULL,
0x0000001040487824ULL, 0x040fe200078e00ffULL, 0x0000000240427810ULL, 0x040fe40007ffe0ffULL,
0x00000006404e7810ULL, 0x000fe20007ffe0ffULL, 0x000000014c457824ULL, 0x000fe200078e0217ULL,
0xfffffff048487812ULL, 0x000fe200078ee241ULL, 0x000000104c467824ULL, 0x000fe400078e00ffULL,
0x0000000142447824ULL, 0x000fc400078e0217ULL, 0x00000010424b7824ULL, 0x000fe200078e00ffULL,
0xfffffff0464d7812ULL, 0x000fe200078ee245ULL, 0x00000100ff457424ULL, 0x000fe400078e00ffULL,
0x0000000140467824ULL, 0x100fe200078e0243ULL, 0xfffffff04b4b7812ULL, 0x000fe200078ee244ULL,
0x0000000142407824ULL, 0x000fe200078e0243ULL, 0x0000e0004d4d7811ULL, 0x000fe200078e20ffULL,
0x00005e0046467625ULL, 0x000fe200078e0045ULL, 0x0000e0004b4b7811ULL, 0x000fc600078e20ffULL,
0x000000014c427824ULL, 0x100fe200078e0243ULL, 0x0000004946467210ULL, 0x000fe20007f3e0ffULL,
0x000000014e447824ULL, 0x000fe400078e0243ULL, 0x00005e0040407625ULL, 0x000fc800078e0045ULL,
0x00005e0042427625ULL, 0x000fe200078e0045ULL, 0x0000004940407210ULL, 0x000fc60007f1e0ffULL,
0x00005e0044447625ULL, 0x000fc800078e0045ULL, 0x000000014e4c7824ULL, 0x000fe200078e0217ULL,
0x0000004944447210ULL, 0x080fe20007f5e0ffULL, 0x000000104e4f7824ULL, 0x000fe400078e00ffULL,
0x000000ffff477224ULL, 0x000fe200008e0647ULL, 0x0000004942427210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff417224ULL, 0x000fe200000e0641ULL, 0xfffffff04f4c7812ULL, 0x000fe200078ee24cULL,
0x000000ffff457224ULL, 0x000fe200010e0645ULL, 0x0000e00048497811ULL, 0x000fe200078e20ffULL,
0x000000ffff437224ULL, 0x000fe200008e0643ULL, 0x0000e0004c4f7811ULL, 0x000fc600078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000046497faeULL, 0x0003e8000b901c46ULL,
0x00000000404b7faeULL, 0x0003e8000b901c46ULL, 0x00000000424d7faeULL, 0x0003e8000b901c46ULL,
0x00000000444f7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b000ff4c7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106680014447f8cULL, 0x0004e4000c80043fULL,
0x0000000000407805ULL, 0x000fc40000015200ULL, 0x01066c0014437984ULL, 0x000f240000000800ULL,
0x8000000043ff7812ULL, 0x018fc40007804845ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff467224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000427805ULL, 0x000fcc0000015200ULL,
0x0000004240477210ULL, 0x000fca0007f1e1ffULL, 0x0000000143437824ULL, 0x000fe200000e0e41ULL,
0x003d09004700780cULL, 0x000fc80003f06070ULL, 0x000000ff4300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404700780cULL, 0x000fc80003f06070ULL,
0x000000ff4300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff427819ULL, 0x000fc80000011443ULL, 0x0000004742427211ULL, 0x000fca00078110ffULL,
0x000000ffff437224ULL, 0x000fca00000e0643ULL, 0x0000000242427819ULL, 0x000fc80000001243ULL,
0x000000420000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000146467810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01066c0014437984ULL, 0x000ee40000000800ULL, 0x8000000043ff7812ULL, 0x008fe40007804845ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x010180000e417984ULL, 0x000ee80000000800ULL,
0x010380000e457984ULL, 0x0004620000000800ULL, 0x0000004a4100720bULL, 0x008fe20003f1d000ULL,
0x0000aa127f007947ULL, 0x000fd8000b800000ULL, 0x0000000000447806ULL, 0x004fc800000e0100ULL,
0x0000ffff44ff7812ULL, 0x000fe2000780c0ffULL, 0x0000048000007945ULL, 0x000fe20003800000ULL,
0x00000001ff467424ULL, 0x000fc400078e00ffULL, 0x000000ffff407224ULL, 0x000fd200078e004aULL,
0x0000044000008947ULL, 0x000fea0003800000ULL, 0x000000031800780cULL, 0x000fe40003f05270ULL,
0x0000004a4100720bULL, 0x000fe20003f34000ULL, 0x0000a9d27f007947ULL, 0x000fd8000b800000ULL,
0x00000000000d7806ULL, 0x000fc400008e0100ULL, 0x0000004a41438209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x000099100d407816ULL, 0x000fc600000000ffULL,
0x010580430e008388ULL, 0x0005e20000000800ULL, 0x000000ff4000720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000004a41437209ULL, 0x004fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff0dff7812ULL, 0x000fc6000780c0ffULL,
0x0000004a430e7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b0e0e7820ULL, 0x000fc80000410000ULL,
0x0000000e00477308ULL, 0x000ea40000000800ULL, 0x0000004712127220ULL, 0x004fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff557819ULL, 0x000fe20000011617ULL,
0x0000a9127f007947ULL, 0x000fea000b800000ULL, 0x00001f55470e7589ULL, 0x0004e400000e0000ULL,
0x0000000e30307220ULL, 0x088fe20000410000ULL, 0x0000000e31317220ULL, 0x080fe20000410000ULL,
0x0000000e34347220ULL, 0x080fe20000410000ULL, 0x0000000e35357220ULL, 0x080fe20000410000ULL,
0x0000000e38387220ULL, 0x080fe20000410000ULL, 0x0000000e39397220ULL, 0x080fe20000410000ULL,
0x0000000e3c3c7220ULL, 0x080fe20000410000ULL, 0x0000000e3d3d7220ULL, 0x080fe20000410000ULL,
0x0000000e24247220ULL, 0x080fe20000410000ULL, 0x0000000e25257220ULL, 0x080fe20000410000ULL,
0x0000000e20207220ULL, 0x080fe20000410000ULL, 0x0000000e21217220ULL, 0x080fe20000410000ULL,
0x0000000e1c1c7220ULL, 0x080fe20000410000ULL, 0x0000000e1d1d7220ULL, 0x080fe20000410000ULL,
0x0000000e2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000e2d2d7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff000dff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000817557811ULL, 0x006fe200078ff0ffULL,
0x0000a8027f007947ULL, 0x000fea000b800000ULL, 0x00001f55470e7589ULL, 0x0002a400000e0000ULL,
0x0000000e32327220ULL, 0x084fe20000410000ULL, 0x0000000e33337220ULL, 0x080fe20000410000ULL,
0x0000000e36367220ULL, 0x080fe20000410000ULL, 0x0000000e37377220ULL, 0x080fe20000410000ULL,
0x0000000e3a3a7220ULL, 0x080fe20000410000ULL, 0x0000000e3b3b7220ULL, 0x080fe20000410000ULL,
0x0000000e3e3e7220ULL, 0x080fe20000410000ULL, 0x0000000e3f3f7220ULL, 0x080fe20000410000ULL,
0x0000000e26267220ULL, 0x080fe20000410000ULL, 0x0000000e27277220ULL, 0x080fe20000410000ULL,
0x0000000e22227220ULL, 0x080fe20000410000ULL, 0x0000000e23237220ULL, 0x080fe20000410000ULL,
0x0000000e1e1e7220ULL, 0x080fe20000410000ULL, 0x0000000e1f1f7220ULL, 0x080fe20000410000ULL,
0x0000000e2e2e7220ULL, 0x080fe20000410000ULL, 0x0000000e2f2f7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff0dff7812ULL, 0x000fe20007800844ULL,
0x00000001ff467424ULL, 0x000fe200078e00ffULL, 0x0000004a41407209ULL, 0x000fd60007810000ULL,
0x8000004041410221ULL, 0x000fe20000010000ULL, 0x00007610ff460816ULL, 0x000fc60000000046ULL,
0x3fb8aa3b41410820ULL, 0x000fc80000410000ULL, 0x00000041000a0308ULL, 0x000ea40000000800ULL,
0x0000000a45450220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001245127221ULL, 0x002fc20000010000ULL, 0x0000000000427805ULL, 0x000fcc0000015200ULL,
0x0106ac00ff0e7984ULL, 0x000e640000000800ULL, 0x800000000eff7812ULL, 0x002fe4000780482bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff417224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104100780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000447805ULL, 0x000fcc0000015200ULL, 0x00000044420e7210ULL, 0x000fca0007f1e1ffULL,
0x0000000145447824ULL, 0x000fe200000e0e43ULL, 0x003d09000e00780cULL, 0x000fc80003f06070ULL,
0x000000ff4400720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400e00780cULL, 0x000fc80003f06070ULL, 0x000000ff4400720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0d7819ULL, 0x000fc80000011444ULL,
0x0000000e0d0d7211ULL, 0x000fca00078110ffULL, 0x000000ffff0e7224ULL, 0x000fca00000e0644ULL,
0x000000020d0d7819ULL, 0x000fc8000000120eULL, 0x0000000d0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000141417810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106ac00ff0e7984ULL, 0x000e640000000800ULL,
0x800000000eff7812ULL, 0x002fe4000780482bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009910460d7816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0d00720cULL, 0x000fda0003f25270ULL, 0x0000012000001947ULL, 0x000fea0003800000ULL,
0x0000000aff08723eULL, 0x000fe400000010ffULL, 0x00000002ff0e7819ULL, 0x000fe40000011617ULL,
0x00005410080d7816ULL, 0x000fe20000000008ULL, 0x0000a3e27f007947ULL, 0x000fea000b800000ULL,
0x00001f0e0d097589ULL, 0x0002a400000e0000ULL, 0x000000080e557810ULL, 0x002fe20007ffe0ffULL,
0x0000a4127f007947ULL, 0x000fea000b800000ULL, 0x00001f550d087589ULL, 0x0002e400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000100e557810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff527224ULL, 0x000fe200078e000dULL, 0x0001143000427802ULL, 0x000fc40000000f00ULL,
0x0000a95000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000180e557810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff527224ULL, 0x004fe200078e000dULL,
0x0001148000427802ULL, 0x000fc40000000f00ULL, 0x0000a90000007944ULL, 0x008fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000000654783bULL, 0x002e620000004200ULL, 0x0000b80000007811ULL, 0x000fc600078e20ffULL,
0x000000000550783bULL, 0x004ea80000004200ULL, 0x000000000448783bULL, 0x000f280000004200ULL,
0x000000000244783bULL, 0x000ee20000004200ULL, 0x00000010ff4e7819ULL, 0x002fe40000011654ULL,
0x000000ff540d7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff0e7819ULL, 0x000fe40000011654ULL,
0x0000ffff54827812ULL, 0x000fe400078ec0ffULL, 0x00000010ff6b7819ULL, 0x100fe40000011655ULL,
0x000000ff554f7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff437819ULL, 0x000fe40000011655ULL,
0x0000ffff55837812ULL, 0x000fc400078ec0ffULL, 0x00000010ff6f7819ULL, 0x100fe40000011656ULL,
0x000000ff56557812ULL, 0x040fe400078ec0ffULL, 0x00000018ff547819ULL, 0x000fe40000011656ULL,
0x0000ffff56847812ULL, 0x000fe400078ec0ffULL, 0x00000010ff717819ULL, 0x000fe40000011657ULL,
0x000000ff57597812ULL, 0x000fc400078ec0ffULL, 0x00000018ff567819ULL, 0x000fe40000011657ULL,
0x0000ffff57857812ULL, 0x000fe400078ec0ffULL, 0x00000010ff757819ULL, 0x104fe40000011650ULL,
0x000000ff505b7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff5a7819ULL, 0x000fe40000011650ULL,
0x0000ffff50867812ULL, 0x000fc400078ec0ffULL, 0x00000010ff667819ULL, 0x110fe4000001164bULL,
0x000000ff4b7c7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff787819ULL, 0x000fe4000001164bULL,
0x0000ffff4b577812ULL, 0x000fe400078ec0ffULL, 0x00000018ff507819ULL, 0x000fe40000011651ULL,
0x00000010ff587819ULL, 0x008fc40000011644ULL, 0x000000ff447d7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff4b7819ULL, 0x000fe40000011644ULL, 0x0000ffff44417812ULL, 0x000fe400078ec0ffULL,
0x0000000eff0e723eULL, 0x000fe400020006ffULL, 0x00000010ff2b7819ULL, 0x100fe40000011645ULL,
0x000000ff457f7812ULL, 0x000fe200078ec0ffULL, 0x2000000eff6c7230ULL, 0x000fe20000004100ULL,
0x00000018ff447819ULL, 0x000fc40000011645ULL, 0x0000ffff45067812ULL, 0x000fe400078ec0ffULL,
0x00000018ff457819ULL, 0x100fe40000011646ULL, 0x000000ff515c7812ULL, 0x000fe400078ec0ffULL,
0x0000000dff42723eULL, 0x000fe400020006ffULL, 0x00000050ff50723eULL, 0x000fe400020006ffULL,
0x00000010ff0d7819ULL, 0x000fc40000011646ULL, 0x000000ff46807812ULL, 0x040fe200078ec0ffULL,
0x20000050ff637230ULL, 0x000fe20000004100ULL, 0x0000ffff46057812ULL, 0x000fe400078ec0ffULL,
0x00000044ff44723eULL, 0x000fe400020006ffULL, 0x00000018ff467819ULL, 0x000fe40000011647ULL,
0x00000045ff0e723eULL, 0x000fe200020006ffULL, 0x20000044ff507230ULL, 0x000fe20000004100ULL,
0x000000ff6b6b7812ULL, 0x000fc400078ec0ffULL, 0x000000ff4e4e7812ULL, 0x000fe200078ec0ffULL,
0x2000000eff0e7230ULL, 0x000fe20000004100ULL, 0x00000008ff457819ULL, 0x000fe40000011682ULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x00000010ff047819ULL, 0x000fe40000011647ULL,
0x000000ff47817812ULL, 0x040fe200078ec0ffULL, 0x2000005cff657230ULL, 0x000fe20000004100ULL,
0x0000ffff47027812ULL, 0x000fc400078ec0ffULL, 0x0000004fff4f723eULL, 0x000fe400020006ffULL,
0x000000ff486e7812ULL, 0x000fe400078ec0ffULL, 0x0000004bff4b723eULL, 0x000fe200020006ffULL,
0x2000004fff6d7230ULL, 0x000fe20000004100ULL, 0x00000046ff47723eULL, 0x000fe400020006ffULL,
0x0000006bff6b723eULL, 0x000fe200020006ffULL, 0x2000004bff4f7230ULL, 0x000fe20000004100ULL,
0x0000004eff44723eULL, 0x000fe200020006ffULL, 0x20000047ff4e7230ULL, 0x000fe20000004100ULL,
0x00000045ff45723eULL, 0x000fc400020006ffULL, 0x00000008ff467819ULL, 0x000fe20000011683ULL,
0x20000044ff4b7230ULL, 0x000fe20000004100ULL, 0x0000006eff5c723eULL, 0x000fe200020006ffULL,
0x2000006bff6e7230ULL, 0x000fe20000004100ULL, 0x00000046ff46723eULL, 0x000fe200020006ffULL,
0x20000045ff6b7230ULL, 0x000fe20000004100ULL, 0x000000ff6f447812ULL, 0x000fe200078ec0ffULL,
0x2000005cff5c7230ULL, 0x000fe20000004100ULL, 0x000000ff71717812ULL, 0x000fe200078ec0ffULL,
0x20000046ff6f7230ULL, 0x000fe20000004100ULL, 0x00000008ff457819ULL, 0x000fc40000011684ULL,
0x00000054ff54723eULL, 0x000fe400020006ffULL, 0x0000005bff5b723eULL, 0x000fe400020006ffULL,
0x0000005aff5a723eULL, 0x000fe200020006ffULL, 0x20000054ff677230ULL, 0x000fe20000004100ULL,
0x000000ff49737812ULL, 0x000fe200078ec0ffULL, 0x2000005bff647230ULL, 0x000fe20000004100ULL,
0x00000018ff727819ULL, 0x000fe20000011649ULL, 0x2000005aff627230ULL, 0x000fe20000004100ULL,
0x00000018ff747819ULL, 0x000fc4000001164aULL, 0x00000044ff44723eULL, 0x000fe400020006ffULL,
0x00000071ff46723eULL, 0x000fe400020006ffULL, 0x00000045ff45723eULL, 0x000fe200020006ffULL,
0x20000044ff717230ULL, 0x000fe20000004100ULL, 0x00000008ff477819ULL, 0x000fe40000011685ULL,
0x00000073ff5b723eULL, 0x000fe200020006ffULL, 0x20000046ff737230ULL, 0x000fe20000004100ULL,
0x00000072ff5a723eULL, 0x000fe200020006ffULL, 0x20000045ff727230ULL, 0x000fe20000004100ULL,
0x00000074ff54723eULL, 0x000fe200020006ffULL, 0x2000005bff5b7230ULL, 0x000fe20000004100ULL,
0x00000047ff74723eULL, 0x000fe200020006ffULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x000000000044783bULL, 0x0002a20000000200ULL, 0x00000010ff767819ULL, 0x000fe20000011651ULL,
0x20000054ff547230ULL, 0x000fe20000004100ULL, 0x0000ffff51877812ULL, 0x000fe200078ec0ffULL,
0x20000074ff747230ULL, 0x000fe20000004100ULL, 0x000000ff525d7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff7a7819ULL, 0x100fe40000011653ULL, 0x00000018ff517819ULL, 0x100fe40000011652ULL,
0x0000ffff52887812ULL, 0x000fe400078ec0ffULL, 0x00000010ff797819ULL, 0x000fe40000011652ULL,
0x000000ff535e7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff527819ULL, 0x000fc40000011653ULL,
0x0000ffff53897812ULL, 0x000fe400078ec0ffULL, 0x0000005dff5d723eULL, 0x000fe400020006ffULL,
0x000000ff7a7a7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff7b7819ULL, 0x100fe20000011648ULL,
0x2000005dff5f7230ULL, 0x000fe20000004100ULL, 0x00000018ff537819ULL, 0x000fe40000011648ULL,
0x0000ffff488a7812ULL, 0x000fc400078ec0ffULL, 0x00000051ff51723eULL, 0x000fe400020006ffULL,
0x00000008ff007819ULL, 0x002fe40000011688ULL, 0x00000010ff487819ULL, 0x000fe2000001164aULL,
0x20000051ff5d7230ULL, 0x000fe20000004100ULL, 0x000000ff4a777812ULL, 0x040fe400078ec0ffULL,
0x0000ffff4a617812ULL, 0x000fe200078ec0ffULL, 0x20000042ff4a7230ULL, 0x000fe20000004100ULL,
0x0000007aff7a723eULL, 0x000fe200020006ffULL, 0x0000000944449231ULL, 0x084fe200003400ffULL,
0x00000010ff7e7819ULL, 0x000fe20000011649ULL, 0x0000000946469231ULL, 0x000fe200003400ffULL,
0x00000000ff00723eULL, 0x000fe200020006ffULL, 0x0000000845459231ULL, 0x080fe200003400ffULL,
0x0000ffff49497812ULL, 0x000fe200078ec0ffULL, 0x0000000847479231ULL, 0x000fe200003400ffULL,
0x0000007dff51723eULL, 0x000fc400020006ffULL, 0x000000ff7b7d7812ULL, 0x000fe200078ec0ffULL,
0x2000007aff7b7230ULL, 0x000fe20000004100ULL, 0x00000010ff4a7819ULL, 0x000fe2000001164aULL,
0x20000000ff7a7230ULL, 0x000fe20000004100ULL, 0x00000010ff4b7819ULL, 0x000fe2000001164bULL,
0x20000051ff517230ULL, 0x000fe20000004100ULL, 0x00000010ff6d7819ULL, 0x000fe4000001166dULL,
0x00000010ff6e7819ULL, 0x000fe4000001166eULL, 0x000000ff7e7e7812ULL, 0x000fc400078ec0ffULL,
0x00000008ff497819ULL, 0x000fe40000011649ULL, 0x00000055ff55723eULL, 0x000fe400020006ffULL,
0x00000059ff59723eULL, 0x000fe400020006ffULL, 0x0000005eff5e723eULL, 0x000fe200020006ffULL,
0x20000055ff697230ULL, 0x000fe20000004100ULL, 0x00000008ff007819ULL, 0x000fe2000001168aULL,
0x20000059ff6a7230ULL, 0x000fe20000004100ULL, 0x00000052ff52723eULL, 0x000fe200020006ffULL,
0x2000005eff607230ULL, 0x000fe20000004100ULL, 0x000010544b4a7816ULL, 0x000fc4000000004aULL,
0x000010546e4b7816ULL, 0x000fe2000000006dULL, 0x20000052ff5e7230ULL, 0x000fe20000004100ULL,
0x0000007eff7e723eULL, 0x000fe400020006ffULL, 0x00000049ff49723eULL, 0x000fe400020006ffULL,
0x00000000ff00723eULL, 0x000fe400020006ffULL, 0x000000ff48487812ULL, 0x000fe200078ec0ffULL,
0x20000049ff6e7230ULL, 0x000fe20000004100ULL, 0x0000007fff52723eULL, 0x000fe200020006ffULL,
0x2000007eff7f7230ULL, 0x000fe20000004100ULL, 0x00000010ff6d7819ULL, 0x000fe2000001166fULL,
0x20000000ff7e7230ULL, 0x000fe20000004100ULL, 0x00000048ff6f723eULL, 0x000fe200020006ffULL,
0x20000052ff527230ULL, 0x000fe20000004100ULL, 0x0000004a4448723cULL, 0x000be20000041830ULL,
0x00000010ff697819ULL, 0x000fc40000011669ULL, 0x00000010ff007819ULL, 0x000fe20000011671ULL,
0x2000006fff6f7230ULL, 0x000fe20000004100ULL, 0x00000053ff53723eULL, 0x000fe400020006ffULL,
0x00000010ff317819ULL, 0x020fe4000001166aULL, 0x00000010ff327819ULL, 0x000fe20000011673ULL,
0x20000053ff597230ULL, 0x000fe20000004100ULL, 0x0000105400307816ULL, 0x000fe40000000069ULL,
0x0000105432317816ULL, 0x000fc40000000031ULL, 0x00000077ff55723eULL, 0x000fe400020006ffULL,
0x000000ff76777812ULL, 0x000fe400078ec0ffULL, 0x00000056ff56723eULL, 0x000fe200020006ffULL,
0x000000304438723cULL, 0x000be20000041838ULL, 0x00000078ff53723eULL, 0x000fe200020006ffULL,
0x20000055ff557230ULL, 0x000fe20000004100ULL, 0x00000077ff77723eULL, 0x000fe200020006ffULL,
0x20000056ff687230ULL, 0x000fe20000004100ULL, 0x00000008ff787819ULL, 0x000fe20000011687ULL,
0x20000053ff537230ULL, 0x000fe20000004100ULL, 0x0000b80003307811ULL, 0x020fe200078e20ffULL,
0x20000077ff777230ULL, 0x000fe20000004100ULL, 0x0000007cff56723eULL, 0x000fc400020006ffULL,
0x00000078ff78723eULL, 0x000fe400020006ffULL, 0x000000ff75757812ULL, 0x000fe200078ec0ffULL,
0x000000003030783bULL, 0x000e620000000200ULL, 0x00000008ff767819ULL, 0x000fe20000011686ULL,
0x20000078ff787230ULL, 0x000fe20000004100ULL, 0x000000ff79797812ULL, 0x000fe200078ec0ffULL,
0x20000056ff567230ULL, 0x000fe20000004100ULL, 0x00000008ff7c7819ULL, 0x000fe40000011689ULL,
0x000000ff66667812ULL, 0x000fc400078ec0ffULL, 0x00000043ff43723eULL, 0x000fe400020006ffULL,
0x00000075ff75723eULL, 0x000fe400020006ffULL, 0x00000076ff76723eULL, 0x000fe200020006ffULL,
0x20000043ff707230ULL, 0x000fe20000004100ULL, 0x00000079ff79723eULL, 0x000fe200020006ffULL,
0x20000075ff757230ULL, 0x000fe20000004100ULL, 0x0000007cff7c723eULL, 0x000fe200020006ffULL,
0x20000076ff767230ULL, 0x000fe20000004100ULL, 0x00000008ff617819ULL, 0x000fe20000011661ULL,
0x20000079ff797230ULL, 0x000fe20000004100ULL, 0x00000010ff657819ULL, 0x000fe20000011665ULL,
0x2000007cff7c7230ULL, 0x000fe20000004100ULL, 0x00000010ff007819ULL, 0x000fc40000011677ULL,
0x00000066ff66723eULL, 0x000fe400020006ffULL, 0x00000061ff61723eULL, 0x000fe400020006ffULL,
0x0000105400657816ULL, 0x000fe20000000065ULL, 0x20000066ff697230ULL, 0x000fe20000004100ULL,
0x000000ff58587812ULL, 0x000fe200078ec0ffULL, 0x20000061ff667230ULL, 0x000fe20000004100ULL,
0x00000010ff007819ULL, 0x000fe40000011663ULL, 0x00000010ff777819ULL, 0x000fc40000011678ULL,
0x00000010ff037819ULL, 0x000fe40000011662ULL, 0x00000058ff62723eULL, 0x000fe200020006ffULL,
0x0000000930309231ULL, 0x082fe200003400ffULL, 0x0000105400777816ULL, 0x000fe20000000077ULL,
0x0000000932329231ULL, 0x000fe200003400ffULL, 0x00000010ff587819ULL, 0x000fe2000001167bULL,
0x0000000831319231ULL, 0x080fe200003400ffULL, 0x00000010ff6c7819ULL, 0x000fe2000001166cULL,
0x0000000833339231ULL, 0x000fe200003400ffULL, 0x00000010ff707819ULL, 0x000fe20000011670ULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x00000010ff6b7819ULL, 0x000fc4000001166bULL,
0x00000010ff677819ULL, 0x000fe40000011667ULL, 0x00000010ff687819ULL, 0x000fe40000011668ULL,
0x00000010ff727819ULL, 0x000fe40000011672ULL, 0x00000010ff737819ULL, 0x000fe40000011674ULL,
0x00000010ff647819ULL, 0x000fe40000011664ULL, 0x00000010ff757819ULL, 0x000fc40000011675ULL,
0x00000010ff767819ULL, 0x000fe40000011676ULL, 0x00000010ff5f7819ULL, 0x000fe4000001165fULL,
0x00000010ff617819ULL, 0x000fe40000011660ULL, 0x00000010ff007819ULL, 0x000fe40000011679ULL,
0x00000010ff5d7819ULL, 0x000fe4000001165dULL, 0x00000010ff5e7819ULL, 0x000fc4000001165eULL,
0x00000010ff7a7819ULL, 0x000fe4000001167aULL, 0x00000010ff7b7819ULL, 0x000fe4000001167cULL,
0x000010546c6c7816ULL, 0x000fe4000000006bULL, 0x00001054706d7816ULL, 0x000fe4000000006dULL,
0x0000105467727816ULL, 0x000fe40000000072ULL, 0x0000105468737816ULL, 0x000fc40000000073ULL,
0x0000105475647816ULL, 0x000fe20000000064ULL, 0x0000006c4434723cULL, 0x040fe20000041834ULL,
0x0000105403767816ULL, 0x000fe40000000076ULL, 0x0000105400607816ULL, 0x000fe4000000005fULL,
0x0000105458617816ULL, 0x000fe40000000061ULL, 0x000010545d7a7816ULL, 0x000fe2000000007aULL,
0x00000072443c723cULL, 0x000f62000004183cULL, 0x000010545e7b7816ULL, 0x000fc4000000007bULL,
0x00000008ff577819ULL, 0x000fe40000011657ULL, 0x000000ff0d0d7812ULL, 0x000fe400078ec0ffULL,
0x00000057ff57723eULL, 0x000fe200020006ffULL, 0x000000644424723cULL, 0x000fe20000041824ULL,
0x00000010ff5b7819ULL, 0x000fe4000001165bULL, 0x00000010ff007819ULL, 0x000fe2000001167fULL,
0x20000057ff577230ULL, 0x000fe20000004100ULL, 0x00000008ff067819ULL, 0x000fc40000011606ULL,
0x00000008ff417819ULL, 0x000fe20000011641ULL, 0x000000764420723cULL, 0x040f620000041820ULL,
0x00001054005d7816ULL, 0x000fe4000000005bULL, 0x00000006ff03723eULL, 0x000fe400020006ffULL,
0x00000041ff41723eULL, 0x000fe400020006ffULL, 0x00000010ff557819ULL, 0x000fe20000011655ULL,
0x00000060441c723cULL, 0x000f62000004181cULL, 0x00000010ff007819ULL, 0x000fe2000001166fULL,
0x20000041ff417230ULL, 0x000fe20000004100ULL, 0x00000010ff667819ULL, 0x000fc40000011666ULL,
0x00000010ff577819ULL, 0x000fe40000011657ULL, 0x000000ff2b2b7812ULL, 0x000fe200078ec0ffULL,
0x0000007a442c723cULL, 0x000b62000004182cULL, 0x00000010ff067819ULL, 0x000fe40000011669ULL,
0x000000ff04047812ULL, 0x000fe400078ec0ffULL, 0x00000008ff057819ULL, 0x000fe40000011605ULL,
0x0000000dff44723eULL, 0x020fe200020006ffULL, 0x20000003ff0d7230ULL, 0x000fe20000004100ULL,
0x00000010ff037819ULL, 0x000fc40000011654ULL, 0x00000010ff457819ULL, 0x000fe20000011656ULL,
0x20000044ff467230ULL, 0x000fe20000004100ULL, 0x0000105400447816ULL, 0x000fe40000000055ULL,
0x00000010ff007819ULL, 0x000fe40000011653ULL, 0x00000008ff027819ULL, 0x000fe40000011602ULL,
0x0000105403667816ULL, 0x000fe40000000066ULL, 0x0000105400677816ULL, 0x000fc40000000057ULL,
0x00000010ff007819ULL, 0x000fe4000001164fULL, 0x00000010ff417819ULL, 0x000fe40000011641ULL,
0x00000010ff507819ULL, 0x000fe20000011650ULL, 0x00000066303c723cULL, 0x000f62000004183cULL,
0x00000010ff037819ULL, 0x000fe4000001160dULL, 0x00000080ff43723eULL, 0x000fe400020006ffULL,
0x00000081ff42723eULL, 0x000fc400020006ffULL, 0x0000007dff7d723eULL, 0x000fe200020006ffULL,
0x20000043ff437230ULL, 0x000fe20000004100ULL, 0x0000002bff2b723eULL, 0x000fe200020006ffULL,
0x20000042ff427230ULL, 0x000fe20000004100ULL, 0x0000105406457816ULL, 0x000fe20000000045ULL,
0x2000007dff7d7230ULL, 0x000fe20000004100ULL, 0x00000004ff04723eULL, 0x000fe200020006ffULL,
0x2000002bff2b7230ULL, 0x000fe20000004100ULL, 0x00000005ff05723eULL, 0x000fe400020006ffULL,
0x00000002ff06723eULL, 0x000fe200020006ffULL, 0x20000004ff047230ULL, 0x000fe20000004100ULL,
0x0000105400027816ULL, 0x000fe20000000041ULL, 0x20000005ff057230ULL, 0x000fe20000004100ULL,
0x0000105450037816ULL, 0x000fe20000000003ULL, 0x20000006ff067230ULL, 0x000fe20000004100ULL,
0x00000010ff5c7819ULL, 0x000fe2000001165cULL, 0x000000443038723cULL, 0x000f620000041838ULL,
0x00000010ff7d7819ULL, 0x000fc4000001167dULL, 0x00000010ff597819ULL, 0x000fe40000011659ULL,
0x00000010ff7f7819ULL, 0x000fe4000001165aULL, 0x00000010ff7e7819ULL, 0x000fe2000001167eULL,
0x000000023020723cULL, 0x000b620000041820ULL, 0x00000010ff6e7819ULL, 0x000fe4000001166eULL,
0x00000010ff517819ULL, 0x000fe40000011651ULL, 0x00000010ff527819ULL, 0x000fc40000011652ULL,
0x00000010ff627819ULL, 0x000fe40000011662ULL, 0x00000010ff2b7819ULL, 0x000fe4000001162bULL,
0x00000010ff437819ULL, 0x000fe40000011643ULL, 0x00000010ff467819ULL, 0x000fe40000011646ULL,
0x00000010ff427819ULL, 0x000fe40000011642ULL, 0x00000010ff477819ULL, 0x000fc40000011604ULL,
0x00000010ff0e7819ULL, 0x000fe4000001160eULL, 0x00000010ff057819ULL, 0x000fe40000011605ULL,
0x00000010ff4e7819ULL, 0x000fe4000001164eULL, 0x00000010ff037819ULL, 0x020fe40000011606ULL,
0x000010547d5c7816ULL, 0x000fe4000000005cULL, 0x00001054597e7816ULL, 0x000fc4000000007eULL,
0x000010547f7f7816ULL, 0x000fe4000000006eULL, 0x0000105462627816ULL, 0x000fe20000000051ULL,
0x0000005c3048723cULL, 0x040b620000041848ULL, 0x000010542b637816ULL, 0x000fe40000000052ULL,
0x0000105446467816ULL, 0x000fe40000000043ULL, 0x0000105447477816ULL, 0x000fe40000000042ULL,
0x000010540e027816ULL, 0x000fe20000000005ULL, 0x0000007e3034723cULL, 0x000b620000041834ULL,
0x000010544e037816ULL, 0x000fce0000000003ULL, 0x000000623024723cULL, 0x040b700000041824ULL,
0x00000046301c723cULL, 0x040b70000004181cULL, 0x000000023030723cULL, 0x000b62000004182cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff2c7f8cULL, 0x020e62000c80043fULL,
0x000000ffff067224ULL, 0x000fce00078e00ffULL, 0x0000000000027805ULL, 0x000fc40000015200ULL,
0x0106bc00ff057984ULL, 0x000ea40000000800ULL, 0x8000000005ff7812ULL, 0x006fc4000780482dULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fcc0000015200ULL,
0x00000004020d7210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e03ULL,
0x003d09000d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011405ULL, 0x0000000d00007211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000200007819ULL, 0x000fc80000001205ULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000106067810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106bc00ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe4000780482dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000211037810ULL, 0x000fe40007ffe0ffULL,
0x000000e010107810ULL, 0x000fe40007ffe0ffULL, 0x000000160300720cULL, 0x000fc60003f06070ULL,
0x00006200130d7a24ULL, 0x000fd400078e0210ULL, 0x0000039000008947ULL, 0x000fea0003800000ULL,
0x0000000407417810ULL, 0x040fe20007ffe0ffULL, 0x0000000114027824ULL, 0x040fe200078e0207ULL,
0x00000002072f7810ULL, 0x000fe40007ffe0ffULL, 0x0000001015007217ULL, 0x000fe20007800000ULL,
0x00000001140e7824ULL, 0x040fe200078e0241ULL, 0x0000000607437810ULL, 0x000fe20007ffe0ffULL,
0x0000000114067824ULL, 0x000fe400078e022fULL, 0x000000010e2b7824ULL, 0x040fe400078e0217ULL,
0x000000100e2e7824ULL, 0x000fc400078e00ffULL, 0x0000000106057824ULL, 0x040fe400078e0217ULL,
0x00000010062c7824ULL, 0x000fe200078e00ffULL, 0xfffffff02e2e7812ULL, 0x000fe200078ee22bULL,
0x0000000100037824ULL, 0x000fe400078e0a10ULL, 0x0000000102047824ULL, 0x000fe200078e0217ULL,
0xfffffff02c2c7812ULL, 0x000fe200078ee205ULL, 0x00000010022d7824ULL, 0x000fe200078e00ffULL,
0x0000000314057217ULL, 0x000fe20007800000ULL, 0x00000100ff2b7424ULL, 0x000fc400078e00ffULL,
0x0000000102027824ULL, 0x000fe200078e020dULL, 0xfffffff02d107812ULL, 0x000fe200078ee204ULL,
0x0000000114007824ULL, 0x000fe200078e0243ULL, 0x000000f00f2d7812ULL, 0x000fe200078ec0ffULL,
0x0000000106047824ULL, 0x000fe400078e020dULL, 0x00005e0002027625ULL, 0x000fc800078e002bULL,
0x000000010e067824ULL, 0x100fe200078e020dULL, 0x0000002d020e7210ULL, 0x000fe20007f1e0ffULL,
0x00000001000d7824ULL, 0x040fe400078e020dULL, 0x00000001000f7824ULL, 0x040fe400078e0217ULL,
0x0000001000427824ULL, 0x000fe400078e00ffULL, 0x0000000105007824ULL, 0x000fe400078e0a14ULL,
0x00005e0004047625ULL, 0x000fe200078e002bULL, 0xfffffff042427812ULL, 0x000fc400078ee20fULL,
0x000000000700720cULL, 0x080fe20003f66070ULL, 0x000000ffff0f7224ULL, 0x000fe200000e0603ULL,
0x0000002d04047210ULL, 0x000fe20007f9e0ffULL, 0x00005e0006027625ULL, 0x080fe200078e002bULL,
0x000000002f00720cULL, 0x080fe40003f46070ULL, 0x000000004100720cULL, 0x080fe20003f06070ULL,
0x00005e000d067625ULL, 0x000fe200078e002bULL, 0x0000002d02027210ULL, 0x080fe40007fbe0ffULL,
0x0000c000100d7811ULL, 0x000fe200078e20ffULL, 0x000000ffff057224ULL, 0x000fe200020e0605ULL,
0x000000004300720cULL, 0x000fe20003f86070ULL, 0x000000ffff037224ULL, 0x000fe200028e0603ULL,
0x0000002d06067210ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e0d7faeULL, 0x0003e2000d901c46ULL, 0x0000c0002c2b7811ULL, 0x000fc400078e20ffULL,
0x0000c0002e2d7811ULL, 0x000fe200078e20ffULL, 0x000000ffff077224ULL, 0x000fe200030e0607ULL,
0x0000c000422f7811ULL, 0x000fe200078e20ffULL, 0x00000000042b7faeULL, 0x0003e8000d101c46ULL,
0x00000000022d7faeULL, 0x0003e8000c101c46ULL, 0x00000000062f7faeULL, 0x0003e2000e101c46ULL,
0x000002d000007947ULL, 0x000fea0003800000ULL, 0x0000000114007824ULL, 0x000fe200078e0207ULL,
0x000000f00f2b7812ULL, 0x000fc600078ec0ffULL, 0x0000000100027824ULL, 0x040fe200078e0217ULL,
0x0000000400067810ULL, 0x040fe20007ffe0ffULL, 0x0000001000077824ULL, 0x040fe200078e00ffULL,
0x0000000200047810ULL, 0x000fc60007ffe0ffULL, 0x0000000106057824ULL, 0x140fe200078e0217ULL,
0xfffffff007107812ULL, 0x000fe200078ee202ULL, 0x00000010060e7824ULL, 0x000fe400078e00ffULL,
0x00000100ff077424ULL, 0x000fe400078e00ffULL, 0x0000000104037824ULL, 0x000fe200078e0217ULL,
0xfffffff00e2d7812ULL, 0x000fe200078ee205ULL, 0x00000001000e7824ULL, 0x040fe200078e020dULL,
0x0000000600007810ULL, 0x000fe20007ffe0ffULL, 0x00000010042c7824ULL, 0x000fe200078e00ffULL,
0x0000c0002d2d7811ULL, 0x000fe200078e20ffULL, 0x00005e000e0e7625ULL, 0x000fc600078e0007ULL,
0xfffffff02c2c7812ULL, 0x000fe200078ee203ULL, 0x0000000104027824ULL, 0x100fe200078e020dULL,
0x0000002b0e0e7210ULL, 0x000fe20007f5e0ffULL, 0x0000000106047824ULL, 0x100fe400078e020dULL,
0x0000000100067824ULL, 0x000fe400078e020dULL, 0x00005e0002027625ULL, 0x000fc800078e0007ULL,
0x00005e0004047625ULL, 0x000fe200078e0007ULL, 0x0000002b02027210ULL, 0x000fc60007f1e0ffULL,
0x00000001000d7824ULL, 0x000fe400078e0217ULL, 0x00005e0006067625ULL, 0x000fc800078e0007ULL,
0x0000001000007824ULL, 0x000fe200078e00ffULL, 0x0000002b06067210ULL, 0x080fe20007f7e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200010e060fULL, 0x0000002b04047210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff037224ULL, 0x000fe200000e0603ULL, 0xfffffff000007812ULL, 0x000fe200078ee20dULL,
0x000000ffff077224ULL, 0x000fe200018e0607ULL, 0x0000c000100d7811ULL, 0x000fe200078e20ffULL,
0x000000ffff057224ULL, 0x000fe200010e0605ULL, 0x0000c0002c2b7811ULL, 0x000fe400078e20ffULL,
0x0000c000002f7811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e0d7faeULL, 0x0003e8000b901c46ULL, 0x00000000022b7faeULL, 0x0003e8000b901c46ULL,
0x00000000042d7faeULL, 0x0003e8000b901c46ULL, 0x00000000062f7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff027f8cULL, 0x002e64000c80043fULL, 0x000000ffff2b7224ULL, 0x002fc400078e0003ULL,
0x0000000000027805ULL, 0x000fca0000015200ULL, 0x0106b400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fc4000780484dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff067224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fcc0000015200ULL,
0x0000000402077210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e03ULL,
0x003d09000700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011405ULL, 0x0000000700007211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000200007819ULL, 0x000fc80000001205ULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000106067810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106b400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe4000780484dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000014000007945ULL, 0x000fe20003800000ULL,
0x0000012000001947ULL, 0x000fea0003800000ULL, 0x0000000aff00723eULL, 0x000fe400000010ffULL,
0x00000002ff037819ULL, 0x000fe40000011617ULL, 0x0000541000007816ULL, 0x000fe20000000000ULL,
0x000081227f007947ULL, 0x000fea000b800000ULL, 0x00001f0300097589ULL, 0x0002a400000e0000ULL,
0x0000000803557810ULL, 0x002fe20007ffe0ffULL, 0x000081527f007947ULL, 0x000fea000b800000ULL,
0x00001f5500087589ULL, 0x0002e400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001003557810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff527224ULL, 0x000fe200078e0000ULL,
0x000137a000427802ULL, 0x000fc40000000f00ULL, 0x000085e000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001803557810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff527224ULL, 0x004fe200078e0000ULL, 0x000137f000427802ULL, 0x000fc40000000f00ULL,
0x0000859000007944ULL, 0x008fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000000290c783bULL, 0x002e680000004200ULL,
0x000000001a04783bULL, 0x000f280000004200ULL, 0x000000002a2c783bULL, 0x0006a80000004200ULL,
0x000000001944783bULL, 0x0002a40000004200ULL, 0x00000010ff637819ULL, 0x002fc4000001160fULL,
0x000000ff0f2a7812ULL, 0x048fe400078ec0ffULL, 0x00000018ff1a7819ULL, 0x000fe4000001160fULL,
0x0000ffff0f787812ULL, 0x000fe400078ec0ffULL, 0x00000010ff4c7819ULL, 0x110fe40000011604ULL,
0x000000ff046f7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff6c7819ULL, 0x000fc40000011604ULL,
0x0000ffff040f7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff047819ULL, 0x000fe40000011605ULL,
0x00000010ff607819ULL, 0x100fe4000001160eULL, 0x000000ff0e297812ULL, 0x040fe400078ec0ffULL,
0x00000018ff197819ULL, 0x000fe4000001160eULL, 0x0000ffff0e777812ULL, 0x000fc400078ec0ffULL,
0x000000ff0c007812ULL, 0x000fe400078ec0ffULL, 0x00000010ff0e7819ULL, 0x000fe40000011605ULL,
0x000000ff05717812ULL, 0x040fe400078ec0ffULL, 0x0000ffff050b7812ULL, 0x000fe400078ec0ffULL,
0x0000002aff2a723eULL, 0x000fe400020006ffULL, 0x00000018ff057819ULL, 0x000fc40000011606ULL,
0x00000004ff04723eULL, 0x000fe200020006ffULL, 0x2000002aff657230ULL, 0x000fe20000004100ULL,
0x0000ffff0c757812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5b7819ULL, 0x100fe2000001160dULL,
0x20000004ff2a7230ULL, 0x000fe20000004100ULL, 0x000000ff0d427812ULL, 0x040fe400078ec0ffULL,
0x00000018ff417819ULL, 0x000fe4000001160dULL, 0x0000ffff0d767812ULL, 0x000fc400078ec0ffULL,
0x00000000ff0d723eULL, 0x000fe400020006ffULL, 0x00000018ff4e7819ULL, 0x004fe4000001162dULL,
0x00000005ff05723eULL, 0x000fe200020006ffULL, 0x2000000dff5a7230ULL, 0x000fe20000004100ULL,
0x00000010ff597819ULL, 0x100fe4000001160cULL, 0x00000018ff107819ULL, 0x000fe2000001160cULL,
0x20000005ff0d7230ULL, 0x000fe20000004100ULL, 0x00000010ff0c7819ULL, 0x000fc40000011606ULL,
0x000000ff06727812ULL, 0x040fe400078ec0ffULL, 0x0000ffff06037812ULL, 0x000fe400078ec0ffULL,
0x00000008ff047819ULL, 0x000fe40000011675ULL, 0x00000018ff067819ULL, 0x000fe40000011607ULL,
0x0000004eff4e723eULL, 0x000fe400020006ffULL, 0x00000018ff5c7819ULL, 0x000fc40000011644ULL,
0x0000001aff1a723eULL, 0x000fe200020006ffULL, 0x2000004eff567230ULL, 0x000fe20000004100ULL,
0x00000004ff04723eULL, 0x000fe400020006ffULL, 0x00000008ff057819ULL, 0x000fe20000011676ULL,
0x2000001aff587230ULL, 0x000fe20000004100ULL, 0x00000006ff06723eULL, 0x000fe400020006ffULL,
0x000000ff2e517812ULL, 0x000fe400078ec0ffULL, 0x00000018ff507819ULL, 0x000fe2000001162eULL,
0x20000006ff1a7230ULL, 0x000fe20000004100ULL, 0x0000005cff4e723eULL, 0x000fe200020006ffULL,
0x20000004ff5c7230ULL, 0x000fe20000004100ULL, 0x00000005ff05723eULL, 0x000fc400020006ffULL,
0x000000ff5b5b7812ULL, 0x000fe200078ec0ffULL, 0x2000004eff4e7230ULL, 0x000fe20000004100ULL,
0x000000ff60047812ULL, 0x000fe200078ec0ffULL, 0x20000005ff607230ULL, 0x000fe20000004100ULL,
0x00000051ff51723eULL, 0x000fe400020006ffULL, 0x00000008ff067819ULL, 0x000fe40000011677ULL,
0x00000050ff50723eULL, 0x000fe200020006ffULL, 0x20000051ff547230ULL, 0x000fe20000004100ULL,
0x000000ff2d4f7812ULL, 0x000fc400078ec0ffULL, 0x000000ff445f7812ULL, 0x000fe200078ec0ffULL,
0x20000050ff517230ULL, 0x000fe20000004100ULL, 0x00000010ff027819ULL, 0x000fe40000011607ULL,
0x000000ff07747812ULL, 0x040fe400078ec0ffULL, 0x0000ffff07007812ULL, 0x000fe400078ec0ffULL,
0x0000005bff5b723eULL, 0x000fe400020006ffULL, 0x00000004ff05723eULL, 0x000fc400020006ffULL,
0x000000ff45647812ULL, 0x000fe400078ec0ffULL, 0x00000006ff06723eULL, 0x000fe400020006ffULL,
0x0000b8001b047811ULL, 0x000fe200078e20ffULL, 0x20000005ff1b7230ULL, 0x000fe20000004100ULL,
0x00000008ff077819ULL, 0x000fe40000011678ULL, 0x00000010ff687819ULL, 0x000fe4000001162dULL,
0x0000ffff2d7a7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff6e7819ULL, 0x000fe40000011644ULL,
0x0000ffff447d7812ULL, 0x000fe400078ec0ffULL, 0x0000004fff2d723eULL, 0x000fe400020006ffULL,
0x0000005fff50723eULL, 0x000fe200020006ffULL, 0x2000005bff5f7230ULL, 0x000fe20000004100ULL,
0x00000018ff447819ULL, 0x000fe20000011645ULL, 0x2000002dff2d7230ULL, 0x000fe20000004100ULL,
0x00000064ff4f723eULL, 0x000fe200020006ffULL, 0x20000006ff647230ULL, 0x000fe20000004100ULL,
0x00000007ff5b723eULL, 0x000fe200020006ffULL, 0x20000050ff507230ULL, 0x000fe20000004100ULL,
0x000000000404783bULL, 0x000e620000000200ULL, 0x000000ff2c4d7812ULL, 0x000fe200078ec0ffULL,
0x2000004fff4f7230ULL, 0x000fe20000004100ULL, 0x00000044ff44723eULL, 0x000fc400020006ffULL,
0x000000ff63637812ULL, 0x000fe400078ec0ffULL, 0x00000018ff697819ULL, 0x000fe40000011647ULL,
0x00000010ff6a7819ULL, 0x000fe4000001162eULL, 0x0000ffff2e7b7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff2c797812ULL, 0x000fe400078ec0ffULL, 0x000000ff46667812ULL, 0x000fc400078ec0ffULL,
0x0000004dff2e723eULL, 0x000fe200020006ffULL, 0x20000044ff4d7230ULL, 0x000fe20000004100ULL,
0x00000063ff63723eULL, 0x000fe400020006ffULL, 0x00000010ff677819ULL, 0x100fe2000001162cULL,
0x2000002eff2e7230ULL, 0x000fe20000004100ULL, 0x00000018ff437819ULL, 0x000fe4000001162cULL,
0x00000010ff707819ULL, 0x000fe40000011645ULL, 0x0000ffff457e7812ULL, 0x000fc400078ec0ffULL,
0x00000069ff44723eULL, 0x000fe400020006ffULL, 0x00000010ff737819ULL, 0x100fe40000011646ULL,
0x00000018ff457819ULL, 0x000fe20000011646ULL, 0x20000044ff447230ULL, 0x000fe20000004100ULL,
0x0000ffff462c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff68697812ULL, 0x000fe400078ec0ffULL,
0x00000029ff29723eULL, 0x000fe200020006ffULL, 0x0000000904049231ULL, 0x082fe200003400ffULL,
0x00000066ff46723eULL, 0x000fe200020006ffULL, 0x20000063ff667230ULL, 0x000fe20000004100ULL,
0x00000008ff687819ULL, 0x000fe20000011679ULL, 0x20000029ff627230ULL, 0x000fe20000004100ULL,
0x000000ff67637812ULL, 0x000fe200078ec0ffULL, 0x2000005bff677230ULL, 0x000fe20000004100ULL,
0x00000069ff69723eULL, 0x000fe200020006ffULL, 0x0000000906069231ULL, 0x000fe200003400ffULL,
0x00000068ff5b723eULL, 0x000fe200020006ffULL, 0x0000000805059231ULL, 0x080fe200003400ffULL,
0x00000010ff6d7819ULL, 0x000fe2000001162fULL, 0x0000000807079231ULL, 0x000fe200003400ffULL,
0x0000006cff29723eULL, 0x000fe200020006ffULL, 0x20000046ff467230ULL, 0x000fe20000004100ULL,
0x000000ff6a6c7812ULL, 0x000fe200078ec0ffULL, 0x20000069ff6a7230ULL, 0x000fe20000004100ULL,
0x00000063ff63723eULL, 0x000fe200020006ffULL, 0x2000005bff697230ULL, 0x000fe20000004100ULL,
0x000000ff6d6d7812ULL, 0x000fe200078ec0ffULL, 0x20000029ff297230ULL, 0x000fe20000004100ULL,
0x0000ffff2f7c7812ULL, 0x000fe200078ec0ffULL, 0x20000063ff687230ULL, 0x000fe20000004100ULL,
0x00000042ff42723eULL, 0x000fc400020006ffULL, 0x00000008ff5b7819ULL, 0x000fe4000001167bULL,
0x000000ff59597812ULL, 0x000fe200078ec0ffULL, 0x20000042ff5e7230ULL, 0x000fe20000004100ULL,
0x0000006dff6d723eULL, 0x000fe400020006ffULL, 0x00000041ff41723eULL, 0x000fe400020006ffULL,
0x0000005bff5b723eULL, 0x000fe400020006ffULL, 0x00000008ff637819ULL, 0x000fe2000001167cULL,
0x20000041ff617230ULL, 0x000fe20000004100ULL, 0x0000006fff42723eULL, 0x000fc400020006ffULL,
0x00000059ff59723eULL, 0x000fe400020006ffULL, 0x000000ff6e6f7812ULL, 0x000fe200078ec0ffULL,
0x2000006dff6e7230ULL, 0x000fe20000004100ULL, 0x00000063ff63723eULL, 0x000fe200020006ffULL,
0x2000005bff6d7230ULL, 0x000fe20000004100ULL, 0x00000071ff41723eULL, 0x000fe200020006ffULL,
0x20000059ff597230ULL, 0x000fe20000004100ULL, 0x00000008ff5b7819ULL, 0x000fe2000001167dULL,
0x20000042ff427230ULL, 0x000fe20000004100ULL, 0x000000ff70717812ULL, 0x000fe200078ec0ffULL,
0x20000041ff417230ULL, 0x000fe20000004100ULL, 0x0000006fff70723eULL, 0x000fe200020006ffULL,
0x20000063ff6f7230ULL, 0x000fe20000004100ULL, 0x000000ff2f537812ULL, 0x000fc400078ec0ffULL,
0x00000018ff527819ULL, 0x000fe2000001162fULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x000000ff476b7812ULL, 0x000fe400078ec0ffULL, 0x0000005bff63723eULL, 0x000fe400020006ffULL,
0x00000010ff2f7819ULL, 0x000fe40000011647ULL, 0x00000010ff5b7819ULL, 0x000fe4000001165eULL,
0x00000043ff43723eULL, 0x000fc400020006ffULL, 0x00000010ff5a7819ULL, 0x000fe4000001165aULL,
0x00000010ff597819ULL, 0x000fe20000011659ULL, 0x20000043ff557230ULL, 0x000fe20000004100ULL,
0x00000010ff5e7819ULL, 0x000fe2000001165fULL, 0x20000063ff5f7230ULL, 0x000fe20000004100ULL,
0x0000006bff6b723eULL, 0x000fe400020006ffULL, 0x00000010ff627819ULL, 0x000fe40000011662ULL,
0x00000010ff1b7819ULL, 0x000fc4000001161bULL, 0x000000ff2f2f7812ULL, 0x000fe400078ec0ffULL,
0x00001054595a7816ULL, 0x000fe4000000005aULL, 0x000010545e5b7816ULL, 0x000fe4000000005bULL,
0x00000010ff637819ULL, 0x000fe40000011665ULL, 0x00000045ff43723eULL, 0x000fe200020006ffULL,
0x2000006bff457230ULL, 0x000fe20000004100ULL, 0x000010541b627816ULL, 0x000fe20000000062ULL,
0x0000005a0448723cULL, 0x000b620000041848ULL, 0x00000010ff587819ULL, 0x000fe20000011658ULL,
0x20000043ff437230ULL, 0x000fe20000004100ULL, 0x00000010ff657819ULL, 0x000fc40000011667ULL,
0x00000019ff19723eULL, 0x000fe400020006ffULL, 0x0000006cff6c723eULL, 0x000fe400020006ffULL,
0x0000002fff2f723eULL, 0x000fe200020006ffULL, 0x20000019ff577230ULL, 0x000fe20000004100ULL,
0x00000010ff2e7819ULL, 0x000fe2000001162eULL, 0x2000006cff6c7230ULL, 0x000fe20000004100ULL,
0x00000010ff1b7819ULL, 0x000fe20000011668ULL, 0x2000002fff5b7230ULL, 0x020fe20000004100ULL,
0x00000008ff6b7819ULL, 0x000fc4000001167aULL, 0x00000008ff2c7819ULL, 0x000fe4000001162cULL,
0x0000105458657816ULL, 0x000fe40000000065ULL, 0x00000010ff10723eULL, 0x000fe400020006ffULL,
0x000010541b587816ULL, 0x000fe4000000002eULL, 0x00000053ff53723eULL, 0x000fe200020006ffULL,
0x20000010ff5d7230ULL, 0x000fe20000004100ULL, 0x0000006bff6b723eULL, 0x000fc400020006ffULL,
0x000000ff4c1b7812ULL, 0x000fe200078ec0ffULL, 0x20000053ff537230ULL, 0x000fe20000004100ULL,
0x00000052ff52723eULL, 0x000fe200020006ffULL, 0x2000006bff6b7230ULL, 0x000fe20000004100ULL,
0x0000002cff2f723eULL, 0x000fe400020006ffULL, 0x00000010ff2d7819ULL, 0x000fe2000001162dULL,
0x20000052ff527230ULL, 0x000fe20000004100ULL, 0x00000010ff6a7819ULL, 0x000fe2000001166aULL,
0x2000002fff5a7230ULL, 0x000fe20000004100ULL, 0x0000b800282c7811ULL, 0x000fc400078e20ffULL,
0x00000010ff287819ULL, 0x000fe40000011655ULL, 0x0000001bff55723eULL, 0x000fe400020006ffULL,
0x00000010ff577819ULL, 0x000fe40000011657ULL, 0x00000010ff647819ULL, 0x000fe40000011664ULL,
0x000010546a597816ULL, 0x000fe4000000002dULL, 0x00000010ff697819ULL, 0x000fe20000011669ULL,
0x000000002c2c783bULL, 0x000e620000000200ULL, 0x00000010ff547819ULL, 0x000fc40000011654ULL,
0x00000010ff1b7819ULL, 0x000fe2000001166cULL, 0x000000580424723cULL, 0x000b620000041824ULL,
0x00000010ff4c7819ULL, 0x000fe40000011656ULL, 0x00000072ff19723eULL, 0x000fe400020006ffULL,
0x00000071ff71723eULL, 0x000fe400020006ffULL, 0x00000010ff5d7819ULL, 0x000fe2000001165dULL,
0x20000055ff587230ULL, 0x020fe20000004100ULL, 0x00000010ff5c7819ULL, 0x000fe2000001165cULL,
0x20000071ff717230ULL, 0x000fe20000004100ULL, 0x0000105457647816ULL, 0x000fe20000000064ULL,
0x20000019ff197230ULL, 0x000fe20000004100ULL, 0x0000105428567816ULL, 0x000fc40000000069ULL,
0x000010541b547816ULL, 0x000fe40000000054ULL, 0x00000008ff727819ULL, 0x000fe2000001167eULL,
0x00000064043c723cULL, 0x000fe2000004183cULL, 0x00000010ff617819ULL, 0x000fe40000011661ULL,
0x00000010ff607819ULL, 0x000fe40000011660ULL, 0x00000010ff667819ULL, 0x000fe40000011666ULL,
0x00000010ff577819ULL, 0x000fc4000001166bULL, 0x00000010ff537819ULL, 0x000fe40000011653ULL,
0x00000010ff6e7819ULL, 0x000fe4000001166eULL, 0x000000ff0e287812ULL, 0x000fe400078ec0ffULL,
0x00000008ff1b7819ULL, 0x000fe4000001160fULL, 0x00000010ff0e7819ULL, 0x000fe20000011651ULL,
0x000000092c2c9231ULL, 0x082fe200003400ffULL, 0x00000010ff527819ULL, 0x000fe20000011652ULL,
0x000000092e2e9231ULL, 0x000fe200003400ffULL, 0x00000010ff6d7819ULL, 0x000fe2000001166dULL,
0x000000082d2d9231ULL, 0x080fe200003400ffULL, 0x00000010ff0f7819ULL, 0x000fe2000001166fULL,
0x000000082f2f9231ULL, 0x000fe200003400ffULL, 0x0000ffff47477812ULL, 0x000fc400078ec0ffULL,
0x000010545d5c7816ULL, 0x000fe4000000005cULL, 0x00000072ff72723eULL, 0x000fe400020006ffULL,
0x00001054615d7816ULL, 0x000fe40000000060ULL, 0x0000105466637816ULL, 0x000fe20000000063ULL,
0x20000072ff727230ULL, 0x000fe20000004100ULL, 0x000010544c577816ULL, 0x000fe40000000057ULL,
0x000010546e557816ULL, 0x000fe20000000053ULL, 0x0000005c0434723cULL, 0x000f620000041834ULL,
0x000010540e0e7816ULL, 0x000fc4000000006dULL, 0x00001054520f7816ULL, 0x000fe4000000000fULL,
0x00000008ff477819ULL, 0x000fe40000011647ULL, 0x00000028ff51723eULL, 0x000fe200020006ffULL,
0x000000620438723cULL, 0x000f620000041838ULL, 0x00000010ff4f7819ULL, 0x000fe4000001164fULL,
0x00000010ff287819ULL, 0x000fe20000011671ULL, 0x20000051ff537230ULL, 0x000fe20000004100ULL,
0x00000047ff47723eULL, 0x000fc400020006ffULL, 0x0000105428517816ULL, 0x000fe2000000004fULL,
0x000000560420723cULL, 0x040f620000041820ULL, 0x00000010ff4f7819ULL, 0x000fe20000011672ULL,
0x20000047ff4c7230ULL, 0x000fe20000004100ULL, 0x000000ff02027812ULL, 0x000fe400078ec0ffULL,
0x0000001bff47723eULL, 0x000fe400020006ffULL, 0x00000010ff457819ULL, 0x000fe20000011645ULL,
0x00000054041c723cULL, 0x000f62000004181cULL, 0x00000010ff437819ULL, 0x000fe20000011643ULL,
0x20000047ff527230ULL, 0x000fe20000004100ULL, 0x00000010ff5a7819ULL, 0x000fc4000001165aULL,
0x000000ff73737812ULL, 0x000fe400078ec0ffULL, 0x00000008ff0b7819ULL, 0x000fe2000001160bULL,
0x0000000e0404723cULL, 0x000b620000041830ULL, 0x00000008ff037819ULL, 0x000fe40000011603ULL,
0x00000010ff417819ULL, 0x000fe40000011641ULL, 0x00000008ff007819ULL, 0x000fe40000011600ULL,
0x000000ff0c0e7812ULL, 0x020fc400078ec0ffULL, 0x00000010ff0c7819ULL, 0x000fe4000001164dULL,
0x00000002ff0f723eULL, 0x000fe400020006ffULL, 0x000010540c4f7816ULL, 0x000fe4000000004fULL,
0x00000010ff0c7819ULL, 0x000fe4000001165bULL, 0x00000010ff027819ULL, 0x000fe40000011653ULL,
0x000010540c477816ULL, 0x000fc40000000045ULL, 0x00001054435a7816ULL, 0x000fe4000000005aULL,
0x00000074ff10723eULL, 0x000fe400020006ffULL, 0x00000073ff73723eULL, 0x000fe400020006ffULL,
0x00000010ff507819ULL, 0x000fe20000011650ULL, 0x20000010ff107230ULL, 0x000fe20000004100ULL,
0x00000010ff1b7819ULL, 0x000fe20000011670ULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x0000000bff0b723eULL, 0x000fc400020006ffULL, 0x0000000eff0e723eULL, 0x000fe400020006ffULL,
0x00000003ff0c723eULL, 0x000fe200020006ffULL, 0x2000000bff0b7230ULL, 0x000fe20000004100ULL,
0x0000105402437816ULL, 0x000fe20000000041ULL, 0x2000000eff0e7230ULL, 0x000fe20000004100ULL,
0x00000000ff02723eULL, 0x000fe200020006ffULL, 0x2000000cff0c7230ULL, 0x000fe20000004100ULL,
0x000010541b507816ULL, 0x000fe20000000050ULL, 0x2000000fff1b7230ULL, 0x000fe20000004100ULL,
0x00000010ff427819ULL, 0x000fe20000011642ULL, 0x20000002ff027230ULL, 0x000fe20000004100ULL,
0x00000010ff037819ULL, 0x000fc40000011658ULL, 0x00000010ff4e7819ULL, 0x000fe2000001164eULL,
0x000000502c30723cULL, 0x000b620000041848ULL, 0x00000010ff5f7819ULL, 0x000fe4000001165fULL,
0x00000010ff467819ULL, 0x000fe40000011646ULL, 0x00000010ff737819ULL, 0x000fe40000011673ULL,
0x00000010ff5b7819ULL, 0x000fe40000011644ULL, 0x00000010ff4c7819ULL, 0x000fc4000001164cULL,
0x0000105403427816ULL, 0x000fe40000000042ULL, 0x00000010ff297819ULL, 0x000fe40000011629ULL,
0x00000010ff527819ULL, 0x000fe40000011652ULL, 0x00000010ff2a7819ULL, 0x000fe2000001162aULL,
0x000000422c24723cULL, 0x000b620000041824ULL, 0x00000010ff0b7819ULL, 0x000fe4000001160bULL,
0x00000010ff197819ULL, 0x000fc40000011619ULL, 0x00000010ff0e7819ULL, 0x000fe4000001160eULL,
0x00000010ff0f7819ULL, 0x000fe40000011610ULL, 0x00000010ff007819ULL, 0x000fe4000001161bULL,
0x00000010ff0d7819ULL, 0x000fe4000001160dULL, 0x00000010ff0c7819ULL, 0x000fe4000001160cULL,
0x00000010ff037819ULL, 0x000fc4000001161aULL, 0x00000010ff027819ULL, 0x000fe40000011602ULL,
0x000010544e4e7816ULL, 0x000fe4000000005fULL, 0x0000105473467816ULL, 0x000fe40000000046ULL,
0x000010545b5b7816ULL, 0x000fe4000000004cULL, 0x0000105429527816ULL, 0x000fe20000000052ULL,
0x0000004e2c34723cULL, 0x000b620000041834ULL, 0x000010542a537816ULL, 0x000fc4000000000bULL,
0x000010540e0e7816ULL, 0x000fe40000000019ULL, 0x00001054000f7816ULL, 0x000fe4000000000fULL,
0x000010540d0c7816ULL, 0x000fe2000000000cULL, 0x000000462c38723cULL, 0x000b620000041838ULL,
0x00001054030d7816ULL, 0x000fce0000000002ULL, 0x0000005a2c3c723cULL, 0x040b70000004183cULL,
0x000000522c20723cULL, 0x040b700000041820ULL, 0x0000000e2c1c723cULL, 0x040b70000004181cULL,
0x0000000c2c2c723cULL, 0x000b620000041804ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff027f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a000ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff467224ULL, 0x022fc600078e0003ULL, 0x0000000111117810ULL, 0x000fc80007ffe0ffULL,
0x000000161100720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xfffec05000007947ULL, 0x000fea000383ffffULL, 0x000000ff1600720cULL, 0x000fda0003f05270ULL,
0x0000036000008947ULL, 0x000fea0003800000ULL, 0x0180000012007810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x00014fc000047802ULL, 0x000fc40000000f00ULL, 0x00006c0000007944ULL, 0x006fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000001200037308ULL, 0x002e640000001000ULL,
0xbf80000003007423ULL, 0x002fc80000000012ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fc40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006700ff037624ULL, 0x000fe400078e00ffULL, 0x00006600ff027624ULL, 0x000fca00078e00ffULL,
0x0000000602037981ULL, 0x000f28000c1e9900ULL, 0x0000000000057919ULL, 0x000e640000000000ULL,
0x00000002ff077819ULL, 0x002fe40000011605ULL, 0x0000000805057811ULL, 0x000fe200078ff0ffULL,
0x0000000003007220ULL, 0x01cfca0000410000ULL, 0x00001f0700047589ULL, 0x000e6800000e0000ULL,
0x00001f0500057589ULL, 0x000ea200000e0000ULL, 0x0000003004307220ULL, 0x042fe20000410000ULL,
0x0000003104317220ULL, 0x040fe20000410000ULL, 0x0000003404347220ULL, 0x040fe20000410000ULL,
0x0000003504357220ULL, 0x040fe20000410000ULL, 0x0000003804387220ULL, 0x040fe20000410000ULL,
0x0000003904397220ULL, 0x040fe20000410000ULL, 0x0000003c043c7220ULL, 0x040fe20000410000ULL,
0x0000003d043d7220ULL, 0x040fe20000410000ULL, 0x0000002404247220ULL, 0x040fe20000410000ULL,
0x0000002504257220ULL, 0x040fe20000410000ULL, 0x0000002004207220ULL, 0x040fe20000410000ULL,
0x0000002104217220ULL, 0x040fe20000410000ULL, 0x0000001c041c7220ULL, 0x040fe20000410000ULL,
0x0000001d041d7220ULL, 0x040fe20000410000ULL, 0x0000002c042c7220ULL, 0x040fe20000410000ULL,
0x0000002d042d7220ULL, 0x000fe20000410000ULL, 0x0000003205327220ULL, 0x044fe20000410000ULL,
0x0000003305337220ULL, 0x040fe20000410000ULL, 0x0000003605367220ULL, 0x040fe20000410000ULL,
0x0000003705377220ULL, 0x040fe20000410000ULL, 0x0000003a053a7220ULL, 0x040fe20000410000ULL,
0x0000003b053b7220ULL, 0x040fe20000410000ULL, 0x0000003e053e7220ULL, 0x040fe20000410000ULL,
0x0000003f053f7220ULL, 0x040fe20000410000ULL, 0x0000002605267220ULL, 0x040fe20000410000ULL,
0x0000002705277220ULL, 0x040fe20000410000ULL, 0x0000002205227220ULL, 0x040fe20000410000ULL,
0x0000002305237220ULL, 0x040fe20000410000ULL, 0x0000001e051e7220ULL, 0x040fe20000410000ULL,
0x0000001f051f7220ULL, 0x040fe20000410000ULL, 0x0000002e052e7220ULL, 0x040fe20000410000ULL,
0x0000002f052f7220ULL, 0x000fc20000410000ULL, 0x0000000000127919ULL, 0x000ee20000000000ULL,
0x0000a00018187811ULL, 0x000fe200078e58ffULL, 0x00000000000579c3ULL, 0x000f220000002700ULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x00000002ff037819ULL, 0x00afc40000011612ULL,
0x0000000212007812ULL, 0x040fe200078ec0ffULL, 0x00000005040472a4ULL, 0x010fe2000f8e023fULL,
0x0000000812077811ULL, 0x000fe200078ff0ffULL, 0x00000008030d7824ULL, 0x040fe200078e00ffULL,
0x0000000300027211ULL, 0x040fe200078ff8ffULL, 0x0000000803097824ULL, 0x000fe200078e00ffULL,
0x0000000700057211ULL, 0x000fe200078ff8ffULL, 0x0000000807067824ULL, 0x000fe200078e00ffULL,
0x0000000402047810ULL, 0x040fe20007ffe0ffULL, 0x00000008030b7824ULL, 0x040fe200078e00ffULL,
0x0000000202007810ULL, 0x000fe20007ffe0ffULL, 0x00000008030f7824ULL, 0x000fe200078e00ffULL,
0xfffffff80d077812ULL, 0x000fe200078ee204ULL, 0x0000000812047824ULL, 0x000fe200078e00ffULL,
0xfffffff809037812ULL, 0x000fc400078ee202ULL, 0x0000000602027810ULL, 0x000fe40007ffe0ffULL,
0xfffffff806097812ULL, 0x000fe200078ee205ULL, 0x0000001003037824ULL, 0x000fe200078e0218ULL,
0x0000002012107810ULL, 0x000fe40007ffe0ffULL, 0xfffffff80b057812ULL, 0x000fe200078ee200ULL,
0x00000010090d7824ULL, 0x000fe200078e0218ULL, 0xfffffff80f0b7812ULL, 0x000fe200078ee202ULL,
0x0000001007097824ULL, 0x100fe200078e0218ULL, 0x0000000804047812ULL, 0x000fe200078ec0ffULL,
0x0000001005057824ULL, 0x100fe200078e0218ULL, 0x000000303100723eULL, 0x000fe200000010ffULL,
0x000000100b0b7824ULL, 0x000fe200078e0218ULL, 0x000000343502723eULL, 0x000fe200000010ffULL,
0x0000000103037824ULL, 0x000fe200078e0204ULL, 0x00000003ff087819ULL, 0x000fe20000011612ULL,
0x0000000104077824ULL, 0x040fe200078e0205ULL, 0x00000003ff117819ULL, 0x000fe20000011610ULL,
0x00000001040d7824ULL, 0x000fe200078e020dULL, 0x00005410000e7816ULL, 0x100fe20000000002ULL,
0x0000000104097824ULL, 0x000fe200078e0209ULL, 0x00007632000f7816ULL, 0x000fe20000000002ULL,
0x0000000108007824ULL, 0x000fe200078e0212ULL, 0x0000003e3f06723eULL, 0x000fe200000010ffULL,
0x0000000110027824ULL, 0x000fc400078e0211ULL, 0x0000000e03007388ULL, 0x0003e20000000a00ULL,
0x00000001040b7824ULL, 0x000fe200078e020bULL, 0x000000202104723eULL, 0x000fe400000010ffULL,
0x0000000700037812ULL, 0x002fe400078ec0ffULL, 0x00000007020f7812ULL, 0x000fe400078ec0ffULL,
0x0ffffff803057812ULL, 0x000fe400078ef812ULL, 0x0ffffff80f0f7812ULL, 0x000fc400078ef810ULL,
0x000000383900723eULL, 0x000fe200000010ffULL, 0x00000010050a7824ULL, 0x100fe200078e0218ULL,
0x0000003c3d02723eULL, 0x000fe200000010ffULL, 0x000000100f187824ULL, 0x000fe200078e0218ULL,
0x000000242503723eULL, 0x000fe400000010ffULL, 0x00005410000e7816ULL, 0x140fe40000000002ULL,
0x00007632000f7816ULL, 0x000fe40000000002ULL, 0x0000001c1d00723eULL, 0x000fc400000010ffULL,
0x0000002c2d02723eULL, 0x000fe200000010ffULL, 0x0000000e07007388ULL, 0x0003e20000000a00ULL,
0x0000003a3b05723eULL, 0x000fc800000010ffULL, 0x00005410050c7816ULL, 0x000fe40000000006ULL,
0x00005410030e7816ULL, 0x142fe40000000004ULL, 0x00007632030f7816ULL, 0x000fe40000000004ULL,
0x000000323303723eULL, 0x000fe400000010ffULL, 0x000000363704723eULL, 0x000fe200000010ffULL,
0x0000000e09007388ULL, 0x0003e40000000a00ULL, 0x00005410000e7816ULL, 0x002fc40000000002ULL,
0x00007632000f7816ULL, 0x000fe40000000002ULL, 0x000000262700723eULL, 0x000fe400000010ffULL,
0x000000222302723eULL, 0x000fe200000010ffULL, 0x0000000e0b007388ULL, 0x0003e40000000a00ULL,
0x00005410030e7816ULL, 0x142fe40000000004ULL, 0x00007632030f7816ULL, 0x000fe40000000004ULL,
0x0000001e1f03723eULL, 0x000fc400000010ffULL, 0x0000002e2f04723eULL, 0x000fe200000010ffULL,
0x0000000e0d007388ULL, 0x0003e40000000a00ULL, 0x00007632050d7816ULL, 0x002fe40000000006ULL,
0x0000000000057919ULL, 0x000e620000002600ULL, 0x0000541000067816ULL, 0x000fc60000000002ULL,
0x0004000c07007388ULL, 0x0007e40000000a00ULL, 0x0000763200077816ULL, 0x008fe40000000002ULL,
0x0000541003027816ULL, 0x140fe40000000004ULL, 0x0000763203037816ULL, 0x000fe20000000004ULL,
0x0004000609007388ULL, 0x0007e20000000a00ULL, 0x0000000805137824ULL, 0x002fc600078e00ffULL,
0x000400020b007388ULL, 0x0003e20000000a00ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000000000a0c7984ULL, 0x000f220000000c00ULL, 0x0000000805007824ULL, 0x000fe200078e00ffULL,
0xfffffff813087812ULL, 0x000fe400078ee208ULL, 0x0000000018187984ULL, 0x000ea20000000c00ULL,
0x0000000712077812ULL, 0x008fe400078ec0ffULL, 0xfffffff800117812ULL, 0x000fe400078ee211ULL,
0x0000000408087c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000411117c10ULL, 0x000fc4000ff3e0ffULL,
0x0000000710097812ULL, 0x000fe200078ec0ffULL, 0x000000ffff037224ULL, 0x002fe200000e06ffULL,
0x00005a0008027a11ULL, 0x040fe200078048ffULL, 0x000000ffff007224ULL, 0x000fe200008e06ffULL,
0x00005a0011047a11ULL, 0x000fe400078248ffULL, 0x00005b0008037a11ULL, 0x000fe400000f4c03ULL,
0x1ffffff807077812ULL, 0x000fe400078ef814ULL, 0x00005b0011057a11ULL, 0x000fc400008f4c00ULL,
0x1ffffff809097812ULL, 0x000fe200078ef814ULL, 0x0000001007027825ULL, 0x000fc800078e0002ULL,
0x0000001009047825ULL, 0x000fe200078e0004ULL, 0x0000000c02007986ULL, 0x010fe8000c101d06ULL,
0x0000001804007986ULL, 0x004fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00006600ff027624ULL, 0x000fe400078e00ffULL, 0x00006700ff037624ULL, 0x000fca00078e00ffULL,
0x0000000602227981ULL, 0x000322000c1e9900ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000001ff0000780cULL, 0x000fe20003f04070ULL, 0x0000000210037824ULL, 0x002fe200078e00ffULL,
0x01060000ff047f8cULL, 0x000e62000c80043fULL, 0x0000004018027824ULL, 0x000fe400078e00ffULL,
0x0000580003007a24ULL, 0x000fc800078e0212ULL, 0x0000620000147a24ULL, 0x000fc800078e0202ULL,
0x000005a000000947ULL, 0x000fea0003800000ULL, 0x00000002ff1f7819ULL, 0x000fe20000011617ULL,
0x00000100ff237424ULL, 0x000fe200078e00ffULL, 0x000000300c217812ULL, 0x000fe400078ec0ffULL,
0x000000081f137810ULL, 0x040fe20007ffe0ffULL, 0x0000000114067824ULL, 0x000fe200078e021fULL,
0x000000101f207810ULL, 0x040fe40007ffe0ffULL, 0x000000181f247810ULL, 0x040fe20007ffe0ffULL,
0x00005e0006067625ULL, 0x000fe200078e0023ULL, 0x000000201f197810ULL, 0x000fc40007ffe0ffULL,
0x0000001717127211ULL, 0x000fe200078fe8ffULL, 0x0000000114087824ULL, 0x000fe200078e0213ULL,
0x00000021060a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000114037824ULL, 0x000fe200078e0220ULL,
0x000000281f1d7810ULL, 0x040fe20007ffe0ffULL, 0x00005e0008087625ULL, 0x000fe200078e0023ULL,
0x00002000181c7811ULL, 0x000fe400078e68ffULL, 0x000000301f1e7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e0607ULL, 0x00000021080c7210ULL, 0x000fe20007f3e0ffULL,
0x00005e0003067625ULL, 0x000fe200078e0023ULL, 0x0000000215037217ULL, 0x000fc60007800000ULL,
0x0000000114087824ULL, 0x000fe200078e0224ULL, 0x00000021060e7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff0d7224ULL, 0x000fe400008e0609ULL, 0x00005e0008087625ULL, 0x000fc800078e0023ULL,
0x0000000114067824ULL, 0x000fe200078e0219ULL, 0x0000002108107210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200000e0607ULL, 0x0000000312087812ULL, 0x000fe200078ec0ffULL,
0x00005e0006067625ULL, 0x000fc600078e0023ULL, 0x0ffffffc08177812ULL, 0x000fe200078ef817ULL,
0x0000000103037824ULL, 0x000fe200078e0a02ULL, 0x0000002106127210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff117224ULL, 0x000fe400008e0609ULL, 0x0000000413097824ULL, 0x000fe200078e00ffULL,
0x000000031f00720cULL, 0x080fe20003f06070ULL, 0x0000000114067824ULL, 0x000fe200078e021dULL,
0x000000031300720cULL, 0x000fe20003f26070ULL, 0x000000ffff137224ULL, 0x000fe200010e0607ULL,
0xfffffffc09097812ULL, 0x000fe200078ee208ULL, 0x00005e0006067625ULL, 0x000fe200078e0023ULL,
0x000000381f1f7810ULL, 0x000fc40007ffe0ffULL, 0x000000032000720cULL, 0x000fe20003fa6070ULL,
0x0000001017177824ULL, 0x100fe200078e021cULL, 0x00000021061a7210ULL, 0x000fe20007fde0ffULL,
0x0000001009097824ULL, 0x000fe200078e021cULL, 0x000000032400720cULL, 0x080fe20003f86070ULL,
0x0000000114067824ULL, 0x000fe200078e021eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a177faeULL, 0x0005e2000c101c46ULL, 0x000000031900720cULL, 0x080fe20003f66070ULL,
0x000000ffff1b7224ULL, 0x000fe200030e0607ULL, 0x000000031d00720cULL, 0x080fe20003f46070ULL,
0x000000000c097faeULL, 0x0007e2000c901c46ULL, 0x000000031e00720cULL, 0x000fe20003f26070ULL,
0x00005e0006067625ULL, 0x000fe200078e0023ULL, 0x000000031f00720cULL, 0x000fc60003f06070ULL,
0x0000000420037824ULL, 0x000fe200078e00ffULL, 0x0000002106067210ULL, 0x000fe20007fde0ffULL,
0x000000041d177824ULL, 0x004fe400078e00ffULL, 0x00000004240b7824ULL, 0x000fe200078e00ffULL,
0xfffffffc03037812ULL, 0x100fe200078ee208ULL, 0x00000004190d7824ULL, 0x008fe200078e00ffULL,
0xfffffffc17177812ULL, 0x100fe200078ee208ULL, 0x000000041e197824ULL, 0x000fe200078e00ffULL,
0xfffffffc0b0b7812ULL, 0x100fe200078ee208ULL, 0x000000041f1d7824ULL, 0x000fe200078e00ffULL,
0xfffffffc0d0d7812ULL, 0x100fe200078ee208ULL, 0x0000000114097824ULL, 0x000fe200078e021fULL,
0xfffffffc19197812ULL, 0x100fe200078ee208ULL, 0x000000ffff077224ULL, 0x000fe200030e0607ULL,
0xfffffffc1d1d7812ULL, 0x000fe200078ee208ULL, 0x00005e0009087625ULL, 0x000fc800078e0023ULL,
0x0000001003037824ULL, 0x100fe200078e021cULL, 0x0000002108087210ULL, 0x000fe20007fde0ffULL,
0x000000100b0b7824ULL, 0x100fe400078e021cULL, 0x000000100d0d7824ULL, 0x100fe200078e021cULL,
0x000000000e037faeULL, 0x0005e2000e901c46ULL, 0x0000001017177824ULL, 0x100fe400078e021cULL,
0x0000001019197824ULL, 0x100fe200078e021cULL, 0x00000000100b7faeULL, 0x0005e2000e101c46ULL,
0x000000101d1d7824ULL, 0x000fc400078e021cULL, 0x000000ffff097224ULL, 0x000fe200030e0609ULL,
0x00000000120d7faeULL, 0x0005e8000d901c46ULL, 0x000000001a177faeULL, 0x0005e8000d101c46ULL,
0x0000000006197faeULL, 0x0005e8000c901c46ULL, 0x00000000081d7faeULL, 0x0005e2000c101c46ULL,
0x000004e000007947ULL, 0x000fea0003800000ULL, 0x0000001017077811ULL, 0x040fe200078ff0ffULL,
0x00000100ff257424ULL, 0x000fe200078e00ffULL, 0x0000001417067211ULL, 0x000fc400078ff0ffULL,
0x0000001717037211ULL, 0x040fe200078fe8ffULL, 0x0000000114087824ULL, 0x000fe200078e0207ULL,
0x00000008170f7811ULL, 0x000fe200078ff0ffULL, 0x00000004071b7824ULL, 0x000fe200078e00ffULL,
0x0000003017117811ULL, 0x040fe200078ff0ffULL, 0x00005e0006067625ULL, 0x000fe200078e0025ULL,
0x00000020170b7811ULL, 0x000fe400078ff0ffULL, 0x000000300c277812ULL, 0x000fe200078ec0ffULL,
0x000000040f197824ULL, 0x000fe200078e00ffULL, 0x0000001817097811ULL, 0x000fe200078ff0ffULL,
0x00000001141e7824ULL, 0x040fe200078e0211ULL, 0x00000003031a7812ULL, 0x000fe200078ec0ffULL,
0x0000000114037824ULL, 0x040fe200078e020fULL, 0x00000028170d7811ULL, 0x040fe200078ff0ffULL,
0x00000001140f7824ULL, 0x000fe200078e020bULL, 0x0000003817137811ULL, 0x000fe200078ff0ffULL,
0x0000000411117824ULL, 0x000fe200078e00ffULL, 0x0000002706107210ULL, 0x000fe20007f1e0ffULL,
0x000000040b0b7824ULL, 0x000fe200078e00ffULL, 0x0000200018237811ULL, 0x000fe200078e68ffULL,
0x00000001140a7824ULL, 0x000fe200078e0209ULL, 0x0ffffffc1a177812ULL, 0x000fe200078ef817ULL,
0x0000000409097824ULL, 0x000fe200078e00ffULL, 0xfffffffc0b127812ULL, 0x100fe200078ee21aULL,
0x00000001141c7824ULL, 0x040fe200078e020dULL, 0xfffffffc190c7812ULL, 0x100fe200078ee21aULL,
0x0000000114207824ULL, 0x000fe200078e0213ULL, 0xfffffffc11147812ULL, 0x100fe200078ee21aULL,
0x000000040d1d7824ULL, 0x000fe200078e00ffULL, 0xfffffffc090e7812ULL, 0x100fe200078ee21aULL,
0x000000ffff117224ULL, 0x000fe200000e0607ULL, 0xfffffffc1b0d7812ULL, 0x000fe200078ee21aULL,
0x00005e0003067625ULL, 0x000fc800078e0025ULL, 0x00000004131f7824ULL, 0x000fe200078e00ffULL,
0xfffffffc1d137812ULL, 0x000fe200078ee21aULL, 0x00005e0008087625ULL, 0x000fc600078e0025ULL,
0xfffffffc1f1b7812ULL, 0x000fe200078ee21aULL, 0x00000010121d7824ULL, 0x000fe200078e0223ULL,
0x0000002706127210ULL, 0x000fe20007f1e0ffULL, 0x00005e000a0a7625ULL, 0x000fe200078e0025ULL,
0x00000027081a7210ULL, 0x000fc60007f3e0ffULL, 0x0000001017297824ULL, 0x100fe400078e0223ULL,
0x00000010131f7824ULL, 0x100fe400078e0223ULL, 0x000000100c037824ULL, 0x100fe200078e0223ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010297faeULL, 0x0005e2000b901c46ULL,
0x000000100d177824ULL, 0x100fe400078e0223ULL, 0x000000100e197824ULL, 0x100fe400078e0223ULL,
0x0000001014217824ULL, 0x000fc400078e0223ULL, 0x000000ffff137224ULL, 0x000fe200000e0607ULL,
0x000000270a0a7210ULL, 0x000fe20007f1e0ffULL, 0x000000101b237824ULL, 0x000fe400078e0223ULL,
0x000000ffff1b7224ULL, 0x000fe200008e0609ULL, 0x0000000012037faeULL, 0x0005e2000b901c46ULL,
0x00005e000f067625ULL, 0x000fc600078e0025ULL, 0x000000001a177faeULL, 0x0005e2000b901c46ULL,
0x00005e001c087625ULL, 0x000fc800078e0025ULL, 0x00005e001e0c7625ULL, 0x000fe200078e0025ULL,
0x0000002708087210ULL, 0x000fc60007f3e0ffULL, 0x00005e00200e7625ULL, 0x000fe200078e0025ULL,
0x000000270c0c7210ULL, 0x000fc60007f5e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e060bULL,
0x0000002706067210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff097224ULL, 0x000fe200008e0609ULL,
0x000000270e0e7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200010e060dULL,
0x000000000a197faeULL, 0x0005e2000b901c46ULL, 0x000000ffff077224ULL, 0x000fe400000e0607ULL,
0x000000ffff0f7224ULL, 0x000fc600018e060fULL, 0x00000000061d7faeULL, 0x0005e8000b901c46ULL,
0x00000000081f7faeULL, 0x0005e8000b901c46ULL, 0x000000000c217faeULL, 0x0005e8000b901c46ULL,
0x000000000e237faeULL, 0x0005e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000067805ULL, 0x004fc40000015200ULL, 0x01060400ff037984ULL, 0x000ea40000000800ULL,
0x8000000003ff7812ULL, 0x006fc40007804805ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fcc0000015200ULL,
0x0000000806087210ULL, 0x000fca0007f1e1ffULL, 0x0000000109097824ULL, 0x000fe200000e0e07ULL,
0x003d09000800780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400800780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff037819ULL, 0x000fc80000011409ULL, 0x0000000803037211ULL, 0x000fca00078110ffULL,
0x000000ffff087224ULL, 0x000fca00000e0609ULL, 0x0000000203037819ULL, 0x000fc80000001208ULL,
0x000000030000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01060400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e640000000000ULL,
0x0000002018037824ULL, 0x002fca00078e0203ULL, 0x00000003ff047819ULL, 0x000fe40000011603ULL,
0x0000000f03037812ULL, 0x000fe400078ec0ffULL, 0x1ffffffe04047812ULL, 0x000fe400078ec0ffULL,
0x0000000103057810ULL, 0x040fe20007ffe0ffULL, 0x0000002003087824ULL, 0x040fe400078e00ffULL,
0x0000000103067824ULL, 0x040fe400078e0204ULL, 0x0000000104077824ULL, 0x040fe200078e0205ULL,
0x0000001004047810ULL, 0x000fe20007ffe0ffULL, 0x0000002003097824ULL, 0x000fe200078e00ffULL,
0x0000001f06067812ULL, 0x000fc400078ec0ffULL, 0x0000001f07077812ULL, 0x000fe200078ec0ffULL,
0x0000000103107824ULL, 0x000fe200078e0204ULL, 0x000001e009067812ULL, 0x000fe200078ee206ULL,
0x0000000105047824ULL, 0x000fe200078e0204ULL, 0x000001e008077812ULL, 0x000fe200078ee207ULL,
0x0000002003057824ULL, 0x040fe200078e00ffULL, 0x0000001f10107812ULL, 0x000fe200078ec0ffULL,
0x00000000060c7984ULL, 0x000e62000000cc00ULL, 0x0000002003037824ULL, 0x000fe200078e00ffULL,
0x0000001f04047812ULL, 0x000fe400078ec0ffULL, 0x0000000007087984ULL, 0x000ea2000000cc00ULL,
0x000001e005107812ULL, 0x000fc400078ee210ULL, 0x000001e003047812ULL, 0x000fe200078ee204ULL,
0x000000ffff1c7224ULL, 0x002fe400078e000cULL, 0x000000ffff1d7224ULL, 0x000fe400078e000eULL,
0x000000ffff1e7224ULL, 0x004fe400078e0008ULL, 0x000000ffff1f7224ULL, 0x000fe400078e000aULL,
0x000000ffff267224ULL, 0x000fe400078e0009ULL, 0x000000ffff277224ULL, 0x000fe200078e000bULL,
0x0000001c06007388ULL, 0x000fe2000000cc00ULL, 0x000000ffff247224ULL, 0x000fc400078e000dULL,
0x000000ffff257224ULL, 0x000fca00078e000fULL, 0x0000002407007388ULL, 0x000fe8000000cc00ULL,
0x0000000004087984ULL, 0x000e68000000cc00ULL, 0x00000000100c7984ULL, 0x000ea2000000cc00ULL,
0x000000ffff2b7224ULL, 0x002fe400078e000aULL, 0x000000ffff2a7224ULL, 0x000fc400078e0008ULL,
0x000000ffff0a7224ULL, 0x000fe400078e0009ULL, 0x000000ffff287224ULL, 0x004fe400078e000cULL,
0x000000ffff297224ULL, 0x000fe400078e000eULL, 0x000000ffff087224ULL, 0x000fe400078e000dULL,
0x000000ffff097224ULL, 0x000fe200078e000fULL, 0x0000002810007388ULL, 0x0003e8000000cc00ULL,
0x0000000804007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01060000ff087f8cULL, 0x002e62000c80043fULL, 0x000000ffff0a7224ULL, 0x000fc600078e00ffULL,
0x0000000000047805ULL, 0x000fc80000015200ULL, 0x01060400ff037984ULL, 0x000ea40000000800ULL,
0x8000000003ff7812ULL, 0x006fc40007804809ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604067210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000600780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400600780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011407ULL,
0x0000000603037211ULL, 0x000fca00078110ffULL, 0x000000ffff067224ULL, 0x000fca00000e0607ULL,
0x0000000203037819ULL, 0x000fc80000001206ULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01060400ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff1600720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0x3d80000022147820ULL, 0x010fe20000410000ULL,
0x0001068818177811ULL, 0x000fe200078e18ffULL, 0x000000ffff1b7224ULL, 0x000fe200078e00ffULL,
0xffffffff16197810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff2d7224ULL, 0x000fe200078e00ffULL,
0x00010608181a7811ULL, 0x000fc400078e28ffULL, 0x000001001b2c7824ULL, 0x000fe200078e0202ULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x0000002c1500720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x00cfea0003800000ULL, 0x000000ffff2f7224ULL, 0x000fe200078e002dULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff2e7224ULL, 0x000fe200078e00ffULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fc4000001ff00ULL, 0x000000012e307810ULL, 0x020fe20007ffe0ffULL,
0x00000a8000007945ULL, 0x000fe20003800000ULL, 0x000000ffff387224ULL, 0x000fc400078e002eULL,
0x0000001b302d7211ULL, 0x040fe200078ff0ffULL, 0x000000ffff2e7224ULL, 0x000fe200078e0030ULL,
0x000000043000780cULL, 0x000fe40003f06070ULL, 0x000000012d317810ULL, 0x040fe20007ffe0ffULL,
0x000001002d337824ULL, 0x000fe200078e0202ULL, 0x000000012f2d7812ULL, 0x000fe400078e0cffULL,
0x000000163100720cULL, 0x000fe20003f26070ULL, 0x0000620000407a24ULL, 0x000fe200078e0233ULL,
0x0000000330317812ULL, 0x000fd600078ec0ffULL, 0x0000054000009947ULL, 0x000fea0003800000ULL,
0x0000000431327824ULL, 0x000fe200078e00ffULL, 0x0000000303317211ULL, 0x002fe200078fe8ffULL,
0x00000002183e7824ULL, 0x000fe200078e022dULL, 0x0000003315307217ULL, 0x000fe20007800000ULL,
0x00000100ff3d7424ULL, 0x000fe200078e00ffULL, 0x00000002ff3b7819ULL, 0x000fe40000011603ULL,
0x0000000331427812ULL, 0x000fe200078ec0ffULL, 0x0000000130347824ULL, 0x000fe200078e0a33ULL,
0x000000083b317810ULL, 0x040fe20007ffe0ffULL, 0x000000013b307824ULL, 0x000fe200078e0240ULL,
0xfffffffc32397812ULL, 0x000fc400078ee203ULL, 0x000000343b00720cULL, 0x080fe20003f26070ULL,
0x0000000131327824ULL, 0x040fe200078e0240ULL, 0x000000343100720cULL, 0x040fe20003f46070ULL,
0x0000000431377824ULL, 0x000fe200078e00ffULL, 0x000020003e3e7811ULL, 0x000fe200078e60ffULL,
0x00005e0030307625ULL, 0x080fe200078e003dULL, 0x0ffffffc42357812ULL, 0x000fe400078ef803ULL,
0xfffffffc37377812ULL, 0x000fe200078ee242ULL, 0x00005e0032327625ULL, 0x000fe200078e003dULL,
0x000000103b3f7810ULL, 0x000fc40007ffe0ffULL, 0x000000183b417810ULL, 0x000fe20007ffe0ffULL,
0x0000001035357824ULL, 0x000fe200078e023eULL, 0x000000203b437810ULL, 0x000fe20007ffe0ffULL,
0x0000001039307825ULL, 0x000fe200078e0030ULL, 0x000000283b457810ULL, 0x040fe40007ffe0ffULL,
0x000000303b477810ULL, 0x000fe20007ffe0ffULL, 0x0000001037377824ULL, 0x000fe200078e023eULL,
0x000000383b3b7810ULL, 0x000fe20007ffe0ffULL, 0x0000001039327825ULL, 0x000fe200078e0032ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030357faeULL, 0x0003e2000c901c46ULL,
0x000000343f00720cULL, 0x000fc40003f26070ULL, 0x000000344300720cULL, 0x080fe20003f66070ULL,
0x0000000032377faeULL, 0x0005e2000d101c46ULL, 0x000000344100720cULL, 0x080fe20003f46070ULL,
0x0000000145367824ULL, 0x140fe200078e0240ULL, 0x000000344500720cULL, 0x080fe20003f86070ULL,
0x00000001473a7824ULL, 0x140fe200078e0240ULL, 0x000000344700720cULL, 0x080fe20003fa6070ULL,
0x000000013b3c7824ULL, 0x140fe200078e0240ULL, 0x000000343b00720cULL, 0x000fe20003fc6070ULL,
0x000000013f307824ULL, 0x102fe400078e0240ULL, 0x0000000143347824ULL, 0x000fc400078e0240ULL,
0x0000000141327824ULL, 0x004fe400078e0240ULL, 0x000000043f3f7824ULL, 0x000fe400078e00ffULL,
0x0000000441417824ULL, 0x000fe400078e00ffULL, 0x000000043b497824ULL, 0x000fe200078e00ffULL,
0xfffffffc3f3f7812ULL, 0x100fe200078ee242ULL, 0x0000000443437824ULL, 0x000fe200078e00ffULL,
0xfffffffc41417812ULL, 0x100fe200078ee242ULL, 0x00005e0030307625ULL, 0x000fe200078e003dULL,
0xfffffffc49497812ULL, 0x000fc400078ee242ULL, 0xfffffffc43437812ULL, 0x000fe200078ee242ULL,
0x00005e0032327625ULL, 0x000fc800078e003dULL, 0x00005e0034347625ULL, 0x000fc800078e003dULL,
0x00005e0036367625ULL, 0x000fc800078e003dULL, 0x00005e003a3a7625ULL, 0x000fc800078e003dULL,
0x0000000445457824ULL, 0x000fe400078e00ffULL, 0x00005e003c3c7625ULL, 0x000fc600078e003dULL,
0xfffffffc45457812ULL, 0x000fe200078ee242ULL, 0x0000000447477824ULL, 0x000fe400078e00ffULL,
0x0000001039307825ULL, 0x000fc600078e0030ULL, 0xfffffffc47477812ULL, 0x000fe200078ee242ULL,
0x0000001039327825ULL, 0x000fc800078e0032ULL, 0x0000001039347825ULL, 0x000fc800078e0034ULL,
0x0000001039367825ULL, 0x000fc800078e0036ULL, 0x00000010393a7825ULL, 0x000fc800078e003aULL,
0x00000010393c7825ULL, 0x000fc800078e003cULL, 0x000000103f397824ULL, 0x100fe400078e023eULL,
0x00000010413f7824ULL, 0x100fe400078e023eULL, 0x0000001043417824ULL, 0x100fe200078e023eULL,
0x0000000030397faeULL, 0x0003e2000c901c46ULL, 0x0000001045437824ULL, 0x100fe400078e023eULL,
0x0000001047457824ULL, 0x100fe200078e023eULL, 0x00000000323f7faeULL, 0x0003e2000d101c46ULL,
0x0000001049477824ULL, 0x000fc600078e023eULL, 0x0000000034417faeULL, 0x0003e8000d901c46ULL,
0x0000000036437faeULL, 0x0003e8000e101c46ULL, 0x000000003a457faeULL, 0x0003e8000e901c46ULL,
0x000000003c477faeULL, 0x0003e2000f101c46ULL, 0x0000048000007947ULL, 0x000fea0003800000ULL,
0x0000000431347824ULL, 0x000fe200078e00ffULL, 0x0000000803337811ULL, 0x042fe200078ff0ffULL,
0x0000000218327824ULL, 0x000fe200078e022dULL, 0x0000001003357811ULL, 0x040fe200078ff0ffULL,
0x00000100ff417424ULL, 0x000fe200078e00ffULL, 0x0000001803377811ULL, 0x000fc400078ff0ffULL,
0x00000020033b7811ULL, 0x040fe400078ff0ffULL, 0x00000028033d7811ULL, 0x000fe200078ff0ffULL,
0x0000000137367824ULL, 0x100fe200078e0240ULL, 0x00000030033f7811ULL, 0x000fe200078ff0ffULL,
0x000000013b3a7824ULL, 0x100fe200078e0240ULL, 0x0000003803437811ULL, 0x000fe200078ff0ffULL,
0x000000013d3c7824ULL, 0x100fe200078e0240ULL, 0x0000000303317211ULL, 0x000fe200078fe8ffULL,
0x000000013f3e7824ULL, 0x100fe200078e0240ULL, 0xfffffffc34397812ULL, 0x000fe200078ee203ULL,
0x0000000135347824ULL, 0x100fe200078e0240ULL, 0x00002000324d7811ULL, 0x000fe200078e60ffULL,
0x0000000133327824ULL, 0x000fe200078e0240ULL, 0x0000004003307211ULL, 0x000fe200078ff0ffULL,
0x0000000433337824ULL, 0x000fe200078e00ffULL, 0x0000000331427812ULL, 0x000fe200078ec0ffULL,
0x0000000435357824ULL, 0x000fc400078e00ffULL, 0x0000000437377824ULL, 0x000fe200078e00ffULL,
0xfffffffc33447812ULL, 0x100fe200078ee242ULL, 0x000000043b3b7824ULL, 0x000fe200078e00ffULL,
0xfffffffc35467812ULL, 0x100fe200078ee242ULL, 0x000000043d3d7824ULL, 0x000fe200078e00ffULL,
0xfffffffc37487812ULL, 0x100fe200078ee242ULL, 0x000000043f3f7824ULL, 0x000fe200078e00ffULL,
0xfffffffc3b4a7812ULL, 0x000fe200078ee242ULL, 0x0000000143407824ULL, 0x000fe200078e0240ULL,
0xfffffffc3d4c7812ULL, 0x100fe200078ee242ULL, 0x0000000443437824ULL, 0x000fe200078e00ffULL,
0xfffffffc3f4e7812ULL, 0x000fe200078ee242ULL, 0x00005e0030307625ULL, 0x000fc600078e0041ULL,
0xfffffffc43507812ULL, 0x000fe200078ee242ULL, 0x00005e0032327625ULL, 0x000fe200078e0041ULL,
0x0ffffffc42427812ULL, 0x000fc600078ef803ULL, 0x00005e0034347625ULL, 0x000fc800078e0041ULL,
0x00005e0036367625ULL, 0x000fc800078e0041ULL, 0x00005e003a3a7625ULL, 0x000fc800078e0041ULL,
0x00005e003c3c7625ULL, 0x000fc800078e0041ULL, 0x00005e003e3e7625ULL, 0x000fc800078e0041ULL,
0x00005e0040407625ULL, 0x000fc800078e0041ULL, 0x0000001039307825ULL, 0x000fc800078e0030ULL,
0x0000001039327825ULL, 0x000fc800078e0032ULL, 0x0000001039347825ULL, 0x000fc800078e0034ULL,
0x0000001039367825ULL, 0x000fc800078e0036ULL, 0x00000010393a7825ULL, 0x000fc800078e003aULL,
0x00000010393c7825ULL, 0x000fc800078e003cULL, 0x00000010393e7825ULL, 0x000fc800078e003eULL,
0x0000001039407825ULL, 0x000fc800078e0040ULL, 0x00000010424f7824ULL, 0x100fe400078e024dULL,
0x0000001044397824ULL, 0x100fe400078e024dULL, 0x0000001046437824ULL, 0x100fe200078e024dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000304f7faeULL, 0x0003e2000b901c46ULL,
0x0000001048457824ULL, 0x100fe400078e024dULL, 0x000000104a477824ULL, 0x100fe200078e024dULL,
0x0000000032397faeULL, 0x0003e2000b901c46ULL, 0x000000104c497824ULL, 0x000fc400078e024dULL,
0x000000104e4b7824ULL, 0x100fe200078e024dULL, 0x0000000034437faeULL, 0x0003e2000b901c46ULL,
0x00000010504d7824ULL, 0x000fc600078e024dULL, 0x0000000036457faeULL, 0x0003e8000b901c46ULL,
0x000000003a477faeULL, 0x0003e8000b901c46ULL, 0x000000003c497faeULL, 0x0003e8000b901c46ULL,
0x000000003e4b7faeULL, 0x0003e8000b901c46ULL, 0x00000000404d7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000ffff397224ULL, 0x002fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xfffffff803307812ULL, 0x020fe200078ec0ffULL, 0x00000002183a7824ULL, 0x000fe200078e022fULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000139477810ULL, 0x000fc40007ffe0ffULL,
0x0000000730307812ULL, 0x000fe400078ef803ULL, 0x000020003a3a7811ULL, 0x000fe400078e60ffULL,
0x00000001ff327819ULL, 0x000fe20000011630ULL, 0x0000000430347824ULL, 0x040fe200078e00ffULL,
0x0000002003357810ULL, 0x000fe20007ffe0ffULL, 0x0000000430337824ULL, 0x000fe400078e00ffULL,
0x0000000132317824ULL, 0x040fe400078e0239ULL, 0x0000000132327824ULL, 0x000fc600078e0247ULL,
0xfffffffc34317812ULL, 0x000fe400078ee231ULL, 0x0000000703347812ULL, 0x000fe400078ec0ffULL,
0xfffffffc33337812ULL, 0x000fe200078ee232ULL, 0x00000010313c7824ULL, 0x100fe200078e023aULL,
0x0000000834497812ULL, 0x000fe200078ef803ULL, 0x0000000438317824ULL, 0x000fe200078e0239ULL,
0xfffffff835327812ULL, 0x000fe200078ec0ffULL, 0x0000001033407824ULL, 0x000fe400078e023aULL,
0x000000003c3c783bULL, 0x000e620000000200ULL, 0x0000000231307824ULL, 0x000fe200078e00ffULL,
0x00000007323b7812ULL, 0x000fe200078ef803ULL, 0x0000002049347824ULL, 0x000fe200078e00ffULL,
0x000000004040783bULL, 0x000ea40000000200ULL, 0x0000003003317211ULL, 0x000fe200078fe0ffULL,
0x000000043b467824ULL, 0x000fe200078e00ffULL, 0x00000001ff327819ULL, 0x000fc4000001163bULL,
0x0000000230447810ULL, 0x000fe20007ffe0ffULL, 0x0000000149317824ULL, 0x000fe400078e0231ULL,
0x0000000132337824ULL, 0x040fe200078e0239ULL, 0x0000004403447211ULL, 0x000fe200078fe0ffULL,
0x0000000132477824ULL, 0x000fe200078e0247ULL, 0xffffffe034317812ULL, 0x000fe400078ee231ULL,
0xfffffffc46337812ULL, 0x000fe200078ee233ULL, 0x0000000149467824ULL, 0x000fe200078e0244ULL,
0x0000000239397810ULL, 0x000fe20007ffe0ffULL, 0x0000001031317824ULL, 0x000fc400078e00ffULL,
0x0000002049497824ULL, 0x000fe200078e00ffULL, 0x000000043900780cULL, 0x000fe40003f25270ULL,
0x000000003134783bULL, 0x0007240000000200ULL, 0xffffffe049467812ULL, 0x000fca00078ee246ULL,
0x0000001046317824ULL, 0x008fe200078e00ffULL, 0x00000018ff307819ULL, 0x102fe4000001163fULL,
0x0000ffff3f487812ULL, 0x040fe400078ec0ffULL, 0x00000030ff45723eULL, 0x000fe400020006ffULL,
0x00000010ff307819ULL, 0x000fe4000001163fULL, 0x000000ff3f3f7812ULL, 0x000fe200078ec0ffULL,
0x20000045ff457230ULL, 0x000fe20000004100ULL, 0x000000ff30447812ULL, 0x000fc400078ec0ffULL,
0x00000008ff307819ULL, 0x000fe20000011648ULL, 0x0000001033487824ULL, 0x000fe200078e023aULL,
0x00000044ff44723eULL, 0x000fe400020006ffULL, 0x0000003fff3f723eULL, 0x000fe400020006ffULL,
0x00000030ff30723eULL, 0x000fe200020006ffULL, 0x20000044ff447230ULL, 0x000fe20000004100ULL,
0x00000010ff457819ULL, 0x000fe20000011645ULL, 0x2000003fff3f7230ULL, 0x000fe20000004100ULL,
0x0000ffff434d7812ULL, 0x004fe200078ec0ffULL, 0x20000030ff307230ULL, 0x000fe20000004100ULL,
0x00000010ff447819ULL, 0x000fe20000011644ULL, 0x000000004848783bULL, 0x000fe20000000200ULL,
0x00000010ff3f7819ULL, 0x000fc4000001163fULL, 0x00000010ff307819ULL, 0x000fe40000011630ULL,
0x0000105445457816ULL, 0x000fe40000000044ULL, 0x0000105430447816ULL, 0x000fe4000000003fULL,
0x00000010ff3f7819ULL, 0x100fe20000011643ULL, 0x000000003130783bULL, 0x000e620000000200ULL,
0x00000018ff467819ULL, 0x000fe40000011643ULL, 0x000000ff3f4c7812ULL, 0x000fe200078ec0ffULL,
0x000000443404723cULL, 0x010b620000041804ULL, 0x00000008ff3f7819ULL, 0x000fc4000001164dULL,
0x000000ff43437812ULL, 0x000fe400078ec0ffULL, 0x0000003fff3f723eULL, 0x000fe400020006ffULL,
0x000000043b447824ULL, 0x020fe200078e00ffULL, 0x00000043ff43723eULL, 0x000fe400020006ffULL,
0x00000046ff46723eULL, 0x000fe200020006ffULL, 0x2000003fff3f7230ULL, 0x000fe20000004100ULL,
0xfffffffc44477812ULL, 0x000fe200078ee247ULL, 0x20000043ff437230ULL, 0x000fe20000004100ULL,
0x0000004cff4c723eULL, 0x000fe200020006ffULL, 0x20000046ff467230ULL, 0x000fe20000004100ULL,
0x00000010ff447819ULL, 0x000fe2000001163fULL, 0x0000001047477824ULL, 0x000fe200078e023aULL,
0x00000010ff437819ULL, 0x000fe20000011643ULL, 0x2000004cff4c7230ULL, 0x000fe20000004100ULL,
0x00000010ff537819ULL, 0x000fc40000011646ULL, 0x0000105444527816ULL, 0x000fe40000000043ULL,
0x000000004744783bULL, 0x000ea20000000200ULL, 0x00000010ff4c7819ULL, 0x000fe4000001164cULL,
0x00000018ff437819ULL, 0x000fe4000001163dULL, 0x0000105453537816ULL, 0x000fe4000000004cULL,
0x00000043ff43723eULL, 0x000fe400020006ffULL, 0x00000010ff3f7819ULL, 0x000fc4000001163cULL,
0x0000ffff3c587812ULL, 0x000fe200078ec0ffULL, 0x000000523004723cULL, 0x002be20000041804ULL,
0x00000018ff3a7819ULL, 0x000fe2000001163cULL, 0x20000043ff597230ULL, 0x000fe20000004100ULL,
0x00000010ff5e7819ULL, 0x100fe40000011648ULL, 0x00000018ff5f7819ULL, 0x000fe40000011648ULL,
0x000000ff48607812ULL, 0x040fe400078ec0ffULL, 0x0000ffff48787812ULL, 0x000fc400078ec0ffULL,
0x000000ff40487812ULL, 0x000fe400078ec0ffULL, 0x000000ff41537812ULL, 0x020fe400078ec0ffULL,
0x000000ff3f3f7812ULL, 0x000fe400078ec0ffULL, 0x000000ff3c3b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4c7819ULL, 0x000fe4000001163dULL, 0x000000ff3d4d7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff3d5b7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff437819ULL, 0x000fe40000011658ULL,
0x00000010ff6f7819ULL, 0x100fe40000011642ULL, 0x00000018ff547819ULL, 0x000fe40000011642ULL,
0x000000ff42577812ULL, 0x040fe400078ec0ffULL, 0x0000ffff427d7812ULL, 0x000fc400078ec0ffULL,
0x0000003aff3d723eULL, 0x000fe400020006ffULL, 0x00000010ff4e7819ULL, 0x100fe4000001163eULL,
0x00000018ff4f7819ULL, 0x000fe2000001163eULL, 0x2000003dff557230ULL, 0x000fe20000004100ULL,
0x000000ff3e507812ULL, 0x040fe400078ec0ffULL, 0x0000ffff3e5c7812ULL, 0x000fe400078ec0ffULL,
0x00000048ff42723eULL, 0x000fc400020006ffULL, 0x00000010ff627819ULL, 0x100fe40000011649ULL,
0x00000018ff617819ULL, 0x000fe20000011649ULL, 0x20000042ff427230ULL, 0x000fe20000004100ULL,
0x000000ff49637812ULL, 0x040fe400078ec0ffULL, 0x0000ffff49797812ULL, 0x000fe400078ec0ffULL,
0x00000018ff3e7819ULL, 0x000fe40000011640ULL, 0x00000053ff53723eULL, 0x000fc400020006ffULL,
0x0000003fff48723eULL, 0x000fe400020006ffULL, 0x00000018ff497819ULL, 0x100fe20000011641ULL,
0x20000053ff3f7230ULL, 0x000fe20000004100ULL, 0x0000003bff3c723eULL, 0x000fe400020006ffULL,
0x00000043ff43723eULL, 0x000fe400020006ffULL, 0x0000003eff3e723eULL, 0x000fe200020006ffULL,
0x2000003cff527230ULL, 0x000fe20000004100ULL, 0x00000054ff3d723eULL, 0x000fe200020006ffULL,
0x20000048ff547230ULL, 0x000fe20000004100ULL, 0x00000049ff49723eULL, 0x000fe200020006ffULL,
0x20000043ff537230ULL, 0x000fe20000004100ULL, 0x00000010ff667819ULL, 0x000fe2000001164aULL,
0x2000003dff3d7230ULL, 0x000fe20000004100ULL, 0x00000010ff6b7819ULL, 0x000fc40000011641ULL,
0x000000ff4c4c7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff417c7812ULL, 0x000fe200078ec0ffULL,
0x2000003eff417230ULL, 0x000fe20000004100ULL, 0x00000008ff487819ULL, 0x000fe2000001165bULL,
0x20000049ff3e7230ULL, 0x000fe20000004100ULL, 0x000000ff6b6b7812ULL, 0x000fe400078ec0ffULL,
0x000000ff66667812ULL, 0x000fe400078ec0ffULL, 0x00000010ff557819ULL, 0x000fc40000011655ULL,
0x00000010ff547819ULL, 0x000fe40000011654ULL, 0x00000008ff497819ULL, 0x000fe4000001165cULL,
0x0000004cff4c723eULL, 0x000fe400020006ffULL, 0x00000010ff527819ULL, 0x000fe40000011652ULL,
0x00000010ff537819ULL, 0x000fe20000011653ULL, 0x2000004cff587230ULL, 0x000fe20000004100ULL,
0x0000ffff4a7a7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff687819ULL, 0x000fe4000001164bULL,
0x0000004dff4d723eULL, 0x000fe400020006ffULL, 0x00000048ff48723eULL, 0x000fe400020006ffULL,
0x00000018ff707819ULL, 0x004fe20000011644ULL, 0x2000004dff567230ULL, 0x000fe20000004100ULL,
0x000000ff4e4e7812ULL, 0x000fe400078ec0ffULL, 0x0000006bff6b723eULL, 0x000fc400020006ffULL,
0x00000066ff66723eULL, 0x000fe400020006ffULL, 0x0000105455557816ULL, 0x000fe40000000054ULL,
0x00000049ff49723eULL, 0x000fe400020006ffULL, 0x0000105453547816ULL, 0x000fe40000000052ULL,
0x00000057ff3c723eULL, 0x000fe200020006ffULL, 0x20000048ff577230ULL, 0x000fe20000004100ULL,
0x00000008ff527819ULL, 0x000fe2000001167aULL, 0x20000049ff5b7230ULL, 0x000fe20000004100ULL,
0x000000ff68537812ULL, 0x000fe200078ec0ffULL, 0x20000066ff687230ULL, 0x000fe20000004100ULL,
0x0000004fff4f723eULL, 0x000fe200020006ffULL, 0x000000543428723cULL, 0x000b620000041828ULL,
0x0000004eff4e723eULL, 0x000fe200020006ffULL, 0x2000003cff3c7230ULL, 0x000fe20000004100ULL,
0x0000005fff5f723eULL, 0x000fe200020006ffULL, 0x2000004fff5d7230ULL, 0x000fe20000004100ULL,
0x00000070ff4d723eULL, 0x000fe200020006ffULL, 0x2000006bff707230ULL, 0x000fe20000004100ULL,
0x00000050ff50723eULL, 0x000fe200020006ffULL, 0x2000004eff5c7230ULL, 0x000fe20000004100ULL,
0x000000ff5e5e7812ULL, 0x000fe200078ec0ffULL, 0x2000004dff4d7230ULL, 0x000fe20000004100ULL,
0x00000052ff66723eULL, 0x000fe200020006ffULL, 0x20000050ff5a7230ULL, 0x000fe20000004100ULL,
0x00000053ff6b723eULL, 0x000fc400020006ffULL, 0x00000008ff497819ULL, 0x000fe20000011678ULL,
0x20000066ff667230ULL, 0x000fe20000004100ULL, 0x00000010ff527819ULL, 0x000fe20000011659ULL,
0x2000006bff6b7230ULL, 0x000fe20000004100ULL, 0x00000010ff537819ULL, 0x000fe40000011658ULL,
0x00000061ff43723eULL, 0x000fe200020006ffULL, 0x2000005fff617230ULL, 0x000fe20000004100ULL,
0x00000010ff567819ULL, 0x000fe40000011656ULL, 0x00000010ff577819ULL, 0x000fe20000011657ULL,
0x20000043ff657230ULL, 0x000fe20000004100ULL, 0x0000005eff5f723eULL, 0x000fc400020006ffULL,
0x00000060ff60723eULL, 0x000fe400020006ffULL, 0x00000049ff5e723eULL, 0x000fe200020006ffULL,
0x2000005fff5f7230ULL, 0x000fe20000004100ULL, 0x0000105452537816ULL, 0x000fe20000000053ULL,
0x20000060ff607230ULL, 0x000fe20000004100ULL, 0x0000105457527816ULL, 0x000fe20000000056ULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x00000018ff647819ULL, 0x000fe4000001164aULL,
0x000000ff4a677812ULL, 0x000fc400078ec0ffULL, 0x00000018ff4a7819ULL, 0x000fe2000001164bULL,
0x000000523424723cULL, 0x000be20000041824ULL, 0x000000ff4b6a7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff4b7b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff547819ULL, 0x020fe4000001165dULL,
0x00000010ff557819ULL, 0x000fe4000001165cULL, 0x00000010ff4b7819ULL, 0x000fc40000011640ULL,
0x000000ff62627812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5a7819ULL, 0x000fe4000001165aULL,
0x00000010ff5b7819ULL, 0x000fe4000001165bULL, 0x0000ffff406c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff517819ULL, 0x000fe40000011644ULL, 0x00000064ff64723eULL, 0x000fc400020006ffULL,
0x0000105454557816ULL, 0x000fe40000000055ULL, 0x000000ff4b4b7812ULL, 0x000fe200078ec0ffULL,
0x20000064ff697230ULL, 0x000fe20000004100ULL, 0x00000062ff62723eULL, 0x000fe400020006ffULL,
0x000010545b547816ULL, 0x000fe4000000005aULL, 0x00000008ff437819ULL, 0x000fe2000001166cULL,
0x20000062ff647230ULL, 0x000fe20000004100ULL, 0x000000ff51537812ULL, 0x000fc400078ec0ffULL,
0x00000010ff607819ULL, 0x000fe20000011660ULL, 0x000000543420723cULL, 0x000be20000041820ULL,
0x00000010ff517819ULL, 0x000fe4000001165eULL, 0x00000010ff407819ULL, 0x000fe40000011645ULL,
0x0000004bff4b723eULL, 0x000fe400020006ffULL, 0x00000043ff43723eULL, 0x000fe400020006ffULL,
0x00000008ff627819ULL, 0x000fe20000011679ULL, 0x2000004bff6e7230ULL, 0x000fe20000004100ULL,
0x0000105451607816ULL, 0x000fe20000000060ULL, 0x20000043ff6d7230ULL, 0x000fe20000004100ULL,
0x00000008ff567819ULL, 0x000fc4000001167bULL, 0x000000ff40517812ULL, 0x000fe400078ec0ffULL,
0x00000010ff407819ULL, 0x000fe40000011669ULL, 0x00000010ff557819ULL, 0x020fe40000011668ULL,
0x00000063ff63723eULL, 0x000fe400020006ffULL, 0x00000062ff62723eULL, 0x000fe400020006ffULL,
0x00000067ff67723eULL, 0x000fe200020006ffULL, 0x20000063ff637230ULL, 0x000fe20000004100ULL,
0x0000004aff4a723eULL, 0x000fe200020006ffULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x0000006aff6a723eULL, 0x000fe200020006ffULL, 0x20000067ff677230ULL, 0x000fe20000004100ULL,
0x00000056ff56723eULL, 0x000fe200020006ffULL, 0x2000004aff6c7230ULL, 0x000fe20000004100ULL,
0x0000105440557816ULL, 0x000fe20000000055ULL, 0x2000006aff6a7230ULL, 0x000fe20000004100ULL,
0x00000010ff407819ULL, 0x000fe20000011641ULL, 0x20000056ff567230ULL, 0x000fe20000004100ULL,
0x00000010ff527819ULL, 0x000fc40000011661ULL, 0x00000010ff5f7819ULL, 0x000fe4000001165fULL,
0x00000010ff417819ULL, 0x000fe4000001166eULL, 0x00000010ff427819ULL, 0x000fe40000011642ULL,
0x00000010ff6d7819ULL, 0x000fe4000001166dULL, 0x00000010ff3b7819ULL, 0x000fe40000011646ULL,
0x00000053ff57723eULL, 0x000fc400020006ffULL, 0x0000105452617816ULL, 0x000fe4000000005fULL,
0x0000105440417816ULL, 0x000fe20000000041ULL, 0x20000057ff577230ULL, 0x000fe20000004100ULL,
0x00000010ff527819ULL, 0x000fe40000011665ULL, 0x00000010ff537819ULL, 0x000fe20000011664ULL,
0x00000060341c723cULL, 0x000f62000004181cULL, 0x000010546d407816ULL, 0x000fe40000000042ULL,
0x000000ff44717812ULL, 0x000fc400078ec0ffULL, 0x000000ff6f6f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff637819ULL, 0x000fe20000011663ULL, 0x000000403028723cULL, 0x000fe20000041828ULL,
0x00000010ff627819ULL, 0x000fe40000011662ULL, 0x000000ff3b427812ULL, 0x000fe400078ec0ffULL,
0x0000ffff44447812ULL, 0x000fe400078ec0ffULL, 0x00000010ff677819ULL, 0x000fc40000011667ULL,
0x00000010ff667819ULL, 0x000fe40000011666ULL, 0x00000010ff6c7819ULL, 0x000fe4000001166cULL,
0x00000010ff6a7819ULL, 0x000fe4000001166aULL, 0x00000010ff6b7819ULL, 0x000fe4000001166bULL,
0x00000010ff3b7819ULL, 0x000fe40000011656ULL, 0x0000105452537816ULL, 0x000fc40000000053ULL,
0x0000006fff4e723eULL, 0x000fe400020006ffULL, 0x0000105462527816ULL, 0x000fe40000000063ULL,
0x00000018ff727819ULL, 0x000fe20000011645ULL, 0x2000004eff4e7230ULL, 0x000fe20000004100ULL,
0x000000ff45737812ULL, 0x000fe400078ec0ffULL, 0x00000008ff447819ULL, 0x000fe20000011644ULL,
0x000000523410723cULL, 0x000b620000041810ULL, 0x0000105466547816ULL, 0x000fc40000000067ULL,
0x000010546c6b7816ULL, 0x000fe4000000006bULL, 0x000010543b6a7816ULL, 0x000fe4000000006aULL,
0x0000ffff45457812ULL, 0x000fe200078ec0ffULL, 0x00000054340c723cULL, 0x040f62000004180cULL,
0x00000071ff50723eULL, 0x000fe400020006ffULL, 0x00000044ff44723eULL, 0x000fe400020006ffULL,
0x00000008ff457819ULL, 0x000fe20000011645ULL, 0x20000050ff507230ULL, 0x000fe20000004100ULL,
0x00000051ff51723eULL, 0x000fe200020006ffULL, 0x0000006a3408723cULL, 0x000b620000041808ULL,
0x00000072ff4c723eULL, 0x000fe200020006ffULL, 0x20000044ff447230ULL, 0x000fe20000004100ULL,
0x00000073ff4b723eULL, 0x000fe200020006ffULL, 0x20000051ff527230ULL, 0x020fe20000004100ULL,
0x00000045ff45723eULL, 0x000fe200020006ffULL, 0x2000004cff4c7230ULL, 0x000fe20000004100ULL,
0x00000010ff347819ULL, 0x000fe2000001163dULL, 0x2000004bff4b7230ULL, 0x000fe20000004100ULL,
0x00000010ff3d7819ULL, 0x000fe2000001164eULL, 0x20000045ff457230ULL, 0x000fe20000004100ULL,
0x00000008ff437819ULL, 0x000fc4000001167cULL, 0x00000008ff487819ULL, 0x000fe4000001167dULL,
0x00000018ff747819ULL, 0x000fe40000011646ULL, 0x000000ff46757812ULL, 0x000fe400078ec0ffULL,
0x00000010ff3a7819ULL, 0x100fe40000011647ULL, 0x00000018ff767819ULL, 0x000fe40000011647ULL,
0x000000ff47777812ULL, 0x000fc400078ec0ffULL, 0x0000ffff46467812ULL, 0x000fe400078ec0ffULL,
0x0000ffff47477812ULL, 0x000fe400078ec0ffULL, 0x00001054343d7816ULL, 0x000fe4000000003dULL,
0x00000010ff347819ULL, 0x000fe4000001164dULL, 0x00000010ff507819ULL, 0x000fe40000011650ULL,
0x00000010ff517819ULL, 0x000fc40000011657ULL, 0x00000010ff357819ULL, 0x000fe40000011644ULL,
0x00000043ff43723eULL, 0x000fe400020006ffULL, 0x00000048ff48723eULL, 0x000fe400020006ffULL,
0x00000008ff467819ULL, 0x000fe20000011646ULL, 0x20000043ff6f7230ULL, 0x000fe20000004100ULL,
0x000000ff3a3a7812ULL, 0x000fe200078ec0ffULL, 0x20000048ff4f7230ULL, 0x000fe20000004100ULL,
0x00000008ff477819ULL, 0x000fc40000011647ULL, 0x0000105434517816ULL, 0x000fe40000000051ULL,
0x0000105435507816ULL, 0x000fe40000000050ULL, 0x00000010ff4c7819ULL, 0x000fe4000001164cULL,
0x00000010ff357819ULL, 0x000fe40000011652ULL, 0x00000010ff4b7819ULL, 0x000fe2000001164bULL,
0x00000050301c723cULL, 0x000f62000004181cULL, 0x00000010ff347819ULL, 0x000fc40000011645ULL,
0x00000074ff48723eULL, 0x000fe400020006ffULL, 0x00000075ff43723eULL, 0x000fe400020006ffULL,
0x00000076ff76723eULL, 0x000fe200020006ffULL, 0x20000048ff487230ULL, 0x000fe20000004100ULL,
0x00000077ff4a723eULL, 0x000fe200020006ffULL, 0x20000043ff437230ULL, 0x000fe20000004100ULL,
0x00000042ff42723eULL, 0x000fe200020006ffULL, 0x20000076ff497230ULL, 0x000fe20000004100ULL,
0x00000046ff46723eULL, 0x000fe200020006ffULL, 0x2000004aff4a7230ULL, 0x000fe20000004100ULL,
0x0000003aff3a723eULL, 0x000fe200020006ffULL, 0x20000042ff427230ULL, 0x000fe20000004100ULL,
0x00000047ff36723eULL, 0x000fe200020006ffULL, 0x20000046ff467230ULL, 0x000fe20000004100ULL,
0x000010544c357816ULL, 0x000fe20000000035ULL, 0x2000003aff3a7230ULL, 0x000fe20000004100ULL,
0x0000105434347816ULL, 0x000fe2000000004bULL, 0x20000036ff367230ULL, 0x000fe20000004100ULL,
0x00000010ff407819ULL, 0x000fc4000001163eULL, 0x00000010ff417819ULL, 0x000fe40000011670ULL,
0x00000010ff3f7819ULL, 0x000fe2000001163fULL, 0x000000343010723cULL, 0x000b620000041810ULL,
0x00000010ff3e7819ULL, 0x000fe4000001166fULL, 0x00000010ff3c7819ULL, 0x000fe4000001163cULL,
0x00000010ff4f7819ULL, 0x000fe4000001164fULL, 0x00000010ff477819ULL, 0x000fc40000011648ULL,
0x00000010ff427819ULL, 0x000fe40000011642ULL, 0x00000010ff437819ULL, 0x000fe40000011643ULL,
0x00000010ff467819ULL, 0x000fe40000011646ULL, 0x00000010ff497819ULL, 0x000fe40000011649ULL,
0x00000010ff3a7819ULL, 0x000fe4000001163aULL, 0x00000010ff4a7819ULL, 0x000fc4000001164aULL,
0x00000010ff357819ULL, 0x020fe40000011636ULL, 0x0000105440417816ULL, 0x000fe40000000041ULL,
0x000010543e407816ULL, 0x000fe4000000003fULL, 0x000010544f3c7816ULL, 0x000fe4000000003cULL,
0x0000105447477816ULL, 0x000fe40000000042ULL, 0x0000105446467816ULL, 0x000fe20000000043ULL,
0x000000403024723cULL, 0x000b620000041824ULL, 0x00001054494b7816ULL, 0x000fc4000000003aULL,
0x00001054354a7816ULL, 0x000fca000000004aULL, 0x0000003c3020723cULL, 0x040b700000041820ULL,
0x00000046300c723cULL, 0x040b70000004180cULL, 0x0000004a3008723cULL, 0x000b620000041808ULL,
0x0000001000009944ULL, 0x000fe20003c00000ULL, 0xffffe7c000007947ULL, 0x000fcc000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff2f7224ULL, 0x000fe200078e002dULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffdcb000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x0000001420207220ULL, 0x0a0fe20000410000ULL,
0x0000001421217220ULL, 0x080fe20000410000ULL, 0x0000001406307220ULL, 0x080fe20000410000ULL,
0x0000001407317220ULL, 0x080fe20000410000ULL, 0x0000001428287220ULL, 0x080fe20000410000ULL,
0x0000001429297220ULL, 0x080fe20000410000ULL, 0x0000001424247220ULL, 0x080fe20000410000ULL,
0x0000001425257220ULL, 0x080fe20000410000ULL, 0x0000001404047220ULL, 0x080fe20000410000ULL,
0x0000001405057220ULL, 0x080fe20000410000ULL, 0x000000141c1c7220ULL, 0x080fe20000410000ULL,
0x000000141d1d7220ULL, 0x080fe20000410000ULL, 0x000000140c067220ULL, 0x080fe20000410000ULL,
0x000000140d077220ULL, 0x080fe20000410000ULL, 0x000000141e327220ULL, 0x080fe20000410000ULL,
0x000000141f337220ULL, 0x080fe20000410000ULL, 0x000000140e367220ULL, 0x080fe20000410000ULL,
0x000000140f377220ULL, 0x080fe20000410000ULL, 0x00000014222e7220ULL, 0x080fe20000410000ULL,
0x00000014232f7220ULL, 0x080fe20000410000ULL, 0x00000014101e7220ULL, 0x080fe20000410000ULL,
0x00000014111f7220ULL, 0x080fe20000410000ULL, 0x0000001412347220ULL, 0x080fe20000410000ULL,
0x0000001413357220ULL, 0x080fe20000410000ULL, 0x000000140a387220ULL, 0x080fe20000410000ULL,
0x000000140b397220ULL, 0x080fe20000410000ULL, 0x000000ffff0e7224ULL, 0x000fe200078e0020ULL,
0x000000142a2a7220ULL, 0x080fe20000410000ULL, 0x000000ffff0f7224ULL, 0x000fe200078e0021ULL,
0x000000142b2b7220ULL, 0x080fe20000410000ULL, 0x0000001426267220ULL, 0x080fe20000410000ULL,
0x0000001427277220ULL, 0x080fe20000410000ULL, 0x0000001408227220ULL, 0x080fe20000410000ULL,
0x0000001409237220ULL, 0x000fe20000410000ULL, 0x000000ffff0b7224ULL, 0x000fc400078e0028ULL,
0x000000ffff0a7224ULL, 0x000fe400078e0029ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0024ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0025ULL, 0x000000ffff107224ULL, 0x000fe400078e0004ULL,
0x000000ffff117224ULL, 0x000fe400078e0005ULL, 0x000000ffff127224ULL, 0x000fc400078e001cULL,
0x000000ffff137224ULL, 0x000fe400078e001dULL, 0x000000ffff207224ULL, 0x000fe400078e0006ULL,
0x000000ffff217224ULL, 0x000fe200078e0007ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000017087f8cULL, 0x0002a2000c80043fULL, 0x000000ffff247224ULL, 0x000fe400078e002aULL,
0x000000ffff257224ULL, 0x000fe400078e002bULL, 0x000000ffff287224ULL, 0x000fc400078e002eULL,
0x000000ffff297224ULL, 0x000fe400078e002fULL, 0x000000ffff2a7224ULL, 0x000fe400078e0030ULL,
0x000000ffff2b7224ULL, 0x000fe400078e0031ULL, 0x000000ffff2e7224ULL, 0x000fe400078e0032ULL,
0x000000ffff2f7224ULL, 0x000fe400078e0033ULL, 0x000000ffff307224ULL, 0x000fc400078e0034ULL,
0x000000ffff317224ULL, 0x000fe400078e0035ULL, 0x000000ffff327224ULL, 0x000fe400078e0036ULL,
0x000000ffff337224ULL, 0x000fe400078e0037ULL, 0x000000ffff347224ULL, 0x000fe400078e0038ULL,
0x000000ffff357224ULL, 0x000fc400078e0039ULL, 0x0000000000047805ULL, 0x006fca0000015200ULL,
0x0000040017077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fc40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x00000006041d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09001d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000001d06067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011c1c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040017077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004031d7824ULL, 0x000fe200078e00ffULL, 0x000000191b00720cULL, 0x000fc80003f05270ULL,
0xfffffff01d057812ULL, 0x000fca00078ec0ffULL, 0x00000080181c7824ULL, 0x000fca00078e0205ULL,
0x010400001c047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000203087824ULL, 0x000fe400078e00ffULL, 0x00000001152c7824ULL, 0x000fc600078e0a2cULL,
0x0000000608097812ULL, 0x000fc800078ec0ffULL, 0x0000000109377812ULL, 0x040fe400078efcffULL,
0x0000000809397812ULL, 0x000fe400078efcffULL, 0x0000002c3700720cULL, 0x080fe40003f26070ULL,
0x0000001009377812ULL, 0x000fe400078efcffULL, 0x0000002c3900720cULL, 0x080fe40003f06070ULL,
0x0000002c3700720cULL, 0x000fc40003fc6070ULL, 0x0000001109397812ULL, 0x040fe400078efcffULL,
0x0000001809377812ULL, 0x040fe400078efcffULL, 0x0000002c0900720cULL, 0x080fe40003f46070ULL,
0x0000002c3900720cULL, 0x080fe40003fa6070ULL, 0x0000002c3700720cULL, 0x000fe40003f66070ULL,
0x00000009093b7812ULL, 0x000fc400078efcffULL, 0x0000001909397812ULL, 0x040fe400078efcffULL,
0x0000002009377812ULL, 0x000fe400078efcffULL, 0xff80000024247808ULL, 0x000fe40005000000ULL,
0xff8000000b0b7808ULL, 0x000fe40005000000ULL, 0xff80000025257808ULL, 0x000fe40004800000ULL,
0xff8000000a0a7808ULL, 0x000fc40004800000ULL, 0x0000002c3b00720cULL, 0x080fe40003f86070ULL,
0x0000002c3900720cULL, 0x080fe40003f46070ULL, 0x0000002c3700720cULL, 0x000fe40003f26070ULL,
0x0000002109397812ULL, 0x040fe400078efcffULL, 0x0000002809377812ULL, 0x000fe400078efcffULL,
0xff80000026267808ULL, 0x000fc40004000000ULL, 0xff8000000c0c7808ULL, 0x000fe40004000000ULL,
0xff80000027277808ULL, 0x000fe40006000000ULL, 0xff8000000d0d7808ULL, 0x000fe40006000000ULL,
0x0000002c3900720cULL, 0x080fe40003f06070ULL, 0x0000002c3700720cULL, 0x000fe40003f86070ULL,
0x0000002909397812ULL, 0x000fc400078efcffULL, 0x0000003009377812ULL, 0x000fe400078efcffULL,
0xff80000028287808ULL, 0x000fe40007000000ULL, 0xff8000000e0e7808ULL, 0x000fe40007000000ULL,
0xff80000029297808ULL, 0x000fe40006800000ULL, 0xff8000000f0f7808ULL, 0x000fe40006800000ULL,
0x0000002c3900720cULL, 0x000fc40003fc6070ULL, 0x0000002c3700720cULL, 0x000fe40003fa6070ULL,
0x0000003109397812ULL, 0x040fe400078efcffULL, 0x0000003809377812ULL, 0x040fe400078efcffULL,
0x0000003909097812ULL, 0x000fe400078efcffULL, 0xff8000002a2a7808ULL, 0x000fe40005800000ULL,
0xff80000010107808ULL, 0x000fc40005800000ULL, 0xff8000002b2b7808ULL, 0x000fe40005000000ULL,
0xff80000011117808ULL, 0x000fe40005000000ULL, 0xff8000002e2e7808ULL, 0x000fe40004800000ULL,
0xff80000012127808ULL, 0x000fe40004800000ULL, 0x0000002c3900720cULL, 0x080fe40003f66070ULL,
0x0000002c3700720cULL, 0x000fc40003f46070ULL, 0x0000002c0900720cULL, 0x000fe40003f26070ULL,
0xff8000002f2f7808ULL, 0x000fe40004000000ULL, 0xff80000013137808ULL, 0x000fe40004000000ULL,
0xff80000030307808ULL, 0x000fe40006000000ULL, 0xff8000001e1e7808ULL, 0x000fe40006000000ULL,
0xff80000031317808ULL, 0x000fc40007000000ULL, 0xff8000001f1f7808ULL, 0x000fe40007000000ULL,
0xff80000032327808ULL, 0x000fe40006800000ULL, 0xff80000020207808ULL, 0x000fe40006800000ULL,
0xff80000033337808ULL, 0x000fe40005800000ULL, 0xff80000021217808ULL, 0x000fe40005800000ULL,
0xff80000034347808ULL, 0x000fc40005000000ULL, 0xff80000022227808ULL, 0x000fe40005000000ULL,
0xff80000035357808ULL, 0x000fe40004800000ULL, 0xff80000023237808ULL, 0x000fc40004800000ULL,
0x0000000b0400720bULL, 0x004fe20003f1e000ULL, 0x0000001fff3b7424ULL, 0x000fe200078e00ffULL,
0x000000240500720bULL, 0x000fe20003f3e000ULL, 0xffffffffff3c7424ULL, 0x000fe200078e00ffULL,
0x000000040b097208ULL, 0x000fe40004000000ULL, 0x0000000524047208ULL, 0x000fc40004800000ULL,
0x0000000a0900720bULL, 0x000fe40003f1e000ULL, 0x000000250400720bULL, 0x000fe40003f3e000ULL,
0x000000090a097208ULL, 0x000fe40004000000ULL, 0x0000000425057208ULL, 0x000fe40004800000ULL,
0x0000000c0900720bULL, 0x000fe40003f1e000ULL, 0x000000260500720bULL, 0x000fc40003f3e000ULL,
0x000000090c047208ULL, 0x000fe40004000000ULL, 0x0000000526087208ULL, 0x000fe40004800000ULL,
0x0000000d0400720bULL, 0x000fe40003f1e000ULL, 0x000000270800720bULL, 0x000fe40003f3e000ULL,
0x000000040d057208ULL, 0x000fe40004000000ULL, 0x0000000827097208ULL, 0x000fc40004800000ULL,
0x0000000e0500720bULL, 0x000fe40003f1e000ULL, 0x000000280900720bULL, 0x000fe40003f3e000ULL,
0x000000050e047208ULL, 0x000fe40004000000ULL, 0x0000000928087208ULL, 0x000fe40004800000ULL,
0x0000000f0400720bULL, 0x000fe40003f1e000ULL, 0x000000290800720bULL, 0x000fc40003f3e000ULL,
0x000000040f057208ULL, 0x000fe40004000000ULL, 0x0000000829097208ULL, 0x000fe40004800000ULL,
0x000000100500720bULL, 0x000fe40003f1e000ULL, 0x0000002a0900720bULL, 0x000fe40003f3e000ULL,
0x0000000510047208ULL, 0x000fe40004000000ULL, 0x000000092a087208ULL, 0x000fc40004800000ULL,
0x000000110400720bULL, 0x000fe40003f1e000ULL, 0x0000002b0800720bULL, 0x000fe40003f3e000ULL,
0x0000000411057208ULL, 0x000fe40004000000ULL, 0x000000082b097208ULL, 0x000fe40004800000ULL,
0x000000120500720bULL, 0x000fe40003f1e000ULL, 0x0000002e0900720bULL, 0x000fc40003f3e000ULL,
0x0000000512047208ULL, 0x000fe40004000000ULL, 0x000000092e087208ULL, 0x000fe40004800000ULL,
0x000000130400720bULL, 0x000fe40003f1e000ULL, 0x0000002f0800720bULL, 0x000fe40003f3e000ULL,
0x0000000413057208ULL, 0x000fe40004000000ULL, 0x000000082f097208ULL, 0x000fc40004800000ULL,
0x0000001e0500720bULL, 0x000fe40003f1e000ULL, 0x000000300900720bULL, 0x000fe40003f3e000ULL,
0x000000051e047208ULL, 0x000fe40004000000ULL, 0x0000000930087208ULL, 0x000fe40004800000ULL,
0x0000001f0400720bULL, 0x000fe40003f1e000ULL, 0x000000310800720bULL, 0x000fc40003f3e000ULL,
0x000000041f057208ULL, 0x000fe40004000000ULL, 0x0000000831097208ULL, 0x000fe40004800000ULL,
0x000000200500720bULL, 0x000fe40003f1e000ULL, 0x000000320900720bULL, 0x000fe40003f3e000ULL,
0x0000000520047208ULL, 0x000fe40004000000ULL, 0x0000000932087208ULL, 0x000fc40004800000ULL,
0x000000210400720bULL, 0x000fe40003f1e000ULL, 0x000000330800720bULL, 0x000fe40003f3e000ULL,
0x0000000421057208ULL, 0x000fe40004000000ULL, 0x0000000833097208ULL, 0x000fe40004800000ULL,
0x000000220500720bULL, 0x000fe40003f1e000ULL, 0x000000340900720bULL, 0x000fc40003f3e000ULL,
0x0000000522047208ULL, 0x000fe40004000000ULL, 0x0000000934087208ULL, 0x000fe40004800000ULL,
0x000000230400720bULL, 0x000fe40003f1e000ULL, 0x000000350800720bULL, 0x000fe40003f3e000ULL,
0x0000000423367208ULL, 0x000fe40004000000ULL, 0x0000000835387208ULL, 0x000fe20004800000ULL,
0x000017d27f007947ULL, 0x000fec000b800000ULL, 0x0c401f0036047f89ULL, 0x0004e400000e0000ULL,
0x000000043600720bULL, 0x008fc80003f1e000ULL, 0x00000036043a7208ULL, 0x000fe20004000000ULL,
0x000017e27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0038047f89ULL, 0x000ee800000e0000ULL,
0x0c401f0006057f89ULL, 0x000f2800000e0000ULL, 0x0c401f00072c7f89ULL, 0x000e6200000e0000ULL,
0x000000043800720bULL, 0x008fc40003f1e000ULL, 0x000000050600720bULL, 0x010fe40003f3e000ULL,
0x0000003804087208ULL, 0x000fe40004000000ULL, 0x0000000605097208ULL, 0x000fe20004800000ULL,
0x0c201f003a047f89ULL, 0x000ee200000e0000ULL, 0x0000002c0700720bULL, 0x002fc60003f1e000ULL,
0x0c201f0008057f89ULL, 0x000e6200000e0000ULL, 0x000000072c2c7208ULL, 0x000fc60004000000ULL,
0x0c201f0009367f89ULL, 0x004ea800000e0000ULL, 0x0c201f002c377f89ULL, 0x0002a200000e0000ULL,
0x000000043a00720bULL, 0x008fe40003f1e000ULL, 0x000000050800720bULL, 0x002fe40003f3e000ULL,
0x0000003a04047208ULL, 0x000fe40004000000ULL, 0x000000360900720bULL, 0x004fc40003f5e000ULL,
0x0000000805057208ULL, 0x000fe40004800000ULL, 0x0000000936067208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL, 0x3fb8aa3b053a7820ULL, 0x000fe20000410000ULL,
0x3f80000000047882ULL, 0x000fe20000000000ULL, 0x0000000c1d1d7812ULL, 0x000fe200078ec0ffULL,
0x3fb8aa3b0b0b7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0c0c7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0d0d7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b20207823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b24247823ULL, 0x100fe2000001083aULL, 0x3fb8aa3b25257823ULL, 0x100fe2000001083aULL,
0x3fb8aa3b0a0a7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b26267823ULL, 0x100fe2000001083aULL,
0x3fb8aa3b27277823ULL, 0x100fe2000001083aULL, 0x0000000b00087308ULL, 0x000fe20000000800ULL,
0x00000004ff3c7e24ULL, 0x002fe2000f8e00ffULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b10107823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b11117823ULL, 0x100fe20000010807ULL, 0x3f8000003c3c783eULL, 0x000fe200000010ffULL,
0x3fb8aa3b28287823ULL, 0x100fe2000001083aULL, 0x0000000a00097308ULL, 0x000e620000000800ULL,
0x3fb8aa3b29297823ULL, 0x100fe2000001083aULL, 0x3fb8aa3b2a2a7823ULL, 0x000fe2000001083aULL,
0x000000ffff3d7224ULL, 0x000fe200078e003cULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe2000001083aULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b12127823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b13137823ULL, 0x100fe20000010807ULL, 0x0000002000367308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b21217823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b22227823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe2000001083aULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe2000001083aULL,
0x3fb8aa3b30307823ULL, 0x100fe2000001083aULL, 0x0000000c000c7308ULL, 0x000fe20000000800ULL,
0x000000080908723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b31317823ULL, 0x100fe2000001083aULL,
0x3fb8aa3b23077823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b32327823ULL, 0x100fe2000001083aULL,
0x3fb8aa3b33337823ULL, 0x100fe2000001083aULL, 0x3fb8aa3b34347823ULL, 0x100fe2000001083aULL,
0x3fb8aa3b35357823ULL, 0x000fe2000001083aULL, 0x0000000d000d7308ULL, 0x000e620000000800ULL,
0x0000000303ff7812ULL, 0x000fc4000780c0ffULL, 0x000000372c00720bULL, 0x004fca0003f3e000ULL,
0x0000002400247308ULL, 0x000ff00000000800ULL, 0x0000002500257308ULL, 0x000ea20000000800ULL,
0x0000000c0d0a723eULL, 0x002fce00000010ffULL, 0x00000026000b7308ULL, 0x000ff00000000800ULL,
0x0000002700207308ULL, 0x000e620000000800ULL, 0x000000242509723eULL, 0x004fce00000010ffULL,
0x0000000e000e7308ULL, 0x000fe20000000800ULL, 0x0000000b200b723eULL, 0x002fce00000010ffULL,
0x0000000f000f7308ULL, 0x000e620000000800ULL, 0x0000003c0824723cULL, 0x000f6e00000418ffULL,
0x0000001000107308ULL, 0x000ff00000000800ULL, 0x0000001100117308ULL, 0x000ea20000000800ULL,
0x0000000e0f0c723eULL, 0x002fce00000010ffULL, 0x0000002800287308ULL, 0x000ff00000000800ULL,
0x0000002900297308ULL, 0x000e620000000800ULL, 0x00000010110e723eULL, 0x004fce00000010ffULL,
0x0000002a002a7308ULL, 0x000ff00000000800ULL, 0x0000002b002b7308ULL, 0x000ea20000000800ULL,
0x00000028290d723eULL, 0x002fce00000010ffULL, 0x0000002100397308ULL, 0x000fe20000000800ULL,
0x0000002a2b0f723eULL, 0x004fce00000010ffULL, 0x0000002200387308ULL, 0x0003e20000000800ULL,
0x00000002ff2a7819ULL, 0x000fc80000011603ULL, 0x000000012a107810ULL, 0x040fe20007ffe0ffULL,
0x000000082a117824ULL, 0x040fe200078e00ffULL, 0x000000082a3b7810ULL, 0x040fe20007ffe0ffULL,
0x0000001200127308ULL, 0x000fe20000000800ULL, 0x0000003c0c20723cULL, 0x022b620000041824ULL,
0x000000082a297824ULL, 0x000fe200078e00ffULL, 0xfffffff811287812ULL, 0x000fca00078ee210ULL,
0x0000001300137308ULL, 0x000e620000000800ULL, 0x000000082a267824ULL, 0x060fe200078e00ffULL,
0x000000032a247810ULL, 0x040fe20007ffe0ffULL, 0x000000082a277824ULL, 0x040fe200078e00ffULL,
0x000000042a257810ULL, 0x000fe40007ffe0ffULL, 0xfffffff829297812ULL, 0x000fe400078ee224ULL,
0x0000001e001e7308ULL, 0x000fe20000000800ULL, 0xfffffff8262b7812ULL, 0x000fe400078ee225ULL,
0x000000052a247810ULL, 0x000fc40007ffe0ffULL, 0x000000062a257810ULL, 0x040fe40007ffe0ffULL,
0xffffffff2a267810ULL, 0x000fe20007ffe0ffULL, 0x0000001f001f7308ULL, 0x000ea20000000800ULL,
0x000000121310723eULL, 0x002fe400000010ffULL, 0xfffffff8273a7812ULL, 0x000fca00078ee226ULL,
0x0000002e002e7308ULL, 0x000ff00000000800ULL, 0x0000002f002f7308ULL, 0x000e620000000800ULL,
0x0000001e1f12723eULL, 0x004fe200000010ffULL, 0x000000082a1f7824ULL, 0x040fe200078e00ffULL,
0x000000022a1e7810ULL, 0x000fc80007ffe0ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee21eULL,
0x0000003000307308ULL, 0x000fe20000000800ULL, 0xfffffff8271e7812ULL, 0x000fce00078ee22aULL,
0x0000003100317308ULL, 0x000ea20000000800ULL, 0x0000002e2f11723eULL, 0x002fe200000010ffULL,
0x000000082a2f7824ULL, 0x040fe400078e00ffULL, 0x000000082a2e7824ULL, 0x000fe400078e00ffULL,
0x000000083b2a7824ULL, 0x000fe200078e00ffULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee224ULL,
0x0000000700077308ULL, 0x000e620000000800ULL, 0x000000363924723eULL, 0x000fe400000010ffULL,
0x0000a00018367811ULL, 0x000fc400078e58ffULL, 0xfffffff82a3b7812ULL, 0x000fe400078ee23bULL,
0x000000303113723eULL, 0x004fe200000010ffULL, 0x0000003200327308ULL, 0x000fe20000000800ULL,
0xfffffff82e317812ULL, 0x000fe200078ee225ULL, 0x000000101e1e7824ULL, 0x100fe400078e0236ULL,
0x0000001028287824ULL, 0x100fe400078e0236ULL, 0x0000003c1020723cULL, 0x000f620000041820ULL,
0x000000380726723eULL, 0x002fe200000010ffULL, 0x0000003300337308ULL, 0x000e620000000800ULL,
0x000000101f2a7824ULL, 0x000fc400078e0236ULL, 0x00000010292e7824ULL, 0x100fe400078e0236ULL,
0x000000102b307824ULL, 0x100fe400078e0236ULL, 0x000000011e077824ULL, 0x000fe200078e021dULL,
0x0000003400347308ULL, 0x000fe20000000800ULL, 0x000000102f1e7824ULL, 0x000fe400078e0236ULL,
0x000000011d287824ULL, 0x040fe200078e0228ULL, 0x0000000807007388ULL, 0x0005e20000000800ULL,
0x000000011d2a7824ULL, 0x000fc400078e022aULL, 0x000000103a3a7824ULL, 0x100fe200078e0236ULL,
0x0000003500357308ULL, 0x000ee20000000800ULL, 0x000000323325723eULL, 0x002fe200000010ffULL,
0x0000001031327824ULL, 0x000fe200078e0236ULL, 0x0000000a28007388ULL, 0x0003e20000000800ULL,
0x000000011d2e7824ULL, 0x040fe400078e022eULL, 0x000000011d307824ULL, 0x040fe200078e0230ULL,
0x0000000c2a007388ULL, 0x0003e20000000800ULL, 0x000000011d1e7824ULL, 0x000fe200078e021eULL,
0x0000002c37077208ULL, 0x004fe20004800000ULL, 0x000000011d327824ULL, 0x040fe200078e0232ULL,
0x0000000e2e007388ULL, 0x0003e20000000800ULL, 0x000000011d3a7824ULL, 0x000fc600078e023aULL,
0x0000001030007388ULL, 0x0003e20000000800ULL, 0x000000343527723eULL, 0x008fe200000010ffULL,
0x000000103b347824ULL, 0x000fe400078e0236ULL, 0x000000121e007388ULL, 0x0003e40000000800ULL,
0x000000011d347824ULL, 0x000fe400078e0234ULL, 0x0000003c2420723cULL, 0x020f620000041820ULL,
0x0000002432007388ULL, 0x0003e80000000800ULL, 0x000000263a007388ULL, 0x0003e80000000800ULL,
0x0000000934007388ULL, 0x0003e80000000800ULL, 0x0004000b28007388ULL, 0x0003e80000000800ULL,
0x0004000d2a007388ULL, 0x0003e80000000800ULL, 0x0004000f2e007388ULL, 0x0003e60000000800ULL,
0x000000ffff217224ULL, 0x020fe200078e0022ULL, 0x0004001130007388ULL, 0x0003e80000000800ULL,
0x000400131e007388ULL, 0x0003e80000000800ULL, 0x0004002532007388ULL, 0x0003e80000000800ULL,
0x000400273a007388ULL, 0x0003e80000000800ULL, 0x010000041c008388ULL, 0x0003e80000000c00ULL,
0x010200201c008388ULL, 0x0003e20000000a00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000001aff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000008001aff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000010001aff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000011b1b7810ULL, 0x000fe20007ffe0ffULL, 0x000018001aff7f8cULL, 0x0003e6000c80043fULL,
0x000000161b00720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffbf4000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff427807ULL, 0x008fe40004000000ULL, 0x0001ae7000467802ULL, 0x000fc40000000f00ULL,
0x00000f5000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff007224ULL, 0x000fe200078e0047ULL,
0xfffe6e0000007947ULL, 0x000fea000383ffffULL, 0x00000001ff427807ULL, 0x000fe40005000000ULL,
0x0001aec000467802ULL, 0x000fc40000000f00ULL, 0x00000f0000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff027224ULL, 0x000fe200078e0047ULL, 0xfffe6e6000007947ULL, 0x000fea000383ffffULL,
0x000000ffff557224ULL, 0x000fe200078e0004ULL, 0x0001af2000427802ULL, 0x000fe20000000f00ULL,
0x000000ffff527224ULL, 0x008fc400078e0019ULL, 0x00000e6000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0052ULL, 0xfffe6ef000007947ULL, 0x000fea000383ffffULL,
0x000000ffff527224ULL, 0x000fe200078e0019ULL, 0x0001af8000427802ULL, 0x000fe20000000f00ULL,
0x000000ffff557224ULL, 0x002fc400078e0004ULL, 0x00000e0000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0052ULL, 0xfffe700000007947ULL, 0x000fea000383ffffULL,
0x000000ffff527224ULL, 0x000fe200078e0000ULL, 0x0001afe000427802ULL, 0x000fe20000000f00ULL,
0x000000ffff557224ULL, 0x000fc400078e0003ULL, 0x00000da000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff097224ULL, 0x004fe200078e0052ULL, 0xfffe73f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff557224ULL, 0x002fe200078e0008ULL, 0x0001b04000427802ULL, 0x000fe20000000f00ULL,
0x000000ffff527224ULL, 0x000fc400078e0000ULL, 0x00000d4000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e0052ULL, 0xfffe73c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff527224ULL, 0x000fe200078e001aULL, 0x0001b0a000427802ULL, 0x000fe20000000f00ULL,
0x000000ffff557224ULL, 0x000fc400078e001bULL, 0x00000ce000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff097224ULL, 0x004fe200078e0052ULL, 0xfffe985000007947ULL, 0x000fea000383ffffULL,
0x000000ffff527224ULL, 0x000fe200078e001aULL, 0x0001b0f000427802ULL, 0x000fc40000000f00ULL,
0x00000c9000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e0052ULL,
0xfffe983000007947ULL, 0x000fea000383ffffULL, 0x00000001ff427807ULL, 0x004fe40004000000ULL,
0x0001b14000467802ULL, 0x000fc40000000f00ULL, 0x00000c8000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff457224ULL, 0x000fe200078e0047ULL, 0xfffebcf000007947ULL, 0x000fea000383ffffULL,
0x00000001ff427807ULL, 0x000fe40005000000ULL, 0x0001b19000467802ULL, 0x000fc40000000f00ULL,
0x00000c3000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff407224ULL, 0x000fe200078e0047ULL,
0xfffebd3000007947ULL, 0x000fea000383ffffULL, 0x000000ffff527224ULL, 0x000fe200078e0047ULL,
0x0001b1e000427802ULL, 0x000fc40000000f00ULL, 0x00000ba000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff427224ULL, 0x004fe200078e0052ULL, 0xfffebdf000007947ULL, 0x000fea000383ffffULL,
0x000000ffff527224ULL, 0x000fe200078e0047ULL, 0x0001b23000427802ULL, 0x000fc40000000f00ULL,
0x00000b5000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff427224ULL, 0x004fe200078e0052ULL,
0xfffebf0000007947ULL, 0x000fea000383ffffULL, 0x000000ffff527224ULL, 0x000fe200078e002bULL,
0x0001b29000427802ULL, 0x000fe20000000f00ULL, 0x000000ffff557224ULL, 0x000fc400078e0044ULL,
0x00000af000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e0052ULL,
0xfffec31000007947ULL, 0x000fea000383ffffULL, 0x000000ffff527224ULL, 0x000fe200078e002bULL,
0x0001b2e000427802ULL, 0x000fc40000000f00ULL, 0x00000aa000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e0052ULL, 0xfffec2f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff527224ULL, 0x000fe200078e0030ULL, 0x0001b34000427802ULL, 0x000fe20000000f00ULL,
0x000000ffff557224ULL, 0x000fc400078e0031ULL, 0x00000a4000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff097224ULL, 0x004fe200078e0052ULL, 0xfffee5b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff527224ULL, 0x000fe200078e0030ULL, 0x0001b39000427802ULL, 0x000fc40000000f00ULL,
0x000009f000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e0052ULL,
0xfffee59000007947ULL, 0x000fea000383ffffULL, 0x00000001ff427807ULL, 0x004fe40004000000ULL,
0x0001b3e000467802ULL, 0x000fc40000000f00ULL, 0x000009e000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff447224ULL, 0x000fe200078e0047ULL, 0xffff094000007947ULL, 0x000fea000383ffffULL,
0x00000001ff427807ULL, 0x000fe40005000000ULL, 0x0001b43000467802ULL, 0x000fc40000000f00ULL,
0x0000099000007944ULL, 0x002fea0003c00000ULL, 0xffff099000007947ULL, 0x000fea000383ffffULL,
0x000000ffff527224ULL, 0x000fe200078e004bULL, 0x0001b47000427802ULL, 0x000fc40000000f00ULL,
0x0000091000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff427224ULL, 0x004fe200078e0052ULL,
0xffff0a5000007947ULL, 0x000fea000383ffffULL, 0x000000ffff527224ULL, 0x000fe200078e004bULL,
0x0001b4c000427802ULL, 0x000fc40000000f00ULL, 0x000008c000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff427224ULL, 0x004fe200078e0052ULL, 0xffff0b6000007947ULL, 0x000fea000383ffffULL,
0x000000ffff527224ULL, 0x000fe200078e002bULL, 0x0001b52000427802ULL, 0x000fe20000000f00ULL,
0x000000ffff557224ULL, 0x000fc400078e0040ULL, 0x0000086000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff097224ULL, 0x004fe200078e0052ULL, 0xffff0f7000007947ULL, 0x000fea000383ffffULL,
0x000000ffff527224ULL, 0x000fe200078e002bULL, 0x0001b57000427802ULL, 0x000fc40000000f00ULL,
0x0000081000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e0052ULL,
0xffff0f5000007947ULL, 0x000fea000383ffffULL, 0x000000ffff527224ULL, 0x000fe200078e0030ULL,
0x0001b5d000427802ULL, 0x000fe20000000f00ULL, 0x000000ffff557224ULL, 0x000fc400078e0031ULL,
0x000007b000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e0052ULL,
0xffff321000007947ULL, 0x000fea000383ffffULL, 0x000000ffff527224ULL, 0x000fe200078e0030ULL,
0x0001b62000427802ULL, 0x000fc40000000f00ULL, 0x0000076000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e0052ULL, 0xffff31f000007947ULL, 0x000fea000383ffffULL,
0x00000001ff427807ULL, 0x004fe40004000000ULL, 0x0001b67000467802ULL, 0x000fc40000000f00ULL,
0x0000075000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff447224ULL, 0x000fe200078e0047ULL,
0xffff55b000007947ULL, 0x000fea000383ffffULL, 0x00000001ff427807ULL, 0x000fe40004800000ULL,
0x0001b6c000467802ULL, 0x000fc40000000f00ULL, 0x0000070000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff0d7224ULL, 0x000fe200078e0047ULL, 0xffff55f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff527224ULL, 0x000fe200078e0047ULL, 0x0001b71000427802ULL, 0x000fc40000000f00ULL,
0x0000067000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e0052ULL,
0xffff56b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff527224ULL, 0x000fe200078e0047ULL,
0x0001b76000427802ULL, 0x000fc40000000f00ULL, 0x0000062000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e0052ULL, 0xffff57c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff527224ULL, 0x000fe200078e000dULL, 0x0001b7c000427802ULL, 0x000fe20000000f00ULL,
0x000000ffff557224ULL, 0x000fc400078e000eULL, 0x000005c000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff097224ULL, 0x004fe200078e0052ULL, 0xffff5bd000007947ULL, 0x000fea000383ffffULL,
0x000000ffff527224ULL, 0x000fe200078e000dULL, 0x0001b81000427802ULL, 0x000fc40000000f00ULL,
0x0000057000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e0052ULL,
0xffff5bb000007947ULL, 0x000fea000383ffffULL, 0x000000ffff527224ULL, 0x000fe200078e0000ULL,
0x0001b87000427802ULL, 0x000fe20000000f00ULL, 0x000000ffff557224ULL, 0x000fc400078e0003ULL,
0x0000051000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e0052ULL,
0xffff7e9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff527224ULL, 0x000fe200078e0000ULL,
0x0001b8c000427802ULL, 0x000fc40000000f00ULL, 0x000004c000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e0052ULL, 0xffff7e7000007947ULL, 0x000fea000383ffffULL,
0x00000002ff397424ULL, 0x000fe200078e00ffULL, 0x0001b91000087802ULL, 0x000fc40000000f00ULL,
0x0000043000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0037ULL,
0xffffe7f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff367224ULL, 0x006fe200078e0038ULL,
0x0001b97000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff397424ULL, 0x000fc400078e00ffULL,
0x000003d000007944ULL, 0x000fea0003c00000ULL, 0x000000373800720bULL, 0x004fe20003f1e000ULL,
0x000000ffff367224ULL, 0x002fe200078e0006ULL, 0x0001b9d000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff397424ULL, 0x000fe200078e00ffULL, 0x0000003837387208ULL, 0x000fc80004000000ULL,
0x0000037000007944ULL, 0x000fea0003c00000ULL, 0x000000370600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff367224ULL, 0x002fe200078e0007ULL, 0x0001ba3000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff397424ULL, 0x000fe200078e00ffULL, 0x0000000637067208ULL, 0x000fc80004000000ULL,
0x0000031000007944ULL, 0x000fea0003c00000ULL, 0x000000370700720bULL, 0x004fe20003f1e000ULL,
0x000000ffff367224ULL, 0x002fe200078e003aULL, 0x0001ba9000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff397424ULL, 0x000fe200078e00ffULL, 0x00000007372c7208ULL, 0x000fc80004000000ULL,
0x000002b000007944ULL, 0x000fea0003c00000ULL, 0x000000373a00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff367224ULL, 0x002fe200078e0038ULL, 0x0001baf000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff397424ULL, 0x000fe200078e00ffULL, 0x0000003a37047208ULL, 0x000fc80004000000ULL,
0x0000025000007944ULL, 0x000fea0003c00000ULL, 0x000000373800720bULL, 0x004fe20003f1e000ULL,
0x000000ffff367224ULL, 0x002fe200078e0006ULL, 0x0001bb5000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff397424ULL, 0x000fe200078e00ffULL, 0x0000003837057208ULL, 0x000fc80004000000ULL,
0x000001f000007944ULL, 0x000fea0003c00000ULL, 0x000000370600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff367224ULL, 0x002fe200078e002cULL, 0x0001bbb000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff397424ULL, 0x000fe200078e00ffULL, 0x0000000637067208ULL, 0x000fc80004000000ULL,
0x0000019000007944ULL, 0x000fea0003c00000ULL, 0xffffe6c000007947ULL, 0x000fea000383ffffULL,
0x0180000012007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000027812ULL, 0x000fc800078ec0ffULL, 0x018000000200780cULL, 0x000fda0003f05070ULL,
0x0000001200008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x040fe40003f25070ULL, 0x008000000200780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff12ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000012027812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000001200007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e0004ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffe42c002007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff097424ULL, 0x000fe200078e00ffULL, 0x0000003c00007348ULL, 0x000fe80003800000ULL,
0x0c00003936377389ULL, 0x0002a200000e003bULL, 0xfffe428008007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff437424ULL, 0x000fe200078e00ffULL, 0x0000000b00007348ULL, 0x000fe80003800000ULL,
0x0000005552527389ULL, 0x0002a200000e000cULL, 0xfffe424042007950ULL, 0x000fea0003c3ffffULL,
0x000000014200780cULL, 0x000fe20003f45070ULL, 0x0000000d00007348ULL, 0x000fe80003800000ULL,
0x00000000ff437424ULL, 0x000fd000078e00ffULL, 0x0000000000427806ULL, 0x000fc800050e0100ULL,
0x0000000d42477212ULL, 0x000fe200078ec0ffULL, 0x000000ffff427224ULL, 0x000fc800078e0046ULL,
0xfffe41d042007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000200000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005e7ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000748ULL, 0x0000000000000288ULL, 0x0000001a00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009d0ULL, 0x0000000000000358ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000d28ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000de8ULL, 0x0000000000000a04ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000017f0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001800ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000007bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001890ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001894ULL, 0x00000000000001a8ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001a80ULL, 0x000000000001bf00ULL, 0x9600001a00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x0000000100000089ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001d980ULL, 0x0000000000000044ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001d9d0ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x000000000001dd50ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001890ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000001c0f0ULL, 0x000000000001c0f0ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x000000000001d980ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x000000000001dd50ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_1_kvt_e4m3_nqpkv_8_m_8_sm_89_cubin_len = 122416;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
