/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_1_kvt_e4m3_nqpkv_8_m_8_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000007e58ULL, 0x0000000000007a18ULL, 0x00380040005a0d5aULL, 0x0001001100400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x2e00000000003374ULL,
0x61626f6c672e766eULL, 0x2e0074696e692e6cULL, 0x74736e6f632e766eULL, 0x0000000034746e61ULL,
0x7865742e6c65722eULL, 0x6c656e72656b2e74ULL, 0x65722e0061686d5fULL, 0x2e747865742e616cULL,
0x6d5f6c656e72656bULL, 0x756265642e006168ULL, 0x00656d6172665f67ULL, 0x2e766e2e6c65722eULL,
0x746e6174736e6f63ULL, 0x65722e006369702eULL, 0x6f632e766e2e616cULL, 0x0034746e6174736eULL,
0x2e6c65722e000000ULL, 0x72665f6775626564ULL, 0x6c65722e00656d61ULL, 0x5f67756265642e61ULL,
0x6e2e00656d617266ULL, 0x72676c6c61632e76ULL, 0x2e766e2e00687061ULL, 0x7079746f746f7270ULL,
0x6f632e766e2e0065ULL, 0x2e30746e6174736eULL, 0x6d5f6c656e72656bULL, 0x0000000000006168ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x732e000000000000ULL, 0x0062617472747368ULL, 0x006261747274732eULL, 0x006261746d79732eULL,
0x5f6261746d79732eULL, 0x6e2e0078646e6873ULL, 0x2e006f666e692e76ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL, 0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL,
0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL, 0x6f632e766e2e0061ULL, 0x0033746e6174736eULL,
0x4d34456b00000000ULL, 0x6e2e0058414d5f33ULL, 0x6c61626f6c672e76ULL, 0x6d730074696e692eULL,
0x2e00657a69536d65ULL, 0x74736e6f632e766eULL, 0x0000000034746e61ULL, 0x79546c656e72656bULL,
0x0000000000006570ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7265746e695f5f24ULL,
0x5f245f305f6c616eULL, 0x6d735f616475635fULL, 0x725f7063725f3032ULL, 0x33665f7a74665f6eULL,
0x6170776f6c735f32ULL, 0x2e6c65722e006874ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL,
0x65742e616c65722eULL, 0x656e72656b2e7478ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL,
0x2e6c65722e00656dULL, 0x74736e6f632e766eULL, 0x006369702e746e61ULL, 0x766e2e616c65722eULL,
0x6e6174736e6f632eULL, 0x722e006369702e74ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL,
0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6c61632e766e2e00ULL, 0x2e0068706172676cULL,
0x6f746f72702e766eULL, 0x72656b0065707974ULL, 0x0061686d5f6c656eULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000d000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007fULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000e000300000089ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000100000099ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c0003000000a2ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e0001000000b3ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x0000010000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000d0022000000d3ULL, 0x0000000000006620ULL,
0x0000000000000260ULL, 0x0004000300000131ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000700030000018cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000d1012000001a8ULL,
0x0000000000000000ULL, 0x0000000000006880ULL, 0x00100003000001b3ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x0000002cffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000662000000000ULL, 0x0000500400000000ULL,
0x0400288080810c00ULL, 0x0000000000001924ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80808a0828808081ULL,
0x8d082880808c0828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x002880808d920000ULL,
0x0000000000000022ULL, 0x00000034ffffffffULL, 0x0000006800000000ULL, 0x0000662000000000ULL,
0x0000026000000000ULL, 0x0000480400000000ULL, 0x80882880808a0900ULL, 0x0900000010042880ULL,
0x2880808a2880808dULL, 0x0000000c00082f04ULL, 0x0008120400000054ULL, 0x0000000000000009ULL,
0x0000000900081104ULL, 0x0008120400000000ULL, 0x000000000000000cULL, 0x0000000c00081104ULL,
0x0008120400000000ULL, 0x000000000000000cULL, 0x0000007c00043704ULL, 0x00000000000c1704ULL,
0x0021f00000f00007ULL, 0x00000000000c1704ULL, 0x0201f00000700006ULL, 0x00000000000c1704ULL,
0x0021f00000380005ULL, 0x00000000000c1704ULL, 0x0011f00000300004ULL, 0x00000000000c1704ULL,
0x0061f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL, 0x00000000000c1704ULL,
0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x00ff1b0380005003ULL,
0x000001d000103104ULL, 0x000039b0000038b0ULL, 0x00482904000039d0ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffff0500000eULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x000001d000482804ULL, 0x000023e000002330ULL, 0x000039d0000024b0ULL, 0x000046d0000046c0ULL,
0x0000471000004700ULL, 0x0000475000004740ULL, 0x00004a20000049e0ULL, 0x00004a8000004a70ULL,
0x00004ac000004ab0ULL, 0x05f0390400005170ULL, 0x000000ff00000340ULL, 0x000401000000cda0ULL,
0x000000ff00000370ULL, 0x000401000000cda8ULL, 0x000000ff00000390ULL, 0x000401000000cdb0ULL,
0x000000ff000003d0ULL, 0x000401000000cdb8ULL, 0x000000ff000003f0ULL, 0x000401000000cdc0ULL,
0x000000ff00000410ULL, 0x000401000000cdc8ULL, 0x000000ff00000430ULL, 0x000401000000cdd0ULL,
0x000000ff00000450ULL, 0x000401000000cdd8ULL, 0x000000ff00000470ULL, 0x000401000000cde0ULL,
0x000000ff00000490ULL, 0x000401000000cde8ULL, 0x000000ff000004b0ULL, 0x000401000000cdf0ULL,
0x000000ff000004d0ULL, 0x000401000000cdf8ULL, 0x000000ff000004f0ULL, 0x000401000000ce00ULL,
0x000000ff00000510ULL, 0x000401000000ce08ULL, 0x000000ff00000530ULL, 0x000401000000ce10ULL,
0x000000ff00000550ULL, 0x000401000000ce18ULL, 0x0000000b00000920ULL, 0x003f01010000cdd8ULL,
0x0000000b00000930ULL, 0x003f01090000cdd8ULL, 0x0000000200000bb0ULL, 0x003f01010000cdb8ULL,
0x0000000200000bf0ULL, 0x003f01090000cdb8ULL, 0x0000000200000d30ULL, 0x003f01010000cdc8ULL,
0x0000000200000d40ULL, 0x003f01090000cdc8ULL, 0x00000002000010d0ULL, 0x003f01010000cda8ULL,
0x00000002000010f0ULL, 0x003f01090000cda8ULL, 0x0000000200001be0ULL, 0x003f01010000cda0ULL,
0x0000000200001c40ULL, 0x003f01010000cdd8ULL, 0x0000000200001c60ULL, 0x003f01010000cde8ULL,
0x0000000200001c70ULL, 0x003f01010000cdf8ULL, 0x0000000200001c80ULL, 0x003f01010000ce08ULL,
0x0000000200001cb0ULL, 0x003f01010000ce18ULL, 0x0000000200001cc0ULL, 0x003f01090000ce18ULL,
0x0000000d000021d0ULL, 0x003f01090000cdd0ULL, 0x0000001100002200ULL, 0x003f01010000cdf0ULL,
0x0000001100002280ULL, 0x003f01090000cdf0ULL, 0x0000000200002300ULL, 0x003f01010000ce18ULL,
0x0000000200002560ULL, 0x003f01090000ce18ULL, 0x0000000200002770ULL, 0x003f01010000ce18ULL,
0x0000000200002870ULL, 0x003f01090000ce18ULL, 0x0000000200003020ULL, 0x003f01010000ce18ULL,
0x0000000200003070ULL, 0x003f01090000ce18ULL, 0x0000000200003780ULL, 0x003f01010000ce18ULL,
0x0000000200003790ULL, 0x003f01090000ce18ULL, 0x0000000200003850ULL, 0x003f01010000ce18ULL,
0x0000000200003860ULL, 0x003f01090000ce18ULL, 0x0000000800003ad0ULL, 0x003f01010000cdf8ULL,
0x0000000800003ae0ULL, 0x003f01010000cdd8ULL, 0x0000000200003b60ULL, 0x003f01010000cda8ULL,
0x0000000200003b80ULL, 0x003f01010000cdb8ULL, 0x0000000200003b90ULL, 0x003f01010000cdc8ULL,
0x0000000200003bb0ULL, 0x003f01010000ce10ULL, 0x0000000200003bc0ULL, 0x003f01090000ce10ULL,
0x0000000200003be0ULL, 0x003f01010000cda0ULL, 0x0000000200003bf0ULL, 0x003f01090000cda0ULL,
0x0000000200003ce0ULL, 0x003f01090000cdb0ULL, 0x0000000200004160ULL, 0x003f01010000cdb8ULL,
0x0000000200004180ULL, 0x003f01090000cdc0ULL, 0x0000000200004580ULL, 0x003f01010000cdc8ULL,
0x0000000200004880ULL, 0x003f01010000ce10ULL, 0x00000002000048c0ULL, 0x003f01090000ce10ULL,
0x00000002000048f0ULL, 0x003f01010000ce10ULL, 0x0000000200004900ULL, 0x003f01090000ce10ULL,
0x0000001700004bd0ULL, 0x003f01010000cdf8ULL, 0x0000001700004be0ULL, 0x003f01090000cdf8ULL,
0x0000001700004db0ULL, 0x003f01010000cdf0ULL, 0x0000000200004de0ULL, 0x003f01010000cda8ULL,
0x0000000200004f20ULL, 0x003f01080000cda0ULL, 0x0000000000005020ULL, 0x003f010000004100ULL,
0x0000000000005090ULL, 0x003f010000004108ULL, 0x0000000000005140ULL, 0x003f010100004108ULL,
0x0000000300005400ULL, 0x0007010a00004108ULL, 0x000000ff00005510ULL, 0x0008010700004100ULL,
0x00000003000057d0ULL, 0x0007010a00004100ULL, 0x000000ff00005ba0ULL, 0x0008010100004108ULL,
0x0000000000005e10ULL, 0x003f010800004108ULL, 0x0000000000005e20ULL, 0x003f010800004100ULL,
0x0000000b00005e40ULL, 0x003f01090000cdd8ULL, 0x0000000200005ea0ULL, 0x003f01090000cdb8ULL,
0x0000000200005f00ULL, 0x003f01090000cdc8ULL, 0x0000000200005f60ULL, 0x003f01090000cda8ULL,
0x0000000200005fc0ULL, 0x003f01090000ce18ULL, 0x0000000d00006020ULL, 0x003f01090000cdd0ULL,
0x0000001100006080ULL, 0x003f01090000cdf0ULL, 0x00000002000060e0ULL, 0x003f01090000ce18ULL,
0x0000000200006140ULL, 0x003f01090000ce18ULL, 0x00000002000061a0ULL, 0x003f01090000ce18ULL,
0x0000000200006200ULL, 0x003f01090000ce18ULL, 0x0000000200006260ULL, 0x003f01090000ce10ULL,
0x00000002000062c0ULL, 0x003f01090000cda0ULL, 0x0000000200006320ULL, 0x003f01090000cdb0ULL,
0x0000000200006380ULL, 0x003f01090000cdc0ULL, 0x00000002000063e0ULL, 0x003f01090000ce10ULL,
0x0000000200006440ULL, 0x003f01090000ce10ULL, 0x00000017000064a0ULL, 0x003f01090000cdf8ULL,
0x0000000500006530ULL, 0x003f010a00004108ULL, 0x00000005000065c0ULL, 0x003f010a00004100ULL,
0x00141c0400123803ULL, 0x00004f3000000130ULL, 0x00005de000004f90ULL, 0x00041e0400005e30ULL,
0x00f8190300000000ULL, 0x0000000d00080a04ULL, 0x0004360400f80210ULL, 0x0000000000000008ULL,
0x00000000ffffffffULL, 0x00000000fffffffeULL, 0x00000000fffffffdULL, 0x00000000fffffffcULL,
0x0000000000000008ULL, 0x0000000700000002ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000500000002ULL, 0x0000000000000000ULL, 0x00000000000000d4ULL, 0x0000000c00000002ULL,
0x0000000000006620ULL, 0x0000000000000044ULL, 0x0000000c00000002ULL, 0x0000000000000000ULL,
0x00000000000000aaULL, 0x0000000c00000002ULL, 0x0000000000000000ULL, 0x0000000043e00000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e240000000800ULL, 0x0000000000097919ULL, 0x000e620000002700ULL,
0x00008c00ff027b82ULL, 0x000e620000000a00ULL, 0x00008200000e7ab9ULL, 0x000fe20000000a00ULL,
0x0000000409027825ULL, 0x002fca00078e0002ULL, 0x0000000e02007981ULL, 0x000ea2000c1e1900ULL,
0x00000000001079c3ULL, 0x000e620000002500ULL, 0x0000030000127ab9ULL, 0x000fe20000000800ULL,
0x00000000000472caULL, 0x004fda00000e0000ULL, 0x0000003f04047890ULL, 0x000fc8000fffe03fULL,
0x000000063f117899ULL, 0x000fe40008011604ULL, 0x0000007f0400788cULL, 0x000fe4000bf04070ULL,
0x000000121100728cULL, 0x000fe4000bf21070ULL, 0x000000011200788cULL, 0x000fe40008704070ULL,
0x0000001211067287ULL, 0x000fe40008800000ULL, 0x0000003f10137287ULL, 0x002fc40008000000ULL,
0x0000000106067887ULL, 0x000fc80008000000ULL, 0x000000061300728cULL, 0x000fcc000bf26070ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000067919ULL, 0x000e620000002300ULL, 0x0000000600047d06ULL, 0x000ea20008209000ULL,
0x0000042000007945ULL, 0x000fe20003800000ULL, 0x0000000000077919ULL, 0x000e620000002200ULL,
0x0000000000437919ULL, 0x000eea0000002100ULL, 0x0000000400047308ULL, 0x004ea20000001000ULL,
0x0000000607ff7212ULL, 0x002fc8000780fcffULL, 0x000000204300780cULL, 0x008fda0000705670ULL,
0x00006600ff028b82ULL, 0x000e620000000a00ULL, 0x00000000003f7886ULL, 0x000fe20000020000ULL,
0x0000007002058810ULL, 0x002fc80007f3e0ffULL, 0x00000000050482caULL, 0x000fe200000e0000ULL,
0x000000ffff028224ULL, 0x000fe200008e0603ULL, 0x0000004306ff7212ULL, 0x000fe2000782fe07ULL,
0x0ffffffe04057836ULL, 0x004fc60000000000ULL, 0x00000000020582caULL, 0x000fc600000e0000ULL,
0x0000000500057305ULL, 0x000e68000021f000ULL, 0x00000004ff027e24ULL, 0x000fca000f8e00ffULL,
0x00000000020482caULL, 0x000fe200000e0000ULL, 0x00000005ff037e24ULL, 0x000fca000f8e00ffULL,
0x00000000030582caULL, 0x000fda00000e0000ULL, 0x00000000040099b9ULL, 0x0003e40008040000ULL,
0x0000000000b41947ULL, 0x002fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x001ffe8000087882ULL, 0x000fe20000000000ULL,
0x7ffa000000097882ULL, 0x000fe20000000000ULL, 0x001fff00000a7882ULL, 0x000fe20000000000ULL,
0x7ffc0000000b7882ULL, 0x000fe20000000000ULL, 0x001ffefe000c7882ULL, 0x000fe20000000000ULL,
0x7ffbf800000d7882ULL, 0x000fe20000000000ULL, 0x0000065405047896ULL, 0x002fe20008000004ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000000073c6ULL, 0x000e740000000000ULL,
0x00cda008043f75b2ULL, 0x000e620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00cda808043f75b2ULL, 0x0004620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x001ffe0000087882ULL, 0x004fe20000000000ULL, 0x7ff8000000097882ULL, 0x000fe20000000000ULL,
0x00cdb00a043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00cdb80c043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00cdc00a043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00cdc80c043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00cdd00a043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00cdd80c043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00cde00a043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00cde80c043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00cdf008043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00cdf808043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00ce0008043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00ce0808043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00ce100a043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00ce180a043f75b2ULL, 0x0002640008000100ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000050572caULL, 0x000fe200000e0000ULL,
0x800000063f087290ULL, 0x000fe2000fffe03fULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x000000133f077292ULL, 0x000fe2000f8e333fULL, 0x000000ff0600720cULL, 0x000fe20003f05270ULL,
0x0000003f0600728cULL, 0x000fc6000bf65070ULL, 0x0000003f00047c82ULL, 0x000fca0008000000ULL,
0x00000005080872a4ULL, 0x000fc8000f8e023fULL, 0x00000008050872a5ULL, 0x000fe4000f8e0004ULL,
0x0000001106047290ULL, 0x000fc8000fffe007ULL, 0x00000004090872a5ULL, 0x000fce000f8e003fULL,
0x0000000900057c82ULL, 0x000fe40008000000ULL, 0x0000003f05077290ULL, 0x000fe4000fffe13fULL,
0x00000000000879c3ULL, 0x000e640000008800ULL, 0x00000007060772a4ULL, 0x000fc8000f8e0204ULL,
0x000000060700728cULL, 0x000fd6000bf26070ULL, 0x0000000706071290ULL, 0x000fe4000fffe13fULL,
0x0000000105051890ULL, 0x000fe4000fffe03fULL, 0x000000060700728cULL, 0x000fc6000bf46070ULL,
0x0000040000077882ULL, 0x000fe40000000000ULL, 0x0000065408077896ULL, 0x002fcc0008000007ULL,
0x0000000105052890ULL, 0x000fe2000fffe03fULL, 0x00000007ff027e24ULL, 0x000fe2000f8e00ffULL,
0x000000063f05b292ULL, 0x000fc6000f8e333fULL, 0x0000000443467824ULL, 0x000fe200078e0202ULL,
0x0000003000fc8947ULL, 0x000ff00003800000ULL, 0x0000000000087919ULL, 0x000e620000002600ULL,
0x000000010600780cULL, 0x000fe20003f05270ULL, 0x000033b000007945ULL, 0x000fd80003800000ULL,
0x0000001400248947ULL, 0x000fea0003800000ULL, 0x000000404300780cULL, 0x000fe20003f06070ULL,
0x000000ffff037224ULL, 0x000fe200078e00ffULL, 0x0000000000147805ULL, 0x000fe4000001ff00ULL,
0x0000000000167805ULL, 0x000fe4000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x000000ffff1a7224ULL, 0x000fcc00078e00ffULL, 0x0000000400a48947ULL, 0x000fea0003800000ULL,
0x000000404300780cULL, 0x000fda0003f05270ULL, 0x0000000000d08947ULL, 0x000fea0003800000ULL,
0x000000040600728cULL, 0x000fcc000bf24070ULL, 0x000000000000781cULL, 0x000fc80003f0f018ULL,
0x000000604300780cULL, 0x000fda0000705670ULL, 0x0000003000b00947ULL, 0x000fea0003800000ULL,
0x0000660000087ab9ULL, 0x000fe20000000a00ULL, 0x0000000109037811ULL, 0x000fe200078e08ffULL,
0x0000007008077890ULL, 0x000fe2000ff3e03fULL, 0x000000ffff067224ULL, 0x000fe400078e00ffULL,
0x00000001ff077424ULL, 0x000fe200078e00ffULL, 0x000000093f087290ULL, 0x000fe40008ffe43fULL,
0x00000007ff0e7e24ULL, 0x000fc8000f8e00ffULL, 0x00000008ff0f7e24ULL, 0x000fce000f8e00ffULL,
0x0000001006047824ULL, 0x040fe200078e00ffULL, 0x0000000106097812ULL, 0x000fe200078ec0ffULL,
0x00000013ff0d7e24ULL, 0x000fc6000f8e00ffULL, 0x0000001004057812ULL, 0x000fe200078ec0ffULL,
0x0000420009087824ULL, 0x002fc800078e0202ULL, 0x00000001020b7824ULL, 0x000fc800078e0205ULL,
0x00cdd8070b0479a7ULL, 0x000e64000850003fULL, 0x00cdd8050b0075a7ULL, 0x002e64000800017fULL,
0x00000054003c8947ULL, 0x002fea0003800000ULL, 0x00000000000c79c3ULL, 0x000e620000002600ULL,
0x0000001009097824ULL, 0x000fe200078e0202ULL, 0x00000000080772caULL, 0x000fe200000e0000ULL,
0x0000000606047c24ULL, 0x000fe2000f8e020dULL, 0x000000000e1472caULL, 0x000fe200000e0000ULL,
0x0000003f000a7c82ULL, 0x000fe20008000000ULL, 0x00000000090972caULL, 0x000fe400000e0000ULL,
0x00000000040b72caULL, 0x000fe400000e0000ULL, 0x000000000f1572caULL, 0x000fc400000e0000ULL,
0x00000000030d72caULL, 0x000fe400000e0000ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x0000420007087890ULL, 0x000fc8000fffe03fULL, 0x0000cdd009097890ULL, 0x000fe4000fffe03fULL,
0x000000060b0b7899ULL, 0x002fd8000800063fULL, 0x00000000003f082fULL, 0x000fe20003820000ULL,
0x00000008140075b4ULL, 0x0003d80008018000ULL, 0x000000000000181cULL, 0x000fe40000f0e170ULL,
0x000000000000781cULL, 0x000fd60003f2e170ULL, 0xfffffffd00ec0947ULL, 0x002fea000393ffffULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x0000620007087890ULL, 0x000fe2000fffe03fULL,
0x00000080000a7882ULL, 0x000fd60000000000ULL, 0x00000000003f082fULL, 0x000fe20003820000ULL,
0x00000008140075b4ULL, 0x0003d80008018000ULL, 0x000000000000181cULL, 0x000fe40000f0e170ULL,
0x000000000000781cULL, 0x000fd60003f2e170ULL, 0xfffffffd00ec0947ULL, 0x002fea000393ffffULL,
0x0000000106067836ULL, 0x000fca0000000000ULL, 0x0000000506007c0cULL, 0x000fda000bf06070ULL,
0xfffffffc00648947ULL, 0x001fea000383ffffULL, 0x0000002c00f07947ULL, 0x000fea0003800000ULL,
0x000000040600728cULL, 0x000fcc000bf24070ULL, 0x000000000000781cULL, 0x000fda0003f0f018ULL,
0x0000002c00e40947ULL, 0x000fea0003800000ULL, 0x00006600ff0c7b82ULL, 0x000ea20000000a00ULL,
0x0000000209037824ULL, 0x000fe400078e00ffULL, 0x000000ffff087224ULL, 0x002fe400078e00ffULL,
0x00000001ff0b7424ULL, 0x000fce00078e00ffULL, 0x00cdb80b020479a7ULL, 0x000e62000850003fULL,
0x00000013ff097e24ULL, 0x000fe2000f8e00ffULL, 0x000000700c067810ULL, 0x004fc60007f3e0ffULL,
0x0000000608097c24ULL, 0x000fe2000f8e0209ULL, 0x00cdb805020075a7ULL, 0x002e64000800017fULL,
0x0000005000a48947ULL, 0x002fee0003800000ULL, 0x00000000000c79c3ULL, 0x000e620000002600ULL,
0x000000ffff077224ULL, 0x000fe200008e060dULL, 0x00000000020872caULL, 0x000fe200000e0000ULL,
0x0000004009097824ULL, 0x000fe200078e00ffULL, 0x00000000061472caULL, 0x000fe200000e0000ULL,
0x0000000108087836ULL, 0x000fe20000000000ULL, 0x00000000071572caULL, 0x000fe200000e0000ULL,
0x0000003f000a7c82ULL, 0x000fe20008000000ULL, 0x00000000090b72caULL, 0x000fe400000e0000ULL,
0x00000000030d72caULL, 0x000fc400000e0000ULL, 0x000000000000781cULL, 0x000fe40003f0f070ULL,
0x0000000508007c0cULL, 0x000fe2000bf26070ULL, 0x0000cdb008097890ULL, 0x002fd8000fffe03fULL,
0x00000000003f082fULL, 0x000fe20003840000ULL, 0x00000008140075b4ULL, 0x0003d80008018000ULL,
0x000000000000281cULL, 0x000fe4000170e170ULL, 0x000000000000781cULL, 0x000fd60003f4e170ULL,
0xfffffffd00ec0947ULL, 0x002fea000393ffffULL, 0x00cdc80b020479a7ULL, 0x000e64000850003fULL,
0x00cdc805020075a7ULL, 0x002e64000800017fULL, 0x0000005000688947ULL, 0x002fea0003800000ULL,
0x00000000000c79c3ULL, 0x000e620000002600ULL, 0x00000000020972caULL, 0x000fe200000e0000ULL,
0x00000080000a7882ULL, 0x000fe20000000000ULL, 0x00000000061472caULL, 0x000fe400000e0000ULL,
0x00000000071572caULL, 0x000fe400000e0000ULL, 0x00000000090b72caULL, 0x000fe400000e0000ULL,
0x00000000030d72caULL, 0x000fe400000e0000ULL, 0x000000000000781cULL, 0x000fc60003f0f070ULL,
0x0000200009087890ULL, 0x000fe4000fffe03fULL, 0x0000cdc009097890ULL, 0x002fd8000fffe03fULL,
0x00000000003f082fULL, 0x000fe20003840000ULL, 0x00000008140075b4ULL, 0x0003d80008018000ULL,
0x000000000000281cULL, 0x000fe4000170e170ULL, 0x000000000000781cULL, 0x000fd60003f4e170ULL,
0xfffffffd00ec0947ULL, 0x002fea000393ffffULL, 0xfffffffc00549947ULL, 0x001fea000383ffffULL,
0x0000002c00247947ULL, 0x000fea0003800000ULL, 0x00008800ff0c7b82ULL, 0x000ea20000000a00ULL,
0x0000840000077ab9ULL, 0x000fe40000000800ULL, 0x0000000709047c24ULL, 0x002fc8000f8e0208ULL,
0x00000100040f7824ULL, 0x000fc800078e0243ULL, 0x000000100f047825ULL, 0x004fcc00078e000cULL,
0x0000000e04047981ULL, 0x000f62000c1e9d00ULL, 0x00000040431b7836ULL, 0x000fe20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x00000001ff1d7424ULL, 0x000fc600078e00ffULL,
0x000000ff1b00780cULL, 0x000fda0003f04070ULL, 0x0000000000680947ULL, 0x000fea0003800000ULL,
0x000000400f097836ULL, 0x000fc80000000000ULL, 0x0000001009087825ULL, 0x000fcc00078e000cULL,
0x0000000e08087981ULL, 0x000f62000c1e9d00ULL, 0x00000080430e7836ULL, 0x000fca0000000000ULL,
0x000000ff0e00780cULL, 0x000fda0003f24070ULL, 0x0000000000501947ULL, 0x000fea0003800000ULL,
0x000000c0430e7836ULL, 0x000fca0000000000ULL, 0x000000ff0e00780cULL, 0x000fda0003f24070ULL,
0x000000c00f119836ULL, 0x000fc80000000000ULL, 0x0000001011109825ULL, 0x000fc800078e000cULL,
0x000000800f0f7836ULL, 0x000fe40000000000ULL, 0x0000000e10109981ULL, 0x000ea4000c1e9d00ULL,
0x000000100f0c7825ULL, 0x000fcc00078e000cULL, 0x0000000e0c0c7981ULL, 0x000f62000c1e9d00ULL,
0x0001000010039824ULL, 0x044fe200078e00ffULL, 0x0000773210109816ULL, 0x000fe200000000ffULL,
0x0001000011159824ULL, 0x040fe200078e00ffULL, 0x0000773211119816ULL, 0x000fe200000000ffULL,
0x0001000012179824ULL, 0x040fe200078e00ffULL, 0x0000773212129816ULL, 0x000fe200000000ffULL,
0x0001000013199824ULL, 0x040fe200078e00ffULL, 0x0000773213139816ULL, 0x000fe200000000ffULL,
0x0001000010149824ULL, 0x000fe400078e00ffULL, 0x0001000011169824ULL, 0x000fc400078e00ffULL,
0x0001000012189824ULL, 0x000fe400078e00ffULL, 0x00010000131a9824ULL, 0x000fce00078e00ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00cda81d021079a7ULL, 0x000e62000850003fULL,
0x000000ff4300780cULL, 0x000fe20003f44070ULL, 0x00cda811020075a7ULL, 0x002e64000802017fULL,
0x0000004c00949947ULL, 0x002ff40003800000ULL, 0x00000ac000017945ULL, 0x000fe80003800000ULL,
0x0000000800a82947ULL, 0x000fea0003800000ULL, 0x0000773204117816ULL, 0x060fe200000000ffULL,
0x0001000004107824ULL, 0x000fe200078e00ffULL, 0x00000001ff047819ULL, 0x100fe20000011643ULL,
0x0001000005127824ULL, 0x040fe200078e00ffULL, 0x00007732051e7816ULL, 0x000fe200000000ffULL,
0x0001000011117824ULL, 0x000fe200078e00ffULL, 0x00000010ff10723eULL, 0x000fe20004807110ULL,
0x00010000071c7824ULL, 0x000fe200078e00ffULL, 0x00000005ff057819ULL, 0x000fe20000011643ULL,
0x0001000006137824ULL, 0x000fe200078e00ffULL, 0x00000011ff11723eULL, 0x000fc40004807111ULL,
0x0000000704047812ULL, 0x000fe400078ec0ffULL, 0x000000ff10107812ULL, 0x000fe400078ec0ffULL,
0x0000ffff11117812ULL, 0x000fe400078ec0ffULL, 0x0000773206207816ULL, 0x000fe400000000ffULL,
0x0000773207077816ULL, 0x000fe400000000ffULL, 0x0000000504067212ULL, 0x000fc400078e3cffULL,
0x0000760411237816ULL, 0x000fe20000000010ULL, 0x000000ffff107224ULL, 0x100fe200078e001eULL,
0x00000012ff1e723eULL, 0x000fe2000480711eULL, 0x000000ffff117224ULL, 0x000fe200078e0020ULL,
0x00000013ff13723eULL, 0x000fe20004807113ULL, 0x000000ffff127224ULL, 0x000fe200078e0007ULL,
0x0000001cff1c723eULL, 0x000fe2000480711cULL, 0x00000008051f7824ULL, 0x000fe200078e0206ULL,
0x0000001043067812ULL, 0x000fe200078ec0ffULL, 0x0001000010107824ULL, 0x000fe200078e00ffULL,
0x000000ff1e1e7812ULL, 0x000fe200078ec0ffULL, 0x0001000011117824ULL, 0x000fe200078e00ffULL,
0x00000004ff077819ULL, 0x000fe20000011606ULL, 0x0001000012127824ULL, 0x000fe200078e00ffULL,
0x00000010ff10723eULL, 0x000fc40004807110ULL, 0x00000011ff11723eULL, 0x000fe20004807111ULL,
0x0000040007067824ULL, 0x000fe200078e0202ULL, 0x00000012ff12723eULL, 0x000fe40004807112ULL,
0x000000ff13137812ULL, 0x000fe400078ec0ffULL, 0x000000ff1c1c7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff10217812ULL, 0x000fe200078ec0ffULL, 0x000000101f107824ULL, 0x000fe200078e0206ULL,
0x0000ffff11207812ULL, 0x000fc400078ec0ffULL, 0x0000ffff12077812ULL, 0x000fe400078ec0ffULL,
0x0000000143057812ULL, 0x000fe400078ec0ffULL, 0x00007604211e7816ULL, 0x000fe4000000001eULL,
0x0000760420207816ULL, 0x000fe20000000013ULL, 0x0000000805107824ULL, 0x000fe200078e0210ULL,
0x0000760407077816ULL, 0x000fe4000000001cULL, 0x00005410231e7816ULL, 0x000fc4000000001eULL,
0x00005410201f7816ULL, 0x000fca0000000007ULL, 0x00c4001e10007388ULL, 0x0003e20000000a00ULL,
0x0000000400e00947ULL, 0x000fea0003800000ULL, 0x0000773208077816ULL, 0x040fe200000000ffULL,
0x0001000008087824ULL, 0x000fe200078e00ffULL, 0x0000773209137816ULL, 0x040fe200000000ffULL,
0x0001000009107824ULL, 0x002fe200078e00ffULL, 0x00000005ff1b7819ULL, 0x000fe2000001161bULL,
0x0001000007077824ULL, 0x000fe400078e00ffULL, 0x000100000a097824ULL, 0x000fe200078e00ffULL,
0x00000008ff0a723eULL, 0x000fe4000480710aULL, 0x00000007ff11723eULL, 0x000fc40004807111ULL,
0x0000001b04087212ULL, 0x000fe400078e3cffULL, 0x0000ffff11127812ULL, 0x000fe400078ec0ffULL,
0x000077320a1e7816ULL, 0x040fe200000000ffULL, 0x000000081b1b7824ULL, 0x000fe200078e0208ULL,
0x000000ff0a077812ULL, 0x000fe200078ec0ffULL, 0x000100000b0a7824ULL, 0x040fe200078e00ffULL,
0x000077320b117816ULL, 0x000fe200000000ffULL, 0x000000ffff087224ULL, 0x000fe200078e001eULL,
0x00007604121c7816ULL, 0x000fe20000000007ULL, 0x000000ffff077224ULL, 0x000fe200078e0013ULL,
0x00000009ff0b723eULL, 0x000fe2000480710bULL, 0x000000ffff097224ULL, 0x000fe200078e0011ULL,
0x00000010ff10723eULL, 0x000fe20004807110ULL, 0x0001000007077824ULL, 0x000fe200078e00ffULL,
0x0000000aff0a723eULL, 0x000fe2000480710aULL, 0x0001000008087824ULL, 0x000fe200078e00ffULL,
0x000000ff10107812ULL, 0x000fe200078ec0ffULL, 0x0001000009097824ULL, 0x000fe200078e00ffULL,
0x00000007ff07723eULL, 0x000fc40004807107ULL, 0x00000008ff08723eULL, 0x000fe40004807108ULL,
0x00000009ff09723eULL, 0x000fe40004807109ULL, 0x000000ff0b0b7812ULL, 0x000fe400078ec0ffULL,
0x000000ff0a0a7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff07077812ULL, 0x000fe400078ec0ffULL,
0x0000ffff08127812ULL, 0x000fe200078ec0ffULL, 0x000000101b087824ULL, 0x000fe200078e0206ULL,
0x0000ffff09097812ULL, 0x000fc400078ec0ffULL, 0x0000760407077816ULL, 0x000fe20000000010ULL,
0x0000000805087824ULL, 0x000fe200078e0208ULL, 0x0000760412127816ULL, 0x000fe4000000000bULL,
0x0000760409097816ULL, 0x000fe4000000000aULL, 0x000054101c0a7816ULL, 0x000fe40000000007ULL,
0x00005410120b7816ULL, 0x000fe20000000009ULL, 0x0000008043097836ULL, 0x000fc80000000000ULL,
0x00c4000a08007388ULL, 0x0003e20000000a00ULL, 0x000000ff0900780cULL, 0x000fda0003f04070ULL,
0x0000000400280947ULL, 0x002fea0003800000ULL, 0x000077320c077816ULL, 0x040fe200000000ffULL,
0x000100000c0c7824ULL, 0x000fe200078e00ffULL, 0x00000005ff0b7819ULL, 0x000fe20000011609ULL,
0x000100000d087824ULL, 0x040fe200078e00ffULL, 0x000077320d117816ULL, 0x000fe200000000ffULL,
0x0001000007077824ULL, 0x000fe200078e00ffULL, 0x0000000cff0a723eULL, 0x000fe2000480710aULL,
0x000100000e097824ULL, 0x000fe200078e00ffULL, 0x0000000b040c7212ULL, 0x000fe400078e3cffULL,
0x00000007ff0d723eULL, 0x000fc4000480710dULL, 0x000000ff0a077812ULL, 0x000fe200078ec0ffULL,
0x000100000f0a7824ULL, 0x000fe200078e00ffULL, 0x000077320e127816ULL, 0x000fe200000000ffULL,
0x000000080b0b7824ULL, 0x100fe200078e020cULL, 0x0000ffff0d0e7812ULL, 0x000fe400078ec0ffULL,
0x000077320f0f7816ULL, 0x000fe400000000ffULL, 0x000076040e107816ULL, 0x000fe20000000007ULL,
0x000000ffff077224ULL, 0x000fe200078e0011ULL, 0x00000008ff0c723eULL, 0x000fe2000480710cULL,
0x000000ffff087224ULL, 0x000fe200078e0012ULL, 0x00000009ff0d723eULL, 0x000fe2000480710dULL,
0x000000ffff097224ULL, 0x000fe200078e000fULL, 0x0000000aff0a723eULL, 0x000fe2000480710aULL,
0x0001000007077824ULL, 0x000fe200078e00ffULL, 0x000000ff0c0c7812ULL, 0x000fe200078ec0ffULL,
0x0001000008087824ULL, 0x000fe200078e00ffULL, 0x000000ff0d0d7812ULL, 0x000fe200078ec0ffULL,
0x0001000009097824ULL, 0x000fe200078e00ffULL, 0x00000007ff07723eULL, 0x000fc40004807107ULL,
0x00000008ff08723eULL, 0x000fe40004807108ULL, 0x00000009ff09723eULL, 0x000fe40004807109ULL,
0x000000ff0a0a7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff07077812ULL, 0x000fe400078ec0ffULL,
0x0000ffff080e7812ULL, 0x000fe200078ec0ffULL, 0x000000100b087824ULL, 0x000fe200078e0206ULL,
0x0000ffff09097812ULL, 0x000fc400078ec0ffULL, 0x0000760407077816ULL, 0x000fe2000000000cULL,
0x0000000805087824ULL, 0x000fe200078e0208ULL, 0x000076040e0e7816ULL, 0x000fe4000000000dULL,
0x0000760409097816ULL, 0x000fe4000000000aULL, 0x0000541010107816ULL, 0x000fe20000000007ULL,
0x000000c043077836ULL, 0x000fe20000000000ULL, 0x000054100e117816ULL, 0x000fc80000000009ULL,
0x000000ff0700780cULL, 0x000fe20003f04070ULL, 0x00c4001008007388ULL, 0x0003d80000000a00ULL,
0x0000000000700947ULL, 0x002fea0003800000ULL, 0x00000005ff077819ULL, 0x000fe40000011607ULL,
0x00000003ff03723eULL, 0x000fe40004807103ULL, 0x0000000704047212ULL, 0x000fe400078e3cffULL,
0x00000014ff14723eULL, 0x000fe40004807114ULL, 0x00000015ff15723eULL, 0x000fe20004807115ULL,
0x0000000807077824ULL, 0x000fe200078e0204ULL, 0x00000016ff16723eULL, 0x000fc40004807116ULL,
0x00000019ff19723eULL, 0x000fe20004807119ULL, 0x0000001007067824ULL, 0x000fe200078e0206ULL,
0x0000001aff1a723eULL, 0x000fe4000480711aULL, 0x00000017ff17723eULL, 0x000fe20004807117ULL,
0x0000000805067824ULL, 0x000fe200078e0206ULL, 0x00000018ff18723eULL, 0x000fe40004807118ULL,
0x000000ff03037812ULL, 0x000fe400078ec0ffULL, 0x000000ff15157812ULL, 0x000fc400078ec0ffULL,
0x0000ffff16167812ULL, 0x000fe400078ec0ffULL, 0x0000ffff14147812ULL, 0x000fe400078ec0ffULL,
0x000000ff19197812ULL, 0x000fe400078ec0ffULL, 0x0000ffff1a1a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff17177812ULL, 0x000fe400078ec0ffULL, 0x0000ffff18187812ULL, 0x000fc400078ec0ffULL,
0x0000760416157816ULL, 0x000fe40000000015ULL, 0x0000760414147816ULL, 0x000fe40000000003ULL,
0x000076041a197816ULL, 0x000fe40000000019ULL, 0x0000760418187816ULL, 0x000fe40000000017ULL,
0x0000541014147816ULL, 0x000fe40000000015ULL, 0x0000541018157816ULL, 0x000fca0000000019ULL,
0x00c4001406007388ULL, 0x0003e40000000a00ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00cda01d02ff79a7ULL, 0x0005e2000850003fULL, 0x0000001c00c07947ULL, 0x000fea0003800000ULL,
0x00009200ff067b82ULL, 0x000ea40000000a00ULL, 0x0000000e06067981ULL, 0x004562000c1e9900ULL,
0x000000074300780cULL, 0x000fe20003f04070ULL, 0x00000001ff057424ULL, 0x000fc800078e00ffULL,
0x00cdd80502ff79a7ULL, 0x0005f0000850003fULL, 0xff800000ff038424ULL, 0x000fe200078e00ffULL,
0x00cde80502ff79a7ULL, 0x0005e2000850003fULL, 0x00cdf80502ff79a7ULL, 0x0005e2000850003fULL,
0x00ce080502ff79a7ULL, 0x0005e4000850003fULL, 0x00cd600346008388ULL, 0x0005e80000000800ULL,
0x00cd80ff46008388ULL, 0x0005e20000000800ULL, 0x00ce1805020479a7ULL, 0x000ee4000850003fULL,
0x00ce1805020075a7ULL, 0x008ee4000800017fULL, 0x0000004000b88947ULL, 0x00cfea0003800000ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x00000000000079c5ULL, 0x000fe20000000000ULL,
0x000000040600728cULL, 0x000fe2000bf24070ULL, 0x00000005ff037819ULL, 0x000fca0000011643ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x0000001c00700947ULL, 0x000fea0003800000ULL,
0x0000840000087ab9ULL, 0x000fe20000000800ULL, 0x0000900000077ab9ULL, 0x000fe20000000800ULL,
0x0000000809087c24ULL, 0x002fe2000f8e0208ULL, 0x00000007080772a4ULL, 0x000fe2000f8e023fULL,
0x0000001f43447812ULL, 0x000fe200078ec0ffULL, 0x0000c000000a7ab9ULL, 0x000fe20000000a00ULL,
0x0000000403427836ULL, 0x040fe20000000000ULL, 0x00000000081572caULL, 0x000fe200000e0000ULL,
0x00000fff07087891ULL, 0x000fe2000f8e103fULL, 0x0000000aff4e7e24ULL, 0x000fe2000f8e00ffULL,
0x00000001ff077819ULL, 0x000fe20000011644ULL, 0x0000000bff4f7e24ULL, 0x000fe2000f8e00ffULL,
0xfffff00008087892ULL, 0x000fe2000f8ec03fULL, 0x0000001003087824ULL, 0x040fe200078e00ffULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x0000000803407836ULL, 0x040fe20000000000ULL,
0x0000000307397812ULL, 0x000fe200078e7803ULL, 0x0000000c033e7836ULL, 0x000fe20000000000ULL,
0x0000000307077812ULL, 0x000fe200078e7842ULL, 0x00000040083c7836ULL, 0x040fe20000000000ULL,
0x00000012151472a4ULL, 0x000fe2000f8e0210ULL, 0x00000080083b7836ULL, 0x040fe20000000000ULL,
0x00008600000c7ab9ULL, 0x000fe20000000a00ULL, 0x000000c0083a7836ULL, 0x000fe20000000000ULL,
0x0000001408097291ULL, 0x000fe2000f8fd03fULL, 0x000000ff4300720cULL, 0x040fe20000722270ULL,
0x3b12492506457820ULL, 0x020fe20000410000ULL, 0x000000084300780cULL, 0x000fe20000701070ULL,
0x000000ffff067224ULL, 0x000fe200078e00ffULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000009ff047e24ULL, 0x000fe2000f8e00ffULL, 0x0000000612097899ULL, 0x000fe2000800063fULL,
0x0000000000267805ULL, 0x000fc4000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000804057824ULL, 0x000fe200078e0243ULL, 0x00000009070972a4ULL, 0x000fe2000f8e0208ULL,
0x0000000143047812ULL, 0x000fe200078ec0ffULL, 0x0000000315077899ULL, 0x000fe2000800063fULL,
0x00000008054e7825ULL, 0x000fe200078e004eULL, 0x00000fff09097890ULL, 0x000fe2000fffe03fULL,
0x0000000000057919ULL, 0x000e620000000000ULL, 0x00000200070c78a5ULL, 0x000fe2000f8e000cULL,
0x00000008ff437819ULL, 0x000fe20000011643ULL, 0x0000001409097291ULL, 0x000fe2000f8fa03fULL,
0x0000000000227805ULL, 0x000fc4000001ff00ULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x0000000309097899ULL, 0x000fe2000800063fULL,
0x0000000000187805ULL, 0x000fe4000001ff00ULL, 0x00000000001a7805ULL, 0x000fe4000001ff00ULL,
0x0000000839397212ULL, 0x000fe200078efcffULL, 0x00000200090878a5ULL, 0x000fe2000f8e000aULL,
0x00000003ff417819ULL, 0x000fe20000011642ULL, 0x0000001042387824ULL, 0x000fe200078e0207ULL,
0x00000003ff3f7819ULL, 0x000fe20000011640ULL, 0xffffffff05167890ULL, 0x000fe2000fffe03fULL,
0x00000003ff3d7819ULL, 0x000fe2000001163eULL, 0xffffffff06177890ULL, 0x000fe2000fffe03fULL,
0x00000004ff3c7819ULL, 0x000fe2000001163cULL, 0x00000004150a78a5ULL, 0x000fe2000f8e000aULL,
0x00000004ff3b7819ULL, 0x000fe2000001163bULL, 0x0000000c08187287ULL, 0x000fe20008000000ULL,
0x00000004ff3a7819ULL, 0x000fe2000001163aULL, 0x0000000d090d7287ULL, 0x000fd80008000000ULL,
0x0000001006077824ULL, 0x040fe200078e00ffULL, 0x00000001060b7812ULL, 0x000fe200078ec0ffULL,
0x00000080ff087424ULL, 0x000fe200078e00ffULL, 0x0000008000017945ULL, 0x000fe40003800000ULL,
0x0000001007077812ULL, 0x000fe200078ec0ffULL, 0x000000100b117824ULL, 0x000fc800078e0202ULL,
0x00000001020d7824ULL, 0x000fe400078e0207ULL, 0x00000001ff077424ULL, 0x000fe400078e00ffULL,
0x00cdd0080d0879a7ULL, 0x000ea4000800003fULL, 0x00cdd0090d0075a7ULL, 0x004ea4000804017fULL,
0x0000003c008ca947ULL, 0x004fea0003800000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00cdf007110879a7ULL, 0x000ea2000850003fULL, 0x000000070500780cULL, 0x002fe20003f44070ULL,
0x0000008000017945ULL, 0x000fe20003800000ULL, 0x000000ffff0c7224ULL, 0x000fe400078e00ffULL,
0x000000ffff0f7224ULL, 0x000fd200078e00ffULL, 0x000000200b0aa824ULL, 0x100fe400078e0202ULL,
0x000000040512a824ULL, 0x040fe400078e0202ULL, 0x00000004050ea824ULL, 0x000fe200078e020aULL,
0x00cdf009110075a7ULL, 0x004e64000806017fULL, 0x0000003c0078b947ULL, 0x002fea0003800000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00cc00000e0ca984ULL, 0x000fe20000000800ULL,
0x000000ffff0a7224ULL, 0x000fe400078e00ffULL, 0x00000004050da824ULL, 0x000fe200078e0202ULL,
0x00cd6000120fa984ULL, 0x000e680000000800ULL, 0x00cd80000d0aa984ULL, 0x0004a20000000800ULL,
0x00ce1807020879a7ULL, 0x0004a4000850003fULL, 0x0000000c0f00720bULL, 0x006fda0003f7e000ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x0000000000107806ULL, 0x000fc800058e0100ULL,
0x000000ff1000720cULL, 0x000fda0003f65270ULL, 0x00000000007cb947ULL, 0x000fea0003800000ULL,
0x8000000c0f0f7221ULL, 0x000fe20000010000ULL, 0x0000005510ff7812ULL, 0x040fe4000786c0ffULL,
0x000000aa10ff7812ULL, 0x000fe2000788c0ffULL, 0x3fb8aa3b0f0f7820ULL, 0x000fc80000410000ULL,
0x0000000f00127308ULL, 0x0002ac0000000800ULL, 0x00000000002cb947ULL, 0x000fea0003800000ULL,
0x00000002050d7824ULL, 0x000fca00078e00ffULL, 0x000000060d0d7812ULL, 0x000fcc00078ec0ffULL,
0x00001f0d120d7589ULL, 0x004ea400000e0000ULL, 0x0000000d24247220ULL, 0x084fe20000410000ULL,
0x0000000d26267220ULL, 0x080fe20000410000ULL, 0x0000000d20207220ULL, 0x080fe20000410000ULL,
0x0000000d22227220ULL, 0x080fe20000410000ULL, 0x0000000d1c1c7220ULL, 0x080fe20000410000ULL,
0x0000000d1e1e7220ULL, 0x080fe20000410000ULL, 0x0000000d18187220ULL, 0x080fe20000410000ULL,
0x0000000d1a1a7220ULL, 0x000fce0000410000ULL, 0x000000000030c947ULL, 0x000fea0003800000ULL,
0x00000002050d7824ULL, 0x000fca00078e00ffULL, 0x000000060d0d7812ULL, 0x000fca00078ec0ffULL,
0x000000010d0d7836ULL, 0x000fca0000000000ULL, 0x00001f0d120e7589ULL, 0x004ea400000e0000ULL,
0x0000000e25257220ULL, 0x084fe20000410000ULL, 0x0000000e27277220ULL, 0x080fe20000410000ULL,
0x0000000e21217220ULL, 0x080fe20000410000ULL, 0x0000000e23237220ULL, 0x080fe20000410000ULL,
0x0000000e1d1d7220ULL, 0x080fe20000410000ULL, 0x0000000e1f1f7220ULL, 0x080fe20000410000ULL,
0x0000000e19197220ULL, 0x080fe20000410000ULL, 0x0000000e1b1b7220ULL, 0x000fce0000410000ULL,
0x000000120a0a7220ULL, 0x004fce0000410000ULL, 0x0000006000017945ULL, 0x000fe20003800000ULL,
0x00ce1809020075a7ULL, 0x0004a2000806017fULL, 0x0000a0000000791aULL, 0x000fc80000000000ULL,
0x009896800000b95dULL, 0x000fea0003900000ULL, 0x00ce18090200b5a7ULL, 0x000e24000806007fULL,
0xfffffffc00ecb947ULL, 0x001fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000030300780cULL, 0x000fe20003f65270ULL, 0x0000019000017945ULL, 0x000fd80003800000ULL,
0x00000000005c3947ULL, 0x000fea0003800000ULL, 0x000000ff1000720cULL, 0x000fe20001762670ULL,
0x000000800b08a824ULL, 0x140fe400078e0202ULL, 0x000000800b0ea824ULL, 0x000fe400078e0202ULL,
0x00000004050da824ULL, 0x000fe200078e0208ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x000000800b12a824ULL, 0x000fe400078e0202ULL, 0x000000040510a824ULL, 0x000fe200078e020eULL,
0x00000000000e7805ULL, 0x002fe2000001ff00ULL, 0x000000800b14a824ULL, 0x000fc400078e0202ULL,
0x000000040511b824ULL, 0x040fe400078e0202ULL, 0x000000040512a824ULL, 0x040fe400078e0212ULL,
0x000000040514a824ULL, 0x000fe200078e0214ULL, 0x00cd600c1100b388ULL, 0x000fe80000000800ULL,
0x00cc40000d09a984ULL, 0x000e680000000800ULL, 0x00cc60001008a984ULL, 0x000ea80000000800ULL,
0x00cc8000120fa984ULL, 0x000ee80000000800ULL, 0x00cca000140ea984ULL, 0x000f220000000800ULL,
0x000000090a097221ULL, 0x002fc80000010000ULL, 0x0000000809087221ULL, 0x004fe20000010000ULL,
0x000000040509a824ULL, 0x000fc600078e0202ULL, 0x0000000f080f7221ULL, 0x008fc80000010000ULL,
0x0000000e0f0e7221ULL, 0x010fca0000010000ULL, 0x00cd800e0900a388ULL, 0x0003e40000000800ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00ce1807020879a7ULL, 0x002e62000850003fULL,
0x000042000b487824ULL, 0x000fe200078e0202ULL, 0x0000016000017945ULL, 0x000fe20003800000ULL,
0x00000008050f7824ULL, 0x040fe400078e00ffULL, 0x00004200484a7836ULL, 0x000fe40000000000ULL,
0x00000008050c7824ULL, 0x000fe400078e00ffULL, 0x00002000434b7824ULL, 0x100fe400078e024aULL,
0x0000200041497824ULL, 0x000fc400078e024aULL, 0x000020003f4c7824ULL, 0x100fe200078e024aULL,
0x000000054b0a7211ULL, 0x080fe200078fc8ffULL, 0x00000008050e7824ULL, 0x000fe200078e00ffULL,
0x00000005490b7211ULL, 0x000fe200078fc8ffULL, 0x000020003d4a7824ULL, 0x000fe200078e024aULL,
0x000000030a0a7212ULL, 0x000fe400078e3cffULL, 0x000000054c0d7211ULL, 0x000fe400078fc8ffULL,
0x000000420b0b7212ULL, 0x000fe200078e3cffULL, 0x00ce1809020075a7ULL, 0x002e62000804017fULL,
0xfffffff80f0a7812ULL, 0x000fc400078ee20aULL, 0x000000400d0d7212ULL, 0x000fe400078e3cffULL,
0xfffffff80c0c7812ULL, 0x000fe200078ee20bULL, 0x000000100a147824ULL, 0x000fe200078e024bULL,
0xfffffff80e0d7812ULL, 0x000fe400078ee20dULL, 0x000000054a0b7211ULL, 0x000fe200078fc8ffULL,
0x0000003400fca947ULL, 0x002fec0003800000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000805087824ULL, 0x000fe200078e00ffULL, 0x0000003e0b0b7212ULL, 0x000fe200078e3cffULL,
0x000000100c107824ULL, 0x000fe200078e0249ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x000000001414783bULL, 0x000e620000004200ULL, 0x000000100d0d7824ULL, 0x000fe200078e024cULL,
0xfffffff8080b7812ULL, 0x000fe200078ee20bULL, 0x0000400048477836ULL, 0x040fe20000000000ULL,
0x000000001010783bULL, 0x000ea20000004200ULL, 0x0000402048487836ULL, 0x000fc40000000000ULL,
0x000000100b0b7824ULL, 0x000fe200078e024aULL, 0x000000000d0c783bULL, 0x000fe20000004200ULL,
0x000001f047ff7812ULL, 0x000fe4000784c0ffULL, 0x0003fff048487812ULL, 0x000fe400078ec0ffULL,
0x000000000b08783bULL, 0x000ee40000004200ULL, 0x00000004ff487819ULL, 0x000fe40000011648ULL,
0x0000624014347816ULL, 0x002fc40000000015ULL, 0x0000735114357816ULL, 0x000fe40000000015ULL,
0x0000624016367816ULL, 0x140fe40000000017ULL, 0x0000735116377816ULL, 0x000fe40000000017ULL,
0x0000624010307816ULL, 0x144fe40000000011ULL, 0x0000735110317816ULL, 0x000fe40000000011ULL,
0x0000624012327816ULL, 0x000fc40000000013ULL, 0x0000624008287816ULL, 0x148fe40000000009ULL,
0x0000735108297816ULL, 0x000fe20000000009ULL, 0x0000040047097824ULL, 0x040fe200078e00ffULL,
0x0003fff047087812ULL, 0x000fe400078ec0ffULL, 0x0000735112337816ULL, 0x000fe40000000013ULL,
0x00000004ff087819ULL, 0x000fe40000011608ULL, 0x000e000009097812ULL, 0x000fc400078ec0ffULL,
0x00003f0008517812ULL, 0x000fe400078ec0ffULL, 0x8000002009097812ULL, 0x000fe400078efcffULL,
0x000062400c2c7816ULL, 0x140fe4000000000dULL, 0x000073510c2d7816ULL, 0x000fe4000000000dULL,
0x000062400e2e7816ULL, 0x140fe4000000000fULL, 0x000073510e2f7816ULL, 0x000fc4000000000fULL,
0x000062400a2a7816ULL, 0x140fe4000000000bULL, 0x000073510a2b7816ULL, 0x000fe4000000000bULL,
0x000000ff51507812ULL, 0x000fe200078ef808ULL, 0x0000002005087836ULL, 0x000fe20000000000ULL,
0x8000002009517807ULL, 0x000fe20001000000ULL, 0x00000000000079c5ULL, 0x000fe20000000000ULL,
0x00000000501a72caULL, 0x000fe200000e0000ULL, 0x00000008080c7824ULL, 0x040fe200078e00ffULL,
0x00000000511b72caULL, 0x000fe200000e0000ULL, 0x00000008080d7824ULL, 0x040fe200078e00ffULL,
0x0000000849097211ULL, 0x080fe200078fc8ffULL, 0x00000008080e7824ULL, 0x000fe200078e00ffULL,
0x000000084b0a7211ULL, 0x000fc400078fc8ffULL, 0x0000004209097212ULL, 0x000fe400078e3cffULL,
0x000000084c0b7211ULL, 0x080fe400078fc8ffULL, 0xfffffff80c0c7812ULL, 0x000fe400078ee209ULL,
0x000000084a097211ULL, 0x000fe200078fc8ffULL, 0x0000001834247df3ULL, 0x000fe20008700824ULL,
0x00000000501a72caULL, 0x000fe200000e0000ULL, 0x0000000808087824ULL, 0x000fe200078e00ffULL,
0x00000000511b72caULL, 0x000fe200000e0000ULL, 0x000000100c107824ULL, 0x000fe200078e0249ULL,
0x000000030a0a7212ULL, 0x000fc400078e3cffULL, 0x000000400b0b7212ULL, 0x000fe400078e3cffULL,
0x0000003e09097212ULL, 0x000fe400078e3cffULL, 0xfffffff80d0a7812ULL, 0x000fe400078ee20aULL,
0xfffffff80e0b7812ULL, 0x000fe400078ee20bULL, 0xfffffff808097812ULL, 0x000fe200078ee209ULL,
0x0000001830207df3ULL, 0x000fe20008700820ULL, 0x00000000501a72caULL, 0x000fe200000e0000ULL,
0x000000100a147824ULL, 0x000fe200078e024bULL, 0x00000000511b72caULL, 0x000fe200000e0000ULL,
0x000000100b0c7824ULL, 0x000fe200078e024cULL, 0x0000001606007c0cULL, 0x000fe2000bf45270ULL,
0x0000001009097824ULL, 0x000fd400078e024aULL, 0x000000182c1c7df3ULL, 0x000fe2000870081cULL,
0x00000000501a72caULL, 0x000fe400000e0000ULL, 0x00000000511b72caULL, 0x000fda00000e0000ULL,
0x0000001828187df3ULL, 0x000fe60008000818ULL, 0x00008000000079c5ULL, 0x000fe40000010000ULL,
0x000000001414783bULL, 0x000e620000004200ULL, 0x00003f0048297812ULL, 0x000fc600078ec0ffULL,
0x000000001010783bULL, 0x000ea20000004200ULL, 0x000000ff29507812ULL, 0x000fc600078ef848ULL,
0x000000000c0c783bULL, 0x000ee80000004200ULL, 0x000000000908783bULL, 0x000f220000004200ULL,
0x0000624014347816ULL, 0x142fe40000000015ULL, 0x0000735114357816ULL, 0x000fe40000000015ULL,
0x0000624016367816ULL, 0x140fe40000000017ULL, 0x0000735116377816ULL, 0x000fc40000000017ULL,
0x0000624010307816ULL, 0x144fe40000000011ULL, 0x0000735110317816ULL, 0x000fe40000000011ULL,
0x0000624012327816ULL, 0x140fe40000000013ULL, 0x0000735112337816ULL, 0x000fe40000000013ULL,
0x000062400c2c7816ULL, 0x148fe4000000000dULL, 0x000073510c2d7816ULL, 0x000fc4000000000dULL,
0x000062400e2e7816ULL, 0x140fe4000000000fULL, 0x000073510e2f7816ULL, 0x000fe4000000000fULL,
0x0000624008287816ULL, 0x150fe40000000009ULL, 0x0000735108297816ULL, 0x000fe40000000009ULL,
0x000062400a2a7816ULL, 0x140fe4000000000bULL, 0x000073510a2b7816ULL, 0x000fc8000000000bULL,
0x00000000000079c5ULL, 0x000fe20000000000ULL, 0x00000000501a72caULL, 0x000fe400000e0000ULL,
0x00000000511b72caULL, 0x000fda00000e0000ULL, 0x0000001834247df3ULL, 0x000fe20008700824ULL,
0x00000000501a72caULL, 0x000fe400000e0000ULL, 0x00000000511b72caULL, 0x000fda00000e0000ULL,
0x0000001830207df3ULL, 0x000fe20008700820ULL, 0x00000000501a72caULL, 0x000fe400000e0000ULL,
0x00000000511b72caULL, 0x000fda00000e0000ULL, 0x000000182c1c7df3ULL, 0x000fe2000870081cULL,
0x00000000501a72caULL, 0x000fe400000e0000ULL, 0x00000000511b72caULL, 0x000fda00000e0000ULL,
0x0000001828187df3ULL, 0x000fe60008000818ULL, 0x00008000000079c5ULL, 0x000fe40000010000ULL,
0x00000a8000017945ULL, 0x000fe80003800000ULL, 0x0000000800982947ULL, 0x000fea0003800000ULL,
0x00ce1807020879a7ULL, 0x000e62000850003fULL, 0x0000000805117824ULL, 0x000fe200078e00ffULL,
0x0000005000027945ULL, 0x000fe80003800000ULL, 0x0000001811117812ULL, 0x000fca00078ec0ffULL,
0x0000000102137824ULL, 0x000fe200078e0211ULL, 0x00ce1809020075a7ULL, 0x002e64000804017fULL,
0x00000030002ca947ULL, 0x002fea0003800000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00cd800013087984ULL, 0x000e620000000a00ULL, 0x00000008ff0c7e24ULL, 0x000fe2000f8e00ffULL,
0x0000018000027945ULL, 0x000fe20003800000ULL, 0x00000009ff0b7e24ULL, 0x000fe2000f8e00ffULL,
0x00cd6000460f0984ULL, 0x000fe20000000800ULL, 0x00000009ff0d7e24ULL, 0x000fe4000f8e00ffULL,
0x00000018ff107e24ULL, 0x000fe2000f8e00ffULL, 0x00cd8000460e0984ULL, 0x000ea20000000800ULL,
0x0000000dff127e24ULL, 0x000fe4000f8e00ffULL, 0x000000ffff100224ULL, 0x000fc400078e000cULL,
0x000000ffff120224ULL, 0x000fe400078e000bULL, 0x01800000080a7836ULL, 0x002fca0000000000ULL,
0x7f8000000a0a7812ULL, 0x000fe200078ec0ffULL, 0x0000000e4e000986ULL, 0x0043e6000c101b0eULL,
0x01ffffff0a00780cULL, 0x000fe20003f44070ULL, 0x00000008ff0a7e24ULL, 0x000fd8000f8e00ffULL,
0x0000000000142947ULL, 0x002fea0003800000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e0008ULL,
0x000031e0000d7802ULL, 0x000fce0000000f00ULL, 0x0000003400107944ULL, 0x001fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e0008ULL, 0x0000000000107947ULL, 0x000fec0003800000ULL,
0x00000008000b7308ULL, 0x000e640000001000ULL, 0xbf800000080a7423ULL, 0x002fc8000000000bULL,
0x800000ff0a0a7221ULL, 0x000fc80000010100ULL, 0x0000000a0b0c7223ULL, 0x000fce000000000bULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0180000009087836ULL, 0x000fe20000000000ULL,
0x000000c000027945ULL, 0x000fe80003800000ULL, 0x7f80000008087812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0800780cULL, 0x000fda0003f44070ULL, 0x0000000000102947ULL, 0x000fea0003800000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e0009ULL, 0x000032d0000d7802ULL, 0x000fce0000000f00ULL,
0x0000003000d47944ULL, 0x001fea0003c00000ULL, 0x0000000000107947ULL, 0x000fea0003800000ULL,
0x0000000900087308ULL, 0x000e640000001000ULL, 0xbf800000090a7423ULL, 0x002fc80000000008ULL,
0x800000ff0a0b7221ULL, 0x000fc80000010100ULL, 0x0000000b08087223ULL, 0x000fce0000000008ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000000c45097220ULL, 0x040fe20000410000ULL,
0x0000000845087220ULL, 0x004fe20000410000ULL, 0x00000002ff0a7819ULL, 0x000fe40000011605ULL,
0x0000000924247220ULL, 0x080fe20000410000ULL, 0x0000000825257220ULL, 0x080fe20000410000ULL,
0x0000000926267220ULL, 0x080fe20000410000ULL, 0x0000000827277220ULL, 0x080fe20000410000ULL,
0x0000000920207220ULL, 0x080fe20000410000ULL, 0x0000000821217220ULL, 0x000fe20000410000ULL,
0x00000024250b723eULL, 0x000fe200000010ffULL, 0x0000000922227220ULL, 0x080fe20000410000ULL,
0x000000262714723eULL, 0x000fe200000010ffULL, 0x0000000823237220ULL, 0x000fe20000410000ULL,
0x00000020210d723eULL, 0x000fe200000010ffULL, 0x000000091c1c7220ULL, 0x080fe20000410000ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x000000000b0b723aULL, 0x000fe20000000000ULL,
0x000000081d1d7220ULL, 0x000fe20000410000ULL, 0x00000022230e723eULL, 0x000fe200000010ffULL,
0x000000091e1e7220ULL, 0x080fe20000410000ULL, 0x000000001414723aULL, 0x000e620000000000ULL,
0x000000081f1f7220ULL, 0x000fe20000410000ULL, 0x0000001c1d0c723eULL, 0x000fe200000010ffULL,
0x0000000918187220ULL, 0x080fe20000410000ULL, 0x000000000d0d723aULL, 0x000fe20000000000ULL,
0x0000000819197220ULL, 0x000fe20000410000ULL, 0x0000001e1f0f723eULL, 0x000fe200000010ffULL,
0x000000091a1a7220ULL, 0x000fe20000410000ULL, 0x000000000e0e723aULL, 0x000ea20000000000ULL,
0x000000081b1b7220ULL, 0x000fe20000410000ULL, 0x0000000303137812ULL, 0x000fc400078e780aULL,
0x000000033c157812ULL, 0x000fe200078e780aULL, 0x000000000c0c723aULL, 0x000fe20000000000ULL,
0x000000033b177812ULL, 0x000fe200078e780aULL, 0x000000100a167824ULL, 0x040fe200078e0213ULL,
0x000000033a297812ULL, 0x000fe200078e780aULL, 0x000000000f0f723aULL, 0x000ee20000000000ULL,
0x000000181909723eULL, 0x000fe200000010ffULL, 0x000000100a287824ULL, 0x040fe200078e0215ULL,
0x0000001a1b08723eULL, 0x000fe200000010ffULL, 0x000000100a2a7824ULL, 0x040fe400078e0217ULL,
0x000000100a0a7824ULL, 0x000fe200078e0229ULL, 0x000000000909723aULL, 0x000fe20000000000ULL,
0x0000002016167824ULL, 0x000fc400078e0247ULL, 0x0000002028287824ULL, 0x100fe200078e0247ULL,
0x000000000808723aULL, 0x000f220000000000ULL, 0x000000202a2a7824ULL, 0x100fe200078e0247ULL,
0x0000019000027945ULL, 0x000fe20003800000ULL, 0x000000200a0a7824ULL, 0x000fe400078e0247ULL,
0x0000000111167824ULL, 0x040fe400078e0216ULL, 0x0000000111287824ULL, 0x040fe400078e0228ULL,
0x00000001112a7824ULL, 0x000fc400078e022aULL, 0x0000000111117824ULL, 0x000fe200078e020aULL,
0x000054100b0a7816ULL, 0x142fe40000000014ULL, 0x000076320b0b7816ULL, 0x000fca0000000014ULL,
0x0000000a16007388ULL, 0x0005e40000000a00ULL, 0x000054100d0a7816ULL, 0x144fe4000000000eULL,
0x000076320d0b7816ULL, 0x000fe2000000000eULL, 0x00000020390d7824ULL, 0x100fe400078e0247ULL,
0x0000002038477824ULL, 0x000fe400078e0247ULL, 0x0000000a28007388ULL, 0x0007e20000000a00ULL,
0x0000001004147824ULL, 0x000fe200078e020dULL, 0x000054100c0a7816ULL, 0x008fc4000000000fULL,
0x000076320c0b7816ULL, 0x000fe2000000000fULL, 0x00000010040c7824ULL, 0x000fc800078e0247ULL,
0x0000000a2a007388ULL, 0x0009e40000000a00ULL, 0x00005410090a7816ULL, 0x150fe40000000008ULL,
0x00007632090b7816ULL, 0x000fca0000000008ULL, 0x0000000a11007388ULL, 0x0003e20000000a00ULL,
0x00ce1807020879a7ULL, 0x000ea4000850003fULL, 0x00ce1809020075a7ULL, 0x004ea4000804017fULL,
0x00000028007ca947ULL, 0x006fea0003800000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000000014087984ULL, 0x000e620000000c00ULL, 0x0000001003117211ULL, 0x040fe200078448ffULL,
0x000000a000027945ULL, 0x000fe40003800000ULL, 0x000000000c0c7984ULL, 0x000ea20000000c00ULL,
0x0000001203127211ULL, 0x000fe400010f4cffULL, 0x0000001144107211ULL, 0x000fca00078420ffULL,
0x000000ffff117224ULL, 0x000fca00010e0612ULL, 0x0000000810007986ULL, 0x0023e8000c101d0eULL,
0x0008000c10007986ULL, 0x0043e2000c101d0eULL, 0x00ce1807021279a7ULL, 0x000ea4000850003fULL,
0x00ce1813020075a7ULL, 0x004ea4000804017fULL, 0x000000280060a947ULL, 0x006fea0003800000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000000000789947ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000e620000000000ULL, 0x0000000000077886ULL, 0x000fe200038e0100ULL,
0x0000000aff087e24ULL, 0x000fe2000f8e00ffULL, 0x00000007000a7d00ULL, 0x000e6200080e0000ULL,
0x0000000bff097e24ULL, 0x000fce000f8e00ffULL, 0x00000007000b7d09ULL, 0x000ea20008000000ULL,
0x000000050a00720cULL, 0x002fda0003f42070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000002992ULL, 0x0003ec0000008000ULL,
0x0000000000002992ULL, 0x002fec000000a000ULL, 0x00000000000029abULL, 0x000fc00000000000ULL,
0x00000000000025abULL, 0x000fec0000000000ULL, 0x0000000b080b29a8ULL, 0x004ea800081ee1ceULL,
0x00000000ff00298fULL, 0x004fe20002000000ULL, 0x00000000000e7806ULL, 0x000fe200038e0100ULL,
0x00000000000c7919ULL, 0x000e640000003900ULL, 0x00001f0a0b027589ULL, 0x000ea200000e0000ULL,
0x00000000000c79c3ULL, 0x000ee20000008800ULL, 0x000000070c0c7c12ULL, 0x002fe2000f8ec0ffULL,
0x0000040000077882ULL, 0x000fc60000000000ULL, 0x0000000c000d7309ULL, 0x000ea40000000000ULL,
0x0000000102027824ULL, 0x004fe200078e020dULL, 0x000006540c077896ULL, 0x008fc80008000007ULL,
0x0000001702007c0cULL, 0x000fe4000bf45270ULL, 0x00000007ff027e24ULL, 0x000fe4000f8e00ffULL,
0x00000001ff097807ULL, 0x000fca0001000000ULL, 0x00ce200902007388ULL, 0x0003e80000000000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000106097812ULL, 0x042fe200078ec0ffULL,
0x0000000106067836ULL, 0x000fc80000000000ULL, 0x0000001009087824ULL, 0x000fe200078e0202ULL,
0x0000000506007c0cULL, 0x000fc6000bf46070ULL, 0x00cdf80708ff79a7ULL, 0x0003e2000850003fULL,
0x00cdd80708ff79a7ULL, 0x0003f2000850003fULL, 0xffffffe40090a947ULL, 0x003fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001000b47947ULL, 0x000fea0003800000ULL,
0x00009200ff067b82ULL, 0x000e640000000a00ULL, 0x0000000e06067981ULL, 0x002362000c1e9900ULL,
0x000000074300780cULL, 0x000fe20003f04070ULL, 0x00000001ff037424ULL, 0x000fc800078e00ffULL,
0x00cda80302ff79a7ULL, 0x0003f0000850003fULL, 0xff317217ff098424ULL, 0x000fe200078e00ffULL,
0x00cdb80302ff79a7ULL, 0x0003e2000850003fULL, 0x00cdc80302ff79a7ULL, 0x0003e6000850003fULL,
0x00cd400946008388ULL, 0x0003e20000000800ULL, 0x00ce1003020479a7ULL, 0x000ea4000850003fULL,
0x00ce1005020075a7ULL, 0x004ea4000800017fULL, 0x0000002400a08947ULL, 0x006fea0003800000ULL,
0x00cda003020479a7ULL, 0x000e64000850003fULL, 0x00cda005020075a7ULL, 0x002e64000800017fULL,
0x0000002400ac8947ULL, 0x002fea0003800000ULL, 0x000000040600728cULL, 0x000fe2000bf24070ULL,
0x00000005ff437819ULL, 0x000fca0000011643ULL, 0x000000000000781cULL, 0x000fda0003f0f018ULL,
0x0000001000640947ULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000e620000000000ULL,
0x0000001043087824ULL, 0x000fe400078e00ffULL, 0x3d80000006047820ULL, 0x020fe20000410000ULL,
0x000000ffff067224ULL, 0x000fe400078e00ffULL, 0x0000000805077211ULL, 0x002fce00078ff0ffULL,
0x00000040ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x00000000000079c5ULL, 0x000fe20000000000ULL, 0x00cdb00b020879a7ULL, 0x000e64000800003fULL,
0x00cdb009020075a7ULL, 0x002e64000800017fULL, 0x0000002400888947ULL, 0x002fea0003800000ULL,
0x00000000020c72caULL, 0x040fe200000e0000ULL, 0x0000040002097824ULL, 0x040fe200078e00ffULL,
0x0003fff002087812ULL, 0x040fe200078ec0ffULL, 0x00000000000079c5ULL, 0x000fe20000000000ULL,
0x000003ff02ff7812ULL, 0x000fe4000780c0ffULL, 0x00000004ff087819ULL, 0x000fe40000011608ULL,
0x000e0000090a7812ULL, 0x000fe400078ec0ffULL, 0x00003f0008097812ULL, 0x000fc400078ec0ffULL,
0x000000ff0a0a7207ULL, 0x000fe20000000000ULL, 0x0000c4000c077890ULL, 0x000fe2000fffe03fULL,
0x000000ff09097812ULL, 0x000fe400078ef808ULL, 0x400000400a087812ULL, 0x000fe200078efcffULL,
0x000003ff073f7892ULL, 0x000fe2000f82c03fULL, 0x00000000090b72caULL, 0x000fe200000e0000ULL,
0x0000000a07087899ULL, 0x000fe2000800063fULL, 0x00000000080972caULL, 0x000fe200000e0000ULL,
0x0003fff007077892ULL, 0x000fe2000f8ec03fULL, 0x0000002002087836ULL, 0x040fe20000000000ULL,
0x000e0000080a7892ULL, 0x000fe2000f8ec03fULL, 0x00002000020a7836ULL, 0x000fe20000000000ULL,
0x000000043f087899ULL, 0x000fc40008011607ULL, 0x0000003f0a077287ULL, 0x000fe20008800000ULL,
0x0003fff008087812ULL, 0x000fe200078ec0ffULL, 0x00003f00080a7892ULL, 0x000fe4000f8ec03fULL,
0x4000004007077892ULL, 0x000fe2000f8efc3fULL, 0x00000004ff087819ULL, 0x000fe20000011608ULL,
0x000000ff0a0a7892ULL, 0x000fc6000f8ef808ULL, 0x0000000b00087c82ULL, 0x000fe20008000000ULL,
0x00003f0008097812ULL, 0x000fe200078ec0ffULL, 0x00000007000b7c82ULL, 0x000fc60008000000ULL,
0x000000ff09097812ULL, 0x000fe200078ef808ULL, 0x00000000081879f3ULL, 0x000fe2000c7008ffULL,
0x0000c4200c087890ULL, 0x000fe2000fffe03fULL, 0x0000004002087836ULL, 0x000fe20000000000ULL,
0x00000000090b72caULL, 0x000fe400000e0000ULL, 0x0003fff008087892ULL, 0x000fe4000f8ec03fULL,
0x0003fff008087812ULL, 0x000fe400078ec0ffULL, 0x000000043f087899ULL, 0x000fc40008011608ULL,
0x00000004ff087819ULL, 0x000fe40000011608ULL, 0x00003f00080a7892ULL, 0x000fe4000f8ec03fULL,
0x00003f0008097812ULL, 0x000fe400078ec0ffULL, 0x000000ff0a0a7892ULL, 0x000fe4000f8ef808ULL,
0x000000ff09097812ULL, 0x000fe200078ef808ULL, 0x0000000b00087c82ULL, 0x000fe20008000000ULL,
0x00000007000b7c82ULL, 0x000fe20008000000ULL, 0x0000006002087836ULL, 0x000fca0000000000ULL,
0x0003fff008087812ULL, 0x000fc800078ec0ffULL, 0x00000004ff087819ULL, 0x000fe20000011608ULL,
0x00000000081879f3ULL, 0x000fe20008700818ULL, 0x0000c4400c087890ULL, 0x000fe2000fffe03fULL,
0x00000000090b72caULL, 0x000fe400000e0000ULL, 0x00003f0008097812ULL, 0x000fe200078ec0ffULL,
0x0003fff008087892ULL, 0x000fc6000f8ec03fULL, 0x000000ff09097812ULL, 0x000fe200078ef808ULL,
0x000000043f087899ULL, 0x000fc80008011608ULL, 0x00003f00080a7892ULL, 0x000fc8000f8ec03fULL,
0x000000ff0a0a7892ULL, 0x000fc6000f8ef808ULL, 0x0000000b00087c82ULL, 0x000fe20008000000ULL,
0x00000007000b7c82ULL, 0x000fca0008000000ULL, 0x00000000081879f3ULL, 0x000fe20008700818ULL,
0x0000c4600c087890ULL, 0x000fe2000fffe03fULL, 0x00000000090b72caULL, 0x000fc600000e0000ULL,
0x0003fff008087892ULL, 0x000fc8000f8ec03fULL, 0x000000043f087899ULL, 0x000fc80008011608ULL,
0x00003f00080a7892ULL, 0x000fc8000f8ec03fULL, 0x000000ff0a0a7892ULL, 0x000fc6000f8ef808ULL,
0x0000000b00087c82ULL, 0x000fe20008000000ULL, 0x00000007000b7c82ULL, 0x000fca0008000000ULL,
0x00000000081879f3ULL, 0x000fe60008000818ULL, 0x00008000000079c5ULL, 0x000fe40000010000ULL,
0x00cdb80302ff79a7ULL, 0x0003e2000850003fULL, 0x00cdc00b020879a7ULL, 0x000ea4000800003fULL,
0x00cdc009020075a7ULL, 0x004ea4000800017fULL, 0x0000002000788947ULL, 0x006fea0003800000ULL,
0x00000000020c72caULL, 0x000fe200000e0000ULL, 0x00000000000079c5ULL, 0x000fe20000000000ULL,
0x0003fff00a087812ULL, 0x000fc800078ec0ffULL, 0x00000004ff087819ULL, 0x000fc80000011608ULL,
0x00003f0008097812ULL, 0x000fc600078ec0ffULL, 0x0000c8000c087890ULL, 0x000fe2000fffe03fULL,
0x000000ff09097812ULL, 0x000fe200078ef808ULL, 0x0000202002087836ULL, 0x000fe40000000000ULL,
0x0003fff008087892ULL, 0x000fe2000f8ec03fULL, 0x00000000090b72caULL, 0x000fe400000e0000ULL,
0x0003fff008087812ULL, 0x000fe200078ec0ffULL, 0x000000043f087899ULL, 0x000fc60008011608ULL,
0x00000004ff087819ULL, 0x000fe20000011608ULL, 0x00003f00080a7892ULL, 0x000fc6000f8ec03fULL,
0x00003f0008097812ULL, 0x000fe200078ec0ffULL, 0x000000ff0a0a7892ULL, 0x000fc6000f8ef808ULL,
0x0000000b00087c82ULL, 0x000fe20008000000ULL, 0x00000007000b7c82ULL, 0x000fe20008000000ULL,
0x000000ff09097812ULL, 0x000fe200078ef808ULL, 0x0000204002087836ULL, 0x000fc60000000000ULL,
0x00000000081879f3ULL, 0x000fe20008700818ULL, 0x0000c8200c087890ULL, 0x000fe2000fffe03fULL,
0x00000000090b72caULL, 0x000fe400000e0000ULL, 0x0003fff008087812ULL, 0x000fe200078ec0ffULL,
0x0003fff008087892ULL, 0x000fc6000f8ec03fULL, 0x00000004ff087819ULL, 0x000fe20000011608ULL,
0x000000043f087899ULL, 0x000fc60008011608ULL, 0x00003f0008097812ULL, 0x000fe200078ec0ffULL,
0x00003f00080a7892ULL, 0x000fc6000f8ec03fULL, 0x000000ff09097812ULL, 0x000fe200078ef808ULL,
0x000000ff0a0a7892ULL, 0x000fe2000f8ef808ULL, 0x0000206002087836ULL, 0x000fe40000000000ULL,
0x0000000b00087c82ULL, 0x000fe20008000000ULL, 0x00000007000b7c82ULL, 0x000fe40008000000ULL,
0x0003fff008087812ULL, 0x000fc800078ec0ffULL, 0x00000004ff087819ULL, 0x000fe20000011608ULL,
0x00000000081879f3ULL, 0x000fe20008700818ULL, 0x0000c8400c087890ULL, 0x000fe2000fffe03fULL,
0x00000000090b72caULL, 0x000fe400000e0000ULL, 0x00003f0008097812ULL, 0x000fe200078ec0ffULL,
0x0003fff008087892ULL, 0x000fc6000f8ec03fULL, 0x000000ff09097812ULL, 0x000fe200078ef808ULL,
0x000000043f087899ULL, 0x000fc80008011608ULL, 0x00003f00080a7892ULL, 0x000fc8000f8ec03fULL,
0x000000ff0a0a7892ULL, 0x000fc6000f8ef808ULL, 0x0000000b00087c82ULL, 0x000fe20008000000ULL,
0x00000007000b7c82ULL, 0x000fca0008000000ULL, 0x00000000081879f3ULL, 0x000fe20008700818ULL,
0x0000c8600c087890ULL, 0x000fe2000fffe03fULL, 0x00000000090b72caULL, 0x000fe200000e0000ULL,
0x00000013ff097e24ULL, 0x000fe4000f8e00ffULL, 0x0003fff008087892ULL, 0x000fe4000f8ec03fULL,
0x0000000606097c24ULL, 0x000fe4000f8e0209ULL, 0x000000043f087899ULL, 0x000fe40008011608ULL,
0x0000000109087836ULL, 0x000fc40000000000ULL, 0x00003f00080a7892ULL, 0x000fc6000f8ec03fULL,
0x0000001108007c0cULL, 0x000fe2000bf05270ULL, 0x000000ff0a0a7892ULL, 0x000fc6000f8ef808ULL,
0x0000000b00087c82ULL, 0x000fe20008000000ULL, 0x00000007000b7c82ULL, 0x000fca0008000000ULL,
0x00000000081879f3ULL, 0x000fe60008000818ULL, 0x00008000000079c5ULL, 0x000fe40000010000ULL,
0x00cdc80302ff79a7ULL, 0x0003e2000850003fULL, 0x0000000418187220ULL, 0x080fe20000410000ULL,
0x0000000419197220ULL, 0x080fe20000410000ULL, 0x000000041a0b7220ULL, 0x080fe20000410000ULL,
0x000000041b0e7220ULL, 0x000fe20000410000ULL, 0x0000000000280947ULL, 0x000fec0003800000ULL,
0x0000004009097824ULL, 0x000fca00078e00ffULL, 0x0000000900087248ULL, 0x000fca0007fe0000ULL,
0x0000000108087824ULL, 0x000fe400078e0a09ULL, 0x0000000807097836ULL, 0x000fc60000000000ULL,
0x000000080700720cULL, 0x080fe40003f06070ULL, 0x000000080900720cULL, 0x000fe40003f26070ULL,
0xff80000018187808ULL, 0x000fe40004000000ULL, 0xff80000019197808ULL, 0x000fe40004000000ULL,
0xff8000000b0b7808ULL, 0x000fe40004800000ULL, 0xff8000000e0e7808ULL, 0x000fce0004800000ULL,
0x000000180b087209ULL, 0x000fe40007810000ULL, 0x000000190e0a7209ULL, 0x000fe40007810000ULL,
0x000000030500780cULL, 0x000fe20003f04070ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x0e001f0008097f89ULL, 0x000ea800000e0000ULL, 0x0e001f000a0d7f89ULL, 0x000ee200000e0000ULL,
0x0000000908097209ULL, 0x004fc40007810000ULL, 0x0000000d0a0d7209ULL, 0x008fc60007810000ULL,
0x0d001f00090c7f89ULL, 0x000ea800000e0000ULL, 0x0d001f000d107f89ULL, 0x000ee200000e0000ULL,
0x0000000c090c7209ULL, 0x004fe40007810000ULL, 0x000000100d107209ULL, 0x008fc60007810000ULL,
0x0c801f000c0f7f89ULL, 0x000ea800000e0000ULL, 0x0c801f0010117f89ULL, 0x000ee200000e0000ULL,
0x0000011000007945ULL, 0x000fe20003800000ULL, 0x0000000f0c0f7209ULL, 0x004fe40007810000ULL,
0x0000001110117209ULL, 0x008fe20007810000ULL, 0x0000000000340947ULL, 0x000fec0003800000ULL,
0x000000ff0f00720bULL, 0x000fe20003f36000ULL, 0x0000006000017945ULL, 0x000fe20003800000ULL,
0x0000000805087824ULL, 0x000fd600078e0202ULL, 0x0000000000089947ULL, 0x000fea0003800000ULL,
0x00cd400f08ff738cULL, 0x0005e20001000200ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x00cd400f08ff738cULL, 0x0005e40000800000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ff1100720bULL, 0x000fda0003f36000ULL, 0x0000000000089947ULL, 0x000fea0003800000ULL,
0x00cd441108ff738cULL, 0x0007e20001000200ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x00cd441108ff738cULL, 0x0007e40000800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00ce1003020879a7ULL, 0x00cea2000850003fULL, 0x00000008050a7824ULL, 0x000fca00078e00ffULL,
0x000000180a0d7812ULL, 0x000fca00078ec0ffULL, 0x0000000102107824ULL, 0x000fe200078e020dULL,
0x00ce1009020075a7ULL, 0x004ea4000802017fULL, 0x0000001800c09947ULL, 0x004fea0003800000ULL,
0x00cd400010087984ULL, 0x000ea20000000a00ULL, 0x00ce1003020c79a7ULL, 0x000ee4000850003fULL,
0x00ce100d020075a7ULL, 0x008ee2000802017fULL, 0x3fb8aa3b080f7820ULL, 0x004fc80000410000ULL,
0x3fb8aa3b18187823ULL, 0x100fe2000001080fULL, 0x3fb8aa3b0b0b7823ULL, 0x000fe2000001080fULL,
0x3fb8aa3b090f7820ULL, 0x000fc80000410000ULL, 0x3fb8aa3b19197823ULL, 0x100fe2000001080fULL,
0x3fb8aa3b0e0e7823ULL, 0x000fe2000001080fULL, 0x0000001800187308ULL, 0x000ff00000000800ULL,
0x0000000b000b7308ULL, 0x000eb00000000800ULL, 0x0000001900197308ULL, 0x000fe20000000800ULL,
0x0000000b180f7221ULL, 0x004fce0000010000ULL, 0x0000000e000e7308ULL, 0x000ea40000000800ULL,
0x0000000e19107221ULL, 0x004fe20000010000ULL, 0x0000001800989947ULL, 0x008fec0003800000ULL,
0x0e001f000f0c7f89ULL, 0x000ea200000e0000ULL, 0x000000070500780cULL, 0x000fe20003f24070ULL,
0x000001c000007945ULL, 0x000fe20003800000ULL, 0x0000000106157812ULL, 0x000fe200078ec0ffULL,
0x0e001f00100d7f89ULL, 0x000ee200000e0000ULL, 0x000000ffff137224ULL, 0x000fc600078e00ffULL,
0x0000001015177824ULL, 0x000fe400078e0202ULL, 0x0000000c0f0c7221ULL, 0x004fe20000010000ULL,
0x0000000d100d7221ULL, 0x008fc80000010000ULL, 0x0d001f000c117f89ULL, 0x000ea800000e0000ULL,
0x0d001f000d127f89ULL, 0x000ee200000e0000ULL, 0x000000110c117221ULL, 0x004fe20000010000ULL,
0x000000120d127221ULL, 0x008fc80000010000ULL, 0x0c801f0011107f89ULL, 0x0004e800000e0000ULL,
0x0c801f00120f7f89ULL, 0x00052200000e0000ULL, 0x0000000000381947ULL, 0x000fea0003800000ULL,
0x00000000000779c3ULL, 0x000f620000003000ULL, 0x00000001ff0d7819ULL, 0x000fe20000011605ULL,
0x0000000405137824ULL, 0x040fe200078e00ffULL, 0x00000006050c7812ULL, 0x000fe400078ec0ffULL,
0x7ffffffc0d147812ULL, 0x000fe400078ec0ffULL, 0x00000001ff0d7819ULL, 0x000fe4000001160cULL,
0x0000001c13167812ULL, 0x000fe200078ec0ffULL, 0x0000000114147824ULL, 0x000fca00078e0243ULL,
0x0000000d140d7212ULL, 0x000fca00078e3cffULL, 0x000000010d0d7824ULL, 0x000fe400078e0216ULL,
0x00000007020c7c36ULL, 0x020fc80008000000ULL, 0x00004200150c7824ULL, 0x000fc800078e020cULL,
0x000000100d0c7824ULL, 0x000fc800078e020cULL, 0x000040000c137836ULL, 0x000fce0000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00cdf803170c79a7ULL, 0x000f64000850003fULL,
0x00cdf80d170075a7ULL, 0x020f64000802017fULL, 0x0000001800289947ULL, 0x020fea0003800000ULL,
0x00000000000779c3ULL, 0x000f620000003000ULL, 0x43e0000018187820ULL, 0x000fe20000410000ULL,
0x43e000000b0b7820ULL, 0x000fe20000410000ULL, 0x43e0000019197820ULL, 0x000fe20000410000ULL,
0x43e000000e0e7820ULL, 0x000fe20000410000ULL, 0x0000001011107221ULL, 0x008fe20000010000ULL,
0x0000000f120f7221ULL, 0x010fe20000010000ULL, 0x000000180b18723eULL, 0x000fe40004807118ULL,
0x000000190e0c723eULL, 0x000fc8000480710cULL, 0x0000541018187816ULL, 0x000fe2000000000cULL,
0x80000007130b7c36ULL, 0x020fe20008000000ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x000000180b007844ULL, 0x0009e20000004000ULL, 0x000000c000007945ULL, 0x000fe80003800000ULL,
0x0000000000280947ULL, 0x010fea0003800000ULL, 0x000000ff4300720cULL, 0x000fe20003f05270ULL,
0x00000080150c7824ULL, 0x140fe400078e0202ULL, 0x00000020150b7824ULL, 0x008fe400078e0202ULL,
0x00000020430c7824ULL, 0x000fe400078e020cULL, 0x000000010a0b7824ULL, 0x000fe400078e020bULL,
0x00000008050c7824ULL, 0x000fc800078e020cULL, 0x00cc00080b008388ULL, 0x0007e80000000800ULL,
0x00cc40100c007388ULL, 0x0007e80000000800ULL, 0x00cc04090b008388ULL, 0x0007e80000000800ULL,
0x00cc440f0c007388ULL, 0x0007e40000000800ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000106067836ULL, 0x000fe20000000000ULL, 0x00cdf00317ff79a7ULL, 0x0009e8000850003fULL,
0x0000000506007c0cULL, 0x000fda000bf06070ULL, 0xffffffec00b08947ULL, 0x01ffea000383ffffULL,
0x00cda80302ff79a7ULL, 0x0003e4000850003fULL, 0x0000000000047919ULL, 0x020ee20000002300ULL,
0x0000003f00007836ULL, 0x000fe20000000000ULL, 0x0000000000057919ULL, 0x000ee20000002200ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x000000783f077890ULL, 0x000fe2000ff3e03fULL, 0x0000007f0000780cULL, 0x000fc60003f04070ULL,
0x0000003f3f0c7290ULL, 0x000fe20008ffe43fULL, 0x0000010000147ab9ULL, 0x000fe20000000800ULL,
0x0000000000067919ULL, 0x002e620000002100ULL, 0x0000000000157ab9ULL, 0x000fe20000000800ULL,
0x00000300ff077b82ULL, 0x000f220000000800ULL, 0x0000000307077899ULL, 0x000fc8000800120cULL,
0x0000000107077890ULL, 0x000fe2000fffe03fULL, 0x0000001404037c24ULL, 0x008fe2000f8e0205ULL,
0x000000010700780cULL, 0x010fc60000704070ULL, 0x0000001503037c24ULL, 0x002fca000f8e0206ULL,
0x0000000703007c0cULL, 0x000fda000bf26070ULL, 0x0000000803029824ULL, 0x004fc800078e0202ULL,
0x00cda000020099b1ULL, 0x0002a4000800003fULL, 0x000000000000894dULL, 0x004fea0003800000ULL,
0x00000000000c79c3ULL, 0x000ee20000008800ULL, 0x0000040000077882ULL, 0x000fe40000000000ULL,
0x000006540c077896ULL, 0x008fd20008000007ULL, 0x00ce2007ff007984ULL, 0x004ea40008000000ULL,
0x000000ff0000720cULL, 0x004fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000405ff7212ULL, 0x000fc8000784fcffULL,
0x000000040600780cULL, 0x000fda0005741070ULL, 0x00000000005ca947ULL, 0x000fea0003800000ULL,
0x0000000706007c11ULL, 0x000fe2000f8e20ffULL, 0x001ffffe00047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x7ffff80000057882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x002fd60000000000ULL, 0x00000000000812caULL, 0x002fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ee40000000000ULL, 0x00410004083f75b2ULL, 0x0042f00008000100ULL,
0xfffffffd00e81947ULL, 0x008fea000393ffffULL, 0x0000000000007918ULL, 0x004fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x001ffe0000047882ULL, 0x002fe20000000000ULL,
0x7ff8000000057882ULL, 0x000fd60000000000ULL, 0x00000000000812caULL, 0x002fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ee40000000000ULL, 0x00410804083f75b2ULL, 0x0042f00008000100ULL,
0xfffffffd00e81947ULL, 0x008fea000393ffffULL, 0x00000100ff057424ULL, 0x000fc800078e00ffULL,
0x0041080500ff79a7ULL, 0x0045e6000850003fULL, 0x00000005ff037819ULL, 0x000fe20000011603ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x00001fff03037589ULL, 0x000ee400000e0000ULL,
0x00000000030572caULL, 0x00afe200000e0000ULL, 0x0000000000007b1dULL, 0x000fd80000010000ULL,
0x000000080500788cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x00000004002c8947ULL, 0x000fea0003800000ULL, 0x00000000000479c3ULL, 0x000fe20000002600ULL,
0x0000000b05067890ULL, 0x000fe2000fffe106ULL, 0x0000840000097ab9ULL, 0x000fc60000000800ULL,
0x000000023f067899ULL, 0x000fc60008011606ULL, 0x00000000000879c3ULL, 0x000e660000002700ULL,
0x00000006ff007c0cULL, 0x000fe2000bf05270ULL, 0x00000009080a72a4ULL, 0x002fd8000f8e0204ULL,
0x0000000800e08947ULL, 0x000fea0003800000ULL, 0x0000000000077919ULL, 0x000e620000000000ULL,
0x0000900000047ab9ULL, 0x000fe20000000800ULL, 0x0000030000087ab9ULL, 0x000fe20000000800ULL,
0x00000004090972a4ULL, 0x000fe4000f8e023fULL, 0x0000000608047899ULL, 0x000fe4000800063fULL,
0x00000fff090b7891ULL, 0x000fc8000f8e103fULL, 0xfffff0000b107892ULL, 0x000fe4000f8ec03fULL,
0xfffffff8050b7890ULL, 0x000fe4000fffe03fULL, 0x00000004090472a4ULL, 0x000fe4000f8e0210ULL,
0x000000080a0572a4ULL, 0x000fe4000f8e023fULL, 0x00000fff040a7890ULL, 0x000fc6000fffe03fULL,
0x0000003f00047c82ULL, 0x000fd20008000000ULL, 0x0000000b04087291ULL, 0x000fe2000f8e103fULL,
0x000000070700780cULL, 0x042fe20003f64070ULL, 0x0000000104047890ULL, 0x000fe2000fffe03fULL,
0x000000ff0700720cULL, 0x000fe20003f25270ULL, 0x0000000408097892ULL, 0x000fe4000f8ec03fULL,
0x00000004080c7899ULL, 0x000fe4000800063fULL, 0x000000023f097899ULL, 0x000fe40008011609ULL,
0x000000300c0c7892ULL, 0x000fc4000f8ec03fULL, 0x0000001f09097899ULL, 0x000fe4000800063fULL,
0x000000060400728cULL, 0x000fe4000bf06070ULL, 0x0000000cff037e24ULL, 0x000fe2000f8e00ffULL,
0x0000000805117290ULL, 0x000fe2000fffe03fULL, 0x00000009ff007e24ULL, 0x004fe2000f8e00ffULL,
0x00000003080d7892ULL, 0x000fe4000f8ec03fULL, 0x0000000c070c7290ULL, 0x000fe4000fffe03fULL,
0x00410800030075a7ULL, 0x000e640008000147ULL, 0x0000001000388947ULL, 0x002ff00003800000ULL,
0x0000014000007945ULL, 0x000fe80003800000ULL, 0x0000000000483947ULL, 0x000fea0003800000ULL,
0x00000011100c7291ULL, 0x000fe2000f8fd03fULL, 0x0000c00000087ab9ULL, 0x000fc60000000a00ULL,
0x000000400c0878a5ULL, 0x000fe4000f8e0008ULL, 0x000000070d0c7291ULL, 0x000fc8000f8e303fULL,
0x00000008ff027e24ULL, 0x000fe2000f8e00ffULL, 0x000000070d087291ULL, 0x000fe2000f8e203fULL,
0x00000009ff037e24ULL, 0x000fe2000f8e00ffULL, 0x0000000c07057c11ULL, 0x040fe2000f8e18ffULL,
0x0000000807027825ULL, 0x000fca00078e0002ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0400000002057faeULL, 0x0003e2000b921a4eULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000410008087890ULL, 0x000fd2000fffe03fULL, 0x000000ffffff79a7ULL, 0x000fe20008200408ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a88ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000d000007945ULL, 0x000fe80003800000ULL,
0x00000000002c1947ULL, 0x000fea0003800000ULL, 0x000000110a0c7291ULL, 0x000fe2000f8fa03fULL,
0x00001000ff007424ULL, 0x000fe200078e00ffULL, 0x000000070d147291ULL, 0x000fe2000f8e203fULL,
0x0000c00000087ab9ULL, 0x000fe20000000a00ULL, 0x000000070d127291ULL, 0x000fe4000f8e603fULL,
0x000010000c0878a5ULL, 0x000fe4000f8e0008ULL, 0x0000410014137890ULL, 0x000fe2000fffe03fULL,
0x00000100000c7882ULL, 0x000fd00000000000ULL, 0x00000012080073baULL, 0x0003e2000800020cULL,
0x00410000ffff79a7ULL, 0x0003e40008000014ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0xfffffffc00288947ULL, 0x001fea000383ffffULL, 0x0000000400d47947ULL, 0x000fea0003800000ULL,
0x0000000000167919ULL, 0x000e620000000000ULL, 0x00000006ff007c0cULL, 0x000fda000bf05270ULL,
0x0000000400488947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0xff317217ff007424ULL, 0x004fe200078e00ffULL, 0x00000000000a7805ULL, 0x000fe4000001ff00ULL,
0x00000000000c7805ULL, 0x000fe4000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff107224ULL, 0x000fe200078e00ffULL, 0x0000003f00047c82ULL, 0x000fcc0008000000ULL,
0x0000000404087892ULL, 0x000fe4000f8ec03fULL, 0x0000000404097899ULL, 0x000fe4000800063fULL,
0x000000023f087899ULL, 0x000fe40008011608ULL, 0x0000003009097892ULL, 0x000fe4000f8ec03fULL,
0x0000001f080b7899ULL, 0x000fe4000800063fULL, 0x00000003040c7892ULL, 0x000fc4000f8ec03fULL,
0x00000009ff037e24ULL, 0x000fe2000f8e00ffULL, 0x0000000907097290ULL, 0x000fe2000fffe03fULL,
0x0000000bff027e24ULL, 0x000fe2000f8e00ffULL, 0x000000070c0a7291ULL, 0x000fe4000f8e603fULL,
0x000000070c087291ULL, 0x000fe4000f8e303fULL, 0x00410002030075a7ULL, 0x000ea20008000147ULL,
0x0000000a050a7291ULL, 0x000fe4000f8e483fULL, 0x0000000805087291ULL, 0x000fc8000f8e183fULL,
0x0000000a16047c11ULL, 0x002fe2000f8e20ffULL, 0x0000000c005c8947ULL, 0x004fee0003800000ULL,
0x00400008ff027984ULL, 0x000e620008000a00ULL, 0x0000000104047890ULL, 0x000fc6000fffe03fULL,
0x0000000004047984ULL, 0x000ea20000000c00ULL, 0x000000060400728cULL, 0x000fe2000bf06070ULL,
0x000000000300720bULL, 0x002fe40003f14000ULL, 0x0000763205127816ULL, 0x044fe20000000012ULL,
0x0001000005157824ULL, 0x000fe200078e00ffULL, 0x0000763206057816ULL, 0x040fe20000000005ULL,
0x0001000006177824ULL, 0x000fe200078e00ffULL, 0x0000763204117816ULL, 0x040fe20000000011ULL,
0x0001000004137824ULL, 0x000fe200078e00ffULL, 0x0000763207067816ULL, 0x040fe20000000006ULL,
0x0001000007197824ULL, 0x000fc400078e00ffULL, 0x0001000011047824ULL, 0x000fe400078e00ffULL,
0x0001000012127824ULL, 0x000fe400078e00ffULL, 0x0001000005147824ULL, 0x000fe400078e00ffULL,
0x00010000061b7824ULL, 0x000fe200078e00ffULL, 0x0000000000380947ULL, 0x000fec0003800000ULL,
0x0000000300037221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b03037820ULL, 0x000fcc0000410000ULL,
0x0000000300037308ULL, 0x000e640000000800ULL, 0x0000000302057220ULL, 0x002fc80000410000ULL,
0x0000000513107223ULL, 0x080fe20000010010ULL, 0x00000005040f7223ULL, 0x080fe2000001000fULL,
0x00000005150e7223ULL, 0x080fe2000001000eULL, 0x00000005120d7223ULL, 0x080fe2000001000dULL,
0x00000005170c7223ULL, 0x080fe2000001000cULL, 0x00000005140b7223ULL, 0x080fe2000001000bULL,
0x00000005190a7223ULL, 0x080fe2000001000aULL, 0x000000051b087223ULL, 0x000fe20000010008ULL,
0x0000000905097221ULL, 0x000fe20000010000ULL, 0x0000000000547947ULL, 0x000fec0003800000ULL,
0x8000000300007221ULL, 0x100fe20000010000ULL, 0x0000001302077220ULL, 0x040fe20000410000ULL,
0x0000001502117220ULL, 0x040fe20000410000ULL, 0x0000001202067220ULL, 0x000fe20000410000ULL,
0x3fb8aa3b00007820ULL, 0x000fe20000410000ULL, 0x0000001702137220ULL, 0x040fe20000410000ULL,
0x0000000402047220ULL, 0x040fe20000410000ULL, 0x0000001402127220ULL, 0x040fe20000410000ULL,
0x0000000000057308ULL, 0x0002a20000000800ULL, 0x0000001902157220ULL, 0x040fe20000410000ULL,
0x0000001b02177220ULL, 0x000fe20000410000ULL, 0x000000ffff007224ULL, 0x002fc400078e0003ULL,
0x0000000905097223ULL, 0x044fe20000010002ULL, 0x0000001005107223ULL, 0x040fe20000010007ULL,
0x0000000f050f7223ULL, 0x040fe20000010004ULL, 0x0000000e050e7223ULL, 0x040fe20000010011ULL,
0x0000000d050d7223ULL, 0x040fe20000010006ULL, 0x0000000c050c7223ULL, 0x040fe20000010013ULL,
0x0000000b050b7223ULL, 0x040fe20000010012ULL, 0x0000000a050a7223ULL, 0x040fe20000010015ULL,
0x0000000805087223ULL, 0x000fce0000010017ULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x000000070c087291ULL, 0x000fe2000f8e203fULL, 0x00000001ff027424ULL, 0x000fd000078e00ffULL,
0x00410802ffff79a7ULL, 0x0003e60008500008ULL, 0xfffffff800d88947ULL, 0x003fea000383ffffULL,
0x0000000000147947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fe4000001ff00ULL,
0x00000000000a7805ULL, 0x000fe4000001ff00ULL, 0x00000000000c7805ULL, 0x000fe4000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff107224ULL, 0x000fce00078e00ffULL,
0x00000000000479c3ULL, 0x000fe20000002600ULL, 0x0000840000087ab9ULL, 0x000fe20000000800ULL,
0x0000000900097308ULL, 0x000ee20000001000ULL, 0x0000000816077824ULL, 0x002fca00078e00ffULL,
0x00000000000679c3ULL, 0x000e620000002700ULL, 0x0000001009107220ULL, 0x048fe20000410000ULL,
0x0000000f090f7220ULL, 0x040fe20000410000ULL, 0x0000000e090e7220ULL, 0x040fe20000410000ULL,
0x0000000c090c7220ULL, 0x040fe20000410000ULL, 0x0000000a090a7220ULL, 0x040fe20000410000ULL,
0x0000000809057220ULL, 0x044fe20000410000ULL, 0x0000000b090b7220ULL, 0x040fe20000410000ULL,
0x0000000d09097220ULL, 0x000fe20000410000ULL, 0x000000100f10723eULL, 0x000fe400000010ffULL,
0x0000000a0513723eULL, 0x000fc400000010ffULL, 0x0000000c0b12723eULL, 0x000fe400000010ffULL,
0x0000000e0911723eULL, 0x000fe200000010ffULL, 0x00000008060472a4ULL, 0x002fc6000f8e0204ULL,
0x0000860000087ab9ULL, 0x000fe20000000a00ULL, 0x0000000504057291ULL, 0x000fc8000f80183fULL,
0x0000003f3f067290ULL, 0x000fe400087fe43fULL, 0x0000000805047291ULL, 0x000fc8000f80483fULL,
0x0000000905057291ULL, 0x000fe400080f4c06ULL, 0x00000004ff027e24ULL, 0x000fc8000f8e00ffULL,
0x00000005ff037e24ULL, 0x000fe4000f8e00ffULL, 0x0000000207027825ULL, 0x000fca00078e0002ULL,
0x0000001002007986ULL, 0x0003e4000c101d0eULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000000000a94dULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x004e240000002100ULL,
0x0000000700007c11ULL, 0x001fc8000f8e20ffULL, 0x00410800000079b1ULL, 0x000e24000800003fULL,
0x00410000000079b1ULL, 0x001fe2000800003fULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00cdd8050b0075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x00cdd8050b0085a7ULL, 0x000e24000800007fULL,
0xfffffffc00ec8947ULL, 0x001fea000383ffffULL, 0xffffffa800ac7947ULL, 0x001fea000383ffffULL,
0x00cdb805020075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x00cdb805020085a7ULL, 0x000e24000800007fULL,
0xfffffffc00ec8947ULL, 0x001fea000383ffffULL, 0xffffffac00447947ULL, 0x001fea000383ffffULL,
0x00cdc805020075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x00cdc805020085a7ULL, 0x000e24000800007fULL,
0xfffffffc00ec8947ULL, 0x001fea000383ffffULL, 0xffffffac00807947ULL, 0x001fea000383ffffULL,
0x00cda811020075a7ULL, 0x000262000802017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x00cda811020095a7ULL, 0x000e24000802007fULL,
0xfffffffc00ec9947ULL, 0x001fea000383ffffULL, 0xffffffb000547947ULL, 0x021fea000383ffffULL,
0x00ce1805020075a7ULL, 0x0004a2000800017fULL, 0x0000a0000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x00ce1805020085a7ULL, 0x000e24000800007fULL,
0xfffffffc00ec8947ULL, 0x001fea000383ffffULL, 0xffffffbc00307947ULL, 0x023fea000383ffffULL,
0x00cdd0090d0075a7ULL, 0x0004a2000804017fULL, 0x0000a0000000791aULL, 0x000fc80000000000ULL,
0x009896800000a95dULL, 0x000fea0003900000ULL, 0x00cdd0090d00a5a7ULL, 0x000e24000804007fULL,
0xfffffffc00eca947ULL, 0x001fea000383ffffULL, 0xffffffc0005c7947ULL, 0x003fea000383ffffULL,
0x00cdf009110075a7ULL, 0x000262000806017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000b95dULL, 0x000fea0003900000ULL, 0x00cdf0091100b5a7ULL, 0x000e24000806007fULL,
0xfffffffc00ecb947ULL, 0x001fea000383ffffULL, 0xffffffc000707947ULL, 0x001fea000383ffffULL,
0x00ce1809020075a7ULL, 0x000262000804017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000a95dULL, 0x000fea0003900000ULL, 0x00ce18090200a5a7ULL, 0x000e24000804007fULL,
0xfffffffc00eca947ULL, 0x001fea000383ffffULL, 0xffffffc400ec7947ULL, 0x001fea000383ffffULL,
0x00ce1809020075a7ULL, 0x000262000804017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000a95dULL, 0x000fea0003900000ULL, 0x00ce18090200a5a7ULL, 0x000e24000804007fULL,
0xfffffffc00eca947ULL, 0x001fea000383ffffULL, 0xffffffcc00bc7947ULL, 0x001fea000383ffffULL,
0x00ce1809020075a7ULL, 0x000262000804017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000a95dULL, 0x000fea0003900000ULL, 0x00ce18090200a5a7ULL, 0x000e24000804007fULL,
0xfffffffc00eca947ULL, 0x001fea000383ffffULL, 0xffffffd4006c7947ULL, 0x001fea000383ffffULL,
0x00ce1813020075a7ULL, 0x000262000804017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000a95dULL, 0x000fea0003900000ULL, 0x00ce18130200a5a7ULL, 0x000e24000804007fULL,
0xfffffffc00eca947ULL, 0x001fea000383ffffULL, 0xffffffd400887947ULL, 0x001fea000383ffffULL,
0x00ce1005020075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x00ce1005020085a7ULL, 0x000e24000800007fULL,
0xfffffffc00ec8947ULL, 0x001fea000383ffffULL, 0xffffffd800487947ULL, 0x021fea000383ffffULL,
0x00cda005020075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x00cda005020085a7ULL, 0x000e24000800007fULL,
0xfffffffc00ec8947ULL, 0x001fea000383ffffULL, 0xffffffd8003c7947ULL, 0x021fea000383ffffULL,
0x00cdb009020075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x00cdb009020085a7ULL, 0x000e24000800007fULL,
0xfffffffc00ec8947ULL, 0x001fea000383ffffULL, 0xffffffd800607947ULL, 0x001fea000383ffffULL,
0x00cdc009020075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x00cdc009020085a7ULL, 0x000e24000800007fULL,
0xfffffffc00ec8947ULL, 0x001fea000383ffffULL, 0xffffffdc00707947ULL, 0x001fea000383ffffULL,
0x00ce1009020075a7ULL, 0x0004a2000802017fULL, 0x0000a0000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x00ce1009020095a7ULL, 0x000e24000802007fULL,
0xfffffffc00ec9947ULL, 0x001fea000383ffffULL, 0xffffffe400287947ULL, 0x003fea000383ffffULL,
0x00ce100d020075a7ULL, 0x0004a2000802017fULL, 0x0000a0000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x00ce100d020095a7ULL, 0x000e24000802007fULL,
0xfffffffc00ec9947ULL, 0x001fea000383ffffULL, 0xffffffe400507947ULL, 0x003fea000383ffffULL,
0x00cdf80d170075a7ULL, 0x000b62000802017fULL, 0x0000d0000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x00cdf80d170095a7ULL, 0x000e24000802007fULL,
0xfffffffc00ec9947ULL, 0x001fea000383ffffULL, 0xffffffe400c07947ULL, 0x01ffea000383ffffULL,
0x00000009ff027e24ULL, 0x000fe4000f8e00ffULL, 0x00000009ff037e24ULL, 0x000fce000f8e00ffULL,
0x0000000cff057e24ULL, 0x000fc8000f8e00ffULL, 0x00410803050075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x00410803050085a7ULL, 0x000e24000800007fULL, 0xfffffffc00e88947ULL, 0x001fea000383ffffULL,
0xffffffec00a47947ULL, 0x001fea000383ffffULL, 0x0000000bff027e24ULL, 0x000fe4000f8e00ffULL,
0x0000000bff037e24ULL, 0x000fce000f8e00ffULL, 0x00000009ff057e24ULL, 0x000fc8000f8e00ffULL,
0x00410003050075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x00410003050085a7ULL, 0x000e24000800007fULL,
0xfffffffc00e88947ULL, 0x001fea000383ffffULL, 0xfffffff000807947ULL, 0x001fea000383ffffULL,
0x018000000a087836ULL, 0x000fe20000000000ULL, 0x0000013000037945ULL, 0x000fe80003800000ULL,
0x7f800000080b7812ULL, 0x000fc800078ec0ffULL, 0x018000000b00780cULL, 0x000fda0003f45070ULL,
0x0000000a0008a308ULL, 0x0000620000001000ULL, 0x000000000038a947ULL, 0x000fea0003800000ULL,
0x000000ff0b00720cULL, 0x040fe40003f65070ULL, 0x008000000b00780cULL, 0x000fe40003f42070ULL,
0x00000001ff0b7807ULL, 0x000fe40001800000ULL, 0x00000001ff087807ULL, 0x002fc80005000000ULL,
0x000000080bff7212ULL, 0x000fda000784fcffULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x007fffff0aff7812ULL, 0x040fe4000784c0ffULL, 0x800000000a0a7812ULL, 0x001fe400078ec0ffULL,
0x00000001ff087807ULL, 0x000fc80001000000ULL, 0x000000080bff7212ULL, 0x000fda000784c0ffULL,
0x008000000a082812ULL, 0x000fe200078efcffULL, 0x000000ffff08a224ULL, 0x000fe200078e000aULL,
0x0000000000047947ULL, 0x000fec0003800000ULL, 0x0000000a00087308ULL, 0x0002a40000001000ULL,
0x0000000000037941ULL, 0x000fea0003800000ULL, 0x000000ffff0a7224ULL, 0x003fe400078e000dULL,
0x00000000ff0b7424ULL, 0x000fc800078e00ffULL, 0xffffff980a187950ULL, 0x000fea0003c3ffffULL,
0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000010000ce80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000015bULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000001c5ULL, 0x00000000000001ccULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000398ULL, 0x0000000000000150ULL,
0x0000000c00000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000cbULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000004e8ULL, 0x0000000000000100ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000005e8ULL, 0x0000000000000048ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000630ULL, 0x000000000000076cULL,
0x0000000d00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000126ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000d9cULL, 0x0000000000000020ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000008ULL, 0x00000004000000b5ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000dc0ULL, 0x0000000000000000ULL,
0x0000000d00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000edULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000dc0ULL, 0x0000000000000030ULL,
0x0000000c00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000400000114ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000df0ULL, 0x0000000000000048ULL,
0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000006dULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000e38ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008fULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000e40ULL, 0x0000000000000010ULL,
0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000000ULL, 0x0000000100000032ULL,
0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000000e80ULL, 0x0000000000006880ULL,
0x0000000c00000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007fULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000007700ULL, 0x0000000000000008ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL,
0x0000000000000043ULL, 0x0000000000000000ULL, 0x0000000000007710ULL, 0x0000000000000400ULL,
0x0000000d00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000100000142ULL,
0x0000000000000042ULL, 0x0000000000000000ULL, 0x0000000000007710ULL, 0x0000000000000308ULL,
0x0000000d00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL,
0x0000000000007e58ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000007e58ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000000e38ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000018ULL, 0x0000000000000018ULL, 0x0000000000000008ULL,
0x0000000500000001ULL, 0x0000000000000e80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000006880ULL, 0x0000000000006880ULL, 0x0000000000000008ULL, 0x0000000600000001ULL,
0x0000000000007700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000010ULL,
0x0000000000000410ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000007710ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000308ULL, 0x0000000000000308ULL,
0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_1_kvt_e4m3_nqpkv_8_m_8_sm_90_cubin_len = 32680;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
