/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_1_kvt_e4m3_pagedKV_128_nqpkv_8_m_8_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001f5d0ULL, 0x000000000001f250ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f34314944327961ULL, 0x6f6c66625f766e5fULL,
0x326a4c3236317461ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL,
0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x336a4c4536316a4cULL, 0x4c49746132454532ULL,
0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45346a4c4534366aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL,
0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL,
0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL, 0x45326a4c4545316aULL, 0x7461324545316a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x4939494432796172ULL, 0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL,
0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL,
0x4c4545346a4c6a49ULL, 0x36316a4c4532336aULL, 0x624c497461324545ULL, 0x31534b5245454531ULL,
0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL,
0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL, 0x4c4545326a4c4532ULL, 0x4545316a4c45326aULL,
0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x45386a4c4545346aULL,
0x7461324545386a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL,
0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL,
0x6a4c4536316a4c45ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5f2400676e696469ULL, 0x616e7265746e695fULL, 0x635f5f245f305f6cULL,
0x30326d735f616475ULL, 0x5f6e725f7063725fULL, 0x5f3233665f7a7466ULL, 0x68746170776f6c73ULL,
0x65746e695f5f2400ULL, 0x245f315f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL,
0x6c66625f636e7973ULL, 0x695f5f2400705f79ULL, 0x5f6c616e7265746eULL, 0x6475635f5f245f32ULL,
0x735f30376d735f61ULL, 0x5f636e79736c6668ULL, 0x5f2400705f786469ULL, 0x616e7265746e695fULL,
0x635f5f245f335f6cULL, 0x30376d735f616475ULL, 0x6e797365746f765fULL, 0x746f6c6c61625f63ULL,
0x742e616c65722e00ULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL,
0x5f6c656e72656b2eULL, 0x72656b240061686dULL, 0x2461686d5f6c656eULL, 0x657479426d656d73ULL,
0x2e766e2e00667542ULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x61705f0061686d5fULL,
0x6265642e006d6172ULL, 0x656d6172665f6775ULL, 0x65642e6c65722e00ULL, 0x6d6172665f677562ULL,
0x2e616c65722e0065ULL, 0x72665f6775626564ULL, 0x2e766e2e00656d61ULL, 0x697463612e6c6572ULL,
0x0000000000006e6fULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c0001000000adULL, 0x0000000000000034ULL, 0x0000000000000010ULL, 0x000c0001000000ebULL,
0x000000000000001cULL, 0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c00010000016bULL, 0x000000000000002cULL, 0x0000000000000004ULL,
0x000c0001000001b5ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c0001000001fbULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000242ULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000c000100000288ULL, 0x0000000000000030ULL, 0x0000000000000004ULL,
0x000c0001000002d6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c000100000324ULL,
0x0000000000000018ULL, 0x0000000000000004ULL, 0x000c000100000372ULL, 0x000000000000000cULL,
0x0000000000000004ULL, 0x000c0001000003b9ULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000c000100000407ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c00010000044cULL,
0x0000000000000020ULL, 0x0000000000000004ULL, 0x000b002200000492ULL, 0x000000000001d330ULL,
0x0000000000000170ULL, 0x000b0022000004c5ULL, 0x000000000001d4a0ULL, 0x0000000000000050ULL,
0x000b0022000004f0ULL, 0x000000000001d4f0ULL, 0x0000000000000040ULL, 0x000b00220000051aULL,
0x000000000001d530ULL, 0x0000000000000150ULL, 0x000a000300000588ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00040003000005a8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00070003000005d8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL,
0x0000000000000000ULL, 0x000000000001d680ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0001d33000000000ULL,
0x0000040400000000ULL, 0x810c0000015c0400ULL, 0x0073640400288080ULL, 0x0000000000000000ULL,
0x000000ccffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080960828808081ULL, 0xa008288080980828ULL, 0x288080a408288080ULL,
0x80a608288080a508ULL, 0x08288080a8082880ULL, 0x8080ac08288080a9ULL, 0xae08288080ad0828ULL,
0x288080af08288080ULL, 0x80b808288080b008ULL, 0x08288080ba082880ULL, 0x8080be08288080bcULL,
0xc208288080c00828ULL, 0x288080c408288080ULL, 0x80c608288080c508ULL, 0x08288080c7082880ULL,
0x8080c908288080c8ULL, 0xcb08288080ca0828ULL, 0x288080cc08288080ULL, 0x808408288080ce08ULL,
0x1028808280162880ULL, 0x0000000000000003ULL, 0x2200288080849200ULL, 0x0000001cffffffffULL,
0x0000007000000000ULL, 0x0001d33000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL,
0x000000ccffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080880828808081ULL, 0x9808288080960828ULL, 0x288080a008288080ULL,
0x80a508288080a408ULL, 0x08288080a6082880ULL, 0x8080a808288080a7ULL, 0xac08288080a90828ULL,
0x288080ad08288080ULL, 0x80af08288080ae08ULL, 0x08288080b0082880ULL, 0x8080be08288080b8ULL,
0xc208288080c00828ULL, 0x288080c408288080ULL, 0x80c608288080c508ULL, 0x08288080c8082880ULL,
0x8080ca08288080c9ULL, 0xcc08288080cb0828ULL, 0x288080ce08288080ULL, 0x828016288080ba08ULL,
0x0000000003102880ULL, 0x8080ba9200000000ULL, 0x0000000000220028ULL, 0x0000002cffffffffULL,
0x0000017000000000ULL, 0x0001d4a000000000ULL, 0x0000005000000000ULL, 0x00000c0400000000ULL,
0x8088288080ba0900ULL, 0x0000000000002880ULL, 0x000000ccffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080960828808081ULL,
0xa008288080980828ULL, 0x288080a408288080ULL, 0x80a608288080a508ULL, 0x08288080a7082880ULL,
0x8080a908288080a8ULL, 0xad08288080ac0828ULL, 0x288080ae08288080ULL, 0x80b008288080af08ULL,
0x08288080b8082880ULL, 0x8080bc08288080baULL, 0xc008288080be0828ULL, 0x288080c208288080ULL,
0x80c508288080c408ULL, 0x08288080c6082880ULL, 0x8080c908288080c7ULL, 0xcb08288080ca0828ULL,
0x288080cc08288080ULL, 0x80c808288080ce08ULL, 0x1028808280162880ULL, 0x0000000000000003ULL,
0x2200288080c89200ULL, 0x0000001cffffffffULL, 0x0000028000000000ULL, 0x0001d4f000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x000000ccffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080960828808081ULL,
0xa008288080980828ULL, 0x288080a408288080ULL, 0x80a608288080a508ULL, 0x08288080a7082880ULL,
0x8080a908288080a8ULL, 0xad08288080ac0828ULL, 0x288080ae08288080ULL, 0x80b008288080af08ULL,
0x08288080b8082880ULL, 0x8080bc08288080baULL, 0xc008288080be0828ULL, 0x288080c208288080ULL,
0x80c508288080c408ULL, 0x08288080c6082880ULL, 0x8080c908288080c7ULL, 0xcb08288080ca0828ULL,
0x288080cc08288080ULL, 0x80c808288080ce08ULL, 0x1028808280162880ULL, 0x0000000000000003ULL,
0x2200288080c89200ULL, 0x0000001cffffffffULL, 0x0000038000000000ULL, 0x0001d53000000000ULL,
0x0000015000000000ULL, 0x0000000000000000ULL, 0x0000001a00082f04ULL, 0x0008230400000099ULL,
0x0000000000000016ULL, 0x0000001600081204ULL, 0x0008110400000000ULL, 0x0000000000000016ULL,
0x0000001500082304ULL, 0x0008120400000000ULL, 0x0000000000000015ULL, 0x0000001500081104ULL,
0x0008230400000000ULL, 0x0000000000000014ULL, 0x0000001400081204ULL, 0x0008110400000000ULL,
0x0000000000000014ULL, 0x0000001300082304ULL, 0x0008120400000000ULL, 0x0000000000000013ULL,
0x0000001300081104ULL, 0x0008230400000000ULL, 0x000000000000001aULL, 0x0000001a00081204ULL,
0x0008110400000000ULL, 0x000000000000001aULL, 0x0000007b00043704ULL, 0x0000001700080a04ULL,
0x0050190300500160ULL, 0x00000000000c1704ULL, 0x0021f00000480006ULL, 0x00000000000c1704ULL,
0x0021f00000400005ULL, 0x00000000000c1704ULL, 0x0011f00000380004ULL, 0x00000000000c1704ULL,
0x0081f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL, 0x00000000000c1704ULL,
0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x0004310400ff1b03ULL,
0x0198290400000020ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x000000e001982804ULL, 0x0000047000000100ULL, 0x0000211000002060ULL, 0x0000237000002200ULL,
0x000027f0000027c0ULL, 0x0000289000002840ULL, 0x00004ea000004e70ULL, 0x00004f4000004ef0ULL,
0x0000762000007590ULL, 0x0000789000007730ULL, 0x00007d5000007d20ULL, 0x00007df000007da0ULL,
0x0000a2100000a1e0ULL, 0x0000a2b00000a260ULL, 0x0000c8100000c790ULL, 0x0000ca800000c920ULL,
0x0000cf200000cef0ULL, 0x0000cfc00000cf70ULL, 0x0000f3e00000f3b0ULL, 0x0000f4800000f430ULL,
0x00011a60000119e0ULL, 0x00011cd000011b70ULL, 0x0001217000012140ULL, 0x00012210000121c0ULL,
0x0001465000014620ULL, 0x000146f0000146a0ULL, 0x000160d0000160c0ULL, 0x0001b7e0000168a0ULL,
0x0001b8300001b820ULL, 0x0001b8900001b840ULL, 0x0001b8d00001b8b0ULL, 0x0001c5a00001b8e0ULL,
0x0001c6400001c5f0ULL, 0x0001c6d00001c680ULL, 0x0001c7900001c730ULL, 0x0001c8400001c7f0ULL,
0x0001c8e00001c890ULL, 0x0001c9700001c920ULL, 0x0001ca300001c9d0ULL, 0x0001cae00001ca90ULL,
0x0001cb800001cb30ULL, 0x0001cc100001cbc0ULL, 0x0001ccd00001cc70ULL, 0x0001cd800001cd30ULL,
0x0001ce300001cdd0ULL, 0x0001cef00001ce90ULL, 0x0001cfb00001cf50ULL, 0x0001d0700001d010ULL,
0x0001d1300001d0d0ULL, 0x0001d1f00001d190ULL, 0x0001d2b00001d250ULL, 0x060039040001d310ULL,
0x000000ff00000200ULL, 0x003f010000010600ULL, 0x0000000d000002d0ULL, 0x003f012000010608ULL,
0x0000000d00000300ULL, 0x003f012000010688ULL, 0x0000000d00000440ULL, 0x003f0120000106a8ULL,
0x000000ff00000460ULL, 0x003f0100000106b8ULL, 0x000000ff000004f0ULL, 0x003f010700010600ULL,
0x0000001f00000640ULL, 0x003f01020001068cULL, 0x0000001f000006a0ULL, 0x003f010100010688ULL,
0x000000ff00000f00ULL, 0x003f0107000106a8ULL, 0x000000ff00001020ULL, 0x003f0101000106a8ULL,
0x000000ff00001080ULL, 0x003f0101000106b8ULL, 0x000000ff00001210ULL, 0x003f0105000106bcULL,
0x000000ff000013e0ULL, 0x003f0105000106bcULL, 0x000000ff00001ca0ULL, 0x003f0107000106b0ULL,
0x000000ff00001d20ULL, 0x003f0101000106b0ULL, 0x0000001f00001d80ULL, 0x003f010100010608ULL,
0x0000001f00001da0ULL, 0x003f01050001060cULL, 0x0000001f00001f70ULL, 0x003f01050001060cULL,
0x000000ff00002520ULL, 0x003f0105000106acULL, 0x000000ff000026f0ULL, 0x003f0105000106acULL,
0x000000ff00004100ULL, 0x003f0101000106b8ULL, 0x000000ff00004130ULL, 0x003f0105000106bcULL,
0x000000ff000042f0ULL, 0x003f0105000106bcULL, 0x000000ff00004b40ULL, 0x003f0107000106a8ULL,
0x000000ff00004bc0ULL, 0x003f0101000106a8ULL, 0x000000ff00004bf0ULL, 0x003f0105000106b4ULL,
0x000000ff00004dc0ULL, 0x003f0105000106b4ULL, 0x000000ff000066d0ULL, 0x003f0101000106b8ULL,
0x000000ff00006740ULL, 0x003f010100010688ULL, 0x000000ff00006790ULL, 0x003f0105000106bcULL,
0x000000ff00006960ULL, 0x003f0105000106bcULL, 0x000000ff000071b0ULL, 0x003f0107000106b0ULL,
0x000000ff000072b0ULL, 0x003f0101000106b0ULL, 0x0000001f00007310ULL, 0x003f010100010628ULL,
0x0000001f00007330ULL, 0x003f01050001062cULL, 0x0000001f00007500ULL, 0x003f01050001062cULL,
0x000000ff00007a80ULL, 0x003f0105000106acULL, 0x000000ff00007c50ULL, 0x003f0105000106acULL,
0x000000ff00009470ULL, 0x003f0101000106b8ULL, 0x000000ff000094a0ULL, 0x003f0105000106bcULL,
0x000000ff00009660ULL, 0x003f0105000106bcULL, 0x000000ff00009eb0ULL, 0x003f0107000106a8ULL,
0x000000ff00009f30ULL, 0x003f0101000106a8ULL, 0x000000ff00009f60ULL, 0x003f0105000106b4ULL,
0x000000ff0000a130ULL, 0x003f0105000106b4ULL, 0x000000ff0000b940ULL, 0x003f0101000106b8ULL,
0x000000ff0000b9b0ULL, 0x003f010100010690ULL, 0x000000ff0000ba10ULL, 0x003f0105000106bcULL,
0x000000ff0000bbe0ULL, 0x003f0105000106bcULL, 0x000000ff0000c430ULL, 0x003f0107000106b0ULL,
0x000000ff0000c4b0ULL, 0x003f0101000106b0ULL, 0x0000001f0000c510ULL, 0x003f010100010648ULL,
0x0000001f0000c530ULL, 0x003f01050001064cULL, 0x0000001f0000c700ULL, 0x003f01050001064cULL,
0x000000ff0000cc50ULL, 0x003f0105000106acULL, 0x000000ff0000ce20ULL, 0x003f0105000106acULL,
0x000000ff0000e640ULL, 0x003f0101000106b8ULL, 0x000000ff0000e670ULL, 0x003f0105000106bcULL,
0x000000ff0000e830ULL, 0x003f0105000106bcULL, 0x000000ff0000f080ULL, 0x003f0107000106a8ULL,
0x000000ff0000f100ULL, 0x003f0101000106a8ULL, 0x000000ff0000f130ULL, 0x003f0105000106b4ULL,
0x000000ff0000f300ULL, 0x003f0105000106b4ULL, 0x000000ff00010b10ULL, 0x003f0101000106b8ULL,
0x000000ff00010b80ULL, 0x003f010100010698ULL, 0x000000ff00010be0ULL, 0x003f0105000106bcULL,
0x000000ff00010db0ULL, 0x003f0105000106bcULL, 0x000000ff00011600ULL, 0x003f0107000106b0ULL,
0x000000ff00011700ULL, 0x003f0101000106b0ULL, 0x0000001f00011760ULL, 0x003f010100010668ULL,
0x0000001f00011780ULL, 0x003f01050001066cULL, 0x0000001f00011950ULL, 0x003f01050001066cULL,
0x000000ff00011ea0ULL, 0x003f0105000106acULL, 0x000000ff00012070ULL, 0x003f0105000106acULL,
0x000000ff00013890ULL, 0x003f0101000106b8ULL, 0x000000ff000138c0ULL, 0x003f0105000106bcULL,
0x000000ff00013a80ULL, 0x003f0105000106bcULL, 0x000000ff000142f0ULL, 0x003f0107000106a8ULL,
0x000000ff00014370ULL, 0x003f0101000106a8ULL, 0x000000ff000143a0ULL, 0x003f0105000106b4ULL,
0x000000ff00014570ULL, 0x003f0105000106b4ULL, 0x000000ff00015d80ULL, 0x003f0101000106b8ULL,
0x000000ff00015de0ULL, 0x003f0101000106a0ULL, 0x000000ff00016b10ULL, 0x003f010100010600ULL,
0x000000ff000178e0ULL, 0x003f010500010604ULL, 0x000000ff00017ab0ULL, 0x003f010500010604ULL,
0x000000ff00017e20ULL, 0x003f010100010600ULL, 0x000000ff00017e50ULL, 0x003f010500010604ULL,
0x000000ff00018010ULL, 0x003f010500010604ULL, 0x000000350001ac20ULL, 0x003f010100000000ULL,
0x000000350001ad10ULL, 0x003f010500000004ULL, 0x000000350001aee0ULL, 0x003f010500000004ULL,
0x000000370001c400ULL, 0x003f010100000000ULL, 0x000000370001c460ULL, 0x003f010100000008ULL,
0x000000370001c4c0ULL, 0x003f010100000010ULL, 0x000000370001c530ULL, 0x003f010100000018ULL,
0x00101c0400053803ULL, 0x00018070000169e0ULL, 0x0001c57000018120ULL, 0x000c050400000401ULL,
0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x000000000000046cULL, 0x0000001a00000002ULL, 0x000000000000036cULL,
0x0000001a00000002ULL, 0x000000000000025cULL, 0x0000001a00000002ULL, 0x000000000000015cULL,
0x0000001a00000002ULL, 0x0000000000000044ULL, 0x0000001a00000002ULL, 0x0000000000000449ULL,
0x0000001a00000002ULL, 0x0000000000000349ULL, 0x0000001a00000002ULL, 0x0000000000000234ULL,
0x0000001a00000002ULL, 0x0000000000000139ULL, 0x0000001a00000002ULL, 0x0000000000010700ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x00000000000d7919ULL, 0x000e620000002100ULL,
0x0000000000107806ULL, 0x000fe200038e0000ULL, 0x00005800ff317624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000037919ULL, 0x000ea20000002300ULL,
0x0000001000087300ULL, 0x000fe200000e0000ULL, 0x0000000831077824ULL, 0x000fe400078e00ffULL,
0x0000000000047919ULL, 0x000ee80000002200ULL, 0x0000000000007919ULL, 0x000f220000002600ULL,
0x0000001000137309ULL, 0x000ea60000000000ULL, 0x00000000000a7919ULL, 0x000f280000000000ULL,
0x0000000000227919ULL, 0x000f220000002700ULL, 0x00000005ff027819ULL, 0x002fc6000001160dULL,
0x00001fff030c7589ULL, 0x0047e200000e0000ULL, 0x000000ffff137224ULL, 0x000fc600078e0a13ULL,
0x00001fff02027589ULL, 0x000e6200000e0000ULL, 0x0000010003037a24ULL, 0x008fe400078e0204ULL,
0x0000000800067824ULL, 0x010fe400078e00ffULL, 0x00000000030d7a24ULL, 0x000fe200078e020dULL,
0x0000000a0800720cULL, 0x000fe20003f02070ULL, 0x0000000000037919ULL, 0x000ea20000000000ULL,
0x0000002207087224ULL, 0x000fe400078e0206ULL, 0x000000ff0d00720cULL, 0x000fc40003f25270ULL,
0x0000000f0d00780cULL, 0x040fe40003f44070ULL, 0x000000030d00780cULL, 0x040fe40003f64070ULL,
0x0000007f0d00780cULL, 0x000fe20003f84070ULL, 0x000000040c097824ULL, 0x002fcc00078e0202ULL,
0x3fffff80ff049424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff059424ULL, 0x000fe400078e00ffULL,
0x0000000209097824ULL, 0x000fe400078e00ffULL, 0x3fffff60ff06b424ULL, 0x000fe200078e00ffULL,
0x01060004ff009388ULL, 0x0003e20000000a00ULL, 0x7fffff60ff07b424ULL, 0x000fe400078e00ffULL,
0xff317217ff0bc424ULL, 0x000fc400078e00ffULL, 0x00000001090a7824ULL, 0x044fe400078e0203ULL,
0x00000020090f7824ULL, 0x000fe200078e00ffULL, 0x0104000b0d00c388ULL, 0x0005e20000004800ULL,
0x00000010030e7824ULL, 0x000fe400078e00ffULL, 0x3fffffc0ff04a424ULL, 0x002fe200078e00ffULL,
0xffffffe00f0f7812ULL, 0x000fe200078ee20aULL, 0x7fffffc0ff05a424ULL, 0x000fe200078e00ffULL,
0x000001f00e117812ULL, 0x000fe200078ec0ffULL, 0x3fffff80ff0a9424ULL, 0x000fc400078e00ffULL,
0x000000100f0f7824ULL, 0x000fe200078e00ffULL, 0x010608040d00a388ULL, 0x0003e20000008a00ULL,
0x000000010d00780cULL, 0x000fe20003f44070ULL, 0x7fffff80ff0b9424ULL, 0x004fe400078e00ffULL,
0x010688060d00b388ULL, 0x0005e20000008a00ULL, 0x0000000809047817ULL, 0x042fe20007800000ULL,
0x0000000108057824ULL, 0x100fe400078e0209ULL, 0x00000200ff077424ULL, 0x004fe400078e00ffULL,
0x0000000104047824ULL, 0x000fe200078e0a09ULL, 0x0000000109097810ULL, 0x000fc80007ffe0ffULL,
0x000000ff0400720cULL, 0x000fe20003f63070ULL, 0x0000000108067824ULL, 0x000fe200078e0209ULL,
0x000000010400780cULL, 0x000fe20003f83070ULL, 0x00005c0005047625ULL, 0x000fc800078e0007ULL,
0x0000000109107824ULL, 0x040fe200078e0203ULL, 0x0000001104047210ULL, 0x000fe20007fbe0ffULL,
0x0000002009127824ULL, 0x000fe400078e00ffULL, 0x00005c0006067625ULL, 0x000fc600078e0007ULL,
0xffffffe012107812ULL, 0x000fe200078ee210ULL, 0x3fffff00ff08a424ULL, 0x000fe200078e00ffULL,
0x0000001106067210ULL, 0x000fe20007fde0ffULL, 0x7fffff00ff09a424ULL, 0x000fe400078e00ffULL,
0x000000ffff057224ULL, 0x000fe400028e0605ULL, 0x000000ffff077224ULL, 0x000fe200030e0607ULL,
0x0106a8080d00a388ULL, 0x000fe20000008a00ULL, 0x0000001010107824ULL, 0x000fc600078e00ffULL,
0x0106b80aff009388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040f7faeULL, 0x0003e8000d901c46ULL,
0x0000000006107faeULL, 0x0005e2000e101c46ULL, 0x000000ffff047224ULL, 0x002fc400078e0013ULL,
0x00000004ff057424ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x004fe60000000000ULL,
0x00006200221c7625ULL, 0x000fe200078e0005ULL, 0x01060404ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01060000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x000000061c1c7981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0c00720cULL, 0x000fc40003f05270ULL,
0x0000007f1c1d7810ULL, 0x044fe40007ffe0ffULL, 0x000000ff1c067810ULL, 0x000fe40007ffe0ffULL,
0x00000007ff1d7819ULL, 0x000fe4000001161dULL, 0x00000008ff1e7819ULL, 0x000fca0000011606ULL,
0x0001640000008947ULL, 0x000fea0003800000ULL, 0x000001ff0600780cULL, 0x000fe20003f24070ULL,
0x00000008021f7824ULL, 0x000fe200078e00ffULL, 0x000000ff1d00720cULL, 0x000fe20003f05270ULL,
0x00000003ff047424ULL, 0x002fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01068c041fff738cULL, 0x0003e20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010688001fff7f8cULL, 0x0005e2000c80043fULL, 0xffffffffff207424ULL, 0x000fe200078e00ffULL,
0x0000005000008947ULL, 0x000fea0003800000ULL, 0x0000000222047824ULL, 0x002fe400078e00ffULL,
0x00006400ff067624ULL, 0x000fc800078e00ffULL, 0x0000640004047624ULL, 0x000fc800078e0206ULL,
0x0000600004207625ULL, 0x000fcc00078e0005ULL, 0x0000000620207981ULL, 0x000324000c1e1900ULL,
0x0000580020047a24ULL, 0x012fc800078e02ffULL, 0x0000008004107824ULL, 0x000fe200078e00ffULL,
0x0000043000001947ULL, 0x000fea0003800000ULL, 0x0000001f1c047217ULL, 0x000fe40007800000ULL,
0x00000004ff057819ULL, 0x000fe40000011603ULL, 0x000000f00e137812ULL, 0x000fe200078ec0ffULL,
0x0000000104047824ULL, 0x000fe200078e0a1fULL, 0x0000000205077810ULL, 0x000fe20007ffe0ffULL,
0x000000011f067824ULL, 0x000fe200078e0205ULL, 0x00000004050a7810ULL, 0x040fe40007ffe0ffULL,
0x000000040500720cULL, 0x080fe20003f06070ULL, 0x000000011f087824ULL, 0x000fe200078e0207ULL,
0x00000006050b7810ULL, 0x000fe20007ffe0ffULL, 0x0000008000057824ULL, 0x000fe200078e0206ULL,
0x000000040700720cULL, 0x080fe20003f26070ULL, 0x0000000106077824ULL, 0x100fe200078e0203ULL,
0x000000040a00720cULL, 0x000fe20003f46070ULL, 0x0000001006097824ULL, 0x000fe200078e00ffULL,
0x00000005100c7210ULL, 0x000fe20007f7e0ffULL, 0x0000000108067824ULL, 0x000fc400078e0203ULL,
0x00000010080f7824ULL, 0x000fe200078e00ffULL, 0xfffffff009077812ULL, 0x000fe200078ee207ULL,
0x000000ffff0d7224ULL, 0x000fe200018e06ffULL, 0x000000040b00720cULL, 0x000fe20003f66070ULL,
0x000000011f0a7824ULL, 0x000fe200078e020aULL, 0x0000000205047810ULL, 0x000fe40007ffe0ffULL,
0x00005e000c087a11ULL, 0x000fe400078840ffULL, 0xfffffff00f097812ULL, 0x000fe400078ee206ULL,
0x0000000405067810ULL, 0x000fc40007ffe0ffULL, 0x0000000410127210ULL, 0x000fe20007fde0ffULL,
0x000000010a047824ULL, 0x000fe200078e0203ULL, 0x00005f000c0c7a11ULL, 0x000fe200020f440dULL,
0x000000100a0a7824ULL, 0x000fe200078e00ffULL, 0x0000000605057810ULL, 0x000fe40007ffe0ffULL,
0x00000006100f7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff067224ULL, 0x000fe200030e06ffULL,
0x00005e0012117a11ULL, 0x000fe400078c40ffULL, 0x00000005100d7210ULL, 0x000fe20007fbe0ffULL,
0x000000011f057824ULL, 0x000fe200078e020bULL, 0xfffffff00a0b7812ULL, 0x000fe200078ee204ULL,
0x000000ffff107224ULL, 0x000fe200020e06ffULL, 0x00005f0012127a11ULL, 0x000fe200030f4406ULL,
0x0000000105067824ULL, 0x000fe200078e0203ULL, 0x0000000813047210ULL, 0x000fe20007fde0ffULL,
0x0000001005147824ULL, 0x000fe200078e00ffULL, 0x0000c00007077811ULL, 0x000fe200078e20ffULL,
0x000000ffff0a7224ULL, 0x000fe200028e06ffULL, 0x00005e000f0e7a11ULL, 0x000fe200078840ffULL,
0x000000ffff057224ULL, 0x000fe200030e060cULL, 0x00005e000d087a11ULL, 0x000fc400078a40ffULL,
0xfffffff0140c7812ULL, 0x000fe400078ee206ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004077faeULL, 0x0003e2000c101c46ULL, 0x00005f000f0f7a11ULL, 0x000fe400020f4410ULL,
0x00005f000d0d7a11ULL, 0x000fe400028f440aULL, 0x000000130e067210ULL, 0x080fe40007f9e0ffULL,
0x0000001308087210ULL, 0x000fe40007fbe0ffULL, 0x0000c000090a7811ULL, 0x000fc400078e20ffULL,
0x0000c0000b0b7811ULL, 0x000fe200078e20ffULL, 0x000000ffff077224ULL, 0x002fe200020e060fULL,
0x0000001311047210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff097224ULL, 0x000fe200028e060dULL,
0x0000c0000c0c7811ULL, 0x000fc600078e20ffULL, 0x000000ffff057224ULL, 0x000fca00000e0612ULL,
0x00000000040a7faeULL, 0x0003e8000c901c46ULL, 0x00000000060b7faeULL, 0x0003e8000d101c46ULL,
0x00000000080c7faeULL, 0x0003e2000d901c46ULL, 0x0000038000007947ULL, 0x000fea0003800000ULL,
0x0000001f03047211ULL, 0x000fe400078fe0ffULL, 0x000000f00e137812ULL, 0x000fc400078ec0ffULL,
0x0000000204067810ULL, 0x040fe20007ffe0ffULL, 0x0000000104057824ULL, 0x140fe200078e0203ULL,
0x00000006040a7810ULL, 0x040fe20007ffe0ffULL, 0x0000001004087824ULL, 0x000fe400078e00ffULL,
0x0000000106077824ULL, 0x040fe400078e0203ULL, 0x0000001006097824ULL, 0x000fe200078e00ffULL,
0xfffffff008067812ULL, 0x000fe200078ee205ULL, 0x0000008000057824ULL, 0x000fc600078e0204ULL,
0xfffffff009097812ULL, 0x000fe400078ee207ULL, 0x0000000404077810ULL, 0x000fe40007ffe0ffULL,
0x0000000510127210ULL, 0x040fe40007f1e0ffULL, 0x0000000405087810ULL, 0x000fe20007ffe0ffULL,
0x00000010070c7824ULL, 0x000fe200078e00ffULL, 0x0000000205047810ULL, 0x040fe40007ffe0ffULL,
0x00000006050b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000107057824ULL, 0x100fe200078e0203ULL,
0x00000008100f7210ULL, 0x000fe20007f5e0ffULL, 0x000000010a077824ULL, 0x000fe200078e0203ULL,
0x0000000410117210ULL, 0x000fe20007f3e0ffULL, 0x000000100a0a7824ULL, 0x000fe200078e00ffULL,
0x0000000b100d7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x00005e0012047a11ULL, 0x000fe200078040ffULL, 0x000000ffff0e7224ULL, 0x000fe200010e06ffULL,
0xfffffff00c0b7812ULL, 0x000fe200078ee205ULL, 0x000000ffff057224ULL, 0x000fe200018e06ffULL,
0xfffffff00a0c7812ULL, 0x000fe200078ee207ULL, 0x000000ffff077224ULL, 0x000fe200008e06ffULL,
0x00005f0012127a11ULL, 0x000fc400000f4408ULL, 0x00005e0011107a11ULL, 0x000fe400078240ffULL,
0x00005e000d0a7a11ULL, 0x000fe400078640ffULL, 0x0000000413047210ULL, 0x000fe40007f1e0ffULL,
0x00005e000f087a11ULL, 0x000fe400078440ffULL, 0x00005f0011117a11ULL, 0x000fe400008f4407ULL,
0x00005f000d0d7a11ULL, 0x000fe200018f4405ULL, 0x000000ffff057224ULL, 0x000fe200000e0612ULL,
0x0000c00006077811ULL, 0x000fc400078e20ffULL, 0x0000001013067210ULL, 0x000fe40007f1e0ffULL,
0x00005f000f0e7a11ULL, 0x000fe200010f440eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004077faeULL, 0x0003e2000b901c46ULL, 0x0000000813087210ULL, 0x040fe40007f3e0ffULL,
0x0000000a130a7210ULL, 0x000fe40007f5e0ffULL, 0x0000c0000c0c7811ULL, 0x000fe400078e20ffULL,
0x0000c00009047811ULL, 0x002fe200078e20ffULL, 0x000000ffff077224ULL, 0x000fe200000e0611ULL,
0x0000c0000b057811ULL, 0x000fe200078e20ffULL, 0x000000ffff097224ULL, 0x000fc400008e060eULL,
0x000000ffff0b7224ULL, 0x000fe200010e060dULL, 0x0000000006047faeULL, 0x0003e8000b901c46ULL,
0x0000000008057faeULL, 0x0003e8000b901c46ULL, 0x000000000a0c7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x000000ff1e00720cULL, 0x000fe20003f05270ULL,
0x000000ffff217224ULL, 0x000fe200078e00ffULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x000000ffff057224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff447f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b800ff247f8cULL, 0x000ee2000c80043fULL, 0x000000ffff047224ULL, 0x000fe200078e00ffULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x00014d2000008947ULL, 0x000fea0003800000ULL, 0x0000000222227824ULL, 0x000fe400078e00ffULL,
0x00006400ff137624ULL, 0x000fc400078e00ffULL, 0x000000ffff447224ULL, 0x002fe400078e0045ULL,
0x0000640022227624ULL, 0x000fe400078e0213ULL, 0x000000ffff4e7224ULL, 0x008fe400078e0025ULL,
0xff317217ff467424ULL, 0x000fe400078e00ffULL, 0x000000ffff237224ULL, 0x000fe400078e00ffULL,
0x000000ffff247224ULL, 0x000fc400078e00ffULL, 0x000000ffff137224ULL, 0x000fc400078e00ffULL,
0x0000010023257824ULL, 0x000fca00078e00ffULL, 0x0000001c2500720cULL, 0x000fda0003f06070ULL,
0x00014c2000000947ULL, 0x004fea0003800000ULL, 0x000000ffff257224ULL, 0x000fc400078e0024ULL,
0x0000000000267805ULL, 0x000fca0000015200ULL, 0x0106bc00ff287984ULL, 0x000e640000000800ULL,
0x8000000028ff7812ULL, 0x002fe4000780484eULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff2e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000287805ULL, 0x000fcc0000015200ULL,
0x00000028262a7210ULL, 0x000fca0007f1e1ffULL, 0x0000000129297824ULL, 0x000fe200000e0e27ULL,
0x003d09002a00780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402a00780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff287819ULL, 0x000fc80000011429ULL, 0x0000002a28287211ULL, 0x000fca00078110ffULL,
0x000000ffff297224ULL, 0x000fca00000e0629ULL, 0x0000000228287819ULL, 0x000fc80000001229ULL,
0x000000280000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012e2e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106bc00ff287984ULL, 0x000e640000000800ULL, 0x8000000028ff7812ULL, 0x002fe4000780484eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000123267810ULL, 0x000fe20007ffe0ffULL,
0x00005800204d7a24ULL, 0x000fc600078e02ffULL, 0x0000001e2600720cULL, 0x000fe20003f26070ULL,
0x000000804d4d7824ULL, 0x000fd800078e00ffULL, 0x0000048000009947ULL, 0x000fea0003800000ULL,
0x0000002023267811ULL, 0x000fe400078e40ffULL, 0x00000004ff317819ULL, 0x000fe40000011603ULL,
0x000000261c277217ULL, 0x000fe40007800000ULL, 0x0000000431377810ULL, 0x000fe20007ffe0ffULL,
0x000000011f287824ULL, 0x000fe200078e0231ULL, 0x0000000231347810ULL, 0x000fe20007ffe0ffULL,
0x0000000127277824ULL, 0x000fe200078e0a26ULL, 0x0000002000267811ULL, 0x000fe200078e38ffULL,
0x0000000128297824ULL, 0x040fe200078e0203ULL, 0x0000000631417810ULL, 0x000fe20007ffe0ffULL,
0x0000001028357824ULL, 0x000fe200078e00ffULL, 0x000000271f277217ULL, 0x040fe20007800000ULL,
0x000000011f2e7824ULL, 0x000fc400078e0237ULL, 0x000000011f2a7824ULL, 0x000fe200078e0234ULL,
0xfffffff035357812ULL, 0x000fe200078ee229ULL, 0x000000012e2f7824ULL, 0x140fe400078e0203ULL,
0x000000102e407824ULL, 0x000fe400078e00ffULL, 0x0000000128287824ULL, 0x000fe400078e0226ULL,
0x000000012a297824ULL, 0x000fe200078e0203ULL, 0xfffffff040407812ULL, 0x000fe200078ee22fULL,
0x000000102a367824ULL, 0x000fe200078e00ffULL, 0x000000284d2f7210ULL, 0x000fe20007f1e0ffULL,
0x000000011f307824ULL, 0x000fc400078e0241ULL, 0x0000000127287824ULL, 0x000fe200078e0a1fULL,
0xfffffff036367812ULL, 0x000fe200078ee229ULL, 0x000000012a297824ULL, 0x100fe400078e0226ULL,
0x000000012e2a7824ULL, 0x100fe400078e0226ULL, 0x0000000130267824ULL, 0x040fe200078e0226ULL,
0x000000294d297210ULL, 0x040fe20007f5e0ffULL, 0x0000000130327824ULL, 0x040fe200078e0203ULL,
0x0000002a4d2a7210ULL, 0x000fe20007f9e0ffULL, 0x0000001030427824ULL, 0x000fc400078e00ffULL,
0x000000ffff307224ULL, 0x000fe200000e06ffULL, 0x00005e002f2e7a11ULL, 0x040fe200078040ffULL,
0x000000ffff337224ULL, 0x000fe200010e06ffULL, 0x000000283400720cULL, 0x080fe40003f46070ULL,
0x00005f002f277a11ULL, 0x000fe200000f4430ULL, 0x00000010032f7824ULL, 0x000fe200078e00ffULL,
0x000000283100720cULL, 0x000fe20003f06070ULL, 0x000000ffff317224ULL, 0x000fe200020e06ffULL,
0x00005e002a307a11ULL, 0x000fe400078a40ffULL, 0x000000f02f347812ULL, 0x000fc400078ec0ffULL,
0x000000264d2f7210ULL, 0x000fe40007fde0ffULL, 0xfffffff042427812ULL, 0x000fe400078ee232ULL,
0x000000342e267210ULL, 0x000fe40007f9e0ffULL, 0x00005f002a317a11ULL, 0x000fe200028f4431ULL,
0x000000ffff2a7224ULL, 0x000fe200030e06ffULL, 0x00005e0029327a11ULL, 0x000fe200078640ffULL,
0x000000ffff277224ULL, 0x000fe200020e0627ULL, 0x00005e002f2e7a11ULL, 0x000fc400078a40ffULL,
0x00005f0029337a11ULL, 0x000fe400018f4433ULL, 0x000000283700720cULL, 0x080fe40003f66070ULL,
0x0000e00035297811ULL, 0x000fe400078e20ffULL, 0x000000284100720cULL, 0x000fe40003f86070ULL,
0x00005f002f2f7a11ULL, 0x000fe200028f442aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026297faeULL, 0x0003e2000c101c46ULL, 0x0000003432287210ULL, 0x000fc40007fbe0ffULL,
0x0000e000362a7811ULL, 0x000fe400078e20ffULL, 0x0000003430267210ULL, 0x082fe20007f1e0ffULL,
0x000000ffff297224ULL, 0x000fe200028e0633ULL, 0x000000342e2e7210ULL, 0x000fe40007fbe0ffULL,
0x0000e00040307811ULL, 0x000fe200078e20ffULL, 0x000000ffff277224ULL, 0x000fe200000e0631ULL,
0x0000e00042317811ULL, 0x000fe200078e20ffULL, 0x000000ffff2f7224ULL, 0x000fe200028e062fULL,
0x00000000282a7faeULL, 0x0003e8000d101c46ULL, 0x0000000026307faeULL, 0x0003e8000d901c46ULL,
0x000000002e317faeULL, 0x0003e2000e101c46ULL, 0x000003a000007947ULL, 0x000fea0003800000ULL,
0x0000001f03277211ULL, 0x000fe400078fe0ffULL, 0x0000002000287811ULL, 0x000fc400078e38ffULL,
0x0000000227297810ULL, 0x040fe20007ffe0ffULL, 0x0000000127267824ULL, 0x140fe200078e0203ULL,
0x00000006272f7810ULL, 0x040fe20007ffe0ffULL, 0x0000001027367824ULL, 0x000fe400078e00ffULL,
0x00000001292a7824ULL, 0x140fe400078e0203ULL, 0x0000001029377824ULL, 0x000fe200078e00ffULL,
0xfffffff036367812ULL, 0x000fe200078ee226ULL, 0x0000000127267824ULL, 0x000fe400078e0228ULL,
0x000000012f307824ULL, 0x000fe200078e0203ULL, 0xfffffff037377812ULL, 0x000fe200078ee22aULL,
0x000000102f417824ULL, 0x000fe200078e00ffULL, 0x000000264d347210ULL, 0x000fe20007f1e0ffULL,
0x0000000129267824ULL, 0x000fe200078e0228ULL, 0x00000004272a7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff041417812ULL, 0x000fe200078ee230ULL, 0x000000ffff297224ULL, 0x000fe200000e06ffULL,
0x00005e0034337a11ULL, 0x000fe200078040ffULL, 0x000000012a277824ULL, 0x100fe400078e0228ULL,
0x000000012f287824ULL, 0x000fe200078e0228ULL, 0x00005f0034347a11ULL, 0x000fe200000f4429ULL,
0x000000012a2e7824ULL, 0x040fe200078e0203ULL, 0x000000264d327210ULL, 0x040fe20007f1e0ffULL,
0x000000102a407824ULL, 0x000fe200078e00ffULL, 0x000000274d277210ULL, 0x000fe20007f7e0ffULL,
0x00000010032a7824ULL, 0x000fe200078e00ffULL, 0x000000284d287210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff297224ULL, 0x000fe200000e06ffULL, 0xfffffff040407812ULL, 0x000fe200078ee22eULL,
0x000000ffff2f7224ULL, 0x000fe200018e06ffULL, 0x000000f02a357812ULL, 0x000fe200078ec0ffULL,
0x000000ffff2a7224ULL, 0x000fe200020e06ffULL, 0x00005e0032317a11ULL, 0x000fc400078440ffULL,
0x00005e00272e7a11ULL, 0x000fe400078640ffULL, 0x0000003533267210ULL, 0x000fe40007f1e0ffULL,
0x00005e0028307a11ULL, 0x000fe400078840ffULL, 0x00005f0032327a11ULL, 0x000fe400010f4429ULL,
0x00005f00272f7a11ULL, 0x000fe200018f442fULL, 0x000000ffff277224ULL, 0x000fe200000e0634ULL,
0x00005f00282a7a11ULL, 0x000fc400020f442aULL, 0x0000e00036297811ULL, 0x000fe400078e20ffULL,
0x0000003531287210ULL, 0x080fe40007f1e0ffULL, 0x000000352e2e7210ULL, 0x080fe20007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026297faeULL, 0x0003e2000b901c46ULL,
0x0000003530307210ULL, 0x000fc60007f7e0ffULL, 0x000000ffff2f7224ULL, 0x000fe400010e062fULL,
0x000000ffff317224ULL, 0x000fe200018e062aULL, 0x0000e000412a7811ULL, 0x000fe400078e20ffULL,
0x0000e00037267811ULL, 0x002fe200078e20ffULL, 0x000000ffff297224ULL, 0x000fe200000e0632ULL,
0x0000e00040277811ULL, 0x000fc800078e20ffULL, 0x0000000028267faeULL, 0x0003e8000b901c46ULL,
0x000000002e277faeULL, 0x0003e8000b901c46ULL, 0x00000000302a7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff367f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010608001f2e7f8cULL, 0x0006a4000c80043fULL, 0x0000000000267805ULL, 0x000fc40000015200ULL,
0x01060c001f287984ULL, 0x000f240000000800ULL, 0x8000000028ff7812ULL, 0x014fc4000780482fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff307224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x00000028262a7210ULL, 0x000fca0007f1e1ffULL,
0x0000000129297824ULL, 0x000fe200000e0e27ULL, 0x003d09002a00780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402a00780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff287819ULL, 0x000fc80000011429ULL,
0x0000002a28287211ULL, 0x000fca00078110ffULL, 0x000000ffff297224ULL, 0x000fca00000e0629ULL,
0x0000000228287819ULL, 0x000fc80000001229ULL, 0x000000280000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000130307810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01060c001f287984ULL, 0x000ea40000000800ULL,
0x8000000028ff7812ULL, 0x004fe4000780482fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001ff277819ULL, 0x000fe20000011603ULL, 0x0000001003267824ULL, 0x000fc600078e00ffULL,
0x0000000c27287812ULL, 0x000fe400078ec0ffULL, 0x0000007026277812ULL, 0x000fca00078ec0ffULL,
0x0000000127277824ULL, 0x000fe400078e0228ULL, 0xffffffffff287424ULL, 0x000fc600078e00ffULL,
0x01000000272e7984ULL, 0x000ea80000000800ULL, 0x01020000272f7984ULL, 0x0006620000000800ULL,
0x000000462e00720bULL, 0x004fe20003f1d000ULL, 0x0001a5227f007947ULL, 0x000fd8000b800000ULL,
0x0000000000297806ULL, 0x008fc800000e0100ULL, 0x0000ffff29337812ULL, 0x000fe2000780c0ffULL,
0x0000047000007945ULL, 0x000fe20003800000ULL, 0x00000001ff327424ULL, 0x000fe400078e00ffULL,
0x000000ffff4c7224ULL, 0x000fc400078e0046ULL, 0x0000001fff297424ULL, 0x000fe400078e00ffULL,
0xffffffffff2a7424ULL, 0x000fca00078e00ffULL, 0x0000041000008947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x000fe40003f05270ULL, 0x000000462e00720bULL, 0x000fe20003f54000ULL,
0x0001a4c27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000307806ULL, 0x000fc400010e0100ULL,
0x0000002e464c7209ULL, 0x000fe20007810000ULL, 0x0000035000017945ULL, 0x000fe20003800000ULL,
0x0000991030317816ULL, 0x000fc600000000ffULL, 0x0104004c27008388ULL, 0x0005e20000000800ULL,
0x000000ff3100720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x8000004c46317221ULL, 0x004fe20000010000ULL, 0x000000ff30ff7812ULL, 0x000fe2000780c0ffULL,
0x0000017000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b31317820ULL, 0x000fcc0000410000ULL,
0x0000003100317308ULL, 0x000ea80000000800ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff477819ULL, 0x000fe20000011603ULL, 0x0001a4227f007947ULL, 0x000fea000b800000ULL,
0x00001f4731477589ULL, 0x0044e400000e0000ULL, 0x000000473c3c7220ULL, 0x08cfe20000410000ULL,
0x000000473d3d7220ULL, 0x080fe20000410000ULL, 0x0000004738387220ULL, 0x080fe20000410000ULL,
0x0000004739397220ULL, 0x080fe20000410000ULL, 0x0000004718187220ULL, 0x080fe20000410000ULL,
0x0000004719197220ULL, 0x080fe20000410000ULL, 0x0000004714147220ULL, 0x080fe20000410000ULL,
0x0000004715157220ULL, 0x080fe20000410000ULL, 0x0000004704047220ULL, 0x080fe20000410000ULL,
0x0000004705057220ULL, 0x080fe20000410000ULL, 0x0000004708087220ULL, 0x080fe20000410000ULL,
0x0000004709097220ULL, 0x080fe20000410000ULL, 0x000000470c0c7220ULL, 0x080fe20000410000ULL,
0x000000470d0d7220ULL, 0x080fe20000410000ULL, 0x0000004710107220ULL, 0x080fe20000410000ULL,
0x0000004711117220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0030ff7812ULL, 0x000fe2000780c0ffULL, 0x0000003121217220ULL, 0x004fd80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000803477811ULL, 0x000fe200078ff0ffULL,
0x0001a2f27f007947ULL, 0x000fea000b800000ULL, 0x00001f4731477589ULL, 0x0004e400000e0000ULL,
0x000000473e3e7220ULL, 0x08cfe20000410000ULL, 0x000000473f3f7220ULL, 0x080fe20000410000ULL,
0x000000473a3a7220ULL, 0x080fe20000410000ULL, 0x000000473b3b7220ULL, 0x080fe20000410000ULL,
0x000000471a1a7220ULL, 0x080fe20000410000ULL, 0x000000471b1b7220ULL, 0x080fe20000410000ULL,
0x0000004716167220ULL, 0x080fe20000410000ULL, 0x0000004717177220ULL, 0x080fe20000410000ULL,
0x0000004706067220ULL, 0x080fe20000410000ULL, 0x0000004707077220ULL, 0x080fe20000410000ULL,
0x000000470a0a7220ULL, 0x080fe20000410000ULL, 0x000000470b0b7220ULL, 0x080fe20000410000ULL,
0x000000470e0e7220ULL, 0x080fe20000410000ULL, 0x000000470f0f7220ULL, 0x080fe20000410000ULL,
0x0000004712127220ULL, 0x080fe20000410000ULL, 0x0000004713137220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff33ff7812ULL, 0x000fda0007806030ULL,
0x8000004c2e2e0221ULL, 0x000fe20000010000ULL, 0x00007610ff320816ULL, 0x000fc60000000032ULL,
0x3fb8aa3b2e2e0820ULL, 0x000fc80000410000ULL, 0x0000002e002b0308ULL, 0x000ea40000000800ULL,
0x0000002b2f2f0220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000212f217221ULL, 0x002fc40000010000ULL, 0x00000000002e7805ULL, 0x000fca0000015200ULL,
0x0106ac00ff307984ULL, 0x000e640000000800ULL, 0x8000000030ff7812ULL, 0x002fe40007804844ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff347224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000307805ULL, 0x000fcc0000015200ULL, 0x000000302e337210ULL, 0x000fca0007f1e1ffULL,
0x0000000131317824ULL, 0x000fe200000e0e2fULL, 0x003d09003300780cULL, 0x000fc80003f06070ULL,
0x000000ff3100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403300780cULL, 0x000fc80003f06070ULL, 0x000000ff3100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff307819ULL, 0x000fc80000011431ULL,
0x0000003330307211ULL, 0x000fca00078110ffULL, 0x000000ffff317224ULL, 0x000fca00000e0631ULL,
0x0000000230307819ULL, 0x000fc80000001231ULL, 0x000000300000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000134347810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106ac00ff307984ULL, 0x000e640000000800ULL,
0x8000000030ff7812ULL, 0x002fe40007804844ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009910322e7816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff2e00720cULL, 0x000fda0003f45270ULL, 0x0000012000002947ULL, 0x000fea0003800000ULL,
0x0000002bff2c723eULL, 0x000fe400000010ffULL, 0x00000002ff2f7819ULL, 0x000fe40000011603ULL,
0x000054102c2e7816ULL, 0x000fe2000000002cULL, 0x00019ee27f007947ULL, 0x000fea000b800000ULL,
0x00001f2f2e2c7589ULL, 0x0002a400000e0000ULL, 0x000000082f2d7810ULL, 0x000fe20007ffe0ffULL,
0x00019f127f007947ULL, 0x000fea000b800000ULL, 0x00001f2d2e2d7589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000102f477810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff497224ULL, 0x000fe200078e002eULL, 0x0000285000487802ULL, 0x000fc40000000f00ULL,
0x0001aca000007944ULL, 0x00efea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000182f477810ULL, 0x004fe20007ffe0ffULL, 0x000000ffff497224ULL, 0x000fe200078e002eULL,
0x000028a000487802ULL, 0x000fc40000000f00ULL, 0x0001ac5000007944ULL, 0x00afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000803507812ULL, 0x000fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000004ff2e7819ULL, 0x00afc40000011603ULL,
0x0000000750507812ULL, 0x100fe400078ef803ULL, 0x0000000202327811ULL, 0x040fe200078e10ffULL,
0x0000000402527824ULL, 0x000fe200078e022eULL, 0x00000007034e7812ULL, 0x000fe200078ec0ffULL,
0x0000001050307824ULL, 0x040fe200078e00ffULL, 0x0000001050337812ULL, 0x040fe200078efcffULL,
0x00000001502f7824ULL, 0x000fe200078e0252ULL, 0x000000084e4e7812ULL, 0x000fe200078ef803ULL,
0x000000012e517824ULL, 0x000fe200078e0232ULL, 0x00000032334f7210ULL, 0x000fe20007ffe02eULL,
0x0000001050317824ULL, 0x000fe200078e00ffULL, 0xfffffff0302f7812ULL, 0x000fe200078ee22fULL,
0x0000000150307824ULL, 0x000fc400078e0251ULL, 0x0000000152557824ULL, 0x000fe200078e0233ULL,
0x0000c0002f2f7811ULL, 0x000fe200078e20ffULL, 0x000000012e547824ULL, 0x000fe200078e024eULL,
0xfffffff031307812ULL, 0x000fe200078ee230ULL, 0x0000001033317824ULL, 0x040fe400078e00ffULL,
0x0000001033347824ULL, 0x000fe200078e00ffULL, 0x0000000254327810ULL, 0x000fe20007ffe0ffULL,
0x000000084e337824ULL, 0x000fe200078e00ffULL, 0xfffffff031557812ULL, 0x000fe200078ee255ULL,
0x000000002f48783bULL, 0x000e620000004200ULL, 0xfffffff0344f7812ULL, 0x000fc400078ee24fULL,
0x0000c00055317811ULL, 0x000fe400078e20ffULL, 0x0000c00030307811ULL, 0x000fe400078e20ffULL,
0xfffffff833327812ULL, 0x000fe200078ee232ULL, 0x000000003144783bULL, 0x004ea20000004200ULL,
0x0000c0004f337811ULL, 0x000fc600078e20ffULL, 0x000000003058783bULL, 0x000ee80000004200ULL,
0x000000003340783bULL, 0x000f220000004200ULL, 0x00000010ff347819ULL, 0x002fe40000011648ULL,
0x000000ff49537812ULL, 0x000fe400078ec0ffULL, 0x000000ff34347812ULL, 0x000fe400078ec0ffULL,
0x0000ffff4a727812ULL, 0x000fc400078ec0ffULL, 0x00000010ff827819ULL, 0x104fe40000011645ULL,
0x000000ff45707812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6f7819ULL, 0x000fe40000011645ULL,
0x0000ffff45777812ULL, 0x000fe400078ec0ffULL, 0x00000010ff627819ULL, 0x008fe40000011659ULL,
0x000000ff59647812ULL, 0x000fc400078ec0ffULL, 0x00000018ff637819ULL, 0x000fe40000011659ULL,
0x0000ffff59787812ULL, 0x000fe400078ec0ffULL, 0x00000010ff6a7819ULL, 0x100fe4000001165bULL,
0x000000ff5b697812ULL, 0x040fe400078ec0ffULL, 0x00000018ff687819ULL, 0x000fe4000001165bULL,
0x0000ffff5b7b7812ULL, 0x000fc400078ec0ffULL, 0x00000053ff45723eULL, 0x000fe400020006ffULL,
0x00000010ff5d7819ULL, 0x100fe40000011649ULL, 0x00000018ff897819ULL, 0x000fe40000011649ULL,
0x0000ffff49867812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5b7819ULL, 0x010fe40000011640ULL,
0x000000ff40907812ULL, 0x000fc400078ec0ffULL, 0x00000018ff8f7819ULL, 0x000fe40000011640ULL,
0x0000ffff40597812ULL, 0x000fe400078ec0ffULL, 0x00000034ff34723eULL, 0x000fe400020006ffULL,
0x00000010ff817819ULL, 0x100fe4000001164aULL, 0x000000ff4a8a7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff497819ULL, 0x000fc4000001164aULL, 0x00000008ff407819ULL, 0x000fe40000011672ULL,
0x00000010ff807819ULL, 0x100fe4000001164bULL, 0x000000ff4b8b7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff4a7819ULL, 0x000fe4000001164bULL, 0x0000ffff4b737812ULL, 0x000fe400078ec0ffULL,
0x0000ffff58757812ULL, 0x000fc400078ec0ffULL, 0x00000010ff4b7819ULL, 0x100fe40000011646ULL,
0x000000ff468c7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff717819ULL, 0x000fe40000011646ULL,
0x0000ffff465f7812ULL, 0x000fe200078ec0ffULL, 0x20000045ff467230ULL, 0x000fe20000004100ULL,
0x00000040ff40723eULL, 0x000fe200020006ffULL, 0x20000034ff457230ULL, 0x000fe20000004100ULL,
0x00000008ff347819ULL, 0x000fc40000011675ULL, 0x00000010ff5e7819ULL, 0x000fe20000011658ULL,
0x20000040ff847230ULL, 0x000fe20000004100ULL, 0x00000034ff34723eULL, 0x000fe400020006ffULL,
0x00000008ff407819ULL, 0x000fe40000011678ULL, 0x000000ff58617812ULL, 0x000fe200078ec0ffULL,
0x20000034ff7c7230ULL, 0x000fe20000004100ULL, 0x00000018ff607819ULL, 0x000fe40000011658ULL,
0x00000010ff667819ULL, 0x000fc4000001165aULL, 0x000000ff5a677812ULL, 0x040fe400078ec0ffULL,
0x00000018ff657819ULL, 0x000fe4000001165aULL, 0x0000ffff5a7a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5a7819ULL, 0x100fe40000011641ULL, 0x000000ff41927812ULL, 0x000fe400078ec0ffULL,
0x00000018ff917819ULL, 0x000fc40000011641ULL, 0x0000ffff41587812ULL, 0x000fe400078ec0ffULL,
0x00000040ff40723eULL, 0x000fe400020006ffULL, 0x00000008ff417819ULL, 0x000fe40000011673ULL,
0x00000008ff347819ULL, 0x000fe2000001167bULL, 0x20000040ff7d7230ULL, 0x000fe20000004100ULL,
0x00000041ff41723eULL, 0x000fe200020006ffULL, 0x000000084e407824ULL, 0x000fe200078e00ffULL,
0x00000034ff34723eULL, 0x000fc400020006ffULL, 0x000000ff48357812ULL, 0x000fe200078ec0ffULL,
0x20000041ff877230ULL, 0x000fe20000004100ULL, 0x00000008ff417819ULL, 0x000fe2000001167aULL,
0x20000034ff787230ULL, 0x000fe20000004100ULL, 0xfffffff840347812ULL, 0x000fe400078ee254ULL,
0x00000041ff41723eULL, 0x000fe400020006ffULL, 0x0000a00034407811ULL, 0x000fe400078e20ffULL,
0x00000010ff747819ULL, 0x000fe20000011644ULL, 0x20000041ff757230ULL, 0x000fe20000004100ULL,
0x000000ff446e7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff6b7819ULL, 0x000fe40000011644ULL,
0x0000ffff44837812ULL, 0x000fe400078ec0ffULL, 0x00000035ff44723eULL, 0x000fe400020006ffULL,
0x00000010ff577819ULL, 0x100fe40000011642ULL, 0x000000ff42947812ULL, 0x000fe200078ec0ffULL,
0x20000044ff447230ULL, 0x000fe20000004100ULL, 0x00000018ff937819ULL, 0x000fc40000011642ULL,
0x0000ffff42567812ULL, 0x000fe400078ec0ffULL, 0x00000010ff537819ULL, 0x100fe40000011643ULL,
0x000000ff43967812ULL, 0x040fe400078ec0ffULL, 0x00000018ff957819ULL, 0x000fe40000011643ULL,
0x0000ffff43357812ULL, 0x000fe400078ec0ffULL, 0x000000004040783bULL, 0x000e620000000200ULL,
0x000000ff5d5d7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff887819ULL, 0x000fe40000011648ULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x0000ffff48857812ULL, 0x000fe400078ec0ffULL,
0x00000010ff487819ULL, 0x100fe40000011647ULL, 0x000000ff478e7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff8d7819ULL, 0x000fc40000011647ULL, 0x0000ffff475c7812ULL, 0x000fe200078ec0ffULL,
0x2000005dff477230ULL, 0x000fe20000004100ULL, 0x000000ff80807812ULL, 0x000fe400078ec0ffULL,
0x00000010ff447819ULL, 0x000fe40000011644ULL, 0x00000010ff457819ULL, 0x000fe40000011645ULL,
0x00000010ff467819ULL, 0x000fe40000011646ULL, 0x00000010ff477819ULL, 0x000fc40000011647ULL,
0x00000049ff49723eULL, 0x000fe400020006ffULL, 0x0000008bff8b723eULL, 0x000fe400020006ffULL,
0x00000080ff80723eULL, 0x000fe200020006ffULL, 0x20000049ff767230ULL, 0x000fe20000004100ULL,
0x0000105445447816ULL, 0x000fe20000000044ULL, 0x2000008bff8b7230ULL, 0x000fe20000004100ULL,
0x000000ff5e5e7812ULL, 0x000fe200078ec0ffULL, 0x20000080ff807230ULL, 0x000fe20000004100ULL,
0x000000ff62627812ULL, 0x000fc400078ec0ffULL, 0x0000105447457816ULL, 0x000fe20000000046ULL,
0x0000002c4040a231ULL, 0x082fe200003400ffULL, 0x0000004aff4a723eULL, 0x000fe200020006ffULL,
0x0000002c4242a231ULL, 0x000fe200003400ffULL, 0x00000061ff49723eULL, 0x000fe200020006ffULL,
0x0000002d4141a231ULL, 0x080fe200003400ffULL, 0x0000005eff5e723eULL, 0x000fe200020006ffULL,
0x0000002d4343a231ULL, 0x000fe200003400ffULL, 0x00000062ff62723eULL, 0x000fe200020006ffULL,
0x2000004aff797230ULL, 0x000fe20000004100ULL, 0x00000008ff777819ULL, 0x000fe20000011677ULL,
0x20000049ff497230ULL, 0x000fe20000004100ULL, 0x00000064ff64723eULL, 0x000fe200020006ffULL,
0x2000005eff7f7230ULL, 0x000fe20000004100ULL, 0x000000444044723cULL, 0x000b62000004183cULL,
0x00000010ff8b7819ULL, 0x000fe2000001168bULL, 0x20000062ff7e7230ULL, 0x000fe20000004100ULL,
0x00000010ff807819ULL, 0x000fe20000011680ULL, 0x20000064ff4a7230ULL, 0x000fe20000004100ULL,
0x00000010ff497819ULL, 0x000fc40000011649ULL, 0x00000077ff3c723eULL, 0x020fe400020006ffULL,
0x00001054808b7816ULL, 0x000fe4000000008bULL, 0x00000010ff7f7819ULL, 0x000fe2000001167fULL,
0x2000003cff807230ULL, 0x000fe20000004100ULL, 0x00000010ff3c7819ULL, 0x000fe4000001167eULL,
0x0000a000323d7811ULL, 0x000fe400078e20ffULL, 0x00000010ff4a7819ULL, 0x000fc4000001164aULL,
0x00000008ff857819ULL, 0x000fe40000011685ULL, 0x00000008ff867819ULL, 0x000fe40000011686ULL,
0x000010547f7e7816ULL, 0x000fe40000000049ULL, 0x000010543c7f7816ULL, 0x000fe4000000004aULL,
0x000000003d3c783bULL, 0x000e620000000200ULL, 0x000000ff81817812ULL, 0x000fe400078ec0ffULL,
0x00000088ff88723eULL, 0x000fc400020006ffULL, 0x00000089ff89723eULL, 0x000fe200020006ffULL,
0x0000007e4004723cULL, 0x000fe20000041804ULL, 0x00000085ff85723eULL, 0x000fe200020006ffULL,
0x20000088ff887230ULL, 0x000fe20000004100ULL, 0x00000086ff86723eULL, 0x000fe200020006ffULL,
0x20000089ff897230ULL, 0x000fe20000004100ULL, 0x0000008aff8a723eULL, 0x000fe200020006ffULL,
0x20000085ff857230ULL, 0x000fe20000004100ULL, 0x00000081ff81723eULL, 0x000fe200020006ffULL,
0x20000086ff867230ULL, 0x000fe20000004100ULL, 0x00000063ff63723eULL, 0x000fe200020006ffULL,
0x2000008aff8a7230ULL, 0x000fe20000004100ULL, 0x000000ff66667812ULL, 0x000fe200078ec0ffULL,
0x20000081ff817230ULL, 0x000fe20000004100ULL, 0x000000ff6a6a7812ULL, 0x000fe200078ec0ffULL,
0x20000063ff6d7230ULL, 0x000fe20000004100ULL, 0x00000010ff767819ULL, 0x000fc40000011676ULL,
0x00000010ff797819ULL, 0x000fe40000011679ULL, 0x00000010ff847819ULL, 0x000fe40000011684ULL,
0x00000010ff777819ULL, 0x000fe40000011687ULL, 0x000000ff4b4b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff887819ULL, 0x000fe40000011688ULL, 0x00000010ff897819ULL, 0x000fc40000011689ULL,
0x00000010ff857819ULL, 0x000fe40000011685ULL, 0x00000010ff867819ULL, 0x000fe40000011686ULL,
0x00000060ff60723eULL, 0x000fe200020006ffULL, 0x0000002c3c3ca231ULL, 0x082fe200003400ffULL,
0x00000067ff67723eULL, 0x000fe200020006ffULL, 0x0000002c3e3ea231ULL, 0x000fe200003400ffULL,
0x00000069ff69723eULL, 0x000fe200020006ffULL, 0x20000060ff6c7230ULL, 0x000fe20000004100ULL,
0x00000066ff66723eULL, 0x000fe200020006ffULL, 0x0000002d3d3da231ULL, 0x080fe200003400ffULL,
0x0000006aff6a723eULL, 0x000fe200020006ffULL, 0x20000069ff697230ULL, 0x000fe20000004100ULL,
0x00000065ff65723eULL, 0x000fe200020006ffULL, 0x20000066ff7b7230ULL, 0x000fe20000004100ULL,
0x00000068ff63723eULL, 0x000fe200020006ffULL, 0x20000067ff687230ULL, 0x000fe20000004100ULL,
0x0000105476767816ULL, 0x000fe20000000084ULL, 0x2000006aff7a7230ULL, 0x000fe20000004100ULL,
0x0000105479777816ULL, 0x000fe20000000077ULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x00000010ff8a7819ULL, 0x000fe2000001168aULL, 0x20000063ff637230ULL, 0x000fe20000004100ULL,
0x00000010ff817819ULL, 0x000fe20000011681ULL, 0x0000002d3f3fa231ULL, 0x000fe200003400ffULL,
0x0000004bff4b723eULL, 0x000fc400020006ffULL, 0x0000105488887816ULL, 0x000fe40000000085ULL,
0x0000105489897816ULL, 0x000fe40000000086ULL, 0x000000ff48487812ULL, 0x000fe400078ec0ffULL,
0x00001054818a7816ULL, 0x000fe2000000008aULL, 0x2000004bff817230ULL, 0x000fe20000004100ULL,
0x00000048ff79723eULL, 0x000fe200020006ffULL, 0x000000884038723cULL, 0x000f620000041838ULL,
0x000000ff74747812ULL, 0x000fc400078ec0ffULL, 0x00000008ff837819ULL, 0x000fe20000011683ULL,
0x20000079ff797230ULL, 0x000fe20000004100ULL, 0x000000ff82827812ULL, 0x000fe400078ec0ffULL,
0x00000010ff6c7819ULL, 0x000fe2000001166cULL, 0x000000764048723cULL, 0x000be20000041814ULL,
0x00000010ff7c7819ULL, 0x000fe4000001167cULL, 0x00000010ff687819ULL, 0x000fe40000011668ULL,
0x00000010ff697819ULL, 0x000fc40000011669ULL, 0x00000010ff147819ULL, 0x020fe2000001166dULL,
0x0000008a4018723cULL, 0x000f620000041818ULL, 0x00000010ff6d7819ULL, 0x000fe4000001167dULL,
0x00000010ff7b7819ULL, 0x000fe4000001167bULL, 0x00000010ff7a7819ULL, 0x000fe4000001167aULL,
0x00000010ff657819ULL, 0x000fe40000011665ULL, 0x00000010ff757819ULL, 0x000fc40000011675ULL,
0x00000010ff637819ULL, 0x000fe40000011663ULL, 0x00000010ff157819ULL, 0x000fe40000011678ULL,
0x0000006eff6e723eULL, 0x000fe400020006ffULL, 0x0000006bff6b723eULL, 0x000fe400020006ffULL,
0x00000070ff73723eULL, 0x000fe200020006ffULL, 0x2000006eff727230ULL, 0x000fe20000004100ULL,
0x0000006fff6f723eULL, 0x000fe200020006ffULL, 0x2000006bff707230ULL, 0x000fe20000004100ULL,
0x00000074ff74723eULL, 0x000fe200020006ffULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x00000083ff83723eULL, 0x000fc400020006ffULL, 0x00000082ff82723eULL, 0x000fe200020006ffULL,
0x20000074ff747230ULL, 0x000fe20000004100ULL, 0x000010546c6c7816ULL, 0x000fe2000000007cULL,
0x20000083ff837230ULL, 0x000fe20000004100ULL, 0x00001054146d7816ULL, 0x000fe2000000006dULL,
0x20000082ff827230ULL, 0x000fe20000004100ULL, 0x000010547b687816ULL, 0x000fe40000000068ULL,
0x000010547a697816ULL, 0x000fe40000000069ULL, 0x0000105465147816ULL, 0x000fe20000000075ULL,
0x0000006c4008723cULL, 0x000f620000041808ULL, 0x0000105463157816ULL, 0x000fc40000000015ULL,
0x00000071ff6a723eULL, 0x000fe200020006ffULL, 0x2000006fff717230ULL, 0x000fe20000004100ULL,
0x000000ff57577812ULL, 0x000fe400078ec0ffULL, 0x00000094ff61723eULL, 0x000fe200020006ffULL,
0x00000068400c723cULL, 0x000f62000004180cULL, 0x00000008ff5f7819ULL, 0x000fe2000001165fULL,
0x2000006aff6a7230ULL, 0x000fe20000004100ULL, 0x00000008ff5c7819ULL, 0x000fe2000001165cULL,
0x20000061ff617230ULL, 0x000fe20000004100ULL, 0x000000ff5b5b7812ULL, 0x000fc400078ec0ffULL,
0x000000ff5a5a7812ULL, 0x000fe200078ec0ffULL, 0x000000144040723cULL, 0x000b620000041810ULL,
0x00000008ff597819ULL, 0x000fe40000011659ULL, 0x00000008ff587819ULL, 0x000fe40000011658ULL,
0x00000057ff57723eULL, 0x000fe400020006ffULL, 0x000000ff53537812ULL, 0x000fe400078ec0ffULL,
0x00000008ff567819ULL, 0x000fe20000011656ULL, 0x20000057ff577230ULL, 0x000fe20000004100ULL,
0x00000008ff357819ULL, 0x000fc40000011635ULL, 0x00000010ff727819ULL, 0x000fe40000011672ULL,
0x00000010ff117819ULL, 0x020fe40000011673ULL, 0x00000010ff747819ULL, 0x000fe40000011674ULL,
0x00000010ff827819ULL, 0x000fe40000011682ULL, 0x00000010ff707819ULL, 0x000fe40000011670ULL,
0x00000010ff717819ULL, 0x000fc40000011671ULL, 0x00000010ff837819ULL, 0x000fe40000011683ULL,
0x00000010ff157819ULL, 0x000fe40000011680ULL, 0x0000008cff6e723eULL, 0x000fe400020006ffULL,
0x0000008eff8e723eULL, 0x000fe400020006ffULL, 0x0000008dff6b723eULL, 0x000fe200020006ffULL,
0x2000006eff6e7230ULL, 0x000fe20000004100ULL, 0x00000090ff66723eULL, 0x000fe200020006ffULL,
0x2000008eff6f7230ULL, 0x000fe20000004100ULL, 0x00000092ff67723eULL, 0x000fe200020006ffULL,
0x2000006bff6b7230ULL, 0x000fe20000004100ULL, 0x0000008fff62723eULL, 0x000fe200020006ffULL,
0x20000066ff667230ULL, 0x000fe20000004100ULL, 0x00000091ff64723eULL, 0x000fe200020006ffULL,
0x20000067ff677230ULL, 0x000fe20000004100ULL, 0x00000096ff60723eULL, 0x000fe200020006ffULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x0000005fff5f723eULL, 0x000fe200020006ffULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x0000005cff5c723eULL, 0x000fe200020006ffULL,
0x20000060ff607230ULL, 0x000fe20000004100ULL, 0x0000005bff5b723eULL, 0x000fe200020006ffULL,
0x2000005fff5f7230ULL, 0x000fe20000004100ULL, 0x0000005aff5a723eULL, 0x000fe200020006ffULL,
0x2000005cff5c7230ULL, 0x000fe20000004100ULL, 0x00000059ff59723eULL, 0x000fe200020006ffULL,
0x2000005bff5b7230ULL, 0x000fe20000004100ULL, 0x00000058ff58723eULL, 0x000fe200020006ffULL,
0x2000005aff5a7230ULL, 0x000fe20000004100ULL, 0x00000053ff53723eULL, 0x000fe200020006ffULL,
0x20000059ff597230ULL, 0x000fe20000004100ULL, 0x00000093ff5e723eULL, 0x000fe200020006ffULL,
0x20000058ff587230ULL, 0x000fe20000004100ULL, 0x00000095ff5d723eULL, 0x000fe200020006ffULL,
0x20000053ff537230ULL, 0x000fe20000004100ULL, 0x00000056ff56723eULL, 0x000fe200020006ffULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x00000035ff35723eULL, 0x000fe200020006ffULL,
0x2000005dff5d7230ULL, 0x000fe20000004100ULL, 0x0000105474107816ULL, 0x000fe20000000072ULL,
0x20000056ff567230ULL, 0x000fe20000004100ULL, 0x0000105482117816ULL, 0x000fe20000000011ULL,
0x20000035ff357230ULL, 0x000fe20000004100ULL, 0x0000105470147816ULL, 0x000fc40000000083ULL,
0x0000105471157816ULL, 0x000fe40000000015ULL, 0x00000010ff617819ULL, 0x000fe20000011661ULL,
0x000000103c10723cULL, 0x040f620000041844ULL, 0x00000010ff577819ULL, 0x000fe40000011657ULL,
0x00000010ff6e7819ULL, 0x000fe4000001166eULL, 0x00000010ff6f7819ULL, 0x000fe4000001166fULL,
0x00000010ff817819ULL, 0x000fe20000011681ULL, 0x000000143c14723cULL, 0x000b620000041838ULL,
0x00000010ff797819ULL, 0x000fc40000011679ULL, 0x00000010ff6a7819ULL, 0x000fe4000001166aULL,
0x00000010ff6b7819ULL, 0x000fe4000001166bULL, 0x00000010ff5f7819ULL, 0x000fe4000001165fULL,
0x00000010ff397819ULL, 0x020fe4000001165cULL, 0x00000010ff667819ULL, 0x000fe40000011666ULL,
0x00000010ff677819ULL, 0x000fc40000011667ULL, 0x00000010ff5b7819ULL, 0x000fe4000001165bULL,
0x00000010ff5a7819ULL, 0x000fe4000001165aULL, 0x00000010ff627819ULL, 0x000fe40000011662ULL,
0x00000010ff597819ULL, 0x000fe40000011659ULL, 0x00000010ff637819ULL, 0x000fe40000011664ULL,
0x00000010ff587819ULL, 0x000fc40000011658ULL, 0x00000010ff457819ULL, 0x000fe40000011660ULL,
0x00000010ff537819ULL, 0x000fe40000011653ULL, 0x0000105457447816ULL, 0x000fe40000000061ULL,
0x00000010ff5e7819ULL, 0x000fe4000001165eULL, 0x00000010ff567819ULL, 0x000fe40000011656ULL,
0x00000010ff577819ULL, 0x000fc4000001165dULL, 0x00000010ff357819ULL, 0x000fe40000011635ULL,
0x00001054816e7816ULL, 0x000fe4000000006eULL, 0x00001054796f7816ULL, 0x000fe4000000006fULL,
0x000010546a387816ULL, 0x000fe4000000005fULL, 0x000010546b397816ULL, 0x000fe40000000039ULL,
0x000010545b667816ULL, 0x000fe20000000066ULL, 0x0000006e3c18723cULL, 0x000b620000041818ULL,
0x000010545a677816ULL, 0x000fc40000000067ULL, 0x0000105462627816ULL, 0x000fe40000000059ULL,
0x0000105463637816ULL, 0x000fe40000000058ULL, 0x0000105453457816ULL, 0x000fe20000000045ULL,
0x000000383c38723cULL, 0x000b620000041848ULL, 0x000010545e567816ULL, 0x000fe40000000056ULL,
0x0000105457577816ULL, 0x000fca0000000035ULL, 0x000000663c04723cULL, 0x040b700000041804ULL,
0x000000623c08723cULL, 0x040b700000041808ULL, 0x000000443c0c723cULL, 0x040b70000004180cULL,
0x000000563c3c723cULL, 0x000b620000041840ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff447f8cULL, 0x020e62000c80043fULL, 0x000000ffff467224ULL, 0x000fce00078e00ffULL,
0x0000000000407805ULL, 0x000fc40000015200ULL, 0x0106bc00ff357984ULL, 0x000ea40000000800ULL,
0x8000000035ff7812ULL, 0x006fc40007804845ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000427805ULL, 0x000fcc0000015200ULL, 0x0000004240427210ULL, 0x000fca0007f1e1ffULL,
0x0000000143437824ULL, 0x000fe200000e0e41ULL, 0x003d09004200780cULL, 0x000fc80003f06070ULL,
0x000000ff4300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404200780cULL, 0x000fc80003f06070ULL, 0x000000ff4300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff357819ULL, 0x000fc80000011443ULL,
0x0000004235357211ULL, 0x000fca00078110ffULL, 0x000000ffff427224ULL, 0x000fca00000e0643ULL,
0x0000000235357819ULL, 0x000fc80000001242ULL, 0x000000350000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000146467810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106bc00ff357984ULL, 0x000e640000000800ULL,
0x8000000035ff7812ULL, 0x002fe40007804845ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000004023357811ULL, 0x000fe200078e40ffULL, 0x0000045000009947ULL, 0x000fea0003800000ULL,
0x000000011f417824ULL, 0x000fe200078e022eULL, 0x0000004000427811ULL, 0x000fe400078e38ffULL,
0x000000022e477810ULL, 0x040fe20007ffe0ffULL, 0x0000000141407824ULL, 0x040fe200078e0203ULL,
0x000000042e567810ULL, 0x000fe20007ffe0ffULL, 0x00000010414b7824ULL, 0x040fe200078e00ffULL,
0x000000f0264a7812ULL, 0x000fe200078ec0ffULL, 0x0000000141417824ULL, 0x000fe200078e0242ULL,
0x000000062e587810ULL, 0x000fe20007ffe0ffULL, 0x000000011f437824ULL, 0x000fe200078e0247ULL,
0xfffffff04b4b7812ULL, 0x000fe200078ee240ULL, 0x000000011f487824ULL, 0x000fe200078e0256ULL,
0x000000351c407217ULL, 0x000fe20007800000ULL, 0x0000000143447824ULL, 0x000fe200078e0203ULL,
0x000000414d457210ULL, 0x000fe20007f1e0ffULL, 0x0000001043537824ULL, 0x000fe200078e00ffULL,
0x0000c0004b4b7811ULL, 0x000fe200078e20ffULL, 0x0000000140407824ULL, 0x000fc400078e0a35ULL,
0x0000000143417824ULL, 0x000fe200078e0242ULL, 0xfffffff053537812ULL, 0x000fe200078ee244ULL,
0x0000000148497824ULL, 0x040fe200078e0203ULL, 0x000000401f407217ULL, 0x000fe20007800000ULL,
0x0000001048577824ULL, 0x000fe200078e00ffULL, 0x000000414d417210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff467224ULL, 0x000fe200000e06ffULL, 0x00005e0045447a11ULL, 0x000fe200078040ffULL,
0x0000000140437824ULL, 0x000fe200078e0a1fULL, 0xfffffff057577812ULL, 0x000fe200078ee249ULL,
0x0000000148407824ULL, 0x000fe200078e0242ULL, 0x00005f0045457a11ULL, 0x000fe200000f4446ULL,
0x000000ffff497224ULL, 0x000fe200018e06ffULL, 0x00005e0041467a11ULL, 0x000fe200078640ffULL,
0x000000011f597824ULL, 0x000fe200078e0258ULL, 0x000000432e00720cULL, 0x000fc40003f86070ULL,
0x000000404d487210ULL, 0x000fe20007fbe0ffULL, 0x0000000159427824ULL, 0x000fe200078e0242ULL,
0x00005f0041497a11ULL, 0x000fe400018f4449ULL, 0x0000004a44407210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff447224ULL, 0x000fe200028e06ffULL, 0x000000434700720cULL, 0x080fe40003f06070ULL,
0x00005e0048477a11ULL, 0x000fe200078a40ffULL, 0x000000ffff417224ULL, 0x000fe200018e0645ULL,
0x000000435600720cULL, 0x000fc40003f66070ULL, 0x00005f0048487a11ULL, 0x000fe400028f4444ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000404b7faeULL, 0x0003e2000e101c46ULL,
0x000000424d457210ULL, 0x000fe40007f9e0ffULL, 0x0000004a47427210ULL, 0x080fe40007fde0ffULL,
0x0000c00053537811ULL, 0x000fe400078e20ffULL, 0x0000c00057577811ULL, 0x000fe400078e20ffULL,
0x0000004a46407210ULL, 0x002fe20007fbe0ffULL, 0x000000ffff467224ULL, 0x000fe200020e06ffULL,
0x00005e0045447a11ULL, 0x000fe200078840ffULL, 0x00000001594b7824ULL, 0x000fc400078e0203ULL,
0x0000001059597824ULL, 0x000fe200078e00ffULL, 0x00005f0045457a11ULL, 0x000fe200020f4446ULL,
0x000000ffff417224ULL, 0x000fe200028e0649ULL, 0x000000435800720cULL, 0x000fe20003fa6070ULL,
0x000000ffff437224ULL, 0x000fe200030e0648ULL, 0x0000004a44447210ULL, 0x000fe40007f9e0ffULL,
0xfffffff0594b7812ULL, 0x000fe200078ee24bULL, 0x0000000040537faeULL, 0x0003e4000c101c46ULL,
0x000000ffff457224ULL, 0x000fe200020e0645ULL, 0x0000c0004b4b7811ULL, 0x000fe200078e20ffULL,
0x0000000042577faeULL, 0x0003e8000d901c46ULL, 0x00000000444b7faeULL, 0x0003e2000e901c46ULL,
0x0000039000007947ULL, 0x000fea0003800000ULL, 0x0000004000467811ULL, 0x000fe200078e38ffULL,
0x000000011f457824ULL, 0x000fe200078e022eULL, 0x000000f026587812ULL, 0x000fc600078ec0ffULL,
0x0000000145417824ULL, 0x140fe200078e0246ULL, 0x0000000245407810ULL, 0x040fe20007ffe0ffULL,
0x0000000145427824ULL, 0x140fe200078e0203ULL, 0x0000000445437810ULL, 0x040fe20007ffe0ffULL,
0x0000001045597824ULL, 0x040fe200078e00ffULL, 0x0000000645457810ULL, 0x000fe20007ffe0ffULL,
0x0000001040487824ULL, 0x040fe200078e00ffULL, 0x000000414d497210ULL, 0x000fe20007f1e0ffULL,
0x0000000140417824ULL, 0x040fe200078e0246ULL, 0xfffffff059597812ULL, 0x000fe200078ee242ULL,
0x0000000140427824ULL, 0x000fc400078e0203ULL, 0x0000000145477824ULL, 0x100fe200078e0203ULL,
0x0000c00059597811ULL, 0x000fe200078e20ffULL, 0x0000001045537824ULL, 0x000fe400078e00ffULL,
0x000000ffff4a7224ULL, 0x000fe200000e06ffULL, 0x00005e0049567a11ULL, 0x000fe200078040ffULL,
0x0000000143407824ULL, 0x100fe400078e0246ULL, 0x0000000145467824ULL, 0x000fe200078e0246ULL,
0x00005f0049577a11ULL, 0x000fe200000f444aULL, 0x0000000143447824ULL, 0x000fe200078e0203ULL,
0x000000404d4a7210ULL, 0x000fe20007f7e0ffULL, 0x00000010434b7824ULL, 0x000fe200078e00ffULL,
0xfffffff048437812ULL, 0x000fc400078ee242ULL, 0xfffffff053487812ULL, 0x000fe400078ee247ULL,
0x000000414d537210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff417224ULL, 0x000fe200018e06ffULL,
0x000000464d497210ULL, 0x000fe40007f9e0ffULL, 0xfffffff04b457812ULL, 0x000fe200078ee244ULL,
0x000000ffff477224ULL, 0x000fe200000e06ffULL, 0x00005e00534b7a11ULL, 0x000fe200078040ffULL,
0x000000ffff407224ULL, 0x000fe200020e06ffULL, 0x0000005856467210ULL, 0x000fc40007fbe0ffULL,
0x00005e0049447a11ULL, 0x000fe400078840ffULL, 0x00005e004a427a11ULL, 0x040fe400078640ffULL,
0x00005f0053537a11ULL, 0x000fe200000f4447ULL, 0x000000ffff477224ULL, 0x000fe200028e0657ULL,
0x00005f0049497a11ULL, 0x000fe400020f4440ULL, 0x00005f004a4a7a11ULL, 0x000fe400018f4441ULL,
0x000000584b407210ULL, 0x080fe20007f1e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000046597faeULL, 0x0003e2000b901c46ULL, 0x0000005842427210ULL, 0x000fc40007f7e0ffULL,
0x0000005844447210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff417224ULL, 0x000fe200000e0653ULL,
0x0000c00048487811ULL, 0x000fe400078e20ffULL, 0x0000c00043467811ULL, 0x002fe200078e20ffULL,
0x000000ffff437224ULL, 0x000fe200018e064aULL, 0x0000c00045477811ULL, 0x000fe200078e20ffULL,
0x000000ffff457224ULL, 0x000fe400020e0649ULL, 0x0000000040467faeULL, 0x0003e8000b901c46ULL,
0x0000000042477faeULL, 0x0003e8000b901c46ULL, 0x0000000044487faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff447f8cULL, 0x000e64000c80043fULL, 0x000000ffff447224ULL, 0x002fc400078e0045ULL,
0x0000000000407805ULL, 0x000fca0000015200ULL, 0x0106b400ff427984ULL, 0x000e640000000800ULL,
0x8000000042ff7812ULL, 0x002fc40007804837ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff467224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000427805ULL, 0x000fcc0000015200ULL,
0x0000004240457210ULL, 0x000fca0007f1e1ffULL, 0x0000000143437824ULL, 0x000fe200000e0e41ULL,
0x003d09004500780cULL, 0x000fc80003f06070ULL, 0x000000ff4300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404500780cULL, 0x000fc80003f06070ULL,
0x000000ff4300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff427819ULL, 0x000fc80000011443ULL, 0x0000004542427211ULL, 0x000fca00078110ffULL,
0x000000ffff437224ULL, 0x000fca00000e0643ULL, 0x0000000242427819ULL, 0x000fc80000001243ULL,
0x000000420000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000146467810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106b400ff427984ULL, 0x000e640000000800ULL, 0x8000000042ff7812ULL, 0x002fe40007804837ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000014000007945ULL, 0x000fe20003800000ULL,
0x0000012000002947ULL, 0x000fea0003800000ULL, 0x0000002bff2c723eULL, 0x000fe400000010ffULL,
0x00000002ff377819ULL, 0x000fe40000011603ULL, 0x000054102c367816ULL, 0x000fe2000000002cULL,
0x000178f27f007947ULL, 0x000fea000b800000ULL, 0x00001f37362c7589ULL, 0x0002a400000e0000ULL,
0x00000008372d7810ULL, 0x000fe20007ffe0ffULL, 0x000179227f007947ULL, 0x000fea000b800000ULL,
0x00001f2d362d7589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001037477810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff497224ULL, 0x000fe200078e0036ULL,
0x00004f0000487802ULL, 0x000fc40000000f00ULL, 0x000185f000007944ULL, 0x00efea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001837477810ULL, 0x004fe20007ffe0ffULL,
0x000000ffff497224ULL, 0x000fe200078e0036ULL, 0x00004f5000487802ULL, 0x000fc40000000f00ULL,
0x000185a000007944ULL, 0x00afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000150517824ULL, 0x040fe200078e0251ULL, 0x0000e00055437811ULL, 0x000fe200078e20ffULL,
0x0000001050427824ULL, 0x040fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000150527824ULL, 0x040fe200078e0252ULL, 0x0000e0004f367811ULL, 0x00afe200078e20ffULL,
0x0000001050417824ULL, 0x000fe200078e00ffULL, 0xfffffff042427812ULL, 0x000fe200078ee251ULL,
0x000000084e457824ULL, 0x000fe200078e00ffULL, 0x0000000454377810ULL, 0x000fe20007ffe0ffULL,
0x000000003648783bULL, 0x000e620000004200ULL, 0xfffffff041417812ULL, 0x000fe200078ee252ULL,
0x000000084e4e7824ULL, 0x000fe200078e00ffULL, 0x0000e00042427811ULL, 0x000fc400078e20ffULL,
0x0000e00041417811ULL, 0x000fe400078e20ffULL, 0x0000000654407810ULL, 0x000fe20007ffe0ffULL,
0x000000004250783bULL, 0x000ee20000004200ULL, 0xfffffff845377812ULL, 0x000fe400078ee237ULL,
0xfffffff84e407812ULL, 0x000fe200078ee240ULL, 0x000000004354783bULL, 0x000f280000004200ULL,
0x000000004158783bULL, 0x000ea20000004200ULL, 0x00000018ff607819ULL, 0x002fc40000011648ULL,
0x0000ffff48727812ULL, 0x000fe400078ec0ffULL, 0x00000010ff717819ULL, 0x000fe40000011649ULL,
0x000000ff495f7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff7a7819ULL, 0x108fe40000011651ULL,
0x000000ff518a7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff897819ULL, 0x000fc40000011651ULL,
0x0000ffff51787812ULL, 0x000fe400078ec0ffULL, 0x00000010ff777819ULL, 0x100fe40000011652ULL,
0x000000ff528b7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff8c7819ULL, 0x000fe40000011652ULL,
0x0000ffff52737812ULL, 0x000fe400078ec0ffULL, 0x00000010ff767819ULL, 0x000fc40000011653ULL,
0x000000ff53527812ULL, 0x040fe400078ec0ffULL, 0x00000018ff8e7819ULL, 0x000fe40000011653ULL,
0x0000ffff53747812ULL, 0x000fe400078ec0ffULL, 0x00000010ff457819ULL, 0x110fe40000011654ULL,
0x000000ff54477812ULL, 0x004fe400078ec0ffULL, 0x00000018ff467819ULL, 0x000fc40000011654ULL,
0x0000ffff54667812ULL, 0x000fe400078ec0ffULL, 0x00000010ff517819ULL, 0x100fe40000011655ULL,
0x000000ff554f7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff4e7819ULL, 0x000fe40000011655ULL,
0x0000ffff556b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff757819ULL, 0x000fc40000011658ULL,
0x000000ff585c7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff797819ULL, 0x000fe40000011658ULL,
0x0000ffff58907812ULL, 0x000fe400078ec0ffULL, 0x00000010ff7f7819ULL, 0x100fe4000001165aULL,
0x000000ff5a847812ULL, 0x000fe400078ec0ffULL, 0x00000018ff837819ULL, 0x000fc4000001165aULL,
0x0000ffff5a7c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff537819ULL, 0x100fe40000011656ULL,
0x000000ff56557812ULL, 0x040fe400078ec0ffULL, 0x00000018ff547819ULL, 0x000fe40000011656ULL,
0x0000ffff568d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff7e7819ULL, 0x000fc4000001165bULL,
0x000000ff5b867812ULL, 0x040fe400078ec0ffULL, 0x00000018ff857819ULL, 0x000fe4000001165bULL,
0x0000ffff5b7d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff567819ULL, 0x100fe40000011657ULL,
0x000000ff575a7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff587819ULL, 0x000fc40000011657ULL,
0x0000ffff578f7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff577819ULL, 0x000fe40000011648ULL,
0x000000ff485b7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff487819ULL, 0x000fe40000011649ULL,
0x0000004fff4f723eULL, 0x000fe400020006ffULL, 0x00000048ff48723eULL, 0x000fc400020006ffULL,
0x00000046ff46723eULL, 0x000fe200020006ffULL, 0x2000004fff6d7230ULL, 0x000fe20000004100ULL,
0x0000ffff49677812ULL, 0x000fe200078ec0ffULL, 0x20000048ff4f7230ULL, 0x000fe20000004100ULL,
0x00000008ff487819ULL, 0x000fe20000011666ULL, 0x20000046ff697230ULL, 0x000fe20000004100ULL,
0x00000018ff497819ULL, 0x000fe4000001164aULL, 0x00000048ff48723eULL, 0x000fe400020006ffULL,
0x00000049ff46723eULL, 0x000fc400020006ffULL, 0x00000008ff497819ULL, 0x000fe2000001166bULL,
0x20000048ff6b7230ULL, 0x000fe20000004100ULL, 0x00000008ff487819ULL, 0x000fe2000001168dULL,
0x20000046ff467230ULL, 0x000fe20000004100ULL, 0x00000049ff49723eULL, 0x000fe400020006ffULL,
0x00000058ff58723eULL, 0x000fe400020006ffULL, 0x00000048ff48723eULL, 0x000fe200020006ffULL,
0x20000049ff6c7230ULL, 0x000fe20000004100ULL, 0x000000ff51517812ULL, 0x000fe200078ec0ffULL,
0x20000058ff617230ULL, 0x000fe20000004100ULL, 0x00000008ff497819ULL, 0x000fc4000001168fULL,
0x00000047ff47723eULL, 0x000fe400020006ffULL, 0x00000060ff58723eULL, 0x000fe200020006ffULL,
0x20000048ff607230ULL, 0x000fe20000004100ULL, 0x00000051ff51723eULL, 0x000fe200020006ffULL,
0x20000047ff6e7230ULL, 0x000fe20000004100ULL, 0x000000ff4a627812ULL, 0x000fe200078ec0ffULL,
0x20000058ff587230ULL, 0x000fe20000004100ULL, 0x00000049ff49723eULL, 0x000fe200020006ffULL,
0x20000051ff6f7230ULL, 0x000fe20000004100ULL, 0x0000005cff48723eULL, 0x000fc400020006ffULL,
0x00000010ff687819ULL, 0x000fe4000001164aULL, 0x0000ffff4a5e7812ULL, 0x000fe200078ec0ffULL,
0x20000048ff517230ULL, 0x000fe20000004100ULL, 0x00000018ff4a7819ULL, 0x000fe4000001164bULL,
0x00000062ff47723eULL, 0x000fe200020006ffULL, 0x20000049ff627230ULL, 0x000fe20000004100ULL,
0x000000ff45457812ULL, 0x000fe400078ec0ffULL, 0x0000004aff4a723eULL, 0x000fe200020006ffULL,
0x20000047ff477230ULL, 0x000fe20000004100ULL, 0x0000008bff49723eULL, 0x000fc400020006ffULL,
0x0000a00037487811ULL, 0x000fe400078e20ffULL, 0x00000010ff807819ULL, 0x100fe20000011659ULL,
0x20000049ff8d7230ULL, 0x000fe20000004100ULL, 0x000000ff59827812ULL, 0x040fe400078ec0ffULL,
0x00000018ff817819ULL, 0x000fe40000011659ULL, 0x0000ffff59917812ULL, 0x000fe400078ec0ffULL,
0x00000045ff70723eULL, 0x000fe200020006ffULL, 0x2000004aff457230ULL, 0x000fe20000004100ULL,
0x00000010ff5d7819ULL, 0x000fc4000001164bULL, 0x000000ff4b647812ULL, 0x040fe200078ec0ffULL,
0x20000070ff707230ULL, 0x000fe20000004100ULL, 0x0000ffff4b597812ULL, 0x000fe400078ec0ffULL,
0x000000004848783bULL, 0x000e620000000200ULL, 0x00000052ff52723eULL, 0x000fe400020006ffULL,
0x000000ff53537812ULL, 0x000fe400078ec0ffULL, 0x000000ff80807812ULL, 0x000fe200078ec0ffULL,
0x20000052ff8f7230ULL, 0x000fe20000004100ULL, 0x00000053ff53723eULL, 0x000fc400020006ffULL,
0x000000ff75527812ULL, 0x000fe400078ec0ffULL, 0x000000ff57577812ULL, 0x000fe200078ec0ffULL,
0x20000053ff667230ULL, 0x000fe20000004100ULL, 0x00000082ff82723eULL, 0x000fe400020006ffULL,
0x00000052ff52723eULL, 0x000fe400020006ffULL, 0x00000080ff80723eULL, 0x000fe200020006ffULL,
0x20000082ff827230ULL, 0x000fe20000004100ULL, 0x00000057ff57723eULL, 0x000fe200020006ffULL,
0x20000052ff527230ULL, 0x000fe20000004100ULL, 0x00000008ff537819ULL, 0x000fe20000011690ULL,
0x20000080ff807230ULL, 0x000fe20000004100ULL, 0x00000010ff7b7819ULL, 0x000fe20000011650ULL,
0x20000057ff5c7230ULL, 0x000fe20000004100ULL, 0x000000ff50887812ULL, 0x000fc400078ec0ffULL,
0x00000018ff877819ULL, 0x000fe40000011650ULL, 0x0000005aff5a723eULL, 0x000fe400020006ffULL,
0x0000ffff50507812ULL, 0x000fe400078ec0ffULL, 0x00000055ff55723eULL, 0x000fe200020006ffULL,
0x2000005aff637230ULL, 0x000fe20000004100ULL, 0x00000054ff54723eULL, 0x000fe400020006ffULL,
0x00000079ff79723eULL, 0x000fe200020006ffULL, 0x20000055ff657230ULL, 0x000fe20000004100ULL,
0x00000053ff53723eULL, 0x000fe200020006ffULL, 0x0000002c4848a231ULL, 0x082fe200003400ffULL,
0x00000008ff577819ULL, 0x000fe20000011650ULL, 0x0000002c4a4aa231ULL, 0x000fe200003400ffULL,
0x0000005fff5a723eULL, 0x000fe200020006ffULL, 0x20000054ff5f7230ULL, 0x000fe20000004100ULL,
0x00000010ff507819ULL, 0x000fe20000011651ULL, 0x20000079ff547230ULL, 0x000fe20000004100ULL,
0x00000008ff557819ULL, 0x000fe20000011691ULL, 0x20000053ff537230ULL, 0x000fe20000004100ULL,
0x00000010ff517819ULL, 0x000fe20000011682ULL, 0x0000002d4949a231ULL, 0x080fe200003400ffULL,
0x00000010ff527819ULL, 0x000fe20000011652ULL, 0x0000002d4b4ba231ULL, 0x000fe200003400ffULL,
0x00000010ff807819ULL, 0x000fe20000011680ULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x00000081ff81723eULL, 0x000fc400020006ffULL, 0x00000055ff55723eULL, 0x000fe400020006ffULL,
0x00000057ff57723eULL, 0x000fe200020006ffULL, 0x20000081ff817230ULL, 0x000fe20000004100ULL,
0x0000105452507816ULL, 0x000fe20000000050ULL, 0x20000055ff557230ULL, 0x000fe20000004100ULL,
0x0000105480517816ULL, 0x000fe40000000051ULL, 0x00000008ff527819ULL, 0x000fe20000011678ULL,
0x20000057ff787230ULL, 0x000fe20000004100ULL, 0x00000010ff547819ULL, 0x000fc40000011654ULL,
0x00000010ff537819ULL, 0x000fe40000011653ULL, 0x00000008ff7c7819ULL, 0x000fe4000001167cULL,
0x00000052ff57723eULL, 0x000fe400020006ffULL, 0x0000105454547816ULL, 0x000fe40000000053ULL,
0x000000504850723cULL, 0x000b620000041810ULL, 0x00000083ff83723eULL, 0x000fe400020006ffULL,
0x0000007cff7c723eULL, 0x000fc400020006ffULL, 0x000000ff56567812ULL, 0x000fe200078ec0ffULL,
0x20000083ff837230ULL, 0x000fe20000004100ULL, 0x000000ff77107812ULL, 0x020fe200078ec0ffULL,
0x2000007cff7c7230ULL, 0x000fe20000004100ULL, 0x00000008ff7d7819ULL, 0x000fe2000001167dULL,
0x20000057ff777230ULL, 0x000fe20000004100ULL, 0x00000010ff817819ULL, 0x000fe40000011681ULL,
0x00000010ff557819ULL, 0x000fe40000011655ULL, 0x0000004eff4e723eULL, 0x000fc400020006ffULL,
0x00000010ff10723eULL, 0x000fe400020006ffULL, 0x00000056ff56723eULL, 0x000fe200020006ffULL,
0x2000004eff6a7230ULL, 0x000fe20000004100ULL, 0x00000085ff85723eULL, 0x000fe400020006ffULL,
0x0000007dff7d723eULL, 0x000fe400020006ffULL, 0x0000105481557816ULL, 0x000fe40000000055ULL,
0x000000ff76117812ULL, 0x000fe200078ec0ffULL, 0x20000010ff767230ULL, 0x000fe20000004100ULL,
0x00000064ff4e723eULL, 0x000fe200020006ffULL, 0x20000056ff647230ULL, 0x000fe20000004100ULL,
0x00000010ff837819ULL, 0x000fe20000011683ULL, 0x20000085ff567230ULL, 0x000fe20000004100ULL,
0x00000010ff7c7819ULL, 0x000fe2000001167cULL, 0x2000007dff7d7230ULL, 0x000fe20000004100ULL,
0x00000011ff11723eULL, 0x000fe200020006ffULL, 0x000000544814723cULL, 0x000b620000041814ULL,
0x0000a00040107811ULL, 0x000fe200078e20ffULL, 0x2000004eff4e7230ULL, 0x000fe20000004100ULL,
0x00000010ff567819ULL, 0x000fc40000011656ULL, 0x00000087ff87723eULL, 0x000fe400020006ffULL,
0x0000105483547816ULL, 0x020fe2000000007cULL, 0x20000011ff7c7230ULL, 0x000fe20000004100ULL,
0x00000010ff557819ULL, 0x000fe2000001167dULL, 0x000000001010783bULL, 0x000e620000000200ULL,
0x00000089ff89723eULL, 0x000fe200020006ffULL, 0x20000087ff877230ULL, 0x000fe20000004100ULL,
0x0000105456557816ULL, 0x000fe40000000055ULL, 0x000000ff7f7f7812ULL, 0x000fe200078ec0ffULL,
0x20000089ff8b7230ULL, 0x000fe20000004100ULL, 0x000000ff7e7e7812ULL, 0x000fc400078ec0ffULL,
0x000000ff7b7b7812ULL, 0x000fe200078ec0ffULL, 0x000000544854723cULL, 0x000be20000041838ULL,
0x000000ff7a7a7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff737819ULL, 0x000fe40000011673ULL,
0x00000008ff747819ULL, 0x000fe40000011674ULL, 0x00000010ff877819ULL, 0x000fe40000011687ULL,
0x00000010ff8b7819ULL, 0x000fc4000001168bULL, 0x00000010ff787819ULL, 0x000fe40000011678ULL,
0x00000010ff397819ULL, 0x020fe40000011677ULL, 0x00000084ff84723eULL, 0x000fe400020006ffULL,
0x00000086ff86723eULL, 0x000fe400020006ffULL, 0x00000088ff88723eULL, 0x000fe200020006ffULL,
0x20000084ff847230ULL, 0x000fe20000004100ULL, 0x0000008aff8a723eULL, 0x000fe200020006ffULL,
0x20000086ff867230ULL, 0x000fe20000004100ULL, 0x0000007fff7f723eULL, 0x000fe200020006ffULL,
0x20000088ff887230ULL, 0x000fe20000004100ULL, 0x0000007eff7e723eULL, 0x000fe200020006ffULL,
0x2000008aff8a7230ULL, 0x000fe20000004100ULL, 0x0000007bff7b723eULL, 0x000fe200020006ffULL,
0x2000007fff7f7230ULL, 0x000fe20000004100ULL, 0x0000007aff7a723eULL, 0x000fe200020006ffULL,
0x2000007eff7e7230ULL, 0x000fe20000004100ULL, 0x0000008cff8c723eULL, 0x000fe200020006ffULL,
0x2000007bff7b7230ULL, 0x000fe20000004100ULL, 0x0000008eff79723eULL, 0x000fe200020006ffULL,
0x2000007aff7a7230ULL, 0x000fe20000004100ULL, 0x00000073ff73723eULL, 0x000fe200020006ffULL,
0x2000008cff757230ULL, 0x000fe20000004100ULL, 0x00000074ff74723eULL, 0x000fe200020006ffULL,
0x20000079ff797230ULL, 0x000fe20000004100ULL, 0x0000105487387816ULL, 0x000fe20000000078ULL,
0x20000073ff737230ULL, 0x000fe20000004100ULL, 0x000010548b397816ULL, 0x000fe20000000039ULL,
0x20000074ff747230ULL, 0x000fe20000004100ULL, 0x00000010ff847819ULL, 0x000fe20000011684ULL,
0x0000002c1010a231ULL, 0x082fe200003400ffULL, 0x00000010ff857819ULL, 0x000fe20000011686ULL,
0x0000002c1212a231ULL, 0x000fe200003400ffULL, 0x00000010ff7f7819ULL, 0x000fe2000001167fULL,
0x000000384808723cULL, 0x000be20000041808ULL, 0x00000010ff7e7819ULL, 0x000fe2000001167eULL,
0x0000002d1111a231ULL, 0x080fe200003400ffULL, 0x00000010ff887819ULL, 0x000fe20000011688ULL,
0x0000002d1313a231ULL, 0x000fe200003400ffULL, 0x00000010ff897819ULL, 0x000fc4000001168aULL,
0x00000010ff7b7819ULL, 0x000fe4000001167bULL, 0x00000010ff7a7819ULL, 0x000fe4000001167aULL,
0x00000010ff8d7819ULL, 0x000fe4000001168dULL, 0x00000010ff777819ULL, 0x000fe4000001168fULL,
0x00000010ff767819ULL, 0x000fe40000011676ULL, 0x00000010ff7c7819ULL, 0x000fc4000001167cULL,
0x00000010ff757819ULL, 0x000fe40000011675ULL, 0x00000010ff797819ULL, 0x000fe40000011679ULL,
0x00000010ff737819ULL, 0x000fe40000011673ULL, 0x00000010ff397819ULL, 0x020fe40000011674ULL,
0x000010547f847816ULL, 0x000fe40000000084ULL, 0x000010547e857816ULL, 0x000fc40000000085ULL,
0x000010547b887816ULL, 0x000fe40000000088ULL, 0x000010547a897816ULL, 0x000fe40000000089ULL,
0x0000105476767816ULL, 0x000fe2000000008dULL, 0x000000844818723cULL, 0x000f620000041818ULL,
0x000010547c777816ULL, 0x000fe40000000077ULL, 0x0000105475387816ULL, 0x000fe40000000073ULL,
0x0000105479397816ULL, 0x000fc40000000039ULL, 0x00000010ff697819ULL, 0x000fe20000011669ULL,
0x000000884804723cULL, 0x040f620000041804ULL, 0x00000010ff6a7819ULL, 0x000fe4000001166aULL,
0x00000010ff6b7819ULL, 0x000fe4000001166bULL, 0x00000010ff6e7819ULL, 0x000fe4000001166eULL,
0x00000010ff6d7819ULL, 0x000fe2000001166dULL, 0x00000076480c723cULL, 0x000f62000004180cULL,
0x00000010ff707819ULL, 0x000fc40000011670ULL, 0x00000010ff6f7819ULL, 0x000fe4000001166fULL,
0x000000ff68687812ULL, 0x000fe400078ec0ffULL, 0x00001054706e7816ULL, 0x000fe2000000006eULL,
0x000000384848723cULL, 0x000b62000004183cULL, 0x000010546f6f7816ULL, 0x000fe4000000006dULL,
0x000000ff71717812ULL, 0x000fe400078ec0ffULL, 0x00000008ff727819ULL, 0x000fc40000011672ULL,
0x00000010ff397819ULL, 0x020fe2000001166cULL, 0x0000006e103c723cULL, 0x040f620000041850ULL,
0x0000105469387816ULL, 0x000fe4000000006bULL, 0x000010546a397816ULL, 0x000fe40000000039ULL,
0x00000008ff677819ULL, 0x000fe40000011667ULL, 0x00000068ff68723eULL, 0x000fe400020006ffULL,
0x000000ff5d5d7812ULL, 0x000fe200078ec0ffULL, 0x000000381038723cULL, 0x000b620000041814ULL,
0x00000008ff5e7819ULL, 0x000fe2000001165eULL, 0x20000068ff687230ULL, 0x000fe20000004100ULL,
0x00000008ff597819ULL, 0x000fc40000011659ULL, 0x0000005bff5b723eULL, 0x000fe400020006ffULL,
0x00000071ff71723eULL, 0x000fe400020006ffULL, 0x00000072ff72723eULL, 0x000fe200020006ffULL,
0x2000005bff5b7230ULL, 0x000fe20000004100ULL, 0x00000067ff67723eULL, 0x000fe200020006ffULL,
0x20000071ff717230ULL, 0x000fe20000004100ULL, 0x0000005dff16723eULL, 0x020fe200020006ffULL,
0x20000072ff727230ULL, 0x000fe20000004100ULL, 0x0000005eff5e723eULL, 0x000fe200020006ffULL,
0x20000067ff507230ULL, 0x000fe20000004100ULL, 0x00000059ff52723eULL, 0x000fe200020006ffULL,
0x20000016ff517230ULL, 0x000fe20000004100ULL, 0x00000010ff477819ULL, 0x000fe20000011647ULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x00000010ff687819ULL, 0x000fe20000011668ULL,
0x20000052ff527230ULL, 0x000fe20000004100ULL, 0x00000010ff657819ULL, 0x000fc40000011665ULL,
0x00000010ff637819ULL, 0x000fe40000011663ULL, 0x00000010ff667819ULL, 0x000fe40000011666ULL,
0x00000010ff647819ULL, 0x000fe40000011664ULL, 0x00000010ff5f7819ULL, 0x000fe4000001165fULL,
0x00000010ff617819ULL, 0x000fe40000011661ULL, 0x00000010ff607819ULL, 0x000fc40000011660ULL,
0x00000010ff157819ULL, 0x000fe40000011662ULL, 0x00000010ff5b7819ULL, 0x000fe4000001165bULL,
0x00000010ff5a7819ULL, 0x000fe4000001165aULL, 0x00000010ff5c7819ULL, 0x000fe4000001165cULL,
0x00000010ff5d7819ULL, 0x000fe40000011671ULL, 0x00000010ff587819ULL, 0x000fc40000011658ULL,
0x00000010ff727819ULL, 0x000fe40000011672ULL, 0x00000010ff4f7819ULL, 0x000fe4000001164fULL,
0x00000010ff507819ULL, 0x000fe40000011650ULL, 0x00000010ff4e7819ULL, 0x000fe4000001164eULL,
0x00000010ff517819ULL, 0x000fe40000011651ULL, 0x0000105468687816ULL, 0x000fc40000000047ULL,
0x00000010ff467819ULL, 0x000fe40000011646ULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x00000010ff457819ULL, 0x000fe40000011645ULL, 0x00000010ff477819ULL, 0x000fe40000011652ULL,
0x0000105466667816ULL, 0x000fe40000000065ULL, 0x0000105464677816ULL, 0x000fc40000000063ULL,
0x000010545f147816ULL, 0x000fe40000000060ULL, 0x0000105461157816ULL, 0x000fe40000000015ULL,
0x000010545c5c7816ULL, 0x000fe2000000005bULL, 0x000000661018723cULL, 0x000b620000041818ULL,
0x000010545d5d7816ULL, 0x000fe4000000005aULL, 0x0000105458587816ULL, 0x000fe40000000072ULL,
0x000010544f597816ULL, 0x000fc40000000050ULL, 0x0000105451697816ULL, 0x000fe2000000004eULL,
0x000000141014723cULL, 0x000b620000041854ULL, 0x0000105446467816ULL, 0x000fe4000000005eULL,
0x0000105445477816ULL, 0x000fca0000000047ULL, 0x0000005c1004723cULL, 0x040b700000041804ULL,
0x000000581008723cULL, 0x040b700000041808ULL, 0x00000068100c723cULL, 0x040b70000004180cULL,
0x000000461010723cULL, 0x000b620000041848ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff467f8cULL, 0x020e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000001c3500720cULL, 0x000fe20003f06070ULL,
0x01068800ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff4e7224ULL, 0x002fc400078e0047ULL,
0x000000ffff467224ULL, 0x000fd200078e004cULL, 0x0000f69000000947ULL, 0x000fea0003800000ULL,
0x0000000000467805ULL, 0x000fc40000015200ULL, 0x0106bc00ff207984ULL, 0x000e640000000800ULL,
0x8000000020ff7812ULL, 0x002fe4000780484eULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000487805ULL, 0x000fcc0000015200ULL,
0x0000004846457210ULL, 0x000fca0007f1e1ffULL, 0x0000000149487824ULL, 0x000fe200000e0e47ULL,
0x003d09004500780cULL, 0x000fc80003f06070ULL, 0x000000ff4800720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404500780cULL, 0x000fc80003f06070ULL,
0x000000ff4800720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff207819ULL, 0x000fc80000011448ULL, 0x0000004520207211ULL, 0x000fca00078110ffULL,
0x000000ffff457224ULL, 0x000fca00000e0648ULL, 0x0000000220207819ULL, 0x000fc80000001245ULL,
0x000000200000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000014a4a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106bc00ff207984ULL, 0x000e640000000800ULL, 0x8000000020ff7812ULL, 0x002fe4000780484eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000046000009947ULL, 0x000fea0003800000ULL,
0x0000002035207810ULL, 0x000fe20007ffe0ffULL, 0x000000011f467824ULL, 0x000fe200078e022eULL,
0x000000042e537810ULL, 0x000fe40007ffe0ffULL, 0x000000201c457217ULL, 0x000fe20007800000ULL,
0x0000000146477824ULL, 0x000fe200078e0203ULL, 0x000000022e4a7810ULL, 0x000fe20007ffe0ffULL,
0x0000001046517824ULL, 0x000fe200078e00ffULL, 0x000000062e557810ULL, 0x000fe20007ffe0ffULL,
0x0000000145457824ULL, 0x000fe200078e0a20ULL, 0x0000006000207811ULL, 0x000fe200078e38ffULL,
0x000000011f497824ULL, 0x000fe200078e0253ULL, 0xfffffff051517812ULL, 0x000fe200078ee247ULL,
0x000000011f487824ULL, 0x040fe200078e024aULL, 0x000000451f457217ULL, 0x000fe20007800000ULL,
0x00000001494b7824ULL, 0x040fe200078e0203ULL, 0x000000f026507812ULL, 0x000fe200078ec0ffULL,
0x0000001049547824ULL, 0x000fe200078e00ffULL, 0x0000e00051517811ULL, 0x000fe200078e20ffULL,
0x0000000146467824ULL, 0x000fc400078e0220ULL, 0x0000000148477824ULL, 0x000fe200078e0203ULL,
0xfffffff054547812ULL, 0x000fe200078ee24bULL, 0x0000001048527824ULL, 0x000fe200078e00ffULL,
0x000000464d4f7210ULL, 0x000fe20007f1e0ffULL, 0x000000011f4b7824ULL, 0x000fe200078e0255ULL,
0x0000e00054547811ULL, 0x000fe200078e20ffULL, 0x0000000148467824ULL, 0x100fe200078e0220ULL,
0xfffffff052527812ULL, 0x000fe200078ee247ULL, 0x0000000149477824ULL, 0x100fe400078e0220ULL,
0x000000014b4e7824ULL, 0x000fe200078e0203ULL, 0x000000464d467210ULL, 0x000fe20007f9e0ffULL,
0x000000104b567824ULL, 0x000fe200078e00ffULL, 0x000000474d477210ULL, 0x000fe20007f7e0ffULL,
0x000000014b207824ULL, 0x000fe200078e0220ULL, 0x0000e00052527811ULL, 0x000fe200078e20ffULL,
0x000000ffff497224ULL, 0x000fe200000e06ffULL, 0x00005e004f487a11ULL, 0x000fe200078040ffULL,
0x0000000145457824ULL, 0x000fe200078e0a1fULL, 0xfffffff056567812ULL, 0x000fe200078ee24eULL,
0x000000ffff4e7224ULL, 0x000fe200020e06ffULL, 0x000000204d207210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff4b7224ULL, 0x000fe200018e06ffULL, 0x00005e00464d7a11ULL, 0x000fc400078c40ffULL,
0x00005f004f4f7a11ULL, 0x000fe400000f4449ULL, 0x00005e0047497a11ULL, 0x000fe400078a40ffULL,
0x000000452e00720cULL, 0x080fe40003f86070ULL, 0x00005f00464e7a11ULL, 0x000fe400030f444eULL,
0x0000005048467210ULL, 0x000fe20007fde0ffULL, 0x000000ffff487224ULL, 0x000fe200010e06ffULL,
0x000000454a00720cULL, 0x000fc40003f06070ULL, 0x00005f00474b7a11ULL, 0x000fe200028f444bULL,
0x000000ffff477224ULL, 0x000fe200030e064fULL, 0x00005e00204a7a11ULL, 0x040fe400078a40ffULL,
0x000000455300720cULL, 0x080fe40003f66070ULL, 0x00005f0020207a11ULL, 0x000fe200028f4448ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000046517faeULL, 0x0003e2000e101c46ULL,
0x000000504d487210ULL, 0x000fe40007fbe0ffULL, 0x000000455500720cULL, 0x000fc40003f46070ULL,
0x0000e00056567811ULL, 0x000fe400078e20ffULL, 0x0000005049467210ULL, 0x082fe20007f9e0ffULL,
0x000000ffff497224ULL, 0x000fe200028e064eULL, 0x000000504a4a7210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff477224ULL, 0x000fe200020e064bULL, 0x0000000048527faeULL, 0x0003e2000c101c46ULL,
0x000000ffff4b7224ULL, 0x000fc600028e0620ULL, 0x0000000046547faeULL, 0x0003e8000d901c46ULL,
0x000000004a567faeULL, 0x0003e2000d101c46ULL, 0x0000039000007947ULL, 0x000fea0003800000ULL,
0x000000011f207824ULL, 0x000fe200078e022eULL, 0x0000006000467811ULL, 0x000fe400078e38ffULL,
0x000000f026507812ULL, 0x000fe200078ec0ffULL, 0x0000000120457824ULL, 0x040fe200078e0203ULL,
0x0000000220487810ULL, 0x040fe20007ffe0ffULL, 0x0000001020517824ULL, 0x040fe200078e00ffULL,
0x0000000420497810ULL, 0x000fc40007ffe0ffULL, 0x00000006204b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000148477824ULL, 0x040fe200078e0203ULL, 0xfffffff051517812ULL, 0x000fe200078ee245ULL,
0x0000001048527824ULL, 0x000fe400078e00ffULL, 0x0000000120457824ULL, 0x100fe200078e0246ULL,
0x0000e00051517811ULL, 0x000fe200078e20ffULL, 0x0000000148207824ULL, 0x100fe200078e0246ULL,
0xfffffff052527812ULL, 0x000fe200078ee247ULL, 0x00000001494a7824ULL, 0x100fe200078e0203ULL,
0x000000454d477210ULL, 0x000fe20007f7e0ffULL, 0x0000000149457824ULL, 0x100fe200078e0246ULL,
0x000000204d207210ULL, 0x000fe20007f1e0ffULL, 0x000000014b467824ULL, 0x000fe200078e0246ULL,
0x00005e00474e7a11ULL, 0x000fe200078840ffULL, 0x0000001049537824ULL, 0x000fe200078e00ffULL,
0x000000454d457210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff487224ULL, 0x000fe200018e06ffULL,
0x000000464d467210ULL, 0x000fe20007f7e0ffULL, 0x000000014b497824ULL, 0x000fe200078e0203ULL,
0xfffffff053537812ULL, 0x000fe200078ee24aULL, 0x000000104b547824ULL, 0x000fe200078e00ffULL,
0x00005f00474f7a11ULL, 0x000fe200020f4448ULL, 0x000000ffff4d7224ULL, 0x000fe200000e06ffULL,
0x00005e0020477a11ULL, 0x000fe200078040ffULL, 0x000000ffff4b7224ULL, 0x000fe200018e06ffULL,
0xfffffff054547812ULL, 0x000fe200078ee249ULL, 0x000000ffff497224ULL, 0x000fe200010e06ffULL,
0x00005e00464a7a11ULL, 0x000fc400078640ffULL, 0x00005e0045487a11ULL, 0x040fe400078440ffULL,
0x000000504e4e7210ULL, 0x080fe40007f9e0ffULL, 0x00005f00204d7a11ULL, 0x000fe400000f444dULL,
0x00005f00464b7a11ULL, 0x000fe200018f444bULL, 0x000000ffff4f7224ULL, 0x000fe200020e064fULL,
0x00005f0045497a11ULL, 0x000fe400010f4449ULL, 0x0000005047467210ULL, 0x000fc40007f1e0ffULL,
0x0000005048487210ULL, 0x080fe20007f5e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000004e517faeULL, 0x0003e2000b901c46ULL, 0x000000504a4a7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff477224ULL, 0x000fe200000e064dULL, 0x0000e00052207811ULL, 0x000fe200078e20ffULL,
0x000000ffff497224ULL, 0x000fe200010e0649ULL, 0x0000e00053457811ULL, 0x000fe200078e20ffULL,
0x000000ffff4b7224ULL, 0x000fe200018e064bULL, 0x0000e000544d7811ULL, 0x000fe200078e20ffULL,
0x0000000046207faeULL, 0x0003e8000b901c46ULL, 0x0000000048457faeULL, 0x0003e8000b901c46ULL,
0x000000004a4d7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000000124207810ULL, 0x000fc80007ffe0ffULL, 0x0000001d2000720cULL, 0x000fe20003f06070ULL,
0xffffffffff207424ULL, 0x000fd800078e00ffULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x0000000122467810ULL, 0x000fe20007ffe024ULL, 0x00000004ff477424ULL, 0x000fc800078e00ffULL,
0x0000600046467625ULL, 0x000fca00078e0047ULL, 0x0000000646207981ULL, 0x000324000c1e1900ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b000ff5c7f8cULL, 0x000ea2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010628001f4a7f8cULL, 0x000664000c80043fULL,
0x0000000000467805ULL, 0x002fc40000015200ULL, 0x01062c001f457984ULL, 0x000e640000000800ULL,
0x8000000045ff7812ULL, 0x002fe4000780484bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4d7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104d00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000487805ULL, 0x000fcc0000015200ULL,
0x0000004846487210ULL, 0x000fca0007f1e1ffULL, 0x0000000149497824ULL, 0x000fe200000e0e47ULL,
0x003d09004800780cULL, 0x000fc80003f06070ULL, 0x000000ff4900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404800780cULL, 0x000fc80003f06070ULL,
0x000000ff4900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff457819ULL, 0x000fc80000011449ULL, 0x0000004845457211ULL, 0x000fca00078110ffULL,
0x000000ffff487224ULL, 0x000fca00000e0649ULL, 0x0000000245457819ULL, 0x000fc80000001248ULL,
0x000000450000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000014d4d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01062c001f457984ULL, 0x000e640000000800ULL, 0x8000000045ff7812ULL, 0x002fe4000780484bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0100800027457984ULL, 0x000e680000000800ULL,
0x01028000274a7984ULL, 0x0006a20000000800ULL, 0x0000004c4500720bULL, 0x002fe20003f1d000ULL,
0x000152927f007947ULL, 0x000fd8000b800000ULL, 0x00000000004b7806ULL, 0x008fc800000e0100ULL,
0x0000ffff4bff7812ULL, 0x000fe2000780c0ffULL, 0x000004a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff477424ULL, 0x000fc400078e00ffULL, 0x000000ffff467224ULL, 0x000fd200078e004cULL,
0x0000046000008947ULL, 0x000fea0003800000ULL, 0x000000010200780cULL, 0x000fe40003f05270ULL,
0x0000004c4500720bULL, 0x000fe20003f54000ULL, 0x000152527f007947ULL, 0x000fd8000b800000ULL,
0x0000000000467806ULL, 0x000fc400010e0100ULL, 0x0000004c45478209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe80003800000ULL, 0x0104804727008388ULL, 0x0003e40000000800ULL,
0x0000991046477816ULL, 0x002fc800000000ffULL, 0x000000ff4700720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000004c45477209ULL, 0x000fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff46ff7812ULL, 0x000fc6000780c0ffULL,
0x0000004c47477221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b47477820ULL, 0x000fc80000410000ULL,
0x00000047004d7308ULL, 0x000e640000000800ULL, 0x0000004d21217220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff477819ULL, 0x000fe20000011603ULL,
0x000151927f007947ULL, 0x000fea000b800000ULL, 0x00001f474d477589ULL, 0x0002e400000e0000ULL,
0x000000473c3c7220ULL, 0x08cfe20000410000ULL, 0x000000473d3d7220ULL, 0x080fe20000410000ULL,
0x0000004738387220ULL, 0x080fe20000410000ULL, 0x0000004739397220ULL, 0x080fe20000410000ULL,
0x0000004718187220ULL, 0x080fe20000410000ULL, 0x0000004719197220ULL, 0x080fe20000410000ULL,
0x0000004714147220ULL, 0x080fe20000410000ULL, 0x0000004715157220ULL, 0x080fe20000410000ULL,
0x0000004704047220ULL, 0x080fe20000410000ULL, 0x0000004705057220ULL, 0x080fe20000410000ULL,
0x0000004708087220ULL, 0x080fe20000410000ULL, 0x0000004709097220ULL, 0x080fe20000410000ULL,
0x000000470c0c7220ULL, 0x080fe20000410000ULL, 0x000000470d0d7220ULL, 0x080fe20000410000ULL,
0x0000004710107220ULL, 0x080fe20000410000ULL, 0x0000004711117220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0046ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000803477811ULL, 0x000fe200078ff0ffULL,
0x000150727f007947ULL, 0x000fea000b800000ULL, 0x00001f474d477589ULL, 0x00066400000e0000ULL,
0x000000473e3e7220ULL, 0x086fe20000410000ULL, 0x000000473f3f7220ULL, 0x080fe20000410000ULL,
0x000000473a3a7220ULL, 0x080fe20000410000ULL, 0x000000473b3b7220ULL, 0x080fe20000410000ULL,
0x000000471a1a7220ULL, 0x080fe20000410000ULL, 0x000000471b1b7220ULL, 0x080fe20000410000ULL,
0x0000004716167220ULL, 0x080fe20000410000ULL, 0x0000004717177220ULL, 0x080fe20000410000ULL,
0x0000004706067220ULL, 0x080fe20000410000ULL, 0x0000004707077220ULL, 0x080fe20000410000ULL,
0x000000470a0a7220ULL, 0x080fe20000410000ULL, 0x000000470b0b7220ULL, 0x080fe20000410000ULL,
0x000000470e0e7220ULL, 0x080fe20000410000ULL, 0x000000470f0f7220ULL, 0x080fe20000410000ULL,
0x0000004712127220ULL, 0x080fe20000410000ULL, 0x0000004713137220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000ffff46ff7812ULL, 0x000fe2000780084bULL,
0x00000001ff477424ULL, 0x000fe200078e00ffULL, 0x0000004c454c7209ULL, 0x000fca0007810000ULL,
0x000000ffff467224ULL, 0x000fcc00078e004cULL, 0x8000004c45450221ULL, 0x100fe20000010000ULL,
0x000000ffff460224ULL, 0x000fe200078e004cULL, 0x00007610ff470816ULL, 0x000fe40000000047ULL,
0x3fb8aa3b45450820ULL, 0x000fc80000410000ULL, 0x00000045002b0308ULL, 0x000e640000000800ULL,
0x0000002b4a4a0220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000214a217221ULL, 0x004fc20000010000ULL, 0x0000000000487805ULL, 0x000fcc0000015200ULL,
0x0106ac00ff457984ULL, 0x000e640000000800ULL, 0x8000000045ff7812ULL, 0x002fe40007804844ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff4c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000004a7805ULL, 0x000fcc0000015200ULL, 0x0000004a484a7210ULL, 0x000fca0007f1e1ffULL,
0x000000014b4b7824ULL, 0x000fe200000e0e49ULL, 0x003d09004a00780cULL, 0x000fc80003f06070ULL,
0x000000ff4b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404a00780cULL, 0x000fc80003f06070ULL, 0x000000ff4b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff457819ULL, 0x000fc8000001144bULL,
0x0000004a45457211ULL, 0x000fca00078110ffULL, 0x000000ffff4a7224ULL, 0x000fca00000e064bULL,
0x0000000245457819ULL, 0x000fc8000000124aULL, 0x000000450000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000014c4c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106ac00ff457984ULL, 0x000e640000000800ULL,
0x8000000045ff7812ULL, 0x002fe40007804844ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991047447816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff4400720cULL, 0x000fda0003f45270ULL, 0x0000012000002947ULL, 0x000fea0003800000ULL,
0x0000002bff2c723eULL, 0x000fe400000010ffULL, 0x00000002ff457819ULL, 0x000fe40000011603ULL,
0x000054102c447816ULL, 0x000fe2000000002cULL, 0x00014c227f007947ULL, 0x000fea000b800000ULL,
0x00001f45442c7589ULL, 0x0002a400000e0000ULL, 0x00000008452d7810ULL, 0x000fe20007ffe0ffULL,
0x00014c527f007947ULL, 0x000fea000b800000ULL, 0x00001f2d442d7589ULL, 0x0002e400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001045477810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff497224ULL, 0x000fe200078e0044ULL, 0x00007db000487802ULL, 0x000fc40000000f00ULL,
0x0001574000007944ULL, 0x01efea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001845477810ULL, 0x004fe20007ffe0ffULL, 0x000000ffff497224ULL, 0x000fe200078e0044ULL,
0x00007e0000487802ULL, 0x000fc40000000f00ULL, 0x000156f000007944ULL, 0x01afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000002f54783bULL, 0x000e680000004200ULL, 0x00000000314c783bULL, 0x008ee80000004200ULL,
0x000000003050783bULL, 0x000ea80000004200ULL, 0x000000003348783bULL, 0x000ea20000004200ULL,
0x00000010ff637819ULL, 0x002fc40000011654ULL, 0x000000ff54447812ULL, 0x040fe400078ec0ffULL,
0x00000018ff5a7819ULL, 0x000fe40000011654ULL, 0x0000ffff548e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff7b7819ULL, 0x100fe40000011655ULL, 0x000000ff555b7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff547819ULL, 0x000fc40000011655ULL, 0x0000ffff558f7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff557819ULL, 0x000fe40000011656ULL, 0x000000ff4c6d7812ULL, 0x008fe400078ec0ffULL,
0x000000ff4d6f7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff6e7819ULL, 0x000fe4000001164dULL,
0x00000010ff857819ULL, 0x004fc40000011651ULL, 0x000000ff51677812ULL, 0x040fe400078ec0ffULL,
0x00000018ff667819ULL, 0x000fe40000011651ULL, 0x0000ffff51937812ULL, 0x000fe400078ec0ffULL,
0x00000055ff55723eULL, 0x000fe400020006ffULL, 0x00000010ff517819ULL, 0x100fe40000011648ULL,
0x000000ff48867812ULL, 0x000fe200078ec0ffULL, 0x20000055ff707230ULL, 0x000fe20000004100ULL,
0x00000018ff837819ULL, 0x000fc40000011648ULL, 0x0000ffff48597812ULL, 0x000fe400078ec0ffULL,
0x00000010ff587819ULL, 0x100fe40000011649ULL, 0x000000ff49897812ULL, 0x040fe400078ec0ffULL,
0x00000018ff887819ULL, 0x000fe40000011649ULL, 0x0000ffff495f7812ULL, 0x000fe400078ec0ffULL,
0x0000006dff6d723eULL, 0x000fc400020006ffULL, 0x000000ff52697812ULL, 0x000fe400078ec0ffULL,
0x0000006fff48723eULL, 0x000fe200020006ffULL, 0x2000006dff6f7230ULL, 0x000fe20000004100ULL,
0x0000006eff49723eULL, 0x000fe400020006ffULL, 0x00000018ff7c7819ULL, 0x000fe2000001164eULL,
0x20000048ff6e7230ULL, 0x000fe20000004100ULL, 0x00000010ff607819ULL, 0x000fe2000001164aULL,
0x20000049ff6d7230ULL, 0x000fe20000004100ULL, 0x000000ff4a8c7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff8b7819ULL, 0x000fe4000001164aULL, 0x0000ffff4a477812ULL, 0x000fe400078ec0ffULL,
0x00000018ff4a7819ULL, 0x000fe4000001164bULL, 0x000000ff63637812ULL, 0x000fe400078ec0ffULL,
0x000000ff7b7b7812ULL, 0x000fe400078ec0ffULL, 0x0000005bff5b723eULL, 0x000fc400020006ffULL,
0x00000069ff55723eULL, 0x000fe400020006ffULL, 0x00000044ff78723eULL, 0x000fe200020006ffULL,
0x2000005bff7d7230ULL, 0x000fe20000004100ULL, 0x0000007cff69723eULL, 0x000fe200020006ffULL,
0x20000055ff557230ULL, 0x000fe20000004100ULL, 0x00000018ff6a7819ULL, 0x000fe20000011653ULL,
0x20000078ff787230ULL, 0x000fe20000004100ULL, 0x00000010ff457819ULL, 0x000fe2000001164bULL,
0x20000069ff697230ULL, 0x000fe20000004100ULL, 0x000000ff4b8d7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff4b447812ULL, 0x000fe400078ec0ffULL, 0x00000008ff497819ULL, 0x000fe4000001168eULL,
0x0000004aff7c723eULL, 0x000fe400020006ffULL, 0x00000063ff48723eULL, 0x000fe400020006ffULL,
0x000000ff4e7e7812ULL, 0x000fe200078ec0ffULL, 0x2000007cff637230ULL, 0x000fe20000004100ULL,
0x0000007bff4a723eULL, 0x000fe200020006ffULL, 0x20000048ff7b7230ULL, 0x000fe20000004100ULL,
0x00000008ff4b7819ULL, 0x000fc4000001168fULL, 0x00000010ff7f7819ULL, 0x000fe40000011656ULL,
0x0000ffff56907812ULL, 0x000fe400078ec0ffULL, 0x00000010ff807819ULL, 0x000fe40000011657ULL,
0x0000006aff5b723eULL, 0x000fe400020006ffULL, 0x00000049ff49723eULL, 0x000fe400020006ffULL,
0x0000007eff6a723eULL, 0x000fe200020006ffULL, 0x2000004aff7e7230ULL, 0x000fe20000004100ULL,
0x0000004bff4b723eULL, 0x000fe200020006ffULL, 0x20000049ff7c7230ULL, 0x000fe20000004100ULL,
0x000000ff7f487812ULL, 0x000fe200078ec0ffULL, 0x2000005bff5b7230ULL, 0x000fe20000004100ULL,
0x000000ff80807812ULL, 0x000fe200078ec0ffULL, 0x2000004bff7f7230ULL, 0x000fe20000004100ULL,
0x00000008ff4a7819ULL, 0x000fe20000011690ULL, 0x2000006aff6a7230ULL, 0x000fe20000004100ULL,
0x0000005aff5a723eULL, 0x000fc400020006ffULL, 0x00000054ff54723eULL, 0x000fe400020006ffULL,
0x00000018ff687819ULL, 0x000fe20000011652ULL, 0x2000005aff767230ULL, 0x000fe20000004100ULL,
0x000000ff536b7812ULL, 0x000fe200078ec0ffULL, 0x20000054ff777230ULL, 0x000fe20000004100ULL,
0x00000048ff49723eULL, 0x000fe400020006ffULL, 0x000000ff4f827812ULL, 0x000fe400078ec0ffULL,
0x00000018ff817819ULL, 0x000fc4000001164fULL, 0x00000080ff4b723eULL, 0x000fe200020006ffULL,
0x20000049ff807230ULL, 0x000fe20000004100ULL, 0x0000004aff4a723eULL, 0x000fe400020006ffULL,
0x0000a80034487811ULL, 0x000fe400078e20ffULL, 0x0000006bff54723eULL, 0x000fe400020006ffULL,
0x00000068ff5a723eULL, 0x000fe400020006ffULL, 0x00000082ff6b723eULL, 0x000fe200020006ffULL,
0x2000004bff827230ULL, 0x000fe20000004100ULL, 0x00000081ff68723eULL, 0x000fe200020006ffULL,
0x2000004aff817230ULL, 0x000fe20000004100ULL, 0x0000ffff50927812ULL, 0x000fe200078ec0ffULL,
0x000000004848783bULL, 0x000e620000000200ULL, 0x00000010ff8a7819ULL, 0x000fe20000011653ULL,
0x20000054ff547230ULL, 0x000fe20000004100ULL, 0x0000ffff537a7812ULL, 0x000fe200078ec0ffULL,
0x2000005aff5a7230ULL, 0x000fe20000004100ULL, 0x00000066ff53723eULL, 0x000fe200020006ffULL,
0x2000006bff6b7230ULL, 0x000fe20000004100ULL, 0x00000086ff66723eULL, 0x000fe200020006ffULL,
0x20000068ff687230ULL, 0x000fe20000004100ULL, 0x000000ff85867812ULL, 0x000fe200078ec0ffULL,
0x20000053ff537230ULL, 0x000fe20000004100ULL, 0x00000008ff857819ULL, 0x000fe20000011692ULL,
0x20000066ff667230ULL, 0x000fe20000004100ULL, 0x000000ff565e7812ULL, 0x000fc400078ec0ffULL,
0x000000ff57627812ULL, 0x040fe400078ec0ffULL, 0x00000018ff617819ULL, 0x000fe40000011657ULL,
0x0000ffff57917812ULL, 0x000fe400078ec0ffULL, 0x00000010ff877819ULL, 0x000fe40000011652ULL,
0x00000086ff86723eULL, 0x000fe400020006ffULL, 0x00000010ff577819ULL, 0x000fc4000001164dULL,
0x0000ffff4d567812ULL, 0x000fe400078ec0ffULL, 0x00000085ff85723eULL, 0x000fe400020006ffULL,
0x00000010ff737819ULL, 0x000fe4000001164cULL, 0x00000067ff4d723eULL, 0x000fe400020006ffULL,
0x0000ffff52947812ULL, 0x000fe400078ec0ffULL, 0x0000ffff4c797812ULL, 0x000fe200078ec0ffULL,
0x2000004dff4d7230ULL, 0x000fe20000004100ULL, 0x00000089ff67723eULL, 0x000fe200020006ffULL,
0x0000002c4848a231ULL, 0x082fe200003400ffULL, 0x00000062ff62723eULL, 0x000fe200020006ffULL,
0x0000002c4a4aa231ULL, 0x000fe200003400ffULL, 0x000000ff87897812ULL, 0x000fe200078ec0ffULL,
0x20000086ff877230ULL, 0x000fe20000004100ULL, 0x000000ff73737812ULL, 0x000fe200078ec0ffULL,
0x20000085ff867230ULL, 0x000fe20000004100ULL, 0x00000008ff857819ULL, 0x000fe20000011694ULL,
0x20000062ff757230ULL, 0x000fe20000004100ULL, 0x00000008ff797819ULL, 0x000fe20000011679ULL,
0x0000002d4949a231ULL, 0x080fe200003400ffULL, 0x0000005eff5e723eULL, 0x000fe200020006ffULL,
0x0000002d4b4ba231ULL, 0x000fe200003400ffULL, 0x0000008cff62723eULL, 0x000fe200020006ffULL,
0x20000067ff677230ULL, 0x000fe20000004100ULL, 0x00000073ff73723eULL, 0x000fe200020006ffULL,
0x2000005eff747230ULL, 0x000fe20000004100ULL, 0x00000085ff85723eULL, 0x000fe200020006ffULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x00000079ff8c723eULL, 0x000fc400020006ffULL,
0x00000018ff647819ULL, 0x000fe20000011650ULL, 0x20000085ff797230ULL, 0x000fe20000004100ULL,
0x000000ff57577812ULL, 0x000fe400078ec0ffULL, 0x0000008bff5e723eULL, 0x000fe200020006ffULL,
0x20000073ff8b7230ULL, 0x000fe20000004100ULL, 0x00000064ff52723eULL, 0x000fe200020006ffULL,
0x2000008cff737230ULL, 0x000fe20000004100ULL, 0x00000083ff64723eULL, 0x000fe200020006ffULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x00000057ff85723eULL, 0x000fe200020006ffULL,
0x20000052ff527230ULL, 0x000fe20000004100ULL, 0x00000008ff8c7819ULL, 0x000fe20000011656ULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x00000008ff837819ULL, 0x000fc40000011691ULL,
0x00000010ff567819ULL, 0x000fe20000011678ULL, 0x20000085ff787230ULL, 0x000fe20000004100ULL,
0x00000010ff577819ULL, 0x000fe4000001167dULL, 0x00000010ff7b7819ULL, 0x000fe4000001167bULL,
0x00000010ff7e7819ULL, 0x000fe4000001167eULL, 0x00000010ff847819ULL, 0x000fe40000011650ULL,
0x00000010ff727819ULL, 0x000fc4000001164eULL, 0x00000018ff6c7819ULL, 0x000fe4000001164cULL,
0x00000061ff61723eULL, 0x000fe400020006ffULL, 0x00000010ff4c7819ULL, 0x000fe4000001164fULL,
0x00000083ff83723eULL, 0x000fe200020006ffULL, 0x20000061ff717230ULL, 0x000fe20000004100ULL,
0x000010547b567816ULL, 0x000fe40000000056ULL, 0x000010547e577816ULL, 0x000fe20000000057ULL,
0x20000083ff837230ULL, 0x000fe20000004100ULL, 0x000000ff50657812ULL, 0x000fc400078ec0ffULL,
0x000000ff84847812ULL, 0x000fe400078ec0ffULL, 0x000000ff727b7812ULL, 0x000fe200078ec0ffULL,
0x00000056483c723cULL, 0x000b62000004183cULL, 0x00000010ff727819ULL, 0x000fe40000011677ULL,
0x00000010ff767819ULL, 0x000fe40000011676ULL, 0x00000010ff7c7819ULL, 0x000fe4000001167cULL,
0x00000010ff777819ULL, 0x000fc4000001167fULL, 0x000000ff4c4c7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff4f507812ULL, 0x000fe400078ec0ffULL, 0x00000065ff4f723eULL, 0x000fe400020006ffULL,
0x00000084ff84723eULL, 0x000fe400020006ffULL, 0x0000ffff4e4e7812ULL, 0x000fe200078ec0ffULL,
0x2000004fff4f7230ULL, 0x000fe20000004100ULL, 0x0000105476767816ULL, 0x000fe2000000007cULL,
0x20000084ff847230ULL, 0x000fe20000004100ULL, 0x0000105472777816ULL, 0x000fc40000000077ULL,
0x0000004cff56723eULL, 0x020fe400020006ffULL, 0x00000010ff4c7819ULL, 0x000fe40000011671ULL,
0x00000010ff707819ULL, 0x000fe20000011670ULL, 0x000000764838723cULL, 0x000b620000041838ULL,
0x00000010ff817819ULL, 0x000fe40000011681ULL, 0x00000010ff717819ULL, 0x000fe40000011683ULL,
0x00000008ff4e7819ULL, 0x000fc4000001164eULL, 0x00000088ff65723eULL, 0x000fe200020006ffULL,
0x20000056ff767230ULL, 0x020fe20000004100ULL, 0x00000008ff887819ULL, 0x000fe40000011693ULL,
0x0000105470707816ULL, 0x000fe20000000081ULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x000010544c717816ULL, 0x000fe40000000071ULL, 0x0000004eff4e723eULL, 0x000fe400020006ffULL,
0x00000010ff4f7819ULL, 0x000fc4000001164fULL, 0x00000010ff4d7819ULL, 0x000fe2000001164dULL,
0x2000004eff727230ULL, 0x000fe20000004100ULL, 0x00000010ff847819ULL, 0x000fe40000011684ULL,
0x00000010ff857819ULL, 0x000fe40000011687ULL, 0x0000a80032567811ULL, 0x000fe400078e20ffULL,
0x00000088ff88723eULL, 0x000fe400020006ffULL, 0x000000ff8a8a7812ULL, 0x000fc400078ec0ffULL,
0x0000105484847816ULL, 0x000fe2000000004fULL, 0x20000088ff887230ULL, 0x000fe20000004100ULL,
0x0000105485857816ULL, 0x000fe4000000004dULL, 0x00000008ff7a7819ULL, 0x000fe2000001167aULL,
0x00000070484c723cULL, 0x000be20000041814ULL, 0x00000089ff89723eULL, 0x000fe200020006ffULL,
0x000000005614783bULL, 0x0202a20000000200ULL, 0x0000008aff8a723eULL, 0x000fe400020006ffULL,
0x0000007aff7a723eULL, 0x000fe200020006ffULL, 0x20000089ff897230ULL, 0x000fe20000004100ULL,
0x00000008ff507819ULL, 0x000fe20000011650ULL, 0x2000008aff8a7230ULL, 0x000fe20000004100ULL,
0x000000ff51517812ULL, 0x000fe200078ec0ffULL, 0x2000007aff7a7230ULL, 0x000fe20000004100ULL,
0x00000010ff527819ULL, 0x000fc40000011652ULL, 0x00000010ff537819ULL, 0x000fe40000011653ULL,
0x00000010ff867819ULL, 0x000fe40000011686ULL, 0x00000010ff577819ULL, 0x000fe40000011688ULL,
0x00000050ff70723eULL, 0x000fe400020006ffULL, 0x00000051ff71723eULL, 0x000fe400020006ffULL,
0x0000105452567816ULL, 0x002fe20000000086ULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x0000105453577816ULL, 0x000fe20000000057ULL, 0x20000071ff717230ULL, 0x000fe20000004100ULL,
0x000000844850723cULL, 0x000be20000041804ULL, 0x00000010ff747819ULL, 0x000fc40000011674ULL,
0x00000010ff757819ULL, 0x000fe40000011675ULL, 0x00000010ff807819ULL, 0x000fe40000011680ULL,
0x00000010ff827819ULL, 0x000fe40000011682ULL, 0x00000010ff557819ULL, 0x000fe40000011655ULL,
0x00000010ff057819ULL, 0x020fe40000011654ULL, 0x00000010ff897819ULL, 0x000fc40000011689ULL,
0x00000010ff8a7819ULL, 0x000fe2000001168aULL, 0x0000002c1414a231ULL, 0x084fe200003400ffULL,
0x00000010ff5a7819ULL, 0x000fe2000001165aULL, 0x0000002c1616a231ULL, 0x000fe200003400ffULL,
0x00000010ff5b7819ULL, 0x000fe2000001165bULL, 0x0000002d1515a231ULL, 0x080fe200003400ffULL,
0x00000010ff797819ULL, 0x000fe20000011679ULL, 0x0000002d1717a231ULL, 0x000fe200003400ffULL,
0x00000010ff077819ULL, 0x000fe4000001167aULL, 0x0000105480747816ULL, 0x000fc40000000074ULL,
0x0000105482757816ULL, 0x000fe40000000075ULL, 0x0000105489047816ULL, 0x000fe40000000055ULL,
0x000010548a057816ULL, 0x000fe20000000005ULL, 0x000000564854723cULL, 0x000be20000041808ULL,
0x000010545a067816ULL, 0x000fe40000000079ULL, 0x000010545b077816ULL, 0x000fe40000000007ULL,
0x000000ff58587812ULL, 0x000fc400078ec0ffULL, 0x00000008ff597819ULL, 0x000fe20000011659ULL,
0x000000744818723cULL, 0x040f620000041818ULL, 0x00000008ff5f7819ULL, 0x000fe4000001165fULL,
0x00000058ff0a723eULL, 0x020fe400020006ffULL, 0x00000059ff08723eULL, 0x000fe400020006ffULL,
0x000000ff60607812ULL, 0x000fe200078ec0ffULL, 0x000000044858723cULL, 0x000b62000004180cULL,
0x0000005fff5f723eULL, 0x000fc400020006ffULL, 0x000000ff45457812ULL, 0x000fe400078ec0ffULL,
0x00000008ff477819ULL, 0x000fe20000011647ULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x00000008ff447819ULL, 0x000fe20000011644ULL, 0x000000064848723cULL, 0x000b620000041810ULL,
0x0000006cff6c723eULL, 0x000fe200020006ffULL, 0x2000000aff0c7230ULL, 0x020fe20000004100ULL,
0x0000008dff61723eULL, 0x000fe200020006ffULL, 0x20000008ff0e7230ULL, 0x000fe20000004100ULL,
0x0000008cff8c723eULL, 0x000fe200020006ffULL, 0x2000006cff6c7230ULL, 0x000fe20000004100ULL,
0x0000007bff7b723eULL, 0x000fe200020006ffULL, 0x20000061ff617230ULL, 0x000fe20000004100ULL,
0x00000060ff60723eULL, 0x000fe200020006ffULL, 0x2000008cff8c7230ULL, 0x000fe20000004100ULL,
0x00000045ff45723eULL, 0x000fe200020006ffULL, 0x2000007bff7b7230ULL, 0x000fe20000004100ULL,
0x00000047ff47723eULL, 0x000fe200020006ffULL, 0x20000060ff607230ULL, 0x000fe20000004100ULL,
0x00000044ff44723eULL, 0x000fe200020006ffULL, 0x20000045ff457230ULL, 0x000fe20000004100ULL,
0x00000010ff657819ULL, 0x000fe20000011665ULL, 0x20000047ff477230ULL, 0x000fe20000004100ULL,
0x00000010ff5f7819ULL, 0x000fe2000001165fULL, 0x20000044ff447230ULL, 0x000fe20000004100ULL,
0x00000010ff6f7819ULL, 0x000fc4000001166fULL, 0x00000010ff097819ULL, 0x000fe4000001166eULL,
0x00000010ff8b7819ULL, 0x000fe4000001168bULL, 0x00000010ff787819ULL, 0x000fe40000011678ULL,
0x00000010ff6c7819ULL, 0x000fe4000001166cULL, 0x00000010ff6d7819ULL, 0x000fe4000001166dULL,
0x00000010ff737819ULL, 0x000fc40000011673ULL, 0x00000010ff057819ULL, 0x000fe4000001168cULL,
0x00000010ff6a7819ULL, 0x000fe4000001166aULL, 0x00000010ff6b7819ULL, 0x000fe4000001166bULL,
0x00000010ff7b7819ULL, 0x000fe4000001167bULL, 0x00000010ff767819ULL, 0x000fe40000011676ULL,
0x00000010ff697819ULL, 0x000fc40000011669ULL, 0x00000010ff687819ULL, 0x000fe40000011668ULL,
0x00000010ff727819ULL, 0x000fe40000011672ULL, 0x00000010ff117819ULL, 0x000fe40000011670ULL,
0x00000010ff667819ULL, 0x000fe40000011666ULL, 0x00000010ff0d7819ULL, 0x000fe40000011667ULL,
0x00000010ff717819ULL, 0x000fc40000011671ULL, 0x00000010ff0f7819ULL, 0x000fe4000001160cULL,
0x00000010ff647819ULL, 0x000fe40000011664ULL, 0x00000010ff0e7819ULL, 0x000fe4000001160eULL,
0x0000105465657816ULL, 0x000fe4000000005fULL, 0x00000010ff627819ULL, 0x000fe40000011662ULL,
0x00000010ff607819ULL, 0x000fc40000011660ULL, 0x00000010ff617819ULL, 0x000fe40000011661ULL,
0x00000010ff457819ULL, 0x000fe40000011645ULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x00000010ff477819ULL, 0x000fe40000011647ULL, 0x00000010ff5f7819ULL, 0x000fe40000011663ULL,
0x00000010ff447819ULL, 0x000fc40000011644ULL, 0x000010548b087816ULL, 0x000fe4000000006fULL,
0x0000105478097816ULL, 0x000fe40000000009ULL, 0x000010546c047816ULL, 0x000fe40000000073ULL,
0x000010546d057816ULL, 0x000fe40000000005ULL, 0x000010547b6a7816ULL, 0x000fe2000000006aULL,
0x000000081408723cULL, 0x000b62000004183cULL, 0x00001054766b7816ULL, 0x000fc4000000006bULL,
0x0000105469107816ULL, 0x000fe40000000072ULL, 0x0000105468117816ULL, 0x000fe40000000011ULL,
0x00001054710c7816ULL, 0x000fe20000000066ULL, 0x000000041404723cULL, 0x000b620000041838ULL,
0x000010540f0d7816ULL, 0x000fe4000000000dULL, 0x0000105464647816ULL, 0x000fe4000000000eULL,
0x0000105460607816ULL, 0x000fc40000000062ULL, 0x0000105445617816ULL, 0x000fe20000000061ULL,
0x0000006a1418723cULL, 0x000b620000041818ULL, 0x000010545e5e7816ULL, 0x000fe40000000047ULL,
0x000010545f5f7816ULL, 0x000fca0000000044ULL, 0x000000101410723cULL, 0x040b70000004184cULL,
0x0000000c140c723cULL, 0x040b700000041850ULL, 0x000000641454723cULL, 0x040b700000041854ULL,
0x000000601458723cULL, 0x040b700000041858ULL, 0x0000005e1414723cULL, 0x000b620000041848ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff3c7f8cULL, 0x020e62000c80043fULL,
0x000000ffff3f7224ULL, 0x000fce00078e00ffULL, 0x0000000000387805ULL, 0x000fc40000015200ULL,
0x0106bc00ff3a7984ULL, 0x000ea40000000800ULL, 0x800000003aff7812ULL, 0x006fc4000780483dULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103f00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383e7210ULL, 0x000fca0007f1e1ffULL, 0x000000013b3b7824ULL, 0x000fe200000e0e39ULL,
0x003d09003e00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403e00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3a7819ULL, 0x000fc8000001143bULL, 0x0000003e3a3a7211ULL, 0x000fca00078110ffULL,
0x000000ffff3b7224ULL, 0x000fca00000e063bULL, 0x000000023a3a7819ULL, 0x000fc8000000123bULL,
0x0000003a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013f3f7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106bc00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe4000780483dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000580020457a24ULL, 0x010fc800078e02ffULL,
0x0000008045457824ULL, 0x000fe200078e00ffULL, 0x0000045000009947ULL, 0x000fea0003800000ULL,
0x0000004035387810ULL, 0x000fe20007ffe0ffULL, 0x000000011f3a7824ULL, 0x000fe200078e022eULL,
0x000000022e4a7810ULL, 0x000fe40007ffe0ffULL, 0x000000381c397217ULL, 0x000fe20007800000ULL,
0x0000008000477824ULL, 0x000fe200078e023aULL, 0x000000042e4c7810ULL, 0x000fe20007ffe0ffULL,
0x000000013a3b7824ULL, 0x000fe200078e0203ULL, 0x000000f026487812ULL, 0x000fe200078ec0ffULL,
0x000000103a497824ULL, 0x000fe200078e00ffULL, 0x00000045473e7210ULL, 0x000fe20007f1e0ffULL,
0x000000011f3a7824ULL, 0x000fe200078e024aULL, 0x0000000247447810ULL, 0x000fe20007ffe0ffULL,
0x0000000139397824ULL, 0x000fe200078e0a38ULL, 0xfffffff049497812ULL, 0x000fe200078ee23bULL,
0x000000011f387824ULL, 0x000fe200078e024cULL, 0x00000004473f7810ULL, 0x000fe20007ffe0ffULL,
0x000000013a3b7824ULL, 0x140fe200078e0203ULL, 0x000000391f397217ULL, 0x000fe20007800000ULL,
0x000000103a4b7824ULL, 0x000fe200078e00ffULL, 0x000000453f3f7210ULL, 0x000fe20007f7e0ffULL,
0x00000001383a7824ULL, 0x040fe200078e0203ULL, 0x0000c00049497811ULL, 0x000fe200078e20ffULL,
0x00000010384d7824ULL, 0x000fe200078e00ffULL, 0xfffffff04b4b7812ULL, 0x000fe200078ee23bULL,
0x000000ffff387224ULL, 0x000fe200000e06ffULL, 0x00005e003e3d7a11ULL, 0x040fe200078040ffULL,
0x00000001393b7824ULL, 0x000fe200078e0a1fULL, 0xfffffff04d4d7812ULL, 0x000fe200078ee23aULL,
0x000000ffff397224ULL, 0x000fe200018e06ffULL, 0x00005f003e3e7a11ULL, 0x000fc400000f4438ULL,
0x0000004544447210ULL, 0x000fe40007f1e0ffULL, 0x0000003b2e00720cULL, 0x000fe40003f86070ULL,
0x00005e003f3a7a11ULL, 0x040fe200078a40ffULL, 0x000000ffff387224ULL, 0x000fe200000e06ffULL,
0x00005e00443c7a11ULL, 0x040fe400078040ffULL, 0x00005f003f3f7a11ULL, 0x000fe400028f4439ULL,
0x00005f0044447a11ULL, 0x000fc400000f4438ULL, 0x000000483d387210ULL, 0x000fe40007f7e0ffULL,
0x0000003b4a00720cULL, 0x080fe40003f06070ULL, 0x000000062e4a7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff397224ULL, 0x000fe200018e063eULL, 0x00000006473d7810ULL, 0x000fe40007ffe0ffULL,
0x0000003b4c00720cULL, 0x000fe20003f66070ULL, 0x000000011f3e7824ULL, 0x000fe200078e024aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000038497faeULL, 0x0003e2000e101c46ULL,
0x000000453d3d7210ULL, 0x000fc40007f9e0ffULL, 0x000000013e477824ULL, 0x000fe200078e0203ULL,
0x000000483a3a7210ULL, 0x080fe40007fde0ffULL, 0x0000c0004b4b7811ULL, 0x000fe400078e20ffULL,
0x0000c0004d4d7811ULL, 0x000fe400078e20ffULL, 0x000000483c387210ULL, 0x002fe20007fbe0ffULL,
0x000000103e497824ULL, 0x000fe400078e00ffULL, 0x000000ffff3e7224ULL, 0x000fe200020e06ffULL,
0x00005e003d3c7a11ULL, 0x040fe200078840ffULL, 0x000000ffff397224ULL, 0x000fe200028e0644ULL,
0x0000003b4a00720cULL, 0x000fe20003fa6070ULL, 0x000000ffff3b7224ULL, 0x000fe200030e063fULL,
0x00005f003d3d7a11ULL, 0x000fc400020f443eULL, 0x000000483c3c7210ULL, 0x000fe20007f9e0ffULL,
0x00000000384b7faeULL, 0x0003e2000c101c46ULL, 0xfffffff049477812ULL, 0x000fc600078ee247ULL,
0x000000ffff3d7224ULL, 0x000fe200020e063dULL, 0x0000c00047477811ULL, 0x000fe200078e20ffULL,
0x000000003a4d7faeULL, 0x0003e8000d901c46ULL, 0x000000003c477faeULL, 0x0003e2000e901c46ULL,
0x0000038000007947ULL, 0x000fea0003800000ULL, 0x000000011f387824ULL, 0x000fc800078e022eULL,
0x0000000138397824ULL, 0x040fe200078e0203ULL, 0x00000002383a7810ULL, 0x040fe20007ffe0ffULL,
0x00000010383c7824ULL, 0x000fc800078e00ffULL, 0x000000013a3b7824ULL, 0x000fe200078e0203ULL,
0xfffffff03c3c7812ULL, 0x000fe200078ee239ULL, 0x000000103a447824ULL, 0x000fe200078e00ffULL,
0x00000004383a7810ULL, 0x000fe20007ffe0ffULL, 0x0000008000397824ULL, 0x000fc600078e0238ULL,
0xfffffff044447812ULL, 0x000fe200078ee23bULL, 0x000000013a3d7824ULL, 0x100fe200078e0203ULL,
0x00000006383b7810ULL, 0x000fe20007ffe0ffULL, 0x000000103a4a7824ULL, 0x000fe200078e00ffULL,
0x0000004539387210ULL, 0x000fe40007f1e0ffULL, 0x0000c00044447811ULL, 0x000fe200078e20ffULL,
0x000000013b3e7824ULL, 0x040fe200078e0203ULL, 0xfffffff04a4a7812ULL, 0x000fe200078ee23dULL,
0x000000103b4e7824ULL, 0x000fe200078e00ffULL, 0x00000002393d7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff3a7224ULL, 0x000fe200000e06ffULL, 0x00005e00383b7a11ULL, 0x000fc400078040ffULL,
0xfffffff04e4e7812ULL, 0x000fe400078ee23eULL, 0x00005f00383a7a11ULL, 0x000fe400000f443aULL,
0x0000000439387810ULL, 0x040fe40007ffe0ffULL, 0x0000000639397810ULL, 0x000fe40007ffe0ffULL,
0x000000453d3d7210ULL, 0x080fe40007f1e0ffULL, 0x0000004538477210ULL, 0x000fc40007f7e0ffULL,
0x000000f0263e7812ULL, 0x000fe400078ec0ffULL, 0x00000045394b7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff397224ULL, 0x000fe200000e06ffULL, 0x00005e003d3f7a11ULL, 0x000fe200078040ffULL,
0x000000ffff487224ULL, 0x000fe200018e06ffULL, 0x0000003e3b387210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff4c7224ULL, 0x000fe200028e06ffULL, 0x00005e0047497a11ULL, 0x000fe400078840ffULL,
0x00005e004b4d7a11ULL, 0x000fc400078a40ffULL, 0x00005f003d3d7a11ULL, 0x000fe200000f4439ULL,
0x000000ffff397224ULL, 0x000fe200018e063aULL, 0x0000c0003c3b7811ULL, 0x000fe400078e20ffULL,
0x0000003e3f3a7210ULL, 0x080fe40007f1e0ffULL, 0x00005f0047487a11ULL, 0x000fe200020f4448ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000383b7faeULL, 0x0003e2000b901c46ULL,
0x0000003e493c7210ULL, 0x000fe40007f7e0ffULL, 0x00005f004b4c7a11ULL, 0x000fc400028f444cULL,
0x0000003e4d3e7210ULL, 0x000fe40007f9e0ffULL, 0x0000c0004a4a7811ULL, 0x000fe400078e20ffULL,
0x0000c0004e4e7811ULL, 0x000fe200078e20ffULL, 0x000000ffff3f7224ULL, 0x000fe400020e064cULL,
0x000000ffff3b7224ULL, 0x002fe400000e063dULL, 0x000000ffff3d7224ULL, 0x000fc600018e0648ULL,
0x000000003a447faeULL, 0x0003e8000b901c46ULL, 0x000000003c4a7faeULL, 0x0003e8000b901c46ULL,
0x000000003e4e7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff387f8cULL, 0x000e64000c80043fULL,
0x000000ffff447224ULL, 0x002fc400078e0039ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x0106b400ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fc4000780485dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3d7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103d00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383c7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003c00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403c00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003c3a3a7211ULL, 0x000fca00078110ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106b400ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe4000780485dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000014000007945ULL, 0x000fe20003800000ULL, 0x0000012000002947ULL, 0x000fea0003800000ULL,
0x0000002bff2c723eULL, 0x000fe400000010ffULL, 0x00000002ff397819ULL, 0x000fe40000011603ULL,
0x000054102c387816ULL, 0x000fe2000000002cULL, 0x000128227f007947ULL, 0x000fea000b800000ULL,
0x00001f39382c7589ULL, 0x0002a400000e0000ULL, 0x00000008392d7810ULL, 0x000fe20007ffe0ffULL,
0x000128527f007947ULL, 0x000fea000b800000ULL, 0x00001f2d382d7589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001039477810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff497224ULL, 0x000fe200078e0038ULL, 0x0000a27000487802ULL, 0x000fc40000000f00ULL,
0x0001328000007944ULL, 0x00efea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001839477810ULL, 0x004fe20007ffe0ffULL, 0x000000ffff497224ULL, 0x000fe200078e0038ULL,
0x0000a2c000487802ULL, 0x000fc40000000f00ULL, 0x0001323000007944ULL, 0x00afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000a800377c7811ULL, 0x000fc400078e20ffULL, 0x00000000414c783bULL, 0x000f280000004200ULL,
0x000000004248783bULL, 0x000ee80000004200ULL, 0x00000000433c783bULL, 0x000ea80000004200ULL,
0x000000003638783bULL, 0x00ae620000004200ULL, 0x00000010ff527819ULL, 0x010fc4000001164cULL,
0x000000ff4c507812ULL, 0x040fe400078ec0ffULL, 0x00000018ff477819ULL, 0x004fe4000001164cULL,
0x0000ffff4c8d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff7e7819ULL, 0x100fe4000001164eULL,
0x000000ff4e5e7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff5d7819ULL, 0x000fc4000001164eULL,
0x0000ffff4e8f7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff867819ULL, 0x100fe40000011649ULL,
0x000000ff49627812ULL, 0x040fe400078ec0ffULL, 0x00000018ff617819ULL, 0x000fe40000011649ULL,
0x0000ffff49927812ULL, 0x000fe400078ec0ffULL, 0x00000010ff537819ULL, 0x000fc4000001164dULL,
0x000000ff4d5c7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff517819ULL, 0x000fe4000001164dULL,
0x0000ffff4d8e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff807819ULL, 0x100fe4000001164fULL,
0x000000ff4f5f7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff4e7819ULL, 0x000fc4000001164fULL,
0x0000ffff4f907812ULL, 0x000fe400078ec0ffULL, 0x00000010ff497819ULL, 0x100fe4000001163fULL,
0x000000ff3f837812ULL, 0x040fe400078ec0ffULL, 0x00000018ff827819ULL, 0x000fe4000001163fULL,
0x0000ffff3f4c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff857819ULL, 0x000fc40000011648ULL,
0x000000ff48607812ULL, 0x040fe400078ec0ffULL, 0x00000018ff4f7819ULL, 0x000fe40000011648ULL,
0x0000ffff48917812ULL, 0x000fe400078ec0ffULL, 0x00000010ff4d7819ULL, 0x102fe40000011638ULL,
0x000000ff38877812ULL, 0x000fe400078ec0ffULL, 0x00000018ff847819ULL, 0x000fc40000011638ULL,
0x0000ffff383f7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff747819ULL, 0x100fe4000001163cULL,
0x000000ff3c687812ULL, 0x040fe400078ec0ffULL, 0x00000018ff677819ULL, 0x000fe4000001163cULL,
0x0000ffff3c787812ULL, 0x000fe400078ec0ffULL, 0x00000010ff727819ULL, 0x000fc4000001163eULL,
0x000000ff3e817812ULL, 0x040fe400078ec0ffULL, 0x00000018ff7f7819ULL, 0x000fe4000001163eULL,
0x0000ffff3e487812ULL, 0x000fe400078ec0ffULL, 0x00000018ff387819ULL, 0x100fe40000011639ULL,
0x00000010ff3e7819ULL, 0x000fe40000011639ULL, 0x000000ff398a7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff393c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff6f7819ULL, 0x100fe4000001163dULL,
0x000000ff3d697812ULL, 0x040fe400078ec0ffULL, 0x00000018ff7d7819ULL, 0x000fe4000001163dULL,
0x0000ffff3d6e7812ULL, 0x000fe400078ec0ffULL, 0x00000051ff77723eULL, 0x000fc400020006ffULL,
0x00000018ff397819ULL, 0x100fe4000001163aULL, 0x00000010ff3d7819ULL, 0x000fe2000001163aULL,
0x20000077ff777230ULL, 0x000fe20000004100ULL, 0x000000ff3a8b7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff3a517812ULL, 0x000fe400078ec0ffULL, 0x0000005eff5e723eULL, 0x000fe400020006ffULL,
0x00000018ff3a7819ULL, 0x000fc4000001163bULL, 0x00000038ff38723eULL, 0x000fe200020006ffULL,
0x2000005eff757230ULL, 0x000fe20000004100ULL, 0x00000050ff79723eULL, 0x000fe400020006ffULL,
0x00000047ff73723eULL, 0x000fe200020006ffULL, 0x20000038ff5e7230ULL, 0x000fe20000004100ULL,
0x00000039ff39723eULL, 0x000fe200020006ffULL, 0x20000079ff797230ULL, 0x000fe20000004100ULL,
0x00000010ff507819ULL, 0x000fe2000001163bULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x000000ff3b8c7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff3b477812ULL, 0x000fe400078ec0ffULL,
0x000000ff4b667812ULL, 0x000fe400078ec0ffULL, 0x0000003aff3b723eULL, 0x000fe400020006ffULL,
0x000000ff53537812ULL, 0x000fe400078ec0ffULL, 0x000000ff52387812ULL, 0x000fe200078ec0ffULL,
0x20000039ff527230ULL, 0x000fe20000004100ULL, 0x00000066ff66723eULL, 0x000fc400020006ffULL,
0x00000053ff3a723eULL, 0x000fe200020006ffULL, 0x2000003bff537230ULL, 0x000fe20000004100ULL,
0x00000008ff397819ULL, 0x000fe2000001168dULL, 0x20000066ff6a7230ULL, 0x000fe20000004100ULL,
0x00000038ff38723eULL, 0x000fe400020006ffULL, 0x00000008ff3b7819ULL, 0x000fe4000001168eULL,
0x00000010ff897819ULL, 0x100fe4000001164bULL, 0x00000018ff657819ULL, 0x000fc4000001164bULL,
0x0000ffff4b7b7812ULL, 0x000fe400078ec0ffULL, 0x00000039ff39723eULL, 0x000fe400020006ffULL,
0x00000062ff4b723eULL, 0x000fe400020006ffULL, 0x000000ff4a647812ULL, 0x000fe400078ec0ffULL,
0x00000018ff637819ULL, 0x000fe2000001164aULL, 0x2000004bff4b7230ULL, 0x000fe20000004100ULL,
0x0000007dff66723eULL, 0x000fe200020006ffULL, 0x20000038ff7d7230ULL, 0x000fe20000004100ULL,
0x0000007fff62723eULL, 0x000fe200020006ffULL, 0x2000003aff7f7230ULL, 0x000fe20000004100ULL,
0x0000003bff3b723eULL, 0x000fe200020006ffULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x000000ff80807812ULL, 0x000fe200078ec0ffULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x0000004eff4e723eULL, 0x000fc400020006ffULL, 0x0000004fff4f723eULL, 0x000fe400020006ffULL,
0x000000ff7e387812ULL, 0x000fe200078ec0ffULL, 0x20000039ff7e7230ULL, 0x000fe20000004100ULL,
0x00000008ff3a7819ULL, 0x000fe2000001168fULL, 0x2000004eff717230ULL, 0x000fe20000004100ULL,
0x0000005fff5f723eULL, 0x000fe200020006ffULL, 0x2000004fff6c7230ULL, 0x000fe20000004100ULL,
0x00000064ff64723eULL, 0x000fe400020006ffULL, 0x00000063ff63723eULL, 0x000fe200020006ffULL,
0x2000005fff767230ULL, 0x000fe20000004100ULL, 0x00000065ff65723eULL, 0x000fe200020006ffULL,
0x20000064ff6b7230ULL, 0x000fe20000004100ULL, 0x00000080ff39723eULL, 0x000fe200020006ffULL,
0x2000003bff807230ULL, 0x000fe20000004100ULL, 0x00000038ff38723eULL, 0x000fc400020006ffULL,
0x0000003aff3a723eULL, 0x000fe400020006ffULL, 0x00000008ff3b7819ULL, 0x000fe40000011690ULL,
0x00000068ff4f723eULL, 0x000fe200020006ffULL, 0x20000063ff687230ULL, 0x000fe20000004100ULL,
0x00000069ff4e723eULL, 0x000fe200020006ffULL, 0x20000065ff697230ULL, 0x000fe20000004100ULL,
0x00000081ff65723eULL, 0x000fe200020006ffULL, 0x20000038ff817230ULL, 0x000fe20000004100ULL,
0x00000083ff64723eULL, 0x000fe200020006ffULL, 0x20000039ff837230ULL, 0x000fe20000004100ULL,
0x00000082ff63723eULL, 0x000fe200020006ffULL, 0x2000003aff827230ULL, 0x000fe20000004100ULL,
0x00000084ff5f723eULL, 0x000fe200020006ffULL, 0x2000004fff4f7230ULL, 0x000fe20000004100ULL,
0x0000003bff84723eULL, 0x000fe200020006ffULL, 0x2000004eff4e7230ULL, 0x000fe20000004100ULL,
0x000000007c38783bULL, 0x000e620000000200ULL, 0x00000010ff887819ULL, 0x000fe2000001164aULL,
0x20000065ff657230ULL, 0x000fe20000004100ULL, 0x0000ffff4a937812ULL, 0x000fe200078ec0ffULL,
0x20000084ff847230ULL, 0x000fe20000004100ULL, 0x0000005dff5d723eULL, 0x000fe200020006ffULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x00000060ff4a723eULL, 0x000fe200020006ffULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x0000008aff60723eULL, 0x000fe200020006ffULL,
0x2000005dff707230ULL, 0x000fe20000004100ULL, 0x000000ff898a7812ULL, 0x000fe200078ec0ffULL,
0x2000004aff4a7230ULL, 0x000fe20000004100ULL, 0x000000ff74747812ULL, 0x000fe200078ec0ffULL,
0x20000060ff607230ULL, 0x000fe20000004100ULL, 0x00000008ff897819ULL, 0x000fe20000011693ULL,
0x2000005fff5f7230ULL, 0x000fe20000004100ULL, 0x00000008ff787819ULL, 0x000fc40000011678ULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x0000008cff5d723eULL, 0x000fe400020006ffULL,
0x00000074ff74723eULL, 0x000fe200020006ffULL, 0x2000005cff7a7230ULL, 0x000fe20000004100ULL,
0x00000089ff89723eULL, 0x000fe200020006ffULL, 0x2000005dff5d7230ULL, 0x000fe20000004100ULL,
0x00000078ff8c723eULL, 0x000fe400020006ffULL, 0x000000ff6f6f7812ULL, 0x000fe200078ec0ffULL,
0x20000089ff787230ULL, 0x000fe20000004100ULL, 0x0000008bff5c723eULL, 0x000fe200020006ffULL,
0x20000074ff8b7230ULL, 0x000fe20000004100ULL, 0x0000006fff89723eULL, 0x000fe200020006ffULL,
0x2000008cff747230ULL, 0x000fe20000004100ULL, 0x00000008ff8c7819ULL, 0x000fe2000001166eULL,
0x2000005cff5c7230ULL, 0x000fe20000004100ULL, 0x00000010ff6e7819ULL, 0x000fe20000011679ULL,
0x20000089ff797230ULL, 0x000fe20000004100ULL, 0x00000010ff6f7819ULL, 0x000fe2000001167aULL,
0x0000002c3838a231ULL, 0x082fe200003400ffULL, 0x00000010ff7d7819ULL, 0x000fe2000001167dULL,
0x0000002c3a3aa231ULL, 0x000fe200003400ffULL, 0x00000010ff7f7819ULL, 0x000fe2000001167fULL,
0x0000002d3939a231ULL, 0x080fe200003400ffULL, 0x000010547d6e7816ULL, 0x000fe2000000006eULL,
0x0000002d3b3ba231ULL, 0x000fe200003400ffULL, 0x000010547f6f7816ULL, 0x000fc4000000006fULL,
0x000000ff727a7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff737819ULL, 0x000fe40000011673ULL,
0x00000010ff727819ULL, 0x000fe2000001167eULL, 0x0000006e3808723cULL, 0x000be20000041808ULL,
0x00000010ff777819ULL, 0x000fe40000011677ULL, 0x00000010ff807819ULL, 0x000fe40000011680ULL,
0x000000ff85857812ULL, 0x000fc400078ec0ffULL, 0x000000ff86867812ULL, 0x000fe400078ec0ffULL,
0x0000105473727816ULL, 0x000fe40000000072ULL, 0x00000010ff757819ULL, 0x000fe40000011675ULL,
0x00000010ff6f7819ULL, 0x020fe40000011676ULL, 0x00000010ff817819ULL, 0x000fe40000011681ULL,
0x00000010ff837819ULL, 0x000fc40000011683ULL, 0x0000105477737816ULL, 0x000fe40000000080ULL,
0x000000ff49497812ULL, 0x000fe400078ec0ffULL, 0x00000085ff85723eULL, 0x000fe400020006ffULL,
0x00000086ff86723eULL, 0x000fe200020006ffULL, 0x000000723804723cULL, 0x000b620000041804ULL,
0x00001054816e7816ULL, 0x000fe20000000075ULL, 0x20000085ff857230ULL, 0x000fe20000004100ULL,
0x00001054836f7816ULL, 0x000fe2000000006fULL, 0x20000086ff867230ULL, 0x000fe20000004100ULL,
0x00000049ff76723eULL, 0x000fc400020006ffULL, 0x00000008ff487819ULL, 0x000fe40000011648ULL,
0x00000010ff707819ULL, 0x000fe20000011670ULL, 0x0000006e3818723cULL, 0x000be20000041818ULL,
0x00000010ff717819ULL, 0x000fe20000011671ULL, 0x20000076ff767230ULL, 0x000fe20000004100ULL,
0x00000010ff827819ULL, 0x000fe40000011682ULL, 0x00000010ff497819ULL, 0x000fe40000011684ULL,
0x00000048ff72723eULL, 0x020fc400020006ffULL, 0x0000105470487816ULL, 0x000fe40000000082ULL,
0x0000105471497816ULL, 0x000fe20000000049ULL, 0x20000072ff727230ULL, 0x000fe20000004100ULL,
0x00000010ff4a7819ULL, 0x000fe4000001164aULL, 0x00000010ff4b7819ULL, 0x000fe4000001164bULL,
0x00000010ff857819ULL, 0x000fe40000011685ULL, 0x00000010ff6f7819ULL, 0x000fc40000011686ULL,
0x0000a80040707811ULL, 0x000fe400078e20ffULL, 0x00001054856e7816ULL, 0x000fe4000000004aULL,
0x000010546f6f7816ULL, 0x000fe4000000004bULL, 0x000000483848723cULL, 0x040be20000041810ULL,
0x00000061ff61723eULL, 0x000fe200020006ffULL, 0x000000007010783bULL, 0x0202a20000000200ULL,
0x00000008ff7c7819ULL, 0x000fe40000011691ULL, 0x000000ff88887812ULL, 0x000fe200078ec0ffULL,
0x20000061ff6d7230ULL, 0x000fe20000004100ULL, 0x00000087ff61723eULL, 0x000fe200020006ffULL,
0x0000006e380c723cULL, 0x000b62000004180cULL, 0x00000008ff877819ULL, 0x000fc40000011692ULL,
0x00000008ff7b7819ULL, 0x000fe2000001167bULL, 0x20000061ff617230ULL, 0x000fe20000004100ULL,
0x0000008aff8a723eULL, 0x000fe400020006ffULL, 0x00000087ff87723eULL, 0x000fe400020006ffULL,
0x0000007cff7c723eULL, 0x000fe200020006ffULL, 0x2000008aff8a7230ULL, 0x000fe20000004100ULL,
0x00000088ff88723eULL, 0x000fe200020006ffULL, 0x20000087ff877230ULL, 0x000fe20000004100ULL,
0x0000007bff7b723eULL, 0x000fe200020006ffULL, 0x2000007cff7c7230ULL, 0x000fe20000004100ULL,
0x000000ff4d4d7812ULL, 0x000fe200078ec0ffULL, 0x20000088ff887230ULL, 0x000fe20000004100ULL,
0x00000008ff707819ULL, 0x002fe2000001164cULL, 0x2000007bff7b7230ULL, 0x000fe20000004100ULL,
0x0000004dff4d723eULL, 0x000fc400020006ffULL, 0x00000010ff4c7819ULL, 0x000fe4000001166dULL,
0x00000010ff6a7819ULL, 0x000fe2000001166aULL, 0x2000004dff6e7230ULL, 0x020fe20000004100ULL,
0x00000010ff897819ULL, 0x000fe4000001168aULL, 0x00000010ff6d7819ULL, 0x000fe40000011687ULL,
0x000000ff3e3e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff6c7819ULL, 0x000fc4000001166cULL,
0x00000010ff7c7819ULL, 0x000fe2000001167cULL, 0x0000002c1010a231ULL, 0x084fe200003400ffULL,
0x00000010ff6b7819ULL, 0x000fe2000001166bULL, 0x0000002c1212a231ULL, 0x000fe200003400ffULL,
0x00000010ff887819ULL, 0x000fe20000011688ULL, 0x0000002d1111a231ULL, 0x080fe200003400ffULL,
0x00000008ff3f7819ULL, 0x000fe2000001163fULL, 0x0000002d1313a231ULL, 0x000fe200003400ffULL,
0x00000010ff687819ULL, 0x000fe40000011668ULL, 0x00000010ff697819ULL, 0x000fc40000011669ULL,
0x00000010ff787819ULL, 0x000fe40000011678ULL, 0x00000010ff4d7819ULL, 0x000fe4000001167bULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x0000008cff8c723eULL, 0x000fe400020006ffULL,
0x0000105489897816ULL, 0x000fe2000000006aULL, 0x20000067ff677230ULL, 0x000fe20000004100ULL,
0x000010544c6d7816ULL, 0x000fe2000000006dULL, 0x2000008cff8c7230ULL, 0x000fe20000004100ULL,
0x0000003eff6a723eULL, 0x000fc400020006ffULL, 0x000010546c6c7816ULL, 0x000fe4000000007cULL,
0x0000105488887816ULL, 0x000fe2000000006bULL, 0x2000006aff6a7230ULL, 0x000fe20000004100ULL,
0x0000003fff3e723eULL, 0x000fe400020006ffULL, 0x00001054684c7816ULL, 0x000fe20000000078ULL,
0x0000006c3854723cULL, 0x000f620000041854ULL, 0x00001054694d7816ULL, 0x000fe2000000004dULL,
0x2000003eff687230ULL, 0x000fe20000004100ULL, 0x00000010ff4f7819ULL, 0x000fc4000001164fULL,
0x00000010ff8b7819ULL, 0x000fe4000001168bULL, 0x00000010ff3f7819ULL, 0x000fe2000001164eULL,
0x000000883858723cULL, 0x040f620000041858ULL, 0x000010548b3e7816ULL, 0x000fe4000000004fULL,
0x00000010ff677819ULL, 0x000fe40000011667ULL, 0x00000010ff667819ULL, 0x000fe40000011666ULL,
0x00000010ff747819ULL, 0x000fe20000011674ULL, 0x0000004c384c723cULL, 0x000b620000041814ULL,
0x00000010ff797819ULL, 0x000fc40000011679ULL, 0x00000008ff3c7819ULL, 0x000fe4000001163cULL,
0x000000ff3d3d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff397819ULL, 0x020fe4000001168cULL,
0x0000105467387816ULL, 0x000fe40000000074ULL, 0x0000105466397816ULL, 0x000fe40000000039ULL,
0x000000ff50507812ULL, 0x000fc400078ec0ffULL, 0x00001054793f7816ULL, 0x000fe4000000003fULL,
0x00000008ff517819ULL, 0x000fe20000011651ULL, 0x000000381038723cULL, 0x000b620000041804ULL,
0x00000008ff477819ULL, 0x000fe40000011647ULL, 0x00000010ff617819ULL, 0x000fe40000011661ULL,
0x00000010ff6e7819ULL, 0x000fe4000001166eULL, 0x00000010ff057819ULL, 0x020fc40000011660ULL,
0x00000010ff6a7819ULL, 0x000fe4000001166aULL, 0x0000007aff7a723eULL, 0x000fe400020006ffULL,
0x00000070ff70723eULL, 0x000fe400020006ffULL, 0x0000003cff14723eULL, 0x000fe200020006ffULL,
0x2000007aff7a7230ULL, 0x000fe20000004100ULL, 0x0000003dff15723eULL, 0x000fe200020006ffULL,
0x20000070ff707230ULL, 0x000fe20000004100ULL, 0x00000050ff50723eULL, 0x000fe200020006ffULL,
0x0000003e103c723cULL, 0x000b620000041808ULL, 0x00000051ff51723eULL, 0x000fc400020006ffULL,
0x00000047ff47723eULL, 0x000fe200020006ffULL, 0x20000050ff507230ULL, 0x000fe20000004100ULL,
0x000010546e047816ULL, 0x000fe20000000061ULL, 0x20000051ff517230ULL, 0x000fe20000004100ULL,
0x000010546a057816ULL, 0x000fe20000000005ULL, 0x20000014ff087230ULL, 0x020fe20000004100ULL,
0x00000010ff657819ULL, 0x000fe20000011665ULL, 0x20000015ff0a7230ULL, 0x000fe20000004100ULL,
0x00000010ff647819ULL, 0x000fe20000011664ULL, 0x20000047ff477230ULL, 0x000fe20000004100ULL,
0x00000010ff7a7819ULL, 0x000fe2000001167aULL, 0x000000041004723cULL, 0x000b62000004180cULL,
0x00000010ff767819ULL, 0x000fc40000011676ULL, 0x00000010ff627819ULL, 0x000fe40000011662ULL,
0x00000010ff637819ULL, 0x000fe40000011663ULL, 0x00000010ff727819ULL, 0x000fe40000011672ULL,
0x00000010ff157819ULL, 0x000fe40000011670ULL, 0x00000010ff5f7819ULL, 0x000fe4000001165fULL,
0x00000010ff687819ULL, 0x000fc40000011668ULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x00000010ff097819ULL, 0x000fe40000011608ULL, 0x00000010ff5c7819ULL, 0x000fe4000001165cULL,
0x00000010ff0a7819ULL, 0x000fe4000001160aULL, 0x00000010ff0d7819ULL, 0x020fe4000001165dULL,
0x00000010ff507819ULL, 0x000fc40000011650ULL, 0x00000010ff527819ULL, 0x000fe40000011652ULL,
0x00000010ff517819ULL, 0x000fe40000011651ULL, 0x00000010ff537819ULL, 0x000fe40000011653ULL,
0x00000010ff477819ULL, 0x000fe40000011647ULL, 0x000010547a7a7816ULL, 0x000fe40000000065ULL,
0x00001054767b7816ULL, 0x000fc40000000064ULL, 0x0000105462147816ULL, 0x000fe40000000072ULL,
0x0000105463157816ULL, 0x000fe40000000015ULL, 0x000010545f087816ULL, 0x000fe20000000068ULL,
0x0000007a1018723cULL, 0x000b620000041818ULL, 0x000010545e097816ULL, 0x000fe40000000009ULL,
0x000010540a0c7816ULL, 0x000fe4000000005cULL, 0x00001054500d7816ULL, 0x000fc4000000000dULL,
0x0000105452527816ULL, 0x000fe20000000051ULL, 0x000000141014723cULL, 0x000b620000041848ULL,
0x0000105453537816ULL, 0x000fce0000000047ULL, 0x000000081008723cULL, 0x040b700000041854ULL,
0x0000000c100c723cULL, 0x040b700000041858ULL, 0x000000521010723cULL, 0x000b62000004184cULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff487f8cULL, 0x020e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000004035477810ULL, 0x000fe20007ffe0ffULL, 0x01069000ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff4e7224ULL, 0x002fe200078e0049ULL, 0x0000000124247810ULL, 0x000fc40007ffe0ffULL,
0x0000001c4700720cULL, 0x000fda0003f06070ULL, 0x0000a41000000947ULL, 0x000fea0003800000ULL,
0x0000000000487805ULL, 0x000fc40000015200ULL, 0x0106bc00ff247984ULL, 0x000e640000000800ULL,
0x8000000024ff7812ULL, 0x002fe4000780484eULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000004a7805ULL, 0x000fcc0000015200ULL,
0x0000004a48477210ULL, 0x000fca0007f1e1ffULL, 0x000000014b4a7824ULL, 0x000fe200000e0e49ULL,
0x003d09004700780cULL, 0x000fc80003f06070ULL, 0x000000ff4a00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404700780cULL, 0x000fc80003f06070ULL,
0x000000ff4a00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff247819ULL, 0x000fc8000001144aULL, 0x0000004724247211ULL, 0x000fca00078110ffULL,
0x000000ffff477224ULL, 0x000fca00000e064aULL, 0x0000000224247819ULL, 0x000fc80000001247ULL,
0x000000240000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000014c4c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106bc00ff247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fe4000780484eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000046000009947ULL, 0x000fea0003800000ULL,
0x0000006035247810ULL, 0x000fe20007ffe0ffULL, 0x000000011f487824ULL, 0x000fe200078e022eULL,
0x000000022e4a7810ULL, 0x000fe40007ffe0ffULL, 0x000000241c477217ULL, 0x000fe20007800000ULL,
0x0000000148497824ULL, 0x000fe200078e0203ULL, 0x000000042e4c7810ULL, 0x000fe20007ffe0ffULL,
0x0000001048527824ULL, 0x000fe200078e00ffULL, 0x000000062e557810ULL, 0x000fe20007ffe0ffULL,
0x0000000147477824ULL, 0x000fe200078e0a24ULL, 0x0000002000247811ULL, 0x000fe200078e38ffULL,
0x000000011f4b7824ULL, 0x040fe200078e024cULL, 0xfffffff052527812ULL, 0x000fe200078ee249ULL,
0x000000011f497824ULL, 0x040fe200078e024aULL, 0x000000471f477217ULL, 0x040fe20007800000ULL,
0x000000011f4e7824ULL, 0x000fe200078e0255ULL, 0x000000f026517812ULL, 0x000fe200078ec0ffULL,
0x0000000148507824ULL, 0x100fe200078e0224ULL, 0x0000e00052527811ULL, 0x000fe200078e20ffULL,
0x00000001494f7824ULL, 0x000fc400078e0224ULL, 0x0000000149487824ULL, 0x140fe200078e0203ULL,
0x0000004550507210ULL, 0x080fe20007f1e0ffULL, 0x0000001049537824ULL, 0x000fe200078e00ffULL,
0x000000454f4f7210ULL, 0x080fe20007f5e0ffULL, 0x000000014b4d7824ULL, 0x100fe400078e0224ULL,
0x000000014e567824ULL, 0x040fe200078e0224ULL, 0xfffffff053537812ULL, 0x000fe200078ee248ULL,
0x000000014b497824ULL, 0x100fe200078e0203ULL, 0x000000454d4d7210ULL, 0x000fe20007f7e0ffULL,
0x000000104b547824ULL, 0x000fe200078e00ffULL, 0x0000e00053537811ULL, 0x000fe200078e20ffULL,
0x000000014e247824ULL, 0x040fe200078e0203ULL, 0x00005e004d4b7a11ULL, 0x000fe200078a40ffULL,
0x000000104e577824ULL, 0x000fe200078e00ffULL, 0xfffffff054547812ULL, 0x000fe200078ee249ULL,
0x000000ffff497224ULL, 0x000fe200000e06ffULL, 0x00005e0050487a11ULL, 0x000fe200078040ffULL,
0x0000000147477824ULL, 0x000fe200078e0a1fULL, 0xfffffff057577812ULL, 0x000fe200078ee224ULL,
0x000000ffff247224ULL, 0x000fe200010e06ffULL, 0x00005e004f4e7a11ULL, 0x000fc400078440ffULL,
0x00005f0050507a11ULL, 0x000fe200000f4449ULL, 0x000000ffff497224ULL, 0x000fe200018e06ffULL,
0x00005f004f4f7a11ULL, 0x000fe400010f4424ULL, 0x0000004556247210ULL, 0x000fe40007fde0ffULL,
0x000000472e00720cULL, 0x080fe40003f46070ULL, 0x000000474a00720cULL, 0x000fe20003f06070ULL,
0x000000ffff4a7224ULL, 0x000fe200030e06ffULL, 0x0000005148487210ULL, 0x000fc40007f9e0ffULL,
0x000000474c00720cULL, 0x080fe40003f66070ULL, 0x00005f004d4d7a11ULL, 0x000fe200028f4449ULL,
0x000000ffff497224ULL, 0x000fe200020e0650ULL, 0x00005e00244c7a11ULL, 0x040fe400078a40ffULL,
0x000000475500720cULL, 0x000fe40003f86070ULL, 0x00005f0024247a11ULL, 0x000fe200028f444aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000048527faeULL, 0x0003e2000d101c46ULL,
0x000000514e4a7210ULL, 0x000fc40007fbe0ffULL, 0x0000e00054547811ULL, 0x000fe400078e20ffULL,
0x0000e00057577811ULL, 0x000fe400078e20ffULL, 0x000000514b487210ULL, 0x082fe20007f5e0ffULL,
0x000000ffff4b7224ULL, 0x000fe200028e064fULL, 0x000000514c4c7210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff497224ULL, 0x000fe200010e064dULL, 0x000000004a537faeULL, 0x0003e2000c101c46ULL,
0x000000ffff4d7224ULL, 0x000fc600028e0624ULL, 0x0000000048547faeULL, 0x0003e8000d901c46ULL,
0x000000004c577faeULL, 0x0003e2000e101c46ULL, 0x0000039000007947ULL, 0x000fea0003800000ULL,
0x000000011f247824ULL, 0x000fe200078e022eULL, 0x0000002000487811ULL, 0x000fe400078e38ffULL,
0x000000f026517812ULL, 0x000fe200078ec0ffULL, 0x0000000124497824ULL, 0x040fe200078e0203ULL,
0x00000002244a7810ULL, 0x040fe20007ffe0ffULL, 0x0000001024527824ULL, 0x040fe200078e00ffULL,
0x00000004244c7810ULL, 0x040fe20007ffe0ffULL, 0x0000000124477824ULL, 0x040fe200078e0248ULL,
0x00000006244e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000148247824ULL, 0x000fe200078e024aULL,
0xfffffff052527812ULL, 0x000fe200078ee249ULL, 0x000000014a4b7824ULL, 0x040fe200078e0203ULL,
0x0000004547497210ULL, 0x000fe20007f1e0ffULL, 0x000000104a537824ULL, 0x000fe200078e00ffULL,
0x0000e00052527811ULL, 0x000fe200078e20ffULL, 0x0000000148477824ULL, 0x000fc400078e024cULL,
0x000000014c4d7824ULL, 0x040fe200078e0203ULL, 0xfffffff053537812ULL, 0x000fe200078ee24bULL,
0x000000104c547824ULL, 0x000fe200078e00ffULL, 0x0000004745477210ULL, 0x000fe20007f5e0ffULL,
0x0000000148487824ULL, 0x000fe200078e024eULL, 0x0000e00053537811ULL, 0x000fe200078e20ffULL,
0x000000014e4c7824ULL, 0x000fe200078e0203ULL, 0xfffffff054547812ULL, 0x000fe200078ee24dULL,
0x000000104e557824ULL, 0x000fe200078e00ffULL, 0x0000004845487210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff4a7224ULL, 0x000fe200000e06ffULL, 0x00005e00494e7a11ULL, 0x000fc400078040ffULL,
0xfffffff055557812ULL, 0x000fe400078ee24cULL, 0x00005f0049507a11ULL, 0x000fe200000f444aULL,
0x000000ffff497224ULL, 0x000fe200010e06ffULL, 0x00000024454d7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff247224ULL, 0x000fe200018e06ffULL, 0x00005e00484c7a11ULL, 0x000fe400078640ffULL,
0x00005e00474a7a11ULL, 0x000fe200078440ffULL, 0x000000ffff4f7224ULL, 0x000fe200000e06ffULL,
0x00005e004d4b7a11ULL, 0x000fc400078040ffULL, 0x000000514e4e7210ULL, 0x080fe40007f9e0ffULL,
0x00005f004d4d7a11ULL, 0x000fe400000f444fULL, 0x00005f0048247a11ULL, 0x000fe200018f4424ULL,
0x000000ffff4f7224ULL, 0x000fe200020e0650ULL, 0x00005f0047477a11ULL, 0x000fe400010f4449ULL,
0x000000514b487210ULL, 0x080fe40007f1e0ffULL, 0x000000514a4a7210ULL, 0x080fe20007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000004e527faeULL, 0x0003e2000b901c46ULL,
0x000000514c4c7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff497224ULL, 0x000fe200000e064dULL,
0x0000e00054547811ULL, 0x000fe200078e20ffULL, 0x000000ffff4b7224ULL, 0x000fe200010e0647ULL,
0x0000e00055557811ULL, 0x000fe200078e20ffULL, 0x000000ffff4d7224ULL, 0x000fe200018e0624ULL,
0x0000000048537faeULL, 0x0003e8000b901c46ULL, 0x000000004a547faeULL, 0x0003e8000b901c46ULL,
0x000000004c557faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b000ff5c7f8cULL, 0x000ea2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010648001f4c7f8cULL, 0x0022e4000c80043fULL,
0x0000000000487805ULL, 0x000fc40000015200ULL, 0x01064c001f247984ULL, 0x000f240000000800ULL,
0x8000000024ff7812ULL, 0x018fc4000780484dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000004a7805ULL, 0x000fcc0000015200ULL,
0x0000004a48477210ULL, 0x000fca0007f1e1ffULL, 0x000000014b4a7824ULL, 0x000fe200000e0e49ULL,
0x003d09004700780cULL, 0x000fc80003f06070ULL, 0x000000ff4a00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404700780cULL, 0x000fc80003f06070ULL,
0x000000ff4a00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff247819ULL, 0x000fc8000001144aULL, 0x0000004724247211ULL, 0x000fca00078110ffULL,
0x000000ffff477224ULL, 0x000fca00000e064aULL, 0x0000000224247819ULL, 0x000fc80000001247ULL,
0x000000240000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000014e4e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01064c001f247984ULL, 0x000ee40000000800ULL, 0x8000000024ff7812ULL, 0x008fe4000780484dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0101000027247984ULL, 0x000ee80000000800ULL,
0x01030000274a7984ULL, 0x0002a20000000800ULL, 0x000000462400720bULL, 0x008fe20003f1d000ULL,
0x000103327f007947ULL, 0x000fd8000b800000ULL, 0x00000000004b7806ULL, 0x002fc800000e0100ULL,
0x0000ffff4bff7812ULL, 0x000fe2000780c0ffULL, 0x0000047000007945ULL, 0x000fe20003800000ULL,
0x00000001ff477424ULL, 0x000fd600078e00ffULL, 0x0000044000008947ULL, 0x000fea0003800000ULL,
0x000000020200780cULL, 0x000fe40003f05270ULL, 0x000000462400720bULL, 0x000fe20003f54000ULL,
0x000103027f007947ULL, 0x000fd8000b800000ULL, 0x00000000004c7806ULL, 0x000fc400010e0100ULL,
0x0000002446478209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe80003800000ULL,
0x0105004727008388ULL, 0x0003e40000000800ULL, 0x000099104c477816ULL, 0x002fc800000000ffULL,
0x000000ff4700720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000002446477209ULL, 0x000fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff4cff7812ULL, 0x000fc6000780c0ffULL, 0x8000004746477221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b47477820ULL, 0x000fc80000410000ULL, 0x00000047004d7308ULL, 0x000e640000000800ULL,
0x0000004d21217220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff477819ULL, 0x000fe20000011603ULL, 0x000102427f007947ULL, 0x000fea000b800000ULL,
0x00001f474d477589ULL, 0x0002e400000e0000ULL, 0x000000473c3c7220ULL, 0x08cfe20000410000ULL,
0x000000473d3d7220ULL, 0x080fe20000410000ULL, 0x0000004738387220ULL, 0x080fe20000410000ULL,
0x0000004739397220ULL, 0x080fe20000410000ULL, 0x0000004718187220ULL, 0x080fe20000410000ULL,
0x0000004719197220ULL, 0x080fe20000410000ULL, 0x0000004714147220ULL, 0x080fe20000410000ULL,
0x0000004715157220ULL, 0x080fe20000410000ULL, 0x0000004704047220ULL, 0x080fe20000410000ULL,
0x0000004705057220ULL, 0x080fe20000410000ULL, 0x0000004708087220ULL, 0x080fe20000410000ULL,
0x0000004709097220ULL, 0x080fe20000410000ULL, 0x000000470c0c7220ULL, 0x080fe20000410000ULL,
0x000000470d0d7220ULL, 0x080fe20000410000ULL, 0x0000004710107220ULL, 0x080fe20000410000ULL,
0x0000004711117220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff004cff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000803477811ULL, 0x000fe200078ff0ffULL, 0x000101227f007947ULL, 0x000fea000b800000ULL,
0x00001f474d477589ULL, 0x00066400000e0000ULL, 0x000000473e3e7220ULL, 0x086fe20000410000ULL,
0x000000473f3f7220ULL, 0x080fe20000410000ULL, 0x000000473a3a7220ULL, 0x080fe20000410000ULL,
0x000000473b3b7220ULL, 0x080fe20000410000ULL, 0x000000471a1a7220ULL, 0x080fe20000410000ULL,
0x000000471b1b7220ULL, 0x080fe20000410000ULL, 0x0000004716167220ULL, 0x080fe20000410000ULL,
0x0000004717177220ULL, 0x080fe20000410000ULL, 0x0000004706067220ULL, 0x080fe20000410000ULL,
0x0000004707077220ULL, 0x080fe20000410000ULL, 0x000000470a0a7220ULL, 0x080fe20000410000ULL,
0x000000470b0b7220ULL, 0x080fe20000410000ULL, 0x000000470e0e7220ULL, 0x080fe20000410000ULL,
0x000000470f0f7220ULL, 0x080fe20000410000ULL, 0x0000004712127220ULL, 0x080fe20000410000ULL,
0x0000004713137220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000ffff4cff7812ULL, 0x000fe2000780084bULL, 0x00000001ff477424ULL, 0x000fe200078e00ffULL,
0x0000002446467209ULL, 0x000fd60007810000ULL, 0x8000004624240221ULL, 0x000fe20000010000ULL,
0x00007610ff470816ULL, 0x000fc60000000047ULL, 0x3fb8aa3b24240820ULL, 0x000fc80000410000ULL,
0x00000024002b0308ULL, 0x000f240000000800ULL, 0x0000002b4a4a0220ULL, 0x014fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000214a217221ULL, 0x004fc20000010000ULL,
0x0000000000487805ULL, 0x000fcc0000015200ULL, 0x0106ac00ff247984ULL, 0x000ea40000000800ULL,
0x8000000024ff7812ULL, 0x004fe40007804844ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000004a7805ULL, 0x000fcc0000015200ULL,
0x0000004a484a7210ULL, 0x000fca0007f1e1ffULL, 0x000000014b4b7824ULL, 0x000fe200000e0e49ULL,
0x003d09004a00780cULL, 0x000fc80003f06070ULL, 0x000000ff4b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404a00780cULL, 0x000fc80003f06070ULL,
0x000000ff4b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff247819ULL, 0x000fc8000001144bULL, 0x0000004a24247211ULL, 0x000fca00078110ffULL,
0x000000ffff4a7224ULL, 0x000fca00000e064bULL, 0x0000000224247819ULL, 0x000fc8000000124aULL,
0x000000240000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000014c4c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106ac00ff247984ULL, 0x000ea40000000800ULL, 0x8000000024ff7812ULL, 0x004fe40007804844ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991047247816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff2400720cULL, 0x000fda0003f45270ULL,
0x0000012000002947ULL, 0x000fea0003800000ULL, 0x0000002bff24723eULL, 0x000fe400000010ffULL,
0x00000002ff447819ULL, 0x000fe40000011603ULL, 0x0000541024247816ULL, 0x000fe20000000024ULL,
0x0000fcf27f007947ULL, 0x000fea000b800000ULL, 0x00001f44242c7589ULL, 0x00046400000e0000ULL,
0x00000008442d7810ULL, 0x000fe20007ffe0ffULL, 0x0000fd227f007947ULL, 0x000fea000b800000ULL,
0x00001f2d242d7589ULL, 0x0004e400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001044477810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff497224ULL, 0x000fe200078e0024ULL,
0x0000cf8000487802ULL, 0x000fc40000000f00ULL, 0x0001057000007944ULL, 0x00efea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001844477810ULL, 0x004fe20007ffe0ffULL,
0x000000ffff497224ULL, 0x000fe200078e0024ULL, 0x0000cfd000487802ULL, 0x000fc40000000f00ULL,
0x0001052000007944ULL, 0x00afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000002f54783bULL, 0x000f280000004200ULL,
0x00000000314c783bULL, 0x00ae680000004200ULL, 0x000000003050783bULL, 0x000ee80000004200ULL,
0x000000003348783bULL, 0x000ea20000004200ULL, 0x00000010ff637819ULL, 0x010fc40000011654ULL,
0x000000ff54247812ULL, 0x044fe400078ec0ffULL, 0x00000018ff5a7819ULL, 0x000fe40000011654ULL,
0x0000ffff548e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff7b7819ULL, 0x100fe40000011655ULL,
0x000000ff555b7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff547819ULL, 0x000fc40000011655ULL,
0x0000ffff558f7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff557819ULL, 0x000fe40000011656ULL,
0x000000ff4c6d7812ULL, 0x002fe400078ec0ffULL, 0x000000ff4d6f7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff6e7819ULL, 0x000fe4000001164dULL, 0x00000010ff857819ULL, 0x008fc40000011651ULL,
0x000000ff51677812ULL, 0x040fe400078ec0ffULL, 0x00000018ff667819ULL, 0x000fe40000011651ULL,
0x0000ffff51937812ULL, 0x000fe400078ec0ffULL, 0x00000055ff55723eULL, 0x000fe400020006ffULL,
0x00000010ff517819ULL, 0x100fe40000011648ULL, 0x000000ff48867812ULL, 0x000fe200078ec0ffULL,
0x20000055ff707230ULL, 0x000fe20000004100ULL, 0x00000018ff837819ULL, 0x000fc40000011648ULL,
0x0000ffff48597812ULL, 0x000fe400078ec0ffULL, 0x00000010ff587819ULL, 0x100fe40000011649ULL,
0x000000ff49897812ULL, 0x040fe400078ec0ffULL, 0x00000018ff887819ULL, 0x000fe40000011649ULL,
0x0000ffff495f7812ULL, 0x000fe400078ec0ffULL, 0x0000006dff6d723eULL, 0x000fc400020006ffULL,
0x000000ff52697812ULL, 0x000fe400078ec0ffULL, 0x0000006fff48723eULL, 0x000fe200020006ffULL,
0x2000006dff6f7230ULL, 0x000fe20000004100ULL, 0x0000006eff49723eULL, 0x000fe400020006ffULL,
0x00000018ff7c7819ULL, 0x000fe2000001164eULL, 0x20000048ff6e7230ULL, 0x000fe20000004100ULL,
0x00000010ff607819ULL, 0x000fe2000001164aULL, 0x20000049ff6d7230ULL, 0x000fe20000004100ULL,
0x000000ff4a8c7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff8b7819ULL, 0x000fe4000001164aULL,
0x0000ffff4a477812ULL, 0x000fe400078ec0ffULL, 0x00000018ff4a7819ULL, 0x000fe4000001164bULL,
0x000000ff63637812ULL, 0x000fe400078ec0ffULL, 0x000000ff7b7b7812ULL, 0x000fe400078ec0ffULL,
0x0000005bff5b723eULL, 0x000fc400020006ffULL, 0x00000069ff55723eULL, 0x000fe400020006ffULL,
0x00000024ff78723eULL, 0x000fe200020006ffULL, 0x2000005bff7d7230ULL, 0x000fe20000004100ULL,
0x0000007cff69723eULL, 0x000fe200020006ffULL, 0x20000055ff557230ULL, 0x000fe20000004100ULL,
0x00000018ff6a7819ULL, 0x000fe20000011653ULL, 0x20000078ff787230ULL, 0x000fe20000004100ULL,
0x00000010ff447819ULL, 0x000fe2000001164bULL, 0x20000069ff697230ULL, 0x000fe20000004100ULL,
0x000000ff4b8d7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff4b247812ULL, 0x000fe400078ec0ffULL,
0x00000008ff497819ULL, 0x000fe4000001168eULL, 0x0000004aff7c723eULL, 0x000fe400020006ffULL,
0x00000063ff48723eULL, 0x000fe400020006ffULL, 0x000000ff4e7e7812ULL, 0x000fe200078ec0ffULL,
0x2000007cff637230ULL, 0x000fe20000004100ULL, 0x0000007bff4a723eULL, 0x000fe200020006ffULL,
0x20000048ff7b7230ULL, 0x000fe20000004100ULL, 0x00000008ff4b7819ULL, 0x000fc4000001168fULL,
0x00000010ff7f7819ULL, 0x000fe40000011656ULL, 0x0000ffff56907812ULL, 0x000fe400078ec0ffULL,
0x00000010ff807819ULL, 0x000fe40000011657ULL, 0x0000006aff5b723eULL, 0x000fe400020006ffULL,
0x00000049ff49723eULL, 0x000fe400020006ffULL, 0x0000007eff6a723eULL, 0x000fe200020006ffULL,
0x2000004aff7e7230ULL, 0x000fe20000004100ULL, 0x0000004bff4b723eULL, 0x000fe200020006ffULL,
0x20000049ff7c7230ULL, 0x000fe20000004100ULL, 0x000000ff7f487812ULL, 0x000fe200078ec0ffULL,
0x2000005bff5b7230ULL, 0x000fe20000004100ULL, 0x000000ff80807812ULL, 0x000fe200078ec0ffULL,
0x2000004bff7f7230ULL, 0x000fe20000004100ULL, 0x00000008ff4a7819ULL, 0x000fe20000011690ULL,
0x2000006aff6a7230ULL, 0x000fe20000004100ULL, 0x0000005aff5a723eULL, 0x000fc400020006ffULL,
0x00000054ff54723eULL, 0x000fe400020006ffULL, 0x00000018ff687819ULL, 0x000fe20000011652ULL,
0x2000005aff767230ULL, 0x000fe20000004100ULL, 0x000000ff536b7812ULL, 0x000fe200078ec0ffULL,
0x20000054ff777230ULL, 0x000fe20000004100ULL, 0x00000048ff49723eULL, 0x000fe400020006ffULL,
0x000000ff4f827812ULL, 0x000fe400078ec0ffULL, 0x00000018ff817819ULL, 0x000fc4000001164fULL,
0x00000080ff4b723eULL, 0x000fe200020006ffULL, 0x20000049ff807230ULL, 0x000fe20000004100ULL,
0x0000004aff4a723eULL, 0x000fe400020006ffULL, 0x0000b00034487811ULL, 0x000fe400078e20ffULL,
0x0000006bff54723eULL, 0x000fe400020006ffULL, 0x00000068ff5a723eULL, 0x000fe400020006ffULL,
0x00000082ff6b723eULL, 0x000fe200020006ffULL, 0x2000004bff827230ULL, 0x000fe20000004100ULL,
0x00000081ff68723eULL, 0x000fe200020006ffULL, 0x2000004aff817230ULL, 0x000fe20000004100ULL,
0x0000ffff50927812ULL, 0x000fe200078ec0ffULL, 0x000000004848783bULL, 0x000e620000000200ULL,
0x00000010ff8a7819ULL, 0x000fe20000011653ULL, 0x20000054ff547230ULL, 0x000fe20000004100ULL,
0x0000ffff537a7812ULL, 0x000fe200078ec0ffULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x00000066ff53723eULL, 0x000fe200020006ffULL, 0x2000006bff6b7230ULL, 0x000fe20000004100ULL,
0x00000086ff66723eULL, 0x000fe200020006ffULL, 0x20000068ff687230ULL, 0x000fe20000004100ULL,
0x000000ff85867812ULL, 0x000fe200078ec0ffULL, 0x20000053ff537230ULL, 0x000fe20000004100ULL,
0x00000008ff857819ULL, 0x000fe20000011692ULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x000000ff565e7812ULL, 0x000fc400078ec0ffULL, 0x000000ff57627812ULL, 0x040fe400078ec0ffULL,
0x00000018ff617819ULL, 0x000fe40000011657ULL, 0x0000ffff57917812ULL, 0x000fe400078ec0ffULL,
0x00000010ff877819ULL, 0x000fe40000011652ULL, 0x00000086ff86723eULL, 0x000fe400020006ffULL,
0x00000010ff577819ULL, 0x000fc4000001164dULL, 0x0000ffff4d567812ULL, 0x000fe400078ec0ffULL,
0x00000085ff85723eULL, 0x000fe400020006ffULL, 0x00000010ff737819ULL, 0x000fe4000001164cULL,
0x00000067ff4d723eULL, 0x000fe400020006ffULL, 0x0000ffff52947812ULL, 0x000fe400078ec0ffULL,
0x0000ffff4c797812ULL, 0x000fe200078ec0ffULL, 0x2000004dff4d7230ULL, 0x000fe20000004100ULL,
0x00000089ff67723eULL, 0x000fe200020006ffULL, 0x0000002c4848a231ULL, 0x082fe200003400ffULL,
0x00000062ff62723eULL, 0x000fe200020006ffULL, 0x0000002c4a4aa231ULL, 0x000fe200003400ffULL,
0x000000ff87897812ULL, 0x000fe200078ec0ffULL, 0x20000086ff877230ULL, 0x000fe20000004100ULL,
0x000000ff73737812ULL, 0x000fe200078ec0ffULL, 0x20000085ff867230ULL, 0x000fe20000004100ULL,
0x00000008ff857819ULL, 0x000fe20000011694ULL, 0x20000062ff757230ULL, 0x000fe20000004100ULL,
0x00000008ff797819ULL, 0x000fe20000011679ULL, 0x0000002d4949a231ULL, 0x080fe200003400ffULL,
0x0000005eff5e723eULL, 0x000fe200020006ffULL, 0x0000002d4b4ba231ULL, 0x000fe200003400ffULL,
0x0000008cff62723eULL, 0x000fe200020006ffULL, 0x20000067ff677230ULL, 0x000fe20000004100ULL,
0x00000073ff73723eULL, 0x000fe200020006ffULL, 0x2000005eff747230ULL, 0x000fe20000004100ULL,
0x00000085ff85723eULL, 0x000fe200020006ffULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x00000079ff8c723eULL, 0x000fc400020006ffULL, 0x00000018ff647819ULL, 0x000fe20000011650ULL,
0x20000085ff797230ULL, 0x000fe20000004100ULL, 0x000000ff57577812ULL, 0x000fe400078ec0ffULL,
0x0000008bff5e723eULL, 0x000fe200020006ffULL, 0x20000073ff8b7230ULL, 0x000fe20000004100ULL,
0x00000064ff52723eULL, 0x000fe200020006ffULL, 0x2000008cff737230ULL, 0x000fe20000004100ULL,
0x00000083ff64723eULL, 0x000fe200020006ffULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x00000057ff85723eULL, 0x000fe200020006ffULL, 0x20000052ff527230ULL, 0x000fe20000004100ULL,
0x00000008ff8c7819ULL, 0x000fe20000011656ULL, 0x20000064ff647230ULL, 0x000fe20000004100ULL,
0x00000008ff837819ULL, 0x000fc40000011691ULL, 0x00000010ff567819ULL, 0x000fe20000011678ULL,
0x20000085ff787230ULL, 0x000fe20000004100ULL, 0x00000010ff577819ULL, 0x000fe4000001167dULL,
0x00000010ff7b7819ULL, 0x000fe4000001167bULL, 0x00000010ff7e7819ULL, 0x000fe4000001167eULL,
0x00000010ff847819ULL, 0x000fe40000011650ULL, 0x00000010ff727819ULL, 0x000fc4000001164eULL,
0x00000018ff6c7819ULL, 0x000fe4000001164cULL, 0x00000061ff61723eULL, 0x000fe400020006ffULL,
0x00000010ff4c7819ULL, 0x000fe4000001164fULL, 0x00000083ff83723eULL, 0x000fe200020006ffULL,
0x20000061ff717230ULL, 0x000fe20000004100ULL, 0x000010547b567816ULL, 0x000fe40000000056ULL,
0x000010547e577816ULL, 0x000fe20000000057ULL, 0x20000083ff837230ULL, 0x000fe20000004100ULL,
0x000000ff50657812ULL, 0x000fc400078ec0ffULL, 0x000000ff84847812ULL, 0x000fe400078ec0ffULL,
0x000000ff727b7812ULL, 0x000fe200078ec0ffULL, 0x00000056483c723cULL, 0x000b62000004183cULL,
0x00000010ff727819ULL, 0x000fe40000011677ULL, 0x00000010ff767819ULL, 0x000fe40000011676ULL,
0x00000010ff7c7819ULL, 0x000fe4000001167cULL, 0x00000010ff777819ULL, 0x000fc4000001167fULL,
0x000000ff4c4c7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff4f507812ULL, 0x000fe400078ec0ffULL,
0x00000065ff4f723eULL, 0x000fe400020006ffULL, 0x00000084ff84723eULL, 0x000fe400020006ffULL,
0x0000ffff4e4e7812ULL, 0x000fe200078ec0ffULL, 0x2000004fff4f7230ULL, 0x000fe20000004100ULL,
0x0000105476767816ULL, 0x000fe2000000007cULL, 0x20000084ff847230ULL, 0x000fe20000004100ULL,
0x0000105472777816ULL, 0x000fc40000000077ULL, 0x0000004cff56723eULL, 0x020fe400020006ffULL,
0x00000010ff4c7819ULL, 0x000fe40000011671ULL, 0x00000010ff707819ULL, 0x000fe20000011670ULL,
0x000000764838723cULL, 0x000b620000041838ULL, 0x00000010ff817819ULL, 0x000fe40000011681ULL,
0x00000010ff717819ULL, 0x000fe40000011683ULL, 0x00000008ff4e7819ULL, 0x000fc4000001164eULL,
0x00000088ff65723eULL, 0x000fe200020006ffULL, 0x20000056ff767230ULL, 0x020fe20000004100ULL,
0x00000008ff887819ULL, 0x000fe40000011693ULL, 0x0000105470707816ULL, 0x000fe20000000081ULL,
0x20000065ff657230ULL, 0x000fe20000004100ULL, 0x000010544c717816ULL, 0x000fe40000000071ULL,
0x0000004eff4e723eULL, 0x000fe400020006ffULL, 0x00000010ff4f7819ULL, 0x000fc4000001164fULL,
0x00000010ff4d7819ULL, 0x000fe2000001164dULL, 0x2000004eff727230ULL, 0x000fe20000004100ULL,
0x00000010ff847819ULL, 0x000fe40000011684ULL, 0x00000010ff857819ULL, 0x000fe40000011687ULL,
0x0000b00032567811ULL, 0x000fe400078e20ffULL, 0x00000088ff88723eULL, 0x000fe400020006ffULL,
0x000000ff8a8a7812ULL, 0x000fc400078ec0ffULL, 0x0000105484847816ULL, 0x000fe2000000004fULL,
0x20000088ff887230ULL, 0x000fe20000004100ULL, 0x0000105485857816ULL, 0x000fe4000000004dULL,
0x00000008ff7a7819ULL, 0x000fe2000001167aULL, 0x00000070484c723cULL, 0x000be20000041814ULL,
0x00000089ff89723eULL, 0x000fe200020006ffULL, 0x000000005614783bULL, 0x0202a20000000200ULL,
0x0000008aff8a723eULL, 0x000fe400020006ffULL, 0x0000007aff7a723eULL, 0x000fe200020006ffULL,
0x20000089ff897230ULL, 0x000fe20000004100ULL, 0x00000008ff507819ULL, 0x000fe20000011650ULL,
0x2000008aff8a7230ULL, 0x000fe20000004100ULL, 0x000000ff51517812ULL, 0x000fe200078ec0ffULL,
0x2000007aff7a7230ULL, 0x000fe20000004100ULL, 0x00000010ff527819ULL, 0x000fc40000011652ULL,
0x00000010ff537819ULL, 0x000fe40000011653ULL, 0x00000010ff867819ULL, 0x000fe40000011686ULL,
0x00000010ff577819ULL, 0x000fe40000011688ULL, 0x00000050ff70723eULL, 0x000fe400020006ffULL,
0x00000051ff71723eULL, 0x000fe400020006ffULL, 0x0000105452567816ULL, 0x002fe20000000086ULL,
0x20000070ff707230ULL, 0x000fe20000004100ULL, 0x0000105453577816ULL, 0x000fe20000000057ULL,
0x20000071ff717230ULL, 0x000fe20000004100ULL, 0x000000844850723cULL, 0x000be20000041804ULL,
0x00000010ff747819ULL, 0x000fc40000011674ULL, 0x00000010ff757819ULL, 0x000fe40000011675ULL,
0x00000010ff807819ULL, 0x000fe40000011680ULL, 0x00000010ff827819ULL, 0x000fe40000011682ULL,
0x00000010ff557819ULL, 0x000fe40000011655ULL, 0x00000010ff057819ULL, 0x020fe40000011654ULL,
0x00000010ff897819ULL, 0x000fc40000011689ULL, 0x00000010ff8a7819ULL, 0x000fe2000001168aULL,
0x0000002c1414a231ULL, 0x084fe200003400ffULL, 0x00000010ff5a7819ULL, 0x000fe2000001165aULL,
0x0000002c1616a231ULL, 0x000fe200003400ffULL, 0x00000010ff5b7819ULL, 0x000fe2000001165bULL,
0x0000002d1515a231ULL, 0x080fe200003400ffULL, 0x00000010ff797819ULL, 0x000fe20000011679ULL,
0x0000002d1717a231ULL, 0x000fe200003400ffULL, 0x00000010ff077819ULL, 0x000fe4000001167aULL,
0x0000105480747816ULL, 0x000fc40000000074ULL, 0x0000105482757816ULL, 0x000fe40000000075ULL,
0x0000105489047816ULL, 0x000fe40000000055ULL, 0x000010548a057816ULL, 0x000fe20000000005ULL,
0x000000564854723cULL, 0x000be20000041808ULL, 0x000010545a067816ULL, 0x000fe40000000079ULL,
0x000010545b077816ULL, 0x000fe40000000007ULL, 0x000000ff58587812ULL, 0x000fc400078ec0ffULL,
0x00000008ff597819ULL, 0x000fe20000011659ULL, 0x000000744818723cULL, 0x040f620000041818ULL,
0x00000008ff5f7819ULL, 0x000fe4000001165fULL, 0x00000058ff0a723eULL, 0x020fe400020006ffULL,
0x00000059ff08723eULL, 0x000fe400020006ffULL, 0x000000ff60607812ULL, 0x000fe200078ec0ffULL,
0x000000044858723cULL, 0x000b62000004180cULL, 0x0000005fff5f723eULL, 0x000fc400020006ffULL,
0x000000ff44447812ULL, 0x000fe400078ec0ffULL, 0x00000008ff477819ULL, 0x000fe20000011647ULL,
0x2000005fff5f7230ULL, 0x000fe20000004100ULL, 0x00000008ff247819ULL, 0x000fe20000011624ULL,
0x000000064848723cULL, 0x000b620000041810ULL, 0x0000006cff6c723eULL, 0x000fe200020006ffULL,
0x2000000aff0c7230ULL, 0x020fe20000004100ULL, 0x0000008dff61723eULL, 0x000fe200020006ffULL,
0x20000008ff0e7230ULL, 0x000fe20000004100ULL, 0x0000008cff8c723eULL, 0x000fe200020006ffULL,
0x2000006cff6c7230ULL, 0x000fe20000004100ULL, 0x0000007bff7b723eULL, 0x000fe200020006ffULL,
0x20000061ff617230ULL, 0x000fe20000004100ULL, 0x00000060ff60723eULL, 0x000fe200020006ffULL,
0x2000008cff8c7230ULL, 0x000fe20000004100ULL, 0x00000044ff44723eULL, 0x000fe200020006ffULL,
0x2000007bff7b7230ULL, 0x000fe20000004100ULL, 0x00000047ff47723eULL, 0x000fe200020006ffULL,
0x20000060ff607230ULL, 0x000fe20000004100ULL, 0x00000024ff24723eULL, 0x000fe200020006ffULL,
0x20000044ff447230ULL, 0x000fe20000004100ULL, 0x00000010ff657819ULL, 0x000fe20000011665ULL,
0x20000047ff477230ULL, 0x000fe20000004100ULL, 0x00000010ff5f7819ULL, 0x000fe2000001165fULL,
0x20000024ff247230ULL, 0x000fe20000004100ULL, 0x00000010ff6f7819ULL, 0x000fc4000001166fULL,
0x00000010ff097819ULL, 0x000fe4000001166eULL, 0x00000010ff8b7819ULL, 0x000fe4000001168bULL,
0x00000010ff787819ULL, 0x000fe40000011678ULL, 0x00000010ff6c7819ULL, 0x000fe4000001166cULL,
0x00000010ff6d7819ULL, 0x000fe4000001166dULL, 0x00000010ff737819ULL, 0x000fc40000011673ULL,
0x00000010ff057819ULL, 0x000fe4000001168cULL, 0x00000010ff6a7819ULL, 0x000fe4000001166aULL,
0x00000010ff6b7819ULL, 0x000fe4000001166bULL, 0x00000010ff7b7819ULL, 0x000fe4000001167bULL,
0x00000010ff767819ULL, 0x000fe40000011676ULL, 0x00000010ff697819ULL, 0x000fc40000011669ULL,
0x00000010ff687819ULL, 0x000fe40000011668ULL, 0x00000010ff727819ULL, 0x000fe40000011672ULL,
0x00000010ff117819ULL, 0x000fe40000011670ULL, 0x00000010ff667819ULL, 0x000fe40000011666ULL,
0x00000010ff0d7819ULL, 0x000fe40000011667ULL, 0x00000010ff717819ULL, 0x000fc40000011671ULL,
0x00000010ff0f7819ULL, 0x000fe4000001160cULL, 0x00000010ff647819ULL, 0x000fe40000011664ULL,
0x00000010ff0e7819ULL, 0x000fe4000001160eULL, 0x0000105465657816ULL, 0x000fe4000000005fULL,
0x00000010ff627819ULL, 0x000fe40000011662ULL, 0x00000010ff607819ULL, 0x000fc40000011660ULL,
0x00000010ff617819ULL, 0x000fe40000011661ULL, 0x00000010ff447819ULL, 0x000fe40000011644ULL,
0x00000010ff5e7819ULL, 0x000fe4000001165eULL, 0x00000010ff477819ULL, 0x000fe40000011647ULL,
0x00000010ff5f7819ULL, 0x000fe40000011663ULL, 0x00000010ff247819ULL, 0x000fc40000011624ULL,
0x000010548b087816ULL, 0x000fe4000000006fULL, 0x0000105478097816ULL, 0x000fe40000000009ULL,
0x000010546c047816ULL, 0x000fe40000000073ULL, 0x000010546d057816ULL, 0x000fe40000000005ULL,
0x000010547b6a7816ULL, 0x000fe2000000006aULL, 0x000000081408723cULL, 0x000b62000004183cULL,
0x00001054766b7816ULL, 0x000fc4000000006bULL, 0x0000105469107816ULL, 0x000fe40000000072ULL,
0x0000105468117816ULL, 0x000fe40000000011ULL, 0x00001054710c7816ULL, 0x000fe20000000066ULL,
0x000000041404723cULL, 0x000b620000041838ULL, 0x000010540f0d7816ULL, 0x000fe4000000000dULL,
0x0000105464647816ULL, 0x000fe4000000000eULL, 0x0000105460607816ULL, 0x000fc40000000062ULL,
0x0000105444617816ULL, 0x000fe20000000061ULL, 0x0000006a1418723cULL, 0x000b620000041818ULL,
0x000010545e5e7816ULL, 0x000fe40000000047ULL, 0x000010545f5f7816ULL, 0x000fca0000000024ULL,
0x000000101410723cULL, 0x040b70000004184cULL, 0x0000000c140c723cULL, 0x040b700000041850ULL,
0x000000641454723cULL, 0x040b700000041854ULL, 0x000000601458723cULL, 0x040b700000041858ULL,
0x0000005e1414723cULL, 0x000b620000041848ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff3c7f8cULL, 0x020e62000c80043fULL, 0x000000ffff3e7224ULL, 0x000fce00078e00ffULL,
0x0000000000387805ULL, 0x000fc40000015200ULL, 0x0106bc00ff247984ULL, 0x000ea40000000800ULL,
0x8000000024ff7812ULL, 0x006fc4000780483dULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383a7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003a00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403a00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff247819ULL, 0x000fc8000001143bULL,
0x0000003a24247211ULL, 0x000fca00078110ffULL, 0x000000ffff3a7224ULL, 0x000fca00000e063bULL,
0x0000000224247819ULL, 0x000fc8000000123aULL, 0x000000240000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106bc00ff247984ULL, 0x000e640000000800ULL,
0x8000000024ff7812ULL, 0x002fe4000780483dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000046000009947ULL, 0x000fea0003800000ULL, 0x000000011f397824ULL, 0x000fe200078e022eULL,
0x0000008035387810ULL, 0x000fe40007ffe0ffULL, 0x0000004000447811ULL, 0x000fe200078e38ffULL,
0x0000000139247824ULL, 0x140fe200078e0203ULL, 0x000000022e3a7810ULL, 0x040fe20007ffe0ffULL,
0x0000001039487824ULL, 0x040fe200078e00ffULL, 0x000000042e4a7810ULL, 0x000fe20007ffe0ffULL,
0x00000001393d7824ULL, 0x000fe200078e0244ULL, 0x000000f026477812ULL, 0x000fe200078ec0ffULL,
0x000000011f3b7824ULL, 0x040fe200078e023aULL, 0xfffffff048487812ULL, 0x000fe200078ee224ULL,
0x000000011f3e7824ULL, 0x000fe200078e024aULL, 0x000000381c247217ULL, 0x000fe20007800000ULL,
0x000000013b3c7824ULL, 0x100fe200078e0203ULL, 0x000000453d3d7210ULL, 0x080fe20007f1e0ffULL,
0x000000103b497824ULL, 0x040fe200078e00ffULL, 0x000000062e4c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000124247824ULL, 0x000fe200078e0a38ULL, 0x0000c00048487811ULL, 0x000fe200078e20ffULL,
0x000000013b3f7824ULL, 0x000fe200078e0244ULL, 0xfffffff049497812ULL, 0x000fe200078ee23cULL,
0x000000ffff387224ULL, 0x000fe200000e06ffULL, 0x000000241f247217ULL, 0x000fe20007800000ULL,
0x000000013e3c7824ULL, 0x040fe200078e0203ULL, 0x00005e003d397a11ULL, 0x000fe200078040ffULL,
0x000000103e4b7824ULL, 0x000fe200078e00ffULL, 0x000000453f3f7210ULL, 0x000fe20007f7e0ffULL,
0x0000000124247824ULL, 0x000fe200078e0a1fULL, 0x00005f003d3d7a11ULL, 0x000fe200000f4438ULL,
0x000000013e3e7824ULL, 0x000fe200078e0244ULL, 0xfffffff04b4b7812ULL, 0x000fe200078ee23cULL,
0x000000ffff387224ULL, 0x000fe200018e06ffULL, 0x00005e003f3c7a11ULL, 0x000fe200078640ffULL,
0x000000011f4d7824ULL, 0x000fe200078e024cULL, 0x000000242e00720cULL, 0x000fc40003f86070ULL,
0x00005f003f3f7a11ULL, 0x000fe200018f4438ULL, 0x000000014d447824ULL, 0x000fe200078e0244ULL,
0x000000453e3e7210ULL, 0x000fe40007fbe0ffULL, 0x0000004739387210ULL, 0x000fe40007f7e0ffULL,
0x000000243a00720cULL, 0x080fe20003f06070ULL, 0x000000ffff3b7224ULL, 0x000fe200028e06ffULL,
0x00005e003e3a7a11ULL, 0x000fe200078a40ffULL, 0x000000ffff397224ULL, 0x000fe200018e063dULL,
0x000000244a00720cULL, 0x000fc40003f66070ULL, 0x00005f003e3e7a11ULL, 0x000fe400028f443bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000038487faeULL, 0x0003e2000e101c46ULL,
0x00000045443b7210ULL, 0x000fe20007f9e0ffULL, 0x000000014d447824ULL, 0x040fe200078e0203ULL,
0x000000473a3a7210ULL, 0x000fe20007fde0ffULL, 0x000000104d4d7824ULL, 0x000fe200078e00ffULL,
0x0000c00049497811ULL, 0x000fe200078e20ffULL, 0x000000ffff3d7224ULL, 0x000fe200020e06ffULL,
0x0000c0004b4b7811ULL, 0x000fe400078e20ffULL, 0xfffffff04d447812ULL, 0x000fc400078ee244ULL,
0x000000473c387210ULL, 0x082fe40007fbe0ffULL, 0x00005e003b3c7a11ULL, 0x040fe400078840ffULL,
0x0000c00044447811ULL, 0x000fe200078e20ffULL, 0x000000ffff397224ULL, 0x000fe200028e063fULL,
0x000000244c00720cULL, 0x000fe40003fa6070ULL, 0x00005f003b247a11ULL, 0x000fe200020f443dULL,
0x000000ffff3b7224ULL, 0x000fe200030e063eULL, 0x000000473c3c7210ULL, 0x000fe20007f9e0ffULL,
0x0000000038497faeULL, 0x0003e8000c101c46ULL, 0x000000ffff3d7224ULL, 0x000fe200020e0624ULL,
0x000000003a4b7faeULL, 0x0003e8000d901c46ULL, 0x000000003c447faeULL, 0x0003e2000e901c46ULL,
0x0000039000007947ULL, 0x000fea0003800000ULL, 0x0000004000387811ULL, 0x000fe200078e38ffULL,
0x000000011f247824ULL, 0x000fe200078e022eULL, 0x000000f026487812ULL, 0x000fc600078ec0ffULL,
0x00000001243a7824ULL, 0x140fe200078e0203ULL, 0x00000002243b7810ULL, 0x040fe20007ffe0ffULL,
0x0000001024497824ULL, 0x040fe200078e00ffULL, 0x00000004243c7810ULL, 0x040fe20007ffe0ffULL,
0x0000000124397824ULL, 0x140fe200078e0238ULL, 0x0000000624247810ULL, 0x000fe20007ffe0ffULL,
0x000000013b447824ULL, 0x000fe200078e0238ULL, 0xfffffff049497812ULL, 0x000fe200078ee23aULL,
0x000000013b3a7824ULL, 0x000fe200078e0203ULL, 0x0000004539397210ULL, 0x000fe20007f1e0ffULL,
0x000000103b4a7824ULL, 0x000fe200078e00ffULL, 0x0000c00049497811ULL, 0x000fe200078e20ffULL,
0x000000013c3b7824ULL, 0x000fc400078e0238ULL, 0x00000001243d7824ULL, 0x000fe200078e0238ULL,
0xfffffff04a4a7812ULL, 0x000fe200078ee23aULL, 0x000000013c387824ULL, 0x140fe200078e0203ULL,
0x000000453b3b7210ULL, 0x000fe20007f7e0ffULL, 0x000000103c4b7824ULL, 0x000fe200078e00ffULL,
0x0000c0004a4a7811ULL, 0x000fe200078e20ffULL, 0x00000001243c7824ULL, 0x040fe400078e0203ULL,
0x00000010244c7824ULL, 0x000fe200078e00ffULL, 0xfffffff04b4b7812ULL, 0x000fe200078ee238ULL,
0x000000ffff247224ULL, 0x000fe200000e06ffULL, 0x00005e00393e7a11ULL, 0x000fc400078040ffULL,
0xfffffff04c4c7812ULL, 0x000fe400078ee23cULL, 0x00005f0039477a11ULL, 0x000fe200000f4424ULL,
0x000000ffff397224ULL, 0x000fe200018e06ffULL, 0x0000004544447210ULL, 0x080fe40007f1e0ffULL,
0x000000453d247210ULL, 0x000fe40007f9e0ffULL, 0x00005e003b3a7a11ULL, 0x000fe200078640ffULL,
0x000000ffff3f7224ULL, 0x000fe200000e06ffULL, 0x00005e00443d7a11ULL, 0x000fe200078040ffULL,
0x000000ffff387224ULL, 0x000fe200020e06ffULL, 0x00005e00243c7a11ULL, 0x000fc400078840ffULL,
0x000000483e3e7210ULL, 0x080fe40007fbe0ffULL, 0x00005f0044447a11ULL, 0x000fe400000f443fULL,
0x00005f0024247a11ULL, 0x000fe200020f4438ULL, 0x000000ffff3f7224ULL, 0x000fe200028e0647ULL,
0x00005f003b3b7a11ULL, 0x000fe400018f4439ULL, 0x000000483d387210ULL, 0x080fe40007f1e0ffULL,
0x000000483a3a7210ULL, 0x080fe20007f7e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e497faeULL, 0x0003e2000b901c46ULL, 0x000000483c3c7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff397224ULL, 0x000fe200000e0644ULL, 0x0000c0004b4b7811ULL, 0x000fe200078e20ffULL,
0x000000ffff3b7224ULL, 0x000fe200018e063bULL, 0x0000c0004c4c7811ULL, 0x000fe200078e20ffULL,
0x000000ffff3d7224ULL, 0x000fe200020e0624ULL, 0x00000000384a7faeULL, 0x0003e8000b901c46ULL,
0x000000003a4b7faeULL, 0x0003e8000b901c46ULL, 0x000000003c4c7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff387f8cULL, 0x002e64000c80043fULL, 0x000000ffff447224ULL, 0x002fc400078e0039ULL,
0x0000000000387805ULL, 0x000fca0000015200ULL, 0x0106b400ff247984ULL, 0x000e640000000800ULL,
0x8000000024ff7812ULL, 0x002fc4000780485dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383a7210ULL, 0x000fca0007f1e1ffULL, 0x000000013b3b7824ULL, 0x000fe200000e0e39ULL,
0x003d09003a00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403a00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff247819ULL, 0x000fc8000001143bULL, 0x0000003a24247211ULL, 0x000fca00078110ffULL,
0x000000ffff3a7224ULL, 0x000fca00000e063bULL, 0x0000000224247819ULL, 0x000fc8000000123aULL,
0x000000240000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106b400ff247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fe4000780485dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000014000007945ULL, 0x000fe20003800000ULL,
0x0000012000002947ULL, 0x000fea0003800000ULL, 0x0000002bff24723eULL, 0x000fe400000010ffULL,
0x00000002ff387819ULL, 0x000fe40000011603ULL, 0x0000541024247816ULL, 0x000fe20000000024ULL,
0x0000d8f27f007947ULL, 0x000fea000b800000ULL, 0x00001f38242c7589ULL, 0x0002a400000e0000ULL,
0x00000008382d7810ULL, 0x000fe20007ffe0ffULL, 0x0000d9227f007947ULL, 0x000fea000b800000ULL,
0x00001f2d242d7589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001038477810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff497224ULL, 0x000fe200078e0024ULL,
0x0000f44000487802ULL, 0x000fc40000000f00ULL, 0x0000e0b000007944ULL, 0x00efea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001838477810ULL, 0x004fe20007ffe0ffULL,
0x000000ffff497224ULL, 0x000fe200078e0024ULL, 0x0000f49000487802ULL, 0x000fc40000000f00ULL,
0x0000e06000007944ULL, 0x00afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000b000377b7811ULL, 0x000fc400078e20ffULL,
0x00000000414c783bULL, 0x000f280000004200ULL, 0x000000004248783bULL, 0x000ee80000004200ULL,
0x00000000433c783bULL, 0x000ea80000004200ULL, 0x000000003638783bULL, 0x002e620000004200ULL,
0x00000010ff517819ULL, 0x010fc4000001164cULL, 0x000000ff4c477812ULL, 0x044fe400078ec0ffULL,
0x00000018ff247819ULL, 0x008fe4000001164cULL, 0x0000ffff4c8c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff7d7819ULL, 0x100fe4000001164eULL, 0x000000ff4e5d7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff5c7819ULL, 0x000fc4000001164eULL, 0x0000ffff4e8e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff857819ULL, 0x100fe40000011649ULL, 0x000000ff49617812ULL, 0x040fe400078ec0ffULL,
0x00000018ff607819ULL, 0x000fe40000011649ULL, 0x0000ffff49917812ULL, 0x000fe400078ec0ffULL,
0x00000010ff527819ULL, 0x000fc4000001164dULL, 0x000000ff4d537812ULL, 0x040fe400078ec0ffULL,
0x00000018ff507819ULL, 0x000fe4000001164dULL, 0x0000ffff4d8d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff7f7819ULL, 0x100fe4000001164fULL, 0x000000ff4f5e7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff4e7819ULL, 0x000fc4000001164fULL, 0x0000ffff4f8f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff497819ULL, 0x100fe4000001163fULL, 0x000000ff3f827812ULL, 0x040fe400078ec0ffULL,
0x00000018ff817819ULL, 0x000fe4000001163fULL, 0x0000ffff3f4c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff847819ULL, 0x000fc40000011648ULL, 0x000000ff485f7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff4f7819ULL, 0x000fe40000011648ULL, 0x0000ffff48907812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4d7819ULL, 0x102fe40000011638ULL, 0x000000ff38867812ULL, 0x000fe400078ec0ffULL,
0x00000018ff837819ULL, 0x000fc40000011638ULL, 0x0000ffff383f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff727819ULL, 0x100fe4000001163cULL, 0x000000ff3c677812ULL, 0x040fe400078ec0ffULL,
0x00000018ff667819ULL, 0x000fe4000001163cULL, 0x0000ffff3c777812ULL, 0x000fe400078ec0ffULL,
0x00000010ff717819ULL, 0x000fc4000001163eULL, 0x000000ff3e807812ULL, 0x040fe400078ec0ffULL,
0x00000018ff7e7819ULL, 0x000fe4000001163eULL, 0x0000ffff3e487812ULL, 0x000fe400078ec0ffULL,
0x00000018ff387819ULL, 0x100fe40000011639ULL, 0x00000010ff3e7819ULL, 0x000fe40000011639ULL,
0x000000ff39897812ULL, 0x000fc400078ec0ffULL, 0x0000ffff393c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff6f7819ULL, 0x100fe4000001163dULL, 0x000000ff3d687812ULL, 0x040fe400078ec0ffULL,
0x00000018ff7c7819ULL, 0x000fe4000001163dULL, 0x0000ffff3d6e7812ULL, 0x000fe400078ec0ffULL,
0x00000047ff78723eULL, 0x000fc400020006ffULL, 0x00000018ff397819ULL, 0x100fe4000001163aULL,
0x00000010ff3d7819ULL, 0x000fe2000001163aULL, 0x20000078ff787230ULL, 0x000fe20000004100ULL,
0x000000ff3a8a7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff3a477812ULL, 0x000fe400078ec0ffULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x00000018ff3a7819ULL, 0x000fc4000001163bULL,
0x00000038ff38723eULL, 0x000fe200020006ffULL, 0x2000005dff737230ULL, 0x000fe20000004100ULL,
0x00000024ff75723eULL, 0x000fe400020006ffULL, 0x00000050ff76723eULL, 0x000fe200020006ffULL,
0x20000038ff5d7230ULL, 0x000fe20000004100ULL, 0x00000039ff39723eULL, 0x000fe200020006ffULL,
0x20000075ff757230ULL, 0x000fe20000004100ULL, 0x00000010ff507819ULL, 0x000fe2000001163bULL,
0x20000076ff767230ULL, 0x000fe20000004100ULL, 0x000000ff3b8b7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff3b247812ULL, 0x000fe400078ec0ffULL, 0x000000ff4b657812ULL, 0x000fe400078ec0ffULL,
0x0000003aff3b723eULL, 0x000fe400020006ffULL, 0x000000ff52527812ULL, 0x000fe400078ec0ffULL,
0x000000ff51387812ULL, 0x000fe200078ec0ffULL, 0x20000039ff517230ULL, 0x000fe20000004100ULL,
0x00000065ff65723eULL, 0x000fc400020006ffULL, 0x00000052ff3a723eULL, 0x000fe200020006ffULL,
0x2000003bff527230ULL, 0x000fe20000004100ULL, 0x00000008ff397819ULL, 0x000fe2000001168cULL,
0x20000065ff697230ULL, 0x000fe20000004100ULL, 0x00000038ff38723eULL, 0x000fe400020006ffULL,
0x00000008ff3b7819ULL, 0x000fe4000001168dULL, 0x00000010ff887819ULL, 0x100fe4000001164bULL,
0x00000018ff647819ULL, 0x000fc4000001164bULL, 0x0000ffff4b7a7812ULL, 0x000fe400078ec0ffULL,
0x00000039ff39723eULL, 0x000fe400020006ffULL, 0x00000061ff4b723eULL, 0x000fe400020006ffULL,
0x000000ff4a637812ULL, 0x000fe400078ec0ffULL, 0x00000018ff627819ULL, 0x000fe2000001164aULL,
0x2000004bff4b7230ULL, 0x000fe20000004100ULL, 0x0000007cff65723eULL, 0x000fe200020006ffULL,
0x20000038ff7c7230ULL, 0x000fe20000004100ULL, 0x0000007eff61723eULL, 0x000fe200020006ffULL,
0x2000003aff7e7230ULL, 0x000fe20000004100ULL, 0x0000003bff3b723eULL, 0x000fe200020006ffULL,
0x20000065ff657230ULL, 0x000fe20000004100ULL, 0x000000ff7f7f7812ULL, 0x000fe200078ec0ffULL,
0x20000061ff617230ULL, 0x000fe20000004100ULL, 0x0000004eff4e723eULL, 0x000fc400020006ffULL,
0x0000004fff4f723eULL, 0x000fe400020006ffULL, 0x000000ff7d387812ULL, 0x000fe200078ec0ffULL,
0x20000039ff7d7230ULL, 0x000fe20000004100ULL, 0x00000008ff3a7819ULL, 0x000fe2000001168eULL,
0x2000004eff707230ULL, 0x000fe20000004100ULL, 0x0000005eff5e723eULL, 0x000fe200020006ffULL,
0x2000004fff6b7230ULL, 0x000fe20000004100ULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x00000062ff62723eULL, 0x000fe200020006ffULL, 0x2000005eff747230ULL, 0x000fe20000004100ULL,
0x00000064ff64723eULL, 0x000fe200020006ffULL, 0x20000063ff6a7230ULL, 0x000fe20000004100ULL,
0x0000007fff39723eULL, 0x000fe200020006ffULL, 0x2000003bff7f7230ULL, 0x000fe20000004100ULL,
0x00000038ff38723eULL, 0x000fc400020006ffULL, 0x0000003aff3a723eULL, 0x000fe400020006ffULL,
0x00000008ff3b7819ULL, 0x000fe4000001168fULL, 0x00000067ff4f723eULL, 0x000fe200020006ffULL,
0x20000062ff677230ULL, 0x000fe20000004100ULL, 0x00000068ff4e723eULL, 0x000fe200020006ffULL,
0x20000064ff687230ULL, 0x000fe20000004100ULL, 0x00000080ff64723eULL, 0x000fe200020006ffULL,
0x20000038ff807230ULL, 0x000fe20000004100ULL, 0x00000082ff63723eULL, 0x000fe200020006ffULL,
0x2000003aff827230ULL, 0x000fe20000004100ULL, 0x00000081ff62723eULL, 0x000fe200020006ffULL,
0x20000039ff817230ULL, 0x000fe20000004100ULL, 0x00000083ff5e723eULL, 0x000fe200020006ffULL,
0x2000004fff4f7230ULL, 0x000fe20000004100ULL, 0x0000003bff83723eULL, 0x000fe200020006ffULL,
0x2000004eff4e7230ULL, 0x000fe20000004100ULL, 0x000000007b38783bULL, 0x000e620000000200ULL,
0x000000ff72727812ULL, 0x000fe200078ec0ffULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x00000008ff777819ULL, 0x000fe20000011677ULL, 0x20000083ff837230ULL, 0x000fe20000004100ULL,
0x00000053ff53723eULL, 0x000fe200020006ffULL, 0x20000064ff647230ULL, 0x000fe20000004100ULL,
0x0000005cff5c723eULL, 0x000fe200020006ffULL, 0x20000063ff637230ULL, 0x000fe20000004100ULL,
0x00000072ff72723eULL, 0x000fe200020006ffULL, 0x20000053ff797230ULL, 0x000fe20000004100ULL,
0x00000077ff77723eULL, 0x000fe200020006ffULL, 0x2000005cff6d7230ULL, 0x000fe20000004100ULL,
0x000000ff6f6f7812ULL, 0x000fe200078ec0ffULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x0000008aff53723eULL, 0x000fe200020006ffULL, 0x20000072ff8a7230ULL, 0x000fe20000004100ULL,
0x0000008bff5c723eULL, 0x000fe200020006ffULL, 0x20000077ff727230ULL, 0x000fe20000004100ULL,
0x0000006fff77723eULL, 0x000fe200020006ffULL, 0x20000053ff537230ULL, 0x000fe20000004100ULL,
0x00000008ff8b7819ULL, 0x000fe2000001166eULL, 0x2000005cff5c7230ULL, 0x000fe20000004100ULL,
0x00000010ff6e7819ULL, 0x000fe20000011678ULL, 0x20000077ff787230ULL, 0x000fe20000004100ULL,
0x00000010ff6f7819ULL, 0x000fc40000011679ULL, 0x00000010ff7c7819ULL, 0x000fe4000001167cULL,
0x00000010ff7e7819ULL, 0x000fe4000001167eULL, 0x000010547c6e7816ULL, 0x000fe4000000006eULL,
0x000010547e6f7816ULL, 0x000fe4000000006fULL, 0x000000ff84847812ULL, 0x000fe400078ec0ffULL,
0x000000ff85857812ULL, 0x000fc400078ec0ffULL, 0x000000ff49497812ULL, 0x000fe200078ec0ffULL,
0x0000002c3838a231ULL, 0x082fe200003400ffULL, 0x00000010ff877819ULL, 0x000fe2000001164aULL,
0x0000002c3a3aa231ULL, 0x000fe200003400ffULL, 0x0000ffff4a927812ULL, 0x000fe200078ec0ffULL,
0x0000002d3939a231ULL, 0x080fe200003400ffULL, 0x0000005fff4a723eULL, 0x000fe200020006ffULL,
0x0000002d3b3ba231ULL, 0x000fe200003400ffULL, 0x00000084ff84723eULL, 0x000fe400020006ffULL,
0x00000085ff85723eULL, 0x000fe200020006ffULL, 0x2000004aff4a7230ULL, 0x000fe20000004100ULL,
0x00000008ff487819ULL, 0x000fe20000011648ULL, 0x20000084ff847230ULL, 0x000fe20000004100ULL,
0x0000006e3808723cULL, 0x000be20000041808ULL, 0x00000010ff6d7819ULL, 0x000fe2000001166dULL,
0x20000085ff857230ULL, 0x000fe20000004100ULL, 0x00000010ff707819ULL, 0x000fc40000011670ULL,
0x00000010ff827819ULL, 0x000fe40000011682ULL, 0x00000049ff6e723eULL, 0x020fe400020006ffULL,
0x00000010ff497819ULL, 0x000fe40000011683ULL, 0x00000060ff60723eULL, 0x000fe200020006ffULL,
0x2000006eff6f7230ULL, 0x000fe20000004100ULL, 0x00000048ff6e723eULL, 0x000fe400020006ffULL,
0x000010546d487816ULL, 0x000fe20000000082ULL, 0x20000060ff6c7230ULL, 0x000fe20000004100ULL,
0x0000105470497816ULL, 0x000fe20000000049ULL, 0x2000006eff6e7230ULL, 0x000fe20000004100ULL,
0x00000010ff4a7819ULL, 0x000fc4000001164aULL, 0x00000010ff4b7819ULL, 0x000fe4000001164bULL,
0x00000010ff847819ULL, 0x000fe40000011684ULL, 0x00000010ff857819ULL, 0x000fe40000011685ULL,
0x0000b000406d7811ULL, 0x000fe400078e20ffULL, 0x00000086ff60723eULL, 0x000fe400020006ffULL,
0x00000008ff7b7819ULL, 0x000fc40000011690ULL, 0x00000008ff867819ULL, 0x000fe20000011691ULL,
0x20000060ff607230ULL, 0x000fe20000004100ULL, 0x0000105484847816ULL, 0x000fe4000000004aULL,
0x0000105485857816ULL, 0x000fe4000000004bULL, 0x000000483848723cULL, 0x040be20000041810ULL,
0x0000007bff7b723eULL, 0x000fe200020006ffULL, 0x000000006d10783bULL, 0x020e620000000200ULL,
0x00000086ff86723eULL, 0x000fe400020006ffULL, 0x00000089ff5f723eULL, 0x000fe200020006ffULL,
0x2000007bff7b7230ULL, 0x000fe20000004100ULL, 0x000000ff88897812ULL, 0x000fe200078ec0ffULL,
0x20000086ff867230ULL, 0x000fe20000004100ULL, 0x000000ff87877812ULL, 0x000fe200078ec0ffULL,
0x00000084380c723cULL, 0x000fe2000004180cULL, 0x00000008ff887819ULL, 0x000fe20000011692ULL,
0x2000005fff5f7230ULL, 0x000fe20000004100ULL, 0x00000008ff7a7819ULL, 0x000fc4000001167aULL,
0x000000ff71797812ULL, 0x000fe400078ec0ffULL, 0x00000008ff4c7819ULL, 0x000fe4000001164cULL,
0x000000ff4d707812ULL, 0x000fe400078ec0ffULL, 0x00000089ff89723eULL, 0x000fe400020006ffULL,
0x00000010ff757819ULL, 0x000fe40000011675ULL, 0x00000010ff717819ULL, 0x000fe20000011676ULL,
0x20000089ff897230ULL, 0x000fe20000004100ULL, 0x00000010ff7d7819ULL, 0x000fc4000001167dULL,
0x00000010ff777819ULL, 0x000fe4000001167fULL, 0x00000010ff6b7819ULL, 0x000fe4000001166bULL,
0x00000010ff6c7819ULL, 0x000fe4000001166cULL, 0x00000010ff7b7819ULL, 0x000fe4000001167bULL,
0x00000010ff4d7819ULL, 0x000fe40000011686ULL, 0x00000087ff87723eULL, 0x000fc400020006ffULL,
0x00000088ff88723eULL, 0x000fe200020006ffULL, 0x0000002c1010a231ULL, 0x082fe200003400ffULL,
0x0000007aff7a723eULL, 0x000fe200020006ffULL, 0x20000087ff877230ULL, 0x000fe20000004100ULL,
0x0000004cff6d723eULL, 0x000fe200020006ffULL, 0x20000088ff887230ULL, 0x000fe20000004100ULL,
0x0000105475767816ULL, 0x000fe2000000007dULL, 0x2000007aff7a7230ULL, 0x000fe20000004100ULL,
0x0000105471777816ULL, 0x000fe20000000077ULL, 0x0000002c1212a231ULL, 0x000fe200003400ffULL,
0x000010546b4c7816ULL, 0x000fe2000000007bULL, 0x0000002d1111a231ULL, 0x080fe200003400ffULL,
0x000010546c4d7816ULL, 0x000fe2000000004dULL, 0x0000002d1313a231ULL, 0x000fe200003400ffULL,
0x00000010ff697819ULL, 0x000fe20000011669ULL, 0x000000763804723cULL, 0x000f620000041804ULL,
0x00000010ff6b7819ULL, 0x000fe20000011689ULL, 0x2000006dff6d7230ULL, 0x000fe20000004100ULL,
0x000000ff3e3e7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff737819ULL, 0x000fe40000011673ULL,
0x00000010ff747819ULL, 0x000fe20000011674ULL, 0x0000004c3854723cULL, 0x000be20000041854ULL,
0x00000010ff807819ULL, 0x000fe40000011680ULL, 0x00000010ff817819ULL, 0x000fe40000011681ULL,
0x00000010ff6a7819ULL, 0x000fe4000001166aULL, 0x00000010ff877819ULL, 0x000fc40000011687ULL,
0x00000008ff3f7819ULL, 0x000fe4000001163fULL, 0x00000010ff677819ULL, 0x000fe40000011667ULL,
0x00000010ff687819ULL, 0x000fe40000011668ULL, 0x00000010ff887819ULL, 0x000fe40000011688ULL,
0x00000010ff4d7819ULL, 0x020fe4000001167aULL, 0x00000066ff66723eULL, 0x000fc400020006ffULL,
0x0000008bff8b723eULL, 0x000fe400020006ffULL, 0x000010546b6b7816ULL, 0x000fe20000000069ULL,
0x20000066ff667230ULL, 0x000fe20000004100ULL, 0x0000003eff69723eULL, 0x000fe200020006ffULL,
0x2000008bff8b7230ULL, 0x000fe20000004100ULL, 0x0000105480807816ULL, 0x000fe40000000073ULL,
0x0000105481817816ULL, 0x000fe20000000074ULL, 0x20000069ff697230ULL, 0x000fe20000004100ULL,
0x00001054876a7816ULL, 0x000fc4000000006aULL, 0x0000003fff3e723eULL, 0x000fe400020006ffULL,
0x00001054674c7816ULL, 0x000fe20000000088ULL, 0x000000803818723cULL, 0x040f620000041818ULL,
0x00001054684d7816ULL, 0x000fe2000000004dULL, 0x2000003eff677230ULL, 0x000fe20000004100ULL,
0x00000010ff4f7819ULL, 0x000fe4000001164fULL, 0x00000010ff8a7819ULL, 0x000fe4000001168aULL,
0x00000010ff3f7819ULL, 0x000fe2000001164eULL, 0x0000006a3858723cULL, 0x000f620000041858ULL,
0x000010548a3e7816ULL, 0x000fc4000000004fULL, 0x00000010ff787819ULL, 0x000fe40000011678ULL,
0x00000010ff667819ULL, 0x000fe40000011666ULL, 0x00000010ff657819ULL, 0x000fe20000011665ULL,
0x0000004c384c723cULL, 0x000b620000041814ULL, 0x00000010ff727819ULL, 0x000fe40000011672ULL,
0x00000070ff70723eULL, 0x000fe400020006ffULL, 0x000000ff3d3d7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff397819ULL, 0x020fe2000001168bULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x00001054783f7816ULL, 0x000fe4000000003fULL, 0x0000105466387816ULL, 0x000fe40000000072ULL,
0x0000105465397816ULL, 0x000fe40000000039ULL, 0x00000008ff3c7819ULL, 0x000fe4000001163cULL,
0x0000003dff15723eULL, 0x000fc400020006ffULL, 0x0000003cff14723eULL, 0x000fe200020006ffULL,
0x000000381038723cULL, 0x040b620000041804ULL, 0x000000ff50507812ULL, 0x000fe400078ec0ffULL,
0x00000008ff477819ULL, 0x000fe40000011647ULL, 0x00000008ff247819ULL, 0x000fe40000011624ULL,
0x00000010ff607819ULL, 0x000fe20000011660ULL, 0x0000003e103c723cULL, 0x000b640000041808ULL,
0x00000010ff057819ULL, 0x020fc4000001165fULL, 0x00000010ff707819ULL, 0x000fe40000011670ULL,
0x00000010ff697819ULL, 0x000fe20000011669ULL, 0x20000015ff0a7230ULL, 0x000fe20000004100ULL,
0x00000010ff617819ULL, 0x000fe20000011661ULL, 0x20000014ff087230ULL, 0x000fe20000004100ULL,
0x00000010ff627819ULL, 0x000fe40000011662ULL, 0x00000010ff6e7819ULL, 0x000fe4000001166eULL,
0x00000010ff157819ULL, 0x000fc4000001166dULL, 0x00000079ff79723eULL, 0x000fe400020006ffULL,
0x00000050ff50723eULL, 0x000fe400020006ffULL, 0x00000047ff47723eULL, 0x000fe200020006ffULL,
0x20000079ff797230ULL, 0x000fe20000004100ULL, 0x00000024ff24723eULL, 0x000fe200020006ffULL,
0x20000050ff507230ULL, 0x000fe20000004100ULL, 0x0000105470047816ULL, 0x000fe20000000060ULL,
0x20000047ff477230ULL, 0x000fe20000004100ULL, 0x0000105469057816ULL, 0x000fe20000000005ULL,
0x20000024ff247230ULL, 0x000fe20000004100ULL, 0x0000105461147816ULL, 0x000fc4000000006eULL,
0x0000105462157816ULL, 0x000fe40000000015ULL, 0x00000010ff647819ULL, 0x000fe20000011664ULL,
0x000000041004723cULL, 0x040b62000004180cULL, 0x00000010ff637819ULL, 0x000fe40000011663ULL,
0x00000010ff797819ULL, 0x000fe40000011679ULL, 0x00000010ff657819ULL, 0x000fe4000001166fULL,
0x00000010ff5e7819ULL, 0x000fe2000001165eULL, 0x000000141014723cULL, 0x000b620000041848ULL,
0x00000010ff677819ULL, 0x000fc40000011667ULL, 0x00000010ff5d7819ULL, 0x000fe4000001165dULL,
0x00000010ff097819ULL, 0x000fe40000011608ULL, 0x00000010ff537819ULL, 0x000fe40000011653ULL,
0x00000010ff0a7819ULL, 0x000fe4000001160aULL, 0x00000010ff0d7819ULL, 0x020fe4000001165cULL,
0x00000010ff507819ULL, 0x000fc40000011650ULL, 0x00000010ff517819ULL, 0x000fe40000011651ULL,
0x00000010ff477819ULL, 0x000fe40000011647ULL, 0x00000010ff497819ULL, 0x000fe40000011652ULL,
0x00000010ff247819ULL, 0x000fe40000011624ULL, 0x0000105479647816ULL, 0x000fe40000000064ULL,
0x0000105465657816ULL, 0x000fc40000000063ULL, 0x000010545e087816ULL, 0x000fe40000000067ULL,
0x000010545d097816ULL, 0x000fe40000000009ULL, 0x000010540a0c7816ULL, 0x000fe20000000053ULL,
0x000000641018723cULL, 0x000b620000041818ULL, 0x00001054500d7816ULL, 0x000fe4000000000dULL,
0x0000105451487816ULL, 0x000fe40000000047ULL, 0x0000105449497816ULL, 0x000fc60000000024ULL,
0x000000081008723cULL, 0x040b700000041854ULL, 0x0000000c100c723cULL, 0x040b700000041858ULL,
0x000000481010723cULL, 0x000b62000004184cULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff487f8cULL, 0x020e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000008035247810ULL, 0x000fe20007ffe0ffULL,
0x01069800ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff4e7224ULL, 0x002fc400078e0049ULL,
0x0000001c2400720cULL, 0x000fe40003f06070ULL, 0x0000000125247810ULL, 0x000fd60007ffe0ffULL,
0x0000524000000947ULL, 0x000fea0003800000ULL, 0x0000000000487805ULL, 0x000fc40000015200ULL,
0x0106bc00ff207984ULL, 0x000e640000000800ULL, 0x8000000020ff7812ULL, 0x002fe4000780484eULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff477224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104700780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000004a7805ULL, 0x000fcc0000015200ULL, 0x0000004a48247210ULL, 0x000fca0007f1e1ffULL,
0x000000014b4a7824ULL, 0x000fe200000e0e49ULL, 0x003d09002400780cULL, 0x000fc80003f06070ULL,
0x000000ff4a00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402400780cULL, 0x000fc80003f06070ULL, 0x000000ff4a00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff207819ULL, 0x000fc8000001144aULL,
0x0000002420207211ULL, 0x000fca00078110ffULL, 0x000000ffff247224ULL, 0x000fca00000e064aULL,
0x0000000220207819ULL, 0x000fc80000001224ULL, 0x000000200000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000147477810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106bc00ff207984ULL, 0x000e640000000800ULL,
0x8000000020ff7812ULL, 0x002fe4000780484eULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000046000009947ULL, 0x000fea0003800000ULL, 0x000000011f477824ULL, 0x000fe200078e022eULL,
0x000000a035207810ULL, 0x000fe40007ffe0ffULL, 0x000000022e4b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000147487824ULL, 0x040fe200078e0203ULL, 0x000000042e4c7810ULL, 0x000fe20007ffe0ffULL,
0x0000001047507824ULL, 0x000fe200078e00ffULL, 0x000000201c247217ULL, 0x000fe20007800000ULL,
0x000000011f4a7824ULL, 0x040fe200078e024bULL, 0x000000062e537810ULL, 0x000fe20007ffe0ffULL,
0x000000011f4d7824ULL, 0x040fe200078e024cULL, 0xfffffff050507812ULL, 0x000fe200078ee248ULL,
0x0000000124247824ULL, 0x000fe200078e0a20ULL, 0x0000006000207811ULL, 0x000fe200078e38ffULL,
0x000000014a487824ULL, 0x100fe200078e0203ULL, 0x000000f0264f7812ULL, 0x000fe200078ec0ffULL,
0x000000104a517824ULL, 0x000fe200078e00ffULL, 0x000000241f247217ULL, 0x000fe20007800000ULL,
0x000000014d4e7824ULL, 0x040fe200078e0203ULL, 0x0000e00050507811ULL, 0x000fe200078e20ffULL,
0x000000104d527824ULL, 0x000fe200078e00ffULL, 0xfffffff051517812ULL, 0x000fe200078ee248ULL,
0x000000011f487824ULL, 0x000fc400078e0253ULL, 0x0000000147497824ULL, 0x000fe200078e0220ULL,
0xfffffff052527812ULL, 0x000fe200078ee24eULL, 0x000000014a4e7824ULL, 0x100fe200078e0220ULL,
0x0000e00051517811ULL, 0x000fe200078e20ffULL, 0x000000014d477824ULL, 0x100fe200078e0220ULL,
0x0000004549497210ULL, 0x080fe20007f1e0ffULL, 0x0000000148207824ULL, 0x000fe200078e0220ULL,
0x000000454e4e7210ULL, 0x080fe20007f3e0ffULL, 0x00000001484a7824ULL, 0x040fe200078e0203ULL,
0x0000004547477210ULL, 0x080fe20007f9e0ffULL, 0x0000001048547824ULL, 0x000fe200078e00ffULL,
0x0000004520207210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff457224ULL, 0x000fe200008e06ffULL,
0x00005e004e4d7a11ULL, 0x000fe200078440ffULL, 0x0000000124247824ULL, 0x000fe200078e0a1fULL,
0xfffffff054547812ULL, 0x000fe200078ee24aULL, 0x000000ffff4a7224ULL, 0x000fe200000e06ffULL,
0x00005e0049487a11ULL, 0x000fc400078040ffULL, 0x00005f004e4e7a11ULL, 0x000fe200010f4445ULL,
0x000000ffff457224ULL, 0x000fe200018e06ffULL, 0x000000242e00720cULL, 0x080fe40003f46070ULL,
0x00005f0049497a11ULL, 0x000fe400000f444aULL, 0x0000004f48487210ULL, 0x000fe40007fbe0ffULL,
0x000000244b00720cULL, 0x080fe20003f26070ULL, 0x000000ffff4b7224ULL, 0x000fe200020e06ffULL,
0x00005e00474a7a11ULL, 0x000fe200078840ffULL, 0x000000ffff497224ULL, 0x000fe200028e0649ULL,
0x000000244c00720cULL, 0x000fc40003f06070ULL, 0x00005e00204c7a11ULL, 0x000fe400078c40ffULL,
0x000000245300720cULL, 0x000fe20003f66070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000048507faeULL, 0x0003e2000d101c46ULL, 0x00005f0047247a11ULL, 0x000fe400020f444bULL,
0x0000004f4a4a7210ULL, 0x080fe40007f9e0ffULL, 0x00005f0020207a11ULL, 0x000fe400030f4445ULL,
0x0000004f4c4c7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff4b7224ULL, 0x000fe200020e0624ULL,
0x0000e00052527811ULL, 0x000fc400078e20ffULL, 0x0000e00054547811ULL, 0x000fe400078e20ffULL,
0x0000004f4d487210ULL, 0x002fe20007f5e0ffULL, 0x000000ffff4d7224ULL, 0x000fc800028e0620ULL,
0x000000ffff497224ULL, 0x000fca00010e064eULL, 0x0000000048517faeULL, 0x0003e8000c901c46ULL,
0x000000004a527faeULL, 0x0003e8000c101c46ULL, 0x000000004c547faeULL, 0x0003e2000d901c46ULL,
0x0000039000007947ULL, 0x000fea0003800000ULL, 0x000000011f207824ULL, 0x000fe200078e022eULL,
0x0000006000247811ULL, 0x000fc400078e38ffULL, 0x000000f026507812ULL, 0x000fe200078ec0ffULL,
0x0000000120477824ULL, 0x040fe200078e0203ULL, 0x0000000220497810ULL, 0x040fe20007ffe0ffULL,
0x0000001020517824ULL, 0x040fe200078e00ffULL, 0x00000004204a7810ULL, 0x000fc60007ffe0ffULL,
0x0000000149487824ULL, 0x000fe200078e0203ULL, 0xfffffff051517812ULL, 0x000fe200078ee247ULL,
0x0000001049527824ULL, 0x040fe400078e00ffULL, 0x0000000120477824ULL, 0x140fe200078e0224ULL,
0x0000000620207810ULL, 0x000fe20007ffe0ffULL, 0x0000000149497824ULL, 0x000fe200078e0224ULL,
0xfffffff052527812ULL, 0x000fe200078ee248ULL, 0x000000014a4b7824ULL, 0x140fe200078e0203ULL,
0x0000004547487210ULL, 0x080fe20007f5e0ffULL, 0x000000014a477824ULL, 0x100fe200078e0224ULL,
0x0000004549497210ULL, 0x080fe20007f1e0ffULL, 0x00000001204c7824ULL, 0x000fe200078e0224ULL,
0x00005e00484e7a11ULL, 0x000fe200078640ffULL, 0x000000104a537824ULL, 0x000fe200078e00ffULL,
0x0000004547477210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff247224ULL, 0x000fe200010e06ffULL,
0x0000e00051517811ULL, 0x000fe200078e20ffULL, 0x00000001204a7824ULL, 0x040fe200078e0203ULL,
0xfffffff053537812ULL, 0x000fe200078ee24bULL, 0x0000001020547824ULL, 0x000fe200078e00ffULL,
0x000000454c207210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff4b7224ULL, 0x000fe200000e06ffULL,
0x00005f00484d7a11ULL, 0x000fe200018f4424ULL, 0x000000ffff457224ULL, 0x000fe200008e06ffULL,
0xfffffff054547812ULL, 0x000fe200078ee24aULL, 0x000000ffff247224ULL, 0x000fe200010e06ffULL,
0x00005e0049487a11ULL, 0x000fc400078040ffULL, 0x00005e00474a7a11ULL, 0x000fe400078240ffULL,
0x00005e00204c7a11ULL, 0x000fe400078440ffULL, 0x000000504e4e7210ULL, 0x080fe40007f7e0ffULL,
0x00005f0049497a11ULL, 0x000fe400000f444bULL, 0x00005f0047457a11ULL, 0x000fe200008f4445ULL,
0x000000ffff4f7224ULL, 0x000fe200018e064dULL, 0x0000005048487210ULL, 0x000fc40007f1e0ffULL,
0x00005f0020207a11ULL, 0x000fe400010f4424ULL, 0x000000504a4a7210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff497224ULL, 0x000fe200000e0649ULL, 0x000000504c4c7210ULL, 0x000fe20007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000004e517faeULL, 0x0003e2000b901c46ULL,
0x0000e00052527811ULL, 0x000fe200078e20ffULL, 0x000000ffff4b7224ULL, 0x000fe200008e0645ULL,
0x0000e00053537811ULL, 0x000fe200078e20ffULL, 0x000000ffff4d7224ULL, 0x000fe200010e0620ULL,
0x0000e00054547811ULL, 0x000fe200078e20ffULL, 0x0000000048527faeULL, 0x0003e8000b901c46ULL,
0x000000004a537faeULL, 0x0003e8000b901c46ULL, 0x000000004c547faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000225487810ULL, 0x002fc80007ffe0ffULL,
0x0000001d4800720cULL, 0x000fe20003f06070ULL, 0xffffffffff207424ULL, 0x000fd800078e00ffULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x0000000122487824ULL, 0x000fe400078e0248ULL,
0x00000004ff497424ULL, 0x000fc800078e00ffULL, 0x0000600048487625ULL, 0x000fca00078e0049ULL,
0x0000000648207981ULL, 0x000324000c1e1900ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff4c7f8cULL, 0x000ea2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010668001f4e7f8cULL, 0x000664000c80043fULL, 0x0000000000487805ULL, 0x002fc40000015200ULL,
0x01066c001f247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fe4000780484fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff477224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104700780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000004a7805ULL, 0x000fcc0000015200ULL, 0x0000004a48457210ULL, 0x000fca0007f1e1ffULL,
0x000000014b4a7824ULL, 0x000fe200000e0e49ULL, 0x003d09004500780cULL, 0x000fc80003f06070ULL,
0x000000ff4a00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404500780cULL, 0x000fc80003f06070ULL, 0x000000ff4a00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff247819ULL, 0x000fc8000001144aULL,
0x0000004524247211ULL, 0x000fca00078110ffULL, 0x000000ffff457224ULL, 0x000fca00000e064aULL,
0x0000000224247819ULL, 0x000fc80000001245ULL, 0x000000240000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000147477810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01066c001f247984ULL, 0x000e640000000800ULL,
0x8000000024ff7812ULL, 0x002fe4000780484fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0101800027247984ULL, 0x000e680000000800ULL, 0x0103800027457984ULL, 0x0006a20000000800ULL,
0x000000462400720bULL, 0x002fe20003f1d000ULL, 0x0000b3827f007947ULL, 0x000fd8000b800000ULL,
0x00000000004a7806ULL, 0x008fc800000e0100ULL, 0x0000ffff4aff7812ULL, 0x000fe2000780c0ffULL,
0x0000047000007945ULL, 0x000fe20003800000ULL, 0x00000001ff477424ULL, 0x000fd600078e00ffULL,
0x0000044000008947ULL, 0x000fea0003800000ULL, 0x000000030200780cULL, 0x000fe40003f05270ULL,
0x000000462400720bULL, 0x000fe20003f34000ULL, 0x0000b3527f007947ULL, 0x000fd8000b800000ULL,
0x0000000000287806ULL, 0x000fc400008e0100ULL, 0x0000004624478209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe80003800000ULL, 0x0105804727008388ULL, 0x0003e40000000800ULL,
0x0000991028277816ULL, 0x002fc800000000ffULL, 0x000000ff2700720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000004624277209ULL, 0x000fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff28ff7812ULL, 0x000fc6000780c0ffULL,
0x0000004627277221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b27277820ULL, 0x000fc80000410000ULL,
0x00000027004b7308ULL, 0x000e640000000800ULL, 0x0000004b21217220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff277819ULL, 0x000fe20000011603ULL,
0x0000b2927f007947ULL, 0x000fea000b800000ULL, 0x00001f274b277589ULL, 0x0002e400000e0000ULL,
0x000000273c3c7220ULL, 0x088fe20000410000ULL, 0x000000273d3d7220ULL, 0x080fe20000410000ULL,
0x0000002738387220ULL, 0x080fe20000410000ULL, 0x0000002739397220ULL, 0x080fe20000410000ULL,
0x0000002718187220ULL, 0x080fe20000410000ULL, 0x0000002719197220ULL, 0x080fe20000410000ULL,
0x0000002714147220ULL, 0x080fe20000410000ULL, 0x0000002715157220ULL, 0x080fe20000410000ULL,
0x0000002704047220ULL, 0x080fe20000410000ULL, 0x0000002705057220ULL, 0x080fe20000410000ULL,
0x0000002708087220ULL, 0x080fe20000410000ULL, 0x0000002709097220ULL, 0x080fe20000410000ULL,
0x000000270c0c7220ULL, 0x080fe20000410000ULL, 0x000000270d0d7220ULL, 0x080fe20000410000ULL,
0x0000002710107220ULL, 0x080fe20000410000ULL, 0x0000002711117220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0028ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000803277811ULL, 0x000fe200078ff0ffULL,
0x0000b1927f007947ULL, 0x000fea000b800000ULL, 0x00001f274b277589ULL, 0x00066400000e0000ULL,
0x000000273e3e7220ULL, 0x082fe20000410000ULL, 0x000000273f3f7220ULL, 0x080fe20000410000ULL,
0x000000273a3a7220ULL, 0x080fe20000410000ULL, 0x000000273b3b7220ULL, 0x080fe20000410000ULL,
0x000000271a1a7220ULL, 0x080fe20000410000ULL, 0x000000271b1b7220ULL, 0x080fe20000410000ULL,
0x0000002716167220ULL, 0x080fe20000410000ULL, 0x0000002717177220ULL, 0x080fe20000410000ULL,
0x0000002706067220ULL, 0x080fe20000410000ULL, 0x0000002707077220ULL, 0x080fe20000410000ULL,
0x000000270a0a7220ULL, 0x080fe20000410000ULL, 0x000000270b0b7220ULL, 0x080fe20000410000ULL,
0x000000270e0e7220ULL, 0x080fe20000410000ULL, 0x000000270f0f7220ULL, 0x080fe20000410000ULL,
0x0000002712127220ULL, 0x080fe20000410000ULL, 0x0000002713137220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000ffff28ff7812ULL, 0x000fe2000780084aULL,
0x00000001ff477424ULL, 0x000fe200078e00ffULL, 0x0000004624467209ULL, 0x000fd60007810000ULL,
0x8000004624240221ULL, 0x000fe20000010000ULL, 0x00007610ff470816ULL, 0x000fc60000000047ULL,
0x3fb8aa3b24240820ULL, 0x000fc80000410000ULL, 0x00000024002b0308ULL, 0x000e640000000800ULL,
0x0000002b45450220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002145217221ULL, 0x004fc20000010000ULL, 0x0000000000487805ULL, 0x000fcc0000015200ULL,
0x0106ac00ff247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fe40007804844ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000004a7805ULL, 0x008fcc0000015200ULL, 0x0000004a48277210ULL, 0x000fca0007f1e1ffULL,
0x000000014b4a7824ULL, 0x000fe200000e0e49ULL, 0x003d09002700780cULL, 0x000fc80003f06070ULL,
0x000000ff4a00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402700780cULL, 0x000fc80003f06070ULL, 0x000000ff4a00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff247819ULL, 0x000fc8000001144aULL,
0x0000002724247211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e064aULL,
0x0000000224247819ULL, 0x000fc80000001227ULL, 0x000000240000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000128287810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106ac00ff247984ULL, 0x000e640000000800ULL,
0x8000000024ff7812ULL, 0x002fe40007804844ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991047247816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff2400720cULL, 0x000fda0003f25270ULL, 0x0000012000001947ULL, 0x000fea0003800000ULL,
0x0000002bff24723eULL, 0x000fe400000010ffULL, 0x00000002ff277819ULL, 0x000fe40000011603ULL,
0x0000541024247816ULL, 0x000fe20000000024ULL, 0x0000ad827f007947ULL, 0x000fea000b800000ULL,
0x00001f27242c7589ULL, 0x0002a400000e0000ULL, 0x00000008272d7810ULL, 0x000fe20007ffe0ffULL,
0x0000adb27f007947ULL, 0x000fea000b800000ULL, 0x00001f2d242d7589ULL, 0x0002e400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001027477810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff497224ULL, 0x000fe200078e0024ULL, 0x000121d000487802ULL, 0x000fc40000000f00ULL,
0x0000b32000007944ULL, 0x01efea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001827477810ULL, 0x004fe20007ffe0ffULL, 0x000000ffff497224ULL, 0x000fe200078e0024ULL,
0x0001222000487802ULL, 0x000fc40000000f00ULL, 0x0000b2d000007944ULL, 0x01afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000003054783bULL, 0x000e620000004200ULL, 0x0000b80034347811ULL, 0x000fc600078e20ffULL,
0x000000002f58783bULL, 0x000ee80000004200ULL, 0x000000003150783bULL, 0x000ea80000004200ULL,
0x000000003348783bULL, 0x0086a20000004200ULL, 0x00000010ff7a7819ULL, 0x002fe40000011654ULL,
0x000000ff54607812ULL, 0x000fc400078ec0ffULL, 0x00000018ff5f7819ULL, 0x000fe40000011654ULL,
0x0000ffff54887812ULL, 0x000fe400078ec0ffULL, 0x00000010ff7b7819ULL, 0x100fe40000011655ULL,
0x000000ff55617812ULL, 0x040fe400078ec0ffULL, 0x00000018ff547819ULL, 0x000fe40000011655ULL,
0x0000ffff55897812ULL, 0x000fc400078ec0ffULL, 0x00000010ff7c7819ULL, 0x100fe40000011656ULL,
0x000000ff56627812ULL, 0x040fe400078ec0ffULL, 0x00000018ff557819ULL, 0x000fe40000011656ULL,
0x0000ffff568a7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff7f7819ULL, 0x000fe40000011657ULL,
0x000000ff57637812ULL, 0x000fc400078ec0ffULL, 0x00000018ff567819ULL, 0x000fe40000011657ULL,
0x0000ffff578b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff707819ULL, 0x100fe40000011658ULL,
0x000000ff58247812ULL, 0x040fe400078ec0ffULL, 0x00000018ff337819ULL, 0x008fe40000011658ULL,
0x0000ffff58847812ULL, 0x000fc400078ec0ffULL, 0x00000010ff817819ULL, 0x104fe40000011650ULL,
0x000000ff50747812ULL, 0x040fe400078ec0ffULL, 0x00000018ff577819ULL, 0x000fe40000011650ULL,
0x0000ffff506d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff727819ULL, 0x000fe40000011659ULL,
0x000000ff59587812ULL, 0x000fc400078ec0ffULL, 0x00000018ff4f7819ULL, 0x000fe40000011659ULL,
0x0000ffff59857812ULL, 0x000fe400078ec0ffULL, 0x00000010ff837819ULL, 0x100fe40000011651ULL,
0x000000ff51777812ULL, 0x040fe400078ec0ffULL, 0x00000018ff507819ULL, 0x000fe40000011651ULL,
0x0000ffff516c7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff757819ULL, 0x100fe4000001165aULL,
0x000000ff5a5c7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff597819ULL, 0x000fe4000001165aULL,
0x0000ffff5a867812ULL, 0x000fe400078ec0ffULL, 0x00000010ff697819ULL, 0x000fe40000011652ULL,
0x000000ff52787812ULL, 0x000fc400078ec0ffULL, 0x00000018ff517819ULL, 0x000fe40000011652ULL,
0x0000ffff52307812ULL, 0x000fe400078ec0ffULL, 0x00000010ff767819ULL, 0x100fe4000001165bULL,
0x000000ff5b5e7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff5d7819ULL, 0x000fe4000001165bULL,
0x0000ffff5b877812ULL, 0x000fc400078ec0ffULL, 0x00000010ff317819ULL, 0x100fe40000011653ULL,
0x000000ff53797812ULL, 0x040fe400078ec0ffULL, 0x00000018ff527819ULL, 0x000fe40000011653ULL,
0x0000ffff535a7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5b7819ULL, 0x000fe40000011648ULL,
0x000000ff487d7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff537819ULL, 0x000fe40000011648ULL,
0x0000ffff484e7812ULL, 0x000fe400078ec0ffULL, 0x00000033ff33723eULL, 0x000fe400020006ffULL,
0x00000018ff487819ULL, 0x000fe40000011649ULL, 0x00000024ff45723eULL, 0x000fe200020006ffULL,
0x20000033ff6e7230ULL, 0x000fe20000004100ULL, 0x00000056ff56723eULL, 0x000fc400020006ffULL,
0x00000052ff52723eULL, 0x000fe200020006ffULL, 0x20000045ff717230ULL, 0x000fe20000004100ULL,
0x00000048ff48723eULL, 0x000fe400020006ffULL, 0x00000061ff33723eULL, 0x000fe200020006ffULL,
0x20000056ff617230ULL, 0x000fe20000004100ULL, 0x00000062ff62723eULL, 0x000fe200020006ffULL,
0x20000052ff567230ULL, 0x000fe20000004100ULL, 0x00000063ff45723eULL, 0x000fe200020006ffULL,
0x20000033ff337230ULL, 0x000fe20000004100ULL, 0x00000010ff477819ULL, 0x000fe20000011649ULL,
0x20000062ff637230ULL, 0x000fe20000004100ULL, 0x000000ff497e7812ULL, 0x040fe200078ec0ffULL,
0x20000045ff627230ULL, 0x000fe20000004100ULL, 0x0000ffff492f7812ULL, 0x000fc400078ec0ffULL,
0x00000053ff52723eULL, 0x000fe200020006ffULL, 0x20000048ff537230ULL, 0x000fe20000004100ULL,
0x00000010ff447819ULL, 0x100fe4000001164aULL, 0x000000ff4a807812ULL, 0x040fe200078ec0ffULL,
0x20000052ff527230ULL, 0x000fe20000004100ULL, 0x00000018ff497819ULL, 0x000fe4000001164aULL,
0x0000ffff4a287812ULL, 0x000fe400078ec0ffULL, 0x000000ff72727812ULL, 0x000fc400078ec0ffULL,
0x00000018ff4a7819ULL, 0x000fe4000001164bULL, 0x00000008ff487819ULL, 0x000fe40000011684ULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x00000057ff57723eULL, 0x000fe200020006ffULL, 0x2000005cff6a7230ULL, 0x000fe20000004100ULL,
0x00000051ff51723eULL, 0x000fe200020006ffULL, 0x2000005fff647230ULL, 0x000fe20000004100ULL,
0x00000049ff45723eULL, 0x000fe200020006ffULL, 0x20000057ff5c7230ULL, 0x000fe20000004100ULL,
0x00000072ff72723eULL, 0x000fe200020006ffULL, 0x20000051ff577230ULL, 0x000fe20000004100ULL,
0x0000004aff4a723eULL, 0x000fe200020006ffULL, 0x20000045ff457230ULL, 0x000fe20000004100ULL,
0x00000048ff48723eULL, 0x000fc400020006ffULL, 0x00000008ff497819ULL, 0x000fe20000011685ULL,
0x2000004aff517230ULL, 0x000fe20000004100ULL, 0x00000074ff5f723eULL, 0x000fe200020006ffULL,
0x20000072ff747230ULL, 0x000fe20000004100ULL, 0x00000049ff49723eULL, 0x000fe200020006ffULL,
0x20000048ff727230ULL, 0x000fe20000004100ULL, 0x000000ff75487812ULL, 0x000fe200078ec0ffULL,
0x2000005fff5f7230ULL, 0x000fe20000004100ULL, 0x000000ff76767812ULL, 0x000fe200078ec0ffULL,
0x20000049ff757230ULL, 0x000fe20000004100ULL, 0x00000008ff4a7819ULL, 0x000fc40000011686ULL,
0x00000058ff58723eULL, 0x000fe400020006ffULL, 0x0000005eff5e723eULL, 0x000fe400020006ffULL,
0x00000059ff59723eULL, 0x000fe200020006ffULL, 0x20000058ff737230ULL, 0x000fe20000004100ULL,
0x00000010ff277819ULL, 0x000fe2000001164bULL, 0x2000005eff6b7230ULL, 0x000fe20000004100ULL,
0x000000ff4b827812ULL, 0x040fe200078ec0ffULL, 0x20000059ff677230ULL, 0x000fe20000004100ULL,
0x0000ffff4b247812ULL, 0x000fc400078ec0ffULL, 0x00000048ff48723eULL, 0x000fe400020006ffULL,
0x00000076ff49723eULL, 0x000fe400020006ffULL, 0x0000004aff4a723eULL, 0x000fe200020006ffULL,
0x20000048ff767230ULL, 0x000fe20000004100ULL, 0x00000008ff4b7819ULL, 0x000fe40000011687ULL,
0x00000077ff5e723eULL, 0x000fe200020006ffULL, 0x2000004aff777230ULL, 0x000fe20000004100ULL,
0x00000078ff58723eULL, 0x000fe200020006ffULL, 0x20000049ff787230ULL, 0x000fe20000004100ULL,
0x00000079ff59723eULL, 0x000fe200020006ffULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x0000004bff79723eULL, 0x000fe200020006ffULL, 0x20000058ff587230ULL, 0x000fe20000004100ULL,
0x000000003448783bULL, 0x0002a20000000200ULL, 0x00000060ff60723eULL, 0x000fe200020006ffULL,
0x20000059ff597230ULL, 0x000fe20000004100ULL, 0x000000ff7b7b7812ULL, 0x000fe200078ec0ffULL,
0x20000079ff797230ULL, 0x000fe20000004100ULL, 0x00000055ff55723eULL, 0x000fe200020006ffULL,
0x20000060ff667230ULL, 0x000fe20000004100ULL, 0x0000007bff7b723eULL, 0x000fc400020006ffULL,
0x00000008ff347819ULL, 0x002fe20000011688ULL, 0x20000055ff607230ULL, 0x000fe20000004100ULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x00000034ff34723eULL, 0x000fe400020006ffULL,
0x0000007eff55723eULL, 0x000fe200020006ffULL, 0x2000005dff687230ULL, 0x000fe20000004100ULL,
0x00000050ff50723eULL, 0x000fe400020006ffULL, 0x000000ff7c7e7812ULL, 0x000fe200078ec0ffULL,
0x2000007bff7c7230ULL, 0x000fe20000004100ULL, 0x0000004fff4f723eULL, 0x000fe200020006ffULL,
0x20000034ff7b7230ULL, 0x000fe20000004100ULL, 0x00000008ff347819ULL, 0x000fe2000001168aULL,
0x20000050ff5d7230ULL, 0x000fe20000004100ULL, 0x00000080ff50723eULL, 0x000fe200020006ffULL,
0x2000004fff6f7230ULL, 0x000fe20000004100ULL, 0x00000034ff34723eULL, 0x000fe200020006ffULL,
0x20000055ff557230ULL, 0x000fe20000004100ULL, 0x00000008ff807819ULL, 0x000fe2000001168bULL,
0x20000050ff507230ULL, 0x000fe20000004100ULL, 0x00000082ff4f723eULL, 0x000fc400020006ffULL,
0x000000ff81827812ULL, 0x000fe400078ec0ffULL, 0x00000080ff81723eULL, 0x000fe200020006ffULL,
0x20000034ff807230ULL, 0x000fe20000004100ULL, 0x00000010ff347819ULL, 0x000fe2000001166fULL,
0x2000004fff4f7230ULL, 0x000fe20000004100ULL, 0x00000010ff6e7819ULL, 0x000fe2000001166eULL,
0x0000002c48489231ULL, 0x084fe200003400ffULL, 0x00000010ff727819ULL, 0x000fe20000011672ULL,
0x0000002c4a4a9231ULL, 0x000fe200003400ffULL, 0x00000010ff6f7819ULL, 0x000fe20000011675ULL,
0x0000002d49499231ULL, 0x080fe200003400ffULL, 0x000010546e6e7816ULL, 0x000fe20000000072ULL,
0x0000002d4b4b9231ULL, 0x000fe200003400ffULL, 0x00001054346f7816ULL, 0x000fe2000000006fULL,
0x20000081ff817230ULL, 0x000fe20000004100ULL, 0x000000ff31317812ULL, 0x000fc400078ec0ffULL,
0x00000054ff54723eULL, 0x000fe400020006ffULL, 0x00000031ff34723eULL, 0x000fe200020006ffULL,
0x0000006e4838723cULL, 0x000be20000041838ULL, 0x00000008ff307819ULL, 0x000fe20000011630ULL,
0x20000054ff657230ULL, 0x000fe20000004100ULL, 0x00000010ff677819ULL, 0x000fe40000011667ULL,
0x00000010ff687819ULL, 0x000fe40000011668ULL, 0x00000010ff777819ULL, 0x000fe20000011677ULL,
0x20000034ff6f7230ULL, 0x020fe20000004100ULL, 0x00000010ff317819ULL, 0x000fc40000011679ULL,
0x0000007dff54723eULL, 0x000fe400020006ffULL, 0x00000030ff6e723eULL, 0x000fe400020006ffULL,
0x00000008ff7d7819ULL, 0x000fe20000011689ULL, 0x20000054ff547230ULL, 0x000fe20000004100ULL,
0x0000105467307816ULL, 0x000fe20000000077ULL, 0x2000006eff6e7230ULL, 0x000fe20000004100ULL,
0x0000105468317816ULL, 0x000fe40000000031ULL, 0x00000010ff337819ULL, 0x000fc40000011633ULL,
0x00000010ff677819ULL, 0x000fe4000001167cULL, 0x0000b80032347811ULL, 0x000fe400078e20ffULL,
0x0000007dff7d723eULL, 0x000fe400020006ffULL, 0x000000ff70707812ULL, 0x000fe400078ec0ffULL,
0x000000ff7a7a7812ULL, 0x000fe200078ec0ffULL, 0x2000007dff7d7230ULL, 0x000fe20000004100ULL,
0x000000ff7f7f7812ULL, 0x000fc400078ec0ffULL, 0x0000105467677816ULL, 0x000fe40000000033ULL,
0x000000304830723cULL, 0x000be20000041814ULL, 0x00000070ff70723eULL, 0x000fe200020006ffULL,
0x000000003414783bULL, 0x0202a20000000200ULL, 0x0000007aff7a723eULL, 0x000fe400020006ffULL,
0x0000007eff7e723eULL, 0x000fe200020006ffULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x0000007fff7f723eULL, 0x000fe200020006ffULL, 0x2000007aff7a7230ULL, 0x000fe20000004100ULL,
0x00000010ff717819ULL, 0x000fe20000011671ULL, 0x2000007eff7e7230ULL, 0x000fe20000004100ULL,
0x00000010ff347819ULL, 0x002fe20000011665ULL, 0x2000007fff7f7230ULL, 0x000fe20000004100ULL,
0x00000010ff657819ULL, 0x000fc4000001167dULL, 0x00000010ff707819ULL, 0x000fe40000011670ULL,
0x0000105434657816ULL, 0x000fe40000000065ULL, 0x00000010ff347819ULL, 0x000fe40000011661ULL,
0x00000010ff737819ULL, 0x000fe40000011673ULL, 0x00000010ff747819ULL, 0x000fe40000011674ULL,
0x00000010ff6a7819ULL, 0x000fc4000001166aULL, 0x00000010ff6b7819ULL, 0x000fe4000001166bULL,
0x00000010ff767819ULL, 0x000fe40000011676ULL, 0x00000010ff787819ULL, 0x000fe40000011678ULL,
0x00000010ff667819ULL, 0x000fe40000011666ULL, 0x00000010ff7a7819ULL, 0x000fe4000001167aULL,
0x00000010ff647819ULL, 0x000fc40000011664ULL, 0x00000010ff7b7819ULL, 0x000fe4000001167bULL,
0x00000010ff637819ULL, 0x000fe20000011663ULL, 0x0000002c14149231ULL, 0x084fe200003400ffULL,
0x00000010ff627819ULL, 0x000fe20000011662ULL, 0x0000002c16169231ULL, 0x000fe200003400ffULL,
0x00000010ff7e7819ULL, 0x000fe2000001167eULL, 0x0000002d15159231ULL, 0x080fe200003400ffULL,
0x00000010ff7f7819ULL, 0x000fe2000001167fULL, 0x0000002d17179231ULL, 0x000fe200003400ffULL,
0x00000010ff607819ULL, 0x000fc40000011660ULL, 0x00000010ff807819ULL, 0x000fe40000011680ULL,
0x00000010ff617819ULL, 0x000fe40000011681ULL, 0x0000105470707816ULL, 0x000fe40000000071ULL,
0x0000105474717816ULL, 0x000fe40000000073ULL, 0x00001054766a7816ULL, 0x000fe4000000006aULL,
0x00001054786b7816ULL, 0x000fc4000000006bULL, 0x000010547a667816ULL, 0x000fe20000000066ULL,
0x00000070483c723cULL, 0x040f62000004183cULL, 0x0000105464647816ULL, 0x000fe4000000007bULL,
0x000010547e7e7816ULL, 0x000fe40000000063ULL, 0x000010547f7f7816ULL, 0x000fe40000000062ULL,
0x0000105460607816ULL, 0x000fe20000000080ULL, 0x0000006a4818723cULL, 0x000f620000041818ULL,
0x0000105434617816ULL, 0x000fc40000000061ULL, 0x000000ff44447812ULL, 0x000fe400078ec0ffULL,
0x00000008ff287819ULL, 0x000fe40000011628ULL, 0x000000ff83837812ULL, 0x000fe200078ec0ffULL,
0x000000664804723cULL, 0x000f620000041804ULL, 0x00000008ff6d7819ULL, 0x000fe4000001166dULL,
0x00000008ff6c7819ULL, 0x000fe4000001166cULL, 0x000000ff69697812ULL, 0x000fc400078ec0ffULL,
0x00000008ff5a7819ULL, 0x000fe2000001165aULL, 0x000000644808723cULL, 0x040f620000041808ULL,
0x000000ff5b5b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff47477812ULL, 0x000fe400078ec0ffULL,
0x00000008ff4e7819ULL, 0x000fe4000001164eULL, 0x00000008ff347819ULL, 0x000fe2000001162fULL,
0x0000007e480c723cULL, 0x000f62000004180cULL, 0x000000ff27277812ULL, 0x000fc400078ec0ffULL,
0x00000008ff247819ULL, 0x000fe40000011624ULL, 0x00000044ff44723eULL, 0x000fe400020006ffULL,
0x00000028ff28723eULL, 0x000fe200020006ffULL, 0x000000604810723cULL, 0x000b620000041810ULL,
0x00000082ff82723eULL, 0x000fe200020006ffULL, 0x20000044ff447230ULL, 0x000fe20000004100ULL,
0x00000083ff83723eULL, 0x000fe200020006ffULL, 0x20000028ff287230ULL, 0x000fe20000004100ULL,
0x0000006dff6d723eULL, 0x000fe200020006ffULL, 0x20000082ff827230ULL, 0x000fe20000004100ULL,
0x0000006cff6c723eULL, 0x000fe200020006ffULL, 0x20000083ff837230ULL, 0x000fe20000004100ULL,
0x00000069ff69723eULL, 0x000fe200020006ffULL, 0x2000006dff6d7230ULL, 0x000fe20000004100ULL,
0x0000005aff5a723eULL, 0x000fe200020006ffULL, 0x2000006cff6c7230ULL, 0x000fe20000004100ULL,
0x0000005bff5b723eULL, 0x000fe200020006ffULL, 0x20000069ff697230ULL, 0x000fe20000004100ULL,
0x00000047ff47723eULL, 0x000fe200020006ffULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x0000004eff4e723eULL, 0x000fe200020006ffULL, 0x2000005bff5b7230ULL, 0x000fe20000004100ULL,
0x00000034ff34723eULL, 0x000fe200020006ffULL, 0x20000047ff477230ULL, 0x000fe20000004100ULL,
0x00000027ff27723eULL, 0x000fe200020006ffULL, 0x2000004eff4e7230ULL, 0x000fe20000004100ULL,
0x00000024ff24723eULL, 0x000fe200020006ffULL, 0x20000034ff347230ULL, 0x000fe20000004100ULL,
0x00000010ff507819ULL, 0x000fe20000011650ULL, 0x20000027ff277230ULL, 0x000fe20000004100ULL,
0x00000010ff447819ULL, 0x000fe20000011644ULL, 0x20000024ff247230ULL, 0x000fe20000004100ULL,
0x00000010ff2f7819ULL, 0x000fc4000001165dULL, 0x00000010ff597819ULL, 0x000fe40000011659ULL,
0x00000010ff6f7819ULL, 0x000fe4000001166fULL, 0x00000010ff457819ULL, 0x000fe40000011645ULL,
0x00000010ff287819ULL, 0x000fe40000011628ULL, 0x00000010ff5f7819ULL, 0x000fe4000001165fULL,
0x00000010ff5e7819ULL, 0x000fc4000001165eULL, 0x00000010ff827819ULL, 0x000fe40000011682ULL,
0x00000010ff837819ULL, 0x000fe40000011683ULL, 0x00000010ff5c7819ULL, 0x000fe4000001165cULL,
0x00000010ff6d7819ULL, 0x000fe4000001166dULL, 0x00000010ff5d7819ULL, 0x000fe4000001166cULL,
0x00000010ff587819ULL, 0x000fc40000011658ULL, 0x00000010ff697819ULL, 0x000fe40000011669ULL,
0x00000010ff577819ULL, 0x000fe40000011657ULL, 0x00000010ff567819ULL, 0x000fe40000011656ULL,
0x00000010ff6e7819ULL, 0x000fe4000001166eULL, 0x00000010ff5a7819ULL, 0x000fe4000001165aULL,
0x00000010ff547819ULL, 0x000fc40000011654ULL, 0x00000010ff557819ULL, 0x000fe40000011655ULL,
0x00000010ff5b7819ULL, 0x000fe4000001165bULL, 0x00000010ff477819ULL, 0x000fe40000011647ULL,
0x00000010ff527819ULL, 0x000fe40000011652ULL, 0x00000010ff4e7819ULL, 0x000fe4000001164eULL,
0x00000010ff537819ULL, 0x000fc40000011653ULL, 0x00000010ff347819ULL, 0x000fe40000011634ULL,
0x00000010ff497819ULL, 0x020fe4000001164fULL, 0x00000010ff277819ULL, 0x000fe40000011627ULL,
0x00000010ff517819ULL, 0x000fe40000011651ULL, 0x00000010ff247819ULL, 0x000fe40000011624ULL,
0x0000105444487816ULL, 0x000fc40000000050ULL, 0x000010546f597816ULL, 0x000fe40000000059ULL,
0x0000105445447816ULL, 0x000fe40000000028ULL, 0x0000105482827816ULL, 0x000fe4000000005fULL,
0x0000105483837816ULL, 0x000fe4000000005eULL, 0x000010545c5c7816ULL, 0x000fe4000000006dULL,
0x000010542f5d7816ULL, 0x000fc4000000005dULL, 0x0000105469587816ULL, 0x000fe20000000058ULL,
0x00000082143c723cULL, 0x040b62000004183cULL, 0x00001054576e7816ULL, 0x000fe4000000006eULL,
0x00001054566f7816ULL, 0x000fe4000000005aULL, 0x000010545b547816ULL, 0x000fe40000000054ULL,
0x0000105447557816ULL, 0x000fe20000000055ULL, 0x0000005c1438723cULL, 0x000b620000041838ULL,
0x0000105452527816ULL, 0x000fc4000000004eULL, 0x0000105453537816ULL, 0x000fe40000000034ULL,
0x0000105427497816ULL, 0x000fe40000000049ULL, 0x0000105451457816ULL, 0x000fe20000000024ULL,
0x000000581418723cULL, 0x040b700000041818ULL, 0x0000006e1430723cULL, 0x040b700000041830ULL,
0x000000541404723cULL, 0x040b700000041804ULL, 0x000000521408723cULL, 0x040b700000041808ULL,
0x00000048140c723cULL, 0x040b70000004180cULL, 0x000000441410723cULL, 0x000b620000041810ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff447f8cULL, 0x020e62000c80043fULL,
0x000000ffff277224ULL, 0x000fce00078e00ffULL, 0x0000000000147805ULL, 0x000fc40000015200ULL,
0x0106bc00ff167984ULL, 0x000ea40000000800ULL, 0x8000000016ff7812ULL, 0x006fc40007804845ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102700780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x0000001614247210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09002400780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402400780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000002416167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000127277810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106bc00ff167984ULL, 0x000e640000000800ULL, 0x8000000016ff7812ULL, 0x002fe40007804845ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000223147810ULL, 0x000fc80007ffe0ffULL,
0x0000001e1400720cULL, 0x000fe20003f06070ULL, 0x0000580020147a24ULL, 0x010fc800078e02ffULL,
0x0000008014247824ULL, 0x000fd000078e00ffULL, 0x0000045000008947ULL, 0x000fea0003800000ULL,
0x000000011f157824ULL, 0x000fe200078e022eULL, 0x000000022e457810ULL, 0x040fe40007ffe0ffULL,
0x000000c035357810ULL, 0x000fe20007ffe0ffULL, 0x0000000115167824ULL, 0x040fe200078e0203ULL,
0x000000042e487810ULL, 0x000fe20007ffe0ffULL, 0x0000001015447824ULL, 0x000fe200078e00ffULL,
0x000000351c147217ULL, 0x000fe20007800000ULL, 0x000000011f177824ULL, 0x000fe200078e0245ULL,
0x000000062e4a7810ULL, 0x000fe20007ffe0ffULL, 0x0000008000157824ULL, 0x000fe200078e0215ULL,
0xfffffff044447812ULL, 0x000fe200078ee216ULL, 0x0000000117167824ULL, 0x000fc400078e0203ULL,
0x0000001017477824ULL, 0x000fe200078e00ffULL, 0x0000000415287810ULL, 0x040fe20007ffe0ffULL,
0x0000000114147824ULL, 0x000fe200078e0a35ULL, 0x0000002415347210ULL, 0x000fe20007f1e0ffULL,
0x000000011f277824ULL, 0x000fe200078e0248ULL, 0xfffffff047477812ULL, 0x000fe200078ee216ULL,
0x000000011f167824ULL, 0x040fe200078e024aULL, 0x000000141f147217ULL, 0x000fe20007800000ULL,
0x0000000127177824ULL, 0x100fe200078e0203ULL, 0x00000002152f7810ULL, 0x000fe20007ffe0ffULL,
0x0000001027497824ULL, 0x000fe200078e00ffULL, 0x0000002428287210ULL, 0x080fe20007f7e0ffULL,
0x0000000116357824ULL, 0x040fe200078e0203ULL, 0x0000000615277810ULL, 0x000fe20007ffe0ffULL,
0x00000010164b7824ULL, 0x000fe200078e00ffULL, 0xfffffff049497812ULL, 0x000fe200078ee217ULL,
0x000000ffff157224ULL, 0x000fe200000e06ffULL, 0x00005e0034177a11ULL, 0x000fe200078440ffULL,
0x0000000114167824ULL, 0x000fe200078e0a1fULL, 0x000000242f2f7210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff147224ULL, 0x000fe200018e06ffULL, 0x0000002427247210ULL, 0x000fc40007f1e0ffULL,
0xfffffff04b4b7812ULL, 0x000fe400078ee235ULL, 0x00005e0028277a11ULL, 0x000fe400078640ffULL,
0x00005f0034347a11ULL, 0x000fe200010f4415ULL, 0x000000ffff157224ULL, 0x000fe200020e06ffULL,
0x000000f026357812ULL, 0x000fe400078ec0ffULL, 0x000000162e00720cULL, 0x000fe40003f46070ULL,
0x00005f0028287a11ULL, 0x000fc400018f4414ULL, 0x00005e002f2e7a11ULL, 0x000fe400078840ffULL,
0x0000003517147210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff177224ULL, 0x000fe200000e06ffULL,
0x00005f002f2f7a11ULL, 0x000fe400020f4415ULL, 0x000000164500720cULL, 0x080fe20003f86070ULL,
0x000000ffff157224ULL, 0x000fe200028e0634ULL, 0x000000164800720cULL, 0x000fe40003f66070ULL,
0x0000c00044447811ULL, 0x000fc400078e20ffULL, 0x000000164a00720cULL, 0x000fe40003f06070ULL,
0x00005e0024267a11ULL, 0x000fe200078c40ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014447faeULL, 0x0003e2000d101c46ULL, 0x000000352e167210ULL, 0x080fe40007fbe0ffULL,
0x00005f0024247a11ULL, 0x000fe400030f4417ULL, 0x0000c00047477811ULL, 0x000fe200078e20ffULL,
0x000000ffff177224ULL, 0x000fe200028e062fULL, 0x0000003526267210ULL, 0x000fc40007fbe0ffULL,
0x0000c00049497811ULL, 0x000fe400078e20ffULL, 0x0000c0004b4b7811ULL, 0x000fe200078e20ffULL,
0x0000000016477faeULL, 0x0005e2000e101c46ULL, 0x0000003527147210ULL, 0x002fe20007f5e0ffULL,
0x000000ffff277224ULL, 0x000fc800028e0624ULL, 0x000000ffff157224ULL, 0x000fca00010e0628ULL,
0x0000000014497faeULL, 0x0005e8000d901c46ULL, 0x00000000264b7faeULL, 0x0005e2000c101c46ULL,
0x0000038000007947ULL, 0x000fea0003800000ULL, 0x000000011f2e7824ULL, 0x000fc800078e022eULL,
0x000000012e147824ULL, 0x140fe200078e0203ULL, 0x000000022e157810ULL, 0x040fe20007ffe0ffULL,
0x000000102e177824ULL, 0x040fe200078e00ffULL, 0x000000042e277810ULL, 0x040fe40007ffe0ffULL,
0x000000062e2f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000115167824ULL, 0x100fe200078e0203ULL,
0xfffffff017177812ULL, 0x000fe200078ee214ULL, 0x0000001015287824ULL, 0x000fe400078e00ffULL,
0x0000008000147824ULL, 0x000fe200078e022eULL, 0x0000c00017177811ULL, 0x000fe200078e20ffULL,
0x0000000127347824ULL, 0x140fe200078e0203ULL, 0xfffffff028287812ULL, 0x000fe200078ee216ULL,
0x0000001027447824ULL, 0x000fe200078e00ffULL, 0x0000002414157210ULL, 0x040fe20007f1e0ffULL,
0x000000012f477824ULL, 0x040fe200078e0203ULL, 0x0000000214167810ULL, 0x040fe20007ffe0ffULL,
0x000000102f497824ULL, 0x000fe200078e00ffULL, 0x00000004142e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000614357810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff147224ULL, 0x000fe200000e06ffULL,
0x0000002416277210ULL, 0x080fe40007f5e0ffULL, 0x000000242e2f7210ULL, 0x080fe40007f7e0ffULL,
0x00005e0015167a11ULL, 0x000fe400078040ffULL, 0x000000f0262e7812ULL, 0x000fe400078ec0ffULL,
0x0000002435457210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff247224ULL, 0x000fe200010e06ffULL,
0x00005f0015157a11ULL, 0x000fc400000f4414ULL, 0x0000002e16147210ULL, 0x000fe40007f1e0ffULL,
0xfffffff044447812ULL, 0x000fe200078ee234ULL, 0x000000ffff347224ULL, 0x000fe200018e06ffULL,
0xfffffff049497812ULL, 0x000fe200078ee247ULL, 0x000000ffff477224ULL, 0x000fe200020e06ffULL,
0x00005e0027267a11ULL, 0x000fe200078440ffULL, 0x000000ffff157224ULL, 0x000fe200000e0615ULL,
0x00005e002f357a11ULL, 0x000fe400078640ffULL, 0x00005e0045487a11ULL, 0x000fc400078840ffULL,
0x00005f0027247a11ULL, 0x000fe200010f4424ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014177faeULL, 0x0003e2000b901c46ULL, 0x0000002e26167210ULL, 0x080fe40007f1e0ffULL,
0x00005f002f347a11ULL, 0x000fe400018f4434ULL, 0x0000002e35267210ULL, 0x080fe40007f5e0ffULL,
0x00005f0045477a11ULL, 0x000fe400020f4447ULL, 0x0000002e482e7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff277224ULL, 0x000fe200010e0634ULL, 0x0000c00028287811ULL, 0x000fe200078e20ffULL,
0x000000ffff177224ULL, 0x002fe200000e0624ULL, 0x0000c00044447811ULL, 0x000fe200078e20ffULL,
0x000000ffff2f7224ULL, 0x000fe200018e0647ULL, 0x0000c00049497811ULL, 0x000fc400078e20ffULL,
0x0000000016287faeULL, 0x0003e8000b901c46ULL, 0x0000000026447faeULL, 0x0003e8000b901c46ULL,
0x000000002e497faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x004fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff447f8cULL, 0x002e64000c80043fULL,
0x000000ffff447224ULL, 0x002fc400078e0045ULL, 0x0000000000147805ULL, 0x000fca0000015200ULL,
0x0106b400ff167984ULL, 0x000e640000000800ULL, 0x8000000016ff7812ULL, 0x002fc4000780484dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff267224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614247210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09002400780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402400780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000002416167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000126267810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106b400ff167984ULL, 0x000e640000000800ULL,
0x8000000016ff7812ULL, 0x002fe4000780484dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000014000007945ULL, 0x000fe20003800000ULL, 0x0000012000001947ULL, 0x000fea0003800000ULL,
0x0000002bff14723eULL, 0x000fe400000010ffULL, 0x00000002ff157819ULL, 0x000fe40000011603ULL,
0x0000541014147816ULL, 0x000fe20000000014ULL, 0x000089627f007947ULL, 0x000fea000b800000ULL,
0x00001f15142c7589ULL, 0x0002a400000e0000ULL, 0x00000008152d7810ULL, 0x000fe20007ffe0ffULL,
0x000089927f007947ULL, 0x000fea000b800000ULL, 0x00001f2d142d7589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001015477810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff497224ULL, 0x000fe200078e0014ULL, 0x000146b000487802ULL, 0x000fc40000000f00ULL,
0x00008e4000007944ULL, 0x00efea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001815477810ULL, 0x004fe20007ffe0ffULL, 0x000000ffff497224ULL, 0x000fe200078e0014ULL,
0x0001470000487802ULL, 0x000fc40000000f00ULL, 0x00008df000007944ULL, 0x00afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000b800375d7811ULL, 0x000fc400078e20ffULL, 0x00000000414c783bULL, 0x000f220000004200ULL,
0x0000b80040407811ULL, 0x000fc600078e20ffULL, 0x000000004248783bULL, 0x000ee80000004200ULL,
0x000000004314783bULL, 0x00ae680000004200ULL, 0x000000003634783bULL, 0x000ee20000004200ULL,
0x00000010ff2a7819ULL, 0x010fe4000001164cULL, 0x000000ff4c267812ULL, 0x000fc400078ec0ffULL,
0x00000018ff247819ULL, 0x000fe4000001164cULL, 0x0000ffff4c797812ULL, 0x000fe400078ec0ffULL,
0x00000010ff2e7819ULL, 0x100fe4000001164dULL, 0x000000ff4d287812ULL, 0x040fe400078ec0ffULL,
0x00000018ff277819ULL, 0x000fe4000001164dULL, 0x0000ffff4d7a7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff647819ULL, 0x100fe4000001164fULL, 0x000000ff4f477812ULL, 0x044fe400078ec0ffULL,
0x00000018ff457819ULL, 0x000fe4000001164fULL, 0x0000ffff4f7c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff6c7819ULL, 0x000fe40000011648ULL, 0x000000ff484d7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff4c7819ULL, 0x000fe40000011648ULL, 0x0000ffff487d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff6d7819ULL, 0x100fe40000011649ULL, 0x000000ff494f7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff487819ULL, 0x000fe40000011649ULL, 0x0000ffff497e7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff6f7819ULL, 0x100fe4000001164aULL, 0x000000ff4a507812ULL, 0x040fe400078ec0ffULL,
0x00000018ff497819ULL, 0x000fe4000001164aULL, 0x0000ffff4a7f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff707819ULL, 0x000fe4000001164bULL, 0x000000ff4b527812ULL, 0x000fc400078ec0ffULL,
0x00000018ff4a7819ULL, 0x000fe4000001164bULL, 0x0000ffff4b807812ULL, 0x000fe400078ec0ffULL,
0x00000010ff737819ULL, 0x102fe40000011614ULL, 0x000000ff14537812ULL, 0x040fe400078ec0ffULL,
0x00000018ff4b7819ULL, 0x000fe40000011614ULL, 0x0000ffff14817812ULL, 0x000fc400078ec0ffULL,
0x00000026ff14723eULL, 0x000fe400020006ffULL, 0x00000010ff747819ULL, 0x100fe40000011615ULL,
0x000000ff15547812ULL, 0x040fe200078ec0ffULL, 0x20000014ff5e7230ULL, 0x000fe20000004100ULL,
0x00000018ff5f7819ULL, 0x000fe40000011615ULL, 0x0000ffff15827812ULL, 0x000fe400078ec0ffULL,
0x00000010ff607819ULL, 0x000fc4000001164eULL, 0x000000ff4e417812ULL, 0x040fe400078ec0ffULL,
0x00000018ff2f7819ULL, 0x000fe4000001164eULL, 0x0000ffff4e7b7812ULL, 0x000fe400078ec0ffULL,
0x00000024ff15723eULL, 0x000fe400020006ffULL, 0x00000010ff5c7819ULL, 0x100fe40000011616ULL,
0x000000ff16677812ULL, 0x000fe200078ec0ffULL, 0x20000015ff617230ULL, 0x000fe20000004100ULL,
0x00000018ff637819ULL, 0x000fc40000011616ULL, 0x0000ffff165a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5b7819ULL, 0x100fe40000011617ULL, 0x000000ff176a7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff687819ULL, 0x000fe40000011617ULL, 0x0000ffff174e7812ULL, 0x000fe400078ec0ffULL,
0x00000028ff16723eULL, 0x000fc400020006ffULL, 0x00000027ff17723eULL, 0x000fe400020006ffULL,
0x000000ff2a147812ULL, 0x000fe200078ec0ffULL, 0x20000016ff627230ULL, 0x000fe20000004100ULL,
0x000000ff2e2e7812ULL, 0x000fe200078ec0ffULL, 0x20000017ff657230ULL, 0x000fe20000004100ULL,
0x0000004aff4a723eULL, 0x000fe400020006ffULL, 0x00000008ff157819ULL, 0x000fe40000011679ULL,
0x00000014ff14723eULL, 0x000fe200020006ffULL, 0x2000004aff557230ULL, 0x000fe20000004100ULL,
0x0000002eff16723eULL, 0x000fc400020006ffULL, 0x00000008ff177819ULL, 0x000fe4000001167aULL,
0x00000010ff427819ULL, 0x108fe40000011635ULL, 0x000000ff35727812ULL, 0x040fe400078ec0ffULL,
0x00000018ff717819ULL, 0x000fe40000011635ULL, 0x0000ffff35287812ULL, 0x000fe400078ec0ffULL,
0x00000015ff15723eULL, 0x000fc400020006ffULL, 0x0000004fff35723eULL, 0x000fe400020006ffULL,
0x0000005fff4f723eULL, 0x000fe200020006ffULL, 0x20000014ff5f7230ULL, 0x000fe20000004100ULL,
0x00000063ff4a723eULL, 0x000fe200020006ffULL, 0x20000016ff637230ULL, 0x000fe20000004100ULL,
0x00000017ff17723eULL, 0x000fe200020006ffULL, 0x20000035ff357230ULL, 0x000fe20000004100ULL,
0x000000ff64647812ULL, 0x000fe200078ec0ffULL, 0x2000004fff4f7230ULL, 0x000fe20000004100ULL,
0x000000ff60147812ULL, 0x000fe200078ec0ffULL, 0x20000015ff607230ULL, 0x000fe20000004100ULL,
0x00000008ff167819ULL, 0x000fe2000001167bULL, 0x2000004aff4a7230ULL, 0x000fe20000004100ULL,
0x00000050ff50723eULL, 0x000fc400020006ffULL, 0x00000047ff47723eULL, 0x000fe400020006ffULL,
0x0000004cff4c723eULL, 0x000fe200020006ffULL, 0x20000050ff577230ULL, 0x000fe20000004100ULL,
0x0000004bff4b723eULL, 0x000fe200020006ffULL, 0x20000047ff697230ULL, 0x000fe20000004100ULL,
0x00000064ff15723eULL, 0x000fe200020006ffULL, 0x20000017ff647230ULL, 0x000fe20000004100ULL,
0x00000018ff6b7819ULL, 0x000fe20000011634ULL, 0x2000004cff587230ULL, 0x000fe20000004100ULL,
0x00000014ff14723eULL, 0x000fe200020006ffULL, 0x2000004bff507230ULL, 0x000fe20000004100ULL,
0x00000016ff16723eULL, 0x000fc400020006ffULL, 0x00000008ff177819ULL, 0x000fe4000001167cULL,
0x00000010ff517819ULL, 0x000fe40000011634ULL, 0x000000ff346e7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff34437812ULL, 0x000fe400078ec0ffULL, 0x0000004dff34723eULL, 0x000fe400020006ffULL,
0x00000067ff4d723eULL, 0x000fe200020006ffULL, 0x20000014ff677230ULL, 0x000fe20000004100ULL,
0x0000006aff4c723eULL, 0x000fe200020006ffULL, 0x20000015ff6a7230ULL, 0x000fe20000004100ULL,
0x00000068ff4b723eULL, 0x000fe200020006ffULL, 0x20000016ff687230ULL, 0x000fe20000004100ULL,
0x0000006bff47723eULL, 0x000fe200020006ffULL, 0x20000034ff347230ULL, 0x000fe20000004100ULL,
0x00000017ff6b723eULL, 0x000fe200020006ffULL, 0x2000004dff4d7230ULL, 0x000fe20000004100ULL,
0x000000005d14783bULL, 0x000e620000000200ULL, 0x00000010ff5e7819ULL, 0x000fe2000001165eULL,
0x2000004cff4c7230ULL, 0x000fe20000004100ULL, 0x00000010ff5f7819ULL, 0x000fe2000001165fULL,
0x2000006bff6b7230ULL, 0x000fe20000004100ULL, 0x00000010ff627819ULL, 0x000fe20000011662ULL,
0x2000004bff4b7230ULL, 0x000fe20000004100ULL, 0x00000010ff637819ULL, 0x000fe20000011663ULL,
0x20000047ff477230ULL, 0x000fe20000004100ULL, 0x00000010ff267819ULL, 0x000fc40000011637ULL,
0x000000ff37787812ULL, 0x040fe400078ec0ffULL, 0x00000018ff777819ULL, 0x000fe40000011637ULL,
0x0000ffff37247812ULL, 0x000fe400078ec0ffULL, 0x000010545f5e7816ULL, 0x000fe4000000005eULL,
0x00000045ff37723eULL, 0x000fe400020006ffULL, 0x00001054635f7816ULL, 0x000fc40000000062ULL,
0x0000002fff2f723eULL, 0x000fe200020006ffULL, 0x20000037ff377230ULL, 0x000fe20000004100ULL,
0x000000ff6c6c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff6d6d7812ULL, 0x000fe400078ec0ffULL,
0x000000ff5b5b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff297819ULL, 0x000fe40000011636ULL,
0x000000ff36767812ULL, 0x000fc400078ec0ffULL, 0x00000018ff757819ULL, 0x000fe40000011636ULL,
0x0000ffff36277812ULL, 0x000fe200078ec0ffULL, 0x2000002fff367230ULL, 0x000fe20000004100ULL,
0x0000006cff6c723eULL, 0x000fe200020006ffULL, 0x0000002c14149231ULL, 0x082fe200003400ffULL,
0x0000006dff6d723eULL, 0x000fe200020006ffULL, 0x0000002c16169231ULL, 0x000fe200003400ffULL,
0x00000010ff367819ULL, 0x000fe20000011636ULL, 0x0000002d15159231ULL, 0x080fe200003400ffULL,
0x00000010ff687819ULL, 0x000fe20000011668ULL, 0x0000002d17179231ULL, 0x000fe200003400ffULL,
0x2000006cff6c7230ULL, 0x000fe20000004100ULL, 0x00000010ff347819ULL, 0x000fe20000011634ULL,
0x2000006dff6d7230ULL, 0x000fe20000004100ULL, 0x0000105436367816ULL, 0x000fc40000000068ULL,
0x00000010ff357819ULL, 0x000fe20000011635ULL, 0x0000005e143c723cULL, 0x000b62000004183cULL,
0x00000010ff6c7819ULL, 0x000fe4000001166cULL, 0x00000010ff6d7819ULL, 0x000fe4000001166dULL,
0x00000048ff48723eULL, 0x000fe400020006ffULL, 0x0000005bff5e723eULL, 0x020fe400020006ffULL,
0x00000008ff5b7819ULL, 0x000fe2000001165aULL, 0x20000048ff597230ULL, 0x000fe20000004100ULL,
0x00000010ff5a7819ULL, 0x000fe20000011637ULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x00000010ff377819ULL, 0x000fc4000001166bULL, 0x000010546c6c7816ULL, 0x000fe40000000034ULL,
0x000010545a377816ULL, 0x000fe40000000037ULL, 0x000010546d6d7816ULL, 0x000fe40000000035ULL,
0x0000006eff48723eULL, 0x000fe400020006ffULL, 0x00000008ff6e7819ULL, 0x000fe2000001167eULL,
0x000000361434723cULL, 0x040be20000041830ULL, 0x00000052ff52723eULL, 0x000fe200020006ffULL,
0x000000004030783bULL, 0x0202a20000000200ULL, 0x00000049ff49723eULL, 0x000fe200020006ffULL,
0x20000048ff487230ULL, 0x000fe20000004100ULL, 0x00000071ff45723eULL, 0x000fe200020006ffULL,
0x20000052ff567230ULL, 0x000fe20000004100ULL, 0x000000ff6f6f7812ULL, 0x000fe200078ec0ffULL,
0x0000006c1404723cULL, 0x000fe20000041804ULL, 0x0000006eff6e723eULL, 0x000fe200020006ffULL,
0x20000045ff457230ULL, 0x000fe20000004100ULL, 0x000000ff70717812ULL, 0x000fc400078ec0ffULL,
0x00000054ff52723eULL, 0x000fe200020006ffULL, 0x20000049ff547230ULL, 0x000fe20000004100ULL,
0x0000006fff6f723eULL, 0x000fe200020006ffULL, 0x2000006eff6e7230ULL, 0x000fe20000004100ULL,
0x00000071ff71723eULL, 0x000fe200020006ffULL, 0x20000052ff527230ULL, 0x000fe20000004100ULL,
0x00000072ff49723eULL, 0x000fe200020006ffULL, 0x2000006fff6f7230ULL, 0x000fe20000004100ULL,
0x00000008ff5d7819ULL, 0x000fe2000001167dULL, 0x20000071ff717230ULL, 0x000fe20000004100ULL,
0x00000008ff707819ULL, 0x000fe2000001167fULL, 0x20000049ff497230ULL, 0x000fe20000004100ULL,
0x00000008ff727819ULL, 0x000fc40000011680ULL, 0x00000010ff407819ULL, 0x002fe40000011659ULL,
0x00000041ff41723eULL, 0x000fe400020006ffULL, 0x00000010ff597819ULL, 0x000fe4000001166eULL,
0x00000075ff75723eULL, 0x000fe200020006ffULL, 0x20000041ff667230ULL, 0x000fe20000004100ULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x00000070ff70723eULL, 0x000fe200020006ffULL,
0x20000075ff2a7230ULL, 0x000fe20000004100ULL, 0x00000072ff72723eULL, 0x000fe200020006ffULL,
0x2000005dff5d7230ULL, 0x000fe20000004100ULL, 0x000000ff73737812ULL, 0x000fe200078ec0ffULL,
0x20000070ff707230ULL, 0x000fe20000004100ULL, 0x000000ff74747812ULL, 0x000fe200078ec0ffULL,
0x20000072ff727230ULL, 0x000fe20000004100ULL, 0x000000ff51517812ULL, 0x000fe200078ec0ffULL,
0x0000002c30309231ULL, 0x084fe200003400ffULL, 0x0000105440597816ULL, 0x000fe20000000059ULL,
0x0000002c32329231ULL, 0x000fe200003400ffULL, 0x00000010ff577819ULL, 0x000fe20000011657ULL,
0x0000002d31319231ULL, 0x080fe200003400ffULL, 0x00000010ff6f7819ULL, 0x000fe2000001166fULL,
0x0000002d33339231ULL, 0x000fe200003400ffULL, 0x00000010ff407819ULL, 0x000fc40000011656ULL,
0x00000010ff717819ULL, 0x000fe40000011671ULL, 0x00000053ff53723eULL, 0x000fe400020006ffULL,
0x00000073ff73723eULL, 0x000fe400020006ffULL, 0x00000074ff75723eULL, 0x000fe200020006ffULL,
0x20000053ff537230ULL, 0x000fe20000004100ULL, 0x00000051ff51723eULL, 0x000fe200020006ffULL,
0x20000073ff737230ULL, 0x000fe20000004100ULL, 0x000010546f567816ULL, 0x000fe20000000057ULL,
0x20000075ff757230ULL, 0x000fe20000004100ULL, 0x0000105471577816ULL, 0x000fe20000000040ULL,
0x20000051ff5a7230ULL, 0x000fe20000004100ULL, 0x00000010ff617819ULL, 0x000fc40000011661ULL,
0x00000010ff607819ULL, 0x000fe40000011660ULL, 0x00000010ff667819ULL, 0x000fe20000011666ULL,
0x00000056140c723cULL, 0x000f62000004180cULL, 0x00000010ff677819ULL, 0x000fe40000011667ULL,
0x000000ff42427812ULL, 0x000fe400078ec0ffULL, 0x00000010ff407819ULL, 0x000fe40000011655ULL,
0x00000010ff657819ULL, 0x000fc40000011665ULL, 0x00000010ff647819ULL, 0x000fe40000011664ULL,
0x00000010ff697819ULL, 0x000fe40000011669ULL, 0x00000010ff6a7819ULL, 0x000fe4000001166aULL,
0x00000010ff587819ULL, 0x000fe40000011658ULL, 0x00000010ff5d7819ULL, 0x000fe4000001165dULL,
0x00000008ff437819ULL, 0x000fc40000011643ULL, 0x00000010ff547819ULL, 0x000fe40000011654ULL,
0x00000010ff707819ULL, 0x000fe40000011670ULL, 0x00000010ff557819ULL, 0x000fe40000011672ULL,
0x0000105461607816ULL, 0x000fe40000000060ULL, 0x0000105467667816ULL, 0x000fe40000000066ULL,
0x00000042ff51723eULL, 0x000fc400020006ffULL, 0x0000105465617816ULL, 0x000fe40000000064ULL,
0x000010546a677816ULL, 0x000fe40000000069ULL, 0x0000105458587816ULL, 0x000fe4000000005dULL,
0x00000043ff42723eULL, 0x000fe200020006ffULL, 0x000000601438723cULL, 0x000f620000041838ULL,
0x0000105454547816ULL, 0x000fe40000000070ULL, 0x0000105440557816ULL, 0x000fe20000000055ULL,
0x20000042ff407230ULL, 0x000fe20000004100ULL, 0x00000010ff537819ULL, 0x000fc40000011653ULL,
0x00000010ff437819ULL, 0x000fe20000011652ULL, 0x000000661418723cULL, 0x040f620000041818ULL,
0x00000010ff737819ULL, 0x000fe20000011673ULL, 0x20000051ff527230ULL, 0x000fe20000004100ULL,
0x00000010ff757819ULL, 0x000fe40000011675ULL, 0x000000ff29297812ULL, 0x000fe400078ec0ffULL,
0x00000076ff2f723eULL, 0x000fe200020006ffULL, 0x000000581408723cULL, 0x000f620000041808ULL,
0x000000ff26267812ULL, 0x000fc400078ec0ffULL, 0x00000008ff747819ULL, 0x000fe20000011681ULL,
0x2000002fff2f7230ULL, 0x000fe20000004100ULL, 0x00000008ff767819ULL, 0x000fe40000011682ULL,
0x000000ff5c5c7812ULL, 0x000fe200078ec0ffULL, 0x000000541410723cULL, 0x000f620000041810ULL,
0x00000008ff4e7819ULL, 0x000fe4000001164eULL, 0x0000105473427816ULL, 0x000fe40000000053ULL,
0x0000105475437816ULL, 0x000fc40000000043ULL, 0x00000008ff287819ULL, 0x000fe40000011628ULL,
0x00000008ff277819ULL, 0x000fe40000011627ULL, 0x00000008ff247819ULL, 0x000fe20000011624ULL,
0x00000042303c723cULL, 0x000b62000004183cULL, 0x00000029ff29723eULL, 0x000fe400020006ffULL,
0x00000078ff41723eULL, 0x000fe400020006ffULL, 0x00000026ff26723eULL, 0x000fe200020006ffULL,
0x20000029ff297230ULL, 0x000fe20000004100ULL, 0x00000077ff77723eULL, 0x000fe200020006ffULL,
0x20000041ff417230ULL, 0x000fe20000004100ULL, 0x00000074ff74723eULL, 0x000fe200020006ffULL,
0x20000026ff437230ULL, 0x020fe20000004100ULL, 0x00000076ff76723eULL, 0x000fe200020006ffULL,
0x20000077ff2e7230ULL, 0x000fe20000004100ULL, 0x0000005cff5c723eULL, 0x000fe200020006ffULL,
0x20000074ff747230ULL, 0x000fe20000004100ULL, 0x0000005bff5b723eULL, 0x000fe200020006ffULL,
0x20000076ff767230ULL, 0x000fe20000004100ULL, 0x0000004eff4e723eULL, 0x000fe200020006ffULL,
0x2000005cff5c7230ULL, 0x000fe20000004100ULL, 0x00000028ff28723eULL, 0x000fe200020006ffULL,
0x2000005bff5b7230ULL, 0x000fe20000004100ULL, 0x00000027ff27723eULL, 0x000fe200020006ffULL,
0x2000004eff4e7230ULL, 0x000fe20000004100ULL, 0x00000024ff24723eULL, 0x000fe200020006ffULL,
0x20000028ff287230ULL, 0x000fe20000004100ULL, 0x00000010ff2f7819ULL, 0x000fe2000001162fULL,
0x20000027ff427230ULL, 0x000fe20000004100ULL, 0x00000010ff297819ULL, 0x000fe20000011629ULL,
0x20000024ff247230ULL, 0x000fe20000004100ULL, 0x00000010ff417819ULL, 0x000fc40000011641ULL,
0x00000010ff437819ULL, 0x000fe40000011643ULL, 0x00000010ff507819ULL, 0x000fe40000011650ULL,
0x00000010ff4f7819ULL, 0x000fe4000001164fULL, 0x00000010ff747819ULL, 0x000fe40000011674ULL,
0x00000010ff517819ULL, 0x000fe40000011676ULL, 0x00000010ff4d7819ULL, 0x000fc4000001164dULL,
0x00000010ff4c7819ULL, 0x000fe4000001164cULL, 0x00000010ff5c7819ULL, 0x000fe4000001165cULL,
0x00000010ff5d7819ULL, 0x000fe4000001165eULL, 0x00000010ff4a7819ULL, 0x000fe4000001164aULL,
0x00000010ff4b7819ULL, 0x000fe4000001164bULL, 0x00000010ff5b7819ULL, 0x000fc4000001165bULL,
0x00000010ff157819ULL, 0x000fe4000001164eULL, 0x00000010ff487819ULL, 0x000fe40000011648ULL,
0x00000010ff497819ULL, 0x000fe40000011649ULL, 0x00000010ff5a7819ULL, 0x000fe4000001165aULL,
0x00000010ff527819ULL, 0x000fe40000011652ULL, 0x00000010ff477819ULL, 0x000fc40000011647ULL,
0x00000010ff407819ULL, 0x000fe40000011640ULL, 0x00000010ff457819ULL, 0x000fe40000011645ULL,
0x00000010ff277819ULL, 0x000fe40000011628ULL, 0x00000010ff2a7819ULL, 0x000fe4000001162aULL,
0x00000010ff427819ULL, 0x000fe40000011642ULL, 0x00000010ff2e7819ULL, 0x000fc4000001162eULL,
0x00000010ff247819ULL, 0x000fe40000011624ULL, 0x0000105429287816ULL, 0x000fe4000000002fULL,
0x0000105443297816ULL, 0x000fe40000000041ULL, 0x0000105450507816ULL, 0x000fe40000000074ULL,
0x000010544f517816ULL, 0x000fe40000000051ULL, 0x000010545c5c7816ULL, 0x000fe2000000004dULL,
0x00000028300c723cULL, 0x000b62000004180cULL, 0x000010545d5d7816ULL, 0x000fc4000000004cULL,
0x000010544a147816ULL, 0x000fe4000000005bULL, 0x000010544b157816ULL, 0x000fe40000000015ULL,
0x000010545a487816ULL, 0x000fe20000000048ULL, 0x000000503038723cULL, 0x000b620000041838ULL,
0x0000105452497816ULL, 0x000fe40000000049ULL, 0x0000105447267816ULL, 0x000fe40000000040ULL,
0x0000105445277816ULL, 0x000fc40000000027ULL, 0x000010542a427816ULL, 0x000fe20000000042ULL,
0x0000005c3018723cULL, 0x000b620000041818ULL, 0x000010542e437816ULL, 0x000fce0000000024ULL,
0x000000143014723cULL, 0x040b700000041834ULL, 0x000000483004723cULL, 0x040b700000041804ULL,
0x000000263008723cULL, 0x040b700000041808ULL, 0x000000423010723cULL, 0x000b620000041810ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff267f8cULL, 0x020e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a000ffff7f8cULL, 0x000fe2000c80043fULL, 0x0000000225247810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4e7224ULL, 0x002fc400078e0027ULL, 0x0000000123237810ULL, 0x000fc80007ffe0ffULL,
0x0000001e2300720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xfffeb37000007947ULL, 0x000fea000383ffffULL, 0x000000ff1e00720cULL, 0x000fe20003f05270ULL,
0x000000ffff297224ULL, 0x000fe400078e0013ULL, 0x000000ffff287224ULL, 0x000fe400078e0012ULL,
0x000000ffff257224ULL, 0x008fe400078e000fULL, 0x000000ffff247224ULL, 0x000fe400078e000eULL,
0x000000ffff277224ULL, 0x000fe400078e0011ULL, 0x000000ffff267224ULL, 0x000fc400078e0010ULL,
0x000000ffff237224ULL, 0x000fe400078e000dULL, 0x000000ffff227224ULL, 0x000fe400078e000cULL,
0x000000ffff207224ULL, 0x000fe400078e000bULL, 0x000000ffff1e7224ULL, 0x000fe400078e000aULL,
0x000000ffff1d7224ULL, 0x000fe400078e0009ULL, 0x000000ffff127224ULL, 0x000fc400078e0008ULL,
0x000000ffff1c7224ULL, 0x000fe400078e0007ULL, 0x000000ffff137224ULL, 0x000fe400078e0006ULL,
0x000000ffff0f7224ULL, 0x000fe400078e0005ULL, 0x000000ffff0e7224ULL, 0x000fe200078e0004ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x0180000021007810ULL, 0x000fe20007ffe0ffULL,
0x000000c000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x000000ffff037224ULL, 0x000fe200078e0021ULL, 0x00015ff000047802ULL, 0x000fc40000000f00ULL,
0x0000734000007944ULL, 0x006fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000002100007308ULL, 0x000ee40000001000ULL, 0xbf80000000217423ULL, 0x008fc80000000021ULL,
0x800000ff21217221ULL, 0x000fc80000010100ULL, 0x0000002100007223ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006800ff047624ULL, 0x000fe400078e00ffULL,
0x00006900ff057624ULL, 0x000fca00078e00ffULL, 0x0000000604047981ULL, 0x0088e8000c1e9900ULL,
0x0000000000057919ULL, 0x010f240000000000ULL, 0x00000002ff037819ULL, 0x016fe40000011605ULL,
0x0000000805057811ULL, 0x000fe200078ff0ffULL, 0x0000000004007220ULL, 0x008fca0000410000ULL,
0x00001f0300037589ULL, 0x000e6800000e0000ULL, 0x00001f0500007589ULL, 0x000ea200000e0000ULL,
0x0000003c033c7220ULL, 0x042fe20000410000ULL, 0x0000003d033d7220ULL, 0x040fe20000410000ULL,
0x0000003803387220ULL, 0x040fe20000410000ULL, 0x0000003903397220ULL, 0x040fe20000410000ULL,
0x0000001803187220ULL, 0x040fe20000410000ULL, 0x0000001903197220ULL, 0x040fe20000410000ULL,
0x0000001403147220ULL, 0x040fe20000410000ULL, 0x0000001503157220ULL, 0x040fe20000410000ULL,
0x0000000e030e7220ULL, 0x040fe20000410000ULL, 0x0000000f030f7220ULL, 0x040fe20000410000ULL,
0x0000001203127220ULL, 0x040fe20000410000ULL, 0x0000001d031d7220ULL, 0x040fe20000410000ULL,
0x0000002203227220ULL, 0x040fe20000410000ULL, 0x0000002303237220ULL, 0x040fe20000410000ULL,
0x0000002603267220ULL, 0x040fe20000410000ULL, 0x0000002703277220ULL, 0x000fe20000410000ULL,
0x0000003e003e7220ULL, 0x044fe20000410000ULL, 0x0000003f003f7220ULL, 0x040fe20000410000ULL,
0x0000003a003a7220ULL, 0x040fe20000410000ULL, 0x0000003b003b7220ULL, 0x040fe20000410000ULL,
0x0000001a001a7220ULL, 0x040fe20000410000ULL, 0x0000001b001b7220ULL, 0x040fe20000410000ULL,
0x0000001600167220ULL, 0x040fe20000410000ULL, 0x0000001700177220ULL, 0x040fe20000410000ULL,
0x0000001300137220ULL, 0x040fe20000410000ULL, 0x0000001c001c7220ULL, 0x040fe20000410000ULL,
0x0000001e001e7220ULL, 0x040fe20000410000ULL, 0x0000002000207220ULL, 0x040fe20000410000ULL,
0x0000002400247220ULL, 0x040fe20000410000ULL, 0x0000002500257220ULL, 0x040fe20000410000ULL,
0x0000002800287220ULL, 0x040fe20000410000ULL, 0x0000002900297220ULL, 0x000fc20000410000ULL,
0x0000000000217919ULL, 0x000ee20000000000ULL, 0x00000000000579c3ULL, 0x000f220000002700ULL,
0x0000580000047ab9ULL, 0x000fc40000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x00000002ff047819ULL, 0x008fc60000011621ULL,
0x00000005040472a4ULL, 0x010fe2000f8e023fULL, 0x0000000221007812ULL, 0x040fe400078ec0ffULL,
0x0000000821057811ULL, 0x000fe200078ff0ffULL, 0x0000000804077824ULL, 0x000fe200078e00ffULL,
0x0000000400037211ULL, 0x000fe200078ff8ffULL, 0x0000000804087824ULL, 0x000fe200078e00ffULL,
0x0000000500067211ULL, 0x000fe200078ff8ffULL, 0x0000000805097824ULL, 0x000fe200078e00ffULL,
0x0000000203007810ULL, 0x040fe20007ffe0ffULL, 0x00000008040a7824ULL, 0x040fe200078e00ffULL,
0x0000000403057810ULL, 0x000fe20007ffe0ffULL, 0x00000008040b7824ULL, 0x000fe200078e00ffULL,
0xfffffff807047812ULL, 0x000fc400078ee203ULL, 0x0000000603037810ULL, 0x000fe40007ffe0ffULL,
0xfffffff809097812ULL, 0x000fe400078ee206ULL, 0xfffffff808067812ULL, 0x000fe400078ee200ULL,
0xfffffff80b087812ULL, 0x000fe200078ee203ULL, 0x0000000821037824ULL, 0x000fe200078e00ffULL,
0xfffffff80a077812ULL, 0x000fe400078ee205ULL, 0x0000a00002057811ULL, 0x000fc400078e58ffULL,
0x0000000803037812ULL, 0x000fe400078ec0ffULL, 0x0000003c3d00723eULL, 0x000fe200000010ffULL,
0x0000001004047824ULL, 0x100fe200078e0205ULL, 0x000000383902723eULL, 0x000fe200000010ffULL,
0x0000001009097824ULL, 0x000fe200078e0205ULL, 0x00000003ff0b7819ULL, 0x000fe20000011621ULL,
0x0000000104047824ULL, 0x000fe200078e0203ULL, 0x00005410000c7816ULL, 0x100fe20000000002ULL,
0x0000001006067824ULL, 0x100fe200078e0205ULL, 0x00007632000d7816ULL, 0x000fe20000000002ULL,
0x0000001007007824ULL, 0x100fe200078e0205ULL, 0x0000002021107810ULL, 0x000fe20007ffe0ffULL,
0x0000001008027824ULL, 0x000fc400078e0205ULL, 0x0000000c04007388ULL, 0x0007e20000000a00ULL,
0x00000003ff117819ULL, 0x000fe20000011610ULL, 0x00000001030a7824ULL, 0x040fe400078e0209ULL,
0x0000000103077824ULL, 0x040fe400078e0206ULL, 0x0000000103087824ULL, 0x000fe200078e0200ULL,
0x000000181900723eULL, 0x000fe200000010ffULL, 0x0000000103097824ULL, 0x000fe200078e0202ULL,
0x000000141502723eULL, 0x000fe400000010ffULL, 0x0000000e0f03723eULL, 0x000fe200000010ffULL,
0x000000010b047824ULL, 0x008fe200078e0221ULL, 0x00005410000e7816ULL, 0x100fe20000000002ULL,
0x00000001100c7824ULL, 0x000fe200078e0211ULL, 0x00007632000f7816ULL, 0x000fc40000000002ULL,
0x0000000704047812ULL, 0x000fe400078ec0ffULL, 0x000000070c0c7812ULL, 0x000fe200078ec0ffULL,
0x0000000e07007388ULL, 0x000fe20000000a00ULL, 0x0ffffff804067812ULL, 0x000fe400078ef821ULL,
0x000000121d04723eULL, 0x000fe400000010ffULL, 0x0ffffff80c0d7812ULL, 0x000fe200078ef810ULL,
0x00000010060c7824ULL, 0x000fe200078e0205ULL, 0x0000541003027816ULL, 0x000fc40000000004ULL,
0x0000763203037816ULL, 0x000fe20000000004ULL, 0x000000100d127824ULL, 0x000fe200078e0205ULL,
0x000000222300723eULL, 0x000fe400000010ffULL, 0x0000003a3b04723eULL, 0x000fe200000010ffULL,
0x0000000208007388ULL, 0x0007e20000000a00ULL, 0x0000001a1b05723eULL, 0x000fe400000010ffULL,
0x000000161706723eULL, 0x000fe400000010ffULL, 0x0000000721217812ULL, 0x000fc400078ec0ffULL,
0x0000000710107812ULL, 0x000fc800078ec0ffULL, 0x1ffffff810107812ULL, 0x000fe400078ef81fULL,
0x000000262702723eULL, 0x008fe400000010ffULL, 0x0000003e3f03723eULL, 0x000fe400000010ffULL,
0x00005410000e7816ULL, 0x140fe40000000002ULL, 0x00007632000f7816ULL, 0x000fe40000000002ULL,
0x0000541003027816ULL, 0x000fc40000000004ULL, 0x0000763203037816ULL, 0x000fe20000000004ULL,
0x0000000e09007388ULL, 0x000fe20000000a00ULL, 0x0000541005047816ULL, 0x140fe40000000006ULL,
0x0000763205057816ULL, 0x000fe20000000006ULL, 0x000000020a007388ULL, 0x0007e20000000a00ULL,
0x000000131c00723eULL, 0x000fc600000010ffULL, 0x0004000407007388ULL, 0x0009e20000000a00ULL,
0x0000001e2002723eULL, 0x008fe400000010ffULL, 0x000000242503723eULL, 0x000fe200000010ffULL,
0x0000000000057919ULL, 0x010ee20000002600ULL, 0x000000282904723eULL, 0x000fe400000010ffULL,
0x0000541000067816ULL, 0x140fe40000000002ULL, 0x0000763200077816ULL, 0x000fe40000000002ULL,
0x0000541003027816ULL, 0x000fc40000000004ULL, 0x0000763203037816ULL, 0x000fe20000000004ULL,
0x0004000608007388ULL, 0x000fe80000000a00ULL, 0x0004000209007388ULL, 0x0009e20000000a00ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000000000c0c7984ULL, 0x000ea20000000c00ULL,
0x0000000805007824ULL, 0x008fc600078e00ffULL, 0x0000000012147984ULL, 0x000ee20000000c00ULL,
0x0000000805057824ULL, 0x000fe200078e00ffULL, 0xfffffff8000b7812ULL, 0x000fc800078ee20bULL,
0xfffffff805117812ULL, 0x000fe400078ee211ULL, 0x000000040b0b7c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000411117c10ULL, 0x000fc6000ff3e0ffULL, 0x000000ffff007224ULL, 0x000fe200000e06ffULL,
0x00005a000b027a11ULL, 0x010fe200078048ffULL, 0x000000ffff057224ULL, 0x000fe200008e06ffULL,
0x00005a0011047a11ULL, 0x000fe400078248ffULL, 0x00005b000b037a11ULL, 0x000fe400000f4c00ULL,
0x1ffffff821007812ULL, 0x000fe400078ef81fULL, 0x00005b0011057a11ULL, 0x000fc600008f4c05ULL,
0x0000001000027825ULL, 0x000fc800078e0002ULL, 0x0000001010047825ULL, 0x000fe200078e0004ULL,
0x0000000c02007986ULL, 0x004fe8000c101d06ULL, 0x0000001404007986ULL, 0x008fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff1f7819ULL, 0x000fe20000011602ULL,
0xffffffffff307424ULL, 0x000fc600078e00ffULL, 0x0000001d1f00720cULL, 0x000fda0003f06070ULL,
0x0000000222048824ULL, 0x002fc800078e00ffULL, 0x0000640004048a24ULL, 0x000fc800078e021fULL,
0x0000600004048625ULL, 0x000fe200078e0005ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00006800ff347624ULL, 0x000fe200078e00ffULL, 0x0000000604308981ULL, 0x0002a2000c1e1900ULL,
0x00006900ff357624ULL, 0x000fca00078e00ffULL, 0x0000000634347981ULL, 0x000722000c1e9900ULL,
0x000001ff0600780cULL, 0x000fe20003f04070ULL, 0x0000008000007824ULL, 0x000fe400078e00ffULL,
0x0000004002327824ULL, 0x000fe200078e00ffULL, 0x01060000ff047f8cULL, 0x002e62000c80043fULL,
0x0000008031317824ULL, 0x000fc600078e00ffULL, 0x00000040000c7812ULL, 0x000fe200078ef832ULL,
0x0000003130177224ULL, 0x004fc800078e02ffULL, 0x0000071000000947ULL, 0x000fea0003800000ULL,
0x00000002ff187819ULL, 0x00afe40000011603ULL, 0x000000300e167812ULL, 0x000fe400078ec0ffULL,
0x0000000818197810ULL, 0x000fe20007ffe0ffULL, 0x000000010c067824ULL, 0x000fe200078e0218ULL,
0x00000010181a7810ULL, 0x040fe40007ffe0ffULL, 0x00000018181b7810ULL, 0x000fe20007ffe0ffULL,
0x000000010c077824ULL, 0x040fe200078e0219ULL, 0x0000000617157210ULL, 0x000fe20007f1e0ffULL,
0x000000010c067824ULL, 0x000fe200078e021aULL, 0x00002000020e7811ULL, 0x000fc400078e68ffULL,
0x0000000717147210ULL, 0x040fe20007f3e0ffULL, 0x000000010c077824ULL, 0x000fe200078e021bULL,
0x00000006170b7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff097224ULL, 0x000fe200000e06ffULL,
0x00005e0015117a11ULL, 0x000fe200078040ffULL, 0x000000ffff087224ULL, 0x000fe200008e06ffULL,
0x00005e0014107a11ULL, 0x000fe400078240ffULL, 0x0000000717137210ULL, 0x000fe40007f7e0ffULL,
0x000000321c067217ULL, 0x000fc40007800000ULL, 0x00005f0015157a11ULL, 0x000fe200000f4409ULL,
0x000000ffff097224ULL, 0x000fe200010e06ffULL, 0x00005e000b0a7a11ULL, 0x000fe200078040ffULL,
0x00000001060d7824ULL, 0x000fe200078e0a32ULL, 0x00005f0014147a11ULL, 0x000fe200008f4408ULL,
0x000000ffff087224ULL, 0x000fe200018e06ffULL, 0x0000000303077211ULL, 0x000fe400078fe8ffULL,
0x00005e0013127a11ULL, 0x000fe400078240ffULL, 0x00005f000b0b7a11ULL, 0x000fe200000f4409ULL,
0x0000000419097824ULL, 0x000fe200078e00ffULL, 0x0000001116067210ULL, 0x000fe20007f7e0ffULL,
0x000000041a117824ULL, 0x000fe200078e00ffULL, 0x00000003070f7812ULL, 0x000fc400078ec0ffULL,
0x00005f0013137a11ULL, 0x000fe200008f4408ULL, 0x000000ffff077224ULL, 0x000fe200018e0615ULL,
0x0000000d1800720cULL, 0x080fe40003f06070ULL, 0x0000000d1900720cULL, 0x080fe40003f26070ULL,
0x0ffffffc0f037812ULL, 0x000fe400078ef803ULL, 0xfffffffc09097812ULL, 0x000fe400078ee20fULL,
0x0000001610087210ULL, 0x080fe20007f7e0ffULL, 0x0000001003037824ULL, 0x100fe200078e020eULL,
0x000000160a0a7210ULL, 0x000fe20007f9e0ffULL, 0x0000001009107824ULL, 0x000fe200078e020eULL,
0x0000000d1a00720cULL, 0x080fe20003f46070ULL, 0x000000ffff097224ULL, 0x000fe200018e0614ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006037faeULL, 0x0003e2000c101c46ULL,
0x000000ffff0b7224ULL, 0x000fe200020e060bULL, 0x0000000d1b00720cULL, 0x040fe20003f86070ULL,
0x000000041b1b7824ULL, 0x000fe200078e00ffULL, 0x0000000008107faeULL, 0x0005e2000c901c46ULL,
0xfffffffc11117812ULL, 0x000fca00078ee20fULL, 0x0000001011117824ULL, 0x000fe200078e020eULL,
0x0000001612067210ULL, 0x002fc80007fbe0ffULL, 0x000000000a117faeULL, 0x0003e2000d101c46ULL,
0x0000002018087810ULL, 0x044fe40007ffe0ffULL, 0x0000002818097810ULL, 0x040fe40007ffe0ffULL,
0x0000003818107810ULL, 0x000fe20007ffe0ffULL, 0x000000010c037824ULL, 0x000fe200078e0208ULL,
0x0000000d0800720cULL, 0x080fe40003f66070ULL, 0x0000000d0900720cULL, 0x000fe40003f46070ULL,
0x0000000317157210ULL, 0x000fe20007f1e0ffULL, 0x000000010c0a7824ULL, 0x002fe200078e0209ULL,
0xfffffffc1b037812ULL, 0x000fc400078ee20fULL, 0x00005e0015147a11ULL, 0x000fe200078c40ffULL,
0x000000ffff077224ULL, 0x000fe200000e06ffULL, 0x00000030180b7810ULL, 0x000fe20007ffe0ffULL,
0x0000001003037824ULL, 0x000fe200078e020eULL, 0x0000000d1000720cULL, 0x080fe40003f06070ULL,
0x00005f0015157a11ULL, 0x000fe200030f4407ULL, 0x000000ffff077224ULL, 0x000fe200028e0613ULL,
0x0000000a170a7210ULL, 0x000fe40007fbe0ffULL, 0x0000000d0b00720cULL, 0x000fe20003f26070ULL,
0x000000010c0d7824ULL, 0x000fe200078e020bULL, 0x0000000006037faeULL, 0x0003e2000e101c46ULL,
0x000000ffff137224ULL, 0x000fe200028e06ffULL, 0x00005e000a127a11ULL, 0x000fe200078a40ffULL,
0x000000010c0c7824ULL, 0x000fe200078e0210ULL, 0x0000000d17117210ULL, 0x000fc40007f9e0ffULL,
0x00005f000a137a11ULL, 0x000fe400028f4413ULL, 0x0000000c170d7210ULL, 0x000fe20007fde0ffULL,
0x0000000409067824ULL, 0x002fe400078e00ffULL, 0x0000000408037824ULL, 0x000fe400078e00ffULL,
0x000000040b077824ULL, 0x000fe200078e00ffULL, 0xfffffffc06067812ULL, 0x100fe200078ee20fULL,
0x0000000410087824ULL, 0x000fe200078e00ffULL, 0xfffffffc03037812ULL, 0x100fe200078ee20fULL,
0x000000ffff0b7224ULL, 0x000fe200020e06ffULL, 0xfffffffc07077812ULL, 0x100fe200078ee20fULL,
0x000000ffff097224ULL, 0x000fe200030e06ffULL, 0xfffffffc08087812ULL, 0x000fe200078ee20fULL,
0x00000010060f7824ULL, 0x100fe200078e020eULL, 0x0000001614067210ULL, 0x080fe20007fbe0ffULL,
0x0000001003037824ULL, 0x100fe200078e020eULL, 0x00005e00110a7a11ULL, 0x000fe200078840ffULL,
0x0000001007107824ULL, 0x100fe200078e020eULL, 0x00005e000d0c7a11ULL, 0x000fe200078c40ffULL,
0x00000010080e7824ULL, 0x000fe200078e020eULL, 0x00005f00110b7a11ULL, 0x000fe200020f440bULL,
0x000000ffff077224ULL, 0x000fe200028e0615ULL, 0x0000001612087210ULL, 0x000fc40007fbe0ffULL,
0x00005f000d0d7a11ULL, 0x000fe400030f4409ULL, 0x000000160a0a7210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff097224ULL, 0x000fe200028e0613ULL, 0x000000160c0c7210ULL, 0x000fe20007fbe0ffULL,
0x0000000006037faeULL, 0x0003e4000d901c46ULL, 0x000000ffff0b7224ULL, 0x000fe400020e060bULL,
0x000000ffff0d7224ULL, 0x000fe200028e060dULL, 0x00000000080f7faeULL, 0x0003e8000d101c46ULL,
0x000000000a107faeULL, 0x0003e8000c901c46ULL, 0x000000000c0e7faeULL, 0x0003e2000c101c46ULL,
0x0000065000007947ULL, 0x000fea0003800000ULL, 0x0000000c03067211ULL, 0x04afe400078ff0ffULL,
0x0000000803167811ULL, 0x000fc400078ff0ffULL, 0x0000000617067210ULL, 0x000fe40007f1e0ffULL,
0x0000001003077811ULL, 0x040fe400078ff0ffULL, 0x0000001803097811ULL, 0x040fe200078ff0ffULL,
0x000000ffff267224ULL, 0x000fe200000e06ffULL, 0x00005e0006257a11ULL, 0x000fe200078040ffULL,
0x000000010c087824ULL, 0x040fe200078e0207ULL, 0x0000000303157211ULL, 0x040fe200078fe8ffULL,
0x000000010c0a7824ULL, 0x000fe200078e0209ULL, 0x00005f0006267a11ULL, 0x000fe200000f4426ULL,
0x000000010c067824ULL, 0x000fe200078e0216ULL, 0x00000020030b7811ULL, 0x040fe200078ff0ffULL,
0x0000000416167824ULL, 0x000fe200078e00ffULL, 0x00000028030f7811ULL, 0x000fc400078ff0ffULL,
0x0000000617247210ULL, 0x000fe20007fde0ffULL, 0x0000000407067824ULL, 0x000fe200078e00ffULL,
0x0000003003117811ULL, 0x000fe200078ff0ffULL, 0x0000000409077824ULL, 0x000fe200078e00ffULL,
0x0000003803137811ULL, 0x000fe200078ff0ffULL, 0x000000010c0d7824ULL, 0x040fe200078e020bULL,
0x0000000315157812ULL, 0x000fe200078ec0ffULL, 0x000000040f097824ULL, 0x000fe200078e00ffULL,
0x0000000817147210ULL, 0x040fe20007fbe0ffULL, 0x000000010c107824ULL, 0x000fe200078e020fULL,
0x0000000a17217210ULL, 0x000fe20007f1e0ffULL, 0x000000040b087824ULL, 0x000fe200078e00ffULL,
0x0000200002197811ULL, 0x000fe200078e68ffULL, 0x000000010c127824ULL, 0x000fe200078e0211ULL,
0xfffffffc07077812ULL, 0x100fe200078ee215ULL, 0x00000004110a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc06067812ULL, 0x000fe200078ee215ULL, 0x000000ffff0f7224ULL, 0x000fe200030e06ffULL,
0x00005e0024237a11ULL, 0x000fe200078c40ffULL, 0x000000010c0c7824ULL, 0x000fe200078e0213ULL,
0x0000000d171b7210ULL, 0x000fe20007f3e0ffULL, 0x00000004130b7824ULL, 0x000fe200078e00ffULL,
0xfffffffc09097812ULL, 0x000fe200078ee215ULL, 0x0000001007117824ULL, 0x000fe200078e0219ULL,
0xfffffffc08087812ULL, 0x100fe200078ee215ULL, 0x000000ffff077224ULL, 0x000fe200000e06ffULL,
0xfffffffc0a0a7812ULL, 0x000fc400078ee215ULL, 0x00005f0024247a11ULL, 0x000fe200030f440fULL,
0x00000010060f7824ULL, 0x100fe200078e0219ULL, 0x00000010171a7210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff067224ULL, 0x000fe200008e06ffULL, 0x00000012170d7210ULL, 0x040fe20007f7e0ffULL,
0x000000100a187824ULL, 0x100fe200078e0219ULL, 0x0000000c170c7210ULL, 0x000fe20007f9e0ffULL,
0x0000001009177824ULL, 0x000fe200078e0219ULL, 0x0ffffffc15107812ULL, 0x000fe200078ef803ULL,
0x000000ffff137224ULL, 0x000fe200018e06ffULL, 0x00005e0021207a11ULL, 0x000fc400078040ffULL,
0xfffffffc16037812ULL, 0x000fe200078ee215ULL, 0x0000001008167824ULL, 0x000fe200078e0219ULL,
0x00005e001b097a11ULL, 0x000fe200078240ffULL, 0x000000ffff087224ULL, 0x000fe200028e06ffULL,
0xfffffffc0b0b7812ULL, 0x000fe200078ee215ULL, 0x0000001010287824ULL, 0x100fe200078e0219ULL,
0x000000300e277812ULL, 0x000fe200078ec0ffULL, 0x0000001003037824ULL, 0x100fe200078e0219ULL,
0x00005e00140a7a11ULL, 0x000fe200078a40ffULL, 0x000000100b197824ULL, 0x000fe200078e0219ULL,
0x00005f0021217a11ULL, 0x000fe200000f4407ULL, 0x000000ffff077224ULL, 0x000fe200010e06ffULL,
0x00005f001b1b7a11ULL, 0x000fe200008f4406ULL, 0x000000ffff157224ULL, 0x000fe200020e06ffULL,
0x00005e001a107a11ULL, 0x000fc400078240ffULL, 0x0000002527067210ULL, 0x000fe40007f1e0ffULL,
0x00005f00140b7a11ULL, 0x000fe400028f4408ULL, 0x00005e000d127a11ULL, 0x000fe400078440ffULL,
0x00005e000c147a11ULL, 0x000fe400078640ffULL, 0x00005f001a1a7a11ULL, 0x000fe200008f4407ULL,
0x000000ffff077224ULL, 0x000fe200000e0626ULL, 0x0000002327087210ULL, 0x000fc40007f1e0ffULL,
0x00005f000d137a11ULL, 0x000fe400010f4413ULL, 0x00005f000c157a11ULL, 0x000fe200018f4415ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006287faeULL, 0x0003e2000b901c46ULL,
0x0000000a270a7210ULL, 0x040fe40007f3e0ffULL, 0x00000020270c7210ULL, 0x040fe40007f5e0ffULL,
0x00000009270e7210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff097224ULL, 0x000fe200000e0624ULL,
0x0000001027107210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200008e060bULL,
0x0000001227127210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff0d7224ULL, 0x000fe200010e0621ULL,
0x0000001427147210ULL, 0x000fe20007f1e0ffULL, 0x0000000008037faeULL, 0x0003e4000b901c46ULL,
0x000000ffff137224ULL, 0x000fc400028e0613ULL, 0x000000000a0f7faeULL, 0x0005e2000b901c46ULL,
0x000000ffff157224ULL, 0x000fc600000e0615ULL, 0x000000000c117faeULL, 0x0007e2000b901c46ULL,
0x000000ffff0f7224ULL, 0x004fe400018e061bULL, 0x000000ffff117224ULL, 0x008fc600020e061aULL,
0x000000000e167faeULL, 0x0003e8000b901c46ULL, 0x0000000010177faeULL, 0x0003e8000b901c46ULL,
0x0000000012187faeULL, 0x0003e8000b901c46ULL, 0x0000000014197faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000067805ULL, 0x002fc40000015200ULL,
0x01060400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fc40007804805ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x0000000806087210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e07ULL, 0x003d09000800780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400800780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011409ULL,
0x0000000803037211ULL, 0x000fca00078110ffULL, 0x000000ffff087224ULL, 0x000fca00000e0609ULL,
0x0000000203037819ULL, 0x000fc80000001208ULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01060400ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e640000000000ULL, 0x0000002002037824ULL, 0x002fca00078e0203ULL,
0x00000003ff047819ULL, 0x000fe40000011603ULL, 0x0000000f03037812ULL, 0x000fe400078ec0ffULL,
0x1ffffffe04047812ULL, 0x000fe400078ec0ffULL, 0x0000000103057810ULL, 0x040fe20007ffe0ffULL,
0x0000002003097824ULL, 0x040fe400078e00ffULL, 0x0000000103067824ULL, 0x040fe400078e0204ULL,
0x0000000104077824ULL, 0x040fe200078e0205ULL, 0x0000001004047810ULL, 0x000fe20007ffe0ffULL,
0x0000002003087824ULL, 0x000fe200078e00ffULL, 0x0000001f06067812ULL, 0x000fc400078ec0ffULL,
0x0000001f07077812ULL, 0x000fe200078ec0ffULL, 0x0000000103107824ULL, 0x000fe200078e0204ULL,
0x000001e008067812ULL, 0x000fe200078ee206ULL, 0x0000000105047824ULL, 0x000fe200078e0204ULL,
0x000001e009077812ULL, 0x000fe200078ee207ULL, 0x0000002003057824ULL, 0x040fe200078e00ffULL,
0x0000001f10107812ULL, 0x000fe200078ec0ffULL, 0x00000000060c7984ULL, 0x000e62000000cc00ULL,
0x0000002003037824ULL, 0x000fe200078e00ffULL, 0x0000001f04047812ULL, 0x000fe400078ec0ffULL,
0x0000000007087984ULL, 0x000ea2000000cc00ULL, 0x000001e005107812ULL, 0x000fc400078ee210ULL,
0x000001e003047812ULL, 0x000fe200078ee204ULL, 0x000000ffff147224ULL, 0x002fe400078e000cULL,
0x000000ffff157224ULL, 0x000fe400078e000eULL, 0x000000ffff177224ULL, 0x004fe400078e000aULL,
0x000000ffff167224ULL, 0x000fe400078e0008ULL, 0x000000ffff0a7224ULL, 0x000fe400078e0009ULL,
0x000000ffff087224ULL, 0x000fe200078e000dULL, 0x0000001406007388ULL, 0x000fe2000000cc00ULL,
0x000000ffff097224ULL, 0x000fca00078e000fULL, 0x0000000807007388ULL, 0x000fe8000000cc00ULL,
0x0000000004087984ULL, 0x000e68000000cc00ULL, 0x00000000100c7984ULL, 0x000ea2000000cc00ULL,
0x000000ffff1b7224ULL, 0x002fe400078e000aULL, 0x000000ffff1a7224ULL, 0x000fc400078e0008ULL,
0x000000ffff0a7224ULL, 0x000fe400078e0009ULL, 0x000000ffff187224ULL, 0x004fe400078e000cULL,
0x000000ffff197224ULL, 0x000fe400078e000eULL, 0x000000ffff087224ULL, 0x000fe400078e000dULL,
0x000000ffff097224ULL, 0x000fe200078e000fULL, 0x0000001810007388ULL, 0x0003e8000000cc00ULL,
0x0000000804007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01060000ff087f8cULL, 0x002e62000c80043fULL, 0x000000ffff0a7224ULL, 0x000fc600078e00ffULL,
0x0000000000047805ULL, 0x000fc80000015200ULL, 0x01060400ff037984ULL, 0x000ea40000000800ULL,
0x8000000003ff7812ULL, 0x006fc40007804809ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604067210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000600780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400600780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011407ULL,
0x0000000603037211ULL, 0x000fca00078110ffULL, 0x000000ffff067224ULL, 0x000fca00000e0607ULL,
0x0000000203037819ULL, 0x000fc80000001206ULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01060400ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff1e00720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0x0000640022337a24ULL, 0x000fe200078e02ffULL,
0x3d80000034347820ULL, 0x010fe20000410000ULL, 0x0001068802357811ULL, 0x000fe200078e18ffULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0xffffffff1e367810ULL, 0x000fe40007ffe0ffULL,
0x0001060802377811ULL, 0x000fc600078e28ffULL, 0x00000100383a7824ULL, 0x000fe200078e0232ULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x0000003a1c00720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x01cfea0003800000ULL, 0x000000ffff3b7224ULL, 0x000fe200078e0039ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fc4000001ff00ULL, 0x000000013c047810ULL, 0x020fe20007ffe0ffULL,
0x00000d8000007945ULL, 0x000fe20003800000ULL, 0x000000ffff3d7224ULL, 0x000fe200078e003cULL,
0x000000013b397812ULL, 0x000fe200078e0cffULL, 0x0000003130457224ULL, 0x010fe200078e02ffULL,
0x0000003804057211ULL, 0x040fe200078ff0ffULL, 0x000000ffff3c7224ULL, 0x000fe200078e0004ULL,
0x000000040400780cULL, 0x000fc40003f06070ULL, 0x0000000105067810ULL, 0x040fe20007ffe0ffULL,
0x0000010005467824ULL, 0x000fe200078e0232ULL, 0x0000000304557812ULL, 0x000fe400078ec0ffULL,
0x0000001e0600720cULL, 0x000fe40003f26070ULL, 0x0000004046057812ULL, 0x000fca00078ec0ffULL,
0x0000000100407824ULL, 0x000fcc00078e0205ULL, 0x000006b000009947ULL, 0x000fea0003800000ULL,
0x00000002ff417819ULL, 0x002fe20000011603ULL, 0x0000000202487824ULL, 0x000fe200078e0239ULL,
0x000000461c057217ULL, 0x000fe40007800000ULL, 0x00000010414f7810ULL, 0x040fe20007ffe0ffULL,
0x0000000141047824ULL, 0x040fe200078e0240ULL, 0x0000000841477810ULL, 0x000fe20007ffe0ffULL,
0x0000000105467824ULL, 0x000fe200078e0a46ULL, 0x0000001841507810ULL, 0x000fe20007ffe0ffULL,
0x000000014f077824ULL, 0x100fe200078e0240ULL, 0x00000004453e7210ULL, 0x000fe20007f3e0ffULL,
0x0000000147067824ULL, 0x000fe200078e0240ULL, 0x0000002041517810ULL, 0x000fe20007ffe0ffULL,
0x00000004474a7824ULL, 0x000fe200078e00ffULL, 0x0000000745157210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff3f7224ULL, 0x000fe200008e06ffULL, 0x0000000645177210ULL, 0x000fc40007f5e0ffULL,
0x00005e003e047a11ULL, 0x000fe200078240ffULL, 0x000000ffff167224ULL, 0x000fe200018e06ffULL,
0x00005e0015147a11ULL, 0x000fe200078640ffULL, 0x000000ffff077224ULL, 0x000fe200010e06ffULL,
0x00005e0017067a11ULL, 0x000fe400078440ffULL, 0x00005f0015157a11ULL, 0x000fe200018f4416ULL,
0x0000000150167824ULL, 0x000fe200078e0240ULL, 0x0000002841527810ULL, 0x040fe40007ffe0ffULL,
0x0000003041537810ULL, 0x000fc40007ffe0ffULL, 0x0000003841547810ULL, 0x000fe40007ffe0ffULL,
0x00005f003e057a11ULL, 0x000fe200008f443fULL, 0x00000001523e7824ULL, 0x100fe200078e0240ULL,
0x00005f0017077a11ULL, 0x000fe200010f4407ULL, 0x0000000151177824ULL, 0x100fe200078e0240ULL,
0x0000001645447210ULL, 0x000fe20007f3e0ffULL, 0x00000001533f7824ULL, 0x100fe200078e0240ULL,
0x000000464100720cULL, 0x000fe20003f46070ULL, 0x0000000154407824ULL, 0x000fe200078e0240ULL,
0x0000001745427210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff177224ULL, 0x000fe200008e06ffULL,
0x0000003e45417210ULL, 0x000fc40007fde0ffULL, 0x00000003033e7211ULL, 0x000fe400078fe8ffULL,
0x00005e0044167a11ULL, 0x000fe200078240ffULL, 0x000000ffff4d7224ULL, 0x000fe200030e06ffULL,
0x0000003f45437210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff3f7224ULL, 0x000fe200028e06ffULL,
0x0000004045457210ULL, 0x000fe20007f7e0ffULL, 0x0000000455407824ULL, 0x000fe200078e00ffULL,
0x000000033e4e7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff4c7224ULL, 0x000fe200020e06ffULL,
0x00005f0044177a11ULL, 0x000fe200008f4417ULL, 0x000000ffff4b7224ULL, 0x000fe200018e06ffULL,
0x000000464700720cULL, 0x000fc40003f26070ULL, 0x0000200048487811ULL, 0x000fe400078e60ffULL,
0x0ffffffc4e497812ULL, 0x100fe400078ef803ULL, 0xfffffffc40477812ULL, 0x000fe400078ee203ULL,
0xfffffffc4a4a7812ULL, 0x000fe200078ee24eULL, 0x0000001049497824ULL, 0x000fe200078e0248ULL,
0x00005e00423e7a11ULL, 0x000fe200078a40ffULL, 0x0000001047047825ULL, 0x000fe200078e0004ULL,
0x00005e0045447a11ULL, 0x000fc400078840ffULL, 0x00005f00423f7a11ULL, 0x000fe200028f443fULL,
0x000000104a4a7824ULL, 0x000fe200078e0248ULL, 0x00005e0041407a11ULL, 0x000fe200078a40ffULL,
0x0000001047067825ULL, 0x000fe200078e0006ULL, 0x00005e0043427a11ULL, 0x000fe200078640ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004497faeULL, 0x0003e2000d101c46ULL,
0x00005f0041417a11ULL, 0x000fe400028f444dULL, 0x00005f0043437a11ULL, 0x000fe200018f444cULL,
0x00000000064a7faeULL, 0x0005e2000c901c46ULL, 0x00005f0045457a11ULL, 0x000fe200020f444bULL,
0x00000004524b7824ULL, 0x000fe200078e00ffULL, 0x000000464f00720cULL, 0x080fe20003f26070ULL,
0x00000004534c7824ULL, 0x000fe200078e00ffULL, 0x000000465000720cULL, 0x000fc40003f46070ULL,
0x000000465100720cULL, 0x080fe20003f66070ULL, 0x0000000450497824ULL, 0x002fe200078e00ffULL,
0x000000465200720cULL, 0x080fe20003f86070ULL, 0x0000001047047825ULL, 0x000fe200078e0014ULL,
0x000000465300720cULL, 0x080fe40003fa6070ULL, 0x000000465400720cULL, 0x040fe20003fc6070ULL,
0x000000044f467824ULL, 0x000fe200078e00ffULL, 0xfffffffc49497812ULL, 0x100fe200078ee24eULL,
0x00000004514a7824ULL, 0x004fe200078e00ffULL, 0xfffffffc4b4b7812ULL, 0x100fe200078ee24eULL,
0x0000000454547824ULL, 0x000fe200078e00ffULL, 0xfffffffc46467812ULL, 0x000fe200078ee24eULL,
0x0000001049497824ULL, 0x000fe200078e0248ULL, 0xfffffffc4a4a7812ULL, 0x000fe200078ee24eULL,
0x0000001047067825ULL, 0x000fe200078e0016ULL, 0xfffffffc4c4c7812ULL, 0x000fc400078ee24eULL,
0xfffffffc544e7812ULL, 0x000fe200078ee24eULL, 0x0000001046467824ULL, 0x100fe400078e0248ULL,
0x000000104a4a7824ULL, 0x000fe400078e0248ULL, 0x0000001047147825ULL, 0x000fe200078e003eULL,
0x0000000004467faeULL, 0x0003e6000c901c46ULL, 0x000000104b4b7824ULL, 0x000fe200078e0248ULL,
0x0000000006497faeULL, 0x0003e2000d101c46ULL, 0x0000001047167825ULL, 0x000fc600078e0040ULL,
0x00000000144a7faeULL, 0x0003e2000d901c46ULL, 0x000000104c4c7824ULL, 0x000fe400078e0248ULL,
0x00000010473e7825ULL, 0x040fe200078e0042ULL, 0x00000000164b7faeULL, 0x0003e6000e101c46ULL,
0x000000104e487824ULL, 0x000fe200078e0248ULL, 0x000000003e4c7faeULL, 0x0003e2000e901c46ULL,
0x0000001047407825ULL, 0x000fca00078e0044ULL, 0x0000000040487faeULL, 0x0003e2000f101c46ULL,
0x000005f000007947ULL, 0x000fea0003800000ULL, 0x0000000803167811ULL, 0x002fe200078ff0ffULL,
0x0000000455517824ULL, 0x000fe200078e00ffULL, 0x0000004003047211ULL, 0x040fe400078ff0ffULL,
0x0000001003177811ULL, 0x000fe200078ff0ffULL, 0x0000000116057824ULL, 0x040fe200078e0240ULL,
0x0000000445157210ULL, 0x000fe20007f3e0ffULL, 0x0000000416467824ULL, 0x000fe200078e00ffULL,
0x00000018033e7811ULL, 0x000fe200078ff0ffULL, 0x0000000417477824ULL, 0x000fe200078e00ffULL,
0x0000000545077210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff057224ULL, 0x000fe200008e06ffULL,
0x00005e0015047a11ULL, 0x000fe200078240ffULL, 0x000000043e487824ULL, 0x000fe200078e00ffULL,
0x0000002803427811ULL, 0x000fe200078ff0ffULL, 0x000000ffff147224ULL, 0x000fe200010e06ffULL,
0x00005e0007067a11ULL, 0x000fc400078440ffULL, 0x00005f0015057a11ULL, 0x000fe200008f4405ULL,
0x00000004424a7824ULL, 0x000fe200078e00ffULL, 0x00005f0007077a11ULL, 0x000fe200010f4414ULL,
0x0000000202147824ULL, 0x000fe200078e0239ULL, 0x0000000303157211ULL, 0x040fe400078fe8ffULL,
0x00000020033f7811ULL, 0x000fe400078ff0ffULL, 0x00002000144c7811ULL, 0x000fe200078e60ffULL,
0x0000000117147824ULL, 0x100fe200078e0240ULL, 0x0000003003437811ULL, 0x040fe200078ff0ffULL,
0x0000000142177824ULL, 0x100fe200078e0240ULL, 0x0000003803447811ULL, 0x000fe200078ff0ffULL,
0x000000013f167824ULL, 0x100fe200078e0240ULL, 0x0000000315417812ULL, 0x000fe200078ec0ffULL,
0x000000013e157824ULL, 0x100fe200078e0240ULL, 0x0000001445427210ULL, 0x000fe20007f7e0ffULL,
0x000000043f497824ULL, 0x000fe200078e00ffULL, 0xfffffffc46467812ULL, 0x100fe200078ee241ULL,
0x00000004434b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc47477812ULL, 0x100fe200078ee241ULL,
0x00000004444d7824ULL, 0x000fe200078e00ffULL, 0xfffffffc48487812ULL, 0x100fe200078ee241ULL,
0x00000001433e7824ULL, 0x100fe200078e0240ULL, 0xfffffffc49497812ULL, 0x100fe200078ee241ULL,
0x00000001443f7824ULL, 0x000fe200078e0240ULL, 0x0000001545407210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff157224ULL, 0x000fe200018e06ffULL, 0xfffffffc4a4a7812ULL, 0x100fe200078ee241ULL,
0x0000001046467824ULL, 0x100fe200078e024cULL, 0xfffffffc4b4b7812ULL, 0x100fe200078ee241ULL,
0x0000001047477824ULL, 0x100fe200078e024cULL, 0xfffffffc4d4d7812ULL, 0x000fe200078ee241ULL,
0x0000001048487824ULL, 0x100fe200078e024cULL, 0x0ffffffc41447812ULL, 0x100fe200078ef803ULL,
0x0000001049497824ULL, 0x100fe200078e024cULL, 0x0000001645507210ULL, 0x040fe20007f3e0ffULL,
0x000000104a4a7824ULL, 0x100fe200078e024cULL, 0x0000001745417210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff177224ULL, 0x000fe200010e06ffULL, 0xfffffffc51517812ULL, 0x000fe200078ee203ULL,
0x0000001044527824ULL, 0x100fe200078e024cULL, 0x0000003e45437210ULL, 0x000fe20007f9e0ffULL,
0x000000104b4b7824ULL, 0x000fe200078e024cULL, 0x00005e0040167a11ULL, 0x000fe200078440ffULL,
0x000000ffff4f7224ULL, 0x000fe200018e06ffULL, 0x00005e0042147a11ULL, 0x000fe200078c40ffULL,
0x0000001051047825ULL, 0x000fe200078e0004ULL, 0x0000003f45457210ULL, 0x000fc40007fbe0ffULL,
0x00005f0040177a11ULL, 0x000fe200010f4417ULL, 0x000000ffff3f7224ULL, 0x000fe200008e06ffULL,
0x00005e00503e7a11ULL, 0x000fe200078240ffULL, 0x000000104d4c7824ULL, 0x000fe200078e024cULL,
0x00005f0042157a11ULL, 0x000fe200030f4415ULL, 0x000000ffff4e7224ULL, 0x000fe200020e06ffULL,
0x00005e0041407a11ULL, 0x000fe200078440ffULL, 0x000000ffff4d7224ULL, 0x000fe200028e06ffULL,
0x00005e0043427a11ULL, 0x000fe200078640ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004527faeULL, 0x0003e2000b901c46ULL, 0x00005e0045447a11ULL, 0x000fc400078840ffULL,
0x00005f00503f7a11ULL, 0x000fe400008f443fULL, 0x00005f0041417a11ULL, 0x000fe400010f444fULL,
0x00005f0043437a11ULL, 0x000fe400018f444eULL, 0x00005f0045457a11ULL, 0x000fe200020f444dULL,
0x0000001051047825ULL, 0x002fc800078e0006ULL, 0x0000001051067825ULL, 0x040fe200078e0014ULL,
0x0000000004467faeULL, 0x0003e6000b901c46ULL, 0x0000001051147825ULL, 0x040fe200078e0016ULL,
0x0000000006477faeULL, 0x0003e6000b901c46ULL, 0x0000001051167825ULL, 0x040fe200078e003eULL,
0x0000000014487faeULL, 0x0003e6000b901c46ULL, 0x00000010513e7825ULL, 0x040fe200078e0040ULL,
0x0000000016497faeULL, 0x0003e6000b901c46ULL, 0x0000001051407825ULL, 0x040fe200078e0042ULL,
0x000000003e4a7faeULL, 0x0003e6000b901c46ULL, 0x0000001051427825ULL, 0x000fe200078e0044ULL,
0x00000000404b7faeULL, 0x0003e8000b901c46ULL, 0x00000000424c7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000035500780cULL, 0x000fe20003f25270ULL,
0x000000a000007945ULL, 0x000fd80003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x000000021f1f7810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff307424ULL, 0x000fc600078e00ffULL,
0x0000001d1f00720cULL, 0x000fda0003f26070ULL, 0x0000004000001947ULL, 0x000fea0003800000ULL,
0x0000000233047824ULL, 0x002fe400078e021fULL, 0x00000004ff057424ULL, 0x000fc800078e00ffULL,
0x0000600004047625ULL, 0x000fca00078e0005ULL, 0x0000000604307981ULL, 0x000324000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000ffff3e7224ULL, 0x002fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xfffffff803047812ULL, 0x020fe200078ec0ffULL, 0x00000002023f7824ULL, 0x000fe200078e023bULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000013e4a7810ULL, 0x000fe40007ffe0ffULL,
0x0000000704047812ULL, 0x000fe400078ef803ULL, 0x000020003f3f7811ULL, 0x000fe400078e60ffULL,
0x00000001ff057819ULL, 0x000fe20000011604ULL, 0x0000000404077824ULL, 0x000fe200078e00ffULL,
0x0000000703147812ULL, 0x000fc600078ec0ffULL, 0x0000000105067824ULL, 0x040fe200078e023eULL,
0x00000008144d7812ULL, 0x000fe200078ef803ULL, 0x0000000105057824ULL, 0x000fc600078e024aULL,
0xfffffffc07067812ULL, 0x000fe200078ee206ULL, 0x000000204d147824ULL, 0x000fe200078e00ffULL,
0xfffffffc07077812ULL, 0x000fc600078ee205ULL, 0x0000001006067824ULL, 0x100fe400078e023fULL,
0x0000001007077824ULL, 0x000fc600078e023fULL, 0x000000000640783bULL, 0x0002a80000000200ULL,
0x000000000744783bULL, 0x0006a20000000200ULL, 0x000000043d067824ULL, 0x002fc800078e023eULL,
0x0000000206047824ULL, 0x000fe200078e00ffULL, 0x0000002003067810ULL, 0x000fc80007ffe0ffULL,
0x0000000403057211ULL, 0x000fe400078fe0ffULL, 0xfffffff806067812ULL, 0x000fe400078ec0ffULL,
0x0000000204497810ULL, 0x000fe20007ffe0ffULL, 0x000000014d057824ULL, 0x000fe200078e0205ULL,
0x0000000706487812ULL, 0x000fc800078ef803ULL, 0xffffffe014057812ULL, 0x000fe200078ee205ULL,
0x00000004484b7824ULL, 0x040fe200078e00ffULL, 0x00000001ff067819ULL, 0x000fe20000011648ULL,
0x0000000448487824ULL, 0x000fe400078e00ffULL, 0x0000001005057824ULL, 0x000fe400078e00ffULL,
0x0000000106077824ULL, 0x008fe200078e023eULL, 0x000000023e3e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000106507824ULL, 0x000fe200078e024aULL, 0x000000000514783bULL, 0x0002e40000000200ULL,
0xfffffffc4b077812ULL, 0x000fc400078ee207ULL, 0x00000018ff047819ULL, 0x104fe40000011643ULL,
0x0000ffff434c7812ULL, 0x000fe400078ec0ffULL, 0x0000004903057211ULL, 0x002fe400078fe0ffULL,
0x00000004ff49723eULL, 0x000fe400020006ffULL, 0x00000010ff047819ULL, 0x000fe20000011643ULL,
0x000000014d4b7824ULL, 0x000fe200078e0205ULL, 0x000000ff43437812ULL, 0x000fe200078ec0ffULL,
0x000000204d4d7824ULL, 0x000fe200078e00ffULL, 0x000000ff04057812ULL, 0x000fe200078ec0ffULL,
0x20000049ff497230ULL, 0x000fe20000004100ULL, 0x00000008ff047819ULL, 0x000fe2000001164cULL,
0x00000010074c7824ULL, 0x000fe200078e023fULL, 0x00000005ff05723eULL, 0x000fc400020006ffULL,
0x00000004ff04723eULL, 0x000fe400020006ffULL, 0x00000043ff43723eULL, 0x000fe200020006ffULL,
0x20000005ff057230ULL, 0x000fe20000004100ULL, 0xffffffe04d4b7812ULL, 0x000fe200078ee24bULL,
0x20000004ff047230ULL, 0x000fe20000004100ULL, 0x00000010ff497819ULL, 0x000fe20000011649ULL,
0x20000043ff437230ULL, 0x000fe20000004100ULL, 0x00000010ff057819ULL, 0x000fe20000011605ULL,
0x000000104b4d7824ULL, 0x000fe200078e00ffULL, 0x00000010ff047819ULL, 0x000fc40000011604ULL,
0x00000010ff437819ULL, 0x000fe40000011643ULL, 0x00001054494b7816ULL, 0x000fe40000000005ULL,
0x00001054044a7816ULL, 0x000fe40000000043ULL, 0x000000004d04783bULL, 0x000e620000000200ULL,
0x00000010ff437819ULL, 0x100fe40000011647ULL, 0x0000ffff47527812ULL, 0x000fe200078ec0ffULL,
0x000000004c4c783bULL, 0x000ea20000000200ULL, 0x00000018ff497819ULL, 0x000fe20000011647ULL,
0x0000004a1410723cULL, 0x008b620000041810ULL, 0x000000ff43517812ULL, 0x000fc400078ec0ffULL,
0x000000ff47477812ULL, 0x000fe400078ec0ffULL, 0x00000008ff437819ULL, 0x000fe40000011652ULL,
0x00000049ff49723eULL, 0x000fe400020006ffULL, 0x00000047ff47723eULL, 0x000fe400020006ffULL,
0x00000051ff51723eULL, 0x000fe200020006ffULL, 0x20000049ff497230ULL, 0x000fe20000004100ULL,
0x00000043ff43723eULL, 0x000fe200020006ffULL, 0x20000047ff477230ULL, 0x000fe20000004100ULL,
0xfffffffc48507812ULL, 0x000fe200078ee250ULL, 0x20000051ff517230ULL, 0x000fe20000004100ULL,
0x00000010ff497819ULL, 0x000fe20000011649ULL, 0x20000043ff437230ULL, 0x000fe20000004100ULL,
0x00000010ff477819ULL, 0x000fe20000011647ULL, 0x0000001050487824ULL, 0x000fe200078e023fULL,
0x00000010ff517819ULL, 0x000fc40000011651ULL, 0x00000010ff437819ULL, 0x000fe40000011643ULL,
0x0000105449577816ULL, 0x000fe40000000051ULL, 0x0000105443567816ULL, 0x000fe20000000047ULL,
0x000000004848783bULL, 0x020ee20000000200ULL, 0x00000018ff3f7819ULL, 0x100fe40000011640ULL,
0x00000010ff437819ULL, 0x000fe40000011640ULL, 0x000000ff40477812ULL, 0x040fe200078ec0ffULL,
0x000000560410723cULL, 0x002be20000041810ULL, 0x0000ffff405d7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff507819ULL, 0x100fe40000011641ULL, 0x00000018ff407819ULL, 0x000fe40000011641ULL,
0x000000ff41517812ULL, 0x040fe400078ec0ffULL, 0x0000ffff415e7812ULL, 0x000fe400078ec0ffULL,
0x0000003fff41723eULL, 0x000fe400020006ffULL, 0x00000010ff647819ULL, 0x004fc4000001164cULL,
0x00000018ff557819ULL, 0x000fe2000001164cULL, 0x20000041ff5b7230ULL, 0x000fe20000004100ULL,
0x000000ff4c657812ULL, 0x040fe400078ec0ffULL, 0x0000ffff4c7e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff527819ULL, 0x100fe40000011642ULL, 0x00000018ff537819ULL, 0x000fe40000011642ULL,
0x000000ff42547812ULL, 0x000fc400078ec0ffULL, 0x0000ffff42617812ULL, 0x000fe400078ec0ffULL,
0x00000018ff4c7819ULL, 0x000fe40000011644ULL, 0x00000010ff667819ULL, 0x100fe4000001164dULL,
0x00000018ff677819ULL, 0x000fe4000001164dULL, 0x000000ff4d687812ULL, 0x040fe400078ec0ffULL,
0x0000ffff4d7f7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff6f7819ULL, 0x100fe4000001164fULL,
0x00000018ff6d7819ULL, 0x000fe4000001164fULL, 0x000000ff4f707812ULL, 0x040fe400078ec0ffULL,
0x0000ffff4f577812ULL, 0x020fe400078ec0ffULL, 0x00000047ff47723eULL, 0x000fe400020006ffULL,
0x00000040ff42723eULL, 0x000fc400020006ffULL, 0x00000010ff4f7819ULL, 0x000fe20000011644ULL,
0x20000047ff587230ULL, 0x000fe20000004100ULL, 0x000000ff444d7812ULL, 0x040fe200078ec0ffULL,
0x20000042ff5f7230ULL, 0x000fe20000004100ULL, 0x0000ffff44717812ULL, 0x000fe400078ec0ffULL,
0x00000018ff447819ULL, 0x000fe40000011645ULL, 0x00000010ff757819ULL, 0x100fe40000011646ULL,
0x00000018ff597819ULL, 0x000fc40000011646ULL, 0x000000ff465a7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff46827812ULL, 0x000fe400078ec0ffULL, 0x0000004cff46723eULL, 0x000fe400020006ffULL,
0x000000ff43417812ULL, 0x000fe400078ec0ffULL, 0x00000008ff4c7819ULL, 0x000fe2000001165dULL,
0x20000046ff467230ULL, 0x000fe20000004100ULL, 0x0000004dff47723eULL, 0x000fc400020006ffULL,
0x00000044ff42723eULL, 0x000fe400020006ffULL, 0x0000005aff5a723eULL, 0x000fe200020006ffULL,
0x20000047ff477230ULL, 0x000fe20000004100ULL, 0x00000041ff4d723eULL, 0x000fe200020006ffULL,
0x20000042ff437230ULL, 0x000fe20000004100ULL, 0x0000004cff4c723eULL, 0x000fe200020006ffULL,
0x2000005aff417230ULL, 0x000fe20000004100ULL, 0x000000ff4f4f7812ULL, 0x000fe200078ec0ffULL,
0x2000004dff5a7230ULL, 0x000fe20000004100ULL, 0x00000010ff6c7819ULL, 0x000fc4000001164eULL,
0x00000018ff697819ULL, 0x000fe4000001164eULL, 0x000000ff4e6a7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff4e807812ULL, 0x000fe400078ec0ffULL, 0x00000059ff42723eULL, 0x000fe200020006ffULL,
0x2000004cff597230ULL, 0x000fe20000004100ULL, 0x000000ff454e7812ULL, 0x000fe400078ec0ffULL,
0x0000004fff4f723eULL, 0x000fe200020006ffULL, 0x20000042ff427230ULL, 0x000fe20000004100ULL,
0x00000008ff4d7819ULL, 0x000fc4000001165eULL, 0x000000ff50507812ULL, 0x000fe200078ec0ffULL,
0x2000004fff737230ULL, 0x000fe20000004100ULL, 0x0000004eff44723eULL, 0x000fe400020006ffULL,
0x00000010ff5b7819ULL, 0x000fe4000001165bULL, 0x00000010ff5a7819ULL, 0x000fe2000001165aULL,
0x20000044ff447230ULL, 0x000fe20000004100ULL, 0x000000ff52527812ULL, 0x000fe400078ec0ffULL,
0x00000008ff4e7819ULL, 0x000fc40000011661ULL, 0x00000069ff69723eULL, 0x000fe400020006ffULL,
0x00000010ff587819ULL, 0x000fe40000011658ULL, 0x00000010ff597819ULL, 0x000fe20000011659ULL,
0x20000069ff6e7230ULL, 0x000fe20000004100ULL, 0x00000051ff51723eULL, 0x000fe400020006ffULL,
0x0000004dff4d723eULL, 0x000fe400020006ffULL, 0x00000050ff50723eULL, 0x000fe200020006ffULL,
0x20000051ff5c7230ULL, 0x000fe20000004100ULL, 0x000000ff664f7812ULL, 0x000fe200078ec0ffULL,
0x2000004dff5d7230ULL, 0x000fe20000004100ULL, 0x00000067ff4c723eULL, 0x000fe200020006ffULL,
0x20000050ff5e7230ULL, 0x000fe20000004100ULL, 0x000010545b5b7816ULL, 0x000fc4000000005aULL,
0x00000053ff53723eULL, 0x000fe200020006ffULL, 0x2000004cff6b7230ULL, 0x000fe20000004100ULL,
0x00000054ff54723eULL, 0x000fe400020006ffULL, 0x00000052ff52723eULL, 0x000fe200020006ffULL,
0x20000053ff637230ULL, 0x000fe20000004100ULL, 0x0000004eff4e723eULL, 0x000fe200020006ffULL,
0x20000054ff607230ULL, 0x000fe20000004100ULL, 0x00001054595a7816ULL, 0x000fe20000000058ULL,
0x20000052ff627230ULL, 0x000fe20000004100ULL, 0x0000006aff6a723eULL, 0x000fe200020006ffULL,
0x2000004eff617230ULL, 0x000fe20000004100ULL, 0x00000008ff587819ULL, 0x000fc40000011680ULL,
0x0000004fff69723eULL, 0x000fe200020006ffULL, 0x0000005a140c723cULL, 0x000be2000004180cULL,
0x0000006dff4c723eULL, 0x000fe200020006ffULL, 0x2000006aff6d7230ULL, 0x000fe20000004100ULL,
0x00000058ff58723eULL, 0x000fe200020006ffULL, 0x20000069ff6a7230ULL, 0x000fe20000004100ULL,
0x000000ff64647812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5c7819ULL, 0x000fe4000001165cULL,
0x00000010ff5d7819ULL, 0x000fc4000001165dULL, 0x00000008ff4e7819ULL, 0x000fe4000001167eULL,
0x00000008ff697819ULL, 0x000fe4000001167fULL, 0x000000ff6c6c7812ULL, 0x000fe400078ec0ffULL,
0x000000ff6f6f7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5f7819ULL, 0x000fe4000001165fULL,
0x00000010ff597819ULL, 0x000fe2000001165eULL, 0x20000058ff5e7230ULL, 0x000fe20000004100ULL,
0x00000008ff577819ULL, 0x000fc40000011657ULL, 0x00000008ff4d7819ULL, 0x000fe20000011671ULL,
0x2000004cff717230ULL, 0x000fe20000004100ULL, 0x00000010ff637819ULL, 0x000fe40000011663ULL,
0x00000010ff5b7819ULL, 0x020fe40000011662ULL, 0x00000010ff607819ULL, 0x000fe40000011660ULL,
0x00000010ff617819ULL, 0x000fe40000011661ULL, 0x00000064ff66723eULL, 0x000fc400020006ffULL,
0x000010545d587816ULL, 0x000fe4000000005cULL, 0x00000010ff567819ULL, 0x008fe20000011648ULL,
0x20000066ff667230ULL, 0x000fe20000004100ULL, 0x00000055ff55723eULL, 0x000fe400020006ffULL,
0x00000065ff65723eULL, 0x000fe400020006ffULL, 0x00000068ff68723eULL, 0x000fe200020006ffULL,
0x20000055ff677230ULL, 0x000fe20000004100ULL, 0x00000070ff70723eULL, 0x000fe200020006ffULL,
0x20000065ff657230ULL, 0x000fe20000004100ULL, 0x0000004eff64723eULL, 0x000fe200020006ffULL,
0x20000068ff687230ULL, 0x000fe20000004100ULL, 0x00000069ff69723eULL, 0x000fe200020006ffULL,
0x20000070ff707230ULL, 0x000fe20000004100ULL, 0x0000006cff6c723eULL, 0x000fe200020006ffULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x0000006fff6f723eULL, 0x000fe200020006ffULL,
0x20000069ff697230ULL, 0x000fe20000004100ULL, 0x000010545f597816ULL, 0x000fe20000000059ULL,
0x2000006cff6c7230ULL, 0x000fe20000004100ULL, 0x00000057ff5c723eULL, 0x000fe200020006ffULL,
0x2000006fff6f7230ULL, 0x000fe20000004100ULL, 0x0000004dff4d723eULL, 0x000fc400020006ffULL,
0x00001054635b7816ULL, 0x000fe2000000005bULL, 0x2000005cff5c7230ULL, 0x000fe20000004100ULL,
0x00001054615a7816ULL, 0x000fe20000000060ULL, 0x2000004dff727230ULL, 0x000fe20000004100ULL,
0x000000ff56567812ULL, 0x000fe200078ec0ffULL, 0x000000581408723cULL, 0x000be20000041808ULL,
0x000000ff75757812ULL, 0x000fe400078ec0ffULL, 0x00000008ff4d7819ULL, 0x000fe40000011682ULL,
0x00000010ff677819ULL, 0x000fc40000011667ULL, 0x00000056ff58723eULL, 0x020fe200020006ffULL,
0x0000005a142c723cULL, 0x000b62000004182cULL, 0x00000010ff657819ULL, 0x000fe40000011665ULL,
0x00000010ff577819ULL, 0x000fe40000011666ULL, 0x00000010ff647819ULL, 0x000fe40000011664ULL,
0x00000010ff6b7819ULL, 0x000fe2000001166bULL, 0x20000058ff5a7230ULL, 0x020fe20000004100ULL,
0x00000010ff687819ULL, 0x000fc40000011668ULL, 0x00000010ff597819ULL, 0x000fe4000001166aULL,
0x00000010ff697819ULL, 0x000fe40000011669ULL, 0x00000010ff6e7819ULL, 0x000fe4000001166eULL,
0x00000010ff6d7819ULL, 0x000fe4000001166dULL, 0x00000010ff5f7819ULL, 0x000fe4000001166cULL,
0x00000010ff5e7819ULL, 0x000fc4000001165eULL, 0x00000010ff717819ULL, 0x000fe40000011671ULL,
0x00000010ff707819ULL, 0x000fe40000011670ULL, 0x00000010ff5d7819ULL, 0x000fe4000001166fULL,
0x00000010ff5c7819ULL, 0x000fe4000001165cULL, 0x00000075ff53723eULL, 0x000fe400020006ffULL,
0x0000004dff4d723eULL, 0x000fc400020006ffULL, 0x0000105467577816ULL, 0x000fe20000000057ULL,
0x20000053ff537230ULL, 0x000fe20000004100ULL, 0x0000105464567816ULL, 0x000fe20000000065ULL,
0x2000004dff547230ULL, 0x000fe20000004100ULL, 0x000010546b597816ULL, 0x000fe40000000059ULL,
0x0000105469587816ULL, 0x000fe40000000068ULL, 0x000010546e5f7816ULL, 0x000fe2000000005fULL,
0x000000561428723cULL, 0x000f620000041828ULL, 0x000010545e5e7816ULL, 0x000fc4000000006dULL,
0x00001054715d7816ULL, 0x000fe4000000005dULL, 0x000010545c5c7816ULL, 0x000fe40000000070ULL,
0x00000010ff747819ULL, 0x000fe20000011645ULL, 0x000000581424723cULL, 0x000f620000041824ULL,
0x0000ffff45817812ULL, 0x000fe400078ec0ffULL, 0x00000010ff427819ULL, 0x000fe40000011642ULL,
0x00000010ff417819ULL, 0x000fc40000011641ULL, 0x00000010ff547819ULL, 0x000fe20000011654ULL,
0x0000005e1420723cULL, 0x040f620000041820ULL, 0x000000ff74747812ULL, 0x000fe400078ec0ffULL,
0x00000008ff4c7819ULL, 0x000fe40000011681ULL, 0x00000018ff767819ULL, 0x000fe40000011648ULL,
0x000000ff48777812ULL, 0x000fe200078ec0ffULL, 0x0000005c1418723cULL, 0x000b620000041818ULL,
0x00000010ff457819ULL, 0x000fc40000011649ULL, 0x00000018ff787819ULL, 0x000fe40000011649ULL,
0x000000ff49797812ULL, 0x000fe400078ec0ffULL, 0x00000010ff157819ULL, 0x020fe40000011653ULL,
0x00000010ff407819ULL, 0x100fe4000001164aULL, 0x00000018ff7a7819ULL, 0x000fe4000001164aULL,
0x000000ff4a7b7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff3f7819ULL, 0x100fe4000001164bULL,
0x00000018ff7c7819ULL, 0x000fe4000001164bULL, 0x000000ff4b7d7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff48487812ULL, 0x000fe400078ec0ffULL, 0x0000ffff49497812ULL, 0x000fe400078ec0ffULL,
0x0000ffff4a4a7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff4b4b7812ULL, 0x000fe400078ec0ffULL,
0x0000105442157816ULL, 0x000fe40000000015ULL, 0x0000105454147816ULL, 0x000fe40000000041ULL,
0x00000074ff74723eULL, 0x000fe400020006ffULL, 0x0000004cff4c723eULL, 0x000fe400020006ffULL,
0x00000010ff467819ULL, 0x000fe20000011646ULL, 0x20000074ff757230ULL, 0x000fe20000004100ULL,
0x00000010ff737819ULL, 0x000fe20000011673ULL, 0x2000004cff747230ULL, 0x000fe20000004100ULL,
0x00000008ff487819ULL, 0x000fe20000011648ULL, 0x00000014042c723cULL, 0x000b62000004182cULL,
0x000000ff45457812ULL, 0x000fc400078ec0ffULL, 0x00000008ff497819ULL, 0x000fe40000011649ULL,
0x000000ff40407812ULL, 0x000fe400078ec0ffULL, 0x00000008ff4a7819ULL, 0x000fe4000001164aULL,
0x000000ff3f3f7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff4b7819ULL, 0x000fe4000001164bULL,
0x0000105446737816ULL, 0x000fc40000000073ULL, 0x00000076ff52723eULL, 0x000fe400020006ffULL,
0x00000077ff55723eULL, 0x000fe400020006ffULL, 0x00000078ff51723eULL, 0x000fe200020006ffULL,
0x20000052ff527230ULL, 0x000fe20000004100ULL, 0x00000079ff50723eULL, 0x000fe200020006ffULL,
0x20000055ff557230ULL, 0x000fe20000004100ULL, 0x0000007aff4c723eULL, 0x000fe200020006ffULL,
0x20000051ff517230ULL, 0x000fe20000004100ULL, 0x0000007bff4d723eULL, 0x000fe200020006ffULL,
0x20000050ff507230ULL, 0x000fe20000004100ULL, 0x0000007cff7c723eULL, 0x000fe200020006ffULL,
0x2000004cff4c7230ULL, 0x000fe20000004100ULL, 0x0000007dff7d723eULL, 0x000fe200020006ffULL,
0x2000004dff4d7230ULL, 0x000fe20000004100ULL, 0x00000048ff48723eULL, 0x000fe200020006ffULL,
0x2000007cff4f7230ULL, 0x000fe20000004100ULL, 0x00000045ff45723eULL, 0x000fe200020006ffULL,
0x2000007dff4e7230ULL, 0x000fe20000004100ULL, 0x00000049ff49723eULL, 0x000fe200020006ffULL,
0x20000048ff487230ULL, 0x000fe20000004100ULL, 0x00000040ff46723eULL, 0x000fe200020006ffULL,
0x20000045ff567230ULL, 0x000fe20000004100ULL, 0x0000004aff4a723eULL, 0x000fe200020006ffULL,
0x20000049ff407230ULL, 0x000fe20000004100ULL, 0x0000003fff3f723eULL, 0x000fe200020006ffULL,
0x20000046ff467230ULL, 0x000fe20000004100ULL, 0x0000004bff14723eULL, 0x020fe200020006ffULL,
0x2000004aff4a7230ULL, 0x000fe20000004100ULL, 0x000000043e00780cULL, 0x000fe20003f25270ULL,
0x2000003fff3f7230ULL, 0x000fe20000004100ULL, 0x00000010ff477819ULL, 0x000fe20000011647ULL,
0x20000014ff147230ULL, 0x000fe20000004100ULL, 0x00000010ff727819ULL, 0x000fc40000011672ULL,
0x00000010ff437819ULL, 0x000fe40000011643ULL, 0x00000010ff447819ULL, 0x000fe40000011644ULL,
0x00000010ff457819ULL, 0x000fe40000011675ULL, 0x00000010ff747819ULL, 0x000fe40000011674ULL,
0x00000010ff527819ULL, 0x000fe40000011652ULL, 0x00000010ff557819ULL, 0x000fc40000011655ULL,
0x00000010ff497819ULL, 0x000fe4000001165aULL, 0x00000010ff487819ULL, 0x000fe40000011648ULL,
0x00000010ff517819ULL, 0x000fe40000011651ULL, 0x00000010ff417819ULL, 0x000fe40000011656ULL,
0x00000010ff507819ULL, 0x000fe40000011650ULL, 0x00000010ff407819ULL, 0x000fc40000011640ULL,
0x00000010ff4b7819ULL, 0x000fe4000001164cULL, 0x00000010ff467819ULL, 0x000fe40000011646ULL,
0x00000010ff4d7819ULL, 0x000fe4000001164dULL, 0x00000010ff4a7819ULL, 0x000fe4000001164aULL,
0x00000010ff4f7819ULL, 0x000fe4000001164fULL, 0x00000010ff157819ULL, 0x000fc4000001163fULL,
0x00000010ff4e7819ULL, 0x000fe4000001164eULL, 0x00000010ff147819ULL, 0x000fe40000011614ULL,
0x0000105472727816ULL, 0x000fe40000000047ULL, 0x0000105443457816ULL, 0x000fe40000000045ULL,
0x0000105474447816ULL, 0x000fe40000000044ULL, 0x0000105452497816ULL, 0x000fe20000000049ULL,
0x00000072040c723cULL, 0x000b62000004180cULL, 0x0000105448487816ULL, 0x000fc40000000055ULL,
0x0000105451417816ULL, 0x000fe40000000041ULL, 0x0000105440407816ULL, 0x000fe40000000050ULL,
0x000010544b4b7816ULL, 0x000fe20000000046ULL, 0x000000440408723cULL, 0x000b620000041808ULL,
0x000010544a4a7816ULL, 0x000fe4000000004dULL, 0x000010544f157816ULL, 0x000fe40000000015ULL,
0x0000105414147816ULL, 0x000fc6000000004eULL, 0x000000480428723cULL, 0x040b700000041828ULL,
0x000000400424723cULL, 0x040b700000041824ULL, 0x0000004a0420723cULL, 0x040b700000041820ULL,
0x000000140418723cULL, 0x000b620000041818ULL, 0x0000001000009944ULL, 0x000fe20003c00000ULL,
0xffffe7d000007947ULL, 0x000fcc000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff3b7224ULL, 0x000fe200078e0039ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffd90000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x000000340c0c7220ULL, 0x0a0fe20000410000ULL, 0x000000340d0d7220ULL, 0x080fe20000410000ULL,
0x000000340e067220ULL, 0x080fe20000410000ULL, 0x000000340f077220ULL, 0x080fe20000410000ULL,
0x0000003408087220ULL, 0x080fe20000410000ULL, 0x0000003409097220ULL, 0x080fe20000410000ULL,
0x000000342c0e7220ULL, 0x080fe20000410000ULL, 0x000000342d0f7220ULL, 0x080fe20000410000ULL,
0x0000003420207220ULL, 0x080fe20000410000ULL, 0x0000003421217220ULL, 0x080fe20000410000ULL,
0x0000003418047220ULL, 0x080fe20000410000ULL, 0x00000034122c7220ULL, 0x080fe20000410000ULL,
0x00000034132d7220ULL, 0x080fe20000410000ULL, 0x000000340a147220ULL, 0x080fe20000410000ULL,
0x000000340b157220ULL, 0x080fe20000410000ULL, 0x0000003428127220ULL, 0x080fe20000410000ULL,
0x0000003429137220ULL, 0x080fe20000410000ULL, 0x000000342a287220ULL, 0x080fe20000410000ULL,
0x000000342b297220ULL, 0x080fe20000410000ULL, 0x0000003419057220ULL, 0x080fe20000410000ULL,
0x000000341a3d7220ULL, 0x080fe20000410000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e000cULL,
0x000000342e2e7220ULL, 0x080fe20000410000ULL, 0x000000ffff0b7224ULL, 0x000fe200078e000dULL,
0x000000342f2f7220ULL, 0x080fe20000410000ULL, 0x0000003410107220ULL, 0x080fe20000410000ULL,
0x0000003411117220ULL, 0x080fe20000410000ULL, 0x0000003424167220ULL, 0x080fe20000410000ULL,
0x0000003425177220ULL, 0x080fe20000410000ULL, 0x00000034262a7220ULL, 0x080fe20000410000ULL,
0x00000034272b7220ULL, 0x080fe20000410000ULL, 0x00000034223b7220ULL, 0x080fe20000410000ULL,
0x00000034233c7220ULL, 0x080fe20000410000ULL, 0x000000341b3e7220ULL, 0x000fe20000410000ULL,
0x000000ffff0c7224ULL, 0x000fc400078e0008ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0009ULL,
0x000000ffff187224ULL, 0x000fe400078e0020ULL, 0x000000ffff197224ULL, 0x000fe400078e0021ULL,
0x000000ffff1a7224ULL, 0x000fe200078e0004ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000035087f8cULL, 0x0002a2000c80043fULL, 0x000000ffff247224ULL, 0x000fe400078e002eULL,
0x000000ffff257224ULL, 0x000fc400078e002fULL, 0x000000ffff267224ULL, 0x000fe400078e002cULL,
0x000000ffff277224ULL, 0x000fe400078e002dULL, 0x000000ffff1b7224ULL, 0x000fe400078e0005ULL,
0x000000ffff207224ULL, 0x000fe400078e0006ULL, 0x000000ffff217224ULL, 0x000fe400078e0007ULL,
0x000000ffff227224ULL, 0x000fc400078e0014ULL, 0x000000ffff237224ULL, 0x000fe400078e0015ULL,
0x000000ffff2c7224ULL, 0x000fe400078e003bULL, 0x000000ffff2d7224ULL, 0x000fe400078e003cULL,
0x000000ffff2e7224ULL, 0x000fe400078e003dULL, 0x000000ffff2f7224ULL, 0x000fc400078e003eULL,
0x0000000000047805ULL, 0x006fca0000015200ULL, 0x0000040035067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fc40007804809ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff157224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x0000000604147210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09001400780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401400780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011407ULL, 0x0000001406067211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000206067819ULL, 0x000fc80000001207ULL,
0x000000060000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000115157810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040035067984ULL, 0x000e640000000800ULL, 0x8000000006ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000403157824ULL, 0x000fe200078e00ffULL,
0x000000363800720cULL, 0x000fc80003f05270ULL, 0xfffffff015147812ULL, 0x000fca00078ec0ffULL,
0x0000008002147824ULL, 0x000fca00078e0214ULL, 0x0104000014047984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x0000000203087824ULL, 0x000fe400078e00ffULL,
0x000000011c3a7824ULL, 0x000fc600078e0a3aULL, 0x0000000608087812ULL, 0x000fc800078ec0ffULL,
0x0000000108097812ULL, 0x040fe400078efcffULL, 0x00000008083b7812ULL, 0x040fe400078efcffULL,
0x0000003a0900720cULL, 0x080fe40003f26070ULL, 0x0000001008097812ULL, 0x000fe400078efcffULL,
0x0000003a3b00720cULL, 0x080fe40003f06070ULL, 0x0000003a0900720cULL, 0x000fc40003fc6070ULL,
0x00000011083b7812ULL, 0x040fe400078efcffULL, 0x0000001808097812ULL, 0x040fe400078efcffULL,
0x0000003a0800720cULL, 0x0c0fe40003f46070ULL, 0x0000003a3b00720cULL, 0x080fe40003fa6070ULL,
0x0000003a0900720cULL, 0x000fe40003f66070ULL, 0x00000009083c7812ULL, 0x000fc400078efcffULL,
0x00000019083b7812ULL, 0x040fe400078efcffULL, 0x0000002008097812ULL, 0x000fe400078efcffULL,
0xff80000020207808ULL, 0x000fe40005000000ULL, 0xff8000000a0a7808ULL, 0x000fe40005000000ULL,
0xff80000021217808ULL, 0x000fe40004800000ULL, 0xff8000000b0b7808ULL, 0x000fc40004800000ULL,
0x0000003a3c00720cULL, 0x080fe40003f86070ULL, 0x0000003a3b00720cULL, 0x080fe40003f46070ULL,
0x0000003a0900720cULL, 0x000fe40003f26070ULL, 0x00000021083b7812ULL, 0x040fe400078efcffULL,
0x0000002808097812ULL, 0x000fe400078efcffULL, 0xff80000022227808ULL, 0x000fc40004000000ULL,
0xff8000000c0c7808ULL, 0x000fe40004000000ULL, 0xff80000023237808ULL, 0x000fe40006000000ULL,
0xff8000000d0d7808ULL, 0x000fe40006000000ULL, 0x0000003a3b00720cULL, 0x080fe40003f06070ULL,
0x0000003a0900720cULL, 0x000fe40003f86070ULL, 0x00000029083b7812ULL, 0x000fc400078efcffULL,
0x0000003008097812ULL, 0x000fe400078efcffULL, 0xff80000024247808ULL, 0x000fe40007000000ULL,
0xff8000000e0e7808ULL, 0x000fe40007000000ULL, 0xff80000025257808ULL, 0x000fe40006800000ULL,
0xff8000000f0f7808ULL, 0x000fe40006800000ULL, 0x0000003a3b00720cULL, 0x000fc40003fc6070ULL,
0x0000003a0900720cULL, 0x000fe40003fa6070ULL, 0x00000031083b7812ULL, 0x040fe400078efcffULL,
0x0000003808097812ULL, 0x040fe400078efcffULL, 0x0000003908087812ULL, 0x000fe400078efcffULL,
0xff80000026267808ULL, 0x000fe40005800000ULL, 0xff80000010107808ULL, 0x000fc40005800000ULL,
0xff80000027277808ULL, 0x000fe40005000000ULL, 0xff80000011117808ULL, 0x000fe40005000000ULL,
0xff80000028287808ULL, 0x000fe40004800000ULL, 0xff80000012127808ULL, 0x000fe40004800000ULL,
0x0000003a3b00720cULL, 0x080fe40003f66070ULL, 0x0000003a0900720cULL, 0x000fc40003f46070ULL,
0x0000003a0800720cULL, 0x000fe40003f26070ULL, 0xff80000029297808ULL, 0x000fe40004000000ULL,
0xff80000013137808ULL, 0x000fe40004000000ULL, 0xff8000002a2a7808ULL, 0x000fe40006000000ULL,
0xff80000016167808ULL, 0x000fe40006000000ULL, 0xff8000002b2b7808ULL, 0x000fc40007000000ULL,
0xff80000017177808ULL, 0x000fe40007000000ULL, 0xff8000002c2c7808ULL, 0x000fe40006800000ULL,
0xff80000018187808ULL, 0x000fe40006800000ULL, 0xff8000002d2d7808ULL, 0x000fe40005800000ULL,
0xff80000019197808ULL, 0x000fe40005800000ULL, 0xff8000002e2e7808ULL, 0x000fc40005000000ULL,
0xff8000001a1a7808ULL, 0x000fe40005000000ULL, 0xff8000002f2f7808ULL, 0x000fe40004800000ULL,
0xff8000001b1b7808ULL, 0x000fc40004800000ULL, 0x0000000a0400720bULL, 0x004fe20003f1e000ULL,
0x0000001fff3d7424ULL, 0x000fe200078e00ffULL, 0x000000200500720bULL, 0x000fe20003f3e000ULL,
0xffffffffff3e7424ULL, 0x000fe200078e00ffULL, 0x000000040a047208ULL, 0x000fe40004000000ULL,
0x0000000520057208ULL, 0x000fc40004800000ULL, 0x0000000b0400720bULL, 0x000fe40003f1e000ULL,
0x000000210500720bULL, 0x000fe40003f3e000ULL, 0x000000040b047208ULL, 0x000fe40004000000ULL,
0x0000000521057208ULL, 0x000fe40004800000ULL, 0x0000000c0400720bULL, 0x000fe40003f1e000ULL,
0x000000220500720bULL, 0x000fc40003f3e000ULL, 0x000000040c047208ULL, 0x000fe40004000000ULL,
0x0000000522057208ULL, 0x000fe40004800000ULL, 0x0000000d0400720bULL, 0x000fe40003f1e000ULL,
0x000000230500720bULL, 0x000fe40003f3e000ULL, 0x000000040d047208ULL, 0x000fe40004000000ULL,
0x0000000523057208ULL, 0x000fc40004800000ULL, 0x0000000e0400720bULL, 0x000fe40003f1e000ULL,
0x000000240500720bULL, 0x000fe40003f3e000ULL, 0x000000040e047208ULL, 0x000fe40004000000ULL,
0x0000000524057208ULL, 0x000fe40004800000ULL, 0x0000000f0400720bULL, 0x000fe40003f1e000ULL,
0x000000250500720bULL, 0x000fc40003f3e000ULL, 0x000000040f047208ULL, 0x000fe40004000000ULL,
0x0000000525057208ULL, 0x000fe40004800000ULL, 0x000000100400720bULL, 0x000fe40003f1e000ULL,
0x000000260500720bULL, 0x000fe40003f3e000ULL, 0x0000000410047208ULL, 0x000fe40004000000ULL,
0x0000000526057208ULL, 0x000fc40004800000ULL, 0x000000110400720bULL, 0x000fe40003f1e000ULL,
0x000000270500720bULL, 0x000fe40003f3e000ULL, 0x0000000411047208ULL, 0x000fe40004000000ULL,
0x0000000527057208ULL, 0x000fe40004800000ULL, 0x000000120400720bULL, 0x000fe40003f1e000ULL,
0x000000280500720bULL, 0x000fc40003f3e000ULL, 0x0000000412047208ULL, 0x000fe40004000000ULL,
0x0000000528057208ULL, 0x000fe40004800000ULL, 0x000000130400720bULL, 0x000fe40003f1e000ULL,
0x000000290500720bULL, 0x000fe40003f3e000ULL, 0x0000000413047208ULL, 0x000fe40004000000ULL,
0x0000000529057208ULL, 0x000fc40004800000ULL, 0x000000160400720bULL, 0x000fe40003f1e000ULL,
0x0000002a0500720bULL, 0x000fe40003f3e000ULL, 0x0000000416047208ULL, 0x000fe40004000000ULL,
0x000000052a057208ULL, 0x000fe40004800000ULL, 0x000000170400720bULL, 0x000fe40003f1e000ULL,
0x0000002b0500720bULL, 0x000fc40003f3e000ULL, 0x0000000417047208ULL, 0x000fe40004000000ULL,
0x000000052b057208ULL, 0x000fe40004800000ULL, 0x000000180400720bULL, 0x000fe40003f1e000ULL,
0x0000002c0500720bULL, 0x000fe40003f3e000ULL, 0x0000000418047208ULL, 0x000fe40004000000ULL,
0x000000052c057208ULL, 0x000fc40004800000ULL, 0x000000190400720bULL, 0x000fe40003f1e000ULL,
0x0000002d0500720bULL, 0x000fe40003f3e000ULL, 0x0000000419047208ULL, 0x000fe40004000000ULL,
0x000000052d057208ULL, 0x000fe40004800000ULL, 0x0000001a0400720bULL, 0x000fe40003f1e000ULL,
0x0000002e0500720bULL, 0x000fc40003f3e000ULL, 0x000000041a047208ULL, 0x000fe40004000000ULL,
0x000000052e057208ULL, 0x000fe40004800000ULL, 0x0000001b0400720bULL, 0x000fe40003f1e000ULL,
0x0000002f0500720bULL, 0x000fe40003f3e000ULL, 0x000000041b3c7208ULL, 0x000fe40004000000ULL,
0x000000052f057208ULL, 0x000fe20004800000ULL, 0x000018627f007947ULL, 0x000fec000b800000ULL,
0x0c401f003c047f89ULL, 0x0004e400000e0000ULL, 0x000000043c00720bULL, 0x008fc80003f1e000ULL,
0x0000003c043c7208ULL, 0x004fe20004000000ULL, 0x000018827f007947ULL, 0x000fea000b800000ULL,
0x0c401f0005047f89ULL, 0x000ea800000e0000ULL, 0x0c401f0006087f89ULL, 0x000ee800000e0000ULL,
0x0c401f0007097f89ULL, 0x000e6200000e0000ULL, 0x000000040500720bULL, 0x004fc40003f1e000ULL,
0x000000080600720bULL, 0x008fe40003f3e000ULL, 0x0000000504057208ULL, 0x000fe40004000000ULL,
0x0000000608067208ULL, 0x000fe20004800000ULL, 0x0c201f003c047f89ULL, 0x000ea200000e0000ULL,
0x000000090700720bULL, 0x002fc60003f1e000ULL, 0x0c201f0005087f89ULL, 0x000e6200000e0000ULL,
0x0000000709077208ULL, 0x000fc60004000000ULL, 0x0c201f00063a7f89ULL, 0x000ee800000e0000ULL,
0x0c201f00073b7f89ULL, 0x0002e200000e0000ULL, 0x000000043c00720bULL, 0x004fe40003f1e000ULL,
0x000000080500720bULL, 0x002fe40003f3e000ULL, 0x0000003c04047208ULL, 0x000fe40004000000ULL,
0x0000003a0600720bULL, 0x008fc40003f5e000ULL, 0x0000000508057208ULL, 0x000fe40004800000ULL,
0x000000063a067208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b043a7820ULL, 0x000fe20000410000ULL,
0x3f80000000047882ULL, 0x000fe20000000000ULL, 0x0000000c15157812ULL, 0x000fe200078ec0ffULL,
0x00000004ff3c7e24ULL, 0x000fe2000f8e00ffULL, 0x3fb8aa3b0a0a7823ULL, 0x100fe2000001083aULL,
0x3fb8aa3b0c0c7823ULL, 0x100fe2000001083aULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe2000001083aULL,
0x3fb8aa3b10107823ULL, 0x100fe2000001083aULL, 0x3fb8aa3b12127823ULL, 0x100fe2000001083aULL,
0x0000000a00087308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b16167823ULL, 0x100fe2000001083aULL,
0x3fb8aa3b0b0b7823ULL, 0x100fe2000001083aULL, 0x3fb8aa3b0d0d7823ULL, 0x100fe2000001083aULL,
0x3f8000003c3c783eULL, 0x000fe200000010ffULL, 0x3fb8aa3b0f0f7823ULL, 0x100fe2000001083aULL,
0x3fb8aa3b11117823ULL, 0x000fe2000001083aULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000c000a7308ULL, 0x000fe20000000800ULL, 0x000000ffff3d7224ULL, 0x000fe200078e003cULL,
0x3fb8aa3b13137823ULL, 0x100fe2000001083aULL, 0x3fb8aa3b17177823ULL, 0x100fe2000001083aULL,
0x3fb8aa3b18187823ULL, 0x100fe2000001083aULL, 0x3fb8aa3b19197823ULL, 0x100fe2000001083aULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe2000001083aULL, 0x3fb8aa3b1b1b7823ULL, 0x000fe2000001083aULL,
0x0000000e000c7308ULL, 0x000fe20000000800ULL, 0x00000002ff3a7819ULL, 0x000fc40000011603ULL,
0x0000000303ff7812ULL, 0x000fe4000780c0ffULL, 0x0000003b0700720bULL, 0x004fc60003f3e000ULL,
0x00000010000e7308ULL, 0x000fe20000000800ULL, 0x000000073b077208ULL, 0x000fce0004800000ULL,
0x0000001200107308ULL, 0x000ff00000000800ULL, 0x0000001600127308ULL, 0x0003f00000000800ULL,
0x0000000b000b7308ULL, 0x000ea20000000800ULL, 0x3fb8aa3b05167820ULL, 0x002fc80000410000ULL,
0x3fb8aa3b21217823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b22227823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b23237823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b20207823ULL, 0x100fe20000010816ULL,
0x0000000d000d7308ULL, 0x000e620000000800ULL, 0x3fb8aa3b24247823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b25257823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe20000010816ULL, 0x000000080b08723eULL, 0x004fe200000010ffULL,
0x0000002000097308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b2f167823ULL, 0x000fe20000010816ULL, 0x000000083a2f7824ULL, 0x000fe200078e00ffULL,
0x0000002100217308ULL, 0x000ea20000000800ULL, 0x0000000a0d0a723eULL, 0x002fce00000010ffULL,
0x0000002200227308ULL, 0x000ff00000000800ULL, 0x0000002300237308ULL, 0x000e620000000800ULL,
0x000000092109723eULL, 0x004fce00000010ffULL, 0x0000000f000f7308ULL, 0x000ea20000000800ULL,
0x00000022230b723eULL, 0x002fce00000010ffULL, 0x0000002400247308ULL, 0x000fe20000000800ULL,
0x0000003c0820723cULL, 0x000b6200000418ffULL, 0x0000000c0f0c723eULL, 0x004fcc00000010ffULL,
0x0000002500257308ULL, 0x000e620000000800ULL, 0x000000083a3d7824ULL, 0x020fce00078e00ffULL,
0x0000001100117308ULL, 0x000eb00000000800ULL, 0x0000002600267308ULL, 0x000fe20000000800ULL,
0x00000024250d723eULL, 0x002fe200000010ffULL, 0x000000ffff247224ULL, 0x000fc400078e003cULL,
0x000000ffff257224ULL, 0x000fc800078e003cULL, 0x0000002700277308ULL, 0x000e620000000800ULL,
0x0000000e110e723eULL, 0x004fe400000010ffULL, 0x000000013a117810ULL, 0x000fca0007ffe0ffULL,
0x0000001300137308ULL, 0x000ea20000000800ULL, 0x00000026270f723eULL, 0x002fce00000010ffULL,
0x0000002a002a7308ULL, 0x000fe20000000800ULL, 0x000000033a267810ULL, 0x040fe40007ffe0ffULL,
0x000000043a277810ULL, 0x000fe20007ffe0ffULL, 0x000000240c20723cULL, 0x000b620000041820ULL,
0x000000101310723eULL, 0x004fc600000010ffULL, 0x0000002b002b7308ULL, 0x000e660000000800ULL,
0x000000083a247824ULL, 0x060fe400078e00ffULL, 0x000000083a257824ULL, 0x000fc600078e00ffULL,
0x0000001700177308ULL, 0x000ea20000000800ULL, 0xfffffff824247812ULL, 0x000fce00078ee211ULL,
0x0000002800287308ULL, 0x000fe20000000800ULL, 0x0000002a2b13723eULL, 0x002fe200000010ffULL,
0x000000ffff2a7224ULL, 0x100fe400078e003cULL, 0x000000ffff2b7224ULL, 0x000fc800078e003cULL,
0x0000002900297308ULL, 0x000e620000000800ULL, 0x000000121712723eULL, 0x004fe400000010ffULL,
0x000000023a177810ULL, 0x000fc80007ffe0ffULL, 0xfffffff825257812ULL, 0x000fe200078ee217ULL,
0x0000001800187308ULL, 0x000fe20000000800ULL, 0x000000083a177824ULL, 0x000fca00078e00ffULL,
0xfffffff817177812ULL, 0x000fe400078ee23aULL, 0x000000282911723eULL, 0x002fe200000010ffULL,
0x0000001900197308ULL, 0x000e620000000800ULL, 0x000000083a287824ULL, 0x040fe400078e00ffULL,
0x000000083a297824ULL, 0x000fc600078e00ffULL, 0x0000002a1020723cULL, 0x000b620000041820ULL,
0xfffffff828267812ULL, 0x000fe200078ee226ULL, 0x0000001a001a7308ULL, 0x000fe20000000800ULL,
0x000000053a287810ULL, 0x040fe40007ffe0ffULL, 0xfffffff829277812ULL, 0x000fe400078ee227ULL,
0x000000083a2b7810ULL, 0x020fe40007ffe0ffULL, 0xfffffff82f287812ULL, 0x000fe200078ee228ULL,
0x0000001b001b7308ULL, 0x000ea20000000800ULL, 0x000000181918723eULL, 0x002fe200000010ffULL,
0x000000082b3e7824ULL, 0x000fe200078e00ffULL, 0x0000a000022f7811ULL, 0x000fc400078e58ffULL,
0x000000063a297810ULL, 0x040fe40007ffe0ffULL, 0xffffffff3a2a7810ULL, 0x040fe20007ffe0ffULL,
0x0000002c002c7308ULL, 0x000fe20000000800ULL, 0x000000083a3a7824ULL, 0x000fe200078e00ffULL,
0xfffffff83d297812ULL, 0x000fe200078ee229ULL, 0x0000001017177824ULL, 0x000fe200078e022fULL,
0xfffffff83e2b7812ULL, 0x000fe200078ee22bULL, 0x0000001024247824ULL, 0x100fe200078e022fULL,
0xfffffff83a2a7812ULL, 0x000fe200078ee22aULL, 0x0000001025257824ULL, 0x100fe200078e022fULL,
0x0000002d002d7308ULL, 0x000e620000000800ULL, 0x0000001a1b1a723eULL, 0x004fe200000010ffULL,
0x0000001026267824ULL, 0x000fc400078e022fULL, 0x0000001027277824ULL, 0x000fe400078e022fULL,
0x0000000117177824ULL, 0x000fe400078e0215ULL, 0x0000002e002e7308ULL, 0x000fe20000000800ULL,
0x0000001028287824ULL, 0x100fe400078e022fULL, 0x0000000115247824ULL, 0x000fe200078e0224ULL,
0x0000000817007388ULL, 0x0005e20000000800ULL, 0x0000001029297824ULL, 0x000fe400078e022fULL,
0x0000000115257824ULL, 0x000fe200078e0225ULL, 0x0000001600167308ULL, 0x000ee20000000800ULL,
0x0000002c2d19723eULL, 0x002fe200000010ffULL, 0x000000ffff2c7224ULL, 0x100fe200078e003cULL,
0x0000000a24007388ULL, 0x0005e20000000800ULL, 0x000000ffff2d7224ULL, 0x000fc400078e003cULL,
0x000000102a2a7824ULL, 0x100fe200078e022fULL, 0x0000000c25007388ULL, 0x0005e20000000800ULL,
0x0000000115267824ULL, 0x000fe400078e0226ULL, 0x000000102b2b7824ULL, 0x000fe400078e022fULL,
0x0000000115277824ULL, 0x040fe200078e0227ULL, 0x0000000e26007388ULL, 0x0005e20000000800ULL,
0x0000000115287824ULL, 0x040fe200078e0228ULL, 0x0000002e161b723eULL, 0x008fe200000010ffULL,
0x0000000115297824ULL, 0x040fe200078e0229ULL, 0x0000001027007388ULL, 0x0005e20000000800ULL,
0x00000001152a7824ULL, 0x000fc400078e022aULL, 0x00000001152b7824ULL, 0x000fe200078e022bULL,
0x0000001228007388ULL, 0x0005e20000000800ULL, 0x0000002c1820723cULL, 0x000f660000041820ULL,
0x0000001829007388ULL, 0x0005e80000000800ULL, 0x0000001a2a007388ULL, 0x0005e80000000800ULL,
0x000000092b007388ULL, 0x0005e80000000800ULL, 0x0004000b24007388ULL, 0x0005e80000000800ULL,
0x0004000d25007388ULL, 0x0005e80000000800ULL, 0x0004000f26007388ULL, 0x0005e20000000800ULL,
0x000000ffff217224ULL, 0x020fc600078e0022ULL, 0x0004001127007388ULL, 0x0005e80000000800ULL,
0x0004001328007388ULL, 0x0005e80000000800ULL, 0x0004001929007388ULL, 0x0005e80000000800ULL,
0x0004001b2a007388ULL, 0x0005e80000000800ULL, 0x0100000414008388ULL, 0x0005e80000000c00ULL,
0x0102002014008388ULL, 0x0005e20000000a00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000037ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000080037ff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000100037ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000138387810ULL, 0x000fe20007ffe0ffULL, 0x0000180037ff7f8cULL, 0x0003e6000c80043fULL,
0x0000001e3800720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffbb8000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff477807ULL, 0x008fe40004000000ULL, 0x0001c5b000487802ULL, 0x000fc40000000f00ULL,
0x00000f8000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff297224ULL, 0x000fe200078e0047ULL,
0xfffe5aa000007947ULL, 0x000fea000383ffffULL, 0x00000001ff477807ULL, 0x000fe40005000000ULL,
0x0001c60000487802ULL, 0x000fc40000000f00ULL, 0x00000f3000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff307224ULL, 0x000fe200078e0047ULL, 0xfffe5b0000007947ULL, 0x000fea000383ffffULL,
0x000000ffff497224ULL, 0x004fe200078e0031ULL, 0x0001c65000487802ULL, 0x000fc40000000f00ULL,
0x00000ea000007944ULL, 0x002fea0003c00000ULL, 0xfffe5bb000007947ULL, 0x000fea000383ffffULL,
0x000000ffff497224ULL, 0x000fe200078e0031ULL, 0x0001c69000487802ULL, 0x000fc40000000f00ULL,
0x00000e6000007944ULL, 0x002fea0003c00000ULL, 0xfffe5ce000007947ULL, 0x000fea000383ffffULL,
0x000000ffff497224ULL, 0x000fe200078e002eULL, 0x0001c6e000487802ULL, 0x000fe20000000f00ULL,
0x000000ffff477224ULL, 0x000fc400078e002fULL, 0x00000e1000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff2c7224ULL, 0x004fe200078e0047ULL, 0xfffe60d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff477224ULL, 0x000fe200078e002dULL, 0x0001c74000487802ULL, 0x000fe20000000f00ULL,
0x000000ffff497224ULL, 0x000fc400078e002eULL, 0x00000db000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff2d7224ULL, 0x004fe200078e0047ULL, 0xfffe60a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff497224ULL, 0x000fe200078e0036ULL, 0x0001c7a000487802ULL, 0x000fe20000000f00ULL,
0x000000ffff477224ULL, 0x000fc400078e0037ULL, 0x00000d5000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff2c7224ULL, 0x004fe200078e0047ULL, 0xfffe86c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff477224ULL, 0x000fe200078e002dULL, 0x0001c80000487802ULL, 0x000fe20000000f00ULL,
0x000000ffff497224ULL, 0x000fc400078e0036ULL, 0x00000cf000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff2d7224ULL, 0x004fe200078e0047ULL, 0xfffe869000007947ULL, 0x000fea000383ffffULL,
0x00000001ff477807ULL, 0x008fe40004000000ULL, 0x0001c85000487802ULL, 0x000fc40000000f00ULL,
0x00000ce000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff4b7224ULL, 0x000fe200078e0047ULL,
0xfffead3000007947ULL, 0x000fea000383ffffULL, 0x00000001ff477807ULL, 0x000fe40005000000ULL,
0x0001c8a000487802ULL, 0x000fc40000000f00ULL, 0x00000c9000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff467224ULL, 0x000fe200078e0047ULL, 0xfffead7000007947ULL, 0x000fea000383ffffULL,
0x000000ffff497224ULL, 0x000fe200078e004dULL, 0x0001c8f000487802ULL, 0x000fc40000000f00ULL,
0x00000c0000007944ULL, 0x014fea0003c00000ULL, 0xfffeae4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff497224ULL, 0x000fe200078e004dULL, 0x0001c93000487802ULL, 0x000fc40000000f00ULL,
0x00000bc000007944ULL, 0x016fea0003c00000ULL, 0xfffeaf6000007947ULL, 0x000fea000383ffffULL,
0x000000ffff497224ULL, 0x000fe200078e0044ULL, 0x0001c98000487802ULL, 0x000fe20000000f00ULL,
0x000000ffff477224ULL, 0x000fc400078e0045ULL, 0x00000b7000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff2c7224ULL, 0x004fe200078e0047ULL, 0xfffeb39000007947ULL, 0x000fea000383ffffULL,
0x000000ffff477224ULL, 0x000fe200078e002dULL, 0x0001c9e000487802ULL, 0x000fe20000000f00ULL,
0x000000ffff497224ULL, 0x000fc400078e0044ULL, 0x00000b1000007944ULL, 0x01efea0003c00000ULL,
0x000000ffff2d7224ULL, 0x004fe200078e0047ULL, 0xfffeb36000007947ULL, 0x000fea000383ffffULL,
0x000000ffff497224ULL, 0x000fe200078e0038ULL, 0x0001ca4000487802ULL, 0x000fe20000000f00ULL,
0x000000ffff477224ULL, 0x000fc400078e0039ULL, 0x00000ab000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff2c7224ULL, 0x004fe200078e0047ULL, 0xfffed79000007947ULL, 0x000fea000383ffffULL,
0x000000ffff477224ULL, 0x000fe200078e002dULL, 0x0001caa000487802ULL, 0x000fe20000000f00ULL,
0x000000ffff497224ULL, 0x000fc400078e0038ULL, 0x00000a5000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff2d7224ULL, 0x004fe200078e0047ULL, 0xfffed76000007947ULL, 0x000fea000383ffffULL,
0x00000001ff477807ULL, 0x002fe40004000000ULL, 0x0001caf000487802ULL, 0x000fc40000000f00ULL,
0x00000a4000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff4b7224ULL, 0x000fe200078e0047ULL,
0xfffefc9000007947ULL, 0x000fea000383ffffULL, 0x00000001ff477807ULL, 0x000fe40005000000ULL,
0x0001cb4000487802ULL, 0x000fc40000000f00ULL, 0x000009f000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff4c7224ULL, 0x000fe200078e0047ULL, 0xfffefcc000007947ULL, 0x000fea000383ffffULL,
0x000000ffff497224ULL, 0x000fe200078e004dULL, 0x0001cb9000487802ULL, 0x000fc40000000f00ULL,
0x0000096000007944ULL, 0x004fea0003c00000ULL, 0xfffefd9000007947ULL, 0x000fea000383ffffULL,
0x000000ffff497224ULL, 0x000fe200078e004dULL, 0x0001cbd000487802ULL, 0x000fc40000000f00ULL,
0x0000092000007944ULL, 0x006fea0003c00000ULL, 0xfffefeb000007947ULL, 0x000fea000383ffffULL,
0x000000ffff497224ULL, 0x000fe200078e0024ULL, 0x0001cc2000487802ULL, 0x000fe20000000f00ULL,
0x000000ffff477224ULL, 0x000fc400078e0044ULL, 0x000008d000007944ULL, 0x00afea0003c00000ULL,
0x000000ffff2c7224ULL, 0x004fe200078e0047ULL, 0xffff02c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff477224ULL, 0x000fe200078e002dULL, 0x0001cc8000487802ULL, 0x000fe20000000f00ULL,
0x000000ffff497224ULL, 0x000fc400078e0024ULL, 0x0000087000007944ULL, 0x00efea0003c00000ULL,
0x000000ffff2d7224ULL, 0x004fe200078e0047ULL, 0xffff029000007947ULL, 0x000fea000383ffffULL,
0x000000ffff497224ULL, 0x000fe200078e0024ULL, 0x0001cce000487802ULL, 0x000fe20000000f00ULL,
0x000000ffff477224ULL, 0x000fc400078e0038ULL, 0x0000081000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff2c7224ULL, 0x004fe200078e0047ULL, 0xffff26c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff477224ULL, 0x000fe200078e002dULL, 0x0001cd4000487802ULL, 0x000fe20000000f00ULL,
0x000000ffff497224ULL, 0x000fc400078e0024ULL, 0x000007b000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff2d7224ULL, 0x004fe200078e0047ULL, 0xffff269000007947ULL, 0x000fea000383ffffULL,
0x00000001ff477807ULL, 0x008fe40004000000ULL, 0x0001cd9000487802ULL, 0x000fc40000000f00ULL,
0x000007a000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff4a7224ULL, 0x000fe200078e0047ULL,
0xffff4c4000007947ULL, 0x000fea000383ffffULL, 0x00000001ff477807ULL, 0x000fe40004800000ULL,
0x0001cde000487802ULL, 0x000fc40000000f00ULL, 0x0000075000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff287224ULL, 0x000fe200078e0047ULL, 0xffff4c7000007947ULL, 0x000fea000383ffffULL,
0x000000ffff477224ULL, 0x000fe200078e0027ULL, 0x0001ce4000487802ULL, 0x000fe20000000f00ULL,
0x000000ffff497224ULL, 0x000fc400078e004bULL, 0x000006b000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff277224ULL, 0x004fe200078e0047ULL, 0xffff4d2000007947ULL, 0x000fea000383ffffULL,
0x000000ffff497224ULL, 0x000fe200078e004bULL, 0x0001cea000487802ULL, 0x000fe20000000f00ULL,
0x000000ffff477224ULL, 0x000fc400078e0027ULL, 0x0000065000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff277224ULL, 0x004fe200078e0047ULL, 0xffff4e2000007947ULL, 0x000fea000383ffffULL,
0x000000ffff497224ULL, 0x000fe200078e0024ULL, 0x0001cf0000487802ULL, 0x000fe20000000f00ULL,
0x000000ffff477224ULL, 0x000fc400078e0027ULL, 0x000005f000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff2c7224ULL, 0x004fe200078e0047ULL, 0xffff523000007947ULL, 0x000fea000383ffffULL,
0x000000ffff477224ULL, 0x000fe200078e002dULL, 0x0001cf6000487802ULL, 0x000fe20000000f00ULL,
0x000000ffff497224ULL, 0x000fc400078e0024ULL, 0x0000059000007944ULL, 0x01efea0003c00000ULL,
0x000000ffff2d7224ULL, 0x004fe200078e0047ULL, 0xffff520000007947ULL, 0x000fea000383ffffULL,
0x000000ffff497224ULL, 0x000fe200078e0014ULL, 0x0001cfc000487802ULL, 0x000fe20000000f00ULL,
0x000000ffff477224ULL, 0x000fc400078e0015ULL, 0x0000053000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff2c7224ULL, 0x004fe200078e0047ULL, 0xffff765000007947ULL, 0x000fea000383ffffULL,
0x000000ffff477224ULL, 0x000fe200078e002dULL, 0x0001d02000487802ULL, 0x000fe20000000f00ULL,
0x000000ffff497224ULL, 0x000fc400078e0014ULL, 0x000004d000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff2d7224ULL, 0x004fe200078e0047ULL, 0xffff762000007947ULL, 0x000fea000383ffffULL,
0x000000ffff087224ULL, 0x000fe200078e003cULL, 0x0001d080003a7802ULL, 0x000fe20000000f00ULL,
0x00000002ff097424ULL, 0x000fc400078e00ffULL, 0x0000042000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e003bULL, 0xffffe75000007947ULL, 0x000fea000383ffffULL,
0x000000ffff087224ULL, 0x000fe200078e0005ULL, 0x0001d0e0003a7802ULL, 0x000fe20000000f00ULL,
0x00000002ff097424ULL, 0x000fc400078e00ffULL, 0x000003c000007944ULL, 0x012fea0003c00000ULL,
0x0000003b0500720bULL, 0x004fe20003f1e000ULL, 0x000000ffff087224ULL, 0x000fe200078e0006ULL,
0x0001d140003a7802ULL, 0x000fe20000000f00ULL, 0x00000002ff097424ULL, 0x000fe200078e00ffULL,
0x000000053b057208ULL, 0x000fc80004000000ULL, 0x0000036000007944ULL, 0x000fea0003c00000ULL,
0x0000003b0600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff087224ULL, 0x000fe200078e0007ULL,
0x0001d1a0003a7802ULL, 0x000fe20000000f00ULL, 0x00000002ff097424ULL, 0x000fe200078e00ffULL,
0x000000063b067208ULL, 0x000fc80004000000ULL, 0x0000030000007944ULL, 0x000fea0003c00000ULL,
0x0000003b0700720bULL, 0x004fe20003f1e000ULL, 0x000000ffff087224ULL, 0x000fe200078e003cULL,
0x0001d200003a7802ULL, 0x000fe20000000f00ULL, 0x00000001ff097424ULL, 0x000fe200078e00ffULL,
0x000000073b077208ULL, 0x000fc80004000000ULL, 0x000002a000007944ULL, 0x000fea0003c00000ULL,
0x0000003b3c00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff087224ULL, 0x000fe200078e0005ULL,
0x0001d260003a7802ULL, 0x000fe20000000f00ULL, 0x00000001ff097424ULL, 0x000fe200078e00ffULL,
0x0000003c3b047208ULL, 0x000fc80004000000ULL, 0x0000024000007944ULL, 0x000fea0003c00000ULL,
0x0000003b0500720bULL, 0x004fe20003f1e000ULL, 0x000000ffff087224ULL, 0x000fe200078e0006ULL,
0x0001d2c0003a7802ULL, 0x000fe20000000f00ULL, 0x00000001ff097424ULL, 0x000fe200078e00ffULL,
0x000000053b057208ULL, 0x000fc80004000000ULL, 0x000001e000007944ULL, 0x000fea0003c00000ULL,
0x0000003b0600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff087224ULL, 0x000fe200078e0007ULL,
0x0001d320003a7802ULL, 0x000fe20000000f00ULL, 0x00000001ff097424ULL, 0x000fe200078e00ffULL,
0x000000063b067208ULL, 0x000fc80004000000ULL, 0x0000018000007944ULL, 0x000fea0003c00000ULL,
0xffffe62000007947ULL, 0x000fea000383ffffULL, 0x0180000003007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000057812ULL, 0x000fc800078ec0ffULL,
0x018000000500780cULL, 0x000fda0003f05070ULL, 0x0000000300008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0500720cULL, 0x040fe40003f25070ULL,
0x008000000500780cULL, 0x000fe40003f02070ULL, 0x00000001ff057807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000005ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff03ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000003037812ULL, 0x002fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000005ff7212ULL, 0x000fda000780c0ffULL, 0x0080000003000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0003ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000300007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff057424ULL, 0x000fc800078e00ffULL, 0xfffe2b6004007950ULL, 0x000fea0003c3ffffULL,
0x0000003e00007348ULL, 0x000fe80003800000ULL, 0x0c000009083b7389ULL, 0x0002a400000e003dULL,
0x000000ffff087224ULL, 0x002fe400078e003aULL, 0x00000000ff097424ULL, 0x000fc800078e00ffULL,
0xfffe2b1008007950ULL, 0x000fea0003c3ffffULL, 0x0000002a00007348ULL, 0x000fe80003800000ULL,
0x0000004749477389ULL, 0x0002a400000e0029ULL, 0x00000000ff497424ULL, 0x002fc800078e00ffULL,
0xfffe2ad048007950ULL, 0x000fea0003c3ffffULL, 0x000000014700780cULL, 0x000fe20003f45070ULL,
0x00000000ff497424ULL, 0x000fe200078e00ffULL, 0x0000002800007348ULL, 0x000ff60003800000ULL,
0x0000000000477806ULL, 0x000fc800050e0100ULL, 0x0000002847477212ULL, 0x000fe200078ec0ffULL,
0xfffe2a7048007950ULL, 0x000fec0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000200000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005e7ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000748ULL, 0x0000000000000288ULL, 0x0000001a00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009d0ULL, 0x0000000000000480ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e50ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000f10ULL, 0x0000000000000a04ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001918ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001928ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000007bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000019b8ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000019bcULL, 0x00000000000001b0ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001b80ULL, 0x000000000001d680ULL, 0x9900001a00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x0000000100000089ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001f200ULL, 0x0000000000000044ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001f250ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x000000000001f5d0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x00000000000019b8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000001d848ULL, 0x000000000001d848ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x000000000001f200ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x000000000001f5d0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_1_kvt_e4m3_pagedKV_128_nqpkv_8_m_8_sm_89_cubin_len = 128688;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
