/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_1_kvt_e4m3_pagedKV_64_nqpkv_8_m_8_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001f750ULL, 0x000000000001f3d0ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f34314944327961ULL, 0x6f6c66625f766e5fULL,
0x326a4c3236317461ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL,
0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x336a4c4536316a4cULL, 0x4c49746132454532ULL,
0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45346a4c4534366aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL,
0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL,
0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL, 0x45326a4c4545316aULL, 0x7461324545316a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x4939494432796172ULL, 0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL,
0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL,
0x4c4545346a4c6a49ULL, 0x36316a4c4532336aULL, 0x624c497461324545ULL, 0x31534b5245454531ULL,
0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL,
0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL, 0x4c4545326a4c4532ULL, 0x4545316a4c45326aULL,
0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x45386a4c4545346aULL,
0x7461324545386a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL,
0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL,
0x6a4c4536316a4c45ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5f2400676e696469ULL, 0x616e7265746e695fULL, 0x635f5f245f305f6cULL,
0x30326d735f616475ULL, 0x5f6e725f7063725fULL, 0x5f3233665f7a7466ULL, 0x68746170776f6c73ULL,
0x65746e695f5f2400ULL, 0x245f315f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL,
0x6c66625f636e7973ULL, 0x695f5f2400705f79ULL, 0x5f6c616e7265746eULL, 0x6475635f5f245f32ULL,
0x735f30376d735f61ULL, 0x5f636e79736c6668ULL, 0x5f2400705f786469ULL, 0x616e7265746e695fULL,
0x635f5f245f335f6cULL, 0x30376d735f616475ULL, 0x6e797365746f765fULL, 0x746f6c6c61625f63ULL,
0x742e616c65722e00ULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL,
0x5f6c656e72656b2eULL, 0x72656b240061686dULL, 0x2461686d5f6c656eULL, 0x657479426d656d73ULL,
0x2e766e2e00667542ULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x61705f0061686d5fULL,
0x6265642e006d6172ULL, 0x656d6172665f6775ULL, 0x65642e6c65722e00ULL, 0x6d6172665f677562ULL,
0x2e616c65722e0065ULL, 0x72665f6775626564ULL, 0x2e766e2e00656d61ULL, 0x697463612e6c6572ULL,
0x0000000000006e6fULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c0001000000adULL, 0x0000000000000034ULL, 0x0000000000000010ULL, 0x000c0001000000ebULL,
0x000000000000001cULL, 0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c00010000016bULL, 0x000000000000002cULL, 0x0000000000000004ULL,
0x000c0001000001b5ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c0001000001fbULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000242ULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000c000100000288ULL, 0x0000000000000030ULL, 0x0000000000000004ULL,
0x000c0001000002d6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c000100000324ULL,
0x0000000000000018ULL, 0x0000000000000004ULL, 0x000c000100000372ULL, 0x000000000000000cULL,
0x0000000000000004ULL, 0x000c0001000003b9ULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000c000100000407ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c00010000044cULL,
0x0000000000000020ULL, 0x0000000000000004ULL, 0x000b002200000492ULL, 0x000000000001d530ULL,
0x0000000000000180ULL, 0x000b0022000004c5ULL, 0x000000000001d6b0ULL, 0x0000000000000050ULL,
0x000b0022000004f0ULL, 0x000000000001d700ULL, 0x0000000000000040ULL, 0x000b00220000051aULL,
0x000000000001d740ULL, 0x0000000000000140ULL, 0x000a000300000588ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00040003000005a8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00070003000005d8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL,
0x0000000000000000ULL, 0x000000000001d880ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0001d53000000000ULL,
0x0000040400000000ULL, 0x810c000001580400ULL, 0x0073e80400288080ULL, 0x0000000000000000ULL,
0x000000a4ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x9608288080820828ULL, 0x2880809808288080ULL,
0x809d082880809908ULL, 0x082880809e082880ULL, 0x8080b608288080b2ULL, 0xc208288080be0828ULL,
0x288080c308288080ULL, 0x80c608288080c408ULL, 0x08288080c7082880ULL, 0x8080c908288080c8ULL,
0xd608288080ca0828ULL, 0x288080da08288080ULL, 0x8280162880808308ULL, 0x0000000003102880ULL,
0x8080839200000000ULL, 0x0000000000220028ULL, 0x00000034ffffffffULL, 0x0000007000000000ULL,
0x0001d53000000000ULL, 0x0000018000000000ULL, 0x0000480400000000ULL, 0x8080288080820900ULL,
0x0900000010042880ULL, 0x2880808228808083ULL, 0x000000a4ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8308288080820828ULL, 0x2880808808288080ULL, 0x8098082880809608ULL, 0x0828808099082880ULL,
0x80809e082880809dULL, 0xb608288080b20828ULL, 0x288080be08288080ULL, 0x80c308288080c208ULL,
0x08288080c4082880ULL, 0x8080c708288080c6ULL, 0xc908288080c80828ULL, 0x288080ca08288080ULL,
0x80b908288080d608ULL, 0x1028808280162880ULL, 0x0000000000000003ULL, 0x2200288080b99200ULL,
0x0000002cffffffffULL, 0x0000016000000000ULL, 0x0001d6b000000000ULL, 0x0000005000000000ULL,
0x00000c0400000000ULL, 0x8088288080b90900ULL, 0x0000000000002880ULL, 0x000000a4ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8308288080820828ULL, 0x2880809608288080ULL, 0x8099082880809808ULL,
0x082880809d082880ULL, 0x8080b2082880809eULL, 0xbe08288080b60828ULL, 0x288080c208288080ULL,
0x80c408288080c308ULL, 0x08288080c7082880ULL, 0x8080c908288080c8ULL, 0xd608288080ca0828ULL,
0x288080da08288080ULL, 0x828016288080c608ULL, 0x0000000003102880ULL, 0x8080c69200000000ULL,
0x0000000000220028ULL, 0x0000001cffffffffULL, 0x0000024800000000ULL, 0x0001d70000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x000000a4ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8308288080820828ULL, 0x2880809608288080ULL, 0x8099082880809808ULL, 0x082880809d082880ULL,
0x8080b2082880809eULL, 0xbe08288080b60828ULL, 0x288080c208288080ULL, 0x80c408288080c308ULL,
0x08288080c6082880ULL, 0x8080c908288080c8ULL, 0xd608288080ca0828ULL, 0x288080da08288080ULL,
0x828016288080c708ULL, 0x0000000003102880ULL, 0x8080c79200000000ULL, 0x0000000000220028ULL,
0x0000002cffffffffULL, 0x0000032000000000ULL, 0x0001d74000000000ULL, 0x0000014000000000ULL,
0x0000140400000000ULL, 0x80c6288080c70900ULL, 0x0000000000002880ULL, 0x0000001a00082f04ULL,
0x0008230400000099ULL, 0x0000000000000016ULL, 0x0000001600081204ULL, 0x0008110400000000ULL,
0x0000000000000016ULL, 0x0000001500082304ULL, 0x0008120400000000ULL, 0x0000000000000015ULL,
0x0000001500081104ULL, 0x0008230400000000ULL, 0x0000000000000014ULL, 0x0000001400081204ULL,
0x0008110400000000ULL, 0x0000000000000014ULL, 0x0000001300082304ULL, 0x0008120400000000ULL,
0x0000000000000013ULL, 0x0000001300081104ULL, 0x0008230400000000ULL, 0x000000000000001aULL,
0x0000001a00081204ULL, 0x0008110400000000ULL, 0x000000000000001aULL, 0x0000007b00043704ULL,
0x0000001700080a04ULL, 0x0050190300500160ULL, 0x00000000000c1704ULL, 0x0021f00000480006ULL,
0x00000000000c1704ULL, 0x0021f00000400005ULL, 0x00000000000c1704ULL, 0x0011f00000380004ULL,
0x00000000000c1704ULL, 0x0081f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL,
0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL,
0x0004310400ff1b03ULL, 0x0198290400000020ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x000000f001982804ULL, 0x0000046000000110ULL, 0x000021a0000020f0ULL,
0x0000240000002290ULL, 0x0000288000002850ULL, 0x00002920000028d0ULL, 0x00004f3000004f00ULL,
0x00004fd000004f80ULL, 0x000076c000007630ULL, 0x00007930000077d0ULL, 0x00007df000007dc0ULL,
0x00007e9000007e40ULL, 0x0000a2b00000a280ULL, 0x0000a3500000a300ULL, 0x0000c9400000c8b0ULL,
0x0000cbb00000ca50ULL, 0x0000d0700000d040ULL, 0x0000d1100000d0c0ULL, 0x0000f5300000f500ULL,
0x0000f5d00000f580ULL, 0x00011bd000011b40ULL, 0x00011e4000011ce0ULL, 0x00012300000122d0ULL,
0x000123a000012350ULL, 0x000147e0000147b0ULL, 0x0001488000014830ULL, 0x0001626000016250ULL,
0x0001b95000016a30ULL, 0x0001b9a00001b990ULL, 0x0001ba000001b9b0ULL, 0x0001ba400001ba20ULL,
0x0001c7100001ba50ULL, 0x0001c7b00001c760ULL, 0x0001c8600001c800ULL, 0x0001c9200001c8c0ULL,
0x0001c9d00001c980ULL, 0x0001ca800001ca20ULL, 0x0001cb400001cae0ULL, 0x0001cc000001cba0ULL,
0x0001ccb00001cc60ULL, 0x0001cd500001cd00ULL, 0x0001ce100001cdb0ULL, 0x0001ced00001ce70ULL,
0x0001cf800001cf30ULL, 0x0001d0300001cfd0ULL, 0x0001d0f00001d090ULL, 0x0001d1b00001d150ULL,
0x0001d2700001d210ULL, 0x0001d3300001d2d0ULL, 0x0001d3f00001d390ULL, 0x0001d4b00001d450ULL,
0x060039040001d510ULL, 0x000000ff000001e0ULL, 0x003f010000010600ULL, 0x0000000a00000210ULL,
0x003f012000010608ULL, 0x0000000a000002b0ULL, 0x003f012000010688ULL, 0x0000000a00000430ULL,
0x003f0120000106a8ULL, 0x000000ff00000450ULL, 0x003f0100000106b8ULL, 0x000000ff000004e0ULL,
0x003f010700010600ULL, 0x0000002500000630ULL, 0x003f01020001068cULL, 0x0000002500000690ULL,
0x003f010100010688ULL, 0x000000ff00000ef0ULL, 0x003f0107000106a8ULL, 0x000000ff00001010ULL,
0x003f0101000106a8ULL, 0x000000ff00001070ULL, 0x003f0101000106b8ULL, 0x000000ff00001200ULL,
0x003f0105000106bcULL, 0x000000ff000013d0ULL, 0x003f0105000106bcULL, 0x000000ff00001c90ULL,
0x003f0107000106b0ULL, 0x000000ff00001db0ULL, 0x003f0101000106b0ULL, 0x0000002500001e10ULL,
0x003f010100010608ULL, 0x0000002500001e30ULL, 0x003f01050001060cULL, 0x0000002500002000ULL,
0x003f01050001060cULL, 0x000000ff000025b0ULL, 0x003f0105000106acULL, 0x000000ff00002780ULL,
0x003f0105000106acULL, 0x000000ff00004190ULL, 0x003f0101000106b8ULL, 0x000000ff000041c0ULL,
0x003f0105000106bcULL, 0x000000ff00004380ULL, 0x003f0105000106bcULL, 0x000000ff00004bd0ULL,
0x003f0107000106a8ULL, 0x000000ff00004c50ULL, 0x003f0101000106a8ULL, 0x000000ff00004c80ULL,
0x003f0105000106b4ULL, 0x000000ff00004e50ULL, 0x003f0105000106b4ULL, 0x000000ff00006760ULL,
0x003f0101000106b8ULL, 0x000000ff000067d0ULL, 0x003f010100010688ULL, 0x000000ff00006830ULL,
0x003f0105000106bcULL, 0x000000ff00006a00ULL, 0x003f0105000106bcULL, 0x000000ff00007250ULL,
0x003f0107000106b0ULL, 0x000000ff00007350ULL, 0x003f0101000106b0ULL, 0x00000025000073b0ULL,
0x003f010100010628ULL, 0x00000025000073d0ULL, 0x003f01050001062cULL, 0x00000025000075a0ULL,
0x003f01050001062cULL, 0x000000ff00007b20ULL, 0x003f0105000106acULL, 0x000000ff00007cf0ULL,
0x003f0105000106acULL, 0x000000ff00009510ULL, 0x003f0101000106b8ULL, 0x000000ff00009540ULL,
0x003f0105000106bcULL, 0x000000ff00009700ULL, 0x003f0105000106bcULL, 0x000000ff00009f50ULL,
0x003f0107000106a8ULL, 0x000000ff00009fd0ULL, 0x003f0101000106a8ULL, 0x000000ff0000a000ULL,
0x003f0105000106b4ULL, 0x000000ff0000a1d0ULL, 0x003f0105000106b4ULL, 0x000000ff0000b9e0ULL,
0x003f0101000106b8ULL, 0x000000ff0000ba50ULL, 0x003f010100010690ULL, 0x000000ff0000bab0ULL,
0x003f0105000106bcULL, 0x000000ff0000bc80ULL, 0x003f0105000106bcULL, 0x000000ff0000c4d0ULL,
0x003f0107000106b0ULL, 0x000000ff0000c5d0ULL, 0x003f0101000106b0ULL, 0x000000250000c630ULL,
0x003f010100010648ULL, 0x000000250000c650ULL, 0x003f01050001064cULL, 0x000000250000c820ULL,
0x003f01050001064cULL, 0x000000ff0000cda0ULL, 0x003f0105000106acULL, 0x000000ff0000cf70ULL,
0x003f0105000106acULL, 0x000000ff0000e790ULL, 0x003f0101000106b8ULL, 0x000000ff0000e7c0ULL,
0x003f0105000106bcULL, 0x000000ff0000e980ULL, 0x003f0105000106bcULL, 0x000000ff0000f1d0ULL,
0x003f0107000106a8ULL, 0x000000ff0000f250ULL, 0x003f0101000106a8ULL, 0x000000ff0000f280ULL,
0x003f0105000106b4ULL, 0x000000ff0000f450ULL, 0x003f0105000106b4ULL, 0x000000ff00010c60ULL,
0x003f0101000106b8ULL, 0x000000ff00010cd0ULL, 0x003f010100010698ULL, 0x000000ff00010d40ULL,
0x003f0105000106bcULL, 0x000000ff00010f10ULL, 0x003f0105000106bcULL, 0x000000ff00011760ULL,
0x003f0107000106b0ULL, 0x000000ff00011860ULL, 0x003f0101000106b0ULL, 0x00000025000118c0ULL,
0x003f010100010668ULL, 0x00000025000118e0ULL, 0x003f01050001066cULL, 0x0000002500011ab0ULL,
0x003f01050001066cULL, 0x000000ff00012030ULL, 0x003f0105000106acULL, 0x000000ff00012200ULL,
0x003f0105000106acULL, 0x000000ff00013a20ULL, 0x003f0101000106b8ULL, 0x000000ff00013a50ULL,
0x003f0105000106bcULL, 0x000000ff00013c10ULL, 0x003f0105000106bcULL, 0x000000ff00014480ULL,
0x003f0107000106a8ULL, 0x000000ff00014500ULL, 0x003f0101000106a8ULL, 0x000000ff00014530ULL,
0x003f0105000106b4ULL, 0x000000ff00014700ULL, 0x003f0105000106b4ULL, 0x000000ff00015f10ULL,
0x003f0101000106b8ULL, 0x000000ff00015f70ULL, 0x003f0101000106a0ULL, 0x000000ff00016c50ULL,
0x003f010100010600ULL, 0x000000ff00017a50ULL, 0x003f010500010604ULL, 0x000000ff00017c20ULL,
0x003f010500010604ULL, 0x000000ff00017f90ULL, 0x003f010100010600ULL, 0x000000ff00017fc0ULL,
0x003f010500010604ULL, 0x000000ff00018180ULL, 0x003f010500010604ULL, 0x0000002a0001ad70ULL,
0x003f010100000000ULL, 0x0000002a0001ae80ULL, 0x003f010500000004ULL, 0x0000002a0001b050ULL,
0x003f010500000004ULL, 0x000000350001c570ULL, 0x003f010100000000ULL, 0x000000350001c5d0ULL,
0x003f010100000008ULL, 0x000000350001c630ULL, 0x003f010100000010ULL, 0x000000350001c6a0ULL,
0x003f010100000018ULL, 0x00101c0400053803ULL, 0x000181e000016b70ULL, 0x0001c6e0000182b0ULL,
0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x00000000000003e4ULL, 0x0000001a00000002ULL,
0x000000000000030cULL, 0x0000001a00000002ULL, 0x0000000000000224ULL, 0x0000001a00000002ULL,
0x0000000000000134ULL, 0x0000001a00000002ULL, 0x0000000000000044ULL, 0x0000001a00000002ULL,
0x00000000000003bcULL, 0x0000001a00000002ULL, 0x00000000000002e4ULL, 0x0000001a00000002ULL,
0x0000000000000201ULL, 0x0000001a00000002ULL, 0x000000000000010cULL, 0x0000001a00000002ULL,
0x0000000000010700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x00000000000a7919ULL, 0x000e620000002100ULL,
0x0000000000087806ULL, 0x000fe200038e0000ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x0000000000007919ULL, 0x000ea20000002300ULL, 0x0000000800077300ULL, 0x000ee200000e0000ULL,
0x0000000304057899ULL, 0x000fe4000800063fULL, 0x0000000000027919ULL, 0x000ea20000002200ULL,
0x0000460000067ab9ULL, 0x000fc60000000a00ULL, 0x0000000000297919ULL, 0x000f220000002600ULL,
0x0000000800107309ULL, 0x0002a60000000000ULL, 0x0000000000147919ULL, 0x000ee80000002700ULL,
0x00000000002a7919ULL, 0x000ee20000000000ULL, 0x00000005ff2b7819ULL, 0x002fc6000001160aULL,
0x0000000000097919ULL, 0x000e680000000000ULL, 0x00001fff2b2b7589ULL, 0x000fe200000e0000ULL,
0x0000010000027a24ULL, 0x004fc600078e0202ULL, 0x00001fff00007589ULL, 0x000ea200000e0000ULL,
0x00000000020a7a24ULL, 0x000fca00078e020aULL, 0x000000ff0a00720cULL, 0x040fe40003f25270ULL,
0x0000000f0a00780cULL, 0x000fe20003f44070ULL, 0x000000102a0b7824ULL, 0x008fe200078e00ffULL,
0x000000030a00780cULL, 0x040fe40003f64070ULL, 0x0000007f0a00780cULL, 0x000fe40003f84070ULL,
0x000000090700720cULL, 0x002fe40003f02070ULL, 0x000001f00b0e7812ULL, 0x000fc600078ec0ffULL,
0x3fffff80ff029424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff039424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff04a424ULL, 0x000fe400078e00ffULL, 0x7fffffc0ff05a424ULL, 0x000fe200078e00ffULL,
0x01060002ff009388ULL, 0x0003e20000000a00ULL, 0x0000000400067824ULL, 0x004fe400078e022bULL,
0xff317217ff07c424ULL, 0x000fe200078e00ffULL, 0x010608040a00a388ULL, 0x0009e20000008a00ULL,
0x0000000206067824ULL, 0x000fe200078e00ffULL, 0x000000010a00780cULL, 0x000fe20003f44070ULL,
0x3fffff80ff089424ULL, 0x000fe200078e00ffULL, 0x010400070a00c388ULL, 0x0005e20000004800ULL,
0x00000020060c7824ULL, 0x000fc400078e00ffULL, 0x3fffff60ff02b424ULL, 0x002fe400078e00ffULL,
0x7fffff60ff03b424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff099424ULL, 0x000fe400078e00ffULL,
0x0000000829047824ULL, 0x010fe200078e00ffULL, 0x010688020a00b388ULL, 0x0003e20000008a00ULL,
0x0000000106057824ULL, 0x000fe400078e022aULL, 0x0000000514047c24ULL, 0x000fc4000f8e0204ULL,
0x7fffff00ff07a424ULL, 0x004fe200078e00ffULL, 0xffffffe00c0c7812ULL, 0x000fe200078ee205ULL,
0x00000200ff057424ULL, 0x000fc800078e00ffULL, 0x000000100c0c7824ULL, 0x000fe200078e00ffULL,
0x0000000806027817ULL, 0x002fe20007800000ULL, 0x0000000104037824ULL, 0x000fc800078e0206ULL,
0x0000000102027824ULL, 0x000fe200078e0a06ULL, 0x0000000106067810ULL, 0x000fc80007ffe0ffULL,
0x000000ff0200720cULL, 0x000fe20003f63070ULL, 0x0000000104047824ULL, 0x000fe200078e0206ULL,
0x000000010200780cULL, 0x000fe20003f83070ULL, 0x00005c0003027625ULL, 0x000fc800078e0005ULL,
0x00000001060d7824ULL, 0x000fe200078e022aULL, 0x0000000e02027210ULL, 0x000fe20007fbe0ffULL,
0x00000020060f7824ULL, 0x000fe400078e00ffULL, 0x00005c0004047625ULL, 0x000fc600078e0005ULL,
0xffffffe00f0d7812ULL, 0x000fe200078ee20dULL, 0x3fffff00ff06a424ULL, 0x000fe200078e00ffULL,
0x0000000e04047210ULL, 0x000fe20007fde0ffULL, 0x000000ffff037224ULL, 0x000fe400028e0603ULL,
0x000000100d0d7824ULL, 0x000fe200078e00ffULL, 0x0106a8060a00a388ULL, 0x000fe20000008a00ULL,
0x000000ffff057224ULL, 0x000fc600030e0605ULL, 0x0106b808ff009388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000020c7faeULL, 0x0003e2000d901c46ULL, 0x000000ffff077224ULL, 0x000fc400078e0a10ULL,
0x00000004ff067424ULL, 0x000fe200078e00ffULL, 0x00000000040d7faeULL, 0x0005e8000e101c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x01060407ffff038cULL, 0x0005e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01060000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000620014027625ULL, 0x000fc600078e0006ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000602287981ULL, 0x004ea2000c1e1900ULL,
0x000000ff0000720cULL, 0x000fe40003f05270ULL, 0x0000003f28277810ULL, 0x044fe40007ffe0ffULL,
0x000000ff28087810ULL, 0x000fe40007ffe0ffULL, 0x00000006ff277819ULL, 0x000fe40000011627ULL,
0x00000008ff267819ULL, 0x000fca0000011608ULL, 0x000165a000008947ULL, 0x000fea0003800000ULL,
0x000001ff0800780cULL, 0x000fe20003f24070ULL, 0x000000082b257824ULL, 0x000fe200078e00ffULL,
0x000000ff2700720cULL, 0x000fe20003f05270ULL, 0x00000003ff007424ULL, 0x000fe200078e00ffULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01068c0025ff738cULL, 0x0003e20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106880025ff7f8cULL, 0x0005e2000c80043fULL,
0xffffffffff247424ULL, 0x000fe200078e00ffULL, 0x0000005000008947ULL, 0x000fea0003800000ULL,
0x0000000214007824ULL, 0x002fe400078e00ffULL, 0x00006400ff027624ULL, 0x000fc800078e00ffULL,
0x0000640000007624ULL, 0x000fc800078e0202ULL, 0x0000600000027625ULL, 0x000fca00078e0006ULL,
0x0000000602247981ULL, 0x000324000c1e1900ULL, 0x0000580024007a24ULL, 0x012fc800078e02ffULL,
0x00000040000d7824ULL, 0x000fe200078e00ffULL, 0x0000043000001947ULL, 0x000fea0003800000ULL,
0x0000002528007217ULL, 0x000fe40007800000ULL, 0x00000004ff027819ULL, 0x000fe4000001162aULL,
0x000000f00b107812ULL, 0x000fe200078ec0ffULL, 0x0000000100007824ULL, 0x000fe200078e0a25ULL,
0x0000000202047810ULL, 0x040fe20007ffe0ffULL, 0x0000000125037824ULL, 0x040fe200078e0202ULL,
0x0000000402067810ULL, 0x040fe40007ffe0ffULL, 0x000000000200720cULL, 0x0c0fe20003f06070ULL,
0x0000000125057824ULL, 0x000fe200078e0204ULL, 0x0000000602077810ULL, 0x000fe20007ffe0ffULL,
0x0000004029027824ULL, 0x000fe200078e0203ULL, 0x000000000400720cULL, 0x080fe20003f26070ULL,
0x0000000103047824ULL, 0x140fe200078e022aULL, 0x000000000600720cULL, 0x000fe20003f46070ULL,
0x00000010030c7824ULL, 0x000fe200078e00ffULL, 0x000000020d097210ULL, 0x000fe20007f7e0ffULL,
0x0000000105037824ULL, 0x000fc400078e022aULL, 0x0000001005057824ULL, 0x000fe200078e00ffULL,
0x00005e0009087a11ULL, 0x000fe200078840ffULL, 0x000000ffff0a7224ULL, 0x000fe200018e06ffULL,
0x000000000700720cULL, 0x000fe20003f66070ULL, 0x0000000125067824ULL, 0x000fe200078e0206ULL,
0x0000000202007810ULL, 0x040fe40007ffe0ffULL, 0xfffffff005057812ULL, 0x000fe400078ee203ULL,
0x0000000402037810ULL, 0x000fe40007ffe0ffULL, 0x000000000d0f7210ULL, 0x000fe20007fde0ffULL,
0x0000000106007824ULL, 0x000fe200078e022aULL, 0x0000000602027810ULL, 0x000fe20007ffe0ffULL,
0x0000001006067824ULL, 0x000fe200078e00ffULL, 0xfffffff00c047812ULL, 0x000fc400078ee204ULL,
0x00005f0009097a11ULL, 0x000fe400020f440aULL, 0x000000030d0c7210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff037224ULL, 0x000fe200030e06ffULL, 0x000000020d0a7210ULL, 0x000fe20007fbe0ffULL,
0x0000000125027824ULL, 0x000fe200078e0207ULL, 0x00005e000f0e7a11ULL, 0x040fe200078c40ffULL,
0x000000ffff0d7224ULL, 0x000fe200020e06ffULL, 0xfffffff006077812ULL, 0x000fe200078ee200ULL,
0x0000000102007824ULL, 0x040fe200078e022aULL, 0x00005f000f0f7a11ULL, 0x000fe200030f4403ULL,
0x0000001002117824ULL, 0x000fe200078e00ffULL, 0x0000000810027210ULL, 0x000fe20007fde0ffULL,
0x000000ffff087224ULL, 0x000fe200028e06ffULL, 0x0000c00004047811ULL, 0x000fc400078e20ffULL,
0x00005e000c0b7a11ULL, 0x000fe200078840ffULL, 0x000000ffff037224ULL, 0x000fe200030e0609ULL,
0x00005e000a067a11ULL, 0x000fe400078a40ffULL, 0x00005f000c0c7a11ULL, 0x000fe400020f440dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002047faeULL, 0x0003e2000c101c46ULL,
0x00005f000a0a7a11ULL, 0x000fe400028f4408ULL, 0x0000001006067210ULL, 0x000fe40007fbe0ffULL,
0xfffffff011097812ULL, 0x000fc400078ee200ULL, 0x0000c00005007811ULL, 0x000fe400078e20ffULL,
0x0000c00007087811ULL, 0x000fe200078e20ffULL, 0x000000ffff077224ULL, 0x000fe200028e060aULL,
0x0000c00009097811ULL, 0x000fe400078e20ffULL, 0x000000100e027210ULL, 0x082fe40007f1e0ffULL,
0x000000100b047210ULL, 0x000fc60007f9e0ffULL, 0x000000ffff037224ULL, 0x000fe400000e060fULL,
0x000000ffff057224ULL, 0x000fc600020e060cULL, 0x0000000002007faeULL, 0x0003e8000c901c46ULL,
0x0000000004087faeULL, 0x0003e8000d101c46ULL, 0x0000000006097faeULL, 0x0003e2000d901c46ULL,
0x0000038000007947ULL, 0x000fea0003800000ULL, 0x000000252a007211ULL, 0x000fc800078fe0ffULL,
0x0000000200037810ULL, 0x040fe20007ffe0ffULL, 0x0000000100027824ULL, 0x140fe200078e022aULL,
0x0000000600077810ULL, 0x040fe20007ffe0ffULL, 0x0000001000047824ULL, 0x000fe400078e00ffULL,
0x0000000103057824ULL, 0x040fe400078e022aULL, 0x0000001003037824ULL, 0x000fe200078e00ffULL,
0xfffffff004047812ULL, 0x000fe200078ee202ULL, 0x0000004029027824ULL, 0x000fe400078e0200ULL,
0x0000001007117824ULL, 0x000fe200078e00ffULL, 0xfffffff003057812ULL, 0x000fc400078ee205ULL,
0x0000000400037810ULL, 0x000fe40007ffe0ffULL, 0x000000020d107210ULL, 0x000fe40007f1e0ffULL,
0x0000000202007810ULL, 0x040fe20007ffe0ffULL, 0x00000010030a7824ULL, 0x040fe200078e00ffULL,
0x0000000402067810ULL, 0x040fe40007ffe0ffULL, 0x0000000602087810ULL, 0x000fe20007ffe0ffULL,
0x0000000103027824ULL, 0x100fe200078e022aULL, 0x000000000d0e7210ULL, 0x000fe20007f3e0ffULL,
0x0000000107037824ULL, 0x000fe200078e022aULL, 0x000000080d097210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff007224ULL, 0x000fe200000e06ffULL, 0x00005e00100f7a11ULL, 0x000fc400078040ffULL,
0xfffffff00a077812ULL, 0x000fe400078ee202ULL, 0xfffffff0110a7812ULL, 0x000fe200078ee203ULL,
0x000000ffff037224ULL, 0x000fe200008e06ffULL, 0x000000f00b117812ULL, 0x000fe400078ec0ffULL,
0x000000060d0c7210ULL, 0x000fe40007f5e0ffULL, 0x00005f0010107a11ULL, 0x000fe200000f4400ULL,
0x000000ffff007224ULL, 0x000fe200018e06ffULL, 0x00005e000e0d7a11ULL, 0x000fe200078240ffULL,
0x000000ffff0b7224ULL, 0x000fe200010e06ffULL, 0x00005e0009087a11ULL, 0x000fc400078640ffULL,
0x0000000f11027210ULL, 0x000fe40007f1e0ffULL, 0x00005e000c067a11ULL, 0x000fe400078440ffULL,
0x00005f000e0e7a11ULL, 0x000fe200008f4403ULL, 0x000000ffff037224ULL, 0x000fe200000e0610ULL,
0x00005f0009097a11ULL, 0x000fe400018f4400ULL, 0x0000c00004007811ULL, 0x000fe400078e20ffULL,
0x0000000d11047210ULL, 0x000fc40007f1e0ffULL, 0x00005f000c0b7a11ULL, 0x000fe200010f440bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002007faeULL, 0x0003e2000b901c46ULL,
0x0000000611067210ULL, 0x040fe40007f3e0ffULL, 0x0000000811087210ULL, 0x000fe40007f5e0ffULL,
0x0000c0000a0a7811ULL, 0x000fc600078e20ffULL, 0x000000ffff097224ULL, 0x000fe200010e0609ULL,
0x0000c00005007811ULL, 0x002fe200078e20ffULL, 0x000000ffff057224ULL, 0x000fe200000e060eULL,
0x0000c00007027811ULL, 0x000fe200078e20ffULL, 0x000000ffff077224ULL, 0x000fc600008e060bULL,
0x0000000004007faeULL, 0x0003e8000b901c46ULL, 0x0000000006027faeULL, 0x0003e8000b901c46ULL,
0x00000000080a7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x000000ff2600720cULL, 0x000fe20003f05270ULL, 0x000000ffff237224ULL, 0x000fe200078e00ffULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x000000ffff057224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff027f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b800ff167f8cULL, 0x000ee2000c80043fULL,
0x000000ffff047224ULL, 0x000fe200078e00ffULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x00014ec000008947ULL, 0x000fea0003800000ULL,
0x0000000214227824ULL, 0x000fe400078e00ffULL, 0x00006400ff007624ULL, 0x000fc400078e00ffULL,
0x000000ffff437224ULL, 0x002fe400078e0003ULL, 0x000000ffff4a7224ULL, 0x008fe400078e0017ULL,
0x0000640022227624ULL, 0x000fe400078e0200ULL, 0xff317217ff447424ULL, 0x000fe400078e00ffULL,
0x000000ffff217224ULL, 0x000fe400078e00ffULL, 0x000000ffff4f7224ULL, 0x000fc400078e00ffULL,
0x000000ffff137224ULL, 0x000fc400078e00ffULL, 0x0000010021007824ULL, 0x000fca00078e00ffULL,
0x000000280000720cULL, 0x000fda0003f06070ULL, 0x00014dc000000947ULL, 0x004fea0003800000ULL,
0x000000ffff207224ULL, 0x000fc400078e004fULL, 0x0000000000027805ULL, 0x000fca0000015200ULL,
0x0106bc00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe4000780484aULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff167224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001402147210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e03ULL, 0x003d09001400780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401400780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011415ULL,
0x0000001400007211ULL, 0x000fca00078110ffULL, 0x000000ffff147224ULL, 0x000fca00000e0615ULL,
0x0000000200007819ULL, 0x000fc80000001214ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000116167810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106bc00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe4000780484aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000121007810ULL, 0x000fe20007ffe0ffULL, 0x0000580024247a24ULL, 0x000fc600078e02ffULL,
0x000000260000720cULL, 0x000fe20003f26070ULL, 0x0000004024247824ULL, 0x000fd800078e00ffULL,
0x0000048000009947ULL, 0x000fea0003800000ULL, 0x00000004ff1b7819ULL, 0x100fe4000001162aULL,
0x0000002021007811ULL, 0x000fe400078e40ffULL, 0x000000021b3d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000125037824ULL, 0x000fe200078e021bULL, 0x0000000028027217ULL, 0x000fe40007800000ULL,
0x000000041b3f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000103147824ULL, 0x000fe200078e022aULL,
0x000000061b407810ULL, 0x000fe20007ffe0ffULL, 0x00000010033c7824ULL, 0x000fc400078e00ffULL,
0x0000000125157824ULL, 0x000fe400078e023dULL, 0x0000000102027824ULL, 0x000fe200078e0a00ULL,
0xfffffff03c3c7812ULL, 0x000fe200078ee214ULL, 0x0000000115147824ULL, 0x000fe200078e022aULL,
0x0000002029007811ULL, 0x000fe200078e30ffULL, 0x00000010153e7824ULL, 0x000fe200078e00ffULL,
0x0000000225027217ULL, 0x040fe20007800000ULL, 0x00000001251d7824ULL, 0x040fe400078e023fULL,
0x00000001251e7824ULL, 0x000fe200078e0240ULL, 0xfffffff03e3e7812ULL, 0x000fe200078ee214ULL,
0x0000000115147824ULL, 0x000fc400078e0200ULL, 0x0000000103037824ULL, 0x100fe400078e0200ULL,
0x000000011d157824ULL, 0x140fe200078e0200ULL, 0x0000001424147210ULL, 0x000fe20007f5e0ffULL,
0x000000011e007824ULL, 0x000fe200078e0200ULL, 0x0000000324167210ULL, 0x000fe20007f1e0ffULL,
0x000000101e417824ULL, 0x000fe200078e00ffULL, 0x00000015241c7210ULL, 0x040fe40007fbe0ffULL,
0x0000000024177210ULL, 0x000fe20007fde0ffULL, 0x000000011d007824ULL, 0x000fc400078e022aULL,
0x000000101d247824ULL, 0x000fe400078e00ffULL, 0x000000011e1d7824ULL, 0x000fe400078e022aULL,
0x000000ffff1e7224ULL, 0x000fe200010e06ffULL, 0xfffffff024247812ULL, 0x000fe200078ee200ULL,
0x0000000102007824ULL, 0x000fe200078e0a25ULL, 0xfffffff041417812ULL, 0x000fe200078ee21dULL,
0x000000102a027824ULL, 0x000fe200078e00ffULL, 0x00005e00141d7a11ULL, 0x000fe200078840ffULL,
0x000000ffff157224ULL, 0x000fe200000e06ffULL, 0x00005e0016037a11ULL, 0x000fc400078040ffULL,
0x000000f0021f7812ULL, 0x000fe400078ec0ffULL, 0x00005f00141e7a11ULL, 0x000fe200020f441eULL,
0x000000ffff147224ULL, 0x000fe200030e06ffULL, 0x00005f0016167a11ULL, 0x000fe400000f4415ULL,
0x0000001f03027210ULL, 0x000fe40007f9e0ffULL, 0x000000001b00720cULL, 0x000fe20003f66070ULL,
0x000000ffff1b7224ULL, 0x000fe200028e06ffULL, 0x00005e001c157a11ULL, 0x000fe200078a40ffULL,
0x000000ffff037224ULL, 0x000fe200020e0616ULL, 0x00005e0017167a11ULL, 0x000fc400078c40ffULL,
0x000000003d00720cULL, 0x080fe40003f46070ULL, 0x000000003f00720cULL, 0x080fe40003f06070ULL,
0x000000004000720cULL, 0x000fe40003f86070ULL, 0x0000e0003c007811ULL, 0x000fe400078e20ffULL,
0x00005f001c1c7a11ULL, 0x000fe400028f441bULL, 0x00005f0017177a11ULL, 0x000fe200030f4414ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002007faeULL, 0x0003e2000d901c46ULL,
0x0000001f1d147210ULL, 0x000fc40007fbe0ffULL, 0x0000e000241b7811ULL, 0x000fe400078e20ffULL,
0x0000001f15027210ULL, 0x082fe20007f7e0ffULL, 0x000000ffff157224ULL, 0x000fe200028e061eULL,
0x0000001f16167210ULL, 0x000fe40007fbe0ffULL, 0x0000e0003e007811ULL, 0x000fe200078e20ffULL,
0x000000ffff037224ULL, 0x000fe200018e061cULL, 0x0000e000411c7811ULL, 0x000fe200078e20ffULL,
0x000000ffff177224ULL, 0x000fe400028e0617ULL, 0x0000000014007faeULL, 0x0003e8000d101c46ULL,
0x00000000021b7faeULL, 0x0003e8000c101c46ULL, 0x00000000161c7faeULL, 0x0003e2000e101c46ULL,
0x000003a000007947ULL, 0x000fea0003800000ULL, 0x000000252a007211ULL, 0x000fe400078fe0ffULL,
0x0000002029147811ULL, 0x000fc400078e30ffULL, 0x0000000200037810ULL, 0x040fe20007ffe0ffULL,
0x0000000100027824ULL, 0x140fe200078e022aULL, 0x0000000600177810ULL, 0x040fe20007ffe0ffULL,
0x00000010003c7824ULL, 0x000fe400078e00ffULL, 0x0000000103157824ULL, 0x040fe400078e022aULL,
0x00000010033d7824ULL, 0x040fe200078e00ffULL, 0xfffffff03c3c7812ULL, 0x000fe200078ee202ULL,
0x0000000103027824ULL, 0x000fe400078e0214ULL, 0x00000001171b7824ULL, 0x000fe200078e022aULL,
0xfffffff03d3d7812ULL, 0x000fe200078ee215ULL, 0x00000010173e7824ULL, 0x000fe200078e00ffULL,
0x0000000400157810ULL, 0x040fe20007ffe0ffULL, 0x0000000100007824ULL, 0x000fe200078e0214ULL,
0x00000002241d7210ULL, 0x000fc40007f5e0ffULL, 0xfffffff03e3e7812ULL, 0x000fe200078ee21bULL,
0x0000000115037824ULL, 0x100fe200078e0214ULL, 0x0000000024007210ULL, 0x040fe20007f1e0ffULL,
0x0000000117147824ULL, 0x000fe400078e0214ULL, 0x0000000115167824ULL, 0x040fe200078e022aULL,
0x0000000324037210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff1e7224ULL, 0x000fe200000e06ffULL,
0x0000001424147210ULL, 0x000fe20007f9e0ffULL, 0x0000001015247824ULL, 0x000fe200078e00ffULL,
0x00005e0000027a11ULL, 0x000fe200078040ffULL, 0x000000102a157824ULL, 0x000fc400078e00ffULL,
0x000000ffff177224ULL, 0x000fe200018e06ffULL, 0x00005f00001e7a11ULL, 0x000fe200000f441eULL,
0x000000ffff007224ULL, 0x000fe200010e06ffULL, 0x000000f0151f7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff1b7224ULL, 0x000fe200020e06ffULL, 0xfffffff024247812ULL, 0x000fe400078ee216ULL,
0x00005e001d157a11ULL, 0x000fe400078440ffULL, 0x00005e0003167a11ULL, 0x000fe400078640ffULL,
0x0000001f02027210ULL, 0x000fc40007f1e0ffULL, 0x00005e00141c7a11ULL, 0x040fe400078840ffULL,
0x00005f001d1d7a11ULL, 0x000fe400010f4400ULL, 0x00005f0003177a11ULL, 0x000fe200018f4417ULL,
0x000000ffff037224ULL, 0x000fe200000e061eULL, 0x00005f00141b7a11ULL, 0x000fe400020f441bULL,
0x0000e0003c007811ULL, 0x000fe400078e20ffULL, 0x0000001f15147210ULL, 0x000fc40007f1e0ffULL,
0x0000001f16167210ULL, 0x080fe20007f5e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002007faeULL, 0x0003e2000b901c46ULL, 0x0000001f1c1c7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff157224ULL, 0x000fe400000e061dULL, 0x000000ffff177224ULL, 0x000fe400010e0617ULL,
0x000000ffff1d7224ULL, 0x000fe200018e061bULL, 0x0000e0003d007811ULL, 0x002fe400078e20ffULL,
0x0000e00024027811ULL, 0x000fc400078e20ffULL, 0x0000e0003e037811ULL, 0x000fe200078e20ffULL,
0x0000000014007faeULL, 0x0003e8000b901c46ULL, 0x0000000016027faeULL, 0x0003e8000b901c46ULL,
0x000000001c037faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x000000014f027810ULL, 0x000fe20007ffe0ffULL, 0x0000008000007945ULL, 0x000fe20003800000ULL,
0xffffffffff247424ULL, 0x000fc400078e00ffULL, 0x000000270200720cULL, 0x000fda0003f06070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x0000000122027824ULL, 0x000fe400078e0202ULL,
0x00000004ff037424ULL, 0x000fc800078e00ffULL, 0x0000600002027625ULL, 0x000fca00078e0003ULL,
0x0000000602247981ULL, 0x000324000c1e1900ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b000ff4c7f8cULL, 0x000ee2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106080025167f8cULL, 0x0002a4000c80043fULL,
0x0000000000027805ULL, 0x002fc40000015200ULL, 0x01060c0025007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x006fe40007804817ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1b7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101b00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001402147210ULL, 0x000fca0007f1e1ffULL, 0x0000000115157824ULL, 0x000fe200000e0e03ULL,
0x003d09001400780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401400780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011415ULL, 0x0000001400007211ULL, 0x000fca00078110ffULL,
0x000000ffff147224ULL, 0x000fca00000e0615ULL, 0x0000000200007819ULL, 0x000fc80000001214ULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000011b1b7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01060c0025007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007804817ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000102a1f7824ULL, 0x000fe200078e00ffULL,
0x00000001ff007819ULL, 0x000fe2000001162aULL, 0xffffffffff1d7424ULL, 0x000fc600078e00ffULL,
0x0000000c00007812ULL, 0x000fe400078ec0ffULL, 0x000000701f1e7812ULL, 0x000fca00078ec0ffULL,
0x000000011e1e7824ULL, 0x000fca00078e0200ULL, 0x010000001e007984ULL, 0x000e680000000800ULL,
0x010200001e027984ULL, 0x0004e20000000800ULL, 0x000000440000720bULL, 0x002fe20003f1d000ULL,
0x0001a6027f007947ULL, 0x000fd8000b800000ULL, 0x0000000000037806ULL, 0x004fc800000e0100ULL,
0x0000ffff03157812ULL, 0x000fe2000780c0ffULL, 0x0000047000007945ULL, 0x000fe20003800000ULL,
0x00000001ff167424ULL, 0x000fe400078e00ffULL, 0x000000ffff4e7224ULL, 0x000fc400078e0044ULL,
0x0000001fff1c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff1b7424ULL, 0x000fca00078e00ffULL,
0x0000041000008947ULL, 0x000fea0003800000ULL, 0x000000ff2b00720cULL, 0x000fe40003f05270ULL,
0x000000440000720bULL, 0x000fe20003f54000ULL, 0x0001a5a27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000037806ULL, 0x000fc400010e0100ULL, 0x00000000444e7209ULL, 0x000fe20007810000ULL,
0x0000035000017945ULL, 0x000fe20003800000ULL, 0x0000991003147816ULL, 0x000fc600000000ffULL,
0x0104004e1e008388ULL, 0x0003e20000000800ULL, 0x000000ff1400720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x8000004e44147221ULL, 0x002fe20000010000ULL,
0x000000ff03ff7812ULL, 0x000fe2000780c0ffULL, 0x0000017000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b14147820ULL, 0x000fcc0000410000ULL, 0x0000001400147308ULL, 0x000e680000000800ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff477819ULL, 0x000fe2000001162aULL,
0x0001a5027f007947ULL, 0x000fea000b800000ULL, 0x00001f4714477589ULL, 0x0022a400000e0000ULL,
0x0000004738387220ULL, 0x084fe20000410000ULL, 0x0000004739397220ULL, 0x080fe20000410000ULL,
0x0000004734347220ULL, 0x080fe20000410000ULL, 0x0000004735357220ULL, 0x080fe20000410000ULL,
0x0000004730307220ULL, 0x080fe20000410000ULL, 0x0000004731317220ULL, 0x080fe20000410000ULL,
0x000000472c2c7220ULL, 0x080fe20000410000ULL, 0x000000472d2d7220ULL, 0x080fe20000410000ULL,
0x0000004704047220ULL, 0x080fe20000410000ULL, 0x0000004705057220ULL, 0x080fe20000410000ULL,
0x000000470c0c7220ULL, 0x080fe20000410000ULL, 0x000000470d0d7220ULL, 0x080fe20000410000ULL,
0x0000004708087220ULL, 0x080fe20000410000ULL, 0x0000004709097220ULL, 0x080fe20000410000ULL,
0x0000004710107220ULL, 0x080fe20000410000ULL, 0x0000004711117220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0003ff7812ULL, 0x000fe2000780c0ffULL,
0x0000001423237220ULL, 0x002fd80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000082a477811ULL, 0x000fe200078ff0ffULL, 0x0001a3e27f007947ULL, 0x000fea000b800000ULL,
0x00001f4714477589ULL, 0x0002a400000e0000ULL, 0x000000473a3a7220ULL, 0x084fe20000410000ULL,
0x000000473b3b7220ULL, 0x080fe20000410000ULL, 0x0000004736367220ULL, 0x080fe20000410000ULL,
0x0000004737377220ULL, 0x080fe20000410000ULL, 0x0000004732327220ULL, 0x080fe20000410000ULL,
0x0000004733337220ULL, 0x080fe20000410000ULL, 0x000000472e2e7220ULL, 0x080fe20000410000ULL,
0x000000472f2f7220ULL, 0x080fe20000410000ULL, 0x0000004706067220ULL, 0x080fe20000410000ULL,
0x0000004707077220ULL, 0x080fe20000410000ULL, 0x000000470e0e7220ULL, 0x080fe20000410000ULL,
0x000000470f0f7220ULL, 0x080fe20000410000ULL, 0x000000470a0a7220ULL, 0x080fe20000410000ULL,
0x000000470b0b7220ULL, 0x080fe20000410000ULL, 0x0000004712127220ULL, 0x080fe20000410000ULL,
0x0000004713137220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff15ff7812ULL, 0x000fda0007806003ULL, 0x8000004e00000221ULL, 0x000fe20000010000ULL,
0x00007610ff160816ULL, 0x000fc60000000016ULL, 0x3fb8aa3b00000820ULL, 0x000fc80000410000ULL,
0x00000000001a0308ULL, 0x000e640000000800ULL, 0x0000001a02020220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002302237221ULL, 0x008fc40000010000ULL,
0x0000000000027805ULL, 0x000fca0000015200ULL, 0x0106ac00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007804843ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff177224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101700780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001402147210ULL, 0x000fca0007f1e1ffULL, 0x0000000115157824ULL, 0x000fe200000e0e03ULL,
0x003d09001400780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401400780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011415ULL, 0x0000001400007211ULL, 0x000fca00078110ffULL,
0x000000ffff147224ULL, 0x000fca00000e0615ULL, 0x0000000200007819ULL, 0x000fc80000001214ULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000117177810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106ac00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007804843ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991016007816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff0000720cULL, 0x000fda0003f45270ULL,
0x0000012000002947ULL, 0x000fea0003800000ULL, 0x0000001aff00723eULL, 0x000fe400000010ffULL,
0x00000002ff027819ULL, 0x000fe4000001162aULL, 0x0000541000007816ULL, 0x000fe20000000000ULL,
0x00019fe27f007947ULL, 0x000fea000b800000ULL, 0x00001f0200197589ULL, 0x0002a400000e0000ULL,
0x0000000802187810ULL, 0x000fe20007ffe0ffULL, 0x0001a0127f007947ULL, 0x000fea000b800000ULL,
0x00001f1800187589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001002477810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff5a7224ULL, 0x000fe200078e0000ULL,
0x000028e000467802ULL, 0x000fc40000000f00ULL, 0x0001ae2000007944ULL, 0x01efea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001802477810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff5a7224ULL, 0x004fe200078e0000ULL, 0x0000293000467802ULL, 0x000fc40000000f00ULL,
0x0001add000007944ULL, 0x01afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000082a527812ULL, 0x000fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000004ff177819ULL, 0x000fc4000001162aULL, 0x0000000752527812ULL, 0x100fe400078ef82aULL,
0x000000072a547812ULL, 0x000fe200078ec0ffULL, 0x000000042b567824ULL, 0x000fe400078e0217ULL,
0x0000001052167824ULL, 0x000fe200078e00ffULL, 0x0000000854547812ULL, 0x000fe200078ef82aULL,
0x0000000152007824ULL, 0x04afe400078e0256ULL, 0x0000001052037824ULL, 0x000fe400078e00ffULL,
0x0000000117507824ULL, 0x000fe200078e0254ULL, 0xfffffff016167812ULL, 0x000fc400078ee200ULL,
0x000000022b007811ULL, 0x000fe400078e10ffULL, 0x0000c00016167811ULL, 0x000fc600078e20ffULL,
0x0000000117537824ULL, 0x000fe400078e0200ULL, 0x000000001644783bULL, 0x000e640000004200ULL,
0x0000000152027824ULL, 0x000fca00078e0253ULL, 0xfffffff003027812ULL, 0x000fc800078ee202ULL,
0x0000c00002157811ULL, 0x000fe400078e20ffULL, 0x0000001052027812ULL, 0x000fc600078efcffULL,
0x000000001548783bULL, 0x000ee20000004200ULL, 0x0000000002557210ULL, 0x000fe20007ffe017ULL,
0x0000000156517824ULL, 0x000fe400078e0202ULL, 0x0000001002037824ULL, 0x040fe400078e00ffULL,
0x0000001002027824ULL, 0x000fe400078e00ffULL, 0x0000000854007824ULL, 0x000fe200078e00ffULL,
0xfffffff003517812ULL, 0x000fe400078ee251ULL, 0xfffffff002557812ULL, 0x000fc400078ee255ULL,
0x0000c00051147811ULL, 0x000fe400078e20ffULL, 0x0000c00055027811ULL, 0x000fe400078e20ffULL,
0x0000000250037810ULL, 0x000fe20007ffe0ffULL, 0x000000001440783bULL, 0x000ea60000004200ULL,
0xfffffff800037812ULL, 0x000fe200078ee203ULL, 0x00000000023c783bULL, 0x000ea20000004200ULL,
0x00000010ff007819ULL, 0x002fc40000011644ULL, 0x000000ff45587812ULL, 0x040fe400078ec0ffULL,
0x000000ff00007812ULL, 0x000fe400078ec0ffULL, 0x0000ffff46717812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5e7819ULL, 0x100fe40000011645ULL, 0x00000018ff887819ULL, 0x000fe40000011645ULL,
0x0000ffff45857812ULL, 0x000fc400078ec0ffULL, 0x00000000ff00723eULL, 0x000fe400020006ffULL,
0x00000010ff5f7819ULL, 0x108fe40000011648ULL, 0x000000ff48617812ULL, 0x040fe400078ec0ffULL,
0x00000018ff607819ULL, 0x000fe40000011648ULL, 0x0000ffff48747812ULL, 0x000fe400078ec0ffULL,
0x00000010ff807819ULL, 0x000fc40000011646ULL, 0x000000ff46897812ULL, 0x000fe400078ec0ffULL,
0x00000018ff457819ULL, 0x000fe40000011646ULL, 0x00000010ff7f7819ULL, 0x000fe40000011647ULL,
0x000000ff478a7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff817819ULL, 0x004fe40000011641ULL,
0x000000ff416f7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff707819ULL, 0x000fe40000011641ULL,
0x0000ffff41757812ULL, 0x000fe400078ec0ffULL, 0x00000058ff41723eULL, 0x000fe400020006ffULL,
0x00000010ff487819ULL, 0x100fe4000001163cULL, 0x000000ff3c907812ULL, 0x000fe400078ec0ffULL,
0x00000018ff8f7819ULL, 0x000fc4000001163cULL, 0x0000ffff3c5c7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff3c7819ULL, 0x000fe40000011671ULL, 0x00000018ff467819ULL, 0x000fe40000011647ULL,
0x0000ffff47727812ULL, 0x000fe400078ec0ffULL, 0x00000010ff657819ULL, 0x000fe4000001164aULL,
0x000000ff4a677812ULL, 0x000fc400078ec0ffULL, 0x00000018ff667819ULL, 0x000fe4000001164aULL,
0x0000ffff4a787812ULL, 0x000fe400078ec0ffULL, 0x00000010ff477819ULL, 0x100fe40000011642ULL,
0x000000ff428c7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff8b7819ULL, 0x000fe40000011642ULL,
0x0000ffff424a7812ULL, 0x000fe200078ec0ffULL, 0x20000041ff427230ULL, 0x000fe20000004100ULL,
0x0000003cff3c723eULL, 0x000fe200020006ffULL, 0x20000000ff417230ULL, 0x000fe20000004100ULL,
0x00000008ff007819ULL, 0x000fc40000011674ULL, 0x0000ffff49777812ULL, 0x000fe200078ec0ffULL,
0x2000003cff837230ULL, 0x000fe20000004100ULL, 0x00000000ff00723eULL, 0x000fe400020006ffULL,
0x00000008ff3c7819ULL, 0x000fe40000011677ULL, 0x0000ffff4b797812ULL, 0x000fe200078ec0ffULL,
0x20000000ff7b7230ULL, 0x000fe20000004100ULL, 0x00000010ff5d7819ULL, 0x000fe4000001163dULL,
0x000000ff3d927812ULL, 0x000fc400078ec0ffULL, 0x00000018ff917819ULL, 0x000fe4000001163dULL,
0x0000ffff3d5b7812ULL, 0x000fe400078ec0ffULL, 0x0000003cff3c723eULL, 0x000fe400020006ffULL,
0x00000008ff3d7819ULL, 0x000fe40000011672ULL, 0x00000008ff007819ULL, 0x000fe20000011679ULL,
0x2000003cff7c7230ULL, 0x000fe20000004100ULL, 0x0000003dff3d723eULL, 0x000fe200020006ffULL,
0x00000008543c7824ULL, 0x000fe200078e00ffULL, 0x00000000ff00723eULL, 0x000fc400020006ffULL,
0x000000ff44577812ULL, 0x000fe200078ec0ffULL, 0x2000003dff867230ULL, 0x000fe20000004100ULL,
0x00000008ff3d7819ULL, 0x000fe20000011678ULL, 0x20000000ff777230ULL, 0x000fe20000004100ULL,
0xfffffff83c007812ULL, 0x000fe400078ee250ULL, 0x0000003dff3d723eULL, 0x000fe400020006ffULL,
0x0000a000003c7811ULL, 0x000fe400078e20ffULL, 0x00000010ff737819ULL, 0x000fe20000011640ULL,
0x2000003dff747230ULL, 0x000fe20000004100ULL, 0x000000ff406e7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff6d7819ULL, 0x000fe40000011640ULL, 0x0000ffff40827812ULL, 0x000fe400078ec0ffULL,
0x00000057ff40723eULL, 0x000fe400020006ffULL, 0x00000010ff5a7819ULL, 0x100fe4000001163eULL,
0x000000ff3e947812ULL, 0x000fe200078ec0ffULL, 0x20000040ff407230ULL, 0x000fe20000004100ULL,
0x00000018ff937819ULL, 0x000fc4000001163eULL, 0x0000ffff3e597812ULL, 0x000fe400078ec0ffULL,
0x00000010ff587819ULL, 0x100fe4000001163fULL, 0x000000ff3f967812ULL, 0x040fe400078ec0ffULL,
0x00000018ff957819ULL, 0x000fe4000001163fULL, 0x0000ffff3f577812ULL, 0x000fe400078ec0ffULL,
0x000000003c3c783bULL, 0x000e620000000200ULL, 0x000000ff5e5e7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff44847812ULL, 0x000fe400078ec0ffULL, 0x0000005eff5e723eULL, 0x000fe400020006ffULL,
0x00000018ff877819ULL, 0x000fe40000011644ULL, 0x00000010ff627819ULL, 0x100fe40000011649ULL,
0x000000ff49647812ULL, 0x000fe400078ec0ffULL, 0x00000018ff637819ULL, 0x000fc40000011649ULL,
0x00000010ff447819ULL, 0x100fe40000011643ULL, 0x000000ff438e7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff8d7819ULL, 0x000fe40000011643ULL, 0x0000ffff43497812ULL, 0x000fe200078ec0ffULL,
0x2000005eff437230ULL, 0x000fe20000004100ULL, 0x00000008ff847819ULL, 0x000fe40000011684ULL,
0x00000008ff857819ULL, 0x000fc40000011685ULL, 0x00000087ff87723eULL, 0x000fe400020006ffULL,
0x00000088ff88723eULL, 0x000fe400020006ffULL, 0x00000010ff407819ULL, 0x000fe20000011640ULL,
0x20000087ff877230ULL, 0x000fe20000004100ULL, 0x00000010ff417819ULL, 0x000fe20000011641ULL,
0x20000088ff887230ULL, 0x000fe20000004100ULL, 0x00000084ff84723eULL, 0x000fe400020006ffULL,
0x00000085ff85723eULL, 0x000fc400020006ffULL, 0x000000ff7f7f7812ULL, 0x000fe200078ec0ffULL,
0x000000193c3ca231ULL, 0x082fe200003400ffULL, 0x00000010ff427819ULL, 0x000fe20000011642ULL,
0x000000193e3ea231ULL, 0x000fe200003400ffULL, 0x00000010ff437819ULL, 0x000fe20000011643ULL,
0x000000183d3da231ULL, 0x080fe200003400ffULL, 0x000000ff4b6c7812ULL, 0x000fe200078ec0ffULL,
0x000000183f3fa231ULL, 0x000fe200003400ffULL, 0x00000045ff45723eULL, 0x000fe200020006ffULL,
0x20000084ff847230ULL, 0x000fe20000004100ULL, 0x00000046ff46723eULL, 0x000fe200020006ffULL,
0x20000085ff857230ULL, 0x000fe20000004100ULL, 0x0000008aff8a723eULL, 0x000fe200020006ffULL,
0x20000045ff767230ULL, 0x000fe20000004100ULL, 0x0000105441407816ULL, 0x000fe20000000040ULL,
0x20000046ff7a7230ULL, 0x000fe20000004100ULL, 0x000000ff81817812ULL, 0x000fe200078ec0ffULL,
0x2000008aff8a7230ULL, 0x000fe20000004100ULL, 0x0000007fff7f723eULL, 0x000fc400020006ffULL,
0x000000ff5f5f7812ULL, 0x000fe400078ec0ffULL, 0x000000ff62627812ULL, 0x000fe200078ec0ffULL,
0x2000007fff7f7230ULL, 0x000fe20000004100ULL, 0x0000105443417816ULL, 0x000fe40000000042ULL,
0x00000018ff687819ULL, 0x100fe4000001164bULL, 0x0000006cff6c723eULL, 0x000fe400020006ffULL,
0x00000081ff81723eULL, 0x000fe200020006ffULL, 0x000000403c40723cULL, 0x000be20000041838ULL,
0x00000010ff6b7819ULL, 0x000fc4000001164bULL, 0x00000061ff45723eULL, 0x000fe400020006ffULL,
0x00000064ff64723eULL, 0x000fe400020006ffULL, 0x0000005fff5f723eULL, 0x000fe200020006ffULL,
0x20000045ff457230ULL, 0x000fe20000004100ULL, 0x00000062ff62723eULL, 0x000fe200020006ffULL,
0x20000064ff467230ULL, 0x000fe20000004100ULL, 0x00000068ff4b723eULL, 0x000fe200020006ffULL,
0x2000006cff687230ULL, 0x000fe20000004100ULL, 0x00000010ff877819ULL, 0x000fe20000011687ULL,
0x2000005fff7d7230ULL, 0x000fe20000004100ULL, 0x00000010ff887819ULL, 0x000fe20000011688ULL,
0x20000062ff7e7230ULL, 0x000fe20000004100ULL, 0x00000010ff847819ULL, 0x000fe20000011684ULL,
0x2000004bff4b7230ULL, 0x000fe20000004100ULL, 0x00000010ff857819ULL, 0x000fc40000011685ULL,
0x0000008bff6c723eULL, 0x000fe200020006ffULL, 0x20000081ff8b7230ULL, 0x000fe20000004100ULL,
0x00000008ff757819ULL, 0x000fe40000011675ULL, 0x00000010ff767819ULL, 0x000fe20000011676ULL,
0x2000006cff6c7230ULL, 0x000fe20000004100ULL, 0x00000010ff7a7819ULL, 0x000fe4000001167aULL,
0x00000010ff837819ULL, 0x000fe40000011683ULL, 0x00000010ff397819ULL, 0x020fc40000011686ULL,
0x0000105487847816ULL, 0x000fe40000000084ULL, 0x0000105488857816ULL, 0x000fe40000000085ULL,
0x000000ff47477812ULL, 0x000fe400078ec0ffULL, 0x00000010ff817819ULL, 0x000fe4000001168aULL,
0x00000010ff7f7819ULL, 0x000fe2000001167fULL, 0x000000843c34723cULL, 0x000be20000041834ULL,
0x00000075ff75723eULL, 0x000fc400020006ffULL, 0x0000105476387816ULL, 0x000fe40000000083ULL,
0x000010547a397816ULL, 0x000fe40000000039ULL, 0x00000047ff47723eULL, 0x000fe200020006ffULL,
0x20000075ff847230ULL, 0x020fe20000004100ULL, 0x000010547f817816ULL, 0x000fe40000000081ULL,
0x000000ff44447812ULL, 0x000fe200078ec0ffULL, 0x20000047ff857230ULL, 0x000fe20000004100ULL,
0x00000010ff457819ULL, 0x000fc40000011645ULL, 0x00000010ff467819ULL, 0x000fe40000011646ULL,
0x00000010ff7d7819ULL, 0x000fe4000001167dULL, 0x00000010ff7f7819ULL, 0x000fe4000001167eULL,
0x0000a000033a7811ULL, 0x000fe400078e20ffULL, 0x000000ff80807812ULL, 0x000fe400078ec0ffULL,
0x00000044ff75723eULL, 0x000fc400020006ffULL, 0x000010547d7e7816ULL, 0x000fe40000000045ULL,
0x000010547f7f7816ULL, 0x000fe20000000046ULL, 0x20000075ff767230ULL, 0x000fe20000004100ULL,
0x000000383c44723cULL, 0x040be2000004182cULL, 0x00000089ff89723eULL, 0x000fe200020006ffULL,
0x000000003a38783bULL, 0x020e620000000200ULL, 0x00000080ff80723eULL, 0x000fe400020006ffULL,
0x00000060ff60723eULL, 0x000fe200020006ffULL, 0x20000089ff897230ULL, 0x000fe20000004100ULL,
0x00000063ff63723eULL, 0x000fe200020006ffULL, 0x20000080ff807230ULL, 0x000fe20000004100ULL,
0x000000ff65657812ULL, 0x000fe200078ec0ffULL, 0x20000060ff697230ULL, 0x000fe20000004100ULL,
0x000000ff6b6b7812ULL, 0x000fe200078ec0ffULL, 0x20000063ff6a7230ULL, 0x000fe20000004100ULL,
0x00000010ff897819ULL, 0x000fe20000011689ULL, 0x0000007e3c04723cULL, 0x000fe20000041804ULL,
0x00000010ff807819ULL, 0x000fc40000011680ULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x00000065ff65723eULL, 0x000fe400020006ffULL, 0x0000006bff6b723eULL, 0x000fe200020006ffULL,
0x20000067ff677230ULL, 0x000fe20000004100ULL, 0x00000010ff697819ULL, 0x000fe20000011669ULL,
0x20000065ff797230ULL, 0x000fe20000004100ULL, 0x00000010ff6a7819ULL, 0x000fe2000001166aULL,
0x2000006bff787230ULL, 0x000fe20000004100ULL, 0x00000010ff7b7819ULL, 0x000fc4000001167bULL,
0x00000010ff2d7819ULL, 0x000fe4000001167cULL, 0x00000066ff64723eULL, 0x000fe400020006ffULL,
0x0000105480807816ULL, 0x000fe40000000089ULL, 0x00001054692c7816ULL, 0x000fe2000000007bULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x000010546a2d7816ULL, 0x000fe4000000002dULL,
0x0000006eff6e723eULL, 0x000fe200020006ffULL, 0x000000803c30723cULL, 0x040f620000041830ULL,
0x0000006dff6d723eULL, 0x000fe200020006ffULL, 0x000000193838a231ULL, 0x082fe200003400ffULL,
0x00000008ff827819ULL, 0x000fe20000011682ULL, 0x2000006eff717230ULL, 0x000fe20000004100ULL,
0x0000006fff72723eULL, 0x000fe200020006ffULL, 0x2000006dff6f7230ULL, 0x000fe20000004100ULL,
0x000000ff73737812ULL, 0x000fe200078ec0ffULL, 0x0000002c3c0c723cULL, 0x000b62000004180cULL,
0x00000010ff677819ULL, 0x000fe20000011667ULL, 0x20000072ff727230ULL, 0x000fe20000004100ULL,
0x00000010ff2f7819ULL, 0x000fe20000011668ULL, 0x000000193a3aa231ULL, 0x000fe200003400ffULL,
0x00000010ff797819ULL, 0x000fe20000011679ULL, 0x000000183939a231ULL, 0x080fe200003400ffULL,
0x00000010ff787819ULL, 0x000fe20000011678ULL, 0x000000183b3ba231ULL, 0x000fe200003400ffULL,
0x00000008ff4a7819ULL, 0x000fc4000001164aULL, 0x0000008cff6d723eULL, 0x000fe400020006ffULL,
0x0000008eff6e723eULL, 0x000fe400020006ffULL, 0x00000010ff647819ULL, 0x000fe20000011664ULL,
0x2000006dff6d7230ULL, 0x000fe20000004100ULL, 0x00000010ff747819ULL, 0x000fe20000011674ULL,
0x2000006eff6e7230ULL, 0x000fe20000004100ULL, 0x00000010ff2c7819ULL, 0x020fe4000001164bULL,
0x00000010ff757819ULL, 0x000fc40000011677ULL, 0x00000070ff70723eULL, 0x000fe400020006ffULL,
0x00000082ff82723eULL, 0x000fe400020006ffULL, 0x000000ff48487812ULL, 0x000fe200078ec0ffULL,
0x20000070ff707230ULL, 0x000fe20000004100ULL, 0x00000073ff73723eULL, 0x000fe200020006ffULL,
0x20000082ff827230ULL, 0x000fe20000004100ULL, 0x00001054792e7816ULL, 0x000fe40000000067ULL,
0x00001054782f7816ULL, 0x000fe2000000002fULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x0000004aff4a723eULL, 0x000fc400020006ffULL, 0x00000008ff497819ULL, 0x000fe40000011649ULL,
0x0000105464747816ULL, 0x000fe20000000074ULL, 0x2000004aff687230ULL, 0x000fe20000004100ULL,
0x000010542c757816ULL, 0x000fe40000000075ULL, 0x00000048ff2d723eULL, 0x000fe400020006ffULL,
0x000000ff5d5d7812ULL, 0x000fe400078ec0ffULL, 0x00000049ff69723eULL, 0x000fc400020006ffULL,
0x00000008ff5c7819ULL, 0x000fe2000001165cULL, 0x0000002e3c48723cULL, 0x040b620000041808ULL,
0x00000008ff5b7819ULL, 0x000fe2000001165bULL, 0x20000069ff697230ULL, 0x000fe20000004100ULL,
0x000000ff5a5a7812ULL, 0x000fe400078ec0ffULL, 0x000000ff58587812ULL, 0x000fe400078ec0ffULL,
0x2000002dff0a7230ULL, 0x020fe20000004100ULL, 0x00000010ff6d7819ULL, 0x000fe2000001166dULL,
0x000000743c3c723cULL, 0x000b620000041810ULL, 0x00000010ff097819ULL, 0x000fc4000001166eULL,
0x00000010ff857819ULL, 0x000fe40000011685ULL, 0x00000010ff767819ULL, 0x000fe40000011676ULL,
0x00000008ff597819ULL, 0x000fe40000011659ULL, 0x00000008ff577819ULL, 0x000fe40000011657ULL,
0x00000090ff65723eULL, 0x000fe400020006ffULL, 0x00000092ff66723eULL, 0x000fc400020006ffULL,
0x0000005dff5d723eULL, 0x000fe200020006ffULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x00000010ff6f7819ULL, 0x000fe2000001166fULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x00000010ff707819ULL, 0x000fe20000011670ULL, 0x2000005dff5d7230ULL, 0x000fe20000004100ULL,
0x00000010ff827819ULL, 0x000fe40000011682ULL, 0x00000010ff2d7819ULL, 0x000fe40000011684ULL,
0x0000008fff62723eULL, 0x000fc400020006ffULL, 0x00000091ff63723eULL, 0x000fe400020006ffULL,
0x0000005cff5c723eULL, 0x000fe200020006ffULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x00000010ff717819ULL, 0x000fe20000011671ULL, 0x20000063ff637230ULL, 0x000fe20000004100ULL,
0x00000010ff117819ULL, 0x020fe20000011672ULL, 0x2000005cff5c7230ULL, 0x000fe20000004100ULL,
0x00000010ff737819ULL, 0x000fe40000011673ULL, 0x00000010ff8b7819ULL, 0x000fc4000001168bULL,
0x0000005bff5b723eULL, 0x000fe400020006ffULL, 0x0000008dff6b723eULL, 0x000fe400020006ffULL,
0x00000094ff61723eULL, 0x000fe200020006ffULL, 0x2000005bff5b7230ULL, 0x000fe20000004100ULL,
0x00000096ff60723eULL, 0x000fe200020006ffULL, 0x2000006bff6b7230ULL, 0x000fe20000004100ULL,
0x0000005aff5a723eULL, 0x000fe200020006ffULL, 0x20000061ff617230ULL, 0x000fe20000004100ULL,
0x00000058ff58723eULL, 0x000fe200020006ffULL, 0x20000060ff607230ULL, 0x000fe20000004100ULL,
0x00000093ff5f723eULL, 0x000fe200020006ffULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x00000095ff5e723eULL, 0x000fe200020006ffULL, 0x20000058ff587230ULL, 0x000fe20000004100ULL,
0x0000105485087816ULL, 0x000fe2000000006dULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x0000105476097816ULL, 0x000fe20000000009ULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x00000059ff59723eULL, 0x000fc400020006ffULL, 0x00000057ff57723eULL, 0x000fe400020006ffULL,
0x000010546f2c7816ULL, 0x000fe20000000082ULL, 0x20000059ff597230ULL, 0x000fe20000004100ULL,
0x00001054702d7816ULL, 0x000fe2000000002dULL, 0x20000057ff577230ULL, 0x000fe20000004100ULL,
0x0000105473107816ULL, 0x000fe20000000071ULL, 0x000000083830723cULL, 0x000b620000041830ULL,
0x000010548b117816ULL, 0x000fe40000000011ULL, 0x00000010ff657819ULL, 0x000fc40000011665ULL,
0x00000010ff0b7819ULL, 0x000fe40000011666ULL, 0x00000010ff0a7819ULL, 0x000fe2000001160aULL,
0x0000002c382c723cULL, 0x040b620000041834ULL, 0x00000010ff5d7819ULL, 0x000fe4000001165dULL,
0x00000010ff627819ULL, 0x000fe40000011662ULL, 0x00000010ff5c7819ULL, 0x000fe4000001165cULL,
0x00000010ff637819ULL, 0x000fe20000011663ULL, 0x000000103810723cULL, 0x000b640000041840ULL,
0x00000010ff097819ULL, 0x020fc4000001165bULL, 0x00000010ff6c7819ULL, 0x000fe4000001166cULL,
0x00000010ff6b7819ULL, 0x000fe4000001166bULL, 0x00000010ff687819ULL, 0x000fe40000011668ULL,
0x00000010ff357819ULL, 0x000fe40000011669ULL, 0x00000010ff617819ULL, 0x000fe40000011661ULL,
0x00000010ff5a7819ULL, 0x000fc4000001165aULL, 0x00000010ff5b7819ULL, 0x000fe40000011660ULL,
0x00000010ff587819ULL, 0x000fe40000011658ULL, 0x00000010ff5f7819ULL, 0x000fe4000001165fULL,
0x00000010ff597819ULL, 0x000fe40000011659ULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x00000010ff417819ULL, 0x000fc40000011657ULL, 0x000010540a0a7816ULL, 0x000fe40000000065ULL,
0x000010545d0b7816ULL, 0x000fe4000000000bULL, 0x0000105462087816ULL, 0x000fe4000000005cULL,
0x0000105463097816ULL, 0x000fe40000000009ULL, 0x000010546c347816ULL, 0x000fe20000000068ULL,
0x0000000a3804723cULL, 0x000b620000041804ULL, 0x000010546b357816ULL, 0x000fc40000000035ULL,
0x000010545a5a7816ULL, 0x000fe40000000061ULL, 0x00001054585b7816ULL, 0x000fe4000000005bULL,
0x000010545f407816ULL, 0x000fe20000000059ULL, 0x000000083808723cULL, 0x000b62000004180cULL,
0x000010545e417816ULL, 0x000fce0000000041ULL, 0x000000343834723cULL, 0x040b700000041844ULL,
0x0000005a380c723cULL, 0x040b700000041848ULL, 0x000000403838723cULL, 0x000b62000004183cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff407f8cULL, 0x020e62000c80043fULL,
0x000000ffff437224ULL, 0x000fce00078e00ffULL, 0x00000000003c7805ULL, 0x000fc40000015200ULL,
0x0106bc00ff3e7984ULL, 0x000ea40000000800ULL, 0x800000003eff7812ULL, 0x006fc40007804841ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104300780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003e7805ULL, 0x000fcc0000015200ULL,
0x0000003e3c427210ULL, 0x000fca0007f1e1ffULL, 0x000000013f3f7824ULL, 0x000fe200000e0e3dULL,
0x003d09004200780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404200780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3e7819ULL, 0x000fc8000001143fULL, 0x000000423e3e7211ULL, 0x000fca00078110ffULL,
0x000000ffff3f7224ULL, 0x000fca00000e063fULL, 0x000000023e3e7819ULL, 0x000fc8000000123fULL,
0x0000003e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000143437810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106bc00ff3e7984ULL, 0x000e640000000800ULL, 0x800000003eff7812ULL, 0x002fe40007804841ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000580024587a24ULL, 0x010fe200078e02ffULL,
0x00000040213c7811ULL, 0x000fc600078e40ffULL, 0x0000004058587824ULL, 0x000fe200078e00ffULL,
0x0000044000009947ULL, 0x000fea0003800000ULL, 0x00000001253e7824ULL, 0x000fe200078e0217ULL,
0x0000000217407810ULL, 0x040fe40007ffe0ffULL, 0x0000003c283d7217ULL, 0x000fe20007800000ULL,
0x000000013e3f7824ULL, 0x040fe200078e022aULL, 0x00000004174a7810ULL, 0x000fe20007ffe0ffULL,
0x000000103e487824ULL, 0x000fe200078e00ffULL, 0x000000f01f477812ULL, 0x000fe200078ec0ffULL,
0x0000000125417824ULL, 0x000fe400078e0240ULL, 0x0000004029467824ULL, 0x000fe200078e023eULL,
0xfffffff048487812ULL, 0x000fe200078ee23fULL, 0x000000013d3d7824ULL, 0x000fc400078e0a3cULL,
0x00000001413f7824ULL, 0x040fe200078e022aULL, 0x0000005846437210ULL, 0x0c0fe20007f1e0ffULL,
0x0000001041497824ULL, 0x000fe200078e00ffULL, 0x0000003d253d7217ULL, 0x040fe20007800000ULL,
0x00000001253e7824ULL, 0x000fe200078e024aULL, 0x0000000246457810ULL, 0x000fe40007ffe0ffULL,
0xfffffff049497812ULL, 0x000fe200078ee23fULL, 0x000000013e417824ULL, 0x040fe200078e022aULL,
0x0000005845457210ULL, 0x080fe20007f7e0ffULL, 0x000000103e4b7824ULL, 0x000fe200078e00ffULL,
0x0000000446447810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff3f7224ULL, 0x000fe200000e06ffULL,
0x00005e00433e7a11ULL, 0x000fe200078040ffULL, 0x000000013d3d7824ULL, 0x000fe200078e0a25ULL,
0x0000005844447210ULL, 0x000fc40007fde0ffULL, 0x00005f0043437a11ULL, 0x000fe200000f443fULL,
0x000000ffff3f7224ULL, 0x000fe200018e06ffULL, 0x00005e0045427a11ULL, 0x000fe400078a40ffULL,
0x0000003d1700720cULL, 0x000fe40003f86070ULL, 0x000000473e3e7210ULL, 0x000fe40007f7e0ffULL,
0xfffffff04b4b7812ULL, 0x000fe200078ee241ULL, 0x000000ffff417224ULL, 0x000fe200030e06ffULL,
0x0000003d4000720cULL, 0x000fc40003f06070ULL, 0x00005f0045457a11ULL, 0x000fe200028f443fULL,
0x000000ffff3f7224ULL, 0x000fe200018e0643ULL, 0x00005e0044407a11ULL, 0x000fe400078a40ffULL,
0x0000003d4a00720cULL, 0x000fe40003f66070ULL, 0x0000c00048487811ULL, 0x000fe400078e20ffULL,
0x00000006174a7810ULL, 0x000fe40007ffe0ffULL, 0x00005f0044447a11ULL, 0x000fe200028f4441ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e487faeULL, 0x0003e2000e101c46ULL,
0x0000000646417810ULL, 0x000fe20007ffe0ffULL, 0x0000000125437824ULL, 0x000fe200078e024aULL,
0x0000004740407210ULL, 0x000fc40007fde0ffULL, 0x0000005841417210ULL, 0x000fe20007f9e0ffULL,
0x0000000143467824ULL, 0x000fe200078e022aULL, 0x0000c00049497811ULL, 0x000fe400078e20ffULL,
0x0000c0004b4b7811ULL, 0x000fe400078e20ffULL, 0x00000047423e7210ULL, 0x002fe20007fbe0ffULL,
0x0000001043487824ULL, 0x000fe400078e00ffULL, 0x000000ffff437224ULL, 0x000fe200020e06ffULL,
0x00005e0041427a11ULL, 0x000fe200078840ffULL, 0x000000ffff3f7224ULL, 0x000fe200028e0645ULL,
0x0000003d4a00720cULL, 0x000fc40003fa6070ULL, 0x00005f00413d7a11ULL, 0x000fe200020f4443ULL,
0x000000ffff417224ULL, 0x000fe200030e0644ULL, 0x0000004742427210ULL, 0x000fe20007f9e0ffULL,
0x000000003e497faeULL, 0x0003e2000c101c46ULL, 0xfffffff048467812ULL, 0x000fc600078ee246ULL,
0x000000ffff437224ULL, 0x000fe200020e063dULL, 0x0000c00046467811ULL, 0x000fe200078e20ffULL,
0x00000000404b7faeULL, 0x0003e8000d901c46ULL, 0x0000000042467faeULL, 0x0003e2000e901c46ULL,
0x0000038000007947ULL, 0x000fea0003800000ULL, 0x0000000125407824ULL, 0x000fe200078e0217ULL,
0x000000f01f457812ULL, 0x000fc600078ec0ffULL, 0x00000001403f7824ULL, 0x040fe200078e022aULL,
0x00000002403d7810ULL, 0x040fe20007ffe0ffULL, 0x0000001040477824ULL, 0x040fe400078e00ffULL,
0x0000004029417824ULL, 0x000fe400078e0240ULL, 0x000000013d3e7824ULL, 0x000fe200078e022aULL,
0xfffffff047477812ULL, 0x000fe200078ee23fULL, 0x000000103d3d7824ULL, 0x000fe200078e00ffULL,
0x00000004403f7810ULL, 0x040fe40007ffe0ffULL, 0x0000000640407810ULL, 0x000fc40007ffe0ffULL,
0x0000005841427210ULL, 0x000fe20007f1e0ffULL, 0x000000103f437824ULL, 0x000fe200078e00ffULL,
0xfffffff03d3d7812ULL, 0x000fe200078ee23eULL, 0x000000013f3e7824ULL, 0x100fe200078e022aULL,
0x0000c00047477811ULL, 0x000fe200078e20ffULL, 0x00000001403f7824ULL, 0x040fe200078e022aULL,
0x0000c0003d3d7811ULL, 0x000fe200078e20ffULL, 0x0000001040467824ULL, 0x000fe200078e00ffULL,
0xfffffff043437812ULL, 0x000fe200078ee23eULL, 0x000000ffff407224ULL, 0x000fe200000e06ffULL,
0x00005e0042447a11ULL, 0x000fc400078040ffULL, 0x00000002413e7810ULL, 0x040fe40007ffe0ffULL,
0x00005f0042407a11ULL, 0x000fe400000f4440ULL, 0x0000000441427810ULL, 0x040fe40007ffe0ffULL,
0xfffffff046467812ULL, 0x000fe400078ee23fULL, 0x0000000641417810ULL, 0x000fe40007ffe0ffULL,
0x000000583e3f7210ULL, 0x000fc40007f1e0ffULL, 0x0000005842487210ULL, 0x080fe40007f7e0ffULL,
0x00000058414b7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff417224ULL, 0x000fe200000e06ffULL,
0x00005e003f427a11ULL, 0x000fe200078040ffULL, 0x000000ffff497224ULL, 0x000fe200018e06ffULL,
0x00000045443e7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff577224ULL, 0x000fe200028e06ffULL,
0x00005e00484a7a11ULL, 0x000fe400078840ffULL, 0x00005e004b597a11ULL, 0x000fc400078a40ffULL,
0x00005f003f417a11ULL, 0x000fe200000f4441ULL, 0x000000ffff3f7224ULL, 0x000fe200018e0640ULL,
0x0000004542407210ULL, 0x080fe40007f1e0ffULL, 0x00005f0048497a11ULL, 0x000fe400020f4449ULL,
0x000000454a427210ULL, 0x080fe20007f7e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e477faeULL, 0x0003e2000b901c46ULL, 0x00005f004b577a11ULL, 0x000fe200028f4457ULL,
0x000000ffff417224ULL, 0x000fe200000e0641ULL, 0x0000004559447210ULL, 0x000fc40007f9e0ffULL,
0x0000c00046467811ULL, 0x000fe400078e20ffULL, 0x00000000403d7faeULL, 0x0005e2000b901c46ULL,
0x000000ffff457224ULL, 0x000fe200020e0657ULL, 0x0000c000433e7811ULL, 0x002fe200078e20ffULL,
0x000000ffff437224ULL, 0x000fca00018e0649ULL, 0x00000000423e7faeULL, 0x0005e8000b901c46ULL,
0x0000000044467faeULL, 0x0005e4000b901c46ULL, 0x0000000000007918ULL, 0x004fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff3e7f8cULL, 0x002e64000c80043fULL,
0x000000ffff437224ULL, 0x002fc400078e003fULL, 0x00000000003e7805ULL, 0x000fca0000015200ULL,
0x0106b400ff3d7984ULL, 0x000e640000000800ULL, 0x800000003dff7812ULL, 0x002fc4000780484dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff427224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000407805ULL, 0x000fcc0000015200ULL, 0x000000403e407210ULL, 0x000fca0007f1e1ffULL,
0x0000000141417824ULL, 0x000fe200000e0e3fULL, 0x003d09004000780cULL, 0x000fc80003f06070ULL,
0x000000ff4100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404000780cULL, 0x000fc80003f06070ULL, 0x000000ff4100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3d7819ULL, 0x000fc80000011441ULL,
0x000000403d3d7211ULL, 0x000fca00078110ffULL, 0x000000ffff407224ULL, 0x000fca00000e0641ULL,
0x000000023d3d7819ULL, 0x000fc80000001240ULL, 0x0000003d0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000142427810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106b400ff3d7984ULL, 0x000e640000000800ULL,
0x800000003dff7812ULL, 0x002fe4000780484dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000014000007945ULL, 0x000fe20003800000ULL, 0x0000012000002947ULL, 0x000fea0003800000ULL,
0x0000001aff18723eULL, 0x000fe400000010ffULL, 0x00000002ff3e7819ULL, 0x000fe4000001162aULL,
0x00005410183d7816ULL, 0x000fe20000000018ULL, 0x000179f27f007947ULL, 0x000fea000b800000ULL,
0x00001f3e3d197589ULL, 0x0002a400000e0000ULL, 0x000000083e187810ULL, 0x000fe20007ffe0ffULL,
0x00017a227f007947ULL, 0x000fea000b800000ULL, 0x00001f183d187589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000103e477810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff5a7224ULL, 0x000fe200078e003dULL, 0x00004f9000467802ULL, 0x000fc40000000f00ULL,
0x0001877000007944ULL, 0x00efea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000183e477810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff5a7224ULL, 0x004fe200078e003dULL,
0x00004fe000467802ULL, 0x000fc40000000f00ULL, 0x0001872000007944ULL, 0x00afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000152537824ULL, 0x040fe200078e0253ULL,
0x0000e00051427811ULL, 0x000fe200078e20ffULL, 0x0000001052417824ULL, 0x040fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000152567824ULL, 0x000fe200078e0256ULL,
0x00000004503e7810ULL, 0x002fe20007ffe0ffULL, 0x0000001052407824ULL, 0x000fe200078e00ffULL,
0xfffffff041417812ULL, 0x000fe200078ee253ULL, 0x0000000854447824ULL, 0x000fe200078e00ffULL,
0x00000006503f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000854547824ULL, 0x000fe200078e00ffULL,
0xfffffff040407812ULL, 0x000fe200078ee256ULL, 0x000000004250783bULL, 0x000e620000004200ULL,
0x0000e00041417811ULL, 0x000fc400078e20ffULL, 0x0000e00040407811ULL, 0x000fe400078e20ffULL,
0x0000e000553d7811ULL, 0x008fe200078e20ffULL, 0x000000004148783bULL, 0x000ee20000004200ULL,
0xfffffff8443e7812ULL, 0x000fe400078ee23eULL, 0xfffffff8543f7812ULL, 0x000fe200078ee23fULL,
0x00000000405c783bULL, 0x000f280000004200ULL, 0x000000003d44783bULL, 0x000ea20000004200ULL,
0x000000ff504c7812ULL, 0x002fc400078ec0ffULL, 0x0000ffff506a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff51597812ULL, 0x000fe400078ec0ffULL, 0x00000010ff777819ULL, 0x108fe4000001164aULL,
0x000000ff4a8b7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff8c7819ULL, 0x000fe4000001164aULL,
0x0000ffff4a567812ULL, 0x000fc400078ec0ffULL, 0x00000010ff7a7819ULL, 0x100fe40000011649ULL,
0x000000ff498a7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff897819ULL, 0x000fe40000011649ULL,
0x0000ffff49787812ULL, 0x000fe400078ec0ffULL, 0x00000010ff767819ULL, 0x000fe4000001164bULL,
0x000000ff4b4a7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff8e7819ULL, 0x000fe4000001164bULL,
0x0000ffff4b577812ULL, 0x000fe400078ec0ffULL, 0x00000010ff497819ULL, 0x100fe40000011650ULL,
0x00000018ff4b7819ULL, 0x000fe40000011650ULL, 0x00000010ff507819ULL, 0x100fe40000011651ULL,
0x00000018ff4d7819ULL, 0x000fc40000011651ULL, 0x0000ffff516f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff757819ULL, 0x110fe4000001165cULL, 0x000000ff5c607812ULL, 0x040fe400078ec0ffULL,
0x00000018ff797819ULL, 0x000fe4000001165cULL, 0x0000ffff5c907812ULL, 0x000fe400078ec0ffULL,
0x00000010ff7f7819ULL, 0x000fc4000001165eULL, 0x000000ff5e847812ULL, 0x040fe400078ec0ffULL,
0x00000018ff837819ULL, 0x000fe4000001165eULL, 0x0000ffff5e7c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff517819ULL, 0x100fe40000011652ULL, 0x000000ff525b7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff5a7819ULL, 0x004fc40000011652ULL, 0x0000ffff528d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff7e7819ULL, 0x100fe4000001165fULL, 0x000000ff5f867812ULL, 0x040fe400078ec0ffULL,
0x00000018ff857819ULL, 0x000fe4000001165fULL, 0x0000ffff5f7d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff527819ULL, 0x000fc40000011653ULL, 0x000000ff535e7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff5c7819ULL, 0x000fe40000011653ULL, 0x0000ffff538f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff537819ULL, 0x100fe40000011644ULL, 0x000000ff445f7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff647819ULL, 0x000fc40000011644ULL, 0x0000ffff44557812ULL, 0x000fe400078ec0ffULL,
0x00000018ff447819ULL, 0x100fe40000011645ULL, 0x0000005bff5b723eULL, 0x000fe400020006ffULL,
0x00000044ff44723eULL, 0x000fe400020006ffULL, 0x00000010ff547819ULL, 0x000fe20000011645ULL,
0x2000005bff697230ULL, 0x000fe20000004100ULL, 0x000000ff45637812ULL, 0x040fe200078ec0ffULL,
0x20000044ff5b7230ULL, 0x000fe20000004100ULL, 0x0000ffff456b7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff457819ULL, 0x000fe40000011646ULL, 0x0000004dff4d723eULL, 0x000fe400020006ffULL,
0x00000045ff45723eULL, 0x000fe400020006ffULL, 0x00000008ff447819ULL, 0x000fe2000001166aULL,
0x2000004dff6e7230ULL, 0x000fe20000004100ULL, 0x0000005cff5c723eULL, 0x000fe200020006ffULL,
0x20000045ff4d7230ULL, 0x000fe20000004100ULL, 0x00000044ff44723eULL, 0x000fc400020006ffULL,
0x00000008ff457819ULL, 0x000fe2000001166fULL, 0x2000005cff657230ULL, 0x000fe20000004100ULL,
0x000000ff49497812ULL, 0x000fe200078ec0ffULL, 0x20000044ff6f7230ULL, 0x000fe20000004100ULL,
0x00000045ff45723eULL, 0x000fe400020006ffULL, 0x00000008ff447819ULL, 0x000fe4000001168dULL,
0x00000059ff59723eULL, 0x000fe200020006ffULL, 0x20000045ff707230ULL, 0x000fe20000004100ULL,
0x00000044ff44723eULL, 0x000fc400020006ffULL, 0x00000008ff457819ULL, 0x000fe2000001168fULL,
0x20000059ff717230ULL, 0x000fe20000004100ULL, 0x00000064ff5c723eULL, 0x000fe200020006ffULL,
0x20000044ff647230ULL, 0x000fe20000004100ULL, 0x00000049ff49723eULL, 0x000fe400020006ffULL,
0x000000ff46667812ULL, 0x000fe200078ec0ffULL, 0x2000005cff5c7230ULL, 0x000fe20000004100ULL,
0x00000045ff45723eULL, 0x000fe200020006ffULL, 0x20000049ff747230ULL, 0x000fe20000004100ULL,
0x00000060ff44723eULL, 0x000fc400020006ffULL, 0x00000010ff6c7819ULL, 0x000fe40000011646ULL,
0x0000ffff46627812ULL, 0x000fe200078ec0ffULL, 0x20000044ff497230ULL, 0x000fe20000004100ULL,
0x00000018ff467819ULL, 0x000fe40000011647ULL, 0x00000066ff59723eULL, 0x000fe200020006ffULL,
0x20000045ff667230ULL, 0x000fe20000004100ULL, 0x0000004cff4c723eULL, 0x000fe400020006ffULL,
0x00000046ff46723eULL, 0x000fe200020006ffULL, 0x20000059ff597230ULL, 0x000fe20000004100ULL,
0x0000008bff45723eULL, 0x000fe200020006ffULL, 0x2000004cff727230ULL, 0x000fe20000004100ULL,
0x0000a0003e447811ULL, 0x000fe200078e20ffULL, 0x20000046ff4c7230ULL, 0x000fe20000004100ULL,
0x00000010ff807819ULL, 0x000fe2000001165dULL, 0x20000045ff8d7230ULL, 0x000fe20000004100ULL,
0x000000ff5d827812ULL, 0x000fc400078ec0ffULL, 0x00000018ff817819ULL, 0x000fe4000001165dULL,
0x0000ffff5d917812ULL, 0x000fe400078ec0ffULL, 0x00000010ff617819ULL, 0x000fe40000011647ULL,
0x000000ff47687812ULL, 0x040fe400078ec0ffULL, 0x0000ffff475d7812ULL, 0x000fe400078ec0ffULL,
0x000000004444783bULL, 0x000e620000000200ULL, 0x0000004aff4a723eULL, 0x000fc400020006ffULL,
0x0000004bff4b723eULL, 0x000fe400020006ffULL, 0x000000ff80807812ULL, 0x000fe200078ec0ffULL,
0x2000004aff8f7230ULL, 0x000fe20000004100ULL, 0x000000ff754a7812ULL, 0x000fe200078ec0ffULL,
0x2000004bff6d7230ULL, 0x000fe20000004100ULL, 0x000000ff53537812ULL, 0x000fe400078ec0ffULL,
0x000000ff51517812ULL, 0x000fe400078ec0ffULL, 0x00000082ff82723eULL, 0x000fc400020006ffULL,
0x0000004aff4a723eULL, 0x000fe400020006ffULL, 0x00000080ff80723eULL, 0x000fe200020006ffULL,
0x20000082ff827230ULL, 0x000fe20000004100ULL, 0x000000ff50507812ULL, 0x000fe200078ec0ffULL,
0x2000004aff4a7230ULL, 0x000fe20000004100ULL, 0x00000053ff53723eULL, 0x000fe200020006ffULL,
0x20000080ff807230ULL, 0x000fe20000004100ULL, 0x00000008ff4b7819ULL, 0x000fe40000011690ULL,
0x00000010ff7b7819ULL, 0x000fe20000011648ULL, 0x20000053ff607230ULL, 0x000fe20000004100ULL,
0x000000ff48887812ULL, 0x000fc400078ec0ffULL, 0x00000018ff877819ULL, 0x000fe40000011648ULL,
0x0000ffff48487812ULL, 0x000fe400078ec0ffULL, 0x00000051ff51723eULL, 0x000fe400020006ffULL,
0x00000050ff50723eULL, 0x000fe400020006ffULL, 0x00000079ff79723eULL, 0x000fe200020006ffULL,
0x20000051ff6a7230ULL, 0x000fe20000004100ULL, 0x0000004bff4b723eULL, 0x000fe200020006ffULL,
0x20000050ff737230ULL, 0x000fe20000004100ULL, 0x00000008ff537819ULL, 0x000fe20000011648ULL,
0x20000079ff507230ULL, 0x000fe20000004100ULL, 0x00000010ff487819ULL, 0x000fe20000011649ULL,
0x2000004bff4b7230ULL, 0x000fe20000004100ULL, 0x00000008ff517819ULL, 0x000fe20000011691ULL,
0x000000194444a231ULL, 0x082fe200003400ffULL, 0x00000010ff497819ULL, 0x000fe20000011682ULL,
0x000000194646a231ULL, 0x000fe200003400ffULL, 0x00000010ff4a7819ULL, 0x000fe2000001164aULL,
0x000000184545a231ULL, 0x080fe200003400ffULL, 0x00000010ff807819ULL, 0x000fe20000011680ULL,
0x000000184747a231ULL, 0x000fe200003400ffULL, 0x00000081ff81723eULL, 0x000fc400020006ffULL,
0x00000051ff51723eULL, 0x000fe400020006ffULL, 0x00000053ff53723eULL, 0x000fe200020006ffULL,
0x20000081ff817230ULL, 0x000fe20000004100ULL, 0x000010544a487816ULL, 0x000fe20000000048ULL,
0x20000051ff517230ULL, 0x000fe20000004100ULL, 0x0000105480497816ULL, 0x000fe40000000049ULL,
0x00000008ff4a7819ULL, 0x000fe20000011678ULL, 0x20000053ff787230ULL, 0x000fe20000004100ULL,
0x00000010ff507819ULL, 0x000fc40000011650ULL, 0x00000010ff4b7819ULL, 0x000fe4000001164bULL,
0x00000008ff7c7819ULL, 0x000fe4000001167cULL, 0x0000004aff53723eULL, 0x000fe400020006ffULL,
0x0000105450507816ULL, 0x000fe4000000004bULL, 0x000000484448723cULL, 0x000be20000041810ULL,
0x00000083ff83723eULL, 0x000fe400020006ffULL, 0x0000007cff7c723eULL, 0x000fc400020006ffULL,
0x00000010ff817819ULL, 0x000fe20000011681ULL, 0x20000083ff837230ULL, 0x000fe20000004100ULL,
0x000000ff77107812ULL, 0x020fe200078ec0ffULL, 0x2000007cff7c7230ULL, 0x000fe20000004100ULL,
0x00000010ff517819ULL, 0x000fe20000011651ULL, 0x20000053ff777230ULL, 0x000fe20000004100ULL,
0x0000005eff5e723eULL, 0x000fe400020006ffULL, 0x000000ff52527812ULL, 0x000fe400078ec0ffULL,
0x00000010ff10723eULL, 0x000fe200020006ffULL, 0x2000005eff677230ULL, 0x000fe20000004100ULL,
0x00000008ff7d7819ULL, 0x000fc4000001167dULL, 0x0000005aff5a723eULL, 0x000fe400020006ffULL,
0x0000105481517816ULL, 0x000fe40000000051ULL, 0x000000ff76117812ULL, 0x000fe200078ec0ffULL,
0x20000010ff767230ULL, 0x000fe20000004100ULL, 0x00000052ff52723eULL, 0x000fe400020006ffULL,
0x00000085ff85723eULL, 0x000fe200020006ffULL, 0x00000050442c723cULL, 0x000b62000004182cULL,
0x0000007dff7d723eULL, 0x000fc400020006ffULL, 0x00000063ff5e723eULL, 0x000fe200020006ffULL,
0x2000005aff637230ULL, 0x000fe20000004100ULL, 0x00000010ff837819ULL, 0x000fe20000011683ULL,
0x2000007dff7d7230ULL, 0x000fe20000004100ULL, 0x00000010ff7c7819ULL, 0x000fe2000001167cULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x00000011ff11723eULL, 0x000fe400020006ffULL,
0x0000a0003f107811ULL, 0x000fe400078e20ffULL, 0x00000068ff5a723eULL, 0x000fe200020006ffULL,
0x20000052ff687230ULL, 0x000fe20000004100ULL, 0x0000105483507816ULL, 0x020fe2000000007cULL,
0x20000085ff527230ULL, 0x000fe20000004100ULL, 0x00000010ff517819ULL, 0x000fe2000001167dULL,
0x20000011ff7c7230ULL, 0x000fe20000004100ULL, 0x00000087ff87723eULL, 0x000fe200020006ffULL,
0x000000001010783bULL, 0x000e620000000200ULL, 0x00000010ff527819ULL, 0x000fe20000011652ULL,
0x2000005aff5a7230ULL, 0x000fe20000004100ULL, 0x00000089ff89723eULL, 0x000fe200020006ffULL,
0x20000087ff877230ULL, 0x000fe20000004100ULL, 0x0000105452517816ULL, 0x000fc40000000051ULL,
0x000000ff7f7f7812ULL, 0x000fe200078ec0ffULL, 0x20000089ff8b7230ULL, 0x000fe20000004100ULL,
0x000000ff7e7e7812ULL, 0x000fe400078ec0ffULL, 0x000000ff7b7b7812ULL, 0x000fe200078ec0ffULL,
0x000000504450723cULL, 0x000be20000041834ULL, 0x000000ff7a7a7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff567819ULL, 0x000fe40000011656ULL, 0x00000008ff577819ULL, 0x000fc40000011657ULL,
0x00000084ff84723eULL, 0x000fe400020006ffULL, 0x00000086ff86723eULL, 0x000fe400020006ffULL,
0x00000088ff88723eULL, 0x000fe200020006ffULL, 0x20000084ff847230ULL, 0x000fe20000004100ULL,
0x0000008aff8a723eULL, 0x000fe200020006ffULL, 0x20000086ff867230ULL, 0x000fe20000004100ULL,
0x0000007fff7f723eULL, 0x000fe200020006ffULL, 0x20000088ff887230ULL, 0x000fe20000004100ULL,
0x0000007eff7e723eULL, 0x000fe200020006ffULL, 0x2000008aff8a7230ULL, 0x000fe20000004100ULL,
0x0000007bff7b723eULL, 0x000fe200020006ffULL, 0x2000007fff7f7230ULL, 0x000fe20000004100ULL,
0x0000007aff7a723eULL, 0x000fe200020006ffULL, 0x2000007eff7e7230ULL, 0x000fe20000004100ULL,
0x0000008cff8c723eULL, 0x000fe200020006ffULL, 0x2000007bff7b7230ULL, 0x000fe20000004100ULL,
0x0000008eff79723eULL, 0x000fe200020006ffULL, 0x2000007aff7a7230ULL, 0x000fe20000004100ULL,
0x00000056ff56723eULL, 0x000fe200020006ffULL, 0x2000008cff757230ULL, 0x000fe20000004100ULL,
0x00000057ff37723eULL, 0x020fe200020006ffULL, 0x20000079ff797230ULL, 0x000fe20000004100ULL,
0x00000010ff877819ULL, 0x000fe20000011687ULL, 0x20000056ff367230ULL, 0x000fe20000004100ULL,
0x00000010ff8b7819ULL, 0x000fe2000001168bULL, 0x20000037ff377230ULL, 0x000fe20000004100ULL,
0x00000010ff787819ULL, 0x000fe20000011678ULL, 0x000000191010a231ULL, 0x082fe200003400ffULL,
0x00000010ff357819ULL, 0x000fe20000011677ULL, 0x000000191212a231ULL, 0x000fe200003400ffULL,
0x0000105487347816ULL, 0x000fe20000000078ULL, 0x000000181111a231ULL, 0x080fe200003400ffULL,
0x000010548b357816ULL, 0x000fe20000000035ULL, 0x000000181313a231ULL, 0x000fe200003400ffULL,
0x00000010ff8d7819ULL, 0x000fc4000001168dULL, 0x00000010ff577819ULL, 0x000fe4000001168fULL,
0x00000010ff767819ULL, 0x000fe20000011676ULL, 0x000000344408723cULL, 0x000b620000041808ULL,
0x00000010ff7c7819ULL, 0x000fe4000001167cULL, 0x00000010ff847819ULL, 0x000fe40000011684ULL,
0x00000010ff857819ULL, 0x000fe40000011686ULL, 0x00000010ff7f7819ULL, 0x000fc4000001167fULL,
0x00000010ff7e7819ULL, 0x000fe4000001167eULL, 0x00000010ff887819ULL, 0x000fe40000011688ULL,
0x00000010ff897819ULL, 0x000fe4000001168aULL, 0x00000010ff7b7819ULL, 0x000fe4000001167bULL,
0x00000010ff7a7819ULL, 0x000fe4000001167aULL, 0x00000010ff757819ULL, 0x000fc40000011675ULL,
0x00000010ff797819ULL, 0x000fe40000011679ULL, 0x00000010ff367819ULL, 0x000fe40000011636ULL,
0x00000010ff377819ULL, 0x000fe40000011637ULL, 0x000000ff54547812ULL, 0x000fe400078ec0ffULL,
0x0000105476567816ULL, 0x000fe4000000008dULL, 0x000010547c577816ULL, 0x000fc40000000057ULL,
0x000010547f847816ULL, 0x000fe40000000084ULL, 0x000010547e857816ULL, 0x000fe40000000085ULL,
0x000010547b887816ULL, 0x000fe40000000088ULL, 0x000010547a897816ULL, 0x000fe40000000089ULL,
0x00000008ff557819ULL, 0x000fe20000011655ULL, 0x000000844430723cULL, 0x000f620000041830ULL,
0x0000105475367816ULL, 0x000fc40000000036ULL, 0x0000105479377816ULL, 0x000fe40000000037ULL,
0x00000054ff35723eULL, 0x020fe400020006ffULL, 0x00000055ff34723eULL, 0x000fe200020006ffULL,
0x000000884404723cULL, 0x000f620000041804ULL, 0x00000008ff6b7819ULL, 0x000fe4000001166bULL,
0x000000ff6c6c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff61617812ULL, 0x000fc400078ec0ffULL,
0x00000008ff627819ULL, 0x000fe20000011662ULL, 0x000000564454723cULL, 0x040b62000004180cULL,
0x00000008ff5d7819ULL, 0x000fe4000001165dULL, 0x00000010ff6d7819ULL, 0x000fe4000001166dULL,
0x00000010ff6e7819ULL, 0x000fe4000001166eULL, 0x20000035ff0d7230ULL, 0x020fe20000004100ULL,
0x000000364444723cULL, 0x000f620000041838ULL, 0x00000010ff6f7819ULL, 0x000fe2000001166fULL,
0x20000034ff0c7230ULL, 0x000fe20000004100ULL, 0x00000010ff357819ULL, 0x000fc40000011670ULL,
0x0000006bff6b723eULL, 0x000fe400020006ffULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x0000006cff6c723eULL, 0x000fe200020006ffULL, 0x2000006bff0e7230ULL, 0x000fe20000004100ULL,
0x00000061ff61723eULL, 0x000fe200020006ffULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x00000062ff62723eULL, 0x000fe200020006ffULL, 0x2000006cff6c7230ULL, 0x000fe20000004100ULL,
0x0000005dff5d723eULL, 0x000fe200020006ffULL, 0x20000061ff0f7230ULL, 0x000fe20000004100ULL,
0x000010546d347816ULL, 0x000fe2000000006fULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x000010546e357816ULL, 0x000fe20000000035ULL, 0x2000005dff5d7230ULL, 0x000fe20000004100ULL,
0x00000010ff5e7819ULL, 0x000fc4000001165eULL, 0x00000010ff0d7819ULL, 0x000fe4000001160dULL,
0x00000010ff5c7819ULL, 0x000fe2000001165cULL, 0x000000341034723cULL, 0x000b62000004182cULL,
0x000010540d617816ULL, 0x000fe4000000005eULL, 0x00000010ff0c7819ULL, 0x000fe4000001160cULL,
0x00000010ff5b7819ULL, 0x000fe4000001165bULL, 0x00000010ff0d7819ULL, 0x000fc4000001160eULL,
0x00000010ff727819ULL, 0x000fe40000011672ULL, 0x00000010ff717819ULL, 0x000fe40000011671ULL,
0x00000010ff747819ULL, 0x000fe40000011674ULL, 0x00000010ff737819ULL, 0x000fe40000011673ULL,
0x00000010ff697819ULL, 0x000fe40000011669ULL, 0x00000010ff677819ULL, 0x000fc40000011667ULL,
0x00000010ff6a7819ULL, 0x000fe4000001166aULL, 0x00000010ff687819ULL, 0x000fe40000011668ULL,
0x00000010ff637819ULL, 0x000fe40000011663ULL, 0x00000010ff657819ULL, 0x000fe40000011665ULL,
0x00000010ff647819ULL, 0x000fe40000011664ULL, 0x00000010ff2d7819ULL, 0x020fc40000011666ULL,
0x00000010ff5f7819ULL, 0x000fe4000001165fULL, 0x00000010ff607819ULL, 0x000fe40000011660ULL,
0x00000010ff597819ULL, 0x000fe40000011659ULL, 0x00000010ff6c7819ULL, 0x000fe4000001166cULL,
0x00000010ff5a7819ULL, 0x000fe4000001165aULL, 0x00000010ff6d7819ULL, 0x000fc4000001160fULL,
0x00000010ff4d7819ULL, 0x000fe4000001164dULL, 0x00000010ff627819ULL, 0x000fe40000011662ULL,
0x00000010ff4c7819ULL, 0x000fe4000001164cULL, 0x00000010ff5d7819ULL, 0x000fe4000001165dULL,
0x000010545c0c7816ULL, 0x000fe4000000000cULL, 0x000010545b0d7816ULL, 0x000fc4000000000dULL,
0x0000105474727816ULL, 0x000fe40000000072ULL, 0x0000105473737816ULL, 0x000fe40000000071ULL,
0x000010546a6a7816ULL, 0x000fe20000000069ULL, 0x0000000c100c723cULL, 0x000b620000041808ULL,
0x00001054686b7816ULL, 0x000fe40000000067ULL, 0x00001054632c7816ULL, 0x000fe40000000064ULL,
0x00001054652d7816ULL, 0x000fc4000000002dULL, 0x0000105460607816ULL, 0x000fe2000000005fULL,
0x000000721038723cULL, 0x040b620000041848ULL, 0x000010546c6c7816ULL, 0x000fe40000000059ULL,
0x000010546d6d7816ULL, 0x000fe4000000005aULL, 0x000010544d627816ULL, 0x000fe40000000062ULL,
0x000010544c637816ULL, 0x000fe2000000005dULL, 0x0000006a1030723cULL, 0x040b700000041830ULL,
0x0000002c102c723cULL, 0x040b700000041850ULL, 0x000000601004723cULL, 0x040b700000041804ULL,
0x0000006c1008723cULL, 0x040b700000041854ULL, 0x000000621010723cULL, 0x000b620000041844ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff447f8cULL, 0x020e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000283c00720cULL, 0x000fe20003f06070ULL, 0x01068800ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff4a7224ULL, 0x002fe200078e0045ULL, 0x000000014f4f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff447224ULL, 0x000fd200078e004eULL, 0x0000f78000000947ULL, 0x000fea0003800000ULL,
0x0000000000447805ULL, 0x000fc40000015200ULL, 0x0106bc00ff247984ULL, 0x000e640000000800ULL,
0x8000000024ff7812ULL, 0x002fe4000780484aULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff487224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000467805ULL, 0x000fcc0000015200ULL,
0x0000004644467210ULL, 0x000fca0007f1e1ffULL, 0x0000000147477824ULL, 0x000fe200000e0e45ULL,
0x003d09004600780cULL, 0x000fc80003f06070ULL, 0x000000ff4700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404600780cULL, 0x000fc80003f06070ULL,
0x000000ff4700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff247819ULL, 0x000fc80000011447ULL, 0x0000004624247211ULL, 0x000fca00078110ffULL,
0x000000ffff467224ULL, 0x000fca00000e0647ULL, 0x0000000224247819ULL, 0x000fc80000001246ULL,
0x000000240000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000148487810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106bc00ff247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fe4000780484aULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000046000009947ULL, 0x000fea0003800000ULL,
0x000000203c247810ULL, 0x000fe20007ffe0ffULL, 0x0000000125457824ULL, 0x000fe200078e0217ULL,
0x0000000417517810ULL, 0x000fe40007ffe0ffULL, 0x0000002428447217ULL, 0x000fe20007800000ULL,
0x0000000145467824ULL, 0x000fe200078e022aULL, 0x0000000217477810ULL, 0x000fe20007ffe0ffULL,
0x00000010454f7824ULL, 0x000fe200078e00ffULL, 0x0000000617537810ULL, 0x000fe20007ffe0ffULL,
0x0000000144447824ULL, 0x000fe200078e0a24ULL, 0x0000002029247811ULL, 0x000fe200078e30ffULL,
0x0000000125497824ULL, 0x000fe200078e0251ULL, 0xfffffff04f4f7812ULL, 0x000fe200078ee246ULL,
0x0000000125487824ULL, 0x040fe200078e0247ULL, 0x0000004425447217ULL, 0x000fe20007800000ULL,
0x00000001454c7824ULL, 0x000fe200078e0224ULL, 0x000000f01f4d7812ULL, 0x000fe200078ec0ffULL,
0x00000001494a7824ULL, 0x000fe200078e022aULL, 0x0000e0004f4f7811ULL, 0x000fe200078e20ffULL,
0x0000001049527824ULL, 0x000fe200078e00ffULL, 0x000000584c4c7210ULL, 0x000fe20007f1e0ffULL,
0x00000001484b7824ULL, 0x000fc400078e0224ULL, 0x0000000148467824ULL, 0x000fe200078e022aULL,
0xfffffff052527812ULL, 0x000fe200078ee24aULL, 0x0000001048507824ULL, 0x000fe200078e00ffULL,
0x000000584b4b7210ULL, 0x080fe20007f9e0ffULL, 0x0000000125457824ULL, 0x000fe200078e0253ULL,
0x0000e00052527811ULL, 0x000fe200078e20ffULL, 0x0000000149497824ULL, 0x000fe200078e0224ULL,
0xfffffff050507812ULL, 0x000fe200078ee246ULL, 0x0000000145487824ULL, 0x040fe400078e0224ULL,
0x00000001454a7824ULL, 0x000fe200078e022aULL, 0x0000005849497210ULL, 0x080fe20007f7e0ffULL,
0x0000001045547824ULL, 0x000fe200078e00ffULL, 0x0000005848587210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff457224ULL, 0x000fe200000e06ffULL, 0x00005e004c467a11ULL, 0x000fe200078040ffULL,
0x0000000144247824ULL, 0x000fe200078e0a25ULL, 0xfffffff054547812ULL, 0x000fe200078ee24aULL,
0x000000ffff447224ULL, 0x000fe200020e06ffULL, 0x00005f004c4c7a11ULL, 0x000fe200000f4445ULL,
0x000000ffff457224ULL, 0x000fe200018e06ffULL, 0x00005e004b4a7a11ULL, 0x000fc400078c40ffULL,
0x000000244700720cULL, 0x080fe40003f06070ULL, 0x00005e0049477a11ULL, 0x000fe400078a40ffULL,
0x000000241700720cULL, 0x000fe40003f86070ULL, 0x00005f004b4b7a11ULL, 0x000fe400030f4444ULL,
0x0000004d46447210ULL, 0x000fe20007fde0ffULL, 0x000000ffff467224ULL, 0x000fe200010e06ffULL,
0x00005f0049497a11ULL, 0x000fc400028f4445ULL, 0x00005e0058487a11ULL, 0x040fe200078a40ffULL,
0x000000ffff457224ULL, 0x000fe200030e064cULL, 0x000000245100720cULL, 0x080fe40003f66070ULL,
0x000000245300720cULL, 0x000fe40003f46070ULL, 0x00005f0058247a11ULL, 0x000fe200028f4446ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000444f7faeULL, 0x0003e2000e101c46ULL,
0x0000004d4a467210ULL, 0x000fe40007fbe0ffULL, 0x0000e00050507811ULL, 0x000fc400078e20ffULL,
0x0000e00054547811ULL, 0x000fe400078e20ffULL, 0x0000004d47447210ULL, 0x082fe20007f9e0ffULL,
0x000000ffff477224ULL, 0x000fe200028e064bULL, 0x0000004d48487210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff457224ULL, 0x000fe200020e0649ULL, 0x0000000046507faeULL, 0x0003e2000c101c46ULL,
0x000000ffff497224ULL, 0x000fc600028e0624ULL, 0x0000000044527faeULL, 0x0003e8000d901c46ULL,
0x0000000048547faeULL, 0x0003e2000d101c46ULL, 0x0000039000007947ULL, 0x000fea0003800000ULL,
0x0000000125247824ULL, 0x000fe200078e0217ULL, 0x0000002029457811ULL, 0x000fe400078e30ffULL,
0x000000f01f4f7812ULL, 0x000fe200078ec0ffULL, 0x0000000124447824ULL, 0x040fe200078e022aULL,
0x0000000224477810ULL, 0x040fe20007ffe0ffULL, 0x0000001024507824ULL, 0x040fe200078e00ffULL,
0x0000000424487810ULL, 0x000fc40007ffe0ffULL, 0x0000000624497810ULL, 0x000fe20007ffe0ffULL,
0x0000000147467824ULL, 0x040fe200078e022aULL, 0xfffffff050507812ULL, 0x000fe200078ee244ULL,
0x0000001047517824ULL, 0x000fe400078e00ffULL, 0x0000000124447824ULL, 0x000fe200078e0245ULL,
0x0000e00050507811ULL, 0x000fe200078e20ffULL, 0x0000000145247824ULL, 0x000fe200078e0247ULL,
0xfffffff051517812ULL, 0x000fe200078ee246ULL, 0x0000000148477824ULL, 0x000fe200078e022aULL,
0x0000005844467210ULL, 0x000fe20007f7e0ffULL, 0x0000000145447824ULL, 0x040fe200078e0248ULL,
0x00000024584c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000145457824ULL, 0x000fe200078e0249ULL,
0x00005e00464a7a11ULL, 0x000fe200078840ffULL, 0x0000001048527824ULL, 0x000fe200078e00ffULL,
0x0000004458447210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff247224ULL, 0x000fe200018e06ffULL,
0x0000004558457210ULL, 0x000fe20007f7e0ffULL, 0x0000000149487824ULL, 0x040fe200078e022aULL,
0xfffffff052527812ULL, 0x000fe200078ee247ULL, 0x0000001049537824ULL, 0x000fe200078e00ffULL,
0x00005f00464d7a11ULL, 0x000fe200020f4424ULL, 0x000000ffff4b7224ULL, 0x000fe200000e06ffULL,
0x00005e004c247a11ULL, 0x000fe200078040ffULL, 0x000000ffff477224ULL, 0x000fe200010e06ffULL,
0x00005e0044467a11ULL, 0x000fe200078440ffULL, 0x000000ffff497224ULL, 0x000fe200018e06ffULL,
0x0000004f4a4a7210ULL, 0x000fc40007f9e0ffULL, 0xfffffff053537812ULL, 0x000fe400078ee248ULL,
0x00005e0045487a11ULL, 0x040fe400078640ffULL, 0x00005f004c4c7a11ULL, 0x000fe200000f444bULL,
0x000000ffff4b7224ULL, 0x000fe200020e064dULL, 0x00005f0044477a11ULL, 0x000fe400010f4447ULL,
0x0000004f24447210ULL, 0x080fe40007f1e0ffULL, 0x00005f0045497a11ULL, 0x000fe200018f4449ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000004a507faeULL, 0x0003e2000b901c46ULL,
0x0000004f46467210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff457224ULL, 0x000fe200000e064cULL,
0x0000004f48487210ULL, 0x000fc40007f7e0ffULL, 0x0000e00051247811ULL, 0x000fe200078e20ffULL,
0x000000ffff477224ULL, 0x000fe400010e0647ULL, 0x000000ffff497224ULL, 0x000fe400018e0649ULL,
0x0000000044247faeULL, 0x0005e2000b901c46ULL, 0x0000e000524a7811ULL, 0x002fe400078e20ffULL,
0x0000e000534b7811ULL, 0x000fc600078e20ffULL, 0x00000000464a7faeULL, 0x0005e8000b901c46ULL,
0x00000000484b7faeULL, 0x0005e4000b901c46ULL, 0x0000000000007918ULL, 0x004fe20000000000ULL,
0x0000000220247810ULL, 0x000fc80007ffe0ffULL, 0x000000272400720cULL, 0x000fe20003f06070ULL,
0xffffffffff247424ULL, 0x000fd800078e00ffULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x0000000222447810ULL, 0x002fe20007ffe020ULL, 0x00000004ff457424ULL, 0x000fc800078e00ffULL,
0x0000600044447625ULL, 0x000fca00078e0045ULL, 0x0000000644247981ULL, 0x000324000c1e1900ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b000ff587f8cULL, 0x000ea2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106280025487f8cULL, 0x0022e4000c80043fULL,
0x0000000000447805ULL, 0x000fc40000015200ULL, 0x01062c0025467984ULL, 0x000e640000000800ULL,
0x8000000046ff7812ULL, 0x00afe40007804849ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4b7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104b00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000467805ULL, 0x000fcc0000015200ULL,
0x00000046444a7210ULL, 0x000fca0007f1e1ffULL, 0x0000000147477824ULL, 0x000fe200000e0e45ULL,
0x003d09004a00780cULL, 0x000fc80003f06070ULL, 0x000000ff4700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404a00780cULL, 0x000fc80003f06070ULL,
0x000000ff4700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff467819ULL, 0x000fc80000011447ULL, 0x0000004a46467211ULL, 0x000fca00078110ffULL,
0x000000ffff477224ULL, 0x000fca00000e0647ULL, 0x0000000246467819ULL, 0x000fc80000001247ULL,
0x000000460000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000014b4b7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01062c0025467984ULL, 0x000e640000000800ULL, 0x8000000046ff7812ULL, 0x002fe40007804849ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x010080001e457984ULL, 0x000e680000000800ULL,
0x010280001e487984ULL, 0x0006a20000000800ULL, 0x0000004e4500720bULL, 0x002fe20003f1d000ULL,
0x000153827f007947ULL, 0x000fd8000b800000ULL, 0x0000000000497806ULL, 0x008fc800000e0100ULL,
0x0000ffff49ff7812ULL, 0x000fe2000780c0ffULL, 0x000004a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff4a7424ULL, 0x000fc400078e00ffULL, 0x000000ffff447224ULL, 0x000fd200078e004eULL,
0x0000046000008947ULL, 0x000fea0003800000ULL, 0x000000012b00780cULL, 0x000fe40003f05270ULL,
0x0000004e4500720bULL, 0x000fe20003f54000ULL, 0x000153427f007947ULL, 0x000fd8000b800000ULL,
0x0000000000447806ULL, 0x000fc400010e0100ULL, 0x0000004e45468209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe80003800000ULL, 0x010480461e008388ULL, 0x0003e40000000800ULL,
0x0000991044467816ULL, 0x002fc800000000ffULL, 0x000000ff4600720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000004e45467209ULL, 0x000fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff44ff7812ULL, 0x000fc6000780c0ffULL,
0x0000004e46467221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b46467820ULL, 0x000fc80000410000ULL,
0x00000046004a7308ULL, 0x000e640000000800ULL, 0x0000004a23237220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff467819ULL, 0x000fe2000001162aULL,
0x000152827f007947ULL, 0x000fea000b800000ULL, 0x00001f464a467589ULL, 0x0002e400000e0000ULL,
0x0000004638387220ULL, 0x088fe20000410000ULL, 0x0000004639397220ULL, 0x080fe20000410000ULL,
0x0000004634347220ULL, 0x080fe20000410000ULL, 0x0000004635357220ULL, 0x080fe20000410000ULL,
0x0000004630307220ULL, 0x080fe20000410000ULL, 0x0000004631317220ULL, 0x080fe20000410000ULL,
0x000000462c2c7220ULL, 0x080fe20000410000ULL, 0x000000462d2d7220ULL, 0x080fe20000410000ULL,
0x0000004604047220ULL, 0x080fe20000410000ULL, 0x0000004605057220ULL, 0x080fe20000410000ULL,
0x000000460c0c7220ULL, 0x080fe20000410000ULL, 0x000000460d0d7220ULL, 0x080fe20000410000ULL,
0x0000004608087220ULL, 0x080fe20000410000ULL, 0x0000004609097220ULL, 0x080fe20000410000ULL,
0x0000004610107220ULL, 0x080fe20000410000ULL, 0x0000004611117220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0044ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000082a467811ULL, 0x000fe200078ff0ffULL,
0x000151827f007947ULL, 0x000fea000b800000ULL, 0x00001f464a467589ULL, 0x00066400000e0000ULL,
0x000000463a3a7220ULL, 0x082fe20000410000ULL, 0x000000463b3b7220ULL, 0x080fe20000410000ULL,
0x0000004636367220ULL, 0x080fe20000410000ULL, 0x0000004637377220ULL, 0x080fe20000410000ULL,
0x0000004632327220ULL, 0x080fe20000410000ULL, 0x0000004633337220ULL, 0x080fe20000410000ULL,
0x000000462e2e7220ULL, 0x080fe20000410000ULL, 0x000000462f2f7220ULL, 0x080fe20000410000ULL,
0x0000004606067220ULL, 0x080fe20000410000ULL, 0x0000004607077220ULL, 0x080fe20000410000ULL,
0x000000460e0e7220ULL, 0x080fe20000410000ULL, 0x000000460f0f7220ULL, 0x080fe20000410000ULL,
0x000000460a0a7220ULL, 0x080fe20000410000ULL, 0x000000460b0b7220ULL, 0x080fe20000410000ULL,
0x0000004612127220ULL, 0x080fe20000410000ULL, 0x0000004613137220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000ffff44ff7812ULL, 0x000fe20007800849ULL,
0x00000001ff4a7424ULL, 0x00afe200078e00ffULL, 0x0000004e454e7209ULL, 0x000fca0007810000ULL,
0x000000ffff447224ULL, 0x000fcc00078e004eULL, 0x8000004e45450221ULL, 0x100fe20000010000ULL,
0x000000ffff440224ULL, 0x000fe200078e004eULL, 0x00007610ff4a0816ULL, 0x000fe4000000004aULL,
0x3fb8aa3b45450820ULL, 0x000fc80000410000ULL, 0x00000045001a0308ULL, 0x000e640000000800ULL,
0x0000001a48480220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002348237221ULL, 0x004fc20000010000ULL, 0x0000000000467805ULL, 0x000fcc0000015200ULL,
0x0106ac00ff457984ULL, 0x000e640000000800ULL, 0x8000000045ff7812ULL, 0x002fe40007804843ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff4b7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000487805ULL, 0x000fcc0000015200ULL, 0x0000004846487210ULL, 0x000fca0007f1e1ffULL,
0x0000000149497824ULL, 0x000fe200000e0e47ULL, 0x003d09004800780cULL, 0x000fc80003f06070ULL,
0x000000ff4900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404800780cULL, 0x000fc80003f06070ULL, 0x000000ff4900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff457819ULL, 0x000fc80000011449ULL,
0x0000004845457211ULL, 0x000fca00078110ffULL, 0x000000ffff487224ULL, 0x000fca00000e0649ULL,
0x0000000245457819ULL, 0x000fc80000001248ULL, 0x000000450000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000014b4b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106ac00ff457984ULL, 0x000e640000000800ULL,
0x8000000045ff7812ULL, 0x002fe40007804843ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099104a437816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff4300720cULL, 0x000fda0003f45270ULL, 0x0000012000002947ULL, 0x000fea0003800000ULL,
0x0000001aff18723eULL, 0x000fe400000010ffULL, 0x00000002ff457819ULL, 0x000fe4000001162aULL,
0x0000541018437816ULL, 0x000fe20000000018ULL, 0x00014d527f007947ULL, 0x000fea000b800000ULL,
0x00001f4543197589ULL, 0x0002a400000e0000ULL, 0x0000000845187810ULL, 0x000fe20007ffe0ffULL,
0x00014d827f007947ULL, 0x000fea000b800000ULL, 0x00001f1843187589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001045477810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff5a7224ULL, 0x000fe200078e0043ULL, 0x00007e5000467802ULL, 0x000fc40000000f00ULL,
0x000158b000007944ULL, 0x01efea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001845477810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff5a7224ULL, 0x004fe200078e0043ULL,
0x00007ea000467802ULL, 0x000fc40000000f00ULL, 0x0001586000007944ULL, 0x01afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000001654783bULL, 0x000ee80000004200ULL, 0x000000001550783bULL, 0x000ea80000004200ULL,
0x000000000248783bULL, 0x000e680000004200ULL, 0x00000000144c783bULL, 0x000e620000004200ULL,
0x00000010ff7a7819ULL, 0x008fc40000011655ULL, 0x000000ff555d7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff5c7819ULL, 0x000fe40000011655ULL, 0x0000ffff558e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff847819ULL, 0x104fe40000011651ULL, 0x000000ff51647812ULL, 0x000fe400078ec0ffULL,
0x00000018ff637819ULL, 0x000fc40000011651ULL, 0x0000ffff51927812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5e7819ULL, 0x100fe40000011654ULL, 0x000000ff54437812ULL, 0x042fe400078ec0ffULL,
0x00000018ff5a7819ULL, 0x000fe40000011654ULL, 0x0000ffff548d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff517819ULL, 0x000fc40000011648ULL, 0x000000ff48897812ULL, 0x040fe400078ec0ffULL,
0x00000018ff867819ULL, 0x000fe40000011648ULL, 0x0000ffff48557812ULL, 0x000fe400078ec0ffULL,
0x000000ff56607812ULL, 0x000fe400078ec0ffULL, 0x000000ff53687812ULL, 0x000fe400078ec0ffULL,
0x00000010ff547819ULL, 0x000fc40000011649ULL, 0x000000ff498a7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff487819ULL, 0x000fe40000011649ULL, 0x0000ffff49477812ULL, 0x000fe400078ec0ffULL,
0x00000018ff497819ULL, 0x000fe4000001164aULL, 0x0000005aff5a723eULL, 0x000fe400020006ffULL,
0x00000060ff60723eULL, 0x000fc400020006ffULL, 0x00000068ff68723eULL, 0x000fe200020006ffULL,
0x2000005aff747230ULL, 0x000fe20000004100ULL, 0x00000048ff48723eULL, 0x000fe200020006ffULL,
0x20000060ff717230ULL, 0x000fe20000004100ULL, 0x00000049ff49723eULL, 0x000fe200020006ffULL,
0x20000068ff6b7230ULL, 0x000fe20000004100ULL, 0x00000018ff7b7819ULL, 0x000fe2000001164dULL,
0x20000048ff607230ULL, 0x000fe20000004100ULL, 0x00000010ff5b7819ULL, 0x000fe2000001164aULL,
0x20000049ff5a7230ULL, 0x000fe20000004100ULL, 0x000000ff4a8b7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff4a467812ULL, 0x000fe400078ec0ffULL, 0x00000010ff7e7819ULL, 0x100fe40000011656ULL,
0x00000018ff5f7819ULL, 0x000fe40000011656ULL, 0x0000ffff568f7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff4a7819ULL, 0x000fe4000001164bULL, 0x000000ff5e5e7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff7f7819ULL, 0x100fe40000011657ULL, 0x000000ff57617812ULL, 0x040fe400078ec0ffULL,
0x00000018ff567819ULL, 0x000fe40000011657ULL, 0x0000ffff57907812ULL, 0x000fe400078ec0ffULL,
0x000000ff7a7a7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff577819ULL, 0x000fc40000011650ULL,
0x00000018ff677819ULL, 0x000fe40000011653ULL, 0x00000043ff76723eULL, 0x000fe400020006ffULL,
0x0000007bff68723eULL, 0x000fe400020006ffULL, 0x00000018ff697819ULL, 0x000fe2000001164cULL,
0x20000076ff767230ULL, 0x000fe20000004100ULL, 0x00000010ff457819ULL, 0x000fe2000001164bULL,
0x20000068ff687230ULL, 0x000fe20000004100ULL, 0x000000ff4b8c7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff4b437812ULL, 0x000fe400078ec0ffULL, 0x00000008ff497819ULL, 0x000fe4000001168dULL,
0x0000004aff7b723eULL, 0x000fe400020006ffULL, 0x0000005eff48723eULL, 0x000fe400020006ffULL,
0x00000010ff877819ULL, 0x000fe20000011652ULL, 0x2000007bff5e7230ULL, 0x000fe20000004100ULL,
0x000000ff52667812ULL, 0x000fc400078ec0ffULL, 0x00000018ff657819ULL, 0x000fe40000011652ULL,
0x0000ffff52937812ULL, 0x000fe400078ec0ffULL, 0x000000ff4d7d7812ULL, 0x000fe400078ec0ffULL,
0x0000007aff4a723eULL, 0x000fe200020006ffULL, 0x20000048ff7a7230ULL, 0x000fe20000004100ULL,
0x00000008ff4b7819ULL, 0x000fe4000001168eULL, 0x00000057ff52723eULL, 0x000fc400020006ffULL,
0x00000067ff57723eULL, 0x000fe400020006ffULL, 0x00000069ff67723eULL, 0x000fe200020006ffULL,
0x20000052ff527230ULL, 0x000fe20000004100ULL, 0x00000049ff49723eULL, 0x000fe200020006ffULL,
0x20000057ff577230ULL, 0x000fe20000004100ULL, 0x0000007dff69723eULL, 0x000fe200020006ffULL,
0x2000004aff7d7230ULL, 0x000fe20000004100ULL, 0x0000004bff4b723eULL, 0x000fe200020006ffULL,
0x20000049ff7b7230ULL, 0x000fe20000004100ULL, 0x000000ff7e487812ULL, 0x000fe200078ec0ffULL,
0x20000067ff677230ULL, 0x000fe20000004100ULL, 0x000000ff7f7f7812ULL, 0x000fe200078ec0ffULL,
0x2000004bff7e7230ULL, 0x000fe20000004100ULL, 0x00000008ff4a7819ULL, 0x000fe2000001168fULL,
0x20000069ff697230ULL, 0x000fe20000004100ULL, 0x00000056ff56723eULL, 0x000fc400020006ffULL,
0x00000048ff49723eULL, 0x000fe400020006ffULL, 0x000000ff4e817812ULL, 0x000fe200078ec0ffULL,
0x20000056ff6e7230ULL, 0x000fe20000004100ULL, 0x00000018ff807819ULL, 0x000fe4000001164eULL,
0x0000007fff4b723eULL, 0x000fe200020006ffULL, 0x20000049ff7f7230ULL, 0x000fe20000004100ULL,
0x0000004aff4a723eULL, 0x000fe400020006ffULL, 0x0000a80000487811ULL, 0x000fc400078e20ffULL,
0x00000010ff707819ULL, 0x000fe4000001164dULL, 0x0000ffff4d737812ULL, 0x000fe400078ec0ffULL,
0x00000064ff4d723eULL, 0x000fe400020006ffULL, 0x00000065ff56723eULL, 0x000fe400020006ffULL,
0x00000081ff65723eULL, 0x000fe200020006ffULL, 0x2000004bff817230ULL, 0x000fe20000004100ULL,
0x00000080ff64723eULL, 0x000fe200020006ffULL, 0x2000004aff807230ULL, 0x000fe20000004100ULL,
0x00000010ff777819ULL, 0x000fe2000001164cULL, 0x000000004848783bULL, 0x000e620000000200ULL,
0x00000018ff827819ULL, 0x000fe2000001164fULL, 0x2000004dff4d7230ULL, 0x000fe20000004100ULL,
0x00000010ff887819ULL, 0x000fe20000011653ULL, 0x20000056ff567230ULL, 0x000fe20000004100ULL,
0x0000ffff53797812ULL, 0x000fe200078ec0ffULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x00000063ff53723eULL, 0x000fe200020006ffULL, 0x20000064ff647230ULL, 0x000fe20000004100ULL,
0x0000ffff4c787812ULL, 0x000fc400078ec0ffULL, 0x0000005dff5d723eULL, 0x000fe200020006ffULL,
0x20000053ff537230ULL, 0x000fe20000004100ULL, 0x00000061ff61723eULL, 0x000fe400020006ffULL,
0x00000066ff66723eULL, 0x000fe200020006ffULL, 0x2000005dff7c7230ULL, 0x000fe20000004100ULL,
0x00000082ff63723eULL, 0x000fe200020006ffULL, 0x20000061ff727230ULL, 0x000fe20000004100ULL,
0x000000ff77777812ULL, 0x000fe200078ec0ffULL, 0x20000066ff6c7230ULL, 0x000fe20000004100ULL,
0x00000008ff737819ULL, 0x000fe20000011673ULL, 0x20000063ff637230ULL, 0x000fe20000004100ULL,
0x00000008ff827819ULL, 0x000fc40000011690ULL, 0x000000ff50627812ULL, 0x040fe400078ec0ffULL,
0x000000ff4f857812ULL, 0x000fe400078ec0ffULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x00000010ff837819ULL, 0x000fe40000011650ULL, 0x0000ffff50917812ULL, 0x000fe200078ec0ffULL,
0x2000005cff757230ULL, 0x000fe20000004100ULL, 0x000000ff4c6a7812ULL, 0x000fc400078ec0ffULL,
0x00000008ff787819ULL, 0x000fe40000011678ULL, 0x00000077ff77723eULL, 0x000fe200020006ffULL,
0x000000194848a231ULL, 0x082fe200003400ffULL, 0x00000010ff767819ULL, 0x000fe20000011676ULL,
0x000000194a4aa231ULL, 0x000fe200003400ffULL, 0x00000010ff7a7819ULL, 0x000fe2000001167aULL,
0x000000184949a231ULL, 0x080fe200003400ffULL, 0x00000073ff73723eULL, 0x000fe200020006ffULL,
0x000000184b4ba231ULL, 0x000fe200003400ffULL, 0x00000010ff4c7819ULL, 0x000fc4000001164fULL,
0x0000ffff4f507812ULL, 0x000fe400078ec0ffULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x00000082ff82723eULL, 0x000fe400020006ffULL, 0x00000062ff4f723eULL, 0x000fe200020006ffULL,
0x2000005fff6d7230ULL, 0x000fe20000004100ULL, 0x00000085ff66723eULL, 0x000fe200020006ffULL,
0x20000082ff827230ULL, 0x000fe20000004100ULL, 0x00000010ff6f7819ULL, 0x000fe2000001164eULL,
0x2000004fff4f7230ULL, 0x000fe20000004100ULL, 0x0000008aff62723eULL, 0x000fe200020006ffULL,
0x20000066ff667230ULL, 0x000fe20000004100ULL, 0x000000ff83837812ULL, 0x000fc400078ec0ffULL,
0x000000ff84857812ULL, 0x000fe200078ec0ffULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x00000078ff8a723eULL, 0x000fe200020006ffULL, 0x20000077ff787230ULL, 0x000fe20000004100ULL,
0x000010547a767816ULL, 0x000fe20000000076ULL, 0x20000073ff7a7230ULL, 0x000fe20000004100ULL,
0x00000010ff777819ULL, 0x000fe4000001167cULL, 0x00000010ff737819ULL, 0x000fe40000011672ULL,
0x00000010ff817819ULL, 0x000fc40000011681ULL, 0x00000083ff83723eULL, 0x000fe400020006ffULL,
0x00000085ff85723eULL, 0x000fe400020006ffULL, 0x000000ff6f7c7812ULL, 0x000fe200078ec0ffULL,
0x20000083ff837230ULL, 0x000fe20000004100ULL, 0x0000ffff4e4e7812ULL, 0x000fe200078ec0ffULL,
0x20000085ff857230ULL, 0x000fe20000004100ULL, 0x00000010ff6f7819ULL, 0x000fe40000011675ULL,
0x00000010ff747819ULL, 0x000fc40000011674ULL, 0x00000010ff7b7819ULL, 0x000fe4000001167bULL,
0x00000010ff757819ULL, 0x000fe4000001167eULL, 0x0000105481737816ULL, 0x000fe40000000073ULL,
0x00000010ff6d7819ULL, 0x000fe4000001166dULL, 0x00000010ff6e7819ULL, 0x000fe4000001166eULL,
0x00000010ff807819ULL, 0x000fc40000011680ULL, 0x00000010ff817819ULL, 0x000fe40000011682ULL,
0x000000ff4c4c7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff4e7819ULL, 0x000fe4000001164eULL,
0x0000105474747816ULL, 0x000fe4000000007bULL, 0x000010546f757816ULL, 0x000fe40000000075ULL,
0x000010546d807816ULL, 0x000fc40000000080ULL, 0x000010546e817816ULL, 0x000fe40000000081ULL,
0x00000010ff717819ULL, 0x000fe20000011671ULL, 0x000000744834723cULL, 0x000b620000041834ULL,
0x00000010ff7f7819ULL, 0x000fe4000001167fULL, 0x0000004cff4c723eULL, 0x000fe400020006ffULL,
0x0000004eff4e723eULL, 0x000fe400020006ffULL, 0x00000010ff4f7819ULL, 0x000fe2000001164fULL,
0x2000004cff747230ULL, 0x020fe20000004100ULL, 0x00000010ff4d7819ULL, 0x000fc4000001164dULL,
0x00000010ff837819ULL, 0x000fe40000011683ULL, 0x00000010ff6f7819ULL, 0x000fe40000011685ULL,
0x0000a800036d7811ULL, 0x000fe400078e20ffULL, 0x000010547f727816ULL, 0x000fe20000000071ULL,
0x2000004eff717230ULL, 0x000fe20000004100ULL, 0x00001054836e7816ULL, 0x000fe4000000004fULL,
0x000010546f6f7816ULL, 0x000fc4000000004dULL, 0x00000080484c723cULL, 0x040be2000004182cULL,
0x00000086ff5f723eULL, 0x000fe200020006ffULL, 0x000000006d2c783bULL, 0x020e620000000200ULL,
0x00000008ff847819ULL, 0x000fe40000011691ULL, 0x00000008ff867819ULL, 0x000fe20000011692ULL,
0x2000005fff5f7230ULL, 0x000fe20000004100ULL, 0x00000089ff61723eULL, 0x000fe200020006ffULL,
0x000000724830723cULL, 0x000be20000041830ULL, 0x000000ff87877812ULL, 0x000fe400078ec0ffULL,
0x000000ff88897812ULL, 0x000fe200078ec0ffULL, 0x20000061ff617230ULL, 0x000fe20000004100ULL,
0x00000084ff84723eULL, 0x000fc400020006ffULL, 0x00000086ff86723eULL, 0x000fe400020006ffULL,
0x00000087ff87723eULL, 0x000fe200020006ffULL, 0x20000084ff847230ULL, 0x000fe20000004100ULL,
0x00000089ff89723eULL, 0x000fe200020006ffULL, 0x20000086ff867230ULL, 0x000fe20000004100ULL,
0x00000008ff887819ULL, 0x000fe20000011693ULL, 0x20000087ff877230ULL, 0x000fe20000004100ULL,
0x00000008ff797819ULL, 0x000fe20000011679ULL, 0x20000089ff897230ULL, 0x000fe20000004100ULL,
0x00000088ff88723eULL, 0x000fc400020006ffULL, 0x00000079ff79723eULL, 0x000fe400020006ffULL,
0x00000008ff507819ULL, 0x000fe20000011650ULL, 0x20000088ff887230ULL, 0x000fe20000004100ULL,
0x000000ff51517812ULL, 0x000fe200078ec0ffULL, 0x20000079ff797230ULL, 0x000fe20000004100ULL,
0x00000010ff527819ULL, 0x000fe40000011652ULL, 0x00000010ff537819ULL, 0x000fe40000011653ULL,
0x00000010ff847819ULL, 0x000fc40000011684ULL, 0x00000010ff857819ULL, 0x000fe40000011686ULL,
0x00000010ff6c7819ULL, 0x000fe2000001166cULL, 0x000000192c2ca231ULL, 0x082fe200003400ffULL,
0x00000010ff6b7819ULL, 0x000fe2000001166bULL, 0x000000192e2ea231ULL, 0x000fe200003400ffULL,
0x00000010ff877819ULL, 0x000fe20000011687ULL, 0x000000182d2da231ULL, 0x080fe200003400ffULL,
0x00000010ff6d7819ULL, 0x000fe20000011689ULL, 0x000000182f2fa231ULL, 0x000fe200003400ffULL,
0x000000ff54547812ULL, 0x000fc400078ec0ffULL, 0x00000050ff72723eULL, 0x020fe400020006ffULL,
0x00000051ff73723eULL, 0x000fe400020006ffULL, 0x0000105452847816ULL, 0x000fe20000000084ULL,
0x20000072ff727230ULL, 0x000fe20000004100ULL, 0x0000105453857816ULL, 0x000fe20000000085ULL,
0x20000073ff737230ULL, 0x000fe20000004100ULL, 0x0000008bff5d723eULL, 0x000fe200020006ffULL,
0x0000006e4850723cULL, 0x000b620000041804ULL, 0x000000ff708b7812ULL, 0x000fe200078ec0ffULL,
0x2000008aff707230ULL, 0x000fe20000004100ULL, 0x00001054876c7816ULL, 0x000fe2000000006cULL,
0x2000005dff5d7230ULL, 0x000fe20000004100ULL, 0x000010546d6d7816ULL, 0x000fc4000000006bULL,
0x00000008ff557819ULL, 0x000fe20000011655ULL, 0x00000084480c723cULL, 0x000fe2000004180cULL,
0x00000054ff05723eULL, 0x020fe400020006ffULL, 0x00000010ff567819ULL, 0x000fe40000011656ULL,
0x00000010ff577819ULL, 0x000fe20000011657ULL, 0x20000005ff6b7230ULL, 0x000fe20000004100ULL,
0x00000010ff887819ULL, 0x000fe40000011688ULL, 0x00000010ff797819ULL, 0x000fc40000011679ULL,
0x00000055ff04723eULL, 0x000fe400020006ffULL, 0x00000010ff7d7819ULL, 0x000fe4000001167dULL,
0x0000105456887816ULL, 0x000fe40000000088ULL, 0x0000105457897816ULL, 0x000fe40000000079ULL,
0x00000010ff677819ULL, 0x000fe20000011667ULL, 0x0000006c4854723cULL, 0x000be20000041808ULL,
0x00000010ff687819ULL, 0x000fc40000011668ULL, 0x00000010ff707819ULL, 0x000fe40000011670ULL,
0x00000010ff057819ULL, 0x000fe4000001167aULL, 0x00000010ff097819ULL, 0x020fe20000011669ULL,
0x20000004ff697230ULL, 0x000fe20000004100ULL, 0x000010547d777816ULL, 0x000fe20000000077ULL,
0x000000884810723cULL, 0x000fe20000041810ULL, 0x0000105467047816ULL, 0x000fe40000000070ULL,
0x0000105468057816ULL, 0x000fc40000000005ULL, 0x0000007cff7c723eULL, 0x000fe400020006ffULL,
0x00000008ff477819ULL, 0x000fe20000011647ULL, 0x000000764838723cULL, 0x000f620000041838ULL,
0x000000ff5b5b7812ULL, 0x000fe200078ec0ffULL, 0x2000007cff7c7230ULL, 0x000fe20000004100ULL,
0x000000ff45457812ULL, 0x000fe400078ec0ffULL, 0x00000008ff467819ULL, 0x000fe40000011646ULL,
0x00000008ff437819ULL, 0x000fe20000011643ULL, 0x000000042c04723cULL, 0x000b620000041834ULL,
0x00000010ff617819ULL, 0x000fc40000011661ULL, 0x00000010ff737819ULL, 0x000fe40000011673ULL,
0x00000010ff6b7819ULL, 0x000fe4000001166bULL, 0x00000010ff357819ULL, 0x020fe40000011662ULL,
0x00000047ff47723eULL, 0x000fe400020006ffULL, 0x0000006aff6a723eULL, 0x000fe400020006ffULL,
0x0000008cff5c723eULL, 0x000fe200020006ffULL, 0x20000047ff477230ULL, 0x000fe20000004100ULL,
0x0000008bff8b723eULL, 0x000fe200020006ffULL, 0x2000006aff6a7230ULL, 0x000fe20000004100ULL,
0x0000005bff5b723eULL, 0x000fe200020006ffULL, 0x2000005cff5c7230ULL, 0x000fe20000004100ULL,
0x00000045ff45723eULL, 0x000fe200020006ffULL, 0x2000008bff8b7230ULL, 0x000fe20000004100ULL,
0x00000046ff46723eULL, 0x000fe200020006ffULL, 0x2000005bff5b7230ULL, 0x000fe20000004100ULL,
0x00000043ff43723eULL, 0x000fe200020006ffULL, 0x20000045ff457230ULL, 0x000fe20000004100ULL,
0x0000105473347816ULL, 0x000fe20000000061ULL, 0x20000046ff467230ULL, 0x000fe20000004100ULL,
0x000010546b357816ULL, 0x000fe20000000035ULL, 0x20000043ff437230ULL, 0x000fe20000004100ULL,
0x00000010ff657819ULL, 0x000fc40000011665ULL, 0x00000010ff7c7819ULL, 0x000fe4000001167cULL,
0x00000010ff377819ULL, 0x000fe20000011647ULL, 0x000000342c50723cULL, 0x000b620000041850ULL,
0x000010547c7c7816ULL, 0x000fe40000000065ULL, 0x00000010ff6a7819ULL, 0x000fe4000001166aULL,
0x00000010ff787819ULL, 0x000fe40000011678ULL, 0x00000010ff8b7819ULL, 0x000fc4000001168bULL,
0x00000010ff667819ULL, 0x000fe40000011666ULL, 0x00000010ff747819ULL, 0x000fe40000011674ULL,
0x00000010ff647819ULL, 0x000fe40000011664ULL, 0x00000010ff637819ULL, 0x000fe40000011663ULL,
0x00000010ff717819ULL, 0x000fe40000011671ULL, 0x00000010ff657819ULL, 0x000fc40000011672ULL,
0x00000010ff5f7819ULL, 0x000fe4000001165fULL, 0x00000010ff697819ULL, 0x000fe40000011669ULL,
0x00000010ff607819ULL, 0x000fe40000011660ULL, 0x00000010ff5d7819ULL, 0x000fe4000001165dULL,
0x00000010ff5b7819ULL, 0x000fe4000001165bULL, 0x00000010ff357819ULL, 0x020fc4000001165cULL,
0x00000010ff457819ULL, 0x000fe40000011645ULL, 0x00000010ff5a7819ULL, 0x000fe4000001165aULL,
0x00000010ff467819ULL, 0x000fe40000011646ULL, 0x00000010ff477819ULL, 0x000fe4000001165eULL,
0x00000010ff437819ULL, 0x000fe40000011643ULL, 0x0000105478087816ULL, 0x000fc4000000006aULL,
0x000010548b097816ULL, 0x000fe40000000009ULL, 0x00001054747d7816ULL, 0x000fe40000000066ULL,
0x0000105464647816ULL, 0x000fe40000000071ULL, 0x0000105463657816ULL, 0x000fe20000000065ULL,
0x000000082c08723cULL, 0x000b620000041838ULL, 0x000010545f367816ULL, 0x000fe40000000069ULL,
0x0000105460377816ULL, 0x000fc40000000037ULL, 0x000010545b347816ULL, 0x000fe4000000005dULL,
0x0000105445357816ULL, 0x000fe20000000035ULL, 0x0000007c2c30723cULL, 0x000b620000041830ULL,
0x000010545a467816ULL, 0x000fe40000000046ULL, 0x0000105447477816ULL, 0x000fca0000000043ULL,
0x000000642c4c723cULL, 0x040b70000004184cULL, 0x000000362c0c723cULL, 0x040b70000004180cULL,
0x000000342c54723cULL, 0x040b700000041854ULL, 0x000000462c10723cULL, 0x000b620000041810ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff347f8cULL, 0x020e62000c80043fULL,
0x000000ffff377224ULL, 0x000fce00078e00ffULL, 0x00000000002c7805ULL, 0x000fc40000015200ULL,
0x0106bc00ff2e7984ULL, 0x000ea40000000800ULL, 0x800000002eff7812ULL, 0x006fc40007804835ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103700780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002e7805ULL, 0x000fcc0000015200ULL,
0x0000002e2c367210ULL, 0x000fca0007f1e1ffULL, 0x000000012f2f7824ULL, 0x000fe200000e0e2dULL,
0x003d09003600780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403600780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff2e7819ULL, 0x000fc8000001142fULL, 0x000000362e2e7211ULL, 0x000fca00078110ffULL,
0x000000ffff2f7224ULL, 0x000fca00000e062fULL, 0x000000022e2e7819ULL, 0x000fc8000000122fULL,
0x0000002e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000137377810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106bc00ff2e7984ULL, 0x000e640000000800ULL, 0x800000002eff7812ULL, 0x002fe40007804835ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000580024457a24ULL, 0x010fc800078e02ffULL,
0x0000004045457824ULL, 0x000fe200078e00ffULL, 0x0000045000009947ULL, 0x000fea0003800000ULL,
0x000000403c2c7810ULL, 0x000fe20007ffe0ffULL, 0x00000001252e7824ULL, 0x000fe200078e0217ULL,
0x0000000217437810ULL, 0x000fe40007ffe0ffULL, 0x0000002c282d7217ULL, 0x000fe20007800000ULL,
0x0000004029397824ULL, 0x000fe200078e022eULL, 0x0000000417477810ULL, 0x000fe20007ffe0ffULL,
0x000000012e2f7824ULL, 0x040fe200078e022aULL, 0x000000f01f3a7812ULL, 0x000fe200078ec0ffULL,
0x000000102e3b7824ULL, 0x000fe200078e00ffULL, 0x0000004539367210ULL, 0x000fe20007f1e0ffULL,
0x00000001252e7824ULL, 0x000fe200078e0243ULL, 0x0000000239387810ULL, 0x000fe20007ffe0ffULL,
0x000000012d2d7824ULL, 0x000fe200078e0a2cULL, 0xfffffff03b3b7812ULL, 0x000fe200078ee22fULL,
0x00000001252c7824ULL, 0x000fe200078e0247ULL, 0x0000000439377810ULL, 0x000fe20007ffe0ffULL,
0x000000012e2f7824ULL, 0x140fe200078e022aULL, 0x0000002d252d7217ULL, 0x000fe20007800000ULL,
0x000000102e467824ULL, 0x000fe200078e00ffULL, 0x0000004537377210ULL, 0x000fe20007f7e0ffULL,
0x000000012c2e7824ULL, 0x040fe200078e022aULL, 0x0000c0003b3b7811ULL, 0x000fe200078e20ffULL,
0x000000102c487824ULL, 0x000fe200078e00ffULL, 0xfffffff046467812ULL, 0x000fe200078ee22fULL,
0x000000ffff2c7224ULL, 0x000fe200000e06ffULL, 0x00005e0036357a11ULL, 0x000fe200078040ffULL,
0x000000012d2f7824ULL, 0x000fe200078e0a25ULL, 0xfffffff048487812ULL, 0x000fe200078ee22eULL,
0x000000ffff2d7224ULL, 0x000fe200018e06ffULL, 0x00005f0036367a11ULL, 0x000fc400000f442cULL,
0x0000004538387210ULL, 0x000fe40007f1e0ffULL, 0x0000002f1700720cULL, 0x000fe40003f86070ULL,
0x00005e00372e7a11ULL, 0x040fe200078a40ffULL, 0x000000ffff2c7224ULL, 0x000fe200000e06ffULL,
0x00005e0038347a11ULL, 0x040fe400078040ffULL, 0x00005f0037377a11ULL, 0x000fe400028f442dULL,
0x00005f0038387a11ULL, 0x000fc400000f442cULL, 0x0000003a352c7210ULL, 0x000fe40007f7e0ffULL,
0x0000002f4300720cULL, 0x080fe40003f06070ULL, 0x0000000617437810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2d7224ULL, 0x000fe200018e0636ULL, 0x0000000639357810ULL, 0x000fe40007ffe0ffULL,
0x0000002f4700720cULL, 0x000fe20003f66070ULL, 0x0000000125367824ULL, 0x000fe200078e0243ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c3b7faeULL, 0x0003e2000e101c46ULL,
0x0000004535357210ULL, 0x000fc40007f9e0ffULL, 0x0000000136397824ULL, 0x000fe200078e022aULL,
0x0000003a2e2e7210ULL, 0x080fe40007fde0ffULL, 0x0000c00046467811ULL, 0x000fe400078e20ffULL,
0x0000c00048487811ULL, 0x000fe400078e20ffULL, 0x0000003a342c7210ULL, 0x002fe20007fbe0ffULL,
0x00000010363b7824ULL, 0x000fe400078e00ffULL, 0x000000ffff367224ULL, 0x000fe200020e06ffULL,
0x00005e0035347a11ULL, 0x000fe200078840ffULL, 0x000000ffff2d7224ULL, 0x000fe200028e0638ULL,
0x0000002f4300720cULL, 0x000fe20003fa6070ULL, 0x000000ffff2f7224ULL, 0x000fe200030e0637ULL,
0x00005f0035357a11ULL, 0x000fc400020f4436ULL, 0x0000003a34347210ULL, 0x000fe20007f9e0ffULL,
0x000000002c467faeULL, 0x0003e2000c101c46ULL, 0xfffffff03b397812ULL, 0x000fc600078ee239ULL,
0x000000ffff357224ULL, 0x000fe200020e0635ULL, 0x0000c00039397811ULL, 0x000fe200078e20ffULL,
0x000000002e487faeULL, 0x0003e8000d901c46ULL, 0x0000000034397faeULL, 0x0003e2000e901c46ULL,
0x0000038000007947ULL, 0x000fea0003800000ULL, 0x00000001252c7824ULL, 0x000fc800078e0217ULL,
0x000000012c2d7824ULL, 0x040fe200078e022aULL, 0x000000022c2e7810ULL, 0x040fe20007ffe0ffULL,
0x000000102c347824ULL, 0x000fc800078e00ffULL, 0x000000012e2f7824ULL, 0x000fe200078e022aULL,
0xfffffff034347812ULL, 0x000fe200078ee22dULL, 0x000000102e387824ULL, 0x000fe200078e00ffULL,
0x000000042c2e7810ULL, 0x000fe20007ffe0ffULL, 0x00000040292d7824ULL, 0x000fc600078e022cULL,
0xfffffff038387812ULL, 0x000fe200078ee22fULL, 0x000000012e357824ULL, 0x100fe200078e022aULL,
0x000000062c2f7810ULL, 0x000fe20007ffe0ffULL, 0x000000102e437824ULL, 0x000fe200078e00ffULL,
0x000000452d2c7210ULL, 0x000fe40007f1e0ffULL, 0x0000c00038387811ULL, 0x000fe200078e20ffULL,
0x000000012f367824ULL, 0x000fe200078e022aULL, 0xfffffff043437812ULL, 0x000fe200078ee235ULL,
0x000000102f497824ULL, 0x000fe200078e00ffULL, 0x000000022d357810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2e7224ULL, 0x000fe200000e06ffULL, 0x00005e002c2f7a11ULL, 0x000fc400078040ffULL,
0xfffffff049497812ULL, 0x000fe400078ee236ULL, 0x00005f002c2e7a11ULL, 0x000fe400000f442eULL,
0x000000042d2c7810ULL, 0x040fe40007ffe0ffULL, 0x000000062d2d7810ULL, 0x000fe40007ffe0ffULL,
0x0000004535357210ULL, 0x080fe40007f1e0ffULL, 0x000000452c397210ULL, 0x000fc40007f7e0ffULL,
0x000000f01f367812ULL, 0x000fe400078ec0ffULL, 0x000000452d467210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff2d7224ULL, 0x000fe200000e06ffULL, 0x00005e0035377a11ULL, 0x000fe200078040ffULL,
0x000000ffff3a7224ULL, 0x000fe200018e06ffULL, 0x000000362f2c7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff477224ULL, 0x000fe200028e06ffULL, 0x00005e00393b7a11ULL, 0x000fe400078840ffULL,
0x00005e0046487a11ULL, 0x000fc400078a40ffULL, 0x00005f0035357a11ULL, 0x000fe200000f442dULL,
0x000000ffff2d7224ULL, 0x000fe200018e062eULL, 0x0000c000342f7811ULL, 0x000fe400078e20ffULL,
0x00000036372e7210ULL, 0x080fe40007f1e0ffULL, 0x00005f00393a7a11ULL, 0x000fe200020f443aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c2f7faeULL, 0x0003e2000b901c46ULL,
0x000000363b347210ULL, 0x000fe40007f7e0ffULL, 0x00005f0046477a11ULL, 0x000fc400028f4447ULL,
0x0000003648367210ULL, 0x000fe40007f9e0ffULL, 0x0000c00043437811ULL, 0x000fe400078e20ffULL,
0x0000c00049497811ULL, 0x000fe200078e20ffULL, 0x000000ffff377224ULL, 0x000fe400020e0647ULL,
0x000000ffff2f7224ULL, 0x002fe400000e0635ULL, 0x000000ffff357224ULL, 0x000fc600018e063aULL,
0x000000002e387faeULL, 0x0003e8000b901c46ULL, 0x0000000034437faeULL, 0x0003e8000b901c46ULL,
0x0000000036497faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff2c7f8cULL, 0x000e64000c80043fULL,
0x000000ffff437224ULL, 0x002fc400078e002dULL, 0x00000000002c7805ULL, 0x000fca0000015200ULL,
0x0106b400ff2e7984ULL, 0x000e640000000800ULL, 0x800000002eff7812ULL, 0x002fc40007804859ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff357224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002e7805ULL, 0x000fcc0000015200ULL, 0x0000002e2c347210ULL, 0x000fca0007f1e1ffULL,
0x000000012f2f7824ULL, 0x000fe200000e0e2dULL, 0x003d09003400780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403400780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff2e7819ULL, 0x000fc8000001142fULL,
0x000000342e2e7211ULL, 0x000fca00078110ffULL, 0x000000ffff2f7224ULL, 0x000fca00000e062fULL,
0x000000022e2e7819ULL, 0x000fc8000000122fULL, 0x0000002e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000135357810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106b400ff2e7984ULL, 0x000e640000000800ULL,
0x800000002eff7812ULL, 0x002fe40007804859ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000014000007945ULL, 0x000fe20003800000ULL, 0x0000012000002947ULL, 0x000fea0003800000ULL,
0x0000001aff18723eULL, 0x000fe400000010ffULL, 0x00000002ff2d7819ULL, 0x000fe4000001162aULL,
0x00005410182c7816ULL, 0x000fe20000000018ULL, 0x000129527f007947ULL, 0x000fea000b800000ULL,
0x00001f2d2c197589ULL, 0x0002a400000e0000ULL, 0x000000082d187810ULL, 0x000fe20007ffe0ffULL,
0x000129827f007947ULL, 0x000fea000b800000ULL, 0x00001f182c187589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000102d477810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff5a7224ULL, 0x000fe200078e002cULL, 0x0000a31000467802ULL, 0x000fc40000000f00ULL,
0x000133f000007944ULL, 0x00efea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000182d477810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff5a7224ULL, 0x004fe200078e002cULL,
0x0000a36000467802ULL, 0x000fc40000000f00ULL, 0x000133a000007944ULL, 0x00afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000004048783bULL, 0x000f280000004200ULL, 0x000000004138783bULL, 0x000ee80000004200ULL,
0x000000004234783bULL, 0x000ea80000004200ULL, 0x000000003d2c783bULL, 0x00ae620000004200ULL,
0x00000010ff7a7819ULL, 0x010fc40000011649ULL, 0x000000ff495b7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff5a7819ULL, 0x004fe40000011649ULL, 0x0000ffff498f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff837819ULL, 0x100fe40000011638ULL, 0x000000ff38627812ULL, 0x000fe400078ec0ffULL,
0x00000018ff617819ULL, 0x000fc40000011638ULL, 0x0000ffff38927812ULL, 0x000fe400078ec0ffULL,
0x00000010ff877819ULL, 0x100fe4000001163aULL, 0x000000ff3a667812ULL, 0x040fe400078ec0ffULL,
0x00000018ff657819ULL, 0x000fe4000001163aULL, 0x0000ffff3a947812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5c7819ULL, 0x000fc40000011648ULL, 0x000000ff48467812ULL, 0x040fe400078ec0ffULL,
0x00000018ff597819ULL, 0x000fe40000011648ULL, 0x0000ffff488e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff847819ULL, 0x100fe40000011639ULL, 0x000000ff39647812ULL, 0x000fe400078ec0ffULL,
0x00000018ff637819ULL, 0x000fc40000011639ULL, 0x0000ffff39937812ULL, 0x000fe400078ec0ffULL,
0x00000010ff887819ULL, 0x100fe4000001163bULL, 0x000000ff3b677812ULL, 0x040fe400078ec0ffULL,
0x00000018ff3a7819ULL, 0x000fe4000001163bULL, 0x0000ffff3b797812ULL, 0x000fe400078ec0ffULL,
0x00000010ff497819ULL, 0x000fc40000011637ULL, 0x000000ff37867812ULL, 0x040fe400078ec0ffULL,
0x00000018ff857819ULL, 0x000fe40000011637ULL, 0x0000ffff37387812ULL, 0x000fe400078ec0ffULL,
0x00000010ff727819ULL, 0x100fe40000011634ULL, 0x000000ff347b7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff3b7819ULL, 0x000fc40000011634ULL, 0x0000ffff34787812ULL, 0x000fe400078ec0ffULL,
0x00000010ff717819ULL, 0x100fe40000011636ULL, 0x000000ff36827812ULL, 0x040fe400078ec0ffULL,
0x00000018ff817819ULL, 0x000fe40000011636ULL, 0x0000ffff36487812ULL, 0x000fe400078ec0ffULL,
0x00000010ff397819ULL, 0x002fc4000001162cULL, 0x000000ff2c8a7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff897819ULL, 0x000fe4000001162cULL, 0x0000ffff2c377812ULL, 0x000fe400078ec0ffULL,
0x00000018ff5d7819ULL, 0x000fe4000001164aULL, 0x00000010ff367819ULL, 0x000fe4000001162dULL,
0x000000ff2d8b7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff2c7819ULL, 0x000fe4000001162dULL,
0x0000ffff2d347812ULL, 0x000fe400078ec0ffULL, 0x00000018ff2d7819ULL, 0x000fe4000001162eULL,
0x00000010ff7e7819ULL, 0x000fe4000001164aULL, 0x000000ff4a5e7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff4a907812ULL, 0x000fc400078ec0ffULL, 0x00000010ff7f7819ULL, 0x100fe4000001164bULL,
0x000000ff4b607812ULL, 0x040fe400078ec0ffULL, 0x00000018ff5f7819ULL, 0x000fe4000001164bULL,
0x0000ffff4b917812ULL, 0x000fe400078ec0ffULL, 0x00000059ff59723eULL, 0x000fe400020006ffULL,
0x0000005dff5d723eULL, 0x000fc400020006ffULL, 0x00000066ff66723eULL, 0x000fe200020006ffULL,
0x20000059ff757230ULL, 0x000fe20000004100ULL, 0x00000010ff4b7819ULL, 0x100fe20000011635ULL,
0x2000005dff6f7230ULL, 0x000fe20000004100ULL, 0x000000ff35807812ULL, 0x040fe200078ec0ffULL,
0x20000066ff6a7230ULL, 0x000fe20000004100ULL, 0x00000018ff7d7819ULL, 0x000fe40000011635ULL,
0x0000ffff354a7812ULL, 0x000fe400078ec0ffULL, 0x0000002cff2c723eULL, 0x000fc400020006ffULL,
0x0000002dff2d723eULL, 0x000fe400020006ffULL, 0x00000010ff357819ULL, 0x000fe2000001162eULL,
0x2000002cff5d7230ULL, 0x000fe20000004100ULL, 0x000000ff2e8c7812ULL, 0x040fe200078ec0ffULL,
0x2000002dff597230ULL, 0x000fe20000004100ULL, 0x0000ffff2e587812ULL, 0x000fe400078ec0ffULL,
0x00000018ff2e7819ULL, 0x000fe4000001162fULL, 0x000000ff5c5c7812ULL, 0x000fc400078ec0ffULL,
0x000000ff7a7a7812ULL, 0x000fe400078ec0ffULL, 0x00000046ff77723eULL, 0x000fe400020006ffULL,
0x0000003aff3a723eULL, 0x000fe400020006ffULL, 0x0000007bff66723eULL, 0x000fe200020006ffULL,
0x20000077ff777230ULL, 0x000fe20000004100ULL, 0x00000010ff477819ULL, 0x000fe2000001162fULL,
0x2000003aff687230ULL, 0x000fe20000004100ULL, 0x000000ff2f8d7812ULL, 0x040fe200078ec0ffULL,
0x20000066ff667230ULL, 0x000fe20000004100ULL, 0x0000ffff2f467812ULL, 0x000fc400078ec0ffULL,
0x00000008ff2d7819ULL, 0x000fe4000001168eULL, 0x0000002eff7b723eULL, 0x000fe400020006ffULL,
0x0000005cff2c723eULL, 0x000fe400020006ffULL, 0x0000007aff2e723eULL, 0x000fe200020006ffULL,
0x2000007bff5c7230ULL, 0x000fe20000004100ULL, 0x00000008ff2f7819ULL, 0x000fe2000001168fULL,
0x2000002cff7a7230ULL, 0x000fe20000004100ULL, 0x0000002dff2d723eULL, 0x000fc400020006ffULL,
0x0000007dff3a723eULL, 0x000fe200020006ffULL, 0x2000002eff7d7230ULL, 0x000fe20000004100ULL,
0x0000002fff2f723eULL, 0x000fe200020006ffULL, 0x2000002dff7b7230ULL, 0x000fe20000004100ULL,
0x000000ff7e2c7812ULL, 0x000fe200078ec0ffULL, 0x2000003aff3a7230ULL, 0x000fe20000004100ULL,
0x000000ff7f7f7812ULL, 0x000fe200078ec0ffULL, 0x2000002fff7e7230ULL, 0x000fe20000004100ULL,
0x00000008ff2e7819ULL, 0x000fe40000011690ULL, 0x00000067ff67723eULL, 0x000fc400020006ffULL,
0x00000061ff61723eULL, 0x000fe400020006ffULL, 0x00000065ff65723eULL, 0x000fe200020006ffULL,
0x20000067ff697230ULL, 0x000fe20000004100ULL, 0x0000002cff2d723eULL, 0x000fe200020006ffULL,
0x20000061ff6b7230ULL, 0x000fe20000004100ULL, 0x0000007fff2f723eULL, 0x000fe200020006ffULL,
0x20000065ff677230ULL, 0x000fe20000004100ULL, 0x0000002eff2e723eULL, 0x000fe200020006ffULL,
0x2000002dff7f7230ULL, 0x000fe20000004100ULL, 0x0000a8003e2c7811ULL, 0x000fc400078e20ffULL,
0x00000080ff65723eULL, 0x000fe200020006ffULL, 0x2000002eff807230ULL, 0x000fe20000004100ULL,
0x00000081ff61723eULL, 0x000fe200020006ffULL, 0x2000002fff817230ULL, 0x000fe20000004100ULL,
0x00000060ff60723eULL, 0x000fe200020006ffULL, 0x000000002c2c783bULL, 0x000e620000000200ULL,
0x000000ff72727812ULL, 0x000fe200078ec0ffULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x00000008ff787819ULL, 0x000fe20000011678ULL, 0x20000060ff747230ULL, 0x000fe20000004100ULL,
0x0000005bff5b723eULL, 0x000fe200020006ffULL, 0x20000061ff617230ULL, 0x000fe20000004100ULL,
0x0000005fff5f723eULL, 0x000fc400020006ffULL, 0x0000008aff60723eULL, 0x000fe200020006ffULL,
0x2000005bff7c7230ULL, 0x000fe20000004100ULL, 0x00000072ff72723eULL, 0x000fe200020006ffULL,
0x2000005fff707230ULL, 0x000fe20000004100ULL, 0x00000078ff8a723eULL, 0x000fe200020006ffULL,
0x20000060ff607230ULL, 0x000fe20000004100ULL, 0x000000ff4b4b7812ULL, 0x000fe200078ec0ffULL,
0x20000072ff787230ULL, 0x000fe20000004100ULL, 0x00000064ff64723eULL, 0x000fe200020006ffULL,
0x2000008aff727230ULL, 0x000fe20000004100ULL, 0x0000008bff5f723eULL, 0x000fc400020006ffULL,
0x0000004bff8a723eULL, 0x000fe200020006ffULL, 0x20000064ff6d7230ULL, 0x000fe20000004100ULL,
0x00000008ff8b7819ULL, 0x000fe2000001164aULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x00000010ff4a7819ULL, 0x000fe20000011677ULL, 0x2000008aff8a7230ULL, 0x000fe20000004100ULL,
0x00000010ff4b7819ULL, 0x000fe4000001167cULL, 0x00000010ff7a7819ULL, 0x000fe4000001167aULL,
0x00000010ff7d7819ULL, 0x000fc4000001167dULL, 0x0000005aff5a723eULL, 0x000fe400020006ffULL,
0x0000005eff5e723eULL, 0x000fe400020006ffULL, 0x00000082ff64723eULL, 0x000fe200020006ffULL,
0x2000005aff767230ULL, 0x000fe20000004100ULL, 0x00000008ff827819ULL, 0x000fe20000011691ULL,
0x000000192c2ca231ULL, 0x082fe200003400ffULL, 0x000010547a4a7816ULL, 0x000fe2000000004aULL,
0x000000192e2ea231ULL, 0x000fe200003400ffULL, 0x000010547d4b7816ULL, 0x000fe2000000004bULL,
0x000000182d2da231ULL, 0x080fe200003400ffULL, 0x2000005eff737230ULL, 0x000fe20000004100ULL,
0x000000182f2fa231ULL, 0x000fe200003400ffULL, 0x000000ff49497812ULL, 0x000fe200078ec0ffULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x00000082ff82723eULL, 0x000fc400020006ffULL,
0x000000ff717a7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff717819ULL, 0x000fe20000011676ULL,
0x0000004a2c08723cULL, 0x000b620000041808ULL, 0x00000010ff777819ULL, 0x000fe2000001167eULL,
0x20000082ff827230ULL, 0x000fe20000004100ULL, 0x00000049ff49723eULL, 0x000fe400020006ffULL,
0x00000010ff737819ULL, 0x000fe40000011673ULL, 0x00000010ff4b7819ULL, 0x020fc40000011674ULL,
0x00000010ff7f7819ULL, 0x000fe4000001167fULL, 0x00000010ff817819ULL, 0x000fe40000011681ULL,
0x00000008ff487819ULL, 0x000fe40000011648ULL, 0x0000105471777816ULL, 0x000fe20000000077ULL,
0x20000049ff717230ULL, 0x000fe20000004100ULL, 0x000010547f4a7816ULL, 0x000fe40000000073ULL,
0x00001054814b7816ULL, 0x000fc4000000004bULL, 0x00000048ff49723eULL, 0x000fe400020006ffULL,
0x00000010ff707819ULL, 0x000fe40000011670ULL, 0x00000010ff817819ULL, 0x000fe20000011682ULL,
0x0000004a2c30723cULL, 0x000be20000041830ULL, 0x0000a8003f487811ULL, 0x000fe400078e20ffULL,
0x0000105470817816ULL, 0x000fe20000000081ULL, 0x20000049ff707230ULL, 0x000fe20000004100ULL,
0x00000062ff62723eULL, 0x000fc400020006ffULL, 0x000000004848783bULL, 0x020e620000000200ULL,
0x00000063ff63723eULL, 0x000fe400020006ffULL, 0x20000062ff6e7230ULL, 0x000fe20000004100ULL,
0x00000085ff62723eULL, 0x000fe400020006ffULL, 0x000000ff84857812ULL, 0x000fe200078ec0ffULL,
0x20000063ff6c7230ULL, 0x000fe20000004100ULL, 0x00000008ff847819ULL, 0x000fe20000011692ULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x00000089ff5e723eULL, 0x000fc400020006ffULL,
0x00000086ff63723eULL, 0x000fe400020006ffULL, 0x00000084ff84723eULL, 0x000fe200020006ffULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x000000ff88897812ULL, 0x000fe200078ec0ffULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x000000ff83837812ULL, 0x000fe200078ec0ffULL,
0x20000084ff847230ULL, 0x000fe20000004100ULL, 0x00000008ff867819ULL, 0x000fe40000011693ULL,
0x000000ff87877812ULL, 0x000fc400078ec0ffULL, 0x00000008ff887819ULL, 0x000fe40000011694ULL,
0x00000008ff797819ULL, 0x000fe40000011679ULL, 0x00000085ff85723eULL, 0x000fe400020006ffULL,
0x00000083ff83723eULL, 0x000fe400020006ffULL, 0x00000086ff86723eULL, 0x000fe200020006ffULL,
0x20000085ff857230ULL, 0x000fe20000004100ULL, 0x00000087ff87723eULL, 0x000fe200020006ffULL,
0x20000083ff837230ULL, 0x000fe20000004100ULL, 0x00000089ff89723eULL, 0x000fe200020006ffULL,
0x20000086ff867230ULL, 0x000fe20000004100ULL, 0x00000088ff88723eULL, 0x000fe200020006ffULL,
0x20000087ff877230ULL, 0x000fe20000004100ULL, 0x00000079ff79723eULL, 0x000fe200020006ffULL,
0x20000089ff897230ULL, 0x000fe20000004100ULL, 0x00000010ff757819ULL, 0x000fe20000011675ULL,
0x20000088ff887230ULL, 0x000fe20000004100ULL, 0x00000010ff7b7819ULL, 0x000fe2000001167bULL,
0x20000079ff797230ULL, 0x000fe20000004100ULL, 0x00000010ff6f7819ULL, 0x000fe2000001166fULL,
0x000000194848a231ULL, 0x082fe200003400ffULL, 0x00000010ff807819ULL, 0x000fe20000011680ULL,
0x000000194a4aa231ULL, 0x000fe200003400ffULL, 0x0000105475767816ULL, 0x000fe2000000007bULL,
0x000000184949a231ULL, 0x080fe200003400ffULL, 0x00000010ff6b7819ULL, 0x000fe2000001166bULL,
0x000000184b4ba231ULL, 0x000fe200003400ffULL, 0x00000010ff847819ULL, 0x000fc40000011684ULL,
0x000010546f807816ULL, 0x000fe20000000080ULL, 0x000000762c04723cULL, 0x040f620000041804ULL,
0x000000ff39397812ULL, 0x000fe400078ec0ffULL, 0x00000010ff6f7819ULL, 0x000fe40000011685ULL,
0x000010546b847816ULL, 0x000fe40000000084ULL, 0x00000010ff6e7819ULL, 0x000fe2000001166eULL,
0x000000802c4c723cULL, 0x000f62000004184cULL, 0x00000010ff6d7819ULL, 0x000fc4000001166dULL,
0x00000010ff837819ULL, 0x000fe40000011683ULL, 0x00000010ff6c7819ULL, 0x000fe4000001166cULL,
0x00000010ff857819ULL, 0x000fe40000011686ULL, 0x00000010ff6a7819ULL, 0x000fe4000001166aULL,
0x00000010ff697819ULL, 0x000fe40000011669ULL, 0x00000010ff877819ULL, 0x000fc40000011687ULL,
0x00000010ff6b7819ULL, 0x000fe40000011689ULL, 0x00000010ff677819ULL, 0x000fe40000011667ULL,
0x00000010ff687819ULL, 0x000fe40000011668ULL, 0x00000010ff887819ULL, 0x000fe40000011688ULL,
0x00000010ff797819ULL, 0x000fe40000011679ULL, 0x00000008ff387819ULL, 0x000fc40000011638ULL,
0x00000039ff39723eULL, 0x000fe400020006ffULL, 0x0000003bff3b723eULL, 0x000fe400020006ffULL,
0x0000008bff8b723eULL, 0x000fe400020006ffULL, 0x00001054836e7816ULL, 0x000fe2000000006eULL,
0x2000003bff3b7230ULL, 0x000fe20000004100ULL, 0x000010546f6f7816ULL, 0x000fe2000000006dULL,
0x20000039ff6d7230ULL, 0x000fe20000004100ULL, 0x000010546c857816ULL, 0x000fe20000000085ULL,
0x2000008bff8b7230ULL, 0x000fe20000004100ULL, 0x00001054876a7816ULL, 0x000fc4000000006aULL,
0x000010546b6b7816ULL, 0x000fe20000000069ULL, 0x0000006e2c50723cULL, 0x040f620000041850ULL,
0x0000105467887816ULL, 0x000fe40000000088ULL, 0x0000105468897816ULL, 0x000fe40000000079ULL,
0x00000038ff38723eULL, 0x000fe400020006ffULL, 0x00000010ff667819ULL, 0x000fe20000011666ULL,
0x000000842c0c723cULL, 0x000f62000004180cULL, 0x00000010ff397819ULL, 0x000fe20000011665ULL,
0x20000038ff6c7230ULL, 0x000fe20000004100ULL, 0x00000010ff787819ULL, 0x000fc40000011678ULL,
0x00000010ff8a7819ULL, 0x000fe4000001168aULL, 0x00000008ff347819ULL, 0x000fe20000011634ULL,
0x0000006a2c54723cULL, 0x040f620000041854ULL, 0x0000105478387816ULL, 0x000fe40000000066ULL,
0x000010548a397816ULL, 0x000fe40000000039ULL, 0x00000008ff587819ULL, 0x000fe40000011658ULL,
0x000000ff36367812ULL, 0x000fe200078ec0ffULL, 0x000000882c10723cULL, 0x000b620000041810ULL,
0x00000008ff377819ULL, 0x000fc40000011637ULL, 0x000000ff47477812ULL, 0x000fe400078ec0ffULL,
0x00000008ff467819ULL, 0x000fe40000011646ULL, 0x000000ff352d7812ULL, 0x020fe400078ec0ffULL,
0x00000010ff3b7819ULL, 0x000fe4000001163bULL, 0x00000010ff3a7819ULL, 0x000fe4000001163aULL,
0x00000010ff727819ULL, 0x000fc40000011672ULL, 0x00000010ff357819ULL, 0x000fe4000001168bULL,
0x00000034ff2c723eULL, 0x000fe400020006ffULL, 0x0000008cff5b723eULL, 0x000fe400020006ffULL,
0x0000002dff2d723eULL, 0x000fe400020006ffULL, 0x00000058ff58723eULL, 0x000fe200020006ffULL,
0x2000005bff5b7230ULL, 0x000fe20000004100ULL, 0x0000008dff5a723eULL, 0x000fc400020006ffULL,
0x0000007aff7a723eULL, 0x000fe200020006ffULL, 0x20000058ff587230ULL, 0x000fe20000004100ULL,
0x00000036ff36723eULL, 0x000fe200020006ffULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x00000037ff37723eULL, 0x000fe200020006ffULL, 0x2000007aff7a7230ULL, 0x000fe20000004100ULL,
0x00000047ff47723eULL, 0x000fe200020006ffULL, 0x20000036ff687230ULL, 0x000fe20000004100ULL,
0x00000046ff46723eULL, 0x000fe200020006ffULL, 0x20000037ff677230ULL, 0x000fe20000004100ULL,
0x000010543b347816ULL, 0x000fe20000000072ULL, 0x20000047ff477230ULL, 0x000fe20000004100ULL,
0x000010543a357816ULL, 0x000fe20000000035ULL, 0x20000046ff467230ULL, 0x000fe20000004100ULL,
0x000000384838723cULL, 0x000b620000041808ULL, 0x00000010ff5d7819ULL, 0x000fc4000001165dULL,
0x00000010ff5b7819ULL, 0x000fe4000001165bULL, 0x00000010ff597819ULL, 0x000fe40000011659ULL,
0x2000002cff087230ULL, 0x020fe20000004100ULL, 0x000000344834723cULL, 0x000b620000041804ULL,
0x2000002dff097230ULL, 0x000fe20000004100ULL, 0x00000010ff587819ULL, 0x000fe40000011658ULL,
0x00000010ff087819ULL, 0x000fe40000011608ULL, 0x00000010ff097819ULL, 0x000fc40000011609ULL,
0x00000010ff647819ULL, 0x000fe40000011664ULL, 0x00000010ff637819ULL, 0x000fe40000011663ULL,
0x00000010ff7a7819ULL, 0x000fe4000001167aULL, 0x00000010ff657819ULL, 0x000fe40000011671ULL,
0x00000010ff617819ULL, 0x000fe40000011661ULL, 0x00000010ff627819ULL, 0x000fc40000011662ULL,
0x00000010ff707819ULL, 0x000fe40000011670ULL, 0x00000010ff2d7819ULL, 0x000fe4000001166cULL,
0x00000010ff607819ULL, 0x000fe40000011660ULL, 0x00000010ff057819ULL, 0x020fe4000001165fULL,
0x00000010ff6d7819ULL, 0x000fe4000001166dULL, 0x00000010ff687819ULL, 0x000fc40000011668ULL,
0x00000010ff5e7819ULL, 0x000fe4000001165eULL, 0x00000010ff677819ULL, 0x000fe40000011667ULL,
0x00000010ff5a7819ULL, 0x000fe4000001165aULL, 0x00000010ff477819ULL, 0x000fe40000011647ULL,
0x00000010ff5c7819ULL, 0x000fe4000001165cULL, 0x00000010ff467819ULL, 0x000fc40000011646ULL,
0x000010545d5f7816ULL, 0x000fe40000000008ULL, 0x0000105409087816ULL, 0x000fe4000000005bULL,
0x0000105459587816ULL, 0x000fe40000000058ULL, 0x000010547a647816ULL, 0x000fe40000000064ULL,
0x0000105465657816ULL, 0x000fe40000000063ULL, 0x00001054612c7816ULL, 0x000fc40000000070ULL,
0x00001054622d7816ULL, 0x000fe4000000002dULL, 0x000010546d047816ULL, 0x000fe20000000060ULL,
0x000000644830723cULL, 0x040b620000041830ULL, 0x0000105468057816ULL, 0x000fe40000000005ULL,
0x000010545e5e7816ULL, 0x000fe40000000067ULL, 0x0000105447097816ULL, 0x000fe4000000005aULL,
0x000010545c597816ULL, 0x000fe20000000046ULL, 0x0000002c482c723cULL, 0x040b70000004184cULL,
0x000000044804723cULL, 0x040b700000041850ULL, 0x0000005e480c723cULL, 0x040b70000004180cULL,
0x000000084808723cULL, 0x040b700000041854ULL, 0x000000584810723cULL, 0x000b620000041810ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff467f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000403c467810ULL, 0x002fe20007ffe0ffULL, 0x01069000ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff4a7224ULL, 0x020fe200078e0047ULL, 0x00000002204f7810ULL, 0x000fc40007ffe0ffULL,
0x000000284600720cULL, 0x000fda0003f06070ULL, 0x0000a50000000947ULL, 0x000fea0003800000ULL,
0x0000000000467805ULL, 0x000fc40000015200ULL, 0x0106bc00ff247984ULL, 0x000e640000000800ULL,
0x8000000024ff7812ULL, 0x002fe4000780484aULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4b7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104b00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000487805ULL, 0x000fcc0000015200ULL,
0x0000004846487210ULL, 0x000fca0007f1e1ffULL, 0x0000000149497824ULL, 0x000fe200000e0e47ULL,
0x003d09004800780cULL, 0x000fc80003f06070ULL, 0x000000ff4900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404800780cULL, 0x000fc80003f06070ULL,
0x000000ff4900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff247819ULL, 0x000fc80000011449ULL, 0x0000004824247211ULL, 0x000fca00078110ffULL,
0x000000ffff487224ULL, 0x000fca00000e0649ULL, 0x0000000224247819ULL, 0x000fc80000001248ULL,
0x000000240000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000014b4b7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106bc00ff247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fe4000780484aULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000046000009947ULL, 0x000fea0003800000ULL,
0x000000603c247810ULL, 0x000fe20007ffe0ffULL, 0x0000000125477824ULL, 0x000fe200078e0217ULL,
0x0000000417527810ULL, 0x000fe40007ffe0ffULL, 0x0000002428467217ULL, 0x000fe20007800000ULL,
0x0000000147487824ULL, 0x000fe200078e022aULL, 0x0000000217497810ULL, 0x000fe20007ffe0ffULL,
0x0000001047507824ULL, 0x000fe200078e00ffULL, 0x0000000617547810ULL, 0x000fe20007ffe0ffULL,
0x0000000146467824ULL, 0x000fe200078e0a24ULL, 0x0000002029247811ULL, 0x000fe200078e30ffULL,
0x00000001254b7824ULL, 0x040fe200078e0252ULL, 0xfffffff050507812ULL, 0x000fe200078ee248ULL,
0x00000001254a7824ULL, 0x040fe200078e0249ULL, 0x0000004625467217ULL, 0x000fe20007800000ULL,
0x00000001474e7824ULL, 0x000fe200078e0224ULL, 0x000000f01f4f7812ULL, 0x000fe200078ec0ffULL,
0x000000014b4c7824ULL, 0x040fe200078e022aULL, 0x0000e00050507811ULL, 0x000fe200078e20ffULL,
0x000000104b537824ULL, 0x000fe200078e00ffULL, 0x000000454e4e7210ULL, 0x000fe20007f1e0ffULL,
0x000000014a4d7824ULL, 0x000fc400078e0224ULL, 0x000000014a487824ULL, 0x040fe200078e022aULL,
0xfffffff053537812ULL, 0x000fe200078ee24cULL, 0x000000104a517824ULL, 0x000fe200078e00ffULL,
0x000000454d4d7210ULL, 0x080fe20007f9e0ffULL, 0x0000000125477824ULL, 0x000fe200078e0254ULL,
0x0000e00053537811ULL, 0x000fe200078e20ffULL, 0x000000014b4b7824ULL, 0x000fe200078e0224ULL,
0xfffffff051517812ULL, 0x000fe200078ee248ULL, 0x00000001474a7824ULL, 0x040fe400078e0224ULL,
0x00000001474c7824ULL, 0x000fe200078e022aULL, 0x000000454b4b7210ULL, 0x080fe20007f7e0ffULL,
0x0000001047557824ULL, 0x000fe200078e00ffULL, 0x000000454a457210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff477224ULL, 0x000fe200000e06ffULL, 0x00005e004e487a11ULL, 0x000fe200078040ffULL,
0x0000000146247824ULL, 0x000fe200078e0a25ULL, 0xfffffff055557812ULL, 0x000fe200078ee24cULL,
0x000000ffff467224ULL, 0x000fe200020e06ffULL, 0x00005f004e4e7a11ULL, 0x000fe200000f4447ULL,
0x000000ffff477224ULL, 0x000fe200018e06ffULL, 0x00005e004d4c7a11ULL, 0x000fc400078c40ffULL,
0x000000244900720cULL, 0x080fe40003f06070ULL, 0x00005e004b497a11ULL, 0x000fe400078a40ffULL,
0x000000241700720cULL, 0x000fe40003f86070ULL, 0x00005f004d4d7a11ULL, 0x000fe400030f4446ULL,
0x0000004f48467210ULL, 0x000fe20007fde0ffULL, 0x000000ffff487224ULL, 0x000fe200010e06ffULL,
0x00005f004b4b7a11ULL, 0x000fc400028f4447ULL, 0x00005e00454a7a11ULL, 0x040fe200078a40ffULL,
0x000000ffff477224ULL, 0x000fe200030e064eULL, 0x000000245200720cULL, 0x080fe40003f66070ULL,
0x000000245400720cULL, 0x000fe40003f46070ULL, 0x00005f0045247a11ULL, 0x000fe200028f4448ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000046507faeULL, 0x0003e2000e101c46ULL,
0x0000004f4c487210ULL, 0x000fe40007fbe0ffULL, 0x0000e00051517811ULL, 0x000fc400078e20ffULL,
0x0000e00055557811ULL, 0x000fe400078e20ffULL, 0x0000004f49467210ULL, 0x082fe20007f9e0ffULL,
0x000000ffff497224ULL, 0x000fe200028e064dULL, 0x0000004f4a4a7210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff477224ULL, 0x000fe200020e064bULL, 0x0000000048517faeULL, 0x0003e2000c101c46ULL,
0x000000ffff4b7224ULL, 0x000fc600028e0624ULL, 0x0000000046537faeULL, 0x0003e8000d901c46ULL,
0x000000004a557faeULL, 0x0003e2000d101c46ULL, 0x0000039000007947ULL, 0x000fea0003800000ULL,
0x0000000125247824ULL, 0x000fe200078e0217ULL, 0x0000002029467811ULL, 0x000fe400078e30ffULL,
0x000000f01f4f7812ULL, 0x000fe200078ec0ffULL, 0x0000000124477824ULL, 0x040fe200078e022aULL,
0x0000000224487810ULL, 0x040fe20007ffe0ffULL, 0x0000001024507824ULL, 0x040fe200078e00ffULL,
0x00000006244a7810ULL, 0x000fc60007ffe0ffULL, 0x0000000148497824ULL, 0x000fe200078e022aULL,
0xfffffff050507812ULL, 0x000fe200078ee247ULL, 0x0000001048517824ULL, 0x000fe400078e00ffULL,
0x0000000124477824ULL, 0x000fe200078e0246ULL, 0x0000e00050507811ULL, 0x000fe200078e20ffULL,
0x00000001464b7824ULL, 0x040fe200078e0248ULL, 0xfffffff051517812ULL, 0x000fe200078ee249ULL,
0x00000001464d7824ULL, 0x000fe200078e024aULL, 0x0000000424497810ULL, 0x000fe20007ffe0ffULL,
0x000000014a4e7824ULL, 0x140fe200078e022aULL, 0x0000004547477210ULL, 0x080fe20007f7e0ffULL,
0x000000104a537824ULL, 0x000fe200078e00ffULL, 0x000000454b4b7210ULL, 0x080fe20007f1e0ffULL,
0x0000000146247824ULL, 0x000fe200078e0249ULL, 0x00005e00474c7a11ULL, 0x000fe200078840ffULL,
0x0000000149487824ULL, 0x000fe200078e022aULL, 0xfffffff053537812ULL, 0x000fe200078ee24eULL,
0x0000001049527824ULL, 0x000fe200078e00ffULL, 0x0000004524497210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff467224ULL, 0x000fe200018e06ffULL, 0x000000454d247210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff4d7224ULL, 0x000fe200000e06ffULL, 0xfffffff052527812ULL, 0x000fc400078ee248ULL,
0x00005f00474e7a11ULL, 0x000fe200020f4446ULL, 0x000000ffff467224ULL, 0x000fe200010e06ffULL,
0x00005e004b477a11ULL, 0x000fe200078040ffULL, 0x000000ffff457224ULL, 0x000fe200018e06ffULL,
0x00005e0049487a11ULL, 0x000fe400078440ffULL, 0x00005e00244a7a11ULL, 0x000fe400078640ffULL,
0x0000004f4c4c7210ULL, 0x000fe40007f9e0ffULL, 0x00005f004b4b7a11ULL, 0x000fc400000f444dULL,
0x00005f0049497a11ULL, 0x000fe200010f4446ULL, 0x000000ffff4d7224ULL, 0x000fe200020e064eULL,
0x0000004f47467210ULL, 0x080fe40007f1e0ffULL, 0x00005f0024247a11ULL, 0x000fe400018f4445ULL,
0x0000004f48487210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff477224ULL, 0x000fe200000e064bULL,
0x0000004f4a4a7210ULL, 0x000fe20007f7e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000004c507faeULL, 0x0003e2000b901c46ULL, 0x0000e00051517811ULL, 0x000fe200078e20ffULL,
0x000000ffff497224ULL, 0x000fe200010e0649ULL, 0x0000e00052527811ULL, 0x000fe200078e20ffULL,
0x000000ffff4b7224ULL, 0x000fe200018e0624ULL, 0x0000e00053537811ULL, 0x000fe200078e20ffULL,
0x0000000046517faeULL, 0x0003e8000b901c46ULL, 0x0000000048527faeULL, 0x0003e8000b901c46ULL,
0x000000004a537faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000320467810ULL, 0x002fc80007ffe0ffULL, 0x000000274600720cULL, 0x000fe20003f06070ULL,
0xffffffffff247424ULL, 0x000fd800078e00ffULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x0000000122467824ULL, 0x000fe400078e0246ULL, 0x00000004ff477424ULL, 0x000fc800078e00ffULL,
0x0000600046467625ULL, 0x000fca00078e0047ULL, 0x0000000646247981ULL, 0x000324000c1e1900ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b000ff547f8cULL, 0x000ea2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01064800254a7f8cULL, 0x000664000c80043fULL,
0x0000000000467805ULL, 0x002fc40000015200ULL, 0x01064c0025457984ULL, 0x000e640000000800ULL,
0x8000000045ff7812ULL, 0x002fe4000780484bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000487805ULL, 0x000fcc0000015200ULL,
0x0000004846487210ULL, 0x000fca0007f1e1ffULL, 0x0000000149497824ULL, 0x000fe200000e0e47ULL,
0x003d09004800780cULL, 0x000fc80003f06070ULL, 0x000000ff4900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404800780cULL, 0x000fc80003f06070ULL,
0x000000ff4900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff457819ULL, 0x000fc80000011449ULL, 0x0000004845457211ULL, 0x000fca00078110ffULL,
0x000000ffff487224ULL, 0x000fca00000e0649ULL, 0x0000000245457819ULL, 0x000fc80000001248ULL,
0x000000450000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000014c4c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01064c0025457984ULL, 0x000e640000000800ULL, 0x8000000045ff7812ULL, 0x002fe4000780484bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x010100001e457984ULL, 0x000e680000000800ULL,
0x010300001e487984ULL, 0x0006a20000000800ULL, 0x000000444500720bULL, 0x002fe20003f1d000ULL,
0x000103e27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000497806ULL, 0x008fc800000e0100ULL,
0x0000ffff49ff7812ULL, 0x000fe2000780c0ffULL, 0x000004a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff4a7424ULL, 0x000fc400078e00ffULL, 0x000000ffff567224ULL, 0x000fd200078e0044ULL,
0x0000046000008947ULL, 0x000fea0003800000ULL, 0x000000022b00780cULL, 0x000fe40003f05270ULL,
0x000000444500720bULL, 0x000fe20003f54000ULL, 0x000103a27f007947ULL, 0x000fd8000b800000ULL,
0x00000000004a7806ULL, 0x000fc400010e0100ULL, 0x0000004544468209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe80003800000ULL, 0x010500461e008388ULL, 0x0003e40000000800ULL,
0x000099104a467816ULL, 0x002fc800000000ffULL, 0x000000ff4600720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000004544467209ULL, 0x000fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff4aff7812ULL, 0x000fc6000780c0ffULL,
0x8000004644467221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b46467820ULL, 0x000fc80000410000ULL,
0x00000046004b7308ULL, 0x000e640000000800ULL, 0x0000004b23237220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff467819ULL, 0x000fe2000001162aULL,
0x000102d27f007947ULL, 0x000fea000b800000ULL, 0x00001f464b467589ULL, 0x0002e400000e0000ULL,
0x0000004638387220ULL, 0x088fe20000410000ULL, 0x0000004639397220ULL, 0x080fe20000410000ULL,
0x0000004634347220ULL, 0x080fe20000410000ULL, 0x0000004635357220ULL, 0x080fe20000410000ULL,
0x0000004630307220ULL, 0x080fe20000410000ULL, 0x0000004631317220ULL, 0x080fe20000410000ULL,
0x000000462c2c7220ULL, 0x080fe20000410000ULL, 0x000000462d2d7220ULL, 0x080fe20000410000ULL,
0x0000004604047220ULL, 0x080fe20000410000ULL, 0x0000004605057220ULL, 0x080fe20000410000ULL,
0x000000460c0c7220ULL, 0x080fe20000410000ULL, 0x000000460d0d7220ULL, 0x080fe20000410000ULL,
0x0000004608087220ULL, 0x080fe20000410000ULL, 0x0000004609097220ULL, 0x080fe20000410000ULL,
0x0000004610107220ULL, 0x080fe20000410000ULL, 0x0000004611117220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff004aff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000082a467811ULL, 0x000fe200078ff0ffULL,
0x000101d27f007947ULL, 0x000fea000b800000ULL, 0x00001f464b467589ULL, 0x00066400000e0000ULL,
0x000000463a3a7220ULL, 0x082fe20000410000ULL, 0x000000463b3b7220ULL, 0x080fe20000410000ULL,
0x0000004636367220ULL, 0x080fe20000410000ULL, 0x0000004637377220ULL, 0x080fe20000410000ULL,
0x0000004632327220ULL, 0x080fe20000410000ULL, 0x0000004633337220ULL, 0x080fe20000410000ULL,
0x000000462e2e7220ULL, 0x080fe20000410000ULL, 0x000000462f2f7220ULL, 0x080fe20000410000ULL,
0x0000004606067220ULL, 0x080fe20000410000ULL, 0x0000004607077220ULL, 0x080fe20000410000ULL,
0x000000460e0e7220ULL, 0x080fe20000410000ULL, 0x000000460f0f7220ULL, 0x080fe20000410000ULL,
0x000000460a0a7220ULL, 0x080fe20000410000ULL, 0x000000460b0b7220ULL, 0x080fe20000410000ULL,
0x0000004612127220ULL, 0x080fe20000410000ULL, 0x0000004613137220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000ffff4aff7812ULL, 0x000fe20007800849ULL,
0x00000001ff4a7424ULL, 0x000fe200078e00ffULL, 0x0000004544447209ULL, 0x000fca0007810000ULL,
0x000000ffff567224ULL, 0x000fcc00078e0044ULL, 0x8000004445450221ULL, 0x100fe20000010000ULL,
0x000000ffff560224ULL, 0x000fe200078e0044ULL, 0x00007610ff4a0816ULL, 0x000fe4000000004aULL,
0x3fb8aa3b45450820ULL, 0x000fc80000410000ULL, 0x00000045001a0308ULL, 0x000e640000000800ULL,
0x0000001a48480220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002348237221ULL, 0x004fc20000010000ULL, 0x0000000000447805ULL, 0x000fcc0000015200ULL,
0x0106ac00ff467984ULL, 0x000e640000000800ULL, 0x8000000046ff7812ULL, 0x002fe40007804843ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff497224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000467805ULL, 0x000fcc0000015200ULL, 0x0000004644487210ULL, 0x000fca0007f1e1ffULL,
0x0000000147477824ULL, 0x000fe200000e0e45ULL, 0x003d09004800780cULL, 0x000fc80003f06070ULL,
0x000000ff4700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404800780cULL, 0x000fc80003f06070ULL, 0x000000ff4700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff467819ULL, 0x000fc80000011447ULL,
0x0000004846467211ULL, 0x000fca00078110ffULL, 0x000000ffff477224ULL, 0x000fca00000e0647ULL,
0x0000000246467819ULL, 0x000fc80000001247ULL, 0x000000460000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000149497810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106ac00ff467984ULL, 0x000e640000000800ULL,
0x8000000046ff7812ULL, 0x002fe40007804843ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099104a437816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff4300720cULL, 0x000fda0003f45270ULL, 0x0000012000002947ULL, 0x000fea0003800000ULL,
0x0000001aff18723eULL, 0x000fe400000010ffULL, 0x00000002ff447819ULL, 0x000fe4000001162aULL,
0x0000541018437816ULL, 0x000fe20000000018ULL, 0x0000fda27f007947ULL, 0x000fea000b800000ULL,
0x00001f4443197589ULL, 0x0002a400000e0000ULL, 0x0000000844187810ULL, 0x000fe20007ffe0ffULL,
0x0000fdd27f007947ULL, 0x000fea000b800000ULL, 0x00001f1843187589ULL, 0x0002e400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001044477810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff5a7224ULL, 0x000fe200078e0043ULL, 0x0000d0d000467802ULL, 0x000fc40000000f00ULL,
0x0001063000007944ULL, 0x01efea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001844477810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff5a7224ULL, 0x004fe200078e0043ULL,
0x0000d12000467802ULL, 0x000fc40000000f00ULL, 0x000105e000007944ULL, 0x01afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000001650783bULL, 0x000e680000004200ULL, 0x00000000154c783bULL, 0x000ee80000004200ULL,
0x000000000244783bULL, 0x002e680000004200ULL, 0x000000001448783bULL, 0x008ee20000004200ULL,
0x00000010ff7a7819ULL, 0x000fc40000011651ULL, 0x000000ff515d7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff5c7819ULL, 0x000fe40000011651ULL, 0x0000ffff518e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff847819ULL, 0x100fe4000001164dULL, 0x000000ff4d647812ULL, 0x000fe400078ec0ffULL,
0x00000018ff637819ULL, 0x000fc4000001164dULL, 0x0000ffff4d927812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5e7819ULL, 0x100fe40000011650ULL, 0x000000ff50437812ULL, 0x040fe400078ec0ffULL,
0x00000018ff5a7819ULL, 0x004fe40000011650ULL, 0x0000ffff508d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4d7819ULL, 0x002fc40000011644ULL, 0x000000ff44897812ULL, 0x040fe400078ec0ffULL,
0x00000018ff867819ULL, 0x000fe40000011644ULL, 0x0000ffff44517812ULL, 0x000fe400078ec0ffULL,
0x000000ff52607812ULL, 0x000fe400078ec0ffULL, 0x000000ff4f687812ULL, 0x000fe400078ec0ffULL,
0x00000010ff507819ULL, 0x000fc40000011645ULL, 0x000000ff458a7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff447819ULL, 0x000fe40000011645ULL, 0x0000ffff45597812ULL, 0x000fe400078ec0ffULL,
0x00000018ff457819ULL, 0x000fe40000011646ULL, 0x0000005aff5a723eULL, 0x000fe400020006ffULL,
0x00000060ff60723eULL, 0x000fc400020006ffULL, 0x00000068ff68723eULL, 0x000fe200020006ffULL,
0x2000005aff747230ULL, 0x000fe20000004100ULL, 0x00000044ff44723eULL, 0x000fe200020006ffULL,
0x20000060ff717230ULL, 0x000fe20000004100ULL, 0x00000045ff45723eULL, 0x000fe200020006ffULL,
0x20000068ff6b7230ULL, 0x000fe20000004100ULL, 0x00000018ff7b7819ULL, 0x008fe20000011649ULL,
0x20000044ff607230ULL, 0x000fe20000004100ULL, 0x00000010ff5b7819ULL, 0x000fe20000011646ULL,
0x20000045ff5a7230ULL, 0x000fe20000004100ULL, 0x000000ff468b7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff46587812ULL, 0x000fe400078ec0ffULL, 0x00000010ff7e7819ULL, 0x100fe40000011652ULL,
0x00000018ff5f7819ULL, 0x000fe40000011652ULL, 0x0000ffff528f7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff467819ULL, 0x000fe40000011647ULL, 0x000000ff5e5e7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff7f7819ULL, 0x100fe40000011653ULL, 0x000000ff53617812ULL, 0x040fe400078ec0ffULL,
0x00000018ff527819ULL, 0x000fe40000011653ULL, 0x0000ffff53907812ULL, 0x000fe400078ec0ffULL,
0x000000ff7a7a7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff537819ULL, 0x000fc4000001164cULL,
0x00000018ff677819ULL, 0x000fe4000001164fULL, 0x00000043ff76723eULL, 0x000fe400020006ffULL,
0x0000007bff68723eULL, 0x000fe400020006ffULL, 0x00000018ff697819ULL, 0x000fe20000011648ULL,
0x20000076ff767230ULL, 0x000fe20000004100ULL, 0x00000010ff577819ULL, 0x000fe20000011647ULL,
0x20000068ff687230ULL, 0x000fe20000004100ULL, 0x000000ff478c7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff47437812ULL, 0x000fe400078ec0ffULL, 0x00000008ff457819ULL, 0x000fe4000001168dULL,
0x00000046ff7b723eULL, 0x000fe400020006ffULL, 0x0000005eff44723eULL, 0x000fe400020006ffULL,
0x00000010ff877819ULL, 0x000fe2000001164eULL, 0x2000007bff5e7230ULL, 0x000fe20000004100ULL,
0x000000ff4e667812ULL, 0x000fc400078ec0ffULL, 0x00000018ff657819ULL, 0x000fe4000001164eULL,
0x0000ffff4e937812ULL, 0x000fe400078ec0ffULL, 0x000000ff497d7812ULL, 0x000fe400078ec0ffULL,
0x0000007aff46723eULL, 0x000fe200020006ffULL, 0x20000044ff7a7230ULL, 0x000fe20000004100ULL,
0x00000008ff477819ULL, 0x000fe4000001168eULL, 0x00000053ff4e723eULL, 0x000fc400020006ffULL,
0x00000067ff53723eULL, 0x000fe400020006ffULL, 0x00000069ff67723eULL, 0x000fe200020006ffULL,
0x2000004eff4e7230ULL, 0x000fe20000004100ULL, 0x00000045ff45723eULL, 0x000fe200020006ffULL,
0x20000053ff537230ULL, 0x000fe20000004100ULL, 0x0000007dff69723eULL, 0x000fe200020006ffULL,
0x20000046ff7d7230ULL, 0x000fe20000004100ULL, 0x00000047ff47723eULL, 0x000fe200020006ffULL,
0x20000045ff7b7230ULL, 0x000fe20000004100ULL, 0x000000ff7e447812ULL, 0x000fe200078ec0ffULL,
0x20000067ff677230ULL, 0x000fe20000004100ULL, 0x000000ff7f7f7812ULL, 0x000fe200078ec0ffULL,
0x20000047ff7e7230ULL, 0x000fe20000004100ULL, 0x00000008ff467819ULL, 0x000fe2000001168fULL,
0x20000069ff697230ULL, 0x000fe20000004100ULL, 0x00000052ff52723eULL, 0x000fc400020006ffULL,
0x00000044ff45723eULL, 0x000fe400020006ffULL, 0x000000ff4a817812ULL, 0x000fe200078ec0ffULL,
0x20000052ff6e7230ULL, 0x000fe20000004100ULL, 0x00000018ff807819ULL, 0x000fe4000001164aULL,
0x0000007fff47723eULL, 0x000fe200020006ffULL, 0x20000045ff7f7230ULL, 0x000fe20000004100ULL,
0x00000046ff46723eULL, 0x000fe400020006ffULL, 0x0000b00000447811ULL, 0x000fc400078e20ffULL,
0x00000010ff707819ULL, 0x000fe40000011649ULL, 0x0000ffff49737812ULL, 0x000fe400078ec0ffULL,
0x00000064ff49723eULL, 0x000fe400020006ffULL, 0x00000065ff52723eULL, 0x000fe400020006ffULL,
0x00000081ff65723eULL, 0x000fe200020006ffULL, 0x20000047ff817230ULL, 0x000fe20000004100ULL,
0x00000080ff64723eULL, 0x000fe200020006ffULL, 0x20000046ff807230ULL, 0x000fe20000004100ULL,
0x00000010ff777819ULL, 0x000fe20000011648ULL, 0x000000004444783bULL, 0x000e620000000200ULL,
0x00000018ff827819ULL, 0x000fe2000001164bULL, 0x20000049ff497230ULL, 0x000fe20000004100ULL,
0x00000010ff887819ULL, 0x000fe2000001164fULL, 0x20000052ff527230ULL, 0x000fe20000004100ULL,
0x0000ffff4f797812ULL, 0x000fe200078ec0ffULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x00000063ff4f723eULL, 0x000fe200020006ffULL, 0x20000064ff647230ULL, 0x000fe20000004100ULL,
0x0000ffff48787812ULL, 0x000fc400078ec0ffULL, 0x0000005dff5d723eULL, 0x000fe200020006ffULL,
0x2000004fff4f7230ULL, 0x000fe20000004100ULL, 0x00000061ff61723eULL, 0x000fe400020006ffULL,
0x00000066ff66723eULL, 0x000fe200020006ffULL, 0x2000005dff7c7230ULL, 0x000fe20000004100ULL,
0x00000082ff63723eULL, 0x000fe200020006ffULL, 0x20000061ff727230ULL, 0x000fe20000004100ULL,
0x000000ff77777812ULL, 0x000fe200078ec0ffULL, 0x20000066ff6c7230ULL, 0x000fe20000004100ULL,
0x00000008ff737819ULL, 0x000fe20000011673ULL, 0x20000063ff637230ULL, 0x000fe20000004100ULL,
0x00000008ff827819ULL, 0x000fc40000011690ULL, 0x000000ff4c627812ULL, 0x040fe400078ec0ffULL,
0x000000ff4b857812ULL, 0x000fe400078ec0ffULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x00000010ff837819ULL, 0x000fe4000001164cULL, 0x0000ffff4c917812ULL, 0x000fe200078ec0ffULL,
0x2000005cff757230ULL, 0x000fe20000004100ULL, 0x000000ff486a7812ULL, 0x000fc400078ec0ffULL,
0x00000008ff787819ULL, 0x000fe40000011678ULL, 0x00000077ff77723eULL, 0x000fe200020006ffULL,
0x000000194444a231ULL, 0x082fe200003400ffULL, 0x00000010ff767819ULL, 0x000fe20000011676ULL,
0x000000194646a231ULL, 0x000fe200003400ffULL, 0x00000010ff7a7819ULL, 0x000fe2000001167aULL,
0x000000184545a231ULL, 0x080fe200003400ffULL, 0x00000073ff73723eULL, 0x000fe200020006ffULL,
0x000000184747a231ULL, 0x000fe200003400ffULL, 0x00000010ff487819ULL, 0x000fc4000001164bULL,
0x0000ffff4b4c7812ULL, 0x000fe400078ec0ffULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x00000082ff82723eULL, 0x000fe400020006ffULL, 0x00000062ff4b723eULL, 0x000fe200020006ffULL,
0x2000005fff6d7230ULL, 0x000fe20000004100ULL, 0x00000085ff66723eULL, 0x000fe200020006ffULL,
0x20000082ff827230ULL, 0x000fe20000004100ULL, 0x00000010ff6f7819ULL, 0x000fe2000001164aULL,
0x2000004bff4b7230ULL, 0x000fe20000004100ULL, 0x0000008aff62723eULL, 0x000fe200020006ffULL,
0x20000066ff667230ULL, 0x000fe20000004100ULL, 0x000000ff83837812ULL, 0x000fc400078ec0ffULL,
0x000000ff84857812ULL, 0x000fe200078ec0ffULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x00000078ff8a723eULL, 0x000fe200020006ffULL, 0x20000077ff787230ULL, 0x000fe20000004100ULL,
0x000010547a767816ULL, 0x000fe20000000076ULL, 0x20000073ff7a7230ULL, 0x000fe20000004100ULL,
0x00000010ff777819ULL, 0x000fe4000001167cULL, 0x00000010ff737819ULL, 0x000fe40000011672ULL,
0x00000010ff817819ULL, 0x000fc40000011681ULL, 0x00000083ff83723eULL, 0x000fe400020006ffULL,
0x00000085ff85723eULL, 0x000fe400020006ffULL, 0x000000ff6f7c7812ULL, 0x000fe200078ec0ffULL,
0x20000083ff837230ULL, 0x000fe20000004100ULL, 0x0000ffff4a4a7812ULL, 0x000fe200078ec0ffULL,
0x20000085ff857230ULL, 0x000fe20000004100ULL, 0x00000010ff6f7819ULL, 0x000fe40000011675ULL,
0x00000010ff747819ULL, 0x000fc40000011674ULL, 0x00000010ff7b7819ULL, 0x000fe4000001167bULL,
0x00000010ff757819ULL, 0x000fe4000001167eULL, 0x0000105481737816ULL, 0x000fe40000000073ULL,
0x00000010ff6d7819ULL, 0x000fe4000001166dULL, 0x00000010ff6e7819ULL, 0x000fe4000001166eULL,
0x00000010ff807819ULL, 0x000fc40000011680ULL, 0x00000010ff817819ULL, 0x000fe40000011682ULL,
0x000000ff48487812ULL, 0x000fe400078ec0ffULL, 0x00000008ff4a7819ULL, 0x000fe4000001164aULL,
0x0000105474747816ULL, 0x000fe4000000007bULL, 0x000010546f757816ULL, 0x000fe40000000075ULL,
0x000010546d807816ULL, 0x000fc40000000080ULL, 0x000010546e817816ULL, 0x000fe40000000081ULL,
0x00000010ff717819ULL, 0x000fe20000011671ULL, 0x000000744434723cULL, 0x000b620000041834ULL,
0x00000010ff7f7819ULL, 0x000fe4000001167fULL, 0x00000048ff48723eULL, 0x000fe400020006ffULL,
0x0000004aff4a723eULL, 0x000fe400020006ffULL, 0x00000010ff4b7819ULL, 0x000fe2000001164bULL,
0x20000048ff747230ULL, 0x020fe20000004100ULL, 0x00000010ff497819ULL, 0x000fc40000011649ULL,
0x00000010ff837819ULL, 0x000fe40000011683ULL, 0x00000010ff6f7819ULL, 0x000fe40000011685ULL,
0x0000b000036d7811ULL, 0x000fe400078e20ffULL, 0x000010547f727816ULL, 0x000fe20000000071ULL,
0x2000004aff717230ULL, 0x000fe20000004100ULL, 0x00001054836e7816ULL, 0x000fe4000000004bULL,
0x000010546f6f7816ULL, 0x000fc40000000049ULL, 0x000000804448723cULL, 0x040be2000004182cULL,
0x00000086ff5f723eULL, 0x000fe200020006ffULL, 0x000000006d2c783bULL, 0x020e620000000200ULL,
0x00000008ff847819ULL, 0x000fe40000011691ULL, 0x00000008ff867819ULL, 0x000fe20000011692ULL,
0x2000005fff5f7230ULL, 0x000fe20000004100ULL, 0x00000089ff61723eULL, 0x000fe200020006ffULL,
0x000000724430723cULL, 0x000be20000041830ULL, 0x000000ff87877812ULL, 0x000fe400078ec0ffULL,
0x000000ff88897812ULL, 0x000fe200078ec0ffULL, 0x20000061ff617230ULL, 0x000fe20000004100ULL,
0x00000084ff84723eULL, 0x000fc400020006ffULL, 0x00000086ff86723eULL, 0x000fe400020006ffULL,
0x00000087ff87723eULL, 0x000fe200020006ffULL, 0x20000084ff847230ULL, 0x000fe20000004100ULL,
0x00000089ff89723eULL, 0x000fe200020006ffULL, 0x20000086ff867230ULL, 0x000fe20000004100ULL,
0x00000008ff887819ULL, 0x000fe20000011693ULL, 0x20000087ff877230ULL, 0x000fe20000004100ULL,
0x00000008ff797819ULL, 0x000fe20000011679ULL, 0x20000089ff897230ULL, 0x000fe20000004100ULL,
0x00000088ff88723eULL, 0x000fc400020006ffULL, 0x00000079ff79723eULL, 0x000fe400020006ffULL,
0x00000008ff4c7819ULL, 0x000fe2000001164cULL, 0x20000088ff887230ULL, 0x000fe20000004100ULL,
0x000000ff4d4d7812ULL, 0x000fe200078ec0ffULL, 0x20000079ff797230ULL, 0x000fe20000004100ULL,
0x00000010ff4e7819ULL, 0x000fe4000001164eULL, 0x00000010ff4f7819ULL, 0x000fe4000001164fULL,
0x00000010ff847819ULL, 0x000fc40000011684ULL, 0x00000010ff857819ULL, 0x000fe40000011686ULL,
0x00000010ff6c7819ULL, 0x000fe2000001166cULL, 0x000000192c2ca231ULL, 0x082fe200003400ffULL,
0x00000010ff6b7819ULL, 0x000fe2000001166bULL, 0x000000192e2ea231ULL, 0x000fe200003400ffULL,
0x00000010ff877819ULL, 0x000fe20000011687ULL, 0x000000182d2da231ULL, 0x080fe200003400ffULL,
0x00000010ff6d7819ULL, 0x000fe20000011689ULL, 0x000000182f2fa231ULL, 0x000fe200003400ffULL,
0x000000ff50507812ULL, 0x000fc400078ec0ffULL, 0x0000004cff72723eULL, 0x020fe400020006ffULL,
0x0000004dff73723eULL, 0x000fe400020006ffULL, 0x000010544e847816ULL, 0x000fe20000000084ULL,
0x20000072ff727230ULL, 0x000fe20000004100ULL, 0x000010544f857816ULL, 0x000fe20000000085ULL,
0x20000073ff737230ULL, 0x000fe20000004100ULL, 0x0000008bff5d723eULL, 0x000fe200020006ffULL,
0x0000006e444c723cULL, 0x000b620000041804ULL, 0x000000ff708b7812ULL, 0x000fe200078ec0ffULL,
0x2000008aff707230ULL, 0x000fe20000004100ULL, 0x00001054876c7816ULL, 0x000fe2000000006cULL,
0x2000005dff5d7230ULL, 0x000fe20000004100ULL, 0x000010546d6d7816ULL, 0x000fc4000000006bULL,
0x00000008ff517819ULL, 0x000fe20000011651ULL, 0x00000084440c723cULL, 0x000fe2000004180cULL,
0x00000050ff05723eULL, 0x020fe400020006ffULL, 0x00000010ff527819ULL, 0x000fe40000011652ULL,
0x00000010ff537819ULL, 0x000fe20000011653ULL, 0x20000005ff6b7230ULL, 0x000fe20000004100ULL,
0x00000010ff887819ULL, 0x000fe40000011688ULL, 0x00000010ff797819ULL, 0x000fc40000011679ULL,
0x00000051ff04723eULL, 0x000fe400020006ffULL, 0x00000010ff7d7819ULL, 0x000fe4000001167dULL,
0x0000105452887816ULL, 0x000fe40000000088ULL, 0x0000105453897816ULL, 0x000fe40000000079ULL,
0x00000010ff677819ULL, 0x000fe20000011667ULL, 0x0000006c4450723cULL, 0x000be20000041808ULL,
0x00000010ff687819ULL, 0x000fc40000011668ULL, 0x00000010ff707819ULL, 0x000fe40000011670ULL,
0x00000010ff057819ULL, 0x000fe4000001167aULL, 0x00000010ff097819ULL, 0x020fe20000011669ULL,
0x20000004ff697230ULL, 0x000fe20000004100ULL, 0x000010547d777816ULL, 0x000fe20000000077ULL,
0x000000884410723cULL, 0x000fe20000041810ULL, 0x0000105467047816ULL, 0x000fe40000000070ULL,
0x0000105468057816ULL, 0x000fc40000000005ULL, 0x0000007cff7c723eULL, 0x000fe400020006ffULL,
0x00000008ff597819ULL, 0x000fe20000011659ULL, 0x000000764438723cULL, 0x000f620000041838ULL,
0x000000ff5b5b7812ULL, 0x000fe200078ec0ffULL, 0x2000007cff7c7230ULL, 0x000fe20000004100ULL,
0x000000ff57577812ULL, 0x000fe400078ec0ffULL, 0x00000008ff587819ULL, 0x000fe40000011658ULL,
0x00000008ff437819ULL, 0x000fe20000011643ULL, 0x000000042c04723cULL, 0x000b620000041834ULL,
0x00000010ff617819ULL, 0x000fc40000011661ULL, 0x00000010ff737819ULL, 0x000fe40000011673ULL,
0x00000010ff6b7819ULL, 0x000fe4000001166bULL, 0x00000010ff357819ULL, 0x020fe40000011662ULL,
0x00000059ff59723eULL, 0x000fe400020006ffULL, 0x0000006aff6a723eULL, 0x000fe400020006ffULL,
0x0000008cff5c723eULL, 0x000fe200020006ffULL, 0x20000059ff597230ULL, 0x000fe20000004100ULL,
0x0000008bff8b723eULL, 0x000fe200020006ffULL, 0x2000006aff6a7230ULL, 0x000fe20000004100ULL,
0x0000005bff5b723eULL, 0x000fe200020006ffULL, 0x2000005cff5c7230ULL, 0x000fe20000004100ULL,
0x00000057ff57723eULL, 0x000fe200020006ffULL, 0x2000008bff8b7230ULL, 0x000fe20000004100ULL,
0x00000058ff58723eULL, 0x000fe200020006ffULL, 0x2000005bff5b7230ULL, 0x000fe20000004100ULL,
0x00000043ff43723eULL, 0x000fe200020006ffULL, 0x20000057ff577230ULL, 0x000fe20000004100ULL,
0x0000105473347816ULL, 0x000fe20000000061ULL, 0x20000058ff587230ULL, 0x000fe20000004100ULL,
0x000010546b357816ULL, 0x000fe20000000035ULL, 0x20000043ff437230ULL, 0x000fe20000004100ULL,
0x00000010ff657819ULL, 0x000fc40000011665ULL, 0x00000010ff7c7819ULL, 0x000fe4000001167cULL,
0x00000010ff377819ULL, 0x000fe20000011659ULL, 0x000000342c4c723cULL, 0x000b62000004184cULL,
0x000010547c7c7816ULL, 0x000fe40000000065ULL, 0x00000010ff6a7819ULL, 0x000fe4000001166aULL,
0x00000010ff787819ULL, 0x000fe40000011678ULL, 0x00000010ff8b7819ULL, 0x000fc4000001168bULL,
0x00000010ff667819ULL, 0x000fe40000011666ULL, 0x00000010ff747819ULL, 0x000fe40000011674ULL,
0x00000010ff647819ULL, 0x000fe40000011664ULL, 0x00000010ff637819ULL, 0x000fe40000011663ULL,
0x00000010ff717819ULL, 0x000fe40000011671ULL, 0x00000010ff657819ULL, 0x000fc40000011672ULL,
0x00000010ff5f7819ULL, 0x000fe4000001165fULL, 0x00000010ff697819ULL, 0x000fe40000011669ULL,
0x00000010ff607819ULL, 0x000fe40000011660ULL, 0x00000010ff5d7819ULL, 0x000fe4000001165dULL,
0x00000010ff5b7819ULL, 0x000fe4000001165bULL, 0x00000010ff357819ULL, 0x020fc4000001165cULL,
0x00000010ff577819ULL, 0x000fe40000011657ULL, 0x00000010ff5a7819ULL, 0x000fe4000001165aULL,
0x00000010ff587819ULL, 0x000fe40000011658ULL, 0x00000010ff597819ULL, 0x000fe4000001165eULL,
0x00000010ff437819ULL, 0x000fe40000011643ULL, 0x0000105478087816ULL, 0x000fc4000000006aULL,
0x000010548b097816ULL, 0x000fe40000000009ULL, 0x00001054747d7816ULL, 0x000fe40000000066ULL,
0x0000105464647816ULL, 0x000fe40000000071ULL, 0x0000105463657816ULL, 0x000fe20000000065ULL,
0x000000082c08723cULL, 0x000b620000041838ULL, 0x000010545f367816ULL, 0x000fe40000000069ULL,
0x0000105460377816ULL, 0x000fc40000000037ULL, 0x000010545b347816ULL, 0x000fe4000000005dULL,
0x0000105457357816ULL, 0x000fe20000000035ULL, 0x0000007c2c30723cULL, 0x000b620000041830ULL,
0x000010545a587816ULL, 0x000fe40000000058ULL, 0x0000105459597816ULL, 0x000fca0000000043ULL,
0x000000642c48723cULL, 0x040b700000041848ULL, 0x000000362c0c723cULL, 0x040b70000004180cULL,
0x000000342c50723cULL, 0x040b700000041850ULL, 0x000000582c10723cULL, 0x000b620000041810ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff347f8cULL, 0x020e62000c80043fULL,
0x000000ffff377224ULL, 0x000fce00078e00ffULL, 0x00000000002c7805ULL, 0x000fc40000015200ULL,
0x0106bc00ff2e7984ULL, 0x000ea40000000800ULL, 0x800000002eff7812ULL, 0x006fc40007804835ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103700780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002e7805ULL, 0x000fcc0000015200ULL,
0x0000002e2c367210ULL, 0x000fca0007f1e1ffULL, 0x000000012f2f7824ULL, 0x000fe200000e0e2dULL,
0x003d09003600780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403600780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff2e7819ULL, 0x000fc8000001142fULL, 0x000000362e2e7211ULL, 0x000fca00078110ffULL,
0x000000ffff2f7224ULL, 0x000fca00000e062fULL, 0x000000022e2e7819ULL, 0x000fc8000000122fULL,
0x0000002e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000137377810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106bc00ff2e7984ULL, 0x000e640000000800ULL, 0x800000002eff7812ULL, 0x002fe40007804835ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000580024577a24ULL, 0x010fc800078e02ffULL,
0x0000004057577824ULL, 0x000fe200078e00ffULL, 0x0000045000009947ULL, 0x000fea0003800000ULL,
0x000000803c2c7810ULL, 0x000fe20007ffe0ffULL, 0x00000001252e7824ULL, 0x000fe200078e0217ULL,
0x0000000217437810ULL, 0x000fe40007ffe0ffULL, 0x0000002c282d7217ULL, 0x000fe20007800000ULL,
0x0000004029397824ULL, 0x000fe200078e022eULL, 0x0000000417457810ULL, 0x000fe20007ffe0ffULL,
0x000000012e2f7824ULL, 0x040fe200078e022aULL, 0x000000f01f3a7812ULL, 0x000fe200078ec0ffULL,
0x000000102e3b7824ULL, 0x000fe200078e00ffULL, 0x0000005739367210ULL, 0x000fe20007f1e0ffULL,
0x00000001252e7824ULL, 0x000fe200078e0243ULL, 0x0000000239387810ULL, 0x000fe20007ffe0ffULL,
0x000000012d2d7824ULL, 0x000fe200078e0a2cULL, 0xfffffff03b3b7812ULL, 0x000fe200078ee22fULL,
0x00000001252c7824ULL, 0x000fe200078e0245ULL, 0x0000000439377810ULL, 0x000fe20007ffe0ffULL,
0x000000012e2f7824ULL, 0x140fe200078e022aULL, 0x0000002d252d7217ULL, 0x000fe20007800000ULL,
0x000000102e447824ULL, 0x000fe200078e00ffULL, 0x0000005737377210ULL, 0x000fe20007f7e0ffULL,
0x000000012c2e7824ULL, 0x040fe200078e022aULL, 0x0000c0003b3b7811ULL, 0x000fe200078e20ffULL,
0x000000102c467824ULL, 0x000fe200078e00ffULL, 0xfffffff044447812ULL, 0x000fe200078ee22fULL,
0x000000ffff2c7224ULL, 0x000fe200000e06ffULL, 0x00005e0036357a11ULL, 0x000fe200078040ffULL,
0x000000012d2f7824ULL, 0x000fe200078e0a25ULL, 0xfffffff046467812ULL, 0x000fe200078ee22eULL,
0x000000ffff2d7224ULL, 0x000fe200018e06ffULL, 0x00005f0036367a11ULL, 0x000fc400000f442cULL,
0x0000005738387210ULL, 0x000fe40007f1e0ffULL, 0x0000002f1700720cULL, 0x000fe40003f86070ULL,
0x00005e00372e7a11ULL, 0x040fe200078a40ffULL, 0x000000ffff2c7224ULL, 0x000fe200000e06ffULL,
0x00005e0038347a11ULL, 0x040fe400078040ffULL, 0x00005f0037377a11ULL, 0x000fe400028f442dULL,
0x00005f0038387a11ULL, 0x000fc400000f442cULL, 0x0000003a352c7210ULL, 0x000fe40007f7e0ffULL,
0x0000002f4300720cULL, 0x080fe40003f06070ULL, 0x0000000617437810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2d7224ULL, 0x000fe200018e0636ULL, 0x0000000639357810ULL, 0x000fe40007ffe0ffULL,
0x0000002f4500720cULL, 0x000fe20003f66070ULL, 0x0000000125367824ULL, 0x000fe200078e0243ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c3b7faeULL, 0x0003e2000e101c46ULL,
0x0000005735357210ULL, 0x000fc40007f9e0ffULL, 0x0000000136397824ULL, 0x000fe200078e022aULL,
0x0000003a2e2e7210ULL, 0x080fe40007fde0ffULL, 0x0000c00044447811ULL, 0x000fe400078e20ffULL,
0x0000c00046467811ULL, 0x000fe400078e20ffULL, 0x0000003a342c7210ULL, 0x002fe20007fbe0ffULL,
0x00000010363b7824ULL, 0x000fe400078e00ffULL, 0x000000ffff367224ULL, 0x000fe200020e06ffULL,
0x00005e0035347a11ULL, 0x000fe200078840ffULL, 0x000000ffff2d7224ULL, 0x000fe200028e0638ULL,
0x0000002f4300720cULL, 0x000fe20003fa6070ULL, 0x000000ffff2f7224ULL, 0x000fe200030e0637ULL,
0x00005f0035357a11ULL, 0x000fc400020f4436ULL, 0x0000003a34347210ULL, 0x000fe20007f9e0ffULL,
0x000000002c447faeULL, 0x0003e2000c101c46ULL, 0xfffffff03b397812ULL, 0x000fc600078ee239ULL,
0x000000ffff357224ULL, 0x000fe200020e0635ULL, 0x0000c00039397811ULL, 0x000fe200078e20ffULL,
0x000000002e467faeULL, 0x0003e8000d901c46ULL, 0x0000000034397faeULL, 0x0003e2000e901c46ULL,
0x0000038000007947ULL, 0x000fea0003800000ULL, 0x00000001252c7824ULL, 0x000fc800078e0217ULL,
0x000000012c2d7824ULL, 0x040fe200078e022aULL, 0x000000022c2e7810ULL, 0x040fe20007ffe0ffULL,
0x000000102c347824ULL, 0x000fc800078e00ffULL, 0x000000012e2f7824ULL, 0x000fe200078e022aULL,
0xfffffff034347812ULL, 0x000fe200078ee22dULL, 0x000000102e387824ULL, 0x000fe200078e00ffULL,
0x000000042c2e7810ULL, 0x000fe20007ffe0ffULL, 0x00000040292d7824ULL, 0x000fc600078e022cULL,
0xfffffff038387812ULL, 0x000fe200078ee22fULL, 0x000000012e357824ULL, 0x100fe200078e022aULL,
0x000000062c2f7810ULL, 0x000fe20007ffe0ffULL, 0x000000102e437824ULL, 0x000fe200078e00ffULL,
0x000000572d2c7210ULL, 0x000fe40007f1e0ffULL, 0x0000c00038387811ULL, 0x000fe200078e20ffULL,
0x000000012f367824ULL, 0x000fe200078e022aULL, 0xfffffff043437812ULL, 0x000fe200078ee235ULL,
0x000000102f477824ULL, 0x000fe200078e00ffULL, 0x000000022d357810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2e7224ULL, 0x000fe200000e06ffULL, 0x00005e002c2f7a11ULL, 0x000fc400078040ffULL,
0xfffffff047477812ULL, 0x000fe400078ee236ULL, 0x00005f002c2e7a11ULL, 0x000fe400000f442eULL,
0x000000042d2c7810ULL, 0x040fe40007ffe0ffULL, 0x000000062d2d7810ULL, 0x000fe40007ffe0ffULL,
0x0000005735357210ULL, 0x080fe40007f1e0ffULL, 0x000000572c397210ULL, 0x000fc40007f7e0ffULL,
0x000000f01f367812ULL, 0x000fe400078ec0ffULL, 0x000000572d447210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff2d7224ULL, 0x000fe200000e06ffULL, 0x00005e0035377a11ULL, 0x000fe200078040ffULL,
0x000000ffff3a7224ULL, 0x000fe200018e06ffULL, 0x000000362f2c7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff457224ULL, 0x000fe200028e06ffULL, 0x00005e00393b7a11ULL, 0x000fe400078840ffULL,
0x00005e0044467a11ULL, 0x000fc400078a40ffULL, 0x00005f0035357a11ULL, 0x000fe200000f442dULL,
0x000000ffff2d7224ULL, 0x000fe200018e062eULL, 0x0000c000342f7811ULL, 0x000fe400078e20ffULL,
0x00000036372e7210ULL, 0x080fe40007f1e0ffULL, 0x00005f00393a7a11ULL, 0x000fe200020f443aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c2f7faeULL, 0x0003e2000b901c46ULL,
0x000000363b347210ULL, 0x000fe40007f7e0ffULL, 0x00005f0044457a11ULL, 0x000fc400028f4445ULL,
0x0000003646367210ULL, 0x000fe40007f9e0ffULL, 0x0000c00043437811ULL, 0x000fe400078e20ffULL,
0x0000c00047477811ULL, 0x000fe200078e20ffULL, 0x000000ffff377224ULL, 0x000fe400020e0645ULL,
0x000000ffff2f7224ULL, 0x002fe400000e0635ULL, 0x000000ffff357224ULL, 0x000fc600018e063aULL,
0x000000002e387faeULL, 0x0003e8000b901c46ULL, 0x0000000034437faeULL, 0x0003e8000b901c46ULL,
0x0000000036477faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff2c7f8cULL, 0x000e64000c80043fULL,
0x000000ffff437224ULL, 0x002fc400078e002dULL, 0x00000000002c7805ULL, 0x000fca0000015200ULL,
0x0106b400ff2e7984ULL, 0x000e640000000800ULL, 0x800000002eff7812ULL, 0x002fc40007804855ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff357224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002e7805ULL, 0x000fcc0000015200ULL, 0x0000002e2c347210ULL, 0x000fca0007f1e1ffULL,
0x000000012f2f7824ULL, 0x000fe200000e0e2dULL, 0x003d09003400780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403400780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff2e7819ULL, 0x000fc8000001142fULL,
0x000000342e2e7211ULL, 0x000fca00078110ffULL, 0x000000ffff2f7224ULL, 0x000fca00000e062fULL,
0x000000022e2e7819ULL, 0x000fc8000000122fULL, 0x0000002e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000135357810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106b400ff2e7984ULL, 0x000e640000000800ULL,
0x800000002eff7812ULL, 0x002fe40007804855ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000014000007945ULL, 0x000fe20003800000ULL, 0x0000012000002947ULL, 0x000fea0003800000ULL,
0x0000001aff18723eULL, 0x000fe400000010ffULL, 0x00000002ff2d7819ULL, 0x000fe4000001162aULL,
0x00005410182c7816ULL, 0x000fe20000000018ULL, 0x0000d9a27f007947ULL, 0x000fea000b800000ULL,
0x00001f2d2c197589ULL, 0x0002a400000e0000ULL, 0x000000082d187810ULL, 0x000fe20007ffe0ffULL,
0x0000d9d27f007947ULL, 0x000fea000b800000ULL, 0x00001f182c187589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000102d477810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff5a7224ULL, 0x000fe200078e002cULL, 0x0000f59000467802ULL, 0x000fc40000000f00ULL,
0x0000e17000007944ULL, 0x00efea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000182d477810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff5a7224ULL, 0x004fe200078e002cULL,
0x0000f5e000467802ULL, 0x000fc40000000f00ULL, 0x0000e12000007944ULL, 0x00afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000004044783bULL, 0x000f280000004200ULL, 0x000000004138783bULL, 0x000ee80000004200ULL,
0x000000004234783bULL, 0x000ea80000004200ULL, 0x000000003d2c783bULL, 0x00ae620000004200ULL,
0x00000010ff7a7819ULL, 0x010fc40000011645ULL, 0x000000ff455b7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff5a7819ULL, 0x004fe40000011645ULL, 0x0000ffff458f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff837819ULL, 0x100fe40000011638ULL, 0x000000ff38627812ULL, 0x000fe400078ec0ffULL,
0x00000018ff617819ULL, 0x000fc40000011638ULL, 0x0000ffff38927812ULL, 0x000fe400078ec0ffULL,
0x00000010ff877819ULL, 0x100fe4000001163aULL, 0x000000ff3a667812ULL, 0x040fe400078ec0ffULL,
0x00000018ff657819ULL, 0x000fe4000001163aULL, 0x0000ffff3a947812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5c7819ULL, 0x000fc40000011644ULL, 0x000000ff44547812ULL, 0x040fe400078ec0ffULL,
0x00000018ff597819ULL, 0x000fe40000011644ULL, 0x0000ffff448e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff847819ULL, 0x100fe40000011639ULL, 0x000000ff39647812ULL, 0x000fe400078ec0ffULL,
0x00000018ff637819ULL, 0x000fc40000011639ULL, 0x0000ffff39937812ULL, 0x000fe400078ec0ffULL,
0x00000010ff887819ULL, 0x100fe4000001163bULL, 0x000000ff3b677812ULL, 0x040fe400078ec0ffULL,
0x00000018ff3a7819ULL, 0x000fe4000001163bULL, 0x0000ffff3b797812ULL, 0x000fe400078ec0ffULL,
0x00000010ff457819ULL, 0x000fc40000011637ULL, 0x000000ff37867812ULL, 0x040fe400078ec0ffULL,
0x00000018ff857819ULL, 0x000fe40000011637ULL, 0x0000ffff37387812ULL, 0x000fe400078ec0ffULL,
0x00000010ff727819ULL, 0x100fe40000011634ULL, 0x000000ff347b7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff3b7819ULL, 0x000fc40000011634ULL, 0x0000ffff34787812ULL, 0x000fe400078ec0ffULL,
0x00000010ff717819ULL, 0x100fe40000011636ULL, 0x000000ff36827812ULL, 0x040fe400078ec0ffULL,
0x00000018ff817819ULL, 0x000fe40000011636ULL, 0x0000ffff36447812ULL, 0x000fe400078ec0ffULL,
0x00000010ff397819ULL, 0x002fc4000001162cULL, 0x000000ff2c8a7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff897819ULL, 0x000fe4000001162cULL, 0x0000ffff2c377812ULL, 0x000fe400078ec0ffULL,
0x00000018ff5d7819ULL, 0x000fe40000011646ULL, 0x00000010ff367819ULL, 0x000fe4000001162dULL,
0x000000ff2d8b7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff2c7819ULL, 0x000fe4000001162dULL,
0x0000ffff2d347812ULL, 0x000fe400078ec0ffULL, 0x00000018ff2d7819ULL, 0x000fe4000001162eULL,
0x00000010ff7e7819ULL, 0x000fe40000011646ULL, 0x000000ff465e7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff46907812ULL, 0x000fc400078ec0ffULL, 0x00000010ff7f7819ULL, 0x100fe40000011647ULL,
0x000000ff47607812ULL, 0x040fe400078ec0ffULL, 0x00000018ff5f7819ULL, 0x000fe40000011647ULL,
0x0000ffff47917812ULL, 0x000fe400078ec0ffULL, 0x00000059ff59723eULL, 0x000fe400020006ffULL,
0x0000005dff5d723eULL, 0x000fc400020006ffULL, 0x00000066ff66723eULL, 0x000fe200020006ffULL,
0x20000059ff757230ULL, 0x000fe20000004100ULL, 0x00000010ff477819ULL, 0x100fe20000011635ULL,
0x2000005dff6f7230ULL, 0x000fe20000004100ULL, 0x000000ff35807812ULL, 0x040fe200078ec0ffULL,
0x20000066ff6a7230ULL, 0x000fe20000004100ULL, 0x00000018ff7d7819ULL, 0x000fe40000011635ULL,
0x0000ffff35467812ULL, 0x000fe400078ec0ffULL, 0x0000002cff2c723eULL, 0x000fc400020006ffULL,
0x0000002dff2d723eULL, 0x000fe400020006ffULL, 0x00000010ff357819ULL, 0x000fe2000001162eULL,
0x2000002cff5d7230ULL, 0x000fe20000004100ULL, 0x000000ff2e8c7812ULL, 0x040fe200078ec0ffULL,
0x2000002dff597230ULL, 0x000fe20000004100ULL, 0x0000ffff2e587812ULL, 0x000fe400078ec0ffULL,
0x00000018ff2e7819ULL, 0x000fe4000001162fULL, 0x000000ff5c5c7812ULL, 0x000fc400078ec0ffULL,
0x000000ff7a7a7812ULL, 0x000fe400078ec0ffULL, 0x00000054ff77723eULL, 0x000fe400020006ffULL,
0x0000003aff3a723eULL, 0x000fe400020006ffULL, 0x0000007bff66723eULL, 0x000fe200020006ffULL,
0x20000077ff777230ULL, 0x000fe20000004100ULL, 0x00000010ff557819ULL, 0x000fe2000001162fULL,
0x2000003aff687230ULL, 0x000fe20000004100ULL, 0x000000ff2f8d7812ULL, 0x040fe200078ec0ffULL,
0x20000066ff667230ULL, 0x000fe20000004100ULL, 0x0000ffff2f547812ULL, 0x000fc400078ec0ffULL,
0x00000008ff2d7819ULL, 0x000fe4000001168eULL, 0x0000002eff7b723eULL, 0x000fe400020006ffULL,
0x0000005cff2c723eULL, 0x000fe400020006ffULL, 0x0000007aff2e723eULL, 0x000fe200020006ffULL,
0x2000007bff5c7230ULL, 0x000fe20000004100ULL, 0x00000008ff2f7819ULL, 0x000fe2000001168fULL,
0x2000002cff7a7230ULL, 0x000fe20000004100ULL, 0x0000002dff2d723eULL, 0x000fc400020006ffULL,
0x0000007dff3a723eULL, 0x000fe200020006ffULL, 0x2000002eff7d7230ULL, 0x000fe20000004100ULL,
0x0000002fff2f723eULL, 0x000fe200020006ffULL, 0x2000002dff7b7230ULL, 0x000fe20000004100ULL,
0x000000ff7e2c7812ULL, 0x000fe200078ec0ffULL, 0x2000003aff3a7230ULL, 0x000fe20000004100ULL,
0x000000ff7f7f7812ULL, 0x000fe200078ec0ffULL, 0x2000002fff7e7230ULL, 0x000fe20000004100ULL,
0x00000008ff2e7819ULL, 0x000fe40000011690ULL, 0x00000067ff67723eULL, 0x000fc400020006ffULL,
0x00000061ff61723eULL, 0x000fe400020006ffULL, 0x00000065ff65723eULL, 0x000fe200020006ffULL,
0x20000067ff697230ULL, 0x000fe20000004100ULL, 0x0000002cff2d723eULL, 0x000fe200020006ffULL,
0x20000061ff6b7230ULL, 0x000fe20000004100ULL, 0x0000007fff2f723eULL, 0x000fe200020006ffULL,
0x20000065ff677230ULL, 0x000fe20000004100ULL, 0x0000002eff2e723eULL, 0x000fe200020006ffULL,
0x2000002dff7f7230ULL, 0x000fe20000004100ULL, 0x0000b0003e2c7811ULL, 0x000fc400078e20ffULL,
0x00000080ff65723eULL, 0x000fe200020006ffULL, 0x2000002eff807230ULL, 0x000fe20000004100ULL,
0x00000081ff61723eULL, 0x000fe200020006ffULL, 0x2000002fff817230ULL, 0x000fe20000004100ULL,
0x00000060ff60723eULL, 0x000fe200020006ffULL, 0x000000002c2c783bULL, 0x000e620000000200ULL,
0x000000ff72727812ULL, 0x000fe200078ec0ffULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x00000008ff787819ULL, 0x000fe20000011678ULL, 0x20000060ff747230ULL, 0x000fe20000004100ULL,
0x0000005bff5b723eULL, 0x000fe200020006ffULL, 0x20000061ff617230ULL, 0x000fe20000004100ULL,
0x0000005fff5f723eULL, 0x000fc400020006ffULL, 0x0000008aff60723eULL, 0x000fe200020006ffULL,
0x2000005bff7c7230ULL, 0x000fe20000004100ULL, 0x00000072ff72723eULL, 0x000fe200020006ffULL,
0x2000005fff707230ULL, 0x000fe20000004100ULL, 0x00000078ff8a723eULL, 0x000fe200020006ffULL,
0x20000060ff607230ULL, 0x000fe20000004100ULL, 0x000000ff47477812ULL, 0x000fe200078ec0ffULL,
0x20000072ff787230ULL, 0x000fe20000004100ULL, 0x00000064ff64723eULL, 0x000fe200020006ffULL,
0x2000008aff727230ULL, 0x000fe20000004100ULL, 0x0000008bff5f723eULL, 0x000fc400020006ffULL,
0x00000047ff8a723eULL, 0x000fe200020006ffULL, 0x20000064ff6d7230ULL, 0x000fe20000004100ULL,
0x00000008ff8b7819ULL, 0x000fe20000011646ULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x00000010ff467819ULL, 0x000fe20000011677ULL, 0x2000008aff8a7230ULL, 0x000fe20000004100ULL,
0x00000010ff477819ULL, 0x000fe4000001167cULL, 0x00000010ff7a7819ULL, 0x000fe4000001167aULL,
0x00000010ff7d7819ULL, 0x000fc4000001167dULL, 0x0000005aff5a723eULL, 0x000fe400020006ffULL,
0x0000005eff5e723eULL, 0x000fe400020006ffULL, 0x00000082ff64723eULL, 0x000fe200020006ffULL,
0x2000005aff767230ULL, 0x000fe20000004100ULL, 0x00000008ff827819ULL, 0x000fe20000011691ULL,
0x000000192c2ca231ULL, 0x082fe200003400ffULL, 0x000010547a467816ULL, 0x000fe20000000046ULL,
0x000000192e2ea231ULL, 0x000fe200003400ffULL, 0x000010547d477816ULL, 0x000fe20000000047ULL,
0x000000182d2da231ULL, 0x080fe200003400ffULL, 0x2000005eff737230ULL, 0x000fe20000004100ULL,
0x000000182f2fa231ULL, 0x000fe200003400ffULL, 0x000000ff45457812ULL, 0x000fe200078ec0ffULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x00000082ff82723eULL, 0x000fc400020006ffULL,
0x000000ff717a7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff717819ULL, 0x000fe20000011676ULL,
0x000000462c08723cULL, 0x000b620000041808ULL, 0x00000010ff777819ULL, 0x000fe2000001167eULL,
0x20000082ff827230ULL, 0x000fe20000004100ULL, 0x00000045ff45723eULL, 0x000fe400020006ffULL,
0x00000010ff737819ULL, 0x000fe40000011673ULL, 0x00000010ff477819ULL, 0x020fc40000011674ULL,
0x00000010ff7f7819ULL, 0x000fe4000001167fULL, 0x00000010ff817819ULL, 0x000fe40000011681ULL,
0x00000008ff447819ULL, 0x000fe40000011644ULL, 0x0000105471777816ULL, 0x000fe20000000077ULL,
0x20000045ff717230ULL, 0x000fe20000004100ULL, 0x000010547f467816ULL, 0x000fe40000000073ULL,
0x0000105481477816ULL, 0x000fc40000000047ULL, 0x00000044ff45723eULL, 0x000fe400020006ffULL,
0x00000010ff707819ULL, 0x000fe40000011670ULL, 0x00000010ff817819ULL, 0x000fe20000011682ULL,
0x000000462c30723cULL, 0x000be20000041830ULL, 0x0000b0003f447811ULL, 0x000fe400078e20ffULL,
0x0000105470817816ULL, 0x000fe20000000081ULL, 0x20000045ff707230ULL, 0x000fe20000004100ULL,
0x00000062ff62723eULL, 0x000fc400020006ffULL, 0x000000004444783bULL, 0x020e620000000200ULL,
0x00000063ff63723eULL, 0x000fe400020006ffULL, 0x20000062ff6e7230ULL, 0x000fe20000004100ULL,
0x00000085ff62723eULL, 0x000fe400020006ffULL, 0x000000ff84857812ULL, 0x000fe200078ec0ffULL,
0x20000063ff6c7230ULL, 0x000fe20000004100ULL, 0x00000008ff847819ULL, 0x000fe20000011692ULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x00000089ff5e723eULL, 0x000fc400020006ffULL,
0x00000086ff63723eULL, 0x000fe400020006ffULL, 0x00000084ff84723eULL, 0x000fe200020006ffULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x000000ff88897812ULL, 0x000fe200078ec0ffULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x000000ff83837812ULL, 0x000fe200078ec0ffULL,
0x20000084ff847230ULL, 0x000fe20000004100ULL, 0x00000008ff867819ULL, 0x000fe40000011693ULL,
0x000000ff87877812ULL, 0x000fc400078ec0ffULL, 0x00000008ff887819ULL, 0x000fe40000011694ULL,
0x00000008ff797819ULL, 0x000fe40000011679ULL, 0x00000085ff85723eULL, 0x000fe400020006ffULL,
0x00000083ff83723eULL, 0x000fe400020006ffULL, 0x00000086ff86723eULL, 0x000fe200020006ffULL,
0x20000085ff857230ULL, 0x000fe20000004100ULL, 0x00000087ff87723eULL, 0x000fe200020006ffULL,
0x20000083ff837230ULL, 0x000fe20000004100ULL, 0x00000089ff89723eULL, 0x000fe200020006ffULL,
0x20000086ff867230ULL, 0x000fe20000004100ULL, 0x00000088ff88723eULL, 0x000fe200020006ffULL,
0x20000087ff877230ULL, 0x000fe20000004100ULL, 0x00000079ff79723eULL, 0x000fe200020006ffULL,
0x20000089ff897230ULL, 0x000fe20000004100ULL, 0x00000010ff757819ULL, 0x000fe20000011675ULL,
0x20000088ff887230ULL, 0x000fe20000004100ULL, 0x00000010ff7b7819ULL, 0x000fe2000001167bULL,
0x20000079ff797230ULL, 0x000fe20000004100ULL, 0x00000010ff6f7819ULL, 0x000fe2000001166fULL,
0x000000194444a231ULL, 0x082fe200003400ffULL, 0x00000010ff807819ULL, 0x000fe20000011680ULL,
0x000000194646a231ULL, 0x000fe200003400ffULL, 0x0000105475767816ULL, 0x000fe2000000007bULL,
0x000000184545a231ULL, 0x080fe200003400ffULL, 0x00000010ff6b7819ULL, 0x000fe2000001166bULL,
0x000000184747a231ULL, 0x000fe200003400ffULL, 0x00000010ff847819ULL, 0x000fc40000011684ULL,
0x000010546f807816ULL, 0x000fe20000000080ULL, 0x000000762c04723cULL, 0x040f620000041804ULL,
0x000000ff39397812ULL, 0x000fe400078ec0ffULL, 0x00000010ff6f7819ULL, 0x000fe40000011685ULL,
0x000010546b847816ULL, 0x000fe40000000084ULL, 0x00000010ff6e7819ULL, 0x000fe2000001166eULL,
0x000000802c48723cULL, 0x000f620000041848ULL, 0x00000010ff6d7819ULL, 0x000fc4000001166dULL,
0x00000010ff837819ULL, 0x000fe40000011683ULL, 0x00000010ff6c7819ULL, 0x000fe4000001166cULL,
0x00000010ff857819ULL, 0x000fe40000011686ULL, 0x00000010ff6a7819ULL, 0x000fe4000001166aULL,
0x00000010ff697819ULL, 0x000fe40000011669ULL, 0x00000010ff877819ULL, 0x000fc40000011687ULL,
0x00000010ff6b7819ULL, 0x000fe40000011689ULL, 0x00000010ff677819ULL, 0x000fe40000011667ULL,
0x00000010ff687819ULL, 0x000fe40000011668ULL, 0x00000010ff887819ULL, 0x000fe40000011688ULL,
0x00000010ff797819ULL, 0x000fe40000011679ULL, 0x00000008ff387819ULL, 0x000fc40000011638ULL,
0x00000039ff39723eULL, 0x000fe400020006ffULL, 0x0000003bff3b723eULL, 0x000fe400020006ffULL,
0x0000008bff8b723eULL, 0x000fe400020006ffULL, 0x00001054836e7816ULL, 0x000fe2000000006eULL,
0x2000003bff3b7230ULL, 0x000fe20000004100ULL, 0x000010546f6f7816ULL, 0x000fe2000000006dULL,
0x20000039ff6d7230ULL, 0x000fe20000004100ULL, 0x000010546c857816ULL, 0x000fe20000000085ULL,
0x2000008bff8b7230ULL, 0x000fe20000004100ULL, 0x00001054876a7816ULL, 0x000fc4000000006aULL,
0x000010546b6b7816ULL, 0x000fe20000000069ULL, 0x0000006e2c4c723cULL, 0x040f62000004184cULL,
0x0000105467887816ULL, 0x000fe40000000088ULL, 0x0000105468897816ULL, 0x000fe40000000079ULL,
0x00000038ff38723eULL, 0x000fe400020006ffULL, 0x00000010ff667819ULL, 0x000fe20000011666ULL,
0x000000842c0c723cULL, 0x000f62000004180cULL, 0x00000010ff397819ULL, 0x000fe20000011665ULL,
0x20000038ff6c7230ULL, 0x000fe20000004100ULL, 0x00000010ff787819ULL, 0x000fc40000011678ULL,
0x00000010ff8a7819ULL, 0x000fe4000001168aULL, 0x00000008ff347819ULL, 0x000fe20000011634ULL,
0x0000006a2c50723cULL, 0x040f620000041850ULL, 0x0000105478387816ULL, 0x000fe40000000066ULL,
0x000010548a397816ULL, 0x000fe40000000039ULL, 0x00000008ff587819ULL, 0x000fe40000011658ULL,
0x000000ff36367812ULL, 0x000fe200078ec0ffULL, 0x000000882c10723cULL, 0x000b620000041810ULL,
0x00000008ff377819ULL, 0x000fc40000011637ULL, 0x000000ff55557812ULL, 0x000fe400078ec0ffULL,
0x00000008ff547819ULL, 0x000fe40000011654ULL, 0x000000ff352d7812ULL, 0x020fe400078ec0ffULL,
0x00000010ff3b7819ULL, 0x000fe4000001163bULL, 0x00000010ff3a7819ULL, 0x000fe4000001163aULL,
0x00000010ff727819ULL, 0x000fc40000011672ULL, 0x00000010ff357819ULL, 0x000fe4000001168bULL,
0x00000034ff2c723eULL, 0x000fe400020006ffULL, 0x0000008cff5b723eULL, 0x000fe400020006ffULL,
0x0000002dff2d723eULL, 0x000fe400020006ffULL, 0x00000058ff58723eULL, 0x000fe200020006ffULL,
0x2000005bff5b7230ULL, 0x000fe20000004100ULL, 0x0000008dff5a723eULL, 0x000fc400020006ffULL,
0x0000007aff7a723eULL, 0x000fe200020006ffULL, 0x20000058ff587230ULL, 0x000fe20000004100ULL,
0x00000036ff36723eULL, 0x000fe200020006ffULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x00000037ff37723eULL, 0x000fe200020006ffULL, 0x2000007aff7a7230ULL, 0x000fe20000004100ULL,
0x00000055ff55723eULL, 0x000fe200020006ffULL, 0x20000036ff687230ULL, 0x000fe20000004100ULL,
0x00000054ff54723eULL, 0x000fe200020006ffULL, 0x20000037ff677230ULL, 0x000fe20000004100ULL,
0x000010543b347816ULL, 0x000fe20000000072ULL, 0x20000055ff557230ULL, 0x000fe20000004100ULL,
0x000010543a357816ULL, 0x000fe20000000035ULL, 0x20000054ff547230ULL, 0x000fe20000004100ULL,
0x000000384438723cULL, 0x000b620000041808ULL, 0x00000010ff5d7819ULL, 0x000fc4000001165dULL,
0x00000010ff5b7819ULL, 0x000fe4000001165bULL, 0x00000010ff597819ULL, 0x000fe40000011659ULL,
0x2000002cff087230ULL, 0x020fe20000004100ULL, 0x000000344434723cULL, 0x000b620000041804ULL,
0x2000002dff097230ULL, 0x000fe20000004100ULL, 0x00000010ff587819ULL, 0x000fe40000011658ULL,
0x00000010ff087819ULL, 0x000fe40000011608ULL, 0x00000010ff097819ULL, 0x000fc40000011609ULL,
0x00000010ff647819ULL, 0x000fe40000011664ULL, 0x00000010ff637819ULL, 0x000fe40000011663ULL,
0x00000010ff7a7819ULL, 0x000fe4000001167aULL, 0x00000010ff657819ULL, 0x000fe40000011671ULL,
0x00000010ff617819ULL, 0x000fe40000011661ULL, 0x00000010ff627819ULL, 0x000fc40000011662ULL,
0x00000010ff707819ULL, 0x000fe40000011670ULL, 0x00000010ff2d7819ULL, 0x000fe4000001166cULL,
0x00000010ff607819ULL, 0x000fe40000011660ULL, 0x00000010ff057819ULL, 0x020fe4000001165fULL,
0x00000010ff6d7819ULL, 0x000fe4000001166dULL, 0x00000010ff687819ULL, 0x000fc40000011668ULL,
0x00000010ff5e7819ULL, 0x000fe4000001165eULL, 0x00000010ff677819ULL, 0x000fe40000011667ULL,
0x00000010ff5a7819ULL, 0x000fe4000001165aULL, 0x00000010ff557819ULL, 0x000fe40000011655ULL,
0x00000010ff5c7819ULL, 0x000fe4000001165cULL, 0x00000010ff547819ULL, 0x000fc40000011654ULL,
0x000010545d5f7816ULL, 0x000fe40000000008ULL, 0x0000105409087816ULL, 0x000fe4000000005bULL,
0x0000105459587816ULL, 0x000fe40000000058ULL, 0x000010547a647816ULL, 0x000fe40000000064ULL,
0x0000105465657816ULL, 0x000fe40000000063ULL, 0x00001054612c7816ULL, 0x000fc40000000070ULL,
0x00001054622d7816ULL, 0x000fe4000000002dULL, 0x000010546d047816ULL, 0x000fe20000000060ULL,
0x000000644430723cULL, 0x040b620000041830ULL, 0x0000105468057816ULL, 0x000fe40000000005ULL,
0x000010545e5e7816ULL, 0x000fe40000000067ULL, 0x0000105455097816ULL, 0x000fe4000000005aULL,
0x000010545c597816ULL, 0x000fe20000000054ULL, 0x0000002c442c723cULL, 0x040b700000041848ULL,
0x000000044404723cULL, 0x040b70000004184cULL, 0x0000005e440c723cULL, 0x040b70000004180cULL,
0x000000084408723cULL, 0x040b700000041850ULL, 0x000000584410723cULL, 0x000b620000041810ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff447f8cULL, 0x020e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000803c447810ULL, 0x002fe20007ffe0ffULL, 0x01069800ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff4a7224ULL, 0x000fe200078e0045ULL, 0x00000003204f7810ULL, 0x000fc40007ffe0ffULL,
0x000000284400720cULL, 0x000fe20003f06070ULL, 0x000000ffff447224ULL, 0x000fd800078e0056ULL,
0x0000527000000947ULL, 0x000fea0003800000ULL, 0x0000000000447805ULL, 0x000fc40000015200ULL,
0x0106bc00ff247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fe4000780484aULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff487224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000467805ULL, 0x000fcc0000015200ULL, 0x0000004644467210ULL, 0x000fca0007f1e1ffULL,
0x0000000147477824ULL, 0x000fe200000e0e45ULL, 0x003d09004600780cULL, 0x000fc80003f06070ULL,
0x000000ff4700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404600780cULL, 0x000fc80003f06070ULL, 0x000000ff4700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff247819ULL, 0x000fc80000011447ULL,
0x0000004624247211ULL, 0x000fca00078110ffULL, 0x000000ffff467224ULL, 0x000fca00000e0647ULL,
0x0000000224247819ULL, 0x000fc80000001246ULL, 0x000000240000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000148487810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106bc00ff247984ULL, 0x000e640000000800ULL,
0x8000000024ff7812ULL, 0x002fe4000780484aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000046000009947ULL, 0x000fea0003800000ULL, 0x000000a03c247810ULL, 0x000fe20007ffe0ffULL,
0x0000000125457824ULL, 0x000fe200078e0217ULL, 0x0000000217477810ULL, 0x000fe40007ffe0ffULL,
0x0000002428447217ULL, 0x000fe20007800000ULL, 0x0000000145467824ULL, 0x000fe200078e022aULL,
0x00000004174a7810ULL, 0x000fe20007ffe0ffULL, 0x00000010454f7824ULL, 0x000fe200078e00ffULL,
0x0000000617527810ULL, 0x000fe20007ffe0ffULL, 0x0000000144447824ULL, 0x000fe200078e0a24ULL,
0x0000002029247811ULL, 0x000fe200078e30ffULL, 0x0000000125487824ULL, 0x000fe200078e0247ULL,
0xfffffff04f4f7812ULL, 0x000fe200078ee246ULL, 0x0000000125497824ULL, 0x040fe200078e024aULL,
0x0000004425447217ULL, 0x000fe20007800000ULL, 0x00000001454d7824ULL, 0x000fe200078e0224ULL,
0x000000f01f4e7812ULL, 0x000fe200078ec0ffULL, 0x0000000125457824ULL, 0x000fe200078e0252ULL,
0x0000e0004f4f7811ULL, 0x000fe200078e20ffULL, 0x00000001484c7824ULL, 0x000fe200078e0224ULL,
0x000000574d4d7210ULL, 0x000fe20007f1e0ffULL, 0x00000001494b7824ULL, 0x000fc400078e022aULL,
0x0000001049517824ULL, 0x000fe200078e00ffULL, 0x000000574c4c7210ULL, 0x080fe20007f3e0ffULL,
0x0000000148467824ULL, 0x040fe400078e022aULL, 0x0000001048507824ULL, 0x000fe200078e00ffULL,
0xfffffff051517812ULL, 0x000fe200078ee24bULL, 0x0000000149497824ULL, 0x100fe200078e0224ULL,
0x00005e004c4b7a11ULL, 0x000fe200078440ffULL, 0x0000000145247824ULL, 0x040fe200078e0224ULL,
0xfffffff050507812ULL, 0x000fe200078ee246ULL, 0x0000000145467824ULL, 0x000fe200078e022aULL,
0x0000005749497210ULL, 0x080fe20007f9e0ffULL, 0x0000001045537824ULL, 0x000fe200078e00ffULL,
0x0000005724577210ULL, 0x000fe20007f7e0ffULL, 0x0000000144247824ULL, 0x000fe200078e0a25ULL,
0x0000e00050507811ULL, 0x000fe200078e20ffULL, 0x000000ffff447224ULL, 0x000fe200008e06ffULL,
0xfffffff053537812ULL, 0x000fe200078ee246ULL, 0x000000ffff467224ULL, 0x000fe200000e06ffULL,
0x00005e004d457a11ULL, 0x000fc400078040ffULL, 0x00005f004c4c7a11ULL, 0x000fe400010f4444ULL,
0x000000241700720cULL, 0x000fe40003f46070ULL, 0x00005f004d4d7a11ULL, 0x000fe200000f4446ULL,
0x000000ffff467224ULL, 0x000fe200018e06ffULL, 0x0000004e45447210ULL, 0x000fe40007fbe0ffULL,
0x000000244a00720cULL, 0x080fe20003f06070ULL, 0x000000ffff4a7224ULL, 0x000fe200020e06ffULL,
0x000000244700720cULL, 0x000fe20003f26070ULL, 0x000000ffff457224ULL, 0x000fe200028e064dULL,
0x00005e0049477a11ULL, 0x000fc400078840ffULL, 0x00005e0057487a11ULL, 0x000fe400078c40ffULL,
0x000000245200720cULL, 0x000fe20003f66070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000444f7faeULL, 0x0003e2000d101c46ULL, 0x00005f0049497a11ULL, 0x000fe400020f444aULL,
0x00005f0057247a11ULL, 0x000fe400030f4446ULL, 0x0000004e47467210ULL, 0x080fe40007f9e0ffULL,
0x0000004e48487210ULL, 0x000fc40007fbe0ffULL, 0x0000e00051517811ULL, 0x000fe200078e20ffULL,
0x000000ffff477224ULL, 0x000fe200020e0649ULL, 0x0000e00053537811ULL, 0x000fe200078e20ffULL,
0x000000ffff497224ULL, 0x000fe200028e0624ULL, 0x0000004e4b447210ULL, 0x002fca0007f5e0ffULL,
0x000000ffff457224ULL, 0x000fca00010e064cULL, 0x0000000044507faeULL, 0x0003e8000c901c46ULL,
0x0000000046517faeULL, 0x0003e8000c101c46ULL, 0x0000000048537faeULL, 0x0003e2000d901c46ULL,
0x0000039000007947ULL, 0x000fea0003800000ULL, 0x0000000125247824ULL, 0x000fe200078e0217ULL,
0x0000002029447811ULL, 0x000fc400078e30ffULL, 0x000000f01f4e7812ULL, 0x000fe200078ec0ffULL,
0x0000000124457824ULL, 0x040fe200078e022aULL, 0x0000000224467810ULL, 0x040fe20007ffe0ffULL,
0x00000010244f7824ULL, 0x040fe200078e00ffULL, 0x0000000624487810ULL, 0x000fc60007ffe0ffULL,
0x0000000146477824ULL, 0x040fe200078e022aULL, 0xfffffff04f4f7812ULL, 0x000fe200078ee245ULL,
0x0000001046507824ULL, 0x000fe400078e00ffULL, 0x0000000124457824ULL, 0x000fe200078e0244ULL,
0x0000e0004f4f7811ULL, 0x000fe200078e20ffULL, 0x00000001444c7824ULL, 0x000fe200078e0246ULL,
0xfffffff050507812ULL, 0x000fe200078ee247ULL, 0x0000000144497824ULL, 0x000fe200078e0248ULL,
0x0000000424477810ULL, 0x000fe20007ffe0ffULL, 0x00000001484b7824ULL, 0x140fe200078e022aULL,
0x0000005745457210ULL, 0x080fe20007f5e0ffULL, 0x0000001048527824ULL, 0x000fe200078e00ffULL,
0x000000574c4c7210ULL, 0x080fe20007f1e0ffULL, 0x0000000144247824ULL, 0x000fe200078e0247ULL,
0x00005e00454a7a11ULL, 0x000fe200078640ffULL, 0x0000000147467824ULL, 0x040fe200078e022aULL,
0xfffffff052527812ULL, 0x000fe200078ee24bULL, 0x0000001047517824ULL, 0x000fe200078e00ffULL,
0x0000005724477210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff447224ULL, 0x000fe200010e06ffULL,
0x0000005749247210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff4b7224ULL, 0x000fe200000e06ffULL,
0xfffffff051517812ULL, 0x000fc400078ee246ULL, 0x00005f00454d7a11ULL, 0x000fe200018f4444ULL,
0x000000ffff447224ULL, 0x000fe200010e06ffULL, 0x00005e004c497a11ULL, 0x000fe200078040ffULL,
0x000000ffff457224ULL, 0x000fe200008e06ffULL, 0x00005e0024487a11ULL, 0x000fe400078440ffULL,
0x00005e0047467a11ULL, 0x000fe400078240ffULL, 0x0000004e4a4a7210ULL, 0x000fe40007f7e0ffULL,
0x00005f004c4c7a11ULL, 0x000fc400000f444bULL, 0x00005f0024247a11ULL, 0x000fe200010f4444ULL,
0x000000ffff4b7224ULL, 0x000fe200018e064dULL, 0x00005f0047477a11ULL, 0x000fe400008f4445ULL,
0x0000004e49447210ULL, 0x080fe40007f1e0ffULL, 0x0000004e46467210ULL, 0x080fe20007f3e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000004a4f7faeULL, 0x0003e2000b901c46ULL,
0x0000004e48487210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff457224ULL, 0x000fe200000e064cULL,
0x0000e00050507811ULL, 0x000fe200078e20ffULL, 0x000000ffff477224ULL, 0x000fe200008e0647ULL,
0x0000e00051517811ULL, 0x000fe200078e20ffULL, 0x000000ffff497224ULL, 0x000fe200010e0624ULL,
0x0000e00052527811ULL, 0x000fe200078e20ffULL, 0x0000000044507faeULL, 0x0003e8000b901c46ULL,
0x0000000046517faeULL, 0x0003e8000b901c46ULL, 0x0000000048527faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000420447810ULL, 0x002fc80007ffe0ffULL,
0x000000274400720cULL, 0x000fe20003f06070ULL, 0xffffffffff247424ULL, 0x000fd800078e00ffULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x0000000122447824ULL, 0x000fe400078e0244ULL,
0x00000004ff457424ULL, 0x000fc800078e00ffULL, 0x0000600044447625ULL, 0x000fca00078e0045ULL,
0x0000000644247981ULL, 0x000324000c1e1900ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff507f8cULL, 0x000ea2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106680025487f8cULL, 0x000664000c80043fULL, 0x0000000000447805ULL, 0x002fc40000015200ULL,
0x01066c0025467984ULL, 0x000e640000000800ULL, 0x8000000046ff7812ULL, 0x002fe40007804849ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff4b7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000467805ULL, 0x000fcc0000015200ULL, 0x00000046444a7210ULL, 0x000fca0007f1e1ffULL,
0x0000000147477824ULL, 0x000fe200000e0e45ULL, 0x003d09004a00780cULL, 0x000fc80003f06070ULL,
0x000000ff4700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404a00780cULL, 0x000fc80003f06070ULL, 0x000000ff4700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff467819ULL, 0x000fc80000011447ULL,
0x0000004a46467211ULL, 0x000fca00078110ffULL, 0x000000ffff477224ULL, 0x000fca00000e0647ULL,
0x0000000246467819ULL, 0x000fc80000001247ULL, 0x000000460000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000014b4b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01066c0025467984ULL, 0x000e640000000800ULL,
0x8000000046ff7812ULL, 0x002fe40007804849ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x010180001e457984ULL, 0x000e680000000800ULL, 0x010380001e487984ULL, 0x0006a20000000800ULL,
0x000000564500720bULL, 0x002fe20003f1d000ULL, 0x0000b4227f007947ULL, 0x000fd8000b800000ULL,
0x0000000000497806ULL, 0x008fc800000e0100ULL, 0x0000ffff49ff7812ULL, 0x000fe2000780c0ffULL,
0x000004a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff4a7424ULL, 0x000fc400078e00ffULL,
0x000000ffff447224ULL, 0x000fd200078e0056ULL, 0x0000046000008947ULL, 0x000fea0003800000ULL,
0x000000032b00780cULL, 0x000fe40003f05270ULL, 0x000000564500720bULL, 0x000fe20003f34000ULL,
0x0000b3e27f007947ULL, 0x000fd8000b800000ULL, 0x00000000001d7806ULL, 0x000fc400008e0100ULL,
0x0000005645448209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe80003800000ULL,
0x010580441e008388ULL, 0x0003e40000000800ULL, 0x000099101d1e7816ULL, 0x002fc800000000ffULL,
0x000000ff1e00720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x00000056451e7209ULL, 0x000fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff1dff7812ULL, 0x000fc6000780c0ffULL, 0x000000561e1e7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b1e1e7820ULL, 0x000fc80000410000ULL, 0x0000001e00447308ULL, 0x000e640000000800ULL,
0x0000004423237220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff1e7819ULL, 0x000fe2000001162aULL, 0x0000b3227f007947ULL, 0x000fea000b800000ULL,
0x00001f1e441e7589ULL, 0x0002e400000e0000ULL, 0x0000001e38387220ULL, 0x088fe20000410000ULL,
0x0000001e39397220ULL, 0x080fe20000410000ULL, 0x0000001e34347220ULL, 0x080fe20000410000ULL,
0x0000001e35357220ULL, 0x080fe20000410000ULL, 0x0000001e30307220ULL, 0x080fe20000410000ULL,
0x0000001e31317220ULL, 0x080fe20000410000ULL, 0x0000001e2c2c7220ULL, 0x080fe20000410000ULL,
0x0000001e2d2d7220ULL, 0x080fe20000410000ULL, 0x0000001e04047220ULL, 0x080fe20000410000ULL,
0x0000001e05057220ULL, 0x080fe20000410000ULL, 0x0000001e0c0c7220ULL, 0x080fe20000410000ULL,
0x0000001e0d0d7220ULL, 0x080fe20000410000ULL, 0x0000001e08087220ULL, 0x080fe20000410000ULL,
0x0000001e09097220ULL, 0x080fe20000410000ULL, 0x0000001e10107220ULL, 0x080fe20000410000ULL,
0x0000001e11117220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff001dff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000082a1e7811ULL, 0x000fe200078ff0ffULL, 0x0000b2227f007947ULL, 0x000fea000b800000ULL,
0x00001f1e441e7589ULL, 0x00066400000e0000ULL, 0x0000001e3a3a7220ULL, 0x082fe20000410000ULL,
0x0000001e3b3b7220ULL, 0x080fe20000410000ULL, 0x0000001e36367220ULL, 0x080fe20000410000ULL,
0x0000001e37377220ULL, 0x080fe20000410000ULL, 0x0000001e32327220ULL, 0x080fe20000410000ULL,
0x0000001e33337220ULL, 0x080fe20000410000ULL, 0x0000001e2e2e7220ULL, 0x080fe20000410000ULL,
0x0000001e2f2f7220ULL, 0x080fe20000410000ULL, 0x0000001e06067220ULL, 0x080fe20000410000ULL,
0x0000001e07077220ULL, 0x080fe20000410000ULL, 0x0000001e0e0e7220ULL, 0x080fe20000410000ULL,
0x0000001e0f0f7220ULL, 0x080fe20000410000ULL, 0x0000001e0a0a7220ULL, 0x080fe20000410000ULL,
0x0000001e0b0b7220ULL, 0x080fe20000410000ULL, 0x0000001e12127220ULL, 0x080fe20000410000ULL,
0x0000001e13137220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000ffff1dff7812ULL, 0x000fe20007800849ULL, 0x00000001ff4a7424ULL, 0x000fe200078e00ffULL,
0x0000005645567209ULL, 0x000fca0007810000ULL, 0x000000ffff447224ULL, 0x00afcc00078e0056ULL,
0x8000005645450221ULL, 0x100fe20000010000ULL, 0x000000ffff440224ULL, 0x000fe200078e0056ULL,
0x00007610ff4a0816ULL, 0x000fe4000000004aULL, 0x3fb8aa3b45450820ULL, 0x000fc80000410000ULL,
0x00000045001a0308ULL, 0x000e640000000800ULL, 0x0000001a48480220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002348237221ULL, 0x004fc20000010000ULL,
0x0000000000467805ULL, 0x000fcc0000015200ULL, 0x0106ac00ff1d7984ULL, 0x000e640000000800ULL,
0x800000001dff7812ULL, 0x002fe40007804843ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff457224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000487805ULL, 0x000fcc0000015200ULL,
0x00000048461e7210ULL, 0x000fca0007f1e1ffULL, 0x0000000149487824ULL, 0x000fe200000e0e47ULL,
0x003d09001e00780cULL, 0x000fc80003f06070ULL, 0x000000ff4800720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401e00780cULL, 0x000fc80003f06070ULL,
0x000000ff4800720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1d7819ULL, 0x000fc80000011448ULL, 0x0000001e1d1d7211ULL, 0x000fca00078110ffULL,
0x000000ffff1e7224ULL, 0x000fca00000e0648ULL, 0x000000021d1d7819ULL, 0x000fc8000000121eULL,
0x0000001d0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000145457810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106ac00ff1d7984ULL, 0x000e640000000800ULL, 0x800000001dff7812ULL, 0x002fe40007804843ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099104a1d7816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff1d00720cULL, 0x000fda0003f25270ULL,
0x0000012000001947ULL, 0x000fea0003800000ULL, 0x0000001aff18723eULL, 0x000fe400000010ffULL,
0x00000002ff1e7819ULL, 0x000fe4000001162aULL, 0x00005410181d7816ULL, 0x000fe20000000018ULL,
0x0000adf27f007947ULL, 0x000fea000b800000ULL, 0x00001f1e1d197589ULL, 0x0002a400000e0000ULL,
0x000000081e187810ULL, 0x000fe20007ffe0ffULL, 0x0000ae227f007947ULL, 0x000fea000b800000ULL,
0x00001f181d187589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000101e477810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff5a7224ULL, 0x000fe200078e001dULL,
0x0001236000467802ULL, 0x000fc40000000f00ULL, 0x0000b3a000007944ULL, 0x01efea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000181e477810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff5a7224ULL, 0x004fe200078e001dULL, 0x000123b000467802ULL, 0x000fc40000000f00ULL,
0x0000b35000007944ULL, 0x01afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000001658783bULL, 0x004ea20000004200ULL,
0x0000b80000007811ULL, 0x000fc400078e20ffULL, 0x0000b80003037811ULL, 0x000fe200078e20ffULL,
0x000000001554783bULL, 0x000ee80000004200ULL, 0x000000000248783bULL, 0x000e680000004200ULL,
0x00000000144c783bULL, 0x000e640000004200ULL, 0x00000018ff1e7819ULL, 0x006fc40000011658ULL,
0x00000010ff527819ULL, 0x000fe40000011658ULL, 0x00000010ff7a7819ULL, 0x108fe40000011654ULL,
0x000000ff545f7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff5e7819ULL, 0x000fe40000011654ULL,
0x0000ffff548b7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff547819ULL, 0x000fc40000011655ULL,
0x00000010ff5c7819ULL, 0x100fe40000011648ULL, 0x000000ff48827812ULL, 0x040fe400078ec0ffULL,
0x00000018ff817819ULL, 0x000fe40000011648ULL, 0x0000ffff48457812ULL, 0x000fe400078ec0ffULL,
0x0000001eff1e723eULL, 0x000fe400020006ffULL, 0x00000010ff437819ULL, 0x000fc40000011649ULL,
0x000000ff49847812ULL, 0x040fe200078ec0ffULL, 0x2000001eff6e7230ULL, 0x000fe20000004100ULL,
0x00000018ff487819ULL, 0x000fe40000011649ULL, 0x0000ffff49167812ULL, 0x000fe400078ec0ffULL,
0x00000018ff497819ULL, 0x000fe4000001164aULL, 0x0000ffff58877812ULL, 0x000fe400078ec0ffULL,
0x000000ff55607812ULL, 0x000fc400078ec0ffULL, 0x00000054ff54723eULL, 0x000fe400020006ffULL,
0x000000ff58027812ULL, 0x000fe400078ec0ffULL, 0x000000ff4c727812ULL, 0x000fe200078ec0ffULL,
0x20000054ff667230ULL, 0x000fe20000004100ULL, 0x00000010ff1d7819ULL, 0x000fe4000001164aULL,
0x000000ff4a857812ULL, 0x040fe400078ec0ffULL, 0x0000ffff4a157812ULL, 0x000fc400078ec0ffULL,
0x00000048ff48723eULL, 0x000fe400020006ffULL, 0x00000018ff4a7819ULL, 0x000fe4000001164bULL,
0x00000049ff1e723eULL, 0x000fe200020006ffULL, 0x20000048ff547230ULL, 0x000fe20000004100ULL,
0x00000010ff717819ULL, 0x000fe40000011659ULL, 0x0000ffff59887812ULL, 0x000fe200078ec0ffULL,
0x2000001eff1e7230ULL, 0x000fe20000004100ULL, 0x00000010ff837819ULL, 0x000fc4000001164dULL,
0x000000ff4d777812ULL, 0x040fe400078ec0ffULL, 0x00000018ff747819ULL, 0x000fe4000001164dULL,
0x0000ffff4d6c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff52527812ULL, 0x000fe400078ec0ffULL,
0x00000008ff497819ULL, 0x000fe40000011687ULL, 0x00000060ff4d723eULL, 0x000fc400020006ffULL,
0x00000002ff46723eULL, 0x000fe400020006ffULL, 0x00000072ff60723eULL, 0x000fe200020006ffULL,
0x2000004dff4d7230ULL, 0x000fe20000004100ULL, 0x00000010ff147819ULL, 0x000fe2000001164bULL,
0x20000046ff707230ULL, 0x000fe20000004100ULL, 0x000000ff4b867812ULL, 0x040fe200078ec0ffULL,
0x20000060ff607230ULL, 0x000fe20000004100ULL, 0x0000ffff4b027812ULL, 0x000fe400078ec0ffULL,
0x0000004aff72723eULL, 0x000fc400020006ffULL, 0x000000ff71717812ULL, 0x000fe400078ec0ffULL,
0x00000052ff48723eULL, 0x000fe200020006ffULL, 0x20000072ff527230ULL, 0x000fe20000004100ULL,
0x00000049ff49723eULL, 0x000fe400020006ffULL, 0x00000008ff4b7819ULL, 0x000fe40000011688ULL,
0x00000010ff757819ULL, 0x000fe2000001165aULL, 0x20000049ff727230ULL, 0x000fe20000004100ULL,
0x0000ffff5a897812ULL, 0x000fc400078ec0ffULL, 0x00000010ff767819ULL, 0x000fe4000001165bULL,
0x0000005eff5e723eULL, 0x000fe400020006ffULL, 0x000000ff59537812ULL, 0x000fe400078ec0ffULL,
0x00000018ff477819ULL, 0x000fe20000011659ULL, 0x2000005eff657230ULL, 0x000fe20000004100ULL,
0x000000ff5a597812ULL, 0x000fe400078ec0ffULL, 0x00000018ff587819ULL, 0x000fc4000001165aULL,
0x00000071ff4a723eULL, 0x000fe200020006ffULL, 0x20000048ff717230ULL, 0x000fe20000004100ULL,
0x0000004bff4b723eULL, 0x000fe400020006ffULL, 0x0000ffff5b8a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff75487812ULL, 0x000fe200078ec0ffULL, 0x2000004bff757230ULL, 0x000fe20000004100ULL,
0x000000ff76767812ULL, 0x000fe400078ec0ffULL, 0x00000008ff497819ULL, 0x000fc40000011689ULL,
0x00000010ff7b7819ULL, 0x000fe40000011655ULL, 0x0000ffff558c7812ULL, 0x000fe400078ec0ffULL,
0x00000059ff59723eULL, 0x000fe400020006ffULL, 0x00000058ff58723eULL, 0x000fe400020006ffULL,
0x00000074ff5e723eULL, 0x000fe200020006ffULL, 0x2000004aff747230ULL, 0x000fe20000004100ULL,
0x00000010ff7d7819ULL, 0x100fe20000011656ULL, 0x20000059ff6a7230ULL, 0x000fe20000004100ULL,
0x000000ff56617812ULL, 0x040fe200078ec0ffULL, 0x20000058ff677230ULL, 0x000fe20000004100ULL,
0x00000018ff557819ULL, 0x000fe20000011656ULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x0000ffff568d7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff7f7819ULL, 0x100fe40000011657ULL,
0x000000ff57627812ULL, 0x040fe400078ec0ffULL, 0x00000018ff567819ULL, 0x000fe40000011657ULL,
0x0000ffff578e7812ULL, 0x000fe400078ec0ffULL, 0x000000ff4e797812ULL, 0x000fe400078ec0ffULL,
0x00000018ff787819ULL, 0x000fc4000001164eULL, 0x00000048ff48723eULL, 0x000fe400020006ffULL,
0x00000076ff4a723eULL, 0x000fe400020006ffULL, 0x00000049ff49723eULL, 0x000fe200020006ffULL,
0x20000048ff767230ULL, 0x000fe20000004100ULL, 0x00000008ff4b7819ULL, 0x000fe4000001168aULL,
0x000000ff5b5d7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff5a7819ULL, 0x000fc4000001165bULL,
0x00000010ff807819ULL, 0x100fe4000001164cULL, 0x00000018ff577819ULL, 0x000fe4000001164cULL,
0x0000ffff4c6d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff4c7819ULL, 0x100fe4000001164fULL,
0x000000ff4f7e7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff7c7819ULL, 0x000fc4000001164fULL,
0x0000ffff4f5b7812ULL, 0x000fe400078ec0ffULL, 0x0000005fff4f723eULL, 0x000fe400020006ffULL,
0x00000077ff5f723eULL, 0x000fe200020006ffULL, 0x20000049ff777230ULL, 0x000fe20000004100ULL,
0x00000079ff59723eULL, 0x000fe200020006ffULL, 0x2000004fff4f7230ULL, 0x000fe20000004100ULL,
0x00000078ff58723eULL, 0x000fe200020006ffULL, 0x2000004aff787230ULL, 0x000fe20000004100ULL,
0x0000004bff79723eULL, 0x000fe200020006ffULL, 0x20000059ff597230ULL, 0x000fe20000004100ULL,
0x000000000048783bULL, 0x0002a20000000200ULL, 0x0000005dff5d723eULL, 0x000fe200020006ffULL,
0x2000005fff5f7230ULL, 0x000fe20000004100ULL, 0x00000057ff57723eULL, 0x000fe200020006ffULL,
0x20000079ff797230ULL, 0x000fe20000004100ULL, 0x0000005aff5a723eULL, 0x000fe200020006ffULL,
0x2000005dff6b7230ULL, 0x000fe20000004100ULL, 0x00000053ff53723eULL, 0x000fe200020006ffULL,
0x20000057ff5d7230ULL, 0x000fe20000004100ULL, 0x00000008ff007819ULL, 0x002fe2000001168bULL,
0x2000005aff687230ULL, 0x000fe20000004100ULL, 0x0000007cff57723eULL, 0x000fe200020006ffULL,
0x20000053ff737230ULL, 0x000fe20000004100ULL, 0x00000000ff00723eULL, 0x000fe200020006ffULL,
0x20000058ff587230ULL, 0x000fe20000004100ULL, 0x00000008ff7c7819ULL, 0x000fe2000001168cULL,
0x20000057ff577230ULL, 0x000fe20000004100ULL, 0x0000007eff5a723eULL, 0x000fc400020006ffULL,
0x000000ff7d7e7812ULL, 0x000fe400078ec0ffULL, 0x0000007cff7d723eULL, 0x000fe200020006ffULL,
0x20000000ff7c7230ULL, 0x000fe20000004100ULL, 0x00000061ff61723eULL, 0x000fe200020006ffULL,
0x2000005aff5a7230ULL, 0x000fe20000004100ULL, 0x000000ff7f7f7812ULL, 0x000fe200078ec0ffULL,
0x2000007dff7d7230ULL, 0x000fe20000004100ULL, 0x00000047ff47723eULL, 0x000fe200020006ffULL,
0x20000061ff647230ULL, 0x000fe20000004100ULL, 0x00000055ff55723eULL, 0x000fc400020006ffULL,
0x00000008ff007819ULL, 0x000fe2000001168dULL, 0x20000047ff6f7230ULL, 0x000fe20000004100ULL,
0x00000010ff697819ULL, 0x000fe2000001164eULL, 0x20000055ff617230ULL, 0x000fe20000004100ULL,
0x00000010ff707819ULL, 0x000fe40000011670ULL, 0x00000010ff717819ULL, 0x000fe40000011671ULL,
0x0000007fff7f723eULL, 0x000fe200020006ffULL, 0x0000001948489231ULL, 0x084fe200003400ffULL,
0x00000010ff737819ULL, 0x000fe20000011673ULL, 0x000000194a4a9231ULL, 0x000fe200003400ffULL,
0x00000010ff747819ULL, 0x000fe20000011674ULL, 0x0000001849499231ULL, 0x080fe200003400ffULL,
0x00000000ff00723eULL, 0x000fe200020006ffULL, 0x000000184b4b9231ULL, 0x000fe200003400ffULL,
0x00000082ff55723eULL, 0x000fc400020006ffULL, 0x0000105471707816ULL, 0x000fe40000000070ULL,
0x000000ff69697812ULL, 0x000fe200078ec0ffULL, 0x20000055ff557230ULL, 0x000fe20000004100ULL,
0x000000ff80827812ULL, 0x000fe200078ec0ffULL, 0x2000007fff807230ULL, 0x000fe20000004100ULL,
0x0000105474717816ULL, 0x000fe20000000073ULL, 0x20000000ff7f7230ULL, 0x000fe20000004100ULL,
0x000000ff7a7a7812ULL, 0x000fe400078ec0ffULL, 0x000000ff7b7b7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff007819ULL, 0x000fe2000001166fULL, 0x000000704838723cULL, 0x000be20000041838ULL,
0x00000069ff69723eULL, 0x000fe400020006ffULL, 0x00000010ff6f7819ULL, 0x000fe40000011675ULL,
0x0000007aff7a723eULL, 0x000fe400020006ffULL, 0x0000007bff7b723eULL, 0x000fe200020006ffULL,
0x20000069ff707230ULL, 0x020fe20000004100ULL, 0x0000ffff4e4e7812ULL, 0x000fe200078ec0ffULL,
0x2000007aff7a7230ULL, 0x000fe20000004100ULL, 0x00000010ff6e7819ULL, 0x000fe2000001166eULL,
0x2000007bff7b7230ULL, 0x000fe20000004100ULL, 0x00000010ff727819ULL, 0x000fc40000011672ULL,
0x00001054006f7816ULL, 0x000fe4000000006fULL, 0x00000010ff677819ULL, 0x000fe40000011667ULL,
0x00000010ff007819ULL, 0x000fe40000011668ULL, 0x00000010ff777819ULL, 0x000fe40000011677ULL,
0x00000010ff697819ULL, 0x000fe40000011679ULL, 0x000000ff4c4c7812ULL, 0x000fc400078ec0ffULL,
0x00000008ff4e7819ULL, 0x000fe4000001164eULL, 0x000010546e6e7816ULL, 0x000fe40000000072ULL,
0x0000105467687816ULL, 0x000fe40000000077ULL, 0x0000105400697816ULL, 0x000fe40000000069ULL,
0x0000004cff4c723eULL, 0x000fe200020006ffULL, 0x0000006e4834723cULL, 0x000be20000041834ULL,
0x0000004eff4e723eULL, 0x000fc400020006ffULL, 0x00000010ff4f7819ULL, 0x000fe4000001164fULL,
0x00000010ff4d7819ULL, 0x000fe2000001164dULL, 0x2000004eff677230ULL, 0x000fe20000004100ULL,
0x00000010ff7a7819ULL, 0x000fe2000001167aULL, 0x2000004cff6e7230ULL, 0x020fe20000004100ULL,
0x00000010ff7b7819ULL, 0x000fe4000001167bULL, 0x000010547a7a7816ULL, 0x000fe4000000004fULL,
0x000010547b7b7816ULL, 0x000fc4000000004dULL, 0x00000068484c723cULL, 0x040be2000004182cULL,
0x00000062ff62723eULL, 0x000fe200020006ffULL, 0x00000000032c783bULL, 0x020e620000000200ULL,
0x00000081ff53723eULL, 0x000fe400020006ffULL, 0x00000008ff817819ULL, 0x000fe2000001168eULL,
0x20000062ff637230ULL, 0x000fe20000004100ULL, 0x00000010ff657819ULL, 0x000fe20000011665ULL,
0x20000053ff537230ULL, 0x000fe20000004100ULL, 0x00000010ff667819ULL, 0x000fe20000011666ULL,
0x0000007a4804723cULL, 0x000fe20000041804ULL, 0x00000010ff7c7819ULL, 0x000fc4000001167cULL,
0x00000010ff7d7819ULL, 0x000fe4000001167dULL, 0x00000056ff56723eULL, 0x000fe400020006ffULL,
0x0000007eff7e723eULL, 0x000fe400020006ffULL, 0x00000081ff81723eULL, 0x000fe200020006ffULL,
0x20000056ff627230ULL, 0x000fe20000004100ULL, 0x00001054657c7816ULL, 0x000fe2000000007cULL,
0x2000007eff7e7230ULL, 0x000fe20000004100ULL, 0x00001054667d7816ULL, 0x000fe2000000007dULL,
0x20000081ff817230ULL, 0x000fe20000004100ULL, 0x00000008ff6d7819ULL, 0x000fc4000001166dULL,
0x00000010ff637819ULL, 0x000fe40000011663ULL, 0x00000010ff657819ULL, 0x000fe20000011680ULL,
0x0000007c480c723cULL, 0x000f62000004180cULL, 0x000000ff43437812ULL, 0x000fe400078ec0ffULL,
0x0000006dff6d723eULL, 0x000fe400020006ffULL, 0x00000008ff457819ULL, 0x000fe40000011645ULL,
0x00000008ff167819ULL, 0x000fe20000011616ULL, 0x2000006dff6d7230ULL, 0x000fe20000004100ULL,
0x00000084ff56723eULL, 0x000fc400020006ffULL, 0x0000105465657816ULL, 0x000fe20000000063ULL,
0x000000192c2c9231ULL, 0x082fe200003400ffULL, 0x00000043ff43723eULL, 0x000fe200020006ffULL,
0x20000056ff567230ULL, 0x000fe20000004100ULL, 0x00000010ff6a7819ULL, 0x000fe2000001166aULL,
0x000000192e2e9231ULL, 0x000fe200003400ffULL, 0x00000010ff6b7819ULL, 0x000fe2000001166bULL,
0x20000043ff437230ULL, 0x000fe20000004100ULL, 0x00000010ff767819ULL, 0x000fe20000011676ULL,
0x000000182d2d9231ULL, 0x080fe200003400ffULL, 0x00000010ff787819ULL, 0x000fe20000011678ULL,
0x000000182f2f9231ULL, 0x000fe200003400ffULL, 0x00000010ff647819ULL, 0x000fc40000011664ULL,
0x00000010ff7e7819ULL, 0x000fe4000001167eULL, 0x00000010ff617819ULL, 0x000fe40000011661ULL,
0x00000010ff007819ULL, 0x000fe40000011662ULL, 0x00000010ff7f7819ULL, 0x000fe4000001167fULL,
0x00000010ff637819ULL, 0x000fe40000011681ULL, 0x00000045ff45723eULL, 0x000fc400020006ffULL,
0x00000016ff16723eULL, 0x000fe400020006ffULL, 0x00001054766a7816ULL, 0x000fe2000000006aULL,
0x20000045ff457230ULL, 0x000fe20000004100ULL, 0x00001054786b7816ULL, 0x000fe2000000006bULL,
0x20000016ff167230ULL, 0x000fe20000004100ULL, 0x000010547e647816ULL, 0x000fe40000000064ULL,
0x0000105461627816ULL, 0x000fe4000000007fULL, 0x0000105400637816ULL, 0x000fe20000000063ULL,
0x0000006a4830723cULL, 0x000f620000041830ULL, 0x00000010ff5d7819ULL, 0x000fc4000001165dULL,
0x00000010ff6d7819ULL, 0x000fe4000001166dULL, 0x00000010ff567819ULL, 0x000fe40000011656ULL,
0x00000010ff437819ULL, 0x000fe20000011643ULL, 0x000000644808723cULL, 0x000f620000041808ULL,
0x000000ff83837812ULL, 0x000fe400078ec0ffULL, 0x00000008ff6c7819ULL, 0x000fe4000001166cULL,
0x00000008ff5b7819ULL, 0x000fc4000001165bULL, 0x000000ff5c5c7812ULL, 0x000fe200078ec0ffULL,
0x000000624810723cULL, 0x000b620000041810ULL, 0x000000ff1d1d7812ULL, 0x000fe400078ec0ffULL,
0x000000ff14147812ULL, 0x000fe400078ec0ffULL, 0x00000008ff157819ULL, 0x000fe40000011615ULL,
0x00000008ff027819ULL, 0x000fe40000011602ULL, 0x000010545d487816ULL, 0x020fc4000000006dULL,
0x00000010ff537819ULL, 0x000fe40000011653ULL, 0x00000010ff457819ULL, 0x000fe40000011645ULL,
0x00000010ff547819ULL, 0x000fe40000011654ULL, 0x00000010ff037819ULL, 0x000fe40000011616ULL,
0x00001054435d7816ULL, 0x000fe40000000056ULL, 0x00000085ff47723eULL, 0x000fc400020006ffULL,
0x00000086ff46723eULL, 0x000fe400020006ffULL, 0x00000082ff82723eULL, 0x000fe200020006ffULL,
0x20000047ff477230ULL, 0x000fe20000004100ULL, 0x00000083ff83723eULL, 0x000fe200020006ffULL,
0x20000046ff467230ULL, 0x000fe20000004100ULL, 0x0000006cff6c723eULL, 0x000fe200020006ffULL,
0x20000082ff827230ULL, 0x000fe20000004100ULL, 0x0000005bff5b723eULL, 0x000fe200020006ffULL,
0x20000083ff837230ULL, 0x000fe20000004100ULL, 0x0000005cff5c723eULL, 0x000fe200020006ffULL,
0x2000006cff6c7230ULL, 0x000fe20000004100ULL, 0x0000001dff1d723eULL, 0x000fe200020006ffULL,
0x2000005bff5b7230ULL, 0x000fe20000004100ULL, 0x00000014ff14723eULL, 0x000fe200020006ffULL,
0x2000005cff5c7230ULL, 0x000fe20000004100ULL, 0x00000015ff15723eULL, 0x000fe200020006ffULL,
0x2000001dff1d7230ULL, 0x000fe20000004100ULL, 0x00000002ff43723eULL, 0x000fe200020006ffULL,
0x20000014ff147230ULL, 0x000fe20000004100ULL, 0x0000105453027816ULL, 0x000fe20000000045ULL,
0x20000015ff007230ULL, 0x000fe20000004100ULL, 0x0000105454037816ULL, 0x000fe20000000003ULL,
0x20000043ff437230ULL, 0x000fe20000004100ULL, 0x00000010ff597819ULL, 0x000fc40000011659ULL,
0x00000010ff707819ULL, 0x000fe40000011670ULL, 0x00000010ff607819ULL, 0x000fe20000011660ULL,
0x000000022c0c723cULL, 0x000b62000004180cULL, 0x0000105470707816ULL, 0x000fe40000000059ULL,
0x00000010ff5f7819ULL, 0x000fe4000001165fULL, 0x00000010ff827819ULL, 0x000fe40000011682ULL,
0x00000010ff617819ULL, 0x000fc40000011683ULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x00000010ff497819ULL, 0x000fe4000001166cULL, 0x00000010ff5a7819ULL, 0x000fe4000001165aULL,
0x00000010ff6e7819ULL, 0x000fe4000001166eULL, 0x00000010ff587819ULL, 0x000fe40000011658ULL,
0x00000010ff577819ULL, 0x000fc40000011657ULL, 0x00000010ff677819ULL, 0x000fe40000011667ULL,
0x00000010ff597819ULL, 0x000fe4000001165bULL, 0x00000010ff557819ULL, 0x000fe40000011655ULL,
0x00000010ff5c7819ULL, 0x000fe4000001165cULL, 0x00000010ff477819ULL, 0x000fe40000011647ULL,
0x00000010ff1d7819ULL, 0x000fc4000001161dULL, 0x00000010ff157819ULL, 0x000fe40000011646ULL,
0x00000010ff167819ULL, 0x000fe40000011614ULL, 0x00000010ff1e7819ULL, 0x000fe4000001161eULL,
0x00000010ff007819ULL, 0x000fe40000011600ULL, 0x00000010ff527819ULL, 0x000fe40000011652ULL,
0x00000010ff037819ULL, 0x020fc40000011643ULL, 0x0000105482607816ULL, 0x000fe40000000060ULL,
0x0000105461617816ULL, 0x000fe4000000005fULL, 0x000010545e497816ULL, 0x000fe40000000049ULL,
0x000010546e717816ULL, 0x000fe4000000005aULL, 0x0000105458587816ULL, 0x000fe20000000067ULL,
0x000000602c38723cULL, 0x000b620000041838ULL, 0x0000105457597816ULL, 0x000fc40000000059ULL,
0x000010545c5c7816ULL, 0x000fe40000000055ULL, 0x000010541d147816ULL, 0x000fe40000000047ULL,
0x0000105416157816ULL, 0x000fe20000000015ULL, 0x000000482c34723cULL, 0x000b620000041834ULL,
0x000010541e027816ULL, 0x000fe40000000000ULL, 0x0000105452037816ULL, 0x000fca0000000003ULL,
0x000000702c30723cULL, 0x040b700000041830ULL, 0x000000582c4c723cULL, 0x040b70000004184cULL,
0x0000005c2c04723cULL, 0x040b700000041804ULL, 0x000000142c08723cULL, 0x040b700000041808ULL,
0x000000022c10723cULL, 0x000b620000041810ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff2c7f8cULL, 0x020e62000c80043fULL, 0x000000ffff167224ULL, 0x000fce00078e00ffULL,
0x0000000000027805ULL, 0x000fc40000015200ULL, 0x0106bc00ff007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x006fc4000780482dULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001402147210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e03ULL, 0x003d09001400780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401400780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011415ULL,
0x0000001400007211ULL, 0x000fca00078110ffULL, 0x000000ffff147224ULL, 0x000fca00000e0615ULL,
0x0000000200007819ULL, 0x000fc80000001214ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000116167810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106bc00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe4000780482dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000221007810ULL, 0x000fc80007ffe0ffULL, 0x000000260000720cULL, 0x000fe20003f06070ULL,
0x0000580024007a24ULL, 0x010fc800078e02ffULL, 0x0000004000147824ULL, 0x000fd000078e00ffULL,
0x0000045000008947ULL, 0x000fea0003800000ULL, 0x000000c03c3c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000125027824ULL, 0x000fe200078e0217ULL, 0x00000002172f7810ULL, 0x040fe40007ffe0ffULL,
0x0000000417437810ULL, 0x040fe20007ffe0ffULL, 0x0000000102037824ULL, 0x000fe200078e022aULL,
0x0000003c28007217ULL, 0x000fe20007800000ULL, 0x00000010022e7824ULL, 0x000fe200078e00ffULL,
0x0000000617467810ULL, 0x000fe20007ffe0ffULL, 0x0000000125157824ULL, 0x040fe400078e022fULL,
0x0000000125167824ULL, 0x000fe200078e0243ULL, 0xfffffff02e2e7812ULL, 0x000fe200078ee203ULL,
0x0000000100007824ULL, 0x000fc400078e0a3cULL, 0x0000004029027824ULL, 0x000fe200078e0202ULL,
0x0000c0002e2e7811ULL, 0x000fe200078e20ffULL, 0x0000000115037824ULL, 0x100fe200078e022aULL,
0x0000000025007217ULL, 0x000fe20007800000ULL, 0x00000010153c7824ULL, 0x000fe200078e00ffULL,
0x00000014022c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000116157824ULL, 0x000fe200078e022aULL,
0x00000004021d7810ULL, 0x000fe20007ffe0ffULL, 0x0000001016457824ULL, 0x000fe200078e00ffULL,
0xfffffff03c3c7812ULL, 0x000fe200078ee203ULL, 0x0000000100007824ULL, 0x000fe200078e0a25ULL,
0x0000000202037810ULL, 0x000fc40007ffe0ffULL, 0xfffffff045457812ULL, 0x000fe200078ee215ULL,
0x0000000125157824ULL, 0x000fe200078e0246ULL, 0x00000006021e7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff027224ULL, 0x000fe200000e06ffULL, 0x0000001403037210ULL, 0x080fe20007f9e0ffULL,
0x00000001152d7824ULL, 0x000fe200078e022aULL, 0x000000141d1d7210ULL, 0x080fe20007f7e0ffULL,
0x0000001015477824ULL, 0x000fe200078e00ffULL, 0x00005e002c167a11ULL, 0x000fe200078440ffULL,
0x000000ffff157224ULL, 0x000fe200020e06ffULL, 0x000000141e147210ULL, 0x000fc40007f1e0ffULL,
0x00005f002c2c7a11ULL, 0x000fe200010f4402ULL, 0x000000ffff027224ULL, 0x000fe200018e06ffULL,
0x000000001700720cULL, 0x000fe40003f46070ULL, 0xfffffff047477812ULL, 0x000fe400078ee22dULL,
0x00005e00031e7a11ULL, 0x000fe400078840ffULL, 0x00005e001d177a11ULL, 0x000fe400078640ffULL,
0x000000f01f2d7812ULL, 0x000fc400078ec0ffULL, 0x00005f00031f7a11ULL, 0x000fe200020f4415ULL,
0x000000ffff157224ULL, 0x000fe200000e06ffULL, 0x00005f001d1d7a11ULL, 0x000fe400018f4402ULL,
0x0000002d16027210ULL, 0x000fe40007fbe0ffULL, 0x00005e0014167a11ULL, 0x000fe400078c40ffULL,
0x000000002f00720cULL, 0x080fe20003f86070ULL, 0x000000ffff037224ULL, 0x000fe200028e062cULL,
0x000000004300720cULL, 0x000fc40003f66070ULL, 0x000000004600720cULL, 0x000fe40003f06070ULL,
0x00005f0014007a11ULL, 0x000fe200030f4415ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000022e7faeULL, 0x0003e2000d101c46ULL, 0x0000002d1e147210ULL, 0x080fe40007fbe0ffULL,
0x0000c0003c3c7811ULL, 0x000fe400078e20ffULL, 0x0000c00045457811ULL, 0x000fe200078e20ffULL,
0x000000ffff157224ULL, 0x000fe200028e061fULL, 0x0000002d16167210ULL, 0x000fc40007fbe0ffULL,
0x0000c00047477811ULL, 0x000fe400078e20ffULL, 0x00000000143c7faeULL, 0x0005e2000e101c46ULL,
0x0000002d17027210ULL, 0x002fe20007f5e0ffULL, 0x000000ffff177224ULL, 0x000fc800028e0600ULL,
0x000000ffff037224ULL, 0x000fca00010e061dULL, 0x0000000002457faeULL, 0x0005e8000d901c46ULL,
0x0000000016477faeULL, 0x0005e2000c101c46ULL, 0x0000038000007947ULL, 0x000fea0003800000ULL,
0x0000000125177824ULL, 0x000fe200078e0217ULL, 0x000000f01f1f7812ULL, 0x000fc600078ec0ffULL,
0x0000000117007824ULL, 0x140fe200078e022aULL, 0x0000000217027810ULL, 0x040fe20007ffe0ffULL,
0x0000001017157824ULL, 0x040fe200078e00ffULL, 0x0000000417167810ULL, 0x040fe40007ffe0ffULL,
0x00000006171e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000102037824ULL, 0x040fe200078e022aULL,
0xfffffff015157812ULL, 0x000fe200078ee200ULL, 0x00000010022c7824ULL, 0x000fe400078e00ffULL,
0x0000004029007824ULL, 0x000fe200078e0217ULL, 0x0000c00015157811ULL, 0x000fe200078e20ffULL,
0x00000001161d7824ULL, 0x100fe200078e022aULL, 0xfffffff02c2c7812ULL, 0x000fe200078ee203ULL,
0x00000010162f7824ULL, 0x000fe200078e00ffULL, 0x0000001400027210ULL, 0x000fe20007f1e0ffULL,
0x000000011e2e7824ULL, 0x000fe200078e022aULL, 0x0000000200037810ULL, 0x000fe20007ffe0ffULL,
0x000000101e467824ULL, 0x000fe200078e00ffULL, 0x0000000400177810ULL, 0x000fc40007ffe0ffULL,
0x00000006002d7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff007224ULL, 0x000fe200000e06ffULL,
0x0000001403167210ULL, 0x080fe40007f5e0ffULL, 0x00005e0002037a11ULL, 0x040fe400078040ffULL,
0x00000014171e7210ULL, 0x080fe40007f7e0ffULL, 0x000000142d3c7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff147224ULL, 0x000fe200010e06ffULL, 0x00005f0002007a11ULL, 0x000fe200000f4400ULL,
0x000000ffff2d7224ULL, 0x000fe200018e06ffULL, 0x0000001f03027210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff437224ULL, 0x000fe200020e06ffULL, 0x00005e0016177a11ULL, 0x000fc400078440ffULL,
0xfffffff046467812ULL, 0x000fe200078ee22eULL, 0x000000ffff037224ULL, 0x000fe200000e0600ULL,
0x00005e001e2e7a11ULL, 0x000fe400078640ffULL, 0xfffffff02f2f7812ULL, 0x000fe400078ee21dULL,
0x00005e003c457a11ULL, 0x000fe200078840ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002157faeULL, 0x0003e2000b901c46ULL, 0x00005f00161d7a11ULL, 0x000fe400010f4414ULL,
0x0000001f17147210ULL, 0x000fc40007f1e0ffULL, 0x00005f001e2d7a11ULL, 0x000fe400018f442dULL,
0x0000001f2e167210ULL, 0x080fe40007f5e0ffULL, 0x00005f003c437a11ULL, 0x000fe400020f4443ULL,
0x0000001f451e7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff157224ULL, 0x002fe200000e061dULL,
0x0000c0002c2c7811ULL, 0x000fe200078e20ffULL, 0x000000ffff177224ULL, 0x000fe200010e062dULL,
0x0000c0002f2f7811ULL, 0x000fe200078e20ffULL, 0x000000ffff1f7224ULL, 0x000fe200018e0643ULL,
0x0000c00046467811ULL, 0x000fe200078e20ffULL, 0x00000000142c7faeULL, 0x0003e8000b901c46ULL,
0x00000000162f7faeULL, 0x0003e8000b901c46ULL, 0x000000001e467faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff027f8cULL, 0x004ea4000c80043fULL, 0x000000ffff437224ULL, 0x004fc400078e0003ULL,
0x0000000000027805ULL, 0x000fca0000015200ULL, 0x0106b400ff007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fc40007804851ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff167224ULL, 0x002fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001402147210ULL, 0x000fca0007f1e1ffULL, 0x0000000115157824ULL, 0x000fe200000e0e03ULL,
0x003d09001400780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401400780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011415ULL, 0x0000001400007211ULL, 0x000fca00078110ffULL,
0x000000ffff147224ULL, 0x000fca00000e0615ULL, 0x0000000200007819ULL, 0x000fc80000001214ULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000116167810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106b400ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007804851ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000014000007945ULL, 0x000fe20003800000ULL,
0x0000012000001947ULL, 0x000fea0003800000ULL, 0x0000001aff00723eULL, 0x000fe400000010ffULL,
0x00000002ff027819ULL, 0x000fe4000001162aULL, 0x0000541000007816ULL, 0x000fe20000000000ULL,
0x000089d27f007947ULL, 0x000fea000b800000ULL, 0x00001f0200197589ULL, 0x0002a400000e0000ULL,
0x0000000802187810ULL, 0x000fe20007ffe0ffULL, 0x00008a027f007947ULL, 0x000fea000b800000ULL,
0x00001f1800187589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001002477810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff5a7224ULL, 0x000fe200078e0000ULL,
0x0001484000467802ULL, 0x000fc40000000f00ULL, 0x00008ec000007944ULL, 0x00efea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001802477810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff5a7224ULL, 0x004fe200078e0000ULL, 0x0001489000467802ULL, 0x000fc40000000f00ULL,
0x00008e7000007944ULL, 0x00afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000000411c783bULL, 0x000f220000004200ULL,
0x0000b8003f3f7811ULL, 0x000fc600078e20ffULL, 0x00000000402c783bULL, 0x000ee80000004200ULL,
0x000000004248783bULL, 0x000ea80000004200ULL, 0x000000003d14783bULL, 0x000e620000004200ULL,
0x00000010ff6d7819ULL, 0x010fe4000001161dULL, 0x000000ff1d537812ULL, 0x000fc400078ec0ffULL,
0x00000018ff527819ULL, 0x000fe4000001161dULL, 0x0000ffff1d7f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff6f7819ULL, 0x100fe4000001161eULL, 0x000000ff1e547812ULL, 0x040fe400078ec0ffULL,
0x00000018ff1d7819ULL, 0x000fe4000001161eULL, 0x0000ffff1e807812ULL, 0x000fc400078ec0ffULL,
0x000000ff1f557812ULL, 0x040fe400078ec0ffULL, 0x000000ff2c007812ULL, 0x00afe400078ec0ffULL,
0x00000010ff727819ULL, 0x100fe4000001161fULL, 0x00000018ff1e7819ULL, 0x000fe4000001161fULL,
0x0000ffff1f817812ULL, 0x000fe400078ec0ffULL, 0x00000018ff1f7819ULL, 0x004fc40000011648ULL,
0x00000010ff417819ULL, 0x000fe4000001162cULL, 0x00000010ff677819ULL, 0x100fe4000001162fULL,
0x000000ff2f477812ULL, 0x040fe400078ec0ffULL, 0x00000018ff467819ULL, 0x000fe4000001162fULL,
0x0000ffff2f7d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5f7819ULL, 0x000fc4000001162dULL,
0x00000010ff6b7819ULL, 0x100fe4000001161cULL, 0x000000ff1c517812ULL, 0x040fe400078ec0ffULL,
0x00000018ff2f7819ULL, 0x000fe4000001161cULL, 0x0000ffff1c7e7812ULL, 0x000fe400078ec0ffULL,
0x00000055ff55723eULL, 0x000fe400020006ffULL, 0x00000000ff1c723eULL, 0x000fc400020006ffULL,
0x00000052ff52723eULL, 0x000fe200020006ffULL, 0x20000055ff587230ULL, 0x000fe20000004100ULL,
0x0000001dff1d723eULL, 0x000fe200020006ffULL, 0x2000001cff5e7230ULL, 0x000fe20000004100ULL,
0x0000001eff1e723eULL, 0x000fe200020006ffULL, 0x20000052ff5b7230ULL, 0x000fe20000004100ULL,
0x0000001fff1f723eULL, 0x000fe200020006ffULL, 0x2000001dff557230ULL, 0x000fe20000004100ULL,
0x0000ffff2c7a7812ULL, 0x000fe200078ec0ffULL, 0x2000001eff567230ULL, 0x000fe20000004100ULL,
0x000000ff41417812ULL, 0x000fe200078ec0ffULL, 0x2000001fff527230ULL, 0x000fe20000004100ULL,
0x0000ffff2d7b7812ULL, 0x000fc400078ec0ffULL, 0x000000ff5f5f7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff1d7819ULL, 0x000fe4000001167aULL, 0x00000041ff1c723eULL, 0x000fe400020006ffULL,
0x000000ff49637812ULL, 0x000fe400078ec0ffULL, 0x0000005fff1e723eULL, 0x000fe200020006ffULL,
0x2000001cff5f7230ULL, 0x000fe20000004100ULL, 0x00000008ff1f7819ULL, 0x000fc4000001167bULL,
0x00000010ff647819ULL, 0x100fe4000001162eULL, 0x000000ff2e457812ULL, 0x040fe400078ec0ffULL,
0x00000018ff427819ULL, 0x000fe4000001162eULL, 0x0000ffff2e7c7812ULL, 0x000fe400078ec0ffULL,
0x00000054ff54723eULL, 0x000fe400020006ffULL, 0x00000010ff737819ULL, 0x000fc40000011648ULL,
0x000000ff48607812ULL, 0x040fe200078ec0ffULL, 0x20000054ff577230ULL, 0x000fe20000004100ULL,
0x0000ffff48827812ULL, 0x000fe400078ec0ffULL, 0x00000010ff507819ULL, 0x100fe40000011614ULL,
0x000000ff14707812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6e7819ULL, 0x000fe40000011614ULL,
0x0000ffff142e7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff487819ULL, 0x000fe40000011649ULL,
0x00000053ff14723eULL, 0x000fe400020006ffULL, 0x0000001dff1d723eULL, 0x000fe400020006ffULL,
0x00000063ff53723eULL, 0x000fe200020006ffULL, 0x2000001eff637230ULL, 0x000fe20000004100ULL,
0x0000001fff1f723eULL, 0x000fe200020006ffULL, 0x20000014ff147230ULL, 0x000fe20000004100ULL,
0x000000ff641c7812ULL, 0x000fe200078ec0ffULL, 0x20000053ff537230ULL, 0x000fe20000004100ULL,
0x000000ff67677812ULL, 0x000fe200078ec0ffULL, 0x2000001fff647230ULL, 0x000fe20000004100ULL,
0x00000008ff1e7819ULL, 0x000fc4000001167cULL, 0x00000060ff54723eULL, 0x000fe200020006ffULL,
0x2000001dff607230ULL, 0x000fe20000004100ULL, 0x00000048ff48723eULL, 0x000fe400020006ffULL,
0x000000ff2d407812ULL, 0x000fe200078ec0ffULL, 0x20000054ff547230ULL, 0x000fe20000004100ULL,
0x00000018ff3d7819ULL, 0x000fe4000001162dULL, 0x00000018ff6a7819ULL, 0x000fe4000001164bULL,
0x0000001cff1d723eULL, 0x000fc400020006ffULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x000000ff4a687812ULL, 0x000fe400078ec0ffULL, 0x00000010ff2d7819ULL, 0x100fe40000011615ULL,
0x000000ff15747812ULL, 0x040fe400078ec0ffULL, 0x00000018ff717819ULL, 0x000fe40000011615ULL,
0x0000ffff151b7812ULL, 0x000fc400078ec0ffULL, 0x0000001eff1e723eULL, 0x000fe400020006ffULL,
0x0000b8003e1c7811ULL, 0x000fe200078e20ffULL, 0x2000001dff3e7230ULL, 0x000fe20000004100ULL,
0x00000008ff1f7819ULL, 0x000fe4000001167dULL, 0x00000051ff15723eULL, 0x000fe200020006ffULL,
0x20000048ff517230ULL, 0x000fe20000004100ULL, 0x00000010ff757819ULL, 0x000fe40000011649ULL,
0x0000ffff49837812ULL, 0x000fe200078ec0ffULL, 0x20000015ff157230ULL, 0x000fe20000004100ULL,
0x00000010ff5d7819ULL, 0x000fc4000001164aULL, 0x00000018ff497819ULL, 0x000fe4000001164aULL,
0x0000ffff4a5a7812ULL, 0x000fe400078ec0ffULL, 0x0000006aff48723eULL, 0x000fe200020006ffULL,
0x20000067ff6a7230ULL, 0x000fe20000004100ULL, 0x00000068ff4a723eULL, 0x000fe200020006ffULL,
0x2000001eff687230ULL, 0x000fe20000004100ULL, 0x0000001fff67723eULL, 0x000fe200020006ffULL,
0x20000048ff487230ULL, 0x000fe20000004100ULL, 0x000000001c1c783bULL, 0x000e620000000200ULL,
0x00000045ff45723eULL, 0x000fe200020006ffULL, 0x2000004aff4a7230ULL, 0x000fe20000004100ULL,
0x00000010ff027819ULL, 0x000fc40000011617ULL, 0x000000ff17797812ULL, 0x000fe200078ec0ffULL,
0x20000045ff667230ULL, 0x000fe20000004100ULL, 0x0000006eff45723eULL, 0x000fe400020006ffULL,
0x000000ff6d6e7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff6d7819ULL, 0x000fe2000001167eULL,
0x20000045ff457230ULL, 0x000fe20000004100ULL, 0x0000006eff6e723eULL, 0x000fe400020006ffULL,
0x00000018ff787819ULL, 0x000fc40000011617ULL, 0x0000ffff17007812ULL, 0x000fe400078ec0ffULL,
0x0000006dff6d723eULL, 0x000fe400020006ffULL, 0x000000ff4b6c7812ULL, 0x000fe400078ec0ffULL,
0x00000046ff17723eULL, 0x000fe400020006ffULL, 0x00000070ff46723eULL, 0x000fe400020006ffULL,
0x00000047ff47723eULL, 0x000fe200020006ffULL, 0x20000017ff177230ULL, 0x000fe20000004100ULL,
0x000000ff6f707812ULL, 0x000fe200078ec0ffULL, 0x2000006eff6f7230ULL, 0x000fe20000004100ULL,
0x00000018ff3c7819ULL, 0x000fe2000001162cULL, 0x2000006dff6e7230ULL, 0x000fe20000004100ULL,
0x0000006cff6c723eULL, 0x000fe200020006ffULL, 0x20000047ff697230ULL, 0x000fe20000004100ULL,
0x000000ff72727812ULL, 0x000fe200078ec0ffULL, 0x20000046ff467230ULL, 0x000fe20000004100ULL,
0x0000002fff2f723eULL, 0x000fc400020006ffULL, 0x00000008ff6d7819ULL, 0x000fe20000011680ULL,
0x000000191c1c9231ULL, 0x082fe200003400ffULL, 0x00000010ff2c7819ULL, 0x100fe20000011616ULL,
0x2000002fff597230ULL, 0x000fe20000004100ULL, 0x000000ff16777812ULL, 0x040fe200078ec0ffULL,
0x000000191e1e9231ULL, 0x000fe200003400ffULL, 0x00000018ff767819ULL, 0x000fe20000011616ULL,
0x000000181d1d9231ULL, 0x080fe200003400ffULL, 0x0000ffff16037812ULL, 0x000fe200078ec0ffULL,
0x000000181f1f9231ULL, 0x000fe200003400ffULL, 0x0000003cff3c723eULL, 0x000fc400020006ffULL,
0x00000042ff16723eULL, 0x000fe400020006ffULL, 0x00000049ff47723eULL, 0x000fe200020006ffULL,
0x2000006cff497230ULL, 0x000fe20000004100ULL, 0x00000072ff72723eULL, 0x000fe200020006ffULL,
0x2000003cff617230ULL, 0x000fe20000004100ULL, 0x0000006dff6d723eULL, 0x000fe200020006ffULL,
0x20000016ff167230ULL, 0x000fe20000004100ULL, 0x000000ff6b6c7812ULL, 0x000fe200078ec0ffULL,
0x20000067ff6b7230ULL, 0x000fe20000004100ULL, 0x00000074ff2f723eULL, 0x000fe200020006ffULL,
0x20000047ff477230ULL, 0x000fe20000004100ULL, 0x00000008ff677819ULL, 0x000fc4000001167fULL,
0x000000ff73747812ULL, 0x000fe200078ec0ffULL, 0x20000072ff737230ULL, 0x000fe20000004100ULL,
0x00000010ff667819ULL, 0x000fe20000011666ULL, 0x2000006dff727230ULL, 0x000fe20000004100ULL,
0x00000010ff3e7819ULL, 0x000fe2000001163eULL, 0x2000002fff2f7230ULL, 0x000fe20000004100ULL,
0x00000076ff3c723eULL, 0x000fe400020006ffULL, 0x000000ff75767812ULL, 0x000fe400078ec0ffULL,
0x0000006cff6c723eULL, 0x000fe200020006ffULL, 0x2000003cff3c7230ULL, 0x000fe20000004100ULL,
0x00000008ff6d7819ULL, 0x000fc40000011682ULL, 0x00000040ff40723eULL, 0x000fe200020006ffULL,
0x2000006cff6c7230ULL, 0x000fe20000004100ULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x000010543e667816ULL, 0x000fe20000000066ULL, 0x20000040ff627230ULL, 0x000fe20000004100ULL,
0x00000010ff3e7819ULL, 0x000fe40000011617ULL, 0x00000076ff76723eULL, 0x000fe400020006ffULL,
0x00000010ff167819ULL, 0x000fc40000011616ULL, 0x00000010ff687819ULL, 0x000fe40000011668ULL,
0x00000010ff177819ULL, 0x000fe4000001166bULL, 0x00000071ff42723eULL, 0x000fe400020006ffULL,
0x0000006dff6d723eULL, 0x000fe400020006ffULL, 0x00000070ff71723eULL, 0x000fe200020006ffULL,
0x20000067ff707230ULL, 0x000fe20000004100ULL, 0x00000077ff40723eULL, 0x000fe200020006ffULL,
0x20000076ff777230ULL, 0x000fe20000004100ULL, 0x00000008ff677819ULL, 0x000fe20000011681ULL,
0x2000006dff767230ULL, 0x000fe20000004100ULL, 0x0000105416167816ULL, 0x000fe20000000068ULL,
0x20000071ff717230ULL, 0x000fe20000004100ULL, 0x000010543e177816ULL, 0x000fe20000000017ULL,
0x20000042ff427230ULL, 0x000fe20000004100ULL, 0x00000010ff157819ULL, 0x000fe20000011615ULL,
0x20000040ff407230ULL, 0x000fe20000004100ULL, 0x00000010ff147819ULL, 0x000fc40000011614ULL,
0x00000010ff6c7819ULL, 0x000fe2000001166cULL, 0x000000161c4c723cULL, 0x000be2000004184cULL,
0x00000010ff6d7819ULL, 0x000fe4000001166fULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x000010546c6c7816ULL, 0x000fe40000000015ULL, 0x000010546d6d7816ULL, 0x000fe40000000014ULL,
0x00000074ff75723eULL, 0x000fe200020006ffULL, 0x000000003f14783bULL, 0x0202a20000000200ULL,
0x20000067ff747230ULL, 0x000fe20000004100ULL, 0x0000003dff3d723eULL, 0x000fc400020006ffULL,
0x00000008ff677819ULL, 0x000fe20000011683ULL, 0x0000006c1c04723cULL, 0x000fe20000041804ULL,
0x00000010ff5e7819ULL, 0x000fe2000001165eULL, 0x2000003dff657230ULL, 0x000fe20000004100ULL,
0x00000010ff5f7819ULL, 0x000fe2000001165fULL, 0x20000075ff757230ULL, 0x000fe20000004100ULL,
0x00000010ff627819ULL, 0x000fe40000011662ULL, 0x00000010ff637819ULL, 0x000fe40000011663ULL,
0x00000067ff67723eULL, 0x000fc400020006ffULL, 0x000000ff50507812ULL, 0x000fe400078ec0ffULL,
0x00000010ff3f7819ULL, 0x002fe40000011658ULL, 0x00000010ff737819ULL, 0x000fe40000011673ULL,
0x000010545f5e7816ULL, 0x000fe4000000005eULL, 0x00001054635f7816ULL, 0x000fe40000000062ULL,
0x000000ff5d627812ULL, 0x000fe200078ec0ffULL, 0x20000067ff5d7230ULL, 0x000fe20000004100ULL,
0x00000050ff3e723eULL, 0x000fc400020006ffULL, 0x00000010ff617819ULL, 0x000fe20000011661ULL,
0x0000005e1c38723cULL, 0x000f620000041838ULL, 0x00000010ff607819ULL, 0x000fe20000011660ULL,
0x2000003eff587230ULL, 0x000fe20000004100ULL, 0x00001054733f7816ULL, 0x000fe4000000003fULL,
0x00000010ff657819ULL, 0x000fe40000011665ULL, 0x00000010ff647819ULL, 0x000fe40000011664ULL,
0x00000010ff677819ULL, 0x000fe20000011669ULL, 0x0000001914149231ULL, 0x084fe200003400ffULL,
0x00000010ff6a7819ULL, 0x000fe2000001166aULL, 0x0000001916169231ULL, 0x000fe200003400ffULL,
0x00000010ff597819ULL, 0x000fe20000011659ULL, 0x0000001815159231ULL, 0x080fe200003400ffULL,
0x00000010ff5b7819ULL, 0x000fe2000001165bULL, 0x0000001817179231ULL, 0x000fe200003400ffULL,
0x00000010ff6e7819ULL, 0x000fc4000001166eULL, 0x00000010ff6f7819ULL, 0x000fe40000011670ULL,
0x00000010ff577819ULL, 0x000fe40000011657ULL, 0x00000010ff717819ULL, 0x000fe40000011671ULL,
0x00000010ff557819ULL, 0x000fe40000011655ULL, 0x00000010ff567819ULL, 0x000fe40000011656ULL,
0x00000010ff727819ULL, 0x000fc40000011672ULL, 0x00000010ff737819ULL, 0x000fe40000011674ULL,
0x0000105461607816ULL, 0x000fe40000000060ULL, 0x0000105465617816ULL, 0x000fe40000000064ULL,
0x000010546a677816ULL, 0x000fe40000000067ULL, 0x00000008ff5a7819ULL, 0x000fe4000001165aULL,
0x00001054596e7816ULL, 0x000fe2000000006eULL, 0x000000601c34723cULL, 0x000f620000041834ULL,
0x000010545b6f7816ULL, 0x000fc4000000006fULL, 0x00001054713e7816ULL, 0x000fe40000000057ULL,
0x0000105455727816ULL, 0x000fe40000000072ULL, 0x0000105456737816ULL, 0x000fe20000000073ULL,
0x000000661c30723cULL, 0x000f620000041830ULL, 0x00000010ff5c7819ULL, 0x000fe4000001164bULL,
0x000000ff2d2d7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff4b4b7812ULL, 0x000fc400078ec0ffULL,
0x0000005aff5a723eULL, 0x000fe200020006ffULL, 0x0000006e1c0c723cULL, 0x040f62000004180cULL,
0x0000002dff2d723eULL, 0x000fe400020006ffULL, 0x000000ff5c5c7812ULL, 0x000fe200078ec0ffULL,
0x2000005aff5a7230ULL, 0x000fe20000004100ULL, 0x00000008ff4b7819ULL, 0x000fe4000001164bULL,
0x00000008ff2e7819ULL, 0x000fe2000001162eULL, 0x0000003e1c08723cULL, 0x000b620000041808ULL,
0x00000008ff1b7819ULL, 0x000fc4000001161bULL, 0x000000ff2c2c7812ULL, 0x000fe400078ec0ffULL,
0x000000ff02027812ULL, 0x000fe400078ec0ffULL, 0x00000008ff037819ULL, 0x000fe20000011603ULL,
0x000000721c10723cULL, 0x000b620000041810ULL, 0x00000008ff007819ULL, 0x000fe20000011600ULL,
0x2000002dff3f7230ULL, 0x020fe20000004100ULL, 0x00000079ff3d723eULL, 0x000fe400020006ffULL,
0x00000078ff78723eULL, 0x000fc400020006ffULL, 0x00000062ff62723eULL, 0x000fe200020006ffULL,
0x2000003dff3d7230ULL, 0x000fe20000004100ULL, 0x0000005cff5c723eULL, 0x000fe200020006ffULL,
0x20000078ff417230ULL, 0x000fe20000004100ULL, 0x0000004bff4b723eULL, 0x000fe200020006ffULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x0000002eff2e723eULL, 0x000fe200020006ffULL,
0x2000005cff5c7230ULL, 0x000fe20000004100ULL, 0x0000001bff1b723eULL, 0x000fe200020006ffULL,
0x2000004bff507230ULL, 0x000fe20000004100ULL, 0x0000002cff2c723eULL, 0x000fe200020006ffULL,
0x2000002eff3e7230ULL, 0x000fe20000004100ULL, 0x00000002ff02723eULL, 0x000fe200020006ffULL,
0x2000001bff1b7230ULL, 0x000fe20000004100ULL, 0x00000003ff03723eULL, 0x000fe200020006ffULL,
0x2000002cff1c7230ULL, 0x000fe20000004100ULL, 0x00000000ff00723eULL, 0x000fe200020006ffULL,
0x20000002ff027230ULL, 0x000fe20000004100ULL, 0x00000010ff477819ULL, 0x000fe20000011647ULL,
0x20000003ff037230ULL, 0x000fe20000004100ULL, 0x00000010ff5a7819ULL, 0x000fe2000001165aULL,
0x20000000ff007230ULL, 0x000fe20000004100ULL, 0x00000010ff537819ULL, 0x000fc40000011653ULL,
0x00000010ff557819ULL, 0x000fe40000011677ULL, 0x00000010ff2f7819ULL, 0x000fe4000001162fULL,
0x00000010ff3f7819ULL, 0x000fe4000001163fULL, 0x00001054472c7816ULL, 0x000fe4000000005aULL,
0x0000105455557816ULL, 0x000fe40000000053ULL, 0x000010543f477816ULL, 0x000fc4000000002fULL,
0x00000010ff1d7819ULL, 0x000fe4000001163dULL, 0x00000010ff547819ULL, 0x000fe40000011654ULL,
0x00000010ff757819ULL, 0x000fe40000011675ULL, 0x00000010ff527819ULL, 0x000fe40000011652ULL,
0x00000010ff517819ULL, 0x000fe40000011651ULL, 0x00000010ff767819ULL, 0x000fc40000011676ULL,
0x00000010ff537819ULL, 0x000fe4000001165dULL, 0x00000010ff4a7819ULL, 0x000fe4000001164aULL,
0x00000010ff497819ULL, 0x000fe40000011649ULL, 0x00000010ff627819ULL, 0x000fe40000011662ULL,
0x00000010ff4b7819ULL, 0x000fe4000001165cULL, 0x00000010ff487819ULL, 0x000fc40000011648ULL,
0x00000010ff2d7819ULL, 0x000fe40000011650ULL, 0x00000010ff467819ULL, 0x000fe40000011646ULL,
0x00000010ff587819ULL, 0x000fe40000011658ULL, 0x00000010ff457819ULL, 0x000fe40000011645ULL,
0x00000010ff3e7819ULL, 0x000fe4000001163eULL, 0x00000010ff3f7819ULL, 0x000fc40000011642ULL,
0x00000010ff1b7819ULL, 0x000fe4000001161bULL, 0x00000010ff407819ULL, 0x000fe40000011640ULL,
0x00000010ff1c7819ULL, 0x000fe4000001161cULL, 0x00000010ff027819ULL, 0x000fe40000011602ULL,
0x00000010ff3c7819ULL, 0x000fe4000001163cULL, 0x00000010ff037819ULL, 0x000fc40000011603ULL,
0x00000010ff3d7819ULL, 0x000fe40000011641ULL, 0x00000010ff007819ULL, 0x000fe40000011600ULL,
0x0000105475547816ULL, 0x000fe40000000054ULL, 0x0000105452527816ULL, 0x000fe40000000076ULL,
0x0000105451537816ULL, 0x000fe40000000053ULL, 0x00001054624a7816ULL, 0x000fe2000000004aULL,
0x000000541438723cULL, 0x000b620000041838ULL, 0x000010544b4b7816ULL, 0x000fc40000000049ULL,
0x00001054482d7816ULL, 0x000fe4000000002dULL, 0x0000105458467816ULL, 0x000fe40000000046ULL,
0x00001054453e7816ULL, 0x000fe2000000003eULL, 0x000000521434723cULL, 0x000b620000041834ULL,
0x000010543f3f7816ULL, 0x000fe4000000001bULL, 0x000010541c1c7816ULL, 0x000fe40000000040ULL,
0x00001054021d7816ULL, 0x000fc4000000001dULL, 0x000010543c3c7816ULL, 0x000fe20000000003ULL,
0x0000004a1430723cULL, 0x000b620000041830ULL, 0x000010543d3d7816ULL, 0x000fce0000000000ULL,
0x0000002c142c723cULL, 0x040b70000004184cULL, 0x000000461404723cULL, 0x040b700000041804ULL,
0x0000003e140c723cULL, 0x040b70000004180cULL, 0x0000001c1408723cULL, 0x040b700000041808ULL,
0x0000003c1410723cULL, 0x000b620000041810ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff027f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a000ffff7f8cULL, 0x000fe2000c80043fULL,
0x00000004204f7810ULL, 0x020fe20007ffe0ffULL, 0x000000ffff4a7224ULL, 0x002fc400078e0003ULL,
0x0000000121217810ULL, 0x000fc80007ffe0ffULL, 0x000000262100720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xfffeb1d000007947ULL, 0x000fea000383ffffULL,
0x000000ff2600720cULL, 0x000fe20003f05270ULL, 0x000000ffff1f7224ULL, 0x000fe400078e0013ULL,
0x000000ffff1e7224ULL, 0x000fe400078e0012ULL, 0x000000ffff177224ULL, 0x008fe400078e000fULL,
0x000000ffff167224ULL, 0x000fe400078e000eULL, 0x000000ffff1d7224ULL, 0x000fe400078e0011ULL,
0x000000ffff1c7224ULL, 0x000fc400078e0010ULL, 0x000000ffff1b7224ULL, 0x000fe400078e000bULL,
0x000000ffff1a7224ULL, 0x000fe400078e000aULL, 0x000000ffff197224ULL, 0x000fe400078e0009ULL,
0x000000ffff187224ULL, 0x000fe400078e0008ULL, 0x000000ffff157224ULL, 0x000fe400078e000dULL,
0x000000ffff147224ULL, 0x000fc400078e000cULL, 0x000000ffff137224ULL, 0x000fe400078e0007ULL,
0x000000ffff127224ULL, 0x000fe400078e0006ULL, 0x000000ffff0f7224ULL, 0x000fe400078e0005ULL,
0x000000ffff0e7224ULL, 0x000fe200078e0004ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x0180000023007810ULL, 0x000fe20007ffe0ffULL, 0x000000c000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x002fe200078e0023ULL,
0x0001618000037802ULL, 0x000fc40000000f00ULL, 0x000073b000007944ULL, 0x004fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000002300007308ULL, 0x000ee40000001000ULL,
0xbf80000000237423ULL, 0x008fc80000000023ULL, 0x800000ff23237221ULL, 0x000fc80000010100ULL,
0x0000002300007223ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006800ff027624ULL, 0x002fe400078e00ffULL, 0x00006900ff037624ULL, 0x000fca00078e00ffULL,
0x0000000602027981ULL, 0x000328000c1e9900ULL, 0x0000000000037919ULL, 0x002e640000000000ULL,
0x00000002ff047819ULL, 0x002fe40000011603ULL, 0x0000000803037811ULL, 0x000fe200078ff0ffULL,
0x0000000002007220ULL, 0x018fca0000410000ULL, 0x00001f0400027589ULL, 0x000e6800000e0000ULL,
0x00001f0300007589ULL, 0x000ee200000e0000ULL, 0x0000003802387220ULL, 0x042fe20000410000ULL,
0x0000003902397220ULL, 0x040fe20000410000ULL, 0x0000003402347220ULL, 0x040fe20000410000ULL,
0x0000003502357220ULL, 0x040fe20000410000ULL, 0x0000003002307220ULL, 0x040fe20000410000ULL,
0x0000003102317220ULL, 0x040fe20000410000ULL, 0x0000002c022c7220ULL, 0x040fe20000410000ULL,
0x0000002d022d7220ULL, 0x040fe20000410000ULL, 0x0000000e020e7220ULL, 0x040fe20000410000ULL,
0x0000000f020f7220ULL, 0x040fe20000410000ULL, 0x0000001402147220ULL, 0x040fe20000410000ULL,
0x0000001502157220ULL, 0x040fe20000410000ULL, 0x0000001802187220ULL, 0x040fe20000410000ULL,
0x0000001902197220ULL, 0x040fe20000410000ULL, 0x0000001c021c7220ULL, 0x040fe20000410000ULL,
0x0000001d021d7220ULL, 0x000fe20000410000ULL, 0x0000003a003a7220ULL, 0x048fe20000410000ULL,
0x0000003b003b7220ULL, 0x040fe20000410000ULL, 0x0000003600367220ULL, 0x040fe20000410000ULL,
0x0000003700377220ULL, 0x040fe20000410000ULL, 0x0000003200327220ULL, 0x040fe20000410000ULL,
0x0000003300337220ULL, 0x040fe20000410000ULL, 0x0000002e002e7220ULL, 0x040fe20000410000ULL,
0x0000002f002f7220ULL, 0x040fe20000410000ULL, 0x0000001200127220ULL, 0x040fe20000410000ULL,
0x0000001300137220ULL, 0x040fe20000410000ULL, 0x0000001600167220ULL, 0x040fe20000410000ULL,
0x0000001700177220ULL, 0x040fe20000410000ULL, 0x0000001a001a7220ULL, 0x040fe20000410000ULL,
0x0000001b001b7220ULL, 0x040fe20000410000ULL, 0x0000001e001e7220ULL, 0x040fe20000410000ULL,
0x0000001f001f7220ULL, 0x000fc20000410000ULL, 0x0000000000207919ULL, 0x000ee20000000000ULL,
0x0000a0002b2b7811ULL, 0x000fe200078e58ffULL, 0x00000000000579c3ULL, 0x000f220000002700ULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x00000002ff037819ULL, 0x00afc40000011620ULL,
0x0000000220007812ULL, 0x040fe200078ec0ffULL, 0x00000005040472a4ULL, 0x010fe2000f8e023fULL,
0x0000000820047811ULL, 0x000fe200078ff0ffULL, 0x0000000803067824ULL, 0x040fe200078e00ffULL,
0x0000000300027211ULL, 0x040fe200078ff8ffULL, 0x0000000803097824ULL, 0x040fe200078e00ffULL,
0x0000000400057211ULL, 0x000fe200078ff8ffULL, 0x0000000804087824ULL, 0x000fe200078e00ffULL,
0x0000000402047810ULL, 0x040fe20007ffe0ffULL, 0x0000000803077824ULL, 0x040fe200078e00ffULL,
0x0000000202007810ULL, 0x000fe20007ffe0ffULL, 0x00000008030a7824ULL, 0x000fe200078e00ffULL,
0xfffffff806037812ULL, 0x000fc400078ee202ULL, 0xfffffff809067812ULL, 0x000fe200078ee204ULL,
0x0000000820047824ULL, 0x000fe200078e00ffULL, 0x0000000602027810ULL, 0x000fe20007ffe0ffULL,
0x0000001003037824ULL, 0x000fe200078e022bULL, 0xfffffff808087812ULL, 0x000fe200078ee205ULL,
0x0000001006067824ULL, 0x100fe200078e022bULL, 0xfffffff807057812ULL, 0x000fe400078ee200ULL,
0xfffffff80a077812ULL, 0x000fe200078ee202ULL, 0x0000001008087824ULL, 0x100fe200078e022bULL,
0x0000000804047812ULL, 0x000fe200078ec0ffULL, 0x0000001005057824ULL, 0x000fe200078e022bULL,
0x000000383900723eULL, 0x000fc400000010ffULL, 0x000000343502723eULL, 0x000fe200000010ffULL,
0x0000000103037824ULL, 0x000fe200078e0204ULL, 0x00000003ff0b7819ULL, 0x000fe20000011620ULL,
0x00000001040a7824ULL, 0x000fe200078e0208ULL, 0x00005410000c7816ULL, 0x000fe20000000002ULL,
0x0000000104087824ULL, 0x000fe200078e0206ULL, 0x00007632000d7816ULL, 0x000fe20000000002ULL,
0x000000010b027824ULL, 0x000fe200078e0220ULL, 0x0000002020107810ULL, 0x000fe20007ffe0ffULL,
0x0000001007007824ULL, 0x000fe400078e022bULL, 0x0000000c03007388ULL, 0x0003e20000000a00ULL,
0x00000003ff117819ULL, 0x000fe20000011610ULL, 0x0000000104077824ULL, 0x000fc400078e0205ULL,
0x0000000104097824ULL, 0x000fe200078e0200ULL, 0x000000303100723eULL, 0x000fe400000010ffULL,
0x000000141504723eULL, 0x000fe400000010ffULL, 0x0000000702037812ULL, 0x002fe200078ec0ffULL,
0x00000001100c7824ULL, 0x000fe200078e0211ULL, 0x0000002c2d02723eULL, 0x000fe400000010ffULL,
0x0ffffff803057812ULL, 0x000fe400078ef820ULL, 0x0000000e0f03723eULL, 0x000fc400000010ffULL,
0x00005410000e7816ULL, 0x140fe40000000002ULL, 0x00007632000f7816ULL, 0x000fe40000000002ULL,
0x000000070c0c7812ULL, 0x000fe400078ec0ffULL, 0x0000541003027816ULL, 0x140fe20000000004ULL,
0x0000000e07007388ULL, 0x000fe20000000a00ULL, 0x0000763203037816ULL, 0x000fe40000000004ULL,
0x0ffffff80c067812ULL, 0x000fe200078ef810ULL, 0x00000010050c7824ULL, 0x100fe200078e022bULL,
0x000000181900723eULL, 0x000fe200000010ffULL, 0x0000000208007388ULL, 0x0003e20000000a00ULL,
0x000000363704723eULL, 0x000fe200000010ffULL, 0x00000010062b7824ULL, 0x000fe200078e022bULL,
0x000000323305723eULL, 0x000fc400000010ffULL, 0x0000002e2f06723eULL, 0x000fe400000010ffULL,
0x0000000720207812ULL, 0x000fe400078ec0ffULL, 0x0000000710107812ULL, 0x000fe400078ec0ffULL,
0x0000001c1d02723eULL, 0x002fe400000010ffULL, 0x0000003a3b03723eULL, 0x000fe400000010ffULL,
0x00005410000e7816ULL, 0x000fc40000000002ULL, 0x00007632000f7816ULL, 0x000fe40000000002ULL,
0x0000541003027816ULL, 0x140fe40000000004ULL, 0x0000763203037816ULL, 0x000fe20000000004ULL,
0x0000000e09007388ULL, 0x000fe20000000a00ULL, 0x0000541005047816ULL, 0x140fe40000000006ULL,
0x0000763205057816ULL, 0x000fe20000000006ULL, 0x000000020a007388ULL, 0x0003e20000000a00ULL,
0x000000121300723eULL, 0x000fc400000010ffULL, 0x1ffffff810107812ULL, 0x000fe200078ef825ULL,
0x0004000407007388ULL, 0x0007e20000000a00ULL, 0x000000161702723eULL, 0x002fe400000010ffULL,
0x0000001a1b03723eULL, 0x000fe200000010ffULL, 0x0000000000057919ULL, 0x008e620000002600ULL,
0x0000001e1f04723eULL, 0x000fe400000010ffULL, 0x0000541000067816ULL, 0x140fe40000000002ULL,
0x0000763200077816ULL, 0x000fc40000000002ULL, 0x0000541003027816ULL, 0x140fe40000000004ULL,
0x0000763203037816ULL, 0x000fe20000000004ULL, 0x0004000608007388ULL, 0x000fe80000000a00ULL,
0x0004000209007388ULL, 0x0007e20000000a00ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000000000c0c7984ULL, 0x000f220000000c00ULL, 0x0000000805007824ULL, 0x002fc600078e00ffULL,
0x000000002b287984ULL, 0x000e620000000c00ULL, 0x0000000805057824ULL, 0x000fe200078e00ffULL,
0xfffffff8000b7812ULL, 0x000fc800078ee20bULL, 0xfffffff805117812ULL, 0x000fe400078ee211ULL,
0x000000040b0b7c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000411117c10ULL, 0x000fc6000ff3e0ffULL,
0x000000ffff007224ULL, 0x000fe200000e06ffULL, 0x00005a000b027a11ULL, 0x008fe200078048ffULL,
0x000000ffff057224ULL, 0x000fe200008e06ffULL, 0x00005a0011047a11ULL, 0x000fe400078248ffULL,
0x00005b000b037a11ULL, 0x000fe400000f4c00ULL, 0x1ffffff820007812ULL, 0x000fe400078ef825ULL,
0x00005b0011057a11ULL, 0x000fc600008f4c05ULL, 0x0000001000027825ULL, 0x000fc800078e0002ULL,
0x0000001010047825ULL, 0x000fe200078e0004ULL, 0x0000000c02007986ULL, 0x010fe8000c101d06ULL,
0x0000002804007986ULL, 0x002fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x000000272b00720cULL, 0x000fe20003f06070ULL, 0xffffffffff007424ULL, 0x000fd800078e00ffULL,
0x0000000214028824ULL, 0x000fc800078e00ffULL, 0x0000640002028a24ULL, 0x000fc800078e022bULL,
0x0000600002028625ULL, 0x000fe200078e0006ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00006800ff067624ULL, 0x000fe200078e00ffULL, 0x0000000602008981ULL, 0x0002a2000c1e1900ULL,
0x00006900ff077624ULL, 0x000fc600078e00ffULL, 0x01060000ff047f8cULL, 0x000ee8000c80043fULL,
0x0000000606067981ULL, 0x000522000c1e9900ULL, 0x000001ff0800780cULL, 0x000fe20003f04070ULL,
0x0000000604047899ULL, 0x000fe2000800063fULL, 0x000000402b027824ULL, 0x002fe400078e00ffULL,
0x0000004029037824ULL, 0x000fc600078e00ffULL, 0x0000000400197c24ULL, 0x004fcc000f8e02ffULL,
0x0000071000000947ULL, 0x000fea0003800000ULL, 0x00000002ff167819ULL, 0x008fe4000001162aULL,
0x000000300b187812ULL, 0x000fe400078ec0ffULL, 0x000020002b0f7811ULL, 0x000fe200078e68ffULL,
0x0000004029297824ULL, 0x000fca00078e0216ULL, 0x0000000829077810ULL, 0x040fe40007ffe0ffULL,
0x0000001029087810ULL, 0x000fe40007ffe0ffULL, 0x0000000719077210ULL, 0x040fe40007f3e0ffULL,
0x0000000819087210ULL, 0x040fe40007f5e0ffULL, 0x0000002919117210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff157224ULL, 0x000fe200008e06ffULL, 0x00005e00070a7a11ULL, 0x000fe200078240ffULL,
0x000000ffff0d7224ULL, 0x000fe200010e06ffULL, 0x0000001829097810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x00005e00080c7a11ULL, 0x000fc400078440ffULL,
0x00005f0007157a11ULL, 0x000fe400008f4415ULL, 0x0000000919097210ULL, 0x000fe40007f7e0ffULL,
0x00005e0011107a11ULL, 0x000fe400078040ffULL, 0x00005f00080d7a11ULL, 0x000fe200010f440dULL,
0x000000ffff137224ULL, 0x000fe200018e06ffULL, 0x0000000228077217ULL, 0x000fe40007800000ULL,
0x0000002a2a087211ULL, 0x000fc400078fe8ffULL, 0x00005f0011117a11ULL, 0x000fe200000f440eULL,
0x0000000107077824ULL, 0x000fe200078e0a02ULL, 0x00000003080e7812ULL, 0x000fe400078ec0ffULL,
0x00005e0009127a11ULL, 0x040fe400078640ffULL, 0x0000000816087810ULL, 0x040fe40007ffe0ffULL,
0x00005f0009137a11ULL, 0x000fe400018f4413ULL, 0x000000071600720cULL, 0x000fe20003f06070ULL,
0x00000004080b7824ULL, 0x000fe200078e00ffULL, 0x0000001016097810ULL, 0x000fc40007ffe0ffULL,
0x000000070800720cULL, 0x080fe40003f26070ULL, 0x0000001018087210ULL, 0x000fe20007f7e0ffULL,
0x0000000409107824ULL, 0x040fe200078e00ffULL, 0x0ffffffc0e2a7812ULL, 0x000fe400078ef82aULL,
0x000000070900720cULL, 0x000fe20003f46070ULL, 0x000000ffff097224ULL, 0x000fe200018e0611ULL,
0xfffffffc0b0b7812ULL, 0x000fe200078ee20eULL, 0x000000102a2a7824ULL, 0x000fe200078e020fULL,
0x000000180a0a7210ULL, 0x000fc40007f7e0ffULL, 0xfffffffc10117812ULL, 0x000fe200078ee20eULL,
0x000000100b107824ULL, 0x000fe200078e020fULL, 0x000000180c0c7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200018e0615ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000082a7faeULL, 0x0003e2000c101c46ULL, 0x0000001011117824ULL, 0x000fe400078e020fULL,
0x000000ffff0d7224ULL, 0x000fe200020e060dULL, 0x000000000a107faeULL, 0x0005e8000c901c46ULL,
0x000000000c117faeULL, 0x0007e2000d101c46ULL, 0x0000001816097810ULL, 0x002fc40007ffe0ffULL,
0x0000002029087810ULL, 0x000fe40007ffe0ffULL, 0x000000070900720cULL, 0x040fe20003f86070ULL,
0x00000004090a7824ULL, 0x004fe200078e00ffULL, 0x0000000819177210ULL, 0x000fe40007f1e0ffULL,
0x00000020160b7810ULL, 0x040fe40007ffe0ffULL, 0x00000028160c7810ULL, 0x048fe20007ffe0ffULL,
0x000000ffff097224ULL, 0x000fe200000e06ffULL, 0x00000030160d7810ULL, 0x000fc40007ffe0ffULL,
0x0000003816117810ULL, 0x000fe40007ffe0ffULL, 0x00005e0017167a11ULL, 0x040fe400078c40ffULL,
0x0000001812087210ULL, 0x000fe40007fbe0ffULL, 0xfffffffc0a0a7812ULL, 0x000fe400078ee20eULL,
0x00005f0017177a11ULL, 0x000fe200030f4409ULL, 0x000000ffff097224ULL, 0x000fe200028e0613ULL,
0x000000070b00720cULL, 0x080fe20003f66070ULL, 0x000000100a0a7824ULL, 0x000fe200078e020fULL,
0x000000070c00720cULL, 0x000fc40003f46070ULL, 0x000000070d00720cULL, 0x080fe40003f26070ULL,
0x000000071100720cULL, 0x000fe20003f06070ULL, 0x00000000080a7faeULL, 0x0003e2000e101c46ULL,
0x0000002829077810ULL, 0x000fe20007ffe0ffULL, 0x0000000411117824ULL, 0x000fe200078e00ffULL,
0x0000003029107810ULL, 0x000fe40007ffe0ffULL, 0x0000000719157210ULL, 0x000fe20007fbe0ffULL,
0x000000040b077824ULL, 0x000fe200078e00ffULL, 0x0000003829297810ULL, 0x000fc40007ffe0ffULL,
0x0000001019137210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200028e06ffULL,
0xfffffffc07077812ULL, 0x100fe200078ee20eULL, 0x000000040c087824ULL, 0x002fe200078e00ffULL,
0x00005e00150a7a11ULL, 0x000fe200078a40ffULL, 0x000000040d097824ULL, 0x000fe200078e00ffULL,
0x0000002919297210ULL, 0x000fe20007fde0ffULL, 0x000000ffff0d7224ULL, 0x000fe200020e06ffULL,
0xfffffffc08087812ULL, 0x100fe200078ee20eULL, 0x0000001007077824ULL, 0x000fe200078e020fULL,
0xfffffffc09097812ULL, 0x000fc400078ee20eULL, 0x00005f00150b7a11ULL, 0x000fe200028f440bULL,
0x0000001008107824ULL, 0x100fe200078e020fULL, 0x0000001816087210ULL, 0x080fe40007fbe0ffULL,
0xfffffffc110e7812ULL, 0x000fe200078ee20eULL, 0x0000001009117824ULL, 0x000fe200078e020fULL,
0x00005e00130c7a11ULL, 0x040fe200078840ffULL, 0x000000ffff097224ULL, 0x000fe200028e0617ULL,
0x000000180a0a7210ULL, 0x080fe20007fbe0ffULL, 0x000000100e127824ULL, 0x000fe200078e020fULL,
0x00005f00130d7a11ULL, 0x000fe200020f440dULL, 0x000000ffff0f7224ULL, 0x000fe200030e06ffULL,
0x00005e00290e7a11ULL, 0x040fe200078c40ffULL, 0x000000ffff0b7224ULL, 0x000fe200028e060bULL,
0x000000180c0c7210ULL, 0x000fe20007f9e0ffULL, 0x0000000008077faeULL, 0x0003e2000d901c46ULL,
0x00005f00290f7a11ULL, 0x000fc400030f440fULL, 0x000000180e0e7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff0d7224ULL, 0x000fe200020e060dULL, 0x000000000a107faeULL, 0x0003e6000d101c46ULL,
0x000000ffff0f7224ULL, 0x000fe200028e060fULL, 0x000000000c117faeULL, 0x0003e8000c901c46ULL,
0x000000000e127faeULL, 0x0003e2000c101c46ULL, 0x0000065000007947ULL, 0x000fea0003800000ULL,
0x000000032a077211ULL, 0x048fe400078ff0ffULL, 0x000000102a087811ULL, 0x000fc400078ff0ffULL,
0x0000000719077210ULL, 0x000fe40007f1e0ffULL, 0x000000082a177811ULL, 0x040fe200078ff0ffULL,
0x0000000103097824ULL, 0x000fe200078e0208ULL, 0x000000182a0a7811ULL, 0x000fe200078ff0ffULL,
0x000000ffff247224ULL, 0x000fe200000e06ffULL, 0x00005e0007237a11ULL, 0x000fe200078040ffULL,
0x0000000408087824ULL, 0x000fe200078e00ffULL, 0x000000202a0d7811ULL, 0x040fe200078ff0ffULL,
0x00000001030c7824ULL, 0x000fe200078e020aULL, 0x00005f0007247a11ULL, 0x000fe200000f4424ULL,
0x0000000103077824ULL, 0x040fe200078e0217ULL, 0x0000002a2a167211ULL, 0x040fe200078fe8ffULL,
0x00000001030e7824ULL, 0x000fe200078e020dULL, 0x000000302a117811ULL, 0x000fc400078ff0ffULL,
0x0000000919207210ULL, 0x000fe20007fbe0ffULL, 0x000000040a097824ULL, 0x000fe200078e00ffULL,
0x000000282a0f7811ULL, 0x000fe200078ff0ffULL, 0x000000040d0a7824ULL, 0x000fe200078e00ffULL,
0x0000000719227210ULL, 0x000fe20007fde0ffULL, 0x00000004110d7824ULL, 0x000fe200078e00ffULL,
0x0000000316167812ULL, 0x000fe200078ec0ffULL, 0x0000000103107824ULL, 0x040fe200078e020fULL,
0x000000382a137811ULL, 0x000fe200078ff0ffULL, 0x0000000103127824ULL, 0x000fe200078e0211ULL,
0x0000000c191f7210ULL, 0x000fe20007f1e0ffULL, 0x000000040f0c7824ULL, 0x000fe200078e00ffULL,
0x000020002b1c7811ULL, 0x000fe200078e68ffULL, 0x000000ffff0f7224ULL, 0x000fe200030e06ffULL,
0xfffffffc09097812ULL, 0x100fe200078ee216ULL, 0x0000000103157824ULL, 0x000fe200078e0213ULL,
0xfffffffc08087812ULL, 0x000fe200078ee216ULL, 0x0000000417077824ULL, 0x000fe200078e00ffULL,
0x0000000e191e7210ULL, 0x000fe20007f3e0ffULL, 0x00000004130e7824ULL, 0x000fe200078e00ffULL,
0x00005e0022217a11ULL, 0x000fe200078c40ffULL, 0x0000001009137824ULL, 0x000fe200078e021cULL,
0xfffffffc0d0d7812ULL, 0x000fe200078ee216ULL, 0x0000001008117824ULL, 0x100fe200078e021cULL,
0x0000001019107210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff097224ULL, 0x000fe200000e06ffULL,
0x0000001219127210ULL, 0x000fe20007f7e0ffULL, 0x000000100d1b7824ULL, 0x000fe200078e021cULL,
0x00005f0022227a11ULL, 0x000fe200030f440fULL, 0x000000ffff087224ULL, 0x000fe200008e06ffULL,
0x0000001519197210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff177224ULL, 0x000fe200018e06ffULL,
0xfffffffc0a0a7812ULL, 0x000fe200078ee216ULL, 0x000000ffff1d7224ULL, 0x000fe200010e06ffULL,
0x00005e001f0f7a11ULL, 0x000fc400078040ffULL, 0xfffffffc0c0c7812ULL, 0x000fe200078ee216ULL,
0x000000100a157824ULL, 0x100fe200078e021cULL, 0x00005e001e0d7a11ULL, 0x000fe200078240ffULL,
0x000000ffff0a7224ULL, 0x000fe200028e06ffULL, 0x000000300b257812ULL, 0x000fe200078ec0ffULL,
0x000000100c1a7824ULL, 0x000fe200078e021cULL, 0x00005f001f1f7a11ULL, 0x000fe200000f4409ULL,
0x000000ffff097224ULL, 0x000fe200020e06ffULL, 0x00005f001e1e7a11ULL, 0x000fe400008f4408ULL,
0x00005e0019187a11ULL, 0x000fc400078640ffULL, 0x0000002325087210ULL, 0x000fe40007f1e0ffULL,
0x0ffffffc162a7812ULL, 0x000fe400078ef82aULL, 0xfffffffc07077812ULL, 0x000fe400078ee216ULL,
0x00005e00200c7a11ULL, 0x000fe200078a40ffULL, 0x000000102a2a7824ULL, 0x000fe200078e021cULL,
0xfffffffc0e0e7812ULL, 0x000fe200078ee216ULL, 0x0000001007077824ULL, 0x000fe200078e021cULL,
0x00005e00100b7a11ULL, 0x000fc400078240ffULL, 0x00005e0012167a11ULL, 0x000fe200078440ffULL,
0x000000100e1c7824ULL, 0x000fe200078e021cULL, 0x00005f0019197a11ULL, 0x000fe200018f4409ULL,
0x000000ffff097224ULL, 0x000fe200000e0624ULL, 0x00005f0020207a11ULL, 0x000fe400028f440aULL,
0x00005f00101d7a11ULL, 0x000fe400008f441dULL, 0x00000021250a7210ULL, 0x000fe20007f1e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000082a7faeULL, 0x0003e2000b901c46ULL,
0x00005f0012177a11ULL, 0x000fc400010f4417ULL, 0x0000000c250c7210ULL, 0x040fe40007f3e0ffULL,
0x0000000f250e7210ULL, 0x040fe40007f5e0ffULL, 0x0000000b25127210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e0622ULL, 0x0000000d25107210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200008e0620ULL, 0x0000001625167210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff0f7224ULL, 0x000fe200010e061fULL, 0x0000001825187210ULL, 0x000fe20007f1e0ffULL,
0x000000000a077faeULL, 0x0003e4000b901c46ULL, 0x000000ffff177224ULL, 0x000fc400028e0617ULL,
0x000000000c117faeULL, 0x0005e2000b901c46ULL, 0x000000ffff197224ULL, 0x000fc600000e0619ULL,
0x000000000e137faeULL, 0x0007e2000b901c46ULL, 0x000000ffff117224ULL, 0x004fe400018e061eULL,
0x000000ffff137224ULL, 0x008fc600020e061dULL, 0x0000000010157faeULL, 0x0003e8000b901c46ULL,
0x00000000121a7faeULL, 0x0003e8000b901c46ULL, 0x00000000161b7faeULL, 0x0003e8000b901c46ULL,
0x00000000181c7faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000087805ULL, 0x002fc40000015200ULL, 0x01060400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fc40007804805ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a080a7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e09ULL,
0x003d09000a00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400a00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff077819ULL, 0x000fc8000001140bULL, 0x0000000a07077211ULL, 0x000fca00078110ffULL,
0x000000ffff0a7224ULL, 0x000fca00000e060bULL, 0x0000000207077819ULL, 0x000fc8000000120aULL,
0x000000070000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01060400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000047919ULL, 0x000e640000000000ULL,
0x000000202b047824ULL, 0x002fca00078e0204ULL, 0x00000003ff057819ULL, 0x000fe40000011604ULL,
0x0000000f04047812ULL, 0x000fe400078ec0ffULL, 0x1ffffffe05057812ULL, 0x000fe400078ec0ffULL,
0x0000000104077810ULL, 0x040fe20007ffe0ffULL, 0x00000020040b7824ULL, 0x040fe400078e00ffULL,
0x0000000104087824ULL, 0x040fe400078e0205ULL, 0x0000000105097824ULL, 0x040fe200078e0207ULL,
0x0000001005057810ULL, 0x000fe20007ffe0ffULL, 0x00000020040a7824ULL, 0x000fe200078e00ffULL,
0x0000001f08087812ULL, 0x000fc400078ec0ffULL, 0x0000001f09097812ULL, 0x000fe400078ec0ffULL,
0x000001e00a087812ULL, 0x000fe200078ee208ULL, 0x00000001040a7824ULL, 0x040fe200078e0205ULL,
0x000001e00b097812ULL, 0x000fe200078ee209ULL, 0x0000000107057824ULL, 0x000fe400078e0205ULL,
0x0000000008107984ULL, 0x000e62000000cc00ULL, 0x0000002004077824ULL, 0x000fe200078e00ffULL,
0x0000001f0a0a7812ULL, 0x000fe200078ec0ffULL, 0x0000002004047824ULL, 0x000fe200078e00ffULL,
0x00000000090c7984ULL, 0x000ea2000000cc00ULL, 0x0000001f05057812ULL, 0x000fc400078ec0ffULL,
0x000001e0070a7812ULL, 0x000fe400078ee20aULL, 0x000001e004057812ULL, 0x000fe200078ee205ULL,
0x000000ffff187224ULL, 0x002fe400078e0010ULL, 0x000000ffff197224ULL, 0x000fe400078e0012ULL,
0x000000ffff1b7224ULL, 0x004fe400078e000eULL, 0x000000ffff1a7224ULL, 0x000fe400078e000cULL,
0x000000ffff0e7224ULL, 0x000fc400078e000dULL, 0x000000ffff0c7224ULL, 0x000fe200078e0011ULL,
0x0000001808007388ULL, 0x000fe2000000cc00ULL, 0x000000ffff0d7224ULL, 0x000fca00078e0013ULL,
0x0000000c09007388ULL, 0x000fe8000000cc00ULL, 0x00000000050c7984ULL, 0x000e68000000cc00ULL,
0x000000000a107984ULL, 0x000ea2000000cc00ULL, 0x000000ffff1f7224ULL, 0x002fe400078e000eULL,
0x000000ffff1e7224ULL, 0x000fc400078e000cULL, 0x000000ffff0e7224ULL, 0x000fe400078e000dULL,
0x000000ffff1c7224ULL, 0x004fe400078e0010ULL, 0x000000ffff1d7224ULL, 0x000fe400078e0012ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0011ULL, 0x000000ffff0d7224ULL, 0x000fe200078e0013ULL,
0x0000001c0a007388ULL, 0x0003e8000000cc00ULL, 0x0000000c05007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01060000ff0a7f8cULL, 0x002e62000c80043fULL,
0x000000ffff0c7224ULL, 0x000fc600078e00ffULL, 0x0000000000047805ULL, 0x000fc80000015200ULL,
0x01060400ff077984ULL, 0x000ea40000000800ULL, 0x8000000007ff7812ULL, 0x006fc4000780480bULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fcc0000015200ULL,
0x0000000804087210ULL, 0x000fca0007f1e1ffULL, 0x0000000109097824ULL, 0x000fe200000e0e05ULL,
0x003d09000800780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400800780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff077819ULL, 0x000fc80000011409ULL, 0x0000000807077211ULL, 0x000fca00078110ffULL,
0x000000ffff087224ULL, 0x000fca00000e0609ULL, 0x0000000207077819ULL, 0x000fc80000001208ULL,
0x000000070000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01060400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe4000780480bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff2600720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000247919ULL, 0x000e620000000000ULL,
0x0000640014257a24ULL, 0x000fe200078e02ffULL, 0x3d80000006297820ULL, 0x010fe20000410000ULL,
0x000106882b2a7811ULL, 0x040fe200078e18ffULL, 0x000000ffff367224ULL, 0x000fe200078e00ffULL,
0xffffffff26347810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff387224ULL, 0x000fe200078e00ffULL,
0x000106082b357811ULL, 0x000fe200078e28ffULL, 0x000000ffff377224ULL, 0x000fc400078e002bULL,
0x0000010036397824ULL, 0x000fe200078e0202ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x000000392800720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x01cfea0003800000ULL,
0x000000ffff3a7224ULL, 0x000fe200078e0038ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x000000ffff3b7224ULL, 0x000fe200078e00ffULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fc4000001ff00ULL,
0x000000013b087810ULL, 0x020fe20007ffe0ffULL, 0x00000d6000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3c7224ULL, 0x000fe200078e003bULL, 0x000000013a387812ULL, 0x000fe200078e0cffULL,
0x0000000400457c24ULL, 0x010fe2000f8e02ffULL, 0x00000036080a7211ULL, 0x040fe200078ff0ffULL,
0x000000ffff3b7224ULL, 0x000fe200078e0008ULL, 0x000000040800780cULL, 0x000fc40003f06070ULL,
0x000000010a097810ULL, 0x000fe40007ffe0ffULL, 0x0000000308547812ULL, 0x000fe400078ec0ffULL,
0x000000260900720cULL, 0x000fda0003f26070ULL, 0x000006c000009947ULL, 0x000fea0003800000ULL,
0x00000002ff417819ULL, 0x002fe20000011624ULL, 0x000001000a097824ULL, 0x000fe400078e0202ULL,
0x000000022b477824ULL, 0x000fe200078e0238ULL, 0x00000010414e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000103087824ULL, 0x000fe200078e0241ULL, 0x0000000841467810ULL, 0x040fe40007ffe0ffULL,
0x00000018414f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000103107824ULL, 0x000fe200078e024eULL,
0x00000008453f7210ULL, 0x000fe20007f3e0ffULL, 0x00000001030a7824ULL, 0x000fe200078e0246ULL,
0x00000009280b7217ULL, 0x000fe20007800000ULL, 0x0000000446497824ULL, 0x000fe200078e00ffULL,
0x0000001045117210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff407224ULL, 0x000fe200008e06ffULL,
0x0000000a45137210ULL, 0x000fe20007f5e0ffULL, 0x000000010b3d7824ULL, 0x000fe200078e0a09ULL,
0x0000002041507810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff127224ULL, 0x000fe200018e06ffULL,
0x00005e0011107a11ULL, 0x000fe200078640ffULL, 0x000000ffff3e7224ULL, 0x000fe200010e06ffULL,
0x00005e00130a7a11ULL, 0x000fc400078440ffULL, 0x00005f0011117a11ULL, 0x000fe200018f4412ULL,
0x0000000103127824ULL, 0x000fe200078e024fULL, 0x0000002841517810ULL, 0x000fe40007ffe0ffULL,
0x00005e003f087a11ULL, 0x000fe400078240ffULL, 0x0000003041527810ULL, 0x040fe40007ffe0ffULL,
0x0000003841537810ULL, 0x000fe40007ffe0ffULL, 0x00005f00130b7a11ULL, 0x000fe200010f443eULL,
0x0000000103137824ULL, 0x000fe200078e0250ULL, 0x00005f003f097a11ULL, 0x000fe200008f4440ULL,
0x00000001033e7824ULL, 0x000fe200078e0251ULL, 0x0000001245447210ULL, 0x000fe20007f3e0ffULL,
0x00000001033f7824ULL, 0x000fe200078e0252ULL, 0x0000003d4100720cULL, 0x000fe20003f46070ULL,
0x0000000103407824ULL, 0x000fe200078e0253ULL, 0x0000001345427210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff137224ULL, 0x000fe200008e06ffULL, 0x0000003e45417210ULL, 0x000fc40007fde0ffULL,
0x00000024243e7211ULL, 0x000fe400078fe8ffULL, 0x00005e0044127a11ULL, 0x000fe200078240ffULL,
0x000000ffff4c7224ULL, 0x000fe200030e06ffULL, 0x0000003f45437210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff3f7224ULL, 0x000fe200028e06ffULL, 0x0000004045457210ULL, 0x000fe20007f7e0ffULL,
0x0000000454407824ULL, 0x000fe200078e00ffULL, 0x000000033e4d7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff4b7224ULL, 0x000fe200020e06ffULL, 0x00005f0044137a11ULL, 0x000fe200008f4413ULL,
0x000000ffff4a7224ULL, 0x000fe200018e06ffULL, 0x0000003d4600720cULL, 0x000fc40003f26070ULL,
0x0000200047477811ULL, 0x000fe400078e60ffULL, 0x0ffffffc4d487812ULL, 0x100fe400078ef824ULL,
0xfffffffc40467812ULL, 0x000fe400078ee224ULL, 0xfffffffc49497812ULL, 0x000fe200078ee24dULL,
0x0000001048487824ULL, 0x000fe200078e0247ULL, 0x00005e00423e7a11ULL, 0x000fe200078a40ffULL,
0x0000001046087825ULL, 0x000fe200078e0008ULL, 0x00005e0045447a11ULL, 0x000fc400078640ffULL,
0x00005f00423f7a11ULL, 0x000fe200028f443fULL, 0x0000001049497824ULL, 0x000fe200078e0247ULL,
0x00005e0041407a11ULL, 0x000fe200078a40ffULL, 0x00000010460a7825ULL, 0x000fe200078e000aULL,
0x00005e0043427a11ULL, 0x000fe200078840ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008487faeULL, 0x0003e2000d101c46ULL, 0x00005f0041417a11ULL, 0x000fe400028f444cULL,
0x00005f0043437a11ULL, 0x000fe200020f444bULL, 0x000000000a497faeULL, 0x0005e2000c901c46ULL,
0x00005f0045457a11ULL, 0x000fe200018f444aULL, 0x00000004514a7824ULL, 0x000fe200078e00ffULL,
0x0000003d4e00720cULL, 0x080fe20003f26070ULL, 0x00000004524b7824ULL, 0x000fe200078e00ffULL,
0x0000003d4f00720cULL, 0x000fc40003f46070ULL, 0x0000003d5000720cULL, 0x080fe20003f66070ULL,
0x000000044f487824ULL, 0x002fe200078e00ffULL, 0x0000003d5100720cULL, 0x080fe20003f86070ULL,
0x0000001046087825ULL, 0x000fe200078e0010ULL, 0x0000003d5200720cULL, 0x080fe40003fa6070ULL,
0x0000003d5300720cULL, 0x040fe20003fc6070ULL, 0x000000044e3d7824ULL, 0x000fe200078e00ffULL,
0xfffffffc48487812ULL, 0x100fe200078ee24dULL, 0x0000000450497824ULL, 0x004fe200078e00ffULL,
0xfffffffc4a4a7812ULL, 0x100fe200078ee24dULL, 0x0000000453537824ULL, 0x000fe200078e00ffULL,
0xfffffffc3d3d7812ULL, 0x000fe200078ee24dULL, 0x0000001048487824ULL, 0x000fe200078e0247ULL,
0xfffffffc49497812ULL, 0x000fe200078ee24dULL, 0x00000010460a7825ULL, 0x000fe200078e0012ULL,
0xfffffffc4b4b7812ULL, 0x000fc400078ee24dULL, 0xfffffffc534d7812ULL, 0x000fe200078ee24dULL,
0x000000103d3d7824ULL, 0x100fe400078e0247ULL, 0x0000001049497824ULL, 0x000fe400078e0247ULL,
0x0000001046107825ULL, 0x000fe200078e003eULL, 0x00000000083d7faeULL, 0x0003e6000c901c46ULL,
0x000000104a4a7824ULL, 0x000fe200078e0247ULL, 0x000000000a487faeULL, 0x0003e2000d101c46ULL,
0x0000001046127825ULL, 0x000fc600078e0040ULL, 0x0000000010497faeULL, 0x0003e2000d901c46ULL,
0x000000104b4b7824ULL, 0x000fe400078e0247ULL, 0x00000010463e7825ULL, 0x040fe200078e0042ULL,
0x00000000124a7faeULL, 0x0003e6000e101c46ULL, 0x000000104d477824ULL, 0x000fe200078e0247ULL,
0x000000003e4b7faeULL, 0x0003e2000e901c46ULL, 0x0000001046407825ULL, 0x000fca00078e0044ULL,
0x0000000040477faeULL, 0x0003e2000f101c46ULL, 0x000005f000007947ULL, 0x000fea0003800000ULL,
0x00000008243e7811ULL, 0x002fe200078ff0ffULL, 0x0000000454507824ULL, 0x000fe200078e00ffULL,
0x0000000324097211ULL, 0x040fe400078ff0ffULL, 0x0000001024407811ULL, 0x000fe200078ff0ffULL,
0x00000001030b7824ULL, 0x000fe200078e023eULL, 0x0000004509097210ULL, 0x080fe20007f3e0ffULL,
0x000000043e3e7824ULL, 0x000fe200078e00ffULL, 0x0000001824427811ULL, 0x040fe400078ff0ffULL,
0x000000450b0b7210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff117224ULL, 0x000fe200008e06ffULL,
0x00005e0009087a11ULL, 0x000fe200078240ffULL, 0x0000000103137824ULL, 0x040fe200078e0242ULL,
0x0000002024447811ULL, 0x040fe200078ff0ffULL, 0x000000ffff107224ULL, 0x000fe200010e06ffULL,
0x0000002824467811ULL, 0x000fe200078ff0ffULL, 0x0000000442427824ULL, 0x000fe200078e00ffULL,
0x0000003024477811ULL, 0x040fe200078ff0ffULL, 0x00000001033f7824ULL, 0x040fe200078e0244ULL,
0x0000003824487811ULL, 0x040fe200078ff0ffULL, 0x0000000103417824ULL, 0x000fe200078e0246ULL,
0x00005e000b0a7a11ULL, 0x000fe200078440ffULL, 0x0000000103437824ULL, 0x000fe200078e0247ULL,
0x00005f0009097a11ULL, 0x000fe200008f4411ULL, 0x0000000103117824ULL, 0x000fe200078e0240ULL,
0x00005f000b0b7a11ULL, 0x000fe200010f4410ULL, 0x00000001033d7824ULL, 0x000fe200078e0248ULL,
0x0000002424127211ULL, 0x000fe200078fe8ffULL, 0x000000022b107824ULL, 0x000fe200078e0238ULL,
0x0000004511117210ULL, 0x080fe20007fde0ffULL, 0x0000000446497824ULL, 0x000fe200078e00ffULL,
0x0000004513137210ULL, 0x080fe20007fbe0ffULL, 0x0000000444447824ULL, 0x000fe200078e00ffULL,
0x000000453f3f7210ULL, 0x080fe20007f9e0ffULL, 0x00000004474a7824ULL, 0x000fe200078e00ffULL,
0x0000004541417210ULL, 0x080fe20007f3e0ffULL, 0x00000004484c7824ULL, 0x000fe200078e00ffULL,
0x0000004543437210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff4f7224ULL, 0x000fe200020e06ffULL,
0x000000453d457210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff4e7224ULL, 0x000fe200008e06ffULL,
0x00000003123d7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff127224ULL, 0x000fe200030e06ffULL,
0x00002000104b7811ULL, 0x000fe200078e60ffULL, 0x0000000440107824ULL, 0x000fe200078e00ffULL,
0xfffffffc3e407812ULL, 0x000fe200078ee23dULL, 0x000000ffff4d7224ULL, 0x000fe200010e06ffULL,
0x0ffffffc3d3e7812ULL, 0x000fc400078ef824ULL, 0xfffffffc10467812ULL, 0x000fe400078ee23dULL,
0x00005e0011107a11ULL, 0x040fe200078c40ffULL, 0x000000103e517824ULL, 0x000fe200078e024bULL,
0xfffffffc42477812ULL, 0x000fe200078ee23dULL, 0x000000ffff3e7224ULL, 0x000fe200028e06ffULL,
0x00005f0011117a11ULL, 0x000fe200030f4412ULL, 0x0000001046467824ULL, 0x000fe200078e024bULL,
0xfffffffc44487812ULL, 0x000fe200078ee23dULL, 0x0000001047477824ULL, 0x000fe200078e024bULL,
0xfffffffc49497812ULL, 0x000fc400078ee23dULL, 0xfffffffc4a4a7812ULL, 0x000fe200078ee23dULL,
0x0000001048487824ULL, 0x100fe200078e024bULL, 0x00005e0013127a11ULL, 0x000fe200078a40ffULL,
0x0000001049497824ULL, 0x100fe200078e024bULL, 0xfffffffc50507812ULL, 0x000fe200078ee224ULL,
0x000000104a4a7824ULL, 0x000fe200078e024bULL, 0xfffffffc4c427812ULL, 0x000fe200078ee23dULL,
0x00000010403d7824ULL, 0x000fe200078e024bULL, 0x00005f0013137a11ULL, 0x000fe200028f443eULL,
0x0000001050087825ULL, 0x000fe200078e0008ULL, 0x00005e003f3e7a11ULL, 0x000fc400078840ffULL,
0x00005e0041407a11ULL, 0x000fe200078240ffULL, 0x00000010424b7824ULL, 0x000fe200078e024bULL,
0x00005e0043427a11ULL, 0x000fe200078440ffULL, 0x000000ffff4c7224ULL, 0x000fe200018e06ffULL,
0x00005e0045447a11ULL, 0x000fe200078640ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008517faeULL, 0x0003e2000b901c46ULL, 0x00005f003f3f7a11ULL, 0x000fe400020f444fULL,
0x00005f0041417a11ULL, 0x000fe400008f444eULL, 0x00005f0043437a11ULL, 0x000fc400010f444dULL,
0x00005f0045457a11ULL, 0x000fe200018f444cULL, 0x0000001050087825ULL, 0x002fc800078e000aULL,
0x00000010500a7825ULL, 0x040fe200078e0010ULL, 0x00000000083d7faeULL, 0x0003e6000b901c46ULL,
0x0000001050107825ULL, 0x040fe200078e0012ULL, 0x000000000a467faeULL, 0x0003e6000b901c46ULL,
0x0000001050127825ULL, 0x040fe200078e003eULL, 0x0000000010477faeULL, 0x0003e6000b901c46ULL,
0x00000010503e7825ULL, 0x040fe200078e0040ULL, 0x0000000012487faeULL, 0x0003e6000b901c46ULL,
0x0000001050407825ULL, 0x040fe200078e0042ULL, 0x000000003e497faeULL, 0x0003e6000b901c46ULL,
0x0000001050427825ULL, 0x000fe200078e0044ULL, 0x00000000404a7faeULL, 0x0003e8000b901c46ULL,
0x00000000424b7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000035400780cULL, 0x000fe20003f25270ULL, 0x000000a000007945ULL, 0x000fd80003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x0000000437377810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff007424ULL, 0x000fc600078e00ffULL, 0x000000273700720cULL, 0x000fda0003f26070ULL,
0x0000004000001947ULL, 0x000fea0003800000ULL, 0x0000000225087824ULL, 0x002fe400078e0237ULL,
0x00000004ff097424ULL, 0x000fc800078e00ffULL, 0x0000600008087625ULL, 0x000fca00078e0009ULL,
0x0000000608007981ULL, 0x000324000c1e1900ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000ffff3d7224ULL, 0x002fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xfffffff824087812ULL, 0x020fe200078ec0ffULL,
0x000000022b3e7824ULL, 0x000fe200078e023aULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000013d497810ULL, 0x000fe40007ffe0ffULL, 0x0000000708087812ULL, 0x000fe400078ef824ULL,
0x000020003e3e7811ULL, 0x000fe400078e60ffULL, 0x00000001ff097819ULL, 0x000fe20000011608ULL,
0x00000004080b7824ULL, 0x000fe200078e00ffULL, 0x0000000724107812ULL, 0x000fc600078ec0ffULL,
0x00000001090a7824ULL, 0x040fe200078e023dULL, 0x00000008104c7812ULL, 0x000fe200078ef824ULL,
0x0000000109097824ULL, 0x000fc600078e0249ULL, 0xfffffffc0b0a7812ULL, 0x040fe200078ee20aULL,
0x000000204c107824ULL, 0x000fe200078e00ffULL, 0xfffffffc0b0b7812ULL, 0x000fc600078ee209ULL,
0x000000100a0a7824ULL, 0x100fe400078e023eULL, 0x000000100b0b7824ULL, 0x000fc600078e023eULL,
0x000000000a40783bULL, 0x0002a80000000200ULL, 0x000000000b44783bULL, 0x0006a20000000200ULL,
0x000000043c0a7824ULL, 0x002fc800078e023dULL, 0x000000020a087824ULL, 0x000fe200078e00ffULL,
0x00000020240a7810ULL, 0x000fc80007ffe0ffULL, 0x0000000824097211ULL, 0x000fe400078fe0ffULL,
0xfffffff80a0a7812ULL, 0x000fe400078ec0ffULL, 0x0000000208487810ULL, 0x000fe20007ffe0ffULL,
0x000000014c097824ULL, 0x000fe200078e0209ULL, 0x000000070a3f7812ULL, 0x000fc800078ef824ULL,
0xffffffe010097812ULL, 0x000fe200078ee209ULL, 0x000000043f4a7824ULL, 0x040fe200078e00ffULL,
0x00000001ff0a7819ULL, 0x000fe2000001163fULL, 0x000000043f3f7824ULL, 0x000fe400078e00ffULL,
0x0000001009097824ULL, 0x000fe400078e00ffULL, 0x000000010a0b7824ULL, 0x008fe200078e023dULL,
0x000000023d3d7810ULL, 0x000fe40007ffe0ffULL, 0x000000000910783bULL, 0x0002e40000000200ULL,
0xfffffffc4a0b7812ULL, 0x000fc400078ee20bULL, 0x00000018ff087819ULL, 0x104fe40000011643ULL,
0x0000ffff434b7812ULL, 0x040fe400078ec0ffULL, 0x0000004824097211ULL, 0x002fe400078fe0ffULL,
0x00000008ff48723eULL, 0x000fe400020006ffULL, 0x00000010ff087819ULL, 0x000fe20000011643ULL,
0x000000014c4a7824ULL, 0x040fe200078e0209ULL, 0x000000ff43437812ULL, 0x000fe200078ec0ffULL,
0x000000204c4c7824ULL, 0x000fe200078e00ffULL, 0x000000ff08097812ULL, 0x000fe200078ec0ffULL,
0x20000048ff487230ULL, 0x000fe20000004100ULL, 0x00000008ff087819ULL, 0x000fe2000001164bULL,
0x000000010a4b7824ULL, 0x000fe200078e0249ULL, 0xffffffe04c4a7812ULL, 0x000fe200078ee24aULL,
0x000000100b4c7824ULL, 0x000fe200078e023eULL, 0x00000009ff09723eULL, 0x000fc400020006ffULL,
0x00000043ff43723eULL, 0x000fe200020006ffULL, 0x000000104a4a7824ULL, 0x000fe200078e00ffULL,
0x00000008ff08723eULL, 0x000fe200020006ffULL, 0x000000004c4c783bULL, 0x000fe20000000200ULL,
0x20000009ff097230ULL, 0x000fe20000004100ULL, 0x00000010ff487819ULL, 0x000fe20000011648ULL,
0x20000043ff437230ULL, 0x000fe20000004100ULL, 0x0000ffff47517812ULL, 0x000fe200078ec0ffULL,
0x20000008ff087230ULL, 0x000fe20000004100ULL, 0x00000010ff097819ULL, 0x000fe40000011609ULL,
0x00000010ff437819ULL, 0x000fc40000011643ULL, 0x00000010ff087819ULL, 0x000fe40000011608ULL,
0x0000105448497816ULL, 0x000fe40000000009ULL, 0x0000105408487816ULL, 0x000fe40000000043ULL,
0x00000010ff437819ULL, 0x000fe20000011647ULL, 0x000000004a08783bULL, 0x0002a20000000200ULL,
0xfffffffc3f4b7812ULL, 0x000fe400078ee24bULL, 0x000000ff43507812ULL, 0x000fe200078ec0ffULL,
0x000000481004723cULL, 0x008b620000041804ULL, 0x00000008ff437819ULL, 0x000fe20000011651ULL,
0x000000104b4b7824ULL, 0x000fe200078e023eULL, 0x00000050ff50723eULL, 0x000fc400020006ffULL,
0x00000018ff4a7819ULL, 0x002fe40000011647ULL, 0x000000ff47477812ULL, 0x000fe200078ec0ffULL,
0x20000050ff507230ULL, 0x000fe20000004100ULL, 0x0000004aff4a723eULL, 0x000fe400020006ffULL,
0x00000047ff47723eULL, 0x000fe400020006ffULL, 0x00000043ff43723eULL, 0x000fe200020006ffULL,
0x2000004aff4a7230ULL, 0x000fe20000004100ULL, 0x00000010ff507819ULL, 0x000fe20000011650ULL,
0x20000047ff477230ULL, 0x000fe20000004100ULL, 0x00000010ff527819ULL, 0x000fe20000011642ULL,
0x20000043ff437230ULL, 0x000fe20000004100ULL, 0x00000010ff4a7819ULL, 0x000fc4000001164aULL,
0x00000010ff477819ULL, 0x000fe40000011647ULL, 0x00000010ff437819ULL, 0x000fe40000011643ULL,
0x000010544a577816ULL, 0x000fe40000000050ULL, 0x0000105443567816ULL, 0x000fe20000000047ULL,
0x000000004b48783bULL, 0x020e620000000200ULL, 0x00000018ff477819ULL, 0x000fe40000011641ULL,
0x00000018ff537819ULL, 0x000fc40000011642ULL, 0x000000ff42547812ULL, 0x040fe400078ec0ffULL,
0x0000ffff42617812ULL, 0x000fe200078ec0ffULL, 0x000000560804723cULL, 0x004be20000041804ULL,
0x00000010ff677819ULL, 0x100fe4000001164dULL, 0x00000018ff667819ULL, 0x000fe4000001164dULL,
0x000000ff4d687812ULL, 0x040fe400078ec0ffULL, 0x0000ffff4d7e7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff427819ULL, 0x000fe40000011644ULL, 0x00000047ff47723eULL, 0x000fe400020006ffULL,
0x00000018ff4d7819ULL, 0x000fe40000011645ULL, 0x0000ffff405d7812ULL, 0x000fe200078ec0ffULL,
0x20000047ff5e7230ULL, 0x000fe20000004100ULL, 0x00000010ff437819ULL, 0x000fe40000011640ULL,
0x00000042ff42723eULL, 0x000fc400020006ffULL, 0x000000ff45587812ULL, 0x000fe400078ec0ffULL,
0x0000004dff4d723eULL, 0x000fe400020006ffULL, 0x00000018ff3e7819ULL, 0x000fe40000011640ULL,
0x000000ff403f7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff637819ULL, 0x100fe4000001164cULL,
0x00000018ff647819ULL, 0x000fc4000001164cULL, 0x000000ff4c657812ULL, 0x040fe400078ec0ffULL,
0x0000ffff4c7d7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff477819ULL, 0x000fe4000001165dULL,
0x000000ff444c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff737819ULL, 0x000fe40000011645ULL,
0x0000ffff45807812ULL, 0x000fe200078ec0ffULL, 0x20000042ff457230ULL, 0x000fe20000004100ULL,
0x000000ff43437812ULL, 0x000fe200078ec0ffULL, 0x2000004dff427230ULL, 0x000fe20000004100ULL,
0x00000010ff507819ULL, 0x000fc40000011641ULL, 0x000000ff41517812ULL, 0x040fe400078ec0ffULL,
0x0000ffff41607812ULL, 0x000fe400078ec0ffULL, 0x00000058ff58723eULL, 0x000fe400020006ffULL,
0x00000010ff747819ULL, 0x100fe40000011646ULL, 0x00000018ff597819ULL, 0x000fe40000011646ULL,
0x000000ff465c7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff46817812ULL, 0x000fe400078ec0ffULL,
0x0000003eff41723eULL, 0x000fe400020006ffULL, 0x0000003fff40723eULL, 0x000fe400020006ffULL,
0x00000047ff47723eULL, 0x000fe200020006ffULL, 0x20000041ff5a7230ULL, 0x000fe20000004100ULL,
0x0000004cff46723eULL, 0x000fe200020006ffULL, 0x20000040ff577230ULL, 0x020fe20000004100ULL,
0x00000008ff4d7819ULL, 0x000fc40000011661ULL, 0x00000043ff4c723eULL, 0x000fe200020006ffULL,
0x20000058ff437230ULL, 0x000fe20000004100ULL, 0x0000004dff4d723eULL, 0x000fe200020006ffULL,
0x20000047ff587230ULL, 0x000fe20000004100ULL, 0x00000059ff41723eULL, 0x000fe200020006ffULL,
0x2000004cff597230ULL, 0x000fe20000004100ULL, 0x00000064ff64723eULL, 0x000fe200020006ffULL,
0x20000046ff467230ULL, 0x000fe20000004100ULL, 0x00000008ff4c7819ULL, 0x000fe20000011660ULL,
0x2000004dff607230ULL, 0x000fe20000004100ULL, 0x000000ff63637812ULL, 0x000fe200078ec0ffULL,
0x20000041ff417230ULL, 0x000fe20000004100ULL, 0x00000010ff577819ULL, 0x000fc40000011657ULL,
0x00000010ff587819ULL, 0x000fe40000011658ULL, 0x0000ffff4e7f7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff4d7819ULL, 0x000fe4000001167dULL, 0x00000066ff47723eULL, 0x000fe200020006ffULL,
0x20000064ff667230ULL, 0x000fe20000004100ULL, 0x00000010ff5a7819ULL, 0x000fe4000001165aULL,
0x00000010ff597819ULL, 0x000fe20000011659ULL, 0x20000047ff6a7230ULL, 0x000fe20000004100ULL,
0x000000ff50507812ULL, 0x000fc400078ec0ffULL, 0x00000063ff64723eULL, 0x000fe400020006ffULL,
0x0000105458587816ULL, 0x000fe40000000057ULL, 0x00000065ff65723eULL, 0x000fe200020006ffULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x0000004dff63723eULL, 0x000fe400020006ffULL,
0x00000008ff577819ULL, 0x000fe2000001167fULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x000010545a597816ULL, 0x000fe20000000059ULL, 0x20000063ff637230ULL, 0x000fe20000004100ULL,
0x00000010ff6b7819ULL, 0x000fc4000001164eULL, 0x00000018ff697819ULL, 0x000fe4000001164eULL,
0x000000ff4e6c7812ULL, 0x000fe200078ec0ffULL, 0x00000058100c723cULL, 0x000b62000004180cULL,
0x00000010ff6e7819ULL, 0x100fe4000001164fULL, 0x00000018ff4e7819ULL, 0x000fe4000001164fULL,
0x000000ff4f6f7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff4f567812ULL, 0x000fc400078ec0ffULL,
0x00000051ff51723eULL, 0x000fe400020006ffULL, 0x00000050ff50723eULL, 0x000fe400020006ffULL,
0x0000004cff4c723eULL, 0x000fe200020006ffULL, 0x20000051ff5b7230ULL, 0x000fe20000004100ULL,
0x000000ff67677812ULL, 0x000fe200078ec0ffULL, 0x20000050ff5d7230ULL, 0x000fe20000004100ULL,
0x00000010ff4f7819ULL, 0x000fe40000011644ULL, 0x00000057ff57723eULL, 0x000fc400020006ffULL,
0x00000069ff69723eULL, 0x000fe400020006ffULL, 0x0000ffff44707812ULL, 0x000fe200078ec0ffULL,
0x20000057ff587230ULL, 0x020fe20000004100ULL, 0x0000005cff40723eULL, 0x000fe200020006ffULL,
0x2000004cff5c7230ULL, 0x000fe20000004100ULL, 0x00000067ff67723eULL, 0x000fe200020006ffULL,
0x20000069ff6d7230ULL, 0x000fe20000004100ULL, 0x000000ff4f4f7812ULL, 0x000fe200078ec0ffULL,
0x20000040ff407230ULL, 0x000fe20000004100ULL, 0x00000008ff567819ULL, 0x000fe20000011656ULL,
0x20000067ff697230ULL, 0x000fe20000004100ULL, 0x00000010ff667819ULL, 0x000fc40000011666ULL,
0x00000010ff657819ULL, 0x000fe40000011665ULL, 0x00000010ff577819ULL, 0x000fe40000011664ULL,
0x00000010ff637819ULL, 0x000fe40000011663ULL, 0x00000008ff477819ULL, 0x000fe40000011670ULL,
0x00000010ff447819ULL, 0x002fe40000011649ULL, 0x0000004fff4f723eULL, 0x000fc400020006ffULL,
0x00000010ff557819ULL, 0x000fe40000011648ULL, 0x000000ff52527812ULL, 0x000fe200078ec0ffULL,
0x2000004fff727230ULL, 0x000fe20000004100ULL, 0x00000008ff677819ULL, 0x000fe4000001167eULL,
0x000000ff6b6b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff6e6e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5e7819ULL, 0x000fc4000001165eULL, 0x00000010ff5b7819ULL, 0x000fe4000001165bULL,
0x00000010ff5d7819ULL, 0x000fe4000001165dULL, 0x00000010ff5c7819ULL, 0x000fe4000001165cULL,
0x00000056ff59723eULL, 0x000fe400020006ffULL, 0x0000105466577816ULL, 0x000fe40000000057ULL,
0x0000105463567816ULL, 0x000fc40000000065ULL, 0x00000047ff47723eULL, 0x000fe400020006ffULL,
0x000000ff44447812ULL, 0x000fe400078ec0ffULL, 0x00000053ff53723eULL, 0x000fe200020006ffULL,
0x20000047ff717230ULL, 0x000fe20000004100ULL, 0x00000054ff54723eULL, 0x000fe200020006ffULL,
0x000000561020723cULL, 0x000be20000041820ULL, 0x00000052ff52723eULL, 0x000fe200020006ffULL,
0x20000053ff627230ULL, 0x000fe20000004100ULL, 0x00000068ff68723eULL, 0x000fe200020006ffULL,
0x20000054ff5f7230ULL, 0x000fe20000004100ULL, 0x0000006cff6c723eULL, 0x000fe200020006ffULL,
0x20000052ff617230ULL, 0x000fe20000004100ULL, 0x0000004eff4e723eULL, 0x000fe200020006ffULL,
0x20000068ff687230ULL, 0x000fe20000004100ULL, 0x0000006fff6f723eULL, 0x000fe200020006ffULL,
0x2000006cff6c7230ULL, 0x000fe20000004100ULL, 0x00000067ff67723eULL, 0x000fe200020006ffULL,
0x2000004eff707230ULL, 0x000fe20000004100ULL, 0x0000006bff6b723eULL, 0x000fe200020006ffULL,
0x2000006fff6f7230ULL, 0x000fe20000004100ULL, 0x0000006eff6e723eULL, 0x000fe200020006ffULL,
0x20000067ff677230ULL, 0x000fe20000004100ULL, 0x000010545e5d7816ULL, 0x000fe2000000005dULL,
0x2000006bff6b7230ULL, 0x000fe20000004100ULL, 0x000010545c5c7816ULL, 0x000fe2000000005bULL,
0x2000006eff6e7230ULL, 0x000fe20000004100ULL, 0x000000ff55557812ULL, 0x000fc400078ec0ffULL,
0x00000044ff44723eULL, 0x000fe400020006ffULL, 0x00000055ff5a723eULL, 0x000fe200020006ffULL,
0x20000059ff557230ULL, 0x000fe20000004100ULL, 0x00000010ff3f7819ULL, 0x000fe2000001164aULL,
0x0000005c1030723cULL, 0x000b620000041830ULL, 0x00000010ff457819ULL, 0x000fe20000011645ULL,
0x2000005aff5b7230ULL, 0x000fe20000004100ULL, 0x00000010ff577819ULL, 0x020fe40000011672ULL,
0x00000010ff467819ULL, 0x000fc40000011646ULL, 0x00000010ff717819ULL, 0x000fe20000011671ULL,
0x20000044ff5c7230ULL, 0x000fe20000004100ULL, 0x0000105445577816ULL, 0x000fe40000000057ULL,
0x000000ff3f447812ULL, 0x000fe400078ec0ffULL, 0x00000010ff627819ULL, 0x000fe40000011662ULL,
0x00000010ff617819ULL, 0x000fe40000011661ULL, 0x00000010ff5f7819ULL, 0x000fc4000001165fULL,
0x00000010ff607819ULL, 0x000fe40000011660ULL, 0x00000010ff6a7819ULL, 0x000fe4000001166aULL,
0x00000010ff687819ULL, 0x000fe40000011668ULL, 0x00000010ff697819ULL, 0x000fe40000011669ULL,
0x00000010ff677819ULL, 0x000fe40000011667ULL, 0x00000010ff6d7819ULL, 0x000fc4000001166dULL,
0x00000010ff6c7819ULL, 0x000fe4000001166cULL, 0x00000010ff597819ULL, 0x000fe4000001166bULL,
0x00000010ff587819ULL, 0x000fe40000011658ULL, 0x00000010ff707819ULL, 0x000fe40000011670ULL,
0x00000010ff6f7819ULL, 0x000fe4000001166fULL, 0x00000010ff457819ULL, 0x000fc4000001166eULL,
0x00000010ff557819ULL, 0x000fe40000011655ULL, 0x0000105471567816ULL, 0x000fe40000000046ULL,
0x000000ff73737812ULL, 0x000fe400078ec0ffULL, 0x00000044ff46723eULL, 0x000fe400020006ffULL,
0x00000008ff477819ULL, 0x000fe20000011680ULL, 0x00000056080c723cULL, 0x000fe2000004180cULL,
0x00000008ff4c7819ULL, 0x000fe20000011681ULL, 0x20000046ff467230ULL, 0x000fe20000004100ULL,
0x0000105462617816ULL, 0x000fc40000000061ULL, 0x0000105460607816ULL, 0x000fe4000000005fULL,
0x000010546a697816ULL, 0x000fe40000000069ULL, 0x0000105467687816ULL, 0x000fe40000000068ULL,
0x000010546d597816ULL, 0x000fe20000000059ULL, 0x00000060102c723cULL, 0x000f62000004182cULL,
0x0000105458587816ULL, 0x000fe4000000006cULL, 0x0000105470457816ULL, 0x000fc40000000045ULL,
0x0000105455447816ULL, 0x000fe4000000006fULL, 0x00000018ff757819ULL, 0x000fe20000011648ULL,
0x00000068101c723cULL, 0x040f62000004181cULL, 0x000000ff48767812ULL, 0x000fe400078ec0ffULL,
0x00000018ff777819ULL, 0x000fe40000011649ULL, 0x000000ff49787812ULL, 0x000fe400078ec0ffULL,
0x00000018ff797819ULL, 0x000fe2000001164aULL, 0x000000581018723cULL, 0x000f620000041818ULL,
0x000000ff4a7a7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff3e7819ULL, 0x100fe4000001164bULL,
0x00000018ff7b7819ULL, 0x000fe4000001164bULL, 0x000000ff4b7c7812ULL, 0x000fe200078ec0ffULL,
0x000000441014723cULL, 0x000b620000041814ULL, 0x0000ffff48487812ULL, 0x000fe400078ec0ffULL,
0x0000ffff49497812ULL, 0x000fe400078ec0ffULL, 0x0000ffff4a4a7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff4b4b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff74747812ULL, 0x000fe400078ec0ffULL,
0x00000073ff73723eULL, 0x000fe400020006ffULL, 0x00000047ff47723eULL, 0x000fe400020006ffULL,
0x0000004cff4c723eULL, 0x000fe400020006ffULL, 0x00000008ff487819ULL, 0x000fc40000011648ULL,
0x00000008ff497819ULL, 0x000fe20000011649ULL, 0x2000004cff527230ULL, 0x000fe20000004100ULL,
0x00000008ff4a7819ULL, 0x000fe4000001164aULL, 0x000000ff3e3e7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff4b7819ULL, 0x000fe4000001164bULL, 0x00000074ff53723eULL, 0x000fe200020006ffULL,
0x20000073ff747230ULL, 0x000fe20000004100ULL, 0x00000075ff50723eULL, 0x000fe200020006ffULL,
0x20000047ff737230ULL, 0x000fe20000004100ULL, 0x00000076ff54723eULL, 0x000fe200020006ffULL,
0x20000053ff537230ULL, 0x000fe20000004100ULL, 0x00000077ff51723eULL, 0x000fe200020006ffULL,
0x20000050ff507230ULL, 0x000fe20000004100ULL, 0x00000078ff4f723eULL, 0x000fe200020006ffULL,
0x20000054ff547230ULL, 0x000fe20000004100ULL, 0x00000079ff47723eULL, 0x000fe200020006ffULL,
0x20000051ff517230ULL, 0x000fe20000004100ULL, 0x0000007aff4c723eULL, 0x000fe200020006ffULL,
0x2000004fff4f7230ULL, 0x000fe20000004100ULL, 0x0000007bff4e723eULL, 0x000fe200020006ffULL,
0x20000047ff477230ULL, 0x000fe20000004100ULL, 0x0000007cff7c723eULL, 0x000fe200020006ffULL,
0x2000004cff4c7230ULL, 0x000fe20000004100ULL, 0x00000048ff48723eULL, 0x000fe200020006ffULL,
0x2000004eff4e7230ULL, 0x000fe20000004100ULL, 0x00000049ff3f723eULL, 0x000fe200020006ffULL,
0x2000007cff4d7230ULL, 0x000fe20000004100ULL, 0x0000004aff4a723eULL, 0x000fe200020006ffULL,
0x20000048ff5a7230ULL, 0x000fe20000004100ULL, 0x0000003eff3e723eULL, 0x000fe200020006ffULL,
0x2000003fff3f7230ULL, 0x000fe20000004100ULL, 0x0000004bff4b723eULL, 0x000fe200020006ffULL,
0x2000004aff4a7230ULL, 0x000fe20000004100ULL, 0x00000010ff107819ULL, 0x020fe20000011641ULL,
0x2000003eff3e7230ULL, 0x000fe20000004100ULL, 0x00000010ff417819ULL, 0x000fe20000011653ULL,
0x2000004bff127230ULL, 0x000fe20000004100ULL, 0x000000043d00780cULL, 0x000fc40003f25270ULL,
0x00000010ff427819ULL, 0x000fe40000011642ULL, 0x00000010ff437819ULL, 0x000fe40000011643ULL,
0x00000010ff497819ULL, 0x000fe40000011674ULL, 0x00000010ff737819ULL, 0x000fe40000011673ULL,
0x00000010ff407819ULL, 0x000fe40000011640ULL, 0x00000010ff527819ULL, 0x000fc40000011652ULL,
0x00000010ff507819ULL, 0x000fe40000011650ULL, 0x00000010ff547819ULL, 0x000fe40000011654ULL,
0x00000010ff557819ULL, 0x000fe4000001165bULL, 0x00000010ff5a7819ULL, 0x000fe4000001165aULL,
0x00000010ff517819ULL, 0x000fe40000011651ULL, 0x00000010ff117819ULL, 0x000fc4000001165cULL,
0x00000010ff4f7819ULL, 0x000fe4000001164fULL, 0x00000010ff3f7819ULL, 0x000fe4000001163fULL,
0x00000010ff477819ULL, 0x000fe40000011647ULL, 0x00000010ff467819ULL, 0x000fe40000011646ULL,
0x00000010ff4c7819ULL, 0x000fe4000001164cULL, 0x00000010ff4a7819ULL, 0x000fc4000001164aULL,
0x00000010ff4e7819ULL, 0x000fe4000001164eULL, 0x00000010ff137819ULL, 0x000fe4000001163eULL,
0x00000010ff4d7819ULL, 0x000fe4000001164dULL, 0x00000010ff127819ULL, 0x000fe40000011612ULL,
0x0000105410417816ULL, 0x000fe40000000041ULL, 0x0000105442497816ULL, 0x000fc40000000049ULL,
0x0000105473487816ULL, 0x000fe40000000043ULL, 0x0000105452407816ULL, 0x000fe40000000040ULL,
0x0000105450557816ULL, 0x000fe40000000055ULL, 0x000010545a547816ULL, 0x000fe20000000054ULL,
0x000000480830723cULL, 0x000b620000041830ULL, 0x0000105451117816ULL, 0x000fe40000000011ULL,
0x000010543f107816ULL, 0x000fc4000000004fULL, 0x00001054474b7816ULL, 0x000fe40000000046ULL,
0x000010544a4a7816ULL, 0x000fe2000000004cULL, 0x00000040082c723cULL, 0x000b62000004182cULL,
0x000010544e137816ULL, 0x000fe40000000013ULL, 0x0000105412127816ULL, 0x000fca000000004dULL,
0x000000540820723cULL, 0x040b700000041820ULL, 0x00000010081c723cULL, 0x040b70000004181cULL,
0x0000004a0818723cULL, 0x040b700000041818ULL, 0x000000120814723cULL, 0x000b620000041814ULL,
0x0000001000009944ULL, 0x000fe20003c00000ULL, 0xffffe7d000007947ULL, 0x000fcc000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff3a7224ULL, 0x000fe200078e0038ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffd92000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x0000002904047220ULL, 0x080fe20000410000ULL,
0x0000002905057220ULL, 0x080fe20000410000ULL, 0x000000291c1c7220ULL, 0x0a0fe20000410000ULL,
0x000000291d1d7220ULL, 0x080fe20000410000ULL, 0x0000002914147220ULL, 0x080fe20000410000ULL,
0x000000290c0a7220ULL, 0x080fe20000410000ULL, 0x000000290d0b7220ULL, 0x080fe20000410000ULL,
0x000000290e3a7220ULL, 0x080fe20000410000ULL, 0x000000290f3b7220ULL, 0x080fe20000410000ULL,
0x00000029300c7220ULL, 0x080fe20000410000ULL, 0x00000029310d7220ULL, 0x080fe20000410000ULL,
0x000000292c0e7220ULL, 0x080fe20000410000ULL, 0x000000292d0f7220ULL, 0x080fe20000410000ULL,
0x000000291a3c7220ULL, 0x080fe20000410000ULL, 0x00000029163e7220ULL, 0x080fe20000410000ULL,
0x00000029173f7220ULL, 0x080fe20000410000ULL, 0x0000002932327220ULL, 0x080fe20000410000ULL,
0x0000002933337220ULL, 0x080fe20000410000ULL, 0x000000292e2e7220ULL, 0x080fe20000410000ULL,
0x000000292f2f7220ULL, 0x080fe20000410000ULL, 0x0000002906067220ULL, 0x080fe20000410000ULL,
0x0000002907077220ULL, 0x080fe20000410000ULL, 0x0000002920127220ULL, 0x080fe20000410000ULL,
0x0000002921137220ULL, 0x080fe20000410000ULL, 0x00000029222c7220ULL, 0x080fe20000410000ULL,
0x00000029232d7220ULL, 0x080fe20000410000ULL, 0x000000291e307220ULL, 0x080fe20000410000ULL,
0x000000291f317220ULL, 0x080fe20000410000ULL, 0x0000002918187220ULL, 0x080fe20000410000ULL,
0x0000002919197220ULL, 0x080fe20000410000ULL, 0x000000291b3d7220ULL, 0x080fe20000410000ULL,
0x0000002915157220ULL, 0x000fe20000410000ULL, 0x000000ffff107224ULL, 0x000fc400078e0004ULL,
0x000000ffff117224ULL, 0x000fe400078e0005ULL, 0x000000ffff167224ULL, 0x000fe400078e001cULL,
0x000000ffff177224ULL, 0x000fe400078e001dULL, 0x000000ffff1a7224ULL, 0x000fe200078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000002a087f8cULL, 0x0002a2000c80043fULL,
0x000000ffff207224ULL, 0x000fe400078e002eULL, 0x000000ffff217224ULL, 0x000fc400078e002fULL,
0x000000ffff1e7224ULL, 0x000fe400078e0032ULL, 0x000000ffff1f7224ULL, 0x000fe400078e0033ULL,
0x000000ffff2e7224ULL, 0x000fe400078e0030ULL, 0x000000ffff2f7224ULL, 0x000fe400078e0031ULL,
0x000000ffff1b7224ULL, 0x000fe400078e0015ULL, 0x000000ffff1c7224ULL, 0x000fc400078e003aULL,
0x000000ffff1d7224ULL, 0x000fe400078e003bULL, 0x000000ffff227224ULL, 0x000fe400078e0006ULL,
0x000000ffff237224ULL, 0x000fe400078e0007ULL, 0x000000ffff307224ULL, 0x000fe400078e003cULL,
0x000000ffff317224ULL, 0x000fe400078e003dULL, 0x000000ffff327224ULL, 0x000fc400078e003eULL,
0x000000ffff337224ULL, 0x000fc400078e003fULL, 0x0000000000047805ULL, 0x006fca0000015200ULL,
0x000004002a067984ULL, 0x000e640000000800ULL, 0x8000000006ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff157224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604147210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09001400780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401400780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000001406067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000115157810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004002a067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000424157824ULL, 0x000fe200078e00ffULL, 0x000000343600720cULL, 0x000fc80003f05270ULL,
0xfffffff015147812ULL, 0x000fca00078ec0ffULL, 0x000000802b147824ULL, 0x000fca00078e0214ULL,
0x0104000014047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000224087824ULL, 0x000fe400078e00ffULL, 0x0000000128397824ULL, 0x000fc600078e0a39ULL,
0x0000000608087812ULL, 0x000fc800078ec0ffULL, 0x0000000108097812ULL, 0x040fe400078efcffULL,
0x00000008083a7812ULL, 0x040fe400078efcffULL, 0x000000390900720cULL, 0x080fe40003f26070ULL,
0x0000001008097812ULL, 0x000fe400078efcffULL, 0x000000393a00720cULL, 0x080fe40003f06070ULL,
0x000000390900720cULL, 0x000fc40003fc6070ULL, 0x00000011083a7812ULL, 0x040fe400078efcffULL,
0x0000001808097812ULL, 0x040fe400078efcffULL, 0x000000390800720cULL, 0x080fe40003f46070ULL,
0x000000393a00720cULL, 0x080fe40003fa6070ULL, 0x000000390900720cULL, 0x000fe40003f66070ULL,
0x00000009083b7812ULL, 0x000fc400078efcffULL, 0x00000019083a7812ULL, 0x040fe400078efcffULL,
0x0000002008097812ULL, 0x000fe400078efcffULL, 0xff8000001c1c7808ULL, 0x000fe40005000000ULL,
0xff8000000a0a7808ULL, 0x000fe40005000000ULL, 0xff8000001d1d7808ULL, 0x000fe40004800000ULL,
0xff8000000b0b7808ULL, 0x000fc40004800000ULL, 0x000000393b00720cULL, 0x080fe40003f86070ULL,
0x000000393a00720cULL, 0x080fe40003f46070ULL, 0x000000390900720cULL, 0x000fe40003f26070ULL,
0x00000021083a7812ULL, 0x040fe400078efcffULL, 0x0000002808097812ULL, 0x000fe400078efcffULL,
0xff8000001e1e7808ULL, 0x000fc40004000000ULL, 0xff8000000c0c7808ULL, 0x000fe40004000000ULL,
0xff8000001f1f7808ULL, 0x000fe40006000000ULL, 0xff8000000d0d7808ULL, 0x000fe40006000000ULL,
0x000000393a00720cULL, 0x080fe40003f06070ULL, 0x000000390900720cULL, 0x000fe40003f86070ULL,
0x00000029083a7812ULL, 0x000fc400078efcffULL, 0x0000003008097812ULL, 0x000fe400078efcffULL,
0xff80000020207808ULL, 0x000fe40007000000ULL, 0xff8000000e0e7808ULL, 0x000fe40007000000ULL,
0xff80000021217808ULL, 0x000fe40006800000ULL, 0xff8000000f0f7808ULL, 0x000fe40006800000ULL,
0x000000393a00720cULL, 0x000fc40003fc6070ULL, 0x000000390900720cULL, 0x000fe40003fa6070ULL,
0x00000031083a7812ULL, 0x040fe400078efcffULL, 0x0000003808097812ULL, 0x040fe400078efcffULL,
0x0000003908087812ULL, 0x000fe400078efcffULL, 0xff80000022227808ULL, 0x000fe40005800000ULL,
0xff80000010107808ULL, 0x000fc40005800000ULL, 0xff80000023237808ULL, 0x000fe40005000000ULL,
0xff80000011117808ULL, 0x000fe40005000000ULL, 0xff8000002c2c7808ULL, 0x000fe40004800000ULL,
0xff80000012127808ULL, 0x000fe40004800000ULL, 0x000000393a00720cULL, 0x080fe40003f66070ULL,
0x000000390900720cULL, 0x000fc40003f46070ULL, 0x000000390800720cULL, 0x000fe40003f26070ULL,
0xff8000002d2d7808ULL, 0x000fe40004000000ULL, 0xff80000013137808ULL, 0x000fe40004000000ULL,
0xff8000002e2e7808ULL, 0x000fe40006000000ULL, 0xff80000016167808ULL, 0x000fe40006000000ULL,
0xff8000002f2f7808ULL, 0x000fc40007000000ULL, 0xff80000017177808ULL, 0x000fe40007000000ULL,
0xff80000030307808ULL, 0x000fe40006800000ULL, 0xff80000018187808ULL, 0x000fe40006800000ULL,
0xff80000031317808ULL, 0x000fe40005800000ULL, 0xff80000019197808ULL, 0x000fe40005800000ULL,
0xff80000032327808ULL, 0x000fc40005000000ULL, 0xff8000001a1a7808ULL, 0x000fe40005000000ULL,
0xff80000033337808ULL, 0x000fe40004800000ULL, 0xff8000001b1b7808ULL, 0x000fc40004800000ULL,
0x0000000a0400720bULL, 0x004fe20003f1e000ULL, 0x0000001fff3c7424ULL, 0x000fe200078e00ffULL,
0x0000001c0500720bULL, 0x000fe20003f3e000ULL, 0xffffffffff3d7424ULL, 0x000fe200078e00ffULL,
0x000000040a047208ULL, 0x000fe40004000000ULL, 0x000000051c057208ULL, 0x000fc40004800000ULL,
0x0000000b0400720bULL, 0x000fe40003f1e000ULL, 0x0000001d0500720bULL, 0x000fe40003f3e000ULL,
0x000000040b047208ULL, 0x000fe40004000000ULL, 0x000000051d057208ULL, 0x000fe40004800000ULL,
0x0000000c0400720bULL, 0x000fe40003f1e000ULL, 0x0000001e0500720bULL, 0x000fc40003f3e000ULL,
0x000000040c047208ULL, 0x000fe40004000000ULL, 0x000000051e057208ULL, 0x000fe40004800000ULL,
0x0000000d0400720bULL, 0x000fe40003f1e000ULL, 0x0000001f0500720bULL, 0x000fe40003f3e000ULL,
0x000000040d047208ULL, 0x000fe40004000000ULL, 0x000000051f057208ULL, 0x000fc40004800000ULL,
0x0000000e0400720bULL, 0x000fe40003f1e000ULL, 0x000000200500720bULL, 0x000fe40003f3e000ULL,
0x000000040e047208ULL, 0x000fe40004000000ULL, 0x0000000520057208ULL, 0x000fe40004800000ULL,
0x0000000f0400720bULL, 0x000fe40003f1e000ULL, 0x000000210500720bULL, 0x000fc40003f3e000ULL,
0x000000040f047208ULL, 0x000fe40004000000ULL, 0x0000000521057208ULL, 0x000fe40004800000ULL,
0x000000100400720bULL, 0x000fe40003f1e000ULL, 0x000000220500720bULL, 0x000fe40003f3e000ULL,
0x0000000410047208ULL, 0x000fe40004000000ULL, 0x0000000522057208ULL, 0x000fc40004800000ULL,
0x000000110400720bULL, 0x000fe40003f1e000ULL, 0x000000230500720bULL, 0x000fe40003f3e000ULL,
0x0000000411047208ULL, 0x000fe40004000000ULL, 0x0000000523057208ULL, 0x000fe40004800000ULL,
0x000000120400720bULL, 0x000fe40003f1e000ULL, 0x0000002c0500720bULL, 0x000fc40003f3e000ULL,
0x0000000412047208ULL, 0x000fe40004000000ULL, 0x000000052c057208ULL, 0x000fe40004800000ULL,
0x000000130400720bULL, 0x000fe40003f1e000ULL, 0x0000002d0500720bULL, 0x000fe40003f3e000ULL,
0x0000000413047208ULL, 0x000fe40004000000ULL, 0x000000052d057208ULL, 0x000fc40004800000ULL,
0x000000160400720bULL, 0x000fe40003f1e000ULL, 0x0000002e0500720bULL, 0x000fe40003f3e000ULL,
0x0000000416047208ULL, 0x000fe40004000000ULL, 0x000000052e057208ULL, 0x000fe40004800000ULL,
0x000000170400720bULL, 0x000fe40003f1e000ULL, 0x0000002f0500720bULL, 0x000fc40003f3e000ULL,
0x0000000417047208ULL, 0x000fe40004000000ULL, 0x000000052f057208ULL, 0x000fe40004800000ULL,
0x000000180400720bULL, 0x000fe40003f1e000ULL, 0x000000300500720bULL, 0x000fe40003f3e000ULL,
0x0000000418047208ULL, 0x000fe40004000000ULL, 0x0000000530057208ULL, 0x000fc40004800000ULL,
0x000000190400720bULL, 0x000fe40003f1e000ULL, 0x000000310500720bULL, 0x000fe40003f3e000ULL,
0x0000000419047208ULL, 0x000fe40004000000ULL, 0x0000000531057208ULL, 0x000fe40004800000ULL,
0x0000001a0400720bULL, 0x000fe40003f1e000ULL, 0x000000320500720bULL, 0x000fc40003f3e000ULL,
0x000000041a047208ULL, 0x000fe40004000000ULL, 0x0000000532057208ULL, 0x000fe40004800000ULL,
0x0000001b0400720bULL, 0x000fe40003f1e000ULL, 0x000000330500720bULL, 0x000fe40003f3e000ULL,
0x000000041b3b7208ULL, 0x000fe40004000000ULL, 0x0000000533057208ULL, 0x000fe20004800000ULL,
0x000018f27f007947ULL, 0x000fec000b800000ULL, 0x0c401f003b047f89ULL, 0x0004e400000e0000ULL,
0x000000043b00720bULL, 0x008fc80003f1e000ULL, 0x0000003b043b7208ULL, 0x004fe20004000000ULL,
0x000019127f007947ULL, 0x000fea000b800000ULL, 0x0c401f0005047f89ULL, 0x000ea800000e0000ULL,
0x0c401f0006087f89ULL, 0x000ee800000e0000ULL, 0x0c401f0007097f89ULL, 0x000e6200000e0000ULL,
0x000000040500720bULL, 0x004fc40003f1e000ULL, 0x000000080600720bULL, 0x008fe40003f3e000ULL,
0x0000000504057208ULL, 0x000fe40004000000ULL, 0x0000000608067208ULL, 0x000fe20004800000ULL,
0x0c201f003b047f89ULL, 0x000ea200000e0000ULL, 0x000000090700720bULL, 0x002fc60003f1e000ULL,
0x0c201f0005087f89ULL, 0x000e6200000e0000ULL, 0x0000000709077208ULL, 0x000fc60004000000ULL,
0x0c201f0006397f89ULL, 0x000ee800000e0000ULL, 0x0c201f00073a7f89ULL, 0x0002e200000e0000ULL,
0x000000043b00720bULL, 0x004fe40003f1e000ULL, 0x000000080500720bULL, 0x002fe40003f3e000ULL,
0x0000003b04047208ULL, 0x000fe40004000000ULL, 0x000000390600720bULL, 0x008fc40003f5e000ULL,
0x0000000508057208ULL, 0x000fe40004800000ULL, 0x0000000639067208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b04397820ULL, 0x000fe20000410000ULL, 0x3f80000000057882ULL, 0x000fe20000000000ULL,
0x0000000c15157812ULL, 0x000fe200078ec0ffULL, 0x00000005ff3c7e24ULL, 0x000fe2000f8e00ffULL,
0x3fb8aa3b0a0a7823ULL, 0x100fe20000010839ULL, 0x3fb8aa3b0c0c7823ULL, 0x100fe20000010839ULL,
0x3fb8aa3b0e0e7823ULL, 0x100fe20000010839ULL, 0x3fb8aa3b10107823ULL, 0x100fe20000010839ULL,
0x3fb8aa3b12127823ULL, 0x100fe20000010839ULL, 0x0000000a00087308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b16167823ULL, 0x100fe20000010839ULL, 0x3fb8aa3b0b0b7823ULL, 0x100fe20000010839ULL,
0x3fb8aa3b0d0d7823ULL, 0x100fe20000010839ULL, 0x3f8000003c3c783eULL, 0x000fe200000010ffULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe20000010839ULL, 0x3fb8aa3b11117823ULL, 0x100fe20000010839ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000c000a7308ULL, 0x000fe20000000800ULL,
0x000000ffff3d7224ULL, 0x000fe200078e003cULL, 0x3fb8aa3b13137823ULL, 0x100fe20000010839ULL,
0x3fb8aa3b17177823ULL, 0x100fe20000010839ULL, 0x3fb8aa3b18187823ULL, 0x100fe20000010839ULL,
0x3fb8aa3b19197823ULL, 0x100fe20000010839ULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe20000010839ULL,
0x3fb8aa3b1b1b7823ULL, 0x000fe20000010839ULL, 0x0000000e000c7308ULL, 0x000fe20000000800ULL,
0x00000002ff397819ULL, 0x000fc40000011624ULL, 0x0000000324ff7812ULL, 0x000fe4000780c0ffULL,
0x0000003a0700720bULL, 0x004fe20003f3e000ULL, 0x00000008393b7824ULL, 0x000fe400078e00ffULL,
0x00000010000e7308ULL, 0x000fe20000000800ULL, 0x000000073a077208ULL, 0x000fce0004800000ULL,
0x0000001200107308ULL, 0x000ff00000000800ULL, 0x0000001600127308ULL, 0x0003f00000000800ULL,
0x0000000b000b7308ULL, 0x000ea20000000800ULL, 0x3fb8aa3b05167820ULL, 0x002fc80000410000ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe20000010816ULL,
0x0000000d000d7308ULL, 0x000e620000000800ULL, 0x3fb8aa3b20207823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b21217823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b22227823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b23237823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe20000010816ULL, 0x000000080b08723eULL, 0x004fe200000010ffULL,
0x0000001c00097308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b30307823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b31317823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b32327823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b33167823ULL, 0x000fe20000010816ULL, 0x0000000839337824ULL, 0x000fe200078e00ffULL,
0x0000001d001d7308ULL, 0x000ea20000000800ULL, 0x0000000a0d0a723eULL, 0x002fce00000010ffULL,
0x0000001e001e7308ULL, 0x000ff00000000800ULL, 0x0000001f001f7308ULL, 0x000e620000000800ULL,
0x000000091d09723eULL, 0x004fce00000010ffULL, 0x0000000f000f7308ULL, 0x000ea20000000800ULL,
0x0000001e1f0b723eULL, 0x002fce00000010ffULL, 0x0000002000207308ULL, 0x000fe20000000800ULL,
0x0000003c081c723cULL, 0x000f6200000418ffULL, 0x0000000c0f0c723eULL, 0x004fcc00000010ffULL,
0x0000002100217308ULL, 0x000e700000000800ULL, 0x0000001100117308ULL, 0x000eb00000000800ULL,
0x0000002200227308ULL, 0x000fe20000000800ULL, 0x00000020210d723eULL, 0x002fe200000010ffULL,
0x000000ffff207224ULL, 0x000fc400078e003cULL, 0x000000ffff217224ULL, 0x000fc800078e003cULL,
0x0000002300237308ULL, 0x000e620000000800ULL, 0x0000000e110e723eULL, 0x004fe400000010ffULL,
0x0000000139117810ULL, 0x000fca0007ffe0ffULL, 0x0000001300137308ULL, 0x000ea20000000800ULL,
0x00000022230f723eULL, 0x002fce00000010ffULL, 0x0000002e002e7308ULL, 0x000fe20000000800ULL,
0x0000000339227810ULL, 0x040fe40007ffe0ffULL, 0x0000000439237810ULL, 0x000fe20007ffe0ffULL,
0x000000200c1c723cULL, 0x020b62000004181cULL, 0x000000101310723eULL, 0x004fc600000010ffULL,
0x0000002f002f7308ULL, 0x000e660000000800ULL, 0x0000000839207824ULL, 0x060fe400078e00ffULL,
0x0000000839217824ULL, 0x000fc600078e00ffULL, 0x0000001700177308ULL, 0x000ea20000000800ULL,
0xfffffff820207812ULL, 0x000fce00078ee211ULL, 0x0000002c002c7308ULL, 0x000fe20000000800ULL,
0x0000002e2f13723eULL, 0x002fe200000010ffULL, 0x000000ffff2e7224ULL, 0x100fe400078e003cULL,
0x000000ffff2f7224ULL, 0x000fc800078e003cULL, 0x0000002d002d7308ULL, 0x000e620000000800ULL,
0x000000121712723eULL, 0x004fe400000010ffULL, 0x0000000239177810ULL, 0x000fc80007ffe0ffULL,
0xfffffff821217812ULL, 0x000fe200078ee217ULL, 0x0000001800187308ULL, 0x000fe20000000800ULL,
0x0000000839177824ULL, 0x000fca00078e00ffULL, 0xfffffff817177812ULL, 0x000fe400078ee239ULL,
0x0000002c2d11723eULL, 0x002fe200000010ffULL, 0x0000001900197308ULL, 0x000e620000000800ULL,
0x00000008392c7824ULL, 0x040fe400078e00ffULL, 0x00000008392d7824ULL, 0x000fc600078e00ffULL,
0x0000002e101c723cULL, 0x000b62000004181cULL, 0xfffffff82c227812ULL, 0x000fe200078ee222ULL,
0x0000001a001a7308ULL, 0x000fe20000000800ULL, 0x00000005392c7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff82d237812ULL, 0x000fe400078ee223ULL, 0x00000008392f7810ULL, 0x020fe40007ffe0ffULL,
0xfffffff8332c7812ULL, 0x000fe200078ee22cULL, 0x0000001b001b7308ULL, 0x000ea20000000800ULL,
0x000000181918723eULL, 0x002fe200000010ffULL, 0x000000082f3d7824ULL, 0x000fe200078e00ffULL,
0x0000a0002b337811ULL, 0x000fc400078e58ffULL, 0x00000006392d7810ULL, 0x040fe40007ffe0ffULL,
0xffffffff392e7810ULL, 0x040fe20007ffe0ffULL, 0x0000003000307308ULL, 0x000fe20000000800ULL,
0x0000000839397824ULL, 0x000fe200078e00ffULL, 0xfffffff83b2d7812ULL, 0x000fe200078ee22dULL,
0x0000001017177824ULL, 0x000fe200078e0233ULL, 0xfffffff83d2f7812ULL, 0x000fe200078ee22fULL,
0x0000001020207824ULL, 0x100fe200078e0233ULL, 0xfffffff8392e7812ULL, 0x000fe200078ee22eULL,
0x0000001021217824ULL, 0x100fe200078e0233ULL, 0x0000003100317308ULL, 0x000e620000000800ULL,
0x0000001a1b1a723eULL, 0x004fe200000010ffULL, 0x0000001022227824ULL, 0x000fc400078e0233ULL,
0x0000001023237824ULL, 0x000fe400078e0233ULL, 0x0000000117177824ULL, 0x000fe400078e0215ULL,
0x0000003200327308ULL, 0x000fe20000000800ULL, 0x000000102c2c7824ULL, 0x100fe400078e0233ULL,
0x0000000115207824ULL, 0x000fe200078e0220ULL, 0x0000000817007388ULL, 0x0005e20000000800ULL,
0x000000102d2d7824ULL, 0x000fe400078e0233ULL, 0x0000000115217824ULL, 0x000fe200078e0221ULL,
0x0000001600167308ULL, 0x000ee20000000800ULL, 0x000000303119723eULL, 0x002fe200000010ffULL,
0x000000ffff307224ULL, 0x100fe200078e003cULL, 0x0000000a20007388ULL, 0x0005e20000000800ULL,
0x000000ffff317224ULL, 0x000fc400078e003cULL, 0x000000102e2e7824ULL, 0x100fe200078e0233ULL,
0x0000000c21007388ULL, 0x0005e20000000800ULL, 0x0000000115227824ULL, 0x000fe400078e0222ULL,
0x000000102f2f7824ULL, 0x000fe400078e0233ULL, 0x0000000115237824ULL, 0x040fe200078e0223ULL,
0x0000000e22007388ULL, 0x0005e20000000800ULL, 0x00000001152c7824ULL, 0x040fe200078e022cULL,
0x00000032161b723eULL, 0x008fe200000010ffULL, 0x00000001152d7824ULL, 0x040fe200078e022dULL,
0x0000001023007388ULL, 0x0005e20000000800ULL, 0x00000001152e7824ULL, 0x000fc400078e022eULL,
0x00000001152f7824ULL, 0x000fe200078e022fULL, 0x000000122c007388ULL, 0x0005e20000000800ULL,
0x00000030181c723cULL, 0x000f66000004181cULL, 0x000000182d007388ULL, 0x0005e80000000800ULL,
0x0000001a2e007388ULL, 0x0005e80000000800ULL, 0x000000092f007388ULL, 0x0005e80000000800ULL,
0x0004000b20007388ULL, 0x0005e80000000800ULL, 0x0004000d21007388ULL, 0x0005e80000000800ULL,
0x0004000f22007388ULL, 0x0005e20000000800ULL, 0x000000ffff1d7224ULL, 0x020fc600078e001eULL,
0x0004001123007388ULL, 0x0005e80000000800ULL, 0x000400132c007388ULL, 0x0005e80000000800ULL,
0x000400192d007388ULL, 0x0005e80000000800ULL, 0x0004001b2e007388ULL, 0x0005e80000000800ULL,
0x0100000414008388ULL, 0x0005e80000000c00ULL, 0x0102001c14008388ULL, 0x0005e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000035ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000080035ff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000100035ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000136367810ULL, 0x000fe20007ffe0ffULL,
0x0000180035ff7f8cULL, 0x0003e6000c80043fULL, 0x000000263600720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffbba000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff467807ULL, 0x004fe40004000000ULL,
0x0001c72000477802ULL, 0x000fc40000000f00ULL, 0x0000102000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff037224ULL, 0x000fe200078e004aULL, 0xfffe59c000007947ULL, 0x000fea000383ffffULL,
0x00000001ff467807ULL, 0x000fe40005000000ULL, 0x0001c77000477802ULL, 0x000fc40000000f00ULL,
0x00000fd000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff037224ULL, 0x000fe200078e004aULL,
0xfffe5a2000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5a7224ULL, 0x002fe200078e0014ULL,
0x0001c7c000467802ULL, 0x000fc40000000f00ULL, 0x00000f4000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff477224ULL, 0x004fe200078e005aULL, 0xfffe5ac000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5a7224ULL, 0x000fe200078e0014ULL, 0x0001c81000467802ULL, 0x000fc40000000f00ULL,
0x00000ef000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff477224ULL, 0x004fe200078e005aULL,
0xfffe5be000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5a7224ULL, 0x000fe200078e0000ULL,
0x0001c87000467802ULL, 0x000fe20000000f00ULL, 0x000000ffff477224ULL, 0x000fc400078e0002ULL,
0x00000e9000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff197224ULL, 0x004fe200078e005aULL,
0xfffe5fd000007947ULL, 0x000fea000383ffffULL, 0x000000ffff477224ULL, 0x000fe200078e0018ULL,
0x0001c8d000467802ULL, 0x000fe20000000f00ULL, 0x000000ffff5a7224ULL, 0x000fc400078e0000ULL,
0x00000e3000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff187224ULL, 0x004fe200078e005aULL,
0xfffe5fa000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5a7224ULL, 0x000fe200078e003dULL,
0x0001c93000467802ULL, 0x000fe20000000f00ULL, 0x000000ffff477224ULL, 0x000fc400078e003eULL,
0x00000dd000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff197224ULL, 0x004fe200078e005aULL,
0xfffe85c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff477224ULL, 0x000fe200078e0018ULL,
0x0001c99000467802ULL, 0x000fe20000000f00ULL, 0x000000ffff5a7224ULL, 0x000fc400078e003dULL,
0x00000d7000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff187224ULL, 0x004fe200078e005aULL,
0xfffe859000007947ULL, 0x000fea000383ffffULL, 0x00000001ff467807ULL, 0x008fe40004000000ULL,
0x0001c9e000477802ULL, 0x000fc40000000f00ULL, 0x00000d6000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff497224ULL, 0x000fe200078e004aULL, 0xfffeac4000007947ULL, 0x000fea000383ffffULL,
0x00000001ff467807ULL, 0x000fe40005000000ULL, 0x0001ca3000477802ULL, 0x000fc40000000f00ULL,
0x00000d1000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff447224ULL, 0x000fe200078e004aULL,
0xfffeac8000007947ULL, 0x000fea000383ffffULL, 0x000000ffff477224ULL, 0x000fe200078e0046ULL,
0x0001ca9000467802ULL, 0x000fe20000000f00ULL, 0x000000ffff5a7224ULL, 0x000fc400078e004aULL,
0x00000c7000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff467224ULL, 0x004fe200078e005aULL,
0xfffead3000007947ULL, 0x000fea000383ffffULL, 0x000000ffff477224ULL, 0x000fe200078e0046ULL,
0x0001caf000467802ULL, 0x000fe20000000f00ULL, 0x000000ffff5a7224ULL, 0x000fc400078e004aULL,
0x00000c1000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff467224ULL, 0x004fe200078e005aULL,
0xfffeae3000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5a7224ULL, 0x000fe200078e0043ULL,
0x0001cb5000467802ULL, 0x000fe20000000f00ULL, 0x000000ffff477224ULL, 0x000fc400078e0045ULL,
0x00000bb000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff197224ULL, 0x004fe200078e005aULL,
0xfffeb26000007947ULL, 0x000fea000383ffffULL, 0x000000ffff477224ULL, 0x000fe200078e0018ULL,
0x0001cbb000467802ULL, 0x000fe20000000f00ULL, 0x000000ffff5a7224ULL, 0x000fc400078e0043ULL,
0x00000b5000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff187224ULL, 0x004fe200078e005aULL,
0xfffeb23000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5a7224ULL, 0x000fe200078e002cULL,
0x0001cc1000467802ULL, 0x000fe20000000f00ULL, 0x000000ffff477224ULL, 0x000fc400078e002dULL,
0x00000af000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff197224ULL, 0x004fe200078e005aULL,
0xfffed66000007947ULL, 0x000fea000383ffffULL, 0x000000ffff477224ULL, 0x000fe200078e0018ULL,
0x0001cc7000467802ULL, 0x000fe20000000f00ULL, 0x000000ffff5a7224ULL, 0x000fc400078e002cULL,
0x00000a9000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff187224ULL, 0x004fe200078e005aULL,
0xfffed63000007947ULL, 0x000fea000383ffffULL, 0x00000001ff467807ULL, 0x008fe40004000000ULL,
0x0001ccc000477802ULL, 0x000fc40000000f00ULL, 0x00000a8000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff497224ULL, 0x000fe200078e004aULL, 0xfffefbe000007947ULL, 0x000fea000383ffffULL,
0x00000001ff467807ULL, 0x000fe40005000000ULL, 0x0001cd1000477802ULL, 0x000fc40000000f00ULL,
0x00000a3000007944ULL, 0x014fea0003c00000ULL, 0xfffefc3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff477224ULL, 0x000fe200078e0046ULL, 0x0001cd6000467802ULL, 0x000fe20000000f00ULL,
0x000000ffff5a7224ULL, 0x000fc400078e004bULL, 0x000009a000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff467224ULL, 0x004fe200078e005aULL, 0xfffefce000007947ULL, 0x000fea000383ffffULL,
0x000000ffff477224ULL, 0x000fe200078e0046ULL, 0x0001cdc000467802ULL, 0x000fe20000000f00ULL,
0x000000ffff5a7224ULL, 0x000fc400078e004bULL, 0x0000094000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff467224ULL, 0x004fe200078e005aULL, 0xfffefde000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5a7224ULL, 0x000fe200078e0043ULL, 0x0001ce2000467802ULL, 0x000fe20000000f00ULL,
0x000000ffff477224ULL, 0x000fc400078e0044ULL, 0x000008e000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff197224ULL, 0x004fe200078e005aULL, 0xffff021000007947ULL, 0x000fea000383ffffULL,
0x000000ffff477224ULL, 0x000fe200078e0018ULL, 0x0001ce8000467802ULL, 0x000fe20000000f00ULL,
0x000000ffff5a7224ULL, 0x000fc400078e0043ULL, 0x0000088000007944ULL, 0x01efea0003c00000ULL,
0x000000ffff187224ULL, 0x004fe200078e005aULL, 0xffff01e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5a7224ULL, 0x000fe200078e002cULL, 0x0001cee000467802ULL, 0x000fe20000000f00ULL,
0x000000ffff477224ULL, 0x000fc400078e002dULL, 0x0000082000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff197224ULL, 0x004fe200078e005aULL, 0xffff261000007947ULL, 0x000fea000383ffffULL,
0x000000ffff477224ULL, 0x000fe200078e0018ULL, 0x0001cf4000467802ULL, 0x000fe20000000f00ULL,
0x000000ffff5a7224ULL, 0x000fc400078e002cULL, 0x000007c000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff187224ULL, 0x004fe200078e005aULL, 0xffff25e000007947ULL, 0x000fea000383ffffULL,
0x00000001ff467807ULL, 0x008fe40004000000ULL, 0x0001cf9000477802ULL, 0x000fc40000000f00ULL,
0x000007b000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff497224ULL, 0x000fe200078e004aULL,
0xffff4ba000007947ULL, 0x000fea000383ffffULL, 0x00000001ff467807ULL, 0x000fe40004800000ULL,
0x0001cfe000477802ULL, 0x000fc40000000f00ULL, 0x0000076000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff1d7224ULL, 0x000fe200078e004aULL, 0xffff4be000007947ULL, 0x000fea000383ffffULL,
0x000000ffff477224ULL, 0x000fe200078e001eULL, 0x0001d04000467802ULL, 0x000fe20000000f00ULL,
0x000000ffff5a7224ULL, 0x000fc400078e0044ULL, 0x000006c000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff1e7224ULL, 0x004fe200078e005aULL, 0xffff4c9000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5a7224ULL, 0x000fe200078e0044ULL, 0x0001d0a000467802ULL, 0x000fe20000000f00ULL,
0x000000ffff477224ULL, 0x000fc400078e001eULL, 0x0000066000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff1e7224ULL, 0x004fe200078e005aULL, 0xffff4d9000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5a7224ULL, 0x000fe200078e001dULL, 0x0001d10000467802ULL, 0x000fe20000000f00ULL,
0x000000ffff477224ULL, 0x000fc400078e001eULL, 0x0000060000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff197224ULL, 0x004fe200078e005aULL, 0xffff51c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff477224ULL, 0x000fe200078e0018ULL, 0x0001d16000467802ULL, 0x000fe20000000f00ULL,
0x000000ffff5a7224ULL, 0x000fc400078e001dULL, 0x000005a000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff187224ULL, 0x004fe200078e005aULL, 0xffff519000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5a7224ULL, 0x000fe200078e0000ULL, 0x0001d1c000467802ULL, 0x000fe20000000f00ULL,
0x000000ffff477224ULL, 0x000fc400078e0002ULL, 0x0000054000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff197224ULL, 0x004fe200078e005aULL, 0xffff75e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff477224ULL, 0x000fe200078e0018ULL, 0x0001d22000467802ULL, 0x000fe20000000f00ULL,
0x000000ffff5a7224ULL, 0x000fc400078e0000ULL, 0x000004e000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff187224ULL, 0x004fe200078e005aULL, 0xffff75b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff087224ULL, 0x000fe200078e003bULL, 0x0001d28000397802ULL, 0x000fe20000000f00ULL,
0x00000002ff097424ULL, 0x000fc400078e00ffULL, 0x0000043000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e003aULL, 0xffffe6c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff087224ULL, 0x000fe200078e0005ULL, 0x0001d2e000397802ULL, 0x000fe20000000f00ULL,
0x00000002ff097424ULL, 0x000fc400078e00ffULL, 0x000003d000007944ULL, 0x012fea0003c00000ULL,
0x0000003a0500720bULL, 0x004fe20003f1e000ULL, 0x000000ffff087224ULL, 0x000fe200078e0006ULL,
0x0001d34000397802ULL, 0x000fe20000000f00ULL, 0x00000002ff097424ULL, 0x000fe200078e00ffULL,
0x000000053a057208ULL, 0x000fc80004000000ULL, 0x0000037000007944ULL, 0x000fea0003c00000ULL,
0x0000003a0600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff087224ULL, 0x000fe200078e0007ULL,
0x0001d3a000397802ULL, 0x000fe20000000f00ULL, 0x00000002ff097424ULL, 0x000fe200078e00ffULL,
0x000000063a067208ULL, 0x000fc80004000000ULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x0000003a0700720bULL, 0x004fe20003f1e000ULL, 0x000000ffff087224ULL, 0x000fe200078e003bULL,
0x0001d40000397802ULL, 0x000fe20000000f00ULL, 0x00000001ff097424ULL, 0x000fe200078e00ffULL,
0x000000073a077208ULL, 0x000fc80004000000ULL, 0x000002b000007944ULL, 0x000fea0003c00000ULL,
0x0000003a3b00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff087224ULL, 0x000fe200078e0005ULL,
0x0001d46000397802ULL, 0x000fe20000000f00ULL, 0x00000001ff097424ULL, 0x000fe200078e00ffULL,
0x0000003b3a047208ULL, 0x000fc80004000000ULL, 0x0000025000007944ULL, 0x000fea0003c00000ULL,
0x0000003a0500720bULL, 0x004fe20003f1e000ULL, 0x000000ffff087224ULL, 0x000fe200078e0006ULL,
0x0001d4c000397802ULL, 0x000fe20000000f00ULL, 0x00000001ff097424ULL, 0x000fe200078e00ffULL,
0x000000053a057208ULL, 0x000fc80004000000ULL, 0x000001f000007944ULL, 0x000fea0003c00000ULL,
0x0000003a0600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff087224ULL, 0x000fe200078e0007ULL,
0x0001d52000397802ULL, 0x000fe20000000f00ULL, 0x00000001ff097424ULL, 0x000fe200078e00ffULL,
0x000000063a067208ULL, 0x000fc80004000000ULL, 0x0000019000007944ULL, 0x000fea0003c00000ULL,
0xffffe59000007947ULL, 0x000fea000383ffffULL, 0x0180000002007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000047812ULL, 0x000fc800078ec0ffULL,
0x018000000400780cULL, 0x000fda0003f05070ULL, 0x0000000200008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0400720cULL, 0x040fe40003f25070ULL,
0x008000000400780cULL, 0x000fe40003f02070ULL, 0x00000001ff047807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000004ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff02ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000002027812ULL, 0x002fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000004ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000200007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x006fe400078e0003ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffe295002007950ULL, 0x000fea0003c3ffffULL, 0x0000003d00007348ULL, 0x000fe80003800000ULL,
0x0c000009083a7389ULL, 0x0002a400000e003cULL, 0x000000ffff087224ULL, 0x002fe400078e0039ULL,
0x00000000ff097424ULL, 0x000fc800078e00ffULL, 0xfffe290008007950ULL, 0x000fea0003c3ffffULL,
0x0000001b00007348ULL, 0x000fe80003800000ULL, 0x000000475a5a7389ULL, 0x0002a400000e001cULL,
0x00000000ff477424ULL, 0x002fc800078e00ffULL, 0xfffe28c046007950ULL, 0x000fea0003c3ffffULL,
0x000000014600780cULL, 0x000fe20003f45070ULL, 0x0000001d00007348ULL, 0x000fd80003800000ULL,
0x0000000000467806ULL, 0x000fc800050e0100ULL, 0x0000001d464a7212ULL, 0x000fe200078ec0ffULL,
0x000000ffff467224ULL, 0x000fe400078e0047ULL, 0x00000000ff477424ULL, 0x000fc800078e00ffULL,
0xfffe285046007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000200000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005e7ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000748ULL, 0x0000000000000288ULL, 0x0000001a00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009d0ULL, 0x0000000000000408ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000dd8ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e98ULL, 0x0000000000000a04ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000018a0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000018b0ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000007bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001940ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001944ULL, 0x00000000000001b0ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001b00ULL, 0x000000000001d880ULL, 0x9900001a00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x0000000100000089ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001f380ULL, 0x0000000000000044ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001f3d0ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x000000000001f750ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001940ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000001da40ULL, 0x000000000001da40ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x000000000001f380ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x000000000001f750ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_1_kvt_e4m3_pagedKV_64_nqpkv_8_m_8_sm_89_cubin_len = 129072;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
