/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_1_kvt_int8_nqpkv_8_m_8_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x00000000000239d0ULL, 0x0000000000023650ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f34314944327961ULL, 0x6f6c66625f766e5fULL,
0x326a4c3236317461ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL,
0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x336a4c4536316a4cULL, 0x4c49746132454532ULL,
0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4534366aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL,
0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL,
0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL, 0x45326a4c4545316aULL, 0x7461324545316a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x4939494432796172ULL, 0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL,
0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL,
0x4c4545346a4c6a49ULL, 0x36316a4c4532336aULL, 0x624c497461324545ULL, 0x31534b5245454531ULL,
0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL,
0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL, 0x4c4545326a4c4532ULL, 0x4545316a4c45326aULL,
0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x45386a4c4545346aULL,
0x7461324545386a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL,
0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL,
0x6a4c4536316a4c45ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5f2400676e696469ULL, 0x616e7265746e695fULL, 0x635f5f245f305f6cULL,
0x30326d735f616475ULL, 0x5f6e725f7063725fULL, 0x5f3233665f7a7466ULL, 0x68746170776f6c73ULL,
0x65746e695f5f2400ULL, 0x245f315f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL,
0x6c66625f636e7973ULL, 0x695f5f2400705f79ULL, 0x5f6c616e7265746eULL, 0x6475635f5f245f32ULL,
0x735f30376d735f61ULL, 0x5f636e79736c6668ULL, 0x5f2400705f786469ULL, 0x616e7265746e695fULL,
0x635f5f245f335f6cULL, 0x30376d735f616475ULL, 0x6e797365746f765fULL, 0x746f6c6c61625f63ULL,
0x742e616c65722e00ULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL,
0x5f6c656e72656b2eULL, 0x72656b240061686dULL, 0x2461686d5f6c656eULL, 0x657479426d656d73ULL,
0x2e766e2e00667542ULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x61705f0061686d5fULL,
0x6265642e006d6172ULL, 0x656d6172665f6775ULL, 0x65642e6c65722e00ULL, 0x6d6172665f677562ULL,
0x2e616c65722e0065ULL, 0x72665f6775626564ULL, 0x2e766e2e00656d61ULL, 0x697463612e6c6572ULL,
0x0000000000006e6fULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c0001000000adULL, 0x0000000000000034ULL, 0x0000000000000010ULL, 0x000c0001000000ebULL,
0x000000000000001cULL, 0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c00010000016bULL, 0x000000000000002cULL, 0x0000000000000004ULL,
0x000c0001000001b5ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c0001000001fbULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000242ULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000c000100000288ULL, 0x0000000000000030ULL, 0x0000000000000004ULL,
0x000c0001000002d6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c000100000324ULL,
0x0000000000000018ULL, 0x0000000000000004ULL, 0x000c000100000372ULL, 0x000000000000000cULL,
0x0000000000000004ULL, 0x000c0001000003b9ULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000c000100000407ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c00010000044cULL,
0x0000000000000020ULL, 0x0000000000000004ULL, 0x000b002200000492ULL, 0x00000000000217b0ULL,
0x0000000000000180ULL, 0x000b0022000004c5ULL, 0x0000000000021930ULL, 0x0000000000000040ULL,
0x000b0022000004f0ULL, 0x0000000000021970ULL, 0x0000000000000040ULL, 0x000b00220000051aULL,
0x00000000000219b0ULL, 0x0000000000000150ULL, 0x000a000300000588ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00040003000005a8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00070003000005d8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL,
0x0000000000000000ULL, 0x0000000000021b00ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000217b000000000ULL,
0x0000040400000000ULL, 0x810c0000015c0400ULL, 0x0084840400288080ULL, 0x0000000000000000ULL,
0x0000009cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x80808a0828808081ULL, 0x92082880808c0828ULL, 0x2880809308288080ULL,
0x809b082880809408ULL, 0x082880809c082880ULL, 0x8080a0082880809dULL, 0xa208288080a10828ULL,
0x288080a308288080ULL, 0x80bc08288080a508ULL, 0x08288080c0082880ULL, 0x8080d408288080c6ULL,
0xd908288080d80828ULL, 0x2880808408288080ULL, 0x0003102880828016ULL, 0x9200000000000000ULL,
0x0000220028808084ULL, 0x0000002cffffffffULL, 0x0000007000000000ULL, 0x000217b000000000ULL,
0x0000018000000000ULL, 0x0000580400000000ULL, 0x8082288080840900ULL, 0x0000000000002880ULL,
0x000000a4ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x80808b0828808081ULL, 0x8d082880808c0828ULL, 0x2880808e08288080ULL,
0x8090082880808f08ULL, 0x0828808092082880ULL, 0x8080940828808093ULL, 0x9c082880809b0828ULL,
0x2880809d08288080ULL, 0x80a208288080a008ULL, 0x08288080a3082880ULL, 0x8080bc08288080a5ULL,
0xc608288080c00828ULL, 0x288080d408288080ULL, 0x808808288080d908ULL, 0x1028808280162880ULL,
0x0000000000000003ULL, 0x2200288080889200ULL, 0x0000001cffffffffULL, 0x0000015000000000ULL,
0x0002193000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x000000a4ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x80808b0828808081ULL, 0x8d082880808c0828ULL, 0x2880808e08288080ULL, 0x8090082880808f08ULL,
0x0828808092082880ULL, 0x8080940828808093ULL, 0x9c082880809b0828ULL, 0x2880809d08288080ULL,
0x80a208288080a008ULL, 0x08288080a3082880ULL, 0x8080bc08288080a5ULL, 0xd408288080c60828ULL,
0x288080d808288080ULL, 0x80c008288080d908ULL, 0x1028808280162880ULL, 0x0000000000000003ULL,
0x2200288080c09200ULL, 0x0000001cffffffffULL, 0x0000022800000000ULL, 0x0002197000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x000000a4ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80808b0828808081ULL,
0x8d082880808c0828ULL, 0x2880808e08288080ULL, 0x8090082880808f08ULL, 0x0828808092082880ULL,
0x8080940828808093ULL, 0x9c082880809b0828ULL, 0x2880809d08288080ULL, 0x80a208288080a008ULL,
0x08288080a3082880ULL, 0x8080bc08288080a5ULL, 0xd408288080c00828ULL, 0x288080d808288080ULL,
0x80c608288080d908ULL, 0x1028808280162880ULL, 0x0000000000000003ULL, 0x2200288080c69200ULL,
0x0000002cffffffffULL, 0x0000030000000000ULL, 0x000219b000000000ULL, 0x0000015000000000ULL,
0x0000180400000000ULL, 0x80c0288080c60900ULL, 0x0000000000002880ULL, 0x0000001a00082f04ULL,
0x00082304000000eeULL, 0x0000000000000016ULL, 0x0000001600081204ULL, 0x0008110400000000ULL,
0x0000000000000016ULL, 0x0000001500082304ULL, 0x0008120400000000ULL, 0x0000000000000015ULL,
0x0000001500081104ULL, 0x0008230400000000ULL, 0x0000000000000014ULL, 0x0000001400081204ULL,
0x0008110400000000ULL, 0x0000000000000014ULL, 0x0000001300082304ULL, 0x0008120400000000ULL,
0x0000000000000013ULL, 0x0000001300081104ULL, 0x0008230400000000ULL, 0x000000000000001aULL,
0x0000001a00081204ULL, 0x0008110400000000ULL, 0x000000000000001aULL, 0x0000007b00043704ULL,
0x00080a0400003501ULL, 0x0048016000000017ULL, 0x000c170400481903ULL, 0x0040000600000000ULL,
0x000c17040021f000ULL, 0x0038000500000000ULL, 0x000c17040021f000ULL, 0x0030000400000000ULL,
0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040061f000ULL, 0x0010000200000000ULL,
0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL,
0x00ff1b030011f000ULL, 0x0000002000043104ULL, 0xffffffff01982904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x01982804ffffffffULL, 0x0000013000000100ULL, 0x00001c7000000470ULL,
0x00001df000001d00ULL, 0x000023b000001f60ULL, 0x00002450000023e0ULL, 0x00005010000024c0ULL,
0x000050b000005040ULL, 0x00007c8000005120ULL, 0x00007e2000007d10ULL, 0x000083f000007f80ULL,
0x0000849000008420ULL, 0x0000ae8000008500ULL, 0x0000af200000aeb0ULL, 0x0000d9f00000af90ULL,
0x0000db900000da80ULL, 0x0000e1600000dcf0ULL, 0x0000e2000000e190ULL, 0x00010be00000e270ULL,
0x00010c8000010c10ULL, 0x0001376000010cf0ULL, 0x00013900000137f0ULL, 0x00013ed000013a60ULL,
0x00013f7000013f00ULL, 0x0001698000013fe0ULL, 0x00016a20000169b0ULL, 0x00018b3000016a90ULL,
0x000192f000018b40ULL, 0x0001f8900001f850ULL, 0x0001f8b00001f8a0ULL, 0x0001f9200001f900ULL,
0x0001f9500001f940ULL, 0x00020650000205f0ULL, 0x00020750000206d0ULL, 0x00020850000207d0ULL,
0x00020940000208d0ULL, 0x00020a00000209a0ULL, 0x00020ad000020a60ULL, 0x00020bc000020b50ULL,
0x00020cb000020c40ULL, 0x00020d7000020d10ULL, 0x00020e5000020de0ULL, 0x00020f4000020ed0ULL,
0x0002103000020fc0ULL, 0x000210f000021090ULL, 0x000211c000021150ULL, 0x000212b000021240ULL,
0x000213a000021330ULL, 0x0002149000021410ULL, 0x0002159000021510ULL, 0x0002169000021610ULL,
0x0002179000021710ULL, 0x0000021006003904ULL, 0x00018600000000ffULL, 0x00000260003f0100ULL,
0x000186080000000fULL, 0x00000300003f0120ULL, 0x000186880000000fULL, 0x00000410003f0120ULL,
0x000186a80000000fULL, 0x00000440003f0120ULL, 0x000186b8000000ffULL, 0x00000500003f0100ULL,
0x00018600000000ffULL, 0x00000600003f0107ULL, 0x0001868c0000002cULL, 0x00000690003f0102ULL,
0x000186880000002cULL, 0x00000d10003f0101ULL, 0x000186a8000000ffULL, 0x00000e30003f0107ULL,
0x000186a8000000ffULL, 0x00000e90003f0101ULL, 0x000186b8000000ffULL, 0x00000fc0003f0101ULL,
0x000186bc000000ffULL, 0x00001190003f0105ULL, 0x000186bc000000ffULL, 0x000018c0003f0105ULL,
0x000186b0000000ffULL, 0x00001940003f0107ULL, 0x000186b0000000ffULL, 0x000019a0003f0101ULL,
0x000186080000002cULL, 0x000019c0003f0101ULL, 0x0001860c0000002cULL, 0x00001b90003f0105ULL,
0x0001860c0000002cULL, 0x00002110003f0105ULL, 0x000186ac000000ffULL, 0x000022e0003f0105ULL,
0x000186ac000000ffULL, 0x00004420003f0105ULL, 0x000186b8000000ffULL, 0x00004450003f0101ULL,
0x000186bc000000ffULL, 0x00004610003f0105ULL, 0x000186bc000000ffULL, 0x00004cf0003f0105ULL,
0x000186a8000000ffULL, 0x00004d70003f0107ULL, 0x000186a8000000ffULL, 0x00004d90003f0101ULL,
0x000186b4000000ffULL, 0x00004f60003f0105ULL, 0x000186b4000000ffULL, 0x00006fa0003f0105ULL,
0x000186b8000000ffULL, 0x00007010003f0101ULL, 0x00018688000000ffULL, 0x00007070003f0101ULL,
0x000186bc000000ffULL, 0x00007240003f0105ULL, 0x000186bc000000ffULL, 0x00007920003f0105ULL,
0x000186b0000000ffULL, 0x000079a0003f0107ULL, 0x000186b0000000ffULL, 0x00007a00003f0101ULL,
0x000186280000002cULL, 0x00007a20003f0101ULL, 0x0001862c0000002cULL, 0x00007bf0003f0105ULL,
0x0001862c0000002cULL, 0x00008150003f0105ULL, 0x000186ac000000ffULL, 0x00008320003f0105ULL,
0x000186ac000000ffULL, 0x0000a280003f0105ULL, 0x000186b8000000ffULL, 0x0000a2b0003f0101ULL,
0x000186bc000000ffULL, 0x0000a470003f0105ULL, 0x000186bc000000ffULL, 0x0000ab50003f0105ULL,
0x000186a8000000ffULL, 0x0000abd0003f0107ULL, 0x000186a8000000ffULL, 0x0000ac00003f0101ULL,
0x000186b4000000ffULL, 0x0000add0003f0105ULL, 0x000186b4000000ffULL, 0x0000cd20003f0105ULL,
0x000186b8000000ffULL, 0x0000cd90003f0101ULL, 0x00018690000000ffULL, 0x0000cde0003f0101ULL,
0x000186bc000000ffULL, 0x0000cfb0003f0105ULL, 0x000186bc000000ffULL, 0x0000d690003f0105ULL,
0x000186b0000000ffULL, 0x0000d710003f0107ULL, 0x000186b0000000ffULL, 0x0000d770003f0101ULL,
0x000186480000002cULL, 0x0000d790003f0101ULL, 0x0001864c0000002cULL, 0x0000d960003f0105ULL,
0x0001864c0000002cULL, 0x0000dec0003f0105ULL, 0x000186ac000000ffULL, 0x0000e090003f0105ULL,
0x000186ac000000ffULL, 0x0000fff0003f0105ULL, 0x000186b8000000ffULL, 0x00010020003f0101ULL,
0x000186bc000000ffULL, 0x000101e0003f0105ULL, 0x000186bc000000ffULL, 0x000108c0003f0105ULL,
0x000186a8000000ffULL, 0x00010940003f0107ULL, 0x000186a8000000ffULL, 0x00010960003f0101ULL,
0x000186b4000000ffULL, 0x00010b30003f0105ULL, 0x000186b4000000ffULL, 0x00012a80003f0105ULL,
0x000186b8000000ffULL, 0x00012af0003f0101ULL, 0x00018698000000ffULL, 0x00012b50003f0101ULL,
0x000186bc000000ffULL, 0x00012d20003f0105ULL, 0x000186bc000000ffULL, 0x00013400003f0105ULL,
0x000186b0000000ffULL, 0x00013480003f0107ULL, 0x000186b0000000ffULL, 0x000134e0003f0101ULL,
0x000186680000002cULL, 0x00013500003f0101ULL, 0x0001866c0000002cULL, 0x000136d0003f0105ULL,
0x0001866c0000002cULL, 0x00013c30003f0105ULL, 0x000186ac000000ffULL, 0x00013e00003f0105ULL,
0x000186ac000000ffULL, 0x00015d60003f0105ULL, 0x000186b8000000ffULL, 0x00015d90003f0101ULL,
0x000186bc000000ffULL, 0x00015f50003f0105ULL, 0x000186bc000000ffULL, 0x00016650003f0105ULL,
0x000186a8000000ffULL, 0x000166d0003f0107ULL, 0x000186a8000000ffULL, 0x00016700003f0101ULL,
0x000186b4000000ffULL, 0x000168d0003f0105ULL, 0x000186b4000000ffULL, 0x00018820003f0105ULL,
0x000186b8000000ffULL, 0x00018880003f0101ULL, 0x000186a0000000ffULL, 0x00019500003f0101ULL,
0x00018600000000ffULL, 0x0001ab50003f0101ULL, 0x00018604000000ffULL, 0x0001ad20003f0105ULL,
0x00018604000000ffULL, 0x0001b0a0003f0105ULL, 0x00018600000000ffULL, 0x0001b0d0003f0101ULL,
0x00018604000000ffULL, 0x0001b290003f0105ULL, 0x00018604000000ffULL, 0x0001ec90003f0105ULL,
0x000000000000002cULL, 0x0001eda0003f0101ULL, 0x000000040000002cULL, 0x0001ef70003f0105ULL,
0x000000040000002cULL, 0x00020440003f0105ULL, 0x000000000000003cULL, 0x000204a0003f0101ULL,
0x000000080000003cULL, 0x00020500003f0101ULL, 0x000000100000003cULL, 0x00020570003f0101ULL,
0x000000180000003cULL, 0x00053803003f0101ULL, 0x0001945000101c04ULL, 0x0001b3a00001b2f0ULL,
0x00000401000205b0ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x00000000000003c4ULL, 0x0000001a00000002ULL,
0x00000000000002ecULL, 0x0000001a00000002ULL, 0x0000000000000214ULL, 0x0000001a00000002ULL,
0x000000000000012cULL, 0x0000001a00000002ULL, 0x0000000000000044ULL, 0x0000001a00000002ULL,
0x00000000000003a1ULL, 0x0000001a00000002ULL, 0x00000000000002c9ULL, 0x0000001a00000002ULL,
0x00000000000001f1ULL, 0x0000001a00000002ULL, 0x0000000000000107ULL, 0x0000001a00000002ULL,
0x0000000000018700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x00000000000f7919ULL, 0x000e620000002100ULL,
0x0000000000127806ULL, 0x000fe200038e0000ULL, 0x00005800ff057624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000027919ULL, 0x000ea20000002300ULL,
0x0000001200067300ULL, 0x000fe200000e0000ULL, 0x0000000805057824ULL, 0x000fe400078e00ffULL,
0x0000000000037919ULL, 0x000ee20000002200ULL, 0x00000200ff0b7424ULL, 0x000fc600078e00ffULL,
0x00000000002f7919ULL, 0x000f220000000000ULL, 0x0000001200127309ULL, 0x000ea60000000000ULL,
0x0000000000297919ULL, 0x000f280000002600ULL, 0x0000000000107919ULL, 0x000f220000002700ULL,
0x00000005ff2e7819ULL, 0x002fc6000001160fULL, 0x0000000000077919ULL, 0x000e680000000000ULL,
0x00001fff020d7589ULL, 0x0045e200000e0000ULL, 0x000000ffff127224ULL, 0x000fe400078e0a12ULL,
0x0000010002007a24ULL, 0x008fe200078e0203ULL, 0x00001fff2e2e7589ULL, 0x000ee600000e0000ULL,
0x00000000000f7a24ULL, 0x000fc400078e020fULL, 0x000000102f0c7824ULL, 0x010fe400078e00ffULL,
0x0000000829007824ULL, 0x000fe200078e00ffULL, 0x000000ff0f00720cULL, 0x040fe40003f25270ULL,
0x0000000f0f00780cULL, 0x000fe20003f44070ULL, 0x0000001005007224ULL, 0x000fe200078e0200ULL,
0x000000030f00780cULL, 0x040fe40003f64070ULL, 0x0000007f0f00780cULL, 0x000fe40003f84070ULL,
0x000000070600720cULL, 0x002fca0003f02070ULL, 0x3fffff80ff029424ULL, 0x004fe400078e00ffULL,
0x7fffff80ff039424ULL, 0x000fe400078e00ffULL, 0x000000040d047824ULL, 0x008fe400078e022eULL,
0x7fffffc0ff05a424ULL, 0x000fe200078e00ffULL, 0x01860002ff009388ULL, 0x0003e20000000a00ULL,
0x0000000204087824ULL, 0x000fe400078e00ffULL, 0x3fffffc0ff04a424ULL, 0x000fc400078e00ffULL,
0x0000000108097824ULL, 0x040fe400078e022fULL, 0x00000020080e7824ULL, 0x000fe200078e00ffULL,
0x018608040f00a388ULL, 0x0005e20000008a00ULL, 0x000000010f00780cULL, 0x000fe20003f44070ULL,
0x0000000100027824ULL, 0x002fe400078e0208ULL, 0xffffffe00e0e7812ULL, 0x000fe200078ee209ULL,
0x3fffff60ff06b424ULL, 0x000fe200078e00ffULL, 0x0000000808097817ULL, 0x000fe20007800000ULL,
0x7fffff60ff07b424ULL, 0x000fc400078e00ffULL, 0xff317217ff0ac424ULL, 0x000fe400078e00ffULL,
0x0000000109097824ULL, 0x000fe200078e0a08ULL, 0x0000000108087810ULL, 0x000fe20007ffe0ffULL,
0x018688060f00b388ULL, 0x0003e20000008a00ULL, 0x00005c0002027625ULL, 0x000fe400078e000bULL,
0x000000ff0900720cULL, 0x040fe20003f63070ULL, 0x0184000a0f00c388ULL, 0x0007e20000004800ULL,
0x0000000100047824ULL, 0x004fe200078e0208ULL, 0x000000010900780cULL, 0x000fe20003f83070ULL,
0x0000000108007824ULL, 0x000fc400078e022fULL, 0x0000002008117824ULL, 0x000fe400078e00ffULL,
0x00005c0004047625ULL, 0x000fe200078e000bULL, 0x000001f00c077812ULL, 0x002fe400078ec0ffULL,
0xffffffe011007812ULL, 0x000fe200078ee200ULL, 0x3fffff00ff08a424ULL, 0x000fe200078e00ffULL,
0x0000000702067210ULL, 0x080fe20007fbe0ffULL, 0x7fffff00ff09a424ULL, 0x000fe200078e00ffULL,
0x0000000704047210ULL, 0x000fe20007fde0ffULL, 0x3fffff80ff0a9424ULL, 0x008fc400078e00ffULL,
0x7fffff80ff0b9424ULL, 0x000fe200078e00ffULL, 0x0186a8080f00a388ULL, 0x000fe20000008a00ULL,
0x000000ffff077224ULL, 0x000fe400028e0603ULL, 0x000000100e117824ULL, 0x000fe200078e00ffULL,
0x0186b80aff009388ULL, 0x000fe20000000a00ULL, 0x000000ffff057224ULL, 0x000fe400030e0605ULL,
0x0000001000137824ULL, 0x000fe200078e00ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ffff007224ULL, 0x000fe200078e0012ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006117faeULL, 0x0003e2000d901c46ULL, 0x00000004ff037424ULL, 0x000fc600078e00ffULL,
0x0000000004137faeULL, 0x0003e2000e101c46ULL, 0x0000600010027625ULL, 0x000fc600078e0003ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x01860400ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01860000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000006022d7981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0d00720cULL, 0x000fc40003f05270ULL,
0x000000ff2d007810ULL, 0x006fc80007ffe0ffULL, 0x00000008ff2b7819ULL, 0x000fce0000011600ULL,
0x00018e9000008947ULL, 0x000fea0003800000ULL, 0x000000082e2c7824ULL, 0x000fe400078e00ffULL,
0x00000003ff037424ULL, 0x000fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01868c032cff738cULL, 0x0003e20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000001ff0000780cULL, 0x000fe20003f04070ULL, 0x00000002102a7824ULL, 0x000fe200078e00ffULL,
0x0000580029037a10ULL, 0x002fe20007ffe0ffULL, 0x018688002cff7f8cULL, 0x0003e8000c80043fULL,
0x000058002a2a7a24ULL, 0x000fcc00078e0203ULL, 0x0000038000000947ULL, 0x000fea0003800000ULL,
0x0000002c2d037217ULL, 0x002fe20007800000ULL, 0x00000100ff0f7424ULL, 0x000fe200078e00ffULL,
0x00000004ff007819ULL, 0x100fe4000001162fULL, 0x000000f00c0d7812ULL, 0x000fe200078ec0ffULL,
0x0000000103037824ULL, 0x000fe200078e0a2cULL, 0x0000000200047810ULL, 0x000fe20007ffe0ffULL,
0x000000012c027824ULL, 0x000fe200078e0200ULL, 0x0000000400057810ULL, 0x040fe40007ffe0ffULL,
0x000000030000720cULL, 0x080fe20003f66070ULL, 0x0000001002097824ULL, 0x000fe200078e00ffULL,
0x0000000600087810ULL, 0x000fe20007ffe0ffULL, 0x0000000102007824ULL, 0x000fe200078e022fULL,
0x000000030400720cULL, 0x080fe20003f46070ULL, 0x000000012c047824ULL, 0x040fe200078e0204ULL,
0x000000030500720cULL, 0x080fe20003f26070ULL, 0x000000012c067824ULL, 0x000fe200078e0205ULL,
0x000000030800720cULL, 0x000fe20003f06070ULL, 0x000062002a027a24ULL, 0x000fe200078e0202ULL,
0xfffffff009007812ULL, 0x000fe200078ee200ULL, 0x0000000104057824ULL, 0x000fc400078e022fULL,
0x00000010040a7824ULL, 0x000fe400078e00ffULL, 0x000000012c087824ULL, 0x000fe400078e0208ULL,
0x0000000106077824ULL, 0x000fe200078e022fULL, 0xfffffff00a0a7812ULL, 0x000fe200078ee205ULL,
0x00000010060e7824ULL, 0x000fe400078e00ffULL, 0x00005e0002027625ULL, 0x000fc600078e000fULL,
0xfffffff00e0e7812ULL, 0x000fe200078ee207ULL, 0x000062002a047a24ULL, 0x000fe200078e0204ULL,
0x0000000d02027210ULL, 0x000fe20007fbe0ffULL, 0x000062002a067a24ULL, 0x040fe400078e0206ULL,
0x000062002a097a24ULL, 0x000fe400078e0208ULL, 0x00005e0004047625ULL, 0x000fc800078e000fULL,
0x00000001080b7824ULL, 0x000fe200078e022fULL, 0x0000000d04047210ULL, 0x000fe20007f9e0ffULL,
0x00000010080c7824ULL, 0x000fe400078e00ffULL, 0x00005e0006067625ULL, 0x000fc600078e000fULL,
0xfffffff00c0c7812ULL, 0x000fe200078ee20bULL, 0x00005e0009087625ULL, 0x000fe200078e000fULL,
0x00014000000b7811ULL, 0x000fe400078e20ffULL, 0x000140000e0f7811ULL, 0x000fe200078e20ffULL,
0x000000ffff037224ULL, 0x000fe200028e0603ULL, 0x0000000d06067210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff057224ULL, 0x000fe200020e0605ULL, 0x0000000d08087210ULL, 0x000fe40007fde0ffULL,
0x000140000a0d7811ULL, 0x000fe200078e20ffULL, 0x000000ffff077224ULL, 0x000fe200028e0607ULL,
0x000140000c117811ULL, 0x000fe200078e20ffULL, 0x000000ffff097224ULL, 0x000fe200030e0609ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000020b7faeULL, 0x0003e8000d901c46ULL,
0x00000000040d7faeULL, 0x0003e8000d101c46ULL, 0x00000000060f7faeULL, 0x0003e8000c901c46ULL,
0x0000000008117faeULL, 0x0003e2000c101c46ULL, 0x000002d000007947ULL, 0x000fea0003800000ULL,
0x0000002c2f007211ULL, 0x002fe400078fe0ffULL, 0x000000f00c0f7812ULL, 0x000fc400078ec0ffULL,
0x0000000400057810ULL, 0x040fe20007ffe0ffULL, 0x0000000100027824ULL, 0x140fe200078e022fULL,
0x0000000200037810ULL, 0x040fe20007ffe0ffULL, 0x0000001000077824ULL, 0x000fe400078e00ffULL,
0x0000000105067824ULL, 0x140fe400078e022fULL, 0x0000001005097824ULL, 0x000fe200078e00ffULL,
0xfffffff0070a7812ULL, 0x000fe200078ee202ULL, 0x0000000103047824ULL, 0x040fe400078e022fULL,
0x00000010030d7824ULL, 0x000fe200078e00ffULL, 0xfffffff0090e7812ULL, 0x000fe200078ee206ULL,
0x00000100ff097424ULL, 0x000fc400078e00ffULL, 0x000062002a027a24ULL, 0x040fe200078e0200ULL,
0xfffffff00d0d7812ULL, 0x000fe200078ee204ULL, 0x000062002a047a24ULL, 0x000fe200078e0203ULL,
0x0000000600007810ULL, 0x000fe20007ffe0ffULL, 0x00005e0002027625ULL, 0x000fe200078e0009ULL,
0x000140000d0d7811ULL, 0x000fc600078e20ffULL, 0x000062002a067a24ULL, 0x000fe200078e0205ULL,
0x0000000f02027210ULL, 0x000fe20007f1e0ffULL, 0x000062002a087a24ULL, 0x000fe400078e0200ULL,
0x00005e0004047625ULL, 0x000fc800078e0009ULL, 0x00005e0006067625ULL, 0x000fe200078e0009ULL,
0x0000000f04047210ULL, 0x000fc60007f3e0ffULL, 0x00000001000b7824ULL, 0x000fe400078e022fULL,
0x00005e0008087625ULL, 0x000fc800078e0009ULL, 0x0000001000007824ULL, 0x000fe200078e00ffULL,
0x0000000f08087210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff037224ULL, 0x000fe200000e0603ULL,
0x0000000f06067210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff057224ULL, 0x000fe200008e0605ULL,
0xfffffff000007812ULL, 0x000fe200078ee20bULL, 0x000000ffff097224ULL, 0x000fe200010e0609ULL,
0x000140000a0b7811ULL, 0x000fe200078e20ffULL, 0x000000ffff077224ULL, 0x000fe200000e0607ULL,
0x000140000e0f7811ULL, 0x000fe400078e20ffULL, 0x0001400000117811ULL, 0x000fe200078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000020b7faeULL, 0x0003e8000b901c46ULL,
0x00000000040d7faeULL, 0x0003e8000b901c46ULL, 0x00000000060f7faeULL, 0x0003e8000b901c46ULL,
0x0000000008117faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000ff2b00720cULL, 0x000fe20003f05270ULL, 0x000000ffff297224ULL, 0x000fe200078e00ffULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0186a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000067805ULL, 0x002fe2000001ff00ULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff0d7224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0186a800ff3c7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0186b800ff027f8cULL, 0x000ea2000c80043fULL,
0x000000ffff0c7224ULL, 0x000fe200078e00ffULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x000179a000008947ULL, 0x000fea0003800000ULL,
0x000000ffff427224ULL, 0x004fe400078e0003ULL, 0xff317217ff3c7424ULL, 0x002fc400078e00ffULL,
0x000000ffff287224ULL, 0x000fe400078e00ffULL, 0x000000ffff337224ULL, 0x000fc400078e00ffULL,
0x0000010028007824ULL, 0x000fca00078e00ffULL, 0x0000002d0000720cULL, 0x000fda0003f06070ULL,
0x000178f000000947ULL, 0x000fea0003800000ULL, 0x0000000000027805ULL, 0x000fc40000015200ULL,
0x0186bc00ff217984ULL, 0x000e640000000800ULL, 0x8000000021ff7812ULL, 0x002fe40007804842ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff267224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000207805ULL, 0x000fcc0000015200ULL, 0x0000002002257210ULL, 0x000fca0007f1e1ffULL,
0x0000000121217824ULL, 0x000fe200000e0e03ULL, 0x003d09002500780cULL, 0x000fc80003f06070ULL,
0x000000ff2100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402500780cULL, 0x000fc80003f06070ULL, 0x000000ff2100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011421ULL,
0x0000002500007211ULL, 0x000fca00078110ffULL, 0x000000ffff217224ULL, 0x000fca00000e0621ULL,
0x0000000200007819ULL, 0x000fc80000001221ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000126267810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0186bc00ff217984ULL, 0x000e640000000800ULL,
0x8000000021ff7812ULL, 0x002fe40007804842ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000128007810ULL, 0x040fe40007ffe0ffULL, 0x0000002028277811ULL, 0x000fe400078e40ffULL,
0x0000002b0000720cULL, 0x000fc60003f26070ULL, 0x000062002a257a24ULL, 0x000fd400078e0227ULL,
0x000003b000009947ULL, 0x000fea0003800000ULL, 0x000000272d007217ULL, 0x000fe40007800000ULL,
0x00000004ff027819ULL, 0x000fc6000001162fULL, 0x0000000100037824ULL, 0x000fe200078e0a27ULL,
0x0000000202217810ULL, 0x000fe20007ffe0ffULL, 0x000000012c007824ULL, 0x000fc600078e0202ULL,
0x000000032c037217ULL, 0x040fe20007800000ULL, 0x000000012c347824ULL, 0x000fe400078e0221ULL,
0x0000000100207824ULL, 0x140fe400078e022fULL, 0x0000001000377824ULL, 0x000fe400078e00ffULL,
0x0000000103037824ULL, 0x000fe400078e0a2cULL, 0x0000000134357824ULL, 0x040fe200078e022fULL,
0xfffffff037267812ULL, 0x000fe200078ee220ULL, 0x0000001034387824ULL, 0x000fe200078e00ffULL,
0x000000032100720cULL, 0x000fe20003f66070ULL, 0x000000102f207824ULL, 0x000fe200078e00ffULL,
0x0000000402217810ULL, 0x000fc40007ffe0ffULL, 0xfffffff038387812ULL, 0x000fe200078ee235ULL,
0x00000100ff357424ULL, 0x000fe200078e00ffULL, 0x000000030200720cULL, 0x080fe20003f86070ULL,
0x000000012c367824ULL, 0x000fe200078e0221ULL, 0x0000000602377810ULL, 0x000fe20007ffe0ffULL,
0x0000000100027824ULL, 0x100fe200078e0225ULL, 0x000000032100720cULL, 0x080fe20003f46070ULL,
0x0000000136007824ULL, 0x000fe200078e0225ULL, 0x000000033700720cULL, 0x000fe20003f06070ULL,
0x00005e0002027625ULL, 0x000fe200078e0035ULL, 0x000000f020397812ULL, 0x000fc600078ec0ffULL,
0x0000000134207824ULL, 0x000fe400078e0225ULL, 0x000000012c3a7824ULL, 0x000fe400078e0237ULL,
0x0000000136377824ULL, 0x040fe400078e022fULL, 0x00000010363e7824ULL, 0x000fe200078e00ffULL,
0x0000003902367210ULL, 0x000fe20007fbe0ffULL, 0x00005e0020207625ULL, 0x000fc600078e0035ULL,
0xfffffff03e3b7812ULL, 0x000fe200078ee237ULL, 0x000000013a347824ULL, 0x000fe400078e0225ULL,
0x000000ffff377224ULL, 0x000fe200028e0603ULL, 0x0000003920207210ULL, 0x000fe20007fbe0ffULL,
0x00005e0000027625ULL, 0x000fe200078e0035ULL, 0x000160003b3b7811ULL, 0x000fc600078e20ffULL,
0x00005e0034347625ULL, 0x000fc800078e0035ULL, 0x000000013a007824ULL, 0x000fe200078e022fULL,
0x0000003934347210ULL, 0x080fe20007fde0ffULL, 0x000000103a257824ULL, 0x000fe400078e00ffULL,
0x000000ffff217224ULL, 0x000fe200028e0621ULL, 0x0000003902027210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff357224ULL, 0x000fe200030e0635ULL, 0xfffffff025007812ULL, 0x000fe400078ee200ULL,
0x0001600026257811ULL, 0x000fe200078e20ffULL, 0x000000ffff037224ULL, 0x000fe200028e0603ULL,
0x0001600038397811ULL, 0x000fc400078e20ffULL, 0x00016000003f7811ULL, 0x000fe200078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000036257faeULL, 0x0003e8000e101c46ULL,
0x0000000020397faeULL, 0x0003e8000d901c46ULL, 0x00000000023b7faeULL, 0x0003e8000d101c46ULL,
0x00000000343f7faeULL, 0x0003e2000c101c46ULL, 0x000002e000007947ULL, 0x000fea0003800000ULL,
0x0000002c2f007211ULL, 0x000fe200078fe0ffULL, 0x00000100ff377424ULL, 0x000fc600078e00ffULL,
0x0000000200207810ULL, 0x040fe20007ffe0ffULL, 0x0000000100027824ULL, 0x140fe200078e022fULL,
0x0000000400347810ULL, 0x040fe20007ffe0ffULL, 0x0000001000357824ULL, 0x000fe400078e00ffULL,
0x0000000120037824ULL, 0x040fe400078e022fULL, 0x0000001020387824ULL, 0x000fe200078e00ffULL,
0xfffffff035267812ULL, 0x000fe200078ee202ULL, 0x0000000100027824ULL, 0x040fe200078e0225ULL,
0x0000000600007810ULL, 0x000fe20007ffe0ffULL, 0x0000000134217824ULL, 0x000fe200078e022fULL,
0xfffffff038387812ULL, 0x000fe200078ee203ULL, 0x000000102f037824ULL, 0x000fc400078e00ffULL,
0x0000001034367824ULL, 0x000fe400078e00ffULL, 0x0000000120207824ULL, 0x000fe200078e0225ULL,
0x000000f003397812ULL, 0x000fe200078ec0ffULL, 0x00005e0002027625ULL, 0x000fe200078e0037ULL,
0xfffffff0363b7812ULL, 0x000fc600078ee221ULL, 0x0000000134347824ULL, 0x100fe200078e0225ULL,
0x0000003902027210ULL, 0x000fe20007f1e0ffULL, 0x0000000100367824ULL, 0x000fe200078e0225ULL,
0x000160003b3b7811ULL, 0x000fe200078e20ffULL, 0x00005e0020207625ULL, 0x000fc800078e0037ULL,
0x00005e0034347625ULL, 0x000fe200078e0037ULL, 0x0000003920207210ULL, 0x000fc60007f5e0ffULL,
0x0000000100257824ULL, 0x000fe400078e022fULL, 0x00005e0036367625ULL, 0x000fc800078e0037ULL,
0x0000001000007824ULL, 0x000fe200078e00ffULL, 0x0000003936367210ULL, 0x080fe20007f7e0ffULL,
0x000000ffff037224ULL, 0x000fe200000e0603ULL, 0x0000003934347210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff217224ULL, 0x000fe200010e0621ULL, 0xfffffff0003f7812ULL, 0x000fe200078ee225ULL,
0x000000ffff377224ULL, 0x000fe200018e0637ULL, 0x0001600026257811ULL, 0x000fe200078e20ffULL,
0x000000ffff357224ULL, 0x000fe200000e0635ULL, 0x0001600038397811ULL, 0x000fe400078e20ffULL,
0x000160003f3f7811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002257faeULL, 0x0003e8000b901c46ULL, 0x0000000020397faeULL, 0x0003e8000b901c46ULL,
0x00000000343b7faeULL, 0x0003e8000b901c46ULL, 0x00000000363f7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0186b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0186b000ff4e7f8cULL, 0x000ea2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018608002c347f8cULL, 0x0022e4000c80043fULL, 0x0000000000027805ULL, 0x000fc40000015200ULL,
0x01860c002c217984ULL, 0x000f240000000800ULL, 0x8000000021ff7812ULL, 0x018fc40007804835ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff267224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000207805ULL, 0x000fcc0000015200ULL, 0x0000002002257210ULL, 0x000fca0007f1e1ffULL,
0x0000000121217824ULL, 0x000fe200000e0e03ULL, 0x003d09002500780cULL, 0x000fc80003f06070ULL,
0x000000ff2100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402500780cULL, 0x000fc80003f06070ULL, 0x000000ff2100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011421ULL,
0x0000002500007211ULL, 0x000fca00078110ffULL, 0x000000ffff217224ULL, 0x000fca00000e0621ULL,
0x0000000200007819ULL, 0x000fc80000001221ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000126267810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01860c002c217984ULL, 0x000ee40000000800ULL,
0x8000000021ff7812ULL, 0x008fe40007804835ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000102f267824ULL, 0x000fe200078e00ffULL, 0x00000001ff007819ULL, 0x000fc8000001162fULL,
0x0000000c00007812ULL, 0x000fe400078ec0ffULL, 0x0000007026257812ULL, 0x000fca00078ec0ffULL,
0x0000000125257824ULL, 0x000fca00078e0200ULL, 0x0180000025037984ULL, 0x000ee80000000800ULL,
0x0182000025007984ULL, 0x0002a20000000800ULL, 0x0000003c0300720bULL, 0x008fe20003f1d000ULL,
0x0001e9527f007947ULL, 0x000fd8000b800000ULL, 0x0000000000027806ULL, 0x002fc800000e0100ULL,
0x0000ffff02217812ULL, 0x000fe2000780c0ffULL, 0x0000045000007945ULL, 0x000fe20003800000ULL,
0x00000001ff347424ULL, 0x000fe400078e00ffULL, 0x000000ffff4c7224ULL, 0x000fd200078e003cULL,
0x0000041000008947ULL, 0x000fea0003800000ULL, 0x000000ff2e00720cULL, 0x000fe40003f05270ULL,
0x0000003c0300720bULL, 0x000fe20003f54000ULL, 0x0001e9227f007947ULL, 0x000fd8000b800000ULL,
0x0000000000027806ULL, 0x000fc400010e0100ULL, 0x000000033c4c7209ULL, 0x000fe20007810000ULL,
0x0000035000017945ULL, 0x000fe20003800000ULL, 0x0000991002207816ULL, 0x000fc600000000ffULL,
0x0184004c25008388ULL, 0x0003e20000000800ULL, 0x000000ff2000720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x8000004c3c207221ULL, 0x002fe20000010000ULL,
0x000000ff02ff7812ULL, 0x000fe2000780c0ffULL, 0x0000017000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b20207820ULL, 0x000fc80000410000ULL, 0x0000002000357308ULL, 0x0002ec0000000800ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff207819ULL, 0x002fe2000001162fULL,
0x0001e8927f007947ULL, 0x000fea000b800000ULL, 0x00001f2035207589ULL, 0x0082e400000e0000ULL,
0x000000201c1c7220ULL, 0x088fe40000410000ULL, 0x000000201d1d7220ULL, 0x080fe40000410000ULL,
0x0000002018187220ULL, 0x000fc40000410000ULL, 0x0000002019197220ULL, 0x080fe40000410000ULL,
0x0000002014147220ULL, 0x080fe40000410000ULL, 0x0000002015157220ULL, 0x080fe40000410000ULL,
0x0000002010107220ULL, 0x080fe40000410000ULL, 0x0000002011117220ULL, 0x080fe40000410000ULL,
0x000000200c0c7220ULL, 0x000fc40000410000ULL, 0x000000200d0d7220ULL, 0x080fe40000410000ULL,
0x0000002008087220ULL, 0x080fe40000410000ULL, 0x0000002009097220ULL, 0x080fe40000410000ULL,
0x0000002004047220ULL, 0x080fe40000410000ULL, 0x0000002005057220ULL, 0x080fe40000410000ULL,
0x0000002030307220ULL, 0x000fc40000410000ULL, 0x0000002031317220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0002ff7812ULL, 0x000fe2000780c0ffULL,
0x0000003529297220ULL, 0x008fd80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000082f207811ULL, 0x002fe200078ff0ffULL, 0x0001e7a27f007947ULL, 0x000fea000b800000ULL,
0x00001f2035207589ULL, 0x0002e400000e0000ULL, 0x000000201e1e7220ULL, 0x088fe40000410000ULL,
0x000000201f1f7220ULL, 0x080fe40000410000ULL, 0x000000201a1a7220ULL, 0x080fe40000410000ULL,
0x000000201b1b7220ULL, 0x080fe40000410000ULL, 0x0000002016167220ULL, 0x080fe40000410000ULL,
0x0000002017177220ULL, 0x000fc40000410000ULL, 0x0000002012127220ULL, 0x080fe40000410000ULL,
0x0000002013137220ULL, 0x080fe40000410000ULL, 0x000000200e0e7220ULL, 0x080fe40000410000ULL,
0x000000200f0f7220ULL, 0x080fe40000410000ULL, 0x000000200a0a7220ULL, 0x080fe40000410000ULL,
0x000000200b0b7220ULL, 0x000fc40000410000ULL, 0x0000002006067220ULL, 0x080fe40000410000ULL,
0x0000002007077220ULL, 0x080fe40000410000ULL, 0x0000002032327220ULL, 0x080fe40000410000ULL,
0x0000002033337220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff21ff7812ULL, 0x000fda0007806002ULL, 0x8000004c03030221ULL, 0x000fe20000010000ULL,
0x00007610ff340816ULL, 0x000fc60000000034ULL, 0x3fb8aa3b03030820ULL, 0x000fc80000410000ULL,
0x0000000300240308ULL, 0x000e640000000800ULL, 0x0000002400000220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002900297221ULL, 0x004fc40000010000ULL,
0x0000000000027805ULL, 0x000fca0000015200ULL, 0x0186ac00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe4000780483dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff367224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000207805ULL, 0x000fcc0000015200ULL,
0x0000002002357210ULL, 0x000fca0007f1e1ffULL, 0x0000000121217824ULL, 0x000fe200000e0e03ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff2100720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff2100720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011421ULL, 0x0000003500007211ULL, 0x000fca00078110ffULL,
0x000000ffff217224ULL, 0x000fca00000e0621ULL, 0x0000000200007819ULL, 0x000fc80000001221ULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000136367810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0186ac00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe4000780483dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991034007816ULL, 0x000fe200000000ffULL,
0x0000019000007945ULL, 0x000fe60003800000ULL, 0x000000ff0000720cULL, 0x000fda0003f45270ULL,
0x0000016000002947ULL, 0x000fea0003800000ULL, 0x00000024ff00723eULL, 0x000fe400000010ffULL,
0x00000002ff037819ULL, 0x000fe4000001162fULL, 0x0000541000007816ULL, 0x000fe20000000000ULL,
0x0001e3d27f007947ULL, 0x000fea000b800000ULL, 0x00001f0300237589ULL, 0x0002a400000e0000ULL,
0x0000000803227810ULL, 0x000fe20007ffe0ffULL, 0x0001e4227f007947ULL, 0x000fea000b800000ULL,
0x00001f2200227589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001003597810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff587224ULL, 0x000fe200078e0000ULL,
0x0000246000407802ULL, 0x000fe20000000f00ULL, 0x0000001fff5a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff5b7424ULL, 0x000fc400078e00ffULL, 0x0001f51000007944ULL, 0x00cfea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001803597810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff587224ULL, 0x004fe200078e0000ULL, 0x000024d000407802ULL, 0x000fe20000000f00ULL,
0x0000001fff5a7424ULL, 0x000fc400078e00ffULL, 0xffffffffff5b7424ULL, 0x000fc400078e00ffULL,
0x0001f4a000007944ULL, 0x008fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000082f007812ULL, 0x00afe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000004ff217819ULL, 0x100fe4000001162fULL, 0x00000007004d7812ULL, 0x000fe400078ef82fULL,
0x000000022e007811ULL, 0x040fe200078e10ffULL, 0x000000042e527824ULL, 0x100fe200078e0221ULL,
0x000000104d377812ULL, 0x040fe200078efcffULL, 0x000000104d037824ULL, 0x040fe400078e00ffULL,
0x000000014d027824ULL, 0x000fe200078e0252ULL, 0x0000000037537210ULL, 0x000fe20007ffe021ULL,
0x0000000121507824ULL, 0x000fc400078e0200ULL, 0x0000000152557824ULL, 0x000fe200078e0237ULL,
0xfffffff003027812ULL, 0x000fe200078ee202ULL, 0x0000001037007824ULL, 0x000fc600078e00ffULL,
0x0001400002207811ULL, 0x000fe200078e20ffULL, 0x000000014d027824ULL, 0x000fe200078e0250ULL,
0xfffffff000537812ULL, 0x000fc600078ee253ULL, 0x000000002040783bULL, 0x000e620000004200ULL,
0xfffffff003027812ULL, 0x000fe400078ee202ULL, 0x0001400053007811ULL, 0x000fe400078e20ffULL,
0x0001400002037811ULL, 0x000fc600078e20ffULL, 0x000000000038783bULL, 0x000ee80000004200ULL,
0x00000000033c783bULL, 0x000f220000004200ULL, 0x00000018ff477819ULL, 0x002fe20000011443ULL,
0x0000004000c77306ULL, 0x000fe20000009400ULL, 0x00000018ff027819ULL, 0x000fe20000011440ULL,
0x0000010041587824ULL, 0x004fe200078e00ffULL, 0x00000018ff347819ULL, 0x000fe40000011441ULL,
0x00000018ff357819ULL, 0x000fc40000011442ULL, 0x00000018ff587819ULL, 0x000fe20000011458ULL,
0x0000004700c47306ULL, 0x000fe20000209400ULL, 0x00000018ff6a7819ULL, 0x008fe40000011439ULL,
0x00000018ff4b7819ULL, 0x010fe4000001143dULL, 0x00000018ff567819ULL, 0x000fe4000001143fULL,
0x00000018ff4a7819ULL, 0x000fe2000001143cULL, 0x0000004700bf7306ULL, 0x000fe20000205400ULL,
0x00000018ff6f7819ULL, 0x000fc4000001143aULL, 0x00000018ff707819ULL, 0x000fca000001143bULL,
0x0000004700837306ULL, 0x0003f0000020d400ULL, 0x0000000200847306ULL, 0x000fe20000209400ULL,
0x00000018ff477819ULL, 0x002fce000001143eULL, 0x0000000200c17306ULL, 0x000e700000205400ULL,
0x0000000200947306ULL, 0x0004f0000020d400ULL, 0x0000004700a07306ULL, 0x000fe20000209400ULL,
0x0000001037027824ULL, 0x004fe200078e00ffULL, 0x000000c18400720bULL, 0x002fc80003fbd000ULL,
0xfffffff002557812ULL, 0x000fe400078ee255ULL, 0x0000004700a37306ULL, 0x000fe40000205400ULL,
0x0001400055027811ULL, 0x000fca00078e20ffULL, 0x0000000194945812ULL, 0x008fe200078efcffULL,
0x0000004700497306ULL, 0x0003f0000020d400ULL, 0x0000003400c37306ULL, 0x000fe20000209400ULL,
0x0000010040477824ULL, 0x002fca00078e00ffULL, 0x00000018ff477819ULL, 0x000fe40000011447ULL,
0x0000003400c67306ULL, 0x000ff00000205400ULL, 0x0000004700ca7306ULL, 0x000ff00000209400ULL,
0x0000004700c97306ULL, 0x000e700000205400ULL, 0x0000003400937306ULL, 0x000ff0000020d400ULL,
0x0000003500bd7306ULL, 0x000fe20000209400ULL, 0x000000c9ca00720bULL, 0x002fce0003f1d000ULL,
0x0000003500c07306ULL, 0x000ff00000205400ULL, 0x0000003500857306ULL, 0x0003f0000020d400ULL,
0x0000004000c87306ULL, 0x000ea20000005400ULL, 0x000000000234783bULL, 0x002e6e0000004200ULL,
0x0000004000997306ULL, 0x0007f0000000d400ULL, 0x0000004700a67306ULL, 0x000922000020d400ULL,
0x0001000040407824ULL, 0x008fe200078e00ffULL, 0x000000c8c700720bULL, 0x004fc80003fdd000ULL,
0x00000018ff407819ULL, 0x000fe40000011440ULL, 0x0000004100987306ULL, 0x000fe20000009400ULL,
0x0000010042477824ULL, 0x010fca00078e00ffULL, 0x00000018ff477819ULL, 0x000fe40000011447ULL,
0x0000004100c57306ULL, 0x000ea20000005400ULL, 0x00000001a6a60812ULL, 0x000fe400078efcffULL,
0x0000000199996812ULL, 0x000fca00078efcffULL, 0x0000004000cc7306ULL, 0x000ff00000209400ULL,
0x0000004000cb7306ULL, 0x000ee20000205400ULL, 0x000000c59800720bULL, 0x004fce0003f1d000ULL,
0x0000004000977306ULL, 0x0005f0000020d400ULL, 0x0000004100957306ULL, 0x000862000000d400ULL,
0x0000010043407824ULL, 0x004fe200078e00ffULL, 0x000000cbcc00720bULL, 0x008fc80003f7d000ULL,
0x00000018ff407819ULL, 0x000fe40000011440ULL, 0x0000004700d17306ULL, 0x000fe20000209400ULL,
0x0001000041417824ULL, 0x010fca00078e00ffULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x0000004700d27306ULL, 0x000ea20000205400ULL, 0x0000000195950812ULL, 0x002fe400078efcffULL,
0x0000000197973812ULL, 0x000fe400078efcffULL, 0x000000c6c300720bULL, 0x000fc60003f7d000ULL,
0x00000047008f7306ULL, 0x0002f0000020d400ULL, 0x0000004300897306ULL, 0x000fe20000009400ULL,
0x000001003c477824ULL, 0x002fe200078e00ffULL, 0x000000d2d100720bULL, 0x004fc40003fbd000ULL,
0x0000000193933812ULL, 0x000fc800078efcffULL, 0x0000004300b07306ULL, 0x000fee0000005400ULL,
0x000000018f8f5812ULL, 0x008fe200078efcffULL, 0x00000043008b7306ULL, 0x0003e2000000d400ULL,
0x000000c0bd00720bULL, 0x000fce0003fbd000ULL, 0x0000004200c27306ULL, 0x000fe20000009400ULL,
0x0001000043437824ULL, 0x002fca00078e00ffULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0x0000004200a77306ULL, 0x000fe20000005400ULL, 0x0000000185855812ULL, 0x000fce00078efcffULL,
0x00000042008c7306ULL, 0x0003f0000000d400ULL, 0x0000005800cd7306ULL, 0x000fe20000209400ULL,
0x0001000042427824ULL, 0x002fce00078e00ffULL, 0x0000005800ce7306ULL, 0x000e700000205400ULL,
0x0000005800a47306ULL, 0x0004f0000020d400ULL, 0x0000003d00a87306ULL, 0x000fe20000009400ULL,
0x00000018ff587819ULL, 0x004fe20000011447ULL, 0x000001003d477824ULL, 0x000fe200078e00ffULL,
0x000000cecd00720bULL, 0x002fc80003f9d000ULL, 0x00000018ff5a7819ULL, 0x000fe20000011447ULL,
0x0000003d00b77306ULL, 0x000ff00000005400ULL, 0x0000003d00467306ULL, 0x0003e2000000d400ULL,
0x00000001a4a44812ULL, 0x008fc400078efcffULL, 0x000000a7c200720bULL, 0x000fca0003f9d000ULL,
0x0000004000d37306ULL, 0x000fe20000209400ULL, 0x000100003d3d7824ULL, 0x002fce00078e00ffULL,
0x0000004000d47306ULL, 0x000e620000205400ULL, 0x000000018c8c4812ULL, 0x000fce00078efcffULL,
0x0000004100cf7306ULL, 0x000ff00000209400ULL, 0x0000004100d07306ULL, 0x000ea20000205400ULL,
0x000000d4d300720bULL, 0x002fce0003f1d000ULL, 0x0000004100967306ULL, 0x0002f0000020d400ULL,
0x0000004300d77306ULL, 0x000fe20000209400ULL, 0x00000018ff417819ULL, 0x002fe40000011442ULL,
0x000000d0cf00720bULL, 0x004fca0003fdd000ULL, 0x0000004300d87306ULL, 0x000e700000205400ULL,
0x0000004300427306ULL, 0x000522000020d400ULL, 0x0000000196966812ULL, 0x008fe400078efcffULL,
0x000000b08900720bULL, 0x000fca0003fdd000ULL, 0x0000003e00517306ULL, 0x000fe20000009400ULL,
0x00000018ff437819ULL, 0x004fe2000001143dULL, 0x000001003e3d7824ULL, 0x000fe200078e00ffULL,
0x000000d8d700720bULL, 0x002fca0003f9d000ULL, 0x0000003e00547306ULL, 0x000fe20000005400ULL,
0x000000018b8b6812ULL, 0x000fce00078efcffULL, 0x0000003e007a7306ULL, 0x0003e2000000d400ULL,
0x0000000142424812ULL, 0x010fe400078efcffULL, 0x000000b7a800720bULL, 0x000fca0003f9d000ULL,
0x0000004000907306ULL, 0x000ea2000020d400ULL, 0x000100003e3e7824ULL, 0x002fca00078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x0000005800d97306ULL, 0x000fe20000209400ULL,
0x0000000146464812ULL, 0x000fce00078efcffULL, 0x0000003e00dc7306ULL, 0x000fe20000209400ULL,
0x0000000190900812ULL, 0x004fe400078efcffULL, 0x000000bfc400720bULL, 0x000fca0003f1d000ULL,
0x0000003e00db7306ULL, 0x000ff00000205400ULL, 0x0000003e007e7306ULL, 0x0003e2000020d400ULL,
0x0000000183830812ULL, 0x000fe400078efcffULL, 0x000000545100720bULL, 0x000fc40003f1d000ULL,
0x000000072f547812ULL, 0x000fc600078ec0ffULL, 0x0000005800da7306ULL, 0x000ea20000205400ULL,
0x00000018ff3e7819ULL, 0x002fe40000011436ULL, 0x0000000854547812ULL, 0x000fca00078ef82fULL,
0x0000005800407306ULL, 0x0002e2000020d400ULL, 0x0000000121517824ULL, 0x000fe200078e0254ULL,
0x000000017a7a0812ULL, 0x000fcc00078efcffULL, 0x0000004100d57306ULL, 0x000fe20000209400ULL,
0x00000018ff587819ULL, 0x002fe2000001143dULL, 0x000001003f3d7824ULL, 0x000fe200078e00ffULL,
0x000000dad900720bULL, 0x004fca0003fdd000ULL, 0x0000004100d67306ULL, 0x000e700000205400ULL,
0x0000003f00b37306ULL, 0x000fe20000009400ULL, 0x0000000140406812ULL, 0x008fce00078efcffULL,
0x0000003f00ae7306ULL, 0x000fe20000005400ULL, 0x000000d6d500720bULL, 0x002fce0003f7d000ULL,
0x0000003f00487306ULL, 0x0003f0000000d400ULL, 0x0000004300e87306ULL, 0x000fe20000209400ULL,
0x000100003f3f7824ULL, 0x002fca00078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x0000004300e77306ULL, 0x000ff00000205400ULL, 0x0000004300807306ULL, 0x0003f0000020d400ULL,
0x0000003e00817306ULL, 0x000fe20000209400ULL, 0x00000018ff437819ULL, 0x002fce0000011434ULL,
0x0000003e00867306ULL, 0x000ff00000205400ULL, 0x0000003e00697306ULL, 0x0003f0000020d400ULL,
0x00000034009c7306ULL, 0x000fe20000009400ULL, 0x00000100343e7824ULL, 0x002fca00078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x00000034009f7306ULL, 0x000ff00000005400ULL,
0x0000003400677306ULL, 0x0003f0000000d400ULL, 0x0000005a00de7306ULL, 0x000fe20000209400ULL,
0x0001000034347824ULL, 0x002fca00078e00ffULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000005a00dd7306ULL, 0x000e700000205400ULL, 0x0000003f00df7306ULL, 0x000ff00000209400ULL,
0x0000003f00e07306ULL, 0x000fe20000205400ULL, 0x000000ddde00720bULL, 0x002fce0003fbd000ULL,
0x0000003f007c7306ULL, 0x0003f0000020d400ULL, 0x0000003400b17306ULL, 0x000fe20000209400ULL,
0x00000018ff3f7819ULL, 0x002fce0000011437ULL, 0x0000003400b87306ULL, 0x000ff00000205400ULL,
0x0000003400787306ULL, 0x0003f0000020d400ULL, 0x0000003c00b97306ULL, 0x000fe20000009400ULL,
0x0000010037347824ULL, 0x002fca00078e00ffULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000003c00bc7306ULL, 0x000ff00000005400ULL, 0x0000003c00457306ULL, 0x0003f0000000d400ULL,
0x00000041008a7306ULL, 0x000ea2000020d400ULL, 0x000100003c3c7824ULL, 0x002fca00078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000005800e47306ULL, 0x000ff00000209400ULL,
0x0000005800e57306ULL, 0x000fe20000205400ULL, 0x000000018a8a3812ULL, 0x004fc400078efcffULL,
0x000000bcb900720bULL, 0x000fe40003f7d000ULL, 0x0000008a858a723eULL, 0x000fc600000010ffULL,
0x00000058007d7306ULL, 0x0003f0000020d400ULL, 0x0000003f007f7306ULL, 0x000fe20000209400ULL,
0x00000018ff587819ULL, 0x002fe40000011435ULL, 0x0000000145453812ULL, 0x000fca00078efcffULL,
0x0000003f00827306ULL, 0x000ff00000205400ULL, 0x0000003f00627306ULL, 0x0003f0000020d400ULL,
0x00000035009b7306ULL, 0x000fe20000009400ULL, 0x00000100353f7824ULL, 0x002fca00078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x00000035009a7306ULL, 0x000ff00000005400ULL,
0x0000003500687306ULL, 0x0003f0000000d400ULL, 0x0000005a00417306ULL, 0x0004e2000020d400ULL,
0x0001000035357824ULL, 0x002fca00078e00ffULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x0000006a006d7306ULL, 0x000fe20000209400ULL, 0x00000018ff5a7819ULL, 0x004fce000001143dULL,
0x0000006a006e7306ULL, 0x000fe20000205400ULL, 0x0000000141415812ULL, 0x008fe400078efcffULL,
0x000000e7e800720bULL, 0x000fca0003fbd000ULL, 0x0000006a005c7306ULL, 0x000ff0000020d400ULL,
0x0000003e00e17306ULL, 0x000fe20000209400ULL, 0x0000000180805812ULL, 0x000fce00078efcffULL,
0x0000003e00e27306ULL, 0x000ff00000205400ULL, 0x0000003e00767306ULL, 0x0003f0000020d400ULL,
0x0000003400917306ULL, 0x000fe20000209400ULL, 0x00000100363e7824ULL, 0x002fca00078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x0000003400927306ULL, 0x000ff00000205400ULL,
0x00000034006a7306ULL, 0x0003f0000020d400ULL, 0x0000003600a27306ULL, 0x000fe20000009400ULL,
0x0000010038347824ULL, 0x002fce00078e00ffULL, 0x00000036009d7306ULL, 0x000ff00000005400ULL,
0x0000003600617306ULL, 0x0003f0000000d400ULL, 0x0000003c00e67306ULL, 0x000fe20000209400ULL,
0x0001000036367824ULL, 0x002fca00078e00ffULL, 0x00000018ff367819ULL, 0x000fe40000011436ULL,
0x0000003c00e37306ULL, 0x000e700000205400ULL, 0x0000003c00477306ULL, 0x000eb0000020d400ULL,
0x0000005a003d7306ULL, 0x000fe20000209400ULL, 0x000000e3e600720bULL, 0x002fce0003f7d000ULL,
0x0000005a003c7306ULL, 0x000e6c0000205400ULL, 0x0000000147473812ULL, 0x004fe400078efcffULL,
0x0000005a007b7306ULL, 0x000ea2000020d400ULL, 0x000000aeb300720bULL, 0x000fce0003f7d000ULL,
0x0000004300b47306ULL, 0x000fe20000209400ULL, 0x0000003c3d00720bULL, 0x002fca0003fbd000ULL,
0x0000000148483812ULL, 0x000fe400078efcffULL, 0x0000004300ab7306ULL, 0x000fe20000205400ULL,
0x0000009f9c00720bULL, 0x000fe20003f7d000ULL, 0x000100003b9c7824ULL, 0x000fc800078e00ffULL,
0x000000017b7b5812ULL, 0x004fe400078efcffULL, 0x0000004300737306ULL, 0x0003e2000020d400ULL,
0x000000e0df00720bULL, 0x000fe40003fbd000ULL, 0x000000487b7b723eULL, 0x000fe400000010ffULL,
0x00000018ff9c7819ULL, 0x000fe4000001149cULL, 0x0000000167673812ULL, 0x000fe200078efcffULL,
0x0000006f00637306ULL, 0x000fe20000209400ULL, 0x00000018ff437819ULL, 0x002fca0000011438ULL,
0x000000017c7c5812ULL, 0x000fe400078efcffULL, 0x0000006f00647306ULL, 0x000fe20000205400ULL,
0x0000009da200720bULL, 0x000fce0003fbd000ULL, 0x0000006f005a7306ULL, 0x000fec000020d400ULL,
0x0000000161615812ULL, 0x000fe400078efcffULL, 0x0000003500ad7306ULL, 0x000fe20000209400ULL,
0x000000868100720bULL, 0x000fce0003fbd000ULL, 0x0000003500b27306ULL, 0x000fec0000205400ULL,
0x0000000169695812ULL, 0x000fe400078efcffULL, 0x00000035006f7306ULL, 0x0003f0000020d400ULL,
0x0000004a00bb7306ULL, 0x000fe20000209400ULL, 0x00000018ff357819ULL, 0x002fe20000011434ULL,
0x0000010039347824ULL, 0x000fcc00078e00ffULL, 0x0000004a00be7306ULL, 0x000e700000205400ULL,
0x0000004300747306ULL, 0x000ff00000209400ULL, 0x0000004300757306ULL, 0x000fe20000205400ULL,
0x000000bebb00720bULL, 0x002fe20003fdd000ULL, 0x0000000854be7824ULL, 0x000fcc00078e00ffULL,
0x0000004300607306ULL, 0x000ff0000020d400ULL, 0x0000003600437306ULL, 0x000ff00000209400ULL,
0x0000003600987306ULL, 0x000ff00000205400ULL, 0x0000003600847306ULL, 0x0003f0000020d400ULL,
0x0000004a00447306ULL, 0x000ea2000020d400ULL, 0x00000018ff367819ULL, 0x002fe20000011434ULL,
0x0000000854347824ULL, 0x000fca00078e00ffULL, 0xfffffff834347812ULL, 0x000fe200078ee251ULL,
0x0000005800ac7306ULL, 0x000ff00000209400ULL, 0x0000005800a97306ULL, 0x000fe20000205400ULL,
0x0000000144446812ULL, 0x004fc400078efcffULL, 0x000000e5e400720bULL, 0x000fca0003fdd000ULL,
0x00000058006c7306ULL, 0x000ff0000020d400ULL, 0x0000007000657306ULL, 0x000fe20000209400ULL,
0x000000017d7d6812ULL, 0x000fe400078efcffULL, 0x000000a3a000720bULL, 0x000fe20003fdd000ULL,
0x000001003ba37824ULL, 0x000fe200078e00ffULL, 0x0000007a7d7a723eULL, 0x000fc600000010ffULL,
0x0000007000667306ULL, 0x000fe20000205400ULL, 0x00000018ffa37819ULL, 0x000fce00000114a3ULL,
0x0000007000587306ULL, 0x000fe2000020d400ULL, 0x0000000149496812ULL, 0x000fe400078efcffULL,
0x0000009a9b00720bULL, 0x000fca0003fdd000ULL, 0x0000003e00a57306ULL, 0x000ff00000209400ULL,
0x0000003e00aa7306ULL, 0x000e620000205400ULL, 0x0000000168686812ULL, 0x000fce00078efcffULL,
0x0000003e00707306ULL, 0x0004f0000020d400ULL, 0x0000003f00b67306ULL, 0x000fe20000209400ULL,
0x00012000343e7811ULL, 0x004fe400078e20ffULL, 0x000000aaa500720bULL, 0x002fca0003fdd000ULL,
0x0000003f00af7306ULL, 0x000e700000205400ULL, 0x0000003f00777306ULL, 0x000522000020d400ULL,
0x0000000170706812ULL, 0x008fe400078efcffULL, 0x000000984300720bULL, 0x000fca0003fdd000ULL,
0x0000004b00b57306ULL, 0x000fe20000209400ULL, 0x000000003e3c783bULL, 0x004ea20000000200ULL,
0x000000afb600720bULL, 0x002fcc0003f7d000ULL, 0x0000004b00ba7306ULL, 0x000e620000205400ULL,
0x0000000184846812ULL, 0x000fcc00078efcffULL, 0x0000000177773812ULL, 0x010fe200078efcffULL,
0x0000004b00797306ULL, 0x000ee6000020d400ULL, 0x000000687777723eULL, 0x000fca00000010ffULL,
0x00000056009e7306ULL, 0x000fe20000209400ULL, 0x000000bab500720bULL, 0x002fce0003f9d000ULL,
0x0000005600a17306ULL, 0x000e6c0000205400ULL, 0x0000000179794812ULL, 0x008fe400078efcffULL,
0x0000003800887306ULL, 0x000fe20000009400ULL, 0x000000dbdc00720bULL, 0x000fe20003f9d000ULL,
0x000000233c3ca231ULL, 0x004fc400003400ffULL, 0x000000233e3ea231ULL, 0x000fe400003400ffULL,
0x000000223d3da231ULL, 0x080fe400003400ffULL, 0x0000003800877306ULL, 0x000fe20000005400ULL,
0x000000a19e00720bULL, 0x002fe20003f1d000ULL, 0x000001003a9e7824ULL, 0x040fe200078e00ffULL,
0x000000223f3fa231ULL, 0x000fe200003400ffULL, 0x000100003aa17824ULL, 0x000fe400078e00ffULL,
0x000000017e7e4812ULL, 0x000fc400078efcffULL, 0x00000038005b7306ULL, 0x0003e2000000d400ULL,
0x000000e2e100720bULL, 0x000fe40003f9d000ULL, 0x00000018ff9e7819ULL, 0x000fe4000001149eULL,
0x0000007e497e723eULL, 0x000fe400000010ffULL, 0x00000018ffa17819ULL, 0x000fe200000114a1ULL,
0x00000056006b7306ULL, 0x000ea2000020d400ULL, 0x0001000038387824ULL, 0x002fca00078e00ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x00000039004a7306ULL, 0x000fe20000009400ULL,
0x0000000176764812ULL, 0x000fe400078efcffULL, 0x000000abb400720bULL, 0x000fe40003f9d000ULL,
0x000000677676723eULL, 0x000fc600000010ffULL, 0x00000039004b7306ULL, 0x000e620000005400ULL,
0x000000016b6b0812ULL, 0x004fe400078efcffULL, 0x000000b8b100720bULL, 0x000fca0003f1d000ULL,
0x0000003900597306ULL, 0x0004e2000000d400ULL, 0x0000000173734812ULL, 0x000fe400078efcffULL,
0x000000b2ad00720bULL, 0x000fca0003f9d000ULL, 0x00000037008e7306ULL, 0x000fe20000009400ULL,
0x0001000039397824ULL, 0x004fe200078e00ffULL, 0x0000000178780812ULL, 0x000fe400078efcffULL,
0x000000a9ac00720bULL, 0x000fe40003f1d000ULL, 0x0000004b4a00720bULL, 0x002fe40003fbd000ULL,
0x00000037008d7306ULL, 0x000e620000005400ULL, 0x000000016f6f4812ULL, 0x000fe200078efcffULL,
0x0000007a3c48723cULL, 0x000be20000041804ULL, 0x000000878800720bULL, 0x000fca0003f9d000ULL,
0x00000037005d7306ULL, 0x000522000000d400ULL, 0x000000016c6c0812ULL, 0x000fe400078efcffULL,
0x000000929100720bULL, 0x000fe40003f1d000ULL, 0x0000000159595812ULL, 0x008fe400078efcffULL,
0x0000006e6d00720bULL, 0x000fe20003fbd000ULL, 0x0000003a00717306ULL, 0x000fe20000009400ULL,
0x0001000037377824ULL, 0x004fe200078e00ffULL, 0x0000008d8e00720bULL, 0x002fc40003f7d000ULL,
0x000000015b5b4812ULL, 0x000fe400078efcffULL, 0x00000018ff377819ULL, 0x000fe40000011437ULL,
0x0000003a00727306ULL, 0x000fe20000005400ULL, 0x000000016a6a0812ULL, 0x000fe400078efcffULL,
0x000000757400720bULL, 0x000fe40003f9d000ULL, 0x000000617004723eULL, 0x020fe400000010ffULL,
0x000000015d5d3812ULL, 0x010fe200078efcffULL, 0x0000003a00577306ULL, 0x0003e2000000d400ULL,
0x000000827f00720bULL, 0x000fc40003f7d000ULL, 0x0000007c6b7f723eULL, 0x000fe400000010ffULL,
0x0000005d6a05723eULL, 0x000fe400000010ffULL, 0x000000015c5c5812ULL, 0x000fe200078efcffULL,
0x0000003800a07306ULL, 0x000fe20000209400ULL, 0x00000018ff3a7819ULL, 0x002fe20000011439ULL,
0x0000007e3c30723cULL, 0x000fe20000041830ULL, 0x00000095a439723eULL, 0x000fe400000010ffULL,
0x0000000160604812ULL, 0x000fc400078efcffULL, 0x0000000162623812ULL, 0x000fe200078efcffULL,
0x00000038009f7306ULL, 0x000fe20000205400ULL, 0x000000646300720bULL, 0x000fce0003fbd000ULL,
0x00000038009b7306ULL, 0x0003ec000020d400ULL, 0x000000015a5a5812ULL, 0x000fe400078efcffULL,
0x0000003500b97306ULL, 0x000fe20000209400ULL, 0x00000099a638723eULL, 0x002fce00000010ffULL,
0x0000003500bc7306ULL, 0x000e620000205400ULL, 0x000000383c1c723cULL, 0x000bee000004181cULL,
0x0000003500a87306ULL, 0x0004e2000020d400ULL, 0x0000008c8f38723eULL, 0x020fe400000010ffULL,
0x0000008b9039723eULL, 0x000fc400000010ffULL, 0x00000042838b723eULL, 0x000fc600000010ffULL,
0x0000003700a77306ULL, 0x000fe20000209400ULL, 0x0000000251357810ULL, 0x004fe20007ffe0ffULL,
0x000000383c14723cULL, 0x000b620000041814ULL, 0x000000bcb900720bULL, 0x002fe40003fdd000ULL,
0xfffffff8be357812ULL, 0x000fc600078ee235ULL, 0x0000003700b07306ULL, 0x000e700000205400ULL,
0x0000003700897306ULL, 0x000522000020d400ULL, 0x00000001a8a86812ULL, 0x008fe400078efcffULL,
0x0000009fa000720bULL, 0x000fca0003fdd000ULL, 0x0000003a009a7306ULL, 0x000fe20000209400ULL,
0x000000969337723eULL, 0x004fe400000010ffULL, 0x000000b0a700720bULL, 0x002fca0003f1d000ULL,
0x0000003a00957306ULL, 0x000fe20000205400ULL, 0x000000019b9b6812ULL, 0x000fc800078efcffULL,
0x0000009b6060723eULL, 0x000fc600000010ffULL, 0x0000003a00937306ULL, 0x0003e2000020d400ULL,
0x0000000189890812ULL, 0x010fe400078efcffULL, 0x000000727100720bULL, 0x000fca0003f1d000ULL,
0x0000003b005e7306ULL, 0x000fe20000009400ULL, 0x00012000353a7811ULL, 0x002fce00078e20ffULL,
0x0000003b005f7306ULL, 0x000e620000005400ULL, 0x0000000157570812ULL, 0x000fce00078efcffULL,
0x0000003b00567306ULL, 0x0004f0000000d400ULL, 0x0000003600b77306ULL, 0x000fe20000209400ULL,
0x000000003a38783bULL, 0x024ea20000000200ULL, 0x0000005f5e00720bULL, 0x002fcc0003f9d000ULL,
0x0000003600ba7306ULL, 0x000e6e0000205400ULL, 0x0000000156564812ULL, 0x008fe200078efcffULL,
0x0000003600ae7306ULL, 0x000722000020d400ULL, 0x000000bab700720bULL, 0x002fce0003f7d000ULL,
0x0000009e008c7306ULL, 0x000fe20000209400ULL, 0x000000979436723eULL, 0x008fce00000010ffULL,
0x000000363c18723cULL, 0x000b620000041818ULL, 0x0000009e00837306ULL, 0x000e620000205400ULL,
0x00000001aeae3812ULL, 0x010fe400078efcffULL, 0x000000959a00720bULL, 0x000fc60003f7d000ULL,
0x000000454036723eULL, 0x020fe200000010ffULL, 0x000000233838a231ULL, 0x084fe200003400ffULL,
0x000000464137723eULL, 0x000fe200000010ffULL, 0x000000233a3aa231ULL, 0x000fe200003400ffULL,
0x0000008a3c40723cULL, 0x000be20000041810ULL, 0x000000223939a231ULL, 0x080fe200003400ffULL,
0x0000009e00887306ULL, 0x000ea2000020d400ULL, 0x000000223b3ba231ULL, 0x000fe200003400ffULL,
0x000000838c00720bULL, 0x002fc60003fdd000ULL, 0x000000474410723eULL, 0x020fe400000010ffULL,
0x000000807911723eULL, 0x000fe200000010ffULL, 0x000000363c44723cULL, 0x000b62000004180cULL,
0x000000a3006b7306ULL, 0x000fe2000020d400ULL, 0x0000000193933812ULL, 0x000fc800078efcffULL,
0x000000935c61723eULL, 0x000fe400000010ffULL, 0x000000103c08723cULL, 0x000b640000041808ULL,
0x000000a3000c7306ULL, 0x020fe20000209400ULL, 0x0000000188886812ULL, 0x004fe400078efcffULL,
0x000000666500720bULL, 0x000fe40003fdd000ULL, 0x000000787310723eULL, 0x000fe200000010ffULL,
0x000000043804723cULL, 0x000b640000041814ULL, 0x000000a3000d7306ULL, 0x000e620000205400ULL,
0x0000006f6c11723eULL, 0x000fc800000010ffULL, 0x0000005ba814723eULL, 0x020fe200000010ffULL,
0x00000076381c723cULL, 0x000f64000004181cULL, 0x000000a100367306ULL, 0x000fe20000209400ULL,
0x0000000158586812ULL, 0x000fe400078efcffULL, 0x00000059ae15723eULL, 0x000fc600000010ffULL,
0x000000103810723cULL, 0x040b640000041818ULL, 0x000000a100377306ULL, 0x000ea20000205400ULL,
0x0000000d0c00720bULL, 0x002fe40003f7d000ULL, 0x00000084690c723eULL, 0x000fe400000010ffULL,
0x00000089620d723eULL, 0x000fe400000010ffULL, 0x000000578818723eULL, 0x020fe200000010ffULL,
0x0000009c003c7306ULL, 0x000fe20000209400ULL, 0x000000143814723cULL, 0x000b6a0000041844ULL,
0x000000016b6b3812ULL, 0x000fc400078efcffULL, 0x0000009c00197306ULL, 0x000e620000205400ULL,
0x000000373600720bULL, 0x004fe20003f1d000ULL, 0x0000000c380c723cULL, 0x040b6c0000041840ULL,
0x000000a100a17306ULL, 0x000ea4000020d400ULL, 0x000000603808723cULL, 0x000b6c0000041808ULL,
0x0000009c005b7306ULL, 0x000ee2000020d400ULL, 0x000000193c00720bULL, 0x002fc40003f7d000ULL,
0x000000566b19723eULL, 0x000fe400000010ffULL, 0x00000001a1a10812ULL, 0x004fca00078efcffULL,
0x000000183818723cULL, 0x000b620000041848ULL, 0x000000a15a5a723eULL, 0x000fc600000010ffULL,
0x000000015b5b3812ULL, 0x008fc800078efcffULL, 0x0000005b585b723eULL, 0x000fce00000010ffULL,
0x0000005a3830723cULL, 0x000b620000041830ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0186b800ff3a7f8cULL, 0x020e62000c80043fULL, 0x000000ffff3c7224ULL, 0x000fce00078e00ffULL,
0x0000000000367805ULL, 0x000fc40000015200ULL, 0x0186bc00ff397984ULL, 0x000ea40000000800ULL,
0x8000000039ff7812ULL, 0x006fe4000780483bULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fcc0000015200ULL, 0x00000038363d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000139397824ULL, 0x000fe200000e0e37ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff387819ULL, 0x000fc80000011439ULL,
0x0000003d38387211ULL, 0x000fca00078110ffULL, 0x000000ffff397224ULL, 0x000fca00000e0639ULL,
0x0000000238387819ULL, 0x000fc80000001239ULL, 0x000000380000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0186bc00ff397984ULL, 0x000e640000000800ULL,
0x8000000039ff7812ULL, 0x002fe4000780483bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002027397810ULL, 0x000fca0007ffe0ffULL, 0x000062002a3b7a24ULL, 0x000fe200078e0239ULL,
0x0000039000009947ULL, 0x000fea0003800000ULL, 0x000000012c387824ULL, 0x000fe200078e0221ULL,
0x000000392d367217ULL, 0x000fe20007800000ULL, 0x00000100ff3f7424ULL, 0x000fe200078e00ffULL,
0x0000000421457810ULL, 0x040fe20007ffe0ffULL, 0x0000000138377824ULL, 0x040fe200078e022fULL,
0x0000000221437810ULL, 0x000fe20007ffe0ffULL, 0x0000001038407824ULL, 0x000fe200078e00ffULL,
0x000000f026417812ULL, 0x000fe200078ec0ffULL, 0x0000000136397824ULL, 0x000fe400078e0a39ULL,
0x000000012c3e7824ULL, 0x000fe200078e0245ULL, 0xfffffff040407812ULL, 0x000fe200078ee237ULL,
0x0000000138367824ULL, 0x000fe200078e023bULL, 0x000000392c397217ULL, 0x000fe20007800000ULL,
0x000000013e3c7824ULL, 0x000fc400078e022fULL, 0x000000103e477824ULL, 0x000fe400078e00ffULL,
0x000000012c3a7824ULL, 0x000fe400078e0243ULL, 0x00005e0036367625ULL, 0x000fe200078e003fULL,
0xfffffff047447812ULL, 0x000fe400078ee23cULL, 0x0000000621477810ULL, 0x000fe20007ffe0ffULL,
0x000000013a387824ULL, 0x000fe200078e022fULL, 0x00000041363c7210ULL, 0x000fe20007f1e0ffULL,
0x000000103a3d7824ULL, 0x000fc400078e00ffULL, 0x000000013a367824ULL, 0x000fe400078e023bULL,
0x000000012c467824ULL, 0x000fe200078e0247ULL, 0xfffffff03d427812ULL, 0x000fe200078ee238ULL,
0x000000013e387824ULL, 0x000fe400078e023bULL, 0x000000ffff3d7224ULL, 0x000fe400000e0637ULL,
0x00005e0036367625ULL, 0x000fc800078e003fULL, 0x00000001393e7824ULL, 0x000fe200078e0a2cULL,
0x0000004136367210ULL, 0x000fe20007fbe0ffULL, 0x00005e0038387625ULL, 0x000fc600078e003fULL,
0x0000003e4300720cULL, 0x080fe20003f66070ULL, 0x00000001463a7824ULL, 0x000fe200078e023bULL,
0x0000004138387210ULL, 0x000fe20007fde0ffULL, 0x0000000146437824ULL, 0x000fe200078e022fULL,
0x0000003e2100720cULL, 0x080fe20003f86070ULL, 0x00005e003a3a7625ULL, 0x000fe200078e003fULL,
0x0000003e4500720cULL, 0x080fe40003f06070ULL, 0x00014000403f7811ULL, 0x000fe200078e20ffULL,
0x000000ffff377224ULL, 0x000fe200028e0637ULL, 0x0000003e4700720cULL, 0x000fe20003fa6070ULL,
0x0000001046467824ULL, 0x000fc400078e00ffULL, 0x000000ffff397224ULL, 0x000fe200030e0639ULL,
0x000000413a3a7210ULL, 0x000fe40007fde0ffULL, 0xfffffff0463e7812ULL, 0x000fe200078ee243ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c3f7faeULL, 0x0003e2000e101c46ULL,
0x0001400042417811ULL, 0x000fe200078e20ffULL, 0x000000ffff3b7224ULL, 0x000fe200030e063bULL,
0x0001400044437811ULL, 0x000fe400078e20ffULL, 0x000140003e457811ULL, 0x000fe200078e20ffULL,
0x0000000036417faeULL, 0x0003e8000d901c46ULL, 0x0000000038437faeULL, 0x0003e8000c101c46ULL,
0x000000003a457faeULL, 0x0003e2000e901c46ULL, 0x000002d000007947ULL, 0x000fea0003800000ULL,
0x000000012c3a7824ULL, 0x000fe200078e0221ULL, 0x000000f026437812ULL, 0x000fe200078ec0ffULL,
0x00000100ff417424ULL, 0x000fc400078e00ffULL, 0x000000013a3c7824ULL, 0x040fe200078e022fULL,
0x000000023a367810ULL, 0x040fe20007ffe0ffULL, 0x000000103a3d7824ULL, 0x040fe200078e00ffULL,
0x000000043a387810ULL, 0x000fc60007ffe0ffULL, 0x0000000136377824ULL, 0x000fe200078e022fULL,
0xfffffff03d447812ULL, 0x000fe200078ee23cULL, 0x000000013a3c7824ULL, 0x040fe200078e023bULL,
0x000000063a3a7810ULL, 0x000fe20007ffe0ffULL, 0x00000010363e7824ULL, 0x000fe200078e00ffULL,
0x0001400044457811ULL, 0x000fe200078e20ffULL, 0x0000000138397824ULL, 0x040fe400078e022fULL,
0x0000001038407824ULL, 0x000fe200078e00ffULL, 0xfffffff03e3e7812ULL, 0x000fe200078ee237ULL,
0x00005e003c3c7625ULL, 0x000fc600078e0041ULL, 0xfffffff040407812ULL, 0x000fe200078ee239ULL,
0x000000013b367824ULL, 0x040fe200078e0236ULL, 0x000000433c3c7210ULL, 0x000fe20007f7e0ffULL,
0x000000013b387824ULL, 0x040fe400078e0238ULL, 0x000000013b3b7824ULL, 0x000fe400078e023aULL,
0x00005e0036367625ULL, 0x000fc800078e0041ULL, 0x000000013a3f7824ULL, 0x000fe200078e022fULL,
0x0000004336367210ULL, 0x000fe20007f1e0ffULL, 0x000000103a427824ULL, 0x000fe400078e00ffULL,
0x00005e0038387625ULL, 0x000fc600078e0041ULL, 0xfffffff042427812ULL, 0x000fe200078ee23fULL,
0x00005e003b3a7625ULL, 0x000fe200078e0041ULL, 0x000140003e3f7811ULL, 0x000fe400078e20ffULL,
0x0001400040417811ULL, 0x000fe200078e20ffULL, 0x000000ffff3d7224ULL, 0x000fe200018e063dULL,
0x0000004338387210ULL, 0x080fe20007f7e0ffULL, 0x000000ffff377224ULL, 0x000fe200000e0637ULL,
0x000000433a3a7210ULL, 0x000fe40007f9e0ffULL, 0x0001400042437811ULL, 0x000fe200078e20ffULL,
0x000000ffff397224ULL, 0x000fe200018e0639ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e2000b901c46ULL, 0x000000ffff3b7224ULL, 0x000fc600020e063bULL,
0x00000000363f7faeULL, 0x0003e8000b901c46ULL, 0x0000000038417faeULL, 0x0003e8000b901c46ULL,
0x000000003a437faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0186a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0186a800ff3c7f8cULL, 0x000e64000c80043fULL,
0x0000000000367805ULL, 0x000fc40000015200ULL, 0x0186b400ff397984ULL, 0x000ea40000000800ULL,
0x8000000039ff7812ULL, 0x004fc4000780484fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff3a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fcc0000015200ULL,
0x00000038363b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000139397824ULL, 0x000fe200000e0e37ULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff387819ULL, 0x000fc80000011439ULL, 0x0000003b38387211ULL, 0x000fca00078110ffULL,
0x000000ffff397224ULL, 0x000fca00000e0639ULL, 0x0000000238387819ULL, 0x000fc80000001239ULL,
0x000000380000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013a3a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0186b400ff397984ULL, 0x000ea40000000800ULL, 0x8000000039ff7812ULL, 0x004fe4000780484fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000018000007945ULL, 0x000fe20003800000ULL,
0x0000016000002947ULL, 0x000fea0003800000ULL, 0x00000024ff22723eULL, 0x000fe400000010ffULL,
0x00000002ff377819ULL, 0x000fe4000001162fULL, 0x0000541022367816ULL, 0x000fe20000000022ULL,
0x0001b8727f007947ULL, 0x000fea000b800000ULL, 0x00001f3736237589ULL, 0x0004e400000e0000ULL,
0x0000000837597810ULL, 0x002fe20007ffe0ffULL, 0x0001b8c27f007947ULL, 0x000fea000b800000ULL,
0x00001f5936227589ULL, 0x0002a400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001037597810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff587224ULL, 0x000fe200078e0036ULL,
0x000050c000407802ULL, 0x000fe20000000f00ULL, 0x0000001fff5a7424ULL, 0x000fc400078e00ffULL,
0xffffffffff5b7424ULL, 0x000fc400078e00ffULL, 0x0001c8b000007944ULL, 0x00cfea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001837597810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff587224ULL, 0x004fe200078e0036ULL, 0x0000513000407802ULL, 0x000fe20000000f00ULL,
0x0000001fff5a7424ULL, 0x000fe400078e00ffULL, 0xffffffffff5b7424ULL, 0x000fc400078e00ffULL,
0x0001c84000007944ULL, 0x008fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0001600055367811ULL, 0x006fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0001600053377811ULL, 0x000fe200078e20ffULL, 0x000000014d527824ULL, 0x040fe400078e0252ULL,
0x000000003638783bULL, 0x000e620000004200ULL, 0x000000014d507824ULL, 0x000fc600078e0250ULL,
0x000000003748783bULL, 0x000ea20000004200ULL, 0x00000018ff417819ULL, 0x002fe2000001143aULL,
0x0000003800b37306ULL, 0x000fe20000009400ULL, 0x00000018ff407819ULL, 0x000fe40000011439ULL,
0x00000018ff3c7819ULL, 0x000fe40000011438ULL, 0x00000018ff427819ULL, 0x000fe4000001143bULL,
0x00000018ff437819ULL, 0x004fe20000011449ULL, 0x00000041007d7306ULL, 0x000ff00000209400ULL,
0x0000004100807306ULL, 0x000ff00000205400ULL, 0x0000004100617306ULL, 0x0003f0000020d400ULL,
0x0000004000977306ULL, 0x000fe20000209400ULL, 0x00000018ff417819ULL, 0x002fce000001144aULL,
0x0000004000927306ULL, 0x000ff00000205400ULL, 0x0000004000657306ULL, 0x0003f0000020d400ULL,
0x0000003800ae7306ULL, 0x000fe20000005400ULL, 0x0000010038407824ULL, 0x002fca00078e00ffULL,
0x00000018ff407819ULL, 0x000fe40000011440ULL, 0x0000003800737306ULL, 0x0003f0000000d400ULL,
0x0000004100607306ULL, 0x000fe20000209400ULL, 0x0001000038387824ULL, 0x002fca00078e00ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x00000041005d7306ULL, 0x000ff00000205400ULL,
0x00000041004f7306ULL, 0x0003f0000020d400ULL, 0x0000003900a27306ULL, 0x000fe20000009400ULL,
0x0000010039417824ULL, 0x002fca00078e00ffULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x0000003900a17306ULL, 0x000ff00000005400ULL, 0x00000039006b7306ULL, 0x0003f0000000d400ULL,
0x0000003800ab7306ULL, 0x000fe20000209400ULL, 0x0001000039397824ULL, 0x002fca00078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000003800ac7306ULL, 0x000ff00000205400ULL,
0x0000003800707306ULL, 0x0003f0000020d400ULL, 0x00000039009a7306ULL, 0x000fe20000209400ULL,
0x000001003b387824ULL, 0x002fca00078e00ffULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x0000003900997306ULL, 0x000ff00000205400ULL, 0x00000039006a7306ULL, 0x0003f0000020d400ULL,
0x0000004000b17306ULL, 0x000fe20000209400ULL, 0x000000104d397824ULL, 0x002fc400078e00ffULL,
0x00000100494d7824ULL, 0x000fc600078e00ffULL, 0xfffffff039527812ULL, 0x040fe400078ee252ULL,
0x0000004000b07306ULL, 0x000fe20000205400ULL, 0xfffffff039397812ULL, 0x000fc800078ee250ULL,
0x0001600039397811ULL, 0x000fc600078e20ffULL, 0x0000004000767306ULL, 0x0003e4000020d400ULL,
0x000000003944783bULL, 0x000eac0000004200ULL, 0x0000003c00a67306ULL, 0x000fe20000209400ULL,
0x000001003a407824ULL, 0x002fca00078e00ffULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x0000003c00a37306ULL, 0x000ff00000205400ULL, 0x0000003c006f7306ULL, 0x0003f0000020d400ULL,
0x0000004200797306ULL, 0x000fe20000209400ULL, 0x00000018ff3c7819ULL, 0x002fce0000011448ULL,
0x00000042007e7306ULL, 0x000fe20000205400ULL, 0x00000018ff947819ULL, 0x004fe20000011444ULL,
0x0000010046ea7824ULL, 0x000fe200078e00ffULL, 0x00000018ff957819ULL, 0x000fe40000011445ULL,
0x00000018ff967819ULL, 0x000fc60000011446ULL, 0x00000042005a7306ULL, 0x0003e2000020d400ULL,
0x00000018ffea7819ULL, 0x000fe400000114eaULL, 0x00000018ffb77819ULL, 0x000fca0000011447ULL,
0x00000038008b7306ULL, 0x000fe20000209400ULL, 0x00000018ff427819ULL, 0x002fce000001144bULL,
0x0000003800887306ULL, 0x000ff00000205400ULL, 0x0000003800627306ULL, 0x0003f0000020d400ULL,
0x0000003c006d7306ULL, 0x000fe20000209400ULL, 0x0001600052387811ULL, 0x002fc400078e20ffULL,
0x00000018ff527819ULL, 0x000fca000001144dULL, 0x0000003c006e7306ULL, 0x000ff00000205400ULL,
0x0000003c00587306ULL, 0x000ff0000020d400ULL, 0x0000004300667306ULL, 0x000ff00000209400ULL,
0x0000004300677306ULL, 0x000ff00000205400ULL, 0x0000004300567306ULL, 0x000ff0000020d400ULL,
0x0000004200597306ULL, 0x000ff00000209400ULL, 0x00000042005c7306ULL, 0x000ff00000205400ULL,
0x00000042003c7306ULL, 0x000ff0000020d400ULL, 0x0000004100a97306ULL, 0x000ff00000209400ULL,
0x0000004100aa7306ULL, 0x000ff00000205400ULL, 0x0000004100727306ULL, 0x000ff0000020d400ULL,
0x0000004000907306ULL, 0x000ff00000209400ULL, 0x00000040008d7306ULL, 0x000ff00000205400ULL,
0x00000040006c7306ULL, 0x0003f0000020d400ULL, 0x0000003a00a47306ULL, 0x000fe20000009400ULL,
0x000000003840783bULL, 0x002e6e0000004200ULL, 0x0000003a00a57306ULL, 0x000ff00000005400ULL,
0x0000003a00697306ULL, 0x0005f0000000d400ULL, 0x0000003b009d7306ULL, 0x000fe20000009400ULL,
0x000100003a3a7824ULL, 0x004fca00078e00ffULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x0000003b003e7306ULL, 0x000ff00000005400ULL, 0x0000003b005f7306ULL, 0x0005e2000000d400ULL,
0x00000018ff8e7819ULL, 0x002fc40000011442ULL, 0x00000018ff7f7819ULL, 0x000fe40000011440ULL,
0x00000018ff857819ULL, 0x000fe40000011441ULL, 0x00000018ff937819ULL, 0x000fe20000011443ULL,
0x0000008e00d17306ULL, 0x000fe20000209400ULL, 0x000100003b3b7824ULL, 0x004fca00078e00ffULL,
0x00000018ff3b7819ULL, 0x000fe4000001143bULL, 0x0000008e00c87306ULL, 0x000ff00000205400ULL,
0x0000008e00987306ULL, 0x0003f0000020d400ULL, 0x0000003a00837306ULL, 0x000fe20000209400ULL,
0x00000100408e7824ULL, 0x002fca00078e00ffULL, 0x00000018ff8e7819ULL, 0x000fe4000001148eULL,
0x0000003a00847306ULL, 0x000ff00000205400ULL, 0x0000003a00687306ULL, 0x0003f0000020d400ULL,
0x0000008e00d47306ULL, 0x000fe20000209400ULL, 0x00000100483a7824ULL, 0x002fca00078e00ffULL,
0x00000018ff3a7819ULL, 0x000fe4000001143aULL, 0x0000008e00d97306ULL, 0x000e700000205400ULL,
0x00000048003f7306ULL, 0x000ff00000009400ULL, 0x00000048009c7306ULL, 0x000fe20000005400ULL,
0x000000d9d400720bULL, 0x002fce0003f7d000ULL, 0x00000048005b7306ULL, 0x0003f0000000d400ULL,
0x0000003b00817306ULL, 0x000fe20000209400ULL, 0x0001000048487824ULL, 0x002fce00078e00ffULL,
0x0000003b00827306ULL, 0x000ff00000205400ULL, 0x0000003b00637306ULL, 0x0003f0000020d400ULL,
0x0000004000cc7306ULL, 0x000fe20000009400ULL, 0x00000018ff3b7819ULL, 0x002fce0000011448ULL,
0x0000004000cb7306ULL, 0x000e700000005400ULL, 0x0000004000487306ULL, 0x000530000000d400ULL,
0x0000009400d07306ULL, 0x000fe20000209400ULL, 0x0001000040407824ULL, 0x004fe200078e00ffULL,
0x000000cbcc00720bULL, 0x002fcc0003f9d000ULL, 0x0000009400d57306ULL, 0x000fee0000205400ULL,
0x0000000148484812ULL, 0x010fe200078efcffULL, 0x00000094008c7306ULL, 0x0003f0000020d400ULL,
0x0000007f00ca7306ULL, 0x000fe20000209400ULL, 0x0000010041947824ULL, 0x002fca00078e00ffULL,
0x00000018ff947819ULL, 0x000fe40000011494ULL, 0x0000007f00cd7306ULL, 0x000e700000205400ULL,
0x0000008500d37306ULL, 0x000ff00000209400ULL, 0x0000008500ce7306ULL, 0x000fe20000205400ULL,
0x000000cdca00720bULL, 0x002fce0003fbd000ULL, 0x0000008500ad7306ULL, 0x000ff0000020d400ULL,
0x0000009300d77306ULL, 0x000ff00000209400ULL, 0x0000009300d27306ULL, 0x000ff00000205400ULL,
0x0000009300917306ULL, 0x0003f0000020d400ULL, 0x0000008e00b57306ULL, 0x000ea2000020d400ULL,
0x00000018ff937819ULL, 0x002fce0000011440ULL, 0x0000004100cf7306ULL, 0x000ff00000009400ULL,
0x00000041009e7306ULL, 0x000e620000005400ULL, 0x00000001b5b53812ULL, 0x004fc800078efcffULL,
0x00000048b548723eULL, 0x000fc600000010ffULL, 0x0000009500c57306ULL, 0x000ff00000209400ULL,
0x0000009500c27306ULL, 0x000fe20000205400ULL, 0x0000009ecf00720bULL, 0x002fce0003f7d000ULL,
0x0000009500857306ULL, 0x0003f0000020d400ULL, 0x0000009300db7306ULL, 0x000fe20000209400ULL,
0x0000010042957824ULL, 0x002fca00078e00ffULL, 0x00000018ff957819ULL, 0x000fe40000011495ULL,
0x0000009300407306ULL, 0x000e700000205400ULL, 0x0000009300b47306ULL, 0x000530000020d400ULL,
0x0000009400d67306ULL, 0x000fe20000209400ULL, 0x0000010043937824ULL, 0x004fe200078e00ffULL,
0x00000040db00720bULL, 0x002fe20003fdd000ULL, 0x0000010047407824ULL, 0x000fc600078e00ffULL,
0x00000018ff937819ULL, 0x000fe40000011493ULL, 0x0000009400dd7306ULL, 0x000e6e0000205400ULL,
0x00000001b4b46812ULL, 0x010fe200078efcffULL, 0x0000007f00af7306ULL, 0x000ea2000020d400ULL,
0x000000ced300720bULL, 0x000fce0003fdd000ULL, 0x0000009500df7306ULL, 0x000fe20000209400ULL,
0x000000ddd600720bULL, 0x002fca0003f1d000ULL, 0x00000001adad6812ULL, 0x000fe400078efcffULL,
0x0000009500da7306ULL, 0x000e620000205400ULL, 0x00000001afaf5812ULL, 0x004fce00078efcffULL,
0x0000004100b27306ULL, 0x000530000000d400ULL, 0x0000009300e17306ULL, 0x000fe20000209400ULL,
0x0001000041417824ULL, 0x004fe200078e00ffULL, 0x000000dadf00720bULL, 0x002fc80003fbd000ULL,
0x00000018ff8e7819ULL, 0x000fe40000011441ULL, 0x0000009300dc7306ULL, 0x000e620000205400ULL,
0x00000001b2b23812ULL, 0x010fce00078efcffULL, 0x0000009400bd7306ULL, 0x000eb0000020d400ULL,
0x0000004200c67306ULL, 0x000fe20000009400ULL, 0x000000dce100720bULL, 0x002fce0003f7d000ULL,
0x0000004200c97306ULL, 0x000e620000005400ULL, 0x00000001bdbd0812ULL, 0x004fce00078efcffULL,
0x0000004300c47306ULL, 0x000ff00000009400ULL, 0x0000004300c77306ULL, 0x000fe20000005400ULL,
0x000000c9c600720bULL, 0x002fce0003f1d000ULL, 0x00000043009f7306ULL, 0x0003f0000000d400ULL,
0x0000009500a77306ULL, 0x000522000020d400ULL, 0x0001000043437824ULL, 0x002fce00078e00ffULL,
0x0000008e00d87306ULL, 0x000fe20000209400ULL, 0x00000018ff957819ULL, 0x004fe20000011443ULL,
0x0000010044437824ULL, 0x000fca00078e00ffULL, 0x00000018ffe27819ULL, 0x000fe20000011443ULL,
0x0000008e00417306ULL, 0x000e620000205400ULL, 0x00000001a7a75812ULL, 0x010fe400078efcffULL,
0x000000c8d100720bULL, 0x000fca0003fbd000ULL, 0x0000004200a07306ULL, 0x000530000000d400ULL,
0x0000009300a87306ULL, 0x000722000020d400ULL, 0x0001000042427824ULL, 0x004fe200078e00ffULL,
0x00000041d800720bULL, 0x002fc40003f9d000ULL, 0x0000000198985812ULL, 0x000fe400078efcffULL,
0x00000018ff417819ULL, 0x000fe40000011440ULL, 0x0000008e00bc7306ULL, 0x0002a2000020d400ULL,
0x0000010045937824ULL, 0x008fe200078e00ffULL, 0x00000001a0a00812ULL, 0x010fc800078efcffULL,
0x00000018ffe67819ULL, 0x000fe40000011493ULL, 0x0000004400c37306ULL, 0x000fe20000009400ULL,
0x00000018ff8e7819ULL, 0x002fe40000011442ULL, 0x00000001a8a83812ULL, 0x000fe400078efcffULL,
0x000000d2d700720bULL, 0x000fc60003f7d000ULL, 0x0000004400c07306ULL, 0x000fe20000005400ULL,
0x00000001bcbc4812ULL, 0x004fe400078efcffULL, 0x000000c7c400720bULL, 0x000fca0003f9d000ULL,
0x00000044008f7306ULL, 0x0003e4000000d400ULL, 0x0000000191913812ULL, 0x000fcc00078efcffULL,
0x0000009500e07306ULL, 0x000fe20000209400ULL, 0x0001000044447824ULL, 0x002fe200078e00ffULL,
0x000000019f9f4812ULL, 0x000fc800078efcffULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x0000009500e57306ULL, 0x000e700000205400ULL, 0x0000008e00427306ULL, 0x000ff00000209400ULL,
0x0000008e00e37306ULL, 0x000ea20000205400ULL, 0x000000e5e000720bULL, 0x002fce0003f1d000ULL,
0x000000e600e87306ULL, 0x000ff00000209400ULL, 0x000000e600e97306ULL, 0x000e620000205400ULL,
0x000000e34200720bULL, 0x004fce0003fdd000ULL, 0x0000003a007b7306ULL, 0x000ff00000209400ULL,
0x0000003a00507306ULL, 0x000fe20000205400ULL, 0x000000e9e800720bULL, 0x002fce0003fbd000ULL,
0x0000003a00647306ULL, 0x000ff0000020d400ULL, 0x0000004500c17306ULL, 0x000ff00000009400ULL,
0x00000045003a7306ULL, 0x000ff00000005400ULL, 0x00000045008a7306ULL, 0x0003f0000000d400ULL,
0x0000004400e47306ULL, 0x000fe20000209400ULL, 0x0001000045457824ULL, 0x002fca00078e00ffULL,
0x00000018ff457819ULL, 0x000fe40000011445ULL, 0x0000004400e77306ULL, 0x000e700000205400ULL,
0x0000009600ba7306ULL, 0x000ff00000209400ULL, 0x0000009600bb7306ULL, 0x000fe20000205400ULL,
0x000000e7e400720bULL, 0x002fce0003f7d000ULL, 0x00000096007f7306ULL, 0x000ff0000020d400ULL,
0x0000009500967306ULL, 0x000e70000020d400ULL, 0x0000008e009b7306ULL, 0x000eb0000020d400ULL,
0x000000e200de7306ULL, 0x000fe20000209400ULL, 0x0000000196960812ULL, 0x002fc400078efcffULL,
0x0000003ac100720bULL, 0x000fe40003f1d000ULL, 0x00000004513a7810ULL, 0x040fe40007ffe0ffULL,
0x0000000651517810ULL, 0x000fe20007ffe0ffULL, 0x000000e200437306ULL, 0x000e620000205400ULL,
0x000000019b9b6812ULL, 0x004fe400078efcffULL, 0x000000c0c300720bULL, 0x000fe40003fdd000ULL,
0x000000969191723eULL, 0x000fc600000010ffULL, 0x000000e200947306ULL, 0x000ea2000020d400ULL,
0x000000018a8a0812ULL, 0x000fe400078efcffULL, 0x000000c2c500720bULL, 0x000fca0003f1d000ULL,
0x000000e600937306ULL, 0x000ee2000020d400ULL, 0x00000043de00720bULL, 0x002fe20003f9d000ULL,
0x0000000854437824ULL, 0x040fe200078e00ffULL, 0x000000018f8f6812ULL, 0x000fe200078efcffULL,
0x0000000854547824ULL, 0x000fc600078e00ffULL, 0xfffffff8433a7812ULL, 0x000fe200078ee23aULL,
0x0000004500e27306ULL, 0x000fe20000209400ULL, 0x0000000185850812ULL, 0x000fca00078efcffULL,
0x0000000194944812ULL, 0x004fe400078efcffULL, 0x0000004500eb7306ULL, 0x000e620000205400ULL,
0x0000000193935812ULL, 0x008fe400078efcffULL, 0x000000d5d000720bULL, 0x000fca0003f9d000ULL,
0x0000004400957306ULL, 0x0004f0000020d400ULL, 0x000000ea00d47306ULL, 0x000fe20000209400ULL,
0x000000ebe200720bULL, 0x002fe40003fbd000ULL, 0x000120003a447811ULL, 0x004fc400078e20ffULL,
0x000000018c8c4812ULL, 0x000fc600078efcffULL, 0x000000ea00cb7306ULL, 0x000e620000205400ULL,
0x0000000195953812ULL, 0x008fce00078efcffULL, 0x0000004600bf7306ULL, 0x000ff00000009400ULL,
0x0000004600be7306ULL, 0x000ea20000005400ULL, 0x000000cbd400720bULL, 0x002fce0003f7d000ULL,
0x0000004600877306ULL, 0x0002f0000000d400ULL, 0x0000003b00757306ULL, 0x000fe20000209400ULL,
0x0001000046467824ULL, 0x002fe200078e00ffULL, 0x000000bebf00720bULL, 0x004fc80003fdd000ULL,
0x00000018ff467819ULL, 0x000fe40000011446ULL, 0x0000003b00787306ULL, 0x000fee0000205400ULL,
0x0000000187876812ULL, 0x008fe200078efcffULL, 0x0000003b004d7306ULL, 0x000fe2000020d400ULL,
0x000000bbba00720bULL, 0x000fce0003fdd000ULL, 0x00000045008e7306ULL, 0x000e6c000020d400ULL,
0x000000017f7f6812ULL, 0x000fe400078efcffULL, 0x0000004700b67306ULL, 0x000fe20000009400ULL,
0x000000a1a200720bULL, 0x000fce0003fdd000ULL, 0x00000047003b7306ULL, 0x000ea20000005400ULL,
0x000000018e8e5812ULL, 0x002fc800078efcffULL, 0x0000008e8585723eULL, 0x000fe400000010ffULL,
0x000000016b6b6812ULL, 0x000fe200078efcffULL, 0x00000052007c7306ULL, 0x000fe20000209400ULL,
0x000000999a00720bULL, 0x000fce0003fdd000ULL, 0x0000005200777306ULL, 0x000fe20000205400ULL,
0x0000003bb600720bULL, 0x004fe40003fbd000ULL, 0xfffffff8543b7812ULL, 0x000fc600078ee251ULL,
0x000000016a6a6812ULL, 0x000fe400078efcffULL, 0x00000052005e7306ULL, 0x000ff0000020d400ULL,
0x000000ea009e7306ULL, 0x000e70000020d400ULL, 0x0000004700527306ULL, 0x0004f0000000d400ULL,
0x0000004100457306ULL, 0x000fe20000209400ULL, 0x0001000047477824ULL, 0x004fe200078e00ffULL,
0x000000019e9e3812ULL, 0x002fc400078efcffULL, 0x000000aeb300720bULL, 0x000fe20003f7d000ULL,
0x000001004aae7824ULL, 0x000fe200078e00ffULL, 0x00000018ff427819ULL, 0x000fe40000011447ULL,
0x0000004100c67306ULL, 0x000e620000205400ULL, 0x0000000152525812ULL, 0x008fe400078efcffULL,
0x00000018ffae7819ULL, 0x000fe400000114aeULL, 0x000000879e9e723eULL, 0x000fc600000010ffULL,
0x0000004100c77306ULL, 0x000ea2000020d400ULL, 0x0000000173733812ULL, 0x000fe400078efcffULL,
0x000000aaa900720bULL, 0x000fca0003f7d000ULL, 0x0000004600407306ULL, 0x000fe20000209400ULL,
0x000000c64500720bULL, 0x002fce0003f9d000ULL, 0x0000004600417306ULL, 0x000e620000205400ULL,
0x0000000172723812ULL, 0x000fe400078efcffULL, 0x000000929700720bULL, 0x000fc60003f7d000ULL,
0x00000001c7c74812ULL, 0x004fe400078efcffULL, 0x0000004200437306ULL, 0x000ff00000209400ULL,
0x0000004200be7306ULL, 0x000ea20000205400ULL, 0x000000414000720bULL, 0x002fc40003f1d000ULL,
0x000120003b407811ULL, 0x000fe400078e20ffULL, 0x0000000165653812ULL, 0x000fe400078efcffULL,
0x000000888b00720bULL, 0x000fe20003f7d000ULL, 0x000000b700b87306ULL, 0x000ff00000209400ULL,
0x000000b700b97306ULL, 0x000e620000205400ULL, 0x000000be4300720bULL, 0x004fc60003fbd000ULL,
0x0000000162623812ULL, 0x000fe400078efcffULL, 0x0000007e7900720bULL, 0x000fe40003f7d000ULL,
0x0000004600c07306ULL, 0x0004f0000020d400ULL, 0x0000004200b67306ULL, 0x0008e2000020d400ULL,
0x000000004444783bULL, 0x004ea20000000200ULL, 0x000000b9b800720bULL, 0x002fc40003f9d000ULL,
0x000000015a5a3812ULL, 0x000fe400078efcffULL, 0x000000777c00720bULL, 0x000fe40003f7d000ULL,
0x000000b700c17306ULL, 0x000e62000020d400ULL, 0x000000004040783bULL, 0x010f220000000200ULL,
0x00000001c0c00812ULL, 0x008fe400078efcffULL, 0x000000b0b100720bULL, 0x000fe20003f1d000ULL,
0x000100004ab07824ULL, 0x000fe200078e00ffULL, 0x000000c07fc0723eULL, 0x000fe200000010ffULL,
0x000100004bb17824ULL, 0x000fe200078e00ffULL, 0x00000001b6b65812ULL, 0x000fe200078efcffULL,
0x0000004900867306ULL, 0x000fe20000009400ULL, 0x000000acab00720bULL, 0x000fc40003fbd000ULL,
0x00000018ffb07819ULL, 0x000fe400000114b0ULL, 0x00000018ffb17819ULL, 0x000fe400000114b1ULL,
0x00000001c1c14812ULL, 0x002fe200078efcffULL, 0x0000004900897306ULL, 0x000e620000005400ULL,
0x000000a3a600720bULL, 0x000fe40003f9d000ULL, 0x0000000176760812ULL, 0x000fe400078efcffULL,
0x000000a5a400720bULL, 0x000fc40003f1d000ULL, 0x0000000170705812ULL, 0x000fe200078efcffULL,
0x0000004900577306ULL, 0x0007e2000000d400ULL, 0x0000003e9d00720bULL, 0x000fe40003fbd000ULL,
0x000000b4af3e723eULL, 0x000fe400000010ffULL, 0x000000b6c1c1723eULL, 0x000fe400000010ffULL,
0x000000016f6f4812ULL, 0x000fe200078efcffULL, 0x000000234444a231ULL, 0x084fe200003400ffULL,
0x0001000049497824ULL, 0x008fe200078e00ffULL, 0x000000234646a231ULL, 0x080fe200003400ffULL,
0x0000009c3f00720bULL, 0x000fe20003f9d000ULL, 0x000000224545a231ULL, 0x080fe200003400ffULL,
0x0000000169690812ULL, 0x000fe200078efcffULL, 0x000000224747a231ULL, 0x080fe200003400ffULL,
0x000000807d00720bULL, 0x000fe20003f1d000ULL, 0x000000234040a231ULL, 0x090fe200003400ffULL,
0x00000018ff517819ULL, 0x000fe20000011449ULL, 0x000000234242a231ULL, 0x000fe200003400ffULL,
0x000000bcad3f723eULL, 0x000fe200000010ffULL, 0x000000224141a231ULL, 0x080fe200003400ffULL,
0x000000b2bd49723eULL, 0x000fe200000010ffULL, 0x000000224343a231ULL, 0x000fe200003400ffULL,
0x0000008d9000720bULL, 0x000fe20003f5d000ULL, 0x0000004a00537306ULL, 0x000fe20000009400ULL,
0x000000015b5b4812ULL, 0x000fe200078efcffULL, 0x0000003e4410723cULL, 0x000fe20000041810ULL,
0x000000787500720bULL, 0x000fc40003f9d000ULL, 0x0000000161610812ULL, 0x000fe400078efcffULL,
0x000000898600720bULL, 0x002fe20003fdd000ULL, 0x0000004a007a7306ULL, 0x000e620000005400ULL,
0x000000507b00720bULL, 0x000fe20003f1d000ULL, 0x00000048441c723cULL, 0x040b62000004181cULL,
0x0000009b9890723eULL, 0x000fe400000010ffULL, 0x000000016c6c2812ULL, 0x000fe400078efcffULL,
0x000000848300720bULL, 0x000fe20003f5d000ULL, 0x000000ae009c7306ULL, 0x000fe20000209400ULL,
0x000000a0a748723eULL, 0x020fe200000010ffULL, 0x00000090440c723cULL, 0x000fe2000004180cULL,
0x0000009fa849723eULL, 0x000fc400000010ffULL, 0x000000958c84723eULL, 0x000fe400000010ffULL,
0x00000052c79f723eULL, 0x000fe200000010ffULL, 0x000000ae003f7306ULL, 0x000ea20000205400ULL,
0x000000014d4d4812ULL, 0x000fe200078efcffULL, 0x000000484404723cULL, 0x040b620000041804ULL,
0x000000015f5f5812ULL, 0x000fe400078efcffULL, 0x0000000168682812ULL, 0x000fe400078efcffULL,
0x0000007a5300720bULL, 0x002fe20003f5d000ULL, 0x0000005100547306ULL, 0x000fe20000209400ULL,
0x0000008f9448723eULL, 0x020fe200000010ffULL, 0x000000844408723cULL, 0x000f620000041808ULL,
0x0000008a9349723eULL, 0x000fc400000010ffULL, 0x0000000164640812ULL, 0x000fe400078efcffULL,
0x000000015e5e3812ULL, 0x000fe200078efcffULL, 0x0000005100ab7306ULL, 0x000e620000205400ULL,
0x0000003f9c00720bULL, 0x004fe20003f9d000ULL, 0x000000c04430723cULL, 0x000fe20000041830ULL,
0x0000000157576812ULL, 0x000fe400078efcffULL, 0x000000828100720bULL, 0x000fe40003fbd000ULL,
0x0000006e6d00720bULL, 0x000fe20003f1d000ULL, 0x0000004a00557306ULL, 0x0004e2000000d400ULL,
0x000000676600720bULL, 0x000fc40003fdd000ULL, 0x000000737676723eULL, 0x000fe400000010ffULL,
0x0000006b7277723eULL, 0x000fe400000010ffULL, 0x0000005b6464723eULL, 0x000fe200000010ffULL,
0x0000004b00717306ULL, 0x000fe20000009400ULL, 0x000001004b4a7824ULL, 0x004fe200078e00ffULL,
0x000000ab5400720bULL, 0x002fe40003f7d000ULL, 0x0000000163635812ULL, 0x000fe200078efcffULL,
0x00000076401c723cULL, 0x000fe2000004181cULL, 0x00000018ff867819ULL, 0x000fc4000001144aULL,
0x0000004b00747306ULL, 0x000e620000005400ULL, 0x0000000158580812ULL, 0x000fe400078efcffULL,
0x0000000156566812ULL, 0x000fe400078efcffULL, 0x0000000155552812ULL, 0x008fe400078efcffULL,
0x0000005d6000720bULL, 0x000fe20003f1d000ULL, 0x0000004b004e7306ULL, 0x0004e2000000d400ULL,
0x0000004d5858723eULL, 0x000fce00000010ffULL, 0x0000005100a17306ULL, 0x0008e2000020d400ULL,
0x000000484448723cULL, 0x004b620000041814ULL, 0x000000747100720bULL, 0x002fe40003fbd000ULL,
0x000000014f4f0812ULL, 0x000fc800078efcffULL, 0x000000ae00ae7306ULL, 0x000e62000020d400ULL,
0x0000009e4450723cULL, 0x010b640000041818ULL, 0x000000696c14723eULL, 0x020fe400000010ffULL,
0x0000005f6215723eULL, 0x000fe400000010ffULL, 0x000000014e4e5812ULL, 0x008fe200078efcffULL,
0x0000008600837306ULL, 0x000fe20000209400ULL, 0x00000001a1a13812ULL, 0x000fe400078efcffULL,
0x0000005c5900720bULL, 0x000fe20003f7d000ULL, 0x000000144014723cULL, 0x000b620000041804ULL,
0x000000706f18723eULL, 0x000fc400000010ffULL, 0x0000006a6519723eULL, 0x000fe200000010ffULL,
0x00000086007e7306ULL, 0x000ea20000205400ULL, 0x00000001aeae4812ULL, 0x002fe400078efcffULL,
0x000000575e65723eULL, 0x000fe400000010ffULL, 0x000000a15659723eULL, 0x000fe200000010ffULL,
0x000000184018723cULL, 0x000b640000041810ULL, 0x00000055ae04723eULL, 0x020fe200000010ffULL,
0x000000b0003e7306ULL, 0x000fe20000209400ULL, 0x000000013c3c3812ULL, 0x000fc600078efcffULL,
0x000000686110723eULL, 0x000fe200000010ffULL, 0x000000584008723cULL, 0x000b620000041808ULL,
0x000000635a11723eULL, 0x000fe400000010ffULL, 0x000000b000457306ULL, 0x000e620000205400ULL,
0x0000007e8300720bULL, 0x004fc80003fdd000ULL, 0x000000104010723cULL, 0x040b66000004180cULL,
0x000000b100447306ULL, 0x000fea0000209400ULL, 0x00000064400c723cULL, 0x000b660000041848ULL,
0x000000b1003f7306ULL, 0x000ea20000205400ULL, 0x000000453e00720bULL, 0x002fce0003f9d000ULL,
0x0000008600797306ULL, 0x000e70000020d400ULL, 0x000000b000b07306ULL, 0x000ee2000020d400ULL,
0x0000003f4400720bULL, 0x004fce0003f5d000ULL, 0x000000b100b17306ULL, 0x000ea2000020d400ULL,
0x0000000179796812ULL, 0x002fc800078efcffULL, 0x0000004e7905723eULL, 0x000fe400000010ffULL,
0x00000001b0b04812ULL, 0x008fc800078efcffULL, 0x000000b04fb0723eULL, 0x000fe200000010ffULL,
0x000000044004723cULL, 0x000b620000041850ULL, 0x00000001b1b12812ULL, 0x004fc800078efcffULL,
0x000000b13cb1723eULL, 0x000fce00000010ffULL, 0x000000b04030723cULL, 0x000b620000041830ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0186b800ff3e7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000020273c7810ULL, 0x000fe20007ffe0ffULL, 0x01868800ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff427224ULL, 0x022fe400078e003fULL, 0x0000002d3c00720cULL, 0x000fe20003f06070ULL,
0x000000ffff3c7224ULL, 0x000fd800078e004cULL, 0x0001184000000947ULL, 0x000fea0003800000ULL,
0x00000000003e7805ULL, 0x000fc40000015200ULL, 0x0186bc00ff417984ULL, 0x000e640000000800ULL,
0x8000000041ff7812ULL, 0x002fe40007804842ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff447224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000407805ULL, 0x000fcc0000015200ULL,
0x000000403e437210ULL, 0x000fca0007f1e1ffULL, 0x0000000141417824ULL, 0x000fe200000e0e3fULL,
0x003d09004300780cULL, 0x000fc80003f06070ULL, 0x000000ff4100720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404300780cULL, 0x000fc80003f06070ULL,
0x000000ff4100720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3c7819ULL, 0x000fc80000011441ULL, 0x000000433c3c7211ULL, 0x000fca00078110ffULL,
0x000000ffff417224ULL, 0x000fca00000e0641ULL, 0x000000023c3c7819ULL, 0x000fc80000001241ULL,
0x0000003c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000144447810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0186bc00ff417984ULL, 0x000e640000000800ULL, 0x8000000041ff7812ULL, 0x002fe40007804842ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000040273f7810ULL, 0x000fca0007ffe0ffULL,
0x000062002a437a24ULL, 0x000fe200078e023fULL, 0x0000039000009947ULL, 0x000fea0003800000ULL,
0x00000002214b7810ULL, 0x040fe20007ffe0ffULL, 0x000000012c3e7824ULL, 0x040fe200078e0221ULL,
0x00000004214d7810ULL, 0x000fe40007ffe0ffULL, 0x0000003f2d3c7217ULL, 0x000fe20007800000ULL,
0x000000012c427824ULL, 0x000fe200078e024bULL, 0x00000006214f7810ULL, 0x000fe20007ffe0ffULL,
0x000000013e407824ULL, 0x000fe200078e022fULL, 0x000000f026497812ULL, 0x000fe200078ec0ffULL,
0x000000103e477824ULL, 0x000fc400078e00ffULL, 0x000000012c447824ULL, 0x000fe400078e024dULL,
0x0000000142417824ULL, 0x040fe200078e022fULL, 0xfffffff047467812ULL, 0x000fe200078ee240ULL,
0x0000001042487824ULL, 0x000fe400078e00ffULL, 0x000000013c3f7824ULL, 0x000fe400078e0a3fULL,
0x0000000144457824ULL, 0x000fe200078e022fULL, 0xfffffff048487812ULL, 0x000fe200078ee241ULL,
0x00000010444a7824ULL, 0x000fe200078e00ffULL, 0x0000003f2c417217ULL, 0x000fe20007800000ULL,
0x00000100ff477424ULL, 0x000fc400078e00ffULL, 0x000000013e3e7824ULL, 0x000fe200078e0243ULL,
0xfffffff04a4a7812ULL, 0x000fe200078ee245ULL, 0x000000012c3c7824ULL, 0x000fe400078e024fULL,
0x0000000142407824ULL, 0x000fe400078e0243ULL, 0x00005e003e3e7625ULL, 0x000fc800078e0047ULL,
0x0000000144427824ULL, 0x100fe200078e0243ULL, 0x000000493e447210ULL, 0x000fe20007f1e0ffULL,
0x000000013c437824ULL, 0x040fe400078e0243ULL, 0x000000013c457824ULL, 0x040fe400078e022fULL,
0x000000103c4e7824ULL, 0x000fe400078e00ffULL, 0x00000001413c7824ULL, 0x000fe400078e0a2cULL,
0x00005e0040407625ULL, 0x000fe200078e0047ULL, 0xfffffff04e4e7812ULL, 0x000fc400078ee245ULL,
0x0000003c2100720cULL, 0x080fe20003f66070ULL, 0x000000ffff457224ULL, 0x000fe200000e063fULL,
0x0000004940407210ULL, 0x000fe20007f9e0ffULL, 0x00005e00423e7625ULL, 0x080fe200078e0047ULL,
0x0000003c4b00720cULL, 0x080fe40003f46070ULL, 0x0000003c4d00720cULL, 0x080fe20003f06070ULL,
0x00005e0043427625ULL, 0x000fe200078e0047ULL, 0x000000493e3e7210ULL, 0x080fe40007fbe0ffULL,
0x0001600046477811ULL, 0x000fe200078e20ffULL, 0x000000ffff417224ULL, 0x000fe200020e0641ULL,
0x0000003c4f00720cULL, 0x000fe20003f86070ULL, 0x000000ffff3f7224ULL, 0x000fe200028e063fULL,
0x0000004942427210ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044477faeULL, 0x0003e2000d901c46ULL, 0x0001600048497811ULL, 0x000fc400078e20ffULL,
0x000160004a4b7811ULL, 0x000fe200078e20ffULL, 0x000000ffff437224ULL, 0x000fe200030e0643ULL,
0x000160004e4d7811ULL, 0x000fe200078e20ffULL, 0x0000000040497faeULL, 0x0003e8000d101c46ULL,
0x000000003e4b7faeULL, 0x0003e8000c101c46ULL, 0x00000000424d7faeULL, 0x0003e2000e101c46ULL,
0x000002d000007947ULL, 0x000fea0003800000ULL, 0x000000012c3c7824ULL, 0x000fe200078e0221ULL,
0x000000f026497812ULL, 0x000fe200078ec0ffULL, 0x00000100ff477424ULL, 0x000fc400078e00ffULL,
0x000000013c3e7824ULL, 0x040fe200078e022fULL, 0x000000023c407810ULL, 0x040fe20007ffe0ffULL,
0x000000103c457824ULL, 0x040fe200078e00ffULL, 0x000000043c427810ULL, 0x040fe20007ffe0ffULL,
0x000000013c447824ULL, 0x040fe200078e0243ULL, 0x000000063c3c7810ULL, 0x000fe20007ffe0ffULL,
0x00000001403f7824ULL, 0x140fe200078e022fULL, 0xfffffff045467812ULL, 0x000fe200078ee23eULL,
0x0000001040487824ULL, 0x000fe400078e00ffULL, 0x0000000142417824ULL, 0x000fe200078e022fULL,
0x00016000464d7811ULL, 0x000fe200078e20ffULL, 0x00000010424a7824ULL, 0x000fe200078e00ffULL,
0xfffffff048487812ULL, 0x000fe200078ee23fULL, 0x00005e0044447625ULL, 0x000fc600078e0047ULL,
0xfffffff04a4a7812ULL, 0x000fe200078ee241ULL, 0x00000001403e7824ULL, 0x100fe200078e0243ULL,
0x0000004944447210ULL, 0x000fe20007f5e0ffULL, 0x0000000142407824ULL, 0x100fe400078e0243ULL,
0x000000013c427824ULL, 0x000fe400078e0243ULL, 0x00005e003e3e7625ULL, 0x000fc800078e0047ULL,
0x00005e0040407625ULL, 0x000fe200078e0047ULL, 0x000000493e3e7210ULL, 0x000fc60007f1e0ffULL,
0x000000013c4b7824ULL, 0x000fe400078e022fULL, 0x00005e0042427625ULL, 0x000fe200078e0047ULL,
0x0001600048477811ULL, 0x000fc600078e20ffULL, 0x000000103c3c7824ULL, 0x000fe200078e00ffULL,
0x0000004942427210ULL, 0x080fe20007f7e0ffULL, 0x000000ffff457224ULL, 0x000fe200010e0645ULL,
0x0000004940407210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff3f7224ULL, 0x000fe200000e063fULL,
0xfffffff03c4b7812ULL, 0x000fe200078ee24bULL, 0x000000ffff437224ULL, 0x000fe200018e0643ULL,
0x000160004a497811ULL, 0x000fe200078e20ffULL, 0x000000ffff417224ULL, 0x000fe200010e0641ULL,
0x000160004b4b7811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000444d7faeULL, 0x0003e8000b901c46ULL, 0x000000003e477faeULL, 0x0003e8000b901c46ULL,
0x0000000040497faeULL, 0x0003e8000b901c46ULL, 0x00000000424b7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0186b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0186b000ff3e7f8cULL, 0x002e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018628002c447f8cULL, 0x0004e4000c80043fULL, 0x0000000000407805ULL, 0x000fc40000015200ULL,
0x01862c002c437984ULL, 0x000f240000000800ULL, 0x8000000043ff7812ULL, 0x018fc40007804845ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff467224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000427805ULL, 0x000fcc0000015200ULL, 0x0000004240477210ULL, 0x000fca0007f1e1ffULL,
0x0000000143437824ULL, 0x000fe200000e0e41ULL, 0x003d09004700780cULL, 0x000fc80003f06070ULL,
0x000000ff4300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404700780cULL, 0x000fc80003f06070ULL, 0x000000ff4300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3c7819ULL, 0x000fc80000011443ULL,
0x000000473c3c7211ULL, 0x000fca00078110ffULL, 0x000000ffff437224ULL, 0x000fca00000e0643ULL,
0x000000023c3c7819ULL, 0x000fc80000001243ULL, 0x0000003c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000146467810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01862c002c437984ULL, 0x000ee40000000800ULL,
0x8000000043ff7812ULL, 0x008fe40007804845ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0180800025437984ULL, 0x000ee80000000800ULL, 0x0182800025427984ULL, 0x0004620000000800ULL,
0x0000004c4300720bULL, 0x008fe20003f1d000ULL, 0x00018cf27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000447806ULL, 0x004fc800000e0100ULL, 0x0000ffff44ff7812ULL, 0x000fe2000780c0ffULL,
0x0000048000007945ULL, 0x000fe20003800000ULL, 0x00000001ff457424ULL, 0x000fc400078e00ffULL,
0x000000ffff3c7224ULL, 0x000fd200078e004cULL, 0x0000044000008947ULL, 0x000fea0003800000ULL,
0x000000012e00780cULL, 0x000fe40003f05270ULL, 0x0000004c4300720bULL, 0x000fe20003f54000ULL,
0x00018cc27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000457806ULL, 0x000fc400010e0100ULL,
0x0000004c433c8209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x0000991045407816ULL, 0x000fc600000000ffULL, 0x0184803c25008388ULL, 0x0005e20000000800ULL,
0x000000ff4000720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000004c43417209ULL, 0x004fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff45ff7812ULL, 0x000fc6000780c0ffULL, 0x0000004c413c7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b3c3c7820ULL, 0x000fc80000410000ULL, 0x0000003c00467308ULL, 0x000ea40000000800ULL,
0x0000004629297220ULL, 0x004fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff597819ULL, 0x000fe2000001162fULL, 0x00018c027f007947ULL, 0x000fea000b800000ULL,
0x00001f59463c7589ULL, 0x0004e400000e0000ULL, 0x0000003c1c1c7220ULL, 0x088fe40000410000ULL,
0x0000003c1d1d7220ULL, 0x080fe40000410000ULL, 0x0000003c18187220ULL, 0x080fe40000410000ULL,
0x0000003c19197220ULL, 0x000fc40000410000ULL, 0x0000003c14147220ULL, 0x080fe40000410000ULL,
0x0000003c15157220ULL, 0x080fe40000410000ULL, 0x0000003c10107220ULL, 0x080fe40000410000ULL,
0x0000003c11117220ULL, 0x080fe40000410000ULL, 0x0000003c0c0c7220ULL, 0x080fe40000410000ULL,
0x0000003c0d0d7220ULL, 0x000fc40000410000ULL, 0x0000003c08087220ULL, 0x080fe40000410000ULL,
0x0000003c09097220ULL, 0x080fe40000410000ULL, 0x0000003c04047220ULL, 0x080fe40000410000ULL,
0x0000003c05057220ULL, 0x080fe40000410000ULL, 0x0000003c30307220ULL, 0x080fe40000410000ULL,
0x0000003c31317220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0045ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000082f597811ULL, 0x006fe200078ff0ffULL, 0x00018b127f007947ULL, 0x000fea000b800000ULL,
0x00001f59463c7589ULL, 0x0002a400000e0000ULL, 0x0000003c1e1e7220ULL, 0x084fe40000410000ULL,
0x0000003c1f1f7220ULL, 0x080fe40000410000ULL, 0x0000003c1a1a7220ULL, 0x080fe40000410000ULL,
0x0000003c1b1b7220ULL, 0x080fe40000410000ULL, 0x0000003c16167220ULL, 0x080fe40000410000ULL,
0x0000003c17177220ULL, 0x000fc40000410000ULL, 0x0000003c12127220ULL, 0x080fe40000410000ULL,
0x0000003c13137220ULL, 0x080fe40000410000ULL, 0x0000003c0e0e7220ULL, 0x080fe40000410000ULL,
0x0000003c0f0f7220ULL, 0x080fe40000410000ULL, 0x0000003c0a0a7220ULL, 0x080fe40000410000ULL,
0x0000003c0b0b7220ULL, 0x000fc40000410000ULL, 0x0000003c06067220ULL, 0x080fe40000410000ULL,
0x0000003c07077220ULL, 0x080fe40000410000ULL, 0x0000003c32327220ULL, 0x080fe40000410000ULL,
0x0000003c33337220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff45ff7812ULL, 0x000fe20007800844ULL, 0x00000001ff457424ULL, 0x000fe200078e00ffULL,
0x0000004c433c7209ULL, 0x000fd60007810000ULL, 0x8000003c43430221ULL, 0x000fe20000010000ULL,
0x00007610ff450816ULL, 0x000fc60000000045ULL, 0x3fb8aa3b43430820ULL, 0x000fc80000410000ULL,
0x0000004300240308ULL, 0x000ea40000000800ULL, 0x0000002442420220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002942297221ULL, 0x002fc40000010000ULL,
0x0000000000407805ULL, 0x000fca0000015200ULL, 0x0186ac00ff427984ULL, 0x000e640000000800ULL,
0x8000000042ff7812ULL, 0x002fe4000780483dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff447224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000427805ULL, 0x000fcc0000015200ULL,
0x0000004240477210ULL, 0x000fca0007f1e1ffULL, 0x0000000143437824ULL, 0x000fe200000e0e41ULL,
0x003d09004700780cULL, 0x000fc80003f06070ULL, 0x000000ff4300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404700780cULL, 0x000fc80003f06070ULL,
0x000000ff4300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff427819ULL, 0x000fc80000011443ULL, 0x0000004742427211ULL, 0x000fca00078110ffULL,
0x000000ffff437224ULL, 0x000fca00000e0643ULL, 0x0000000242427819ULL, 0x000fc80000001243ULL,
0x000000420000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000144447810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0186ac00ff427984ULL, 0x000e640000000800ULL, 0x8000000042ff7812ULL, 0x002fe4000780483dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009910453d7816ULL, 0x000fe200000000ffULL,
0x0000019000007945ULL, 0x000fe60003800000ULL, 0x000000ff3d00720cULL, 0x000fda0003f45270ULL,
0x0000016000002947ULL, 0x000fea0003800000ULL, 0x00000024ff22723eULL, 0x000fe400000010ffULL,
0x00000002ff427819ULL, 0x000fe4000001162fULL, 0x00005410223d7816ULL, 0x000fe20000000022ULL,
0x000187127f007947ULL, 0x000fea000b800000ULL, 0x00001f423d237589ULL, 0x0002a400000e0000ULL,
0x0000000842597810ULL, 0x002fe20007ffe0ffULL, 0x000187627f007947ULL, 0x000fea000b800000ULL,
0x00001f593d227589ULL, 0x0002e400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001042597810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff587224ULL, 0x000fe200078e003dULL,
0x000084a000407802ULL, 0x000fe20000000f00ULL, 0x0000001fff5a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff5b7424ULL, 0x000fc400078e00ffULL, 0x000194d000007944ULL, 0x00cfea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001842597810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff587224ULL, 0x004fe200078e003dULL, 0x0000851000407802ULL, 0x000fe20000000f00ULL,
0x0000001fff5a7424ULL, 0x000fc400078e00ffULL, 0xffffffffff5b7424ULL, 0x000fc400078e00ffULL,
0x0001946000007944ULL, 0x008fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000002048783bULL, 0x000f280000004200ULL,
0x00000000034c783bULL, 0x000fe80000004200ULL, 0x000000000240783bULL, 0x000e680000004200ULL,
0x000000000044783bULL, 0x000ee20000004200ULL, 0x00000018ff597819ULL, 0x012fe2000001144bULL,
0x0000004800c07306ULL, 0x000fe20000009400ULL, 0x00000100486f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff507819ULL, 0x000fc40000011449ULL, 0x00000018ff3d7819ULL, 0x000fe40000011448ULL,
0x00000018ff6f7819ULL, 0x000fe4000001146fULL, 0x0000005900ba7306ULL, 0x000fe20000209400ULL,
0x00000018ff607819ULL, 0x000fe40000011442ULL, 0x00000018ff747819ULL, 0x008fe40000011446ULL,
0x00000018ff5b7819ULL, 0x000fe4000001144dULL, 0x00000018ff737819ULL, 0x000fe20000011445ULL,
0x0000005900bb7306ULL, 0x000fe20000205400ULL, 0x00000018ff567819ULL, 0x000fc4000001144aULL,
0x00000018ff5d7819ULL, 0x000fe4000001144eULL, 0x00000018ff757819ULL, 0x000fc60000011447ULL,
0x0000005900877306ULL, 0x0003f0000020d400ULL, 0x0000004800c37306ULL, 0x000ee20000005400ULL,
0x00000018ff597819ULL, 0x002fce000001144fULL, 0x0000005900a37306ULL, 0x000ff00000209400ULL,
0x0000005900a67306ULL, 0x000fe20000205400ULL, 0x000000c3c000720bULL, 0x008fce0003f1d000ULL,
0x0000005900707306ULL, 0x0003f0000020d400ULL, 0x0000006000827306ULL, 0x000fe20000209400ULL,
0x00000018ff597819ULL, 0x002fce0000011443ULL, 0x0000006000817306ULL, 0x000ff00000205400ULL,
0x0000006000677306ULL, 0x000ff0000020d400ULL, 0x00000059007b7306ULL, 0x000ff00000209400ULL,
0x00000059007a7306ULL, 0x000ff00000205400ULL, 0x00000059005f7306ULL, 0x000ff0000020d400ULL,
0x0000007400607306ULL, 0x000ff00000209400ULL, 0x0000007400617306ULL, 0x000ff00000205400ULL,
0x0000007400597306ULL, 0x0003f0000020d400ULL, 0x0000004900c17306ULL, 0x000fe20000009400ULL,
0x0000010049747824ULL, 0x002fca00078e00ffULL, 0x00000018ff747819ULL, 0x000fe40000011474ULL,
0x00000049007e7306ULL, 0x000ff00000005400ULL, 0x0000004900987306ULL, 0x0003f0000000d400ULL,
0x0000006f00c27306ULL, 0x000fe20000209400ULL, 0x0001000049497824ULL, 0x002fce00078e00ffULL,
0x0000006f00c57306ULL, 0x000e700000205400ULL, 0x0000006f00ab7306ULL, 0x0007f0000020d400ULL,
0x00000048009a7306ULL, 0x0008a2000000d400ULL, 0x00000018ff6f7819ULL, 0x008fc40000011449ULL,
0x000000c5c200720bULL, 0x002fca0003f7d000ULL, 0x0000006f00cb7306ULL, 0x000fe20000209400ULL,
0x0001000048487824ULL, 0x010fce00078e00ffULL, 0x0000006f00c87306ULL, 0x000e620000205400ULL,
0x000000019a9a0812ULL, 0x004fe400078efcffULL, 0x00000001abab3812ULL, 0x000fe400078efcffULL,
0x0000007ec100720bULL, 0x000fc60003f7d000ULL, 0x0000003d00bc7306ULL, 0x000ff00000209400ULL,
0x0000003d00a77306ULL, 0x000ea20000205400ULL, 0x000000c8cb00720bULL, 0x002fe40003f1d000ULL,
0x0000000198983812ULL, 0x000fca00078efcffULL, 0x0000003d00957306ULL, 0x0003f0000020d400ULL,
0x0000006f00497306ULL, 0x000722000020d400ULL, 0x00000018ff3d7819ULL, 0x002fe4000001144cULL,
0x000000a7bc00720bULL, 0x004fca0003f9d000ULL, 0x0000004b00b97306ULL, 0x000fe20000009400ULL,
0x000001004c6f7824ULL, 0x008fca00078e00ffULL, 0x00000018ff6f7819ULL, 0x000fe4000001146fULL,
0x0000004b00887306ULL, 0x000e620000005400ULL, 0x0000000149490812ULL, 0x010fe400078efcffULL,
0x0000000195954812ULL, 0x000fca00078efcffULL, 0x0000007400c67306ULL, 0x000ff00000209400ULL,
0x0000007400c97306ULL, 0x000ea20000205400ULL, 0x00000088b900720bULL, 0x002fce0003f1d000ULL,
0x0000005000be7306ULL, 0x000ff00000209400ULL, 0x0000005000bf7306ULL, 0x000fe20000205400ULL,
0x000000c9c600720bULL, 0x004fce0003fdd000ULL, 0x0000005000947306ULL, 0x000ff0000020d400ULL,
0x0000005b00b17306ULL, 0x000ff00000209400ULL, 0x0000005b00b07306ULL, 0x000ff00000205400ULL,
0x0000005b00507306ULL, 0x0003f0000020d400ULL, 0x0000003d00b37306ULL, 0x000fe20000209400ULL,
0x00000018ff5b7819ULL, 0x002fce0000011441ULL, 0x0000003d00b27306ULL, 0x000ff00000205400ULL,
0x0000003d007c7306ULL, 0x0003f0000020d400ULL, 0x0000005b00977306ULL, 0x000fe20000209400ULL,
0x00000018ff3d7819ULL, 0x002fce0000011440ULL, 0x0000003d00a17306ULL, 0x000ff00000209400ULL,
0x0000003d009e7306ULL, 0x000ff00000205400ULL, 0x0000003d006c7306ULL, 0x0003f0000020d400ULL,
0x0000005b00967306ULL, 0x000fe20000205400ULL, 0x00000018ff3d7819ULL, 0x002fce0000011444ULL,
0x0000005b00697306ULL, 0x000ff0000020d400ULL, 0x00000073006a7306ULL, 0x000ff00000209400ULL,
0x00000073006b7306ULL, 0x000ff00000205400ULL, 0x00000073005b7306ULL, 0x0003f0000020d400ULL,
0x0000005600b87306ULL, 0x000fe20000209400ULL, 0x00000018ff737819ULL, 0x002fce0000011448ULL,
0x0000005600b77306ULL, 0x000ff00000205400ULL, 0x0000005600897306ULL, 0x000ff0000020d400ULL,
0x0000004b008d7306ULL, 0x000e70000000d400ULL, 0x0000005d00a57306ULL, 0x000ff00000209400ULL,
0x0000005d009c7306ULL, 0x000fe20000205400ULL, 0x000000018d8d0812ULL, 0x002fce00078efcffULL,
0x0000005d00567306ULL, 0x000ff0000020d400ULL, 0x0000007400a97306ULL, 0x000e70000020d400ULL,
0x0000004a00bd7306ULL, 0x000ff00000009400ULL, 0x0000004a00aa7306ULL, 0x000ea20000005400ULL,
0x00000001a9a96812ULL, 0x002fce00078efcffULL, 0x0000003d006d7306ULL, 0x000ff00000209400ULL,
0x0000003d006e7306ULL, 0x000fe20000205400ULL, 0x000000aabd00720bULL, 0x004fce0003fdd000ULL,
0x0000003d005d7306ULL, 0x000ff0000020d400ULL, 0x0000007300c47306ULL, 0x000ff00000209400ULL,
0x0000007300c77306ULL, 0x000e700000205400ULL, 0x0000006f00d57306ULL, 0x000ff00000209400ULL,
0x0000006f00d27306ULL, 0x000ea20000205400ULL, 0x000000c7c400720bULL, 0x002fce0003fbd000ULL,
0x0000007500627306ULL, 0x000ff00000209400ULL, 0x0000007500637306ULL, 0x000fe20000205400ULL,
0x000000d2d500720bULL, 0x004fce0003f1d000ULL, 0x00000075003d7306ULL, 0x0003f0000020d400ULL,
0x0000007300487306ULL, 0x0004e2000020d400ULL, 0x000001004a757824ULL, 0x002fca00078e00ffULL,
0x00000018ff757819ULL, 0x000fe40000011475ULL, 0x0000004a008f7306ULL, 0x000e62000000d400ULL,
0x000001004b737824ULL, 0x044fe400078e00ffULL, 0x000100004b4b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff747819ULL, 0x000fe20000011473ULL, 0x000100004a737824ULL, 0x000fe200078e00ffULL,
0x00000018ff4b7819ULL, 0x000fe2000001144bULL, 0x0000007500cd7306ULL, 0x000fe20000209400ULL,
0x0000000148485812ULL, 0x008fe400078efcffULL, 0x00000018ff737819ULL, 0x000fe40000011473ULL,
0x000000bfbe00720bULL, 0x000fe40003fbd000ULL, 0x000000018f8f6812ULL, 0x002fe200078efcffULL,
0x0000007500ca7306ULL, 0x000e620000205400ULL, 0x000000489548723eULL, 0x000fce00000010ffULL,
0x0000006f00867306ULL, 0x0004e4000020d400ULL, 0x0000000194945812ULL, 0x000fc800078efcffULL,
0x000000499449723eULL, 0x000fe400000010ffULL, 0x0000004b00d07306ULL, 0x000fe20000209400ULL,
0x000000cacd00720bULL, 0x002fe20003f9d000ULL, 0x000001004e6f7824ULL, 0x004fca00078e00ffULL,
0x00000018ff6f7819ULL, 0x000fe2000001146fULL, 0x0000004b00d37306ULL, 0x000e620000205400ULL,
0x0000000186860812ULL, 0x008fe400078efcffULL, 0x000000b2b300720bULL, 0x000fca0003f1d000ULL,
0x0000007500927306ULL, 0x000eb0000020d400ULL, 0x0000007400cf7306ULL, 0x000fe20000209400ULL,
0x000000d3d000720bULL, 0x002fe40003fdd000ULL, 0x000000017c7c0812ULL, 0x000fca00078efcffULL,
0x0000007400cc7306ULL, 0x000e620000205400ULL, 0x0000000192924812ULL, 0x004fe400078efcffULL,
0x000000b7b800720bULL, 0x000fca0003f9d000ULL, 0x0000004b008c7306ULL, 0x0004f0000020d400ULL,
0x0000004d00997306ULL, 0x000fe20000009400ULL, 0x000100004d4b7824ULL, 0x004fe200078e00ffULL,
0x000000cccf00720bULL, 0x002fc40003f7d000ULL, 0x0000000189894812ULL, 0x000fe400078efcffULL,
0x00000018ff4b7819ULL, 0x000fe4000001144bULL, 0x0000004d00b47306ULL, 0x000e620000005400ULL,
0x000000018c8c6812ULL, 0x008fce00078efcffULL, 0x0000004f00ac7306ULL, 0x000ff00000009400ULL,
0x0000004f00ad7306ULL, 0x000ea20000005400ULL, 0x000000b49900720bULL, 0x002fce0003fdd000ULL,
0x0000007300d17306ULL, 0x000ff00000209400ULL, 0x0000007300ce7306ULL, 0x000e620000205400ULL,
0x000000adac00720bULL, 0x004fe20003f1d000ULL, 0x0000010047ac7824ULL, 0x000fca00078e00ffULL,
0x00000018ffac7819ULL, 0x000fe200000114acULL, 0x00000074004a7306ULL, 0x0004f0000020d400ULL,
0x0000004d00847306ULL, 0x000f22000000d400ULL, 0x000001004d747824ULL, 0x004fe200078e00ffULL,
0x000000ced100720bULL, 0x002fc80003fbd000ULL, 0x00000018ff747819ULL, 0x000fe40000011474ULL,
0x0000004f00557306ULL, 0x000e62000000d400ULL, 0x000000014a4a3812ULL, 0x008fe400078efcffULL,
0x000000bbba00720bULL, 0x000fca0003f7d000ULL, 0x0000007400d77306ULL, 0x000fe20000209400ULL,
0x0000000184846812ULL, 0x010fce00078efcffULL, 0x0000007400d47306ULL, 0x000ea20000205400ULL,
0x0000000155550812ULL, 0x002fe400078efcffULL, 0x000000a6a300720bULL, 0x000fe20003f1d000ULL,
0x0001000046a67824ULL, 0x000fe200078e00ffULL, 0x0000000187873812ULL, 0x000fc600078efcffULL,
0x00000073008e7306ULL, 0x0002e2000020d400ULL, 0x00000018ffa67819ULL, 0x000fce00000114a6ULL,
0x0000004c00b67306ULL, 0x000fe20000009400ULL, 0x000001004f737824ULL, 0x002fe200078e00ffULL,
0x000000d4d700720bULL, 0x004fe20003f9d000ULL, 0x000100004f4f7824ULL, 0x000fe200078e00ffULL,
0x0000000170700812ULL, 0x000fe400078efcffULL, 0x00000018ff737819ULL, 0x000fe40000011473ULL,
0x0000004c00b57306ULL, 0x000e620000005400ULL, 0x000000018e8e5812ULL, 0x008fe400078efcffULL,
0x00000018ff4f7819ULL, 0x000fc4000001144fULL, 0x0000008e898e723eULL, 0x000fc600000010ffULL,
0x0000004c00837306ULL, 0x0004f0000000d400ULL, 0x0000004e00ae7306ULL, 0x000fe20000009400ULL,
0x000100004c4c7824ULL, 0x004fe200078e00ffULL, 0x000000b5b600720bULL, 0x002fc80003fbd000ULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x0000004e00af7306ULL, 0x000e6e0000005400ULL,
0x0000000183835812ULL, 0x008fe200078efcffULL, 0x0000004b00dd7306ULL, 0x000ff00000209400ULL,
0x0000004b00da7306ULL, 0x000ea20000205400ULL, 0x000000afae00720bULL, 0x002fce0003fdd000ULL,
0x0000004b007f7306ULL, 0x0002f0000020d400ULL, 0x00000040009f7306ULL, 0x000fe20000009400ULL,
0x00000100404b7824ULL, 0x002fe200078e00ffULL, 0x000000dadd00720bULL, 0x004fc80003fbd000ULL,
0x00000018ff4b7819ULL, 0x000fe4000001144bULL, 0x0000004000a27306ULL, 0x000fee0000005400ULL,
0x000000017f7f5812ULL, 0x008fe200078efcffULL, 0x0000004000727306ULL, 0x0003f0000000d400ULL,
0x0000007400857306ULL, 0x000ea2000020d400ULL, 0x0001000040407824ULL, 0x002fca00078e00ffULL,
0x00000018ff407819ULL, 0x000fe40000011440ULL, 0x0000004c00d67306ULL, 0x000ff00000209400ULL,
0x0000004c00d97306ULL, 0x000e620000205400ULL, 0x0000000185854812ULL, 0x004fc400078efcffULL,
0x000000b0b100720bULL, 0x000fca0003f9d000ULL, 0x0000004b00e27306ULL, 0x000ff00000209400ULL,
0x0000004b00e57306ULL, 0x000fe20000205400ULL, 0x000000d9d600720bULL, 0x002fe40003f7d000ULL,
0x0000000150504812ULL, 0x000fca00078efcffULL, 0x0000004b00797306ULL, 0x0003f0000020d400ULL,
0x0000004e00537306ULL, 0x0004e2000000d400ULL, 0x00000100424b7824ULL, 0x002fce00078e00ffULL,
0x0000004000e47306ULL, 0x000fe20000209400ULL, 0x000100004e4e7824ULL, 0x004fca00078e00ffULL,
0x00000018ff4e7819ULL, 0x000fe4000001144eULL, 0x0000004000e77306ULL, 0x000e620000205400ULL,
0x0000000153536812ULL, 0x008fe400078efcffULL, 0x0000009ca500720bULL, 0x000fe20003fdd000ULL,
0x0000010046a57824ULL, 0x000fc800078e00ffULL, 0x0000004000757306ULL, 0x0005e2000020d400ULL,
0x00000018ffa57819ULL, 0x000fce00000114a5ULL, 0x0000004c004d7306ULL, 0x000722000020d400ULL,
0x00000018ff407819ULL, 0x004fe4000001144bULL, 0x000000e7e400720bULL, 0x002fe40003f1d000ULL,
0x0000000156566812ULL, 0x000fc600078efcffULL, 0x0000007300de7306ULL, 0x000fe20000209400ULL,
0x00000100414c7824ULL, 0x008fca00078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe4000001144cULL,
0x0000007300e17306ULL, 0x000e620000205400ULL, 0x000000014d4d3812ULL, 0x010fe400078efcffULL,
0x0000000175750812ULL, 0x000fe400078efcffULL, 0x000000969700720bULL, 0x000fc60003f1d000ULL,
0x0000007300787306ULL, 0x000eb0000020d400ULL, 0x0000004100a07306ULL, 0x000fe20000009400ULL,
0x000000e1de00720bULL, 0x002fe40003fbd000ULL, 0x0000000169690812ULL, 0x000fca00078efcffULL,
0x00000041009b7306ULL, 0x000e6c0000005400ULL, 0x0000000178785812ULL, 0x004fe400078efcffULL,
0x0000004100717306ULL, 0x0004f0000000d400ULL, 0x00000040004b7306ULL, 0x000fe20000209400ULL,
0x0001000041417824ULL, 0x004fe200078e00ffULL, 0x0000009ba000720bULL, 0x002fc80003fdd000ULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x0000004000a87306ULL, 0x000e6e0000205400ULL,
0x0000000171716812ULL, 0x008fe200078efcffULL, 0x0000004000737306ULL, 0x0004f0000020d400ULL,
0x0000006f00e07306ULL, 0x000fe20000209400ULL, 0x0000010044407824ULL, 0x004fe200078e00ffULL,
0x000000a84b00720bULL, 0x002fc80003fdd000ULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x0000006f00e37306ULL, 0x000e6e0000205400ULL, 0x0000000173736812ULL, 0x008fe200078efcffULL,
0x0000004e00db7306ULL, 0x000fe20000209400ULL, 0x000000818200720bULL, 0x000fc40003fdd000ULL,
0x000000557881723eULL, 0x000fca00000010ffULL, 0x0000004e00d87306ULL, 0x000ea20000205400ULL,
0x000000e3e000720bULL, 0x002fca0003f7d000ULL, 0x0000000167676812ULL, 0x000fe400078efcffULL,
0x0000004e007d7306ULL, 0x0002f0000020d400ULL, 0x0000004200a47306ULL, 0x000fe20000009400ULL,
0x00000100434e7824ULL, 0x002fe200078e00ffULL, 0x000000d8db00720bULL, 0x004fc80003f9d000ULL,
0x00000018ffea7819ULL, 0x000fe4000001144eULL, 0x00000042009d7306ULL, 0x000fee0000005400ULL,
0x000000017d7d4812ULL, 0x008fe200078efcffULL, 0x0000004200687306ULL, 0x0003e2000000d400ULL,
0x000000e5e200720bULL, 0x000fce0003f9d000ULL, 0x0000004300917306ULL, 0x000fe20000009400ULL,
0x0001000042427824ULL, 0x002fca00078e00ffULL, 0x00000018ff427819ULL, 0x000fe40000011442ULL,
0x0000004300907306ULL, 0x000fe20000005400ULL, 0x0000000179794812ULL, 0x000fe400078efcffULL,
0x0000009ea100720bULL, 0x000fca0003f9d000ULL, 0x0000004300647306ULL, 0x0003f0000000d400ULL,
0x0000004100e87306ULL, 0x000fe20000209400ULL, 0x0001000043437824ULL, 0x002fe200078e00ffULL,
0x000000016c6c4812ULL, 0x000fc800078efcffULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0x0000004100eb7306ULL, 0x000e700000205400ULL, 0x0000004100747306ULL, 0x0004f0000020d400ULL,
0x0000004000b77306ULL, 0x000fe20000209400ULL, 0x0000010045417824ULL, 0x004fe200078e00ffULL,
0x000000ebe800720bULL, 0x002fc80003f9d000ULL, 0x00000018ffb37819ULL, 0x000fe40000011441ULL,
0x0000004000b67306ULL, 0x000e6e0000205400ULL, 0x0000000174744812ULL, 0x008fe200078efcffULL,
0x0000004000997306ULL, 0x0005f0000020d400ULL, 0x0000006f00807306ULL, 0x000ee2000020d400ULL,
0x0001280034407811ULL, 0x004fc400078e20ffULL, 0x000000b6b700720bULL, 0x002fca0003fdd000ULL,
0x0000004f00dc7306ULL, 0x000ff00000209400ULL, 0x0000004f00df7306ULL, 0x000e620000205400ULL,
0x0000000180803812ULL, 0x008fe400078efcffULL, 0x000000a29f00720bULL, 0x000fe20003f7d000ULL,
0x00010000479f7824ULL, 0x000fe200078e00ffULL, 0x0000000199996812ULL, 0x000fc400078efcffULL,
0x000000538080723eULL, 0x000fe200000010ffULL, 0x0000004f00777306ULL, 0x000ea2000020d400ULL,
0x00000018ff9f7819ULL, 0x000fce000001149fULL, 0x0000004c00e97306ULL, 0x000fe20000209400ULL,
0x000000dfdc00720bULL, 0x002fe40003fbd000ULL, 0x0000000172723812ULL, 0x000fca00078efcffULL,
0x0000004c00e67306ULL, 0x000e6c0000205400ULL, 0x0000000177775812ULL, 0x004fe400078efcffULL,
0x0000004c00767306ULL, 0x000ea2000020d400ULL, 0x0000009da400720bULL, 0x000fce0003fbd000ULL,
0x00000042004c7306ULL, 0x000fe20000209400ULL, 0x000000e6e900720bULL, 0x002fca0003f7d000ULL,
0x0000000168685812ULL, 0x000fe400078efcffULL, 0x00000042004f7306ULL, 0x000e6c0000205400ULL,
0x0000000176763812ULL, 0x004fe400078efcffULL, 0x00000042007e7306ULL, 0x000ea2000020d400ULL,
0x000000909100720bULL, 0x000fce0003f7d000ULL, 0x0000004300a77306ULL, 0x000fe20000209400ULL,
0x0000004f4c00720bULL, 0x002fe40003fbd000ULL, 0x00000084854f723eULL, 0x000fc600000010ffULL,
0x0000000164643812ULL, 0x000fe400078efcffULL, 0x0000004300aa7306ULL, 0x000e6c0000205400ULL,
0x000000017e7e5812ULL, 0x004fe400078efcffULL, 0x0000004300887306ULL, 0x0004f0000020d400ULL,
0x000000ea004e7306ULL, 0x000fe20000209400ULL, 0x000000004040783bULL, 0x004ea20000000200ULL,
0x000000aaa700720bULL, 0x002fcc0003f7d000ULL, 0x000000ea00937306ULL, 0x000e6e0000205400ULL,
0x0000000188883812ULL, 0x008fe200078efcffULL, 0x000000ea006f7306ULL, 0x000ee2000020d400ULL,
0x000000934e00720bULL, 0x002fce0003f1d000ULL, 0x00000044008b7306ULL, 0x000fe20000009400ULL,
0x00000083864e723eULL, 0x000fce00000010ffULL, 0x00000044008a7306ULL, 0x000e620000005400ULL,
0x000000016f6f0812ULL, 0x008fe400078efcffULL, 0x0000007a7b00720bULL, 0x000fca0003f1d000ULL,
0x00000044005e7306ULL, 0x000722000000d400ULL, 0x000000234040a231ULL, 0x084fe400003400ffULL,
0x000000234242a231ULL, 0x000fe400003400ffULL, 0x000000224141a231ULL, 0x080fe400003400ffULL,
0x000000224343a231ULL, 0x000fe200003400ffULL, 0x000000b300b27306ULL, 0x000fe20000209400ULL,
0x0001000044447824ULL, 0x008fe200078e00ffULL, 0x0000008a8b00720bULL, 0x002fc40003f9d000ULL,
0x000000015f5f0812ULL, 0x000fe400078efcffULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x000000b300af7306ULL, 0x000e6e0000205400ULL, 0x000000015e5e4812ULL, 0x010fe200078efcffULL,
0x0000004500517306ULL, 0x000fe20000009400ULL, 0x0000006e6d00720bULL, 0x000fc40003f9d000ULL,
0x0000005e995e723eULL, 0x000fca00000010ffULL, 0x0000004500527306ULL, 0x000ea20000005400ULL,
0x000000afb200720bULL, 0x002fca0003f1d000ULL, 0x000000015d5d4812ULL, 0x000fe400078efcffULL,
0x00000045005c7306ULL, 0x0002f0000000d400ULL, 0x0000004400a27306ULL, 0x000fe20000209400ULL,
0x0001000045457824ULL, 0x002fe200078e00ffULL, 0x000000525100720bULL, 0x004fc80003fbd000ULL,
0x00000018ff9b7819ULL, 0x000fe40000011445ULL, 0x0000004400a37306ULL, 0x000e620000205400ULL,
0x00000098a945723eULL, 0x000fcc00000010ffULL, 0x000000015c5c5812ULL, 0x008fe200078efcffULL,
0x00000044009c7306ULL, 0x0005e2000020d400ULL, 0x0000006b6a00720bULL, 0x000fce0003fbd000ULL,
0x000000b300ad7306ULL, 0x000ee2000020d400ULL, 0x0000009aab44723eULL, 0x004fe400000010ffULL,
0x000000a3a200720bULL, 0x002fc60003fdd000ULL, 0x000000015b5b5812ULL, 0x000fe400078efcffULL,
0x0000009b009d7306ULL, 0x000fe20000209400ULL, 0x000000616000720bULL, 0x000fce0003fbd000ULL,
0x0000009b00987306ULL, 0x000e620000205400ULL, 0x00000001adad0812ULL, 0x008fe400078efcffULL,
0x000000019c9c6812ULL, 0x000fc600078efcffULL, 0x0000000159595812ULL, 0x000fe400078efcffULL,
0x0000004600547306ULL, 0x000ff00000009400ULL, 0x0000004600577306ULL, 0x000ea20000005400ULL,
0x000000989d00720bULL, 0x002fce0003f1d000ULL, 0x00000046005a7306ULL, 0x000e70000000d400ULL,
0x0000004700657306ULL, 0x000fe20000009400ULL, 0x000000575400720bULL, 0x004fce0003f7d000ULL,
0x0000004700667306ULL, 0x000eac0000005400ULL, 0x000000015a5a3812ULL, 0x002fe400078efcffULL,
0x0000004700587306ULL, 0x0003f0000000d400ULL, 0x0000009b00947306ULL, 0x000ee2000020d400ULL,
0x000000444044723cULL, 0x002be2000004181cULL, 0x000000666500720bULL, 0x004fcc0003f9d000ULL,
0x0000008f921c723eULL, 0x020fe200000010ffULL, 0x000000a5008a7306ULL, 0x000fe20000205400ULL,
0x0000008d4a1d723eULL, 0x000fe400000010ffULL, 0x00012800351e7811ULL, 0x000fe200078e20ffULL,
0x000000484048723cULL, 0x000be20000041818ULL, 0x0000008c878f723eULL, 0x000fe400000010ffULL,
0x0000000194940812ULL, 0x008fe200078efcffULL, 0x000000a5008d7306ULL, 0x000e620000209400ULL,
0x0000000158584812ULL, 0x000fc400078efcffULL, 0x0000004d7c18723eULL, 0x020fe200000010ffULL,
0x0000001c4014723cULL, 0x040b620000041814ULL, 0x0000007f5019723eULL, 0x000fe200000010ffULL,
0x000000001e1c783bULL, 0x020ea40000000200ULL, 0x000000ac007a7306ULL, 0x000fe80000209400ULL,
0x0000004e404c723cULL, 0x000be8000004180cULL, 0x000000ac000d7306ULL, 0x020ee20000205400ULL,
0x0000008a8d00720bULL, 0x002fc40003fdd000ULL, 0x0000007e670c723eULL, 0x000fe200000010ffULL,
0x000000184050723cULL, 0x040be80000041808ULL, 0x000000a500837306ULL, 0x000e66000020d400ULL,
0x0000007d5608723eULL, 0x020fe200000010ffULL, 0x0000008e4010723cULL, 0x000f620000041810ULL,
0x000000777009723eULL, 0x000fc400000010ffULL, 0x000000727918723eULL, 0x000fe200000010ffULL,
0x000000ac007b7306ULL, 0x000f22000020d400ULL, 0x0000000d7a00720bULL, 0x008fe40003f1d000ULL,
0x000000885f0d723eULL, 0x000fe200000010ffULL, 0x000000804054723cULL, 0x000b620000041804ULL,
0x000000717619723eULL, 0x000fe400000010ffULL, 0x0000005cad5f723eULL, 0x000fe200000010ffULL,
0x000000a600707306ULL, 0x000fe20000209400ULL, 0x0000000183836812ULL, 0x002fc400078efcffULL,
0x000000636200720bULL, 0x000fe20003fdd000ULL, 0x000000084030723cULL, 0x000b640000041830ULL,
0x000000756c04723eULL, 0x020fe200000010ffULL, 0x000000231c1ca231ULL, 0x084fe200003400ffULL,
0x000000746905723eULL, 0x000fe200000010ffULL, 0x000000a600417306ULL, 0x000e620000205400ULL,
0x000000017b7b0812ULL, 0x010fe200078efcffULL, 0x000000231e1ea231ULL, 0x000fe200003400ffULL,
0x000000687308723eULL, 0x000fe200000010ffULL, 0x000000221d1da231ULL, 0x080fe200003400ffULL,
0x000000646f09723eULL, 0x000fe200000010ffULL, 0x000000221f1fa231ULL, 0x000fe200003400ffULL,
0x0000005a835a723eULL, 0x000fe200000010ffULL, 0x0000009f00407306ULL, 0x000fe20000209400ULL,
0x000000013d3d6812ULL, 0x000fc800078efcffULL, 0x000000081c08723cULL, 0x000b660000041814ULL,
0x0000009f00437306ULL, 0x000ea20000205400ULL, 0x000000417000720bULL, 0x002fc60003f7d000ULL,
0x000000945b15723eULL, 0x020fe200000010ffULL, 0x0000000c1c0c723cULL, 0x000b620000041810ULL,
0x0000009c5d14723eULL, 0x000fe400000010ffULL, 0x000000a600a67306ULL, 0x000e62000020d400ULL,
0x000000587b5b723eULL, 0x000fc800000010ffULL, 0x000000181c18723cULL, 0x000b660000041844ULL,
0x0000009f00427306ULL, 0x000ee2000020d400ULL, 0x000000434000720bULL, 0x004fc80003f1d000ULL,
0x000000041c04723cULL, 0x000b620000041848ULL, 0x00000001a6a63812ULL, 0x002fc800078efcffULL,
0x000000a659a6723eULL, 0x000fc600000010ffULL, 0x0000005e1c10723cULL, 0x000b62000004184cULL,
0x0000000142420812ULL, 0x008fc800078efcffULL, 0x000000423da7723eULL, 0x000fc600000010ffULL,
0x000000141c14723cULL, 0x040b700000041850ULL, 0x0000005a1c54723cULL, 0x040b700000041854ULL,
0x000000a61c1c723cULL, 0x000b620000041830ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0186b800ff407f8cULL, 0x000e62000c80043fULL, 0x000000ffff427224ULL, 0x000fce00078e00ffULL,
0x0000000000307805ULL, 0x020fc40000015200ULL, 0x0186bc00ff337984ULL, 0x000ea40000000800ULL,
0x8000000033ff7812ULL, 0x006fc40007804841ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x000fcc0000015200ULL, 0x00000032303d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000133337824ULL, 0x000fe200000e0e31ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff327819ULL, 0x000fc80000011433ULL,
0x0000003d32327211ULL, 0x000fca00078110ffULL, 0x000000ffff337224ULL, 0x000fca00000e0633ULL,
0x0000000232327819ULL, 0x000fc80000001233ULL, 0x000000320000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000142427810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0186bc00ff337984ULL, 0x000e640000000800ULL,
0x8000000033ff7812ULL, 0x002fe40007804841ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000006027337810ULL, 0x000fca0007ffe0ffULL, 0x000062002a407a24ULL, 0x000fe200078e0233ULL,
0x0000039000009947ULL, 0x000fea0003800000ULL, 0x000000012c317824ULL, 0x000fe200078e0221ULL,
0x000000332d307217ULL, 0x000fe20007800000ULL, 0x00000100ff417424ULL, 0x000fe200078e00ffULL,
0x0000000221477810ULL, 0x000fe20007ffe0ffULL, 0x0000000131327824ULL, 0x000fe200078e022fULL,
0x0000000421497810ULL, 0x000fe20007ffe0ffULL, 0x0000001031457824ULL, 0x040fe200078e00ffULL,
0x000000f0263d7812ULL, 0x000fe200078ec0ffULL, 0x0000000130337824ULL, 0x000fe400078e0a33ULL,
0x0000000131307824ULL, 0x000fe200078e0240ULL, 0xfffffff045457812ULL, 0x000fe200078ee232ULL,
0x000000012c327824ULL, 0x040fe200078e0247ULL, 0x000000332c337217ULL, 0x000fe20007800000ULL,
0x00005e0030307625ULL, 0x000fe200078e0041ULL, 0x0001400045457811ULL, 0x000fc600078e20ffULL,
0x0000000132427824ULL, 0x040fe400078e022fULL, 0x00000010324b7824ULL, 0x000fe400078e00ffULL,
0x000000012c437824ULL, 0x000fc600078e0249ULL, 0xfffffff04b467812ULL, 0x000fe200078ee242ULL,
0x0000000143447824ULL, 0x040fe200078e022fULL, 0x0000003d30427210ULL, 0x000fe20007f1e0ffULL,
0x00000010434d7824ULL, 0x000fe200078e00ffULL, 0x00000006214b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000132307824ULL, 0x100fe400078e0240ULL, 0x0000000143327824ULL, 0x000fe200078e0240ULL,
0xfffffff04d487812ULL, 0x000fe200078ee244ULL, 0x000000ffff437224ULL, 0x000fe400000e0631ULL,
0x00005e0030307625ULL, 0x000fc800078e0041ULL, 0x000000012c4a7824ULL, 0x000fe200078e024bULL,
0x0000003d30307210ULL, 0x000fe20007fbe0ffULL, 0x0000000133447824ULL, 0x000fe400078e0a2cULL,
0x00005e0032327625ULL, 0x000fc600078e0041ULL, 0x000000444700720cULL, 0x080fe20003f66070ULL,
0x000000014a407824ULL, 0x000fe200078e0240ULL, 0x0000003d32327210ULL, 0x000fe20007fde0ffULL,
0x000000014a477824ULL, 0x000fe200078e022fULL, 0x000000442100720cULL, 0x080fe20003f86070ULL,
0x00005e0040407625ULL, 0x000fe200078e0041ULL, 0x000000444900720cULL, 0x000fc60003f06070ULL,
0x000000ffff317224ULL, 0x000fe200028e0631ULL, 0x000000444b00720cULL, 0x000fe20003fa6070ULL,
0x000000104a4a7824ULL, 0x000fe400078e00ffULL, 0x000000ffff337224ULL, 0x000fe200030e0633ULL,
0x0000003d40407210ULL, 0x000fe40007fde0ffULL, 0xfffffff04a447812ULL, 0x000fe200078ee247ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000042457faeULL, 0x0003e2000e101c46ULL,
0x00014000463d7811ULL, 0x000fe200078e20ffULL, 0x000000ffff417224ULL, 0x000fe200030e0641ULL,
0x0001400048477811ULL, 0x000fc400078e20ffULL, 0x0001400044497811ULL, 0x000fe200078e20ffULL,
0x00000000303d7faeULL, 0x0003e8000d901c46ULL, 0x0000000032477faeULL, 0x0003e8000c101c46ULL,
0x0000000040497faeULL, 0x0003e2000e901c46ULL, 0x000002d000007947ULL, 0x000fea0003800000ULL,
0x000000012c307824ULL, 0x000fe400078e0221ULL, 0x00000100ff417424ULL, 0x000fc400078e00ffULL,
0x0000000130317824ULL, 0x040fe200078e022fULL, 0x0000000230327810ULL, 0x040fe20007ffe0ffULL,
0x0000001030447824ULL, 0x040fe200078e00ffULL, 0x0000000430437810ULL, 0x000fc60007ffe0ffULL,
0x0000000132337824ULL, 0x000fe200078e022fULL, 0xfffffff044447812ULL, 0x000fe200078ee231ULL,
0x0000001032427824ULL, 0x000fe200078e00ffULL, 0x0000000630317810ULL, 0x000fe20007ffe0ffULL,
0x00000001433d7824ULL, 0x040fe400078e022fULL, 0x0000001043467824ULL, 0x040fe200078e00ffULL,
0xfffffff042457812ULL, 0x000fe200078ee233ULL, 0x0000000130427824ULL, 0x100fe400078e0240ULL,
0x0000000132307824ULL, 0x100fe200078e0240ULL, 0xfffffff046467812ULL, 0x000fe200078ee23dULL,
0x0000000143327824ULL, 0x000fe200078e0240ULL, 0x000000f0263d7812ULL, 0x000fe200078ec0ffULL,
0x00005e0042427625ULL, 0x000fe200078e0041ULL, 0x0001400045457811ULL, 0x000fc600078e20ffULL,
0x0000000131407824ULL, 0x040fe200078e0240ULL, 0x0000003d42427210ULL, 0x000fe20007f7e0ffULL,
0x0000000131477824ULL, 0x040fe400078e022fULL, 0x0000001031487824ULL, 0x000fe400078e00ffULL,
0x00005e0030307625ULL, 0x000fc600078e0041ULL, 0xfffffff048487812ULL, 0x000fe200078ee247ULL,
0x00005e0032327625ULL, 0x000fe200078e0041ULL, 0x0000003d30307210ULL, 0x000fe40007f1e0ffULL,
0x0001400046477811ULL, 0x000fe200078e20ffULL, 0x00005e0040407625ULL, 0x000fe200078e0041ULL,
0x0001400048497811ULL, 0x000fc600078e20ffULL, 0x000000ffff437224ULL, 0x000fe200018e0643ULL,
0x0000003d32327210ULL, 0x080fe20007f7e0ffULL, 0x000000ffff317224ULL, 0x000fe200000e0631ULL,
0x0000003d40407210ULL, 0x000fe40007f9e0ffULL, 0x00014000443d7811ULL, 0x000fe200078e20ffULL,
0x000000ffff337224ULL, 0x000fe400018e0633ULL, 0x000000ffff417224ULL, 0x000fe400020e0641ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000423d7faeULL, 0x0003e8000b901c46ULL,
0x0000000030457faeULL, 0x0003e8000b901c46ULL, 0x0000000032477faeULL, 0x0003e8000b901c46ULL,
0x0000000040497faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0186a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0186a800ff307f8cULL, 0x000e64000c80043fULL,
0x000000ffff3d7224ULL, 0x002fc400078e0031ULL, 0x0000000000307805ULL, 0x000fca0000015200ULL,
0x0186b400ff337984ULL, 0x000e640000000800ULL, 0x8000000033ff7812ULL, 0x002fc4000780483fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff407224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x000fcc0000015200ULL, 0x0000003230417210ULL, 0x000fca0007f1e1ffULL,
0x0000000133337824ULL, 0x000fe200000e0e31ULL, 0x003d09004100780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404100780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff327819ULL, 0x000fc80000011433ULL,
0x0000004132327211ULL, 0x000fca00078110ffULL, 0x000000ffff337224ULL, 0x000fca00000e0633ULL,
0x0000000232327819ULL, 0x000fc80000001233ULL, 0x000000320000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000140407810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0186b400ff337984ULL, 0x000e640000000800ULL,
0x8000000033ff7812ULL, 0x002fe4000780483fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000018000007945ULL, 0x000fe20003800000ULL, 0x0000016000002947ULL, 0x000fea0003800000ULL,
0x00000024ff22723eULL, 0x000fe400000010ffULL, 0x00000002ff317819ULL, 0x000fe4000001162fULL,
0x0000541022307816ULL, 0x000fe20000000022ULL, 0x00015d727f007947ULL, 0x000fea000b800000ULL,
0x00001f3130237589ULL, 0x0002a400000e0000ULL, 0x0000000831597810ULL, 0x002fe20007ffe0ffULL,
0x00015dc27f007947ULL, 0x000fea000b800000ULL, 0x00001f5930227589ULL, 0x0002e400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001031597810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff587224ULL, 0x000fe200078e0030ULL, 0x0000af3000407802ULL, 0x000fe20000000f00ULL,
0x0000001fff5a7424ULL, 0x000fc400078e00ffULL, 0xffffffffff5b7424ULL, 0x000fc400078e00ffULL,
0x00016a4000007944ULL, 0x00cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001831597810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff587224ULL, 0x004fe200078e0030ULL,
0x0000afa000407802ULL, 0x000fe20000000f00ULL, 0x0000001fff5a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff5b7424ULL, 0x000fc400078e00ffULL, 0x000169d000007944ULL, 0x008fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000003840783bULL, 0x000f280000004200ULL, 0x000000003948783bULL, 0x000fe80000004200ULL,
0x000000003630783bULL, 0x002e680000004200ULL, 0x000000003744783bULL, 0x000ee20000004200ULL,
0x00000018ff4e7819ULL, 0x010fe20000011441ULL, 0x0000004000cc7306ULL, 0x000fe20000009400ULL,
0x00000018ff4c7819ULL, 0x000fe20000011440ULL, 0x0000010040687824ULL, 0x000fe200078e00ffULL,
0x00000018ff507819ULL, 0x000fc40000011442ULL, 0x00000018ff527819ULL, 0x000fe40000011443ULL,
0x00000018ff597819ULL, 0x002fe20000011433ULL, 0x0000004e00c87306ULL, 0x000fe20000209400ULL,
0x00000018ff687819ULL, 0x000fe40000011468ULL, 0x00000018ff6f7819ULL, 0x008fe40000011446ULL,
0x00000018ff737819ULL, 0x000fe40000011447ULL, 0x00000018ff6c7819ULL, 0x000fe20000011445ULL,
0x0000004e00a97306ULL, 0x000ff00000205400ULL, 0x0000004e003f7306ULL, 0x0003f0000020d400ULL,
0x0000004c00c77306ULL, 0x000fe20000209400ULL, 0x00000018ff4e7819ULL, 0x002fce0000011449ULL,
0x0000004e00bb7306ULL, 0x000ff00000209400ULL, 0x0000004e00bc7306ULL, 0x000ff00000205400ULL,
0x0000004e00757306ULL, 0x0003f0000020d400ULL, 0x0000004c00967306ULL, 0x000ee20000205400ULL,
0x00000018ff4e7819ULL, 0x002fce0000011431ULL, 0x0000004e00917306ULL, 0x000ff00000209400ULL,
0x0000004e00907306ULL, 0x000fe20000205400ULL, 0x00000096c700720bULL, 0x008fce0003f9d000ULL,
0x0000004e00607306ULL, 0x000ff0000020d400ULL, 0x0000004c003e7306ULL, 0x0002f0000020d400ULL,
0x0000006f005d7306ULL, 0x000fe20000209400ULL, 0x00000018ff4c7819ULL, 0x002fce0000011448ULL,
0x0000006f005e7306ULL, 0x000fe20000205400ULL, 0x000000013e3e4812ULL, 0x008fce00078efcffULL,
0x0000006f004e7306ULL, 0x0003f0000020d400ULL, 0x0000004c00c07306ULL, 0x000fe20000209400ULL,
0x00000100416f7824ULL, 0x002fca00078e00ffULL, 0x00000018ff6f7819ULL, 0x000fe4000001146fULL,
0x0000004c00c17306ULL, 0x000ff00000205400ULL, 0x0000004c007f7306ULL, 0x0003f0000020d400ULL,
0x0000005000c27306ULL, 0x000fe20000209400ULL, 0x00000018ff4c7819ULL, 0x002fce0000011430ULL,
0x0000005000c57306ULL, 0x000ff00000205400ULL, 0x00000050008a7306ULL, 0x0003f0000020d400ULL,
0x0000005200c37306ULL, 0x000fe20000209400ULL, 0x00000018ff507819ULL, 0x002fce000001144aULL,
0x0000005200ba7306ULL, 0x000ff00000205400ULL, 0x0000005200847306ULL, 0x0003f0000020d400ULL,
0x0000004c00a07306ULL, 0x000fe20000209400ULL, 0x00000018ff527819ULL, 0x002fce000001144bULL,
0x0000004c00a37306ULL, 0x000ff00000205400ULL, 0x0000004c00647306ULL, 0x0003f0000020d400ULL,
0x0000006f00d07306ULL, 0x000fe20000209400ULL, 0x00000018ff4c7819ULL, 0x002fce0000011444ULL,
0x0000006f00cf7306ULL, 0x000e700000205400ULL, 0x0000005000b27306ULL, 0x000ff00000209400ULL,
0x0000005000ad7306ULL, 0x000fe20000205400ULL, 0x000000cfd000720bULL, 0x002fce0003f7d000ULL,
0x0000005000727306ULL, 0x0003f0000020d400ULL, 0x00000040006d7306ULL, 0x000ee20000005400ULL,
0x00000018ff507819ULL, 0x002fce0000011432ULL, 0x00000040009e7306ULL, 0x000330000000d400ULL,
0x0000005200af7306ULL, 0x000fe20000209400ULL, 0x0001000040407824ULL, 0x002fe200078e00ffULL,
0x0000006dcc00720bULL, 0x008fcc0003f1d000ULL, 0x0000005200b07306ULL, 0x000fee0000205400ULL,
0x000000019e9e0812ULL, 0x010fe200078efcffULL, 0x00000052006b7306ULL, 0x000ff0000020d400ULL,
0x0000005900767306ULL, 0x000ff00000209400ULL, 0x0000005900777306ULL, 0x000ff00000205400ULL,
0x0000005900587306ULL, 0x004ff0000020d400ULL, 0x0000004c00657306ULL, 0x000ff00000209400ULL,
0x0000004c00667306ULL, 0x000ff00000205400ULL, 0x0000004c00527306ULL, 0x000ff0000020d400ULL,
0x0000007300597306ULL, 0x000ff00000209400ULL, 0x00000073005a7306ULL, 0x000ff00000205400ULL,
0x00000073004c7306ULL, 0x0003f0000020d400ULL, 0x00000050007b7306ULL, 0x000fe20000209400ULL,
0x0000010042737824ULL, 0x002fca00078e00ffULL, 0x00000018ff737819ULL, 0x000fe40000011473ULL,
0x00000050007e7306ULL, 0x000ff00000205400ULL, 0x00000050005c7306ULL, 0x000ff0000020d400ULL,
0x0000006c00617306ULL, 0x000ff00000209400ULL, 0x0000006c00627306ULL, 0x000ff00000205400ULL,
0x0000006c00507306ULL, 0x0003f0000020d400ULL, 0x0000006800ce7306ULL, 0x000fe20000209400ULL,
0x00000018ff6c7819ULL, 0x002fce0000011440ULL, 0x0000006800cb7306ULL, 0x000e700000205400ULL,
0x0000006f00a87306ULL, 0x000eb0000020d400ULL, 0x0000004200c67306ULL, 0x000fe20000009400ULL,
0x000000cbce00720bULL, 0x002fce0003fdd000ULL, 0x0000004200877306ULL, 0x000e620000005400ULL,
0x00000001a8a83812ULL, 0x004fce00078efcffULL, 0x0000006c00cd7306ULL, 0x000ff00000209400ULL,
0x0000006c00407306ULL, 0x000ea20000205400ULL, 0x00000087c600720bULL, 0x002fce0003f7d000ULL,
0x0000004100ca7306ULL, 0x000ff00000009400ULL, 0x0000004100c97306ULL, 0x000fe20000005400ULL,
0x00000040cd00720bULL, 0x004fe40003fbd000ULL, 0x000128003a407811ULL, 0x000fca00078e20ffULL,
0x00000041009b7306ULL, 0x0003f0000000d400ULL, 0x0000006c009d7306ULL, 0x0004e2000020d400ULL,
0x0001000041417824ULL, 0x002fce00078e00ffULL, 0x0000007300d47306ULL, 0x000fe20000209400ULL,
0x00000100436c7824ULL, 0x004fca00078e00ffULL, 0x00000018ff6c7819ULL, 0x000fe4000001146cULL,
0x0000007300d17306ULL, 0x000e620000205400ULL, 0x000000019d9d5812ULL, 0x008fe400078efcffULL,
0x000000a9c800720bULL, 0x000fe40003fbd000ULL, 0x0000009d3e3e723eULL, 0x000fc600000010ffULL,
0x0000004300c47306ULL, 0x000ff00000009400ULL, 0x0000004300b37306ULL, 0x000fe20000005400ULL,
0x000000d1d400720bULL, 0x002fe40003f9d000ULL, 0x000000013f3f5812ULL, 0x000fca00078efcffULL,
0x00000043008e7306ULL, 0x0003f0000000d400ULL, 0x0000006800a57306ULL, 0x0004e2000020d400ULL,
0x0001000043437824ULL, 0x002fca00078e00ffULL, 0x00000018ff6f7819ULL, 0x000fe40000011443ULL,
0x00000042008f7306ULL, 0x000322000000d400ULL, 0x00000018ff687819ULL, 0x004fce0000011441ULL,
0x0000006800417306ULL, 0x000fe20000209400ULL, 0x0001000042427824ULL, 0x002fe200078e00ffULL,
0x00000001a5a56812ULL, 0x008fe400078efcffULL, 0x000000c9ca00720bULL, 0x000fc80003fdd000ULL,
0x0000006800d27306ULL, 0x000e620000205400ULL, 0x000000018f8f3812ULL, 0x010fce00078efcffULL,
0x0000006f00d87306ULL, 0x000fe20000209400ULL, 0x000000019b9b6812ULL, 0x000fce00078efcffULL,
0x0000006f00437306ULL, 0x000ea20000205400ULL, 0x000000d24100720bULL, 0x002fce0003f1d000ULL,
0x0000007300927306ULL, 0x0002f0000020d400ULL, 0x0000006c00d67306ULL, 0x000fe20000209400ULL,
0x0000010048737824ULL, 0x002fe200078e00ffULL, 0x00000043d800720bULL, 0x004fc80003f7d000ULL,
0x00000018ff737819ULL, 0x000fe40000011473ULL, 0x0000006c00d37306ULL, 0x000e620000205400ULL,
0x0000000192924812ULL, 0x008fe400078efcffULL, 0x000000c5c200720bULL, 0x000fca0003f9d000ULL,
0x0000006c00937306ULL, 0x0004f0000020d400ULL, 0x00000068009c7306ULL, 0x0008e2000020d400ULL,
0x00000100496c7824ULL, 0x004fe200078e00ffULL, 0x000000d3d600720bULL, 0x002fc40003fdd000ULL,
0x000000018a8a4812ULL, 0x000fe400078efcffULL, 0x00000018ff6c7819ULL, 0x000fe4000001146cULL,
0x0000004900bd7306ULL, 0x000fe20000009400ULL, 0x00000018ff687819ULL, 0x010fcc0000011442ULL,
0x0000000193936812ULL, 0x008fe200078efcffULL, 0x0000004900be7306ULL, 0x000fe20000005400ULL,
0x000000019c9c0812ULL, 0x000fe400078efcffULL, 0x000000b3c400720bULL, 0x000fe40003f1d000ULL,
0x000000bac300720bULL, 0x000fe40003fdd000ULL, 0x0000009c3f3f723eULL, 0x000fe200000010ffULL,
0x00000049007d7306ULL, 0x0003f0000000d400ULL, 0x0000006f00897306ULL, 0x0004e2000020d400ULL,
0x0001000049497824ULL, 0x002fe200078e00ffULL, 0x000000018e8e0812ULL, 0x000fc400078efcffULL,
0x0000000184846812ULL, 0x000fc800078efcffULL, 0x0000006800d57306ULL, 0x000fe20000209400ULL,
0x00000018ff6f7819ULL, 0x004fe20000011449ULL, 0x000001004a497824ULL, 0x000fcc00078e00ffULL,
0x0000006800427306ULL, 0x000e620000205400ULL, 0x0000000189893812ULL, 0x008fe400078efcffULL,
0x000000bebd00720bULL, 0x000fca0003f7d000ULL, 0x0000006c00d97306ULL, 0x000ff00000209400ULL,
0x0000006c00dc7306ULL, 0x000ea20000205400ULL, 0x00000042d500720bULL, 0x002fe40003fbd000ULL,
0x000000017d7d3812ULL, 0x000fe200078efcffULL, 0x000000004040783bULL, 0x000e680000000200ULL,
0x0000006c00867306ULL, 0x000730000020d400ULL, 0x0000007300d77306ULL, 0x000fe20000209400ULL,
0x00000018ff6c7819ULL, 0x008fc40000011449ULL, 0x000000dcd900720bULL, 0x004fca0003f9d000ULL,
0x0000007300da7306ULL, 0x000eb00000205400ULL, 0x00000068008b7306ULL, 0x000ee2000020d400ULL,
0x0000000186864812ULL, 0x010fe400078efcffULL, 0x000000bcbb00720bULL, 0x000fca0003f9d000ULL,
0x0000004800bf7306ULL, 0x000fe20000009400ULL, 0x000000dad700720bULL, 0x004fe20003f1d000ULL,
0x000000234040a231ULL, 0x082fe400003400ffULL, 0x000000234242a231ULL, 0x000fc800003400ffULL,
0x0000004800a67306ULL, 0x000e620000005400ULL, 0x000000018b8b5812ULL, 0x008fe200078efcffULL,
0x000000224141a231ULL, 0x080fe200003400ffULL, 0x0000000175754812ULL, 0x000fe200078efcffULL,
0x000000224343a231ULL, 0x000fe200003400ffULL, 0x0000008b8a8a723eULL, 0x000fe400000010ffULL,
0x00000089848b723eULL, 0x000fe200000010ffULL, 0x0000006c00e77306ULL, 0x000fe60000209400ULL,
0x0000003e4004723cULL, 0x000fea0000041804ULL, 0x0000006c00ea7306ULL, 0x000ea20000205400ULL,
0x000000a6bf00720bULL, 0x002fc40003fbd000ULL, 0x0000008a400c723cULL, 0x000fea000004180cULL,
0x0000004800827306ULL, 0x0002f0000000d400ULL, 0x0000004a00b47306ULL, 0x000fe20000009400ULL,
0x0001000048487824ULL, 0x002fe200078e00ffULL, 0x000000eae700720bULL, 0x004fc80003f7d000ULL,
0x00000018ff687819ULL, 0x000fe40000011448ULL, 0x0000004a00b97306ULL, 0x000fe20000005400ULL,
0x0000000182825812ULL, 0x008fce00078efcffULL, 0x0000004a00787306ULL, 0x0003f0000000d400ULL,
0x0000007300857306ULL, 0x0004e2000020d400ULL, 0x000100004a4a7824ULL, 0x002fca00078e00ffULL,
0x00000018ff4a7819ULL, 0x000fe4000001144aULL, 0x0000004b00ae7306ULL, 0x000fe20000009400ULL,
0x000001004b737824ULL, 0x004fca00078e00ffULL, 0x00000018ff737819ULL, 0x000fe40000011473ULL,
0x0000004b00ab7306ULL, 0x000fe20000005400ULL, 0x0000000185850812ULL, 0x008fe400078efcffULL,
0x000000c1c000720bULL, 0x000fca0003f1d000ULL, 0x0000004b006e7306ULL, 0x0003f0000000d400ULL,
0x0000006800de7306ULL, 0x000fe20000209400ULL, 0x000100004b4b7824ULL, 0x002fe200078e00ffULL,
0x000000017f7f0812ULL, 0x000fc800078efcffULL, 0x00000018ff4b7819ULL, 0x000fe4000001144bULL,
0x0000006800db7306ULL, 0x000e700000205400ULL, 0x0000006800887306ULL, 0x0004f0000020d400ULL,
0x0000003000b17306ULL, 0x000fe20000009400ULL, 0x0000010030687824ULL, 0x004fe200078e00ffULL,
0x000000dbde00720bULL, 0x002fc80003fdd000ULL, 0x00000018ff687819ULL, 0x000fe40000011468ULL,
0x0000003000ac7306ULL, 0x000fee0000005400ULL, 0x0000000188886812ULL, 0x008fe200078efcffULL,
0x0000003000697306ULL, 0x0003e2000000d400ULL, 0x000000b9b400720bULL, 0x000fce0003fdd000ULL,
0x0000006c00497306ULL, 0x000ea2000020d400ULL, 0x0001000030307824ULL, 0x002fca00078e00ffULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x0000006f00e27306ULL, 0x000fe20000209400ULL,
0x0000000178786812ULL, 0x000fe400078efcffULL, 0x000000adb200720bULL, 0x000fca0003fdd000ULL,
0x0000006f00dd7306ULL, 0x000e620000205400ULL, 0x0000000149493812ULL, 0x004fe400078efcffULL,
0x000000acb100720bULL, 0x000fe20003f7d000ULL, 0x0000010047b17824ULL, 0x000fe200078e00ffULL,
0x000000784978723eULL, 0x000fc600000010ffULL, 0x0000004a00e07306ULL, 0x000fe20000209400ULL,
0x0000000172726812ULL, 0x000fe400078efcffULL, 0x00000018ffb17819ULL, 0x000fca00000114b1ULL,
0x0000004a00df7306ULL, 0x000ea20000205400ULL, 0x000000dde200720bULL, 0x002fe40003fbd000ULL,
0x0000000169693812ULL, 0x000fca00078efcffULL, 0x0000004a00817306ULL, 0x0002f0000020d400ULL,
0x0000004b00e47306ULL, 0x000fe20000209400ULL, 0x00000100314a7824ULL, 0x002fe200078e00ffULL,
0x000000dfe000720bULL, 0x004fc80003f9d000ULL, 0x00000018ff4a7819ULL, 0x000fe4000001144aULL,
0x0000004b00e17306ULL, 0x000fee0000205400ULL, 0x0000000181814812ULL, 0x008fe200078efcffULL,
0x0000004b007a7306ULL, 0x0003f0000020d400ULL, 0x0000007300e57306ULL, 0x000fe20000209400ULL,
0x00000100324b7824ULL, 0x002fce00078e00ffULL, 0x0000007300e87306ULL, 0x000e700000205400ULL,
0x0000007300797306ULL, 0x000eb0000020d400ULL, 0x0000003100a17306ULL, 0x000fe20000009400ULL,
0x000000e8e500720bULL, 0x002fce0003f1d000ULL, 0x0000003100a27306ULL, 0x000e6c0000005400ULL,
0x0000000179790812ULL, 0x004fe400078efcffULL, 0x0000003100637306ULL, 0x0004e2000000d400ULL,
0x000000b0af00720bULL, 0x000fe20003f1d000ULL, 0x0000010046af7824ULL, 0x000fc400078e00ffULL,
0x0001000046b07824ULL, 0x000fc600078e00ffULL, 0x00000018ffaf7819ULL, 0x000fe200000114afULL,
0x0000003000b67306ULL, 0x000fe20000209400ULL, 0x0001000031317824ULL, 0x004fe200078e00ffULL,
0x000000a2a100720bULL, 0x002fe40003fdd000ULL, 0x00000018ffb07819ULL, 0x000fe400000114b0ULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x0000003000b57306ULL, 0x000e620000205400ULL,
0x000000016b6b0812ULL, 0x000fcc00078efcffULL, 0x0000000163636812ULL, 0x008fe200078efcffULL,
0x0000003000737306ULL, 0x0005f0000020d400ULL, 0x0000006f00487306ULL, 0x000ee2000020d400ULL,
0x00000018ff307819ULL, 0x004fe2000001144bULL, 0x00000100334b7824ULL, 0x000fe200078e00ffULL,
0x000000b5b600720bULL, 0x002fc80003f1d000ULL, 0x00000018ffe97819ULL, 0x000fe2000001144bULL,
0x0000004a00b77306ULL, 0x000ff00000209400ULL, 0x0000004a00b87306ULL, 0x000e620000205400ULL,
0x0000000148485812ULL, 0x008fc400078efcffULL, 0x000000abae00720bULL, 0x000fe20003fbd000ULL,
0x0001000047ae7824ULL, 0x000fe200078e00ffULL, 0x0000000173730812ULL, 0x000fc600078efcffULL,
0x0000003000947306ULL, 0x000fe20000209400ULL, 0x00000018ffae7819ULL, 0x000fce00000114aeULL,
0x0000003000957306ULL, 0x000fe20000205400ULL, 0x000000b8b700720bULL, 0x002fe40003f7d000ULL,
0x000000016e6e5812ULL, 0x000fe400078efcffULL, 0x000000e1e400720bULL, 0x000fe40003fbd000ULL,
0x0000006e7979723eULL, 0x000fe200000010ffULL, 0x00000030006c7306ULL, 0x0003ec000020d400ULL,
0x000000784054723cULL, 0x000fe40000041854ULL, 0x0000006800e67306ULL, 0x000fe20000209400ULL,
0x0000010044307824ULL, 0x002fe200078e00ffULL, 0x000000017a7a5812ULL, 0x000fc400078efcffULL,
0x000000a3a000720bULL, 0x000fe40003fbd000ULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x0000006800e37306ULL, 0x000e700000205400ULL, 0x0000003200a47306ULL, 0x000fe20000009400ULL,
0x0000000164645812ULL, 0x000fc800078efcffULL, 0x000000736464723eULL, 0x000fc600000010ffULL,
0x00000032009f7306ULL, 0x000fe20000005400ULL, 0x000000e3e600720bULL, 0x002fce0003f9d000ULL,
0x00000032005f7306ULL, 0x0003f0000000d400ULL, 0x0000003300987306ULL, 0x000fe20000009400ULL,
0x0001000032327824ULL, 0x002fca00078e00ffULL, 0x00000018ff327819ULL, 0x000fe40000011432ULL,
0x0000003300977306ULL, 0x000e700000005400ULL, 0x00000033005b7306ULL, 0x0004f0000000d400ULL,
0x0000003100a77306ULL, 0x000fe20000209400ULL, 0x0001000033337824ULL, 0x004fe200078e00ffULL,
0x000000979800720bULL, 0x002fc80003f1d000ULL, 0x00000018ff337819ULL, 0x000fe40000011433ULL,
0x0000003100aa7306ULL, 0x000e6e0000205400ULL, 0x000000015b5b0812ULL, 0x008fe200078efcffULL,
0x00000031006f7306ULL, 0x0004f0000020d400ULL, 0x0000003000b37306ULL, 0x000fe20000209400ULL,
0x0000010045317824ULL, 0x004fe200078e00ffULL, 0x000000aaa700720bULL, 0x002fc80003fdd000ULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x0000003000ba7306ULL, 0x000fee0000205400ULL,
0x000000016f6f6812ULL, 0x008fe200078efcffULL, 0x0000003000a67306ULL, 0x0003f0000020d400ULL,
0x0000004a00747306ULL, 0x000ea2000020d400ULL, 0x000128003b307811ULL, 0x002fce00078e20ffULL,
0x00000068007c7306ULL, 0x000e70000020d400ULL, 0x00000032004a7306ULL, 0x000fe20000209400ULL,
0x0000000174743812ULL, 0x004fe400078efcffULL, 0x000000909100720bULL, 0x000fca0003f7d000ULL,
0x00000032004b7306ULL, 0x000fe20000205400ULL, 0x000000017c7c4812ULL, 0x002fe400078efcffULL,
0x0000009fa400720bULL, 0x000fe40003f9d000ULL, 0x000000697c7c723eULL, 0x000fc600000010ffULL,
0x00000032006d7306ULL, 0x000fe2000020d400ULL, 0x0000000160603812ULL, 0x000fce00078efcffULL,
0x0000003300967306ULL, 0x000fe20000209400ULL, 0x000000015f5f4812ULL, 0x000fe400078efcffULL,
0x0000007e7b00720bULL, 0x000fca0003f9d000ULL, 0x0000003300a97306ULL, 0x000e700000205400ULL,
0x0000003300877306ULL, 0x000ea2000020d400ULL, 0x000000015c5c4812ULL, 0x000fe400078efcffULL,
0x000000bab300720bULL, 0x000fca0003f9d000ULL, 0x0000003100bd7306ULL, 0x000fe20000209400ULL,
0x000000a99600720bULL, 0x002fce0003f1d000ULL, 0x0000003100bc7306ULL, 0x000fe20000205400ULL,
0x00000001a6a64812ULL, 0x000fe400078efcffULL, 0x000000666500720bULL, 0x000fe40003f9d000ULL,
0x0000006f6065723eULL, 0x000fe400000010ffULL, 0x0000000187870812ULL, 0x004fe200078efcffULL,
0x0000003100b47306ULL, 0x0003f0000020d400ULL, 0x000000e9008c7306ULL, 0x000fe20000209400ULL,
0x000000003030783bULL, 0x002e620000000200ULL, 0x0000000152524812ULL, 0x000fc400078efcffULL,
0x0000005e5d00720bULL, 0x000fc80003f9d000ULL, 0x000000e9008d7306ULL, 0x000eb00000205400ULL,
0x0000004400997306ULL, 0x000fe20000009400ULL, 0x000000014e4e4812ULL, 0x000fce00078efcffULL,
0x00000044009a7306ULL, 0x000ee20000005400ULL, 0x0000008d8c00720bULL, 0x004fce0003f7d000ULL,
0x0000004400537306ULL, 0x0005f0000000d400ULL, 0x000000e900687306ULL, 0x000f22000020d400ULL,
0x0001000044447824ULL, 0x004fe200078e00ffULL, 0x000000233030a231ULL, 0x082fe200003400ffULL,
0x0000009a9900720bULL, 0x008fe20003fbd000ULL, 0x000000233232a231ULL, 0x000fc400003400ffULL,
0x00000018ff447819ULL, 0x000fe20000011444ULL, 0x000000223131a231ULL, 0x080fe200003400ffULL,
0x0000004500807306ULL, 0x000fe20000009400ULL, 0x000000223333a231ULL, 0x000fe200003400ffULL,
0x000000959400720bULL, 0x000fcc0003f5d000ULL, 0x0000004500837306ULL, 0x000e620000005400ULL,
0x0000000168683812ULL, 0x010fe400078efcffULL, 0x000000777600720bULL, 0x000fe40003f7d000ULL,
0x0000000153535812ULL, 0x000fe400078efcffULL, 0x000000016c6c2812ULL, 0x000fe200078efcffULL,
0x0000004500517306ULL, 0x0004e2000000d400ULL, 0x0000004b4a00720bULL, 0x000fe40003f5d000ULL,
0x000000887f4a723eULL, 0x000fc400000010ffULL, 0x00000048754b723eULL, 0x000fe400000010ffULL,
0x00000053a6a6723eULL, 0x000fe200000010ffULL, 0x0000004600707306ULL, 0x000fe20000009400ULL,
0x0001000045457824ULL, 0x004fe200078e00ffULL, 0x000000838000720bULL, 0x002fe40003fdd000ULL,
0x0000000158583812ULL, 0x000fe200078efcffULL, 0x0000004a4048723cULL, 0x000be20000041814ULL,
0x000000bcbd00720bULL, 0x000fe40003f7d000ULL, 0x0000004600717306ULL, 0x000e620000005400ULL,
0x000000016d6d2812ULL, 0x000fc600078efcffULL, 0x0000005f6c14723eULL, 0x020fe400000010ffULL,
0x0000005b6815723eULL, 0x000fe400000010ffULL, 0x00000046004f7306ULL, 0x000522000000d400ULL,
0x0000000151516812ULL, 0x008fe400078efcffULL, 0x00000001b4b43812ULL, 0x000fe400078efcffULL,
0x000000626100720bULL, 0x000fe40003fdd000ULL, 0x00000051b4a7723eULL, 0x000fe200000010ffULL,
0x0000004400ac7306ULL, 0x000fe20000209400ULL, 0x00000018ff467819ULL, 0x004fc40000011445ULL,
0x0000009ba845723eULL, 0x000fe400000010ffULL, 0x000000717000720bULL, 0x002fc60003f5d000ULL,
0x0000004400ad7306ULL, 0x000e640000205400ULL, 0x0000000150506812ULL, 0x000fcc00078efcffULL,
0x0000004400ab7306ULL, 0x0004e4000020d400ULL, 0x000000014f4f2812ULL, 0x010fcc00078efcffULL,
0x0000004700677306ULL, 0x000fe20000009400ULL, 0x0000009ea544723eULL, 0x004fe400000010ffULL,
0x000000adac00720bULL, 0x002fca0003fbd000ULL, 0x000000444018723cULL, 0x000be20000041818ULL,
0x00000047006a7306ULL, 0x000e6c0000005400ULL, 0x0000008f9244723eULL, 0x020fe400000010ffULL,
0x0000008e9345723eULL, 0x000fe200000010ffULL, 0x0000004600a07306ULL, 0x000fe20000209400ULL,
0x00000001abab5812ULL, 0x008fca00078efcffULL, 0x000000444008723cULL, 0x000b620000041808ULL,
0x0000006a6700720bULL, 0x002fe20003f1d000ULL, 0x00000046009b7306ULL, 0x000e6a0000205400ULL,
0x000000828544723eULL, 0x020fe400000010ffULL, 0x0000007d8645723eULL, 0x000fe200000010ffULL,
0x000000af00907306ULL, 0x000fe20000209400ULL, 0x00000063747d723eULL, 0x000fce00000010ffULL,
0x000000af003f7306ULL, 0x000ea20000205400ULL, 0x0000009ba000720bULL, 0x002fca0003f7d000ULL,
0x000000143014723cULL, 0x000be40000041808ULL, 0x00000047004d7306ULL, 0x000e6a000000d400ULL,
0x000000ab5208723eULL, 0x020fc600000010ffULL, 0x0000004600977306ULL, 0x000722000020d400ULL,
0x0000003f9000720bULL, 0x004fce0003fbd000ULL, 0x000000af003e7306ULL, 0x000ea2000020d400ULL,
0x000000444044723cULL, 0x008b620000041810ULL, 0x000000014d4d0812ULL, 0x002fcc00078efcffULL,
0x000000817210723eULL, 0x020fe200000010ffULL, 0x000000b100807306ULL, 0x000fe20000209400ULL,
0x0000007a6b11723eULL, 0x000fe400000010ffULL, 0x0000000197973812ULL, 0x010fe400078efcffULL,
0x0000005a5900720bULL, 0x000fe40003f7d000ULL, 0x000000013e3e5812ULL, 0x004fe200078efcffULL,
0x000000104040723cULL, 0x000b62000004181cULL, 0x000000b100137306ULL, 0x000e620000205400ULL,
0x000000975009723eULL, 0x000fca00000010ffULL, 0x0000006d5c10723eULL, 0x020fe200000010ffULL,
0x0000007c301c723cULL, 0x000f620000041818ULL, 0x000000b000677306ULL, 0x000fe20000209400ULL,
0x000000014c4c3812ULL, 0x000fe400078efcffULL, 0x000000875811723eULL, 0x000fc800000010ffULL,
0x000000643018723cULL, 0x000b620000041804ULL, 0x000000b000667306ULL, 0x000ea20000205400ULL,
0x000000138000720bULL, 0x002fca0003fdd000ULL, 0x0000004f3e04723eULL, 0x020fe200000010ffULL,
0x000000103010723cULL, 0x040b62000004180cULL, 0x000000ae00607306ULL, 0x000fee0000209400ULL,
0x000000a6300c723cULL, 0x000b620000041844ULL, 0x000000ae00057306ULL, 0x000e620000205400ULL,
0x000000666700720bULL, 0x004fcc0003fbd000ULL, 0x000000083008723cULL, 0x000b620000041848ULL,
0x000000b1006e7306ULL, 0x000eb0000020d400ULL, 0x000000b000077306ULL, 0x000ee2000020d400ULL,
0x000000056000720bULL, 0x002fce0003f5d000ULL, 0x000000ae003f7306ULL, 0x000e62000020d400ULL,
0x000000016e6e6812ULL, 0x004fc800078efcffULL, 0x0000004d6e05723eULL, 0x000fe400000010ffULL,
0x0000000107075812ULL, 0x008fc800078efcffULL, 0x000000074e4e723eULL, 0x000fe400000010ffULL,
0x000000043004723cULL, 0x000b620000041854ULL, 0x000000013f3f2812ULL, 0x002fc800078efcffULL,
0x0000003f4c4f723eULL, 0x000fce00000010ffULL, 0x0000004e3030723cULL, 0x000b620000041840ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0186b800ff3e7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000060273e7810ULL, 0x002fe20007ffe0ffULL, 0x01869000ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff427224ULL, 0x020fe400078e003fULL, 0x0000002d3e00720cULL, 0x000fda0003f06070ULL,
0x0000bad000000947ULL, 0x000fea0003800000ULL, 0x00000000003e7805ULL, 0x000fc40000015200ULL,
0x0186bc00ff417984ULL, 0x000e640000000800ULL, 0x8000000041ff7812ULL, 0x002fe40007804842ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff447224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000407805ULL, 0x000fcc0000015200ULL, 0x000000403e437210ULL, 0x000fca0007f1e1ffULL,
0x0000000141417824ULL, 0x000fe200000e0e3fULL, 0x003d09004300780cULL, 0x000fc80003f06070ULL,
0x000000ff4100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404300780cULL, 0x000fc80003f06070ULL, 0x000000ff4100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff407819ULL, 0x000fc80000011441ULL,
0x0000004340407211ULL, 0x000fca00078110ffULL, 0x000000ffff417224ULL, 0x000fca00000e0641ULL,
0x0000000240407819ULL, 0x000fc80000001241ULL, 0x000000400000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000144447810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0186bc00ff417984ULL, 0x000e640000000800ULL,
0x8000000041ff7812ULL, 0x002fe40007804842ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000080273f7810ULL, 0x000fca0007ffe0ffULL, 0x000062002a437a24ULL, 0x000fe200078e023fULL,
0x0000039000009947ULL, 0x000fea0003800000ULL, 0x00000002214b7810ULL, 0x000fe20007ffe0ffULL,
0x000000012c407824ULL, 0x040fe200078e0221ULL, 0x0000003f2d3e7217ULL, 0x000fe40007800000ULL,
0x00000004214d7810ULL, 0x040fe20007ffe0ffULL, 0x000000012c427824ULL, 0x000fe200078e024bULL,
0x00000006214f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000140417824ULL, 0x100fe200078e022fULL,
0x000000f026497812ULL, 0x000fe200078ec0ffULL, 0x0000000142447824ULL, 0x000fc400078e022fULL,
0x0000001042477824ULL, 0x000fe400078e00ffULL, 0x0000001040487824ULL, 0x000fe400078e00ffULL,
0x000000013e3f7824ULL, 0x000fe200078e0a3fULL, 0xfffffff0474a7812ULL, 0x000fe200078ee244ULL,
0x000000012c467824ULL, 0x000fe200078e024dULL, 0xfffffff048487812ULL, 0x000fe200078ee241ULL,
0x00000100ff477424ULL, 0x000fe200078e00ffULL, 0x0000003f2c417217ULL, 0x000fe20007800000ULL,
0x00000001403e7824ULL, 0x000fc400078e0243ULL, 0x0000000146457824ULL, 0x040fe400078e022fULL,
0x00000010464c7824ULL, 0x000fe400078e00ffULL, 0x0000000142407824ULL, 0x000fe400078e0243ULL,
0x000000012c447824ULL, 0x000fe200078e024fULL, 0xfffffff04c4c7812ULL, 0x000fe200078ee245ULL,
0x00005e003e3e7625ULL, 0x000fc800078e0047ULL, 0x0000000146427824ULL, 0x000fe400078e0243ULL,
0x0000000141467824ULL, 0x000fe400078e0a2cULL, 0x00005e0040407625ULL, 0x000fc600078e0047ULL,
0x000000462100720cULL, 0x080fe20003f66070ULL, 0x0000000144437824ULL, 0x000fe200078e0243ULL,
0x0000004940407210ULL, 0x080fe20007f9e0ffULL, 0x0000000144457824ULL, 0x040fe200078e022fULL,
0x000000464b00720cULL, 0x080fe20003f46070ULL, 0x00000010444e7824ULL, 0x000fe200078e00ffULL,
0x000000493e447210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff417224ULL, 0x000fe200020e0641ULL,
0x000000464f00720cULL, 0x080fe40003f86070ULL, 0xfffffff04e4e7812ULL, 0x000fe200078ee245ULL,
0x000000ffff457224ULL, 0x000fe200000e063fULL, 0x000000464d00720cULL, 0x000fe20003f06070ULL,
0x00005e00423e7625ULL, 0x000fe200078e0047ULL, 0x000160004c4b7811ULL, 0x000fc400078e20ffULL,
0x000160004e4d7811ULL, 0x000fe200078e20ffULL, 0x00005e0043427625ULL, 0x000fe200078e0047ULL,
0x000000493e3e7210ULL, 0x080fe40007fbe0ffULL, 0x0001600048477811ULL, 0x000fe400078e20ffULL,
0x0000004942427210ULL, 0x000fe20007fde0ffULL, 0x000000ffff3f7224ULL, 0x000fe200028e063fULL,
0x000160004a497811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044477faeULL, 0x0003e4000d901c46ULL, 0x000000ffff437224ULL, 0x000fc400030e0643ULL,
0x0000000040497faeULL, 0x0003e8000d101c46ULL, 0x000000003e4b7faeULL, 0x0003e8000c101c46ULL,
0x00000000424d7faeULL, 0x0003e2000e101c46ULL, 0x000002d000007947ULL, 0x000fea0003800000ULL,
0x000000012c3e7824ULL, 0x000fe200078e0221ULL, 0x000000f026497812ULL, 0x000fe200078ec0ffULL,
0x00000100ff477424ULL, 0x000fc400078e00ffULL, 0x000000013e3f7824ULL, 0x140fe200078e022fULL,
0x000000043e427810ULL, 0x040fe20007ffe0ffULL, 0x000000103e467824ULL, 0x040fe200078e00ffULL,
0x000000023e407810ULL, 0x040fe40007ffe0ffULL, 0x000000063e4c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000142447824ULL, 0x000fe200078e022fULL, 0xfffffff046467812ULL, 0x000fe200078ee23fULL,
0x0000001042457824ULL, 0x000fe400078e00ffULL, 0x0000000140417824ULL, 0x000fc400078e022fULL,
0x0000001040487824ULL, 0x000fe200078e00ffULL, 0xfffffff0454a7812ULL, 0x000fe200078ee244ULL,
0x000000013e447824ULL, 0x100fe400078e0243ULL, 0x00000001403e7824ULL, 0x000fe200078e0243ULL,
0xfffffff048487812ULL, 0x000fe200078ee241ULL, 0x00005e0044447625ULL, 0x000fc800078e0047ULL,
0x0000000142407824ULL, 0x100fe200078e0243ULL, 0x0000004944447210ULL, 0x000fe20007f5e0ffULL,
0x000000014c427824ULL, 0x000fe400078e0243ULL, 0x00005e003e3e7625ULL, 0x000fc800078e0047ULL,
0x00005e0040407625ULL, 0x000fe200078e0047ULL, 0x000000493e3e7210ULL, 0x000fc60007f1e0ffULL,
0x000000014c4b7824ULL, 0x000fe400078e022fULL, 0x00005e0042427625ULL, 0x000fe200078e0047ULL,
0x0001600046477811ULL, 0x000fc600078e20ffULL, 0x000000104c4c7824ULL, 0x000fe200078e00ffULL,
0x0000004942427210ULL, 0x080fe20007f7e0ffULL, 0x000000ffff457224ULL, 0x000fe200010e0645ULL,
0x0000004940407210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff3f7224ULL, 0x000fe200000e063fULL,
0xfffffff04c4c7812ULL, 0x000fe200078ee24bULL, 0x000000ffff437224ULL, 0x000fe200018e0643ULL,
0x0001600048497811ULL, 0x000fe200078e20ffULL, 0x000000ffff417224ULL, 0x000fe200010e0641ULL,
0x000160004a4b7811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044477faeULL, 0x0003e2000b901c46ULL, 0x000160004c4d7811ULL, 0x000fc600078e20ffULL,
0x000000003e497faeULL, 0x0003e8000b901c46ULL, 0x00000000404b7faeULL, 0x0003e8000b901c46ULL,
0x00000000424d7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0186b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0186b000ff567f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018648002c427f8cULL, 0x0004e4000c80043fULL,
0x00000000003e7805ULL, 0x000fc40000015200ULL, 0x01864c002c417984ULL, 0x000f240000000800ULL,
0x8000000041ff7812ULL, 0x018fc40007804843ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff447224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000407805ULL, 0x000fcc0000015200ULL,
0x000000403e457210ULL, 0x000fca0007f1e1ffULL, 0x0000000141417824ULL, 0x000fe200000e0e3fULL,
0x003d09004500780cULL, 0x000fc80003f06070ULL, 0x000000ff4100720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404500780cULL, 0x000fc80003f06070ULL,
0x000000ff4100720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff407819ULL, 0x000fc80000011441ULL, 0x0000004540407211ULL, 0x000fca00078110ffULL,
0x000000ffff417224ULL, 0x000fca00000e0641ULL, 0x0000000240407819ULL, 0x000fc80000001241ULL,
0x000000400000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000144447810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01864c002c417984ULL, 0x000ee40000000800ULL, 0x8000000041ff7812ULL, 0x008fe40007804843ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x01810000253f7984ULL, 0x000ee80000000800ULL,
0x01830000253e7984ULL, 0x0004620000000800ULL, 0x0000003c3f00720bULL, 0x008fe20003f1d000ULL,
0x000132f27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000427806ULL, 0x004fc800000e0100ULL,
0x0000ffff42ff7812ULL, 0x000fe2000780c0ffULL, 0x0000048000007945ULL, 0x000fe20003800000ULL,
0x00000001ff437424ULL, 0x000fc400078e00ffULL, 0x000000ffff547224ULL, 0x000fd200078e003cULL,
0x0000044000008947ULL, 0x000fea0003800000ULL, 0x000000022e00780cULL, 0x000fe40003f05270ULL,
0x0000003c3f00720bULL, 0x000fe20003f54000ULL, 0x000132c27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000437806ULL, 0x000fc400010e0100ULL, 0x0000003f3c408209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x0000991043417816ULL, 0x000fc600000000ffULL,
0x0185004025008388ULL, 0x0005e20000000800ULL, 0x000000ff4100720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000003f3c417209ULL, 0x004fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff43ff7812ULL, 0x000fc6000780c0ffULL,
0x800000413c407221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b40407820ULL, 0x000fc80000410000ULL,
0x0000004000447308ULL, 0x000ea40000000800ULL, 0x0000004429297220ULL, 0x004fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff597819ULL, 0x000fe2000001162fULL,
0x000132127f007947ULL, 0x000fea000b800000ULL, 0x00001f5944407589ULL, 0x0004e400000e0000ULL,
0x000000401c1c7220ULL, 0x088fe40000410000ULL, 0x000000401d1d7220ULL, 0x080fe40000410000ULL,
0x0000004018187220ULL, 0x080fe40000410000ULL, 0x0000004019197220ULL, 0x000fc40000410000ULL,
0x0000004014147220ULL, 0x080fe40000410000ULL, 0x0000004015157220ULL, 0x080fe40000410000ULL,
0x0000004010107220ULL, 0x080fe40000410000ULL, 0x0000004011117220ULL, 0x080fe40000410000ULL,
0x000000400c0c7220ULL, 0x080fe40000410000ULL, 0x000000400d0d7220ULL, 0x000fc40000410000ULL,
0x0000004008087220ULL, 0x080fe40000410000ULL, 0x0000004009097220ULL, 0x080fe40000410000ULL,
0x0000004004047220ULL, 0x080fe40000410000ULL, 0x0000004005057220ULL, 0x080fe40000410000ULL,
0x0000004030307220ULL, 0x080fe40000410000ULL, 0x0000004031317220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0043ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000082f597811ULL, 0x006fe200078ff0ffULL,
0x000131227f007947ULL, 0x000fea000b800000ULL, 0x00001f5944407589ULL, 0x0002a400000e0000ULL,
0x000000401e1e7220ULL, 0x084fe40000410000ULL, 0x000000401f1f7220ULL, 0x080fe40000410000ULL,
0x000000401a1a7220ULL, 0x080fe40000410000ULL, 0x000000401b1b7220ULL, 0x080fe40000410000ULL,
0x0000004016167220ULL, 0x080fe40000410000ULL, 0x0000004017177220ULL, 0x000fc40000410000ULL,
0x0000004012127220ULL, 0x080fe40000410000ULL, 0x0000004013137220ULL, 0x080fe40000410000ULL,
0x000000400e0e7220ULL, 0x080fe40000410000ULL, 0x000000400f0f7220ULL, 0x080fe40000410000ULL,
0x000000400a0a7220ULL, 0x080fe40000410000ULL, 0x000000400b0b7220ULL, 0x000fc40000410000ULL,
0x0000004006067220ULL, 0x080fe40000410000ULL, 0x0000004007077220ULL, 0x080fe40000410000ULL,
0x0000004032327220ULL, 0x080fe40000410000ULL, 0x0000004033337220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff43ff7812ULL, 0x000fe20007800842ULL,
0x00000001ff437424ULL, 0x000fe200078e00ffULL, 0x0000003f3c547209ULL, 0x000fd60007810000ULL,
0x800000543f3f0221ULL, 0x000fe20000010000ULL, 0x00007610ff430816ULL, 0x000fc60000000043ULL,
0x3fb8aa3b3f3f0820ULL, 0x000fc80000410000ULL, 0x0000003f00240308ULL, 0x000ea40000000800ULL,
0x000000243e3e0220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000293e297221ULL, 0x002fc40000010000ULL, 0x00000000003e7805ULL, 0x000fca0000015200ULL,
0x0186ac00ff3c7984ULL, 0x000e640000000800ULL, 0x800000003cff7812ULL, 0x002fe4000780483dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff427224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000407805ULL, 0x000fcc0000015200ULL, 0x000000403e457210ULL, 0x000fca0007f1e1ffULL,
0x0000000141417824ULL, 0x000fe200000e0e3fULL, 0x003d09004500780cULL, 0x000fc80003f06070ULL,
0x000000ff4100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404500780cULL, 0x000fc80003f06070ULL, 0x000000ff4100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3c7819ULL, 0x000fc80000011441ULL,
0x000000453c3c7211ULL, 0x000fca00078110ffULL, 0x000000ffff417224ULL, 0x000fca00000e0641ULL,
0x000000023c3c7819ULL, 0x000fc80000001241ULL, 0x0000003c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000142427810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0186ac00ff3c7984ULL, 0x000e640000000800ULL,
0x800000003cff7812ULL, 0x002fe4000780483dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009910433c7816ULL, 0x000fe200000000ffULL, 0x0000019000007945ULL, 0x000fe60003800000ULL,
0x000000ff3c00720cULL, 0x000fda0003f45270ULL, 0x0000016000002947ULL, 0x000fea0003800000ULL,
0x00000024ff22723eULL, 0x000fe400000010ffULL, 0x00000002ff3d7819ULL, 0x000fe4000001162fULL,
0x00005410223c7816ULL, 0x000fe20000000022ULL, 0x00012d227f007947ULL, 0x000fea000b800000ULL,
0x00001f3d3c237589ULL, 0x0002a400000e0000ULL, 0x000000083d597810ULL, 0x002fe20007ffe0ffULL,
0x00012d727f007947ULL, 0x000fea000b800000ULL, 0x00001f593c227589ULL, 0x0002e400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000103d597810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff587224ULL, 0x000fe200078e003cULL, 0x0000e21000407802ULL, 0x000fe20000000f00ULL,
0x0000001fff5a7424ULL, 0x000fe400078e00ffULL, 0xffffffffff5b7424ULL, 0x000fc400078e00ffULL,
0x0001376000007944ULL, 0x00cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000183d597810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff587224ULL, 0x004fe200078e003cULL,
0x0000e28000407802ULL, 0x000fe20000000f00ULL, 0x0000001fff5a7424ULL, 0x000fc400078e00ffULL,
0xffffffffff5b7424ULL, 0x000fc400078e00ffULL, 0x000136f000007944ULL, 0x008fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000002044783bULL, 0x000f280000004200ULL, 0x000000000348783bULL, 0x000e680000004200ULL,
0x00000000023c783bULL, 0x002fe80000004200ULL, 0x000000000040783bULL, 0x000e620000004200ULL,
0x00000018ff597819ULL, 0x010fe20000011447ULL, 0x0000004400c07306ULL, 0x000fe20000009400ULL,
0x00000100446f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff527819ULL, 0x000fc40000011445ULL,
0x00000018ff5b7819ULL, 0x000fe40000011448ULL, 0x00000018ff6f7819ULL, 0x000fe4000001146fULL,
0x0000005900ba7306ULL, 0x000fe20000209400ULL, 0x00000018ff557819ULL, 0x000fe40000011446ULL,
0x00000018ff747819ULL, 0x002fe40000011442ULL, 0x00000018ff4c7819ULL, 0x000fe40000011444ULL,
0x00000018ff5d7819ULL, 0x000fe20000011449ULL, 0x0000005900bb7306ULL, 0x000fe20000205400ULL,
0x00000018ff737819ULL, 0x000fc40000011441ULL, 0x00000018ff637819ULL, 0x000fe40000011440ULL,
0x00000018ff757819ULL, 0x000fc60000011443ULL, 0x0000005900877306ULL, 0x0003f0000020d400ULL,
0x0000004400c37306ULL, 0x000f220000005400ULL, 0x00000018ff597819ULL, 0x002fce000001144bULL,
0x0000005900a37306ULL, 0x000ff00000209400ULL, 0x0000005900a67306ULL, 0x000fe20000205400ULL,
0x000000c3c000720bULL, 0x010fce0003f1d000ULL, 0x0000005900707306ULL, 0x0003f0000020d400ULL,
0x0000007400607306ULL, 0x000fe20000209400ULL, 0x00000018ff597819ULL, 0x002fce000001143fULL,
0x00000059007b7306ULL, 0x000ff00000209400ULL, 0x00000059007a7306ULL, 0x000ff00000205400ULL,
0x00000059005f7306ULL, 0x000ff0000020d400ULL, 0x0000007400617306ULL, 0x000ff00000205400ULL,
0x0000007400597306ULL, 0x0003f0000020d400ULL, 0x0000004500c17306ULL, 0x000fe20000009400ULL,
0x0000010045747824ULL, 0x002fca00078e00ffULL, 0x00000018ff747819ULL, 0x000fe40000011474ULL,
0x00000045007e7306ULL, 0x000ff00000005400ULL, 0x0000004500987306ULL, 0x0003f0000000d400ULL,
0x0000006f00c27306ULL, 0x000fe20000209400ULL, 0x0001000045457824ULL, 0x002fce00078e00ffULL,
0x0000006f00c57306ULL, 0x000e700000205400ULL, 0x0000006f00ab7306ULL, 0x0009f0000020d400ULL,
0x00000044009a7306ULL, 0x0006a2000000d400ULL, 0x00000018ff6f7819ULL, 0x010fc40000011445ULL,
0x000000c5c200720bULL, 0x002fca0003f7d000ULL, 0x0000006f00cb7306ULL, 0x000fe20000209400ULL,
0x0001000044447824ULL, 0x008fce00078e00ffULL, 0x0000006f00c87306ULL, 0x000e620000205400ULL,
0x000000019a9a0812ULL, 0x004fe400078efcffULL, 0x00000001abab3812ULL, 0x000fe400078efcffULL,
0x0000007ec100720bULL, 0x000fc60003f7d000ULL, 0x0000006f00457306ULL, 0x0004f0000020d400ULL,
0x0000004700b97306ULL, 0x000fe20000009400ULL, 0x000000c8cb00720bULL, 0x002fe20003f1d000ULL,
0x00000100486f7824ULL, 0x004fe200078e00ffULL, 0x0000000198983812ULL, 0x000fc800078efcffULL,
0x00000018ff6f7819ULL, 0x000fe2000001146fULL, 0x0000004700887306ULL, 0x000e6c0000005400ULL,
0x0000000145450812ULL, 0x008fe400078efcffULL, 0x0000007400c67306ULL, 0x000ff00000209400ULL,
0x0000007400c97306ULL, 0x000ea20000205400ULL, 0x00000088b900720bULL, 0x002fce0003f1d000ULL,
0x0000005b00b37306ULL, 0x000ff00000209400ULL, 0x0000005b00b27306ULL, 0x000fe20000205400ULL,
0x000000c9c600720bULL, 0x004fce0003fdd000ULL, 0x0000005b007c7306ULL, 0x0003f0000020d400ULL,
0x0000005500b87306ULL, 0x000fe20000209400ULL, 0x00000018ff5b7819ULL, 0x002fce000001143cULL,
0x0000005500b77306ULL, 0x000ff00000205400ULL, 0x0000005500897306ULL, 0x0003f0000020d400ULL,
0x0000004c00bc7306ULL, 0x000fe20000209400ULL, 0x00000018ff557819ULL, 0x002fce000001144aULL,
0x0000004c00a77306ULL, 0x000e700000205400ULL, 0x0000004c00957306ULL, 0x000eb0000020d400ULL,
0x0000005200be7306ULL, 0x000fe20000209400ULL, 0x000000a7bc00720bULL, 0x002fce0003f9d000ULL,
0x0000005200bf7306ULL, 0x000fec0000205400ULL, 0x0000000195954812ULL, 0x004fe400078efcffULL,
0x0000005200947306ULL, 0x000ff0000020d400ULL, 0x0000005d00b17306ULL, 0x000ff00000209400ULL,
0x0000005d00b07306ULL, 0x000ff00000205400ULL, 0x0000005d004c7306ULL, 0x0003f0000020d400ULL,
0x0000005500a57306ULL, 0x000fe20000209400ULL, 0x00000018ff5d7819ULL, 0x002fce000001143dULL,
0x00000055009c7306ULL, 0x000ff00000205400ULL, 0x0000005500527306ULL, 0x0003f0000020d400ULL,
0x0000005b00a17306ULL, 0x000fe20000209400ULL, 0x00000018ff557819ULL, 0x002fce000001143eULL,
0x0000005b009e7306ULL, 0x000ff00000205400ULL, 0x0000005b006c7306ULL, 0x000ff0000020d400ULL,
0x00000073006a7306ULL, 0x000ff00000209400ULL, 0x00000073006b7306ULL, 0x000ff00000205400ULL,
0x00000073005b7306ULL, 0x0003f0000020d400ULL, 0x00000047008d7306ULL, 0x000ea2000000d400ULL,
0x00000018ff737819ULL, 0x002fce0000011444ULL, 0x0000005d00977306ULL, 0x000ff00000209400ULL,
0x0000005d00967306ULL, 0x000fe20000205400ULL, 0x000000018d8d0812ULL, 0x004fce00078efcffULL,
0x0000005d00697306ULL, 0x000ff0000020d400ULL, 0x0000007400a97306ULL, 0x000e70000020d400ULL,
0x0000004600bd7306ULL, 0x000ff00000009400ULL, 0x0000004600aa7306ULL, 0x000ea20000005400ULL,
0x00000001a9a96812ULL, 0x002fce00078efcffULL, 0x0000005500827306ULL, 0x000ff00000209400ULL,
0x0000005500817306ULL, 0x000fe20000205400ULL, 0x000000aabd00720bULL, 0x004fce0003fdd000ULL,
0x0000005500677306ULL, 0x000ff0000020d400ULL, 0x00000063006d7306ULL, 0x000ff00000209400ULL,
0x00000063006e7306ULL, 0x000ff00000205400ULL, 0x00000063005d7306ULL, 0x000ff0000020d400ULL,
0x0000007300c47306ULL, 0x000ff00000209400ULL, 0x0000007300c77306ULL, 0x000e700000205400ULL,
0x0000006f00d57306ULL, 0x000ff00000209400ULL, 0x0000006f00d27306ULL, 0x000ea20000205400ULL,
0x000000c7c400720bULL, 0x002fce0003fbd000ULL, 0x0000007500627306ULL, 0x000ff00000209400ULL,
0x0000007500637306ULL, 0x000fe20000205400ULL, 0x000000d2d500720bULL, 0x004fce0003f1d000ULL,
0x0000007500557306ULL, 0x0003f0000020d400ULL, 0x0000007300447306ULL, 0x0004e2000020d400ULL,
0x0000010046757824ULL, 0x002fca00078e00ffULL, 0x00000018ff757819ULL, 0x000fe40000011475ULL,
0x00000046008f7306ULL, 0x000e62000000d400ULL, 0x0000010047737824ULL, 0x044fe400078e00ffULL,
0x0001000047477824ULL, 0x000fc600078e00ffULL, 0x00000018ff747819ULL, 0x000fe20000011473ULL,
0x0001000046737824ULL, 0x000fe200078e00ffULL, 0x00000018ff477819ULL, 0x000fe20000011447ULL,
0x0000007500cd7306ULL, 0x000fe20000209400ULL, 0x0000000144445812ULL, 0x008fe400078efcffULL,
0x00000018ff737819ULL, 0x000fe40000011473ULL, 0x000000bfbe00720bULL, 0x000fe40003fbd000ULL,
0x000000018f8f6812ULL, 0x002fe200078efcffULL, 0x0000007500ca7306ULL, 0x000e620000205400ULL,
0x000000449544723eULL, 0x000fce00000010ffULL, 0x0000006f00867306ULL, 0x0004e4000020d400ULL,
0x0000000194945812ULL, 0x000fc800078efcffULL, 0x000000459445723eULL, 0x000fe400000010ffULL,
0x0000004700d07306ULL, 0x000fe20000209400ULL, 0x000000cacd00720bULL, 0x002fe20003f9d000ULL,
0x000001004a6f7824ULL, 0x004fca00078e00ffULL, 0x00000018ff6f7819ULL, 0x000fe2000001146fULL,
0x0000004700d37306ULL, 0x000e620000205400ULL, 0x0000000186860812ULL, 0x008fe400078efcffULL,
0x000000b2b300720bULL, 0x000fca0003f1d000ULL, 0x0000007500927306ULL, 0x000eb0000020d400ULL,
0x0000007400cf7306ULL, 0x000fe20000209400ULL, 0x000000d3d000720bULL, 0x002fe40003fdd000ULL,
0x000000017c7c0812ULL, 0x000fca00078efcffULL, 0x0000007400cc7306ULL, 0x000e620000205400ULL,
0x0000000192924812ULL, 0x004fe400078efcffULL, 0x000000b7b800720bULL, 0x000fca0003f9d000ULL,
0x00000047008c7306ULL, 0x0004f0000020d400ULL, 0x0000004900997306ULL, 0x000fe20000009400ULL,
0x0001000049477824ULL, 0x004fe200078e00ffULL, 0x000000cccf00720bULL, 0x002fc40003f7d000ULL,
0x0000000189894812ULL, 0x000fe400078efcffULL, 0x00000018ff477819ULL, 0x000fe40000011447ULL,
0x0000004900b47306ULL, 0x000e620000005400ULL, 0x000000018c8c6812ULL, 0x008fce00078efcffULL,
0x0000004b00ac7306ULL, 0x000ff00000009400ULL, 0x0000004b00ad7306ULL, 0x000ea20000005400ULL,
0x000000b49900720bULL, 0x002fce0003fdd000ULL, 0x0000007300d17306ULL, 0x000ff00000209400ULL,
0x0000007300ce7306ULL, 0x000e620000205400ULL, 0x000000adac00720bULL, 0x004fe20003f1d000ULL,
0x0000010043ac7824ULL, 0x000fca00078e00ffULL, 0x00000018ffac7819ULL, 0x000fe200000114acULL,
0x0000007400467306ULL, 0x0004f0000020d400ULL, 0x0000004900847306ULL, 0x000f22000000d400ULL,
0x0000010049747824ULL, 0x004fe200078e00ffULL, 0x000000ced100720bULL, 0x002fc80003fbd000ULL,
0x00000018ff747819ULL, 0x000fe40000011474ULL, 0x0000004b00517306ULL, 0x000e62000000d400ULL,
0x0000000146463812ULL, 0x008fe400078efcffULL, 0x000000bbba00720bULL, 0x000fca0003f7d000ULL,
0x0000007400d77306ULL, 0x000fe20000209400ULL, 0x0000000184846812ULL, 0x010fce00078efcffULL,
0x0000007400d47306ULL, 0x000ea20000205400ULL, 0x0000000151510812ULL, 0x002fe400078efcffULL,
0x000000a6a300720bULL, 0x000fe20003f1d000ULL, 0x0001000042a67824ULL, 0x000fe200078e00ffULL,
0x0000000187873812ULL, 0x000fc600078efcffULL, 0x00000073008e7306ULL, 0x0002e2000020d400ULL,
0x00000018ffa67819ULL, 0x000fce00000114a6ULL, 0x0000004800b67306ULL, 0x000fe20000009400ULL,
0x000001004b737824ULL, 0x002fe200078e00ffULL, 0x000000d4d700720bULL, 0x004fe20003f9d000ULL,
0x000100004b4b7824ULL, 0x000fe200078e00ffULL, 0x0000000170700812ULL, 0x000fe400078efcffULL,
0x00000018ff737819ULL, 0x000fe40000011473ULL, 0x0000004800b57306ULL, 0x000e620000005400ULL,
0x000000018e8e5812ULL, 0x008fe400078efcffULL, 0x00000018ff4b7819ULL, 0x000fc4000001144bULL,
0x0000008e898e723eULL, 0x000fc600000010ffULL, 0x0000004800837306ULL, 0x0004f0000000d400ULL,
0x0000004a00ae7306ULL, 0x000fe20000009400ULL, 0x0001000048487824ULL, 0x004fe200078e00ffULL,
0x000000b5b600720bULL, 0x002fc80003fbd000ULL, 0x00000018ff487819ULL, 0x000fe40000011448ULL,
0x0000004a00af7306ULL, 0x000e6e0000005400ULL, 0x0000000183835812ULL, 0x008fe200078efcffULL,
0x0000004700dd7306ULL, 0x000ff00000209400ULL, 0x0000004700da7306ULL, 0x000ea20000205400ULL,
0x000000afae00720bULL, 0x002fce0003fdd000ULL, 0x00000047007f7306ULL, 0x0002f0000020d400ULL,
0x0000003c009f7306ULL, 0x000fe20000009400ULL, 0x000001003c477824ULL, 0x002fe200078e00ffULL,
0x000000dadd00720bULL, 0x004fc80003fbd000ULL, 0x00000018ff477819ULL, 0x000fe40000011447ULL,
0x0000003c00a27306ULL, 0x000fee0000005400ULL, 0x000000017f7f5812ULL, 0x008fe200078efcffULL,
0x0000003c00727306ULL, 0x0003f0000000d400ULL, 0x0000007400857306ULL, 0x000ea2000020d400ULL,
0x000100003c3c7824ULL, 0x002fca00078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000004800d67306ULL, 0x000ff00000209400ULL, 0x0000004800d97306ULL, 0x000e620000205400ULL,
0x0000000185854812ULL, 0x004fc400078efcffULL, 0x000000b0b100720bULL, 0x000fca0003f9d000ULL,
0x0000004700e27306ULL, 0x000ff00000209400ULL, 0x0000004700e57306ULL, 0x000fe20000205400ULL,
0x000000d9d600720bULL, 0x002fe40003f7d000ULL, 0x000000014c4c4812ULL, 0x000fca00078efcffULL,
0x0000004700797306ULL, 0x0003f0000020d400ULL, 0x0000004a004f7306ULL, 0x0004e2000000d400ULL,
0x000001003e477824ULL, 0x002fce00078e00ffULL, 0x0000003c00e47306ULL, 0x000fe20000209400ULL,
0x000100004a4a7824ULL, 0x004fca00078e00ffULL, 0x00000018ff4a7819ULL, 0x000fe4000001144aULL,
0x0000003c00e77306ULL, 0x000e620000205400ULL, 0x000000014f4f6812ULL, 0x008fe400078efcffULL,
0x0000009ca500720bULL, 0x000fe20003fdd000ULL, 0x0000010042a57824ULL, 0x000fc800078e00ffULL,
0x0000003c00757306ULL, 0x0005e2000020d400ULL, 0x00000018ffa57819ULL, 0x000fce00000114a5ULL,
0x0000004800497306ULL, 0x000722000020d400ULL, 0x00000018ff3c7819ULL, 0x004fe40000011447ULL,
0x000000e7e400720bULL, 0x002fe40003f1d000ULL, 0x0000000152526812ULL, 0x000fc600078efcffULL,
0x0000007300de7306ULL, 0x000fe20000209400ULL, 0x000001003d487824ULL, 0x008fca00078e00ffULL,
0x00000018ff487819ULL, 0x000fe40000011448ULL, 0x0000007300e17306ULL, 0x000e620000205400ULL,
0x0000000149493812ULL, 0x010fe400078efcffULL, 0x0000000175750812ULL, 0x000fe400078efcffULL,
0x000000969700720bULL, 0x000fc60003f1d000ULL, 0x0000007300787306ULL, 0x000eb0000020d400ULL,
0x0000003d00a07306ULL, 0x000fe20000009400ULL, 0x000000e1de00720bULL, 0x002fe40003fbd000ULL,
0x0000000169690812ULL, 0x000fca00078efcffULL, 0x0000003d009b7306ULL, 0x000e6c0000005400ULL,
0x0000000178785812ULL, 0x004fe400078efcffULL, 0x0000003d00717306ULL, 0x0004f0000000d400ULL,
0x0000003c00477306ULL, 0x000fe20000209400ULL, 0x000100003d3d7824ULL, 0x004fe200078e00ffULL,
0x0000009ba000720bULL, 0x002fc80003fdd000ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000003c00a87306ULL, 0x000e6e0000205400ULL, 0x0000000171716812ULL, 0x008fe200078efcffULL,
0x0000003c00737306ULL, 0x0004f0000020d400ULL, 0x0000006f00e07306ULL, 0x000fe20000209400ULL,
0x00000100403c7824ULL, 0x004fe200078e00ffULL, 0x000000a84700720bULL, 0x002fc80003fdd000ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000006f00e37306ULL, 0x000e6e0000205400ULL,
0x0000000173736812ULL, 0x008fe200078efcffULL, 0x0000004a00db7306ULL, 0x000fe20000209400ULL,
0x000000818200720bULL, 0x000fc40003fdd000ULL, 0x000000517881723eULL, 0x000fca00000010ffULL,
0x0000004a00d87306ULL, 0x000ea20000205400ULL, 0x000000e3e000720bULL, 0x002fca0003f7d000ULL,
0x0000000167676812ULL, 0x000fe400078efcffULL, 0x0000004a007d7306ULL, 0x0002f0000020d400ULL,
0x0000003e00a47306ULL, 0x000fe20000009400ULL, 0x000001003f4a7824ULL, 0x002fe200078e00ffULL,
0x000000d8db00720bULL, 0x004fc80003f9d000ULL, 0x00000018ffea7819ULL, 0x000fe4000001144aULL,
0x0000003e009d7306ULL, 0x000fee0000005400ULL, 0x000000017d7d4812ULL, 0x008fe200078efcffULL,
0x0000003e00687306ULL, 0x0003e2000000d400ULL, 0x000000e5e200720bULL, 0x000fce0003f9d000ULL,
0x0000003f00917306ULL, 0x000fe20000009400ULL, 0x000100003e3e7824ULL, 0x002fca00078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x0000003f00907306ULL, 0x000fe20000005400ULL,
0x0000000179794812ULL, 0x000fe400078efcffULL, 0x0000009ea100720bULL, 0x000fca0003f9d000ULL,
0x0000003f00647306ULL, 0x0003f0000000d400ULL, 0x0000003d00e87306ULL, 0x000fe20000209400ULL,
0x000100003f3f7824ULL, 0x002fe200078e00ffULL, 0x000000016c6c4812ULL, 0x000fc800078efcffULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x0000003d00eb7306ULL, 0x000e700000205400ULL,
0x0000003d00747306ULL, 0x0004f0000020d400ULL, 0x0000003c00b77306ULL, 0x000fe20000209400ULL,
0x00000100413d7824ULL, 0x004fe200078e00ffULL, 0x000000ebe800720bULL, 0x002fc80003f9d000ULL,
0x00000018ffb37819ULL, 0x000fe4000001143dULL, 0x0000003c00b67306ULL, 0x000e6e0000205400ULL,
0x0000000174744812ULL, 0x008fe200078efcffULL, 0x0000003c00997306ULL, 0x0005f0000020d400ULL,
0x0000006f00807306ULL, 0x000ee2000020d400ULL, 0x00013000343c7811ULL, 0x004fc400078e20ffULL,
0x000000b6b700720bULL, 0x002fca0003fdd000ULL, 0x0000004b00dc7306ULL, 0x000ff00000209400ULL,
0x0000004b00df7306ULL, 0x000e620000205400ULL, 0x0000000180803812ULL, 0x008fe400078efcffULL,
0x000000a29f00720bULL, 0x000fe20003f7d000ULL, 0x00010000439f7824ULL, 0x000fe200078e00ffULL,
0x0000000199996812ULL, 0x000fc400078efcffULL, 0x0000004f8080723eULL, 0x000fe200000010ffULL,
0x0000004b00777306ULL, 0x000ea2000020d400ULL, 0x00000018ff9f7819ULL, 0x000fce000001149fULL,
0x0000004800e97306ULL, 0x000fe20000209400ULL, 0x000000dfdc00720bULL, 0x002fe40003fbd000ULL,
0x0000000172723812ULL, 0x000fca00078efcffULL, 0x0000004800e67306ULL, 0x000e6c0000205400ULL,
0x0000000177775812ULL, 0x004fe400078efcffULL, 0x0000004800767306ULL, 0x000ea2000020d400ULL,
0x0000009da400720bULL, 0x000fce0003fbd000ULL, 0x0000003e00487306ULL, 0x000fe20000209400ULL,
0x000000e6e900720bULL, 0x002fca0003f7d000ULL, 0x0000000168685812ULL, 0x000fe400078efcffULL,
0x0000003e004b7306ULL, 0x000e6c0000205400ULL, 0x0000000176763812ULL, 0x004fe400078efcffULL,
0x0000003e007e7306ULL, 0x000ea2000020d400ULL, 0x000000909100720bULL, 0x000fce0003f7d000ULL,
0x0000003f00a77306ULL, 0x000fe20000209400ULL, 0x0000004b4800720bULL, 0x002fe40003fbd000ULL,
0x00000084854b723eULL, 0x000fc600000010ffULL, 0x0000000164643812ULL, 0x000fe400078efcffULL,
0x0000003f00aa7306ULL, 0x000e6c0000205400ULL, 0x000000017e7e5812ULL, 0x004fe400078efcffULL,
0x0000003f00887306ULL, 0x0004f0000020d400ULL, 0x000000ea004a7306ULL, 0x000fe20000209400ULL,
0x000000003c3c783bULL, 0x004ea20000000200ULL, 0x000000aaa700720bULL, 0x002fcc0003f7d000ULL,
0x000000ea00937306ULL, 0x000e6e0000205400ULL, 0x0000000188883812ULL, 0x008fe200078efcffULL,
0x000000ea006f7306ULL, 0x000ee2000020d400ULL, 0x000000934a00720bULL, 0x002fce0003f1d000ULL,
0x00000040008b7306ULL, 0x000fe20000009400ULL, 0x00000083864a723eULL, 0x000fce00000010ffULL,
0x00000040008a7306ULL, 0x000e620000005400ULL, 0x000000016f6f0812ULL, 0x008fe400078efcffULL,
0x0000007a7b00720bULL, 0x000fca0003f1d000ULL, 0x00000040005e7306ULL, 0x000722000000d400ULL,
0x000000233c3ca231ULL, 0x084fe400003400ffULL, 0x000000233e3ea231ULL, 0x000fe400003400ffULL,
0x000000223d3da231ULL, 0x080fe400003400ffULL, 0x000000223f3fa231ULL, 0x000fe200003400ffULL,
0x000000b300b27306ULL, 0x000fe20000209400ULL, 0x0001000040407824ULL, 0x008fe200078e00ffULL,
0x0000008a8b00720bULL, 0x002fc40003f9d000ULL, 0x000000015f5f0812ULL, 0x000fe400078efcffULL,
0x00000018ff407819ULL, 0x000fe40000011440ULL, 0x000000b300af7306ULL, 0x000e6e0000205400ULL,
0x000000015e5e4812ULL, 0x010fe200078efcffULL, 0x00000041004d7306ULL, 0x000fe20000009400ULL,
0x0000006e6d00720bULL, 0x000fc40003f9d000ULL, 0x0000005e995e723eULL, 0x000fca00000010ffULL,
0x00000041004e7306ULL, 0x000ea20000005400ULL, 0x000000afb200720bULL, 0x002fca0003f1d000ULL,
0x000000015d5d4812ULL, 0x000fe400078efcffULL, 0x00000041005c7306ULL, 0x0002f0000000d400ULL,
0x0000004000a27306ULL, 0x000fe20000209400ULL, 0x0001000041417824ULL, 0x002fe200078e00ffULL,
0x0000004e4d00720bULL, 0x004fc80003fbd000ULL, 0x00000018ff9b7819ULL, 0x000fe40000011441ULL,
0x0000004000a37306ULL, 0x000e620000205400ULL, 0x00000098a941723eULL, 0x000fcc00000010ffULL,
0x000000015c5c5812ULL, 0x008fe200078efcffULL, 0x00000040009c7306ULL, 0x0005e2000020d400ULL,
0x0000006b6a00720bULL, 0x000fce0003fbd000ULL, 0x000000b300ad7306ULL, 0x000ee2000020d400ULL,
0x0000009aab40723eULL, 0x004fe400000010ffULL, 0x000000a3a200720bULL, 0x002fc60003fdd000ULL,
0x000000015b5b5812ULL, 0x000fe400078efcffULL, 0x0000009b009d7306ULL, 0x000fe20000209400ULL,
0x000000616000720bULL, 0x000fce0003fbd000ULL, 0x0000009b00987306ULL, 0x000e620000205400ULL,
0x00000001adad0812ULL, 0x008fe400078efcffULL, 0x000000019c9c6812ULL, 0x000fc600078efcffULL,
0x0000000159595812ULL, 0x000fe400078efcffULL, 0x0000004200507306ULL, 0x000ff00000009400ULL,
0x0000004200537306ULL, 0x000ea20000005400ULL, 0x000000989d00720bULL, 0x002fce0003f1d000ULL,
0x00000042005a7306ULL, 0x000e70000000d400ULL, 0x0000004300657306ULL, 0x000fe20000009400ULL,
0x000000535000720bULL, 0x004fce0003f7d000ULL, 0x0000004300667306ULL, 0x000eac0000005400ULL,
0x000000015a5a3812ULL, 0x002fe400078efcffULL, 0x0000004300587306ULL, 0x0003f0000000d400ULL,
0x0000009b00947306ULL, 0x000ee2000020d400ULL, 0x000000403c40723cULL, 0x002be2000004181cULL,
0x000000666500720bULL, 0x004fcc0003f9d000ULL, 0x0000008f921c723eULL, 0x020fe200000010ffULL,
0x000000a5008a7306ULL, 0x000fe20000205400ULL, 0x0000008d461d723eULL, 0x000fe400000010ffULL,
0x00013000351e7811ULL, 0x000fe200078e20ffULL, 0x000000443c44723cULL, 0x000be20000041818ULL,
0x0000008c878f723eULL, 0x000fe400000010ffULL, 0x0000000194940812ULL, 0x008fe200078efcffULL,
0x000000a5008d7306ULL, 0x000e620000209400ULL, 0x0000000158584812ULL, 0x000fc400078efcffULL,
0x000000497c18723eULL, 0x020fe200000010ffULL, 0x0000001c3c14723cULL, 0x040b620000041814ULL,
0x0000007f4c19723eULL, 0x000fe200000010ffULL, 0x000000001e1c783bULL, 0x020ea40000000200ULL,
0x000000ac007a7306ULL, 0x000fe80000209400ULL, 0x0000004a3c48723cULL, 0x000be8000004180cULL,
0x000000ac000d7306ULL, 0x020ee20000205400ULL, 0x0000008a8d00720bULL, 0x002fc40003fdd000ULL,
0x0000007e670c723eULL, 0x000fe200000010ffULL, 0x000000183c4c723cULL, 0x040be80000041808ULL,
0x000000a500837306ULL, 0x000e66000020d400ULL, 0x0000007d5208723eULL, 0x020fe200000010ffULL,
0x0000008e3c10723cULL, 0x000f620000041810ULL, 0x000000777009723eULL, 0x000fc400000010ffULL,
0x000000727918723eULL, 0x000fe200000010ffULL, 0x000000ac007b7306ULL, 0x000f22000020d400ULL,
0x0000000d7a00720bULL, 0x008fe40003f1d000ULL, 0x000000885f0d723eULL, 0x000fe200000010ffULL,
0x000000803c50723cULL, 0x000b620000041804ULL, 0x000000717619723eULL, 0x000fe400000010ffULL,
0x0000005cad5f723eULL, 0x000fe200000010ffULL, 0x000000a600707306ULL, 0x000fe20000209400ULL,
0x0000000183836812ULL, 0x002fc400078efcffULL, 0x000000636200720bULL, 0x000fe20003fdd000ULL,
0x000000083c30723cULL, 0x000b640000041830ULL, 0x000000756c04723eULL, 0x020fe200000010ffULL,
0x000000231c1ca231ULL, 0x084fe200003400ffULL, 0x000000746905723eULL, 0x000fe200000010ffULL,
0x000000a6003d7306ULL, 0x000e620000205400ULL, 0x000000017b7b0812ULL, 0x010fe200078efcffULL,
0x000000231e1ea231ULL, 0x000fe200003400ffULL, 0x000000687308723eULL, 0x000fe200000010ffULL,
0x000000221d1da231ULL, 0x080fe200003400ffULL, 0x000000646f09723eULL, 0x000fe200000010ffULL,
0x000000221f1fa231ULL, 0x000fe200003400ffULL, 0x0000005a835a723eULL, 0x000fe200000010ffULL,
0x0000009f003c7306ULL, 0x000fe20000209400ULL, 0x0000000155556812ULL, 0x000fc800078efcffULL,
0x000000081c08723cULL, 0x000b660000041814ULL, 0x0000009f003f7306ULL, 0x000ea20000205400ULL,
0x0000003d7000720bULL, 0x002fc60003f7d000ULL, 0x000000945b15723eULL, 0x020fe200000010ffULL,
0x0000000c1c0c723cULL, 0x000b620000041810ULL, 0x0000009c5d14723eULL, 0x000fe400000010ffULL,
0x000000a600a67306ULL, 0x000e62000020d400ULL, 0x000000587b5b723eULL, 0x000fc800000010ffULL,
0x000000181c18723cULL, 0x000b660000041840ULL, 0x0000009f003e7306ULL, 0x000ee2000020d400ULL,
0x0000003f3c00720bULL, 0x004fc80003f1d000ULL, 0x000000041c04723cULL, 0x000b620000041844ULL,
0x00000001a6a63812ULL, 0x002fc800078efcffULL, 0x000000a659a6723eULL, 0x000fc600000010ffULL,
0x0000005e1c10723cULL, 0x000b620000041848ULL, 0x000000013e3e0812ULL, 0x008fc800078efcffULL,
0x0000003e55a7723eULL, 0x000fc600000010ffULL, 0x000000141c14723cULL, 0x040b70000004184cULL,
0x0000005a1c50723cULL, 0x040b700000041850ULL, 0x000000a61c1c723cULL, 0x000b620000041830ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0186b800ff3c7f8cULL, 0x000e62000c80043fULL,
0x000000ffff3e7224ULL, 0x000fce00078e00ffULL, 0x0000000000307805ULL, 0x020fc40000015200ULL,
0x0186bc00ff337984ULL, 0x000ea40000000800ULL, 0x8000000033ff7812ULL, 0x006fc4000780483dULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fcc0000015200ULL,
0x00000032303f7210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000003f32327211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0186bc00ff337984ULL, 0x000e640000000800ULL, 0x8000000033ff7812ULL, 0x002fe4000780483dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000a027337810ULL, 0x000fca0007ffe0ffULL,
0x000062002a3c7a24ULL, 0x000fe200078e0233ULL, 0x0000039000009947ULL, 0x000fea0003800000ULL,
0x000000012c317824ULL, 0x000fe200078e0221ULL, 0x000000332d307217ULL, 0x000fe40007800000ULL,
0x0000000221437810ULL, 0x000fe20007ffe0ffULL, 0x0000000131327824ULL, 0x000fe200078e022fULL,
0x0000000421457810ULL, 0x000fe20007ffe0ffULL, 0x00000010313d7824ULL, 0x040fe200078e00ffULL,
0x000000f026417812ULL, 0x000fe200078ec0ffULL, 0x0000000130337824ULL, 0x000fe400078e0a33ULL,
0x0000000131307824ULL, 0x000fe200078e023cULL, 0xfffffff03d427812ULL, 0x000fe200078ee232ULL,
0x000000012c327824ULL, 0x040fe200078e0243ULL, 0x000000332c337217ULL, 0x000fe20007800000ULL,
0x00000100ff3d7424ULL, 0x000fc400078e00ffULL, 0x00000001323e7824ULL, 0x040fe400078e022fULL,
0x0000001032477824ULL, 0x000fe400078e00ffULL, 0x00005e0030307625ULL, 0x000fc600078e003dULL,
0xfffffff047447812ULL, 0x000fe200078ee23eULL, 0x000000012c3f7824ULL, 0x000fe200078e0245ULL,
0x00000041303e7210ULL, 0x000fe20007f1e0ffULL, 0x0000000132307824ULL, 0x100fe200078e023cULL,
0x0000000621477810ULL, 0x000fe20007ffe0ffULL, 0x000000013f407824ULL, 0x040fe400078e022fULL,
0x000000103f497824ULL, 0x040fe400078e00ffULL, 0x000000013f327824ULL, 0x000fe400078e023cULL,
0x000000ffff3f7224ULL, 0x000fe200000e0631ULL, 0xfffffff049467812ULL, 0x000fe200078ee240ULL,
0x00005e0030307625ULL, 0x000fc800078e003dULL, 0x000000012c487824ULL, 0x000fe200078e0247ULL,
0x0000004130307210ULL, 0x000fe20007fbe0ffULL, 0x0000000133407824ULL, 0x000fe400078e0a2cULL,
0x00005e0032327625ULL, 0x000fc600078e003dULL, 0x000000404300720cULL, 0x080fe20003f66070ULL,
0x00000001483c7824ULL, 0x000fe200078e023cULL, 0x0000004132327210ULL, 0x000fe20007fde0ffULL,
0x0000000148437824ULL, 0x000fe200078e022fULL, 0x000000402100720cULL, 0x080fe20003f86070ULL,
0x00005e003c3c7625ULL, 0x000fe200078e003dULL, 0x000000404500720cULL, 0x080fe40003f06070ULL,
0x0001400046457811ULL, 0x000fe200078e20ffULL, 0x000000ffff317224ULL, 0x000fe200028e0631ULL,
0x000000404700720cULL, 0x000fe20003fa6070ULL, 0x0000001048487824ULL, 0x000fc400078e00ffULL,
0x000000ffff337224ULL, 0x000fe200030e0633ULL, 0x000000413c3c7210ULL, 0x000fe40007fde0ffULL,
0xfffffff048407812ULL, 0x000fe400078ee243ULL, 0x0001400042417811ULL, 0x000fe200078e20ffULL,
0x000000ffff3d7224ULL, 0x000fe200030e063dULL, 0x0001400044437811ULL, 0x000fe400078e20ffULL,
0x0001400040477811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e417faeULL, 0x0003e8000e101c46ULL, 0x0000000030437faeULL, 0x0003e8000d901c46ULL,
0x0000000032457faeULL, 0x0003e8000c101c46ULL, 0x000000003c477faeULL, 0x0003e2000e901c46ULL,
0x000002d000007947ULL, 0x000fea0003800000ULL, 0x000000012c307824ULL, 0x000fe200078e0221ULL,
0x000000f026417812ULL, 0x000fc600078ec0ffULL, 0x0000000130317824ULL, 0x140fe200078e022fULL,
0x00000004303f7810ULL, 0x040fe20007ffe0ffULL, 0x0000001030407824ULL, 0x040fe200078e00ffULL,
0x0000000230327810ULL, 0x040fe20007ffe0ffULL, 0x00000001303e7824ULL, 0x000fe400078e023cULL,
0x000000013f3d7824ULL, 0x040fe200078e022fULL, 0xfffffff040407812ULL, 0x000fe200078ee231ULL,
0x000000103f447824ULL, 0x000fe200078e00ffULL, 0x0000000630317810ULL, 0x000fe20007ffe0ffULL,
0x0000000132337824ULL, 0x000fc400078e022fULL, 0x0000001032427824ULL, 0x000fe200078e00ffULL,
0xfffffff044447812ULL, 0x000fe200078ee23dULL, 0x00000100ff3d7424ULL, 0x000fe400078e00ffULL,
0x0000000132307824ULL, 0x100fe200078e023cULL, 0xfffffff042427812ULL, 0x000fe200078ee233ULL,
0x000000013f327824ULL, 0x000fe200078e023cULL, 0x0001400044457811ULL, 0x000fe200078e20ffULL,
0x00005e003e3e7625ULL, 0x000fc800078e003dULL, 0x00000001313c7824ULL, 0x040fe200078e023cULL,
0x000000413e3e7210ULL, 0x000fe20007f7e0ffULL, 0x0000000131437824ULL, 0x040fe400078e022fULL,
0x0000001031467824ULL, 0x000fe400078e00ffULL, 0x00005e0030307625ULL, 0x000fc600078e003dULL,
0xfffffff046467812ULL, 0x000fe200078ee243ULL, 0x00005e0032327625ULL, 0x000fe200078e003dULL,
0x0000004130307210ULL, 0x000fe40007f1e0ffULL, 0x0001400042437811ULL, 0x000fe200078e20ffULL,
0x00005e003c3c7625ULL, 0x000fe200078e003dULL, 0x0001400046477811ULL, 0x000fc600078e20ffULL,
0x000000ffff3f7224ULL, 0x000fe200018e063fULL, 0x0000004132327210ULL, 0x080fe20007f7e0ffULL,
0x000000ffff317224ULL, 0x000fe200000e0631ULL, 0x000000413c3c7210ULL, 0x000fe40007f9e0ffULL,
0x0001400040417811ULL, 0x000fe200078e20ffULL, 0x000000ffff337224ULL, 0x000fe400018e0633ULL,
0x000000ffff3d7224ULL, 0x000fe400020e063dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e417faeULL, 0x0003e8000b901c46ULL, 0x0000000030437faeULL, 0x0003e8000b901c46ULL,
0x0000000032457faeULL, 0x0003e8000b901c46ULL, 0x000000003c477faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0186a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0186a800ff3c7f8cULL, 0x000e64000c80043fULL, 0x0000000000307805ULL, 0x000fc40000015200ULL,
0x0186b400ff337984ULL, 0x000ea40000000800ULL, 0x8000000033ff7812ULL, 0x004fc40007804857ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3c7224ULL, 0x002fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x000fcc0000015200ULL, 0x00000032303f7210ULL, 0x000fca0007f1e1ffULL,
0x0000000133337824ULL, 0x000fe200000e0e31ULL, 0x003d09003f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff327819ULL, 0x000fc80000011433ULL,
0x0000003f32327211ULL, 0x000fca00078110ffULL, 0x000000ffff337224ULL, 0x000fca00000e0633ULL,
0x0000000232327819ULL, 0x000fc80000001233ULL, 0x000000320000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0186b400ff337984ULL, 0x000e640000000800ULL,
0x8000000033ff7812ULL, 0x002fe40007804857ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000018000007945ULL, 0x000fe20003800000ULL, 0x0000016000002947ULL, 0x000fea0003800000ULL,
0x00000024ff22723eULL, 0x000fe400000010ffULL, 0x00000002ff317819ULL, 0x000fe4000001162fULL,
0x0000541022307816ULL, 0x000fe20000000022ULL, 0x000103927f007947ULL, 0x000fea000b800000ULL,
0x00001f3130237589ULL, 0x0002a400000e0000ULL, 0x0000000831597810ULL, 0x002fe20007ffe0ffULL,
0x000103e27f007947ULL, 0x000fea000b800000ULL, 0x00001f5930227589ULL, 0x0002e400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001031597810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff587224ULL, 0x000fe200078e0030ULL, 0x00010c9000407802ULL, 0x000fe20000000f00ULL,
0x0000001fff5a7424ULL, 0x000fc400078e00ffULL, 0xffffffffff5b7424ULL, 0x000fc400078e00ffULL,
0x00010ce000007944ULL, 0x00cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001831597810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff587224ULL, 0x004fe200078e0030ULL,
0x00010d0000407802ULL, 0x000fe20000000f00ULL, 0x0000001fff5a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff5b7424ULL, 0x000fc400078e00ffULL, 0x00010c7000007944ULL, 0x008fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000003840783bULL, 0x000f280000004200ULL, 0x000000003948783bULL, 0x000fe80000004200ULL,
0x000000003630783bULL, 0x002e680000004200ULL, 0x000000003744783bULL, 0x000ee20000004200ULL,
0x00000018ff4d7819ULL, 0x010fe20000011441ULL, 0x0000004000cc7306ULL, 0x000fe20000009400ULL,
0x00000018ff3c7819ULL, 0x000fe20000011440ULL, 0x0000010040687824ULL, 0x000fe200078e00ffULL,
0x00000018ff4f7819ULL, 0x000fc40000011442ULL, 0x00000018ff567819ULL, 0x000fe40000011443ULL,
0x00000018ff597819ULL, 0x002fe20000011433ULL, 0x0000004d00c87306ULL, 0x000fe20000209400ULL,
0x00000018ff687819ULL, 0x000fe40000011468ULL, 0x00000018ff6f7819ULL, 0x008fe40000011446ULL,
0x00000018ff737819ULL, 0x000fe40000011447ULL, 0x00000018ff6c7819ULL, 0x000fe20000011445ULL,
0x0000004d00a97306ULL, 0x000ff00000205400ULL, 0x0000004d003f7306ULL, 0x0003f0000020d400ULL,
0x0000003c00c77306ULL, 0x000fe20000209400ULL, 0x00000018ff4d7819ULL, 0x002fce0000011449ULL,
0x0000004d00bb7306ULL, 0x000ff00000209400ULL, 0x0000004d00bc7306ULL, 0x000ff00000205400ULL,
0x0000004d00757306ULL, 0x0003f0000020d400ULL, 0x0000003c00967306ULL, 0x000ee20000205400ULL,
0x00000018ff4d7819ULL, 0x002fce0000011431ULL, 0x0000004d00917306ULL, 0x000ff00000209400ULL,
0x0000004d00907306ULL, 0x000fe20000205400ULL, 0x00000096c700720bULL, 0x008fce0003f9d000ULL,
0x0000004d00607306ULL, 0x000ff0000020d400ULL, 0x0000003c003e7306ULL, 0x0002f0000020d400ULL,
0x0000006f005d7306ULL, 0x000fe20000209400ULL, 0x00000018ff3c7819ULL, 0x002fce0000011448ULL,
0x0000006f005e7306ULL, 0x000fe20000205400ULL, 0x000000013e3e4812ULL, 0x008fce00078efcffULL,
0x0000006f004d7306ULL, 0x0003f0000020d400ULL, 0x0000003c00c07306ULL, 0x000fe20000209400ULL,
0x00000100416f7824ULL, 0x002fca00078e00ffULL, 0x00000018ff6f7819ULL, 0x000fe4000001146fULL,
0x0000003c00c17306ULL, 0x000ff00000205400ULL, 0x0000003c007f7306ULL, 0x0003f0000020d400ULL,
0x0000004f00c27306ULL, 0x000fe20000209400ULL, 0x00000018ff3c7819ULL, 0x002fce0000011430ULL,
0x0000004f00c57306ULL, 0x000ff00000205400ULL, 0x0000004f008a7306ULL, 0x0003f0000020d400ULL,
0x0000005600c37306ULL, 0x000fe20000209400ULL, 0x00000018ff4f7819ULL, 0x002fce000001144aULL,
0x0000005600ba7306ULL, 0x000ff00000205400ULL, 0x0000005600847306ULL, 0x0003f0000020d400ULL,
0x0000003c00a07306ULL, 0x000fe20000209400ULL, 0x00000018ff567819ULL, 0x002fce000001144bULL,
0x0000003c00a37306ULL, 0x000ff00000205400ULL, 0x0000003c00647306ULL, 0x0003f0000020d400ULL,
0x0000006f00d07306ULL, 0x000fe20000209400ULL, 0x00000018ff3c7819ULL, 0x002fce0000011444ULL,
0x0000006f00cf7306ULL, 0x000e700000205400ULL, 0x0000004f00b27306ULL, 0x000ff00000209400ULL,
0x0000004f00ad7306ULL, 0x000fe20000205400ULL, 0x000000cfd000720bULL, 0x002fce0003f7d000ULL,
0x0000004f00727306ULL, 0x0003f0000020d400ULL, 0x00000040006d7306ULL, 0x000ee20000005400ULL,
0x00000018ff4f7819ULL, 0x002fce0000011432ULL, 0x00000040009e7306ULL, 0x000330000000d400ULL,
0x0000005600af7306ULL, 0x000fe20000209400ULL, 0x0001000040407824ULL, 0x002fe200078e00ffULL,
0x0000006dcc00720bULL, 0x008fcc0003f1d000ULL, 0x0000005600b07306ULL, 0x000fee0000205400ULL,
0x000000019e9e0812ULL, 0x010fe200078efcffULL, 0x00000056006b7306ULL, 0x000ff0000020d400ULL,
0x0000005900767306ULL, 0x000ff00000209400ULL, 0x0000005900777306ULL, 0x000ff00000205400ULL,
0x0000005900587306ULL, 0x004ff0000020d400ULL, 0x0000003c00657306ULL, 0x000ff00000209400ULL,
0x0000003c00667306ULL, 0x000ff00000205400ULL, 0x0000003c00567306ULL, 0x000ff0000020d400ULL,
0x0000007300597306ULL, 0x000ff00000209400ULL, 0x00000073005a7306ULL, 0x000ff00000205400ULL,
0x00000073003c7306ULL, 0x0003f0000020d400ULL, 0x0000004f007b7306ULL, 0x000fe20000209400ULL,
0x0000010042737824ULL, 0x002fca00078e00ffULL, 0x00000018ff737819ULL, 0x000fe40000011473ULL,
0x0000004f007e7306ULL, 0x000ff00000205400ULL, 0x0000004f005c7306ULL, 0x000ff0000020d400ULL,
0x0000006c00617306ULL, 0x000ff00000209400ULL, 0x0000006c00627306ULL, 0x000ff00000205400ULL,
0x0000006c004f7306ULL, 0x0003f0000020d400ULL, 0x0000006800ce7306ULL, 0x000fe20000209400ULL,
0x00000018ff6c7819ULL, 0x002fce0000011440ULL, 0x0000006800cb7306ULL, 0x000e700000205400ULL,
0x0000006f00a87306ULL, 0x000eb0000020d400ULL, 0x0000004200c67306ULL, 0x000fe20000009400ULL,
0x000000cbce00720bULL, 0x002fce0003fdd000ULL, 0x0000004200877306ULL, 0x000e620000005400ULL,
0x00000001a8a83812ULL, 0x004fce00078efcffULL, 0x0000006c00cd7306ULL, 0x000ff00000209400ULL,
0x0000006c00407306ULL, 0x000ea20000205400ULL, 0x00000087c600720bULL, 0x002fce0003f7d000ULL,
0x0000006c009d7306ULL, 0x0002f0000020d400ULL, 0x0000007300d47306ULL, 0x000fe20000209400ULL,
0x00000100436c7824ULL, 0x002fe200078e00ffULL, 0x00000040cd00720bULL, 0x004fc40003fbd000ULL,
0x000130003a407811ULL, 0x000fe400078e20ffULL, 0x00000018ff6c7819ULL, 0x000fe4000001146cULL,
0x0000007300d17306ULL, 0x000e6e0000205400ULL, 0x000000019d9d5812ULL, 0x008fe200078efcffULL,
0x0000004300c47306ULL, 0x000fe20000009400ULL, 0x000000a9c800720bULL, 0x000fc40003fbd000ULL,
0x0000009d3e3e723eULL, 0x000fca00000010ffULL, 0x0000004300b37306ULL, 0x000fe20000005400ULL,
0x000000d1d400720bULL, 0x002fca0003f9d000ULL, 0x000000013f3f5812ULL, 0x000fe400078efcffULL,
0x00000043008e7306ULL, 0x0003f0000000d400ULL, 0x0000006800a57306ULL, 0x000ea2000020d400ULL,
0x0001000043437824ULL, 0x002fca00078e00ffULL, 0x00000018ff6f7819ULL, 0x000fe40000011443ULL,
0x0000004100ca7306ULL, 0x000ff00000009400ULL, 0x0000004100c97306ULL, 0x000e620000005400ULL,
0x00000001a5a56812ULL, 0x004fce00078efcffULL, 0x00000041009b7306ULL, 0x0004f0000000d400ULL,
0x00000042008f7306ULL, 0x0008e2000000d400ULL, 0x0001000041417824ULL, 0x004fe200078e00ffULL,
0x000000c9ca00720bULL, 0x002fc80003fdd000ULL, 0x00000018ff687819ULL, 0x000fe40000011441ULL,
0x0000006f00d87306ULL, 0x000fe20000209400ULL, 0x0001000042427824ULL, 0x010fcc00078e00ffULL,
0x000000019b9b6812ULL, 0x008fe200078efcffULL, 0x0000006f00437306ULL, 0x000e620000205400ULL,
0x000000018f8f3812ULL, 0x000fce00078efcffULL, 0x0000007300927306ULL, 0x0004f0000020d400ULL,
0x0000006c00d67306ULL, 0x000fe20000209400ULL, 0x00000043d800720bULL, 0x002fe20003f7d000ULL,
0x0000010048737824ULL, 0x004fca00078e00ffULL, 0x00000018ff737819ULL, 0x000fe20000011473ULL,
0x0000006c00d37306ULL, 0x000e620000205400ULL, 0x0000000192924812ULL, 0x008fe400078efcffULL,
0x000000c5c200720bULL, 0x000fca0003f9d000ULL, 0x0000006c00937306ULL, 0x0004f0000020d400ULL,
0x0000006800417306ULL, 0x000fe20000209400ULL, 0x00000100496c7824ULL, 0x004fe200078e00ffULL,
0x000000d3d600720bULL, 0x002fc40003fdd000ULL, 0x000000018a8a4812ULL, 0x000fe400078efcffULL,
0x00000018ff6c7819ULL, 0x000fe4000001146cULL, 0x0000006800d27306ULL, 0x000e6e0000205400ULL,
0x0000000193936812ULL, 0x008fe200078efcffULL, 0x00000068009c7306ULL, 0x0004e2000020d400ULL,
0x000000bac300720bULL, 0x000fce0003fdd000ULL, 0x0000004900bd7306ULL, 0x000fe20000009400ULL,
0x00000018ff687819ULL, 0x004fe40000011442ULL, 0x000000d24100720bULL, 0x002fc60003f1d000ULL,
0x0000000184846812ULL, 0x000fe400078efcffULL, 0x0000004900be7306ULL, 0x000ff00000005400ULL,
0x00000049007d7306ULL, 0x0003e2000000d400ULL, 0x000000019c9c0812ULL, 0x008fc400078efcffULL,
0x000000b3c400720bULL, 0x000fe40003f1d000ULL, 0x0000009c3f3f723eULL, 0x000fc600000010ffULL,
0x0000006f00897306ULL, 0x0004e2000020d400ULL, 0x0001000049497824ULL, 0x002fce00078e00ffULL,
0x0000006800d57306ULL, 0x000fe20000209400ULL, 0x00000018ff6f7819ULL, 0x004fe20000011449ULL,
0x000001004a497824ULL, 0x000fe200078e00ffULL, 0x000000018e8e0812ULL, 0x000fca00078efcffULL,
0x0000006800427306ULL, 0x000e620000205400ULL, 0x0000000189893812ULL, 0x008fe400078efcffULL,
0x000000bebd00720bULL, 0x000fca0003f7d000ULL, 0x0000006c00d97306ULL, 0x000ff00000209400ULL,
0x0000006c00dc7306ULL, 0x000ea20000205400ULL, 0x00000042d500720bULL, 0x002fe40003fbd000ULL,
0x000000017d7d3812ULL, 0x000fe200078efcffULL, 0x000000004040783bULL, 0x000e680000000200ULL,
0x0000006c00867306ULL, 0x0007f0000020d400ULL, 0x00000068008b7306ULL, 0x000f22000020d400ULL,
0x00000018ff6c7819ULL, 0x008fc40000011449ULL, 0x000000dcd900720bULL, 0x004fca0003f9d000ULL,
0x0000004800bf7306ULL, 0x000ff00000009400ULL, 0x0000004800a67306ULL, 0x000ea20000005400ULL,
0x000000018b8b5812ULL, 0x010fe400078efcffULL, 0x0000000186864812ULL, 0x000fc400078efcffULL,
0x000000bcbb00720bULL, 0x000fe40003f9d000ULL, 0x0000008b8a8a723eULL, 0x000fe200000010ffULL,
0x0000006c00e77306ULL, 0x000fe20000209400ULL, 0x00000089848b723eULL, 0x000fe200000010ffULL,
0x000000234040a231ULL, 0x082fe400003400ffULL, 0x000000234242a231ULL, 0x000fc800003400ffULL,
0x0000006c00ea7306ULL, 0x000e620000205400ULL, 0x000000a6bf00720bULL, 0x004fe20003fbd000ULL,
0x000000224141a231ULL, 0x080fe200003400ffULL, 0x0000000175754812ULL, 0x000fe200078efcffULL,
0x000000224343a231ULL, 0x000fc800003400ffULL, 0x0000004800827306ULL, 0x0004e6000000d400ULL,
0x0000003e4004723cULL, 0x040fea0000041804ULL, 0x0000004a00b47306ULL, 0x000fe20000009400ULL,
0x0001000048487824ULL, 0x004fe200078e00ffULL, 0x000000eae700720bULL, 0x002fe20003f7d000ULL,
0x0000008a400c723cULL, 0x000fe6000004180cULL, 0x00000018ff687819ULL, 0x000fc40000011448ULL,
0x0000004a00b97306ULL, 0x000fe20000005400ULL, 0x0000000182825812ULL, 0x008fce00078efcffULL,
0x0000004a00787306ULL, 0x0003f0000000d400ULL, 0x0000007300d77306ULL, 0x000fe20000209400ULL,
0x000100004a4a7824ULL, 0x002fca00078e00ffULL, 0x00000018ff4a7819ULL, 0x000fe4000001144aULL,
0x0000007300da7306ULL, 0x000e700000205400ULL, 0x0000007300857306ULL, 0x0004f0000020d400ULL,
0x0000004b00ae7306ULL, 0x000fe20000009400ULL, 0x000001004b737824ULL, 0x004fe200078e00ffULL,
0x000000dad700720bULL, 0x002fc80003f1d000ULL, 0x00000018ff737819ULL, 0x000fe40000011473ULL,
0x0000004b00ab7306ULL, 0x000fee0000005400ULL, 0x0000000185850812ULL, 0x008fe200078efcffULL,
0x0000004b006e7306ULL, 0x0003e2000000d400ULL, 0x000000c1c000720bULL, 0x000fce0003f1d000ULL,
0x0000006800de7306ULL, 0x000fe20000209400ULL, 0x000100004b4b7824ULL, 0x002fca00078e00ffULL,
0x00000018ff4b7819ULL, 0x000fe4000001144bULL, 0x0000006800db7306ULL, 0x000e620000205400ULL,
0x000000017f7f0812ULL, 0x000fce00078efcffULL, 0x0000006800887306ULL, 0x0004f0000020d400ULL,
0x0000003000b17306ULL, 0x000fe20000009400ULL, 0x0000010030687824ULL, 0x004fe200078e00ffULL,
0x000000dbde00720bULL, 0x002fc80003fdd000ULL, 0x00000018ff687819ULL, 0x000fe40000011468ULL,
0x0000003000ac7306ULL, 0x000fee0000005400ULL, 0x0000000188886812ULL, 0x008fe200078efcffULL,
0x0000003000697306ULL, 0x0003e2000000d400ULL, 0x000000b9b400720bULL, 0x000fce0003fdd000ULL,
0x0000006c00497306ULL, 0x000ea2000020d400ULL, 0x0001000030307824ULL, 0x002fca00078e00ffULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x0000006f00e27306ULL, 0x000fe20000209400ULL,
0x0000000178786812ULL, 0x000fe400078efcffULL, 0x000000adb200720bULL, 0x000fca0003fdd000ULL,
0x0000006f00dd7306ULL, 0x000e620000205400ULL, 0x0000000149493812ULL, 0x004fe400078efcffULL,
0x000000acb100720bULL, 0x000fe20003f7d000ULL, 0x0000010047b17824ULL, 0x000fe200078e00ffULL,
0x000000784978723eULL, 0x000fc600000010ffULL, 0x0000004a00e07306ULL, 0x000fe20000209400ULL,
0x0000000172726812ULL, 0x000fe400078efcffULL, 0x00000018ffb17819ULL, 0x000fca00000114b1ULL,
0x0000004a00df7306ULL, 0x000ea20000205400ULL, 0x000000dde200720bULL, 0x002fe40003fbd000ULL,
0x0000000169693812ULL, 0x000fca00078efcffULL, 0x0000004a00817306ULL, 0x0002f0000020d400ULL,
0x0000004b00e47306ULL, 0x000fe20000209400ULL, 0x00000100314a7824ULL, 0x002fe200078e00ffULL,
0x000000dfe000720bULL, 0x004fc80003f9d000ULL, 0x00000018ff4a7819ULL, 0x000fe4000001144aULL,
0x0000004b00e17306ULL, 0x000fee0000205400ULL, 0x0000000181814812ULL, 0x008fe200078efcffULL,
0x0000004b007a7306ULL, 0x0003f0000020d400ULL, 0x0000007300e57306ULL, 0x000fe20000209400ULL,
0x00000100324b7824ULL, 0x002fce00078e00ffULL, 0x0000007300e87306ULL, 0x000e700000205400ULL,
0x0000007300797306ULL, 0x000eb0000020d400ULL, 0x0000003100a17306ULL, 0x000fe20000009400ULL,
0x000000e8e500720bULL, 0x002fce0003f1d000ULL, 0x0000003100a27306ULL, 0x000e6c0000005400ULL,
0x0000000179790812ULL, 0x004fe400078efcffULL, 0x0000003100637306ULL, 0x0004e2000000d400ULL,
0x000000b0af00720bULL, 0x000fe20003f1d000ULL, 0x0000010046af7824ULL, 0x000fc400078e00ffULL,
0x0001000046b07824ULL, 0x000fc600078e00ffULL, 0x00000018ffaf7819ULL, 0x000fe200000114afULL,
0x0000003000b67306ULL, 0x000fe20000209400ULL, 0x0001000031317824ULL, 0x004fe200078e00ffULL,
0x000000a2a100720bULL, 0x002fe40003fdd000ULL, 0x00000018ffb07819ULL, 0x000fe400000114b0ULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x0000003000b57306ULL, 0x000e620000205400ULL,
0x000000016b6b0812ULL, 0x000fcc00078efcffULL, 0x0000000163636812ULL, 0x008fe200078efcffULL,
0x0000003000737306ULL, 0x0005f0000020d400ULL, 0x0000006f00487306ULL, 0x000ee2000020d400ULL,
0x00000018ff307819ULL, 0x004fe2000001144bULL, 0x00000100334b7824ULL, 0x000fe200078e00ffULL,
0x000000b5b600720bULL, 0x002fc80003f1d000ULL, 0x00000018ffe97819ULL, 0x000fe2000001144bULL,
0x0000004a00b77306ULL, 0x000ff00000209400ULL, 0x0000004a00b87306ULL, 0x000e620000205400ULL,
0x0000000148485812ULL, 0x008fc400078efcffULL, 0x000000abae00720bULL, 0x000fe20003fbd000ULL,
0x0001000047ae7824ULL, 0x000fe200078e00ffULL, 0x0000000173730812ULL, 0x000fc600078efcffULL,
0x0000003000947306ULL, 0x000fe20000209400ULL, 0x00000018ffae7819ULL, 0x000fce00000114aeULL,
0x0000003000957306ULL, 0x000fe20000205400ULL, 0x000000b8b700720bULL, 0x002fe40003f7d000ULL,
0x000000016e6e5812ULL, 0x000fe400078efcffULL, 0x000000e1e400720bULL, 0x000fe40003fbd000ULL,
0x0000006e7979723eULL, 0x000fe200000010ffULL, 0x00000030006c7306ULL, 0x0003ec000020d400ULL,
0x000000784050723cULL, 0x000fe40000041850ULL, 0x0000006800e67306ULL, 0x000fe20000209400ULL,
0x0000010044307824ULL, 0x002fe200078e00ffULL, 0x000000017a7a5812ULL, 0x000fc400078efcffULL,
0x000000a3a000720bULL, 0x000fe40003fbd000ULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x0000006800e37306ULL, 0x000e700000205400ULL, 0x0000003200a47306ULL, 0x000fe20000009400ULL,
0x0000000164645812ULL, 0x000fc800078efcffULL, 0x000000736464723eULL, 0x000fc600000010ffULL,
0x00000032009f7306ULL, 0x000fe20000005400ULL, 0x000000e3e600720bULL, 0x002fce0003f9d000ULL,
0x00000032005f7306ULL, 0x0003f0000000d400ULL, 0x0000003300987306ULL, 0x000fe20000009400ULL,
0x0001000032327824ULL, 0x002fca00078e00ffULL, 0x00000018ff327819ULL, 0x000fe40000011432ULL,
0x0000003300977306ULL, 0x000e700000005400ULL, 0x00000033005b7306ULL, 0x0004f0000000d400ULL,
0x0000003100a77306ULL, 0x000fe20000209400ULL, 0x0001000033337824ULL, 0x004fe200078e00ffULL,
0x000000979800720bULL, 0x002fc80003f1d000ULL, 0x00000018ff337819ULL, 0x000fe40000011433ULL,
0x0000003100aa7306ULL, 0x000e6e0000205400ULL, 0x000000015b5b0812ULL, 0x008fe200078efcffULL,
0x00000031006f7306ULL, 0x0004f0000020d400ULL, 0x0000003000b37306ULL, 0x000fe20000209400ULL,
0x0000010045317824ULL, 0x004fe200078e00ffULL, 0x000000aaa700720bULL, 0x002fc80003fdd000ULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x0000003000ba7306ULL, 0x000fee0000205400ULL,
0x000000016f6f6812ULL, 0x008fe200078efcffULL, 0x0000003000a67306ULL, 0x0003f0000020d400ULL,
0x0000004a00747306ULL, 0x000ea2000020d400ULL, 0x000130003b307811ULL, 0x002fce00078e20ffULL,
0x00000068007c7306ULL, 0x000e70000020d400ULL, 0x00000032004a7306ULL, 0x000fe20000209400ULL,
0x0000000174743812ULL, 0x004fe400078efcffULL, 0x000000909100720bULL, 0x000fca0003f7d000ULL,
0x00000032004b7306ULL, 0x000fe20000205400ULL, 0x000000017c7c4812ULL, 0x002fe400078efcffULL,
0x0000009fa400720bULL, 0x000fe40003f9d000ULL, 0x000000697c7c723eULL, 0x000fc600000010ffULL,
0x00000032006d7306ULL, 0x000fe2000020d400ULL, 0x0000000160603812ULL, 0x000fce00078efcffULL,
0x0000003300967306ULL, 0x000fe20000209400ULL, 0x000000015f5f4812ULL, 0x000fe400078efcffULL,
0x0000007e7b00720bULL, 0x000fca0003f9d000ULL, 0x0000003300a97306ULL, 0x000e700000205400ULL,
0x0000003300877306ULL, 0x000ea2000020d400ULL, 0x000000015c5c4812ULL, 0x000fe400078efcffULL,
0x000000bab300720bULL, 0x000fca0003f9d000ULL, 0x0000003100bd7306ULL, 0x000fe20000209400ULL,
0x000000a99600720bULL, 0x002fce0003f1d000ULL, 0x0000003100bc7306ULL, 0x000fe20000205400ULL,
0x00000001a6a64812ULL, 0x000fe400078efcffULL, 0x000000666500720bULL, 0x000fe40003f9d000ULL,
0x0000006f6065723eULL, 0x000fe400000010ffULL, 0x0000000187870812ULL, 0x004fe200078efcffULL,
0x0000003100b47306ULL, 0x0003f0000020d400ULL, 0x000000e9008c7306ULL, 0x000fe20000209400ULL,
0x000000003030783bULL, 0x002e620000000200ULL, 0x0000000156564812ULL, 0x000fc400078efcffULL,
0x0000005e5d00720bULL, 0x000fc80003f9d000ULL, 0x000000e9008d7306ULL, 0x000eb00000205400ULL,
0x0000004400997306ULL, 0x000fe20000009400ULL, 0x000000014d4d4812ULL, 0x000fce00078efcffULL,
0x00000044009a7306ULL, 0x000ee20000005400ULL, 0x0000008d8c00720bULL, 0x004fce0003f7d000ULL,
0x0000004400577306ULL, 0x0005f0000000d400ULL, 0x000000e900687306ULL, 0x000f22000020d400ULL,
0x0001000044447824ULL, 0x004fe200078e00ffULL, 0x000000233030a231ULL, 0x082fe200003400ffULL,
0x0000009a9900720bULL, 0x008fe20003fbd000ULL, 0x000000233232a231ULL, 0x000fc400003400ffULL,
0x00000018ff447819ULL, 0x000fe20000011444ULL, 0x000000223131a231ULL, 0x080fe200003400ffULL,
0x0000004500807306ULL, 0x000fe20000009400ULL, 0x000000223333a231ULL, 0x000fe200003400ffULL,
0x000000959400720bULL, 0x000fcc0003f5d000ULL, 0x0000004500837306ULL, 0x000e620000005400ULL,
0x0000000168683812ULL, 0x010fe400078efcffULL, 0x000000777600720bULL, 0x000fe40003f7d000ULL,
0x0000000157575812ULL, 0x000fe400078efcffULL, 0x000000016c6c2812ULL, 0x000fe200078efcffULL,
0x0000004500557306ULL, 0x0004e2000000d400ULL, 0x0000004b4a00720bULL, 0x000fe40003f5d000ULL,
0x000000887f4a723eULL, 0x000fc400000010ffULL, 0x00000048754b723eULL, 0x000fe400000010ffULL,
0x00000057a6a6723eULL, 0x000fe200000010ffULL, 0x0000004600707306ULL, 0x000fe20000009400ULL,
0x0001000045457824ULL, 0x004fe200078e00ffULL, 0x000000838000720bULL, 0x002fe40003fdd000ULL,
0x0000000158583812ULL, 0x000fe200078efcffULL, 0x0000004a4048723cULL, 0x000be20000041814ULL,
0x000000bcbd00720bULL, 0x000fe40003f7d000ULL, 0x0000004600717306ULL, 0x000e620000005400ULL,
0x000000016d6d2812ULL, 0x000fc600078efcffULL, 0x0000005f6c14723eULL, 0x020fe400000010ffULL,
0x0000005b6815723eULL, 0x000fe400000010ffULL, 0x00000046004e7306ULL, 0x000522000000d400ULL,
0x0000000155556812ULL, 0x008fe400078efcffULL, 0x00000001b4b43812ULL, 0x000fe400078efcffULL,
0x000000626100720bULL, 0x000fe40003fdd000ULL, 0x00000055b4a7723eULL, 0x000fe200000010ffULL,
0x0000004400ac7306ULL, 0x000fe20000209400ULL, 0x00000018ff467819ULL, 0x004fc40000011445ULL,
0x0000009ba845723eULL, 0x000fe400000010ffULL, 0x000000717000720bULL, 0x002fc60003f5d000ULL,
0x0000004400ad7306ULL, 0x000e640000205400ULL, 0x000000014f4f6812ULL, 0x000fcc00078efcffULL,
0x0000004400ab7306ULL, 0x0004e4000020d400ULL, 0x000000014e4e2812ULL, 0x010fcc00078efcffULL,
0x0000004600a07306ULL, 0x000fe20000209400ULL, 0x0000009ea544723eULL, 0x004fe400000010ffULL,
0x000000adac00720bULL, 0x002fca0003fbd000ULL, 0x000000444018723cULL, 0x000be20000041818ULL,
0x00000046009b7306ULL, 0x000e6c0000205400ULL, 0x0000008f9244723eULL, 0x020fe400000010ffULL,
0x0000008e9345723eULL, 0x000fe200000010ffULL, 0x000000af00907306ULL, 0x000fe20000209400ULL,
0x00000001abab5812ULL, 0x008fca00078efcffULL, 0x000000444008723cULL, 0x000b620000041808ULL,
0x0000009ba000720bULL, 0x002fe20003f7d000ULL, 0x000000af003f7306ULL, 0x000e6a0000205400ULL,
0x000000828544723eULL, 0x020fe400000010ffULL, 0x0000007d8645723eULL, 0x000fe200000010ffULL,
0x0000004700677306ULL, 0x000fe20000009400ULL, 0x00000063747d723eULL, 0x000fce00000010ffULL,
0x00000047006a7306ULL, 0x000ea20000005400ULL, 0x0000003f9000720bULL, 0x002fca0003fbd000ULL,
0x000000143014723cULL, 0x000be40000041808ULL, 0x00000047004c7306ULL, 0x000e6a000000d400ULL,
0x000000ab5608723eULL, 0x020fc600000010ffULL, 0x0000004600987306ULL, 0x000722000020d400ULL,
0x0000006a6700720bULL, 0x004fce0003f1d000ULL, 0x000000af00837306ULL, 0x000ea2000020d400ULL,
0x000000444044723cULL, 0x008b6a0000041810ULL, 0x000000014c4c0812ULL, 0x002fe400078efcffULL,
0x000000817210723eULL, 0x020fe200000010ffULL, 0x000000b100807306ULL, 0x000fe20000209400ULL,
0x0000007a6b11723eULL, 0x000fc400000010ffULL, 0x0000000198983812ULL, 0x010fe400078efcffULL,
0x0000005a5900720bULL, 0x000fe40003f7d000ULL, 0x0000000183835812ULL, 0x004fe200078efcffULL,
0x000000104040723cULL, 0x000b62000004181cULL, 0x000000b100137306ULL, 0x000e620000205400ULL,
0x000000984f09723eULL, 0x000fca00000010ffULL, 0x0000006d5c10723eULL, 0x020fe200000010ffULL,
0x0000007c301c723cULL, 0x000f620000041818ULL, 0x000000b0003e7306ULL, 0x000fe20000209400ULL,
0x000000013c3c3812ULL, 0x000fe400078efcffULL, 0x000000875811723eULL, 0x000fc800000010ffULL,
0x000000643018723cULL, 0x000b620000041804ULL, 0x000000b000637306ULL, 0x000ea20000205400ULL,
0x000000138000720bULL, 0x002fca0003fdd000ULL, 0x0000004e8304723eULL, 0x020fe200000010ffULL,
0x000000103010723cULL, 0x040b62000004180cULL, 0x000000ae00607306ULL, 0x000fee0000209400ULL,
0x000000a6300c723cULL, 0x000b620000041844ULL, 0x000000ae00057306ULL, 0x000e620000205400ULL,
0x000000633e00720bULL, 0x004fcc0003fbd000ULL, 0x000000083008723cULL, 0x000b620000041848ULL,
0x000000b100717306ULL, 0x000eb0000020d400ULL, 0x000000b000b07306ULL, 0x000ee2000020d400ULL,
0x000000056000720bULL, 0x002fce0003f5d000ULL, 0x000000ae00b17306ULL, 0x000e62000020d400ULL,
0x0000000171716812ULL, 0x004fc800078efcffULL, 0x0000004c7105723eULL, 0x000fe400000010ffULL,
0x00000001b0b05812ULL, 0x008fc800078efcffULL, 0x000000b04db0723eULL, 0x000fe200000010ffULL,
0x000000043004723cULL, 0x000b620000041850ULL, 0x00000001b1b12812ULL, 0x002fc800078efcffULL,
0x000000b13cb1723eULL, 0x000fce00000010ffULL, 0x000000b03030723cULL, 0x000b620000041840ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0186b800ff3e7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000a0273c7810ULL, 0x000fe20007ffe0ffULL, 0x01869800ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff427224ULL, 0x022fe400078e003fULL, 0x0000002d3c00720cULL, 0x000fe20003f06070ULL,
0x000000ffff3c7224ULL, 0x000fd800078e0054ULL, 0x00005d6000000947ULL, 0x000fea0003800000ULL,
0x00000000003e7805ULL, 0x000fc40000015200ULL, 0x0186bc00ff417984ULL, 0x000e640000000800ULL,
0x8000000041ff7812ULL, 0x002fe40007804842ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff447224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000407805ULL, 0x000fcc0000015200ULL,
0x000000403e437210ULL, 0x000fca0007f1e1ffULL, 0x0000000141417824ULL, 0x000fe200000e0e3fULL,
0x003d09004300780cULL, 0x000fc80003f06070ULL, 0x000000ff4100720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404300780cULL, 0x000fc80003f06070ULL,
0x000000ff4100720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3c7819ULL, 0x000fc80000011441ULL, 0x000000433c3c7211ULL, 0x000fca00078110ffULL,
0x000000ffff417224ULL, 0x000fca00000e0641ULL, 0x000000023c3c7819ULL, 0x000fc80000001241ULL,
0x0000003c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000144447810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0186bc00ff417984ULL, 0x000e640000000800ULL, 0x8000000041ff7812ULL, 0x002fe40007804842ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000c0273f7810ULL, 0x000fca0007ffe0ffULL,
0x000062002a417a24ULL, 0x000fe200078e023fULL, 0x0000039000009947ULL, 0x000fea0003800000ULL,
0x0000000221437810ULL, 0x000fe20007ffe0ffULL, 0x000000012c3e7824ULL, 0x040fe200078e0221ULL,
0x0000003f2d3c7217ULL, 0x000fe40007800000ULL, 0x0000000421497810ULL, 0x000fe20007ffe0ffULL,
0x000000012c407824ULL, 0x000fe400078e0243ULL, 0x000000013c3f7824ULL, 0x000fe400078e0a3fULL,
0x0000000140427824ULL, 0x000fc400078e022fULL, 0x00000010404b7824ULL, 0x000fe200078e00ffULL,
0x0000003f2c3f7217ULL, 0x040fe20007800000ULL, 0x000000012c447824ULL, 0x000fe400078e0249ULL,
0x000000013e3c7824ULL, 0x140fe200078e022fULL, 0xfffffff04b487812ULL, 0x000fe200078ee242ULL,
0x000000103e477824ULL, 0x000fe200078e00ffULL, 0x00000006214b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000144457824ULL, 0x040fe400078e022fULL, 0x00000010444a7824ULL, 0x000fe200078e00ffULL,
0xfffffff047467812ULL, 0x000fe200078ee23cULL, 0x000000012c3c7824ULL, 0x000fe200078e024bULL,
0x000000f026477812ULL, 0x000fe200078ec0ffULL, 0x000000013e3e7824ULL, 0x000fe200078e0241ULL,
0xfffffff04a4a7812ULL, 0x000fe200078ee245ULL, 0x00000100ff457424ULL, 0x000fc400078e00ffULL,
0x0000000144427824ULL, 0x100fe400078e0241ULL, 0x0000000140407824ULL, 0x100fe400078e0241ULL,
0x000000013c447824ULL, 0x040fe400078e0241ULL, 0x000000013c417824ULL, 0x040fe400078e022fULL,
0x000000103c4c7824ULL, 0x000fe400078e00ffULL, 0x000000013f3c7824ULL, 0x000fc400078e0a2cULL,
0x00005e003e3e7625ULL, 0x080fe200078e0045ULL, 0xfffffff04c4c7812ULL, 0x000fe400078ee241ULL,
0x0000003c4300720cULL, 0x080fe20003f46070ULL, 0x00005e0040407625ULL, 0x000fe200078e0045ULL,
0x000000473e3e7210ULL, 0x000fe40007fbe0ffULL, 0x0000003c2100720cULL, 0x080fe20003f66070ULL,
0x00005e0042427625ULL, 0x080fe200078e0045ULL, 0x0000003c4900720cULL, 0x080fe40003f26070ULL,
0x0000003c4b00720cULL, 0x000fe20003f06070ULL, 0x00005e0044447625ULL, 0x000fe200078e0045ULL,
0x0000004740407210ULL, 0x000fc40007f9e0ffULL, 0x0001600048497811ULL, 0x000fe200078e20ffULL,
0x000000ffff3f7224ULL, 0x000fe200028e063fULL, 0x0000004742427210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff417224ULL, 0x000fe200020e0641ULL, 0x0000004744447210ULL, 0x000fe40007fde0ffULL,
0x0001600046477811ULL, 0x000fe200078e20ffULL, 0x000000ffff437224ULL, 0x000fe200028e0643ULL,
0x000160004a4b7811ULL, 0x000fe200078e20ffULL, 0x000000ffff457224ULL, 0x000fe200030e0645ULL,
0x000160004c4d7811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e477faeULL, 0x0003e8000d901c46ULL, 0x0000000040497faeULL, 0x0003e8000d101c46ULL,
0x00000000424b7faeULL, 0x0003e8000c901c46ULL, 0x00000000444d7faeULL, 0x0003e2000c101c46ULL,
0x000002d000007947ULL, 0x000fea0003800000ULL, 0x000000012c3c7824ULL, 0x000fe200078e0221ULL,
0x000000f026477812ULL, 0x000fc600078ec0ffULL, 0x000000013c3e7824ULL, 0x040fe200078e022fULL,
0x000000043c427810ULL, 0x040fe20007ffe0ffULL, 0x000000103c457824ULL, 0x040fe200078e00ffULL,
0x000000023c407810ULL, 0x040fe20007ffe0ffULL, 0x000000013c447824ULL, 0x040fe200078e0241ULL,
0x000000063c3c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000142437824ULL, 0x140fe200078e022fULL,
0xfffffff045467812ULL, 0x000fe200078ee23eULL, 0x00000010424a7824ULL, 0x000fe400078e00ffULL,
0x00000001403f7824ULL, 0x000fc400078e022fULL, 0x0000001040487824ULL, 0x000fe200078e00ffULL,
0xfffffff04a4a7812ULL, 0x000fe200078ee243ULL, 0x00000100ff437424ULL, 0x000fe400078e00ffULL,
0x00000001403e7824ULL, 0x000fe200078e0241ULL, 0xfffffff048487812ULL, 0x000fe200078ee23fULL,
0x00005e0044447625ULL, 0x000fe200078e0043ULL, 0x000160004a4b7811ULL, 0x000fc600078e20ffULL,
0x0000000142407824ULL, 0x100fe200078e0241ULL, 0x0000004744447210ULL, 0x000fe20007f3e0ffULL,
0x000000013c427824ULL, 0x000fe400078e0241ULL, 0x00005e003e3e7625ULL, 0x000fc800078e0043ULL,
0x00005e0040407625ULL, 0x000fe200078e0043ULL, 0x000000473e3e7210ULL, 0x000fc60007f1e0ffULL,
0x000000013c497824ULL, 0x000fe400078e022fULL, 0x00005e0042427625ULL, 0x000fc800078e0043ULL,
0x000000103c3c7824ULL, 0x000fe200078e00ffULL, 0x0000004742427210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff457224ULL, 0x000fe200008e0645ULL, 0x0000004740407210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff3f7224ULL, 0x000fe200000e063fULL, 0xfffffff03c3c7812ULL, 0x000fe200078ee249ULL,
0x000000ffff437224ULL, 0x000fe200010e0643ULL, 0x0001600046477811ULL, 0x000fe200078e20ffULL,
0x000000ffff417224ULL, 0x000fe200008e0641ULL, 0x0001600048497811ULL, 0x000fe400078e20ffULL,
0x000160003c4d7811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044477faeULL, 0x0003e8000b901c46ULL, 0x000000003e497faeULL, 0x0003e8000b901c46ULL,
0x00000000404b7faeULL, 0x0003e8000b901c46ULL, 0x00000000424d7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0186b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0186b000ff3e7f8cULL, 0x002e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018668002c447f8cULL, 0x0004e4000c80043fULL, 0x0000000000407805ULL, 0x000fc40000015200ULL,
0x01866c002c437984ULL, 0x000f240000000800ULL, 0x8000000043ff7812ULL, 0x018fc40007804845ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff467224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000427805ULL, 0x000fcc0000015200ULL, 0x0000004240477210ULL, 0x000fca0007f1e1ffULL,
0x0000000143437824ULL, 0x000fe200000e0e41ULL, 0x003d09004700780cULL, 0x000fc80003f06070ULL,
0x000000ff4300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404700780cULL, 0x000fc80003f06070ULL, 0x000000ff4300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3c7819ULL, 0x000fc80000011443ULL,
0x000000473c3c7211ULL, 0x000fca00078110ffULL, 0x000000ffff437224ULL, 0x000fca00000e0643ULL,
0x000000023c3c7819ULL, 0x000fc80000001243ULL, 0x0000003c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000146467810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01866c002c437984ULL, 0x000ee40000000800ULL,
0x8000000043ff7812ULL, 0x008fe40007804845ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0181800025437984ULL, 0x000ee80000000800ULL, 0x0183800025427984ULL, 0x0004620000000800ULL,
0x000000544300720bULL, 0x008fe20003f1d000ULL, 0x0000d9027f007947ULL, 0x000fd8000b800000ULL,
0x0000000000447806ULL, 0x004fc800000e0100ULL, 0x0000ffff44ff7812ULL, 0x000fe2000780c0ffULL,
0x0000048000007945ULL, 0x000fe20003800000ULL, 0x00000001ff457424ULL, 0x000fc400078e00ffULL,
0x000000ffff3c7224ULL, 0x000fd200078e0054ULL, 0x0000044000008947ULL, 0x000fea0003800000ULL,
0x000000032e00780cULL, 0x000fe40003f05270ULL, 0x000000544300720bULL, 0x000fe20003f34000ULL,
0x0000d8d27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000457806ULL, 0x000fc400008e0100ULL,
0x00000054433c8209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x0000991045407816ULL, 0x000fc600000000ffULL, 0x0185803c25008388ULL, 0x0005e20000000800ULL,
0x000000ff4000720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000005443257209ULL, 0x004fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff45ff7812ULL, 0x000fc6000780c0ffULL, 0x0000005425257221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b25257820ULL, 0x000fc80000410000ULL, 0x00000025003c7308ULL, 0x000ea40000000800ULL,
0x0000003c29297220ULL, 0x004fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff597819ULL, 0x000fe2000001162fULL, 0x0000d8127f007947ULL, 0x000fea000b800000ULL,
0x00001f593c257589ULL, 0x0004e400000e0000ULL, 0x000000251c1c7220ULL, 0x088fe40000410000ULL,
0x000000251d1d7220ULL, 0x080fe40000410000ULL, 0x0000002518187220ULL, 0x080fe40000410000ULL,
0x0000002519197220ULL, 0x000fc40000410000ULL, 0x0000002514147220ULL, 0x080fe40000410000ULL,
0x0000002515157220ULL, 0x080fe40000410000ULL, 0x0000002510107220ULL, 0x080fe40000410000ULL,
0x0000002511117220ULL, 0x080fe40000410000ULL, 0x000000250c0c7220ULL, 0x080fe40000410000ULL,
0x000000250d0d7220ULL, 0x000fc40000410000ULL, 0x0000002508087220ULL, 0x080fe40000410000ULL,
0x0000002509097220ULL, 0x080fe40000410000ULL, 0x0000002504047220ULL, 0x080fe40000410000ULL,
0x0000002505057220ULL, 0x080fe40000410000ULL, 0x0000002530307220ULL, 0x080fe40000410000ULL,
0x0000002531317220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0045ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000082f597811ULL, 0x006fe200078ff0ffULL, 0x0000d7227f007947ULL, 0x000fea000b800000ULL,
0x00001f593c257589ULL, 0x0002a400000e0000ULL, 0x000000251e1e7220ULL, 0x084fe40000410000ULL,
0x000000251f1f7220ULL, 0x080fe40000410000ULL, 0x000000251a1a7220ULL, 0x080fe40000410000ULL,
0x000000251b1b7220ULL, 0x080fe40000410000ULL, 0x0000002516167220ULL, 0x080fe40000410000ULL,
0x0000002517177220ULL, 0x000fc40000410000ULL, 0x0000002512127220ULL, 0x080fe40000410000ULL,
0x0000002513137220ULL, 0x080fe40000410000ULL, 0x000000250e0e7220ULL, 0x080fe40000410000ULL,
0x000000250f0f7220ULL, 0x080fe40000410000ULL, 0x000000250a0a7220ULL, 0x080fe40000410000ULL,
0x000000250b0b7220ULL, 0x000fc40000410000ULL, 0x0000002506067220ULL, 0x080fe40000410000ULL,
0x0000002507077220ULL, 0x080fe40000410000ULL, 0x0000002532327220ULL, 0x080fe40000410000ULL,
0x0000002533337220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff45ff7812ULL, 0x000fe20007800844ULL, 0x00000001ff457424ULL, 0x000fe200078e00ffULL,
0x00000054433c7209ULL, 0x002fd60007810000ULL, 0x8000003c43430221ULL, 0x000fe20000010000ULL,
0x00007610ff450816ULL, 0x000fc60000000045ULL, 0x3fb8aa3b43430820ULL, 0x000fc80000410000ULL,
0x0000004300240308ULL, 0x000e640000000800ULL, 0x0000002442420220ULL, 0x002fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002942297221ULL, 0x002fc40000010000ULL,
0x0000000000407805ULL, 0x000fca0000015200ULL, 0x0186ac00ff427984ULL, 0x000e640000000800ULL,
0x8000000042ff7812ULL, 0x002fe4000780483dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff447224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000427805ULL, 0x000fcc0000015200ULL,
0x0000004240427210ULL, 0x000fca0007f1e1ffULL, 0x0000000143437824ULL, 0x000fe200000e0e41ULL,
0x003d09004200780cULL, 0x000fc80003f06070ULL, 0x000000ff4300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404200780cULL, 0x000fc80003f06070ULL,
0x000000ff4300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc80000011443ULL, 0x0000004225257211ULL, 0x000fca00078110ffULL,
0x000000ffff427224ULL, 0x000fca00000e0643ULL, 0x0000000225257819ULL, 0x000fc80000001242ULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000144447810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0186ac00ff427984ULL, 0x000e640000000800ULL, 0x8000000042ff7812ULL, 0x002fe4000780483dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991045257816ULL, 0x000fe200000000ffULL,
0x0000019000007945ULL, 0x000fe60003800000ULL, 0x000000ff2500720cULL, 0x000fda0003f25270ULL,
0x0000016000001947ULL, 0x000fea0003800000ULL, 0x00000024ff22723eULL, 0x000fe400000010ffULL,
0x00000002ff427819ULL, 0x000fe4000001162fULL, 0x0000541022257816ULL, 0x000fe20000000022ULL,
0x0000d3227f007947ULL, 0x000fea000b800000ULL, 0x00001f4225237589ULL, 0x0002a400000e0000ULL,
0x0000000842597810ULL, 0x002fe20007ffe0ffULL, 0x0000d3727f007947ULL, 0x000fea000b800000ULL,
0x00001f5925227589ULL, 0x0002e400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001042597810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff587224ULL, 0x000fe200078e0025ULL,
0x00013f8000407802ULL, 0x000fe20000000f00ULL, 0x0000001fff5a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff5b7424ULL, 0x000fc400078e00ffULL, 0x0000d9f000007944ULL, 0x00cfea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001842597810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff587224ULL, 0x004fe200078e0025ULL, 0x00013ff000407802ULL, 0x000fe20000000f00ULL,
0x0000001fff5a7424ULL, 0x000fc400078e00ffULL, 0xffffffffff5b7424ULL, 0x000fc400078e00ffULL,
0x0000d98000007944ULL, 0x008fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000002040783bULL, 0x000f220000004200ULL,
0x0001380035357811ULL, 0x000fc600078e20ffULL, 0x000000000344783bULL, 0x000fe80000004200ULL,
0x000000000248783bULL, 0x000e680000004200ULL, 0x00000000004c783bULL, 0x0006a20000004200ULL,
0x00000018ff507819ULL, 0x010fe20000011442ULL, 0x0000010040647824ULL, 0x000fe200078e00ffULL,
0x00000018ff257819ULL, 0x002fe20000011441ULL, 0x0000004000c07306ULL, 0x000fe20000009400ULL,
0x00000018ff007819ULL, 0x008fc40000011440ULL, 0x00000018ff647819ULL, 0x000fe40000011464ULL,
0x00000018ff527819ULL, 0x000fe40000011443ULL, 0x00000018ff557819ULL, 0x000fe2000001144bULL,
0x0000005000bd7306ULL, 0x000fe20000209400ULL, 0x00000018ff677819ULL, 0x004fe4000001144dULL,
0x00000018ff687819ULL, 0x000fe4000001144eULL, 0x00000018ff697819ULL, 0x000fc6000001144fULL,
0x0000005000be7306ULL, 0x000ff00000205400ULL, 0x0000005000877306ULL, 0x0003f0000020d400ULL,
0x0000002500c47306ULL, 0x000fe20000209400ULL, 0x00000018ff507819ULL, 0x002fce0000011446ULL,
0x0000002500bf7306ULL, 0x000ff00000205400ULL, 0x0000002500037306ULL, 0x0003f0000020d400ULL,
0x0000000000c37306ULL, 0x000fe20000209400ULL, 0x00000018ff257819ULL, 0x002fce0000011445ULL,
0x0000000000c27306ULL, 0x000e700000205400ULL, 0x0000000000967306ULL, 0x0004f0000020d400ULL,
0x0000005000a87306ULL, 0x000fe20000209400ULL, 0x00000018ff007819ULL, 0x004fc40000011444ULL,
0x000000c2c300720bULL, 0x002fca0003f7d000ULL, 0x0000005000a97306ULL, 0x000ff00000205400ULL,
0x00000050006b7306ULL, 0x0003e2000020d400ULL, 0x0000000196963812ULL, 0x008fce00078efcffULL,
0x0000004000c17306ULL, 0x000ea20000005400ULL, 0x00000018ff507819ULL, 0x002fce000001144aULL,
0x00000040009b7306ULL, 0x0002f0000000d400ULL, 0x0000002500ac7306ULL, 0x000fe20000209400ULL,
0x0001000040407824ULL, 0x002fe200078e00ffULL, 0x000000c1c000720bULL, 0x004fcc0003fdd000ULL,
0x0000002500ad7306ULL, 0x000fee0000205400ULL, 0x000000019b9b6812ULL, 0x008fe200078efcffULL,
0x0000002500777306ULL, 0x0003f0000020d400ULL, 0x0000006400c57306ULL, 0x000fe20000209400ULL,
0x00000018ff257819ULL, 0x002fce0000011449ULL, 0x0000006400c67306ULL, 0x000e700000205400ULL,
0x0000000000b77306ULL, 0x000ff00000209400ULL, 0x0000000000b47306ULL, 0x000fe20000205400ULL,
0x000000c6c500720bULL, 0x002fce0003f1d000ULL, 0x0000000000737306ULL, 0x0003f0000020d400ULL,
0x00000041007b7306ULL, 0x000fe20000009400ULL, 0x00000018ff007819ULL, 0x002fce0000011448ULL,
0x0000004100bc7306ULL, 0x000e700000005400ULL, 0x0000005000787306ULL, 0x000ff00000209400ULL,
0x0000005000757306ULL, 0x000fe20000205400ULL, 0x000000bc7b00720bULL, 0x002fce0003f9d000ULL,
0x0000005000587306ULL, 0x000ff0000020d400ULL, 0x00000067005d7306ULL, 0x000ff00000209400ULL,
0x00000067005e7306ULL, 0x000ff00000205400ULL, 0x0000006700507306ULL, 0x0003f0000020d400ULL,
0x0000005200bb7306ULL, 0x000fe20000209400ULL, 0x00000018ff677819ULL, 0x002fce0000011440ULL,
0x0000005200b87306ULL, 0x000ff00000205400ULL, 0x0000005200867306ULL, 0x0003f0000020d400ULL,
0x0000002500917306ULL, 0x000fe20000209400ULL, 0x00000018ff527819ULL, 0x002fce0000011447ULL,
0x0000002500907306ULL, 0x000ff00000205400ULL, 0x00000025005c7306ULL, 0x000ff0000020d400ULL,
0x00000000009d7306ULL, 0x000ff00000209400ULL, 0x00000000009e7306ULL, 0x000ff00000205400ULL,
0x0000000000607306ULL, 0x0003f0000020d400ULL, 0x0000006800597306ULL, 0x000fe20000209400ULL,
0x00000018ff007819ULL, 0x002fce000001144cULL, 0x00000068005a7306ULL, 0x000ff00000205400ULL,
0x0000006800257306ULL, 0x0003f0000020d400ULL, 0x0000006700407306ULL, 0x000fe20000209400ULL,
0x0000010041687824ULL, 0x002fca00078e00ffULL, 0x00000018ff687819ULL, 0x000fe40000011468ULL,
0x0000006700c77306ULL, 0x000e700000205400ULL, 0x0000005200a67306ULL, 0x000ff00000209400ULL,
0x0000005200a77306ULL, 0x000fe20000205400ULL, 0x000000c74000720bULL, 0x002fe20003f5d000ULL,
0x000001004c407824ULL, 0x000fca00078e00ffULL, 0x00000018ff407819ULL, 0x000fe20000011440ULL,
0x00000052006c7306ULL, 0x000ff0000020d400ULL, 0x00000055006e7306ULL, 0x000ff00000209400ULL,
0x0000005500717306ULL, 0x000ff00000205400ULL, 0x0000005500547306ULL, 0x000ff0000020d400ULL,
0x0000000000627306ULL, 0x000ff00000209400ULL, 0x00000000005f7306ULL, 0x000ff00000205400ULL,
0x0000000000527306ULL, 0x000ff0000020d400ULL, 0x00000041009a7306ULL, 0x0002b0000000d400ULL,
0x0000006900557306ULL, 0x000fe20000209400ULL, 0x0001000041417824ULL, 0x002fce00078e00ffULL,
0x0000006900567306ULL, 0x000fe20000205400ULL, 0x000000019a9a4812ULL, 0x004fce00078efcffULL,
0x0000006900007306ULL, 0x0003f0000020d400ULL, 0x0000006400a07306ULL, 0x0004e2000020d400ULL,
0x0000010042697824ULL, 0x002fca00078e00ffULL, 0x00000018ff697819ULL, 0x000fe40000011469ULL,
0x0000004200ba7306ULL, 0x000fe20000009400ULL, 0x00000018ff647819ULL, 0x004fce0000011441ULL,
0x0000004200957306ULL, 0x000e620000005400ULL, 0x00000001a0a00812ULL, 0x008fe400078efcffULL,
0x000000bfc400720bULL, 0x000fca0003f1d000ULL, 0x0000004300b97306ULL, 0x000ff00000009400ULL,
0x0000004300927306ULL, 0x000ea20000005400ULL, 0x00000095ba00720bULL, 0x002fe40003f7d000ULL,
0x0000000103030812ULL, 0x000fca00078efcffULL, 0x0000006800c97306ULL, 0x000ff00000209400ULL,
0x0000006800c87306ULL, 0x000e620000205400ULL, 0x00000092b900720bULL, 0x004fce0003f9d000ULL,
0x00000042008f7306ULL, 0x0004f0000000d400ULL, 0x0000006700997306ULL, 0x0008e2000020d400ULL,
0x0001000042427824ULL, 0x004fe200078e00ffULL, 0x000000c8c900720bULL, 0x002fcc0003fbd000ULL,
0x00000043008e7306ULL, 0x0002a2000000d400ULL, 0x0000010043677824ULL, 0x010fe200078e00ffULL,
0x000000018f8f3812ULL, 0x008fc800078efcffULL, 0x00000018ff677819ULL, 0x000fe40000011467ULL,
0x0000006400417306ULL, 0x000fe20000209400ULL, 0x0001000043437824ULL, 0x002fe200078e00ffULL,
0x0000000199992812ULL, 0x000fcc00078efcffULL, 0x0000006400ca7306ULL, 0x000e620000205400ULL,
0x000000018e8e4812ULL, 0x004fce00078efcffULL, 0x0000006400987306ULL, 0x0004f0000020d400ULL,
0x0000006900cc7306ULL, 0x000fe20000209400ULL, 0x00000018ff647819ULL, 0x004fe40000011442ULL,
0x000000ca4100720bULL, 0x002fe20003fdd000ULL, 0x000001004d417824ULL, 0x000fc800078e00ffULL,
0x0000006900cb7306ULL, 0x000e700000205400ULL, 0x0000006800a17306ULL, 0x000522000020d400ULL,
0x0000000198986812ULL, 0x008fe400078efcffULL, 0x000000bebd00720bULL, 0x000fc40003fdd000ULL,
0x000000980303723eULL, 0x000fc600000010ffULL, 0x0000006400cf7306ULL, 0x000fe20000209400ULL,
0x00000018ff687819ULL, 0x004fe40000011443ULL, 0x000000cbcc00720bULL, 0x002fca0003f5d000ULL,
0x0000006400427306ULL, 0x000e620000205400ULL, 0x00000001a1a15812ULL, 0x010fe400078efcffULL,
0x0000000187876812ULL, 0x000fca00078efcffULL, 0x0000004400b27306ULL, 0x000ff00000009400ULL,
0x0000004400b37306ULL, 0x000ea20000005400ULL, 0x00000042cf00720bULL, 0x002fce0003f1d000ULL,
0x0000006700ce7306ULL, 0x000ff00000209400ULL, 0x0000006700cd7306ULL, 0x000e620000205400ULL,
0x000000b3b200720bULL, 0x004fe40003f9d000ULL, 0x00000018ffb37819ULL, 0x000fca0000011441ULL,
0x0000006800437306ULL, 0x000ff00000209400ULL, 0x0000006800d07306ULL, 0x000ea20000205400ULL,
0x000000cdce00720bULL, 0x002fce0003fbd000ULL, 0x0000006700937306ULL, 0x0002f0000020d400ULL,
0x0000006900947306ULL, 0x0008e2000020d400ULL, 0x0000010045677824ULL, 0x002fe200078e00ffULL,
0x000000d04300720bULL, 0x004fc80003f7d000ULL, 0x00000018ff677819ULL, 0x000fe40000011467ULL,
0x00000044007e7306ULL, 0x0002a2000000d400ULL, 0x0000010044697824ULL, 0x010fe200078e00ffULL,
0x0000000193935812ULL, 0x008fc800078efcffULL, 0x00000018ff697819ULL, 0x000fe40000011469ULL,
0x00000064008c7306ULL, 0x000722000020d400ULL, 0x0001000044447824ULL, 0x002fe200078e00ffULL,
0x0000000194942812ULL, 0x000fe400078efcffULL, 0x000000b8bb00720bULL, 0x000fc80003f5d000ULL,
0x0000004000957306ULL, 0x000fe20000209400ULL, 0x00000018ff647819ULL, 0x008fe20000011444ULL,
0x0000010046447824ULL, 0x000fe200078e00ffULL, 0x000000017e7e4812ULL, 0x004fe400078efcffULL,
0x000000b4b700720bULL, 0x000fc60003f9d000ULL, 0x0000004000ba7306ULL, 0x000fe20000205400ULL,
0x000000018c8c0812ULL, 0x010fe400078efcffULL, 0x0000000186862812ULL, 0x000fe400078efcffULL,
0x0000008c878c723eULL, 0x000fc600000010ffULL, 0x0000004000927306ULL, 0x0003e4000020d400ULL,
0x0000000173734812ULL, 0x000fcc00078efcffULL, 0x0000006700d47306ULL, 0x000fe20000209400ULL,
0x0001380034407811ULL, 0x002fcc00078e20ffULL, 0x000000004040783bULL, 0x000e620000000200ULL,
0x0000006700d37306ULL, 0x000eb00000205400ULL, 0x00000068008d7306ULL, 0x000ef0000020d400ULL,
0x0000004600b17306ULL, 0x000fe20000009400ULL, 0x000000d3d400720bULL, 0x004fce0003f1d000ULL,
0x0000004600b07306ULL, 0x000ea20000005400ULL, 0x000000018d8d3812ULL, 0x008fc800078efcffULL,
0x0000008d868d723eULL, 0x000fc600000010ffULL, 0x0000006900d17306ULL, 0x000fe20000209400ULL,
0x0000002340409231ULL, 0x002fce00003400ffULL, 0x0000006900d27306ULL, 0x000e620000205400ULL,
0x000000b0b100720bULL, 0x004fe20003f7d000ULL, 0x0000002342429231ULL, 0x000fe400003400ffULL,
0x0000002241419231ULL, 0x080fe400003400ffULL, 0x0000002243439231ULL, 0x000fe400003400ffULL,
0x0000006400d77306ULL, 0x000fea0000209400ULL, 0x0000008c4010723cULL, 0x000fe60000041810ULL,
0x0000006400d87306ULL, 0x000ea20000205400ULL, 0x000000d2d100720bULL, 0x002fce0003fbd000ULL,
0x0000006700857306ULL, 0x0002f0000020d400ULL, 0x0000004600727306ULL, 0x0008e2000000d400ULL,
0x00000018ff677819ULL, 0x002fe40000011444ULL, 0x000000d8d700720bULL, 0x004fca0003f5d000ULL,
0x0000006900817306ULL, 0x0002a2000020d400ULL, 0x0001000046467824ULL, 0x010fe200078e00ffULL,
0x0000000185850812ULL, 0x008fe400078efcffULL, 0x000000adac00720bULL, 0x000fe20003f1d000ULL,
0x000001004eac7824ULL, 0x040fe200078e00ffULL, 0x00000018ff467819ULL, 0x000fe20000011446ULL,
0x000100004ead7824ULL, 0x000fe200078e00ffULL, 0x0000004500b67306ULL, 0x000fe20000009400ULL,
0x0000010047697824ULL, 0x002fe200078e00ffULL, 0x0000000172723812ULL, 0x000fc400078efcffULL,
0x000000a7a600720bULL, 0x000fe40003f7d000ULL, 0x00000018ff697819ULL, 0x000fe40000011469ULL,
0x0000004500b57306ULL, 0x000e620000005400ULL, 0x0000000181815812ULL, 0x004fe400078efcffULL,
0x0000000177770812ULL, 0x000fe400078efcffULL, 0x000000a9a800720bULL, 0x000fe40003f1d000ULL,
0x00000018ffac7819ULL, 0x000fe200000114acULL, 0x00000045007c7306ULL, 0x0004e2000000d400ULL,
0x000000016c6c3812ULL, 0x000fc400078efcffULL, 0x00000018ffad7819ULL, 0x000fca00000114adULL,
0x0000004700ae7306ULL, 0x000fe20000009400ULL, 0x0001000045457824ULL, 0x004fe200078e00ffULL,
0x000000b5b600720bULL, 0x002fe40003fdd000ULL, 0x000000016b6b0812ULL, 0x000fe400078efcffULL,
0x00000018ff687819ULL, 0x000fe40000011445ULL, 0x0000004700af7306ULL, 0x000e6e0000005400ULL,
0x000000017c7c6812ULL, 0x008fe200078efcffULL, 0x0000006400807306ULL, 0x0004e6000020d400ULL,
0x0000007c8585723eULL, 0x000fca00000010ffULL, 0x0000004800a47306ULL, 0x000fe20000009400ULL,
0x0000010048647824ULL, 0x004fe200078e00ffULL, 0x000000afae00720bULL, 0x002fe20003fbd000ULL,
0x000001004fae7824ULL, 0x000fc600078e00ffULL, 0x00000018ff647819ULL, 0x000fe40000011464ULL,
0x0000004800a57306ULL, 0x000fe20000005400ULL, 0x0000000180802812ULL, 0x008fe400078efcffULL,
0x00000018ffae7819ULL, 0x000fe400000114aeULL, 0x000000807380723eULL, 0x000fc600000010ffULL,
0x0000004800657306ULL, 0x0003f0000000d400ULL, 0x0000006700457306ULL, 0x000fe20000209400ULL,
0x0001000048487824ULL, 0x002fca00078e00ffULL, 0x00000018ff487819ULL, 0x000fe40000011448ULL,
0x0000006700447306ULL, 0x000e700000205400ULL, 0x0000004600da7306ULL, 0x000ff00000209400ULL,
0x0000004600d97306ULL, 0x000fe20000205400ULL, 0x000000444500720bULL, 0x002fe20003f5d000ULL,
0x000100004d457824ULL, 0x000fcc00078e00ffULL, 0x00000046007a7306ULL, 0x0003f0000020d400ULL,
0x0000004700707306ULL, 0x0004e2000000d400ULL, 0x0000010049467824ULL, 0x002fce00078e00ffULL,
0x0000004900a27306ULL, 0x000fe20000009400ULL, 0x0001000047477824ULL, 0x004fca00078e00ffULL,
0x00000018ff477819ULL, 0x000fe40000011447ULL, 0x0000004900a37306ULL, 0x000e620000005400ULL,
0x0000000170705812ULL, 0x008fce00078efcffULL, 0x0000006900d57306ULL, 0x000ff00000209400ULL,
0x0000006900d67306ULL, 0x000ea20000205400ULL, 0x000000a3a200720bULL, 0x002fce0003fbd000ULL,
0x0000004800e47306ULL, 0x000ff00000209400ULL, 0x0000004800e17306ULL, 0x000e620000205400ULL,
0x000000d6d500720bULL, 0x004fce0003f9d000ULL, 0x00000067007d7306ULL, 0x0004f0000020d400ULL,
0x0000004c00897306ULL, 0x000fe20000009400ULL, 0x00000018ff677819ULL, 0x004fe20000011446ULL,
0x000001004a467824ULL, 0x000fe200078e00ffULL, 0x000000e1e400720bULL, 0x002fc80003f7d000ULL,
0x00000018ffe57819ULL, 0x000fe20000011446ULL, 0x0000004c00887306ULL, 0x000fe20000005400ULL,
0x000000017d7d2812ULL, 0x008fce00078efcffULL, 0x0000004c00537306ULL, 0x0003f0000000d400ULL,
0x0000006800db7306ULL, 0x000fe20000209400ULL, 0x000100004c4c7824ULL, 0x002fca00078e00ffULL,
0x00000018ff447819ULL, 0x000fe4000001144cULL, 0x0000006800dc7306ULL, 0x000e700000205400ULL,
0x0000004900637306ULL, 0x0004f0000000d400ULL, 0x00000069007f7306ULL, 0x000f22000020d400ULL,
0x000000dcdb00720bULL, 0x002fe20003fdd000ULL, 0x0001000049497824ULL, 0x004fca00078e00ffULL,
0x00000018ff497819ULL, 0x000fe20000011449ULL, 0x0000004700de7306ULL, 0x000fe20000209400ULL,
0x0000000163635812ULL, 0x008fce00078efcffULL, 0x0000004700dd7306ULL, 0x000e620000205400ULL,
0x000000017f7f4812ULL, 0x010fe400078efcffULL, 0x000000a5a400720bULL, 0x000fca0003f9d000ULL,
0x0000004700797306ULL, 0x000ff0000020d400ULL, 0x00000048006f7306ULL, 0x0004e2000020d400ULL,
0x000000ddde00720bULL, 0x002fe40003f5d000ULL, 0x0000000165654812ULL, 0x000fca00078efcffULL,
0x0000004d00847306ULL, 0x000fe20000009400ULL, 0x000001004b487824ULL, 0x004fca00078e00ffULL,
0x00000018ffe77819ULL, 0x000fe40000011448ULL, 0x0000004d00837306ULL, 0x000fe20000005400ULL,
0x000000016f6f3812ULL, 0x008fe400078efcffULL, 0x000000909100720bULL, 0x000fe40003f7d000ULL,
0x0000000179792812ULL, 0x000fe400078efcffULL, 0x0000009e9d00720bULL, 0x000fe20003f5d000ULL,
0x0000004d00517306ULL, 0x000fe2000000d400ULL, 0x000000796c79723eULL, 0x000fce00000010ffULL,
0x0000004e006d7306ULL, 0x000fe20000009400ULL, 0x000000015c5c3812ULL, 0x000fc600078efcffULL,
0x0000000160602812ULL, 0x000fc800078efcffULL, 0x0000004e006a7306ULL, 0x000fe20000005400ULL,
0x0000006f6060723eULL, 0x000fce00000010ffULL, 0x0000004e003d7306ULL, 0x0003f0000000d400ULL,
0x000000e500467306ULL, 0x000fe20000209400ULL, 0x00000018ff4e7819ULL, 0x002fe40000011445ULL,
0x0000009aa145723eULL, 0x000fca00000010ffULL, 0x000000e500477306ULL, 0x000e700000205400ULL,
0x00000044004c7306ULL, 0x000ff00000209400ULL, 0x0000004400a97306ULL, 0x000fe20000205400ULL,
0x000000474600720bULL, 0x002fce0003fbd000ULL, 0x00000044004d7306ULL, 0x0003f0000020d400ULL,
0x0000006800827306ULL, 0x000ea2000020d400ULL, 0x0000009ba044723eULL, 0x002fce00000010ffULL,
0x00000044401c723cULL, 0x000b62000004181cULL, 0x0000006400e07306ULL, 0x000fec0000209400ULL,
0x0000008f9444723eULL, 0x020fe400000010ffULL, 0x0000008e9345723eULL, 0x000fe200000010ffULL,
0x0000006400df7306ULL, 0x000e620000205400ULL, 0x0000000182826812ULL, 0x004fc400078efcffULL,
0x000000d9da00720bULL, 0x000fc60003fdd000ULL, 0x000000444044723cULL, 0x000be40000041814ULL,
0x0000006700e27306ULL, 0x000fe20000209400ULL, 0x000000003514783bULL, 0x020eae0000000200ULL,
0x0000006700e37306ULL, 0x000ee20000205400ULL, 0x000000dfe000720bULL, 0x002fc40003f1d000ULL,
0x000000017a7a6812ULL, 0x000fca00078efcffULL, 0x000000e7008a7306ULL, 0x000ff00000209400ULL,
0x000000e7008b7306ULL, 0x000e620000205400ULL, 0x000000e3e200720bULL, 0x008fce0003f9d000ULL,
0x0000004a009f7306ULL, 0x000ff00000009400ULL, 0x0000004a009c7306ULL, 0x000ee20000005400ULL,
0x0000008b8a00720bULL, 0x002fe20003f7d000ULL, 0x0000002314149231ULL, 0x004fc400003400ffULL,
0x0000002316169231ULL, 0x000fe400003400ffULL, 0x0000002215159231ULL, 0x080fe400003400ffULL,
0x0000004a005b7306ULL, 0x0002a2000000d400ULL, 0x0000002217179231ULL, 0x000fce00003400ffULL,
0x0000006400747306ULL, 0x000f22000020d400ULL, 0x000100004a4a7824ULL, 0x002fe200078e00ffULL,
0x0000009c9f00720bULL, 0x008fc80003fdd000ULL, 0x00000018ffe67819ULL, 0x000fe4000001144aULL,
0x0000004b00977306ULL, 0x000fee0000009400ULL, 0x000000015b5b6812ULL, 0x004fe200078efcffULL,
0x0000004b00027306ULL, 0x000e620000005400ULL, 0x0000000174740812ULL, 0x010fce00078efcffULL,
0x0000006700767306ULL, 0x000eb0000020d400ULL, 0x000000e500687306ULL, 0x000ee2000020d400ULL,
0x000000029700720bULL, 0x002fe40003f1d000ULL, 0x000000999602723eULL, 0x000fca00000010ffULL,
0x000000e700647306ULL, 0x000e62000020d400ULL, 0x0000000176764812ULL, 0x004fe200078efcffULL,
0x000000024018723cULL, 0x000fe20000041818ULL, 0x000000888900720bULL, 0x000fca0003f9d000ULL,
0x0000004900aa7306ULL, 0x000fe20000209400ULL, 0x0000000168685812ULL, 0x008fe400078efcffULL,
0x000000757800720bULL, 0x000fe40003fbd000ULL, 0x0000007a6b78723eULL, 0x000fe400000010ffULL,
0x0000005b6868723eULL, 0x000fe200000010ffULL, 0x0000004900ab7306ULL, 0x000ea20000205400ULL,
0x0000000164643812ULL, 0x002fe400078efcffULL, 0x000000716e00720bULL, 0x000fe20003f7d000ULL,
0x000000784030723cULL, 0x000fe20000041830ULL, 0x0000000153534812ULL, 0x000fc400078efcffULL,
0x000000a94c00720bULL, 0x000fe20003f9d000ULL, 0x0000004b00577306ULL, 0x0002e2000000d400ULL,
0x0000000158585812ULL, 0x000fe400078efcffULL, 0x000000ba9500720bULL, 0x000fca0003fbd000ULL,
0x0000004900697306ULL, 0x000f22000020d400ULL, 0x000100004b4b7824ULL, 0x002fe200078e00ffULL,
0x000000abaa00720bULL, 0x004fe40003f5d000ULL, 0x0000000154543812ULL, 0x000fe400078efcffULL,
0x00000018ffc57819ULL, 0x000fe4000001144bULL, 0x000000e600487306ULL, 0x000fe20000209400ULL,
0x0000000157570812ULL, 0x008fe400078efcffULL, 0x0000000192925812ULL, 0x000fc400078efcffULL,
0x000000014d4d4812ULL, 0x000fe400078efcffULL, 0x0000005f6200720bULL, 0x000fe20003fbd000ULL,
0x000000e600497306ULL, 0x000e620000205400ULL, 0x0000000169692812ULL, 0x010fe400078efcffULL,
0x000000838400720bULL, 0x000fe40003f5d000ULL, 0x0000007e8184723eULL, 0x000fe400000010ffULL,
0x000000827781723eULL, 0x000fe200000010ffULL, 0x000000c5004a7306ULL, 0x000fe20000209400ULL,
0x000000539292723eULL, 0x000fc600000010ffULL, 0x00000084400c723cULL, 0x040f62000004180cULL,
0x0000000152525812ULL, 0x000fe400078efcffULL, 0x0000005a5900720bULL, 0x000fe20003fbd000ULL,
0x000000c5004b7306ULL, 0x000ea20000205400ULL, 0x000000494800720bULL, 0x002fe40003fdd000ULL,
0x000000727d48723eULL, 0x000fe200000010ffULL, 0x000000804008723cULL, 0x000f620000041808ULL,
0x000000707f49723eULL, 0x000fe400000010ffULL, 0x0000000151512812ULL, 0x000fe200078efcffULL,
0x000000b300b27306ULL, 0x000fe20000209400ULL, 0x0000005e5d00720bULL, 0x000fc40003f5d000ULL,
0x0000004d5252723eULL, 0x000fe400000010ffULL, 0x0000000125255812ULL, 0x000fc600078efcffULL,
0x000000b300af7306ULL, 0x000e620000205400ULL, 0x0000004b4a00720bULL, 0x004fe40003f1d000ULL,
0x000000484048723cULL, 0x000b660000041804ULL, 0x0000000150502812ULL, 0x000fe400078efcffULL,
0x000000e600677306ULL, 0x000ea4000020d400ULL, 0x000000657404723eULL, 0x020fc400000010ffULL,
0x000000637605723eULL, 0x000fc800000010ffULL, 0x000000b300347306ULL, 0x000ee2000020d400ULL,
0x000000afb200720bULL, 0x002fe40003f7d000ULL, 0x000000041404723cULL, 0x000b6a000004181cULL,
0x0000004e009c7306ULL, 0x000fe20000209400ULL, 0x0000000167676812ULL, 0x004fe400078efcffULL,
0x0000006a6d00720bULL, 0x000fc40003fdd000ULL, 0x000000675858723eULL, 0x000fc600000010ffULL,
0x0000004e009b7306ULL, 0x000e620000205400ULL, 0x0000000134343812ULL, 0x008fc800078efcffULL,
0x000000513493723eULL, 0x000fc600000010ffULL, 0x000000ac00027306ULL, 0x000fe20000209400ULL,
0x000000013d3d6812ULL, 0x000fc600078efcffULL, 0x00000092140c723cULL, 0x000b68000004180cULL,
0x000000ac00037306ULL, 0x000ea20000205400ULL, 0x0000009b9c00720bULL, 0x002fce0003f7d000ULL,
0x0000004f00667306ULL, 0x000ff00000009400ULL, 0x0000004f00617306ULL, 0x000fe20000005400ULL,
0x000000030200720bULL, 0x004fce0003f9d000ULL, 0x0000004f00207306ULL, 0x0003f0000000d400ULL,
0x0000004e00977306ULL, 0x000ea2000020d400ULL, 0x000100004f4f7824ULL, 0x002fca00078e00ffULL,
0x00000018ff1c7819ULL, 0x020fe4000001144fULL, 0x000000c5007b7306ULL, 0x000e70000020d400ULL,
0x000000ac004e7306ULL, 0x000ee2000020d400ULL, 0x0000000197973812ULL, 0x004fc400078efcffULL,
0x000000565500720bULL, 0x000fe40003f7d000ULL, 0x000000975053723eULL, 0x000fc600000010ffULL,
0x000000ae00737306ULL, 0x000fe20000209400ULL, 0x000000017b7b0812ULL, 0x002fe400078efcffULL,
0x000000616600720bULL, 0x000fe20003f1d000ULL, 0x000000521408723cULL, 0x040b620000041808ULL,
0x000000695c61723eULL, 0x000fe400000010ffULL, 0x000000576469723eULL, 0x000fe200000010ffULL,
0x000000ae006e7306ULL, 0x000e620000205400ULL, 0x000000014e4e4812ULL, 0x008fe400078efcffULL,
0x0000000100003812ULL, 0x000fe200078efcffULL, 0x000000601418723cULL, 0x000b620000041818ULL,
0x0000007b5459723eULL, 0x000fc400000010ffULL, 0x0000003d4e4e723eULL, 0x000fe200000010ffULL,
0x000000ad00357306ULL, 0x000fe20000209400ULL, 0x0000000120200812ULL, 0x000fc600078efcffULL,
0x000000681444723cULL, 0x000b680000041844ULL, 0x000000ad00407306ULL, 0x000ea20000205400ULL,
0x0000006e7300720bULL, 0x002fc60003f5d000ULL, 0x000000581410723cULL, 0x000b680000041810ULL,
0x0000001c001d7306ULL, 0x000ff00000209400ULL, 0x0000001c001e7306ULL, 0x000e620000205400ULL,
0x000000403500720bULL, 0x004fce0003f9d000ULL, 0x000000ae006b7306ULL, 0x000eb0000020d400ULL,
0x000000ad00027306ULL, 0x000ee2000020d400ULL, 0x0000001e1d00720bULL, 0x002fce0003fdd000ULL,
0x0000001c00037306ULL, 0x000e62000020d400ULL, 0x000000016b6b2812ULL, 0x004fc800078efcffULL,
0x000000206b4f723eULL, 0x000fe400000010ffULL, 0x0000000102024812ULL, 0x008fc800078efcffULL,
0x000000022502723eULL, 0x000fe200000010ffULL, 0x0000004e1448723cULL, 0x000b620000041848ULL,
0x0000000103036812ULL, 0x002fc800078efcffULL, 0x000000030003723eULL, 0x000fce00000010ffULL,
0x000000021430723cULL, 0x000b620000041830ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0186b800ff167f8cULL, 0x020e62000c80043fULL, 0x000000ffff1c7224ULL, 0x000fce00078e00ffULL,
0x0000000000027805ULL, 0x000fc40000015200ULL, 0x0186bc00ff157984ULL, 0x000ea40000000800ULL,
0x8000000015ff7812ULL, 0x006fe40007804817ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x00000014021d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e03ULL, 0x003d09001d00780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401d00780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011415ULL,
0x0000001d00007211ULL, 0x000fca00078110ffULL, 0x000000ffff157224ULL, 0x000fca00000e0615ULL,
0x0000000200007819ULL, 0x000fc80000001215ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011c1c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0186bc00ff157984ULL, 0x000e640000000800ULL,
0x8000000015ff7812ULL, 0x002fe40007804817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000228007810ULL, 0x000fe40007ffe0ffULL, 0x000000e027037810ULL, 0x000fe40007ffe0ffULL,
0x0000002b0000720cULL, 0x000fc60003f06070ULL, 0x000062002a177a24ULL, 0x000fd400078e0203ULL,
0x0000039000008947ULL, 0x000fea0003800000ULL, 0x0000000221277810ULL, 0x040fe20007ffe0ffULL,
0x000000012c027824ULL, 0x040fe200078e0221ULL, 0x0000000421357810ULL, 0x000fe40007ffe0ffULL,
0x000000032d007217ULL, 0x000fe20007800000ULL, 0x000000012c167824ULL, 0x000fe200078e0227ULL,
0x00000006213d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000102147824ULL, 0x000fe200078e022fULL,
0x000000f026257812ULL, 0x000fe200078ec0ffULL, 0x00000010021f7824ULL, 0x000fe400078e00ffULL,
0x000000012c1c7824ULL, 0x000fc400078e0235ULL, 0x0000000116157824ULL, 0x040fe200078e022fULL,
0xfffffff01f1e7812ULL, 0x000fe200078ee214ULL, 0x0000001016207824ULL, 0x000fe400078e00ffULL,
0x0000000100037824ULL, 0x000fe400078e0a03ULL, 0x000000011c1d7824ULL, 0x000fe200078e022fULL,
0xfffffff020207812ULL, 0x000fe200078ee215ULL, 0x000000101c347824ULL, 0x000fe200078e00ffULL,
0x000000032c157217ULL, 0x000fe20007800000ULL, 0x00000100ff1f7424ULL, 0x000fc400078e00ffULL,
0x0000000102027824ULL, 0x000fe200078e0217ULL, 0xfffffff034347812ULL, 0x000fe200078ee21dULL,
0x000000012c007824ULL, 0x000fe400078e023dULL, 0x0000000116147824ULL, 0x000fe400078e0217ULL,
0x00005e0002027625ULL, 0x000fc800078e001fULL, 0x000000011c167824ULL, 0x100fe200078e0217ULL,
0x00000025021c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000100177824ULL, 0x040fe400078e0217ULL,
0x00000001001d7824ULL, 0x040fe400078e022fULL, 0x0000001000267824ULL, 0x000fe400078e00ffULL,
0x0000000115007824ULL, 0x000fe400078e0a2cULL, 0x00005e0014147625ULL, 0x000fe200078e001fULL,
0xfffffff026267812ULL, 0x000fc400078ee21dULL, 0x000000002100720cULL, 0x080fe20003f66070ULL,
0x000000ffff1d7224ULL, 0x000fe200000e0603ULL, 0x0000002514147210ULL, 0x000fe20007f9e0ffULL,
0x00005e0016027625ULL, 0x080fe200078e001fULL, 0x000000002700720cULL, 0x080fe40003f46070ULL,
0x000000003500720cULL, 0x080fe20003f06070ULL, 0x00005e0017167625ULL, 0x000fe200078e001fULL,
0x0000002502027210ULL, 0x080fe40007fbe0ffULL, 0x000140001e1f7811ULL, 0x000fe200078e20ffULL,
0x000000ffff157224ULL, 0x000fe200020e0615ULL, 0x000000003d00720cULL, 0x000fe20003f86070ULL,
0x000000ffff037224ULL, 0x000fe200028e0603ULL, 0x0000002516167210ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c1f7faeULL, 0x0003e2000d901c46ULL,
0x0001400020217811ULL, 0x000fc400078e20ffULL, 0x0001400034257811ULL, 0x000fe200078e20ffULL,
0x000000ffff177224ULL, 0x000fe200030e0617ULL, 0x0001400026277811ULL, 0x000fe200078e20ffULL,
0x0000000014217faeULL, 0x0003e8000d101c46ULL, 0x0000000002257faeULL, 0x0003e8000c101c46ULL,
0x0000000016277faeULL, 0x0003e2000e101c46ULL, 0x000002d000007947ULL, 0x000fea0003800000ULL,
0x000000012c007824ULL, 0x000fe200078e0221ULL, 0x000000f026217812ULL, 0x000fe200078ec0ffULL,
0x00000100ff1f7424ULL, 0x000fc400078e00ffULL, 0x0000000100027824ULL, 0x040fe200078e022fULL,
0x0000000400167810ULL, 0x040fe20007ffe0ffULL, 0x00000010001d7824ULL, 0x040fe200078e00ffULL,
0x0000000200147810ULL, 0x000fc60007ffe0ffULL, 0x0000000116157824ULL, 0x140fe200078e022fULL,
0xfffffff01d1e7812ULL, 0x000fe200078ee202ULL, 0x00000010161c7824ULL, 0x000fe400078e00ffULL,
0x0000000114037824ULL, 0x040fe400078e022fULL, 0x0000001014207824ULL, 0x000fe200078e00ffULL,
0xfffffff01c257812ULL, 0x000fe200078ee215ULL, 0x00000001001c7824ULL, 0x140fe200078e0217ULL,
0x0000000600007810ULL, 0x000fe20007ffe0ffULL, 0x0000000114027824ULL, 0x000fe200078e0217ULL,
0xfffffff020207812ULL, 0x000fe200078ee203ULL, 0x00005e001c1c7625ULL, 0x000fe200078e001fULL,
0x0001400025257811ULL, 0x000fc600078e20ffULL, 0x0000000116147824ULL, 0x100fe200078e0217ULL,
0x000000211c1c7210ULL, 0x000fe20007f5e0ffULL, 0x0000000100167824ULL, 0x000fe400078e0217ULL,
0x00005e0002027625ULL, 0x000fc800078e001fULL, 0x00005e0014147625ULL, 0x000fe200078e001fULL,
0x0000002102027210ULL, 0x000fc60007f1e0ffULL, 0x00005e0016167625ULL, 0x000fe200078e001fULL,
0x000140001e1f7811ULL, 0x000fc600078e20ffULL, 0x0000000100267824ULL, 0x000fe200078e022fULL,
0x0000002116167210ULL, 0x080fe20007f7e0ffULL, 0x0000001000277824ULL, 0x000fe400078e00ffULL,
0x000000ffff1d7224ULL, 0x000fe200010e061dULL, 0x0000002114147210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff037224ULL, 0x000fe200000e0603ULL, 0xfffffff027267812ULL, 0x000fe200078ee226ULL,
0x000000ffff177224ULL, 0x000fe200018e0617ULL, 0x0001400020217811ULL, 0x000fe200078e20ffULL,
0x000000ffff157224ULL, 0x000fe200010e0615ULL, 0x0001400026277811ULL, 0x000fe200078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c1f7faeULL, 0x0003e8000b901c46ULL,
0x0000000002217faeULL, 0x0003e8000b901c46ULL, 0x0000000014257faeULL, 0x0003e8000b901c46ULL,
0x0000000016277faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0186a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0186a800ff027f8cULL, 0x002e64000c80043fULL,
0x000000ffff3d7224ULL, 0x002fc400078e0003ULL, 0x0000000000027805ULL, 0x000fca0000015200ULL,
0x0186b400ff157984ULL, 0x000e640000000800ULL, 0x8000000015ff7812ULL, 0x002fc4000780483fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff167224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001402177210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e03ULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011415ULL,
0x0000001700007211ULL, 0x000fca00078110ffULL, 0x000000ffff157224ULL, 0x000fca00000e0615ULL,
0x0000000200007819ULL, 0x000fc80000001215ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000116167810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0186b400ff157984ULL, 0x000e640000000800ULL,
0x8000000015ff7812ULL, 0x002fe4000780483fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000018000007945ULL, 0x000fe20003800000ULL, 0x0000016000001947ULL, 0x000fea0003800000ULL,
0x00000024ff00723eULL, 0x000fe400000010ffULL, 0x00000002ff037819ULL, 0x000fe4000001162fULL,
0x0000541000007816ULL, 0x000fe20000000000ULL, 0x0000a9627f007947ULL, 0x000fea000b800000ULL,
0x00001f0300237589ULL, 0x0002a400000e0000ULL, 0x0000000803597810ULL, 0x002fe20007ffe0ffULL,
0x0000a9b27f007947ULL, 0x000fea000b800000ULL, 0x00001f5900227589ULL, 0x0002e400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001003597810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff587224ULL, 0x000fe200078e0000ULL, 0x00016a3000407802ULL, 0x000fe20000000f00ULL,
0x0000001fff5a7424ULL, 0x000fc400078e00ffULL, 0xffffffffff5b7424ULL, 0x000fc400078e00ffULL,
0x0000af4000007944ULL, 0x00cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001803597810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff587224ULL, 0x004fe200078e0000ULL,
0x00016aa000407802ULL, 0x000fe20000000f00ULL, 0x0000001fff5a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff5b7424ULL, 0x000fc400078e00ffULL, 0x0000aed000007944ULL, 0x008fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000003840783bULL, 0x000f280000004200ULL, 0x00000000394c783bULL, 0x000fe80000004200ULL,
0x000000003614783bULL, 0x000e680000004200ULL, 0x00000000371c783bULL, 0x000ee20000004200ULL,
0x00000018ff217819ULL, 0x010fe20000011442ULL, 0x0000010040697824ULL, 0x000fe200078e00ffULL,
0x0000004000b67306ULL, 0x000fe20000009400ULL, 0x00000018ff007819ULL, 0x002fc40000011440ULL,
0x00000018ff037819ULL, 0x000fe40000011441ULL, 0x00000018ff697819ULL, 0x000fe40000011469ULL,
0x00000018ff267819ULL, 0x000fe20000011443ULL, 0x0000002100b37306ULL, 0x000fe20000209400ULL,
0x00000018ff397819ULL, 0x000fe40000011417ULL, 0x00000018ff6d7819ULL, 0x008fe4000001141dULL,
0x00000018ff707819ULL, 0x000fc4000001141fULL, 0x00000018ff6e7819ULL, 0x000fe2000001141eULL,
0x0000002100b07306ULL, 0x000ff00000205400ULL, 0x0000002100777306ULL, 0x0003f0000020d400ULL,
0x0000006900787306ULL, 0x000fe20000209400ULL, 0x00000018ff217819ULL, 0x002fce000001144eULL,
0x0000002100a27306ULL, 0x000ff00000209400ULL, 0x0000002100a17306ULL, 0x000ff00000205400ULL,
0x0000002100617306ULL, 0x0003f0000020d400ULL, 0x0000006900b77306ULL, 0x000ee20000205400ULL,
0x00000018ff217819ULL, 0x002fce0000011416ULL, 0x0000002100647306ULL, 0x000ff00000209400ULL,
0x0000002100657306ULL, 0x000fe20000205400ULL, 0x000000b77800720bULL, 0x008fe20003f1d000ULL,
0x000001001eb77824ULL, 0x000fca00078e00ffULL, 0x00000018ffb77819ULL, 0x000fe200000114b7ULL,
0x0000002100517306ULL, 0x000ff0000020d400ULL, 0x0000006d00547306ULL, 0x000ff00000209400ULL,
0x0000006d00557306ULL, 0x000ff00000205400ULL, 0x0000006d00217306ULL, 0x0003f0000020d400ULL,
0x0000004000817306ULL, 0x000ee20000005400ULL, 0x00000100416d7824ULL, 0x002fca00078e00ffULL,
0x00000018ff6d7819ULL, 0x000fe4000001146dULL, 0x0000004000937306ULL, 0x0003f0000000d400ULL,
0x00000069009c7306ULL, 0x0008a2000020d400ULL, 0x0001000040407824ULL, 0x002fe200078e00ffULL,
0x00000081b600720bULL, 0x008fe20003f7d000ULL, 0x000100001db67824ULL, 0x000fc600078e00ffULL,
0x00000018ff407819ULL, 0x000fe40000011440ULL, 0x0000006d00be7306ULL, 0x000fe20000209400ULL,
0x0000010042697824ULL, 0x010fe200078e00ffULL, 0x00000018ffb67819ULL, 0x000fc800000114b6ULL,
0x00000018ff697819ULL, 0x000fe40000011469ULL, 0x0000006d00bb7306ULL, 0x000e620000205400ULL,
0x000000019c9c0812ULL, 0x004fe400078efcffULL, 0x0000000193933812ULL, 0x000fca00078efcffULL,
0x0000004100b47306ULL, 0x000ff00000009400ULL, 0x0000004100677306ULL, 0x000ea20000005400ULL,
0x000000bbbe00720bULL, 0x002fce0003f1d000ULL, 0x0000004000ba7306ULL, 0x000ff00000209400ULL,
0x0000004000b97306ULL, 0x000e620000205400ULL, 0x00000067b400720bULL, 0x004fce0003fdd000ULL,
0x00000040009a7306ULL, 0x0005f0000020d400ULL, 0x0000004100927306ULL, 0x000722000000d400ULL,
0x0000010043407824ULL, 0x004fe200078e00ffULL, 0x000000b9ba00720bULL, 0x002fc80003fbd000ULL,
0x00000018ff407819ULL, 0x000fe40000011440ULL, 0x0000006d00a37306ULL, 0x000e62000020d400ULL,
0x0001000041417824ULL, 0x008fca00078e00ffULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x0000004000c07306ULL, 0x000fe20000209400ULL, 0x0000000192926812ULL, 0x010fe400078efcffULL,
0x000000019a9a5812ULL, 0x000fca00078efcffULL, 0x0000004000bf7306ULL, 0x000ea20000205400ULL,
0x00000001a3a30812ULL, 0x002fce00078efcffULL, 0x0000004300ab7306ULL, 0x000ff00000009400ULL,
0x0000004300887306ULL, 0x000e620000005400ULL, 0x000000bfc000720bULL, 0x004fce0003f1d000ULL,
0x0000004100c27306ULL, 0x000ff00000209400ULL, 0x0000004100c17306ULL, 0x000ea20000205400ULL,
0x00000088ab00720bULL, 0x002fce0003fdd000ULL, 0x00000041008a7306ULL, 0x0003f0000020d400ULL,
0x0000004000867306ULL, 0x000722000020d400ULL, 0x000001004c417824ULL, 0x002fe200078e00ffULL,
0x000000c1c200720bULL, 0x004fc80003f7d000ULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x00000043007d7306ULL, 0x0002a2000000d400ULL, 0x000001004d407824ULL, 0x008fca00078e00ffULL,
0x00000018ff407819ULL, 0x000fe40000011440ULL, 0x0000004100c87306ULL, 0x000fe20000209400ULL,
0x0001000043437824ULL, 0x002fe200078e00ffULL, 0x0000000186860812ULL, 0x010fe400078efcffULL,
0x000000018a8a3812ULL, 0x000fe400078efcffULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0x0000004100c77306ULL, 0x000e620000205400ULL, 0x000000017d7d6812ULL, 0x004fce00078efcffULL,
0x0000004c00a87306ULL, 0x000ff00000009400ULL, 0x0000004c00a77306ULL, 0x000ea20000005400ULL,
0x000000c7c800720bULL, 0x002fce0003f1d000ULL, 0x00000000008d7306ULL, 0x000ff00000209400ULL,
0x0000000000827306ULL, 0x000e620000205400ULL, 0x000000a7a800720bULL, 0x004fce0003fdd000ULL,
0x0000000300b87306ULL, 0x000ff00000209400ULL, 0x0000000300b57306ULL, 0x000ea20000205400ULL,
0x000000828d00720bULL, 0x002fe20003f9d000ULL, 0x000100001e8d7824ULL, 0x000fc400078e00ffULL,
0x000100001f827824ULL, 0x000fc600078e00ffULL, 0x00000018ff8d7819ULL, 0x000fe2000001148dULL,
0x0000000300837306ULL, 0x0002e2000020d400ULL, 0x00000018ff827819ULL, 0x000fce0000011482ULL,
0x0000004d00a57306ULL, 0x000fe20000009400ULL, 0x00000018ff037819ULL, 0x002fe4000001144dULL,
0x000000b5b800720bULL, 0x004fe20003f5d000ULL, 0x000001001fb57824ULL, 0x000fc800078e00ffULL,
0x0000004d00a67306ULL, 0x000fe20000005400ULL, 0x00000018ffb57819ULL, 0x000fce00000114b5ULL,
0x0000004d00687306ULL, 0x0003e2000000d400ULL, 0x0000000183832812ULL, 0x008fe400078efcffULL,
0x000000b0b300720bULL, 0x000fca0003f5d000ULL, 0x00000000008f7306ULL, 0x0004e2000020d400ULL,
0x000100004d4d7824ULL, 0x002fca00078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x0000006900bd7306ULL, 0x000fe20000209400ULL, 0x00000018ff007819ULL, 0x004fe4000001144cULL,
0x0000000177772812ULL, 0x000fca00078efcffULL, 0x0000006900bc7306ULL, 0x000e620000205400ULL,
0x000000018f8f4812ULL, 0x008fce00078efcffULL, 0x0000004100747306ULL, 0x0004f0000020d400ULL,
0x0000004200ac7306ULL, 0x000fe20000009400ULL, 0x000001004e417824ULL, 0x004fe200078e00ffULL,
0x000000bcbd00720bULL, 0x002fc80003fbd000ULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x0000004200af7306ULL, 0x000e620000005400ULL, 0x0000000174740812ULL, 0x008fce00078efcffULL,
0x00000042007e7306ULL, 0x0004f0000000d400ULL, 0x0000000300aa7306ULL, 0x000fe20000209400ULL,
0x0001000042427824ULL, 0x004fe200078e00ffULL, 0x000000afac00720bULL, 0x002fc80003f9d000ULL,
0x00000018ff427819ULL, 0x000fe40000011442ULL, 0x0000000300a97306ULL, 0x000e6e0000205400ULL,
0x000000017e7e4812ULL, 0x008fe200078efcffULL, 0x0000004c006f7306ULL, 0x0004f0000000d400ULL,
0x0000000000ae7306ULL, 0x000fe20000209400ULL, 0x000000a9aa00720bULL, 0x002fe20003f1d000ULL,
0x000100004c4c7824ULL, 0x004fca00078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe2000001144cULL,
0x0000000000ad7306ULL, 0x000fe20000205400ULL, 0x000000016f6f6812ULL, 0x008fce00078efcffULL,
0x00000000006c7306ULL, 0x0003f0000020d400ULL, 0x0000004d00d17306ULL, 0x000fe20000209400ULL,
0x00000018ff007819ULL, 0x002fce0000011414ULL, 0x0000004d00d27306ULL, 0x000e700000205400ULL,
0x0000002600b27306ULL, 0x000ff00000209400ULL, 0x0000002600b17306ULL, 0x000ea20000205400ULL,
0x000000d2d100720bULL, 0x002fce0003fdd000ULL, 0x0000002600767306ULL, 0x0002f0000020d400ULL,
0x0000004000c97306ULL, 0x000fe20000209400ULL, 0x00000018ff267819ULL, 0x002fe4000001144fULL,
0x000000b1b200720bULL, 0x004fca0003f9d000ULL, 0x0000004000ca7306ULL, 0x000e700000205400ULL,
0x0000004000737306ULL, 0x000522000020d400ULL, 0x0000000176764812ULL, 0x008fce00078efcffULL,
0x0000004f009e7306ULL, 0x000fe20000009400ULL, 0x000001004f407824ULL, 0x004fe200078e00ffULL,
0x000000cac900720bULL, 0x002fcc0003f5d000ULL, 0x0000004f009b7306ULL, 0x000fee0000005400ULL,
0x0000000173732812ULL, 0x010fe200078efcffULL, 0x0000004f00607306ULL, 0x0003f0000000d400ULL,
0x0000004e009d7306ULL, 0x000fe20000009400ULL, 0x000100004f4f7824ULL, 0x002fce00078e00ffULL,
0x0000004e00a07306ULL, 0x000ff00000005400ULL, 0x0000004e00667306ULL, 0x0003f0000000d400ULL,
0x0000000000977306ULL, 0x000fe20000209400ULL, 0x000100004e4e7824ULL, 0x002fce00078e00ffULL,
0x0000000000987306ULL, 0x000ff00000205400ULL, 0x00000000005a7306ULL, 0x0003f0000020d400ULL,
0x0000004300c67306ULL, 0x000fe20000209400ULL, 0x00000018ff007819ULL, 0x002fce000001141cULL,
0x0000004300c57306ULL, 0x000ff00000205400ULL, 0x00000043007b7306ULL, 0x0003f0000020d400ULL,
0x0000001400377306ULL, 0x000fe20000009400ULL, 0x0000010014437824ULL, 0x002fca00078e00ffULL,
0x00000018ff437819ULL, 0x000fe40000011443ULL, 0x0000001400367306ULL, 0x000ff00000005400ULL,
0x00000014005d7306ULL, 0x0003f0000000d400ULL, 0x0000000300637306ULL, 0x0004e2000020d400ULL,
0x0001000014147824ULL, 0x002fca00078e00ffULL, 0x00000018ff147819ULL, 0x000fe40000011414ULL,
0x0000006900877306ULL, 0x000e62000020d400ULL, 0x00000018ff037819ULL, 0x004fce0000011415ULL,
0x0000004200c37306ULL, 0x000fe20000209400ULL, 0x0000000163630812ULL, 0x008fe400078efcffULL,
0x000000363700720bULL, 0x000fe40003f1d000ULL, 0x000138003b367811ULL, 0x000fc600078e20ffULL,
0x0000004200c47306ULL, 0x000ea20000205400ULL, 0x0000000187875812ULL, 0x002fe400078efcffULL,
0x000000c5c600720bULL, 0x000fe40003fbd000ULL, 0x0000007e877e723eULL, 0x000fc600000010ffULL,
0x00000042007c7306ULL, 0x0002e2000020d400ULL, 0x000000015d5d0812ULL, 0x000fce00078efcffULL,
0x0000004100cc7306ULL, 0x000fe20000209400ULL, 0x00000018ff427819ULL, 0x002fe40000011440ULL,
0x00000018ff407819ULL, 0x000fe4000001144eULL, 0x000000c4c300720bULL, 0x004fe40003f7d000ULL,
0x000000017b7b5812ULL, 0x000fe200078efcffULL, 0x0000004100cb7306ULL, 0x000e620000205400ULL,
0x000000adae00720bULL, 0x000fce0003fbd000ULL, 0x00000041006d7306ULL, 0x000524000020d400ULL,
0x000000017c7c3812ULL, 0x008fe400078efcffULL, 0x000000a6a500720bULL, 0x000fe40003f7d000ULL,
0x000000016c6c5812ULL, 0x000fe400078efcffULL, 0x0000002600a47306ULL, 0x000fe20000209400ULL,
0x00000018ff417819ULL, 0x004fe4000001144fULL, 0x0000009b9e00720bULL, 0x000fc40003fbd000ULL,
0x000000cbcc00720bULL, 0x002fe40003f5d000ULL, 0x0000007c777c723eULL, 0x000fe200000010ffULL,
0x00000026009f7306ULL, 0x000fe20000205400ULL, 0x0000000168683812ULL, 0x000fe400078efcffULL,
0x000000a09d00720bULL, 0x000fe40003f7d000ULL, 0x000000687373723eULL, 0x000fc600000010ffULL,
0x00000026005c7306ULL, 0x000fe2000020d400ULL, 0x0000000160605812ULL, 0x000fe400078efcffULL,
0x000000016d6d2812ULL, 0x010fe400078efcffULL, 0x000000a1a200720bULL, 0x000fc60003f5d000ULL,
0x00000039005f7306ULL, 0x000fe20000209400ULL, 0x0000000166663812ULL, 0x000fc800078efcffULL,
0x000000666d68723eULL, 0x000fc600000010ffULL, 0x0000003900627306ULL, 0x000fe40000205400ULL,
0x0000000161612812ULL, 0x000fcc00078efcffULL, 0x0000003900387306ULL, 0x000ff0000020d400ULL,
0x0000000000587306ULL, 0x000ff00000209400ULL, 0x0000000000597306ULL, 0x000ff00000205400ULL,
0x0000000000267306ULL, 0x000ff0000020d400ULL, 0x0000007000397306ULL, 0x000ff00000209400ULL,
0x00000070003e7306ULL, 0x000ff00000205400ULL, 0x0000007000007306ULL, 0x000ff0000020d400ULL,
0x0000004d00707306ULL, 0x000e70000020d400ULL, 0x0000004100da7306ULL, 0x000ff00000209400ULL,
0x0000004100d97306ULL, 0x000ea20000205400ULL, 0x0000000170706812ULL, 0x002fce00078efcffULL,
0x00000041004f7306ULL, 0x0002f0000020d400ULL, 0x0000000300807306ULL, 0x000fe20000209400ULL,
0x0000010016417824ULL, 0x002fe200078e00ffULL, 0x000000d9da00720bULL, 0x004fcc0003f7d000ULL,
0x00000003007f7306ULL, 0x000fee0000205400ULL, 0x000000014f4f3812ULL, 0x008fe200078efcffULL,
0x0000000300537306ULL, 0x000ff0000020d400ULL, 0x0000004000d37306ULL, 0x000ff00000209400ULL,
0x0000004000d47306ULL, 0x000e700000205400ULL, 0x0000006e003f7306ULL, 0x000ff00000209400ULL,
0x0000006e00527306ULL, 0x000fe20000205400ULL, 0x000000d4d300720bULL, 0x002fce0003fdd000ULL,
0x0000006e00037306ULL, 0x000ff0000020d400ULL, 0x00000040006e7306ULL, 0x0002b0000020d400ULL,
0x0000001400d67306ULL, 0x000fe20000209400ULL, 0x0000010015407824ULL, 0x002fca00078e00ffULL,
0x00000018ff407819ULL, 0x000fe40000011440ULL, 0x0000001400d57306ULL, 0x000e620000205400ULL,
0x000000016e6e6812ULL, 0x004fc800078efcffULL, 0x0000006e616e723eULL, 0x000fc600000010ffULL,
0x00000014004d7306ULL, 0x0004f0000020d400ULL, 0x0000004300dc7306ULL, 0x000fe20000209400ULL,
0x00000018ff147819ULL, 0x004fe20000011441ULL, 0x0000010017417824ULL, 0x000fe200078e00ffULL,
0x000000d5d600720bULL, 0x002fc80003f7d000ULL, 0x00000018ffdd7819ULL, 0x000fe20000011441ULL,
0x0000004300db7306ULL, 0x000e700000205400ULL, 0x00000043004e7306ULL, 0x000ea2000020d400ULL,
0x000000014d4d3812ULL, 0x008fce00078efcffULL, 0x0000001500357306ULL, 0x000fe20000009400ULL,
0x000000dbdc00720bULL, 0x002fce0003fbd000ULL, 0x0000001500347306ULL, 0x000e6c0000005400ULL,
0x000000014e4e5812ULL, 0x004fe400078efcffULL, 0x0000001500577306ULL, 0x0004e2000000d400ULL,
0x000000989700720bULL, 0x000fce0003fbd000ULL, 0x0000001400897306ULL, 0x000fe20000209400ULL,
0x0001000015157824ULL, 0x004fe200078e00ffULL, 0x000000343500720bULL, 0x002fe40003fdd000ULL,
0x000000003634783bULL, 0x000e640000000200ULL, 0x00000018ff157819ULL, 0x000fe40000011415ULL,
0x00000014008e7306ULL, 0x000ea20000205400ULL, 0x000000015a5a5812ULL, 0x000fe400078efcffULL,
0x0000007f8000720bULL, 0x000fc40003fbd000ULL, 0x0000007d867f723eULL, 0x000fe400000010ffULL,
0x0000000157576812ULL, 0x008fe200078efcffULL, 0x0000001400437306ULL, 0x000722000020d400ULL,
0x0000007b767d723eULL, 0x000fe400000010ffULL, 0x0000004d5a5a723eULL, 0x000fca00000010ffULL,
0x0000004000d87306ULL, 0x000fe20000209400ULL, 0x000001001c147824ULL, 0x008fe200078e00ffULL,
0x0000008e8900720bULL, 0x004fe40003fdd000ULL, 0x0000000153535812ULL, 0x000fe400078efcffULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x0000004000d77306ULL, 0x000eae0000205400ULL,
0x0000000143436812ULL, 0x010fe200078efcffULL, 0x0000001600957306ULL, 0x000fe20000009400ULL,
0x0000002334349231ULL, 0x002fc400003400ffULL, 0x0000002336369231ULL, 0x000fca00003400ffULL,
0x0000001600967306ULL, 0x000e620000005400ULL, 0x000000d7d800720bULL, 0x004fe20003f1d000ULL,
0x0000002235359231ULL, 0x080fe400003400ffULL, 0x0000002237379231ULL, 0x000fc800003400ffULL,
0x0000001600567306ULL, 0x0004f0000000d400ULL, 0x0000001700997306ULL, 0x000fe20000009400ULL,
0x0001000016167824ULL, 0x004fe200078e00ffULL, 0x000000969500720bULL, 0x002fc80003f5d000ULL,
0x00000018ff167819ULL, 0x000fe40000011416ULL, 0x0000001700947306ULL, 0x000fee0000005400ULL,
0x0000000156562812ULL, 0x008fe200078efcffULL, 0x0000001700507306ULL, 0x0003e2000000d400ULL,
0x000000656400720bULL, 0x000fce0003f5d000ULL, 0x0000004c00ce7306ULL, 0x000fe20000209400ULL,
0x0001000017177824ULL, 0x002fca00078e00ffULL, 0x00000018ff177819ULL, 0x000fe40000011417ULL,
0x0000004c00cd7306ULL, 0x000e620000205400ULL, 0x0000000151512812ULL, 0x000fce00078efcffULL,
0x0000004200cf7306ULL, 0x000ff00000209400ULL, 0x0000004200d07306ULL, 0x000fe20000205400ULL,
0x000000cdce00720bULL, 0x002fce0003f9d000ULL, 0x0000004200697306ULL, 0x000ff0000020d400ULL,
0x00000015008c7306ULL, 0x000ff00000209400ULL, 0x00000015008b7306ULL, 0x000ff00000205400ULL,
0x0000001500427306ULL, 0x0003f0000020d400ULL, 0x0000001400b47306ULL, 0x000fe20000209400ULL,
0x000001001d157824ULL, 0x002fce00078e00ffULL, 0x0000001400af7306ULL, 0x000ff00000205400ULL,
0x0000001400887306ULL, 0x0003f0000020d400ULL, 0x0000004c00757306ULL, 0x000ea2000020d400ULL,
0x000138003a147811ULL, 0x002fce00078e20ffULL, 0x0000001d00727306ULL, 0x000ff00000009400ULL,
0x0000001d00717306ULL, 0x000fe20000005400ULL, 0x0000000175754812ULL, 0x004fe400078efcffULL,
0x000000d0cf00720bULL, 0x000fca0003f9d000ULL, 0x0000001d00257306ULL, 0x0003f0000000d400ULL,
0x00000040004c7306ULL, 0x000ea2000020d400ULL, 0x00000018ff1d7819ULL, 0x002fe40000011415ULL,
0x0000000169694812ULL, 0x000fc400078efcffULL, 0x0000009fa400720bULL, 0x000fe40003f9d000ULL,
0x000000606969723eULL, 0x000fe200000010ffULL, 0x0000001600797306ULL, 0x000ff00000209400ULL,
0x00000016007a7306ULL, 0x000e620000205400ULL, 0x000000014c4c0812ULL, 0x004fc400078efcffULL,
0x0000008b8c00720bULL, 0x000fe40003f1d000ULL, 0x000000015c5c4812ULL, 0x000fe400078efcffULL,
0x000000949900720bULL, 0x000fe20003f9d000ULL, 0x0000001600407306ULL, 0x000eb0000020d400ULL,
0x0000001700787306ULL, 0x000fe20000209400ULL, 0x0000000142420812ULL, 0x000fc400078efcffULL,
0x0000007a7900720bULL, 0x002fe40003fdd000ULL, 0x0000000150504812ULL, 0x000fe400078efcffULL,
0x000000625f00720bULL, 0x000fe20003f9d000ULL, 0x0000001700817306ULL, 0x000ff00000205400ULL,
0x0000001700677306ULL, 0x0003e2000020d400ULL, 0x0000000140406812ULL, 0x004fc400078efcffULL,
0x000000afb400720bULL, 0x000fe40003fdd000ULL, 0x0000000138384812ULL, 0x000fe400078efcffULL,
0x000000595800720bULL, 0x000fe20003f9d000ULL, 0x000000dd00857306ULL, 0x000fe20000209400ULL,
0x000000001414783bULL, 0x002e620000000200ULL, 0x000000405140723eULL, 0x000fcc00000010ffULL,
0x000000dd00847306ULL, 0x000ea20000205400ULL, 0x0000000188886812ULL, 0x000fc600078efcffULL,
0x0000000126264812ULL, 0x000fe400078efcffULL, 0x0000003e3900720bULL, 0x000fe40003f9d000ULL,
0x000000dd00417306ULL, 0x000ef0000020d400ULL, 0x0000001c00907306ULL, 0x000fe20000009400ULL,
0x000000848500720bULL, 0x004fc40003f1d000ULL, 0x0000000100004812ULL, 0x000fca00078efcffULL,
0x0000001c00917306ULL, 0x000eac0000005400ULL, 0x0000000141410812ULL, 0x008fe400078efcffULL,
0x0000001c00277306ULL, 0x000722000000d400ULL, 0x0000002314149231ULL, 0x082fe200003400ffULL,
0x000000817800720bULL, 0x000fe20003f1d000ULL, 0x0000002316169231ULL, 0x000fc400003400ffULL,
0x0000002215159231ULL, 0x080fe400003400ffULL, 0x0000002217179231ULL, 0x000fe200003400ffULL,
0x0000001d00ab7306ULL, 0x000fe20000209400ULL, 0x000100001c1c7824ULL, 0x008fe200078e00ffULL,
0x000000919000720bULL, 0x004fe40003f7d000ULL, 0x000000717200720bULL, 0x000fe40003f3d000ULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x0000007e1444723cULL, 0x000fe20000041844ULL,
0x0000001d00a67306ULL, 0x000e620000205400ULL, 0x0000000167670812ULL, 0x000fc400078efcffULL,
0x0000006f7472723eULL, 0x000fe400000010ffULL, 0x0000004f5c6f723eULL, 0x000fe400000010ffULL,
0x0000000127273812ULL, 0x010fe200078efcffULL, 0x0000001d003a7306ULL, 0x0004e2000020d400ULL,
0x000000555400720bULL, 0x000fe20003f7d000ULL, 0x0000007c1410723cULL, 0x000fe20000041810ULL,
0x0000000125251812ULL, 0x000fe400078efcffULL, 0x000000523f00720bULL, 0x000fc40003f3d000ULL,
0x000000278888723eULL, 0x000fe200000010ffULL, 0x0000001c009d7306ULL, 0x000fe20000209400ULL,
0x00000092a31d723eULL, 0x004fe200000010ffULL, 0x00000072140c723cULL, 0x000f62000004180cULL,
0x000000a6ab00720bULL, 0x002fc60003f1d000ULL, 0x0000000121213812ULL, 0x000fe400078efcffULL,
0x0000001c009e7306ULL, 0x000e640000205400ULL, 0x000000681448723cULL, 0x000fe20000041848ULL,
0x0000000103031812ULL, 0x000fca00078efcffULL, 0x0000001c003b7306ULL, 0x000522000020d400ULL,
0x000000013a3a0812ULL, 0x008fe200078efcffULL, 0x0000006e1430723cULL, 0x000fe60000041830ULL,
0x000000253a89723eULL, 0x000fc600000010ffULL, 0x0000001e006a7306ULL, 0x000fe20000009400ULL,
0x000000939c1c723eULL, 0x004fe400000010ffULL, 0x0000009e9d00720bULL, 0x002fe20003fdd000ULL,
0x00000088340c723cULL, 0x020fe8000004180cULL, 0x0000001e006b7306ULL, 0x000e680000005400ULL,
0x0000001c1404723cULL, 0x000b680000041804ULL, 0x000000b600957306ULL, 0x000fe20000209400ULL,
0x000000013b3b6812ULL, 0x010fc400078efcffULL, 0x000000756c1c723eULL, 0x020fe400000010ffULL,
0x00000070631d723eULL, 0x000fe400000010ffULL, 0x0000003b2626723eULL, 0x000fe200000010ffULL,
0x000000b600927306ULL, 0x000ea20000205400ULL, 0x0000006b6a00720bULL, 0x002fc60003fbd000ULL,
0x0000001c1408723cULL, 0x000be80000041808ULL, 0x000000b700807306ULL, 0x000fe60000209400ULL,
0x0000005d4e1c723eULL, 0x020fe400000010ffULL, 0x000000574c1d723eULL, 0x000fc600000010ffULL,
0x000000b700777306ULL, 0x000e620000205400ULL, 0x000000929500720bULL, 0x004fce0003f1d000ULL,
0x0000001e00207306ULL, 0x0004f0000000d400ULL, 0x0000001f005b7306ULL, 0x000fe20000009400ULL,
0x0000009a8f1e723eULL, 0x004fe400000010ffULL, 0x000000778000720bULL, 0x002fca0003fdd000ULL,
0x0000001f005e7306ULL, 0x000e620000005400ULL, 0x0000000120205812ULL, 0x008fce00078efcffULL,
0x0000001f00027306ULL, 0x0005f0000000d400ULL, 0x000000b600907306ULL, 0x000ee2000020d400ULL,
0x0000008a831f723eULL, 0x004fe400000010ffULL, 0x0000005e5b00720bULL, 0x002fc40003f5d000ULL,
0x00000042535b723eULL, 0x000fc600000010ffULL, 0x0000001e1418723cULL, 0x000b620000041818ULL,
0x000000b5006a7306ULL, 0x000fec0000209400ULL, 0x000000504115723eULL, 0x020fe200000010ffULL,
0x0000001c341c723cULL, 0x000b620000041804ULL, 0x000000b500637306ULL, 0x000e620000205400ULL,
0x0000000190900812ULL, 0x008fc400078efcffULL, 0x0000000102022812ULL, 0x000fe400078efcffULL,
0x000000564314723eULL, 0x000fe400000010ffULL, 0x000000673841723eULL, 0x000fe200000010ffULL,
0x000000b700717306ULL, 0x000ea2000020d400ULL, 0x000000902127723eULL, 0x000fc600000010ffULL,
0x000000143414723cULL, 0x000b680000041844ULL, 0x0000008d004f7306ULL, 0x000fe20000209400ULL,
0x000000636a00720bULL, 0x002fc60003f1d000ULL, 0x0000005a3418723cULL, 0x000b680000041818ULL,
0x0000008d004c7306ULL, 0x000e620000205400ULL, 0x0000000171716812ULL, 0x004fc600078efcffULL,
0x000000403410723cULL, 0x040b680000041810ULL, 0x0000008200047306ULL, 0x020fe80000209400ULL,
0x000000263408723cULL, 0x000b680000041808ULL, 0x0000008200057306ULL, 0x000ea20000205400ULL,
0x0000004c4f00720bULL, 0x002fce0003f7d000ULL, 0x000000b5005f7306ULL, 0x000e70000020d400ULL,
0x0000008d00067306ULL, 0x000ee2000020d400ULL, 0x000000050400720bULL, 0x004fe40003fdd000ULL,
0x000000207104723eULL, 0x000fca00000010ffULL, 0x0000008200257306ULL, 0x000ea2000020d400ULL,
0x000000015f5f0812ULL, 0x002fc800078efcffULL, 0x000000025f05723eULL, 0x000fe400000010ffULL,
0x0000000106063812ULL, 0x008fc800078efcffULL, 0x000000060302723eULL, 0x000fe400000010ffULL,
0x000000043404723cULL, 0x000b620000041848ULL, 0x0000000125256812ULL, 0x004fc800078efcffULL,
0x000000250003723eULL, 0x000fce00000010ffULL, 0x000000023430723cULL, 0x000b620000041830ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0186b800ff027f8cULL, 0x020e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0186a000ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff427224ULL, 0x002fc600078e0003ULL,
0x0000000128287810ULL, 0x000fc80007ffe0ffULL, 0x0000002b2800720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xfffe86a000007947ULL, 0x000fea000383ffffULL,
0x000000ff2b00720cULL, 0x000fe20003f05270ULL, 0x000000ffff217224ULL, 0x000fe400078e000cULL,
0x000000ffff2a7224ULL, 0x000fe400078e0006ULL, 0x000000ffff267224ULL, 0x000fe400078e000aULL,
0x000000ffff0c7224ULL, 0x000fe400078e0013ULL, 0x000000ffff2b7224ULL, 0x000fe400078e0007ULL,
0x000000ffff287224ULL, 0x000fc400078e0005ULL, 0x000000ffff277224ULL, 0x000fe400078e0004ULL,
0x000000ffff257224ULL, 0x000fe400078e000bULL, 0x000000ffff247224ULL, 0x000fe400078e0009ULL,
0x000000ffff237224ULL, 0x000fe400078e0008ULL, 0x000000ffff227224ULL, 0x000fe400078e000fULL,
0x000000ffff207224ULL, 0x000fc400078e000eULL, 0x000000ffff0a7224ULL, 0x000fe400078e000dULL,
0x000000ffff067224ULL, 0x000fe400078e0011ULL, 0x000000ffff137224ULL, 0x000fe200078e0010ULL,
0x0000036000008947ULL, 0x000fea0003800000ULL, 0x0180000029007810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x00018a6000047802ULL, 0x000fc40000000f00ULL, 0x00008d5000007944ULL, 0x006fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000002900007308ULL, 0x000ee40000001000ULL,
0xbf80000000027423ULL, 0x00cfc80000000029ULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000300007223ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006700ff037624ULL, 0x000fe400078e00ffULL, 0x00006600ff027624ULL, 0x000fca00078e00ffULL,
0x0000000602037981ULL, 0x000f28000c1e9900ULL, 0x0000000000057919ULL, 0x000ee40000000000ULL,
0x00000002ff077819ULL, 0x008fe40000011605ULL, 0x0000000805057811ULL, 0x000fe200078ff0ffULL,
0x0000000003007220ULL, 0x014fca0000410000ULL, 0x00001f0700047589ULL, 0x000ea800000e0000ULL,
0x00001f0500057589ULL, 0x000ee200000e0000ULL, 0x0000001c041c7220ULL, 0x044fe40000410000ULL,
0x0000001d041d7220ULL, 0x040fe40000410000ULL, 0x0000001804187220ULL, 0x040fe40000410000ULL,
0x0000001904197220ULL, 0x000fc40000410000ULL, 0x0000001404147220ULL, 0x040fe40000410000ULL,
0x0000001504157220ULL, 0x040fe40000410000ULL, 0x0000001304137220ULL, 0x040fe40000410000ULL,
0x0000000604067220ULL, 0x040fe40000410000ULL, 0x0000002104217220ULL, 0x040fe40000410000ULL,
0x0000000a040a7220ULL, 0x000fc40000410000ULL, 0x0000002304237220ULL, 0x040fe40000410000ULL,
0x0000002404247220ULL, 0x040fe40000410000ULL, 0x0000002704277220ULL, 0x040fe40000410000ULL,
0x0000002804287220ULL, 0x040fe40000410000ULL, 0x0000003004307220ULL, 0x040fe40000410000ULL,
0x0000003104317220ULL, 0x000fc40000410000ULL, 0x0000001e051e7220ULL, 0x048fe40000410000ULL,
0x0000001f051f7220ULL, 0x040fe40000410000ULL, 0x0000001a051a7220ULL, 0x040fe40000410000ULL,
0x0000001b051b7220ULL, 0x040fe40000410000ULL, 0x0000001605167220ULL, 0x040fe40000410000ULL,
0x0000001705177220ULL, 0x000fc40000410000ULL, 0x0000001205127220ULL, 0x040fe40000410000ULL,
0x0000000c050c7220ULL, 0x040fe40000410000ULL, 0x0000002005207220ULL, 0x040fe40000410000ULL,
0x0000002205227220ULL, 0x040fe40000410000ULL, 0x0000002605267220ULL, 0x040fe40000410000ULL,
0x0000002505257220ULL, 0x000fc40000410000ULL, 0x0000002a052a7220ULL, 0x040fe40000410000ULL,
0x0000002b052b7220ULL, 0x040fe40000410000ULL, 0x0000003205327220ULL, 0x040fe40000410000ULL,
0x0000003305337220ULL, 0x000fc40000410000ULL, 0x0000000000297919ULL, 0x002e620000000000ULL,
0x000120002e2e7811ULL, 0x000fe200078e58ffULL, 0x00000000000579c3ULL, 0x000ee20000002700ULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x00000002ff037819ULL, 0x006fc40000011629ULL,
0x0000000229007812ULL, 0x040fe200078ec0ffULL, 0x00000005040472a4ULL, 0x008fe2000f8e023fULL,
0x0000000829077811ULL, 0x000fe200078ff0ffULL, 0x00000008030d7824ULL, 0x040fe200078e00ffULL,
0x0000000300027211ULL, 0x040fe200078ff8ffULL, 0x0000000803097824ULL, 0x000fe200078e00ffULL,
0x0000000700057211ULL, 0x000fe200078ff8ffULL, 0x0000000807087824ULL, 0x000fe200078e00ffULL,
0x0000000402047810ULL, 0x040fe20007ffe0ffULL, 0x00000008030b7824ULL, 0x040fe200078e00ffULL,
0x0000000202007810ULL, 0x000fe20007ffe0ffULL, 0x00000008030f7824ULL, 0x000fe200078e00ffULL,
0xfffffff80d077812ULL, 0x000fe200078ee204ULL, 0x0000000829047824ULL, 0x000fe200078e00ffULL,
0xfffffff809037812ULL, 0x000fc400078ee202ULL, 0x0000000602027810ULL, 0x000fe40007ffe0ffULL,
0xfffffff808097812ULL, 0x000fe200078ee205ULL, 0x0000001003037824ULL, 0x000fe200078e022eULL,
0x0000002029107810ULL, 0x000fe40007ffe0ffULL, 0xfffffff80b057812ULL, 0x000fe200078ee200ULL,
0x00000010090d7824ULL, 0x000fe200078e022eULL, 0xfffffff80f0b7812ULL, 0x000fe200078ee202ULL,
0x0000001007097824ULL, 0x100fe200078e022eULL, 0x0000000804047812ULL, 0x000fe200078ec0ffULL,
0x0000001005057824ULL, 0x100fe200078e022eULL, 0x0000001c1d00723eULL, 0x000fe200000010ffULL,
0x000000100b0b7824ULL, 0x000fe200078e022eULL, 0x000000181902723eULL, 0x000fe200000010ffULL,
0x0000000103037824ULL, 0x000fe200078e0204ULL, 0x00000003ff087819ULL, 0x000fe20000011629ULL,
0x0000000104077824ULL, 0x040fe200078e0205ULL, 0x00000003ff117819ULL, 0x000fe20000011610ULL,
0x00000001040d7824ULL, 0x000fe200078e020dULL, 0x00005410000e7816ULL, 0x100fe20000000002ULL,
0x0000000104097824ULL, 0x000fe200078e0209ULL, 0x00007632000f7816ULL, 0x000fe20000000002ULL,
0x0000000108007824ULL, 0x000fc400078e0229ULL, 0x0000000110027824ULL, 0x000fe400078e0211ULL,
0x0000000e03007388ULL, 0x0003e20000000a00ULL, 0x00000001040b7824ULL, 0x000fe200078e020bULL,
0x000000232404723eULL, 0x000fe400000010ffULL, 0x0000000700037812ULL, 0x002fe400078ec0ffULL,
0x00000007020f7812ULL, 0x000fe400078ec0ffULL, 0x0ffffff803057812ULL, 0x000fc400078ef829ULL,
0x0ffffff80f0f7812ULL, 0x000fe400078ef810ULL, 0x000000141500723eULL, 0x000fe400000010ffULL,
0x000000130602723eULL, 0x000fe400000010ffULL, 0x000000210a03723eULL, 0x000fe200000010ffULL,
0x00000010050a7824ULL, 0x000fe200078e022eULL, 0x00005410000e7816ULL, 0x040fe20000000002ULL,
0x000000100f2e7824ULL, 0x000fe200078e022eULL, 0x00007632000f7816ULL, 0x000fc40000000002ULL,
0x000000272800723eULL, 0x000fe400000010ffULL, 0x000000303102723eULL, 0x000fe200000010ffULL,
0x0000000e07007388ULL, 0x0003e20000000a00ULL, 0x000000161705723eULL, 0x000fe400000010ffULL,
0x000000120c06723eULL, 0x000fc800000010ffULL, 0x00005410050c7816ULL, 0x000fe40000000006ULL,
0x00005410030e7816ULL, 0x142fe40000000004ULL, 0x00007632030f7816ULL, 0x000fe40000000004ULL,
0x0000001e1f03723eULL, 0x000fe400000010ffULL, 0x0000001a1b04723eULL, 0x000fe200000010ffULL,
0x0000000e09007388ULL, 0x0003e40000000a00ULL, 0x00005410000e7816ULL, 0x002fc40000000002ULL,
0x00007632000f7816ULL, 0x000fe40000000002ULL, 0x000000202200723eULL, 0x000fe400000010ffULL,
0x000000262502723eULL, 0x000fe200000010ffULL, 0x0000000e0b007388ULL, 0x0003e40000000a00ULL,
0x00005410030e7816ULL, 0x142fe40000000004ULL, 0x00007632030f7816ULL, 0x000fe40000000004ULL,
0x0000002a2b03723eULL, 0x000fc400000010ffULL, 0x000000323304723eULL, 0x000fe200000010ffULL,
0x0000000e0d007388ULL, 0x0003e40000000a00ULL, 0x00007632050d7816ULL, 0x002fe40000000006ULL,
0x0000000000057919ULL, 0x000e620000002600ULL, 0x0000541000067816ULL, 0x000fc60000000002ULL,
0x0004000c07007388ULL, 0x0005e40000000a00ULL, 0x0000763200077816ULL, 0x004fe40000000002ULL,
0x0000541003027816ULL, 0x140fe40000000004ULL, 0x0000763203037816ULL, 0x000fe20000000004ULL,
0x0004000609007388ULL, 0x0005e20000000a00ULL, 0x0000000805137824ULL, 0x002fc600078e00ffULL,
0x000400020b007388ULL, 0x0003e20000000a00ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000000000a0c7984ULL, 0x000ee20000000c00ULL, 0x0000000805007824ULL, 0x000fe200078e00ffULL,
0xfffffff813087812ULL, 0x000fe400078ee208ULL, 0x000000002e147984ULL, 0x000f220000000c00ULL,
0x0000000729077812ULL, 0x004fe400078ec0ffULL, 0xfffffff800117812ULL, 0x000fe400078ee211ULL,
0x0000000408087c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000411117c10ULL, 0x000fc4000ff3e0ffULL,
0x0000000710097812ULL, 0x000fe200078ec0ffULL, 0x000000ffff037224ULL, 0x002fe200000e06ffULL,
0x00005a0008027a11ULL, 0x040fe200078048ffULL, 0x000000ffff007224ULL, 0x000fe200008e06ffULL,
0x00005a0011047a11ULL, 0x000fe400078248ffULL, 0x00005b0008037a11ULL, 0x000fe400000f4c03ULL,
0x1ffffff807077812ULL, 0x000fe400078ef82cULL, 0x00005b0011057a11ULL, 0x000fc400008f4c00ULL,
0x1ffffff809097812ULL, 0x000fe200078ef82cULL, 0x0000001007027825ULL, 0x000fc800078e0002ULL,
0x0000001009047825ULL, 0x000fe200078e0004ULL, 0x0000000c02007986ULL, 0x008fe8000c101d06ULL,
0x0000001404007986ULL, 0x010fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00006600ff027624ULL, 0x000fe400078e00ffULL, 0x00006700ff037624ULL, 0x000fca00078e00ffULL,
0x00000006022a7981ULL, 0x000322000c1e9900ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000001ff0000780cULL, 0x000fe20003f04070ULL, 0x0000000210107824ULL, 0x000fe200078e00ffULL,
0x01860000ff027f8cULL, 0x002e62000c80043fULL, 0x000000402e007824ULL, 0x000fe400078e00ffULL,
0x0000580010297a24ULL, 0x000fc800078e0229ULL, 0x0000620029187a24ULL, 0x000fc800078e0200ULL,
0x00000b9000000947ULL, 0x000fea0003800000ULL, 0x00000003ff227819ULL, 0x100fe2000001162fULL,
0x00000100ff277424ULL, 0x000fe200078e00ffULL, 0x000000700c317812ULL, 0x000fe400078ec0ffULL,
0x0000000822087810ULL, 0x040fe20007ffe0ffULL, 0x0000000122157824ULL, 0x140fe200078e022fULL,
0x0000000422067810ULL, 0x040fe40007ffe0ffULL, 0x0000000c220e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000108057824ULL, 0x100fe200078e022fULL, 0x0000001022107810ULL, 0x000fe20007ffe0ffULL,
0x00000008080a7824ULL, 0x000fe200078e00ffULL, 0x0000001422147810ULL, 0x000fe20007ffe0ffULL,
0x0000000106047824ULL, 0x000fe200078e022fULL, 0x0000001822167810ULL, 0x000fe20007ffe0ffULL,
0x0000000806177824ULL, 0x000fe200078e00ffULL, 0xfffffff80a1f7812ULL, 0x000fe200078ee205ULL,
0x000000010e077824ULL, 0x040fe200078e022fULL, 0x000000002d057217ULL, 0x000fe20007800000ULL,
0x000000080e0a7824ULL, 0x000fe200078e00ffULL, 0xfffffff817177812ULL, 0x000fe200078ee204ULL,
0x0000000118047824ULL, 0x000fe200078e0222ULL, 0x00000007151c7812ULL, 0x000fe200078ec0ffULL,
0x0000000105197824ULL, 0x000fe200078e0a00ULL, 0xfffffff80a217812ULL, 0x000fe200078ee207ULL,
0x00005e0004047625ULL, 0x000fe200078e0027ULL, 0x0000001c221e7810ULL, 0x000fc40007ffe0ffULL,
0x000000190600720cULL, 0x080fe20003f86070ULL, 0x0000000118067824ULL, 0x040fe200078e0206ULL,
0x00000004310a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000118077824ULL, 0x000fe200078e0208ULL,
0x000000190800720cULL, 0x080fe20003f46070ULL, 0x0000000110097824ULL, 0x000fe200078e022fULL,
0x000000190e00720cULL, 0x080fe20003f66070ULL, 0x00000008100c7824ULL, 0x000fe200078e00ffULL,
0x000020002e1a7811ULL, 0x000fe200078e70ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e0605ULL,
0x000000191000720cULL, 0x000fe20003f06070ULL, 0x00005e0006047625ULL, 0x000fe200078e0027ULL,
0xfffffff80c237812ULL, 0x000fc400078ee209ULL, 0x0ffffff81c1b7812ULL, 0x000fe200078ef82fULL,
0x00005e0007067625ULL, 0x000fe200078e0027ULL, 0x00000004310c7210ULL, 0x040fe40007f3e0ffULL,
0x0000002022207810ULL, 0x000fe20007ffe0ffULL, 0x0000000118087824ULL, 0x040fe200078e020eULL,
0x00000006310e7210ULL, 0x000fe20007fbe0ffULL, 0x0000000118067824ULL, 0x000fe400078e0210ULL,
0x000000ffff0d7224ULL, 0x000fe400008e0605ULL, 0x000000ffff0f7224ULL, 0x000fc400028e0607ULL,
0x00005e0008047625ULL, 0x000fc800078e0027ULL, 0x0000000118097824ULL, 0x000fe200078e0214ULL,
0x0000000431107210ULL, 0x000fe20007f3e0ffULL, 0x00005e0006067625ULL, 0x000fc800078e0027ULL,
0x00005e0009087625ULL, 0x000fe200078e0027ULL, 0x0000000631127210ULL, 0x000fc60007fbe0ffULL,
0x0000000118047824ULL, 0x000fe200078e0216ULL, 0x0000000831087210ULL, 0x000fe20007fde0ffULL,
0x000000ffff117224ULL, 0x000fe200008e0605ULL, 0x000000191400720cULL, 0x080fe20003f26070ULL,
0x000000ffff137224ULL, 0x000fe200028e0607ULL, 0x000000192200720cULL, 0x000fe20003fa6070ULL,
0x00005e0004047625ULL, 0x000fc800078e0027ULL, 0x000000ffff097224ULL, 0x000fe400030e0609ULL,
0x0000000114067824ULL, 0x040fe400078e022fULL, 0x0000000814257824ULL, 0x000fe200078e00ffULL,
0x0000000431147210ULL, 0x000fe20007fde0ffULL, 0x0000000118047824ULL, 0x000fe400078e021eULL,
0x000000101b1b7824ULL, 0x000fe200078e021aULL, 0xfffffff825257812ULL, 0x000fe200078ee206ULL,
0x000000ffff157224ULL, 0x000fc400030e0605ULL, 0x00005e0004047625ULL, 0x000fe200078e0027ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a1b7faeULL, 0x0005e2000e901c46ULL,
0x000000191600720cULL, 0x0c0fe40003fa6070ULL, 0x00000010171d7824ULL, 0x100fe400078e021aULL,
0x000000101f1f7824ULL, 0x100fe400078e021aULL, 0x00000001161c7824ULL, 0x140fe200078e022fULL,
0x000000000c1d7faeULL, 0x0007e2000e101c46ULL, 0x0000000816337824ULL, 0x000fe200078e00ffULL,
0x0000000431167210ULL, 0x000fe20007fde0ffULL, 0x0000001021217824ULL, 0x000fe200078e021aULL,
0x00000024220a7810ULL, 0x004fe20007ffe0ffULL, 0x0000000118067824ULL, 0x000fe200078e0220ULL,
0x000000000e1f7faeULL, 0x0005e2000d101c46ULL, 0x000000011e047824ULL, 0x040fe200078e022fULL,
0x000000191e00720cULL, 0x040fe20003f86070ULL, 0x000000081e1b7824ULL, 0x000fe200078e00ffULL,
0x0000000010217faeULL, 0x0003e2000d901c46ULL, 0x00005e0006067625ULL, 0x000fe200078e0027ULL,
0x000000192000720cULL, 0x000fc40003f66070ULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee204ULL,
0x00000001200b7824ULL, 0x040fe200078e022fULL, 0xfffffff8330d7812ULL, 0x008fe200078ee21cULL,
0x0000000820207824ULL, 0x000fe200078e00ffULL, 0x000000190a00720cULL, 0x000fe20003f46070ULL,
0x0000000118047824ULL, 0x000fe200078e020aULL, 0x00000030220e7810ULL, 0x004fe20007ffe0ffULL,
0x000000ffff177224ULL, 0x000fe200030e0605ULL, 0x0000000631067210ULL, 0x000fe20007fde0ffULL,
0x00005e0004047625ULL, 0x000fe200078e0027ULL, 0xfffffff8200f7812ULL, 0x000fc400078ee20bULL,
0x0000003422107810ULL, 0x042fe20007ffe0ffULL, 0x0000001023237824ULL, 0x100fe200078e021aULL,
0x0000003c221c7810ULL, 0x000fe20007ffe0ffULL, 0x0000001025257824ULL, 0x100fe400078e021aULL,
0x000000100d0d7824ULL, 0x100fe200078e021aULL, 0x0000000012237faeULL, 0x0003e2000c101c46ULL,
0x000000ffff077224ULL, 0x000fe200030e0607ULL, 0x000000191c00720cULL, 0x080fe20003f06070ULL,
0x000000010a0c7824ULL, 0x040fe200078e022fULL, 0x0000000008257faeULL, 0x0005e2000c901c46ULL,
0x000000080a1d7824ULL, 0x000fe200078e00ffULL, 0x00000004310a7210ULL, 0x000fe20007fde0ffULL,
0x000000101b1b7824ULL, 0x100fe200078e021aULL, 0x0000002822047810ULL, 0x000fe20007ffe0ffULL,
0x000000100f0f7824ULL, 0x000fe200078e021aULL, 0x00000000140d7faeULL, 0x0007e2000e901c46ULL,
0x000000ffff0b7224ULL, 0x000fe200030e0605ULL, 0xfffffff81d117812ULL, 0x000fe200078ee20cULL,
0x0000000104057824ULL, 0x040fe200078e022fULL, 0x00000000161b7faeULL, 0x0003e2000e101c46ULL,
0x000000190400720cULL, 0x000fc40003fc6070ULL, 0x0000002c220c7810ULL, 0x000fe20007ffe0ffULL,
0x00000000060f7faeULL, 0x0003e2000d901c46ULL, 0x0000001011117824ULL, 0x000fe200078e021aULL,
0x000000190e00720cULL, 0x080fe40003f86070ULL, 0x000000010c097824ULL, 0x144fe200078e022fULL,
0x000000190c00720cULL, 0x0c0fe20003fa6070ULL, 0x000000000a117faeULL, 0x0005e2000d101c46ULL,
0x000000080c147824ULL, 0x008fe200078e00ffULL, 0x0000003822127810ULL, 0x002fe20007ffe0ffULL,
0x000000010e0d7824ULL, 0x000fe200078e022fULL, 0x000000191000720cULL, 0x080fe20003f66070ULL,
0x0000000804067824ULL, 0x000fe200078e00ffULL, 0xfffffff814157812ULL, 0x000fe200078ee209ULL,
0x0000000118047824ULL, 0x000fe200078e0204ULL, 0x000000191200720cULL, 0x040fe20003f26070ULL,
0x0000000812197824ULL, 0x000fe200078e00ffULL, 0xfffffff806137812ULL, 0x000fe200078ee205ULL,
0x00005e0004047625ULL, 0x000fc800078e0027ULL, 0x0000000118067824ULL, 0x040fe200078e020cULL,
0x0000000431087210ULL, 0x000fe20007f5e0ffULL, 0x00000001180c7824ULL, 0x000fe400078e020eULL,
0x00005e0006067625ULL, 0x000fc800078e0027ULL, 0x000000080e0e7824ULL, 0x000fe400078e00ffULL,
0x000000ffff097224ULL, 0x000fe200010e0605ULL, 0x00000006310a7210ULL, 0x004fe20007f5e0ffULL,
0x00005e000c047625ULL, 0x000fe200078e0027ULL, 0xfffffff80e117812ULL, 0x000fc600078ee20dULL,
0x0000000118067824ULL, 0x000fe400078e0210ULL, 0x00000001100d7824ULL, 0x040fe400078e022fULL,
0x00000008100e7824ULL, 0x000fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x000fe200010e0607ULL,
0x00000004310c7210ULL, 0x000fe20007f5e0ffULL, 0x00005e0006067625ULL, 0x000fe200078e0027ULL,
0xfffffff80e177812ULL, 0x000fc600078ee20dULL, 0x0000000118047824ULL, 0x000fe400078e0212ULL,
0x000000ffff0d7224ULL, 0x000fe200010e0605ULL, 0x00000006310e7210ULL, 0x000fe20007f5e0ffULL,
0x00005e0004047625ULL, 0x000fc800078e0027ULL, 0x0000000118187824ULL, 0x000fe400078e021cULL,
0x0000000112107824ULL, 0x000fe400078e022fULL, 0x000000ffff0f7224ULL, 0x000fe200010e0607ULL,
0x0000000431047210ULL, 0x000fe20007f5e0ffULL, 0x000000011c2f7824ULL, 0x040fe200078e022fULL,
0xfffffff819197812ULL, 0x000fe200078ee210ULL, 0x000000081c1c7824ULL, 0x000fe400078e00ffULL,
0x00005e0018067625ULL, 0x000fc600078e0027ULL, 0xfffffff81c2f7812ULL, 0x000fe200078ee22fULL,
0x000000ffff057224ULL, 0x000fe200010e0605ULL, 0x0000000631067210ULL, 0x000fe20007f5e0ffULL,
0x0000001013137824ULL, 0x100fe400078e021aULL, 0x0000001015157824ULL, 0x100fe400078e021aULL,
0x0000001011117824ULL, 0x100fe200078e021aULL, 0x0000000008137faeULL, 0x0003e2000f101c46ULL,
0x0000001017177824ULL, 0x100fe400078e021aULL, 0x0000001019197824ULL, 0x100fe200078e021aULL,
0x000000000a157faeULL, 0x0003e2000e901c46ULL, 0x000000102f2f7824ULL, 0x000fc400078e021aULL,
0x000000ffff077224ULL, 0x000fe200010e0607ULL, 0x000000000c117faeULL, 0x0003e8000e101c46ULL,
0x000000000e177faeULL, 0x0003e8000d901c46ULL, 0x0000000004197faeULL, 0x0003e8000c901c46ULL,
0x00000000062f7faeULL, 0x0003e2000c101c46ULL, 0x00000a5000007947ULL, 0x000fea0003800000ULL,
0x000000082f087811ULL, 0x040fe200078fe8ffULL, 0x00000100ff347424ULL, 0x000fe200078e00ffULL,
0x0000000c2f097811ULL, 0x000fc400078fe8ffULL, 0x000000102f0a7811ULL, 0x040fe200078fe8ffULL,
0x0000000108057824ULL, 0x140fe200078e022fULL, 0x000000042f077811ULL, 0x040fe200078fe8ffULL,
0x0000000808107824ULL, 0x000fe200078e00ffULL, 0x000000202f1a7811ULL, 0x000fe200078fe8ffULL,
0x0000000109067824ULL, 0x000fe200078e022fULL, 0x0000001c2f157811ULL, 0x000fe200078fe8ffULL,
0x00000008090f7824ULL, 0x000fe200078e00ffULL, 0xfffffff8100d7812ULL, 0x000fe200078ee205ULL,
0x000000010a0e7824ULL, 0x140fe200078e022fULL, 0x000000282f1f7811ULL, 0x000fe200078fe8ffULL,
0x000000080a117824ULL, 0x000fe200078e00ffULL, 0xfffffff80f107812ULL, 0x000fe200078ee206ULL,
0x0000000107047824ULL, 0x100fe200078e022fULL, 0x000000182f0f7811ULL, 0x000fe200078fe8ffULL,
0x00000008070b7824ULL, 0x000fe200078e00ffULL, 0xfffffff811117812ULL, 0x000fe200078ee20eULL,
0x000000011a137824ULL, 0x140fe200078e022fULL, 0x000000142f0e7811ULL, 0x000fe200078fe8ffULL,
0x000000081a1c7824ULL, 0x000fe200078e00ffULL, 0xfffffff80b0b7812ULL, 0x000fe200078ee204ULL,
0x000000010f057824ULL, 0x100fe200078e022fULL, 0x0000002c2f217811ULL, 0x040fe200078fe8ffULL,
0x000000010e047824ULL, 0x000fe200078e022fULL, 0xfffffff81c1b7812ULL, 0x000fe200078ee213ULL,
0x000000080e177824ULL, 0x000fe200078e00ffULL, 0x000000242f1c7811ULL, 0x000fe200078fe8ffULL,
0x000000080f147824ULL, 0x000fe200078e00ffULL, 0x000000302f237811ULL, 0x000fe200078fe8ffULL,
0x0000000115067824ULL, 0x000fe200078e022fULL, 0xfffffff817127812ULL, 0x000fe200078ee204ULL,
0x0000000815197824ULL, 0x000fe200078e00ffULL, 0xfffffff814147812ULL, 0x000fe200078ee205ULL,
0x000000011c047824ULL, 0x140fe200078e022fULL, 0x000000342f257811ULL, 0x000fe200078fe8ffULL,
0x000000081c177824ULL, 0x000fe200078e00ffULL, 0xfffffff819167812ULL, 0x000fe200078ee206ULL,
0x000000011f057824ULL, 0x140fe200078e022fULL, 0x000000700c4b7812ULL, 0x000fe200078ec0ffULL,
0x000000081f207824ULL, 0x000fe200078e00ffULL, 0xfffffff8171e7812ULL, 0x000fe200078ee204ULL,
0x0000000121067824ULL, 0x000fe200078e022fULL, 0x000000182f047211ULL, 0x000fe200078fe8ffULL,
0x0000000821197824ULL, 0x000fe200078e00ffULL, 0xfffffff820207812ULL, 0x000fe200078ee205ULL,
0x0000000123137824ULL, 0x000fe200078e022fULL, 0x0000002f2f057211ULL, 0x000fe200078fe8ffULL,
0x0000000823267824ULL, 0x000fe200078e00ffULL, 0xfffffff819227812ULL, 0x000fe200078ee206ULL,
0x0000000118177824ULL, 0x000fe200078e020fULL, 0x0000000705067812ULL, 0x000fe200078ec0ffULL,
0x00005e0004047625ULL, 0x000fe200078e0034ULL, 0xfffffff826267812ULL, 0x000fc400078ee213ULL,
0x000000382f277811ULL, 0x000fe200078fe8ffULL, 0x0000000118137824ULL, 0x000fe200078e020eULL,
0x0000004b040e7210ULL, 0x000fe20007f1e0ffULL, 0x00000001250f7824ULL, 0x000fe200078e022fULL,
0x0000003c2f307811ULL, 0x000fe200078fe8ffULL, 0x0000000825367824ULL, 0x000fe200078e00ffULL,
0x000020002e497811ULL, 0x000fe200078e70ffULL, 0x0000000118077824ULL, 0x040fe400078e0207ULL,
0x0000000118197824ULL, 0x000fe200078e0215ULL, 0xfffffff836157812ULL, 0x000fe200078ee20fULL,
0x00000001181d7824ULL, 0x000fc400078e021cULL, 0x00000001182c7824ULL, 0x040fe400078e0227ULL,
0x00000001271c7824ULL, 0x140fe400078e022fULL, 0x0000000118087824ULL, 0x040fe400078e0208ULL,
0x00000001180c7824ULL, 0x000fe200078e020aULL, 0x0ffffff8060a7812ULL, 0x000fe200078ef82fULL,
0x0000000827277824ULL, 0x000fe400078e00ffULL, 0x000000ffff0f7224ULL, 0x000fc400000e0605ULL,
0x00005e0007047625ULL, 0x000fe200078e0034ULL, 0xfffffff8271c7812ULL, 0x000fc600078ee21cULL,
0x0000000118097824ULL, 0x040fe400078e0209ULL, 0x00000001181a7824ULL, 0x040fe400078e021aULL,
0x00000001181f7824ULL, 0x040fe400078e021fULL, 0x0000000118217824ULL, 0x040fe400078e0221ULL,
0x0000000118247824ULL, 0x040fe400078e0223ULL, 0x0000000118287824ULL, 0x000fc400078e0225ULL,
0x0000000118327824ULL, 0x000fe400078e0230ULL, 0x00000001302f7824ULL, 0x040fe400078e022fULL,
0x0000000830187824ULL, 0x000fe400078e00ffULL, 0x00005e0008067625ULL, 0x000fc600078e0034ULL,
0xfffffff818187812ULL, 0x000fe200078ee22fULL, 0x0000001010317824ULL, 0x000fe200078e0249ULL,
0x0000004b04107210ULL, 0x000fe20007f1e0ffULL, 0x00005e0009087625ULL, 0x000fc800078e0034ULL,
0x000000100a257824ULL, 0x100fe400078e0249ULL, 0x000000100b277824ULL, 0x100fe400078e0249ULL,
0x00005e000c0a7625ULL, 0x000fe200078e0034ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e257faeULL, 0x0005e6000b901c46ULL, 0x0000001012357824ULL, 0x100fe200078e0249ULL,
0x0000004b06127210ULL, 0x000fe20007f3e0ffULL, 0x000000100d2f7824ULL, 0x000fc400078e0249ULL,
0x0000001011337824ULL, 0x100fe400078e0249ULL, 0x0000001014377824ULL, 0x000fe200078e0249ULL,
0x0000004b08147210ULL, 0x000fe20007f5e0ffULL, 0x00005e00130c7625ULL, 0x000fc800078e0034ULL,
0x0000001016397824ULL, 0x000fe400078e0249ULL, 0x000000ffff117224ULL, 0x000fe200000e0605ULL,
0x0000004b0a167210ULL, 0x000fe20007f1e0ffULL, 0x000000101b3b7824ULL, 0x100fe400078e0249ULL,
0x000000101e3d7824ULL, 0x100fe200078e0249ULL, 0x0000000010277faeULL, 0x0005e2000b901c46ULL,
0x00000010203f7824ULL, 0x100fe400078e0249ULL, 0x0000001022417824ULL, 0x000fc400078e0249ULL,
0x0000001026437824ULL, 0x100fe400078e0249ULL, 0x0000001015457824ULL, 0x100fe400078e0249ULL,
0x000000101c477824ULL, 0x000fe400078e0249ULL, 0x00005e0017047625ULL, 0x000fc800078e0034ULL,
0x0000001018497824ULL, 0x000fe400078e0249ULL, 0x000000ffff137224ULL, 0x000fe200008e0607ULL,
0x0000004b0c187210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff157224ULL, 0x000fe400010e0609ULL,
0x00005e0019067625ULL, 0x080fe200078e0034ULL, 0x00000000122f7faeULL, 0x0005e6000b901c46ULL,
0x000000ffff177224ULL, 0x000fe200000e060bULL, 0x0000000014317faeULL, 0x0005e2000b901c46ULL,
0x00005e001a087625ULL, 0x000fe200078e0034ULL, 0x0000004b041a7210ULL, 0x000fc40007f1e0ffULL,
0x0000000016337faeULL, 0x0005e2000b901c46ULL, 0x000000ffff197224ULL, 0x000fe200008e060dULL,
0x0000004b061c7210ULL, 0x000fe20007f3e0ffULL, 0x00005e001d0a7625ULL, 0x000fc600078e0034ULL,
0x0000000018357faeULL, 0x0005e2000b901c46ULL, 0x00005e001f0c7625ULL, 0x000fc800078e0034ULL,
0x000000ffff1b7224ULL, 0x000fe200000e0605ULL, 0x0000004b081e7210ULL, 0x080fe20007f1e0ffULL,
0x00005e0021047625ULL, 0x080fe200078e0034ULL, 0x0000004b0c227210ULL, 0x080fe40007f5e0ffULL,
0x000000001a377faeULL, 0x0005e2000b901c46ULL, 0x000000ffff1d7224ULL, 0x000fe200008e0607ULL,
0x0000004b0a207210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff1f7224ULL, 0x000fe200000e0609ULL,
0x0000004b04047210ULL, 0x000fe20007f1e0ffULL, 0x00005e0024067625ULL, 0x080fe200078e0034ULL,
0x000000001c397faeULL, 0x0005e6000b901c46ULL, 0x000000ffff217224ULL, 0x000fe200008e060bULL,
0x000000001e3b7faeULL, 0x0005e2000b901c46ULL, 0x00005e0028087625ULL, 0x000fc600078e0034ULL,
0x00000000203d7faeULL, 0x0005e2000b901c46ULL, 0x000000ffff237224ULL, 0x000fe200010e060dULL,
0x0000004b08087210ULL, 0x000fe20007f3e0ffULL, 0x00005e002c0a7625ULL, 0x000fc600078e0034ULL,
0x00000000223f7faeULL, 0x0005e2000b901c46ULL, 0x00005e00320c7625ULL, 0x000fe200078e0034ULL,
0x0000004b0a0a7210ULL, 0x000fc60007f5e0ffULL, 0x000000ffff057224ULL, 0x000fe200000e0605ULL,
0x0000004b06067210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff097224ULL, 0x000fe200008e0609ULL,
0x0000004b0c0c7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200010e060bULL,
0x0000000004417faeULL, 0x0005e2000b901c46ULL, 0x000000ffff077224ULL, 0x000fe400000e0607ULL,
0x000000ffff0d7224ULL, 0x000fc600018e060dULL, 0x0000000006437faeULL, 0x0005e8000b901c46ULL,
0x0000000008457faeULL, 0x0005e8000b901c46ULL, 0x000000000a477faeULL, 0x0005e8000b901c46ULL,
0x000000000c497faeULL, 0x0005e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000047805ULL, 0x006fc40000015200ULL, 0x01860400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fc40007804803ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff087224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x0000000604097210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09000900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011407ULL, 0x0000000906067211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000206067819ULL, 0x000fc80000001207ULL,
0x000000060000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000108087810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01860400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804803ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e640000000000ULL,
0x000000202e027824ULL, 0x002fca00078e0203ULL, 0x00000003ff037819ULL, 0x000fe40000011602ULL,
0x0000000f02027812ULL, 0x000fe400078ec0ffULL, 0x1ffffffe03037812ULL, 0x000fe400078ec0ffULL,
0x0000000102047810ULL, 0x040fe20007ffe0ffULL, 0x0000002002077824ULL, 0x040fe400078e00ffULL,
0x0000000102057824ULL, 0x040fe400078e0203ULL, 0x0000000103067824ULL, 0x040fe200078e0204ULL,
0x0000001003037810ULL, 0x000fe20007ffe0ffULL, 0x0000002002087824ULL, 0x000fe200078e00ffULL,
0x0000001f05057812ULL, 0x000fc400078ec0ffULL, 0x0000001f06067812ULL, 0x000fe400078ec0ffULL,
0x000001e008057812ULL, 0x000fe400078ee205ULL, 0x000001e007067812ULL, 0x000fe200078ee206ULL,
0x0000000102077824ULL, 0x100fe400078e0203ULL, 0x00000000050c7984ULL, 0x000e62000000cc00ULL,
0x0000000104037824ULL, 0x000fe400078e0203ULL, 0x0000002002047824ULL, 0x040fe200078e00ffULL,
0x0000000006087984ULL, 0x000ea2000000cc00ULL, 0x0000002002027824ULL, 0x000fe200078e00ffULL,
0x0000001f03037812ULL, 0x000fc400078ec0ffULL, 0x0000001f07077812ULL, 0x000fe400078ec0ffULL,
0x000001e002037812ULL, 0x000fe400078ee203ULL, 0x000001e004077812ULL, 0x000fe200078ee207ULL,
0x000000ffff107224ULL, 0x002fe400078e000cULL, 0x000000ffff117224ULL, 0x000fe400078e000eULL,
0x000000ffff127224ULL, 0x004fe400078e0008ULL, 0x000000ffff137224ULL, 0x000fc400078e000aULL,
0x000000ffff167224ULL, 0x000fe400078e0009ULL, 0x000000ffff177224ULL, 0x000fe200078e000bULL,
0x0000001005007388ULL, 0x000fe2000000cc00ULL, 0x000000ffff147224ULL, 0x000fe400078e000dULL,
0x000000ffff157224ULL, 0x000fca00078e000fULL, 0x0000001406007388ULL, 0x000fe8000000cc00ULL,
0x0000000003087984ULL, 0x000e68000000cc00ULL, 0x00000000070c7984ULL, 0x000ea2000000cc00ULL,
0x000000ffff1b7224ULL, 0x002fe400078e000aULL, 0x000000ffff1a7224ULL, 0x000fc400078e0008ULL,
0x000000ffff0a7224ULL, 0x000fe400078e0009ULL, 0x000000ffff187224ULL, 0x004fe400078e000cULL,
0x000000ffff197224ULL, 0x000fe400078e000eULL, 0x000000ffff087224ULL, 0x000fe400078e000dULL,
0x000000ffff097224ULL, 0x000fe200078e000fULL, 0x0000001807007388ULL, 0x0003e8000000cc00ULL,
0x0000000803007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01860000ff067f8cULL, 0x002e62000c80043fULL, 0x000000ffff087224ULL, 0x000fc600078e00ffULL,
0x0000000000027805ULL, 0x000fc80000015200ULL, 0x01860400ff057984ULL, 0x000ea40000000800ULL,
0x8000000005ff7812ULL, 0x006fc40007804807ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000047805ULL, 0x000fcc0000015200ULL, 0x0000000402097210ULL, 0x000fca0007f1e1ffULL,
0x0000000105057824ULL, 0x000fe200000e0e03ULL, 0x003d09000900780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400900780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc80000011405ULL,
0x0000000904047211ULL, 0x000fca00078110ffULL, 0x000000ffff057224ULL, 0x000fca00000e0605ULL,
0x0000000204047819ULL, 0x000fc80000001205ULL, 0x000000040000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000108087810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01860400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff2b00720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000287919ULL, 0x000e620000000000ULL, 0x3d8000002a2a7820ULL, 0x010fe20000410000ULL,
0x000186882e2c7811ULL, 0x040fe200078e18ffULL, 0x000000ffff3e7224ULL, 0x000fe200078e00ffULL,
0xffffffff2b2f7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff3d7224ULL, 0x000fe200078e00ffULL,
0x000186082e3c7811ULL, 0x000fc400078e28ffULL, 0x000001003e407824ULL, 0x000fe200078e0200ULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x000000402d00720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x00cfea0003800000ULL, 0x000000ffff3f7224ULL, 0x000fe200078e003dULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff417224ULL, 0x000fe200078e00ffULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x0000000000047805ULL, 0x000fc4000001ff00ULL, 0x0000000141037810ULL, 0x000fe20007ffe0ffULL,
0x000014e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff427224ULL, 0x000fe200078e0041ULL,
0x000000013f3d7812ULL, 0x000fc400078e0cffULL, 0x0000003e03257211ULL, 0x040fe200078ff8ffULL,
0x000000ffff417224ULL, 0x000fe200078e0003ULL, 0x000000020300780cULL, 0x000fe40003f06070ULL,
0x0000000125027810ULL, 0x040fe20007ffe0ffULL, 0x0000010025267824ULL, 0x000fe200078e0200ULL,
0x0000000103247812ULL, 0x000fe400078ec0ffULL, 0x0000002b0200720cULL, 0x000fe20003f26070ULL,
0x0000620029037a24ULL, 0x000fd800078e0226ULL, 0x00000ab000009947ULL, 0x020fea0003800000ULL,
0x00000003ff497819ULL, 0x002fe20000011628ULL, 0x0000000824377824ULL, 0x000fe200078e00ffULL,
0x000000262d027217ULL, 0x000fe20007800000ULL, 0x000000022e367824ULL, 0x000fe200078e023dULL,
0x0000000449317810ULL, 0x040fe20007ffe0ffULL, 0x00000100ff4b7424ULL, 0x000fe200078e00ffULL,
0x0000000849337810ULL, 0x040fe20007ffe0ffULL, 0x0000000102027824ULL, 0x000fe200078e0a26ULL,
0x0000001049477810ULL, 0x000fe20007ffe0ffULL, 0x0000000131257824ULL, 0x100fe200078e0228ULL,
0x0000001849537810ULL, 0x000fe20007ffe0ffULL, 0x0000000831307824ULL, 0x000fe200078e00ffULL,
0x0000000c49357810ULL, 0x000fe20007ffe0ffULL, 0x0000000833327824ULL, 0x000fe200078e00ffULL,
0x00000014494f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000147277824ULL, 0x100fe200078e0228ULL,
0xfffffff8303b7812ULL, 0x000fe200078ee225ULL, 0x0000000133257824ULL, 0x100fe200078e0228ULL,
0x00000020495b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000847347824ULL, 0x000fe200078e00ffULL,
0x0000001c49577810ULL, 0x000fe20007ffe0ffULL, 0x0000000135267824ULL, 0x100fe200078e0228ULL,
0xfffffff832437812ULL, 0x000fe200078ee225ULL, 0x0000000153257824ULL, 0x100fe200078e0228ULL,
0x00000024495f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000853327824ULL, 0x000fe200078e00ffULL,
0xfffffff8344d7812ULL, 0x000fe200078ee227ULL, 0x0000000835457824ULL, 0x000fe200078e00ffULL,
0x000000024900720cULL, 0x080fe20003f26070ULL, 0x000000014f307824ULL, 0x040fe200078e0228ULL,
0xfffffff832557812ULL, 0x000fe200078ee225ULL, 0x000000084f517824ULL, 0x000fe200078e00ffULL,
0xfffffff845457812ULL, 0x000fe200078ee226ULL, 0x000000015b277824ULL, 0x100fe200078e0228ULL,
0xfffffff837377812ULL, 0x000fe200078ee228ULL, 0x000000085b347824ULL, 0x000fe200078e00ffULL,
0xfffffff851517812ULL, 0x000fe200078ee230ULL, 0x0000000149257824ULL, 0x100fe200078e0228ULL,
0x0000200036367811ULL, 0x000fe200078e68ffULL, 0x0000000157267824ULL, 0x140fe200078e0228ULL,
0xfffffff8345d7812ULL, 0x000fe200078ee227ULL, 0x0000000857597824ULL, 0x000fe200078e00ffULL,
0x0000000725277812ULL, 0x000fe200078ec0ffULL, 0x000000015f307824ULL, 0x000fe200078e0228ULL,
0x000000023100720cULL, 0x080fe20003f46070ULL, 0x000000085f617824ULL, 0x000fe200078e00ffULL,
0xfffffff859597812ULL, 0x000fe200078ee226ULL, 0x0000000149247824ULL, 0x100fe200078e0203ULL,
0x0ffffff827397812ULL, 0x000fe200078ef828ULL, 0x0000000131267824ULL, 0x100fe200078e0203ULL,
0xfffffff861617812ULL, 0x000fe200078ee230ULL, 0x0000000133307824ULL, 0x040fe200078e0203ULL,
0x000000023300720cULL, 0x080fe20003f66070ULL, 0x00005e0024247625ULL, 0x000fe200078e004bULL,
0x000000023500720cULL, 0x000fc40003f86070ULL, 0x000000024700720cULL, 0x000fe20003fa6070ULL,
0x0000000135327824ULL, 0x100fe400078e0203ULL, 0x0000000147347824ULL, 0x000fe400078e0203ULL,
0x00005e0026267625ULL, 0x000fc800078e004bULL, 0x00005e0030307625ULL, 0x000fc800078e004bULL,
0x00005e0032327625ULL, 0x000fc800078e004bULL, 0x0000001037247825ULL, 0x000fc800078e0024ULL,
0x0000001039397824ULL, 0x000fe400078e0236ULL, 0x00005e0034347625ULL, 0x000fc600078e004bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024397faeULL, 0x0003e2000c901c46ULL,
0x000000103b3b7824ULL, 0x000fe200078e0236ULL, 0x000000024f00720cULL, 0x000fe20003f26070ULL,
0x0000001037267825ULL, 0x000fc800078e0026ULL, 0x0000001043437824ULL, 0x000fe200078e0236ULL,
0x00000000263b7faeULL, 0x0005e2000d101c46ULL, 0x0000001037307825ULL, 0x000fe200078e0030ULL,
0x000000025300720cULL, 0x000fc60003f46070ULL, 0x0000001045457824ULL, 0x000fe200078e0236ULL,
0x0000000030437faeULL, 0x0007e2000d901c46ULL, 0x0000001037327825ULL, 0x000fe200078e0032ULL,
0x000000025700720cULL, 0x000fc60003f66070ULL, 0x000000104d477824ULL, 0x000fe200078e0236ULL,
0x0000000032457faeULL, 0x0009e2000e101c46ULL, 0x0000001037347825ULL, 0x000fe200078e0034ULL,
0x000000025b00720cULL, 0x080fe40003f86070ULL, 0x00000030494d7810ULL, 0x000fe20007ffe0ffULL,
0x000000014f247824ULL, 0x102fe200078e0203ULL, 0x0000000034477faeULL, 0x0003e2000e901c46ULL,
0x0000000153267824ULL, 0x004fe200078e0203ULL, 0x000000025f00720cULL, 0x000fe20003fa6070ULL,
0x00005e0024247625ULL, 0x000fe200078e004bULL, 0x00000034494f7810ULL, 0x000fc60007ffe0ffULL,
0x0000000157387824ULL, 0x100fe400078e0203ULL, 0x000000015b3a7824ULL, 0x000fe400078e0203ULL,
0x00005e0026267625ULL, 0x000fe200078e004bULL, 0x0000002c49477810ULL, 0x002fc60007ffe0ffULL,
0x000000015f347824ULL, 0x000fe400078e0203ULL, 0x00005e0038307625ULL, 0x008fc800078e004bULL,
0x00005e003a327625ULL, 0x010fc800078e004bULL, 0x0000001051397824ULL, 0x000fe200078e0236ULL,
0x0000003849517810ULL, 0x000fe20007ffe0ffULL, 0x0000001037247825ULL, 0x000fc800078e0024ULL,
0x00005e0034347625ULL, 0x000fe200078e004bULL, 0x0000000024397faeULL, 0x0003e6000c901c46ULL,
0x00000010553b7824ULL, 0x000fe400078e0236ULL, 0x0000001037267825ULL, 0x000fc800078e0026ULL,
0x0000001059437824ULL, 0x000fe200078e0236ULL, 0x00000000263b7faeULL, 0x0005e2000d101c46ULL,
0x0000001037307825ULL, 0x000fe200078e0030ULL, 0x0000002849397810ULL, 0x042fe40007ffe0ffULL,
0x0000003c49497810ULL, 0x000fe20007ffe0ffULL, 0x000000105d457824ULL, 0x000fe200078e0236ULL,
0x0000000030437faeULL, 0x0003e2000d901c46ULL, 0x0000001037327825ULL, 0x000fe200078e0032ULL,
0x000000023900720cULL, 0x080fe40003f26070ULL, 0x000000024700720cULL, 0x080fe20003f46070ULL,
0x0000001061257824ULL, 0x000fe200078e0236ULL, 0x0000000032457faeULL, 0x0007e2000e101c46ULL,
0x0000001037347825ULL, 0x000fe200078e0034ULL, 0x000000024d00720cULL, 0x000fc40003f66070ULL,
0x000000024f00720cULL, 0x080fe20003f86070ULL, 0x0000000139247824ULL, 0x040fe200078e0228ULL,
0x0000000034257faeULL, 0x0009e2000e901c46ULL, 0x00000008393b7824ULL, 0x004fe200078e00ffULL,
0x000000025100720cULL, 0x080fe20003fa6070ULL, 0x0000000847267824ULL, 0x000fe200078e00ffULL,
0x000000024900720cULL, 0x000fe20003fc6070ULL, 0x0000000139027824ULL, 0x100fe200078e0203ULL,
0xfffffff83b3b7812ULL, 0x000fe200078ee224ULL, 0x0000000147247824ULL, 0x100fe400078e0203ULL,
0x000000014f307824ULL, 0x002fc400078e0203ULL, 0x0000000151327824ULL, 0x108fe400078e0203ULL,
0x0000000147257824ULL, 0x110fe400078e0228ULL, 0x0000000149347824ULL, 0x000fe400078e0203ULL,
0x000000084d387824ULL, 0x040fe200078e00ffULL, 0xfffffff826437812ULL, 0x000fe200078ee225ULL,
0x000000014d267824ULL, 0x040fe400078e0203ULL, 0x000000014d257824ULL, 0x000fc400078e0228ULL,
0x000000014f277824ULL, 0x140fe400078e0228ULL, 0x000000084f3a7824ULL, 0x000fe200078e00ffULL,
0xfffffff838457812ULL, 0x000fe200078ee225ULL, 0x0000000151037824ULL, 0x140fe400078e0228ULL,
0x0000000851447824ULL, 0x000fe200078e00ffULL, 0xfffffff83a477812ULL, 0x000fe200078ee227ULL,
0x0000000149317824ULL, 0x040fe400078e0228ULL, 0x0000000849467824ULL, 0x000fe200078e00ffULL,
0xfffffff844497812ULL, 0x000fe200078ee203ULL, 0x00005e0002027625ULL, 0x000fc600078e004bULL,
0xfffffff8464d7812ULL, 0x000fe200078ee231ULL, 0x00005e0024247625ULL, 0x000fc800078e004bULL,
0x00005e0026267625ULL, 0x000fc800078e004bULL, 0x00005e0030307625ULL, 0x000fc800078e004bULL,
0x00005e0032327625ULL, 0x000fc800078e004bULL, 0x00005e0034347625ULL, 0x000fc800078e004bULL,
0x0000001037027825ULL, 0x000fc800078e0002ULL, 0x0000001037247825ULL, 0x000fc800078e0024ULL,
0x0000001037267825ULL, 0x000fc800078e0026ULL, 0x0000001037307825ULL, 0x000fc800078e0030ULL,
0x0000001037327825ULL, 0x000fc800078e0032ULL, 0x0000001037347825ULL, 0x000fc800078e0034ULL,
0x000000103b377824ULL, 0x100fe400078e0236ULL, 0x0000001043397824ULL, 0x100fe400078e0236ULL,
0x00000010453b7824ULL, 0x100fe200078e0236ULL, 0x0000000002377faeULL, 0x0003e2000c901c46ULL,
0x0000001047437824ULL, 0x100fe400078e0236ULL, 0x0000001049457824ULL, 0x100fe200078e0236ULL,
0x0000000024397faeULL, 0x0003e2000d101c46ULL, 0x000000104d477824ULL, 0x000fc600078e0236ULL,
0x00000000263b7faeULL, 0x0003e8000d901c46ULL, 0x0000000030437faeULL, 0x0003e8000e101c46ULL,
0x0000000032457faeULL, 0x0003e8000e901c46ULL, 0x0000000034477faeULL, 0x0003e2000f101c46ULL,
0x0000097000007947ULL, 0x000fea0003800000ULL, 0x0000000428267811ULL, 0x002fe200078fe8ffULL,
0x0000000824437824ULL, 0x000fe200078e00ffULL, 0x0000001428347811ULL, 0x040fe200078fe8ffULL,
0x00000100ff517424ULL, 0x000fe200078e00ffULL, 0x0000000828307811ULL, 0x000fe200078fe8ffULL,
0x0000000126027824ULL, 0x100fe200078e0228ULL, 0x0000000c28317811ULL, 0x000fe200078fe8ffULL,
0x0000000826257824ULL, 0x000fe200078e00ffULL, 0x0000001028327811ULL, 0x000fe200078fe8ffULL,
0x0000000134337824ULL, 0x000fe200078e0228ULL, 0x0000002428447811ULL, 0x000fe200078fe8ffULL,
0x00000008345c7824ULL, 0x000fe200078e00ffULL, 0xfffffff825547812ULL, 0x000fe200078ee202ULL,
0x0000000130027824ULL, 0x100fe200078e0228ULL, 0x0000001828367811ULL, 0x000fe200078fe8ffULL,
0x0000000830357824ULL, 0x000fe200078e00ffULL, 0x0000001c28387811ULL, 0x000fe200078fe8ffULL,
0x0000000131257824ULL, 0x040fe200078e0228ULL, 0xfffffff85c5c7812ULL, 0x000fe200078ee233ULL,
0x0000000831587824ULL, 0x000fe200078e00ffULL, 0xfffffff835567812ULL, 0x000fe200078ee202ULL,
0x0000000132277824ULL, 0x100fe200078e0228ULL, 0x00000020283a7811ULL, 0x000fe200078fe8ffULL,
0x00000008325a7824ULL, 0x000fe200078e00ffULL, 0x00000034284c7811ULL, 0x000fe200078fe8ffULL,
0x0000000144337824ULL, 0x100fe200078e0228ULL, 0xfffffff858587812ULL, 0x000fe200078ee225ULL,
0x0000000844647824ULL, 0x000fe200078e00ffULL, 0x0000002828467811ULL, 0x000fe200078fe8ffULL,
0x0000000136027824ULL, 0x100fe200078e0228ULL, 0x0000002c28487811ULL, 0x000fe200078fe8ffULL,
0x0000000836357824ULL, 0x000fe200078e00ffULL, 0xfffffff85a5a7812ULL, 0x000fe200078ee227ULL,
0x0000000138257824ULL, 0x000fe200078e0228ULL, 0xfffffff864647812ULL, 0x000fe200078ee233ULL,
0x0000000838607824ULL, 0x000fe200078e00ffULL, 0xfffffff8355e7812ULL, 0x000fe200078ee202ULL,
0x000000013a277824ULL, 0x100fe200078e0228ULL, 0x00000030284a7811ULL, 0x000fe200078fe8ffULL,
0x000000083a627824ULL, 0x000fe200078e00ffULL, 0xfffffff860607812ULL, 0x000fe200078ee225ULL,
0x000000014c337824ULL, 0x140fe200078e0228ULL, 0xfffffff843437812ULL, 0x100fe200078ee228ULL,
0x000000084c6c7824ULL, 0x000fe200078e00ffULL, 0xfffffff862627812ULL, 0x000fe200078ee227ULL,
0x0000000146027824ULL, 0x000fc400078e0228ULL, 0x0000000846357824ULL, 0x000fe200078e00ffULL,
0xfffffff86c6c7812ULL, 0x000fe200078ee233ULL, 0x0000000148257824ULL, 0x000fe200078e0228ULL,
0x0000003828337811ULL, 0x000fe200078fe8ffULL, 0x0000000848687824ULL, 0x000fe200078e00ffULL,
0xfffffff835667812ULL, 0x000fe200078ee202ULL, 0x000000014a277824ULL, 0x100fe200078e0228ULL,
0x0000003c28357811ULL, 0x000fe200078fe8ffULL, 0x000000084a6a7824ULL, 0x000fe200078e00ffULL,
0xfffffff868687812ULL, 0x000fe200078ee225ULL, 0x0000000126247824ULL, 0x100fe200078e0203ULL,
0x0000002828257211ULL, 0x000fe200078fe8ffULL, 0x0000000130267824ULL, 0x000fe200078e0203ULL,
0xfffffff86a6a7812ULL, 0x000fe200078ee227ULL, 0x0000000131307824ULL, 0x100fe200078e0203ULL,
0x0000000328027211ULL, 0x000fe200078fe8ffULL, 0x00000001334e7824ULL, 0x000fe200078e0203ULL,
0x0000000725257812ULL, 0x000fe200078ec0ffULL, 0x0000000133317824ULL, 0x000fc400078e0228ULL,
0x00000008336e7824ULL, 0x000fe200078e00ffULL, 0x0ffffff825527812ULL, 0x100fe200078ef828ULL,
0x000000022e277824ULL, 0x000fe400078e023dULL, 0x0000000135337824ULL, 0x040fe200078e0228ULL,
0xfffffff86e6e7812ULL, 0x000fe200078ee231ULL, 0x0000000835707824ULL, 0x000fe200078e00ffULL,
0x00002000276f7811ULL, 0x000fe200078e68ffULL, 0x0000000132327824ULL, 0x100fe400078e0203ULL,
0x0000000134347824ULL, 0x000fe200078e0203ULL, 0xfffffff870707812ULL, 0x000fe200078ee233ULL,
0x0000000136367824ULL, 0x000fc400078e0203ULL, 0x0000000138387824ULL, 0x100fe400078e0203ULL,
0x000000013a3a7824ULL, 0x100fe400078e0203ULL, 0x0000000144447824ULL, 0x100fe400078e0203ULL,
0x0000000146467824ULL, 0x100fe400078e0203ULL, 0x0000000148487824ULL, 0x100fe400078e0203ULL,
0x000000014a4a7824ULL, 0x000fc400078e0203ULL, 0x000000014c4c7824ULL, 0x100fe400078e0203ULL,
0x0000000135507824ULL, 0x000fe400078e0203ULL, 0x00005e0002027625ULL, 0x000fc800078e0051ULL,
0x00005e0024247625ULL, 0x000fc800078e0051ULL, 0x00005e0026267625ULL, 0x000fc800078e0051ULL,
0x00005e0030307625ULL, 0x000fc800078e0051ULL, 0x00005e0032327625ULL, 0x000fc800078e0051ULL,
0x00005e0034347625ULL, 0x000fc800078e0051ULL, 0x00005e0036367625ULL, 0x000fc800078e0051ULL,
0x00005e0038387625ULL, 0x000fc800078e0051ULL, 0x00005e003a3a7625ULL, 0x000fc800078e0051ULL,
0x00005e0044447625ULL, 0x000fc800078e0051ULL, 0x00005e0046467625ULL, 0x000fc800078e0051ULL,
0x00005e0048487625ULL, 0x000fc800078e0051ULL, 0x00005e004a4a7625ULL, 0x000fc800078e0051ULL,
0x00005e004c4c7625ULL, 0x000fc800078e0051ULL, 0x00005e004e4e7625ULL, 0x000fc800078e0051ULL,
0x00005e0050507625ULL, 0x000fc800078e0051ULL, 0x0000001043027825ULL, 0x000fc800078e0002ULL,
0x0000001043247825ULL, 0x000fc800078e0024ULL, 0x0000001043267825ULL, 0x000fc800078e0026ULL,
0x0000001043307825ULL, 0x000fc800078e0030ULL, 0x0000001043327825ULL, 0x000fc800078e0032ULL,
0x0000001043347825ULL, 0x000fc800078e0034ULL, 0x0000001043367825ULL, 0x000fc800078e0036ULL,
0x0000001043387825ULL, 0x000fc800078e0038ULL, 0x00000010433a7825ULL, 0x000fc800078e003aULL,
0x0000001043447825ULL, 0x000fc800078e0044ULL, 0x0000001043467825ULL, 0x000fc800078e0046ULL,
0x0000001043487825ULL, 0x000fc800078e0048ULL, 0x00000010434a7825ULL, 0x000fc800078e004aULL,
0x00000010434c7825ULL, 0x000fc800078e004cULL, 0x00000010434e7825ULL, 0x000fc800078e004eULL,
0x0000001043507825ULL, 0x000fc800078e0050ULL, 0x0000001052437824ULL, 0x100fe400078e026fULL,
0x0000001054537824ULL, 0x100fe400078e026fULL, 0x0000001056557824ULL, 0x100fe200078e026fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002437faeULL, 0x0003e2000b901c46ULL,
0x0000001058577824ULL, 0x100fe400078e026fULL, 0x000000105a597824ULL, 0x100fe200078e026fULL,
0x0000000024537faeULL, 0x0003e2000b901c46ULL, 0x000000105c5b7824ULL, 0x000fc400078e026fULL,
0x000000105e5d7824ULL, 0x100fe200078e026fULL, 0x0000000026557faeULL, 0x0003e2000b901c46ULL,
0x00000010605f7824ULL, 0x100fe400078e026fULL, 0x0000001062617824ULL, 0x100fe200078e026fULL,
0x0000000030577faeULL, 0x0003e2000b901c46ULL, 0x0000001064637824ULL, 0x100fe400078e026fULL,
0x0000001066657824ULL, 0x100fe200078e026fULL, 0x0000000032597faeULL, 0x0003e2000b901c46ULL,
0x0000001068677824ULL, 0x000fc400078e026fULL, 0x000000106a697824ULL, 0x100fe200078e026fULL,
0x00000000345b7faeULL, 0x0003e2000b901c46ULL, 0x000000106c6b7824ULL, 0x100fe400078e026fULL,
0x000000106e6d7824ULL, 0x100fe200078e026fULL, 0x00000000365d7faeULL, 0x0003e2000b901c46ULL,
0x00000010706f7824ULL, 0x000fc600078e026fULL, 0x00000000385f7faeULL, 0x0003e8000b901c46ULL,
0x000000003a617faeULL, 0x0003e8000b901c46ULL, 0x0000000044637faeULL, 0x0003e8000b901c46ULL,
0x0000000046657faeULL, 0x0003e8000b901c46ULL, 0x0000000048677faeULL, 0x0003e8000b901c46ULL,
0x000000004a697faeULL, 0x0003e8000b901c46ULL, 0x000000004c6b7faeULL, 0x0003e8000b901c46ULL,
0x000000004e6d7faeULL, 0x0003e8000b901c46ULL, 0x00000000506f7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000ffff437224ULL, 0x002fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xfffffff828037812ULL, 0x000fe200078ec0ffULL, 0x000000022e307824ULL, 0x020fe200078e023fULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000143317810ULL, 0x000fc40007ffe0ffULL,
0x0000000703027812ULL, 0x000fe400078ef828ULL, 0x0000200030307811ULL, 0x000fc600078e68ffULL,
0x0000000102037824ULL, 0x040fe400078e0243ULL, 0x0000000802247824ULL, 0x040fe400078e00ffULL,
0x0000000802257824ULL, 0x040fe400078e00ffULL, 0x0000000102027824ULL, 0x000fe200078e0231ULL,
0xfffffff824037812ULL, 0x000fc800078ee203ULL, 0xfffffff825257812ULL, 0x000fe200078ee202ULL,
0x0000001003037824ULL, 0x000fc800078e0230ULL, 0x0000001025257824ULL, 0x000fe200078e0230ULL,
0x000000000338783bULL, 0x000e680000000200ULL, 0x000000002534783bULL, 0x0004e40000000200ULL,
0x0000002028257810ULL, 0x004fc80007ffe0ffULL, 0xfffffff825257812ULL, 0x000fe400078ec0ffULL,
0x00000018ff247819ULL, 0x002fe20000011438ULL, 0x0000003800777306ULL, 0x000fe20000009400ULL,
0x00000018ff267819ULL, 0x000fe20000011439ULL, 0x0001000038547824ULL, 0x000fe200078e00ffULL,
0x00000018ff277819ULL, 0x000fe2000001143aULL, 0x0001000039557824ULL, 0x000fe200078e00ffULL,
0x00000018ff447819ULL, 0x000fe2000001143bULL, 0x0001000037607824ULL, 0x008fe200078e00ffULL,
0x00000018ff547819ULL, 0x000fe20000011454ULL, 0x00000024009b7306ULL, 0x000fe20000209400ULL,
0x00000018ff557819ULL, 0x000fc40000011455ULL, 0x00000018ff457819ULL, 0x000fe40000011434ULL,
0x00000018ff707819ULL, 0x000fe40000011460ULL, 0x00000018ff4b7819ULL, 0x000fe20000011436ULL,
0x00000024009e7306ULL, 0x000e620000205400ULL, 0x00000018ff4c7819ULL, 0x000fe40000011437ULL,
0x00000018ff467819ULL, 0x000fca0000011435ULL, 0x0000002400837306ULL, 0x0004f0000020d400ULL,
0x0000002600a47306ULL, 0x000fe20000209400ULL, 0x0000000725247812ULL, 0x004fe400078ef828ULL,
0x0000009e9b00720bULL, 0x002fc60003fbd000ULL, 0x0000000124257824ULL, 0x040fe400078e0243ULL,
0x0000002600a77306ULL, 0x000fe20000205400ULL, 0x0000000124317824ULL, 0x040fe400078e0231ULL,
0x0000000824327824ULL, 0x000fca00078e00ffULL, 0x00000026007d7306ULL, 0x0003e2000020d400ULL,
0xfffffff832317812ULL, 0x000fe400078ee231ULL, 0x0000000183835812ULL, 0x008fc600078efcffULL,
0x0000001031317824ULL, 0x000fe400078e0230ULL, 0x0000002700987306ULL, 0x000fe20000209400ULL,
0x0000000824267824ULL, 0x002fca00078e00ffULL, 0xfffffff826257812ULL, 0x000fe400078ee225ULL,
0x0000002700977306ULL, 0x000fe60000205400ULL, 0x0000001025257824ULL, 0x000fe400078e0230ULL,
0x000000003130783bULL, 0x000e660000000200ULL, 0x00000027007a7306ULL, 0x0005f0000020d400ULL,
0x0000003800a87306ULL, 0x000ee20000005400ULL, 0x000000002524783bULL, 0x004eae0000000200ULL,
0x0000003900a07306ULL, 0x000ff00000009400ULL, 0x00000039009d7306ULL, 0x000f220000005400ULL,
0x000000a87700720bULL, 0x008fce0003f3d000ULL, 0x0000003800807306ULL, 0x0006a2000000d400ULL,
0x00000018ff5a7819ULL, 0x002fe40000011430ULL, 0x00000018ff8c7819ULL, 0x000fca0000011433ULL,
0x00000039007c7306ULL, 0x0002a2000000d400ULL, 0x0000010038387824ULL, 0x008fe200078e00ffULL,
0x0000009da000720bULL, 0x010fe40003f9d000ULL, 0x00000018ff617819ULL, 0x000fe40000011431ULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000005400b17306ULL, 0x000fe20000209400ULL,
0x0000010039397824ULL, 0x002fe200078e00ffULL, 0x0000000180801812ULL, 0x004fe200078efcffULL,
0x00010000246c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff627819ULL, 0x000fc40000011432ULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000005400b47306ULL, 0x000e620000205400ULL,
0x00000018ff6c7819ULL, 0x000fe4000001146cULL, 0x000000017c7c4812ULL, 0x000fe400078efcffULL,
0x000000979800720bULL, 0x000fe40003f9d000ULL, 0x00000007289d7812ULL, 0x000fe200078ec0ffULL,
0x0000003800b37306ULL, 0x000ff00000209400ULL, 0x0000003800b67306ULL, 0x000ea20000205400ULL,
0x000000b4b100720bULL, 0x002fc40003f5d000ULL, 0x000000017a7a4812ULL, 0x000fca00078efcffULL,
0x0000005500b77306ULL, 0x000ff00000209400ULL, 0x0000005500ba7306ULL, 0x000e620000205400ULL,
0x000000b6b300720bULL, 0x004fce0003fdd000ULL, 0x0000003800967306ULL, 0x0004f0000020d400ULL,
0x0000005400937306ULL, 0x0008e2000020d400ULL, 0x000100003b387824ULL, 0x004fe200078e00ffULL,
0x000000bab700720bULL, 0x002fc80003f3d000ULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x0000003a00a27306ULL, 0x000fe20000009400ULL, 0x000100003a547824ULL, 0x010fe200078e00ffULL,
0x0000000196966812ULL, 0x008fc800078efcffULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x0000003a009f7306ULL, 0x000e620000005400ULL, 0x0000000193932812ULL, 0x000fe400078efcffULL,
0x000000a7a400720bULL, 0x000fca0003f5d000ULL, 0x0000003a007b7306ULL, 0x0004f0000000d400ULL,
0x0000003900c47306ULL, 0x000fe20000209400ULL, 0x000001003a3a7824ULL, 0x004fe200078e00ffULL,
0x0000009fa200720bULL, 0x002fc40003f7d000ULL, 0x000000017d7d2812ULL, 0x000fe400078efcffULL,
0x00000018ff3a7819ULL, 0x000fe4000001143aULL, 0x0000003900c17306ULL, 0x000e620000205400ULL,
0x000000089da27812ULL, 0x000fca00078ef828ULL, 0x00000020a29d7824ULL, 0x000fe200078e00ffULL,
0x000000017b7b3812ULL, 0x008fe200078efcffULL, 0x0000003900a67306ULL, 0x0004f0000020d400ULL,
0x0000003b008a7306ULL, 0x000fe20000009400ULL, 0x00000018ff397819ULL, 0x004fc40000011424ULL,
0x000000c1c400720bULL, 0x002fca0003fdd000ULL, 0x0000003b008b7306ULL, 0x000e700000005400ULL,
0x0000003b00787306ULL, 0x000522000000d400ULL, 0x00000001a6a66812ULL, 0x008fce00078efcffULL,
0x0000003900ce7306ULL, 0x000fe20000209400ULL, 0x000001003b3b7824ULL, 0x004fe200078e00ffULL,
0x0000008b8a00720bULL, 0x002fc80003f5d000ULL, 0x00000018ff3b7819ULL, 0x000fe4000001143bULL,
0x0000003900c97306ULL, 0x000e6e0000205400ULL, 0x0000000178782812ULL, 0x010fe200078efcffULL,
0x0000003900727306ULL, 0x0004f0000020d400ULL, 0x0000003400857306ULL, 0x000fe20000009400ULL,
0x0001000034397824ULL, 0x004fe200078e00ffULL, 0x000000c9ce00720bULL, 0x002fcc0003f5d000ULL,
0x0000003400847306ULL, 0x000fee0000005400ULL, 0x0000000172722812ULL, 0x008fe200078efcffULL,
0x0000003400537306ULL, 0x0003f0000000d400ULL, 0x0000003800c87306ULL, 0x000fe20000209400ULL,
0x0000010034347824ULL, 0x002fce00078e00ffULL, 0x0000003800c57306ULL, 0x000e700000205400ULL,
0x0000003800957306ULL, 0x0005f0000020d400ULL, 0x0000005500a37306ULL, 0x000ee2000020d400ULL,
0x00000018ff387819ULL, 0x004fc40000011426ULL, 0x000000c5c800720bULL, 0x002fca0003fdd000ULL,
0x0000003a00ca7306ULL, 0x000ff00000209400ULL, 0x0000003a00c77306ULL, 0x000e620000205400ULL,
0x00000001a3a31812ULL, 0x008fe400078efcffULL, 0x0000000195956812ULL, 0x000fc800078efcffULL,
0x000000789578723eULL, 0x000fe200000010ffULL, 0x0000003800bc7306ULL, 0x000ff00000209400ULL,
0x0000003800b97306ULL, 0x000fe20000205400ULL, 0x000000c7ca00720bULL, 0x002fce0003f3d000ULL,
0x0000003800657306ULL, 0x0003f0000020d400ULL, 0x0000006c00d17306ULL, 0x000fe20000209400ULL,
0x00000018ff387819ULL, 0x002fe20000011434ULL, 0x0001000035347824ULL, 0x000fcc00078e00ffULL,
0x0000006c00d47306ULL, 0x000e700000205400ULL, 0x0000003a00a17306ULL, 0x0004f0000020d400ULL,
0x0000003b00cd7306ULL, 0x000fe20000209400ULL, 0x00000018ff3a7819ULL, 0x004fc40000011425ULL,
0x000000d4d100720bULL, 0x002fca0003f9d000ULL, 0x0000003b00d07306ULL, 0x000fe20000205400ULL,
0x00000001a1a11812ULL, 0x008fce00078efcffULL, 0x0000003b009c7306ULL, 0x0003f0000020d400ULL,
0x0000007000667306ULL, 0x000fe20000209400ULL, 0x00000018ff3b7819ULL, 0x002fce0000011427ULL,
0x0000007000637306ULL, 0x000ff00000205400ULL, 0x0000007000607306ULL, 0x0003f0000020d400ULL,
0x0000003a00cb7306ULL, 0x000fe20000209400ULL, 0x0001000025707824ULL, 0x002fca00078e00ffULL,
0x00000018ffcf7819ULL, 0x000fe40000011470ULL, 0x0000003a00cc7306ULL, 0x000ff00000205400ULL,
0x0000003a006a7306ULL, 0x0003f0000020d400ULL, 0x0000003b00bf7306ULL, 0x000fe20000209400ULL,
0x00000018ff3a7819ULL, 0x002fe20000011434ULL, 0x0000010035347824ULL, 0x000fcc00078e00ffULL,
0x0000003b00c27306ULL, 0x000ff00000205400ULL, 0x0000003b005f7306ULL, 0x0003f0000020d400ULL,
0x00000036007f7306ULL, 0x000fe20000009400ULL, 0x00010000363b7824ULL, 0x002fca00078e00ffULL,
0x00000018ff557819ULL, 0x000fe4000001143bULL, 0x0000003600027306ULL, 0x000ff00000005400ULL,
0x00000036004e7306ULL, 0x0003f0000000d400ULL, 0x0000005400c37306ULL, 0x000fe20000209400ULL,
0x0000010036367824ULL, 0x002fca00078e00ffULL, 0x00000018ff577819ULL, 0x000fe40000011436ULL,
0x0000005400c67306ULL, 0x000e700000205400ULL, 0x00000054009a7306ULL, 0x0004f0000020d400ULL,
0x0000003700817306ULL, 0x000fe20000009400ULL, 0x00000018ff547819ULL, 0x004fc40000011439ULL,
0x000000c6c300720bULL, 0x002fca0003fbd000ULL, 0x00000037007e7306ULL, 0x000ff00000005400ULL,
0x00000037004d7306ULL, 0x0003e2000000d400ULL, 0x000000019a9a5812ULL, 0x008fe400078efcffULL,
0x000000d0cd00720bULL, 0x000fc40003fbd000ULL, 0x0000007b9a9a723eULL, 0x000fe200000010ffULL,
0x00000100327b7824ULL, 0x000fe400078e00ffULL, 0x0000002500a97306ULL, 0x000fe20000009400ULL,
0x0000010037377824ULL, 0x002fe400078e00ffULL, 0x00000018ff7b7819ULL, 0x000fc6000001147bULL,
0x00000018ff717819ULL, 0x000fe40000011437ULL, 0x0000002500ac7306ULL, 0x000e620000005400ULL,
0x000000019c9c5812ULL, 0x000fce00078efcffULL, 0x0000002500697306ULL, 0x0004f0000000d400ULL,
0x0000002400ad7306ULL, 0x000fe20000009400ULL, 0x0000010025257824ULL, 0x004fe200078e00ffULL,
0x000000aca900720bULL, 0x002fc80003fbd000ULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x0000002400b07306ULL, 0x000e6e0000005400ULL, 0x0000000169695812ULL, 0x008fe200078efcffULL,
0x0000005400bd7306ULL, 0x000fe20000209400ULL, 0x000000b9bc00720bULL, 0x000fce0003fbd000ULL,
0x0000005400c07306ULL, 0x000ea20000205400ULL, 0x000000b0ad00720bULL, 0x002fca0003f3d000ULL,
0x0000000165655812ULL, 0x000fe400078efcffULL, 0x0000005400647306ULL, 0x0002f0000020d400ULL,
0x0000003800be7306ULL, 0x000fe20000209400ULL, 0x00000018ff547819ULL, 0x002fc40000011434ULL,
0x000000c0bd00720bULL, 0x004fca0003fbd000ULL, 0x0000003800bb7306ULL, 0x000ff00000205400ULL,
0x0000003800397306ULL, 0x000fe2000020d400ULL, 0x0000000164645812ULL, 0x008fe400078efcffULL,
0x0000007e8100720bULL, 0x000fca0003fbd000ULL, 0x0000006c00907306ULL, 0x0002b0000020d400ULL,
0x0000004400947306ULL, 0x000fe20000209400ULL, 0x00010000266c7824ULL, 0x002fe200078e00ffULL,
0x000000014d4d5812ULL, 0x000fcc00078efcffULL, 0x00000044008f7306ULL, 0x000e620000205400ULL,
0x0000000190904812ULL, 0x004fce00078efcffULL, 0x0000005a006d7306ULL, 0x000ff00000209400ULL,
0x0000005a006e7306ULL, 0x000fe20000205400ULL, 0x0000008f9400720bULL, 0x002fce0003f7d000ULL,
0x0000005a00387306ULL, 0x000ff0000020d400ULL, 0x000000cf00d57306ULL, 0x000ff00000209400ULL,
0x000000cf00d87306ULL, 0x000e700000205400ULL, 0x00000024006f7306ULL, 0x0004f0000000d400ULL,
0x0000008c00597306ULL, 0x000fe20000209400ULL, 0x0000010024247824ULL, 0x004fe200078e00ffULL,
0x000000d8d500720bULL, 0x002fc80003f9d000ULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x0000008c005a7306ULL, 0x000fe20000205400ULL, 0x000000016f6f1812ULL, 0x008fe400078efcffULL,
0x000000cccb00720bULL, 0x000fe40003f3d000ULL, 0x0000006f9090723eULL, 0x000fc600000010ffULL,
0x0000008c005b7306ULL, 0x000ff0000020d400ULL, 0x000000cf008c7306ULL, 0x0002a2000020d400ULL,
0x000000016a6a1812ULL, 0x000fce00078efcffULL, 0x0000003500827306ULL, 0x000fe20000009400ULL,
0x0001000027cf7824ULL, 0x002fce00078e00ffULL, 0x0000003500037306ULL, 0x000fe20000005400ULL,
0x000000018c8c4812ULL, 0x004fc800078efcffULL, 0x000000698c8c723eULL, 0x000fc600000010ffULL,
0x0000003500507306ULL, 0x000ff0000000d400ULL, 0x0000002600aa7306ULL, 0x000ff00000009400ULL,
0x0000002600a57306ULL, 0x000ff00000005400ULL, 0x0000002600677306ULL, 0x0003f0000000d400ULL,
0x0000003a00b87306ULL, 0x000fe20000209400ULL, 0x0000010026267824ULL, 0x002fca00078e00ffULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x0000003a00b57306ULL, 0x000ff00000205400ULL,
0x0000003a00357306ULL, 0x000ff0000020d400ULL, 0x0000005400b27306ULL, 0x000ff00000209400ULL,
0x0000005400af7306ULL, 0x000ff00000205400ULL, 0x0000005400347306ULL, 0x000ff0000020d400ULL,
0x0000005500ae7306ULL, 0x000ff00000209400ULL, 0x0000005500ab7306ULL, 0x000ff00000205400ULL,
0x00000055003b7306ULL, 0x000ff0000020d400ULL, 0x0000005700927306ULL, 0x000ff00000209400ULL,
0x0000005700917306ULL, 0x000ff00000205400ULL, 0x0000005700367306ULL, 0x000ff0000020d400ULL,
0x00000061003a7306ULL, 0x000ff00000209400ULL, 0x0000006100557306ULL, 0x000e700000205400ULL,
0x0000006100547306ULL, 0x000eb0000020d400ULL, 0x0000006200567306ULL, 0x000fe20000209400ULL,
0x000000553a00720bULL, 0x002fce0003fbd000ULL, 0x0000006200577306ULL, 0x000fec0000205400ULL,
0x0000000154545812ULL, 0x004fe400078efcffULL, 0x0000006200587306ULL, 0x000ff0000020d400ULL,
0x0000007100377306ULL, 0x000ff00000209400ULL, 0x0000007100627306ULL, 0x000ff00000205400ULL,
0x0000007100617306ULL, 0x000ff0000020d400ULL, 0x0000002500d77306ULL, 0x000ff00000209400ULL,
0x0000002500da7306ULL, 0x000ff00000205400ULL, 0x0000002500717306ULL, 0x0003f0000020d400ULL,
0x0000002400d37306ULL, 0x000fe20000209400ULL, 0x00000018ff257819ULL, 0x002fce00000114cfULL,
0x0000002400d67306ULL, 0x000e700000205400ULL, 0x0000002500cf7306ULL, 0x000ff00000209400ULL,
0x0000002500d27306ULL, 0x000fe20000205400ULL, 0x000000d6d300720bULL, 0x002fce0003fdd000ULL,
0x0000002500777306ULL, 0x0003f0000020d400ULL, 0x0000004400797306ULL, 0x000ea2000020d400ULL,
0x0000000842257824ULL, 0x002fe200078e0243ULL, 0x0000000243437810ULL, 0x000fc60007ffe0ffULL,
0x0000000225257824ULL, 0x000fc600078e00ffULL, 0x0000002600db7306ULL, 0x000ff00000209400ULL,
0x0000002600de7306ULL, 0x000e620000205400ULL, 0x0000000179793812ULL, 0x004fe400078efcffULL,
0x000000a5aa00720bULL, 0x000fe20003f7d000ULL, 0x00000020a2a57824ULL, 0x000fe200078e00ffULL,
0x0000009c7979723eULL, 0x000fc600000010ffULL, 0x0000002400997306ULL, 0x0004f0000020d400ULL,
0x00000027008d7306ULL, 0x000fe20000009400ULL, 0x00000018ff247819ULL, 0x004fe4000001146cULL,
0x000000dedb00720bULL, 0x002fc40003f9d000ULL, 0x0000000167673812ULL, 0x000fe400078efcffULL,
0x000000848500720bULL, 0x000fe20003f7d000ULL, 0x0000002400d97306ULL, 0x000fe20000209400ULL,
0x0000000199996812ULL, 0x008fe400078efcffULL, 0x000000dad700720bULL, 0x000fca0003fdd000ULL,
0x0000002400dc7306ULL, 0x000e680000205400ULL, 0x0000000153533812ULL, 0x000fc800078efcffULL,
0x0000002400707306ULL, 0x0005e2000020d400ULL, 0x0000000171716812ULL, 0x000fe400078efcffULL,
0x000000d2cf00720bULL, 0x000fe40003fdd000ULL, 0x000000536464723eULL, 0x000fc600000010ffULL,
0x00000027008e7306ULL, 0x000ee20000005400ULL, 0x0000002528247211ULL, 0x004fe400078fe0ffULL,
0x0000000225257810ULL, 0x000fe40007ffe0ffULL, 0x000000dcd900720bULL, 0x002fe20003f5d000ULL,
0x00000001a2247824ULL, 0x000fe200078e0224ULL, 0x0000002528257211ULL, 0x000fe200078fe0ffULL,
0x00000026006c7306ULL, 0x0002a2000020d400ULL, 0x0000000177776812ULL, 0x000fe400078efcffULL,
0xffffffe09d247812ULL, 0x000fc400078ee224ULL, 0x000000038200720bULL, 0x000fe40003fdd000ULL,
0x000000968303723eULL, 0x000fe200000010ffULL, 0x00000027005e7306ULL, 0x0008a2000000d400ULL,
0x0001000030267824ULL, 0x002fe200078e00ffULL, 0x0000008e8d00720bULL, 0x008fe20003f3d000ULL,
0x0000001024247824ULL, 0x000fe200078e00ffULL, 0x0000000170702812ULL, 0x000fe400078efcffULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x0000004c00447306ULL, 0x000fe20000209400ULL,
0x0000010027277824ULL, 0x010fe200078e00ffULL, 0x000000016c6c4812ULL, 0x004fc400078efcffULL,
0x000000c2bf00720bULL, 0x000fe40003f9d000ULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x0000004c004f7306ULL, 0x000fe20000205400ULL, 0x000000015e5e1812ULL, 0x000fe400078efcffULL,
0x000000bbbe00720bULL, 0x000fe40003f3d000ULL, 0x0000000150506812ULL, 0x000fe400078efcffULL,
0x000000716a8d723eULL, 0x000fe200000010ffULL, 0x0000004c00487306ULL, 0x000fe2000020d400ULL,
0x000000015f5f4812ULL, 0x000fc400078efcffULL, 0x000000677070723eULL, 0x000fe400000010ffULL,
0x0000006c6571723eULL, 0x000fe400000010ffULL, 0x0000005e775e723eULL, 0x000fe200000010ffULL,
0x0000003000767306ULL, 0x000fe20000009400ULL, 0x0000000139391812ULL, 0x000fe400078efcffULL,
0x000000b5b800720bULL, 0x000fca0003f3d000ULL, 0x0000003000757306ULL, 0x000ff00000005400ULL,
0x00000030004c7306ULL, 0x0003e2000000d400ULL, 0x0000000135351812ULL, 0x000fe400078efcffULL,
0x000000abae00720bULL, 0x000fc40003f3d000ULL, 0x000000503550723eULL, 0x000fc600000010ffULL,
0x0000002600977306ULL, 0x000fe20000209400ULL, 0x0000010030307824ULL, 0x002fca00078e00ffULL,
0x00000018ff9d7819ULL, 0x000fe20000011430ULL, 0x00000001a2307824ULL, 0x000fe200078e0225ULL,
0x00000026008a7306ULL, 0x000e620000205400ULL, 0x000000013b3b1812ULL, 0x000fc600078efcffULL,
0xffffffe0a5987812ULL, 0x000fe400078ee230ULL, 0x0000007ca330723eULL, 0x000fe200000010ffULL,
0x00010000337c7824ULL, 0x000fe200078e00ffULL, 0x00000026008b7306ULL, 0x0004e8000020d400ULL,
0x00000018ff7c7819ULL, 0x000fc8000001147cULL, 0x00000027009b7306ULL, 0x000fe20000209400ULL,
0x0001000031267824ULL, 0x004fe200078e00ffULL, 0x0000008a9700720bULL, 0x002fc80003f3d000ULL,
0x00000018ffa27819ULL, 0x000fe40000011426ULL, 0x0000002700a07306ULL, 0x000e6e0000205400ULL,
0x000000018b8b1812ULL, 0x008fe200078efcffULL, 0x0000004500887306ULL, 0x000ff00000209400ULL,
0x0000004500897306ULL, 0x000ea20000205400ULL, 0x000000a09b00720bULL, 0x002fc40003f5d000ULL,
0x000000a17a9b723eULL, 0x000fca00000010ffULL, 0x0000004600877306ULL, 0x000ff00000209400ULL,
0x0000004600867306ULL, 0x000e620000205400ULL, 0x000000898800720bULL, 0x004fce0003f9d000ULL,
0x00000027009e7306ULL, 0x0004f0000020d400ULL, 0x00000045004a7306ULL, 0x000f22000020d400ULL,
0x000000002424783bULL, 0x004ea20000000200ULL, 0x000000868700720bULL, 0x002fcc0003f7d000ULL,
0x0000004600477306ULL, 0x000e62000020d400ULL, 0x000000019e9e2812ULL, 0x008fe400078efcffULL,
0x000000027f00720bULL, 0x000fe40003f5d000ULL, 0x000000809302723eULL, 0x000fe400000010ffULL,
0x0000009e5f5f723eULL, 0x000fe200000010ffULL, 0x0000003100687306ULL, 0x000fe20000009400ULL,
0x000000014a4a4812ULL, 0x010fe400078efcffULL, 0x000000afb200720bULL, 0x000fc40003f9d000ULL,
0x000000394a65723eULL, 0x000fc600000010ffULL, 0x00000031006b7306ULL, 0x000ee20000005400ULL,
0x0000000147473812ULL, 0x002fe400078efcffULL, 0x000000919200720bULL, 0x000fe40003f7d000ULL,
0x000000014e4e2812ULL, 0x000fe400078efcffULL, 0x000000997291723eULL, 0x000fe200000010ffULL,
0x0000004b00747306ULL, 0x000fe20000209400ULL, 0x0000000134344812ULL, 0x000fe400078efcffULL,
0x000000757600720bULL, 0x000fc40003f9d000ULL, 0x0000004e3b4e723eULL, 0x000fc600000010ffULL,
0x0000004b00737306ULL, 0x000e620000205400ULL, 0x0000006b6800720bULL, 0x008fe20003f5d000ULL,
0x000000022404723cULL, 0x004b620000041804ULL, 0x0000000136363812ULL, 0x000fe400078efcffULL,
0x0000006e6d00720bULL, 0x000fc60003f7d000ULL, 0x0000004b00497306ULL, 0x000fe2000020d400ULL,
0x0001000032027824ULL, 0x020fe200078e00ffULL, 0x000000014c4c4812ULL, 0x000fe200078efcffULL,
0x0000009a241c723cULL, 0x040fe6000004181cULL, 0x00000018ff027819ULL, 0x000fe40000011402ULL,
0x00000031004b7306ULL, 0x0004e2000000d400ULL, 0x000000737400720bULL, 0x002fe40003fdd000ULL,
0x0000000138383812ULL, 0x000fe200078efcffULL, 0x000000782418723cULL, 0x000fe20000041818ULL,
0x000000636600720bULL, 0x000fc40003f7d000ULL, 0x0000004c8b4c723eULL, 0x000fe200000010ffULL,
0x0000009d00947306ULL, 0x000fe20000209400ULL, 0x0000010031317824ULL, 0x004fc600078e00ffULL,
0x000000902414723cULL, 0x040fe40000041814ULL, 0x00000018ff827819ULL, 0x000fe40000011431ULL,
0x0000009d009f7306ULL, 0x000e620000205400ULL, 0x000000014b4b2812ULL, 0x008fe400078efcffULL,
0x000000623700720bULL, 0x000fe20003f5d000ULL, 0x0000008c2410723cULL, 0x000fe20000041810ULL,
0x0000000149496812ULL, 0x000fe400078efcffULL, 0x000000a67d31723eULL, 0x000fe200000010ffULL,
0x0000009d008f7306ULL, 0x000ea2000020d400ULL, 0x00000100337d7824ULL, 0x000fe200078e00ffULL,
0x0000000160603812ULL, 0x000fc400078efcffULL, 0x00000070240c723cULL, 0x040fe4000004180cULL,
0x00000018ff7d7819ULL, 0x000fe4000001147dULL, 0x000000a200a47306ULL, 0x000fe20000209400ULL,
0x0000009f9400720bULL, 0x002fe40003fdd000ULL, 0x0000000161612812ULL, 0x000fe200078efcffULL,
0x000000302420723cULL, 0x000b620000041820ULL, 0x0000004d6060723eULL, 0x000fc600000010ffULL,
0x000000a2009d7306ULL, 0x000e660000205400ULL, 0x0000001098307824ULL, 0x020fe200078e00ffULL,
0x0000005e2408723cULL, 0x000b640000041808ULL, 0x000000018f8f6812ULL, 0x004fe400078efcffULL,
0x0000000200037306ULL, 0x000fe40000209400ULL, 0x0000008f384d723eULL, 0x000fcc00000010ffULL,
0x00000002007a7306ULL, 0x000ea20000205400ULL, 0x0000009da400720bULL, 0x002fce0003f9d000ULL,
0x0000003300517306ULL, 0x000ff00000009400ULL, 0x0000003300527306ULL, 0x000e620000005400ULL,
0x0000007a0300720bULL, 0x004fce0003f5d000ULL, 0x00000032005c7306ULL, 0x000ff00000009400ULL,
0x00000032005d7306ULL, 0x000ea20000005400ULL, 0x000000525100720bULL, 0x002fe40003fdd000ULL,
0x000000344751723eULL, 0x000fca00000010ffULL, 0x000000a200847306ULL, 0x000e70000020d400ULL,
0x00000082007f7306ULL, 0x000fe20000209400ULL, 0x0000005d5c00720bULL, 0x004fce0003f3d000ULL,
0x00000082007e7306ULL, 0x000ea20000205400ULL, 0x0000000184844812ULL, 0x002fe400078efcffULL,
0x0000004f4400720bULL, 0x000fe40003f9d000ULL, 0x00000036494f723eULL, 0x000fe400000010ffULL,
0x0000004b8484723eULL, 0x000fe200000010ffULL, 0x0000000200737306ULL, 0x000e70000020d400ULL,
0x0000007b006f7306ULL, 0x000fe20000209400ULL, 0x0000007e7f00720bULL, 0x004fc40003f7d000ULL,
0x0000000148484812ULL, 0x000fe400078efcffULL, 0x000000575600720bULL, 0x000fe40003f9d000ULL,
0x000000614861723eULL, 0x000fe200000010ffULL, 0x0000007b00027306ULL, 0x000ea20000205400ULL,
0x0000000173732812ULL, 0x002fce00078efcffULL, 0x0000003200467306ULL, 0x000e64000000d400ULL,
0x0000000158584812ULL, 0x000fcc00078efcffULL, 0x0000007d00247306ULL, 0x020fe20000209400ULL,
0x000000026f00720bULL, 0x004fce0003fbd000ULL, 0x0000007d00037306ULL, 0x000ea20000205400ULL,
0x0000000146461812ULL, 0x002fc800078efcffULL, 0x000000467346723eULL, 0x000fc600000010ffULL,
0x0000003300457306ULL, 0x0002f0000000d400ULL, 0x0000008200857306ULL, 0x000f22000020d400ULL,
0x000000003030783bULL, 0x002e620000000200ULL, 0x000000032400720bULL, 0x004fcc0003f3d000ULL,
0x0000007c00527306ULL, 0x000fe20000209400ULL, 0x0000000145456812ULL, 0x008fce00078efcffULL,
0x0000007c00257306ULL, 0x000ea20000205400ULL, 0x0000000185853812ULL, 0x010fe400078efcffULL,
0x0000005a5900720bULL, 0x000fe40003f7d000ULL, 0x000000855485723eULL, 0x000fc600000010ffULL,
0x0000007d00027306ULL, 0x000ef0000020d400ULL, 0x0000007b005d7306ULL, 0x000f22000020d400ULL,
0x000000255200720bULL, 0x004fe40003f5d000ULL, 0x000000015b5b3812ULL, 0x000fca00078efcffULL,
0x0000007c007c7306ULL, 0x000ea2000020d400ULL, 0x0000000102021812ULL, 0x008fe200078efcffULL,
0x000000643004723cULL, 0x002b620000041804ULL, 0x000000084300780cULL, 0x000fe40003f25270ULL,
0x000000025b5b723eULL, 0x000fe400000010ffULL, 0x000000015d5d5812ULL, 0x010fc600078efcffULL,
0x000000503020723cULL, 0x000b620000041820ULL, 0x0000005d5847723eULL, 0x000fe400000010ffULL,
0x000000017c7c2812ULL, 0x004fca00078efcffULL, 0x0000004e301c723cULL, 0x000b62000004181cULL,
0x000000457c5a723eULL, 0x000fce00000010ffULL, 0x000000603018723cULL, 0x040b700000041818ULL,
0x0000004c3014723cULL, 0x040b700000041814ULL, 0x000000843010723cULL, 0x040b700000041810ULL,
0x00000046300c723cULL, 0x040b70000004180cULL, 0x0000005a3008723cULL, 0x000b620000041808ULL,
0x0000001000009944ULL, 0x000fe20003c00000ULL, 0xffffe0e000007947ULL, 0x000fcc000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff3f7224ULL, 0x000fe200078e003dULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffcb7000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x0000002a18187220ULL, 0x0a0fe40000410000ULL,
0x0000002a14147220ULL, 0x000fc40000410000ULL, 0x0000002a15157220ULL, 0x080fe40000410000ULL,
0x0000002a04047220ULL, 0x080fe40000410000ULL, 0x0000002a05057220ULL, 0x080fe40000410000ULL,
0x0000002a20207220ULL, 0x080fe40000410000ULL, 0x0000002a21217220ULL, 0x080fe40000410000ULL,
0x0000002a1c1c7220ULL, 0x000fc40000410000ULL, 0x0000002a1d1d7220ULL, 0x080fe40000410000ULL,
0x0000002a19197220ULL, 0x080fe40000410000ULL, 0x0000002a10027220ULL, 0x080fe40000410000ULL,
0x0000002a11037220ULL, 0x080fe40000410000ULL, 0x0000002a08087220ULL, 0x080fe40000410000ULL,
0x0000002a16307220ULL, 0x000fc40000410000ULL, 0x0000002a17317220ULL, 0x080fe40000410000ULL,
0x0000002a12327220ULL, 0x080fe40000410000ULL, 0x0000002a13337220ULL, 0x080fe40000410000ULL,
0x0000002a0c167220ULL, 0x080fe40000410000ULL, 0x0000002a0d177220ULL, 0x080fe40000410000ULL,
0x0000002a0e347220ULL, 0x000fc40000410000ULL, 0x0000002a0f357220ULL, 0x080fe40000410000ULL,
0x0000002a0a367220ULL, 0x080fe40000410000ULL, 0x0000002a0b377220ULL, 0x000fe40000410000ULL,
0x000000ffff107224ULL, 0x000fe400078e0018ULL, 0x000000ffff127224ULL, 0x000fe400078e0014ULL,
0x000000ffff137224ULL, 0x000fc400078e0015ULL, 0x0000002a06247220ULL, 0x080fe40000410000ULL,
0x0000002a07257220ULL, 0x080fe40000410000ULL, 0x0000002a22227220ULL, 0x080fe40000410000ULL,
0x0000002a23237220ULL, 0x080fe40000410000ULL, 0x0000002a1e1e7220ULL, 0x080fe40000410000ULL,
0x0000002a1f1f7220ULL, 0x000fc40000410000ULL, 0x0000002a1a267220ULL, 0x080fe40000410000ULL,
0x0000002a1b277220ULL, 0x080fe40000410000ULL, 0x0000002a09097220ULL, 0x000fe40000410000ULL,
0x000000ffff0b7224ULL, 0x000fe400078e0004ULL, 0x000000ffff0a7224ULL, 0x000fe400078e0005ULL,
0x000000ffff0c7224ULL, 0x000fc400078e0020ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0021ULL,
0x000000ffff0e7224ULL, 0x000fe400078e001cULL, 0x000000ffff0f7224ULL, 0x000fe400078e001dULL,
0x000000ffff117224ULL, 0x000fe400078e0019ULL, 0x000000ffff147224ULL, 0x000fe400078e0002ULL,
0x000000ffff157224ULL, 0x000fc400078e0003ULL, 0x000000ffff187224ULL, 0x000fe200078e0008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000002c067f8cULL, 0x0002a2000c80043fULL,
0x000000ffff1c7224ULL, 0x000fe400078e0022ULL, 0x000000ffff1d7224ULL, 0x000fe400078e0023ULL,
0x000000ffff1a7224ULL, 0x000fe400078e0024ULL, 0x000000ffff1b7224ULL, 0x000fe400078e0025ULL,
0x000000ffff207224ULL, 0x000fc400078e0026ULL, 0x000000ffff217224ULL, 0x000fe400078e0027ULL,
0x000000ffff227224ULL, 0x000fe400078e0030ULL, 0x000000ffff237224ULL, 0x000fe400078e0031ULL,
0x000000ffff197224ULL, 0x000fe400078e0009ULL, 0x000000ffff247224ULL, 0x000fe400078e0032ULL,
0x000000ffff257224ULL, 0x000fc400078e0033ULL, 0x000000ffff267224ULL, 0x000fe400078e0034ULL,
0x000000ffff277224ULL, 0x000fe400078e0035ULL, 0x000000ffff307224ULL, 0x000fe400078e0036ULL,
0x000000ffff317224ULL, 0x000fc400078e0037ULL, 0x0000000000027805ULL, 0x006fca0000015200ULL,
0x000004002c057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804807ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff087224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000047805ULL, 0x000fcc0000015200ULL, 0x0000000402097210ULL, 0x000fca0007f1e1ffULL,
0x0000000105057824ULL, 0x000fe200000e0e03ULL, 0x003d09000900780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400900780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc80000011405ULL,
0x0000000904047211ULL, 0x000fca00078110ffULL, 0x000000ffff057224ULL, 0x000fca00000e0605ULL,
0x0000000204047819ULL, 0x000fc80000001205ULL, 0x000000040000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000108087810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004002c057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000428037824ULL, 0x000fe200078e00ffULL, 0x0000002f3e00720cULL, 0x000fc80003f05270ULL,
0xfffffff003057812ULL, 0x000fca00078ec0ffULL, 0x000000802e027824ULL, 0x000fca00078e0205ULL,
0x0184000002047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000228087824ULL, 0x000fe400078e00ffULL, 0x000000012d407824ULL, 0x000fc600078e0a40ULL,
0x0000000608097812ULL, 0x000fc800078ec0ffULL, 0x0000000109337812ULL, 0x040fe400078efcffULL,
0x0000000809357812ULL, 0x000fe400078efcffULL, 0x000000403300720cULL, 0x080fe40003f26070ULL,
0x0000001009337812ULL, 0x000fe400078efcffULL, 0x000000403500720cULL, 0x080fe40003f06070ULL,
0x000000403300720cULL, 0x000fc40003fc6070ULL, 0x0000001109357812ULL, 0x040fe400078efcffULL,
0x0000001809337812ULL, 0x040fe400078efcffULL, 0x000000400900720cULL, 0x080fe40003f46070ULL,
0x000000403500720cULL, 0x080fe40003fa6070ULL, 0x000000403300720cULL, 0x000fe40003f66070ULL,
0x0000000909377812ULL, 0x000fc400078efcffULL, 0x0000001909357812ULL, 0x040fe400078efcffULL,
0x0000002009337812ULL, 0x000fe400078efcffULL, 0xff8000001a1a7808ULL, 0x000fe40005000000ULL,
0xff8000000b0b7808ULL, 0x000fe40005000000ULL, 0xff8000001b1b7808ULL, 0x000fe40004800000ULL,
0xff8000000a0a7808ULL, 0x000fc40004800000ULL, 0x000000403700720cULL, 0x080fe40003f86070ULL,
0x000000403500720cULL, 0x080fe40003f46070ULL, 0x000000403300720cULL, 0x000fe40003f26070ULL,
0x0000002109357812ULL, 0x040fe400078efcffULL, 0x0000002809337812ULL, 0x000fe400078efcffULL,
0xff8000001c1c7808ULL, 0x000fc40004000000ULL, 0xff8000000c0c7808ULL, 0x000fe40004000000ULL,
0xff8000001d1d7808ULL, 0x000fe40006000000ULL, 0xff8000000d0d7808ULL, 0x000fe40006000000ULL,
0x000000403500720cULL, 0x080fe40003f06070ULL, 0x000000403300720cULL, 0x000fe40003f86070ULL,
0x0000002909357812ULL, 0x000fc400078efcffULL, 0x0000003009337812ULL, 0x000fe400078efcffULL,
0xff8000001e1e7808ULL, 0x000fe40007000000ULL, 0xff8000000e0e7808ULL, 0x000fe40007000000ULL,
0xff8000001f1f7808ULL, 0x000fe40006800000ULL, 0xff8000000f0f7808ULL, 0x000fe40006800000ULL,
0x000000403500720cULL, 0x000fc40003fc6070ULL, 0x000000403300720cULL, 0x000fe40003fa6070ULL,
0x0000003109357812ULL, 0x040fe400078efcffULL, 0x0000003809337812ULL, 0x040fe400078efcffULL,
0x0000003909097812ULL, 0x000fe400078efcffULL, 0xff80000020207808ULL, 0x000fe40005800000ULL,
0xff80000010107808ULL, 0x000fc40005800000ULL, 0xff80000021217808ULL, 0x000fe40005000000ULL,
0xff80000011117808ULL, 0x000fe40005000000ULL, 0xff80000022227808ULL, 0x000fe40004800000ULL,
0xff80000012127808ULL, 0x000fe40004800000ULL, 0x000000403500720cULL, 0x080fe40003f66070ULL,
0x000000403300720cULL, 0x000fc40003f46070ULL, 0x000000400900720cULL, 0x000fe40003f26070ULL,
0xff80000023237808ULL, 0x000fe40004000000ULL, 0xff80000013137808ULL, 0x000fe40004000000ULL,
0xff80000024247808ULL, 0x000fe40006000000ULL, 0xff80000014147808ULL, 0x000fe40006000000ULL,
0xff80000025257808ULL, 0x000fc40007000000ULL, 0xff80000015157808ULL, 0x000fe40007000000ULL,
0xff80000026267808ULL, 0x000fe40006800000ULL, 0xff80000016167808ULL, 0x000fe40006800000ULL,
0xff80000027277808ULL, 0x000fe40005800000ULL, 0xff80000017177808ULL, 0x000fe40005800000ULL,
0xff80000030307808ULL, 0x000fc40005000000ULL, 0xff80000018187808ULL, 0x000fe40005000000ULL,
0xff80000031317808ULL, 0x000fe40004800000ULL, 0xff80000019197808ULL, 0x000fc40004800000ULL,
0x0000000b0400720bULL, 0x004fe40003f1e000ULL, 0x0000001a0500720bULL, 0x000fe40003f3e000ULL,
0x000000040b097208ULL, 0x000fe40004000000ULL, 0x000000051a047208ULL, 0x000fc40004800000ULL,
0x0000000a0900720bULL, 0x000fe40003f1e000ULL, 0x0000001b0400720bULL, 0x000fe40003f3e000ULL,
0x000000090a097208ULL, 0x000fe40004000000ULL, 0x000000041b057208ULL, 0x000fe40004800000ULL,
0x0000000c0900720bULL, 0x000fe40003f1e000ULL, 0x0000001c0500720bULL, 0x000fc40003f3e000ULL,
0x000000090c047208ULL, 0x000fe40004000000ULL, 0x000000051c087208ULL, 0x000fe40004800000ULL,
0x0000000d0400720bULL, 0x000fe40003f1e000ULL, 0x0000001d0800720bULL, 0x000fe40003f3e000ULL,
0x000000040d057208ULL, 0x000fe40004000000ULL, 0x000000081d097208ULL, 0x000fc40004800000ULL,
0x0000000e0500720bULL, 0x000fe40003f1e000ULL, 0x0000001e0900720bULL, 0x000fe40003f3e000ULL,
0x000000050e047208ULL, 0x000fe40004000000ULL, 0x000000091e087208ULL, 0x000fe40004800000ULL,
0x0000000f0400720bULL, 0x000fe40003f1e000ULL, 0x0000001f0800720bULL, 0x000fc40003f3e000ULL,
0x000000040f057208ULL, 0x000fe40004000000ULL, 0x000000081f097208ULL, 0x000fe40004800000ULL,
0x000000100500720bULL, 0x000fe40003f1e000ULL, 0x000000200900720bULL, 0x000fe40003f3e000ULL,
0x0000000510047208ULL, 0x000fe40004000000ULL, 0x0000000920087208ULL, 0x000fc40004800000ULL,
0x000000110400720bULL, 0x000fe40003f1e000ULL, 0x000000210800720bULL, 0x000fe40003f3e000ULL,
0x0000000411057208ULL, 0x000fe40004000000ULL, 0x0000000821097208ULL, 0x000fe40004800000ULL,
0x000000120500720bULL, 0x000fe40003f1e000ULL, 0x000000220900720bULL, 0x000fc40003f3e000ULL,
0x0000000512047208ULL, 0x000fe40004000000ULL, 0x0000000922087208ULL, 0x000fe40004800000ULL,
0x000000130400720bULL, 0x000fe40003f1e000ULL, 0x000000230800720bULL, 0x000fe40003f3e000ULL,
0x0000000413057208ULL, 0x000fe40004000000ULL, 0x0000000823097208ULL, 0x000fc40004800000ULL,
0x000000140500720bULL, 0x000fe40003f1e000ULL, 0x000000240900720bULL, 0x000fe40003f3e000ULL,
0x0000000514047208ULL, 0x000fe40004000000ULL, 0x0000000924087208ULL, 0x000fe40004800000ULL,
0x000000150400720bULL, 0x000fe40003f1e000ULL, 0x000000250800720bULL, 0x000fc40003f3e000ULL,
0x0000000415057208ULL, 0x000fe40004000000ULL, 0x0000000825097208ULL, 0x000fe40004800000ULL,
0x000000160500720bULL, 0x000fe40003f1e000ULL, 0x000000260900720bULL, 0x000fe40003f3e000ULL,
0x0000000516047208ULL, 0x000fe40004000000ULL, 0x0000000926087208ULL, 0x000fc40004800000ULL,
0x000000170400720bULL, 0x000fe40003f1e000ULL, 0x000000270800720bULL, 0x000fe40003f3e000ULL,
0x0000000417057208ULL, 0x000fe40004000000ULL, 0x0000000827097208ULL, 0x000fe40004800000ULL,
0x000000180500720bULL, 0x000fe40003f1e000ULL, 0x000000300900720bULL, 0x000fc40003f3e000ULL,
0x0000000518047208ULL, 0x000fe40004000000ULL, 0x0000000930087208ULL, 0x000fe40004800000ULL,
0x000000190400720bULL, 0x000fe40003f1e000ULL, 0x000000310800720bULL, 0x000fe40003f3e000ULL,
0x0000000419347208ULL, 0x000fe40004000000ULL, 0x0000000831367208ULL, 0x000fe20004800000ULL,
0x00001b827f007947ULL, 0x000fec000b800000ULL, 0x0c401f0034047f89ULL, 0x0004e400000e0000ULL,
0x000000043400720bULL, 0x008fc80003f1e000ULL, 0x0000003404377208ULL, 0x000fe20004000000ULL,
0x00001bb27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0036047f89ULL, 0x000ee800000e0000ULL,
0x0c401f0006057f89ULL, 0x000f2800000e0000ULL, 0x0c401f0007327f89ULL, 0x000e6200000e0000ULL,
0x000000043600720bULL, 0x008fc40003f1e000ULL, 0x000000050600720bULL, 0x010fe40003f3e000ULL,
0x0000003604087208ULL, 0x000fe40004000000ULL, 0x0000000605097208ULL, 0x000fe20004800000ULL,
0x0c201f0037047f89ULL, 0x000ee200000e0000ULL, 0x000000320700720bULL, 0x002fc60003f1e000ULL,
0x0c201f0008057f89ULL, 0x000e6200000e0000ULL, 0x0000000732327208ULL, 0x000fc60004000000ULL,
0x0c201f0009347f89ULL, 0x004ea800000e0000ULL, 0x0c201f0032337f89ULL, 0x0002a200000e0000ULL,
0x000000043700720bULL, 0x008fe40003f1e000ULL, 0x000000050800720bULL, 0x002fe40003f3e000ULL,
0x0000003704047208ULL, 0x000fe40004000000ULL, 0x000000340900720bULL, 0x004fc40003f5e000ULL,
0x0000000805057208ULL, 0x000fe40004800000ULL, 0x0000000934067208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0x3fb8aa3b05367820ULL, 0x000fe20000410000ULL, 0x00000002ff377819ULL, 0x000fe20000011628ULL,
0x3fb8aa3b0b0b7823ULL, 0x100fe20000010807ULL, 0x0000000328ff7812ULL, 0x000fe2000780c0ffULL,
0x3fb8aa3b0c0c7823ULL, 0x100fe20000010807ULL, 0x000000333200720bULL, 0x004fe20003f3e000ULL,
0x3fb8aa3b0d0d7823ULL, 0x100fe20000010807ULL, 0x0000000b00087308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b16167823ULL, 0x000fc40000010807ULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe40000010836ULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe40000010836ULL, 0x3fb8aa3b0a0a7823ULL, 0x100fe20000010807ULL,
0x0000001600347308ULL, 0x002fe20000000800ULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe40000010836ULL,
0x3fb8aa3b1d1d7823ULL, 0x000fe40000010836ULL, 0x3fb8aa3b0e0e7823ULL, 0x000fc40000010807ULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe20000010807ULL, 0x0000000a00097308ULL, 0x000e620000000800ULL,
0x3fb8aa3b10107823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b11117823ULL, 0x000fe40000010807ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe40000010836ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010836ULL,
0x0000000c000c7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b20207823ULL, 0x000fc40000010836ULL,
0x3fb8aa3b21217823ULL, 0x100fe40000010836ULL, 0x3fb8aa3b12127823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b13137823ULL, 0x100fe20000010807ULL, 0x0000000d000d7308ULL, 0x000ea20000000800ULL,
0x000000080908723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b14147823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b15157823ULL, 0x000fe40000010807ULL, 0x3fb8aa3b22227823ULL, 0x000fc40000010836ULL,
0x0000001a001a7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b23237823ULL, 0x100fe40000010836ULL,
0x3fb8aa3b24247823ULL, 0x100fe40000010836ULL, 0x3fb8aa3b25257823ULL, 0x000fe40000010836ULL,
0x3fb8aa3b17177823ULL, 0x100fe20000010807ULL, 0x0000001b001b7308ULL, 0x000e620000000800ULL,
0x0000000c0d0a723eULL, 0x004fe200000010ffULL, 0x3fb8aa3b18187823ULL, 0x000fc40000010807ULL,
0x3fb8aa3b19077823ULL, 0x000fe40000010807ULL, 0x3fb8aa3b26267823ULL, 0x100fe40000010836ULL,
0x0000001c000b7308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b27277823ULL, 0x100fe40000010836ULL,
0x3fb8aa3b30307823ULL, 0x100fe40000010836ULL, 0x3fb8aa3b31317823ULL, 0x000fe40000010836ULL,
0x0000000837367824ULL, 0x000fe200078e00ffULL, 0x0000001d00167308ULL, 0x0007220000000800ULL,
0x00000004ff1c7e24ULL, 0x004fe2000f8e00ffULL, 0x0000001a1b09723eULL, 0x002fe200000010ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000008371b7824ULL, 0x000fc400078e00ffULL,
0x3f8000001c1c783eULL, 0x000fe400000010ffULL, 0x0000000e000e7308ULL, 0x000fe60000000800ULL,
0x000000ffff1d7224ULL, 0x008fe200078e001cULL, 0x0000000b160b723eULL, 0x010fc800000010ffULL,
0x0000000f000f7308ULL, 0x000e620000000800ULL, 0x0000000437167810ULL, 0x000fe40007ffe0ffULL,
0x0000001c0838723cULL, 0x000f6a00000418ffULL, 0x0000001000107308ULL, 0x000ff00000000800ULL,
0x0000001100117308ULL, 0x000ea20000000800ULL, 0x0000000e0f0c723eULL, 0x002fce00000010ffULL,
0x0000001e001e7308ULL, 0x000ff00000000800ULL, 0x0000001f001f7308ULL, 0x000e620000000800ULL,
0x00000010110e723eULL, 0x004fe200000010ffULL, 0x0000000837117824ULL, 0x040fe200078e00ffULL,
0x0000000137107810ULL, 0x000fc80007ffe0ffULL, 0xfffffff8111a7812ULL, 0x000fe200078ee210ULL,
0x0000002000207308ULL, 0x000ff00000000800ULL, 0x0000002100217308ULL, 0x000ea20000000800ULL,
0x0000001e1f0d723eULL, 0x002fe200000010ffULL, 0x00000008371e7824ULL, 0x040fe200078e00ffULL,
0x00000005371f7810ULL, 0x000fc80007ffe0ffULL, 0xfffffff8361f7812ULL, 0x000fe200078ee21fULL,
0x0000001200127308ULL, 0x000fe20000000800ULL, 0x00000020210f723eULL, 0x004fce00000010ffULL,
0x0000001300137308ULL, 0x000e620000000800ULL, 0x000000ffff207224ULL, 0x100fe400078e001cULL,
0x000000ffff217224ULL, 0x000fe200078e001cULL, 0x0000001c0c38723cULL, 0x020b680000041838ULL,
0x0000001400147308ULL, 0x000ff00000000800ULL, 0x0000001500157308ULL, 0x000ea20000000800ULL,
0x000000121310723eULL, 0x002fce00000010ffULL, 0x0000002200227308ULL, 0x000ff00000000800ULL,
0x0000002300237308ULL, 0x000e620000000800ULL, 0x000000141512723eULL, 0x004fe400000010ffULL,
0x0000000337157810ULL, 0x000fc40007ffe0ffULL, 0x0000000237147810ULL, 0x000fe40007ffe0ffULL,
0xfffffff81e1d7812ULL, 0x020fe200078ee215ULL, 0x0000002400247308ULL, 0x000fe20000000800ULL,
0xfffffff81b1b7812ULL, 0x000fce00078ee214ULL, 0x0000002500257308ULL, 0x000ea20000000800ULL,
0x000000222311723eULL, 0x002fe200000010ffULL, 0x0000000837227824ULL, 0x040fe400078e00ffULL,
0x0000000837237824ULL, 0x000fc600078e00ffULL, 0xfffffff822197812ULL, 0x000fe200078ee237ULL,
0x0000001700357308ULL, 0x0002e20000000800ULL, 0x000000242513723eULL, 0x004fe200000010ffULL,
0x0000000837177824ULL, 0x002fcc00078e00ffULL, 0x0000001800187308ULL, 0x000fe20000000800ULL,
0x0000000837247810ULL, 0x000fe40007ffe0ffULL, 0xfffffff8171e7812ULL, 0x000fe400078ee216ULL,
0x000000201014723cULL, 0x000b620000041838ULL, 0x000000343534723eULL, 0x008fe400000010ffULL,
0x0000000700077308ULL, 0x000e620000000800ULL, 0x0000000824257824ULL, 0x000fc600078e00ffULL,
0x0000000637207810ULL, 0x060fe20007ffe0ffULL, 0x000000ffff387224ULL, 0x100fe200078e001cULL,
0xffffffff37217810ULL, 0x000fe40007ffe0ffULL, 0x0000002600267308ULL, 0x000fe20000000800ULL,
0x000000ffff397224ULL, 0x000fe200078e001cULL, 0xfffffff825247812ULL, 0x000fe400078ee224ULL,
0x000120002e257811ULL, 0x000fe400078e58ffULL, 0xfffffff823207812ULL, 0x000fc400078ee220ULL,
0x0000002700277308ULL, 0x000ea20000000800ULL, 0x000000180736723eULL, 0x002fe200000010ffULL,
0x0000001019197824ULL, 0x100fe200078e0225ULL, 0x0000000c03187812ULL, 0x000fe200078ec0ffULL,
0x000000101a037824ULL, 0x000fe200078e0225ULL, 0xfffffff822227812ULL, 0x000fe200078ee221ULL,
0x000000101b1b7824ULL, 0x100fe400078e0225ULL, 0x0000003000307308ULL, 0x000fe20000000800ULL,
0x000000101d1d7824ULL, 0x100fe400078e0225ULL, 0x000000101e077824ULL, 0x000fc400078e0225ULL,
0x0000000119197824ULL, 0x000fe400078e0218ULL, 0x000000101f1f7824ULL, 0x000fe200078e0225ULL,
0x0000003100317308ULL, 0x000e620000000800ULL, 0x000000262735723eULL, 0x004fe200000010ffULL,
0x0000000118037824ULL, 0x000fe200078e0203ULL, 0x0000000819007388ULL, 0x0005e20000000800ULL,
0x0000001020217824ULL, 0x000fe400078e0225ULL, 0x00000001181b7824ULL, 0x000fe200078e021bULL,
0x0000000a03007388ULL, 0x0005e20000000800ULL, 0x0000001022237824ULL, 0x000fc400078e0225ULL,
0x00000001181d7824ULL, 0x000fe200078e021dULL, 0x0000000c1b007388ULL, 0x0005e20000000800ULL,
0x0000001024257824ULL, 0x000fe400078e0225ULL, 0x00000001181f7824ULL, 0x040fe200078e021fULL,
0x0000000e1d007388ULL, 0x0005e20000000800ULL, 0x000000303137723eULL, 0x002fe200000010ffULL,
0x0000000118217824ULL, 0x040fe400078e0221ULL, 0x0000000118237824ULL, 0x000fc800078e0223ULL,
0x000000383438723cULL, 0x000b6e0000041814ULL, 0x0000000118147824ULL, 0x060fe200078e0207ULL,
0x0000003233077208ULL, 0x000fe20004800000ULL, 0x0000000118187824ULL, 0x000fc600078e0225ULL,
0x0000001014007388ULL, 0x0005e80000000800ULL, 0x000000121f007388ULL, 0x0005e80000000800ULL,
0x0000003421007388ULL, 0x0005e80000000800ULL, 0x0000003623007388ULL, 0x0005e20000000800ULL,
0x000000ffff397224ULL, 0x000fc600078e003aULL, 0x0000000918007388ULL, 0x0005e80000000800ULL,
0x0004000b03007388ULL, 0x0005e80000000800ULL, 0x0004000d1b007388ULL, 0x0005e80000000800ULL,
0x0004000f1d007388ULL, 0x0005e80000000800ULL, 0x0004001114007388ULL, 0x0005e80000000800ULL,
0x000400131f007388ULL, 0x0005e80000000800ULL, 0x0004003521007388ULL, 0x0005e80000000800ULL,
0x0004003723007388ULL, 0x0005e80000000800ULL, 0x0180000402008388ULL, 0x0005e80000000c00ULL,
0x0182003802008388ULL, 0x0005e20000000a00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000003cff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000008003cff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000010003cff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000013e3e7810ULL, 0x000fe20007ffe0ffULL, 0x000018003cff7f8cULL, 0x0003e6000c80043fULL,
0x0000002b3e00720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffadc000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff407807ULL, 0x002fe20004000000ULL, 0xffffffffff457424ULL, 0x000fe200078e00ffULL,
0x0002060000467802ULL, 0x000fc40000000f00ULL, 0x000013b000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff027224ULL, 0x000fe200078e0045ULL, 0xfffe166000007947ULL, 0x000fea000383ffffULL,
0x00000001ff407807ULL, 0x000fe20005000000ULL, 0xffffffffff457424ULL, 0x000fe200078e00ffULL,
0x0002066000467802ULL, 0x000fc40000000f00ULL, 0x0000135000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff027224ULL, 0x000fe200078e0045ULL, 0xfffe169000007947ULL, 0x000fea000383ffffULL,
0x000000ffff597224ULL, 0x000fe200078e0020ULL, 0x000206e000407802ULL, 0x000fe20000000f00ULL,
0x000000ffff587224ULL, 0x008fe400078e0035ULL, 0x0000001fff5a7424ULL, 0x000fc400078e00ffULL,
0xffffffffff5b7424ULL, 0x000fc400078e00ffULL, 0x0000129000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff207224ULL, 0x004fe200078e0058ULL, 0xfffe170000007947ULL, 0x000fea000383ffffULL,
0x000000ffff587224ULL, 0x000fe200078e0035ULL, 0x0002076000407802ULL, 0x000fe20000000f00ULL,
0x000000ffff597224ULL, 0x000fe400078e0020ULL, 0x0000001fff5a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff5b7424ULL, 0x000fc400078e00ffULL, 0x0000121000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff207224ULL, 0x004fe200078e0058ULL, 0xfffe17f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff587224ULL, 0x000fe200078e0000ULL, 0x000207e000407802ULL, 0x000fe20000000f00ULL,
0x000000ffff597224ULL, 0x000fc400078e0003ULL, 0x0000001fff5a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff5b7424ULL, 0x000fc400078e00ffULL, 0x0000119000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff237224ULL, 0x004fe200078e0058ULL, 0xfffe1bc000007947ULL, 0x000fea000383ffffULL,
0x000000ffff597224ULL, 0x002fe200078e0022ULL, 0x0002086000407802ULL, 0x000fe20000000f00ULL,
0x000000ffff587224ULL, 0x000fe400078e0000ULL, 0x0000001fff5a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff5b7424ULL, 0x000fc400078e00ffULL, 0x0000111000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff227224ULL, 0x004fe200078e0058ULL, 0xfffe1b7000007947ULL, 0x000fea000383ffffULL,
0x000000ffff587224ULL, 0x000fe200078e0036ULL, 0x000208e000407802ULL, 0x000fe20000000f00ULL,
0x000000ffff597224ULL, 0x000fc400078e0037ULL, 0x0000001fff5a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff5b7424ULL, 0x000fc400078e00ffULL, 0x0000109000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff237224ULL, 0x004fe200078e0058ULL, 0xfffe472000007947ULL, 0x000fea000383ffffULL,
0x000000ffff587224ULL, 0x000fe200078e0036ULL, 0x0002095000407802ULL, 0x000fe20000000f00ULL,
0x0000001fff5a7424ULL, 0x000fe400078e00ffULL, 0xffffffffff5b7424ULL, 0x000fc400078e00ffULL,
0x0000102000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff227224ULL, 0x004fe200078e0058ULL,
0xfffe46e000007947ULL, 0x000fea000383ffffULL, 0x00000001ff407807ULL, 0x004fe20004000000ULL,
0xffffffffff457424ULL, 0x000fe200078e00ffULL, 0x000209b000467802ULL, 0x000fc40000000f00ULL,
0x0000100000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff447224ULL, 0x000fe200078e0045ULL,
0xfffe72c000007947ULL, 0x000fea000383ffffULL, 0x00000001ff407807ULL, 0x000fe20005000000ULL,
0xffffffffff457424ULL, 0x000fe200078e00ffULL, 0x00020a1000467802ULL, 0x000fc40000000f00ULL,
0x00000fa000007944ULL, 0x002fea0003c00000ULL, 0xfffe730000007947ULL, 0x000fea000383ffffULL,
0x000000ffff587224ULL, 0x000fe200078e0046ULL, 0x00020a7000407802ULL, 0x000fe20000000f00ULL,
0x0000001fff5a7424ULL, 0x000fc400078e00ffULL, 0xffffffffff5b7424ULL, 0x000fc400078e00ffULL,
0x00000f0000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff3c7224ULL, 0x004fe200078e0058ULL,
0xfffe73a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff587224ULL, 0x000fe200078e0046ULL,
0x00020ae000407802ULL, 0x000fe20000000f00ULL, 0x0000001fff5a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff5b7424ULL, 0x000fc400078e00ffULL, 0x00000e9000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff3c7224ULL, 0x004fe200078e0058ULL, 0xfffe749000007947ULL, 0x000fea000383ffffULL,
0x000000ffff587224ULL, 0x000fe200078e003dULL, 0x00020b6000407802ULL, 0x000fe20000000f00ULL,
0x000000ffff597224ULL, 0x000fe400078e0042ULL, 0x0000001fff5a7424ULL, 0x000fc400078e00ffULL,
0xffffffffff5b7424ULL, 0x000fc400078e00ffULL, 0x00000e1000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff237224ULL, 0x004fe200078e0058ULL, 0xfffe788000007947ULL, 0x000fea000383ffffULL,
0x000000ffff587224ULL, 0x000fe200078e003dULL, 0x00020bd000407802ULL, 0x000fe20000000f00ULL,
0x0000001fff5a7424ULL, 0x000fe400078e00ffULL, 0xffffffffff5b7424ULL, 0x000fc400078e00ffULL,
0x00000da000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff227224ULL, 0x004fe200078e0058ULL,
0xfffe784000007947ULL, 0x000fea000383ffffULL, 0x000000ffff587224ULL, 0x000fe200078e0030ULL,
0x00020c5000407802ULL, 0x000fe20000000f00ULL, 0x000000ffff597224ULL, 0x000fe400078e0031ULL,
0x0000001fff5a7424ULL, 0x000fc400078e00ffULL, 0xffffffffff5b7424ULL, 0x000fc400078e00ffULL,
0x00000d2000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff237224ULL, 0x004fe200078e0058ULL,
0xfffea22000007947ULL, 0x000fea000383ffffULL, 0x000000ffff587224ULL, 0x000fe200078e0030ULL,
0x00020cc000407802ULL, 0x000fe20000000f00ULL, 0x0000001fff5a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff5b7424ULL, 0x000fc400078e00ffULL, 0x00000cb000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff227224ULL, 0x004fe200078e0058ULL, 0xfffea1e000007947ULL, 0x000fea000383ffffULL,
0x00000001ff407807ULL, 0x004fe20004000000ULL, 0xffffffffff457424ULL, 0x000fe200078e00ffULL,
0x00020d2000467802ULL, 0x000fc40000000f00ULL, 0x00000c9000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff427224ULL, 0x000fe200078e0045ULL, 0xfffeccc000007947ULL, 0x000fea000383ffffULL,
0x00000001ff407807ULL, 0x000fe20005000000ULL, 0xffffffffff457424ULL, 0x000fe200078e00ffULL,
0x00020d8000467802ULL, 0x000fc40000000f00ULL, 0x00000c3000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff437224ULL, 0x000fe200078e0045ULL, 0xfffeccf000007947ULL, 0x000fea000383ffffULL,
0x000000ffff587224ULL, 0x000fe200078e0044ULL, 0x00020df000407802ULL, 0x000fe20000000f00ULL,
0x0000001fff5a7424ULL, 0x000fc400078e00ffULL, 0xffffffffff5b7424ULL, 0x000fc400078e00ffULL,
0x00000b8000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff407224ULL, 0x004fe200078e0058ULL,
0xfffecd9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff587224ULL, 0x000fe200078e0044ULL,
0x00020e6000407802ULL, 0x000fe20000000f00ULL, 0x0000001fff5a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff5b7424ULL, 0x000fc400078e00ffULL, 0x00000b1000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff407224ULL, 0x004fe200078e0058ULL, 0xfffece8000007947ULL, 0x000fea000383ffffULL,
0x000000ffff587224ULL, 0x000fe200078e003cULL, 0x00020ee000407802ULL, 0x000fe20000000f00ULL,
0x000000ffff597224ULL, 0x000fe400078e003dULL, 0x0000001fff5a7424ULL, 0x000fc400078e00ffULL,
0xffffffffff5b7424ULL, 0x000fc400078e00ffULL, 0x00000a9000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff237224ULL, 0x004fe200078e0058ULL, 0xfffed27000007947ULL, 0x000fea000383ffffULL,
0x000000ffff587224ULL, 0x000fe200078e003cULL, 0x00020f5000407802ULL, 0x000fe20000000f00ULL,
0x0000001fff5a7424ULL, 0x000fe400078e00ffULL, 0xffffffffff5b7424ULL, 0x000fc400078e00ffULL,
0x00000a2000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff227224ULL, 0x004fe200078e0058ULL,
0xfffed23000007947ULL, 0x000fea000383ffffULL, 0x000000ffff587224ULL, 0x000fe200078e0030ULL,
0x00020fd000407802ULL, 0x000fe20000000f00ULL, 0x000000ffff597224ULL, 0x000fe400078e0031ULL,
0x0000001fff5a7424ULL, 0x000fc400078e00ffULL, 0xffffffffff5b7424ULL, 0x000fc400078e00ffULL,
0x000009a000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff237224ULL, 0x004fe200078e0058ULL,
0xfffefc0000007947ULL, 0x000fea000383ffffULL, 0x000000ffff587224ULL, 0x000fe200078e0030ULL,
0x0002104000407802ULL, 0x000fe20000000f00ULL, 0x0000001fff5a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff5b7424ULL, 0x000fc400078e00ffULL, 0x0000093000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff227224ULL, 0x004fe200078e0058ULL, 0xfffefbc000007947ULL, 0x000fea000383ffffULL,
0x00000001ff407807ULL, 0x004fe20004000000ULL, 0xffffffffff457424ULL, 0x000fe200078e00ffULL,
0x000210a000467802ULL, 0x000fc40000000f00ULL, 0x0000091000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff447224ULL, 0x000fe200078e0045ULL, 0xffff26b000007947ULL, 0x000fea000383ffffULL,
0x00000001ff407807ULL, 0x000fe20004800000ULL, 0xffffffffff457424ULL, 0x000fe200078e00ffULL,
0x0002110000467802ULL, 0x000fc40000000f00ULL, 0x000008b000007944ULL, 0x002fea0003c00000ULL,
0xffff26f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff587224ULL, 0x000fe200078e003cULL,
0x0002116000407802ULL, 0x000fe20000000f00ULL, 0x0000001fff5a7424ULL, 0x000fc400078e00ffULL,
0xffffffffff5b7424ULL, 0x000fc400078e00ffULL, 0x0000081000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff257224ULL, 0x004fe200078e0058ULL, 0xffff279000007947ULL, 0x000fea000383ffffULL,
0x000000ffff587224ULL, 0x000fe200078e003cULL, 0x000211d000407802ULL, 0x000fe20000000f00ULL,
0x0000001fff5a7424ULL, 0x000fe400078e00ffULL, 0xffffffffff5b7424ULL, 0x000fc400078e00ffULL,
0x000007a000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff257224ULL, 0x004fe200078e0058ULL,
0xffff288000007947ULL, 0x000fea000383ffffULL, 0x000000ffff587224ULL, 0x000fe200078e0025ULL,
0x0002125000407802ULL, 0x000fe20000000f00ULL, 0x000000ffff597224ULL, 0x000fe400078e0042ULL,
0x0000001fff5a7424ULL, 0x000fc400078e00ffULL, 0xffffffffff5b7424ULL, 0x000fc400078e00ffULL,
0x0000072000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff237224ULL, 0x004fe200078e0058ULL,
0xffff2c7000007947ULL, 0x000fea000383ffffULL, 0x000000ffff587224ULL, 0x000fe200078e0025ULL,
0x000212c000407802ULL, 0x000fe20000000f00ULL, 0x0000001fff5a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff5b7424ULL, 0x000fc400078e00ffULL, 0x000006b000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff227224ULL, 0x004fe200078e0058ULL, 0xffff2c3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff587224ULL, 0x000fe200078e0000ULL, 0x0002134000407802ULL, 0x000fe20000000f00ULL,
0x000000ffff597224ULL, 0x000fe400078e0003ULL, 0x0000001fff5a7424ULL, 0x000fc400078e00ffULL,
0xffffffffff5b7424ULL, 0x000fc400078e00ffULL, 0x0000063000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff237224ULL, 0x004fe200078e0058ULL, 0xffff563000007947ULL, 0x000fea000383ffffULL,
0x000000ffff587224ULL, 0x000fe200078e0000ULL, 0x000213b000407802ULL, 0x000fe20000000f00ULL,
0x0000001fff5a7424ULL, 0x000fe400078e00ffULL, 0xffffffffff5b7424ULL, 0x000fc400078e00ffULL,
0x000005c000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff227224ULL, 0x004fe200078e0058ULL,
0xffff55f000007947ULL, 0x000fea000383ffffULL, 0x00000002ff357424ULL, 0x000fe200078e00ffULL,
0x0002142000087802ULL, 0x000fe20000000f00ULL, 0x0000001fff337424ULL, 0x000fe400078e00ffULL,
0xffffffffff387424ULL, 0x000fc400078e00ffULL, 0x0000051000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0033ULL, 0xffffe42000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x006fe200078e0036ULL, 0x000214a000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff357424ULL, 0x000fc400078e00ffULL, 0x0000001fff337424ULL, 0x000fe400078e00ffULL,
0xffffffffff387424ULL, 0x000fc400078e00ffULL, 0x0000049000007944ULL, 0x000fea0003c00000ULL,
0x000000333600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff347224ULL, 0x002fe200078e0006ULL,
0x0002152000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff357424ULL, 0x000fe200078e00ffULL,
0x0000003633367208ULL, 0x000fe20004000000ULL, 0x0000001fff337424ULL, 0x000fe400078e00ffULL,
0xffffffffff387424ULL, 0x000fc400078e00ffULL, 0x0000041000007944ULL, 0x000fea0003c00000ULL,
0x000000330600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff347224ULL, 0x002fe200078e0007ULL,
0x000215a000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff357424ULL, 0x000fe200078e00ffULL,
0x0000000633067208ULL, 0x000fe20004000000ULL, 0x0000001fff337424ULL, 0x000fc400078e00ffULL,
0xffffffffff387424ULL, 0x000fc400078e00ffULL, 0x0000039000007944ULL, 0x000fea0003c00000ULL,
0x000000330700720bULL, 0x004fe20003f1e000ULL, 0x000000ffff347224ULL, 0x002fe200078e0037ULL,
0x0002162000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff357424ULL, 0x000fe200078e00ffULL,
0x0000000733327208ULL, 0x000fe20004000000ULL, 0x0000001fff337424ULL, 0x000fe400078e00ffULL,
0xffffffffff387424ULL, 0x000fc400078e00ffULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x000000333700720bULL, 0x004fe20003f1e000ULL, 0x000000ffff347224ULL, 0x002fe200078e0036ULL,
0x000216a000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff357424ULL, 0x000fe200078e00ffULL,
0x0000003733047208ULL, 0x000fe20004000000ULL, 0x0000001fff337424ULL, 0x000fc400078e00ffULL,
0xffffffffff387424ULL, 0x000fc400078e00ffULL, 0x0000029000007944ULL, 0x000fea0003c00000ULL,
0x000000333600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff347224ULL, 0x002fe200078e0006ULL,
0x0002172000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff357424ULL, 0x000fe200078e00ffULL,
0x0000003633057208ULL, 0x000fe20004000000ULL, 0x0000001fff337424ULL, 0x000fe400078e00ffULL,
0xffffffffff387424ULL, 0x000fc400078e00ffULL, 0x0000021000007944ULL, 0x000fea0003c00000ULL,
0x000000330600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff347224ULL, 0x002fe200078e0032ULL,
0x000217a000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff357424ULL, 0x000fe200078e00ffULL,
0x0000000633067208ULL, 0x000fe20004000000ULL, 0x0000001fff337424ULL, 0x000fc400078e00ffULL,
0xffffffffff387424ULL, 0x000fc400078e00ffULL, 0x0000019000007944ULL, 0x000fea0003c00000ULL,
0xffffe21000007947ULL, 0x000fea000383ffffULL, 0x0180000029007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000002900008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff29ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000029027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000002900007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffde6d002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff097424ULL, 0x000fe200078e00ffULL,
0x0000003800007348ULL, 0x000fe80003800000ULL, 0x0c00003534337389ULL, 0x0002a200000e0033ULL,
0xfffde69008007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff417424ULL, 0x000fe200078e00ffULL,
0x0000005b00007348ULL, 0x000fe80003800000ULL, 0x0000005958587389ULL, 0x0002a200000e005aULL,
0xfffde65040007950ULL, 0x000fea0003c3ffffULL, 0x000000014000780cULL, 0x000fe20003f45070ULL,
0x0000004500007348ULL, 0x000fe80003800000ULL, 0x00000000ff417424ULL, 0x000fd000078e00ffULL,
0x0000000000407806ULL, 0x000fc800050e0100ULL, 0x0000004540457212ULL, 0x000fe200078ec0ffULL,
0x000000ffff407224ULL, 0x000fc800078e0046ULL, 0xfffde5e040007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000100000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005e7ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000748ULL, 0x0000000000000288ULL, 0x0000001a00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009d0ULL, 0x00000000000003e8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000db8ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e78ULL, 0x0000000000000a08ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001880ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001890ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000007bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001920ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001924ULL, 0x00000000000001a8ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001b00ULL, 0x0000000000021b00ULL, 0xee00001a00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x0000000100000089ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000023600ULL, 0x0000000000000044ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000023650ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x00000000000239d0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001920ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000021ce0ULL, 0x0000000000021ce0ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000023600ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x00000000000239d0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_1_kvt_int8_nqpkv_8_m_8_sm_80_cubin_len = 146096;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
