/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_1_kvt_int8_nqpkv_8_m_8_sm_86_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000021e50ULL, 0x0000000000021ad0ULL, 0x0038004000560556ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f34314944327961ULL, 0x6f6c66625f766e5fULL,
0x326a4c3236317461ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL,
0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x336a4c4536316a4cULL, 0x4c49746132454532ULL,
0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45346a4c4534366aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL,
0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL,
0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL, 0x45326a4c4545316aULL, 0x7461324545316a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x4939494432796172ULL, 0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL,
0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL,
0x4c4545346a4c6a49ULL, 0x36316a4c4532336aULL, 0x624c497461324545ULL, 0x31534b5245454531ULL,
0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL,
0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL, 0x4c4545326a4c4532ULL, 0x4545316a4c45326aULL,
0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x45386a4c4545346aULL,
0x7461324545386a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL,
0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL,
0x6a4c4536316a4c45ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5f2400676e696469ULL, 0x616e7265746e695fULL, 0x635f5f245f305f6cULL,
0x30326d735f616475ULL, 0x5f6e725f7063725fULL, 0x5f3233665f7a7466ULL, 0x68746170776f6c73ULL,
0x65746e695f5f2400ULL, 0x245f315f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL,
0x6c66625f636e7973ULL, 0x695f5f2400705f79ULL, 0x5f6c616e7265746eULL, 0x6475635f5f245f32ULL,
0x735f30376d735f61ULL, 0x5f636e79736c6668ULL, 0x5f2400705f786469ULL, 0x616e7265746e695fULL,
0x635f5f245f335f6cULL, 0x30376d735f616475ULL, 0x6e797365746f765fULL, 0x746f6c6c61625f63ULL,
0x742e616c65722e00ULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL,
0x5f6c656e72656b2eULL, 0x72656b240061686dULL, 0x2461686d5f6c656eULL, 0x657479426d656d73ULL,
0x2e766e2e00667542ULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x61705f0061686d5fULL,
0x6265642e006d6172ULL, 0x656d6172665f6775ULL, 0x65642e6c65722e00ULL, 0x6d6172665f677562ULL,
0x2e616c65722e0065ULL, 0x72665f6775626564ULL, 0x2e766e2e00656d61ULL, 0x697463612e6c6572ULL,
0x0000000000006e6fULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c0001000000adULL, 0x0000000000000034ULL, 0x0000000000000010ULL, 0x000c0001000000ebULL,
0x000000000000001cULL, 0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c00010000016bULL, 0x000000000000002cULL, 0x0000000000000004ULL,
0x000c0001000001b5ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c0001000001fbULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000242ULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000c000100000288ULL, 0x0000000000000030ULL, 0x0000000000000004ULL,
0x000c0001000002d6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c000100000324ULL,
0x0000000000000018ULL, 0x0000000000000004ULL, 0x000c000100000372ULL, 0x000000000000000cULL,
0x0000000000000004ULL, 0x000c0001000003b9ULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000c000100000407ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c00010000044cULL,
0x0000000000000020ULL, 0x0000000000000004ULL, 0x000b002200000492ULL, 0x000000000001fc30ULL,
0x0000000000000190ULL, 0x000b0022000004c5ULL, 0x000000000001fdc0ULL, 0x0000000000000040ULL,
0x000b0022000004f0ULL, 0x000000000001fe00ULL, 0x0000000000000040ULL, 0x000b00220000051aULL,
0x000000000001fe40ULL, 0x0000000000000140ULL, 0x000a000300000588ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00040003000005a8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00070003000005d8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL,
0x0000000000000000ULL, 0x000000000001ff80ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0001fc3000000000ULL,
0x0000040400000000ULL, 0x810c0000015c0400ULL, 0x007da40400288080ULL, 0x0000000000000000ULL,
0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x9508288080940828ULL, 0x2880809608288080ULL,
0x809a082880809808ULL, 0x082880809b082880ULL, 0x80809d082880809cULL, 0x9f082880809e0828ULL,
0x288080a108288080ULL, 0x80c608288080c408ULL, 0x08288080da082880ULL, 0x80808508288080dbULL,
0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808592ULL, 0x00000034ffffffffULL,
0x0000007000000000ULL, 0x0001fc3000000000ULL, 0x0000019000000000ULL, 0x0000580400000000ULL,
0x8084288080820900ULL, 0x0900000004042880ULL, 0x2880808228808085ULL, 0x0000009cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080820828808081ULL, 0x8b082880808a0828ULL, 0x2880808f08288080ULL, 0x8095082880809408ULL,
0x0828808096082880ULL, 0x8080980828808097ULL, 0x9b082880809a0828ULL, 0x2880809c08288080ULL,
0x809e082880809d08ULL, 0x082880809f082880ULL, 0x8080c408288080a1ULL, 0xdb08288080c60828ULL,
0x2880808808288080ULL, 0x0003102880828016ULL, 0x9200000000000000ULL, 0x0000220028808088ULL,
0x0000001cffffffffULL, 0x0000014800000000ULL, 0x0001fdc000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x0000009cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8b082880808a0828ULL,
0x2880808f08288080ULL, 0x8095082880809408ULL, 0x0828808096082880ULL, 0x8080980828808097ULL,
0x9b082880809a0828ULL, 0x2880809c08288080ULL, 0x809e082880809d08ULL, 0x082880809f082880ULL,
0x8080c608288080a1ULL, 0xdb08288080da0828ULL, 0x288080c408288080ULL, 0x0003102880828016ULL,
0x9200000000000000ULL, 0x00002200288080c4ULL, 0x0000001cffffffffULL, 0x0000021800000000ULL,
0x0001fe0000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000009cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080820828808081ULL, 0x8b082880808a0828ULL, 0x2880808f08288080ULL, 0x8095082880809408ULL,
0x0828808096082880ULL, 0x8080980828808097ULL, 0x9b082880809a0828ULL, 0x2880809c08288080ULL,
0x809e082880809d08ULL, 0x082880809f082880ULL, 0x8080c608288080a1ULL, 0xdb08288080da0828ULL,
0x288080c408288080ULL, 0x0003102880828016ULL, 0x9200000000000000ULL, 0x00002200288080c4ULL,
0x0000001cffffffffULL, 0x000002e800000000ULL, 0x0001fe4000000000ULL, 0x0000014000000000ULL,
0x0000000000000000ULL, 0x0000001a00082f04ULL, 0x00082304000000e7ULL, 0x0000000000000016ULL,
0x0000001600081204ULL, 0x0008110400000000ULL, 0x0000000000000016ULL, 0x0000001500082304ULL,
0x0008120400000000ULL, 0x0000000000000015ULL, 0x0000001500081104ULL, 0x0008230400000000ULL,
0x0000000000000014ULL, 0x0000001400081204ULL, 0x0008110400000000ULL, 0x0000000000000014ULL,
0x0000001300082304ULL, 0x0008120400000000ULL, 0x0000000000000013ULL, 0x0000001300081104ULL,
0x0008230400000000ULL, 0x000000000000001aULL, 0x0000001a00081204ULL, 0x0008110400000000ULL,
0x000000000000001aULL, 0x0000007b00043704ULL, 0x00080a0400003501ULL, 0x0048016000000017ULL,
0x000c170400481903ULL, 0x0040000600000000ULL, 0x000c17040021f000ULL, 0x0038000500000000ULL,
0x000c17040021f000ULL, 0x0030000400000000ULL, 0x000c17040011f000ULL, 0x0018000300000000ULL,
0x000c17040061f000ULL, 0x0010000200000000ULL, 0x000c17040021f000ULL, 0x0008000100000000ULL,
0x000c17040021f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0x0000002000043104ULL,
0xffffffff01982904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x01982804ffffffffULL,
0x00000100000000e0ULL, 0x00001c8000000470ULL, 0x00001e2000001d30ULL, 0x000023e000001f90ULL,
0x0000246000002410ULL, 0x00005010000024b0ULL, 0x0000509000005040ULL, 0x00007c50000050e0ULL,
0x00007df000007ce0ULL, 0x000083c000007f50ULL, 0x00008440000083f0ULL, 0x0000ae1000008490ULL,
0x0000ae900000ae40ULL, 0x0000d9400000aee0ULL, 0x0000dae00000d9d0ULL, 0x0000e0b00000dc40ULL,
0x0000e1300000e0e0ULL, 0x00010b000000e180ULL, 0x00010b8000010b30ULL, 0x0001364000010bd0ULL,
0x000137e0000136d0ULL, 0x00013db000013940ULL, 0x00013e3000013de0ULL, 0x0001682000013e80ULL,
0x000168a000016850ULL, 0x00018960000168f0ULL, 0x0001914000018970ULL, 0x0001e1800001e140ULL,
0x0001e1a00001e190ULL, 0x0001e2100001e1f0ULL, 0x0001e2400001e230ULL, 0x0001ef100001eec0ULL,
0x0001efd00001ef70ULL, 0x0001f0900001f030ULL, 0x0001f1400001f0f0ULL, 0x0001f1e00001f190ULL,
0x0001f2800001f230ULL, 0x0001f3300001f2e0ULL, 0x0001f3e00001f390ULL, 0x0001f4800001f430ULL,
0x0001f5200001f4d0ULL, 0x0001f5d00001f580ULL, 0x0001f6800001f630ULL, 0x0001f7200001f6d0ULL,
0x0001f7c00001f770ULL, 0x0001f8700001f820ULL, 0x0001f9200001f8d0ULL, 0x0001f9d00001f970ULL,
0x0001fa900001fa30ULL, 0x0001fb500001faf0ULL, 0x0001fc100001fbb0ULL, 0x0000021006003904ULL,
0x00010600000000ffULL, 0x00000280003f0100ULL, 0x0001060800000003ULL, 0x00000320003f0120ULL,
0x0001068800000003ULL, 0x00000410003f0120ULL, 0x000106a800000003ULL, 0x00000440003f0120ULL,
0x000106b8000000ffULL, 0x00000500003f0100ULL, 0x00010600000000ffULL, 0x00000600003f0107ULL,
0x0001068c00000011ULL, 0x00000690003f0102ULL, 0x0001068800000011ULL, 0x00000d10003f0101ULL,
0x000106a8000000ffULL, 0x00000e30003f0107ULL, 0x000106a8000000ffULL, 0x00000e90003f0101ULL,
0x000106b8000000ffULL, 0x00000fc0003f0101ULL, 0x000106bc000000ffULL, 0x00001190003f0105ULL,
0x000106bc000000ffULL, 0x000018c0003f0105ULL, 0x000106b0000000ffULL, 0x00001940003f0107ULL,
0x000106b0000000ffULL, 0x000019a0003f0101ULL, 0x0001060800000011ULL, 0x000019c0003f0101ULL,
0x0001060c00000011ULL, 0x00001b90003f0105ULL, 0x0001060c00000011ULL, 0x00002140003f0105ULL,
0x000106ac000000ffULL, 0x00002310003f0105ULL, 0x000106ac000000ffULL, 0x00004420003f0105ULL,
0x000106b8000000ffULL, 0x00004450003f0101ULL, 0x000106bc000000ffULL, 0x00004610003f0105ULL,
0x000106bc000000ffULL, 0x00004cf0003f0105ULL, 0x000106a8000000ffULL, 0x00004d70003f0107ULL,
0x000106a8000000ffULL, 0x00004d90003f0101ULL, 0x000106b4000000ffULL, 0x00004f60003f0105ULL,
0x000106b4000000ffULL, 0x00006f70003f0105ULL, 0x000106b8000000ffULL, 0x00006fe0003f0101ULL,
0x00010688000000ffULL, 0x00007040003f0101ULL, 0x000106bc000000ffULL, 0x00007210003f0105ULL,
0x000106bc000000ffULL, 0x000078f0003f0105ULL, 0x000106b0000000ffULL, 0x00007970003f0107ULL,
0x000106b0000000ffULL, 0x000079d0003f0101ULL, 0x0001062800000011ULL, 0x000079f0003f0101ULL,
0x0001062c00000011ULL, 0x00007bc0003f0105ULL, 0x0001062c00000011ULL, 0x00008120003f0105ULL,
0x000106ac000000ffULL, 0x000082f0003f0105ULL, 0x000106ac000000ffULL, 0x0000a210003f0105ULL,
0x000106b8000000ffULL, 0x0000a240003f0101ULL, 0x000106bc000000ffULL, 0x0000a400003f0105ULL,
0x000106bc000000ffULL, 0x0000aae0003f0105ULL, 0x000106a8000000ffULL, 0x0000ab60003f0107ULL,
0x000106a8000000ffULL, 0x0000ab90003f0101ULL, 0x000106b4000000ffULL, 0x0000ad60003f0105ULL,
0x000106b4000000ffULL, 0x0000cc70003f0105ULL, 0x000106b8000000ffULL, 0x0000cce0003f0101ULL,
0x00010690000000ffULL, 0x0000cd30003f0101ULL, 0x000106bc000000ffULL, 0x0000cf00003f0105ULL,
0x000106bc000000ffULL, 0x0000d5e0003f0105ULL, 0x000106b0000000ffULL, 0x0000d660003f0107ULL,
0x000106b0000000ffULL, 0x0000d6c0003f0101ULL, 0x0001064800000011ULL, 0x0000d6e0003f0101ULL,
0x0001064c00000011ULL, 0x0000d8b0003f0105ULL, 0x0001064c00000011ULL, 0x0000de10003f0105ULL,
0x000106ac000000ffULL, 0x0000dfe0003f0105ULL, 0x000106ac000000ffULL, 0x0000ff00003f0105ULL,
0x000106b8000000ffULL, 0x0000ff30003f0101ULL, 0x000106bc000000ffULL, 0x000100f0003f0105ULL,
0x000106bc000000ffULL, 0x000107d0003f0105ULL, 0x000106a8000000ffULL, 0x00010850003f0107ULL,
0x000106a8000000ffULL, 0x00010880003f0101ULL, 0x000106b4000000ffULL, 0x00010a50003f0105ULL,
0x000106b4000000ffULL, 0x00012960003f0105ULL, 0x000106b8000000ffULL, 0x000129d0003f0101ULL,
0x00010698000000ffULL, 0x00012a30003f0101ULL, 0x000106bc000000ffULL, 0x00012c00003f0105ULL,
0x000106bc000000ffULL, 0x000132e0003f0105ULL, 0x000106b0000000ffULL, 0x00013360003f0107ULL,
0x000106b0000000ffULL, 0x000133c0003f0101ULL, 0x0001066800000011ULL, 0x000133e0003f0101ULL,
0x0001066c00000011ULL, 0x000135b0003f0105ULL, 0x0001066c00000011ULL, 0x00013b10003f0105ULL,
0x000106ac000000ffULL, 0x00013ce0003f0105ULL, 0x000106ac000000ffULL, 0x00015c00003f0105ULL,
0x000106b8000000ffULL, 0x00015c30003f0101ULL, 0x000106bc000000ffULL, 0x00015df0003f0105ULL,
0x000106bc000000ffULL, 0x000164f0003f0105ULL, 0x000106a8000000ffULL, 0x00016570003f0107ULL,
0x000106a8000000ffULL, 0x000165a0003f0101ULL, 0x000106b4000000ffULL, 0x00016770003f0105ULL,
0x000106b4000000ffULL, 0x00018680003f0105ULL, 0x000106b8000000ffULL, 0x000186e0003f0101ULL,
0x000106a0000000ffULL, 0x00019330003f0101ULL, 0x00010600000000ffULL, 0x00019e20003f0101ULL,
0x00010604000000ffULL, 0x00019ff0003f0105ULL, 0x00010604000000ffULL, 0x0001a370003f0105ULL,
0x00010600000000ffULL, 0x0001a3a0003f0101ULL, 0x00010604000000ffULL, 0x0001a560003f0105ULL,
0x00010604000000ffULL, 0x0001d540003f0105ULL, 0x0000000000000038ULL, 0x0001d670003f0101ULL,
0x0000000400000038ULL, 0x0001d840003f0105ULL, 0x0000000400000038ULL, 0x0001ed20003f0105ULL,
0x000000000000003aULL, 0x0001ed80003f0101ULL, 0x000000080000003aULL, 0x0001ede0003f0101ULL,
0x000000100000003aULL, 0x0001ee50003f0101ULL, 0x000000180000003aULL, 0x00053803003f0101ULL,
0x0001928000101c04ULL, 0x0001a6700001a5c0ULL, 0x000004010001ee90ULL, 0x00000100000c0504ULL,
0x0000000100000001ULL, 0x0000000000041e04ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x00000000000003a4ULL, 0x0000001a00000002ULL, 0x00000000000002d4ULL, 0x0000001a00000002ULL,
0x0000000000000204ULL, 0x0000001a00000002ULL, 0x000000000000011cULL, 0x0000001a00000002ULL,
0x0000000000000044ULL, 0x0000001a00000002ULL, 0x000000000000037fULL, 0x0000001a00000002ULL,
0x00000000000002afULL, 0x0000001a00000002ULL, 0x00000000000001dfULL, 0x0000001a00000002ULL,
0x00000000000000f8ULL, 0x0000001a00000002ULL, 0x0000000000010700ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000037919ULL, 0x000e620000002100ULL,
0x0000000000137806ULL, 0x000fe200038e0000ULL, 0x00005800ff077624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000047919ULL, 0x000ea20000002300ULL,
0x0000001300097300ULL, 0x000fe200000e0000ULL, 0x0000000807077824ULL, 0x000fe400078e00ffULL,
0x0000000000057919ULL, 0x000ee80000002200ULL, 0x0000000000147919ULL, 0x000f220000002600ULL,
0x0000001300137309ULL, 0x000ea60000000000ULL, 0x00000000000a7919ULL, 0x000f280000000000ULL,
0x0000000000127919ULL, 0x000f220000002700ULL, 0x00000005ff007819ULL, 0x002fc60000011603ULL,
0x00001fff040f7589ULL, 0x004fe200000e0000ULL, 0x000000ffff157224ULL, 0x000fc600078e0a13ULL,
0x00001fff00007589ULL, 0x000e6200000e0000ULL, 0x0000010004027a24ULL, 0x008fe400078e0205ULL,
0x0000000814067824ULL, 0x010fe400078e00ffULL, 0x0000000002037a24ULL, 0x000fe400078e0203ULL,
0x0000000000027919ULL, 0x000ea20000000000ULL, 0x0000000a0900720cULL, 0x000fe40003f02070ULL,
0x000000ff0300720cULL, 0x000fe20003f25270ULL, 0x00000012070a7224ULL, 0x000fe200078e0206ULL,
0x0000000f0300780cULL, 0x000fc40003f44070ULL, 0x0000007f0300780cULL, 0x040fe40003f84070ULL,
0x000000030300780cULL, 0x000fe20003f64070ULL, 0x000000040f087824ULL, 0x002fcc00078e0200ULL,
0x3fffff80ff049424ULL, 0x000fe400078e00ffULL, 0x00000002080b7824ULL, 0x000fe400078e00ffULL,
0x7fffff80ff059424ULL, 0x000fe400078e00ffULL, 0x000000010b0c7824ULL, 0x044fe400078e0202ULL,
0x000000200b0d7824ULL, 0x000fe200078e00ffULL, 0x01060004ff009388ULL, 0x0003e20000000a00ULL,
0x3fffffc0ff06a424ULL, 0x000fc400078e00ffULL, 0x7fffffc0ff07a424ULL, 0x000fe200078e00ffULL,
0xffffffe00d107812ULL, 0x000fe200078ee20cULL, 0xff317217ff16c424ULL, 0x000fe200078e00ffULL,
0x000000080b0c7817ULL, 0x000fe20007800000ULL, 0x3fffff60ff08b424ULL, 0x000fe200078e00ffULL,
0x010608060300a388ULL, 0x0005e20000008a00ULL, 0x000000010300780cULL, 0x000fe20003f44070ULL,
0x000000010a047824ULL, 0x102fe400078e020bULL, 0x000000010c0c7824ULL, 0x000fe200078e0a0bULL,
0x000000010b0b7810ULL, 0x000fe20007ffe0ffULL, 0x7fffff60ff09b424ULL, 0x000fe200078e00ffULL,
0x010400160300c388ULL, 0x0003e20000004800ULL, 0x00000200ff0d7424ULL, 0x000fe200078e00ffULL,
0x000000010c00780cULL, 0x000fe20003f83070ULL, 0x00000010020e7824ULL, 0x000fe200078e00ffULL,
0x010688080300b388ULL, 0x0007e20000008a00ULL, 0x000000010a067824ULL, 0x004fe200078e020bULL,
0x000000ff0c00720cULL, 0x000fe20003f63070ULL, 0x00005c0004047625ULL, 0x000fe200078e000dULL,
0x000001f00e117812ULL, 0x000fc600078ec0ffULL, 0x000000200b167824ULL, 0x002fe400078e00ffULL,
0x00005c0006067625ULL, 0x000fe200078e000dULL, 0x0000001104087210ULL, 0x008fc60007fbe0ffULL,
0x000000010b097824ULL, 0x000fe200078e0202ULL, 0x0000001106067210ULL, 0x000fe20007fde0ffULL,
0x3fffff00ff0aa424ULL, 0x000fe400078e00ffULL, 0x7fffff00ff0ba424ULL, 0x000fe200078e00ffULL,
0xffffffe016047812ULL, 0x000fe200078ee209ULL, 0x3fffff80ff0c9424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff0d9424ULL, 0x000fe200078e00ffULL, 0x0106a80a0300a388ULL, 0x000fe20000008a00ULL,
0x000000ffff097224ULL, 0x000fc400028e0605ULL, 0x0000001010117824ULL, 0x000fe200078e00ffULL,
0x0106b80cff009388ULL, 0x000fe20000000a00ULL, 0x000000ffff077224ULL, 0x000fe400030e0607ULL,
0x0000001004137824ULL, 0x000fe200078e00ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ffff037224ULL, 0x000fe200078e0015ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008117faeULL, 0x0003e2000d901c46ULL, 0x00000004ff057424ULL, 0x000fc600078e00ffULL,
0x0000000006137faeULL, 0x0003e2000e101c46ULL, 0x0000600012047625ULL, 0x000fc600078e0005ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x01060403ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01060000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000604037981ULL, 0x002ea2000c1e1900ULL, 0x000000ff0f00720cULL, 0x000fc40003f05270ULL,
0x000000ff03067810ULL, 0x004fc80007ffe0ffULL, 0x00000008ff107819ULL, 0x000fce0000011606ULL,
0x00018cc000008947ULL, 0x000fea0003800000ULL, 0x0000000800117824ULL, 0x000fe400078e00ffULL,
0x00000003ff047424ULL, 0x000fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01068c0411ff738cULL, 0x0003e20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000001ff0600780cULL, 0x000fe20003f04070ULL, 0x0000000212127824ULL, 0x000fe200078e00ffULL,
0x0000580014057a10ULL, 0x000fe20007ffe0ffULL, 0x0106880011ff7f8cULL, 0x0005e8000c80043fULL,
0x0000580012127a24ULL, 0x000fcc00078e0205ULL, 0x0000038000000947ULL, 0x000fea0003800000ULL,
0x00000004ff057819ULL, 0x004fe20000011602ULL, 0x00000100ff177424ULL, 0x000fe200078e00ffULL,
0x0000001103047217ULL, 0x002fe40007800000ULL, 0x0000000205067810ULL, 0x000fe20007ffe0ffULL,
0x0000000111077824ULL, 0x000fe200078e0205ULL, 0x0000000405087810ULL, 0x040fe20007ffe0ffULL,
0x0000000104047824ULL, 0x000fe200078e0a11ULL, 0x00000006050a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000111097824ULL, 0x040fe200078e0206ULL, 0x000000f00e157812ULL, 0x000fe200078ec0ffULL,
0x00000001110b7824ULL, 0x000fe200078e0208ULL, 0x000000040500720cULL, 0x080fe20003f66070ULL,
0x0000000107057824ULL, 0x140fe200078e0202ULL, 0x000000040600720cULL, 0x080fe20003f46070ULL,
0x00000010070c7824ULL, 0x000fe200078e00ffULL, 0x000000040800720cULL, 0x080fe20003f26070ULL,
0x0000000109067824ULL, 0x140fe200078e0202ULL, 0x000000040a00720cULL, 0x000fe20003f06070ULL,
0x00000010090f7824ULL, 0x000fe200078e00ffULL, 0xfffffff00c0c7812ULL, 0x000fe200078ee205ULL,
0x000000010b087824ULL, 0x000fc400078e0202ULL, 0x000000100b137824ULL, 0x000fe200078e00ffULL,
0xfffffff00f0f7812ULL, 0x000fe200078ee206ULL, 0x0000620012047a24ULL, 0x000fe400078e0207ULL,
0x0000000111077824ULL, 0x000fe200078e020aULL, 0xfffffff013137812ULL, 0x000fe200078ee208ULL,
0x00005e0004047625ULL, 0x000fe200078e0017ULL, 0x0000c0000f0f7811ULL, 0x000fe400078e20ffULL,
0x0000c00013137811ULL, 0x000fe200078e20ffULL, 0x0000620012067a24ULL, 0x000fe200078e0209ULL,
0x0000001504047210ULL, 0x000fe20007fbe0ffULL, 0x0000620012087a24ULL, 0x000fc400078e020bULL,
0x00006200120a7a24ULL, 0x000fe400078e0207ULL, 0x00000001070d7824ULL, 0x040fe400078e0202ULL,
0x00000010070e7824ULL, 0x000fe400078e00ffULL, 0x00005e0006067625ULL, 0x000fc600078e0017ULL,
0xfffffff00e0e7812ULL, 0x000fe200078ee20dULL, 0x00005e0008087625ULL, 0x000fe200078e0017ULL,
0x0000001506067210ULL, 0x000fe40007f9e0ffULL, 0x0000c0000c0d7811ULL, 0x000fe200078e20ffULL,
0x00005e000a0a7625ULL, 0x000fc800078e0017ULL, 0x000000ffff057224ULL, 0x000fe200028e0605ULL,
0x0000001508087210ULL, 0x080fe20007fbe0ffULL, 0x000000ffff077224ULL, 0x000fe200020e0607ULL,
0x000000150a0a7210ULL, 0x000fe40007fde0ffULL, 0x0000c0000e157811ULL, 0x000fe200078e20ffULL,
0x000000ffff097224ULL, 0x000fe200028e0609ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040d7faeULL, 0x0003e2000d901c46ULL, 0x000000ffff0b7224ULL, 0x000fc600030e060bULL,
0x00000000060f7faeULL, 0x0003e8000d101c46ULL, 0x0000000008137faeULL, 0x0003e8000c901c46ULL,
0x000000000a157faeULL, 0x0003e2000c101c46ULL, 0x000002d000007947ULL, 0x000fea0003800000ULL,
0x0000001102057211ULL, 0x004fe200078fe0ffULL, 0x00000100ff147424ULL, 0x000fe200078e00ffULL,
0x000000f00e157812ULL, 0x000fc400078ec0ffULL, 0x0000000205077810ULL, 0x040fe20007ffe0ffULL,
0x0000000105047824ULL, 0x142fe200078e0202ULL, 0x0000000405097810ULL, 0x040fe20007ffe0ffULL,
0x00000010050b7824ULL, 0x000fe400078e00ffULL, 0x0000000107067824ULL, 0x040fe400078e0202ULL,
0x00000010070f7824ULL, 0x000fe200078e00ffULL, 0xfffffff00b0c7812ULL, 0x000fe200078ee204ULL,
0x0000620012047a24ULL, 0x000fe200078e0205ULL, 0x00000006050b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000109087824ULL, 0x000fe200078e0202ULL, 0xfffffff00f0f7812ULL, 0x000fe200078ee206ULL,
0x0000001009137824ULL, 0x000fc400078e00ffULL, 0x00005e0004047625ULL, 0x080fe200078e0014ULL,
0x0000c0000f0f7811ULL, 0x000fe400078e20ffULL, 0xfffffff013137812ULL, 0x000fe200078ee208ULL,
0x0000620012077a24ULL, 0x000fe200078e0207ULL, 0x0000001504047210ULL, 0x000fe20007f1e0ffULL,
0x0000620012097a24ULL, 0x040fe200078e0209ULL, 0x0000c00013137811ULL, 0x000fe200078e20ffULL,
0x00006200120a7a24ULL, 0x000fe400078e020bULL, 0x00005e0007067625ULL, 0x000fc800078e0014ULL,
0x000000010b0d7824ULL, 0x040fe200078e0202ULL, 0x0000001506067210ULL, 0x000fe20007f3e0ffULL,
0x000000100b0e7824ULL, 0x000fe400078e00ffULL, 0x00005e0009087625ULL, 0x000fc600078e0014ULL,
0xfffffff00e0e7812ULL, 0x000fe200078ee20dULL, 0x00005e000a0a7625ULL, 0x000fe200078e0014ULL,
0x0000c0000c0d7811ULL, 0x000fc600078e20ffULL, 0x000000ffff057224ULL, 0x000fe200000e0605ULL,
0x0000001508087210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff077224ULL, 0x000fe200008e0607ULL,
0x000000150a0a7210ULL, 0x000fe40007f5e0ffULL, 0x0000c0000e157811ULL, 0x000fe200078e20ffULL,
0x000000ffff097224ULL, 0x000fe200000e0609ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040d7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff0b7224ULL, 0x000fc600010e060bULL,
0x00000000060f7faeULL, 0x0003e8000b901c46ULL, 0x0000000008137faeULL, 0x0003e8000b901c46ULL,
0x000000000a157faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000ff1000720cULL, 0x000fe20003f05270ULL, 0x000000ffff137224ULL, 0x002fe200078e00ffULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff297224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff3a7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b800ff147f8cULL, 0x000ea2000c80043fULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x0001780000008947ULL, 0x000fea0003800000ULL,
0x000000ffff467224ULL, 0x004fe400078e0015ULL, 0xff317217ff407424ULL, 0x000fc400078e00ffULL,
0x000000ffff157224ULL, 0x000fe400078e00ffULL, 0x000000ffff0f7224ULL, 0x000fc400078e00ffULL,
0x0000010015147824ULL, 0x000fca00078e00ffULL, 0x000000031400720cULL, 0x000fda0003f06070ULL,
0x0001775000000947ULL, 0x022fea0003800000ULL, 0x0000000000167805ULL, 0x000fc40000015200ULL,
0x0106bc00ff197984ULL, 0x000ea40000000800ULL, 0x8000000019ff7812ULL, 0x004fe40007804846ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000187805ULL, 0x000fcc0000015200ULL, 0x00000018161f7210ULL, 0x000fca0007f1e1ffULL,
0x0000000119197824ULL, 0x000fe200000e0e17ULL, 0x003d09001f00780cULL, 0x000fc80003f06070ULL,
0x000000ff1900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401f00780cULL, 0x000fc80003f06070ULL, 0x000000ff1900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011419ULL,
0x0000001f14147211ULL, 0x000fca00078110ffULL, 0x000000ffff197224ULL, 0x000fca00000e0619ULL,
0x0000000214147819ULL, 0x000fc80000001219ULL, 0x000000140000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011a1a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106bc00ff197984ULL, 0x000ea40000000800ULL,
0x8000000019ff7812ULL, 0x004fe40007804846ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000115177810ULL, 0x040fe40007ffe0ffULL, 0x0000002015147811ULL, 0x000fe400078e40ffULL,
0x000000101700720cULL, 0x000fc60003f26070ULL, 0x00006200121f7a24ULL, 0x000fd400078e0214ULL,
0x000003b000009947ULL, 0x000fea0003800000ULL, 0x0000001403177217ULL, 0x000fe20007800000ULL,
0x00000100ff237424ULL, 0x000fe200078e00ffULL, 0x00000004ff187819ULL, 0x000fc60000011602ULL,
0x0000000117167824ULL, 0x000fe200078e0a14ULL, 0x00000002181a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000111177824ULL, 0x000fc600078e0218ULL, 0x0000001611167217ULL, 0x000fe20007800000ULL,
0x0000000117197824ULL, 0x040fe400078e0202ULL, 0x0000001017227824ULL, 0x000fe400078e00ffULL,
0x0000000116167824ULL, 0x000fe400078e0a11ULL, 0x00000001111e7824ULL, 0x000fe200078e021aULL,
0xfffffff022227812ULL, 0x000fe200078ee219ULL, 0x0000001002197824ULL, 0x000fe200078e00ffULL,
0x000000161a00720cULL, 0x080fe20003f66070ULL, 0x0000000117177824ULL, 0x000fe200078e021fULL,
0x00000004181a7810ULL, 0x000fe20007ffe0ffULL, 0x000000011e207824ULL, 0x000fe200078e0202ULL,
0x000000161800720cULL, 0x000fe20003f86070ULL, 0x000000101e217824ULL, 0x000fe200078e00ffULL,
0x0000000618187810ULL, 0x000fc40007ffe0ffULL, 0x000000161a00720cULL, 0x080fe40003f46070ULL,
0x000000161800720cULL, 0x000fe20003f06070ULL, 0x00005e0017167625ULL, 0x000fe200078e0023ULL,
0x000000f019257812ULL, 0x000fe400078ec0ffULL, 0xfffffff021247812ULL, 0x000fe200078ee220ULL,
0x0000000111197824ULL, 0x040fe200078e021aULL, 0x0000002516207210ULL, 0x000fe20007fbe0ffULL,
0x0000000111267824ULL, 0x000fe400078e0218ULL, 0x000000011e187824ULL, 0x000fc400078e021fULL,
0x0000000119217824ULL, 0x040fe400078e0202ULL, 0x0000001019387824ULL, 0x040fe400078e00ffULL,
0x00000001191a7824ULL, 0x000fe400078e021fULL, 0x00005e0018187625ULL, 0x000fe200078e0023ULL,
0xfffffff038277812ULL, 0x000fc600078ee221ULL, 0x00000001261e7824ULL, 0x000fe200078e021fULL,
0x0000e00027277811ULL, 0x000fe200078e20ffULL, 0x000000ffff217224ULL, 0x000fe200028e0617ULL,
0x0000002518187210ULL, 0x000fe20007fbe0ffULL, 0x00005e001a167625ULL, 0x000fc800078e0023ULL,
0x00005e001e1e7625ULL, 0x000fc800078e0023ULL, 0x00000001261a7824ULL, 0x000fe200078e0202ULL,
0x000000251e1e7210ULL, 0x080fe20007fde0ffULL, 0x0000001026237824ULL, 0x000fe400078e00ffULL,
0x000000ffff197224ULL, 0x000fe200028e0619ULL, 0x0000002516167210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff1f7224ULL, 0x000fe200030e061fULL, 0xfffffff0231a7812ULL, 0x000fe400078ee21aULL,
0x0000e00022237811ULL, 0x000fe200078e20ffULL, 0x000000ffff177224ULL, 0x000fe200028e0617ULL,
0x0000e00024257811ULL, 0x000fc400078e20ffULL, 0x0000e0001a397811ULL, 0x000fe200078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020237faeULL, 0x0005e8000e101c46ULL,
0x0000000018257faeULL, 0x0005e8000d901c46ULL, 0x0000000016277faeULL, 0x0005e8000d101c46ULL,
0x000000001e397faeULL, 0x0005e2000c101c46ULL, 0x000002e000007947ULL, 0x000fea0003800000ULL,
0x0000001102177211ULL, 0x000fc800078fe0ffULL, 0x0000000217197810ULL, 0x040fe20007ffe0ffULL,
0x0000000117167824ULL, 0x140fe200078e0202ULL, 0x00000004171e7810ULL, 0x040fe20007ffe0ffULL,
0x0000001017217824ULL, 0x040fe200078e00ffULL, 0x0000000617227810ULL, 0x000fe20007ffe0ffULL,
0x0000000119187824ULL, 0x040fe400078e0202ULL, 0x0000001019257824ULL, 0x000fe200078e00ffULL,
0xfffffff0211a7812ULL, 0x000fe200078ee216ULL, 0x00000100ff217424ULL, 0x000fe400078e00ffULL,
0x0000000117167824ULL, 0x000fe200078e021fULL, 0xfffffff025257812ULL, 0x000fe200078ee218ULL,
0x0000001002187824ULL, 0x000fc400078e00ffULL, 0x000000011e207824ULL, 0x040fe200078e0202ULL,
0x0000e00025257811ULL, 0x000fe200078e20ffULL, 0x000000101e277824ULL, 0x000fe200078e00ffULL,
0x000000f018237812ULL, 0x000fe200078ec0ffULL, 0x00005e0016167625ULL, 0x000fc600078e0021ULL,
0xfffffff027277812ULL, 0x000fe200078ee220ULL, 0x0000000119187824ULL, 0x100fe200078e021fULL,
0x0000002316167210ULL, 0x000fe20007f1e0ffULL, 0x000000011e1e7824ULL, 0x100fe200078e021fULL,
0x0000e00027277811ULL, 0x000fe200078e20ffULL, 0x0000000122207824ULL, 0x000fe400078e021fULL,
0x00005e0018187625ULL, 0x000fc800078e0021ULL, 0x00005e001e1e7625ULL, 0x000fe200078e0021ULL,
0x0000002318187210ULL, 0x000fc60007f5e0ffULL, 0x00005e0020207625ULL, 0x000fc800078e0021ULL,
0x0000000122247824ULL, 0x000fe200078e0202ULL, 0x0000002320207210ULL, 0x080fe20007f7e0ffULL,
0x0000001022397824ULL, 0x000fe400078e00ffULL, 0x000000ffff177224ULL, 0x000fe200000e0617ULL,
0x000000231e1e7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff197224ULL, 0x000fe200010e0619ULL,
0xfffffff039247812ULL, 0x000fe200078ee224ULL, 0x000000ffff217224ULL, 0x000fe200018e0621ULL,
0x0000e0001a237811ULL, 0x000fe200078e20ffULL, 0x000000ffff1f7224ULL, 0x000fe200000e061fULL,
0x0000e00024397811ULL, 0x000fc600078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0005e8000b901c46ULL, 0x0000000018257faeULL, 0x0005e8000b901c46ULL,
0x000000001e277faeULL, 0x0005e8000b901c46ULL, 0x0000000020397faeULL, 0x0005e4000b901c46ULL,
0x0000000000007918ULL, 0x004fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff507f8cULL, 0x000ea2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01060800111e7f8cULL, 0x0006a4000c80043fULL, 0x0000000000167805ULL, 0x000fc40000015200ULL,
0x01060c0011197984ULL, 0x000f240000000800ULL, 0x8000000019ff7812ULL, 0x014fc4000780481fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000187805ULL, 0x000fcc0000015200ULL, 0x0000001816217210ULL, 0x000fca0007f1e1ffULL,
0x0000000119197824ULL, 0x000fe200000e0e17ULL, 0x003d09002100780cULL, 0x000fc80003f06070ULL,
0x000000ff1900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402100780cULL, 0x000fc80003f06070ULL, 0x000000ff1900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff187819ULL, 0x000fc80000011419ULL,
0x0000002118187211ULL, 0x000fca00078110ffULL, 0x000000ffff197224ULL, 0x000fca00000e0619ULL,
0x0000000218187819ULL, 0x000fc80000001219ULL, 0x000000180000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011a1a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01060c0011197984ULL, 0x000ea40000000800ULL,
0x8000000019ff7812ULL, 0x004fe4000780481fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001ff177819ULL, 0x000fe20000011602ULL, 0x0000001002167824ULL, 0x000fc600078e00ffULL,
0x0000000c17187812ULL, 0x000fe400078ec0ffULL, 0x0000007016177812ULL, 0x000fca00078ec0ffULL,
0x0000000117177824ULL, 0x000fe400078e0218ULL, 0xffffffffff187424ULL, 0x000fc600078e00ffULL,
0x01000000171f7984ULL, 0x000ea80000000800ULL, 0x01020000171e7984ULL, 0x0006620000000800ULL,
0x000000401f00720bULL, 0x004fe20003f1d000ULL, 0x0001d2227f007947ULL, 0x000fd8000b800000ULL,
0x0000000000197806ULL, 0x008fc800000e0100ULL, 0x0000ffff19237812ULL, 0x000fe2000780c0ffULL,
0x0000047000007945ULL, 0x000fe20003800000ULL, 0x00000001ff227424ULL, 0x000fe400078e00ffULL,
0x000000ffff527224ULL, 0x000fc400078e0040ULL, 0x0000001fff197424ULL, 0x000fe400078e00ffULL,
0xffffffffff1a7424ULL, 0x000fca00078e00ffULL, 0x0000041000008947ULL, 0x000fea0003800000ULL,
0x000000ff0000720cULL, 0x000fe40003f05270ULL, 0x000000401f00720bULL, 0x000fe20003f54000ULL,
0x0001d1c27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000207806ULL, 0x000fc400010e0100ULL,
0x0000001f40527209ULL, 0x000fe20007810000ULL, 0x0000035000017945ULL, 0x000fe20003800000ULL,
0x0000991020217816ULL, 0x000fc600000000ffULL, 0x0104005217008388ULL, 0x0005e20000000800ULL,
0x000000ff2100720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x8000005240217221ULL, 0x004fe20000010000ULL, 0x000000ff20ff7812ULL, 0x000fe2000780c0ffULL,
0x0000017000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b21217820ULL, 0x000fc80000410000ULL,
0x0000002100247308ULL, 0x0004ec0000000800ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff217819ULL, 0x004fe20000011602ULL, 0x0001d1227f007947ULL, 0x000fea000b800000ULL,
0x00001f2124217589ULL, 0x0084e400000e0000ULL, 0x000000213c3c7220ULL, 0x088fe20000410000ULL,
0x000000213d3d7220ULL, 0x080fe20000410000ULL, 0x0000002134347220ULL, 0x080fe20000410000ULL,
0x0000002135357220ULL, 0x080fe20000410000ULL, 0x0000002130307220ULL, 0x080fe20000410000ULL,
0x0000002131317220ULL, 0x080fe20000410000ULL, 0x000000212c2c7220ULL, 0x080fe20000410000ULL,
0x000000212d2d7220ULL, 0x080fe20000410000ULL, 0x0000002128287220ULL, 0x080fe20000410000ULL,
0x0000002129297220ULL, 0x080fe20000410000ULL, 0x0000002108087220ULL, 0x080fe20000410000ULL,
0x0000002109097220ULL, 0x080fe20000410000ULL, 0x0000002104047220ULL, 0x080fe20000410000ULL,
0x0000002105057220ULL, 0x080fe20000410000ULL, 0x000000210c0c7220ULL, 0x080fe20000410000ULL,
0x000000210d0d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0020ff7812ULL, 0x000fe2000780c0ffULL, 0x0000002413137220ULL, 0x008fd80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000802217811ULL, 0x004fe200078ff0ffULL,
0x0001d0127f007947ULL, 0x000fea000b800000ULL, 0x00001f2124217589ULL, 0x0004e400000e0000ULL,
0x000000213e3e7220ULL, 0x088fe20000410000ULL, 0x000000213f3f7220ULL, 0x080fe20000410000ULL,
0x0000002136367220ULL, 0x080fe20000410000ULL, 0x0000002137377220ULL, 0x080fe20000410000ULL,
0x0000002132327220ULL, 0x080fe20000410000ULL, 0x0000002133337220ULL, 0x080fe20000410000ULL,
0x000000212e2e7220ULL, 0x080fe20000410000ULL, 0x000000212f2f7220ULL, 0x080fe20000410000ULL,
0x000000212a2a7220ULL, 0x080fe20000410000ULL, 0x000000212b2b7220ULL, 0x080fe20000410000ULL,
0x000000210a0a7220ULL, 0x080fe20000410000ULL, 0x000000210b0b7220ULL, 0x080fe20000410000ULL,
0x0000002106067220ULL, 0x080fe20000410000ULL, 0x0000002107077220ULL, 0x080fe20000410000ULL,
0x000000210e0e7220ULL, 0x080fe20000410000ULL, 0x000000210f0f7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff23ff7812ULL, 0x000fda0007806020ULL,
0x800000521f1f0221ULL, 0x000fe20000010000ULL, 0x00007610ff220816ULL, 0x000fc60000000022ULL,
0x3fb8aa3b1f1f0820ULL, 0x000fc80000410000ULL, 0x0000001f001b0308ULL, 0x000ea40000000800ULL,
0x0000001b1e1e0220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000131e137221ULL, 0x002fc40000010000ULL, 0x00000000001e7805ULL, 0x000fca0000015200ULL,
0x0106ac00ff207984ULL, 0x000e640000000800ULL, 0x8000000020ff7812ULL, 0x002fe4000780483bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff247224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000207805ULL, 0x000fcc0000015200ULL, 0x000000201e237210ULL, 0x000fca0007f1e1ffULL,
0x0000000121217824ULL, 0x000fe200000e0e1fULL, 0x003d09002300780cULL, 0x000fc80003f06070ULL,
0x000000ff2100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402300780cULL, 0x000fc80003f06070ULL, 0x000000ff2100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff207819ULL, 0x000fc80000011421ULL,
0x0000002320207211ULL, 0x000fca00078110ffULL, 0x000000ffff217224ULL, 0x000fca00000e0621ULL,
0x0000000220207819ULL, 0x000fc80000001221ULL, 0x000000200000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000124247810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106ac00ff207984ULL, 0x000e640000000800ULL,
0x8000000020ff7812ULL, 0x002fe4000780483bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009910221e7816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff1e00720cULL, 0x000fda0003f45270ULL, 0x0000012000002947ULL, 0x000fea0003800000ULL,
0x0000001bff1c723eULL, 0x000fe400000010ffULL, 0x00000002ff1e7819ULL, 0x000fe40000011602ULL,
0x000054101c1f7816ULL, 0x000fe2000000001cULL, 0x0001cc227f007947ULL, 0x000fea000b800000ULL,
0x00001f1e1f1d7589ULL, 0x0002a400000e0000ULL, 0x000000081e1c7810ULL, 0x000fe20007ffe0ffULL,
0x0001cc527f007947ULL, 0x000fea000b800000ULL, 0x00001f1c1f1c7589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000101e5b7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff5a7224ULL, 0x000fe200078e001fULL, 0x0000247000447802ULL, 0x000fc40000000f00ULL,
0x0001d99000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000181e5b7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff5a7224ULL, 0x004fe200078e001fULL,
0x000024c000447802ULL, 0x000fc40000000f00ULL, 0x0001d94000007944ULL, 0x008fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000008021f7812ULL, 0x00afe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000004ff1e7819ULL, 0x000fc40000011602ULL,
0x000000071f547812ULL, 0x000fe400078ef802ULL, 0x0000000200237811ULL, 0x040fe200078e10ffULL,
0x0000000400597824ULL, 0x100fe200078e021eULL, 0x0000001054227812ULL, 0x040fe200078efcffULL,
0x0000001054207824ULL, 0x000fe200078e00ffULL, 0x0000000702557812ULL, 0x000fe200078ec0ffULL,
0x00000001541f7824ULL, 0x000fe200078e0259ULL, 0x0000002322567210ULL, 0x000fe20007ffe01eULL,
0x000000011e577824ULL, 0x000fe200078e0223ULL, 0x0000000855557812ULL, 0x000fe200078ef802ULL,
0x0000001054217824ULL, 0x000fe200078e00ffULL, 0xfffffff0201f7812ULL, 0x000fe200078ee21fULL,
0x0000000154207824ULL, 0x000fc400078e0257ULL, 0x0000000159587824ULL, 0x000fe200078e0222ULL,
0x0000c0001f1f7811ULL, 0x000fe200078e20ffULL, 0x0000001022237824ULL, 0x040fe200078e00ffULL,
0xfffffff021207812ULL, 0x000fe200078ee220ULL, 0x0000001022217824ULL, 0x000fe400078e00ffULL,
0x000000001f40783bULL, 0x000e620000004200ULL, 0xfffffff023567812ULL, 0x000fe200078ee256ULL,
0x000000011e537824ULL, 0x000fe200078e0255ULL, 0xfffffff021587812ULL, 0x000fe400078ee258ULL,
0x0000c00020207811ULL, 0x000fc400078e20ffULL, 0x0000c00058217811ULL, 0x000fe400078e20ffULL,
0x0000c00056227811ULL, 0x000fe200078e20ffULL, 0x000000002044783bULL, 0x000ee80000004200ULL,
0x000000002138783bULL, 0x000f280000004200ULL, 0x000000002224783bULL, 0x000ea20000004200ULL,
0x0000004000607306ULL, 0x002fe20000009400ULL, 0x00000018ffbf7819ULL, 0x000fe20000011440ULL,
0x0000010040237824ULL, 0x000fe200078e00ffULL, 0x00000018ffa27819ULL, 0x000fe20000011441ULL,
0x0000010043c37824ULL, 0x040fe200078e00ffULL, 0x00000018ff9a7819ULL, 0x000fe20000011443ULL,
0x0001000042c27824ULL, 0x000fe200078e00ffULL, 0x00000018ffa87819ULL, 0x000fe20000011423ULL,
0x0000004000ad7306ULL, 0x000e620000005400ULL, 0x00000018ffc37819ULL, 0x000fe200000114c3ULL,
0x0000010044b07824ULL, 0x048fe200078e00ffULL, 0x00000018ffc27819ULL, 0x000fe200000114c2ULL,
0x0001000043b37824ULL, 0x000fe200078e00ffULL, 0x00000018ff9b7819ULL, 0x000fe20000011442ULL,
0x0001000044b27824ULL, 0x000fe200078e00ffULL, 0x00000018ff897819ULL, 0x010fe20000011438ULL,
0x0000004000797306ULL, 0x000722000000d400ULL, 0x00000018ffb07819ULL, 0x000fe200000114b0ULL,
0x0001000045ab7824ULL, 0x040fe200078e00ffULL, 0x00000018ffb37819ULL, 0x000fe200000114b3ULL,
0x0000010045af7824ULL, 0x000fe200078e00ffULL, 0x00000018ffb27819ULL, 0x000fe200000114b2ULL,
0x00010000468b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff937819ULL, 0x000fe20000011444ULL,
0x000000a800237306ULL, 0x000fe20000209400ULL, 0x0001000040407824ULL, 0x008fe200078e00ffULL,
0x000000ad6000720bULL, 0x002fe20003f7d000ULL, 0x0000010038ad7824ULL, 0x000fe200078e00ffULL,
0x00000018ffab7819ULL, 0x000fe200000114abULL, 0x00010000478c7824ULL, 0x000fe200078e00ffULL,
0x00000018ffbe7819ULL, 0x000fe20000011440ULL, 0x0000010041407824ULL, 0x000fe200078e00ffULL,
0x000000a800ac7306ULL, 0x0002e20000205400ULL, 0x00000018ffaf7819ULL, 0x000fc400000114afULL,
0x00000018ff877819ULL, 0x000fe40000011445ULL, 0x00000018ffc97819ULL, 0x000fe20000011440ULL,
0x0000010042407824ULL, 0x000fe200078e00ffULL, 0x0000000179793812ULL, 0x010fe200078efcffULL,
0x000000be00c57306ULL, 0x000fe20000209400ULL, 0x000000a800a87245ULL, 0x002fe4000020d400ULL,
0x00000018ffcf7819ULL, 0x000fe20000011440ULL, 0x0000010047407824ULL, 0x000fe200078e00ffULL,
0x00000018ff827819ULL, 0x000fc40000011446ULL, 0x00000018ff8b7819ULL, 0x000fe2000001148bULL,
0x000000be00c67306ULL, 0x000e620000205400ULL, 0x000000ac2300720bULL, 0x008fe20003fdd000ULL,
0x0000000855ac7824ULL, 0x000fe200078e00ffULL, 0x0000000253237810ULL, 0x000fe40007ffe0ffULL,
0x00000018ff407819ULL, 0x000fe40000011440ULL, 0xfffffff8ac237812ULL, 0x000fe200078ee223ULL,
0x0000004100c07306ULL, 0x000fe20000009400ULL, 0x000000be00ac7245ULL, 0x000fc4000020d400ULL,
0x00000018ff8c7819ULL, 0x000fe4000001148cULL, 0x00000018ff6c7819ULL, 0x004fe40000011424ULL,
0x00000001a8a86812ULL, 0x000fe200078efcffULL, 0x0000004100bd7306ULL, 0x000ea20000005400ULL,
0x000000c6c500720bULL, 0x002fe40003f1d000ULL, 0x00000018ff807819ULL, 0x000fe40000011447ULL,
0x00000018ffad7819ULL, 0x000fc400000114adULL, 0x00000018ff4b7819ULL, 0x000fe2000001143aULL,
0x0000004100787306ULL, 0x0002e2000000d400ULL, 0x00000018ff687819ULL, 0x000fe40000011425ULL,
0x00000018ff5c7819ULL, 0x000fe40000011426ULL, 0x00000018ff5d7819ULL, 0x000fe40000011427ULL,
0x00000001acac0812ULL, 0x000fe200078efcffULL, 0x000000c900ca7306ULL, 0x000fe20000209400ULL,
0x0001000041417824ULL, 0x002fe200078e00ffULL, 0x000000bdc000720bULL, 0x004fc40003fdd000ULL,
0x000000bf00bd7245ULL, 0x000fe4000020d400ULL, 0x00000018ffcc7819ULL, 0x000fe20000011441ULL,
0x0000010046417824ULL, 0x000fe200078e00ffULL, 0x000000c900cb7306ULL, 0x000e620000205400ULL,
0x00000018ff4e7819ULL, 0x000fc6000001143bULL, 0x00000018ff417819ULL, 0x000fc60000011441ULL,
0x0000000178786812ULL, 0x008fe200078efcffULL, 0x000000bf00c77306ULL, 0x000ff00000209400ULL,
0x000000bf00c87306ULL, 0x0004e20000205400ULL, 0x000000cbca00720bULL, 0x002fce0003fbd000ULL,
0x000000cc00cd7306ULL, 0x000fe20000209400ULL, 0x000000c900bf7245ULL, 0x004fca000020d400ULL,
0x00000001bfbf5812ULL, 0x000fe400078efcffULL, 0x000000cc00ce7306ULL, 0x000e620000205400ULL,
0x000000c8c700720bULL, 0x008fce0003f9d000ULL, 0x000000cf00d07306ULL, 0x000fec0000209400ULL,
0x00000001bdbd4812ULL, 0x000fe400078efcffULL, 0x000000cf00d17306ULL, 0x000ea20000205400ULL,
0x000000cecd00720bULL, 0x002fe40003f1d000ULL, 0x000000acbdac723eULL, 0x000fca00000010ffULL,
0x000000a200a57306ULL, 0x000ff00000209400ULL, 0x000000a200a67306ULL, 0x0002e20000205400ULL,
0x000000d1d000720bULL, 0x004fce0003fbd000ULL, 0x000000c300d47306ULL, 0x000fe20000209400ULL,
0x000000a200a27245ULL, 0x002fce000020d400ULL, 0x000000c300d57306ULL, 0x000e620000205400ULL,
0x000000a6a500720bULL, 0x008fe40003f9d000ULL, 0x000000cc00a57245ULL, 0x000fc8000020d400ULL,
0x00000001a5a50812ULL, 0x000fe200078efcffULL, 0x000000c200d27306ULL, 0x000fec0000209400ULL,
0x00000001a2a24812ULL, 0x000fe400078efcffULL, 0x000000c200d37306ULL, 0x000fe20000205400ULL,
0x000000d5d400720bULL, 0x002fce0003f1d000ULL, 0x0000004400a17306ULL, 0x000ff00000009400ULL,
0x0000004400a07306ULL, 0x000e700000005400ULL, 0x0000003800847306ULL, 0x000ff00000009400ULL,
0x0000003800817306ULL, 0x000fe20000005400ULL, 0x000000a0a100720bULL, 0x002fc40003f9d000ULL,
0x000000c300a17245ULL, 0x000fc8000020d400ULL, 0x00000001a1a10812ULL, 0x000fe200078efcffULL,
0x0000003800657306ULL, 0x0003f0000000d400ULL, 0x0000004300a37306ULL, 0x000fe20000009400ULL,
0x0001000038387824ULL, 0x002fca00078e00ffULL, 0x00000018ffa67819ULL, 0x000fe40000011438ULL,
0x0000004300a47306ULL, 0x000e620000005400ULL, 0x000000cf00387245ULL, 0x000fc8000020d400ULL,
0x0000000138385812ULL, 0x000fe400078efcffULL, 0x000000d3d200720bULL, 0x000fe20003fbd000ULL,
0x0000009a009c7306ULL, 0x000ff00000209400ULL, 0x0000009a009d7306ULL, 0x0004e20000205400ULL,
0x000000a4a300720bULL, 0x002fe20003fdd000ULL, 0x0000010039a47824ULL, 0x000fca00078e00ffULL,
0x00000018ffa07819ULL, 0x000fe200000114a4ULL, 0x000000b000ba7306ULL, 0x000fe20000209400ULL,
0x0000009a009a7245ULL, 0x004fce000020d400ULL, 0x000000b000b57306ULL, 0x0002a20000205400ULL,
0x0000009d9c00720bULL, 0x008fe20003f1d000ULL, 0x00010000399d7824ULL, 0x000fe200078e00ffULL,
0x000000c2009c7245ULL, 0x000fc8000020d400ULL, 0x000000019c9c5812ULL, 0x000fe200078efcffULL,
0x0000004200c17306ULL, 0x000fe20000009400ULL, 0x000000b000b07245ULL, 0x002fe4000020d400ULL,
0x00000018ff9d7819ULL, 0x000fc6000001149dULL, 0x000000019a9a0812ULL, 0x000fe400078efcffULL,
0x0000004200c47306ULL, 0x000e620000005400ULL, 0x000000b5ba00720bULL, 0x004fe20003fbd000ULL,
0x0001000024b57824ULL, 0x000fca00078e00ffULL, 0x00000018ffb57819ULL, 0x000fe200000114b5ULL,
0x0000004300727306ULL, 0x000eac000000d400ULL, 0x00000001b0b05812ULL, 0x000fe400078efcffULL,
0x000000b300d67306ULL, 0x000fe20000209400ULL, 0x000000c4c100720bULL, 0x002fce0003f7d000ULL,
0x000000b300d77306ULL, 0x0002e20000205400ULL, 0x0000000172726812ULL, 0x004fce00078efcffULL,
0x0000004200737306ULL, 0x000ea2000000d400ULL, 0x000000b300b37245ULL, 0x002fce000020d400ULL,
0x000000b200b67306ULL, 0x000fe20000209400ULL, 0x000000d7d600720bULL, 0x008fce0003fdd000ULL,
0x000000b200bb7306ULL, 0x0002e20000205400ULL, 0x0000000173733812ULL, 0x004fc800078efcffULL,
0x000000733838723eULL, 0x000fe400000010ffULL, 0x00000001b3b36812ULL, 0x000fe200078efcffULL,
0x0000009b009e7306ULL, 0x000fe20000209400ULL, 0x000000b200b27245ULL, 0x002fce000020d400ULL,
0x0000009b009f7306ULL, 0x0002a20000205400ULL, 0x000000bbb600720bULL, 0x008fe20003fbd000ULL,
0x0000010025b67824ULL, 0x000fca00078e00ffULL, 0x00000018ffb67819ULL, 0x000fe200000114b6ULL,
0x0000004500987306ULL, 0x000fe20000009400ULL, 0x0000009b009b7245ULL, 0x002fca000020d400ULL,
0x00000001b2b25812ULL, 0x000fe400078efcffULL, 0x0000004500997306ULL, 0x000e620000005400ULL,
0x0000009f9e00720bULL, 0x004fce0003f7d000ULL, 0x0000004400717306ULL, 0x000eac000000d400ULL,
0x000000019b9b3812ULL, 0x000fe400078efcffULL, 0x0000009300947306ULL, 0x000fe20000209400ULL,
0x000000999800720bULL, 0x002fe20003fdd000ULL, 0x000001003a987824ULL, 0x000fe200078e00ffULL,
0x0000009c9b9c723eULL, 0x000fc800000010ffULL, 0x00000018ff987819ULL, 0x000fe20000011498ULL,
0x0000009300977306ULL, 0x0002e20000205400ULL, 0x0000000171714812ULL, 0x004fce00078efcffULL,
0x000000ab00b17306ULL, 0x000fe20000209400ULL, 0x0000009300937245ULL, 0x002fce000020d400ULL,
0x000000ab00b47306ULL, 0x0002a20000205400ULL, 0x000000979400720bULL, 0x008fe40003f9d000ULL,
0x0000008700947245ULL, 0x000fca000020d400ULL, 0x000000af00b97306ULL, 0x000fe20000209400ULL,
0x000000ab00ab7245ULL, 0x002fca000020d400ULL, 0x0000000193934812ULL, 0x000fe400078efcffULL,
0x000000af00bc7306ULL, 0x000e620000205400ULL, 0x000000b4b100720bULL, 0x004fe20003fbd000ULL,
0x0000010024b17824ULL, 0x000fca00078e00ffULL, 0x00000018ffb17819ULL, 0x000fe200000114b1ULL,
0x00000045006f7306ULL, 0x000eac000000d400ULL, 0x00000001abab5812ULL, 0x000fe400078efcffULL,
0x0000008700917306ULL, 0x000fe20000209400ULL, 0x000000bcb900720bULL, 0x002fce0003f7d000ULL,
0x0000008700907306ULL, 0x000e620000205400ULL, 0x000000016f6f6812ULL, 0x004fce00078efcffULL,
0x0000004600967306ULL, 0x000ff00000009400ULL, 0x0000004600957306ULL, 0x000ea20000005400ULL,
0x000000909100720bULL, 0x002fe20003fdd000ULL, 0x0000010026917824ULL, 0x000fc400078e00ffULL,
0x0000010027907824ULL, 0x000fc600078e00ffULL, 0x00000018ff917819ULL, 0x000fe20000011491ULL,
0x0000004100b77306ULL, 0x000fe20000209400ULL, 0x00000018ff907819ULL, 0x000fca0000011490ULL,
0x0000000194946812ULL, 0x000fe400078efcffULL, 0x0000004100b87306ULL, 0x000e620000205400ULL,
0x000000959600720bULL, 0x004fe40003f1d000ULL, 0x000000af00967245ULL, 0x000fe2000020d400ULL,
0x000100003baf7824ULL, 0x000fe200078e00ffULL, 0x000000ab94ab723eULL, 0x000fe400000010ffULL,
0x0000000196963812ULL, 0x000fe200078efcffULL, 0x0000004000a97306ULL, 0x000fe20000209400ULL,
0x00000018ffaf7819ULL, 0x000fce00000114afULL, 0x0000004000ae7306ULL, 0x000ea20000205400ULL,
0x000000b8b700720bULL, 0x002fe20003f9d000ULL, 0x0001000025b77824ULL, 0x000fca00078e00ffULL,
0x00000018ffb77819ULL, 0x000fe200000114b7ULL, 0x00000047008f7306ULL, 0x000ff00000009400ULL,
0x0000004700927306ULL, 0x000e620000005400ULL, 0x000000aea900720bULL, 0x004fce0003fbd000ULL,
0x0000008200857306ULL, 0x000ff00000209400ULL, 0x0000008200887306ULL, 0x0004e20000205400ULL,
0x000000928f00720bULL, 0x002fe20003f7d000ULL, 0x000100003a927824ULL, 0x000fc400078e00ffULL,
0x000001003b8f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff877819ULL, 0x000fe20000011492ULL,
0x0000008b00437306ULL, 0x000fe20000209400ULL, 0x0000004100927245ULL, 0x000fe4000020d400ULL,
0x00000018ff997819ULL, 0x000fe2000001148fULL, 0x00010000268f7824ULL, 0x000fe200078e00ffULL,
0x0000000192924812ULL, 0x000fe400078efcffULL, 0x0000008200827245ULL, 0x004fe2000020d400ULL,
0x0000008b00aa7306ULL, 0x0002a20000205400ULL, 0x000000888500720bULL, 0x008fc40003fdd000ULL,
0x0000004000857245ULL, 0x000fe4000020d400ULL, 0x00000018ff8f7819ULL, 0x000fe4000001148fULL,
0x0000000185855812ULL, 0x000fe200078efcffULL, 0x0000008c00a77306ULL, 0x000fe20000209400ULL,
0x0000008b008b7245ULL, 0x002fca000020d400ULL, 0x0000000182826812ULL, 0x000fe400078efcffULL,
0x0000008c00427306ULL, 0x000e620000205400ULL, 0x000000aa4300720bULL, 0x004fe40003f9d000ULL,
0x000000b293aa723eULL, 0x000fca00000010ffULL, 0x0000002400777306ULL, 0x000fec0000009400ULL,
0x000000018b8b4812ULL, 0x000fe400078efcffULL, 0x0000002400767306ULL, 0x000fe20000005400ULL,
0x00000042a700720bULL, 0x002fe40003fbd000ULL, 0x000000818400720bULL, 0x000fc40003f9d000ULL,
0x0000008b8282723eULL, 0x000fc600000010ffULL, 0x00000024005e7306ULL, 0x0003f0000000d400ULL,
0x0000004600497306ULL, 0x0004e2000000d400ULL, 0x0000000855247824ULL, 0x002fe200078e00ffULL,
0x0000000165654812ULL, 0x000fc800078efcffULL, 0xfffffff824247812ULL, 0x000fe400078ee253ULL,
0x0000008000867306ULL, 0x000fe20000209400ULL, 0x00000018ff467819ULL, 0x004fe40000011439ULL,
0x0000a00024417811ULL, 0x000fca00078e20ffULL, 0x0000008000837306ULL, 0x000e620000205400ULL,
0x000000004140783bULL, 0x000ea20000000200ULL, 0x0000000149490812ULL, 0x008fcc00078efcffULL,
0x00000039007f7306ULL, 0x000ff00000009400ULL, 0x00000039007e7306ULL, 0x000ee20000005400ULL,
0x000000838600720bULL, 0x002fe40003f1d000ULL, 0x0000008000867245ULL, 0x000fc4000020d400ULL,
0x0000008c00837245ULL, 0x000fe4000020d400ULL, 0x000000ad00807245ULL, 0x000fe2000020d400ULL,
0x0000004700487306ULL, 0x000e62000000d400ULL, 0x0000000183835812ULL, 0x000fca00078efcffULL,
0x0000000186860812ULL, 0x000fe400078efcffULL, 0x0000003900647306ULL, 0x000f22000000d400ULL,
0x0000007e7f00720bULL, 0x008fe40003f1d000ULL, 0x000000838683723eULL, 0x000fca00000010ffULL,
0x0000003a007d7306ULL, 0x000fe20000009400ULL, 0x0000000148483812ULL, 0x002fe200078efcffULL,
0x0000001d4040a231ULL, 0x084fe400003400ffULL, 0x0000001d4242a231ULL, 0x000fe200003400ffULL,
0x000000488585723eULL, 0x000fe200000010ffULL, 0x0000001c4141a231ULL, 0x080fe400003400ffULL,
0x0000003a007c7306ULL, 0x000e620000005400ULL, 0x0000000164640812ULL, 0x010fe200078efcffULL,
0x0000001c4343a231ULL, 0x000fcc00003400ffULL, 0x0000003a00627306ULL, 0x000eb0000000d400ULL,
0x000000ad00be7306ULL, 0x000fe20000209400ULL, 0x0000007c7d00720bULL, 0x002fce0003f9d000ULL,
0x000000ad00c17306ULL, 0x0002ec0000205400ULL, 0x0000000162624812ULL, 0x004fe400078efcffULL,
0x0000009800977306ULL, 0x000fe20000209400ULL, 0x000000a5a2ad723eULL, 0x002fce00000010ffULL,
0x00000098003a7306ULL, 0x000e620000205400ULL, 0x000000c1be00720bULL, 0x008fe20003f7d000ULL,
0x000000ac4034723cULL, 0x000fec0000041834ULL, 0x00000089008d7306ULL, 0x000fec0000209400ULL,
0x0000000180803812ULL, 0x000fc400078efcffULL, 0x00000089008e7306ULL, 0x0004e20000205400ULL,
0x0000003a9700720bULL, 0x002fce0003f1d000ULL, 0x000000a000a47306ULL, 0x000fe20000209400ULL,
0x0000008900897245ULL, 0x004fce000020d400ULL, 0x000000a000397306ULL, 0x000e620000205400ULL,
0x0000008e8d00720bULL, 0x008fce0003fbd000ULL, 0x00000099009f7306ULL, 0x000fec0000209400ULL,
0x0000000189895812ULL, 0x000fe400078efcffULL, 0x0000009900b47306ULL, 0x000ea20000205400ULL,
0x00000039a400720bULL, 0x002fe40003f7d000ULL, 0x00000072a139723eULL, 0x000fc400000010ffULL,
0x0000009900727245ULL, 0x000fc6000020d400ULL, 0x0000002500747306ULL, 0x000fe40000009400ULL,
0x000000384030723cULL, 0x000bec0000041830ULL, 0x0000002500757306ULL, 0x000fe20000005400ULL,
0x0000a00023387811ULL, 0x020fce00078e20ffULL, 0x00000025005f7306ULL, 0x0003f0000000d400ULL,
0x00000026004d7306ULL, 0x000fe20000009400ULL, 0x0001000027257824ULL, 0x002fca00078e00ffULL,
0x00000018ff257819ULL, 0x000fe40000011425ULL, 0x00000026004c7306ULL, 0x000ff00000005400ULL,
0x00000026005a7306ULL, 0x0003f0000000d400ULL, 0x00000027006b7306ULL, 0x000fe20000009400ULL,
0x00000079a826723eULL, 0x002fce00000010ffULL, 0x00000027006e7306ULL, 0x000ff00000005400ULL,
0x00000027005b7306ULL, 0x0003f0000000d400ULL, 0x000000a600c07306ULL, 0x000fe20000209400ULL,
0x00000078bf27723eULL, 0x002fc400000010ffULL, 0x0000009d00787245ULL, 0x000fca000020d400ULL,
0x000000a600a37306ULL, 0x0002e20000205400ULL, 0x00000026403c723cULL, 0x000b6e000004183cULL,
0x0000004b00447306ULL, 0x000fe20000209400ULL, 0x0000009800277245ULL, 0x020fe4000020d400ULL,
0x000000a600a67245ULL, 0x002fc4000020d400ULL, 0x0000000127270812ULL, 0x000fe400078efcffULL,
0x000000b49f00720bULL, 0x004fe20003f1d000ULL, 0x0000004b00457306ULL, 0x000e620000205400ULL,
0x000000a3c000720bULL, 0x008fe40003fdd000ULL, 0x0000004b00267245ULL, 0x000fca000020d400ULL,
0x0000009d009e7306ULL, 0x000fe80000209400ULL, 0x0000000172720812ULL, 0x000fe400078efcffULL,
0x00000001a6a66812ULL, 0x000fe400078efcffULL, 0x0000009d00957306ULL, 0x0004e20000205400ULL,
0x000000454400720bULL, 0x002fe40003f9d000ULL, 0x00000071b044723eULL, 0x000fc400000010ffULL,
0x0000006f9645723eULL, 0x000fc600000010ffULL, 0x0000003b007a7306ULL, 0x000fe20000009400ULL,
0x000000b39a9d723eULL, 0x004fca00000010ffULL, 0x0000000126264812ULL, 0x000fe400078efcffULL,
0x0000003b007b7306ULL, 0x000e620000005400ULL, 0x000000959e00720bULL, 0x008fe20003fbd000ULL,
0x0000009c402c723cULL, 0x000f6c000004182cULL, 0x0000003b00637306ULL, 0x000eac000000d400ULL,
0x0000000178785812ULL, 0x000fc400078efcffULL, 0x00000087003b7306ULL, 0x000fe20000209400ULL,
0x0000007b7a00720bULL, 0x002fe40003fdd000ULL, 0x000000767700720bULL, 0x000fe40003fbd000ULL,
0x000000a0007b7245ULL, 0x000fe4000020d400ULL, 0x0000004600777245ULL, 0x000fe2000020d400ULL,
0x0000008700887306ULL, 0x0002e20000205400ULL, 0x000000017b7b3812ULL, 0x000fca00078efcffULL,
0x0000000163636812ULL, 0x004fe400078efcffULL, 0x000000b1007e7306ULL, 0x000fe20000209400ULL,
0x0000008700877245ULL, 0x002fe4000020d400ULL, 0x000000015e5e5812ULL, 0x000fca00078efcffULL,
0x000000b1007d7306ULL, 0x0002a20000205400ULL, 0x000000883b00720bULL, 0x008fe40003f1d000ULL,
0x000000003838783bULL, 0x000eea0000000200ULL, 0x000000b6007a7306ULL, 0x000fe20000209400ULL,
0x000000b100b17245ULL, 0x002fca000020d400ULL, 0x0000000187870812ULL, 0x000fe400078efcffULL,
0x000000b600797306ULL, 0x0003220000205400ULL, 0x0000007d7e00720bULL, 0x004fce0003f9d000ULL,
0x0000004600477306ULL, 0x000fe20000209400ULL, 0x000000b600b67245ULL, 0x002fca000020d400ULL,
0x00000001b1b14812ULL, 0x000fe400078efcffULL, 0x00000046008a7306ULL, 0x000e620000205400ULL,
0x000000797a00720bULL, 0x010fe40003f9d000ULL, 0x0000005eb15e723eULL, 0x000fca00000010ffULL,
0x0000004e004a7306ULL, 0x000fe20000209400ULL, 0x0000001d3838a231ULL, 0x088fe400003400ffULL,
0x0000001d3a3aa231ULL, 0x000fc600003400ffULL, 0x00000001b6b64812ULL, 0x000fe200078efcffULL,
0x0000001c3939a231ULL, 0x080fe200003400ffULL, 0x0000004e004f7306ULL, 0x000ea20000205400ULL,
0x0000008a4700720bULL, 0x002fe20003f7d000ULL, 0x0000001c3b3ba231ULL, 0x000fe200003400ffULL,
0x000000444044723cULL, 0x000b6a0000041828ULL, 0x000000b500767306ULL, 0x000fe40000209400ULL,
0x0000004e002a7245ULL, 0x020fc4000020d400ULL, 0x000000af00297245ULL, 0x000fe4000020d400ULL,
0x0000000177773812ULL, 0x000fe400078efcffULL, 0x000000b500737306ULL, 0x0002e20000205400ULL,
0x0000004f4a00720bULL, 0x004fe40003f1d000ULL, 0x000000757400720bULL, 0x000fca0003f7d000ULL,
0x000000af00a77306ULL, 0x000fe20000209400ULL, 0x000000b500b57245ULL, 0x002fca000020d400ULL,
0x000000012a2a0812ULL, 0x000fe400078efcffULL, 0x000000af00847306ULL, 0x000e620000205400ULL,
0x000000737600720bULL, 0x008fe40003fbd000ULL, 0x0000006e6b00720bULL, 0x000fe40003f1d000ULL,
0x000000015f5f3812ULL, 0x000fc600078efcffULL, 0x0000006c00707306ULL, 0x000fe20000209400ULL,
0x0000005fb65f723eULL, 0x000fca00000010ffULL, 0x00000001b5b55812ULL, 0x000fe400078efcffULL,
0x0000006c006d7306ULL, 0x0004e20000205400ULL, 0x00000084a700720bULL, 0x002fe40003fdd000ULL,
0x000000499284723eULL, 0x000fe400000010ffULL, 0x000000aa4048723cULL, 0x000b620000041808ULL,
0x000000015b5b0812ULL, 0x000fe400078efcffULL, 0x0000006800697306ULL, 0x000fe20000209400ULL,
0x0000006c006c7245ULL, 0x004fc6000020d400ULL, 0x000000a68908723eULL, 0x020fe400000010ffULL,
0x0000000129296812ULL, 0x000fe400078efcffULL, 0x00000068006a7306ULL, 0x0002a20000205400ULL,
0x0000006d7000720bULL, 0x008fe40003f9d000ULL, 0x0000004c4d00720bULL, 0x000fe40003fdd000ULL,
0x00000084404c723cULL, 0x000b620000041804ULL, 0x000000787709723eULL, 0x000fc400000010ffULL,
0x0000009100287306ULL, 0x000fe20000209400ULL, 0x0000006800687245ULL, 0x002fe4000020d400ULL,
0x000000292a29723eULL, 0x000fe400000010ffULL, 0x000000658004723eULL, 0x020fe200000010ffULL,
0x000000824040723cULL, 0x000b62000004180cULL, 0x000000647b05723eULL, 0x000fe200000010ffULL,
0x00000091002b7306ULL, 0x0002e20000205400ULL, 0x0000006a6900720bULL, 0x004fe40003fbd000ULL,
0x000000016c6c4812ULL, 0x000fc400078efcffULL, 0x00000062270c723eULL, 0x020fe200000010ffULL,
0x000000043804723cULL, 0x000f62000004183cULL, 0x000000015a5a6812ULL, 0x000fe200078efcffULL,
0x000000b700747306ULL, 0x000fe20000209400ULL, 0x0000009100917245ULL, 0x002fe4000020d400ULL,
0x00000063720d723eULL, 0x000fc600000010ffULL, 0x0000000168685812ULL, 0x000fe200078efcffULL,
0x000000083808723cULL, 0x000f620000041834ULL, 0x000000b7006f7306ULL, 0x0002a20000205400ULL,
0x0000002b2800720bULL, 0x008fe40003f9d000ULL, 0x000000872628723eULL, 0x000fc800000010ffULL,
0x0000000c380c723cULL, 0x000b620000041830ULL, 0x0000009000717306ULL, 0x000fe20000209400ULL,
0x000000b700b77245ULL, 0x002fca000020d400ULL, 0x0000000191914812ULL, 0x000fe200078efcffULL,
0x000000283828723cULL, 0x040b62000004182cULL, 0x00000090006e7306ULL, 0x0002e20000205400ULL,
0x0000006f7400720bULL, 0x004fe40003f7d000ULL, 0x000000b56c30723eULL, 0x020fe400000010ffULL,
0x0000005a9134723eULL, 0x000fe400000010ffULL, 0x0000005e382c723cULL, 0x000b620000041844ULL,
0x0000005c00677306ULL, 0x000fe20000209400ULL, 0x0000009000907245ULL, 0x002fca000020d400ULL,
0x00000001b7b73812ULL, 0x000fe400078efcffULL, 0x0000005c00667306ULL, 0x0002a20000205400ULL,
0x0000006e7100720bULL, 0x008fe40003fbd000ULL, 0x000000b76831723eULL, 0x000fca00000010ffULL,
0x0000005d00617306ULL, 0x000fe20000209400ULL, 0x0000005c005c7245ULL, 0x002fe2000020d400ULL,
0x000000303830723cULL, 0x000b680000041848ULL, 0x0000000190905812ULL, 0x000fe400078efcffULL,
0x0000005d00607306ULL, 0x000e620000205400ULL, 0x000000666700720bULL, 0x004fe40003f7d000ULL,
0x0000005b9035723eULL, 0x000fca00000010ffULL, 0x0000008f00647306ULL, 0x000fe40000209400ULL,
0x000000343834723cULL, 0x000b68000004184cULL, 0x000000015c5c3812ULL, 0x000fe400078efcffULL,
0x0000008f003d7306ULL, 0x0004e20000205400ULL, 0x000000606100720bULL, 0x002fce0003f9d000ULL,
0x0000002500277306ULL, 0x000fe20000209400ULL, 0x0000008f008f7245ULL, 0x004fce000020d400ULL,
0x0000002500267306ULL, 0x000e620000205400ULL, 0x0000003d6400720bULL, 0x008fda0003fdd000ULL,
0x000000018f8f6812ULL, 0x000fe400078efcffULL, 0x000000262700720bULL, 0x002fe40003fbd000ULL,
0x0000005d00267245ULL, 0x000fe4000020d400ULL, 0x00000025005d7245ULL, 0x000fe4000020d400ULL,
0x0000000126264812ULL, 0x000fe400078efcffULL, 0x0000008f5c5c723eULL, 0x000fca00000010ffULL,
0x000000015d5d5812ULL, 0x000fc800078efcffULL, 0x0000005d265d723eULL, 0x000fce00000010ffULL,
0x0000005c3840723cULL, 0x000b620000041840ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff3a7f8cULL, 0x020e62000c80043fULL, 0x000000ffff3c7224ULL, 0x000fce00078e00ffULL,
0x0000000000267805ULL, 0x000fc40000015200ULL, 0x0106bc00ff257984ULL, 0x000ea40000000800ULL,
0x8000000025ff7812ULL, 0x006fe4000780483bULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fcc0000015200ULL, 0x0000003826387210ULL, 0x000fca0007f1e1ffULL,
0x0000000139397824ULL, 0x000fe200000e0e27ULL, 0x003d09003800780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403800780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff257819ULL, 0x000fc80000011439ULL,
0x0000003825257211ULL, 0x000fca00078110ffULL, 0x000000ffff387224ULL, 0x000fca00000e0639ULL,
0x0000000225257819ULL, 0x000fc80000001238ULL, 0x000000250000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106bc00ff257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe4000780483bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002014387810ULL, 0x000fca0007ffe0ffULL, 0x00006200123a7a24ULL, 0x000fe200078e0238ULL,
0x0000039000009947ULL, 0x000fea0003800000ULL, 0x0000000111277824ULL, 0x000fe200078e021eULL,
0x000000041e467810ULL, 0x040fe20007ffe0ffULL, 0x00000100ff3b7424ULL, 0x000fe200078e00ffULL,
0x0000003803257217ULL, 0x000fe20007800000ULL, 0x0000000127267824ULL, 0x040fe200078e0202ULL,
0x000000021e447810ULL, 0x000fe20007ffe0ffULL, 0x0000001027397824ULL, 0x000fe200078e00ffULL,
0x000000f0163f7812ULL, 0x000fe200078ec0ffULL, 0x00000001113d7824ULL, 0x000fe400078e0246ULL,
0x0000000125387824ULL, 0x000fe200078e0a38ULL, 0xfffffff0393e7812ULL, 0x000fe200078ee226ULL,
0x0000000127267824ULL, 0x000fc400078e023aULL, 0x0000000111257824ULL, 0x040fe200078e0244ULL,
0x0000003811387217ULL, 0x000fe20007800000ULL, 0x000000013d3c7824ULL, 0x040fe400078e0202ULL,
0x000000103d477824ULL, 0x000fe400078e00ffULL, 0x00005e0026267625ULL, 0x000fc600078e003bULL,
0xfffffff047477812ULL, 0x000fe200078ee23cULL, 0x0000000125397824ULL, 0x040fe200078e0202ULL,
0x0000003f263c7210ULL, 0x000fe20007f1e0ffULL, 0x0000001025487824ULL, 0x000fe200078e00ffULL,
0x0000c00047477811ULL, 0x000fe200078e20ffULL, 0x0000000125267824ULL, 0x100fe400078e023aULL,
0x0000000138257824ULL, 0x000fe200078e0a11ULL, 0xfffffff048457812ULL, 0x000fe200078ee239ULL,
0x000000013d397824ULL, 0x000fe200078e023aULL, 0x000000061e487810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fe200000e0627ULL, 0x000000254400720cULL, 0x000fe20003f66070ULL,
0x00005e0026267625ULL, 0x000fe200078e003bULL, 0x000000251e00720cULL, 0x000fc40003f86070ULL,
0x000000254600720cULL, 0x000fe20003f06070ULL, 0x0000000111497824ULL, 0x000fe200078e0248ULL,
0x0000003f26267210ULL, 0x000fe20007fbe0ffULL, 0x00005e0039387625ULL, 0x000fe200078e003bULL,
0x0000c00045457811ULL, 0x000fc600078e20ffULL, 0x00000001493a7824ULL, 0x040fe200078e023aULL,
0x0000003f38387210ULL, 0x000fe20007fde0ffULL, 0x0000000149447824ULL, 0x000fe400078e0202ULL,
0x00005e003a3a7625ULL, 0x000fc800078e003bULL, 0x000000ffff277224ULL, 0x000fe200028e0627ULL,
0x000000254800720cULL, 0x000fe20003fa6070ULL, 0x0000001049497824ULL, 0x000fe200078e00ffULL,
0x0000c0003e257811ULL, 0x000fe200078e20ffULL, 0x000000ffff397224ULL, 0x000fe200030e0639ULL,
0x0000003f3a3a7210ULL, 0x000fe40007fde0ffULL, 0xfffffff049447812ULL, 0x000fe200078ee244ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c257faeULL, 0x0003e4000e101c46ULL,
0x000000ffff3b7224ULL, 0x000fe200030e063bULL, 0x0000c000443f7811ULL, 0x000fe200078e20ffULL,
0x0000000026457faeULL, 0x0003e8000d901c46ULL, 0x0000000038477faeULL, 0x0003e8000c101c46ULL,
0x000000003a3f7faeULL, 0x0003e2000e901c46ULL, 0x000002d000007947ULL, 0x000fea0003800000ULL,
0x0000000111397824ULL, 0x000fe200078e021eULL, 0x000000f016457812ULL, 0x000fc600078ec0ffULL,
0x00000001393b7824ULL, 0x040fe200078e0202ULL, 0x0000000239257810ULL, 0x040fe20007ffe0ffULL,
0x0000001039467824ULL, 0x040fe200078e00ffULL, 0x0000000439277810ULL, 0x040fe20007ffe0ffULL,
0x00000001393c7824ULL, 0x040fe200078e023aULL, 0x0000000639397810ULL, 0x000fe20007ffe0ffULL,
0x0000000125267824ULL, 0x140fe200078e0202ULL, 0xfffffff046467812ULL, 0x000fe200078ee23bULL,
0x00000010253d7824ULL, 0x000fe400078e00ffULL, 0x0000000127387824ULL, 0x040fe200078e0202ULL,
0x0000c00046477811ULL, 0x000fe200078e20ffULL, 0x00000010273f7824ULL, 0x000fe200078e00ffULL,
0xfffffff03d3e7812ULL, 0x000fe200078ee226ULL, 0x00000100ff3b7424ULL, 0x000fc400078e00ffULL,
0x000000013a267824ULL, 0x000fe200078e0225ULL, 0xfffffff03f3f7812ULL, 0x000fe200078ee238ULL,
0x00005e003c3c7625ULL, 0x000fc600078e003bULL, 0x0000c0003f3f7811ULL, 0x000fe200078e20ffULL,
0x000000013a387824ULL, 0x000fe200078e0227ULL, 0x000000453c3c7210ULL, 0x000fe20007f7e0ffULL,
0x000000013a3a7824ULL, 0x000fe400078e0239ULL, 0x0000000139257824ULL, 0x040fe400078e0202ULL,
0x0000001039447824ULL, 0x000fe400078e00ffULL, 0x00005e0026267625ULL, 0x000fc600078e003bULL,
0xfffffff044447812ULL, 0x000fe200078ee225ULL, 0x00005e0038387625ULL, 0x000fe200078e003bULL,
0x0000004526267210ULL, 0x000fe40007f1e0ffULL, 0x0000c0003e257811ULL, 0x000fe200078e20ffULL,
0x00005e003a3a7625ULL, 0x000fc800078e003bULL, 0x000000ffff3d7224ULL, 0x000fe200018e063dULL,
0x0000004538387210ULL, 0x080fe20007f7e0ffULL, 0x000000ffff277224ULL, 0x000fe200000e0627ULL,
0x000000453a3a7210ULL, 0x000fe40007f9e0ffULL, 0x0000c00044457811ULL, 0x000fe200078e20ffULL,
0x000000ffff397224ULL, 0x000fe200018e0639ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c477faeULL, 0x0003e2000b901c46ULL, 0x000000ffff3b7224ULL, 0x000fc600020e063bULL,
0x0000000026257faeULL, 0x0003e8000b901c46ULL, 0x00000000383f7faeULL, 0x0003e8000b901c46ULL,
0x000000003a457faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff3a7f8cULL, 0x000e64000c80043fULL,
0x0000000000267805ULL, 0x000fc40000015200ULL, 0x0106b400ff257984ULL, 0x000ea40000000800ULL,
0x8000000025ff7812ULL, 0x004fc40007804851ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff3a7224ULL, 0x002fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fcc0000015200ULL,
0x0000003826387210ULL, 0x000fca0007f1e1ffULL, 0x0000000139397824ULL, 0x000fe200000e0e27ULL,
0x003d09003800780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403800780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc80000011439ULL, 0x0000003825257211ULL, 0x000fca00078110ffULL,
0x000000ffff387224ULL, 0x000fca00000e0639ULL, 0x0000000225257819ULL, 0x000fc80000001238ULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013a3a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106b400ff257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe40007804851ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000014000007945ULL, 0x000fe20003800000ULL,
0x0000012000002947ULL, 0x000fea0003800000ULL, 0x0000001bff1c723eULL, 0x000fe400000010ffULL,
0x00000002ff267819ULL, 0x000fe40000011602ULL, 0x000054101c257816ULL, 0x000fe2000000001cULL,
0x0001a0b27f007947ULL, 0x000fea000b800000ULL, 0x00001f26251d7589ULL, 0x0002a400000e0000ULL,
0x00000008265b7810ULL, 0x002fe20007ffe0ffULL, 0x0001a0e27f007947ULL, 0x000fea000b800000ULL,
0x00001f5b251c7589ULL, 0x0002e400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000010265b7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff5a7224ULL, 0x000fe200078e0025ULL,
0x000050a000447802ULL, 0x000fc40000000f00ULL, 0x0001ad6000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000018265b7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff5a7224ULL, 0x004fe200078e0025ULL, 0x000050f000447802ULL, 0x000fc40000000f00ULL,
0x0001ad1000007944ULL, 0x008fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000154597824ULL, 0x040fe200078e0259ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000001054267824ULL, 0x000fe200078e00ffULL, 0x0000e00056277811ULL, 0x000fe200078e20ffULL,
0x0000000154577824ULL, 0x040fe200078e0257ULL, 0x00000006533a7810ULL, 0x000fe20007ffe0ffULL,
0x0000001054547824ULL, 0x000fe200078e00ffULL, 0xfffffff026267812ULL, 0x000fe200078ee259ULL,
0x000000002744783bULL, 0x000f220000004200ULL, 0x0000000855da7824ULL, 0x000fe200078e00ffULL,
0x0000000453397810ULL, 0x000fe20007ffe0ffULL, 0x0000000855557824ULL, 0x000fe200078e00ffULL,
0x0000e00026267811ULL, 0x000fc400078e20ffULL, 0xfffffff054257812ULL, 0x002fe400078ee257ULL,
0xfffffff8553a7812ULL, 0x000fe200078ee23aULL, 0x00000000264c783bULL, 0x000e620000004200ULL,
0x0000e00025257811ULL, 0x000fe400078e20ffULL, 0xfffffff8da397812ULL, 0x000fe400078ee239ULL,
0x0000e00058387811ULL, 0x000fe200078e20ffULL, 0x000000002548783bULL, 0x000ee80000004200ULL,
0x00000000383c783bULL, 0x000ea20000004200ULL, 0x0000004500897306ULL, 0x010fe20000009400ULL,
0x00000018ff5d7819ULL, 0x000fc40000011445ULL, 0x00000018ff517819ULL, 0x000fe40000011446ULL,
0x00000018ff507819ULL, 0x000fe40000011447ULL, 0x00000018ff637819ULL, 0x000fe20000011444ULL,
0x0000004500847306ULL, 0x000fe20000005400ULL, 0x000001004cca7824ULL, 0x002fe200078e00ffULL,
0x00000018ffc07819ULL, 0x000fe2000001144cULL, 0x000001004dc57824ULL, 0x040fe200078e00ffULL,
0x00000018ffb37819ULL, 0x000fe2000001144eULL, 0x000001004ec47824ULL, 0x000fe200078e00ffULL,
0x00000018ffca7819ULL, 0x000fe200000114caULL, 0x000100004cce7824ULL, 0x000fe200078e00ffULL,
0x00000018ffc57819ULL, 0x000fe200000114c5ULL, 0x0000004d00bd7306ULL, 0x000fe20000009400ULL,
0x00000018ffc47819ULL, 0x000fe200000114c4ULL, 0x000100004dc77824ULL, 0x000fe200078e00ffULL,
0x000000ca00557245ULL, 0x000fe2000020d400ULL, 0x000001004fc37824ULL, 0x040fe200078e00ffULL,
0x00000018ffce7819ULL, 0x000fe200000114ceULL, 0x000100004fc67824ULL, 0x000fe200078e00ffULL,
0x00000018ffc77819ULL, 0x000fe200000114c7ULL, 0x000000ca00e07306ULL, 0x000fe20000209400ULL,
0x00000018ffb07819ULL, 0x000fe2000001144fULL, 0x000100004ec87824ULL, 0x000fe200078e00ffULL,
0x00000018ffba7819ULL, 0x000fe2000001144dULL, 0x0001000049537824ULL, 0x008fe200078e00ffULL,
0x00000018ffc37819ULL, 0x000fe200000114c3ULL, 0x000001004ae27824ULL, 0x040fe200078e00ffULL,
0x00000018ffc87819ULL, 0x000fe200000114c8ULL, 0x000000ca00e17306ULL, 0x000e620000205400ULL,
0x00000018ffa67819ULL, 0x000fe20000011449ULL, 0x000100004adb7824ULL, 0x000fe200078e00ffULL,
0x00000018ff9f7819ULL, 0x000fe2000001144aULL, 0x0001000048d57824ULL, 0x000fe200078e00ffULL,
0x00000018ffab7819ULL, 0x000fe20000011448ULL, 0x000001004be47824ULL, 0x040fe200078e00ffULL,
0x00000018ffc67819ULL, 0x000fe200000114c6ULL, 0x000000c500d87306ULL, 0x000fe20000209400ULL,
0x00000018ffd57819ULL, 0x000fe200000114d5ULL, 0x000100004bd77824ULL, 0x000fe200078e00ffULL,
0x00000018ff9d7819ULL, 0x000fe2000001144bULL, 0x000001003c8f7824ULL, 0x004fe200078e00ffULL,
0x00000018ffe27819ULL, 0x000fe200000114e2ULL, 0x000001003e917824ULL, 0x000fe200078e00ffULL,
0x00000018ffd77819ULL, 0x000fe200000114d7ULL, 0x000000c500dd7306ULL, 0x000ea20000205400ULL,
0x000000e1e000720bULL, 0x002fe20003fdd000ULL, 0x000100003e727824ULL, 0x000fe200078e00ffULL,
0x00000018ffe47819ULL, 0x000fe200000114e4ULL, 0x000100003c947824ULL, 0x000fe200078e00ffULL,
0x00000018ffdb7819ULL, 0x000fe200000114dbULL, 0x000001003d967824ULL, 0x040fe200078e00ffULL,
0x00000018ff6e7819ULL, 0x000fe2000001143eULL, 0x0000004d00bc7306ULL, 0x000e620000005400ULL,
0x00000018ff8f7819ULL, 0x000fe2000001148fULL, 0x000100003d987824ULL, 0x000fe200078e00ffULL,
0x00000018ff8a7819ULL, 0x000fe2000001143cULL, 0x000001003f7a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff7b7819ULL, 0x000fc4000001143dULL, 0x0000000155556812ULL, 0x000fe200078efcffULL,
0x0000004c00de7306ULL, 0x000fe20000009400ULL, 0x000000ddd800720bULL, 0x004fe40003fbd000ULL,
0x00000018ff917819ULL, 0x000fe40000011491ULL, 0x00000018ff6a7819ULL, 0x000fe4000001143fULL,
0x00000018ff947819ULL, 0x000fe20000011494ULL, 0x0000004c00717306ULL, 0x000ea20000005400ULL,
0x000000bcbd00720bULL, 0x002fc40003fdd000ULL, 0x000000c500bc7245ULL, 0x000fe4000020d400ULL,
0x000000c000bd7245ULL, 0x000fe4000020d400ULL, 0x00000001bcbc5812ULL, 0x000fe200078efcffULL,
0x000000c400cc7306ULL, 0x000fe20000209400ULL, 0x00000018ff7a7819ULL, 0x000fe4000001147aULL,
0x00000018ff967819ULL, 0x000fe40000011496ULL, 0x00000018ff727819ULL, 0x000fc40000011472ULL,
0x00000018ff987819ULL, 0x000fe20000011498ULL, 0x000000c400cd7306ULL, 0x0002e20000205400ULL,
0x00000071de00720bULL, 0x004fe20003f9d000ULL, 0x0001000046717824ULL, 0x000fca00078e00ffULL,
0x00000018ff717819ULL, 0x000fe20000011471ULL, 0x0000004c008e7306ULL, 0x000ea2000000d400ULL,
0x000000c400c47245ULL, 0x002fce000020d400ULL, 0x000000ce004c7306ULL, 0x000fe20000209400ULL,
0x000000cdcc00720bULL, 0x008fce0003fbd000ULL, 0x000000ce00e37306ULL, 0x0002e20000205400ULL,
0x000000018e8e4812ULL, 0x004fca00078efcffULL, 0x00000001c4c45812ULL, 0x000fe400078efcffULL,
0x000000c700df7306ULL, 0x000fe20000209400ULL, 0x000000ce00ce7245ULL, 0x002fce000020d400ULL,
0x000000c700dc7306ULL, 0x0002a20000205400ULL, 0x000000e34c00720bULL, 0x008fe20003f7d000ULL,
0x00000100474c7824ULL, 0x000fcc00078e00ffULL, 0x000000b300bb7306ULL, 0x000fe20000209400ULL,
0x000000c700c77245ULL, 0x002fca000020d400ULL, 0x00000001cece3812ULL, 0x000fe400078efcffULL,
0x000000b300b87306ULL, 0x0002e20000205400ULL, 0x000000dcdf00720bULL, 0x004fce0003f9d000ULL,
0x0000004f00b57306ULL, 0x000fe20000009400ULL, 0x000000b300b37245ULL, 0x002fca000020d400ULL,
0x00000001c7c74812ULL, 0x000fe400078efcffULL, 0x0000004f00b27306ULL, 0x000e620000005400ULL,
0x000000b8bb00720bULL, 0x008fce0003fbd000ULL, 0x0000004f00737306ULL, 0x0004ec000000d400ULL,
0x00000001b3b35812ULL, 0x000fe400078efcffULL, 0x000000c000c17306ULL, 0x000fe20000209400ULL,
0x00000100494f7824ULL, 0x004fe200078e00ffULL, 0x000000b2b500720bULL, 0x002fc40003f9d000ULL,
0x000000c300b27245ULL, 0x000fe4000020d400ULL, 0x00000018ff4f7819ULL, 0x000fe4000001144fULL,
0x000000c000c27306ULL, 0x000e6e0000205400ULL, 0x0000000173734812ULL, 0x008fe200078efcffULL,
0x000000ba00be7306ULL, 0x000ff00000209400ULL, 0x000000ba00bf7306ULL, 0x0004e20000205400ULL,
0x000000c2c100720bULL, 0x002fce0003f1d000ULL, 0x0000004f00d37306ULL, 0x000fe20000209400ULL,
0x000000ba00ba7245ULL, 0x004fca000020d400ULL, 0x00000001bdbd0812ULL, 0x000fe400078efcffULL,
0x0000004f00da7306ULL, 0x000e620000205400ULL, 0x000000bfbe00720bULL, 0x008fce0003f7d000ULL,
0x0000004e00b97306ULL, 0x000fec0000009400ULL, 0x00000001baba3812ULL, 0x000fe400078efcffULL,
0x0000004e00b67306ULL, 0x000ea20000005400ULL, 0x000000dad300720bULL, 0x002fe40003fbd000ULL,
0x000000c7bac7723eULL, 0x000fca00000010ffULL, 0x0000004e00777306ULL, 0x0002f0000000d400ULL,
0x0000004d008d7306ULL, 0x0008e2000000d400ULL, 0x00000100484e7824ULL, 0x002fe200078e00ffULL,
0x000000b6b900720bULL, 0x004fc80003f1d000ULL, 0x00000018ff4e7819ULL, 0x000fe4000001144eULL,
0x000000c300cb7306ULL, 0x000fe20000209400ULL, 0x00000100444d7824ULL, 0x010fe200078e00ffULL,
0x0000004e00b57245ULL, 0x000fca000020d400ULL, 0x0000000177770812ULL, 0x008fe200078efcffULL,
0x000000c300d07306ULL, 0x000e620000205400ULL, 0x000000018d8d6812ULL, 0x000fe400078efcffULL,
0x00000077c4c4723eULL, 0x000fe400000010ffULL, 0x0000008dbc8d723eULL, 0x000fc600000010ffULL,
0x0000004900a87306ULL, 0x000ff00000009400ULL, 0x0000004900a97306ULL, 0x000fe20000005400ULL,
0x000000d0cb00720bULL, 0x002fce0003fdd000ULL, 0x00000049006f7306ULL, 0x0003ec000000d400ULL,
0x00000001b2b26812ULL, 0x000fe400078efcffULL, 0x0000004a00a37306ULL, 0x000fe20000009400ULL,
0x0001000045497824ULL, 0x002fe200078e00ffULL, 0x00000073b2c5723eULL, 0x000fcc00000010ffULL,
0x0000004a00a47306ULL, 0x000ff00000005400ULL, 0x0000004a006b7306ULL, 0x0003f0000000d400ULL,
0x00000045005b7306ULL, 0x0005e2000000d400ULL, 0x00000100454a7824ULL, 0x002fce00078e00ffULL,
0x000000c800c97306ULL, 0x000fe20000209400ULL, 0x00000018ff457819ULL, 0x004fe20000011453ULL,
0x0001000047537824ULL, 0x000fca00078e00ffULL, 0x00000018ff537819ULL, 0x000fe20000011453ULL,
0x000000c800d27306ULL, 0x0002b00000205400ULL, 0x0000004e00d47306ULL, 0x000fe20000209400ULL,
0x000000c800c87245ULL, 0x002fce000020d400ULL, 0x0000004e00cf7306ULL, 0x0002e20000205400ULL,
0x000000d2c900720bULL, 0x004fce0003f7d000ULL, 0x0000004800ac7306ULL, 0x000fe20000009400ULL,
0x0000004f004e7245ULL, 0x002fe4000020d400ULL, 0x00000045004f7245ULL, 0x000fe4000020d400ULL,
0x000000014e4e5812ULL, 0x000fe400078efcffULL, 0x00000001c8c83812ULL, 0x000fe200078efcffULL,
0x0000004800af7306ULL, 0x000e620000005400ULL, 0x000000cfd400720bULL, 0x008fce0003f9d000ULL,
0x0000004800707306ULL, 0x0004ec000000d400ULL, 0x00000001b5b54812ULL, 0x000fe400078efcffULL,
0x0000004600797306ULL, 0x000fe20000009400ULL, 0x0000010046487824ULL, 0x004fe200078e00ffULL,
0x000000afac00720bULL, 0x002fc40003f7d000ULL, 0x000000c600ac7245ULL, 0x000fe4000020d400ULL,
0x000000b000af7245ULL, 0x000fe4000020d400ULL, 0x0000004600787306ULL, 0x000fee0000005400ULL,
0x0000000170703812ULL, 0x008fe200078efcffULL, 0x00000046005a7306ULL, 0x000ff0000000d400ULL,
0x0000004700697306ULL, 0x000ff00000009400ULL, 0x0000004700687306ULL, 0x000ff00000005400ULL,
0x0000004700587306ULL, 0x000ff0000000d400ULL, 0x0000004500467306ULL, 0x000ff00000209400ULL,
0x0000004500477306ULL, 0x000e700000205400ULL, 0x000000c600d17306ULL, 0x000ff00000209400ULL,
0x000000c600d67306ULL, 0x0004e20000205400ULL, 0x000000474600720bULL, 0x002fc40003fbd000ULL,
0x0000a0003a467811ULL, 0x000fca00078e20ffULL, 0x0000004b00a17306ULL, 0x000fe20000009400ULL,
0x000000cebdc6723eULL, 0x004fca00000010ffULL, 0x000000014f4f5812ULL, 0x000fe400078efcffULL,
0x0000004b00a07306ULL, 0x000e620000005400ULL, 0x000000d6d100720bULL, 0x008fce0003fdd000ULL,
0x0000004b00547306ULL, 0x0004ec000000d400ULL, 0x00000001acac6812ULL, 0x000fe400078efcffULL,
0x000000b000b47306ULL, 0x000fe20000209400ULL, 0x00010000444b7824ULL, 0x004fe200078e00ffULL,
0x000000a0a100720bULL, 0x002fc40003fbd000ULL, 0x000000a9a800720bULL, 0x000fe40003fdd000ULL,
0x000000d500a87245ULL, 0x000fe4000020d400ULL, 0x000000b000b77306ULL, 0x000e620000205400ULL,
0x000000e400a17245ULL, 0x000fe4000020d400ULL, 0x000000db00a07245ULL, 0x000fc8000020d400ULL,
0x0000000154545812ULL, 0x008fe200078efcffULL, 0x00000044007d7306ULL, 0x000fe20000009400ULL,
0x000000016f6f6812ULL, 0x000fce00078efcffULL, 0x0000004400807306ULL, 0x000fe20000005400ULL,
0x000000b7b400720bULL, 0x002fce0003f1d000ULL, 0x00000044005c7306ULL, 0x000fec000000d400ULL,
0x00000001afaf0812ULL, 0x000fe400078efcffULL, 0x000000d500d97306ULL, 0x000fe40000209400ULL,
0x000000acafaf723eULL, 0x000fcc00000010ffULL, 0x000000d500447306ULL, 0x000e700000205400ULL,
0x000000ab00ae7306ULL, 0x000ff00000209400ULL, 0x000000ab00b17306ULL, 0x0004e20000205400ULL,
0x00000044d900720bULL, 0x002fce0003f9d000ULL, 0x000000d700447306ULL, 0x000fe20000209400ULL,
0x000000ab00ab7245ULL, 0x004fca000020d400ULL, 0x00000001a8a84812ULL, 0x000fe400078efcffULL,
0x000000d700457306ULL, 0x0002a20000205400ULL, 0x000000b1ae00720bULL, 0x008fe40003f1d000ULL,
0x000000a4a300720bULL, 0x000fe40003f9d000ULL, 0x000000e200a47245ULL, 0x000fe4000020d400ULL,
0x000000c8b3ae723eULL, 0x000fe200000010ffULL, 0x000000e200b67306ULL, 0x000fe20000209400ULL,
0x000000d700d77245ULL, 0x002fca000020d400ULL, 0x00000001abab0812ULL, 0x000fe400078efcffULL,
0x000000e200b97306ULL, 0x000e620000205400ULL, 0x000000454400720bULL, 0x004fe40003fbd000ULL,
0x000000016b6b4812ULL, 0x000fe200078efcffULL, 0x000000004644783bULL, 0x000ea80000000200ULL,
0x000000a600ad7306ULL, 0x000fec0000209400ULL, 0x00000001d7d75812ULL, 0x000fc400078efcffULL,
0x000000a600aa7306ULL, 0x0007220000205400ULL, 0x000000b9b600720bULL, 0x002fce0003fdd000ULL,
0x000000e400b87306ULL, 0x000fe20000209400ULL, 0x000000a600a67245ULL, 0x008fca000020d400ULL,
0x00000001a4a46812ULL, 0x000fe400078efcffULL, 0x000000e400b77306ULL, 0x000e620000205400ULL,
0x000000aaad00720bULL, 0x010fe40003f7d000ULL, 0x0000006ba4a4723eULL, 0x000fca00000010ffULL,
0x0000003d00817306ULL, 0x000fe20000009400ULL, 0x0000001d4444a231ULL, 0x004fca00003400ffULL,
0x00000001a6a63812ULL, 0x000fe200078efcffULL, 0x0000001d4646a231ULL, 0x000fe200003400ffULL,
0x0000003d00827306ULL, 0x000ea20000005400ULL, 0x000000b7b800720bULL, 0x002fe20003f1d000ULL,
0x0000001c4545a231ULL, 0x080fe200003400ffULL, 0x0000004fa64f723eULL, 0x000fe200000010ffULL,
0x0000001c4747a231ULL, 0x000fc800003400ffULL, 0x000000db00b07306ULL, 0x000fec0000209400ULL,
0x00000001a1a10812ULL, 0x000fe400078efcffULL, 0x000000db00a97306ULL, 0x000e620000205400ULL,
0x000000828100720bULL, 0x004fe40003fbd000ULL, 0x0000008a00817245ULL, 0x000fca000020d400ULL,
0x0000003e008c7306ULL, 0x000ff00000009400ULL, 0x0000003e00857306ULL, 0x000fe20000005400ULL,
0x000000a9b000720bULL, 0x002fce0003f9d000ULL, 0x0000003e00627306ULL, 0x000fec000000d400ULL,
0x00000001a0a04812ULL, 0x000fe400078efcffULL, 0x0000009f003e7306ULL, 0x000ff00000209400ULL,
0x0000009f00a77306ULL, 0x0002b00000205400ULL, 0x0000003c007c7306ULL, 0x000fe20000009400ULL,
0x0000009f009f7245ULL, 0x002fce000020d400ULL, 0x0000003c00837306ULL, 0x000e620000005400ULL,
0x000000a73e00720bULL, 0x004fe40003fdd000ULL, 0x0000a000393e7811ULL, 0x000fca00078e20ffULL,
0x0000003c00657306ULL, 0x000eac000000d400ULL, 0x000000019f9f6812ULL, 0x000fe400078efcffULL,
0x0000003d00647306ULL, 0x000ee2000000d400ULL, 0x000000837c00720bULL, 0x002fe40003f9d000ULL,
0x0000008f007c7245ULL, 0x000fc4000020d400ULL, 0x0000009600837245ULL, 0x000fe4000020d400ULL,
0x000000a09fa0723eULL, 0x000fe200000010ffULL, 0x0000008f00a27306ULL, 0x000fec0000209400ULL,
0x0000000165654812ULL, 0x004fe400078efcffULL, 0x0000008f00a57306ULL, 0x000e620000205400ULL,
0x0000000164645812ULL, 0x008fc400078efcffULL, 0x000000858c00720bULL, 0x000fe40003f9d000ULL,
0x00000018ff857819ULL, 0x000fe4000001144aULL, 0x0000008e558c723eULL, 0x000fe200000010ffULL,
0x0000009d003c7306ULL, 0x000fe20000209400ULL, 0x00000070b54a723eULL, 0x000fe400000010ffULL,
0x00000018ff707819ULL, 0x000fca0000011448ULL, 0x0000009d003d7306ULL, 0x000ea20000205400ULL,
0x000000a5a200720bULL, 0x002fe40003f7d000ULL, 0x0000000162624812ULL, 0x000fca00078efcffULL,
0x0000009100997306ULL, 0x000fec0000209400ULL, 0x000000017c7c3812ULL, 0x000fe400078efcffULL,
0x00000091009a7306ULL, 0x0002e20000205400ULL, 0x0000003d3c00720bULL, 0x004fe40003f1d000ULL,
0x000000657c7c723eULL, 0x000fca00000010ffULL, 0x0000003f008b7306ULL, 0x000fe20000009400ULL,
0x0000009100917245ULL, 0x002fce000020d400ULL, 0x0000003f007e7306ULL, 0x000fe20000005400ULL,
0x0000009a9900720bULL, 0x008fce0003fbd000ULL, 0x0000003f00617306ULL, 0x0003ec000000d400ULL,
0x0000000191915812ULL, 0x000fe400078efcffULL, 0x0000009400937306ULL, 0x000fe20000209400ULL,
0x000100003f3f7824ULL, 0x002fca00078e00ffULL, 0x00000018ffa27819ULL, 0x000fe4000001143fULL,
0x000000003e3c783bULL, 0x000e620000000200ULL, 0x0000009400927306ULL, 0x0004f00000205400ULL,
0x0000007a00907306ULL, 0x000fe20000209400ULL, 0x0000009400947245ULL, 0x004fce000020d400ULL,
0x0000007a00957306ULL, 0x0005220000205400ULL, 0x000000929300720bULL, 0x008fe40003fdd000ULL,
0x0000009d00927245ULL, 0x000fe4000020d400ULL, 0x00000018ff937819ULL, 0x000fe4000001144dULL,
0x0000000192920812ULL, 0x000fe200078efcffULL, 0x0000008a00877306ULL, 0x000fe20000209400ULL,
0x0000007a007a7245ULL, 0x004fca000020d400ULL, 0x0000000194946812ULL, 0x000fe400078efcffULL,
0x0000008a00867306ULL, 0x000ea20000205400ULL, 0x000000959000720bULL, 0x010fe40003fbd000ULL,
0x0000007e8b00720bULL, 0x000fe40003fdd000ULL, 0x00000018ff7e7819ULL, 0x000fe2000001144bULL,
0x0000001d3c3ca231ULL, 0x082fe400003400ffULL, 0x0000006e00747306ULL, 0x000fe20000209400ULL,
0x0000001d3e3ea231ULL, 0x000fe200003400ffULL, 0x0000006f4e4b723eULL, 0x000fe200000010ffULL,
0x0000001c3d3da231ULL, 0x080fe200003400ffULL, 0x0000006e006f7245ULL, 0x000fe2000020d400ULL,
0x0000001c3f3fa231ULL, 0x000fe200003400ffULL, 0x000000017a7a5812ULL, 0x000fc400078efcffULL,
0x0000006e00757306ULL, 0x000e620000205400ULL, 0x000000868700720bULL, 0x004fe40003f1d000ULL,
0x000000807d00720bULL, 0x000fe20003f5d000ULL, 0x0000008c3c04723cULL, 0x040fe20000041804ULL,
0x0000000161616812ULL, 0x000fe400078efcffULL, 0x000000a8ab4e723eULL, 0x000fe200000010ffULL,
0x0000009600977306ULL, 0x000fe80000209400ULL, 0x000000c63c08723cULL, 0x000fe40000041808ULL,
0x0000000181810812ULL, 0x000fc400078efcffULL, 0x00000096009e7306ULL, 0x000ea20000205400ULL,
0x000000757400720bULL, 0x002fe40003f9d000ULL, 0x000000015c5c2812ULL, 0x000fe200078efcffULL,
0x000000c43c0c723cULL, 0x040f68000004180cULL, 0x0000007200767306ULL, 0x000fe80000209400ULL,
0x000000ae3c28723cULL, 0x000fe40000041828ULL, 0x000000016f6f4812ULL, 0x000fc400078efcffULL,
0x0000007200a37306ULL, 0x0002e20000205400ULL, 0x0000009e9700720bULL, 0x004fce0003f7d000ULL,
0x0000007b007f7306ULL, 0x000fe20000209400ULL, 0x0000007200727245ULL, 0x002fca000020d400ULL,
0x0000000183833812ULL, 0x000fe400078efcffULL, 0x0000007b00887306ULL, 0x0002a20000205400ULL,
0x000000a37600720bULL, 0x008fe40003fbd000ULL, 0x00000064837d723eULL, 0x000fca00000010ffULL,
0x0000006a006d7306ULL, 0x000fe20000209400ULL, 0x0000007b007b7245ULL, 0x002fca000020d400ULL,
0x0000000172725812ULL, 0x000fe400078efcffULL, 0x0000006a006c7306ULL, 0x000e620000205400ULL,
0x000000887f00720bULL, 0x004fce0003f1d000ULL, 0x00000098009b7306ULL, 0x000fec0000209400ULL,
0x000000017b7b0812ULL, 0x000fe400078efcffULL, 0x00000098009c7306ULL, 0x0004e20000205400ULL,
0x0000006c6d00720bULL, 0x002fe40003fbd000ULL, 0x000000787900720bULL, 0x000fc40003f1d000ULL,
0x00000018ff797819ULL, 0x000fe40000011449ULL, 0x0000004a3c48723cULL, 0x000be2000004182cULL,
0x00000093004d7306ULL, 0x000fe20000209400ULL, 0x0000009800987245ULL, 0x004fe4000020d400ULL,
0x00000018ff6c7819ULL, 0x000fc6000001144cULL, 0x0000006a002d7245ULL, 0x020fe4000020d400ULL,
0x0000009300827306ULL, 0x0002a20000205400ULL, 0x0000009c9b00720bULL, 0x008fe40003f7d000ULL,
0x000000012d2d5812ULL, 0x000fe400078efcffULL, 0x000000015a5a0812ULL, 0x000fe400078efcffULL,
0x000000726f2c723eULL, 0x000fe200000010ffULL, 0x0000006300567306ULL, 0x000fe20000209400ULL,
0x0000009300937245ULL, 0x002fca000020d400ULL, 0x0000000198983812ULL, 0x000fe400078efcffULL,
0x0000006300577306ULL, 0x0002e20000205400ULL, 0x000000824d00720bULL, 0x004fe40003f9d000ULL,
0x000000848900720bULL, 0x000fe20003f7d000ULL, 0x0000004e3c4c723cULL, 0x000b680000041830ULL,
0x0000008500867306ULL, 0x000fe20000209400ULL, 0x0000006300637245ULL, 0x002fc4000020d400ULL,
0x000000629130723eULL, 0x020fe400000010ffULL, 0x000000617a31723eULL, 0x000fe400000010ffULL,
0x0000000193934812ULL, 0x000fe200078efcffULL, 0x0000008500877306ULL, 0x000e620000205400ULL,
0x000000575600720bULL, 0x008fe40003fbd000ULL, 0x000000015b5b3812ULL, 0x000fe200078efcffULL,
0x000000304430723cULL, 0x000be2000004180cULL, 0x0000005c935c723eULL, 0x000fc600000010ffULL,
0x000000a200a57306ULL, 0x000fe60000209400ULL, 0x00000053000d7245ULL, 0x020fc6000020d400ULL,
0x0000000163635812ULL, 0x000fe400078efcffULL, 0x000000a200aa7306ULL, 0x0004e20000205400ULL,
0x000000878600720bULL, 0x002fce0003f9d000ULL, 0x0000005d00677306ULL, 0x000fe20000209400ULL,
0x000000a200a27245ULL, 0x004fce000020d400ULL, 0x0000005d00667306ULL, 0x000e620000205400ULL,
0x000000aaa500720bULL, 0x008fe40003fdd000ULL, 0x00000054a1a5723eULL, 0x000fe400000010ffULL,
0x000000d792a1723eULL, 0x000fc600000010ffULL, 0x0000007e007f7306ULL, 0x000fe40000209400ULL,
0x000000a43c54723cULL, 0x040b680000041834ULL, 0x00000001a2a26812ULL, 0x000fe400078efcffULL,
0x0000007e00787306ULL, 0x0004e20000205400ULL, 0x000000666700720bULL, 0x002fe20003f5d000ULL,
0x000000a03c40723cULL, 0x000f620000041840ULL, 0x0000008500667245ULL, 0x000fc4000020d400ULL,
0x000000948134723eULL, 0x020fe400000010ffULL, 0x0000000166664812ULL, 0x000fe200078efcffULL,
0x0000007900747306ULL, 0x000fe20000209400ULL, 0x000000987b35723eULL, 0x000fe200000010ffULL,
0x0000007c443c723cULL, 0x040b620000041804ULL, 0x0000007e007e7245ULL, 0x004fe4000020d400ULL,
0x000000686900720bULL, 0x000fe40003fdd000ULL, 0x000000a22d2d723eULL, 0x000fe200000010ffULL,
0x0000007900737306ULL, 0x000e620000205400ULL, 0x000000787f00720bULL, 0x008fe20003f9d000ULL,
0x000000344434723cULL, 0x000b640000041808ULL, 0x0000005d00047245ULL, 0x020fc4000020d400ULL,
0x0000007000057245ULL, 0x000fe4000020d400ULL, 0x0000000104042812ULL, 0x000fe200078efcffULL,
0x00000070006e7306ULL, 0x000fe20000209400ULL, 0x0000007900097245ULL, 0x000fe4000020d400ULL,
0x0000000158586812ULL, 0x000fe400078efcffULL, 0x0000005b665d723eULL, 0x000fe400000010ffULL,
0x000000017e7e4812ULL, 0x000fe200078efcffULL, 0x00000070006d7306ULL, 0x000ea20000205400ULL,
0x000000737400720bULL, 0x002fc40003f7d000ULL, 0x0000007e6308723eULL, 0x000fca00000010ffULL,
0x00000051005f7306ULL, 0x000fec0000209400ULL, 0x0000000109093812ULL, 0x000fe400078efcffULL,
0x0000005100607306ULL, 0x000e620000205400ULL, 0x0000006d6e00720bULL, 0x004fe40003fbd000ULL,
0x000000090409723eULL, 0x000fca00000010ffULL, 0x0000005000597306ULL, 0x000fe40000209400ULL,
0x000000084408723cULL, 0x000b68000004184cULL, 0x0000000105055812ULL, 0x000fe400078efcffULL,
0x00000050005e7306ULL, 0x0004e20000205400ULL, 0x000000605f00720bULL, 0x002fe40003f9d000ULL,
0x0000005a0504723eULL, 0x000fca00000010ffULL, 0x0000006c002e7306ULL, 0x000fe20000209400ULL,
0x0000005000507245ULL, 0x004fce000020d400ULL, 0x0000006c002f7306ULL, 0x000e620000205400ULL,
0x0000005e5900720bULL, 0x008fce0003f7d000ULL, 0x0000007100677306ULL, 0x000fec0000209400ULL,
0x0000000150503812ULL, 0x000fe400078efcffULL, 0x0000007100647306ULL, 0x0004e20000205400ULL,
0x0000002f2e00720bULL, 0x002fe40003f5d000ULL, 0x0000002c442c723cULL, 0x000b6a0000041828ULL,
0x0000005300067306ULL, 0x000fe20000209400ULL, 0x0000007100717245ULL, 0x004fc4000020d400ULL,
0x0000005c4428723cULL, 0x000b6a0000041848ULL, 0x0000005300077306ULL, 0x000e620000205400ULL,
0x000000646700720bULL, 0x008fda0003fbd000ULL, 0x0000000171715812ULL, 0x000fe400078efcffULL,
0x000000070600720bULL, 0x002fe40003f1d000ULL, 0x0000006c00077245ULL, 0x000fe4000020d400ULL,
0x0000005100067245ULL, 0x000fe4000020d400ULL, 0x0000000107072812ULL, 0x000fe400078efcffULL,
0x0000000106064812ULL, 0x000fc400078efcffULL, 0x000000580705723eULL, 0x000fe400000010ffULL,
0x00000071060c723eULL, 0x000fe400000010ffULL, 0x000000010d0d0812ULL, 0x000fc600078efcffULL,
0x000000044404723cULL, 0x000b620000041854ULL, 0x0000000d500d723eULL, 0x000fce00000010ffULL,
0x0000000c440c723cULL, 0x000b620000041840ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff407f8cULL, 0x020e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000002014407810ULL, 0x002fe20007ffe0ffULL,
0x01068800ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff467224ULL, 0x000fe400078e0041ULL,
0x000000034000720cULL, 0x000fe20003f06070ULL, 0x000000ffff407224ULL, 0x000fd800078e0052ULL,
0x000116d000000947ULL, 0x000fea0003800000ULL, 0x0000000000407805ULL, 0x000fc40000015200ULL,
0x0106bc00ff437984ULL, 0x000e640000000800ULL, 0x8000000043ff7812ULL, 0x002fe40007804846ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff447224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000427805ULL, 0x000fcc0000015200ULL, 0x0000004240457210ULL, 0x000fca0007f1e1ffULL,
0x0000000143437824ULL, 0x000fe200000e0e41ULL, 0x003d09004500780cULL, 0x000fc80003f06070ULL,
0x000000ff4300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404500780cULL, 0x000fc80003f06070ULL, 0x000000ff4300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff427819ULL, 0x000fc80000011443ULL,
0x0000004542427211ULL, 0x000fca00078110ffULL, 0x000000ffff437224ULL, 0x000fca00000e0643ULL,
0x0000000242427819ULL, 0x000fc80000001243ULL, 0x000000420000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000144447810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106bc00ff437984ULL, 0x000e640000000800ULL,
0x8000000043ff7812ULL, 0x002fe40007804846ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000004014417810ULL, 0x000fca0007ffe0ffULL, 0x0000620012457a24ULL, 0x000fe200078e0241ULL,
0x0000039000009947ULL, 0x000fea0003800000ULL, 0x000000041e4e7810ULL, 0x040fe20007ffe0ffULL,
0x0000000111427824ULL, 0x000fe200078e021eULL, 0x000000021e4c7810ULL, 0x040fe40007ffe0ffULL,
0x0000004103407217ULL, 0x000fe20007800000ULL, 0x0000000111477824ULL, 0x040fe200078e024eULL,
0x000000061e507810ULL, 0x000fe20007ffe0ffULL, 0x0000000111447824ULL, 0x000fe200078e024cULL,
0x000000f0164b7812ULL, 0x000fe200078ec0ffULL, 0x0000000147487824ULL, 0x000fc400078e0202ULL,
0x00000010474f7824ULL, 0x000fe400078e00ffULL, 0x0000000140407824ULL, 0x000fe400078e0a41ULL,
0x0000000142437824ULL, 0x040fe200078e0202ULL, 0xfffffff04f4f7812ULL, 0x000fe200078ee248ULL,
0x00000010424a7824ULL, 0x000fe400078e00ffULL, 0x0000000144467824ULL, 0x040fe200078e0202ULL,
0x0000e0004f4f7811ULL, 0x000fe200078e20ffULL, 0x00000010444d7824ULL, 0x000fe200078e00ffULL,
0xfffffff04a4a7812ULL, 0x000fe200078ee243ULL, 0x00000100ff487424ULL, 0x000fc400078e00ffULL,
0x0000000142417824ULL, 0x100fe200078e0245ULL, 0x0000004011427217ULL, 0x000fe20007800000ULL,
0x0000000144437824ULL, 0x000fe200078e0245ULL, 0xfffffff04d4d7812ULL, 0x000fe200078ee246ULL,
0x0000000111467824ULL, 0x000fe400078e0250ULL, 0x00005e0041407625ULL, 0x000fe200078e0048ULL,
0x0000e0004d4d7811ULL, 0x000fc600078e20ffULL, 0x0000000142497824ULL, 0x000fe400078e0a11ULL,
0x0000000147447824ULL, 0x100fe400078e0245ULL, 0x00005e0043427625ULL, 0x000fe200078e0048ULL,
0x000000491e00720cULL, 0x080fe40003f66070ULL, 0x000000494c00720cULL, 0x000fe20003f46070ULL,
0x0000000146457824ULL, 0x000fe200078e0245ULL, 0x0000004b42427210ULL, 0x000fe20007f9e0ffULL,
0x0000000146477824ULL, 0x000fc400078e0202ULL, 0x0000001046547824ULL, 0x000fe200078e00ffULL,
0x0000004b40467210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff437224ULL, 0x000fe200020e0643ULL,
0x000000495000720cULL, 0x080fe40003f86070ULL, 0xfffffff054517812ULL, 0x000fe200078ee247ULL,
0x000000ffff477224ULL, 0x000fe200000e0641ULL, 0x000000494e00720cULL, 0x000fe20003f06070ULL,
0x00005e0044407625ULL, 0x080fe200078e0048ULL, 0x0000e0004a497811ULL, 0x000fe400078e20ffULL,
0x0000e00051517811ULL, 0x000fe200078e20ffULL, 0x00005e0045447625ULL, 0x000fe200078e0048ULL,
0x0000004b40407210ULL, 0x080fe20007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000046497faeULL, 0x0003e6000d901c46ULL, 0x0000004b44447210ULL, 0x000fe20007fde0ffULL,
0x000000ffff417224ULL, 0x000fe200028e0641ULL, 0x00000000424d7faeULL, 0x0003e6000d101c46ULL,
0x000000ffff457224ULL, 0x000fe200030e0645ULL, 0x00000000404f7faeULL, 0x0003e8000c101c46ULL,
0x0000000044517faeULL, 0x0003e2000e101c46ULL, 0x000002d000007947ULL, 0x000fea0003800000ULL,
0x0000000111407824ULL, 0x000fe200078e021eULL, 0x000000f0164b7812ULL, 0x000fe200078ec0ffULL,
0x00000100ff497424ULL, 0x000fc400078e00ffULL, 0x0000000140417824ULL, 0x040fe200078e0202ULL,
0x0000000440447810ULL, 0x040fe20007ffe0ffULL, 0x0000001040487824ULL, 0x040fe200078e00ffULL,
0x0000000240427810ULL, 0x000fc60007ffe0ffULL, 0x0000000144467824ULL, 0x100fe200078e0202ULL,
0xfffffff048487812ULL, 0x000fe200078ee241ULL, 0x0000001044477824ULL, 0x000fe200078e00ffULL,
0x0000000640417810ULL, 0x000fe20007ffe0ffULL, 0x0000000142437824ULL, 0x000fe200078e0202ULL,
0x0000e000484f7811ULL, 0x000fe200078e20ffULL, 0x00000010424a7824ULL, 0x000fe200078e00ffULL,
0xfffffff0474c7812ULL, 0x000fe200078ee246ULL, 0x0000000140467824ULL, 0x100fe400078e0245ULL,
0x0000000142407824ULL, 0x000fe200078e0245ULL, 0xfffffff04a4a7812ULL, 0x000fe200078ee243ULL,
0x00005e0046467625ULL, 0x000fc800078e0049ULL, 0x0000000144427824ULL, 0x100fe200078e0245ULL,
0x0000004b46467210ULL, 0x000fe20007f5e0ffULL, 0x0000000141447824ULL, 0x040fe400078e0245ULL,
0x00000001414d7824ULL, 0x040fe400078e0202ULL, 0x00000010414e7824ULL, 0x000fe400078e00ffULL,
0x00005e0040407625ULL, 0x000fc600078e0049ULL, 0xfffffff04e4d7812ULL, 0x000fe200078ee24dULL,
0x00005e0042427625ULL, 0x000fe200078e0049ULL, 0x0000004b40407210ULL, 0x000fe40007f1e0ffULL,
0x0000e0004d4d7811ULL, 0x000fe200078e20ffULL, 0x00005e0044447625ULL, 0x000fe200078e0049ULL,
0x0000e0004a497811ULL, 0x000fc600078e20ffULL, 0x000000ffff477224ULL, 0x000fe200010e0647ULL,
0x0000004b42427210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff417224ULL, 0x000fe200000e0641ULL,
0x0000004b44447210ULL, 0x000fe40007f7e0ffULL, 0x0000e0004c4b7811ULL, 0x000fe200078e20ffULL,
0x000000ffff437224ULL, 0x000fe200010e0643ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000464f7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff457224ULL, 0x000fc600018e0645ULL,
0x0000000040497faeULL, 0x0003e8000b901c46ULL, 0x00000000424b7faeULL, 0x0003e8000b901c46ULL,
0x00000000444d7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b000ff427f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106280011467f8cULL, 0x0004e4000c80043fULL,
0x0000000000407805ULL, 0x000fc40000015200ULL, 0x01062c0011457984ULL, 0x000f240000000800ULL,
0x8000000045ff7812ULL, 0x018fc40007804847ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff487224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000447805ULL, 0x000fcc0000015200ULL,
0x0000004440497210ULL, 0x000fca0007f1e1ffULL, 0x0000000145457824ULL, 0x000fe200000e0e41ULL,
0x003d09004900780cULL, 0x000fc80003f06070ULL, 0x000000ff4500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404900780cULL, 0x000fc80003f06070ULL,
0x000000ff4500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff447819ULL, 0x000fc80000011445ULL, 0x0000004944447211ULL, 0x000fca00078110ffULL,
0x000000ffff457224ULL, 0x000fca00000e0645ULL, 0x0000000244447819ULL, 0x000fc80000001245ULL,
0x000000440000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000148487810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01062c0011457984ULL, 0x000ee40000000800ULL, 0x8000000045ff7812ULL, 0x008fe40007804847ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0100800017417984ULL, 0x000ee80000000800ULL,
0x0102800017467984ULL, 0x0004620000000800ULL, 0x000000524100720bULL, 0x008fe20003f1d000ULL,
0x000175227f007947ULL, 0x000fd8000b800000ULL, 0x0000000000477806ULL, 0x004fc800000e0100ULL,
0x0000ffff47ff7812ULL, 0x000fe2000780c0ffULL, 0x0000048000007945ULL, 0x000fe20003800000ULL,
0x00000001ff487424ULL, 0x000fc400078e00ffULL, 0x000000ffff407224ULL, 0x000fd200078e0052ULL,
0x0000044000008947ULL, 0x000fea0003800000ULL, 0x000000010000780cULL, 0x000fe40003f05270ULL,
0x000000524100720bULL, 0x000fe20003f54000ULL, 0x000174e27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000407806ULL, 0x000fc400010e0100ULL, 0x0000005241448209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x0000991040457816ULL, 0x000fc600000000ffULL,
0x0104804417008388ULL, 0x0005e20000000800ULL, 0x000000ff4500720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000005241457209ULL, 0x004fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff40ff7812ULL, 0x000fc6000780c0ffULL,
0x0000005245447221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b44447820ULL, 0x000fc80000410000ULL,
0x0000004400487308ULL, 0x000ea40000000800ULL, 0x0000004813137220ULL, 0x004fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff5b7819ULL, 0x000fe20000011602ULL,
0x000174227f007947ULL, 0x000fea000b800000ULL, 0x00001f5b48447589ULL, 0x0004e400000e0000ULL,
0x000000443c3c7220ULL, 0x088fe20000410000ULL, 0x000000443d3d7220ULL, 0x080fe20000410000ULL,
0x0000004434347220ULL, 0x080fe20000410000ULL, 0x0000004435357220ULL, 0x080fe20000410000ULL,
0x0000004430307220ULL, 0x080fe20000410000ULL, 0x0000004431317220ULL, 0x080fe20000410000ULL,
0x000000442c2c7220ULL, 0x080fe20000410000ULL, 0x000000442d2d7220ULL, 0x080fe20000410000ULL,
0x0000004428287220ULL, 0x080fe20000410000ULL, 0x0000004429297220ULL, 0x080fe20000410000ULL,
0x0000004408087220ULL, 0x080fe20000410000ULL, 0x0000004409097220ULL, 0x080fe20000410000ULL,
0x0000004404047220ULL, 0x080fe20000410000ULL, 0x0000004405057220ULL, 0x080fe20000410000ULL,
0x000000440c0c7220ULL, 0x080fe20000410000ULL, 0x000000440d0d7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0040ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008025b7811ULL, 0x006fe200078ff0ffULL,
0x000173127f007947ULL, 0x000fea000b800000ULL, 0x00001f5b48447589ULL, 0x0002a400000e0000ULL,
0x000000443e3e7220ULL, 0x084fe20000410000ULL, 0x000000443f3f7220ULL, 0x080fe20000410000ULL,
0x0000004436367220ULL, 0x080fe20000410000ULL, 0x0000004437377220ULL, 0x080fe20000410000ULL,
0x0000004432327220ULL, 0x080fe20000410000ULL, 0x0000004433337220ULL, 0x080fe20000410000ULL,
0x000000442e2e7220ULL, 0x080fe20000410000ULL, 0x000000442f2f7220ULL, 0x080fe20000410000ULL,
0x000000442a2a7220ULL, 0x080fe20000410000ULL, 0x000000442b2b7220ULL, 0x080fe20000410000ULL,
0x000000440a0a7220ULL, 0x080fe20000410000ULL, 0x000000440b0b7220ULL, 0x080fe20000410000ULL,
0x0000004406067220ULL, 0x080fe20000410000ULL, 0x0000004407077220ULL, 0x080fe20000410000ULL,
0x000000440e0e7220ULL, 0x080fe20000410000ULL, 0x000000440f0f7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff40ff7812ULL, 0x000fe20007800847ULL,
0x00000001ff487424ULL, 0x002fe200078e00ffULL, 0x0000005241407209ULL, 0x000fd60007810000ULL,
0x8000004041410221ULL, 0x000fe20000010000ULL, 0x00007610ff480816ULL, 0x000fc60000000048ULL,
0x3fb8aa3b41410820ULL, 0x000fc80000410000ULL, 0x00000041001b0308ULL, 0x000e640000000800ULL,
0x0000001b46460220ULL, 0x002fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001346137221ULL, 0x002fc20000010000ULL, 0x0000000000447805ULL, 0x000fcc0000015200ULL,
0x0106ac00ff467984ULL, 0x000e640000000800ULL, 0x8000000046ff7812ULL, 0x002fe4000780483bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff497224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000467805ULL, 0x000fcc0000015200ULL, 0x0000004644467210ULL, 0x000fca0007f1e1ffULL,
0x0000000147477824ULL, 0x000fe200000e0e45ULL, 0x003d09004600780cULL, 0x000fc80003f06070ULL,
0x000000ff4700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404600780cULL, 0x000fc80003f06070ULL, 0x000000ff4700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff417819ULL, 0x000fc80000011447ULL,
0x0000004641417211ULL, 0x000fca00078110ffULL, 0x000000ffff467224ULL, 0x000fca00000e0647ULL,
0x0000000241417819ULL, 0x000fc80000001246ULL, 0x000000410000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000149497810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106ac00ff467984ULL, 0x000e640000000800ULL,
0x8000000046ff7812ULL, 0x002fe4000780483bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009910483b7816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff3b00720cULL, 0x000fda0003f45270ULL, 0x0000012000002947ULL, 0x000fea0003800000ULL,
0x0000001bff1c723eULL, 0x000fe400000010ffULL, 0x00000002ff467819ULL, 0x000fe40000011602ULL,
0x000054101c3b7816ULL, 0x000fe2000000001cULL, 0x00016ef27f007947ULL, 0x000fea000b800000ULL,
0x00001f463b1d7589ULL, 0x0002a400000e0000ULL, 0x00000008465b7810ULL, 0x002fe20007ffe0ffULL,
0x00016f227f007947ULL, 0x000fea000b800000ULL, 0x00001f5b3b1c7589ULL, 0x0002e400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000010465b7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff5a7224ULL, 0x000fe200078e003bULL, 0x0000845000447802ULL, 0x000fc40000000f00ULL,
0x000179b000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000018465b7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff5a7224ULL, 0x004fe200078e003bULL,
0x000084a000447802ULL, 0x000fc40000000f00ULL, 0x0001796000007944ULL, 0x008fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000001f50783bULL, 0x000f280000004200ULL, 0x00000000214c783bULL, 0x000e680000004200ULL,
0x000000002044783bULL, 0x000ee80000004200ULL, 0x000000002248783bULL, 0x000ea20000004200ULL,
0x0000005000bd7306ULL, 0x010fe20000009400ULL, 0x00000018ffc07819ULL, 0x000fe20000011450ULL,
0x0000010050a77824ULL, 0x000fe200078e00ffULL, 0x00000018ffa57819ULL, 0x000fe20000011451ULL,
0x0000010053bc7824ULL, 0x040fe200078e00ffULL, 0x00000018ff9e7819ULL, 0x000fe20000011452ULL,
0x0001000053b77824ULL, 0x000fe200078e00ffULL, 0x00000018ffc17819ULL, 0x000fe200000114a7ULL,
0x0000005000c27306ULL, 0x000f220000005400ULL, 0x00000018ffbc7819ULL, 0x000fe200000114bcULL,
0x0001000052b97824ULL, 0x040fe200078e00ffULL, 0x00000018ffb77819ULL, 0x000fe200000114b7ULL,
0x000001004fdb7824ULL, 0x002fe200078e00ffULL, 0x00000018ff817819ULL, 0x000fe2000001144cULL,
0x0000010052ba7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6a7819ULL, 0x000fe2000001144fULL,
0x0000005000807306ULL, 0x0002a2000000d400ULL, 0x00000018ffb97819ULL, 0x000fe200000114b9ULL,
0x000100004dd87824ULL, 0x000fe200078e00ffULL, 0x00000018ff9a7819ULL, 0x000fe20000011453ULL,
0x0001000045aa7824ULL, 0x008fe200078e00ffULL, 0x00000018ff787819ULL, 0x000fe2000001144dULL,
0x0001000044a77824ULL, 0x000fe200078e00ffULL, 0x00000018ffba7819ULL, 0x000fe200000114baULL,
0x0000005100cb7306ULL, 0x000fe20000009400ULL, 0x0001000050507824ULL, 0x002fe200078e00ffULL,
0x000000c2bd00720bULL, 0x010fe20003f7d000ULL, 0x000001004cbd7824ULL, 0x040fe200078e00ffULL,
0x00000018ffaa7819ULL, 0x000fe200000114aaULL, 0x000100004cc27824ULL, 0x000fe200078e00ffULL,
0x00000018ffc77819ULL, 0x000fe20000011450ULL, 0x0000010051507824ULL, 0x000fe200078e00ffULL,
0x0000005100ce7306ULL, 0x000e620000005400ULL, 0x00000018ffa77819ULL, 0x000fe200000114a7ULL,
0x000001004eda7824ULL, 0x000fe200078e00ffULL, 0x00000018ff937819ULL, 0x000fc40000011444ULL,
0x00000018ffcd7819ULL, 0x000fe20000011450ULL, 0x0001000047507824ULL, 0x000fe200078e00ffULL,
0x0000000180803812ULL, 0x004fe200078efcffULL, 0x0000005100797306ULL, 0x0004e2000000d400ULL,
0x00000018ff927819ULL, 0x000fe40000011445ULL, 0x00000018ff3b7819ULL, 0x000fe4000001144aULL,
0x00000018ff877819ULL, 0x000fe40000011447ULL, 0x00000018ff867819ULL, 0x000fe20000011446ULL,
0x000000c000c97306ULL, 0x000fe20000209400ULL, 0x0001000051517824ULL, 0x004fe200078e00ffULL,
0x000000cecb00720bULL, 0x002fc40003f9d000ULL, 0x00000018ff507819ULL, 0x000fe40000011450ULL,
0x00000018ffd17819ULL, 0x000fe20000011451ULL, 0x0000010045517824ULL, 0x000fe200078e00ffULL,
0x000000c000cc7306ULL, 0x0002a20000205400ULL, 0x00000018ff717819ULL, 0x000fe4000001144eULL,
0x00000018ffc27819ULL, 0x000fe400000114c2ULL, 0x00000018ff517819ULL, 0x000fe40000011451ULL,
0x0000000179794812ULL, 0x008fe200078efcffULL, 0x000000c700c37306ULL, 0x000fe20000209400ULL,
0x000000c000c07245ULL, 0x002fc4000020d400ULL, 0x00000018ffd87819ULL, 0x000fe400000114d8ULL,
0x00000018ff617819ULL, 0x000fe40000011448ULL, 0x00000018ffda7819ULL, 0x000fe200000114daULL,
0x000000c700ca7306ULL, 0x000e620000205400ULL, 0x000000ccc900720bULL, 0x004fe40003f1d000ULL,
0x00000018ff5c7819ULL, 0x000fe40000011449ULL, 0x00000018ffdb7819ULL, 0x000fc400000114dbULL,
0x00000018ff417819ULL, 0x000fe2000001144bULL, 0x000000d100d27306ULL, 0x000fec0000209400ULL,
0x00000001c0c00812ULL, 0x000fe400078efcffULL, 0x000000d100d37306ULL, 0x000ea20000205400ULL,
0x000000cac300720bULL, 0x002fe20003fbd000ULL, 0x000001004dca7824ULL, 0x000fc400078e00ffULL,
0x000100004ec37824ULL, 0x000fc800078e00ffULL, 0x000000bc00d67306ULL, 0x000fe20000209400ULL,
0x00000018ffc37819ULL, 0x000fce00000114c3ULL, 0x000000bc00d97306ULL, 0x000e620000205400ULL,
0x000000d3d200720bULL, 0x004fce0003f7d000ULL, 0x0000005200a87306ULL, 0x000ff00000009400ULL,
0x0000005200a97306ULL, 0x000ea20000005400ULL, 0x000000d9d600720bULL, 0x002fce0003f9d000ULL,
0x000000a500b67306ULL, 0x000ff00000209400ULL, 0x000000a500b37306ULL, 0x0003e20000205400ULL,
0x000000a9a800720bULL, 0x004fe40003f1d000ULL, 0x000000d100a87245ULL, 0x000fc8000020d400ULL,
0x00000001a8a83812ULL, 0x000fe200078efcffULL, 0x0000005300a37306ULL, 0x000fe20000009400ULL,
0x000000a500a57245ULL, 0x002fce000020d400ULL, 0x0000005300a67306ULL, 0x000e700000005400ULL,
0x000000c100bf7306ULL, 0x000ff00000209400ULL, 0x000000c100c87306ULL, 0x000ea20000205400ULL,
0x000000a6a300720bULL, 0x002fc40003f7d000ULL, 0x000000bc00a37245ULL, 0x000fe4000020d400ULL,
0x00000018ffa67819ULL, 0x000fe400000114caULL, 0x00000001a3a34812ULL, 0x000fe200078efcffULL,
0x0000004c008f7306ULL, 0x000ff00000009400ULL, 0x0000004c008e7306ULL, 0x000fe20000005400ULL,
0x000000c8bf00720bULL, 0x004fce0003fdd000ULL, 0x0000004c00657306ULL, 0x0003f0000000d400ULL,
0x000000b700c47306ULL, 0x000fe20000209400ULL, 0x00000018ff4c7819ULL, 0x002fe200000114bdULL,
0x000100004fbd7824ULL, 0x000fca00078e00ffULL, 0x00000018ffbd7819ULL, 0x000fe200000114bdULL,
0x000000b700c57306ULL, 0x0002b00000205400ULL, 0x0000005200777306ULL, 0x000722000000d400ULL,
0x000000b700b77245ULL, 0x002fce000020d400ULL, 0x0000004f007a7306ULL, 0x000fe20000009400ULL,
0x000000c5c400720bULL, 0x004fe20003f9d000ULL, 0x0000010047527824ULL, 0x008fca00078e00ffULL,
0x00000018ff527819ULL, 0x000fe20000011452ULL, 0x0000004f007f7306ULL, 0x000fe20000005400ULL,
0x0000000177770812ULL, 0x010fca00078efcffULL, 0x00000001b7b74812ULL, 0x000fe400078efcffULL,
0x0000004f005f7306ULL, 0x0003f0000000d400ULL, 0x0000009e00a17306ULL, 0x000fe20000209400ULL,
0x000000c7004f7245ULL, 0x002fc8000020d400ULL, 0x000000014f4f5812ULL, 0x000fe400078efcffULL,
0x000000b3b600720bULL, 0x000fe20003fbd000ULL, 0x0000009e00a47306ULL, 0x0002a20000205400ULL,
0x000000cd00b67245ULL, 0x000fe4000020d400ULL, 0x0000004fc0c0723eULL, 0x000fca00000010ffULL,
0x0000005300747306ULL, 0x000722000000d400ULL, 0x0000009e009e7245ULL, 0x002fc6000020d400ULL,
0x00000001a5a55812ULL, 0x000fc800078efcffULL, 0x000000b900c67306ULL, 0x000fe20000209400ULL,
0x0000010044537824ULL, 0x008fe200078e00ffULL, 0x000000a4a100720bULL, 0x004fe20003f1d000ULL,
0x0000010048a47824ULL, 0x000fc600078e00ffULL, 0x00000018ff537819ULL, 0x000fe40000011453ULL,
0x000000b900d77306ULL, 0x0002a20000205400ULL, 0x0000000174743812ULL, 0x010fe400078efcffULL,
0x00000018ffa47819ULL, 0x000fc800000114a4ULL, 0x000000019e9e0812ULL, 0x000fe200078efcffULL,
0x000000cd00cf7306ULL, 0x000fe20000209400ULL, 0x000000b900b97245ULL, 0x002fce000020d400ULL,
0x000000cd00d07306ULL, 0x000fe20000205400ULL, 0x000000d7c600720bULL, 0x004fce0003fbd000ULL,
0x0000005100bb7306ULL, 0x000fec0000209400ULL, 0x00000001b9b95812ULL, 0x000fe400078efcffULL,
0x0000005100be7306ULL, 0x0002a40000205400ULL, 0x000000b99e9e723eULL, 0x000fcc00000010ffULL,
0x0000005300b87306ULL, 0x000fe20000209400ULL, 0x0000005100517245ULL, 0x002fce000020d400ULL,
0x0000005300b57306ULL, 0x000e620000205400ULL, 0x000000bebb00720bULL, 0x004fce0003f9d000ULL,
0x0000004d00847306ULL, 0x000fec0000009400ULL, 0x0000000151514812ULL, 0x000fe400078efcffULL,
0x0000004d00857306ULL, 0x000fe20000005400ULL, 0x000000b5b800720bULL, 0x002fe20003f1d000ULL,
0x0001000048b57824ULL, 0x000fc400078e00ffULL, 0x0000010049b87824ULL, 0x000fc600078e00ffULL,
0x00000018ffb57819ULL, 0x000fe200000114b5ULL, 0x0000004d00647306ULL, 0x0003e2000000d400ULL,
0x00000018ffb87819ULL, 0x000fce00000114b8ULL, 0x0000009a009c7306ULL, 0x000fe20000209400ULL,
0x000000c1004d7245ULL, 0x002fc8000020d400ULL, 0x000000014d4d6812ULL, 0x000fe400078efcffULL,
0x000000d0cf00720bULL, 0x000fe20003fdd000ULL, 0x0000009a009b7306ULL, 0x000e620000205400ULL,
0x000000804d80723eULL, 0x000fce00000010ffULL, 0x000000ba00d47306ULL, 0x000fe80000209400ULL,
0x00000001b6b66812ULL, 0x000fc800078efcffULL, 0x000000ba00d57306ULL, 0x0004e20000205400ULL,
0x0000009b9c00720bULL, 0x002fe20003fbd000ULL, 0x000100004a9b7824ULL, 0x000fe400078e00ffULL,
0x000001004b9c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff9b7819ULL, 0x000fe2000001149bULL,
0x0000004500a07306ULL, 0x000fe20000009400ULL, 0x000000ba00ba7245ULL, 0x004fe4000020d400ULL,
0x00000018ff9c7819ULL, 0x000fca000001149cULL, 0x00000045009d7306ULL, 0x000e620000005400ULL,
0x000000d5d400720bULL, 0x008fce0003fdd000ULL, 0x000000aa00b47306ULL, 0x000fec0000209400ULL,
0x00000001baba6812ULL, 0x000fe400078efcffULL, 0x000000aa00b17306ULL, 0x0004e20000205400ULL,
0x0000009da000720bULL, 0x002fe20003f7d000ULL, 0x000001004a9d7824ULL, 0x000fe200078e00ffULL,
0x0000005300a07245ULL, 0x000fc4000020d400ULL, 0x0000009200537245ULL, 0x000fe4000020d400ULL,
0x00000001a0a00812ULL, 0x000fe200078efcffULL, 0x000000a700ab7306ULL, 0x000fe20000209400ULL,
0x000000aa00aa7245ULL, 0x004fe4000020d400ULL, 0x00000018ff9d7819ULL, 0x000fca000001149dULL,
0x000000a700b07306ULL, 0x0002a20000205400ULL, 0x000000b1b400720bULL, 0x008fce0003f9d000ULL,
0x00000044009f7306ULL, 0x000fe20000009400ULL, 0x000000a700a77245ULL, 0x002fca000020d400ULL,
0x00000001aaaa4812ULL, 0x000fe400078efcffULL, 0x0000004400a27306ULL, 0x000e620000005400ULL,
0x000000b0ab00720bULL, 0x004fce0003f1d000ULL, 0x00000044006f7306ULL, 0x0004ec000000d400ULL,
0x00000001a7a70812ULL, 0x000fe400078efcffULL, 0x0000009300997306ULL, 0x000fe20000209400ULL,
0x0000010046447824ULL, 0x004fe200078e00ffULL, 0x000000a29f00720bULL, 0x002fe20003fdd000ULL,
0x00010000499f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x0000009300987306ULL, 0x000fee0000205400ULL, 0x000000016f6f6812ULL, 0x008fe200078efcffULL,
0x00000045006c7306ULL, 0x0002b0000000d400ULL, 0x0000004700917306ULL, 0x000fe20000009400ULL,
0x0001000046457824ULL, 0x002fca00078e00ffULL, 0x00000018ff457819ULL, 0x000fe40000011445ULL,
0x0000004700907306ULL, 0x000e620000005400ULL, 0x000000016c6c3812ULL, 0x004fc800078efcffULL,
0x0000006c5151723eULL, 0x000fc600000010ffULL, 0x0000009200957306ULL, 0x000ff00000209400ULL,
0x0000009200947306ULL, 0x000ea20000205400ULL, 0x000000909100720bULL, 0x002fe40003f9d000ULL,
0x0000004400907245ULL, 0x000fca000020d400ULL, 0x0000004a00707306ULL, 0x000ff00000009400ULL,
0x0000004a006d7306ULL, 0x000fe20000005400ULL, 0x000000949500720bULL, 0x004fe40003f7d000ULL,
0x0000009300947245ULL, 0x000fca000020d400ULL, 0x0000004a00547306ULL, 0x0003ec000000d400ULL,
0x0000000153533812ULL, 0x000fe400078efcffULL, 0x0000004400af7306ULL, 0x000fe20000209400ULL,
0x0000009a004a7245ULL, 0x002fe2000020d400ULL, 0x000100004b9a7824ULL, 0x000fe200078e00ffULL,
0x0000008e8f00720bULL, 0x000fc40003f7d000ULL, 0x000000014a4a5812ULL, 0x000fe400078efcffULL,
0x000000989900720bULL, 0x000fe20003fbd000ULL, 0x0000004400ac7306ULL, 0x0002a20000205400ULL,
0x00000052008f7245ULL, 0x000fe4000020d400ULL, 0x000000aa534d723eULL, 0x000fe400000010ffULL,
0x00000018ff9a7819ULL, 0x000fc6000001149aULL, 0x0000005200ad7306ULL, 0x000fe20000209400ULL,
0x0000a80024447811ULL, 0x002fe400078e20ffULL, 0x0000000165653812ULL, 0x000fe400078efcffULL,
0x0000000194945812ULL, 0x000fc600078efcffULL, 0x0000005200ae7306ULL, 0x0002e20000205400ULL,
0x000000acaf00720bULL, 0x004fce0003f1d000ULL, 0x0000004600967306ULL, 0x000fe20000009400ULL,
0x0000004500527245ULL, 0x002fca000020d400ULL, 0x0000000190900812ULL, 0x000fe400078efcffULL,
0x0000004600977306ULL, 0x000e620000005400ULL, 0x000000aead00720bULL, 0x008fce0003fbd000ULL,
0x0000004700687306ULL, 0x000eac000000d400ULL, 0x000000018f8f5812ULL, 0x000fe400078efcffULL,
0x00000087008a7306ULL, 0x000fe20000209400ULL, 0x000000979600720bULL, 0x002fce0003fdd000ULL,
0x00000087008b7306ULL, 0x0002e20000205400ULL, 0x0000000168684812ULL, 0x004fce00078efcffULL,
0x0000004600697306ULL, 0x000ea2000000d400ULL, 0x0000008700877245ULL, 0x002fce000020d400ULL,
0x0000004500467306ULL, 0x000fe20000209400ULL, 0x0000008b8a00720bULL, 0x008fe40003f9d000ULL,
0x00000086008b7245ULL, 0x000fca000020d400ULL, 0x0000004500477306ULL, 0x000e620000205400ULL,
0x0000000169696812ULL, 0x004fca00078efcffULL, 0x0000000187874812ULL, 0x000fe400078efcffULL,
0x0000005000b27306ULL, 0x000ff00000209400ULL, 0x0000005000bf7306ULL, 0x000ea20000205400ULL,
0x000000474600720bULL, 0x002fc40003f1d000ULL, 0x000000004444783bULL, 0x000e6a0000000200ULL,
0x00000086008c7306ULL, 0x000fec0000209400ULL, 0x0000000152520812ULL, 0x000fc400078efcffULL,
0x00000086008d7306ULL, 0x0007220000205400ULL, 0x000000bfb200720bULL, 0x004fce0003fbd000ULL,
0x000000a600a97306ULL, 0x000fe20000209400ULL, 0x0000005000867245ULL, 0x008fe4000020d400ULL,
0x0000006fa050723eULL, 0x000fc600000010ffULL, 0x0000000186865812ULL, 0x000fe400078efcffULL,
0x000000a600a27306ULL, 0x000ea20000205400ULL, 0x0000008d8c00720bULL, 0x010fce0003fdd000ULL,
0x0000004e007e7306ULL, 0x000fe20000009400ULL, 0x0000001d4444a231ULL, 0x082fe400003400ffULL,
0x0000001d4646a231ULL, 0x000fc600003400ffULL, 0x000000018b8b6812ULL, 0x000fe200078efcffULL,
0x0000001c4545a231ULL, 0x080fe200003400ffULL, 0x0000004e007d7306ULL, 0x000fe20000005400ULL,
0x000000a2a900720bULL, 0x004fe20003f9d000ULL, 0x0000001c4747a231ULL, 0x000fcc00003400ffULL,
0x0000004e005e7306ULL, 0x000fe2000000d400ULL, 0x000000504428723cULL, 0x000bee0000041828ULL,
0x0000004c004e7306ULL, 0x000fe20000209400ULL, 0x000000699050723eULL, 0x020fe400000010ffULL,
0x000000688f51723eULL, 0x000fca00000010ffULL, 0x0000004c00c17306ULL, 0x000e700000205400ULL,
0x000000c200b37306ULL, 0x000ff00000209400ULL, 0x000000c200c87306ULL, 0x0004e20000205400ULL,
0x000000c14e00720bULL, 0x002fc40003f1d000ULL, 0x000000a8a5c1723eULL, 0x000fca00000010ffULL,
0x00000048007b7306ULL, 0x000fe20000009400ULL, 0x000000c200c27245ULL, 0x004fe2000020d400ULL,
0x000000c04434723cULL, 0x000fec0000041834ULL, 0x00000048007c7306ULL, 0x000fe20000005400ULL,
0x000000c8b300720bULL, 0x008fce0003fbd000ULL, 0x0000004800587306ULL, 0x000fec000000d400ULL,
0x00000001c2c25812ULL, 0x000fe400078efcffULL, 0x0000008100887306ULL, 0x000fe20000209400ULL,
0x0000007d7e00720bULL, 0x000fce0003fbd000ULL, 0x0000008100897306ULL, 0x000e6c0000205400ULL,
0x000000015e5e5812ULL, 0x000fe400078efcffULL, 0x000000d800a17306ULL, 0x000ff00000209400ULL,
0x000000d800487306ULL, 0x0004e20000205400ULL, 0x000000898800720bULL, 0x002fc40003fdd000ULL,
0x000000a600897245ULL, 0x000fe4000020d400ULL, 0x0000004c00887245ULL, 0x000fe4000020d400ULL,
0x0000000189894812ULL, 0x000fe200078efcffULL, 0x0000007800827306ULL, 0x000fe20000209400ULL,
0x0000000188880812ULL, 0x000fe400078efcffULL, 0x000000858400720bULL, 0x000fe40003f1d000ULL,
0x000000d800d87245ULL, 0x004fc4000020d400ULL, 0x0000008100857245ULL, 0x000fe2000020d400ULL,
0x0000007800837306ULL, 0x000e620000205400ULL, 0x00000048a100720bULL, 0x008fe40003f7d000ULL,
0x00000079b681723eULL, 0x000fe400000010ffULL, 0x0000007800797245ULL, 0x000fe4000020d400ULL,
0x0000000185856812ULL, 0x000fe200078efcffULL, 0x0000004900767306ULL, 0x000fe20000009400ULL,
0x0000000164640812ULL, 0x000fe200078efcffULL, 0x00000080443c723cULL, 0x000f62000004183cULL,
0x0000007c7b00720bULL, 0x000fc40003f1d000ULL, 0x000000da007b7245ULL, 0x000fe4000020d400ULL,
0x00000001d8d83812ULL, 0x000fe200078efcffULL, 0x0000004900757306ULL, 0x000fe20000005400ULL,
0x000000838200720bULL, 0x002fe40003f9d000ULL, 0x0000007f7a00720bULL, 0x000fe40003fdd000ULL,
0x00000077ba48723eULL, 0x000fe400000010ffULL, 0x0000a800234c7811ULL, 0x000fe200078e20ffULL,
0x0000004900597306ULL, 0x000fe2000000d400ULL, 0x0000000158580812ULL, 0x000fc400078efcffULL,
0x000000658888723eULL, 0x000fe400000010ffULL, 0x000000648989723eULL, 0x000fe400000010ffULL,
0x0000000179794812ULL, 0x000fe200078efcffULL, 0x000000da00497306ULL, 0x000fe20000209400ULL,
0x000000015f5f6812ULL, 0x000fe400078efcffULL, 0x0000006d7000720bULL, 0x000fe40003fdd000ULL,
0x0000007100707245ULL, 0x000fc6000020d400ULL, 0x000000da00987306ULL, 0x000e700000205400ULL,
0x000000db00957306ULL, 0x000fe20000209400ULL, 0x0000000154546812ULL, 0x000fce00078efcffULL,
0x000000db00927306ULL, 0x000ea20000205400ULL, 0x000000984900720bULL, 0x002fe40003f7d000ULL,
0x00000074a349723eULL, 0x000fca00000010ffULL, 0x0000004b00677306ULL, 0x000fec0000009400ULL,
0x000000017b7b3812ULL, 0x000fe400078efcffULL, 0x0000004b00667306ULL, 0x000fe20000005400ULL,
0x000000929500720bULL, 0x004fe40003f9d000ULL, 0x000000757600720bULL, 0x000fc40003f7d000ULL,
0x000000db00767245ULL, 0x000fc6000020d400ULL, 0x0000004b00557306ULL, 0x000fec000000d400ULL,
0x0000000176764812ULL, 0x000fe400078efcffULL, 0x000000c3004b7306ULL, 0x000fe20000209400ULL,
0x0000000159593812ULL, 0x000fce00078efcffULL, 0x000000c3008c7306ULL, 0x0002b00000205400ULL,
0x0000007100737306ULL, 0x000fe20000209400ULL, 0x000000c300c37245ULL, 0x002fce000020d400ULL,
0x0000007100727306ULL, 0x0002e20000205400ULL, 0x0000008c4b00720bULL, 0x004fce0003fbd000ULL,
0x000000bd004e7306ULL, 0x000fe20000209400ULL, 0x000000bd00717245ULL, 0x002fca000020d400ULL,
0x00000001c3c35812ULL, 0x000fe400078efcffULL, 0x000000bd008d7306ULL, 0x000e620000205400ULL,
0x000000727300720bULL, 0x008fe40003f9d000ULL, 0x00000018ff727819ULL, 0x000fe4000001149fULL,
0x000000b74a9f723eULL, 0x000fe400000010ffULL, 0x000000484448723cULL, 0x040b620000041830ULL,
0x0000006a006e7306ULL, 0x000fe20000209400ULL, 0x000000004c30783bULL, 0x0204ea0000000200ULL,
0x0000000170704812ULL, 0x000fe200078efcffULL, 0x0000009e442c723cULL, 0x000f62000004182cULL,
0x0000006a006b7306ULL, 0x0009220000205400ULL, 0x0000008d4e00720bULL, 0x002fc40003fbd000ULL,
0x000000a7944c723eULL, 0x004fe400000010ffULL, 0x000000c37070723eULL, 0x000fc600000010ffULL,
0x000000a400847306ULL, 0x000fe20000209400ULL, 0x0000006a006a7245ULL, 0x010fe2000020d400ULL,
0x0000004c444c723cULL, 0x000b680000041808ULL, 0x0000000171715812ULL, 0x000fe400078efcffULL,
0x000000a4007d7306ULL, 0x000e620000205400ULL, 0x0000006b6e00720bULL, 0x000fe40003f9d000ULL,
0x000000528b08723eULL, 0x020fc400000010ffULL, 0x000000868709723eULL, 0x000fe200000010ffULL,
0x000000504450723cULL, 0x040b640000041804ULL, 0x000000b8007a7306ULL, 0x000fea0000209400ULL,
0x0000005e7b04723eULL, 0x020fe200000010ffULL, 0x000000084444723cULL, 0x000b62000004180cULL,
0x000000016a6a4812ULL, 0x000fe200078efcffULL, 0x000000b8007f7306ULL, 0x0005220000205400ULL,
0x0000007d8400720bULL, 0x002fe20003fbd000ULL, 0x0000001d3030a231ULL, 0x088fe200003400ffULL,
0x000000666700720bULL, 0x000fe20003f9d000ULL, 0x0000001d3232a231ULL, 0x000fe200003400ffULL,
0x000000a400677245ULL, 0x000fe2000020d400ULL, 0x0000001c3131a231ULL, 0x080fe200003400ffULL,
0x000000c28508723eULL, 0x020fe200000010ffULL, 0x000000b500787306ULL, 0x000fe20000209400ULL,
0x000000b800b87245ULL, 0x004fe2000020d400ULL, 0x0000001c3333a231ULL, 0x000fe200003400ffULL,
0x000000d87909723eULL, 0x000fc400000010ffULL, 0x0000005f7605723eULL, 0x000fe400000010ffULL,
0x0000000167675812ULL, 0x000fe200078efcffULL, 0x000000b500757306ULL, 0x0002a20000205400ULL,
0x0000007f7a00720bULL, 0x010fe20003fbd000ULL, 0x00000088300c723cULL, 0x040b62000004183cULL,
0x0000000155554812ULL, 0x000fe400078efcffULL, 0x000000716a71723eULL, 0x000fe400000010ffULL,
0x000000586758723eULL, 0x000fe200000010ffULL, 0x0000006100637306ULL, 0x000fe20000209400ULL,
0x000000b500b57245ULL, 0x002fe2000020d400ULL, 0x000000083008723cULL, 0x000b640000041834ULL,
0x00000061003c7245ULL, 0x020fc4000020d400ULL, 0x00000072003d7245ULL, 0x000fe4000020d400ULL,
0x00000001b8b85812ULL, 0x000fe200078efcffULL, 0x0000006100627306ULL, 0x000e620000205400ULL,
0x000000757800720bULL, 0x004fe20003f1d000ULL, 0x000000043004723cULL, 0x000b620000041848ULL,
0x0000004100367245ULL, 0x000fe4000020d400ULL, 0x00000059b859723eULL, 0x000fc600000010ffULL,
0x0000005c005d7306ULL, 0x000fe40000209400ULL, 0x00000070302c723cULL, 0x040b68000004182cULL,
0x00000001b5b50812ULL, 0x000fe400078efcffULL, 0x0000005c00607306ULL, 0x0004e20000205400ULL,
0x000000626300720bULL, 0x002fe20003fbd000ULL, 0x000000583028723cULL, 0x000b6c0000041828ULL,
0x0000007200737306ULL, 0x000fe20000209400ULL, 0x0000005c005c7245ULL, 0x004fca000020d400ULL,
0x000000013c3c5812ULL, 0x000fe400078efcffULL, 0x0000007200747306ULL, 0x000e620000205400ULL,
0x000000605d00720bULL, 0x008fe40003f1d000ULL, 0x000000b53c3c723eULL, 0x000fca00000010ffULL,
0x0000009d006b7306ULL, 0x000fec0000209400ULL, 0x000000015c5c0812ULL, 0x000fe400078efcffULL,
0x0000009d00687306ULL, 0x0004e20000205400ULL, 0x000000747300720bULL, 0x002fce0003f7d000ULL,
0x0000009c00667306ULL, 0x000fe20000209400ULL, 0x0000009d009d7245ULL, 0x004fca000020d400ULL,
0x000000013d3d3812ULL, 0x000fe400078efcffULL, 0x0000009c00657306ULL, 0x0002a20000205400ULL,
0x000000686b00720bULL, 0x008fe40003fbd000ULL, 0x0000003d5c3d723eULL, 0x000fca00000010ffULL,
0x0000003b005b7306ULL, 0x000fe20000209400ULL, 0x0000009c009c7245ULL, 0x002fe2000020d400ULL,
0x0000003c304c723cULL, 0x000b68000004184cULL, 0x000000019d9d5812ULL, 0x000fe400078efcffULL,
0x0000003b005a7306ULL, 0x000e620000205400ULL, 0x000000656600720bULL, 0x004fe40003f1d000ULL,
0x000000549d54723eULL, 0x000fca00000010ffULL, 0x0000004100577306ULL, 0x000fec0000209400ULL,
0x000000019c9c0812ULL, 0x000fe400078efcffULL, 0x0000004100567306ULL, 0x000ea20000205400ULL,
0x0000005a5b00720bULL, 0x002fe40003f7d000ULL, 0x000000559c55723eULL, 0x000fca00000010ffULL,
0x0000009b00647306ULL, 0x000fe40000209400ULL, 0x000000543050723cULL, 0x000b6c0000041850ULL,
0x0000009b003f7306ULL, 0x0002e20000205400ULL, 0x000000565700720bULL, 0x004fce0003fbd000ULL,
0x0000009a00347306ULL, 0x000fe20000209400ULL, 0x0000009b009b7245ULL, 0x002fca000020d400ULL,
0x0000000136365812ULL, 0x000fe400078efcffULL, 0x0000009a00357306ULL, 0x000e620000205400ULL,
0x0000003f6400720bULL, 0x008fda0003fdd000ULL, 0x000000019b9b6812ULL, 0x000fe400078efcffULL,
0x000000353400720bULL, 0x002fe40003f1d000ULL, 0x0000003b00347245ULL, 0x000fe4000020d400ULL,
0x0000009a00357245ULL, 0x000fe4000020d400ULL, 0x0000000134343812ULL, 0x000fc800078efcffULL,
0x0000009b3434723eULL, 0x000fc600000010ffULL, 0x0000000135350812ULL, 0x000fc800078efcffULL,
0x000000353635723eULL, 0x000fce00000010ffULL, 0x000000343030723cULL, 0x000b620000041844ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff3c7f8cULL, 0x020e62000c80043fULL,
0x000000ffff3e7224ULL, 0x000fce00078e00ffULL, 0x0000000000347805ULL, 0x000fc40000015200ULL,
0x0106bc00ff377984ULL, 0x000ea40000000800ULL, 0x8000000037ff7812ULL, 0x006fe4000780483dULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fcc0000015200ULL,
0x00000036343b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000137377824ULL, 0x000fe200000e0e35ULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff367819ULL, 0x000fc80000011437ULL, 0x0000003b36367211ULL, 0x000fca00078110ffULL,
0x000000ffff377224ULL, 0x000fca00000e0637ULL, 0x0000000236367819ULL, 0x000fc80000001237ULL,
0x000000360000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106bc00ff377984ULL, 0x000e640000000800ULL, 0x8000000037ff7812ULL, 0x002fe4000780483dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000006014357810ULL, 0x000fca0007ffe0ffULL,
0x00006200123c7a24ULL, 0x000fe200078e0235ULL, 0x0000039000009947ULL, 0x000fea0003800000ULL,
0x0000000111377824ULL, 0x000fe200078e021eULL, 0x0000003503347217ULL, 0x000fe20007800000ULL,
0x00000100ff3d7424ULL, 0x000fe200078e00ffULL, 0x000000041e487810ULL, 0x040fe20007ffe0ffULL,
0x00000001373b7824ULL, 0x040fe200078e0202ULL, 0x000000021e467810ULL, 0x000fe20007ffe0ffULL,
0x0000001037447824ULL, 0x000fe200078e00ffULL, 0x000000f016417812ULL, 0x000fe200078ec0ffULL,
0x0000000134367824ULL, 0x000fe400078e0a35ULL, 0x00000001113f7824ULL, 0x000fe200078e0248ULL,
0xfffffff044447812ULL, 0x000fe200078ee23bULL, 0x0000000137347824ULL, 0x000fe200078e023cULL,
0x0000003611367217ULL, 0x040fe20007800000ULL, 0x00000001113b7824ULL, 0x000fc400078e0246ULL,
0x000000013f3e7824ULL, 0x040fe400078e0202ULL, 0x000000103f477824ULL, 0x000fe400078e00ffULL,
0x00005e0034347625ULL, 0x000fc600078e003dULL, 0xfffffff047477812ULL, 0x000fe200078ee23eULL,
0x000000013b377824ULL, 0x040fe200078e0202ULL, 0x00000041343e7210ULL, 0x000fe20007f1e0ffULL,
0x000000103b4a7824ULL, 0x000fe200078e00ffULL, 0x0000c00047477811ULL, 0x000fe200078e20ffULL,
0x000000013b347824ULL, 0x100fe400078e023cULL, 0x00000001363b7824ULL, 0x000fe200078e0a11ULL,
0xfffffff04a457812ULL, 0x000fe200078ee237ULL, 0x000000013f377824ULL, 0x000fe200078e023cULL,
0x000000061e4a7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff3f7224ULL, 0x000fe200000e0635ULL,
0x0000003b4600720cULL, 0x000fe20003f66070ULL, 0x00005e0034347625ULL, 0x000fe200078e003dULL,
0x0000003b1e00720cULL, 0x000fc40003f86070ULL, 0x0000003b4800720cULL, 0x000fe20003f06070ULL,
0x0000000111497824ULL, 0x000fe200078e024aULL, 0x0000004134347210ULL, 0x000fe20007fbe0ffULL,
0x00005e0037367625ULL, 0x000fe200078e003dULL, 0x0000c00045457811ULL, 0x000fc600078e20ffULL,
0x00000001493c7824ULL, 0x040fe200078e023cULL, 0x0000004136367210ULL, 0x000fe20007fde0ffULL,
0x0000000149467824ULL, 0x000fe400078e0202ULL, 0x00005e003c3c7625ULL, 0x000fc800078e003dULL,
0x000000ffff357224ULL, 0x000fe200028e0635ULL, 0x0000003b4a00720cULL, 0x000fe20003fa6070ULL,
0x0000001049497824ULL, 0x000fe200078e00ffULL, 0x0000c000443b7811ULL, 0x000fe200078e20ffULL,
0x000000ffff377224ULL, 0x000fe200030e0637ULL, 0x000000413c3c7210ULL, 0x000fe40007fde0ffULL,
0xfffffff049467812ULL, 0x000fe200078ee246ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e3b7faeULL, 0x0003e4000e101c46ULL, 0x000000ffff3d7224ULL, 0x000fe200030e063dULL,
0x0000c00046417811ULL, 0x000fe200078e20ffULL, 0x0000000034457faeULL, 0x0003e8000d901c46ULL,
0x0000000036477faeULL, 0x0003e8000c101c46ULL, 0x000000003c417faeULL, 0x0003e2000e901c46ULL,
0x000002d000007947ULL, 0x000fea0003800000ULL, 0x0000000111357824ULL, 0x000fc800078e021eULL,
0x0000000135347824ULL, 0x040fe200078e0202ULL, 0x0000000235377810ULL, 0x040fe20007ffe0ffULL,
0x0000001035417824ULL, 0x040fe200078e00ffULL, 0x00000004353f7810ULL, 0x000fc60007ffe0ffULL,
0x0000000137367824ULL, 0x000fe200078e0202ULL, 0xfffffff041417812ULL, 0x000fe200078ee234ULL,
0x00000010373d7824ULL, 0x000fe400078e00ffULL, 0x000000013f3b7824ULL, 0x000fe200078e0202ULL,
0x0000c00041417811ULL, 0x000fe200078e20ffULL, 0x000000103f3e7824ULL, 0x000fe200078e00ffULL,
0xfffffff03d447812ULL, 0x000fe200078ee236ULL, 0x00000100ff3d7424ULL, 0x000fe400078e00ffULL,
0x000000013f367824ULL, 0x100fe200078e023cULL, 0xfffffff03e457812ULL, 0x000fe200078ee23bULL,
0x00000001353e7824ULL, 0x140fe200078e023cULL, 0x0000000635357810ULL, 0x000fe20007ffe0ffULL,
0x0000000137347824ULL, 0x000fe200078e023cULL, 0x000000f0163b7812ULL, 0x000fe200078ec0ffULL,
0x00005e003e3e7625ULL, 0x000fe200078e003dULL, 0x0000c00045457811ULL, 0x000fc600078e20ffULL,
0x00000001353c7824ULL, 0x040fe200078e023cULL, 0x0000003b3e3e7210ULL, 0x000fe20007f7e0ffULL,
0x0000000135467824ULL, 0x040fe400078e0202ULL, 0x0000001035477824ULL, 0x000fe400078e00ffULL,
0x00005e0034347625ULL, 0x000fc600078e003dULL, 0xfffffff047467812ULL, 0x000fe200078ee246ULL,
0x00005e0036367625ULL, 0x000fe200078e003dULL, 0x0000003b34347210ULL, 0x000fe40007f1e0ffULL,
0x0000c00046477811ULL, 0x000fe200078e20ffULL, 0x00005e003c3c7625ULL, 0x000fc800078e003dULL,
0x000000ffff3f7224ULL, 0x000fe200018e063fULL, 0x0000003b36367210ULL, 0x080fe20007f7e0ffULL,
0x000000ffff357224ULL, 0x000fe200000e0635ULL, 0x0000003b3c3c7210ULL, 0x000fe40007f9e0ffULL,
0x0000c000443b7811ULL, 0x000fe200078e20ffULL, 0x000000ffff377224ULL, 0x000fe200018e0637ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e417faeULL, 0x0003e2000b901c46ULL,
0x000000ffff3d7224ULL, 0x000fc600020e063dULL, 0x00000000343b7faeULL, 0x0003e8000b901c46ULL,
0x0000000036457faeULL, 0x0003e8000b901c46ULL, 0x000000003c477faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff347f8cULL, 0x000e64000c80043fULL, 0x000000ffff3b7224ULL, 0x002fc400078e0035ULL,
0x0000000000347805ULL, 0x000fca0000015200ULL, 0x0106b400ff377984ULL, 0x000e640000000800ULL,
0x8000000037ff7812ULL, 0x002fc40007804843ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fcc0000015200ULL,
0x00000036343d7210ULL, 0x000fca0007f1e1ffULL, 0x0000000137377824ULL, 0x000fe200000e0e35ULL,
0x003d09003d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff367819ULL, 0x000fc80000011437ULL, 0x0000003d36367211ULL, 0x000fca00078110ffULL,
0x000000ffff377224ULL, 0x000fca00000e0637ULL, 0x0000000236367819ULL, 0x000fc80000001237ULL,
0x000000360000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106b400ff377984ULL, 0x000e640000000800ULL, 0x8000000037ff7812ULL, 0x002fe40007804843ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000014000007945ULL, 0x000fe20003800000ULL,
0x0000012000002947ULL, 0x000fea0003800000ULL, 0x0000001bff1c723eULL, 0x000fe400000010ffULL,
0x00000002ff357819ULL, 0x000fe40000011602ULL, 0x000054101c347816ULL, 0x000fe2000000001cULL,
0x000145527f007947ULL, 0x000fea000b800000ULL, 0x00001f35341d7589ULL, 0x0002a400000e0000ULL,
0x00000008355b7810ULL, 0x002fe20007ffe0ffULL, 0x000145827f007947ULL, 0x000fea000b800000ULL,
0x00001f5b341c7589ULL, 0x0002e400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000010355b7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff5a7224ULL, 0x000fe200078e0034ULL,
0x0000aea000447802ULL, 0x000fc40000000f00ULL, 0x00014f6000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000018355b7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff5a7224ULL, 0x004fe200078e0034ULL, 0x0000aef000447802ULL, 0x000fc40000000f00ULL,
0x00014f1000007944ULL, 0x008fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000002644783bULL, 0x000f280000004200ULL,
0x000000003848783bULL, 0x000e680000004200ULL, 0x00000000253c783bULL, 0x000ee80000004200ULL,
0x000000002734783bULL, 0x002e620000004200ULL, 0x0000010044a57824ULL, 0x010fe200078e00ffULL,
0x00000018ffbd7819ULL, 0x000fe20000011444ULL, 0x0000004400ba7306ULL, 0x000fe20000009400ULL,
0x00000018ffaa7819ULL, 0x000fe20000011445ULL, 0x0000010047b67824ULL, 0x000fe200078e00ffULL,
0x00000018ffc07819ULL, 0x000fe200000114a5ULL, 0x0000010049da7824ULL, 0x040fe200078e00ffULL,
0x00000018ff767819ULL, 0x000fe20000011449ULL, 0x0001000049dc7824ULL, 0x000fe200078e00ffULL,
0x00000018ffb67819ULL, 0x000fe200000114b6ULL, 0x000000c000c27306ULL, 0x000fe20000209400ULL,
0x0000010046bf7824ULL, 0x040fe200078e00ffULL, 0x00000018ff9c7819ULL, 0x000fe20000011446ULL,
0x0001000047b97824ULL, 0x000fe200078e00ffULL, 0x00000018ff997819ULL, 0x000fe20000011447ULL,
0x0001000046b87824ULL, 0x000fe200078e00ffULL, 0x00000018ffbf7819ULL, 0x000fe200000114bfULL,
0x000001003ca77824ULL, 0x048fe200078e00ffULL, 0x000000c000c57306ULL, 0x000ee20000205400ULL,
0x00000018ffb97819ULL, 0x000fe200000114b9ULL, 0x000001003da57824ULL, 0x040fe200078e00ffULL,
0x00000018ffb87819ULL, 0x000fe200000114b8ULL, 0x000100003ca97824ULL, 0x000fe200078e00ffULL,
0x00000018ffa77819ULL, 0x000fe200000114a7ULL, 0x000100003da87824ULL, 0x000fe200078e00ffULL,
0x00000018ffa57819ULL, 0x000fe200000114a5ULL, 0x0000004400c17306ULL, 0x000f220000005400ULL,
0x00000018ffa97819ULL, 0x000fe200000114a9ULL, 0x000001004add7824ULL, 0x000fe200078e00ffULL,
0x00000018ffa87819ULL, 0x000fe200000114a8ULL, 0x000001004bc77824ULL, 0x000fe200078e00ffULL,
0x00000018ff937819ULL, 0x000fc4000001143cULL, 0x00000018ff907819ULL, 0x000fe2000001143dULL,
0x00000044007e7306ULL, 0x000462000000d400ULL, 0x000000c5c200720bULL, 0x008fe20003f1d000ULL,
0x0001000048c27824ULL, 0x000fe200078e00ffULL, 0x00000018ff877819ULL, 0x000fe2000001143fULL,
0x000100004ac57824ULL, 0x000fe200078e00ffULL, 0x00000018ff8a7819ULL, 0x000fe4000001143eULL,
0x00000018ff817819ULL, 0x000fe20000011448ULL, 0x000000bd00ca7306ULL, 0x000fe20000209400ULL,
0x0001000044447824ULL, 0x004fe200078e00ffULL, 0x000000c1ba00720bULL, 0x010fc40003fdd000ULL,
0x00000018ff5e7819ULL, 0x002fe40000011434ULL, 0x00000018ffc67819ULL, 0x000fe20000011444ULL,
0x0000010045447824ULL, 0x000fe200078e00ffULL, 0x000000bd00cb7306ULL, 0x0002a20000205400ULL,
0x00000018ff6e7819ULL, 0x000fe4000001144aULL, 0x000000c600ba7245ULL, 0x000fe4000020d400ULL,
0x00000018ffce7819ULL, 0x000fe40000011444ULL, 0x000000017e7e6812ULL, 0x000fe200078efcffULL,
0x000000c600c87306ULL, 0x000fe20000209400ULL, 0x000000bd00bd7245ULL, 0x002fc4000020d400ULL,
0x00000018ff577819ULL, 0x000fe40000011435ULL, 0x00000018ff417819ULL, 0x000fe40000011436ULL,
0x00000018ff427819ULL, 0x000fe20000011437ULL, 0x000000c600c97306ULL, 0x000e620000205400ULL,
0x000000cbca00720bULL, 0x004fe40003f7d000ULL, 0x00000018ffdd7819ULL, 0x000fe400000114ddULL,
0x00000018ffc27819ULL, 0x000fc400000114c2ULL, 0x00000018ffc77819ULL, 0x000fe200000114c7ULL,
0x0000004500cc7306ULL, 0x000fe20000009400ULL, 0x00000018ffdc7819ULL, 0x000fe400000114dcULL,
0x00000018ffc57819ULL, 0x000fe400000114c5ULL, 0x00000018ff697819ULL, 0x000fe4000001144bULL,
0x00000001bdbd3812ULL, 0x000fe200078efcffULL, 0x0000004500cd7306ULL, 0x000fe20000005400ULL,
0x000000c9c800720bULL, 0x002fce0003fbd000ULL, 0x0000004500757306ULL, 0x0003ec000000d400ULL,
0x00000001baba5812ULL, 0x000fe400078efcffULL, 0x000000aa00b47306ULL, 0x000fe20000209400ULL,
0x0001000045457824ULL, 0x002fca00078e00ffULL, 0x00000018ffd17819ULL, 0x000fe20000011445ULL,
0x000001003f457824ULL, 0x000fe200078e00ffULL, 0x000000aa00b77306ULL, 0x000e680000205400ULL,
0x00000018ff457819ULL, 0x000fc80000011445ULL, 0x000000ce00cf7306ULL, 0x000ff00000209400ULL,
0x000000ce00d07306ULL, 0x000ea20000205400ULL, 0x000000b7b400720bULL, 0x002fe20003f7d000ULL,
0x0000010034b47824ULL, 0x000fca00078e00ffULL, 0x00000018ffb47819ULL, 0x000fe200000114b4ULL,
0x0000004900837306ULL, 0x000ff00000009400ULL, 0x0000004900847306ULL, 0x000fe20000005400ULL,
0x000000d0cf00720bULL, 0x004fce0003f9d000ULL, 0x00000049005f7306ULL, 0x0003f0000000d400ULL,
0x0000004600ae7306ULL, 0x000fe20000009400ULL, 0x000000c000497245ULL, 0x002fe4000020d400ULL,
0x000000ce00c07245ULL, 0x000fc4000020d400ULL, 0x0000000149490812ULL, 0x000fe400078efcffULL,
0x000000cdcc00720bULL, 0x000fe20003f1d000ULL, 0x0000004600b37306ULL, 0x000e620000005400ULL,
0x00000001c0c04812ULL, 0x000fe400078efcffULL, 0x0000007e497e723eULL, 0x000fca00000010ffULL,
0x000000d100d27306ULL, 0x000fe80000209400ULL, 0x0000000175750812ULL, 0x000fc800078efcffULL,
0x000000d100d37306ULL, 0x000ea20000205400ULL, 0x000000b3ae00720bULL, 0x002fe40003fbd000ULL,
0x000000aa00b37245ULL, 0x000fe4000020d400ULL, 0x000000d100ae7245ULL, 0x000fe4000020d400ULL,
0x00000001b3b33812ULL, 0x000fe200078efcffULL, 0x000000b600d67306ULL, 0x000fe20000209400ULL,
0x00000018ffaa7819ULL, 0x000fce00000114daULL, 0x000000b600d97306ULL, 0x0002e20000205400ULL,
0x000000d3d200720bULL, 0x004fce0003fdd000ULL, 0x0000009c00a17306ULL, 0x000fe20000209400ULL,
0x000000b600b67245ULL, 0x002fca000020d400ULL, 0x00000001aeae6812ULL, 0x000fe400078efcffULL,
0x0000009c00a27306ULL, 0x000e620000205400ULL, 0x000000d9d600720bULL, 0x008fe40003f1d000ULL,
0x000000aeb3b3723eULL, 0x000fca00000010ffULL, 0x000000bf00d47306ULL, 0x000fec0000209400ULL,
0x00000001b6b60812ULL, 0x000fe400078efcffULL, 0x000000bf00d57306ULL, 0x0004e20000205400ULL,
0x000000a2a100720bULL, 0x002fce0003f7d000ULL, 0x0000004600727306ULL, 0x000e62000000d400ULL,
0x000000bf00bf7245ULL, 0x004fce000020d400ULL, 0x000000b900d87306ULL, 0x000fe20000209400ULL,
0x000000d5d400720bULL, 0x008fce0003f9d000ULL, 0x000000b900db7306ULL, 0x0004e20000205400ULL,
0x0000000172725812ULL, 0x002fca00078efcffULL, 0x00000001bfbf4812ULL, 0x000fe400078efcffULL,
0x0000004700a47306ULL, 0x000fe20000009400ULL, 0x000000b900b97245ULL, 0x004fe4000020d400ULL,
0x00000072bf72723eULL, 0x000fca00000010ffULL, 0x0000004700a37306ULL, 0x000e620000005400ULL,
0x000000dbd800720bULL, 0x008fce0003fbd000ULL, 0x0000003c00a07306ULL, 0x000fec0000009400ULL,
0x00000001b9b95812ULL, 0x000fe400078efcffULL, 0x0000003c009d7306ULL, 0x000ea20000005400ULL,
0x000000a3a400720bULL, 0x002fce0003fdd000ULL, 0x000000b800c47306ULL, 0x000ff00000209400ULL,
0x000000b800d77306ULL, 0x0002e20000205400ULL, 0x0000009da000720bULL, 0x004fe40003f1d000ULL,
0x0000009c009d7245ULL, 0x000fc4000020d400ULL, 0x00000099009c7245ULL, 0x000fe4000020d400ULL,
0x000000019d9d3812ULL, 0x000fe200078efcffULL, 0x000000a700bb7306ULL, 0x000fe20000209400ULL,
0x000000b800b87245ULL, 0x002fce000020d400ULL, 0x000000a700bc7306ULL, 0x000e620000205400ULL,
0x000000d7c400720bULL, 0x008fce0003f9d000ULL, 0x00000047006f7306ULL, 0x0004ec000000d400ULL,
0x00000001b8b84812ULL, 0x000fe400078efcffULL, 0x000000a500be7306ULL, 0x000fe20000209400ULL,
0x000000bcbb00720bULL, 0x002fe20003f7d000ULL, 0x000001003e477824ULL, 0x004fe200078e00ffULL,
0x000000b89db8723eULL, 0x000fe200000010ffULL, 0x0001000034bb7824ULL, 0x000fc400078e00ffULL,
0x0000010035bc7824ULL, 0x000fe200078e00ffULL, 0x00000018ff477819ULL, 0x000fe20000011447ULL,
0x000000a500c37306ULL, 0x0002a20000205400ULL, 0x000000016f6f6812ULL, 0x008fe400078efcffULL,
0x00000018ffbc7819ULL, 0x000fe400000114bcULL, 0x00000018ffbb7819ULL, 0x000fc600000114bbULL,
0x0000003d009e7306ULL, 0x000fe20000009400ULL, 0x000000a500a57245ULL, 0x002fce000020d400ULL,
0x0000003d009f7306ULL, 0x000e620000005400ULL, 0x000000c3be00720bULL, 0x004fce0003fbd000ULL,
0x00000099009a7306ULL, 0x000fec0000209400ULL, 0x00000001a5a55812ULL, 0x000fe400078efcffULL,
0x00000099009b7306ULL, 0x0004e20000205400ULL, 0x0000009f9e00720bULL, 0x002fe20003fdd000ULL,
0x00010000359f7824ULL, 0x000fe200078e00ffULL, 0x000000a7009e7245ULL, 0x000fc8000020d400ULL,
0x000000019e9e3812ULL, 0x000fe200078efcffULL, 0x000000a900ad7306ULL, 0x000fe20000209400ULL,
0x0001000037997824ULL, 0x004fca00078e00ffULL, 0x00000018ff997819ULL, 0x000fe40000011499ULL,
0x000000a900b07306ULL, 0x0002a20000205400ULL, 0x0000009b9a00720bULL, 0x008fe20003f9d000ULL,
0x00000100369b7824ULL, 0x000fe400078e00ffULL, 0x00000100379a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff9b7819ULL, 0x000fe2000001149bULL, 0x000000a800b57306ULL, 0x000fe20000209400ULL,
0x000000a900a97245ULL, 0x002fe4000020d400ULL, 0x00000018ff9a7819ULL, 0x000fc6000001149aULL,
0x000000019c9c4812ULL, 0x000fe400078efcffULL, 0x000000a800b27306ULL, 0x0002e20000205400ULL,
0x000000b0ad00720bULL, 0x004fe40003f7d000ULL, 0x000000b99cb9723eULL, 0x000fca00000010ffULL,
0x0000009300977306ULL, 0x000fe20000209400ULL, 0x000000a800a87245ULL, 0x002fca000020d400ULL,
0x00000001a9a93812ULL, 0x000fe400078efcffULL, 0x0000009300987306ULL, 0x000e620000205400ULL,
0x000000b2b500720bULL, 0x008fe40003fbd000ULL, 0x000000babdb2723eULL, 0x000fca00000010ffULL,
0x0000004700af7306ULL, 0x000fec0000209400ULL, 0x00000001a8a85812ULL, 0x000fe400078efcffULL,
0x0000004700ac7306ULL, 0x000ea20000205400ULL, 0x000000989700720bULL, 0x002fce0003f9d000ULL,
0x0000003c006d7306ULL, 0x0002f0000000d400ULL, 0x0000003d006c7306ULL, 0x0008e2000000d400ULL,
0x000100003f3c7824ULL, 0x002fe200078e00ffULL, 0x000000acaf00720bULL, 0x004fc80003f7d000ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000003e00967306ULL, 0x000fe20000009400ULL,
0x000100003e3d7824ULL, 0x010fe200078e00ffULL, 0x000000016d6d0812ULL, 0x008fc800078efcffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000003e00957306ULL, 0x000e620000005400ULL,
0x000000016c6c6812ULL, 0x000fe400078efcffULL, 0x0000006d9e9e723eULL, 0x000fca00000010ffULL,
0x0000004500a67306ULL, 0x000ff00000209400ULL, 0x0000004500ab7306ULL, 0x000ea20000205400ULL,
0x000000959600720bULL, 0x002fce0003f1d000ULL, 0x0000009000917306ULL, 0x000ff00000209400ULL,
0x0000009000947306ULL, 0x000e620000205400ULL, 0x000000aba600720bULL, 0x004fce0003fbd000ULL,
0x0000003f00927306ULL, 0x000ff00000009400ULL, 0x0000003f008f7306ULL, 0x000ea20000005400ULL,
0x000000949100720bULL, 0x002fe40003fdd000ULL, 0x0000009300947245ULL, 0x000fc4000020d400ULL,
0x0000004700917245ULL, 0x000fe4000020d400ULL, 0x0000000194944812ULL, 0x000fe200078efcffULL,
0x00000087008d7306ULL, 0x000fe20000209400ULL, 0x0000000191913812ULL, 0x000fce00078efcffULL,
0x00000087008c7306ULL, 0x0002e20000205400ULL, 0x0000008f9200720bULL, 0x004fe40003f9d000ULL,
0x00000090008f7245ULL, 0x000fc8000020d400ULL, 0x000000018f8f6812ULL, 0x000fe200078efcffULL,
0x0000003e00667306ULL, 0x000522000000d400ULL, 0x0000008700877245ULL, 0x002fe4000020d400ULL,
0x000000a88f8f723eULL, 0x000fca00000010ffULL, 0x0000003f00637306ULL, 0x000e62000000d400ULL,
0x00000100483e7824ULL, 0x004fe200078e00ffULL, 0x0000008c8d00720bULL, 0x008fe40003f7d000ULL,
0x00000045008c7245ULL, 0x000fe4000020d400ULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x0000003d00467306ULL, 0x000fe20000209400ULL, 0x0000a8003a457811ULL, 0x000fe400078e20ffULL,
0x0000000166660812ULL, 0x010fc400078efcffULL, 0x000000018c8c5812ULL, 0x000fe400078efcffULL,
0x0000000187873812ULL, 0x000fe200078efcffULL, 0x0000003d00b17306ULL, 0x0004e20000205400ULL,
0x0000000163634812ULL, 0x002fe400078efcffULL, 0x000000669166723eULL, 0x000fca00000010ffULL,
0x0000003c003f7306ULL, 0x000fe20000209400ULL, 0x0000003d003d7245ULL, 0x004fce000020d400ULL,
0x0000003c00447306ULL, 0x0002a20000205400ULL, 0x000000b14600720bULL, 0x008fce0003f1d000ULL,
0x0000004800897306ULL, 0x000fe20000009400ULL, 0x0000003c003c7245ULL, 0x002fca000020d400ULL,
0x000000013d3d0812ULL, 0x000fe400078efcffULL, 0x0000004800887306ULL, 0x000e620000005400ULL,
0x000000443f00720bULL, 0x004fe40003fbd000ULL, 0x000000004544783bULL, 0x000ea20000000200ULL,
0x0000003e003f7245ULL, 0x000fc8000020d400ULL, 0x0000004800627306ULL, 0x000eec000000d400ULL,
0x000000013c3c5812ULL, 0x000fe400078efcffULL, 0x0000003e00487306ULL, 0x000fe20000209400ULL,
0x000000888900720bULL, 0x002fe40003f1d000ULL, 0x0000003c8749723eULL, 0x000fca00000010ffULL,
0x0000003e00c17306ULL, 0x000e6c0000205400ULL, 0x0000000162620812ULL, 0x008fe400078efcffULL,
0x0000003400777306ULL, 0x000ff00000009400ULL, 0x00000034007a7306ULL, 0x000fe20000005400ULL,
0x000000c14800720bULL, 0x002fe20003f9d000ULL, 0x0000001d4444a231ULL, 0x004fc400003400ffULL,
0x0000001d4646a231ULL, 0x000fe400003400ffULL, 0x0000001c4545a231ULL, 0x080fe400003400ffULL,
0x0000003400587306ULL, 0x0003e2000000d400ULL, 0x0000001c4747a231ULL, 0x000fca00003400ffULL,
0x000000013f3f4812ULL, 0x000fe400078efcffULL, 0x0000004a00827306ULL, 0x000fe20000009400ULL,
0x0000a80039347811ULL, 0x002fe400078e20ffULL, 0x000000848300720bULL, 0x000fe40003f9d000ULL,
0x000000623f3c723eULL, 0x000fc600000010ffULL, 0x0000004a007d7306ULL, 0x000e700000005400ULL,
0x0000004a005d7306ULL, 0x0004e2000000d400ULL, 0x000000015f5f4812ULL, 0x000fce00078efcffULL,
0x00000035007f7306ULL, 0x000fe20000009400ULL, 0x00010000364a7824ULL, 0x004fe200078e00ffULL,
0x0000007d8200720bULL, 0x002fcc0003f1d000ULL, 0x00000035007c7306ULL, 0x000fee0000005400ULL,
0x000000015d5d0812ULL, 0x008fe200078efcffULL, 0x0000003500557306ULL, 0x000ff0000000d400ULL,
0x0000003600737306ULL, 0x000ff00000009400ULL, 0x0000003600747306ULL, 0x000ff00000005400ULL,
0x0000003600547306ULL, 0x000ff0000000d400ULL, 0x0000003700687306ULL, 0x000ff00000009400ULL,
0x0000003700677306ULL, 0x000ff00000005400ULL, 0x0000003700437306ULL, 0x0003f0000000d400ULL,
0x0000008a008e7306ULL, 0x000fe20000209400ULL, 0x000000003434783bULL, 0x002e6e0000000200ULL,
0x0000008a008b7306ULL, 0x0004f00000205400ULL, 0x000000dd00a47306ULL, 0x000fe20000209400ULL,
0x0000008a008a7245ULL, 0x004fce000020d400ULL, 0x000000dd00977306ULL, 0x000ea20000205400ULL,
0x0000008b8e00720bULL, 0x008fce0003fdd000ULL, 0x000000c200c67306ULL, 0x000fec0000209400ULL,
0x000000018a8a6812ULL, 0x000fe400078efcffULL, 0x000000c200b77306ULL, 0x0007220000205400ULL,
0x00000097a400720bULL, 0x004fe20003f9d000ULL, 0x0000001d3434a231ULL, 0x002fc400003400ffULL,
0x0000001d3636a231ULL, 0x000fe400003400ffULL, 0x0000001c3535a231ULL, 0x080fe400003400ffULL,
0x000000aa00a37306ULL, 0x000fe20000209400ULL, 0x0000001c3737a231ULL, 0x000fe200003400ffULL,
0x0000007a7700720bULL, 0x000fe40003f5d000ULL, 0x0000007600777245ULL, 0x000fe4000020d400ULL,
0x000000c200c27245ULL, 0x008fc4000020d400ULL, 0x000000aa00a27306ULL, 0x0002a20000205400ULL,
0x000000b7c600720bULL, 0x010fe20003fdd000ULL, 0x000000b23408723cULL, 0x040fea0000041808ULL,
0x0000000158582812ULL, 0x000fe200078efcffULL, 0x0000008100857306ULL, 0x000fe20000209400ULL,
0x000000aa00aa7245ULL, 0x002fe2000020d400ULL, 0x000000b8342c723cULL, 0x000fe8000004182cULL,
0x00000001c2c26812ULL, 0x000fc400078efcffULL, 0x0000008100867306ULL, 0x0002e20000205400ULL,
0x000000a2a300720bULL, 0x004fce0003f7d000ULL, 0x000000c700957306ULL, 0x000fe20000209400ULL,
0x0000008100817245ULL, 0x002fca000020d400ULL, 0x00000001aaaa3812ULL, 0x000fe400078efcffULL,
0x000000c700927306ULL, 0x0003e20000205400ULL, 0x000000868500720bULL, 0x008fce0003fbd000ULL,
0x0000004b00807306ULL, 0x000fe20000009400ULL, 0x000000c700c77245ULL, 0x002fca000020d400ULL,
0x0000000181815812ULL, 0x000fe400078efcffULL, 0x0000004b00797306ULL, 0x000e700000005400ULL,
0x000000dc00a07306ULL, 0x000ff00000209400ULL, 0x000000dc00a17306ULL, 0x0004e20000205400ULL,
0x000000798000720bULL, 0x002fce0003fdd000ULL, 0x0000007600787306ULL, 0x000fe20000209400ULL,
0x000000dc00dc7245ULL, 0x004fce000020d400ULL, 0x00000076007b7306ULL, 0x0002a20000205400ULL,
0x000000a1a000720bULL, 0x008fce0003f7d000ULL, 0x0000004b005c7306ULL, 0x000722000000d400ULL,
0x000000dd00767245ULL, 0x002fc8000020d400ULL, 0x0000000176764812ULL, 0x000fe400078efcffULL,
0x000000929500720bULL, 0x000fe20003f9d000ULL, 0x0000006e00717306ULL, 0x000fe20000209400ULL,
0x000100004b4b7824ULL, 0x008fe200078e00ffULL, 0x0000007b7800720bULL, 0x004fe40003fbd000ULL,
0x00000001dcdc3812ULL, 0x000fe400078efcffULL, 0x00000018ff4b7819ULL, 0x000fe4000001144bULL,
0x0000006e00707306ULL, 0x0002a20000205400ULL, 0x000000015c5c6812ULL, 0x010fc400078efcffULL,
0x0000007c7f00720bULL, 0x000fe40003f7d000ULL, 0x00000001c7c74812ULL, 0x000fe400078efcffULL,
0x00000075c07f723eULL, 0x000fe200000010ffULL, 0x000000c5008b7306ULL, 0x000fe20000209400ULL,
0x0000006e006e7245ULL, 0x002fe4000020d400ULL, 0x0000000177775812ULL, 0x000fe400078efcffULL,
0x000000747300720bULL, 0x000fe20003fbd000ULL, 0x0000007e340c723cULL, 0x000f62000004180cULL,
0x0000006fb673723eULL, 0x000fe200000010ffULL, 0x000000c5008e7306ULL, 0x0002e20000205400ULL,
0x000000707100720bULL, 0x004fc40003f1d000ULL, 0x0000004b006f7245ULL, 0x000fe4000020d400ULL,
0x00000018ff747819ULL, 0x000fe2000001149fULL, 0x000000723404723cULL, 0x040f620000041804ULL,
0x0000006ca59f723eULL, 0x000fe200000010ffULL, 0x0000004b00487306ULL, 0x000fe20000209400ULL,
0x000000c500c57245ULL, 0x002fe4000020d400ULL, 0x0000000155553812ULL, 0x000fe400078efcffULL,
0x0000000154545812ULL, 0x000fe200078efcffULL, 0x0000009e3428723cULL, 0x000f620000041828ULL,
0x000000016e6e0812ULL, 0x000fe200078efcffULL, 0x0000004b00897306ULL, 0x000e620000205400ULL,
0x0000008e8b00720bULL, 0x008fc40003f9d000ULL, 0x000000a9948e723eULL, 0x000fca00000010ffULL,
0x00000069006b7306ULL, 0x000fe40000209400ULL, 0x0000008e344c723cULL, 0x000f68000004184cULL,
0x00000001c5c54812ULL, 0x000fe400078efcffULL, 0x00000069006a7306ULL, 0x000ea20000205400ULL,
0x000000894800720bULL, 0x002fe40003fdd000ULL, 0x0000003d8a48723eULL, 0x000fc400000010ffULL,
0x0000005faa3d723eULL, 0x000fe400000010ffULL, 0x000000c56e6e723eULL, 0x000fe200000010ffULL,
0x000000b4003e7306ULL, 0x000fec0000209400ULL, 0x000000016f6f6812ULL, 0x000fe400078efcffULL,
0x000000b400797306ULL, 0x000e620000205400ULL, 0x0000006a6b00720bULL, 0x004fc40003f9d000ULL,
0x000000676800720bULL, 0x000fe40003fdd000ULL, 0x0000006900687245ULL, 0x000fe4000020d400ULL,
0x000000b400697245ULL, 0x000fe2000020d400ULL, 0x0000005e00647306ULL, 0x000fe20000209400ULL,
0x000000638c67723eULL, 0x000fe400000010ffULL, 0x00000018ff637819ULL, 0x000fe4000001144aULL,
0x000000483448723cULL, 0x000be20000041830ULL, 0x0000000168684812ULL, 0x000fc400078efcffULL,
0x0000005e00657306ULL, 0x0004e20000205400ULL, 0x000000793e00720bULL, 0x002fe40003f1d000ULL,
0x0000000143436812ULL, 0x000fe400078efcffULL, 0x000000663450723cULL, 0x000b640000041850ULL,
0x0000005d7630723eULL, 0x020fe200000010ffULL, 0x000000bc007b7306ULL, 0x000fe20000209400ULL,
0x0000005e005e7245ULL, 0x004fe4000020d400ULL, 0x0000005cc731723eULL, 0x000fc400000010ffULL,
0x000000c28134723eULL, 0x000fe200000010ffULL, 0x0000003c443c723cULL, 0x040b62000004180cULL,
0x0000000169690812ULL, 0x000fe200078efcffULL, 0x000000bc00807306ULL, 0x0002a20000205400ULL,
0x000000656400720bULL, 0x008fe40003f9d000ULL, 0x000000dc7735723eULL, 0x000fe400000010ffULL,
0x00000099000d7245ULL, 0x020fe2000020d400ULL, 0x000000304430723cULL, 0x000b620000041804ULL,
0x0000006f686f723eULL, 0x000fe200000010ffULL, 0x0000005700617306ULL, 0x000fe20000209400ULL,
0x000000bc00bc7245ULL, 0x002fc4000020d400ULL, 0x000000586958723eULL, 0x000fe400000010ffULL,
0x0000005700047245ULL, 0x020fe2000020d400ULL, 0x000000344434723cULL, 0x040b620000041808ULL,
0x000000015e5e4812ULL, 0x000fe200078efcffULL, 0x0000005700607306ULL, 0x000e620000205400ULL,
0x000000807b00720bULL, 0x004fe40003f1d000ULL, 0x0000004100067245ULL, 0x000fe4000020d400ULL,
0x0000007400097245ULL, 0x020fe2000020d400ULL, 0x0000006e442c723cULL, 0x000b64000004182cULL,
0x000000bb00787306ULL, 0x000fec0000209400ULL, 0x00000001bcbc0812ULL, 0x000fc400078efcffULL,
0x000000bb00757306ULL, 0x0004e20000205400ULL, 0x000000606100720bULL, 0x002fce0003f5d000ULL,
0x0000007400707306ULL, 0x000fe20000209400ULL, 0x000000bb00bb7245ULL, 0x004fca000020d400ULL,
0x0000000104042812ULL, 0x000fe400078efcffULL, 0x0000007400717306ULL, 0x000e620000205400ULL,
0x000000757800720bULL, 0x008fce0003f1d000ULL, 0x0000009b006c7306ULL, 0x000fec0000209400ULL,
0x00000001bbbb0812ULL, 0x000fe400078efcffULL, 0x0000009b006b7306ULL, 0x0004e20000205400ULL,
0x000000717000720bULL, 0x002fe40003f7d000ULL, 0x000000bb5e08723eULL, 0x000fca00000010ffULL,
0x00000041005a7306ULL, 0x000fe20000209400ULL, 0x0000009b009b7245ULL, 0x004fca000020d400ULL,
0x0000000109093812ULL, 0x000fe400078efcffULL, 0x00000041005b7306ULL, 0x000e620000205400ULL,
0x0000006b6c00720bULL, 0x008fe40003f9d000ULL, 0x000000090409723eULL, 0x000fca00000010ffULL,
0x0000004200567306ULL, 0x000fec0000209400ULL, 0x000000019b9b4812ULL, 0x000fe400078efcffULL,
0x0000004200597306ULL, 0x0004e20000205400ULL, 0x0000005b5a00720bULL, 0x002fe40003f1d000ULL,
0x000000549b04723eULL, 0x000fca00000010ffULL, 0x0000009a006a7306ULL, 0x000fe20000209400ULL,
0x0000004200427245ULL, 0x004fca000020d400ULL, 0x0000000106060812ULL, 0x000fe400078efcffULL,
0x0000009a00657306ULL, 0x0002a20000205400ULL, 0x000000595600720bULL, 0x008fe40003f7d000ULL,
0x00000055bc59723eULL, 0x000fca00000010ffULL, 0x0000006300607306ULL, 0x000fe20000209400ULL,
0x0000009a009a7245ULL, 0x002fe2000020d400ULL, 0x000000584428723cULL, 0x000b680000041828ULL,
0x0000000142423812ULL, 0x000fe400078efcffULL, 0x00000063005f7306ULL, 0x0002e20000205400ULL,
0x000000656a00720bULL, 0x004fce0003f5d000ULL, 0x00000099000c7306ULL, 0x000fe20000209400ULL,
0x0000006300637245ULL, 0x002fca000020d400ULL, 0x000000019a9a2812ULL, 0x000fe400078efcffULL,
0x00000099000b7306ULL, 0x000e620000205400ULL, 0x0000005f6000720bULL, 0x008fe40003f9d000ULL,
0x000000439a05723eULL, 0x000fd600000010ffULL, 0x0000000163634812ULL, 0x000fe400078efcffULL,
0x0000000b0c00720bULL, 0x002fe40003fbd000ULL, 0x00000063060c723eULL, 0x000fe200000010ffULL,
0x000000084408723cULL, 0x040b70000004184cULL, 0x000000044404723cULL, 0x000b640000041850ULL,
0x000000010d0d5812ULL, 0x000fc800078efcffULL, 0x0000000d420d723eULL, 0x000fce00000010ffULL,
0x0000000c440c723cULL, 0x000b620000041848ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff427f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000006014427810ULL, 0x002fe20007ffe0ffULL,
0x01069000ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff467224ULL, 0x020fe400078e0043ULL,
0x000000034200720cULL, 0x000fda0003f06070ULL, 0x0000b9e000000947ULL, 0x000fea0003800000ULL,
0x0000000000427805ULL, 0x000fc40000015200ULL, 0x0106bc00ff417984ULL, 0x000e640000000800ULL,
0x8000000041ff7812ULL, 0x002fe40007804846ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff477224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104700780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000447805ULL, 0x000fcc0000015200ULL,
0x0000004442447210ULL, 0x000fca0007f1e1ffULL, 0x0000000145457824ULL, 0x000fe200000e0e43ULL,
0x003d09004400780cULL, 0x000fc80003f06070ULL, 0x000000ff4500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404400780cULL, 0x000fc80003f06070ULL,
0x000000ff4500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff417819ULL, 0x000fc80000011445ULL, 0x0000004441417211ULL, 0x000fca00078110ffULL,
0x000000ffff447224ULL, 0x000fca00000e0645ULL, 0x0000000241417819ULL, 0x000fc80000001244ULL,
0x000000410000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000147477810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106bc00ff417984ULL, 0x000e640000000800ULL, 0x8000000041ff7812ULL, 0x002fe40007804846ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000008014427810ULL, 0x000fca0007ffe0ffULL,
0x0000620012477a24ULL, 0x000fe200078e0242ULL, 0x0000039000009947ULL, 0x000fea0003800000ULL,
0x000000041e507810ULL, 0x040fe20007ffe0ffULL, 0x0000000111437824ULL, 0x000fe200078e021eULL,
0x000000021e4e7810ULL, 0x040fe40007ffe0ffULL, 0x0000004203417217ULL, 0x000fe20007800000ULL,
0x0000000111487824ULL, 0x040fe200078e0250ULL, 0x000000061e527810ULL, 0x000fe20007ffe0ffULL,
0x0000000111457824ULL, 0x000fe400078e024eULL, 0x0000000148497824ULL, 0x000fc400078e0202ULL,
0x00000010484a7824ULL, 0x000fe400078e00ffULL, 0x0000000143447824ULL, 0x040fe400078e0202ULL,
0x00000010434b7824ULL, 0x000fe200078e00ffULL, 0xfffffff04a4f7812ULL, 0x000fe200078ee249ULL,
0x0000000141427824ULL, 0x000fe400078e0a42ULL, 0x0000000145467824ULL, 0x000fe200078e0202ULL,
0xfffffff04b4c7812ULL, 0x000fe200078ee244ULL, 0x00000010454d7824ULL, 0x000fe200078e00ffULL,
0x0000004211447217ULL, 0x000fe20007800000ULL, 0x00000100ff4a7424ULL, 0x000fe200078e00ffULL,
0x000000f0164b7812ULL, 0x000fe200078ec0ffULL, 0x0000000143437824ULL, 0x100fe200078e0247ULL,
0xfffffff04d4d7812ULL, 0x000fe200078ee246ULL, 0x0000000111417824ULL, 0x000fe200078e0252ULL,
0x0000e0004f4f7811ULL, 0x000fe200078e20ffULL, 0x0000000145457824ULL, 0x000fe200078e0247ULL,
0x0000e0004d4d7811ULL, 0x000fe200078e20ffULL, 0x00005e0043427625ULL, 0x000fc800078e004aULL,
0x0000000148467824ULL, 0x100fe200078e0247ULL, 0x0000004b42487210ULL, 0x000fe20007f1e0ffULL,
0x0000000141477824ULL, 0x040fe400078e0247ULL, 0x0000000141497824ULL, 0x040fe400078e0202ULL,
0x0000001041547824ULL, 0x000fe400078e00ffULL, 0x0000000144417824ULL, 0x000fe400078e0a11ULL,
0x00005e0045447625ULL, 0x000fe200078e004aULL, 0xfffffff054517812ULL, 0x000fc400078ee249ULL,
0x000000411e00720cULL, 0x000fe20003f66070ULL, 0x000000ffff497224ULL, 0x000fe200000e0643ULL,
0x0000004b44447210ULL, 0x000fe20007f9e0ffULL, 0x00005e0046427625ULL, 0x080fe200078e004aULL,
0x000000414e00720cULL, 0x080fe40003f46070ULL, 0x000000415000720cULL, 0x000fe20003f06070ULL,
0x00005e0047467625ULL, 0x000fe200078e004aULL, 0x0000004b42427210ULL, 0x000fe40007fbe0ffULL,
0x0000e00051517811ULL, 0x000fe200078e20ffULL, 0x000000ffff457224ULL, 0x000fe200020e0645ULL,
0x000000415200720cULL, 0x000fe20003f86070ULL, 0x000000ffff437224ULL, 0x000fe200028e0643ULL,
0x0000004b46467210ULL, 0x000fc40007fde0ffULL, 0x0000e0004c417811ULL, 0x000fc600078e20ffULL,
0x000000ffff477224ULL, 0x000fe400030e0647ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000048417faeULL, 0x0003e8000d901c46ULL, 0x00000000444d7faeULL, 0x0003e8000d101c46ULL,
0x00000000424f7faeULL, 0x0003e8000c101c46ULL, 0x0000000046517faeULL, 0x0003e2000e101c46ULL,
0x000002d000007947ULL, 0x000fea0003800000ULL, 0x0000000111417824ULL, 0x000fc800078e021eULL,
0x0000000141427824ULL, 0x140fe200078e0202ULL, 0x0000000241437810ULL, 0x040fe20007ffe0ffULL,
0x0000001041497824ULL, 0x040fe200078e00ffULL, 0x0000000441457810ULL, 0x040fe20007ffe0ffULL,
0x0000000141487824ULL, 0x040fe200078e0247ULL, 0x0000000641417810ULL, 0x000fe20007ffe0ffULL,
0x0000000143447824ULL, 0x000fe200078e0202ULL, 0xfffffff0494a7812ULL, 0x000fe200078ee242ULL,
0x00000010434b7824ULL, 0x000fe400078e00ffULL, 0x0000000145467824ULL, 0x000fc400078e0202ULL,
0x00000010454d7824ULL, 0x000fe200078e00ffULL, 0xfffffff04b4c7812ULL, 0x000fe200078ee244ULL,
0x00000100ff4b7424ULL, 0x000fe400078e00ffULL, 0x0000000143427824ULL, 0x000fe200078e0247ULL,
0xfffffff04d4e7812ULL, 0x000fe200078ee246ULL, 0x00005e0048487625ULL, 0x000fe200078e004bULL,
0x000000f0164d7812ULL, 0x000fc600078ec0ffULL, 0x0000000145447824ULL, 0x100fe200078e0247ULL,
0x0000004d48487210ULL, 0x000fe20007f5e0ffULL, 0x0000000141467824ULL, 0x000fe400078e0247ULL,
0x00005e0042427625ULL, 0x000fc800078e004bULL, 0x00005e0044447625ULL, 0x000fe200078e004bULL,
0x0000004d42427210ULL, 0x000fc60007f1e0ffULL, 0x00005e0046467625ULL, 0x000fe200078e004bULL,
0x0000e0004c4b7811ULL, 0x000fc600078e20ffULL, 0x00000001414f7824ULL, 0x040fe200078e0202ULL,
0x0000004d46467210ULL, 0x080fe20007f7e0ffULL, 0x0000001041507824ULL, 0x000fe200078e00ffULL,
0x0000e0004a417811ULL, 0x000fe200078e20ffULL, 0x000000ffff497224ULL, 0x000fe200010e0649ULL,
0x0000004d44447210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff437224ULL, 0x000fe200000e0643ULL,
0xfffffff0504f7812ULL, 0x000fe200078ee24fULL, 0x000000ffff477224ULL, 0x000fe200018e0647ULL,
0x0000e0004e4d7811ULL, 0x000fe200078e20ffULL, 0x000000ffff457224ULL, 0x000fe200010e0645ULL,
0x0000e0004f4f7811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000048417faeULL, 0x0003e8000b901c46ULL, 0x00000000424b7faeULL, 0x0003e8000b901c46ULL,
0x00000000444d7faeULL, 0x0003e8000b901c46ULL, 0x00000000464f7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff507f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106480011467f8cULL, 0x0004e4000c80043fULL, 0x0000000000427805ULL, 0x000fc40000015200ULL,
0x01064c0011417984ULL, 0x000f240000000800ULL, 0x8000000041ff7812ULL, 0x018fc40007804847ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff487224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000447805ULL, 0x000fcc0000015200ULL, 0x0000004442447210ULL, 0x000fca0007f1e1ffULL,
0x0000000145457824ULL, 0x000fe200000e0e43ULL, 0x003d09004400780cULL, 0x000fc80003f06070ULL,
0x000000ff4500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404400780cULL, 0x000fc80003f06070ULL, 0x000000ff4500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff417819ULL, 0x000fc80000011445ULL,
0x0000004441417211ULL, 0x000fca00078110ffULL, 0x000000ffff447224ULL, 0x000fca00000e0645ULL,
0x0000000241417819ULL, 0x000fc80000001244ULL, 0x000000410000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000148487810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01064c0011417984ULL, 0x000ee40000000800ULL,
0x8000000041ff7812ULL, 0x008fe40007804847ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0101000017417984ULL, 0x000ee80000000800ULL, 0x0103000017427984ULL, 0x0004620000000800ULL,
0x000000404100720bULL, 0x008fe20003f1d000ULL, 0x00011ad27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000437806ULL, 0x004fc800000e0100ULL, 0x0000ffff43ff7812ULL, 0x000fe2000780c0ffULL,
0x0000048000007945ULL, 0x000fe20003800000ULL, 0x00000001ff447424ULL, 0x000fc400078e00ffULL,
0x000000ffff527224ULL, 0x000fd200078e0040ULL, 0x0000044000008947ULL, 0x000fea0003800000ULL,
0x000000020000780cULL, 0x000fe40003f05270ULL, 0x000000404100720bULL, 0x000fe20003f54000ULL,
0x00011a927f007947ULL, 0x000fd8000b800000ULL, 0x0000000000467806ULL, 0x000fc400010e0100ULL,
0x0000004140448209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x0000991046457816ULL, 0x000fc600000000ffULL, 0x0105004417008388ULL, 0x0005e20000000800ULL,
0x000000ff4500720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000004140457209ULL, 0x004fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff46ff7812ULL, 0x000fc6000780c0ffULL, 0x8000004540447221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b44447820ULL, 0x000fc80000410000ULL, 0x0000004400487308ULL, 0x000ea40000000800ULL,
0x0000004813137220ULL, 0x004fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff5b7819ULL, 0x000fe20000011602ULL, 0x000119d27f007947ULL, 0x000fea000b800000ULL,
0x00001f5b48447589ULL, 0x0004e400000e0000ULL, 0x000000443c3c7220ULL, 0x088fe20000410000ULL,
0x000000443d3d7220ULL, 0x080fe20000410000ULL, 0x0000004434347220ULL, 0x080fe20000410000ULL,
0x0000004435357220ULL, 0x080fe20000410000ULL, 0x0000004430307220ULL, 0x080fe20000410000ULL,
0x0000004431317220ULL, 0x080fe20000410000ULL, 0x000000442c2c7220ULL, 0x080fe20000410000ULL,
0x000000442d2d7220ULL, 0x080fe20000410000ULL, 0x0000004428287220ULL, 0x080fe20000410000ULL,
0x0000004429297220ULL, 0x080fe20000410000ULL, 0x0000004408087220ULL, 0x080fe20000410000ULL,
0x0000004409097220ULL, 0x080fe20000410000ULL, 0x0000004404047220ULL, 0x080fe20000410000ULL,
0x0000004405057220ULL, 0x080fe20000410000ULL, 0x000000440c0c7220ULL, 0x080fe20000410000ULL,
0x000000440d0d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0046ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008025b7811ULL, 0x006fe200078ff0ffULL, 0x000118c27f007947ULL, 0x000fea000b800000ULL,
0x00001f5b48447589ULL, 0x0002a400000e0000ULL, 0x000000443e3e7220ULL, 0x084fe20000410000ULL,
0x000000443f3f7220ULL, 0x080fe20000410000ULL, 0x0000004436367220ULL, 0x080fe20000410000ULL,
0x0000004437377220ULL, 0x080fe20000410000ULL, 0x0000004432327220ULL, 0x080fe20000410000ULL,
0x0000004433337220ULL, 0x080fe20000410000ULL, 0x000000442e2e7220ULL, 0x080fe20000410000ULL,
0x000000442f2f7220ULL, 0x080fe20000410000ULL, 0x000000442a2a7220ULL, 0x080fe20000410000ULL,
0x000000442b2b7220ULL, 0x080fe20000410000ULL, 0x000000440a0a7220ULL, 0x080fe20000410000ULL,
0x000000440b0b7220ULL, 0x080fe20000410000ULL, 0x0000004406067220ULL, 0x080fe20000410000ULL,
0x0000004407077220ULL, 0x080fe20000410000ULL, 0x000000440e0e7220ULL, 0x080fe20000410000ULL,
0x000000440f0f7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff46ff7812ULL, 0x000fe20007800843ULL, 0x00000001ff447424ULL, 0x000fe200078e00ffULL,
0x0000004140527209ULL, 0x000fd60007810000ULL, 0x8000005241410221ULL, 0x000fe20000010000ULL,
0x00007610ff440816ULL, 0x000fc60000000044ULL, 0x3fb8aa3b41410820ULL, 0x000fc80000410000ULL,
0x00000041001b0308ULL, 0x000ea40000000800ULL, 0x0000001b42420220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001342137221ULL, 0x002fc20000010000ULL,
0x0000000000407805ULL, 0x000fcc0000015200ULL, 0x0106ac00ff427984ULL, 0x000e640000000800ULL,
0x8000000042ff7812ULL, 0x002fe4000780483bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff467224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000427805ULL, 0x000fcc0000015200ULL,
0x0000004240457210ULL, 0x000fca0007f1e1ffULL, 0x0000000143437824ULL, 0x000fe200000e0e41ULL,
0x003d09004500780cULL, 0x000fc80003f06070ULL, 0x000000ff4300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404500780cULL, 0x000fc80003f06070ULL,
0x000000ff4300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff427819ULL, 0x000fc80000011443ULL, 0x0000004542427211ULL, 0x000fca00078110ffULL,
0x000000ffff437224ULL, 0x000fca00000e0643ULL, 0x0000000242427819ULL, 0x000fc80000001243ULL,
0x000000420000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000146467810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106ac00ff427984ULL, 0x000e640000000800ULL, 0x8000000042ff7812ULL, 0x002fe4000780483bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009910443b7816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff3b00720cULL, 0x000fda0003f45270ULL,
0x0000012000002947ULL, 0x000fea0003800000ULL, 0x0000001bff1c723eULL, 0x000fe400000010ffULL,
0x00000002ff407819ULL, 0x000fe40000011602ULL, 0x000054101c3b7816ULL, 0x000fe2000000001cULL,
0x000114a27f007947ULL, 0x000fea000b800000ULL, 0x00001f403b1d7589ULL, 0x0002a400000e0000ULL,
0x00000008405b7810ULL, 0x002fe20007ffe0ffULL, 0x000114d27f007947ULL, 0x000fea000b800000ULL,
0x00001f5b3b1c7589ULL, 0x0002e400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000010405b7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff5a7224ULL, 0x000fe200078e003bULL,
0x0000e14000447802ULL, 0x000fc40000000f00ULL, 0x00011cc000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000018405b7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff5a7224ULL, 0x004fe200078e003bULL, 0x0000e19000447802ULL, 0x000fc40000000f00ULL,
0x00011c7000007944ULL, 0x008fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000001f4c783bULL, 0x000f280000004200ULL,
0x000000002148783bULL, 0x000e680000004200ULL, 0x000000002040783bULL, 0x000ee80000004200ULL,
0x000000002244783bULL, 0x000ea20000004200ULL, 0x0000004c00bd7306ULL, 0x010fe20000009400ULL,
0x00000018ffc07819ULL, 0x000fe2000001144cULL, 0x000001004ca77824ULL, 0x000fe200078e00ffULL,
0x00000018ffa57819ULL, 0x000fe2000001144dULL, 0x000001004fbc7824ULL, 0x040fe200078e00ffULL,
0x00000018ff9e7819ULL, 0x000fe2000001144eULL, 0x000100004fb77824ULL, 0x000fe200078e00ffULL,
0x00000018ffc17819ULL, 0x000fe200000114a7ULL, 0x0000004c00c27306ULL, 0x000f220000005400ULL,
0x00000018ffbc7819ULL, 0x000fe200000114bcULL, 0x000100004eb97824ULL, 0x040fe200078e00ffULL,
0x00000018ffb77819ULL, 0x000fe200000114b7ULL, 0x000001004bdb7824ULL, 0x002fe200078e00ffULL,
0x00000018ff817819ULL, 0x000fe20000011448ULL, 0x000001004eba7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6a7819ULL, 0x000fe2000001144bULL, 0x0000004c00807306ULL, 0x0002a2000000d400ULL,
0x00000018ffb97819ULL, 0x000fe200000114b9ULL, 0x0001000049d87824ULL, 0x000fe200078e00ffULL,
0x00000018ff9a7819ULL, 0x000fe2000001144fULL, 0x0001000041aa7824ULL, 0x008fe200078e00ffULL,
0x00000018ff787819ULL, 0x000fe20000011449ULL, 0x0001000040a77824ULL, 0x000fe200078e00ffULL,
0x00000018ffba7819ULL, 0x000fe200000114baULL, 0x0000004d00cb7306ULL, 0x000fe20000009400ULL,
0x000100004c4c7824ULL, 0x002fe200078e00ffULL, 0x000000c2bd00720bULL, 0x010fe20003f7d000ULL,
0x0000010048bd7824ULL, 0x040fe200078e00ffULL, 0x00000018ffaa7819ULL, 0x000fe200000114aaULL,
0x0001000048c27824ULL, 0x000fe200078e00ffULL, 0x00000018ffc77819ULL, 0x000fe2000001144cULL,
0x000001004d4c7824ULL, 0x000fe200078e00ffULL, 0x0000004d00ce7306ULL, 0x000e620000005400ULL,
0x00000018ffa77819ULL, 0x000fe200000114a7ULL, 0x000001004ada7824ULL, 0x000fe200078e00ffULL,
0x00000018ff937819ULL, 0x000fc40000011440ULL, 0x00000018ffcd7819ULL, 0x000fe2000001144cULL,
0x00010000434c7824ULL, 0x000fe200078e00ffULL, 0x0000000180803812ULL, 0x004fe200078efcffULL,
0x0000004d00797306ULL, 0x0004e2000000d400ULL, 0x00000018ff927819ULL, 0x000fe40000011441ULL,
0x00000018ff3b7819ULL, 0x000fe40000011446ULL, 0x00000018ff877819ULL, 0x000fe40000011443ULL,
0x00000018ff867819ULL, 0x000fe20000011442ULL, 0x000000c000c97306ULL, 0x000fe20000209400ULL,
0x000100004d4d7824ULL, 0x004fe200078e00ffULL, 0x000000cecb00720bULL, 0x002fc40003f9d000ULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x00000018ffd17819ULL, 0x000fe2000001144dULL,
0x00000100414d7824ULL, 0x000fe200078e00ffULL, 0x000000c000cc7306ULL, 0x0002a20000205400ULL,
0x00000018ff717819ULL, 0x000fe4000001144aULL, 0x00000018ffc27819ULL, 0x000fe400000114c2ULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x0000000179794812ULL, 0x008fe200078efcffULL,
0x000000c700c37306ULL, 0x000fe20000209400ULL, 0x000000c000c07245ULL, 0x002fc4000020d400ULL,
0x00000018ffd87819ULL, 0x000fe400000114d8ULL, 0x00000018ff617819ULL, 0x000fe40000011444ULL,
0x00000018ffda7819ULL, 0x000fe200000114daULL, 0x000000c700ca7306ULL, 0x000e620000205400ULL,
0x000000ccc900720bULL, 0x004fe40003f1d000ULL, 0x00000018ff5c7819ULL, 0x000fe40000011445ULL,
0x00000018ffdb7819ULL, 0x000fc400000114dbULL, 0x00000018ff537819ULL, 0x000fe20000011447ULL,
0x000000d100d27306ULL, 0x000fec0000209400ULL, 0x00000001c0c00812ULL, 0x000fe400078efcffULL,
0x000000d100d37306ULL, 0x000ea20000205400ULL, 0x000000cac300720bULL, 0x002fe20003fbd000ULL,
0x0000010049ca7824ULL, 0x000fc400078e00ffULL, 0x000100004ac37824ULL, 0x000fc800078e00ffULL,
0x000000bc00d67306ULL, 0x000fe20000209400ULL, 0x00000018ffc37819ULL, 0x000fce00000114c3ULL,
0x000000bc00d97306ULL, 0x000e620000205400ULL, 0x000000d3d200720bULL, 0x004fce0003f7d000ULL,
0x0000004e00a87306ULL, 0x000ff00000009400ULL, 0x0000004e00a97306ULL, 0x000ea20000005400ULL,
0x000000d9d600720bULL, 0x002fce0003f9d000ULL, 0x000000a500b67306ULL, 0x000ff00000209400ULL,
0x000000a500b37306ULL, 0x0003e20000205400ULL, 0x000000a9a800720bULL, 0x004fe40003f1d000ULL,
0x000000d100a87245ULL, 0x000fc8000020d400ULL, 0x00000001a8a83812ULL, 0x000fe200078efcffULL,
0x0000004f00a37306ULL, 0x000fe20000009400ULL, 0x000000a500a57245ULL, 0x002fce000020d400ULL,
0x0000004f00a67306ULL, 0x000e700000005400ULL, 0x000000c100bf7306ULL, 0x000ff00000209400ULL,
0x000000c100c87306ULL, 0x000ea20000205400ULL, 0x000000a6a300720bULL, 0x002fc40003f7d000ULL,
0x000000bc00a37245ULL, 0x000fe4000020d400ULL, 0x00000018ffa67819ULL, 0x000fe400000114caULL,
0x00000001a3a34812ULL, 0x000fe200078efcffULL, 0x00000048008f7306ULL, 0x000ff00000009400ULL,
0x00000048008e7306ULL, 0x000fe20000005400ULL, 0x000000c8bf00720bULL, 0x004fce0003fdd000ULL,
0x0000004800657306ULL, 0x0003f0000000d400ULL, 0x000000b700c47306ULL, 0x000fe20000209400ULL,
0x00000018ff487819ULL, 0x002fe200000114bdULL, 0x000100004bbd7824ULL, 0x000fca00078e00ffULL,
0x00000018ffbd7819ULL, 0x000fe200000114bdULL, 0x000000b700c57306ULL, 0x0002b00000205400ULL,
0x0000004e00777306ULL, 0x000722000000d400ULL, 0x000000b700b77245ULL, 0x002fce000020d400ULL,
0x0000004b007a7306ULL, 0x000fe20000009400ULL, 0x000000c5c400720bULL, 0x004fe20003f9d000ULL,
0x00000100434e7824ULL, 0x008fca00078e00ffULL, 0x00000018ff4e7819ULL, 0x000fe2000001144eULL,
0x0000004b007f7306ULL, 0x000fe20000005400ULL, 0x0000000177770812ULL, 0x010fca00078efcffULL,
0x00000001b7b74812ULL, 0x000fe400078efcffULL, 0x0000004b005f7306ULL, 0x0003f0000000d400ULL,
0x0000009e00a17306ULL, 0x000fe20000209400ULL, 0x000000c7004b7245ULL, 0x002fc8000020d400ULL,
0x000000014b4b5812ULL, 0x000fe400078efcffULL, 0x000000b3b600720bULL, 0x000fe20003fbd000ULL,
0x0000009e00a47306ULL, 0x0002a20000205400ULL, 0x000000cd00b67245ULL, 0x000fe4000020d400ULL,
0x0000004bc0c0723eULL, 0x000fca00000010ffULL, 0x0000004f00747306ULL, 0x000722000000d400ULL,
0x0000009e009e7245ULL, 0x002fc6000020d400ULL, 0x00000001a5a55812ULL, 0x000fc800078efcffULL,
0x000000b900c67306ULL, 0x000fe20000209400ULL, 0x00000100404f7824ULL, 0x008fe200078e00ffULL,
0x000000a4a100720bULL, 0x004fe20003f1d000ULL, 0x0000010044a47824ULL, 0x000fc600078e00ffULL,
0x00000018ff4f7819ULL, 0x000fe4000001144fULL, 0x000000b900d77306ULL, 0x0002a20000205400ULL,
0x0000000174743812ULL, 0x010fe400078efcffULL, 0x00000018ffa47819ULL, 0x000fc800000114a4ULL,
0x000000019e9e0812ULL, 0x000fe200078efcffULL, 0x000000cd00cf7306ULL, 0x000fe20000209400ULL,
0x000000b900b97245ULL, 0x002fce000020d400ULL, 0x000000cd00d07306ULL, 0x000fe20000205400ULL,
0x000000d7c600720bULL, 0x004fce0003fbd000ULL, 0x0000004d00bb7306ULL, 0x000fec0000209400ULL,
0x00000001b9b95812ULL, 0x000fe400078efcffULL, 0x0000004d00be7306ULL, 0x0002a40000205400ULL,
0x000000b99e9e723eULL, 0x000fcc00000010ffULL, 0x0000004f00b87306ULL, 0x000fe20000209400ULL,
0x0000004d004d7245ULL, 0x002fce000020d400ULL, 0x0000004f00b57306ULL, 0x000e620000205400ULL,
0x000000bebb00720bULL, 0x004fce0003f9d000ULL, 0x0000004900847306ULL, 0x000fec0000009400ULL,
0x000000014d4d4812ULL, 0x000fe400078efcffULL, 0x0000004900857306ULL, 0x000fe20000005400ULL,
0x000000b5b800720bULL, 0x002fe20003f1d000ULL, 0x0001000044b57824ULL, 0x000fc400078e00ffULL,
0x0000010045b87824ULL, 0x000fc600078e00ffULL, 0x00000018ffb57819ULL, 0x000fe200000114b5ULL,
0x0000004900647306ULL, 0x0003e2000000d400ULL, 0x00000018ffb87819ULL, 0x000fce00000114b8ULL,
0x0000009a009c7306ULL, 0x000fe20000209400ULL, 0x000000c100497245ULL, 0x002fc8000020d400ULL,
0x0000000149496812ULL, 0x000fe400078efcffULL, 0x000000d0cf00720bULL, 0x000fe20003fdd000ULL,
0x0000009a009b7306ULL, 0x000e620000205400ULL, 0x000000804980723eULL, 0x000fce00000010ffULL,
0x000000ba00d47306ULL, 0x000fe80000209400ULL, 0x00000001b6b66812ULL, 0x000fc800078efcffULL,
0x000000ba00d57306ULL, 0x0004e20000205400ULL, 0x0000009b9c00720bULL, 0x002fe20003fbd000ULL,
0x00010000469b7824ULL, 0x000fe400078e00ffULL, 0x00000100479c7824ULL, 0x000fc600078e00ffULL,
0x00000018ff9b7819ULL, 0x000fe2000001149bULL, 0x0000004100a07306ULL, 0x000fe20000009400ULL,
0x000000ba00ba7245ULL, 0x004fe4000020d400ULL, 0x00000018ff9c7819ULL, 0x000fca000001149cULL,
0x00000041009d7306ULL, 0x000e620000005400ULL, 0x000000d5d400720bULL, 0x008fce0003fdd000ULL,
0x000000aa00b47306ULL, 0x000fec0000209400ULL, 0x00000001baba6812ULL, 0x000fe400078efcffULL,
0x000000aa00b17306ULL, 0x0004e20000205400ULL, 0x0000009da000720bULL, 0x002fe20003f7d000ULL,
0x00000100469d7824ULL, 0x000fe200078e00ffULL, 0x0000004f00a07245ULL, 0x000fc4000020d400ULL,
0x00000092004f7245ULL, 0x000fe4000020d400ULL, 0x00000001a0a00812ULL, 0x000fe200078efcffULL,
0x000000a700ab7306ULL, 0x000fe20000209400ULL, 0x000000aa00aa7245ULL, 0x004fe4000020d400ULL,
0x00000018ff9d7819ULL, 0x000fca000001149dULL, 0x000000a700b07306ULL, 0x0002a20000205400ULL,
0x000000b1b400720bULL, 0x008fce0003f9d000ULL, 0x00000040009f7306ULL, 0x000fe20000009400ULL,
0x000000a700a77245ULL, 0x002fca000020d400ULL, 0x00000001aaaa4812ULL, 0x000fe400078efcffULL,
0x0000004000a27306ULL, 0x000e620000005400ULL, 0x000000b0ab00720bULL, 0x004fce0003f1d000ULL,
0x00000040006f7306ULL, 0x0004ec000000d400ULL, 0x00000001a7a70812ULL, 0x000fe400078efcffULL,
0x0000009300997306ULL, 0x000fe20000209400ULL, 0x0000010042407824ULL, 0x004fe200078e00ffULL,
0x000000a29f00720bULL, 0x002fe20003fdd000ULL, 0x00010000459f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff407819ULL, 0x000fe40000011440ULL, 0x0000009300987306ULL, 0x000fee0000205400ULL,
0x000000016f6f6812ULL, 0x008fe200078efcffULL, 0x00000041006c7306ULL, 0x0002b0000000d400ULL,
0x0000004300917306ULL, 0x000fe20000009400ULL, 0x0001000042417824ULL, 0x002fca00078e00ffULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x0000004300907306ULL, 0x000e620000005400ULL,
0x000000016c6c3812ULL, 0x004fc800078efcffULL, 0x0000006c4d4d723eULL, 0x000fc600000010ffULL,
0x0000009200957306ULL, 0x000ff00000209400ULL, 0x0000009200947306ULL, 0x000ea20000205400ULL,
0x000000909100720bULL, 0x002fe40003f9d000ULL, 0x0000004000907245ULL, 0x000fca000020d400ULL,
0x0000004600707306ULL, 0x000ff00000009400ULL, 0x00000046006d7306ULL, 0x000fe20000005400ULL,
0x000000949500720bULL, 0x004fe40003f7d000ULL, 0x0000009300947245ULL, 0x000fca000020d400ULL,
0x0000004600547306ULL, 0x0003ec000000d400ULL, 0x000000014f4f3812ULL, 0x000fe400078efcffULL,
0x0000004000af7306ULL, 0x000fe20000209400ULL, 0x0000009a00467245ULL, 0x002fe2000020d400ULL,
0x00010000479a7824ULL, 0x000fe200078e00ffULL, 0x0000008e8f00720bULL, 0x000fc40003f7d000ULL,
0x0000000146465812ULL, 0x000fe400078efcffULL, 0x000000989900720bULL, 0x000fe20003fbd000ULL,
0x0000004000ac7306ULL, 0x0002a20000205400ULL, 0x0000004e008f7245ULL, 0x000fe4000020d400ULL,
0x000000aa4f49723eULL, 0x000fe400000010ffULL, 0x00000018ff9a7819ULL, 0x000fc6000001149aULL,
0x0000004e00ad7306ULL, 0x000fe20000209400ULL, 0x0000b00024407811ULL, 0x002fe400078e20ffULL,
0x0000000165653812ULL, 0x000fe400078efcffULL, 0x0000000194945812ULL, 0x000fc600078efcffULL,
0x0000004e00ae7306ULL, 0x0002e20000205400ULL, 0x000000acaf00720bULL, 0x004fce0003f1d000ULL,
0x0000004200967306ULL, 0x000fe20000009400ULL, 0x00000041004e7245ULL, 0x002fca000020d400ULL,
0x0000000190900812ULL, 0x000fe400078efcffULL, 0x0000004200977306ULL, 0x000e620000005400ULL,
0x000000aead00720bULL, 0x008fce0003fbd000ULL, 0x0000004300687306ULL, 0x000eac000000d400ULL,
0x000000018f8f5812ULL, 0x000fe400078efcffULL, 0x00000087008a7306ULL, 0x000fe20000209400ULL,
0x000000979600720bULL, 0x002fce0003fdd000ULL, 0x00000087008b7306ULL, 0x0002e20000205400ULL,
0x0000000168684812ULL, 0x004fce00078efcffULL, 0x0000004200697306ULL, 0x000ea2000000d400ULL,
0x0000008700877245ULL, 0x002fce000020d400ULL, 0x0000004100427306ULL, 0x000fe20000209400ULL,
0x0000008b8a00720bULL, 0x008fe40003f9d000ULL, 0x00000086008b7245ULL, 0x000fca000020d400ULL,
0x0000004100437306ULL, 0x000e620000205400ULL, 0x0000000169696812ULL, 0x004fca00078efcffULL,
0x0000000187874812ULL, 0x000fe400078efcffULL, 0x0000004c00b27306ULL, 0x000ff00000209400ULL,
0x0000004c00bf7306ULL, 0x000ea20000205400ULL, 0x000000434200720bULL, 0x002fc40003f1d000ULL,
0x000000004040783bULL, 0x000e6a0000000200ULL, 0x00000086008c7306ULL, 0x000fec0000209400ULL,
0x000000014e4e0812ULL, 0x000fc400078efcffULL, 0x00000086008d7306ULL, 0x0007220000205400ULL,
0x000000bfb200720bULL, 0x004fce0003fbd000ULL, 0x000000a600a97306ULL, 0x000fe20000209400ULL,
0x0000004c00867245ULL, 0x008fe4000020d400ULL, 0x0000006fa04c723eULL, 0x000fc600000010ffULL,
0x0000000186865812ULL, 0x000fe400078efcffULL, 0x000000a600a27306ULL, 0x000ea20000205400ULL,
0x0000008d8c00720bULL, 0x010fce0003fdd000ULL, 0x0000004a007e7306ULL, 0x000fe20000009400ULL,
0x0000001d4040a231ULL, 0x082fe400003400ffULL, 0x0000001d4242a231ULL, 0x000fc600003400ffULL,
0x000000018b8b6812ULL, 0x000fe200078efcffULL, 0x0000001c4141a231ULL, 0x080fe200003400ffULL,
0x0000004a007d7306ULL, 0x000fe20000005400ULL, 0x000000a2a900720bULL, 0x004fe20003f9d000ULL,
0x0000001c4343a231ULL, 0x000fcc00003400ffULL, 0x0000004a005e7306ULL, 0x000fe2000000d400ULL,
0x0000004c4028723cULL, 0x000bee0000041828ULL, 0x00000048004a7306ULL, 0x000fe20000209400ULL,
0x00000069904c723eULL, 0x020fe400000010ffULL, 0x000000688f4d723eULL, 0x000fca00000010ffULL,
0x0000004800c17306ULL, 0x000e700000205400ULL, 0x000000c200b37306ULL, 0x000ff00000209400ULL,
0x000000c200c87306ULL, 0x0004e20000205400ULL, 0x000000c14a00720bULL, 0x002fc40003f1d000ULL,
0x000000a8a5c1723eULL, 0x000fca00000010ffULL, 0x00000044007b7306ULL, 0x000fe20000009400ULL,
0x000000c200c27245ULL, 0x004fe2000020d400ULL, 0x000000c04034723cULL, 0x000fec0000041834ULL,
0x00000044007c7306ULL, 0x000fe20000005400ULL, 0x000000c8b300720bULL, 0x008fce0003fbd000ULL,
0x0000004400587306ULL, 0x000fec000000d400ULL, 0x00000001c2c25812ULL, 0x000fe400078efcffULL,
0x0000008100887306ULL, 0x000fe20000209400ULL, 0x0000007d7e00720bULL, 0x000fce0003fbd000ULL,
0x0000008100897306ULL, 0x000e6c0000205400ULL, 0x000000015e5e5812ULL, 0x000fe400078efcffULL,
0x000000d800a17306ULL, 0x000ff00000209400ULL, 0x000000d800447306ULL, 0x0004e20000205400ULL,
0x000000898800720bULL, 0x002fc40003fdd000ULL, 0x000000a600897245ULL, 0x000fe4000020d400ULL,
0x0000004800887245ULL, 0x000fe4000020d400ULL, 0x0000000189894812ULL, 0x000fe200078efcffULL,
0x0000007800827306ULL, 0x000fe20000209400ULL, 0x0000000188880812ULL, 0x000fe400078efcffULL,
0x000000858400720bULL, 0x000fe40003f1d000ULL, 0x000000d800d87245ULL, 0x004fc4000020d400ULL,
0x0000008100857245ULL, 0x000fe2000020d400ULL, 0x0000007800837306ULL, 0x000e620000205400ULL,
0x00000044a100720bULL, 0x008fe40003f7d000ULL, 0x00000079b681723eULL, 0x000fe400000010ffULL,
0x0000007800797245ULL, 0x000fe4000020d400ULL, 0x0000000185856812ULL, 0x000fe200078efcffULL,
0x0000004500767306ULL, 0x000fe20000009400ULL, 0x0000000164640812ULL, 0x000fe200078efcffULL,
0x00000080403c723cULL, 0x000f62000004183cULL, 0x0000007c7b00720bULL, 0x000fc40003f1d000ULL,
0x000000da007b7245ULL, 0x000fe4000020d400ULL, 0x00000001d8d83812ULL, 0x000fe200078efcffULL,
0x0000004500757306ULL, 0x000fe20000005400ULL, 0x000000838200720bULL, 0x002fe40003f9d000ULL,
0x0000007f7a00720bULL, 0x000fe40003fdd000ULL, 0x00000077ba44723eULL, 0x000fe400000010ffULL,
0x0000b00023487811ULL, 0x000fe200078e20ffULL, 0x0000004500597306ULL, 0x000fe2000000d400ULL,
0x0000000158580812ULL, 0x000fc400078efcffULL, 0x000000658888723eULL, 0x000fe400000010ffULL,
0x000000648989723eULL, 0x000fe400000010ffULL, 0x0000000179794812ULL, 0x000fe200078efcffULL,
0x000000da00457306ULL, 0x000fe20000209400ULL, 0x000000015f5f6812ULL, 0x000fe400078efcffULL,
0x0000006d7000720bULL, 0x000fe40003fdd000ULL, 0x0000007100707245ULL, 0x000fc6000020d400ULL,
0x000000da00987306ULL, 0x000e700000205400ULL, 0x000000db00957306ULL, 0x000fe20000209400ULL,
0x0000000154546812ULL, 0x000fce00078efcffULL, 0x000000db00927306ULL, 0x000ea20000205400ULL,
0x000000984500720bULL, 0x002fe40003f7d000ULL, 0x00000074a345723eULL, 0x000fca00000010ffULL,
0x0000004700677306ULL, 0x000fec0000009400ULL, 0x000000017b7b3812ULL, 0x000fe400078efcffULL,
0x0000004700667306ULL, 0x000fe20000005400ULL, 0x000000929500720bULL, 0x004fe40003f9d000ULL,
0x000000757600720bULL, 0x000fc40003f7d000ULL, 0x000000db00767245ULL, 0x000fc6000020d400ULL,
0x0000004700557306ULL, 0x000fec000000d400ULL, 0x0000000176764812ULL, 0x000fe400078efcffULL,
0x000000c300477306ULL, 0x000fe20000209400ULL, 0x0000000159593812ULL, 0x000fce00078efcffULL,
0x000000c3008c7306ULL, 0x0002b00000205400ULL, 0x0000007100737306ULL, 0x000fe20000209400ULL,
0x000000c300c37245ULL, 0x002fce000020d400ULL, 0x0000007100727306ULL, 0x0002e20000205400ULL,
0x0000008c4700720bULL, 0x004fce0003fbd000ULL, 0x000000bd004a7306ULL, 0x000fe20000209400ULL,
0x000000bd00717245ULL, 0x002fca000020d400ULL, 0x00000001c3c35812ULL, 0x000fe400078efcffULL,
0x000000bd008d7306ULL, 0x000e620000205400ULL, 0x000000727300720bULL, 0x008fe40003f9d000ULL,
0x00000018ff727819ULL, 0x000fe4000001149fULL, 0x000000b7469f723eULL, 0x000fe400000010ffULL,
0x000000444044723cULL, 0x040b620000041830ULL, 0x0000006a006e7306ULL, 0x000fe20000209400ULL,
0x000000004830783bULL, 0x0204ea0000000200ULL, 0x0000000170704812ULL, 0x000fe200078efcffULL,
0x0000009e402c723cULL, 0x000f62000004182cULL, 0x0000006a006b7306ULL, 0x0009220000205400ULL,
0x0000008d4a00720bULL, 0x002fc40003fbd000ULL, 0x000000a79448723eULL, 0x004fe400000010ffULL,
0x000000c37070723eULL, 0x000fc600000010ffULL, 0x000000a400847306ULL, 0x000fe20000209400ULL,
0x0000006a006a7245ULL, 0x010fe2000020d400ULL, 0x000000484048723cULL, 0x000b680000041808ULL,
0x0000000171715812ULL, 0x000fe400078efcffULL, 0x000000a4007d7306ULL, 0x000e620000205400ULL,
0x0000006b6e00720bULL, 0x000fe40003f9d000ULL, 0x0000004e8b08723eULL, 0x020fc400000010ffULL,
0x000000868709723eULL, 0x000fe200000010ffULL, 0x0000004c404c723cULL, 0x040b640000041804ULL,
0x000000b8007a7306ULL, 0x000fea0000209400ULL, 0x0000005e7b04723eULL, 0x020fe200000010ffULL,
0x000000084040723cULL, 0x000b62000004180cULL, 0x000000016a6a4812ULL, 0x000fe200078efcffULL,
0x000000b8007f7306ULL, 0x0005220000205400ULL, 0x0000007d8400720bULL, 0x002fe20003fbd000ULL,
0x0000001d3030a231ULL, 0x088fe200003400ffULL, 0x000000666700720bULL, 0x000fe20003f9d000ULL,
0x0000001d3232a231ULL, 0x000fe200003400ffULL, 0x000000a400677245ULL, 0x000fe2000020d400ULL,
0x0000001c3131a231ULL, 0x080fe200003400ffULL, 0x000000c28508723eULL, 0x020fe200000010ffULL,
0x000000b500787306ULL, 0x000fe20000209400ULL, 0x000000b800b87245ULL, 0x004fe2000020d400ULL,
0x0000001c3333a231ULL, 0x000fe200003400ffULL, 0x000000d87909723eULL, 0x000fc400000010ffULL,
0x0000005f7605723eULL, 0x000fe400000010ffULL, 0x0000000167675812ULL, 0x000fe200078efcffULL,
0x000000b500757306ULL, 0x0002a20000205400ULL, 0x0000007f7a00720bULL, 0x010fe20003fbd000ULL,
0x00000088300c723cULL, 0x040b62000004183cULL, 0x0000000155554812ULL, 0x000fe400078efcffULL,
0x000000716a71723eULL, 0x000fe400000010ffULL, 0x000000586758723eULL, 0x000fe200000010ffULL,
0x0000006100637306ULL, 0x000fe20000209400ULL, 0x000000b500b57245ULL, 0x002fe2000020d400ULL,
0x000000083008723cULL, 0x000b640000041834ULL, 0x00000061003c7245ULL, 0x020fc4000020d400ULL,
0x00000072003d7245ULL, 0x000fe4000020d400ULL, 0x00000001b8b85812ULL, 0x000fe200078efcffULL,
0x0000006100627306ULL, 0x000e620000205400ULL, 0x000000757800720bULL, 0x004fe20003f1d000ULL,
0x000000043004723cULL, 0x000b620000041844ULL, 0x0000005300367245ULL, 0x000fe4000020d400ULL,
0x00000059b859723eULL, 0x000fc600000010ffULL, 0x0000005c005d7306ULL, 0x000fe40000209400ULL,
0x00000070302c723cULL, 0x040b68000004182cULL, 0x00000001b5b50812ULL, 0x000fe400078efcffULL,
0x0000005c00607306ULL, 0x0004e20000205400ULL, 0x000000626300720bULL, 0x002fe20003fbd000ULL,
0x000000583028723cULL, 0x000b6c0000041828ULL, 0x0000007200737306ULL, 0x000fe20000209400ULL,
0x0000005c005c7245ULL, 0x004fca000020d400ULL, 0x000000013c3c5812ULL, 0x000fe400078efcffULL,
0x0000007200747306ULL, 0x000e620000205400ULL, 0x000000605d00720bULL, 0x008fe40003f1d000ULL,
0x000000b53c3c723eULL, 0x000fca00000010ffULL, 0x0000009d006b7306ULL, 0x000fec0000209400ULL,
0x000000015c5c0812ULL, 0x000fe400078efcffULL, 0x0000009d00687306ULL, 0x0004e20000205400ULL,
0x000000747300720bULL, 0x002fce0003f7d000ULL, 0x0000009c00667306ULL, 0x000fe20000209400ULL,
0x0000009d009d7245ULL, 0x004fca000020d400ULL, 0x000000013d3d3812ULL, 0x000fe400078efcffULL,
0x0000009c00657306ULL, 0x0002a20000205400ULL, 0x000000686b00720bULL, 0x008fe40003fbd000ULL,
0x0000003d5c3d723eULL, 0x000fca00000010ffULL, 0x0000003b005b7306ULL, 0x000fe20000209400ULL,
0x0000009c009c7245ULL, 0x002fe2000020d400ULL, 0x0000003c3048723cULL, 0x000b680000041848ULL,
0x000000019d9d5812ULL, 0x000fe400078efcffULL, 0x0000003b005a7306ULL, 0x000e620000205400ULL,
0x000000656600720bULL, 0x004fe40003f1d000ULL, 0x000000549d54723eULL, 0x000fca00000010ffULL,
0x0000005300577306ULL, 0x000fec0000209400ULL, 0x000000019c9c0812ULL, 0x000fe400078efcffULL,
0x0000005300567306ULL, 0x000ea20000205400ULL, 0x0000005a5b00720bULL, 0x002fe40003f7d000ULL,
0x000000559c55723eULL, 0x000fca00000010ffULL, 0x0000009b00647306ULL, 0x000fe40000209400ULL,
0x00000054304c723cULL, 0x000b6c000004184cULL, 0x0000009b003f7306ULL, 0x0002e20000205400ULL,
0x000000565700720bULL, 0x004fce0003fbd000ULL, 0x0000009a00347306ULL, 0x000fe20000209400ULL,
0x0000009b009b7245ULL, 0x002fca000020d400ULL, 0x0000000136365812ULL, 0x000fe400078efcffULL,
0x0000009a00357306ULL, 0x000e620000205400ULL, 0x0000003f6400720bULL, 0x008fda0003fdd000ULL,
0x000000019b9b6812ULL, 0x000fe400078efcffULL, 0x000000353400720bULL, 0x002fe40003f1d000ULL,
0x0000003b00347245ULL, 0x000fe4000020d400ULL, 0x0000009a00357245ULL, 0x000fe4000020d400ULL,
0x0000000134343812ULL, 0x000fc800078efcffULL, 0x0000009b3434723eULL, 0x000fc600000010ffULL,
0x0000000135350812ULL, 0x000fc800078efcffULL, 0x000000353635723eULL, 0x000fce00000010ffULL,
0x000000343030723cULL, 0x000b620000041840ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff3c7f8cULL, 0x020e62000c80043fULL, 0x000000ffff3e7224ULL, 0x000fce00078e00ffULL,
0x0000000000347805ULL, 0x000fc40000015200ULL, 0x0106bc00ff377984ULL, 0x000ea40000000800ULL,
0x8000000037ff7812ULL, 0x006fe4000780483dULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fcc0000015200ULL, 0x00000036343b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003b36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106bc00ff377984ULL, 0x000e640000000800ULL,
0x8000000037ff7812ULL, 0x002fe4000780483dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000a014357810ULL, 0x000fca0007ffe0ffULL, 0x00006200123c7a24ULL, 0x000fe200078e0235ULL,
0x0000039000009947ULL, 0x000fea0003800000ULL, 0x0000000111377824ULL, 0x000fe200078e021eULL,
0x0000003503347217ULL, 0x000fe20007800000ULL, 0x00000100ff3d7424ULL, 0x000fe200078e00ffULL,
0x000000041e447810ULL, 0x040fe20007ffe0ffULL, 0x00000001373b7824ULL, 0x040fe200078e0202ULL,
0x000000021e427810ULL, 0x000fe20007ffe0ffULL, 0x0000001037407824ULL, 0x000fe200078e00ffULL,
0x000000f016417812ULL, 0x000fe200078ec0ffULL, 0x0000000134367824ULL, 0x000fe400078e0a35ULL,
0x00000001113f7824ULL, 0x000fe200078e0244ULL, 0xfffffff040407812ULL, 0x000fe200078ee23bULL,
0x0000000137347824ULL, 0x000fe200078e023cULL, 0x0000003611367217ULL, 0x040fe20007800000ULL,
0x00000001113b7824ULL, 0x000fc400078e0242ULL, 0x000000013f3e7824ULL, 0x040fe400078e0202ULL,
0x000000103f457824ULL, 0x000fe400078e00ffULL, 0x00005e0034347625ULL, 0x000fc600078e003dULL,
0xfffffff045457812ULL, 0x000fe200078ee23eULL, 0x000000013b377824ULL, 0x040fe200078e0202ULL,
0x00000041343e7210ULL, 0x000fe20007f1e0ffULL, 0x000000103b467824ULL, 0x000fe200078e00ffULL,
0x0000c00045457811ULL, 0x000fe200078e20ffULL, 0x000000013b347824ULL, 0x100fe400078e023cULL,
0x00000001363b7824ULL, 0x000fe200078e0a11ULL, 0xfffffff046437812ULL, 0x000fe200078ee237ULL,
0x000000013f377824ULL, 0x000fe200078e023cULL, 0x000000061e467810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff3f7224ULL, 0x000fe200000e0635ULL, 0x0000003b4200720cULL, 0x000fe20003f66070ULL,
0x00005e0034347625ULL, 0x000fe200078e003dULL, 0x0000003b1e00720cULL, 0x000fc40003f86070ULL,
0x0000003b4400720cULL, 0x000fe20003f06070ULL, 0x0000000111477824ULL, 0x000fe200078e0246ULL,
0x0000004134347210ULL, 0x000fe20007fbe0ffULL, 0x00005e0037367625ULL, 0x000fe200078e003dULL,
0x0000c00043437811ULL, 0x000fc600078e20ffULL, 0x00000001473c7824ULL, 0x040fe200078e023cULL,
0x0000004136367210ULL, 0x000fe20007fde0ffULL, 0x0000000147427824ULL, 0x000fe400078e0202ULL,
0x00005e003c3c7625ULL, 0x000fc800078e003dULL, 0x000000ffff357224ULL, 0x000fe200028e0635ULL,
0x0000003b4600720cULL, 0x000fe20003fa6070ULL, 0x0000001047477824ULL, 0x000fe200078e00ffULL,
0x0000c000403b7811ULL, 0x000fe200078e20ffULL, 0x000000ffff377224ULL, 0x000fe200030e0637ULL,
0x000000413c3c7210ULL, 0x000fe40007fde0ffULL, 0xfffffff047427812ULL, 0x000fe200078ee242ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e3b7faeULL, 0x0003e4000e101c46ULL,
0x000000ffff3d7224ULL, 0x000fe200030e063dULL, 0x0000c00042417811ULL, 0x000fe200078e20ffULL,
0x0000000034437faeULL, 0x0003e8000d901c46ULL, 0x0000000036457faeULL, 0x0003e8000c101c46ULL,
0x000000003c417faeULL, 0x0003e2000e901c46ULL, 0x000002d000007947ULL, 0x000fea0003800000ULL,
0x0000000111357824ULL, 0x000fc800078e021eULL, 0x0000000135347824ULL, 0x040fe200078e0202ULL,
0x0000000235377810ULL, 0x040fe20007ffe0ffULL, 0x00000010353d7824ULL, 0x040fe200078e00ffULL,
0x00000004353f7810ULL, 0x040fe20007ffe0ffULL, 0x00000001353e7824ULL, 0x040fe200078e023cULL,
0x0000000635357810ULL, 0x000fe20007ffe0ffULL, 0x0000000137367824ULL, 0x000fe200078e0202ULL,
0xfffffff03d407812ULL, 0x000fe200078ee234ULL, 0x0000001037417824ULL, 0x000fe400078e00ffULL,
0x000000013f3b7824ULL, 0x000fc400078e0202ULL, 0x000000103f427824ULL, 0x000fe200078e00ffULL,
0xfffffff041417812ULL, 0x000fe200078ee236ULL, 0x00000100ff3d7424ULL, 0x000fe400078e00ffULL,
0x000000013f367824ULL, 0x100fe200078e023cULL, 0xfffffff042427812ULL, 0x000fe200078ee23bULL,
0x00005e003e3e7625ULL, 0x000fe200078e003dULL, 0x000000f0163b7812ULL, 0x000fe400078ec0ffULL,
0x0000c00041417811ULL, 0x000fe200078e20ffULL, 0x0000000137347824ULL, 0x100fe200078e023cULL,
0x0000003b3e3e7210ULL, 0x000fe20007f7e0ffULL, 0x00000001353c7824ULL, 0x000fc400078e023cULL,
0x0000000135437824ULL, 0x040fe400078e0202ULL, 0x0000001035447824ULL, 0x000fe400078e00ffULL,
0x00005e0034347625ULL, 0x000fc600078e003dULL, 0xfffffff044447812ULL, 0x000fe200078ee243ULL,
0x00005e0036367625ULL, 0x000fe200078e003dULL, 0x0000003b34347210ULL, 0x000fe40007f1e0ffULL,
0x0000c00042437811ULL, 0x000fe200078e20ffULL, 0x00005e003c3c7625ULL, 0x000fe200078e003dULL,
0x0000c00044457811ULL, 0x000fc600078e20ffULL, 0x000000ffff3f7224ULL, 0x000fe200018e063fULL,
0x0000003b36367210ULL, 0x080fe20007f7e0ffULL, 0x000000ffff357224ULL, 0x000fe200000e0635ULL,
0x0000003b3c3c7210ULL, 0x000fe40007f9e0ffULL, 0x0000c000403b7811ULL, 0x000fe200078e20ffULL,
0x000000ffff377224ULL, 0x000fe400018e0637ULL, 0x000000ffff3d7224ULL, 0x000fe400020e063dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e3b7faeULL, 0x0003e8000b901c46ULL,
0x0000000034417faeULL, 0x0003e8000b901c46ULL, 0x0000000036437faeULL, 0x0003e8000b901c46ULL,
0x000000003c457faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff347f8cULL, 0x000e64000c80043fULL,
0x000000ffff3b7224ULL, 0x002fc400078e0035ULL, 0x0000000000347805ULL, 0x000fca0000015200ULL,
0x0106b400ff377984ULL, 0x000e640000000800ULL, 0x8000000037ff7812ULL, 0x002fc40007804851ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fcc0000015200ULL, 0x00000036343d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003d36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106b400ff377984ULL, 0x000e640000000800ULL,
0x8000000037ff7812ULL, 0x002fe40007804851ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000014000007945ULL, 0x000fe20003800000ULL, 0x0000012000002947ULL, 0x000fea0003800000ULL,
0x0000001bff1c723eULL, 0x000fe400000010ffULL, 0x00000002ff357819ULL, 0x000fe40000011602ULL,
0x000054101c347816ULL, 0x000fe2000000001cULL, 0x0000eb027f007947ULL, 0x000fea000b800000ULL,
0x00001f35341d7589ULL, 0x0002a400000e0000ULL, 0x00000008355b7810ULL, 0x002fe20007ffe0ffULL,
0x0000eb327f007947ULL, 0x000fea000b800000ULL, 0x00001f5b341c7589ULL, 0x0002e400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000010355b7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff5a7224ULL, 0x000fe200078e0034ULL, 0x00010b9000447802ULL, 0x000fc40000000f00ULL,
0x0000f27000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000018355b7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff5a7224ULL, 0x004fe200078e0034ULL,
0x00010be000447802ULL, 0x000fc40000000f00ULL, 0x0000f22000007944ULL, 0x008fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000002640783bULL, 0x000f280000004200ULL, 0x000000003844783bULL, 0x000e680000004200ULL,
0x00000000253c783bULL, 0x000ee80000004200ULL, 0x000000002734783bULL, 0x002e620000004200ULL,
0x0000010040a57824ULL, 0x010fe200078e00ffULL, 0x00000018ffbd7819ULL, 0x000fe20000011440ULL,
0x0000004000ba7306ULL, 0x000fe20000009400ULL, 0x00000018ffaa7819ULL, 0x000fe20000011441ULL,
0x0000010043b67824ULL, 0x000fe200078e00ffULL, 0x00000018ffc07819ULL, 0x000fe200000114a5ULL,
0x0000010045da7824ULL, 0x040fe200078e00ffULL, 0x00000018ff767819ULL, 0x000fe20000011445ULL,
0x0001000045dc7824ULL, 0x000fe200078e00ffULL, 0x00000018ffb67819ULL, 0x000fe200000114b6ULL,
0x000000c000c27306ULL, 0x000fe20000209400ULL, 0x0000010042bf7824ULL, 0x040fe200078e00ffULL,
0x00000018ff9c7819ULL, 0x000fe20000011442ULL, 0x0001000043b97824ULL, 0x000fe200078e00ffULL,
0x00000018ff997819ULL, 0x000fe20000011443ULL, 0x0001000042b87824ULL, 0x000fe200078e00ffULL,
0x00000018ffbf7819ULL, 0x000fe200000114bfULL, 0x000001003ca77824ULL, 0x048fe200078e00ffULL,
0x000000c000c57306ULL, 0x000ee20000205400ULL, 0x00000018ffb97819ULL, 0x000fe200000114b9ULL,
0x000001003da57824ULL, 0x040fe200078e00ffULL, 0x00000018ffb87819ULL, 0x000fe200000114b8ULL,
0x000100003ca97824ULL, 0x000fe200078e00ffULL, 0x00000018ffa77819ULL, 0x000fe200000114a7ULL,
0x000100003da87824ULL, 0x000fe200078e00ffULL, 0x00000018ffa57819ULL, 0x000fe200000114a5ULL,
0x0000004000c17306ULL, 0x000f220000005400ULL, 0x00000018ffa97819ULL, 0x000fe200000114a9ULL,
0x0000010046dd7824ULL, 0x000fe200078e00ffULL, 0x00000018ffa87819ULL, 0x000fe200000114a8ULL,
0x0000010047c77824ULL, 0x000fe200078e00ffULL, 0x00000018ff937819ULL, 0x000fc4000001143cULL,
0x00000018ff907819ULL, 0x000fe2000001143dULL, 0x00000040007e7306ULL, 0x000462000000d400ULL,
0x000000c5c200720bULL, 0x008fe20003f1d000ULL, 0x0001000044c27824ULL, 0x000fe200078e00ffULL,
0x00000018ff877819ULL, 0x000fe2000001143fULL, 0x0001000046c57824ULL, 0x000fe200078e00ffULL,
0x00000018ff8a7819ULL, 0x000fe4000001143eULL, 0x00000018ff817819ULL, 0x000fe20000011444ULL,
0x000000bd00ca7306ULL, 0x000fe20000209400ULL, 0x0001000040407824ULL, 0x004fe200078e00ffULL,
0x000000c1ba00720bULL, 0x010fc40003fdd000ULL, 0x00000018ff5e7819ULL, 0x002fe40000011434ULL,
0x00000018ffc67819ULL, 0x000fe20000011440ULL, 0x0000010041407824ULL, 0x000fe200078e00ffULL,
0x000000bd00cb7306ULL, 0x0002a20000205400ULL, 0x00000018ff6e7819ULL, 0x000fe40000011446ULL,
0x000000c600ba7245ULL, 0x000fe4000020d400ULL, 0x00000018ffce7819ULL, 0x000fe40000011440ULL,
0x000000017e7e6812ULL, 0x000fe200078efcffULL, 0x000000c600c87306ULL, 0x000fe20000209400ULL,
0x000000bd00bd7245ULL, 0x002fc4000020d400ULL, 0x00000018ff577819ULL, 0x000fe40000011435ULL,
0x00000018ff507819ULL, 0x000fe40000011436ULL, 0x00000018ff517819ULL, 0x000fe20000011437ULL,
0x000000c600c97306ULL, 0x000e620000205400ULL, 0x000000cbca00720bULL, 0x004fe40003f7d000ULL,
0x00000018ffdd7819ULL, 0x000fe400000114ddULL, 0x00000018ffc27819ULL, 0x000fc400000114c2ULL,
0x00000018ffc77819ULL, 0x000fe200000114c7ULL, 0x0000004100cc7306ULL, 0x000fe20000009400ULL,
0x00000018ffdc7819ULL, 0x000fe400000114dcULL, 0x00000018ffc57819ULL, 0x000fe400000114c5ULL,
0x00000018ff697819ULL, 0x000fe40000011447ULL, 0x00000001bdbd3812ULL, 0x000fe200078efcffULL,
0x0000004100cd7306ULL, 0x000fe20000005400ULL, 0x000000c9c800720bULL, 0x002fce0003fbd000ULL,
0x0000004100757306ULL, 0x0003ec000000d400ULL, 0x00000001baba5812ULL, 0x000fe400078efcffULL,
0x000000aa00b47306ULL, 0x000fe20000209400ULL, 0x0001000041417824ULL, 0x002fca00078e00ffULL,
0x00000018ffd17819ULL, 0x000fe20000011441ULL, 0x000001003f417824ULL, 0x000fe200078e00ffULL,
0x000000aa00b77306ULL, 0x000e680000205400ULL, 0x00000018ff417819ULL, 0x000fc80000011441ULL,
0x000000ce00cf7306ULL, 0x000ff00000209400ULL, 0x000000ce00d07306ULL, 0x000ea20000205400ULL,
0x000000b7b400720bULL, 0x002fe20003f7d000ULL, 0x0000010034b47824ULL, 0x000fca00078e00ffULL,
0x00000018ffb47819ULL, 0x000fe200000114b4ULL, 0x0000004500837306ULL, 0x000ff00000009400ULL,
0x0000004500847306ULL, 0x000fe20000005400ULL, 0x000000d0cf00720bULL, 0x004fce0003f9d000ULL,
0x00000045005f7306ULL, 0x0003f0000000d400ULL, 0x0000004200ae7306ULL, 0x000fe20000009400ULL,
0x000000c000457245ULL, 0x002fe4000020d400ULL, 0x000000ce00c07245ULL, 0x000fc4000020d400ULL,
0x0000000145450812ULL, 0x000fe400078efcffULL, 0x000000cdcc00720bULL, 0x000fe20003f1d000ULL,
0x0000004200b37306ULL, 0x000e620000005400ULL, 0x00000001c0c04812ULL, 0x000fe400078efcffULL,
0x0000007e457e723eULL, 0x000fca00000010ffULL, 0x000000d100d27306ULL, 0x000fe80000209400ULL,
0x0000000175750812ULL, 0x000fc800078efcffULL, 0x000000d100d37306ULL, 0x000ea20000205400ULL,
0x000000b3ae00720bULL, 0x002fe40003fbd000ULL, 0x000000aa00b37245ULL, 0x000fe4000020d400ULL,
0x000000d100ae7245ULL, 0x000fe4000020d400ULL, 0x00000001b3b33812ULL, 0x000fe200078efcffULL,
0x000000b600d67306ULL, 0x000fe20000209400ULL, 0x00000018ffaa7819ULL, 0x000fce00000114daULL,
0x000000b600d97306ULL, 0x0002e20000205400ULL, 0x000000d3d200720bULL, 0x004fce0003fdd000ULL,
0x0000009c00a17306ULL, 0x000fe20000209400ULL, 0x000000b600b67245ULL, 0x002fca000020d400ULL,
0x00000001aeae6812ULL, 0x000fe400078efcffULL, 0x0000009c00a27306ULL, 0x000e620000205400ULL,
0x000000d9d600720bULL, 0x008fe40003f1d000ULL, 0x000000aeb3b3723eULL, 0x000fca00000010ffULL,
0x000000bf00d47306ULL, 0x000fec0000209400ULL, 0x00000001b6b60812ULL, 0x000fe400078efcffULL,
0x000000bf00d57306ULL, 0x0004e20000205400ULL, 0x000000a2a100720bULL, 0x002fce0003f7d000ULL,
0x0000004200727306ULL, 0x000e62000000d400ULL, 0x000000bf00bf7245ULL, 0x004fce000020d400ULL,
0x000000b900d87306ULL, 0x000fe20000209400ULL, 0x000000d5d400720bULL, 0x008fce0003f9d000ULL,
0x000000b900db7306ULL, 0x0004e20000205400ULL, 0x0000000172725812ULL, 0x002fca00078efcffULL,
0x00000001bfbf4812ULL, 0x000fe400078efcffULL, 0x0000004300a47306ULL, 0x000fe20000009400ULL,
0x000000b900b97245ULL, 0x004fe4000020d400ULL, 0x00000072bf72723eULL, 0x000fca00000010ffULL,
0x0000004300a37306ULL, 0x000e620000005400ULL, 0x000000dbd800720bULL, 0x008fce0003fbd000ULL,
0x0000003c00a07306ULL, 0x000fec0000009400ULL, 0x00000001b9b95812ULL, 0x000fe400078efcffULL,
0x0000003c009d7306ULL, 0x000ea20000005400ULL, 0x000000a3a400720bULL, 0x002fce0003fdd000ULL,
0x000000b800c47306ULL, 0x000ff00000209400ULL, 0x000000b800d77306ULL, 0x0002e20000205400ULL,
0x0000009da000720bULL, 0x004fe40003f1d000ULL, 0x0000009c009d7245ULL, 0x000fc4000020d400ULL,
0x00000099009c7245ULL, 0x000fe4000020d400ULL, 0x000000019d9d3812ULL, 0x000fe200078efcffULL,
0x000000a700bb7306ULL, 0x000fe20000209400ULL, 0x000000b800b87245ULL, 0x002fce000020d400ULL,
0x000000a700bc7306ULL, 0x000e620000205400ULL, 0x000000d7c400720bULL, 0x008fce0003f9d000ULL,
0x00000043006f7306ULL, 0x0004ec000000d400ULL, 0x00000001b8b84812ULL, 0x000fe400078efcffULL,
0x000000a500be7306ULL, 0x000fe20000209400ULL, 0x000000bcbb00720bULL, 0x002fe20003f7d000ULL,
0x000001003e437824ULL, 0x004fe200078e00ffULL, 0x000000b89db8723eULL, 0x000fe200000010ffULL,
0x0001000034bb7824ULL, 0x000fc400078e00ffULL, 0x0000010035bc7824ULL, 0x000fe200078e00ffULL,
0x00000018ff437819ULL, 0x000fe20000011443ULL, 0x000000a500c37306ULL, 0x0002a20000205400ULL,
0x000000016f6f6812ULL, 0x008fe400078efcffULL, 0x00000018ffbc7819ULL, 0x000fe400000114bcULL,
0x00000018ffbb7819ULL, 0x000fc600000114bbULL, 0x0000003d009e7306ULL, 0x000fe20000009400ULL,
0x000000a500a57245ULL, 0x002fce000020d400ULL, 0x0000003d009f7306ULL, 0x000e620000005400ULL,
0x000000c3be00720bULL, 0x004fce0003fbd000ULL, 0x00000099009a7306ULL, 0x000fec0000209400ULL,
0x00000001a5a55812ULL, 0x000fe400078efcffULL, 0x00000099009b7306ULL, 0x0004e20000205400ULL,
0x0000009f9e00720bULL, 0x002fe20003fdd000ULL, 0x00010000359f7824ULL, 0x000fe200078e00ffULL,
0x000000a7009e7245ULL, 0x000fc8000020d400ULL, 0x000000019e9e3812ULL, 0x000fe200078efcffULL,
0x000000a900ad7306ULL, 0x000fe20000209400ULL, 0x0001000037997824ULL, 0x004fca00078e00ffULL,
0x00000018ff997819ULL, 0x000fe40000011499ULL, 0x000000a900b07306ULL, 0x0002a20000205400ULL,
0x0000009b9a00720bULL, 0x008fe20003f9d000ULL, 0x00000100369b7824ULL, 0x000fe400078e00ffULL,
0x00000100379a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff9b7819ULL, 0x000fe2000001149bULL,
0x000000a800b57306ULL, 0x000fe20000209400ULL, 0x000000a900a97245ULL, 0x002fe4000020d400ULL,
0x00000018ff9a7819ULL, 0x000fc6000001149aULL, 0x000000019c9c4812ULL, 0x000fe400078efcffULL,
0x000000a800b27306ULL, 0x0002e20000205400ULL, 0x000000b0ad00720bULL, 0x004fe40003f7d000ULL,
0x000000b99cb9723eULL, 0x000fca00000010ffULL, 0x0000009300977306ULL, 0x000fe20000209400ULL,
0x000000a800a87245ULL, 0x002fca000020d400ULL, 0x00000001a9a93812ULL, 0x000fe400078efcffULL,
0x0000009300987306ULL, 0x000e620000205400ULL, 0x000000b2b500720bULL, 0x008fe40003fbd000ULL,
0x000000babdb2723eULL, 0x000fca00000010ffULL, 0x0000004300af7306ULL, 0x000fec0000209400ULL,
0x00000001a8a85812ULL, 0x000fe400078efcffULL, 0x0000004300ac7306ULL, 0x000ea20000205400ULL,
0x000000989700720bULL, 0x002fce0003f9d000ULL, 0x0000003c006d7306ULL, 0x0002f0000000d400ULL,
0x0000003d006c7306ULL, 0x0008e2000000d400ULL, 0x000100003f3c7824ULL, 0x002fe200078e00ffULL,
0x000000acaf00720bULL, 0x004fc80003f7d000ULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000003e00967306ULL, 0x000fe20000009400ULL, 0x000100003e3d7824ULL, 0x010fe200078e00ffULL,
0x000000016d6d0812ULL, 0x008fc800078efcffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000003e00957306ULL, 0x000e620000005400ULL, 0x000000016c6c6812ULL, 0x000fe400078efcffULL,
0x0000006d9e9e723eULL, 0x000fca00000010ffULL, 0x0000004100a67306ULL, 0x000ff00000209400ULL,
0x0000004100ab7306ULL, 0x000ea20000205400ULL, 0x000000959600720bULL, 0x002fce0003f1d000ULL,
0x0000009000917306ULL, 0x000ff00000209400ULL, 0x0000009000947306ULL, 0x000e620000205400ULL,
0x000000aba600720bULL, 0x004fce0003fbd000ULL, 0x0000003f00927306ULL, 0x000ff00000009400ULL,
0x0000003f008f7306ULL, 0x000ea20000005400ULL, 0x000000949100720bULL, 0x002fe40003fdd000ULL,
0x0000009300947245ULL, 0x000fc4000020d400ULL, 0x0000004300917245ULL, 0x000fe4000020d400ULL,
0x0000000194944812ULL, 0x000fe200078efcffULL, 0x00000087008d7306ULL, 0x000fe20000209400ULL,
0x0000000191913812ULL, 0x000fce00078efcffULL, 0x00000087008c7306ULL, 0x0002e20000205400ULL,
0x0000008f9200720bULL, 0x004fe40003f9d000ULL, 0x00000090008f7245ULL, 0x000fc8000020d400ULL,
0x000000018f8f6812ULL, 0x000fe200078efcffULL, 0x0000003e00667306ULL, 0x000522000000d400ULL,
0x0000008700877245ULL, 0x002fe4000020d400ULL, 0x000000a88f8f723eULL, 0x000fca00000010ffULL,
0x0000003f00637306ULL, 0x000e62000000d400ULL, 0x00000100443e7824ULL, 0x004fe200078e00ffULL,
0x0000008c8d00720bULL, 0x008fe40003f7d000ULL, 0x00000041008c7245ULL, 0x000fe4000020d400ULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x0000003d00427306ULL, 0x000fe20000209400ULL,
0x0000b0003a417811ULL, 0x000fe400078e20ffULL, 0x0000000166660812ULL, 0x010fc400078efcffULL,
0x000000018c8c5812ULL, 0x000fe400078efcffULL, 0x0000000187873812ULL, 0x000fe200078efcffULL,
0x0000003d00b17306ULL, 0x0004e20000205400ULL, 0x0000000163634812ULL, 0x002fe400078efcffULL,
0x000000669166723eULL, 0x000fca00000010ffULL, 0x0000003c003f7306ULL, 0x000fe20000209400ULL,
0x0000003d003d7245ULL, 0x004fce000020d400ULL, 0x0000003c00407306ULL, 0x0002a20000205400ULL,
0x000000b14200720bULL, 0x008fce0003f1d000ULL, 0x0000004400897306ULL, 0x000fe20000009400ULL,
0x0000003c003c7245ULL, 0x002fca000020d400ULL, 0x000000013d3d0812ULL, 0x000fe400078efcffULL,
0x0000004400887306ULL, 0x000e620000005400ULL, 0x000000403f00720bULL, 0x004fe40003fbd000ULL,
0x000000004140783bULL, 0x000ea20000000200ULL, 0x0000003e003f7245ULL, 0x000fc8000020d400ULL,
0x0000004400627306ULL, 0x000eec000000d400ULL, 0x000000013c3c5812ULL, 0x000fe400078efcffULL,
0x0000003e00447306ULL, 0x000fe20000209400ULL, 0x000000888900720bULL, 0x002fe40003f1d000ULL,
0x0000003c8745723eULL, 0x000fca00000010ffULL, 0x0000003e00c17306ULL, 0x000e6c0000205400ULL,
0x0000000162620812ULL, 0x008fe400078efcffULL, 0x0000003400777306ULL, 0x000ff00000009400ULL,
0x00000034007a7306ULL, 0x000fe20000005400ULL, 0x000000c14400720bULL, 0x002fe20003f9d000ULL,
0x0000001d4040a231ULL, 0x004fc400003400ffULL, 0x0000001d4242a231ULL, 0x000fe400003400ffULL,
0x0000001c4141a231ULL, 0x080fe400003400ffULL, 0x0000003400587306ULL, 0x0003e2000000d400ULL,
0x0000001c4343a231ULL, 0x000fca00003400ffULL, 0x000000013f3f4812ULL, 0x000fe400078efcffULL,
0x0000004600827306ULL, 0x000fe20000009400ULL, 0x0000b00039347811ULL, 0x002fe400078e20ffULL,
0x000000848300720bULL, 0x000fe40003f9d000ULL, 0x000000623f3c723eULL, 0x000fc600000010ffULL,
0x00000046007d7306ULL, 0x000e700000005400ULL, 0x00000046005d7306ULL, 0x0004e2000000d400ULL,
0x000000015f5f4812ULL, 0x000fce00078efcffULL, 0x00000035007f7306ULL, 0x000fe20000009400ULL,
0x0001000036467824ULL, 0x004fe200078e00ffULL, 0x0000007d8200720bULL, 0x002fcc0003f1d000ULL,
0x00000035007c7306ULL, 0x000fee0000005400ULL, 0x000000015d5d0812ULL, 0x008fe200078efcffULL,
0x0000003500557306ULL, 0x000ff0000000d400ULL, 0x0000003600737306ULL, 0x000ff00000009400ULL,
0x0000003600747306ULL, 0x000ff00000005400ULL, 0x0000003600547306ULL, 0x000ff0000000d400ULL,
0x0000003700687306ULL, 0x000ff00000009400ULL, 0x0000003700677306ULL, 0x000ff00000005400ULL,
0x0000003700537306ULL, 0x0003f0000000d400ULL, 0x0000008a008e7306ULL, 0x000fe20000209400ULL,
0x000000003434783bULL, 0x002e6e0000000200ULL, 0x0000008a008b7306ULL, 0x0004f00000205400ULL,
0x000000dd00a47306ULL, 0x000fe20000209400ULL, 0x0000008a008a7245ULL, 0x004fce000020d400ULL,
0x000000dd00977306ULL, 0x000ea20000205400ULL, 0x0000008b8e00720bULL, 0x008fce0003fdd000ULL,
0x000000c200c67306ULL, 0x000fec0000209400ULL, 0x000000018a8a6812ULL, 0x000fe400078efcffULL,
0x000000c200b77306ULL, 0x0007220000205400ULL, 0x00000097a400720bULL, 0x004fe20003f9d000ULL,
0x0000001d3434a231ULL, 0x002fc400003400ffULL, 0x0000001d3636a231ULL, 0x000fe400003400ffULL,
0x0000001c3535a231ULL, 0x080fe400003400ffULL, 0x000000aa00a37306ULL, 0x000fe20000209400ULL,
0x0000001c3737a231ULL, 0x000fe200003400ffULL, 0x0000007a7700720bULL, 0x000fe40003f5d000ULL,
0x0000007600777245ULL, 0x000fe4000020d400ULL, 0x000000c200c27245ULL, 0x008fc4000020d400ULL,
0x000000aa00a27306ULL, 0x0002a20000205400ULL, 0x000000b7c600720bULL, 0x010fe20003fdd000ULL,
0x000000b23408723cULL, 0x040fea0000041808ULL, 0x0000000158582812ULL, 0x000fe200078efcffULL,
0x0000008100857306ULL, 0x000fe20000209400ULL, 0x000000aa00aa7245ULL, 0x002fe2000020d400ULL,
0x000000b8342c723cULL, 0x000fe8000004182cULL, 0x00000001c2c26812ULL, 0x000fc400078efcffULL,
0x0000008100867306ULL, 0x0002e20000205400ULL, 0x000000a2a300720bULL, 0x004fce0003f7d000ULL,
0x000000c700957306ULL, 0x000fe20000209400ULL, 0x0000008100817245ULL, 0x002fca000020d400ULL,
0x00000001aaaa3812ULL, 0x000fe400078efcffULL, 0x000000c700927306ULL, 0x0003e20000205400ULL,
0x000000868500720bULL, 0x008fce0003fbd000ULL, 0x0000004700807306ULL, 0x000fe20000009400ULL,
0x000000c700c77245ULL, 0x002fca000020d400ULL, 0x0000000181815812ULL, 0x000fe400078efcffULL,
0x0000004700797306ULL, 0x000e700000005400ULL, 0x000000dc00a07306ULL, 0x000ff00000209400ULL,
0x000000dc00a17306ULL, 0x0004e20000205400ULL, 0x000000798000720bULL, 0x002fce0003fdd000ULL,
0x0000007600787306ULL, 0x000fe20000209400ULL, 0x000000dc00dc7245ULL, 0x004fce000020d400ULL,
0x00000076007b7306ULL, 0x0002a20000205400ULL, 0x000000a1a000720bULL, 0x008fce0003f7d000ULL,
0x00000047005c7306ULL, 0x000722000000d400ULL, 0x000000dd00767245ULL, 0x002fc8000020d400ULL,
0x0000000176764812ULL, 0x000fe400078efcffULL, 0x000000929500720bULL, 0x000fe20003f9d000ULL,
0x0000006e00717306ULL, 0x000fe20000209400ULL, 0x0001000047477824ULL, 0x008fe200078e00ffULL,
0x0000007b7800720bULL, 0x004fe40003fbd000ULL, 0x00000001dcdc3812ULL, 0x000fe400078efcffULL,
0x00000018ff477819ULL, 0x000fe40000011447ULL, 0x0000006e00707306ULL, 0x0002a20000205400ULL,
0x000000015c5c6812ULL, 0x010fc400078efcffULL, 0x0000007c7f00720bULL, 0x000fe40003f7d000ULL,
0x00000001c7c74812ULL, 0x000fe400078efcffULL, 0x00000075c07f723eULL, 0x000fe200000010ffULL,
0x000000c5008b7306ULL, 0x000fe20000209400ULL, 0x0000006e006e7245ULL, 0x002fe4000020d400ULL,
0x0000000177775812ULL, 0x000fe400078efcffULL, 0x000000747300720bULL, 0x000fe20003fbd000ULL,
0x0000007e340c723cULL, 0x000f62000004180cULL, 0x0000006fb673723eULL, 0x000fe200000010ffULL,
0x000000c5008e7306ULL, 0x0002e20000205400ULL, 0x000000707100720bULL, 0x004fc40003f1d000ULL,
0x00000047006f7245ULL, 0x000fe4000020d400ULL, 0x00000018ff747819ULL, 0x000fe2000001149fULL,
0x000000723404723cULL, 0x040f620000041804ULL, 0x0000006ca59f723eULL, 0x000fe200000010ffULL,
0x0000004700447306ULL, 0x000fe20000209400ULL, 0x000000c500c57245ULL, 0x002fe4000020d400ULL,
0x0000000155553812ULL, 0x000fe400078efcffULL, 0x0000000154545812ULL, 0x000fe200078efcffULL,
0x0000009e3428723cULL, 0x000f620000041828ULL, 0x000000016e6e0812ULL, 0x000fe200078efcffULL,
0x0000004700897306ULL, 0x000e620000205400ULL, 0x0000008e8b00720bULL, 0x008fc40003f9d000ULL,
0x000000a9948e723eULL, 0x000fca00000010ffULL, 0x00000069006b7306ULL, 0x000fe40000209400ULL,
0x0000008e3448723cULL, 0x000fe80000041848ULL, 0x00000001c5c54812ULL, 0x000fe400078efcffULL,
0x00000069006a7306ULL, 0x000ea20000205400ULL, 0x000000894400720bULL, 0x002fe40003fdd000ULL,
0x0000003d8a44723eULL, 0x000fc400000010ffULL, 0x0000005faa3d723eULL, 0x000fe400000010ffULL,
0x000000c56e6e723eULL, 0x000fe200000010ffULL, 0x000000b4003e7306ULL, 0x000fec0000209400ULL,
0x000000016f6f6812ULL, 0x000fe400078efcffULL, 0x000000b400797306ULL, 0x000e620000205400ULL,
0x0000006a6b00720bULL, 0x004fc40003f9d000ULL, 0x000000676800720bULL, 0x000fe40003fdd000ULL,
0x0000006900687245ULL, 0x000fe4000020d400ULL, 0x000000b400697245ULL, 0x000fe2000020d400ULL,
0x0000005e00647306ULL, 0x000fe20000209400ULL, 0x000000638c67723eULL, 0x000fe400000010ffULL,
0x00000018ff637819ULL, 0x000fe40000011446ULL, 0x000000443444723cULL, 0x000be20000041830ULL,
0x0000000168684812ULL, 0x000fc400078efcffULL, 0x0000005e00657306ULL, 0x0004e20000205400ULL,
0x000000793e00720bULL, 0x002fe40003f1d000ULL, 0x0000000153536812ULL, 0x000fe400078efcffULL,
0x00000066344c723cULL, 0x000b64000004184cULL, 0x0000005d7630723eULL, 0x020fe200000010ffULL,
0x000000bc007b7306ULL, 0x000fe20000209400ULL, 0x0000005e005e7245ULL, 0x004fe4000020d400ULL,
0x0000005cc731723eULL, 0x000fc400000010ffULL, 0x000000c28134723eULL, 0x000fe200000010ffULL,
0x0000003c403c723cULL, 0x040b62000004180cULL, 0x0000000169690812ULL, 0x000fe200078efcffULL,
0x000000bc00807306ULL, 0x0002a20000205400ULL, 0x000000656400720bULL, 0x008fe40003f9d000ULL,
0x000000dc7735723eULL, 0x000fe400000010ffULL, 0x00000051000e7245ULL, 0x020fe2000020d400ULL,
0x000000304030723cULL, 0x000b620000041804ULL, 0x00000099000d7245ULL, 0x000fe2000020d400ULL,
0x0000005700617306ULL, 0x000fe20000209400ULL, 0x000000bc00bc7245ULL, 0x002fc4000020d400ULL,
0x0000006f686f723eULL, 0x000fe400000010ffULL, 0x0000005700047245ULL, 0x020fe2000020d400ULL,
0x000000344034723cULL, 0x040b620000041808ULL, 0x000000015e5e4812ULL, 0x000fe200078efcffULL,
0x0000005700607306ULL, 0x000e620000205400ULL, 0x000000807b00720bULL, 0x004fe40003f1d000ULL,
0x000000586958723eULL, 0x000fe400000010ffULL, 0x0000007400097245ULL, 0x020fe2000020d400ULL,
0x0000006e402c723cULL, 0x000b64000004182cULL, 0x000000bb00787306ULL, 0x000fec0000209400ULL,
0x00000001bcbc0812ULL, 0x000fc400078efcffULL, 0x000000bb00757306ULL, 0x0004e20000205400ULL,
0x000000606100720bULL, 0x002fce0003f5d000ULL, 0x0000007400707306ULL, 0x000fe20000209400ULL,
0x000000bb00bb7245ULL, 0x004fca000020d400ULL, 0x0000000104042812ULL, 0x000fe400078efcffULL,
0x0000007400717306ULL, 0x000e620000205400ULL, 0x000000757800720bULL, 0x008fce0003f1d000ULL,
0x0000009b006c7306ULL, 0x000fec0000209400ULL, 0x00000001bbbb0812ULL, 0x000fe400078efcffULL,
0x0000009b006b7306ULL, 0x0004e20000205400ULL, 0x000000717000720bULL, 0x002fe40003f7d000ULL,
0x000000bb5e08723eULL, 0x000fca00000010ffULL, 0x00000050005a7306ULL, 0x000fe20000209400ULL,
0x0000009b009b7245ULL, 0x004fca000020d400ULL, 0x0000000109093812ULL, 0x000fe400078efcffULL,
0x00000050005b7306ULL, 0x0002a20000205400ULL, 0x0000006b6c00720bULL, 0x008fe40003f9d000ULL,
0x000000090409723eULL, 0x000fca00000010ffULL, 0x0000005100567306ULL, 0x000fe20000209400ULL,
0x0000005000507245ULL, 0x002fca000020d400ULL, 0x000000019b9b4812ULL, 0x000fe400078efcffULL,
0x0000005100597306ULL, 0x000e620000205400ULL, 0x0000005b5a00720bULL, 0x004fe40003f1d000ULL,
0x000000549b04723eULL, 0x000fca00000010ffULL, 0x0000009a006a7306ULL, 0x000fec0000209400ULL,
0x0000000150500812ULL, 0x000fe400078efcffULL, 0x0000009a00657306ULL, 0x0004e20000205400ULL,
0x000000595600720bULL, 0x002fe40003f7d000ULL, 0x00000055bc59723eULL, 0x000fca00000010ffULL,
0x0000006300607306ULL, 0x000fe20000209400ULL, 0x0000009a009a7245ULL, 0x004fe2000020d400ULL,
0x000000584028723cULL, 0x000b680000041828ULL, 0x000000010e0e3812ULL, 0x000fe400078efcffULL,
0x00000063005f7306ULL, 0x0002a20000205400ULL, 0x000000656a00720bULL, 0x008fce0003f5d000ULL,
0x00000099000c7306ULL, 0x000fe20000209400ULL, 0x0000006300637245ULL, 0x002fca000020d400ULL,
0x000000019a9a2812ULL, 0x000fe400078efcffULL, 0x00000099000b7306ULL, 0x000e620000205400ULL,
0x0000005f6000720bULL, 0x004fe40003f9d000ULL, 0x000000539a05723eULL, 0x000fce00000010ffULL,
0x000000044004723cULL, 0x040b68000004184cULL, 0x0000000163634812ULL, 0x000fe400078efcffULL,
0x0000000b0c00720bULL, 0x002fe40003fbd000ULL, 0x00000063500c723eULL, 0x000fe200000010ffULL,
0x000000084008723cULL, 0x000b740000041848ULL, 0x000000010d0d5812ULL, 0x000fc800078efcffULL,
0x0000000d0e0d723eULL, 0x000fce00000010ffULL, 0x0000000c400c723cULL, 0x000b620000041844ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff407f8cULL, 0x020e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000a014407810ULL, 0x002fe20007ffe0ffULL, 0x01069800ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff467224ULL, 0x000fe400078e0041ULL, 0x000000034000720cULL, 0x000fe20003f06070ULL,
0x000000ffff407224ULL, 0x000fd800078e0052ULL, 0x00005ce000000947ULL, 0x000fea0003800000ULL,
0x0000000000407805ULL, 0x000fc40000015200ULL, 0x0106bc00ff437984ULL, 0x000e640000000800ULL,
0x8000000043ff7812ULL, 0x002fe40007804846ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff447224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000427805ULL, 0x000fcc0000015200ULL,
0x0000004240457210ULL, 0x000fca0007f1e1ffULL, 0x0000000143437824ULL, 0x000fe200000e0e41ULL,
0x003d09004500780cULL, 0x000fc80003f06070ULL, 0x000000ff4300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404500780cULL, 0x000fc80003f06070ULL,
0x000000ff4300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff427819ULL, 0x000fc80000011443ULL, 0x0000004542427211ULL, 0x000fca00078110ffULL,
0x000000ffff437224ULL, 0x000fca00000e0643ULL, 0x0000000242427819ULL, 0x000fc80000001243ULL,
0x000000420000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000144447810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106bc00ff437984ULL, 0x000e640000000800ULL, 0x8000000043ff7812ULL, 0x002fe40007804846ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000c014417810ULL, 0x000fca0007ffe0ffULL,
0x0000620012437a24ULL, 0x000fe200078e0241ULL, 0x0000039000009947ULL, 0x000fea0003800000ULL,
0x000000021e4a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000111427824ULL, 0x000fe200078e021eULL,
0x000000041e4e7810ULL, 0x040fe40007ffe0ffULL, 0x0000004103407217ULL, 0x000fe20007800000ULL,
0x0000000111447824ULL, 0x040fe200078e024aULL, 0x000000061e507810ULL, 0x000fe20007ffe0ffULL,
0x0000000111467824ULL, 0x000fe200078e024eULL, 0x000000f0164b7812ULL, 0x000fe200078ec0ffULL,
0x0000000140407824ULL, 0x000fc400078e0a41ULL, 0x0000000144457824ULL, 0x140fe400078e0202ULL,
0x00000010444c7824ULL, 0x000fe200078e00ffULL, 0x0000004011407217ULL, 0x040fe20007800000ULL,
0x0000000142417824ULL, 0x140fe400078e0202ULL, 0x0000001042487824ULL, 0x000fe200078e00ffULL,
0xfffffff04c4c7812ULL, 0x000fe200078ee245ULL, 0x0000000146477824ULL, 0x040fe400078e0202ULL,
0x0000001046547824ULL, 0x000fe200078e00ffULL, 0xfffffff048487812ULL, 0x000fe200078ee241ULL,
0x0000000111457824ULL, 0x000fc400078e0250ULL, 0x0000000142417824ULL, 0x000fe200078e0243ULL,
0xfffffff0544d7812ULL, 0x000fe200078ee247ULL, 0x00000100ff477424ULL, 0x000fe400078e00ffULL,
0x0000000144427824ULL, 0x100fe200078e0243ULL, 0x0000e0004d4d7811ULL, 0x000fe200078e20ffULL,
0x0000000146447824ULL, 0x100fe400078e0243ULL, 0x0000000145467824ULL, 0x040fe400078e0243ULL,
0x0000000145437824ULL, 0x000fc400078e0202ULL, 0x0000001045547824ULL, 0x000fe400078e00ffULL,
0x0000000140497824ULL, 0x000fe400078e0a11ULL, 0x00005e0041407625ULL, 0x000fe200078e0047ULL,
0xfffffff0544f7812ULL, 0x000fe400078ee243ULL, 0x000000491e00720cULL, 0x000fe20003f66070ULL,
0x00005e0042427625ULL, 0x000fe200078e0047ULL, 0x0000004b40407210ULL, 0x000fe40007fbe0ffULL,
0x000000494a00720cULL, 0x000fe20003f46070ULL, 0x00005e0044447625ULL, 0x000fe200078e0047ULL,
0x000000494e00720cULL, 0x000fc40003f26070ULL, 0x000000495000720cULL, 0x000fe20003f06070ULL,
0x00005e0046467625ULL, 0x000fe200078e0047ULL, 0x0000004b42427210ULL, 0x080fe40007f9e0ffULL,
0x0000e00048497811ULL, 0x000fe200078e20ffULL, 0x000000ffff417224ULL, 0x000fe200028e0641ULL,
0x0000004b44447210ULL, 0x080fe20007fbe0ffULL, 0x000000ffff437224ULL, 0x000fe200020e0643ULL,
0x0000004b46467210ULL, 0x000fe40007fde0ffULL, 0x0000e0004c4b7811ULL, 0x000fe200078e20ffULL,
0x000000ffff457224ULL, 0x000fe200028e0645ULL, 0x0000e0004f4f7811ULL, 0x000fe200078e20ffULL,
0x000000ffff477224ULL, 0x000fe200030e0647ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000040497faeULL, 0x0003e8000d901c46ULL, 0x00000000424b7faeULL, 0x0003e8000d101c46ULL,
0x00000000444d7faeULL, 0x0003e8000c901c46ULL, 0x00000000464f7faeULL, 0x0003e2000c101c46ULL,
0x000002d000007947ULL, 0x000fea0003800000ULL, 0x0000000111407824ULL, 0x000fc800078e021eULL,
0x0000000140417824ULL, 0x140fe200078e0202ULL, 0x0000000440477810ULL, 0x040fe20007ffe0ffULL,
0x0000001040487824ULL, 0x040fe200078e00ffULL, 0x0000000240427810ULL, 0x040fe20007ffe0ffULL,
0x0000000140467824ULL, 0x000fe400078e0243ULL, 0x0000000147457824ULL, 0x140fe200078e0202ULL,
0xfffffff048487812ULL, 0x000fe200078ee241ULL, 0x00000010474c7824ULL, 0x000fe200078e00ffULL,
0x0000000640417810ULL, 0x000fe20007ffe0ffULL, 0x0000000142447824ULL, 0x000fc400078e0202ULL,
0x0000001042497824ULL, 0x000fe200078e00ffULL, 0xfffffff04c4c7812ULL, 0x000fe200078ee245ULL,
0x00000100ff457424ULL, 0x000fe400078e00ffULL, 0x0000000142407824ULL, 0x100fe200078e0243ULL,
0xfffffff0494a7812ULL, 0x000fe200078ee244ULL, 0x0000000147427824ULL, 0x000fe200078e0243ULL,
0x000000f016497812ULL, 0x000fe200078ec0ffULL, 0x00005e0046467625ULL, 0x000fe200078e0045ULL,
0x0000e0004c4d7811ULL, 0x000fc600078e20ffULL, 0x0000000141447824ULL, 0x040fe200078e0243ULL,
0x0000004946467210ULL, 0x000fe20007f3e0ffULL, 0x00000001414b7824ULL, 0x040fe400078e0202ULL,
0x00000010414e7824ULL, 0x000fe400078e00ffULL, 0x00005e0040407625ULL, 0x000fc600078e0045ULL,
0xfffffff04e4e7812ULL, 0x000fe200078ee24bULL, 0x00005e0042427625ULL, 0x000fe200078e0045ULL,
0x0000004940407210ULL, 0x000fe40007f1e0ffULL, 0x0000e0004a4b7811ULL, 0x000fe200078e20ffULL,
0x00005e0044447625ULL, 0x000fe200078e0045ULL, 0x0000e0004e4f7811ULL, 0x000fc600078e20ffULL,
0x000000ffff477224ULL, 0x000fe200008e0647ULL, 0x0000004942427210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff417224ULL, 0x000fe200000e0641ULL, 0x0000004944447210ULL, 0x000fe40007f5e0ffULL,
0x0000e00048497811ULL, 0x000fe200078e20ffULL, 0x000000ffff437224ULL, 0x000fe400008e0643ULL,
0x000000ffff457224ULL, 0x000fe400010e0645ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000046497faeULL, 0x0003e8000b901c46ULL, 0x00000000404b7faeULL, 0x0003e8000b901c46ULL,
0x00000000424d7faeULL, 0x0003e8000b901c46ULL, 0x00000000444f7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff427f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106680011467f8cULL, 0x0004e4000c80043fULL, 0x0000000000407805ULL, 0x000fc40000015200ULL,
0x01066c0011457984ULL, 0x000f240000000800ULL, 0x8000000045ff7812ULL, 0x018fc40007804847ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff487224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000447805ULL, 0x000fcc0000015200ULL, 0x0000004440497210ULL, 0x000fca0007f1e1ffULL,
0x0000000145457824ULL, 0x000fe200000e0e41ULL, 0x003d09004900780cULL, 0x000fc80003f06070ULL,
0x000000ff4500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404900780cULL, 0x000fc80003f06070ULL, 0x000000ff4500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff447819ULL, 0x000fc80000011445ULL,
0x0000004944447211ULL, 0x000fca00078110ffULL, 0x000000ffff457224ULL, 0x000fca00000e0645ULL,
0x0000000244447819ULL, 0x000fc80000001245ULL, 0x000000440000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000148487810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01066c0011457984ULL, 0x000ee40000000800ULL,
0x8000000045ff7812ULL, 0x008fe40007804847ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0101800017417984ULL, 0x000ee80000000800ULL, 0x0103800017467984ULL, 0x0004620000000800ULL,
0x000000524100720bULL, 0x008fe20003f1d000ULL, 0x0000c0727f007947ULL, 0x000fd8000b800000ULL,
0x0000000000477806ULL, 0x004fc800000e0100ULL, 0x0000ffff47ff7812ULL, 0x000fe2000780c0ffULL,
0x0000048000007945ULL, 0x000fe20003800000ULL, 0x00000001ff487424ULL, 0x000fc400078e00ffULL,
0x000000ffff407224ULL, 0x000fd200078e0052ULL, 0x0000044000008947ULL, 0x000fea0003800000ULL,
0x000000030000780cULL, 0x000fe40003f05270ULL, 0x000000524100720bULL, 0x000fe20003f34000ULL,
0x0000c0327f007947ULL, 0x000fd8000b800000ULL, 0x0000000000187806ULL, 0x000fc400008e0100ULL,
0x0000005241408209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x0000991018447816ULL, 0x000fc600000000ffULL, 0x0105804017008388ULL, 0x0005e20000000800ULL,
0x000000ff4400720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000005241177209ULL, 0x004fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff18ff7812ULL, 0x000fc6000780c0ffULL, 0x0000005217177221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b17177820ULL, 0x000fc80000410000ULL, 0x0000001700407308ULL, 0x000ea40000000800ULL,
0x0000004013137220ULL, 0x004fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff5b7819ULL, 0x000fe20000011602ULL, 0x0000bf727f007947ULL, 0x000fea000b800000ULL,
0x00001f5b40177589ULL, 0x0004e400000e0000ULL, 0x000000173c3c7220ULL, 0x088fe20000410000ULL,
0x000000173d3d7220ULL, 0x080fe20000410000ULL, 0x0000001734347220ULL, 0x080fe20000410000ULL,
0x0000001735357220ULL, 0x080fe20000410000ULL, 0x0000001730307220ULL, 0x080fe20000410000ULL,
0x0000001731317220ULL, 0x080fe20000410000ULL, 0x000000172c2c7220ULL, 0x080fe20000410000ULL,
0x000000172d2d7220ULL, 0x080fe20000410000ULL, 0x0000001728287220ULL, 0x080fe20000410000ULL,
0x0000001729297220ULL, 0x080fe20000410000ULL, 0x0000001708087220ULL, 0x080fe20000410000ULL,
0x0000001709097220ULL, 0x080fe20000410000ULL, 0x0000001704047220ULL, 0x080fe20000410000ULL,
0x0000001705057220ULL, 0x080fe20000410000ULL, 0x000000170c0c7220ULL, 0x080fe20000410000ULL,
0x000000170d0d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0018ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008025b7811ULL, 0x006fe200078ff0ffULL, 0x0000be627f007947ULL, 0x000fea000b800000ULL,
0x00001f5b40177589ULL, 0x0002a400000e0000ULL, 0x000000173e3e7220ULL, 0x084fe20000410000ULL,
0x000000173f3f7220ULL, 0x080fe20000410000ULL, 0x0000001736367220ULL, 0x080fe20000410000ULL,
0x0000001737377220ULL, 0x080fe20000410000ULL, 0x0000001732327220ULL, 0x080fe20000410000ULL,
0x0000001733337220ULL, 0x080fe20000410000ULL, 0x000000172e2e7220ULL, 0x080fe20000410000ULL,
0x000000172f2f7220ULL, 0x080fe20000410000ULL, 0x000000172a2a7220ULL, 0x080fe20000410000ULL,
0x000000172b2b7220ULL, 0x080fe20000410000ULL, 0x000000170a0a7220ULL, 0x080fe20000410000ULL,
0x000000170b0b7220ULL, 0x080fe20000410000ULL, 0x0000001706067220ULL, 0x080fe20000410000ULL,
0x0000001707077220ULL, 0x080fe20000410000ULL, 0x000000170e0e7220ULL, 0x080fe20000410000ULL,
0x000000170f0f7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff18ff7812ULL, 0x000fe20007800847ULL, 0x00000001ff487424ULL, 0x000fe200078e00ffULL,
0x0000005241407209ULL, 0x002fd60007810000ULL, 0x8000004041410221ULL, 0x000fe20000010000ULL,
0x00007610ff480816ULL, 0x000fc60000000048ULL, 0x3fb8aa3b41410820ULL, 0x000fc80000410000ULL,
0x00000041001b0308ULL, 0x000e640000000800ULL, 0x0000001b46460220ULL, 0x002fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001346137221ULL, 0x002fc20000010000ULL,
0x0000000000447805ULL, 0x000fcc0000015200ULL, 0x0106ac00ff187984ULL, 0x000e640000000800ULL,
0x8000000018ff7812ULL, 0x002fe4000780483bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff417224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104100780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000467805ULL, 0x000fcc0000015200ULL,
0x0000004644187210ULL, 0x000fca0007f1e1ffULL, 0x0000000147467824ULL, 0x000fe200000e0e45ULL,
0x003d09001800780cULL, 0x000fc80003f06070ULL, 0x000000ff4600720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401800780cULL, 0x000fc80003f06070ULL,
0x000000ff4600720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff177819ULL, 0x000fc80000011446ULL, 0x0000001817177211ULL, 0x000fca00078110ffULL,
0x000000ffff187224ULL, 0x000fca00000e0646ULL, 0x0000000217177819ULL, 0x000fc80000001218ULL,
0x000000170000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000141417810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106ac00ff187984ULL, 0x000e640000000800ULL, 0x8000000018ff7812ULL, 0x002fe4000780483bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991048177816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff1700720cULL, 0x000fda0003f25270ULL,
0x0000012000001947ULL, 0x000fea0003800000ULL, 0x0000001bff17723eULL, 0x000fe400000010ffULL,
0x00000002ff187819ULL, 0x000fe40000011602ULL, 0x0000541017177816ULL, 0x000fe20000000017ULL,
0x0000ba427f007947ULL, 0x000fea000b800000ULL, 0x00001f18171d7589ULL, 0x0002a400000e0000ULL,
0x00000008185b7810ULL, 0x002fe20007ffe0ffULL, 0x0000ba727f007947ULL, 0x000fea000b800000ULL,
0x00001f5b171c7589ULL, 0x0002e400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000010185b7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff5a7224ULL, 0x000fe200078e0017ULL,
0x00013e4000447802ULL, 0x000fc40000000f00ULL, 0x0000bfc000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000018185b7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff5a7224ULL, 0x004fe200078e0017ULL, 0x00013e9000447802ULL, 0x000fc40000000f00ULL,
0x0000bf7000007944ULL, 0x008fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000001f44783bULL, 0x000f220000004200ULL,
0x0000b80024247811ULL, 0x000fc400078e20ffULL, 0x0000b80023237811ULL, 0x000fe200078e20ffULL,
0x000000002048783bULL, 0x000e680000004200ULL, 0x00000000214c783bULL, 0x000ee80000004200ULL,
0x000000002250783bULL, 0x000ea20000004200ULL, 0x0001000044ca7824ULL, 0x010fe200078e00ffULL,
0x00000018ffa37819ULL, 0x000fe20000011444ULL, 0x0000004500a57306ULL, 0x000fe20000009400ULL,
0x00000018ff9e7819ULL, 0x000fe20000011445ULL, 0x0000010047a87824ULL, 0x040fe200078e00ffULL,
0x00000018ffca7819ULL, 0x000fe200000114caULL, 0x0001000046ae7824ULL, 0x000fe200078e00ffULL,
0x00000018ff957819ULL, 0x000fe20000011446ULL, 0x0001000047b07824ULL, 0x000fe200078e00ffULL,
0x00000018ffa87819ULL, 0x000fe200000114a8ULL, 0x000000ca00d67306ULL, 0x000fe20000209400ULL,
0x00000018ffae7819ULL, 0x000fe200000114aeULL, 0x0000010044c97824ULL, 0x000fe200078e00ffULL,
0x00000018ffb07819ULL, 0x000fe200000114b0ULL, 0x0001000045b27824ULL, 0x040fe200078e00ffULL,
0x00000018ff947819ULL, 0x000fe20000011447ULL, 0x0000010048aa7824ULL, 0x002fe200078e00ffULL,
0x00000018ffc97819ULL, 0x000fe200000114c9ULL, 0x000000ca00d77306ULL, 0x0003220000205400ULL,
0x00000018ffb27819ULL, 0x000fe200000114b2ULL, 0x0000010045ab7824ULL, 0x000fe200078e00ffULL,
0x00000018ffaa7819ULL, 0x000fe200000114aaULL, 0x0001000049af7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8d7819ULL, 0x000fe20000011448ULL, 0x0000010046a77824ULL, 0x000fe200078e00ffULL,
0x00000018ffab7819ULL, 0x000fe200000114abULL, 0x0000004500a67306ULL, 0x000ea20000005400ULL,
0x000000ca00ca7245ULL, 0x002fe2000020d400ULL, 0x0001000048b17824ULL, 0x000fe200078e00ffULL,
0x00000018ffaf7819ULL, 0x000fe200000114afULL, 0x000100004dda7824ULL, 0x008fe200078e00ffULL,
0x00000018ffa77819ULL, 0x000fe200000114a7ULL, 0x000001004edb7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8b7819ULL, 0x000fe20000011449ULL, 0x000000a300ac7306ULL, 0x000fe20000209400ULL,
0x000000d7d600720bULL, 0x010fe20003f9d000ULL, 0x000001004fdc7824ULL, 0x040fe200078e00ffULL,
0x00000018ffb17819ULL, 0x000fe200000114b1ULL, 0x000100004fcf7824ULL, 0x000fe200078e00ffULL,
0x00000018ffda7819ULL, 0x000fe200000114daULL, 0x000100004ed17824ULL, 0x000fe200078e00ffULL,
0x00000018ff7b7819ULL, 0x000fe2000001144aULL, 0x000000a300ad7306ULL, 0x0002e20000205400ULL,
0x000000a6a500720bULL, 0x004fe20003f7d000ULL, 0x000001004dd87824ULL, 0x000fe200078e00ffULL,
0x00000018ff7c7819ULL, 0x000fc4000001144bULL, 0x00000018ffdb7819ULL, 0x000fe400000114dbULL,
0x00000001caca4812ULL, 0x000fe200078efcffULL, 0x0000009e00a27306ULL, 0x000fe20000209400ULL,
0x000000a300a37245ULL, 0x002fe4000020d400ULL, 0x00000018ffdc7819ULL, 0x000fe400000114dcULL,
0x00000018ff807819ULL, 0x000fe4000001144cULL, 0x00000018ff657819ULL, 0x000fe2000001144fULL,
0x0000009e00a17306ULL, 0x000e620000205400ULL, 0x000000adac00720bULL, 0x008fc40003fbd000ULL,
0x00000018ff697819ULL, 0x000fe4000001144eULL, 0x00000018ffd17819ULL, 0x000fe400000114d1ULL,
0x00000018ff707819ULL, 0x000fe2000001144dULL, 0x0000004600a47306ULL, 0x000fe20000009400ULL,
0x00000018ff5c7819ULL, 0x000fe40000011450ULL, 0x00000018ff547819ULL, 0x000fe40000011451ULL,
0x00000018ff177819ULL, 0x000fc40000011452ULL, 0x00000001a3a35812ULL, 0x000fe200078efcffULL,
0x0000004600a97306ULL, 0x000ea20000005400ULL, 0x000000a1a200720bULL, 0x002fe40003f9d000ULL,
0x00000018ff187819ULL, 0x000fca0000011453ULL, 0x0000004500727306ULL, 0x0002f0000000d400ULL,
0x00000047009f7306ULL, 0x000fe20000009400ULL, 0x000000a9a400720bULL, 0x004fe20003f1d000ULL,
0x000100004a457824ULL, 0x002fe200078e00ffULL, 0x00000018ffa47819ULL, 0x000fc800000114d8ULL,
0x00000018ff457819ULL, 0x000fe20000011445ULL, 0x0000004700a07306ULL, 0x000e620000005400ULL,
0x0000000172723812ULL, 0x008fce00078efcffULL, 0x000000a800b97306ULL, 0x000ff00000209400ULL,
0x000000a800cc7306ULL, 0x0004e20000205400ULL, 0x000000a09f00720bULL, 0x002fe40003fbd000ULL,
0x0000009e009f7245ULL, 0x000fc4000020d400ULL, 0x000000caa39e723eULL, 0x000fe400000010ffULL,
0x000000019f9f4812ULL, 0x000fe200078efcffULL, 0x0000004400cd7306ULL, 0x000fe20000009400ULL,
0x000000a800a87245ULL, 0x004fce000020d400ULL, 0x0000004400ce7306ULL, 0x000e620000005400ULL,
0x000000ccb900720bULL, 0x008fce0003f7d000ULL, 0x000000ae00b77306ULL, 0x000fec0000209400ULL,
0x00000001a8a83812ULL, 0x000fe400078efcffULL, 0x000000ae00bc7306ULL, 0x0004e20000205400ULL,
0x000000cecd00720bULL, 0x002fe40003f5d000ULL, 0x000000c900ce7245ULL, 0x000fca000020d400ULL,
0x00000046006e7306ULL, 0x000322000000d400ULL, 0x000000ae00ae7245ULL, 0x004fce000020d400ULL,
0x00000095009a7306ULL, 0x000fe20000209400ULL, 0x000000bcb700720bULL, 0x008fe20003f9d000ULL,
0x000001004b467824ULL, 0x002fca00078e00ffULL, 0x00000018ff467819ULL, 0x000fe20000011446ULL,
0x0000009500997306ULL, 0x0002a20000205400ULL, 0x000000016e6e0812ULL, 0x010fca00078efcffULL,
0x00000001aeae4812ULL, 0x000fe400078efcffULL, 0x000000b000c77306ULL, 0x000fe20000209400ULL,
0x0000009500957245ULL, 0x002fce000020d400ULL, 0x000000b000c87306ULL, 0x0002e20000205400ULL,
0x000000999a00720bULL, 0x004fce0003f1d000ULL, 0x0000004700217306ULL, 0x000522000000d400ULL,
0x000000b000b07245ULL, 0x002fca000020d400ULL, 0x0000000195950812ULL, 0x000fe400078efcffULL,
0x000000c900d07306ULL, 0x000fe20000209400ULL, 0x0000010049477824ULL, 0x004fe200078e00ffULL,
0x000000c8c700720bULL, 0x008fc80003f7d000ULL, 0x00000018ff477819ULL, 0x000fe40000011447ULL,
0x000000c900d57306ULL, 0x000e620000205400ULL, 0x0000000121215812ULL, 0x010fc800078efcffULL,
0x00000021a821723eULL, 0x000fe400000010ffULL, 0x00000001b0b03812ULL, 0x000fe200078efcffULL,
0x0000004400717306ULL, 0x0004f0000000d400ULL, 0x000000b200d37306ULL, 0x000fe20000209400ULL,
0x000000d5d000720bULL, 0x002fe20003fdd000ULL, 0x000001004a447824ULL, 0x004fca00078e00ffULL,
0x00000018ff447819ULL, 0x000fe20000011444ULL, 0x000000b200d27306ULL, 0x0002a20000205400ULL,
0x0000000171712812ULL, 0x008fca00078efcffULL, 0x00000001cece6812ULL, 0x000fe400078efcffULL,
0x000000aa00b87306ULL, 0x000fe20000209400ULL, 0x000000b200b27245ULL, 0x002fe4000020d400ULL,
0x00000071cece723eULL, 0x000fca00000010ffULL, 0x000000aa00b37306ULL, 0x000e620000205400ULL,
0x000000d2d300720bULL, 0x004fce0003f5d000ULL, 0x0000004700b67306ULL, 0x000fec0000209400ULL,
0x00000001b2b22812ULL, 0x000fe400078efcffULL, 0x0000004700bd7306ULL, 0x000ea20000205400ULL,
0x000000b3b800720bULL, 0x002fe40003f9d000ULL, 0x000000b29f9f723eULL, 0x000fca00000010ffULL,
0x0000004a00927306ULL, 0x000ff00000009400ULL, 0x0000004a00937306ULL, 0x000e620000005400ULL,
0x000000bdb600720bULL, 0x004fce0003f1d000ULL, 0x000000ab00d47306ULL, 0x000ff00000209400ULL,
0x000000ab00d97306ULL, 0x0004e20000205400ULL, 0x000000939200720bULL, 0x002fe40003f7d000ULL,
0x000000aa00937245ULL, 0x000fc8000020d400ULL, 0x0000000193934812ULL, 0x000fe200078efcffULL,
0x00000048009d7306ULL, 0x000fe20000009400ULL, 0x000000ab00ab7245ULL, 0x004fce000020d400ULL,
0x00000048009c7306ULL, 0x000e620000005400ULL, 0x000000d9d400720bULL, 0x008fce0003fdd000ULL,
0x0000009400977306ULL, 0x000fec0000209400ULL, 0x00000001abab6812ULL, 0x000fe400078efcffULL,
0x0000009400967306ULL, 0x000ea20000205400ULL, 0x0000009c9d00720bULL, 0x002fce0003f5d000ULL,
0x0000008d00917306ULL, 0x000ff00000209400ULL, 0x0000008d008e7306ULL, 0x000e620000205400ULL,
0x000000969700720bULL, 0x004fe40003fbd000ULL, 0x0000009400977245ULL, 0x000fca000020d400ULL,
0x000000af00c57306ULL, 0x000fec0000209400ULL, 0x0000000197975812ULL, 0x000fe400078efcffULL,
0x000000af00c67306ULL, 0x000ea20000205400ULL, 0x0000008e9100720bULL, 0x002fe40003f9d000ULL,
0x0000004700917245ULL, 0x000fc4000020d400ULL, 0x0000008d008e7245ULL, 0x000fe4000020d400ULL,
0x0000000191910812ULL, 0x000fe200078efcffULL, 0x000000a700ba7306ULL, 0x000fe20000209400ULL,
0x00000046008d7245ULL, 0x000fe4000020d400ULL, 0x000000b09797723eULL, 0x000fc600000010ffULL,
0x000000018e8e4812ULL, 0x000fe400078efcffULL, 0x000000a700bb7306ULL, 0x0002e20000205400ULL,
0x000000c6c500720bULL, 0x004fce0003f1d000ULL, 0x00000048006c7306ULL, 0x000522000000d400ULL,
0x000000a700a77245ULL, 0x002fce000020d400ULL, 0x0000008b008f7306ULL, 0x000fe20000209400ULL,
0x000000bbba00720bULL, 0x008fe20003fdd000ULL, 0x000100004c487824ULL, 0x004fca00078e00ffULL,
0x00000018ffcd7819ULL, 0x000fe20000011448ULL, 0x0000008b00907306ULL, 0x000e620000205400ULL,
0x000000016c6c2812ULL, 0x010fe200078efcffULL, 0x0000010053487824ULL, 0x000fc600078e00ffULL,
0x0000006c936c723eULL, 0x000fe400000010ffULL, 0x00000001a7a76812ULL, 0x000fe200078efcffULL,
0x000000b100b47306ULL, 0x000ff00000209400ULL, 0x000000b100c17306ULL, 0x0004e20000205400ULL,
0x000000908f00720bULL, 0x002fc40003f5d000ULL, 0x000000af008f7245ULL, 0x000fe4000020d400ULL,
0x0000008b00907245ULL, 0x000fe4000020d400ULL, 0x000000018f8f0812ULL, 0x000fe200078efcffULL,
0x0000004c00857306ULL, 0x000fe20000009400ULL, 0x000000b100b17245ULL, 0x004fca000020d400ULL,
0x0000000190902812ULL, 0x000fe400078efcffULL, 0x0000004c00867306ULL, 0x000e620000005400ULL,
0x000000c1b400720bULL, 0x008fe40003fbd000ULL, 0x0000008f908f723eULL, 0x000fca00000010ffULL,
0x00000049009b7306ULL, 0x000fec0000009400ULL, 0x00000001b1b15812ULL, 0x000fe400078efcffULL,
0x0000004900987306ULL, 0x000ea20000005400ULL, 0x000000868500720bULL, 0x002fe40003f1d000ULL,
0x000000b18e8e723eULL, 0x000fca00000010ffULL, 0x0000004b00897306ULL, 0x000ff00000009400ULL,
0x0000004b008c7306ULL, 0x000e620000005400ULL, 0x000000989b00720bULL, 0x004fce0003fdd000ULL,
0x0000004c005e7306ULL, 0x000eb0000000d400ULL, 0x000000da009c7306ULL, 0x000fe20000209400ULL,
0x0000008c8900720bULL, 0x002fe40003fbd000ULL, 0x00000044008c7245ULL, 0x000fca000020d400ULL,
0x000000da00997306ULL, 0x000e620000205400ULL, 0x000000015e5e0812ULL, 0x004fce00078efcffULL,
0x00000049006a7306ULL, 0x0004f0000000d400ULL, 0x0000004400c47306ULL, 0x000fe20000209400ULL,
0x000000999c00720bULL, 0x002fe20003f1d000ULL, 0x0000010052497824ULL, 0x004fca00078e00ffULL,
0x00000018ff497819ULL, 0x000fe20000011449ULL, 0x0000004400bf7306ULL, 0x000e620000205400ULL,
0x000000016a6a6812ULL, 0x008fce00078efcffULL, 0x0000004a00677306ULL, 0x0004f0000000d400ULL,
0x0000004b00647306ULL, 0x000922000000d400ULL, 0x000100004b4a7824ULL, 0x004fe200078e00ffULL,
0x000000bfc400720bULL, 0x002fc80003fdd000ULL, 0x00000018ff4a7819ULL, 0x000fe4000001144aULL,
0x0000007b00887306ULL, 0x000fe20000209400ULL, 0x0000000167673812ULL, 0x008fe200078efcffULL,
0x000001004c4b7824ULL, 0x010fe200078e00ffULL, 0x0000004a00857245ULL, 0x000fc8000020d400ULL,
0x00000018ff4b7819ULL, 0x000fe2000001144bULL, 0x0000007b00837306ULL, 0x000e620000205400ULL,
0x0000000164645812ULL, 0x000fe400078efcffULL, 0x000000018c8c6812ULL, 0x000fc800078efcffULL,
0x000000678c8c723eULL, 0x000fe200000010ffULL, 0x0000007c00847306ULL, 0x000ff00000209400ULL,
0x0000007c00817306ULL, 0x0004e20000205400ULL, 0x000000838800720bULL, 0x002fc40003f7d000ULL,
0x0000004500837245ULL, 0x000fca000020d400ULL, 0x0000004600c27306ULL, 0x000fe20000209400ULL,
0x0000007c007c7245ULL, 0x004fce000020d400ULL, 0x0000004600cb7306ULL, 0x000e620000205400ULL,
0x000000818400720bULL, 0x008fe40003fbd000ULL, 0x000000da00817245ULL, 0x000fe4000020d400ULL,
0x0000007b00847245ULL, 0x000fe4000020d400ULL, 0x0000000181810812ULL, 0x000fe200078efcffULL,
0x000000db00967306ULL, 0x000fe20000209400ULL, 0x0000000184843812ULL, 0x000fca00078efcffULL,
0x000000017c7c5812ULL, 0x000fe400078efcffULL, 0x000000db009b7306ULL, 0x0004e20000205400ULL,
0x000000cbc200720bULL, 0x002fce0003f9d000ULL, 0x0000004500b57306ULL, 0x000fe20000209400ULL,
0x000000db00db7245ULL, 0x004fca000020d400ULL, 0x000000018d8d4812ULL, 0x000fe400078efcffULL,
0x0000004500c07306ULL, 0x0002a20000205400ULL, 0x0000009b9600720bULL, 0x008fe40003f1d000ULL,
0x000000ae9596723eULL, 0x000fe400000010ffULL, 0x000000648d8d723eULL, 0x000fc600000010ffULL,
0x000000cd00d07306ULL, 0x000fe20000209400ULL, 0x000000002444783bULL, 0x0022ea0000000200ULL,
0x00000001dbdb0812ULL, 0x000fe400078efcffULL, 0x000000cd00a57306ULL, 0x0009220000205400ULL,
0x000000c0b500720bULL, 0x004fe40003fdd000ULL, 0x0000006900247245ULL, 0x002fca000020d400ULL,
0x0000004a00c37306ULL, 0x000fe20000209400ULL, 0x000000cd00cd7245ULL, 0x010fca000020d400ULL,
0x0000000183836812ULL, 0x000fe400078efcffULL, 0x0000004a00be7306ULL, 0x000e620000205400ULL,
0x000000a5d000720bULL, 0x000fe40003f7d000ULL, 0x000000838484723eULL, 0x000fca00000010ffULL,
0x0000004e00747306ULL, 0x000fec0000009400ULL, 0x00000001cdcd3812ULL, 0x000fe400078efcffULL,
0x0000004e00797306ULL, 0x000ea20000005400ULL, 0x000000bec300720bULL, 0x002fe20003f9d000ULL,
0x0000001d44449231ULL, 0x008fc400003400ffULL, 0x0000001d46469231ULL, 0x000fe400003400ffULL,
0x0000001c45459231ULL, 0x080fe400003400ffULL, 0x0000004d00877306ULL, 0x000fe20000009400ULL,
0x0000001c47479231ULL, 0x000fca00003400ffULL, 0x0000000185854812ULL, 0x000fe400078efcffULL,
0x0000004d008a7306ULL, 0x000e620000005400ULL, 0x000000797400720bULL, 0x004fe20003fbd000ULL,
0x0000009e4434723cULL, 0x000fe20000041834ULL, 0x000000857c85723eULL, 0x000fca00000010ffULL,
0x000000dc00927306ULL, 0x000fe40000209400ULL, 0x00000096442c723cULL, 0x040f6c000004182cULL,
0x000000dc009d7306ULL, 0x0004e20000205400ULL, 0x0000008a8700720bULL, 0x002fe20003f5d000ULL,
0x0000008e4408723cULL, 0x000fe20000041808ULL, 0x00000018ff877819ULL, 0x000fc400000114cfULL,
0x00000072abcf723eULL, 0x000fc600000010ffULL, 0x0000004f00777306ULL, 0x000fe20000009400ULL,
0x000000dc00dc7245ULL, 0x004fe2000020d400ULL, 0x0000008c4404723cULL, 0x040fec0000041804ULL,
0x0000004f00787306ULL, 0x000e620000005400ULL, 0x0000009d9200720bULL, 0x008fe20003f1d000ULL,
0x000000ce443c723cULL, 0x040f6c000004183cULL, 0x0000004f005b7306ULL, 0x000ea4000000d400ULL,
0x00000084440c723cULL, 0x000fe8000004180cULL, 0x00000001dcdc0812ULL, 0x000fc400078efcffULL,
0x0000004b004c7306ULL, 0x000fe20000209400ULL, 0x000000787700720bULL, 0x002fce0003f7d000ULL,
0x0000004b004f7306ULL, 0x0002ec0000205400ULL, 0x000000015b5b3812ULL, 0x004fe400078efcffULL,
0x0000008000827306ULL, 0x000fe20000209400ULL, 0x0000004b004b7245ULL, 0x002fe4000020d400ULL,
0x0000005bdc5b723eULL, 0x000fca00000010ffULL, 0x0000008000757306ULL, 0x0002a20000205400ULL,
0x0000004f4c00720bULL, 0x008fce0003fdd000ULL, 0x0000004e005a7306ULL, 0x000722000000d400ULL,
0x0000008000807245ULL, 0x002fca000020d400ULL, 0x000000014b4b6812ULL, 0x000fe400078efcffULL,
0x00000069006d7306ULL, 0x000fe20000209400ULL, 0x00000100504e7824ULL, 0x008fe200078e00ffULL,
0x000000758200720bULL, 0x004fe40003f9d000ULL, 0x0000005e4b5e723eULL, 0x000fe400000010ffULL,
0x00000018ff4e7819ULL, 0x000fe4000001144eULL, 0x0000006900207306ULL, 0x000e620000205400ULL,
0x000000015a5a5812ULL, 0x010fc800078efcffULL, 0x0000005adb5a723eULL, 0x000fe400000010ffULL,
0x0000000180804812ULL, 0x000fe200078efcffULL, 0x000000d100897306ULL, 0x000fe60000209400ULL,
0x000000cd8080723eULL, 0x000fca00000010ffULL, 0x000000d100867306ULL, 0x0004e20000205400ULL,
0x000000206d00720bULL, 0x002fe40003fbd000ULL, 0x0000006ea720723eULL, 0x000fe400000010ffULL,
0x0000006a916d723eULL, 0x000fc600000010ffULL, 0x0000008700887306ULL, 0x000fe20000209400ULL,
0x000000d100d17245ULL, 0x004fe2000020d400ULL, 0x000000204430723cULL, 0x040f680000041830ULL,
0x0000000124245812ULL, 0x000fe400078efcffULL, 0x00000087004f7306ULL, 0x0002a20000205400ULL,
0x000000868900720bULL, 0x008fe20003f1d000ULL, 0x0000006c4428723cULL, 0x000b6c0000041828ULL,
0x0000004d005f7306ULL, 0x000722000000d400ULL, 0x0000008700877245ULL, 0x002fc4000020d400ULL,
0x0000005c00477245ULL, 0x020fc6000020d400ULL, 0x00000001d1d10812ULL, 0x000fe400078efcffULL,
0x00000070007d7306ULL, 0x000fe20000209400ULL, 0x00000100514d7824ULL, 0x008fe200078e00ffULL,
0x0000004f8800720bULL, 0x004fe40003f7d000ULL, 0x000000d12444723eULL, 0x000fe400000010ffULL,
0x00000018ff747819ULL, 0x000fe4000001144dULL, 0x00000070007e7306ULL, 0x0002a20000205400ULL,
0x000000015f5f2812ULL, 0x010fc400078efcffULL, 0x0000004900247245ULL, 0x000fc8000020d400ULL,
0x0000000187873812ULL, 0x000fe200078efcffULL, 0x0000004e004a7306ULL, 0x000fe20000209400ULL,
0x0000007000707245ULL, 0x002fce000020d400ULL, 0x0000004e00757306ULL, 0x0002e20000205400ULL,
0x0000007e7d00720bULL, 0x004fce0003f5d000ULL, 0x00000065006b7306ULL, 0x000fe20000209400ULL,
0x0000004e004e7245ULL, 0x002fca000020d400ULL, 0x0000000170702812ULL, 0x000fe400078efcffULL,
0x0000006500687306ULL, 0x000e620000205400ULL, 0x000000754a00720bULL, 0x008fe40003fbd000ULL,
0x000000817081723eULL, 0x000fca00000010ffULL, 0x000000a400a17306ULL, 0x000fec0000209400ULL,
0x000000014e4e5812ULL, 0x000fe400078efcffULL, 0x000000a400a07306ULL, 0x0004e20000205400ULL,
0x000000686b00720bULL, 0x002fce0003f1d000ULL, 0x0000005300667306ULL, 0x000fe20000009400ULL,
0x000000a400a47245ULL, 0x004fce000020d400ULL, 0x0000005300637306ULL, 0x000e620000005400ULL,
0x000000a0a100720bULL, 0x008fce0003fdd000ULL, 0x0000005200227306ULL, 0x000fec0000009400ULL,
0x00000001a4a46812ULL, 0x000fe400078efcffULL, 0x00000052006f7306ULL, 0x000ea20000005400ULL,
0x000000636600720bULL, 0x002fe40003f7d000ULL, 0x00000018ff637819ULL, 0x000fc40000011448ULL,
0x0000006500487245ULL, 0x000fe4000020d400ULL, 0x0000005fa45f723eULL, 0x000fe200000010ffULL,
0x0000007400777306ULL, 0x000fe20000209400ULL, 0x0000000148480812ULL, 0x000fc800078efcffULL,
0x000000874845723eULL, 0x000fc600000010ffULL, 0x0000007400727306ULL, 0x0002e20000205400ULL,
0x0000006f2200720bULL, 0x004fe40003f5d000ULL, 0x000000002320783bULL, 0x000eaa0000000200ULL,
0x00000050007f7306ULL, 0x000fe20000009400ULL, 0x0000007400747245ULL, 0x002fce000020d400ULL,
0x00000050007a7306ULL, 0x000e620000005400ULL, 0x000000727700720bULL, 0x008fce0003fbd000ULL,
0x0000005100737306ULL, 0x000fec0000009400ULL, 0x0000000174745812ULL, 0x000fe400078efcffULL,
0x0000005100767306ULL, 0x000ee20000005400ULL, 0x0000007a7f00720bULL, 0x002fce0003f9d000ULL,
0x0000005c00617306ULL, 0x000fe20000209400ULL, 0x0000001d20209231ULL, 0x084fe400003400ffULL,
0x0000001d22229231ULL, 0x000fe400003400ffULL, 0x0000001c21219231ULL, 0x000fc600003400ffULL,
0x0000005c00627306ULL, 0x000e620000205400ULL, 0x000000767300720bULL, 0x008fe20003fdd000ULL,
0x0000001c23239231ULL, 0x000fcc00003400ffULL, 0x0000005000577306ULL, 0x0004e2000000d400ULL,
0x00000044202c723cULL, 0x040b6e000004182cULL, 0x0000005100417306ULL, 0x0008e2000000d400ULL,
0x0001000050507824ULL, 0x004fe200078e00ffULL, 0x000000626100720bULL, 0x002fe20003f1d000ULL,
0x0000005e203c723cULL, 0x000b66000004183cULL, 0x00000018ff507819ULL, 0x000fc40000011450ULL,
0x0000005400607306ULL, 0x000fe20000209400ULL, 0x0001000051517824ULL, 0x010fe200078e00ffULL,
0x0000000157574812ULL, 0x008fe200078efcffULL, 0x000000802034723cULL, 0x040b660000041834ULL,
0x00000018ff517819ULL, 0x000fe40000011451ULL, 0x00000050004c7306ULL, 0x000fe20000209400ULL,
0x0000000141416812ULL, 0x000fe400078efcffULL, 0x0000000147470812ULL, 0x000fe200078efcffULL,
0x0000005a2030723cULL, 0x000b620000041830ULL, 0x000000574e4e723eULL, 0x000fc600000010ffULL,
0x00000050004d7306ULL, 0x0002b00000205400ULL, 0x00000054005d7306ULL, 0x0007220000205400ULL,
0x0000005000507245ULL, 0x002fce000020d400ULL, 0x00000051006e7306ULL, 0x000fe20000209400ULL,
0x0000004d4c00720bULL, 0x004fe40003fbd000ULL, 0x0000005400547245ULL, 0x008fca000020d400ULL,
0x00000051004f7306ULL, 0x0002a20000205400ULL, 0x0000005d6000720bULL, 0x010fca0003f9d000ULL,
0x0000000150505812ULL, 0x000fe400078efcffULL, 0x0000004900697306ULL, 0x000fe20000209400ULL,
0x0000005100517245ULL, 0x002fe4000020d400ULL, 0x000000504750723eULL, 0x000fc600000010ffULL,
0x0000000154544812ULL, 0x000fe400078efcffULL, 0x00000049004a7306ULL, 0x000e620000205400ULL,
0x0000004f6e00720bULL, 0x004fe40003fdd000ULL, 0x00000041744f723eULL, 0x000fca00000010ffULL,
0x00000052001f7306ULL, 0x0004e4000000d400ULL, 0x0000004e2028723cULL, 0x000b680000041828ULL,
0x0000000151516812ULL, 0x000fe400078efcffULL, 0x00000053003b7306ULL, 0x0008e2000000d400ULL,
0x0001000052527824ULL, 0x004fe200078e00ffULL, 0x0000004a6900720bULL, 0x002fc40003f1d000ULL,
0x000000515451723eULL, 0x000fe400000010ffULL, 0x00000018ff527819ULL, 0x000fe40000011452ULL,
0x0000006300647306ULL, 0x000fe20000209400ULL, 0x0001000053537824ULL, 0x010fe200078e00ffULL,
0x000000011f1f2812ULL, 0x008fe200078efcffULL, 0x000000502008723cULL, 0x000b660000041808ULL,
0x00000018ff537819ULL, 0x000fc40000011453ULL, 0x0000006300617306ULL, 0x000e620000205400ULL,
0x0000000124240812ULL, 0x000fe400078efcffULL, 0x000000013b3b3812ULL, 0x000fe400078efcffULL,
0x0000001f2444723eULL, 0x020fc600000010ffULL, 0x0000001700597306ULL, 0x000ff00000209400ULL,
0x0000001700587306ULL, 0x0004e20000205400ULL, 0x000000616400720bULL, 0x002fce0003f9d000ULL,
0x0000001800557306ULL, 0x000fe20000209400ULL, 0x0000001700177245ULL, 0x004fce000020d400ULL,
0x0000001800567306ULL, 0x0002a20000205400ULL, 0x000000585900720bULL, 0x008fce0003fbd000ULL,
0x0000005200467306ULL, 0x000fe20000209400ULL, 0x0000001800187245ULL, 0x002fca000020d400ULL,
0x0000000117175812ULL, 0x000fe400078efcffULL, 0x00000052004b7306ULL, 0x0002e20000205400ULL,
0x000000565500720bULL, 0x004fce0003fdd000ULL, 0x00000053004c7306ULL, 0x000fe20000209400ULL,
0x0000005200527245ULL, 0x002fca000020d400ULL, 0x0000000118186812ULL, 0x000fe400078efcffULL,
0x00000053004d7306ULL, 0x0002a20000205400ULL, 0x0000004b4600720bULL, 0x008fe40003f1d000ULL,
0x0000006300467245ULL, 0x000fc8000020d400ULL, 0x0000000146464812ULL, 0x000fe400078efcffULL,
0x0000005300537245ULL, 0x002fe4000020d400ULL, 0x0000003b4645723eULL, 0x000fc600000010ffULL,
0x0000000152520812ULL, 0x000fe400078efcffULL, 0x0000004d4c00720bULL, 0x004fe40003f5d000ULL,
0x000000521752723eULL, 0x000fe200000010ffULL, 0x000000442004723cULL, 0x000b740000041804ULL,
0x0000000153532812ULL, 0x000fc800078efcffULL, 0x000000531853723eULL, 0x000fce00000010ffULL,
0x000000522020723cULL, 0x000b62000004180cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff447f8cULL, 0x020e62000c80043fULL, 0x000000ffff187224ULL, 0x000fce00078e00ffULL,
0x00000000000c7805ULL, 0x000fc40000015200ULL, 0x0106bc00ff0f7984ULL, 0x000ea40000000800ULL,
0x800000000fff7812ULL, 0x006fe40007804845ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000e7805ULL, 0x000fcc0000015200ULL, 0x0000000e0c177210ULL, 0x000fca0007f1e1ffULL,
0x000000010f0f7824ULL, 0x000fe200000e0e0dULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0e7819ULL, 0x000fc8000001140fULL,
0x000000170e0e7211ULL, 0x000fca00078110ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060fULL,
0x000000020e0e7819ULL, 0x000fc8000000120fULL, 0x0000000e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000118187810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106bc00ff0f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe40007804845ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000002150d7810ULL, 0x000fc80007ffe0ffULL, 0x000000100d00720cULL, 0x000fe40003f06070ULL,
0x000000e0140d7810ULL, 0x000fca0007ffe0ffULL, 0x0000620012177a24ULL, 0x000fcc00078e020dULL,
0x0000039000008947ULL, 0x000fea0003800000ULL, 0x000000021e467810ULL, 0x040fe20007ffe0ffULL,
0x00000001110e7824ULL, 0x000fe200078e021eULL, 0x000000041e487810ULL, 0x040fe40007ffe0ffULL,
0x0000000d030c7217ULL, 0x000fe20007800000ULL, 0x0000000111147824ULL, 0x040fe200078e0246ULL,
0x000000061e4a7810ULL, 0x000fe20007ffe0ffULL, 0x00000001111f7824ULL, 0x000fe400078e0248ULL,
0x0000000114187824ULL, 0x040fe400078e0202ULL, 0x0000001014417824ULL, 0x000fc400078e00ffULL,
0x000000010c0c7824ULL, 0x000fe400078e0a0dULL, 0x000000010e0f7824ULL, 0x040fe200078e0202ULL,
0xfffffff041417812ULL, 0x000fe200078ee218ULL, 0x000000100e247824ULL, 0x000fe400078e00ffULL,
0x000000011f3b7824ULL, 0x000fe200078e0202ULL, 0x0000c00041417811ULL, 0x000fe200078e20ffULL,
0x000000101f447824ULL, 0x000fe200078e00ffULL, 0xfffffff024247812ULL, 0x000fe200078ee20fULL,
0x00000100ff187424ULL, 0x000fc400078e00ffULL, 0x000000010e0d7824ULL, 0x100fe200078e0217ULL,
0x0000000c110e7217ULL, 0x040fe20007800000ULL, 0x00000001140f7824ULL, 0x000fe200078e0217ULL,
0xfffffff044477812ULL, 0x000fe200078ee23bULL, 0x0000000111447824ULL, 0x000fe200078e024aULL,
0x000000f0163b7812ULL, 0x000fe200078ec0ffULL, 0x00005e000d0c7625ULL, 0x000fe200078e0018ULL,
0x0000c00047477811ULL, 0x000fc600078e20ffULL, 0x000000011f147824ULL, 0x000fe400078e0217ULL,
0x000000010e1f7824ULL, 0x000fe400078e0a11ULL, 0x0000000144167824ULL, 0x000fe400078e0217ULL,
0x00005e000f0e7625ULL, 0x000fe200078e0018ULL, 0x0000001f1e00720cULL, 0x080fe40003f66070ULL,
0x0000001f4600720cULL, 0x000fe20003f46070ULL, 0x0000000144177824ULL, 0x000fe200078e0202ULL,
0x0000003b0e0e7210ULL, 0x080fe20007f9e0ffULL, 0x00000010444c7824ULL, 0x000fe200078e00ffULL,
0x0000003b0c447210ULL, 0x000fc60007f1e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200020e060fULL,
0xfffffff04c497812ULL, 0x000fe200078ee217ULL, 0x000000ffff457224ULL, 0x000fe200000e060dULL,
0x0000001f4800720cULL, 0x080fe20003f06070ULL, 0x00005e00140c7625ULL, 0x080fe200078e0018ULL,
0x0000001f4a00720cULL, 0x000fe40003f86070ULL, 0x0000c000241f7811ULL, 0x000fe200078e20ffULL,
0x00005e0016167625ULL, 0x000fe200078e0018ULL, 0x0000003b0c0c7210ULL, 0x080fe40007fbe0ffULL,
0x0000c00049497811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000441f7faeULL, 0x0003e2000d901c46ULL, 0x0000003b16167210ULL, 0x000fe20007fde0ffULL,
0x000000ffff0d7224ULL, 0x000fc400028e060dULL, 0x000000000e417faeULL, 0x0003e4000d101c46ULL,
0x000000ffff177224ULL, 0x000fe400030e0617ULL, 0x000000000c477faeULL, 0x0003e8000c101c46ULL,
0x0000000016497faeULL, 0x0003e2000e101c46ULL, 0x000002d000007947ULL, 0x000fea0003800000ULL,
0x00000001111e7824ULL, 0x000fc800078e021eULL, 0x000000011e0c7824ULL, 0x140fe200078e0202ULL,
0x000000041e0f7810ULL, 0x040fe20007ffe0ffULL, 0x000000101e3b7824ULL, 0x040fe200078e00ffULL,
0x000000021e0d7810ULL, 0x040fe40007ffe0ffULL, 0x000000061e447810ULL, 0x000fe20007ffe0ffULL,
0x000000010f1f7824ULL, 0x000fe200078e0202ULL, 0xfffffff03b147812ULL, 0x000fe200078ee20cULL,
0x000000100f247824ULL, 0x000fe400078e00ffULL, 0x000000010d0e7824ULL, 0x000fc400078e0202ULL,
0x000000100d417824ULL, 0x000fe200078e00ffULL, 0xfffffff024247812ULL, 0x000fe200078ee21fULL,
0x00000100ff3b7424ULL, 0x000fe400078e00ffULL, 0x000000011e1f7824ULL, 0x100fe200078e0217ULL,
0xfffffff041187812ULL, 0x000fe200078ee20eULL, 0x000000010d0c7824ULL, 0x000fe200078e0217ULL,
0x000000f016417812ULL, 0x000fe200078ec0ffULL, 0x00005e001f1e7625ULL, 0x000fc800078e003bULL,
0x000000010f0e7824ULL, 0x100fe200078e0217ULL, 0x000000411e1e7210ULL, 0x000fe20007f5e0ffULL,
0x0000000144167824ULL, 0x000fe400078e0217ULL, 0x00005e000c0c7625ULL, 0x000fc800078e003bULL,
0x00005e000e0e7625ULL, 0x000fe200078e003bULL, 0x000000410c0c7210ULL, 0x000fc60007f1e0ffULL,
0x0000000144457824ULL, 0x000fe400078e0202ULL, 0x00005e0016167625ULL, 0x000fe200078e003bULL,
0x0000c000143b7811ULL, 0x000fc600078e20ffULL, 0x0000001044447824ULL, 0x000fe200078e00ffULL,
0x0000004116167210ULL, 0x080fe20007f7e0ffULL, 0x000000ffff1f7224ULL, 0x000fe200010e061fULL,
0x000000410e0e7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200000e060dULL,
0xfffffff044447812ULL, 0x000fe200078ee245ULL, 0x000000ffff177224ULL, 0x000fe200018e0617ULL,
0x0000c00018417811ULL, 0x000fe200078e20ffULL, 0x000000ffff0f7224ULL, 0x000fe200010e060fULL,
0x0000c00024457811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e3b7faeULL, 0x0003e2000b901c46ULL, 0x0000c00044477811ULL, 0x000fc600078e20ffULL,
0x000000000c417faeULL, 0x0003e8000b901c46ULL, 0x000000000e457faeULL, 0x0003e8000b901c46ULL,
0x0000000016477faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff0c7f8cULL, 0x000e64000c80043fULL,
0x000000ffff3b7224ULL, 0x002fc400078e000dULL, 0x00000000000c7805ULL, 0x000fca0000015200ULL,
0x0106b400ff0f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fc40007804843ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000e7805ULL, 0x000fcc0000015200ULL, 0x0000000e0c177210ULL, 0x000fca0007f1e1ffULL,
0x000000010f0f7824ULL, 0x000fe200000e0e0dULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0e7819ULL, 0x000fc8000001140fULL,
0x000000170e0e7211ULL, 0x000fca00078110ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060fULL,
0x000000020e0e7819ULL, 0x000fc8000000120fULL, 0x0000000e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000114147810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106b400ff0f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe40007804843ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000014000007945ULL, 0x000fe20003800000ULL, 0x0000012000001947ULL, 0x000fea0003800000ULL,
0x0000001bff0c723eULL, 0x000fe400000010ffULL, 0x00000002ff0d7819ULL, 0x000fe40000011602ULL,
0x000054100c0c7816ULL, 0x000fe2000000000cULL, 0x000090827f007947ULL, 0x000fea000b800000ULL,
0x00001f0d0c1d7589ULL, 0x0002a400000e0000ULL, 0x000000080d5b7810ULL, 0x002fe20007ffe0ffULL,
0x000090b27f007947ULL, 0x000fea000b800000ULL, 0x00001f5b0c1c7589ULL, 0x0002e400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000100d5b7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff5a7224ULL, 0x000fe200078e000cULL, 0x000168b000447802ULL, 0x000fc40000000f00ULL,
0x0000955000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000180d5b7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff5a7224ULL, 0x004fe200078e000cULL,
0x0001690000447802ULL, 0x000fc40000000f00ULL, 0x0000950000007944ULL, 0x008fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000000260c783bULL, 0x002e680000004200ULL, 0x000000002544783bULL, 0x000f280000004200ULL,
0x00000000384c783bULL, 0x000ee80000004200ULL, 0x000000002748783bULL, 0x000ea20000004200ULL,
0x000001000c937824ULL, 0x002fe200078e00ffULL, 0x0000000c00907306ULL, 0x000fe20000009400ULL,
0x00000018ffa47819ULL, 0x000fc4000001140cULL, 0x00000018ffaf7819ULL, 0x000fe2000001140dULL,
0x00000100459d7824ULL, 0x050fe200078e00ffULL, 0x00000018ff9f7819ULL, 0x000fe20000011493ULL,
0x0001000044987824ULL, 0x000fe200078e00ffULL, 0x00000018ff8b7819ULL, 0x000fe2000001140eULL,
0x0000000c00957306ULL, 0x000e620000005400ULL, 0x00000018ff877819ULL, 0x000fe2000001140fULL,
0x0001000045977824ULL, 0x000fe200078e00ffULL, 0x00000018ff9d7819ULL, 0x000fe2000001149dULL,
0x0000010046947824ULL, 0x000fe200078e00ffULL, 0x00000018ff807819ULL, 0x000fe20000011444ULL,
0x000001004fcf7824ULL, 0x048fe200078e00ffULL, 0x00000018ff987819ULL, 0x000fe20000011498ULL,
0x0000000c006c7306ULL, 0x000722000000d400ULL, 0x00000018ff7d7819ULL, 0x000fe20000011445ULL,
0x000100004fd07824ULL, 0x000fe200078e00ffULL, 0x00000018ff977819ULL, 0x000fe20000011497ULL,
0x000001004ecd7824ULL, 0x040fe200078e00ffULL, 0x00000018ff947819ULL, 0x000fe20000011494ULL,
0x000100004ece7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6e7819ULL, 0x000fe20000011446ULL,
0x0000009f009e7306ULL, 0x000fe20000209400ULL, 0x000100000c0c7824ULL, 0x008fe200078e00ffULL,
0x000000959000720bULL, 0x002fe20003fbd000ULL, 0x000001004dcb7824ULL, 0x040fe200078e00ffULL,
0x0000009f00957245ULL, 0x000fe2000020d400ULL, 0x000100004dcc7824ULL, 0x000fe200078e00ffULL,
0x00000018ffa07819ULL, 0x000fe2000001140cULL, 0x000001000d0c7824ULL, 0x000fe200078e00ffULL,
0x0000009f00a17306ULL, 0x0002e20000205400ULL, 0x00000018ff767819ULL, 0x000fc4000001144cULL,
0x00000018ff6f7819ULL, 0x000fe40000011447ULL, 0x00000018ffa97819ULL, 0x000fe2000001140cULL,
0x000001000e0c7824ULL, 0x000fe200078e00ffULL, 0x000000016c6c5812ULL, 0x010fe200078efcffULL,
0x0000000d00a77306ULL, 0x000fe20000009400ULL, 0x000000a0009f7245ULL, 0x002fe4000020d400ULL,
0x00000018ffb47819ULL, 0x000fe2000001140cULL, 0x000001000f0c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff587819ULL, 0x000fc4000001144fULL, 0x00000018ff667819ULL, 0x000fe2000001144dULL,
0x0000000d00a87306ULL, 0x000e620000005400ULL, 0x000000a19e00720bULL, 0x008fe40003f1d000ULL,
0x00000018ffbc7819ULL, 0x000fe2000001140cULL, 0x00000100440c7824ULL, 0x000fe200078e00ffULL,
0x00000018ffcf7819ULL, 0x000fe400000114cfULL, 0x00000018ffcd7819ULL, 0x000fe200000114cdULL,
0x0000000d006b7306ULL, 0x000722000000d400ULL, 0x00000018ffc27819ULL, 0x000fe2000001140cULL,
0x00010000460c7824ULL, 0x000fe200078e00ffULL, 0x00000018ffce7819ULL, 0x000fc400000114ceULL,
0x00000018ff5b7819ULL, 0x000fe4000001144eULL, 0x0000000195950812ULL, 0x000fe200078efcffULL,
0x000000a000a27306ULL, 0x000fe20000209400ULL, 0x000100000d0d7824ULL, 0x008fe200078e00ffULL,
0x000000a8a700720bULL, 0x002fe40003fdd000ULL, 0x00000018ff0c7819ULL, 0x000fe4000001140cULL,
0x00000018ffac7819ULL, 0x000fe2000001140dULL, 0x00000100470d7824ULL, 0x000fe200078e00ffULL,
0x000000a000a37306ULL, 0x0002e20000205400ULL, 0x00000018ffcb7819ULL, 0x000fc400000114cbULL,
0x000000ac00a17245ULL, 0x000fe4000020d400ULL, 0x00000018ff0d7819ULL, 0x000fe4000001140dULL,
0x000000016b6b6812ULL, 0x010fe200078efcffULL, 0x000000a900aa7306ULL, 0x000fe20000209400ULL,
0x000000a400a07245ULL, 0x002fe4000020d400ULL, 0x00000018ffd07819ULL, 0x000fe400000114d0ULL,
0x00000018ff1a7819ULL, 0x004fc40000011449ULL, 0x00000018ff417819ULL, 0x000fe20000011448ULL,
0x000000a900ab7306ULL, 0x000e620000205400ULL, 0x000000a3a200720bULL, 0x008fe40003f7d000ULL,
0x000000a900a27245ULL, 0x000fe4000020d400ULL, 0x00000018ffcc7819ULL, 0x000fe400000114ccULL,
0x00000018ff167819ULL, 0x000fe2000001144aULL, 0x000000a400a57306ULL, 0x000fe20000209400ULL,
0x00000018ff147819ULL, 0x000fc4000001144bULL, 0x0000006c956c723eULL, 0x000fc600000010ffULL,
0x000000019f9f3812ULL, 0x000fe400078efcffULL, 0x000000a400a67306ULL, 0x0004e20000205400ULL,
0x000000abaa00720bULL, 0x002fce0003f1d000ULL, 0x000000ac00ad7306ULL, 0x000fe20000209400ULL,
0x000000af00a47245ULL, 0x004fca000020d400ULL, 0x00000001a2a20812ULL, 0x000fe400078efcffULL,
0x000000ac00ae7306ULL, 0x000e620000205400ULL, 0x000000a6a500720bULL, 0x008fce0003f9d000ULL,
0x000000af00b07306ULL, 0x000fec0000209400ULL, 0x00000001a0a04812ULL, 0x000fe400078efcffULL,
0x000000af00b17306ULL, 0x000ea20000205400ULL, 0x000000aead00720bULL, 0x002fe40003fbd000ULL,
0x0000009fa0a0723eULL, 0x000fca00000010ffULL, 0x000000b400b57306ULL, 0x000fec0000209400ULL,
0x00000001a1a15812ULL, 0x000fe400078efcffULL, 0x000000b400b67306ULL, 0x000e620000205400ULL,
0x000000b1b000720bULL, 0x004fce0003f7d000ULL, 0x000000bc00bd7306ULL, 0x000fec0000209400ULL,
0x00000001a4a43812ULL, 0x000fe400078efcffULL, 0x000000bc00be7306ULL, 0x000ea20000205400ULL,
0x000000b6b500720bULL, 0x002fe40003f1d000ULL, 0x000000a1a4a1723eULL, 0x000fca00000010ffULL,
0x0000000e00b27306ULL, 0x000ff00000009400ULL, 0x0000000e00b37306ULL, 0x000e620000005400ULL,
0x000000bebd00720bULL, 0x004fce0003fdd000ULL, 0x0000000e00657306ULL, 0x0004f0000000d400ULL,
0x0000000f00ba7306ULL, 0x000fe20000009400ULL, 0x000100000e0e7824ULL, 0x004fe200078e00ffULL,
0x000000b3b200720bULL, 0x002fc80003f5d000ULL, 0x00000018ffb77819ULL, 0x000fe4000001140eULL,
0x0000000f00bb7306ULL, 0x000e6e0000005400ULL, 0x0000000165652812ULL, 0x008fe200078efcffULL,
0x0000000f00627306ULL, 0x0004f0000000d400ULL, 0x0000004400927306ULL, 0x000fe20000009400ULL,
0x000100000f0f7824ULL, 0x004fe200078e00ffULL, 0x000000bbba00720bULL, 0x002fc80003f9d000ULL,
0x00000018ffbf7819ULL, 0x000fe4000001140fULL, 0x0000004400917306ULL, 0x000e6e0000005400ULL,
0x0000000162624812ULL, 0x008fe200078efcffULL, 0x0000008b008c7306ULL, 0x000ff00000209400ULL,
0x0000008b008d7306ULL, 0x000ea20000205400ULL, 0x000000919200720bULL, 0x002fc40003fbd000ULL,
0x000000b400927245ULL, 0x000fe4000020d400ULL, 0x000000bc00917245ULL, 0x000fe4000020d400ULL,
0x0000000192920812ULL, 0x000fe200078efcffULL, 0x000000b700b87306ULL, 0x000fe20000209400ULL,
0x0000000191916812ULL, 0x000fc800078efcffULL, 0x000000629191723eULL, 0x000fc600000010ffULL,
0x000000b700b97306ULL, 0x0002e20000205400ULL, 0x0000008d8c00720bULL, 0x004fe40003f1d000ULL,
0x0000008b008c7245ULL, 0x000fe4000020d400ULL, 0x000000bf008d7245ULL, 0x000fc6000020d400ULL,
0x000000bf00c07306ULL, 0x000fe20000209400ULL, 0x000000b700b77245ULL, 0x002fca000020d400ULL,
0x000000018c8c0812ULL, 0x000fe400078efcffULL, 0x000000bf00c17306ULL, 0x000e620000205400ULL,
0x000000b9b800720bULL, 0x008fce0003f7d000ULL, 0x000000c200c37306ULL, 0x000fec0000209400ULL,
0x00000001b7b73812ULL, 0x000fe400078efcffULL, 0x000000c200c47306ULL, 0x000ea20000205400ULL,
0x000000c1c000720bULL, 0x002fe40003fdd000ULL, 0x000000b78c8c723eULL, 0x000fca00000010ffULL,
0x00000087008e7306ULL, 0x000fec0000209400ULL, 0x000000018d8d6812ULL, 0x000fe400078efcffULL,
0x00000087008f7306ULL, 0x000e620000205400ULL, 0x000000c4c300720bULL, 0x004fce0003f9d000ULL,
0x00000045008a7306ULL, 0x000ff00000009400ULL, 0x0000004500897306ULL, 0x000ea20000005400ULL,
0x0000008f8e00720bULL, 0x002fce0003f5d000ULL, 0x0000004600887306ULL, 0x000ff00000009400ULL,
0x0000004600857306ULL, 0x000e620000005400ULL, 0x000000898a00720bULL, 0x004fe40003f7d000ULL,
0x00000087008a7245ULL, 0x000fc8000020d400ULL, 0x000000018a8a2812ULL, 0x000fe200078efcffULL,
0x0000009d00c77306ULL, 0x000fe60000209400ULL, 0x0000008d8a8d723eULL, 0x000fca00000010ffULL,
0x0000009d00c87306ULL, 0x000ea20000205400ULL, 0x000000858800720bULL, 0x002fe40003fdd000ULL,
0x000000c200857245ULL, 0x000fc8000020d400ULL, 0x0000000185854812ULL, 0x000fe200078efcffULL,
0x0000008000867306ULL, 0x000ff00000209400ULL, 0x0000008000837306ULL, 0x000e620000205400ULL,
0x000000c8c700720bULL, 0x004fce0003f1d000ULL, 0x0000004500617306ULL, 0x0004f0000000d400ULL,
0x0000009800c57306ULL, 0x000fe20000209400ULL, 0x000000838600720bULL, 0x002fe20003f9d000ULL,
0x000001004a457824ULL, 0x004fe200078e00ffULL, 0x0000009d00867245ULL, 0x000fc8000020d400ULL,
0x0000000186860812ULL, 0x000fe200078efcffULL, 0x0000009800c67306ULL, 0x0002a20000205400ULL,
0x0000000161613812ULL, 0x008fce00078efcffULL, 0x0000007d00827306ULL, 0x000fe20000209400ULL,
0x0000009800987245ULL, 0x002fce000020d400ULL, 0x0000007d007f7306ULL, 0x000e620000205400ULL,
0x000000c6c500720bULL, 0x004fce0003f5d000ULL, 0x0000009700c97306ULL, 0x000fec0000209400ULL,
0x0000000198982812ULL, 0x000fe400078efcffULL, 0x0000009700ca7306ULL, 0x0004e20000205400ULL,
0x0000007f8200720bULL, 0x002fe40003f7d000ULL, 0x00000080007f7245ULL, 0x000fc4000020d400ULL,
0x0000007d00807245ULL, 0x000fe4000020d400ULL, 0x000000017f7f4812ULL, 0x000fe200078efcffULL,
0x0000000d00997306ULL, 0x000fe20000209400ULL, 0x0000009700977245ULL, 0x004fe4000020d400ULL,
0x000000987f98723eULL, 0x000fc600000010ffULL, 0x0000000180803812ULL, 0x000fe400078efcffULL,
0x0000000d009a7306ULL, 0x000e620000205400ULL, 0x000000cac900720bULL, 0x008fce0003f1d000ULL,
0x00000046005a7306ULL, 0x0004ec000000d400ULL, 0x0000000197970812ULL, 0x000fe400078efcffULL,
0x00000094009c7306ULL, 0x000fe20000209400ULL, 0x0001000047467824ULL, 0x004fe200078e00ffULL,
0x0000009a9900720bULL, 0x002fc40003f9d000ULL, 0x000000978099723eULL, 0x000fe400000010ffULL,
0x00000018ff467819ULL, 0x000fe40000011446ULL, 0x00000094009b7306ULL, 0x000e620000205400ULL,
0x000000015a5a6812ULL, 0x008fce00078efcffULL, 0x0000004c007e7306ULL, 0x000ff00000009400ULL,
0x0000004c007b7306ULL, 0x000ea20000005400ULL, 0x0000009b9c00720bULL, 0x002fce0003f5d000ULL,
0x00000046000f7306ULL, 0x000ff00000209400ULL, 0x00000046000e7306ULL, 0x0002e20000205400ULL,
0x0000007b7e00720bULL, 0x004fe40003f1d000ULL, 0x0000000d007e7245ULL, 0x000fc4000020d400ULL,
0x00000094007b7245ULL, 0x000fe4000020d400ULL, 0x000000017e7e4812ULL, 0x000fe200078efcffULL,
0x0000004d00247306ULL, 0x000fe20000009400ULL, 0x0000b8003a0d7811ULL, 0x000fe400078e20ffULL,
0x000000017b7b2812ULL, 0x000fe400078efcffULL, 0x0000004600467245ULL, 0x002fe4000020d400ULL,
0x0000005a7b5a723eULL, 0x000fe200000010ffULL, 0x0000004d00257306ULL, 0x000e620000005400ULL,
0x0000000e0f00720bULL, 0x008fce0003f9d000ULL, 0x0000006e00267306ULL, 0x000fec0000209400ULL,
0x0000000146464812ULL, 0x000fe400078efcffULL, 0x0000006e00277306ULL, 0x0004e20000205400ULL,
0x000000252400720bULL, 0x002fe40003f7d000ULL, 0x0000b80039247811ULL, 0x000fc400078e20ffULL,
0x0000000c00397245ULL, 0x000fc6000020d400ULL, 0x0000000c00937306ULL, 0x000fe20000209400ULL,
0x0000006e006e7245ULL, 0x004fce000020d400ULL, 0x0000000c00967306ULL, 0x0002a20000205400ULL,
0x000000272600720bULL, 0x008fe40003f5d000ULL, 0x000000002424783bULL, 0x000eea0000000200ULL,
0x0000004700847306ULL, 0x000fe20000009400ULL, 0x000000000d0c783bULL, 0x002e6a0000000200ULL,
0x000000016e6e2812ULL, 0x000fc400078efcffULL, 0x0000004700817306ULL, 0x000fe20000005400ULL,
0x000000969300720bULL, 0x004fce0003fdd000ULL, 0x0000004700577306ULL, 0x0005ec000000d400ULL,
0x0000000139396812ULL, 0x000fe400078efcffULL, 0x0000007600747306ULL, 0x000fe20000209400ULL,
0x000001004c477824ULL, 0x004fe200078e00ffULL, 0x000000396e6e723eULL, 0x000fc800000010ffULL,
0x00000018ff477819ULL, 0x000fe40000011447ULL, 0x0000007600717306ULL, 0x0005240000205400ULL,
0x00000047003a7245ULL, 0x000fe2000020d400ULL, 0x0000001d24249231ULL, 0x088fe400003400ffULL,
0x0000001d26269231ULL, 0x000fe400003400ffULL, 0x0000001c25259231ULL, 0x080fe200003400ffULL,
0x00000044005e7306ULL, 0x000722000000d400ULL, 0x0000007600767245ULL, 0x004fe2000020d400ULL,
0x0000001c27279231ULL, 0x000fc400003400ffULL, 0x0000001d0c0c9231ULL, 0x082fe400003400ffULL,
0x0000001d0e0e9231ULL, 0x000fe400003400ffULL, 0x0000004c00557306ULL, 0x000e62000000d400ULL,
0x000100004c447824ULL, 0x008fe200078e00ffULL, 0x000000717400720bULL, 0x010fe20003f9d000ULL,
0x0000001c0d0d9231ULL, 0x080fe200003400ffULL, 0x000000a02434723cULL, 0x000fe20000041834ULL,
0x0000001c0f0f9231ULL, 0x000fe200003400ffULL, 0x00000018ff907819ULL, 0x000fe20000011444ULL,
0x000001004b447824ULL, 0x000fe200078e00ffULL, 0x0000004f00787306ULL, 0x000fe20000009400ULL,
0x000000015e5e5812ULL, 0x000fc400078efcffULL, 0x000000818400720bULL, 0x000fe20003fbd000ULL,
0x0000008c242c723cULL, 0x000fe2000004182cULL, 0x0000005e855e723eULL, 0x000fe400000010ffULL,
0x0000000176764812ULL, 0x000fe200078efcffULL, 0x0000004f00737306ULL, 0x000ea20000005400ULL,
0x0000000155550812ULL, 0x002fc600078efcffULL, 0x000000982408723cULL, 0x000fe80000041808ULL,
0x0000004f00387306ULL, 0x000e62000000d400ULL, 0x0000000157575812ULL, 0x000fce00078efcffULL,
0x00000047004c7306ULL, 0x000fe20000209400ULL, 0x000000737800720bULL, 0x004fce0003f1d000ULL,
0x00000047004f7306ULL, 0x0004ec0000205400ULL, 0x0000000138380812ULL, 0x002fe400078efcffULL,
0x0000006600757306ULL, 0x000fe20000209400ULL, 0x0000009000477245ULL, 0x004fce000020d400ULL,
0x0000006600727306ULL, 0x0002a20000205400ULL, 0x0000004f4c00720bULL, 0x008fce0003fdd000ULL,
0x0000004e00777306ULL, 0x000fe20000009400ULL, 0x0000006600667245ULL, 0x002fca000020d400ULL,
0x000000013a3a6812ULL, 0x000fe400078efcffULL, 0x0000004e007a7306ULL, 0x000e620000005400ULL,
0x000000727500720bULL, 0x004fce0003f9d000ULL, 0x00000090009e7306ULL, 0x000fec0000209400ULL,
0x0000000166664812ULL, 0x000fe400078efcffULL, 0x0000009000a37306ULL, 0x0004e20000205400ULL,
0x0000007a7700720bULL, 0x002fe40003fdd000ULL, 0x000000cc00777245ULL, 0x000fca000020d400ULL,
0x000000cf00817306ULL, 0x000fe20000209400ULL, 0x000000659290723eULL, 0x004fce00000010ffULL,
0x000000cf00847306ULL, 0x000e620000205400ULL, 0x000000a39e00720bULL, 0x008fe20003f5d000ULL,
0x000000902430723cULL, 0x000f6c0000041830ULL, 0x0000006f00797306ULL, 0x000fec0000209400ULL,
0x0000000147472812ULL, 0x000fc400078efcffULL, 0x0000006f007c7306ULL, 0x0004e20000205400ULL,
0x000000848100720bULL, 0x002fe40003f9d000ULL, 0x000000477676723eULL, 0x000fca00000010ffULL,
0x0000004d00527306ULL, 0x000322000000d400ULL, 0x0000006f006f7245ULL, 0x004fce000020d400ULL,
0x0000004e00437306ULL, 0x000522000000d400ULL, 0x00000100494d7824ULL, 0x002fe200078e00ffULL,
0x0000007c7900720bULL, 0x008fc80003fbd000ULL, 0x00000018ff717819ULL, 0x000fe4000001144dULL,
0x0000004900687306ULL, 0x000fe20000009400ULL, 0x00000100484e7824ULL, 0x004fe200078e00ffULL,
0x0000000152523812ULL, 0x010fe400078efcffULL, 0x0000005b004d7245ULL, 0x000fe4000020d400ULL,
0x00000018ff4e7819ULL, 0x000fe4000001144eULL, 0x0000004900677306ULL, 0x000e620000005400ULL,
0x0000000143436812ULL, 0x000fc400078efcffULL, 0x000000016f6f5812ULL, 0x000fe400078efcffULL,
0x0000004e00397245ULL, 0x000fe4000020d400ULL, 0x000000466f6f723eULL, 0x000fe200000010ffULL,
0x000000cd00897306ULL, 0x000fec0000209400ULL, 0x0000006e2420723cULL, 0x000fe40000041820ULL,
0x000000cd00887306ULL, 0x000ea20000205400ULL, 0x000000676800720bULL, 0x002fce0003f3d000ULL,
0x000000ce007d7306ULL, 0x000ff00000209400ULL, 0x000000ce00827306ULL, 0x0002e20000205400ULL,
0x000000888900720bULL, 0x004fce0003f7d000ULL, 0x0000004800707306ULL, 0x000fe20000009400ULL,
0x000000ce00ce7245ULL, 0x002fce000020d400ULL, 0x00000048006d7306ULL, 0x000e620000005400ULL,
0x000000827d00720bULL, 0x008fce0003fdd000ULL, 0x0000005b00607306ULL, 0x000fec0000209400ULL,
0x00000001cece6812ULL, 0x000fe400078efcffULL, 0x0000005b005f7306ULL, 0x0004e20000205400ULL,
0x0000006d7000720bULL, 0x002fe40003f5d000ULL, 0x0000006ba26d723eULL, 0x000fca00000010ffULL,
0x0000004900197306ULL, 0x000322000000d400ULL, 0x000000577e5b723eULL, 0x004fe200000010ffULL,
0x0000006c243c723cULL, 0x040f6c000004183cULL, 0x000000cb00a57306ULL, 0x000fe20000209400ULL,
0x0001000049497824ULL, 0x002fe200078e00ffULL, 0x0000005a2404723cULL, 0x000fe80000041804ULL,
0x00000018ff687819ULL, 0x000fc40000011449ULL, 0x000000cb00a67306ULL, 0x0002a20000205400ULL,
0x000000cf00497245ULL, 0x000fe4000020d400ULL, 0x000000d000cf7245ULL, 0x000fe4000020d400ULL,
0x0000000149494812ULL, 0x000fe400078efcffULL, 0x0000005f6000720bULL, 0x008fe20003f9d000ULL,
0x0000004b00647306ULL, 0x000fe20000009400ULL, 0x000000cb00cb7245ULL, 0x002fe4000020d400ULL,
0x00000018ff607819ULL, 0x000fc40000011445ULL, 0x00000061865f723eULL, 0x000fe400000010ffULL,
0x0000000119191812ULL, 0x010fe200078efcffULL, 0x0000004b00637306ULL, 0x000fe20000005400ULL,
0x000000a6a500720bULL, 0x004fe40003fbd000ULL, 0x000000384949723eULL, 0x000fe200000010ffULL,
0x0000005e2428723cULL, 0x000b620000041828ULL, 0x000000014d4d4812ULL, 0x000fc600078efcffULL,
0x000000d000837306ULL, 0x000fe20000209400ULL, 0x000000ce4dce723eULL, 0x000fe400000010ffULL,
0x0000004100247245ULL, 0x020fe4000020d400ULL, 0x0000006800257245ULL, 0x000fe4000020d400ULL,
0x00000001cbcb5812ULL, 0x000fe200078efcffULL, 0x000000d0004c7306ULL, 0x000e620000205400ULL,
0x0000007100267245ULL, 0x000fe4000020d400ULL, 0x00000052cb45723eULL, 0x000fca00000010ffULL,
0x00000048001e7306ULL, 0x0004f0000000d400ULL, 0x0000004e004f7306ULL, 0x000fe20000209400ULL,
0x0001000048487824ULL, 0x004fe200078e00ffULL, 0x0000004c8300720bULL, 0x002fc80003fdd000ULL,
0x00000018ff6b7819ULL, 0x000fe40000011448ULL, 0x0000004e00747306ULL, 0x000e620000205400ULL,
0x000000cd00487245ULL, 0x000fe4000020d400ULL, 0x000000011e1e2812ULL, 0x008fe400078efcffULL,
0x0000000148483812ULL, 0x000fe400078efcffULL, 0x000000636400720bULL, 0x000fe20003f7d000ULL,
0x00000058005c7306ULL, 0x000fe20000209400ULL, 0x00000001cfcf6812ULL, 0x000fc400078efcffULL,
0x000000434848723eULL, 0x000fca00000010ffULL, 0x00000058005d7306ULL, 0x0004e20000205400ULL,
0x000000744f00720bULL, 0x002fe20003f9d000ULL, 0x000000480c30723cULL, 0x000b6c0000041830ULL,
0x000000cc00a77306ULL, 0x000fe20000209400ULL, 0x0000005800587245ULL, 0x004fca000020d400ULL,
0x0000000139394812ULL, 0x000fe400078efcffULL, 0x000000cc008e7306ULL, 0x000e620000205400ULL,
0x0000005d5c00720bULL, 0x008fe40003f1d000ULL, 0x00000018ff5c7819ULL, 0x000fe40000011444ULL,
0x000000553a44723eULL, 0x000fe400000010ffULL, 0x0000001e391e723eULL, 0x000fe200000010ffULL,
0x0000004100567306ULL, 0x000fe80000209400ULL, 0x000000440c3c723cULL, 0x000b64000004183cULL,
0x0000000158580812ULL, 0x000fc400078efcffULL, 0x0000004100597306ULL, 0x000ea20000205400ULL,
0x0000008ea700720bULL, 0x002fe40003fbd000ULL, 0x000000cf58cf723eULL, 0x000fca00000010ffULL,
0x0000006800637306ULL, 0x000fe40000209400ULL, 0x000000ce0c2c723cULL, 0x000b68000004182cULL,
0x0000000177775812ULL, 0x000fe400078efcffULL, 0x0000006800627306ULL, 0x000e620000205400ULL,
0x000000595600720bULL, 0x004fe40003fdd000ULL, 0x000000776677723eULL, 0x000fca00000010ffULL,
0x0000007100727306ULL, 0x000fe40000209400ULL, 0x000000760c34723cULL, 0x000b680000041834ULL,
0x0000000124246812ULL, 0x000fe400078efcffULL, 0x0000007100737306ULL, 0x000ea20000205400ULL,
0x000000626300720bULL, 0x002fce0003f3d000ULL, 0x0000006b00707306ULL, 0x000fec0000209400ULL,
0x0000000125251812ULL, 0x000fe400078efcffULL, 0x0000006b00677306ULL, 0x0002e20000205400ULL,
0x000000737200720bULL, 0x004fce0003f9d000ULL, 0x0000004a006a7306ULL, 0x000fe20000009400ULL,
0x0000006b006b7245ULL, 0x002fca000020d400ULL, 0x0000000126264812ULL, 0x000fe400078efcffULL,
0x0000004a00697306ULL, 0x000e620000005400ULL, 0x000000677000720bULL, 0x008fce0003f5d000ULL,
0x0000001a00547306ULL, 0x000fec0000209400ULL, 0x000000016b6b2812ULL, 0x000fe400078efcffULL,
0x0000001a00537306ULL, 0x0004e20000205400ULL, 0x000000696a00720bULL, 0x002fe40003fbd000ULL,
0x0000006b2424723eULL, 0x000fca00000010ffULL, 0x0000004a00187306ULL, 0x000322000000d400ULL,
0x0000001a001a7245ULL, 0x004fce000020d400ULL, 0x0000004b00177306ULL, 0x000522000000d400ULL,
0x000100004a4a7824ULL, 0x002fe200078e00ffULL, 0x000000535400720bULL, 0x008fc80003f1d000ULL,
0x00000018ff4a7819ULL, 0x000fe4000001144aULL, 0x0000006000617306ULL, 0x000fe20000209400ULL,
0x000100004b4b7824ULL, 0x004fe200078e00ffULL, 0x0000000118185812ULL, 0x010fc800078efcffULL,
0x00000018ff4b7819ULL, 0x000fe4000001144bULL, 0x00000060004c7306ULL, 0x000e620000205400ULL,
0x000000011a1a0812ULL, 0x000fe400078efcffULL, 0x0000000117173812ULL, 0x000fe400078efcffULL,
0x000000251a25723eULL, 0x000fc600000010ffULL, 0x0000005c004f7306ULL, 0x000fe80000209400ULL,
0x000000240c08723cULL, 0x000b680000041808ULL, 0x0000005c00567306ULL, 0x0004e20000205400ULL,
0x0000004c6100720bULL, 0x002fce0003fdd000ULL, 0x00000014001f7306ULL, 0x000fe20000209400ULL,
0x0000005c005c7245ULL, 0x004fce000020d400ULL, 0x0000001400427306ULL, 0x0002a20000205400ULL,
0x000000564f00720bULL, 0x008fce0003f3d000ULL, 0x0000001600507306ULL, 0x000fe20000209400ULL,
0x0000001400147245ULL, 0x002fca000020d400ULL, 0x000000015c5c1812ULL, 0x000fe400078efcffULL,
0x0000001600517306ULL, 0x000e620000205400ULL, 0x000000421f00720bULL, 0x004fe40003f5d000ULL,
0x00000019261f723eULL, 0x000fe400000010ffULL, 0x0000006000197245ULL, 0x000fc6000020d400ULL,
0x0000004a00467306ULL, 0x000fe20000209400ULL, 0x0000000119196812ULL, 0x000fe200078efcffULL,
0x0000001e0c28723cULL, 0x000b660000041828ULL, 0x000000181918723eULL, 0x000fe400000010ffULL,
0x000000175c19723eULL, 0x000fe200000010ffULL, 0x0000004a00277306ULL, 0x0004e20000205400ULL,
0x000000515000720bULL, 0x002fe40003f9d000ULL, 0x0000001600177245ULL, 0x000fc4000020d400ULL,
0x0000000114142812ULL, 0x000fe200078efcffULL, 0x000000180c04723cULL, 0x000b640000041804ULL,
0x0000004b003a7306ULL, 0x000fe20000209400ULL, 0x0000004a004a7245ULL, 0x004fca000020d400ULL,
0x0000000117174812ULL, 0x000fe400078efcffULL, 0x0000004b00437306ULL, 0x0002a20000205400ULL,
0x000000274600720bULL, 0x008fe40003f1d000ULL, 0x0000004b004b7245ULL, 0x002fd6000020d400ULL,
0x000000014a4a0812ULL, 0x000fe400078efcffULL, 0x000000433a00720bULL, 0x004fe40003fbd000ULL,
0x0000004a174a723eULL, 0x000fd600000010ffULL, 0x000000014b4b5812ULL, 0x000fc800078efcffULL,
0x0000004b144b723eULL, 0x000fce00000010ffULL, 0x0000004a0c0c723cULL, 0x000b620000041820ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff167f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a000ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff467224ULL, 0x002fc600078e0017ULL,
0x0000000115157810ULL, 0x000fc80007ffe0ffULL, 0x000000101500720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xfffe884000007947ULL, 0x000fea000383ffffULL,
0x000000ff1000720cULL, 0x000fe20003f05270ULL, 0x000000ffff1b7224ULL, 0x020fe400078e000dULL,
0x000000ffff1c7224ULL, 0x000fe400078e000fULL, 0x000000ffff1d7224ULL, 0x000fe400078e000eULL,
0x000000ffff1a7224ULL, 0x000fe400078e000cULL, 0x000000ffff187224ULL, 0x000fe400078e0007ULL,
0x000000ffff197224ULL, 0x000fc400078e0006ULL, 0x000000ffff177224ULL, 0x000fe400078e0005ULL,
0x000000ffff167224ULL, 0x000fe400078e0004ULL, 0x000000ffff147224ULL, 0x004fe400078e000bULL,
0x000000ffff157224ULL, 0x000fe400078e000aULL, 0x000000ffff0d7224ULL, 0x000fe400078e0009ULL,
0x000000ffff127224ULL, 0x000fe200078e0008ULL, 0x0000036000008947ULL, 0x000fea0003800000ULL,
0x0180000013027810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000002027812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0200780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0001889000057802ULL, 0x000fc40000000f00ULL,
0x000073a000007944ULL, 0x002fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000001300047308ULL, 0x000ea40000001000ULL, 0xbf80000004027423ULL, 0x004fc80000000013ULL,
0x800000ff02037221ULL, 0x000fc80000010100ULL, 0x0000000304047223ULL, 0x000fc40000000004ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006700ff037624ULL, 0x000fe400078e00ffULL,
0x00006600ff027624ULL, 0x000fca00078e00ffULL, 0x0000000602037981ULL, 0x000ea8000c1e9900ULL,
0x0000000000067919ULL, 0x000ee40000000000ULL, 0x00000002ff057819ULL, 0x008fe40000011606ULL,
0x0000000806077811ULL, 0x000fe200078ff0ffULL, 0x0000000403047220ULL, 0x004fca0000410000ULL,
0x00001f0504057589ULL, 0x000ea800000e0000ULL, 0x00001f0704067589ULL, 0x000ee200000e0000ULL,
0x0000003c053c7220ULL, 0x044fe20000410000ULL, 0x0000003d053d7220ULL, 0x040fe20000410000ULL,
0x0000003405347220ULL, 0x040fe20000410000ULL, 0x0000003505357220ULL, 0x040fe20000410000ULL,
0x0000003005307220ULL, 0x040fe20000410000ULL, 0x0000003105317220ULL, 0x040fe20000410000ULL,
0x0000002c052c7220ULL, 0x040fe20000410000ULL, 0x0000002d052d7220ULL, 0x040fe20000410000ULL,
0x0000002805287220ULL, 0x040fe20000410000ULL, 0x0000002905297220ULL, 0x040fe20000410000ULL,
0x0000001205127220ULL, 0x040fe20000410000ULL, 0x0000000d050d7220ULL, 0x040fe20000410000ULL,
0x0000001605167220ULL, 0x040fe20000410000ULL, 0x0000001705177220ULL, 0x040fe20000410000ULL,
0x0000001a051a7220ULL, 0x040fe20000410000ULL, 0x0000001b051b7220ULL, 0x000fe20000410000ULL,
0x0000003e063e7220ULL, 0x048fe20000410000ULL, 0x0000003f063f7220ULL, 0x040fe20000410000ULL,
0x0000003606367220ULL, 0x040fe20000410000ULL, 0x0000003706377220ULL, 0x040fe20000410000ULL,
0x0000003206327220ULL, 0x040fe20000410000ULL, 0x0000003306337220ULL, 0x040fe20000410000ULL,
0x0000002e062e7220ULL, 0x040fe20000410000ULL, 0x0000002f062f7220ULL, 0x040fe20000410000ULL,
0x0000002a062a7220ULL, 0x040fe20000410000ULL, 0x0000002b062b7220ULL, 0x040fe20000410000ULL,
0x0000001506157220ULL, 0x040fe20000410000ULL, 0x0000001406147220ULL, 0x040fe20000410000ULL,
0x0000001906197220ULL, 0x040fe20000410000ULL, 0x0000001806187220ULL, 0x040fe20000410000ULL,
0x0000001d061d7220ULL, 0x040fe20000410000ULL, 0x0000001c061c7220ULL, 0x000fc20000410000ULL,
0x00000000001e7919ULL, 0x000ea20000000000ULL, 0x00000000000579c3ULL, 0x000ee20000002700ULL,
0x0000580000047ab9ULL, 0x000fc40000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x00000002ff057819ULL, 0x004fc6000001161eULL,
0x00000005040472a4ULL, 0x008fe2000f8e023fULL, 0x000000021e027812ULL, 0x040fe400078ec0ffULL,
0x000000081e077811ULL, 0x000fe200078ff0ffULL, 0x0000000805047824ULL, 0x040fe200078e00ffULL,
0x0000000502037211ULL, 0x040fe200078ff8ffULL, 0x0000000805097824ULL, 0x040fe200078e00ffULL,
0x0000000702067211ULL, 0x000fe200078ff8ffULL, 0x0000000805087824ULL, 0x040fe200078e00ffULL,
0xfffffff804047812ULL, 0x000fe200078ee203ULL, 0x00000008050a7824ULL, 0x000fe200078e00ffULL,
0x0000000203027810ULL, 0x000fe20007ffe0ffULL, 0x0000000807077824ULL, 0x000fe200078e00ffULL,
0x0000000403057810ULL, 0x000fc40007ffe0ffULL, 0x0000000603037810ULL, 0x000fe40007ffe0ffULL,
0x000000201e107810ULL, 0x000fe40007ffe0ffULL, 0xfffffff80a0a7812ULL, 0x000fe200078ee203ULL,
0x000000081e037824ULL, 0x000fe200078e00ffULL, 0xfffffff8070c7812ULL, 0x000fe400078ee206ULL,
0xfffffff808087812ULL, 0x000fe400078ee205ULL, 0xfffffff809067812ULL, 0x000fc400078ee202ULL,
0x0000a00000057811ULL, 0x000fe400078e58ffULL, 0x0000003c3d00723eULL, 0x000fe400000010ffULL,
0x000000343502723eULL, 0x000fe200000010ffULL, 0x0000001004047824ULL, 0x100fe200078e0205ULL,
0x00000003ff137819ULL, 0x002fe20000011610ULL, 0x000000100c0c7824ULL, 0x100fe200078e0205ULL,
0x0000000803037812ULL, 0x000fe200078ec0ffULL, 0x0000001006067824ULL, 0x100fe200078e0205ULL,
0x00005410000e7816ULL, 0x100fe20000000002ULL, 0x0000001008087824ULL, 0x000fe200078e0205ULL,
0x00007632000f7816ULL, 0x000fe20000000002ULL, 0x0000000110027824ULL, 0x000fe200078e0213ULL,
0x00000003ff097819ULL, 0x000fe2000001161eULL, 0x0000000104047824ULL, 0x000fc400078e0203ULL,
0x000000100a0a7824ULL, 0x000fe200078e0205ULL, 0x00000007020b7812ULL, 0x000fe200078ec0ffULL,
0x0000000109007824ULL, 0x000fe200078e021eULL, 0x0000000e04007388ULL, 0x0003e20000000a00ULL,
0x00000001030c7824ULL, 0x000fe200078e020cULL, 0x0000002c2d02723eULL, 0x000fe200000010ffULL,
0x0000000103077824ULL, 0x040fe400078e0206ULL, 0x0000000103087824ULL, 0x040fe400078e0208ULL,
0x00000001030a7824ULL, 0x000fe200078e020aULL, 0x0000000700037812ULL, 0x000fc400078ec0ffULL,
0x000000303100723eULL, 0x000fe400000010ffULL, 0x0ffffff80b0e7812ULL, 0x002fe400078ef810ULL,
0x000000120d04723eULL, 0x000fe400000010ffULL, 0x00007632000f7816ULL, 0x100fe20000000002ULL,
0x000000100e127824ULL, 0x000fe200078e0205ULL, 0x00005410000e7816ULL, 0x000fe40000000002ULL,
0x0ffffff803067812ULL, 0x000fc400078ef81eULL, 0x000000282903723eULL, 0x000fe200000010ffULL,
0x0000000e07007388ULL, 0x0003e20000000a00ULL, 0x000000161700723eULL, 0x000fe200000010ffULL,
0x00000010060b7824ULL, 0x000fe200078e0205ULL, 0x0000001a1b02723eULL, 0x000fe400000010ffULL,
0x000000323305723eULL, 0x000fe400000010ffULL, 0x0000002e2f06723eULL, 0x000fe400000010ffULL,
0x000000071e1e7812ULL, 0x000fc400078ec0ffULL, 0x00007632050d7816ULL, 0x000fe40000000006ULL,
0x00005410030e7816ULL, 0x142fe40000000004ULL, 0x00007632030f7816ULL, 0x000fe40000000004ULL,
0x0000003e3f03723eULL, 0x000fe400000010ffULL, 0x000000363704723eULL, 0x000fe200000010ffULL,
0x0000000e08007388ULL, 0x0003e20000000a00ULL, 0x0000000710107812ULL, 0x000fc400078ec0ffULL,
0x00005410000e7816ULL, 0x142fe40000000002ULL, 0x00007632000f7816ULL, 0x000fe40000000002ULL,
0x0000002a2b00723eULL, 0x000fe400000010ffULL, 0x000000151402723eULL, 0x000fe200000010ffULL,
0x0000000e0a007388ULL, 0x0003e40000000a00ULL, 0x00005410030e7816ULL, 0x142fe40000000004ULL,
0x00007632030f7816ULL, 0x000fc40000000004ULL, 0x000000191803723eULL, 0x000fe400000010ffULL,
0x0000001d1c04723eULL, 0x000fe200000010ffULL, 0x0000000e0c007388ULL, 0x0003e40000000a00ULL,
0x00005410050c7816ULL, 0x002fe40000000006ULL, 0x0000000000057919ULL, 0x000e620000002600ULL,
0x0000541000067816ULL, 0x000fc60000000002ULL, 0x0004000c07007388ULL, 0x0005e40000000a00ULL,
0x0000763200077816ULL, 0x004fe40000000002ULL, 0x0000541003027816ULL, 0x140fe40000000004ULL,
0x0000763203037816ULL, 0x000fe20000000004ULL, 0x0004000608007388ULL, 0x0005e20000000a00ULL,
0x0000000805007824ULL, 0x002fc600078e00ffULL, 0x000400020a007388ULL, 0x0003e20000000a00ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000000000b0c7984ULL, 0x000ee20000000c00ULL,
0x0000000805047824ULL, 0x000fe200078e00ffULL, 0xfffffff800097812ULL, 0x000fe400078ee209ULL,
0x0000000012147984ULL, 0x000f220000000c00ULL, 0x1ffffff81e077812ULL, 0x004fe400078ef811ULL,
0xfffffff804137812ULL, 0x000fe400078ee213ULL, 0x0000000409097c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000413137c10ULL, 0x000fc4000ff3e0ffULL, 0x1ffffff810117812ULL, 0x000fe200078ef811ULL,
0x000000ffff067224ULL, 0x000fe200000e06ffULL, 0x00005a0009027a11ULL, 0x002fe200078048ffULL,
0x000000ffff007224ULL, 0x000fe200008e06ffULL, 0x00005a0013047a11ULL, 0x000fe400078248ffULL,
0x00005b0009037a11ULL, 0x000fe400000f4c06ULL, 0x00005b0013057a11ULL, 0x000fc600008f4c00ULL,
0x0000001007027825ULL, 0x000fc800078e0002ULL, 0x0000001011047825ULL, 0x000fe200078e0004ULL,
0x0000000c02007986ULL, 0x008fe8000c101d06ULL, 0x0000001404007986ULL, 0x010fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00006600ff047624ULL, 0x000fe400078e00ffULL,
0x00006700ff057624ULL, 0x000fca00078e00ffULL, 0x0000000604207981ULL, 0x000322000c1e9900ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000001ff0600780cULL, 0x000fe20003f04070ULL,
0x0000000212117824ULL, 0x000fe200078e00ffULL, 0x01060000ff047f8cULL, 0x002e62000c80043fULL,
0x0000004000127824ULL, 0x000fe400078e00ffULL, 0x0000580011117a24ULL, 0x000fc800078e0214ULL,
0x0000620011137a24ULL, 0x000fc800078e0212ULL, 0x000005a000000947ULL, 0x000fea0003800000ULL,
0x00000002ff1e7819ULL, 0x000fe20000011602ULL, 0x00000100ff237424ULL, 0x000fe200078e00ffULL,
0x000000300e217812ULL, 0x000fe400078ec0ffULL, 0x000000081e177810ULL, 0x040fe20007ffe0ffULL,
0x0000000113067824ULL, 0x040fe200078e021eULL, 0x000000101e227810ULL, 0x040fe40007ffe0ffULL,
0x000000181e247810ULL, 0x040fe20007ffe0ffULL, 0x0000000113087824ULL, 0x000fe200078e0217ULL,
0x000000201e1a7810ULL, 0x000fe20007ffe0ffULL, 0x00005e0006067625ULL, 0x000fe200078e0023ULL,
0x00000012030f7217ULL, 0x000fc40007800000ULL, 0x0000000202167211ULL, 0x000fe200078fe8ffULL,
0x00005e0008087625ULL, 0x000fe200078e0023ULL, 0x00000021060a7210ULL, 0x080fe40007f1e0ffULL,
0x00002000001b7811ULL, 0x000fe200078e68ffULL, 0x00000001130e7824ULL, 0x040fe200078e0222ULL,
0x00000021080c7210ULL, 0x000fe20007f3e0ffULL, 0x0000000113087824ULL, 0x000fe200078e0224ULL,
0x000000281e1c7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0b7224ULL, 0x000fe400000e0607ULL,
0x00005e000e067625ULL, 0x000fc800078e0023ULL, 0x000000ffff0d7224ULL, 0x000fe200008e0609ULL,
0x00000021060e7210ULL, 0x000fe20007f1e0ffULL, 0x00005e0008087625ULL, 0x000fc800078e0023ULL,
0x0000000113067824ULL, 0x000fe200078e021aULL, 0x0000002108147210ULL, 0x000fe20007f3e0ffULL,
0x000000010f087824ULL, 0x000fe400078e0a12ULL, 0x000000ffff0f7224ULL, 0x000fe400000e0607ULL,
0x00005e0006067625ULL, 0x000fe200078e0023ULL, 0x000000081e00720cULL, 0x080fe40003f06070ULL,
0x000000082200720cULL, 0x080fe20003fa6070ULL, 0x000000ffff157224ULL, 0x000fe200008e0609ULL,
0x0000000316097812ULL, 0x000fe200078ec0ffULL, 0x0000000417187824ULL, 0x040fe200078e00ffULL,
0x0000002106167210ULL, 0x000fe20007f5e0ffULL, 0x0000000422227824ULL, 0x000fe200078e00ffULL,
0x000000081700720cULL, 0x000fc40003f26070ULL, 0xfffffffc18067812ULL, 0x000fe200078ee209ULL,
0x000000ffff177224ULL, 0x000fe200010e0607ULL, 0x0ffffffc09027812ULL, 0x000fe400078ef802ULL,
0x000000082400720cULL, 0x080fe20003f86070ULL, 0x00000010061f7824ULL, 0x100fe200078e021bULL,
0x000000081a00720cULL, 0x080fe20003f66070ULL, 0x0000000113067824ULL, 0x000fe200078e021cULL,
0x000000081c00720cULL, 0x000fe20003f46070ULL, 0x00000010021d7824ULL, 0x000fe200078e021bULL,
0x000000301e027810ULL, 0x000fe20007ffe0ffULL, 0x00005e0006067625ULL, 0x000fe200078e0023ULL,
0x000000381e1e7810ULL, 0x000fc40007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a1d7faeULL, 0x0005e4000c101c46ULL, 0x0000002106187210ULL, 0x000fe20007fde0ffULL,
0x0000000113067824ULL, 0x040fe200078e0202ULL, 0x000000000c1f7faeULL, 0x0007e2000c901c46ULL,
0x000000080200720cULL, 0x080fe40003f26070ULL, 0x000000081e00720cULL, 0x000fe20003f06070ULL,
0x000000ffff197224ULL, 0x000fe400030e0607ULL, 0x0000000113087824ULL, 0x000fc400078e021eULL,
0x00000004240a7824ULL, 0x004fe400078e00ffULL, 0x000000041e1e7824ULL, 0x000fe400078e00ffULL,
0x000000041a0c7824ULL, 0x008fe200078e00ffULL, 0xfffffffc0a0a7812ULL, 0x100fe200078ee209ULL,
0x000000041c1a7824ULL, 0x000fe200078e00ffULL, 0xfffffffc1e1e7812ULL, 0x100fe200078ee209ULL,
0x00000004021c7824ULL, 0x000fe200078e00ffULL, 0xfffffffc22027812ULL, 0x100fe200078ee209ULL,
0x00005e0006067625ULL, 0x000fe200078e0023ULL, 0xfffffffc0c0c7812ULL, 0x000fc400078ee209ULL,
0xfffffffc1a1a7812ULL, 0x000fe200078ee209ULL, 0x00000010020b7824ULL, 0x100fe200078e021bULL,
0x0000002106067210ULL, 0x000fe20007fde0ffULL, 0x000000100a0d7824ULL, 0x000fe200078e021bULL,
0xfffffffc1c1c7812ULL, 0x000fe200078ee209ULL, 0x00005e0008087625ULL, 0x000fe200078e0023ULL,
0x000000000e0b7faeULL, 0x0005e6000e901c46ULL, 0x000000ffff077224ULL, 0x000fe200030e0607ULL,
0x0000002108087210ULL, 0x000fe20007fde0ffULL, 0x000000100c137824ULL, 0x100fe200078e021bULL,
0x00000000140d7faeULL, 0x0005e2000e101c46ULL, 0x000000101a1d7824ULL, 0x000fc400078e021bULL,
0x000000101c1f7824ULL, 0x100fe200078e021bULL, 0x0000000016137faeULL, 0x0005e2000d901c46ULL,
0x000000101e1b7824ULL, 0x000fe400078e021bULL, 0x000000ffff097224ULL, 0x000fe200030e0609ULL,
0x00000000181d7faeULL, 0x0005e8000d101c46ULL, 0x00000000061f7faeULL, 0x0005e8000c901c46ULL,
0x00000000081b7faeULL, 0x0005e2000c101c46ULL, 0x000004e000007947ULL, 0x000fea0003800000ULL,
0x0000001302067211ULL, 0x040fe200078ff0ffULL, 0x00000100ff277424ULL, 0x000fe200078e00ffULL,
0x0000000202077211ULL, 0x000fc400078fe8ffULL, 0x00000008021a7811ULL, 0x040fe400078ff0ffULL,
0x0000002802147811ULL, 0x000fe400078ff0ffULL, 0x0000000307197812ULL, 0x000fe200078ec0ffULL,
0x00005e0006067625ULL, 0x000fe200078e0027ULL, 0x000000300e297812ULL, 0x000fe400078ec0ffULL,
0x00000010020a7811ULL, 0x040fe200078ff0ffULL, 0x0000000113087824ULL, 0x040fe200078e021aULL,
0x0000003002167811ULL, 0x000fe200078ff0ffULL, 0x000000041a227824ULL, 0x000fe200078e00ffULL,
0x00000020020e7811ULL, 0x040fe200078ff0ffULL, 0x00000001131a7824ULL, 0x040fe200078e0214ULL,
0x00000018020c7811ULL, 0x000fe200078ff0ffULL, 0x0000000414287824ULL, 0x000fe200078e00ffULL,
0x0000002906147210ULL, 0x000fe20007f1e0ffULL, 0x0000000113097824ULL, 0x040fe200078e020aULL,
0x0000003802187811ULL, 0x000fe200078ff0ffULL, 0x00000001131c7824ULL, 0x040fe200078e0216ULL,
0x0000200000257811ULL, 0x000fe200078e68ffULL, 0x00000004162a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc28167812ULL, 0x000fe200078ee219ULL, 0x00000001130f7824ULL, 0x000fc400078e020eULL,
0x000000ffff157224ULL, 0x000fe200000e0607ULL, 0xfffffffc2a177812ULL, 0x100fe200078ee219ULL,
0x000000040a247824ULL, 0x000fe400078e00ffULL, 0x000000040c267824ULL, 0x000fe400078e00ffULL,
0x000000040e0e7824ULL, 0x000fe400078e00ffULL, 0x00000001131e7824ULL, 0x000fe200078e0218ULL,
0xfffffffc260d7812ULL, 0x100fe200078ee219ULL, 0x00005e0008067625ULL, 0x000fe200078e0027ULL,
0xfffffffc0e0e7812ULL, 0x000fc600078ee219ULL, 0x0000000418187824ULL, 0x000fe400078e00ffULL,
0x00000001130a7824ULL, 0x000fe200078e020cULL, 0x0ffffffc19137812ULL, 0x000fe200078ef802ULL,
0x00005e0009087625ULL, 0x000fe200078e0027ULL, 0xfffffffc22027812ULL, 0x100fe400078ee219ULL,
0xfffffffc240c7812ULL, 0x000fe200078ee219ULL, 0x0000001016217824ULL, 0x000fe200078e0225ULL,
0x0000002906167210ULL, 0x000fe20007f1e0ffULL, 0x00005e000a0a7625ULL, 0x000fe200078e0027ULL,
0xfffffffc18197812ULL, 0x000fc400078ee219ULL, 0x0000002908187210ULL, 0x000fe20007f3e0ffULL,
0x00000010132b7824ULL, 0x100fe400078e0225ULL, 0x0000001017237824ULL, 0x100fe400078e0225ULL,
0x0000001002137824ULL, 0x100fe200078e0225ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000142b7faeULL, 0x0005e2000b901c46ULL, 0x000000100c1b7824ULL, 0x100fe400078e0225ULL,
0x000000100d1d7824ULL, 0x100fe400078e0225ULL, 0x000000100e1f7824ULL, 0x000fc400078e0225ULL,
0x000000ffff177224ULL, 0x000fe200000e0607ULL, 0x000000290a0a7210ULL, 0x000fe20007f1e0ffULL,
0x0000001019257824ULL, 0x000fe400078e0225ULL, 0x000000ffff197224ULL, 0x000fe200008e0609ULL,
0x0000000016137faeULL, 0x0005e2000b901c46ULL, 0x00005e000f067625ULL, 0x000fc600078e0027ULL,
0x00000000181b7faeULL, 0x0005e2000b901c46ULL, 0x00005e001a087625ULL, 0x000fc800078e0027ULL,
0x00005e001c0c7625ULL, 0x000fe200078e0027ULL, 0x0000002908087210ULL, 0x000fc60007f3e0ffULL,
0x00005e001e0e7625ULL, 0x000fe200078e0027ULL, 0x000000290c0c7210ULL, 0x000fc60007f5e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e060bULL, 0x0000002906067210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0609ULL, 0x000000290e0e7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200010e060dULL, 0x000000000a1d7faeULL, 0x0005e2000b901c46ULL,
0x000000ffff077224ULL, 0x000fe400000e0607ULL, 0x000000ffff0f7224ULL, 0x000fc600018e060fULL,
0x00000000061f7faeULL, 0x0005e8000b901c46ULL, 0x0000000008217faeULL, 0x0005e8000b901c46ULL,
0x000000000c237faeULL, 0x0005e8000b901c46ULL, 0x000000000e257faeULL, 0x0005e4000b901c46ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000067805ULL, 0x004fc40000015200ULL,
0x01060400ff097984ULL, 0x000ea40000000800ULL, 0x8000000009ff7812ULL, 0x006fc40007804805ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x00000008060b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e07ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff027819ULL, 0x000fc80000011409ULL,
0x0000000b02027211ULL, 0x000fca00078110ffULL, 0x000000ffff097224ULL, 0x000fca00000e0609ULL,
0x0000000202027819ULL, 0x000fc80000001209ULL, 0x000000020000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01060400ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000e640000000000ULL, 0x0000002000027824ULL, 0x002fca00078e0205ULL,
0x00000003ff047819ULL, 0x000fe40000011602ULL, 0x0000000f02027812ULL, 0x000fe400078ec0ffULL,
0x1ffffffe04057812ULL, 0x000fe400078ec0ffULL, 0x0000000102047810ULL, 0x040fe20007ffe0ffULL,
0x0000002002087824ULL, 0x040fe400078e00ffULL, 0x0000000102067824ULL, 0x040fe400078e0205ULL,
0x0000000105077824ULL, 0x040fe200078e0204ULL, 0x0000001005057810ULL, 0x000fe20007ffe0ffULL,
0x0000002002097824ULL, 0x000fe200078e00ffULL, 0x0000001f06067812ULL, 0x000fe200078ec0ffULL,
0x0000002002147824ULL, 0x000fe200078e00ffULL, 0x0000001f07077812ULL, 0x000fe200078ec0ffULL,
0x0000000104047824ULL, 0x100fe200078e0205ULL, 0x000001e009067812ULL, 0x000fe200078ee206ULL,
0x0000000102137824ULL, 0x000fe200078e0205ULL, 0x000001e008077812ULL, 0x000fe200078ee207ULL,
0x0000002002057824ULL, 0x000fe200078e00ffULL, 0x0000001f04047812ULL, 0x000fe200078ec0ffULL,
0x00000000060c7984ULL, 0x000e62000000cc00ULL, 0x0000001f13137812ULL, 0x000fc400078ec0ffULL,
0x000001e005047812ULL, 0x000fe200078ee204ULL, 0x0000000007087984ULL, 0x000ea2000000cc00ULL,
0x000001e014137812ULL, 0x000fe200078ee213ULL, 0x000000ffff187224ULL, 0x002fe400078e000cULL,
0x000000ffff197224ULL, 0x000fe400078e000eULL, 0x000000ffff1a7224ULL, 0x004fe400078e0008ULL,
0x000000ffff1b7224ULL, 0x000fe400078e000aULL, 0x000000ffff1e7224ULL, 0x000fc400078e0009ULL,
0x000000ffff1f7224ULL, 0x000fe200078e000bULL, 0x0000001806007388ULL, 0x000fe2000000cc00ULL,
0x000000ffff1c7224ULL, 0x000fe400078e000dULL, 0x000000ffff1d7224ULL, 0x000fca00078e000fULL,
0x0000001c07007388ULL, 0x000fe8000000cc00ULL, 0x0000000004087984ULL, 0x000e68000000cc00ULL,
0x00000000130c7984ULL, 0x000ea2000000cc00ULL, 0x000000ffff177224ULL, 0x002fe400078e000aULL,
0x000000ffff167224ULL, 0x000fc400078e0008ULL, 0x000000ffff0a7224ULL, 0x000fe400078e0009ULL,
0x000000ffff147224ULL, 0x004fe400078e000cULL, 0x000000ffff157224ULL, 0x000fe400078e000eULL,
0x000000ffff087224ULL, 0x000fe400078e000dULL, 0x000000ffff097224ULL, 0x000fe200078e000fULL,
0x0000001413007388ULL, 0x0003e8000000cc00ULL, 0x0000000804007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01060000ff087f8cULL, 0x002e62000c80043fULL,
0x000000ffff0a7224ULL, 0x000fc600078e00ffULL, 0x0000000000047805ULL, 0x000fc80000015200ULL,
0x01060400ff077984ULL, 0x000ea40000000800ULL, 0x8000000007ff7812ULL, 0x006fc40007804809ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x00000006040b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09000b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff027819ULL, 0x000fc80000011407ULL, 0x0000000b02027211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000202027819ULL, 0x000fc80000001207ULL,
0x000000020000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01060400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff1000720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000e620000000000ULL,
0x3d80000020137820ULL, 0x010fe20000410000ULL, 0x0001068800387811ULL, 0x000fe200078e18ffULL,
0x000000ffff3b7224ULL, 0x000fe200078e00ffULL, 0xffffffff10397810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fe200078e00ffULL, 0x00010608003a7811ULL, 0x000fc400078e28ffULL,
0x000001003b3c7824ULL, 0x000fe200078e0212ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x0000003c0300720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x00cfea0003800000ULL,
0x000000ffff3f7224ULL, 0x000fe200078e003dULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x000000ffff3e7224ULL, 0x000fe200078e00ffULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fc4000001ff00ULL,
0x000000013e287810ULL, 0x000fe20007ffe0ffULL, 0x00000a8000007945ULL, 0x000fe20003800000ULL,
0x000000ffff407224ULL, 0x000fe200078e003eULL, 0x000000013f3d7812ULL, 0x000fc400078e0cffULL,
0x0000003b28297211ULL, 0x040fe200078ff0ffULL, 0x000000ffff3e7224ULL, 0x000fe200078e0028ULL,
0x000000042800780cULL, 0x040fe40003f06070ULL, 0x00000001292b7810ULL, 0x040fe20007ffe0ffULL,
0x00000100292c7824ULL, 0x020fe200078e0212ULL, 0x0000000328297812ULL, 0x000fe400078ec0ffULL,
0x000000102b00720cULL, 0x000fe20003f26070ULL, 0x0000620011317a24ULL, 0x000fd800078e022cULL,
0x0000054000009947ULL, 0x000fea0003800000ULL, 0x0000000429357824ULL, 0x000fe200078e00ffULL,
0x0000000202297211ULL, 0x002fe200078fe8ffULL, 0x0000000200347824ULL, 0x000fe200078e023dULL,
0x0000002c03287217ULL, 0x000fe20007800000ULL, 0x00000100ff377424ULL, 0x000fe200078e00ffULL,
0x00000002ff2e7819ULL, 0x000fe40000011602ULL, 0x0000000329337812ULL, 0x000fe200078ec0ffULL,
0x00000001282c7824ULL, 0x000fe200078e0a2cULL, 0x000000082e297810ULL, 0x040fe20007ffe0ffULL,
0x000000012e287824ULL, 0x000fe200078e0231ULL, 0xfffffffc35357812ULL, 0x000fc400078ee202ULL,
0x0000002c2e00720cULL, 0x080fe20003f26070ULL, 0x00000001292a7824ULL, 0x040fe200078e0231ULL,
0x0000002c2900720cULL, 0x040fe20003f46070ULL, 0x0000000429307824ULL, 0x000fe200078e00ffULL,
0x0000200034347811ULL, 0x000fe200078e60ffULL, 0x00005e0028287625ULL, 0x080fe200078e0037ULL,
0x0ffffffc332d7812ULL, 0x000fe400078ef802ULL, 0xfffffffc302f7812ULL, 0x000fe200078ee233ULL,
0x00005e002a2a7625ULL, 0x000fe200078e0037ULL, 0x000000102e307810ULL, 0x000fc40007ffe0ffULL,
0x000000182e327810ULL, 0x040fe20007ffe0ffULL, 0x000000102d2d7824ULL, 0x000fe200078e0234ULL,
0x000000202e367810ULL, 0x040fe20007ffe0ffULL, 0x0000001035287825ULL, 0x000fe200078e0028ULL,
0x000000282e417810ULL, 0x040fe40007ffe0ffULL, 0x000000302e427810ULL, 0x040fe20007ffe0ffULL,
0x000000102f2f7824ULL, 0x000fe200078e0234ULL, 0x000000382e437810ULL, 0x000fe20007ffe0ffULL,
0x00000010352a7825ULL, 0x000fe200078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000282d7faeULL, 0x0003e2000c901c46ULL, 0x0000002c3000720cULL, 0x000fc40003f26070ULL,
0x0000002c3600720cULL, 0x080fe20003f66070ULL, 0x000000002a2f7faeULL, 0x0005e2000d101c46ULL,
0x0000002c3200720cULL, 0x080fe20003f46070ULL, 0x0000000430447824ULL, 0x000fe200078e00ffULL,
0x0000002c4100720cULL, 0x0c0fe20003f86070ULL, 0x0000000432467824ULL, 0x000fe200078e00ffULL,
0x0000002c4200720cULL, 0x080fe20003fa6070ULL, 0x0000000441487824ULL, 0x000fe200078e00ffULL,
0x0000002c4300720cULL, 0x000fe20003fc6070ULL, 0x0000000130287824ULL, 0x102fe400078e0231ULL,
0x00000001362c7824ULL, 0x000fe200078e0231ULL, 0xfffffffc48477812ULL, 0x000fe200078ee233ULL,
0x0000000142307824ULL, 0x000fc400078e0231ULL, 0x0000000436367824ULL, 0x000fe400078e00ffULL,
0x0000000442427824ULL, 0x000fe400078e00ffULL, 0x00000004434a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc36457812ULL, 0x000fe200078ee233ULL, 0x00000001322a7824ULL, 0x004fe200078e0231ULL,
0xfffffffc42497812ULL, 0x000fe200078ee233ULL, 0x00000001412e7824ULL, 0x000fe200078e0231ULL,
0xfffffffc44417812ULL, 0x000fe200078ee233ULL, 0x0000000143327824ULL, 0x000fe200078e0231ULL,
0xfffffffc46437812ULL, 0x100fe200078ee233ULL, 0x00005e0028287625ULL, 0x000fe200078e0037ULL,
0xfffffffc4a4b7812ULL, 0x000fc600078ee233ULL, 0x00005e002a2a7625ULL, 0x000fc800078e0037ULL,
0x00005e002c2c7625ULL, 0x000fc800078e0037ULL, 0x00005e002e2e7625ULL, 0x000fc800078e0037ULL,
0x00005e0030307625ULL, 0x000fc800078e0037ULL, 0x00005e0032327625ULL, 0x000fc800078e0037ULL,
0x0000001035287825ULL, 0x000fc800078e0028ULL, 0x00000010352a7825ULL, 0x000fc800078e002aULL,
0x00000010352c7825ULL, 0x000fc800078e002cULL, 0x00000010352e7825ULL, 0x000fc800078e002eULL,
0x0000001035307825ULL, 0x000fc800078e0030ULL, 0x0000001035327825ULL, 0x000fc800078e0032ULL,
0x0000001041357824ULL, 0x100fe400078e0234ULL, 0x0000001043377824ULL, 0x100fe400078e0234ULL,
0x0000001045417824ULL, 0x100fe200078e0234ULL, 0x0000000028357faeULL, 0x0003e2000c901c46ULL,
0x0000001047437824ULL, 0x100fe400078e0234ULL, 0x0000001049457824ULL, 0x100fe200078e0234ULL,
0x000000002a377faeULL, 0x0003e2000d101c46ULL, 0x000000104b477824ULL, 0x000fc600078e0234ULL,
0x000000002c417faeULL, 0x0003e8000d901c46ULL, 0x000000002e437faeULL, 0x0003e8000e101c46ULL,
0x0000000030457faeULL, 0x0003e8000e901c46ULL, 0x0000000032477faeULL, 0x0003e2000f101c46ULL,
0x0000048000007947ULL, 0x000fea0003800000ULL, 0x00000002002a7824ULL, 0x000fe200078e023dULL,
0x00000008022c7811ULL, 0x042fe200078ff0ffULL, 0x0000000429417824ULL, 0x000fe200078e00ffULL,
0x00000010022e7811ULL, 0x040fe200078ff0ffULL, 0x00000100ff377424ULL, 0x000fe200078e00ffULL,
0x0000001802307811ULL, 0x000fe200078ff0ffULL, 0x000000042c447824ULL, 0x000fe200078e00ffULL,
0x0000002002327811ULL, 0x000fe200078ff0ffULL, 0x000000042e467824ULL, 0x000fe200078e00ffULL,
0x0000002802347811ULL, 0x000fe200078ff0ffULL, 0x0000000430487824ULL, 0x000fe200078e00ffULL,
0x0000003002367811ULL, 0x000fe200078ff0ffULL, 0x00000004324a7824ULL, 0x000fe200078e00ffULL,
0x0000003802427811ULL, 0x000fe200078ff0ffULL, 0x00000004344c7824ULL, 0x000fe200078e00ffULL,
0x000020002a4d7811ULL, 0x000fe200078e60ffULL, 0x000000012c2a7824ULL, 0x100fe200078e0231ULL,
0x0000000202297211ULL, 0x000fe200078fe8ffULL, 0x000000012e2c7824ULL, 0x100fe200078e0231ULL,
0x0000003102287211ULL, 0x000fe200078ff0ffULL, 0x00000001302e7824ULL, 0x100fe200078e0231ULL,
0x00000003292b7812ULL, 0x000fe200078ec0ffULL, 0x0000000132307824ULL, 0x000fe200078e0231ULL,
0xfffffffc41417812ULL, 0x000fe200078ee202ULL, 0x00000004364e7824ULL, 0x000fe200078e00ffULL,
0xfffffffc44447812ULL, 0x100fe200078ee22bULL, 0x0000000442507824ULL, 0x000fe200078e00ffULL,
0xfffffffc46467812ULL, 0x000fe200078ee22bULL, 0x0000000134327824ULL, 0x000fe200078e0231ULL,
0xfffffffc48487812ULL, 0x000fe200078ee22bULL, 0x0000000136347824ULL, 0x000fe200078e0231ULL,
0xfffffffc4a4a7812ULL, 0x000fe200078ee22bULL, 0x0000000142367824ULL, 0x000fe200078e0231ULL,
0xfffffffc4c4c7812ULL, 0x100fe200078ee22bULL, 0x00005e0028287625ULL, 0x000fe200078e0037ULL,
0xfffffffc4e4e7812ULL, 0x000fc400078ee22bULL, 0xfffffffc50507812ULL, 0x000fe200078ee22bULL,
0x00005e002c2c7625ULL, 0x000fe200078e0037ULL, 0x0ffffffc2b427812ULL, 0x000fc600078ef802ULL,
0x00005e002a2a7625ULL, 0x000fc800078e0037ULL, 0x00005e002e2e7625ULL, 0x000fc800078e0037ULL,
0x00005e0030307625ULL, 0x000fc800078e0037ULL, 0x00005e0032327625ULL, 0x000fc800078e0037ULL,
0x00005e0034347625ULL, 0x000fc800078e0037ULL, 0x00005e0036367625ULL, 0x000fc800078e0037ULL,
0x0000001041287825ULL, 0x000fc800078e0028ULL, 0x00000010412a7825ULL, 0x000fc800078e002aULL,
0x00000010412c7825ULL, 0x000fc800078e002cULL, 0x00000010412e7825ULL, 0x000fc800078e002eULL,
0x0000001041307825ULL, 0x000fc800078e0030ULL, 0x0000001041327825ULL, 0x000fc800078e0032ULL,
0x0000001041347825ULL, 0x000fc800078e0034ULL, 0x0000001041367825ULL, 0x000fc800078e0036ULL,
0x00000010424f7824ULL, 0x100fe400078e024dULL, 0x0000001044417824ULL, 0x100fe400078e024dULL,
0x0000001046437824ULL, 0x100fe200078e024dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000284f7faeULL, 0x0003e2000b901c46ULL, 0x0000001048457824ULL, 0x100fe400078e024dULL,
0x000000104a477824ULL, 0x100fe200078e024dULL, 0x000000002a417faeULL, 0x0003e2000b901c46ULL,
0x000000104c497824ULL, 0x000fc400078e024dULL, 0x000000104e4b7824ULL, 0x100fe200078e024dULL,
0x000000002c437faeULL, 0x0003e2000b901c46ULL, 0x00000010504d7824ULL, 0x000fc600078e024dULL,
0x000000002e457faeULL, 0x0003e8000b901c46ULL, 0x0000000030477faeULL, 0x0003e8000b901c46ULL,
0x0000000032497faeULL, 0x0003e8000b901c46ULL, 0x00000000344b7faeULL, 0x0003e8000b901c46ULL,
0x00000000364d7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000ffff417224ULL, 0x002fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xfffffff802297812ULL, 0x000fe200078ec0ffULL,
0x00000002002d7824ULL, 0x020fe200078e023fULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000020022f7810ULL, 0x000fc40007ffe0ffULL, 0x0000000729297812ULL, 0x100fe400078ef802ULL,
0x000020002d2d7811ULL, 0x000fe400078e60ffULL, 0x00000001ff287819ULL, 0x000fe20000011629ULL,
0x00000004292b7824ULL, 0x000fe200078e00ffULL, 0xfffffff82f2f7812ULL, 0x000fe200078ec0ffULL,
0x0000000429297824ULL, 0x000fe200078e00ffULL, 0x0000000141477810ULL, 0x000fe20007ffe0ffULL,
0x00000001282a7824ULL, 0x000fe200078e0241ULL, 0x000000072f2f7812ULL, 0x000fc400078ef802ULL,
0x0000000702cb7812ULL, 0x000fe200078ec0ffULL, 0x0000000128287824ULL, 0x000fe200078e0247ULL,
0xfffffffc2b2a7812ULL, 0x000fe200078ee22aULL, 0x000000042f317824ULL, 0x040fe200078e00ffULL,
0x00000001ff2c7819ULL, 0x000fe2000001162fULL, 0x000000042f2f7824ULL, 0x000fe200078e00ffULL,
0xfffffffc29287812ULL, 0x000fe200078ee228ULL, 0x000000102a347824ULL, 0x000fe200078e022dULL,
0x00000008cbce7812ULL, 0x000fe200078ef802ULL, 0x000000012c2e7824ULL, 0x000fe400078e0241ULL,
0x0000001028287824ULL, 0x000fc400078e022dULL, 0x000000003434783bULL, 0x000e620000000200ULL,
0xfffffffc312e7812ULL, 0x000fe200078ee22eULL, 0x000000012c2c7824ULL, 0x000fe400078e0247ULL,
0x000000002828783bULL, 0x000ea20000000200ULL, 0x00000020ced07824ULL, 0x000fe400078e00ffULL,
0x000000102e2e7824ULL, 0x000fe200078e022dULL, 0xfffffffc2f2c7812ULL, 0x000fe200078ee22cULL,
0x00000020cecf7824ULL, 0x000fc600078e00ffULL, 0x000000002e30783bULL, 0x000ee20000000200ULL,
0x000000102c2c7824ULL, 0x000fcc00078e022dULL, 0x000000002c2c783bULL, 0x000f220000000200ULL,
0x0000003400af7306ULL, 0x002fe20000009400ULL, 0x00000018ffa97819ULL, 0x000fe20000011434ULL,
0x0001000034517824ULL, 0x000fe200078e00ffULL, 0x00000018ff9e7819ULL, 0x000fe20000011435ULL,
0x0001000029827824ULL, 0x044fe200078e00ffULL, 0x00000018ff687819ULL, 0x000fe20000011429ULL,
0x0000010029847824ULL, 0x000fe200078e00ffULL, 0x00000018ffb47819ULL, 0x000fe20000011451ULL,
0x0000003400b07306ULL, 0x000e620000005400ULL, 0x0001000037a87824ULL, 0x040fe200078e00ffULL,
0x00000018ff997819ULL, 0x000fe20000011436ULL, 0x0000010036aa7824ULL, 0x000fe200078e00ffULL,
0x00000018ff9d7819ULL, 0x008fe20000011430ULL, 0x000100002a757824ULL, 0x040fe200078e00ffULL,
0x00000018ffa87819ULL, 0x000fe200000114a8ULL, 0x000001002a737824ULL, 0x000fe200078e00ffULL,
0x0000003400637306ULL, 0x0004e2000000d400ULL, 0x00000018ff947819ULL, 0x000fe20000011431ULL,
0x0000010037a77824ULL, 0x000fe200078e00ffULL, 0x00000018ff5e7819ULL, 0x000fe2000001142aULL,
0x00010000287d7824ULL, 0x040fe200078e00ffULL, 0x00000018ff897819ULL, 0x000fe20000011437ULL,
0x0000010028837824ULL, 0x000fe200078e00ffULL, 0x00000018ff4a7819ULL, 0x000fe2000001142bULL,
0x000000b400b57306ULL, 0x000fe20000209400ULL, 0x0000010034347824ULL, 0x004fe200078e00ffULL,
0x000000b0af00720bULL, 0x002fc40003f9d000ULL, 0x00000018ffaa7819ULL, 0x000fe400000114aaULL,
0x00000018ffb77819ULL, 0x000fe20000011434ULL, 0x0001000035347824ULL, 0x000fe200078e00ffULL,
0x000000b400b67306ULL, 0x000e620000205400ULL, 0x00000018ffa77819ULL, 0x000fe400000114a7ULL,
0x00000018ff8e7819ULL, 0x000fe40000011432ULL, 0x00000018ffba7819ULL, 0x000fe20000011434ULL,
0x0001000036347824ULL, 0x000fe200078e00ffULL, 0x0000000163634812ULL, 0x008fe200078efcffULL,
0x0000003500ab7306ULL, 0x000fe20000009400ULL, 0x00000018ff887819ULL, 0x000fc40000011433ULL,
0x00000018ffc07819ULL, 0x000fe40000011434ULL, 0x00000018ff7d7819ULL, 0x000fe4000001147dULL,
0x00000018ff727819ULL, 0x000fe20000011428ULL, 0x000000ba00bb7306ULL, 0x000fe20000209400ULL,
0x000000b6b500720bULL, 0x002fe20003f5d000ULL, 0x000100002bb57824ULL, 0x040fe200078e00ffULL,
0x00000018ff827819ULL, 0x000fe20000011482ULL, 0x000001002bb67824ULL, 0x000fe200078e00ffULL,
0x00000018ff837819ULL, 0x000fc40000011483ULL, 0x00000018ff847819ULL, 0x000fe20000011484ULL,
0x000000ba00bc7306ULL, 0x000e620000205400ULL, 0x00000018ff737819ULL, 0x000fe40000011473ULL,
0x00000018ff757819ULL, 0x000fe40000011475ULL, 0x00000018ff347819ULL, 0x010fe4000001142cULL,
0x00000018ffb67819ULL, 0x000fe200000114b6ULL, 0x0000003500a67306ULL, 0x000ea20000005400ULL,
0x00000018ff517819ULL, 0x000fc4000001142eULL, 0x00000018ff547819ULL, 0x000fca000001142fULL,
0x0000003600a07306ULL, 0x000fe20000009400ULL, 0x000000bcbb00720bULL, 0x002fce0003fbd000ULL,
0x0000003600a17306ULL, 0x000e620000005400ULL, 0x000000a6ab00720bULL, 0x004fe40003f3d000ULL,
0x000000b400a67245ULL, 0x000fc8000020d400ULL, 0x00000001a6a62812ULL, 0x000fe200078efcffULL,
0x000000b700b87306ULL, 0x000fe60000209400ULL, 0x00000063a6a6723eULL, 0x000fca00000010ffULL,
0x000000b700b97306ULL, 0x000ea20000205400ULL, 0x000000a1a000720bULL, 0x002fe40003f5d000ULL,
0x000000ba00a17245ULL, 0x000fe4000020d400ULL, 0x000000a900a07245ULL, 0x000fe4000020d400ULL,
0x00000001a1a15812ULL, 0x000fe200078efcffULL, 0x0000003500627306ULL, 0x0002f0000000d400ULL,
0x0000009e00ae7306ULL, 0x000fe20000209400ULL, 0x0000010035357824ULL, 0x002fe200078e00ffULL,
0x000000b9b800720bULL, 0x004fc80003f7d000ULL, 0x00000018ffbd7819ULL, 0x000fe40000011435ULL,
0x0000009e00c17306ULL, 0x000e620000205400ULL, 0x0000000162621812ULL, 0x008fe400078efcffULL,
0x00000018ff357819ULL, 0x000fe4000001142dULL, 0x00000062a162723eULL, 0x000fc600000010ffULL,
0x000000c000c27306ULL, 0x000ff00000209400ULL, 0x000000c000c37306ULL, 0x000ea20000205400ULL,
0x000000c1ae00720bULL, 0x002fce0003f9d000ULL, 0x000000a900b27306ULL, 0x000ff00000209400ULL,
0x000000a900b37306ULL, 0x0002e20000205400ULL, 0x000000c3c200720bULL, 0x004fce0003fbd000ULL,
0x0000002900667306ULL, 0x000fe20000009400ULL, 0x0001000032a97824ULL, 0x002fce00078e00ffULL,
0x0000002900697306ULL, 0x000fe20000005400ULL, 0x000000b3b200720bULL, 0x008fe20003fdd000ULL,
0x0000010033b27824ULL, 0x000fca00078e00ffULL, 0x00000018ffb27819ULL, 0x000fe200000114b2ULL,
0x0000002900427306ULL, 0x0003ec000000d400ULL, 0x00000001a0a06812ULL, 0x000fe400078efcffULL,
0x0000003000917306ULL, 0x000fe20000009400ULL, 0x0001000030297824ULL, 0x002fce00078e00ffULL,
0x0000003000907306ULL, 0x000ff00000005400ULL, 0x00000030005a7306ULL, 0x0003f0000000d400ULL,
0x0000002800987306ULL, 0x000fe20000009400ULL, 0x0000010030307824ULL, 0x002fca00078e00ffULL,
0x00000018ffc97819ULL, 0x000fe20000011430ULL, 0x0001000031307824ULL, 0x000fe200078e00ffULL,
0x0000002800977306ULL, 0x000e680000005400ULL, 0x00000018ffcc7819ULL, 0x000fc80000011430ULL,
0x000000bd00be7306ULL, 0x000ff00000209400ULL, 0x000000bd00bf7306ULL, 0x000fe20000205400ULL,
0x000000979800720bULL, 0x002fe40003f3d000ULL, 0x0000009e00977245ULL, 0x000fe2000020d400ULL,
0x00000100329e7824ULL, 0x000fe200078e00ffULL, 0x000000c000987245ULL, 0x000fc4000020d400ULL,
0x0000000197974812ULL, 0x000fe200078efcffULL, 0x00000031007f7306ULL, 0x000fe20000009400ULL,
0x0000000198985812ULL, 0x000fe400078efcffULL, 0x00000018ff9e7819ULL, 0x000fca000001149eULL,
0x00000031007c7306ULL, 0x000ff00000005400ULL, 0x0000003100577306ULL, 0x0003f0000000d400ULL,
0x0000002a006a7306ULL, 0x000fe20000009400ULL, 0x0000010031317824ULL, 0x002fce00078e00ffULL,
0x0000002a00677306ULL, 0x000ff00000005400ULL, 0x0000002a00437306ULL, 0x0003f0000000d400ULL,
0x0000009900a27306ULL, 0x000fe20000209400ULL, 0x00000018ff2a7819ULL, 0x002fe20000011429ULL,
0x0000000440297824ULL, 0x000fe200078e0241ULL, 0x0000000241417810ULL, 0x000fc60007ffe0ffULL,
0x0000000229297824ULL, 0x000fe400078e00ffULL, 0x0000009900a57306ULL, 0x0002a60000205400ULL,
0x0000000229cd7810ULL, 0x000fe40007ffe0ffULL, 0x0000002902297211ULL, 0x040fe400078fe0ffULL,
0x000000cd02cd7211ULL, 0x000fe200078fe0ffULL, 0x000000a800b17306ULL, 0x000fe20000209400ULL,
0x0000009900997245ULL, 0x002fe2000020d400ULL, 0x00000001ce297824ULL, 0x000fc400078e0229ULL,
0x00000001ce307824ULL, 0x000fc600078e02cdULL, 0xffffffe0d0297812ULL, 0x000fe200078ee229ULL,
0x000000a800c67306ULL, 0x0002e20000205400ULL, 0x000000a5a200720bULL, 0x004fe20003f9d000ULL,
0x0001000033a57824ULL, 0x000fe200078e00ffULL, 0xffffffe0cf307812ULL, 0x000fe200078ee230ULL,
0x0000001029297824ULL, 0x000fc600078e00ffULL, 0x00000018ffa57819ULL, 0x000fe200000114a5ULL,
0x00000037009f7306ULL, 0x000fe20000009400ULL, 0x000000a800a87245ULL, 0x002fca000020d400ULL,
0x0000000199994812ULL, 0x000fe400078efcffULL, 0x00000037009c7306ULL, 0x000e620000005400ULL,
0x000000c6b100720bULL, 0x008fce0003fbd000ULL, 0x0000002b00647306ULL, 0x000fec0000009400ULL,
0x00000001a8a85812ULL, 0x000fe400078efcffULL, 0x0000002b00657306ULL, 0x000fe20000005400ULL,
0x0000009c9f00720bULL, 0x002fe40003fdd000ULL, 0x000000bd009c7245ULL, 0x000fc4000020d400ULL,
0x00000018ff9f7819ULL, 0x000fe400000114a9ULL, 0x000000909100720bULL, 0x000fe20003fbd000ULL,
0x0000002b00447306ULL, 0x0003e2000000d400ULL, 0x0000008900907245ULL, 0x000fe4000020d400ULL,
0x000000a700a97245ULL, 0x000fca000020d400ULL, 0x00000036005f7306ULL, 0x000ea2000000d400ULL,
0x00000018ff2b7819ULL, 0x002fe40000011431ULL, 0x000000b700317245ULL, 0x000fe4000020d400ULL,
0x000000015a5a5812ULL, 0x000fe400078efcffULL, 0x0000000131313812ULL, 0x000fe200078efcffULL,
0x00000089009b7306ULL, 0x000fe20000209400ULL, 0x000000bfbe00720bULL, 0x000fce0003f7d000ULL,
0x00000089009a7306ULL, 0x000e620000205400ULL, 0x000000015f5f2812ULL, 0x004fc800078efcffULL,
0x0000005f9898723eULL, 0x000fe400000010ffULL, 0x000000019c9c3812ULL, 0x000fe200078efcffULL,
0x000000aa00c47306ULL, 0x000fe60000209400ULL, 0x0000009c9763723eULL, 0x000fca00000010ffULL,
0x000000aa00c57306ULL, 0x0004e20000205400ULL, 0x0000009a9b00720bULL, 0x002fe40003f5d000ULL,
0x0000009d009a7245ULL, 0x000fca000020d400ULL, 0x0000002a00c77306ULL, 0x000fe20000209400ULL,
0x000000aa00aa7245ULL, 0x004fca000020d400ULL, 0x0000000190902812ULL, 0x000fe400078efcffULL,
0x0000002a00c87306ULL, 0x000e620000205400ULL, 0x000000c5c400720bULL, 0x008fce0003f7d000ULL,
0x000000cc00cd7306ULL, 0x000fec0000209400ULL, 0x00000001aaaa3812ULL, 0x000fe400078efcffULL,
0x000000cc00b07306ULL, 0x000ea20000205400ULL, 0x000000c8c700720bULL, 0x002fe40003f9d000ULL,
0x000000aa9999723eULL, 0x000fca00000010ffULL, 0x000000a700ad7306ULL, 0x000ff00000209400ULL,
0x000000a700ac7306ULL, 0x0002e20000205400ULL, 0x000000b0cd00720bULL, 0x004fce0003f5d000ULL,
0x00000037005b7306ULL, 0x000ea2000000d400ULL, 0x00000031a0a7723eULL, 0x002fce00000010ffULL,
0x0000009d00a37306ULL, 0x000fe20000209400ULL, 0x000000acad00720bULL, 0x008fce0003f7d000ULL,
0x0000009d00a47306ULL, 0x000e620000205400ULL, 0x000000015b5b6812ULL, 0x004fc800078efcffULL,
0x0000005ba8a8723eULL, 0x000fe400000010ffULL, 0x00000001a9a93812ULL, 0x000fe200078efcffULL,
0x00000032007a7306ULL, 0x000fe60000009400ULL, 0x000000a990a9723eULL, 0x000fca00000010ffULL,
0x00000032007b7306ULL, 0x000fe20000005400ULL, 0x000000a4a300720bULL, 0x002fce0003fdd000ULL,
0x0000003200507306ULL, 0x000fec000000d400ULL, 0x000000019a9a6812ULL, 0x000fe400078efcffULL,
0x0000009f00af7306ULL, 0x000ff00000209400ULL, 0x0000009f00327306ULL, 0x0003f00000205400ULL,
0x000000c900ca7306ULL, 0x000fe20000209400ULL, 0x0000009f009f7245ULL, 0x002fce000020d400ULL,
0x000000c900cb7306ULL, 0x0002b00000205400ULL, 0x0000003300767306ULL, 0x000fe20000009400ULL,
0x000000c900c97245ULL, 0x002fce000020d400ULL, 0x0000003300777306ULL, 0x000fe20000005400ULL,
0x000000cbca00720bULL, 0x004fce0003f7d000ULL, 0x00000033004b7306ULL, 0x0003ec000000d400ULL,
0x00000001c9c93812ULL, 0x000fe400078efcffULL, 0x0000002b00ab7306ULL, 0x000fe20000209400ULL,
0x0000002a00337245ULL, 0x002fe4000020d400ULL, 0x0000007b7a00720bULL, 0x000fc40003f7d000ULL,
0x0000000133334812ULL, 0x000fe400078efcffULL, 0x0000007c7f00720bULL, 0x000fe20003f9d000ULL,
0x0000002b00ae7306ULL, 0x000e620000205400ULL, 0x000000cc007c7245ULL, 0x000fe4000020d400ULL,
0x0000002b007a7245ULL, 0x000fe4000020d400ULL, 0x000000017c7c2812ULL, 0x000fe400078efcffULL,
0x00000032af00720bULL, 0x000fe20003f5d000ULL, 0x0000009400957306ULL, 0x000fe20000209400ULL,
0x00000094007b7245ULL, 0x000fc4000020d400ULL, 0x0000000150503812ULL, 0x000fe400078efcffULL,
0x0000000157574812ULL, 0x000fe400078efcffULL, 0x00000018ff327819ULL, 0x000fe200000114b5ULL,
0x0000009400967306ULL, 0x000ea20000205400ULL, 0x000000aeab00720bULL, 0x002fe40003fbd000ULL,
0x0000005a335a723eULL, 0x000fe400000010ffULL, 0x000000019f9f2812ULL, 0x000fc400078efcffULL,
0x000000777600720bULL, 0x000fe20003f5d000ULL, 0x0000009e00a27306ULL, 0x000fe20000209400ULL,
0x0000008e00777245ULL, 0x000fe4000020d400ULL, 0x0000003200337245ULL, 0x000fe4000020d400ULL,
0x000000c99a5b723eULL, 0x000fe400000010ffULL, 0x000000017a7a5812ULL, 0x000fe200078efcffULL,
0x0000009e009b7306ULL, 0x0002e20000205400ULL, 0x000000969500720bULL, 0x004fc40003fdd000ULL,
0x000000577c7c723eULL, 0x000fe400000010ffULL, 0x000000014b4b2812ULL, 0x000fc600078efcffULL,
0x0000008e00937306ULL, 0x000fe20000209400ULL, 0x0000009e009e7245ULL, 0x002fca000020d400ULL,
0x000000017b7b6812ULL, 0x000fe400078efcffULL, 0x0000008e00927306ULL, 0x000e620000205400ULL,
0x0000009ba200720bULL, 0x008fce0003f9d000ULL, 0x000000a500917306ULL, 0x000fec0000209400ULL,
0x000000019e9e4812ULL, 0x000fe400078efcffULL, 0x000000a5002a7306ULL, 0x000ea20000205400ULL,
0x000000929300720bULL, 0x002fe40003fbd000ULL, 0x000000696600720bULL, 0x000fe20003f9d000ULL,
0x000100002c697824ULL, 0x000fe200078e00ffULL, 0x000000a500667245ULL, 0x000fc6000020d400ULL,
0x0000007d008a7306ULL, 0x000fec0000209400ULL, 0x0000000177775812ULL, 0x000fe400078efcffULL,
0x0000007d008f7306ULL, 0x0002e20000205400ULL, 0x0000002a9100720bULL, 0x004fe40003fdd000ULL,
0x000000676a00720bULL, 0x000fc40003fbd000ULL, 0x0000007d006a7245ULL, 0x000fe4000020d400ULL,
0x000000b200677245ULL, 0x000fe2000020d400ULL, 0x000000b2007f7306ULL, 0x000fe20000209400ULL,
0x00000018ff7d7819ULL, 0x002fe20000011469ULL, 0x000100002d697824ULL, 0x000fe200078e00ffULL,
0x0000000142424812ULL, 0x000fe400078efcffULL, 0x0000009e7731723eULL, 0x000fe400000010ffULL,
0x0000000166666812ULL, 0x000fe200078efcffULL, 0x000000b200967306ULL, 0x000e620000205400ULL,
0x0000008f8a00720bULL, 0x008fc40003f5d000ULL, 0x0000000143435812ULL, 0x000fe400078efcffULL,
0x0000004b6666723eULL, 0x000fc600000010ffULL, 0x00000088008c7306ULL, 0x000fec0000209400ULL,
0x000000016a6a2812ULL, 0x000fe400078efcffULL, 0x00000088008d7306ULL, 0x0004e20000205400ULL,
0x000000967f00720bULL, 0x002fce0003f7d000ULL, 0x00000072006c7306ULL, 0x000fe20000209400ULL,
0x0000008800887245ULL, 0x004fca000020d400ULL, 0x0000000167673812ULL, 0x000fe400078efcffULL,
0x00000072006d7306ULL, 0x0002a20000205400ULL, 0x0000008d8c00720bULL, 0x008fce0003fdd000ULL,
0x0000002800457306ULL, 0x000ee2000000d400ULL, 0x0000007200727245ULL, 0x002fca000020d400ULL,
0x0000000188886812ULL, 0x000fe400078efcffULL, 0x0000008200807306ULL, 0x000fe20000209400ULL,
0x0000006d6c00720bULL, 0x004fe40003f5d000ULL, 0x000000656400720bULL, 0x000fe20003fdd000ULL,
0x000001002c647824ULL, 0x000fe200078e00ffULL, 0x0000008200657245ULL, 0x000fe4000020d400ULL,
0x000000678867723eULL, 0x000fe200000010ffULL, 0x0000008200857306ULL, 0x0002a20000205400ULL,
0x0000000145451812ULL, 0x008fc400078efcffULL, 0x00000018ff6c7819ULL, 0x000fe40000011464ULL,
0x0000007500647245ULL, 0x000fe4000020d400ULL, 0x0000000172722812ULL, 0x000fe200078efcffULL,
0x00000083008b7306ULL, 0x000fe20000209400ULL, 0x000001002f827824ULL, 0x002fe200078e00ffULL,
0x0000000144446812ULL, 0x000fe400078efcffULL, 0x000000456a6a723eULL, 0x000fe400000010ffULL,
0x00000018ff827819ULL, 0x000fc40000011482ULL, 0x0000008300287306ULL, 0x0002e20000205400ULL,
0x000000858000720bULL, 0x004fe20003f3d000ULL, 0x000100002e807824ULL, 0x040fe400078e00ffULL,
0x000001002e857824ULL, 0x000fc600078e00ffULL, 0x00000018ff807819ULL, 0x000fe20000011480ULL,
0x00000068006e7306ULL, 0x000fe20000209400ULL, 0x0000008300837245ULL, 0x002fe4000020d400ULL,
0x00000018ff857819ULL, 0x000fc60000011485ULL, 0x0000000165651812ULL, 0x000fe400078efcffULL,
0x00000068006b7306ULL, 0x000e620000205400ULL, 0x000000288b00720bULL, 0x008fe40003f7d000ULL,
0x000000002928783bULL, 0x000eaa0000000200ULL, 0x0000005e00707306ULL, 0x000fec0000209400ULL,
0x0000000183833812ULL, 0x000fc400078efcffULL, 0x0000005e006f7306ULL, 0x0007220000205400ULL,
0x0000006b6e00720bULL, 0x002fe40003f5d000ULL, 0x00000083726b723eULL, 0x000fca00000010ffULL,
0x0000008400867306ULL, 0x000fe20000209400ULL, 0x0000005e005e7245ULL, 0x008fce000020d400ULL,
0x0000008400877306ULL, 0x0002e20000205400ULL, 0x0000006f7000720bULL, 0x010fe40003f3d000ULL,
0x00000018ff6f7819ULL, 0x000fe40000011469ULL, 0x0000006800697245ULL, 0x000fc6000020d400ULL,
0x0000007300787306ULL, 0x000fe20000209400ULL, 0x0000000169692812ULL, 0x000fe400078efcffULL,
0x0000008400847245ULL, 0x002fe2000020d400ULL, 0x000000622824723cULL, 0x004f640000041824ULL,
0x000000015e5e1812ULL, 0x000fe400078efcffULL, 0x0000007300797306ULL, 0x0002a20000205400ULL,
0x000000878600720bULL, 0x008fe20003f7d000ULL, 0x000100002f867824ULL, 0x000fc400078e00ffULL,
0x000000a6281c723cULL, 0x000f66000004181cULL, 0x00000018ff867819ULL, 0x000fe20000011486ULL,
0x0000003200897306ULL, 0x000fe20000209400ULL, 0x0000007300737245ULL, 0x002fc6000020d400ULL,
0x000000982820723cULL, 0x000fe40000041820ULL, 0x0000000184843812ULL, 0x000fe400078efcffULL,
0x0000003200767306ULL, 0x000e620000205400ULL, 0x000000797800720bULL, 0x004fc60003f5d000ULL,
0x000000a82818723cULL, 0x040f680000041818ULL, 0x0000002c00717306ULL, 0x000fe80000009400ULL,
0x0000005a2814723cULL, 0x000f640000041814ULL, 0x0000000173732812ULL, 0x000fc400078efcffULL,
0x0000002c00747306ULL, 0x000ea20000005400ULL, 0x000000768900720bULL, 0x002fc60003f3d000ULL,
0x000000662804723cULL, 0x000fe80000041804ULL, 0x0000002c00497306ULL, 0x000e6c000000d400ULL,
0x0000000133331812ULL, 0x000fc400078efcffULL, 0x00000075007e7306ULL, 0x000fe20000209400ULL,
0x000000747100720bULL, 0x004fe40003f9d000ULL, 0x000000443344723eULL, 0x000fca00000010ffULL,
0x0000007500817306ULL, 0x000eac0000205400ULL, 0x0000000149494812ULL, 0x002fe400078efcffULL,
0x0000007d008b7306ULL, 0x000ff00000209400ULL, 0x0000007d002c7306ULL, 0x000e620000205400ULL,
0x000000817e00720bULL, 0x004fc40003f7d000ULL, 0x0000008500817245ULL, 0x000fca000020d400ULL,
0x0000002e005d7306ULL, 0x000fec0000009400ULL, 0x0000000164643812ULL, 0x000fe400078efcffULL,
0x0000002e005c7306ULL, 0x000ea20000005400ULL, 0x0000002c8b00720bULL, 0x002fe20003fbd000ULL,
0x00000010302c7824ULL, 0x000fe200078e00ffULL, 0x000000509f30723eULL, 0x000fc400000010ffULL,
0x000000436464723eULL, 0x000fc600000010ffULL, 0x0000004a004e7306ULL, 0x000fe40000209400ULL,
0x000000302808723cULL, 0x000bec0000041808ULL, 0x0000004a004f7306ULL, 0x000e620000205400ULL,
0x0000005c5d00720bULL, 0x004fe40003f5d000ULL, 0x0000007d005c7245ULL, 0x000fc4000020d400ULL,
0x0000004a00317245ULL, 0x020fe4000020d400ULL, 0x000000015c5c5812ULL, 0x000fe200078efcffULL,
0x000000b6007f7306ULL, 0x000fe20000209400ULL, 0x0000007a7b7d723eULL, 0x000fe400000010ffULL,
0x0000006c005d7245ULL, 0x000fe4000020d400ULL, 0x000000495c5c723eULL, 0x000fc600000010ffULL,
0x000000b6008a7306ULL, 0x0004e20000205400ULL, 0x0000004f4e00720bULL, 0x002fe20003f3d000ULL,
0x0000007c280c723cULL, 0x000b6c000004180cULL, 0x0000002d00617306ULL, 0x000fe20000009400ULL,
0x000000b600b67245ULL, 0x004fe4000020d400ULL, 0x000000426528723eULL, 0x020fc400000010ffULL,
0x000000846929723eULL, 0x000fe400000010ffULL, 0x0000000131311812ULL, 0x000fe200078efcffULL,
0x0000002d00607306ULL, 0x000e620000005400ULL, 0x0000008a7f00720bULL, 0x008fe40003f9d000ULL,
0x000000735e65723eULL, 0x000fca00000010ffULL, 0x0000006c006d7306ULL, 0x000fec0000209400ULL,
0x00000001b6b64812ULL, 0x000fe400078efcffULL, 0x0000006c006e7306ULL, 0x000ea20000205400ULL,
0x000000606100720bULL, 0x002fe40003f7d000ULL, 0x000000b63145723eULL, 0x000fca00000010ffULL,
0x0000003400587306ULL, 0x000ff00000209400ULL, 0x0000003400597306ULL, 0x0002e20000205400ULL,
0x0000006e6d00720bULL, 0x004fce0003fbd000ULL, 0x0000002d00487306ULL, 0x000522000000d400ULL,
0x0000003400347245ULL, 0x002fca000020d400ULL, 0x000000015d5d5812ULL, 0x000fe400078efcffULL,
0x0000002e00477306ULL, 0x000e62000000d400ULL, 0x000001002d2d7824ULL, 0x004fe200078e00ffULL,
0x000000595800720bULL, 0x008fc80003fdd000ULL, 0x00000018ff627819ULL, 0x000fe4000001142dULL,
0x0000002f004c7306ULL, 0x000fe20000009400ULL, 0x0000000148483812ULL, 0x010fcc00078efcffULL,
0x0000000134346812ULL, 0x000fe200078efcffULL, 0x0000002f004d7306ULL, 0x000ea20000005400ULL,
0x0000000147472812ULL, 0x002fe400078efcffULL, 0x0000005d345d723eULL, 0x000fca00000010ffULL,
0x0000002f00467306ULL, 0x0002f0000000d400ULL, 0x0000003500367306ULL, 0x000fe20000209400ULL,
0x000000002c2c783bULL, 0x002e620000000200ULL, 0x0000004d4c00720bULL, 0x004fcc0003fbd000ULL,
0x0000003500377306ULL, 0x00052e0000205400ULL, 0x0000000146465812ULL, 0x008fe200078efcffULL,
0x0000006f00687306ULL, 0x000fe20000209400ULL, 0x0000003500357245ULL, 0x004fce000020d400ULL,
0x0000006f005f7306ULL, 0x0004e20000205400ULL, 0x000000373600720bULL, 0x010fce0003f3d000ULL,
0x0000006200607306ULL, 0x000fe20000209400ULL, 0x0000006f006f7245ULL, 0x004fca000020d400ULL,
0x0000000135351812ULL, 0x000fe400078efcffULL, 0x0000006200617306ULL, 0x0005220000205400ULL,
0x0000005f6800720bULL, 0x008fe20003f9d000ULL, 0x000000282c24723cULL, 0x042b6c0000041824ULL,
0x0000008000637306ULL, 0x000fe20000209400ULL, 0x0000006200627245ULL, 0x004fe2000020d400ULL,
0x0000006a2c1c723cULL, 0x000b64000004181cULL, 0x0000005100287245ULL, 0x020fc4000020d400ULL,
0x0000008600297245ULL, 0x000fe4000020d400ULL, 0x000000016f6f4812ULL, 0x000fe200078efcffULL,
0x00000080006e7306ULL, 0x0002a20000205400ULL, 0x000000616000720bULL, 0x010fe20003fdd000ULL,
0x000000442c18723cULL, 0x000b620000041818ULL, 0x000000486f48723eULL, 0x000fca00000010ffULL,
0x0000008500327306ULL, 0x000fe20000209400ULL, 0x0000008000807245ULL, 0x002fe2000020d400ULL,
0x000000642c20723cULL, 0x040b680000041820ULL, 0x0000000162626812ULL, 0x000fe400078efcffULL,
0x00000085004b7306ULL, 0x000e620000205400ULL, 0x0000006e6300720bULL, 0x004fe20003f7d000ULL,
0x0000005c2c14723cULL, 0x000b620000041814ULL, 0x000000623549723eULL, 0x000fca00000010ffULL,
0x0000005100527306ULL, 0x000fe40000209400ULL, 0x000000482c0c723cULL, 0x000b68000004180cULL,
0x0000000180803812ULL, 0x000fe400078efcffULL, 0x0000005100537306ULL, 0x000ea20000205400ULL,
0x0000004b3200720bULL, 0x002fe40003f3d000ULL, 0x000000478080723eULL, 0x000fc400000010ffULL,
0x0000008200477245ULL, 0x000fc6000020d400ULL, 0x0000005400557306ULL, 0x000fec0000209400ULL,
0x0000000181811812ULL, 0x000fe400078efcffULL, 0x0000005400567306ULL, 0x0002e20000205400ULL,
0x000000535200720bULL, 0x004fe40003f9d000ULL, 0x000000044100780cULL, 0x000fca0003f25270ULL,
0x0000008600307306ULL, 0x000fe20000209400ULL, 0x0000005400547245ULL, 0x002fca000020d400ULL,
0x0000000128284812ULL, 0x000fe400078efcffULL, 0x00000086002b7306ULL, 0x000e620000205400ULL,
0x000000565500720bULL, 0x008fe40003fdd000ULL, 0x000000812881723eULL, 0x000fca00000010ffULL,
0x00000082002a7306ULL, 0x000fe40000209400ULL, 0x000000802c08723cULL, 0x000b680000041808ULL,
0x0000000154546812ULL, 0x000fe400078efcffULL, 0x0000008200317306ULL, 0x000ea20000205400ULL,
0x0000002b3000720bULL, 0x002fda0003f7d000ULL, 0x0000000129293812ULL, 0x000fe400078efcffULL,
0x000000312a00720bULL, 0x004fe40003f5d000ULL, 0x000000462946723eULL, 0x000fd600000010ffULL,
0x0000000147472812ULL, 0x000fc800078efcffULL, 0x000000475447723eULL, 0x000fce00000010ffULL,
0x000000462c04723cULL, 0x000b620000041804ULL, 0x0000001000009944ULL, 0x000fe20003c00000ULL,
0xffffe0c000007947ULL, 0x000fcc000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff3f7224ULL, 0x000fe200078e003dULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffd5b000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x000000131a2c7220ULL, 0x0a0fe20000410000ULL, 0x000000131e287220ULL, 0x080fe20000410000ULL,
0x000000131b2d7220ULL, 0x080fe20000410000ULL, 0x00000013141a7220ULL, 0x080fe20000410000ULL,
0x000000131c1c7220ULL, 0x080fe20000410000ULL, 0x000000131d1d7220ULL, 0x080fe20000410000ULL,
0x000000131f297220ULL, 0x080fe20000410000ULL, 0x00000013151b7220ULL, 0x080fe20000410000ULL,
0x000000130c1e7220ULL, 0x080fe20000410000ULL, 0x0000001324247220ULL, 0x080fe20000410000ULL,
0x0000001325257220ULL, 0x080fe20000410000ULL, 0x0000001320207220ULL, 0x080fe20000410000ULL,
0x0000001321217220ULL, 0x080fe20000410000ULL, 0x0000001318187220ULL, 0x080fe20000410000ULL,
0x0000001319197220ULL, 0x080fe20000410000ULL, 0x000000130d1f7220ULL, 0x080fe20000410000ULL,
0x0000001308087220ULL, 0x080fe20000410000ULL, 0x0000001309097220ULL, 0x080fe20000410000ULL,
0x0000001304047220ULL, 0x080fe20000410000ULL, 0x00000013162e7220ULL, 0x080fe20000410000ULL,
0x00000013172f7220ULL, 0x080fe20000410000ULL, 0x000000130a327220ULL, 0x080fe20000410000ULL,
0x000000130b337220ULL, 0x080fe20000410000ULL, 0x000000ffff167224ULL, 0x000fe200078e001aULL,
0x000000130e307220ULL, 0x080fe20000410000ULL, 0x000000130f317220ULL, 0x080fe20000410000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e001cULL, 0x0000001326267220ULL, 0x080fe20000410000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e001dULL, 0x0000001327277220ULL, 0x080fe20000410000ULL,
0x000000ffff177224ULL, 0x000fe200078e001bULL, 0x00000013222a7220ULL, 0x080fe20000410000ULL,
0x000000ffff1a7224ULL, 0x000fe200078e001eULL, 0x00000013232b7220ULL, 0x080fe20000410000ULL,
0x0000001305057220ULL, 0x080fe20000410000ULL, 0x0000001306067220ULL, 0x080fe20000410000ULL,
0x0000001307077220ULL, 0x000fe20000410000ULL, 0x000000ffff0c7224ULL, 0x000fc400078e0024ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0025ULL, 0x000000ffff0e7224ULL, 0x000fe400078e0020ULL,
0x000000ffff0f7224ULL, 0x000fe400078e0021ULL, 0x000000ffff147224ULL, 0x000fe400078e0018ULL,
0x000000ffff157224ULL, 0x000fe400078e0019ULL, 0x000000ffff1b7224ULL, 0x000fc400078e001fULL,
0x000000ffff1c7224ULL, 0x000fe400078e0008ULL, 0x000000ffff1d7224ULL, 0x000fe400078e0009ULL,
0x000000ffff1e7224ULL, 0x000fe200078e0004ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000038087f8cULL, 0x0002a2000c80043fULL, 0x000000ffff207224ULL, 0x000fe400078e0028ULL,
0x000000ffff217224ULL, 0x000fe400078e0029ULL, 0x000000ffff227224ULL, 0x000fc400078e0026ULL,
0x000000ffff237224ULL, 0x000fe400078e0027ULL, 0x000000ffff247224ULL, 0x000fe400078e002aULL,
0x000000ffff257224ULL, 0x000fe400078e002bULL, 0x000000ffff267224ULL, 0x000fe400078e002cULL,
0x000000ffff277224ULL, 0x000fe400078e002dULL, 0x000000ffff287224ULL, 0x000fc400078e002eULL,
0x000000ffff297224ULL, 0x000fe400078e002fULL, 0x000000ffff1f7224ULL, 0x000fe400078e0005ULL,
0x000000ffff2a7224ULL, 0x000fe400078e0030ULL, 0x000000ffff2b7224ULL, 0x000fe400078e0031ULL,
0x000000ffff2c7224ULL, 0x000fe400078e0032ULL, 0x000000ffff2d7224ULL, 0x000fc400078e0033ULL,
0x000000ffff2e7224ULL, 0x000fe400078e0006ULL, 0x000000ffff2f7224ULL, 0x000fc400078e0007ULL,
0x0000000000047805ULL, 0x006fca0000015200ULL, 0x0000040038077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff187224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x0000000604197210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09001900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011407ULL, 0x0000001906067211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000206067819ULL, 0x000fc80000001207ULL,
0x000000060000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000118187810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040038077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000402197824ULL, 0x000fe200078e00ffULL,
0x000000393b00720cULL, 0x000fc80003f05270ULL, 0xfffffff019057812ULL, 0x000fca00078ec0ffULL,
0x0000008000187824ULL, 0x000fca00078e0205ULL, 0x0104000018047984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x0000000202087824ULL, 0x000fe400078e00ffULL,
0x00000001033c7824ULL, 0x000fc600078e0a3cULL, 0x0000000608097812ULL, 0x000fc800078ec0ffULL,
0x0000000109317812ULL, 0x040fe400078efcffULL, 0x0000000809337812ULL, 0x000fe400078efcffULL,
0x0000003c3100720cULL, 0x080fe40003f26070ULL, 0x0000001009317812ULL, 0x000fe400078efcffULL,
0x0000003c3300720cULL, 0x080fe40003f06070ULL, 0x0000003c3100720cULL, 0x000fc40003fc6070ULL,
0x0000001109337812ULL, 0x040fe400078efcffULL, 0x0000001809317812ULL, 0x040fe400078efcffULL,
0x0000003c0900720cULL, 0x080fe40003f46070ULL, 0x0000003c3300720cULL, 0x080fe40003fa6070ULL,
0x0000003c3100720cULL, 0x000fe40003f66070ULL, 0x0000000909357812ULL, 0x000fc400078efcffULL,
0x0000001909337812ULL, 0x040fe400078efcffULL, 0x0000002009317812ULL, 0x000fe400078efcffULL,
0xff80000020207808ULL, 0x000fe40005000000ULL, 0xff8000000b0b7808ULL, 0x000fe40005000000ULL,
0xff80000021217808ULL, 0x000fe40004800000ULL, 0xff8000000a0a7808ULL, 0x000fc40004800000ULL,
0x0000003c3500720cULL, 0x080fe40003f86070ULL, 0x0000003c3300720cULL, 0x080fe40003f46070ULL,
0x0000003c3100720cULL, 0x000fe40003f26070ULL, 0x0000002109337812ULL, 0x040fe400078efcffULL,
0x0000002809317812ULL, 0x000fe400078efcffULL, 0xff80000022227808ULL, 0x000fc40004000000ULL,
0xff8000000c0c7808ULL, 0x000fe40004000000ULL, 0xff80000023237808ULL, 0x000fe40006000000ULL,
0xff8000000d0d7808ULL, 0x000fe40006000000ULL, 0x0000003c3300720cULL, 0x080fe40003f06070ULL,
0x0000003c3100720cULL, 0x000fe40003f86070ULL, 0x0000002909337812ULL, 0x000fc400078efcffULL,
0x0000003009317812ULL, 0x000fe400078efcffULL, 0xff80000024247808ULL, 0x000fe40007000000ULL,
0xff8000000e0e7808ULL, 0x000fe40007000000ULL, 0xff80000025257808ULL, 0x000fe40006800000ULL,
0xff8000000f0f7808ULL, 0x000fe40006800000ULL, 0x0000003c3300720cULL, 0x000fc40003fc6070ULL,
0x0000003c3100720cULL, 0x000fe40003fa6070ULL, 0x0000003109337812ULL, 0x040fe400078efcffULL,
0x0000003809317812ULL, 0x040fe400078efcffULL, 0x0000003909097812ULL, 0x000fe400078efcffULL,
0xff80000026267808ULL, 0x000fe40005800000ULL, 0xff80000014147808ULL, 0x000fc40005800000ULL,
0xff80000027277808ULL, 0x000fe40005000000ULL, 0xff80000015157808ULL, 0x000fe40005000000ULL,
0xff80000028287808ULL, 0x000fe40004800000ULL, 0xff80000016167808ULL, 0x000fe40004800000ULL,
0x0000003c3300720cULL, 0x080fe40003f66070ULL, 0x0000003c3100720cULL, 0x000fc40003f46070ULL,
0x0000003c0900720cULL, 0x000fe40003f26070ULL, 0xff80000029297808ULL, 0x000fe40004000000ULL,
0xff80000017177808ULL, 0x000fe40004000000ULL, 0xff8000002a2a7808ULL, 0x000fe40006000000ULL,
0xff8000001a1a7808ULL, 0x000fe40006000000ULL, 0xff8000002b2b7808ULL, 0x000fc40007000000ULL,
0xff8000001b1b7808ULL, 0x000fe40007000000ULL, 0xff8000002c2c7808ULL, 0x000fe40006800000ULL,
0xff8000001c1c7808ULL, 0x000fe40006800000ULL, 0xff8000002d2d7808ULL, 0x000fe40005800000ULL,
0xff8000001d1d7808ULL, 0x000fe40005800000ULL, 0xff8000002e2e7808ULL, 0x000fc40005000000ULL,
0xff8000001e1e7808ULL, 0x000fe40005000000ULL, 0xff8000002f2f7808ULL, 0x000fe40004800000ULL,
0xff8000001f1f7808ULL, 0x000fc40004800000ULL, 0x0000000b0400720bULL, 0x004fe20003f1e000ULL,
0x0000001fff367424ULL, 0x000fe200078e00ffULL, 0x000000200500720bULL, 0x000fe20003f3e000ULL,
0xffffffffff377424ULL, 0x000fe200078e00ffULL, 0x000000040b097208ULL, 0x000fe40004000000ULL,
0x0000000520047208ULL, 0x000fc40004800000ULL, 0x0000000a0900720bULL, 0x000fe40003f1e000ULL,
0x000000210400720bULL, 0x000fe40003f3e000ULL, 0x000000090a097208ULL, 0x000fe40004000000ULL,
0x0000000421057208ULL, 0x000fe40004800000ULL, 0x0000000c0900720bULL, 0x000fe40003f1e000ULL,
0x000000220500720bULL, 0x000fc40003f3e000ULL, 0x000000090c047208ULL, 0x000fe40004000000ULL,
0x0000000522087208ULL, 0x000fe40004800000ULL, 0x0000000d0400720bULL, 0x000fe40003f1e000ULL,
0x000000230800720bULL, 0x000fe40003f3e000ULL, 0x000000040d057208ULL, 0x000fe40004000000ULL,
0x0000000823097208ULL, 0x000fc40004800000ULL, 0x0000000e0500720bULL, 0x000fe40003f1e000ULL,
0x000000240900720bULL, 0x000fe40003f3e000ULL, 0x000000050e047208ULL, 0x000fe40004000000ULL,
0x0000000924087208ULL, 0x000fe40004800000ULL, 0x0000000f0400720bULL, 0x000fe40003f1e000ULL,
0x000000250800720bULL, 0x000fc40003f3e000ULL, 0x000000040f057208ULL, 0x000fe40004000000ULL,
0x0000000825097208ULL, 0x000fe40004800000ULL, 0x000000140500720bULL, 0x000fe40003f1e000ULL,
0x000000260900720bULL, 0x000fe40003f3e000ULL, 0x0000000514047208ULL, 0x000fe40004000000ULL,
0x0000000926087208ULL, 0x000fc40004800000ULL, 0x000000150400720bULL, 0x000fe40003f1e000ULL,
0x000000270800720bULL, 0x000fe40003f3e000ULL, 0x0000000415057208ULL, 0x000fe40004000000ULL,
0x0000000827097208ULL, 0x000fe40004800000ULL, 0x000000160500720bULL, 0x000fe40003f1e000ULL,
0x000000280900720bULL, 0x000fc40003f3e000ULL, 0x0000000516047208ULL, 0x000fe40004000000ULL,
0x0000000928087208ULL, 0x000fe40004800000ULL, 0x000000170400720bULL, 0x000fe40003f1e000ULL,
0x000000290800720bULL, 0x000fe40003f3e000ULL, 0x0000000417057208ULL, 0x000fe40004000000ULL,
0x0000000829097208ULL, 0x000fc40004800000ULL, 0x0000001a0500720bULL, 0x000fe40003f1e000ULL,
0x0000002a0900720bULL, 0x000fe40003f3e000ULL, 0x000000051a047208ULL, 0x000fe40004000000ULL,
0x000000092a087208ULL, 0x000fe40004800000ULL, 0x0000001b0400720bULL, 0x000fe40003f1e000ULL,
0x0000002b0800720bULL, 0x000fc40003f3e000ULL, 0x000000041b057208ULL, 0x000fe40004000000ULL,
0x000000082b097208ULL, 0x000fe40004800000ULL, 0x0000001c0500720bULL, 0x000fe40003f1e000ULL,
0x0000002c0900720bULL, 0x000fe40003f3e000ULL, 0x000000051c047208ULL, 0x000fe40004000000ULL,
0x000000092c087208ULL, 0x000fc40004800000ULL, 0x0000001d0400720bULL, 0x000fe40003f1e000ULL,
0x0000002d0800720bULL, 0x000fe40003f3e000ULL, 0x000000041d057208ULL, 0x000fe40004000000ULL,
0x000000082d097208ULL, 0x000fe40004800000ULL, 0x0000001e0500720bULL, 0x000fe40003f1e000ULL,
0x0000002e0900720bULL, 0x000fc40003f3e000ULL, 0x000000051e047208ULL, 0x000fe40004000000ULL,
0x000000092e087208ULL, 0x000fe40004800000ULL, 0x0000001f0400720bULL, 0x000fe40003f1e000ULL,
0x0000002f0800720bULL, 0x000fe40003f3e000ULL, 0x000000041f327208ULL, 0x000fe40004000000ULL,
0x000000082f347208ULL, 0x000fe20004800000ULL, 0x000018127f007947ULL, 0x000fec000b800000ULL,
0x0c401f0032047f89ULL, 0x0004e400000e0000ULL, 0x000000043200720bULL, 0x008fc80003f1e000ULL,
0x0000003204357208ULL, 0x000fe20004000000ULL, 0x000018227f007947ULL, 0x000fea000b800000ULL,
0x0c401f0034047f89ULL, 0x000ee800000e0000ULL, 0x0c401f0006057f89ULL, 0x000f2800000e0000ULL,
0x0c401f0007307f89ULL, 0x000e6200000e0000ULL, 0x000000043400720bULL, 0x008fc40003f1e000ULL,
0x000000050600720bULL, 0x010fe40003f3e000ULL, 0x0000003404087208ULL, 0x000fe40004000000ULL,
0x0000000605097208ULL, 0x000fe20004800000ULL, 0x0c201f0035047f89ULL, 0x000ee200000e0000ULL,
0x000000300700720bULL, 0x002fc60003f1e000ULL, 0x0c201f0008057f89ULL, 0x000e6200000e0000ULL,
0x0000000730307208ULL, 0x000fc60004000000ULL, 0x0c201f0009327f89ULL, 0x004ea800000e0000ULL,
0x0c201f0030317f89ULL, 0x0002a200000e0000ULL, 0x000000043500720bULL, 0x008fe40003f1e000ULL,
0x000000050800720bULL, 0x002fe40003f3e000ULL, 0x0000003504047208ULL, 0x000fe40004000000ULL,
0x000000320900720bULL, 0x004fc40003f5e000ULL, 0x0000000805057208ULL, 0x000fe40004800000ULL,
0x0000000932067208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL,
0x3fb8aa3b05357820ULL, 0x000fe20000410000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0x0000000c19197812ULL, 0x000fe200078ec0ffULL, 0x3fb8aa3b0b0b7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0c0c7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0d0d7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b1c1c7823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b20207823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b21217823ULL, 0x000fe20000010835ULL, 0x3fb8aa3b0a0a7823ULL, 0x000fe20000010807ULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010835ULL, 0x3fb8aa3b23237823ULL, 0x000fe20000010835ULL,
0x0000000b00087308ULL, 0x000fe20000000800ULL, 0x00000004ff367e24ULL, 0x002fe2000f8e00ffULL,
0x3fb8aa3b0e0e7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0f0f7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b14147823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b15157823ULL, 0x000fe20000010807ULL,
0x3f8000003636783eULL, 0x000fe200000010ffULL, 0x3fb8aa3b24247823ULL, 0x100fe20000010835ULL,
0x0000000a00097308ULL, 0x000e620000000800ULL, 0x3fb8aa3b25257823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010835ULL, 0x000000ffff377224ULL, 0x100fe200078e0036ULL,
0x3fb8aa3b27277823ULL, 0x000fe20000010835ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3fb8aa3b16167823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b17177823ULL, 0x100fe20000010807ULL,
0x0000001c00327308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b1e1e7823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010835ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010835ULL,
0x0000000c000c7308ULL, 0x000fe20000000800ULL, 0x000000080908723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b2b2b7823ULL, 0x000fe20000010835ULL, 0x3fb8aa3b1f077823ULL, 0x000fe20000010807ULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe20000010835ULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe20000010835ULL, 0x3fb8aa3b2f2f7823ULL, 0x000fe20000010835ULL,
0x0000000d000d7308ULL, 0x000e620000000800ULL, 0x000000ffff3e7224ULL, 0x100fe200078e0036ULL,
0x0000000302ff7812ULL, 0x000fe2000780c0ffULL, 0x000000ffff3f7224ULL, 0x000fe200078e0036ULL,
0x000000313000720bULL, 0x004fc80003f3e000ULL, 0x0000002000207308ULL, 0x000ff00000000800ULL,
0x0000002100217308ULL, 0x000ea20000000800ULL, 0x0000000c0d0a723eULL, 0x002fce00000010ffULL,
0x00000022000b7308ULL, 0x000ff00000000800ULL, 0x00000023001c7308ULL, 0x000e620000000800ULL,
0x000000202109723eULL, 0x004fce00000010ffULL, 0x0000000e000e7308ULL, 0x000fe20000000800ULL,
0x0000000b1c0b723eULL, 0x002fce00000010ffULL, 0x0000000f000f7308ULL, 0x000e620000000800ULL,
0x000000360820723cULL, 0x000f6e00000418ffULL, 0x0000001400147308ULL, 0x000ff00000000800ULL,
0x0000001500157308ULL, 0x000ea20000000800ULL, 0x0000000e0f0c723eULL, 0x002fce00000010ffULL,
0x0000002400247308ULL, 0x000ff00000000800ULL, 0x0000002500257308ULL, 0x000e620000000800ULL,
0x00000014150e723eULL, 0x004fce00000010ffULL, 0x0000002600267308ULL, 0x000ff00000000800ULL,
0x0000002700277308ULL, 0x000ea20000000800ULL, 0x00000024250d723eULL, 0x002fce00000010ffULL,
0x0000001d00337308ULL, 0x000fe20000000800ULL, 0x00000026270f723eULL, 0x004fce00000010ffULL,
0x0000001e00347308ULL, 0x0003e20000000800ULL, 0x00000002ff267819ULL, 0x000fc80000011602ULL,
0x0000000126147810ULL, 0x040fe20007ffe0ffULL, 0x0000000826157824ULL, 0x040fe400078e00ffULL,
0x0000001600167308ULL, 0x000fe20000000800ULL, 0x000000360c1c723cULL, 0x022b620000041820ULL,
0x0000000826257824ULL, 0x040fe200078e00ffULL, 0xfffffff815247812ULL, 0x000fe200078ee214ULL,
0x0000000826357824ULL, 0x000fc800078e00ffULL, 0x0000001700177308ULL, 0x000e620000000800ULL,
0x0000000826227824ULL, 0x060fe200078e00ffULL, 0x0000000326207810ULL, 0x040fe20007ffe0ffULL,
0x0000000826237824ULL, 0x040fe200078e00ffULL, 0x0000000426217810ULL, 0x000fe40007ffe0ffULL,
0xfffffff825257812ULL, 0x000fe400078ee220ULL, 0x0000001a001a7308ULL, 0x000fe20000000800ULL,
0xfffffff822277812ULL, 0x000fe400078ee221ULL, 0x0000000526207810ULL, 0x000fc40007ffe0ffULL,
0x0000000626217810ULL, 0x040fe40007ffe0ffULL, 0xffffffff26227810ULL, 0x000fe20007ffe0ffULL,
0x0000001b001b7308ULL, 0x000ea20000000800ULL, 0x000000161714723eULL, 0x002fe400000010ffULL,
0xfffffff835357812ULL, 0x000fca00078ee222ULL, 0x0000002800287308ULL, 0x000ff00000000800ULL,
0x0000002900297308ULL, 0x000e620000000800ULL, 0x0000001a1b16723eULL, 0x004fe200000010ffULL,
0x00000008261b7824ULL, 0x040fe200078e00ffULL, 0x00000002261a7810ULL, 0x000fc80007ffe0ffULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee21aULL, 0x0000002a002a7308ULL, 0x000fe20000000800ULL,
0xfffffff8231a7812ULL, 0x000fce00078ee226ULL, 0x0000002b002b7308ULL, 0x000ea20000000800ULL,
0x000000282915723eULL, 0x002fe200000010ffULL, 0x0000000826297824ULL, 0x040fe400078e00ffULL,
0x0000000826287824ULL, 0x000fc600078e00ffULL, 0xfffffff829297812ULL, 0x000fe200078ee220ULL,
0x0000000700077308ULL, 0x000e620000000800ULL, 0x000000323320723eULL, 0x000fe400000010ffULL,
0x0000a00000327811ULL, 0x000fe400078e58ffULL, 0x0000002a2b17723eULL, 0x004fc600000010ffULL,
0x0000002c002c7308ULL, 0x000fe20000000800ULL, 0xfffffff8282b7812ULL, 0x000fe200078ee221ULL,
0x000000101a1a7824ULL, 0x100fe400078e0232ULL, 0x0000001024247824ULL, 0x100fe200078e0232ULL,
0x00000036141c723cULL, 0x000b62000004181cULL, 0x000000340722723eULL, 0x002fe400000010ffULL,
0x0000002d002d7308ULL, 0x000e620000000800ULL, 0x0000001025287824ULL, 0x100fe400078e0232ULL,
0x00000010272a7824ULL, 0x000fe200078e0232ULL, 0x0000000826377810ULL, 0x020fe20007ffe0ffULL,
0x000000011a077824ULL, 0x000fc600078e0219ULL, 0x0000002e002e7308ULL, 0x000fe20000000800ULL,
0x00000010291a7824ULL, 0x000fe400078e0232ULL, 0x0000000837267824ULL, 0x000fe200078e00ffULL,
0x0000000807007388ULL, 0x0005e20000000800ULL, 0x0000000119247824ULL, 0x040fe400078e0224ULL,
0x0000000119287824ULL, 0x000fe200078e0228ULL, 0x0000002f002f7308ULL, 0x000ee20000000800ULL,
0x0000002c2d21723eULL, 0x002fe200000010ffULL, 0x000000102b2c7824ULL, 0x100fe200078e0232ULL,
0xfffffff826377812ULL, 0x000fe200078ee237ULL, 0x000000101b267824ULL, 0x000fe200078e0232ULL,
0x0000000a24007388ULL, 0x0003e20000000800ULL, 0x00000001192a7824ULL, 0x000fe200078e022aULL,
0x0000003031077208ULL, 0x004fe20004800000ULL, 0x0000000119267824ULL, 0x000fc400078e0226ULL,
0x00000001191a7824ULL, 0x040fe400078e021aULL, 0x00000001192c7824ULL, 0x000fe200078e022cULL,
0x0000000c26007388ULL, 0x0003e20000000800ULL, 0x0000002e2f23723eULL, 0x008fe200000010ffULL,
0x00000010352e7824ULL, 0x100fe400078e0232ULL, 0x0000000e28007388ULL, 0x0003e20000000800ULL,
0x0000001037327824ULL, 0x000fe400078e0232ULL, 0x00000001192e7824ULL, 0x040fe200078e022eULL,
0x000000142a007388ULL, 0x0003e20000000800ULL, 0x0000003e201c723cULL, 0x000f62000004181cULL,
0x0000000119327824ULL, 0x000fc400078e0232ULL, 0x000000161a007388ULL, 0x0003e80000000800ULL,
0x000000202c007388ULL, 0x0003e80000000800ULL, 0x000000222e007388ULL, 0x0003e80000000800ULL,
0x0000000932007388ULL, 0x0003e80000000800ULL, 0x0004000b24007388ULL, 0x0003e80000000800ULL,
0x0004000d26007388ULL, 0x0003e20000000800ULL, 0x000000ffff1d7224ULL, 0x020fc600078e001eULL,
0x0004000f28007388ULL, 0x0003e80000000800ULL, 0x000400152a007388ULL, 0x0003e80000000800ULL,
0x000400171a007388ULL, 0x0003e80000000800ULL, 0x000400212c007388ULL, 0x0003e80000000800ULL,
0x000400232e007388ULL, 0x0003e80000000800ULL, 0x0100000418008388ULL, 0x0003e80000000c00ULL,
0x0102001c18008388ULL, 0x0003e20000000a00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000003aff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000008003aff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000010003aff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000013b3b7810ULL, 0x000fe20007ffe0ffULL, 0x000018003aff7f8cULL, 0x0003e6000c80043fULL,
0x000000103b00720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffb7b000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff457807ULL, 0x008fe40004000000ULL, 0x0001eed000447802ULL, 0x000fc40000000f00ULL,
0x00000f7000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff197224ULL, 0x000fe200078e0048ULL,
0xfffe2da000007947ULL, 0x000fea000383ffffULL, 0x00000001ff457807ULL, 0x000fe40005000000ULL,
0x0001ef2000447802ULL, 0x000fc40000000f00ULL, 0x00000f2000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff207224ULL, 0x000fe200078e0048ULL, 0xfffe2e0000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5b7224ULL, 0x000fe200078e0021ULL, 0x0001ef8000447802ULL, 0x000fe20000000f00ULL,
0x000000ffff5a7224ULL, 0x008fc400078e0024ULL, 0x00000e8000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff217224ULL, 0x004fe200078e005aULL, 0xfffe2e9000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5a7224ULL, 0x000fe200078e0024ULL, 0x0001efe000447802ULL, 0x000fe20000000f00ULL,
0x000000ffff5b7224ULL, 0x002fc400078e0021ULL, 0x00000e2000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff217224ULL, 0x004fe200078e005aULL, 0xfffe2fa000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5a7224ULL, 0x000fe200078e001fULL, 0x0001f04000447802ULL, 0x000fe20000000f00ULL,
0x000000ffff5b7224ULL, 0x000fc400078e001eULL, 0x00000dc000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff1d7224ULL, 0x004fe200078e005aULL, 0xfffe339000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5b7224ULL, 0x002fe200078e001cULL, 0x0001f0a000447802ULL, 0x000fe20000000f00ULL,
0x000000ffff5a7224ULL, 0x000fc400078e001fULL, 0x00000d6000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff1c7224ULL, 0x004fe200078e005aULL, 0xfffe336000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5a7224ULL, 0x000fe200078e0025ULL, 0x0001f10000447802ULL, 0x000fe20000000f00ULL,
0x000000ffff5b7224ULL, 0x000fc400078e0026ULL, 0x00000d0000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff1d7224ULL, 0x004fe200078e005aULL, 0xfffe5f0000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5a7224ULL, 0x000fe200078e0025ULL, 0x0001f15000447802ULL, 0x000fc40000000f00ULL,
0x00000cb000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff1c7224ULL, 0x004fe200078e005aULL,
0xfffe5ee000007947ULL, 0x000fea000383ffffULL, 0x00000001ff457807ULL, 0x004fe40004000000ULL,
0x0001f1a000447802ULL, 0x000fc40000000f00ULL, 0x00000ca000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff477224ULL, 0x000fe200078e0048ULL, 0xfffe8aa000007947ULL, 0x000fea000383ffffULL,
0x00000001ff457807ULL, 0x000fe40005000000ULL, 0x0001f1f000447802ULL, 0x000fc40000000f00ULL,
0x00000c5000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff407224ULL, 0x000fe200078e0048ULL,
0xfffe8ae000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5a7224ULL, 0x000fe200078e0048ULL,
0x0001f24000447802ULL, 0x000fc40000000f00ULL, 0x00000bc000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff447224ULL, 0x004fe200078e005aULL, 0xfffe8ba000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5a7224ULL, 0x000fe200078e0048ULL, 0x0001f29000447802ULL, 0x000fc40000000f00ULL,
0x00000b7000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff447224ULL, 0x004fe200078e005aULL,
0xfffe8cb000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5a7224ULL, 0x000fe200078e003bULL,
0x0001f2f000447802ULL, 0x000fe20000000f00ULL, 0x000000ffff5b7224ULL, 0x000fc400078e0046ULL,
0x00000b1000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff1d7224ULL, 0x004fe200078e005aULL,
0xfffe90c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5a7224ULL, 0x000fe200078e003bULL,
0x0001f34000447802ULL, 0x000fc40000000f00ULL, 0x00000ac000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff1c7224ULL, 0x004fe200078e005aULL, 0xfffe90a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5a7224ULL, 0x000fe200078e0034ULL, 0x0001f3a000447802ULL, 0x000fe20000000f00ULL,
0x000000ffff5b7224ULL, 0x000fc400078e0035ULL, 0x00000a6000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff1d7224ULL, 0x004fe200078e005aULL, 0xfffeba6000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5a7224ULL, 0x000fe200078e0034ULL, 0x0001f3f000447802ULL, 0x000fc40000000f00ULL,
0x00000a1000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff1c7224ULL, 0x004fe200078e005aULL,
0xfffeba4000007947ULL, 0x000fea000383ffffULL, 0x00000001ff457807ULL, 0x004fe40004000000ULL,
0x0001f44000447802ULL, 0x000fc40000000f00ULL, 0x00000a0000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff437224ULL, 0x000fe200078e0048ULL, 0xfffee4f000007947ULL, 0x000fea000383ffffULL,
0x00000001ff457807ULL, 0x000fe40005000000ULL, 0x0001f49000447802ULL, 0x000fc40000000f00ULL,
0x000009b000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff467224ULL, 0x000fe200078e0048ULL,
0xfffee53000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5a7224ULL, 0x000fe200078e0048ULL,
0x0001f4e000447802ULL, 0x000fc40000000f00ULL, 0x0000092000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff447224ULL, 0x004fe200078e005aULL, 0xfffee5f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5a7224ULL, 0x000fe200078e0048ULL, 0x0001f53000447802ULL, 0x000fc40000000f00ULL,
0x000008d000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff447224ULL, 0x004fe200078e005aULL,
0xfffee70000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5a7224ULL, 0x000fe200078e003bULL,
0x0001f59000447802ULL, 0x000fe20000000f00ULL, 0x000000ffff5b7224ULL, 0x000fc400078e0040ULL,
0x0000087000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff1d7224ULL, 0x004fe200078e005aULL,
0xfffeeb1000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5a7224ULL, 0x000fe200078e003bULL,
0x0001f5e000447802ULL, 0x000fc40000000f00ULL, 0x0000082000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff1c7224ULL, 0x004fe200078e005aULL, 0xfffeeaf000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5a7224ULL, 0x000fe200078e0034ULL, 0x0001f64000447802ULL, 0x000fe20000000f00ULL,
0x000000ffff5b7224ULL, 0x000fc400078e0035ULL, 0x000007c000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff1d7224ULL, 0x004fe200078e005aULL, 0xffff14b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5a7224ULL, 0x000fe200078e0034ULL, 0x0001f69000447802ULL, 0x000fc40000000f00ULL,
0x0000077000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff1c7224ULL, 0x004fe200078e005aULL,
0xffff149000007947ULL, 0x000fea000383ffffULL, 0x00000001ff457807ULL, 0x004fe40004000000ULL,
0x0001f6e000447802ULL, 0x000fc40000000f00ULL, 0x0000076000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff477224ULL, 0x000fe200078e0048ULL, 0xffff3f5000007947ULL, 0x000fea000383ffffULL,
0x00000001ff457807ULL, 0x000fe40004800000ULL, 0x0001f73000447802ULL, 0x000fc40000000f00ULL,
0x0000071000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff187224ULL, 0x000fe200078e0048ULL,
0xffff3f9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5a7224ULL, 0x000fe200078e0040ULL,
0x0001f78000447802ULL, 0x000fc40000000f00ULL, 0x0000068000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff177224ULL, 0x004fe200078e005aULL, 0xffff405000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5a7224ULL, 0x000fe200078e0040ULL, 0x0001f7d000447802ULL, 0x000fc40000000f00ULL,
0x0000063000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff177224ULL, 0x004fe200078e005aULL,
0xffff416000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5a7224ULL, 0x000fe200078e0017ULL,
0x0001f83000447802ULL, 0x000fe20000000f00ULL, 0x000000ffff5b7224ULL, 0x000fc400078e0018ULL,
0x000005d000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff1d7224ULL, 0x004fe200078e005aULL,
0xffff457000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5a7224ULL, 0x000fe200078e0017ULL,
0x0001f88000447802ULL, 0x000fc40000000f00ULL, 0x0000058000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff1c7224ULL, 0x004fe200078e005aULL, 0xffff455000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5a7224ULL, 0x000fe200078e000cULL, 0x0001f8e000447802ULL, 0x000fe20000000f00ULL,
0x000000ffff5b7224ULL, 0x000fc400078e000dULL, 0x0000052000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff1d7224ULL, 0x004fe200078e005aULL, 0xffff6f3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5a7224ULL, 0x000fe200078e000cULL, 0x0001f93000447802ULL, 0x000fc40000000f00ULL,
0x000004d000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff1c7224ULL, 0x004fe200078e005aULL,
0xffff6f1000007947ULL, 0x000fea000383ffffULL, 0x00000002ff337424ULL, 0x000fe200078e00ffULL,
0x0001f98000087802ULL, 0x000fc40000000f00ULL, 0x0000044000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0031ULL, 0xffffe7b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff327224ULL, 0x006fe200078e0034ULL, 0x0001f9e000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff337424ULL, 0x000fc400078e00ffULL, 0x000003e000007944ULL, 0x000fea0003c00000ULL,
0x000000313400720bULL, 0x004fe20003f1e000ULL, 0x000000ffff327224ULL, 0x002fe200078e0006ULL,
0x0001fa4000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff337424ULL, 0x000fe200078e00ffULL,
0x0000003431347208ULL, 0x000fc80004000000ULL, 0x0000038000007944ULL, 0x000fea0003c00000ULL,
0x000000310600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff327224ULL, 0x002fe200078e0007ULL,
0x0001faa000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff337424ULL, 0x000fe200078e00ffULL,
0x0000000631067208ULL, 0x000fc80004000000ULL, 0x0000032000007944ULL, 0x000fea0003c00000ULL,
0x000000310700720bULL, 0x004fe20003f1e000ULL, 0x000000ffff327224ULL, 0x002fe200078e0035ULL,
0x0001fb0000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff337424ULL, 0x000fe200078e00ffULL,
0x0000000731307208ULL, 0x000fc80004000000ULL, 0x000002c000007944ULL, 0x000fea0003c00000ULL,
0x000000313500720bULL, 0x004fe20003f1e000ULL, 0x000000ffff327224ULL, 0x002fe200078e0034ULL,
0x0001fb6000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff337424ULL, 0x000fe200078e00ffULL,
0x0000003531047208ULL, 0x000fc80004000000ULL, 0x0000026000007944ULL, 0x000fea0003c00000ULL,
0x000000313400720bULL, 0x004fe20003f1e000ULL, 0x000000ffff327224ULL, 0x002fe200078e0006ULL,
0x0001fbc000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff337424ULL, 0x000fe200078e00ffULL,
0x0000003431057208ULL, 0x000fc80004000000ULL, 0x0000020000007944ULL, 0x000fea0003c00000ULL,
0x000000310600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff327224ULL, 0x002fe200078e0030ULL,
0x0001fc2000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff337424ULL, 0x000fe200078e00ffULL,
0x0000000631067208ULL, 0x000fc80004000000ULL, 0x000001a000007944ULL, 0x000fea0003c00000ULL,
0xffffe68000007947ULL, 0x000fea000383ffffULL, 0x0180000013027810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000002037812ULL, 0x000fc800078ec0ffULL,
0x018000000300780cULL, 0x000fda0003f05070ULL, 0x0000001300028308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0300720cULL, 0x040fe40003f25070ULL,
0x008000000300780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff027807ULL, 0x004fc80004000000ULL, 0x0000000203ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff13ff7812ULL, 0x000fc8000780c0ffULL,
0x00000001ff027807ULL, 0x000fc80000000000ULL, 0x0000000203ff7212ULL, 0x000fe4000780c0ffULL,
0x8000000013037812ULL, 0x000fd600078ec0ffULL, 0x0080000003020812ULL, 0x000fe200078efcffULL,
0x000000ffff028224ULL, 0x000fe200078e0003ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000001300027308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff047224ULL, 0x00cfe400078e0002ULL, 0x000000ffff027224ULL, 0x000fe400078e0005ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffe024002007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff097424ULL, 0x000fe200078e00ffULL, 0x0000003700007348ULL, 0x000fe80003800000ULL,
0x0c00003332317389ULL, 0x0002a200000e0036ULL, 0xfffe020008007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff457424ULL, 0x000fe200078e00ffULL, 0x0000001a00007348ULL, 0x000fe80003800000ULL,
0x0000005b5a5a7389ULL, 0x0002a200000e0019ULL, 0xfffe01c044007950ULL, 0x000fea0003c3ffffULL,
0x000000014500780cULL, 0x000fe20003f45070ULL, 0x0000001800007348ULL, 0x000fd80003800000ULL,
0x0000000000457806ULL, 0x000fc800050e0100ULL, 0x0000001845487212ULL, 0x000fe200078ec0ffULL,
0x00000000ff457424ULL, 0x000fc800078e00ffULL, 0xfffe016044007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000200000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005e7ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000748ULL, 0x0000000000000288ULL, 0x0000001a00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009d0ULL, 0x00000000000003b8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000d88ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e48ULL, 0x0000000000000a08ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001850ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001860ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000007bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000018f0ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000018f4ULL, 0x00000000000001a8ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001b00ULL, 0x000000000001ff80ULL, 0xe700001a00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x0000000100000089ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000021a80ULL, 0x0000000000000044ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000021ad0ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000021e50ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x00000000000018f0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000020190ULL, 0x0000000000020190ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000021a80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000021e50ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_1_kvt_int8_nqpkv_8_m_8_sm_86_cubin_len = 139056;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
