/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_1_kvt_int8_pagedKV_128_nqpkv_8_m_8_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x00000000000255d0ULL, 0x0000000000025250ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f34314944327961ULL, 0x6f6c66625f766e5fULL,
0x326a4c3236317461ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL,
0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x336a4c4536316a4cULL, 0x4c49746132454532ULL,
0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4534366aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL,
0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL,
0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL, 0x45326a4c4545316aULL, 0x7461324545316a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x4939494432796172ULL, 0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL,
0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL,
0x4c4545346a4c6a49ULL, 0x36316a4c4532336aULL, 0x624c497461324545ULL, 0x31534b5245454531ULL,
0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL,
0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL, 0x4c4545326a4c4532ULL, 0x4545316a4c45326aULL,
0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x45386a4c4545346aULL,
0x7461324545386a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL,
0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL,
0x6a4c4536316a4c45ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5f2400676e696469ULL, 0x616e7265746e695fULL, 0x635f5f245f305f6cULL,
0x30326d735f616475ULL, 0x5f6e725f7063725fULL, 0x5f3233665f7a7466ULL, 0x68746170776f6c73ULL,
0x65746e695f5f2400ULL, 0x245f315f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL,
0x6c66625f636e7973ULL, 0x695f5f2400705f79ULL, 0x5f6c616e7265746eULL, 0x6475635f5f245f32ULL,
0x735f30376d735f61ULL, 0x5f636e79736c6668ULL, 0x5f2400705f786469ULL, 0x616e7265746e695fULL,
0x635f5f245f335f6cULL, 0x30376d735f616475ULL, 0x6e797365746f765fULL, 0x746f6c6c61625f63ULL,
0x742e616c65722e00ULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL,
0x5f6c656e72656b2eULL, 0x72656b240061686dULL, 0x2461686d5f6c656eULL, 0x657479426d656d73ULL,
0x2e766e2e00667542ULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x61705f0061686d5fULL,
0x6265642e006d6172ULL, 0x656d6172665f6775ULL, 0x65642e6c65722e00ULL, 0x6d6172665f677562ULL,
0x2e616c65722e0065ULL, 0x72665f6775626564ULL, 0x2e766e2e00656d61ULL, 0x697463612e6c6572ULL,
0x0000000000006e6fULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c0001000000adULL, 0x0000000000000034ULL, 0x0000000000000010ULL, 0x000c0001000000ebULL,
0x000000000000001cULL, 0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c00010000016bULL, 0x000000000000002cULL, 0x0000000000000004ULL,
0x000c0001000001b5ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c0001000001fbULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000242ULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000c000100000288ULL, 0x0000000000000030ULL, 0x0000000000000004ULL,
0x000c0001000002d6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c000100000324ULL,
0x0000000000000018ULL, 0x0000000000000004ULL, 0x000c000100000372ULL, 0x000000000000000cULL,
0x0000000000000004ULL, 0x000c0001000003b9ULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000c000100000407ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c00010000044cULL,
0x0000000000000020ULL, 0x0000000000000004ULL, 0x000b002200000492ULL, 0x0000000000023360ULL,
0x0000000000000170ULL, 0x000b0022000004c5ULL, 0x00000000000234d0ULL, 0x0000000000000050ULL,
0x000b0022000004f0ULL, 0x0000000000023520ULL, 0x0000000000000040ULL, 0x000b00220000051aULL,
0x0000000000023560ULL, 0x0000000000000120ULL, 0x000a000300000588ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00040003000005a8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00070003000005d8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL,
0x0000000000000000ULL, 0x0000000000023680ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0002336000000000ULL,
0x0000040400000000ULL, 0x810c0000015c0400ULL, 0x008b700400288080ULL, 0x0000000000000000ULL,
0x000000bcffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080900828808081ULL, 0x9508288080940828ULL, 0x2880809608288080ULL,
0x809a082880809908ULL, 0x082880809e082880ULL, 0x8080a408288080a0ULL, 0xaa08288080a60828ULL,
0x288080ae08288080ULL, 0x80b608288080b408ULL, 0x08288080b8082880ULL, 0x8080be08288080baULL,
0xc208288080c10828ULL, 0x288080c408288080ULL, 0x80c608288080c508ULL, 0x08288080c7082880ULL,
0x8080de08288080c8ULL, 0x8016288080840828ULL, 0x0000000310288082ULL, 0x8084920000000000ULL,
0x0000000022002880ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL, 0x0002336000000000ULL,
0x0000017000000000ULL, 0x0000000000000000ULL, 0x000000c4ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080880828808081ULL,
0x90082880808a0828ULL, 0x2880809408288080ULL, 0x8096082880809508ULL, 0x0828808097082880ULL,
0x80809a0828808099ULL, 0xa0082880809e0828ULL, 0x288080a408288080ULL, 0x80aa08288080a608ULL,
0x08288080ae082880ULL, 0x8080b608288080b4ULL, 0xba08288080b80828ULL, 0x288080be08288080ULL,
0x80c208288080c108ULL, 0x08288080c4082880ULL, 0x8080c708288080c5ULL, 0xde08288080c80828ULL,
0x288080b008288080ULL, 0x0003102880828016ULL, 0x9200000000000000ULL, 0x00002200288080b0ULL,
0x0000002cffffffffULL, 0x0000016000000000ULL, 0x000234d000000000ULL, 0x0000005000000000ULL,
0x00000c0400000000ULL, 0x8088288080b00900ULL, 0x0000000000002880ULL, 0x000000c4ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x80808a0828808081ULL, 0x9408288080900828ULL, 0x2880809508288080ULL, 0x8097082880809608ULL,
0x0828808099082880ULL, 0x80809e082880809aULL, 0xa408288080a00828ULL, 0x288080a608288080ULL,
0x80ae08288080aa08ULL, 0x08288080b4082880ULL, 0x8080b808288080b6ULL, 0xbe08288080ba0828ULL,
0x288080c108288080ULL, 0x80c508288080c208ULL, 0x08288080c6082880ULL, 0x8080c808288080c7ULL,
0xc408288080de0828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x00288080c4920000ULL,
0x0000000000000022ULL, 0x0000001cffffffffULL, 0x0000026800000000ULL, 0x0002352000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x000000bcffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80808a0828808081ULL,
0x9408288080900828ULL, 0x2880809508288080ULL, 0x8097082880809608ULL, 0x0828808099082880ULL,
0x80809e082880809aULL, 0xa408288080a00828ULL, 0x288080a608288080ULL, 0x80ae08288080aa08ULL,
0x08288080b4082880ULL, 0x8080b808288080b6ULL, 0xbe08288080ba0828ULL, 0x288080c108288080ULL,
0x80c408288080c208ULL, 0x08288080c7082880ULL, 0x8080de08288080c8ULL, 0x8016288080c50828ULL,
0x0000000310288082ULL, 0x80c5920000000000ULL, 0x0000000022002880ULL, 0x0000002cffffffffULL,
0x0000036000000000ULL, 0x0002356000000000ULL, 0x0000012000000000ULL, 0x0000140400000000ULL,
0x80c4288080c50900ULL, 0x0000000000002880ULL, 0x0000001a00082f04ULL, 0x00082304000000f1ULL,
0x0000000000000016ULL, 0x0000001600081204ULL, 0x0008110400000000ULL, 0x0000000000000016ULL,
0x0000001500082304ULL, 0x0008120400000000ULL, 0x0000000000000015ULL, 0x0000001500081104ULL,
0x0008230400000000ULL, 0x0000000000000014ULL, 0x0000001400081204ULL, 0x0008110400000000ULL,
0x0000000000000014ULL, 0x0000001300082304ULL, 0x0008120400000000ULL, 0x0000000000000013ULL,
0x0000001300081104ULL, 0x0008230400000000ULL, 0x000000000000001aULL, 0x0000001a00081204ULL,
0x0008110400000000ULL, 0x000000000000001aULL, 0x0000007b00043704ULL, 0x00080a0400003501ULL,
0x0050016000000017ULL, 0x000c170400501903ULL, 0x0048000600000000ULL, 0x000c17040021f000ULL,
0x0040000500000000ULL, 0x000c17040021f000ULL, 0x0038000400000000ULL, 0x000c17040011f000ULL,
0x0018000300000000ULL, 0x000c17040081f000ULL, 0x0010000200000000ULL, 0x000c17040021f000ULL,
0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL,
0x0000002000043104ULL, 0xffffffff01982904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x01982804ffffffffULL, 0x00000100000000e0ULL, 0x0000205000000470ULL, 0x000021d0000020e0ULL,
0x0000279000002340ULL, 0x00002820000027c0ULL, 0x0000556000002880ULL, 0x000055f000005590ULL,
0x000083a000005650ULL, 0x0000854000008430ULL, 0x00008b30000086a0ULL, 0x00008bc000008b60ULL,
0x0000b71000008c20ULL, 0x0000b7a00000b740ULL, 0x0000e3e00000b800ULL, 0x0000e5700000e460ULL,
0x0000eb400000e6d0ULL, 0x0000ebe00000eb70ULL, 0x000117400000ec50ULL, 0x000117e000011770ULL,
0x000144b000011850ULL, 0x0001464000014530ULL, 0x00014c10000147a0ULL, 0x00014cb000014c40ULL,
0x0001783000014d20ULL, 0x000178d000017860ULL, 0x0001999000017940ULL, 0x0001a170000199a0ULL,
0x00021410000213d0ULL, 0x0002143000021420ULL, 0x000214a000021480ULL, 0x000214d0000214c0ULL,
0x00022200000221a0ULL, 0x000222e000022270ULL, 0x000223c000022350ULL, 0x000224a000022430ULL,
0x0002256000022500ULL, 0x00022640000225d0ULL, 0x00022720000226b0ULL, 0x0002280000022790ULL,
0x000228c000022860ULL, 0x000229a000022930ULL, 0x00022aa000022a20ULL, 0x00022ba000022b20ULL,
0x00022c6000022c00ULL, 0x00022d4000022cd0ULL, 0x00022e4000022dc0ULL, 0x00022f4000022ec0ULL,
0x0002304000022fc0ULL, 0x00023140000230c0ULL, 0x00023240000231c0ULL, 0x00023340000232c0ULL,
0x0000020006003904ULL, 0x00018600000000ffULL, 0x000002c0003f0100ULL, 0x000186080000000fULL,
0x000002f0003f0120ULL, 0x000186880000000fULL, 0x00000440003f0120ULL, 0x000186a80000000fULL,
0x00000460003f0120ULL, 0x000186b8000000ffULL, 0x000004f0003f0100ULL, 0x00018600000000ffULL,
0x00000640003f0107ULL, 0x0001868c0000000fULL, 0x000006a0003f0102ULL, 0x000186880000000fULL,
0x00000f00003f0101ULL, 0x000186a8000000ffULL, 0x00001020003f0107ULL, 0x000186a8000000ffULL,
0x00001080003f0101ULL, 0x000186b8000000ffULL, 0x00001210003f0101ULL, 0x000186bc000000ffULL,
0x000013e0003f0105ULL, 0x000186bc000000ffULL, 0x00001ca0003f0105ULL, 0x000186b0000000ffULL,
0x00001d20003f0107ULL, 0x000186b0000000ffULL, 0x00001d80003f0101ULL, 0x000186080000000fULL,
0x00001da0003f0101ULL, 0x0001860c0000000fULL, 0x00001f70003f0105ULL, 0x0001860c0000000fULL,
0x000024f0003f0105ULL, 0x000186ac000000ffULL, 0x000026c0003f0105ULL, 0x000186ac000000ffULL,
0x000047f0003f0105ULL, 0x000186b8000000ffULL, 0x00004820003f0101ULL, 0x000186bc000000ffULL,
0x000049e0003f0105ULL, 0x000186bc000000ffULL, 0x00005230003f0105ULL, 0x000186a8000000ffULL,
0x000052b0003f0107ULL, 0x000186a8000000ffULL, 0x000052e0003f0101ULL, 0x000186b4000000ffULL,
0x000054b0003f0105ULL, 0x000186b4000000ffULL, 0x000074e0003f0105ULL, 0x000186b8000000ffULL,
0x00007550003f0101ULL, 0x00018688000000ffULL, 0x000075a0003f0101ULL, 0x000186bc000000ffULL,
0x00007770003f0105ULL, 0x000186bc000000ffULL, 0x00007fc0003f0105ULL, 0x000186b0000000ffULL,
0x000080c0003f0107ULL, 0x000186b0000000ffULL, 0x00008120003f0101ULL, 0x000186280000000fULL,
0x00008140003f0101ULL, 0x0001862c0000000fULL, 0x00008310003f0105ULL, 0x0001862c0000000fULL,
0x00008890003f0105ULL, 0x000186ac000000ffULL, 0x00008a60003f0105ULL, 0x000186ac000000ffULL,
0x0000a9a0003f0105ULL, 0x000186b8000000ffULL, 0x0000a9d0003f0101ULL, 0x000186bc000000ffULL,
0x0000ab90003f0105ULL, 0x000186bc000000ffULL, 0x0000b3e0003f0105ULL, 0x000186a8000000ffULL,
0x0000b460003f0107ULL, 0x000186a8000000ffULL, 0x0000b490003f0101ULL, 0x000186b4000000ffULL,
0x0000b660003f0105ULL, 0x000186b4000000ffULL, 0x0000d590003f0105ULL, 0x000186b8000000ffULL,
0x0000d600003f0101ULL, 0x00018690000000ffULL, 0x0000d660003f0101ULL, 0x000186bc000000ffULL,
0x0000d830003f0105ULL, 0x000186bc000000ffULL, 0x0000e080003f0105ULL, 0x000186b0000000ffULL,
0x0000e100003f0107ULL, 0x000186b0000000ffULL, 0x0000e160003f0101ULL, 0x000186480000000fULL,
0x0000e180003f0101ULL, 0x0001864c0000000fULL, 0x0000e350003f0105ULL, 0x0001864c0000000fULL,
0x0000e8a0003f0105ULL, 0x000186ac000000ffULL, 0x0000ea70003f0105ULL, 0x000186ac000000ffULL,
0x000109d0003f0105ULL, 0x000186b8000000ffULL, 0x00010a00003f0101ULL, 0x000186bc000000ffULL,
0x00010bc0003f0105ULL, 0x000186bc000000ffULL, 0x00011410003f0105ULL, 0x000186a8000000ffULL,
0x00011490003f0107ULL, 0x000186a8000000ffULL, 0x000114c0003f0101ULL, 0x000186b4000000ffULL,
0x00011690003f0105ULL, 0x000186b4000000ffULL, 0x000135e0003f0105ULL, 0x000186b8000000ffULL,
0x00013650003f0101ULL, 0x00018698000000ffULL, 0x000136b0003f0101ULL, 0x000186bc000000ffULL,
0x00013880003f0105ULL, 0x000186bc000000ffULL, 0x000140d0003f0105ULL, 0x000186b0000000ffULL,
0x000141d0003f0107ULL, 0x000186b0000000ffULL, 0x00014230003f0101ULL, 0x000186680000000fULL,
0x00014250003f0101ULL, 0x0001866c0000000fULL, 0x00014420003f0105ULL, 0x0001866c0000000fULL,
0x00014970003f0105ULL, 0x000186ac000000ffULL, 0x00014b40003f0105ULL, 0x000186ac000000ffULL,
0x00016aa0003f0105ULL, 0x000186b8000000ffULL, 0x00016ad0003f0101ULL, 0x000186bc000000ffULL,
0x00016c90003f0105ULL, 0x000186bc000000ffULL, 0x00017500003f0105ULL, 0x000186a8000000ffULL,
0x00017580003f0107ULL, 0x000186a8000000ffULL, 0x000175b0003f0101ULL, 0x000186b4000000ffULL,
0x00017780003f0105ULL, 0x000186b4000000ffULL, 0x000196d0003f0105ULL, 0x000186b8000000ffULL,
0x00019730003f0101ULL, 0x000186a0000000ffULL, 0x0001a3e0003f0101ULL, 0x00018600000000ffULL,
0x0001c010003f0101ULL, 0x00018604000000ffULL, 0x0001c1e0003f0105ULL, 0x00018604000000ffULL,
0x0001c550003f0105ULL, 0x00018600000000ffULL, 0x0001c580003f0101ULL, 0x00018604000000ffULL,
0x0001c740003f0105ULL, 0x00018604000000ffULL, 0x00020810003f0105ULL, 0x000000000000003dULL,
0x00020920003f0101ULL, 0x000000040000003dULL, 0x00020af0003f0105ULL, 0x000000040000003dULL,
0x00021ff0003f0105ULL, 0x000000000000003fULL, 0x00022050003f0101ULL, 0x000000080000003fULL,
0x000220b0003f0101ULL, 0x000000100000003fULL, 0x00022120003f0101ULL, 0x000000180000003fULL,
0x00053803003f0101ULL, 0x0001a2b000101c04ULL, 0x0001c8500001c7a0ULL, 0x0000040100022160ULL,
0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x000000000000043cULL, 0x0000001a00000002ULL, 0x000000000000034cULL,
0x0000001a00000002ULL, 0x0000000000000244ULL, 0x0000001a00000002ULL, 0x000000000000014cULL,
0x0000001a00000002ULL, 0x0000000000000044ULL, 0x0000001a00000002ULL, 0x0000000000000415ULL,
0x0000001a00000002ULL, 0x0000000000000322ULL, 0x0000001a00000002ULL, 0x000000000000021fULL,
0x0000001a00000002ULL, 0x0000000000000125ULL, 0x0000001a00000002ULL, 0x0000000000018700ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x00000000000f7919ULL, 0x000e620000002100ULL,
0x00000000000c7806ULL, 0x000fe200038e0000ULL, 0x00005800ff397624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000037919ULL, 0x000ea20000002300ULL,
0x0000000c00087300ULL, 0x000fe200000e0000ULL, 0x0000000839077824ULL, 0x000fe400078e00ffULL,
0x0000000000047919ULL, 0x000ee80000002200ULL, 0x0000000000007919ULL, 0x000f220000002600ULL,
0x0000000c00147309ULL, 0x000ea60000000000ULL, 0x00000000000a7919ULL, 0x000f280000000000ULL,
0x0000000000127919ULL, 0x000f220000002700ULL, 0x00000005ff027819ULL, 0x002fc6000001160fULL,
0x00001fff030e7589ULL, 0x0047e200000e0000ULL, 0x000000ffff147224ULL, 0x000fc600078e0a14ULL,
0x00001fff02027589ULL, 0x000e6200000e0000ULL, 0x0000010003037a24ULL, 0x008fe400078e0204ULL,
0x0000000800067824ULL, 0x010fe400078e00ffULL, 0x00000000030f7a24ULL, 0x000fe200078e020fULL,
0x0000000a0800720cULL, 0x000fe20003f02070ULL, 0x0000000000037919ULL, 0x000ea20000000000ULL,
0x0000001207087224ULL, 0x000fe400078e0206ULL, 0x000000ff0f00720cULL, 0x000fc40003f25270ULL,
0x0000000f0f00780cULL, 0x040fe40003f44070ULL, 0x000000030f00780cULL, 0x040fe40003f64070ULL,
0x0000007f0f00780cULL, 0x000fe20003f84070ULL, 0x000000040e097824ULL, 0x002fcc00078e0202ULL,
0x3fffff80ff049424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff059424ULL, 0x000fe400078e00ffULL,
0x0000000209097824ULL, 0x000fe400078e00ffULL, 0x3fffff60ff06b424ULL, 0x000fe200078e00ffULL,
0x01860004ff009388ULL, 0x0003e20000000a00ULL, 0x00000001090a7824ULL, 0x044fe400078e0203ULL,
0x0000002009107824ULL, 0x000fc400078e00ffULL, 0x7fffff60ff07b424ULL, 0x000fe400078e00ffULL,
0xff317217ff0bc424ULL, 0x000fe200078e00ffULL, 0xffffffe010107812ULL, 0x000fe200078ee20aULL,
0x00000200ff0a7424ULL, 0x000fe400078e00ffULL, 0x3fffffc0ff04a424ULL, 0x002fe200078e00ffULL,
0x0184000b0f00c388ULL, 0x000fe20000004800ULL, 0x7fffffc0ff05a424ULL, 0x000fe400078e00ffULL,
0x3fffff80ff0c9424ULL, 0x000fc400078e00ffULL, 0x7fffff80ff0d9424ULL, 0x000fe200078e00ffULL,
0x018608040f00a388ULL, 0x0003e20000008a00ULL, 0x000000010f00780cULL, 0x000fe20003f44070ULL,
0x0000001010107824ULL, 0x000fe400078e00ffULL, 0x018688060f00b388ULL, 0x0005e20000008a00ULL,
0x0000000809047817ULL, 0x002fe20007800000ULL, 0x0000000108057824ULL, 0x000fd000078e0209ULL,
0x7fffff00ff0ba424ULL, 0x000fe400078e00ffULL, 0x0000000104047824ULL, 0x000fe200078e0a09ULL,
0x0000000109097810ULL, 0x000fe20007ffe0ffULL, 0x0000001003067824ULL, 0x004fc600078e00ffULL,
0x000000ff0400720cULL, 0x000fe20003f63070ULL, 0x0000000108087824ULL, 0x000fe200078e0209ULL,
0x000000010400780cULL, 0x000fe20003f83070ULL, 0x00005c0005047625ULL, 0x000fe200078e000aULL,
0x000001f006117812ULL, 0x000fc600078ec0ffULL, 0x0000000109077824ULL, 0x040fe200078e0203ULL,
0x0000001104047210ULL, 0x000fe20007fbe0ffULL, 0x0000002009137824ULL, 0x000fe400078e00ffULL,
0x00005c0008087625ULL, 0x000fc600078e000aULL, 0xffffffe013077812ULL, 0x000fe200078ee207ULL,
0x3fffff00ff0aa424ULL, 0x000fe200078e00ffULL, 0x0000001108087210ULL, 0x000fe20007fde0ffULL,
0x000000ffff057224ULL, 0x000fe400028e0605ULL, 0x0000001007077824ULL, 0x000fe200078e00ffULL,
0x0186a80a0f00a388ULL, 0x000fe20000008a00ULL, 0x000000ffff097224ULL, 0x000fc600030e0609ULL,
0x0186b80cff009388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004107faeULL, 0x0003e8000d901c46ULL,
0x0000000008077faeULL, 0x0005e2000e101c46ULL, 0x000000ffff047224ULL, 0x002fc400078e0014ULL,
0x00000004ff057424ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x004fe60000000000ULL,
0x00006200120c7625ULL, 0x000fe200078e0005ULL, 0x01860404ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01860000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x000000060c0c7981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0e00720cULL, 0x000fc40003f05270ULL,
0x0000007f0c0d7810ULL, 0x044fe40007ffe0ffULL, 0x000000ff0c077810ULL, 0x000fe40007ffe0ffULL,
0x00000007ff0d7819ULL, 0x000fe4000001160dULL, 0x00000008ff0e7819ULL, 0x000fca0000011607ULL,
0x00019cd000008947ULL, 0x000fea0003800000ULL, 0x000001ff0700780cULL, 0x000fe20003f24070ULL,
0x00000008020f7824ULL, 0x000fe200078e00ffULL, 0x000000ff0d00720cULL, 0x000fe20003f05270ULL,
0x00000003ff047424ULL, 0x002fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01868c040fff738cULL, 0x0003e20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018688000fff7f8cULL, 0x0005e2000c80043fULL, 0xffffffffff107424ULL, 0x000fe200078e00ffULL,
0x0000005000008947ULL, 0x000fea0003800000ULL, 0x0000000212047824ULL, 0x002fe400078e00ffULL,
0x00006400ff077624ULL, 0x000fc800078e00ffULL, 0x0000640004047624ULL, 0x000fc800078e0207ULL,
0x0000600004107625ULL, 0x000fcc00078e0005ULL, 0x0000000610107981ULL, 0x000324000c1e1900ULL,
0x0000580010047a24ULL, 0x012fc800078e02ffULL, 0x0000008004137824ULL, 0x000fe200078e00ffULL,
0x0000043000001947ULL, 0x000fea0003800000ULL, 0x0000000f0c047217ULL, 0x000fe40007800000ULL,
0x00000004ff057819ULL, 0x000fe40000011603ULL, 0x000000f006197812ULL, 0x000fe200078ec0ffULL,
0x0000000104047824ULL, 0x000fe200078e0a0fULL, 0x0000000205087810ULL, 0x000fe20007ffe0ffULL,
0x000000010f077824ULL, 0x000fe200078e0205ULL, 0x00000004050a7810ULL, 0x040fe40007ffe0ffULL,
0x000000040500720cULL, 0x080fe20003f06070ULL, 0x000000010f097824ULL, 0x000fe200078e0208ULL,
0x00000006050b7810ULL, 0x000fe20007ffe0ffULL, 0x0000008000057824ULL, 0x000fe200078e0207ULL,
0x000000040800720cULL, 0x080fe20003f26070ULL, 0x0000000107087824ULL, 0x140fe200078e0203ULL,
0x000000040a00720cULL, 0x000fe20003f46070ULL, 0x0000001007147824ULL, 0x000fe200078e00ffULL,
0x00000005131a7210ULL, 0x000fe20007f7e0ffULL, 0x0000000109077824ULL, 0x000fc400078e0203ULL,
0x0000001009157824ULL, 0x000fe200078e00ffULL, 0x00005e001a117a11ULL, 0x040fe200078840ffULL,
0x000000ffff097224ULL, 0x000fe200018e06ffULL, 0x000000040b00720cULL, 0x000fe20003f66070ULL,
0x000000010f0a7824ULL, 0x000fe200078e020aULL, 0x0000000205047810ULL, 0x000fe20007ffe0ffULL,
0x000000010f0b7824ULL, 0x000fe200078e020bULL, 0x00005f001a1a7a11ULL, 0x000fe400020f4409ULL,
0x0000000405097810ULL, 0x000fe20007ffe0ffULL, 0x000000010b067824ULL, 0x100fe200078e0203ULL,
0x0000000605057810ULL, 0x000fe20007ffe0ffULL, 0x000000100b1b7824ULL, 0x000fe200078e00ffULL,
0x0000000413187210ULL, 0x000fe20007fde0ffULL, 0x000000010a047824ULL, 0x000fe200078e0203ULL,
0xfffffff015077812ULL, 0x000fc400078ee207ULL, 0x0000000913157210ULL, 0x040fe20007f9e0ffULL,
0x000000100a097824ULL, 0x000fe200078e00ffULL, 0x0000000513137210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff057224ULL, 0x000fe200030e06ffULL, 0x00005e0018177a11ULL, 0x040fe200078c40ffULL,
0x000000ffff167224ULL, 0x000fe200020e06ffULL, 0xfffffff009097812ULL, 0x000fe200078ee204ULL,
0x000000ffff0b7224ULL, 0x000fe200028e06ffULL, 0x00005f0018187a11ULL, 0x000fe400030f4405ULL,
0x0000001119047210ULL, 0x000fc40007fde0ffULL, 0xfffffff014087812ULL, 0x000fe400078ee208ULL,
0x00005e0015147a11ULL, 0x000fe200078840ffULL, 0x000000ffff057224ULL, 0x000fe200030e061aULL,
0x0001400008087811ULL, 0x000fe400078e20ffULL, 0x00005e00130a7a11ULL, 0x000fe400078a40ffULL,
0xfffffff01b117812ULL, 0x000fe200078ee206ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004087faeULL, 0x0003e2000c101c46ULL, 0x00005f0015157a11ULL, 0x000fc400020f4416ULL,
0x00005f0013137a11ULL, 0x000fe400028f440bULL, 0x0000001914067210ULL, 0x080fe40007f9e0ffULL,
0x00014000090b7811ULL, 0x000fe400078e20ffULL, 0x0001400011117811ULL, 0x000fe400078e20ffULL,
0x0000001917047210ULL, 0x082fe40007f1e0ffULL, 0x000000190a087210ULL, 0x000fc40007fbe0ffULL,
0x00014000070a7811ULL, 0x000fe200078e20ffULL, 0x000000ffff057224ULL, 0x000fe400000e0618ULL,
0x000000ffff077224ULL, 0x000fe400020e0615ULL, 0x000000ffff097224ULL, 0x000fe200028e0613ULL,
0x00000000040a7faeULL, 0x0003e8000c901c46ULL, 0x00000000060b7faeULL, 0x0003e8000d101c46ULL,
0x0000000008117faeULL, 0x0003e2000d901c46ULL, 0x0000038000007947ULL, 0x000fea0003800000ULL,
0x0000000f03047211ULL, 0x000fe400078fe0ffULL, 0x000000f006197812ULL, 0x000fc400078ec0ffULL,
0x0000000204077810ULL, 0x040fe20007ffe0ffULL, 0x0000000104057824ULL, 0x140fe200078e0203ULL,
0x00000006040b7810ULL, 0x040fe20007ffe0ffULL, 0x0000001004097824ULL, 0x000fe400078e00ffULL,
0x0000000107087824ULL, 0x040fe400078e0203ULL, 0x00000010070a7824ULL, 0x000fe200078e00ffULL,
0xfffffff009077812ULL, 0x000fe200078ee205ULL, 0x0000008000057824ULL, 0x000fe400078e0204ULL,
0x000000100b177824ULL, 0x000fe200078e00ffULL, 0xfffffff00a097812ULL, 0x000fc400078ee208ULL,
0x0000000404087810ULL, 0x000fe40007ffe0ffULL, 0x0000000513187210ULL, 0x000fe40007f1e0ffULL,
0x0000000205047810ULL, 0x040fe20007ffe0ffULL, 0x0000001008157824ULL, 0x040fe200078e00ffULL,
0x00000004050a7810ULL, 0x040fe40007ffe0ffULL, 0x0000000605117810ULL, 0x000fe20007ffe0ffULL,
0x0000000108057824ULL, 0x100fe200078e0203ULL, 0x0000000413167210ULL, 0x000fe20007f3e0ffULL,
0x000000010b087824ULL, 0x000fe200078e0203ULL, 0x0000000a13147210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff0a7224ULL, 0x000fe200000e06ffULL, 0x0000001113137210ULL, 0x000fc40007f7e0ffULL,
0x00005e0018047a11ULL, 0x040fe200078040ffULL, 0x000000ffff067224ULL, 0x000fe200010e06ffULL,
0xfffffff0150b7812ULL, 0x000fe200078ee205ULL, 0x000000ffff057224ULL, 0x000fe200018e06ffULL,
0x00005f0018187a11ULL, 0x000fe400000f440aULL, 0xfffffff017117812ULL, 0x000fe200078ee208ULL,
0x000000ffff177224ULL, 0x000fe200008e06ffULL, 0x00005e00130a7a11ULL, 0x000fe400078640ffULL,
0x0000000419047210ULL, 0x000fc40007f1e0ffULL, 0x00005e0014087a11ULL, 0x000fe400078440ffULL,
0x00005e0016157a11ULL, 0x000fe400078240ffULL, 0x00005f0013137a11ULL, 0x000fe200018f4405ULL,
0x000000ffff057224ULL, 0x000fe200000e0618ULL, 0x00005f0014147a11ULL, 0x000fe400010f4406ULL,
0x0001400007077811ULL, 0x000fe400078e20ffULL, 0x00005f0016167a11ULL, 0x000fc400008f4417ULL,
0x0000001519067210ULL, 0x040fe20007f1e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004077faeULL, 0x0003e2000b901c46ULL, 0x0000000819087210ULL, 0x040fe40007f3e0ffULL,
0x0000000a190a7210ULL, 0x000fe40007f5e0ffULL, 0x0001400011117811ULL, 0x000fe400078e20ffULL,
0x0001400009047811ULL, 0x002fe200078e20ffULL, 0x000000ffff077224ULL, 0x000fe200000e0616ULL,
0x000140000b057811ULL, 0x000fe200078e20ffULL, 0x000000ffff097224ULL, 0x000fc400008e0614ULL,
0x000000ffff0b7224ULL, 0x000fe200010e0613ULL, 0x0000000006047faeULL, 0x0003e8000b901c46ULL,
0x0000000008057faeULL, 0x0003e8000b901c46ULL, 0x000000000a117faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x000000ff0e00720cULL, 0x000fe20003f05270ULL,
0x000000ffff117224ULL, 0x000fe200078e00ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0186a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff297224ULL, 0x000fe200078e00ffULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0186a800ff147f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0186b800ff167f8cULL, 0x000ee2000c80043fULL, 0x000000ffff287224ULL, 0x000fe200078e00ffULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0001867000008947ULL, 0x000fea0003800000ULL, 0x0000000212127824ULL, 0x000fe400078e00ffULL,
0x00006400ff137624ULL, 0x000fc400078e00ffULL, 0x000000ffff417224ULL, 0x002fe400078e0015ULL,
0x0000640012127624ULL, 0x000fe400078e0213ULL, 0x000000ffff487224ULL, 0x008fe400078e0017ULL,
0xff317217ff437424ULL, 0x000fe400078e00ffULL, 0x000000ffff137224ULL, 0x000fe400078e00ffULL,
0x000000ffff147224ULL, 0x000fc400078e00ffULL, 0x000000ffff237224ULL, 0x000fc400078e00ffULL,
0x0000010013157824ULL, 0x000fca00078e00ffULL, 0x0000000c1500720cULL, 0x000fda0003f06070ULL,
0x0001857000000947ULL, 0x004fea0003800000ULL, 0x000000ffff157224ULL, 0x000fc400078e0014ULL,
0x0000000000167805ULL, 0x000fca0000015200ULL, 0x0186bc00ff1b7984ULL, 0x000e640000000800ULL,
0x800000001bff7812ULL, 0x002fe40007804848ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000001c7805ULL, 0x000fcc0000015200ULL,
0x0000001c161c7210ULL, 0x000fca0007f1e1ffULL, 0x000000011d1d7824ULL, 0x000fe200000e0e17ULL,
0x003d09001c00780cULL, 0x000fc80003f06070ULL, 0x000000ff1d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401c00780cULL, 0x000fc80003f06070ULL,
0x000000ff1d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1b7819ULL, 0x000fc8000001141dULL, 0x0000001c1b1b7211ULL, 0x000fca00078110ffULL,
0x000000ffff1c7224ULL, 0x000fca00000e061dULL, 0x000000021b1b7819ULL, 0x000fc8000000121cULL,
0x0000001b0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000011e1e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0186bc00ff1b7984ULL, 0x000e640000000800ULL, 0x800000001bff7812ULL, 0x002fe40007804848ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000113167810ULL, 0x000fe20007ffe0ffULL,
0x0000580010517a24ULL, 0x000fc600078e02ffULL, 0x0000000e1600720cULL, 0x000fe20003f26070ULL,
0x0000008051517824ULL, 0x000fd800078e00ffULL, 0x0000048000009947ULL, 0x000fea0003800000ULL,
0x0000002013167811ULL, 0x000fe400078e40ffULL, 0x00000004ff257819ULL, 0x000fe40000011603ULL,
0x000000160c177217ULL, 0x000fe40007800000ULL, 0x00000004253f7810ULL, 0x000fe20007ffe0ffULL,
0x000000010f1b7824ULL, 0x000fe200078e0225ULL, 0x00000002253c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000117177824ULL, 0x000fe200078e0a16ULL, 0x0000002000167811ULL, 0x000fe200078e38ffULL,
0x000000011b1c7824ULL, 0x000fe200078e0203ULL, 0x0000000625427810ULL, 0x000fe20007ffe0ffULL,
0x000000101b3d7824ULL, 0x000fe200078e00ffULL, 0x000000170f177217ULL, 0x040fe20007800000ULL,
0x000000010f1e7824ULL, 0x000fc400078e023fULL, 0x000000010f1d7824ULL, 0x000fe200078e023cULL,
0xfffffff03d3d7812ULL, 0x000fe200078ee21cULL, 0x000000011e1f7824ULL, 0x140fe400078e0203ULL,
0x000000101e407824ULL, 0x000fe400078e00ffULL, 0x000000011b1b7824ULL, 0x000fe400078e0216ULL,
0x000000011d1c7824ULL, 0x040fe200078e0203ULL, 0xfffffff040407812ULL, 0x000fe200078ee21fULL,
0x000000101d3e7824ULL, 0x000fe200078e00ffULL, 0x0000001b511f7210ULL, 0x000fe20007f1e0ffULL,
0x000000010f247824ULL, 0x000fc400078e0242ULL, 0x00000001171b7824ULL, 0x000fe200078e0a0fULL,
0xfffffff03e3e7812ULL, 0x000fe200078ee21cULL, 0x000000011d1c7824ULL, 0x100fe400078e0216ULL,
0x000000011e1d7824ULL, 0x100fe400078e0216ULL, 0x0000000124167824ULL, 0x040fe200078e0216ULL,
0x0000001c511c7210ULL, 0x040fe20007f5e0ffULL, 0x0000000124267824ULL, 0x040fe200078e0203ULL,
0x0000001d511d7210ULL, 0x000fe20007f9e0ffULL, 0x0000001024447824ULL, 0x000fc400078e00ffULL,
0x000000ffff247224ULL, 0x000fe200000e06ffULL, 0x00005e001f1e7a11ULL, 0x040fe200078040ffULL,
0x000000ffff277224ULL, 0x000fe200010e06ffULL, 0x0000001b3c00720cULL, 0x080fe40003f46070ULL,
0x00005f001f177a11ULL, 0x000fe200000f4424ULL, 0x00000010031f7824ULL, 0x000fe200078e00ffULL,
0xfffffff044447812ULL, 0x000fe400078ee226ULL, 0x0000001b2500720cULL, 0x000fe20003f06070ULL,
0x000000ffff257224ULL, 0x000fe200020e06ffULL, 0x000000f01f3c7812ULL, 0x000fc400078ec0ffULL,
0x00005e001c267a11ULL, 0x040fe400078640ffULL, 0x00000016511f7210ULL, 0x000fe40007fde0ffULL,
0x00005e001d247a11ULL, 0x040fe400078a40ffULL, 0x00005f001c277a11ULL, 0x000fe200018f4427ULL,
0x000000ffff1c7224ULL, 0x000fe200030e06ffULL, 0x0000003c1e167210ULL, 0x000fe40007f9e0ffULL,
0x00005f001d257a11ULL, 0x000fc400028f4425ULL, 0x00005e001f1e7a11ULL, 0x000fe200078a40ffULL,
0x000000ffff177224ULL, 0x000fe200020e0617ULL, 0x000160003d1d7811ULL, 0x000fe400078e20ffULL,
0x00005f001f1f7a11ULL, 0x000fe400028f441cULL, 0x0000003c261c7210ULL, 0x000fe20007fbe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000161d7faeULL, 0x0003e2000c101c46ULL,
0x0000001b3f00720cULL, 0x080fe40003f66070ULL, 0x0000001b4200720cULL, 0x000fc40003f86070ULL,
0x000160003e1b7811ULL, 0x000fe400078e20ffULL, 0x0000003c24167210ULL, 0x082fe20007f1e0ffULL,
0x000000ffff1d7224ULL, 0x000fe200028e0627ULL, 0x0000003c1e1e7210ULL, 0x000fe40007fbe0ffULL,
0x0001600040247811ULL, 0x000fe200078e20ffULL, 0x000000ffff177224ULL, 0x000fe200000e0625ULL,
0x0001600044257811ULL, 0x000fe200078e20ffULL, 0x000000ffff1f7224ULL, 0x000fe200028e061fULL,
0x000000001c1b7faeULL, 0x0003e8000d101c46ULL, 0x0000000016247faeULL, 0x0003e8000d901c46ULL,
0x000000001e257faeULL, 0x0003e2000e101c46ULL, 0x000003a000007947ULL, 0x000fea0003800000ULL,
0x0000000f03177211ULL, 0x000fe400078fe0ffULL, 0x00000020001b7811ULL, 0x000fc400078e38ffULL,
0x00000002171c7810ULL, 0x040fe20007ffe0ffULL, 0x0000000117167824ULL, 0x140fe200078e0203ULL,
0x00000006171f7810ULL, 0x040fe20007ffe0ffULL, 0x00000010173e7824ULL, 0x040fe400078e00ffULL,
0x000000011c1d7824ULL, 0x040fe400078e0203ULL, 0x000000101c3f7824ULL, 0x000fe200078e00ffULL,
0xfffffff03e3e7812ULL, 0x000fe200078ee216ULL, 0x0000000117167824ULL, 0x000fe400078e021bULL,
0x000000101f427824ULL, 0x000fe200078e00ffULL, 0xfffffff03f3f7812ULL, 0x000fc400078ee21dULL,
0x00000004171d7810ULL, 0x000fe40007ffe0ffULL, 0x00000016513c7210ULL, 0x000fe20007f1e0ffULL,
0x000000011c167824ULL, 0x000fe400078e021bULL, 0x000000011d1e7824ULL, 0x040fe400078e0203ULL,
0x000000101d407824ULL, 0x040fe400078e00ffULL, 0x000000011d177824ULL, 0x000fe400078e021bULL,
0x000000011f1d7824ULL, 0x040fe200078e0203ULL, 0xfffffff040407812ULL, 0x000fe200078ee21eULL,
0x000000ffff1c7224ULL, 0x000fe200000e06ffULL, 0x00005e003c277a11ULL, 0x000fe200078040ffULL,
0x000000011f1b7824ULL, 0x000fe200078e021bULL, 0xfffffff042427812ULL, 0x000fe200078ee21dULL,
0x00000010031e7824ULL, 0x000fe200078e00ffULL, 0x00005f003c3c7a11ULL, 0x000fc400000f441cULL,
0x00000016511d7210ULL, 0x040fe40007f1e0ffULL, 0x0000001751177210ULL, 0x040fe40007f7e0ffULL,
0x0000001b511b7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff267224ULL, 0x000fe200000e06ffULL,
0x000000f01e3d7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff1f7224ULL, 0x000fe200018e06ffULL,
0x00005e00171e7a11ULL, 0x000fe200078640ffULL, 0x000000ffff257224ULL, 0x000fe200020e06ffULL,
0x00005e001b247a11ULL, 0x000fc400078840ffULL, 0x0000003d27167210ULL, 0x000fe40007f1e0ffULL,
0x00005e001d1c7a11ULL, 0x000fe400078440ffULL, 0x00005f00171f7a11ULL, 0x000fe200018f441fULL,
0x000000ffff177224ULL, 0x000fe200000e063cULL, 0x00005f001b257a11ULL, 0x000fe400020f4425ULL,
0x000160003e1b7811ULL, 0x000fe400078e20ffULL, 0x00005f001d1d7a11ULL, 0x000fc400010f4426ULL,
0x0000003d1c1c7210ULL, 0x080fe20007f1e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000161b7faeULL, 0x0003e2000b901c46ULL, 0x0000003d1e1e7210ULL, 0x080fe40007f5e0ffULL,
0x0000003d24247210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff1d7224ULL, 0x000fe400000e061dULL,
0x000000ffff1f7224ULL, 0x000fe400010e061fULL, 0x000000ffff257224ULL, 0x000fe200018e0625ULL,
0x000160003f167811ULL, 0x002fc400078e20ffULL, 0x0001600040177811ULL, 0x000fe400078e20ffULL,
0x00016000421b7811ULL, 0x000fe200078e20ffULL, 0x000000001c167faeULL, 0x0003e8000b901c46ULL,
0x000000001e177faeULL, 0x0003e8000b901c46ULL, 0x00000000241b7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0186b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0186b000ff527f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018608000f1e7f8cULL, 0x0006a4000c80043fULL, 0x0000000000167805ULL, 0x000fc40000015200ULL,
0x01860c000f1b7984ULL, 0x000f240000000800ULL, 0x800000001bff7812ULL, 0x014fc4000780481fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff247224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001c7805ULL, 0x000fcc0000015200ULL, 0x0000001c161c7210ULL, 0x000fca0007f1e1ffULL,
0x000000011d1d7824ULL, 0x000fe200000e0e17ULL, 0x003d09001c00780cULL, 0x000fc80003f06070ULL,
0x000000ff1d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401c00780cULL, 0x000fc80003f06070ULL, 0x000000ff1d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1b7819ULL, 0x000fc8000001141dULL,
0x0000001c1b1b7211ULL, 0x000fca00078110ffULL, 0x000000ffff1c7224ULL, 0x000fca00000e061dULL,
0x000000021b1b7819ULL, 0x000fc8000000121cULL, 0x0000001b0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000124247810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01860c000f1b7984ULL, 0x000ea40000000800ULL,
0x800000001bff7812ULL, 0x004fe4000780481fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001ff177819ULL, 0x000fe20000011603ULL, 0x0000001003167824ULL, 0x000fc600078e00ffULL,
0x0000000c171b7812ULL, 0x000fe400078ec0ffULL, 0x0000007016177812ULL, 0x000fca00078ec0ffULL,
0x0000000117177824ULL, 0x000fca00078e021bULL, 0x01800000171b7984ULL, 0x000ea80000000800ULL,
0x01820000171c7984ULL, 0x0006620000000800ULL, 0x000000431b00720bULL, 0x004fe20003f1d000ULL,
0x000201227f007947ULL, 0x000fd8000b800000ULL, 0x00000000001d7806ULL, 0x008fc800000e0100ULL,
0x0000ffff1d1f7812ULL, 0x000fe2000780c0ffULL, 0x0000045000007945ULL, 0x000fe20003800000ULL,
0x00000001ff247424ULL, 0x000fe400078e00ffULL, 0x000000ffff507224ULL, 0x000fd200078e0043ULL,
0x0000041000008947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x000fe40003f05270ULL,
0x000000431b00720bULL, 0x000fe20003f54000ULL, 0x000200f27f007947ULL, 0x000fd8000b800000ULL,
0x00000000001d7806ULL, 0x000fc400010e0100ULL, 0x0000001b43507209ULL, 0x000fe20007810000ULL,
0x0000035000017945ULL, 0x000fe20003800000ULL, 0x000099101d1e7816ULL, 0x000fc600000000ffULL,
0x0184005017008388ULL, 0x0005e20000000800ULL, 0x000000ff1e00720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x80000050431e7221ULL, 0x004fe20000010000ULL,
0x000000ff1dff7812ULL, 0x000fe2000780c0ffULL, 0x0000017000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b1e1e7820ULL, 0x000fcc0000410000ULL, 0x0000001e001e7308ULL, 0x000ea80000000800ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff477819ULL, 0x000fe20000011603ULL,
0x000200627f007947ULL, 0x000fea000b800000ULL, 0x00001f471e477589ULL, 0x0044e400000e0000ULL,
0x0000004738387220ULL, 0x088fe40000410000ULL, 0x0000004739397220ULL, 0x080fe40000410000ULL,
0x0000004734347220ULL, 0x080fe40000410000ULL, 0x0000004735357220ULL, 0x000fc40000410000ULL,
0x0000004730307220ULL, 0x080fe40000410000ULL, 0x0000004731317220ULL, 0x080fe40000410000ULL,
0x000000472c2c7220ULL, 0x080fe40000410000ULL, 0x000000472d2d7220ULL, 0x080fe40000410000ULL,
0x0000004728287220ULL, 0x080fe40000410000ULL, 0x0000004729297220ULL, 0x000fc40000410000ULL,
0x0000004708087220ULL, 0x080fe40000410000ULL, 0x0000004709097220ULL, 0x080fe40000410000ULL,
0x0000004704047220ULL, 0x080fe40000410000ULL, 0x0000004705057220ULL, 0x080fe40000410000ULL,
0x0000004720207220ULL, 0x080fe40000410000ULL, 0x0000004721217220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff001dff7812ULL, 0x000fe2000780c0ffULL,
0x0000001e11117220ULL, 0x004fd80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000803477811ULL, 0x000fe200078ff0ffULL, 0x0001ff627f007947ULL, 0x000fea000b800000ULL,
0x00001f471e477589ULL, 0x0004e400000e0000ULL, 0x000000473a3a7220ULL, 0x088fe40000410000ULL,
0x000000473b3b7220ULL, 0x080fe40000410000ULL, 0x0000004736367220ULL, 0x080fe40000410000ULL,
0x0000004737377220ULL, 0x080fe40000410000ULL, 0x0000004732327220ULL, 0x080fe40000410000ULL,
0x0000004733337220ULL, 0x000fc40000410000ULL, 0x000000472e2e7220ULL, 0x080fe40000410000ULL,
0x000000472f2f7220ULL, 0x080fe40000410000ULL, 0x000000472a2a7220ULL, 0x080fe40000410000ULL,
0x000000472b2b7220ULL, 0x080fe40000410000ULL, 0x000000470a0a7220ULL, 0x080fe40000410000ULL,
0x000000470b0b7220ULL, 0x000fc40000410000ULL, 0x0000004706067220ULL, 0x080fe40000410000ULL,
0x0000004707077220ULL, 0x080fe40000410000ULL, 0x0000004722227220ULL, 0x080fe40000410000ULL,
0x0000004723237220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff1fff7812ULL, 0x000fda000780601dULL, 0x800000501b1b0221ULL, 0x000fe20000010000ULL,
0x00007610ff240816ULL, 0x000fc60000000024ULL, 0x3fb8aa3b1b1b0820ULL, 0x000fc80000410000ULL,
0x0000001b00180308ULL, 0x000ea40000000800ULL, 0x000000181c1c0220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000111c117221ULL, 0x002fc40000010000ULL,
0x00000000001c7805ULL, 0x000fca0000015200ULL, 0x0186ac00ff1b7984ULL, 0x000e640000000800ULL,
0x800000001bff7812ULL, 0x002fe40007804841ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff257224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000001e7805ULL, 0x000fcc0000015200ULL,
0x0000001e1c1e7210ULL, 0x000fca0007f1e1ffULL, 0x000000011f1f7824ULL, 0x000fe200000e0e1dULL,
0x003d09001e00780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401e00780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1b7819ULL, 0x000fc8000001141fULL, 0x0000001e1b1b7211ULL, 0x000fca00078110ffULL,
0x000000ffff1e7224ULL, 0x000fca00000e061fULL, 0x000000021b1b7819ULL, 0x000fc8000000121eULL,
0x0000001b0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000125257810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0186ac00ff1b7984ULL, 0x000e640000000800ULL, 0x800000001bff7812ULL, 0x002fe40007804841ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009910241b7816ULL, 0x000fe200000000ffULL,
0x0000017000007945ULL, 0x000fe60003800000ULL, 0x000000ff1b00720cULL, 0x000fda0003f45270ULL,
0x0000014000002947ULL, 0x000fea0003800000ULL, 0x00000018ff19723eULL, 0x000fe400000010ffULL,
0x00000002ff1b7819ULL, 0x000fe40000011603ULL, 0x00005410195e7816ULL, 0x000fe20000000019ULL,
0x0001fb827f007947ULL, 0x000fea000b800000ULL, 0x00001f1b5e197589ULL, 0x0002a400000e0000ULL,
0x000000081b1a7810ULL, 0x000fe20007ffe0ffULL, 0x0001fbc27f007947ULL, 0x000fea000b800000ULL,
0x00001f1a5e1a7589ULL, 0x00066400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000101b477810ULL, 0x000fe20007ffe0ffULL, 0x0000001fff457424ULL, 0x000fe200078e00ffULL,
0x0000283000447802ULL, 0x000fe20000000f00ULL, 0xffffffffff467424ULL, 0x000fc400078e00ffULL,
0x00020cf000007944ULL, 0x00efea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000181b477810ULL, 0x000fe20007ffe0ffULL, 0x0000001fff457424ULL, 0x000fe200078e00ffULL,
0x0000289000447802ULL, 0x000fe20000000f00ULL, 0xffffffffff467424ULL, 0x004fc400078e00ffULL,
0x00020c9000007944ULL, 0x00afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000803567812ULL, 0x000fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000004ff1b7819ULL, 0x002fc40000011603ULL, 0x0000000756567812ULL, 0x000fe400078ef803ULL,
0x00000002021f7811ULL, 0x040fe200078e10ffULL, 0x0000000402587824ULL, 0x100fe200078e021bULL,
0x0000001056247812ULL, 0x040fe200078efcffULL, 0x00000010561d7824ULL, 0x040fe400078e00ffULL,
0x00000001561c7824ULL, 0x000fe200078e0258ULL, 0x0000001f24597210ULL, 0x000fe20007ffe01bULL,
0x000000011b577824ULL, 0x000fe400078e021fULL, 0x00000010561e7824ULL, 0x040fe200078e00ffULL,
0xfffffff01d1c7812ULL, 0x000fe200078ee21cULL, 0x00000001561d7824ULL, 0x000fc400078e0257ULL,
0x00000001585a7824ULL, 0x000fe200078e0224ULL, 0x000140001c1c7811ULL, 0x000fe200078e20ffULL,
0x00000010241f7824ULL, 0x000fe200078e00ffULL, 0xfffffff01e1d7812ULL, 0x000fe200078ee21dULL,
0x00000010241e7824ULL, 0x000fe400078e00ffULL, 0x000000001c44783bULL, 0x004e620000004200ULL,
0x000140001d1d7811ULL, 0x000fe400078e20ffULL, 0xfffffff01e5a7812ULL, 0x000fe400078ee25aULL,
0xfffffff01f597812ULL, 0x000fe200078ee259ULL, 0x000000001d3c783bULL, 0x000ea20000004200ULL,
0x000140005a1e7811ULL, 0x000fc400078e20ffULL, 0x00014000591f7811ULL, 0x000fc600078e20ffULL,
0x000000001e24783bULL, 0x000f280000004200ULL, 0x000000001f40783bULL, 0x000ee20000004200ULL,
0x00000100444b7824ULL, 0x002fe200078e00ffULL, 0x0000004400947306ULL, 0x000fe20000009400ULL,
0x00000018ff9b7819ULL, 0x000fe40000011444ULL, 0x00000018ff997819ULL, 0x000fe40000011445ULL,
0x00000018ff4b7819ULL, 0x000fc4000001144bULL, 0x00000018ff8a7819ULL, 0x000fe20000011447ULL,
0x0000004400d27306ULL, 0x000e620000005400ULL, 0x00000018ff4a7819ULL, 0x004fe4000001143cULL,
0x00000018ff8d7819ULL, 0x000fe40000011446ULL, 0x00000018ff4d7819ULL, 0x000fe4000001143eULL,
0x00000018ff7b7819ULL, 0x010fe20000011424ULL, 0x0000004b00d47306ULL, 0x000fe20000209400ULL,
0x00000018ff497819ULL, 0x000fc4000001143dULL, 0x00000018ff727819ULL, 0x000fe4000001143fULL,
0x00000018ff737819ULL, 0x000fe40000011425ULL, 0x00000018ff657819ULL, 0x008fe20000011440ULL,
0x0000004b00d37306ULL, 0x000ea20000205400ULL, 0x000000d29400720bULL, 0x002fe40003fdd000ULL,
0x00000018ff6f7819ULL, 0x000fe40000011426ULL, 0x00000018ff667819ULL, 0x000fc40000011427ULL,
0x00000018ff607819ULL, 0x000fe20000011441ULL, 0x0000004400a07306ULL, 0x0002e2000000d400ULL,
0x00000018ff5f7819ULL, 0x000fe40000011442ULL, 0x00000018ff5d7819ULL, 0x000fca0000011443ULL,
0x0000004b00ac7306ULL, 0x0008e2000020d400ULL, 0x0001000044447824ULL, 0x002fe200078e00ffULL,
0x000000d3d400720bULL, 0x004fc80003f1d000ULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x00000045009f7306ULL, 0x000fe20000009400ULL, 0x00000100454b7824ULL, 0x010fe200078e00ffULL,
0x00000001a0a06812ULL, 0x008fc800078efcffULL, 0x00000018ff4b7819ULL, 0x000fe4000001144bULL,
0x0000004500d17306ULL, 0x000e620000005400ULL, 0x00000001acac0812ULL, 0x000fce00078efcffULL,
0x00000045009d7306ULL, 0x0004f0000000d400ULL, 0x0000009b00767306ULL, 0x000fe20000209400ULL,
0x0001000045457824ULL, 0x004fe200078e00ffULL, 0x000000d19f00720bULL, 0x002fc80003f1d000ULL,
0x00000018ff457819ULL, 0x000fe40000011445ULL, 0x0000009b00ce7306ULL, 0x000e6e0000205400ULL,
0x000000019d9d0812ULL, 0x008fe200078efcffULL, 0x0000004400d67306ULL, 0x000ff00000209400ULL,
0x0000004400d57306ULL, 0x000ea20000205400ULL, 0x000000ce7600720bULL, 0x002fce0003fbd000ULL,
0x00000044009e7306ULL, 0x0002f0000020d400ULL, 0x0000004500d97306ULL, 0x000fe20000209400ULL,
0x0000010046447824ULL, 0x002fe200078e00ffULL, 0x000000d5d600720bULL, 0x004fc80003f7d000ULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x0000004500da7306ULL, 0x000e6e0000205400ULL,
0x000000019e9e3812ULL, 0x008fe200078efcffULL, 0x00000045009c7306ULL, 0x0004f0000020d400ULL,
0x0000004b00d77306ULL, 0x000fe20000209400ULL, 0x0000010047457824ULL, 0x004fe200078e00ffULL,
0x000000dad900720bULL, 0x002fc80003fdd000ULL, 0x00000018ff457819ULL, 0x000fe40000011445ULL,
0x0000004b00d87306ULL, 0x000e6e0000205400ULL, 0x000000019c9c6812ULL, 0x008fe200078efcffULL,
0x0000009b009b7306ULL, 0x000eb0000020d400ULL, 0x0000004400db7306ULL, 0x000fe20000209400ULL,
0x000000d8d700720bULL, 0x002fce0003f9d000ULL, 0x0000004400dc7306ULL, 0x000e620000205400ULL,
0x000000019b9b5812ULL, 0x004fce00078efcffULL, 0x0000004700b67306ULL, 0x000ff00000009400ULL,
0x0000004700ca7306ULL, 0x000ea20000005400ULL, 0x000000dcdb00720bULL, 0x002fce0003fbd000ULL,
0x0000004700907306ULL, 0x0003f0000000d400ULL, 0x0000004400957306ULL, 0x000722000020d400ULL,
0x0001000047477824ULL, 0x002fe200078e00ffULL, 0x000000cab600720bULL, 0x004fc80003fdd000ULL,
0x00000018ff477819ULL, 0x000fe40000011447ULL, 0x0000004500dd7306ULL, 0x000fe20000209400ULL,
0x000001003c447824ULL, 0x008fca00078e00ffULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x0000004500de7306ULL, 0x000e620000205400ULL, 0x0000000195955812ULL, 0x010fe400078efcffULL,
0x0000000190906812ULL, 0x000fca00078efcffULL, 0x0000003c00c47306ULL, 0x000ff00000009400ULL,
0x0000003c00c87306ULL, 0x000fe20000005400ULL, 0x000000dedd00720bULL, 0x002fce0003f1d000ULL,
0x0000003c00887306ULL, 0x0003f0000000d400ULL, 0x0000009900cf7306ULL, 0x000fe20000209400ULL,
0x000100003c3c7824ULL, 0x002fca00078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000009900d07306ULL, 0x000e700000205400ULL, 0x0000004b00ab7306ULL, 0x000eb0000020d400ULL,
0x0000004600cd7306ULL, 0x000fe20000009400ULL, 0x000000d0cf00720bULL, 0x002fce0003f7d000ULL,
0x0000004600af7306ULL, 0x000e620000005400ULL, 0x00000001abab4812ULL, 0x004fce00078efcffULL,
0x0000004600937306ULL, 0x0004f0000000d400ULL, 0x0000004700e17306ULL, 0x000fe20000209400ULL,
0x0001000046467824ULL, 0x004fe200078e00ffULL, 0x000000afcd00720bULL, 0x002fc80003f9d000ULL,
0x00000018ff467819ULL, 0x000fe40000011446ULL, 0x0000004700e27306ULL, 0x000e6e0000205400ULL,
0x0000000193934812ULL, 0x008fe200078efcffULL, 0x00000047008b7306ULL, 0x000eb0000020d400ULL,
0x0000008d006e7306ULL, 0x000fe20000209400ULL, 0x000000e2e100720bULL, 0x002fce0003f9d000ULL,
0x0000008d00cb7306ULL, 0x000e6c0000205400ULL, 0x000000018b8b4812ULL, 0x004fe400078efcffULL,
0x0000004400e37306ULL, 0x000ff00000209400ULL, 0x0000004400e47306ULL, 0x000ea20000205400ULL,
0x000000cb6e00720bULL, 0x002fce0003fbd000ULL, 0x0000004400477306ULL, 0x000e70000020d400ULL,
0x0000003c00e97306ULL, 0x000fe20000209400ULL, 0x000000e4e300720bULL, 0x004fce0003fdd000ULL,
0x0000003c00e87306ULL, 0x000fec0000205400ULL, 0x0000000147476812ULL, 0x002fe400078efcffULL,
0x0000003c00447306ULL, 0x0003f0000020d400ULL, 0x0000003e00547306ULL, 0x000fe20000009400ULL,
0x000001003e3c7824ULL, 0x002fca00078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000003e00557306ULL, 0x000ff00000005400ULL, 0x0000003e00487306ULL, 0x0003f0000000d400ULL,
0x0000004500967306ULL, 0x0004e2000020d400ULL, 0x000100003e3e7824ULL, 0x002fca00078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x0000008a00cc7306ULL, 0x000fe20000209400ULL,
0x000001003d457824ULL, 0x004fca00078e00ffULL, 0x00000018ff457819ULL, 0x000fe40000011445ULL,
0x0000008a00c97306ULL, 0x000e620000205400ULL, 0x0000000196960812ULL, 0x008fce00078efcffULL,
0x0000009900997306ULL, 0x000eb0000020d400ULL, 0x0000004600df7306ULL, 0x000fe20000209400ULL,
0x000000c9cc00720bULL, 0x002fce0003f1d000ULL, 0x0000004600e07306ULL, 0x000e620000205400ULL,
0x0000000199993812ULL, 0x004fce00078efcffULL, 0x0000003e00b87306ULL, 0x000ff00000209400ULL,
0x0000003e00b57306ULL, 0x000fe20000205400ULL, 0x000000e0df00720bULL, 0x002fce0003f7d000ULL,
0x0000003e00837306ULL, 0x0003f0000020d400ULL, 0x0000008d008d7306ULL, 0x000ea2000020d400ULL,
0x00000100243e7824ULL, 0x002fca00078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x0000002400a37306ULL, 0x000ff00000009400ULL, 0x0000002400a77306ULL, 0x000fe20000005400ULL,
0x000000018d8d5812ULL, 0x004fce00078efcffULL, 0x00000024006d7306ULL, 0x0003f0000000d400ULL,
0x0000004500e67306ULL, 0x000fe20000209400ULL, 0x0001000024247824ULL, 0x002fca00078e00ffULL,
0x00000018ff247819ULL, 0x000fe40000011424ULL, 0x0000004500e57306ULL, 0x000e700000205400ULL,
0x0000008a008a7306ULL, 0x000eb0000020d400ULL, 0x0000003d00707306ULL, 0x000fe20000009400ULL,
0x000000e5e600720bULL, 0x002fce0003fbd000ULL, 0x0000003d00c67306ULL, 0x000e620000005400ULL,
0x000000018a8a0812ULL, 0x004fe400078efcffULL, 0x000000555400720bULL, 0x000fe40003f1d000ULL,
0x0000000703547812ULL, 0x000fc600078ec0ffULL, 0x0000003d00877306ULL, 0x0004e2000000d400ULL,
0x0000000854547812ULL, 0x000fca00078ef803ULL, 0x000000011b557824ULL, 0x000fe400078e0254ULL,
0x00000046008f7306ULL, 0x000f22000020d400ULL, 0x000100003d3d7824ULL, 0x004fe200078e00ffULL,
0x000000c67000720bULL, 0x002fe40003f9d000ULL, 0x0000000148480812ULL, 0x000fe400078efcffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000002400c27306ULL, 0x000fee0000209400ULL,
0x0000000187874812ULL, 0x008fe200078efcffULL, 0x0000002400c37306ULL, 0x000fe20000205400ULL,
0x000000018f8f3812ULL, 0x010fc400078efcffULL, 0x000000c8c400720bULL, 0x000fca0003f7d000ULL,
0x00000024007f7306ULL, 0x0003f0000020d400ULL, 0x0000004500897306ULL, 0x000ea2000020d400ULL,
0x0000010026247824ULL, 0x002fe200078e00ffULL, 0x0000000188883812ULL, 0x000fc400078efcffULL,
0x000000e8e900720bULL, 0x000fe40003f7d000ULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x0000003d00ec7306ULL, 0x000fe20000209400ULL, 0x000000884788723eULL, 0x000fce00000010ffULL,
0x0000003d00eb7306ULL, 0x000e620000205400ULL, 0x0000000189895812ULL, 0x004fe400078efcffULL,
0x0000000144443812ULL, 0x000fe400078efcffULL, 0x000000878989723eULL, 0x000fc600000010ffULL,
0x0000003d004b7306ULL, 0x0004f0000020d400ULL, 0x0000002400ad7306ULL, 0x000fe20000209400ULL,
0x000001003f3d7824ULL, 0x004fe200078e00ffULL, 0x000000ebec00720bULL, 0x002fc80003fbd000ULL,
0x00000018ff827819ULL, 0x000fe4000001143dULL, 0x0000002400ae7306ULL, 0x000fee0000205400ULL,
0x000000014b4b5812ULL, 0x008fe200078efcffULL, 0x0000002400787306ULL, 0x0003f0000020d400ULL,
0x0000004a00c57306ULL, 0x000fe20000209400ULL, 0x0000010040247824ULL, 0x002fca00078e00ffULL,
0x00000018ff247819ULL, 0x000fe40000011424ULL, 0x0000004a00c77306ULL, 0x000e700000205400ULL,
0x0000003c00ea7306ULL, 0x000ff00000209400ULL, 0x0000003c00e77306ULL, 0x000fe20000205400ULL,
0x000000c7c500720bULL, 0x002fce0003fdd000ULL, 0x0000003c00847306ULL, 0x000ff0000020d400ULL,
0x00000082003d7306ULL, 0x000ff00000209400ULL, 0x00000082003c7306ULL, 0x000e700000205400ULL,
0x0000003e00bc7306ULL, 0x000ff00000209400ULL, 0x0000003e00bd7306ULL, 0x000fe20000205400ULL,
0x0000003c3d00720bULL, 0x002fce0003fbd000ULL, 0x0000003e007e7306ULL, 0x0003f0000020d400ULL,
0x0000002400c47306ULL, 0x000fe20000209400ULL, 0x00000100253e7824ULL, 0x002fca00078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x0000002400c67306ULL, 0x000ff00000205400ULL,
0x0000002400707306ULL, 0x0003f0000020d400ULL, 0x0000003f00b07306ULL, 0x000fe20000009400ULL,
0x0000000854247824ULL, 0x002fca00078e00ffULL, 0xfffffff824247812ULL, 0x000fe400078ee255ULL,
0x0000003f009a7306ULL, 0x000e700000005400ULL, 0x0000003f004c7306ULL, 0x0004f0000000d400ULL,
0x0000004a004a7306ULL, 0x000f22000020d400ULL, 0x000100003f3f7824ULL, 0x004fe200078e00ffULL,
0x0000009ab000720bULL, 0x002fc80003f7d000ULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x0000003e00c17306ULL, 0x000fee0000209400ULL, 0x000000014c4c3812ULL, 0x008fe200078efcffULL,
0x0000003e00c07306ULL, 0x000e620000205400ULL, 0x000000014a4a6812ULL, 0x010fc400078efcffULL,
0x000000e7ea00720bULL, 0x000fe40003fdd000ULL, 0x000000a7a300720bULL, 0x000fe20003f7d000ULL,
0x0000010042a77824ULL, 0x000fe200078e00ffULL, 0x000000444a4a723eULL, 0x000fe200000010ffULL,
0x0000003e00807306ULL, 0x0004e2000020d400ULL, 0x0001000043a37824ULL, 0x000fe400078e00ffULL,
0x00000018ffa77819ULL, 0x000fc600000114a7ULL, 0x00000018ffa37819ULL, 0x000fe400000114a3ULL,
0x0000003f00be7306ULL, 0x000fe20000209400ULL, 0x00012000243e7811ULL, 0x004fe400078e20ffULL,
0x0000000184846812ULL, 0x000fe400078efcffULL, 0x000000016d6d3812ULL, 0x000fe400078efcffULL,
0x000000c0c100720bULL, 0x002fe20003f7d000ULL, 0x0000003f00bf7306ULL, 0x000fe20000205400ULL,
0x000000488484723eULL, 0x000fce00000010ffULL, 0x0000003f00817306ULL, 0x0003e8000020d400ULL,
0x0000000180803812ULL, 0x008fc800078efcffULL, 0x0000004900b37306ULL, 0x000fe20000209400ULL,
0x000000003e3c783bULL, 0x002e6e0000000200ULL, 0x0000004900b47306ULL, 0x000eb00000205400ULL,
0x0000004d00a87306ULL, 0x000ff00000209400ULL, 0x0000004d00a47306ULL, 0x000ee20000205400ULL,
0x000000b4b300720bULL, 0x004fce0003f9d000ULL, 0x0000002500a27306ULL, 0x000ff00000009400ULL,
0x0000002500a17306ULL, 0x000fe20000005400ULL, 0x000000a4a800720bULL, 0x008fe20003fdd000ULL,
0x000000193c3ca231ULL, 0x082fe200003400ffULL, 0x0001000042a87824ULL, 0x000fe200078e00ffULL,
0x000000193e3ea231ULL, 0x000fc400003400ffULL, 0x0000001a3d3da231ULL, 0x080fe400003400ffULL,
0x00000025006c7306ULL, 0x0003e2000000d400ULL, 0x0000001a3f3fa231ULL, 0x000fe200003400ffULL,
0x00000018ffa87819ULL, 0x000fcc00000114a8ULL, 0x0000004900497306ULL, 0x000ea2000020d400ULL,
0x0001000025257824ULL, 0x002fca00078e00ffULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x0000004d004d7306ULL, 0x000e70000020d400ULL, 0x0000007200a67306ULL, 0x000fe20000209400ULL,
0x0000000149494812ULL, 0x004fc400078efcffULL, 0x000000b5b800720bULL, 0x000fe40003f9d000ULL,
0x0000004b494b723eULL, 0x000fc600000010ffULL, 0x0000007200a97306ULL, 0x000ea20000205400ULL,
0x000000014d4d6812ULL, 0x002fe400078efcffULL, 0x000000a1a200720bULL, 0x000fe20003fdd000ULL,
0x0000004a3c48723cULL, 0x000be80000041808ULL, 0x0000002500b97306ULL, 0x000fe20000209400ULL,
0x0000000183834812ULL, 0x000fe400078efcffULL, 0x000000bdbc00720bULL, 0x000fc40003f9d000ULL,
0x000000834d08723eULL, 0x020fc600000010ffULL, 0x0000002500ba7306ULL, 0x000fe20000205400ULL,
0x000000a9a600720bULL, 0x004fe20003f1d000ULL, 0x0000010043a97824ULL, 0x000fe200078e00ffULL,
0x000000016c6c6812ULL, 0x000fe400078efcffULL, 0x000000aead00720bULL, 0x000fe40003fdd000ULL,
0x00000018ffa97819ULL, 0x000fe200000114a9ULL, 0x0000002500777306ULL, 0x0003e2000020d400ULL,
0x000000017e7e4812ULL, 0x000fce00078efcffULL, 0x00000040008e7306ULL, 0x000fe20000009400ULL,
0x0000010027257824ULL, 0x002fe200078e00ffULL, 0x0000000178786812ULL, 0x000fc800078efcffULL,
0x00000018ff257819ULL, 0x000fe40000011425ULL, 0x00000040008c7306ULL, 0x000ff00000005400ULL,
0x0000004000617306ULL, 0x0003f0000000d400ULL, 0x0000002600aa7306ULL, 0x000fe20000009400ULL,
0x0001000040407824ULL, 0x002fca00078e00ffULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x0000002600a57306ULL, 0x000ff00000005400ULL, 0x00000026006b7306ULL, 0x0003f0000000d400ULL,
0x0000002700927306ULL, 0x000fe20000009400ULL, 0x0001000026267824ULL, 0x002fca00078e00ffULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x0000002700917306ULL, 0x000e700000005400ULL,
0x0000002700627306ULL, 0x0004f0000000d400ULL, 0x0000002500977306ULL, 0x000fe20000209400ULL,
0x0001000027277824ULL, 0x004fe200078e00ffULL, 0x000000919200720bULL, 0x002fc80003f7d000ULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x0000002500987306ULL, 0x000fee0000205400ULL,
0x0000000162623812ULL, 0x008fe200078efcffULL, 0x0000002500717306ULL, 0x0003f0000020d400ULL,
0x0000007200727306ULL, 0x000ea2000020d400ULL, 0x0000010041257824ULL, 0x002fce00078e00ffULL,
0x00000041004e7306ULL, 0x000ff00000009400ULL, 0x00000041004f7306ULL, 0x000fe20000005400ULL,
0x0000000172720812ULL, 0x004fe400078efcffULL, 0x000000c3c200720bULL, 0x000fca0003f1d000ULL,
0x00000041005e7306ULL, 0x0003f0000000d400ULL, 0x0000008200827306ULL, 0x000ea2000020d400ULL,
0x0001000041417824ULL, 0x002fe200078e00ffULL, 0x000000017f7f0812ULL, 0x000fc800078efcffULL,
0x00000018ffa27819ULL, 0x000fe40000011441ULL, 0x0000004000a47306ULL, 0x000fe20000209400ULL,
0x0000009dab41723eULL, 0x000fce00000010ffULL, 0x0000004000a67306ULL, 0x000fe20000205400ULL,
0x0000000182825812ULL, 0x004fe400078efcffULL, 0x000000bfbe00720bULL, 0x000fca0003fbd000ULL,
0x0000004000a17306ULL, 0x0003f0000020d400ULL, 0x0000002600947306ULL, 0x000fe20000209400ULL,
0x000000a0ac40723eULL, 0x002fe400000010ffULL, 0x0000000181815812ULL, 0x000fc400078efcffULL,
0x000000a5aa00720bULL, 0x000fe40003fbd000ULL, 0x000000817209723eULL, 0x000fe200000010ffULL,
0x00000026009f7306ULL, 0x000e700000205400ULL, 0x0000002600767306ULL, 0x0004e4000020d400ULL,
0x000000016b6b5812ULL, 0x000fcc00078efcffULL, 0x0000002700af7306ULL, 0x000fe20000209400ULL,
0x00000018ff267819ULL, 0x004fe40000011425ULL, 0x0000000255257810ULL, 0x000fe40007ffe0ffULL,
0x0000009f9400720bULL, 0x002fc60003fdd000ULL, 0x0000002700b67306ULL, 0x000ff00000205400ULL,
0x00000027006e7306ULL, 0x0003e4000020d400ULL, 0x0000000176766812ULL, 0x008fc400078efcffULL,
0x000000c6c400720bULL, 0x000fc80003fdd000ULL, 0x0000004200797306ULL, 0x000fe20000009400ULL,
0x0000000854277824ULL, 0x002fca00078e00ffULL, 0xfffffff827257812ULL, 0x000fe400078ee225ULL,
0x00000042007a7306ULL, 0x000fe20000005400ULL, 0x0000009c9927723eULL, 0x000fe400000010ffULL,
0x0000000170706812ULL, 0x000fe400078efcffULL, 0x000000a6a400720bULL, 0x000fc60003fdd000ULL,
0x00000042005c7306ULL, 0x000ff0000000d400ULL, 0x0000004300637306ULL, 0x000fe40000009400ULL,
0x00000001a1a16812ULL, 0x000fcc00078efcffULL, 0x0000004300647306ULL, 0x000ff00000005400ULL,
0x00000043005b7306ULL, 0x0003f0000000d400ULL, 0x0000007b00bb7306ULL, 0x000fe20000209400ULL,
0x000000403c40723cULL, 0x002b6e0000041838ULL, 0x0000007b00b77306ULL, 0x000e620000205400ULL,
0x000000939538723eULL, 0x020fc400000010ffULL, 0x000000909639723eULL, 0x000fe400000010ffULL,
0x00012000253a7811ULL, 0x000fc600078e20ffULL, 0x0000007300b17306ULL, 0x000fe40000209400ULL,
0x000000383c30723cULL, 0x000be40000041830ULL, 0x000000003a38783bULL, 0x020ea80000000200ULL,
0x0000007300b27306ULL, 0x000ee20000205400ULL, 0x000000b7bb00720bULL, 0x002fce0003f9d000ULL,
0x0000006600857306ULL, 0x000ff00000209400ULL, 0x0000006600867306ULL, 0x000e620000205400ULL,
0x000000b2b100720bULL, 0x008fce0003f1d000ULL, 0x0000007b007b7306ULL, 0x000ef0000020d400ULL,
0x0000007300737306ULL, 0x000f22000020d400ULL, 0x000000868500720bULL, 0x002fe40003f7d000ULL,
0x0000004c8285723eULL, 0x000fe200000010ffULL, 0x000000193838a231ULL, 0x004fc400003400ffULL,
0x000000193a3aa231ULL, 0x000fe400003400ffULL, 0x0000006600667306ULL, 0x000e62000020d400ULL,
0x000000017b7b4812ULL, 0x008fe200078efcffULL, 0x0000001a3939a231ULL, 0x080fe200003400ffULL,
0x000000bab900720bULL, 0x000fe20003f9d000ULL, 0x0000001a3b3ba231ULL, 0x000fc800003400ffULL,
0x0000006f00457306ULL, 0x000fe20000209400ULL, 0x0000000173730812ULL, 0x010fe400078efcffULL,
0x000000989700720bULL, 0x000fca0003f1d000ULL, 0x0000006f00467306ULL, 0x000ea20000205400ULL,
0x0000000166663812ULL, 0x002fe400078efcffULL, 0x0000000177774812ULL, 0x000fe400078efcffULL,
0x0000008c8e00720bULL, 0x000fc60003f9d000ULL, 0x0000002600c57306ULL, 0x000fe20000209400ULL,
0x0000000171710812ULL, 0x000fe400078efcffULL, 0x000000b6af00720bULL, 0x000fca0003f1d000ULL,
0x0000002600b07306ULL, 0x000e620000205400ULL, 0x000000464500720bULL, 0x004fe40003fbd000ULL,
0x000000883c44723cULL, 0x000fe20000041828ULL, 0x0000000161614812ULL, 0x000fc800078efcffULL,
0x00000026009a7306ULL, 0x0005e2000020d400ULL, 0x000000016e6e0812ULL, 0x000fe400078efcffULL,
0x0000007a7900720bULL, 0x000fe40003f1d000ULL, 0x000000617070723eULL, 0x000fc600000010ffULL,
0x0000006f006f7306ULL, 0x000ee2000020d400ULL, 0x0000009e9b26723eULL, 0x004fe400000010ffULL,
0x000000b0c500720bULL, 0x002fca0003f7d000ULL, 0x000000a200a57306ULL, 0x000fe20000209400ULL,
0x000000263c34723cULL, 0x000b620000041834ULL, 0x000000015c5c0812ULL, 0x000fcc00078efcffULL,
0x000000a2009d7306ULL, 0x000e620000205400ULL, 0x0000008f8d26723eULL, 0x020fe400000010ffULL,
0x0000008b8a27723eULL, 0x000fe400000010ffULL, 0x000000016f6f5812ULL, 0x008fe400078efcffULL,
0x000000019a9a3812ULL, 0x000fe200078efcffULL, 0x00000065007c7306ULL, 0x000fe20000209400ULL,
0x0000004f4e00720bULL, 0x000fe20003fbd000ULL, 0x000000263c2c723cULL, 0x040f6c000004182cULL,
0x00000065007d7306ULL, 0x000ea20000205400ULL, 0x0000009da500720bULL, 0x002fe20003f7d000ULL,
0x000000843c4c723cULL, 0x000b680000041804ULL, 0x000000015e5e5812ULL, 0x000fc400078efcffULL,
0x000000a200997306ULL, 0x000e62000020d400ULL, 0x0000006d7e04723eULL, 0x020fe200000010ffULL,
0x000000083c3c723cULL, 0x000b620000041820ULL, 0x0000006c8005723eULL, 0x000fca00000010ffULL,
0x0000006000747306ULL, 0x000fe20000209400ULL, 0x0000007f7b08723eULL, 0x020fe200000010ffULL,
0x000000043804723cULL, 0x040f620000041840ULL, 0x000000777309723eULL, 0x000fe400000010ffULL,
0x0000007d7c00720bULL, 0x004fe40003f9d000ULL, 0x0000006b7820723eULL, 0x000fe200000010ffULL,
0x0000006000757306ULL, 0x000ea20000205400ULL, 0x0000000199993812ULL, 0x002fe200078efcffULL,
0x000000083808723cULL, 0x000f620000041834ULL, 0x000000627121723eULL, 0x000fc400000010ffULL,
0x0000005e9a71723eULL, 0x000fc600000010ffULL, 0x000000a700907306ULL, 0x000fe40000209400ULL,
0x000000203820723cULL, 0x000b6c0000041830ULL, 0x000000a7008a7306ULL, 0x000e620000205400ULL,
0x000000757400720bULL, 0x004fce0003fbd000ULL, 0x000000a900287306ULL, 0x000ff00000209400ULL,
0x000000a900297306ULL, 0x000ea20000205400ULL, 0x0000008a9000720bULL, 0x002fce0003fdd000ULL,
0x0000006500657306ULL, 0x000e70000020d400ULL, 0x0000006000607306ULL, 0x000ee2000020d400ULL,
0x000000292800720bULL, 0x004fe40003f7d000ULL, 0x000000766f28723eULL, 0x000fc400000010ffULL,
0x0000006e6629723eULL, 0x000fc600000010ffULL, 0x000000a700a77306ULL, 0x000ea2000020d400ULL,
0x0000000165654812ULL, 0x002fe400078efcffULL, 0x000000646300720bULL, 0x000fe20003f9d000ULL,
0x000000283828723cULL, 0x000b64000004182cULL, 0x000000a16530723eULL, 0x020fe400000010ffULL,
0x000000a900a97306ULL, 0x000e62000020d400ULL, 0x0000000160605812ULL, 0x008fc600078efcffULL,
0x00000070382c723cULL, 0x000b620000041844ULL, 0x000000996031723eULL, 0x000fc600000010ffULL,
0x0000005f00677306ULL, 0x000fe20000209400ULL, 0x00000001a7a76812ULL, 0x004fe400078efcffULL,
0x000000015b5b4812ULL, 0x000fe200078efcffULL, 0x000000303830723cULL, 0x000b680000041848ULL,
0x0000005f00697306ULL, 0x000ea20000205400ULL, 0x00000001a9a93812ULL, 0x002fc800078efcffULL,
0x0000005ba935723eULL, 0x000fc600000010ffULL, 0x0000005d006a7306ULL, 0x000ff00000209400ULL,
0x0000005d00687306ULL, 0x000e620000205400ULL, 0x000000696700720bULL, 0x004fce0003fbd000ULL,
0x000000a800267306ULL, 0x000ff00000209400ULL, 0x000000a800277306ULL, 0x000ea20000205400ULL,
0x000000686a00720bULL, 0x002fce0003fdd000ULL, 0x000000a300407306ULL, 0x000ff00000209400ULL,
0x000000a300347306ULL, 0x000e620000205400ULL, 0x000000272600720bULL, 0x004fce0003f1d000ULL,
0x0000005f005f7306ULL, 0x000eb0000020d400ULL, 0x0000005d005d7306ULL, 0x000ee2000020d400ULL,
0x000000344000720bULL, 0x002fe40003f7d000ULL, 0x0000005ca734723eULL, 0x000fca00000010ffULL,
0x000000a800a87306ULL, 0x000e62000020d400ULL, 0x000000015f5f5812ULL, 0x004fe200078efcffULL,
0x000000343834723cULL, 0x000b6c000004184cULL, 0x000000a300a37306ULL, 0x000ea2000020d400ULL,
0x000000015d5d6812ULL, 0x008fe400078efcffULL, 0x00000001a8a80812ULL, 0x002fc800078efcffULL,
0x000000a85f5c723eULL, 0x000fe400000010ffULL, 0x00000001a3a33812ULL, 0x004fc800078efcffULL,
0x000000a35d5d723eULL, 0x000fce00000010ffULL, 0x0000005c3838723cULL, 0x000b62000004183cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0186b800ff3e7f8cULL, 0x020e62000c80043fULL,
0x000000ffff417224ULL, 0x000fce00078e00ffULL, 0x0000000000267805ULL, 0x000fc40000015200ULL,
0x0186bc00ff3c7984ULL, 0x000ea40000000800ULL, 0x800000003cff7812ULL, 0x006fe4000780483fULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104100780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003c7805ULL, 0x000fcc0000015200ULL,
0x0000003c26407210ULL, 0x000fca0007f1e1ffULL, 0x000000013d3d7824ULL, 0x000fe200000e0e27ULL,
0x003d09004000780cULL, 0x000fc80003f06070ULL, 0x000000ff3d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404000780cULL, 0x000fc80003f06070ULL,
0x000000ff3d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3c7819ULL, 0x000fc8000001143dULL, 0x000000403c3c7211ULL, 0x000fca00078110ffULL,
0x000000ffff3d7224ULL, 0x000fca00000e063dULL, 0x000000023c3c7819ULL, 0x000fc8000000123dULL,
0x0000003c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000141417810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0186bc00ff3c7984ULL, 0x000e640000000800ULL, 0x800000003cff7812ULL, 0x002fe4000780483fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000040133c7811ULL, 0x000fe200078e40ffULL,
0x0000045000009947ULL, 0x000fea0003800000ULL, 0x000000010f277824ULL, 0x000fe200078e021bULL,
0x00000040003e7811ULL, 0x000fe400078e38ffULL, 0x000000021b427810ULL, 0x000fe20007ffe0ffULL,
0x0000000127267824ULL, 0x100fe200078e0203ULL, 0x000000041b487810ULL, 0x000fe20007ffe0ffULL,
0x0000001027467824ULL, 0x040fe200078e00ffULL, 0x000000f016457812ULL, 0x000fe200078ec0ffULL,
0x0000000127277824ULL, 0x000fe200078e023eULL, 0x000000061b4a7810ULL, 0x000fe20007ffe0ffULL,
0x000000010f3d7824ULL, 0x040fe200078e0242ULL, 0xfffffff046467812ULL, 0x000fe200078ee226ULL,
0x000000010f437824ULL, 0x000fe200078e0248ULL, 0x0000003c0c267217ULL, 0x000fe20007800000ULL,
0x000000013d3f7824ULL, 0x000fe200078e0203ULL, 0x0000002751417210ULL, 0x000fe20007f1e0ffULL,
0x000000103d477824ULL, 0x000fe200078e00ffULL, 0x0001400046467811ULL, 0x000fe200078e20ffULL,
0x0000000126267824ULL, 0x000fc400078e0a3cULL, 0x000000013d277824ULL, 0x000fe200078e023eULL,
0xfffffff047477812ULL, 0x000fe200078ee23fULL, 0x0000000143447824ULL, 0x000fe200078e0203ULL,
0x000000260f267217ULL, 0x000fe20007800000ULL, 0x0000001043497824ULL, 0x000fe200078e00ffULL,
0x0000002751277210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff407224ULL, 0x000fe200000e06ffULL,
0x00005e00413f7a11ULL, 0x000fe200078040ffULL, 0x00000001263d7824ULL, 0x000fe200078e0a0fULL,
0xfffffff049497812ULL, 0x000fe200078ee244ULL, 0x0000000143267824ULL, 0x000fe200078e023eULL,
0x00005f0041417a11ULL, 0x000fe200000f4440ULL, 0x000000ffff447224ULL, 0x000fe200018e06ffULL,
0x00005e0027407a11ULL, 0x000fe200078640ffULL, 0x000000010f4b7824ULL, 0x000fe200078e024aULL,
0x0000003d1b00720cULL, 0x000fc40003f86070ULL, 0x0000002651437210ULL, 0x000fe20007fbe0ffULL,
0x000000014b3e7824ULL, 0x000fe200078e023eULL, 0x00005f0027447a11ULL, 0x000fe400018f4444ULL,
0x000000453f267210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff3f7224ULL, 0x000fe200028e06ffULL,
0x0000003d4200720cULL, 0x080fe40003f06070ULL, 0x00005e0043427a11ULL, 0x000fe200078a40ffULL,
0x000000ffff277224ULL, 0x000fe200018e0641ULL, 0x0000003d4800720cULL, 0x000fc40003f66070ULL,
0x00005f0043437a11ULL, 0x000fe400028f443fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026467faeULL, 0x0003e2000e101c46ULL, 0x0000003e513f7210ULL, 0x000fe40007f9e0ffULL,
0x00000045423e7210ULL, 0x080fe40007fde0ffULL, 0x0001400047477811ULL, 0x000fe200078e20ffULL,
0x000000ffff417224ULL, 0x000fe200020e06ffULL, 0x0001400049497811ULL, 0x000fe400078e20ffULL,
0x0000004540267210ULL, 0x002fe20007fbe0ffULL, 0x000000014b467824ULL, 0x000fe200078e0203ULL,
0x00005e003f407a11ULL, 0x000fe200078840ffULL, 0x000000104b4b7824ULL, 0x000fc400078e00ffULL,
0x000000ffff277224ULL, 0x000fe200028e0644ULL, 0x0000003d4a00720cULL, 0x000fe40003fa6070ULL,
0x00005f003f3d7a11ULL, 0x000fe200020f4441ULL, 0x000000ffff3f7224ULL, 0x000fe200030e0643ULL,
0x0000004540407210ULL, 0x000fe20007f9e0ffULL, 0x0000000026477faeULL, 0x0003e2000c101c46ULL,
0xfffffff04b467812ULL, 0x000fc600078ee246ULL, 0x000000ffff417224ULL, 0x000fe200020e063dULL,
0x0001400046467811ULL, 0x000fe200078e20ffULL, 0x000000003e497faeULL, 0x0003e8000d901c46ULL,
0x0000000040467faeULL, 0x0003e2000e901c46ULL, 0x0000039000007947ULL, 0x000fea0003800000ULL,
0x0000004000417811ULL, 0x000fe200078e38ffULL, 0x000000010f407824ULL, 0x000fe200078e021bULL,
0x000000f0164a7812ULL, 0x000fc600078ec0ffULL, 0x0000000140277824ULL, 0x040fe200078e0241ULL,
0x0000000240267810ULL, 0x040fe20007ffe0ffULL, 0x00000001403d7824ULL, 0x040fe200078e0203ULL,
0x00000004403e7810ULL, 0x040fe20007ffe0ffULL, 0x00000010404b7824ULL, 0x040fe200078e00ffULL,
0x0000000640407810ULL, 0x000fe20007ffe0ffULL, 0x0000001026437824ULL, 0x040fe200078e00ffULL,
0x0000002751427210ULL, 0x000fe20007f1e0ffULL, 0x0000000126277824ULL, 0x040fe200078e0241ULL,
0xfffffff04b4b7812ULL, 0x000fe200078ee23dULL, 0x00000001263d7824ULL, 0x000fc400078e0203ULL,
0x000000013e267824ULL, 0x040fe200078e0241ULL, 0x000140004b4b7811ULL, 0x000fe200078e20ffULL,
0x000000013e3f7824ULL, 0x040fe200078e0203ULL, 0xfffffff0433d7812ULL, 0x000fe200078ee23dULL,
0x000000103e447824ULL, 0x000fe400078e00ffULL, 0x0000000140417824ULL, 0x040fe200078e0241ULL,
0x000140003d3d7811ULL, 0x000fe200078e20ffULL, 0x00000001403e7824ULL, 0x000fe200078e0203ULL,
0xfffffff0443f7812ULL, 0x000fe200078ee23fULL, 0x0000001040457824ULL, 0x000fe200078e00ffULL,
0x0000004151417210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff407224ULL, 0x000fe200000e06ffULL,
0x00005e0042487a11ULL, 0x000fc400078040ffULL, 0xfffffff045447812ULL, 0x000fe400078ee23eULL,
0x00005f0042497a11ULL, 0x000fe400000f4440ULL, 0x0000002751477210ULL, 0x040fe40007f1e0ffULL,
0x0000002651457210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff267224ULL, 0x000fe200020e06ffULL,
0x0000004a48427210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff437224ULL, 0x000fe200000e06ffULL,
0x00005e0047467a11ULL, 0x000fe200078040ffULL, 0x000000ffff277224ULL, 0x000fe200018e06ffULL,
0x00005e0041407a11ULL, 0x000fc400078840ffULL, 0x00005e00453e7a11ULL, 0x000fe400078640ffULL,
0x00005f0047477a11ULL, 0x000fe200000f4443ULL, 0x000000ffff437224ULL, 0x000fe200028e0649ULL,
0x00005f0041417a11ULL, 0x000fe400020f4426ULL, 0x00005f0045457a11ULL, 0x000fe400018f4427ULL,
0x0000004a46267210ULL, 0x080fe20007f1e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000424b7faeULL, 0x0003e2000b901c46ULL, 0x0000004a3e3e7210ULL, 0x000fc40007f7e0ffULL,
0x0000004a40407210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff277224ULL, 0x000fe200000e0647ULL,
0x0001400044447811ULL, 0x000fc600078e20ffULL, 0x000000ffff417224ULL, 0x000fe200020e0641ULL,
0x00000000263d7faeULL, 0x0005e2000b901c46ULL, 0x000140003f427811ULL, 0x002fe200078e20ffULL,
0x000000ffff3f7224ULL, 0x000fca00018e0645ULL, 0x000000003e427faeULL, 0x0005e8000b901c46ULL,
0x0000000040447faeULL, 0x0005e4000b901c46ULL, 0x0000000000007918ULL, 0x006fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0186a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0186a800ff267f8cULL, 0x000e64000c80043fULL,
0x000000ffff417224ULL, 0x002fc400078e0027ULL, 0x0000000000267805ULL, 0x000fca0000015200ULL,
0x0186b400ff3d7984ULL, 0x000e640000000800ULL, 0x800000003dff7812ULL, 0x002fc40007804853ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff407224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003e7805ULL, 0x000fcc0000015200ULL, 0x0000003e263e7210ULL, 0x000fca0007f1e1ffULL,
0x000000013f3f7824ULL, 0x000fe200000e0e27ULL, 0x003d09003e00780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403e00780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3d7819ULL, 0x000fc8000001143fULL,
0x0000003e3d3d7211ULL, 0x000fca00078110ffULL, 0x000000ffff3e7224ULL, 0x000fca00000e063fULL,
0x000000023d3d7819ULL, 0x000fc8000000123eULL, 0x0000003d0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000140407810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0186b400ff3d7984ULL, 0x000e640000000800ULL,
0x800000003dff7812ULL, 0x002fe40007804853ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000016000007945ULL, 0x000fe20003800000ULL, 0x0000014000002947ULL, 0x000fea0003800000ULL,
0x00000018ff19723eULL, 0x000fe400000010ffULL, 0x00000002ff267819ULL, 0x000fe40000011603ULL,
0x00005410195e7816ULL, 0x000fe20000000019ULL, 0x0001ce927f007947ULL, 0x000fea000b800000ULL,
0x00001f265e197589ULL, 0x0002a400000e0000ULL, 0x00000008261a7810ULL, 0x000fe20007ffe0ffULL,
0x0001ced27f007947ULL, 0x000fea000b800000ULL, 0x00001f1a5e1a7589ULL, 0x00066400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x0000001026477810ULL, 0x000fe20007ffe0ffULL,
0x0000001fff457424ULL, 0x000fe200078e00ffULL, 0x0000560000447802ULL, 0x000fe20000000f00ULL,
0xffffffffff467424ULL, 0x000fc400078e00ffULL, 0x0001df2000007944ULL, 0x00efea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x0000001826477810ULL, 0x000fe20007ffe0ffULL,
0x0000001fff457424ULL, 0x000fe200078e00ffULL, 0x0000566000447802ULL, 0x000fe20000000f00ULL,
0xffffffffff467424ULL, 0x004fc400078e00ffULL, 0x0001dec000007944ULL, 0x00afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000160005a277811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000156587824ULL, 0x000fe200078e0258ULL,
0x0001600059267811ULL, 0x002fc400078e20ffULL, 0x000000002744783bULL, 0x004e680000004200ULL,
0x00000000264c783bULL, 0x000ea20000004200ULL, 0x00000100443d7824ULL, 0x002fe200078e00ffULL,
0x0000004400b67306ULL, 0x000fe20000009400ULL, 0x00000100473e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff787819ULL, 0x000fe20000011444ULL, 0x000001004c3f7824ULL, 0x004fe200078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe2000001143dULL, 0x000001004d407824ULL, 0x000fe200078e00ffULL,
0x00000018ff3e7819ULL, 0x000fc4000001143eULL, 0x0000003d00b57306ULL, 0x000fe20000209400ULL,
0x00000018ff6f7819ULL, 0x000fe40000011445ULL, 0x00000018ff6a7819ULL, 0x000fe40000011446ULL,
0x00000018ff627819ULL, 0x000fe40000011447ULL, 0x00000018ff607819ULL, 0x000fe2000001144cULL,
0x0000003d00b47306ULL, 0x000fe20000205400ULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x00000018ff407819ULL, 0x000fc40000011440ULL, 0x00000018ff5e7819ULL, 0x008fe4000001144dULL,
0x00000018ff5c7819ULL, 0x000fe2000001144eULL, 0x0000003d007e7306ULL, 0x0003e2000020d400ULL,
0x00000018ff527819ULL, 0x000fce000001144fULL, 0x0000003e00907306ULL, 0x000fe20000209400ULL,
0x00000100453d7824ULL, 0x002fca00078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000003e008f7306ULL, 0x000ff00000205400ULL, 0x0000003e006c7306ULL, 0x0003f0000020d400ULL,
0x0000003d00af7306ULL, 0x000fe20000209400ULL, 0x00000010563e7824ULL, 0x002fca00078e00ffULL,
0xfffffff03e3e7812ULL, 0x000fe400078ee258ULL, 0x0000003d00b07306ULL, 0x000fe40000205400ULL,
0x000160003e3e7811ULL, 0x000fcc00078e20ffULL, 0x0000003d007a7306ULL, 0x0003f0000020d400ULL,
0x0000004400b37306ULL, 0x000fe20000005400ULL, 0x00000100463d7824ULL, 0x002fca00078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000044007d7306ULL, 0x0003f0000000d400ULL,
0x0000004500aa7306ULL, 0x000fe20000009400ULL, 0x0001000044447824ULL, 0x002fca00078e00ffULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x0000004500a77306ULL, 0x000ff00000005400ULL,
0x0000004500757306ULL, 0x0003f0000000d400ULL, 0x0000004600ac7306ULL, 0x000fe20000009400ULL,
0x0001000045457824ULL, 0x002fca00078e00ffULL, 0x00000018ff457819ULL, 0x000fe40000011445ULL,
0x0000004600a97306ULL, 0x000ff00000005400ULL, 0x00000046006e7306ULL, 0x0003f0000000d400ULL,
0x0000004700a47306ULL, 0x000fe20000009400ULL, 0x0001000046467824ULL, 0x002fca00078e00ffULL,
0x00000018ff467819ULL, 0x000fe40000011446ULL, 0x0000004700427306ULL, 0x000ff00000005400ULL,
0x0000004700687306ULL, 0x0003f0000000d400ULL, 0x0000004400ae7306ULL, 0x000fe20000209400ULL,
0x0001000047477824ULL, 0x002fca00078e00ffULL, 0x00000018ff6b7819ULL, 0x000fe40000011447ULL,
0x0000004400ad7306ULL, 0x000ff00000205400ULL, 0x0000004400797306ULL, 0x000ff0000020d400ULL,
0x0000004500a07306ULL, 0x000ff00000209400ULL, 0x00000045009f7306ULL, 0x000ff00000205400ULL,
0x0000004500737306ULL, 0x000ff0000020d400ULL, 0x0000004600897306ULL, 0x000ff00000209400ULL,
0x00000046008a7306ULL, 0x000ff00000205400ULL, 0x0000004600727306ULL, 0x0003f0000020d400ULL,
0x0000003d00957306ULL, 0x000fe20000209400ULL, 0x000000003e44783bULL, 0x002e6e0000004200ULL,
0x0000003d00947306ULL, 0x000ff00000205400ULL, 0x0000003d00747306ULL, 0x0005f0000020d400ULL,
0x0000004c00437306ULL, 0x000fe20000009400ULL, 0x00000001563d7824ULL, 0x004fc400078e0257ULL,
0x0000001056567824ULL, 0x000fca00078e00ffULL, 0xfffffff0563d7812ULL, 0x000fe200078ee23dULL,
0x0000004c00a37306ULL, 0x000fe60000005400ULL, 0x000160003d3d7811ULL, 0x000fe200078e20ffULL,
0x00000100448e7824ULL, 0x002fc800078e00ffULL, 0x0000004c00647306ULL, 0x0003e2000000d400ULL,
0x000000003d48783bULL, 0x000ea20000004200ULL, 0x00000018ffb87819ULL, 0x000fe20000011444ULL,
0x0000010047937824ULL, 0x000fe200078e00ffULL, 0x00000018ff8e7819ULL, 0x000fe4000001148eULL,
0x00000018ffb77819ULL, 0x000fe40000011445ULL, 0x0000008e00d97306ULL, 0x000fe20000209400ULL,
0x000100004c4c7824ULL, 0x002fe200078e00ffULL, 0x00000018ff937819ULL, 0x000fc40000011493ULL,
0x00000018ff9e7819ULL, 0x000fe40000011446ULL, 0x00000018ff4c7819ULL, 0x000fe4000001144cULL,
0x0000008e00da7306ULL, 0x000e620000205400ULL, 0x00000018ff997819ULL, 0x000fce0000011447ULL,
0x0000008e00be7306ULL, 0x000730000020d400ULL, 0x0000004c007f7306ULL, 0x000fe20000209400ULL,
0x00000100458e7824ULL, 0x008fe200078e00ffULL, 0x000000dad900720bULL, 0x002fc80003f7d000ULL,
0x00000018ff8e7819ULL, 0x000fe4000001148eULL, 0x0000004c00807306ULL, 0x000fe20000205400ULL,
0x00000018ff917819ULL, 0x004fe20000011448ULL, 0x000001004ada7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8b7819ULL, 0x000fe40000011449ULL, 0x00000018ff877819ULL, 0x000fe4000001144aULL,
0x00000001bebe3812ULL, 0x010fe200078efcffULL, 0x0000004c00697306ULL, 0x000fe2000020d400ULL,
0x00000018ffeb7819ULL, 0x000fce00000114daULL, 0x000000b800d47306ULL, 0x000ff00000209400ULL,
0x000000b800d57306ULL, 0x000e700000205400ULL, 0x0000004400d87306ULL, 0x000ff00000009400ULL,
0x0000004400d77306ULL, 0x000ea20000005400ULL, 0x000000d5d400720bULL, 0x002fe20003fbd000ULL,
0x000001004bd47824ULL, 0x000fca00078e00ffULL, 0x00000018ffd47819ULL, 0x000fe200000114d4ULL,
0x00000044004c7306ULL, 0x0002f0000000d400ULL, 0x0000008e00dc7306ULL, 0x000fe20000209400ULL,
0x0001000044447824ULL, 0x002fe200078e00ffULL, 0x000000d7d800720bULL, 0x004fc40003f9d000ULL,
0x00000018ffd77819ULL, 0x000fe4000001144bULL, 0x00000018ffbb7819ULL, 0x000fe40000011444ULL,
0x0000008e00dd7306ULL, 0x000e6e0000205400ULL, 0x000000014c4c4812ULL, 0x008fe200078efcffULL,
0x0000008e00bd7306ULL, 0x0004e6000020d400ULL, 0x0000004cbe4c723eULL, 0x000fca00000010ffULL,
0x0000004500a17306ULL, 0x000fe20000009400ULL, 0x00000100468e7824ULL, 0x004fe200078e00ffULL,
0x000000dddc00720bULL, 0x002fc80003f1d000ULL, 0x00000018ff8e7819ULL, 0x000fe4000001148eULL,
0x0000004500d67306ULL, 0x000e6e0000005400ULL, 0x00000001bdbd0812ULL, 0x008fe200078efcffULL,
0x000000bb00447306ULL, 0x000ff00000209400ULL, 0x000000bb00db7306ULL, 0x000ea20000205400ULL,
0x000000d6a100720bULL, 0x002fce0003f7d000ULL, 0x000000b800b87306ULL, 0x000e70000020d400ULL,
0x0000008e00e07306ULL, 0x000fe20000209400ULL, 0x000000db4400720bULL, 0x004fce0003fdd000ULL,
0x0000008e00df7306ULL, 0x000ea20000205400ULL, 0x00000001b8b85812ULL, 0x002fce00078efcffULL,
0x0000004500bc7306ULL, 0x0002f0000000d400ULL, 0x000000bb00bb7306ULL, 0x000f22000020d400ULL,
0x0001000045457824ULL, 0x002fe200078e00ffULL, 0x000000dfe000720bULL, 0x004fc80003fbd000ULL,
0x00000018ffba7819ULL, 0x000fe40000011445ULL, 0x000000b700d27306ULL, 0x000fe20000209400ULL,
0x00000001bcbc3812ULL, 0x008fce00078efcffULL, 0x000000b700d37306ULL, 0x000e620000205400ULL,
0x00000001bbbb6812ULL, 0x010fce00078efcffULL, 0x0000009300e27306ULL, 0x000ff00000209400ULL,
0x0000009300e17306ULL, 0x000ea20000205400ULL, 0x000000d3d200720bULL, 0x002fce0003fdd000ULL,
0x0000008e00b27306ULL, 0x0002f0000020d400ULL, 0x0000009e00cf7306ULL, 0x000fe20000209400ULL,
0x000000e1e200720bULL, 0x004fe20003f7d000ULL, 0x00000100488e7824ULL, 0x002fca00078e00ffULL,
0x00000018ff8e7819ULL, 0x000fe2000001148eULL, 0x0000009e00cb7306ULL, 0x000e620000205400ULL,
0x00000001b2b25812ULL, 0x008fce00078efcffULL, 0x0000004600ce7306ULL, 0x000ff00000009400ULL,
0x0000004600cd7306ULL, 0x000ea20000005400ULL, 0x000000cbcf00720bULL, 0x002fce0003fbd000ULL,
0x0000004600a67306ULL, 0x0003f0000000d400ULL, 0x0000009300b17306ULL, 0x000722000020d400ULL,
0x0001000046467824ULL, 0x002fe200078e00ffULL, 0x000000cdce00720bULL, 0x004fc80003f1d000ULL,
0x00000018ffa27819ULL, 0x000fe40000011446ULL, 0x0000004700cc7306ULL, 0x000fe20000009400ULL,
0x0000010049937824ULL, 0x008fca00078e00ffULL, 0x00000018ff937819ULL, 0x000fe40000011493ULL,
0x0000004700b97306ULL, 0x000fe20000005400ULL, 0x00000001b1b13812ULL, 0x010fe400078efcffULL,
0x00000001a6a60812ULL, 0x000fca00078efcffULL, 0x0000004700a57306ULL, 0x0003f0000000d400ULL,
0x000000b700b77306ULL, 0x000ea2000020d400ULL, 0x0001000047477824ULL, 0x002fca00078e00ffULL,
0x00000018ff9d7819ULL, 0x000fe40000011447ULL, 0x0000009900d17306ULL, 0x000ff00000209400ULL,
0x0000009900d07306ULL, 0x000e620000205400ULL, 0x00000001b7b76812ULL, 0x004fce00078efcffULL,
0x000000ba00de7306ULL, 0x000ff00000209400ULL, 0x000000ba00457306ULL, 0x000ea20000205400ULL,
0x000000d0d100720bULL, 0x002fce0003f7d000ULL, 0x000000a200467306ULL, 0x000ff00000209400ULL,
0x000000a200e37306ULL, 0x000e620000205400ULL, 0x00000045de00720bULL, 0x004fce0003f9d000ULL,
0x0000009e009e7306ULL, 0x000eb0000020d400ULL, 0x0000009300e77306ULL, 0x000fe20000209400ULL,
0x000000e34600720bULL, 0x002fce0003fdd000ULL, 0x0000009300e87306ULL, 0x000e620000205400ULL,
0x000000019e9e5812ULL, 0x004fce00078efcffULL, 0x0000004800ca7306ULL, 0x000ff00000009400ULL,
0x0000004800c77306ULL, 0x000fe20000005400ULL, 0x000000e8e700720bULL, 0x002fce0003fbd000ULL,
0x0000004800967306ULL, 0x0003f0000000d400ULL, 0x0000009d00477306ULL, 0x000fe20000209400ULL,
0x0001000048487824ULL, 0x002fca00078e00ffULL, 0x00000018ff487819ULL, 0x000fe40000011448ULL,
0x0000009d00e47306ULL, 0x000e700000205400ULL, 0x0000003f00847306ULL, 0x000ff00000209400ULL,
0x0000003f00587306ULL, 0x000fe20000205400ULL, 0x000000e44700720bULL, 0x002fe20003f1d000ULL,
0x0000000854477824ULL, 0x000fc400078e00ffULL, 0x0000000854547824ULL, 0x000fc800078e00ffULL,
0x0000003f006d7306ULL, 0x000ff0000020d400ULL, 0x0000004900c97306ULL, 0x000ff00000009400ULL,
0x00000049003f7306ULL, 0x000ff00000005400ULL, 0x0000004900927306ULL, 0x0003f0000000d400ULL,
0x0000009300977306ULL, 0x0004e2000020d400ULL, 0x0001000049497824ULL, 0x002fce00078e00ffULL,
0x0000009900997306ULL, 0x000e62000020d400ULL, 0x00000018ff937819ULL, 0x004fce0000011449ULL,
0x000000ba00ba7306ULL, 0x000ea2000020d400ULL, 0x0000000197975812ULL, 0x008fce00078efcffULL,
0x000000a200a27306ULL, 0x000ee2000020d400ULL, 0x0000000199993812ULL, 0x002fce00078efcffULL,
0x0000004800e97306ULL, 0x000fe20000209400ULL, 0x00000001baba4812ULL, 0x004fe400078efcffULL,
0x000000b9cc00720bULL, 0x000fca0003f9d000ULL, 0x0000004800ea7306ULL, 0x000e620000205400ULL,
0x00000001a2a26812ULL, 0x008fe400078efcffULL, 0x000000c7ca00720bULL, 0x000fca0003fdd000ULL,
0x0000004800987306ULL, 0x000ea2000020d400ULL, 0x00000001a5a54812ULL, 0x000fce00078efcffULL,
0x0000009300497306ULL, 0x000fe20000209400ULL, 0x000000eae900720bULL, 0x002fe40003f7d000ULL,
0x0000000196966812ULL, 0x000fca00078efcffULL, 0x0000009300487306ULL, 0x000e6c0000205400ULL,
0x0000000198983812ULL, 0x004fe400078efcffULL, 0x0000009d009d7306ULL, 0x000eb0000020d400ULL,
0x0000004a00c57306ULL, 0x000fe20000009400ULL, 0x000000484900720bULL, 0x002fce0003fbd000ULL,
0x0000004a00c27306ULL, 0x000e620000005400ULL, 0x000000019d9d0812ULL, 0x004fe400078efcffULL,
0x0000003fc900720bULL, 0x000fe40003f1d000ULL, 0x00000004553f7810ULL, 0x040fe40007ffe0ffULL,
0x0000000655557810ULL, 0x000fe20007ffe0ffULL, 0x0000008e00e67306ULL, 0x000fe20000209400ULL,
0xfffffff8473f7812ULL, 0x000fc800078ee23fULL, 0x000120003f487811ULL, 0x000fc600078e20ffULL,
0x0000008e00e57306ULL, 0x000ea20000205400ULL, 0x000000c2c500720bULL, 0x002fe40003fdd000ULL,
0x0000000192920812ULL, 0x000fca00078efcffULL, 0x000000eb00da7306ULL, 0x000ff00000209400ULL,
0x000000eb00447306ULL, 0x000e620000205400ULL, 0x000000e5e600720bULL, 0x004fce0003f9d000ULL,
0x0000004000827306ULL, 0x000ff00000209400ULL, 0x0000004000817306ULL, 0x000fe20000205400ULL,
0x00000044da00720bULL, 0x002fce0003f7d000ULL, 0x0000004000667306ULL, 0x000ff0000020d400ULL,
0x0000009300937306ULL, 0x000e70000020d400ULL, 0x0000004b00c17306ULL, 0x000ff00000009400ULL,
0x0000004b00407306ULL, 0x000ea20000005400ULL, 0x0000000193935812ULL, 0x002fce00078efcffULL,
0x0000008e009c7306ULL, 0x000e70000020d400ULL, 0x0000004b008e7306ULL, 0x000722000000d400ULL,
0x00000040c100720bULL, 0x004fe40003fbd000ULL, 0xfffffff854407812ULL, 0x000fe200078ee255ULL,
0x000001004e557824ULL, 0x000fc800078e00ffULL, 0x0000008b00c47306ULL, 0x000fe20000209400ULL,
0x000100004b4b7824ULL, 0x008fe200078e00ffULL, 0x000000019c9c4812ULL, 0x002fe400078efcffULL,
0x00000018ff557819ULL, 0x000fe40000011455ULL, 0x00000018ff477819ULL, 0x000fe4000001144bULL,
0x0000008b00c37306ULL, 0x000e620000205400ULL, 0x000000018e8e5812ULL, 0x010fce00078efcffULL,
0x0000004a00567306ULL, 0x0004f0000000d400ULL, 0x0000009100c67306ULL, 0x000fe20000209400ULL,
0x000100004a4a7824ULL, 0x004fe200078e00ffULL, 0x000000c3c400720bULL, 0x002fc80003f1d000ULL,
0x00000018ff4a7819ULL, 0x000fe4000001144aULL, 0x0000009100c87306ULL, 0x000e620000205400ULL,
0x0000000156566812ULL, 0x008fce00078efcffULL, 0x000000eb00a17306ULL, 0x000eb0000020d400ULL,
0x0000004700c27306ULL, 0x000fe20000209400ULL, 0x000000c8c600720bULL, 0x002fce0003f9d000ULL,
0x0000004700447306ULL, 0x000e620000205400ULL, 0x00000001a1a13812ULL, 0x004fe400078efcffULL,
0x000000b3b600720bULL, 0x000fca0003f7d000ULL, 0x0000008b008b7306ULL, 0x000eb0000020d400ULL,
0x0000004a00457306ULL, 0x000fe20000209400ULL, 0x00000044c200720bULL, 0x002fe40003fbd000ULL,
0x0001200040447811ULL, 0x000fc400078e20ffULL, 0x000000017d7d3812ULL, 0x000fe400078efcffULL,
0x000000b0af00720bULL, 0x000fe20003f7d000ULL, 0x0000004a00467306ULL, 0x000e620000205400ULL,
0x000000018b8b0812ULL, 0x004fce00078efcffULL, 0x0000009100917306ULL, 0x000ea8000020d400ULL,
0x000000017a7a3812ULL, 0x000fc800078efcffULL, 0x000000d400d27306ULL, 0x000fe20000209400ULL,
0x000000464500720bULL, 0x002fce0003f1d000ULL, 0x000000d400cd7306ULL, 0x000e620000205400ULL,
0x0000000191914812ULL, 0x004fce00078efcffULL, 0x0000004a00c67306ULL, 0x0004f0000020d400ULL,
0x0000004700c17306ULL, 0x0008e2000020d400ULL, 0x000000004848783bULL, 0x004ea20000000200ULL,
0x000000cdd200720bULL, 0x002fcc0003f9d000ULL, 0x000000d400b97306ULL, 0x000e62000020d400ULL,
0x000000004444783bULL, 0x010f220000000200ULL, 0x00000001c6c60812ULL, 0x008fe400078efcffULL,
0x000000b4b500720bULL, 0x000fe20003f1d000ULL, 0x000100004eb57824ULL, 0x000fe400078e00ffULL,
0x000100004fb47824ULL, 0x000fe200078e00ffULL, 0x000000d700d87306ULL, 0x000fe20000209400ULL,
0x00000001c1c15812ULL, 0x000fe400078efcffULL, 0x000000adae00720bULL, 0x000fc40003fbd000ULL,
0x00000018ffb57819ULL, 0x000fe400000114b5ULL, 0x00000018ffb47819ULL, 0x000fe200000114b4ULL,
0x000000d700d97306ULL, 0x000ee20000205400ULL, 0x00000001b9b94812ULL, 0x002fe400078efcffULL,
0x000000017e7e0812ULL, 0x000fe400078efcffULL, 0x000000a9ac00720bULL, 0x000fe40003f1d000ULL,
0x0000008eb9b9723eULL, 0x000fe200000010ffULL, 0x0000006f009b7306ULL, 0x000fe20000209400ULL,
0x0000000179795812ULL, 0x000fc400078efcffULL, 0x00000042a400720bULL, 0x000fe40003fbd000ULL,
0x000000bbb842723eULL, 0x000fe400000010ffULL, 0x00000056a1b8723eULL, 0x000fe200000010ffULL,
0x0000006f009a7306ULL, 0x000e620000205400ULL, 0x000000d9d800720bULL, 0x008fe20003f9d000ULL,
0x000000194848a231ULL, 0x084fe200003400ffULL, 0x000000016e6e0812ULL, 0x000fe200078efcffULL,
0x000000194a4aa231ULL, 0x000fe400003400ffULL, 0x0000001a4949a231ULL, 0x000fc400003400ffULL,
0x0000008700bf7306ULL, 0x000fe20000209400ULL, 0x0000001a4b4ba231ULL, 0x080fe200003400ffULL,
0x0000000168685812ULL, 0x000fe200078efcffULL, 0x000000194444a231ULL, 0x090fe400003400ffULL,
0x000000194646a231ULL, 0x000fe400003400ffULL, 0x0000001a4545a231ULL, 0x080fe200003400ffULL,
0x0000008700c07306ULL, 0x000ea20000205400ULL, 0x0000009a9b00720bULL, 0x002fe20003f7d000ULL,
0x0000001a4747a231ULL, 0x000fe200003400ffULL, 0x000000949500720bULL, 0x000fca0003f5d000ULL,
0x000000d700d77306ULL, 0x000e70000020d400ULL, 0x0000007800a87306ULL, 0x000fe20000209400ULL,
0x000000c0bf00720bULL, 0x004fe40003fdd000ULL, 0x0000000174742812ULL, 0x000fc400078efcffULL,
0x0000008a8900720bULL, 0x000fc60003f5d000ULL, 0x0000007800ab7306ULL, 0x000ea20000205400ULL,
0x00000001d7d74812ULL, 0x002fc800078efcffULL, 0x000000c1d7c1723eULL, 0x000fc600000010ffULL,
0x0000006f006f7306ULL, 0x000e64000020d400ULL, 0x0000000172722812ULL, 0x000fcc00078efcffULL,
0x0000008700877306ULL, 0x000ee2000020d400ULL, 0x000000aba800720bULL, 0x004fce0003f9d000ULL,
0x0000007800787306ULL, 0x000ea2000020d400ULL, 0x000000016f6f3812ULL, 0x002fe400078efcffULL,
0x0000008f9000720bULL, 0x000fca0003f7d000ULL, 0x0000006a00857306ULL, 0x000fe20000209400ULL,
0x0000000187876812ULL, 0x008fe400078efcffULL, 0x000000a7aa00720bULL, 0x000fe40003fdd000ULL,
0x000000c687c0723eULL, 0x000fc600000010ffULL, 0x0000006a00867306ULL, 0x000e620000205400ULL,
0x0000000178784812ULL, 0x004fe400078efcffULL, 0x000000a34300720bULL, 0x000fe40003f9d000ULL,
0x000000016c6c3812ULL, 0x000fe400078efcffULL, 0x000000bab743723eULL, 0x000fe200000010ffULL,
0x00000062005b7306ULL, 0x000fe20000209400ULL, 0x0000000175756812ULL, 0x000fe400078efcffULL,
0x0000009fa000720bULL, 0x000fc60003fdd000ULL, 0x000000424808723cULL, 0x000b640000041808ULL,
0x0000006200837306ULL, 0x000ea20000205400ULL, 0x000000868500720bULL, 0x002fe40003f1d000ULL,
0x0000000164644812ULL, 0x000fe400078efcffULL, 0x000000a29e42723eULL, 0x020fe400000010ffULL,
0x0000009d9943723eULL, 0x000fe200000010ffULL, 0x0000004d008c7306ULL, 0x000fe20000009400ULL,
0x0000000173736812ULL, 0x000fc400078efcffULL, 0x000000807f00720bULL, 0x000fc60003f9d000ULL,
0x000000424828723cULL, 0x000fe40000041828ULL, 0x0000004d008d7306ULL, 0x000e620000005400ULL,
0x000000835b00720bULL, 0x004fce0003f7d000ULL, 0x0000004d005f7306ULL, 0x0005e2000000d400ULL,
0x0000000169694812ULL, 0x000fce00078efcffULL, 0x0000006a006a7306ULL, 0x000ee2000020d400ULL,
0x000100004d4d7824ULL, 0x004fe200078e00ffULL, 0x0000008d8c00720bULL, 0x002fc80003fdd000ULL,
0x00000018ff547819ULL, 0x000fe4000001144dULL, 0x000000bcbd4d723eULL, 0x000fe200000010ffULL,
0x0000006200627306ULL, 0x000e6c000020d400ULL, 0x0000004c4804723cULL, 0x000b620000041804ULL,
0x000000016a6a0812ULL, 0x008fe200078efcffULL, 0x0000004e00597306ULL, 0x000fe20000009400ULL,
0x000000588400720bULL, 0x000fc40003f1d000ULL, 0x000000015f5f6812ULL, 0x000fe400078efcffULL,
0x000000a6b24c723eULL, 0x020fe400000010ffULL, 0x000000a5b14d723eULL, 0x000fe200000010ffULL,
0x0000004e005a7306ULL, 0x000ea20000005400ULL, 0x0000000162623812ULL, 0x002fe400078efcffULL,
0x000000818200720bULL, 0x000fe40003f7d000ULL, 0x000000726a6a723eULL, 0x000fe200000010ffULL,
0x0000004c4820723cULL, 0x000b620000041820ULL, 0x000000016d6d0812ULL, 0x000fe200078efcffULL,
0x0000006b00887306ULL, 0x000fe60000209400ULL, 0x000000646d64723eULL, 0x000fc400000010ffULL,
0x000000969c4c723eULL, 0x020fe400000010ffULL, 0x00000092974d723eULL, 0x000fe200000010ffULL,
0x0000006b00577306ULL, 0x000e620000205400ULL, 0x0000005a5900720bULL, 0x004fe40003f5d000ULL,
0x000000b84858723cULL, 0x000be20000041834ULL, 0x0000000166663812ULL, 0x000fc800078efcffULL,
0x0000004e005d7306ULL, 0x0004e4000000d400ULL, 0x000000797834723eULL, 0x020fe400000010ffULL,
0x000000736f35723eULL, 0x000fc800000010ffULL, 0x0000006000767306ULL, 0x000fe20000209400ULL,
0x000001004f4e7824ULL, 0x004fe200078e00ffULL, 0x000000578800720bULL, 0x002fe20003fbd000ULL,
0x000000344434723cULL, 0x000fe60000041808ULL, 0x00000018ff427819ULL, 0x000fe4000001144eULL,
0x0000006000777306ULL, 0x000e620000205400ULL, 0x000000015d5d2812ULL, 0x008fce00078efcffULL,
0x0000005e00707306ULL, 0x000ff00000209400ULL, 0x0000005e00717306ULL, 0x000ea20000205400ULL,
0x000000777600720bULL, 0x002fce0003f1d000ULL, 0x0000005400b37306ULL, 0x000ff00000209400ULL,
0x0000005400aa7306ULL, 0x000e620000205400ULL, 0x000000717000720bULL, 0x004fce0003fdd000ULL,
0x0000005500a37306ULL, 0x000ff00000209400ULL, 0x00000055009a7306ULL, 0x000ea20000205400ULL,
0x000000aab300720bULL, 0x002fce0003f7d000ULL, 0x0000005400a77306ULL, 0x0002f0000020d400ULL,
0x00000055008c7306ULL, 0x0008e2000020d400ULL, 0x000000989154723eULL, 0x002fe400000010ffULL,
0x0000009aa300720bULL, 0x004fca0003f9d000ULL, 0x0000004f007b7306ULL, 0x000fe20000009400ULL,
0x000000938b55723eULL, 0x010fe400000010ffULL, 0x00000001a7a73812ULL, 0x008fca00078efcffULL,
0x0000004f007c7306ULL, 0x000fe20000005400ULL, 0x000000544854723cULL, 0x000b620000041830ULL,
0x000000018c8c4812ULL, 0x000fcc00078efcffULL, 0x0000004f00537306ULL, 0x0003e2000000d400ULL,
0x0000006e7430723eULL, 0x020fe400000010ffULL, 0x000000686c31723eULL, 0x000fca00000010ffULL,
0x0000006000607306ULL, 0x000ea2000020d400ULL, 0x0000004c484c723cULL, 0x042b6e000004182cULL,
0x0000007d7e2c723eULL, 0x020fe200000010ffULL, 0x000000c04848723cULL, 0x000f620000041838ULL,
0x000000757a2d723eULL, 0x000fe200000010ffULL, 0x0000005e005e7306ULL, 0x000e62000020d400ULL,
0x0000000160600812ULL, 0x004fca00078efcffULL, 0x0000002c4438723cULL, 0x000b640000041804ULL,
0x0000006b006b7306ULL, 0x000ea2000020d400ULL, 0x000000696008723eULL, 0x000fca00000010ffULL,
0x000000304430723cULL, 0x000b640000041820ULL, 0x0000004200897306ULL, 0x000fe20000209400ULL,
0x000000015e5e6812ULL, 0x002fc800078efcffULL, 0x000000a75e09723eULL, 0x000fc600000010ffULL,
0x00000042002e7306ULL, 0x000e620000205400ULL, 0x000000016b6b5812ULL, 0x004fe400078efcffULL,
0x0000007c7b00720bULL, 0x000fe20003fbd000ULL, 0x000000084408723cULL, 0x000b620000041854ULL,
0x0000006b626b723eULL, 0x000fc600000010ffULL, 0x0000004200837306ULL, 0x000eb0000020d400ULL,
0x0000005c00677306ULL, 0x000fe20000209400ULL, 0x0000002e8900720bULL, 0x002fe40003fdd000ULL,
0x0000000153535812ULL, 0x000fe200078efcffULL, 0x0000006a442c723cULL, 0x000b680000041828ULL,
0x0000005c00657306ULL, 0x000e6c0000205400ULL, 0x0000000183836812ULL, 0x004fc400078efcffULL,
0x0000005200617306ULL, 0x000ff00000209400ULL, 0x0000005200637306ULL, 0x000ea20000205400ULL,
0x000000656700720bULL, 0x002fe40003f1d000ULL, 0x0000005f6665723eULL, 0x000fca00000010ffULL,
0x000000b500427306ULL, 0x000fe40000209400ULL, 0x000000644428723cULL, 0x000b6c000004184cULL,
0x000000b500437306ULL, 0x000e620000205400ULL, 0x000000636100720bULL, 0x004fce0003f7d000ULL,
0x000000b400047306ULL, 0x020ff00000209400ULL, 0x000000b400057306ULL, 0x000ea20000205400ULL,
0x000000434200720bULL, 0x002fce0003f9d000ULL, 0x0000005c005c7306ULL, 0x000e70000020d400ULL,
0x0000005200527306ULL, 0x000ee2000020d400ULL, 0x000000050400720bULL, 0x004fe40003f5d000ULL,
0x0000005d8c04723eULL, 0x000fc400000010ffULL, 0x000000538305723eULL, 0x000fc600000010ffULL,
0x000000b500b57306ULL, 0x000ea2000020d400ULL, 0x000000015c5c0812ULL, 0x002fc600078efcffULL,
0x000000044404723cULL, 0x000b680000041858ULL, 0x000000b400217306ULL, 0x000e62000020d400ULL,
0x0000000152523812ULL, 0x008fe400078efcffULL, 0x00000001b5b54812ULL, 0x004fc800078efcffULL,
0x000000b55c20723eULL, 0x000fe400000010ffULL, 0x0000000121212812ULL, 0x002fc800078efcffULL,
0x000000215221723eULL, 0x000fce00000010ffULL, 0x000000204420723cULL, 0x000b620000041848ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0186b800ff427f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000c3c00720cULL, 0x000fe20003f06070ULL, 0x01868800ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff487224ULL, 0x022fe400078e0043ULL, 0x000000ffff437224ULL, 0x000fd200078e0050ULL,
0x000121d000000947ULL, 0x000fea0003800000ULL, 0x0000000000427805ULL, 0x000fc40000015200ULL,
0x0186bc00ff107984ULL, 0x000e640000000800ULL, 0x8000000010ff7812ULL, 0x002fe40007804848ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff467224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000447805ULL, 0x000fcc0000015200ULL, 0x0000004442447210ULL, 0x000fca0007f1e1ffULL,
0x0000000145457824ULL, 0x000fe200000e0e43ULL, 0x003d09004400780cULL, 0x000fc80003f06070ULL,
0x000000ff4500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404400780cULL, 0x000fc80003f06070ULL, 0x000000ff4500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff107819ULL, 0x000fc80000011445ULL,
0x0000004410107211ULL, 0x000fca00078110ffULL, 0x000000ffff447224ULL, 0x000fca00000e0645ULL,
0x0000000210107819ULL, 0x000fc80000001244ULL, 0x000000100000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000146467810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0186bc00ff107984ULL, 0x000e640000000800ULL,
0x8000000010ff7812ULL, 0x002fe40007804848ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000046000009947ULL, 0x000fea0003800000ULL, 0x000000203c107810ULL, 0x000fe20007ffe0ffULL,
0x000000010f437824ULL, 0x000fe200078e021bULL, 0x000000041b4f7810ULL, 0x000fe40007ffe0ffULL,
0x000000100c427217ULL, 0x000fe20007800000ULL, 0x0000000143447824ULL, 0x000fe200078e0203ULL,
0x000000021b487810ULL, 0x000fe20007ffe0ffULL, 0x00000010434d7824ULL, 0x000fe200078e00ffULL,
0x000000061b537810ULL, 0x000fe20007ffe0ffULL, 0x0000000142427824ULL, 0x000fe200078e0a10ULL,
0x0000006000107811ULL, 0x000fe200078e38ffULL, 0x000000010f467824ULL, 0x000fe200078e024fULL,
0xfffffff04d4d7812ULL, 0x000fe200078ee244ULL, 0x000000010f457824ULL, 0x040fe200078e0248ULL,
0x000000420f427217ULL, 0x000fe20007800000ULL, 0x0000000146477824ULL, 0x000fe200078e0203ULL,
0x000000f0164c7812ULL, 0x000fe200078ec0ffULL, 0x0000001046527824ULL, 0x000fe200078e00ffULL,
0x000160004d4d7811ULL, 0x000fe200078e20ffULL, 0x0000000143437824ULL, 0x000fc400078e0210ULL,
0x0000000145447824ULL, 0x040fe200078e0203ULL, 0xfffffff052527812ULL, 0x000fe200078ee247ULL,
0x00000010454e7824ULL, 0x000fe200078e00ffULL, 0x00000043514b7210ULL, 0x000fe20007f1e0ffULL,
0x000000010f477824ULL, 0x000fe200078e0253ULL, 0x0001600052527811ULL, 0x000fe200078e20ffULL,
0x0000000145437824ULL, 0x000fe200078e0210ULL, 0xfffffff04e4e7812ULL, 0x000fe200078ee244ULL,
0x0000000146447824ULL, 0x100fe400078e0210ULL, 0x0000000147457824ULL, 0x000fe200078e0210ULL,
0x0000004351437210ULL, 0x000fe20007f9e0ffULL, 0x0000000147497824ULL, 0x000fe200078e0203ULL,
0x0000004451447210ULL, 0x000fe20007f7e0ffULL, 0x00000010474a7824ULL, 0x000fe200078e00ffULL,
0x0000004551457210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff477224ULL, 0x000fe200000e06ffULL,
0x00005e004b467a11ULL, 0x040fe200078040ffULL, 0x0000000142107824ULL, 0x000fe200078e0a0fULL,
0xfffffff04a517812ULL, 0x000fe200078ee249ULL, 0x000000ffff4a7224ULL, 0x000fe200020e06ffULL,
0x00005f004b4b7a11ULL, 0x000fc400000f4447ULL, 0x000000104800720cULL, 0x080fe20003f06070ULL,
0x000000ffff487224ULL, 0x000fe200018e06ffULL, 0x00005e0043497a11ULL, 0x000fe400078c40ffULL,
0x00005e0044477a11ULL, 0x040fe400078a40ffULL, 0x000000101b00720cULL, 0x000fe40003f86070ULL,
0x00005f00434a7a11ULL, 0x000fe400030f444aULL, 0x00005f0044487a11ULL, 0x000fe200028f4448ULL,
0x000000ffff447224ULL, 0x000fe200010e06ffULL, 0x0000004c46427210ULL, 0x000fc40007fde0ffULL,
0x00005e0045467a11ULL, 0x000fe400078a40ffULL, 0x000000104f00720cULL, 0x080fe20003f66070ULL,
0x000000ffff437224ULL, 0x000fe200030e064bULL, 0x000000105300720cULL, 0x000fe40003f46070ULL,
0x00005f0045107a11ULL, 0x000fe400028f4444ULL, 0x0000004c49447210ULL, 0x000fe20007fbe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000424d7faeULL, 0x0003e2000e101c46ULL,
0x000160004e4e7811ULL, 0x000fc400078e20ffULL, 0x0001600051517811ULL, 0x000fe200078e20ffULL,
0x000000ffff457224ULL, 0x000fe200028e064aULL, 0x0000004c46467210ULL, 0x000fc80007fbe0ffULL,
0x00000000444e7faeULL, 0x0005e2000c101c46ULL, 0x0000004c47427210ULL, 0x002fe20007f9e0ffULL,
0x000000ffff477224ULL, 0x000fc800028e0610ULL, 0x000000ffff437224ULL, 0x000fca00020e0648ULL,
0x0000000042527faeULL, 0x0005e8000d901c46ULL, 0x0000000046517faeULL, 0x0005e2000d101c46ULL,
0x0000039000007947ULL, 0x000fea0003800000ULL, 0x000000010f107824ULL, 0x000fe200078e021bULL,
0x0000006000437811ULL, 0x000fe400078e38ffULL, 0x000000f0164c7812ULL, 0x000fe200078ec0ffULL,
0x0000000110427824ULL, 0x040fe200078e0203ULL, 0x0000000210457810ULL, 0x040fe20007ffe0ffULL,
0x00000010104d7824ULL, 0x040fe200078e00ffULL, 0x0000000410467810ULL, 0x000fc40007ffe0ffULL,
0x0000000610477810ULL, 0x040fe20007ffe0ffULL, 0x0000000145447824ULL, 0x000fe200078e0203ULL,
0xfffffff04d4d7812ULL, 0x000fe200078ee242ULL, 0x00000010454e7824ULL, 0x000fe400078e00ffULL,
0x0000000110427824ULL, 0x100fe200078e0243ULL, 0x000160004d4d7811ULL, 0x000fe200078e20ffULL,
0x0000000145107824ULL, 0x000fe200078e0243ULL, 0xfffffff04e4e7812ULL, 0x000fe200078ee244ULL,
0x0000000146457824ULL, 0x040fe200078e0203ULL, 0x0000004251447210ULL, 0x040fe20007f7e0ffULL,
0x0000000146427824ULL, 0x100fe200078e0243ULL, 0x00000010514a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000147437824ULL, 0x000fe200078e0243ULL, 0x00005e0044487a11ULL, 0x000fe200078840ffULL,
0x00000010464f7824ULL, 0x000fe200078e00ffULL, 0x0000004251427210ULL, 0x000fe20007f5e0ffULL,
0x0000000147467824ULL, 0x000fc400078e0203ULL, 0x000000ffff107224ULL, 0x000fe200018e06ffULL,
0x0000004351437210ULL, 0x000fe20007f7e0ffULL, 0x0000001047477824ULL, 0x000fe200078e00ffULL,
0xfffffff04f4f7812ULL, 0x000fe200078ee245ULL, 0x000000ffff497224ULL, 0x000fe200000e06ffULL,
0x00005f00444b7a11ULL, 0x000fe200020f4410ULL, 0x000000ffff457224ULL, 0x000fe200010e06ffULL,
0xfffffff047517812ULL, 0x000fe200078ee246ULL, 0x000000ffff477224ULL, 0x000fe200018e06ffULL,
0x00005e004a107a11ULL, 0x000fe400078040ffULL, 0x00005e0042447a11ULL, 0x000fc400078440ffULL,
0x0000004c48487210ULL, 0x080fe40007f9e0ffULL, 0x00005e0043467a11ULL, 0x040fe400078640ffULL,
0x00005f004a4a7a11ULL, 0x000fe200000f4449ULL, 0x000000ffff497224ULL, 0x000fe200020e064bULL,
0x00005f0042457a11ULL, 0x000fe400010f4445ULL, 0x0000004c10427210ULL, 0x080fe40007f1e0ffULL,
0x00005f0043477a11ULL, 0x000fe200018f4447ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000484d7faeULL, 0x0003e2000b901c46ULL, 0x0000004c44447210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff437224ULL, 0x000fe200000e064aULL, 0x0000004c46467210ULL, 0x000fc40007f7e0ffULL,
0x000160004e107811ULL, 0x000fe200078e20ffULL, 0x000000ffff457224ULL, 0x000fe400010e0645ULL,
0x000000ffff477224ULL, 0x000fe400018e0647ULL, 0x0000000042107faeULL, 0x0005e2000b901c46ULL,
0x000160004f487811ULL, 0x002fe400078e20ffULL, 0x0001600051497811ULL, 0x000fc600078e20ffULL,
0x0000000044487faeULL, 0x0005e8000b901c46ULL, 0x0000000046497faeULL, 0x0005e4000b901c46ULL,
0x0000000000007918ULL, 0x004fe20000000000ULL, 0x0000000114107810ULL, 0x000fc80007ffe0ffULL,
0x0000000d1000720cULL, 0x000fe20003f06070ULL, 0xffffffffff107424ULL, 0x000fd800078e00ffULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x0000000112427810ULL, 0x000fe20007ffe014ULL,
0x00000004ff437424ULL, 0x000fc800078e00ffULL, 0x0000600042427625ULL, 0x000fca00078e0043ULL,
0x0000000642107981ULL, 0x000324000c1e1900ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0186b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0186b000ff587f8cULL, 0x000ea2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018628000f467f8cULL, 0x000664000c80043fULL, 0x0000000000427805ULL, 0x002fc40000015200ULL,
0x01862c000f447984ULL, 0x000e640000000800ULL, 0x8000000044ff7812ULL, 0x002fe40007804847ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff497224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000447805ULL, 0x000fcc0000015200ULL, 0x0000004442487210ULL, 0x000fca0007f1e1ffULL,
0x0000000145457824ULL, 0x000fe200000e0e43ULL, 0x003d09004800780cULL, 0x000fc80003f06070ULL,
0x000000ff4500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404800780cULL, 0x000fc80003f06070ULL, 0x000000ff4500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff447819ULL, 0x000fc80000011445ULL,
0x0000004844447211ULL, 0x000fca00078110ffULL, 0x000000ffff457224ULL, 0x000fca00000e0645ULL,
0x0000000244447819ULL, 0x000fc80000001245ULL, 0x000000440000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000149497810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01862c000f447984ULL, 0x000e640000000800ULL,
0x8000000044ff7812ULL, 0x002fe40007804847ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0180800017427984ULL, 0x000e680000000800ULL, 0x0182800017487984ULL, 0x0006a20000000800ULL,
0x000000504200720bULL, 0x002fe20003f1d000ULL, 0x0001a1327f007947ULL, 0x000fd8000b800000ULL,
0x0000000000497806ULL, 0x008fc800000e0100ULL, 0x0000ffff49ff7812ULL, 0x000fe2000780c0ffULL,
0x000004a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff4a7424ULL, 0x000fc400078e00ffULL,
0x000000ffff437224ULL, 0x000fd200078e0050ULL, 0x0000046000008947ULL, 0x000fea0003800000ULL,
0x000000010200780cULL, 0x000fe40003f05270ULL, 0x000000504200720bULL, 0x000fe20003f54000ULL,
0x0001a1027f007947ULL, 0x000fd8000b800000ULL, 0x0000000000437806ULL, 0x000fc400010e0100ULL,
0x0000005042448209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe80003800000ULL,
0x0184804417008388ULL, 0x0003e40000000800ULL, 0x0000991043447816ULL, 0x002fc800000000ffULL,
0x000000ff4400720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000005042447209ULL, 0x000fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff43ff7812ULL, 0x000fc6000780c0ffULL, 0x0000005044447221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b44447820ULL, 0x000fc80000410000ULL, 0x00000044005e7308ULL, 0x000e640000000800ULL,
0x0000005e11117220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff447819ULL, 0x000fe20000011603ULL, 0x0001a0527f007947ULL, 0x000fea000b800000ULL,
0x00001f445e447589ULL, 0x0002e400000e0000ULL, 0x0000004438387220ULL, 0x088fe40000410000ULL,
0x0000004439397220ULL, 0x080fe40000410000ULL, 0x0000004434347220ULL, 0x080fe40000410000ULL,
0x0000004435357220ULL, 0x000fc40000410000ULL, 0x0000004430307220ULL, 0x080fe40000410000ULL,
0x0000004431317220ULL, 0x080fe40000410000ULL, 0x000000442c2c7220ULL, 0x080fe40000410000ULL,
0x000000442d2d7220ULL, 0x080fe40000410000ULL, 0x0000004428287220ULL, 0x080fe40000410000ULL,
0x0000004429297220ULL, 0x000fc40000410000ULL, 0x0000004408087220ULL, 0x080fe40000410000ULL,
0x0000004409097220ULL, 0x080fe40000410000ULL, 0x0000004404047220ULL, 0x080fe40000410000ULL,
0x0000004405057220ULL, 0x080fe40000410000ULL, 0x0000004420207220ULL, 0x080fe40000410000ULL,
0x0000004421217220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0043ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000803447811ULL, 0x000fe200078ff0ffULL, 0x00019f627f007947ULL, 0x000fea000b800000ULL,
0x00001f445e447589ULL, 0x00066400000e0000ULL, 0x000000443a3a7220ULL, 0x082fe40000410000ULL,
0x000000443b3b7220ULL, 0x080fe40000410000ULL, 0x0000004436367220ULL, 0x080fe40000410000ULL,
0x0000004437377220ULL, 0x080fe40000410000ULL, 0x0000004432327220ULL, 0x080fe40000410000ULL,
0x0000004433337220ULL, 0x000fc40000410000ULL, 0x000000442e2e7220ULL, 0x080fe40000410000ULL,
0x000000442f2f7220ULL, 0x080fe40000410000ULL, 0x000000442a2a7220ULL, 0x080fe40000410000ULL,
0x000000442b2b7220ULL, 0x080fe40000410000ULL, 0x000000440a0a7220ULL, 0x080fe40000410000ULL,
0x000000440b0b7220ULL, 0x000fc40000410000ULL, 0x0000004406067220ULL, 0x080fe40000410000ULL,
0x0000004407077220ULL, 0x080fe40000410000ULL, 0x0000004422227220ULL, 0x080fe40000410000ULL,
0x0000004423237220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000ffff43ff7812ULL, 0x000fe20007800849ULL, 0x00000001ff4a7424ULL, 0x000fe200078e00ffULL,
0x0000005042507209ULL, 0x000fca0007810000ULL, 0x000000ffff437224ULL, 0x000fcc00078e0050ULL,
0x8000005042420221ULL, 0x000fe20000010000ULL, 0x00007610ff4a0816ULL, 0x000fe2000000004aULL,
0x000000ffff430224ULL, 0x000fe400078e0050ULL, 0x3fb8aa3b42420820ULL, 0x000fc80000410000ULL,
0x0000004200180308ULL, 0x000e640000000800ULL, 0x0000001848480220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001148117221ULL, 0x004fc40000010000ULL,
0x0000000000447805ULL, 0x000fca0000015200ULL, 0x0186ac00ff427984ULL, 0x000e640000000800ULL,
0x8000000042ff7812ULL, 0x002fe40007804841ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff487224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000467805ULL, 0x000fcc0000015200ULL,
0x0000004644467210ULL, 0x000fca0007f1e1ffULL, 0x0000000147477824ULL, 0x000fe200000e0e45ULL,
0x003d09004600780cULL, 0x000fc80003f06070ULL, 0x000000ff4700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404600780cULL, 0x000fc80003f06070ULL,
0x000000ff4700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff427819ULL, 0x000fc80000011447ULL, 0x0000004642427211ULL, 0x000fca00078110ffULL,
0x000000ffff467224ULL, 0x000fca00000e0647ULL, 0x0000000242427819ULL, 0x000fc80000001246ULL,
0x000000420000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000148487810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0186ac00ff427984ULL, 0x000e640000000800ULL, 0x8000000042ff7812ULL, 0x002fe40007804841ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099104a417816ULL, 0x000fe200000000ffULL,
0x0000017000007945ULL, 0x000fe60003800000ULL, 0x000000ff4100720cULL, 0x000fda0003f45270ULL,
0x0000014000002947ULL, 0x000fea0003800000ULL, 0x00000018ff19723eULL, 0x000fe400000010ffULL,
0x00000002ff417819ULL, 0x000fe40000011603ULL, 0x00005410195e7816ULL, 0x008fe20000000019ULL,
0x00019b427f007947ULL, 0x000fea000b800000ULL, 0x00001f415e197589ULL, 0x0002a400000e0000ULL,
0x00000008411a7810ULL, 0x000fe20007ffe0ffULL, 0x00019b827f007947ULL, 0x000fea000b800000ULL,
0x00001f1a5e1a7589ULL, 0x00066400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x0000001041477810ULL, 0x000fe20007ffe0ffULL, 0x0000001fff457424ULL, 0x000fe200078e00ffULL,
0x00008bd000447802ULL, 0x000fe20000000f00ULL, 0xffffffffff467424ULL, 0x000fc400078e00ffULL,
0x0001a95000007944ULL, 0x01efea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x0000001841477810ULL, 0x000fe20007ffe0ffULL, 0x0000001fff457424ULL, 0x000fe200078e00ffULL,
0x00008c3000447802ULL, 0x000fe20000000f00ULL, 0xffffffffff467424ULL, 0x004fc400078e00ffULL,
0x0001a8f000007944ULL, 0x01afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000001c4c783bULL, 0x000ee80000004200ULL,
0x000000001d50783bULL, 0x000ea80000004200ULL, 0x000000001e44783bULL, 0x004ea80000004200ULL,
0x000000001f48783bULL, 0x000e620000004200ULL, 0x0000004c00d37306ULL, 0x008fe20000009400ULL,
0x00000018ff987819ULL, 0x000fe2000001144cULL, 0x000001004c727824ULL, 0x000fe200078e00ffULL,
0x00000018ff977819ULL, 0x000fe2000001144dULL, 0x000001004d777824ULL, 0x000fe200078e00ffULL,
0x00000018ff8d7819ULL, 0x000fe2000001144eULL, 0x0000010053787824ULL, 0x000fe200078e00ffULL,
0x00000018ffad7819ULL, 0x000fe20000011472ULL, 0x0000004c00d27306ULL, 0x000ee20000005400ULL,
0x00000018ff777819ULL, 0x000fc40000011477ULL, 0x00000018ff8b7819ULL, 0x000fe4000001144fULL,
0x00000018ff577819ULL, 0x000fe40000011452ULL, 0x00000018ff827819ULL, 0x000fe20000011450ULL,
0x0000004c009e7306ULL, 0x0002e2000000d400ULL, 0x00000018ff7d7819ULL, 0x000fe40000011451ULL,
0x00000018ff6e7819ULL, 0x004fe40000011444ULL, 0x00000018ff6a7819ULL, 0x000fc40000011445ULL,
0x00000018ff787819ULL, 0x000fe20000011478ULL, 0x0000009800ce7306ULL, 0x000fe20000209400ULL,
0x000100004c4c7824ULL, 0x002fe200078e00ffULL, 0x000000d2d300720bULL, 0x008fe40003f1d000ULL,
0x00000018ff767819ULL, 0x000fe40000011453ULL, 0x00000018ff4c7819ULL, 0x000fe4000001144cULL,
0x0000009800ab7306ULL, 0x000e620000205400ULL, 0x00000018ff687819ULL, 0x000fc40000011446ULL,
0x00000018ff607819ULL, 0x000fe40000011447ULL, 0x00000018ff5e7819ULL, 0x000fe40000011448ULL,
0x000000019e9e0812ULL, 0x000fe200078efcffULL, 0x0000004d00d17306ULL, 0x000fe20000009400ULL,
0x00000018ff5a7819ULL, 0x000fe4000001144aULL, 0x00000018ff417819ULL, 0x000fe4000001144bULL,
0x00000018ff5c7819ULL, 0x000fc60000011449ULL, 0x0000004d00737306ULL, 0x000fe20000005400ULL,
0x000000abce00720bULL, 0x002fce0003f9d000ULL, 0x0000004d009c7306ULL, 0x0003f0000000d400ULL,
0x0000004c00d57306ULL, 0x000fe20000209400ULL, 0x000100004d4d7824ULL, 0x002fca00078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x0000004c00d67306ULL, 0x000e700000205400ULL,
0x0000004c009d7306ULL, 0x0004f0000020d400ULL, 0x0000009800987306ULL, 0x000ee2000020d400ULL,
0x000001004e4c7824ULL, 0x004fe200078e00ffULL, 0x000000d6d500720bULL, 0x002fc80003fbd000ULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x0000004d00da7306ULL, 0x000fee0000209400ULL,
0x000000019d9d5812ULL, 0x008fe200078efcffULL, 0x0000004d00d97306ULL, 0x000e620000205400ULL,
0x0000000198984812ULL, 0x000fce00078efcffULL, 0x0000004c00dc7306ULL, 0x000ff00000209400ULL,
0x0000004c00db7306ULL, 0x000ea20000205400ULL, 0x000000d9da00720bULL, 0x002fce0003f1d000ULL,
0x0000004e00cd7306ULL, 0x000ff00000009400ULL, 0x0000004e00b07306ULL, 0x000fe20000005400ULL,
0x000000dbdc00720bULL, 0x004fce0003f9d000ULL, 0x0000004e00927306ULL, 0x0003f0000000d400ULL,
0x0000007700d77306ULL, 0x000fe20000209400ULL, 0x000100004e4e7824ULL, 0x002fca00078e00ffULL,
0x00000018ff4e7819ULL, 0x000fe4000001144eULL, 0x0000007700d87306ULL, 0x000e700000205400ULL,
0x0000004d009b7306ULL, 0x0004f0000020d400ULL, 0x0000004c00937306ULL, 0x000ee2000020d400ULL,
0x000000d8d700720bULL, 0x002fe20003fdd000ULL, 0x000001004f4d7824ULL, 0x004fca00078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe2000001144dULL, 0x0000004f00cc7306ULL, 0x000fe20000009400ULL,
0x000000019b9b0812ULL, 0x008fce00078efcffULL, 0x0000004f00707306ULL, 0x000e620000005400ULL,
0x0000000193934812ULL, 0x000fce00078efcffULL, 0x0000008d00c97306ULL, 0x000ff00000209400ULL,
0x0000008d00c67306ULL, 0x000ea20000205400ULL, 0x00000070cc00720bULL, 0x002fce0003f1d000ULL,
0x000000ad00d47306ULL, 0x000ff00000209400ULL, 0x000000ad00727306ULL, 0x000e620000205400ULL,
0x000000c6c900720bULL, 0x004fce0003f9d000ULL, 0x0000007700ac7306ULL, 0x0004f0000020d400ULL,
0x0000004e00e07306ULL, 0x000fe20000209400ULL, 0x0000010051777824ULL, 0x004fe200078e00ffULL,
0x00000072d400720bULL, 0x002fc80003f7d000ULL, 0x00000018ff777819ULL, 0x000fe40000011477ULL,
0x0000004e00df7306ULL, 0x000fe20000205400ULL, 0x00000001acac6812ULL, 0x008fe400078efcffULL,
0x000000b0cd00720bULL, 0x000fca0003fdd000ULL, 0x0000004e004c7306ULL, 0x0003f0000020d400ULL,
0x0000009700cf7306ULL, 0x000fe20000209400ULL, 0x00000100504e7824ULL, 0x002fe200078e00ffULL,
0x0000000192926812ULL, 0x000fc800078efcffULL, 0x00000018ff4e7819ULL, 0x000fe4000001144eULL,
0x0000009700d07306ULL, 0x000e700000205400ULL, 0x0000004f008f7306ULL, 0x0004f0000000d400ULL,
0x0000008d008d7306ULL, 0x000ee2000020d400ULL, 0x000100004f4f7824ULL, 0x004fe200078e00ffULL,
0x000000d0cf00720bULL, 0x002fc80003fbd000ULL, 0x00000018ff4f7819ULL, 0x000fe4000001144fULL,
0x000000ad00ad7306ULL, 0x000e62000020d400ULL, 0x000000018f8f0812ULL, 0x008fce00078efcffULL,
0x0000004e00e47306ULL, 0x000fe20000209400ULL, 0x000000018d8d4812ULL, 0x000fce00078efcffULL,
0x0000004e00e37306ULL, 0x000ea20000205400ULL, 0x00000001adad3812ULL, 0x002fe400078efcffULL,
0x00000073d100720bULL, 0x000fca0003f7d000ULL, 0x0000007700e67306ULL, 0x000ff00000209400ULL,
0x0000007700e57306ULL, 0x000e620000205400ULL, 0x000000e3e400720bULL, 0x004fe40003f1d000ULL,
0x000000019c9c3812ULL, 0x000fca00078efcffULL, 0x00000077008a7306ULL, 0x0004f0000020d400ULL,
0x0000005200b57306ULL, 0x000fe20000009400ULL, 0x0000010052777824ULL, 0x004fe200078e00ffULL,
0x000000e5e600720bULL, 0x002fc80003f9d000ULL, 0x00000018ff777819ULL, 0x000fe40000011477ULL,
0x0000005200b67306ULL, 0x000fee0000005400ULL, 0x000000018a8a4812ULL, 0x008fe200078efcffULL,
0x00000052007a7306ULL, 0x0003f0000000d400ULL, 0x0000009700977306ULL, 0x000ea2000020d400ULL,
0x0001000052527824ULL, 0x002fca00078e00ffULL, 0x00000018ff527819ULL, 0x000fe40000011452ULL,
0x0000004d00de7306ULL, 0x000ff00000209400ULL, 0x0000004d00dd7306ULL, 0x000e620000205400ULL,
0x0000000197975812ULL, 0x004fc400078efcffULL, 0x000000dfe000720bULL, 0x000fca0003fbd000ULL,
0x0000004d00947306ULL, 0x000eb0000020d400ULL, 0x0000004f00e17306ULL, 0x000fe20000209400ULL,
0x000000ddde00720bULL, 0x002fe40003f7d000ULL, 0x000000014c4c5812ULL, 0x000fc800078efcffULL,
0x0000004c8d4c723eULL, 0x000fe200000010ffULL, 0x0000004f00e27306ULL, 0x000e6c0000205400ULL,
0x0000000194943812ULL, 0x004fe400078efcffULL, 0x0000004f004d7306ULL, 0x000eb0000020d400ULL,
0x0000005200bb7306ULL, 0x000fe20000209400ULL, 0x000000e2e100720bULL, 0x002fce0003fdd000ULL,
0x0000005200ba7306ULL, 0x000fec0000205400ULL, 0x000000014d4d6812ULL, 0x004fe400078efcffULL,
0x0000005200857306ULL, 0x0003f0000020d400ULL, 0x0000004400a37306ULL, 0x000fe20000009400ULL,
0x0000010044527824ULL, 0x002fca00078e00ffULL, 0x00000018ff527819ULL, 0x000fe40000011452ULL,
0x0000004400a67306ULL, 0x000ff00000005400ULL, 0x0000004400757306ULL, 0x0003f0000000d400ULL,
0x0000004e004f7306ULL, 0x000ea2000020d400ULL, 0x0001000044447824ULL, 0x002fca00078e00ffULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x0000008200b87306ULL, 0x000ff00000209400ULL,
0x0000008200b27306ULL, 0x000e620000205400ULL, 0x000000014f4f0812ULL, 0x004fce00078efcffULL,
0x0000007d00b77306ULL, 0x000ff00000209400ULL, 0x0000007d00b37306ULL, 0x000ea20000205400ULL,
0x000000b2b800720bULL, 0x002fce0003f1d000ULL, 0x0000005000c87306ULL, 0x000ff00000009400ULL,
0x0000005000c77306ULL, 0x000e620000005400ULL, 0x000000b3b700720bULL, 0x004fce0003f9d000ULL,
0x0000005000867306ULL, 0x0004f0000000d400ULL, 0x0000005100717306ULL, 0x000fe20000009400ULL,
0x0001000050507824ULL, 0x004fe200078e00ffULL, 0x000000c7c800720bULL, 0x002fc80003fbd000ULL,
0x00000018ff507819ULL, 0x000fe40000011450ULL, 0x0000005100b97306ULL, 0x000e6e0000005400ULL,
0x0000000186865812ULL, 0x008fe200078efcffULL, 0x0000005100877306ULL, 0x0004e6000000d400ULL,
0x000000864f86723eULL, 0x000fca00000010ffULL, 0x0000005200c27306ULL, 0x000fe20000209400ULL,
0x0001000051517824ULL, 0x004fe200078e00ffULL, 0x000000b97100720bULL, 0x002fc80003fdd000ULL,
0x00000018ff517819ULL, 0x000fe40000011451ULL, 0x0000005200c37306ULL, 0x000fee0000205400ULL,
0x0000000187876812ULL, 0x008fe200078efcffULL, 0x00000052007f7306ULL, 0x0003e2000020d400ULL,
0x000000b6b500720bULL, 0x000fc40003fdd000ULL, 0x000000878a87723eULL, 0x000fca00000010ffULL,
0x0000004500a47306ULL, 0x000fe20000009400ULL, 0x0000010045527824ULL, 0x002fca00078e00ffULL,
0x00000018ff527819ULL, 0x000fe40000011452ULL, 0x00000045009f7306ULL, 0x000fe20000005400ULL,
0x000000017a7a6812ULL, 0x000fce00078efcffULL, 0x0000004500747306ULL, 0x0003f0000000d400ULL,
0x0000004400c07306ULL, 0x000fe20000209400ULL, 0x0001000045457824ULL, 0x002fca00078e00ffULL,
0x00000018ff457819ULL, 0x000fe40000011445ULL, 0x0000004400c17306ULL, 0x000ff00000205400ULL,
0x0000004400797306ULL, 0x0003f0000020d400ULL, 0x0000008200827306ULL, 0x000ea2000020d400ULL,
0x0000010046447824ULL, 0x002fca00078e00ffULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x0000007d007d7306ULL, 0x000e70000020d400ULL, 0x0000005300b17306ULL, 0x000fe20000009400ULL,
0x0000000182820812ULL, 0x004fce00078efcffULL, 0x0000005300b47306ULL, 0x000ea20000005400ULL,
0x000000017d7d4812ULL, 0x002fe400078efcffULL, 0x000000babb00720bULL, 0x000fca0003f9d000ULL,
0x0000008b00ca7306ULL, 0x000ff00000209400ULL, 0x0000008b00cb7306ULL, 0x000e620000205400ULL,
0x000000b4b100720bULL, 0x004fe40003f1d000ULL, 0x0000000185854812ULL, 0x000fc400078efcffULL,
0x000000c3c200720bULL, 0x000fc60003f9d000ULL, 0x0000005000e77306ULL, 0x000ff00000209400ULL,
0x0000005000e87306ULL, 0x000fe20000205400ULL, 0x000000cbca00720bULL, 0x002fe40003f7d000ULL,
0x000000017f7f4812ULL, 0x000fca00078efcffULL, 0x00000050004e7306ULL, 0x000ff0000020d400ULL,
0x0000005100ec7306ULL, 0x000ff00000209400ULL, 0x0000005100e97306ULL, 0x000e700000205400ULL,
0x0000005100507306ULL, 0x000eb0000020d400ULL, 0x0000007700ed7306ULL, 0x000fe20000209400ULL,
0x000000e9ec00720bULL, 0x002fce0003fbd000ULL, 0x0000007700ee7306ULL, 0x000fec0000205400ULL,
0x0000000150505812ULL, 0x004fe400078efcffULL, 0x0000007700517306ULL, 0x000ff0000020d400ULL,
0x0000007800ea7306ULL, 0x000ff00000209400ULL, 0x0000007800eb7306ULL, 0x000e700000205400ULL,
0x0000007800817306ULL, 0x000eb0000020d400ULL, 0x0000004500bc7306ULL, 0x000fe20000209400ULL,
0x000000ebea00720bULL, 0x002fce0003fbd000ULL, 0x0000004500bd7306ULL, 0x000fec0000205400ULL,
0x0000000181815812ULL, 0x004fe400078efcffULL, 0x0000004500777306ULL, 0x0003f0000020d400ULL,
0x0000004400ae7306ULL, 0x000fe20000209400ULL, 0x0000010047457824ULL, 0x002fca00078e00ffULL,
0x00000018ff457819ULL, 0x000fe40000011445ULL, 0x0000004400af7306ULL, 0x000ff00000205400ULL,
0x0000004400787306ULL, 0x0003f0000020d400ULL, 0x0000005300557306ULL, 0x0004e2000000d400ULL,
0x0000010048447824ULL, 0x002fca00078e00ffULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x0000004600a77306ULL, 0x000fe20000009400ULL, 0x0001000053537824ULL, 0x004fca00078e00ffULL,
0x00000018ff537819ULL, 0x000fe40000011453ULL, 0x0000004600a17306ULL, 0x000fe20000005400ULL,
0x0000000155550812ULL, 0x008fce00078efcffULL, 0x00000046006c7306ULL, 0x0003f0000000d400ULL,
0x0000004700917306ULL, 0x000fe20000009400ULL, 0x0001000046467824ULL, 0x002fca00078e00ffULL,
0x00000018ff467819ULL, 0x000fe40000011446ULL, 0x0000004700907306ULL, 0x000ff00000005400ULL,
0x0000004700657306ULL, 0x0003f0000000d400ULL, 0x0000008b008b7306ULL, 0x000ea2000020d400ULL,
0x0001000047477824ULL, 0x002fca00078e00ffULL, 0x00000018ff477819ULL, 0x000fe40000011447ULL,
0x0000007600a87306ULL, 0x000ff00000209400ULL, 0x0000007600a97306ULL, 0x000e620000205400ULL,
0x000000018b8b3812ULL, 0x004fc400078efcffULL, 0x000000e8e700720bULL, 0x000fe40003f7d000ULL,
0x0000004d8b4d723eULL, 0x000fc600000010ffULL, 0x0000004500957306ULL, 0x000ff00000209400ULL,
0x0000004500967306ULL, 0x000fe20000205400ULL, 0x000000a9a800720bULL, 0x002fe20003f1d000ULL,
0x000001004aa87824ULL, 0x000fe200078e00ffULL, 0x000000014e4e3812ULL, 0x000fe200078efcffULL,
0x000100004aa97824ULL, 0x000fe200078e00ffULL, 0x000000eeed00720bULL, 0x000fc40003f7d000ULL,
0x00000018ffa87819ULL, 0x000fe200000114a8ULL, 0x0000004500727306ULL, 0x0003e2000020d400ULL,
0x00000018ffa97819ULL, 0x000fce00000114a9ULL, 0x0000004400c67306ULL, 0x000fe20000209400ULL,
0x0000010049457824ULL, 0x002fe200078e00ffULL, 0x0000000151513812ULL, 0x000fe400078efcffULL,
0x000000a6a300720bULL, 0x000fe40003f7d000ULL, 0x00000018ffb87819ULL, 0x000fe40000011445ULL,
0x0000004400c77306ULL, 0x000fe20000205400ULL, 0x0000007a517a723eULL, 0x000fce00000010ffULL,
0x0000004400717306ULL, 0x0003e2000020d400ULL, 0x0000000175753812ULL, 0x000fce00078efcffULL,
0x0000005300c47306ULL, 0x000fe20000209400ULL, 0x0001280024447811ULL, 0x002fce00078e20ffULL,
0x0000005300c57306ULL, 0x000e700000205400ULL, 0x00000053007e7306ULL, 0x000eb0000020d400ULL,
0x0000005200bf7306ULL, 0x000fe20000209400ULL, 0x000000c5c400720bULL, 0x002fce0003fbd000ULL,
0x0000005200be7306ULL, 0x000e6c0000205400ULL, 0x000000017e7e5812ULL, 0x004fe400078efcffULL,
0x0000005200807306ULL, 0x000ea2000020d400ULL, 0x000000a1a700720bULL, 0x000fce0003fbd000ULL,
0x0000004600527306ULL, 0x000fe20000209400ULL, 0x000000bebf00720bULL, 0x002fca0003f7d000ULL,
0x000000016c6c5812ULL, 0x000fe400078efcffULL, 0x0000004600537306ULL, 0x000e6c0000205400ULL,
0x0000000180803812ULL, 0x004fe400078efcffULL, 0x0000004600737306ULL, 0x000ea2000020d400ULL,
0x000000909100720bULL, 0x000fce0003f7d000ULL, 0x0000004700ab7306ULL, 0x000fe20000209400ULL,
0x000000535200720bULL, 0x002fe40003fbd000ULL, 0x0000004e8252723eULL, 0x000fe400000010ffULL,
0x000000507d53723eULL, 0x000fe400000010ffULL, 0x0000000165653812ULL, 0x000fe200078efcffULL,
0x0000004700b07306ULL, 0x000e6c0000205400ULL, 0x0000000173735812ULL, 0x004fc400078efcffULL,
0x0000004700707306ULL, 0x0004f0000020d400ULL, 0x0000007600767306ULL, 0x000ee2000020d400ULL,
0x000000004444783bULL, 0x004ea20000000200ULL, 0x000000b0ab00720bULL, 0x002fcc0003f7d000ULL,
0x0000005700aa7306ULL, 0x000fee0000209400ULL, 0x0000000170703812ULL, 0x008fe200078efcffULL,
0x0000005700a07306ULL, 0x000e620000205400ULL, 0x0000000176760812ULL, 0x000fe400078efcffULL,
0x000000c1c000720bULL, 0x000fca0003f1d000ULL, 0x0000006e00a57306ULL, 0x000ff00000209400ULL,
0x0000006e00a27306ULL, 0x000ee20000205400ULL, 0x000000a0aa00720bULL, 0x002fe20003fdd000ULL,
0x000001004baa7824ULL, 0x000fe200078e00ffULL, 0x0000000179790812ULL, 0x000fe200078efcffULL,
0x000100004ba07824ULL, 0x000fc600078e00ffULL, 0x00000018ffaa7819ULL, 0x000fe200000114aaULL,
0x0000005700577306ULL, 0x000e62000020d400ULL, 0x000000194444a231ULL, 0x084fe200003400ffULL,
0x00000018ffa07819ULL, 0x000fe200000114a0ULL, 0x000000194646a231ULL, 0x000fe400003400ffULL,
0x0000001a4545a231ULL, 0x080fe400003400ffULL, 0x0000001a4747a231ULL, 0x000fe200003400ffULL,
0x0000006e006e7306ULL, 0x000ea2000020d400ULL, 0x000000a2a500720bULL, 0x008fca0003f9d000ULL,
0x000000524450723cULL, 0x040be40000041808ULL, 0x0000006a009a7306ULL, 0x000fe20000209400ULL,
0x0000000157576812ULL, 0x002fe400078efcffULL, 0x0000009fa400720bULL, 0x000fe40003fdd000ULL,
0x000000855708723eULL, 0x020fe200000010ffULL, 0x0000004c442c723cULL, 0x000fe2000004182cULL,
0x0000007e7609723eULL, 0x000fe200000010ffULL, 0x0000006a00997306ULL, 0x000e620000205400ULL,
0x000000016e6e4812ULL, 0x004fc400078efcffULL, 0x000000bdbc00720bULL, 0x000fe40003f9d000ULL,
0x000000757f0a723eULL, 0x000fe200000010ffULL, 0x00000086444c723cULL, 0x000be40000041828ULL,
0x0000006a006a7306ULL, 0x000ea2000020d400ULL, 0x0000000174746812ULL, 0x000fe400078efcffULL,
0x000000afae00720bULL, 0x000fe40003fdd000ULL, 0x00000074800b723eULL, 0x000fc600000010ffULL,
0x00000048008e7306ULL, 0x000fe20000009400ULL, 0x000000999a00720bULL, 0x002fe40003f1d000ULL,
0x0000000177774812ULL, 0x000fca00078efcffULL, 0x00000048008c7306ULL, 0x000e620000005400ULL,
0x0000000178786812ULL, 0x000fc800078efcffULL, 0x0000006c7828723eULL, 0x020fe400000010ffULL,
0x000000016a6a0812ULL, 0x004fe200078efcffULL, 0x00000048005f7306ULL, 0x0004e2000000d400ULL,
0x000000969500720bULL, 0x000fce0003f1d000ULL, 0x0000004a00547306ULL, 0x000fe20000009400ULL,
0x0001000048487824ULL, 0x004fe200078e00ffULL, 0x0000008c8e00720bULL, 0x002fe40003f9d000ULL,
0x00012800258c7811ULL, 0x000fe400078e20ffULL, 0x00000018ff487819ULL, 0x000fe40000011448ULL,
0x0000004a00567306ULL, 0x000e620000005400ULL, 0x0000000172720812ULL, 0x000fc800078efcffULL,
0x000000657229723eULL, 0x000fe400000010ffULL, 0x000000015f5f4812ULL, 0x008fe200078efcffULL,
0x0000004a005b7306ULL, 0x0004f0000000d400ULL, 0x0000004b00667306ULL, 0x000fe20000009400ULL,
0x0000009ead4a723eULL, 0x004fc400000010ffULL, 0x000000565400720bULL, 0x002fca0003f7d000ULL,
0x0000004b00677306ULL, 0x000ff00000005400ULL, 0x0000004b00427306ULL, 0x0003e2000000d400ULL,
0x000000015b5b3812ULL, 0x008fce00078efcffULL, 0x00000049007b7306ULL, 0x000fe20000009400ULL,
0x0000009cac4b723eULL, 0x002fce00000010ffULL, 0x00000049007c7306ULL, 0x000e620000005400ULL,
0x0000004a4438723cULL, 0x000b6e0000041838ULL, 0x00000049005d7306ULL, 0x0004e2000000d400ULL,
0x00000092934a723eULL, 0x020fe400000010ffULL, 0x0000008f944b723eULL, 0x000fca00000010ffULL,
0x0000004800a37306ULL, 0x000fe20000209400ULL, 0x0001000049497824ULL, 0x004fe200078e00ffULL,
0x0000007c7b00720bULL, 0x002fe40003fbd000ULL, 0x00000055817b723eULL, 0x000fe400000010ffULL,
0x00000018ffa17819ULL, 0x000fe40000011449ULL, 0x0000004800a67306ULL, 0x000fe20000205400ULL,
0x0000009b9749723eULL, 0x000fe400000010ffULL, 0x0000007a4454723cULL, 0x000fe80000041804ULL,
0x000000015d5d5812ULL, 0x008fe200078efcffULL, 0x00000048009f7306ULL, 0x0003f0000020d400ULL,
0x0000006800887306ULL, 0x000fe20000209400ULL, 0x0000009d9848723eULL, 0x002fce00000010ffULL,
0x0000006800897306ULL, 0x000e620000205400ULL, 0x000000484434723cULL, 0x040f6e0000041834ULL,
0x0000006000837306ULL, 0x000fe20000209400ULL, 0x0000004a4448723cULL, 0x040b640000041830ULL,
0x000000008c30783bULL, 0x020eaa0000000200ULL, 0x0000006000847306ULL, 0x000ee20000205400ULL,
0x000000898800720bULL, 0x002fe20003fdd000ULL, 0x000000084444723cULL, 0x000b6c0000041820ULL,
0x0000006800687306ULL, 0x000e62000020d400ULL, 0x000000796e20723eULL, 0x020fc400000010ffULL,
0x000000776a21723eULL, 0x000fca00000010ffULL, 0x0000006000607306ULL, 0x000ea2000020d400ULL,
0x000000848300720bULL, 0x008fce0003f1d000ULL, 0x000000b800b27306ULL, 0x000fe20000209400ULL,
0x0000000168686812ULL, 0x002fe400078efcffULL, 0x000000c7c600720bULL, 0x000fe40003fdd000ULL,
0x000000736868723eULL, 0x000fc600000010ffULL, 0x000000b800b37306ULL, 0x000e620000205400ULL,
0x0000000160600812ULL, 0x004fe200078efcffULL, 0x000000193030a231ULL, 0x080fe400003400ffULL,
0x000000193232a231ULL, 0x000fe400003400ffULL, 0x0000001a3131a231ULL, 0x080fe400003400ffULL,
0x000000b800b17306ULL, 0x000ea2000020d400ULL, 0x0000000171716812ULL, 0x000fe200078efcffULL,
0x0000001a3333a231ULL, 0x000fe200003400ffULL, 0x000000a6a300720bULL, 0x000fc40003fdd000ULL,
0x0000005f7104723eULL, 0x000fc600000010ffULL, 0x000000a100a27306ULL, 0x000fe20000209400ULL,
0x000000b3b200720bULL, 0x002fe20003f1d000ULL, 0x0000000a3008723cULL, 0x040b6c0000041838ULL,
0x000000a1009c7306ULL, 0x000e620000205400ULL, 0x000000019f9f6812ULL, 0x000fe200078efcffULL,
0x000000203020723cULL, 0x000b680000041834ULL, 0x00000001b1b10812ULL, 0x004fc400078efcffULL,
0x0000005e006d7306ULL, 0x000fe40000209400ULL, 0x0000005db105723eULL, 0x000fcc00000010ffULL,
0x0000005e006f7306ULL, 0x000ea20000205400ULL, 0x0000009ca200720bULL, 0x002fce0003f1d000ULL,
0x000000a100977306ULL, 0x000e70000020d400ULL, 0x0000005c00697306ULL, 0x000fe20000209400ULL,
0x0000006f6d00720bULL, 0x004fce0003f9d000ULL, 0x0000005c006b7306ULL, 0x000ea20000205400ULL,
0x0000000197970812ULL, 0x002fce00078efcffULL, 0x000000a8008f7306ULL, 0x000ff00000209400ULL,
0x000000a8008b7306ULL, 0x000e620000205400ULL, 0x0000006b6900720bULL, 0x004fe40003fbd000ULL,
0x000000706069723eULL, 0x000fca00000010ffULL, 0x000000aa00827306ULL, 0x000fe40000209400ULL,
0x00000068302c723cULL, 0x000b6c000004182cULL, 0x000000aa002a7306ULL, 0x000ea20000205400ULL,
0x0000008b8f00720bULL, 0x002fce0003fdd000ULL, 0x0000005e005e7306ULL, 0x000e70000020d400ULL,
0x0000005c005c7306ULL, 0x000ee2000020d400ULL, 0x0000002a8200720bULL, 0x004fe40003f1d000ULL,
0x000000283028723cULL, 0x000b6a0000041848ULL, 0x000000a800a87306ULL, 0x000ea2000020d400ULL,
0x000000015e5e4812ULL, 0x002fc400078efcffULL, 0x000000676600720bULL, 0x000fe40003f9d000ULL,
0x0000009f5e5e723eULL, 0x000fc600000010ffULL, 0x000000aa00aa7306ULL, 0x000e62000020d400ULL,
0x000000015c5c5812ULL, 0x008fc800078efcffULL, 0x000000975c5f723eULL, 0x000fc600000010ffULL,
0x0000005a00617306ULL, 0x000fe20000209400ULL, 0x00000001a8a86812ULL, 0x004fe400078efcffULL,
0x0000000142424812ULL, 0x000fe200078efcffULL, 0x0000005e3050723cULL, 0x000b620000041850ULL,
0x0000005ba8a8723eULL, 0x000fc600000010ffULL, 0x0000005a00627306ULL, 0x000ea20000205400ULL,
0x00000001aaaa0812ULL, 0x002fce00078efcffULL, 0x0000004100637306ULL, 0x000ff00000209400ULL,
0x0000004100647306ULL, 0x000e620000205400ULL, 0x000000626100720bULL, 0x004fce0003fbd000ULL,
0x000000a900067306ULL, 0x000ff00000209400ULL, 0x000000a900077306ULL, 0x000ea20000205400ULL,
0x000000646300720bULL, 0x002fce0003fdd000ULL, 0x000000a000387306ULL, 0x020ff00000209400ULL,
0x000000a000357306ULL, 0x000e620000205400ULL, 0x000000070600720bULL, 0x004fe40003f7d000ULL,
0x000000043004723cULL, 0x000b6a000004184cULL, 0x0000005a005a7306ULL, 0x000eb0000020d400ULL,
0x0000004100417306ULL, 0x000ee2000020d400ULL, 0x000000353800720bULL, 0x002fce0003f1d000ULL,
0x000000a900347306ULL, 0x000262000020d400ULL, 0x000000015a5a5812ULL, 0x004fce00078efcffULL,
0x000000a000a07306ULL, 0x000ea2000020d400ULL, 0x0000000141416812ULL, 0x008fe400078efcffULL,
0x00000042aaa9723eULL, 0x002fe400000010ffULL, 0x0000000134343812ULL, 0x000fca00078efcffULL,
0x000000a83054723cULL, 0x000b620000041854ULL, 0x000000345a34723eULL, 0x000fe400000010ffULL,
0x00000001a0a00812ULL, 0x004fc800078efcffULL, 0x000000a04135723eULL, 0x000fce00000010ffULL,
0x000000343030723cULL, 0x000b620000041844ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0186b800ff387f8cULL, 0x000e62000c80043fULL, 0x000000ffff3b7224ULL, 0x000fce00078e00ffULL,
0x0000000000347805ULL, 0x020fc40000015200ULL, 0x0186bc00ff367984ULL, 0x000ea40000000800ULL,
0x8000000036ff7812ULL, 0x006fe40007804839ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fcc0000015200ULL, 0x00000036343a7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003a00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403a00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003a36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013b3b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0186bc00ff367984ULL, 0x000e640000000800ULL,
0x8000000036ff7812ULL, 0x002fe40007804839ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000580010427a24ULL, 0x010fc800078e02ffULL, 0x0000008042427824ULL, 0x000fe200078e00ffULL,
0x0000045000009947ULL, 0x000fea0003800000ULL, 0x000000403c347810ULL, 0x000fe20007ffe0ffULL,
0x000000010f367824ULL, 0x000fe200078e021bULL, 0x000000021b477810ULL, 0x040fe40007ffe0ffULL,
0x000000340c357217ULL, 0x000fe20007800000ULL, 0x0000008000447824ULL, 0x000fe200078e0236ULL,
0x000000041b497810ULL, 0x000fe20007ffe0ffULL, 0x0000000136377824ULL, 0x000fe200078e0203ULL,
0x000000f016457812ULL, 0x000fe200078ec0ffULL, 0x0000001036467824ULL, 0x000fe200078e00ffULL,
0x00000042443a7210ULL, 0x0c0fe20007f1e0ffULL, 0x000000010f367824ULL, 0x000fe200078e0247ULL,
0x0000000244417810ULL, 0x000fe20007ffe0ffULL, 0x0000000135357824ULL, 0x000fe200078e0a34ULL,
0xfffffff046467812ULL, 0x000fe200078ee237ULL, 0x000000010f347824ULL, 0x040fe200078e0249ULL,
0x00000004443b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000136377824ULL, 0x140fe200078e0203ULL,
0x000000350f357217ULL, 0x000fe20007800000ULL, 0x0000001036487824ULL, 0x000fe200078e00ffULL,
0x000000423b3b7210ULL, 0x000fe20007f7e0ffULL, 0x0000000134367824ULL, 0x000fe200078e0203ULL,
0x0001400046467811ULL, 0x000fe200078e20ffULL, 0x00000010344a7824ULL, 0x000fe200078e00ffULL,
0xfffffff048487812ULL, 0x000fe200078ee237ULL, 0x000000ffff347224ULL, 0x000fe200000e06ffULL,
0x00005e003a397a11ULL, 0x000fe200078040ffULL, 0x0000000135377824ULL, 0x000fe200078e0a0fULL,
0xfffffff04a4a7812ULL, 0x000fe200078ee236ULL, 0x000000ffff357224ULL, 0x000fe200018e06ffULL,
0x00005f003a3a7a11ULL, 0x000fc400000f4434ULL, 0x0000004241417210ULL, 0x000fe40007f1e0ffULL,
0x000000371b00720cULL, 0x000fe40003f86070ULL, 0x00005e003b367a11ULL, 0x000fe200078a40ffULL,
0x000000ffff347224ULL, 0x000fe200000e06ffULL, 0x00005e0041387a11ULL, 0x000fe400078040ffULL,
0x00005f003b3b7a11ULL, 0x000fe400028f4435ULL, 0x00005f0041417a11ULL, 0x000fc400000f4434ULL,
0x0000004539347210ULL, 0x000fe40007f7e0ffULL, 0x000000374700720cULL, 0x080fe40003f06070ULL,
0x000000061b477810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff357224ULL, 0x000fe200018e063aULL,
0x0000000644397810ULL, 0x000fe40007ffe0ffULL, 0x000000374900720cULL, 0x000fe20003f66070ULL,
0x000000010f3a7824ULL, 0x000fe200078e0247ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000034467faeULL, 0x0003e2000e101c46ULL, 0x0000004239397210ULL, 0x000fc40007f9e0ffULL,
0x000000013a447824ULL, 0x000fe200078e0203ULL, 0x0000004536367210ULL, 0x080fe40007fde0ffULL,
0x0001400048487811ULL, 0x000fe400078e20ffULL, 0x000140004a4a7811ULL, 0x000fe400078e20ffULL,
0x0000004538347210ULL, 0x002fe20007fbe0ffULL, 0x000000103a467824ULL, 0x000fe400078e00ffULL,
0x000000ffff3a7224ULL, 0x000fe200020e06ffULL, 0x00005e0039387a11ULL, 0x000fe200078840ffULL,
0x000000ffff357224ULL, 0x000fe200028e0641ULL, 0x000000374700720cULL, 0x000fe20003fa6070ULL,
0x000000ffff377224ULL, 0x000fe200030e063bULL, 0x00005f0039397a11ULL, 0x000fc400020f443aULL,
0x0000004538387210ULL, 0x000fe20007f9e0ffULL, 0x0000000034487faeULL, 0x0003e2000c101c46ULL,
0xfffffff046447812ULL, 0x000fc600078ee244ULL, 0x000000ffff397224ULL, 0x000fe200020e0639ULL,
0x0001400044447811ULL, 0x000fe200078e20ffULL, 0x00000000364a7faeULL, 0x0003e8000d901c46ULL,
0x0000000038447faeULL, 0x0003e2000e901c46ULL, 0x0000038000007947ULL, 0x000fea0003800000ULL,
0x000000010f347824ULL, 0x000fc800078e021bULL, 0x0000000134357824ULL, 0x040fe200078e0203ULL,
0x0000000234367810ULL, 0x040fe20007ffe0ffULL, 0x0000001034387824ULL, 0x000fc800078e00ffULL,
0x0000000136377824ULL, 0x000fe200078e0203ULL, 0xfffffff038387812ULL, 0x000fe200078ee235ULL,
0x0000001036417824ULL, 0x000fe200078e00ffULL, 0x0000000434367810ULL, 0x000fe20007ffe0ffULL,
0x0000008000357824ULL, 0x000fc600078e0234ULL, 0xfffffff041417812ULL, 0x000fe200078ee237ULL,
0x0000000136397824ULL, 0x100fe200078e0203ULL, 0x0000000634377810ULL, 0x000fe20007ffe0ffULL,
0x0000001036477824ULL, 0x000fe200078e00ffULL, 0x0000004235347210ULL, 0x000fe40007f1e0ffULL,
0x0001400041417811ULL, 0x000fe200078e20ffULL, 0x00000001373a7824ULL, 0x000fe200078e0203ULL,
0xfffffff047477812ULL, 0x000fe200078ee239ULL, 0x00000010374b7824ULL, 0x000fe200078e00ffULL,
0x0000000235397810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff367224ULL, 0x000fe200000e06ffULL,
0x00005e0034377a11ULL, 0x000fc400078040ffULL, 0xfffffff04b4b7812ULL, 0x000fe400078ee23aULL,
0x00005f0034367a11ULL, 0x000fe400000f4436ULL, 0x0000000435347810ULL, 0x040fe40007ffe0ffULL,
0x0000000635357810ULL, 0x000fe40007ffe0ffULL, 0x0000004239397210ULL, 0x080fe40007f1e0ffULL,
0x0000004234447210ULL, 0x000fc40007f7e0ffULL, 0x000000f0163a7812ULL, 0x000fe400078ec0ffULL,
0x0000004235487210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff357224ULL, 0x000fe200000e06ffULL,
0x00005e00393b7a11ULL, 0x000fe200078040ffULL, 0x000000ffff457224ULL, 0x000fe200018e06ffULL,
0x0000003a37347210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff497224ULL, 0x000fe200028e06ffULL,
0x00005e0044467a11ULL, 0x000fe400078840ffULL, 0x00005e00484a7a11ULL, 0x000fc400078a40ffULL,
0x00005f0039397a11ULL, 0x000fe200000f4435ULL, 0x000000ffff357224ULL, 0x000fe200018e0636ULL,
0x0001400038377811ULL, 0x000fe400078e20ffULL, 0x0000003a3b367210ULL, 0x080fe40007f1e0ffULL,
0x00005f0044457a11ULL, 0x000fe200020f4445ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000034377faeULL, 0x0003e2000b901c46ULL, 0x0000003a46387210ULL, 0x000fe40007f7e0ffULL,
0x00005f0048497a11ULL, 0x000fc400028f4449ULL, 0x0000003a4a3a7210ULL, 0x000fe40007f9e0ffULL,
0x0001400047477811ULL, 0x000fe400078e20ffULL, 0x000140004b4b7811ULL, 0x000fe200078e20ffULL,
0x000000ffff3b7224ULL, 0x000fe400020e0649ULL, 0x000000ffff377224ULL, 0x002fe400000e0639ULL,
0x000000ffff397224ULL, 0x000fc600018e0645ULL, 0x0000000036417faeULL, 0x0003e8000b901c46ULL,
0x0000000038477faeULL, 0x0003e8000b901c46ULL, 0x000000003a4b7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0186a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0186a800ff347f8cULL, 0x000e64000c80043fULL, 0x000000ffff417224ULL, 0x002fc400078e0035ULL,
0x0000000000347805ULL, 0x000fca0000015200ULL, 0x0186b400ff367984ULL, 0x000e640000000800ULL,
0x8000000036ff7812ULL, 0x002fc40007804859ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff397224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103900780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fcc0000015200ULL,
0x0000003634387210ULL, 0x000fca0007f1e1ffULL, 0x0000000137377824ULL, 0x000fe200000e0e35ULL,
0x003d09003800780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403800780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff367819ULL, 0x000fc80000011437ULL, 0x0000003836367211ULL, 0x000fca00078110ffULL,
0x000000ffff377224ULL, 0x000fca00000e0637ULL, 0x0000000236367819ULL, 0x000fc80000001237ULL,
0x000000360000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000139397810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0186b400ff367984ULL, 0x000e640000000800ULL, 0x8000000036ff7812ULL, 0x002fe40007804859ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000016000007945ULL, 0x000fe20003800000ULL,
0x0000014000002947ULL, 0x000fea0003800000ULL, 0x00000018ff19723eULL, 0x000fe400000010ffULL,
0x00000002ff347819ULL, 0x000fe40000011603ULL, 0x00005410195e7816ULL, 0x000fe20000000019ULL,
0x000170427f007947ULL, 0x000fea000b800000ULL, 0x00001f345e197589ULL, 0x0002a400000e0000ULL,
0x00000008341a7810ULL, 0x000fe20007ffe0ffULL, 0x000170827f007947ULL, 0x000fea000b800000ULL,
0x00001f1a5e1a7589ULL, 0x00066400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x0000001034477810ULL, 0x000fe20007ffe0ffULL, 0x0000001fff457424ULL, 0x000fe200078e00ffULL,
0x0000b7b000447802ULL, 0x000fe20000000f00ULL, 0xffffffffff467424ULL, 0x000fc400078e00ffULL,
0x00017d7000007944ULL, 0x00efea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x0000001834477810ULL, 0x000fe20007ffe0ffULL, 0x0000001fff457424ULL, 0x000fe200078e00ffULL,
0x0000b81000447802ULL, 0x000fe20000000f00ULL, 0xffffffffff467424ULL, 0x004fc400078e00ffULL,
0x00017d1000007944ULL, 0x00afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000128003fb97811ULL, 0x000fc400078e20ffULL,
0x000000003e48783bULL, 0x000f280000004200ULL, 0x000000003d44783bULL, 0x004ea80000004200ULL,
0x000000002734783bULL, 0x002e680000004200ULL, 0x000000002638783bULL, 0x000ee20000004200ULL,
0x00000048008f7306ULL, 0x010fe20000009400ULL, 0x00000018ff9d7819ULL, 0x000fe20000011448ULL,
0x00000100485a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff9c7819ULL, 0x000fe20000011449ULL,
0x00000100496c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff8e7819ULL, 0x000fc4000001144aULL,
0x00000018ffae7819ULL, 0x000fe2000001145aULL, 0x0000004800947306ULL, 0x000f220000005400ULL,
0x00000018ff6c7819ULL, 0x000fe4000001146cULL, 0x00000018ff8b7819ULL, 0x000fe4000001144bULL,
0x00000018ff7f7819ULL, 0x004fe40000011444ULL, 0x00000018ff7b7819ULL, 0x000fe20000011445ULL,
0x0000004800a67306ULL, 0x0004e2000000d400ULL, 0x00000018ff6a7819ULL, 0x002fc40000011434ULL,
0x00000018ff767819ULL, 0x000fe40000011446ULL, 0x00000018ff647819ULL, 0x000fe40000011435ULL,
0x00000018ff6d7819ULL, 0x000fe20000011447ULL, 0x0000009d00d17306ULL, 0x000fe20000209400ULL,
0x0001000048487824ULL, 0x004fe200078e00ffULL, 0x000000948f00720bULL, 0x010fe40003fbd000ULL,
0x00000018ff627819ULL, 0x000fe40000011436ULL, 0x00000018ff487819ULL, 0x000fc40000011448ULL,
0x0000009d00d27306ULL, 0x000e620000205400ULL, 0x00000018ff5c7819ULL, 0x000fe40000011437ULL,
0x00000018ff597819ULL, 0x008fe40000011438ULL, 0x00000018ff4f7819ULL, 0x000fe40000011439ULL,
0x00000001a6a65812ULL, 0x000fe200078efcffULL, 0x00000049006f7306ULL, 0x000fe20000009400ULL,
0x00000018ff4d7819ULL, 0x000fe4000001143aULL, 0x00000018ff4c7819ULL, 0x000fca000001143bULL,
0x0000004900d07306ULL, 0x000fe20000005400ULL, 0x000000d2d100720bULL, 0x002fce0003f7d000ULL,
0x0000004900a47306ULL, 0x0003f0000000d400ULL, 0x0000004800d57306ULL, 0x000fe20000209400ULL,
0x0001000049497824ULL, 0x002fca00078e00ffULL, 0x00000018ff497819ULL, 0x000fe40000011449ULL,
0x0000004800d47306ULL, 0x000e700000205400ULL, 0x0000004800a57306ULL, 0x0004f0000020d400ULL,
0x0000006c00d67306ULL, 0x000fe20000209400ULL, 0x000001004a487824ULL, 0x004fe200078e00ffULL,
0x000000d4d500720bULL, 0x002fc80003f1d000ULL, 0x00000018ff487819ULL, 0x000fe40000011448ULL,
0x0000006c00d77306ULL, 0x000e6e0000205400ULL, 0x00000001a5a50812ULL, 0x008fe200078efcffULL,
0x0000009d009d7306ULL, 0x000eb0000020d400ULL, 0x000000ae005a7306ULL, 0x000fe20000209400ULL,
0x000000d7d600720bULL, 0x002fce0003f9d000ULL, 0x000000ae00d37306ULL, 0x000e620000205400ULL,
0x000000019d9d3812ULL, 0x004fce00078efcffULL, 0x0000004900d87306ULL, 0x000ff00000209400ULL,
0x0000004900d97306ULL, 0x000ea20000205400ULL, 0x000000d35a00720bULL, 0x002fce0003fdd000ULL,
0x0000004800da7306ULL, 0x000ff00000209400ULL, 0x0000004800db7306ULL, 0x000e620000205400ULL,
0x000000d9d800720bULL, 0x004fce0003fbd000ULL, 0x0000006c00ad7306ULL, 0x000eb0000020d400ULL,
0x0000004a00ce7306ULL, 0x000fe20000009400ULL, 0x000000dbda00720bULL, 0x002fce0003f7d000ULL,
0x0000004a00b17306ULL, 0x000e620000005400ULL, 0x00000001adad4812ULL, 0x004fce00078efcffULL,
0x0000004900a37306ULL, 0x0004f0000020d400ULL, 0x0000004b006b7306ULL, 0x000fe20000009400ULL,
0x000001004b497824ULL, 0x004fe200078e00ffULL, 0x000000b1ce00720bULL, 0x002fc80003f9d000ULL,
0x00000018ff497819ULL, 0x000fe40000011449ULL, 0x0000004b00cd7306ULL, 0x000e620000005400ULL,
0x00000001a3a35812ULL, 0x008fce00078efcffULL, 0x0000004b00937306ULL, 0x0004f0000000d400ULL,
0x000000ae00ae7306ULL, 0x000f22000020d400ULL, 0x000100004b4b7824ULL, 0x004fe200078e00ffULL,
0x000000cd6b00720bULL, 0x002fc80003fbd000ULL, 0x00000018ff4b7819ULL, 0x000fe4000001144bULL,
0x0000004800987306ULL, 0x0002ae000020d400ULL, 0x0000000193935812ULL, 0x008fe200078efcffULL,
0x0000009c00a27306ULL, 0x000fe20000209400ULL, 0x0000010044487824ULL, 0x002fe200078e00ffULL,
0x00000001aeae6812ULL, 0x010fc400078efcffULL, 0x000000d06f00720bULL, 0x000fe40003fdd000ULL,
0x00000018ff487819ULL, 0x000fe40000011448ULL, 0x0000009c00cf7306ULL, 0x000e620000205400ULL,
0x0000000198983812ULL, 0x004fce00078efcffULL, 0x0000008e00ca7306ULL, 0x000fe20000209400ULL,
0x00000001a4a46812ULL, 0x000fce00078efcffULL, 0x0000008e00c47306ULL, 0x000ea20000205400ULL,
0x000000cfa200720bULL, 0x002fce0003f1d000ULL, 0x0000004a00977306ULL, 0x0002f0000000d400ULL,
0x0000004400c67306ULL, 0x000fe20000009400ULL, 0x000100004a4a7824ULL, 0x002fe200078e00ffULL,
0x000000c4ca00720bULL, 0x004fc80003f7d000ULL, 0x00000018ff4a7819ULL, 0x000fe4000001144aULL,
0x0000004400c77306ULL, 0x000fe20000005400ULL, 0x0000000197974812ULL, 0x008fce00078efcffULL,
0x0000004400867306ULL, 0x0003f0000000d400ULL, 0x0000004b00e17306ULL, 0x000fe20000209400ULL,
0x0001000044447824ULL, 0x002fca00078e00ffULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x0000004b00e07306ULL, 0x000e700000205400ULL, 0x0000004900dd7306ULL, 0x000ff00000209400ULL,
0x0000004900dc7306ULL, 0x000ea20000205400ULL, 0x000000e0e100720bULL, 0x002fce0003f9d000ULL,
0x0000004900997306ULL, 0x0002f0000020d400ULL, 0x0000009c009c7306ULL, 0x000f22000020d400ULL,
0x0000010045497824ULL, 0x002fe200078e00ffULL, 0x000000dcdd00720bULL, 0x004fc80003fdd000ULL,
0x00000018ff497819ULL, 0x000fe40000011449ULL, 0x0000008e008e7306ULL, 0x000e6e000020d400ULL,
0x0000000199996812ULL, 0x008fe200078efcffULL, 0x0000004500c57306ULL, 0x000fe20000009400ULL,
0x000000019c9c0812ULL, 0x010fce00078efcffULL, 0x0000004500707306ULL, 0x000ea20000005400ULL,
0x000000018e8e3812ULL, 0x002fce00078efcffULL, 0x0000004a00de7306ULL, 0x000ff00000209400ULL,
0x0000004a00df7306ULL, 0x000e620000205400ULL, 0x00000070c500720bULL, 0x004fce0003f7d000ULL,
0x0000004800e37306ULL, 0x000ff00000209400ULL, 0x0000004800e27306ULL, 0x000ea20000205400ULL,
0x000000dfde00720bULL, 0x002fce0003f1d000ULL, 0x0000004400e67306ULL, 0x000ff00000209400ULL,
0x0000004400e77306ULL, 0x000fe20000205400ULL, 0x000000e2e300720bULL, 0x004fce0003fbd000ULL,
0x00000044008a7306ULL, 0x0003f0000020d400ULL, 0x0000004b008d7306ULL, 0x000ea2000020d400ULL,
0x0000010046447824ULL, 0x002fca00078e00ffULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x0000004900e47306ULL, 0x000ff00000209400ULL, 0x0000004900e57306ULL, 0x000e620000205400ULL,
0x000000018d8d4812ULL, 0x004fce00078efcffULL, 0x0000004500837306ULL, 0x0004f0000000d400ULL,
0x0000004a00907306ULL, 0x0008e2000020d400ULL, 0x0001000045457824ULL, 0x004fe200078e00ffULL,
0x000000e5e400720bULL, 0x002fc80003f9d000ULL, 0x00000018ff457819ULL, 0x000fe40000011445ULL,
0x00000048008c7306ULL, 0x000e62000020d400ULL, 0x00000100354a7824ULL, 0x010fe200078e00ffULL,
0x0000000183833812ULL, 0x008fc800078efcffULL, 0x00000018ff4a7819ULL, 0x000fe4000001144aULL,
0x0000008b00cb7306ULL, 0x000fe20000209400ULL, 0x0000000190900812ULL, 0x000fe400078efcffULL,
0x000000c7c600720bULL, 0x000fca0003f1d000ULL, 0x0000008b00cc7306ULL, 0x000ea20000205400ULL,
0x000000018c8c5812ULL, 0x002fce00078efcffULL, 0x0000007f00c37306ULL, 0x000fe20000209400ULL,
0x0000000186860812ULL, 0x000fc800078efcffULL, 0x000000868c86723eULL, 0x000fc600000010ffULL,
0x0000007f00c27306ULL, 0x000e620000205400ULL, 0x000000cccb00720bULL, 0x004fce0003fdd000ULL,
0x0000004400ec7306ULL, 0x000ff00000209400ULL, 0x0000004400ed7306ULL, 0x000ea20000205400ULL,
0x000000c2c300720bULL, 0x002fce0003fbd000ULL, 0x0000004900897306ULL, 0x0002f0000020d400ULL,
0x0000003400b47306ULL, 0x000fe20000009400ULL, 0x0000010034497824ULL, 0x002fe200078e00ffULL,
0x000000edec00720bULL, 0x004fc80003f7d000ULL, 0x00000018ff497819ULL, 0x000fe40000011449ULL,
0x0000003400b27306ULL, 0x000fe20000005400ULL, 0x0000000189894812ULL, 0x008fce00078efcffULL,
0x00000034006e7306ULL, 0x0003f0000000d400ULL, 0x0000007b00bd7306ULL, 0x000fe20000209400ULL,
0x0001000034347824ULL, 0x002fca00078e00ffULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000007b00b87306ULL, 0x000e700000205400ULL, 0x0000004500e97306ULL, 0x000ff00000209400ULL,
0x0000004500e87306ULL, 0x000ea20000205400ULL, 0x000000b8bd00720bULL, 0x002fce0003f9d000ULL,
0x0000004500847306ULL, 0x0002f0000020d400ULL, 0x0000004600bc7306ULL, 0x000fe20000009400ULL,
0x0000010047457824ULL, 0x002fe200078e00ffULL, 0x000000e8e900720bULL, 0x004fc80003f1d000ULL,
0x00000018ff457819ULL, 0x000fe40000011445ULL, 0x0000004600797306ULL, 0x000fee0000005400ULL,
0x0000000184840812ULL, 0x008fe200078efcffULL, 0x00000046007a7306ULL, 0x0003f0000000d400ULL,
0x0000003500a87306ULL, 0x000fe20000009400ULL, 0x0001000046467824ULL, 0x002fca00078e00ffULL,
0x00000018ff467819ULL, 0x000fe40000011446ULL, 0x0000003500aa7306ULL, 0x000ff00000005400ULL,
0x0000003500677306ULL, 0x0003f0000000d400ULL, 0x0000008b008b7306ULL, 0x000ea2000020d400ULL,
0x0001000035357824ULL, 0x002fca00078e00ffULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x0000007f007f7306ULL, 0x000e70000020d400ULL, 0x0000004400857306ULL, 0x000ee2000020d400ULL,
0x000000018b8b6812ULL, 0x004fc400078efcffULL, 0x000000e7e600720bULL, 0x000fca0003fdd000ULL,
0x0000004700ba7306ULL, 0x000fe20000009400ULL, 0x000000017f7f5812ULL, 0x002fce00078efcffULL,
0x0000004700bb7306ULL, 0x000e620000005400ULL, 0x0000000185853812ULL, 0x008fe400078efcffULL,
0x000000b2b400720bULL, 0x000fe40003f7d000ULL, 0x000000018a8a6812ULL, 0x000fe400078efcffULL,
0x00000079bc00720bULL, 0x000fe20003fdd000ULL, 0x0000004700747306ULL, 0x0004e2000000d400ULL,
0x0000008a7f8a723eULL, 0x000fce00000010ffULL, 0x0000003400be7306ULL, 0x000fe20000209400ULL,
0x0001000047477824ULL, 0x004fe200078e00ffULL, 0x000000bbba00720bULL, 0x002fe40003fbd000ULL,
0x000000016e6e3812ULL, 0x000fe400078efcffULL, 0x00000018ff487819ULL, 0x000fe40000011447ULL,
0x0000003400bf7306ULL, 0x000fe20000205400ULL, 0x000000017a7a6812ULL, 0x000fc800078efcffULL,
0x0000007a857a723eULL, 0x000fe400000010ffULL, 0x0000000174745812ULL, 0x008fe200078efcffULL,
0x0000003400777306ULL, 0x0003f0000020d400ULL, 0x0000007b007b7306ULL, 0x000ea2000020d400ULL,
0x0000010036347824ULL, 0x002fca00078e00ffULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000004500ea7306ULL, 0x000ff00000209400ULL, 0x0000004500eb7306ULL, 0x000e620000205400ULL,
0x000000017b7b4812ULL, 0x004fce00078efcffULL, 0x00000045007e7306ULL, 0x000eb0000020d400ULL,
0x0000004600447306ULL, 0x000fe20000209400ULL, 0x000000ebea00720bULL, 0x002fce0003f1d000ULL,
0x0000004600457306ULL, 0x000e6c0000205400ULL, 0x000000017e7e0812ULL, 0x004fe400078efcffULL,
0x0000003500af7306ULL, 0x000ff00000209400ULL, 0x0000003500b07306ULL, 0x000fe20000205400ULL,
0x000000454400720bULL, 0x002fc40003f9d000ULL, 0x0001280040447811ULL, 0x000fca00078e20ffULL,
0x0000003500717306ULL, 0x0003f0000020d400ULL, 0x0000004600827306ULL, 0x000ea2000020d400ULL,
0x0000010037357824ULL, 0x002fca00078e00ffULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x0000003600ac7306ULL, 0x000ff00000009400ULL, 0x0000003600a77306ULL, 0x000fe20000005400ULL,
0x0000000182824812ULL, 0x004fce00078efcffULL, 0x0000003600637306ULL, 0x0003f0000000d400ULL,
0x00000037009f7306ULL, 0x000fe20000009400ULL, 0x0001000036367824ULL, 0x002fca00078e00ffULL,
0x00000018ff367819ULL, 0x000fe40000011436ULL, 0x00000037009e7306ULL, 0x000ff00000005400ULL,
0x0000003700617306ULL, 0x0003f0000000d400ULL, 0x0000004800467306ULL, 0x000fe20000209400ULL,
0x0001000037377824ULL, 0x002fca00078e00ffULL, 0x00000018ff377819ULL, 0x000fe40000011437ULL,
0x0000004800477306ULL, 0x000e700000205400ULL, 0x0000004a00c07306ULL, 0x000ff00000209400ULL,
0x0000004a00c17306ULL, 0x000ea20000205400ULL, 0x000000474600720bULL, 0x002fc40003fbd000ULL,
0x000000004444783bULL, 0x000e6a0000000200ULL, 0x00000034009a7306ULL, 0x000ff00000209400ULL,
0x00000034009b7306ULL, 0x000fe20000205400ULL, 0x000000c1c000720bULL, 0x004fce0003f7d000ULL,
0x0000003400727306ULL, 0x0005f0000020d400ULL, 0x0000003500917306ULL, 0x000fe20000209400ULL,
0x0000010038347824ULL, 0x004fca00078e00ffULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000003500927306ULL, 0x000fe20000205400ULL, 0x000000194444a231ULL, 0x082fe400003400ffULL,
0x000000194646a231ULL, 0x000fe400003400ffULL, 0x0000001a4545a231ULL, 0x000fc600003400ffULL,
0x00000035006c7306ULL, 0x0003e2000020d400ULL, 0x0000001a4747a231ULL, 0x000fce00003400ffULL,
0x00000036008f7306ULL, 0x000fe20000209400ULL, 0x0000010039357824ULL, 0x002fca00078e00ffULL,
0x00000018ffc37819ULL, 0x000fe40000011435ULL, 0x0000003600947306ULL, 0x000ff00000205400ULL,
0x00000036006f7306ULL, 0x000ff0000020d400ULL, 0x0000003700a27306ULL, 0x000ff00000209400ULL,
0x0000003700b17306ULL, 0x000ff00000205400ULL, 0x00000037006b7306ULL, 0x000ff0000020d400ULL,
0x0000003400c47306ULL, 0x000ff00000209400ULL, 0x0000003400c67306ULL, 0x000ff00000205400ULL,
0x0000003400707306ULL, 0x0003f0000020d400ULL, 0x0000004a00787306ULL, 0x000ea2000020d400ULL,
0x00000000b934783bULL, 0x0022ee0000000200ULL, 0x0000007600b77306ULL, 0x000fe20000209400ULL,
0x000001003bb97824ULL, 0x002fca00078e00ffULL, 0x00000018ffb97819ULL, 0x000fe400000114b9ULL,
0x0000007600b37306ULL, 0x000e620000205400ULL, 0x0000000178783812ULL, 0x004fce00078efcffULL,
0x0000006d00b57306ULL, 0x000ff00000209400ULL, 0x0000006d00b67306ULL, 0x000ea20000205400ULL,
0x000000b3b700720bULL, 0x002fe20003fdd000ULL, 0x000100003ab77824ULL, 0x000fca00078e00ffULL,
0x00000018ffb77819ULL, 0x000fe200000114b7ULL, 0x0000006400967306ULL, 0x000fe20000209400ULL,
0x000000193434a231ULL, 0x088fe400003400ffULL, 0x000000193636a231ULL, 0x000fe400003400ffULL,
0x0000001a3535a231ULL, 0x080fe400003400ffULL, 0x0000001a3737a231ULL, 0x000fe200003400ffULL,
0x0000006400957306ULL, 0x000e620000205400ULL, 0x000000b6b500720bULL, 0x004fe20003f1d000ULL,
0x000001003ab67824ULL, 0x000fe200078e00ffULL, 0x0000009b9a00720bULL, 0x000fe20003f5d000ULL,
0x000100003bb57824ULL, 0x000fc600078e00ffULL, 0x00000018ffb67819ULL, 0x000fe200000114b6ULL,
0x0000004900c87306ULL, 0x000fe20000209400ULL, 0x00000018ffb57819ULL, 0x000fce00000114b5ULL,
0x0000004900c97306ULL, 0x000ea20000205400ULL, 0x000000959600720bULL, 0x002fe40003f7d000ULL,
0x0000000172722812ULL, 0x000fe400078efcffULL, 0x000000948f00720bULL, 0x000fc60003f5d000ULL,
0x0000007600767306ULL, 0x000e70000020d400ULL, 0x0000006d006d7306ULL, 0x000ee2000020d400ULL,
0x000000c9c800720bULL, 0x004fe40003f9d000ULL, 0x000000016f6f2812ULL, 0x000fca00078efcffULL,
0x0000006400647306ULL, 0x000ea2000020d400ULL, 0x0000000176766812ULL, 0x002fe400078efcffULL,
0x000000aaa800720bULL, 0x000fe40003fdd000ULL, 0x000000827682723eULL, 0x000fc600000010ffULL,
0x0000004800487306ULL, 0x000e62000020d400ULL, 0x000000016d6d0812ULL, 0x008fe400078efcffULL,
0x000000bfbe00720bULL, 0x000fca0003f1d000ULL, 0x0000004900497306ULL, 0x000ee2000020d400ULL,
0x0000000164643812ULL, 0x004fe400078efcffULL, 0x000000929100720bULL, 0x000fe40003f7d000ULL,
0x0000000167676812ULL, 0x000fe400078efcffULL, 0x000000b0af00720bULL, 0x000fe20003fdd000ULL,
0x0000006a00a97306ULL, 0x000fe20000209400ULL, 0x0000000148485812ULL, 0x002fe400078efcffULL,
0x0000000177770812ULL, 0x000fc400078efcffULL, 0x0000009e9f00720bULL, 0x000fc60003f1d000ULL,
0x0000006a00ab7306ULL, 0x000e620000205400ULL, 0x0000000149494812ULL, 0x008fe400078efcffULL,
0x000000a7ac00720bULL, 0x000fe40003f9d000ULL, 0x000000016c6c3812ULL, 0x000fe400078efcffULL,
0x0000000171716812ULL, 0x000fe200078efcffULL, 0x0000006a006a7306ULL, 0x000ea4000020d400ULL,
0x0000000161610812ULL, 0x000fc400078efcffULL, 0x000000b1a200720bULL, 0x000fc80003f1d000ULL,
0x0000003800a07306ULL, 0x000fe20000009400ULL, 0x000000aba900720bULL, 0x002fe40003fbd000ULL,
0x0000000163634812ULL, 0x000fca00078efcffULL, 0x0000003800a17306ULL, 0x000e620000005400ULL,
0x000000016b6b0812ULL, 0x000fca00078efcffULL, 0x000000016a6a5812ULL, 0x004fe400078efcffULL,
0x0000006200807306ULL, 0x000ff00000209400ULL, 0x0000006200817306ULL, 0x000ea20000205400ULL,
0x000000a1a000720bULL, 0x002fce0003fbd000ULL, 0x0000005c007c7306ULL, 0x000ff00000209400ULL,
0x0000005c007d7306ULL, 0x000e620000205400ULL, 0x000000818000720bULL, 0x004fce0003f9d000ULL,
0x00000038005b7306ULL, 0x0004f0000000d400ULL, 0x0000003900877306ULL, 0x000fe20000009400ULL,
0x0001000038387824ULL, 0x004fe200078e00ffULL, 0x0000007d7c00720bULL, 0x002fc80003f7d000ULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000003900887306ULL, 0x000e620000005400ULL,
0x000000015b5b5812ULL, 0x008fce00078efcffULL, 0x0000003900587306ULL, 0x0004f0000000d400ULL,
0x0000003a00737306ULL, 0x000fe20000009400ULL, 0x0001000039397824ULL, 0x004fe200078e00ffULL,
0x000000888700720bULL, 0x002fc40003fdd000ULL, 0x000000838987723eULL, 0x000fe400000010ffULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000003a00757306ULL, 0x000e620000005400ULL,
0x000000486d83723eULL, 0x000fe400000010ffULL, 0x000000863404723cULL, 0x000fe80000041804ULL,
0x0000000158586812ULL, 0x008fe200078efcffULL, 0x0000003a004e7306ULL, 0x0004f0000000d400ULL,
0x0000003b004a7306ULL, 0x000fe20000009400ULL, 0x000000a6ae3a723eULL, 0x004fc400000010ffULL,
0x000000757300720bULL, 0x002fca0003f5d000ULL, 0x0000003b004b7306ULL, 0x000e700000005400ULL,
0x0000003b005a7306ULL, 0x0005e2000000d400ULL, 0x000000014e4e2812ULL, 0x008fce00078efcffULL,
0x0000006200627306ULL, 0x000ee2000020d400ULL, 0x000000a4ad3b723eULL, 0x004fe400000010ffULL,
0x0000004b4a00720bULL, 0x002fca0003f1d000ULL, 0x0000005c005c7306ULL, 0x000e62000020d400ULL,
0x0000003a3408723cULL, 0x000b6e0000041808ULL, 0x000000c300c27306ULL, 0x000fe20000209400ULL,
0x00000093993b723eULL, 0x020fe400000010ffULL, 0x0000000162624812ULL, 0x008fc400078efcffULL,
0x000000c6c400720bULL, 0x000fe40003f9d000ULL, 0x00000097983a723eULL, 0x000fe200000010ffULL,
0x000000c300b87306ULL, 0x000ea20000205400ULL, 0x000000015c5c3812ULL, 0x002fe400078efcffULL,
0x000000015a5a0812ULL, 0x000fe400078efcffULL, 0x0000006f6262723eULL, 0x000fe200000010ffULL,
0x0000003a3428723cULL, 0x000fe40000041828ULL, 0x0000003800b47306ULL, 0x000fe40000209400ULL,
0x0000000170704812ULL, 0x000fcc00078efcffULL, 0x0000003800b37306ULL, 0x000e620000205400ULL,
0x000000b8c200720bULL, 0x004fce0003f7d000ULL, 0x0000003800b27306ULL, 0x0004f0000020d400ULL,
0x0000003900a87306ULL, 0x000fe20000209400ULL, 0x000000a59d38723eULL, 0x004fe400000010ffULL,
0x000000b3b400720bULL, 0x002fca0003fbd000ULL, 0x0000003900a47306ULL, 0x000ff00000205400ULL,
0x00000039009e7306ULL, 0x0003e2000020d400ULL, 0x00000001b2b25812ULL, 0x008fce00078efcffULL,
0x000000c300797306ULL, 0x000ea2000020d400ULL, 0x000000a39c39723eULL, 0x002fce00000010ffULL,
0x000000383420723cULL, 0x000b620000041820ULL, 0x0000005900687306ULL, 0x000fec0000209400ULL,
0x000000908e38723eULL, 0x020fe400000010ffULL, 0x0000008d8b39723eULL, 0x000fe200000010ffULL,
0x0000005900697306ULL, 0x000e620000205400ULL, 0x000000847b8b723eULL, 0x000fc400000010ffULL,
0x000000747e7b723eULL, 0x000fe400000010ffULL, 0x0000000179793812ULL, 0x004fe200078efcffULL,
0x00000038342c723cULL, 0x040b62000004182cULL, 0x000000a4a800720bULL, 0x000fe20003f7d000ULL,
0x0000004f00657306ULL, 0x000fea0000209400ULL, 0x0000006e4938723eULL, 0x020fe200000010ffULL,
0x0000008a3450723cULL, 0x000f620000041850ULL, 0x000000677839723eULL, 0x000fe200000010ffULL,
0x0000004f00667306ULL, 0x000ea20000205400ULL, 0x000000696800720bULL, 0x002fc60003f9d000ULL,
0x000000019e9e3812ULL, 0x000fe400078efcffULL, 0x000000384438723cULL, 0x000fe40000041808ULL,
0x000000b600957306ULL, 0x000fec0000209400ULL, 0x0000007a3454723cULL, 0x000f640000041854ULL,
0x000000b600937306ULL, 0x000e620000205400ULL, 0x000000666500720bULL, 0x004fca0003fdd000ULL,
0x000000823448723cULL, 0x000b640000041830ULL, 0x0000005900597306ULL, 0x000eaa000020d400ULL,
0x000000776a34723eULL, 0x020fe400000010ffULL, 0x000000716435723eULL, 0x000fe200000010ffULL,
0x0000004f004f7306ULL, 0x000ee2000020d400ULL, 0x000000939500720bULL, 0x002fc40003fbd000ULL,
0x000000637230723eULL, 0x000fe400000010ffULL, 0x000000616c31723eULL, 0x000fe200000010ffULL,
0x000000344434723cULL, 0x000f620000041820ULL, 0x0000006b5c63723eULL, 0x000fe200000010ffULL,
0x000000b600b67306ULL, 0x000e62000020d400ULL, 0x0000000159594812ULL, 0x004fca00078efcffULL,
0x000000304430723cULL, 0x000b640000041828ULL, 0x0000004d00607306ULL, 0x000fe20000209400ULL,
0x000000014f4f6812ULL, 0x008fc800078efcffULL, 0x0000005b7028723eULL, 0x020fe200000010ffULL,
0x00000062442c723cULL, 0x000f62000004182cULL, 0x000000587929723eULL, 0x000fe200000010ffULL,
0x0000004d005f7306ULL, 0x000ea20000205400ULL, 0x00000001b6b65812ULL, 0x002fca00078efcffULL,
0x000000284428723cULL, 0x000b640000041804ULL, 0x0000004c005d7306ULL, 0x000fea0000209400ULL,
0x0000004eb604723eULL, 0x020fc600000010ffULL, 0x0000004c005e7306ULL, 0x000e620000205400ULL,
0x0000005f6000720bULL, 0x004fce0003f9d000ULL, 0x000000b900887306ULL, 0x000ff00000209400ULL,
0x000000b9007c7306ULL, 0x000ea20000205400ULL, 0x0000005e5d00720bULL, 0x002fce0003f7d000ULL,
0x000000b7006d7306ULL, 0x000ff00000209400ULL, 0x000000b700677306ULL, 0x000e620000205400ULL,
0x0000007c8800720bULL, 0x004fce0003fdd000ULL, 0x000000b500087306ULL, 0x000ff00000209400ULL,
0x000000b500097306ULL, 0x000ea20000205400ULL, 0x000000676d00720bULL, 0x002fce0003fbd000ULL,
0x0000004d004d7306ULL, 0x000e70000020d400ULL, 0x0000004c004c7306ULL, 0x000ee2000020d400ULL,
0x000000090800720bULL, 0x004fe40003f5d000ULL, 0x000000b25908723eULL, 0x000fc400000010ffULL,
0x0000009e4f09723eULL, 0x000fc600000010ffULL, 0x000000b900b97306ULL, 0x000ea2000020d400ULL,
0x000000014d4d4812ULL, 0x002fc600078efcffULL, 0x000000084408723cULL, 0x000b680000041850ULL,
0x000000b700b77306ULL, 0x000e62000020d400ULL, 0x000000014c4c3812ULL, 0x008fce00078efcffULL,
0x000000b500217306ULL, 0x000ee2000020d400ULL, 0x00000001b9b96812ULL, 0x004fc800078efcffULL,
0x0000005ab905723eULL, 0x000fe400000010ffULL, 0x00000001b7b75812ULL, 0x002fc800078efcffULL,
0x000000b74d20723eULL, 0x000fe200000010ffULL, 0x000000044404723cULL, 0x000b620000041854ULL,
0x0000000121212812ULL, 0x008fc800078efcffULL, 0x000000214c21723eULL, 0x000fce00000010ffULL,
0x000000204420723cULL, 0x000b620000041848ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0186b800ff447f8cULL, 0x020e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000403c447810ULL, 0x002fe20007ffe0ffULL,
0x01869000ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff487224ULL, 0x000fe200078e0045ULL,
0x0000000114147810ULL, 0x000fe40007ffe0ffULL, 0x0000000c4400720cULL, 0x000fda0003f06070ULL,
0x0000c11000000947ULL, 0x000fea0003800000ULL, 0x0000000000447805ULL, 0x000fc40000015200ULL,
0x0186bc00ff147984ULL, 0x000e640000000800ULL, 0x8000000014ff7812ULL, 0x002fe40007804848ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff497224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000467805ULL, 0x000fcc0000015200ULL, 0x0000004644467210ULL, 0x000fca0007f1e1ffULL,
0x0000000147477824ULL, 0x000fe200000e0e45ULL, 0x003d09004600780cULL, 0x000fc80003f06070ULL,
0x000000ff4700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404600780cULL, 0x000fc80003f06070ULL, 0x000000ff4700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011447ULL,
0x0000004614147211ULL, 0x000fca00078110ffULL, 0x000000ffff467224ULL, 0x000fca00000e0647ULL,
0x0000000214147819ULL, 0x000fc80000001246ULL, 0x000000140000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000149497810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0186bc00ff147984ULL, 0x000e640000000800ULL,
0x8000000014ff7812ULL, 0x002fe40007804848ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000046000009947ULL, 0x000fea0003800000ULL, 0x000000603c147810ULL, 0x000fe20007ffe0ffULL,
0x000000010f457824ULL, 0x000fe200078e021bULL, 0x000000021b487810ULL, 0x000fe40007ffe0ffULL,
0x000000140c447217ULL, 0x000fe20007800000ULL, 0x0000000145467824ULL, 0x000fe200078e0203ULL,
0x000000041b517810ULL, 0x000fe20007ffe0ffULL, 0x00000010454f7824ULL, 0x000fe200078e00ffULL,
0x000000061b537810ULL, 0x000fe20007ffe0ffULL, 0x0000000144447824ULL, 0x000fe200078e0a14ULL,
0x0000002000147811ULL, 0x000fe200078e38ffULL, 0x000000010f477824ULL, 0x000fe200078e0251ULL,
0xfffffff04f4f7812ULL, 0x000fe200078ee246ULL, 0x000000010f467824ULL, 0x040fe200078e0248ULL,
0x000000440f447217ULL, 0x000fe20007800000ULL, 0x00000001454d7824ULL, 0x100fe200078e0214ULL,
0x000000f0164e7812ULL, 0x000fe200078ec0ffULL, 0x000000010f497824ULL, 0x000fe200078e0253ULL,
0x000160004f4f7811ULL, 0x000fe200078e20ffULL, 0x00000001464c7824ULL, 0x040fe200078e0214ULL,
0x000000424d4d7210ULL, 0x000fe20007f1e0ffULL, 0x0000000146457824ULL, 0x000fc400078e0203ULL,
0x0000001046507824ULL, 0x000fe200078e00ffULL, 0x000000424c4c7210ULL, 0x080fe20007f5e0ffULL,
0x00000001474a7824ULL, 0x100fe400078e0214ULL, 0x0000000149547824ULL, 0x040fe200078e0214ULL,
0xfffffff050507812ULL, 0x000fe200078ee245ULL, 0x0000000149147824ULL, 0x140fe200078e0203ULL,
0x000000424a4a7210ULL, 0x000fe20007f7e0ffULL, 0x0000001049557824ULL, 0x000fe200078e00ffULL,
0x0001600050507811ULL, 0x000fe200078e20ffULL, 0x0000000147467824ULL, 0x040fe200078e0203ULL,
0x00005e004a497a11ULL, 0x000fe200078a40ffULL, 0x0000001047527824ULL, 0x000fe200078e00ffULL,
0xfffffff055557812ULL, 0x000fe200078ee214ULL, 0x000000ffff457224ULL, 0x000fe200000e06ffULL,
0x00005e004d477a11ULL, 0x000fe200078040ffULL, 0x0000000144147824ULL, 0x000fe200078e0a0fULL,
0xfffffff052527812ULL, 0x000fe200078ee246ULL, 0x000000ffff447224ULL, 0x000fe200010e06ffULL,
0x00005e004c4b7a11ULL, 0x000fc400078440ffULL, 0x00005f004d4d7a11ULL, 0x000fe200000f4445ULL,
0x000000ffff457224ULL, 0x000fe200018e06ffULL, 0x0000004254467210ULL, 0x000fe40007fde0ffULL,
0x00005f004c4c7a11ULL, 0x000fe400010f4444ULL, 0x000000141b00720cULL, 0x000fe40003f46070ULL,
0x0000004e47447210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff477224ULL, 0x000fe200030e06ffULL,
0x000000144800720cULL, 0x000fc40003f06070ULL, 0x00005f004a4a7a11ULL, 0x000fe200028f4445ULL,
0x000000ffff457224ULL, 0x000fe200020e064dULL, 0x00005e0046487a11ULL, 0x040fe400078a40ffULL,
0x000000145100720cULL, 0x080fe40003f66070ULL, 0x000000145300720cULL, 0x000fe20003f86070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000444f7faeULL, 0x0003e2000d101c46ULL,
0x00005f0046147a11ULL, 0x000fe400028f4447ULL, 0x0000004e4b467210ULL, 0x000fc40007fbe0ffULL,
0x0001600052527811ULL, 0x000fe400078e20ffULL, 0x0001600055557811ULL, 0x000fe200078e20ffULL,
0x000000ffff477224ULL, 0x000fe200028e064cULL, 0x0000004e48487210ULL, 0x080fe40007fbe0ffULL,
0x0000004e49447210ULL, 0x002fe40007f5e0ffULL, 0x0000000046507faeULL, 0x0003e2000c101c46ULL,
0x000000ffff497224ULL, 0x000fe400028e0614ULL, 0x000000ffff457224ULL, 0x000fca00010e064aULL,
0x0000000044527faeULL, 0x0003e8000d901c46ULL, 0x0000000048557faeULL, 0x0003e2000e101c46ULL,
0x0000039000007947ULL, 0x000fea0003800000ULL, 0x000000010f147824ULL, 0x000fe200078e021bULL,
0x0000002000457811ULL, 0x000fe400078e38ffULL, 0x000000f0164e7812ULL, 0x000fe200078ec0ffULL,
0x0000000114467824ULL, 0x040fe200078e0203ULL, 0x0000000214477810ULL, 0x040fe20007ffe0ffULL,
0x00000010144f7824ULL, 0x040fe200078e00ffULL, 0x0000000414497810ULL, 0x040fe20007ffe0ffULL,
0x0000000114447824ULL, 0x040fe200078e0245ULL, 0x00000006144a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000145147824ULL, 0x000fe200078e0247ULL, 0xfffffff04f4f7812ULL, 0x000fe200078ee246ULL,
0x0000000147487824ULL, 0x040fe200078e0203ULL, 0x0000004244467210ULL, 0x000fe20007f1e0ffULL,
0x0000001047507824ULL, 0x000fe200078e00ffULL, 0x000160004f4f7811ULL, 0x000fe200078e20ffULL,
0x0000000145447824ULL, 0x000fc400078e0249ULL, 0x00000001494b7824ULL, 0x140fe200078e0203ULL,
0xfffffff050507812ULL, 0x000fe200078ee248ULL, 0x0000001049517824ULL, 0x000fe200078e00ffULL,
0x0000004442447210ULL, 0x000fe20007f5e0ffULL, 0x0000000145457824ULL, 0x000fe200078e024aULL,
0x0001600050507811ULL, 0x000fe200078e20ffULL, 0x000000014a497824ULL, 0x040fe200078e0203ULL,
0xfffffff051517812ULL, 0x000fe200078ee24bULL, 0x000000104a527824ULL, 0x000fe200078e00ffULL,
0x0000004542457210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff477224ULL, 0x000fe200000e06ffULL,
0x00005e00464a7a11ULL, 0x000fc400078040ffULL, 0xfffffff052527812ULL, 0x000fe400078ee249ULL,
0x00005f00464d7a11ULL, 0x000fe200000f4447ULL, 0x000000ffff477224ULL, 0x000fe200010e06ffULL,
0x00000014424c7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff147224ULL, 0x000fe200018e06ffULL,
0x00005e0044467a11ULL, 0x000fe400078440ffULL, 0x00005e0045487a11ULL, 0x000fe200078640ffULL,
0x000000ffff4b7224ULL, 0x000fe200000e06ffULL, 0x00005e004c497a11ULL, 0x000fc400078040ffULL,
0x0000004e4a4a7210ULL, 0x080fe40007f9e0ffULL, 0x00005f004c4c7a11ULL, 0x000fe400000f444bULL,
0x00005f0044477a11ULL, 0x000fe200010f4447ULL, 0x000000ffff4b7224ULL, 0x000fe200020e064dULL,
0x0000004e49447210ULL, 0x080fe40007f1e0ffULL, 0x00005f0045147a11ULL, 0x000fe400018f4414ULL,
0x0000004e46467210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff457224ULL, 0x000fe200000e064cULL,
0x0000004e48487210ULL, 0x000fe20007f7e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000004a4f7faeULL, 0x0003e2000b901c46ULL, 0x0001600051517811ULL, 0x000fe200078e20ffULL,
0x000000ffff477224ULL, 0x000fe200010e0647ULL, 0x0001600052527811ULL, 0x000fe200078e20ffULL,
0x000000ffff497224ULL, 0x000fe200018e0614ULL, 0x0000000044507faeULL, 0x0003e8000b901c46ULL,
0x0000000046517faeULL, 0x0003e8000b901c46ULL, 0x0000000048527faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0186b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0186b000ff5c7f8cULL, 0x000ea2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018648000f487f8cULL, 0x0022e4000c80043fULL, 0x0000000000447805ULL, 0x000fc40000015200ULL,
0x01864c000f147984ULL, 0x000f240000000800ULL, 0x8000000014ff7812ULL, 0x018fc40007804849ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff4a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000467805ULL, 0x000fcc0000015200ULL, 0x0000004644467210ULL, 0x000fca0007f1e1ffULL,
0x0000000147477824ULL, 0x000fe200000e0e45ULL, 0x003d09004600780cULL, 0x000fc80003f06070ULL,
0x000000ff4700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404600780cULL, 0x000fc80003f06070ULL, 0x000000ff4700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011447ULL,
0x0000004614147211ULL, 0x000fca00078110ffULL, 0x000000ffff467224ULL, 0x000fca00000e0647ULL,
0x0000000214147819ULL, 0x000fc80000001246ULL, 0x000000140000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000014a4a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01864c000f147984ULL, 0x000ee40000000800ULL,
0x8000000014ff7812ULL, 0x008fe40007804849ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0181000017147984ULL, 0x000ee80000000800ULL, 0x0183000017487984ULL, 0x0002a20000000800ULL,
0x000000431400720bULL, 0x008fe20003f1d000ULL, 0x000144527f007947ULL, 0x000fd8000b800000ULL,
0x0000000000497806ULL, 0x002fc800000e0100ULL, 0x0000ffff49ff7812ULL, 0x000fe2000780c0ffULL,
0x0000047000007945ULL, 0x000fe20003800000ULL, 0x00000001ff4a7424ULL, 0x000fd600078e00ffULL,
0x0000044000008947ULL, 0x000fea0003800000ULL, 0x000000020200780cULL, 0x000fe40003f05270ULL,
0x000000431400720bULL, 0x000fe20003f54000ULL, 0x000144327f007947ULL, 0x000fd8000b800000ULL,
0x00000000004a7806ULL, 0x000fc400010e0100ULL, 0x0000001443448209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe80003800000ULL, 0x0185004417008388ULL, 0x0003e40000000800ULL,
0x000099104a447816ULL, 0x002fc800000000ffULL, 0x000000ff4400720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000001443447209ULL, 0x000fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff4aff7812ULL, 0x000fc6000780c0ffULL,
0x8000004443447221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b44447820ULL, 0x000fc80000410000ULL,
0x00000044005e7308ULL, 0x000e640000000800ULL, 0x0000005e11117220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff447819ULL, 0x000fe20000011603ULL,
0x000143827f007947ULL, 0x000fea000b800000ULL, 0x00001f445e447589ULL, 0x0002e400000e0000ULL,
0x0000004438387220ULL, 0x088fe40000410000ULL, 0x0000004439397220ULL, 0x080fe40000410000ULL,
0x0000004434347220ULL, 0x080fe40000410000ULL, 0x0000004435357220ULL, 0x000fc40000410000ULL,
0x0000004430307220ULL, 0x080fe40000410000ULL, 0x0000004431317220ULL, 0x080fe40000410000ULL,
0x000000442c2c7220ULL, 0x080fe40000410000ULL, 0x000000442d2d7220ULL, 0x080fe40000410000ULL,
0x0000004428287220ULL, 0x080fe40000410000ULL, 0x0000004429297220ULL, 0x000fc40000410000ULL,
0x0000004408087220ULL, 0x080fe40000410000ULL, 0x0000004409097220ULL, 0x080fe40000410000ULL,
0x0000004404047220ULL, 0x080fe40000410000ULL, 0x0000004405057220ULL, 0x080fe40000410000ULL,
0x0000004420207220ULL, 0x080fe40000410000ULL, 0x0000004421217220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff004aff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000803447811ULL, 0x000fe200078ff0ffULL,
0x000142927f007947ULL, 0x000fea000b800000ULL, 0x00001f445e447589ULL, 0x00066400000e0000ULL,
0x000000443a3a7220ULL, 0x082fe40000410000ULL, 0x000000443b3b7220ULL, 0x080fe40000410000ULL,
0x0000004436367220ULL, 0x080fe40000410000ULL, 0x0000004437377220ULL, 0x080fe40000410000ULL,
0x0000004432327220ULL, 0x080fe40000410000ULL, 0x0000004433337220ULL, 0x000fc40000410000ULL,
0x000000442e2e7220ULL, 0x080fe40000410000ULL, 0x000000442f2f7220ULL, 0x080fe40000410000ULL,
0x000000442a2a7220ULL, 0x080fe40000410000ULL, 0x000000442b2b7220ULL, 0x080fe40000410000ULL,
0x000000440a0a7220ULL, 0x080fe40000410000ULL, 0x000000440b0b7220ULL, 0x000fc40000410000ULL,
0x0000004406067220ULL, 0x080fe40000410000ULL, 0x0000004407077220ULL, 0x080fe40000410000ULL,
0x0000004422227220ULL, 0x080fe40000410000ULL, 0x0000004423237220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000ffff4aff7812ULL, 0x000fe20007800849ULL,
0x00000001ff4a7424ULL, 0x000fe200078e00ffULL, 0x0000001443437209ULL, 0x000fd60007810000ULL,
0x8000004314140221ULL, 0x000fe20000010000ULL, 0x00007610ff4a0816ULL, 0x000fc6000000004aULL,
0x3fb8aa3b14140820ULL, 0x000fc80000410000ULL, 0x0000001400180308ULL, 0x000f240000000800ULL,
0x0000001848480220ULL, 0x014fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001148117221ULL, 0x004fc40000010000ULL, 0x0000000000447805ULL, 0x000fca0000015200ULL,
0x0186ac00ff147984ULL, 0x000ea40000000800ULL, 0x8000000014ff7812ULL, 0x004fe40007804841ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff487224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000467805ULL, 0x000fcc0000015200ULL, 0x0000004644467210ULL, 0x000fca0007f1e1ffULL,
0x0000000147477824ULL, 0x000fe200000e0e45ULL, 0x003d09004600780cULL, 0x000fc80003f06070ULL,
0x000000ff4700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404600780cULL, 0x000fc80003f06070ULL, 0x000000ff4700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011447ULL,
0x0000004614147211ULL, 0x000fca00078110ffULL, 0x000000ffff467224ULL, 0x000fca00000e0647ULL,
0x0000000214147819ULL, 0x000fc80000001246ULL, 0x000000140000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000148487810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0186ac00ff147984ULL, 0x000ea40000000800ULL,
0x8000000014ff7812ULL, 0x004fe40007804841ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099104a147816ULL, 0x000fe200000000ffULL, 0x0000019000007945ULL, 0x000fe60003800000ULL,
0x000000ff1400720cULL, 0x000fda0003f45270ULL, 0x0000016000002947ULL, 0x000fea0003800000ULL,
0x00000018ff14723eULL, 0x000fe400000010ffULL, 0x00000002ff417819ULL, 0x000fe40000011603ULL,
0x0000541014147816ULL, 0x000fe20000000014ULL, 0x00013e927f007947ULL, 0x000fea000b800000ULL,
0x00001f4114197589ULL, 0x00046400000e0000ULL, 0x00000008411a7810ULL, 0x000fe20007ffe0ffULL,
0x00013ee27f007947ULL, 0x000fea000b800000ULL, 0x00001f1a141a7589ULL, 0x0004e400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001041477810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff5e7224ULL, 0x00afe200078e0014ULL, 0x0000ebf000447802ULL, 0x000fe20000000f00ULL,
0x0000001fff457424ULL, 0x000fe400078e00ffULL, 0xffffffffff467424ULL, 0x000fc400078e00ffULL,
0x0001493000007944ULL, 0x004fea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001841477810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff5e7224ULL, 0x00afe200078e0014ULL,
0x0000ec6000447802ULL, 0x000fe20000000f00ULL, 0x0000001fff457424ULL, 0x000fc400078e00ffULL,
0xffffffffff467424ULL, 0x004fc400078e00ffULL, 0x000148c000007944ULL, 0x000fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000001c4c783bULL, 0x000f280000004200ULL, 0x000000001d50783bULL, 0x000ee80000004200ULL,
0x000000001e44783bULL, 0x004ea80000004200ULL, 0x000000001f48783bULL, 0x000e620000004200ULL,
0x0000004c00d37306ULL, 0x010fe20000009400ULL, 0x00000018ff977819ULL, 0x000fe2000001144dULL,
0x000001004d7b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff987819ULL, 0x000fe2000001144cULL,
0x000001004c767824ULL, 0x000fe200078e00ffULL, 0x00000018ff8e7819ULL, 0x000fc4000001144eULL,
0x00000018ff7b7819ULL, 0x000fe2000001147bULL, 0x0000004c00d27306ULL, 0x000f220000005400ULL,
0x00000018ff8c7819ULL, 0x000fe4000001144fULL, 0x00000018ffad7819ULL, 0x000fe40000011476ULL,
0x00000018ff577819ULL, 0x008fe40000011451ULL, 0x00000018ff827819ULL, 0x000fe20000011450ULL,
0x0000004d00d17306ULL, 0x000fe20000009400ULL, 0x00000018ff727819ULL, 0x004fc40000011444ULL,
0x00000018ff6e7819ULL, 0x000fe40000011445ULL, 0x00000018ff7a7819ULL, 0x000fe40000011453ULL,
0x00000018ff5b7819ULL, 0x000fe20000011452ULL, 0x0000004d00777306ULL, 0x000fe20000005400ULL,
0x000000d2d300720bULL, 0x010fe40003f1d000ULL, 0x00000018ff6c7819ULL, 0x000fe40000011446ULL,
0x00000018ff647819ULL, 0x000fc40000011447ULL, 0x00000018ff627819ULL, 0x002fe20000011448ULL,
0x0000004d009c7306ULL, 0x0003e2000000d400ULL, 0x00000018ff5e7819ULL, 0x000fe4000001144aULL,
0x00000018ff147819ULL, 0x000fe4000001144bULL, 0x00000018ff607819ULL, 0x000fc60000011449ULL,
0x0000004c009e7306ULL, 0x0004e2000000d400ULL, 0x000100004d4d7824ULL, 0x002fca00078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x0000004e00cd7306ULL, 0x000fe20000009400ULL,
0x000100004c4c7824ULL, 0x004fca00078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe4000001144cULL,
0x0000004d00da7306ULL, 0x000fe20000209400ULL, 0x000000019e9e0812ULL, 0x008fce00078efcffULL,
0x0000004d00d97306ULL, 0x000e700000205400ULL, 0x0000004c00d57306ULL, 0x000ff00000209400ULL,
0x0000004c00d67306ULL, 0x000ea20000205400ULL, 0x000000d9da00720bULL, 0x002fce0003f1d000ULL,
0x0000004c009d7306ULL, 0x0003f0000020d400ULL, 0x0000004d009b7306ULL, 0x000722000020d400ULL,
0x000001004e4c7824ULL, 0x002fe200078e00ffULL, 0x000000d6d500720bULL, 0x004fc80003fbd000ULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x0000004e00b07306ULL, 0x000fe20000005400ULL,
0x000001004f4d7824ULL, 0x008fca00078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x0000004e00937306ULL, 0x0003e2000000d400ULL, 0x000000019b9b0812ULL, 0x010fe400078efcffULL,
0x000000019d9d5812ULL, 0x000fca00078efcffULL, 0x0000004f00cc7306ULL, 0x000fe20000009400ULL,
0x000100004e4e7824ULL, 0x002fca00078e00ffULL, 0x00000018ff4e7819ULL, 0x000fe4000001144eULL,
0x0000004f00747306ULL, 0x000e700000005400ULL, 0x0000004f00907306ULL, 0x0004f0000000d400ULL,
0x0000007b00d77306ULL, 0x000fe20000209400ULL, 0x000100004f4f7824ULL, 0x004fe200078e00ffULL,
0x00000074cc00720bULL, 0x002fc80003f1d000ULL, 0x00000018ff4f7819ULL, 0x000fe4000001144fULL,
0x0000007b00d87306ULL, 0x000e6e0000205400ULL, 0x0000000190900812ULL, 0x008fe200078efcffULL,
0x000000ad00d47306ULL, 0x000ff00000209400ULL, 0x000000ad00767306ULL, 0x000ea20000205400ULL,
0x000000d8d700720bULL, 0x002fce0003fdd000ULL, 0x0000004c00dc7306ULL, 0x000ff00000209400ULL,
0x0000004c00db7306ULL, 0x000fe20000205400ULL, 0x00000076d400720bULL, 0x004fce0003f7d000ULL,
0x0000004c00947306ULL, 0x000ff0000020d400ULL, 0x0000004d00de7306ULL, 0x000ff00000209400ULL,
0x0000004d00dd7306ULL, 0x000ff00000205400ULL, 0x0000004d00957306ULL, 0x000ff0000020d400ULL,
0x0000004e00e07306ULL, 0x000ff00000209400ULL, 0x0000004e00df7306ULL, 0x000ff00000205400ULL,
0x0000004e004c7306ULL, 0x0003f0000020d400ULL, 0x0000004f00e17306ULL, 0x000fe20000209400ULL,
0x00000100504e7824ULL, 0x002fca00078e00ffULL, 0x00000018ff4e7819ULL, 0x000fe4000001144eULL,
0x0000004f00e27306ULL, 0x000ff00000205400ULL, 0x0000004f004d7306ULL, 0x0003f0000020d400ULL,
0x0000005100757306ULL, 0x000fe20000009400ULL, 0x00000100514f7824ULL, 0x002fca00078e00ffULL,
0x00000018ff4f7819ULL, 0x000fe4000001144fULL, 0x0000005100b97306ULL, 0x000ff00000005400ULL,
0x0000005100897306ULL, 0x0003f0000000d400ULL, 0x0000009700cf7306ULL, 0x000fe20000209400ULL,
0x0001000051517824ULL, 0x002fca00078e00ffULL, 0x00000018ff517819ULL, 0x000fe40000011451ULL,
0x0000009700d07306ULL, 0x000e700000205400ULL, 0x0000007b00ac7306ULL, 0x0004f0000020d400ULL,
0x0000009800ce7306ULL, 0x000fe20000209400ULL, 0x000000d0cf00720bULL, 0x002fe20003fbd000ULL,
0x00000100527b7824ULL, 0x004fca00078e00ffULL, 0x00000018ff7b7819ULL, 0x000fe2000001147bULL,
0x0000009800ab7306ULL, 0x000e620000205400ULL, 0x00000001acac6812ULL, 0x008fe400078efcffULL,
0x000000b0cd00720bULL, 0x000fca0003fdd000ULL, 0x0000004e00e47306ULL, 0x000ff00000209400ULL,
0x0000004e00e37306ULL, 0x000ea20000205400ULL, 0x000000abce00720bULL, 0x002fe40003f9d000ULL,
0x0000000193936812ULL, 0x000fc400078efcffULL, 0x000000e2e100720bULL, 0x000fc60003fdd000ULL,
0x000000ad00ad7306ULL, 0x000e70000020d400ULL, 0x0000005100ec7306ULL, 0x000fe20000209400ULL,
0x000000e3e400720bULL, 0x004fe40003f1d000ULL, 0x000000014d4d6812ULL, 0x000fc400078efcffULL,
0x000000b97500720bULL, 0x000fc60003fdd000ULL, 0x0000005100e97306ULL, 0x000fe20000205400ULL,
0x00000001adad3812ULL, 0x002fe400078efcffULL, 0x00000077d100720bULL, 0x000fca0003f7d000ULL,
0x0000005100867306ULL, 0x0003e4000020d400ULL, 0x0000000189896812ULL, 0x000fcc00078efcffULL,
0x0000009700977306ULL, 0x000ea2000020d400ULL, 0x0000010053517824ULL, 0x002fe200078e00ffULL,
0x000000019c9c3812ULL, 0x000fe400078efcffULL, 0x000000ddde00720bULL, 0x000fe40003f7d000ULL,
0x00000018ff517819ULL, 0x000fe40000011451ULL, 0x0000009800987306ULL, 0x000e70000020d400ULL,
0x0000005100ea7306ULL, 0x000fe20000209400ULL, 0x0000000197975812ULL, 0x004fc400078efcffULL,
0x000000dfe000720bULL, 0x000fe40003fbd000ULL, 0x0000000195953812ULL, 0x000fc600078efcffULL,
0x0000005100eb7306ULL, 0x000fe20000205400ULL, 0x0000000198984812ULL, 0x002fe400078efcffULL,
0x000000dbdc00720bULL, 0x000fca0003f9d000ULL, 0x0000005100817306ULL, 0x0003e2000020d400ULL,
0x000000014c4c5812ULL, 0x000fce00078efcffULL, 0x0000004400a37306ULL, 0x000fe20000009400ULL,
0x0000010044517824ULL, 0x002fe200078e00ffULL, 0x0000000194944812ULL, 0x000fc800078efcffULL,
0x00000018ff517819ULL, 0x000fe40000011451ULL, 0x0000004400a67306ULL, 0x000ff00000005400ULL,
0x0000004400797306ULL, 0x0003f0000000d400ULL, 0x0000004e004e7306ULL, 0x000ea2000020d400ULL,
0x0001000044447824ULL, 0x002fca00078e00ffULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x0000008200b87306ULL, 0x000ff00000209400ULL, 0x0000008200b27306ULL, 0x000e620000205400ULL,
0x000000014e4e0812ULL, 0x004fce00078efcffULL, 0x0000005100c27306ULL, 0x000ff00000209400ULL,
0x0000005100c37306ULL, 0x000fe20000205400ULL, 0x000000b2b800720bULL, 0x002fce0003f1d000ULL,
0x00000051007f7306ULL, 0x0003f0000020d400ULL, 0x0000005000c87306ULL, 0x000fe20000009400ULL,
0x0000010045517824ULL, 0x002fca00078e00ffULL, 0x00000018ff517819ULL, 0x000fe40000011451ULL,
0x0000005000c77306ULL, 0x000e700000005400ULL, 0x0000004500a47306ULL, 0x000ff00000009400ULL,
0x00000045009f7306ULL, 0x000fe20000005400ULL, 0x000000c7c800720bULL, 0x002fce0003fbd000ULL,
0x0000004500787306ULL, 0x0003f0000000d400ULL, 0x0000004400c07306ULL, 0x000fe20000209400ULL,
0x0001000045457824ULL, 0x002fca00078e00ffULL, 0x00000018ff457819ULL, 0x000fe40000011445ULL,
0x0000004400c17306ULL, 0x000ff00000205400ULL, 0x00000044007d7306ULL, 0x0003f0000020d400ULL,
0x0000008e00c97306ULL, 0x000fe20000209400ULL, 0x0000010046447824ULL, 0x002fca00078e00ffULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x0000008e00c67306ULL, 0x000e700000205400ULL,
0x0000008200827306ULL, 0x000eb0000020d400ULL, 0x0000005300b17306ULL, 0x000fe20000009400ULL,
0x000000c6c900720bULL, 0x002fce0003f9d000ULL, 0x0000005300b47306ULL, 0x000e620000005400ULL,
0x0000000182820812ULL, 0x004fce00078efcffULL, 0x0000008c00ca7306ULL, 0x000ff00000209400ULL,
0x0000008c00cb7306ULL, 0x000ea20000205400ULL, 0x000000b4b100720bULL, 0x002fce0003f1d000ULL,
0x0000005300597306ULL, 0x0002f0000000d400ULL, 0x0000007b00ed7306ULL, 0x000fe20000209400ULL,
0x0001000053537824ULL, 0x002fe200078e00ffULL, 0x000000cbca00720bULL, 0x004fc80003f7d000ULL,
0x00000018ff537819ULL, 0x000fe40000011453ULL, 0x0000007b00ee7306ULL, 0x000fe20000205400ULL,
0x0000000159590812ULL, 0x008fce00078efcffULL, 0x0000007b00877306ULL, 0x000ff0000020d400ULL,
0x0000004500bc7306ULL, 0x000ff00000209400ULL, 0x0000004500bd7306ULL, 0x000ff00000205400ULL,
0x00000045007b7306ULL, 0x0003f0000020d400ULL, 0x0000004400ae7306ULL, 0x000fe20000209400ULL,
0x0000010047457824ULL, 0x002fca00078e00ffULL, 0x00000018ff457819ULL, 0x000fe40000011445ULL,
0x0000004400af7306ULL, 0x000ff00000205400ULL, 0x00000044007c7306ULL, 0x0003f0000020d400ULL,
0x0000005000887306ULL, 0x0004e2000000d400ULL, 0x0000010048447824ULL, 0x002fca00078e00ffULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x0000005200b57306ULL, 0x000fe20000009400ULL,
0x0001000050507824ULL, 0x004fca00078e00ffULL, 0x00000018ff507819ULL, 0x000fe40000011450ULL,
0x0000005200b67306ULL, 0x000e620000005400ULL, 0x0000000188885812ULL, 0x008fe400078efcffULL,
0x000000e9ec00720bULL, 0x000fca0003fbd000ULL, 0x0000005200547306ULL, 0x0004f0000000d400ULL,
0x0000004600a77306ULL, 0x000fe20000009400ULL, 0x0001000052527824ULL, 0x004fe200078e00ffULL,
0x000000b6b500720bULL, 0x002fc40003fdd000ULL, 0x0000000186865812ULL, 0x000fe400078efcffULL,
0x00000018ff527819ULL, 0x000fe40000011452ULL, 0x0000004600a17306ULL, 0x000fe20000005400ULL,
0x000000ebea00720bULL, 0x000fcc0003fbd000ULL, 0x0000000154546812ULL, 0x008fe200078efcffULL,
0x0000004600707306ULL, 0x0003ec000000d400ULL, 0x0000000181815812ULL, 0x000fe400078efcffULL,
0x0000004700927306ULL, 0x000fe20000009400ULL, 0x0001000046467824ULL, 0x002fca00078e00ffULL,
0x00000018ff467819ULL, 0x000fe40000011446ULL, 0x0000004700917306ULL, 0x000ff00000005400ULL,
0x0000004700697306ULL, 0x0003f0000000d400ULL, 0x0000008e008e7306ULL, 0x000ea2000020d400ULL,
0x0001000047477824ULL, 0x002fca00078e00ffULL, 0x00000018ff477819ULL, 0x000fe40000011447ULL,
0x0000004f00e67306ULL, 0x000ff00000209400ULL, 0x0000004f00e57306ULL, 0x000e620000205400ULL,
0x000000018e8e4812ULL, 0x004fc800078efcffULL, 0x0000004c8e4c723eULL, 0x000fc600000010ffULL,
0x0000007a00a87306ULL, 0x000ff00000209400ULL, 0x0000007a00a97306ULL, 0x000ea20000205400ULL,
0x000000e5e600720bULL, 0x002fce0003f9d000ULL, 0x0000005300c47306ULL, 0x000ff00000209400ULL,
0x0000005300c57306ULL, 0x000e620000205400ULL, 0x000000a9a800720bULL, 0x004fe20003f1d000ULL,
0x000001004aa87824ULL, 0x000fc400078e00ffULL, 0x000100004aa97824ULL, 0x000fc600078e00ffULL,
0x00000018ffa87819ULL, 0x000fe200000114a8ULL, 0x00000053007e7306ULL, 0x000ea2000020d400ULL,
0x00000018ffa97819ULL, 0x000fce00000114a9ULL, 0x0000008c008c7306ULL, 0x000ee2000020d400ULL,
0x000000c5c400720bULL, 0x002fce0003fbd000ULL, 0x0000004500537306ULL, 0x000fec0000209400ULL,
0x000000017e7e5812ULL, 0x004fe400078efcffULL, 0x0000004500967306ULL, 0x000fe20000205400ULL,
0x000000018c8c3812ULL, 0x008fe400078efcffULL, 0x000000a1a700720bULL, 0x000fc40003fbd000ULL,
0x0000004d8c4d723eULL, 0x000fc600000010ffULL, 0x0000004500767306ULL, 0x0003f0000020d400ULL,
0x0000004400c67306ULL, 0x000fe20000209400ULL, 0x0000010049457824ULL, 0x002fe200078e00ffULL,
0x0000000170705812ULL, 0x000fc800078efcffULL, 0x00000018ffb87819ULL, 0x000fe40000011445ULL,
0x0000004400c77306ULL, 0x000ff00000205400ULL, 0x0000004400757306ULL, 0x0003f0000020d400ULL,
0x0000005000e77306ULL, 0x000fe20000209400ULL, 0x0001300024447811ULL, 0x002fce00078e20ffULL,
0x0000005000e87306ULL, 0x000e700000205400ULL, 0x0000005200bb7306ULL, 0x000ff00000209400ULL,
0x0000005200ba7306ULL, 0x000fe20000205400ULL, 0x000000e8e700720bULL, 0x002fce0003f7d000ULL,
0x0000005200857306ULL, 0x000ff0000020d400ULL, 0x0000005100bf7306ULL, 0x000ff00000209400ULL,
0x0000005100be7306ULL, 0x000ff00000205400ULL, 0x0000005100807306ULL, 0x000ff0000020d400ULL,
0x0000004600517306ULL, 0x000ff00000209400ULL, 0x0000004600527306ULL, 0x000e700000205400ULL,
0x0000004600777306ULL, 0x000eb0000020d400ULL, 0x0000004700ab7306ULL, 0x000fe20000209400ULL,
0x000000525100720bULL, 0x002fc40003fbd000ULL, 0x000000884e52723eULL, 0x000fca00000010ffULL,
0x0000004700b07306ULL, 0x000fec0000205400ULL, 0x0000000177775812ULL, 0x004fe400078efcffULL,
0x0000004700747306ULL, 0x0003f0000020d400ULL, 0x0000004f004f7306ULL, 0x000ea2000020d400ULL,
0x000000004444783bULL, 0x002e6e0000000200ULL, 0x0000005700b77306ULL, 0x000ff00000209400ULL,
0x0000005700b37306ULL, 0x000ee20000205400ULL, 0x000000014f4f4812ULL, 0x004fce00078efcffULL,
0x0000007a007a7306ULL, 0x000eb0000020d400ULL, 0x0000005b00aa7306ULL, 0x000fe20000209400ULL,
0x000000b3b700720bULL, 0x008fce0003f9d000ULL, 0x0000005b00a07306ULL, 0x000ee20000205400ULL,
0x000000017a7a0812ULL, 0x004fe200078efcffULL, 0x000000194444a231ULL, 0x082fe200003400ffULL,
0x000000c1c000720bULL, 0x000fe20003f1d000ULL, 0x000000194646a231ULL, 0x000fe400003400ffULL,
0x0000001a4545a231ULL, 0x080fe400003400ffULL, 0x0000005000507306ULL, 0x000e62000020d400ULL,
0x0000001a4747a231ULL, 0x000fce00003400ffULL, 0x0000005700577306ULL, 0x000ea2000020d400ULL,
0x000000a0aa00720bULL, 0x008fe20003fdd000ULL, 0x000001004baa7824ULL, 0x000fe200078e00ffULL,
0x000000017d7d0812ULL, 0x000fe200078efcffULL, 0x000100004ba07824ULL, 0x000fc600078e00ffULL,
0x00000018ffaa7819ULL, 0x000fe200000114aaULL, 0x0000005b005b7306ULL, 0x000ee2000020d400ULL,
0x0000000150503812ULL, 0x002fe400078efcffULL, 0x000000eeed00720bULL, 0x000fe40003f7d000ULL,
0x000000508282723eULL, 0x000fe400000010ffULL, 0x00000018ffa07819ULL, 0x000fe200000114a0ULL,
0x0000006e009a7306ULL, 0x000fe20000209400ULL, 0x0000000157574812ULL, 0x004fc400078efcffULL,
0x000000babb00720bULL, 0x000fca0003f9d000ULL, 0x0000006e00997306ULL, 0x000e620000205400ULL,
0x000000015b5b6812ULL, 0x008fe400078efcffULL, 0x0000009fa400720bULL, 0x000fe40003fdd000ULL,
0x0000000187873812ULL, 0x000fe400078efcffULL, 0x000000a6a300720bULL, 0x000fe20003f7d000ULL,
0x0000006e006e7306ULL, 0x000ea2000020d400ULL, 0x0000000185854812ULL, 0x000fe400078efcffULL,
0x000000c3c200720bULL, 0x000fca0003f9d000ULL, 0x00000048008f7306ULL, 0x000fe20000009400ULL,
0x000000999a00720bULL, 0x002fe40003f1d000ULL, 0x0000000178786812ULL, 0x000fe400078efcffULL,
0x000000afae00720bULL, 0x000fe40003fdd000ULL, 0x0000000179793812ULL, 0x000fe200078efcffULL,
0x00000048008d7306ULL, 0x000fe20000005400ULL, 0x000000bebf00720bULL, 0x000fe40003f7d000ULL,
0x000000017f7f4812ULL, 0x000fc600078efcffULL, 0x000000016e6e0812ULL, 0x004fe400078efcffULL,
0x0000004800637306ULL, 0x0003e2000000d400ULL, 0x000000965300720bULL, 0x000fe40003f1d000ULL,
0x0001300025537811ULL, 0x000fe400078e20ffULL, 0x000000017c7c6812ULL, 0x000fe400078efcffULL,
0x0000000180803812ULL, 0x000fe200078efcffULL, 0x0000004a00587306ULL, 0x000fe20000009400ULL,
0x0001000048487824ULL, 0x002fe200078e00ffULL, 0x000000919200720bULL, 0x000fc80003f7d000ULL,
0x00000018ff487819ULL, 0x000fe40000011448ULL, 0x0000004a005a7306ULL, 0x000e620000005400ULL,
0x0000000176760812ULL, 0x000fcc00078efcffULL, 0x0000000169693812ULL, 0x000fe200078efcffULL,
0x0000004a005f7306ULL, 0x0004e2000000d400ULL, 0x000000b0ab00720bULL, 0x000fce0003f7d000ULL,
0x0000004b006a7306ULL, 0x000fe20000009400ULL, 0x0000009ead4a723eULL, 0x004fca00000010ffULL,
0x0000000174743812ULL, 0x000fe400078efcffULL, 0x0000004b006b7306ULL, 0x000fe20000005400ULL,
0x0000005a5800720bULL, 0x002fce0003f7d000ULL, 0x0000004b00417306ULL, 0x0003ec000000d400ULL,
0x000000015f5f3812ULL, 0x008fe400078efcffULL, 0x0000004900557306ULL, 0x000fe20000009400ULL,
0x0000009cac4b723eULL, 0x002fce00000010ffULL, 0x0000004900567306ULL, 0x000e620000005400ULL,
0x0000004a4438723cULL, 0x000b6e0000041838ULL, 0x0000004900617306ULL, 0x0004e2000000d400ULL,
0x00000093944a723eULL, 0x020fe400000010ffULL, 0x00000090954b723eULL, 0x000fca00000010ffULL,
0x0000004800a37306ULL, 0x000fe20000209400ULL, 0x0001000049497824ULL, 0x004fe200078e00ffULL,
0x000000565500720bULL, 0x002fc80003fbd000ULL, 0x00000018ffa17819ULL, 0x000fe40000011449ULL,
0x0000004800a67306ULL, 0x000fe20000205400ULL, 0x0000009b9749723eULL, 0x000fcc00000010ffULL,
0x0000000161615812ULL, 0x008fe200078efcffULL, 0x00000048009f7306ULL, 0x0003f0000020d400ULL,
0x0000007200a57306ULL, 0x000fe20000209400ULL, 0x0000009d9848723eULL, 0x002fce00000010ffULL,
0x0000007200a27306ULL, 0x000e620000205400ULL, 0x000000484434723cULL, 0x040f6e0000041834ULL,
0x0000006c008a7306ULL, 0x000fe20000209400ULL, 0x0000004a4448723cULL, 0x000be40000041830ULL,
0x000000005330783bULL, 0x0204ea0000000200ULL, 0x0000006c008b7306ULL, 0x000f220000205400ULL,
0x000000a2a500720bULL, 0x002fc40003f9d000ULL, 0x000000894f53723eULL, 0x004fe400000010ffULL,
0x0000004c444c723cULL, 0x040b66000004182cULL, 0x0000006400837306ULL, 0x000fe80000209400ULL,
0x000000707c2c723eULL, 0x020fe200000010ffULL, 0x000000524450723cULL, 0x000be20000041828ULL,
0x00000069762d723eULL, 0x000fc400000010ffULL, 0x0000006400847306ULL, 0x000e620000205400ULL,
0x0000008b8a00720bULL, 0x010fc60003fdd000ULL, 0x000000548728723eULL, 0x020fe400000010ffULL,
0x000000598129723eULL, 0x000fe400000010ffULL, 0x0000007200727306ULL, 0x000eb0000020d400ULL,
0x0000006c006c7306ULL, 0x000f22000020d400ULL, 0x000000848300720bULL, 0x002fc40003f1d000ULL,
0x000000865783723eULL, 0x000fe200000010ffULL, 0x000000193030a231ULL, 0x088fe400003400ffULL,
0x000000193232a231ULL, 0x000fe400003400ffULL, 0x0000006400647306ULL, 0x000e62000020d400ULL,
0x0000000172724812ULL, 0x004fe200078efcffULL, 0x000000824454723cULL, 0x000b620000041808ULL,
0x000000bdbc00720bULL, 0x000fe20003f9d000ULL, 0x0000001a3131a231ULL, 0x080fe400003400ffULL,
0x0000001a3333a231ULL, 0x000fc400003400ffULL, 0x000000b800b27306ULL, 0x000fe20000209400ULL,
0x000000016c6c6812ULL, 0x010fe400078efcffULL, 0x000000c7c600720bULL, 0x000fe40003fdd000ULL,
0x000000855b08723eULL, 0x020fe400000010ffULL, 0x000000284458723cULL, 0x000b620000041804ULL,
0x000000b800b37306ULL, 0x000ea20000205400ULL, 0x0000000164640812ULL, 0x002fe400078efcffULL,
0x000000017b7b4812ULL, 0x000fc400078efcffULL, 0x0000008d8f00720bULL, 0x000fe40003f9d000ULL,
0x0000007e7a09723eULL, 0x000fe200000010ffULL, 0x000000b800b17306ULL, 0x000e62000020d400ULL,
0x0000000175756812ULL, 0x000fe400078efcffULL, 0x000000a6a300720bULL, 0x000fe40003fdd000ULL,
0x000000797f04723eULL, 0x020fe200000010ffULL, 0x000000084444723cULL, 0x000b620000041820ULL,
0x000000788005723eULL, 0x000fe200000010ffULL, 0x000000a100a27306ULL, 0x000fe20000209400ULL,
0x000000b3b200720bULL, 0x004fc40003f1d000ULL, 0x0000007d7228723eULL, 0x000fe400000010ffULL,
0x0000007b6e29723eULL, 0x000fe200000010ffULL, 0x000000043020723cULL, 0x040b620000041838ULL,
0x0000000163634812ULL, 0x000fe200078efcffULL, 0x000000a1009c7306ULL, 0x000ea20000205400ULL,
0x000000019f9f6812ULL, 0x000fe400078efcffULL, 0x000000776c08723eULL, 0x020fe400000010ffULL,
0x000000637504723eULL, 0x000fe200000010ffULL, 0x000000283028723cULL, 0x000b620000041834ULL,
0x00000001b1b10812ULL, 0x002fe200078efcffULL, 0x0000006200717306ULL, 0x000fe20000209400ULL,
0x000000746409723eULL, 0x000fc400000010ffULL, 0x00000061b105723eULL, 0x000fca00000010ffULL,
0x0000006200737306ULL, 0x000e620000205400ULL, 0x0000009ca200720bULL, 0x004fe20003f1d000ULL,
0x000000083008723cULL, 0x000b6c000004184cULL, 0x000000a100977306ULL, 0x000eb0000020d400ULL,
0x00000060006d7306ULL, 0x000fe20000209400ULL, 0x000000737100720bULL, 0x002fce0003f9d000ULL,
0x00000060006f7306ULL, 0x000e620000205400ULL, 0x0000000197970812ULL, 0x004fce00078efcffULL,
0x000000a800907306ULL, 0x000ff00000209400ULL, 0x000000a8008c7306ULL, 0x000ea20000205400ULL,
0x0000006f6d00720bULL, 0x002fce0003fbd000ULL, 0x000000aa002e7306ULL, 0x000ff00000209400ULL,
0x000000aa002f7306ULL, 0x000e620000205400ULL, 0x0000008c9000720bULL, 0x004fce0003fdd000ULL,
0x0000006200627306ULL, 0x000eb0000020d400ULL, 0x0000006000607306ULL, 0x000ee2000020d400ULL,
0x0000002f2e00720bULL, 0x002fe40003f1d000ULL, 0x0000002c302c723cULL, 0x000b6a0000041848ULL,
0x000000a800a87306ULL, 0x000e62000020d400ULL, 0x0000000162624812ULL, 0x004fc400078efcffULL,
0x0000006b6a00720bULL, 0x000fe40003f9d000ULL, 0x0000009f6262723eULL, 0x000fc600000010ffULL,
0x000000aa00aa7306ULL, 0x000ea2000020d400ULL, 0x0000000160605812ULL, 0x008fc800078efcffULL,
0x000000976063723eULL, 0x000fc600000010ffULL, 0x0000005e00657306ULL, 0x000fe20000209400ULL,
0x00000001a8a86812ULL, 0x002fe400078efcffULL, 0x0000000141414812ULL, 0x000fe200078efcffULL,
0x000000623054723cULL, 0x000b620000041854ULL, 0x0000005fa8a8723eULL, 0x000fc600000010ffULL,
0x0000005e00667306ULL, 0x000e620000205400ULL, 0x00000001aaaa0812ULL, 0x004fce00078efcffULL,
0x0000001400677306ULL, 0x000ff00000209400ULL, 0x0000001400687306ULL, 0x000ea20000205400ULL,
0x000000666500720bULL, 0x002fce0003fbd000ULL, 0x000000a900067306ULL, 0x000ff00000209400ULL,
0x000000a900077306ULL, 0x000e620000205400ULL, 0x000000686700720bULL, 0x004fce0003fdd000ULL,
0x000000a000387306ULL, 0x000ff00000209400ULL, 0x000000a000357306ULL, 0x020ea20000205400ULL,
0x000000070600720bULL, 0x002fe40003f7d000ULL, 0x000000043004723cULL, 0x000b6a0000041850ULL,
0x0000005e005e7306ULL, 0x000e70000020d400ULL, 0x0000001400147306ULL, 0x000ee2000020d400ULL,
0x000000353800720bULL, 0x004fce0003f1d000ULL, 0x000000a900347306ULL, 0x000522000020d400ULL,
0x000000015e5e5812ULL, 0x002fce00078efcffULL, 0x000000a000a07306ULL, 0x000e62000020d400ULL,
0x0000000114146812ULL, 0x008fe400078efcffULL, 0x00000041aaa9723eULL, 0x004fe400000010ffULL,
0x0000000134343812ULL, 0x010fca00078efcffULL, 0x000000a83058723cULL, 0x000b620000041858ULL,
0x000000345e34723eULL, 0x000fe400000010ffULL, 0x00000001a0a00812ULL, 0x002fc800078efcffULL,
0x000000a01435723eULL, 0x000fce00000010ffULL, 0x000000343030723cULL, 0x000b620000041844ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0186b800ff387f8cULL, 0x000e62000c80043fULL,
0x000000ffff3a7224ULL, 0x000fce00078e00ffULL, 0x0000000000347805ULL, 0x020fc40000015200ULL,
0x0186bc00ff147984ULL, 0x000ea40000000800ULL, 0x8000000014ff7812ULL, 0x006fe40007804839ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fcc0000015200ULL,
0x0000003634367210ULL, 0x000fca0007f1e1ffULL, 0x0000000137377824ULL, 0x000fe200000e0e35ULL,
0x003d09003600780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403600780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011437ULL, 0x0000003614147211ULL, 0x000fca00078110ffULL,
0x000000ffff367224ULL, 0x000fca00000e0637ULL, 0x0000000214147819ULL, 0x000fc80000001236ULL,
0x000000140000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013a3a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0186bc00ff147984ULL, 0x000e640000000800ULL, 0x8000000014ff7812ULL, 0x002fe40007804839ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000046000009947ULL, 0x000fea0003800000ULL,
0x000000010f357824ULL, 0x000fe200078e021bULL, 0x000000803c347810ULL, 0x000fe40007ffe0ffULL,
0x0000004000417811ULL, 0x000fe200078e38ffULL, 0x0000000135147824ULL, 0x000fe200078e0203ULL,
0x000000021b367810ULL, 0x000fe20007ffe0ffULL, 0x0000001035457824ULL, 0x000fe200078e00ffULL,
0x000000041b477810ULL, 0x000fe20007ffe0ffULL, 0x0000000135397824ULL, 0x000fe200078e0241ULL,
0x000000f016447812ULL, 0x000fe200078ec0ffULL, 0x000000010f377824ULL, 0x000fe200078e0236ULL,
0xfffffff045457812ULL, 0x000fe200078ee214ULL, 0x000000010f3a7824ULL, 0x000fe200078e0247ULL,
0x000000340c147217ULL, 0x000fe20007800000ULL, 0x0000000137387824ULL, 0x000fe200078e0203ULL,
0x0000004239397210ULL, 0x000fe20007f1e0ffULL, 0x0000001037467824ULL, 0x000fe200078e00ffULL,
0x000000061b497810ULL, 0x000fe20007ffe0ffULL, 0x0000000114147824ULL, 0x000fe200078e0a34ULL,
0x0001400045457811ULL, 0x000fe200078e20ffULL, 0x00000001373b7824ULL, 0x000fe200078e0241ULL,
0xfffffff046467812ULL, 0x000fe200078ee238ULL, 0x000000ffff347224ULL, 0x000fe200000e06ffULL,
0x000000140f147217ULL, 0x000fe20007800000ULL, 0x000000013a387824ULL, 0x040fe200078e0203ULL,
0x00005e0039357a11ULL, 0x000fe200078040ffULL, 0x000000103a487824ULL, 0x000fe200078e00ffULL,
0x000000423b3b7210ULL, 0x000fe20007f7e0ffULL, 0x0000000114147824ULL, 0x000fe200078e0a0fULL,
0x00005f0039397a11ULL, 0x000fe200000f4434ULL, 0x000000013a3a7824ULL, 0x000fe200078e0241ULL,
0xfffffff048487812ULL, 0x000fe200078ee238ULL, 0x000000ffff347224ULL, 0x000fe200018e06ffULL,
0x00005e003b387a11ULL, 0x000fe200078640ffULL, 0x000000010f4a7824ULL, 0x000fe200078e0249ULL,
0x000000141b00720cULL, 0x000fc40003f86070ULL, 0x00005f003b3b7a11ULL, 0x000fe200018f4434ULL,
0x000000014a417824ULL, 0x000fe200078e0241ULL, 0x000000423a3a7210ULL, 0x000fe40007fbe0ffULL,
0x0000004435347210ULL, 0x000fe40007f7e0ffULL, 0x000000143600720cULL, 0x080fe20003f06070ULL,
0x000000ffff377224ULL, 0x000fe200028e06ffULL, 0x00005e003a367a11ULL, 0x000fe200078a40ffULL,
0x000000ffff357224ULL, 0x000fe200018e0639ULL, 0x000000144700720cULL, 0x000fc40003f66070ULL,
0x00005f003a3a7a11ULL, 0x000fe400028f4437ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000034457faeULL, 0x0003e2000e101c46ULL, 0x0000004241377210ULL, 0x000fe20007f9e0ffULL,
0x000000014a417824ULL, 0x000fe200078e0203ULL, 0x0000004436367210ULL, 0x000fe20007fde0ffULL,
0x000000104a4a7824ULL, 0x000fe200078e00ffULL, 0x0001400046467811ULL, 0x000fe200078e20ffULL,
0x000000ffff397224ULL, 0x000fe200020e06ffULL, 0x0001400048487811ULL, 0x000fe400078e20ffULL,
0xfffffff04a417812ULL, 0x000fc400078ee241ULL, 0x0000004438347210ULL, 0x002fe40007fbe0ffULL,
0x00005e0037387a11ULL, 0x000fe400078840ffULL, 0x0001400041417811ULL, 0x000fe200078e20ffULL,
0x000000ffff357224ULL, 0x000fe200028e063bULL, 0x000000144900720cULL, 0x000fe40003fa6070ULL,
0x00005f0037147a11ULL, 0x000fe200020f4439ULL, 0x000000ffff377224ULL, 0x000fe200030e063aULL,
0x0000004438387210ULL, 0x000fe20007f9e0ffULL, 0x0000000034467faeULL, 0x0003e8000c101c46ULL,
0x000000ffff397224ULL, 0x000fe200020e0614ULL, 0x0000000036487faeULL, 0x0003e8000d901c46ULL,
0x0000000038417faeULL, 0x0003e2000e901c46ULL, 0x0000039000007947ULL, 0x000fea0003800000ULL,
0x0000004000347811ULL, 0x000fe200078e38ffULL, 0x000000010f147824ULL, 0x000fe200078e021bULL,
0x000000f016457812ULL, 0x000fc600078ec0ffULL, 0x0000000114367824ULL, 0x140fe200078e0203ULL,
0x0000000214377810ULL, 0x040fe20007ffe0ffULL, 0x0000001014467824ULL, 0x040fe200078e00ffULL,
0x0000000414387810ULL, 0x040fe20007ffe0ffULL, 0x0000000114357824ULL, 0x140fe200078e0234ULL,
0x0000000614147810ULL, 0x000fe20007ffe0ffULL, 0x0000000137417824ULL, 0x040fe200078e0234ULL,
0xfffffff046467812ULL, 0x000fe200078ee236ULL, 0x0000000137367824ULL, 0x000fe200078e0203ULL,
0x0000004235357210ULL, 0x000fe20007f1e0ffULL, 0x0000001037477824ULL, 0x000fe200078e00ffULL,
0x0001400046467811ULL, 0x000fe200078e20ffULL, 0x0000000138377824ULL, 0x000fc400078e0234ULL,
0x0000000114397824ULL, 0x000fe200078e0234ULL, 0xfffffff047477812ULL, 0x000fe200078ee236ULL,
0x0000000138347824ULL, 0x140fe200078e0203ULL, 0x0000004237377210ULL, 0x000fe20007f7e0ffULL,
0x0000001038487824ULL, 0x000fe200078e00ffULL, 0x0001400047477811ULL, 0x000fe200078e20ffULL,
0x0000000114387824ULL, 0x040fe400078e0203ULL, 0x0000001014497824ULL, 0x000fe200078e00ffULL,
0xfffffff048487812ULL, 0x000fe200078ee234ULL, 0x000000ffff147224ULL, 0x000fe200000e06ffULL,
0x00005e00353a7a11ULL, 0x000fc400078040ffULL, 0xfffffff049497812ULL, 0x000fe400078ee238ULL,
0x00005f0035447a11ULL, 0x000fe200000f4414ULL, 0x000000ffff357224ULL, 0x000fe200018e06ffULL,
0x0000004241417210ULL, 0x080fe40007f1e0ffULL, 0x0000004239147210ULL, 0x000fe40007f9e0ffULL,
0x00005e0037367a11ULL, 0x000fe200078640ffULL, 0x000000ffff3b7224ULL, 0x000fe200000e06ffULL,
0x00005e0041397a11ULL, 0x000fe200078040ffULL, 0x000000ffff347224ULL, 0x000fe200020e06ffULL,
0x00005e0014387a11ULL, 0x000fc400078840ffULL, 0x000000453a3a7210ULL, 0x080fe40007fbe0ffULL,
0x00005f0041417a11ULL, 0x000fe400000f443bULL, 0x00005f0014147a11ULL, 0x000fe200020f4434ULL,
0x000000ffff3b7224ULL, 0x000fe200028e0644ULL, 0x00005f0037377a11ULL, 0x000fe400018f4435ULL,
0x0000004539347210ULL, 0x080fe40007f1e0ffULL, 0x0000004536367210ULL, 0x080fe20007f7e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a467faeULL, 0x0003e2000b901c46ULL,
0x0000004538387210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff357224ULL, 0x000fe200000e0641ULL,
0x0001400048487811ULL, 0x000fe200078e20ffULL, 0x000000ffff377224ULL, 0x000fe200018e0637ULL,
0x0001400049497811ULL, 0x000fe200078e20ffULL, 0x000000ffff397224ULL, 0x000fe200020e0614ULL,
0x0000000034477faeULL, 0x0003e8000b901c46ULL, 0x0000000036487faeULL, 0x0003e8000b901c46ULL,
0x0000000038497faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0186a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0186a800ff347f8cULL, 0x002e64000c80043fULL,
0x000000ffff417224ULL, 0x002fc400078e0035ULL, 0x0000000000347805ULL, 0x000fca0000015200ULL,
0x0186b400ff147984ULL, 0x000e640000000800ULL, 0x8000000014ff7812ULL, 0x002fc4000780485dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff387224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fcc0000015200ULL, 0x0000003634367210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003600780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403600780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011437ULL,
0x0000003614147211ULL, 0x000fca00078110ffULL, 0x000000ffff367224ULL, 0x000fca00000e0637ULL,
0x0000000214147819ULL, 0x000fc80000001236ULL, 0x000000140000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000138387810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0186b400ff147984ULL, 0x000e640000000800ULL,
0x8000000014ff7812ULL, 0x002fe4000780485dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000018000007945ULL, 0x000fe20003800000ULL, 0x0000016000002947ULL, 0x000fea0003800000ULL,
0x00000018ff14723eULL, 0x000fe400000010ffULL, 0x00000002ff347819ULL, 0x000fe40000011603ULL,
0x0000541014147816ULL, 0x000fe20000000014ULL, 0x000113927f007947ULL, 0x000fea000b800000ULL,
0x00001f3414197589ULL, 0x0002a400000e0000ULL, 0x00000008341a7810ULL, 0x000fe20007ffe0ffULL,
0x000113e27f007947ULL, 0x000fea000b800000ULL, 0x00001f1a141a7589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001034477810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff5e7224ULL, 0x000fe200078e0014ULL, 0x000117f000447802ULL, 0x000fe20000000f00ULL,
0x0000001fff457424ULL, 0x000fc400078e00ffULL, 0xffffffffff467424ULL, 0x000fc400078e00ffULL,
0x00011d3000007944ULL, 0x00efea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001834477810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff5e7224ULL, 0x000fe200078e0014ULL,
0x0001186000447802ULL, 0x000fe20000000f00ULL, 0x0000001fff457424ULL, 0x000fe400078e00ffULL,
0xffffffffff467424ULL, 0x004fc400078e00ffULL, 0x00011cc000007944ULL, 0x00afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000130003fb77811ULL, 0x000fc400078e20ffULL, 0x000000003e34783bULL, 0x002e680000004200ULL,
0x000000003d44783bULL, 0x004ea80000004200ULL, 0x000000002748783bULL, 0x000f280000004200ULL,
0x000000002638783bULL, 0x000ee20000004200ULL, 0x0000010035727824ULL, 0x002fe200078e00ffULL,
0x00000018ff9c7819ULL, 0x000fe20000011434ULL, 0x0000003400d37306ULL, 0x000fe20000009400ULL,
0x00000100346c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff9b7819ULL, 0x000fe20000011435ULL,
0x0000010037737824ULL, 0x000fe200078e00ffULL, 0x00000018ff727819ULL, 0x000fc40000011472ULL,
0x00000018ffac7819ULL, 0x000fe4000001146cULL, 0x0000003400d47306ULL, 0x000e620000005400ULL,
0x00000018ff8f7819ULL, 0x000fe40000011436ULL, 0x00000018ff8c7819ULL, 0x000fe40000011437ULL,
0x00000018ff807819ULL, 0x004fe40000011444ULL, 0x00000018ff737819ULL, 0x000fe20000011473ULL,
0x0000009c00ce7306ULL, 0x000fe20000209400ULL, 0x00000018ff7b7819ULL, 0x000fc40000011445ULL,
0x00000018ff697819ULL, 0x010fe40000011448ULL, 0x00000018ff777819ULL, 0x000fe40000011446ULL,
0x00000018ff627819ULL, 0x000fe20000011449ULL, 0x0000009c00d17306ULL, 0x000ea20000205400ULL,
0x000000d4d300720bULL, 0x002fe40003fbd000ULL, 0x00000018ff6f7819ULL, 0x000fe40000011447ULL,
0x00000018ff537819ULL, 0x000fc4000001144bULL, 0x00000018ff5f7819ULL, 0x000fe2000001144aULL,
0x0000003400a47306ULL, 0x000322000000d400ULL, 0x00000018ff517819ULL, 0x008fe40000011438ULL,
0x00000018ff4f7819ULL, 0x000fe40000011439ULL, 0x00000018ff4d7819ULL, 0x000fe4000001143aULL,
0x00000018ff147819ULL, 0x000fe2000001143bULL, 0x0000003500d27306ULL, 0x000fe20000009400ULL,
0x0001000034347824ULL, 0x002fe200078e00ffULL, 0x000000d1ce00720bULL, 0x004fc80003f7d000ULL,
0x00000018ffa37819ULL, 0x000fe40000011434ULL, 0x00000035006d7306ULL, 0x000fe20000005400ULL,
0x00000001a4a45812ULL, 0x010fce00078efcffULL, 0x0000003500a27306ULL, 0x0003f0000000d400ULL,
0x0000007200d87306ULL, 0x000fe20000209400ULL, 0x0001000035357824ULL, 0x002fca00078e00ffULL,
0x00000018ffa17819ULL, 0x000fe40000011435ULL, 0x0000007200d77306ULL, 0x000e700000205400ULL,
0x0000007200ab7306ULL, 0x0004f0000020d400ULL, 0x000000a300d67306ULL, 0x000fe20000209400ULL,
0x0000010036727824ULL, 0x004fe200078e00ffULL, 0x000000d7d800720bULL, 0x002fc80003f9d000ULL,
0x00000018ff727819ULL, 0x000fe40000011472ULL, 0x000000a300347306ULL, 0x000e6e0000205400ULL,
0x00000001abab4812ULL, 0x008fe200078efcffULL, 0x0000009c009c7306ULL, 0x000eb0000020d400ULL,
0x000000ac00d57306ULL, 0x000fe20000209400ULL, 0x00000034d600720bULL, 0x002fce0003f1d000ULL,
0x000000ac006c7306ULL, 0x000e620000205400ULL, 0x000000019c9c3812ULL, 0x004fce00078efcffULL,
0x000000a100357306ULL, 0x000ff00000209400ULL, 0x000000a100d97306ULL, 0x000ea20000205400ULL,
0x0000006cd500720bULL, 0x002fce0003fdd000ULL, 0x0000007200da7306ULL, 0x000ff00000209400ULL,
0x0000007200db7306ULL, 0x000e620000205400ULL, 0x000000d93500720bULL, 0x004fe20003fbd000ULL,
0x0000010038357824ULL, 0x000fca00078e00ffULL, 0x00000018ff357819ULL, 0x000fe20000011435ULL,
0x0000003600cd7306ULL, 0x000ff00000009400ULL, 0x0000003600af7306ULL, 0x000ea20000005400ULL,
0x000000dbda00720bULL, 0x002fce0003f7d000ULL, 0x000000a300a37306ULL, 0x000e70000020d400ULL,
0x0000009b00cf7306ULL, 0x000fe20000209400ULL, 0x000000afcd00720bULL, 0x004fce0003f9d000ULL,
0x0000009b00d07306ULL, 0x000ea20000205400ULL, 0x00000001a3a30812ULL, 0x002fce00078efcffULL,
0x0000003700cc7306ULL, 0x000ff00000009400ULL, 0x00000037006a7306ULL, 0x000fe20000005400ULL,
0x000000d0cf00720bULL, 0x004fce0003f1d000ULL, 0x0000003700937306ULL, 0x0003f0000000d400ULL,
0x000000ac00ac7306ULL, 0x000ea2000020d400ULL, 0x0001000037377824ULL, 0x002fca00078e00ffULL,
0x00000018ff8e7819ULL, 0x000fe40000011437ULL, 0x000000a100a17306ULL, 0x000e70000020d400ULL,
0x0000007200977306ULL, 0x000722000020d400ULL, 0x00000001acac6812ULL, 0x004fc400078efcffULL,
0x0000006dd200720bULL, 0x000fca0003fdd000ULL, 0x0000008f00c97306ULL, 0x000fe20000209400ULL,
0x0000010044727824ULL, 0x008fe200078e00ffULL, 0x00000001a1a15812ULL, 0x002fe400078efcffULL,
0x0000006acc00720bULL, 0x000fe40003fbd000ULL, 0x00000018ff727819ULL, 0x000fe40000011472ULL,
0x0000008f00c17306ULL, 0x000e620000205400ULL, 0x0000000197973812ULL, 0x010fe400078efcffULL,
0x00000001a2a26812ULL, 0x000fca00078efcffULL, 0x0000003600967306ULL, 0x0004e2000000d400ULL,
0x0000000193935812ULL, 0x000fce00078efcffULL, 0x0000004400c87306ULL, 0x000fe20000009400ULL,
0x0001000036367824ULL, 0x004fe200078e00ffULL, 0x000000c1c900720bULL, 0x002fc80003f7d000ULL,
0x00000018ff907819ULL, 0x000fe40000011436ULL, 0x0000004400c77306ULL, 0x000fe20000005400ULL,
0x0000000196964812ULL, 0x008fce00078efcffULL, 0x0000004400877306ULL, 0x0003f0000000d400ULL,
0x0000008e00377306ULL, 0x000fe20000209400ULL, 0x0001000044447824ULL, 0x002fca00078e00ffULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x0000008e00df7306ULL, 0x000e700000205400ULL,
0x0000009b009b7306ULL, 0x000eb0000020d400ULL, 0x0000009000de7306ULL, 0x000fe20000209400ULL,
0x000000df3700720bULL, 0x002fce0003f9d000ULL, 0x0000009000367306ULL, 0x000e620000205400ULL,
0x000000019b9b0812ULL, 0x004fce00078efcffULL, 0x0000007300dd7306ULL, 0x000ff00000209400ULL,
0x0000007300dc7306ULL, 0x000ea20000205400ULL, 0x00000036de00720bULL, 0x002fce0003f1d000ULL,
0x0000007300987306ULL, 0x0002f0000020d400ULL, 0x0000008f008f7306ULL, 0x000f22000020d400ULL,
0x0000010045737824ULL, 0x002fe200078e00ffULL, 0x000000dcdd00720bULL, 0x004fc80003fdd000ULL,
0x00000018ff737819ULL, 0x000fe40000011473ULL, 0x0000004500c47306ULL, 0x000fee0000009400ULL,
0x0000000198986812ULL, 0x008fe200078efcffULL, 0x00000045006b7306ULL, 0x000e620000005400ULL,
0x000000018f8f3812ULL, 0x010fce00078efcffULL, 0x0000007200e17306ULL, 0x000ff00000209400ULL,
0x0000007200e07306ULL, 0x000ea20000205400ULL, 0x0000006bc400720bULL, 0x002fce0003f7d000ULL,
0x0000004400e47306ULL, 0x000ff00000209400ULL, 0x0000004400e57306ULL, 0x000fe20000205400ULL,
0x000000e0e100720bULL, 0x004fce0003fbd000ULL, 0x00000044008b7306ULL, 0x0003f0000020d400ULL,
0x0000008e008e7306ULL, 0x000ea2000020d400ULL, 0x0000010046447824ULL, 0x002fca00078e00ffULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x0000007300e27306ULL, 0x000ff00000209400ULL,
0x0000007300e37306ULL, 0x000e620000205400ULL, 0x000000018e8e4812ULL, 0x004fce00078efcffULL,
0x0000009000907306ULL, 0x000eb0000020d400ULL, 0x0000004500847306ULL, 0x000722000000d400ULL,
0x000000e3e200720bULL, 0x002fce0003f9d000ULL, 0x00000072008d7306ULL, 0x000322000020d400ULL,
0x0001000045457824ULL, 0x008fe200078e00ffULL, 0x0000000190900812ULL, 0x004fe400078efcffULL,
0x000000c7c800720bULL, 0x000fe40003f1d000ULL, 0x00000018ff457819ULL, 0x000fe40000011445ULL,
0x0000008c00cb7306ULL, 0x000fe20000209400ULL, 0x0000010048727824ULL, 0x002fe200078e00ffULL,
0x0000000184843812ULL, 0x010fc800078efcffULL, 0x00000018ff727819ULL, 0x000fe40000011472ULL,
0x0000008c00ca7306ULL, 0x000e620000205400ULL, 0x000000018d8d5812ULL, 0x000fe400078efcffULL,
0x0000000187870812ULL, 0x000fca00078efcffULL, 0x0000008000c37306ULL, 0x000ff00000209400ULL,
0x0000008000c27306ULL, 0x000ea20000205400ULL, 0x000000cacb00720bULL, 0x002fce0003fdd000ULL,
0x0000004400e87306ULL, 0x000ff00000209400ULL, 0x0000004400e97306ULL, 0x000e620000205400ULL,
0x000000c2c300720bULL, 0x004fce0003fbd000ULL, 0x00000073008a7306ULL, 0x0004f0000020d400ULL,
0x0000007b00c07306ULL, 0x000fe20000209400ULL, 0x0001000048737824ULL, 0x004fe200078e00ffULL,
0x000000e9e800720bULL, 0x002fc80003f7d000ULL, 0x00000018ff737819ULL, 0x000fe40000011473ULL,
0x0000007b00bf7306ULL, 0x000e620000205400ULL, 0x000000018a8a4812ULL, 0x008fce00078efcffULL,
0x0000004800b27306ULL, 0x000ff00000009400ULL, 0x0000004800b07306ULL, 0x000fe20000005400ULL,
0x000000bfc000720bULL, 0x002fce0003f9d000ULL, 0x00000048006e7306ULL, 0x000ff0000000d400ULL,
0x0000004500e77306ULL, 0x000ff00000209400ULL, 0x0000004500e67306ULL, 0x000e700000205400ULL,
0x0000004500857306ULL, 0x0004f0000020d400ULL, 0x0000007200c57306ULL, 0x000fe20000209400ULL,
0x0000010047457824ULL, 0x004fe200078e00ffULL, 0x000000e6e700720bULL, 0x002fc80003f1d000ULL,
0x00000018ff457819ULL, 0x000fe40000011445ULL, 0x0000007200c67306ULL, 0x000fee0000205400ULL,
0x0000000185850812ULL, 0x008fe200078efcffULL, 0x0000007200487306ULL, 0x0003f0000020d400ULL,
0x0000004600ba7306ULL, 0x000fe20000009400ULL, 0x0000010049727824ULL, 0x002fca00078e00ffULL,
0x00000018ff727819ULL, 0x000fe40000011472ULL, 0x0000004600b67306ULL, 0x000ff00000005400ULL,
0x00000046007a7306ULL, 0x0003f0000000d400ULL, 0x0000004900a67306ULL, 0x000fe20000009400ULL,
0x0001000046467824ULL, 0x002fca00078e00ffULL, 0x00000018ff467819ULL, 0x000fe40000011446ULL,
0x0000004900a87306ULL, 0x000ff00000005400ULL, 0x0000004900667306ULL, 0x0003f0000000d400ULL,
0x0000008c008c7306ULL, 0x000ea2000020d400ULL, 0x0001000049497824ULL, 0x002fca00078e00ffULL,
0x00000018ff497819ULL, 0x000fe40000011449ULL, 0x0000008000807306ULL, 0x000e70000020d400ULL,
0x0000004400867306ULL, 0x000ee2000020d400ULL, 0x000000018c8c6812ULL, 0x004fc400078efcffULL,
0x000000e5e400720bULL, 0x000fca0003fdd000ULL, 0x0000004700b87306ULL, 0x000fe20000009400ULL,
0x0000000180805812ULL, 0x002fce00078efcffULL, 0x0000004700b97306ULL, 0x000e620000005400ULL,
0x0000000186863812ULL, 0x008fe400078efcffULL, 0x000000b0b200720bULL, 0x000fe40003f7d000ULL,
0x000000018b8b6812ULL, 0x000fe400078efcffULL, 0x000000b6ba00720bULL, 0x000fe20003fdd000ULL,
0x0000004700747306ULL, 0x0004e2000000d400ULL, 0x0000008b8080723eULL, 0x000fce00000010ffULL,
0x0000007b007b7306ULL, 0x000f22000020d400ULL, 0x0001000047477824ULL, 0x004fe200078e00ffULL,
0x000000b9b800720bULL, 0x002fe40003fbd000ULL, 0x000000016e6e3812ULL, 0x000fe400078efcffULL,
0x00000018ff7e7819ULL, 0x000fe40000011447ULL, 0x0000004500ea7306ULL, 0x000fe20000209400ULL,
0x000000017a7a6812ULL, 0x000fc800078efcffULL, 0x0000007a867a723eULL, 0x000fe400000010ffULL,
0x0000000174745812ULL, 0x008fe200078efcffULL, 0x0000004500eb7306ULL, 0x000e620000205400ULL,
0x000000017b7b4812ULL, 0x010fce00078efcffULL, 0x00000045007f7306ULL, 0x000eb0000020d400ULL,
0x0000007300bb7306ULL, 0x000fe20000209400ULL, 0x000000ebea00720bULL, 0x002fce0003f1d000ULL,
0x0000007300bc7306ULL, 0x000fec0000205400ULL, 0x000000017f7f0812ULL, 0x004fe400078efcffULL,
0x0000007300787306ULL, 0x000ff0000020d400ULL, 0x0000004600447306ULL, 0x000ff00000209400ULL,
0x0000004600457306ULL, 0x000e700000205400ULL, 0x0000004900ad7306ULL, 0x000ff00000209400ULL,
0x0000004900ae7306ULL, 0x000fe20000205400ULL, 0x000000454400720bULL, 0x002fc40003f9d000ULL,
0x0001300040447811ULL, 0x000fca00078e20ffULL, 0x0000004900737306ULL, 0x0003f0000020d400ULL,
0x0000004b009e7306ULL, 0x000fe20000009400ULL, 0x000001004b497824ULL, 0x002fca00078e00ffULL,
0x00000018ff497819ULL, 0x000fe40000011449ULL, 0x0000004b009d7306ULL, 0x000ff00000005400ULL,
0x0000004b005e7306ULL, 0x0003f0000000d400ULL, 0x0000004600837306ULL, 0x000ea2000020d400ULL,
0x000100004b4b7824ULL, 0x002fca00078e00ffULL, 0x00000018ff347819ULL, 0x000fe4000001144bULL,
0x0000007e00467306ULL, 0x000ff00000209400ULL, 0x0000007e00477306ULL, 0x000e620000205400ULL,
0x0000000183834812ULL, 0x004fc400078efcffULL, 0x000000c6c500720bULL, 0x000fca0003f9d000ULL,
0x0000007200bd7306ULL, 0x000ff00000209400ULL, 0x0000007200be7306ULL, 0x000ea20000205400ULL,
0x000000474600720bULL, 0x002fe40003fbd000ULL, 0x000000004444783bULL, 0x000e620000000200ULL,
0x0000000148484812ULL, 0x000fc800078efcffULL, 0x00000034004b7306ULL, 0x000ff00000209400ULL,
0x0000003400af7306ULL, 0x000fe20000205400ULL, 0x000000bebd00720bULL, 0x004fce0003f7d000ULL,
0x00000034006a7306ULL, 0x0005f0000020d400ULL, 0x0000006f00b37306ULL, 0x000fe20000209400ULL,
0x0000010039347824ULL, 0x004fca00078e00ffULL, 0x00000018ffc37819ULL, 0x000fe40000011434ULL,
0x0000006f00b47306ULL, 0x000ea20000205400ULL, 0x000000194444a231ULL, 0x082fe400003400ffULL,
0x000000194646a231ULL, 0x000fe400003400ffULL, 0x0000001a4545a231ULL, 0x000fc600003400ffULL,
0x0000003500c17306ULL, 0x000fe20000209400ULL, 0x0000001a4747a231ULL, 0x000fce00003400ffULL,
0x0000003500c77306ULL, 0x000fe20000205400ULL, 0x000000b4b300720bULL, 0x004fe20003f1d000ULL,
0x000001003ab47824ULL, 0x000fe400078e00ffULL, 0x000100003bb37824ULL, 0x000fc600078e00ffULL,
0x00000018ffb47819ULL, 0x000fe200000114b4ULL, 0x00000035006b7306ULL, 0x0003e2000020d400ULL,
0x00000018ffb37819ULL, 0x000fce00000114b3ULL, 0x0000007200797306ULL, 0x0004e2000020d400ULL,
0x00000000b734783bULL, 0x00232e0000000200ULL, 0x0000007700b57306ULL, 0x000fe20000209400ULL,
0x000001004a727824ULL, 0x004fe400078e00ffULL, 0x000001003bb77824ULL, 0x002fc600078e00ffULL,
0x00000018ff727819ULL, 0x000fe40000011472ULL, 0x0000007700b17306ULL, 0x000e620000205400ULL,
0x0000000179793812ULL, 0x008fe400078efcffULL, 0x00000018ffb77819ULL, 0x000fca00000114b7ULL,
0x0000006200957306ULL, 0x000ff00000209400ULL, 0x0000006200947306ULL, 0x000ea20000205400ULL,
0x000000b1b500720bULL, 0x002fe20003fdd000ULL, 0x000100003ab57824ULL, 0x000fca00078e00ffULL,
0x00000018ffb57819ULL, 0x000fe200000114b5ULL, 0x0000006f006f7306ULL, 0x000e62000020d400ULL,
0x000000193434a231ULL, 0x090fe400003400ffULL, 0x000000193636a231ULL, 0x000fe400003400ffULL,
0x0000001a3535a231ULL, 0x080fe400003400ffULL, 0x0000001a3737a231ULL, 0x000fe200003400ffULL,
0x0000007700777306ULL, 0x000ee2000020d400ULL, 0x000000949500720bULL, 0x004fce0003f7d000ULL,
0x0000006200627306ULL, 0x000ea2000020d400ULL, 0x000000016f6f0812ULL, 0x002fe400078efcffULL,
0x000000bcbb00720bULL, 0x000fca0003f1d000ULL, 0x0000007e007e7306ULL, 0x000e62000020d400ULL,
0x0000000177776812ULL, 0x008fe400078efcffULL, 0x000000a8a600720bULL, 0x000fca0003fdd000ULL,
0x0000004a00aa7306ULL, 0x000fe20000009400ULL, 0x0000000162623812ULL, 0x004fe400078efcffULL,
0x0000000178780812ULL, 0x000fe400078efcffULL, 0x0000009d9e00720bULL, 0x000fc60003f1d000ULL,
0x0000004a00a57306ULL, 0x000ea20000005400ULL, 0x000000017e7e5812ULL, 0x002fe400078efcffULL,
0x0000000166666812ULL, 0x000fe400078efcffULL, 0x000000aead00720bULL, 0x000fc60003fdd000ULL,
0x0000006900a77306ULL, 0x000fe40000209400ULL, 0x000000015e5e0812ULL, 0x000fe400078efcffULL,
0x000000af4b00720bULL, 0x000fe40003f1d000ULL, 0x0000007e6f4b723eULL, 0x000fe400000010ffULL,
0x0000006900a97306ULL, 0x000e620000205400ULL, 0x000000a5aa00720bULL, 0x004fe40003f9d000ULL,
0x0000000173736812ULL, 0x000fca00078efcffULL, 0x0000004900917306ULL, 0x000fe20000209400ULL,
0x000000016a6a0812ULL, 0x000fce00078efcffULL, 0x0000004900927306ULL, 0x000ea20000205400ULL,
0x000000a9a700720bULL, 0x002fce0003fbd000ULL, 0x0000004a00657306ULL, 0x0002f0000000d400ULL,
0x0000006900697306ULL, 0x000f22000020d400ULL, 0x000000929100720bULL, 0x004fe20003f7d000ULL,
0x000100004a4a7824ULL, 0x002fca00078e00ffULL, 0x00000018ffd57819ULL, 0x000fe2000001144aULL,
0x00000049006c7306ULL, 0x000e62000020d400ULL, 0x0000000165654812ULL, 0x008fce00078efcffULL,
0x00000038009f7306ULL, 0x000fe20000009400ULL, 0x0000000169695812ULL, 0x010fce00078efcffULL,
0x0000003800a07306ULL, 0x000ea20000005400ULL, 0x000000016c6c3812ULL, 0x002fce00078efcffULL,
0x0000005f00817306ULL, 0x000ff00000209400ULL, 0x0000005f00827306ULL, 0x000e620000205400ULL,
0x000000a09f00720bULL, 0x004fce0003fbd000ULL, 0x00000053007c7306ULL, 0x000ff00000209400ULL,
0x00000053007d7306ULL, 0x000ea20000205400ULL, 0x000000828100720bULL, 0x002fe40003f9d000ULL,
0x000000857b81723eULL, 0x000fc400000010ffULL, 0x000000747f7b723eULL, 0x000fc600000010ffULL,
0x0000007200997306ULL, 0x000fe40000209400ULL, 0x000000803454723cULL, 0x040fec0000041854ULL,
0x00000072009a7306ULL, 0x000e620000205400ULL, 0x0000007d7c00720bULL, 0x004fe20003f7d000ULL,
0x0000007a3458723cULL, 0x000fec0000041858ULL, 0x00000038005d7306ULL, 0x0004f0000000d400ULL,
0x0000003900897306ULL, 0x000fe20000009400ULL, 0x0001000038387824ULL, 0x004fe200078e00ffULL,
0x0000009a9900720bULL, 0x002fc80003f5d000ULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x0000003900887306ULL, 0x000e620000005400ULL, 0x000000015d5d5812ULL, 0x008fce00078efcffULL,
0x0000003900507306ULL, 0x0004f0000000d400ULL, 0x0000003a00757306ULL, 0x000fe20000009400ULL,
0x0001000039397824ULL, 0x004fe200078e00ffULL, 0x000000888900720bULL, 0x002fc80003fdd000ULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000003a00767306ULL, 0x000fee0000005400ULL,
0x0000000150506812ULL, 0x008fe200078efcffULL, 0x0000003a004e7306ULL, 0x0003f0000000d400ULL,
0x0000003b00707306ULL, 0x000fe20000009400ULL, 0x000000a4ac3a723eULL, 0x002fce00000010ffULL,
0x0000003b00717306ULL, 0x000e700000005400ULL, 0x0000003b004c7306ULL, 0x0005f0000000d400ULL,
0x0000005f005f7306ULL, 0x000ee2000020d400ULL, 0x000000a2ab3b723eULL, 0x004fc400000010ffULL,
0x000000717000720bULL, 0x002fca0003f1d000ULL, 0x0000005300537306ULL, 0x000e62000020d400ULL,
0x0000003a3420723cULL, 0x000b6e0000041820ULL, 0x0000007200727306ULL, 0x000ea2000020d400ULL,
0x00000096973a723eULL, 0x020fe400000010ffULL, 0x00000093983b723eULL, 0x000fc400000010ffULL,
0x000000015f5f4812ULL, 0x008fe400078efcffULL, 0x000000c7c100720bULL, 0x000fe20003f9d000ULL,
0x000000d500497306ULL, 0x000fe20000209400ULL, 0x0000000153533812ULL, 0x002fe200078efcffULL,
0x0000003a342c723cULL, 0x000b62000004182cULL, 0x000000014c4c0812ULL, 0x000fca00078efcffULL,
0x000000d5004a7306ULL, 0x000e620000205400ULL, 0x0000000172722812ULL, 0x004fe400078efcffULL,
0x000000878d3a723eULL, 0x020fe400000010ffULL, 0x000000848a3b723eULL, 0x000fe400000010ffULL,
0x000000016b6b4812ULL, 0x000fe200078efcffULL, 0x000000c300c27306ULL, 0x000fe80000209400ULL,
0x0000003a3404723cULL, 0x000fe80000041804ULL, 0x000000c300bf7306ULL, 0x000ea20000205400ULL,
0x0000004a4900720bULL, 0x002fc40003f5d000ULL, 0x00000083774a723eULL, 0x000fca00000010ffULL,
0x0000003800b27306ULL, 0x000ff00000209400ULL, 0x0000003800b17306ULL, 0x000e620000205400ULL,
0x000000bfc200720bULL, 0x004fce0003f7d000ULL, 0x0000003800b07306ULL, 0x0004f0000020d400ULL,
0x0000003900a67306ULL, 0x000fe20000209400ULL, 0x000000a39c38723eULL, 0x004fe400000010ffULL,
0x000000b1b200720bULL, 0x002fca0003fbd000ULL, 0x0000003900a27306ULL, 0x000ff00000205400ULL,
0x00000039009d7306ULL, 0x0003e2000020d400ULL, 0x00000001b0b05812ULL, 0x008fce00078efcffULL,
0x000000d5006d7306ULL, 0x000ea2000020d400ULL, 0x000000a19b39723eULL, 0x002fce00000010ffULL,
0x000000383428723cULL, 0x000be20000041828ULL, 0x000000c300b67306ULL, 0x000e6c000020d400ULL,
0x000000908f38723eULL, 0x020fe400000010ffULL, 0x0000008e8c39723eULL, 0x000fe200000010ffULL,
0x0000005100677306ULL, 0x000fe20000209400ULL, 0x000000016d6d2812ULL, 0x004fc400078efcffULL,
0x000000767500720bULL, 0x000fc60003f5d000ULL, 0x000000383408723cULL, 0x000b620000041808ULL,
0x00000001b6b63812ULL, 0x002fe200078efcffULL, 0x0000005100687306ULL, 0x000e620000205400ULL,
0x000000a2a600720bULL, 0x000fc80003f7d000ULL, 0x0000006e4838723eULL, 0x020fe400000010ffULL,
0x000000667939723eULL, 0x000fe200000010ffULL, 0x0000004f00637306ULL, 0x000fe20000209400ULL,
0x0000004a3448723cULL, 0x000b620000041830ULL, 0x000000014e4e2812ULL, 0x000fc800078efcffULL,
0x000000019d9d3812ULL, 0x000fe400078efcffULL, 0x0000004f00647306ULL, 0x000ea20000205400ULL,
0x000000384438723cULL, 0x000b620000041820ULL, 0x000000686700720bULL, 0x002fe40003f9d000ULL,
0x000000657230723eULL, 0x020fe400000010ffULL, 0x0000005e6c31723eULL, 0x000fe400000010ffULL,
0x000000b400947306ULL, 0x000fe20000209400ULL, 0x0000006d5f20723eULL, 0x000fc400000010ffULL,
0x0000006a5321723eULL, 0x000fe400000010ffULL, 0x000000304430723cULL, 0x040f62000004182cULL,
0x000000786934723eULL, 0x000fe400000010ffULL, 0x000000b400937306ULL, 0x000e620000205400ULL,
0x000000646300720bULL, 0x004fe40003fdd000ULL, 0x000000736235723eULL, 0x000fe400000010ffULL,
0x00000020442c723cULL, 0x040f660000041808ULL, 0x0000005100517306ULL, 0x000eaa000020d400ULL,
0x000000344434723cULL, 0x000b660000041828ULL, 0x0000004f004f7306ULL, 0x000ee2000020d400ULL,
0x000000939400720bULL, 0x002fc60003fbd000ULL, 0x0000005d6b28723eULL, 0x020fe400000010ffULL,
0x00000050b629723eULL, 0x000fe400000010ffULL, 0x000000b400b47306ULL, 0x000e62000020d400ULL,
0x0000000151514812ULL, 0x004fc800078efcffULL, 0x000000284428723cULL, 0x000b620000041804ULL,
0x000000b05108723eULL, 0x000fe400000010ffULL, 0x0000004d00607306ULL, 0x000fe20000209400ULL,
0x000000014f4f6812ULL, 0x008fc800078efcffULL, 0x0000009d4f09723eULL, 0x000fc600000010ffULL,
0x0000004d00617306ULL, 0x000ea20000205400ULL, 0x00000001b4b45812ULL, 0x002fc600078efcffULL,
0x000000084408723cULL, 0x000b640000041854ULL, 0x0000004eb404723eULL, 0x020fe400000010ffULL,
0x0000001400527306ULL, 0x000ff00000209400ULL, 0x00000014005c7306ULL, 0x000e620000205400ULL,
0x000000616000720bULL, 0x004fce0003f9d000ULL, 0x000000b700847306ULL, 0x000ff00000209400ULL,
0x000000b7007c7306ULL, 0x000ea20000205400ULL, 0x0000005c5200720bULL, 0x002fce0003f7d000ULL,
0x000000b5006f7306ULL, 0x000ff00000209400ULL, 0x000000b500667306ULL, 0x000e620000205400ULL,
0x0000007c8400720bULL, 0x004fce0003fdd000ULL, 0x000000b300227306ULL, 0x000ff00000209400ULL,
0x000000b300237306ULL, 0x000ea20000205400ULL, 0x000000666f00720bULL, 0x002fce0003fbd000ULL,
0x0000004d004d7306ULL, 0x000e70000020d400ULL, 0x0000001400147306ULL, 0x000ee2000020d400ULL,
0x000000232200720bULL, 0x004fce0003f5d000ULL, 0x000000b700b77306ULL, 0x000ea2000020d400ULL,
0x000000014d4d4812ULL, 0x002fce00078efcffULL, 0x000000b500b57306ULL, 0x000e62000020d400ULL,
0x0000000114143812ULL, 0x008fce00078efcffULL, 0x000000b300217306ULL, 0x000ee2000020d400ULL,
0x00000001b7b76812ULL, 0x004fc800078efcffULL, 0x0000004cb705723eULL, 0x000fe400000010ffULL,
0x00000001b5b55812ULL, 0x002fc800078efcffULL, 0x000000b54d20723eULL, 0x000fe200000010ffULL,
0x000000044404723cULL, 0x000b620000041858ULL, 0x0000000121212812ULL, 0x008fc800078efcffULL,
0x000000211421723eULL, 0x000fce00000010ffULL, 0x000000204420723cULL, 0x000b620000041848ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0186b800ff447f8cULL, 0x020e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000803c147810ULL, 0x000fe20007ffe0ffULL, 0x01869800ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff487224ULL, 0x002fe400078e0045ULL, 0x0000000c1400720cULL, 0x000fe40003f06070ULL,
0x0000000115147810ULL, 0x000fd60007ffe0ffULL, 0x000060c000000947ULL, 0x000fea0003800000ULL,
0x0000000000447805ULL, 0x000fc40000015200ULL, 0x0186bc00ff107984ULL, 0x000e640000000800ULL,
0x8000000010ff7812ULL, 0x002fe40007804848ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff497224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104900780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000467805ULL, 0x000fcc0000015200ULL,
0x0000004644147210ULL, 0x000fca0007f1e1ffULL, 0x0000000147467824ULL, 0x000fe200000e0e45ULL,
0x003d09001400780cULL, 0x000fc80003f06070ULL, 0x000000ff4600720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401400780cULL, 0x000fc80003f06070ULL,
0x000000ff4600720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff107819ULL, 0x000fc80000011446ULL, 0x0000001410107211ULL, 0x000fca00078110ffULL,
0x000000ffff147224ULL, 0x000fca00000e0646ULL, 0x0000000210107819ULL, 0x000fc80000001214ULL,
0x000000100000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000149497810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0186bc00ff107984ULL, 0x000e640000000800ULL, 0x8000000010ff7812ULL, 0x002fe40007804848ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000046000009947ULL, 0x000fea0003800000ULL,
0x000000a03c107810ULL, 0x000fe20007ffe0ffULL, 0x000000010f447824ULL, 0x000fe200078e021bULL,
0x000000041b497810ULL, 0x040fe40007ffe0ffULL, 0x000000021b487810ULL, 0x000fe20007ffe0ffULL,
0x0000000144457824ULL, 0x000fe200078e0203ULL, 0x000000100c147217ULL, 0x000fe20007800000ULL,
0x000000010f4a7824ULL, 0x000fe200078e0249ULL, 0x000000061b507810ULL, 0x000fe20007ffe0ffULL,
0x00000010444d7824ULL, 0x000fe200078e00ffULL, 0x000000f0164c7812ULL, 0x000fe200078ec0ffULL,
0x0000000114147824ULL, 0x000fe200078e0a10ULL, 0x0000006000107811ULL, 0x000fe200078e38ffULL,
0x000000010f467824ULL, 0x000fe200078e0248ULL, 0xfffffff04d4d7812ULL, 0x000fe200078ee245ULL,
0x000000014a4b7824ULL, 0x140fe200078e0203ULL, 0x000000140f147217ULL, 0x000fe20007800000ULL,
0x000000104a4f7824ULL, 0x000fe200078e00ffULL, 0x000160004d4d7811ULL, 0x000fe200078e20ffULL,
0x0000000146477824ULL, 0x000fc400078e0203ULL, 0x00000010464e7824ULL, 0x000fe200078e00ffULL,
0xfffffff04f4f7812ULL, 0x000fe200078ee24bULL, 0x0000000144457824ULL, 0x000fe400078e0210ULL,
0x000000010f447824ULL, 0x000fe200078e0250ULL, 0xfffffff04e4e7812ULL, 0x000fe200078ee247ULL,
0x00000001464b7824ULL, 0x100fe200078e0210ULL, 0x0000004245457210ULL, 0x080fe20007f1e0ffULL,
0x000000014a477824ULL, 0x100fe200078e0210ULL, 0x000160004e4e7811ULL, 0x000fe200078e20ffULL,
0x0000000144107824ULL, 0x040fe200078e0210ULL, 0x000000424b4b7210ULL, 0x080fe20007f3e0ffULL,
0x0000000144467824ULL, 0x040fe200078e0203ULL, 0x0000004247477210ULL, 0x080fe20007f9e0ffULL,
0x0000001044517824ULL, 0x000fe200078e00ffULL, 0x0000004210107210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff427224ULL, 0x000fe200008e06ffULL, 0x00005e004b4a7a11ULL, 0x000fe200078440ffULL,
0x0000000114147824ULL, 0x000fe200078e0a0fULL, 0xfffffff051517812ULL, 0x000fe200078ee246ULL,
0x000000ffff467224ULL, 0x000fe200000e06ffULL, 0x00005e0045447a11ULL, 0x000fc400078040ffULL,
0x00005f004b4b7a11ULL, 0x000fe200010f4442ULL, 0x000000ffff427224ULL, 0x000fe200018e06ffULL,
0x000000141b00720cULL, 0x000fe40003f46070ULL, 0x00005f0045457a11ULL, 0x000fe400000f4446ULL,
0x0000004c44447210ULL, 0x000fe40007fbe0ffULL, 0x000000144900720cULL, 0x080fe20003f06070ULL,
0x000000ffff497224ULL, 0x000fe200020e06ffULL, 0x00005e0047467a11ULL, 0x000fe200078840ffULL,
0x000000ffff457224ULL, 0x000fe200028e0645ULL, 0x000000144800720cULL, 0x000fc40003f26070ULL,
0x00005e0010487a11ULL, 0x000fe400078c40ffULL, 0x000000145000720cULL, 0x000fe20003f66070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000444d7faeULL, 0x0003e2000d101c46ULL,
0x00005f0047147a11ULL, 0x000fe400020f4449ULL, 0x0000004c46467210ULL, 0x080fe40007f9e0ffULL,
0x00005f0010107a11ULL, 0x000fe400030f4442ULL, 0x0000004c48487210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff477224ULL, 0x000fe200020e0614ULL, 0x000160004f4f7811ULL, 0x000fc400078e20ffULL,
0x0001600051517811ULL, 0x000fe200078e20ffULL, 0x000000ffff497224ULL, 0x000fe200028e0610ULL,
0x0000004c4a447210ULL, 0x002fca0007f5e0ffULL, 0x000000ffff457224ULL, 0x000fca00010e064bULL,
0x00000000444e7faeULL, 0x0003e8000c901c46ULL, 0x00000000464f7faeULL, 0x0003e8000c101c46ULL,
0x0000000048517faeULL, 0x0003e2000d901c46ULL, 0x0000039000007947ULL, 0x000fea0003800000ULL,
0x000000010f107824ULL, 0x000fe200078e021bULL, 0x0000006000147811ULL, 0x000fc400078e38ffULL,
0x000000f0164c7812ULL, 0x000fe200078ec0ffULL, 0x0000000110447824ULL, 0x040fe200078e0203ULL,
0x0000000210467810ULL, 0x040fe20007ffe0ffULL, 0x00000010104d7824ULL, 0x040fe200078e00ffULL,
0x0000000410487810ULL, 0x000fc60007ffe0ffULL, 0x0000000146457824ULL, 0x040fe200078e0203ULL,
0xfffffff04d4d7812ULL, 0x000fe200078ee244ULL, 0x00000010464e7824ULL, 0x000fe400078e00ffULL,
0x0000000110447824ULL, 0x140fe200078e0214ULL, 0x0000000610107810ULL, 0x000fe20007ffe0ffULL,
0x0000000146477824ULL, 0x100fe200078e0214ULL, 0xfffffff04e4e7812ULL, 0x000fe200078ee245ULL,
0x0000000148467824ULL, 0x100fe200078e0203ULL, 0x0000004244457210ULL, 0x080fe20007f5e0ffULL,
0x0000000148447824ULL, 0x100fe200078e0214ULL, 0x0000004247477210ULL, 0x080fe20007f1e0ffULL,
0x0000000110497824ULL, 0x000fe200078e0214ULL, 0x00005e00454a7a11ULL, 0x000fe200078640ffULL,
0x00000010484f7824ULL, 0x000fe200078e00ffULL, 0x0000004244447210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff147224ULL, 0x000fe200010e06ffULL, 0x000160004d4d7811ULL, 0x000fe200078e20ffULL,
0x0000000110487824ULL, 0x040fe200078e0203ULL, 0xfffffff04f4f7812ULL, 0x000fe200078ee246ULL,
0x0000001010507824ULL, 0x000fe200078e00ffULL, 0x0000004249107210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff497224ULL, 0x000fe200000e06ffULL, 0x00005f00454b7a11ULL, 0x000fe200018f4414ULL,
0x000000ffff427224ULL, 0x000fe200008e06ffULL, 0x00005e0047457a11ULL, 0x000fe200078040ffULL,
0x000000ffff147224ULL, 0x000fe200010e06ffULL, 0x00005e0044467a11ULL, 0x000fc400078240ffULL,
0xfffffff050507812ULL, 0x000fe400078ee248ULL, 0x00005e0010487a11ULL, 0x000fe400078440ffULL,
0x0000004c4a4a7210ULL, 0x080fe40007f7e0ffULL, 0x00005f0047477a11ULL, 0x000fe400000f4449ULL,
0x00005f0044427a11ULL, 0x000fe200008f4442ULL, 0x000000ffff4b7224ULL, 0x000fe200018e064bULL,
0x0000004c45447210ULL, 0x000fc40007f1e0ffULL, 0x00005f0010107a11ULL, 0x000fe400010f4414ULL,
0x0000004c46467210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff457224ULL, 0x000fe200000e0647ULL,
0x0000004c48487210ULL, 0x000fe20007f5e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000004a4d7faeULL, 0x0003e2000b901c46ULL, 0x000160004e4e7811ULL, 0x000fe200078e20ffULL,
0x000000ffff477224ULL, 0x000fe200008e0642ULL, 0x000160004f4f7811ULL, 0x000fe200078e20ffULL,
0x000000ffff497224ULL, 0x000fe200010e0610ULL, 0x0001600050507811ULL, 0x000fe200078e20ffULL,
0x00000000444e7faeULL, 0x0003e8000b901c46ULL, 0x00000000464f7faeULL, 0x0003e8000b901c46ULL,
0x0000000048507faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000215447810ULL, 0x002fc80007ffe0ffULL, 0x0000000d4400720cULL, 0x000fe20003f06070ULL,
0xffffffffff107424ULL, 0x000fd800078e00ffULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x0000000112447824ULL, 0x000fe400078e0244ULL, 0x00000004ff457424ULL, 0x000fc800078e00ffULL,
0x0000600044447625ULL, 0x000fca00078e0045ULL, 0x0000000644107981ULL, 0x000324000c1e1900ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0186b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0186b000ff507f8cULL, 0x000ea2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018668000f487f8cULL, 0x000664000c80043fULL,
0x0000000000447805ULL, 0x002fc40000015200ULL, 0x01866c000f147984ULL, 0x000e640000000800ULL,
0x8000000014ff7812ULL, 0x002fe40007804849ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000467805ULL, 0x000fcc0000015200ULL,
0x0000004644427210ULL, 0x000fca0007f1e1ffULL, 0x0000000147467824ULL, 0x000fe200000e0e45ULL,
0x003d09004200780cULL, 0x000fc80003f06070ULL, 0x000000ff4600720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404200780cULL, 0x000fc80003f06070ULL,
0x000000ff4600720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011446ULL, 0x0000004214147211ULL, 0x000fca00078110ffULL,
0x000000ffff427224ULL, 0x000fca00000e0646ULL, 0x0000000214147819ULL, 0x000fc80000001242ULL,
0x000000140000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000014a4a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01866c000f147984ULL, 0x000e640000000800ULL, 0x8000000014ff7812ULL, 0x002fe40007804849ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0181800017147984ULL, 0x000e680000000800ULL,
0x0183800017427984ULL, 0x0006a20000000800ULL, 0x000000431400720bULL, 0x002fe20003f1d000ULL,
0x0000e7227f007947ULL, 0x000fd8000b800000ULL, 0x0000000000487806ULL, 0x008fc800000e0100ULL,
0x0000ffff48ff7812ULL, 0x000fe2000780c0ffULL, 0x0000047000007945ULL, 0x000fe20003800000ULL,
0x00000001ff497424ULL, 0x000fd600078e00ffULL, 0x0000044000008947ULL, 0x000fea0003800000ULL,
0x000000030200780cULL, 0x000fe40003f05270ULL, 0x000000431400720bULL, 0x000fe20003f34000ULL,
0x0000e7027f007947ULL, 0x000fd8000b800000ULL, 0x0000000000497806ULL, 0x000fc400008e0100ULL,
0x0000004314448209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe80003800000ULL,
0x0185804417008388ULL, 0x0003e40000000800ULL, 0x0000991049177816ULL, 0x002fc800000000ffULL,
0x000000ff1700720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000004314177209ULL, 0x000fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff49ff7812ULL, 0x000fc6000780c0ffULL, 0x0000004317177221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b17177820ULL, 0x000fc80000410000ULL, 0x00000017005e7308ULL, 0x000e640000000800ULL,
0x0000005e11117220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff177819ULL, 0x000fe20000011603ULL, 0x0000e6527f007947ULL, 0x000fea000b800000ULL,
0x00001f175e177589ULL, 0x0002e400000e0000ULL, 0x0000001738387220ULL, 0x088fe40000410000ULL,
0x0000001739397220ULL, 0x080fe40000410000ULL, 0x0000001734347220ULL, 0x080fe40000410000ULL,
0x0000001735357220ULL, 0x000fc40000410000ULL, 0x0000001730307220ULL, 0x080fe40000410000ULL,
0x0000001731317220ULL, 0x080fe40000410000ULL, 0x000000172c2c7220ULL, 0x080fe40000410000ULL,
0x000000172d2d7220ULL, 0x080fe40000410000ULL, 0x0000001728287220ULL, 0x080fe40000410000ULL,
0x0000001729297220ULL, 0x000fc40000410000ULL, 0x0000001708087220ULL, 0x080fe40000410000ULL,
0x0000001709097220ULL, 0x080fe40000410000ULL, 0x0000001704047220ULL, 0x080fe40000410000ULL,
0x0000001705057220ULL, 0x080fe40000410000ULL, 0x0000001720207220ULL, 0x080fe40000410000ULL,
0x0000001721217220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0049ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000803177811ULL, 0x000fe200078ff0ffULL, 0x0000e5627f007947ULL, 0x000fea000b800000ULL,
0x00001f175e177589ULL, 0x00066400000e0000ULL, 0x000000173a3a7220ULL, 0x082fe40000410000ULL,
0x000000173b3b7220ULL, 0x080fe40000410000ULL, 0x0000001736367220ULL, 0x080fe40000410000ULL,
0x0000001737377220ULL, 0x080fe40000410000ULL, 0x0000001732327220ULL, 0x080fe40000410000ULL,
0x0000001733337220ULL, 0x000fc40000410000ULL, 0x000000172e2e7220ULL, 0x080fe40000410000ULL,
0x000000172f2f7220ULL, 0x080fe40000410000ULL, 0x000000172a2a7220ULL, 0x080fe40000410000ULL,
0x000000172b2b7220ULL, 0x080fe40000410000ULL, 0x000000170a0a7220ULL, 0x080fe40000410000ULL,
0x000000170b0b7220ULL, 0x000fc40000410000ULL, 0x0000001706067220ULL, 0x080fe40000410000ULL,
0x0000001707077220ULL, 0x080fe40000410000ULL, 0x0000001722227220ULL, 0x080fe40000410000ULL,
0x0000001723237220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000ffff49ff7812ULL, 0x000fe20007800848ULL, 0x00000001ff497424ULL, 0x000fe200078e00ffULL,
0x0000004314437209ULL, 0x000fd60007810000ULL, 0x8000004314140221ULL, 0x000fe20000010000ULL,
0x00007610ff490816ULL, 0x000fc60000000049ULL, 0x3fb8aa3b14140820ULL, 0x000fc80000410000ULL,
0x0000001400180308ULL, 0x000e640000000800ULL, 0x0000001842420220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001142117221ULL, 0x004fc40000010000ULL,
0x0000000000447805ULL, 0x000fca0000015200ULL, 0x0186ac00ff147984ULL, 0x000e640000000800ULL,
0x8000000014ff7812ULL, 0x002fe40007804841ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff427224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000467805ULL, 0x000fcc0000015200ULL,
0x0000004644177210ULL, 0x000fca0007f1e1ffULL, 0x0000000147467824ULL, 0x000fe200000e0e45ULL,
0x003d09001700780cULL, 0x000fc80003f06070ULL, 0x000000ff4600720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401700780cULL, 0x000fc80003f06070ULL,
0x000000ff4600720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011446ULL, 0x0000001714147211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0646ULL, 0x0000000214147819ULL, 0x000fc80000001217ULL,
0x000000140000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000142427810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0186ac00ff147984ULL, 0x000e640000000800ULL, 0x8000000014ff7812ULL, 0x002fe40007804841ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991049147816ULL, 0x000fe200000000ffULL,
0x0000019000007945ULL, 0x000fe60003800000ULL, 0x000000ff1400720cULL, 0x000fda0003f25270ULL,
0x0000016000001947ULL, 0x000fea0003800000ULL, 0x00000018ff14723eULL, 0x000fe400000010ffULL,
0x00000002ff177819ULL, 0x000fe40000011603ULL, 0x0000541014147816ULL, 0x000fe20000000014ULL,
0x0000e1627f007947ULL, 0x000fea000b800000ULL, 0x00001f1714197589ULL, 0x0002a400000e0000ULL,
0x00000008171a7810ULL, 0x000fe20007ffe0ffULL, 0x0000e1b27f007947ULL, 0x000fea000b800000ULL,
0x00001f1a141a7589ULL, 0x0002e400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001017477810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff5e7224ULL, 0x008fe200078e0014ULL,
0x00014cc000447802ULL, 0x000fe20000000f00ULL, 0x0000001fff457424ULL, 0x000fe400078e00ffULL,
0xffffffffff467424ULL, 0x000fc400078e00ffULL, 0x0000e86000007944ULL, 0x016fea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001817477810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff5e7224ULL, 0x008fe200078e0014ULL, 0x00014d3000447802ULL, 0x000fe20000000f00ULL,
0x0000001fff457424ULL, 0x000fc400078e00ffULL, 0xffffffffff467424ULL, 0x004fc400078e00ffULL,
0x0000e7f000007944ULL, 0x012fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000001c44783bULL, 0x004ea20000004200ULL,
0x0001380024247811ULL, 0x000fc600078e20ffULL, 0x000000001d48783bULL, 0x000e680000004200ULL,
0x000000001e4c783bULL, 0x000ee80000004200ULL, 0x000000001f1c783bULL, 0x000ee20000004200ULL,
0x0000010044657824ULL, 0x004fe200078e00ffULL, 0x0000004400c67306ULL, 0x000fe20000009400ULL,
0x00000018ff967819ULL, 0x000fe20000011445ULL, 0x00000100476a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff787819ULL, 0x002fc40000011448ULL, 0x00000018ff657819ULL, 0x000fe40000011465ULL,
0x00000018ff977819ULL, 0x000fe20000011444ULL, 0x0000004400c77306ULL, 0x000e620000005400ULL,
0x00000018ff6f7819ULL, 0x000fe4000001144aULL, 0x00000018ff6a7819ULL, 0x000fe4000001146aULL,
0x00000018ff877819ULL, 0x000fe40000011446ULL, 0x00000018ff7b7819ULL, 0x000fe20000011449ULL,
0x0000006500cc7306ULL, 0x000fe20000209400ULL, 0x00000018ff867819ULL, 0x000fc40000011447ULL,
0x00000018ff707819ULL, 0x000fe4000001144bULL, 0x00000018ff5e7819ULL, 0x008fe4000001144dULL,
0x00000018ff617819ULL, 0x000fe2000001144cULL, 0x0000006500cd7306ULL, 0x000ea20000205400ULL,
0x000000c7c600720bULL, 0x002fe40003fdd000ULL, 0x00000018ff5a7819ULL, 0x000fe4000001144eULL,
0x00000018ff567819ULL, 0x000fc4000001144fULL, 0x00000018ff547819ULL, 0x000fe2000001141cULL,
0x0000006500ab7306ULL, 0x0002e2000020d400ULL, 0x00000018ff427819ULL, 0x000fe4000001141dULL,
0x00000018ff417819ULL, 0x000fe4000001141eULL, 0x00000018ff147819ULL, 0x000fc6000001141fULL,
0x0000004500647306ULL, 0x000fe20000009400ULL, 0x0000010045657824ULL, 0x002fe200078e00ffULL,
0x000000cdcc00720bULL, 0x004fc80003f1d000ULL, 0x00000018ff657819ULL, 0x000fe40000011465ULL,
0x0000004500c57306ULL, 0x000e6e0000005400ULL, 0x00000001abab0812ULL, 0x008fe200078efcffULL,
0x0000006500d07306ULL, 0x000ff00000209400ULL, 0x0000006500cf7306ULL, 0x000ea20000205400ULL,
0x000000c56400720bULL, 0x002fce0003f9d000ULL, 0x0000006500aa7306ULL, 0x0003f0000020d400ULL,
0x00000045009b7306ULL, 0x0006e2000000d400ULL, 0x0000010046657824ULL, 0x002fe200078e00ffULL,
0x000000cfd000720bULL, 0x004fc80003fbd000ULL, 0x00000018ff657819ULL, 0x000fe40000011465ULL,
0x0000004800bc7306ULL, 0x000fe20000009400ULL, 0x0001000045457824ULL, 0x008fca00078e00ffULL,
0x00000018ff9a7819ULL, 0x000fe40000011445ULL, 0x0000006500d37306ULL, 0x000fe20000209400ULL,
0x000000019b9b4812ULL, 0x000fe400078efcffULL, 0x00000001aaaa5812ULL, 0x000fca00078efcffULL,
0x0000006500d27306ULL, 0x000ff00000205400ULL, 0x0000006500937306ULL, 0x0003f0000020d400ULL,
0x0000004800bd7306ULL, 0x000fe20000005400ULL, 0x0000010048657824ULL, 0x002fca00078e00ffULL,
0x00000018ff657819ULL, 0x000fe40000011465ULL, 0x00000048007e7306ULL, 0x0003f0000000d400ULL,
0x0000009700c97306ULL, 0x000fe20000209400ULL, 0x0001000048487824ULL, 0x002fca00078e00ffULL,
0x00000018ff487819ULL, 0x000fe40000011448ULL, 0x0000009700c87306ULL, 0x000e700000205400ULL,
0x00000044009d7306ULL, 0x0004f0000000d400ULL, 0x0000009a00457306ULL, 0x000fe20000209400ULL,
0x0001000044447824ULL, 0x004fe200078e00ffULL, 0x000000c8c900720bULL, 0x002fc80003f7d000ULL,
0x00000018ff9c7819ULL, 0x000fe40000011444ULL, 0x0000009a00d17306ULL, 0x000e620000205400ULL,
0x000000019d9d6812ULL, 0x008fce00078efcffULL, 0x0000004800e07306ULL, 0x000ff00000209400ULL,
0x0000004800e17306ULL, 0x000fe20000205400ULL, 0x000000d14500720bULL, 0x002fe20003fdd000ULL,
0x000001001d457824ULL, 0x000fcc00078e00ffULL, 0x0000004800807306ULL, 0x0003f0000020d400ULL,
0x0000004a00b97306ULL, 0x000fe20000009400ULL, 0x000001004a487824ULL, 0x002fca00078e00ffULL,
0x00000018ff487819ULL, 0x000fe40000011448ULL, 0x0000004a00b77306ULL, 0x000ff00000005400ULL,
0x0000004a00757306ULL, 0x0003f0000000d400ULL, 0x0000009700977306ULL, 0x000ea2000020d400ULL,
0x000100004a4a7824ULL, 0x002fca00078e00ffULL, 0x00000018ff4a7819ULL, 0x000fe4000001144aULL,
0x0000006a00d57306ULL, 0x000ff00000209400ULL, 0x0000006a00d47306ULL, 0x000e620000205400ULL,
0x0000000197973812ULL, 0x004fce00078efcffULL, 0x0000006a00927306ULL, 0x0004f0000020d400ULL,
0x0000004600c47306ULL, 0x000fe20000009400ULL, 0x00000100496a7824ULL, 0x004fe200078e00ffULL,
0x000000d4d500720bULL, 0x002fc80003fbd000ULL, 0x00000018ff6a7819ULL, 0x000fe4000001146aULL,
0x0000004600c37306ULL, 0x000e6e0000005400ULL, 0x0000000192925812ULL, 0x008fe200078efcffULL,
0x0000004900bb7306ULL, 0x000ff00000009400ULL, 0x0000004900be7306ULL, 0x000fe20000005400ULL,
0x000000c3c400720bULL, 0x002fce0003f7d000ULL, 0x00000049007f7306ULL, 0x0003f0000000d400ULL,
0x0000009c00447306ULL, 0x000fe20000209400ULL, 0x0001000049497824ULL, 0x002fca00078e00ffULL,
0x00000018ff497819ULL, 0x000fe40000011449ULL, 0x0000009c00ce7306ULL, 0x000e700000205400ULL,
0x0000004a00de7306ULL, 0x000ff00000209400ULL, 0x0000004a00df7306ULL, 0x000fe20000205400ULL,
0x000000ce4400720bULL, 0x002fe20003f5d000ULL, 0x000001001c447824ULL, 0x000fca00078e00ffULL,
0x00000018ff447819ULL, 0x000fe20000011444ULL, 0x0000004a007c7306ULL, 0x0003f0000020d400ULL,
0x0000009a009a7306ULL, 0x000ea2000020d400ULL, 0x000001004c4a7824ULL, 0x002fca00078e00ffULL,
0x00000018ff4a7819ULL, 0x000fe4000001144aULL, 0x0000004700ae7306ULL, 0x000ff00000009400ULL,
0x00000047008d7306ULL, 0x000e620000005400ULL, 0x000000019a9a6812ULL, 0x004fce00078efcffULL,
0x00000047008e7306ULL, 0x0004f0000000d400ULL, 0x0000009600ca7306ULL, 0x000fe20000209400ULL,
0x0001000047477824ULL, 0x004fe200078e00ffULL, 0x0000008dae00720bULL, 0x002fc80003f9d000ULL,
0x00000018ff8b7819ULL, 0x000fe40000011447ULL, 0x0000009600cb7306ULL, 0x000e6e0000205400ULL,
0x000000018e8e4812ULL, 0x008fe200078efcffULL, 0x0000008700c17306ULL, 0x000fe20000209400ULL,
0x000000bdbc00720bULL, 0x000fc40003f9d000ULL, 0x00000018ffbc7819ULL, 0x000fca0000011445ULL,
0x0000008700c27306ULL, 0x000ea20000205400ULL, 0x000000cbca00720bULL, 0x002fca0003f1d000ULL,
0x000000017e7e4812ULL, 0x000fe400078efcffULL, 0x00000046008f7306ULL, 0x0002f0000000d400ULL,
0x0000004900e47306ULL, 0x000fe20000209400ULL, 0x0001000046467824ULL, 0x002fe200078e00ffULL,
0x000000c2c100720bULL, 0x004fc80003fdd000ULL, 0x00000018ff8c7819ULL, 0x000fe40000011446ULL,
0x0000004900e57306ULL, 0x000fe20000205400ULL, 0x000000018f8f3812ULL, 0x008fce00078efcffULL,
0x0000004900817306ULL, 0x0003f0000020d400ULL, 0x0000004b00b57306ULL, 0x000fe20000009400ULL,
0x000001004b497824ULL, 0x002fca00078e00ffULL, 0x00000018ff497819ULL, 0x000fe40000011449ULL,
0x0000004b00b67306ULL, 0x000ff00000005400ULL, 0x0000004b00747306ULL, 0x0003f0000000d400ULL,
0x0000004a00b27306ULL, 0x000fe20000209400ULL, 0x000100004b4b7824ULL, 0x002fca00078e00ffULL,
0x00000018ff4b7819ULL, 0x000fe4000001144bULL, 0x0000004a00b17306ULL, 0x000ff00000205400ULL,
0x0000004a00767306ULL, 0x0003f0000020d400ULL, 0x0000009c009c7306ULL, 0x000ea2000020d400ULL,
0x000001004d4a7824ULL, 0x002fca00078e00ffULL, 0x00000018ff4a7819ULL, 0x000fe4000001144aULL,
0x0000008b00d77306ULL, 0x000ff00000209400ULL, 0x0000008b00477306ULL, 0x000e620000205400ULL,
0x000000019c9c2812ULL, 0x004fc400078efcffULL, 0x000000d2d300720bULL, 0x000fca0003f5d000ULL,
0x0000009600967306ULL, 0x000eb0000020d400ULL, 0x0000008700877306ULL, 0x000ee2000020d400ULL,
0x00000047d700720bULL, 0x002fe40003f7d000ULL, 0x0000000193932812ULL, 0x000fca00078efcffULL,
0x0000008c00467306ULL, 0x000fe20000209400ULL, 0x0000000196960812ULL, 0x004fce00078efcffULL,
0x0000008c00d67306ULL, 0x000e620000205400ULL, 0x0000000187876812ULL, 0x008fe400078efcffULL,
0x000000bebb00720bULL, 0x000fca0003fdd000ULL, 0x0000004d00a47306ULL, 0x000ff00000009400ULL,
0x0000004d00a57306ULL, 0x000fe20000005400ULL, 0x000000d64600720bULL, 0x002fe40003f1d000ULL,
0x000000017f7f6812ULL, 0x000fc400078efcffULL, 0x000000e5e400720bULL, 0x000fc60003fdd000ULL,
0x0000004d00677306ULL, 0x0003f0000000d400ULL, 0x0000004b00e67306ULL, 0x000fe20000209400ULL,
0x000100004d4d7824ULL, 0x002fe200078e00ffULL, 0x0000000181816812ULL, 0x000fc400078efcffULL,
0x000000dfde00720bULL, 0x000fe40003fdd000ULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x0000004b00e77306ULL, 0x000ff00000205400ULL, 0x0000004b007d7306ULL, 0x0003e2000020d400ULL,
0x000000017c7c6812ULL, 0x000fce00078efcffULL, 0x0000004a00af7306ULL, 0x000fe20000209400ULL,
0x000001004f4b7824ULL, 0x002fca00078e00ffULL, 0x00000018ff4b7819ULL, 0x000fe4000001144bULL,
0x0000004a00b07306ULL, 0x000ff00000205400ULL, 0x0000004a00777306ULL, 0x0003f0000020d400ULL,
0x0000004c00a67306ULL, 0x000fe20000009400ULL, 0x000001004e4a7824ULL, 0x002fca00078e00ffULL,
0x00000018ff4a7819ULL, 0x000fe4000001144aULL, 0x0000004c00a77306ULL, 0x000ff00000005400ULL,
0x0000004c00667306ULL, 0x0003f0000000d400ULL, 0x0000004e00a37306ULL, 0x000fe20000009400ULL,
0x000100004c4c7824ULL, 0x002fca00078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe4000001144cULL,
0x0000004e009e7306ULL, 0x000e700000005400ULL, 0x0000004e005d7306ULL, 0x0004f0000000d400ULL,
0x0000004f00997306ULL, 0x000fe20000009400ULL, 0x000100004e4e7824ULL, 0x004fe200078e00ffULL,
0x0000009ea300720bULL, 0x002fc80003fdd000ULL, 0x00000018ff4e7819ULL, 0x000fe4000001144eULL,
0x0000004f00987306ULL, 0x000fee0000005400ULL, 0x000000015d5d6812ULL, 0x008fe200078efcffULL,
0x0000004f00597306ULL, 0x0003f0000000d400ULL, 0x0000008b008b7306ULL, 0x000ea2000020d400ULL,
0x000100004f4f7824ULL, 0x002fca00078e00ffULL, 0x00000018ff4f7819ULL, 0x000fe4000001144fULL,
0x0000008600c07306ULL, 0x000ff00000209400ULL, 0x0000008600bf7306ULL, 0x000e620000205400ULL,
0x000000018b8b3812ULL, 0x004fc400078efcffULL, 0x000000b7b900720bULL, 0x000fe20003f7d000ULL,
0x000001001eb77824ULL, 0x000fc800078e00ffULL, 0x0000008c008c7306ULL, 0x000ea2000020d400ULL,
0x00000018ffb77819ULL, 0x000fce00000114b7ULL, 0x0000006500d87306ULL, 0x000fe20000209400ULL,
0x000000bfc000720bULL, 0x002fe40003f5d000ULL, 0x0000000175753812ULL, 0x000fca00078efcffULL,
0x0000006500d97306ULL, 0x000e620000205400ULL, 0x000000018c8c0812ULL, 0x004fce00078efcffULL,
0x0000006500847306ULL, 0x000eb0000020d400ULL, 0x0000004d00ac7306ULL, 0x000fe20000209400ULL,
0x000000d9d800720bULL, 0x002fce0003fbd000ULL, 0x0000004d00ad7306ULL, 0x000fec0000205400ULL,
0x0000000184845812ULL, 0x004fe400078efcffULL, 0x0000004d006b7306ULL, 0x000fe2000020d400ULL,
0x000000b6b500720bULL, 0x000fe20003fbd000ULL, 0x000100001eb67824ULL, 0x000fe200078e00ffULL,
0x0000007e847e723eULL, 0x000fc800000010ffULL, 0x00000018ffb67819ULL, 0x000fe200000114b6ULL,
0x0000006a00dd7306ULL, 0x000fec0000209400ULL, 0x0000000174745812ULL, 0x000fe400078efcffULL,
0x0000006a00dc7306ULL, 0x000e620000205400ULL, 0x000000a5a400720bULL, 0x000fce0003fbd000ULL,
0x0000006a00857306ULL, 0x000eac000020d400ULL, 0x0000000167675812ULL, 0x000fe400078efcffULL,
0x0000004a00947306ULL, 0x000fe20000209400ULL, 0x000000dcdd00720bULL, 0x002fce0003f1d000ULL,
0x0000004a00957306ULL, 0x000e6c0000205400ULL, 0x0000000185850812ULL, 0x004fe400078efcffULL,
0x0000004a006c7306ULL, 0x000ea4000020d400ULL, 0x0000007f857f723eULL, 0x000fcc00000010ffULL,
0x0000004b004d7306ULL, 0x000fe20000209400ULL, 0x000000959400720bULL, 0x002fce0003fbd000ULL,
0x0000004b008a7306ULL, 0x000fec0000205400ULL, 0x000000016c6c5812ULL, 0x004fe400078efcffULL,
0x0000004b00657306ULL, 0x000fe4000020d400ULL, 0x0000005d6c6c723eULL, 0x000fcc00000010ffULL,
0x0000004c00e87306ULL, 0x000ff00000209400ULL, 0x0000004c00e97306ULL, 0x000ff00000205400ULL,
0x0000004c00717306ULL, 0x000ff0000020d400ULL, 0x0000004e004a7306ULL, 0x000ff00000209400ULL,
0x0000004e004b7306ULL, 0x000e700000205400ULL, 0x0000004e006a7306ULL, 0x000eb0000020d400ULL,
0x0000004f004c7306ULL, 0x000fe20000209400ULL, 0x0000004b4a00720bULL, 0x002fce0003fdd000ULL,
0x0000004f004e7306ULL, 0x000fec0000205400ULL, 0x000000016a6a6812ULL, 0x004fe400078efcffULL,
0x0000004f00647306ULL, 0x000ff0000020d400ULL, 0x00000044004f7306ULL, 0x000ff00000209400ULL,
0x0000004400ae7306ULL, 0x000ff00000205400ULL, 0x00000044008d7306ULL, 0x0003f0000020d400ULL,
0x0000007800ba7306ULL, 0x000fe20000209400ULL, 0x000000002444783bULL, 0x002e6e0000000200ULL,
0x0000007800b87306ULL, 0x000eb00000205400ULL, 0x0000008600867306ULL, 0x000ef0000020d400ULL,
0x0000007000a87306ULL, 0x000fe20000209400ULL, 0x000000b8ba00720bULL, 0x004fe20003f9d000ULL,
0x000001001fb87824ULL, 0x000fca00078e00ffULL, 0x00000018ffb87819ULL, 0x000fe200000114b8ULL,
0x0000007000a97306ULL, 0x000ea20000205400ULL, 0x0000000186862812ULL, 0x008fe400078efcffULL,
0x000000e1e000720bULL, 0x000fca0003f5d000ULL, 0x0000007b00b37306ULL, 0x000fe20000209400ULL,
0x0000001944449231ULL, 0x082fe400003400ffULL, 0x0000001946469231ULL, 0x000fe400003400ffULL,
0x0000001a45459231ULL, 0x080fe400003400ffULL, 0x0000001a47479231ULL, 0x000fe200003400ffULL,
0x0000007b00b47306ULL, 0x000e620000205400ULL, 0x000000a9a800720bULL, 0x004fe40003f7d000ULL,
0x0000000180802812ULL, 0x000fc600078efcffULL, 0x0000007e4428723cULL, 0x000fe40000041828ULL,
0x0000007800787306ULL, 0x000eb0000020d400ULL, 0x0000004900e27306ULL, 0x000fe20000209400ULL,
0x000000b4b300720bULL, 0x002fe20003f1d000ULL, 0x000100001fb37824ULL, 0x000fca00078e00ffULL,
0x00000018ffb37819ULL, 0x000fe200000114b3ULL, 0x0000004900e37306ULL, 0x000e620000205400ULL,
0x0000000178784812ULL, 0x004fc800078efcffULL, 0x00000080784a723eULL, 0x000fc600000010ffULL,
0x0000007000707306ULL, 0x000eb0000020d400ULL, 0x0000004800db7306ULL, 0x000fe20000209400ULL,
0x000000e3e200720bULL, 0x002fce0003f9d000ULL, 0x0000004800da7306ULL, 0x000e620000205400ULL,
0x0000000170703812ULL, 0x004fe400078efcffULL, 0x000000e9e800720bULL, 0x000fca0003f7d000ULL,
0x0000007b007b7306ULL, 0x000eb0000020d400ULL, 0x0000006f00a27306ULL, 0x000fe20000209400ULL,
0x000000dadb00720bULL, 0x002fe40003f5d000ULL, 0x0000000171713812ULL, 0x000fca00078efcffULL,
0x0000006f009f7306ULL, 0x000e620000205400ULL, 0x000000017b7b0812ULL, 0x004fc800078efcffULL,
0x000000817b4b723eULL, 0x000fc600000010ffULL, 0x0000004900497306ULL, 0x000eb0000020d400ULL,
0x0000001c00897306ULL, 0x000fe20000009400ULL, 0x0000009fa200720bULL, 0x002fce0003f1d000ULL,
0x0000001c00887306ULL, 0x000fe20000005400ULL, 0x0000000149494812ULL, 0x004fe400078efcffULL,
0x000000a7a600720bULL, 0x000fca0003f9d000ULL, 0x0000001c00557306ULL, 0x0003f0000000d400ULL,
0x0000004800487306ULL, 0x000ea2000020d400ULL, 0x000100001c1c7824ULL, 0x002fe200078e00ffULL,
0x0000000166664812ULL, 0x000fc400078efcffULL, 0x000000b0af00720bULL, 0x000fe40003f9d000ULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x0000005e00917306ULL, 0x000ff00000209400ULL,
0x0000005e00907306ULL, 0x000e620000205400ULL, 0x0000000148482812ULL, 0x004fc400078efcffULL,
0x000000e7e600720bULL, 0x000fe40003f5d000ULL, 0x0000000177774812ULL, 0x000fe400078efcffULL,
0x000000888900720bULL, 0x000fe20003f9d000ULL, 0x0000001d00837306ULL, 0x000fe20000009400ULL,
0x0000008c8788723eULL, 0x000fe400000010ffULL, 0x0000008b8689723eULL, 0x000fca00000010ffULL,
0x0000001d00827306ULL, 0x000fe20000005400ULL, 0x000000909100720bULL, 0x002fe20003f7d000ULL,
0x00000088442c723cULL, 0x000fe2000004182cULL, 0x000000017d7d2812ULL, 0x000fe400078efcffULL,
0x0000000155554812ULL, 0x000fe400078efcffULL, 0x0000007d707d723eULL, 0x000fe200000010ffULL,
0x0000001d00537306ULL, 0x0003f0000000d400ULL, 0x0000001e006e7306ULL, 0x000fe20000009400ULL,
0x000100001d1d7824ULL, 0x002fca00078e00ffULL, 0x00000018ff9e7819ULL, 0x000fe4000001141dULL,
0x0000001e006d7306ULL, 0x000e620000005400ULL, 0x0000009a961d723eULL, 0x000fce00000010ffULL,
0x0000001e00527306ULL, 0x0004f0000000d400ULL, 0x0000001f00687306ULL, 0x000fe20000009400ULL,
0x0000009dab1e723eULL, 0x004fe400000010ffULL, 0x0000006d6e00720bULL, 0x002fca0003fdd000ULL,
0x0000001f00697306ULL, 0x000ff00000005400ULL, 0x0000001f00177306ULL, 0x0003e2000000d400ULL,
0x0000000152526812ULL, 0x008fce00078efcffULL, 0x0000001c00b47306ULL, 0x000fe20000209400ULL,
0x0000009baa1f723eULL, 0x002fce00000010ffULL, 0x0000001c00a27306ULL, 0x000e620000205400ULL,
0x0000001e4438723cULL, 0x000bee0000041838ULL, 0x0000001c009f7306ULL, 0x0005e2000020d400ULL,
0x0000008f931e723eULL, 0x020fe400000010ffULL, 0x0000008e921f723eULL, 0x000fca00000010ffULL,
0x0000005e005e7306ULL, 0x000ee2000020d400ULL, 0x0000009c971c723eULL, 0x004fe200000010ffULL,
0x0000001e4430723cULL, 0x000f620000041830ULL, 0x000000a2b400720bULL, 0x002fca0003f9d000ULL,
0x0000006f006f7306ULL, 0x000e64000020d400ULL, 0x0000001c4434723cULL, 0x000b6c0000041834ULL,
0x0000006100a07306ULL, 0x000fe20000209400ULL, 0x00013800251c7811ULL, 0x020fe400078e20ffULL,
0x000000015e5e3812ULL, 0x008fc400078efcffULL, 0x0000008a4d00720bULL, 0x000fe40003f7d000ULL,
0x000000001c1c783bULL, 0x000ea20000000200ULL, 0x0000006100a17306ULL, 0x000ee20000205400ULL,
0x000000016f6f0812ULL, 0x002fe400078efcffULL, 0x000000b1b200720bULL, 0x000fe40003f1d000ULL,
0x00000074494d723eULL, 0x000fe400000010ffULL, 0x0000007c6f7c723eULL, 0x000fe200000010ffULL,
0x0000006100617306ULL, 0x000e62000020d400ULL, 0x000000019f9f4812ULL, 0x000fc400078efcffULL,
0x0000000165653812ULL, 0x000fc600078efcffULL, 0x0000007c4420723cULL, 0x000fe40000041820ULL,
0x0000005a007a7306ULL, 0x000fe20000209400ULL, 0x000000a1a000720bULL, 0x008fe40003f5d000ULL,
0x0000000176760812ULL, 0x000fe400078efcffULL, 0x000000989900720bULL, 0x000fc60003f1d000ULL,
0x0000005a00797306ULL, 0x000eec0000205400ULL, 0x0000000161612812ULL, 0x002fe400078efcffULL,
0x0000005600727306ULL, 0x000fe20000209400ULL, 0x000000adac00720bULL, 0x000fe40003f5d000ULL,
0x0000000159590812ULL, 0x000fc400078efcffULL, 0x0000004e4c00720bULL, 0x000fe40003f1d000ULL,
0x00000075484c723eULL, 0x000fe200000010ffULL, 0x0000005600737306ULL, 0x000e620000205400ULL,
0x000000797a00720bULL, 0x008fe20003fbd000ULL, 0x0000004a4448723cULL, 0x000b620000041808ULL,
0x000000191c1c9231ULL, 0x084fe200003400ffULL, 0x00000059656d723eULL, 0x000fe200000010ffULL,
0x000000191e1e9231ULL, 0x000fe200003400ffULL, 0x000000016b6b2812ULL, 0x000fe200078efcffULL,
0x0000001a1d1d9231ULL, 0x080fe200003400ffULL, 0x0000005a005a7306ULL, 0x000ea2000020d400ULL,
0x000000828300720bULL, 0x000fe20003f5d000ULL, 0x0000001a1f1f9231ULL, 0x000fe200003400ffULL,
0x000000667608723eULL, 0x020fc400000010ffULL, 0x000000677709723eULL, 0x000fe400000010ffULL,
0x0000000164640812ULL, 0x000fe200078efcffULL, 0x0000005600567306ULL, 0x000ee2000020d400ULL,
0x000000737200720bULL, 0x002fe20003f7d000ULL, 0x0000006c1c30723cULL, 0x000fe20000041830ULL,
0x000000696800720bULL, 0x000fc60003f1d000ULL, 0x0000000153532812ULL, 0x000fe400078efcffULL,
0x000000bc00bb7306ULL, 0x000fe20000209400ULL, 0x000000015a5a5812ULL, 0x004fe200078efcffULL,
0x000000081c08723cULL, 0x000fe20000041838ULL, 0x000000ae4f00720bULL, 0x000fe40003fbd000ULL,
0x0000006a5a5a723eULL, 0x000fc600000010ffULL, 0x000000bc00b57306ULL, 0x000e620000205400ULL,
0x0000000156563812ULL, 0x008fe200078efcffULL, 0x0000004c444c723cULL, 0x000b620000041804ULL,
0x0000000117170812ULL, 0x000fca00078efcffULL, 0x000000b7008e7306ULL, 0x000fe20000209400ULL,
0x000000018d8d5812ULL, 0x000fe400078efcffULL, 0x000000716104723eULL, 0x020fe400000010ffULL,
0x0000006b5e05723eULL, 0x000fc600000010ffULL, 0x000000b700257306ULL, 0x000ea20000205400ULL,
0x000000b5bb00720bULL, 0x002fc60003f7d000ULL, 0x000000041c04723cULL, 0x000b680000041834ULL,
0x000000bc00247306ULL, 0x000e66000020d400ULL, 0x000000558d34723eULL, 0x020fca00000010ffULL,
0x0000005400627306ULL, 0x000fe20000209400ULL, 0x000000258e00720bULL, 0x004fce0003f9d000ULL,
0x0000005400637306ULL, 0x000ea20000205400ULL, 0x0000000124243812ULL, 0x002fc800078efcffULL,
0x000000532435723eULL, 0x000fc600000010ffULL, 0x00000042005f7306ULL, 0x000fe80000209400ULL,
0x000000341c28723cULL, 0x000b680000041828ULL, 0x0000004200607306ULL, 0x000e620000205400ULL,
0x000000636200720bULL, 0x004fce0003fbd000ULL, 0x0000009e00a07306ULL, 0x000ff00000209400ULL,
0x0000009e009b7306ULL, 0x000ea20000205400ULL, 0x000000605f00720bULL, 0x002fce0003f5d000ULL,
0x0000005400547306ULL, 0x000e70000020d400ULL, 0x0000004200427306ULL, 0x000ee2000020d400ULL,
0x0000009ba000720bULL, 0x004fce0003f7d000ULL, 0x0000009e00967306ULL, 0x000ea2000020d400ULL,
0x0000000154545812ULL, 0x002fc800078efcffULL, 0x0000009f5454723eULL, 0x000fc600000010ffULL,
0x000000b700b77306ULL, 0x000e62000020d400ULL, 0x0000000142422812ULL, 0x008fce00078efcffULL,
0x00000041005b7306ULL, 0x000fe20000209400ULL, 0x0000000196963812ULL, 0x004fc800078efcffULL,
0x000000964255723eULL, 0x000fc600000010ffULL, 0x00000041005c7306ULL, 0x000ea20000205400ULL,
0x00000001b7b74812ULL, 0x002fc600078efcffULL, 0x000000541c48723cULL, 0x000b620000041848ULL,
0x00000052b752723eULL, 0x000fc600000010ffULL, 0x0000001400577306ULL, 0x000ff00000209400ULL,
0x0000001400587306ULL, 0x000e620000205400ULL, 0x0000005c5b00720bULL, 0x004fe40003fbd000ULL,
0x00000064565b723eULL, 0x000fca00000010ffULL, 0x000000b800787306ULL, 0x000fe40000209400ULL,
0x0000005a1c2c723cULL, 0x000b6c000004182cULL, 0x000000b800727306ULL, 0x000ea20000205400ULL,
0x000000585700720bULL, 0x002fce0003f7d000ULL, 0x000000b600447306ULL, 0x000ff00000209400ULL,
0x000000b600457306ULL, 0x000e620000205400ULL, 0x000000727800720bULL, 0x004fce0003f5d000ULL,
0x000000b300387306ULL, 0x000ff00000209400ULL, 0x000000b300257306ULL, 0x000ea20000205400ULL,
0x000000454400720bULL, 0x002fce0003f9d000ULL, 0x0000004100417306ULL, 0x000e70000020d400ULL,
0x0000001400147306ULL, 0x000ee2000020d400ULL, 0x000000253800720bULL, 0x004fce0003fdd000ULL,
0x000000b800b87306ULL, 0x000ea2000020d400ULL, 0x0000000141415812ULL, 0x002fce00078efcffULL,
0x000000b600b67306ULL, 0x000e62000020d400ULL, 0x0000000114143812ULL, 0x008fce00078efcffULL,
0x000000b300b37306ULL, 0x000ee2000020d400ULL, 0x00000001b8b82812ULL, 0x004fc800078efcffULL,
0x00000017b853723eULL, 0x000fe400000010ffULL, 0x00000001b6b64812ULL, 0x002fc800078efcffULL,
0x000000b641b6723eULL, 0x000fe200000010ffULL, 0x000000521c4c723cULL, 0x000b62000004184cULL,
0x00000001b3b36812ULL, 0x008fc800078efcffULL, 0x000000b314b7723eULL, 0x000fce00000010ffULL,
0x000000b61c20723cULL, 0x000b620000041820ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0186b800ff247f8cULL, 0x000e62000c80043fULL, 0x000000ffff347224ULL, 0x020fce00078e00ffULL,
0x00000000001c7805ULL, 0x000fc40000015200ULL, 0x0186bc00ff147984ULL, 0x000ea40000000800ULL,
0x8000000014ff7812ULL, 0x006fe40007804825ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001e7805ULL, 0x000fcc0000015200ULL, 0x0000001e1c177210ULL, 0x000fca0007f1e1ffULL,
0x000000011f1e7824ULL, 0x000fe200000e0e1dULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff1e00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff1e00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc8000001141eULL,
0x0000001714147211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e061eULL,
0x0000000214147819ULL, 0x000fc80000001217ULL, 0x000000140000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000134347810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0186bc00ff147984ULL, 0x000e640000000800ULL,
0x8000000014ff7812ULL, 0x002fe40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000213147810ULL, 0x000fc80007ffe0ffULL, 0x0000000e1400720cULL, 0x000fe20003f06070ULL,
0x0000580010147a24ULL, 0x010fc800078e02ffULL, 0x00000080141c7824ULL, 0x000fd000078e00ffULL,
0x0000045000008947ULL, 0x000fea0003800000ULL, 0x000000c03c3c7810ULL, 0x000fe20007ffe0ffULL,
0x000000010f177824ULL, 0x000fe200078e021bULL, 0x000000021b377810ULL, 0x040fe40007ffe0ffULL,
0x000000041b397810ULL, 0x000fe20007ffe0ffULL, 0x00000001171d7824ULL, 0x040fe200078e0203ULL,
0x0000003c0c147217ULL, 0x000fe20007800000ULL, 0x0000001017367824ULL, 0x000fe200078e00ffULL,
0x000000061b3b7810ULL, 0x000fe20007ffe0ffULL, 0x000000010f1e7824ULL, 0x000fe400078e0237ULL,
0x0000008000177824ULL, 0x000fe200078e0217ULL, 0xfffffff036367812ULL, 0x000fe200078ee21dULL,
0x0000000114147824ULL, 0x000fc400078e0a3cULL, 0x000000010f1f7824ULL, 0x000fe200078e0239ULL,
0x0000001c17347210ULL, 0x000fe20007f1e0ffULL, 0x000000011e1d7824ULL, 0x140fe200078e0203ULL,
0x000000140f147217ULL, 0x000fe20007800000ULL, 0x000000101e387824ULL, 0x000fe200078e00ffULL,
0x0000000217257810ULL, 0x000fe20007ffe0ffULL, 0x000000011f1e7824ULL, 0x000fe200078e0203ULL,
0x0000000617247810ULL, 0x000fe20007ffe0ffULL, 0x000000101f3a7824ULL, 0x000fe200078e00ffULL,
0xfffffff038387812ULL, 0x000fe200078ee21dULL, 0x000000010f1d7824ULL, 0x000fe200078e023bULL,
0x00000004171f7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff177224ULL, 0x000fe200000e06ffULL,
0xfffffff03a3a7812ULL, 0x000fe200078ee21eULL, 0x0000000114147824ULL, 0x000fe200078e0a0fULL,
0x00005e00341e7a11ULL, 0x040fe200078440ffULL, 0x000000011d357824ULL, 0x000fe200078e0203ULL,
0x0000001c25257210ULL, 0x000fe20007f9e0ffULL, 0x000000101d3c7824ULL, 0x000fe200078e00ffULL,
0x00005f0034347a11ULL, 0x000fc400010f4417ULL, 0x0000001c1f1f7210ULL, 0x000fe40007f7e0ffULL,
0x000000141b00720cULL, 0x000fe20003f46070ULL, 0x000000ffff1b7224ULL, 0x000fe200020e06ffULL,
0x0000001c241c7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff177224ULL, 0x000fe200018e06ffULL,
0xfffffff03c3c7812ULL, 0x000fe400078ee235ULL, 0x00005e0025247a11ULL, 0x000fe400078840ffULL,
0x000000f016357812ULL, 0x000fc400078ec0ffULL, 0x00005e001f1d7a11ULL, 0x000fe400078640ffULL,
0x00005f0025257a11ULL, 0x000fe200020f441bULL, 0x000000ffff1b7224ULL, 0x000fe200000e06ffULL,
0x000000351e167210ULL, 0x000fe40007fbe0ffULL, 0x00005e001c1e7a11ULL, 0x000fe400078c40ffULL,
0x00005f001f1f7a11ULL, 0x000fe200018f4417ULL, 0x000000ffff177224ULL, 0x000fe200028e0634ULL,
0x000000143700720cULL, 0x000fc40003f86070ULL, 0x000000143900720cULL, 0x080fe40003f66070ULL,
0x0001400036367811ULL, 0x000fe400078e20ffULL, 0x000000143b00720cULL, 0x000fe40003f06070ULL,
0x00005f001c147a11ULL, 0x000fe200030f441bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016367faeULL, 0x0003e2000d101c46ULL, 0x00000035241c7210ULL, 0x000fe40007fbe0ffULL,
0x0001400038387811ULL, 0x000fc400078e20ffULL, 0x000140003a3a7811ULL, 0x000fe400078e20ffULL,
0x000140003c3c7811ULL, 0x000fe400078e20ffULL, 0x000000351d167210ULL, 0x082fe20007f5e0ffULL,
0x000000ffff1d7224ULL, 0x000fe200028e0625ULL, 0x000000351e1e7210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff177224ULL, 0x000fe200010e061fULL, 0x000000001c387faeULL, 0x0003e2000e101c46ULL,
0x000000ffff1f7224ULL, 0x000fc600028e0614ULL, 0x00000000163a7faeULL, 0x0003e8000d901c46ULL,
0x000000001e3c7faeULL, 0x0003e2000c101c46ULL, 0x0000038000007947ULL, 0x000fea0003800000ULL,
0x000000010f1b7824ULL, 0x000fc800078e021bULL, 0x000000011b147824ULL, 0x040fe200078e0203ULL,
0x000000021b177810ULL, 0x040fe20007ffe0ffULL, 0x000000101b1d7824ULL, 0x040fe200078e00ffULL,
0x000000061b257810ULL, 0x000fc60007ffe0ffULL, 0x00000001171e7824ULL, 0x000fe200078e0203ULL,
0xfffffff01d1d7812ULL, 0x000fe200078ee214ULL, 0x00000010171f7824ULL, 0x000fe400078e00ffULL,
0x0000008000147824ULL, 0x000fe200078e021bULL, 0x000140001d1d7811ULL, 0x000fe200078e20ffULL,
0x0000000125387824ULL, 0x000fe200078e0203ULL, 0xfffffff01f1f7812ULL, 0x000fe200078ee21eULL,
0x00000010253a7824ULL, 0x000fe200078e00ffULL, 0x000000041b1e7810ULL, 0x000fe40007ffe0ffULL,
0x0000001c14177210ULL, 0x000fc40007f1e0ffULL, 0x00000002141b7810ULL, 0x000fe20007ffe0ffULL,
0x000000011e347824ULL, 0x000fe200078e0203ULL, 0x0000000414247810ULL, 0x000fe20007ffe0ffULL,
0x000000101e367824ULL, 0x000fe200078e00ffULL, 0x0000000614357810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff147224ULL, 0x000fe200000e06ffULL, 0x0000001c1b1e7210ULL, 0x080fe40007f5e0ffULL,
0x00005e00171b7a11ULL, 0x000fe400078040ffULL, 0x0000001c24257210ULL, 0x000fc40007f7e0ffULL,
0x000000f016247812ULL, 0x000fe400078ec0ffULL, 0x0000001c35377210ULL, 0x000fe40007f9e0ffULL,
0x00005f0017147a11ULL, 0x000fe200000f4414ULL, 0x000000ffff177224ULL, 0x000fe200010e06ffULL,
0x00005e001e1c7a11ULL, 0x000fe400078440ffULL, 0x000000241b167210ULL, 0x000fe40007f1e0ffULL,
0xfffffff036367812ULL, 0x000fe200078ee234ULL, 0x000000ffff347224ULL, 0x000fe200018e06ffULL,
0xfffffff03a3a7812ULL, 0x000fe200078ee238ULL, 0x000000ffff387224ULL, 0x000fe200020e06ffULL,
0x00005e0025357a11ULL, 0x000fc400078640ffULL, 0x00005e0037397a11ULL, 0x000fe400078840ffULL,
0x00005f001e1b7a11ULL, 0x000fe200010f4417ULL, 0x000000ffff177224ULL, 0x000fe200000e0614ULL,
0x000000241c1c7210ULL, 0x080fe40007f1e0ffULL, 0x00005f0025347a11ULL, 0x000fe400018f4434ULL,
0x00000024351e7210ULL, 0x000fe20007f5e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000161d7faeULL, 0x0003e2000b901c46ULL, 0x00005f0037387a11ULL, 0x000fc400020f4438ULL,
0x0000002439247210ULL, 0x000fe40007f7e0ffULL, 0x000140001f147811ULL, 0x000fe200078e20ffULL,
0x000000ffff1f7224ULL, 0x000fe200010e0634ULL, 0x0001400036367811ULL, 0x000fe200078e20ffULL,
0x000000ffff257224ULL, 0x000fe200018e0638ULL, 0x000140003a3a7811ULL, 0x000fe200078e20ffULL,
0x000000ffff1d7224ULL, 0x002fca00000e061bULL, 0x000000001c147faeULL, 0x0003e8000b901c46ULL,
0x000000001e367faeULL, 0x0003e8000b901c46ULL, 0x00000000243a7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0186a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0186a800ff167f8cULL, 0x000e64000c80043fULL, 0x000000ffff417224ULL, 0x002fc400078e0017ULL,
0x0000000000167805ULL, 0x000fca0000015200ULL, 0x0186b400ff147984ULL, 0x000e640000000800ULL,
0x8000000014ff7812ULL, 0x002fc40007804851ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000001c7805ULL, 0x000fcc0000015200ULL,
0x0000001c161b7210ULL, 0x000fca0007f1e1ffULL, 0x000000011d1c7824ULL, 0x000fe200000e0e17ULL,
0x003d09001b00780cULL, 0x000fc80003f06070ULL, 0x000000ff1c00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401b00780cULL, 0x000fc80003f06070ULL,
0x000000ff1c00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc8000001141cULL, 0x0000001b14147211ULL, 0x000fca00078110ffULL,
0x000000ffff1b7224ULL, 0x000fca00000e061cULL, 0x0000000214147819ULL, 0x000fc8000000121bULL,
0x000000140000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000011e1e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0186b400ff147984ULL, 0x000e640000000800ULL, 0x8000000014ff7812ULL, 0x002fe40007804851ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000018000007945ULL, 0x000fe20003800000ULL,
0x0000016000001947ULL, 0x000fea0003800000ULL, 0x00000018ff14723eULL, 0x000fe400000010ffULL,
0x00000002ff167819ULL, 0x000fe40000011603ULL, 0x0000541014147816ULL, 0x000fe20000000014ULL,
0x0000b6427f007947ULL, 0x000fea000b800000ULL, 0x00001f1614197589ULL, 0x0002a400000e0000ULL,
0x00000008161a7810ULL, 0x000fe20007ffe0ffULL, 0x0000b6927f007947ULL, 0x000fea000b800000ULL,
0x00001f1a141a7589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001016477810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff5e7224ULL, 0x000fe200078e0014ULL,
0x000178e000447802ULL, 0x000fe20000000f00ULL, 0x0000001fff457424ULL, 0x000fc400078e00ffULL,
0xffffffffff467424ULL, 0x000fc400078e00ffULL, 0x0000bc4000007944ULL, 0x00efea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001816477810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff5e7224ULL, 0x000fe200078e0014ULL, 0x0001795000447802ULL, 0x000fe20000000f00ULL,
0x0000001fff457424ULL, 0x000fe400078e00ffULL, 0xffffffffff467424ULL, 0x004fc400078e00ffULL,
0x0000bbd000007944ULL, 0x00afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000138003fa77811ULL, 0x000fc400078e20ffULL,
0x000000003e34783bULL, 0x000f280000004200ULL, 0x000000003d3c783bULL, 0x000ee80000004200ULL,
0x00000000271c783bULL, 0x000ea80000004200ULL, 0x000000002624783bULL, 0x000e620000004200ULL,
0x0000010034687824ULL, 0x010fe200078e00ffULL, 0x00000034007f7306ULL, 0x000fe20000009400ULL,
0x00000018ff907819ULL, 0x000fc40000011434ULL, 0x00000018ff867819ULL, 0x000fe40000011435ULL,
0x00000018ff687819ULL, 0x000fe40000011468ULL, 0x00000018ff7a7819ULL, 0x000fe20000011436ULL,
0x0000003400bc7306ULL, 0x000f220000005400ULL, 0x00000018ff647819ULL, 0x008fe4000001143dULL,
0x00000018ff797819ULL, 0x000fe40000011437ULL, 0x00000018ff607819ULL, 0x000fc4000001143eULL,
0x00000018ff3b7819ULL, 0x004fe2000001141cULL, 0x0000003400167306ULL, 0x0022a2000000d400ULL,
0x00000018ff6e7819ULL, 0x000fe4000001143cULL, 0x00000018ff5d7819ULL, 0x000fe4000001143fULL,
0x00000018ff587819ULL, 0x000fe4000001141dULL, 0x00000018ff477819ULL, 0x000fe20000011424ULL,
0x0000003500b67306ULL, 0x000fe20000009400ULL, 0x0001000034347824ULL, 0x002fe200078e00ffULL,
0x000000bc7f00720bULL, 0x010fc40003fdd000ULL, 0x00000018ff457819ULL, 0x000fe40000011425ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000003500707306ULL, 0x000e620000005400ULL,
0x00000018ff427819ULL, 0x000fe40000011426ULL, 0x00000018ff147819ULL, 0x000fe40000011427ULL,
0x00000018ff577819ULL, 0x000fe4000001141eULL, 0x0000000116166812ULL, 0x004fe200078efcffULL,
0x0000006800bd7306ULL, 0x000fe20000209400ULL, 0x00000018ff517819ULL, 0x000fce000001141fULL,
0x0000006800be7306ULL, 0x000ea20000205400ULL, 0x00000070b600720bULL, 0x002fce0003f1d000ULL,
0x00000068009a7306ULL, 0x0003f0000020d400ULL, 0x0000003500177306ULL, 0x000722000000d400ULL,
0x0000010035687824ULL, 0x002fe200078e00ffULL, 0x000000bebd00720bULL, 0x004fc80003f7d000ULL,
0x00000018ff687819ULL, 0x000fe40000011468ULL, 0x0000003400bf7306ULL, 0x000fe20000209400ULL,
0x0001000035357824ULL, 0x008fca00078e00ffULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x0000003400c07306ULL, 0x000e620000205400ULL, 0x0000000117170812ULL, 0x010fe400078efcffULL,
0x000000019a9a3812ULL, 0x000fc800078efcffULL, 0x000000169a16723eULL, 0x000fe200000010ffULL,
0x0000003400937306ULL, 0x0004f0000020d400ULL, 0x0000003700b17306ULL, 0x000fe20000009400ULL,
0x0000010036347824ULL, 0x004fe200078e00ffULL, 0x000000c0bf00720bULL, 0x002fc80003fbd000ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000003700b07306ULL, 0x000e6e0000005400ULL,
0x0000000193935812ULL, 0x008fe200078efcffULL, 0x0000003500c37306ULL, 0x000ff00000209400ULL,
0x0000003500c47306ULL, 0x000ea20000205400ULL, 0x000000b0b100720bULL, 0x002fce0003f1d000ULL,
0x0000003400c67306ULL, 0x000ff00000209400ULL, 0x0000003400c57306ULL, 0x000e620000205400ULL,
0x000000c4c300720bULL, 0x004fce0003fdd000ULL, 0x0000003400887306ULL, 0x0004f0000020d400ULL,
0x0000009000897306ULL, 0x000fe20000209400ULL, 0x000001003c347824ULL, 0x004fe200078e00ffULL,
0x000000c5c600720bULL, 0x002fc80003fbd000ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000009000ba7306ULL, 0x000e6e0000205400ULL, 0x0000000188885812ULL, 0x008fe200078efcffULL,
0x0000008600bb7306ULL, 0x000ff00000209400ULL, 0x0000008600b97306ULL, 0x000ea20000205400ULL,
0x000000ba8900720bULL, 0x002fce0003f5d000ULL, 0x0000006800c27306ULL, 0x000ff00000209400ULL,
0x0000006800c17306ULL, 0x000e620000205400ULL, 0x000000b9bb00720bULL, 0x004fce0003f7d000ULL,
0x00000035008a7306ULL, 0x0004f0000020d400ULL, 0x0000003700807306ULL, 0x0008e2000000d400ULL,
0x0000010037357824ULL, 0x004fe200078e00ffULL, 0x000000c1c200720bULL, 0x002fc80003f9d000ULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x0000003c00af7306ULL, 0x000fe20000009400ULL,
0x0001000037377824ULL, 0x010fe200078e00ffULL, 0x000000018a8a6812ULL, 0x008fc800078efcffULL,
0x00000018ff377819ULL, 0x000fe40000011437ULL, 0x0000003c008b7306ULL, 0x000e620000005400ULL,
0x0000000180800812ULL, 0x000fce00078efcffULL, 0x0000003400ce7306ULL, 0x000ff00000209400ULL,
0x0000003400cd7306ULL, 0x000ea20000205400ULL, 0x0000008baf00720bULL, 0x002fe20003fdd000ULL,
0x0001000027af7824ULL, 0x000fca00078e00ffULL, 0x00000018ffaf7819ULL, 0x000fe200000114afULL,
0x0000003500c77306ULL, 0x000ff00000209400ULL, 0x0000003500c87306ULL, 0x000fe20000205400ULL,
0x000000cdce00720bULL, 0x004fce0003f1d000ULL, 0x0000003500877306ULL, 0x0003f0000020d400ULL,
0x0000003d00aa7306ULL, 0x000fe20000009400ULL, 0x000001003d357824ULL, 0x002fca00078e00ffULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x0000003d00a97306ULL, 0x000ff00000005400ULL,
0x0000003d006b7306ULL, 0x0003f0000000d400ULL, 0x0000009000907306ULL, 0x000ea2000020d400ULL,
0x000100003d3d7824ULL, 0x002fca00078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000008600867306ULL, 0x000e70000020d400ULL, 0x0000006800a87306ULL, 0x000ee2000020d400ULL,
0x0000000190902812ULL, 0x004fce00078efcffULL, 0x0000003600b37306ULL, 0x000fe20000009400ULL,
0x0000000186863812ULL, 0x002fce00078efcffULL, 0x0000003600b27306ULL, 0x000e620000005400ULL,
0x00000001a8a84812ULL, 0x008fe400078efcffULL, 0x000000c8c700720bULL, 0x000fe40003f9d000ULL,
0x00000017a817723eULL, 0x000fc600000010ffULL, 0x0000007a00b87306ULL, 0x000ff00000209400ULL,
0x0000007a00b77306ULL, 0x000ea20000205400ULL, 0x000000b2b300720bULL, 0x002fe20003f5d000ULL,
0x0001000026b37824ULL, 0x000fe200078e00ffULL, 0x0000000187874812ULL, 0x000fc800078efcffULL,
0x000000808787723eULL, 0x000fe200000010ffULL, 0x0000003400787306ULL, 0x0002e2000020d400ULL,
0x00000018ffb37819ULL, 0x000fce00000114b3ULL, 0x0000003600817306ULL, 0x0008e2000000d400ULL,
0x000001003e347824ULL, 0x002fe200078e00ffULL, 0x000000b7b800720bULL, 0x004fc80003f7d000ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000003c00737306ULL, 0x0002a2000000d400ULL,
0x0001000036367824ULL, 0x010fe200078e00ffULL, 0x0000000178780812ULL, 0x008fc800078efcffULL,
0x00000018ff7e7819ULL, 0x000fe40000011436ULL, 0x0000006400ae7306ULL, 0x000fe20000209400ULL,
0x000100003c3c7824ULL, 0x002fe200078e00ffULL, 0x0000000181812812ULL, 0x000fc800078efcffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000006400ac7306ULL, 0x000e620000205400ULL,
0x0000000173736812ULL, 0x004fc800078efcffULL, 0x000000737878723eULL, 0x000fc600000010ffULL,
0x0000003d00d57306ULL, 0x000ff00000209400ULL, 0x0000003d00d67306ULL, 0x000ea20000205400ULL,
0x000000acae00720bULL, 0x002fce0003f1d000ULL, 0x0000007900b57306ULL, 0x000ff00000209400ULL,
0x0000007900b47306ULL, 0x000e620000205400ULL, 0x000000d6d500720bULL, 0x004fce0003fdd000ULL,
0x0000003e00a57306ULL, 0x000ff00000009400ULL, 0x0000003e00a67306ULL, 0x000fe20000005400ULL,
0x000000b4b500720bULL, 0x002fe20003fbd000ULL, 0x0000010026b47824ULL, 0x000fc400078e00ffULL,
0x0000010027b57824ULL, 0x000fc600078e00ffULL, 0x00000018ffb47819ULL, 0x000fe200000114b4ULL,
0x0000003e00677306ULL, 0x0003e2000000d400ULL, 0x00000018ffb57819ULL, 0x000fce00000114b5ULL,
0x0000003400d07306ULL, 0x000fe20000209400ULL, 0x000100003e3e7824ULL, 0x002fca00078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x0000003400cf7306ULL, 0x000ff00000205400ULL,
0x0000003400727306ULL, 0x0003f0000020d400ULL, 0x0000007a007a7306ULL, 0x000ea2000020d400ULL,
0x000001001c347824ULL, 0x002fca00078e00ffULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000001c009d7306ULL, 0x000ff00000009400ULL, 0x0000001c009e7306ULL, 0x000fe20000005400ULL,
0x000000017a7a3812ULL, 0x004fc400078efcffULL, 0x000000a9aa00720bULL, 0x000fca0003f7d000ULL,
0x0000001c005f7306ULL, 0x0003f0000000d400ULL, 0x0000007e00367306ULL, 0x000fe20000209400ULL,
0x000100001c1c7824ULL, 0x002fe200078e00ffULL, 0x000000016b6b3812ULL, 0x000fc400078efcffULL,
0x000000a6a500720bULL, 0x000fe40003f7d000ULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x0000007e00c97306ULL, 0x000e700000205400ULL, 0x0000003700cb7306ULL, 0x000fe20000209400ULL,
0x0000000167673812ULL, 0x000fce00078efcffULL, 0x0000003700cc7306ULL, 0x000ea20000205400ULL,
0x000000c93600720bULL, 0x002fe20003f5d000ULL, 0x0001000025367824ULL, 0x000fca00078e00ffULL,
0x00000018ff367819ULL, 0x000fe20000011436ULL, 0x00000037007d7306ULL, 0x000e70000020d400ULL,
0x0000003500ca7306ULL, 0x000fe20000209400ULL, 0x000000cccb00720bULL, 0x004fce0003f9d000ULL,
0x0000003500377306ULL, 0x000fec0000205400ULL, 0x000000017d7d4812ULL, 0x002fe400078efcffULL,
0x0000003500767306ULL, 0x0003f0000020d400ULL, 0x0000003f00a07306ULL, 0x000fe20000009400ULL,
0x000001003f357824ULL, 0x002fca00078e00ffULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x0000003f009f7306ULL, 0x000ff00000005400ULL, 0x0000003f00617306ULL, 0x0003f0000000d400ULL,
0x0000006400647306ULL, 0x000ea2000020d400ULL, 0x000100003f3f7824ULL, 0x002fca00078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x0000003d00717306ULL, 0x000e70000020d400ULL,
0x0000007900797306ULL, 0x000ee2000020d400ULL, 0x0000000164640812ULL, 0x004fc400078efcffULL,
0x0000009e9d00720bULL, 0x000fca0003f1d000ULL, 0x0000003e00d77306ULL, 0x000fe20000209400ULL,
0x0000000171716812ULL, 0x002fce00078efcffULL, 0x0000003e00d87306ULL, 0x000e620000205400ULL,
0x0000000179795812ULL, 0x008fe400078efcffULL, 0x000000015f5f0812ULL, 0x000fca00078efcffULL,
0x0000003400e07306ULL, 0x000ff00000209400ULL, 0x0000003400df7306ULL, 0x000fe20000205400ULL,
0x000000d8d700720bULL, 0x002fce0003fdd000ULL, 0x0000003400697306ULL, 0x0003f0000020d400ULL,
0x0000006e00ad7306ULL, 0x000fe20000209400ULL, 0x000001001d347824ULL, 0x002fca00078e00ffULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000006e00ab7306ULL, 0x000e700000205400ULL,
0x0000003e006f7306ULL, 0x000eb0000020d400ULL, 0x0000001d009b7306ULL, 0x000fe20000009400ULL,
0x000000abad00720bULL, 0x002fce0003fbd000ULL, 0x0000001d009c7306ULL, 0x000e620000005400ULL,
0x000000016f6f6812ULL, 0x004fce00078efcffULL, 0x0000001d00387306ULL, 0x0004f0000000d400ULL,
0x0000001c00da7306ULL, 0x000fe20000209400ULL, 0x000100001d1d7824ULL, 0x004fe200078e00ffULL,
0x0000009c9b00720bULL, 0x002fc80003fdd000ULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x0000001c00d97306ULL, 0x000fee0000205400ULL, 0x0000000138386812ULL, 0x008fe200078efcffULL,
0x0000001c003e7306ULL, 0x0003f0000020d400ULL, 0x0000007e007e7306ULL, 0x000ea2000020d400ULL,
0x000001001e1c7824ULL, 0x002fca00078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x0000003c00d17306ULL, 0x000ff00000209400ULL, 0x0000003c00d27306ULL, 0x000e620000205400ULL,
0x000000017e7e2812ULL, 0x004fc400078efcffULL, 0x00000037ca00720bULL, 0x000fe40003f5d000ULL,
0x0000008a8637723eULL, 0x000fe400000010ffULL, 0x000000818886723eULL, 0x000fe200000010ffULL,
0x0000003f00de7306ULL, 0x000ff00000209400ULL, 0x0000003f00dd7306ULL, 0x000ea20000205400ULL,
0x000000d2d100720bULL, 0x002fc40003f9d000ULL, 0x0000000176762812ULL, 0x000fe400078efcffULL,
0x000000cfd000720bULL, 0x000fc60003f5d000ULL, 0x0000003f00687306ULL, 0x000e70000020d400ULL,
0x0000003500d37306ULL, 0x000fe20000209400ULL, 0x000000ddde00720bULL, 0x004fe40003f7d000ULL,
0x0000000172722812ULL, 0x000fc800078efcffULL, 0x000000677272723eULL, 0x000fe200000010ffULL,
0x0000003500d47306ULL, 0x000fec0000205400ULL, 0x0000000168683812ULL, 0x002fe400078efcffULL,
0x00000035006a7306ULL, 0x000fe2000020d400ULL, 0x000000d9da00720bULL, 0x000fce0003f7d000ULL,
0x0000003400dc7306ULL, 0x000fec0000209400ULL, 0x000000013e3e3812ULL, 0x000fe400078efcffULL,
0x0000003400db7306ULL, 0x000e700000205400ULL, 0x00000034003f7306ULL, 0x000eb0000020d400ULL,
0x0000001d008e7306ULL, 0x000fe20000209400ULL, 0x000000dbdc00720bULL, 0x002fce0003f1d000ULL,
0x0000001d008d7306ULL, 0x000e6c0000205400ULL, 0x000000013f3f0812ULL, 0x004fe400078efcffULL,
0x0000001d00347306ULL, 0x0004f0000020d400ULL, 0x0000001c008c7306ULL, 0x000fe20000209400ULL,
0x000001001f1d7824ULL, 0x004fe200078e00ffULL, 0x0000008d8e00720bULL, 0x002fc80003f1d000ULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x0000001c008f7306ULL, 0x000e6e0000205400ULL,
0x0000000134340812ULL, 0x008fe200078efcffULL, 0x0000001c00357306ULL, 0x0004f0000020d400ULL,
0x0000006e006e7306ULL, 0x000f22000020d400ULL, 0x00000100241c7824ULL, 0x004fe200078e00ffULL,
0x0000008f8c00720bULL, 0x002fc80003fdd000ULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x0000003c00777306ULL, 0x000e6e000020d400ULL, 0x0000000135356812ULL, 0x008fe200078efcffULL,
0x0000001d00847306ULL, 0x000fe20000209400ULL, 0x000000016e6e5812ULL, 0x010fc400078efcffULL,
0x0000009fa000720bULL, 0x000fca0003fbd000ULL, 0x0000001d00857306ULL, 0x000ea20000205400ULL,
0x0000000177774812ULL, 0x002fe400078efcffULL, 0x000000d4d300720bULL, 0x000fca0003f9d000ULL,
0x0000001d003c7306ULL, 0x0002e2000020d400ULL, 0x0000000161615812ULL, 0x000fe400078efcffULL,
0x000000dfe000720bULL, 0x000fca0003fbd000ULL, 0x0000001c00b27306ULL, 0x000fe20000209400ULL,
0x00000100251d7824ULL, 0x002fe200078e00ffULL, 0x000000016a6a4812ULL, 0x000fe400078efcffULL,
0x000000858400720bULL, 0x004fe40003f1d000ULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x0000001c00b07306ULL, 0x000fe20000205400ULL, 0x0000000169695812ULL, 0x000fe400078efcffULL,
0x000000616a73723eULL, 0x000fca00000010ffULL, 0x0000001c008b7306ULL, 0x0003e2000020d400ULL,
0x000000013c3c0812ULL, 0x008fce00078efcffULL, 0x0000002400917306ULL, 0x000fe20000009400ULL,
0x00010000241c7824ULL, 0x002fce00078e00ffULL, 0x0000002400927306ULL, 0x000e700000005400ULL,
0x0000002400507306ULL, 0x000eb0000000d400ULL, 0x0000002500757306ULL, 0x000fe20000009400ULL,
0x000000929100720bULL, 0x002fce0003f7d000ULL, 0x0000002500747306ULL, 0x000fec0000005400ULL,
0x0000000150503812ULL, 0x004fe400078efcffULL, 0x0000002500467306ULL, 0x000ff0000000d400ULL,
0x00000026006c7306ULL, 0x000ff00000009400ULL, 0x00000026006d7306ULL, 0x000ff00000005400ULL,
0x0000002600447306ULL, 0x000ff0000000d400ULL, 0x00000027005c7306ULL, 0x000ff00000009400ULL,
0x00000027005e7306ULL, 0x000ff00000005400ULL, 0x00000027001b7306ULL, 0x0003f0000000d400ULL,
0x0000001e00957306ULL, 0x000fe20000009400ULL, 0x00000000a724783bULL, 0x002e6e0000000200ULL,
0x0000001e00967306ULL, 0x000ff00000005400ULL, 0x0000001e005b7306ULL, 0x0005f0000000d400ULL,
0x0000006000a37306ULL, 0x000fe20000209400ULL, 0x000100001e1e7824ULL, 0x004fca00078e00ffULL,
0x00000018ff1e7819ULL, 0x000fe4000001141eULL, 0x0000006000a27306ULL, 0x000eb00000205400ULL,
0x0000005d00a47306ULL, 0x000fe20000209400ULL, 0x0000001924249231ULL, 0x002fc400003400ffULL,
0x0000001926269231ULL, 0x000fe400003400ffULL, 0x0000001a25259231ULL, 0x080fe400003400ffULL,
0x0000001a27279231ULL, 0x000fe200003400ffULL, 0x0000005d00a17306ULL, 0x000e620000205400ULL,
0x000000a2a300720bULL, 0x004fca0003f5d000ULL, 0x000000162408723cULL, 0x040b640000041808ULL,
0x0000001f00997306ULL, 0x000fea0000009400ULL, 0x0000007e7a16723eULL, 0x020fe200000010ffULL,
0x000000862430723cULL, 0x000fe20000041830ULL, 0x0000007d7917723eULL, 0x000fe200000010ffULL,
0x0000001f00947306ULL, 0x000fe20000005400ULL, 0x000000a1a400720bULL, 0x002fc40003f9d000ULL,
0x0000006b7679723eULL, 0x000fc600000010ffULL, 0x00000016242c723cULL, 0x040be4000004182cULL,
0x0000001f00547306ULL, 0x0003ea000000d400ULL, 0x000000776e16723eULL, 0x020fe200000010ffULL,
0x000000782428723cULL, 0x000fe20000041828ULL, 0x000000716417723eULL, 0x000fe200000010ffULL,
0x0000001d00b17306ULL, 0x000fe20000209400ULL, 0x000100001f1f7824ULL, 0x002fca00078e00ffULL,
0x00000018ff1f7819ULL, 0x000fe2000001141fULL, 0x000000162448723cULL, 0x040be20000041848ULL,
0x0000001d00a97306ULL, 0x000fec0000205400ULL, 0x0000005f6916723eULL, 0x020fe200000010ffULL,
0x00000072244c723cULL, 0x000fe2000004184cULL, 0x0000001d00a77306ULL, 0x0003e2000020d400ULL,
0x000000383f17723eULL, 0x000fce00000010ffULL, 0x0000001e007b7306ULL, 0x000fe20000209400ULL,
0x00000018ff1d7819ULL, 0x002fe4000001141cULL, 0x00013800401c7811ULL, 0x000fca00078e20ffULL,
0x0000001e007c7306ULL, 0x000e700000205400ULL, 0x0000003b00977306ULL, 0x000ff00000209400ULL,
0x0000003b00987306ULL, 0x000ea20000205400ULL, 0x0000007c7b00720bULL, 0x002fce0003fdd000ULL,
0x0000006000607306ULL, 0x000e70000020d400ULL, 0x0000005d005d7306ULL, 0x000ee2000020d400ULL,
0x000000989700720bULL, 0x004fce0003fbd000ULL, 0x0000001e003d7306ULL, 0x000ea2000020d400ULL,
0x0000000160602812ULL, 0x002fe400078efcffULL, 0x000000969500720bULL, 0x000fe40003f5d000ULL,
0x0000006f6060723eULL, 0x000fc600000010ffULL, 0x0000001f007f7306ULL, 0x000fe20000209400ULL,
0x000000015d5d4812ULL, 0x008fe400078efcffULL, 0x000000949900720bULL, 0x000fe40003f9d000ULL,
0x000000685d61723eULL, 0x000fc600000010ffULL, 0x0000001f00897306ULL, 0x000e620000205400ULL,
0x000000013d3d6812ULL, 0x004fe400078efcffULL, 0x000000b0b200720bULL, 0x000fe20003fdd000ULL,
0x000000602420723cULL, 0x000fe20000041820ULL, 0x000000015b5b2812ULL, 0x000fc600078efcffULL,
0x0000001f00707306ULL, 0x000ea2000020d400ULL, 0x0000000154544812ULL, 0x000fce00078efcffULL,
0x0000001d00a57306ULL, 0x000fe20000209400ULL, 0x000000897f00720bULL, 0x002fe40003f1d000ULL,
0x000000018b8b6812ULL, 0x000fc800078efcffULL, 0x000000508b50723eULL, 0x000fe200000010ffULL,
0x0000001d009d7306ULL, 0x000e6c0000205400ULL, 0x0000000170700812ULL, 0x004fe400078efcffULL,
0x0000001d00407306ULL, 0x0004e2000020d400ULL, 0x000000a9b100720bULL, 0x000fce0003f1d000ULL,
0x0000003b003b7306ULL, 0x000f22000020d400ULL, 0x000000001c1c783bULL, 0x004ea20000000200ULL,
0x0000009da500720bULL, 0x002fc80003fdd000ULL, 0x00000001a7a70812ULL, 0x000fe400078efcffULL,
0x0000005800837306ULL, 0x000fee0000209400ULL, 0x0000000140406812ULL, 0x008fe200078efcffULL,
0x0000005800827306ULL, 0x000e620000205400ULL, 0x000000013b3b5812ULL, 0x010fce00078efcffULL,
0x0000005100627306ULL, 0x000ff00000209400ULL, 0x0000005100637306ULL, 0x000ee20000205400ULL,
0x000000828300720bULL, 0x002fce0003fbd000ULL, 0x0000003600957306ULL, 0x000fe20000209400ULL,
0x000000191c1c9231ULL, 0x084fe400003400ffULL, 0x000000191e1e9231ULL, 0x000fe400003400ffULL,
0x0000001a1d1d9231ULL, 0x080fe400003400ffULL, 0x0000001a1f1f9231ULL, 0x000fe200003400ffULL,
0x0000003600947306ULL, 0x000e620000205400ULL, 0x000000636200720bULL, 0x008fe40003f9d000ULL,
0x000000747500720bULL, 0x000fca0003f3d000ULL, 0x0000003600917306ULL, 0x0004f0000020d400ULL,
0x0000005700657306ULL, 0x000fe20000209400ULL, 0x000000939036723eULL, 0x004fe400000010ffULL,
0x000000949500720bULL, 0x002fc40003f1d000ULL, 0x0000000146461812ULL, 0x000fc600078efcffULL,
0x0000005700667306ULL, 0x000e620000205400ULL, 0x000000362404723cULL, 0x000b6e0000041804ULL,
0x0000005800587306ULL, 0x000ea2000020d400ULL, 0x0000003e3b36723eULL, 0x020fe400000010ffULL,
0x0000000191910812ULL, 0x008fca00078efcffULL, 0x0000005100517306ULL, 0x000ee2000020d400ULL,
0x000000666500720bULL, 0x002fce0003f5d000ULL, 0x0000004700397306ULL, 0x000fe20000209400ULL,
0x0000000158585812ULL, 0x004fe400078efcffULL, 0x0000006d6c00720bULL, 0x000fe40003fbd000ULL,
0x000000345837723eULL, 0x000fc600000010ffULL, 0x00000047003a7306ULL, 0x000e620000205400ULL,
0x0000000151514812ULL, 0x008fce00078efcffULL, 0x0000005700577306ULL, 0x000ea2000020d400ULL,
0x0000000144445812ULL, 0x000fce00078efcffULL, 0x0000004500597306ULL, 0x000fe20000209400ULL,
0x0000003a3900720bULL, 0x002fe40003f9d000ULL, 0x000000161c38723cULL, 0x000b6a0000041808ULL,
0x00000045005a7306ULL, 0x000e620000205400ULL, 0x0000000157572812ULL, 0x004fe400078efcffULL,
0x0000005b3508723eULL, 0x020fc400000010ffULL, 0x0000005e5c00720bULL, 0x000fe20003f5d000ULL,
0x000000361c34723cULL, 0x040b620000041804ULL, 0x000000543c09723eULL, 0x000fe200000010ffULL,
0x000000b400817306ULL, 0x000fea0000209400ULL, 0x0000003d5704723eULL, 0x020fe200000010ffULL,
0x000000081c30723cULL, 0x000b620000041830ULL, 0x000000705105723eULL, 0x000fe200000010ffULL,
0x000000b4007a7306ULL, 0x000ea20000205400ULL, 0x0000005a5900720bULL, 0x002fc40003f7d000ULL,
0x000000011b1b2812ULL, 0x000fe400078efcffULL, 0x00000046a751723eULL, 0x000fe200000010ffULL,
0x000000041c2c723cULL, 0x040b64000004182cULL, 0x0000004700477306ULL, 0x000e6c000020d400ULL,
0x000000501c28723cULL, 0x000b640000041828ULL, 0x0000004500457306ULL, 0x000ee2000020d400ULL,
0x0000007a8100720bULL, 0x004fce0003fdd000ULL, 0x000000b400b47306ULL, 0x000ea2000020d400ULL,
0x0000000147474812ULL, 0x002fc800078efcffULL, 0x000000404708723eULL, 0x020fc600000010ffULL,
0x0000004200557306ULL, 0x000fe20000209400ULL, 0x0000000145453812ULL, 0x008fc800078efcffULL,
0x000000914509723eULL, 0x000fc600000010ffULL, 0x0000004200567306ULL, 0x000e620000205400ULL,
0x00000001b4b46812ULL, 0x004fc800078efcffULL, 0x00000044b404723eULL, 0x000fc600000010ffULL,
0x0000001400527306ULL, 0x000ff00000209400ULL, 0x0000001400537306ULL, 0x000ea20000205400ULL,
0x000000565500720bULL, 0x002fce0003f3d000ULL, 0x000000b5006b7306ULL, 0x000ff00000209400ULL,
0x000000b500647306ULL, 0x000e620000205400ULL, 0x000000535200720bULL, 0x004fce0003f9d000ULL,
0x000000b3005c7306ULL, 0x000ff00000209400ULL, 0x000000b300247306ULL, 0x000ea20000205400ULL,
0x000000646b00720bULL, 0x002fce0003f1d000ULL, 0x000000af000a7306ULL, 0x000ff00000209400ULL,
0x000000af00067306ULL, 0x000e620000205400ULL, 0x000000245c00720bULL, 0x004fce0003f7d000ULL,
0x0000004200427306ULL, 0x000eb0000020d400ULL, 0x0000001400147306ULL, 0x000ee2000020d400ULL,
0x000000060a00720bULL, 0x002fe40003fdd000ULL, 0x000000081c08723cULL, 0x000b6a0000041848ULL,
0x000000b500b57306ULL, 0x000e62000020d400ULL, 0x0000000142421812ULL, 0x004fce00078efcffULL,
0x000000b300b37306ULL, 0x000ea2000020d400ULL, 0x0000000114144812ULL, 0x008fce00078efcffULL,
0x000000af00177306ULL, 0x000ee2000020d400ULL, 0x00000001b5b50812ULL, 0x002fc800078efcffULL,
0x0000001bb505723eULL, 0x000fe400000010ffULL, 0x00000001b3b33812ULL, 0x004fc800078efcffULL,
0x000000b34216723eULL, 0x000fe200000010ffULL, 0x000000041c04723cULL, 0x000b62000004184cULL,
0x0000000117176812ULL, 0x008fc800078efcffULL, 0x000000171417723eULL, 0x000fce00000010ffULL,
0x000000161c20723cULL, 0x000b620000041820ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0186b800ff167f8cULL, 0x020e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0186a000ffff7f8cULL, 0x000fe2000c80043fULL,
0x0000000215147810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff487224ULL, 0x002fc400078e0017ULL,
0x0000000113137810ULL, 0x000fc80007ffe0ffULL, 0x0000000e1300720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xfffe7a2000007947ULL, 0x000fea000383ffffULL,
0x000000ff0e00720cULL, 0x000fe20003f05270ULL, 0x000000ffff1a7224ULL, 0x000fe400078e0007ULL,
0x000000ffff197224ULL, 0x000fe400078e0006ULL, 0x000000ffff187224ULL, 0x000fe400078e0005ULL,
0x000000ffff177224ULL, 0x008fe400078e0004ULL, 0x000000ffff167224ULL, 0x000fe400078e000bULL,
0x000000ffff157224ULL, 0x002fc400078e000aULL, 0x000000ffff137224ULL, 0x000fe400078e0009ULL,
0x000000ffff127224ULL, 0x000fe200078e0008ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x0180000011007810ULL, 0x000fe20007ffe0ffULL, 0x000000c000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000000ffff037224ULL, 0x000fe200078e0011ULL,
0x000198c000047802ULL, 0x000fc40000000f00ULL, 0x00009aa000007944ULL, 0x004fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000001100007308ULL, 0x000e640000001000ULL,
0xbf80000000117423ULL, 0x002fc80000000011ULL, 0x800000ff11117221ULL, 0x000fc80000010100ULL,
0x0000001100007223ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006800ff047624ULL, 0x000fe400078e00ffULL, 0x00006900ff057624ULL, 0x000fca00078e00ffULL,
0x0000000604047981ULL, 0x0088e8000c1e9900ULL, 0x0000000000057919ULL, 0x010f240000000000ULL,
0x00000002ff037819ULL, 0x016fe40000011605ULL, 0x0000000805057811ULL, 0x000fe200078ff0ffULL,
0x0000000004007220ULL, 0x008fca0000410000ULL, 0x00001f0300037589ULL, 0x000e6800000e0000ULL,
0x00001f0500007589ULL, 0x000ea200000e0000ULL, 0x0000003803387220ULL, 0x042fe40000410000ULL,
0x0000003903397220ULL, 0x040fe40000410000ULL, 0x0000003403347220ULL, 0x040fe40000410000ULL,
0x0000003503357220ULL, 0x000fc40000410000ULL, 0x0000003003307220ULL, 0x040fe40000410000ULL,
0x0000003103317220ULL, 0x040fe40000410000ULL, 0x0000002c032c7220ULL, 0x040fe40000410000ULL,
0x0000002d032d7220ULL, 0x040fe40000410000ULL, 0x0000002803287220ULL, 0x040fe40000410000ULL,
0x0000002903297220ULL, 0x000fc40000410000ULL, 0x0000001203127220ULL, 0x040fe40000410000ULL,
0x0000001303137220ULL, 0x040fe40000410000ULL, 0x0000001703177220ULL, 0x040fe40000410000ULL,
0x0000001803187220ULL, 0x040fe40000410000ULL, 0x0000002003207220ULL, 0x040fe40000410000ULL,
0x0000002103217220ULL, 0x000fc40000410000ULL, 0x0000003a003a7220ULL, 0x044fe40000410000ULL,
0x0000003b003b7220ULL, 0x040fe40000410000ULL, 0x0000003600367220ULL, 0x040fe40000410000ULL,
0x0000003700377220ULL, 0x040fe40000410000ULL, 0x0000003200327220ULL, 0x040fe40000410000ULL,
0x0000003300337220ULL, 0x000fc40000410000ULL, 0x0000002e002e7220ULL, 0x040fe40000410000ULL,
0x0000002f002f7220ULL, 0x040fe40000410000ULL, 0x0000002a002a7220ULL, 0x040fe40000410000ULL,
0x0000002b002b7220ULL, 0x040fe40000410000ULL, 0x0000001500157220ULL, 0x040fe40000410000ULL,
0x0000001600167220ULL, 0x000fc40000410000ULL, 0x0000001900197220ULL, 0x040fe40000410000ULL,
0x0000001a001a7220ULL, 0x040fe40000410000ULL, 0x0000002200227220ULL, 0x040fe40000410000ULL,
0x0000002300237220ULL, 0x000fc40000410000ULL, 0x00000000001b7919ULL, 0x000e620000000000ULL,
0x00000000000579c3ULL, 0x000ee20000002700ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x00000002ff047819ULL, 0x002fc6000001161bULL, 0x00000005040472a4ULL, 0x008fe2000f8e023fULL,
0x000000021b007812ULL, 0x040fe400078ec0ffULL, 0x000000081b057811ULL, 0x000fe200078ff0ffULL,
0x0000000804077824ULL, 0x000fe200078e00ffULL, 0x0000000400037211ULL, 0x000fe200078ff8ffULL,
0x0000000804087824ULL, 0x000fe200078e00ffULL, 0x0000000500067211ULL, 0x000fe200078ff8ffULL,
0x0000000805097824ULL, 0x000fe200078e00ffULL, 0x0000000203007810ULL, 0x040fe20007ffe0ffULL,
0x00000008040a7824ULL, 0x040fe200078e00ffULL, 0x0000000403057810ULL, 0x000fe20007ffe0ffULL,
0x00000008040b7824ULL, 0x000fe200078e00ffULL, 0xfffffff807047812ULL, 0x000fc400078ee203ULL,
0x0000000603037810ULL, 0x000fe40007ffe0ffULL, 0xfffffff809097812ULL, 0x000fe400078ee206ULL,
0xfffffff808067812ULL, 0x000fe400078ee200ULL, 0xfffffff80b087812ULL, 0x000fe200078ee203ULL,
0x000000081b037824ULL, 0x000fe200078e00ffULL, 0xfffffff80a077812ULL, 0x000fe400078ee205ULL,
0x0001200002057811ULL, 0x000fc400078e58ffULL, 0x0000000803037812ULL, 0x000fe400078ec0ffULL,
0x000000201b0d7810ULL, 0x000fe20007ffe0ffULL, 0x0000001004047824ULL, 0x100fe200078e0205ULL,
0x000000383900723eULL, 0x000fe200000010ffULL, 0x0000001009097824ULL, 0x000fe200078e0205ULL,
0x000000343502723eULL, 0x000fe200000010ffULL, 0x0000000104047824ULL, 0x000fe200078e0203ULL,
0x00000003ff0e7819ULL, 0x000fe2000001160dULL, 0x0000001006067824ULL, 0x000fe200078e0205ULL,
0x0000541000107816ULL, 0x140fe20000000002ULL, 0x00000001030a7824ULL, 0x000fe200078e0209ULL,
0x0000763200117816ULL, 0x000fe20000000002ULL, 0x000000010d0c7824ULL, 0x000fe200078e020eULL,
0x00000003ff0b7819ULL, 0x000fe2000001161bULL, 0x0000001007007824ULL, 0x000fc400078e0205ULL,
0x0000001004007388ULL, 0x0003e20000000a00ULL, 0x000000070c0c7812ULL, 0x000fe200078ec0ffULL,
0x0000001008027824ULL, 0x000fe400078e0205ULL, 0x0000000103077824ULL, 0x040fe400078e0206ULL,
0x0000000103087824ULL, 0x000fe200078e0200ULL, 0x000000303100723eULL, 0x000fe200000010ffULL,
0x0000000103097824ULL, 0x000fe200078e0202ULL, 0x0000002c2d02723eULL, 0x000fe400000010ffULL,
0x000000282903723eULL, 0x000fe200000010ffULL, 0x000000010b047824ULL, 0x002fe200078e021bULL,
0x0ffffff80c107812ULL, 0x000fc400078ef80dULL, 0x0000763200117816ULL, 0x100fe40000000002ULL,
0x0000000704047812ULL, 0x000fe200078ec0ffULL, 0x0000001010147824ULL, 0x000fe200078e0205ULL,
0x0000541000107816ULL, 0x000fe40000000002ULL, 0x0ffffff804067812ULL, 0x000fe400078ef81bULL,
0x000000121304723eULL, 0x000fe200000010ffULL, 0x0000001007007388ULL, 0x000fe20000000a00ULL,
0x000000171800723eULL, 0x000fe200000010ffULL, 0x00000010060c7824ULL, 0x000fe200078e0205ULL,
0x0000541003027816ULL, 0x000fc40000000004ULL, 0x0000763203037816ULL, 0x000fe40000000004ULL,
0x000000363704723eULL, 0x000fe400000010ffULL, 0x000000323305723eULL, 0x000fe200000010ffULL,
0x0000000208007388ULL, 0x0003e20000000a00ULL, 0x0000002e2f06723eULL, 0x000fe400000010ffULL,
0x000000071b1b7812ULL, 0x000fe400078ec0ffULL, 0x000000070d0d7812ULL, 0x000fc800078ec0ffULL,
0x1ffffff80d0d7812ULL, 0x000fe400078ef80fULL, 0x000000202102723eULL, 0x002fe400000010ffULL,
0x0000003a3b03723eULL, 0x000fe400000010ffULL, 0x0000541000107816ULL, 0x140fe40000000002ULL,
0x0000763200117816ULL, 0x000fe40000000002ULL, 0x0000541003027816ULL, 0x000fc40000000004ULL,
0x0000763203037816ULL, 0x000fe20000000004ULL, 0x0000001009007388ULL, 0x000fe20000000a00ULL,
0x0000541005047816ULL, 0x140fe40000000006ULL, 0x0000763205057816ULL, 0x000fe20000000006ULL,
0x000000020a007388ULL, 0x0003e20000000a00ULL, 0x0000002a2b00723eULL, 0x000fc600000010ffULL,
0x0004000407007388ULL, 0x0007e20000000a00ULL, 0x000000151602723eULL, 0x002fe400000010ffULL,
0x000000191a03723eULL, 0x000fe200000010ffULL, 0x0000000000057919ULL, 0x008e620000002600ULL,
0x000000222304723eULL, 0x000fe400000010ffULL, 0x0000541000067816ULL, 0x140fe40000000002ULL,
0x0000763200077816ULL, 0x000fe40000000002ULL, 0x0000541003027816ULL, 0x000fc40000000004ULL,
0x0000763203037816ULL, 0x000fe20000000004ULL, 0x0004000608007388ULL, 0x000fe80000000a00ULL,
0x0004000209007388ULL, 0x0007e20000000a00ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000000000c107984ULL, 0x000f220000000c00ULL, 0x0000000805007824ULL, 0x002fc600078e00ffULL,
0x0000000014147984ULL, 0x000e620000000c00ULL, 0x0000000805057824ULL, 0x000fe200078e00ffULL,
0xfffffff8000b7812ULL, 0x000fc800078ee20bULL, 0xfffffff8050e7812ULL, 0x000fe400078ee20eULL,
0x000000040b0b7c10ULL, 0x000fe4000ff1e0ffULL, 0x000000040e0e7c10ULL, 0x000fc6000ff3e0ffULL,
0x000000ffff007224ULL, 0x000fe200000e06ffULL, 0x00005a000b027a11ULL, 0x048fe200078048ffULL,
0x000000ffff057224ULL, 0x000fe200008e06ffULL, 0x00005a000e047a11ULL, 0x040fe400078248ffULL,
0x00005b000b037a11ULL, 0x000fe400000f4c00ULL, 0x1ffffff81b007812ULL, 0x000fe400078ef80fULL,
0x00005b000e057a11ULL, 0x000fc600008f4c05ULL, 0x0000001000027825ULL, 0x000fc800078e0002ULL,
0x000000100d047825ULL, 0x000fe200078e0004ULL, 0x0000001002007986ULL, 0x010fe8000c101d06ULL,
0x0000001404007986ULL, 0x002fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff0f7819ULL, 0x000fe20000011602ULL, 0xffffffffff387424ULL, 0x000fc600078e00ffULL,
0x0000000d0f00720cULL, 0x000fda0003f06070ULL, 0x0000000212048824ULL, 0x002fc800078e00ffULL,
0x0000640004048a24ULL, 0x000fc800078e020fULL, 0x0000600004048625ULL, 0x000fe200078e0005ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00006800ff3c7624ULL, 0x000fe200078e00ffULL,
0x0000000604388981ULL, 0x0002a2000c1e1900ULL, 0x00006900ff3d7624ULL, 0x000fca00078e00ffULL,
0x000000063c3c7981ULL, 0x000722000c1e9900ULL, 0x000001ff0700780cULL, 0x000fe20003f04070ULL,
0x0000008000007824ULL, 0x000fe400078e00ffULL, 0x00000040023a7824ULL, 0x000fe200078e00ffULL,
0x01860000ff047f8cULL, 0x002e62000c80043fULL, 0x0000008039397824ULL, 0x000fc600078e00ffULL,
0x0000004000087812ULL, 0x000fe200078ef83aULL, 0x0000003938077224ULL, 0x004fc800078e02ffULL,
0x00000e8000000947ULL, 0x000fea0003800000ULL, 0x00000003ff267819ULL, 0x10afe40000011603ULL,
0x0000003a0c097217ULL, 0x000fe40007800000ULL, 0x00000004260b7810ULL, 0x000fe20007ffe0ffULL,
0x00000001080a7824ULL, 0x000fe200078e0226ULL, 0x0000000826117810ULL, 0x040fe20007ffe0ffULL,
0x0000000109097824ULL, 0x000fe200078e0a3aULL, 0x0000001426177810ULL, 0x000fe20007ffe0ffULL,
0x000000010b107824ULL, 0x000fe200078e0203ULL, 0x0000000a071f7210ULL, 0x000fe20007f3e0ffULL,
0x00000001080a7824ULL, 0x000fe200078e020bULL, 0x000000090b00720cULL, 0x040fe20003f06070ULL,
0x000000080b137824ULL, 0x000fe200078e00ffULL, 0x0000001826197810ULL, 0x000fe20007ffe0ffULL,
0x00000001110b7824ULL, 0x000fe200078e0203ULL, 0x0000000a070a7210ULL, 0x000fe20007f5e0ffULL,
0x0000000811147824ULL, 0x000fe200078e00ffULL, 0xfffffff813137812ULL, 0x000fe200078ee210ULL,
0x000000ffff157224ULL, 0x000fe200008e06ffULL, 0x00005e001f187a11ULL, 0x000fe200078240ffULL,
0x000000ffff1e7224ULL, 0x000fe200010e06ffULL, 0x00005e000a1a7a11ULL, 0x000fe200078440ffULL,
0x0000000108167824ULL, 0x000fe200078e0217ULL, 0xfffffff814147812ULL, 0x000fc400078ee20bULL,
0x00005f000a1e7a11ULL, 0x000fe400010f441eULL, 0x0000000c260a7810ULL, 0x000fe40007ffe0ffULL,
0x00005f001f1f7a11ULL, 0x000fe400008f4415ULL, 0x000000091100720cULL, 0x000fe20003f26070ULL,
0x00000001080b7824ULL, 0x000fe200078e020aULL, 0x0000001026157810ULL, 0x000fe20007ffe0ffULL,
0x0000000108117824ULL, 0x000fe200078e0211ULL, 0x0000001607167210ULL, 0x040fe20007f7e0ffULL,
0x000000080a287824ULL, 0x000fe200078e00ffULL, 0x0000000b070b7210ULL, 0x040fe20007fbe0ffULL,
0x0000000108107824ULL, 0x000fe200078e0215ULL, 0x0000001107117210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff227224ULL, 0x000fe200018e06ffULL, 0x00005e0016217a11ULL, 0x000fe200078640ffULL,
0x000000ffff257224ULL, 0x000fe200028e06ffULL, 0x00005e000b247a11ULL, 0x000fe200078a40ffULL,
0x000000ffff1d7224ULL, 0x000fe200020e06ffULL, 0x0000001007107210ULL, 0x000fe20007f5e0ffULL,
0x0000000815297824ULL, 0x000fe200078e00ffULL, 0x00005f000b257a11ULL, 0x000fe200028f4425ULL,
0x00000001260b7824ULL, 0x000fe200078e0203ULL, 0x00005e00111b7a11ULL, 0x000fe200078840ffULL,
0x000000ffff237224ULL, 0x000fe200010e06ffULL, 0x00005e00101c7a11ULL, 0x000fc400078440ffULL,
0x00005f00111d7a11ULL, 0x000fe400020f441dULL, 0x000000070b117812ULL, 0x000fe200078ec0ffULL,
0x00000001080b7824ULL, 0x000fe200078e0219ULL, 0x0000007006277812ULL, 0x000fe400078ec0ffULL,
0x00005f0010237a11ULL, 0x000fe200010f4423ULL, 0x000000010a107824ULL, 0x100fe200078e0203ULL,
0x00005f0016227a11ULL, 0x000fe200018f4422ULL, 0x0000000115167824ULL, 0x000fe200078e0203ULL,
0x000000090a00720cULL, 0x000fc40003fa6070ULL, 0x0000000b07207210ULL, 0x000fe40007fde0ffULL,
0x00000018270a7210ULL, 0x000fe40007f7e0ffULL, 0x000000092600720cULL, 0x080fe20003f46070ULL,
0x000000ffff187224ULL, 0x000fe200030e06ffULL, 0x0000200002067811ULL, 0x000fe200078e70ffULL,
0x000000ffff0b7224ULL, 0x000fe200018e061fULL, 0x0ffffff811117812ULL, 0x100fe400078ef803ULL,
0x00005e00201f7a11ULL, 0x000fe200078640ffULL, 0x0000001013137824ULL, 0x100fe200078e0206ULL,
0x000000091500720cULL, 0x080fe20003f86070ULL, 0x0000001011117824ULL, 0x000fe200078e0206ULL,
0xfffffff828157812ULL, 0x000fe200078ee210ULL, 0x0000001014147824ULL, 0x000fe200078e0206ULL,
0x00005f0020207a11ULL, 0x000fe200018f4418ULL, 0x0000000117187824ULL, 0x100fe200078e0203ULL,
0x0000001a27107210ULL, 0x000fe20007f7e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a117faeULL, 0x0003e2000d101c46ULL, 0x0000001c261a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000817287824ULL, 0x040fe200078e00ffULL, 0x000000091700720cULL, 0x000fe20003f46070ULL,
0x0000000119177824ULL, 0x000fe200078e0203ULL, 0xfffffff829167812ULL, 0x000fe200078ee216ULL,
0x0000001015157824ULL, 0x000fe200078e0206ULL, 0xfffffff828187812ULL, 0x000fc600078ee218ULL,
0x0000001016167824ULL, 0x000fe400078e0206ULL, 0x000000ffff117224ULL, 0x002fe200018e061eULL,
0x0000001b270a7210ULL, 0x000fe20007f7e0ffULL, 0x00000001081b7824ULL, 0x000fe400078e021aULL,
0x0000001018187824ULL, 0x000fe200078e0206ULL, 0x0000000010137faeULL, 0x0003e2000c101c46ULL,
0x000000ffff0b7224ULL, 0x000fe200018e061dULL, 0x0000001b071b7210ULL, 0x000fe40007fde0ffULL,
0x000000091900720cULL, 0x040fe20003f66070ULL, 0x0000000819197824ULL, 0x000fe200078e00ffULL,
0x000000000a147faeULL, 0x0005e2000c901c46ULL, 0x000000ffff1e7224ULL, 0x000fe200030e06ffULL,
0x00005e001b1d7a11ULL, 0x000fc400078c40ffULL, 0xfffffff819177812ULL, 0x000fe400078ee217ULL,
0x00005f001b1e7a11ULL, 0x000fe200030f441eULL, 0x000000011a137824ULL, 0x042fe200078e0203ULL,
0x0000002427107210ULL, 0x000fe20007fde0ffULL, 0x0000001017177824ULL, 0x000fe200078e0206ULL,
0x000000091a00720cULL, 0x040fe20003f06070ULL, 0x000000081a1a7824ULL, 0x000fe200078e00ffULL,
0x0000002026147810ULL, 0x004fe20007ffe0ffULL, 0x000000ffff117224ULL, 0x000fe200030e0625ULL,
0x0000001c270a7210ULL, 0x000fc40007f3e0ffULL, 0xfffffff81a137812ULL, 0x000fe200078ee213ULL,
0x0000000108197824ULL, 0x000fe200078e0214ULL, 0x0000000010157faeULL, 0x0003e2000e901c46ULL,
0x000000ffff0b7224ULL, 0x000fe200008e0623ULL, 0x000000091400720cULL, 0x040fe20003f26070ULL,
0x0000000814237824ULL, 0x040fe200078e00ffULL, 0x00000019071c7210ULL, 0x000fe20007fde0ffULL,
0x0000000114197824ULL, 0x000fe200078e0203ULL, 0x000000000a167faeULL, 0x0005e2000e101c46ULL,
0x0000001013137824ULL, 0x000fe400078e0206ULL, 0x000000ffff147224ULL, 0x000fe200030e06ffULL,
0x00005e001c1b7a11ULL, 0x000fc400078c40ffULL, 0xfffffff823197812ULL, 0x000fe400078ee219ULL,
0x00005f001c1c7a11ULL, 0x000fe400030f4414ULL, 0x0000002426147810ULL, 0x000fe20007ffe0ffULL,
0x0000001019197824ULL, 0x000fe200078e0206ULL, 0x00000021270a7210ULL, 0x004fe40007fbe0ffULL,
0x000000091400720cULL, 0x000fe20003f86070ULL, 0x0000000108107824ULL, 0x002fe400078e0214ULL,
0x0000000114117824ULL, 0x000fc400078e0203ULL, 0x0000000814157824ULL, 0x000fe200078e00ffULL,
0x0000001007167210ULL, 0x000fe20007fde0ffULL, 0x000000ffff0b7224ULL, 0x000fe200028e0622ULL,
0x0000001f27107210ULL, 0x000fe40007fbe0ffULL, 0xfffffff815157812ULL, 0x000fe200078ee211ULL,
0x000000ffff1a7224ULL, 0x000fe200030e06ffULL, 0x000000000a187faeULL, 0x0003e2000d101c46ULL,
0x000000ffff117224ULL, 0x000fe200028e0620ULL, 0x00005e0016147a11ULL, 0x000fc800078c40ffULL,
0x0000000010177faeULL, 0x0005e2000d901c46ULL, 0x00005f0016167a11ULL, 0x000fe400030f441aULL,
0x0000003c261a7810ULL, 0x040fe40007ffe0ffULL, 0x0000001d270a7210ULL, 0x002fe40007f5e0ffULL,
0x0000003826187810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0b7224ULL, 0x000fe200010e061eULL,
0x0000001b27107210ULL, 0x044fe20007f7e0ffULL, 0x00000008181f7824ULL, 0x000fe200078e00ffULL,
0x0000001427147210ULL, 0x000fe40007f5e0ffULL, 0x000000000a137faeULL, 0x0003e2000c101c46ULL,
0x000000ffff117224ULL, 0x000fca00018e061cULL, 0x0000000010197faeULL, 0x0005e2000c901c46ULL,
0x000000091800720cULL, 0x080fe20003f26070ULL, 0x00000010150a7824ULL, 0x002fe200078e0206ULL,
0x00000028260b7810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff157224ULL, 0x000fe200010e0616ULL,
0x0000003426167810ULL, 0x040fe40007ffe0ffULL, 0x000000090b00720cULL, 0x0c0fe20003fa6070ULL,
0x000000010b107824ULL, 0x044fe200078e0203ULL, 0x00000000140a7faeULL, 0x0003e2000e101c46ULL,
0x0000002c26117810ULL, 0x000fe20007ffe0ffULL, 0x000000080b137824ULL, 0x000fe200078e00ffULL,
0x000000091600720cULL, 0x0c0fe20003f46070ULL, 0x00000008161e7824ULL, 0x000fe200078e00ffULL,
0x000000091100720cULL, 0x040fe20003f86070ULL, 0x0000000811197824ULL, 0x000fc400078e00ffULL,
0x00000001080a7824ULL, 0x002fe200078e020bULL, 0x0000003026147810ULL, 0x000fc80007ffe0ffULL,
0x0000000a07157210ULL, 0x000fe20007f1e0ffULL, 0x00000001110a7824ULL, 0x000fe200078e0203ULL,
0x000000091400720cULL, 0x080fe20003f66070ULL, 0x0000000108117824ULL, 0x000fe200078e0211ULL,
0x00005e00150b7a11ULL, 0x000fe200078c40ffULL, 0x000000ffff177224ULL, 0x000fe200000e06ffULL,
0x000000091a00720cULL, 0x000fe40003f06070ULL, 0xfffffff813097812ULL, 0x000fe200078ee210ULL,
0x0000000114107824ULL, 0x040fe200078e0203ULL, 0xfffffff819137812ULL, 0x000fe200078ee20aULL,
0x0000000814197824ULL, 0x000fe200078e00ffULL, 0x00005f0015157a11ULL, 0x000fe200030f4417ULL,
0x0000000108147824ULL, 0x000fe200078e0214ULL, 0x0000000b270a7210ULL, 0x000fe20007fde0ffULL,
0x0000000116177824ULL, 0x000fc400078e0203ULL, 0x0000001009097824ULL, 0x000fe400078e0206ULL,
0x000000ffff0b7224ULL, 0x000fe200030e0615ULL, 0x00000011071c7210ULL, 0x000fe20007fde0ffULL,
0x0000000118117824ULL, 0x000fe200078e0203ULL, 0xfffffff819157812ULL, 0x000fe200078ee210ULL,
0x0000000108167824ULL, 0x000fe200078e0216ULL, 0x000000000a097faeULL, 0x0003e2000e901c46ULL,
0x000000ffff1d7224ULL, 0x000fe200030e06ffULL, 0x00005e001c1b7a11ULL, 0x000fe200078c40ffULL,
0x0000000108187824ULL, 0x040fe200078e0218ULL, 0xfffffff81f197812ULL, 0x000fe200078ee211ULL,
0x0000000108087824ULL, 0x000fe200078e021aULL, 0x00005f001c117a11ULL, 0x000fe200030f441dULL,
0x000000011a037824ULL, 0x040fe200078e0203ULL, 0x0000001b27107210ULL, 0x000fe20007fde0ffULL,
0x000000081a1c7824ULL, 0x000fe200078e00ffULL, 0x0000001607167210ULL, 0x000fe20007fbe0ffULL,
0x0000001013137824ULL, 0x100fe200078e0206ULL, 0xfffffff81e177812ULL, 0x000fe200078ee217ULL,
0x000000ffff117224ULL, 0x000fe200030e0611ULL, 0x00000014071b7210ULL, 0x000fe20007fde0ffULL,
0x0000001015157824ULL, 0x100fe200078e0206ULL, 0xfffffff81c037812ULL, 0x000fe200078ee203ULL,
0x0000001017177824ULL, 0x100fe200078e0206ULL, 0x0000000010137faeULL, 0x0005e2000e101c46ULL,
0x000000ffff1a7224ULL, 0x000fe200030e06ffULL, 0x00005e001b147a11ULL, 0x000fe200078c40ffULL,
0x0000001019197824ULL, 0x100fe200078e0206ULL, 0x0000001807187210ULL, 0x000fe20007f9e0ffULL,
0x0000001003037824ULL, 0x000fe200078e0206ULL, 0x00005f001b1a7a11ULL, 0x000fc600030f441aULL,
0x000000ffff0b7224ULL, 0x002fe200020e06ffULL, 0x00005e00180a7a11ULL, 0x000fe400078840ffULL,
0x0000000807117210ULL, 0x004fe20007fde0ffULL, 0x000000ffff137224ULL, 0x000fe200028e06ffULL,
0x00005e0016087a11ULL, 0x000fe400078a40ffULL, 0x00005f00180b7a11ULL, 0x000fe200020f440bULL,
0x000000ffff097224ULL, 0x000fe200030e06ffULL, 0x00005f0016137a11ULL, 0x000fe400028f4413ULL,
0x0000001427067210ULL, 0x000fc40007fbe0ffULL, 0x00005e0011107a11ULL, 0x000fe400078c40ffULL,
0x0000000a270a7210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff077224ULL, 0x000fe200028e061aULL,
0x0000000827087210ULL, 0x000fe40007fbe0ffULL, 0x00005f0011117a11ULL, 0x000fe200030f4409ULL,
0x000000ffff0b7224ULL, 0x000fe200020e060bULL, 0x0000000006157faeULL, 0x0003e2000d901c46ULL,
0x000000ffff097224ULL, 0x000fe200028e0613ULL, 0x0000001027107210ULL, 0x000fc80007fbe0ffULL,
0x0000000008177faeULL, 0x0003e2000d101c46ULL, 0x000000ffff117224ULL, 0x000fc600028e0611ULL,
0x000000000a197faeULL, 0x0003e8000c901c46ULL, 0x0000000010037faeULL, 0x0003e2000c101c46ULL,
0x00000d4000007947ULL, 0x000fea0003800000ULL, 0x0000000c03137811ULL, 0x04afe400078fe8ffULL,
0x0000000803117811ULL, 0x040fe400078fe8ffULL, 0x00000004030b7811ULL, 0x000fe200078fe8ffULL,
0x0000000113157824ULL, 0x100fe200078e0203ULL, 0x0000001003167811ULL, 0x000fe200078fe8ffULL,
0x0000000813187824ULL, 0x000fe200078e00ffULL, 0x00000020031e7811ULL, 0x000fe200078fe8ffULL,
0x00000001110a7824ULL, 0x000fe200078e0203ULL, 0x0000001c031c7811ULL, 0x000fe200078fe8ffULL,
0x0000000811147824ULL, 0x000fe200078e00ffULL, 0xfffffff818157812ULL, 0x000fe200078ee215ULL,
0x000000010b097824ULL, 0x100fe200078e0203ULL, 0x00000018031a7811ULL, 0x000fe200078fe8ffULL,
0x000000080b107824ULL, 0x000fe200078e00ffULL, 0x0000001403187811ULL, 0x040fe200078fe8ffULL,
0x0000000116177824ULL, 0x000fe200078e0203ULL, 0xfffffff814147812ULL, 0x000fe200078ee20aULL,
0x0000000816197824ULL, 0x000fe200078e00ffULL, 0xfffffff810107812ULL, 0x000fe200078ee209ULL,
0x000000011e1f7824ULL, 0x040fe200078e0203ULL, 0x0000002c03237811ULL, 0x000fe200078fe8ffULL,
0x000000081e217824ULL, 0x000fe200078e00ffULL, 0xfffffff819177812ULL, 0x000fe200078ee217ULL,
0x000000011c1d7824ULL, 0x040fe200078e0203ULL, 0x0000003003277811ULL, 0x000fe200078fe8ffULL,
0x000000081c207824ULL, 0x000fe200078e00ffULL, 0xfffffff8211f7812ULL, 0x000fe200078ee21fULL,
0x000000011a0a7824ULL, 0x040fe200078e0203ULL, 0x0000002803217811ULL, 0x040fe200078fe8ffULL,
0x000000081a1b7824ULL, 0x000fe200078e00ffULL, 0xfffffff8201d7812ULL, 0x000fe200078ee21dULL,
0x0000000118097824ULL, 0x140fe200078e0203ULL, 0x0000002403207811ULL, 0x000fe200078fe8ffULL,
0x0000000818197824ULL, 0x000fe200078e00ffULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee20aULL,
0x00000001210a7824ULL, 0x000fe200078e0203ULL, 0x00000038032a7811ULL, 0x000fe200078fe8ffULL,
0x0000000821247824ULL, 0x000fe200078e00ffULL, 0xfffffff819197812ULL, 0x000fe200078ee209ULL,
0x0000000120097824ULL, 0x140fe200078e0203ULL, 0x0000003c032c7811ULL, 0x000fe200078fe8ffULL,
0x0000000820227824ULL, 0x000fe200078e00ffULL, 0xfffffff824247812ULL, 0x000fe200078ee20aULL,
0x0000000123257824ULL, 0x000fe200078e0203ULL, 0x00000003030a7211ULL, 0x000fe200078fe8ffULL,
0x0000000823267824ULL, 0x000fe200078e00ffULL, 0xfffffff822227812ULL, 0x000fe200078ee209ULL,
0x0000000127287824ULL, 0x000fe200078e0203ULL, 0x0000000803097211ULL, 0x000fe200078fe8ffULL,
0x0000000827297824ULL, 0x000fe200078e00ffULL, 0xfffffff826267812ULL, 0x000fe200078ee225ULL,
0x0000000108167824ULL, 0x000fe200078e0216ULL, 0x0000003403257811ULL, 0x000fe200078fe8ffULL,
0x000000012a2b7824ULL, 0x100fe200078e0203ULL, 0x000000070a0a7812ULL, 0x000fe200078ec0ffULL,
0x00000001082d7824ULL, 0x000fe200078e022cULL, 0x00000009074c7210ULL, 0x000fe20007f1e0ffULL,
0x000000082c337824ULL, 0x000fe200078e00ffULL, 0xfffffff829287812ULL, 0x000fe200078ee228ULL,
0x0000000125297824ULL, 0x100fe200078e0203ULL, 0x0ffffff80a0a7812ULL, 0x100fe200078ef803ULL,
0x000000012c037824ULL, 0x000fe200078e0203ULL, 0x0000001607167210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff2c7224ULL, 0x000fe200000e06ffULL, 0x00005e004c4b7a11ULL, 0x000fe200078040ffULL,
0x00000001080b7824ULL, 0x040fe200078e020bULL, 0xfffffff833337812ULL, 0x000fe200078ee203ULL,
0x0000000108117824ULL, 0x000fe200078e0211ULL, 0x00005f004c4c7a11ULL, 0x000fe200000f442cULL,
0x0000000108137824ULL, 0x040fe200078e0213ULL, 0x0000000b070b7210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff447224ULL, 0x000fe200018e06ffULL, 0x0000001107117210ULL, 0x040fe20007f3e0ffULL,
0x00000001081e7824ULL, 0x000fe200078e021eULL, 0x0000001307137210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff4a7224ULL, 0x000fe200000e06ffULL, 0x00005e0016437a11ULL, 0x000fe200078640ffULL,
0x0000000108187824ULL, 0x040fe200078e0218ULL, 0x00005e000b497a11ULL, 0x000fe200078040ffULL,
0x000000ffff487224ULL, 0x000fe200008e06ffULL, 0x00005e0011477a11ULL, 0x000fe200078240ffULL,
0x00000001081a7824ULL, 0x000fe200078e021aULL, 0x00005f0016447a11ULL, 0x000fe200018f4444ULL,
0x000000ffff467224ULL, 0x000fe200010e06ffULL, 0x00005e0013457a11ULL, 0x000fe200078440ffULL,
0x00000001081c7824ULL, 0x040fe200078e021cULL, 0x0000001e071e7210ULL, 0x000fe20007f7e0ffULL,
0x0000000108207824ULL, 0x040fe200078e0220ULL, 0x00005f000b4a7a11ULL, 0x000fe200000f444aULL,
0x00000008252e7824ULL, 0x000fe200078e00ffULL, 0x00005f0011487a11ULL, 0x000fe200008f4448ULL,
0x000000ffff3f7224ULL, 0x000fe200018e06ffULL, 0x0000001807427210ULL, 0x000fe20007f1e0ffULL,
0x0000000108277824ULL, 0x040fe200078e0227ULL, 0x00005f0013467a11ULL, 0x000fe200010f4446ULL,
0x0000000108217824ULL, 0x040fe200078e0221ULL, 0x0000001a07417210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff117224ULL, 0x000fe200000e06ffULL, 0x0000001c07407210ULL, 0x000fe20007f5e0ffULL,
0x0000000108097824ULL, 0x000fe200078e0225ULL, 0x00005e001e1c7a11ULL, 0x000fe200078640ffULL,
0x000000ffff0b7224ULL, 0x000fe200008e06ffULL, 0x00005e0042167a11ULL, 0x000fe200078040ffULL,
0x000000ffff037224ULL, 0x000fe200010e06ffULL, 0x00005e0041187a11ULL, 0x000fe200078240ffULL,
0x0000000108237824ULL, 0x000fe200078e0223ULL, 0x00005f001e3f7a11ULL, 0x000fe200018f443fULL,
0x0000000108257824ULL, 0x000fe200078e022aULL, 0x00005e00401a7a11ULL, 0x000fe200078440ffULL,
0x000000082a2a7824ULL, 0x000fe200078e00ffULL, 0x0000002007207210ULL, 0x000fc40007f7e0ffULL,
0x00005f0042427a11ULL, 0x000fe400000f4411ULL, 0xfffffff82e087812ULL, 0x000fe200078ee229ULL,
0x000000ffff3e7224ULL, 0x000fe200018e06ffULL, 0x00005f0041417a11ULL, 0x000fe400008f440bULL,
0x0000200002117811ULL, 0x000fe400078e70ffULL, 0x00005f0040407a11ULL, 0x000fe400010f4403ULL,
0x0000002707377210ULL, 0x040fe20007f3e0ffULL, 0x0000001008317824ULL, 0x100fe200078e0211ULL,
0x00000021073d7210ULL, 0x040fe20007f5e0ffULL, 0x00000010242e7824ULL, 0x100fe200078e0211ULL,
0x00005e00201e7a11ULL, 0x000fe200078c40ffULL, 0x000000ffff087224ULL, 0x000fe200008e06ffULL,
0x00000023073b7210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200010e06ffULL,
0x0000000907097210ULL, 0x040fe20007f7e0ffULL, 0x000000100a037824ULL, 0x100fe200078e0211ULL,
0x0000002507357210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff0a7224ULL, 0x000fe200000e06ffULL,
0x00005f00203e7a11ULL, 0x000fe200030f443eULL, 0x00000010262f7824ULL, 0x100fe200078e0211ULL,
0x00005e0037247a11ULL, 0x000fe200078240ffULL, 0x0000001028307824ULL, 0x000fe200078e0211ULL,
0x00005e003d207a11ULL, 0x000fe200078440ffULL, 0x000000ffff367224ULL, 0x000fe200018e06ffULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee22bULL, 0x0000001010137824ULL, 0x100fe200078e0211ULL,
0x0000002d07077210ULL, 0x000fe20007fbe0ffULL, 0x00000010222d7824ULL, 0x100fe200078e0211ULL,
0x00005f0037377a11ULL, 0x000fe200008f4408ULL, 0x000000ffff087224ULL, 0x000fe200020e06ffULL,
0x00005e003b227a11ULL, 0x000fe200078040ffULL, 0x000000102a327824ULL, 0x000fe200078e0211ULL,
0x00005f003d3d7a11ULL, 0x000fe200010f440bULL, 0x000000ffff347224ULL, 0x000fe200028e06ffULL,
0x00000070064d7812ULL, 0x000fe200078ec0ffULL, 0x0000001014217824ULL, 0x100fe200078e0211ULL,
0x00005e0009267a11ULL, 0x000fe200078240ffULL, 0x0000001015237824ULL, 0x100fe200078e0211ULL,
0x00005e0035287a11ULL, 0x000fe200078440ffULL, 0x0000001017257824ULL, 0x100fe200078e0211ULL,
0x00005e00072a7a11ULL, 0x000fe200078640ffULL, 0x0000001019277824ULL, 0x100fe200078e0211ULL,
0x00005f003b3b7a11ULL, 0x000fe200000f440aULL, 0x000000101b297824ULL, 0x100fe200078e0211ULL,
0x0000004b4d067210ULL, 0x000fe20007f1e0ffULL, 0x000000101d2b7824ULL, 0x100fe200078e0211ULL,
0x00005f0009367a11ULL, 0x000fe200008f4436ULL, 0x000000101f2c7824ULL, 0x100fe200078e0211ULL,
0x00005f0035357a11ULL, 0x000fe200010f4408ULL, 0x0000001033337824ULL, 0x000fe200078e0211ULL,
0x000000494d087210ULL, 0x000fc40007f3e0ffULL, 0x00005f0007347a11ULL, 0x000fe200018f4434ULL,
0x000000ffff077224ULL, 0x000fe200000e064cULL, 0x000000474d0a7210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e064aULL, 0x000000454d107210ULL, 0x040fe40007f7e0ffULL,
0x000000434d147210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff0b7224ULL, 0x000fe200010e0648ULL,
0x000000164d167210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff117224ULL, 0x000fe200018e0646ULL,
0x000000184d187210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff157224ULL, 0x000fe200028e0644ULL,
0x0000001a4d1a7210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff177224ULL, 0x000fe200020e0642ULL,
0x0000001c4d1c7210ULL, 0x040fe20007f5e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006037faeULL, 0x0003e2000b901c46ULL, 0x0000001e4d1e7210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff197224ULL, 0x000fe200000e0641ULL, 0x000000204d207210ULL, 0x040fe20007fbe0ffULL,
0x0000000008137faeULL, 0x0003e2000b901c46ULL, 0x000000224d227210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff1b7224ULL, 0x000fe200008e0640ULL, 0x000000244d247210ULL, 0x040fe20007f1e0ffULL,
0x000000000a217faeULL, 0x0005e2000b901c46ULL, 0x000000264d267210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff1d7224ULL, 0x000fe200010e063fULL, 0x000000284d287210ULL, 0x040fe20007f5e0ffULL,
0x0000000010237faeULL, 0x0007e2000b901c46ULL, 0x000000ffff1f7224ULL, 0x000fe200018e063eULL,
0x0000002a4d2a7210ULL, 0x000fc40007f7e0ffULL, 0x0000000014257faeULL, 0x0003e8000b901c46ULL,
0x0000000016277faeULL, 0x0003e2000b901c46ULL, 0x000000ffff217224ULL, 0x004fc600028e063dULL,
0x0000000018297faeULL, 0x0005e2000b901c46ULL, 0x000000ffff237224ULL, 0x008fc600020e063bULL,
0x000000001a2b7faeULL, 0x0007e2000b901c46ULL, 0x000000ffff257224ULL, 0x002fc600000e0637ULL,
0x000000001c2c7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff277224ULL, 0x000fc600008e0636ULL,
0x000000001e2d7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff297224ULL, 0x004fc600010e0635ULL,
0x00000000202e7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff2b7224ULL, 0x008fc600018e0634ULL,
0x00000000222f7faeULL, 0x0003e8000b901c46ULL, 0x0000000024307faeULL, 0x0003e8000b901c46ULL,
0x0000000026317faeULL, 0x0003e8000b901c46ULL, 0x0000000028327faeULL, 0x0003e8000b901c46ULL,
0x000000002a337faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000067805ULL, 0x002fc40000015200ULL, 0x01860400ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fc40007804805ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fcc0000015200ULL,
0x0000000806087210ULL, 0x000fca0007f1e1ffULL, 0x0000000109097824ULL, 0x000fe200000e0e07ULL,
0x003d09000800780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400800780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff037819ULL, 0x000fc80000011409ULL, 0x0000000803037211ULL, 0x000fca00078110ffULL,
0x000000ffff087224ULL, 0x000fca00000e0609ULL, 0x0000000203037819ULL, 0x000fc80000001208ULL,
0x000000030000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01860400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e640000000000ULL,
0x0000002002037824ULL, 0x002fca00078e0203ULL, 0x00000003ff047819ULL, 0x000fe40000011603ULL,
0x0000000f03037812ULL, 0x000fe400078ec0ffULL, 0x1ffffffe04047812ULL, 0x000fe400078ec0ffULL,
0x0000000103057810ULL, 0x040fe20007ffe0ffULL, 0x0000002003097824ULL, 0x040fe400078e00ffULL,
0x0000000103067824ULL, 0x040fe400078e0204ULL, 0x0000000104077824ULL, 0x040fe200078e0205ULL,
0x0000001004047810ULL, 0x000fe20007ffe0ffULL, 0x0000002003087824ULL, 0x000fe200078e00ffULL,
0x0000001f06067812ULL, 0x000fc400078ec0ffULL, 0x0000001f07077812ULL, 0x000fe200078ec0ffULL,
0x0000000103107824ULL, 0x000fe200078e0204ULL, 0x000001e008067812ULL, 0x000fe200078ee206ULL,
0x0000000105047824ULL, 0x000fe200078e0204ULL, 0x000001e009077812ULL, 0x000fe200078ee207ULL,
0x0000002003057824ULL, 0x040fe200078e00ffULL, 0x0000001f10107812ULL, 0x000fe200078ec0ffULL,
0x0000000006147984ULL, 0x000e62000000cc00ULL, 0x0000002003037824ULL, 0x000fe200078e00ffULL,
0x0000001f04047812ULL, 0x000fe400078ec0ffULL, 0x0000000007087984ULL, 0x000ea2000000cc00ULL,
0x000001e005107812ULL, 0x000fc400078ee210ULL, 0x000001e003047812ULL, 0x000fe200078ee204ULL,
0x000000ffff187224ULL, 0x002fe400078e0014ULL, 0x000000ffff197224ULL, 0x000fe400078e0016ULL,
0x000000ffff1b7224ULL, 0x004fe400078e000aULL, 0x000000ffff1a7224ULL, 0x000fe400078e0008ULL,
0x000000ffff0a7224ULL, 0x000fe400078e0009ULL, 0x000000ffff087224ULL, 0x000fe200078e0015ULL,
0x0000001806007388ULL, 0x000fe2000000cc00ULL, 0x000000ffff097224ULL, 0x000fca00078e0017ULL,
0x0000000807007388ULL, 0x000fe8000000cc00ULL, 0x0000000004087984ULL, 0x000e68000000cc00ULL,
0x0000000010147984ULL, 0x000ea2000000cc00ULL, 0x000000ffff1f7224ULL, 0x002fe400078e000aULL,
0x000000ffff1e7224ULL, 0x000fc400078e0008ULL, 0x000000ffff0a7224ULL, 0x000fe400078e0009ULL,
0x000000ffff1c7224ULL, 0x004fe400078e0014ULL, 0x000000ffff1d7224ULL, 0x000fe400078e0016ULL,
0x000000ffff087224ULL, 0x000fe400078e0015ULL, 0x000000ffff097224ULL, 0x000fe200078e0017ULL,
0x0000001c10007388ULL, 0x0003e8000000cc00ULL, 0x0000000804007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01860000ff087f8cULL, 0x002e62000c80043fULL,
0x000000ffff0a7224ULL, 0x000fc600078e00ffULL, 0x0000000000047805ULL, 0x000fc80000015200ULL,
0x01860400ff037984ULL, 0x000ea40000000800ULL, 0x8000000003ff7812ULL, 0x006fc40007804809ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x0000000604067210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09000600780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400600780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff037819ULL, 0x000fc80000011407ULL, 0x0000000603037211ULL, 0x000fca00078110ffULL,
0x000000ffff067224ULL, 0x000fca00000e0607ULL, 0x0000000203037819ULL, 0x000fc80000001206ULL,
0x000000030000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01860400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff0e00720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e620000000000ULL,
0x00006400123b7a24ULL, 0x000fe200078e02ffULL, 0x00018688023d7811ULL, 0x000fe200078e18ffULL,
0x3d8000003c3c7820ULL, 0x010fe20000410000ULL, 0xffffffff0e3e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x00018608023f7811ULL, 0x000fca00078e28ffULL,
0x0000010040427824ULL, 0x000fe200078e023aULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x000000420c00720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x01cfea0003800000ULL,
0x000000ffff437224ULL, 0x000fe200078e0041ULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x000000ffff447224ULL, 0x000fe200078e00ffULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fc4000001ff00ULL,
0x0000000144287810ULL, 0x020fe20007ffe0ffULL, 0x00001ae000007945ULL, 0x000fe20003800000ULL,
0x000000ffff457224ULL, 0x000fe200078e0044ULL, 0x0000000143417812ULL, 0x000fe200078e0cffULL,
0x00000039384c7224ULL, 0x010fe200078e02ffULL, 0x0000004028297211ULL, 0x040fe200078ff8ffULL,
0x000000ffff447224ULL, 0x000fe200078e0028ULL, 0x000000022800780cULL, 0x000fc40003f06070ULL,
0x00000001292a7810ULL, 0x040fe20007ffe0ffULL, 0x0000010029297824ULL, 0x000fe200078e023aULL,
0x0000000128667812ULL, 0x000fe400078ec0ffULL, 0x0000000e2a00720cULL, 0x000fe40003f26070ULL,
0x00000040294d7812ULL, 0x000fca00078ec0ffULL, 0x00000001004d7824ULL, 0x000fcc00078e024dULL,
0x00000da000009947ULL, 0x000fea0003800000ULL, 0x00000003ff587819ULL, 0x002fe20000011603ULL,
0x0000000866537824ULL, 0x000fe200078e00ffULL, 0x000000290c287217ULL, 0x000fe20007800000ULL,
0x0000000202547824ULL, 0x000fe200078e0241ULL, 0x00000004582a7810ULL, 0x040fe40007ffe0ffULL,
0x00000008582c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000128527824ULL, 0x000fe200078e0a29ULL,
0x0000000c58557810ULL, 0x000fe20007ffe0ffULL, 0x000000012a2b7824ULL, 0x000fe200078e0203ULL,
0x0000001058567810ULL, 0x000fe20007ffe0ffULL, 0x000000082a577824ULL, 0x000fe200078e00ffULL,
0x000000522c00720cULL, 0x080fe20003fa6070ULL, 0x000000012a297824ULL, 0x040fe200078e024dULL,
0x000000522a00720cULL, 0x000fe20003f86070ULL, 0x000000012c2d7824ULL, 0x040fe200078e0203ULL,
0xfffffff857577812ULL, 0x000fe200078ee22bULL, 0x000000082c597824ULL, 0x000fe200078e00ffULL,
0x000000294c2b7210ULL, 0x000fe20007f5e0ffULL, 0x0000000158287824ULL, 0x140fe200078e024dULL,
0x00000014585c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000155297824ULL, 0x000fe200078e024dULL,
0xfffffff859597812ULL, 0x000fe200078ee22dULL, 0x00000001555a7824ULL, 0x000fe200078e0203ULL,
0x000000284c2d7210ULL, 0x000fe20007f3e0ffULL, 0x000000012c287824ULL, 0x000fe200078e024dULL,
0x000000294c297210ULL, 0x040fe20007fde0ffULL, 0x000000ffff2c7224ULL, 0x000fe200010e06ffULL,
0x00005e002b4e7a11ULL, 0x040fe200078440ffULL, 0x000000ffff2e7224ULL, 0x000fe200008e06ffULL,
0x000000284c2a7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff287224ULL, 0x000fe200030e06ffULL,
0x00005f002b4f7a11ULL, 0x000fe200010f442cULL, 0x00000008555d7824ULL, 0x000fe200078e00ffULL,
0x00005e002d487a11ULL, 0x000fe200078240ffULL, 0x000000ffff2b7224ULL, 0x000fe200018e06ffULL,
0x00005e0029367a11ULL, 0x000fe200078440ffULL, 0x00000001565b7824ULL, 0x040fe200078e0203ULL,
0x00005f002d497a11ULL, 0x000fe200008f442eULL, 0x0000000856677824ULL, 0x040fe200078e00ffULL,
0x00005f0029377a11ULL, 0x000fe200010f4428ULL, 0x0000000156287824ULL, 0x100fe200078e024dULL,
0x00005e002a507a11ULL, 0x000fe200078240ffULL, 0x000000015c297824ULL, 0x000fe200078e024dULL,
0x00000018585e7810ULL, 0x000fc40007ffe0ffULL, 0x00005f002a517a11ULL, 0x000fe400008f442bULL,
0x000000284c2b7210ULL, 0x000fe20007f3e0ffULL, 0x000000015e2a7824ULL, 0x100fe200078e024dULL,
0x0000001c585f7810ULL, 0x000fe40007ffe0ffULL, 0x000000294c2c7210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff2f7224ULL, 0x000fe200008e06ffULL, 0x00005e002b4a7a11ULL, 0x000fe200078240ffULL,
0x000000015f297824ULL, 0x000fe200078e024dULL, 0x0000002a4c2d7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff2e7224ULL, 0x000fe200010e06ffULL, 0x00005f002b4b7a11ULL, 0x000fc400008f442fULL,
0x00005e002c287a11ULL, 0x000fe200078440ffULL, 0x000000ffff2f7224ULL, 0x000fe200018e06ffULL,
0x000000294c2b7210ULL, 0x000fe40007fde0ffULL, 0x00005f002c297a11ULL, 0x000fe400010f442eULL,
0x00005e002d2c7a11ULL, 0x000fe200078240ffULL, 0x000000ffff2e7224ULL, 0x000fe200030e06ffULL,
0x00005e002b2a7a11ULL, 0x000fe400078440ffULL, 0x0000002058607810ULL, 0x000fc40007ffe0ffULL,
0x0000002458617810ULL, 0x000fe40007ffe0ffULL, 0x00005f002d2d7a11ULL, 0x000fe400008f442fULL,
0x00005f002b2b7a11ULL, 0x000fe200010f442eULL, 0x00000001602e7824ULL, 0x100fe200078e024dULL,
0x0000002c58637810ULL, 0x040fe20007ffe0ffULL, 0x00000001612f7824ULL, 0x000fe200078e024dULL,
0x0000002858627810ULL, 0x000fe40007ffe0ffULL, 0x0000002e4c357210ULL, 0x000fc40007f3e0ffULL,
0x0000002f4c307210ULL, 0x000fe20007f5e0ffULL, 0x00000001632f7824ULL, 0x100fe200078e024dULL,
0x0000003058647810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff467224ULL, 0x000fe200008e06ffULL,
0x00005e0035347a11ULL, 0x040fe200078240ffULL, 0x00000001622e7824ULL, 0x000fe200078e024dULL,
0x0000002f4c2f7210ULL, 0x000fe20007fde0ffULL, 0x000000ffff337224ULL, 0x000fe200010e06ffULL,
0x00005e0030327a11ULL, 0x000fe400078440ffULL, 0x00005f0035357a11ULL, 0x000fe200008f4446ULL,
0x000000ffff467224ULL, 0x000fe200030e06ffULL, 0x0000002e4c317210ULL, 0x000fc40007f7e0ffULL,
0x00005f0030337a11ULL, 0x000fe400010f4433ULL, 0x00005e002f2e7a11ULL, 0x000fe200078440ffULL,
0x000000ffff477224ULL, 0x000fe200018e06ffULL, 0x00005e0031307a11ULL, 0x000fe400078240ffULL,
0x00005f002f2f7a11ULL, 0x000fe200010f4446ULL, 0x0000000158467824ULL, 0x000fe200078e0203ULL,
0x00005f0031317a11ULL, 0x000fe400008f4447ULL, 0x000000525500720cULL, 0x000fc40003f26070ULL,
0x0000000746477812ULL, 0x000fe200078ec0ffULL, 0x0000000164467824ULL, 0x000fe200078e024dULL,
0x000000525800720cULL, 0x000fe40003f66070ULL, 0x0ffffff847557812ULL, 0x100fe400078ef803ULL,
0x000000464c477210ULL, 0x000fe40007fde0ffULL, 0x000000525600720cULL, 0x000fe40003f46070ULL,
0xfffffff853537812ULL, 0x000fe200078ee203ULL, 0x000000ffff567224ULL, 0x000fe200030e06ffULL,
0x0000200054547811ULL, 0x000fc400078e68ffULL, 0x0000003458657810ULL, 0x000fe20007ffe0ffULL,
0x0000001053487825ULL, 0x000fe200078e0048ULL, 0x00005e0047467a11ULL, 0x000fe400078c40ffULL,
0xfffffff85d5a7812ULL, 0x000fe200078ee25aULL, 0x0000001055557824ULL, 0x000fe200078e0254ULL,
0x00005f0047477a11ULL, 0x000fe200030f4456ULL, 0x0000000165567824ULL, 0x000fe200078e024dULL,
0xfffffff8675b7812ULL, 0x000fe200078ee25bULL, 0x00000010534e7825ULL, 0x000fe200078e004eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000048557faeULL, 0x0003e2000d901c46ULL,
0x000000525c00720cULL, 0x000fc40003f66070ULL, 0x0000001053507825ULL, 0x000fc800078e0050ULL,
0x0000001053367825ULL, 0x000fc800078e0036ULL, 0x00000010534a7825ULL, 0x000fe200078e004aULL,
0x000000564c497210ULL, 0x002fc60007fde0ffULL, 0x0000001057557824ULL, 0x100fe400078e0254ULL,
0x000000ffff577224ULL, 0x000fe200030e06ffULL, 0x00005e0049487a11ULL, 0x000fe200078c40ffULL,
0x0000001059567824ULL, 0x000fe200078e0254ULL, 0x000000004e557faeULL, 0x0003e2000e101c46ULL,
0x000000015c5d7824ULL, 0x040fe200078e0203ULL, 0x00005f0049497a11ULL, 0x000fe200030f4457ULL,
0x000000085c5c7824ULL, 0x000fe200078e00ffULL, 0x0000003858577810ULL, 0x040fe20007ffe0ffULL,
0x0000000050567faeULL, 0x0005e2000e901c46ULL, 0x0000003c58587810ULL, 0x000fe20007ffe0ffULL,
0x0000001053287825ULL, 0x000fe200078e0028ULL, 0x000000525e00720cULL, 0x000fc40003fa6070ULL,
0xfffffff85c5d7812ULL, 0x000fe200078ee25dULL, 0x00000010532c7825ULL, 0x000fc800078e002cULL,
0x00000001574e7824ULL, 0x102fe400078e024dULL, 0x00000001584f7824ULL, 0x000fe400078e024dULL,
0x000000105a4d7824ULL, 0x100fe200078e0254ULL, 0x0000004e4c517210ULL, 0x004fe20007f9e0ffULL,
0x000000105b507824ULL, 0x000fe400078e0254ULL, 0x000000015e567824ULL, 0x000fe200078e0203ULL,
0x00005e00514e7a11ULL, 0x000fe200078c40ffULL, 0x000000ffff557224ULL, 0x000fe200020e06ffULL,
0x0000004f4c4c7210ULL, 0x000fe20007f9e0ffULL, 0x00000000364d7faeULL, 0x0003e2000c901c46ULL,
0x000000085e5e7824ULL, 0x000fe200078e00ffULL, 0x000000526000720cULL, 0x000fe20003f26070ULL,
0x00000010532a7825ULL, 0x000fe200078e002aULL, 0x000000004a507faeULL, 0x0005e2000d101c46ULL,
0x00005f00514f7a11ULL, 0x000fc400030f4455ULL, 0x000000525f00720cULL, 0x000fe20003f46070ULL,
0x0000000161517824ULL, 0x000fe200078e0203ULL, 0xfffffff85e567812ULL, 0x000fe200078ee256ULL,
0x0000001053347825ULL, 0x000fe200078e0034ULL, 0x00005e004c367a11ULL, 0x002fc600078c40ffULL,
0x000000085f4d7824ULL, 0x040fe400078e00ffULL, 0x000000015f4a7824ULL, 0x104fe400078e0203ULL,
0x00000001604b7824ULL, 0x040fe400078e0203ULL, 0x0000000860507824ULL, 0x000fe200078e00ffULL,
0xfffffff84d4d7812ULL, 0x000fe200078ee24aULL, 0x000000ffff377224ULL, 0x000fe200020e06ffULL,
0x000000526100720cULL, 0x0c0fe20003f86070ULL, 0x0000000861617824ULL, 0x000fe200078e00ffULL,
0xfffffff850507812ULL, 0x000fe200078ee24bULL, 0x000000105d4a7824ULL, 0x100fe200078e0254ULL,
0x00005f004c377a11ULL, 0x000fe200030f4437ULL, 0x00000010564b7824ULL, 0x100fe200078e0254ULL,
0xfffffff861517812ULL, 0x000fe200078ee251ULL, 0x000000104d4c7824ULL, 0x100fe200078e0254ULL,
0x00000000284a7faeULL, 0x0003e2000d901c46ULL, 0x00000010504d7824ULL, 0x100fe200078e0254ULL,
0x000000526400720cULL, 0x080fe20003f66070ULL, 0x0000001051507824ULL, 0x000fe200078e0254ULL,
0x000000002c4b7faeULL, 0x0005e2000e901c46ULL, 0x0000001053327825ULL, 0x000fe200078e0032ULL,
0x000000525700720cULL, 0x000fc40003fa6070ULL, 0x000000002a4c7faeULL, 0x0007e2000d101c46ULL,
0x000000526300720cULL, 0x080fe20003f46070ULL, 0x0000001053307825ULL, 0x000fe200078e0030ULL,
0x000000525800720cULL, 0x080fe20003fc6070ULL, 0x00000000344d7faeULL, 0x0009e2000c901c46ULL,
0x000000526200720cULL, 0x0c0fe20003f26070ULL, 0x0000000162287824ULL, 0x142fe400078e0203ULL,
0x0000000862627824ULL, 0x000fe200078e00ffULL, 0x0000000032507faeULL, 0x0003e2000e101c46ULL,
0x0000000163297824ULL, 0x100fe200078e0203ULL, 0x000000526500720cULL, 0x000fe20003f86070ULL,
0x0000000863637824ULL, 0x000fe200078e00ffULL, 0xfffffff862287812ULL, 0x000fe200078ee228ULL,
0x00000001642a7824ULL, 0x008fc400078e0203ULL, 0x0000000864647824ULL, 0x000fe200078e00ffULL,
0xfffffff863297812ULL, 0x000fe200078ee229ULL, 0x00000001652b7824ULL, 0x140fe400078e0203ULL,
0x0000000865657824ULL, 0x000fe200078e00ffULL, 0xfffffff8642a7812ULL, 0x000fe200078ee22aULL,
0x00000001572c7824ULL, 0x044fe400078e0203ULL, 0x0000000857347824ULL, 0x010fe200078e00ffULL,
0xfffffff8652b7812ULL, 0x000fe200078ee22bULL, 0x00000001582d7824ULL, 0x000fc400078e0203ULL,
0x0000000858357824ULL, 0x000fe200078e00ffULL, 0xfffffff834347812ULL, 0x000fe200078ee22cULL,
0x00000010282c7824ULL, 0x000fe400078e0254ULL, 0x00000010532e7825ULL, 0x000fe200078e002eULL,
0xfffffff835357812ULL, 0x000fe400078ee22dULL, 0x00000000302c7faeULL, 0x0005e2000c901c46ULL,
0x00000010292d7824ULL, 0x100fe400078e0254ULL, 0x000000102a327824ULL, 0x002fc400078e0254ULL,
0x0000001053467825ULL, 0x000fe200078e0046ULL, 0x000000002e2d7faeULL, 0x0005e6000d101c46ULL,
0x000000102b337824ULL, 0x000fe200078e0254ULL, 0x0000000046327faeULL, 0x0005e2000d901c46ULL,
0x0000001053487825ULL, 0x000fc800078e0048ULL, 0x0000001034347824ULL, 0x000fe200078e0254ULL,
0x0000000048337faeULL, 0x0005e2000e101c46ULL, 0x0000001053287825ULL, 0x000fc800078e004eULL,
0x0000001035547824ULL, 0x000fe200078e0254ULL, 0x0000000028347faeULL, 0x0005e2000e901c46ULL,
0x00000010532a7825ULL, 0x000fca00078e0036ULL, 0x000000002a547faeULL, 0x0005e2000f101c46ULL,
0x00000c6000007947ULL, 0x000fea0003800000ULL, 0x0000000403297811ULL, 0x042fe200078fe8ffULL,
0x00000008666b7824ULL, 0x000fe200078e00ffULL, 0x0000000c032f7811ULL, 0x040fe400078fe8ffULL,
0x0000001003307811ULL, 0x000fe200078fe8ffULL, 0x0000000129287824ULL, 0x100fe200078e0203ULL,
0x0000001803467811ULL, 0x000fe200078fe8ffULL, 0x0000000829577824ULL, 0x000fe200078e00ffULL,
0x0000001c03477811ULL, 0x000fe200078fe8ffULL, 0x000000012f2b7824ULL, 0x100fe200078e0203ULL,
0x0000002403497811ULL, 0x000fe200078fe8ffULL, 0x000000082f597824ULL, 0x000fe200078e00ffULL,
0xfffffff857577812ULL, 0x000fe200078ee228ULL, 0x0000000130287824ULL, 0x040fe200078e0203ULL,
0x00000008032e7811ULL, 0x000fe200078fe8ffULL, 0x00000008305a7824ULL, 0x000fe200078e00ffULL,
0xfffffff859597812ULL, 0x000fe200078ee22bULL, 0x00000001462b7824ULL, 0x140fe200078e0203ULL,
0x0000002803507811ULL, 0x000fe200078fe8ffULL, 0x00000008465c7824ULL, 0x000fe200078e00ffULL,
0xfffffff85a5a7812ULL, 0x000fe200078ee228ULL, 0x0000000147287824ULL, 0x000fe200078e0203ULL,
0x0000003003527811ULL, 0x000fe200078fe8ffULL, 0x00000008475d7824ULL, 0x000fe200078e00ffULL,
0xfffffff85c5c7812ULL, 0x000fe200078ee22bULL, 0x00000001492b7824ULL, 0x100fe200078e0203ULL,
0x0000001403317811ULL, 0x000fe200078fe8ffULL, 0x00000008495f7824ULL, 0x000fe200078e00ffULL,
0xfffffff85d5d7812ULL, 0x000fe200078ee228ULL, 0x000000012e2a7824ULL, 0x040fe200078e0203ULL,
0x0000002003487811ULL, 0x000fe200078fe8ffULL, 0x000000082e587824ULL, 0x000fe200078e00ffULL,
0xfffffff85f5f7812ULL, 0x000fe200078ee22bULL, 0x0000000150287824ULL, 0x140fe200078e0203ULL,
0x0000002c03517811ULL, 0x040fe200078fe8ffULL, 0x0000000850607824ULL, 0x000fe200078e00ffULL,
0xfffffff858587812ULL, 0x000fe200078ee22aULL, 0x00000001522b7824ULL, 0x140fe200078e0203ULL,
0x0000003803547811ULL, 0x000fe200078fe8ffULL, 0x0000000852627824ULL, 0x000fe200078e00ffULL,
0xfffffff860607812ULL, 0x000fe200078ee228ULL, 0x00000001312a7824ULL, 0x000fe200078e0203ULL,
0x0000004d03287211ULL, 0x000fe200078fe8ffULL, 0x00000008315b7824ULL, 0x000fe200078e00ffULL,
0xfffffff862627812ULL, 0x000fe200078ee22bULL, 0x00000008485e7824ULL, 0x000fe200078e00ffULL,
0x000000284c2b7210ULL, 0x000fe20007f3e0ffULL, 0x0000000129287824ULL, 0x000fe200078e024dULL,
0xfffffff85b5b7812ULL, 0x000fe200078ee22aULL, 0x00000001482a7824ULL, 0x100fe200078e0203ULL,
0x0000003403537811ULL, 0x000fe200078fe8ffULL, 0x0000000851617824ULL, 0x040fe200078e00ffULL,
0x000000284c297210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff2d7224ULL, 0x000fe200008e06ffULL,
0xfffffff85e5e7812ULL, 0x000fe200078ee22aULL, 0x00000001512a7824ULL, 0x100fe200078e0203ULL,
0x0000003c03657811ULL, 0x000fe200078fe8ffULL, 0x000000ffff2c7224ULL, 0x000fe200010e06ffULL,
0x00005e0029287a11ULL, 0x000fe200078440ffULL, 0x0000000154337824ULL, 0x140fe200078e0203ULL,
0xfffffff861617812ULL, 0x000fe200078ee22aULL, 0x0000000854647824ULL, 0x000fe200078e00ffULL,
0x00005e002b2a7a11ULL, 0x000fe200078240ffULL, 0x0000000153327824ULL, 0x000fe200078e0203ULL,
0x00005f0029297a11ULL, 0x000fe200010f442cULL, 0x000000012e2c7824ULL, 0x000fe200078e024dULL,
0x00005f002b2b7a11ULL, 0x000fe200008f442dULL, 0x00000001302e7824ULL, 0x000fe200078e024dULL,
0xfffffff864647812ULL, 0x000fe200078ee233ULL, 0x000000012f2d7824ULL, 0x100fe200078e024dULL,
0x0000002c4c337210ULL, 0x040fe20007f5e0ffULL, 0x00000001312f7824ULL, 0x000fe200078e024dULL,
0x0000002e4c357210ULL, 0x040fe20007f9e0ffULL, 0x0000000853637824ULL, 0x000fe200078e00ffULL,
0x0000002d4c317210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff377224ULL, 0x000fe200010e06ffULL,
0x0000002f4c2d7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff2f7224ULL, 0x000fe200020e06ffULL,
0xfffffff863637812ULL, 0x000fe200078ee232ULL, 0x000000ffff367224ULL, 0x000fe200018e06ffULL,
0x00005e00352e7a11ULL, 0x000fe200078840ffULL, 0x000000ffff347224ULL, 0x000fe200008e06ffULL,
0x00005e0033327a11ULL, 0x000fc400078440ffULL, 0x00005e0031307a11ULL, 0x000fe400078640ffULL,
0x00005e002d2c7a11ULL, 0x000fe400078240ffULL, 0x00005f00352f7a11ULL, 0x000fe200020f442fULL,
0x0000000147357824ULL, 0x000fe200078e024dULL, 0x00005f0033337a11ULL, 0x000fe200010f4437ULL,
0x0000000149377824ULL, 0x100fe200078e024dULL, 0x00005f0031317a11ULL, 0x000fe200018f4436ULL,
0x0000000148367824ULL, 0x100fe200078e024dULL, 0x00005f002d2d7a11ULL, 0x000fe200008f4434ULL,
0x0000000146347824ULL, 0x000fe200078e024dULL, 0x000000354c477210ULL, 0x000fc40007f7e0ffULL,
0x000000374c357210ULL, 0x040fe40007f3e0ffULL, 0x000000344c497210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff4e7224ULL, 0x000fe200018e06ffULL, 0x000000364c4b7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff4a7224ULL, 0x000fe200008e06ffULL, 0x00005e0035347a11ULL, 0x000fe200078240ffULL,
0x000000ffff4f7224ULL, 0x000fe200010e06ffULL, 0x00005e0049487a11ULL, 0x000fe200078440ffULL,
0x000000ffff377224ULL, 0x000fe200020e06ffULL, 0x00005e0047467a11ULL, 0x000fc400078640ffULL,
0x00005e004b367a11ULL, 0x000fe400078840ffULL, 0x00005f0035357a11ULL, 0x000fe200008f444aULL,
0x00000001504a7824ULL, 0x000fe200078e024dULL, 0x00005f0049497a11ULL, 0x000fe200010f444fULL,
0x00000001534f7824ULL, 0x100fe200078e024dULL, 0x00005f0047477a11ULL, 0x000fe200018f444eULL,
0x00000001524e7824ULL, 0x000fe200078e024dULL, 0x00005f004b377a11ULL, 0x000fe200020f4437ULL,
0x00000001514b7824ULL, 0x100fe200078e024dULL, 0x0000000303567211ULL, 0x000fe200078fe8ffULL,
0x0000000154507824ULL, 0x100fe200078e024dULL, 0x0000004a4c547210ULL, 0x040fe20007fde0ffULL,
0x00000001654d7824ULL, 0x000fe200078e024dULL, 0x0000004b4c527210ULL, 0x000fc40007fbe0ffULL,
0x0000004e4c6a7210ULL, 0x040fe20007f9e0ffULL, 0x00000008654e7824ULL, 0x040fe200078e00ffULL,
0x0000004f4c517210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff4b7224ULL, 0x000fe200030e06ffULL,
0x000000504c537210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff4f7224ULL, 0x000fe200020e06ffULL,
0x0000004d4c557210ULL, 0x000fe20007f7e0ffULL, 0x00000002024c7824ULL, 0x000fe200078e0241ULL,
0x0000000756567812ULL, 0x000fe200078ec0ffULL, 0x00000001654d7824ULL, 0x100fe200078e0203ULL,
0xfffffff86b6b7812ULL, 0x100fe200078ee203ULL, 0x000000ffff697224ULL, 0x000fe200008e06ffULL,
0x000020004c657811ULL, 0x000fe200078e68ffULL, 0x000000ffff687224ULL, 0x000fe200010e06ffULL,
0x0ffffff856567812ULL, 0x000fe200078ef803ULL, 0x000000106b2a7825ULL, 0x000fe200078e002aULL,
0xfffffff84e4e7812ULL, 0x000fc400078ee24dULL, 0x00005e00544a7a11ULL, 0x000fe200078c40ffULL,
0x000000ffff4d7224ULL, 0x000fe200028e06ffULL, 0x00005e00524c7a11ULL, 0x000fe200078a40ffULL,
0x0000001056567824ULL, 0x100fe200078e0265ULL, 0x00005e0051507a11ULL, 0x000fe200078240ffULL,
0x0000001057577824ULL, 0x000fe200078e0265ULL, 0x00005f00524d7a11ULL, 0x000fe200028f444dULL,
0x0000001058587824ULL, 0x000fe200078e0265ULL, 0x00005f00544b7a11ULL, 0x000fe200030f444bULL,
0x0000001059597824ULL, 0x100fe200078e0265ULL, 0x00005e0053527a11ULL, 0x000fe200078440ffULL,
0x000000105a5a7824ULL, 0x100fe200078e0265ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a567faeULL, 0x0003e2000b901c46ULL, 0x000000105b5b7824ULL, 0x000fe200078e0265ULL,
0x00005f0051517a11ULL, 0x000fe200008f4469ULL, 0x000000105c5c7824ULL, 0x100fe200078e0265ULL,
0x00005f0053537a11ULL, 0x000fe200010f4468ULL, 0x000000105d5d7824ULL, 0x000fc400078e0265ULL,
0x000000105e5e7824ULL, 0x100fe400078e0265ULL, 0x000000105f5f7824ULL, 0x100fe400078e0265ULL,
0x0000001060607824ULL, 0x100fe400078e0265ULL, 0x0000001061617824ULL, 0x100fe400078e0265ULL,
0x0000001062627824ULL, 0x100fe400078e0265ULL, 0x0000001063637824ULL, 0x000fc400078e0265ULL,
0x0000001064647824ULL, 0x000fe400078e0265ULL, 0x000000106b287825ULL, 0x000fc800078e0028ULL,
0x000000104e657824ULL, 0x000fe200078e0265ULL, 0x00005e006a4e7a11ULL, 0x040fe200078840ffULL,
0x000000106b327825ULL, 0x040fe200078e0032ULL, 0x0000000028577faeULL, 0x0005e4000b901c46ULL,
0x00005f006a4f7a11ULL, 0x000fe200020f444fULL, 0x000000106b307825ULL, 0x040fe200078e0030ULL,
0x0000000032587faeULL, 0x0005e6000b901c46ULL, 0x000000106b2e7825ULL, 0x000fe200078e002eULL,
0x0000000030597faeULL, 0x0005e6000b901c46ULL, 0x000000ffff677224ULL, 0x000fe200018e06ffULL,
0x00005e0055547a11ULL, 0x000fe200078640ffULL, 0x000000106b2c7825ULL, 0x000fe200078e002cULL,
0x000000002e5a7faeULL, 0x0005e4000b901c46ULL, 0x00005f0055557a11ULL, 0x000fe200018f4467ULL,
0x000000106b487825ULL, 0x040fe200078e0048ULL, 0x000000002c5b7faeULL, 0x0005e6000b901c46ULL,
0x000000106b467825ULL, 0x040fe200078e0046ULL, 0x00000000485c7faeULL, 0x0005e6000b901c46ULL,
0x000000106b367825ULL, 0x040fe200078e0036ULL, 0x00000000465d7faeULL, 0x0005e6000b901c46ULL,
0x000000106b347825ULL, 0x040fe200078e0034ULL, 0x00000000365e7faeULL, 0x0005e6000b901c46ULL,
0x000000106b2a7825ULL, 0x042fe200078e004aULL, 0x00000000345f7faeULL, 0x0005e6000b901c46ULL,
0x000000106b4a7825ULL, 0x040fe200078e004cULL, 0x000000002a607faeULL, 0x0005e6000b901c46ULL,
0x000000106b4c7825ULL, 0x040fe200078e004eULL, 0x000000004a617faeULL, 0x0005e6000b901c46ULL,
0x000000106b4e7825ULL, 0x040fe200078e0050ULL, 0x000000004c627faeULL, 0x0005e6000b901c46ULL,
0x000000106b507825ULL, 0x040fe200078e0052ULL, 0x000000004e637faeULL, 0x0005e6000b901c46ULL,
0x000000106b527825ULL, 0x000fe200078e0054ULL, 0x0000000050647faeULL, 0x0005e8000b901c46ULL,
0x0000000052657faeULL, 0x0005e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff6600720cULL, 0x000fe20003f25270ULL, 0x000000a000007945ULL, 0x000fd80003800000ULL,
0x0000008000009947ULL, 0x000fea0003800000ULL, 0x000000020f0f7810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff387424ULL, 0x000fc600078e00ffULL, 0x0000000d0f00720cULL, 0x000fda0003f26070ULL,
0x0000004000001947ULL, 0x000fea0003800000ULL, 0x000000023b287824ULL, 0x004fe400078e020fULL,
0x00000004ff297424ULL, 0x000fc800078e00ffULL, 0x0000600028287625ULL, 0x000fca00078e0029ULL,
0x0000000628387981ULL, 0x000324000c1e1900ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000ffff467224ULL, 0x004fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xfffffff803287812ULL, 0x062fe200078ec0ffULL,
0x00000002022c7824ULL, 0x000fe200078e0243ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000001462f7810ULL, 0x000fe40007ffe0ffULL, 0x0000000728287812ULL, 0x000fe400078ef803ULL,
0x000020002c2c7811ULL, 0x000fe400078e68ffULL, 0x00000020032d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000128297824ULL, 0x000fc400078e0246ULL, 0x00000008282a7824ULL, 0x040fe200078e00ffULL,
0xfffffff82d2d7812ULL, 0x000fe200078ec0ffULL, 0x0000000128287824ULL, 0x000fc600078e022fULL,
0xfffffff82a297812ULL, 0x040fe400078ee229ULL, 0xfffffff82a287812ULL, 0x000fe400078ee228ULL,
0x000000072d2d7812ULL, 0x000fe200078ef803ULL, 0x0000001029297824ULL, 0x100fe400078e022cULL,
0x0000001028287824ULL, 0x000fe400078e022cULL, 0x000000012d2e7824ULL, 0x040fe200078e0246ULL,
0x000000002934783bULL, 0x000e620000000200ULL, 0x000000082d307824ULL, 0x000fc400078e00ffULL,
0x000000012d2f7824ULL, 0x040fe200078e022fULL, 0x000000002828783bULL, 0x000ea20000000200ULL,
0x000000082d2d7824ULL, 0x000fe200078e00ffULL, 0xfffffff8302e7812ULL, 0x000fc800078ee22eULL,
0xfffffff82d2f7812ULL, 0x000fe200078ee22fULL, 0x000000102e2e7824ULL, 0x000fc800078e022cULL,
0x000000102f2f7824ULL, 0x000fe200078e022cULL, 0x000000002e30783bULL, 0x000eea0000000200ULL,
0x000000002f2c783bULL, 0x000ee20000000200ULL, 0x0000003400b67306ULL, 0x002fe20000009400ULL,
0x00000018ff937819ULL, 0x000fe20000011434ULL, 0x0001000034577824ULL, 0x000fe200078e00ffULL,
0x00000018ff7f7819ULL, 0x000fc40000011437ULL, 0x00000018ff4d7819ULL, 0x004fe40000011428ULL,
0x00000018ff577819ULL, 0x000fe20000011457ULL, 0x0000003400b97306ULL, 0x000e620000005400ULL,
0x00000018ff8d7819ULL, 0x000fe40000011435ULL, 0x00000018ff867819ULL, 0x000fe40000011436ULL,
0x00000018ff4a7819ULL, 0x000fe40000011429ULL, 0x00000018ff4b7819ULL, 0x000fe2000001142bULL,
0x0000003400957306ULL, 0x000462000000d400ULL, 0x00000018ff4c7819ULL, 0x000fc4000001142aULL,
0x00000018ff7c7819ULL, 0x008fe40000011430ULL, 0x00000018ff6e7819ULL, 0x000fe40000011432ULL,
0x00000018ff6f7819ULL, 0x000fe20000011431ULL, 0x00000028009e7306ULL, 0x000fe20000009400ULL,
0x0000010034347824ULL, 0x004fe200078e00ffULL, 0x000000b9b600720bULL, 0x002fe20003f3d000ULL,
0x0000010033b67824ULL, 0x000fe200078e00ffULL, 0x00000018ff657819ULL, 0x000fe40000011433ULL,
0x00000018ff347819ULL, 0x000fc40000011434ULL, 0x00000028009d7306ULL, 0x000fe20000005400ULL,
0x00000018ffb67819ULL, 0x000fe400000114b6ULL, 0x00000018ff587819ULL, 0x000fe4000001142cULL,
0x00000018ff5b7819ULL, 0x000fe4000001142dULL, 0x0000000195951812ULL, 0x000fe200078efcffULL,
0x0000003400be7306ULL, 0x000fe20000209400ULL, 0x00000018ff5e7819ULL, 0x000fe4000001142eULL,
0x00000018ff617819ULL, 0x000fca000001142fULL, 0x0000003400bf7306ULL, 0x000e700000205400ULL,
0x0000003400a57306ULL, 0x0004f0000020d400ULL, 0x0000002800567306ULL, 0x000fe2000000d400ULL,
0x0001000036347824ULL, 0x004fe200078e00ffULL, 0x000000bfbe00720bULL, 0x002fc80003fdd000ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000003700a37306ULL, 0x000fee0000009400ULL,
0x00000001a5a56812ULL, 0x008fe200078efcffULL, 0x0000003400cc7306ULL, 0x000ff00000209400ULL,
0x0000003400ce7306ULL, 0x000ff00000205400ULL, 0x00000034008c7306ULL, 0x0003f0000020d400ULL,
0x0000003700a47306ULL, 0x000fe20000005400ULL, 0x0001000037347824ULL, 0x002fca00078e00ffULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000003700817306ULL, 0x0003f0000000d400ULL,
0x0000003400cf7306ULL, 0x000fe20000209400ULL, 0x0000010037377824ULL, 0x002fca00078e00ffULL,
0x00000018ff377819ULL, 0x000fe40000011437ULL, 0x0000003400cd7306ULL, 0x000ff00000205400ULL,
0x0000003400857306ULL, 0x0003f0000020d400ULL, 0x0000003500b27306ULL, 0x000fe20000009400ULL,
0x0001000028347824ULL, 0x002fc400078e00ffULL, 0x0000010028287824ULL, 0x000fc600078e00ffULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x00000018ff287819ULL, 0x000fe20000011428ULL,
0x0000003500af7306ULL, 0x000e700000005400ULL, 0x0000003400c47306ULL, 0x000ff00000209400ULL,
0x0000003400c57306ULL, 0x000fe20000205400ULL, 0x000000afb200720bULL, 0x002fce0003f9d000ULL,
0x00000034006a7306ULL, 0x000ff0000020d400ULL, 0x0000002800c37306ULL, 0x000ff00000209400ULL,
0x0000002800c27306ULL, 0x000ff00000205400ULL, 0x0000002800347306ULL, 0x0003f0000020d400ULL,
0x0000005700bb7306ULL, 0x000fe20000209400ULL, 0x000100002a287824ULL, 0x002fca00078e00ffULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x0000005700bc7306ULL, 0x000e700000205400ULL,
0x0000005700a27306ULL, 0x0005f0000020d400ULL, 0x0000003500917306ULL, 0x0006e2000000d400ULL,
0x0001000035577824ULL, 0x004fe200078e00ffULL, 0x000000bcbb00720bULL, 0x002fc80003f5d000ULL,
0x00000018ff577819ULL, 0x000fe40000011457ULL, 0x0000003700d77306ULL, 0x000fe20000209400ULL,
0x0000010035357824ULL, 0x008fca00078e00ffULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x0000003700d67306ULL, 0x000fe20000205400ULL, 0x0000000191914812ULL, 0x000fe400078efcffULL,
0x00000001a2a22812ULL, 0x000fca00078efcffULL, 0x0000003700847306ULL, 0x000ff0000020d400ULL,
0x0000002800897306ULL, 0x000ff00000209400ULL, 0x0000002800887306ULL, 0x000ff00000205400ULL,
0x0000002800377306ULL, 0x0003f0000020d400ULL, 0x0000005700c87306ULL, 0x000fe20000209400ULL,
0x000100002b287824ULL, 0x002fca00078e00ffULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x0000005700c97306ULL, 0x000e700000205400ULL, 0x0000008600aa7306ULL, 0x000ff00000209400ULL,
0x0000008600a97306ULL, 0x000ea20000205400ULL, 0x000000c9c800720bULL, 0x002fce0003f3d000ULL,
0x0000003600b37306ULL, 0x000ff00000009400ULL, 0x0000003600b07306ULL, 0x000e620000005400ULL,
0x000000a9aa00720bULL, 0x004fce0003f9d000ULL, 0x00000036008a7306ULL, 0x0004f0000000d400ULL,
0x0000003500cb7306ULL, 0x000fe20000209400ULL, 0x0000010036367824ULL, 0x004fe200078e00ffULL,
0x000000b0b300720bULL, 0x002fe20003f7d000ULL, 0x000100002cb37824ULL, 0x000fc600078e00ffULL,
0x00000018ff367819ULL, 0x000fe40000011436ULL, 0x0000003500ca7306ULL, 0x000e620000205400ULL,
0x00000018ffb37819ULL, 0x000fcc00000114b3ULL, 0x000000018a8a3812ULL, 0x008fe200078efcffULL,
0x0000003500947306ULL, 0x0004f0000020d400ULL, 0x0000002900967306ULL, 0x000fe20000009400ULL,
0x0001000029357824ULL, 0x004fe200078e00ffULL, 0x000000cacb00720bULL, 0x002fc80003fdd000ULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x0000002900977306ULL, 0x000fee0000005400ULL,
0x0000000194946812ULL, 0x008fe200078efcffULL, 0x0000002900537306ULL, 0x0003e2000000d400ULL,
0x000000cdcf00720bULL, 0x000fce0003fdd000ULL, 0x00000028006b7306ULL, 0x000fe20000209400ULL,
0x0000010029297824ULL, 0x002fca00078e00ffULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x00000028006c7306ULL, 0x000fe20000205400ULL, 0x0000000185856812ULL, 0x000fce00078efcffULL,
0x0000002800667306ULL, 0x0003f0000020d400ULL, 0x0000002b009a7306ULL, 0x000fe20000009400ULL,
0x0001000030287824ULL, 0x002fca00078e00ffULL, 0x00000018ff7e7819ULL, 0x000fe40000011428ULL,
0x0000002b009b7306ULL, 0x000ff00000005400ULL, 0x0000002b00507306ULL, 0x0003f0000000d400ULL,
0x0000005700a87306ULL, 0x000ea2000020d400ULL, 0x000001002b2b7824ULL, 0x002fca00078e00ffULL,
0x00000018ff2b7819ULL, 0x000fe4000001142bULL, 0x0000003600d17306ULL, 0x000ff00000209400ULL,
0x0000003600d07306ULL, 0x000e620000205400ULL, 0x00000001a8a81812ULL, 0x004fce00078efcffULL,
0x00000036008b7306ULL, 0x000eb0000020d400ULL, 0x0000008600867306ULL, 0x000ee2000020d400ULL,
0x000000d0d100720bULL, 0x002fce0003f3d000ULL, 0x00000029008f7306ULL, 0x000fec0000209400ULL,
0x000000018b8b1812ULL, 0x004fe400078efcffULL, 0x00000029008e7306ULL, 0x000fe20000205400ULL,
0x0000000186864812ULL, 0x008fce00078efcffULL, 0x0000002900367306ULL, 0x000ff0000020d400ULL,
0x0000008d00b87306ULL, 0x000ff00000209400ULL, 0x0000008d00b47306ULL, 0x000e700000205400ULL,
0x0000007e00287306ULL, 0x000ff00000209400ULL, 0x0000007e00297306ULL, 0x000ea20000205400ULL,
0x000000b4b800720bULL, 0x002fce0003f5d000ULL, 0x0000002b00677306ULL, 0x000ff00000209400ULL,
0x0000002b00687306ULL, 0x000fe20000205400ULL, 0x000000292800720bULL, 0x004fe20003f9d000ULL,
0x000100002d297824ULL, 0x000fcc00078e00ffULL, 0x0000002b00697306ULL, 0x0003f0000020d400ULL,
0x0000002a00987306ULL, 0x000fe20000009400ULL, 0x00010000312b7824ULL, 0x002fca00078e00ffULL,
0x00000018ff7d7819ULL, 0x000fe4000001142bULL, 0x0000002a00997306ULL, 0x000ff00000005400ULL,
0x0000002a00517306ULL, 0x0003f0000000d400ULL, 0x0000009300877306ULL, 0x000fe20000209400ULL,
0x000001002a2a7824ULL, 0x002fca00078e00ffULL, 0x00000018ff2a7819ULL, 0x000fe4000001142aULL,
0x0000009300ae7306ULL, 0x000e700000205400ULL, 0x0000003000b57306ULL, 0x000ff00000009400ULL,
0x0000003000b77306ULL, 0x000ea20000005400ULL, 0x000000ae8700720bULL, 0x002fe20003fbd000ULL,
0x0000000845ae7824ULL, 0x000fe200078e0246ULL, 0x0000000703877812ULL, 0x000fc400078ec0ffULL,
0x0000000246467810ULL, 0x000fe20007ffe0ffULL, 0x00000002aeae7824ULL, 0x000fe200078e00ffULL,
0x0000000887b47812ULL, 0x000fe200078ef803ULL, 0x0000003000757306ULL, 0x0002e6000000d400ULL,
0x000000ae03af7211ULL, 0x000fe400078fe0ffULL, 0x00000002aeae7810ULL, 0x000fc60007ffe0ffULL,
0x0000008d008d7306ULL, 0x000ee2000020d400ULL, 0x0000010030307824ULL, 0x002fe200078e00ffULL,
0x000000b7b500720bULL, 0x004fe20003f3d000ULL, 0x00000001b4af7824ULL, 0x040fe200078e02afULL,
0x000000ae03ae7211ULL, 0x000fe400078fe0ffULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x0000007e007e7306ULL, 0x000e62000020d400ULL, 0x00000001b4ae7824ULL, 0x000fcc00078e02aeULL,
0x0000000175751812ULL, 0x008fe200078efcffULL, 0x0000007f00a77306ULL, 0x000fe20000209400ULL,
0x000000018d8d2812ULL, 0x000fe400078efcffULL, 0x000000a4a300720bULL, 0x000fca0003f5d000ULL,
0x0000007f00a67306ULL, 0x000ea20000205400ULL, 0x000000017e7e4812ULL, 0x002fc800078efcffULL,
0x000000757e7e723eULL, 0x000fc600000010ffULL, 0x0000007d002b7306ULL, 0x000fe20000209400ULL,
0x0000000181812812ULL, 0x000fce00078efcffULL, 0x0000007d00d87306ULL, 0x000e620000205400ULL,
0x000000a6a700720bULL, 0x004fce0003f7d000ULL, 0x0000002a00837306ULL, 0x000ff00000209400ULL,
0x0000002a00827306ULL, 0x000fe20000205400ULL, 0x000000d82b00720bULL, 0x002fce0003f9d000ULL,
0x0000002a00577306ULL, 0x000ff0000020d400ULL, 0x0000003000d97306ULL, 0x000ff00000209400ULL,
0x00000030002a7306ULL, 0x000e700000205400ULL, 0x0000003000807306ULL, 0x0004f0000020d400ULL,
0x0000003200ac7306ULL, 0x000fe20000009400ULL, 0x0001000032307824ULL, 0x004fe200078e00ffULL,
0x0000002ad900720bULL, 0x002fc80003fdd000ULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x0000003200ab7306ULL, 0x000fee0000005400ULL, 0x0000000180806812ULL, 0x008fe200078efcffULL,
0x00000032006d7306ULL, 0x0003f0000000d400ULL, 0x0000006f00d37306ULL, 0x000fe20000209400ULL,
0x0000010032327824ULL, 0x002fca00078e00ffULL, 0x00000018ff327819ULL, 0x000fe40000011432ULL,
0x0000006f00d47306ULL, 0x000e700000205400ULL, 0x0000009300937306ULL, 0x000eb0000020d400ULL,
0x0000007f007f7306ULL, 0x000ee2000020d400ULL, 0x000000d4d300720bULL, 0x002fce0003f3d000ULL,
0x0000007d007d7306ULL, 0x000e62000020d400ULL, 0x0000000193935812ULL, 0x004fe400078efcffULL,
0x000000cecc00720bULL, 0x000fca0003fbd000ULL, 0x0000007c00d57306ULL, 0x000fe20000209400ULL,
0x000000017f7f3812ULL, 0x008fe400078efcffULL, 0x000000abac00720bULL, 0x000fca0003f7d000ULL,
0x0000007c00d27306ULL, 0x000ea20000205400ULL, 0x000000017d7d4812ULL, 0x002fe400078efcffULL,
0x000000018c8c5812ULL, 0x000fe400078efcffULL, 0x000000d6d700720bULL, 0x000fc60003fbd000ULL,
0x0000003200dd7306ULL, 0x000fe20000209400ULL, 0x000000016d6d3812ULL, 0x000fe400078efcffULL,
0x0000009d9e00720bULL, 0x000fca0003f7d000ULL, 0x0000003200dc7306ULL, 0x000e620000205400ULL,
0x000000d2d500720bULL, 0x004fe40003f5d000ULL, 0x0000000184845812ULL, 0x000fca00078efcffULL,
0x0000003100b17306ULL, 0x000fe20000009400ULL, 0x0000000156563812ULL, 0x000fce00078efcffULL,
0x0000003100ad7306ULL, 0x000ea20000005400ULL, 0x000000dcdd00720bULL, 0x002fce0003f9d000ULL,
0x0000003100707306ULL, 0x0002f0000000d400ULL, 0x000000b600b07306ULL, 0x000fe20000209400ULL,
0x0000010031317824ULL, 0x002fe200078e00ffULL, 0x000000adb100720bULL, 0x004fc80003fbd000ULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x000000b600b27306ULL, 0x000fee0000205400ULL,
0x0000000170705812ULL, 0x008fe200078efcffULL, 0x000000b600877306ULL, 0x0003e6000020d400ULL,
0x000000707d70723eULL, 0x000fca00000010ffULL, 0x0000006f006f7306ULL, 0x000ea2000020d400ULL,
0x00000020b4b67824ULL, 0x042fe400078e00ffULL, 0x00000020b4b47824ULL, 0x000fc600078e00ffULL,
0xffffffe0b6af7812ULL, 0x000fe400078ee2afULL, 0x0000003300a17306ULL, 0x000fe20000009400ULL,
0xffffffe0b4ae7812ULL, 0x000fe400078ee2aeULL, 0x00000010af287824ULL, 0x000fca00078e00ffULL,
0x0000003300a07306ULL, 0x000e620000005400ULL, 0x000000016f6f1812ULL, 0x004fce00078efcffULL,
0x0000007c007c7306ULL, 0x000eb0000020d400ULL, 0x0000003100db7306ULL, 0x000fe20000209400ULL,
0x000000a0a100720bULL, 0x002fce0003f3d000ULL, 0x0000003100da7306ULL, 0x000e620000205400ULL,
0x000000017c7c2812ULL, 0x004fce00078efcffULL, 0x0000003200327306ULL, 0x000eb0000020d400ULL,
0x0000002c007b7306ULL, 0x000fe20000009400ULL, 0x000000dadb00720bULL, 0x002fce0003fdd000ULL,
0x0000002c007a7306ULL, 0x000fe20000005400ULL, 0x0000000132324812ULL, 0x004fce00078efcffULL,
0x0000002c004f7306ULL, 0x0003f0000000d400ULL, 0x0000006500c67306ULL, 0x000fe20000209400ULL,
0x000001002c2c7824ULL, 0x002fca00078e00ffULL, 0x00000018ff2c7819ULL, 0x000fe4000001142cULL,
0x0000006500c77306ULL, 0x000e700000205400ULL, 0x0000003000de7306ULL, 0x000ff00000209400ULL,
0x0000003000df7306ULL, 0x000ea20000205400ULL, 0x000000c7c600720bULL, 0x002fce0003f9d000ULL,
0x0000003000777306ULL, 0x0002f0000020d400ULL, 0x0000002c00a67306ULL, 0x000fe20000209400ULL,
0x0001000033307824ULL, 0x002fe200078e00ffULL, 0x000000dfde00720bULL, 0x004fc80003f5d000ULL,
0x00000018ffe07819ULL, 0x000fe40000011430ULL, 0x0000002c00a77306ULL, 0x000fee0000205400ULL,
0x0000000177772812ULL, 0x008fe200078efcffULL, 0x0000002c00a47306ULL, 0x0003e2000020d400ULL,
0x000000b2b000720bULL, 0x000fce0003f5d000ULL, 0x0000003300647306ULL, 0x000ea2000000d400ULL,
0x00000018ff2c7819ULL, 0x002fe40000011429ULL, 0x000000002828783bULL, 0x000e660000000200ULL,
0x0000000187872812ULL, 0x000fe400078efcffULL, 0x0000003100767306ULL, 0x000ee2000020d400ULL,
0x000000999800720bULL, 0x000fce0003f5d000ULL, 0x0000006500657306ULL, 0x000ee2000020d400ULL,
0x0000000164641812ULL, 0x004fe400078efcffULL, 0x000000c2c300720bULL, 0x000fc60003f3d000ULL,
0x0000000151512812ULL, 0x000fe400078efcffULL, 0x000000e000307306ULL, 0x000fe20000209400ULL,
0x0000000176766812ULL, 0x008fce00078efcffULL, 0x000000e000317306ULL, 0x000ea20000205400ULL,
0x0000000165654812ULL, 0x000fe400078efcffULL, 0x0000000134341812ULL, 0x000fe400078efcffULL,
0x000000876565723eULL, 0x000fc600000010ffULL, 0x0000004d009c7306ULL, 0x000ff00000209400ULL,
0x0000004d009f7306ULL, 0x000ee20000205400ULL, 0x000000313000720bULL, 0x004fe40003fdd000ULL,
0x00000091a830723eULL, 0x000fc400000010ffULL, 0x000000948d31723eULL, 0x000fe200000010ffULL,
0x000100002e8d7824ULL, 0x000fe400078e00ffULL, 0x0000004a00927306ULL, 0x000fe60000209400ULL,
0x00000018ff8d7819ULL, 0x000fe2000001148dULL, 0x000000302820723cULL, 0x002b680000041820ULL,
0x0000004a00907306ULL, 0x000e620000205400ULL, 0x0000009f9c00720bULL, 0x008fc40003f9d000ULL,
0x000001002e307824ULL, 0x020fca00078e00ffULL, 0x0000003500bd7306ULL, 0x000fe20000209400ULL,
0x00000018ff757819ULL, 0x000fe40000011430ULL, 0x0000006d7730723eULL, 0x000fca00000010ffULL,
0x0000003500ba7306ULL, 0x000ea20000205400ULL, 0x000000909200720bULL, 0x002fce0003f7d000ULL,
0x000000e000337306ULL, 0x000e70000020d400ULL, 0x0000004d004d7306ULL, 0x000ee2000020d400ULL,
0x000000babd00720bULL, 0x004fce0003f3d000ULL, 0x0000004a004a7306ULL, 0x000ea2000020d400ULL,
0x0000000133336812ULL, 0x002fe400078efcffULL, 0x000000979600720bULL, 0x000fe40003fdd000ULL,
0x000000643364723eULL, 0x000fc600000010ffULL, 0x0000006e00c17306ULL, 0x000fe20000209400ULL,
0x000000014d4d4812ULL, 0x008fe400078efcffULL, 0x0000008e8f00720bULL, 0x000fe20003f9d000ULL,
0x000000642804723cULL, 0x000fe80000041804ULL, 0x0000006e00c07306ULL, 0x000e620000205400ULL,
0x000000014a4a3812ULL, 0x004fe400078efcffULL, 0x000000828300720bULL, 0x000fc40003f7d000ULL,
0x0000000153536812ULL, 0x000fc600078efcffULL, 0x0000002d00717306ULL, 0x000fe20000009400ULL,
0x0000000136364812ULL, 0x000fe400078efcffULL, 0x0000007a7b00720bULL, 0x000fca0003f9d000ULL,
0x0000002d00727306ULL, 0x000ea20000005400ULL, 0x000000c0c100720bULL, 0x002fe40003fbd000ULL,
0x0000000157573812ULL, 0x000fca00078efcffULL, 0x0000002d004e7306ULL, 0x0002e2000000d400ULL,
0x000000014f4f4812ULL, 0x000fce00078efcffULL, 0x0000003500357306ULL, 0x000ee2000020d400ULL,
0x000001002d2d7824ULL, 0x002fe200078e00ffULL, 0x000000727100720bULL, 0x004fe40003f5d000ULL,
0x000000766f71723eULL, 0x000fe400000010ffULL, 0x00000018ff967819ULL, 0x000fe4000001142dULL,
0x0000006e006e7306ULL, 0x000e62000020d400ULL, 0x000000a5932d723eULL, 0x000fe400000010ffULL,
0x000000702810723cULL, 0x000fe80000041810ULL, 0x000000014e4e2812ULL, 0x008fe200078efcffULL,
0x0000005800737306ULL, 0x000fe20000209400ULL, 0x0000000135351812ULL, 0x000fc400078efcffULL,
0x000000888900720bULL, 0x000fe40003f3d000ULL, 0x000000686700720bULL, 0x000fc60003f5d000ULL,
0x0000005800747306ULL, 0x000ea20000205400ULL, 0x000000016e6e5812ULL, 0x002fe400078efcffULL,
0x000000c5c400720bULL, 0x000fe40003fbd000ULL, 0x000000326e31723eULL, 0x000fc600000010ffULL,
0x0000002c00ab7306ULL, 0x000fe20000209400ULL, 0x0000000137371812ULL, 0x000fe400078efcffULL,
0x0000000169692812ULL, 0x000fe200078efcffULL, 0x000000302808723cULL, 0x000fe80000041808ULL,
0x0000002c00a07306ULL, 0x000e620000205400ULL, 0x000000747300720bULL, 0x004fe40003f7d000ULL,
0x000000016a6a5812ULL, 0x000fc400078efcffULL, 0x0000009b9a00720bULL, 0x000fe40003fbd000ULL,
0x000000566a6a723eULL, 0x000fe200000010ffULL, 0x0000002c009d7306ULL, 0x0004e2000020d400ULL,
0x000000513756723eULL, 0x000fce00000010ffULL, 0x000000b300a97306ULL, 0x000fe20000209400ULL,
0x00000095a22c723eULL, 0x004fe400000010ffULL, 0x000000a0ab00720bULL, 0x002fe40003f9d000ULL,
0x0000000150505812ULL, 0x000fc600078efcffULL, 0x0000002c2824723cULL, 0x000b620000041824ULL,
0x000000b300aa7306ULL, 0x000e6c0000205400ULL, 0x0000008a8c2c723eULL, 0x020fe200000010ffULL,
0x000100002f8a7824ULL, 0x040fe200078e00ffULL, 0x0000008b862d723eULL, 0x000fe200000010ffULL,
0x0000005800587306ULL, 0x000ea2000020d400ULL, 0x000001002f8b7824ULL, 0x000fe200078e00ffULL,
0x000000019d9d4812ULL, 0x008fc400078efcffULL, 0x00000018ff8a7819ULL, 0x000fe4000001148aULL,
0x0000002c281c723cULL, 0x000b62000004181cULL, 0x000000aaa900720bULL, 0x002fe20003f3d000ULL,
0x0000004c00797306ULL, 0x000fe20000209400ULL, 0x00000018ff8b7819ULL, 0x000fe4000001148bULL,
0x0000004e9d4e723eULL, 0x000fe400000010ffULL, 0x00000010ae2c7824ULL, 0x020fc600078e00ffULL,
0x0000004c00787306ULL, 0x000e620000205400ULL, 0x0000000158583812ULL, 0x004fe400078efcffULL,
0x0000006c6b00720bULL, 0x000fe40003f7d000ULL, 0x000000344d6b723eULL, 0x000fc600000010ffULL,
0x0000002e00627306ULL, 0x000ff00000009400ULL, 0x0000002e00637306ULL, 0x000fe20000005400ULL,
0x000000787900720bULL, 0x002fe40003fdd000ULL, 0x0000000166663812ULL, 0x000fca00078efcffULL,
0x0000002e00497306ULL, 0x0003f0000000d400ULL, 0x0000002f00547306ULL, 0x000fe20000009400ULL,
0x00000081852e723eULL, 0x002fce00000010ffULL, 0x0000002f00557306ULL, 0x000ff00000005400ULL,
0x0000002f00487306ULL, 0x0003f0000000d400ULL, 0x000000b300a37306ULL, 0x000ea2000020d400ULL,
0x000000847f2f723eULL, 0x002fc400000010ffULL, 0x000000807c7f723eULL, 0x000fca00000010ffULL,
0x0000002e2818723cULL, 0x040be20000041818ULL, 0x0000004c004c7306ULL, 0x000e62000020d400ULL,
0x000000002c2c783bULL, 0x020eec0000000200ULL, 0x0000007e2814723cULL, 0x000b620000041814ULL,
0x0000004b00477306ULL, 0x000fe20000209400ULL, 0x00000001a3a31812ULL, 0x004fc400078efcffULL,
0x000000636200720bULL, 0x000fc60003f3d000ULL, 0x000000533528723eULL, 0x020fe400000010ffULL,
0x0000004b00527306ULL, 0x000ea20000205400ULL, 0x000000014c4c6812ULL, 0x002fe400078efcffULL,
0x000000a7a600720bULL, 0x000fe40003fdd000ULL, 0x000000364a29723eULL, 0x000fe400000010ffULL,
0x000000574c57723eULL, 0x000fe200000010ffULL, 0x0000005b00597306ULL, 0x000fe20000209400ULL,
0x0000000149491812ULL, 0x000fc400078efcffULL, 0x00000050664a723eULL, 0x000fca00000010ffULL,
0x0000005b005a7306ULL, 0x000e620000205400ULL, 0x000000524700720bULL, 0x004fe40003f9d000ULL,
0x00000001a4a46812ULL, 0x000fe400078efcffULL, 0x000000555400720bULL, 0x000fc60003fdd000ULL,
0x0000009600977306ULL, 0x000fe20000209400ULL, 0x000000282c20723cULL, 0x048b6e0000041820ULL,
0x0000009600907306ULL, 0x000ea20000205400ULL, 0x0000005a5900720bULL, 0x002fe20003fbd000ULL,
0x0000006a2c24723cULL, 0x000f640000041824ULL, 0x0000004fa328723eULL, 0x020fc400000010ffULL,
0x000000a45829723eULL, 0x000fe400000010ffULL, 0x0000000148486812ULL, 0x000fe200078efcffULL,
0x0000008d00867306ULL, 0x000fe20000209400ULL, 0x000000562c1c723cULL, 0x040f6e000004181cULL,
0x0000008d00817306ULL, 0x000e620000205400ULL, 0x000000909700720bULL, 0x004fe20003f7d000ULL,
0x000000282c14723cULL, 0x000b6c0000041814ULL, 0x0000008b002b7306ULL, 0x000ff00000209400ULL,
0x0000008b00317306ULL, 0x000ea20000205400ULL, 0x000000818600720bULL, 0x002fce0003f5d000ULL,
0x0000004b004b7306ULL, 0x000e70000020d400ULL, 0x0000005b005b7306ULL, 0x000ee2000020d400ULL,
0x000000312b00720bULL, 0x004fce0003f3d000ULL, 0x0000009600967306ULL, 0x000ea2000020d400ULL,
0x000000014b4b4812ULL, 0x002fc800078efcffULL, 0x000000694b4b723eULL, 0x000fc600000010ffULL,
0x0000008d008d7306ULL, 0x000e62000020d400ULL, 0x000000015b5b5812ULL, 0x008fc600078efcffULL,
0x0000004a2c18723cULL, 0x000b680000041818ULL, 0x0000005e005c7306ULL, 0x000fe20000209400ULL,
0x0000000196963812ULL, 0x004fc800078efcffULL, 0x000000965b4f723eULL, 0x000fc600000010ffULL,
0x0000005e005d7306ULL, 0x000ea20000205400ULL, 0x000000018d8d2812ULL, 0x002fc600078efcffULL,
0x0000004e2c10723cULL, 0x000b640000041810ULL, 0x000000498d28723eULL, 0x020fe400000010ffULL,
0x00000061005f7306ULL, 0x000ff00000209400ULL, 0x0000006100607306ULL, 0x000e620000205400ULL,
0x0000005d5c00720bULL, 0x004fce0003f9d000ULL, 0x0000007500787306ULL, 0x000ff00000209400ULL,
0x00000075006f7306ULL, 0x000ea20000205400ULL, 0x000000605f00720bULL, 0x002fce0003f7d000ULL,
0x0000008a00307306ULL, 0x000ff00000209400ULL, 0x0000008a002a7306ULL, 0x000e620000205400ULL,
0x0000006f7800720bULL, 0x004fce0003fbd000ULL, 0x0000008b008b7306ULL, 0x000eb0000020d400ULL,
0x0000005e005e7306ULL, 0x000ee2000020d400ULL, 0x0000002a3000720bULL, 0x002fce0003f5d000ULL,
0x0000006100617306ULL, 0x000e62000020d400ULL, 0x000000018b8b1812ULL, 0x004fe400078efcffULL,
0x000000084600780cULL, 0x000fca0003f25270ULL, 0x0000007500757306ULL, 0x000ea2000020d400ULL,
0x000000015e5e4812ULL, 0x008fce00078efcffULL, 0x0000008a008a7306ULL, 0x000ee2000020d400ULL,
0x0000000161613812ULL, 0x002fc800078efcffULL, 0x0000008b6149723eULL, 0x000fe400000010ffULL,
0x0000000175755812ULL, 0x004fc800078efcffULL, 0x000000755e29723eULL, 0x000fe400000010ffULL,
0x000000018a8a2812ULL, 0x008fca00078efcffULL, 0x000000282c08723cULL, 0x000b620000041808ULL,
0x000000488a48723eULL, 0x000fce00000010ffULL, 0x000000482c04723cULL, 0x000b620000041804ULL,
0x0000001000009944ULL, 0x000fe20003c00000ULL, 0xffffe0f000007947ULL, 0x000fcc000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff437224ULL, 0x000fe200078e0041ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffc4c000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x0000003c1a2a7220ULL, 0x080fe40000410000ULL,
0x0000003c1e287220ULL, 0x0a0fe40000410000ULL, 0x0000003c1b2b7220ULL, 0x080fe40000410000ULL,
0x0000003c141a7220ULL, 0x080fe40000410000ULL, 0x0000003c1c1c7220ULL, 0x000fc40000410000ULL,
0x0000003c1d1d7220ULL, 0x080fe40000410000ULL, 0x0000003c1f297220ULL, 0x080fe40000410000ULL,
0x0000003c151b7220ULL, 0x080fe40000410000ULL, 0x0000003c101e7220ULL, 0x080fe40000410000ULL,
0x0000003c24247220ULL, 0x080fe40000410000ULL, 0x0000003c25257220ULL, 0x000fc40000410000ULL,
0x0000003c20207220ULL, 0x080fe40000410000ULL, 0x0000003c21217220ULL, 0x080fe40000410000ULL,
0x0000003c18187220ULL, 0x080fe40000410000ULL, 0x0000003c19197220ULL, 0x080fe40000410000ULL,
0x0000003c111f7220ULL, 0x080fe40000410000ULL, 0x0000003c08087220ULL, 0x000fc40000410000ULL,
0x0000003c09097220ULL, 0x080fe40000410000ULL, 0x0000003c04047220ULL, 0x080fe40000410000ULL,
0x0000003c162c7220ULL, 0x080fe40000410000ULL, 0x0000003c172d7220ULL, 0x080fe40000410000ULL,
0x0000003c122e7220ULL, 0x080fe40000410000ULL, 0x0000003c132f7220ULL, 0x000fc40000410000ULL,
0x000000ffff167224ULL, 0x000fe400078e001aULL, 0x0000003c0a307220ULL, 0x080fe40000410000ULL,
0x0000003c0b317220ULL, 0x000fe40000410000ULL, 0x000000ffff127224ULL, 0x000fe400078e001cULL,
0x000000ffff137224ULL, 0x000fe400078e001dULL, 0x000000ffff177224ULL, 0x000fc400078e001bULL,
0x000000ffff1a7224ULL, 0x000fe400078e001eULL, 0x0000003c26267220ULL, 0x080fe40000410000ULL,
0x0000003c27277220ULL, 0x080fe40000410000ULL, 0x0000003c22227220ULL, 0x080fe40000410000ULL,
0x0000003c23237220ULL, 0x080fe40000410000ULL, 0x0000003c05057220ULL, 0x000fc40000410000ULL,
0x0000003c06067220ULL, 0x080fe40000410000ULL, 0x0000003c07077220ULL, 0x000fe40000410000ULL,
0x000000ffff0a7224ULL, 0x000fe400078e0024ULL, 0x000000ffff0b7224ULL, 0x000fe400078e0025ULL,
0x000000ffff107224ULL, 0x000fe400078e0020ULL, 0x000000ffff117224ULL, 0x000fc400078e0021ULL,
0x000000ffff147224ULL, 0x000fe400078e0018ULL, 0x000000ffff157224ULL, 0x000fe400078e0019ULL,
0x000000ffff1b7224ULL, 0x000fe400078e001fULL, 0x000000ffff1c7224ULL, 0x000fe400078e0008ULL,
0x000000ffff1d7224ULL, 0x000fe400078e0009ULL, 0x000000ffff1e7224ULL, 0x000fe200078e0004ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000003d087f8cULL, 0x0002a2000c80043fULL,
0x000000ffff207224ULL, 0x000fc400078e0026ULL, 0x000000ffff217224ULL, 0x000fe400078e0027ULL,
0x000000ffff247224ULL, 0x000fe400078e0028ULL, 0x000000ffff257224ULL, 0x000fe400078e0029ULL,
0x000000ffff267224ULL, 0x000fe400078e002aULL, 0x000000ffff277224ULL, 0x000fe400078e002bULL,
0x000000ffff287224ULL, 0x000fc400078e002cULL, 0x000000ffff297224ULL, 0x000fe400078e002dULL,
0x000000ffff2a7224ULL, 0x000fe400078e002eULL, 0x000000ffff2b7224ULL, 0x000fe400078e002fULL,
0x000000ffff1f7224ULL, 0x000fe400078e0005ULL, 0x000000ffff2c7224ULL, 0x000fe400078e0030ULL,
0x000000ffff2d7224ULL, 0x000fc400078e0031ULL, 0x000000ffff2e7224ULL, 0x000fe400078e0006ULL,
0x000000ffff2f7224ULL, 0x000fc400078e0007ULL, 0x0000000000047805ULL, 0x006fca0000015200ULL,
0x000004003d067984ULL, 0x000e640000000800ULL, 0x8000000006ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff197224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604187210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09001800780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401800780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000001806067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000119197810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004003d067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000403197824ULL, 0x000fe200078e00ffULL, 0x0000003e4000720cULL, 0x000fc80003f05270ULL,
0xfffffff019187812ULL, 0x000fca00078ec0ffULL, 0x0000008002187824ULL, 0x000fca00078e0218ULL,
0x0184000018047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000203087824ULL, 0x000fe400078e00ffULL, 0x000000010c427824ULL, 0x000fc600078e0a42ULL,
0x0000000608087812ULL, 0x000fc800078ec0ffULL, 0x0000000108097812ULL, 0x040fe400078efcffULL,
0x0000000808307812ULL, 0x040fe400078efcffULL, 0x000000420900720cULL, 0x080fe40003f26070ULL,
0x0000001008097812ULL, 0x000fe400078efcffULL, 0x000000423000720cULL, 0x080fe40003f06070ULL,
0x000000420900720cULL, 0x000fc40003fc6070ULL, 0x0000001108307812ULL, 0x040fe400078efcffULL,
0x0000001808097812ULL, 0x040fe400078efcffULL, 0x000000420800720cULL, 0x080fe40003f46070ULL,
0x000000423000720cULL, 0x080fe40003fa6070ULL, 0x000000420900720cULL, 0x000fe40003f66070ULL,
0x0000000908317812ULL, 0x000fc400078efcffULL, 0x0000001908307812ULL, 0x040fe400078efcffULL,
0x0000002008097812ULL, 0x000fe400078efcffULL, 0xff80000020207808ULL, 0x000fe40005000000ULL,
0xff8000000a0a7808ULL, 0x000fe40005000000ULL, 0xff80000021217808ULL, 0x000fe40004800000ULL,
0xff8000000b0b7808ULL, 0x000fc40004800000ULL, 0x000000423100720cULL, 0x080fe40003f86070ULL,
0x000000423000720cULL, 0x080fe40003f46070ULL, 0x000000420900720cULL, 0x000fe40003f26070ULL,
0x0000002108307812ULL, 0x040fe400078efcffULL, 0x0000002808097812ULL, 0x000fe400078efcffULL,
0xff80000022227808ULL, 0x000fc40004000000ULL, 0xff80000010107808ULL, 0x000fe40004000000ULL,
0xff80000023237808ULL, 0x000fe40006000000ULL, 0xff80000011117808ULL, 0x000fe40006000000ULL,
0x000000423000720cULL, 0x080fe40003f06070ULL, 0x000000420900720cULL, 0x000fe40003f86070ULL,
0x0000002908307812ULL, 0x000fc400078efcffULL, 0x0000003008097812ULL, 0x000fe400078efcffULL,
0xff80000024247808ULL, 0x000fe40007000000ULL, 0xff80000012127808ULL, 0x000fe40007000000ULL,
0xff80000025257808ULL, 0x000fe40006800000ULL, 0xff80000013137808ULL, 0x000fe40006800000ULL,
0x000000423000720cULL, 0x000fc40003fc6070ULL, 0x000000420900720cULL, 0x000fe40003fa6070ULL,
0x0000003108307812ULL, 0x040fe400078efcffULL, 0x0000003808097812ULL, 0x040fe400078efcffULL,
0x0000003908087812ULL, 0x000fe400078efcffULL, 0xff80000026267808ULL, 0x000fe40005800000ULL,
0xff80000014147808ULL, 0x000fc40005800000ULL, 0xff80000027277808ULL, 0x000fe40005000000ULL,
0xff80000015157808ULL, 0x000fe40005000000ULL, 0xff80000028287808ULL, 0x000fe40004800000ULL,
0xff80000016167808ULL, 0x000fe40004800000ULL, 0x000000423000720cULL, 0x080fe40003f66070ULL,
0x000000420900720cULL, 0x000fc40003f46070ULL, 0x000000420800720cULL, 0x000fe40003f26070ULL,
0xff80000029297808ULL, 0x000fe40004000000ULL, 0xff80000017177808ULL, 0x000fe40004000000ULL,
0xff8000002a2a7808ULL, 0x000fe40006000000ULL, 0xff8000001a1a7808ULL, 0x000fe40006000000ULL,
0xff8000002b2b7808ULL, 0x000fc40007000000ULL, 0xff8000001b1b7808ULL, 0x000fe40007000000ULL,
0xff8000002c2c7808ULL, 0x000fe40006800000ULL, 0xff8000001c1c7808ULL, 0x000fe40006800000ULL,
0xff8000002d2d7808ULL, 0x000fe40005800000ULL, 0xff8000001d1d7808ULL, 0x000fe40005800000ULL,
0xff8000002e2e7808ULL, 0x000fc40005000000ULL, 0xff8000001e1e7808ULL, 0x000fe40005000000ULL,
0xff8000002f2f7808ULL, 0x000fe40004800000ULL, 0xff8000001f1f7808ULL, 0x000fc40004800000ULL,
0x0000000a0400720bULL, 0x004fe40003f1e000ULL, 0x000000200500720bULL, 0x000fe40003f3e000ULL,
0x000000040a047208ULL, 0x000fe40004000000ULL, 0x0000000520057208ULL, 0x000fc40004800000ULL,
0x0000000b0400720bULL, 0x000fe40003f1e000ULL, 0x000000210500720bULL, 0x000fe40003f3e000ULL,
0x000000040b047208ULL, 0x000fe40004000000ULL, 0x0000000521057208ULL, 0x000fe40004800000ULL,
0x000000100400720bULL, 0x000fe40003f1e000ULL, 0x000000220500720bULL, 0x000fc40003f3e000ULL,
0x0000000410047208ULL, 0x000fe40004000000ULL, 0x0000000522057208ULL, 0x000fe40004800000ULL,
0x000000110400720bULL, 0x000fe40003f1e000ULL, 0x000000230500720bULL, 0x000fe40003f3e000ULL,
0x0000000411047208ULL, 0x000fe40004000000ULL, 0x0000000523057208ULL, 0x000fc40004800000ULL,
0x000000120400720bULL, 0x000fe40003f1e000ULL, 0x000000240500720bULL, 0x000fe40003f3e000ULL,
0x0000000412047208ULL, 0x000fe40004000000ULL, 0x0000000524057208ULL, 0x000fe40004800000ULL,
0x000000130400720bULL, 0x000fe40003f1e000ULL, 0x000000250500720bULL, 0x000fc40003f3e000ULL,
0x0000000413047208ULL, 0x000fe40004000000ULL, 0x0000000525057208ULL, 0x000fe40004800000ULL,
0x000000140400720bULL, 0x000fe40003f1e000ULL, 0x000000260500720bULL, 0x000fe40003f3e000ULL,
0x0000000414047208ULL, 0x000fe40004000000ULL, 0x0000000526057208ULL, 0x000fc40004800000ULL,
0x000000150400720bULL, 0x000fe40003f1e000ULL, 0x000000270500720bULL, 0x000fe40003f3e000ULL,
0x0000000415047208ULL, 0x000fe40004000000ULL, 0x0000000527057208ULL, 0x000fe40004800000ULL,
0x000000160400720bULL, 0x000fe40003f1e000ULL, 0x000000280500720bULL, 0x000fc40003f3e000ULL,
0x0000000416047208ULL, 0x000fe40004000000ULL, 0x0000000528057208ULL, 0x000fe40004800000ULL,
0x000000170400720bULL, 0x000fe40003f1e000ULL, 0x000000290500720bULL, 0x000fe40003f3e000ULL,
0x0000000417047208ULL, 0x000fe40004000000ULL, 0x0000000529057208ULL, 0x000fc40004800000ULL,
0x0000001a0400720bULL, 0x000fe40003f1e000ULL, 0x0000002a0500720bULL, 0x000fe40003f3e000ULL,
0x000000041a047208ULL, 0x000fe40004000000ULL, 0x000000052a057208ULL, 0x000fe40004800000ULL,
0x0000001b0400720bULL, 0x000fe40003f1e000ULL, 0x0000002b0500720bULL, 0x000fc40003f3e000ULL,
0x000000041b047208ULL, 0x000fe40004000000ULL, 0x000000052b057208ULL, 0x000fe40004800000ULL,
0x0000001c0400720bULL, 0x000fe40003f1e000ULL, 0x0000002c0500720bULL, 0x000fe40003f3e000ULL,
0x000000041c047208ULL, 0x000fe40004000000ULL, 0x000000052c057208ULL, 0x000fc40004800000ULL,
0x0000001d0400720bULL, 0x000fe40003f1e000ULL, 0x0000002d0500720bULL, 0x000fe40003f3e000ULL,
0x000000041d047208ULL, 0x000fe40004000000ULL, 0x000000052d057208ULL, 0x000fe40004800000ULL,
0x0000001e0400720bULL, 0x000fe40003f1e000ULL, 0x0000002e0500720bULL, 0x000fc40003f3e000ULL,
0x000000041e047208ULL, 0x000fe40004000000ULL, 0x000000052e057208ULL, 0x000fe40004800000ULL,
0x0000001f0400720bULL, 0x000fe40003f1e000ULL, 0x0000002f0500720bULL, 0x000fe40003f3e000ULL,
0x000000041f327208ULL, 0x000fe40004000000ULL, 0x000000052f057208ULL, 0x000fe20004800000ULL,
0x00001ba27f007947ULL, 0x000fec000b800000ULL, 0x0c401f0032047f89ULL, 0x0004e400000e0000ULL,
0x000000043200720bULL, 0x008fc80003f1e000ULL, 0x0000003204327208ULL, 0x004fe20004000000ULL,
0x00001be27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0005047f89ULL, 0x000ea800000e0000ULL,
0x0c401f0006087f89ULL, 0x000ee800000e0000ULL, 0x0c401f0007097f89ULL, 0x000e6200000e0000ULL,
0x000000040500720bULL, 0x004fc40003f1e000ULL, 0x000000080600720bULL, 0x008fe40003f3e000ULL,
0x0000000504057208ULL, 0x000fe40004000000ULL, 0x0000000608067208ULL, 0x000fe20004800000ULL,
0x0c201f0032047f89ULL, 0x000ea200000e0000ULL, 0x000000090700720bULL, 0x002fc60003f1e000ULL,
0x0c201f0005087f89ULL, 0x000e6200000e0000ULL, 0x0000000709077208ULL, 0x000fc60004000000ULL,
0x0c201f0006307f89ULL, 0x000ee800000e0000ULL, 0x0c201f0007317f89ULL, 0x0002e200000e0000ULL,
0x000000043200720bULL, 0x004fe40003f1e000ULL, 0x000000080500720bULL, 0x002fe40003f3e000ULL,
0x0000003204047208ULL, 0x000fe40004000000ULL, 0x000000300600720bULL, 0x008fc40003f5e000ULL,
0x0000000508057208ULL, 0x000fe40004800000ULL, 0x0000000630067208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b04307820ULL, 0x000fe20000410000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0x0000000c19197812ULL, 0x000fe200078ec0ffULL, 0x00000004ff327e24ULL, 0x000fe2000f8e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b0a0a7823ULL, 0x100fe20000010830ULL,
0x0000000303ff7812ULL, 0x000fe2000780c0ffULL, 0x3fb8aa3b10107823ULL, 0x100fe20000010830ULL,
0x3f8000003232783eULL, 0x000fe200000010ffULL, 0x3fb8aa3b12127823ULL, 0x100fe20000010830ULL,
0x0000000a00087308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b14147823ULL, 0x100fe20000010830ULL,
0x000000310700720bULL, 0x004fe20003f3e000ULL, 0x3fb8aa3b16167823ULL, 0x000fc40000010830ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe20000010830ULL, 0x0000000731077208ULL, 0x000fe20004800000ULL,
0x3fb8aa3b0b0b7823ULL, 0x100fe20000010830ULL, 0x00000010000a7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b11117823ULL, 0x000fe40000010830ULL, 0x000000ffff337224ULL, 0x000fe400078e0032ULL,
0x3fb8aa3b13137823ULL, 0x100fe40000010830ULL, 0x3fb8aa3b15157823ULL, 0x100fe20000010830ULL,
0x0000001200107308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b17177823ULL, 0x000fc40000010830ULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe40000010830ULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe40000010830ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe20000010830ULL, 0x0000001400127308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe40000010830ULL, 0x3fb8aa3b1f1f7823ULL, 0x000fe20000010830ULL,
0x00000002ff307819ULL, 0x000fc80000011603ULL, 0x0000001600147308ULL, 0x000ff00000000800ULL,
0x0000001a00167308ULL, 0x0003f00000000800ULL, 0x0000000b000b7308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b051a7820ULL, 0x002fc80000410000ULL, 0x3fb8aa3b21217823ULL, 0x100fe4000001081aULL,
0x3fb8aa3b22227823ULL, 0x100fe2000001081aULL, 0x0000001100117308ULL, 0x000e620000000800ULL,
0x3fb8aa3b23237823ULL, 0x100fe4000001081aULL, 0x3fb8aa3b20207823ULL, 0x100fe4000001081aULL,
0x3fb8aa3b24247823ULL, 0x100fe4000001081aULL, 0x3fb8aa3b25257823ULL, 0x100fe2000001081aULL,
0x0000002000097308ULL, 0x000fe20000000800ULL, 0x000000080b08723eULL, 0x004fe200000010ffULL,
0x3fb8aa3b26267823ULL, 0x000fc4000001081aULL, 0x3fb8aa3b27277823ULL, 0x100fe4000001081aULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe4000001081aULL, 0x0000002100217308ULL, 0x000ea20000000800ULL,
0x0000000a110a723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe4000001081aULL,
0x3fb8aa3b28287823ULL, 0x100fe4000001081aULL, 0x3fb8aa3b29297823ULL, 0x000fc4000001081aULL,
0x0000002200227308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe4000001081aULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe4000001081aULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe4000001081aULL,
0x3fb8aa3b2f1a7823ULL, 0x000fe2000001081aULL, 0x0000002300237308ULL, 0x000e620000000800ULL,
0x000000092109723eULL, 0x004fe200000010ffULL, 0x00000008302f7824ULL, 0x000fcc00078e00ffULL,
0x0000001300137308ULL, 0x000ea20000000800ULL, 0x00000022230b723eULL, 0x002fce00000010ffULL,
0x0000002400247308ULL, 0x000fe20000000800ULL, 0x000000320820723cULL, 0x000b6200000418ffULL,
0x000000101310723eULL, 0x004fcc00000010ffULL, 0x0000002500257308ULL, 0x000e620000000800ULL,
0x0000000830337824ULL, 0x020fce00078e00ffULL, 0x0000001500157308ULL, 0x000eb00000000800ULL,
0x0000002600267308ULL, 0x000fe20000000800ULL, 0x000000242511723eULL, 0x002fe200000010ffULL,
0x000000ffff247224ULL, 0x000fc400078e0032ULL, 0x000000ffff257224ULL, 0x000fc800078e0032ULL,
0x0000002700277308ULL, 0x000e620000000800ULL, 0x000000121512723eULL, 0x004fe400000010ffULL,
0x0000000130157810ULL, 0x000fca0007ffe0ffULL, 0x0000001700177308ULL, 0x000ea20000000800ULL,
0x000000262713723eULL, 0x002fce00000010ffULL, 0x0000002a002a7308ULL, 0x000fe20000000800ULL,
0x0000000330267810ULL, 0x040fe40007ffe0ffULL, 0x0000000430277810ULL, 0x000fe20007ffe0ffULL,
0x000000241020723cULL, 0x000b620000041820ULL, 0x000000141714723eULL, 0x004fc600000010ffULL,
0x0000002b002b7308ULL, 0x000e660000000800ULL, 0x0000000830247824ULL, 0x060fe400078e00ffULL,
0x0000000830257824ULL, 0x000fc600078e00ffULL, 0x0000001b001b7308ULL, 0x000ea20000000800ULL,
0xfffffff824247812ULL, 0x000fce00078ee215ULL, 0x0000002800287308ULL, 0x000fe20000000800ULL,
0x0000002a2b17723eULL, 0x002fe200000010ffULL, 0x000000ffff2a7224ULL, 0x100fe400078e0032ULL,
0x000000ffff2b7224ULL, 0x000fc800078e0032ULL, 0x0000002900297308ULL, 0x000e620000000800ULL,
0x000000161b16723eULL, 0x004fe400000010ffULL, 0x00000002301b7810ULL, 0x000fc80007ffe0ffULL,
0xfffffff825257812ULL, 0x000fe200078ee21bULL, 0x0000001c001c7308ULL, 0x000fe20000000800ULL,
0x00000008301b7824ULL, 0x000fca00078e00ffULL, 0xfffffff81b1b7812ULL, 0x000fe400078ee230ULL,
0x000000282915723eULL, 0x002fe200000010ffULL, 0x0000001d001d7308ULL, 0x000e620000000800ULL,
0x0000000830287824ULL, 0x040fe400078e00ffULL, 0x0000000830297824ULL, 0x000fc600078e00ffULL,
0x0000002a1420723cULL, 0x000b620000041820ULL, 0xfffffff828267812ULL, 0x000fe200078ee226ULL,
0x0000001e001e7308ULL, 0x000fe20000000800ULL, 0x0000000530287810ULL, 0x040fe40007ffe0ffULL,
0xfffffff829277812ULL, 0x000fe400078ee227ULL, 0x00000008302b7810ULL, 0x020fe40007ffe0ffULL,
0xfffffff82f287812ULL, 0x000fe200078ee228ULL, 0x0000001f001f7308ULL, 0x000ea20000000800ULL,
0x0000001c1d1c723eULL, 0x002fe200000010ffULL, 0x000000082b347824ULL, 0x000fe200078e00ffULL,
0x00012000022f7811ULL, 0x000fc400078e58ffULL, 0x0000000630297810ULL, 0x040fe40007ffe0ffULL,
0xffffffff302a7810ULL, 0x040fe20007ffe0ffULL, 0x0000002c002c7308ULL, 0x000fe20000000800ULL,
0x0000000830307824ULL, 0x000fe200078e00ffULL, 0xfffffff833297812ULL, 0x000fe200078ee229ULL,
0x000000101b1b7824ULL, 0x000fe200078e022fULL, 0xfffffff8342b7812ULL, 0x000fe200078ee22bULL,
0x0000001024247824ULL, 0x100fe200078e022fULL, 0xfffffff8302a7812ULL, 0x000fe200078ee22aULL,
0x0000001025257824ULL, 0x100fe200078e022fULL, 0x0000002d002d7308ULL, 0x000e620000000800ULL,
0x0000001e1f1e723eULL, 0x004fe200000010ffULL, 0x0000001026267824ULL, 0x000fc400078e022fULL,
0x0000001027277824ULL, 0x000fe400078e022fULL, 0x000000011b1b7824ULL, 0x000fe400078e0219ULL,
0x0000002e002e7308ULL, 0x000fe20000000800ULL, 0x0000001028287824ULL, 0x100fe400078e022fULL,
0x0000000119247824ULL, 0x000fe200078e0224ULL, 0x000000081b007388ULL, 0x0005e20000000800ULL,
0x0000001029297824ULL, 0x000fe400078e022fULL, 0x0000000119257824ULL, 0x000fe200078e0225ULL,
0x0000001a001a7308ULL, 0x000ee20000000800ULL, 0x0000002c2d1d723eULL, 0x002fe200000010ffULL,
0x000000ffff2c7224ULL, 0x100fe200078e0032ULL, 0x0000000a24007388ULL, 0x0005e20000000800ULL,
0x000000ffff2d7224ULL, 0x000fc400078e0032ULL, 0x000000102a2a7824ULL, 0x100fe200078e022fULL,
0x0000001025007388ULL, 0x0005e20000000800ULL, 0x0000000119267824ULL, 0x000fe400078e0226ULL,
0x000000102b2b7824ULL, 0x000fe400078e022fULL, 0x0000000119277824ULL, 0x040fe200078e0227ULL,
0x0000001226007388ULL, 0x0005e20000000800ULL, 0x0000000119287824ULL, 0x040fe200078e0228ULL,
0x0000002e1a1f723eULL, 0x008fe200000010ffULL, 0x0000000119297824ULL, 0x040fe200078e0229ULL,
0x0000001427007388ULL, 0x0005e20000000800ULL, 0x00000001192a7824ULL, 0x000fc400078e022aULL,
0x00000001192b7824ULL, 0x000fe200078e022bULL, 0x0000001628007388ULL, 0x0005e20000000800ULL,
0x0000002c1c20723cULL, 0x000f660000041820ULL, 0x0000001c29007388ULL, 0x0005e80000000800ULL,
0x0000001e2a007388ULL, 0x0005e80000000800ULL, 0x000000092b007388ULL, 0x0005e80000000800ULL,
0x0004000b24007388ULL, 0x0005e80000000800ULL, 0x0004001125007388ULL, 0x0005e80000000800ULL,
0x0004001326007388ULL, 0x0005e20000000800ULL, 0x000000ffff217224ULL, 0x020fc600078e0022ULL,
0x0004001527007388ULL, 0x0005e80000000800ULL, 0x0004001728007388ULL, 0x0005e80000000800ULL,
0x0004001d29007388ULL, 0x0005e80000000800ULL, 0x0004001f2a007388ULL, 0x0005e80000000800ULL,
0x0180000418008388ULL, 0x0005e80000000c00ULL, 0x0182002018008388ULL, 0x0005e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000003fff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000008003fff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000010003fff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000140407810ULL, 0x000fe20007ffe0ffULL,
0x000018003fff7f8cULL, 0x0003e6000c80043fULL, 0x0000000e4000720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffa6c000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff447807ULL, 0x008fe20004000000ULL,
0xffffffffff467424ULL, 0x000fe200078e00ffULL, 0x000221b000457802ULL, 0x000fc40000000f00ULL,
0x000013b000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff1d7224ULL, 0x000fe200078e0046ULL,
0xfffdfe9000007947ULL, 0x000fea000383ffffULL, 0x00000001ff447807ULL, 0x000fe20005000000ULL,
0xffffffffff467424ULL, 0x000fe200078e00ffULL, 0x0002221000457802ULL, 0x000fc40000000f00ULL,
0x0000135000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff1d7224ULL, 0x000fe200078e0046ULL,
0xfffdfec000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5e7224ULL, 0x004fe200078e001eULL,
0x0002228000447802ULL, 0x000fe20000000f00ULL, 0x0000001fff457424ULL, 0x000fe400078e00ffULL,
0xffffffffff467424ULL, 0x000fc400078e00ffULL, 0x000012a000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff477224ULL, 0x004fe200078e0046ULL, 0xfffdff4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5e7224ULL, 0x000fe200078e001eULL, 0x000222f000447802ULL, 0x000fe20000000f00ULL,
0x0000001fff457424ULL, 0x000fc400078e00ffULL, 0xffffffffff467424ULL, 0x000fc400078e00ffULL,
0x0000123000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff477224ULL, 0x004fe200078e0046ULL,
0xfffe004000007947ULL, 0x000fea000383ffffULL, 0x000000ffff477224ULL, 0x000fe200078e001bULL,
0x0002236000447802ULL, 0x000fe20000000f00ULL, 0x0000001fff457424ULL, 0x000fe400078e00ffULL,
0xffffffffff467424ULL, 0x000fc400078e00ffULL, 0x000011c000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff197224ULL, 0x004fe200078e0046ULL, 0xfffe042000007947ULL, 0x000fea000383ffffULL,
0x000000ffff477224ULL, 0x000fe200078e001aULL, 0x000223d000447802ULL, 0x000fe20000000f00ULL,
0x0000001fff457424ULL, 0x000fe400078e00ffULL, 0xffffffffff467424ULL, 0x000fc400078e00ffULL,
0x0000115000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff1a7224ULL, 0x004fe200078e0046ULL,
0xfffe03e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff477224ULL, 0x000fe200078e0026ULL,
0x0002244000447802ULL, 0x000fe20000000f00ULL, 0x0000001fff457424ULL, 0x000fc400078e00ffULL,
0xffffffffff467424ULL, 0x000fc400078e00ffULL, 0x000010e000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff197224ULL, 0x004fe200078e0046ULL, 0xfffe311000007947ULL, 0x000fea000383ffffULL,
0x000000ffff477224ULL, 0x000fe200078e001aULL, 0x000224b000447802ULL, 0x000fe20000000f00ULL,
0x0000001fff457424ULL, 0x000fe400078e00ffULL, 0xffffffffff467424ULL, 0x000fc400078e00ffULL,
0x0000107000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff1a7224ULL, 0x004fe200078e0046ULL,
0xfffe30d000007947ULL, 0x000fea000383ffffULL, 0x00000001ff447807ULL, 0x008fe20004000000ULL,
0xffffffffff467424ULL, 0x000fe200078e00ffULL, 0x0002251000457802ULL, 0x000fc40000000f00ULL,
0x0000105000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff497224ULL, 0x000fe200078e0046ULL,
0xfffe5e8000007947ULL, 0x000fea000383ffffULL, 0x00000001ff447807ULL, 0x000fe20005000000ULL,
0xffffffffff467424ULL, 0x000fe200078e00ffULL, 0x0002257000457802ULL, 0x000fc40000000f00ULL,
0x00000ff000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff437224ULL, 0x000fe200078e0046ULL,
0xfffe5eb000007947ULL, 0x000fea000383ffffULL, 0x000000ffff477224ULL, 0x000fe200078e0044ULL,
0x000225e000447802ULL, 0x000fe20000000f00ULL, 0x0000001fff457424ULL, 0x000fc400078e00ffULL,
0xffffffffff467424ULL, 0x000fc400078e00ffULL, 0x00000f4000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff447224ULL, 0x004fe200078e0046ULL, 0xfffe5f5000007947ULL, 0x000fea000383ffffULL,
0x000000ffff477224ULL, 0x000fe200078e0044ULL, 0x0002265000447802ULL, 0x000fe20000000f00ULL,
0x0000001fff457424ULL, 0x000fe400078e00ffULL, 0xffffffffff467424ULL, 0x000fc400078e00ffULL,
0x00000ed000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff447224ULL, 0x004fe200078e0046ULL,
0xfffe604000007947ULL, 0x000fea000383ffffULL, 0x000000ffff477224ULL, 0x000fe200078e0041ULL,
0x000226c000447802ULL, 0x000fe20000000f00ULL, 0x0000001fff457424ULL, 0x000fe400078e00ffULL,
0xffffffffff467424ULL, 0x000fc400078e00ffULL, 0x00000e6000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff197224ULL, 0x004fe200078e0046ULL, 0xfffe646000007947ULL, 0x000fea000383ffffULL,
0x000000ffff477224ULL, 0x000fe200078e001aULL, 0x0002273000447802ULL, 0x000fe20000000f00ULL,
0x0000001fff457424ULL, 0x000fc400078e00ffULL, 0xffffffffff467424ULL, 0x000fc400078e00ffULL,
0x00000df000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff1a7224ULL, 0x004fe200078e0046ULL,
0xfffe642000007947ULL, 0x000fea000383ffffULL, 0x000000ffff477224ULL, 0x000fe200078e0034ULL,
0x000227a000447802ULL, 0x000fe20000000f00ULL, 0x0000001fff457424ULL, 0x000fe400078e00ffULL,
0xffffffffff467424ULL, 0x000fc400078e00ffULL, 0x00000d8000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff197224ULL, 0x004fe200078e0046ULL, 0xfffe8f6000007947ULL, 0x000fea000383ffffULL,
0x000000ffff477224ULL, 0x000fe200078e001aULL, 0x0002281000447802ULL, 0x000fe20000000f00ULL,
0x0000001fff457424ULL, 0x000fe400078e00ffULL, 0xffffffffff467424ULL, 0x000fc400078e00ffULL,
0x00000d1000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff1a7224ULL, 0x004fe200078e0046ULL,
0xfffe8f2000007947ULL, 0x000fea000383ffffULL, 0x00000001ff447807ULL, 0x002fe20004000000ULL,
0xffffffffff467424ULL, 0x000fe200078e00ffULL, 0x0002287000457802ULL, 0x000fc40000000f00ULL,
0x00000cf000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff497224ULL, 0x000fe200078e0046ULL,
0xfffebb6000007947ULL, 0x000fea000383ffffULL, 0x00000001ff447807ULL, 0x000fe20005000000ULL,
0xffffffffff467424ULL, 0x000fe200078e00ffULL, 0x000228d000457802ULL, 0x000fc40000000f00ULL,
0x00000c9000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff4a7224ULL, 0x000fe200078e0046ULL,
0xfffebb8000007947ULL, 0x000fea000383ffffULL, 0x000000ffff477224ULL, 0x000fe200078e0044ULL,
0x0002294000447802ULL, 0x000fe20000000f00ULL, 0x0000001fff457424ULL, 0x000fc400078e00ffULL,
0xffffffffff467424ULL, 0x000fc400078e00ffULL, 0x00000be000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff447224ULL, 0x004fe200078e0046ULL, 0xfffebc2000007947ULL, 0x000fea000383ffffULL,
0x000000ffff477224ULL, 0x000fe200078e0044ULL, 0x000229b000447802ULL, 0x000fe20000000f00ULL,
0x0000001fff457424ULL, 0x000fe400078e00ffULL, 0xffffffffff467424ULL, 0x000fc400078e00ffULL,
0x00000b7000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff447224ULL, 0x004fe200078e0046ULL,
0xfffebd1000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5e7224ULL, 0x00afe200078e0014ULL,
0x00022a3000447802ULL, 0x000fe20000000f00ULL, 0x000000ffff477224ULL, 0x000fe400078e0041ULL,
0x0000001fff457424ULL, 0x000fc400078e00ffULL, 0xffffffffff467424ULL, 0x000fc400078e00ffULL,
0x00000af000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff197224ULL, 0x004fe200078e0046ULL,
0xfffec10000007947ULL, 0x000fea000383ffffULL, 0x000000ffff477224ULL, 0x000fe200078e001aULL,
0x00022ab000447802ULL, 0x000fe20000000f00ULL, 0x000000ffff5e7224ULL, 0x00afe400078e0014ULL,
0x0000001fff457424ULL, 0x000fe400078e00ffULL, 0xffffffffff467424ULL, 0x000fc400078e00ffULL,
0x00000a7000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff1a7224ULL, 0x004fe200078e0046ULL,
0xfffec0b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5e7224ULL, 0x000fe200078e0014ULL,
0x00022b3000447802ULL, 0x000fe20000000f00ULL, 0x000000ffff477224ULL, 0x000fc400078e0034ULL,
0x0000001fff457424ULL, 0x000fe400078e00ffULL, 0xffffffffff467424ULL, 0x000fc400078e00ffULL,
0x000009f000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff197224ULL, 0x004fe200078e0046ULL,
0xfffeec0000007947ULL, 0x000fea000383ffffULL, 0x000000ffff477224ULL, 0x000fe200078e001aULL,
0x00022bb000447802ULL, 0x000fe20000000f00ULL, 0x000000ffff5e7224ULL, 0x000fe400078e0014ULL,
0x0000001fff457424ULL, 0x000fe400078e00ffULL, 0xffffffffff467424ULL, 0x000fc400078e00ffULL,
0x0000097000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff1a7224ULL, 0x004fe200078e0046ULL,
0xfffeebb000007947ULL, 0x000fea000383ffffULL, 0x00000001ff447807ULL, 0x008fe20004000000ULL,
0xffffffffff467424ULL, 0x000fe200078e00ffULL, 0x00022c1000457802ULL, 0x000fc40000000f00ULL,
0x0000095000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff487224ULL, 0x000fe200078e0046ULL,
0xffff189000007947ULL, 0x000fea000383ffffULL, 0x00000001ff447807ULL, 0x000fe20004800000ULL,
0xffffffffff467424ULL, 0x000fe200078e00ffULL, 0x00022c7000457802ULL, 0x000fc40000000f00ULL,
0x000008f000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff497224ULL, 0x000fe200078e0046ULL,
0xffff18b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff477224ULL, 0x000fe200078e0017ULL,
0x00022ce000447802ULL, 0x000fe20000000f00ULL, 0x0000001fff457424ULL, 0x000fc400078e00ffULL,
0xffffffffff467424ULL, 0x000fc400078e00ffULL, 0x0000084000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff177224ULL, 0x004fe200078e0046ULL, 0xffff195000007947ULL, 0x000fea000383ffffULL,
0x000000ffff477224ULL, 0x000fe200078e0017ULL, 0x00022d5000447802ULL, 0x000fe20000000f00ULL,
0x0000001fff457424ULL, 0x000fe400078e00ffULL, 0xffffffffff467424ULL, 0x000fc400078e00ffULL,
0x000007d000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff177224ULL, 0x004fe200078e0046ULL,
0xffff1a4000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5e7224ULL, 0x008fe200078e0014ULL,
0x00022dd000447802ULL, 0x000fe20000000f00ULL, 0x000000ffff477224ULL, 0x000fe400078e0017ULL,
0x0000001fff457424ULL, 0x000fc400078e00ffULL, 0xffffffffff467424ULL, 0x000fc400078e00ffULL,
0x0000075000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff197224ULL, 0x004fe200078e0046ULL,
0xffff1e3000007947ULL, 0x000fea000383ffffULL, 0x000000ffff477224ULL, 0x000fe200078e001aULL,
0x00022e5000447802ULL, 0x000fe20000000f00ULL, 0x000000ffff5e7224ULL, 0x008fe400078e0014ULL,
0x0000001fff457424ULL, 0x000fe400078e00ffULL, 0xffffffffff467424ULL, 0x000fc400078e00ffULL,
0x000006d000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff1a7224ULL, 0x004fe200078e0046ULL,
0xffff1de000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5e7224ULL, 0x000fe200078e0014ULL,
0x00022ed000447802ULL, 0x000fe20000000f00ULL, 0x000000ffff477224ULL, 0x000fc400078e0016ULL,
0x0000001fff457424ULL, 0x000fe400078e00ffULL, 0xffffffffff467424ULL, 0x000fc400078e00ffULL,
0x0000065000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff197224ULL, 0x004fe200078e0046ULL,
0xffff495000007947ULL, 0x000fea000383ffffULL, 0x000000ffff477224ULL, 0x000fe200078e001aULL,
0x00022f5000447802ULL, 0x000fe20000000f00ULL, 0x000000ffff5e7224ULL, 0x000fe400078e0014ULL,
0x0000001fff457424ULL, 0x000fe400078e00ffULL, 0xffffffffff467424ULL, 0x000fc400078e00ffULL,
0x000005d000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff1a7224ULL, 0x004fe200078e0046ULL,
0xffff490000007947ULL, 0x000fea000383ffffULL, 0x000000ffff087224ULL, 0x000fe200078e0032ULL,
0x00022fd000307802ULL, 0x000fe20000000f00ULL, 0x00000002ff097424ULL, 0x000fc400078e00ffULL,
0x0000001fff317424ULL, 0x000fe400078e00ffULL, 0xffffffffff337424ULL, 0x000fc400078e00ffULL,
0x0000050000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0031ULL,
0xffffe3f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff087224ULL, 0x000fe200078e0005ULL,
0x0002305000307802ULL, 0x000fe20000000f00ULL, 0x00000002ff097424ULL, 0x000fe400078e00ffULL,
0x0000001fff317424ULL, 0x000fe400078e00ffULL, 0xffffffffff337424ULL, 0x000fc400078e00ffULL,
0x0000048000007944ULL, 0x012fea0003c00000ULL, 0x000000310500720bULL, 0x004fe20003f1e000ULL,
0x000000ffff087224ULL, 0x000fe200078e0006ULL, 0x000230d000307802ULL, 0x000fe20000000f00ULL,
0x00000002ff097424ULL, 0x000fe200078e00ffULL, 0x0000000531057208ULL, 0x000fe20004000000ULL,
0x0000001fff317424ULL, 0x000fc400078e00ffULL, 0xffffffffff337424ULL, 0x000fc400078e00ffULL,
0x0000040000007944ULL, 0x000fea0003c00000ULL, 0x000000310600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff087224ULL, 0x000fe200078e0007ULL, 0x0002315000307802ULL, 0x000fe20000000f00ULL,
0x00000002ff097424ULL, 0x000fe200078e00ffULL, 0x0000000631067208ULL, 0x000fe20004000000ULL,
0x0000001fff317424ULL, 0x000fe400078e00ffULL, 0xffffffffff337424ULL, 0x000fc400078e00ffULL,
0x0000038000007944ULL, 0x000fea0003c00000ULL, 0x000000310700720bULL, 0x004fe20003f1e000ULL,
0x000000ffff087224ULL, 0x000fe200078e0032ULL, 0x000231d000307802ULL, 0x000fe20000000f00ULL,
0x00000001ff097424ULL, 0x000fe200078e00ffULL, 0x0000000731077208ULL, 0x000fe20004000000ULL,
0x0000001fff317424ULL, 0x000fc400078e00ffULL, 0xffffffffff337424ULL, 0x000fc400078e00ffULL,
0x0000030000007944ULL, 0x000fea0003c00000ULL, 0x000000313200720bULL, 0x004fe20003f1e000ULL,
0x000000ffff087224ULL, 0x000fe200078e0005ULL, 0x0002325000307802ULL, 0x000fe20000000f00ULL,
0x00000001ff097424ULL, 0x000fe200078e00ffULL, 0x0000003231047208ULL, 0x000fe20004000000ULL,
0x0000001fff317424ULL, 0x000fe400078e00ffULL, 0xffffffffff337424ULL, 0x000fc400078e00ffULL,
0x0000028000007944ULL, 0x000fea0003c00000ULL, 0x000000310500720bULL, 0x004fe20003f1e000ULL,
0x000000ffff087224ULL, 0x000fe200078e0006ULL, 0x000232d000307802ULL, 0x000fe20000000f00ULL,
0x00000001ff097424ULL, 0x000fe200078e00ffULL, 0x0000000531057208ULL, 0x000fe20004000000ULL,
0x0000001fff317424ULL, 0x000fc400078e00ffULL, 0xffffffffff337424ULL, 0x000fc400078e00ffULL,
0x0000020000007944ULL, 0x000fea0003c00000ULL, 0x000000310600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff087224ULL, 0x000fe200078e0007ULL, 0x0002335000307802ULL, 0x000fe20000000f00ULL,
0x00000001ff097424ULL, 0x000fe200078e00ffULL, 0x0000000631067208ULL, 0x000fe20004000000ULL,
0x0000001fff317424ULL, 0x000fe400078e00ffULL, 0xffffffffff337424ULL, 0x000fc400078e00ffULL,
0x0000018000007944ULL, 0x000fea0003c00000ULL, 0xffffe1e000007947ULL, 0x000fea000383ffffULL,
0x0180000003007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000057812ULL, 0x000fc800078ec0ffULL, 0x018000000500780cULL, 0x000fda0003f05070ULL,
0x0000000300008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0500720cULL, 0x040fe40003f25070ULL, 0x008000000500780cULL, 0x000fe40003f02070ULL,
0x00000001ff057807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000005ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff03ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000003037812ULL, 0x002fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000005ff7212ULL, 0x000fda000780c0ffULL,
0x0080000003000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0003ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000300007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000ff057424ULL, 0x000fc800078e00ffULL,
0xfffdcb3004007950ULL, 0x000fea0003c3ffffULL, 0x0000003300007348ULL, 0x000fe80003800000ULL,
0x0c00000908317389ULL, 0x0002a400000e0031ULL, 0x000000ffff087224ULL, 0x002fe400078e0030ULL,
0x00000000ff097424ULL, 0x000fc800078e00ffULL, 0xfffdcae008007950ULL, 0x000fea0003c3ffffULL,
0x0000004600007348ULL, 0x000fe80003800000ULL, 0x000000475e467389ULL, 0x0002a400000e0045ULL,
0x00000000ff457424ULL, 0x002fc800078e00ffULL, 0xfffdcaa044007950ULL, 0x000fea0003c3ffffULL,
0x000000014400780cULL, 0x000fe20003f45070ULL, 0x0000004600007348ULL, 0x000fd80003800000ULL,
0x0000000000447806ULL, 0x000fc800050e0100ULL, 0x0000004644467212ULL, 0x000fe200078ec0ffULL,
0x000000ffff447224ULL, 0x000fe400078e0045ULL, 0x00000000ff457424ULL, 0x000fc800078e00ffULL,
0xfffdca3044007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000100000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005e7ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000748ULL, 0x0000000000000288ULL, 0x0000001a00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009d0ULL, 0x0000000000000460ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e30ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000ef0ULL, 0x0000000000000a08ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000018f8ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001908ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000007bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001998ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x000000000000199cULL, 0x00000000000001b0ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001b80ULL, 0x0000000000023680ULL, 0xf100001a00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x0000000100000089ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000025200ULL, 0x0000000000000044ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000025250ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x00000000000255d0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001998ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000023868ULL, 0x0000000000023868ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000025200ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x00000000000255d0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_1_kvt_int8_pagedKV_128_nqpkv_8_m_8_sm_80_cubin_len = 153264;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
