/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_1_kvt_int8_pagedKV_128_nqpkv_8_m_8_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x00000000000236d0ULL, 0x0000000000023350ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f34314944327961ULL, 0x6f6c66625f766e5fULL,
0x326a4c3236317461ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL,
0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x336a4c4536316a4cULL, 0x4c49746132454532ULL,
0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45346a4c4534366aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL,
0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL,
0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL, 0x45326a4c4545316aULL, 0x7461324545316a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x4939494432796172ULL, 0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL,
0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL,
0x4c4545346a4c6a49ULL, 0x36316a4c4532336aULL, 0x624c497461324545ULL, 0x31534b5245454531ULL,
0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL,
0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL, 0x4c4545326a4c4532ULL, 0x4545316a4c45326aULL,
0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x45386a4c4545346aULL,
0x7461324545386a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL,
0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL,
0x6a4c4536316a4c45ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5f2400676e696469ULL, 0x616e7265746e695fULL, 0x635f5f245f305f6cULL,
0x30326d735f616475ULL, 0x5f6e725f7063725fULL, 0x5f3233665f7a7466ULL, 0x68746170776f6c73ULL,
0x65746e695f5f2400ULL, 0x245f315f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL,
0x6c66625f636e7973ULL, 0x695f5f2400705f79ULL, 0x5f6c616e7265746eULL, 0x6475635f5f245f32ULL,
0x735f30376d735f61ULL, 0x5f636e79736c6668ULL, 0x5f2400705f786469ULL, 0x616e7265746e695fULL,
0x635f5f245f335f6cULL, 0x30376d735f616475ULL, 0x6e797365746f765fULL, 0x746f6c6c61625f63ULL,
0x742e616c65722e00ULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL,
0x5f6c656e72656b2eULL, 0x72656b240061686dULL, 0x2461686d5f6c656eULL, 0x657479426d656d73ULL,
0x2e766e2e00667542ULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x61705f0061686d5fULL,
0x6265642e006d6172ULL, 0x656d6172665f6775ULL, 0x65642e6c65722e00ULL, 0x6d6172665f677562ULL,
0x2e616c65722e0065ULL, 0x72665f6775626564ULL, 0x2e766e2e00656d61ULL, 0x697463612e6c6572ULL,
0x0000000000006e6fULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c0001000000adULL, 0x0000000000000034ULL, 0x0000000000000010ULL, 0x000c0001000000ebULL,
0x000000000000001cULL, 0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c00010000016bULL, 0x000000000000002cULL, 0x0000000000000004ULL,
0x000c0001000001b5ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c0001000001fbULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000242ULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000c000100000288ULL, 0x0000000000000030ULL, 0x0000000000000004ULL,
0x000c0001000002d6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c000100000324ULL,
0x0000000000000018ULL, 0x0000000000000004ULL, 0x000c000100000372ULL, 0x000000000000000cULL,
0x0000000000000004ULL, 0x000c0001000003b9ULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000c000100000407ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c00010000044cULL,
0x0000000000000020ULL, 0x0000000000000004ULL, 0x000b002200000492ULL, 0x0000000000021390ULL,
0x0000000000000170ULL, 0x000b0022000004c5ULL, 0x0000000000021500ULL, 0x0000000000000050ULL,
0x000b0022000004f0ULL, 0x0000000000021550ULL, 0x0000000000000040ULL, 0x000b00220000051aULL,
0x0000000000021590ULL, 0x0000000000000170ULL, 0x000a000300000588ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00040003000005a8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00070003000005d8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL,
0x0000000000000000ULL, 0x0000000000021700ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0002139000000000ULL,
0x0000040400000000ULL, 0x810c0000015c0400ULL, 0x00837c0400288080ULL, 0x0000000000000000ULL,
0x000000dcffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x80808e0828808081ULL, 0x9a082880808f0828ULL, 0x2880809d08288080ULL,
0x80a108288080a008ULL, 0x08288080a2082880ULL, 0x8080a808288080a5ULL, 0xab08288080aa0828ULL,
0x288080ae08288080ULL, 0x80b108288080b008ULL, 0x08288080b4082880ULL, 0x8080b808288080b5ULL,
0xbd08288080bc0828ULL, 0x288080be08288080ULL, 0x80c408288080bf08ULL, 0x08288080c6082880ULL,
0x8080c808288080c7ULL, 0xca08288080c90828ULL, 0x288080cb08288080ULL, 0x80cd08288080cc08ULL,
0x08288080ce082880ULL, 0x8082801628808084ULL, 0x0000000000031028ULL, 0x2880808492000000ULL,
0x0000000000002200ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL, 0x0002139000000000ULL,
0x0000017000000000ULL, 0x0000000000000000ULL, 0x000000ecffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL,
0x8a08288080880828ULL, 0x2880808c08288080ULL, 0x8091082880809008ULL, 0x082880809a082880ULL,
0x8080a0082880809dULL, 0xa208288080a10828ULL, 0x288080a508288080ULL, 0x80aa08288080a808ULL,
0x08288080ab082880ULL, 0x8080af08288080aeULL, 0xb408288080b10828ULL, 0x288080b508288080ULL,
0x80bc08288080b808ULL, 0x08288080bd082880ULL, 0x8080bf08288080beULL, 0xc608288080c40828ULL,
0x288080c708288080ULL, 0x80c908288080c808ULL, 0x08288080ca082880ULL, 0x8080cd08288080ccULL,
0xb008288080ce0828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x00288080b0920000ULL,
0x0000000000000022ULL, 0x0000002cffffffffULL, 0x0000018000000000ULL, 0x0002150000000000ULL,
0x0000005000000000ULL, 0x00000c0400000000ULL, 0x8088288080b00900ULL, 0x0000000000002880ULL,
0x000000e4ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x80808a0828808081ULL, 0x90082880808c0828ULL, 0x2880809108288080ULL,
0x809d082880809a08ULL, 0x08288080a0082880ULL, 0x8080a208288080a1ULL, 0xa808288080a50828ULL,
0x288080aa08288080ULL, 0x80ae08288080ab08ULL, 0x08288080af082880ULL, 0x8080b108288080b0ULL,
0xb508288080b40828ULL, 0x288080b808288080ULL, 0x80bd08288080bc08ULL, 0x08288080be082880ULL,
0x8080c408288080bfULL, 0xc708288080c60828ULL, 0x288080c808288080ULL, 0x80ca08288080c908ULL,
0x08288080cb082880ULL, 0x8080ce08288080cdULL, 0x8016288080cc0828ULL, 0x0000000310288082ULL,
0x80cc920000000000ULL, 0x0000000022002880ULL, 0x0000001cffffffffULL, 0x000002b000000000ULL,
0x0002155000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x000000e4ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x80808a0828808081ULL, 0x90082880808c0828ULL, 0x2880809108288080ULL, 0x809d082880809a08ULL,
0x08288080a0082880ULL, 0x8080a208288080a1ULL, 0xa808288080a50828ULL, 0x288080aa08288080ULL,
0x80ae08288080ab08ULL, 0x08288080af082880ULL, 0x8080b108288080b0ULL, 0xb508288080b40828ULL,
0x288080b808288080ULL, 0x80be08288080bc08ULL, 0x08288080bf082880ULL, 0x8080c608288080c4ULL,
0xc808288080c70828ULL, 0x288080c908288080ULL, 0x80cb08288080ca08ULL, 0x08288080cc082880ULL,
0x8080ce08288080cdULL, 0x8016288080bd0828ULL, 0x0000000310288082ULL, 0x80bd920000000000ULL,
0x0000000022002880ULL, 0x0000002cffffffffULL, 0x000003c800000000ULL, 0x0002159000000000ULL,
0x0000017000000000ULL, 0x0000140400000000ULL, 0x80bc288080bd0900ULL, 0x0000000000002880ULL,
0x0000001a00082f04ULL, 0x00082304000000edULL, 0x0000000000000016ULL, 0x0000001600081204ULL,
0x0008110400000000ULL, 0x0000000000000016ULL, 0x0000001500082304ULL, 0x0008120400000000ULL,
0x0000000000000015ULL, 0x0000001500081104ULL, 0x0008230400000000ULL, 0x0000000000000014ULL,
0x0000001400081204ULL, 0x0008110400000000ULL, 0x0000000000000014ULL, 0x0000001300082304ULL,
0x0008120400000000ULL, 0x0000000000000013ULL, 0x0000001300081104ULL, 0x0008230400000000ULL,
0x000000000000001aULL, 0x0000001a00081204ULL, 0x0008110400000000ULL, 0x000000000000001aULL,
0x0000007b00043704ULL, 0x0000001700080a04ULL, 0x0050190300500160ULL, 0x00000000000c1704ULL,
0x0021f00000480006ULL, 0x00000000000c1704ULL, 0x0021f00000400005ULL, 0x00000000000c1704ULL,
0x0011f00000380004ULL, 0x00000000000c1704ULL, 0x0081f00000180003ULL, 0x00000000000c1704ULL,
0x0021f00000100002ULL, 0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL,
0x0011f00000000000ULL, 0x0004310400ff1b03ULL, 0x0198290400000020ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000000e001982804ULL, 0x0000047000000100ULL,
0x0000211000002060ULL, 0x0000237000002200ULL, 0x000027f0000027c0ULL, 0x0000289000002840ULL,
0x000055a000005570ULL, 0x00005640000055f0ULL, 0x0000842000008390ULL, 0x0000869000008530ULL,
0x00008b5000008b20ULL, 0x00008bf000008ba0ULL, 0x0000b7100000b6e0ULL, 0x0000b7b00000b760ULL,
0x0000e4100000e390ULL, 0x0000e6800000e520ULL, 0x0000eb200000eaf0ULL, 0x0000ebc00000eb70ULL,
0x000116e0000116b0ULL, 0x0001178000011730ULL, 0x00014460000143e0ULL, 0x000146d000014570ULL,
0x00014b7000014b40ULL, 0x00014c1000014bc0ULL, 0x0001775000017720ULL, 0x000177f0000177a0ULL,
0x000198d0000198c0ULL, 0x0001f7c00001a0a0ULL, 0x0001f8100001f800ULL, 0x0001f8700001f820ULL,
0x0001f8b00001f890ULL, 0x000205800001f8c0ULL, 0x00020620000205d0ULL, 0x000206b000020660ULL,
0x0002077000020710ULL, 0x00020820000207d0ULL, 0x000208d000020870ULL, 0x0002099000020930ULL,
0x00020a50000209f0ULL, 0x00020b0000020ab0ULL, 0x00020bb000020b50ULL, 0x00020c7000020c10ULL,
0x00020d3000020cd0ULL, 0x00020de000020d90ULL, 0x00020e9000020e30ULL, 0x00020f5000020ef0ULL,
0x0002101000020fb0ULL, 0x000210d000021070ULL, 0x0002119000021130ULL, 0x00021250000211f0ULL,
0x00021310000212b0ULL, 0x0600390400021370ULL, 0x000000ff00000200ULL, 0x003f010000010600ULL,
0x0000000d000002d0ULL, 0x003f012000010608ULL, 0x0000000d00000300ULL, 0x003f012000010688ULL,
0x0000000d00000440ULL, 0x003f0120000106a8ULL, 0x000000ff00000460ULL, 0x003f0100000106b8ULL,
0x000000ff000004f0ULL, 0x003f010700010600ULL, 0x0000002700000640ULL, 0x003f01020001068cULL,
0x00000027000006a0ULL, 0x003f010100010688ULL, 0x000000ff00000f00ULL, 0x003f0107000106a8ULL,
0x000000ff00001020ULL, 0x003f0101000106a8ULL, 0x000000ff00001080ULL, 0x003f0101000106b8ULL,
0x000000ff00001210ULL, 0x003f0105000106bcULL, 0x000000ff000013e0ULL, 0x003f0105000106bcULL,
0x000000ff00001ca0ULL, 0x003f0107000106b0ULL, 0x000000ff00001d20ULL, 0x003f0101000106b0ULL,
0x0000002700001d80ULL, 0x003f010100010608ULL, 0x0000002700001da0ULL, 0x003f01050001060cULL,
0x0000002700001f70ULL, 0x003f01050001060cULL, 0x000000ff00002520ULL, 0x003f0105000106acULL,
0x000000ff000026f0ULL, 0x003f0105000106acULL, 0x000000ff00004800ULL, 0x003f0101000106b8ULL,
0x000000ff00004830ULL, 0x003f0105000106bcULL, 0x000000ff000049f0ULL, 0x003f0105000106bcULL,
0x000000ff00005240ULL, 0x003f0107000106a8ULL, 0x000000ff000052c0ULL, 0x003f0101000106a8ULL,
0x000000ff000052f0ULL, 0x003f0105000106b4ULL, 0x000000ff000054c0ULL, 0x003f0105000106b4ULL,
0x000000ff000074d0ULL, 0x003f0101000106b8ULL, 0x000000ff00007540ULL, 0x003f010100010688ULL,
0x000000ff00007590ULL, 0x003f0105000106bcULL, 0x000000ff00007760ULL, 0x003f0105000106bcULL,
0x000000ff00007fb0ULL, 0x003f0107000106b0ULL, 0x000000ff000080b0ULL, 0x003f0101000106b0ULL,
0x0000002700008110ULL, 0x003f010100010628ULL, 0x0000002700008130ULL, 0x003f01050001062cULL,
0x0000002700008300ULL, 0x003f01050001062cULL, 0x000000ff00008880ULL, 0x003f0105000106acULL,
0x000000ff00008a50ULL, 0x003f0105000106acULL, 0x000000ff0000a970ULL, 0x003f0101000106b8ULL,
0x000000ff0000a9a0ULL, 0x003f0105000106bcULL, 0x000000ff0000ab60ULL, 0x003f0105000106bcULL,
0x000000ff0000b3b0ULL, 0x003f0107000106a8ULL, 0x000000ff0000b430ULL, 0x003f0101000106a8ULL,
0x000000ff0000b460ULL, 0x003f0105000106b4ULL, 0x000000ff0000b630ULL, 0x003f0105000106b4ULL,
0x000000ff0000d540ULL, 0x003f0101000106b8ULL, 0x000000ff0000d5b0ULL, 0x003f010100010690ULL,
0x000000ff0000d610ULL, 0x003f0105000106bcULL, 0x000000ff0000d7e0ULL, 0x003f0105000106bcULL,
0x000000ff0000e030ULL, 0x003f0107000106b0ULL, 0x000000ff0000e0b0ULL, 0x003f0101000106b0ULL,
0x000000270000e110ULL, 0x003f010100010648ULL, 0x000000270000e130ULL, 0x003f01050001064cULL,
0x000000270000e300ULL, 0x003f01050001064cULL, 0x000000ff0000e850ULL, 0x003f0105000106acULL,
0x000000ff0000ea20ULL, 0x003f0105000106acULL, 0x000000ff00010940ULL, 0x003f0101000106b8ULL,
0x000000ff00010970ULL, 0x003f0105000106bcULL, 0x000000ff00010b30ULL, 0x003f0105000106bcULL,
0x000000ff00011380ULL, 0x003f0107000106a8ULL, 0x000000ff00011400ULL, 0x003f0101000106a8ULL,
0x000000ff00011430ULL, 0x003f0105000106b4ULL, 0x000000ff00011600ULL, 0x003f0105000106b4ULL,
0x000000ff00013510ULL, 0x003f0101000106b8ULL, 0x000000ff00013580ULL, 0x003f010100010698ULL,
0x000000ff000135e0ULL, 0x003f0105000106bcULL, 0x000000ff000137b0ULL, 0x003f0105000106bcULL,
0x000000ff00014000ULL, 0x003f0107000106b0ULL, 0x000000ff00014100ULL, 0x003f0101000106b0ULL,
0x0000002700014160ULL, 0x003f010100010668ULL, 0x0000002700014180ULL, 0x003f01050001066cULL,
0x0000002700014350ULL, 0x003f01050001066cULL, 0x000000ff000148a0ULL, 0x003f0105000106acULL,
0x000000ff00014a70ULL, 0x003f0105000106acULL, 0x000000ff00016990ULL, 0x003f0101000106b8ULL,
0x000000ff000169c0ULL, 0x003f0105000106bcULL, 0x000000ff00016b80ULL, 0x003f0105000106bcULL,
0x000000ff000173f0ULL, 0x003f0107000106a8ULL, 0x000000ff00017470ULL, 0x003f0101000106a8ULL,
0x000000ff000174a0ULL, 0x003f0105000106b4ULL, 0x000000ff00017670ULL, 0x003f0105000106b4ULL,
0x000000ff00019580ULL, 0x003f0101000106b8ULL, 0x000000ff000195e0ULL, 0x003f0101000106a0ULL,
0x000000ff0001a330ULL, 0x003f010100010600ULL, 0x000000ff0001b0e0ULL, 0x003f010500010604ULL,
0x000000ff0001b2b0ULL, 0x003f010500010604ULL, 0x000000ff0001b620ULL, 0x003f010100010600ULL,
0x000000ff0001b650ULL, 0x003f010500010604ULL, 0x000000ff0001b810ULL, 0x003f010500010604ULL,
0x000000400001ebc0ULL, 0x003f010100000000ULL, 0x000000400001ecf0ULL, 0x003f010500000004ULL,
0x000000400001eec0ULL, 0x003f010500000004ULL, 0x00000042000203e0ULL, 0x003f010100000000ULL,
0x0000004200020440ULL, 0x003f010100000008ULL, 0x00000042000204a0ULL, 0x003f010100000010ULL,
0x0000004200020510ULL, 0x003f010100000018ULL, 0x00101c0400053803ULL, 0x0001b8700001a1e0ULL,
0x000205500001b930ULL, 0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL,
0x0000000000000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x00000000000004ccULL,
0x0000001a00000002ULL, 0x00000000000003b4ULL, 0x0000001a00000002ULL, 0x000000000000028cULL,
0x0000001a00000002ULL, 0x000000000000016cULL, 0x0000001a00000002ULL, 0x0000000000000044ULL,
0x0000001a00000002ULL, 0x00000000000004a5ULL, 0x0000001a00000002ULL, 0x000000000000038dULL,
0x0000001a00000002ULL, 0x0000000000000262ULL, 0x0000001a00000002ULL, 0x0000000000000143ULL,
0x0000001a00000002ULL, 0x0000000000010700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x00000000000d7919ULL, 0x000e620000002100ULL,
0x0000000000107806ULL, 0x000fe200038e0000ULL, 0x00005800ff397624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000037919ULL, 0x000ea20000002300ULL,
0x0000001000087300ULL, 0x000fe200000e0000ULL, 0x0000000839077824ULL, 0x000fe400078e00ffULL,
0x0000000000047919ULL, 0x000ee80000002200ULL, 0x0000000000007919ULL, 0x000f220000002600ULL,
0x0000001000137309ULL, 0x000ea60000000000ULL, 0x00000000000a7919ULL, 0x000f280000000000ULL,
0x00000000003e7919ULL, 0x000f220000002700ULL, 0x00000005ff027819ULL, 0x002fc6000001160dULL,
0x00001fff030c7589ULL, 0x0047e200000e0000ULL, 0x000000ffff137224ULL, 0x000fc600078e0a13ULL,
0x00001fff02027589ULL, 0x000e6200000e0000ULL, 0x0000010003037a24ULL, 0x008fe400078e0204ULL,
0x0000000800067824ULL, 0x010fe400078e00ffULL, 0x00000000030d7a24ULL, 0x000fe200078e020dULL,
0x0000000a0800720cULL, 0x000fe20003f02070ULL, 0x0000000000037919ULL, 0x000ea20000000000ULL,
0x0000003e07087224ULL, 0x000fe400078e0206ULL, 0x000000ff0d00720cULL, 0x000fc40003f25270ULL,
0x0000000f0d00780cULL, 0x040fe40003f44070ULL, 0x000000030d00780cULL, 0x040fe40003f64070ULL,
0x0000007f0d00780cULL, 0x000fe20003f84070ULL, 0x000000040c097824ULL, 0x002fcc00078e0202ULL,
0x3fffff80ff049424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff059424ULL, 0x000fe400078e00ffULL,
0x0000000209097824ULL, 0x000fe400078e00ffULL, 0x3fffff60ff06b424ULL, 0x000fe200078e00ffULL,
0x01060004ff009388ULL, 0x0003e20000000a00ULL, 0x7fffff60ff07b424ULL, 0x000fe400078e00ffULL,
0xff317217ff0bc424ULL, 0x000fc400078e00ffULL, 0x00000001090a7824ULL, 0x044fe400078e0203ULL,
0x00000020090f7824ULL, 0x000fe200078e00ffULL, 0x0104000b0d00c388ULL, 0x0005e20000004800ULL,
0x00000010030e7824ULL, 0x000fe400078e00ffULL, 0x3fffffc0ff04a424ULL, 0x002fe200078e00ffULL,
0xffffffe00f0f7812ULL, 0x000fe200078ee20aULL, 0x7fffffc0ff05a424ULL, 0x000fe200078e00ffULL,
0x000001f00e117812ULL, 0x000fe200078ec0ffULL, 0x3fffff80ff0a9424ULL, 0x000fc400078e00ffULL,
0x000000100f0f7824ULL, 0x000fe200078e00ffULL, 0x010608040d00a388ULL, 0x0003e20000008a00ULL,
0x000000010d00780cULL, 0x000fe20003f44070ULL, 0x7fffff80ff0b9424ULL, 0x004fe400078e00ffULL,
0x010688060d00b388ULL, 0x0005e20000008a00ULL, 0x0000000809047817ULL, 0x042fe20007800000ULL,
0x0000000108057824ULL, 0x100fe400078e0209ULL, 0x00000200ff077424ULL, 0x004fe400078e00ffULL,
0x0000000104047824ULL, 0x000fe200078e0a09ULL, 0x0000000109097810ULL, 0x000fc80007ffe0ffULL,
0x000000ff0400720cULL, 0x000fe20003f63070ULL, 0x0000000108067824ULL, 0x000fe200078e0209ULL,
0x000000010400780cULL, 0x000fe20003f83070ULL, 0x00005c0005047625ULL, 0x000fc800078e0007ULL,
0x0000000109107824ULL, 0x040fe200078e0203ULL, 0x0000001104047210ULL, 0x000fe20007fbe0ffULL,
0x0000002009127824ULL, 0x000fe400078e00ffULL, 0x00005c0006067625ULL, 0x000fc600078e0007ULL,
0xffffffe012107812ULL, 0x000fe200078ee210ULL, 0x3fffff00ff08a424ULL, 0x000fe200078e00ffULL,
0x0000001106067210ULL, 0x000fe20007fde0ffULL, 0x7fffff00ff09a424ULL, 0x000fe400078e00ffULL,
0x000000ffff057224ULL, 0x000fe400028e0605ULL, 0x000000ffff077224ULL, 0x000fe200030e0607ULL,
0x0106a8080d00a388ULL, 0x000fe20000008a00ULL, 0x0000001010107824ULL, 0x000fc600078e00ffULL,
0x0106b80aff009388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040f7faeULL, 0x0003e8000d901c46ULL,
0x0000000006107faeULL, 0x0005e2000e101c46ULL, 0x000000ffff047224ULL, 0x002fc400078e0013ULL,
0x00000004ff057424ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x004fe60000000000ULL,
0x000062003e247625ULL, 0x000fe200078e0005ULL, 0x01060404ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01060000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000624247981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0c00720cULL, 0x000fc40003f05270ULL,
0x0000007f24257810ULL, 0x044fe40007ffe0ffULL, 0x000000ff24067810ULL, 0x000fe40007ffe0ffULL,
0x00000007ff257819ULL, 0x000fe40000011625ULL, 0x00000008ff267819ULL, 0x000fca0000011606ULL,
0x00019c0000008947ULL, 0x000fea0003800000ULL, 0x000001ff0600780cULL, 0x000fe20003f24070ULL,
0x0000000802277824ULL, 0x000fe200078e00ffULL, 0x000000ff2500720cULL, 0x000fe20003f05270ULL,
0x00000003ff047424ULL, 0x002fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01068c0427ff738cULL, 0x0003e20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106880027ff7f8cULL, 0x0005e2000c80043fULL, 0xffffffffff287424ULL, 0x000fe200078e00ffULL,
0x0000005000008947ULL, 0x000fea0003800000ULL, 0x000000023e047824ULL, 0x002fe400078e00ffULL,
0x00006400ff067624ULL, 0x000fc800078e00ffULL, 0x0000640004047624ULL, 0x000fc800078e0206ULL,
0x0000600004287625ULL, 0x000fcc00078e0005ULL, 0x0000000628287981ULL, 0x000324000c1e1900ULL,
0x0000580028047a24ULL, 0x012fc800078e02ffULL, 0x0000008004107824ULL, 0x000fe200078e00ffULL,
0x0000043000001947ULL, 0x000fea0003800000ULL, 0x0000002724047217ULL, 0x000fe40007800000ULL,
0x00000004ff057819ULL, 0x000fe40000011603ULL, 0x000000f00e137812ULL, 0x000fe200078ec0ffULL,
0x0000000104047824ULL, 0x000fe200078e0a27ULL, 0x0000000205077810ULL, 0x000fe20007ffe0ffULL,
0x0000000127067824ULL, 0x000fe200078e0205ULL, 0x00000004050a7810ULL, 0x040fe40007ffe0ffULL,
0x000000040500720cULL, 0x080fe20003f06070ULL, 0x0000000127087824ULL, 0x000fe200078e0207ULL,
0x00000006050b7810ULL, 0x000fe20007ffe0ffULL, 0x0000008000057824ULL, 0x000fe200078e0206ULL,
0x000000040700720cULL, 0x080fe20003f26070ULL, 0x0000000106077824ULL, 0x100fe200078e0203ULL,
0x000000040a00720cULL, 0x000fe20003f46070ULL, 0x0000001006097824ULL, 0x000fe200078e00ffULL,
0x00000005100c7210ULL, 0x000fe20007f7e0ffULL, 0x0000000108067824ULL, 0x000fc400078e0203ULL,
0x00000010080f7824ULL, 0x000fe200078e00ffULL, 0xfffffff009077812ULL, 0x000fe200078ee207ULL,
0x000000ffff0d7224ULL, 0x000fe200018e06ffULL, 0x000000040b00720cULL, 0x000fe20003f66070ULL,
0x00000001270a7824ULL, 0x000fe200078e020aULL, 0x0000000205047810ULL, 0x000fe40007ffe0ffULL,
0x00005e000c087a11ULL, 0x000fe400078840ffULL, 0xfffffff00f097812ULL, 0x000fe400078ee206ULL,
0x0000000405067810ULL, 0x000fc40007ffe0ffULL, 0x0000000410127210ULL, 0x000fe20007fde0ffULL,
0x000000010a047824ULL, 0x000fe200078e0203ULL, 0x00005f000c0c7a11ULL, 0x000fe200020f440dULL,
0x000000100a0a7824ULL, 0x000fe200078e00ffULL, 0x0000000605057810ULL, 0x000fe40007ffe0ffULL,
0x00000006100f7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff067224ULL, 0x000fe200030e06ffULL,
0x00005e0012117a11ULL, 0x000fe400078c40ffULL, 0x00000005100d7210ULL, 0x000fe20007fbe0ffULL,
0x0000000127057824ULL, 0x000fe200078e020bULL, 0xfffffff00a0b7812ULL, 0x000fe200078ee204ULL,
0x000000ffff107224ULL, 0x000fe200020e06ffULL, 0x00005f0012127a11ULL, 0x000fe200030f4406ULL,
0x0000000105067824ULL, 0x000fe200078e0203ULL, 0x0000000813047210ULL, 0x000fe20007fde0ffULL,
0x0000001005147824ULL, 0x000fe200078e00ffULL, 0x0000c00007077811ULL, 0x000fe200078e20ffULL,
0x000000ffff0a7224ULL, 0x000fe200028e06ffULL, 0x00005e000f0e7a11ULL, 0x000fe200078840ffULL,
0x000000ffff057224ULL, 0x000fe200030e060cULL, 0x00005e000d087a11ULL, 0x000fc400078a40ffULL,
0xfffffff0140c7812ULL, 0x000fe400078ee206ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004077faeULL, 0x0003e2000c101c46ULL, 0x00005f000f0f7a11ULL, 0x000fe400020f4410ULL,
0x00005f000d0d7a11ULL, 0x000fe400028f440aULL, 0x000000130e067210ULL, 0x080fe40007f9e0ffULL,
0x0000001308087210ULL, 0x000fe40007fbe0ffULL, 0x0000c000090a7811ULL, 0x000fc400078e20ffULL,
0x0000c0000b0b7811ULL, 0x000fe200078e20ffULL, 0x000000ffff077224ULL, 0x002fe200020e060fULL,
0x0000001311047210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff097224ULL, 0x000fe200028e060dULL,
0x0000c0000c0c7811ULL, 0x000fc600078e20ffULL, 0x000000ffff057224ULL, 0x000fca00000e0612ULL,
0x00000000040a7faeULL, 0x0003e8000c901c46ULL, 0x00000000060b7faeULL, 0x0003e8000d101c46ULL,
0x00000000080c7faeULL, 0x0003e2000d901c46ULL, 0x0000038000007947ULL, 0x000fea0003800000ULL,
0x0000002703047211ULL, 0x000fe400078fe0ffULL, 0x000000f00e137812ULL, 0x000fc400078ec0ffULL,
0x0000000204067810ULL, 0x040fe20007ffe0ffULL, 0x0000000104057824ULL, 0x140fe200078e0203ULL,
0x00000006040a7810ULL, 0x040fe20007ffe0ffULL, 0x0000001004087824ULL, 0x000fe400078e00ffULL,
0x0000000106077824ULL, 0x040fe400078e0203ULL, 0x0000001006097824ULL, 0x000fe200078e00ffULL,
0xfffffff008067812ULL, 0x000fe200078ee205ULL, 0x0000008000057824ULL, 0x000fc600078e0204ULL,
0xfffffff009097812ULL, 0x000fe400078ee207ULL, 0x0000000404077810ULL, 0x000fe40007ffe0ffULL,
0x0000000510127210ULL, 0x040fe40007f1e0ffULL, 0x0000000405087810ULL, 0x000fe20007ffe0ffULL,
0x00000010070c7824ULL, 0x000fe200078e00ffULL, 0x0000000205047810ULL, 0x040fe40007ffe0ffULL,
0x00000006050b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000107057824ULL, 0x100fe200078e0203ULL,
0x00000008100f7210ULL, 0x000fe20007f5e0ffULL, 0x000000010a077824ULL, 0x000fe200078e0203ULL,
0x0000000410117210ULL, 0x000fe20007f3e0ffULL, 0x000000100a0a7824ULL, 0x000fe200078e00ffULL,
0x0000000b100d7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x00005e0012047a11ULL, 0x000fe200078040ffULL, 0x000000ffff0e7224ULL, 0x000fe200010e06ffULL,
0xfffffff00c0b7812ULL, 0x000fe200078ee205ULL, 0x000000ffff057224ULL, 0x000fe200018e06ffULL,
0xfffffff00a0c7812ULL, 0x000fe200078ee207ULL, 0x000000ffff077224ULL, 0x000fe200008e06ffULL,
0x00005f0012127a11ULL, 0x000fc400000f4408ULL, 0x00005e0011107a11ULL, 0x000fe400078240ffULL,
0x00005e000d0a7a11ULL, 0x000fe400078640ffULL, 0x0000000413047210ULL, 0x000fe40007f1e0ffULL,
0x00005e000f087a11ULL, 0x000fe400078440ffULL, 0x00005f0011117a11ULL, 0x000fe400008f4407ULL,
0x00005f000d0d7a11ULL, 0x000fe200018f4405ULL, 0x000000ffff057224ULL, 0x000fe200000e0612ULL,
0x0000c00006077811ULL, 0x000fc400078e20ffULL, 0x0000001013067210ULL, 0x000fe40007f1e0ffULL,
0x00005f000f0e7a11ULL, 0x000fe200010f440eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004077faeULL, 0x0003e2000b901c46ULL, 0x0000000813087210ULL, 0x040fe40007f3e0ffULL,
0x0000000a130a7210ULL, 0x000fe40007f5e0ffULL, 0x0000c0000c0c7811ULL, 0x000fe400078e20ffULL,
0x0000c00009047811ULL, 0x002fe200078e20ffULL, 0x000000ffff077224ULL, 0x000fe200000e0611ULL,
0x0000c0000b057811ULL, 0x000fe200078e20ffULL, 0x000000ffff097224ULL, 0x000fc400008e060eULL,
0x000000ffff0b7224ULL, 0x000fe200010e060dULL, 0x0000000006047faeULL, 0x0003e8000b901c46ULL,
0x0000000008057faeULL, 0x0003e8000b901c46ULL, 0x000000000a0c7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x000000ff2600720cULL, 0x000fe20003f05270ULL,
0x000000ffff297224ULL, 0x000fe200078e00ffULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x000000ffff117224ULL, 0x000fe200078e00ffULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff487f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b800ff2a7f8cULL, 0x000ee2000c80043fULL, 0x000000ffff107224ULL, 0x000fe200078e00ffULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0001852000008947ULL, 0x000fea0003800000ULL, 0x000000023e2a7824ULL, 0x008fe400078e00ffULL,
0x00006400ff0b7624ULL, 0x000fc400078e00ffULL, 0x000000ffff4b7224ULL, 0x000fe400078e002bULL,
0x000064002a2a7624ULL, 0x000fe400078e020bULL, 0x000000ffff487224ULL, 0x002fe400078e0049ULL,
0xff317217ff4a7424ULL, 0x000fe400078e00ffULL, 0x000000ffff2b7224ULL, 0x000fe400078e00ffULL,
0x000000ffff2c7224ULL, 0x000fc400078e00ffULL, 0x000000ffff0b7224ULL, 0x000fc400078e00ffULL,
0x000001002b2d7824ULL, 0x000fca00078e00ffULL, 0x000000242d00720cULL, 0x000fda0003f06070ULL,
0x0001842000000947ULL, 0x004fea0003800000ULL, 0x000000ffff2d7224ULL, 0x000fc400078e002cULL,
0x00000000002e7805ULL, 0x000fca0000015200ULL, 0x0106bc00ff307984ULL, 0x000e640000000800ULL,
0x8000000030ff7812ULL, 0x002fe4000780484bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff367224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000307805ULL, 0x000fcc0000015200ULL,
0x000000302e327210ULL, 0x000fca0007f1e1ffULL, 0x0000000131317824ULL, 0x000fe200000e0e2fULL,
0x003d09003200780cULL, 0x000fc80003f06070ULL, 0x000000ff3100720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403200780cULL, 0x000fc80003f06070ULL,
0x000000ff3100720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff307819ULL, 0x000fc80000011431ULL, 0x0000003230307211ULL, 0x000fca00078110ffULL,
0x000000ffff317224ULL, 0x000fca00000e0631ULL, 0x0000000230307819ULL, 0x000fc80000001231ULL,
0x000000300000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000136367810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106bc00ff307984ULL, 0x000e640000000800ULL, 0x8000000030ff7812ULL, 0x002fe4000780484bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000012b2e7810ULL, 0x000fe20007ffe0ffULL,
0x0000580028557a24ULL, 0x000fc600078e02ffULL, 0x000000262e00720cULL, 0x000fe20003f26070ULL,
0x0000008055557824ULL, 0x000fd800078e00ffULL, 0x0000048000009947ULL, 0x000fea0003800000ULL,
0x000000202b2e7811ULL, 0x000fe400078e40ffULL, 0x00000004ff397819ULL, 0x000fe40000011603ULL,
0x0000002e242f7217ULL, 0x000fe40007800000ULL, 0x00000004393f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000127307824ULL, 0x000fe200078e0239ULL, 0x00000002393c7810ULL, 0x000fe20007ffe0ffULL,
0x000000012f2f7824ULL, 0x000fe200078e0a2eULL, 0x00000020002e7811ULL, 0x000fe200078e38ffULL,
0x0000000130317824ULL, 0x040fe200078e0203ULL, 0x0000000639417810ULL, 0x000fe20007ffe0ffULL,
0x00000010303d7824ULL, 0x000fe200078e00ffULL, 0x0000002f272f7217ULL, 0x040fe20007800000ULL,
0x0000000127367824ULL, 0x000fc400078e023fULL, 0x0000000127327824ULL, 0x000fe200078e023cULL,
0xfffffff03d3d7812ULL, 0x000fe200078ee231ULL, 0x0000000136377824ULL, 0x140fe400078e0203ULL,
0x0000001036407824ULL, 0x000fe400078e00ffULL, 0x0000000130307824ULL, 0x000fe400078e022eULL,
0x0000000132317824ULL, 0x000fe200078e0203ULL, 0xfffffff040407812ULL, 0x000fe200078ee237ULL,
0x00000010323e7824ULL, 0x000fe200078e00ffULL, 0x0000003055377210ULL, 0x000fe20007f1e0ffULL,
0x0000000127387824ULL, 0x000fc400078e0241ULL, 0x000000012f307824ULL, 0x000fe200078e0a27ULL,
0xfffffff03e3e7812ULL, 0x000fe200078ee231ULL, 0x0000000132317824ULL, 0x100fe400078e022eULL,
0x0000000136327824ULL, 0x100fe400078e022eULL, 0x00000001382e7824ULL, 0x040fe200078e022eULL,
0x0000003155317210ULL, 0x040fe20007f5e0ffULL, 0x00000001383a7824ULL, 0x040fe200078e0203ULL,
0x0000003255327210ULL, 0x000fe20007f9e0ffULL, 0x0000001038427824ULL, 0x000fc400078e00ffULL,
0x000000ffff387224ULL, 0x000fe200000e06ffULL, 0x00005e0037367a11ULL, 0x040fe200078040ffULL,
0x000000ffff3b7224ULL, 0x000fe200010e06ffULL, 0x000000303c00720cULL, 0x080fe40003f46070ULL,
0x00005f00372f7a11ULL, 0x000fe200000f4438ULL, 0x0000001003377824ULL, 0x000fe200078e00ffULL,
0x000000303900720cULL, 0x000fe20003f06070ULL, 0x000000ffff397224ULL, 0x000fe200020e06ffULL,
0x00005e0032387a11ULL, 0x000fe400078a40ffULL, 0x000000f0373c7812ULL, 0x000fc400078ec0ffULL,
0x0000002e55377210ULL, 0x000fe40007fde0ffULL, 0xfffffff042427812ULL, 0x000fe400078ee23aULL,
0x0000003c362e7210ULL, 0x000fe40007f9e0ffULL, 0x00005f0032397a11ULL, 0x000fe200028f4439ULL,
0x000000ffff327224ULL, 0x000fe200030e06ffULL, 0x00005e00313a7a11ULL, 0x000fe200078640ffULL,
0x000000ffff2f7224ULL, 0x000fe200020e062fULL, 0x00005e0037367a11ULL, 0x000fc400078a40ffULL,
0x00005f00313b7a11ULL, 0x000fe400018f443bULL, 0x000000303f00720cULL, 0x080fe40003f66070ULL,
0x0000e0003d317811ULL, 0x000fe400078e20ffULL, 0x000000304100720cULL, 0x000fe40003f86070ULL,
0x00005f0037377a11ULL, 0x000fe200028f4432ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002e317faeULL, 0x0003e2000c101c46ULL, 0x0000003c3a307210ULL, 0x000fc40007fbe0ffULL,
0x0000e0003e327811ULL, 0x000fe400078e20ffULL, 0x0000003c382e7210ULL, 0x082fe20007f1e0ffULL,
0x000000ffff317224ULL, 0x000fe200028e063bULL, 0x0000003c36367210ULL, 0x000fe40007fbe0ffULL,
0x0000e00040387811ULL, 0x000fe200078e20ffULL, 0x000000ffff2f7224ULL, 0x000fe200000e0639ULL,
0x0000e00042397811ULL, 0x000fe200078e20ffULL, 0x000000ffff377224ULL, 0x000fe200028e0637ULL,
0x0000000030327faeULL, 0x0003e8000d101c46ULL, 0x000000002e387faeULL, 0x0003e8000d901c46ULL,
0x0000000036397faeULL, 0x0003e2000e101c46ULL, 0x000003a000007947ULL, 0x000fea0003800000ULL,
0x00000027032f7211ULL, 0x000fe400078fe0ffULL, 0x0000002000307811ULL, 0x000fc400078e38ffULL,
0x000000022f317810ULL, 0x040fe20007ffe0ffULL, 0x000000012f2e7824ULL, 0x140fe200078e0203ULL,
0x000000062f377810ULL, 0x040fe20007ffe0ffULL, 0x000000102f3e7824ULL, 0x000fe400078e00ffULL,
0x0000000131327824ULL, 0x140fe400078e0203ULL, 0x00000010313f7824ULL, 0x000fe200078e00ffULL,
0xfffffff03e3e7812ULL, 0x000fe200078ee22eULL, 0x000000012f2e7824ULL, 0x000fe400078e0230ULL,
0x0000000137387824ULL, 0x000fe200078e0203ULL, 0xfffffff03f3f7812ULL, 0x000fe200078ee232ULL,
0x0000001037417824ULL, 0x000fe200078e00ffULL, 0x0000002e553c7210ULL, 0x000fe20007f1e0ffULL,
0x00000001312e7824ULL, 0x000fe200078e0230ULL, 0x000000042f327810ULL, 0x000fc40007ffe0ffULL,
0xfffffff041417812ULL, 0x000fe200078ee238ULL, 0x000000ffff317224ULL, 0x000fe200000e06ffULL,
0x00005e003c3b7a11ULL, 0x000fe200078040ffULL, 0x00000001322f7824ULL, 0x100fe400078e0230ULL,
0x0000000137307824ULL, 0x000fe200078e0230ULL, 0x00005f003c3c7a11ULL, 0x000fe200000f4431ULL,
0x0000000132367824ULL, 0x040fe200078e0203ULL, 0x0000002e553a7210ULL, 0x040fe20007f1e0ffULL,
0x0000001032407824ULL, 0x000fe200078e00ffULL, 0x0000002f552f7210ULL, 0x000fe20007f7e0ffULL,
0x0000001003327824ULL, 0x000fe200078e00ffULL, 0x0000003055307210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff317224ULL, 0x000fe200000e06ffULL, 0xfffffff040407812ULL, 0x000fe200078ee236ULL,
0x000000ffff377224ULL, 0x000fe200018e06ffULL, 0x000000f0323d7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff327224ULL, 0x000fe200020e06ffULL, 0x00005e003a397a11ULL, 0x000fc400078440ffULL,
0x00005e002f367a11ULL, 0x000fe400078640ffULL, 0x0000003d3b2e7210ULL, 0x000fe40007f1e0ffULL,
0x00005e0030387a11ULL, 0x000fe400078840ffULL, 0x00005f003a3a7a11ULL, 0x000fe400010f4431ULL,
0x00005f002f377a11ULL, 0x000fe200018f4437ULL, 0x000000ffff2f7224ULL, 0x000fe200000e063cULL,
0x00005f0030327a11ULL, 0x000fc400020f4432ULL, 0x0000e0003e317811ULL, 0x000fe400078e20ffULL,
0x0000003d39307210ULL, 0x080fe40007f1e0ffULL, 0x0000003d36367210ULL, 0x080fe20007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002e317faeULL, 0x0003e2000b901c46ULL,
0x0000003d38387210ULL, 0x000fc60007f7e0ffULL, 0x000000ffff377224ULL, 0x000fe400010e0637ULL,
0x000000ffff397224ULL, 0x000fe200018e0632ULL, 0x0000e00041327811ULL, 0x000fe400078e20ffULL,
0x0000e0003f2e7811ULL, 0x002fe200078e20ffULL, 0x000000ffff317224ULL, 0x000fe200000e063aULL,
0x0000e000402f7811ULL, 0x000fc800078e20ffULL, 0x00000000302e7faeULL, 0x0003e8000b901c46ULL,
0x00000000362f7faeULL, 0x0003e8000b901c46ULL, 0x0000000038327faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff567f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106080027367f8cULL, 0x0006a4000c80043fULL, 0x00000000002e7805ULL, 0x000fc40000015200ULL,
0x01060c0027307984ULL, 0x000f240000000800ULL, 0x8000000030ff7812ULL, 0x014fc40007804837ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff387224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000307805ULL, 0x000fcc0000015200ULL, 0x000000302e327210ULL, 0x000fca0007f1e1ffULL,
0x0000000131317824ULL, 0x000fe200000e0e2fULL, 0x003d09003200780cULL, 0x000fc80003f06070ULL,
0x000000ff3100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403200780cULL, 0x000fc80003f06070ULL, 0x000000ff3100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff307819ULL, 0x000fc80000011431ULL,
0x0000003230307211ULL, 0x000fca00078110ffULL, 0x000000ffff317224ULL, 0x000fca00000e0631ULL,
0x0000000230307819ULL, 0x000fc80000001231ULL, 0x000000300000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000138387810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01060c0027307984ULL, 0x000ea40000000800ULL,
0x8000000030ff7812ULL, 0x004fe40007804837ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001ff2f7819ULL, 0x000fe20000011603ULL, 0x00000010032e7824ULL, 0x000fc600078e00ffULL,
0x0000000c2f307812ULL, 0x000fe400078ec0ffULL, 0x000000702e2f7812ULL, 0x000fca00078ec0ffULL,
0x000000012f2f7824ULL, 0x000fe400078e0230ULL, 0xffffffffff307424ULL, 0x000fc600078e00ffULL,
0x010000002f367984ULL, 0x000ea80000000800ULL, 0x010200002f377984ULL, 0x0006620000000800ULL,
0x0000004a3600720bULL, 0x004fe20003f1d000ULL, 0x0001e5027f007947ULL, 0x000fd8000b800000ULL,
0x0000000000317806ULL, 0x008fc800000e0100ULL, 0x0000ffff313b7812ULL, 0x000fe2000780c0ffULL,
0x0000047000007945ULL, 0x000fe20003800000ULL, 0x00000001ff3a7424ULL, 0x000fe400078e00ffULL,
0x000000ffff547224ULL, 0x000fc400078e004aULL, 0x0000001fff317424ULL, 0x000fe400078e00ffULL,
0xffffffffff327424ULL, 0x000fca00078e00ffULL, 0x0000041000008947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x000fe40003f05270ULL, 0x0000004a3600720bULL, 0x000fe20003f54000ULL,
0x0001e4a27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000387806ULL, 0x000fc400010e0100ULL,
0x000000364a547209ULL, 0x000fe20007810000ULL, 0x0000035000017945ULL, 0x000fe20003800000ULL,
0x0000991038397816ULL, 0x000fc600000000ffULL, 0x010400542f008388ULL, 0x0005e20000000800ULL,
0x000000ff3900720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x800000544a397221ULL, 0x004fe20000010000ULL, 0x000000ff38ff7812ULL, 0x000fe2000780c0ffULL,
0x0000017000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b39397820ULL, 0x000fcc0000410000ULL,
0x0000003900397308ULL, 0x000ea80000000800ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff4b7819ULL, 0x000fe20000011603ULL, 0x0001e4027f007947ULL, 0x000fea000b800000ULL,
0x00001f4b394b7589ULL, 0x0044e400000e0000ULL, 0x0000004b20207220ULL, 0x08cfe20000410000ULL,
0x0000004b21217220ULL, 0x080fe20000410000ULL, 0x0000004b1c1c7220ULL, 0x080fe20000410000ULL,
0x0000004b1d1d7220ULL, 0x080fe20000410000ULL, 0x0000004b18187220ULL, 0x080fe20000410000ULL,
0x0000004b19197220ULL, 0x080fe20000410000ULL, 0x0000004b14147220ULL, 0x080fe20000410000ULL,
0x0000004b15157220ULL, 0x080fe20000410000ULL, 0x0000004b10107220ULL, 0x080fe20000410000ULL,
0x0000004b11117220ULL, 0x080fe20000410000ULL, 0x0000004b0c0c7220ULL, 0x080fe20000410000ULL,
0x0000004b0d0d7220ULL, 0x080fe20000410000ULL, 0x0000004b04047220ULL, 0x080fe20000410000ULL,
0x0000004b05057220ULL, 0x080fe20000410000ULL, 0x0000004b08087220ULL, 0x080fe20000410000ULL,
0x0000004b09097220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0038ff7812ULL, 0x000fe2000780c0ffULL, 0x0000003929297220ULL, 0x004fd80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008034b7811ULL, 0x000fe200078ff0ffULL,
0x0001e2d27f007947ULL, 0x000fea000b800000ULL, 0x00001f4b394b7589ULL, 0x0004e400000e0000ULL,
0x0000004b22227220ULL, 0x08cfe20000410000ULL, 0x0000004b23237220ULL, 0x080fe20000410000ULL,
0x0000004b1e1e7220ULL, 0x080fe20000410000ULL, 0x0000004b1f1f7220ULL, 0x080fe20000410000ULL,
0x0000004b1a1a7220ULL, 0x080fe20000410000ULL, 0x0000004b1b1b7220ULL, 0x080fe20000410000ULL,
0x0000004b16167220ULL, 0x080fe20000410000ULL, 0x0000004b17177220ULL, 0x080fe20000410000ULL,
0x0000004b12127220ULL, 0x080fe20000410000ULL, 0x0000004b13137220ULL, 0x080fe20000410000ULL,
0x0000004b0e0e7220ULL, 0x080fe20000410000ULL, 0x0000004b0f0f7220ULL, 0x080fe20000410000ULL,
0x0000004b06067220ULL, 0x080fe20000410000ULL, 0x0000004b07077220ULL, 0x080fe20000410000ULL,
0x0000004b0a0a7220ULL, 0x080fe20000410000ULL, 0x0000004b0b0b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff3bff7812ULL, 0x000fda0007806038ULL,
0x8000005436360221ULL, 0x000fe20000010000ULL, 0x00007610ff3a0816ULL, 0x000fc6000000003aULL,
0x3fb8aa3b36360820ULL, 0x000fc80000410000ULL, 0x0000003600330308ULL, 0x000ea40000000800ULL,
0x0000003337370220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002937297221ULL, 0x002fc40000010000ULL, 0x0000000000367805ULL, 0x000fca0000015200ULL,
0x0106ac00ff387984ULL, 0x000e640000000800ULL, 0x8000000038ff7812ULL, 0x002fe40007804848ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fcc0000015200ULL, 0x00000038363b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000139397824ULL, 0x000fe200000e0e37ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff387819ULL, 0x000fc80000011439ULL,
0x0000003b38387211ULL, 0x000fca00078110ffULL, 0x000000ffff397224ULL, 0x000fca00000e0639ULL,
0x0000000238387819ULL, 0x000fc80000001239ULL, 0x000000380000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106ac00ff387984ULL, 0x000e640000000800ULL,
0x8000000038ff7812ULL, 0x002fe40007804848ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099103a367816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff3600720cULL, 0x000fda0003f45270ULL, 0x0000012000002947ULL, 0x000fea0003800000ULL,
0x00000033ff34723eULL, 0x000fe400000010ffULL, 0x00000002ff377819ULL, 0x000fe40000011603ULL,
0x0000541034367816ULL, 0x000fe20000000034ULL, 0x0001dec27f007947ULL, 0x000fea000b800000ULL,
0x00001f3736347589ULL, 0x0002a400000e0000ULL, 0x0000000837357810ULL, 0x000fe20007ffe0ffULL,
0x0001def27f007947ULL, 0x000fea000b800000ULL, 0x00001f3536357589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000010374b7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4d7224ULL, 0x000fe200078e0036ULL, 0x00002850004c7802ULL, 0x000fc40000000f00ULL,
0x0001ed0000007944ULL, 0x00efea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000018374b7810ULL, 0x004fe20007ffe0ffULL, 0x000000ffff4d7224ULL, 0x000fe200078e0036ULL,
0x000028a0004c7802ULL, 0x000fc40000000f00ULL, 0x0001ecb000007944ULL, 0x00afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000803587812ULL, 0x000fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000004ff367819ULL, 0x00afc40000011603ULL,
0x0000000758587812ULL, 0x100fe400078ef803ULL, 0x00000002023a7811ULL, 0x040fe200078e10ffULL,
0x00000004025a7824ULL, 0x000fe200078e0236ULL, 0x00000010583c7812ULL, 0x040fe200078efcffULL,
0x0000001058387824ULL, 0x040fe200078e00ffULL, 0x00000007035d7812ULL, 0x000fe200078ec0ffULL,
0x0000000158377824ULL, 0x000fe200078e025aULL, 0x0000003a3c5b7210ULL, 0x000fe20007ffe036ULL,
0x0000000136597824ULL, 0x000fe200078e023aULL, 0x000000085d5d7812ULL, 0x000fe200078ef803ULL,
0x0000001058397824ULL, 0x000fe200078e00ffULL, 0xfffffff038377812ULL, 0x000fe200078ee237ULL,
0x0000000158387824ULL, 0x000fc400078e0259ULL, 0x000000015a5e7824ULL, 0x000fe200078e023cULL,
0x0000c00037377811ULL, 0x000fe200078e20ffULL, 0x00000001365c7824ULL, 0x000fe200078e025dULL,
0xfffffff039387812ULL, 0x000fe200078ee238ULL, 0x000000103c397824ULL, 0x000fe400078e00ffULL,
0x000000003744783bULL, 0x000e620000004200ULL, 0x0000c00038387811ULL, 0x000fe200078e20ffULL,
0x000000103c3c7824ULL, 0x000fe200078e00ffULL, 0xfffffff0395e7812ULL, 0x000fc600078ee25eULL,
0x000000003848783bULL, 0x004ea20000004200ULL, 0x0000c0005e397811ULL, 0x000fe400078e20ffULL,
0xfffffff03c5b7812ULL, 0x000fc600078ee25bULL, 0x000000003940783bULL, 0x000ee20000004200ULL,
0x0000c0005b3a7811ULL, 0x000fca00078e20ffULL, 0x000000003a3c783bULL, 0x000f220000004200ULL,
0x00000100444e7824ULL, 0x002fe200078e00ffULL, 0x00000018ffc47819ULL, 0x000fe20000011444ULL,
0x0000010045cf7824ULL, 0x040fe200078e00ffULL, 0x0000004500bf7306ULL, 0x000fe20000009400ULL,
0x0000010046c97824ULL, 0x040fe200078e00ffULL, 0x00000018ffce7819ULL, 0x000fe2000001144eULL,
0x0001000046b67824ULL, 0x000fe200078e00ffULL, 0x00000018ffcf7819ULL, 0x000fe200000114cfULL,
0x0001000045d17824ULL, 0x000fe200078e00ffULL, 0x00000018ffc97819ULL, 0x000fe200000114c9ULL,
0x0000010048b57824ULL, 0x044fe200078e00ffULL, 0x000000ce00a07306ULL, 0x000fe20000209400ULL,
0x00000018ffb67819ULL, 0x000fe200000114b6ULL, 0x0000010047bb7824ULL, 0x040fe200078e00ffULL,
0x00000018ffd17819ULL, 0x000fe200000114d1ULL, 0x0001000047b97824ULL, 0x000fe200078e00ffULL,
0x00000018ffae7819ULL, 0x000fe20000011445ULL, 0x0001000048b87824ULL, 0x000fe200078e00ffULL,
0x00000018ffb57819ULL, 0x000fe200000114b5ULL, 0x000000ce00d27306ULL, 0x000e620000205400ULL,
0x00000018ffbb7819ULL, 0x000fe200000114bbULL, 0x0001000049b17824ULL, 0x040fe200078e00ffULL,
0x00000018ffb97819ULL, 0x000fe200000114b9ULL, 0x0000010049b47824ULL, 0x000fe200078e00ffULL,
0x00000018ffb87819ULL, 0x000fe200000114b8ULL, 0x000100004b927824ULL, 0x000fe200078e00ffULL,
0x00000018ffa47819ULL, 0x000fe20000011447ULL, 0x000000cf00d67306ULL, 0x000fe20000209400ULL,
0x00000018ffb17819ULL, 0x000fe200000114b1ULL, 0x000100004a937824ULL, 0x000fe200078e00ffULL,
0x00000018ff977819ULL, 0x000fc40000011448ULL, 0x00000018ff947819ULL, 0x000fe40000011449ULL,
0x00000018ff8b7819ULL, 0x008fe20000011440ULL, 0x000000cf00d77306ULL, 0x000ea20000205400ULL,
0x000000d2a000720bULL, 0x002fe20003fdd000ULL, 0x0000010040a07824ULL, 0x000fe200078e00ffULL,
0x00000018ffa57819ULL, 0x000fe20000011446ULL, 0x000000085dd27824ULL, 0x000fe200078e00ffULL,
0x00000018ff887819ULL, 0x000fe4000001144aULL, 0x00000018ffb47819ULL, 0x000fe200000114b4ULL,
0x000000c400957306ULL, 0x000fe20000209400ULL, 0x00000018ff927819ULL, 0x000fc40000011492ULL,
0x00000018ff937819ULL, 0x000fe40000011493ULL, 0x00000018ff857819ULL, 0x000fe4000001144bULL,
0x00000018ffa07819ULL, 0x000fe200000114a0ULL, 0x000000c4008a7306ULL, 0x000e620000205400ULL,
0x000000d7d600720bULL, 0x004fe40003fbd000ULL, 0x00000018ff4f7819ULL, 0x000fe40000011442ULL,
0x00000018ff707819ULL, 0x010fc4000001143cULL, 0x00000018ff6b7819ULL, 0x000fe2000001143dULL,
0x0000004500bc7306ULL, 0x000ea20000005400ULL, 0x00000018ff527819ULL, 0x000fe40000011443ULL,
0x00000018ff617819ULL, 0x000fe4000001143eULL, 0x00000018ff627819ULL, 0x000fc6000001143fULL,
0x00000044003b7306ULL, 0x000fe20000009400ULL, 0x0000008a9500720bULL, 0x002fe40003f9d000ULL,
0x000000ce00957245ULL, 0x000fc8000020d400ULL, 0x0000000195956812ULL, 0x000fe200078efcffULL,
0x0000004400667306ULL, 0x000e620000005400ULL, 0x000000bcbf00720bULL, 0x004fe40003fdd000ULL,
0x000000cf00bf7245ULL, 0x000fe4000020d400ULL, 0x000000c400bc7245ULL, 0x000fe4000020d400ULL,
0x00000001bfbf5812ULL, 0x000fe200078efcffULL, 0x0000004400817306ULL, 0x0004e2000000d400ULL,
0x00000001bcbc4812ULL, 0x000fce00078efcffULL, 0x000000c900da7306ULL, 0x000fe20000209400ULL,
0x0001000044447824ULL, 0x004fe200078e00ffULL, 0x000000663b00720bULL, 0x002fe40003f7d000ULL,
0x000000025c3b7810ULL, 0x000fe40007ffe0ffULL, 0x00000018ffd37819ULL, 0x000fe20000011444ULL,
0x000001004b447824ULL, 0x000fe200078e00ffULL, 0x000000c900db7306ULL, 0x0002a20000205400ULL,
0xfffffff8d23b7812ULL, 0x000fe400078ee23bULL, 0x000000d3008a7245ULL, 0x000fc4000020d400ULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x0000000181813812ULL, 0x008fe200078efcffULL,
0x000000d300d47306ULL, 0x000fe20000209400ULL, 0x000000c900c97245ULL, 0x002fce000020d400ULL,
0x000000d300d57306ULL, 0x000e620000205400ULL, 0x000000dbda00720bULL, 0x004fce0003fbd000ULL,
0x000000b600cc7306ULL, 0x000fec0000209400ULL, 0x00000001c9c95812ULL, 0x000fe400078efcffULL,
0x000000b600cd7306ULL, 0x0004e20000205400ULL, 0x000000d5d400720bULL, 0x002fce0003f1d000ULL,
0x000000d100d87306ULL, 0x000fe20000209400ULL, 0x000000b600b67245ULL, 0x004fca000020d400ULL,
0x000000018a8a0812ULL, 0x000fe400078efcffULL, 0x000000d100d97306ULL, 0x000e620000205400ULL,
0x000000cdcc00720bULL, 0x008fce0003fbd000ULL, 0x00000045007d7306ULL, 0x000eac000000d400ULL,
0x00000001b6b65812ULL, 0x000fe400078efcffULL, 0x0000004700b07306ULL, 0x000fe20000009400ULL,
0x000000d9d800720bULL, 0x002fce0003f1d000ULL, 0x0000004700af7306ULL, 0x000e620000005400ULL,
0x000000017d7d6812ULL, 0x004fce00078efcffULL, 0x000000ae00b27306ULL, 0x000ff00000209400ULL,
0x000000ae00b37306ULL, 0x0004e20000205400ULL, 0x000000afb000720bULL, 0x002fe20003fdd000ULL,
0x0001000043b07824ULL, 0x000fcc00078e00ffULL, 0x000000b500c37306ULL, 0x000fe20000209400ULL,
0x000000ae00ae7245ULL, 0x004fce000020d400ULL, 0x000000b500bd7306ULL, 0x0002a20000205400ULL,
0x000000b3b200720bULL, 0x008fe40003f9d000ULL, 0x000000d100b27245ULL, 0x000fc8000020d400ULL,
0x00000001b2b20812ULL, 0x000fe200078efcffULL, 0x000000bb00d07306ULL, 0x000fe20000209400ULL,
0x000000b500b57245ULL, 0x002fca000020d400ULL, 0x00000001aeae4812ULL, 0x000fe400078efcffULL,
0x000000bb00dc7306ULL, 0x0002e20000205400ULL, 0x000000bdc300720bULL, 0x004fe20003fbd000ULL,
0x000100003dbd7824ULL, 0x000fca00078e00ffULL, 0x00000018ffbd7819ULL, 0x000fe200000114bdULL,
0x0000004700777306ULL, 0x000522000000d400ULL, 0x000000bb00bb7245ULL, 0x002fca000020d400ULL,
0x00000001b5b55812ULL, 0x000fe400078efcffULL, 0x000000b900ca7306ULL, 0x000fe20000209400ULL,
0x000000dcd000720bULL, 0x008fe20003f1d000ULL, 0x000001004a477824ULL, 0x004fca00078e00ffULL,
0x00000018ff477819ULL, 0x000fe20000011447ULL, 0x000000b900cb7306ULL, 0x0002a20000205400ULL,
0x0000000177776812ULL, 0x010fca00078efcffULL, 0x00000001bbbb0812ULL, 0x000fe400078efcffULL,
0x000000b800be7306ULL, 0x000fe20000209400ULL, 0x000000b900b97245ULL, 0x002fce000020d400ULL,
0x000000b800c87306ULL, 0x0002e20000205400ULL, 0x000000cbca00720bULL, 0x004fce0003fdd000ULL,
0x000000a400a77306ULL, 0x000fe20000209400ULL, 0x000000b800b87245ULL, 0x002fca000020d400ULL,
0x00000001b9b96812ULL, 0x000fe400078efcffULL, 0x000000a400a87306ULL, 0x0002a20000205400ULL,
0x000000c8be00720bULL, 0x008fce0003fbd000ULL, 0x0000004800ad7306ULL, 0x000fe20000009400ULL,
0x000000a400a47245ULL, 0x002fca000020d400ULL, 0x00000001b8b85812ULL, 0x000fe400078efcffULL,
0x0000004800ac7306ULL, 0x000e620000005400ULL, 0x000000a8a700720bULL, 0x004fce0003f1d000ULL,
0x0000004900a17306ULL, 0x000fec0000009400ULL, 0x00000001a4a40812ULL, 0x000fe400078efcffULL,
0x0000004900a27306ULL, 0x000ea20000005400ULL, 0x000000acad00720bULL, 0x002fce0003f9d000ULL,
0x0000004600c57306ULL, 0x000ff00000009400ULL, 0x0000004600c67306ULL, 0x000e620000005400ULL,
0x000000a2a100720bULL, 0x004fce0003fdd000ULL, 0x000000b100b77306ULL, 0x000ff00000209400ULL,
0x000000b100ba7306ULL, 0x0004e20000205400ULL, 0x000000c6c500720bULL, 0x002fce0003f7d000ULL,
0x0000004000877306ULL, 0x000fe20000009400ULL, 0x000000b100b17245ULL, 0x004fce000020d400ULL,
0x0000004000867306ULL, 0x000fe20000005400ULL, 0x000000bab700720bULL, 0x008fe20003fbd000ULL,
0x000001003cb77824ULL, 0x040fe400078e00ffULL, 0x000100003cba7824ULL, 0x000fc800078e00ffULL,
0x0000004000697306ULL, 0x0003e2000000d400ULL, 0x00000018ffba7819ULL, 0x000fca00000114baULL,
0x00000001b1b15812ULL, 0x000fe400078efcffULL, 0x0000004800757306ULL, 0x000ea2000000d400ULL,
0x0001000040407824ULL, 0x002fca00078e00ffULL, 0x00000018ffb37819ULL, 0x000fe20000011440ULL,
0x0000010041407824ULL, 0x000fe200078e00ffULL, 0x0000004a009e7306ULL, 0x000fe80000009400ULL,
0x00000018ffac7819ULL, 0x000fe20000011440ULL, 0x0000010042407824ULL, 0x000fc600078e00ffULL,
0x0000004a009c7306ULL, 0x000e620000005400ULL, 0x0000000175754812ULL, 0x004fce00078efcffULL,
0x0000004900767306ULL, 0x000eb0000000d400ULL, 0x00000097009b7306ULL, 0x000fe20000209400ULL,
0x0000009c9e00720bULL, 0x002fe40003f1d000ULL, 0x00000018ff9e7819ULL, 0x000fe20000011440ULL,
0x0000010043407824ULL, 0x000fc800078e00ffULL, 0x00000097009d7306ULL, 0x0002e20000205400ULL,
0x0000000176766812ULL, 0x004fe400078efcffULL, 0x00000018ffa17819ULL, 0x000fe20000011440ULL,
0x000000085d407824ULL, 0x000fc800078e00ffULL, 0x00000094009a7306ULL, 0x000fe20000209400ULL,
0x0000009700977245ULL, 0x002fe4000020d400ULL, 0xfffffff840407812ULL, 0x000fca00078ee25cULL,
0x0000009400987306ULL, 0x000e620000205400ULL, 0x0000009d9b00720bULL, 0x008fce0003f9d000ULL,
0x00000046007a7306ULL, 0x000eac000000d400ULL, 0x0000000197974812ULL, 0x000fe400078efcffULL,
0x000000a500aa7306ULL, 0x000fe20000209400ULL, 0x000000989a00720bULL, 0x002fe40003fdd000ULL,
0x0000009400987245ULL, 0x000fc4000020d400ULL, 0x0000004700947245ULL, 0x000fc6000020d400ULL,
0x000000a500a97306ULL, 0x0002e20000205400ULL, 0x000000017a7a3812ULL, 0x004fc800078efcffULL,
0x0000007ac97a723eULL, 0x000fe400000010ffULL, 0x0000000198986812ULL, 0x000fe200078efcffULL,
0x0000004400a67306ULL, 0x000fe20000209400ULL, 0x000000a500a57245ULL, 0x002fe4000020d400ULL,
0x000000b198b1723eULL, 0x000fca00000010ffULL, 0x0000004400ab7306ULL, 0x000e620000205400ULL,
0x000000a9aa00720bULL, 0x008fce0003f7d000ULL, 0x0000004700c07306ULL, 0x000fec0000209400ULL,
0x00000001a5a53812ULL, 0x000fe400078efcffULL, 0x0000004700c17306ULL, 0x0004e20000205400ULL,
0x000000aba600720bULL, 0x002fe40003fbd000ULL, 0x000000b6a5b6723eULL, 0x000fca00000010ffULL,
0x0000008800907306ULL, 0x000fe20000209400ULL, 0x0000a00040477811ULL, 0x004fce00078e20ffULL,
0x0000008800917306ULL, 0x0002a20000205400ULL, 0x000000c1c000720bULL, 0x008fce0003f9d000ULL,
0x000000b400c27306ULL, 0x000fe20000209400ULL, 0x0000008800887245ULL, 0x002fca000020d400ULL,
0x0000000194944812ULL, 0x000fe400078efcffULL, 0x000000b400c77306ULL, 0x0002e20000205400ULL,
0x000000919000720bULL, 0x004fe40003fdd000ULL, 0x0000004400907245ULL, 0x000fc8000020d400ULL,
0x0000000190905812ULL, 0x000fe200078efcffULL, 0x0000009200457306ULL, 0x000fe20000209400ULL,
0x000000b400b47245ULL, 0x002fca000020d400ULL, 0x0000000188886812ULL, 0x000fe400078efcffULL,
0x0000009200467306ULL, 0x0002a20000205400ULL, 0x000000c7c200720bULL, 0x008fce0003f7d000ULL,
0x00000093009f7306ULL, 0x000fe20000209400ULL, 0x0000009200927245ULL, 0x002fca000020d400ULL,
0x00000001b4b43812ULL, 0x000fe400078efcffULL, 0x0000009300a37306ULL, 0x0002e20000205400ULL,
0x000000464500720bULL, 0x004fe40003fbd000ULL, 0x000000004744783bULL, 0x000eaa0000000200ULL,
0x0000004b00967306ULL, 0x000fe20000009400ULL, 0x0000009300937245ULL, 0x002fca000020d400ULL,
0x0000000192925812ULL, 0x000fe400078efcffULL, 0x0000004b00997306ULL, 0x000e620000005400ULL,
0x000000a39f00720bULL, 0x008fce0003f9d000ULL, 0x0000004a004d7306ULL, 0x00072c000000d400ULL,
0x0000000193934812ULL, 0x000fe400078efcffULL, 0x00000085008c7306ULL, 0x000fe20000209400ULL,
0x000000999600720bULL, 0x002fe20003f7d000ULL, 0x0001000042997824ULL, 0x000fe200078e00ffULL,
0x00000018ff4a7819ULL, 0x008fe20000011441ULL, 0x000001003e967824ULL, 0x000fe200078e00ffULL,
0x000000868700720bULL, 0x000fc40003f9d000ULL, 0x0000008500867245ULL, 0x000fe2000020d400ULL,
0x00000085008d7306ULL, 0x0002e20000205400ULL, 0x000000014d4d0812ULL, 0x010fe200078efcffULL,
0x000000344444a231ULL, 0x084fe200003400ffULL, 0x00000018ff997819ULL, 0x000fe20000011499ULL,
0x000000344646a231ULL, 0x000fe200003400ffULL, 0x0000004d9494723eULL, 0x000fe200000010ffULL,
0x000000354545a231ULL, 0x080fe400003400ffULL, 0x000000b300c57306ULL, 0x000fe20000209400ULL,
0x000000354747a231ULL, 0x000fe200003400ffULL, 0x0000000169694812ULL, 0x000fc400078efcffULL,
0x00000018ff857819ULL, 0x002fe400000114b7ULL, 0x000000b9a4b7723eULL, 0x000fe400000010ffULL,
0x000000b300af7306ULL, 0x0002a20000205400ULL, 0x0000008d8c00720bULL, 0x008fe40003f1d000ULL,
0x00000018ff8c7819ULL, 0x000fe400000114b0ULL, 0x000000b897b0723eULL, 0x000fe200000010ffULL,
0x000000b64414723cULL, 0x000fe20000041814ULL, 0x000000938888723eULL, 0x000fe200000010ffULL,
0x0000004b004c7306ULL, 0x000ee2000000d400ULL, 0x000000b300b37245ULL, 0x002fc4000020d400ULL,
0x00000018ff967819ULL, 0x000fc60000011496ULL, 0x0000000186860812ULL, 0x000fe400078efcffULL,
0x0000008b008e7306ULL, 0x000fe20000209400ULL, 0x000000afc500720bULL, 0x004fce0003fdd000ULL,
0x0000008b008f7306ULL, 0x0002a20000205400ULL, 0x000000014c4c3812ULL, 0x008fca00078efcffULL,
0x00000001b3b36812ULL, 0x000fe400078efcffULL, 0x000000a000ce7306ULL, 0x000fe20000209400ULL,
0x0000008b008b7245ULL, 0x002fce000020d400ULL, 0x000000a000c47306ULL, 0x0002e20000205400ULL,
0x0000008f8e00720bULL, 0x004fce0003fbd000ULL, 0x0000004100847306ULL, 0x000fe20000009400ULL,
0x000000a000a07245ULL, 0x002fca000020d400ULL, 0x000000018b8b5812ULL, 0x000fe400078efcffULL,
0x00000041007e7306ULL, 0x000e620000005400ULL, 0x000000c4ce00720bULL, 0x008fce0003f7d000ULL,
0x00000041006a7306ULL, 0x0004ec000000d400ULL, 0x00000001a0a03812ULL, 0x000fe400078efcffULL,
0x0000004200837306ULL, 0x000fe20000009400ULL, 0x0001000041417824ULL, 0x004fe200078e00ffULL,
0x0000007e8400720bULL, 0x002fc80003f1d000ULL, 0x00000018ffa87819ULL, 0x000fe20000011441ULL,
0x000100003f417824ULL, 0x000fe200078e00ffULL, 0x00000042007f7306ULL, 0x000e680000005400ULL,
0x00000018ff417819ULL, 0x000fc60000011441ULL, 0x000000016a6a0812ULL, 0x008fe200078efcffULL,
0x0000004300827306ULL, 0x000ff00000009400ULL, 0x0000004300807306ULL, 0x000ea20000005400ULL,
0x0000007f8300720bULL, 0x002fce0003f9d000ULL, 0x000000a800a97306ULL, 0x000ff00000209400ULL,
0x000000a8009c7306ULL, 0x0002e20000205400ULL, 0x000000808200720bULL, 0x004fce0003fdd000ULL,
0x000000ac00ad7306ULL, 0x000fe20000209400ULL, 0x000000a800a87245ULL, 0x002fce000020d400ULL,
0x000000ac00a77306ULL, 0x0002a20000205400ULL, 0x0000009ca900720bULL, 0x008fce0003fbd000ULL,
0x0000009e009b7306ULL, 0x000fe20000209400ULL, 0x000000ac00ac7245ULL, 0x002fca000020d400ULL,
0x00000001a8a85812ULL, 0x000fe400078efcffULL, 0x0000009e009a7306ULL, 0x0002e20000205400ULL,
0x000000a7ad00720bULL, 0x004fce0003f7d000ULL, 0x0000004200677306ULL, 0x000522000000d400ULL,
0x0000009e009e7245ULL, 0x002fca000020d400ULL, 0x00000001acac3812ULL, 0x000fe400078efcffULL,
0x0000004f00497306ULL, 0x000fe20000209400ULL, 0x0000009a9b00720bULL, 0x008fe20003f1d000ULL,
0x000100003e427824ULL, 0x004fca00078e00ffULL, 0x00000018ff427819ULL, 0x000fe20000011442ULL,
0x0000004f00487306ULL, 0x000e620000205400ULL, 0x0000000167674812ULL, 0x010fca00078efcffULL,
0x000000019e9e0812ULL, 0x000fe400078efcffULL, 0x0000003c007c7306ULL, 0x000ff00000009400ULL,
0x0000003c007b7306ULL, 0x000ea20000005400ULL, 0x000000484900720bULL, 0x002fc40003f9d000ULL,
0x00000075b548723eULL, 0x000fe400000010ffULL, 0x00000076b449723eULL, 0x000fc600000010ffULL,
0x0000003c00637306ULL, 0x0002f0000000d400ULL, 0x0000003d00787306ULL, 0x000fe20000009400ULL,
0x000001003d3c7824ULL, 0x002fe200078e00ffULL, 0x0000007b7c00720bULL, 0x004fc40003fbd000ULL,
0x0000004a007c7245ULL, 0x000fe4000020d400ULL, 0x00000018ff807819ULL, 0x000fe4000001143cULL,
0x0000003d00797306ULL, 0x000fe20000005400ULL, 0x00000081953c723eULL, 0x000fe400000010ffULL,
0x00000077bb7b723eULL, 0x000fe400000010ffULL, 0x0000004c9095723eULL, 0x000fe400000010ffULL,
0x0000000163635812ULL, 0x008fe200078efcffULL, 0x0000003d00647306ULL, 0x0003e4000000d400ULL,
0x0000007a4418723cULL, 0x000fec0000041818ULL, 0x0000004a004b7306ULL, 0x000fe20000209400ULL,
0x0000007dbf3d723eULL, 0x002fce00000010ffULL, 0x0000004a00897306ULL, 0x000e620000205400ULL,
0x0000003c4420723cULL, 0x000bee0000041820ULL, 0x000000a100a27306ULL, 0x000fe20000209400ULL,
0x0000a0003b3c7811ULL, 0x020fce00078e20ffULL, 0x000000a100aa7306ULL, 0x0004e20000205400ULL,
0x000000894b00720bULL, 0x002fe40003f7d000ULL, 0x000000484448723cULL, 0x000be20000041810ULL,
0x000000928689723eULL, 0x000fc800000010ffULL, 0x0000004300687306ULL, 0x000322000000d400ULL,
0x000000a100a17245ULL, 0x004fe4000020d400ULL, 0x0000004f00127245ULL, 0x020fe2000020d400ULL,
0x000000884408723cULL, 0x000fe20000041808ULL, 0x000000679e10723eULL, 0x000fe400000010ffULL,
0x0000000112124812ULL, 0x000fe200078efcffULL, 0x0000003e00517306ULL, 0x000fe20000009400ULL,
0x000001003f437824ULL, 0x002fe200078e00ffULL, 0x000000aaa200720bULL, 0x008fc40003f1d000ULL,
0x000000017c7c3812ULL, 0x000fe400078efcffULL, 0x000000797800720bULL, 0x000fe40003f7d000ULL,
0x0000003e00507306ULL, 0x000fe20000005400ULL, 0x0000000168686812ULL, 0x010fe400078efcffULL,
0x00000018ff797819ULL, 0x000fe40000011443ULL, 0x0000005200437245ULL, 0x000fe4000020d400ULL,
0x00000001a1a10812ULL, 0x000fe200078efcffULL, 0x0000003e005f7306ULL, 0x0003e6000000d400ULL,
0x0000000164643812ULL, 0x000fc400078efcffULL, 0x00000068a111723eULL, 0x000fc600000010ffULL,
0x0000003f006e7306ULL, 0x000fe20000009400ULL, 0x0000008abc3e723eULL, 0x002fce00000010ffULL,
0x0000003f006f7306ULL, 0x000ff00000005400ULL, 0x0000003f00607306ULL, 0x0003f0000000d400ULL,
0x00000085007e7306ULL, 0x000fe20000209400ULL, 0x000000b2ae3f723eULL, 0x002fce00000010ffULL,
0x00000085007f7306ULL, 0x0002a20000205400ULL, 0x0000003e441c723cULL, 0x000b64000004181cULL,
0x000000003c3c783bULL, 0x020eea0000000200ULL, 0x00000099009d7306ULL, 0x000fe20000209400ULL,
0x0000008500857245ULL, 0x002fce000020d400ULL, 0x00000099008d7306ULL, 0x0003220000205400ULL,
0x0000007f7e00720bULL, 0x004fce0003f9d000ULL, 0x0000008c00917306ULL, 0x000fe20000209400ULL,
0x0000009900997245ULL, 0x002fca000020d400ULL, 0x0000000185854812ULL, 0x000fe400078efcffULL,
0x0000008c00877306ULL, 0x0002a20000205400ULL, 0x0000008d9d00720bULL, 0x010fce0003f1d000ULL,
0x0000008000827306ULL, 0x000fe20000209400ULL, 0x0000008c008c7245ULL, 0x002fe2000020d400ULL,
0x000000343c3ca231ULL, 0x088fe400003400ffULL, 0x000000343e3ea231ULL, 0x000fe400003400ffULL,
0x0000000199990812ULL, 0x000fe200078efcffULL, 0x000000353d3da231ULL, 0x080fe200003400ffULL,
0x0000008000817306ULL, 0x0002e20000205400ULL, 0x000000879100720bULL, 0x004fe20003fdd000ULL,
0x000000353f3fa231ULL, 0x000fcc00003400ffULL, 0x000000ba007d7306ULL, 0x000fe20000209400ULL,
0x0000008000807245ULL, 0x002fca000020d400ULL, 0x000000018c8c6812ULL, 0x000fe400078efcffULL,
0x000000ba00777306ULL, 0x0002a20000205400ULL, 0x000000818200720bULL, 0x008fe40003f9d000ULL,
0x000000505100720bULL, 0x000fca0003fdd000ULL, 0x00000052004e7306ULL, 0x000fe20000209400ULL,
0x000000ba00ba7245ULL, 0x002fca000020d400ULL, 0x0000000180804812ULL, 0x000fe400078efcffULL,
0x0000005200537306ULL, 0x000e620000205400ULL, 0x000000777d00720bULL, 0x004fe40003fbd000ULL,
0x000000015f5f6812ULL, 0x000fca00078efcffULL, 0x0000007000737306ULL, 0x000fec0000209400ULL,
0x00000001baba5812ULL, 0x000fe400078efcffULL, 0x0000007000747306ULL, 0x0004e20000205400ULL,
0x000000534e00720bULL, 0x002fe40003f1d000ULL, 0x000000b0444c723cULL, 0x000bea000004180cULL,
0x0000006b00717306ULL, 0x000fe20000209400ULL, 0x0000007000707245ULL, 0x004fc4000020d400ULL,
0x000000944450723cULL, 0x000b640000041804ULL, 0x000000b38b0c723eULL, 0x020fe400000010ffULL,
0x000000a87c0d723eULL, 0x000fe200000010ffULL, 0x0000006b00727306ULL, 0x0002a20000205400ULL,
0x000000747300720bULL, 0x008fe40003f9d000ULL, 0x00000069a004723eULL, 0x000fe400000010ffULL,
0x0000006aac05723eULL, 0x000fe200000010ffULL, 0x0000000c3c0c723cULL, 0x000b62000004181cULL,
0x0000000143430812ULL, 0x000fe200078efcffULL, 0x000000bd00787306ULL, 0x000fe20000209400ULL,
0x0000006b006b7245ULL, 0x002fc4000020d400ULL, 0x0000006f6e00720bULL, 0x000fe40003f1d000ULL,
0x00000099121c723eULL, 0x020fe200000010ffULL, 0x000000043c04723cULL, 0x000b620000041820ULL,
0x0000000170704812ULL, 0x000fe200078efcffULL, 0x000000bd00757306ULL, 0x0002e20000205400ULL,
0x000000727100720bULL, 0x004fe40003fbd000ULL, 0x0000008c431d723eULL, 0x000fe400000010ffULL,
0x0000007900217245ULL, 0x020fc4000020d400ULL, 0x0000004100437245ULL, 0x000fe2000020d400ULL,
0x0000009600137306ULL, 0x000fe20000209400ULL, 0x000000bd00bd7245ULL, 0x002fe2000020d400ULL,
0x0000001c3c14723cULL, 0x000b620000041814ULL, 0x0000000160600812ULL, 0x000fc600078efcffULL,
0x000000016b6b5812ULL, 0x000fe400078efcffULL, 0x0000009600767306ULL, 0x0002a20000205400ULL,
0x000000757800720bULL, 0x008fe40003f7d000ULL, 0x000000ba701c723eULL, 0x020fca00000010ffULL,
0x00000079007a7306ULL, 0x000fe20000209400ULL, 0x0000009600967245ULL, 0x002fca000020d400ULL,
0x00000001bdbd3812ULL, 0x000fe400078efcffULL, 0x0000007900457306ULL, 0x000e620000205400ULL,
0x000000761300720bULL, 0x004fe40003f9d000ULL, 0x000000103c10723cULL, 0x000b620000041818ULL,
0x000000bd6b1d723eULL, 0x000fc800000010ffULL, 0x00000061006c7306ULL, 0x000fe40000209400ULL,
0x000000638518723eULL, 0x020fe400000010ffULL, 0x000000648019723eULL, 0x000fe400000010ffULL,
0x0000000196964812ULL, 0x000fe400078efcffULL, 0x00000061006d7306ULL, 0x0004e20000205400ULL,
0x000000457a00720bULL, 0x002fe40003fbd000ULL, 0x000000183c18723cULL, 0x000b6a0000041848ULL,
0x0000006200657306ULL, 0x000fe20000209400ULL, 0x0000006100617245ULL, 0x004fca000020d400ULL,
0x0000000121215812ULL, 0x000fe400078efcffULL, 0x0000006200667306ULL, 0x0002a20000205400ULL,
0x0000006d6c00720bULL, 0x008fe40003f7d000ULL, 0x000000602121723eULL, 0x000fca00000010ffULL,
0x0000004200447306ULL, 0x000fe20000209400ULL, 0x0000006200627245ULL, 0x002fca000020d400ULL,
0x0000000161613812ULL, 0x000fe400078efcffULL, 0x0000004200207306ULL, 0x0002e20000205400ULL,
0x000000666500720bULL, 0x004fce0003f9d000ULL, 0x00000041001e7306ULL, 0x000fe20000209400ULL,
0x0000004200427245ULL, 0x002fca000020d400ULL, 0x0000000162624812ULL, 0x000fe400078efcffULL,
0x00000041001f7306ULL, 0x000e620000205400ULL, 0x000000204400720bULL, 0x008fe40003fdd000ULL,
0x0000005f9620723eULL, 0x000fce00000010ffULL, 0x000000203c20723cULL, 0x040b680000041850ULL,
0x0000000142426812ULL, 0x000fe400078efcffULL, 0x0000001f1e00720bULL, 0x002fe40003fbd000ULL,
0x000000426142723eULL, 0x000fe200000010ffULL, 0x0000001c3c1c723cULL, 0x000b74000004184cULL,
0x0000000143435812ULL, 0x000fc800078efcffULL, 0x000000436243723eULL, 0x000fce00000010ffULL,
0x000000423c3c723cULL, 0x000b620000041808ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff427f8cULL, 0x020e62000c80043fULL, 0x000000ffff447224ULL, 0x000fce00078e00ffULL,
0x0000000000087805ULL, 0x000fc40000015200ULL, 0x0106bc00ff0a7984ULL, 0x000ea40000000800ULL,
0x800000000aff7812ULL, 0x006fe40007804843ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a08417210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e09ULL, 0x003d09004100780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404100780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0a7819ULL, 0x000fc8000001140bULL,
0x000000410a0a7211ULL, 0x000fca00078110ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e060bULL,
0x000000020a0a7819ULL, 0x000fc8000000120bULL, 0x0000000a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000144447810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106bc00ff0a7984ULL, 0x000e640000000800ULL,
0x800000000aff7812ULL, 0x002fe40007804843ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000402b417811ULL, 0x000fe200078e40ffULL, 0x0000045000009947ULL, 0x000fea0003800000ULL,
0x0000000127097824ULL, 0x000fe200078e0236ULL, 0x00000040000a7811ULL, 0x000fe400078e38ffULL,
0x0000000236457810ULL, 0x040fe20007ffe0ffULL, 0x0000000109087824ULL, 0x040fe200078e0203ULL,
0x00000004364b7810ULL, 0x000fe20007ffe0ffULL, 0x0000001009497824ULL, 0x040fe200078e00ffULL,
0x000000f02e487812ULL, 0x000fe200078ec0ffULL, 0x0000000109097824ULL, 0x000fe200078e020aULL,
0x00000006364d7810ULL, 0x000fe20007ffe0ffULL, 0x00000001270b7824ULL, 0x000fe200078e0245ULL,
0xfffffff049497812ULL, 0x000fe200078ee208ULL, 0x0000000127467824ULL, 0x000fe200078e024bULL,
0x0000004124087217ULL, 0x000fe20007800000ULL, 0x000000010b427824ULL, 0x000fe200078e0203ULL,
0x0000000955437210ULL, 0x000fe20007f1e0ffULL, 0x000000100b4a7824ULL, 0x000fe200078e00ffULL,
0x0000c00049497811ULL, 0x000fe200078e20ffULL, 0x0000000108087824ULL, 0x000fc400078e0a41ULL,
0x000000010b097824ULL, 0x000fe200078e020aULL, 0xfffffff04a4a7812ULL, 0x000fe200078ee242ULL,
0x0000000146477824ULL, 0x040fe200078e0203ULL, 0x0000000827087217ULL, 0x000fe20007800000ULL,
0x00000010464c7824ULL, 0x000fe200078e00ffULL, 0x0000000955097210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff447224ULL, 0x000fe200000e06ffULL, 0x00005e0043427a11ULL, 0x040fe200078040ffULL,
0x00000001080b7824ULL, 0x000fe200078e0a27ULL, 0xfffffff04c4c7812ULL, 0x000fe200078ee247ULL,
0x0000000146087824ULL, 0x000fe200078e020aULL, 0x00005f0043437a11ULL, 0x000fe200000f4444ULL,
0x000000ffff477224ULL, 0x000fe200018e06ffULL, 0x00005e0009447a11ULL, 0x000fe200078640ffULL,
0x00000001274e7824ULL, 0x000fe200078e024dULL, 0x0000000b3600720cULL, 0x000fc40003f86070ULL,
0x0000000855467210ULL, 0x000fe20007fbe0ffULL, 0x000000014e0a7824ULL, 0x000fe200078e020aULL,
0x00005f0009477a11ULL, 0x000fe400018f4447ULL, 0x0000004842087210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff427224ULL, 0x000fe200028e06ffULL, 0x0000000b4500720cULL, 0x080fe40003f06070ULL,
0x00005e0046457a11ULL, 0x000fe200078a40ffULL, 0x000000ffff097224ULL, 0x000fe200018e0643ULL,
0x0000000b4b00720cULL, 0x000fc40003f66070ULL, 0x00005f0046467a11ULL, 0x000fe400028f4442ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008497faeULL, 0x0003e2000e101c46ULL,
0x0000000a55437210ULL, 0x000fe40007f9e0ffULL, 0x00000048450a7210ULL, 0x080fe40007fde0ffULL,
0x0000c0004a4a7811ULL, 0x000fe400078e20ffULL, 0x0000c0004c4c7811ULL, 0x000fe400078e20ffULL,
0x0000004844087210ULL, 0x002fe20007fbe0ffULL, 0x000000ffff447224ULL, 0x000fe200020e06ffULL,
0x00005e0043427a11ULL, 0x000fe200078840ffULL, 0x000000014e497824ULL, 0x000fc400078e0203ULL,
0x000000104e4e7824ULL, 0x000fe200078e00ffULL, 0x00005f0043437a11ULL, 0x000fe200020f4444ULL,
0x000000ffff097224ULL, 0x000fe200028e0647ULL, 0x0000000b4d00720cULL, 0x000fe20003fa6070ULL,
0x000000ffff0b7224ULL, 0x000fe200030e0646ULL, 0x0000004842427210ULL, 0x000fe40007f9e0ffULL,
0xfffffff04e497812ULL, 0x000fe200078ee249ULL, 0x00000000084a7faeULL, 0x0003e4000c101c46ULL,
0x000000ffff437224ULL, 0x000fe200020e0643ULL, 0x0000c00049497811ULL, 0x000fe200078e20ffULL,
0x000000000a4c7faeULL, 0x0003e8000d901c46ULL, 0x0000000042497faeULL, 0x0003e2000e901c46ULL,
0x0000039000007947ULL, 0x000fea0003800000ULL, 0x0000004000447811ULL, 0x000fe200078e38ffULL,
0x0000000127437824ULL, 0x000fe200078e0236ULL, 0x000000f02e4d7812ULL, 0x000fc600078ec0ffULL,
0x0000000143097824ULL, 0x140fe200078e0244ULL, 0x0000000243087810ULL, 0x040fe20007ffe0ffULL,
0x00000001430a7824ULL, 0x140fe200078e0203ULL, 0x00000004430b7810ULL, 0x040fe20007ffe0ffULL,
0x00000010434e7824ULL, 0x040fe200078e00ffULL, 0x0000000643437810ULL, 0x000fe20007ffe0ffULL,
0x0000001008467824ULL, 0x040fe200078e00ffULL, 0x0000000955477210ULL, 0x000fe20007f1e0ffULL,
0x0000000108097824ULL, 0x000fe200078e0244ULL, 0xfffffff04e4e7812ULL, 0x000fe200078ee20aULL,
0x00000001080a7824ULL, 0x000fc400078e0203ULL, 0x0000000143457824ULL, 0x140fe200078e0203ULL,
0x0000c0004e4e7811ULL, 0x000fe200078e20ffULL, 0x00000010434a7824ULL, 0x000fe400078e00ffULL,
0x000000ffff487224ULL, 0x000fe200000e06ffULL, 0x00005e00474b7a11ULL, 0x000fe200078040ffULL,
0x000000010b087824ULL, 0x100fe400078e0244ULL, 0x0000000143447824ULL, 0x000fe200078e0244ULL,
0x00005f00474c7a11ULL, 0x000fe200000f4448ULL, 0x000000010b427824ULL, 0x000fe200078e0203ULL,
0x0000000855487210ULL, 0x000fe20007f7e0ffULL, 0x000000100b497824ULL, 0x000fe200078e00ffULL,
0xfffffff0460b7812ULL, 0x000fc400078ee20aULL, 0xfffffff04a467812ULL, 0x000fe400078ee245ULL,
0x00000009554a7210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff097224ULL, 0x000fe200018e06ffULL,
0x0000004455477210ULL, 0x000fe40007f9e0ffULL, 0xfffffff049437812ULL, 0x000fe200078ee242ULL,
0x000000ffff457224ULL, 0x000fe200000e06ffULL, 0x00005e004a497a11ULL, 0x000fe200078040ffULL,
0x000000ffff087224ULL, 0x000fe200020e06ffULL, 0x0000004d4b447210ULL, 0x000fc40007fbe0ffULL,
0x00005e0047427a11ULL, 0x040fe400078840ffULL, 0x00005e00480a7a11ULL, 0x000fe400078640ffULL,
0x00005f004a4a7a11ULL, 0x000fe200000f4445ULL, 0x000000ffff457224ULL, 0x000fe200028e064cULL,
0x00005f0047477a11ULL, 0x000fe400020f4408ULL, 0x00005f0048487a11ULL, 0x000fe400018f4409ULL,
0x0000004d49087210ULL, 0x080fe20007f1e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000444e7faeULL, 0x0003e2000b901c46ULL, 0x0000004d0a0a7210ULL, 0x000fc40007f7e0ffULL,
0x0000004d42427210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff097224ULL, 0x000fe200000e064aULL,
0x0000c00046467811ULL, 0x000fe400078e20ffULL, 0x0000c0000b447811ULL, 0x002fe200078e20ffULL,
0x000000ffff0b7224ULL, 0x000fe200018e0648ULL, 0x0000c00043457811ULL, 0x000fe200078e20ffULL,
0x000000ffff437224ULL, 0x000fe400020e0647ULL, 0x0000000008447faeULL, 0x0003e8000b901c46ULL,
0x000000000a457faeULL, 0x0003e8000b901c46ULL, 0x0000000042467faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff487f8cULL, 0x000e64000c80043fULL, 0x000000ffff487224ULL, 0x002fc400078e0049ULL,
0x0000000000087805ULL, 0x000fca0000015200ULL, 0x0106b400ff0a7984ULL, 0x000e640000000800ULL,
0x800000000aff7812ULL, 0x002fc40007804857ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff437224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104300780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a08427210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e09ULL,
0x003d09004200780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404200780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0a7819ULL, 0x000fc8000001140bULL, 0x000000420a0a7211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060bULL, 0x000000020a0a7819ULL, 0x000fc8000000120bULL,
0x0000000a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000143437810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106b400ff0a7984ULL, 0x000e640000000800ULL, 0x800000000aff7812ULL, 0x002fe40007804857ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000014000007945ULL, 0x000fe20003800000ULL,
0x0000012000002947ULL, 0x000fea0003800000ULL, 0x00000033ff08723eULL, 0x000fe400000010ffULL,
0x00000002ff097819ULL, 0x000fe40000011603ULL, 0x0000541008087816ULL, 0x000fe20000000008ULL,
0x0001b1d27f007947ULL, 0x000fea000b800000ULL, 0x00001f0908347589ULL, 0x0002a400000e0000ULL,
0x0000000809357810ULL, 0x000fe20007ffe0ffULL, 0x0001b2027f007947ULL, 0x000fea000b800000ULL,
0x00001f3508357589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000010094b7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff4d7224ULL, 0x000fe200078e0008ULL,
0x00005600004c7802ULL, 0x000fc40000000f00ULL, 0x0001bf5000007944ULL, 0x00efea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000018094b7810ULL, 0x004fe20007ffe0ffULL,
0x000000ffff4d7224ULL, 0x000fe200078e0008ULL, 0x00005650004c7802ULL, 0x000fc40000000f00ULL,
0x0001bf0000007944ULL, 0x00afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001585a7824ULL, 0x040fe200078e025aULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000001058447824ULL, 0x040fe200078e00ffULL, 0x0000e0005b437811ULL, 0x000fe200078e20ffULL,
0x0000000158457824ULL, 0x000fe200078e0259ULL, 0x0000e0005e427811ULL, 0x000fe200078e20ffULL,
0x0000001058467824ULL, 0x000fe200078e00ffULL, 0xfffffff044447812ULL, 0x000fe200078ee25aULL,
0x00000000434c783bULL, 0x000f220000004200ULL, 0x000000065c477810ULL, 0x000fc40007ffe0ffULL,
0x0000e00044447811ULL, 0x000fe200078e20ffULL, 0x000000004208783bULL, 0x00ae620000004200ULL,
0xfffffff046457812ULL, 0x000fe400078ee245ULL, 0x000000045c467810ULL, 0x000fe20007ffe0ffULL,
0x000000004458783bULL, 0x000ee20000004200ULL, 0x0000e00045457811ULL, 0x000fca00078e20ffULL,
0x000000004550783bULL, 0x000ea20000004200ULL, 0x0000004c00847306ULL, 0x010fe20000009400ULL,
0x00000018ff687819ULL, 0x000fe4000001144cULL, 0x00000018ff627819ULL, 0x000fe2000001144dULL,
0x000001000a987824ULL, 0x042fe200078e00ffULL, 0x00000018ff757819ULL, 0x000fe2000001140aULL,
0x000100000a797824ULL, 0x000fe200078e00ffULL, 0x00000018ff4a7819ULL, 0x000fe2000001144eULL,
0x0000010059cf7824ULL, 0x048fe200078e00ffULL, 0x0000005800727306ULL, 0x000fe20000009400ULL,
0x0000010058ce7824ULL, 0x040fe200078e00ffULL, 0x00000018ffca7819ULL, 0x000fe20000011458ULL,
0x0001000059d17824ULL, 0x000fe200078e00ffULL, 0x00000018ffcf7819ULL, 0x000fe200000114cfULL,
0x0001000058d27824ULL, 0x000fe200078e00ffULL, 0x00000018ffce7819ULL, 0x000fe200000114ceULL,
0x000001005ad07824ULL, 0x040fe200078e00ffULL, 0x0000005800787306ULL, 0x000e620000005400ULL,
0x00000018ffd17819ULL, 0x000fe200000114d1ULL, 0x000100005ad37824ULL, 0x000fe200078e00ffULL,
0x00000018ffd27819ULL, 0x000fe200000114d2ULL, 0x000001005bcd7824ULL, 0x000fe200078e00ffULL,
0x00000018ffd07819ULL, 0x000fe200000114d0ULL, 0x0000010050c37824ULL, 0x004fe200078e00ffULL,
0x00000018ffc47819ULL, 0x000fe20000011459ULL, 0x000000cf00d57306ULL, 0x000fe20000209400ULL,
0x00000018ffbb7819ULL, 0x000fe2000001145aULL, 0x0000010052e97824ULL, 0x040fe200078e00ffULL,
0x00000018ffa67819ULL, 0x000fe20000011452ULL, 0x0001000052e57824ULL, 0x000fe200078e00ffULL,
0x00000018ffcd7819ULL, 0x000fe200000114cdULL, 0x0000010051ba7824ULL, 0x000fe200078e00ffULL,
0x00000018ffc37819ULL, 0x000fe200000114c3ULL, 0x000000cf00dd7306ULL, 0x0004e20000205400ULL,
0x000000787200720bULL, 0x002fe20003f9d000ULL, 0x000100005bc77824ULL, 0x000fe200078e00ffULL,
0x00000018ffb87819ULL, 0x000fe2000001145bULL, 0x0000010053ea7824ULL, 0x040fe200078e00ffULL,
0x00000018ffd37819ULL, 0x000fe200000114d3ULL, 0x0001000053e27824ULL, 0x000fe200078e00ffULL,
0x00000018ffba7819ULL, 0x000fe200000114baULL, 0x0000005800957306ULL, 0x000e62000000d400ULL,
0x000000cf00cf7245ULL, 0x004fe2000020d400ULL, 0x000100004e787824ULL, 0x000fe200078e00ffULL,
0x00000018ffc77819ULL, 0x000fe200000114c7ULL, 0x000100004f727824ULL, 0x000fe200078e00ffULL,
0x00000018ffb07819ULL, 0x000fe20000011451ULL, 0x00000100099d7824ULL, 0x000fe200078e00ffULL,
0x00000018ffa57819ULL, 0x000fe20000011453ULL, 0x000000ce00e67306ULL, 0x000fe20000209400ULL,
0x000000ddd500720bULL, 0x008fe20003fbd000ULL, 0x00010000099f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff497819ULL, 0x000fe2000001144fULL, 0x0000010008967824ULL, 0x040fe200078e00ffULL,
0x00000018ff827819ULL, 0x000fe20000011409ULL, 0x00010000089b7824ULL, 0x000fe200078e00ffULL,
0x00000018ffe57819ULL, 0x000fe200000114e5ULL, 0x000000ce00587306ULL, 0x000ea20000205400ULL,
0x0000000195954812ULL, 0x002fe200078efcffULL, 0x000001000b7f7824ULL, 0x000fe200078e00ffULL,
0x00000018ffe27819ULL, 0x000fc400000114e2ULL, 0x00000018ffe97819ULL, 0x000fe400000114e9ULL,
0x00000001cfcf5812ULL, 0x000fe200078efcffULL, 0x000000d100e17306ULL, 0x000fe20000209400ULL,
0x00000018ffea7819ULL, 0x000fe400000114eaULL, 0x00000018ff967819ULL, 0x000fe40000011496ULL,
0x00000018ff927819ULL, 0x000fe40000011408ULL, 0x00000018ff987819ULL, 0x000fe20000011498ULL,
0x000000d100dc7306ULL, 0x0002e20000205400ULL, 0x00000058e600720bULL, 0x004fe20003fdd000ULL,
0x000001004f587824ULL, 0x000fe200078e00ffULL, 0x00000018ff7f7819ULL, 0x000fc4000001147fULL,
0x00000018ff707819ULL, 0x000fe4000001140bULL, 0x00000018ff9b7819ULL, 0x000fe2000001149bULL,
0x000000d200e77306ULL, 0x000fe20000209400ULL, 0x000000d100d17245ULL, 0x002fe4000020d400ULL,
0x00000018ff9d7819ULL, 0x000fe4000001149dULL, 0x00000018ff797819ULL, 0x000fe40000011479ULL,
0x00000018ff9f7819ULL, 0x000fe2000001149fULL, 0x000000d200e87306ULL, 0x000e620000205400ULL,
0x000000dce100720bULL, 0x008fc40003f9d000ULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x00000018ff727819ULL, 0x000fc60000011472ULL, 0x000000d000d77306ULL, 0x000fec0000209400ULL,
0x00000001d1d14812ULL, 0x000fe400078efcffULL, 0x000000d000d87306ULL, 0x0004e20000205400ULL,
0x000000e8e700720bULL, 0x002fce0003f7d000ULL, 0x0000005900c67306ULL, 0x000fe20000009400ULL,
0x000000d000d07245ULL, 0x004fce000020d400ULL, 0x0000005900c57306ULL, 0x000fe20000005400ULL,
0x000000d8d700720bULL, 0x008fce0003fbd000ULL, 0x0000005b00bc7306ULL, 0x000fec0000009400ULL,
0x00000001d0d05812ULL, 0x000fe400078efcffULL, 0x0000005b00b97306ULL, 0x000e700000005400ULL,
0x0000005900947306ULL, 0x0005f0000000d400ULL, 0x000000c400c87306ULL, 0x000fe20000209400ULL,
0x000000085d597824ULL, 0x044fe200078e00ffULL, 0x000000b9bc00720bULL, 0x002fe20003f9d000ULL,
0x000000085d5d7824ULL, 0x000fc600078e00ffULL, 0xfffffff859467812ULL, 0x000fe200078ee246ULL,
0x000100004c597824ULL, 0x000fe200078e00ffULL, 0x000000c400c97306ULL, 0x0003e20000205400ULL,
0xfffffff85d477812ULL, 0x000fe200078ee247ULL, 0x00010000505d7824ULL, 0x000fca00078e00ffULL,
0x00000018ff5d7819ULL, 0x000fe2000001145dULL, 0x0000005a00c17306ULL, 0x000fe20000009400ULL,
0x000000c400c47245ULL, 0x002fce000020d400ULL, 0x0000005a00bf7306ULL, 0x000ff00000005400ULL,
0x0000005a007e7306ULL, 0x0003f0000000d400ULL, 0x000000bb00c07306ULL, 0x000fe20000209400ULL,
0x00010000515a7824ULL, 0x002fce00078e00ffULL, 0x000000bb00c27306ULL, 0x0002b00000205400ULL,
0x0000005200ae7306ULL, 0x000fe20000009400ULL, 0x000000bb00bb7245ULL, 0x002fce000020d400ULL,
0x0000005200af7306ULL, 0x000fe20000005400ULL, 0x000000c2c000720bULL, 0x004fce0003fbd000ULL,
0x0000005200717306ULL, 0x0003ec000000d400ULL, 0x00000001bbbb5812ULL, 0x000fe400078efcffULL,
0x0000004c00877306ULL, 0x000fe20000005400ULL, 0x000001004c527824ULL, 0x002fce00078e00ffULL,
0x0000004c00607306ULL, 0x0003f0000000d400ULL, 0x0000005b007a7306ULL, 0x0004e2000000d400ULL,
0x00000018ff4c7819ULL, 0x002fe4000001145aULL, 0x000000ce005a7245ULL, 0x000fc8000020d400ULL,
0x000000015a5a6812ULL, 0x000fe200078efcffULL, 0x000000cd00d67306ULL, 0x000fe20000209400ULL,
0x000000d2005b7245ULL, 0x004fe4000020d400ULL, 0x000000c5c600720bULL, 0x000fe40003fdd000ULL,
0x000000015b5b3812ULL, 0x000fe400078efcffULL, 0x000000c9c800720bULL, 0x000fe20003f7d000ULL,
0x000000cd00d97306ULL, 0x0002a20000205400ULL, 0x000000017a7a4812ULL, 0x008fce00078efcffULL,
0x000000c300de7306ULL, 0x000fe20000209400ULL, 0x0000000194946812ULL, 0x000fe400078efcffULL,
0x000000cd00cd7245ULL, 0x002fe4000020d400ULL, 0x00000001c4c43812ULL, 0x000fc600078efcffULL,
0x000000c300db7306ULL, 0x0002e20000205400ULL, 0x000000d9d600720bULL, 0x004fce0003fdd000ULL,
0x000000d300d47306ULL, 0x000fe20000209400ULL, 0x000000c300c37245ULL, 0x002fca000020d400ULL,
0x00000001cdcd6812ULL, 0x000fe400078efcffULL, 0x000000d300da7306ULL, 0x0002a20000205400ULL,
0x000000dbde00720bULL, 0x008fce0003f9d000ULL, 0x000000ba005c7306ULL, 0x000fe20000209400ULL,
0x000000d300d37245ULL, 0x002fca000020d400ULL, 0x00000001c3c34812ULL, 0x000fe400078efcffULL,
0x000000ba00e37306ULL, 0x0002e20000205400ULL, 0x000000dad400720bULL, 0x004fce0003f7d000ULL,
0x0000005100a97306ULL, 0x000fe20000009400ULL, 0x000000ba00ba7245ULL, 0x002fca000020d400ULL,
0x00000001d3d33812ULL, 0x000fe400078efcffULL, 0x0000005100ab7306ULL, 0x000fe20000005400ULL,
0x000000e35c00720bULL, 0x008fe40003fbd000ULL, 0x000000d3bbc6723eULL, 0x000fca00000010ffULL,
0x0000005100767306ULL, 0x0003ec000000d400ULL, 0x00000001baba5812ULL, 0x000fe400078efcffULL,
0x0000005300a87306ULL, 0x000fe20000009400ULL, 0x000100004d517824ULL, 0x002fce00078e00ffULL,
0x0000005300a77306ULL, 0x000ff00000005400ULL, 0x00000053005e7306ULL, 0x0003f0000000d400ULL,
0x0000004d00907306ULL, 0x000fe20000009400ULL, 0x000001004d537824ULL, 0x002fce00078e00ffULL,
0x0000004d008b7306ULL, 0x000ff00000005400ULL, 0x0000004d00577306ULL, 0x000ff0000000d400ULL,
0x000000ca00cb7306ULL, 0x000ff00000209400ULL, 0x000000ca00cc7306ULL, 0x0002b00000205400ULL,
0x000000c700df7306ULL, 0x000fe20000209400ULL, 0x000000ca00ca7245ULL, 0x002fce000020d400ULL,
0x000000c700e07306ULL, 0x0002e20000205400ULL, 0x000000cccb00720bULL, 0x004fce0003f1d000ULL,
0x0000005d00e47306ULL, 0x000fe20000209400ULL, 0x000000c700c77245ULL, 0x002fca000020d400ULL,
0x00000001caca0812ULL, 0x000fe400078efcffULL, 0x0000005d004d7306ULL, 0x0002a20000205400ULL,
0x000000e0df00720bULL, 0x008fe40003fdd000ULL, 0x000000bfc100720bULL, 0x000fca0003f1d000ULL,
0x0000000a00937306ULL, 0x000fe20000009400ULL, 0x0000005d005d7245ULL, 0x002fca000020d400ULL,
0x00000001c7c76812ULL, 0x000fe400078efcffULL, 0x0000000a008c7306ULL, 0x000fe20000005400ULL,
0x0000004de400720bULL, 0x004fe40003f9d000ULL, 0x000000aba900720bULL, 0x000fe40003fdd000ULL,
0x0000004c00a97245ULL, 0x000fe4000020d400ULL, 0x000000017e7e0812ULL, 0x000fe200078efcffULL,
0x0000000a00677306ULL, 0x0003e6000000d400ULL, 0x0000007ed07e723eULL, 0x000fc600000010ffULL,
0x000000015d5d4812ULL, 0x000fe400078efcffULL, 0x0000005000aa7306ULL, 0x000fe20000009400ULL,
0x00000018ff0a7819ULL, 0x002fe40000011450ULL, 0x000000afae00720bULL, 0x000fe40003f9d000ULL,
0x0000000a005c7245ULL, 0x000fe4000020d400ULL, 0x0000000176766812ULL, 0x000fe200078efcffULL,
0x0000005000ad7306ULL, 0x000e700000005400ULL, 0x0000005000777306ULL, 0x0004e2000000d400ULL,
0x0000000171714812ULL, 0x000fce00078efcffULL, 0x0000004e00817306ULL, 0x000fe20000009400ULL,
0x000001004e507824ULL, 0x004fe200078e00ffULL, 0x000000adaa00720bULL, 0x002fe40003f7d000ULL,
0x000000e900aa7245ULL, 0x000fc8000020d400ULL, 0x0000004e00807306ULL, 0x000fee0000005400ULL,
0x0000000177773812ULL, 0x008fe200078efcffULL, 0x0000004e00567306ULL, 0x000ff0000000d400ULL,
0x0000004f006f7306ULL, 0x000ff00000009400ULL, 0x0000004f006e7306ULL, 0x000ff00000005400ULL,
0x0000004f004b7306ULL, 0x000ff0000000d400ULL, 0x0000004c004e7306ULL, 0x000ff00000209400ULL,
0x0000004c004f7306ULL, 0x0002b00000205400ULL, 0x0000000900887306ULL, 0x000fe20000009400ULL,
0x0000a000464c7811ULL, 0x002fce00078e20ffULL, 0x0000000900897306ULL, 0x000fe20000005400ULL,
0x0000004f4e00720bULL, 0x004fce0003fbd000ULL, 0x0000000900697306ULL, 0x000fec000000d400ULL,
0x00000001a9a95812ULL, 0x000fe400078efcffULL, 0x000000b000b17306ULL, 0x000fe20000209400ULL,
0x000000a7a800720bULL, 0x000fe40003fbd000ULL, 0x000000e500a87245ULL, 0x000fc4000020d400ULL,
0x000000ea00a77245ULL, 0x000fc6000020d400ULL, 0x000000b000097306ULL, 0x0002ac0000205400ULL,
0x000000015e5e5812ULL, 0x000fe400078efcffULL, 0x000000b800bd7306ULL, 0x000fe20000209400ULL,
0x000000b000b07245ULL, 0x002fce000020d400ULL, 0x000000b800be7306ULL, 0x0002e20000205400ULL,
0x00000009b100720bULL, 0x004fce0003f7d000ULL, 0x000000e500ad7306ULL, 0x000fe20000209400ULL,
0x000000b800b87245ULL, 0x002fca000020d400ULL, 0x00000001b0b03812ULL, 0x000fe400078efcffULL,
0x000000e5004d7306ULL, 0x000e620000205400ULL, 0x000000bebd00720bULL, 0x008fce0003f1d000ULL,
0x0000000a00b67306ULL, 0x000fec0000209400ULL, 0x00000001b8b80812ULL, 0x000fe400078efcffULL,
0x0000000a00b77306ULL, 0x000ea20000205400ULL, 0x0000004dad00720bULL, 0x002fe40003f9d000ULL,
0x000000004c4c783bULL, 0x000e620000000200ULL, 0x000000c7b8c7723eULL, 0x000fc800000010ffULL,
0x000000e200097306ULL, 0x000fec0000209400ULL, 0x00000001a8a84812ULL, 0x000fe400078efcffULL,
0x000000e2000a7306ULL, 0x000ee20000205400ULL, 0x000000b7b600720bULL, 0x004fce0003f1d000ULL,
0x0000000800837306ULL, 0x000fec0000009400ULL, 0x000000015c5c0812ULL, 0x000fe400078efcffULL,
0x00000008008a7306ULL, 0x000ea20000005400ULL, 0x0000000a0900720bULL, 0x008fce0003fbd000ULL,
0x000000e900bf7306ULL, 0x000fe20000209400ULL, 0x000000344c4ca231ULL, 0x082fe400003400ffULL,
0x000000344e4ea231ULL, 0x000fe400003400ffULL, 0x000000354d4da231ULL, 0x000fc600003400ffULL,
0x000000e900b97306ULL, 0x000e620000205400ULL, 0x0000008a8300720bULL, 0x004fe20003f9d000ULL,
0x000000354f4fa231ULL, 0x000fe200003400ffULL, 0x000000e200837245ULL, 0x000fe4000020d400ULL,
0x00000018ff8a7819ULL, 0x000fe40000011452ULL, 0x0000000183835812ULL, 0x000fe200078efcffULL,
0x000000ea00bc7306ULL, 0x000fe20000209400ULL, 0x000000898800720bULL, 0x000fe20003fbd000ULL,
0x000000c64c14723cULL, 0x000fe20000041814ULL, 0x00000018ff897819ULL, 0x000fc40000011453ULL,
0x000000955a52723eULL, 0x000fe400000010ffULL, 0x00000094cf53723eULL, 0x000fe200000010ffULL,
0x000000ea00bd7306ULL, 0x000ea20000205400ULL, 0x000000b9bf00720bULL, 0x002fe40003fdd000ULL,
0x0000005bca5a723eULL, 0x000fe400000010ffULL, 0x000000d1c45b723eULL, 0x000fe200000010ffULL,
0x000000524c04723cULL, 0x040be20000041804ULL, 0x0000000169695812ULL, 0x000fe200078efcffULL,
0x00000008006a7306ULL, 0x000e6a000000d400ULL, 0x00000077c352723eULL, 0x020fe200000010ffULL,
0x0000005a4c0c723cULL, 0x000be2000004180cULL, 0x00000001aaaa6812ULL, 0x000fe200078efcffULL,
0x0000009600ac7306ULL, 0x000fe20000209400ULL, 0x000000bdbc00720bULL, 0x004fc40003f1d000ULL,
0x00000018ff777819ULL, 0x000fe40000011450ULL, 0x0000005d5c5a723eULL, 0x020fe400000010ffULL,
0x00000071aa5c723eULL, 0x000fe200000010ffULL, 0x0000009600087306ULL, 0x0004e20000205400ULL,
0x000000016a6a4812ULL, 0x002fe400078efcffULL, 0x0000008c9300720bULL, 0x000fe40003f9d000ULL,
0x00000076ba53723eULL, 0x000fc400000010ffULL, 0x00000001a7a70812ULL, 0x000fe200078efcffULL,
0x0000009800a07306ULL, 0x000fe20000209400ULL, 0x0000009600967245ULL, 0x004fe4000020d400ULL,
0x0000005ea75d723eULL, 0x000fe400000010ffULL, 0x000000a9b05b723eULL, 0x000fc600000010ffULL,
0x0000009800a17306ULL, 0x0002a20000205400ULL, 0x00000008ac00720bULL, 0x008fe40003f7d000ULL,
0x0000a00047087811ULL, 0x000fe400078e20ffULL, 0x0000000167674812ULL, 0x000fc600078efcffULL,
0x000000a600b47306ULL, 0x000fe20000209400ULL, 0x0000009800987245ULL, 0x002fca000020d400ULL,
0x0000000196963812ULL, 0x000fe400078efcffULL, 0x000000a600b57306ULL, 0x0002e20000205400ULL,
0x000000a1a000720bULL, 0x004fce0003fbd000ULL, 0x000000a500b37306ULL, 0x000fe20000209400ULL,
0x000000a600a67245ULL, 0x002fca000020d400ULL, 0x0000000198985812ULL, 0x000fe400078efcffULL,
0x000000a500b27306ULL, 0x0002a20000205400ULL, 0x000000b5b400720bULL, 0x008fce0003fdd000ULL,
0x0000000b00917306ULL, 0x000fe20000009400ULL, 0x000000a500a57245ULL, 0x002fca000020d400ULL,
0x00000001a6a66812ULL, 0x000fe400078efcffULL, 0x0000000b00857306ULL, 0x000fe20000005400ULL,
0x000000b2b300720bULL, 0x004fce0003f1d000ULL, 0x0000000b00667306ULL, 0x0003ec000000d400ULL,
0x00000001a5a50812ULL, 0x000fe400078efcffULL, 0x0000007f00977306ULL, 0x000fe20000209400ULL,
0x000100000b0b7824ULL, 0x002fe200078e00ffULL, 0x00000083a583723eULL, 0x000fc800000010ffULL,
0x00000018ffac7819ULL, 0x000fe4000001140bULL, 0x0000007f009c7306ULL, 0x000e620000205400ULL,
0x000000000808783bULL, 0x000eae0000000200ULL, 0x0000009b009a7306ULL, 0x000ff00000209400ULL,
0x0000009b00997306ULL, 0x0007220000205400ULL, 0x0000009c9700720bULL, 0x002fce0003fbd000ULL,
0x00000092008f7306ULL, 0x000fe20000209400ULL, 0x0000009b009b7245ULL, 0x008fce000020d400ULL,
0x00000092008d7306ULL, 0x0002e20000205400ULL, 0x000000999a00720bULL, 0x010fce0003fdd000ULL,
0x00000075007b7306ULL, 0x000fe20000209400ULL, 0x0000009200927245ULL, 0x002fe2000020d400ULL,
0x000000340808a231ULL, 0x084fe400003400ffULL, 0x000000340a0aa231ULL, 0x000fe400003400ffULL,
0x000000019b9b6812ULL, 0x000fe200078efcffULL, 0x000000350909a231ULL, 0x080fe200003400ffULL,
0x00000075007c7306ULL, 0x0002a20000205400ULL, 0x0000008d8f00720bULL, 0x008fe20003f1d000ULL,
0x000000350b0ba231ULL, 0x000fe200003400ffULL, 0x000000859100720bULL, 0x000fc40003fdd000ULL,
0x000000878400720bULL, 0x000fe40003f5d000ULL, 0x0000008200847245ULL, 0x000fe2000020d400ULL,
0x0000009d009e7306ULL, 0x000fe20000209400ULL, 0x0000007500757245ULL, 0x002fe4000020d400ULL,
0x00000018ff857819ULL, 0x000fc60000011459ULL, 0x0000000192920812ULL, 0x000fe400078efcffULL,
0x0000009d00a47306ULL, 0x0002e20000205400ULL, 0x0000007c7b00720bULL, 0x004fe40003f9d000ULL,
0x0000007f007b7245ULL, 0x000fe4000020d400ULL, 0x0000000166666812ULL, 0x000fe400078efcffULL,
0x000000017b7b5812ULL, 0x000fe200078efcffULL, 0x00000079007d7306ULL, 0x000fe20000209400ULL,
0x0000009d009d7245ULL, 0x002fc4000020d400ULL, 0x0000007acd7f723eULL, 0x000fe400000010ffULL,
0x0000000160602812ULL, 0x000fe400078efcffULL, 0x0000000175754812ULL, 0x000fe200078efcffULL,
0x0000007900ab7306ULL, 0x0002a20000205400ULL, 0x000000a49e00720bULL, 0x008fe20003f7d000ULL,
0x0000007e4c10723cULL, 0x000f6c0000041810ULL, 0x0000008200867306ULL, 0x000fe20000209400ULL,
0x0000007900797245ULL, 0x002fca000020d400ULL, 0x000000019d9d3812ULL, 0x000fe400078efcffULL,
0x00000082008e7306ULL, 0x0002e20000205400ULL, 0x000000ab7d00720bULL, 0x004fce0003fbd000ULL,
0x0000007000747306ULL, 0x000fe20000209400ULL, 0x000000a8a682723eULL, 0x002fca00000010ffULL,
0x0000000179795812ULL, 0x000fe400078efcffULL, 0x0000007000737306ULL, 0x0002a20000205400ULL,
0x0000008e8600720bULL, 0x008fe20003f1d000ULL, 0x000000824c3c723cULL, 0x000fec000004183cULL,
0x0000009f00a27306ULL, 0x000fe20000209400ULL, 0x0000007000707245ULL, 0x002fca000020d400ULL,
0x0000000184840812ULL, 0x000fe400078efcffULL, 0x0000009f00a37306ULL, 0x0002e20000205400ULL,
0x000000737400720bULL, 0x004fe40003fbd000ULL, 0x000000808100720bULL, 0x000fe40003f1d000ULL,
0x00000018ff817819ULL, 0x000fe40000011451ULL, 0x00000018ff747819ULL, 0x000fe20000011458ULL,
0x0000008a00997306ULL, 0x000fe20000209400ULL, 0x0000009f009f7245ULL, 0x002fe2000020d400ULL,
0x000000524c50723cULL, 0x000b680000041818ULL, 0x0000000170705812ULL, 0x000fc400078efcffULL,
0x0000008a00887306ULL, 0x0002a20000205400ULL, 0x000000a3a200720bULL, 0x008fe20003f7d000ULL,
0x0000005a4c58723cULL, 0x000b62000004181cULL, 0x0000000156560812ULL, 0x000fe400078efcffULL,
0x000000679818723eULL, 0x020fe400000010ffULL, 0x000000667b19723eULL, 0x000fe200000010ffULL,
0x000000ac00ad7306ULL, 0x000fe20000209400ULL, 0x0000008a008a7245ULL, 0x002fe4000020d400ULL,
0x0000009b921c723eULL, 0x000fc600000010ffULL, 0x000000019f9f3812ULL, 0x000fe200078efcffULL,
0x000000180818723cULL, 0x000fe20000041810ULL, 0x000000ac00ae7306ULL, 0x0002e20000205400ULL,
0x000000889900720bULL, 0x004fe40003f9d000ULL, 0x0000008b9000720bULL, 0x000fe40003f7d000ULL,
0x0000009f841d723eULL, 0x000fc600000010ffULL, 0x00000068005f7306ULL, 0x000fe20000209400ULL,
0x000000ac00ac7245ULL, 0x002fc6000020d400ULL, 0x0000001c081c723cULL, 0x000be4000004180cULL,
0x000000018a8a4812ULL, 0x000fe400078efcffULL, 0x00000068006d7306ULL, 0x0002a20000205400ULL,
0x000000aead00720bULL, 0x008fe40003fdd000ULL, 0x0000000157573812ULL, 0x000fe400078efcffULL,
0x00000081000d7245ULL, 0x020fe4000020d400ULL, 0x000000608a10723eULL, 0x000fe200000010ffULL,
0x00000089008c7306ULL, 0x000fe20000209400ULL, 0x0000006800687245ULL, 0x002fca000020d400ULL,
0x00000001acac6812ULL, 0x000fe400078efcffULL, 0x00000089008d7306ULL, 0x0002e20000205400ULL,
0x0000006d5f00720bULL, 0x004fe40003fbd000ULL, 0x0000006e6f00720bULL, 0x000fe20003fdd000ULL,
0x0000005c4c5c723cULL, 0x000b680000041820ULL, 0x00000062006c7306ULL, 0x000fe20000209400ULL,
0x0000008900897245ULL, 0x002fc4000020d400ULL, 0x0000006a9620723eULL, 0x020fe400000010ffULL,
0x000000699d21723eULL, 0x000fe400000010ffULL, 0x0000000168685812ULL, 0x000fe200078efcffULL,
0x00000062006b7306ULL, 0x0002a20000205400ULL, 0x0000008d8c00720bULL, 0x008fe40003f9d000ULL,
0x000000014b4b6812ULL, 0x000fe200078efcffULL, 0x000000200820723cULL, 0x000b680000041804ULL,
0x0000008500867306ULL, 0x000fe20000209400ULL, 0x0000006200627245ULL, 0x002fc4000020d400ULL,
0x000000797504723eULL, 0x020fe400000010ffULL, 0x000000ac7005723eULL, 0x000fe400000010ffULL,
0x0000000189894812ULL, 0x000fe200078efcffULL, 0x0000008500807306ULL, 0x0002e20000205400ULL,
0x0000006b6c00720bULL, 0x004fe40003f5d000ULL, 0x000000578911723eULL, 0x000fe200000010ffULL,
0x000000040814723cULL, 0x000b680000041814ULL, 0x00000081007c7306ULL, 0x000fe20000209400ULL,
0x0000008500857245ULL, 0x002fc4000020d400ULL, 0x0000007400057245ULL, 0x020fe2000020d400ULL,
0x000000100810723cULL, 0x000b640000041850ULL, 0x0000000162622812ULL, 0x000fe400078efcffULL,
0x00000081007a7306ULL, 0x000e620000205400ULL, 0x000000808600720bULL, 0x008fce0003f9d000ULL,
0x0000007700767306ULL, 0x000fec0000209400ULL, 0x0000000185854812ULL, 0x000fe400078efcffULL,
0x0000007700737306ULL, 0x0004e20000205400ULL, 0x0000007a7c00720bULL, 0x002fe40003f7d000ULL,
0x00000085680c723eULL, 0x000fca00000010ffULL, 0x00000074006e7306ULL, 0x000fe20000209400ULL,
0x0000007700777245ULL, 0x004fca000020d400ULL, 0x000000010d0d3812ULL, 0x000fe400078efcffULL,
0x00000074006d7306ULL, 0x000e620000205400ULL, 0x000000737600720bULL, 0x008fe40003fbd000ULL,
0x0000000d620d723eULL, 0x000fca00000010ffULL, 0x0000004a00647306ULL, 0x000fe40000209400ULL,
0x0000000c080c723cULL, 0x000b680000041858ULL, 0x0000000177775812ULL, 0x000fe400078efcffULL,
0x0000004a00657306ULL, 0x0004e20000205400ULL, 0x0000006d6e00720bULL, 0x002fe40003f5d000ULL,
0x000000567704723eULL, 0x000fca00000010ffULL, 0x0000004900617306ULL, 0x000fe20000209400ULL,
0x0000004a004a7245ULL, 0x004fca000020d400ULL, 0x0000000105052812ULL, 0x000fe400078efcffULL,
0x0000004900637306ULL, 0x0002a20000205400ULL, 0x000000656400720bULL, 0x008fe40003f9d000ULL,
0x0000004b0505723eULL, 0x000fe400000010ffULL, 0x00000072004b7245ULL, 0x000fc6000020d400ULL,
0x00000078006b7306ULL, 0x000fe20000209400ULL, 0x0000004900497245ULL, 0x002fca000020d400ULL,
0x000000014a4a4812ULL, 0x000fe400078efcffULL, 0x00000078004c7306ULL, 0x0002e20000205400ULL,
0x000000636100720bULL, 0x004fce0003f7d000ULL, 0x0000007200067306ULL, 0x000fe20000209400ULL,
0x0000007800787245ULL, 0x002fca000020d400ULL, 0x0000000149493812ULL, 0x000fe400078efcffULL,
0x0000007200077306ULL, 0x000e620000205400ULL, 0x0000004c6b00720bULL, 0x008fda0003fbd000ULL,
0x0000000178785812ULL, 0x000fe400078efcffULL, 0x000000070600720bULL, 0x002fe40003f1d000ULL,
0x000000784a4a723eULL, 0x000fe200000010ffULL, 0x000000040804723cULL, 0x000b74000004185cULL,
0x000000014b4b0812ULL, 0x000fc800078efcffULL, 0x0000004b494b723eULL, 0x000fce00000010ffULL,
0x0000004a0808723cULL, 0x000b62000004183cULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff3c7f8cULL, 0x020e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000244100720cULL, 0x000fe20003f06070ULL,
0x01068800ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff4b7224ULL, 0x002fe400078e003dULL,
0x000000ffff4a7224ULL, 0x000fd200078e0054ULL, 0x0001209000000947ULL, 0x000fea0003800000ULL,
0x00000000003c7805ULL, 0x000fc40000015200ULL, 0x0106bc00ff287984ULL, 0x000e640000000800ULL,
0x8000000028ff7812ULL, 0x002fe4000780484bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff497224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104900780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003e7805ULL, 0x000fcc0000015200ULL,
0x0000003e3c3e7210ULL, 0x000fca0007f1e1ffULL, 0x000000013f3f7824ULL, 0x000fe200000e0e3dULL,
0x003d09003e00780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403e00780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff287819ULL, 0x000fc8000001143fULL, 0x0000003e28287211ULL, 0x000fca00078110ffULL,
0x000000ffff3e7224ULL, 0x000fca00000e063fULL, 0x0000000228287819ULL, 0x000fc8000000123eULL,
0x000000280000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000149497810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106bc00ff287984ULL, 0x000e640000000800ULL, 0x8000000028ff7812ULL, 0x002fe4000780484bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000046000009947ULL, 0x000fea0003800000ULL,
0x0000002041287810ULL, 0x000fe20007ffe0ffULL, 0x00000001273d7824ULL, 0x000fe200078e0236ULL,
0x0000000436527810ULL, 0x000fe40007ffe0ffULL, 0x00000028243c7217ULL, 0x000fe20007800000ULL,
0x000000013d3e7824ULL, 0x040fe200078e0203ULL, 0x00000002364b7810ULL, 0x040fe20007ffe0ffULL,
0x000000103d507824ULL, 0x000fe200078e00ffULL, 0x0000000636567810ULL, 0x000fe20007ffe0ffULL,
0x000000013c3c7824ULL, 0x000fe200078e0a28ULL, 0x0000006000287811ULL, 0x000fe200078e38ffULL,
0x0000000127497824ULL, 0x040fe200078e0252ULL, 0xfffffff050507812ULL, 0x000fe200078ee23eULL,
0x00000001273f7824ULL, 0x040fe200078e024bULL, 0x0000003c273c7217ULL, 0x000fe20007800000ULL,
0x00000001494a7824ULL, 0x040fe200078e0203ULL, 0x000000f02e4f7812ULL, 0x000fe200078ec0ffULL,
0x0000001049537824ULL, 0x000fe200078e00ffULL, 0x0000e00050507811ULL, 0x000fe200078e20ffULL,
0x000000013d3d7824ULL, 0x000fc400078e0228ULL, 0x000000013f3e7824ULL, 0x100fe200078e0203ULL,
0xfffffff053537812ULL, 0x000fe200078ee24aULL, 0x000000103f517824ULL, 0x000fe200078e00ffULL,
0x0000003d554e7210ULL, 0x000fe20007f1e0ffULL, 0x00000001274a7824ULL, 0x000fe200078e0256ULL,
0x0000e00053537811ULL, 0x000fe200078e20ffULL, 0x000000013f3d7824ULL, 0x000fe200078e0228ULL,
0xfffffff051517812ULL, 0x000fe200078ee23eULL, 0x00000001493e7824ULL, 0x100fe400078e0228ULL,
0x000000014a3f7824ULL, 0x040fe200078e0228ULL, 0x0000003d553d7210ULL, 0x040fe20007f9e0ffULL,
0x000000014a4c7824ULL, 0x040fe200078e0203ULL, 0x0000003e553e7210ULL, 0x040fe20007f7e0ffULL,
0x000000104a4d7824ULL, 0x000fe200078e00ffULL, 0x0000003f553f7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff497224ULL, 0x000fe200000e06ffULL, 0x00005e004e4a7a11ULL, 0x000fe200078040ffULL,
0x000000013c287824ULL, 0x000fe200078e0a27ULL, 0xfffffff04d557812ULL, 0x000fe200078ee24cULL,
0x000000ffff4d7224ULL, 0x000fe200020e06ffULL, 0x00005f004e4e7a11ULL, 0x000fc400000f4449ULL,
0x000000284b00720cULL, 0x080fe20003f06070ULL, 0x000000ffff4b7224ULL, 0x000fe200018e06ffULL,
0x00005e003d4c7a11ULL, 0x040fe400078c40ffULL, 0x00005e003e497a11ULL, 0x000fe400078a40ffULL,
0x000000283600720cULL, 0x000fe40003f86070ULL, 0x00005f003d4d7a11ULL, 0x000fe400030f444dULL,
0x00005f003e4b7a11ULL, 0x000fe200028f444bULL, 0x000000ffff3e7224ULL, 0x000fe200010e06ffULL,
0x0000004f4a3c7210ULL, 0x000fc40007fde0ffULL, 0x00005e003f4a7a11ULL, 0x040fe400078a40ffULL,
0x000000285200720cULL, 0x080fe20003f66070ULL, 0x000000ffff3d7224ULL, 0x000fe200030e064eULL,
0x000000285600720cULL, 0x000fe40003f46070ULL, 0x00005f003f287a11ULL, 0x000fe400028f443eULL,
0x0000004f4c3e7210ULL, 0x000fe20007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c507faeULL, 0x0003e2000e101c46ULL, 0x0000e00051517811ULL, 0x000fc400078e20ffULL,
0x0000e00055557811ULL, 0x000fe200078e20ffULL, 0x000000ffff3f7224ULL, 0x000fe200028e064dULL,
0x0000004f4a4a7210ULL, 0x000fc80007fbe0ffULL, 0x000000003e517faeULL, 0x0005e2000c101c46ULL,
0x0000004f493c7210ULL, 0x002fca0007f9e0ffULL, 0x000000ffff3d7224ULL, 0x000fe400020e064bULL,
0x000000ffff4b7224ULL, 0x000fc600028e0628ULL, 0x000000003c537faeULL, 0x0005e8000d901c46ULL,
0x000000004a557faeULL, 0x0005e2000d101c46ULL, 0x0000039000007947ULL, 0x000fea0003800000ULL,
0x0000000127287824ULL, 0x000fe200078e0236ULL, 0x00000060003d7811ULL, 0x000fe400078e38ffULL,
0x000000f02e4f7812ULL, 0x000fe200078ec0ffULL, 0x00000001283c7824ULL, 0x040fe200078e0203ULL,
0x00000002283f7810ULL, 0x040fe20007ffe0ffULL, 0x0000001028507824ULL, 0x040fe200078e00ffULL,
0x0000000428497810ULL, 0x000fc40007ffe0ffULL, 0x00000006284a7810ULL, 0x000fe20007ffe0ffULL,
0x000000013f3e7824ULL, 0x040fe200078e0203ULL, 0xfffffff050507812ULL, 0x000fe200078ee23cULL,
0x000000103f517824ULL, 0x040fe400078e00ffULL, 0x00000001283c7824ULL, 0x100fe200078e023dULL,
0x0000e00050507811ULL, 0x000fe200078e20ffULL, 0x000000013f287824ULL, 0x000fe200078e023dULL,
0xfffffff051517812ULL, 0x000fe200078ee23eULL, 0x00000001493f7824ULL, 0x000fe200078e0203ULL,
0x0000003c553e7210ULL, 0x000fe20007f7e0ffULL, 0x00000001493c7824ULL, 0x000fc400078e023dULL,
0x000000014a3d7824ULL, 0x000fe200078e023dULL, 0x00005e003e4c7a11ULL, 0x000fe200078840ffULL,
0x0000001049527824ULL, 0x000fe200078e00ffULL, 0x0000002855497210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff287224ULL, 0x000fe200018e06ffULL, 0x0000003c553c7210ULL, 0x040fe20007f5e0ffULL,
0x000000014a4b7824ULL, 0x040fe200078e0203ULL, 0x0000003d553d7210ULL, 0x000fe20007f7e0ffULL,
0x000000104a537824ULL, 0x000fe200078e00ffULL, 0xfffffff052527812ULL, 0x000fe200078ee23fULL,
0x000000ffff4d7224ULL, 0x000fe200000e06ffULL, 0x00005f003e4e7a11ULL, 0x000fe200020f4428ULL,
0x000000ffff3f7224ULL, 0x000fe200010e06ffULL, 0xfffffff053537812ULL, 0x000fe200078ee24bULL,
0x000000ffff4b7224ULL, 0x000fe200018e06ffULL, 0x00005e0049287a11ULL, 0x000fc400078040ffULL,
0x00005e003c3e7a11ULL, 0x000fe400078440ffULL, 0x0000004f4c4c7210ULL, 0x080fe40007f9e0ffULL,
0x00005e003d4a7a11ULL, 0x000fe400078640ffULL, 0x00005f0049497a11ULL, 0x000fe200000f444dULL,
0x000000ffff4d7224ULL, 0x000fe200020e064eULL, 0x00005f003c3f7a11ULL, 0x000fe400010f443fULL,
0x0000004f283c7210ULL, 0x000fc40007f1e0ffULL, 0x00005f003d4b7a11ULL, 0x000fe200018f444bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000004c507faeULL, 0x0003e2000b901c46ULL,
0x0000004f3e3e7210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff3d7224ULL, 0x000fe200000e0649ULL,
0x0000004f4a4a7210ULL, 0x000fe40007f7e0ffULL, 0x0000e00051287811ULL, 0x000fe200078e20ffULL,
0x000000ffff3f7224ULL, 0x000fe200010e063fULL, 0x0000e00052497811ULL, 0x000fe200078e20ffULL,
0x000000ffff4b7224ULL, 0x000fe400018e064bULL, 0x000000003c287faeULL, 0x0005e2000b901c46ULL,
0x0000e000534c7811ULL, 0x002fc600078e20ffULL, 0x000000003e497faeULL, 0x0005e8000b901c46ULL,
0x000000004a4c7faeULL, 0x0005e4000b901c46ULL, 0x0000000000007918ULL, 0x004fe20000000000ULL,
0x000000012c287810ULL, 0x000fc80007ffe0ffULL, 0x000000252800720cULL, 0x000fe20003f06070ULL,
0xffffffffff287424ULL, 0x000fd800078e00ffULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x000000012a3c7810ULL, 0x000fe20007ffe02cULL, 0x00000004ff3d7424ULL, 0x000fc800078e00ffULL,
0x000060003c3c7625ULL, 0x000fca00078e003dULL, 0x000000063c287981ULL, 0x000324000c1e1900ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b000ff587f8cULL, 0x000ea2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01062800274a7f8cULL, 0x000664000c80043fULL,
0x00000000003c7805ULL, 0x002fc40000015200ULL, 0x01062c00273e7984ULL, 0x000e640000000800ULL,
0x800000003eff7812ULL, 0x002fe4000780484bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003e7805ULL, 0x000fcc0000015200ULL,
0x0000003e3c497210ULL, 0x000fca0007f1e1ffULL, 0x000000013f3f7824ULL, 0x000fe200000e0e3dULL,
0x003d09004900780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404900780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3e7819ULL, 0x000fc8000001143fULL, 0x000000493e3e7211ULL, 0x000fca00078110ffULL,
0x000000ffff3f7224ULL, 0x000fca00000e063fULL, 0x000000023e3e7819ULL, 0x000fc8000000123fULL,
0x0000003e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000014c4c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01062c00273e7984ULL, 0x000e640000000800ULL, 0x800000003eff7812ULL, 0x002fe4000780484bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x010080002f3e7984ULL, 0x000e680000000800ULL,
0x010280002f3f7984ULL, 0x0006a20000000800ULL, 0x000000543e00720bULL, 0x002fe20003f1d000ULL,
0x000184727f007947ULL, 0x000fd8000b800000ULL, 0x0000000000497806ULL, 0x008fc800000e0100ULL,
0x0000ffff49ff7812ULL, 0x000fe2000780c0ffULL, 0x000004a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff4b7424ULL, 0x000fc400078e00ffULL, 0x000000ffff4a7224ULL, 0x000fd200078e0054ULL,
0x0000046000008947ULL, 0x000fea0003800000ULL, 0x000000010200780cULL, 0x000fe40003f05270ULL,
0x000000543e00720bULL, 0x000fe20003f54000ULL, 0x000184327f007947ULL, 0x000fd8000b800000ULL,
0x00000000003c7806ULL, 0x000fc400010e0100ULL, 0x000000543e3d8209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe80003800000ULL, 0x0104803d2f008388ULL, 0x0003e40000000800ULL,
0x000099103c3d7816ULL, 0x002fc800000000ffULL, 0x000000ff3d00720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x000000543e3d7209ULL, 0x000fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff3cff7812ULL, 0x000fc6000780c0ffULL,
0x000000543d3d7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b3d3d7820ULL, 0x000fc80000410000ULL,
0x0000003d004a7308ULL, 0x000e640000000800ULL, 0x0000004a29297220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff3d7819ULL, 0x000fe20000011603ULL,
0x000183727f007947ULL, 0x000fea000b800000ULL, 0x00001f3d4a3d7589ULL, 0x0002e400000e0000ULL,
0x0000003d20207220ULL, 0x088fe20000410000ULL, 0x0000003d21217220ULL, 0x080fe20000410000ULL,
0x0000003d1c1c7220ULL, 0x080fe20000410000ULL, 0x0000003d1d1d7220ULL, 0x080fe20000410000ULL,
0x0000003d18187220ULL, 0x080fe20000410000ULL, 0x0000003d19197220ULL, 0x080fe20000410000ULL,
0x0000003d14147220ULL, 0x080fe20000410000ULL, 0x0000003d15157220ULL, 0x080fe20000410000ULL,
0x0000003d10107220ULL, 0x080fe20000410000ULL, 0x0000003d11117220ULL, 0x080fe20000410000ULL,
0x0000003d0c0c7220ULL, 0x080fe20000410000ULL, 0x0000003d0d0d7220ULL, 0x080fe20000410000ULL,
0x0000003d04047220ULL, 0x080fe20000410000ULL, 0x0000003d05057220ULL, 0x080fe20000410000ULL,
0x0000003d08087220ULL, 0x080fe20000410000ULL, 0x0000003d09097220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff003cff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008033d7811ULL, 0x000fe200078ff0ffULL,
0x000182727f007947ULL, 0x000fea000b800000ULL, 0x00001f3d4a3d7589ULL, 0x00066400000e0000ULL,
0x0000003d22227220ULL, 0x082fe20000410000ULL, 0x0000003d23237220ULL, 0x080fe20000410000ULL,
0x0000003d1e1e7220ULL, 0x080fe20000410000ULL, 0x0000003d1f1f7220ULL, 0x080fe20000410000ULL,
0x0000003d1a1a7220ULL, 0x080fe20000410000ULL, 0x0000003d1b1b7220ULL, 0x080fe20000410000ULL,
0x0000003d16167220ULL, 0x080fe20000410000ULL, 0x0000003d17177220ULL, 0x080fe20000410000ULL,
0x0000003d12127220ULL, 0x080fe20000410000ULL, 0x0000003d13137220ULL, 0x080fe20000410000ULL,
0x0000003d0e0e7220ULL, 0x080fe20000410000ULL, 0x0000003d0f0f7220ULL, 0x080fe20000410000ULL,
0x0000003d06067220ULL, 0x080fe20000410000ULL, 0x0000003d07077220ULL, 0x080fe20000410000ULL,
0x0000003d0a0a7220ULL, 0x080fe20000410000ULL, 0x0000003d0b0b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000ffff3cff7812ULL, 0x000fe20007800849ULL,
0x00000001ff4b7424ULL, 0x000fe200078e00ffULL, 0x000000543e547209ULL, 0x000fca0007810000ULL,
0x000000ffff4a7224ULL, 0x00afcc00078e0054ULL, 0x800000543e3e0221ULL, 0x100fe20000010000ULL,
0x000000ffff4a0224ULL, 0x000fe200078e0054ULL, 0x00007610ff4b0816ULL, 0x000fe4000000004bULL,
0x3fb8aa3b3e3e0820ULL, 0x000fc80000410000ULL, 0x0000003e00330308ULL, 0x000e640000000800ULL,
0x000000333f3f0220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000293f297221ULL, 0x004fc20000010000ULL, 0x00000000003c7805ULL, 0x000fcc0000015200ULL,
0x0106ac00ff3e7984ULL, 0x000e640000000800ULL, 0x800000003eff7812ULL, 0x002fe40007804848ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff4c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003e7805ULL, 0x000fcc0000015200ULL, 0x0000003e3c497210ULL, 0x000fca0007f1e1ffULL,
0x000000013f3f7824ULL, 0x000fe200000e0e3dULL, 0x003d09004900780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404900780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3e7819ULL, 0x000fc8000001143fULL,
0x000000493e3e7211ULL, 0x000fca00078110ffULL, 0x000000ffff3f7224ULL, 0x000fca00000e063fULL,
0x000000023e3e7819ULL, 0x000fc8000000123fULL, 0x0000003e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000014c4c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106ac00ff3e7984ULL, 0x000e640000000800ULL,
0x800000003eff7812ULL, 0x002fe40007804848ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099104b3c7816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff3c00720cULL, 0x000fda0003f45270ULL, 0x0000012000002947ULL, 0x000fea0003800000ULL,
0x00000033ff34723eULL, 0x000fe400000010ffULL, 0x00000002ff3d7819ULL, 0x000fe40000011603ULL,
0x00005410343c7816ULL, 0x000fe20000000034ULL, 0x00017e427f007947ULL, 0x000fea000b800000ULL,
0x00001f3d3c347589ULL, 0x0002a400000e0000ULL, 0x000000083d357810ULL, 0x000fe20007ffe0ffULL,
0x00017e727f007947ULL, 0x000fea000b800000ULL, 0x00001f353c357589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000103d4b7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4d7224ULL, 0x000fe200078e003cULL, 0x00008bb0004c7802ULL, 0x000fc40000000f00ULL,
0x000189a000007944ULL, 0x01efea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000183d4b7810ULL, 0x004fe20007ffe0ffULL, 0x000000ffff4d7224ULL, 0x000fe200078e003cULL,
0x00008c00004c7802ULL, 0x000fc40000000f00ULL, 0x0001895000007944ULL, 0x01afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000003750783bULL, 0x000ee80000004200ULL, 0x000000003854783bULL, 0x000ea80000004200ULL,
0x00000000394c783bULL, 0x000e680000004200ULL, 0x000000003a3c783bULL, 0x00ae620000004200ULL,
0x00000018ffc77819ULL, 0x000fe20000011450ULL, 0x0001000050d87824ULL, 0x000fe200078e00ffULL,
0x0000005100ce7306ULL, 0x000fe20000009400ULL, 0x00000018ffbb7819ULL, 0x000fe20000011451ULL,
0x0000010053c27824ULL, 0x040fe200078e00ffULL, 0x00000018ffb17819ULL, 0x000fe20000011452ULL,
0x0001000052c37824ULL, 0x000fe200078e00ffULL, 0x00000018ffd87819ULL, 0x000fe200000114d8ULL,
0x0000010056a27824ULL, 0x044fe200078e00ffULL, 0x00000018ffc27819ULL, 0x000fe200000114c2ULL,
0x000000c700cc7306ULL, 0x000fe20000209400ULL, 0x00000018ff867819ULL, 0x000fe20000011456ULL,
0x00010000569d7824ULL, 0x000fe200078e00ffULL, 0x00000018ffc37819ULL, 0x000fe200000114c3ULL,
0x0001000053c67824ULL, 0x000fe200078e00ffULL, 0x00000018ffa47819ULL, 0x000fe20000011453ULL,
0x0000010054ba7824ULL, 0x000fe200078e00ffULL, 0x00000018ff987819ULL, 0x000fe20000011454ULL,
0x000000c700cd7306ULL, 0x0004e20000205400ULL, 0x0000010050d77824ULL, 0x000fe200078e00ffULL,
0x00000018ffc67819ULL, 0x000fe200000114c6ULL, 0x0000010055aa7824ULL, 0x000fe200078e00ffULL,
0x00000018ffba7819ULL, 0x000fe200000114baULL, 0x0001000054ab7824ULL, 0x000fe200078e00ffULL,
0x00000018ffd77819ULL, 0x000fe200000114d7ULL, 0x0000010051d27824ULL, 0x040fe200078e00ffULL,
0x000000d800e07306ULL, 0x000fe20000209400ULL, 0x000000c700c77245ULL, 0x004fe2000020d400ULL,
0x0001000051d17824ULL, 0x000fe200078e00ffULL, 0x00000018ffaa7819ULL, 0x000fe200000114aaULL,
0x0001000055a67824ULL, 0x000fe200078e00ffULL, 0x00000018ffab7819ULL, 0x000fe200000114abULL,
0x0000010052c17824ULL, 0x000fe200078e00ffULL, 0x00000018ffd27819ULL, 0x000fe200000114d2ULL,
0x000000d800e17306ULL, 0x000ea20000205400ULL, 0x000000cdcc00720bULL, 0x008fe20003f1d000ULL,
0x0000010057a07824ULL, 0x000fe200078e00ffULL, 0x00000018ffd17819ULL, 0x000fc400000114d1ULL,
0x00000018ffa67819ULL, 0x000fe400000114a6ULL, 0x00000018ffa27819ULL, 0x000fe200000114a2ULL,
0x0000005100cb7306ULL, 0x000ee20000005400ULL, 0x00000018ffc17819ULL, 0x000fe400000114c1ULL,
0x00000018ffa07819ULL, 0x000fe400000114a0ULL, 0x00000018ff9d7819ULL, 0x000fe4000001149dULL,
0x00000001c7c70812ULL, 0x000fe200078efcffULL, 0x0000005200bc7306ULL, 0x000fe20000009400ULL,
0x000000e1e000720bULL, 0x004fc40003fbd000ULL, 0x00000018ff837819ULL, 0x000fe40000011457ULL,
0x00000018ff977819ULL, 0x000fe40000011455ULL, 0x00000018ff7d7819ULL, 0x000fe2000001144dULL,
0x0000005200bd7306ULL, 0x000ea20000005400ULL, 0x000000cbce00720bULL, 0x008fe40003f9d000ULL,
0x00000018ff767819ULL, 0x000fe4000001144eULL, 0x00000018ff8d7819ULL, 0x000fc4000001144cULL,
0x00000018ff497819ULL, 0x002fe2000001143fULL, 0x000000bb00bf7306ULL, 0x000fe20000209400ULL,
0x00000018ff667819ULL, 0x000fe4000001143cULL, 0x00000018ff617819ULL, 0x000fe4000001143dULL,
0x00000018ff487819ULL, 0x000fe4000001143eULL, 0x00000018ff6e7819ULL, 0x000fe2000001144fULL,
0x000000bb00c07306ULL, 0x0003e20000205400ULL, 0x000000bdbc00720bULL, 0x004fe20003f1d000ULL,
0x000001003dbd7824ULL, 0x000fca00078e00ffULL, 0x00000018ffbd7819ULL, 0x000fe200000114bdULL,
0x00000051007e7306ULL, 0x0004e2000000d400ULL, 0x000000bb00bb7245ULL, 0x002fce000020d400ULL,
0x00000052007a7306ULL, 0x000e62000000d400ULL, 0x000001004c517824ULL, 0x004fca00078e00ffULL,
0x00000018ff517819ULL, 0x000fe40000011451ULL, 0x000000b100b77306ULL, 0x000fe20000209400ULL,
0x000000017e7e4812ULL, 0x008fce00078efcffULL, 0x000000b100b47306ULL, 0x0004e20000205400ULL,
0x000000017a7a0812ULL, 0x002fce00078efcffULL, 0x000000c200d47306ULL, 0x000fe20000209400ULL,
0x000000b100b17245ULL, 0x004fce000020d400ULL, 0x000000c200d97306ULL, 0x0002a20000205400ULL,
0x000000b4b700720bULL, 0x008fe20003f1d000ULL, 0x000100003cb77824ULL, 0x000fca00078e00ffULL,
0x00000018ffb77819ULL, 0x000fe200000114b7ULL, 0x00000056009b7306ULL, 0x000fe20000009400ULL,
0x000000c200c27245ULL, 0x002fca000020d400ULL, 0x00000001b1b10812ULL, 0x000fe400078efcffULL,
0x00000056009c7306ULL, 0x000fe20000005400ULL, 0x000000d9d400720bULL, 0x004fce0003f9d000ULL,
0x00000056006d7306ULL, 0x0003ec000000d400ULL, 0x00000001c2c24812ULL, 0x000fe400078efcffULL,
0x000000c300c97306ULL, 0x000fe20000209400ULL, 0x000000d800567245ULL, 0x002fc8000020d400ULL,
0x0000000156565812ULL, 0x000fe400078efcffULL, 0x000000c0bf00720bULL, 0x000fe20003fbd000ULL,
0x000000c300ca7306ULL, 0x0002b00000205400ULL, 0x000000c600cf7306ULL, 0x000fe20000209400ULL,
0x000000c300c37245ULL, 0x002fc6000020d400ULL, 0x00000001bbbb5812ULL, 0x000fc800078efcffULL,
0x000000c600d07306ULL, 0x0002e20000205400ULL, 0x000000cac900720bULL, 0x004fce0003fbd000ULL,
0x000000ba00c57306ULL, 0x000fe20000209400ULL, 0x000000c600c67245ULL, 0x002fca000020d400ULL,
0x00000001c3c35812ULL, 0x000fe400078efcffULL, 0x000000ba00c47306ULL, 0x0002a20000205400ULL,
0x000000d0cf00720bULL, 0x008fce0003f9d000ULL, 0x0000005000d37306ULL, 0x000fe20000009400ULL,
0x000000ba00ba7245ULL, 0x002fca000020d400ULL, 0x00000001c6c64812ULL, 0x000fe400078efcffULL,
0x0000005000dd7306ULL, 0x000e620000005400ULL, 0x000000c4c500720bULL, 0x004fce0003f1d000ULL,
0x000000d700de7306ULL, 0x000fec0000209400ULL, 0x00000001baba0812ULL, 0x000fe400078efcffULL,
0x000000d700df7306ULL, 0x000ea20000205400ULL, 0x000000ddd300720bULL, 0x002fe20003f7d000ULL,
0x000001004ddd7824ULL, 0x000fcc00078e00ffULL, 0x000000a400ac7306ULL, 0x000ff00000209400ULL,
0x000000a400ad7306ULL, 0x0002e20000205400ULL, 0x000000dfde00720bULL, 0x004fe20003fdd000ULL,
0x000001004ede7824ULL, 0x000fca00078e00ffULL, 0x00000018ffde7819ULL, 0x000fe200000114deULL,
0x0000005400b57306ULL, 0x000fe20000009400ULL, 0x000000a400a47245ULL, 0x002fce000020d400ULL,
0x0000005400b67306ULL, 0x000fe20000005400ULL, 0x000000adac00720bULL, 0x008fe20003fbd000ULL,
0x000001003fac7824ULL, 0x000fe400078e00ffULL, 0x000001003ead7824ULL, 0x000fc600078e00ffULL,
0x00000018ffac7819ULL, 0x000fe200000114acULL, 0x0000005400757306ULL, 0x000fe2000000d400ULL,
0x00000018ffad7819ULL, 0x000fca00000114adULL, 0x00000001a4a45812ULL, 0x000fe400078efcffULL,
0x000000aa00c87306ULL, 0x000ff00000209400ULL, 0x000000aa00547306ULL, 0x0002b00000205400ULL,
0x000000ab00ae7306ULL, 0x000fe20000209400ULL, 0x000000aa00aa7245ULL, 0x002fce000020d400ULL,
0x000000ab00be7306ULL, 0x0002e20000205400ULL, 0x00000054c800720bULL, 0x004fe20003f9d000ULL,
0x000100003f547824ULL, 0x000fca00078e00ffULL, 0x00000018ff547819ULL, 0x000fe20000011454ULL,
0x0000005000887306ULL, 0x0004a2000000d400ULL, 0x000000ab00ab7245ULL, 0x002fca000020d400ULL,
0x00000001aaaa4812ULL, 0x000fe400078efcffULL, 0x000000d200dc7306ULL, 0x000fe20000209400ULL,
0x000000beae00720bULL, 0x008fe20003f1d000ULL, 0x0001000057507824ULL, 0x004fca00078e00ffULL,
0x00000018ff507819ULL, 0x000fe20000011450ULL, 0x000000d200e27306ULL, 0x0003e20000205400ULL,
0x0000000188883812ULL, 0x000fca00078efcffULL, 0x00000001abab0812ULL, 0x000fe400078efcffULL,
0x000000d100db7306ULL, 0x000fe20000209400ULL, 0x000000d200d27245ULL, 0x002fce000020d400ULL,
0x000000d100da7306ULL, 0x0002b00000205400ULL, 0x00000098009e7306ULL, 0x000fe20000209400ULL,
0x000000d100d17245ULL, 0x002fce000020d400ULL, 0x00000098009f7306ULL, 0x0002e20000205400ULL,
0x000000dadb00720bULL, 0x004fce0003f7d000ULL, 0x0000005300b87306ULL, 0x000fe20000009400ULL,
0x0000009800987245ULL, 0x002fca000020d400ULL, 0x00000001d1d13812ULL, 0x000fe400078efcffULL,
0x0000005300b97306ULL, 0x000e620000005400ULL, 0x0000009f9e00720bULL, 0x008fce0003fbd000ULL,
0x0000005300797306ULL, 0x0004ec000000d400ULL, 0x0000000198985812ULL, 0x000fe400078efcffULL,
0x000000a600af7306ULL, 0x000fe20000209400ULL, 0x000000d700537245ULL, 0x004fe2000020d400ULL,
0x000100004fd77824ULL, 0x000fe200078e00ffULL, 0x000000b9b800720bULL, 0x002fc40003f7d000ULL,
0x0000000153536812ULL, 0x000fe400078efcffULL, 0x000000e2dc00720bULL, 0x000fe20003fdd000ULL,
0x000000a600b07306ULL, 0x0002a20000205400ULL, 0x00000018ffb87819ULL, 0x000fe400000114ddULL,
0x00000018ffd77819ULL, 0x000fe400000114d7ULL, 0x000000885388723eULL, 0x000fc600000010ffULL,
0x000000a200a77306ULL, 0x000fe20000209400ULL, 0x000000a600a67245ULL, 0x002fe4000020d400ULL,
0x0000000179793812ULL, 0x008fe400078efcffULL, 0x00000001d2d26812ULL, 0x000fc600078efcffULL,
0x000000a200a87306ULL, 0x0002e20000205400ULL, 0x000000b0af00720bULL, 0x004fce0003f9d000ULL,
0x000000c100d57306ULL, 0x000fe20000209400ULL, 0x000000a200a27245ULL, 0x002fca000020d400ULL,
0x00000001a6a64812ULL, 0x000fe400078efcffULL, 0x000000c100d67306ULL, 0x0002a20000205400ULL,
0x000000a8a700720bULL, 0x008fce0003f1d000ULL, 0x000000a000a57306ULL, 0x000fe20000209400ULL,
0x000000c100c17245ULL, 0x002fca000020d400ULL, 0x00000001a2a20812ULL, 0x000fe400078efcffULL,
0x000000a000a97306ULL, 0x0002e20000205400ULL, 0x000000d6d500720bULL, 0x004fce0003fdd000ULL,
0x0000005700927306ULL, 0x000fe20000009400ULL, 0x000000a000a07245ULL, 0x002fca000020d400ULL,
0x00000001c1c16812ULL, 0x000fe400078efcffULL, 0x0000005700907306ULL, 0x000e620000005400ULL,
0x000000a9a500720bULL, 0x008fe40003fbd000ULL, 0x000000b6b500720bULL, 0x000fe20003fdd000ULL,
0x000001003cb67824ULL, 0x000fe200078e00ffULL, 0x0000007ac17a723eULL, 0x000fc600000010ffULL,
0x00000057006f7306ULL, 0x000ea2000000d400ULL, 0x00000018ffb67819ULL, 0x000fca00000114b6ULL,
0x00000001a0a05812ULL, 0x000fe400078efcffULL, 0x0000009d00a17306ULL, 0x000fe20000209400ULL,
0x000000909200720bULL, 0x002fe40003f9d000ULL, 0x0000000175756812ULL, 0x000fe400078efcffULL,
0x0000009c9b00720bULL, 0x000fe40003fdd000ULL, 0x00000075baba723eULL, 0x000fe200000010ffULL,
0x0000009d00577306ULL, 0x0002ec0000205400ULL, 0x000000016f6f4812ULL, 0x004fc400078efcffULL,
0x0000005500b27306ULL, 0x000fe20000009400ULL, 0x0000009d009d7245ULL, 0x002fe4000020d400ULL,
0x000000016d6d6812ULL, 0x000fc800078efcffULL, 0x0000006da2a2723eULL, 0x000fe200000010ffULL,
0x0000005500b37306ULL, 0x000e620000005400ULL, 0x00000057a100720bULL, 0x008fe40003f1d000ULL,
0x0000005100577245ULL, 0x000fca000020d400ULL, 0x0000005000a37306ULL, 0x000fec0000209400ULL,
0x000000019d9d0812ULL, 0x000fe400078efcffULL, 0x0000005000d37306ULL, 0x000ea20000205400ULL,
0x000000b3b200720bULL, 0x002fe20003f7d000ULL, 0x000100003db27824ULL, 0x000fca00078e00ffULL,
0x00000018ffb27819ULL, 0x000fe200000114b2ULL, 0x0000005500707306ULL, 0x0002f0000000d400ULL,
0x00000083008f7306ULL, 0x000fe20000209400ULL, 0x000100004c557824ULL, 0x002fe200078e00ffULL,
0x000000d3a300720bULL, 0x004fc40003fbd000ULL, 0x0000006fa0a3723eULL, 0x000fe400000010ffULL,
0x00000018ffcc7819ULL, 0x000fe20000011455ULL, 0x000100003e557824ULL, 0x000fe200078e00ffULL,
0x0000008300937306ULL, 0x0002a20000205400ULL, 0x0000000170703812ULL, 0x008fc600078efcffULL,
0x00000018ff557819ULL, 0x000fc80000011455ULL, 0x0000005100527306ULL, 0x000fe20000209400ULL,
0x0000008300837245ULL, 0x002fce000020d400ULL, 0x0000005100cb7306ULL, 0x0002e20000205400ULL,
0x000000938f00720bULL, 0x004fce0003f9d000ULL, 0x00000097009a7306ULL, 0x000fe20000209400ULL,
0x000000c6a451723eULL, 0x002fca00000010ffULL, 0x0000000183834812ULL, 0x000fe400078efcffULL,
0x0000009700997306ULL, 0x0002a20000205400ULL, 0x000000cb5200720bULL, 0x008fe40003f1d000ULL,
0x0000005000527245ULL, 0x000fe4000020d400ULL, 0x000000c3b150723eULL, 0x000fe400000010ffULL,
0x0000000152525812ULL, 0x000fe200078efcffULL, 0x000000cc00bf7306ULL, 0x000fe20000209400ULL,
0x0000009700977245ULL, 0x002fc4000020d400ULL, 0x000000528383723eULL, 0x000fc600000010ffULL,
0x0000000157570812ULL, 0x000fe400078efcffULL, 0x000000cc00bc7306ULL, 0x0002e20000205400ULL,
0x000000999a00720bULL, 0x004fce0003f7d000ULL, 0x000000b800b97306ULL, 0x000fe20000209400ULL,
0x000000cc00cc7245ULL, 0x002fca000020d400ULL, 0x0000000197973812ULL, 0x000fe400078efcffULL,
0x000000b800b47306ULL, 0x0002a20000205400ULL, 0x000000bcbf00720bULL, 0x008fe40003fbd000ULL,
0x000000a69797723eULL, 0x000fca00000010ffULL, 0x0000004c00967306ULL, 0x000fe20000009400ULL,
0x000000b800b87245ULL, 0x002fca000020d400ULL, 0x00000001cccc5812ULL, 0x000fe400078efcffULL,
0x0000004c00917306ULL, 0x000e620000005400ULL, 0x000000b4b900720bULL, 0x004fce0003f9d000ULL,
0x0000008600947306ULL, 0x000fec0000209400ULL, 0x00000001b8b84812ULL, 0x000fe400078efcffULL,
0x0000008600957306ULL, 0x0004e20000205400ULL, 0x000000919600720bULL, 0x002fe40003f7d000ULL,
0x000000ab9896723eULL, 0x000fca00000010ffULL, 0x0000004e008c7306ULL, 0x000fe20000009400ULL,
0x0000008600867245ULL, 0x004fce000020d400ULL, 0x0000004e00807306ULL, 0x000e620000005400ULL,
0x000000959400720bULL, 0x008fce0003fdd000ULL, 0x0000004d008e7306ULL, 0x000fec0000009400ULL,
0x0000000186866812ULL, 0x000fe400078efcffULL, 0x0000004d00847306ULL, 0x000ea20000005400ULL,
0x000000808c00720bULL, 0x002fce0003fbd000ULL, 0x0000004d00697306ULL, 0x0002f0000000d400ULL,
0x0000004e00637306ULL, 0x0006e2000000d400ULL, 0x000100004d4d7824ULL, 0x002fe200078e00ffULL,
0x000000848e00720bULL, 0x004fc80003f1d000ULL, 0x00000018ffb37819ULL, 0x000fe4000001144dULL,
0x0000007d008a7306ULL, 0x000fe20000209400ULL, 0x000100004e4e7824ULL, 0x008fe200078e00ffULL,
0x000000b300cd7245ULL, 0x000fca000020d400ULL, 0x0000000169690812ULL, 0x000fe200078efcffULL,
0x0000007d00877306ULL, 0x0002a20000205400ULL, 0x0000000163635812ULL, 0x000fce00078efcffULL,
0x0000003f006c7306ULL, 0x000fe20000009400ULL, 0x0000007d007d7245ULL, 0x002fce000020d400ULL,
0x0000003f006b7306ULL, 0x000fe20000005400ULL, 0x000000878a00720bULL, 0x004fce0003f9d000ULL,
0x0000003f005a7306ULL, 0x0003ec000000d400ULL, 0x000000017d7d4812ULL, 0x000fe400078efcffULL,
0x0000008d00827306ULL, 0x000fe20000209400ULL, 0x00000018ff3f7819ULL, 0x002fc8000001144eULL,
0x0000003f00537245ULL, 0x000fc6000020d400ULL, 0x0000008d00857306ULL, 0x0002b00000205400ULL,
0x0000004c006a7306ULL, 0x0006a2000000d400ULL, 0x0000008d008d7245ULL, 0x002fce000020d400ULL,
0x0000003c00897306ULL, 0x000fe20000009400ULL, 0x000001004f4c7824ULL, 0x008fe200078e00ffULL,
0x000000858200720bULL, 0x004fc80003fdd000ULL, 0x00000018ff9b7819ULL, 0x000fe4000001144cULL,
0x0000003c007f7306ULL, 0x000e620000005400ULL, 0x000000016a6a3812ULL, 0x000fe400078efcffULL,
0x0000a800404c7811ULL, 0x000fe400078e20ffULL, 0x0000009b00df7245ULL, 0x000fe4000020d400ULL,
0x000000018d8d6812ULL, 0x000fe200078efcffULL, 0x0000003c005d7306ULL, 0x000ea2000000d400ULL,
0x0000006a576a723eULL, 0x000fc400000010ffULL, 0x000000cc8dcc723eULL, 0x000fca00000010ffULL,
0x000000b300b57306ULL, 0x000fe20000209400ULL, 0x0000007f8900720bULL, 0x002fe40003f1d000ULL,
0x0000007ed289723eULL, 0x000fca00000010ffULL, 0x000000b3003c7306ULL, 0x000e6c0000205400ULL,
0x000000015d5d0812ULL, 0x004fe400078efcffULL, 0x0000003f00907306ULL, 0x000ff00000209400ULL,
0x0000003f00917306ULL, 0x000ea20000205400ULL, 0x0000003cb500720bULL, 0x002fc40003f7d000ULL,
0x00000056c73c723eULL, 0x000fca00000010ffULL, 0x0000009b00997306ULL, 0x000fec0000209400ULL,
0x00000001cdcd3812ULL, 0x000fe400078efcffULL, 0x0000009b009a7306ULL, 0x000e620000205400ULL,
0x000000919000720bULL, 0x004fe40003fbd000ULL, 0x000000cd7dcd723eULL, 0x000fca00000010ffULL,
0x0000003d007c7306ULL, 0x000fec0000009400ULL, 0x0000000153535812ULL, 0x000fe400078efcffULL,
0x0000003d007b7306ULL, 0x000fe20000005400ULL, 0x0000009a9900720bULL, 0x002fce0003f9d000ULL,
0x0000003d005e7306ULL, 0x000fec000000d400ULL, 0x00000001dfdf4812ULL, 0x000fe400078efcffULL,
0x0000003e00747306ULL, 0x000ff00000009400ULL, 0x0000003e00737306ULL, 0x000ff00000005400ULL,
0x0000003e004b7306ULL, 0x000ff0000000d400ULL, 0x000000de003d7306ULL, 0x000ff00000209400ULL,
0x000000de003e7306ULL, 0x0002b00000205400ULL, 0x000000d7008f7306ULL, 0x000fe20000209400ULL,
0x000000de00de7245ULL, 0x002fce000020d400ULL, 0x000000d700827306ULL, 0x000e620000205400ULL,
0x0000003e3d00720bULL, 0x004fe40003f7d000ULL, 0x000000d1bb3d723eULL, 0x000fe400000010ffULL,
0x00000070aabb723eULL, 0x000fc600000010ffULL, 0x0000004f008b7306ULL, 0x000fec0000009400ULL,
0x00000001dede3812ULL, 0x000fe400078efcffULL, 0x0000004f00817306ULL, 0x000ea20000005400ULL,
0x000000828f00720bULL, 0x002fe40003fbd000ULL, 0x0000007b7c00720bULL, 0x000fc40003f7d000ULL,
0x00000079c27b723eULL, 0x000fe400000010ffULL, 0x0000009d8682723eULL, 0x000fe200000010ffULL,
0x0000004f00647306ULL, 0x0002e2000000d400ULL, 0x00000063dede723eULL, 0x000fce00000010ffULL,
0x0000007600787306ULL, 0x000fe20000209400ULL, 0x000000004c4c783bULL, 0x002e620000000200ULL,
0x000000818b00720bULL, 0x004fe40003fdd000ULL, 0x000000015e5e3812ULL, 0x000fc800078efcffULL,
0x0000007600777306ULL, 0x0004ae0000205400ULL, 0x0000000164646812ULL, 0x008fe200078efcffULL,
0x000000b600847306ULL, 0x000fe20000209400ULL, 0x000000737400720bULL, 0x000fe40003fdd000ULL,
0x0000007600767245ULL, 0x004fc4000020d400ULL, 0x00000064dfdf723eULL, 0x000fc600000010ffULL,
0x000000b600807306ULL, 0x0004e20000205400ULL, 0x000000777800720bULL, 0x000fe40003f9d000ULL,
0x000000d700777245ULL, 0x000fc6000020d400ULL, 0x000000014b4b6812ULL, 0x000fe400078efcffULL,
0x000000bd007f7306ULL, 0x000fe20000209400ULL, 0x0000000177775812ULL, 0x000fe400078efcffULL,
0x000000b600b67245ULL, 0x004fc6000020d400ULL, 0x0000000176764812ULL, 0x000fe400078efcffULL,
0x000000bd007e7306ULL, 0x0004a20000205400ULL, 0x000000808400720bULL, 0x008fe20003fbd000ULL,
0x000000344c4ca231ULL, 0x082fe200003400ffULL, 0x000000537676723eULL, 0x000fe200000010ffULL,
0x000000344e4ea231ULL, 0x000fe400003400ffULL, 0x000000354d4da231ULL, 0x080fe400003400ffULL,
0x000000b700567306ULL, 0x000fe20000209400ULL, 0x000000354f4fa231ULL, 0x000fe200003400ffULL,
0x000000bd00bd7245ULL, 0x004fc8000020d400ULL, 0x00000001b6b65812ULL, 0x000fe400078efcffULL,
0x000000b700797306ULL, 0x000e620000205400ULL, 0x0000007e7f00720bULL, 0x000fe20003fbd000ULL,
0x000000884c20723cULL, 0x000fe20000041820ULL, 0x0000005db6b6723eULL, 0x000fca00000010ffULL,
0x0000006600687306ULL, 0x000fe40000209400ULL, 0x0000003c4c1c723cULL, 0x040b68000004181cULL,
0x00000001bdbd5812ULL, 0x000fe400078efcffULL, 0x0000006600677306ULL, 0x0004e20000205400ULL,
0x000000795600720bULL, 0x002fe20003f1d000ULL, 0x0000007a4c18723cULL, 0x000f640000041818ULL,
0x0000a8003b3c7811ULL, 0x020fc800078e20ffULL, 0x0000006100627306ULL, 0x000fe40000209400ULL,
0x000000003c3c783bULL, 0x000e620000000200ULL, 0x000000504c14723cULL, 0x000be20000041814ULL,
0x0000006600667245ULL, 0x004fc8000020d400ULL, 0x0000006100657306ULL, 0x0005e20000205400ULL,
0x000000676800720bULL, 0x008fe40003fbd000ULL, 0x000000ba4c10723cULL, 0x040f6a0000041810ULL,
0x000000ad00507306ULL, 0x020fe20000209400ULL, 0x0000006100617245ULL, 0x004fe4000020d400ULL,
0x000000964c0c723cULL, 0x000f66000004180cULL, 0x0000000166665812ULL, 0x000fc400078efcffULL,
0x000000ad00517306ULL, 0x0004e60000205400ULL, 0x000000a24c04723cULL, 0x040f6a0000041804ULL,
0x0000006e00727306ULL, 0x000fe20000209400ULL, 0x000000ad00ad7245ULL, 0x004fe4000020d400ULL,
0x000000824c08723cULL, 0x000b6a0000041808ULL, 0x0000006e00717306ULL, 0x0004a40000205400ULL,
0x000000b7004c7245ULL, 0x020fe2000020d400ULL, 0x000000343c3ca231ULL, 0x082fe200003400ffULL,
0x000000515000720bULL, 0x008fe20003fbd000ULL, 0x000000343e3ea231ULL, 0x000fe200003400ffULL,
0x000000014c4c0812ULL, 0x000fe200078efcffULL, 0x000000353d3da231ULL, 0x080fe200003400ffULL,
0x000000656200720bULL, 0x000fe20003f1d000ULL, 0x000000b200787306ULL, 0x000fe20000209400ULL,
0x0000006e006e7245ULL, 0x004fe2000020d400ULL, 0x000000353f3fa231ULL, 0x000fe200003400ffULL,
0x000000b2004d7245ULL, 0x000fc4000020d400ULL, 0x0000005ebdb7723eULL, 0x000fe400000010ffULL,
0x0000004c664c723eULL, 0x000fe200000010ffULL, 0x000000b200737306ULL, 0x000e620000205400ULL,
0x000000717200720bULL, 0x000fe20003f9d000ULL, 0x000000cc3c1c723cULL, 0x000b62000004181cULL,
0x00000001adad5812ULL, 0x000fe400078efcffULL, 0x0000000161610812ULL, 0x000fc600078efcffULL,
0x000000ac00527306ULL, 0x000fe40000209400ULL, 0x000000de3c18723cULL, 0x040b680000041818ULL,
0x000000016e6e4812ULL, 0x000fe400078efcffULL, 0x000000ac00567306ULL, 0x000ea20000205400ULL,
0x000000737800720bULL, 0x002fe20003f7d000ULL, 0x000000b63c10723cULL, 0x000b620000041810ULL,
0x0000006b6c00720bULL, 0x000fc40003f9d000ULL, 0x00000069b86b723eULL, 0x000fe400000010ffULL,
0x000000776e77723eULL, 0x000fe200000010ffULL, 0x00000055004e7306ULL, 0x000fe80000209400ULL,
0x0000006a3c20723cULL, 0x000b640000041820ULL, 0x000000014d4d3812ULL, 0x000fe400078efcffULL,
0x00000055004f7306ULL, 0x0002e20000205400ULL, 0x000000565200720bULL, 0x004fc40003f1d000ULL,
0x000000015a5a4812ULL, 0x000fe200078efcffULL, 0x000000763c14723cULL, 0x000b620000041814ULL,
0x0000004d614d723eULL, 0x000fc600000010ffULL, 0x0000004800607306ULL, 0x000fe20000209400ULL,
0x0000005500557245ULL, 0x002fc6000020d400ULL, 0x0000004c3c0c723cULL, 0x000b68000004180cULL,
0x00000048005f7306ULL, 0x0002a20000205400ULL, 0x0000004f4e00720bULL, 0x008fe40003fdd000ULL,
0x000000ac004f7245ULL, 0x000fe4000020d400ULL, 0x0000004bad4e723eULL, 0x000fe400000010ffULL,
0x000000014f4f0812ULL, 0x000fe200078efcffULL, 0x00000049005b7306ULL, 0x000fe20000209400ULL,
0x00000049004b7245ULL, 0x000fc4000020d400ULL, 0x0000004800487245ULL, 0x002fe4000020d400ULL,
0x0000005a4f4f723eULL, 0x000fe400000010ffULL, 0x0000000155556812ULL, 0x000fe200078efcffULL,
0x00000049005c7306ULL, 0x0002e20000205400ULL, 0x0000005f6000720bULL, 0x004fc60003f7d000ULL,
0x0000004e3c04723cULL, 0x000b680000041804ULL, 0x0000005400577306ULL, 0x000fe20000209400ULL,
0x0000005400497245ULL, 0x002fca000020d400ULL, 0x0000000148483812ULL, 0x000fe400078efcffULL,
0x0000005400507306ULL, 0x000e620000205400ULL, 0x0000005c5b00720bULL, 0x008fe40003fbd000ULL,
0x000000554848723eULL, 0x000fd600000010ffULL, 0x000000014b4b5812ULL, 0x000fe400078efcffULL,
0x000000505700720bULL, 0x002fda0003f1d000ULL, 0x0000000149490812ULL, 0x000fc800078efcffULL,
0x000000494b49723eULL, 0x000fce00000010ffULL, 0x000000483c3c723cULL, 0x000b620000041808ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff487f8cULL, 0x020e62000c80043fULL,
0x000000ffff4c7224ULL, 0x000fce00078e00ffULL, 0x0000000000087805ULL, 0x000fc40000015200ULL,
0x0106bc00ff0a7984ULL, 0x000ea40000000800ULL, 0x800000000aff7812ULL, 0x006fe40007804849ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a084b7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e09ULL,
0x003d09004b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0a7819ULL, 0x000fc8000001140bULL, 0x0000004b0a0a7211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060bULL, 0x000000020a0a7819ULL, 0x000fc8000000120bULL,
0x0000000a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000014c4c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106bc00ff0a7984ULL, 0x000e640000000800ULL, 0x800000000aff7812ULL, 0x002fe40007804849ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000580028497a24ULL, 0x010fc800078e02ffULL,
0x0000008049497824ULL, 0x000fe200078e00ffULL, 0x0000045000009947ULL, 0x000fea0003800000ULL,
0x0000004041087810ULL, 0x000fe20007ffe0ffULL, 0x00000001270a7824ULL, 0x000fe200078e0236ULL,
0x0000000236527810ULL, 0x000fe40007ffe0ffULL, 0x0000000824097217ULL, 0x000fe20007800000ULL,
0x00000080004f7824ULL, 0x000fe200078e020aULL, 0x0000000436547810ULL, 0x000fe20007ffe0ffULL,
0x000000010a0b7824ULL, 0x000fe200078e0203ULL, 0x000000f02e507812ULL, 0x000fe200078ec0ffULL,
0x000000100a517824ULL, 0x000fe200078e00ffULL, 0x000000494f4c7210ULL, 0x000fe20007f1e0ffULL,
0x00000001270a7824ULL, 0x000fe200078e0252ULL, 0x000000024f4e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000109097824ULL, 0x000fe200078e0a08ULL, 0xfffffff051517812ULL, 0x000fe200078ee20bULL,
0x0000000127087824ULL, 0x000fe200078e0254ULL, 0x000000044f4d7810ULL, 0x000fe20007ffe0ffULL,
0x000000010a0b7824ULL, 0x140fe200078e0203ULL, 0x0000000927097217ULL, 0x000fe20007800000ULL,
0x000000100a537824ULL, 0x000fe200078e00ffULL, 0x000000494d4d7210ULL, 0x000fe20007f7e0ffULL,
0x00000001080a7824ULL, 0x040fe200078e0203ULL, 0x0000c00051517811ULL, 0x000fe200078e20ffULL,
0x0000001008557824ULL, 0x000fe200078e00ffULL, 0xfffffff053537812ULL, 0x000fe200078ee20bULL,
0x000000ffff087224ULL, 0x000fe200000e06ffULL, 0x00005e004c487a11ULL, 0x040fe200078040ffULL,
0x00000001090b7824ULL, 0x000fe200078e0a27ULL, 0xfffffff055557812ULL, 0x000fe200078ee20aULL,
0x000000ffff097224ULL, 0x000fe200018e06ffULL, 0x00005f004c4c7a11ULL, 0x000fc400000f4408ULL,
0x000000494e4e7210ULL, 0x000fe40007f1e0ffULL, 0x0000000b3600720cULL, 0x000fe40003f86070ULL,
0x00005e004d0a7a11ULL, 0x040fe200078a40ffULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x00005e004e4b7a11ULL, 0x040fe400078040ffULL, 0x00005f004d4d7a11ULL, 0x000fe400028f4409ULL,
0x00005f004e4e7a11ULL, 0x000fc400000f4408ULL, 0x0000005048087210ULL, 0x000fe40007f7e0ffULL,
0x0000000b5200720cULL, 0x080fe40003f06070ULL, 0x0000000636527810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff097224ULL, 0x000fe200018e064cULL, 0x000000064f487810ULL, 0x000fe40007ffe0ffULL,
0x0000000b5400720cULL, 0x000fe20003f66070ULL, 0x00000001274c7824ULL, 0x000fe200078e0252ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008517faeULL, 0x0003e2000e101c46ULL,
0x0000004948487210ULL, 0x000fc40007f9e0ffULL, 0x000000014c4f7824ULL, 0x000fe200078e0203ULL,
0x000000500a0a7210ULL, 0x080fe40007fde0ffULL, 0x0000c00053537811ULL, 0x000fe400078e20ffULL,
0x0000c00055557811ULL, 0x000fe400078e20ffULL, 0x000000504b087210ULL, 0x002fe20007fbe0ffULL,
0x000000104c517824ULL, 0x000fe400078e00ffULL, 0x000000ffff4b7224ULL, 0x000fe200020e06ffULL,
0x00005e00484c7a11ULL, 0x000fe200078840ffULL, 0x000000ffff097224ULL, 0x000fe200028e064eULL,
0x0000000b5200720cULL, 0x000fe20003fa6070ULL, 0x000000ffff0b7224ULL, 0x000fe200030e064dULL,
0x00005f0048487a11ULL, 0x000fc400020f444bULL, 0x000000504c4c7210ULL, 0x000fe20007f9e0ffULL,
0x0000000008537faeULL, 0x0003e2000c101c46ULL, 0xfffffff0514f7812ULL, 0x000fc600078ee24fULL,
0x000000ffff4d7224ULL, 0x000fe200020e0648ULL, 0x0000c0004f4f7811ULL, 0x000fe200078e20ffULL,
0x000000000a557faeULL, 0x0003e8000d901c46ULL, 0x000000004c4f7faeULL, 0x0003e2000e901c46ULL,
0x0000038000007947ULL, 0x000fea0003800000ULL, 0x0000000127087824ULL, 0x000fe200078e0236ULL,
0x000000f02e4e7812ULL, 0x000fc600078ec0ffULL, 0x0000000108097824ULL, 0x040fe200078e0203ULL,
0x00000002080a7810ULL, 0x040fe20007ffe0ffULL, 0x0000001008487824ULL, 0x000fc800078e00ffULL,
0x000000010a0b7824ULL, 0x000fe200078e0203ULL, 0xfffffff048487812ULL, 0x000fe200078ee209ULL,
0x000000100a4d7824ULL, 0x000fe200078e00ffULL, 0x00000004080a7810ULL, 0x000fe20007ffe0ffULL,
0x0000008000097824ULL, 0x000fe200078e0208ULL, 0x0000c00048487811ULL, 0x000fe400078e20ffULL,
0xfffffff04d4d7812ULL, 0x000fe200078ee20bULL, 0x000000010a4b7824ULL, 0x000fe200078e0203ULL,
0x00000006080b7810ULL, 0x000fe20007ffe0ffULL, 0x000000100a527824ULL, 0x000fe200078e00ffULL,
0x0000004909087210ULL, 0x000fc60007f1e0ffULL, 0x000000010b4c7824ULL, 0x040fe200078e0203ULL,
0xfffffff052527812ULL, 0x000fe200078ee24bULL, 0x000000100b567824ULL, 0x000fe200078e00ffULL,
0x00000002094b7810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff0a7224ULL, 0x000fe200000e06ffULL,
0x00005e00080b7a11ULL, 0x000fe400078040ffULL, 0xfffffff056567812ULL, 0x000fe400078ee24cULL,
0x00005f00080a7a11ULL, 0x000fe400000f440aULL, 0x0000000409087810ULL, 0x000fc40007ffe0ffULL,
0x0000000609097810ULL, 0x000fe40007ffe0ffULL, 0x000000494b4b7210ULL, 0x080fe40007f1e0ffULL,
0x00000049084f7210ULL, 0x080fe40007f7e0ffULL, 0x0000004909537210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff097224ULL, 0x000fe200000e06ffULL, 0x00005e004b4c7a11ULL, 0x000fe200078040ffULL,
0x000000ffff507224ULL, 0x000fe200018e06ffULL, 0x0000004e0b087210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff547224ULL, 0x000fe200028e06ffULL, 0x00005e004f517a11ULL, 0x000fc400078840ffULL,
0x00005e0053557a11ULL, 0x000fe400078a40ffULL, 0x00005f004b4b7a11ULL, 0x000fe200000f4409ULL,
0x000000ffff097224ULL, 0x000fe200018e060aULL, 0x0000004e4c0a7210ULL, 0x080fe40007f1e0ffULL,
0x00005f004f507a11ULL, 0x000fe400020f4450ULL, 0x0000004e514c7210ULL, 0x080fe20007f7e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008487faeULL, 0x0003e2000b901c46ULL,
0x00005f0053547a11ULL, 0x000fe200028f4454ULL, 0x000000ffff0b7224ULL, 0x000fe200000e064bULL,
0x0000004e554e7210ULL, 0x000fc40007f9e0ffULL, 0x0000c00052527811ULL, 0x000fe400078e20ffULL,
0x0000c00056567811ULL, 0x000fe200078e20ffULL, 0x000000ffff4f7224ULL, 0x000fe200020e0654ULL,
0x0000c0004d087811ULL, 0x002fe200078e20ffULL, 0x000000ffff4d7224ULL, 0x000fc800018e0650ULL,
0x000000000a087faeULL, 0x0003e8000b901c46ULL, 0x000000004c527faeULL, 0x0003e8000b901c46ULL,
0x000000004e567faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff087f8cULL, 0x000e64000c80043fULL,
0x000000ffff487224ULL, 0x002fc400078e0009ULL, 0x0000000000087805ULL, 0x000fca0000015200ULL,
0x0106b400ff0a7984ULL, 0x000e640000000800ULL, 0x800000000aff7812ULL, 0x002fc40007804859ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff4c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a084b7210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e09ULL, 0x003d09004b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0a7819ULL, 0x000fc8000001140bULL,
0x0000004b0a0a7211ULL, 0x000fca00078110ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e060bULL,
0x000000020a0a7819ULL, 0x000fc8000000120bULL, 0x0000000a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000014c4c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106b400ff0a7984ULL, 0x000e640000000800ULL,
0x800000000aff7812ULL, 0x002fe40007804859ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000014000007945ULL, 0x000fe20003800000ULL, 0x0000012000002947ULL, 0x000fea0003800000ULL,
0x00000033ff08723eULL, 0x000fe400000010ffULL, 0x00000002ff097819ULL, 0x000fe40000011603ULL,
0x0000541008087816ULL, 0x000fe20000000008ULL, 0x000153427f007947ULL, 0x000fea000b800000ULL,
0x00001f0908347589ULL, 0x0002a400000e0000ULL, 0x0000000809357810ULL, 0x000fe20007ffe0ffULL,
0x000153727f007947ULL, 0x000fea000b800000ULL, 0x00001f3508357589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000010094b7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4d7224ULL, 0x000fe200078e0008ULL, 0x0000b770004c7802ULL, 0x000fc40000000f00ULL,
0x00015de000007944ULL, 0x00efea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000018094b7810ULL, 0x004fe20007ffe0ffULL, 0x000000ffff4d7224ULL, 0x000fe200078e0008ULL,
0x0000b7c0004c7802ULL, 0x000fc40000000f00ULL, 0x00015d9000007944ULL, 0x00afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000a80046987811ULL, 0x000fc400078e20ffULL, 0x000000004454783bULL, 0x000f280000004200ULL,
0x000000004250783bULL, 0x000ee80000004200ULL, 0x000000004508783bULL, 0x00ae680000004200ULL,
0x00000000434c783bULL, 0x000ee20000004200ULL, 0x0000010055b07824ULL, 0x010fe200078e00ffULL,
0x0000005400d67306ULL, 0x000fe20000009400ULL, 0x0000010054d57824ULL, 0x000fe200078e00ffULL,
0x00000018ffae7819ULL, 0x000fe20000011454ULL, 0x0000010056c97824ULL, 0x040fe200078e00ffULL,
0x00000018ffb07819ULL, 0x000fe200000114b0ULL, 0x0001000056c27824ULL, 0x000fe200078e00ffULL,
0x00000018ffd57819ULL, 0x000fe200000114d5ULL, 0x0001000054d17824ULL, 0x000fe200078e00ffULL,
0x000000b000d97306ULL, 0x000fe20000209400ULL, 0x00000018ffc97819ULL, 0x000fe200000114c9ULL,
0x0000010057c77824ULL, 0x040fe200078e00ffULL, 0x00000018ffc27819ULL, 0x000fe200000114c2ULL,
0x0000010052e17824ULL, 0x000fe200078e00ffULL, 0x00000018ffd17819ULL, 0x000fe200000114d1ULL,
0x0001000057c37824ULL, 0x000fe200078e00ffULL, 0x00000018ff747819ULL, 0x000fe20000011452ULL,
0x000000b000dd7306ULL, 0x0008a20000205400ULL, 0x00000018ffc77819ULL, 0x000fe200000114c7ULL,
0x0001000055cb7824ULL, 0x000fe200078e00ffULL, 0x00000018ffa27819ULL, 0x000fe20000011457ULL,
0x0000010009a77824ULL, 0x042fe200078e00ffULL, 0x00000018ffbe7819ULL, 0x000fe20000011455ULL,
0x0000010008b27824ULL, 0x000fe200078e00ffULL, 0x00000018ff9f7819ULL, 0x000fe20000011408ULL,
0x000000d500de7306ULL, 0x000fe20000209400ULL, 0x000000b000b07245ULL, 0x010fe2000020d400ULL,
0x0000010050e07824ULL, 0x000fe200078e00ffULL, 0x00000018ffc37819ULL, 0x000fe200000114c3ULL,
0x0001000009a47824ULL, 0x000fe200078e00ffULL, 0x00000018ffcb7819ULL, 0x000fe200000114cbULL,
0x0001000008a87824ULL, 0x000fe200078e00ffULL, 0x00000018ffb57819ULL, 0x000fe20000011456ULL,
0x000000d500df7306ULL, 0x000e620000205400ULL, 0x000000ddd900720bULL, 0x004fc40003f9d000ULL,
0x00000018ffa77819ULL, 0x000fe400000114a7ULL, 0x00000018ff8d7819ULL, 0x000fe40000011450ULL,
0x00000018ffb27819ULL, 0x000fe200000114b2ULL, 0x000000c900d37306ULL, 0x000fe20000209400ULL,
0x00000018ff7c7819ULL, 0x000fe40000011451ULL, 0x00000018ffa47819ULL, 0x000fe400000114a4ULL,
0x00000018ffa87819ULL, 0x000fc400000114a8ULL, 0x00000001b0b04812ULL, 0x000fe200078efcffULL,
0x000000c900d47306ULL, 0x0005220000205400ULL, 0x000000dfde00720bULL, 0x002fe20003f1d000ULL,
0x0001000050de7824ULL, 0x000fe200078e00ffULL, 0x00000018ff897819ULL, 0x000fe2000001140bULL,
0x0000010051df7824ULL, 0x000fe200078e00ffULL, 0x00000018ff8a7819ULL, 0x000fe4000001140aULL,
0x00000018ff9b7819ULL, 0x000fe20000011409ULL, 0x0000005400da7306ULL, 0x000e620000005400ULL,
0x000000c900c97245ULL, 0x004fc4000020d400ULL, 0x00000018ffe17819ULL, 0x000fe400000114e1ULL,
0x00000018ff647819ULL, 0x008fe4000001144cULL, 0x00000018ff5d7819ULL, 0x000fe2000001144dULL,
0x0000005500ac7306ULL, 0x000fe20000009400ULL, 0x000000d4d300720bULL, 0x010fe40003f9d000ULL,
0x00000018ff587819ULL, 0x000fe4000001144eULL, 0x00000018ff4b7819ULL, 0x000fc4000001144fULL,
0x00000018ff6e7819ULL, 0x000fe20000011453ULL, 0x0000005500ad7306ULL, 0x000fe20000005400ULL,
0x000000dad600720bULL, 0x002fe20003fdd000ULL, 0x0001000052d67824ULL, 0x000fe400078e00ffULL,
0x0000010053da7824ULL, 0x000fe400078e00ffULL, 0x00000001c9c94812ULL, 0x000fe400078efcffULL,
0x000000c200ca7306ULL, 0x000fe20000209400ULL, 0x00000018ffda7819ULL, 0x000fc400000114daULL,
0x00000018ffd67819ULL, 0x000fca00000114d6ULL, 0x000000c200ce7306ULL, 0x0002b00000205400ULL,
0x00000052008e7306ULL, 0x000fe20000009400ULL, 0x000000c200c27245ULL, 0x002fce000020d400ULL,
0x0000005200887306ULL, 0x000fe20000005400ULL, 0x000000ceca00720bULL, 0x004fce0003f9d000ULL,
0x0000005200637306ULL, 0x0003ec000000d400ULL, 0x00000001c2c24812ULL, 0x000fe400078efcffULL,
0x000000d100d87306ULL, 0x000fe20000209400ULL, 0x000000d500527245ULL, 0x002fc8000020d400ULL,
0x0000000152520812ULL, 0x000fe400078efcffULL, 0x000000adac00720bULL, 0x000fe20003f1d000ULL,
0x000000d100d77306ULL, 0x000e620000205400ULL, 0x000000d100ac7245ULL, 0x000fe4000020d400ULL,
0x00000018ffad7819ULL, 0x000fca00000114deULL, 0x00000055007b7306ULL, 0x0004f0000000d400ULL,
0x000000c700d07306ULL, 0x000fe20000209400ULL, 0x000000d7d800720bULL, 0x002fe20003fbd000ULL,
0x000100000b557824ULL, 0x004fca00078e00ffULL, 0x00000018ff557819ULL, 0x000fe20000011455ULL,
0x000000c700d27306ULL, 0x0002a20000205400ULL, 0x000000017b7b0812ULL, 0x008fca00078efcffULL,
0x00000001acac5812ULL, 0x000fe400078efcffULL, 0x000000ae00cf7306ULL, 0x000fe20000209400ULL,
0x000000c700c77245ULL, 0x002fce000020d400ULL, 0x000000ae00a67306ULL, 0x0002e20000205400ULL,
0x000000d2d000720bULL, 0x004fce0003f1d000ULL, 0x000000a200af7306ULL, 0x000fe20000209400ULL,
0x000000ae00ae7245ULL, 0x002fca000020d400ULL, 0x00000001c7c70812ULL, 0x000fe400078efcffULL,
0x000000a200b47306ULL, 0x000e620000205400ULL, 0x000000a6cf00720bULL, 0x008fce0003f7d000ULL,
0x0000005600b17306ULL, 0x000fec0000009400ULL, 0x00000001aeae3812ULL, 0x000fe400078efcffULL,
0x0000005600bf7306ULL, 0x000ea20000005400ULL, 0x000000b4af00720bULL, 0x002fe20003f9d000ULL,
0x000100004eaf7824ULL, 0x000fe200078e00ffULL, 0x000000acaeac723eULL, 0x000fe200000010ffULL,
0x000001004fb47824ULL, 0x000fc600078e00ffULL, 0x00000018ffaf7819ULL, 0x000fe200000114afULL,
0x0000000800b77306ULL, 0x000fe20000009400ULL, 0x00000018ffb47819ULL, 0x000fce00000114b4ULL,
0x0000000800b67306ULL, 0x000e620000005400ULL, 0x000000bfb100720bULL, 0x004fe40003fbd000ULL,
0x000000cb00b17245ULL, 0x000fca000020d400ULL, 0x000000be00c17306ULL, 0x000ff00000209400ULL,
0x000000be00c07306ULL, 0x0004e20000205400ULL, 0x000000b6b700720bULL, 0x002fe20003f1d000ULL,
0x000001004eb67824ULL, 0x000fe200078e00ffULL, 0x000000a200b77245ULL, 0x000fe2000020d400ULL,
0x000100004fa27824ULL, 0x000fc600078e00ffULL, 0x00000001b7b74812ULL, 0x000fe200078efcffULL,
0x0000009f00967306ULL, 0x000fe20000209400ULL, 0x000000be00be7245ULL, 0x004fe4000020d400ULL,
0x00000018ffb67819ULL, 0x000fe400000114b6ULL, 0x00000018ffa27819ULL, 0x000fc600000114a2ULL,
0x0000009f00977306ULL, 0x0002a20000205400ULL, 0x000000c0c100720bULL, 0x008fe40003f7d000ULL,
0x00000018ffc07819ULL, 0x000fca00000114dfULL, 0x0000005600787306ULL, 0x000722000000d400ULL,
0x0000009f009f7245ULL, 0x002fca000020d400ULL, 0x00000001bebe3812ULL, 0x000fe400078efcffULL,
0x000000c300cd7306ULL, 0x000fe20000209400ULL, 0x000000979600720bULL, 0x004fe20003f9d000ULL,
0x000001000b567824ULL, 0x008fca00078e00ffULL, 0x00000018ff567819ULL, 0x000fe20000011456ULL,
0x000000c300cc7306ULL, 0x0002a20000205400ULL, 0x0000000178785812ULL, 0x010fc800078efcffULL,
0x00000078c978723eULL, 0x000fe400000010ffULL, 0x000000019f9f4812ULL, 0x000fe200078efcffULL,
0x00000054007d7306ULL, 0x000722000000d400ULL, 0x000000c300c37245ULL, 0x002fce000020d400ULL,
0x000000cb00db7306ULL, 0x000fe20000209400ULL, 0x000000cccd00720bULL, 0x004fe20003fbd000ULL,
0x000100000a547824ULL, 0x008fca00078e00ffULL, 0x00000018ff547819ULL, 0x000fe20000011454ULL,
0x000000cb00dc7306ULL, 0x000e620000205400ULL, 0x000000017d7d6812ULL, 0x010fc800078efcffULL,
0x0000007d5252723eULL, 0x000fe400000010ffULL, 0x00000001c3c35812ULL, 0x000fe200078efcffULL,
0x0000000b009e7306ULL, 0x000fe60000009400ULL, 0x000000c3b7c3723eULL, 0x000fca00000010ffULL,
0x0000000b00937306ULL, 0x000ea20000005400ULL, 0x000000dcdb00720bULL, 0x002fce0003fdd000ULL,
0x000000b500ba7306ULL, 0x000fec0000209400ULL, 0x00000001b1b16812ULL, 0x000fe400078efcffULL,
0x000000b500bb7306ULL, 0x0002e20000205400ULL, 0x000000939e00720bULL, 0x004fce0003f9d000ULL,
0x000000a700c67306ULL, 0x000fe20000209400ULL, 0x000000b500b57245ULL, 0x002fce000020d400ULL,
0x000000a700c87306ULL, 0x0002a20000205400ULL, 0x000000bbba00720bULL, 0x008fce0003f7d000ULL,
0x0000005000807306ULL, 0x000fe20000009400ULL, 0x000000a700a77245ULL, 0x002fca000020d400ULL,
0x00000001b5b53812ULL, 0x000fe400078efcffULL, 0x00000050007e7306ULL, 0x000fe20000005400ULL,
0x000000c8c600720bULL, 0x004fe20003fbd000ULL, 0x000001004dc67824ULL, 0x000fe200078e00ffULL,
0x000000c2b5c2723eULL, 0x000fc800000010ffULL, 0x00000018ffc67819ULL, 0x000fe200000114c6ULL,
0x0000005000667306ULL, 0x0003ec000000d400ULL, 0x00000001a7a75812ULL, 0x000fe400078efcffULL,
0x0000005700bd7306ULL, 0x000fe20000009400ULL, 0x00000018ff507819ULL, 0x002fe200000114e0ULL,
0x0001000051e07824ULL, 0x000fcc00078e00ffULL, 0x0000005700bc7306ULL, 0x000e700000005400ULL,
0x0000000800737306ULL, 0x000eb0000000d400ULL, 0x0000000b00697306ULL, 0x000ee2000000d400ULL,
0x000000bcbd00720bULL, 0x002fce0003fdd000ULL, 0x00000051008f7306ULL, 0x000fe20000009400ULL,
0x0000000173730812ULL, 0x004fce00078efcffULL, 0x0000005100907306ULL, 0x000fe20000005400ULL,
0x0000000169694812ULL, 0x008fce00078efcffULL, 0x0000005100657306ULL, 0x000ff0000000d400ULL,
0x0000000a00957306ULL, 0x000ff00000009400ULL, 0x0000000a00917306ULL, 0x000e700000005400ULL,
0x000000b200c47306ULL, 0x000ff00000209400ULL, 0x000000b200c57306ULL, 0x0004e20000205400ULL,
0x000000919500720bULL, 0x002fce0003f1d000ULL, 0x0000005000517306ULL, 0x000fe20000209400ULL,
0x000000b200b27245ULL, 0x004fce000020d400ULL, 0x0000005000a67306ULL, 0x0002a20000205400ULL,
0x000000c5c400720bULL, 0x008fe20003f7d000ULL, 0x000001004cc47824ULL, 0x040fe400078e00ffULL,
0x000100004cc57824ULL, 0x000fc600078e00ffULL, 0x00000018ffc47819ULL, 0x000fe200000114c4ULL,
0x000000a400ab7306ULL, 0x000fe20000209400ULL, 0x0000005000507245ULL, 0x002fe4000020d400ULL,
0x00000018ffc57819ULL, 0x000fc600000114c5ULL, 0x00000001b2b23812ULL, 0x000fe400078efcffULL,
0x000000a400a97306ULL, 0x0002e20000205400ULL, 0x000000a65100720bULL, 0x004fe40003f9d000ULL,
0x000000ad00517245ULL, 0x000fe4000020d400ULL, 0x00000073b2a6723eULL, 0x000fc600000010ffULL,
0x0000005700757306ULL, 0x000522000000d400ULL, 0x000000a400a47245ULL, 0x002fca000020d400ULL,
0x0000000150504812ULL, 0x000fe400078efcffULL, 0x0000000900b87306ULL, 0x000fe20000009400ULL,
0x000001000a577824ULL, 0x004fe200078e00ffULL, 0x000000a9ab00720bULL, 0x008fe40003fbd000ULL,
0x000000908f00720bULL, 0x000fe40003f9d000ULL, 0x00000018ff577819ULL, 0x000fe40000011457ULL,
0x0000000900b97306ULL, 0x000e620000005400ULL, 0x0000000175756812ULL, 0x010fcc00078efcffULL,
0x00000001a4a45812ULL, 0x000fe200078efcffULL, 0x0000000a006f7306ULL, 0x000ea2000000d400ULL,
0x0000000165654812ULL, 0x000fce00078efcffULL, 0x000000a800aa7306ULL, 0x000fe20000209400ULL,
0x000000b9b800720bULL, 0x002fe20003fdd000ULL, 0x000100004db87824ULL, 0x000fe200078e00ffULL,
0x00000018ffb97819ULL, 0x000fc800000114e0ULL, 0x00000018ffb87819ULL, 0x000fe200000114b8ULL,
0x000000a800b37306ULL, 0x0002e20000205400ULL, 0x000000016f6f0812ULL, 0x004fce00078efcffULL,
0x0000005400a17306ULL, 0x000fe20000209400ULL, 0x000000a800a87245ULL, 0x002fce000020d400ULL,
0x00000054000b7306ULL, 0x0002a20000205400ULL, 0x000000b3aa00720bULL, 0x008fce0003f7d000ULL,
0x0000005600a07306ULL, 0x000fe20000209400ULL, 0x0000005400547245ULL, 0x002fca000020d400ULL,
0x00000001a8a83812ULL, 0x000fe400078efcffULL, 0x00000056000a7306ULL, 0x0002e20000205400ULL,
0x0000000ba100720bULL, 0x004fce0003f1d000ULL, 0x0000000900727306ULL, 0x000ea2000000d400ULL,
0x0000005600567245ULL, 0x002fca000020d400ULL, 0x0000000154540812ULL, 0x000fe400078efcffULL,
0x0000009b00997306ULL, 0x000fe20000209400ULL, 0x0000000aa000720bULL, 0x008fe40003fbd000ULL,
0x0000a800470a7811ULL, 0x000fe400078e20ffULL, 0x0000007e8000720bULL, 0x000fc60003f1d000ULL,
0x0000009b009a7306ULL, 0x0002e20000205400ULL, 0x0000000172726812ULL, 0x004fc800078efcffULL,
0x00000072a7a7723eULL, 0x000fe400000010ffULL, 0x0000000156565812ULL, 0x000fe200078efcffULL,
0x0000005700a57306ULL, 0x000fe20000209400ULL, 0x0000009b009b7245ULL, 0x002fe4000020d400ULL,
0x0000000166660812ULL, 0x000fe400078efcffULL, 0x000000888e00720bULL, 0x000fe40003f1d000ULL,
0x000000665066723eULL, 0x000fe200000010ffULL, 0x0000005700a37306ULL, 0x0002a20000205400ULL,
0x0000009a9900720bULL, 0x008fc40003fdd000ULL, 0x000000a89f9a723eULL, 0x000fca00000010ffULL,
0x000000e100c17306ULL, 0x000fe20000209400ULL, 0x0000005700577245ULL, 0x002fe4000020d400ULL,
0x0000000163630812ULL, 0x000fc600078efcffULL, 0x000000019b9b6812ULL, 0x000fe400078efcffULL,
0x000000e100967306ULL, 0x0002e20000205400ULL, 0x000000a3a500720bULL, 0x004fe40003f7d000ULL,
0x000000a49b9b723eULL, 0x000fca00000010ffULL, 0x0000005500087306ULL, 0x000fe20000209400ULL,
0x000000e100e17245ULL, 0x002fca000020d400ULL, 0x0000000157573812ULL, 0x000fe400078efcffULL,
0x0000005500097306ULL, 0x0002a20000205400ULL, 0x00000096c100720bULL, 0x008fce0003f9d000ULL,
0x0000004c007f7306ULL, 0x000fe20000009400ULL, 0x0000005500557245ULL, 0x002fca000020d400ULL,
0x00000001e1e14812ULL, 0x000fe400078efcffULL, 0x0000004c00827306ULL, 0x000fe20000005400ULL,
0x000000090800720bULL, 0x004fe40003fbd000ULL, 0x000000000a08783bULL, 0x000e6a0000000200ULL,
0x0000004c005c7306ULL, 0x000fec000000d400ULL, 0x0000000155555812ULL, 0x000fc400078efcffULL,
0x0000004d008b7306ULL, 0x000ff00000009400ULL, 0x0000004d00877306ULL, 0x000ff00000005400ULL,
0x0000004d005b7306ULL, 0x000ff0000000d400ULL, 0x0000004e007a7306ULL, 0x000fe20000009400ULL,
0x000000340808a231ULL, 0x002fc400003400ffULL, 0x000000340a0aa231ULL, 0x000fe400003400ffULL,
0x000000350909a231ULL, 0x000fc600003400ffULL, 0x0000004e00797306ULL, 0x000fe20000005400ULL,
0x000000350b0ba231ULL, 0x000fce00003400ffULL, 0x0000004e005a7306ULL, 0x000ff0000000d400ULL,
0x0000004f006d7306ULL, 0x000ff00000009400ULL, 0x0000004f006c7306ULL, 0x000ff00000005400ULL,
0x0000004f00597306ULL, 0x0003f0000000d400ULL, 0x0000008a009d7306ULL, 0x000fe20000209400ULL,
0x00000000984c783bULL, 0x002e6e0000000200ULL, 0x0000008a00927306ULL, 0x0004f00000205400ULL,
0x00000089009c7306ULL, 0x000fe20000209400ULL, 0x0000008a008a7245ULL, 0x004fce000020d400ULL,
0x0000008900947306ULL, 0x0005220000205400ULL, 0x000000929d00720bULL, 0x008fce0003fdd000ULL,
0x000000da00957306ULL, 0x000fe20000209400ULL, 0x0000008900897245ULL, 0x004fca000020d400ULL,
0x000000018a8a6812ULL, 0x000fe400078efcffULL, 0x000000da00937306ULL, 0x0004e20000205400ULL,
0x000000949c00720bULL, 0x010fe20003f7d000ULL, 0x000000344c4ca231ULL, 0x082fe200003400ffULL,
0x000000548a54723eULL, 0x000fe200000010ffULL, 0x000000344e4ea231ULL, 0x000fe400003400ffULL,
0x000000354d4da231ULL, 0x080fe400003400ffULL, 0x0000008d00837306ULL, 0x000fe20000209400ULL,
0x000000da00da7245ULL, 0x004fe2000020d400ULL, 0x000000354f4fa231ULL, 0x000fe200003400ffULL,
0x000000827f00720bULL, 0x000fc60003f5d000ULL, 0x0000000189893812ULL, 0x000fe400078efcffULL,
0x0000008d00857306ULL, 0x0002a20000205400ULL, 0x000000939500720bULL, 0x008fe20003f9d000ULL,
0x000000c24c14723cULL, 0x000fe20000041814ULL, 0x000000558955723eULL, 0x000fca00000010ffULL,
0x000000ad00cf7306ULL, 0x000fe20000209400ULL, 0x0000008d008d7245ULL, 0x002fe2000020d400ULL,
0x000000a64c10723cULL, 0x000fe20000041810ULL, 0x000000015c5c2812ULL, 0x000fc600078efcffULL,
0x00000001dada4812ULL, 0x000fe400078efcffULL, 0x000000ad00bf7306ULL, 0x0002e20000205400ULL,
0x000000858300720bULL, 0x004fe20003fbd000ULL, 0x0000009a4c0c723cULL, 0x040fec000004180cULL,
0x0000007400777306ULL, 0x000fe20000209400ULL, 0x000000b1bead723eULL, 0x002fe200000010ffULL,
0x000000544c3c723cULL, 0x000fe8000004183cULL, 0x000000018d8d5812ULL, 0x000fc400078efcffULL,
0x0000007400767306ULL, 0x0002a20000205400ULL, 0x000000bfcf00720bULL, 0x008fe20003fdd000ULL,
0x000000ac4c1c723cULL, 0x000f6c000004181cULL, 0x000000c000bc7306ULL, 0x000fe20000209400ULL,
0x0000007400747245ULL, 0x002fca000020d400ULL, 0x0000000151516812ULL, 0x000fe400078efcffULL,
0x000000c000ba7306ULL, 0x0002e20000205400ULL, 0x000000767700720bULL, 0x004fce0003f1d000ULL,
0x000000d600917306ULL, 0x000fe20000209400ULL, 0x000000c000c07245ULL, 0x002fca000020d400ULL,
0x0000000174740812ULL, 0x000fe400078efcffULL, 0x000000d600927306ULL, 0x0002a20000205400ULL,
0x000000babc00720bULL, 0x008fce0003f7d000ULL, 0x0000007c00817306ULL, 0x000fe20000209400ULL,
0x000000d600d67245ULL, 0x002fca000020d400ULL, 0x00000001c0c03812ULL, 0x000fe400078efcffULL,
0x0000007c00867306ULL, 0x0002e20000205400ULL, 0x000000929100720bULL, 0x004fce0003f9d000ULL,
0x00000053008c7306ULL, 0x000fe20000009400ULL, 0x0000007c007c7245ULL, 0x002fca000020d400ULL,
0x00000001d6d64812ULL, 0x000fe400078efcffULL, 0x0000005300847306ULL, 0x000e620000005400ULL,
0x000000868100720bULL, 0x008fe40003fbd000ULL, 0x000000d67474723eULL, 0x000fca00000010ffULL,
0x0000006e00707306ULL, 0x000fec0000209400ULL, 0x000000017c7c5812ULL, 0x000fe400078efcffULL,
0x0000006e00717306ULL, 0x0004e20000205400ULL, 0x000000848c00720bULL, 0x002fe40003fdd000ULL,
0x000000797a00720bULL, 0x000fc40003fbd000ULL, 0x00000075c779723eULL, 0x000fc600000010ffULL,
0x000000b900bb7306ULL, 0x000fe20000209400ULL, 0x0000006e006e7245ULL, 0x004fc6000020d400ULL,
0x000000784c18723cULL, 0x000f680000041818ULL, 0x000000b900bd7306ULL, 0x0002a20000205400ULL,
0x000000717000720bULL, 0x008fe40003f9d000ULL, 0x000000015a5a5812ULL, 0x000fca00078efcffULL,
0x000000c400807306ULL, 0x000fe20000209400ULL, 0x000000b900b97245ULL, 0x002fca000020d400ULL,
0x000000016e6e4812ULL, 0x000fe400078efcffULL, 0x000000c400837306ULL, 0x0002e20000205400ULL,
0x000000bdbb00720bULL, 0x004fce0003f7d000ULL, 0x0000005300627306ULL, 0x000522000000d400ULL,
0x000000c400c47245ULL, 0x002fca000020d400ULL, 0x00000001b9b93812ULL, 0x000fe400078efcffULL,
0x00000064006a7306ULL, 0x000fe20000209400ULL, 0x0001000053537824ULL, 0x004fe200078e00ffULL,
0x000000838000720bULL, 0x008fe40003f1d000ULL, 0x000000878b00720bULL, 0x000fe40003f7d000ULL,
0x00000018ff947819ULL, 0x000fe40000011453ULL, 0x00000064006b7306ULL, 0x0002a20000205400ULL,
0x0000007bb053723eULL, 0x000fc400000010ffULL, 0x0000000162626812ULL, 0x010fe400078efcffULL,
0x0000009400757245ULL, 0x000fe4000020d400ULL, 0x00000001c4c40812ULL, 0x000fe200078efcffULL,
0x000000c600817306ULL, 0x000fe20000209400ULL, 0x000000524c20723cULL, 0x000b620000041820ULL,
0x0000006400647245ULL, 0x002fe4000020d400ULL, 0x000000015b5b3812ULL, 0x000fe400078efcffULL,
0x0000005cc45c723eULL, 0x000fc400000010ffULL, 0x000000c600847306ULL, 0x0002e20000205400ULL,
0x0000006f5752723eULL, 0x020fe400000010ffULL, 0x000000695653723eULL, 0x000fe400000010ffULL,
0x0000006b6a00720bULL, 0x004fc60003f9d000ULL, 0x0000005d00677306ULL, 0x000fe20000209400ULL,
0x000000c600c67245ULL, 0x002fe2000020d400ULL, 0x000000524c04723cULL, 0x000b6c0000041804ULL,
0x0000005d00687306ULL, 0x000e620000205400ULL, 0x000000848100720bULL, 0x008fe40003f1d000ULL,
0x000000518d4c723eULL, 0x020fc400000010ffULL, 0x000000b97c4d723eULL, 0x000fe400000010ffULL,
0x0000000164644812ULL, 0x000fe200078efcffULL, 0x0000009400977306ULL, 0x000fe20000209400ULL,
0x00000063e14e723eULL, 0x000fe400000010ffULL, 0x00000062da4f723eULL, 0x000fe200000010ffULL,
0x0000004c081c723cULL, 0x000b64000004181cULL, 0x00000001c6c60812ULL, 0x000fe400078efcffULL,
0x00000094007e7306ULL, 0x000ea20000205400ULL, 0x000000686700720bULL, 0x002fc40003f5d000ULL,
0x0000005d004c7245ULL, 0x020fe2000020d400ULL, 0x0000004e0818723cULL, 0x040b620000041818ULL,
0x00000065c067723eULL, 0x000fe400000010ffULL, 0x000000b800657245ULL, 0x000fe2000020d400ULL,
0x000000c5007d7306ULL, 0x000fe20000209400ULL, 0x0000005bc65d723eULL, 0x000fe400000010ffULL,
0x000000b4005b7245ULL, 0x000fe2000020d400ULL, 0x000000660820723cULL, 0x000b640000041820ULL,
0x000000014c4c2812ULL, 0x000fc400078efcffULL, 0x000000c5007a7306ULL, 0x0002e20000205400ULL,
0x0000007e9700720bULL, 0x004fc60003fdd000ULL, 0x0000005c0810723cULL, 0x000b680000041810ULL,
0x000000b800767306ULL, 0x000fe20000209400ULL, 0x000000c500c57245ULL, 0x002fca000020d400ULL,
0x0000000175756812ULL, 0x000fe400078efcffULL, 0x000000b800777306ULL, 0x000e620000205400ULL,
0x0000007a7d00720bULL, 0x008fe40003f1d000ULL, 0x0000006c6d00720bULL, 0x000fe40003fdd000ULL,
0x000000756e75723eULL, 0x000fc600000010ffULL, 0x000000b600727306ULL, 0x000fe80000209400ULL,
0x000000740814723cULL, 0x000b640000041814ULL, 0x00000001c5c50812ULL, 0x000fe400078efcffULL,
0x000000b600707306ULL, 0x0004e20000205400ULL, 0x000000777600720bULL, 0x002fe40003f7d000ULL,
0x0000000159596812ULL, 0x000fc400078efcffULL, 0x000000c56464723eULL, 0x000fc600000010ffULL,
0x000000b400577306ULL, 0x000fe20000209400ULL, 0x000000b600b67245ULL, 0x004fca000020d400ULL,
0x0000000165653812ULL, 0x000fe400078efcffULL, 0x000000b400567306ULL, 0x000e620000205400ULL,
0x000000707200720bULL, 0x008fe40003f9d000ULL, 0x000000654c65723eULL, 0x000fca00000010ffULL,
0x0000005800607306ULL, 0x000fe40000209400ULL, 0x00000064080c723cULL, 0x000b68000004180cULL,
0x00000001b6b64812ULL, 0x000fe400078efcffULL, 0x0000005800617306ULL, 0x0004e20000205400ULL,
0x000000565700720bULL, 0x002fe40003f5d000ULL, 0x0000005ab65a723eULL, 0x000fca00000010ffULL,
0x0000004b005e7306ULL, 0x000fe20000209400ULL, 0x0000005800587245ULL, 0x004fca000020d400ULL,
0x000000015b5b2812ULL, 0x000fe400078efcffULL, 0x0000004b005f7306ULL, 0x0002a20000205400ULL,
0x000000616000720bULL, 0x008fe40003f1d000ULL, 0x000000595b5b723eULL, 0x000fe400000010ffULL,
0x000000a200597245ULL, 0x000fc6000020d400ULL, 0x000000af00527306ULL, 0x000fe20000209400ULL,
0x0000004b004b7245ULL, 0x002fe2000020d400ULL, 0x0000005a0804723cULL, 0x000b680000041804ULL,
0x0000000158580812ULL, 0x000fe400078efcffULL, 0x000000af00507306ULL, 0x0002e20000205400ULL,
0x0000005f5e00720bULL, 0x004fce0003f7d000ULL, 0x000000a200517306ULL, 0x000fe20000209400ULL,
0x000000af00af7245ULL, 0x002fca000020d400ULL, 0x000000014b4b3812ULL, 0x000fe400078efcffULL,
0x000000a2004d7306ULL, 0x000e620000205400ULL, 0x000000505200720bULL, 0x008fda0003f9d000ULL,
0x00000001afaf4812ULL, 0x000fe400078efcffULL, 0x0000004d5100720bULL, 0x002fe40003fbd000ULL,
0x000000af5858723eULL, 0x000fd600000010ffULL, 0x0000000159595812ULL, 0x000fc800078efcffULL,
0x000000594b59723eULL, 0x000fce00000010ffULL, 0x000000580808723cULL, 0x000b62000004183cULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff3c7f8cULL, 0x020e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000040413c7810ULL, 0x002fe20007ffe0ffULL, 0x01069000ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff4b7224ULL, 0x000fe200078e003dULL, 0x000000012c2c7810ULL, 0x000fe40007ffe0ffULL,
0x000000243c00720cULL, 0x000fda0003f06070ULL, 0x0000c01000000947ULL, 0x000fea0003800000ULL,
0x00000000003c7805ULL, 0x000fc40000015200ULL, 0x0106bc00ff2c7984ULL, 0x000e640000000800ULL,
0x800000002cff7812ULL, 0x002fe4000780484bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003e7805ULL, 0x000fcc0000015200ULL,
0x0000003e3c3e7210ULL, 0x000fca0007f1e1ffULL, 0x000000013f3f7824ULL, 0x000fe200000e0e3dULL,
0x003d09003e00780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403e00780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff2c7819ULL, 0x000fc8000001143fULL, 0x0000003e2c2c7211ULL, 0x000fca00078110ffULL,
0x000000ffff3e7224ULL, 0x000fca00000e063fULL, 0x000000022c2c7819ULL, 0x000fc8000000123eULL,
0x0000002c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000014c4c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106bc00ff2c7984ULL, 0x000e640000000800ULL, 0x800000002cff7812ULL, 0x002fe4000780484bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000046000009947ULL, 0x000fea0003800000ULL,
0x00000060412c7810ULL, 0x000fe20007ffe0ffULL, 0x00000001273d7824ULL, 0x000fe200078e0236ULL,
0x00000002364b7810ULL, 0x000fe40007ffe0ffULL, 0x0000002c243c7217ULL, 0x000fe20007800000ULL,
0x000000013d3e7824ULL, 0x040fe200078e0203ULL, 0x00000004364c7810ULL, 0x040fe20007ffe0ffULL,
0x000000103d527824ULL, 0x000fe200078e00ffULL, 0x0000000636557810ULL, 0x000fe20007ffe0ffULL,
0x000000013c3c7824ULL, 0x000fe200078e0a2cULL, 0x00000020002c7811ULL, 0x000fe200078e38ffULL,
0x00000001273f7824ULL, 0x040fe200078e024cULL, 0xfffffff052527812ULL, 0x000fe200078ee23eULL,
0x00000001273e7824ULL, 0x040fe200078e024bULL, 0x0000003c273c7217ULL, 0x000fe20007800000ULL,
0x000000013d507824ULL, 0x100fe200078e022cULL, 0x000000f02e517812ULL, 0x000fe200078ec0ffULL,
0x00000001274e7824ULL, 0x000fe200078e0255ULL, 0x0000e00052527811ULL, 0x000fe200078e20ffULL,
0x000000013e4f7824ULL, 0x000fe200078e022cULL, 0x0000004950507210ULL, 0x000fe20007f1e0ffULL,
0x000000013e3d7824ULL, 0x000fc400078e0203ULL, 0x000000103e537824ULL, 0x000fe200078e00ffULL,
0x000000494f4f7210ULL, 0x080fe20007f5e0ffULL, 0x000000013f4d7824ULL, 0x100fe400078e022cULL,
0x000000014e567824ULL, 0x040fe200078e022cULL, 0xfffffff053537812ULL, 0x000fe200078ee23dULL,
0x000000014e2c7824ULL, 0x140fe200078e0203ULL, 0x000000494d4d7210ULL, 0x000fe20007f7e0ffULL,
0x000000104e577824ULL, 0x000fe200078e00ffULL, 0x0000e00053537811ULL, 0x000fe200078e20ffULL,
0x000000013f3e7824ULL, 0x000fc400078e0203ULL, 0x000000103f547824ULL, 0x000fe200078e00ffULL,
0xfffffff057577812ULL, 0x000fe200078ee22cULL, 0x000000ffff3d7224ULL, 0x000fe200000e06ffULL,
0x00005e00503f7a11ULL, 0x000fe200078040ffULL, 0x000000013c2c7824ULL, 0x000fe200078e0a27ULL,
0xfffffff054547812ULL, 0x000fe200078ee23eULL, 0x000000ffff3c7224ULL, 0x000fe200010e06ffULL,
0x00005e004f4e7a11ULL, 0x000fe400078440ffULL, 0x00005f0050507a11ULL, 0x000fe200000f443dULL,
0x000000ffff3d7224ULL, 0x000fe200018e06ffULL, 0x0000002c4b00720cULL, 0x000fc40003f06070ULL,
0x00000049563e7210ULL, 0x000fe40007fde0ffULL, 0x00005f004f4f7a11ULL, 0x000fe400010f443cULL,
0x00005e004d4b7a11ULL, 0x000fe400078a40ffULL, 0x0000002c3600720cULL, 0x080fe40003f46070ULL,
0x000000513f3c7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff3f7224ULL, 0x000fe200030e06ffULL,
0x0000002c4c00720cULL, 0x000fc40003f66070ULL, 0x00005f004d4d7a11ULL, 0x000fe200028f443dULL,
0x000000ffff3d7224ULL, 0x000fe200020e0650ULL, 0x00005e003e4c7a11ULL, 0x040fe400078a40ffULL,
0x0000002c5500720cULL, 0x000fe40003f86070ULL, 0x00005f003e2c7a11ULL, 0x000fe200028f443fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c527faeULL, 0x0003e2000d101c46ULL,
0x000000514e3e7210ULL, 0x000fe40007fbe0ffULL, 0x0000e00054547811ULL, 0x000fc400078e20ffULL,
0x0000e00057577811ULL, 0x000fe200078e20ffULL, 0x000000ffff3f7224ULL, 0x000fe200028e064fULL,
0x000000514c4c7210ULL, 0x000fc80007fbe0ffULL, 0x000000003e537faeULL, 0x0005e2000c101c46ULL,
0x000000514b3c7210ULL, 0x002fca0007f5e0ffULL, 0x000000ffff3d7224ULL, 0x000fe400010e064dULL,
0x000000ffff4d7224ULL, 0x000fc600028e062cULL, 0x000000003c547faeULL, 0x0005e8000d901c46ULL,
0x000000004c577faeULL, 0x0005e2000e101c46ULL, 0x0000039000007947ULL, 0x000fea0003800000ULL,
0x00000001272c7824ULL, 0x000fe200078e0236ULL, 0x00000020003d7811ULL, 0x000fe400078e38ffULL,
0x000000f02e517812ULL, 0x000fe200078ec0ffULL, 0x000000012c3e7824ULL, 0x040fe200078e0203ULL,
0x000000022c3f7810ULL, 0x040fe20007ffe0ffULL, 0x000000102c527824ULL, 0x040fe200078e00ffULL,
0x000000042c4c7810ULL, 0x040fe20007ffe0ffULL, 0x000000012c3c7824ULL, 0x040fe200078e023dULL,
0x000000062c4e7810ULL, 0x000fe20007ffe0ffULL, 0x000000013d2c7824ULL, 0x000fe200078e023fULL,
0xfffffff052527812ULL, 0x000fe200078ee23eULL, 0x000000013f4b7824ULL, 0x040fe200078e0203ULL,
0x000000493c3e7210ULL, 0x000fe20007f1e0ffULL, 0x000000103f537824ULL, 0x000fe200078e00ffULL,
0x0000e00052527811ULL, 0x000fe200078e20ffULL, 0x000000013d3c7824ULL, 0x000fc400078e024cULL,
0x000000014c4d7824ULL, 0x040fe200078e0203ULL, 0xfffffff053537812ULL, 0x000fe200078ee24bULL,
0x000000104c547824ULL, 0x000fe200078e00ffULL, 0x0000003c493c7210ULL, 0x000fe20007f5e0ffULL,
0x000000013d3d7824ULL, 0x000fe200078e024eULL, 0x0000e00053537811ULL, 0x000fe200078e20ffULL,
0x000000014e4c7824ULL, 0x000fe200078e0203ULL, 0xfffffff054547812ULL, 0x000fe200078ee24dULL,
0x000000104e557824ULL, 0x000fe200078e00ffULL, 0x0000003d493d7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff3f7224ULL, 0x000fe200000e06ffULL, 0x00005e003e4e7a11ULL, 0x000fc400078040ffULL,
0xfffffff055557812ULL, 0x000fe400078ee24cULL, 0x00005f003e507a11ULL, 0x000fe200000f443fULL,
0x000000ffff3f7224ULL, 0x000fe200010e06ffULL, 0x0000002c494d7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff2c7224ULL, 0x000fe200018e06ffULL, 0x00005e003c3e7a11ULL, 0x000fe400078440ffULL,
0x00005e003d4c7a11ULL, 0x000fe200078640ffULL, 0x000000ffff4f7224ULL, 0x000fe200000e06ffULL,
0x00005e004d4b7a11ULL, 0x000fc400078040ffULL, 0x000000514e4e7210ULL, 0x080fe40007f9e0ffULL,
0x00005f004d4d7a11ULL, 0x000fe400000f444fULL, 0x00005f003c3f7a11ULL, 0x000fe200010f443fULL,
0x000000ffff4f7224ULL, 0x000fe200020e0650ULL, 0x000000514b3c7210ULL, 0x080fe40007f1e0ffULL,
0x00005f003d2c7a11ULL, 0x000fe400018f442cULL, 0x000000513e3e7210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff3d7224ULL, 0x000fe200000e064dULL, 0x000000514c4c7210ULL, 0x000fe20007f7e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000004e527faeULL, 0x0003e2000b901c46ULL,
0x0000e00054547811ULL, 0x000fe200078e20ffULL, 0x000000ffff3f7224ULL, 0x000fe200010e063fULL,
0x0000e00055557811ULL, 0x000fe200078e20ffULL, 0x000000ffff4d7224ULL, 0x000fe200018e062cULL,
0x000000003c537faeULL, 0x0003e8000b901c46ULL, 0x000000003e547faeULL, 0x0003e8000b901c46ULL,
0x000000004c557faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b000ff647f8cULL, 0x000ee2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01064800274c7f8cULL, 0x0062a4000c80043fULL,
0x00000000003c7805ULL, 0x000fc40000015200ULL, 0x01064c00272c7984ULL, 0x000f240000000800ULL,
0x800000002cff7812ULL, 0x014fc4000780484dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4b7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104b00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003e7805ULL, 0x000fcc0000015200ULL,
0x0000003e3c3e7210ULL, 0x000fca0007f1e1ffULL, 0x000000013f3f7824ULL, 0x000fe200000e0e3dULL,
0x003d09003e00780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403e00780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff2c7819ULL, 0x000fc8000001143fULL, 0x0000003e2c2c7211ULL, 0x000fca00078110ffULL,
0x000000ffff3e7224ULL, 0x000fca00000e063fULL, 0x000000022c2c7819ULL, 0x000fc8000000123eULL,
0x0000002c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000014b4b7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01064c00272c7984ULL, 0x000ea40000000800ULL, 0x800000002cff7812ULL, 0x004fe4000780484dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x010100002f2c7984ULL, 0x000ea80000000800ULL,
0x010300002f3e7984ULL, 0x0002e20000000800ULL, 0x0000004a2c00720bULL, 0x004fe20003f1d000ULL,
0x000127527f007947ULL, 0x000fd8000b800000ULL, 0x00000000003f7806ULL, 0x002fc800000e0100ULL,
0x0000ffff3fff7812ULL, 0x000fe2000780c0ffULL, 0x0000047000007945ULL, 0x000fe20003800000ULL,
0x00000001ff4b7424ULL, 0x000fd600078e00ffULL, 0x0000044000008947ULL, 0x000fea0003800000ULL,
0x000000020200780cULL, 0x000fe40003f05270ULL, 0x0000004a2c00720bULL, 0x000fe20003f54000ULL,
0x000127227f007947ULL, 0x000fd8000b800000ULL, 0x00000000003c7806ULL, 0x000fc400010e0100ULL,
0x0000002c4a3d8209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe80003800000ULL,
0x0105003d2f008388ULL, 0x0003e40000000800ULL, 0x000099103c3d7816ULL, 0x002fc800000000ffULL,
0x000000ff3d00720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000002c4a3d7209ULL, 0x000fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff3cff7812ULL, 0x000fc6000780c0ffULL, 0x8000003d4a3d7221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b3d3d7820ULL, 0x000fc80000410000ULL, 0x0000003d004e7308ULL, 0x000e640000000800ULL,
0x0000004e29297220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff3d7819ULL, 0x000fe20000011603ULL, 0x000126627f007947ULL, 0x000fea000b800000ULL,
0x00001f3d4e3d7589ULL, 0x0002a400000e0000ULL, 0x0000003d20207220ULL, 0x084fe20000410000ULL,
0x0000003d21217220ULL, 0x080fe20000410000ULL, 0x0000003d1c1c7220ULL, 0x080fe20000410000ULL,
0x0000003d1d1d7220ULL, 0x080fe20000410000ULL, 0x0000003d18187220ULL, 0x080fe20000410000ULL,
0x0000003d19197220ULL, 0x080fe20000410000ULL, 0x0000003d14147220ULL, 0x080fe20000410000ULL,
0x0000003d15157220ULL, 0x080fe20000410000ULL, 0x0000003d10107220ULL, 0x080fe20000410000ULL,
0x0000003d11117220ULL, 0x080fe20000410000ULL, 0x0000003d0c0c7220ULL, 0x080fe20000410000ULL,
0x0000003d0d0d7220ULL, 0x080fe20000410000ULL, 0x0000003d04047220ULL, 0x080fe20000410000ULL,
0x0000003d05057220ULL, 0x080fe20000410000ULL, 0x0000003d08087220ULL, 0x080fe20000410000ULL,
0x0000003d09097220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff003cff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008033d7811ULL, 0x000fe200078ff0ffULL, 0x000125627f007947ULL, 0x000fea000b800000ULL,
0x00001f3d4e3d7589ULL, 0x00046400000e0000ULL, 0x0000003d22227220ULL, 0x082fe20000410000ULL,
0x0000003d23237220ULL, 0x080fe20000410000ULL, 0x0000003d1e1e7220ULL, 0x080fe20000410000ULL,
0x0000003d1f1f7220ULL, 0x080fe20000410000ULL, 0x0000003d1a1a7220ULL, 0x080fe20000410000ULL,
0x0000003d1b1b7220ULL, 0x080fe20000410000ULL, 0x0000003d16167220ULL, 0x080fe20000410000ULL,
0x0000003d17177220ULL, 0x080fe20000410000ULL, 0x0000003d12127220ULL, 0x080fe20000410000ULL,
0x0000003d13137220ULL, 0x080fe20000410000ULL, 0x0000003d0e0e7220ULL, 0x080fe20000410000ULL,
0x0000003d0f0f7220ULL, 0x080fe20000410000ULL, 0x0000003d06067220ULL, 0x080fe20000410000ULL,
0x0000003d07077220ULL, 0x080fe20000410000ULL, 0x0000003d0a0a7220ULL, 0x080fe20000410000ULL,
0x0000003d0b0b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000ffff3cff7812ULL, 0x000fe2000780083fULL, 0x00000001ff4b7424ULL, 0x000fe200078e00ffULL,
0x0000002c4a4a7209ULL, 0x000fd60007810000ULL, 0x8000004a2c2c0221ULL, 0x000fe20000010000ULL,
0x00007610ff4b0816ULL, 0x000fc6000000004bULL, 0x3fb8aa3b2c2c0820ULL, 0x000fc80000410000ULL,
0x0000002c00330308ULL, 0x000f240000000800ULL, 0x000000333e3e0220ULL, 0x018fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000293e297221ULL, 0x008fc20000010000ULL,
0x00000000003c7805ULL, 0x000fcc0000015200ULL, 0x0106ac00ff2c7984ULL, 0x000ee40000000800ULL,
0x800000002cff7812ULL, 0x008fe40007804848ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003e7805ULL, 0x000fcc0000015200ULL,
0x0000003e3c3e7210ULL, 0x000fca0007f1e1ffULL, 0x000000013f3f7824ULL, 0x000fe200000e0e3dULL,
0x003d09003e00780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403e00780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff2c7819ULL, 0x000fc8000001143fULL, 0x0000003e2c2c7211ULL, 0x000fca00078110ffULL,
0x000000ffff3e7224ULL, 0x000fca00000e063fULL, 0x000000022c2c7819ULL, 0x000fc8000000123eULL,
0x0000002c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000014c4c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106ac00ff2c7984ULL, 0x000ee40000000800ULL, 0x800000002cff7812ULL, 0x008fe40007804848ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099104b2c7816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff2c00720cULL, 0x000fda0003f45270ULL,
0x0000012000002947ULL, 0x000fea0003800000ULL, 0x00000033ff2c723eULL, 0x000fe400000010ffULL,
0x00000002ff3c7819ULL, 0x000fe40000011603ULL, 0x000054102c2c7816ULL, 0x000fe2000000002cULL,
0x000121527f007947ULL, 0x000fea000b800000ULL, 0x00001f3c2c347589ULL, 0x00066400000e0000ULL,
0x000000083c357810ULL, 0x000fe20007ffe0ffULL, 0x000121827f007947ULL, 0x000fea000b800000ULL,
0x00001f352c357589ULL, 0x0004e400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000103c4b7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff4d7224ULL, 0x000fe200078e002cULL,
0x0000eb80004c7802ULL, 0x000fc40000000f00ULL, 0x000129d000007944ULL, 0x00efea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000183c4b7810ULL, 0x004fe20007ffe0ffULL,
0x000000ffff4d7224ULL, 0x000fe200078e002cULL, 0x0000ebd0004c7802ULL, 0x000fc40000000f00ULL,
0x0001298000007944ULL, 0x00afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000003750783bULL, 0x000f280000004200ULL,
0x00000000394c783bULL, 0x006e680000004200ULL, 0x000000003854783bULL, 0x000ea80000004200ULL,
0x000000003a3c783bULL, 0x008ee20000004200ULL, 0x0000010050d57824ULL, 0x050fe200078e00ffULL,
0x0000005000cf7306ULL, 0x000fe20000009400ULL, 0x0001000050d37824ULL, 0x000fe200078e00ffULL,
0x00000018ffb67819ULL, 0x000fe20000011451ULL, 0x0000010051ce7824ULL, 0x040fe200078e00ffULL,
0x00000018ffd57819ULL, 0x000fe200000114d5ULL, 0x0001000051cd7824ULL, 0x000fe200078e00ffULL,
0x00000018ffd37819ULL, 0x000fe200000114d3ULL, 0x0000010053bd7824ULL, 0x040fe200078e00ffULL,
0x000000d500da7306ULL, 0x000fe20000209400ULL, 0x00000018ffce7819ULL, 0x000fe200000114ceULL,
0x000001004ede7824ULL, 0x002fe200078e00ffULL, 0x00000018ff8d7819ULL, 0x000fe2000001144cULL,
0x0001000052be7824ULL, 0x000fe200078e00ffULL, 0x00000018ffbd7819ULL, 0x000fe200000114bdULL,
0x0001000053c17824ULL, 0x000fe200078e00ffULL, 0x00000018ffc27819ULL, 0x000fe20000011450ULL,
0x000000d500db7306ULL, 0x000e620000205400ULL, 0x00000018ff637819ULL, 0x000fe2000001144eULL,
0x0000010055a67824ULL, 0x044fe200078e00ffULL, 0x00000018ffcd7819ULL, 0x000fe200000114cdULL,
0x0001000055a27824ULL, 0x000fe200078e00ffULL, 0x00000018ffbe7819ULL, 0x000fe200000114beULL,
0x0000010054b57824ULL, 0x000fe200078e00ffULL, 0x00000018ffc17819ULL, 0x000fe200000114c1ULL,
0x0000005000d67306ULL, 0x000ea20000005400ULL, 0x00000018ff9b7819ULL, 0x000fe20000011453ULL,
0x0000010052bc7824ULL, 0x000fe200078e00ffULL, 0x00000018ffa67819ULL, 0x000fe200000114a6ULL,
0x0001000054a77824ULL, 0x000fe200078e00ffULL, 0x00000018ffac7819ULL, 0x000fc40000011452ULL,
0x00000018ff987819ULL, 0x000fe20000011454ULL, 0x000000d300dc7306ULL, 0x000fe20000209400ULL,
0x000000dbda00720bULL, 0x002fe20003fdd000ULL, 0x000100004cdb7824ULL, 0x040fe200078e00ffULL,
0x00000018ffa27819ULL, 0x000fe200000114a2ULL, 0x000001004fda7824ULL, 0x000fe200078e00ffULL,
0x00000018ff977819ULL, 0x000fe40000011455ULL, 0x00000018ffb57819ULL, 0x000fe200000114b5ULL,
0x000000d300dd7306ULL, 0x000e620000205400ULL, 0x000000d6cf00720bULL, 0x004fe20003f7d000ULL,
0x000001004cd67824ULL, 0x000fe200078e00ffULL, 0x00000018ffbc7819ULL, 0x000fc400000114bcULL,
0x00000018ffa77819ULL, 0x000fe400000114a7ULL, 0x00000018ff837819ULL, 0x000fe20000011457ULL,
0x0000005100c97306ULL, 0x000fe20000009400ULL, 0x00000018ff727819ULL, 0x008fe4000001143cULL,
0x00000018ff6d7819ULL, 0x000fe4000001143dULL, 0x00000018ff2c7819ULL, 0x000fe4000001143eULL,
0x00000018ff487819ULL, 0x000fe2000001143fULL, 0x0000005100c67306ULL, 0x000ea20000005400ULL,
0x000000dddc00720bULL, 0x002fe20003fbd000ULL, 0x000001004ddc7824ULL, 0x040fe200078e00ffULL,
0x00000018ff867819ULL, 0x000fe20000011456ULL, 0x000100004ddd7824ULL, 0x000fe200078e00ffULL,
0x00000018ff7d7819ULL, 0x000fc4000001144dULL, 0x00000018ffda7819ULL, 0x000fe200000114daULL,
0x00000051007e7306ULL, 0x000e62000000d400ULL, 0x00000018ff5d7819ULL, 0x000fe4000001144fULL,
0x00000018ffdd7819ULL, 0x000fe400000114ddULL, 0x00000018ffde7819ULL, 0x000fc600000114deULL,
0x000000ce00d97306ULL, 0x000fe20000209400ULL, 0x000000c6c900720bULL, 0x004fce0003f9d000ULL,
0x000000ce00517306ULL, 0x0004ec0000205400ULL, 0x000000017e7e4812ULL, 0x002fe400078efcffULL,
0x000000b600ba7306ULL, 0x000fe20000209400ULL, 0x000000ce00ce7245ULL, 0x004fce000020d400ULL,
0x000000b600bb7306ULL, 0x0002b00000205400ULL, 0x0000004c00967306ULL, 0x000fe20000009400ULL,
0x000000b600b67245ULL, 0x002fce000020d400ULL, 0x0000004c00917306ULL, 0x000ff00000005400ULL,
0x0000004c00767306ULL, 0x0003f0000000d400ULL, 0x0000004e008c7306ULL, 0x000fe20000009400ULL,
0x00000018ff4c7819ULL, 0x002fe200000114d6ULL, 0x000100004ed67824ULL, 0x000fca00078e00ffULL,
0x00000018ffd67819ULL, 0x000fe200000114d6ULL, 0x0000004e00807306ULL, 0x000ff00000005400ULL,
0x0000004e006f7306ULL, 0x0003f0000000d400ULL, 0x000000bd00d07306ULL, 0x000fe20000209400ULL,
0x000000d5004e7245ULL, 0x002fc8000020d400ULL, 0x000000014e4e6812ULL, 0x000fe400078efcffULL,
0x00000051d900720bULL, 0x008fe20003fdd000ULL, 0x000000bd00d47306ULL, 0x0002e20000205400ULL,
0x000000d300517245ULL, 0x000fc8000020d400ULL, 0x0000000151515812ULL, 0x000fe400078efcffULL,
0x000000bbba00720bULL, 0x004fe20003fbd000ULL, 0x0000005000887306ULL, 0x000522000000d400ULL,
0x000000bd00bd7245ULL, 0x002fe2000020d400ULL, 0x000001003cbb7824ULL, 0x000fe400078e00ffULL,
0x00000001cece6812ULL, 0x000fc600078efcffULL, 0x00000018ffbb7819ULL, 0x000fe200000114bbULL,
0x000000c200c77306ULL, 0x000fe20000209400ULL, 0x000000d4d000720bULL, 0x008fe20003f9d000ULL,
0x0001000057507824ULL, 0x004fe400078e00ffULL, 0x00000001b6b65812ULL, 0x000fc600078efcffULL,
0x00000018ff507819ULL, 0x000fe20000011450ULL, 0x000000c200c87306ULL, 0x0002a20000205400ULL,
0x0000000188883812ULL, 0x010fc800078efcffULL, 0x000000884e4e723eULL, 0x000fe400000010ffULL,
0x00000001bdbd4812ULL, 0x000fe200078efcffULL, 0x000000cd00d87306ULL, 0x000fe20000209400ULL,
0x000000c200c27245ULL, 0x002fce000020d400ULL, 0x000000cd00d77306ULL, 0x0002e20000205400ULL,
0x000000c8c700720bULL, 0x004fe40003f1d000ULL, 0x00000018ffc77819ULL, 0x000fca00000114dbULL,
0x000000be00c47306ULL, 0x000fe20000209400ULL, 0x000000cd00cd7245ULL, 0x002fca000020d400ULL,
0x00000001c2c20812ULL, 0x000fe400078efcffULL, 0x000000be00c57306ULL, 0x0002a20000205400ULL,
0x000000d7d800720bULL, 0x008fce0003f7d000ULL, 0x000000c100cb7306ULL, 0x000fe20000209400ULL,
0x000000be00be7245ULL, 0x002fca000020d400ULL, 0x00000001cdcd3812ULL, 0x000fe400078efcffULL,
0x000000c100cc7306ULL, 0x0002e20000205400ULL, 0x000000c5c400720bULL, 0x004fce0003fbd000ULL,
0x0000005200b77306ULL, 0x000fe20000009400ULL, 0x000000c100c17245ULL, 0x002fca000020d400ULL,
0x00000001bebe5812ULL, 0x000fe400078efcffULL, 0x0000005200b87306ULL, 0x000e620000005400ULL,
0x000000cccb00720bULL, 0x008fce0003f9d000ULL, 0x0000005300b37306ULL, 0x000fec0000009400ULL,
0x00000001c1c14812ULL, 0x000fe400078efcffULL, 0x0000005300b47306ULL, 0x000ea20000005400ULL,
0x000000b8b700720bULL, 0x002fce0003f1d000ULL, 0x0000009b009c7306ULL, 0x000ff00000209400ULL,
0x0000009b00a87306ULL, 0x000e620000205400ULL, 0x000000b4b300720bULL, 0x004fe40003f7d000ULL,
0x00000018ffb37819ULL, 0x000fca00000114dcULL, 0x000000a600c37306ULL, 0x000ff00000209400ULL,
0x000000a600ca7306ULL, 0x0004e20000205400ULL, 0x000000a89c00720bULL, 0x002fe20003fbd000ULL,
0x000100003e9c7824ULL, 0x000fc400078e00ffULL, 0x000001003fa87824ULL, 0x000fc600078e00ffULL,
0x00000018ff9c7819ULL, 0x000fe2000001149cULL, 0x00000052007a7306ULL, 0x000322000000d400ULL,
0x000000a600a67245ULL, 0x004fe4000020d400ULL, 0x00000018ffa87819ULL, 0x000fca00000114a8ULL,
0x0000005300797306ULL, 0x000522000000d400ULL, 0x000000cac300720bULL, 0x008fe20003f9d000ULL,
0x0001000056527824ULL, 0x002fca00078e00ffULL, 0x00000018ff527819ULL, 0x000fe20000011452ULL,
0x0000005500ad7306ULL, 0x000fe20000009400ULL, 0x0000010057537824ULL, 0x004fe200078e00ffULL,
0x000000017a7a0812ULL, 0x010fc800078efcffULL, 0x00000018ff537819ULL, 0x000fe40000011453ULL,
0x0000005500ae7306ULL, 0x000e620000005400ULL, 0x0000000179793812ULL, 0x000fe400078efcffULL,
0x00000001a6a64812ULL, 0x000fca00078efcffULL, 0x000000ac00b27306ULL, 0x000ff00000209400ULL,
0x000000ac00af7306ULL, 0x0004e20000205400ULL, 0x000000aead00720bULL, 0x002fe20003f7d000ULL,
0x000100003dae7824ULL, 0x000fe200078e00ffULL, 0x000000ac00ad7245ULL, 0x000fc8000020d400ULL,
0x00000018ffae7819ULL, 0x000fe200000114aeULL, 0x00000098009f7306ULL, 0x000fe20000209400ULL,
0x000001003eac7824ULL, 0x004fca00078e00ffULL, 0x00000018ffac7819ULL, 0x000fe400000114acULL,
0x0000009800a07306ULL, 0x0002a20000205400ULL, 0x000000afb200720bULL, 0x008fe40003f1d000ULL,
0x0000009b00af7245ULL, 0x000fe2000020d400ULL, 0x000100003f9b7824ULL, 0x000fc600078e00ffULL,
0x00000001afaf5812ULL, 0x000fe200078efcffULL, 0x000000a200aa7306ULL, 0x000fe20000209400ULL,
0x0000009800987245ULL, 0x002fe4000020d400ULL, 0x00000018ff9b7819ULL, 0x000fc6000001149bULL,
0x00000001adad0812ULL, 0x000fe400078efcffULL, 0x000000a200ab7306ULL, 0x0002e20000205400ULL,
0x000000a09f00720bULL, 0x004fce0003fbd000ULL, 0x0000005500587306ULL, 0x000522000000d400ULL,
0x000000a200a27245ULL, 0x002fca000020d400ULL, 0x0000000198985812ULL, 0x000fe400078efcffULL,
0x00000097009a7306ULL, 0x000fe20000209400ULL, 0x000000abaa00720bULL, 0x008fe20003f9d000ULL,
0x0000010056557824ULL, 0x004fca00078e00ffULL, 0x00000018ff557819ULL, 0x000fe20000011455ULL,
0x0000009700997306ULL, 0x0002a20000205400ULL, 0x0000000158583812ULL, 0x010fca00078efcffULL,
0x00000001a2a24812ULL, 0x000fe400078efcffULL, 0x000000b500c07306ULL, 0x000fe20000209400ULL,
0x0000009700977245ULL, 0x002fce000020d400ULL, 0x000000b500bf7306ULL, 0x0002e20000205400ULL,
0x000000999a00720bULL, 0x004fce0003f7d000ULL, 0x0000005300a17306ULL, 0x000fe20000209400ULL,
0x000000b500b57245ULL, 0x002fca000020d400ULL, 0x0000000197973812ULL, 0x000fe400078efcffULL,
0x0000005300a57306ULL, 0x000e620000205400ULL, 0x000000bfc000720bULL, 0x008fe20003f1d000ULL,
0x000100003cbf7824ULL, 0x000fe200078e00ffULL, 0x000000919600720bULL, 0x000fe20003f7d000ULL,
0x000001003dc07824ULL, 0x000fe200078e00ffULL, 0x0000005300917245ULL, 0x000fe4000020d400ULL,
0x00000018ffbf7819ULL, 0x000fe200000114bfULL, 0x000000bc00d17306ULL, 0x000fe20000209400ULL,
0x00000018ffc07819ULL, 0x000fc400000114c0ULL, 0x000000a29797723eULL, 0x000fc600000010ffULL,
0x00000001b5b50812ULL, 0x000fe400078efcffULL, 0x000000bc00d27306ULL, 0x0004e20000205400ULL,
0x000000a5a100720bULL, 0x002fe40003fbd000ULL, 0x0000000176763812ULL, 0x000fca00078efcffULL,
0x0000005700927306ULL, 0x000fe20000009400ULL, 0x000000bc00bc7245ULL, 0x004fca000020d400ULL,
0x0000000191915812ULL, 0x000fe400078efcffULL, 0x0000005700907306ULL, 0x000e620000005400ULL,
0x000000d2d100720bULL, 0x008fce0003fdd000ULL, 0x000000a700a97306ULL, 0x000fec0000209400ULL,
0x00000001bcbc6812ULL, 0x000fe400078efcffULL, 0x000000a700b97306ULL, 0x0004e20000205400ULL,
0x000000909200720bULL, 0x002fe40003f9d000ULL, 0x0000005000927245ULL, 0x000fc4000020d400ULL,
0x0000005500907245ULL, 0x000fc6000020d400ULL, 0x00000057005e7306ULL, 0x000e62000000d400ULL,
0x000000a700a77245ULL, 0x004fce000020d400ULL, 0x0000005000577306ULL, 0x000fe20000209400ULL,
0x000000b9a900720bULL, 0x008fce0003f1d000ULL, 0x0000005000cf7306ULL, 0x0004e20000205400ULL,
0x000000015e5e4812ULL, 0x002fca00078efcffULL, 0x00000001a7a70812ULL, 0x000fe400078efcffULL,
0x0000005400b07306ULL, 0x000fe20000009400ULL, 0x0000007abc50723eULL, 0x004fe400000010ffULL,
0x000000a79896723eULL, 0x000fca00000010ffULL, 0x0000005400b17306ULL, 0x000e620000005400ULL,
0x000000cf5700720bULL, 0x008fce0003fbd000ULL, 0x00000083008f7306ULL, 0x000fec0000209400ULL,
0x0000000192925812ULL, 0x000fe400078efcffULL, 0x0000008300937306ULL, 0x0004e20000205400ULL,
0x000000b1b000720bULL, 0x002fce0003fdd000ULL, 0x0000005500a37306ULL, 0x000fe20000209400ULL,
0x0000008300837245ULL, 0x004fce000020d400ULL, 0x0000005500a47306ULL, 0x0002a20000205400ULL,
0x000000938f00720bULL, 0x008fe40003f9d000ULL, 0x00000052008f7245ULL, 0x000fca000020d400ULL,
0x000000c700ba7306ULL, 0x000fe20000209400ULL, 0x000000c1af55723eULL, 0x002fca00000010ffULL,
0x0000000183834812ULL, 0x000fe400078efcffULL, 0x000000c700b77306ULL, 0x0002e20000205400ULL,
0x000000a4a300720bULL, 0x004fce0003f1d000ULL, 0x0000003c00897306ULL, 0x000fe20000009400ULL,
0x000000c700c77245ULL, 0x002fca000020d400ULL, 0x0000000190900812ULL, 0x000fe400078efcffULL,
0x0000003c007f7306ULL, 0x000fe20000005400ULL, 0x000000b7ba00720bULL, 0x008fce0003fbd000ULL,
0x0000003c00697306ULL, 0x0003ec000000d400ULL, 0x00000001c7c75812ULL, 0x000fe400078efcffULL,
0x0000005400627306ULL, 0x000ea2000000d400ULL, 0x0000b000403c7811ULL, 0x002fe400078e20ffULL,
0x000000808c00720bULL, 0x000fca0003fbd000ULL, 0x00000056009d7306ULL, 0x000ff00000009400ULL,
0x00000056009e7306ULL, 0x000e620000005400ULL, 0x0000000162626812ULL, 0x004fe400078efcffULL,
0x000000016f6f5812ULL, 0x000fc400078efcffULL, 0x00000062b562723eULL, 0x000fc600000010ffULL,
0x000000b300b47306ULL, 0x000ff00000209400ULL, 0x000000b300b07306ULL, 0x0004e20000205400ULL,
0x0000009e9d00720bULL, 0x002fe40003fdd000ULL, 0x0000009b009d7245ULL, 0x000fca000020d400ULL,
0x0000003d007c7306ULL, 0x000fe20000009400ULL, 0x000000b300b37245ULL, 0x004fce000020d400ULL,
0x0000003d007b7306ULL, 0x000fe20000005400ULL, 0x000000b0b400720bULL, 0x008fce0003f9d000ULL,
0x0000003d006a7306ULL, 0x000fec000000d400ULL, 0x00000001b3b34812ULL, 0x000fe400078efcffULL,
0x0000003e005f7306ULL, 0x000ff00000009400ULL, 0x0000003e005b7306ULL, 0x000ff00000005400ULL,
0x0000003e004b7306ULL, 0x000ff0000000d400ULL, 0x0000003f00617306ULL, 0x000ff00000009400ULL,
0x0000003f00607306ULL, 0x000ff00000005400ULL, 0x0000003f00667306ULL, 0x0003f0000000d400ULL,
0x00000056005c7306ULL, 0x000ea2000000d400ULL, 0x000000003c3c783bULL, 0x002e6e0000000200ULL,
0x0000005200547306ULL, 0x000ff00000209400ULL, 0x0000005200567306ULL, 0x000ee20000205400ULL,
0x000000015c5c6812ULL, 0x004fce00078efcffULL, 0x0000008600947306ULL, 0x000ff00000209400ULL,
0x0000008600957306ULL, 0x0005220000205400ULL, 0x000000565400720bULL, 0x008fce0003f1d000ULL,
0x0000007d008a7306ULL, 0x000fe20000209400ULL, 0x0000008600867245ULL, 0x004fe2000020d400ULL,
0x000000343c3ca231ULL, 0x082fe400003400ffULL, 0x000000343e3ea231ULL, 0x000fe400003400ffULL,
0x000000018f8f0812ULL, 0x000fe200078efcffULL, 0x000000353d3da231ULL, 0x080fe200003400ffULL,
0x0000007d00877306ULL, 0x0002a20000205400ULL, 0x000000959400720bULL, 0x010fe20003fdd000ULL,
0x000000353f3fa231ULL, 0x000fcc00003400ffULL, 0x0000004d008e7306ULL, 0x000fe20000009400ULL,
0x0000007d007d7245ULL, 0x002fca000020d400ULL, 0x0000000186866812ULL, 0x000fe400078efcffULL,
0x0000004d00847306ULL, 0x000fe20000005400ULL, 0x000000878a00720bULL, 0x004fe40003f9d000ULL,
0x0000008f8686723eULL, 0x000fe400000010ffULL, 0x000000928387723eULL, 0x000fc600000010ffULL,
0x0000004d00757306ULL, 0x000fec000000d400ULL, 0x000000017d7d4812ULL, 0x000fe400078efcffULL,
0x0000004c004d7306ULL, 0x000ff00000209400ULL, 0x0000004c00c67306ULL, 0x000e700000205400ULL,
0x000000d600537306ULL, 0x000ff00000209400ULL, 0x000000d600547306ULL, 0x0004e20000205400ULL,
0x000000c64d00720bULL, 0x002fc40003f1d000ULL, 0x000000cdb64d723eULL, 0x000fca00000010ffULL,
0x0000004f008b7306ULL, 0x000fe20000009400ULL, 0x000000d600d67245ULL, 0x004fce000020d400ULL,
0x0000004f00817306ULL, 0x000fe20000005400ULL, 0x000000545300720bULL, 0x008fe40003fbd000ULL,
0x000000bead54723eULL, 0x000fe400000010ffULL, 0x000000a800ad7245ULL, 0x000fc6000020d400ULL,
0x0000004f00707306ULL, 0x0003ec000000d400ULL, 0x00000001d6d65812ULL, 0x000fe400078efcffULL,
0x0000008d00827306ULL, 0x000fe20000209400ULL, 0x000100004f4f7824ULL, 0x002fca00078e00ffULL,
0x00000018ff937819ULL, 0x000fe4000001144fULL, 0x0000008d00857306ULL, 0x0002a20000205400ULL,
0x0000007ece4f723eULL, 0x000fce00000010ffULL, 0x000000da00997306ULL, 0x000fe20000209400ULL,
0x0000004e3c20723cULL, 0x000fe20000041820ULL, 0x0000008d008d7245ULL, 0x002fcc000020d400ULL,
0x000000da009a7306ULL, 0x0002e20000205400ULL, 0x000000858200720bULL, 0x004fe40003fdd000ULL,
0x0000004c00827245ULL, 0x000fe4000020d400ULL, 0x00000051c24c723eULL, 0x000fe400000010ffULL,
0x0000000182820812ULL, 0x000fe200078efcffULL, 0x0000009300567306ULL, 0x000fe20000209400ULL,
0x000000848e00720bULL, 0x000fe40003f1d000ULL, 0x000000da00da7245ULL, 0x002fe2000020d400ULL,
0x0000004c3c4c723cULL, 0x000b62000004181cULL, 0x00000079bd51723eULL, 0x000fc400000010ffULL,
0x000000018d8d6812ULL, 0x000fe200078efcffULL, 0x0000009300577306ULL, 0x0002a20000205400ULL,
0x0000009a9900720bULL, 0x008fe40003f9d000ULL, 0x0000b0003b1c7811ULL, 0x020fe200078e20ffULL,
0x000000503c50723cULL, 0x000be20000041818ULL, 0x000000818b00720bULL, 0x000fe40003fdd000ULL,
0x0000000175750812ULL, 0x000fe200078efcffULL, 0x0000006300787306ULL, 0x000fe20000209400ULL,
0x000000001c1c783bULL, 0x000ee20000000200ULL, 0x0000009300937245ULL, 0x002fc4000020d400ULL,
0x0000007f8900720bULL, 0x000fe40003f1d000ULL, 0x00000001dada4812ULL, 0x000fe400078efcffULL,
0x0000006300777306ULL, 0x000e620000205400ULL, 0x000000575600720bULL, 0x004fe40003fbd000ULL,
0x0000000170706812ULL, 0x000fe200078efcffULL, 0x000000543c54723cULL, 0x000be20000041814ULL,
0x0000005b5f00720bULL, 0x000fe40003fdd000ULL, 0x000000768218723eULL, 0x020fe200000010ffULL,
0x000000dd00b17306ULL, 0x000fe20000209400ULL, 0x0000000169690812ULL, 0x000fc400078efcffULL,
0x00000075b319723eULL, 0x000fe400000010ffULL, 0x000000c78d14723eULL, 0x000fe400000010ffULL,
0x0000000193935812ULL, 0x000fe200078efcffULL, 0x000000dd00b27306ULL, 0x0005220000205400ULL,
0x000000777800720bULL, 0x002fe40003f9d000ULL, 0x0000006300777245ULL, 0x000fe4000020d400ULL,
0x00000058a663723eULL, 0x000fc400000010ffULL, 0x0000005d00787245ULL, 0x000fe2000020d400ULL,
0x000000bb00847306ULL, 0x000fe20000209400ULL, 0x000000dd00dd7245ULL, 0x004fe4000020d400ULL,
0x000000014b4b6812ULL, 0x000fc600078efcffULL, 0x0000000177774812ULL, 0x000fe400078efcffULL,
0x000000bb00807306ULL, 0x0002a20000205400ULL, 0x000000b2b100720bULL, 0x010fe20003f7d000ULL,
0x000000341c1ca231ULL, 0x088fe400003400ffULL, 0x000000341e1ea231ULL, 0x000fe400003400ffULL,
0x000000351d1da231ULL, 0x080fe400003400ffULL, 0x0000005d005a7306ULL, 0x000fe20000209400ULL,
0x000000bb00bb7245ULL, 0x002fe2000020d400ULL, 0x000000351f1fa231ULL, 0x000fc800003400ffULL,
0x00000001dddd3812ULL, 0x000fe400078efcffULL, 0x0000005d00597306ULL, 0x000e620000205400ULL,
0x000000808400720bULL, 0x004fe40003fbd000ULL, 0x000000dd7d15723eULL, 0x000fca00000010ffULL,
0x000000de00b87306ULL, 0x000fe40000209400ULL, 0x000000141c14723cULL, 0x000fe8000004184cULL,
0x00000001bbbb5812ULL, 0x000fe400078efcffULL, 0x000000de009f7306ULL, 0x0004e20000205400ULL,
0x000000595a00720bULL, 0x002fe40003f9d000ULL, 0x000000623c58723cULL, 0x000b6a0000041810ULL,
0x000000c0007f7306ULL, 0x000fe20000209400ULL, 0x000000de00de7245ULL, 0x004fc4000020d400ULL,
0x0000005c9062723eULL, 0x020fe400000010ffULL, 0x0000005e9163723eULL, 0x000fe400000010ffULL,
0x0000000178784812ULL, 0x000fe200078efcffULL, 0x000000c000817306ULL, 0x000e620000205400ULL,
0x0000009fb800720bULL, 0x008fe20003f7d000ULL, 0x000000963c5c723cULL, 0x000be2000004180cULL,
0x000000606100720bULL, 0x000fe40003f9d000ULL, 0x00000070da11723eULL, 0x000fc600000010ffULL,
0x000000bf007e7306ULL, 0x000fe20000209400ULL, 0x000000d6770c723eULL, 0x020fe200000010ffULL,
0x000000623c60723cULL, 0x000b620000041804ULL, 0x00000093780d723eULL, 0x000fc600000010ffULL,
0x00000001dede3812ULL, 0x000fe400078efcffULL, 0x000000bf00797306ULL, 0x0004e20000205400ULL,
0x000000817f00720bULL, 0x002fe20003fbd000ULL, 0x000000863c3c723cULL, 0x000b620000041808ULL,
0x0000007b7c00720bULL, 0x000fe40003f7d000ULL, 0x000000ae00057245ULL, 0x020fe4000020d400ULL,
0x0000000166664812ULL, 0x000fe200078efcffULL, 0x0000007200747306ULL, 0x000fe20000209400ULL,
0x000000c000097245ULL, 0x000fc4000020d400ULL, 0x000000bf00bf7245ULL, 0x004fe4000020d400ULL,
0x0000006fde10723eULL, 0x000fe400000010ffULL, 0x0000000109095812ULL, 0x000fe200078efcffULL,
0x0000007200737306ULL, 0x0002a20000205400ULL, 0x000000797e00720bULL, 0x008fe40003f1d000ULL,
0x000000016a6a3812ULL, 0x000fe400078efcffULL, 0x00000069bb08723eULL, 0x000fc400000010ffULL,
0x0000006a0909723eULL, 0x000fe200000010ffULL, 0x0000006d006e7306ULL, 0x000fe20000209400ULL,
0x0000007200727245ULL, 0x002fca000020d400ULL, 0x00000001bfbf0812ULL, 0x000fe200078efcffULL,
0x000000081c08723cULL, 0x000f620000041858ULL, 0x0000006d00717306ULL, 0x0002e20000205400ULL,
0x000000737400720bULL, 0x004fce0003fbd000ULL, 0x000000ae001a7306ULL, 0x000fe20000209400ULL,
0x0000006d006d7245ULL, 0x002fca000020d400ULL, 0x0000000172725812ULL, 0x000fe400078efcffULL,
0x000000ae001b7306ULL, 0x000e620000205400ULL, 0x000000716e00720bULL, 0x008fce0003f1d000ULL,
0x000000ac007a7306ULL, 0x000fec0000209400ULL, 0x000000016d6d0812ULL, 0x000fe400078efcffULL,
0x000000ac00127306ULL, 0x0004e20000205400ULL, 0x0000001b1a00720bULL, 0x002fe40003f7d000ULL,
0x000000181c18723cULL, 0x000b6a0000041820ULL, 0x000000a8000e7306ULL, 0x000fe20000209400ULL,
0x000000ac00ac7245ULL, 0x004fca000020d400ULL, 0x0000000105053812ULL, 0x000fe400078efcffULL,
0x000000a800077306ULL, 0x000e620000205400ULL, 0x000000127a00720bULL, 0x008fe40003fbd000ULL,
0x000000056d05723eULL, 0x000fe200000010ffULL, 0x000000101c10723cULL, 0x000b680000041850ULL,
0x0000002c006c7306ULL, 0x000fec0000209400ULL, 0x00000001acac5812ULL, 0x000fc400078efcffULL,
0x0000002c006b7306ULL, 0x0004e20000205400ULL, 0x000000070e00720bULL, 0x002fe40003f1d000ULL,
0x0000004bacac723eULL, 0x000fe200000010ffULL, 0x0000000c1c0c723cULL, 0x000b680000041854ULL,
0x0000004800677306ULL, 0x000fe20000209400ULL, 0x0000002c002c7245ULL, 0x004fca000020d400ULL,
0x00000001adad0812ULL, 0x000fe400078efcffULL, 0x0000004800687306ULL, 0x0002a20000205400ULL,
0x0000006b6c00720bULL, 0x008fe40003f7d000ULL, 0x00000066adad723eULL, 0x000fca00000010ffULL,
0x0000009c00047306ULL, 0x000fe20000209400ULL, 0x0000004800487245ULL, 0x002fe2000020d400ULL,
0x000000ac1c60723cULL, 0x000b680000041860ULL, 0x000000012c2c3812ULL, 0x000fe400078efcffULL,
0x0000009c00067306ULL, 0x0002e20000205400ULL, 0x000000686700720bULL, 0x004fce0003fbd000ULL,
0x0000009b00207306ULL, 0x020fe20000209400ULL, 0x0000009c009c7245ULL, 0x002fca000020d400ULL,
0x0000000148485812ULL, 0x000fe400078efcffULL, 0x0000009b00217306ULL, 0x000e620000205400ULL,
0x000000060400720bULL, 0x008fe40003fdd000ULL, 0x000000bf7204723eULL, 0x000fce00000010ffULL,
0x000000041c04723cULL, 0x000b68000004185cULL, 0x000000019c9c6812ULL, 0x000fe400078efcffULL,
0x000000212000720bULL, 0x002fe40003f1d000ULL, 0x0000009c2c9c723eULL, 0x000fd600000010ffULL,
0x000000019d9d0812ULL, 0x000fc800078efcffULL, 0x0000009d489d723eULL, 0x000fce00000010ffULL,
0x0000009c1c1c723cULL, 0x000b62000004183cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff3c7f8cULL, 0x020e62000c80043fULL, 0x000000ffff3e7224ULL, 0x000fce00078e00ffULL,
0x0000000000207805ULL, 0x000fc40000015200ULL, 0x0106bc00ff227984ULL, 0x000ea40000000800ULL,
0x8000000022ff7812ULL, 0x006fe4000780483dULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000227805ULL, 0x000fcc0000015200ULL, 0x00000022202c7210ULL, 0x000fca0007f1e1ffULL,
0x0000000123237824ULL, 0x000fe200000e0e21ULL, 0x003d09002c00780cULL, 0x000fc80003f06070ULL,
0x000000ff2300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402c00780cULL, 0x000fc80003f06070ULL, 0x000000ff2300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff227819ULL, 0x000fc80000011423ULL,
0x0000002c22227211ULL, 0x000fca00078110ffULL, 0x000000ffff237224ULL, 0x000fca00000e0623ULL,
0x0000000222227819ULL, 0x000fc80000001223ULL, 0x000000220000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106bc00ff227984ULL, 0x000e640000000800ULL,
0x8000000022ff7812ULL, 0x002fe4000780483dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000046000009947ULL, 0x000fea0003800000ULL, 0x0000000127227824ULL, 0x000fe200078e0236ULL,
0x0000008041217810ULL, 0x000fe40007ffe0ffULL, 0x00000002362c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000122207824ULL, 0x100fe200078e0203ULL, 0x0000004000487811ULL, 0x000fe200078e38ffULL,
0x00000010224c7824ULL, 0x000fe200078e00ffULL, 0x00000004364e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000127237824ULL, 0x000fe200078e022cULL, 0x000000f02e4b7812ULL, 0x000fe200078ec0ffULL,
0x00000001223d7824ULL, 0x000fe200078e0248ULL, 0xfffffff04c4c7812ULL, 0x000fe200078ee220ULL,
0x00000001233c7824ULL, 0x040fe200078e0203ULL, 0x0000002124207217ULL, 0x000fe20007800000ULL,
0x00000010234d7824ULL, 0x000fe200078e00ffULL, 0x000000493d3d7210ULL, 0x080fe20007f1e0ffULL,
0x00000001233f7824ULL, 0x000fe200078e0248ULL, 0x0000000636507810ULL, 0x000fe20007ffe0ffULL,
0x0000000120207824ULL, 0x000fe200078e0a21ULL, 0xfffffff04d4d7812ULL, 0x000fe200078ee23cULL,
0x00000001273e7824ULL, 0x000fe200078e024eULL, 0x000000493f3f7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff227224ULL, 0x000fe200000e06ffULL, 0x0000002027207217ULL, 0x000fe20007800000ULL,
0x000000013e3c7824ULL, 0x040fe200078e0203ULL, 0x00005e003d217a11ULL, 0x040fe200078040ffULL,
0x000000103e4f7824ULL, 0x000fe200078e00ffULL, 0x0000c0004c4c7811ULL, 0x000fe200078e20ffULL,
0x0000000120237824ULL, 0x000fe200078e0a27ULL, 0x00005f003d3d7a11ULL, 0x000fe200000f4422ULL,
0x000000ffff207224ULL, 0x000fe200018e06ffULL, 0xfffffff04f4f7812ULL, 0x000fe200078ee23cULL,
0x000000013e3e7824ULL, 0x000fe200078e0248ULL, 0x00005e003f3c7a11ULL, 0x000fe200078640ffULL,
0x0000000127517824ULL, 0x000fe200078e0250ULL, 0x000000233600720cULL, 0x000fc40003f86070ULL,
0x00005f003f3f7a11ULL, 0x000fe200018f4420ULL, 0x0000000151487824ULL, 0x000fe200078e0248ULL,
0x000000493e3e7210ULL, 0x000fe40007fbe0ffULL, 0x0000004b21207210ULL, 0x000fe40007f7e0ffULL,
0x000000232c00720cULL, 0x080fe20003f06070ULL, 0x000000ffff2c7224ULL, 0x000fe200028e06ffULL,
0x00005e003e227a11ULL, 0x000fe200078a40ffULL, 0x000000ffff217224ULL, 0x000fe200018e063dULL,
0x000000234e00720cULL, 0x000fc40003f66070ULL, 0x00005f003e3e7a11ULL, 0x000fe400028f442cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000204c7faeULL, 0x0003e2000e101c46ULL,
0x00000049482c7210ULL, 0x000fe20007f9e0ffULL, 0x0000000151487824ULL, 0x040fe200078e0203ULL,
0x0000004b22227210ULL, 0x000fe20007fde0ffULL, 0x0000001051517824ULL, 0x000fe200078e00ffULL,
0x0000c0004d4d7811ULL, 0x000fe200078e20ffULL, 0x000000ffff3d7224ULL, 0x000fe200020e06ffULL,
0x0000c0004f4f7811ULL, 0x000fe400078e20ffULL, 0xfffffff051487812ULL, 0x000fc400078ee248ULL,
0x0000004b3c207210ULL, 0x002fe40007fbe0ffULL, 0x00005e002c3c7a11ULL, 0x000fe400078840ffULL,
0x0000c00048487811ULL, 0x000fe200078e20ffULL, 0x000000ffff217224ULL, 0x000fe200028e063fULL,
0x000000235000720cULL, 0x000fe20003fa6070ULL, 0x000000ffff237224ULL, 0x000fe200030e063eULL,
0x00005f002c2c7a11ULL, 0x000fe400020f443dULL, 0x0000004b3c3c7210ULL, 0x000fe20007f9e0ffULL,
0x00000000204d7faeULL, 0x0003e8000c101c46ULL, 0x000000ffff3d7224ULL, 0x000fe200020e062cULL,
0x00000000224f7faeULL, 0x0003e8000d901c46ULL, 0x000000003c487faeULL, 0x0003e2000e901c46ULL,
0x0000039000007947ULL, 0x000fea0003800000ULL, 0x0000004000217811ULL, 0x000fe200078e38ffULL,
0x0000000127207824ULL, 0x000fe200078e0236ULL, 0x000000f02e4c7812ULL, 0x000fc600078ec0ffULL,
0x0000000120237824ULL, 0x040fe200078e0203ULL, 0x00000002202c7810ULL, 0x040fe20007ffe0ffULL,
0x00000010204d7824ULL, 0x040fe200078e00ffULL, 0x00000004203c7810ULL, 0x040fe20007ffe0ffULL,
0x0000000120227824ULL, 0x140fe200078e0221ULL, 0x0000000620207810ULL, 0x000fe20007ffe0ffULL,
0x000000012c487824ULL, 0x040fe200078e0221ULL, 0xfffffff04d4d7812ULL, 0x000fe200078ee223ULL,
0x000000012c237824ULL, 0x000fe200078e0203ULL, 0x0000004922227210ULL, 0x000fe20007f1e0ffULL,
0x000000102c4e7824ULL, 0x000fe200078e00ffULL, 0x0000c0004d4d7811ULL, 0x000fe200078e20ffULL,
0x000000013c2c7824ULL, 0x000fc400078e0221ULL, 0x00000001203d7824ULL, 0x000fe200078e0221ULL,
0xfffffff04e4e7812ULL, 0x000fe200078ee223ULL, 0x000000013c217824ULL, 0x100fe200078e0203ULL,
0x000000492c237210ULL, 0x080fe20007f7e0ffULL, 0x000000103c4f7824ULL, 0x000fe200078e00ffULL,
0x000000493d2c7210ULL, 0x000fe20007f9e0ffULL, 0x00000001203c7824ULL, 0x000fe200078e0203ULL,
0x0000c0004e4e7811ULL, 0x000fe200078e20ffULL, 0x0000001020507824ULL, 0x000fe200078e00ffULL,
0xfffffff04f4f7812ULL, 0x000fe200078ee221ULL, 0x000000ffff207224ULL, 0x000fe200000e06ffULL,
0x00005e00223e7a11ULL, 0x000fe200078040ffULL, 0x000000ffff217224ULL, 0x000fe200018e06ffULL,
0xfffffff050507812ULL, 0x000fc400078ee23cULL, 0x00005f00224b7a11ULL, 0x000fe200000f4420ULL,
0x000000ffff207224ULL, 0x000fe200020e06ffULL, 0x0000004948487210ULL, 0x000fe40007f1e0ffULL,
0x00005e002c3c7a11ULL, 0x000fe400078840ffULL, 0x00005e0023227a11ULL, 0x000fe200078640ffULL,
0x000000ffff3f7224ULL, 0x000fe200000e06ffULL, 0x00005e00483d7a11ULL, 0x000fe400078040ffULL,
0x0000004c3e3e7210ULL, 0x000fc40007fbe0ffULL, 0x00005f0048487a11ULL, 0x000fe400000f443fULL,
0x00005f002c2c7a11ULL, 0x000fe200020f4420ULL, 0x000000ffff3f7224ULL, 0x000fe200028e064bULL,
0x00005f0023237a11ULL, 0x000fe400018f4421ULL, 0x0000004c3d207210ULL, 0x080fe40007f1e0ffULL,
0x0000004c22227210ULL, 0x080fe20007f7e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e4d7faeULL, 0x0003e2000b901c46ULL, 0x0000004c3c3c7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff217224ULL, 0x000fe200000e0648ULL, 0x0000c0004f4f7811ULL, 0x000fe200078e20ffULL,
0x000000ffff237224ULL, 0x000fe200018e0623ULL, 0x0000c00050507811ULL, 0x000fe200078e20ffULL,
0x000000ffff3d7224ULL, 0x000fe200020e062cULL, 0x00000000204e7faeULL, 0x0003e8000b901c46ULL,
0x00000000224f7faeULL, 0x0003e8000b901c46ULL, 0x000000003c507faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff207f8cULL, 0x000e64000c80043fULL, 0x000000ffff487224ULL, 0x002fc400078e0021ULL,
0x0000000000207805ULL, 0x000fca0000015200ULL, 0x0106b400ff227984ULL, 0x000e640000000800ULL,
0x8000000022ff7812ULL, 0x002fc40007804865ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000227805ULL, 0x000fcc0000015200ULL,
0x00000022202c7210ULL, 0x000fca0007f1e1ffULL, 0x0000000123237824ULL, 0x000fe200000e0e21ULL,
0x003d09002c00780cULL, 0x000fc80003f06070ULL, 0x000000ff2300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402c00780cULL, 0x000fc80003f06070ULL,
0x000000ff2300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff227819ULL, 0x000fc80000011423ULL, 0x0000002c22227211ULL, 0x000fca00078110ffULL,
0x000000ffff237224ULL, 0x000fca00000e0623ULL, 0x0000000222227819ULL, 0x000fc80000001223ULL,
0x000000220000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106b400ff227984ULL, 0x000e640000000800ULL, 0x8000000022ff7812ULL, 0x002fe40007804865ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000014000007945ULL, 0x000fe20003800000ULL,
0x0000012000002947ULL, 0x000fea0003800000ULL, 0x00000033ff20723eULL, 0x000fe400000010ffULL,
0x00000002ff217819ULL, 0x000fe40000011603ULL, 0x0000541020207816ULL, 0x000fe20000000020ULL,
0x0000f6527f007947ULL, 0x000fea000b800000ULL, 0x00001f2120347589ULL, 0x0002a400000e0000ULL,
0x0000000821357810ULL, 0x000fe20007ffe0ffULL, 0x0000f6827f007947ULL, 0x000fea000b800000ULL,
0x00001f3520357589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000010214b7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff4d7224ULL, 0x000fe200078e0020ULL,
0x00011740004c7802ULL, 0x000fc40000000f00ULL, 0x0000fe1000007944ULL, 0x00efea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000018214b7810ULL, 0x004fe20007ffe0ffULL,
0x000000ffff4d7224ULL, 0x000fe200078e0020ULL, 0x00011790004c7802ULL, 0x000fc40000000f00ULL,
0x0000fdc000007944ULL, 0x00afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000b00046937811ULL, 0x000fc400078e20ffULL,
0x00000000444c783bULL, 0x000f280000004200ULL, 0x000000004520783bULL, 0x00ae680000004200ULL,
0x00000000423c783bULL, 0x000ee80000004200ULL, 0x000000004350783bULL, 0x000ea20000004200ULL,
0x000001004da67824ULL, 0x050fe200078e00ffULL, 0x00000018ffa57819ULL, 0x000fe2000001144cULL,
0x000001004ca27824ULL, 0x000fe200078e00ffULL, 0x00000018ffc07819ULL, 0x000fe2000001144dULL,
0x000001004ecb7824ULL, 0x000fe200078e00ffULL, 0x00000018ffa67819ULL, 0x000fe200000114a6ULL,
0x000000a500d27306ULL, 0x000fe20000209400ULL, 0x00000018ffa27819ULL, 0x000fe200000114a2ULL,
0x000100004cd47824ULL, 0x000fe200078e00ffULL, 0x00000018ffcb7819ULL, 0x000fe200000114cbULL,
0x000100004ec57824ULL, 0x000fe200078e00ffULL, 0x00000018ffb47819ULL, 0x000fe2000001144eULL,
0x000100004dce7824ULL, 0x000fe200078e00ffULL, 0x00000018ffd47819ULL, 0x000fe200000114d4ULL,
0x000000a600da7306ULL, 0x000fe20000209400ULL, 0x00000018ffc57819ULL, 0x000fe200000114c5ULL,
0x000001004fc97824ULL, 0x040fe200078e00ffULL, 0x00000018ffce7819ULL, 0x000fe200000114ceULL,
0x0000010020b57824ULL, 0x042fe200078e00ffULL, 0x00000018ffa97819ULL, 0x000fe2000001144fULL,
0x000100004fc67824ULL, 0x000fe200078e00ffULL, 0x00000018ffc97819ULL, 0x000fe200000114c9ULL,
0x000000a600de7306ULL, 0x0003220000205400ULL, 0x00000018ffb57819ULL, 0x000fe200000114b5ULL,
0x0001000020ae7824ULL, 0x000fe200078e00ffULL, 0x00000018ffc67819ULL, 0x000fe200000114c6ULL,
0x0000010021ad7824ULL, 0x040fe200078e00ffULL, 0x00000018ff9a7819ULL, 0x000fe20000011420ULL,
0x0001000021aa7824ULL, 0x000fe200078e00ffULL, 0x00000018ffae7819ULL, 0x000fe200000114aeULL,
0x000000a500bb7306ULL, 0x0004e20000205400ULL, 0x000000a600a67245ULL, 0x002fc4000020d400ULL,
0x00000018ffad7819ULL, 0x000fe400000114adULL, 0x00000018ff947819ULL, 0x000fe40000011421ULL,
0x00000018ffaa7819ULL, 0x000fe200000114aaULL, 0x000000a200dc7306ULL, 0x000fe20000209400ULL,
0x000000deda00720bULL, 0x010fe40003f9d000ULL, 0x000000a500a57245ULL, 0x004fe4000020d400ULL,
0x00000018ff887819ULL, 0x000fc40000011422ULL, 0x00000018ff877819ULL, 0x000fe20000011423ULL,
0x000000a200dd7306ULL, 0x0002a20000205400ULL, 0x000000bbd200720bULL, 0x008fe40003f7d000ULL,
0x00000018ff8c7819ULL, 0x000fe4000001143cULL, 0x00000018ff7b7819ULL, 0x000fe4000001143dULL,
0x00000001a6a64812ULL, 0x000fe200078efcffULL, 0x000000cb00d67306ULL, 0x000fe20000209400ULL,
0x000000a200a27245ULL, 0x002fc4000020d400ULL, 0x00000018ff737819ULL, 0x000fe4000001143eULL,
0x00000018ff6e7819ULL, 0x000fe4000001143fULL, 0x00000001a5a53812ULL, 0x000fe200078efcffULL,
0x000000cb00d77306ULL, 0x0002e20000205400ULL, 0x000000dddc00720bULL, 0x004fe20003f1d000ULL,
0x000001003edd7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5f7819ULL, 0x000fe20000011450ULL,
0x000001003ddc7824ULL, 0x000fe200078e00ffULL, 0x00000018ff587819ULL, 0x000fc40000011451ULL,
0x00000018ffdd7819ULL, 0x000fe200000114ddULL, 0x000000c000c47306ULL, 0x000fe20000209400ULL,
0x000000cb00cb7245ULL, 0x002fe4000020d400ULL, 0x00000018ff4b7819ULL, 0x000fe40000011452ULL,
0x00000018ff2c7819ULL, 0x000fe40000011453ULL, 0x00000001a2a20812ULL, 0x000fe200078efcffULL,
0x000000c000c37306ULL, 0x0002a20000205400ULL, 0x000000d7d600720bULL, 0x008fce0003f9d000ULL,
0x0000004c009b7306ULL, 0x000fe20000009400ULL, 0x000000c000c07245ULL, 0x002fca000020d400ULL,
0x00000001cbcb4812ULL, 0x000fe400078efcffULL, 0x0000004c00db7306ULL, 0x000e620000005400ULL,
0x000000c3c400720bULL, 0x004fce0003f7d000ULL, 0x0000004d00a47306ULL, 0x000fec0000009400ULL,
0x00000001c0c03812ULL, 0x000fe400078efcffULL, 0x0000004d00a37306ULL, 0x000ea20000005400ULL,
0x000000db9b00720bULL, 0x002fe20003fdd000ULL, 0x000100003cdb7824ULL, 0x000fc400078e00ffULL,
0x000100003f9b7824ULL, 0x000fc800078e00ffULL, 0x000000d400d97306ULL, 0x000fe20000209400ULL,
0x00000018ff9b7819ULL, 0x000fce000001149bULL, 0x000000d400d87306ULL, 0x000e620000205400ULL,
0x000000a3a400720bULL, 0x004fe40003f1d000ULL, 0x000000d400a37245ULL, 0x000fe4000020d400ULL,
0x00000018ffa47819ULL, 0x000fc600000114dbULL, 0x000000c500cd7306ULL, 0x000ff00000209400ULL,
0x000000c500d17306ULL, 0x0004e20000205400ULL, 0x000000d8d900720bULL, 0x002fce0003fbd000ULL,
0x000000b400bc7306ULL, 0x000fe20000209400ULL, 0x000000c500c57245ULL, 0x004fca000020d400ULL,
0x00000001a3a35812ULL, 0x000fe400078efcffULL, 0x000000b400bd7306ULL, 0x0002a20000205400ULL,
0x000000d1cd00720bULL, 0x008fce0003f9d000ULL, 0x0000004c00897306ULL, 0x000722000000d400ULL,
0x000000b400b47245ULL, 0x002fca000020d400ULL, 0x00000001c5c54812ULL, 0x000fe400078efcffULL,
0x0000004d007a7306ULL, 0x000262000000d400ULL, 0x000000bdbc00720bULL, 0x004fe20003f7d000ULL,
0x00010000224c7824ULL, 0x008fe400078e00ffULL, 0x0001000050bd7824ULL, 0x000fc600078e00ffULL,
0x00000018ff4c7819ULL, 0x000fe2000001144cULL, 0x0000004e00c17306ULL, 0x000fe20000009400ULL,
0x0000000189896812ULL, 0x010fe200078efcffULL, 0x00010000234d7824ULL, 0x002fe200078e00ffULL,
0x00000018ffbd7819ULL, 0x000fc600000114bdULL, 0x00000001b4b43812ULL, 0x000fe400078efcffULL,
0x0000004e00c27306ULL, 0x000e620000005400ULL, 0x000000017a7a0812ULL, 0x000fe400078efcffULL,
0x00000018ff4d7819ULL, 0x000fca000001144dULL, 0x000000ce00df7306ULL, 0x000ff00000209400ULL,
0x000000ce00e07306ULL, 0x0004e20000205400ULL, 0x000000c2c100720bULL, 0x002fe40003fbd000ULL,
0x00000018ffc27819ULL, 0x000fca00000114dcULL, 0x000000c900d37306ULL, 0x000fe20000209400ULL,
0x000000ce00ce7245ULL, 0x004fce000020d400ULL, 0x000000c900d57306ULL, 0x0002a20000205400ULL,
0x000000e0df00720bULL, 0x008fce0003fdd000ULL, 0x000000a900af7306ULL, 0x000fe20000209400ULL,
0x000000c900c97245ULL, 0x002fca000020d400ULL, 0x00000001cece6812ULL, 0x000fe400078efcffULL,
0x000000a900b07306ULL, 0x0002e20000205400ULL, 0x000000d5d300720bULL, 0x004fce0003f1d000ULL,
0x000000b500c77306ULL, 0x000fe20000209400ULL, 0x000000a900a97245ULL, 0x002fca000020d400ULL,
0x00000001c9c90812ULL, 0x000fe400078efcffULL, 0x000000b500c87306ULL, 0x0002a20000205400ULL,
0x000000b0af00720bULL, 0x008fe20003f9d000ULL, 0x0001000051af7824ULL, 0x000fca00078e00ffULL,
0x00000018ffaf7819ULL, 0x000fe200000114afULL, 0x0000004e00767306ULL, 0x000722000000d400ULL,
0x000000b500b57245ULL, 0x002fca000020d400ULL, 0x00000001a9a94812ULL, 0x000fe400078efcffULL,
0x0000004f00bf7306ULL, 0x000fe20000009400ULL, 0x000000c8c700720bULL, 0x004fe20003f7d000ULL,
0x000001003c4e7824ULL, 0x008fca00078e00ffULL, 0x00000018ff4e7819ULL, 0x000fe2000001144eULL,
0x0000004f00be7306ULL, 0x000e620000005400ULL, 0x0000000176765812ULL, 0x010fc800078efcffULL,
0x00000076cb76723eULL, 0x000fe400000010ffULL, 0x00000001b5b53812ULL, 0x000fe200078efcffULL,
0x0000002000b87306ULL, 0x000ff00000009400ULL, 0x0000002000b77306ULL, 0x000ea20000005400ULL,
0x000000bebf00720bULL, 0x002fe20003fdd000ULL, 0x0000010051bf7824ULL, 0x000fca00078e00ffULL,
0x00000018ffbf7819ULL, 0x000fe200000114bfULL, 0x000000c600d07306ULL, 0x000ff00000209400ULL,
0x000000c600cf7306ULL, 0x0002e20000205400ULL, 0x000000b7b800720bULL, 0x004fce0003f1d000ULL,
0x0000009a00a07306ULL, 0x000fe20000209400ULL, 0x000000c600c67245ULL, 0x002fce000020d400ULL,
0x0000009a00a17306ULL, 0x0002a20000205400ULL, 0x000000cfd000720bULL, 0x008fce0003fbd000ULL,
0x000000ae00b17306ULL, 0x000fe20000209400ULL, 0x0000009a009a7245ULL, 0x002fca000020d400ULL,
0x00000001c6c65812ULL, 0x000fe400078efcffULL, 0x000000ae00b67306ULL, 0x0002e20000205400ULL,
0x000000a1a000720bULL, 0x004fe40003f9d000ULL, 0x000000c6a9a9723eULL, 0x000fca00000010ffULL,
0x0000002100b97306ULL, 0x000fe20000009400ULL, 0x000000ae00ae7245ULL, 0x002fca000020d400ULL,
0x000000019a9a4812ULL, 0x000fe400078efcffULL, 0x0000002100ba7306ULL, 0x000fe20000005400ULL,
0x000000b6b100720bULL, 0x008fce0003f7d000ULL, 0x0000002100717306ULL, 0x0003ec000000d400ULL,
0x00000001aeae3812ULL, 0x000fe400078efcffULL, 0x0000004f00747306ULL, 0x000ea2000000d400ULL,
0x0000010022217824ULL, 0x002fe200078e00ffULL, 0x000000ae9a9a723eULL, 0x000fc800000010ffULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x0000002000727306ULL, 0x0002f0000000d400ULL,
0x00000022009d7306ULL, 0x000fe20000009400ULL, 0x0000010023207824ULL, 0x002fe200078e00ffULL,
0x0000000174746812ULL, 0x004fc400078efcffULL, 0x000000bab900720bULL, 0x000fe20003fdd000ULL,
0x0000010050ba7824ULL, 0x000fe200078e00ffULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x00000022009c7306ULL, 0x000e620000005400ULL, 0x0000000172720812ULL, 0x008fe400078efcffULL,
0x00000018ffba7819ULL, 0x000fca00000114baULL, 0x000000ad00ca7306ULL, 0x000fe20000209400ULL,
0x0000000171716812ULL, 0x000fce00078efcffULL, 0x000000ad00cc7306ULL, 0x0004e20000205400ULL,
0x0000009c9d00720bULL, 0x002fce0003f1d000ULL, 0x0000002300977306ULL, 0x000fe20000009400ULL,
0x000000ad00ad7245ULL, 0x004fce000020d400ULL, 0x0000002300917306ULL, 0x000e620000005400ULL,
0x000000ccca00720bULL, 0x008fce0003fbd000ULL, 0x0000002100ab7306ULL, 0x000fec0000209400ULL,
0x00000001adad5812ULL, 0x000fe400078efcffULL, 0x0000002100ac7306ULL, 0x000ea20000205400ULL,
0x000000919700720bULL, 0x002fe40003f9d000ULL, 0x0000002100917245ULL, 0x000fc4000020d400ULL,
0x00000071adad723eULL, 0x000fc600000010ffULL, 0x00000022006b7306ULL, 0x000e70000000d400ULL,
0x0000002300687306ULL, 0x000ee2000000d400ULL, 0x000000acab00720bULL, 0x004fe40003f7d000ULL,
0x00000072b5ac723eULL, 0x000fca00000010ffULL, 0x0000009400987306ULL, 0x000fe20000209400ULL,
0x000000016b6b0812ULL, 0x002fca00078efcffULL, 0x0000000191913812ULL, 0x000fe400078efcffULL,
0x0000009400997306ULL, 0x0002a20000205400ULL, 0x0000000168684812ULL, 0x008fce00078efcffULL,
0x000000aa00b27306ULL, 0x000fe20000209400ULL, 0x0000009400947245ULL, 0x002fce000020d400ULL,
0x000000aa00b37306ULL, 0x0002e20000205400ULL, 0x000000999800720bULL, 0x004fce0003fdd000ULL,
0x0000004c00227306ULL, 0x000fe20000209400ULL, 0x000000aa00aa7245ULL, 0x002fca000020d400ULL,
0x0000000194946812ULL, 0x000fe400078efcffULL, 0x0000004c00237306ULL, 0x000e620000205400ULL,
0x000000b3b200720bULL, 0x008fce0003fbd000ULL, 0x0000004e004f7306ULL, 0x000fec0000209400ULL,
0x00000001aaaa5812ULL, 0x000fe400078efcffULL, 0x0000004e00bb7306ULL, 0x000ea20000205400ULL,
0x000000232200720bULL, 0x002fce0003f1d000ULL, 0x0000008700957306ULL, 0x000ff00000209400ULL,
0x0000008700927306ULL, 0x0002e20000205400ULL, 0x000000bb4f00720bULL, 0x004fe40003f9d000ULL,
0x000000cec04f723eULL, 0x000fca00000010ffULL, 0x0000003c007e7306ULL, 0x000fe20000009400ULL,
0x0000008700877245ULL, 0x002fce000020d400ULL, 0x0000003c007c7306ULL, 0x000e620000005400ULL,
0x000000929500720bULL, 0x008fe40003f7d000ULL, 0x0000004c00927245ULL, 0x000fe4000020d400ULL,
0x00000089a24c723eULL, 0x000fe400000010ffULL, 0x0000000192920812ULL, 0x000fe200078efcffULL,
0x0000008800967306ULL, 0x000fec0000209400ULL, 0x0000000187873812ULL, 0x000fc400078efcffULL,
0x0000008800907306ULL, 0x0004e20000205400ULL, 0x0000007c7e00720bULL, 0x002fe40003f1d000ULL,
0x0000004e007e7245ULL, 0x000fe4000020d400ULL, 0x0000004d007c7245ULL, 0x000fe4000020d400ULL,
0x000000017e7e4812ULL, 0x000fe200078efcffULL, 0x0000002000a77306ULL, 0x000fe20000209400ULL,
0x0000008800887245ULL, 0x004fe4000020d400ULL, 0x000000a3a54e723eULL, 0x000fca00000010ffULL,
0x0000002000a87306ULL, 0x0002a20000205400ULL, 0x000000909600720bULL, 0x008fe40003fdd000ULL,
0x0000002000907245ULL, 0x000fca000020d400ULL, 0x0000003d008e7306ULL, 0x000fe20000009400ULL,
0x000000009320783bULL, 0x002e6a0000000200ULL, 0x0000000188886812ULL, 0x000fe400078efcffULL,
0x0000003d008f7306ULL, 0x000ee20000005400ULL, 0x000000a8a700720bULL, 0x004fe40003fbd000ULL,
0x000000c5b4a8723eULL, 0x000fca00000010ffULL, 0x0000004d009e7306ULL, 0x000fec0000209400ULL,
0x0000000190905812ULL, 0x000fe400078efcffULL, 0x0000004d009f7306ULL, 0x0005220000205400ULL,
0x0000008f8e00720bULL, 0x008fce0003f9d000ULL, 0x000000a400d27306ULL, 0x000fe20000209400ULL,
0x0000007aa64d723eULL, 0x004fce00000010ffULL, 0x000000a400c17306ULL, 0x0004e20000205400ULL,
0x0000009f9e00720bULL, 0x010fe20003fbd000ULL, 0x000000342020a231ULL, 0x082fe400003400ffULL,
0x000000342222a231ULL, 0x000fe400003400ffULL, 0x000000352121a231ULL, 0x080fe400003400ffULL,
0x0000003c00677306ULL, 0x000322000000d400ULL, 0x000000a400a47245ULL, 0x004fe2000020d400ULL,
0x000000352323a231ULL, 0x000fc800003400ffULL, 0x000000017c7c5812ULL, 0x000fe400078efcffULL,
0x0000003e008d7306ULL, 0x000fe20000009400ULL, 0x000001003f3c7824ULL, 0x002fe200078e00ffULL,
0x000000c1d200720bULL, 0x008fe20003fdd000ULL, 0x0000004c2018723cULL, 0x000be60000041818ULL,
0x00000018ff9c7819ULL, 0x000fe4000001143cULL, 0x0000003e00867306ULL, 0x000e620000005400ULL,
0x0000b000473c7811ULL, 0x000fc400078e20ffULL, 0x0000000167670812ULL, 0x010fe200078efcffULL,
0x0000004e2014723cULL, 0x040b640000041814ULL, 0x0000006b914c723eULL, 0x020fe400000010ffULL,
0x00000001a4a46812ULL, 0x000fe200078efcffULL, 0x0000003d00647306ULL, 0x0004e2000000d400ULL,
0x00000068904d723eULL, 0x000fe400000010ffULL, 0x00000092884e723eULL, 0x000fe200000010ffULL,
0x000000a8200c723cULL, 0x000fe2000004180cULL, 0x0000007c874f723eULL, 0x000fc400000010ffULL,
0x000000677e7e723eULL, 0x000fe200000010ffULL, 0x000000dd00b97306ULL, 0x000fe20000209400ULL,
0x000100003d3d7824ULL, 0x004fe200078e00ffULL, 0x000000868d00720bULL, 0x002fe40003f1d000ULL,
0x0000004c2060723cULL, 0x000fe40000041860ULL, 0x00000018ffb77819ULL, 0x000fe4000001143dULL,
0x000000dd00a07306ULL, 0x0002a20000205400ULL, 0x0000000164644812ULL, 0x008fc600078efcffULL,
0x000000ac2008723cULL, 0x000fe80000041808ULL, 0x0000003e005e7306ULL, 0x000722000000d400ULL,
0x000000dd00dd7245ULL, 0x002fc6000020d400ULL, 0x0000004e204c723cULL, 0x000be8000004181cULL,
0x0000003f008b7306ULL, 0x000fe20000009400ULL, 0x000100003e3e7824ULL, 0x008fe200078e00ffULL,
0x000000a0b900720bULL, 0x004fc80003f9d000ULL, 0x00000018ff977819ULL, 0x000fe4000001143eULL,
0x0000003f00827306ULL, 0x000e620000005400ULL, 0x000000015e5e0812ULL, 0x010fcc00078efcffULL,
0x00000001dddd4812ULL, 0x000fe200078efcffULL, 0x0000008c00817306ULL, 0x000ff00000209400ULL,
0x0000008c00837306ULL, 0x0004e20000205400ULL, 0x000000828b00720bULL, 0x002fce0003fdd000ULL,
0x0000003f005d7306ULL, 0x000322000000d400ULL, 0x0000008c008c7245ULL, 0x004fce000020d400ULL,
0x0000007300777306ULL, 0x000fe20000209400ULL, 0x000000003c3c783bULL, 0x002e620000000200ULL,
0x000000838100720bULL, 0x008fcc0003fbd000ULL, 0x0000007300757306ULL, 0x0004e20000205400ULL,
0x000000015d5d6812ULL, 0x010fcc00078efcffULL, 0x000000018c8c5812ULL, 0x000fe200078efcffULL,
0x0000009c009d7306ULL, 0x000fe20000209400ULL, 0x0000007300737245ULL, 0x004fe4000020d400ULL,
0x000000a48c1c723eULL, 0x020fca00000010ffULL, 0x0000009c00987306ULL, 0x0005220000205400ULL,
0x000000757700720bULL, 0x008fe40003f1d000ULL, 0x00000074c977723eULL, 0x000fca00000010ffULL,
0x0000007b007f7306ULL, 0x000fe20000209400ULL, 0x0000009c009c7245ULL, 0x004fe2000020d400ULL,
0x000000762010723cULL, 0x000f680000041810ULL, 0x0000000173730812ULL, 0x000fe400078efcffULL,
0x0000007b00847306ULL, 0x0004e20000205400ULL, 0x000000989d00720bULL, 0x010fe20003f9d000ULL,
0x000000343c3ca231ULL, 0x002fc400003400ffULL, 0x000000343e3ea231ULL, 0x000fe400003400ffULL,
0x000000353d3da231ULL, 0x080fe400003400ffULL, 0x000000ba00817306ULL, 0x000fe20000209400ULL,
0x0000007b007b7245ULL, 0x004fe2000020d400ULL, 0x000000353f3fa231ULL, 0x000fc800003400ffULL,
0x000000019c9c4812ULL, 0x000fe400078efcffULL, 0x000000ba00827306ULL, 0x0002a20000205400ULL,
0x000000847f00720bULL, 0x008fce0003fbd000ULL, 0x000000c200be7306ULL, 0x000fe20000209400ULL,
0x000000ba00ba7245ULL, 0x002fca000020d400ULL, 0x000000017b7b5812ULL, 0x000fe400078efcffULL,
0x000000c200bc7306ULL, 0x0002e20000205400ULL, 0x000000828100720bULL, 0x004fce0003f1d000ULL,
0x0000009700967306ULL, 0x000fe20000209400ULL, 0x000000c200c27245ULL, 0x002fca000020d400ULL,
0x00000001baba0812ULL, 0x000fe400078efcffULL, 0x0000009700937306ULL, 0x0002a20000205400ULL,
0x000000bcbe00720bULL, 0x008fce0003f7d000ULL, 0x00000050007d7306ULL, 0x000fe20000009400ULL,
0x0000009700977245ULL, 0x002fca000020d400ULL, 0x00000001c2c23812ULL, 0x000fe400078efcffULL,
0x0000005000807306ULL, 0x000e620000005400ULL, 0x000000939600720bULL, 0x004fce0003f9d000ULL,
0x0000005200797306ULL, 0x000fec0000009400ULL, 0x0000000197974812ULL, 0x000fe400078efcffULL,
0x0000005200787306ULL, 0x000ea20000005400ULL, 0x000000807d00720bULL, 0x002fce0003f5d000ULL,
0x000000bf007f7306ULL, 0x000ff00000209400ULL, 0x000000bf00837306ULL, 0x0002e20000205400ULL,
0x000000787900720bULL, 0x004fce0003fbd000ULL, 0x0000006e00707306ULL, 0x000fe20000209400ULL,
0x000000bf00bf7245ULL, 0x002fce000020d400ULL, 0x0000006e006f7306ULL, 0x0002a20000205400ULL,
0x000000837f00720bULL, 0x008fe40003f1d000ULL, 0x00000064c27f723eULL, 0x000fca00000010ffULL,
0x000000b700b87306ULL, 0x000fe20000209400ULL, 0x0000006e006e7245ULL, 0x002fca000020d400ULL,
0x00000001bfbf0812ULL, 0x000fe400078efcffULL, 0x000000b700b07306ULL, 0x0002e20000205400ULL,
0x0000006f7000720bULL, 0x004fce0003f9d000ULL, 0x000000bd007d7306ULL, 0x000fe20000209400ULL,
0x000000b700b77245ULL, 0x002fca000020d400ULL, 0x000000016e6e4812ULL, 0x000fe400078efcffULL,
0x000000bd00787306ULL, 0x0002a20000205400ULL, 0x000000b0b800720bULL, 0x008fce0003f7d000ULL,
0x00000051008a7306ULL, 0x000fe20000009400ULL, 0x000000bd00bd7245ULL, 0x002fca000020d400ULL,
0x00000001b7b73812ULL, 0x000fe400078efcffULL, 0x0000005100857306ULL, 0x000e620000005400ULL,
0x000000787d00720bULL, 0x004fe40003f1d000ULL, 0x000000b77b1d723eULL, 0x000fca00000010ffULL,
0x0000005f00697306ULL, 0x000fe40000209400ULL, 0x0000001c3c1c723cULL, 0x000be80000041814ULL,
0x00000001bdbd0812ULL, 0x000fe400078efcffULL, 0x0000005f006a7306ULL, 0x0004e20000205400ULL,
0x000000858a00720bULL, 0x002fe40003f7d000ULL, 0x000000977314723eULL, 0x020fca00000010ffULL,
0x0000005100567306ULL, 0x000322000000d400ULL, 0x0000005f005f7245ULL, 0x004fce000020d400ULL,
0x0000004b005b7306ULL, 0x000fe20000209400ULL, 0x0000010052517824ULL, 0x002fe200078e00ffULL,
0x0000006a6900720bULL, 0x008fc80003f9d000ULL, 0x00000018ff727819ULL, 0x000fe40000011451ULL,
0x0000004b005c7306ULL, 0x0002a20000205400ULL, 0x0000009b00517245ULL, 0x000fe4000020d400ULL,
0x0000000156563812ULL, 0x010fc800078efcffULL, 0x000000015f5f4812ULL, 0x000fe200078efcffULL,
0x0000005000577306ULL, 0x000722000000d400ULL, 0x0000004b004b7245ULL, 0x002fce000020d400ULL,
0x0000005800667306ULL, 0x000fe20000209400ULL, 0x0000010053507824ULL, 0x008fe200078e00ffULL,
0x0000005c5b00720bULL, 0x004fc80003f1d000ULL, 0x00000018ff707819ULL, 0x000fe40000011450ULL,
0x0000005800657306ULL, 0x0002a20000205400ULL, 0x0000000157572812ULL, 0x010fe400078efcffULL,
0x0000007000737245ULL, 0x000fc8000020d400ULL, 0x000000014b4b0812ULL, 0x000fe200078efcffULL,
0x0000009b00957306ULL, 0x000fe20000209400ULL, 0x0000005800587245ULL, 0x002fce000020d400ULL,
0x0000009b00997306ULL, 0x0002e20000205400ULL, 0x000000656600720bULL, 0x004fce0003f5d000ULL,
0x000000af00757306ULL, 0x000fe20000209400ULL, 0x000000aa949b723eULL, 0x002fca00000010ffULL,
0x0000000158582812ULL, 0x000fe400078efcffULL, 0x000000af00747306ULL, 0x0002a20000205400ULL,
0x0000009a2004723cULL, 0x000f620000041804ULL, 0x000000999500720bULL, 0x008fcc0003fdd000ULL,
0x0000007200717306ULL, 0x000fe20000209400ULL, 0x0000007e3c20723cULL, 0x000b620000041818ULL,
0x000000af00af7245ULL, 0x002fca000020d400ULL, 0x0000000151516812ULL, 0x000fe200078efcffULL,
0x00000072006f7306ULL, 0x0002e20000205400ULL, 0x0000005d9c19723eULL, 0x020fe400000010ffULL,
0x000000747500720bULL, 0x004fe40003f7d000ULL, 0x0000005edd18723eULL, 0x000fe400000010ffULL,
0x000000516e15723eULL, 0x000fe200000010ffULL, 0x0000005200557306ULL, 0x000522000000d400ULL,
0x0000007200727245ULL, 0x002fc6000020d400ULL, 0x000000183c18723cULL, 0x040b680000041810ULL,
0x00000053006d7306ULL, 0x000fe20000009400ULL, 0x0001000052527824ULL, 0x004fe200078e00ffULL,
0x0000006f7100720bULL, 0x008fe40003f9d000ULL, 0x00000001afaf3812ULL, 0x000fe200078efcffULL,
0x000000143c14723cULL, 0x000b62000004180cULL, 0x00000018ff527819ULL, 0x000fc40000011452ULL,
0x00000053006c7306ULL, 0x000e620000005400ULL, 0x0000000155555812ULL, 0x010fe400078efcffULL,
0x00000057ba10723eULL, 0x020fe400000010ffULL, 0x00000056bf11723eULL, 0x000fe400000010ffULL,
0x0000000172724812ULL, 0x000fe200078efcffULL, 0x0000005300547306ULL, 0x0004e2000000d400ULL,
0x000000bd5f0c723eULL, 0x000fe400000010ffULL, 0x000000af580d723eULL, 0x000fe200000010ffULL,
0x000000103c10723cULL, 0x000b620000041808ULL, 0x000000557272723eULL, 0x000fc600000010ffULL,
0x0000002c00597306ULL, 0x000fe20000209400ULL, 0x0001000053537824ULL, 0x004fe200078e00ffULL,
0x0000006c6d00720bULL, 0x002fe40003fdd000ULL, 0x0000000c3c0c723cULL, 0x000b640000041804ULL,
0x00000018ff537819ULL, 0x000fe40000011453ULL, 0x0000002c005a7306ULL, 0x0002a40000205400ULL,
0x0000005300097245ULL, 0x020fca000020d400ULL, 0x0000000154546812ULL, 0x008fe200078efcffULL,
0x00000070006b7306ULL, 0x000fe20000209400ULL, 0x0000002c002c7245ULL, 0x002fce000020d400ULL,
0x0000007000687306ULL, 0x000e620000205400ULL, 0x0000005a5900720bULL, 0x004fce0003f7d000ULL,
0x0000005200507306ULL, 0x000fec0000209400ULL, 0x000000012c2c3812ULL, 0x000fe400078efcffULL,
0x0000005200647306ULL, 0x0004e20000205400ULL, 0x000000686b00720bULL, 0x002fce0003f5d000ULL,
0x00000053005d7306ULL, 0x000fe20000209400ULL, 0x0000005200527245ULL, 0x004fca000020d400ULL,
0x0000000173732812ULL, 0x000fe400078efcffULL, 0x00000053005b7306ULL, 0x000e620000205400ULL,
0x000000645000720bULL, 0x008fe40003f9d000ULL, 0x000000547373723eULL, 0x000fce00000010ffULL,
0x000000723c04723cULL, 0x000b680000041860ULL, 0x0000000152524812ULL, 0x000fe400078efcffULL,
0x0000005b5d00720bULL, 0x002fe40003fbd000ULL, 0x000000524b08723eULL, 0x000fd600000010ffULL,
0x0000000109095812ULL, 0x000fc800078efcffULL, 0x000000092c09723eULL, 0x000fce00000010ffULL,
0x000000083c08723cULL, 0x000b62000004184cULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff3c7f8cULL, 0x020e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000080412c7810ULL, 0x000fe20007ffe0ffULL,
0x01069800ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff4b7224ULL, 0x002fe400078e003dULL,
0x000000242c00720cULL, 0x000fe40003f06070ULL, 0x000000012d2c7810ULL, 0x000fd60007ffe0ffULL,
0x0000604000000947ULL, 0x000fea0003800000ULL, 0x00000000003c7805ULL, 0x000fc40000015200ULL,
0x0106bc00ff287984ULL, 0x000e640000000800ULL, 0x8000000028ff7812ULL, 0x002fe4000780484bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff4c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003e7805ULL, 0x000fcc0000015200ULL, 0x0000003e3c2c7210ULL, 0x000fca0007f1e1ffULL,
0x000000013f3e7824ULL, 0x000fe200000e0e3dULL, 0x003d09002c00780cULL, 0x000fc80003f06070ULL,
0x000000ff3e00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402c00780cULL, 0x000fc80003f06070ULL, 0x000000ff3e00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff287819ULL, 0x000fc8000001143eULL,
0x0000002c28287211ULL, 0x000fca00078110ffULL, 0x000000ffff2c7224ULL, 0x000fca00000e063eULL,
0x0000000228287819ULL, 0x000fc8000000122cULL, 0x000000280000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000014c4c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106bc00ff287984ULL, 0x000e640000000800ULL,
0x8000000028ff7812ULL, 0x002fe4000780484bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000046000009947ULL, 0x000fea0003800000ULL, 0x000000a041287810ULL, 0x000fe20007ffe0ffULL,
0x00000001273c7824ULL, 0x040fe200078e0236ULL, 0x00000002363f7810ULL, 0x000fe40007ffe0ffULL,
0x00000028242c7217ULL, 0x000fe20007800000ULL, 0x000000013c3d7824ULL, 0x000fe200078e0203ULL,
0x00000004364c7810ULL, 0x040fe20007ffe0ffULL, 0x00000001273e7824ULL, 0x040fe200078e023fULL,
0x0000000636547810ULL, 0x000fe20007ffe0ffULL, 0x000000012c2c7824ULL, 0x000fe200078e0a28ULL,
0x0000006000287811ULL, 0x000fe200078e38ffULL, 0x000000103c517824ULL, 0x000fe200078e00ffULL,
0x000000f02e507812ULL, 0x000fe200078ec0ffULL, 0x00000001274b7824ULL, 0x040fe200078e024cULL,
0x0000002c272c7217ULL, 0x000fe20007800000ULL, 0x000000013e4e7824ULL, 0x040fe200078e0228ULL,
0xfffffff051517812ULL, 0x000fe200078ee23dULL, 0x000000013e3d7824ULL, 0x000fc400078e0203ULL,
0x000000103e527824ULL, 0x000fe200078e00ffULL, 0x000000494e4e7210ULL, 0x080fe20007f3e0ffULL,
0x000000013c4f7824ULL, 0x000fe200078e0228ULL, 0x0000e00051517811ULL, 0x000fe200078e20ffULL,
0x000000014b4d7824ULL, 0x040fe200078e0203ULL, 0xfffffff052527812ULL, 0x000fe200078ee23dULL,
0x000000104b537824ULL, 0x000fe200078e00ffULL, 0x000000494f4f7210ULL, 0x080fe20007f1e0ffULL,
0x00000001273c7824ULL, 0x000fe200078e0254ULL, 0x0000e00052527811ULL, 0x000fe200078e20ffULL,
0x000000014b4b7824ULL, 0x100fe200078e0228ULL, 0xfffffff053537812ULL, 0x000fe200078ee24dULL,
0x000000013c287824ULL, 0x000fe200078e0228ULL, 0x00005e004e4d7a11ULL, 0x000fe200078440ffULL,
0x000000013c3d7824ULL, 0x040fe200078e0203ULL, 0x000000494b4b7210ULL, 0x080fe20007f9e0ffULL,
0x000000103c557824ULL, 0x000fe200078e00ffULL, 0x0000004928287210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff3c7224ULL, 0x000fe200008e06ffULL, 0x0000e00053537811ULL, 0x000fe200078e20ffULL,
0x000000012c2c7824ULL, 0x000fe200078e0a27ULL, 0xfffffff055557812ULL, 0x000fe200078ee23dULL,
0x000000ffff3e7224ULL, 0x000fe200000e06ffULL, 0x00005e004f3d7a11ULL, 0x000fe200078040ffULL,
0x000000ffff497224ULL, 0x000fe200020e06ffULL, 0x00005f004e4e7a11ULL, 0x000fc400010f443cULL,
0x0000002c3600720cULL, 0x000fe40003f46070ULL, 0x00005f004f4f7a11ULL, 0x000fe200000f443eULL,
0x000000ffff3e7224ULL, 0x000fe200018e06ffULL, 0x000000503d3c7210ULL, 0x000fe40007fbe0ffULL,
0x0000002c3f00720cULL, 0x080fe40003f26070ULL, 0x0000002c4c00720cULL, 0x000fe20003f06070ULL,
0x000000ffff3d7224ULL, 0x000fe200028e064fULL, 0x00005e004b3f7a11ULL, 0x000fc400078840ffULL,
0x00005e00284c7a11ULL, 0x000fe400078c40ffULL, 0x0000002c5400720cULL, 0x000fe20003f66070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c517faeULL, 0x0003e2000d101c46ULL,
0x00005f004b2c7a11ULL, 0x000fe400020f4449ULL, 0x00005f0028287a11ULL, 0x000fe400030f443eULL,
0x000000503f3e7210ULL, 0x080fe40007f9e0ffULL, 0x000000504c4c7210ULL, 0x000fc40007fbe0ffULL,
0x0000e00055557811ULL, 0x000fe200078e20ffULL, 0x000000ffff3f7224ULL, 0x000fe200020e062cULL,
0x000000504d3c7210ULL, 0x002fe20007f5e0ffULL, 0x000000ffff4d7224ULL, 0x000fc800028e0628ULL,
0x000000ffff3d7224ULL, 0x000fca00010e064eULL, 0x000000003c527faeULL, 0x0003e8000c901c46ULL,
0x000000003e537faeULL, 0x0003e8000c101c46ULL, 0x000000004c557faeULL, 0x0003e2000d901c46ULL,
0x0000039000007947ULL, 0x000fea0003800000ULL, 0x0000000127287824ULL, 0x000fe200078e0236ULL,
0x00000060002c7811ULL, 0x000fc400078e38ffULL, 0x000000f02e507812ULL, 0x000fe200078ec0ffULL,
0x00000001283c7824ULL, 0x040fe200078e0203ULL, 0x00000002283d7810ULL, 0x040fe20007ffe0ffULL,
0x0000001028517824ULL, 0x000fc800078e00ffULL, 0x000000013d3e7824ULL, 0x000fe200078e0203ULL,
0xfffffff051517812ULL, 0x000fe200078ee23cULL, 0x000000103d527824ULL, 0x000fe400078e00ffULL,
0x00000001283c7824ULL, 0x100fe200078e022cULL, 0x0000e00051517811ULL, 0x000fe200078e20ffULL,
0x000000013d4b7824ULL, 0x000fe200078e022cULL, 0xfffffff052527812ULL, 0x000fe400078ee23eULL,
0x00000004283e7810ULL, 0x040fe40007ffe0ffULL, 0x0000000628287810ULL, 0x000fc40007ffe0ffULL,
0x000000493c3c7210ULL, 0x080fe20007f5e0ffULL, 0x000000013e3f7824ULL, 0x100fe200078e022cULL,
0x000000494b4b7210ULL, 0x080fe20007f1e0ffULL, 0x00000001284c7824ULL, 0x000fe200078e022cULL,
0x00005e003c4e7a11ULL, 0x000fe200078640ffULL, 0x000000013e3d7824ULL, 0x140fe200078e0203ULL,
0x000000493f3f7210ULL, 0x080fe20007f3e0ffULL, 0x000000103e537824ULL, 0x000fe200078e00ffULL,
0x0000e00052527811ULL, 0x000fe200078e20ffULL, 0x000000ffff2c7224ULL, 0x000fe400010e06ffULL,
0x00000001283e7824ULL, 0x040fe200078e0203ULL, 0xfffffff053537812ULL, 0x000fe200078ee23dULL,
0x0000001028547824ULL, 0x000fe200078e00ffULL, 0x000000494c287210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff497224ULL, 0x000fe200000e06ffULL, 0x00005f003c4d7a11ULL, 0x000fe200018f442cULL,
0x000000ffff3c7224ULL, 0x000fe200008e06ffULL, 0xfffffff054547812ULL, 0x000fe200078ee23eULL,
0x000000ffff2c7224ULL, 0x000fe200010e06ffULL, 0x00005e004b3d7a11ULL, 0x000fc400078040ffULL,
0x00005e003f3e7a11ULL, 0x000fe400078240ffULL, 0x00005e00284c7a11ULL, 0x000fe400078440ffULL,
0x000000504e4e7210ULL, 0x080fe40007f7e0ffULL, 0x00005f004b497a11ULL, 0x000fe400000f4449ULL,
0x00005f003f3f7a11ULL, 0x000fe200008f443cULL, 0x000000ffff4f7224ULL, 0x000fe200018e064dULL,
0x000000503d3c7210ULL, 0x000fc40007f1e0ffULL, 0x00005f0028287a11ULL, 0x000fe400010f442cULL,
0x000000503e3e7210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff3d7224ULL, 0x000fe200000e0649ULL,
0x000000504c4c7210ULL, 0x000fe20007f5e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000004e517faeULL, 0x0003e2000b901c46ULL, 0x0000e00053537811ULL, 0x000fe200078e20ffULL,
0x000000ffff3f7224ULL, 0x000fe200008e063fULL, 0x0000e00054547811ULL, 0x000fe200078e20ffULL,
0x000000ffff4d7224ULL, 0x000fe200010e0628ULL, 0x000000003c527faeULL, 0x0003e8000b901c46ULL,
0x000000003e537faeULL, 0x0003e8000b901c46ULL, 0x000000004c547faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x000000022d3c7810ULL, 0x002fc80007ffe0ffULL,
0x000000253c00720cULL, 0x000fe20003f06070ULL, 0xffffffffff287424ULL, 0x000fd800078e00ffULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000000012a3c7824ULL, 0x000fe400078e023cULL,
0x00000004ff3d7424ULL, 0x000fc800078e00ffULL, 0x000060003c3c7625ULL, 0x000fca00078e003dULL,
0x000000063c287981ULL, 0x000324000c1e1900ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff587f8cULL, 0x000ea2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01066800274c7f8cULL, 0x000664000c80043fULL, 0x00000000003c7805ULL, 0x002fc40000015200ULL,
0x01066c00272c7984ULL, 0x000e640000000800ULL, 0x800000002cff7812ULL, 0x002fe4000780484dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff497224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003e7805ULL, 0x000fcc0000015200ULL, 0x0000003e3c3e7210ULL, 0x000fca0007f1e1ffULL,
0x000000013f3f7824ULL, 0x000fe200000e0e3dULL, 0x003d09003e00780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403e00780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff2c7819ULL, 0x000fc8000001143fULL,
0x0000003e2c2c7211ULL, 0x000fca00078110ffULL, 0x000000ffff3e7224ULL, 0x000fca00000e063fULL,
0x000000022c2c7819ULL, 0x000fc8000000123eULL, 0x0000002c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000149497810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01066c00272c7984ULL, 0x000e640000000800ULL,
0x800000002cff7812ULL, 0x002fe4000780484dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x010180002f2c7984ULL, 0x000e680000000800ULL, 0x010380002f3e7984ULL, 0x0006a20000000800ULL,
0x0000004a2c00720bULL, 0x002fe20003f1d000ULL, 0x0000c9e27f007947ULL, 0x000fd8000b800000ULL,
0x00000000003f7806ULL, 0x008fc800000e0100ULL, 0x0000ffff3fff7812ULL, 0x000fe2000780c0ffULL,
0x0000047000007945ULL, 0x000fe20003800000ULL, 0x00000001ff497424ULL, 0x000fd600078e00ffULL,
0x0000044000008947ULL, 0x000fea0003800000ULL, 0x000000030200780cULL, 0x000fe40003f05270ULL,
0x0000004a2c00720bULL, 0x000fe20003f34000ULL, 0x0000c9b27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000307806ULL, 0x000fc400008e0100ULL, 0x0000004a2c3c8209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe80003800000ULL, 0x0105803c2f008388ULL, 0x0003e40000000800ULL,
0x00009910302f7816ULL, 0x002fc800000000ffULL, 0x000000ff2f00720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000004a2c2f7209ULL, 0x000fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff30ff7812ULL, 0x000fc6000780c0ffULL,
0x0000004a2f2f7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b2f2f7820ULL, 0x000fc80000410000ULL,
0x0000002f003c7308ULL, 0x000e640000000800ULL, 0x0000003c29297220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff2f7819ULL, 0x000fe20000011603ULL,
0x0000c8f27f007947ULL, 0x000fea000b800000ULL, 0x00001f2f3c2f7589ULL, 0x0002e400000e0000ULL,
0x0000002f20207220ULL, 0x088fe20000410000ULL, 0x0000002f21217220ULL, 0x080fe20000410000ULL,
0x0000002f1c1c7220ULL, 0x080fe20000410000ULL, 0x0000002f1d1d7220ULL, 0x080fe20000410000ULL,
0x0000002f18187220ULL, 0x080fe20000410000ULL, 0x0000002f19197220ULL, 0x080fe20000410000ULL,
0x0000002f14147220ULL, 0x080fe20000410000ULL, 0x0000002f15157220ULL, 0x080fe20000410000ULL,
0x0000002f10107220ULL, 0x080fe20000410000ULL, 0x0000002f11117220ULL, 0x080fe20000410000ULL,
0x0000002f0c0c7220ULL, 0x080fe20000410000ULL, 0x0000002f0d0d7220ULL, 0x080fe20000410000ULL,
0x0000002f04047220ULL, 0x080fe20000410000ULL, 0x0000002f05057220ULL, 0x080fe20000410000ULL,
0x0000002f08087220ULL, 0x080fe20000410000ULL, 0x0000002f09097220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0030ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008032f7811ULL, 0x000fe200078ff0ffULL,
0x0000c7f27f007947ULL, 0x000fea000b800000ULL, 0x00001f2f3c2f7589ULL, 0x00066400000e0000ULL,
0x0000002f22227220ULL, 0x082fe20000410000ULL, 0x0000002f23237220ULL, 0x080fe20000410000ULL,
0x0000002f1e1e7220ULL, 0x080fe20000410000ULL, 0x0000002f1f1f7220ULL, 0x080fe20000410000ULL,
0x0000002f1a1a7220ULL, 0x080fe20000410000ULL, 0x0000002f1b1b7220ULL, 0x080fe20000410000ULL,
0x0000002f16167220ULL, 0x080fe20000410000ULL, 0x0000002f17177220ULL, 0x080fe20000410000ULL,
0x0000002f12127220ULL, 0x080fe20000410000ULL, 0x0000002f13137220ULL, 0x080fe20000410000ULL,
0x0000002f0e0e7220ULL, 0x080fe20000410000ULL, 0x0000002f0f0f7220ULL, 0x080fe20000410000ULL,
0x0000002f06067220ULL, 0x080fe20000410000ULL, 0x0000002f07077220ULL, 0x080fe20000410000ULL,
0x0000002f0a0a7220ULL, 0x080fe20000410000ULL, 0x0000002f0b0b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000ffff30ff7812ULL, 0x000fe2000780083fULL,
0x00000001ff497424ULL, 0x000fe200078e00ffULL, 0x0000004a2c4a7209ULL, 0x000fd60007810000ULL,
0x8000004a2c2c0221ULL, 0x000fe20000010000ULL, 0x00007610ff490816ULL, 0x000fc60000000049ULL,
0x3fb8aa3b2c2c0820ULL, 0x000fc80000410000ULL, 0x0000002c00330308ULL, 0x000e640000000800ULL,
0x000000333e3e0220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000293e297221ULL, 0x004fc20000010000ULL, 0x00000000003c7805ULL, 0x008fcc0000015200ULL,
0x0106ac00ff2c7984ULL, 0x000e640000000800ULL, 0x800000002cff7812ULL, 0x002fe40007804848ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff307224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003e7805ULL, 0x000fcc0000015200ULL, 0x0000003e3c2f7210ULL, 0x000fca0007f1e1ffULL,
0x000000013f3e7824ULL, 0x000fe200000e0e3dULL, 0x003d09002f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3e00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3e00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff2c7819ULL, 0x000fc8000001143eULL,
0x0000002f2c2c7211ULL, 0x000fca00078110ffULL, 0x000000ffff2f7224ULL, 0x000fca00000e063eULL,
0x000000022c2c7819ULL, 0x000fc8000000122fULL, 0x0000002c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000130307810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106ac00ff2c7984ULL, 0x000e640000000800ULL,
0x800000002cff7812ULL, 0x002fe40007804848ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009910492c7816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff2c00720cULL, 0x000fda0003f25270ULL, 0x0000012000001947ULL, 0x000fea0003800000ULL,
0x00000033ff2c723eULL, 0x000fe400000010ffULL, 0x00000002ff2f7819ULL, 0x000fe40000011603ULL,
0x000054102c2c7816ULL, 0x000fe2000000002cULL, 0x0000c3e27f007947ULL, 0x000fea000b800000ULL,
0x00001f2f2c347589ULL, 0x0002a400000e0000ULL, 0x000000082f357810ULL, 0x000fe20007ffe0ffULL,
0x0000c4127f007947ULL, 0x000fea000b800000ULL, 0x00001f352c357589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000102f4b7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4d7224ULL, 0x000fe200078e002cULL, 0x00014bd0004c7802ULL, 0x000fc40000000f00ULL,
0x0000c98000007944ULL, 0x01efea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000182f4b7810ULL, 0x004fe20007ffe0ffULL, 0x000000ffff4d7224ULL, 0x000fe200078e002cULL,
0x00014c20004c7802ULL, 0x000fc40000000f00ULL, 0x0000c93000007944ULL, 0x01afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000000373c783bULL, 0x000ee80000004200ULL, 0x00000000384c783bULL, 0x000ea80000004200ULL,
0x000000003950783bULL, 0x000e680000004200ULL, 0x000000003a54783bULL, 0x000e620000004200ULL,
0x000100003cc67824ULL, 0x048fe200078e00ffULL, 0x00000018ffa27819ULL, 0x000fe2000001143dULL,
0x000001003cc47824ULL, 0x000fe200078e00ffULL, 0x00000018ffa77819ULL, 0x000fe2000001143cULL,
0x000001003db97824ULL, 0x000fe200078e00ffULL, 0x00000018ffc67819ULL, 0x000fe200000114c6ULL,
0x000000a200a67306ULL, 0x000fe20000209400ULL, 0x00000018ffc47819ULL, 0x000fe200000114c4ULL,
0x000100003eb07824ULL, 0x040fe200078e00ffULL, 0x00000018ffb97819ULL, 0x000fe200000114b9ULL,
0x000001003ea87824ULL, 0x000fe200078e00ffULL, 0x00000018ff997819ULL, 0x000fe2000001143eULL,
0x000001004cab7824ULL, 0x044fe200078e00ffULL, 0x00000018ffb07819ULL, 0x000fe200000114b0ULL,
0x000000c600d57306ULL, 0x000fe20000209400ULL, 0x00000018ffa87819ULL, 0x000fe200000114a8ULL,
0x000001004daa7824ULL, 0x000fe200078e00ffULL, 0x00000018ffab7819ULL, 0x000fe200000114abULL,
0x000001003fa97824ULL, 0x000fe200078e00ffULL, 0x00000018ff987819ULL, 0x000fe2000001143fULL,
0x000100004cba7824ULL, 0x000fe200078e00ffULL, 0x00000018ffaa7819ULL, 0x000fe200000114aaULL,
0x000000c600d47306ULL, 0x0004e20000205400ULL, 0x000100003daf7824ULL, 0x000fe200078e00ffULL,
0x00000018ff917819ULL, 0x000fe2000001144cULL, 0x000100004db27824ULL, 0x000fe200078e00ffULL,
0x00000018ffa97819ULL, 0x000fe200000114a9ULL, 0x000100003fb77824ULL, 0x000fe200078e00ffULL,
0x00000018ffba7819ULL, 0x000fe200000114baULL, 0x0001000051df7824ULL, 0x002fe200078e00ffULL,
0x000000c400dc7306ULL, 0x000fe20000209400ULL, 0x000000c600c67245ULL, 0x004fe2000020d400ULL,
0x0000010052e07824ULL, 0x040fe200078e00ffULL, 0x00000018ffaf7819ULL, 0x000fe200000114afULL,
0x0000010053da7824ULL, 0x040fe200078e00ffULL, 0x00000018ffb27819ULL, 0x000fe200000114b2ULL,
0x0001000053d87824ULL, 0x000fe200078e00ffULL, 0x00000018ffb77819ULL, 0x000fe200000114b7ULL,
0x000000c400dd7306ULL, 0x0002a20000205400ULL, 0x000000d4d500720bULL, 0x008fe20003f9d000ULL,
0x0000010051de7824ULL, 0x000fe200078e00ffULL, 0x00000018ff7f7819ULL, 0x000fe2000001144eULL,
0x0001000052d97824ULL, 0x000fe200078e00ffULL, 0x00000018ff807819ULL, 0x000fc4000001144fULL,
0x00000018ffdf7819ULL, 0x000fe200000114dfULL, 0x000000a200a57306ULL, 0x0006e20000205400ULL,
0x000000c400c47245ULL, 0x002fe4000020d400ULL, 0x00000018ff847819ULL, 0x000fe40000011450ULL,
0x00000018ff8c7819ULL, 0x000fe4000001144dULL, 0x00000001c6c64812ULL, 0x000fe200078efcffULL,
0x000000a700b57306ULL, 0x000fe20000209400ULL, 0x000000dddc00720bULL, 0x004fc40003fdd000ULL,
0x000000a200a27245ULL, 0x008fe4000020d400ULL, 0x00000018ffe07819ULL, 0x000fe400000114e0ULL,
0x00000018ff697819ULL, 0x000fe20000011453ULL, 0x000000a700b37306ULL, 0x0002a20000205400ULL,
0x000000a5a600720bULL, 0x000fe40003f9d000ULL, 0x00000018ffda7819ULL, 0x000fe400000114daULL,
0x00000018ff6d7819ULL, 0x000fc40000011452ULL, 0x00000001c4c46812ULL, 0x000fe200078efcffULL,
0x0000003e00b17306ULL, 0x000fe20000009400ULL, 0x000000a700a77245ULL, 0x002fe4000020d400ULL,
0x00000018ffd97819ULL, 0x000fe400000114d9ULL, 0x00000018ff747819ULL, 0x000fe40000011451ULL,
0x00000001a2a24812ULL, 0x000fe200078efcffULL, 0x0000003e00b87306ULL, 0x000e620000005400ULL,
0x000000b3b500720bULL, 0x004fc40003fbd000ULL, 0x00000018ffb37819ULL, 0x000fe400000114deULL,
0x00000018ffd87819ULL, 0x000fe400000114d8ULL, 0x00000018ff607819ULL, 0x000fe20000011454ULL,
0x000000b900d37306ULL, 0x000fe20000209400ULL, 0x00000018ff497819ULL, 0x000fe40000011455ULL,
0x00000018ff2c7819ULL, 0x000fe40000011456ULL, 0x00000018ff2f7819ULL, 0x000fc40000011457ULL,
0x00000001a7a75812ULL, 0x000fe200078efcffULL, 0x000000b900d67306ULL, 0x0004e20000205400ULL,
0x000000b8b100720bULL, 0x002fce0003f1d000ULL, 0x000000b000c07306ULL, 0x000fe20000209400ULL,
0x000000b900b97245ULL, 0x004fce000020d400ULL, 0x000000b000c77306ULL, 0x0002a20000205400ULL,
0x000000d6d300720bULL, 0x008fce0003fdd000ULL, 0x0000003f00a37306ULL, 0x000fe20000009400ULL,
0x000000b000b07245ULL, 0x002fca000020d400ULL, 0x00000001b9b96812ULL, 0x000fe400078efcffULL,
0x0000003f00a47306ULL, 0x000e620000005400ULL, 0x000000c7c000720bULL, 0x004fce0003f9d000ULL,
0x0000003e00397306ULL, 0x0004ec000000d400ULL, 0x00000001b0b04812ULL, 0x000fe400078efcffULL,
0x00000099009c7306ULL, 0x000fe20000209400ULL, 0x000000a4a300720bULL, 0x002fe20003fbd000ULL,
0x000001004e3e7824ULL, 0x004fca00078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x00000099009e7306ULL, 0x0002a20000205400ULL, 0x0000000139390812ULL, 0x008fce00078efcffULL,
0x000000a800c27306ULL, 0x000fe20000209400ULL, 0x0000009900997245ULL, 0x002fce000020d400ULL,
0x000000a800c37306ULL, 0x0002e20000205400ULL, 0x0000009e9c00720bULL, 0x004fce0003f1d000ULL,
0x000000ab00bf7306ULL, 0x000fe20000209400ULL, 0x000000a800a87245ULL, 0x002fca000020d400ULL,
0x0000000199990812ULL, 0x000fe400078efcffULL, 0x000000ab00bb7306ULL, 0x0002a20000205400ULL,
0x000000c3c200720bULL, 0x008fe40003fdd000ULL, 0x000000b099b0723eULL, 0x000fca00000010ffULL,
0x0000003f00387306ULL, 0x000ee2000000d400ULL, 0x000000ab00ab7245ULL, 0x002fca000020d400ULL,
0x00000001a8a86812ULL, 0x000fe400078efcffULL, 0x0000003d00b47306ULL, 0x000fe20000009400ULL,
0x000000bbbf00720bULL, 0x004fe40003f9d000ULL, 0x0000008c00bb7245ULL, 0x000fe4000020d400ULL,
0x00000039a8a8723eULL, 0x000fc600000010ffULL, 0x0000003d00b67306ULL, 0x000e620000005400ULL,
0x0000000138385812ULL, 0x008fca00078efcffULL, 0x00000001abab4812ULL, 0x000fe400078efcffULL,
0x00000098009b7306ULL, 0x000ff00000209400ULL, 0x00000098009a7306ULL, 0x0004e20000205400ULL,
0x000000b6b400720bULL, 0x002fce0003f7d000ULL, 0x0000003c00d77306ULL, 0x000fe20000009400ULL,
0x0000009800987245ULL, 0x004fce000020d400ULL, 0x0000003c00db7306ULL, 0x000e620000005400ULL,
0x0000009a9b00720bULL, 0x008fce0003fbd000ULL, 0x000000aa00be7306ULL, 0x000fec0000209400ULL,
0x0000000198985812ULL, 0x000fe400078efcffULL, 0x000000aa00c57306ULL, 0x0004e20000205400ULL,
0x000000dbd700720bULL, 0x002fce0003f5d000ULL, 0x0000004d009f7306ULL, 0x000fe20000009400ULL,
0x000000aa00aa7245ULL, 0x004fce000020d400ULL, 0x0000004d009d7306ULL, 0x000e620000005400ULL,
0x000000c5be00720bULL, 0x008fce0003f1d000ULL, 0x0000009100947306ULL, 0x000fec0000209400ULL,
0x00000001aaaa0812ULL, 0x000fe400078efcffULL, 0x0000009100957306ULL, 0x0004e20000205400ULL,
0x0000009d9f00720bULL, 0x002fce0003fdd000ULL, 0x0000003d00757306ULL, 0x0002e2000000d400ULL,
0x0000009100917245ULL, 0x004fce000020d400ULL, 0x0000003c00767306ULL, 0x0004a2000000d400ULL,
0x000100004e3d7824ULL, 0x002fe200078e00ffULL, 0x000000959400720bULL, 0x008fc80003f9d000ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x000000a900c17306ULL, 0x000fe20000209400ULL,
0x000001004f3c7824ULL, 0x004fe200078e00ffULL, 0x0000000175753812ULL, 0x000fc800078efcffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x000000a900c87306ULL, 0x0002a20000205400ULL,
0x0000000176762812ULL, 0x000fe400078efcffULL, 0x0000000191914812ULL, 0x000fe400078efcffULL,
0x00000076c476723eULL, 0x000fc600000010ffULL, 0x000000ba00bc7306ULL, 0x000fe20000209400ULL,
0x000000a900a97245ULL, 0x002fce000020d400ULL, 0x000000ba00c97306ULL, 0x0002e20000205400ULL,
0x000000c8c100720bULL, 0x004fce0003f7d000ULL, 0x000000af00d27306ULL, 0x000fe20000209400ULL,
0x000000ba00ba7245ULL, 0x002fca000020d400ULL, 0x00000001a9a93812ULL, 0x000fe400078efcffULL,
0x000000af00d17306ULL, 0x0002a20000205400ULL, 0x000000c9bc00720bULL, 0x008fe40003fbd000ULL,
0x00000038a9a9723eULL, 0x000fca00000010ffULL, 0x000000b200cb7306ULL, 0x000fe20000209400ULL,
0x000000af00af7245ULL, 0x002fca000020d400ULL, 0x00000001baba5812ULL, 0x000fe400078efcffULL,
0x000000b200cc7306ULL, 0x0002e20000205400ULL, 0x000000d1d200720bULL, 0x004fe40003f5d000ULL,
0x000000ba91ba723eULL, 0x000fca00000010ffULL, 0x0000004d006f7306ULL, 0x0004a2000000d400ULL,
0x000000b200b27245ULL, 0x002fca000020d400ULL, 0x00000001afaf2812ULL, 0x000fe400078efcffULL,
0x0000003e00ca7306ULL, 0x000fe20000209400ULL, 0x000000cccb00720bULL, 0x008fe20003f1d000ULL,
0x00000100564d7824ULL, 0x004fe200078e00ffULL, 0x000000afa2af723eULL, 0x000fca00000010ffULL,
0x0000003e00cf7306ULL, 0x000e620000205400ULL, 0x000000016f6f6812ULL, 0x000fca00078efcffULL,
0x00000001b2b20812ULL, 0x000fe400078efcffULL, 0x0000003c00bd7306ULL, 0x000ff00000209400ULL,
0x0000003c00d07306ULL, 0x000ea20000205400ULL, 0x000000cfca00720bULL, 0x002fce0003fdd000ULL,
0x0000004f00877306ULL, 0x000ff00000009400ULL, 0x0000004f008d7306ULL, 0x000e620000005400ULL,
0x000000d0bd00720bULL, 0x004fce0003f9d000ULL, 0x000000b700cd7306ULL, 0x000ff00000209400ULL,
0x000000b700ce7306ULL, 0x0004e20000205400ULL, 0x0000008d8700720bULL, 0x002fe40003fbd000ULL,
0x0000003e00877245ULL, 0x000fc8000020d400ULL, 0x0000000187876812ULL, 0x000fe200078efcffULL,
0x0000004c00a17306ULL, 0x000fe20000009400ULL, 0x000000b700b77245ULL, 0x004fce000020d400ULL,
0x0000004c00a07306ULL, 0x000e620000005400ULL, 0x000000cecd00720bULL, 0x008fce0003f7d000ULL,
0x0000004e00967306ULL, 0x000fec0000009400ULL, 0x00000001b7b73812ULL, 0x000fe400078efcffULL,
0x0000004e00977306ULL, 0x000ea20000005400ULL, 0x000000a0a100720bULL, 0x002fce0003f5d000ULL,
0x0000004e006b7306ULL, 0x0002f0000000d400ULL, 0x0000005000887306ULL, 0x000fe20000009400ULL,
0x000100004f4e7824ULL, 0x002fe200078e00ffULL, 0x000000979600720bULL, 0x004fc80003f7d000ULL,
0x00000018ff4e7819ULL, 0x000fe4000001144eULL, 0x0000005000897306ULL, 0x000e6e0000005400ULL,
0x000000016b6b3812ULL, 0x008fe200078efcffULL, 0x0000003d003f7306ULL, 0x000ff00000209400ULL,
0x0000003d00ae7306ULL, 0x000ea20000205400ULL, 0x000000898800720bULL, 0x002fc40003f1d000ULL,
0x0000003c00887245ULL, 0x000fe4000020d400ULL, 0x0000b800403c7811ULL, 0x000fe400078e20ffULL,
0x0000000188884812ULL, 0x000fe200078efcffULL, 0x0000004f00687306ULL, 0x0002e2000000d400ULL,
0x0000003d00407245ULL, 0x000fce000020d400ULL, 0x0000004e00ad7306ULL, 0x000fe20000209400ULL,
0x00000100504f7824ULL, 0x002fe200078e00ffULL, 0x000000ae3f00720bULL, 0x004fe40003fdd000ULL,
0x000000003c3c783bULL, 0x000e620000000200ULL, 0x000000c6a7ae723eULL, 0x000fe400000010ffULL,
0x00000018ff4f7819ULL, 0x000fe2000001144fULL, 0x0000004e00ac7306ULL, 0x000ea20000205400ULL,
0x0000000168685812ULL, 0x008fcc00078efcffULL, 0x0000000140406812ULL, 0x000fe200078efcffULL,
0x0000005000627306ULL, 0x000ef0000000d400ULL, 0x0000004c00707306ULL, 0x000662000000d400ULL,
0x000000acad00720bULL, 0x004fce0003f9d000ULL, 0x000000df00a07306ULL, 0x000fe20000209400ULL,
0x00010000504c7824ULL, 0x008fe200078e00ffULL, 0x0000000162620812ULL, 0x000fcc00078efcffULL,
0x000000df009c7306ULL, 0x000ea20000205400ULL, 0x0000000170702812ULL, 0x002fe200078efcffULL,
0x000000343c3c9231ULL, 0x000fc600003400ffULL, 0x00000070ab70723eULL, 0x000fe200000010ffULL,
0x000000343e3e9231ULL, 0x000fe400003400ffULL, 0x0000004f00507306ULL, 0x000fe20000209400ULL,
0x000000353d3d9231ULL, 0x080fe400003400ffULL, 0x000000353f3f9231ULL, 0x000fca00003400ffULL,
0x0000004f00d77306ULL, 0x000e620000205400ULL, 0x0000009ca000720bULL, 0x004fe20003f1d000ULL,
0x000000ae3c1c723cULL, 0x000f6c000004181cULL, 0x0000008400857306ULL, 0x000ff00000209400ULL,
0x0000008400797306ULL, 0x0004e20000205400ULL, 0x000000d75000720bULL, 0x002fc40003fdd000ULL,
0x0000004e00507245ULL, 0x000fc8000020d400ULL, 0x0000000150504812ULL, 0x000fe200078efcffULL,
0x0000007f008a7306ULL, 0x000fe20000209400ULL, 0x0000008400847245ULL, 0x004fce000020d400ULL,
0x0000007f00867306ULL, 0x0002a20000205400ULL, 0x000000798500720bULL, 0x008fe40003f9d000ULL,
0x000000df00857245ULL, 0x000fc8000020d400ULL, 0x0000000185850812ULL, 0x000fe200078efcffULL,
0x0000008c00927306ULL, 0x000fe20000209400ULL, 0x0000007f007f7245ULL, 0x002fca000020d400ULL,
0x0000000184844812ULL, 0x000fe400078efcffULL, 0x0000008c00937306ULL, 0x000e620000205400ULL,
0x000000868a00720bULL, 0x004fce0003f7d000ULL, 0x00000080008e7306ULL, 0x000fec0000209400ULL,
0x000000017f7f3812ULL, 0x000fe400078efcffULL, 0x00000080008b7306ULL, 0x0004e20000205400ULL,
0x000000939200720bULL, 0x002fce0003f5d000ULL, 0x000000e0009a7306ULL, 0x000fe20000209400ULL,
0x0000008000807245ULL, 0x004fca000020d400ULL, 0x00000001bbbb2812ULL, 0x000fe400078efcffULL,
0x000000e000967306ULL, 0x0002a20000205400ULL, 0x0000008b8e00720bULL, 0x008fe40003fbd000ULL,
0x000000b2bbbb723eULL, 0x000fca00000010ffULL, 0x00000053007b7306ULL, 0x000fe20000009400ULL,
0x000000e000e07245ULL, 0x002fe2000020d400ULL, 0x000000ba3c0c723cULL, 0x000fe8000004180cULL,
0x0000000180805812ULL, 0x000fe400078efcffULL, 0x00000053007c7306ULL, 0x000fe20000005400ULL,
0x000000969a00720bULL, 0x004fce0003f1d000ULL, 0x00000053005f7306ULL, 0x0003ec000000d400ULL,
0x00000001e0e00812ULL, 0x000fe400078efcffULL, 0x0000005200787306ULL, 0x000fe20000009400ULL,
0x00000018ff537819ULL, 0x002fe2000001144cULL, 0x00000100574c7824ULL, 0x000fcc00078e00ffULL,
0x0000005300d47306ULL, 0x000ff00000209400ULL, 0x0000005300b17306ULL, 0x0002b00000205400ULL,
0x00000052007d7306ULL, 0x000ee20000005400ULL, 0x0000005300537245ULL, 0x002fce000020d400ULL,
0x000000da00947306ULL, 0x000fe20000209400ULL, 0x000000b1d400720bULL, 0x004fe40003f7d000ULL,
0x000000b798b1723eULL, 0x000fca00000010ffULL, 0x000000da00927306ULL, 0x0002a20000205400ULL,
0x0000007d7800720bULL, 0x008fe20003fbd000ULL, 0x000000b03c14723cULL, 0x000fe80000041814ULL,
0x0000000153533812ULL, 0x000fe400078efcffULL, 0x000000b300a57306ULL, 0x000fe20000209400ULL,
0x000000da00da7245ULL, 0x002fe4000020d400ULL, 0x0000007c7b00720bULL, 0x000fc40003f7d000ULL,
0x000000538484723eULL, 0x000fc600000010ffULL, 0x000000b300a37306ULL, 0x0003e20000205400ULL,
0x000000929400720bULL, 0x004fce0003f1d000ULL, 0x00000051008f7306ULL, 0x000fe20000009400ULL,
0x000000b300b37245ULL, 0x002fe4000020d400ULL, 0x000000015f5f3812ULL, 0x000fc600078efcffULL,
0x00000001dada0812ULL, 0x000fe400078efcffULL, 0x0000005100907306ULL, 0x000e640000005400ULL,
0x0000005fda5f723eULL, 0x000fcc00000010ffULL, 0x00000052005e7306ULL, 0x0004f0000000d400ULL,
0x0000005100647306ULL, 0x0006e2000000d400ULL, 0x000000908f00720bULL, 0x002fe20003f5d000ULL,
0x0000010055527824ULL, 0x004fca00078e00ffULL, 0x00000018ff797819ULL, 0x000fe20000011452ULL,
0x0000006d00717306ULL, 0x000fe20000209400ULL, 0x0000010054517824ULL, 0x008fe200078e00ffULL,
0x000000015e5e5812ULL, 0x000fe400078efcffULL, 0x00000079008b7245ULL, 0x000fe4000020d400ULL,
0x00000018ff8a7819ULL, 0x000fe40000011451ULL, 0x0000006d003a7306ULL, 0x0002a20000205400ULL,
0x0000004f00517245ULL, 0x000fc4000020d400ULL, 0x0000000164642812ULL, 0x000fe400078efcffULL,
0x0000000151516812ULL, 0x000fe400078efcffULL, 0x000000a3a500720bULL, 0x000fe20003fdd000ULL,
0x000000d9008c7306ULL, 0x000fe20000209400ULL, 0x0000006d006d7245ULL, 0x002fe4000020d400ULL,
0x000000625162723eULL, 0x000fe400000010ffULL, 0x0000005ee05e723eULL, 0x000fc600000010ffULL,
0x000000d900897306ULL, 0x0002e20000205400ULL, 0x0000003a7100720bULL, 0x004fe40003fbd000ULL,
0x0000006faa71723eULL, 0x000fe400000010ffULL, 0x00000001b3b36812ULL, 0x000fe400078efcffULL,
0x00000018ff6f7819ULL, 0x000fe2000001144dULL, 0x0000005500777306ULL, 0x000fe20000009400ULL,
0x000000d900d97245ULL, 0x002fe2000020d400ULL, 0x000000703c10723cULL, 0x000fe20000041810ULL,
0x00000050804d723eULL, 0x000fc600000010ffULL, 0x000000016d6d5812ULL, 0x000fe400078efcffULL,
0x00000055007a7306ULL, 0x000e620000005400ULL, 0x000000898c00720bULL, 0x008fce0003f1d000ULL,
0x000000d800867306ULL, 0x000fec0000209400ULL, 0x00000001d9d90812ULL, 0x000fe400078efcffULL,
0x000000d8004e7306ULL, 0x0004e20000205400ULL, 0x0000007a7700720bULL, 0x002fe40003fdd000ULL,
0x00000075b977723eULL, 0x000fca00000010ffULL, 0x0000007400817306ULL, 0x000fe20000209400ULL,
0x000000d800d87245ULL, 0x004fe2000020d400ULL, 0x000000763c20723cULL, 0x000fec0000041820ULL,
0x0000007400827306ULL, 0x0002a20000205400ULL, 0x0000004e8600720bULL, 0x008fe40003f7d000ULL,
0x0000b8003b4e7811ULL, 0x000fc400078e20ffULL, 0x000000a83c38723cULL, 0x000b660000041818ULL,
0x00000069006e7306ULL, 0x000fe20000209400ULL, 0x000000004e18783bULL, 0x0206e20000000200ULL,
0x0000007400747245ULL, 0x002fc8000020d400ULL, 0x00000001d8d83812ULL, 0x000fe400078efcffULL,
0x00000069006c7306ULL, 0x0002e20000205400ULL, 0x000000828100720bULL, 0x004fe40003f5d000ULL,
0x0000006b874e723eULL, 0x008fca00000010ffULL, 0x0000008a004f7306ULL, 0x000fe20000209400ULL,
0x0000006900697245ULL, 0x002fca000020d400ULL, 0x0000000174742812ULL, 0x000fe400078efcffULL,
0x0000008a00787306ULL, 0x0002a20000205400ULL, 0x0000006c6e00720bULL, 0x000fe40003f1d000ULL,
0x000000857485723eULL, 0x000fca00000010ffULL, 0x0000005600737306ULL, 0x000fe20000009400ULL,
0x0000008a008a7245ULL, 0x002fca000020d400ULL, 0x0000000169690812ULL, 0x000fe400078efcffULL,
0x0000005600727306ULL, 0x000e620000005400ULL, 0x000000784f00720bULL, 0x004fe20003fbd000ULL,
0x0000003418189231ULL, 0x080fe200003400ffULL, 0x00000068884f723eULL, 0x000fe200000010ffULL,
0x000000341a1a9231ULL, 0x000fe400003400ffULL, 0x0000003519199231ULL, 0x080fe400003400ffULL,
0x0000005400837306ULL, 0x000fe20000009400ULL, 0x000000351b1b9231ULL, 0x000fe200003400ffULL,
0x0000004e3c04723cULL, 0x000f680000041804ULL, 0x000000018a8a5812ULL, 0x000fc400078efcffULL,
0x00000054007e7306ULL, 0x000ea20000005400ULL, 0x000000727300720bULL, 0x002fe20003f5d000ULL,
0x00000084181c723cULL, 0x040fec000004181cULL, 0x0000006000657306ULL, 0x000fe40000209400ULL,
0x0000005e1838723cULL, 0x000fec0000041838ULL, 0x0000006000667306ULL, 0x0002e20000205400ULL,
0x0000007e8300720bULL, 0x004fce0003f9d000ULL, 0x00000079007b7306ULL, 0x000fe20000209400ULL,
0x0000006000607245ULL, 0x002fce000020d400ULL, 0x0000007900757306ULL, 0x000e620000205400ULL,
0x000000666500720bULL, 0x008fce0003f1d000ULL, 0x00000057006a7306ULL, 0x000fec0000009400ULL,
0x0000000160600812ULL, 0x000fe400078efcffULL, 0x0000005700677306ULL, 0x000ea20000005400ULL,
0x000000757b00720bULL, 0x002fce0003fbd000ULL, 0x00000054005b7306ULL, 0x0002ec000000d400ULL,
0x000000018b8b5812ULL, 0x000fe400078efcffULL, 0x0000005500487306ULL, 0x0006e2000000d400ULL,
0x0001000054547824ULL, 0x002fe200078e00ffULL, 0x000000676a00720bULL, 0x004fc40003f7d000ULL,
0x00000018ff677819ULL, 0x000fe4000001144cULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x0000004900637306ULL, 0x000fe20000209400ULL, 0x0001000055557824ULL, 0x008fe200078e00ffULL,
0x000000407f4c723eULL, 0x000fe400000010ffULL, 0x000000015b5b4812ULL, 0x000fe400078efcffULL,
0x00000018ff557819ULL, 0x000fc40000011455ULL, 0x0000004900617306ULL, 0x0002a20000205400ULL,
0x0000004c3c08723cULL, 0x000b620000041808ULL, 0x0000000148486812ULL, 0x000fe400078efcffULL,
0x0000005b8a8a723eULL, 0x000fe400000010ffULL, 0x000000488b8b723eULL, 0x000fe400000010ffULL,
0x0000005400527306ULL, 0x000fe20000209400ULL, 0x0000004900497245ULL, 0x002fe4000020d400ULL,
0x000000d96d3c723eULL, 0x020fc400000010ffULL, 0x000000d8693d723eULL, 0x000fe200000010ffULL,
0x0000008a1810723cULL, 0x000f640000041810ULL, 0x0000005400727306ULL, 0x0002e20000205400ULL,
0x000000616300720bULL, 0x004fe40003f9d000ULL, 0x00000064b363723eULL, 0x000fc600000010ffULL,
0x0000003c1814723cULL, 0x000b640000041814ULL, 0x0000005500737306ULL, 0x000fe20000209400ULL,
0x0000005400547245ULL, 0x002fc8000020d400ULL, 0x00000067003d7245ULL, 0x020fe2000020d400ULL,
0x000000621820723cULL, 0x000b620000041820ULL, 0x0000000149494812ULL, 0x000fe200078efcffULL,
0x0000005500767306ULL, 0x0002a20000205400ULL, 0x000000725200720bULL, 0x008fce0003fbd000ULL,
0x0000006f00777306ULL, 0x000fe20000209400ULL, 0x0000005500557245ULL, 0x002fca000020d400ULL,
0x0000000154545812ULL, 0x000fe400078efcffULL, 0x0000006f006c7306ULL, 0x0002e20000205400ULL,
0x000000767300720bULL, 0x004fe40003fdd000ULL, 0x000000546054723eULL, 0x000fca00000010ffULL,
0x0000005600307306ULL, 0x0004e2000000d400ULL, 0x0000006f006f7245ULL, 0x002fca000020d400ULL,
0x0000000155556812ULL, 0x000fe400078efcffULL, 0x0000005700377306ULL, 0x000262000000d400ULL,
0x0001000056567824ULL, 0x004fe200078e00ffULL, 0x0000006c7700720bULL, 0x008fe40003f1d000ULL,
0x000000554955723eULL, 0x000fe400000010ffULL, 0x00000018ff567819ULL, 0x000fe40000011456ULL,
0x0000006700687306ULL, 0x000fe20000209400ULL, 0x0001000057577824ULL, 0x002fe200078e00ffULL,
0x0000000130302812ULL, 0x000fe200078efcffULL, 0x00000054180c723cULL, 0x000b66000004180cULL,
0x00000018ff577819ULL, 0x000fc40000011457ULL, 0x0000006700407306ULL, 0x000e620000205400ULL,
0x000000016f6f0812ULL, 0x000fe400078efcffULL, 0x0000000137373812ULL, 0x000fe400078efcffULL,
0x000000306f3c723eULL, 0x000fc600000010ffULL, 0x0000002c005d7306ULL, 0x000ff00000209400ULL,
0x0000002c005c7306ULL, 0x0004e20000205400ULL, 0x000000406800720bULL, 0x002fce0003f9d000ULL,
0x0000002f004b7306ULL, 0x000fe20000209400ULL, 0x0000002c002c7245ULL, 0x004fca000020d400ULL,
0x000000013d3d4812ULL, 0x000fe400078efcffULL, 0x0000002f005a7306ULL, 0x0002a20000205400ULL,
0x0000005c5d00720bULL, 0x008fe40003fbd000ULL, 0x000000373d3d723eULL, 0x000fca00000010ffULL,
0x00000056003e7306ULL, 0x000fe20000209400ULL, 0x0000002f002f7245ULL, 0x002fe2000020d400ULL,
0x0000003c1804723cULL, 0x000b680000041804ULL, 0x000000012c2c5812ULL, 0x000fe400078efcffULL,
0x00000056003f7306ULL, 0x0002e20000205400ULL, 0x0000005a4b00720bULL, 0x004fce0003fdd000ULL,
0x00000057004c7306ULL, 0x000fe20000209400ULL, 0x0000005600567245ULL, 0x002fca000020d400ULL,
0x000000012f2f6812ULL, 0x000fe400078efcffULL, 0x00000057004d7306ULL, 0x0002a20000205400ULL,
0x0000003f3e00720bULL, 0x008fe40003f1d000ULL, 0x0000005700577245ULL, 0x002fd6000020d400ULL,
0x0000000156560812ULL, 0x000fe400078efcffULL, 0x0000004d4c00720bULL, 0x004fe40003f5d000ULL,
0x000000562c56723eULL, 0x000fd600000010ffULL, 0x0000000157572812ULL, 0x000fc800078efcffULL,
0x000000572f57723eULL, 0x000fce00000010ffULL, 0x000000561818723cULL, 0x000b620000041808ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff3c7f8cULL, 0x020e62000c80043fULL,
0x000000ffff2f7224ULL, 0x000fce00078e00ffULL, 0x0000000000087805ULL, 0x000fc40000015200ULL,
0x0106bc00ff0a7984ULL, 0x000ea40000000800ULL, 0x800000000aff7812ULL, 0x006fe4000780483dULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102f00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a082c7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e09ULL,
0x003d09002c00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402c00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0a7819ULL, 0x000fc8000001140bULL, 0x0000002c0a0a7211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060bULL, 0x000000020a0a7819ULL, 0x000fc8000000120bULL,
0x0000000a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012f2f7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106bc00ff0a7984ULL, 0x000e640000000800ULL, 0x800000000aff7812ULL, 0x002fe4000780483dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000022b087810ULL, 0x000fc80007ffe0ffULL,
0x000000260800720cULL, 0x000fe20003f06070ULL, 0x0000580028087a24ULL, 0x010fc800078e02ffULL,
0x00000080082c7824ULL, 0x000fd000078e00ffULL, 0x0000045000008947ULL, 0x000fea0003800000ULL,
0x0000000127097824ULL, 0x000fe200078e0236ULL, 0x00000002363f7810ULL, 0x040fe40007ffe0ffULL,
0x000000c041417810ULL, 0x000fe20007ffe0ffULL, 0x00000001090a7824ULL, 0x040fe200078e0203ULL,
0x0000000436487810ULL, 0x000fe20007ffe0ffULL, 0x00000010093e7824ULL, 0x000fe200078e00ffULL,
0x0000004124087217ULL, 0x000fe20007800000ULL, 0x00000001270b7824ULL, 0x000fe200078e023fULL,
0x0000000636497810ULL, 0x000fe20007ffe0ffULL, 0x0000008000097824ULL, 0x000fe200078e0209ULL,
0xfffffff03e3e7812ULL, 0x000fe200078ee20aULL, 0x000000010b0a7824ULL, 0x000fc400078e0203ULL,
0x000000100b407824ULL, 0x000fe200078e00ffULL, 0x0000000409307810ULL, 0x040fe20007ffe0ffULL,
0x0000000108087824ULL, 0x000fe200078e0a41ULL, 0x0000002c093c7210ULL, 0x000fe20007f1e0ffULL,
0x00000001272f7824ULL, 0x040fe200078e0248ULL, 0xfffffff040407812ULL, 0x000fe200078ee20aULL,
0x00000001270a7824ULL, 0x040fe200078e0249ULL, 0x0000000827087217ULL, 0x000fe20007800000ULL,
0x000000012f0b7824ULL, 0x100fe200078e0203ULL, 0x0000000209377810ULL, 0x000fe20007ffe0ffULL,
0x000000102f417824ULL, 0x000fe200078e00ffULL, 0x0000002c30307210ULL, 0x080fe20007f7e0ffULL,
0x000000010a3d7824ULL, 0x040fe200078e0203ULL, 0x00000006092f7810ULL, 0x000fe20007ffe0ffULL,
0x000000100a4b7824ULL, 0x000fe200078e00ffULL, 0xfffffff041417812ULL, 0x000fe200078ee20bULL,
0x000000ffff097224ULL, 0x000fe200000e06ffULL, 0x00005e003c0b7a11ULL, 0x000fe200078440ffULL,
0x00000001080a7824ULL, 0x000fe200078e0a27ULL, 0x0000002c37377210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff087224ULL, 0x000fe200018e06ffULL, 0x0000002c2f2c7210ULL, 0x000fc40007f1e0ffULL,
0xfffffff04b4b7812ULL, 0x000fe400078ee23dULL, 0x00005e00302f7a11ULL, 0x000fe400078640ffULL,
0x00005f003c3c7a11ULL, 0x000fe200010f4409ULL, 0x000000ffff097224ULL, 0x000fe200020e06ffULL,
0x000000f02e3d7812ULL, 0x000fe400078ec0ffULL, 0x0000000a3600720cULL, 0x000fe40003f46070ULL,
0x00005f0030307a11ULL, 0x000fc400018f4408ULL, 0x00005e0037367a11ULL, 0x000fe400078840ffULL,
0x0000003d0b087210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e06ffULL,
0x00005f0037377a11ULL, 0x000fe400020f4409ULL, 0x0000000a3f00720cULL, 0x080fe20003f86070ULL,
0x000000ffff097224ULL, 0x000fe200028e063cULL, 0x0000000a4800720cULL, 0x000fe40003f66070ULL,
0x0000c0003e3e7811ULL, 0x000fc400078e20ffULL, 0x0000000a4900720cULL, 0x000fe40003f06070ULL,
0x00005e002c2e7a11ULL, 0x000fe200078c40ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000083e7faeULL, 0x0003e2000d101c46ULL, 0x0000003d360a7210ULL, 0x080fe40007fbe0ffULL,
0x00005f002c2c7a11ULL, 0x000fe400030f440bULL, 0x0000c00040407811ULL, 0x000fe200078e20ffULL,
0x000000ffff0b7224ULL, 0x000fe200028e0637ULL, 0x0000003d2e2e7210ULL, 0x000fc40007fbe0ffULL,
0x0000c00041417811ULL, 0x000fe400078e20ffULL, 0x0000c0004b4b7811ULL, 0x000fe200078e20ffULL,
0x000000000a407faeULL, 0x0005e2000e101c46ULL, 0x0000003d2f087210ULL, 0x002fe20007f5e0ffULL,
0x000000ffff2f7224ULL, 0x000fc800028e062cULL, 0x000000ffff097224ULL, 0x000fca00010e0630ULL,
0x0000000008417faeULL, 0x0005e8000d901c46ULL, 0x000000002e4b7faeULL, 0x0005e2000c101c46ULL,
0x0000038000007947ULL, 0x000fea0003800000ULL, 0x0000000127367824ULL, 0x000fc800078e0236ULL,
0x0000000136087824ULL, 0x140fe200078e0203ULL, 0x0000000236097810ULL, 0x040fe20007ffe0ffULL,
0x00000010360b7824ULL, 0x040fe200078e00ffULL, 0x00000004362f7810ULL, 0x040fe40007ffe0ffULL,
0x0000000636377810ULL, 0x000fe20007ffe0ffULL, 0x00000001090a7824ULL, 0x100fe200078e0203ULL,
0xfffffff00b0b7812ULL, 0x000fe200078ee208ULL, 0x0000001009307824ULL, 0x000fe400078e00ffULL,
0x0000008000087824ULL, 0x000fe200078e0236ULL, 0x0000c0000b0b7811ULL, 0x000fe200078e20ffULL,
0x000000012f3c7824ULL, 0x140fe200078e0203ULL, 0xfffffff030307812ULL, 0x000fe200078ee20aULL,
0x000000102f3e7824ULL, 0x000fe200078e00ffULL, 0x0000002c08097210ULL, 0x040fe20007f1e0ffULL,
0x0000000137407824ULL, 0x040fe200078e0203ULL, 0x00000002080a7810ULL, 0x040fe20007ffe0ffULL,
0x0000001037487824ULL, 0x000fe200078e00ffULL, 0x0000000408367810ULL, 0x000fc40007ffe0ffULL,
0x00000006083d7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x0000002c0a2f7210ULL, 0x080fe40007f5e0ffULL, 0x0000002c36377210ULL, 0x080fe40007f7e0ffULL,
0x00005e00090a7a11ULL, 0x000fe400078040ffULL, 0x000000f02e367812ULL, 0x000fe400078ec0ffULL,
0x0000002c3d3f7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff2c7224ULL, 0x000fe200010e06ffULL,
0x00005f0009097a11ULL, 0x000fc400000f4408ULL, 0x000000360a087210ULL, 0x000fe40007f1e0ffULL,
0xfffffff03e3e7812ULL, 0x000fe200078ee23cULL, 0x000000ffff3c7224ULL, 0x000fe200018e06ffULL,
0xfffffff048487812ULL, 0x000fe200078ee240ULL, 0x000000ffff407224ULL, 0x000fe200020e06ffULL,
0x00005e002f2e7a11ULL, 0x000fe200078440ffULL, 0x000000ffff097224ULL, 0x000fe200000e0609ULL,
0x00005e00373d7a11ULL, 0x000fe400078640ffULL, 0x00005e003f417a11ULL, 0x000fc400078840ffULL,
0x00005f002f2c7a11ULL, 0x000fe200010f442cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080b7faeULL, 0x0003e2000b901c46ULL, 0x000000362e0a7210ULL, 0x080fe40007f1e0ffULL,
0x00005f00373c7a11ULL, 0x000fe400018f443cULL, 0x000000363d2e7210ULL, 0x080fe40007f5e0ffULL,
0x00005f003f407a11ULL, 0x000fe400020f4440ULL, 0x0000003641367210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff2f7224ULL, 0x000fe200010e063cULL, 0x0000c00030307811ULL, 0x000fe200078e20ffULL,
0x000000ffff0b7224ULL, 0x002fe200000e062cULL, 0x0000c0003e3e7811ULL, 0x000fe200078e20ffULL,
0x000000ffff377224ULL, 0x000fe200018e0640ULL, 0x0000c00048487811ULL, 0x000fc400078e20ffULL,
0x000000000a307faeULL, 0x0003e8000b901c46ULL, 0x000000002e3e7faeULL, 0x0003e8000b901c46ULL,
0x0000000036487faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x004fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff487f8cULL, 0x002e64000c80043fULL,
0x000000ffff487224ULL, 0x002fc400078e0049ULL, 0x0000000000087805ULL, 0x000fca0000015200ULL,
0x0106b400ff0a7984ULL, 0x000e640000000800ULL, 0x800000000aff7812ULL, 0x002fc40007804859ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff2e7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a082c7210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e09ULL, 0x003d09002c00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402c00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0a7819ULL, 0x000fc8000001140bULL,
0x0000002c0a0a7211ULL, 0x000fca00078110ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e060bULL,
0x000000020a0a7819ULL, 0x000fc8000000120bULL, 0x0000000a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012e2e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106b400ff0a7984ULL, 0x000e640000000800ULL,
0x800000000aff7812ULL, 0x002fe40007804859ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000014000007945ULL, 0x000fe20003800000ULL, 0x0000012000001947ULL, 0x000fea0003800000ULL,
0x00000033ff08723eULL, 0x000fe400000010ffULL, 0x00000002ff097819ULL, 0x000fe40000011603ULL,
0x0000541008087816ULL, 0x000fe20000000008ULL, 0x000098c27f007947ULL, 0x000fea000b800000ULL,
0x00001f0908347589ULL, 0x0002a400000e0000ULL, 0x0000000809357810ULL, 0x000fe20007ffe0ffULL,
0x000098f27f007947ULL, 0x000fea000b800000ULL, 0x00001f3508357589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000010094b7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4d7224ULL, 0x000fe200078e0008ULL, 0x000177b0004c7802ULL, 0x000fc40000000f00ULL,
0x00009da000007944ULL, 0x00efea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000018094b7810ULL, 0x004fe20007ffe0ffULL, 0x000000ffff4d7224ULL, 0x000fe200078e0008ULL,
0x00017800004c7802ULL, 0x000fc40000000f00ULL, 0x00009d5000007944ULL, 0x00afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000b800467a7811ULL, 0x000fc400078e20ffULL, 0x000000004408783bULL, 0x00ae680000004200ULL,
0x00000000453c783bULL, 0x000ee80000004200ULL, 0x00000000424c783bULL, 0x000f280000004200ULL,
0x000000004340783bULL, 0x000ea20000004200ULL, 0x00000008009b7306ULL, 0x002fe20000009400ULL,
0x00000018ffb87819ULL, 0x000fe20000011408ULL, 0x0000010008947824ULL, 0x000fe200078e00ffULL,
0x00000018ff987819ULL, 0x000fe20000011409ULL, 0x000100000aae7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8d7819ULL, 0x000fe2000001140aULL, 0x000001003c9c7824ULL, 0x048fe200078e00ffULL,
0x00000018ffaa7819ULL, 0x000fe20000011494ULL, 0x00000008009f7306ULL, 0x000e620000005400ULL,
0x00000018ffae7819ULL, 0x000fe200000114aeULL, 0x000001000bad7824ULL, 0x040fe200078e00ffULL,
0x00000018ff9c7819ULL, 0x000fe2000001149cULL, 0x000100000b9e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8c7819ULL, 0x000fe2000001140bULL, 0x000100003c9d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff857819ULL, 0x000fe2000001143cULL, 0x00000008006b7306ULL, 0x0006a2000000d400ULL,
0x00000018ff7e7819ULL, 0x000fe2000001143dULL, 0x000100003f947824ULL, 0x000fe200078e00ffULL,
0x00000018ffad7819ULL, 0x000fe200000114adULL, 0x000001004c957824ULL, 0x010fe200078e00ffULL,
0x00000018ff9d7819ULL, 0x000fe2000001149dULL, 0x000001004fd37824ULL, 0x000fe200078e00ffULL,
0x00000018ff947819ULL, 0x000fe20000011494ULL, 0x0000009800b27306ULL, 0x000fe20000209400ULL,
0x0001000008087824ULL, 0x008fe200078e00ffULL, 0x0000009f9b00720bULL, 0x002fe20003f5d000ULL,
0x000001004ed17824ULL, 0x040fe200078e00ffULL, 0x00000018ff6d7819ULL, 0x000fe2000001143eULL,
0x000100004ed27824ULL, 0x000fe200078e00ffULL, 0x00000018ffb57819ULL, 0x000fe20000011408ULL,
0x0000010009087824ULL, 0x000fe200078e00ffULL, 0x0000009800af7306ULL, 0x0003e20000205400ULL,
0x00000018ff6e7819ULL, 0x000fe2000001143fULL, 0x000100004cce7824ULL, 0x000fe200078e00ffULL,
0x00000018ff9e7819ULL, 0x000fe2000001149eULL, 0x00000100409b7824ULL, 0x004fe200078e00ffULL,
0x00000018ffbd7819ULL, 0x000fe20000011408ULL, 0x000001000a087824ULL, 0x000fe200078e00ffULL,
0x000000016b6b2812ULL, 0x000fe200078efcffULL, 0x000000b500b67306ULL, 0x000fe20000209400ULL,
0x0000009800987245ULL, 0x002fe2000020d400ULL, 0x000001004dcf7824ULL, 0x000fe200078e00ffULL,
0x00000018ffc57819ULL, 0x000fe20000011408ULL, 0x000100003e087824ULL, 0x000fe200078e00ffULL,
0x00000018ff757819ULL, 0x000fe2000001144cULL, 0x000100004fb47824ULL, 0x000fe200078e00ffULL,
0x00000018ff657819ULL, 0x000fe2000001144dULL, 0x000000b500b77306ULL, 0x0002a20000205400ULL,
0x00000018ff087819ULL, 0x000fe20000011408ULL, 0x000100004dd07824ULL, 0x000fe200078e00ffULL,
0x00000018ff957819ULL, 0x000fc40000011495ULL, 0x00000018ff5c7819ULL, 0x000fe4000001144eULL,
0x00000018ffd37819ULL, 0x000fe200000114d3ULL, 0x0000000a00c37306ULL, 0x000fe20000009400ULL,
0x000000b500b57245ULL, 0x002fe4000020d400ULL, 0x00000018ffd17819ULL, 0x000fe400000114d1ULL,
0x00000018ff9b7819ULL, 0x000fe4000001149bULL, 0x00000018ffd27819ULL, 0x000fe200000114d2ULL,
0x0000000a00c47306ULL, 0x000e620000005400ULL, 0x000000b7b600720bULL, 0x004fc40003f9d000ULL,
0x000000b800b67245ULL, 0x000fe4000020d400ULL, 0x00000018ffcf7819ULL, 0x000fe400000114cfULL,
0x00000018ff567819ULL, 0x000fe2000001144fULL, 0x000000ae00c87306ULL, 0x000fe20000209400ULL,
0x00000018ffb47819ULL, 0x000fe400000114b4ULL, 0x00000018ffd07819ULL, 0x000fe400000114d0ULL,
0x00000018ff457819ULL, 0x000fc40000011440ULL, 0x00000001b5b54812ULL, 0x000fe200078efcffULL,
0x000000ae00c97306ULL, 0x0004e20000205400ULL, 0x000000afb200720bULL, 0x000fe40003f9d000ULL,
0x000000c4c300720bULL, 0x002fe40003f1d000ULL, 0x000000bd00af7245ULL, 0x000fe4000020d400ULL,
0x00000018ff327819ULL, 0x000fe20000011441ULL, 0x0000000900bb7306ULL, 0x000fe20000009400ULL,
0x000000ae00ae7245ULL, 0x004fc4000020d400ULL, 0x00000018ff2e7819ULL, 0x000fe40000011442ULL,
0x00000018ff2c7819ULL, 0x000fe40000011443ULL, 0x0000000198984812ULL, 0x000fe200078efcffULL,
0x0000000900bc7306ULL, 0x000e620000005400ULL, 0x000000c9c800720bULL, 0x008fce0003f9d000ULL,
0x00000009006a7306ULL, 0x0005ec000000d400ULL, 0x00000001aeae4812ULL, 0x000fe400078efcffULL,
0x0000000a00647306ULL, 0x000722000000d400ULL, 0x0001000009097824ULL, 0x004fe200078e00ffULL,
0x000000bcbb00720bULL, 0x002fc80003f7d000ULL, 0x00000018ffc07819ULL, 0x000fe20000011409ULL,
0x000001003e097824ULL, 0x000fe200078e00ffULL, 0x0000008d00917306ULL, 0x000fe20000209400ULL,
0x000001003f0a7824ULL, 0x008fe200078e00ffULL, 0x000000c000b77245ULL, 0x000fe4000020d400ULL,
0x00000018ff097819ULL, 0x000fe40000011409ULL, 0x00000018ff0a7819ULL, 0x000fe4000001140aULL,
0x0000008d00927306ULL, 0x0002a20000205400ULL, 0x0000000164640812ULL, 0x010fc400078efcffULL,
0x000000016a6a3812ULL, 0x000fca00078efcffULL, 0x000000aa00a07306ULL, 0x000fe20000209400ULL,
0x0000008d008d7245ULL, 0x002fce000020d400ULL, 0x000000aa00b37306ULL, 0x0002e20000205400ULL,
0x000000929100720bULL, 0x004fce0003f1d000ULL, 0x0000000b009a7306ULL, 0x000fe20000009400ULL,
0x000000aa00aa7245ULL, 0x002fca000020d400ULL, 0x000000018d8d0812ULL, 0x000fe400078efcffULL,
0x0000000b00997306ULL, 0x000fe20000005400ULL, 0x000000b3a000720bULL, 0x008fe40003fdd000ULL,
0x00000018ffa07819ULL, 0x000fe400000114ceULL, 0x000000ae8dae723eULL, 0x000fc600000010ffULL,
0x0000000b00617306ULL, 0x0003ec000000d400ULL, 0x00000001aaaa6812ULL, 0x000fe400078efcffULL,
0x0000009c00b17306ULL, 0x000fe20000209400ULL, 0x000001003d0b7824ULL, 0x002fe200078e00ffULL,
0x0000006baaaa723eULL, 0x000fc800000010ffULL, 0x00000018ff0b7819ULL, 0x000fe4000001140bULL,
0x0000009c00ab7306ULL, 0x0002b00000205400ULL, 0x000000b800b97306ULL, 0x000fe20000209400ULL,
0x0000009c009c7245ULL, 0x002fce000020d400ULL, 0x000000b800ba7306ULL, 0x000e620000205400ULL,
0x000000abb100720bULL, 0x004fce0003f9d000ULL, 0x000000c000c17306ULL, 0x000fec0000209400ULL,
0x000000019c9c4812ULL, 0x000fe400078efcffULL, 0x000000c000c27306ULL, 0x000ea20000205400ULL,
0x000000bab900720bULL, 0x002fce0003fbd000ULL, 0x000000bd00be7306ULL, 0x000fec0000209400ULL,
0x00000001b6b65812ULL, 0x000fe400078efcffULL, 0x000000bd00bf7306ULL, 0x000e620000205400ULL,
0x000000c2c100720bULL, 0x004fe40003f5d000ULL, 0x000000999a00720bULL, 0x000fc40003fbd000ULL,
0x000000b5b6b6723eULL, 0x000fc600000010ffULL, 0x0000000b00a97306ULL, 0x000fec0000209400ULL,
0x00000001b7b72812ULL, 0x000fe400078efcffULL, 0x0000000b00ac7306ULL, 0x000ea20000205400ULL,
0x000000bfbe00720bULL, 0x002fe40003fdd000ULL, 0x0000000161615812ULL, 0x000fc400078efcffULL,
0x000000b798b7723eULL, 0x000fc600000010ffULL, 0x0000003c00977306ULL, 0x000fec0000009400ULL,
0x00000001afaf6812ULL, 0x000fe400078efcffULL, 0x0000003c00967306ULL, 0x000e620000005400ULL,
0x000000aca900720bULL, 0x004fe40003f1d000ULL, 0x0000006aafab723eULL, 0x000fca00000010ffULL,
0x0000003c005d7306ULL, 0x0004f0000000d400ULL, 0x0000008500897306ULL, 0x000fe20000209400ULL,
0x000100003d3c7824ULL, 0x004fe200078e00ffULL, 0x000000969700720bULL, 0x002fc40003f5d000ULL,
0x000000c500967245ULL, 0x000fe4000020d400ULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000008500887306ULL, 0x0002ae0000205400ULL, 0x000000015d5d2812ULL, 0x008fe200078efcffULL,
0x000000c500c67306ULL, 0x000fe20000209400ULL, 0x0000008500857245ULL, 0x002fc4000020d400ULL,
0x0000005d9c9c723eULL, 0x000fe400000010ffULL, 0x000000b4005d7245ULL, 0x000fc6000020d400ULL,
0x000000c500c77306ULL, 0x000e620000205400ULL, 0x000000888900720bULL, 0x004fe40003f9d000ULL,
0x0000000b00887245ULL, 0x000fc8000020d400ULL, 0x0000000188880812ULL, 0x000fe200078efcffULL,
0x0000003c00a77306ULL, 0x000fec0000209400ULL, 0x0000000185854812ULL, 0x000fe400078efcffULL,
0x0000003c00a87306ULL, 0x000ea20000205400ULL, 0x000000c7c600720bULL, 0x002fce0003fdd000ULL,
0x0000000a00a57306ULL, 0x000fec0000209400ULL, 0x0000000196966812ULL, 0x000fe400078efcffULL,
0x0000000a00b07306ULL, 0x000e620000205400ULL, 0x000000a8a700720bULL, 0x004fe40003f1d000ULL,
0x000000649664723eULL, 0x000fca00000010ffULL, 0x0000008c008f7306ULL, 0x000ff00000209400ULL,
0x0000008c008e7306ULL, 0x0004e20000205400ULL, 0x000000b0a500720bULL, 0x002fce0003f9d000ULL,
0x0000007e00877306ULL, 0x000fe20000209400ULL, 0x0000008c008c7245ULL, 0x004fce000020d400ULL,
0x0000007e00867306ULL, 0x0002a20000205400ULL, 0x0000008e8f00720bULL, 0x008fce0003fbd000ULL,
0x000000ad00ca7306ULL, 0x000fe20000209400ULL, 0x0000007e007e7245ULL, 0x002fca000020d400ULL,
0x000000018c8c5812ULL, 0x000fe400078efcffULL, 0x000000ad00cb7306ULL, 0x0002e20000205400ULL,
0x000000868700720bULL, 0x004fe40003f5d000ULL, 0x0000003c00877245ULL, 0x000fe4000020d400ULL,
0x0000009d00867245ULL, 0x000fe4000020d400ULL, 0x0000000187870812ULL, 0x000fe200078efcffULL,
0x0000003d00937306ULL, 0x000fe20000009400ULL, 0x000000ad00ad7245ULL, 0x002fca000020d400ULL,
0x000000017e7e2812ULL, 0x000fe400078efcffULL, 0x0000003d00907306ULL, 0x000e620000005400ULL,
0x000000cbca00720bULL, 0x008fe40003f7d000ULL, 0x000000877e87723eULL, 0x000fca00000010ffULL,
0x0000004c007c7306ULL, 0x000fec0000009400ULL, 0x00000001adad3812ULL, 0x000fe400078efcffULL,
0x0000004c00807306ULL, 0x000ea20000005400ULL, 0x000000909300720bULL, 0x002fce0003fdd000ULL,
0x0000003e008b7306ULL, 0x000ff00000009400ULL, 0x0000003e008a7306ULL, 0x000fe20000005400ULL,
0x000000807c00720bULL, 0x004fe40003f1d000ULL, 0x0000000a007c7245ULL, 0x000fc8000020d400ULL,
0x000000017c7c4812ULL, 0x000fe200078efcffULL, 0x0000003e00597306ULL, 0x000ff0000000d400ULL,
0x0000003f00817306ULL, 0x000ff00000009400ULL, 0x0000003f007f7306ULL, 0x000ff00000005400ULL,
0x0000003f00557306ULL, 0x000ff0000000d400ULL, 0x00000094003e7306ULL, 0x000ff00000209400ULL,
0x00000094003f7306ULL, 0x0002b00000205400ULL, 0x0000009d00a17306ULL, 0x000fe20000209400ULL,
0x0000009400947245ULL, 0x002fce000020d400ULL, 0x0000009d00a27306ULL, 0x000e620000205400ULL,
0x0000003f3e00720bULL, 0x004fce0003f9d000ULL, 0x0000003d005e7306ULL, 0x000eac000000d400ULL,
0x0000000194944812ULL, 0x000fe400078efcffULL, 0x0000009e00cc7306ULL, 0x000fe20000209400ULL,
0x000000a2a100720bULL, 0x002fe40003fbd000ULL, 0x000000d000a17245ULL, 0x000fca000020d400ULL,
0x0000009e00cd7306ULL, 0x0002e20000205400ULL, 0x000000015e5e6812ULL, 0x004fc800078efcffULL,
0x0000005e889d723eULL, 0x000fe400000010ffULL, 0x0000000186865812ULL, 0x000fe200078efcffULL,
0x0000000900a67306ULL, 0x000fe20000209400ULL, 0x0000009e009e7245ULL, 0x002fe4000020d400ULL,
0x0000007f8100720bULL, 0x000fe40003fbd000ULL, 0x00000009007f7245ULL, 0x000fe4000020d400ULL,
0x000000868586723eULL, 0x000fe200000010ffULL, 0x0000000900a37306ULL, 0x0002a20000205400ULL,
0x000000cdcc00720bULL, 0x008fce0003f7d000ULL, 0x0000007500737306ULL, 0x000fe20000209400ULL,
0x0000b80047097811ULL, 0x002fe400078e20ffULL, 0x0000000800477245ULL, 0x000fe4000020d400ULL,
0x0000000155555812ULL, 0x000fe400078efcffULL, 0x000000019e9e3812ULL, 0x000fe200078efcffULL,
0x0000007500707306ULL, 0x0002e20000205400ULL, 0x000000a3a600720bULL, 0x004fe40003fdd000ULL,
0x0000008a8b00720bULL, 0x000fc40003f7d000ULL, 0x0000009e8caf723eULL, 0x000fc600000010ffULL,
0x00000008003d7306ULL, 0x000fe20000209400ULL, 0x0000007500757245ULL, 0x002fca000020d400ULL,
0x000000017f7f6812ULL, 0x000fe400078efcffULL, 0x0000000800a47306ULL, 0x0002a20000205400ULL,
0x000000707300720bULL, 0x008fe40003f9d000ULL, 0x0000000159593812ULL, 0x000fca00078efcffULL,
0x0000006500747306ULL, 0x000fe20000209400ULL, 0x000000000908783bULL, 0x002e6a0000000200ULL,
0x0000000175754812ULL, 0x000fe400078efcffULL, 0x0000006500717306ULL, 0x000ee20000205400ULL,
0x000000a43d00720bULL, 0x004fe40003fdd000ULL, 0x000000007a3c783bULL, 0x000eaa0000000200ULL,
0x0000004e00777306ULL, 0x000fec0000009400ULL, 0x0000000147476812ULL, 0x000fc400078efcffULL,
0x0000004e00787306ULL, 0x000fe20000005400ULL, 0x000000717400720bULL, 0x008fce0003f9d000ULL,
0x0000004e00497306ULL, 0x000ff0000000d400ULL, 0x0000006d007d7306ULL, 0x000fe20000209400ULL,
0x0000003408089231ULL, 0x082fe400003400ffULL, 0x000000340a0a9231ULL, 0x000fc400003400ffULL,
0x0000003509099231ULL, 0x080fe400003400ffULL, 0x000000350b0b9231ULL, 0x080fe200003400ffULL,
0x0000006d00827306ULL, 0x0002e20000205400ULL, 0x000000343c3c9231ULL, 0x084fe400003400ffULL,
0x000000343e3e9231ULL, 0x000fe400003400ffULL, 0x000000353d3d9231ULL, 0x000fc600003400ffULL,
0x00000095004e7306ULL, 0x000fe20000209400ULL, 0x0000006d006d7245ULL, 0x002fe2000020d400ULL,
0x000000353f3f9231ULL, 0x000fcc00003400ffULL, 0x00000095009f7306ULL, 0x0002a20000205400ULL,
0x000000827d00720bULL, 0x008fe20003f7d000ULL, 0x000000aa3c20723cULL, 0x040fec0000041820ULL,
0x000000d300897306ULL, 0x000fe20000209400ULL, 0x0000009500957245ULL, 0x002fe2000020d400ULL,
0x000000b63c1c723cULL, 0x000fe8000004181cULL, 0x000000016d6d3812ULL, 0x000fc400078efcffULL,
0x000000d3008b7306ULL, 0x0002e20000205400ULL, 0x0000009f4e00720bULL, 0x004fe20003fdd000ULL,
0x000000ae3c14723cULL, 0x040f620000041814ULL, 0x00000065004e7245ULL, 0x000fe4000020d400ULL,
0x00000061ad65723eULL, 0x000fe400000010ffULL, 0x000000014e4e4812ULL, 0x000fe200078efcffULL,
0x0000004d00837306ULL, 0x000fe20000009400ULL, 0x000000d300d37245ULL, 0x002fe2000020d400ULL,
0x0000009c3c10723cULL, 0x000fe80000041810ULL, 0x0000000195956812ULL, 0x000fc400078efcffULL,
0x0000004d00847306ULL, 0x000e620000005400ULL, 0x0000008b8900720bULL, 0x008fe20003f9d000ULL,
0x000000643c38723cULL, 0x000f620000041838ULL, 0x000000787700720bULL, 0x000fca0003fdd000ULL,
0x000000a000b37306ULL, 0x000fe40000209400ULL, 0x000000863c0c723cULL, 0x000f68000004180cULL,
0x00000001d3d34812ULL, 0x000fe400078efcffULL, 0x000000a000b97306ULL, 0x0004e20000205400ULL,
0x000000848300720bULL, 0x002fe40003f5d000ULL, 0x0000000149496812ULL, 0x000fca00078efcffULL,
0x0000004c00547306ULL, 0x000322000000d400ULL, 0x000000a000a07245ULL, 0x004fce000020d400ULL,
0x0000004f00767306ULL, 0x000fe20000009400ULL, 0x000000b9b300720bULL, 0x008fe20003f7d000ULL,
0x00010000414c7824ULL, 0x002fcc00078e00ffULL, 0x0000004f00727306ULL, 0x000e620000005400ULL,
0x0000000154540812ULL, 0x010fc800078efcffULL, 0x000000549554723eULL, 0x000fe400000010ffULL,
0x00000001a0a03812ULL, 0x000fe200078efcffULL, 0x0000005c005f7306ULL, 0x000fe60000209400ULL,
0x000000a075a0723eULL, 0x000fca00000010ffULL, 0x0000005c00607306ULL, 0x0004e20000205400ULL,
0x000000727600720bULL, 0x002fce0003f1d000ULL, 0x0000006e00797306ULL, 0x000fe20000209400ULL,
0x0000005c005c7245ULL, 0x004fce000020d400ULL, 0x0000006e007b7306ULL, 0x0002a20000205400ULL,
0x000000605f00720bULL, 0x008fce0003f9d000ULL, 0x0000004d00517306ULL, 0x000722000000d400ULL,
0x0000006e006e7245ULL, 0x002fca000020d400ULL, 0x000000015c5c4812ULL, 0x000fe400078efcffULL,
0x000000d1008e7306ULL, 0x000fe20000209400ULL, 0x0000007b7900720bULL, 0x004fe20003fbd000ULL,
0x00010000404d7824ULL, 0x008fcc00078e00ffULL, 0x000000d1008a7306ULL, 0x0002a20000205400ULL,
0x0000000151512812ULL, 0x010fca00078efcffULL, 0x000000016e6e5812ULL, 0x000fe400078efcffULL,
0x00000040006f7306ULL, 0x000fe20000009400ULL, 0x000000d100d17245ULL, 0x002fce000020d400ULL,
0x00000040006c7306ULL, 0x000e620000005400ULL, 0x0000008a8e00720bULL, 0x004fce0003f5d000ULL,
0x0000009b00707306ULL, 0x000fec0000209400ULL, 0x00000001d1d12812ULL, 0x000fe400078efcffULL,
0x0000009b00727306ULL, 0x0004e20000205400ULL, 0x0000006c6f00720bULL, 0x002fce0003f7d000ULL,
0x0000004100677306ULL, 0x000fe20000009400ULL, 0x0000009b009b7245ULL, 0x004fce000020d400ULL,
0x0000004100667306ULL, 0x000e620000005400ULL, 0x000000727000720bULL, 0x008fce0003f9d000ULL,
0x000000d200817306ULL, 0x000fec0000209400ULL, 0x000000019b9b4812ULL, 0x000fe400078efcffULL,
0x000000d200807306ULL, 0x0004e20000205400ULL, 0x000000666700720bULL, 0x002fe40003f3d000ULL,
0x00000018ff677819ULL, 0x000fc4000001144cULL, 0x000000476d4c723eULL, 0x000fc600000010ffULL,
0x000000cf00b27306ULL, 0x000fe20000209400ULL, 0x000000d200d27245ULL, 0x004fce000020d400ULL,
0x000000cf00997306ULL, 0x0002a20000205400ULL, 0x000000808100720bULL, 0x008fce0003fdd000ULL,
0x0000004f00447306ULL, 0x000722000000d400ULL, 0x000000cf00cf7245ULL, 0x002fca000020d400ULL,
0x00000001d2d26812ULL, 0x000fe400078efcffULL, 0x0000004300637306ULL, 0x000fe20000009400ULL,
0x00000100414f7824ULL, 0x008fe200078e00ffULL, 0x00000099b200720bULL, 0x004fe40003fbd000ULL,
0x000000d25c5c723eULL, 0x000fe400000010ffULL, 0x00000018ff6c7819ULL, 0x000fe4000001144fULL,
0x0000004300627306ULL, 0x000e620000005400ULL, 0x00000018ff4f7819ULL, 0x000fc4000001144dULL,
0x0000000144440812ULL, 0x010fe400078efcffULL, 0x000000946e4d723eULL, 0x000fe400000010ffULL,
0x00000001cfcf5812ULL, 0x000fe200078efcffULL, 0x00000056005b7306ULL, 0x000ff00000209400ULL,
0x00000056005a7306ULL, 0x0004e20000205400ULL, 0x000000626300720bULL, 0x002fce0003f5d000ULL,
0x0000006c006f7306ULL, 0x000fe20000209400ULL, 0x0000005600567245ULL, 0x004fce000020d400ULL,
0x0000006c006b7306ULL, 0x0002a20000205400ULL, 0x0000005a5b00720bULL, 0x008fce0003f1d000ULL,
0x000000b4007a7306ULL, 0x000fe20000209400ULL, 0x0000006c006c7245ULL, 0x002fca000020d400ULL,
0x0000000156560812ULL, 0x000fe400078efcffULL, 0x000000b400797306ULL, 0x000e620000205400ULL,
0x0000006b6f00720bULL, 0x004fce0003f9d000ULL, 0x000000d000977306ULL, 0x000fec0000209400ULL,
0x000000016c6c4812ULL, 0x000fe400078efcffULL, 0x000000d000907306ULL, 0x000ea20000205400ULL,
0x000000797a00720bULL, 0x002fce0003fdd000ULL, 0x0000004100317306ULL, 0x0002ec000000d400ULL,
0x000000015d5d6812ULL, 0x000fe400078efcffULL, 0x0000006700627306ULL, 0x000fe20000209400ULL,
0x0000010042417824ULL, 0x002fe200078e00ffULL, 0x000000909700720bULL, 0x004fc40003fbd000ULL,
0x0000005d565d723eULL, 0x000fe400000010ffULL, 0x00000018ff5f7819ULL, 0x000fe40000011441ULL,
0x0000006700617306ULL, 0x000e620000205400ULL, 0x000000557c41723eULL, 0x000fe400000010ffULL,
0x0000000131311812ULL, 0x008fe200078efcffULL, 0x0000005c0814723cULL, 0x060fe20000041814ULL,
0x00000051cf55723eULL, 0x000fe400000010ffULL, 0x00000001a1a15812ULL, 0x000fe200078efcffULL,
0x0000004000367306ULL, 0x0004e6000000d400ULL, 0x000000a14ea1723eULL, 0x000fe200000010ffULL,
0x000000540820723cULL, 0x000fe80000041820ULL, 0x0000002e004b7306ULL, 0x000fe20000209400ULL,
0x0000010043407824ULL, 0x004fe200078e00ffULL, 0x000000616200720bULL, 0x002fc40003f3d000ULL,
0x000000a0081c723cULL, 0x000fe4000004181cULL, 0x00000018ff5b7819ULL, 0x000fe40000011440ULL,
0x0000002e00507306ULL, 0x0002a20000205400ULL, 0x000000597f40723eULL, 0x000fe400000010ffULL,
0x0000000136363812ULL, 0x008fc800078efcffULL, 0x000000369b36723eULL, 0x000fe200000010ffULL,
0x0000004f006a7306ULL, 0x000fe20000209400ULL, 0x000000403c04723cULL, 0x000f620000041804ULL,
0x0000002e002e7245ULL, 0x002fcc000020d400ULL, 0x0000004f00667306ULL, 0x0002e20000205400ULL,
0x0000004c3c3c723cULL, 0x000b620000041818ULL, 0x000000504b00720bULL, 0x004fcc0003f9d000ULL,
0x0000004500577306ULL, 0x000fe20000209400ULL, 0x00000049d118723eULL, 0x020fe400000010ffULL,
0x00000044d319723eULL, 0x000fe400000010ffULL, 0x0000004f004f7245ULL, 0x002fe4000020d400ULL,
0x000000012e2e4812ULL, 0x000fe200078efcffULL, 0x0000004500587306ULL, 0x0002a20000205400ULL,
0x000000666a00720bULL, 0x008fe20003f7d000ULL, 0x000000180818723cULL, 0x000b6c0000041838ULL,
0x0000004200697306ULL, 0x000fe20000009400ULL, 0x0000006700397245ULL, 0x020fc4000020d400ULL,
0x0000004500457245ULL, 0x002fe4000020d400ULL, 0x0000000139391812ULL, 0x000fe400078efcffULL,
0x000000014f4f3812ULL, 0x000fe200078efcffULL, 0x0000004200687306ULL, 0x000e620000005400ULL,
0x000000585700720bULL, 0x004fce0003fdd000ULL, 0x0000003200537306ULL, 0x000fec0000209400ULL,
0x0000000145456812ULL, 0x000fe400078efcffULL, 0x0000003200527306ULL, 0x0004e20000205400ULL,
0x000000686900720bULL, 0x002fe40003fbd000ULL, 0x0000004f4538723eULL, 0x000fca00000010ffULL,
0x0000004200307306ULL, 0x000322000000d400ULL, 0x0000003200327245ULL, 0x004fce000020d400ULL,
0x00000043002f7306ULL, 0x000522000000d400ULL, 0x0001000042427824ULL, 0x002fe200078e00ffULL,
0x000000525300720bULL, 0x008fc80003f1d000ULL, 0x00000018ff427819ULL, 0x000fe40000011442ULL,
0x0000005b00597306ULL, 0x000fe20000209400ULL, 0x0001000043437824ULL, 0x004fe200078e00ffULL,
0x0000000130305812ULL, 0x010fc800078efcffULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0x0000005b00477306ULL, 0x000e620000205400ULL, 0x0000000132320812ULL, 0x000fe400078efcffULL,
0x000000012f2f2812ULL, 0x000fe400078efcffULL, 0x000000393239723eULL, 0x000fc600000010ffULL,
0x0000002c00377306ULL, 0x000fe80000209400ULL, 0x00000038080c723cULL, 0x000b68000004180cULL,
0x0000002c00467306ULL, 0x0004e20000205400ULL, 0x000000475900720bULL, 0x002fce0003f3d000ULL,
0x0000005f005e7306ULL, 0x000fe20000209400ULL, 0x0000002c002c7245ULL, 0x004fce000020d400ULL,
0x0000005f005a7306ULL, 0x0002a20000205400ULL, 0x000000463700720bULL, 0x008fe40003f7d000ULL,
0x000000316c37723eULL, 0x000fe400000010ffULL, 0x0000005b00317245ULL, 0x000fc6000020d400ULL,
0x0000004200407306ULL, 0x000fe20000209400ULL, 0x0000000131311812ULL, 0x000fe200078efcffULL,
0x000000360810723cULL, 0x000b620000041810ULL, 0x0000005f005f7245ULL, 0x002fe4000020d400ULL,
0x0000002f3131723eULL, 0x000fe400000010ffULL, 0x00000043002f7245ULL, 0x000fe2000020d400ULL,
0x0000004200417306ULL, 0x0002e20000205400ULL, 0x0000005a5e00720bULL, 0x004fe40003fdd000ULL,
0x000000012c2c3812ULL, 0x000fca00078efcffULL, 0x00000043004b7306ULL, 0x000fe20000209400ULL,
0x0000004200427245ULL, 0x002fca000020d400ULL, 0x000000015f5f6812ULL, 0x000fe400078efcffULL,
0x0000004300447306ULL, 0x000e620000205400ULL, 0x000000414000720bULL, 0x008fe40003f1d000ULL,
0x000000305f30723eULL, 0x000fce00000010ffULL, 0x000000300804723cULL, 0x000b680000041804ULL,
0x0000000142420812ULL, 0x000fe400078efcffULL, 0x000000444b00720bULL, 0x002fe40003fbd000ULL,
0x000000422e2e723eULL, 0x000fd600000010ffULL, 0x000000012f2f5812ULL, 0x000fc800078efcffULL,
0x0000002f2c2f723eULL, 0x000fce00000010ffULL, 0x0000002e0808723cULL, 0x000b62000004183cULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff2e7f8cULL, 0x020e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a000ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000022d2c7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4b7224ULL, 0x002fc400078e002fULL, 0x000000012b2b7810ULL, 0x000fc80007ffe0ffULL,
0x000000262b00720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xfffe7b7000007947ULL, 0x000fea000383ffffULL, 0x000000ff2600720cULL, 0x000fe20003f05270ULL,
0x000000ffff2a7224ULL, 0x008fe400078e000fULL, 0x000000ffff287224ULL, 0x000fe400078e000eULL,
0x000000ffff247224ULL, 0x000fe400078e0013ULL, 0x000000ffff327224ULL, 0x000fe400078e000bULL,
0x000000ffff317224ULL, 0x000fe400078e000aULL, 0x000000ffff307224ULL, 0x000fc400078e0009ULL,
0x000000ffff2f7224ULL, 0x000fe400078e0008ULL, 0x000000ffff2e7224ULL, 0x000fe400078e0007ULL,
0x000000ffff2d7224ULL, 0x000fe400078e0006ULL, 0x000000ffff2c7224ULL, 0x000fe400078e0005ULL,
0x000000ffff2b7224ULL, 0x000fe400078e0004ULL, 0x000000ffff267224ULL, 0x000fc400078e000dULL,
0x000000ffff257224ULL, 0x000fe400078e000cULL, 0x000000ffff137224ULL, 0x000fe400078e0012ULL,
0x000000ffff0f7224ULL, 0x000fe400078e0011ULL, 0x000000ffff0e7224ULL, 0x000fe200078e0010ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x0180000029007810ULL, 0x000fe20007ffe0ffULL,
0x000000c000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x000000ffff037224ULL, 0x000fe200078e0029ULL, 0x000197f000047802ULL, 0x000fc40000000f00ULL,
0x00007ba000007944ULL, 0x006fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000002900007308ULL, 0x000ee40000001000ULL, 0xbf80000000297423ULL, 0x008fc80000000029ULL,
0x800000ff29297221ULL, 0x000fc80000010100ULL, 0x0000002900007223ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006800ff047624ULL, 0x000fe400078e00ffULL,
0x00006900ff057624ULL, 0x000fca00078e00ffULL, 0x0000000604047981ULL, 0x0088e8000c1e9900ULL,
0x0000000000057919ULL, 0x010f240000000000ULL, 0x00000002ff037819ULL, 0x016fe40000011605ULL,
0x0000000805057811ULL, 0x000fe200078ff0ffULL, 0x0000000004007220ULL, 0x008fca0000410000ULL,
0x00001f0300037589ULL, 0x000e6800000e0000ULL, 0x00001f0500007589ULL, 0x000ea200000e0000ULL,
0x0000002003207220ULL, 0x042fe20000410000ULL, 0x0000002103217220ULL, 0x040fe20000410000ULL,
0x0000001c031c7220ULL, 0x040fe20000410000ULL, 0x0000001d031d7220ULL, 0x040fe20000410000ULL,
0x0000001803187220ULL, 0x040fe20000410000ULL, 0x0000001903197220ULL, 0x040fe20000410000ULL,
0x0000001403147220ULL, 0x040fe20000410000ULL, 0x0000001503157220ULL, 0x040fe20000410000ULL,
0x0000000e030e7220ULL, 0x040fe20000410000ULL, 0x0000000f030f7220ULL, 0x040fe20000410000ULL,
0x0000002503257220ULL, 0x040fe20000410000ULL, 0x0000002603267220ULL, 0x040fe20000410000ULL,
0x0000002b032b7220ULL, 0x040fe20000410000ULL, 0x0000002c032c7220ULL, 0x040fe20000410000ULL,
0x0000002f032f7220ULL, 0x040fe20000410000ULL, 0x0000003003307220ULL, 0x000fe20000410000ULL,
0x0000002200227220ULL, 0x044fe20000410000ULL, 0x0000002300237220ULL, 0x040fe20000410000ULL,
0x0000001e001e7220ULL, 0x040fe20000410000ULL, 0x0000001f001f7220ULL, 0x040fe20000410000ULL,
0x0000001a001a7220ULL, 0x040fe20000410000ULL, 0x0000001b001b7220ULL, 0x040fe20000410000ULL,
0x0000001600167220ULL, 0x040fe20000410000ULL, 0x0000001700177220ULL, 0x040fe20000410000ULL,
0x0000001300137220ULL, 0x040fe20000410000ULL, 0x0000002400247220ULL, 0x040fe20000410000ULL,
0x0000002800287220ULL, 0x040fe20000410000ULL, 0x0000002a002a7220ULL, 0x040fe20000410000ULL,
0x0000002d002d7220ULL, 0x040fe20000410000ULL, 0x0000002e002e7220ULL, 0x040fe20000410000ULL,
0x0000003100317220ULL, 0x040fe20000410000ULL, 0x0000003200327220ULL, 0x000fc20000410000ULL,
0x0000000000297919ULL, 0x000ee20000000000ULL, 0x00000000000579c3ULL, 0x000f220000002700ULL,
0x0000580000047ab9ULL, 0x000fc40000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x00000002ff047819ULL, 0x008fc60000011629ULL,
0x00000005040472a4ULL, 0x010fe2000f8e023fULL, 0x0000000229007812ULL, 0x040fe400078ec0ffULL,
0x0000000829057811ULL, 0x000fe200078ff0ffULL, 0x0000000804077824ULL, 0x000fe200078e00ffULL,
0x0000000400037211ULL, 0x000fe200078ff8ffULL, 0x0000000804087824ULL, 0x000fe200078e00ffULL,
0x0000000500067211ULL, 0x000fe200078ff8ffULL, 0x0000000805097824ULL, 0x000fe200078e00ffULL,
0x0000000203007810ULL, 0x040fe20007ffe0ffULL, 0x00000008040a7824ULL, 0x040fe200078e00ffULL,
0x0000000403057810ULL, 0x000fe20007ffe0ffULL, 0x00000008040b7824ULL, 0x000fe200078e00ffULL,
0xfffffff807047812ULL, 0x000fc400078ee203ULL, 0x0000000603037810ULL, 0x000fe40007ffe0ffULL,
0xfffffff809097812ULL, 0x000fe400078ee206ULL, 0xfffffff808067812ULL, 0x000fe400078ee200ULL,
0xfffffff80b087812ULL, 0x000fe200078ee203ULL, 0x0000000829037824ULL, 0x000fe200078e00ffULL,
0xfffffff80a077812ULL, 0x000fe400078ee205ULL, 0x0000a00002057811ULL, 0x000fc400078e58ffULL,
0x0000000803037812ULL, 0x000fe400078ec0ffULL, 0x000000202100723eULL, 0x000fe200000010ffULL,
0x0000001004047824ULL, 0x100fe200078e0205ULL, 0x0000001c1d02723eULL, 0x000fe200000010ffULL,
0x0000001009097824ULL, 0x000fe200078e0205ULL, 0x00000003ff0b7819ULL, 0x000fe20000011629ULL,
0x0000000104047824ULL, 0x000fe200078e0203ULL, 0x00005410000c7816ULL, 0x100fe20000000002ULL,
0x0000001006067824ULL, 0x100fe200078e0205ULL, 0x00007632000d7816ULL, 0x000fe20000000002ULL,
0x0000001007007824ULL, 0x100fe200078e0205ULL, 0x0000002029107810ULL, 0x000fe20007ffe0ffULL,
0x0000001008027824ULL, 0x000fc400078e0205ULL, 0x0000000c04007388ULL, 0x0007e20000000a00ULL,
0x00000003ff117819ULL, 0x000fe20000011610ULL, 0x00000001030a7824ULL, 0x040fe400078e0209ULL,
0x0000000103077824ULL, 0x040fe400078e0206ULL, 0x0000000103087824ULL, 0x000fe200078e0200ULL,
0x000000181900723eULL, 0x000fe200000010ffULL, 0x0000000103097824ULL, 0x000fe200078e0202ULL,
0x000000141502723eULL, 0x000fe400000010ffULL, 0x0000000e0f03723eULL, 0x000fe200000010ffULL,
0x000000010b047824ULL, 0x008fe200078e0229ULL, 0x00005410000e7816ULL, 0x100fe20000000002ULL,
0x00000001100c7824ULL, 0x000fe200078e0211ULL, 0x00007632000f7816ULL, 0x000fc40000000002ULL,
0x0000000704047812ULL, 0x000fe400078ec0ffULL, 0x000000070c0c7812ULL, 0x000fe200078ec0ffULL,
0x0000000e07007388ULL, 0x000fe20000000a00ULL, 0x0ffffff804067812ULL, 0x000fe400078ef829ULL,
0x000000252604723eULL, 0x000fe400000010ffULL, 0x0ffffff80c0d7812ULL, 0x000fe200078ef810ULL,
0x00000010060c7824ULL, 0x000fe200078e0205ULL, 0x0000541003027816ULL, 0x000fc40000000004ULL,
0x0000763203037816ULL, 0x000fe20000000004ULL, 0x000000100d127824ULL, 0x000fe200078e0205ULL,
0x0000002b2c00723eULL, 0x000fe400000010ffULL, 0x0000001e1f04723eULL, 0x000fe200000010ffULL,
0x0000000208007388ULL, 0x0007e20000000a00ULL, 0x0000001a1b05723eULL, 0x000fe400000010ffULL,
0x000000161706723eULL, 0x000fe400000010ffULL, 0x0000000729297812ULL, 0x000fc400078ec0ffULL,
0x0000000710107812ULL, 0x000fc800078ec0ffULL, 0x1ffffff810107812ULL, 0x000fe400078ef827ULL,
0x0000002f3002723eULL, 0x008fe400000010ffULL, 0x000000222303723eULL, 0x000fe400000010ffULL,
0x00005410000e7816ULL, 0x140fe40000000002ULL, 0x00007632000f7816ULL, 0x000fe40000000002ULL,
0x0000541003027816ULL, 0x000fc40000000004ULL, 0x0000763203037816ULL, 0x000fe20000000004ULL,
0x0000000e09007388ULL, 0x000fe20000000a00ULL, 0x0000541005047816ULL, 0x140fe40000000006ULL,
0x0000763205057816ULL, 0x000fe20000000006ULL, 0x000000020a007388ULL, 0x0007e20000000a00ULL,
0x000000132400723eULL, 0x000fc600000010ffULL, 0x0004000407007388ULL, 0x0009e20000000a00ULL,
0x000000282a02723eULL, 0x008fe400000010ffULL, 0x0000002d2e03723eULL, 0x000fe200000010ffULL,
0x0000000000057919ULL, 0x010ee20000002600ULL, 0x000000313204723eULL, 0x000fe400000010ffULL,
0x0000541000067816ULL, 0x140fe40000000002ULL, 0x0000763200077816ULL, 0x000fe40000000002ULL,
0x0000541003027816ULL, 0x000fc40000000004ULL, 0x0000763203037816ULL, 0x000fe20000000004ULL,
0x0004000608007388ULL, 0x000fe80000000a00ULL, 0x0004000209007388ULL, 0x0009e20000000a00ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000000000c0c7984ULL, 0x000ea20000000c00ULL,
0x0000000805007824ULL, 0x008fc600078e00ffULL, 0x0000000012147984ULL, 0x000ee20000000c00ULL,
0x0000000805057824ULL, 0x000fe200078e00ffULL, 0xfffffff8000b7812ULL, 0x000fc800078ee20bULL,
0xfffffff805117812ULL, 0x000fe400078ee211ULL, 0x000000040b0b7c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000411117c10ULL, 0x000fc6000ff3e0ffULL, 0x000000ffff007224ULL, 0x000fe200000e06ffULL,
0x00005a000b027a11ULL, 0x010fe200078048ffULL, 0x000000ffff057224ULL, 0x000fe200008e06ffULL,
0x00005a0011047a11ULL, 0x000fe400078248ffULL, 0x00005b000b037a11ULL, 0x000fe400000f4c00ULL,
0x1ffffff829007812ULL, 0x000fe400078ef827ULL, 0x00005b0011057a11ULL, 0x000fc600008f4c05ULL,
0x0000001000027825ULL, 0x000fc800078e0002ULL, 0x0000001010047825ULL, 0x000fe200078e0004ULL,
0x0000000c02007986ULL, 0x004fe8000c101d06ULL, 0x0000001404007986ULL, 0x008fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff277819ULL, 0x000fe20000011602ULL,
0xffffffffff387424ULL, 0x000fc600078e00ffULL, 0x000000252700720cULL, 0x000fda0003f06070ULL,
0x000000023e048824ULL, 0x002fc800078e00ffULL, 0x0000640004048a24ULL, 0x000fc800078e0227ULL,
0x0000600004048625ULL, 0x000fe200078e0005ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000604388981ULL, 0x0002a2000c1e1900ULL, 0x000001ff0600780cULL, 0x000fe20003f04070ULL,
0x0000008000007824ULL, 0x000fe400078e00ffULL, 0x00000040023a7824ULL, 0x000fe400078e00ffULL,
0x00006800ff047624ULL, 0x002fe400078e00ffULL, 0x00006900ff057624ULL, 0x000fe400078e00ffULL,
0x0000008039397824ULL, 0x000fc600078e00ffULL, 0x00000006043f7981ULL, 0x000322000c1e9900ULL,
0x00000040000c7812ULL, 0x000fc600078ef83aULL, 0x01060000ff047f8cULL, 0x002e62000c80043fULL,
0x0000003938177224ULL, 0x004fe200078e02ffULL, 0x0000071000000947ULL, 0x000fea0003800000ULL,
0x00000002ff187819ULL, 0x002fe40000011603ULL, 0x000000300e167812ULL, 0x000fe400078ec0ffULL,
0x0000000818197810ULL, 0x000fe20007ffe0ffULL, 0x000000010c067824ULL, 0x000fe200078e0218ULL,
0x00000010181a7810ULL, 0x040fe40007ffe0ffULL, 0x00000018181b7810ULL, 0x000fe20007ffe0ffULL,
0x000000010c077824ULL, 0x040fe200078e0219ULL, 0x0000000617157210ULL, 0x000fe20007f1e0ffULL,
0x000000010c067824ULL, 0x000fe200078e021aULL, 0x00002000020e7811ULL, 0x000fc400078e68ffULL,
0x0000000717147210ULL, 0x040fe20007f3e0ffULL, 0x000000010c077824ULL, 0x000fe200078e021bULL,
0x00000006170b7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff097224ULL, 0x000fe200000e06ffULL,
0x00005e0015117a11ULL, 0x000fe200078040ffULL, 0x000000ffff087224ULL, 0x000fe200008e06ffULL,
0x00005e0014107a11ULL, 0x000fe400078240ffULL, 0x0000000717137210ULL, 0x000fe40007f7e0ffULL,
0x0000003a24067217ULL, 0x000fc40007800000ULL, 0x00005f0015157a11ULL, 0x000fe200000f4409ULL,
0x000000ffff097224ULL, 0x000fe200010e06ffULL, 0x00005e000b0a7a11ULL, 0x000fe200078040ffULL,
0x00000001060d7824ULL, 0x000fe200078e0a3aULL, 0x00005f0014147a11ULL, 0x000fe200008f4408ULL,
0x000000ffff087224ULL, 0x000fe200018e06ffULL, 0x0000000303077211ULL, 0x000fe400078fe8ffULL,
0x00005e0013127a11ULL, 0x000fe400078240ffULL, 0x00005f000b0b7a11ULL, 0x000fe200000f4409ULL,
0x0000000419097824ULL, 0x000fe200078e00ffULL, 0x0000001116067210ULL, 0x000fe20007f7e0ffULL,
0x000000041a117824ULL, 0x000fe200078e00ffULL, 0x00000003070f7812ULL, 0x000fc400078ec0ffULL,
0x00005f0013137a11ULL, 0x000fe200008f4408ULL, 0x000000ffff077224ULL, 0x000fe200018e0615ULL,
0x0000000d1800720cULL, 0x080fe40003f06070ULL, 0x0000000d1900720cULL, 0x080fe40003f26070ULL,
0x0ffffffc0f037812ULL, 0x000fe400078ef803ULL, 0xfffffffc09097812ULL, 0x000fe400078ee20fULL,
0x0000001610087210ULL, 0x080fe20007f7e0ffULL, 0x0000001003037824ULL, 0x100fe200078e020eULL,
0x000000160a0a7210ULL, 0x000fe20007f9e0ffULL, 0x0000001009107824ULL, 0x000fe200078e020eULL,
0x0000000d1a00720cULL, 0x080fe20003f46070ULL, 0x000000ffff097224ULL, 0x000fe200018e0614ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006037faeULL, 0x0003e2000c101c46ULL,
0x000000ffff0b7224ULL, 0x000fe200020e060bULL, 0x0000000d1b00720cULL, 0x040fe20003f86070ULL,
0x000000041b1b7824ULL, 0x000fe200078e00ffULL, 0x0000000008107faeULL, 0x0005e2000c901c46ULL,
0xfffffffc11117812ULL, 0x000fca00078ee20fULL, 0x0000001011117824ULL, 0x000fe200078e020eULL,
0x0000001612067210ULL, 0x002fc80007fbe0ffULL, 0x000000000a117faeULL, 0x0003e2000d101c46ULL,
0x0000002018087810ULL, 0x044fe40007ffe0ffULL, 0x0000002818097810ULL, 0x040fe40007ffe0ffULL,
0x0000003818107810ULL, 0x000fe20007ffe0ffULL, 0x000000010c037824ULL, 0x000fe200078e0208ULL,
0x0000000d0800720cULL, 0x080fe40003f66070ULL, 0x0000000d0900720cULL, 0x000fe40003f46070ULL,
0x0000000317157210ULL, 0x000fe20007f1e0ffULL, 0x000000010c0a7824ULL, 0x002fe200078e0209ULL,
0xfffffffc1b037812ULL, 0x000fc400078ee20fULL, 0x00005e0015147a11ULL, 0x000fe200078c40ffULL,
0x000000ffff077224ULL, 0x000fe200000e06ffULL, 0x00000030180b7810ULL, 0x000fe20007ffe0ffULL,
0x0000001003037824ULL, 0x000fe200078e020eULL, 0x0000000d1000720cULL, 0x080fe40003f06070ULL,
0x00005f0015157a11ULL, 0x000fe200030f4407ULL, 0x000000ffff077224ULL, 0x000fe200028e0613ULL,
0x0000000a170a7210ULL, 0x000fe40007fbe0ffULL, 0x0000000d0b00720cULL, 0x000fe20003f26070ULL,
0x000000010c0d7824ULL, 0x000fe200078e020bULL, 0x0000000006037faeULL, 0x0003e2000e101c46ULL,
0x000000ffff137224ULL, 0x000fe200028e06ffULL, 0x00005e000a127a11ULL, 0x000fe200078a40ffULL,
0x000000010c0c7824ULL, 0x000fe200078e0210ULL, 0x0000000d17117210ULL, 0x000fc40007f9e0ffULL,
0x00005f000a137a11ULL, 0x000fe400028f4413ULL, 0x0000000c170d7210ULL, 0x000fe20007fde0ffULL,
0x0000000409067824ULL, 0x002fe400078e00ffULL, 0x0000000408037824ULL, 0x000fe400078e00ffULL,
0x000000040b077824ULL, 0x000fe200078e00ffULL, 0xfffffffc06067812ULL, 0x100fe200078ee20fULL,
0x0000000410087824ULL, 0x000fe200078e00ffULL, 0xfffffffc03037812ULL, 0x100fe200078ee20fULL,
0x000000ffff0b7224ULL, 0x000fe200020e06ffULL, 0xfffffffc07077812ULL, 0x100fe200078ee20fULL,
0x000000ffff097224ULL, 0x000fe200030e06ffULL, 0xfffffffc08087812ULL, 0x000fe200078ee20fULL,
0x00000010060f7824ULL, 0x100fe200078e020eULL, 0x0000001614067210ULL, 0x080fe20007fbe0ffULL,
0x0000001003037824ULL, 0x100fe200078e020eULL, 0x00005e00110a7a11ULL, 0x000fe200078840ffULL,
0x0000001007107824ULL, 0x100fe200078e020eULL, 0x00005e000d0c7a11ULL, 0x000fe200078c40ffULL,
0x00000010080e7824ULL, 0x000fe200078e020eULL, 0x00005f00110b7a11ULL, 0x000fe200020f440bULL,
0x000000ffff077224ULL, 0x000fe200028e0615ULL, 0x0000001612087210ULL, 0x000fc40007fbe0ffULL,
0x00005f000d0d7a11ULL, 0x000fe400030f4409ULL, 0x000000160a0a7210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff097224ULL, 0x000fe200028e0613ULL, 0x000000160c0c7210ULL, 0x000fe20007fbe0ffULL,
0x0000000006037faeULL, 0x0003e4000d901c46ULL, 0x000000ffff0b7224ULL, 0x000fe400020e060bULL,
0x000000ffff0d7224ULL, 0x000fe200028e060dULL, 0x00000000080f7faeULL, 0x0003e8000d101c46ULL,
0x000000000a107faeULL, 0x0003e8000c901c46ULL, 0x000000000c0e7faeULL, 0x0003e2000c101c46ULL,
0x0000065000007947ULL, 0x000fea0003800000ULL, 0x0000000c03067211ULL, 0x042fe400078ff0ffULL,
0x0000000803167811ULL, 0x000fc400078ff0ffULL, 0x0000000617067210ULL, 0x000fe40007f1e0ffULL,
0x0000001003077811ULL, 0x040fe400078ff0ffULL, 0x0000001803097811ULL, 0x040fe200078ff0ffULL,
0x000000ffff217224ULL, 0x000fe200000e06ffULL, 0x00005e0006207a11ULL, 0x000fe200078040ffULL,
0x000000010c087824ULL, 0x040fe200078e0207ULL, 0x0000000303157211ULL, 0x040fe200078fe8ffULL,
0x000000010c0a7824ULL, 0x000fe200078e0209ULL, 0x00005f0006217a11ULL, 0x000fe200000f4421ULL,
0x000000010c067824ULL, 0x000fe200078e0216ULL, 0x00000020030b7811ULL, 0x040fe200078ff0ffULL,
0x0000000416167824ULL, 0x000fe200078e00ffULL, 0x00000028030f7811ULL, 0x000fc400078ff0ffULL,
0x00000006171f7210ULL, 0x000fe20007fde0ffULL, 0x0000000407067824ULL, 0x000fe200078e00ffULL,
0x0000003003117811ULL, 0x000fe200078ff0ffULL, 0x0000000409077824ULL, 0x000fe200078e00ffULL,
0x0000003803137811ULL, 0x000fe200078ff0ffULL, 0x000000010c0d7824ULL, 0x040fe200078e020bULL,
0x0000000315157812ULL, 0x000fe200078ec0ffULL, 0x000000040f097824ULL, 0x000fe200078e00ffULL,
0x0000000817147210ULL, 0x040fe20007fbe0ffULL, 0x000000010c107824ULL, 0x000fe200078e020fULL,
0x0000000a171d7210ULL, 0x000fe20007f1e0ffULL, 0x000000040b087824ULL, 0x000fe200078e00ffULL,
0x0000200002197811ULL, 0x000fe200078e68ffULL, 0x000000010c127824ULL, 0x000fe200078e0211ULL,
0xfffffffc07077812ULL, 0x100fe200078ee215ULL, 0x00000004110a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc06067812ULL, 0x000fe200078ee215ULL, 0x000000ffff0f7224ULL, 0x000fe200030e06ffULL,
0x00005e001f1e7a11ULL, 0x000fe200078c40ffULL, 0x000000010c0c7824ULL, 0x000fe200078e0213ULL,
0x0000000d171b7210ULL, 0x000fe20007f3e0ffULL, 0x00000004130b7824ULL, 0x000fe200078e00ffULL,
0xfffffffc09097812ULL, 0x000fe200078ee215ULL, 0x0000001007117824ULL, 0x000fe200078e0219ULL,
0xfffffffc08087812ULL, 0x100fe200078ee215ULL, 0x000000ffff077224ULL, 0x000fe200000e06ffULL,
0xfffffffc0a0a7812ULL, 0x000fc400078ee215ULL, 0x00005f001f1f7a11ULL, 0x000fe200030f440fULL,
0x00000010060f7824ULL, 0x100fe200078e0219ULL, 0x00000010171a7210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff067224ULL, 0x000fe200008e06ffULL, 0x00000012170d7210ULL, 0x040fe20007f7e0ffULL,
0x000000100a187824ULL, 0x100fe200078e0219ULL, 0x0000000c170c7210ULL, 0x000fe20007f9e0ffULL,
0x0000001009177824ULL, 0x000fe200078e0219ULL, 0x0ffffffc15107812ULL, 0x000fe200078ef803ULL,
0x000000ffff137224ULL, 0x000fe200018e06ffULL, 0x00005e001d1c7a11ULL, 0x000fc400078040ffULL,
0xfffffffc16037812ULL, 0x000fe200078ee215ULL, 0x0000001008167824ULL, 0x000fe200078e0219ULL,
0x00005e001b097a11ULL, 0x000fe200078240ffULL, 0x000000ffff087224ULL, 0x000fe200028e06ffULL,
0xfffffffc0b0b7812ULL, 0x000fe200078ee215ULL, 0x0000001010237824ULL, 0x100fe200078e0219ULL,
0x000000300e227812ULL, 0x000fe200078ec0ffULL, 0x0000001003037824ULL, 0x100fe200078e0219ULL,
0x00005e00140a7a11ULL, 0x000fe200078a40ffULL, 0x000000100b197824ULL, 0x000fe200078e0219ULL,
0x00005f001d1d7a11ULL, 0x000fe200000f4407ULL, 0x000000ffff077224ULL, 0x000fe200010e06ffULL,
0x00005f001b1b7a11ULL, 0x000fe200008f4406ULL, 0x000000ffff157224ULL, 0x000fe200020e06ffULL,
0x00005e001a107a11ULL, 0x000fc400078240ffULL, 0x0000002022067210ULL, 0x000fe40007f1e0ffULL,
0x00005f00140b7a11ULL, 0x000fe400028f4408ULL, 0x00005e000d127a11ULL, 0x000fe400078440ffULL,
0x00005e000c147a11ULL, 0x000fe400078640ffULL, 0x00005f001a1a7a11ULL, 0x000fe200008f4407ULL,
0x000000ffff077224ULL, 0x000fe200000e0621ULL, 0x0000001e22087210ULL, 0x000fc40007f1e0ffULL,
0x00005f000d137a11ULL, 0x000fe400010f4413ULL, 0x00005f000c157a11ULL, 0x000fe200018f4415ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006237faeULL, 0x0003e2000b901c46ULL,
0x0000000a220a7210ULL, 0x040fe40007f3e0ffULL, 0x0000001c220c7210ULL, 0x040fe40007f5e0ffULL,
0x00000009220e7210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff097224ULL, 0x000fe200000e061fULL,
0x0000001022107210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200008e060bULL,
0x0000001222127210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff0d7224ULL, 0x000fe200010e061dULL,
0x0000001422147210ULL, 0x000fe20007f1e0ffULL, 0x0000000008037faeULL, 0x0003e4000b901c46ULL,
0x000000ffff137224ULL, 0x000fc400028e0613ULL, 0x000000000a0f7faeULL, 0x0005e2000b901c46ULL,
0x000000ffff157224ULL, 0x000fc600000e0615ULL, 0x000000000c117faeULL, 0x0007e2000b901c46ULL,
0x000000ffff0f7224ULL, 0x004fe400018e061bULL, 0x000000ffff117224ULL, 0x008fc600020e061aULL,
0x000000000e167faeULL, 0x0003e8000b901c46ULL, 0x0000000010177faeULL, 0x0003e8000b901c46ULL,
0x0000000012187faeULL, 0x0003e8000b901c46ULL, 0x0000000014197faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000067805ULL, 0x002fc40000015200ULL,
0x01060400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fc40007804805ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x0000000806087210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e07ULL, 0x003d09000800780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400800780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011409ULL,
0x0000000803037211ULL, 0x000fca00078110ffULL, 0x000000ffff087224ULL, 0x000fca00000e0609ULL,
0x0000000203037819ULL, 0x000fc80000001208ULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01060400ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e640000000000ULL, 0x0000002002037824ULL, 0x002fca00078e0203ULL,
0x00000003ff047819ULL, 0x000fe40000011603ULL, 0x0000000f03037812ULL, 0x000fe400078ec0ffULL,
0x1ffffffe04047812ULL, 0x000fe400078ec0ffULL, 0x0000000103057810ULL, 0x040fe20007ffe0ffULL,
0x0000002003097824ULL, 0x040fe400078e00ffULL, 0x0000000103067824ULL, 0x040fe400078e0204ULL,
0x0000000104077824ULL, 0x040fe200078e0205ULL, 0x0000001004047810ULL, 0x000fe20007ffe0ffULL,
0x0000002003087824ULL, 0x000fe200078e00ffULL, 0x0000001f06067812ULL, 0x000fc400078ec0ffULL,
0x0000001f07077812ULL, 0x000fe200078ec0ffULL, 0x0000000103107824ULL, 0x000fe200078e0204ULL,
0x000001e008067812ULL, 0x000fe200078ee206ULL, 0x0000000105047824ULL, 0x000fe200078e0204ULL,
0x000001e009077812ULL, 0x000fe200078ee207ULL, 0x0000002003057824ULL, 0x040fe200078e00ffULL,
0x0000001f10107812ULL, 0x000fe200078ec0ffULL, 0x00000000060c7984ULL, 0x000e62000000cc00ULL,
0x0000002003037824ULL, 0x000fe200078e00ffULL, 0x0000001f04047812ULL, 0x000fe400078ec0ffULL,
0x0000000007087984ULL, 0x000ea2000000cc00ULL, 0x000001e005107812ULL, 0x000fc400078ee210ULL,
0x000001e003047812ULL, 0x000fe200078ee204ULL, 0x000000ffff147224ULL, 0x002fe400078e000cULL,
0x000000ffff157224ULL, 0x000fe400078e000eULL, 0x000000ffff177224ULL, 0x004fe400078e000aULL,
0x000000ffff167224ULL, 0x000fe400078e0008ULL, 0x000000ffff0a7224ULL, 0x000fe400078e0009ULL,
0x000000ffff087224ULL, 0x000fe200078e000dULL, 0x0000001406007388ULL, 0x000fe2000000cc00ULL,
0x000000ffff097224ULL, 0x000fca00078e000fULL, 0x0000000807007388ULL, 0x000fe8000000cc00ULL,
0x0000000004087984ULL, 0x000e68000000cc00ULL, 0x00000000100c7984ULL, 0x000ea2000000cc00ULL,
0x000000ffff1b7224ULL, 0x002fe400078e000aULL, 0x000000ffff1a7224ULL, 0x000fc400078e0008ULL,
0x000000ffff0a7224ULL, 0x000fe400078e0009ULL, 0x000000ffff187224ULL, 0x004fe400078e000cULL,
0x000000ffff197224ULL, 0x000fe400078e000eULL, 0x000000ffff087224ULL, 0x000fe400078e000dULL,
0x000000ffff097224ULL, 0x000fe200078e000fULL, 0x0000001810007388ULL, 0x0003e8000000cc00ULL,
0x0000000804007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01060000ff087f8cULL, 0x002e62000c80043fULL, 0x000000ffff0a7224ULL, 0x000fc600078e00ffULL,
0x0000000000047805ULL, 0x000fc80000015200ULL, 0x01060400ff037984ULL, 0x000ea40000000800ULL,
0x8000000003ff7812ULL, 0x006fc40007804809ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604067210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000600780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400600780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011407ULL,
0x0000000603037211ULL, 0x000fca00078110ffULL, 0x000000ffff067224ULL, 0x000fca00000e0607ULL,
0x0000000203037819ULL, 0x000fc80000001206ULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01060400ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff2600720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0x000064003e3e7a24ULL, 0x000fe200078e02ffULL,
0x3d8000003f3f7820ULL, 0x010fe20000410000ULL, 0x0001068802407811ULL, 0x000fe200078e18ffULL,
0x000000ffff437224ULL, 0x000fe200078e00ffULL, 0xffffffff26417810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff447224ULL, 0x000fe200078e00ffULL, 0x0001060802427811ULL, 0x000fc400078e28ffULL,
0x0000010043457824ULL, 0x000fe200078e023aULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x000000452400720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x01cfea0003800000ULL,
0x000000ffff467224ULL, 0x000fe200078e0044ULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x000000ffff477224ULL, 0x000fe200078e00ffULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fc4000001ff00ULL,
0x0000000147287810ULL, 0x020fe20007ffe0ffULL, 0x00000d8000007945ULL, 0x000fe20003800000ULL,
0x000000ffff487224ULL, 0x000fe200078e0047ULL, 0x0000000146447812ULL, 0x000fe200078e0cffULL,
0x0000003938377224ULL, 0x010fe200078e02ffULL, 0x0000004328297211ULL, 0x040fe200078ff0ffULL,
0x000000ffff477224ULL, 0x000fe200078e0028ULL, 0x000000042800780cULL, 0x000fc40003f06070ULL,
0x00000001292a7810ULL, 0x040fe20007ffe0ffULL, 0x00000100293b7824ULL, 0x000fe200078e023aULL,
0x0000000328557812ULL, 0x000fe400078ec0ffULL, 0x000000262a00720cULL, 0x000fe40003f26070ULL,
0x000000403b297812ULL, 0x000fca00078ec0ffULL, 0x0000000100327824ULL, 0x000fcc00078e0229ULL,
0x000006b000009947ULL, 0x000fea0003800000ULL, 0x00000002ff337819ULL, 0x002fe20000011603ULL,
0x00000002023d7824ULL, 0x000fe200078e0244ULL, 0x0000003b24297217ULL, 0x000fe40007800000ULL,
0x00000010334f7810ULL, 0x040fe20007ffe0ffULL, 0x0000000133287824ULL, 0x140fe200078e0232ULL,
0x00000008333c7810ULL, 0x000fe20007ffe0ffULL, 0x00000001293b7824ULL, 0x000fe200078e0a3bULL,
0x0000001833507810ULL, 0x000fe20007ffe0ffULL, 0x000000014f2b7824ULL, 0x100fe200078e0232ULL,
0x0000002837307210ULL, 0x000fe20007f3e0ffULL, 0x000000013c2a7824ULL, 0x040fe200078e0232ULL,
0x0000002033517810ULL, 0x000fe20007ffe0ffULL, 0x000000043c4a7824ULL, 0x000fe200078e00ffULL,
0x0000002b372d7210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff317224ULL, 0x000fe200008e06ffULL,
0x0000002a372f7210ULL, 0x000fc40007f5e0ffULL, 0x00005e0030287a11ULL, 0x000fe200078240ffULL,
0x000000ffff2e7224ULL, 0x000fe200018e06ffULL, 0x00005e002d2c7a11ULL, 0x000fe200078640ffULL,
0x000000ffff2b7224ULL, 0x000fe200010e06ffULL, 0x00005e002f2a7a11ULL, 0x000fe400078440ffULL,
0x00005f002d2d7a11ULL, 0x000fe200018f442eULL, 0x00000001502e7824ULL, 0x000fe200078e0232ULL,
0x0000002833527810ULL, 0x040fe40007ffe0ffULL, 0x0000003033537810ULL, 0x000fc40007ffe0ffULL,
0x0000003833547810ULL, 0x000fe40007ffe0ffULL, 0x00005f0030297a11ULL, 0x000fe200008f4431ULL,
0x0000000152307824ULL, 0x100fe200078e0232ULL, 0x00005f002f2b7a11ULL, 0x000fe200010f442bULL,
0x00000001512f7824ULL, 0x100fe200078e0232ULL, 0x0000002e37367210ULL, 0x000fe20007f3e0ffULL,
0x0000000153317824ULL, 0x100fe200078e0232ULL, 0x0000003b3300720cULL, 0x000fe20003f46070ULL,
0x0000000154327824ULL, 0x000fe200078e0232ULL, 0x0000002f37347210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff2f7224ULL, 0x000fe200008e06ffULL, 0x0000003037337210ULL, 0x000fc40007fde0ffULL,
0x0000000303307211ULL, 0x000fe400078fe8ffULL, 0x00005e00362e7a11ULL, 0x000fe200078240ffULL,
0x000000ffff4d7224ULL, 0x000fe200030e06ffULL, 0x0000003137357210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff317224ULL, 0x000fe200028e06ffULL, 0x0000003237377210ULL, 0x000fe20007f7e0ffULL,
0x0000000455327824ULL, 0x000fe200078e00ffULL, 0x00000003304e7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff4c7224ULL, 0x000fe200020e06ffULL, 0x00005f00362f7a11ULL, 0x000fe200008f442fULL,
0x000000ffff4b7224ULL, 0x000fe200018e06ffULL, 0x0000003b3c00720cULL, 0x000fc40003f26070ULL,
0x000020003d3d7811ULL, 0x000fe400078e60ffULL, 0x0ffffffc4e497812ULL, 0x100fe400078ef803ULL,
0xfffffffc323c7812ULL, 0x000fe400078ee203ULL, 0xfffffffc4a4a7812ULL, 0x000fe200078ee24eULL,
0x0000001049497824ULL, 0x000fe200078e023dULL, 0x00005e0034307a11ULL, 0x000fe200078a40ffULL,
0x000000103c287825ULL, 0x000fe200078e0028ULL, 0x00005e0037367a11ULL, 0x000fc400078840ffULL,
0x00005f0034317a11ULL, 0x000fe200028f4431ULL, 0x000000104a4a7824ULL, 0x000fe200078e023dULL,
0x00005e0033327a11ULL, 0x000fe200078a40ffULL, 0x000000103c2a7825ULL, 0x000fe200078e002aULL,
0x00005e0035347a11ULL, 0x000fe200078640ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028497faeULL, 0x0003e2000d101c46ULL, 0x00005f0033337a11ULL, 0x000fe400028f444dULL,
0x00005f0035357a11ULL, 0x000fe200018f444cULL, 0x000000002a4a7faeULL, 0x0005e2000c901c46ULL,
0x00005f0037377a11ULL, 0x000fe200020f444bULL, 0x00000004524b7824ULL, 0x000fe200078e00ffULL,
0x0000003b4f00720cULL, 0x080fe20003f26070ULL, 0x00000004534c7824ULL, 0x000fe200078e00ffULL,
0x0000003b5000720cULL, 0x000fc40003f46070ULL, 0x0000003b5100720cULL, 0x080fe20003f66070ULL,
0x0000000450497824ULL, 0x002fe200078e00ffULL, 0x0000003b5200720cULL, 0x080fe20003f86070ULL,
0x000000103c287825ULL, 0x000fe200078e002cULL, 0x0000003b5300720cULL, 0x080fe40003fa6070ULL,
0x0000003b5400720cULL, 0x040fe20003fc6070ULL, 0x000000044f3b7824ULL, 0x000fe200078e00ffULL,
0xfffffffc49497812ULL, 0x100fe200078ee24eULL, 0x00000004514a7824ULL, 0x004fe200078e00ffULL,
0xfffffffc4b4b7812ULL, 0x100fe200078ee24eULL, 0x0000000454547824ULL, 0x000fe200078e00ffULL,
0xfffffffc3b3b7812ULL, 0x100fe200078ee24eULL, 0x0000001049497824ULL, 0x000fe200078e023dULL,
0xfffffffc4a4a7812ULL, 0x000fe200078ee24eULL, 0x000000103c2a7825ULL, 0x000fe200078e002eULL,
0xfffffffc4c4c7812ULL, 0x000fc400078ee24eULL, 0xfffffffc544e7812ULL, 0x000fe200078ee24eULL,
0x000000103b3b7824ULL, 0x100fe400078e023dULL, 0x000000104a4a7824ULL, 0x000fe400078e023dULL,
0x000000103c2c7825ULL, 0x040fe200078e0030ULL, 0x00000000283b7faeULL, 0x0003e6000c901c46ULL,
0x000000104b4b7824ULL, 0x000fe200078e023dULL, 0x000000002a497faeULL, 0x0003e2000d101c46ULL,
0x000000103c2e7825ULL, 0x000fc600078e0032ULL, 0x000000002c4a7faeULL, 0x0003e2000d901c46ULL,
0x000000104c4c7824ULL, 0x000fe400078e023dULL, 0x000000103c307825ULL, 0x000fe200078e0034ULL,
0x000000002e4b7faeULL, 0x0003e6000e101c46ULL, 0x000000104e3d7824ULL, 0x000fe200078e023dULL,
0x00000000304c7faeULL, 0x0003e2000e901c46ULL, 0x000000103c327825ULL, 0x000fca00078e0036ULL,
0x00000000323d7faeULL, 0x0003e2000f101c46ULL, 0x000005f000007947ULL, 0x000fea0003800000ULL,
0x00000008032e7811ULL, 0x002fe200078ff0ffULL, 0x0000000455517824ULL, 0x000fe200078e00ffULL,
0x0000003203287211ULL, 0x040fe400078ff0ffULL, 0x00000010032f7811ULL, 0x000fe200078ff0ffULL,
0x000000012e297824ULL, 0x040fe200078e0232ULL, 0x00000028372d7210ULL, 0x000fe20007f3e0ffULL,
0x000000042e3b7824ULL, 0x000fe200078e00ffULL, 0x0000001803307811ULL, 0x000fe200078ff0ffULL,
0x000000042f3c7824ULL, 0x000fe200078e00ffULL, 0x00000029372b7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff297224ULL, 0x000fe200008e06ffULL, 0x00005e002d287a11ULL, 0x000fe200078240ffULL,
0x00000004303d7824ULL, 0x000fe200078e00ffULL, 0x0000002803347811ULL, 0x000fe200078ff0ffULL,
0x000000ffff2c7224ULL, 0x000fe200010e06ffULL, 0x00005e002b2a7a11ULL, 0x000fc400078440ffULL,
0x00005f002d297a11ULL, 0x000fe200008f4429ULL, 0x00000004344a7824ULL, 0x000fe200078e00ffULL,
0x00005f002b2b7a11ULL, 0x000fe200010f442cULL, 0x00000002022c7824ULL, 0x000fe200078e0244ULL,
0x00000003032d7211ULL, 0x040fe400078fe8ffULL, 0x0000002003317811ULL, 0x000fe400078ff0ffULL,
0x000020002c4c7811ULL, 0x000fe200078e60ffULL, 0x000000012f2c7824ULL, 0x100fe200078e0232ULL,
0x0000003003357811ULL, 0x040fe200078ff0ffULL, 0x00000001342f7824ULL, 0x100fe200078e0232ULL,
0x0000003803367811ULL, 0x000fe200078ff0ffULL, 0x00000001312e7824ULL, 0x100fe200078e0232ULL,
0x000000032d337812ULL, 0x000fe200078ec0ffULL, 0x00000001302d7824ULL, 0x100fe200078e0232ULL,
0x0000002c37347210ULL, 0x000fe20007f7e0ffULL, 0x0000000431497824ULL, 0x000fe200078e00ffULL,
0xfffffffc3b3b7812ULL, 0x100fe200078ee233ULL, 0x00000004354b7824ULL, 0x000fe200078e00ffULL,
0xfffffffc3c3c7812ULL, 0x100fe200078ee233ULL, 0x00000004364d7824ULL, 0x040fe200078e00ffULL,
0xfffffffc3d3d7812ULL, 0x100fe200078ee233ULL, 0x0000000135307824ULL, 0x100fe200078e0232ULL,
0xfffffffc49497812ULL, 0x100fe200078ee233ULL, 0x0000000136317824ULL, 0x000fe200078e0232ULL,
0x0000002d37327210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff2d7224ULL, 0x000fe200018e06ffULL,
0xfffffffc4a4a7812ULL, 0x100fe200078ee233ULL, 0x000000103b3b7824ULL, 0x100fe200078e024cULL,
0xfffffffc4b4b7812ULL, 0x100fe200078ee233ULL, 0x000000103c3c7824ULL, 0x100fe200078e024cULL,
0xfffffffc4d4d7812ULL, 0x000fe200078ee233ULL, 0x000000103d3d7824ULL, 0x100fe200078e024cULL,
0x0ffffffc33367812ULL, 0x100fe200078ef803ULL, 0x0000001049497824ULL, 0x100fe200078e024cULL,
0x0000002e37507210ULL, 0x040fe20007f3e0ffULL, 0x000000104a4a7824ULL, 0x100fe200078e024cULL,
0x0000002f37337210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff2f7224ULL, 0x000fe200010e06ffULL,
0xfffffffc51517812ULL, 0x000fe200078ee203ULL, 0x0000001036527824ULL, 0x100fe200078e024cULL,
0x0000003037357210ULL, 0x000fe20007f9e0ffULL, 0x000000104b4b7824ULL, 0x000fe200078e024cULL,
0x00005e00322e7a11ULL, 0x000fe200078440ffULL, 0x000000ffff4f7224ULL, 0x000fe200018e06ffULL,
0x00005e00342c7a11ULL, 0x000fe200078c40ffULL, 0x0000001051287825ULL, 0x000fe200078e0028ULL,
0x0000003137377210ULL, 0x000fc40007fbe0ffULL, 0x00005f00322f7a11ULL, 0x000fe200010f442fULL,
0x000000ffff317224ULL, 0x000fe200008e06ffULL, 0x00005e0050307a11ULL, 0x000fe200078240ffULL,
0x000000104d4c7824ULL, 0x000fe200078e024cULL, 0x00005f00342d7a11ULL, 0x000fe200030f442dULL,
0x000000ffff4e7224ULL, 0x000fe200020e06ffULL, 0x00005e0033327a11ULL, 0x000fe200078440ffULL,
0x000000ffff4d7224ULL, 0x000fe200028e06ffULL, 0x00005e0035347a11ULL, 0x000fe200078640ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028527faeULL, 0x0003e2000b901c46ULL,
0x00005e0037367a11ULL, 0x000fc400078840ffULL, 0x00005f0050317a11ULL, 0x000fe400008f4431ULL,
0x00005f0033337a11ULL, 0x000fe400010f444fULL, 0x00005f0035357a11ULL, 0x000fe400018f444eULL,
0x00005f0037377a11ULL, 0x000fe200020f444dULL, 0x0000001051287825ULL, 0x002fc800078e002aULL,
0x00000010512a7825ULL, 0x040fe200078e002cULL, 0x00000000283b7faeULL, 0x0003e6000b901c46ULL,
0x00000010512c7825ULL, 0x040fe200078e002eULL, 0x000000002a3c7faeULL, 0x0003e6000b901c46ULL,
0x00000010512e7825ULL, 0x040fe200078e0030ULL, 0x000000002c3d7faeULL, 0x0003e6000b901c46ULL,
0x0000001051307825ULL, 0x040fe200078e0032ULL, 0x000000002e497faeULL, 0x0003e6000b901c46ULL,
0x0000001051327825ULL, 0x040fe200078e0034ULL, 0x00000000304a7faeULL, 0x0003e6000b901c46ULL,
0x0000001051347825ULL, 0x000fe200078e0036ULL, 0x00000000324b7faeULL, 0x0003e8000b901c46ULL,
0x00000000344c7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000035500780cULL, 0x000fe20003f25270ULL, 0x000000a000007945ULL, 0x000fd80003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x0000000227277810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff387424ULL, 0x000fc600078e00ffULL, 0x000000252700720cULL, 0x000fda0003f26070ULL,
0x0000004000001947ULL, 0x000fea0003800000ULL, 0x000000023e287824ULL, 0x002fe400078e0227ULL,
0x00000004ff297424ULL, 0x000fc800078e00ffULL, 0x0000600028287625ULL, 0x000fca00078e0029ULL,
0x0000000628387981ULL, 0x000324000c1e1900ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000ffff497224ULL, 0x002fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xfffffff803287812ULL, 0x060fe200078ec0ffULL,
0x00000002022c7824ULL, 0x000fe200078e0246ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000020032d7810ULL, 0x000fe40007ffe0ffULL, 0x0000000728287812ULL, 0x000fe400078ef803ULL,
0x000020002c2c7811ULL, 0x000fe400078e60ffULL, 0x00000001ff297819ULL, 0x000fe20000011628ULL,
0x00000004282b7824ULL, 0x040fe200078e00ffULL, 0xfffffff82d2d7812ULL, 0x000fe200078ec0ffULL,
0x0000000428287824ULL, 0x000fe200078e00ffULL, 0x00000001493b7810ULL, 0x000fe20007ffe0ffULL,
0x00000001292a7824ULL, 0x000fe200078e0249ULL, 0x000000072d2d7812ULL, 0x000fc600078ef803ULL,
0x0000000129297824ULL, 0x000fe200078e023bULL, 0xfffffffc2b2a7812ULL, 0x000fe200078ee22aULL,
0x000000042d307824ULL, 0x040fe200078e00ffULL, 0x00000001ff2e7819ULL, 0x000fe2000001162dULL,
0x000000042d2d7824ULL, 0x000fe200078e00ffULL, 0xfffffffc28297812ULL, 0x000fe200078ee229ULL,
0x000000102a2a7824ULL, 0x100fe400078e022cULL, 0x000000012e2f7824ULL, 0x040fe400078e0249ULL,
0x0000001029297824ULL, 0x000fe200078e022cULL, 0x000000002a34783bULL, 0x000e620000000200ULL,
0x000000012e2e7824ULL, 0x000fe200078e023bULL, 0xfffffffc302f7812ULL, 0x000fc600078ee22fULL,
0x000000002928783bULL, 0x000fe20000000200ULL, 0xfffffffc2d2e7812ULL, 0x000fe200078ee22eULL,
0x000000102f2f7824ULL, 0x000fc800078e022cULL, 0x000000102e2e7824ULL, 0x000fe200078e022cULL,
0x000000002f30783bULL, 0x000eaa0000000200ULL, 0x000000002e2c783bULL, 0x000ee20000000200ULL,
0x0000003400b77306ULL, 0x002fe20000009400ULL, 0x00000018ffac7819ULL, 0x000fe20000011434ULL,
0x0001000034507824ULL, 0x000fe200078e00ffULL, 0x00000018ffa47819ULL, 0x000fe20000011435ULL,
0x0000010035c27824ULL, 0x000fe200078e00ffULL, 0x00000018ff9a7819ULL, 0x000fe20000011436ULL,
0x0000010036b07824ULL, 0x000fe200078e00ffULL, 0x00000018ffc37819ULL, 0x000fe20000011450ULL,
0x0000003400b57306ULL, 0x000e620000005400ULL, 0x00000018ffc27819ULL, 0x000fe200000114c2ULL,
0x0000010037ab7824ULL, 0x000fe200078e00ffULL, 0x00000018ffb07819ULL, 0x000fe200000114b0ULL,
0x0001000030bc7824ULL, 0x004fe200078e00ffULL, 0x00000018ff637819ULL, 0x000fe2000001142aULL,
0x000100002a7a7824ULL, 0x040fe200078e00ffULL, 0x00000018ffab7819ULL, 0x000fe200000114abULL,
0x0000003400687306ULL, 0x0004e2000000d400ULL, 0x000001002a787824ULL, 0x000fe200078e00ffULL,
0x00000018ffbc7819ULL, 0x000fe200000114bcULL, 0x0001000031bf7824ULL, 0x000fe200078e00ffULL,
0x00000018ff9c7819ULL, 0x000fe20000011431ULL, 0x0001000035bd7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6c7819ULL, 0x000fe20000011429ULL, 0x0001000029877824ULL, 0x000fe200078e00ffULL,
0x0000003500af7306ULL, 0x000fe20000009400ULL, 0x0000010034347824ULL, 0x004fe200078e00ffULL,
0x000000b5b700720bULL, 0x002fe20003f9d000ULL, 0x0000010029897824ULL, 0x000fe200078e00ffULL,
0x00000018ff4e7819ULL, 0x000fe2000001142bULL, 0x0001000036b87824ULL, 0x000fe200078e00ffULL,
0x00000018ffc67819ULL, 0x000fe20000011434ULL, 0x0000010033b77824ULL, 0x000fe200078e00ffULL,
0x0000003500ad7306ULL, 0x000e620000005400ULL, 0x00000018ff8d7819ULL, 0x000fe20000011437ULL,
0x0001000037ae7824ULL, 0x000fe200078e00ffULL, 0x00000018ffbd7819ULL, 0x000fe200000114bdULL,
0x0000010028887824ULL, 0x040fe200078e00ffULL, 0x00000018ff9f7819ULL, 0x000fe20000011430ULL,
0x0001000028827824ULL, 0x000fe200078e00ffULL, 0x0000000168684812ULL, 0x008fe200078efcffULL,
0x000000c600c77306ULL, 0x000fe20000209400ULL, 0x00000018ffbf7819ULL, 0x000fc400000114bfULL,
0x00000018ffb87819ULL, 0x000fe400000114b8ULL, 0x00000018ff8e7819ULL, 0x000fe40000011433ULL,
0x00000018ffb77819ULL, 0x000fe200000114b7ULL, 0x000000c600c87306ULL, 0x000ea20000205400ULL,
0x000000adaf00720bULL, 0x002fe40003f3d000ULL, 0x000000c600ad7245ULL, 0x000fe4000020d400ULL,
0x00000018ffae7819ULL, 0x000fc400000114aeULL, 0x00000018ff887819ULL, 0x000fe20000011488ULL,
0x000000ac00ba7306ULL, 0x000fe20000209400ULL, 0x00000018ff777819ULL, 0x000fe40000011428ULL,
0x00000018ff967819ULL, 0x000fe40000011432ULL, 0x00000018ff827819ULL, 0x000fe40000011482ULL,
0x00000018ff877819ULL, 0x000fe20000011487ULL, 0x000000ac00bb7306ULL, 0x0002e20000205400ULL,
0x000000c8c700720bULL, 0x004fc40003f7d000ULL, 0x00000018ff897819ULL, 0x000fe40000011489ULL,
0x00000018ff347819ULL, 0x000fe4000001142cULL, 0x00000018ff507819ULL, 0x000fe2000001142eULL,
0x000000c200cb7306ULL, 0x000fe20000209400ULL, 0x000000ac00ac7245ULL, 0x002fe4000020d400ULL,
0x00000018ff537819ULL, 0x000fe4000001142fULL, 0x00000018ff787819ULL, 0x000fc40000011478ULL,
0x00000001adad3812ULL, 0x000fe200078efcffULL, 0x000000c200cc7306ULL, 0x000e620000205400ULL,
0x000000bbba00720bULL, 0x008fe40003fdd000ULL, 0x00000018ff7a7819ULL, 0x000fca000001147aULL,
0x0000003700a37306ULL, 0x000fec0000009400ULL, 0x00000001acac6812ULL, 0x000fe400078efcffULL,
0x0000003700a27306ULL, 0x000ea20000005400ULL, 0x000000cccb00720bULL, 0x002fce0003f7d000ULL,
0x000000a400b37306ULL, 0x000ff00000209400ULL, 0x000000a400b97306ULL, 0x0002e20000205400ULL,
0x000000a2a300720bULL, 0x004fe40003fdd000ULL, 0x000000c200a27245ULL, 0x000fc8000020d400ULL,
0x00000001a2a23812ULL, 0x000fe200078efcffULL, 0x000000b000c17306ULL, 0x000fe20000209400ULL,
0x000000a400a47245ULL, 0x002fce000020d400ULL, 0x000000b000be7306ULL, 0x0002a20000205400ULL,
0x000000b9b300720bULL, 0x008fe20003f9d000ULL, 0x0001000032b37824ULL, 0x000fca00078e00ffULL,
0x00000018ffb37819ULL, 0x000fe200000114b3ULL, 0x000000c300c47306ULL, 0x000fe20000209400ULL,
0x000000b000b07245ULL, 0x002fca000020d400ULL, 0x00000001a4a44812ULL, 0x000fe400078efcffULL,
0x000000c300c57306ULL, 0x000e620000205400ULL, 0x000000bec100720bULL, 0x004fce0003f7d000ULL,
0x0000009a00a77306ULL, 0x000fec0000209400ULL, 0x00000001b0b03812ULL, 0x000fe400078efcffULL,
0x0000009a00aa7306ULL, 0x0004e20000205400ULL, 0x000000c5c400720bULL, 0x002fe20003f5d000ULL,
0x000100002bc47824ULL, 0x000fc400078e00ffULL, 0x000001002bc57824ULL, 0x000fc800078e00ffULL,
0x000000ab00b27306ULL, 0x000fe20000209400ULL, 0x0000009a009a7245ULL, 0x004fce000020d400ULL,
0x000000ab00b17306ULL, 0x0002a20000205400ULL, 0x000000aaa700720bULL, 0x008fe20003f9d000ULL,
0x0001000033aa7824ULL, 0x000fca00078e00ffULL, 0x00000018ffaa7819ULL, 0x000fe200000114aaULL,
0x0000003600a67306ULL, 0x000fe20000009400ULL, 0x000000ab00ab7245ULL, 0x002fca000020d400ULL,
0x000000019a9a4812ULL, 0x000fe400078efcffULL, 0x0000003600a57306ULL, 0x000fe20000005400ULL,
0x000000b1b200720bULL, 0x004fce0003f7d000ULL, 0x0000002a006d7306ULL, 0x000fec0000009400ULL,
0x00000001abab3812ULL, 0x000fe400078efcffULL, 0x0000002a006b7306ULL, 0x000ff00000005400ULL,
0x0000002a003c7306ULL, 0x0003f0000000d400ULL, 0x0000003100847306ULL, 0x000fe20000009400ULL,
0x00000100302a7824ULL, 0x002fca00078e00ffULL, 0x00000018ff2a7819ULL, 0x000fe4000001142aULL,
0x0000003100817306ULL, 0x000ff00000005400ULL, 0x00000031005e7306ULL, 0x0003f0000000d400ULL,
0x000000bc00cf7306ULL, 0x000fe20000209400ULL, 0x0000010031317824ULL, 0x002fce00078e00ffULL,
0x000000bc00d07306ULL, 0x000e700000205400ULL, 0x00000029006e7306ULL, 0x000ff00000009400ULL,
0x00000029006f7306ULL, 0x000fe20000005400ULL, 0x000000d0cf00720bULL, 0x002fce0003f9d000ULL,
0x00000029003d7306ULL, 0x0003f0000000d400ULL, 0x0000002b00697306ULL, 0x000fe20000009400ULL,
0x0000000448297824ULL, 0x002fe200078e0249ULL, 0x0000000249497810ULL, 0x000fc60007ffe0ffULL,
0x0000000229297824ULL, 0x000fc600078e00ffULL, 0x0000002b006a7306ULL, 0x000ff00000005400ULL,
0x0000002b004d7306ULL, 0x0003f0000000d400ULL, 0x0000002a00c07306ULL, 0x000fe20000209400ULL,
0x00000018ff2b7819ULL, 0x002fc40000011431ULL, 0x000000c300317245ULL, 0x000fc8000020d400ULL,
0x0000000131312812ULL, 0x000fe200078efcffULL, 0x0000002a00d17306ULL, 0x000e620000205400ULL,
0x000000a5a600720bULL, 0x000fe40003f5d000ULL, 0x000000bd00a57245ULL, 0x000fe4000020d400ULL,
0x000000683168723eULL, 0x000fc600000010ffULL, 0x0000003000907306ULL, 0x000ff00000009400ULL,
0x00000030008f7306ULL, 0x000fe20000005400ULL, 0x000000d1c000720bULL, 0x002fce0003f7d000ULL,
0x00000030005f7306ULL, 0x0003f0000000d400ULL, 0x0000003600647306ULL, 0x000ea2000000d400ULL,
0x0000000703307812ULL, 0x002fc800078ec0ffULL, 0x0000000830d27812ULL, 0x000fe400078ef803ULL,
0x0000000229307810ULL, 0x000fe20007ffe0ffULL, 0x0000008d009b7306ULL, 0x000fe20000209400ULL,
0x0000002903297211ULL, 0x040fe200078fe0ffULL, 0x00000020d2d37824ULL, 0x040fe200078e00ffULL,
0x0000003003307211ULL, 0x000fe200078fe0ffULL, 0x00000020d2d47824ULL, 0x040fe400078e00ffULL,
0x00000001d2297824ULL, 0x040fe400078e0229ULL, 0x0000008d00977306ULL, 0x0002e20000205400ULL,
0x00000001d2307824ULL, 0x000fe200078e0230ULL, 0x0000000164642812ULL, 0x004fc400078efcffULL,
0xffffffe0d3297812ULL, 0x000fe400078ee229ULL, 0xffffffe0d4307812ULL, 0x000fe400078ee230ULL,
0x000000bd00c97306ULL, 0x000fe20000209400ULL, 0x0000008d008d7245ULL, 0x002fe2000020d400ULL,
0x0000001029297824ULL, 0x000fcc00078e00ffULL, 0x000000bd00ca7306ULL, 0x000e620000205400ULL,
0x000000979b00720bULL, 0x008fce0003f5d000ULL, 0x0000003500677306ULL, 0x0004ec000000d400ULL,
0x000000018d8d2812ULL, 0x000fe400078efcffULL, 0x00000032007f7306ULL, 0x000fe20000009400ULL,
0x000000cac900720bULL, 0x002fe40003fbd000ULL, 0x00000018ff357819ULL, 0x004fc4000001142dULL,
0x000000ab8d8d723eULL, 0x000fc600000010ffULL, 0x0000003200807306ULL, 0x000fe20000005400ULL,
0x0000000167671812ULL, 0x008fca00078efcffULL, 0x00000001a5a55812ULL, 0x000fe400078efcffULL,
0x0000002800a07306ULL, 0x000ff00000009400ULL, 0x0000002800a17306ULL, 0x000e700000005400ULL,
0x00000033007b7306ULL, 0x000ff00000009400ULL, 0x00000033007c7306ULL, 0x000fe20000005400ULL,
0x000000a1a000720bULL, 0x002fe20003f3d000ULL, 0x0000010032a17824ULL, 0x000fca00078e00ffULL,
0x00000018ffa17819ULL, 0x000fe200000114a1ULL, 0x00000033005a7306ULL, 0x0003f0000000d400ULL,
0x000000bf00d27306ULL, 0x000fe20000209400ULL, 0x000000bc00337245ULL, 0x002fc8000020d400ULL,
0x0000000133334812ULL, 0x000fe400078efcffULL, 0x000000818400720bULL, 0x000fe20003f9d000ULL,
0x000000bf00b57306ULL, 0x000e620000205400ULL, 0x0000002a00847245ULL, 0x000fe4000020d400ULL,
0x000000bf00817245ULL, 0x000fe4000020d400ULL, 0x0000000184843812ULL, 0x000fe400078efcffULL,
0x000000807f00720bULL, 0x000fe20003f7d000ULL, 0x000000b800cd7306ULL, 0x000fe20000209400ULL,
0x0000002b00807245ULL, 0x000fc4000020d400ULL, 0x00000018ff7f7819ULL, 0x000fe400000114c4ULL,
0x000000015e5e4812ULL, 0x000fc600078efcffULL, 0x000000b800ce7306ULL, 0x000ea20000205400ULL,
0x000000b5d200720bULL, 0x002fce0003f5d000ULL, 0x00000032005d7306ULL, 0x0002ec000000d400ULL,
0x0000000181812812ULL, 0x000fe400078efcffULL, 0x000000b7002a7306ULL, 0x000fe20000209400ULL,
0x000000cecd00720bULL, 0x004fe40003fbd000ULL, 0x000000b800327245ULL, 0x002fc4000020d400ULL,
0x0000005e815e723eULL, 0x000fc600000010ffULL, 0x000000b7009b7306ULL, 0x0002a20000205400ULL,
0x000000015d5d3812ULL, 0x008fca00078efcffULL, 0x0000000132325812ULL, 0x000fe400078efcffULL,
0x000000b300a37306ULL, 0x000fe20000209400ULL, 0x000000b700b77245ULL, 0x002fce000020d400ULL,
0x000000b300a07306ULL, 0x0002e20000205400ULL, 0x0000009b2a00720bULL, 0x004fce0003f7d000ULL,
0x000000ae00b47306ULL, 0x000fe20000209400ULL, 0x000000b300b37245ULL, 0x002fca000020d400ULL,
0x00000001b7b73812ULL, 0x000fe400078efcffULL, 0x000000ae00b67306ULL, 0x0002a20000205400ULL,
0x000000a0a300720bULL, 0x008fce0003f5d000ULL, 0x00000028004f7306ULL, 0x000ee2000000d400ULL,
0x000000ae00ae7245ULL, 0x002fca000020d400ULL, 0x00000001b3b32812ULL, 0x000fe400078efcffULL,
0x0000003700607306ULL, 0x000e62000000d400ULL, 0x000000b6b400720bULL, 0x004fe40003fbd000ULL,
0x0000007c7b00720bULL, 0x000fca0003f5d000ULL, 0x0000008800917306ULL, 0x000fe20000209400ULL,
0x000000014f4f1812ULL, 0x008fca00078efcffULL, 0x00000001aeae5812ULL, 0x000fe400078efcffULL,
0x0000008800287306ULL, 0x0004e20000205400ULL, 0x0000000160606812ULL, 0x002fe400078efcffULL,
0x0000008f9000720bULL, 0x000fe40003fbd000ULL, 0x000000015a5a2812ULL, 0x000fc600078efcffULL,
0x0000009f00a87306ULL, 0x000fe20000209400ULL, 0x0000008800887245ULL, 0x004fce000020d400ULL,
0x0000009f00a97306ULL, 0x0002a20000205400ULL, 0x000000289100720bULL, 0x008fe20003f7d000ULL,
0x000001002f917824ULL, 0x000fe200078e00ffULL, 0x000000015f5f5812ULL, 0x000fc800078efcffULL,
0x00000018ff917819ULL, 0x000fe20000011491ULL, 0x000000a100a77306ULL, 0x000fe20000209400ULL,
0x0000009f009f7245ULL, 0x002fca000020d400ULL, 0x0000000188883812ULL, 0x000fe400078efcffULL,
0x000000a100977306ULL, 0x0002e20000205400ULL, 0x000000a9a800720bULL, 0x004fce0003fdd000ULL,
0x0000009c009d7306ULL, 0x000fe20000209400ULL, 0x000000a100a17245ULL, 0x002fca000020d400ULL,
0x000000019f9f6812ULL, 0x000fe400078efcffULL, 0x0000009c009e7306ULL, 0x0002a20000205400ULL,
0x00000097a700720bULL, 0x008fe40003f9d000ULL, 0x000000849f9f723eULL, 0x000fca00000010ffULL,
0x0000002b00af7306ULL, 0x000fe20000209400ULL, 0x0000009c009c7245ULL, 0x002fca000020d400ULL,
0x00000001a1a14812ULL, 0x000fe400078efcffULL, 0x0000002b00a67306ULL, 0x0002e20000205400ULL,
0x0000009e9d00720bULL, 0x004fe40003fdd000ULL, 0x0000006f6e00720bULL, 0x000fe20003f9d000ULL,
0x000100002c6f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6e7819ULL, 0x000fe400000114c5ULL,
0x0000005f339e723eULL, 0x000fe200000010ffULL, 0x0000008200927306ULL, 0x000fe20000209400ULL,
0x000000002928783bULL, 0x002e620000000200ULL, 0x00000018ff6f7819ULL, 0x000fc8000001146fULL,
0x000000019c9c6812ULL, 0x000fe400078efcffULL, 0x0000008200957306ULL, 0x0004a20000205400ULL,
0x000000a6af00720bULL, 0x008fe40003fbd000ULL, 0x000000013d3d4812ULL, 0x000fca00078efcffULL,
0x0000008700867306ULL, 0x000fe20000209400ULL, 0x0000008200827245ULL, 0x004fca000020d400ULL,
0x0000000180805812ULL, 0x000fe400078efcffULL, 0x00000087008a7306ULL, 0x0004e20000205400ULL,
0x000000959200720bULL, 0x000fe40003f5d000ULL, 0x000000809c5f723eULL, 0x000fca00000010ffULL,
0x000000aa008f7306ULL, 0x000fe20000209400ULL, 0x0000008700877245ULL, 0x004fca000020d400ULL,
0x0000000182822812ULL, 0x000fe400078efcffULL, 0x000000aa00907306ULL, 0x0004a20000205400ULL,
0x0000008a8600720bULL, 0x008fe20003f3d000ULL, 0x000100002d867824ULL, 0x040fe200078e00ffULL,
0x0000009e2810723cULL, 0x002fe20000041810ULL, 0x000001002d8a7824ULL, 0x000fe200078e00ffULL,
0x0000004f8282723eULL, 0x000fe400000010ffULL, 0x00000018ff867819ULL, 0x000fe20000011486ULL,
0x0000007700717306ULL, 0x000fe20000209400ULL, 0x000000aa00aa7245ULL, 0x004fc4000020d400ULL,
0x00000018ff8a7819ULL, 0x000fe2000001148aULL, 0x0000005e280c723cULL, 0x000fe4000004180cULL,
0x0000000187871812ULL, 0x000fe400078efcffULL, 0x0000007700727306ULL, 0x0002a20000205400ULL,
0x000000908f00720bULL, 0x000fe20003fdd000ULL, 0x000001002e8f7824ULL, 0x000fe400078e00ffULL,
0x000100002f907824ULL, 0x000fc600078e00ffULL, 0x00000018ff8f7819ULL, 0x000fe2000001148fULL,
0x0000009600997306ULL, 0x000fe20000209400ULL, 0x0000007700777245ULL, 0x002fe4000020d400ULL,
0x00000018ff907819ULL, 0x000fc60000011490ULL, 0x00000001aaaa6812ULL, 0x000fe400078efcffULL,
0x0000009600987306ULL, 0x0002e20000205400ULL, 0x000000727100720bULL, 0x004fe40003f5d000ULL,
0x0000005aaaaa723eULL, 0x000fca00000010ffULL, 0x0000006300757306ULL, 0x000fe20000209400ULL,
0x0000009600967245ULL, 0x002fca000020d400ULL, 0x0000000177772812ULL, 0x000fe400078efcffULL,
0x0000006300747306ULL, 0x0002a20000205400ULL, 0x000000989900720bULL, 0x008fce0003fbd000ULL,
0x00000089008b7306ULL, 0x000fe20000209400ULL, 0x0000006300637245ULL, 0x002fca000020d400ULL,
0x0000000196965812ULL, 0x000fe400078efcffULL, 0x00000089008c7306ULL, 0x0002e20000205400ULL,
0x000000747500720bULL, 0x004fe40003f3d000ULL, 0x0000006b6d00720bULL, 0x000fe40003fbd000ULL,
0x000000a19631723eULL, 0x000fc600000010ffULL, 0x0000002c00767306ULL, 0x000fe20000009400ULL,
0x0000008900897245ULL, 0x002fca000020d400ULL, 0x0000000163631812ULL, 0x000fe400078efcffULL,
0x0000002c00797306ULL, 0x000e620000005400ULL, 0x0000008c8b00720bULL, 0x008fe20003f7d000ULL,
0x000100002e8b7824ULL, 0x000fe200078e00ffULL, 0x00000060ae8c723eULL, 0x000fe400000010ffULL,
0x000000013c3c5812ULL, 0x000fe400078efcffULL, 0x00000018ff8b7819ULL, 0x000fe2000001148bULL,
0x0000002c003b7306ULL, 0x0004e4000000d400ULL, 0x0000008c2814723cULL, 0x000fe80000041814ULL,
0x0000000189893812ULL, 0x000fc400078efcffULL, 0x0000008e00937306ULL, 0x000fe20000209400ULL,
0x000001002c2c7824ULL, 0x004fe200078e00ffULL, 0x000000797600720bULL, 0x002fc80003f9d000ULL,
0x00000018ff727819ULL, 0x000fe4000001142cULL, 0x0000008e00947306ULL, 0x0002a20000205400ULL,
0x00000067a52c723eULL, 0x000fcc00000010ffULL, 0x000000013b3b4812ULL, 0x008fe200078efcffULL,
0x0000006c00737306ULL, 0x000fe20000209400ULL, 0x0000008e008e7245ULL, 0x002fce000020d400ULL,
0x0000006c00707306ULL, 0x0002e20000205400ULL, 0x000000949300720bULL, 0x004fce0003fdd000ULL,
0x0000002d00667306ULL, 0x000fe20000009400ULL, 0x0000006c006c7245ULL, 0x002fca000020d400ULL,
0x000000018e8e6812ULL, 0x000fe400078efcffULL, 0x0000002d00657306ULL, 0x000fe20000005400ULL,
0x000000707300720bULL, 0x008fe40003f5d000ULL, 0x0000006a6900720bULL, 0x000fe40003fdd000ULL,
0x000000adac69723eULL, 0x000fe400000010ffULL, 0x000000b78eab723eULL, 0x000fe200000010ffULL,
0x0000002d004c7306ULL, 0x0003e8000000d400ULL, 0x000000682818723cULL, 0x000fe40000041818ULL,
0x000000016c6c2812ULL, 0x000fc400078efcffULL, 0x0000007f00977306ULL, 0x000fe20000209400ULL,
0x000000a2a42d723eULL, 0x002fe400000010ffULL, 0x000000014d4d6812ULL, 0x000fe200078efcffULL,
0x000000aa2804723cULL, 0x040fe80000041804ULL, 0x0000007f007b7306ULL, 0x0002a80000205400ULL,
0x0000002c2820723cULL, 0x000b680000041820ULL, 0x0000002e00627306ULL, 0x000fe20000009400ULL,
0x0000007f007f7245ULL, 0x002fc4000020d400ULL, 0x00000010302c7824ULL, 0x020fe200078e00ffULL,
0x0000005db330723eULL, 0x000fc800000010ffULL, 0x0000002e00617306ULL, 0x000fe20000005400ULL,
0x0000007b9700720bULL, 0x004fe40003f3d000ULL, 0x000000302808723cULL, 0x000fea0000041808ULL,
0x0000002e004b7306ULL, 0x0003ec000000d400ULL, 0x000000017f7f1812ULL, 0x000fc400078efcffULL,
0x0000002f00587306ULL, 0x000fe20000009400ULL, 0x00000064322e723eULL, 0x002fce00000010ffULL,
0x0000002f00577306ULL, 0x000ff00000005400ULL, 0x0000002f004a7306ULL, 0x0003f0000000d400ULL,
0x00000078007d7306ULL, 0x000fe20000209400ULL, 0x000000b09a2f723eULL, 0x002fce00000010ffULL,
0x00000078007e7306ULL, 0x0002a20000205400ULL, 0x0000002e281c723cULL, 0x000b64000004181cULL,
0x000000002c2c783bULL, 0x020eea0000000200ULL, 0x0000007a00837306ULL, 0x000fe20000209400ULL,
0x0000007800787245ULL, 0x002fe4000020d400ULL, 0x0000004d7f2a723eULL, 0x000fc400000010ffULL,
0x0000003d8728723eULL, 0x000fe400000010ffULL, 0x000000896c29723eULL, 0x000fe200000010ffULL,
0x0000007a00857306ULL, 0x0002620000205400ULL, 0x0000007e7d00720bULL, 0x004fe40003f5d000ULL,
0x0000008a004d7245ULL, 0x000fca000020d400ULL, 0x0000004e00567306ULL, 0x000fe20000209400ULL,
0x0000007a007a7245ULL, 0x002fca000020d400ULL, 0x0000000178782812ULL, 0x000fe400078efcffULL,
0x0000004e00597306ULL, 0x0002a20000205400ULL, 0x000000858300720bULL, 0x000fe40003f7d000ULL,
0x000000616200720bULL, 0x000fe40003f5d000ULL, 0x000000887783723eULL, 0x000fe400000010ffULL,
0x00000078633d723eULL, 0x000fe200000010ffULL, 0x0000006e006b7306ULL, 0x000fe20000209400ULL,
0x0000004e004e7245ULL, 0x002fe2000020d400ULL, 0x000000282c20723cULL, 0x008b680000041820ULL,
0x000000017a7a3812ULL, 0x000fc400078efcffULL, 0x0000006e006d7306ULL, 0x0002e20000205400ULL,
0x000000595600720bULL, 0x004fe40003f3d000ULL, 0x000000656600720bULL, 0x000fe20003f7d000ULL,
0x000000822c18723cULL, 0x000f620000041818ULL, 0x000000014b4b2812ULL, 0x000fe400078efcffULL,
0x0000003c7a3c723eULL, 0x000fe200000010ffULL, 0x0000006f006a7306ULL, 0x000fe20000209400ULL,
0x0000006e006e7245ULL, 0x002fca000020d400ULL, 0x000000014e4e1812ULL, 0x000fe200078efcffULL,
0x0000003c2c1c723cULL, 0x000f62000004181cULL, 0x0000006f00717306ULL, 0x0002a20000205400ULL,
0x0000006d6b00720bULL, 0x008fe40003f9d000ULL, 0x000000014c4c3812ULL, 0x000fca00078efcffULL,
0x00000034005b7306ULL, 0x000fe20000209400ULL, 0x0000006f006f7245ULL, 0x002fca000020d400ULL,
0x000000016e6e4812ULL, 0x000fe400078efcffULL, 0x00000034005c7306ULL, 0x0002e20000205400ULL,
0x000000716a00720bULL, 0x004fe40003fbd000ULL, 0x0000006e4e2b723eULL, 0x000fca00000010ffULL,
0x00000072007c7306ULL, 0x000fe20000209400ULL, 0x0000003400347245ULL, 0x002fe2000020d400ULL,
0x0000002a2c14723cULL, 0x000f680000041814ULL, 0x000000016f6f5812ULL, 0x000fe400078efcffULL,
0x0000007200707306ULL, 0x0002a20000205400ULL, 0x0000005c5b00720bULL, 0x008fe40003fdd000ULL,
0x0000003b6f28723eULL, 0x020fca00000010ffULL, 0x0000008600737306ULL, 0x000fe20000209400ULL,
0x0000007200727245ULL, 0x002fca000020d400ULL, 0x0000000134346812ULL, 0x000fe400078efcffULL,
0x0000008600327306ULL, 0x0002e20000205400ULL, 0x000000707c00720bULL, 0x004fce0003fbd000ULL,
0x0000003500367306ULL, 0x000fe20000209400ULL, 0x0000008600867245ULL, 0x002fca000020d400ULL,
0x0000000172725812ULL, 0x000fe400078efcffULL, 0x0000003500377306ULL, 0x0002a20000205400ULL,
0x000000327300720bULL, 0x008fe40003f9d000ULL, 0x000000575800720bULL, 0x000fe40003fbd000ULL,
0x000000723429723eULL, 0x000fc600000010ffULL, 0x0000008a00647306ULL, 0x000fe20000209400ULL,
0x0000003500357245ULL, 0x002fc6000020d400ULL, 0x000000282c10723cULL, 0x000b640000041810ULL,
0x0000000186864812ULL, 0x000fe400078efcffULL, 0x0000008a00607306ULL, 0x000e620000205400ULL,
0x000000373600720bULL, 0x004fe40003f3d000ULL, 0x000000014a4a5812ULL, 0x000fe400078efcffULL,
0x0000004c864c723eULL, 0x000fc600000010ffULL, 0x0000008b00337306ULL, 0x000fec0000209400ULL,
0x0000000135351812ULL, 0x000fe400078efcffULL, 0x0000008b00617306ULL, 0x0004e20000205400ULL,
0x000000606400720bULL, 0x002fce0003fdd000ULL, 0x0000008f005d7306ULL, 0x000fe20000209400ULL,
0x0000008b008b7245ULL, 0x004fca000020d400ULL, 0x000000014d4d6812ULL, 0x000fe400078efcffULL,
0x0000008f00567306ULL, 0x0002a20000205400ULL, 0x000000613300720bULL, 0x008fe40003f7d000ULL,
0x0000004d354d723eULL, 0x000fca00000010ffULL, 0x0000005000517306ULL, 0x000fe20000209400ULL,
0x0000008f008f7245ULL, 0x002fe2000020d400ULL, 0x0000004c2c0c723cULL, 0x000b68000004180cULL,
0x000000018b8b3812ULL, 0x000fe400078efcffULL, 0x0000005000527306ULL, 0x0002e20000205400ULL,
0x000000565d00720bULL, 0x004fe40003f3d000ULL, 0x0000004b8b28723eULL, 0x020fc400000010ffULL,
0x00000091004b7245ULL, 0x000fc6000020d400ULL, 0x0000005300547306ULL, 0x000fe20000209400ULL,
0x0000005000507245ULL, 0x002fca000020d400ULL, 0x000000018f8f1812ULL, 0x000fe400078efcffULL,
0x0000005300557306ULL, 0x0002a20000205400ULL, 0x000000525100720bULL, 0x008fe40003f9d000ULL,
0x000000044900780cULL, 0x000fca0003f25270ULL, 0x0000009000307306ULL, 0x000fe20000209400ULL,
0x0000005300537245ULL, 0x002fca000020d400ULL, 0x0000000150504812ULL, 0x000fe400078efcffULL,
0x0000009000317306ULL, 0x0002e20000205400ULL, 0x000000555400720bULL, 0x004fe40003fdd000ULL,
0x0000008f5029723eULL, 0x000fca00000010ffULL, 0x0000009100327306ULL, 0x000fe20000209400ULL,
0x0000009000907245ULL, 0x002fe2000020d400ULL, 0x000000282c08723cULL, 0x000b680000041808ULL,
0x0000000153536812ULL, 0x000fe400078efcffULL, 0x00000091002a7306ULL, 0x000e620000205400ULL,
0x000000313000720bULL, 0x008fda0003f7d000ULL, 0x0000000190903812ULL, 0x000fe400078efcffULL,
0x0000002a3200720bULL, 0x002fe40003f5d000ULL, 0x0000004a904a723eULL, 0x000fd600000010ffULL,
0x000000014b4b2812ULL, 0x000fc800078efcffULL, 0x0000004b534b723eULL, 0x000fce00000010ffULL,
0x0000004a2c04723cULL, 0x000b620000041804ULL, 0x0000001000009944ULL, 0x000fe20003c00000ULL,
0xffffe0c000007947ULL, 0x000fcc000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff467224ULL, 0x000fe200078e0044ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffd1f000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x0000003f162c7220ULL, 0x0a0fe20000410000ULL, 0x0000003f1a287220ULL, 0x080fe20000410000ULL,
0x0000003f172d7220ULL, 0x080fe20000410000ULL, 0x0000003f10167220ULL, 0x080fe20000410000ULL,
0x0000003f18187220ULL, 0x080fe20000410000ULL, 0x0000003f19197220ULL, 0x080fe20000410000ULL,
0x0000003f1b297220ULL, 0x080fe20000410000ULL, 0x0000003f11177220ULL, 0x080fe20000410000ULL,
0x0000003f0c1a7220ULL, 0x080fe20000410000ULL, 0x0000003f20207220ULL, 0x080fe20000410000ULL,
0x0000003f21217220ULL, 0x080fe20000410000ULL, 0x0000003f1c1c7220ULL, 0x080fe20000410000ULL,
0x0000003f1d1d7220ULL, 0x080fe20000410000ULL, 0x0000003f14147220ULL, 0x080fe20000410000ULL,
0x0000003f15157220ULL, 0x080fe20000410000ULL, 0x0000003f0d1b7220ULL, 0x080fe20000410000ULL,
0x0000003f08087220ULL, 0x080fe20000410000ULL, 0x0000003f09097220ULL, 0x080fe20000410000ULL,
0x0000003f04047220ULL, 0x080fe20000410000ULL, 0x0000003f122e7220ULL, 0x080fe20000410000ULL,
0x0000003f132f7220ULL, 0x080fe20000410000ULL, 0x0000003f0a327220ULL, 0x080fe20000410000ULL,
0x0000003f0b337220ULL, 0x080fe20000410000ULL, 0x000000ffff127224ULL, 0x000fe200078e0016ULL,
0x0000003f0e307220ULL, 0x080fe20000410000ULL, 0x0000003f0f317220ULL, 0x080fe20000410000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e0018ULL, 0x0000003f22227220ULL, 0x080fe20000410000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e0019ULL, 0x0000003f23237220ULL, 0x080fe20000410000ULL,
0x000000ffff137224ULL, 0x000fe200078e0017ULL, 0x0000003f1e2a7220ULL, 0x080fe20000410000ULL,
0x000000ffff167224ULL, 0x000fe200078e001aULL, 0x0000003f1f2b7220ULL, 0x080fe20000410000ULL,
0x0000003f05057220ULL, 0x080fe20000410000ULL, 0x0000003f06067220ULL, 0x080fe20000410000ULL,
0x0000003f07077220ULL, 0x000fe20000410000ULL, 0x000000ffff0c7224ULL, 0x000fc400078e0020ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0021ULL, 0x000000ffff0e7224ULL, 0x000fe400078e001cULL,
0x000000ffff0f7224ULL, 0x000fe400078e001dULL, 0x000000ffff107224ULL, 0x000fe400078e0014ULL,
0x000000ffff117224ULL, 0x000fe400078e0015ULL, 0x000000ffff177224ULL, 0x000fc400078e001bULL,
0x000000ffff187224ULL, 0x000fe400078e0008ULL, 0x000000ffff197224ULL, 0x000fe400078e0009ULL,
0x000000ffff1a7224ULL, 0x000fe200078e0004ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000040087f8cULL, 0x0002a2000c80043fULL, 0x000000ffff1c7224ULL, 0x000fe400078e0028ULL,
0x000000ffff1d7224ULL, 0x000fe400078e0029ULL, 0x000000ffff1e7224ULL, 0x000fc400078e0022ULL,
0x000000ffff1f7224ULL, 0x000fe400078e0023ULL, 0x000000ffff207224ULL, 0x000fe400078e002aULL,
0x000000ffff217224ULL, 0x000fe400078e002bULL, 0x000000ffff227224ULL, 0x000fe400078e002cULL,
0x000000ffff237224ULL, 0x000fe400078e002dULL, 0x000000ffff287224ULL, 0x000fc400078e002eULL,
0x000000ffff297224ULL, 0x000fe400078e002fULL, 0x000000ffff1b7224ULL, 0x000fe400078e0005ULL,
0x000000ffff2a7224ULL, 0x000fe400078e0030ULL, 0x000000ffff2b7224ULL, 0x000fe400078e0031ULL,
0x000000ffff2c7224ULL, 0x000fe400078e0032ULL, 0x000000ffff2d7224ULL, 0x000fc400078e0033ULL,
0x000000ffff2e7224ULL, 0x000fe400078e0006ULL, 0x000000ffff2f7224ULL, 0x000fc400078e0007ULL,
0x0000000000047805ULL, 0x006fca0000015200ULL, 0x0000040040067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff157224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x0000000604147210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09001400780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401400780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011407ULL, 0x0000001406067211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000206067819ULL, 0x000fc80000001207ULL,
0x000000060000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000115157810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040040067984ULL, 0x000e640000000800ULL, 0x8000000006ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000403157824ULL, 0x000fe200078e00ffULL,
0x000000414300720cULL, 0x000fc80003f05270ULL, 0xfffffff015147812ULL, 0x000fca00078ec0ffULL,
0x0000008002147824ULL, 0x000fca00078e0214ULL, 0x0104000014047984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x0000000203087824ULL, 0x000fe400078e00ffULL,
0x0000000124457824ULL, 0x000fc600078e0a45ULL, 0x0000000608087812ULL, 0x000fc800078ec0ffULL,
0x0000000108097812ULL, 0x040fe400078efcffULL, 0x0000000808307812ULL, 0x040fe400078efcffULL,
0x000000450900720cULL, 0x080fe40003f26070ULL, 0x0000001008097812ULL, 0x000fe400078efcffULL,
0x000000453000720cULL, 0x080fe40003f06070ULL, 0x000000450900720cULL, 0x000fc40003fc6070ULL,
0x0000001108307812ULL, 0x040fe400078efcffULL, 0x0000001808097812ULL, 0x040fe400078efcffULL,
0x000000450800720cULL, 0x080fe40003f46070ULL, 0x000000453000720cULL, 0x080fe40003fa6070ULL,
0x000000450900720cULL, 0x000fe40003f66070ULL, 0x0000000908317812ULL, 0x000fc400078efcffULL,
0x0000001908307812ULL, 0x040fe400078efcffULL, 0x0000002008097812ULL, 0x000fe400078efcffULL,
0xff8000001c1c7808ULL, 0x000fe40005000000ULL, 0xff8000000a0a7808ULL, 0x000fe40005000000ULL,
0xff8000001d1d7808ULL, 0x000fe40004800000ULL, 0xff8000000b0b7808ULL, 0x000fc40004800000ULL,
0x000000453100720cULL, 0x080fe40003f86070ULL, 0x000000453000720cULL, 0x080fe40003f46070ULL,
0x000000450900720cULL, 0x000fe40003f26070ULL, 0x0000002108307812ULL, 0x040fe400078efcffULL,
0x0000002808097812ULL, 0x000fe400078efcffULL, 0xff8000001e1e7808ULL, 0x000fc40004000000ULL,
0xff8000000c0c7808ULL, 0x000fe40004000000ULL, 0xff8000001f1f7808ULL, 0x000fe40006000000ULL,
0xff8000000d0d7808ULL, 0x000fe40006000000ULL, 0x000000453000720cULL, 0x080fe40003f06070ULL,
0x000000450900720cULL, 0x000fe40003f86070ULL, 0x0000002908307812ULL, 0x000fc400078efcffULL,
0x0000003008097812ULL, 0x000fe400078efcffULL, 0xff80000020207808ULL, 0x000fe40007000000ULL,
0xff8000000e0e7808ULL, 0x000fe40007000000ULL, 0xff80000021217808ULL, 0x000fe40006800000ULL,
0xff8000000f0f7808ULL, 0x000fe40006800000ULL, 0x000000453000720cULL, 0x000fc40003fc6070ULL,
0x000000450900720cULL, 0x000fe40003fa6070ULL, 0x0000003108307812ULL, 0x040fe400078efcffULL,
0x0000003808097812ULL, 0x040fe400078efcffULL, 0x0000003908087812ULL, 0x000fe400078efcffULL,
0xff80000022227808ULL, 0x000fe40005800000ULL, 0xff80000010107808ULL, 0x000fc40005800000ULL,
0xff80000023237808ULL, 0x000fe40005000000ULL, 0xff80000011117808ULL, 0x000fe40005000000ULL,
0xff80000028287808ULL, 0x000fe40004800000ULL, 0xff80000012127808ULL, 0x000fe40004800000ULL,
0x000000453000720cULL, 0x080fe40003f66070ULL, 0x000000450900720cULL, 0x000fc40003f46070ULL,
0x000000450800720cULL, 0x000fe40003f26070ULL, 0xff80000029297808ULL, 0x000fe40004000000ULL,
0xff80000013137808ULL, 0x000fe40004000000ULL, 0xff8000002a2a7808ULL, 0x000fe40006000000ULL,
0xff80000016167808ULL, 0x000fe40006000000ULL, 0xff8000002b2b7808ULL, 0x000fc40007000000ULL,
0xff80000017177808ULL, 0x000fe40007000000ULL, 0xff8000002c2c7808ULL, 0x000fe40006800000ULL,
0xff80000018187808ULL, 0x000fe40006800000ULL, 0xff8000002d2d7808ULL, 0x000fe40005800000ULL,
0xff80000019197808ULL, 0x000fe40005800000ULL, 0xff8000002e2e7808ULL, 0x000fc40005000000ULL,
0xff8000001a1a7808ULL, 0x000fe40005000000ULL, 0xff8000002f2f7808ULL, 0x000fe40004800000ULL,
0xff8000001b1b7808ULL, 0x000fc40004800000ULL, 0x0000000a0400720bULL, 0x004fe20003f1e000ULL,
0x0000001fff337424ULL, 0x000fe200078e00ffULL, 0x0000001c0500720bULL, 0x000fe20003f3e000ULL,
0xffffffffff347424ULL, 0x000fe200078e00ffULL, 0x000000040a047208ULL, 0x000fe40004000000ULL,
0x000000051c057208ULL, 0x000fc40004800000ULL, 0x0000000b0400720bULL, 0x000fe40003f1e000ULL,
0x0000001d0500720bULL, 0x000fe40003f3e000ULL, 0x000000040b047208ULL, 0x000fe40004000000ULL,
0x000000051d057208ULL, 0x000fe40004800000ULL, 0x0000000c0400720bULL, 0x000fe40003f1e000ULL,
0x0000001e0500720bULL, 0x000fc40003f3e000ULL, 0x000000040c047208ULL, 0x000fe40004000000ULL,
0x000000051e057208ULL, 0x000fe40004800000ULL, 0x0000000d0400720bULL, 0x000fe40003f1e000ULL,
0x0000001f0500720bULL, 0x000fe40003f3e000ULL, 0x000000040d047208ULL, 0x000fe40004000000ULL,
0x000000051f057208ULL, 0x000fc40004800000ULL, 0x0000000e0400720bULL, 0x000fe40003f1e000ULL,
0x000000200500720bULL, 0x000fe40003f3e000ULL, 0x000000040e047208ULL, 0x000fe40004000000ULL,
0x0000000520057208ULL, 0x000fe40004800000ULL, 0x0000000f0400720bULL, 0x000fe40003f1e000ULL,
0x000000210500720bULL, 0x000fc40003f3e000ULL, 0x000000040f047208ULL, 0x000fe40004000000ULL,
0x0000000521057208ULL, 0x000fe40004800000ULL, 0x000000100400720bULL, 0x000fe40003f1e000ULL,
0x000000220500720bULL, 0x000fe40003f3e000ULL, 0x0000000410047208ULL, 0x000fe40004000000ULL,
0x0000000522057208ULL, 0x000fc40004800000ULL, 0x000000110400720bULL, 0x000fe40003f1e000ULL,
0x000000230500720bULL, 0x000fe40003f3e000ULL, 0x0000000411047208ULL, 0x000fe40004000000ULL,
0x0000000523057208ULL, 0x000fe40004800000ULL, 0x000000120400720bULL, 0x000fe40003f1e000ULL,
0x000000280500720bULL, 0x000fc40003f3e000ULL, 0x0000000412047208ULL, 0x000fe40004000000ULL,
0x0000000528057208ULL, 0x000fe40004800000ULL, 0x000000130400720bULL, 0x000fe40003f1e000ULL,
0x000000290500720bULL, 0x000fe40003f3e000ULL, 0x0000000413047208ULL, 0x000fe40004000000ULL,
0x0000000529057208ULL, 0x000fc40004800000ULL, 0x000000160400720bULL, 0x000fe40003f1e000ULL,
0x0000002a0500720bULL, 0x000fe40003f3e000ULL, 0x0000000416047208ULL, 0x000fe40004000000ULL,
0x000000052a057208ULL, 0x000fe40004800000ULL, 0x000000170400720bULL, 0x000fe40003f1e000ULL,
0x0000002b0500720bULL, 0x000fc40003f3e000ULL, 0x0000000417047208ULL, 0x000fe40004000000ULL,
0x000000052b057208ULL, 0x000fe40004800000ULL, 0x000000180400720bULL, 0x000fe40003f1e000ULL,
0x0000002c0500720bULL, 0x000fe40003f3e000ULL, 0x0000000418047208ULL, 0x000fe40004000000ULL,
0x000000052c057208ULL, 0x000fc40004800000ULL, 0x000000190400720bULL, 0x000fe40003f1e000ULL,
0x0000002d0500720bULL, 0x000fe40003f3e000ULL, 0x0000000419047208ULL, 0x000fe40004000000ULL,
0x000000052d057208ULL, 0x000fe40004800000ULL, 0x0000001a0400720bULL, 0x000fe40003f1e000ULL,
0x0000002e0500720bULL, 0x000fc40003f3e000ULL, 0x000000041a047208ULL, 0x000fe40004000000ULL,
0x000000052e057208ULL, 0x000fe40004800000ULL, 0x0000001b0400720bULL, 0x000fe40003f1e000ULL,
0x0000002f0500720bULL, 0x000fe40003f3e000ULL, 0x000000041b327208ULL, 0x000fe40004000000ULL,
0x000000052f057208ULL, 0x000fe20004800000ULL, 0x000018e27f007947ULL, 0x000fec000b800000ULL,
0x0c401f0032047f89ULL, 0x0004e400000e0000ULL, 0x000000043200720bULL, 0x008fc80003f1e000ULL,
0x0000003204327208ULL, 0x004fe20004000000ULL, 0x000019027f007947ULL, 0x000fea000b800000ULL,
0x0c401f0005047f89ULL, 0x000ea800000e0000ULL, 0x0c401f0006087f89ULL, 0x000ee800000e0000ULL,
0x0c401f0007097f89ULL, 0x000e6200000e0000ULL, 0x000000040500720bULL, 0x004fc40003f1e000ULL,
0x000000080600720bULL, 0x008fe40003f3e000ULL, 0x0000000504057208ULL, 0x000fe40004000000ULL,
0x0000000608067208ULL, 0x000fe20004800000ULL, 0x0c201f0032047f89ULL, 0x000ea200000e0000ULL,
0x000000090700720bULL, 0x002fc60003f1e000ULL, 0x0c201f0005087f89ULL, 0x000e6200000e0000ULL,
0x0000000709077208ULL, 0x000fc60004000000ULL, 0x0c201f0006307f89ULL, 0x000ee800000e0000ULL,
0x0c201f0007317f89ULL, 0x0002e200000e0000ULL, 0x000000043200720bULL, 0x004fe40003f1e000ULL,
0x000000080500720bULL, 0x002fe40003f3e000ULL, 0x0000003204047208ULL, 0x000fe40004000000ULL,
0x000000300600720bULL, 0x008fc40003f5e000ULL, 0x0000000508057208ULL, 0x000fe40004800000ULL,
0x0000000630067208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b04307820ULL, 0x000fe20000410000ULL,
0x3f80000000047882ULL, 0x000fe20000000000ULL, 0x0000000c15157812ULL, 0x000fe200078ec0ffULL,
0x00000004ff327e24ULL, 0x000fe2000f8e00ffULL, 0x3fb8aa3b0a0a7823ULL, 0x100fe20000010830ULL,
0x3fb8aa3b0c0c7823ULL, 0x100fe20000010830ULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe20000010830ULL,
0x3fb8aa3b10107823ULL, 0x100fe20000010830ULL, 0x3fb8aa3b12127823ULL, 0x100fe20000010830ULL,
0x0000000a00087308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b16167823ULL, 0x100fe20000010830ULL,
0x3fb8aa3b0b0b7823ULL, 0x100fe20000010830ULL, 0x3fb8aa3b0d0d7823ULL, 0x100fe20000010830ULL,
0x3f8000003232783eULL, 0x000fe200000010ffULL, 0x3fb8aa3b0f0f7823ULL, 0x100fe20000010830ULL,
0x3fb8aa3b11117823ULL, 0x000fe20000010830ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000c000a7308ULL, 0x000fe20000000800ULL, 0x000000ffff337224ULL, 0x000fe200078e0032ULL,
0x3fb8aa3b13137823ULL, 0x100fe20000010830ULL, 0x3fb8aa3b17177823ULL, 0x100fe20000010830ULL,
0x3fb8aa3b18187823ULL, 0x100fe20000010830ULL, 0x3fb8aa3b19197823ULL, 0x100fe20000010830ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe20000010830ULL, 0x3fb8aa3b1b1b7823ULL, 0x000fe20000010830ULL,
0x0000000e000c7308ULL, 0x000fe20000000800ULL, 0x00000002ff307819ULL, 0x000fc40000011603ULL,
0x0000000303ff7812ULL, 0x000fe4000780c0ffULL, 0x000000310700720bULL, 0x004fc60003f3e000ULL,
0x00000010000e7308ULL, 0x000fe20000000800ULL, 0x0000000731077208ULL, 0x000fce0004800000ULL,
0x0000001200107308ULL, 0x000ff00000000800ULL, 0x0000001600127308ULL, 0x0003f00000000800ULL,
0x0000000b000b7308ULL, 0x000ea20000000800ULL, 0x3fb8aa3b05167820ULL, 0x002fc80000410000ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe20000010816ULL,
0x0000000d000d7308ULL, 0x000e620000000800ULL, 0x3fb8aa3b20207823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b21217823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b22227823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b23237823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe20000010816ULL, 0x000000080b08723eULL, 0x004fe200000010ffULL,
0x0000001c00097308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b2f167823ULL, 0x000fe20000010816ULL, 0x00000008302f7824ULL, 0x000fe200078e00ffULL,
0x0000001d001d7308ULL, 0x000ea20000000800ULL, 0x0000000a0d0a723eULL, 0x002fce00000010ffULL,
0x0000001e001e7308ULL, 0x000ff00000000800ULL, 0x0000001f001f7308ULL, 0x000e620000000800ULL,
0x000000091d09723eULL, 0x004fce00000010ffULL, 0x0000000f000f7308ULL, 0x000ea20000000800ULL,
0x0000001e1f0b723eULL, 0x002fce00000010ffULL, 0x0000002000207308ULL, 0x000fe20000000800ULL,
0x00000032081c723cULL, 0x000b6200000418ffULL, 0x0000000c0f0c723eULL, 0x004fcc00000010ffULL,
0x0000002100217308ULL, 0x000e620000000800ULL, 0x0000000830337824ULL, 0x020fce00078e00ffULL,
0x0000001100117308ULL, 0x000eb00000000800ULL, 0x0000002200227308ULL, 0x000fe20000000800ULL,
0x00000020210d723eULL, 0x002fe200000010ffULL, 0x000000ffff207224ULL, 0x000fc400078e0032ULL,
0x000000ffff217224ULL, 0x000fc800078e0032ULL, 0x0000002300237308ULL, 0x000e620000000800ULL,
0x0000000e110e723eULL, 0x004fe400000010ffULL, 0x0000000130117810ULL, 0x000fca0007ffe0ffULL,
0x0000001300137308ULL, 0x000ea20000000800ULL, 0x00000022230f723eULL, 0x002fce00000010ffULL,
0x0000002a002a7308ULL, 0x000fe20000000800ULL, 0x0000000330227810ULL, 0x040fe40007ffe0ffULL,
0x0000000430237810ULL, 0x000fe20007ffe0ffULL, 0x000000200c1c723cULL, 0x000b62000004181cULL,
0x000000101310723eULL, 0x004fc600000010ffULL, 0x0000002b002b7308ULL, 0x000e660000000800ULL,
0x0000000830207824ULL, 0x060fe400078e00ffULL, 0x0000000830217824ULL, 0x000fc600078e00ffULL,
0x0000001700177308ULL, 0x000ea20000000800ULL, 0xfffffff820207812ULL, 0x000fce00078ee211ULL,
0x0000002800287308ULL, 0x000fe20000000800ULL, 0x0000002a2b13723eULL, 0x002fe200000010ffULL,
0x000000ffff2a7224ULL, 0x100fe400078e0032ULL, 0x000000ffff2b7224ULL, 0x000fc800078e0032ULL,
0x0000002900297308ULL, 0x000e620000000800ULL, 0x000000121712723eULL, 0x004fe400000010ffULL,
0x0000000230177810ULL, 0x000fc80007ffe0ffULL, 0xfffffff821217812ULL, 0x000fe200078ee217ULL,
0x0000001800187308ULL, 0x000fe20000000800ULL, 0x0000000830177824ULL, 0x000fca00078e00ffULL,
0xfffffff817177812ULL, 0x000fe400078ee230ULL, 0x000000282911723eULL, 0x002fe200000010ffULL,
0x0000001900197308ULL, 0x000e620000000800ULL, 0x0000000830287824ULL, 0x040fe400078e00ffULL,
0x0000000830297824ULL, 0x000fc600078e00ffULL, 0x0000002a101c723cULL, 0x000b62000004181cULL,
0xfffffff828227812ULL, 0x000fe200078ee222ULL, 0x0000001a001a7308ULL, 0x000fe20000000800ULL,
0x0000000530287810ULL, 0x040fe40007ffe0ffULL, 0xfffffff829237812ULL, 0x000fe400078ee223ULL,
0x00000008302b7810ULL, 0x020fe40007ffe0ffULL, 0xfffffff82f287812ULL, 0x000fe200078ee228ULL,
0x0000001b001b7308ULL, 0x000ea20000000800ULL, 0x000000181918723eULL, 0x002fe200000010ffULL,
0x000000082b347824ULL, 0x000fe200078e00ffULL, 0x0000a000022f7811ULL, 0x000fc400078e58ffULL,
0x0000000630297810ULL, 0x040fe40007ffe0ffULL, 0xffffffff302a7810ULL, 0x040fe20007ffe0ffULL,
0x0000002c002c7308ULL, 0x000fe20000000800ULL, 0x0000000830307824ULL, 0x000fe200078e00ffULL,
0xfffffff833297812ULL, 0x000fe200078ee229ULL, 0x0000001017177824ULL, 0x000fe200078e022fULL,
0xfffffff8342b7812ULL, 0x000fe200078ee22bULL, 0x0000001020207824ULL, 0x100fe200078e022fULL,
0xfffffff8302a7812ULL, 0x000fe200078ee22aULL, 0x0000001021217824ULL, 0x100fe200078e022fULL,
0x0000002d002d7308ULL, 0x000e620000000800ULL, 0x0000001a1b1a723eULL, 0x004fe200000010ffULL,
0x0000001022227824ULL, 0x000fc400078e022fULL, 0x0000001023237824ULL, 0x000fe400078e022fULL,
0x0000000117177824ULL, 0x000fe400078e0215ULL, 0x0000002e002e7308ULL, 0x000fe20000000800ULL,
0x0000001028287824ULL, 0x100fe400078e022fULL, 0x0000000115207824ULL, 0x000fe200078e0220ULL,
0x0000000817007388ULL, 0x0005e20000000800ULL, 0x0000001029297824ULL, 0x000fe400078e022fULL,
0x0000000115217824ULL, 0x000fe200078e0221ULL, 0x0000001600167308ULL, 0x000ee20000000800ULL,
0x0000002c2d19723eULL, 0x002fe200000010ffULL, 0x000000ffff2c7224ULL, 0x100fe200078e0032ULL,
0x0000000a20007388ULL, 0x0005e20000000800ULL, 0x000000ffff2d7224ULL, 0x000fc400078e0032ULL,
0x000000102a2a7824ULL, 0x100fe200078e022fULL, 0x0000000c21007388ULL, 0x0005e20000000800ULL,
0x0000000115227824ULL, 0x000fe400078e0222ULL, 0x000000102b2b7824ULL, 0x000fe400078e022fULL,
0x0000000115237824ULL, 0x040fe200078e0223ULL, 0x0000000e22007388ULL, 0x0005e20000000800ULL,
0x0000000115287824ULL, 0x040fe200078e0228ULL, 0x0000002e161b723eULL, 0x008fe200000010ffULL,
0x0000000115297824ULL, 0x040fe200078e0229ULL, 0x0000001023007388ULL, 0x0005e20000000800ULL,
0x00000001152a7824ULL, 0x000fc400078e022aULL, 0x00000001152b7824ULL, 0x000fe200078e022bULL,
0x0000001228007388ULL, 0x0005e20000000800ULL, 0x0000002c181c723cULL, 0x000f66000004181cULL,
0x0000001829007388ULL, 0x0005e80000000800ULL, 0x0000001a2a007388ULL, 0x0005e80000000800ULL,
0x000000092b007388ULL, 0x0005e80000000800ULL, 0x0004000b20007388ULL, 0x0005e80000000800ULL,
0x0004000d21007388ULL, 0x0005e80000000800ULL, 0x0004000f22007388ULL, 0x0005e20000000800ULL,
0x000000ffff1d7224ULL, 0x020fc600078e001eULL, 0x0004001123007388ULL, 0x0005e80000000800ULL,
0x0004001328007388ULL, 0x0005e80000000800ULL, 0x0004001929007388ULL, 0x0005e80000000800ULL,
0x0004001b2a007388ULL, 0x0005e80000000800ULL, 0x0100000414008388ULL, 0x0005e80000000c00ULL,
0x0102001c14008388ULL, 0x0005e20000000a00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000042ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000080042ff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000100042ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000143437810ULL, 0x000fe20007ffe0ffULL, 0x0000180042ff7f8cULL, 0x0003e6000c80043fULL,
0x000000264300720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffb3b000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff3c7807ULL, 0x008fe40004000000ULL, 0x00020590003d7802ULL, 0x000fc40000000f00ULL,
0x0000100000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff317224ULL, 0x000fe200078e004bULL,
0xfffe1ac000007947ULL, 0x000fea000383ffffULL, 0x00000001ff3c7807ULL, 0x000fe40005000000ULL,
0x000205e0003d7802ULL, 0x000fc40000000f00ULL, 0x00000fb000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff387224ULL, 0x000fe200078e004bULL, 0xfffe1b2000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4d7224ULL, 0x004fe200078e0039ULL, 0x00020630004c7802ULL, 0x000fc40000000f00ULL,
0x00000f2000007944ULL, 0x002fea0003c00000ULL, 0xfffe1bd000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4d7224ULL, 0x000fe200078e0039ULL, 0x00020670004c7802ULL, 0x000fc40000000f00ULL,
0x00000ee000007944ULL, 0x002fea0003c00000ULL, 0xfffe1d0000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4d7224ULL, 0x000fe200078e0036ULL, 0x000206c0004c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff4b7224ULL, 0x000fc400078e0037ULL, 0x00000e9000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff347224ULL, 0x004fe200078e004bULL, 0xfffe20f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4b7224ULL, 0x000fe200078e0035ULL, 0x00020720004c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff4d7224ULL, 0x000fc400078e0036ULL, 0x00000e3000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff357224ULL, 0x004fe200078e004bULL, 0xfffe20c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4d7224ULL, 0x000fe200078e0008ULL, 0x00020780004c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff4b7224ULL, 0x000fc400078e0009ULL, 0x00000dd000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff347224ULL, 0x004fe200078e004bULL, 0xfffe4de000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4b7224ULL, 0x000fe200078e0035ULL, 0x000207e0004c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff4d7224ULL, 0x000fc400078e0008ULL, 0x00000d7000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff357224ULL, 0x004fe200078e004bULL, 0xfffe4db000007947ULL, 0x000fea000383ffffULL,
0x00000001ff3c7807ULL, 0x008fe40004000000ULL, 0x00020830003d7802ULL, 0x000fc40000000f00ULL,
0x00000d6000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff497224ULL, 0x000fe200078e004bULL,
0xfffe7b5000007947ULL, 0x000fea000383ffffULL, 0x00000001ff3c7807ULL, 0x000fe40005000000ULL,
0x00020880003d7802ULL, 0x000fc40000000f00ULL, 0x00000d1000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff3c7224ULL, 0x000fe200078e004bULL, 0xfffe7b9000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4b7224ULL, 0x000fe200078e003dULL, 0x000208e0004c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff4d7224ULL, 0x000fc400078e004aULL, 0x00000c7000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff3d7224ULL, 0x004fe200078e004bULL, 0xfffe7c4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4d7224ULL, 0x000fe200078e004aULL, 0x00020940004c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff4b7224ULL, 0x000fc400078e003dULL, 0x00000c1000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff3d7224ULL, 0x004fe200078e004bULL, 0xfffe7d4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4d7224ULL, 0x000fe200078e003cULL, 0x000209a0004c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff4b7224ULL, 0x000fc400078e003dULL, 0x00000bb000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff347224ULL, 0x004fe200078e004bULL, 0xfffe817000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4b7224ULL, 0x000fe200078e0035ULL, 0x00020a00004c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff4d7224ULL, 0x000fc400078e003cULL, 0x00000b5000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff357224ULL, 0x004fe200078e004bULL, 0xfffe814000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4d7224ULL, 0x000fe200078e0008ULL, 0x00020a60004c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff4b7224ULL, 0x000fc400078e0009ULL, 0x00000af000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff347224ULL, 0x004fe200078e004bULL, 0xfffeac7000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4b7224ULL, 0x000fe200078e0035ULL, 0x00020ac0004c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff4d7224ULL, 0x000fc400078e0008ULL, 0x00000a9000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff357224ULL, 0x004fe200078e004bULL, 0xfffeac4000007947ULL, 0x000fea000383ffffULL,
0x00000001ff3c7807ULL, 0x002fe40004000000ULL, 0x00020b10003d7802ULL, 0x000fc40000000f00ULL,
0x00000a8000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff3f7224ULL, 0x000fe200078e004bULL,
0xfffed87000007947ULL, 0x000fea000383ffffULL, 0x00000001ff3c7807ULL, 0x000fe40005000000ULL,
0x00020b60003d7802ULL, 0x000fc40000000f00ULL, 0x00000a3000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff3c7224ULL, 0x000fe200078e004bULL, 0xfffed8a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4b7224ULL, 0x000fe200078e003dULL, 0x00020bc0004c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff4d7224ULL, 0x000fc400078e004eULL, 0x0000099000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff3d7224ULL, 0x004fe200078e004bULL, 0xfffed95000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4d7224ULL, 0x000fe200078e004eULL, 0x00020c20004c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff4b7224ULL, 0x000fc400078e003dULL, 0x0000093000007944ULL, 0x00afea0003c00000ULL,
0x000000ffff3d7224ULL, 0x004fe200078e004bULL, 0xfffeda5000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4d7224ULL, 0x000fe200078e002cULL, 0x00020c80004c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff4b7224ULL, 0x000fc400078e003cULL, 0x000008d000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff347224ULL, 0x004fe200078e004bULL, 0xfffede6000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4b7224ULL, 0x000fe200078e0035ULL, 0x00020ce0004c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff4d7224ULL, 0x000fc400078e002cULL, 0x0000087000007944ULL, 0x00efea0003c00000ULL,
0x000000ffff357224ULL, 0x004fe200078e004bULL, 0xfffede3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4d7224ULL, 0x000fe200078e0020ULL, 0x00020d40004c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff4b7224ULL, 0x000fc400078e0021ULL, 0x0000081000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff347224ULL, 0x004fe200078e004bULL, 0xffff096000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4b7224ULL, 0x000fe200078e0035ULL, 0x00020da0004c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff4d7224ULL, 0x000fc400078e0020ULL, 0x000007b000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff357224ULL, 0x004fe200078e004bULL, 0xffff093000007947ULL, 0x000fea000383ffffULL,
0x00000001ff3c7807ULL, 0x008fe40004000000ULL, 0x00020df0003d7802ULL, 0x000fc40000000f00ULL,
0x000007a000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff3f7224ULL, 0x000fe200078e004bULL,
0xffff35e000007947ULL, 0x000fea000383ffffULL, 0x00000001ff3c7807ULL, 0x000fe40004800000ULL,
0x00020e40003d7802ULL, 0x000fc40000000f00ULL, 0x0000075000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff307224ULL, 0x000fe200078e004bULL, 0xffff361000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4b7224ULL, 0x000fe200078e002fULL, 0x00020ea0004c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff4d7224ULL, 0x000fc400078e003cULL, 0x000006b000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff2f7224ULL, 0x004fe200078e004bULL, 0xffff36c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4d7224ULL, 0x000fe200078e003cULL, 0x00020f00004c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff4b7224ULL, 0x000fc400078e002fULL, 0x0000065000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff2f7224ULL, 0x004fe200078e004bULL, 0xffff37c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4d7224ULL, 0x000fe200078e002cULL, 0x00020f60004c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff4b7224ULL, 0x000fc400078e002fULL, 0x000005f000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff347224ULL, 0x004fe200078e004bULL, 0xffff3bd000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4b7224ULL, 0x000fe200078e0035ULL, 0x00020fc0004c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff4d7224ULL, 0x000fc400078e002cULL, 0x0000059000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff357224ULL, 0x004fe200078e004bULL, 0xffff3ba000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4d7224ULL, 0x000fe200078e0008ULL, 0x00021020004c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff4b7224ULL, 0x000fc400078e0009ULL, 0x0000053000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff347224ULL, 0x004fe200078e004bULL, 0xffff66f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4b7224ULL, 0x000fe200078e0035ULL, 0x00021080004c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff4d7224ULL, 0x000fc400078e0008ULL, 0x000004d000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff357224ULL, 0x004fe200078e004bULL, 0xffff66c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff087224ULL, 0x000fe200078e0032ULL, 0x000210e000307802ULL, 0x000fe20000000f00ULL,
0x00000002ff097424ULL, 0x000fc400078e00ffULL, 0x0000042000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0031ULL, 0xffffe6d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff087224ULL, 0x000fe200078e0005ULL, 0x0002114000307802ULL, 0x000fe20000000f00ULL,
0x00000002ff097424ULL, 0x000fc400078e00ffULL, 0x000003c000007944ULL, 0x012fea0003c00000ULL,
0x000000310500720bULL, 0x004fe20003f1e000ULL, 0x000000ffff087224ULL, 0x000fe200078e0006ULL,
0x000211a000307802ULL, 0x000fe20000000f00ULL, 0x00000002ff097424ULL, 0x000fe200078e00ffULL,
0x0000000531057208ULL, 0x000fc80004000000ULL, 0x0000036000007944ULL, 0x000fea0003c00000ULL,
0x000000310600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff087224ULL, 0x000fe200078e0007ULL,
0x0002120000307802ULL, 0x000fe20000000f00ULL, 0x00000002ff097424ULL, 0x000fe200078e00ffULL,
0x0000000631067208ULL, 0x000fc80004000000ULL, 0x0000030000007944ULL, 0x000fea0003c00000ULL,
0x000000310700720bULL, 0x004fe20003f1e000ULL, 0x000000ffff087224ULL, 0x000fe200078e0032ULL,
0x0002126000307802ULL, 0x000fe20000000f00ULL, 0x00000001ff097424ULL, 0x000fe200078e00ffULL,
0x0000000731077208ULL, 0x000fc80004000000ULL, 0x000002a000007944ULL, 0x000fea0003c00000ULL,
0x000000313200720bULL, 0x004fe20003f1e000ULL, 0x000000ffff087224ULL, 0x000fe200078e0005ULL,
0x000212c000307802ULL, 0x000fe20000000f00ULL, 0x00000001ff097424ULL, 0x000fe200078e00ffULL,
0x0000003231047208ULL, 0x000fc80004000000ULL, 0x0000024000007944ULL, 0x000fea0003c00000ULL,
0x000000310500720bULL, 0x004fe20003f1e000ULL, 0x000000ffff087224ULL, 0x000fe200078e0006ULL,
0x0002132000307802ULL, 0x000fe20000000f00ULL, 0x00000001ff097424ULL, 0x000fe200078e00ffULL,
0x0000000531057208ULL, 0x000fc80004000000ULL, 0x000001e000007944ULL, 0x000fea0003c00000ULL,
0x000000310600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff087224ULL, 0x000fe200078e0007ULL,
0x0002138000307802ULL, 0x000fe20000000f00ULL, 0x00000001ff097424ULL, 0x000fe200078e00ffULL,
0x0000000631067208ULL, 0x000fc80004000000ULL, 0x0000018000007944ULL, 0x000fea0003c00000ULL,
0xffffe5a000007947ULL, 0x000fea000383ffffULL, 0x0180000003007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000057812ULL, 0x000fc800078ec0ffULL,
0x018000000500780cULL, 0x000fda0003f05070ULL, 0x0000000300008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0500720cULL, 0x040fe40003f25070ULL,
0x008000000500780cULL, 0x000fe40003f02070ULL, 0x00000001ff057807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000005ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff03ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000003037812ULL, 0x002fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000005ff7212ULL, 0x000fda000780c0ffULL, 0x0080000003000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0003ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000300007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff057424ULL, 0x000fc800078e00ffULL, 0xfffdeb0004007950ULL, 0x000fea0003c3ffffULL,
0x0000003400007348ULL, 0x000fe80003800000ULL, 0x0c00000908317389ULL, 0x0002a400000e0033ULL,
0x000000ffff087224ULL, 0x002fe400078e0030ULL, 0x00000000ff097424ULL, 0x000fc800078e00ffULL,
0xfffdeab008007950ULL, 0x000fea0003c3ffffULL, 0x0000003200007348ULL, 0x000fe80003800000ULL,
0x0000004b4d4b7389ULL, 0x0002a400000e0031ULL, 0x00000000ff4d7424ULL, 0x002fc800078e00ffULL,
0xfffdea704c007950ULL, 0x000fea0003c3ffffULL, 0x000000013c00780cULL, 0x000fe20003f45070ULL,
0x0000003000007348ULL, 0x000fd80003800000ULL, 0x00000000003c7806ULL, 0x000fc800050e0100ULL,
0x000000303c4b7212ULL, 0x000fe200078ec0ffULL, 0x000000ffff3c7224ULL, 0x000fe400078e003dULL,
0x00000000ff3d7424ULL, 0x000fc800078e00ffULL, 0xfffdea003c007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000200000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005e7ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000748ULL, 0x0000000000000288ULL, 0x0000001a00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009d0ULL, 0x00000000000004f0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000ec0ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000f80ULL, 0x0000000000000a04ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001988ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001998ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000007bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001a28ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001a2cULL, 0x00000000000001b0ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001c00ULL, 0x0000000000021700ULL, 0xed00001a00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x0000000100000089ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000023300ULL, 0x0000000000000044ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000023350ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x00000000000236d0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001a28ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000218d8ULL, 0x00000000000218d8ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000023300ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x00000000000236d0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_1_kvt_int8_pagedKV_128_nqpkv_8_m_8_sm_89_cubin_len = 145328;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
