/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_1_kvt_int8_pagedKV_128_nqpkv_8_m_8_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000019830ULL, 0x00000000000194b0ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x766e2e0000000000ULL, 0x2e6c61626f6c672eULL, 0x65722e0074696e69ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6e6f632e766e2e00ULL, 0x000033746e617473ULL, 0x536d656d73000000ULL, 0x2e766e2e00657a69ULL,
0x692e6c61626f6c67ULL, 0x4e5a5a5f0074696eULL, 0x7473336164756334ULL, 0x5f5f38345f5f3364ULL,
0x31326c6961746564ULL, 0x676e6f7274735f5fULL, 0x726564726f5f7265ULL, 0x696945616475635fULL,
0x726f66785f5f3745ULL, 0x374b4e5a5a5f006dULL, 0x4944327961727241ULL, 0x326a4c45326a4c66ULL,
0x624c497461324545ULL, 0x6a664b5245454530ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x326a4c66495f5349ULL, 0x6a4c4545326a4c45ULL,
0x324545386a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f30534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x625f766e5f5f3431ULL,
0x32363174616f6c66ULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6a49636556334944ULL, 0x316a4c4545346a4cULL, 0x324545386a4c4536ULL, 0x454531624c497461ULL,
0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL,
0x4944327961727241ULL, 0x6a4c6a4963655633ULL, 0x4536316a4c454534ULL, 0x6132454532336a4cULL,
0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4534366a4c4545ULL,
0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL,
0x45326a4c45326a4cULL, 0x316a4c45316a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL,
0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL,
0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL, 0x4c4545316a4c4534ULL, 0x4545316a4c45326aULL,
0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x6e4974736e493949ULL, 0x45346a4c4974614dULL,
0x326a4c4545326a4cULL, 0x61324545316a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL,
0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL, 0x746132454536316aULL, 0x5245454531624c49ULL,
0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL,
0x4939494432796172ULL, 0x74614d6e4974736eULL, 0x326a4c45326a4c49ULL, 0x6a4c45326a4c4545ULL,
0x4c49746132454531ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x4545386a4c45386aULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x36316a4c4545346aULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x5f24000000000000ULL, 0x616e7265746e695fULL, 0x635f5f245f305f6cULL, 0x30326d735f616475ULL,
0x5f6e725f7063725fULL, 0x5f3233665f7a7466ULL, 0x68746170776f6c73ULL, 0x65742e6c65722e00ULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x747865742e616c65ULL, 0x5f6c656e72656b2eULL,
0x72656b240061686dULL, 0x2461686d5f6c656eULL, 0x657479426d656d73ULL, 0x6265642e00667542ULL,
0x656d6172665f6775ULL, 0x65642e6c65722e00ULL, 0x6d6172665f677562ULL, 0x2e616c65722e0065ULL,
0x72665f6775626564ULL, 0x2e766e2e00656d61ULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x0000000061686d5fULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000100000098ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b0003000000a1ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b0001000000b1ULL, 0x0000000000000034ULL, 0x0000000000000010ULL, 0x000b0001000000efULL,
0x000000000000001cULL, 0x0000000000000004ULL, 0x000b000100000128ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000b00010000016fULL, 0x000000000000002cULL, 0x0000000000000004ULL,
0x000b0001000001b9ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b0001000001ffULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000b000100000246ULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000b00010000028cULL, 0x0000000000000030ULL, 0x0000000000000004ULL,
0x000b0001000002daULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000328ULL,
0x0000000000000018ULL, 0x0000000000000004ULL, 0x000b000100000376ULL, 0x000000000000000cULL,
0x0000000000000004ULL, 0x000b0001000003bdULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000b00010000040bULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000b000100000450ULL,
0x0000000000000020ULL, 0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000a0022000004abULL, 0x0000000000017cd0ULL, 0x0000000000000230ULL,
0x0004000300000521ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a101200000040ULL,
0x0000000000000000ULL, 0x0000000000017f00ULL, 0x000d000300000551ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000024ffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00017cd000000000ULL, 0x0000c80400000000ULL,
0x0000288080810c00ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080850828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880808592ULL, 0x0000002cffffffffULL, 0x0000006000000000ULL,
0x00017cd000000000ULL, 0x0000023000000000ULL, 0x0000580400000000ULL, 0x8082288080850900ULL,
0x0000000000002880ULL, 0x0000001600082f04ULL, 0x000823040000007bULL, 0x0000000000000014ULL,
0x0000001400081204ULL, 0x0008110400000000ULL, 0x0000000000000014ULL, 0x0000001600082304ULL,
0x0008120400000000ULL, 0x0000000000000016ULL, 0x0000001600081104ULL, 0x0004370400000000ULL,
0x000c17040000007bULL, 0x0048000600000000ULL, 0x000c17040021f000ULL, 0x0040000500000000ULL,
0x000c17040021f000ULL, 0x0038000400000000ULL, 0x000c17040011f000ULL, 0x0018000300000000ULL,
0x000c17040081f000ULL, 0x0010000200000000ULL, 0x000c17040021f000ULL, 0x0008000100000000ULL,
0x000c17040021f000ULL, 0x0000000000000000ULL, 0x00801b030011f000ULL, 0xffffffff00b82904ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x00b82804ffffffffULL, 0x00000130000000f0ULL,
0x00002250000007e0ULL, 0x00002370000022b0ULL, 0x00002940000024b0ULL, 0x0000457000002950ULL,
0x0000617000004580ULL, 0x000062a0000061d0ULL, 0x00006790000063e0ULL, 0x00008230000067a0ULL,
0x00009d0000008240ULL, 0x00009e3000009d60ULL, 0x0000a32000009f70ULL, 0x0000bda00000a330ULL,
0x0000d8f00000bdb0ULL, 0x0000da200000d950ULL, 0x0000df100000db60ULL, 0x0000f9d00000df20ULL,
0x00010a300000f9e0ULL, 0x0001129000010a40ULL, 0x0001714000017090ULL, 0x000173f000017370ULL,
0x000176c000017660ULL, 0x00017a3000017860ULL, 0x0000037005f03904ULL, 0x00018600000000ffULL,
0x0000045000040100ULL, 0x0001860800000012ULL, 0x00000560003f0100ULL, 0x0001868800000012ULL,
0x00000680003f0100ULL, 0x000186a800000000ULL, 0x00000770003f0100ULL, 0x000186b8000000ffULL,
0x0000090000040100ULL, 0x0001860000000007ULL, 0x00000a10003f0107ULL, 0x0001868800000003ULL,
0x000012c0003f0101ULL, 0x000186a800000007ULL, 0x000013a0003f0107ULL, 0x000186a800000007ULL,
0x00001440003f0101ULL, 0x000186b800000007ULL, 0x00001540003f0101ULL, 0x000186b800000007ULL,
0x000016b0003f0109ULL, 0x000186b800000007ULL, 0x00001fa0003f0109ULL, 0x000186b000000007ULL,
0x00001ff0003f0107ULL, 0x000186b000000007ULL, 0x00002000003f0101ULL, 0x0001860800000003ULL,
0x00002020003f0101ULL, 0x0001860800000003ULL, 0x00002190003f0109ULL, 0x0001860800000003ULL,
0x00002640003f0109ULL, 0x000186a800000007ULL, 0x000027b0003f0109ULL, 0x000186a800000007ULL,
0x00003830003f0109ULL, 0x000186b800000007ULL, 0x000038d0003f0101ULL, 0x000186b800000007ULL,
0x00003a40003f0109ULL, 0x000186b800000007ULL, 0x000042a0003f0109ULL, 0x00000000000000ffULL,
0x000042e000050107ULL, 0x000186a800000007ULL, 0x00004310003f0101ULL, 0x000186b000000007ULL,
0x00004480003f0109ULL, 0x000186b000000007ULL, 0x00005370003f0109ULL, 0x000186b800000007ULL,
0x000053a0003f0101ULL, 0x0001868800000007ULL, 0x000054d0003f0101ULL, 0x000186b800000007ULL,
0x00005640003f0109ULL, 0x000186b800000007ULL, 0x00005ea0003f0109ULL, 0x00000000000000ffULL,
0x00005f6000060107ULL, 0x000186b000000007ULL, 0x00005f70003f0101ULL, 0x0001862800000003ULL,
0x00005f90003f0101ULL, 0x0001862800000003ULL, 0x00006100003f0109ULL, 0x0001862800000003ULL,
0x00006590003f0109ULL, 0x000186a800000007ULL, 0x00006700003f0109ULL, 0x000186a800000007ULL,
0x00007550003f0109ULL, 0x000186b800000007ULL, 0x00007600003f0101ULL, 0x000186b800000007ULL,
0x00007770003f0109ULL, 0x000186b800000007ULL, 0x00007fe0003f0109ULL, 0x00000000000000ffULL,
0x0000802000050107ULL, 0x000186a800000007ULL, 0x00008050003f0101ULL, 0x000186b000000007ULL,
0x000081c0003f0109ULL, 0x000186b000000007ULL, 0x00008fb0003f0109ULL, 0x000186b800000007ULL,
0x00008fe0003f0101ULL, 0x0001869000000007ULL, 0x000090f0003f0101ULL, 0x000186b800000007ULL,
0x00009260003f0109ULL, 0x000186b800000007ULL, 0x00009ac0003f0109ULL, 0x00000000000000ffULL,
0x00009b0000060107ULL, 0x000186b000000007ULL, 0x00009b10003f0101ULL, 0x0001864800000003ULL,
0x00009b30003f0101ULL, 0x0001864800000003ULL, 0x00009ca0003f0109ULL, 0x0001864800000003ULL,
0x0000a120003f0109ULL, 0x000186a800000007ULL, 0x0000a290003f0109ULL, 0x000186a800000007ULL,
0x0000b090003f0109ULL, 0x000186b800000007ULL, 0x0000b180003f0101ULL, 0x000186b800000007ULL,
0x0000b2f0003f0109ULL, 0x000186b800000007ULL, 0x0000bb50003f0109ULL, 0x00000000000000ffULL,
0x0000bb9000050107ULL, 0x000186a800000007ULL, 0x0000bbc0003f0101ULL, 0x000186b000000007ULL,
0x0000bd30003f0109ULL, 0x000186b000000007ULL, 0x0000cb00003f0109ULL, 0x000186b800000007ULL,
0x0000cb30003f0101ULL, 0x0001869800000007ULL, 0x0000cc60003f0101ULL, 0x000186b800000007ULL,
0x0000cdd0003f0109ULL, 0x000186b800000007ULL, 0x0000d630003f0109ULL, 0x00000000000000ffULL,
0x0000d6f000060107ULL, 0x000186b000000007ULL, 0x0000d700003f0101ULL, 0x0001866800000003ULL,
0x0000d720003f0101ULL, 0x0001866800000003ULL, 0x0000d890003f0109ULL, 0x0001866800000003ULL,
0x0000dd10003f0109ULL, 0x000186a800000007ULL, 0x0000de80003f0109ULL, 0x000186a800000007ULL,
0x0000ec30003f0109ULL, 0x000186b800000007ULL, 0x0000ed80003f0101ULL, 0x000186b800000007ULL,
0x0000eef0003f0109ULL, 0x000186b800000007ULL, 0x0000f780003f0109ULL, 0x00000000000000ffULL,
0x0000f7c000050107ULL, 0x000186a800000007ULL, 0x0000f7f0003f0101ULL, 0x000186b000000007ULL,
0x0000f960003f0109ULL, 0x000186b000000007ULL, 0x000105f0003f0109ULL, 0x000186b800000007ULL,
0x00010610003f0101ULL, 0x000186a000000007ULL, 0x00011430003f0101ULL, 0x0001860000000007ULL,
0x000130e0003f0101ULL, 0x0001860000000007ULL, 0x00013250003f0109ULL, 0x0001860000000007ULL,
0x00013590003f0109ULL, 0x0001860000000007ULL, 0x000135b0003f0101ULL, 0x0001860000000007ULL,
0x00013720003f0109ULL, 0x0001860000000007ULL, 0x000165e0003f0109ULL, 0x000186880000000aULL,
0x000167b0003f0101ULL, 0x000186880000000aULL, 0x00016920003f0109ULL, 0x000186880000000aULL,
0x00017c70003f0109ULL, 0x000186080000000dULL, 0x00017c80003f0101ULL, 0x000186100000000dULL,
0x00017c90003f0101ULL, 0x000186180000000dULL, 0x00017ca0003f0101ULL, 0x000186200000000dULL,
0x00053803003f0101ULL, 0x0001137000101c04ULL, 0x0001381000013750ULL, 0x000c050400017cc0ULL,
0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0050190300000000ULL, 0x0000001700080a04ULL,
0x0000000000500210ULL, 0x00000000000000bcULL, 0x0000001600000002ULL, 0x0000000000017cd0ULL,
0x0000000000000044ULL, 0x0000001600000002ULL, 0x0000000000000000ULL, 0x0000000000000098ULL,
0x0000001600000002ULL, 0x0000000000000000ULL, 0x0000000000018700ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e620000000800ULL, 0x0000000000117919ULL, 0x000ea20000002300ULL,
0x0000010000047ab9ULL, 0x000fcc0000000800ULL, 0x00008400ff177b82ULL, 0x000ee20000000800ULL,
0x0000040000077802ULL, 0x000fe20000000f00ULL, 0x0000000000007919ULL, 0x000ea20000002200ULL,
0x0000035000007945ULL, 0x000fe20003800000ULL, 0x0000000000037919ULL, 0x000f280000002100ULL,
0x00008800ff047b82ULL, 0x000f620000000a00ULL, 0x0000000000097919ULL, 0x000ee20000000000ULL,
0x0000000000087919ULL, 0x000ee20000002600ULL, 0x0000000000367919ULL, 0x000ee20000002700ULL,
0x00000000000e7919ULL, 0x000ee20000008800ULL, 0x0000000411007c24ULL, 0x004fe2000f8e0200ULL,
0x0000000000047ab9ULL, 0x000fe20000000800ULL, 0x00001fff11117589ULL, 0x000fe400000e0000ULL,
0x0000000400007c24ULL, 0x110fe2000f8e0203ULL, 0x00000005ff347819ULL, 0x000fc80000011603ULL,
0x0000007f0000780cULL, 0x000fe40003f64070ULL, 0x00001fff34347589ULL, 0x000ea200000e0000ULL,
0x0000000808037824ULL, 0x00afe200078e00ffULL, 0x000000ff0000720cULL, 0x040fe40003f45270ULL,
0x0000000f0000780cULL, 0x040fe40003f04070ULL, 0x000000030000780cULL, 0x040fe40003fa4070ULL,
0x000000010000780cULL, 0x000fc40003f84070ULL, 0x000006540e077816ULL, 0x000fe20000000007ULL,
0x00000000000cb919ULL, 0x000e620000008800ULL, 0x00000400000bb802ULL, 0x000fe20000000f00ULL,
0x00000010090e7824ULL, 0x000fe400078e00ffULL, 0xff317217ff15b424ULL, 0x000fc600078e00ffULL,
0x000001f00e137812ULL, 0x000fe200078ec0ffULL, 0x0000000411027824ULL, 0x004fc800078e0234ULL,
0x0000000202067824ULL, 0x000fe400078e00ffULL, 0x0000000817027824ULL, 0x000fe400078e00ffULL,
0x00000001060a7824ULL, 0x040fe400078e0209ULL, 0x00000020060d7824ULL, 0x000fe400078e00ffULL,
0x0000003602027224ULL, 0x000fe200078e0203ULL, 0x0000000806037848ULL, 0x000fe40007fe0000ULL,
0xffffffe00d107812ULL, 0x000fe200078ee20aULL, 0x00000001060a7836ULL, 0x000fe20000000000ULL,
0x000006540c19b816ULL, 0x002fe2000000000bULL, 0x00000001030b7824ULL, 0x100fe200078e0a06ULL,
0x00008e00ff0c7b82ULL, 0x000e620000000a00ULL, 0x0000000102037824ULL, 0x000fc400078e0206ULL,
0x00000001020f7824ULL, 0x000fe400078e020aULL, 0x0000020003027825ULL, 0x020fc800078e0004ULL,
0x000002000f047825ULL, 0x000fc800078e0004ULL, 0x000000040006b824ULL, 0x000fe400078e0219ULL,
0x000000010a0f7824ULL, 0x000fe200078e0209ULL, 0x0000000000242947ULL, 0x002fec0003800000ULL,
0x00000000000579c3ULL, 0x000ea20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000067882ULL, 0x000fe20000000000ULL, 0x7ffc000000077882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x004fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000eb40000000000ULL, 0x01860006043f75b2ULL, 0x0004a40008000100ULL,
0x0000000000007918ULL, 0x004fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000380947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000ea20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x004fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x0000000400127c11ULL, 0x000fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000120612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000ea40000000000ULL,
0x01860804063f75b2ULL, 0x0004b00008000100ULL, 0xfffffffd00e81947ULL, 0x004fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000385947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ffb000000057882ULL, 0x000fc60000000000ULL,
0x0000000400127c11ULL, 0x000fe2000f8e18ffULL, 0x001ffec000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000120612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ea40000000000ULL, 0x01868804063f75b2ULL, 0x0004b00008000100ULL,
0xfffffffd00e81947ULL, 0x004fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x018400150600b388ULL, 0x0005e20000000800ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ee20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x008fc60008000004ULL, 0x7ff8000000057882ULL, 0x000fc60000000000ULL,
0x0000000400007c11ULL, 0x000fe2000f8e18ffULL, 0x001ffe0000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x004fca0000000000ULL, 0x00000000000612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ea40000000000ULL, 0x0186a804063f75b2ULL, 0x0004b00008000100ULL,
0xfffffffd00e81947ULL, 0x004fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000b000007945ULL, 0x000fe80003800000ULL, 0x0000000000242947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000ee20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000067882ULL, 0x000fe20000000000ULL, 0x7ffc000000077882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x008fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000ef40000000000ULL, 0x0186b806043f75b2ULL, 0x0006e40008000100ULL,
0x0000000000007918ULL, 0x00cfe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000070572caULL, 0x000fe200000e0000ULL, 0x000000200a007824ULL, 0x000fe200078e00ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000ff0b00720cULL, 0x040fe20003f03070ULL,
0x0000820000087ab9ULL, 0x000fe20000000a00ULL, 0x000000010b00780cULL, 0x000fc40003f23070ULL,
0x00000013020a7210ULL, 0x000fe20007f5e0ffULL, 0x0001860005047890ULL, 0x000fe2000fffe03fULL,
0x0000001304047210ULL, 0x000fe40007f7e0ffULL, 0xffffffe000007812ULL, 0x000fe200078ee20fULL,
0x000000ffff0b7224ULL, 0x000fe400010e0603ULL, 0x00000010100f7824ULL, 0x000fe400078e0207ULL,
0x000000ffff057224ULL, 0x000fe400018e0605ULL, 0x0000001000137824ULL, 0x000fe200078e0207ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a0f7faeULL, 0x0007e2000c101c48ULL,
0x0000000436027825ULL, 0x002fc600078e000cULL, 0x0000000004137faeULL, 0x0007e2000c901c48ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x000000ffffff79a7ULL, 0x000fe40008200404ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a84ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x00000008020f7981ULL, 0x008ee2000c1e1900ULL, 0x000000ff1100720cULL, 0x000fe20003f05270ULL,
0x0000007f0f067836ULL, 0x00cfe40000000000ULL, 0x000000ff0f0b7836ULL, 0x000fc60000000000ULL,
0x00000007ff067819ULL, 0x000fe40000011606ULL, 0x00000008ff057819ULL, 0x000fca000001160bULL,
0x0000010800748947ULL, 0x004fea0003800000ULL, 0x000000ff0600720cULL, 0x000fe20003f05270ULL,
0x0000000834047824ULL, 0x000fe200078e00ffULL, 0x000001ff0b00780cULL, 0x000fe20003f24070ULL,
0x00000004ff007424ULL, 0x000fe400078e00ffULL, 0x0000000107037824ULL, 0x000fe400078e0204ULL,
0xffffffffff027424ULL, 0x000fe400078e00ffULL, 0x0186880003ff79a7ULL, 0x0003e8000850003fULL,
0x0000000000188947ULL, 0x000fea0003800000ULL, 0x00009000ff0d7b82ULL, 0x000ea20000000800ULL,
0x0000000236007824ULL, 0x002fce00078e00ffULL, 0x00008c00ff0a7b82ULL, 0x000e620000000a00ULL,
0x0000000d000d7224ULL, 0x004fc800078e020dULL, 0x000000040d0a7825ULL, 0x002fca00078e000aULL,
0x000000080a027981ULL, 0x000324000c1e1900ULL, 0x0000001702007224ULL, 0x012fc800078e02ffULL,
0x0000008000157824ULL, 0x000fe200078e00ffULL, 0x0000000400141947ULL, 0x000fec0003800000ULL,
0x000000040f0b7248ULL, 0x000fe20007fe0000ULL, 0x00008a0000067ab9ULL, 0x000fe20000000a00ULL,
0x00000004ff007819ULL, 0x000fe40000011609ULL, 0x000000f00e1d7812ULL, 0x000fe200078ec0ffULL,
0x000000010b0b7824ULL, 0x000fe400078e0a04ULL, 0x00000001040a7824ULL, 0x000fe400078e0200ULL,
0x00000002000c7836ULL, 0x000fe20000000000ULL, 0x0000000b0000720cULL, 0x000fe20003f66070ULL,
0x00000004000d7836ULL, 0x000fc40000000000ULL, 0x0000000600117836ULL, 0x000fe20000000000ULL,
0x0000000b0c00720cULL, 0x080fe20003f46070ULL, 0x0000008008007824ULL, 0x000fe200078e020aULL,
0x0000000b0d00720cULL, 0x080fe20003f26070ULL, 0x0000000104107824ULL, 0x000fe400078e020cULL,
0x000000010a0c7824ULL, 0x140fe200078e0209ULL, 0x00000000151b7210ULL, 0x000fe20007f1e0ffULL,
0x000000100a137824ULL, 0x000fe400078e00ffULL, 0x00000001100a7824ULL, 0x040fe200078e0209ULL,
0x000000061b1a7c11ULL, 0x000fe2000f8840ffULL, 0x0000001010177824ULL, 0x000fe200078e00ffULL,
0xfffffff0130c7812ULL, 0x000fe200078ee20cULL, 0x000000ffff127224ULL, 0x000fe200000e06ffULL,
0x0000000b1100720cULL, 0x000fe20003f06070ULL, 0x00000004000b7836ULL, 0x000fe20000000000ULL,
0xfffffff017107812ULL, 0x000fe200078ee20aULL, 0x00000002000a7836ULL, 0x000fe20000000000ULL,
0x000000071b1b7c11ULL, 0x000fe2000a0f4412ULL, 0x0000000104127824ULL, 0x040fe200078e020dULL,
0x0000000b15137210ULL, 0x000fe20007fbe0ffULL, 0x00000006000d7836ULL, 0x000fe20000000000ULL,
0x0000000a15187210ULL, 0x000fe20007f9e0ffULL, 0x0000000104147824ULL, 0x000fc400078e0211ULL,
0x0000000112007824ULL, 0x100fe200078e0209ULL, 0x0000000d15117210ULL, 0x000fe20007fde0ffULL,
0x00000001140a7824ULL, 0x040fe400078e0209ULL, 0x0000001014157824ULL, 0x000fe400078e00ffULL,
0x000000ffff0b7224ULL, 0x000fe200020e06ffULL, 0x0000000618167c11ULL, 0x000fe2000f8840ffULL,
0x0000001012177824ULL, 0x000fe200078e00ffULL, 0xfffffff0150e7812ULL, 0x000fe200078ee20aULL,
0x00014000070d7836ULL, 0x000fe20000000000ULL, 0x0000000718187c11ULL, 0x000fe2000a0f440bULL,
0x000000ffff147224ULL, 0x000fe200028e06ffULL, 0x0000001a1d0a7210ULL, 0x000fe20007f9e0ffULL,
0x000000100c157824ULL, 0x100fe200078e020dULL, 0xfffffff017007812ULL, 0x000fe200078ee200ULL,
0x0000001010177824ULL, 0x000fe200078e020dULL, 0x0000000613107c11ULL, 0x000fe2000f8a40ffULL,
0x000000ffff0b7224ULL, 0x000fe200020e061bULL, 0x0000001d160c7210ULL, 0x000fe20007f9e0ffULL,
0x0000001000197824ULL, 0x000fc400078e020dULL, 0x000000ffff007224ULL, 0x000fe200030e06ffULL,
0x0000000611127c11ULL, 0x000fe2000f8c40ffULL, 0x000000100e1b7824ULL, 0x000fe200078e020dULL,
0x00000007130e7c11ULL, 0x000fe2000a8f4414ULL, 0x000000ffff0d7224ULL, 0x000fe200020e0618ULL,
0x0000001d10107210ULL, 0x000fe20007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a157faeULL, 0x0003e2000d901c48ULL, 0x0000000711007c11ULL, 0x000fe4000b0f4400ULL,
0x0000001d12127210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff117224ULL, 0x000fe200028e060eULL,
0x000000000c177faeULL, 0x0003e6000d101c48ULL, 0x000000ffff137224ULL, 0x000fe200020e0600ULL,
0x0000000010197faeULL, 0x0003e8000c901c48ULL, 0x00000000121b7faeULL, 0x0003e2000c101c48ULL,
0x0000000000e87947ULL, 0x000fea0003800000ULL, 0x0000000409007211ULL, 0x000fe200078fe0ffULL,
0x00008a0000067ab9ULL, 0x000fe20000000a00ULL, 0x00014000071b7836ULL, 0x000fe20000000000ULL,
0x000000f00e1d7812ULL, 0x000fe400078ec0ffULL, 0x00000002000a7836ULL, 0x000fe40000000000ULL,
0x00000001000b7824ULL, 0x100fe400078e0209ULL, 0x000000010a0c7824ULL, 0x040fe400078e0209ULL,
0x000000100a0d7824ULL, 0x000fc400078e00ffULL, 0x00000080080a7824ULL, 0x000fe400078e0200ULL,
0x0000001000107824ULL, 0x000fe200078e00ffULL, 0xfffffff00d0d7812ULL, 0x000fe200078ee20cULL,
0x000000040a117836ULL, 0x000fe20000000000ULL, 0x0000000a15167210ULL, 0x000fe20007f3e0ffULL,
0x000000020a0c7836ULL, 0x000fe20000000000ULL, 0xfffffff0100b7812ULL, 0x000fe200078ee20bULL,
0x000000060a127836ULL, 0x000fe20000000000ULL, 0x0000001115137210ULL, 0x000fe20007f7e0ffULL,
0x00000006000a7836ULL, 0x000fe20000000000ULL, 0x0000000c15147210ULL, 0x000fe20007f5e0ffULL,
0x0000000400107836ULL, 0x000fe20000000000ULL, 0x0000001215117210ULL, 0x000fe20007f1e0ffULL,
0x000000010a0c7824ULL, 0x000fc400078e0209ULL, 0x000000100a197824ULL, 0x000fe400078e00ffULL,
0x000000ffff157224ULL, 0x000fe200008e06ffULL, 0x00000006160a7c11ULL, 0x000fe2000f8240ffULL,
0x0000000110007824ULL, 0x040fe200078e0209ULL, 0xfffffff0190c7812ULL, 0x000fe200078ee20cULL,
0x0000001010177824ULL, 0x000fe200078e00ffULL, 0x0000000716167c11ULL, 0x000fe200088f4415ULL,
0x000000100b157824ULL, 0x100fe400078e021bULL, 0x000000ffff0b7224ULL, 0x000fe200010e06ffULL,
0xfffffff017007812ULL, 0x000fe200078ee200ULL, 0x000000100d177824ULL, 0x100fe200078e021bULL,
0x00000006140d7c11ULL, 0x000fe2000f8240ffULL, 0x000000ffff0e7224ULL, 0x000fe200018e06ffULL,
0x0000000613107c11ULL, 0x000fe2000f8440ffULL, 0x0000001000197824ULL, 0x000fe200078e021bULL,
0x0000000714147c11ULL, 0x000fe200088f440bULL, 0x000000ffff007224ULL, 0x000fe200000e06ffULL,
0x0000000a1d0a7210ULL, 0x000fe20007f3e0ffULL, 0x000000100c1b7824ULL, 0x000fe200078e021bULL,
0x0000000611127c11ULL, 0x000fc4000f8640ffULL, 0x0000000d1d0c7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200008e0616ULL, 0x00000007130e7c11ULL, 0x000fe400090f440eULL,
0x000000101d107210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200000e0614ULL,
0x0000000711007c11ULL, 0x000fe200098f4400ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a157faeULL, 0x0003e2000b901c48ULL, 0x000000121d127210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff117224ULL, 0x000fe400008e060eULL, 0x000000000c177faeULL, 0x0003e4000b901c48ULL,
0x000000ffff137224ULL, 0x000fc400010e0600ULL, 0x0000000010197faeULL, 0x0003e8000b901c48ULL,
0x00000000121b7faeULL, 0x0003e4000b901c48ULL, 0x000186a805057890ULL, 0x000fe2000fffe03fULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x000000ff0500720cULL, 0x000fe20003f05270ULL,
0x00000001ff0a7424ULL, 0x000fe200078e00ffULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff007224ULL, 0x000fe200078e00ffULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a45ULL, 0x0000000000267805ULL, 0x000fc4000001ff00ULL,
0x0000000000247805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x000000ffff217224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0186a80a074c79a7ULL, 0x0002a2000850003fULL, 0x000000ffff207224ULL, 0x000fe200078e00ffULL,
0x00000000001e7805ULL, 0x000fe4000001ff00ULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x00000000001a7805ULL, 0x000fc4000001ff00ULL, 0x0000000000187805ULL, 0x000fe4000001ff00ULL,
0x0000000000167805ULL, 0x000fe4000001ff00ULL, 0x0000000000147805ULL, 0x000fe4000001ff00ULL,
0x0000000000127805ULL, 0x000fe4000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0186b80a070a79a7ULL, 0x0022e2000850003fULL, 0x000000f4000c8947ULL, 0x000fea0003800000ULL,
0x00009000ff0d7b82ULL, 0x000f220000000800ULL, 0x00000002360a7824ULL, 0x008fe200078e00ffULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x000000ffff4c7224ULL, 0x004fe400078e004dULL,
0x000000ffff397224ULL, 0x000fe400078e000bULL, 0xff317217ff4e7424ULL, 0x000fe400078e00ffULL,
0x000000ffff4d7224ULL, 0x000fe400078e00ffULL, 0x000000ffff2f7224ULL, 0x000fc400078e00ffULL,
0x0000000d0a0a7224ULL, 0x010fce00078e020dULL, 0x0000000804067899ULL, 0x000fcc000800063fULL,
0x000000060f007c0cULL, 0x000fda000bf03070ULL, 0x000000f000d00947ULL, 0x002fea0003800000ULL,
0x000000ffff0b7224ULL, 0x000fce00078e004dULL, 0x0000000000307805ULL, 0x000fce0000015200ULL,
0x0186b839070075a7ULL, 0x000ea4000800017fULL, 0x00000000005c0947ULL, 0x004fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fce0000015200ULL,
0x0000003230357210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000003532327211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x0186b839070075a7ULL, 0x000ea4000800017fULL,
0xfffffffc00a88947ULL, 0x004fea000383ffffULL, 0x0000000104067890ULL, 0x000fe2000fffe03fULL,
0x0000840000077ab9ULL, 0x000fe40000000800ULL, 0x00000007024f7c24ULL, 0x000fc6000f8e02ffULL,
0x0000000605007c0cULL, 0x000fe2000bf23070ULL, 0x000000804f4f7824ULL, 0x000fd800078e00ffULL,
0x0000000400289947ULL, 0x000fea0003800000ULL, 0x00000004ff377819ULL, 0x000fe20000011609ULL,
0x0000002004067891ULL, 0x000fe2000f8e403fULL, 0x0000002008327811ULL, 0x000fe200078e38ffULL,
0x00008a00000a7ab9ULL, 0x000fe40000000a00ULL, 0x0000000104367824ULL, 0x000fe400078e0237ULL,
0x0000000237397836ULL, 0x000fe40000000000ULL, 0x0000000136307824ULL, 0x040fe400078e0209ULL,
0x0000001036337824ULL, 0x000fc400078e00ffULL, 0x0000000104357824ULL, 0x000fe400078e0239ULL,
0x0000000136367824ULL, 0x000fe200078e0232ULL, 0xfffffff0333c7812ULL, 0x000fe200078ee230ULL,
0x0000000135317824ULL, 0x040fe200078e0209ULL, 0x000000060f307c48ULL, 0x000fe2000ffe0000ULL,
0x00000010353e7824ULL, 0x000fe200078e00ffULL, 0x000000364f337210ULL, 0x000fe20007f1e0ffULL,
0x00000004373b7836ULL, 0x000fe40000000000ULL, 0x00000006373f7836ULL, 0x000fe20000000000ULL,
0xfffffff03e3e7812ULL, 0x000fe200078ee231ULL, 0x8000000630317c36ULL, 0x000fc40008000000ULL,
0x0000000104387824ULL, 0x040fe400078e023bULL, 0x00000001043a7824ULL, 0x000fe200078e023fULL,
0x0000003104317248ULL, 0x000fe20007fe0000ULL, 0x0000000135307824ULL, 0x100fe400078e0232ULL,
0x0000000138367824ULL, 0x040fe400078e0232ULL, 0x00000001383d7824ULL, 0x040fe200078e0209ULL,
0x000000304f307210ULL, 0x000fe20007f9e0ffULL, 0x0000001038407824ULL, 0x000fc400078e00ffULL,
0x000000013a327824ULL, 0x040fe400078e0232ULL, 0x000000013a417824ULL, 0x040fe200078e0209ULL,
0xfffffff040407812ULL, 0x000fe200078ee23dULL, 0x000000103a427824ULL, 0x000fe400078e00ffULL,
0x000000ffff387224ULL, 0x000fe200000e06ffULL, 0x0000000a333a7c11ULL, 0x000fe2000f8040ffULL,
0x0000000131357824ULL, 0x000fe200078e0a04ULL, 0xfffffff042427812ULL, 0x000fe400078ee241ULL,
0x0000000b33317c11ULL, 0x000fe200080f4438ULL, 0x0000001009387824ULL, 0x000fe200078e00ffULL,
0x000000353700720cULL, 0x000fc40003f66070ULL, 0x000000353b00720cULL, 0x080fe20003f06070ULL,
0x000000ffff3b7224ULL, 0x000fe200020e06ffULL, 0x000000364f377210ULL, 0x000fe40007fbe0ffULL,
0x0000000a30337c11ULL, 0x000fe4000f8840ffULL, 0x000000f0383d7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff387224ULL, 0x000fe200028e06ffULL, 0x000000353900720cULL, 0x000fe40003f46070ULL,
0x0000000a37367c11ULL, 0x000fc4000f8c40ffULL, 0x0000000b303b7c11ULL, 0x000fe4000a0f443bULL,
0x000000324f397210ULL, 0x000fe40007f9e0ffULL, 0x0000003d3a307210ULL, 0x000fe40007fbe0ffULL,
0x0000000b37377c11ULL, 0x000fe2000b0f4438ULL, 0x000000ffff3a7224ULL, 0x000fe200020e06ffULL,
0x0000003d33327210ULL, 0x000fe20007fde0ffULL, 0x000000ffff317224ULL, 0x000fe200028e0631ULL,
0x0000000a39387c11ULL, 0x000fc4000f8840ffULL, 0x000000353f00720cULL, 0x000fe20003fa6070ULL,
0x000000ffff337224ULL, 0x000fe200030e063bULL, 0x0000003d36367210ULL, 0x000fe20007fde0ffULL,
0x0001600007357836ULL, 0x000fe20000000000ULL, 0x0000000b39397c11ULL, 0x000fe4000a0f443aULL,
0x0000003d38387210ULL, 0x000fe20007f9e0ffULL, 0x000000103c3b7824ULL, 0x100fe400078e0235ULL,
0x000000103e3d7824ULL, 0x000fe400078e0235ULL, 0x000000ffff377224ULL, 0x000fe200030e0637ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000303b7faeULL, 0x0005e2000d901c48ULL,
0x00000010403f7824ULL, 0x000fc400078e0235ULL, 0x0000001042357824ULL, 0x000fe200078e0235ULL,
0x00000000323d7faeULL, 0x0005e2000d101c48ULL, 0x000000ffff397224ULL, 0x000fc600020e0639ULL,
0x00000000363f7faeULL, 0x0005e8000c101c48ULL, 0x0000000038357faeULL, 0x0005e2000e901c48ULL,
0x0000000000f07947ULL, 0x000fea0003800000ULL, 0x0000000409327211ULL, 0x000fe200078fe0ffULL,
0x00008a0000067ab9ULL, 0x000fe20000000a00ULL, 0x0000002008317811ULL, 0x000fc600078e38ffULL,
0x0000000132307824ULL, 0x140fe400078e0209ULL, 0x0000001032357824ULL, 0x000fe400078e00ffULL,
0x0000000232367836ULL, 0x000fe40000000000ULL, 0x00000006323a7836ULL, 0x000fe20000000000ULL,
0xfffffff035357812ULL, 0x000fe200078ee230ULL, 0x0000000136337824ULL, 0x040fe400078e0209ULL,
0x0000001036387824ULL, 0x000fc400078e00ffULL, 0x0000000132307824ULL, 0x000fe400078e0231ULL,
0x000000013a397824ULL, 0x000fe200078e0209ULL, 0xfffffff038337812ULL, 0x000fe200078ee233ULL,
0x0000000432387836ULL, 0x000fe20000000000ULL, 0x000000304f3e7210ULL, 0x000fe20007f1e0ffULL,
0x0000000136307824ULL, 0x100fe400078e0231ULL, 0x0000000138327824ULL, 0x100fe400078e0231ULL,
0x000000013a367824ULL, 0x000fc400078e0231ULL, 0x0000000138377824ULL, 0x040fe200078e0209ULL,
0x000000324f327210ULL, 0x000fe20007f5e0ffULL, 0x00000010383c7824ULL, 0x000fe200078e00ffULL,
0x000000364f367210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff317224ULL, 0x000fe200000e06ffULL,
0x000000063e387c11ULL, 0x000fe2000f8040ffULL, 0x000000103a3a7824ULL, 0x000fe200078e00ffULL,
0xfffffff03c3d7812ULL, 0x000fe200078ee237ULL, 0x0000001009377824ULL, 0x000fe200078e00ffULL,
0x000000073e3e7c11ULL, 0x000fe400080f4431ULL, 0xfffffff03a397812ULL, 0x000fe200078ee239ULL,
0x00016000073a7836ULL, 0x000fe20000000000ULL, 0x000000304f307210ULL, 0x000fc40007f1e0ffULL,
0x000000f037407812ULL, 0x000fe200078ec0ffULL, 0x00000010333b7824ULL, 0x100fe400078e023aULL,
0x000000ffff317224ULL, 0x000fe200000e06ffULL, 0x0000000630337c11ULL, 0x040fe2000f8040ffULL,
0x00000010393f7824ULL, 0x100fe400078e023aULL, 0x000000ffff397224ULL, 0x000fe200018e06ffULL,
0x00000007303c7c11ULL, 0x000fe200080f4431ULL, 0x000000ffff317224ULL, 0x000fe200010e06ffULL,
0x0000000632377c11ULL, 0x000fe2000f8440ffULL, 0x0000001035357824ULL, 0x100fe200078e023aULL,
0x0000004038307210ULL, 0x000fe20007f1e0ffULL, 0x000000103d3d7824ULL, 0x000fe200078e023aULL,
0x0000000636387c11ULL, 0x000fc4000f8640ffULL, 0x00000007323a7c11ULL, 0x000fe200090f4431ULL,
0x000000ffff317224ULL, 0x000fe200000e063eULL, 0x0000004033327210ULL, 0x000fe40007f1e0ffULL,
0x0000000736397c11ULL, 0x000fe400098f4439ULL, 0x0000004037367210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff337224ULL, 0x000fe200000e063cULL, 0x0000004038387210ULL, 0x000fe20007f7e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030357faeULL, 0x0005e4000b901c48ULL,
0x000000ffff377224ULL, 0x000fc400010e063aULL, 0x000000ffff397224ULL, 0x000fe200018e0639ULL,
0x00000000323b7faeULL, 0x0005e8000b901c48ULL, 0x00000000363d7faeULL, 0x0005e8000b901c48ULL,
0x00000000383f7faeULL, 0x0005e4000b901c48ULL, 0x00000000070672caULL, 0x000fe200000e0000ULL,
0x0000000000007918ULL, 0x004fe20000000000ULL, 0x00000001ff367424ULL, 0x000fd600078e00ffULL,
0x000186b006067890ULL, 0x000fd2000fffe03fULL, 0x00000000ff0079b0ULL, 0x000fe20008000a46ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0186b036075479a7ULL, 0x0004e4000850003fULL,
0x01860836033679a7ULL, 0x004464000850003fULL, 0x0000000000307805ULL, 0x000fce0000015200ULL,
0x01860837030075a7ULL, 0x002e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff387224ULL, 0x000fce00078e00ffULL, 0x000000103800780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fce0000015200ULL,
0x0000003230357210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000003532327211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000138387836ULL, 0x000fce0000000000ULL, 0x01860837030075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00000001ff307819ULL, 0x000fe20000011609ULL,
0x0000001009367824ULL, 0x000fe400078e00ffULL, 0x00000001ff377424ULL, 0x000fe200078e00ffULL,
0x0000000c304b7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff507224ULL, 0x000fe200078e004eULL,
0x0000007036307812ULL, 0x000fc800078ec0ffULL, 0x000000074b4b7210ULL, 0x000fca0007ffe030ULL,
0x018000004b317984ULL, 0x000e680000000800ULL, 0x018200004b337984ULL, 0x0009220000000800ULL,
0x0000004e3100720bULL, 0x002fda0003f1d000ULL, 0x0000000000307806ULL, 0x000fc800000e0100ULL,
0x0000ffff30327812ULL, 0x000fda000780c0ffULL, 0x0000000000e88947ULL, 0x01cfea0003800000ULL,
0x0000004e3100720bULL, 0x000fe40003f14000ULL, 0x000000ff3400720cULL, 0x000fe40003f45270ULL,
0x000000314e507209ULL, 0x000fd20007810000ULL, 0x0000000000357806ULL, 0x000fe400000e0100ULL,
0x018400504b00a388ULL, 0x0003e40000000800ULL, 0x0000991035307816ULL, 0x000fc800000000ffULL,
0x000000ff3000720cULL, 0x000fda0003f05270ULL, 0x0000000000b08947ULL, 0x002fea0003800000ULL,
0x800000504e307221ULL, 0x000fe20000010000ULL, 0x000000ff35ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0035ff7812ULL, 0x000fe2000784c0ffULL, 0x3fb8aa3b30307820ULL, 0x000fc80000410000ULL,
0x0000003000397308ULL, 0x0002ac0000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff307819ULL, 0x002fcc0000011609ULL, 0x00001f3039307589ULL, 0x004e6400000e0000ULL,
0x0000003010107220ULL, 0x082fe20000410000ULL, 0x0000003011117220ULL, 0x080fe20000410000ULL,
0x0000003014147220ULL, 0x080fe20000410000ULL, 0x0000003015157220ULL, 0x080fe20000410000ULL,
0x0000003018187220ULL, 0x080fe20000410000ULL, 0x0000003019197220ULL, 0x080fe20000410000ULL,
0x000000301c1c7220ULL, 0x080fe20000410000ULL, 0x000000301d1d7220ULL, 0x080fe20000410000ULL,
0x0000003020207220ULL, 0x080fe20000410000ULL, 0x0000003021217220ULL, 0x080fe20000410000ULL,
0x0000003024247220ULL, 0x080fe20000410000ULL, 0x0000003025257220ULL, 0x080fe20000410000ULL,
0x0000003028287220ULL, 0x080fe20000410000ULL, 0x0000003029297220ULL, 0x080fe20000410000ULL,
0x000000302c2c7220ULL, 0x080fe20000410000ULL, 0x000000302d2d7220ULL, 0x000fce0000410000ULL,
0x0000003900007220ULL, 0x004fe20000410000ULL, 0x000000000048a947ULL, 0x000fec0003800000ULL,
0x0000000809307811ULL, 0x002fcc00078ff0ffULL, 0x00001f3039307589ULL, 0x000e6400000e0000ULL,
0x0000003012127220ULL, 0x082fe20000410000ULL, 0x0000003013137220ULL, 0x080fe20000410000ULL,
0x0000003016167220ULL, 0x080fe20000410000ULL, 0x0000003017177220ULL, 0x080fe20000410000ULL,
0x000000301a1a7220ULL, 0x080fe20000410000ULL, 0x000000301b1b7220ULL, 0x080fe20000410000ULL,
0x000000301e1e7220ULL, 0x080fe20000410000ULL, 0x000000301f1f7220ULL, 0x080fe20000410000ULL,
0x0000003022227220ULL, 0x080fe20000410000ULL, 0x0000003023237220ULL, 0x080fe20000410000ULL,
0x0000003026267220ULL, 0x080fe20000410000ULL, 0x0000003027277220ULL, 0x080fe20000410000ULL,
0x000000302a2a7220ULL, 0x080fe20000410000ULL, 0x000000302b2b7220ULL, 0x080fe20000410000ULL,
0x000000302e2e7220ULL, 0x080fe20000410000ULL, 0x000000302f2f7220ULL, 0x000fce0000410000ULL,
0x0000ffff32ff7812ULL, 0x000fda0007806035ULL, 0x8000005031310221ULL, 0x000fe20000010000ULL,
0x00007610ff370816ULL, 0x000fc60000000037ULL, 0x3fb8aa3b31310820ULL, 0x000fc80000410000ULL,
0x00000031000c0308ULL, 0x000ea40000000800ULL, 0x0000000c33330220ULL, 0x004fce0000410000ULL,
0x0000000033007221ULL, 0x000fe20000010000ULL, 0x0000000000307805ULL, 0x002fe20000015200ULL,
0x0186a84c070075a7ULL, 0x000ea4000800017fULL, 0x00000000005c0947ULL, 0x006fea0003800000ULL,
0x000000ffff387224ULL, 0x000fce00078e00ffULL, 0x000000103800780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fcc0000015200ULL,
0x0000003230357210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000003532327211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000138387836ULL, 0x000fce0000000000ULL, 0x0186a84c070075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000709407812ULL, 0x040fe200078ec0ffULL,
0x0001400007447836ULL, 0x000fe20000000000ULL, 0x0000000809307812ULL, 0x000fe400078ec0ffULL,
0x00000004ff357819ULL, 0x000fe40000011609ULL, 0x0000991037317816ULL, 0x000fe400000000ffULL,
0x0000000840407812ULL, 0x000fe200078ef809ULL, 0x0000000434527824ULL, 0x000fe200078e0235ULL,
0x0000000730517812ULL, 0x000fc400078ef809ULL, 0x000000ff3100720cULL, 0x000fe20003f45270ULL,
0x0000000135377824ULL, 0x000fe200078e0240ULL, 0x00000002344c7811ULL, 0x000fe200078e10ffULL,
0x0000000151307824ULL, 0x040fe400078e0252ULL, 0x0000001051497824ULL, 0x000fe400078e00ffULL,
0x00000008404a7824ULL, 0x000fc600078e00ffULL, 0xfffffff049497812ULL, 0x000fe400078ee230ULL,
0xfffffff84a4a7812ULL, 0x000fc600078ee237ULL, 0x0000001049497824ULL, 0x000fe400078e0244ULL,
0x000000104a4a7824ULL, 0x000fe200078e0207ULL, 0x0000000000182947ULL, 0x000fec0003800000ULL,
0x00000002ff337819ULL, 0x000fe40000011609ULL, 0x0000000cff0d723eULL, 0x000fc600000010ffULL,
0x0000000833317836ULL, 0x000fe20000000000ULL, 0x000054100d307816ULL, 0x000fca000000000dULL,
0x00001f33300d7589ULL, 0x0002a800000e0000ULL, 0x00001f31300e7589ULL, 0x0002e400000e0000ULL,
0x012000004a30783bULL, 0x0022e20000000200ULL, 0x0000000000102947ULL, 0x000fea0003800000ULL,
0x0000000d30307232ULL, 0x08cfe40000200000ULL, 0x0000000d32327232ULL, 0x000fe40000200000ULL,
0x0000000e31317232ULL, 0x080fe40000200000ULL, 0x0000000e33337232ULL, 0x000fce0000200000ULL,
0x00000000493c783bULL, 0x000f220000004200ULL, 0x0000000135427824ULL, 0x000fe400078e024cULL,
0x0000001051397824ULL, 0x040fe400078e00ffULL, 0x0000000151387824ULL, 0x000fca00078e0242ULL,
0xfffffff039397812ULL, 0x000fca00078ee238ULL, 0x0000001039487824ULL, 0x000fca00078e0244ULL,
0x000000004838783bULL, 0x000f620000004200ULL, 0x00000018ff5a7819ULL, 0x010fe2000001143cULL,
0x000001003c477824ULL, 0x040fe200078e00ffULL, 0x000088803c587816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5b7819ULL, 0x000fe2000001143dULL,
0x000001003d4e7824ULL, 0x040fe200078e00ffULL, 0x00000018ff477819ULL, 0x000fe20000011447ULL,
0x0000005a005a7306ULL, 0x000fe20000202400ULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x000088803d627816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4e7819ULL, 0x000fc4000001144eULL, 0x00000018ff597819ULL, 0x000fe2000001143eULL,
0x0000004700637306ULL, 0x0009e20000202400ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff577819ULL, 0x000fe4000001143fULL, 0x000088803e5c7816ULL, 0x040fe400000000ffULL,
0x000088803f5d7816ULL, 0x000fe200000000ffULL, 0x0000003c00617306ULL, 0x000be20000202400ULL,
0x000001003e477824ULL, 0x050fe200078e00ffULL, 0x00000018ff467819ULL, 0x022fe20000011438ULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff417819ULL, 0x000fc40000011439ULL,
0x00000018ff477819ULL, 0x000fe40000011447ULL, 0x0000005800587306ULL, 0x000e620000202400ULL,
0x000001003f3c7824ULL, 0x048fe200078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff437819ULL, 0x000fe4000001143aULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000006200627306ULL, 0x000fe20000202400ULL,
0x00000018ff3f7819ULL, 0x000fc4000001143fULL, 0x000088803b677816ULL, 0x000fe400000000ffULL,
0x00000018ff457819ULL, 0x000fc6000001143bULL, 0x0000004e00657306ULL, 0x0007300000202400ULL,
0x0000003d00647306ULL, 0x000be20000202400ULL, 0x00008880384e7816ULL, 0x008fce00000000ffULL,
0x00000047005f7306ULL, 0x0007e20000202400ULL, 0x00000100383d7824ULL, 0x064fe400078e00ffULL,
0x0001000038387824ULL, 0x000fc600078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000003c00667306ULL, 0x0005e20000202400ULL, 0x0000888039477816ULL, 0x008fe400000000ffULL,
0x00000018ff387819ULL, 0x000fca0000011438ULL, 0x0000005b005b7306ULL, 0x000ee20000202400ULL,
0x00000100393c7824ULL, 0x044fe400078e00ffULL, 0x0001000039397824ULL, 0x000fc600078e00ffULL,
0x00000018ff567819ULL, 0x000fe4000001143cULL, 0x00000018ff397819ULL, 0x000fe20000011439ULL,
0x0000003e005e7306ULL, 0x000fe20000202400ULL, 0x000088803a3c7816ULL, 0x000fce00000000ffULL,
0x0000003f00607306ULL, 0x000ff00000202400ULL, 0x00000038003f7306ULL, 0x0003f00000202400ULL,
0x00000039003e7306ULL, 0x0009e20000202400ULL, 0x0000541058387816ULL, 0x002fe20000000063ULL,
0x000000ffff587224ULL, 0x000fcc00078e0067ULL, 0x0000005c005c7306ULL, 0x000e620000202400ULL,
0x0000541062397816ULL, 0x010fe20000000065ULL, 0x000001003b627824ULL, 0x040fe400078e00ffULL,
0x000100003b3b7824ULL, 0x000fc800078e00ffULL, 0x0000005d005d7306ULL, 0x000ea20000202400ULL,
0x000000383010723cULL, 0x000fe20000041810ULL, 0x00000018ff3b7819ULL, 0x000fcc000001143bULL,
0x0000541061387816ULL, 0x000fe2000000005aULL, 0x0000005900597306ULL, 0x000f220000202400ULL,
0x0000541064397816ULL, 0x008fe4000000005bULL, 0x00000018ff5b7819ULL, 0x000fca0000011462ULL,
0x0000005700577306ULL, 0x000ee20000202400ULL, 0x000000383014723cULL, 0x000fee0000041814ULL,
0x000054105c387816ULL, 0x002fe2000000005fULL, 0x0000004e004e7306ULL, 0x000fe20000202400ULL,
0x000054105d397816ULL, 0x004fce0000000066ULL, 0x0000003d00537306ULL, 0x0002a20000202400ULL,
0x000000383018723cULL, 0x000fee0000041818ULL, 0x0000004700477306ULL, 0x000fe20000202400ULL,
0x000054105e387816ULL, 0x010fe20000000059ULL, 0x000001003a3d7824ULL, 0x002fe200078e00ffULL,
0x0000541060397816ULL, 0x008fe20000000057ULL, 0x000100003a3a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe2000001143dULL, 0x0000005600567306ULL, 0x000e620000202400ULL,
0x00000018ff3a7819ULL, 0x000fe2000001143aULL, 0x00000038301c723cULL, 0x000fec000004181cULL,
0x0000004600467306ULL, 0x000ee20000202400ULL, 0x000054104e387816ULL, 0x004fe20000000053ULL,
0x00000008404e7824ULL, 0x000fe200078e00ffULL, 0x0000001051537812ULL, 0x000fc400078efcffULL,
0x0000541047397816ULL, 0x002fc60000000056ULL, 0x0000004100417306ULL, 0x000e680000202400ULL,
0x000000383020723cULL, 0x000fe20000041820ULL, 0x000054103f467816ULL, 0x008fc60000000046ULL,
0x0000003c003c7306ULL, 0x000fe60000202400ULL, 0x0000000237397836ULL, 0x000fe20000000000ULL,
0x000054103e477816ULL, 0x002fc80000000041ULL, 0x0000003d003d7306ULL, 0x000e620000202400ULL,
0x0000000152417824ULL, 0x000fe400078e0253ULL, 0x00000010533e7824ULL, 0x000fe200078e00ffULL,
0x000000463024723cULL, 0x000fe80000041824ULL, 0x0000004300437306ULL, 0x000fe20000202400ULL,
0xfffffff03e417812ULL, 0x000fe400078ee241ULL, 0xfffffff84e467812ULL, 0x000fc400078ee239ULL,
0x000054103c3c7816ULL, 0x002fc6000000003dULL, 0x0000004500457306ULL, 0x000fe20000202400ULL,
0x0000001046467824ULL, 0x000fce00078e0207ULL, 0x0000005800587306ULL, 0x000ff00000202400ULL,
0x0000005b005b7306ULL, 0x000e700000202400ULL, 0x0000003a003a7306ULL, 0x000ea20000202400ULL,
0x00005410583d7816ULL, 0x002fce000000005bULL, 0x0000003b00387306ULL, 0x000e620000202400ULL,
0x0000003c3028723cULL, 0x000fe20000041828ULL, 0x000054103a3a7816ULL, 0x004fe40000000043ULL,
0x00005410383b7816ULL, 0x002fe20000000045ULL, 0x0000001041457824ULL, 0x000fcc00078e0244ULL,
0x0000003a302c723cULL, 0x000fe2000004182cULL, 0x012000004630783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000102947ULL, 0x000fde0003800000ULL,
0x0000000d30307232ULL, 0x084fe40000200000ULL, 0x0000000d32327232ULL, 0x000fe40000200000ULL,
0x0000000e31317232ULL, 0x080fe40000200000ULL, 0x0000000e33337232ULL, 0x000fce0000200000ULL,
0x0000004c534e7210ULL, 0x040fe20007ffe035ULL, 0x0000001053537824ULL, 0x000fe200078e00ffULL,
0x00000000453c783bULL, 0x000ee80000004200ULL, 0xfffffff0534e7812ULL, 0x000fca00078ee24eULL,
0x000000104e447824ULL, 0x000fca00078e0244ULL, 0x000000004438783bULL, 0x000f220000004200ULL,
0x00000018ff617819ULL, 0x008fe2000001143cULL, 0x000001003c567824ULL, 0x040fe200078e00ffULL,
0x00000018ff607819ULL, 0x000fe2000001143dULL, 0x000001003d577824ULL, 0x040fe200078e00ffULL,
0x000088803c637816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x000088803d677816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff567819ULL, 0x000fe20000011456ULL, 0x0000006100617306ULL, 0x000fe20000202400ULL,
0x00000018ff3c7819ULL, 0x000fc4000001143cULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff537819ULL, 0x010fe40000011438ULL, 0x0000888038597816ULL, 0x000fe200000000ffULL,
0x0000005600687306ULL, 0x0007e20000202400ULL, 0x00000018ff577819ULL, 0x000fe40000011457ULL,
0x00000018ff5c7819ULL, 0x000fe4000001143fULL, 0x000088803f647816ULL, 0x000fc400000000ffULL,
0x00000018ff4c7819ULL, 0x000fe20000011439ULL, 0x0000003c00667306ULL, 0x0009e20000202400ULL,
0x000001003e567824ULL, 0x048fe200078e00ffULL, 0x0000888039587816ULL, 0x000fe400000000ffULL,
0x000088803e627816ULL, 0x040fe400000000ffULL, 0x00000018ff567819ULL, 0x000fe40000011456ULL,
0x0000003d00697306ULL, 0x0007e20000202400ULL, 0x000001003f3c7824ULL, 0x050fe200078e00ffULL,
0x00000018ff5d7819ULL, 0x000fe2000001143eULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff437819ULL, 0x000fe2000001143aULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fc4000001143cULL, 0x0000006300637306ULL, 0x000fe20000202400ULL,
0x00000100383d7824ULL, 0x048fe200078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x0001000038387824ULL, 0x000fe200078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000006700677306ULL, 0x000fe20000202400ULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x00000018ff477819ULL, 0x000fca000001143bULL,
0x00000057006a7306ULL, 0x000ef00000202400ULL, 0x0000005600657306ULL, 0x000ff00000202400ULL,
0x0000003c006b7306ULL, 0x0009f00000202400ULL, 0x0000003800567306ULL, 0x000be20000202400ULL,
0x00000100393c7824ULL, 0x010fc400078e00ffULL, 0x0001000039397824ULL, 0x000fc600078e00ffULL,
0x00000018ff5b7819ULL, 0x000fe4000001143cULL, 0x0000006000607306ULL, 0x000f220000202400ULL,
0x000001003b387824ULL, 0x022fe200078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x000088803a3c7816ULL, 0x000fe400000000ffULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x0000003f005f7306ULL, 0x000ff00000202400ULL, 0x0000003900577306ULL, 0x0007f00000202400ULL,
0x00000038003f7306ULL, 0x0003e20000202400ULL, 0x0000541067397816ULL, 0x008fce000000006aULL,
0x0000006200627306ULL, 0x000ee20000202400ULL, 0x0000541063387816ULL, 0x002fce0000000068ULL,
0x0000006400647306ULL, 0x000e620000202400ULL, 0x000000383010723cULL, 0x004fee0000041810ULL,
0x0000541066387816ULL, 0x000fe20000000061ULL, 0x0000005d005d7306ULL, 0x000fe20000202400ULL,
0x0000541069397816ULL, 0x010fce0000000060ULL, 0x0000005c005c7306ULL, 0x000fe20000202400ULL,
0x000000383014723cULL, 0x000fee0000041814ULL, 0x0000003e005e7306ULL, 0x0005220000202400ULL,
0x0000541062387816ULL, 0x008fe40000000065ULL, 0x0000541064397816ULL, 0x002fca000000006bULL,
0x0000005900597306ULL, 0x000fe20000202400ULL, 0x000088803b3e7816ULL, 0x044fe200000000ffULL,
0x000000383018723cULL, 0x000fe20000041818ULL, 0x000100003b3b7824ULL, 0x000fca00078e00ffULL,
0x0000003d005a7306ULL, 0x0002a20000202400ULL, 0x000054105e387816ULL, 0x010fe4000000005dULL,
0x000054105f397816ULL, 0x000fe4000000005cULL, 0x00000018ff3b7819ULL, 0x000fc6000001143bULL,
0x0000005800587306ULL, 0x000fe20000202400ULL, 0x000001003a3d7824ULL, 0x042fe200078e00ffULL,
0x00000038301c723cULL, 0x000fe2000004181cULL, 0x000100003a3a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000005b005b7306ULL, 0x000e620000202400ULL,
0x00000018ff3a7819ULL, 0x000fe4000001143aULL, 0x0000541059387816ULL, 0x004fca000000005aULL,
0x0000005300537306ULL, 0x000ea20000202400ULL, 0x0000541058397816ULL, 0x002fce000000005bULL,
0x0000004c004c7306ULL, 0x000e620000202400ULL, 0x000000383020723cULL, 0x000fee0000041820ULL,
0x0000003c003c7306ULL, 0x000fe20000202400ULL, 0x0000541056387816ULL, 0x004fe40000000053ULL,
0x0000541057397816ULL, 0x002fca000000004cULL, 0x0000003d003d7306ULL, 0x000e640000202400ULL,
0x000000383024723cULL, 0x000fec0000041824ULL, 0x0000004300437306ULL, 0x000fe20000202400ULL,
0x00000001ff387424ULL, 0x000fe200078e00ffULL, 0x000054103c3c7816ULL, 0x002fcc000000003dULL,
0x0000004700477306ULL, 0x000fe20000202400ULL, 0x0186b838073879a7ULL, 0x000e6e000850003fULL,
0x0000003e003e7306ULL, 0x000eb00000202400ULL, 0x0000003a003a7306ULL, 0x000ee20000202400ULL,
0x000054103e3d7816ULL, 0x004fce000000003fULL, 0x0000003b00607306ULL, 0x000ea20000202400ULL,
0x0000003c3028723cULL, 0x000fe20000041828ULL, 0x000054103a3a7816ULL, 0x008fe40000000043ULL,
0x00005410603b7816ULL, 0x004fce0000000047ULL, 0x0000003a302c723cULL, 0x000fee000004182cULL,
0x0000000000307805ULL, 0x000fe20000015200ULL, 0x0186b839070075a7ULL, 0x002e64000800017fULL,
0x00000000005c0947ULL, 0x002fdc0003800000ULL, 0x000000ffff3a7224ULL, 0x000fce00078e00ffULL,
0x000000103a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x000fcc0000015200ULL, 0x00000032303b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000133337824ULL, 0x000fe200000e0e31ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff327819ULL, 0x000fc80000011433ULL,
0x0000003b32327211ULL, 0x000fca00078110ffULL, 0x000000ffff337224ULL, 0x000fca00000e0633ULL,
0x0000000232327819ULL, 0x000fc80000001233ULL, 0x000000320000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013a3a7836ULL, 0x000fce0000000000ULL,
0x0186b839070075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000004004077891ULL, 0x000fe2000f8e403fULL, 0x00000004001c9947ULL, 0x000ff60003800000ULL,
0x0000000104327824ULL, 0x000fe200078e0235ULL, 0x0000004008387811ULL, 0x000fe200078e38ffULL,
0x0000000235397836ULL, 0x000fe20000000000ULL, 0x00008a00000a7ab9ULL, 0x000fe20000000a00ULL,
0x0000000132307824ULL, 0x000fe200078e0209ULL, 0x000000f0364c7812ULL, 0x000fe200078ec0ffULL,
0x0000001032337824ULL, 0x000fe400078e00ffULL, 0x00000001043a7824ULL, 0x000fe400078e0239ULL,
0x0000000132327824ULL, 0x000fe200078e0238ULL, 0xfffffff0333e7812ULL, 0x000fe200078ee230ULL,
0x000000013a317824ULL, 0x040fe200078e0209ULL, 0x000000070f307c48ULL, 0x000fe2000ffe0000ULL,
0x000000103a567824ULL, 0x000fe200078e00ffULL, 0x000000324f337210ULL, 0x000fe20007f1e0ffULL,
0x0000000435537836ULL, 0x000fc40000000000ULL, 0x0000000635577836ULL, 0x000fe20000000000ULL,
0xfffffff056567812ULL, 0x000fe200078ee231ULL, 0x8000000730317c36ULL, 0x000fe40008000000ULL,
0x000000013a307824ULL, 0x000fe400078e0238ULL, 0x00000001043d7824ULL, 0x000fe200078e0253ULL,
0x0000003104317248ULL, 0x000fe20007fe0000ULL, 0x000000ffff3c7224ULL, 0x000fe200000e06ffULL,
0x000000304f307210ULL, 0x000fe20007f7e0ffULL, 0x000000013d437824ULL, 0x000fe200078e0209ULL,
0x0000000a33327c11ULL, 0x000fe2000f8040ffULL, 0x00000001313a7824ULL, 0x000fc400078e0a04ULL,
0x000000ffff3f7224ULL, 0x000fe200018e06ffULL, 0x0000000a303b7c11ULL, 0x040fe2000f8640ffULL,
0x000000103d587824ULL, 0x000fe200078e00ffULL, 0x0000003a3500720cULL, 0x080fe40003f86070ULL,
0x0000000b303f7c11ULL, 0x000fe200098f443fULL, 0x000000013d307824ULL, 0x000fe200078e0238ULL,
0xfffffff058587812ULL, 0x000fe200078ee243ULL, 0x0001400007437836ULL, 0x000fe20000000000ULL,
0x0000000b33337c11ULL, 0x000fe200080f443cULL, 0x00000001043c7824ULL, 0x000fe200078e0257ULL,
0x0000004c32327210ULL, 0x000fe20007f7e0ffULL, 0x000000103e477824ULL, 0x000fe200078e0243ULL,
0x000000304f307210ULL, 0x000fe20007fbe0ffULL, 0x000000013c387824ULL, 0x000fe200078e0238ULL,
0x0000003a3900720cULL, 0x080fe20003f06070ULL, 0x000000ffff337224ULL, 0x000fe200018e0633ULL,
0x0000003a5300720cULL, 0x000fe20003f66070ULL, 0x000000ffff317224ULL, 0x000fe200028e06ffULL,
0x0000000a303d7c11ULL, 0x000fe2000f8a40ffULL, 0x000000013c537824ULL, 0x040fe200078e0209ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000032477faeULL, 0x0003e2000e101c48ULL,
0x000000384f397210ULL, 0x000fe20007f9e0ffULL, 0x000000103c5a7824ULL, 0x000fe200078e00ffULL,
0x0000000b303e7c11ULL, 0x000fc4000a8f4431ULL, 0x0000004c3b307210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff3c7224ULL, 0x000fe200020e06ffULL, 0x0000000a393b7c11ULL, 0x000fe4000f8840ffULL,
0x0000004c3d387210ULL, 0x000fe20007fde0ffULL, 0x000000ffff317224ULL, 0x000fe200028e063fULL,
0x0000003a5700720cULL, 0x000fe20003fa6070ULL, 0x00000010583d7824ULL, 0x000fe200078e0243ULL,
0x0000000b39337c11ULL, 0x002fe2000a0f443cULL, 0x000000ffff397224ULL, 0x000fe200030e063eULL,
0xfffffff05a5a7812ULL, 0x000fc400078ee253ULL, 0x0000004c3b327210ULL, 0x000fe20007f9e0ffULL,
0x00000010563b7824ULL, 0x100fe400078e0243ULL, 0x000000105a437824ULL, 0x000fe400078e0243ULL,
0x000000ffff337224ULL, 0x000fe200020e0633ULL, 0x00000000303b7faeULL, 0x0003e8000c101c48ULL,
0x00000000383d7faeULL, 0x0003e8000d901c48ULL, 0x0000000032437faeULL, 0x0003e2000e901c48ULL,
0x0000000000ec7947ULL, 0x000fea0003800000ULL, 0x0000000104387824ULL, 0x000fe200078e0235ULL,
0x0000004008397811ULL, 0x000fe200078e38ffULL, 0x00008a00000a7ab9ULL, 0x000fe20000000a00ULL,
0x000000f036537812ULL, 0x000fe200078ec0ffULL, 0x00000001383a7824ULL, 0x040fe400078e0209ULL,
0x00000010383d7824ULL, 0x040fe400078e00ffULL, 0x0000000438327836ULL, 0x000fe40000000000ULL,
0x0000000238307836ULL, 0x000fe20000000000ULL, 0xfffffff03d3d7812ULL, 0x000fe200078ee23aULL,
0x00000001383a7824ULL, 0x000fc400078e0239ULL, 0x0000000132337824ULL, 0x140fe400078e0209ULL,
0x00000010323e7824ULL, 0x000fe200078e00ffULL, 0x0000003a4f3b7210ULL, 0x000fe20007f1e0ffULL,
0x0000000130317824ULL, 0x040fe400078e0209ULL, 0x00000010303c7824ULL, 0x040fe200078e00ffULL,
0xfffffff03e337812ULL, 0x000fe200078ee233ULL, 0x0000000638387836ULL, 0x000fe20000000000ULL,
0x0000000a3b477c11ULL, 0x000fe2000f8640ffULL, 0x0000000130307824ULL, 0x100fe200078e0239ULL,
0xfffffff03c317812ULL, 0x000fe200078ee231ULL, 0x0000000132327824ULL, 0x000fc400078e0239ULL,
0x00000001383a7824ULL, 0x040fe400078e0239ULL, 0x0000000138397824ULL, 0x040fe400078e0209ULL,
0x00000010383e7824ULL, 0x000fe400078e00ffULL, 0x000000ffff3c7224ULL, 0x000fe200000e06ffULL,
0x000000304f307210ULL, 0x000fe20007f1e0ffULL, 0x0001400007387836ULL, 0x000fe20000000000ULL,
0xfffffff03e397812ULL, 0x000fe400078ee239ULL, 0x0000000b3b4c7c11ULL, 0x000fe200098f443cULL,
0x000000103d577824ULL, 0x100fe200078e0238ULL, 0x000000324f327210ULL, 0x000fe20007f7e0ffULL,
0x00000010313d7824ULL, 0x100fe200078e0238ULL, 0x0000003a4f3b7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff317224ULL, 0x000fe200000e06ffULL, 0x0000000a303e7c11ULL, 0x000fe2000f8040ffULL,
0x00000010333f7824ULL, 0x000fc400078e0238ULL, 0x0000001039437824ULL, 0x000fe200078e0238ULL,
0x0000000b30337c11ULL, 0x000fe200080f4431ULL, 0x000000ffff317224ULL, 0x000fe200018e06ffULL,
0x0000000a32397c11ULL, 0x040fe2000f8040ffULL, 0x000000ffff387224ULL, 0x000fe200020e06ffULL,
0x0000000a3b3a7c11ULL, 0x040fe4000f8640ffULL, 0x0000005347307210ULL, 0x000fe40007fbe0ffULL,
0x0000000b323c7c11ULL, 0x000fe400080f4431ULL, 0x000000533e327210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff317224ULL, 0x000fe200028e064cULL, 0x0000000b3b3b7c11ULL, 0x000fc400098f4438ULL,
0x0000005339387210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff337224ULL, 0x000fe200000e0633ULL,
0x000000533a3a7210ULL, 0x000fe20007f9e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000030577faeULL, 0x0003e4000b901c48ULL, 0x000000ffff397224ULL, 0x000fe400018e063cULL,
0x000000ffff3b7224ULL, 0x000fe200020e063bULL, 0x00000000323d7faeULL, 0x0003e8000b901c48ULL,
0x00000000383f7faeULL, 0x0003e8000b901c48ULL, 0x000000003a437faeULL, 0x0003e4000b901c48ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x00000001ff307424ULL, 0x000fe200078e00ffULL,
0x00000000ff0079b0ULL, 0x000fe20008000a45ULL, 0x0000000000007918ULL, 0x000fc80000000000ULL,
0x0186a830073079a7ULL, 0x000e64000850003fULL, 0x000000ffff4c7224ULL, 0x002fe200078e0031ULL,
0x0000000000307805ULL, 0x000fe20000015200ULL, 0x0186b055070075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff387224ULL, 0x000fce00078e00ffULL,
0x000000103800780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x000fcc0000015200ULL, 0x0000003230397210ULL, 0x000fca0007f1e1ffULL,
0x0000000133337824ULL, 0x000fe200000e0e31ULL, 0x003d09003900780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403900780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff327819ULL, 0x000fc80000011433ULL,
0x0000003932327211ULL, 0x000fca00078110ffULL, 0x000000ffff337224ULL, 0x000fca00000e0633ULL,
0x0000000232327819ULL, 0x000fc80000001233ULL, 0x000000320000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000138387836ULL, 0x000fce0000000000ULL,
0x0186b055070075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000437307836ULL, 0x000fe40000000000ULL, 0x0000000840337824ULL, 0x000fe400078e00ffULL,
0x0000000151317824ULL, 0x040fe400078e0252ULL, 0x0000001051327824ULL, 0x000fe200078e00ffULL,
0xfffffff833307812ULL, 0x000fe200078ee230ULL, 0x0001600007527836ULL, 0x000fc60000000000ULL,
0xfffffff032437812ULL, 0x000fe200078ee231ULL, 0x0000001030477824ULL, 0x000fe200078e0207ULL,
0x0000000000182947ULL, 0x000fec0003800000ULL, 0x00000002ff317819ULL, 0x000fe40000011609ULL,
0x0000000cff0d723eULL, 0x000fc600000010ffULL, 0x0000000831337836ULL, 0x000fe20000000000ULL,
0x000054100d307816ULL, 0x000fca000000000dULL, 0x00001f31300d7589ULL, 0x0002a800000e0000ULL,
0x00001f33300e7589ULL, 0x0002e400000e0000ULL, 0x012000004730783bULL, 0x0022e20000000200ULL,
0x0000001043437824ULL, 0x000fe200078e0252ULL, 0x0000000000102947ULL, 0x000fec0003800000ULL,
0x0000000d30307232ULL, 0x08cfe40000200000ULL, 0x0000000d32327232ULL, 0x000fe40000200000ULL,
0x0000000e31317232ULL, 0x080fe40000200000ULL, 0x0000000e33337232ULL, 0x000fce0000200000ULL,
0x00000000433c783bULL, 0x000f220000004200ULL, 0x0000000151427824ULL, 0x040fe400078e0242ULL,
0x0000001051397824ULL, 0x000fe400078e00ffULL, 0x0000000637377836ULL, 0x000fe40000000000ULL,
0x0000001041417824ULL, 0x000fe200078e0252ULL, 0xfffffff039397812ULL, 0x000fca00078ee242ULL,
0x0000001039427824ULL, 0x000fca00078e0252ULL, 0x000000004238783bULL, 0x000f620000004200ULL,
0x00000018ff617819ULL, 0x010fe2000001143cULL, 0x000001003c567824ULL, 0x040fe200078e00ffULL,
0x000088803c577816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff607819ULL, 0x000fe2000001143dULL, 0x000001003d587824ULL, 0x040fe200078e00ffULL,
0x000088803d657816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x0000005700577306ULL, 0x000fe20000202400ULL,
0x00000018ff567819ULL, 0x000fc40000011456ULL, 0x00000018ff587819ULL, 0x000fe40000011458ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff5c7819ULL, 0x000fe2000001143fULL,
0x0000003c00667306ULL, 0x0009e20000202400ULL, 0x000088803f647816ULL, 0x000fe200000000ffULL,
0x000001003b6b7824ULL, 0x022fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fe40000011438ULL,
0x00000018ff557819ULL, 0x000fc40000011439ULL, 0x0000888038597816ULL, 0x000fe200000000ffULL,
0x0000005600687306ULL, 0x0003620000202400ULL, 0x000001003f3c7824ULL, 0x050fe200078e00ffULL,
0x000088803e627816ULL, 0x040fe200000000ffULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5d7819ULL, 0x000fe4000001143eULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000006500657306ULL, 0x000fe20000202400ULL, 0x000001003e567824ULL, 0x042fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff517819ULL, 0x000fc4000001143aULL, 0x00000018ff567819ULL, 0x000fe40000011456ULL,
0x00000058006a7306ULL, 0x0003220000202400ULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x00000018ff537819ULL, 0x000fca000001143bULL, 0x0000003d00677306ULL, 0x0009e20000202400ULL,
0x0000888039587816ULL, 0x002fce00000000ffULL, 0x0000003c00697306ULL, 0x0003e20000202400ULL,
0x00000100383d7824ULL, 0x054fe400078e00ffULL, 0x0001000038387824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000006100617306ULL, 0x000ea20000202400ULL,
0x00000100393c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff387819ULL, 0x000fe20000011438ULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff5b7819ULL, 0x000fe4000001143cULL,
0x0000006000607306ULL, 0x000e620000202400ULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x000088803a3c7816ULL, 0x000fca00000000ffULL, 0x0000005600637306ULL, 0x000ff00000202400ULL,
0x0000003f005f7306ULL, 0x000ff00000202400ULL, 0x00000038003f7306ULL, 0x000bf00000202400ULL,
0x0000003900567306ULL, 0x0009e20000202400ULL, 0x0000541057387816ULL, 0x028fc40000000068ULL,
0x00000018ff577819ULL, 0x000fca000001146bULL, 0x0000006200627306ULL, 0x000ee20000202400ULL,
0x0000541065397816ULL, 0x010fce000000006aULL, 0x0000006400647306ULL, 0x000f220000202400ULL,
0x000000383010723cULL, 0x000fee0000041810ULL, 0x0000541066387816ULL, 0x004fe20000000061ULL,
0x0000005d005d7306ULL, 0x000fe20000202400ULL, 0x0000541067397816ULL, 0x002fce0000000060ULL,
0x0000005c005c7306ULL, 0x000fe20000202400ULL, 0x000000383014723cULL, 0x000fee0000041814ULL,
0x0000003e005e7306ULL, 0x0002a20000202400ULL, 0x0000541062387816ULL, 0x008fe40000000063ULL,
0x0000541064397816ULL, 0x010fca0000000069ULL, 0x0000005900597306ULL, 0x000fe20000202400ULL,
0x000088803b3e7816ULL, 0x042fe200000000ffULL, 0x000100003b3b7824ULL, 0x000fe200078e00ffULL,
0x000000383018723cULL, 0x000fe80000041818ULL, 0x00000018ff3b7819ULL, 0x000fe2000001143bULL,
0x0000003d005a7306ULL, 0x0002e40000202400ULL, 0x000054105e387816ULL, 0x004fc4000000005dULL,
0x000054105f397816ULL, 0x000fc8000000005cULL, 0x0000005800587306ULL, 0x000fe20000202400ULL,
0x000001003a3d7824ULL, 0x042fe400078e00ffULL, 0x000100003a3a7824ULL, 0x000fe200078e00ffULL,
0x00000038301c723cULL, 0x000fe4000004181cULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000005b005b7306ULL, 0x000e620000202400ULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x0000541059387816ULL, 0x008fca000000005aULL, 0x0000003c003c7306ULL, 0x000fe20000202400ULL,
0x0000541058397816ULL, 0x002fce000000005bULL, 0x0000003d003d7306ULL, 0x000e620000202400ULL,
0x000000383020723cULL, 0x000fee0000041820ULL, 0x0000005400547306ULL, 0x000ea20000202400ULL,
0x0000000840387824ULL, 0x000fe200078e00ffULL, 0x000054103c3c7816ULL, 0x002fcc000000003dULL,
0x0000005500557306ULL, 0x000e620000202400ULL, 0xfffffff838387812ULL, 0x000fe400078ee237ULL,
0x000054103f547816ULL, 0x004fca0000000054ULL, 0x0000005100517306ULL, 0x000fe20000202400ULL,
0x0000001038377824ULL, 0x000fe200078e0207ULL, 0x0000541056557816ULL, 0x002fcc0000000055ULL,
0x0000005300537306ULL, 0x000fe20000202400ULL, 0x000000543024723cULL, 0x000fee0000041824ULL,
0x0000003e003e7306ULL, 0x000ff00000202400ULL, 0x0000005700577306ULL, 0x000e700000202400ULL,
0x0000003a003a7306ULL, 0x000ea20000202400ULL, 0x000054103e3d7816ULL, 0x002fce0000000057ULL,
0x0000003b005c7306ULL, 0x000e620000202400ULL, 0x0000003c3028723cULL, 0x000fe20000041828ULL,
0x000054103a3a7816ULL, 0x004fe40000000051ULL, 0x000054105c3b7816ULL, 0x002fce0000000053ULL,
0x0000003a302c723cULL, 0x000fe2000004182cULL, 0x012000003730783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000102947ULL, 0x000fde0003800000ULL,
0x0000000d30307232ULL, 0x084fe40000200000ULL, 0x0000000d32327232ULL, 0x000fe40000200000ULL,
0x0000000e31317232ULL, 0x080fe40000200000ULL, 0x0000000e33337232ULL, 0x000fce0000200000ULL,
0x00000000413c783bULL, 0x000ee20000004200ULL, 0x000000104e407824ULL, 0x000fe200078e0252ULL,
0x000000070f007c0cULL, 0x000fc8000bf03070ULL, 0x000000004038783bULL, 0x000f220000004200ULL,
0x00000018ff5c7819ULL, 0x008fe2000001143cULL, 0x000001003c547824ULL, 0x040fe200078e00ffULL,
0x000088803c5e7816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5b7819ULL, 0x000fe2000001143dULL, 0x000001003d557824ULL, 0x000fe200078e00ffULL,
0x00000018ff547819ULL, 0x000fe20000011454ULL, 0x0000005c005c7306ULL, 0x000fe20000202400ULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x000001003b6a7824ULL, 0x010fe200078e00ffULL,
0x000088803d627816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff557819ULL, 0x000fc40000011455ULL, 0x00000018ff5a7819ULL, 0x000fe2000001143eULL,
0x0000005400637306ULL, 0x0007e20000202400ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x000088803e5d7816ULL, 0x040fe400000000ffULL, 0x00000018ff537819ULL, 0x000fe40000011438ULL,
0x00000018ff527819ULL, 0x000fe20000011439ULL, 0x0000003c00677306ULL, 0x0009e20000202400ULL,
0x000001003e547824ULL, 0x008fe200078e00ffULL, 0x0000888038567816ULL, 0x000fe200000000ffULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x000088803f5f7816ULL, 0x000fc400000000ffULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x0000005e005e7306ULL, 0x000ee20000202400ULL,
0x000001003f3c7824ULL, 0x050fe200078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x00000018ff587819ULL, 0x000fe2000001143fULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000006200627306ULL, 0x000fe20000202400ULL,
0x00000018ff4e7819ULL, 0x000fc4000001143aULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x00000018ff517819ULL, 0x000fe4000001143bULL, 0x00000018ff6a7819ULL, 0x000fe2000001146aULL,
0x0000005500697306ULL, 0x000f300000202400ULL, 0x0000003d00647306ULL, 0x000bf00000202400ULL,
0x0000005400607306ULL, 0x0007e20000202400ULL, 0x00000100383d7824ULL, 0x022fc400078e00ffULL,
0x0001000038387824ULL, 0x000fc600078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000003c00667306ULL, 0x0003e20000202400ULL, 0x0000888039547816ULL, 0x00cfe400000000ffULL,
0x00000018ff387819ULL, 0x000fca0000011438ULL, 0x0000003e00617306ULL, 0x000fe20000202400ULL,
0x00000100393c7824ULL, 0x042fe400078e00ffULL, 0x0001000039397824ULL, 0x000fc600078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x00000018ff397819ULL, 0x000fe20000011439ULL,
0x0000005b005b7306ULL, 0x000e700000202400ULL, 0x00000038003e7306ULL, 0x0005f00000202400ULL,
0x0000003900557306ULL, 0x0009e20000202400ULL, 0x000054105e387816ULL, 0x004fce0000000063ULL,
0x0000005d005d7306ULL, 0x000ea20000202400ULL, 0x0000541062397816ULL, 0x010fce0000000069ULL,
0x0000005f005f7306ULL, 0x000ee20000202400ULL, 0x000000383010723cULL, 0x000fee0000041810ULL,
0x000100003a397824ULL, 0x000fe200078e00ffULL, 0x0000541067387816ULL, 0x000fe2000000005cULL,
0x0000005800587306ULL, 0x000fe60000202400ULL, 0x00000018ff5c7819ULL, 0x000fc40000011439ULL,
0x0000541064397816ULL, 0x002fe2000000005bULL, 0x000100003b5b7824ULL, 0x000fe400078e00ffULL,
0x0000003f00657306ULL, 0x0003260000202400ULL, 0x00000018ff5b7819ULL, 0x000fe2000001145bULL,
0x000000383014723cULL, 0x000fe80000041814ULL, 0x0000003d00577306ULL, 0x000be20000202400ULL,
0x000088803a3f7816ULL, 0x002fc400000000ffULL, 0x000054105d387816ULL, 0x004fe40000000060ULL,
0x000054105f397816ULL, 0x008fc60000000066ULL, 0x0000005a005a7306ULL, 0x000e620000202400ULL,
0x000001003a3d7824ULL, 0x020fc600078e00ffULL, 0x000000383018723cULL, 0x000fe40000041818ULL,
0x00000018ff687819ULL, 0x000fe4000001143dULL, 0x000088803b3d7816ULL, 0x000fe200000000ffULL,
0x0000005600567306ULL, 0x000ea40000202400ULL, 0x0000541065397816ULL, 0x010fe40000000058ULL,
0x0000541061387816ULL, 0x002fc8000000005aULL, 0x0000005400547306ULL, 0x000fe60000202400ULL,
0x00000038301c723cULL, 0x000fea000004181cULL, 0x0000003c00597306ULL, 0x000e640000202400ULL,
0x0000541056387816ULL, 0x004fe20000000057ULL, 0x00000001ff567424ULL, 0x000fca00078e00ffULL,
0x0000003d003d7306ULL, 0x000fe20000202400ULL, 0x0000541054397816ULL, 0x002fce0000000059ULL,
0x0000006a003a7306ULL, 0x000e620000202400ULL, 0x000000383020723cULL, 0x000fee0000041820ULL,
0x0000004e004e7306ULL, 0x000fe20000202400ULL, 0x0186b856073879a7ULL, 0x0004a2000850003fULL,
0x000054103d3d7816ULL, 0x002fcc000000003aULL, 0x0000005c003b7306ULL, 0x000e620000202400ULL,
0x0186885607ff79a7ULL, 0x0005ee000850003fULL, 0x0000005300537306ULL, 0x000ee20000202400ULL,
0x000054103b3a7816ULL, 0x002fce000000004eULL, 0x0000005200527306ULL, 0x000e620000202400ULL,
0x000000ffff4e7224ULL, 0x000fe200078e0050ULL, 0x000054103e547816ULL, 0x008fcc0000000053ULL,
0x0000005100517306ULL, 0x000fe20000202400ULL, 0x0000541055557816ULL, 0x002fce0000000052ULL,
0x0000003f003f7306ULL, 0x000fe20000202400ULL, 0x000000543024723cULL, 0x000fee0000041824ULL,
0x00000068003c7306ULL, 0x000e700000202400ULL, 0x0000005b00587306ULL, 0x000ee20000202400ULL,
0x000054103f3c7816ULL, 0x002fce000000003cULL, 0x0000003c3028723cULL, 0x000fe20000041828ULL,
0x00005410583b7816ULL, 0x008fce0000000051ULL, 0x0000003a302c723cULL, 0x000fe2000004182cULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x000000b000e80947ULL, 0x004fde0003800000ULL,
0x0000000000307805ULL, 0x000fe20000015200ULL, 0x0186b839070075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff387224ULL, 0x000fce00078e00ffULL,
0x000000103800780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x000fcc0000015200ULL, 0x00000032303b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000133337824ULL, 0x000fe200000e0e31ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff027819ULL, 0x000fc80000011433ULL,
0x0000003b02027211ULL, 0x000fca00078110ffULL, 0x000000ffff337224ULL, 0x000fca00000e0633ULL,
0x0000000202027819ULL, 0x000fc80000001233ULL, 0x000000020000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000138387836ULL, 0x000fce0000000000ULL,
0x0186b839070075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000400209947ULL, 0x000fea0003800000ULL, 0x0000000104327824ULL, 0x000fe200078e0235ULL,
0x00000020070a7890ULL, 0x000fe2000fffe03fULL, 0x0000000235397836ULL, 0x000fe20000000000ULL,
0x0000006008307811ULL, 0x000fe200078e38ffULL, 0x0000000132027824ULL, 0x040fe200078e0209ULL,
0x00008a00000c7ab9ULL, 0x000fe20000000a00ULL, 0x0000001032317824ULL, 0x000fe400078e00ffULL,
0x0000000104387824ULL, 0x000fe400078e0239ULL, 0x00000004353f7836ULL, 0x000fe20000000000ULL,
0xfffffff0313e7812ULL, 0x000fe200078ee202ULL, 0x0000000138027824ULL, 0x000fc400078e0209ULL,
0x0000001038337824ULL, 0x000fe400078e00ffULL, 0x00000001043a7824ULL, 0x000fe400078e023fULL,
0x0000000132327824ULL, 0x000fe200078e0230ULL, 0xfffffff0334e7812ULL, 0x000fe200078ee202ULL,
0x000000013a317824ULL, 0x040fe200078e0209ULL, 0x0000000a0f027c48ULL, 0x000fe2000ffe0000ULL,
0x000000103a527824ULL, 0x000fe200078e00ffULL, 0x000000324f337210ULL, 0x000fe20007f1e0ffULL,
0x0000000635517836ULL, 0x000fc40000000000ULL, 0x000000013a327824ULL, 0x100fe200078e0230ULL,
0xfffffff052527812ULL, 0x000fe200078ee231ULL, 0x8000000a02317c36ULL, 0x000fe40008000000ULL,
0x00000001043b7824ULL, 0x000fe200078e0251ULL, 0x000000324f327210ULL, 0x000fe20007f5e0ffULL,
0x0000000138027824ULL, 0x100fe200078e0230ULL, 0x0000003104317248ULL, 0x000fe20007fe0000ULL,
0x000000013b307824ULL, 0x040fe400078e0230ULL, 0x000000013b3c7824ULL, 0x000fc400078e0209ULL,
0x000000103b3d7824ULL, 0x000fe200078e00ffULL, 0x000000024f3b7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff387224ULL, 0x000fe200000e06ffULL, 0x0000000c333a7c11ULL, 0x000fe2000f8040ffULL,
0x0000000131027824ULL, 0x000fe200078e0a04ULL, 0x000000304f4f7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff307224ULL, 0x000fe200020e06ffULL, 0x0000000d33317c11ULL, 0x000fe400080f4438ULL,
0xfffffff03d547812ULL, 0x000fe200078ee23cULL, 0x000000ffff3c7224ULL, 0x000fe200018e06ffULL,
0x0000000c3b337c11ULL, 0x000fc4000f8840ffULL, 0x000000023900720cULL, 0x000fe20003f06070ULL,
0x000000ffff397224ULL, 0x000fe200010e06ffULL, 0x000000f0363d7812ULL, 0x000fe400078ec0ffULL,
0x0000000c32387c11ULL, 0x040fe4000f8a40ffULL, 0x0000000d3b3b7c11ULL, 0x000fe4000a0f4430ULL,
0x0000003d3a307210ULL, 0x000fe40007f9e0ffULL, 0x0000000d32397c11ULL, 0x000fc4000a8f4439ULL,
0x0000003d33327210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff317224ULL, 0x000fe200020e0631ULL,
0x000000023500720cULL, 0x080fe40003f86070ULL, 0x0000000c4f3a7c11ULL, 0x000fe2000f8640ffULL,
0x000000ffff337224ULL, 0x000fe200028e063bULL, 0x000000023f00720cULL, 0x080fe20003f46070ULL,
0x00016000073b7836ULL, 0x000fe20000000000ULL, 0x000000025100720cULL, 0x000fe40003fa6070ULL,
0x0000003d38387210ULL, 0x000fe20007fde0ffULL, 0x000000104e3f7824ULL, 0x100fe200078e023bULL,
0x0000000d4f027c11ULL, 0x000fe200098f443cULL, 0x00000010524f7824ULL, 0x100fe200078e023bULL,
0x0000003d3a3a7210ULL, 0x000fe20007f7e0ffULL, 0x000000103e3d7824ULL, 0x000fc400078e023bULL,
0x000000ffff397224ULL, 0x000fe400030e0639ULL, 0x0000001054517824ULL, 0x000fe200078e023bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000303d7faeULL, 0x0003e2000e101c48ULL,
0x000000ffff3b7224ULL, 0x000fc600018e0602ULL, 0x00000000323f7faeULL, 0x0003e8000c101c48ULL,
0x00000000384f7faeULL, 0x0003e8000d101c48ULL, 0x000000003a517faeULL, 0x0003e2000e901c48ULL,
0x0000000000ec7947ULL, 0x000fea0003800000ULL, 0x0000000104027824ULL, 0x000fe200078e0235ULL,
0x00008a00000a7ab9ULL, 0x000fe20000000a00ULL, 0x000000f036517812ULL, 0x000fe400078ec0ffULL,
0x0000000102307824ULL, 0x140fe400078e0209ULL, 0x0000001002317824ULL, 0x000fe400078e00ffULL,
0x0000000202327836ULL, 0x000fe40000000000ULL, 0x0000000602527836ULL, 0x000fe20000000000ULL,
0xfffffff0313a7812ULL, 0x000fe200078ee230ULL, 0x00000004023e7836ULL, 0x000fe20000000000ULL,
0x0000006008317811ULL, 0x000fe200078e38ffULL, 0x0000000132337824ULL, 0x000fc400078e0209ULL,
0x00000010324e7824ULL, 0x000fe400078e00ffULL, 0x0000000102387824ULL, 0x100fe400078e0231ULL,
0x0000000132027824ULL, 0x100fe200078e0231ULL, 0xfffffff04e4e7812ULL, 0x000fe200078ee233ULL,
0x0000000152327824ULL, 0x100fe200078e0231ULL, 0x000000384f387210ULL, 0x000fe20007f9e0ffULL,
0x000000013e307824ULL, 0x040fe200078e0231ULL, 0x000000024f3c7210ULL, 0x000fe20007f5e0ffULL,
0x000000103e3b7824ULL, 0x040fe200078e00ffULL, 0x000000324f027210ULL, 0x000fe20007f1e0ffULL,
0x000000013e327824ULL, 0x100fe200078e0209ULL, 0x000000304f397210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff317224ULL, 0x000fe200020e06ffULL, 0x0000000a38307c11ULL, 0x000fe2000f8840ffULL,
0x0000000152337824ULL, 0x000fe200078e0209ULL, 0xfffffff03b327812ULL, 0x000fe200078ee232ULL,
0x00016000074f7836ULL, 0x000fe20000000000ULL, 0x0000000b383e7c11ULL, 0x000fe2000a0f4431ULL,
0x000000ffff317224ULL, 0x000fe200010e06ffULL, 0x0000000a3c3b7c11ULL, 0x000fe2000f8440ffULL,
0x0000001052527824ULL, 0x000fe200078e00ffULL, 0x0000005130307210ULL, 0x000fe20007f9e0ffULL,
0x00000010323f7824ULL, 0x000fe200078e024fULL, 0x0000000b3c3c7c11ULL, 0x000fe200090f4431ULL,
0x000000ffff327224ULL, 0x000fe200018e06ffULL, 0xfffffff052527812ULL, 0x000fe200078ee233ULL,
0x000000103a537824ULL, 0x100fe200078e024fULL, 0x0000000a39387c11ULL, 0x040fe2000f8440ffULL,
0x000000ffff337224ULL, 0x000fe200000e06ffULL, 0x0000000a023a7c11ULL, 0x000fe2000f8640ffULL,
0x000000ffff317224ULL, 0x000fe200020e063eULL, 0x0000000b39397c11ULL, 0x000fe200090f4432ULL,
0x000000104e3d7824ULL, 0x100fe200078e024fULL, 0x000000513b327210ULL, 0x000fe20007f1e0ffULL,
0x00000010524f7824ULL, 0x000fe200078e024fULL, 0x0000000b02027c11ULL, 0x000fe200098f4433ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030537faeULL, 0x0003e2000b901c48ULL,
0x0000005138387210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff337224ULL, 0x000fe200000e063cULL,
0x000000513a3a7210ULL, 0x000fc60007f7e0ffULL, 0x000000ffff397224ULL, 0x000fe200010e0639ULL,
0x00000000323d7faeULL, 0x0003e2000b901c48ULL, 0x000000ffff3b7224ULL, 0x000fc600018e0602ULL,
0x00000000383f7faeULL, 0x0003e8000b901c48ULL, 0x000000003a4f7faeULL, 0x0003e4000b901c48ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x000000014d317836ULL, 0x000fe40000000000ULL,
0x00000001ff387424ULL, 0x000fe400078e00ffULL, 0xffffffffff027424ULL, 0x000fe200078e00ffULL,
0x000000063100720cULL, 0x000fda0003f06070ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x00008c00ff307b82ULL, 0x000e620000000a00ULL, 0x000000010a337810ULL, 0x000fca0007ffe04dULL,
0x0000000433307825ULL, 0x002fca00078e0030ULL, 0x0000000830027981ULL, 0x000324000c1e1900ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a46ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0186b038075279a7ULL, 0x0004e4000850003fULL, 0x01862838033879a7ULL, 0x004464000850003fULL,
0x0000000000307805ULL, 0x002fce0000015200ULL, 0x01862839030075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff3a7224ULL, 0x000fce00078e00ffULL,
0x000000103a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x000fce0000015200ULL, 0x00000032303b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000133337824ULL, 0x000fe200000e0e31ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff327819ULL, 0x000fc80000011433ULL,
0x0000003b32327211ULL, 0x000fca00078110ffULL, 0x000000ffff337224ULL, 0x000fca00000e0633ULL,
0x0000000232327819ULL, 0x000fc80000001233ULL, 0x000000320000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013a3a7836ULL, 0x000fce0000000000ULL,
0x01862839030075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x018080004b317984ULL, 0x000e620000000800ULL, 0x00000001ff387424ULL, 0x000fe400078e00ffULL,
0x000000ffff4e7224ULL, 0x000fe200078e0050ULL, 0x018280004b337984ULL, 0x000b620000000800ULL,
0x000000503100720bULL, 0x002fda0003f1d000ULL, 0x0000000000397806ULL, 0x000fc800000e0100ULL,
0x0000ffff39ff7812ULL, 0x000fda000780c0ffULL, 0x0000000000f48947ULL, 0x02cfea0003800000ULL,
0x000000013400780cULL, 0x000fe40003f45270ULL, 0x000000503100720bULL, 0x000fd60003f14000ULL,
0x000000503130a209ULL, 0x000fe40007810000ULL, 0x0000000000387806ULL, 0x000fc600000e0100ULL,
0x018480304b00a388ULL, 0x0003e20000000800ULL, 0x0000991038327816ULL, 0x000fc800000000ffULL,
0x000000ff3200720cULL, 0x000fda0003f05270ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x00000050313b7209ULL, 0x000fe40007810000ULL, 0x000000ff38ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0038ff7812ULL, 0x000fe2000784c0ffULL, 0x000000503b307221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b30307820ULL, 0x000fc80000410000ULL, 0x00000030003b7308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff307819ULL, 0x002fcc0000011609ULL,
0x00001f303b307589ULL, 0x004e6400000e0000ULL, 0x0000003010107220ULL, 0x082fe20000410000ULL,
0x0000003011117220ULL, 0x080fe20000410000ULL, 0x0000003014147220ULL, 0x080fe20000410000ULL,
0x0000003015157220ULL, 0x080fe20000410000ULL, 0x0000003018187220ULL, 0x080fe20000410000ULL,
0x0000003019197220ULL, 0x080fe20000410000ULL, 0x000000301c1c7220ULL, 0x080fe20000410000ULL,
0x000000301d1d7220ULL, 0x080fe20000410000ULL, 0x0000003020207220ULL, 0x080fe20000410000ULL,
0x0000003021217220ULL, 0x080fe20000410000ULL, 0x0000003024247220ULL, 0x080fe20000410000ULL,
0x0000003025257220ULL, 0x080fe20000410000ULL, 0x0000003028287220ULL, 0x080fe20000410000ULL,
0x0000003029297220ULL, 0x080fe20000410000ULL, 0x000000302c2c7220ULL, 0x080fe20000410000ULL,
0x000000302d2d7220ULL, 0x000fce0000410000ULL, 0x0000003b00007220ULL, 0x004fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x0000000809307811ULL, 0x002fcc00078ff0ffULL,
0x00001f303b307589ULL, 0x000e6400000e0000ULL, 0x0000003012127220ULL, 0x082fe20000410000ULL,
0x0000003013137220ULL, 0x080fe20000410000ULL, 0x0000003016167220ULL, 0x080fe20000410000ULL,
0x0000003017177220ULL, 0x080fe20000410000ULL, 0x000000301a1a7220ULL, 0x080fe20000410000ULL,
0x000000301b1b7220ULL, 0x080fe20000410000ULL, 0x000000301e1e7220ULL, 0x080fe20000410000ULL,
0x000000301f1f7220ULL, 0x080fe20000410000ULL, 0x0000003022227220ULL, 0x080fe20000410000ULL,
0x0000003023237220ULL, 0x080fe20000410000ULL, 0x0000003026267220ULL, 0x080fe20000410000ULL,
0x0000003027277220ULL, 0x080fe20000410000ULL, 0x000000302a2a7220ULL, 0x080fe20000410000ULL,
0x000000302b2b7220ULL, 0x080fe20000410000ULL, 0x000000302e2e7220ULL, 0x080fe20000410000ULL,
0x000000302f2f7220ULL, 0x000fce0000410000ULL, 0x0000ffff38ff7812ULL, 0x000fe20007800839ULL,
0x00000001ff387424ULL, 0x000fe200078e00ffULL, 0x00000050314e7209ULL, 0x000fd60007810000ULL,
0x8000004e31310221ULL, 0x000fe20000010000ULL, 0x00007610ff380816ULL, 0x000fc60000000038ULL,
0x3fb8aa3b31310820ULL, 0x000fc80000410000ULL, 0x00000031000c0308ULL, 0x000ea40000000800ULL,
0x0000000c33330220ULL, 0x004fce0000410000ULL, 0x0000000033007221ULL, 0x000fce0000010000ULL,
0x0000000000307805ULL, 0x002fce0000015200ULL, 0x0186a84c070075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff3a7224ULL, 0x000fce00078e00ffULL,
0x000000103a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x000fce0000015200ULL, 0x0000003230397210ULL, 0x000fca0007f1e1ffULL,
0x0000000133337824ULL, 0x000fe200000e0e31ULL, 0x003d09003900780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403900780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff327819ULL, 0x000fc80000011433ULL,
0x0000003932327211ULL, 0x000fca00078110ffULL, 0x000000ffff337224ULL, 0x000fca00000e0633ULL,
0x0000000232327819ULL, 0x000fc80000001233ULL, 0x000000320000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013a3a7836ULL, 0x000fce0000000000ULL,
0x0186a84c070075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000991038307816ULL, 0x000fc800000000ffULL, 0x000000ff3000720cULL, 0x000fda0003f45270ULL,
0x0000000000182947ULL, 0x000fea0003800000ULL, 0x00000002ff317819ULL, 0x000fe40000011609ULL,
0x0000000cff0d723eULL, 0x000fc600000010ffULL, 0x0000000831337836ULL, 0x000fe20000000000ULL,
0x000054100d307816ULL, 0x000fca000000000dULL, 0x00001f31300d7589ULL, 0x0002a800000e0000ULL,
0x00001f33300e7589ULL, 0x0002e400000e0000ULL, 0x012800004a30783bULL, 0x0022e20000000200ULL,
0x0000000000102947ULL, 0x000fea0003800000ULL, 0x0000000d30307232ULL, 0x08cfe40000200000ULL,
0x0000000d32327232ULL, 0x000fe40000200000ULL, 0x0000000e31317232ULL, 0x080fe40000200000ULL,
0x0000000e33337232ULL, 0x000fce0000200000ULL, 0x00000000493c783bULL, 0x000f680000004200ULL,
0x000000004838783bULL, 0x000f640000004200ULL, 0x00000018ff5d7819ULL, 0x022fe2000001143cULL,
0x000001003c547824ULL, 0x040fe200078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe2000001143dULL,
0x000001003d557824ULL, 0x040fe200078e00ffULL, 0x000088803c5f7816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x000088803d637816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff507819ULL, 0x008fe20000011438ULL,
0x0000005d005d7306ULL, 0x000fe20000202400ULL, 0x00000018ff3c7819ULL, 0x000fc4000001143cULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000888038577816ULL, 0x000fe400000000ffULL,
0x00000018ff547819ULL, 0x000fe20000011454ULL, 0x0000003c00627306ULL, 0x0003e20000202400ULL,
0x00000018ff557819ULL, 0x000fe40000011455ULL, 0x00000018ff5a7819ULL, 0x000fe4000001143fULL,
0x000088803f607816ULL, 0x000fc400000000ffULL, 0x00000018ff517819ULL, 0x000fe20000011439ULL,
0x0000003d00657306ULL, 0x0007e20000202400ULL, 0x000001003f3c7824ULL, 0x002fe200078e00ffULL,
0x0000888039567816ULL, 0x000fe200000000ffULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x000088803e5e7816ULL, 0x000fe400000000ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000005f005f7306ULL, 0x000fe20000202400ULL, 0x00000100383d7824ULL, 0x048fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x0001000038387824ULL, 0x000fe200078e00ffULL,
0x00000018ff5b7819ULL, 0x000fc4000001143eULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000005400667306ULL, 0x0003e20000202400ULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x00000018ff4c7819ULL, 0x000fe4000001143aULL, 0x00000018ff4f7819ULL, 0x000fc6000001143bULL,
0x0000006300637306ULL, 0x000fe20000202400ULL, 0x000001003e547824ULL, 0x042fe400078e00ffULL,
0x000100003e3e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x0000005500687306ULL, 0x000e620000202400ULL, 0x00000018ff3e7819ULL, 0x000fce000001143eULL,
0x0000003c00697306ULL, 0x0007f00000202400ULL, 0x0000003800557306ULL, 0x000be20000202400ULL,
0x00000100393c7824ULL, 0x048fe400078e00ffULL, 0x0001000039397824ULL, 0x000fc600078e00ffULL,
0x00000018ff597819ULL, 0x000fe4000001143cULL, 0x0000005c005c7306ULL, 0x000ee20000202400ULL,
0x000001003b387824ULL, 0x024fe200078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x000088803a3c7816ULL, 0x000fe400000000ffULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x0000005400617306ULL, 0x000ff00000202400ULL, 0x0000003f00677306ULL, 0x000ff00000202400ULL,
0x0000003900547306ULL, 0x0003f00000202400ULL, 0x00000038003f7306ULL, 0x0005e20000202400ULL,
0x0000541063397816ULL, 0x002fce0000000068ULL, 0x0000005e005e7306ULL, 0x000e620000202400ULL,
0x000054105f387816ULL, 0x004fe20000000066ULL, 0x000100003b5f7824ULL, 0x000fca00078e00ffULL,
0x00000018ff5f7819ULL, 0x000fe2000001145fULL, 0x0000006000607306ULL, 0x000ea20000202400ULL,
0x000000383010723cULL, 0x000fee0000041810ULL, 0x0000541062387816ULL, 0x000fe2000000005dULL,
0x0000005b005b7306ULL, 0x000fe20000202400ULL, 0x0000541065397816ULL, 0x008fce000000005cULL,
0x0000005a005a7306ULL, 0x000fe20000202400ULL, 0x000000383014723cULL, 0x000fee0000041814ULL,
0x0000003e00647306ULL, 0x0007620000202400ULL, 0x000054105e387816ULL, 0x002fe40000000061ULL,
0x0000541060397816ULL, 0x004fca0000000069ULL, 0x0000003d00587306ULL, 0x0003e20000202400ULL,
0x000088803b3e7816ULL, 0x008fe200000000ffULL, 0x000000383018723cULL, 0x000fec0000041818ULL,
0x0000005700577306ULL, 0x000ea20000202400ULL, 0x000001003a3d7824ULL, 0x002fe200078e00ffULL,
0x0000541064387816ULL, 0x020fe2000000005bULL, 0x000100003a3a7824ULL, 0x000fe200078e00ffULL,
0x0000541067397816ULL, 0x000fc4000000005aULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000005600567306ULL, 0x000fe20000202400ULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x00000038301c723cULL, 0x000fea000004181cULL, 0x0000005900597306ULL, 0x000e640000202400ULL,
0x0000541057387816ULL, 0x004fcc0000000058ULL, 0x0000003c003c7306ULL, 0x000fe20000202400ULL,
0x0000541056397816ULL, 0x002fce0000000059ULL, 0x0000003d003d7306ULL, 0x000e620000202400ULL,
0x000000383020723cULL, 0x000fee0000041820ULL, 0x0000005000507306ULL, 0x000ea20000202400ULL,
0x000054103c3c7816ULL, 0x002fce000000003dULL, 0x0000005100517306ULL, 0x000e620000202400ULL,
0x0000541055507816ULL, 0x004fce0000000050ULL, 0x0000004c004c7306ULL, 0x000fe20000202400ULL,
0x0000541054517816ULL, 0x002fce0000000051ULL, 0x0000004f004f7306ULL, 0x000fe20000202400ULL,
0x000000503024723cULL, 0x000fee0000041824ULL, 0x0000003e003e7306ULL, 0x000e700000202400ULL,
0x0000003a003b7306ULL, 0x000ea20000202400ULL, 0x000054103e3d7816ULL, 0x002fce000000003fULL,
0x0000005f005c7306ULL, 0x000e620000202400ULL, 0x0000003c3028723cULL, 0x000fe20000041828ULL,
0x000054103b387816ULL, 0x004fe4000000004cULL, 0x000054105c397816ULL, 0x002fce000000004fULL,
0x00000038302c723cULL, 0x000fe2000004182cULL, 0x012800004630783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000102947ULL, 0x000fde0003800000ULL,
0x0000000d30307232ULL, 0x084fe40000200000ULL, 0x0000000d32327232ULL, 0x000fe40000200000ULL,
0x0000000e31317232ULL, 0x080fe40000200000ULL, 0x0000000e33337232ULL, 0x000fce0000200000ULL,
0x00000000453c783bULL, 0x000ee80000004200ULL, 0x000000004438783bULL, 0x000f620000004200ULL,
0x00000018ff5d7819ULL, 0x008fe2000001143cULL, 0x000001003c547824ULL, 0x040fe200078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe2000001143dULL, 0x000001003d557824ULL, 0x040fe200078e00ffULL,
0x000088803c5f7816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x000088803d637816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff507819ULL, 0x022fe20000011438ULL, 0x0000005d005d7306ULL, 0x000fe20000202400ULL,
0x00000018ff3c7819ULL, 0x000fc4000001143cULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000888038577816ULL, 0x000fe400000000ffULL, 0x00000018ff547819ULL, 0x000fe20000011454ULL,
0x0000003c00627306ULL, 0x0003e20000202400ULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x00000018ff5a7819ULL, 0x000fe4000001143fULL, 0x000088803f607816ULL, 0x000fc400000000ffULL,
0x00000018ff517819ULL, 0x000fe20000011439ULL, 0x0000003d00657306ULL, 0x0007e20000202400ULL,
0x000001003f3c7824ULL, 0x002fe200078e00ffULL, 0x0000888039567816ULL, 0x000fe200000000ffULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x000088803e5e7816ULL, 0x000fe400000000ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000005f005f7306ULL, 0x000fe20000202400ULL,
0x00000100383d7824ULL, 0x048fe200078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x0001000038387824ULL, 0x000fe200078e00ffULL, 0x00000018ff5b7819ULL, 0x000fc4000001143eULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000005400667306ULL, 0x0003e20000202400ULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x00000018ff4c7819ULL, 0x000fe4000001143aULL,
0x00000018ff4f7819ULL, 0x000fc6000001143bULL, 0x0000006300637306ULL, 0x000fe20000202400ULL,
0x000001003e547824ULL, 0x042fe400078e00ffULL, 0x000100003e3e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x0000005500687306ULL, 0x000e620000202400ULL,
0x00000018ff3e7819ULL, 0x000fce000001143eULL, 0x0000003c00697306ULL, 0x0007f00000202400ULL,
0x0000003800557306ULL, 0x000be20000202400ULL, 0x00000100393c7824ULL, 0x048fe400078e00ffULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff597819ULL, 0x000fe4000001143cULL,
0x0000005c005c7306ULL, 0x000ee20000202400ULL, 0x000001003b387824ULL, 0x024fe200078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x000088803a3c7816ULL, 0x000fe400000000ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000005400617306ULL, 0x000ff00000202400ULL,
0x0000003f00677306ULL, 0x000ff00000202400ULL, 0x0000003900547306ULL, 0x0003f00000202400ULL,
0x00000038003f7306ULL, 0x0005e20000202400ULL, 0x0000541063397816ULL, 0x002fce0000000068ULL,
0x0000005e005e7306ULL, 0x000e620000202400ULL, 0x000054105f387816ULL, 0x004fe20000000066ULL,
0x000100003b5f7824ULL, 0x000fca00078e00ffULL, 0x00000018ff5f7819ULL, 0x000fe2000001145fULL,
0x0000006000607306ULL, 0x000ea20000202400ULL, 0x000000383010723cULL, 0x000fee0000041810ULL,
0x0000541062387816ULL, 0x000fe2000000005dULL, 0x0000005b005b7306ULL, 0x000fe20000202400ULL,
0x0000541065397816ULL, 0x008fce000000005cULL, 0x0000005a005a7306ULL, 0x000fe20000202400ULL,
0x000000383014723cULL, 0x000fee0000041814ULL, 0x0000003e00647306ULL, 0x0007620000202400ULL,
0x000054105e387816ULL, 0x002fe40000000061ULL, 0x0000541060397816ULL, 0x004fca0000000069ULL,
0x0000003d00587306ULL, 0x0003e20000202400ULL, 0x000088803b3e7816ULL, 0x008fe200000000ffULL,
0x000000383018723cULL, 0x000fec0000041818ULL, 0x0000005700577306ULL, 0x000ea20000202400ULL,
0x000001003a3d7824ULL, 0x002fe200078e00ffULL, 0x0000541064387816ULL, 0x020fe2000000005bULL,
0x000100003a3a7824ULL, 0x000fe200078e00ffULL, 0x0000541067397816ULL, 0x000fc4000000005aULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000005600567306ULL, 0x000fe20000202400ULL,
0x00000018ff3a7819ULL, 0x000fe4000001143aULL, 0x00000038301c723cULL, 0x000fea000004181cULL,
0x0000005900597306ULL, 0x000e640000202400ULL, 0x0000541057387816ULL, 0x004fcc0000000058ULL,
0x0000004c004c7306ULL, 0x000fe20000202400ULL, 0x0000541056397816ULL, 0x002fce0000000059ULL,
0x0000004f004f7306ULL, 0x000fe20000202400ULL, 0x000000383020723cULL, 0x000fee0000041820ULL,
0x0000003a003b7306ULL, 0x0002b00000202400ULL, 0x0000005f005c7306ULL, 0x000ee20000202400ULL,
0x00000001ff3a7424ULL, 0x002fe200078e00ffULL, 0x000054103b387816ULL, 0x004fcc000000004cULL,
0x0000003c003c7306ULL, 0x000fe20000202400ULL, 0x000054105c397816ULL, 0x008fce000000004fULL,
0x0000003d003d7306ULL, 0x000e620000202400ULL, 0x00000038302c723cULL, 0x000fee000004182cULL,
0x0000005000507306ULL, 0x000ea20000202400ULL, 0x0186b83a073879a7ULL, 0x0006e2000850003fULL,
0x000054103c3c7816ULL, 0x002fcc000000003dULL, 0x0000005100517306ULL, 0x000e620000202400ULL,
0x0000541055507816ULL, 0x004fce0000000050ULL, 0x0000003e003e7306ULL, 0x000ea20000202400ULL,
0x0000541054517816ULL, 0x002fce0000000051ULL, 0x000000503024723cULL, 0x000fe20000041824ULL,
0x000054103e3d7816ULL, 0x004fce000000003fULL, 0x0000003c3028723cULL, 0x008fde0000041828ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x0000000000307805ULL, 0x000fce0000015200ULL,
0x0186b839070075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff3a7224ULL, 0x000fce00078e00ffULL, 0x000000103a00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fce0000015200ULL,
0x00000032303b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000003b32327211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013a3a7836ULL, 0x000fce0000000000ULL, 0x0186b839070075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00008400000a7ab9ULL, 0x000fe40000000800ULL,
0x0000000a024f7c24ULL, 0x010fc8000f8e02ffULL, 0x000000804f4f7824ULL, 0x000fe200078e00ffULL,
0x00000004001c9947ULL, 0x000fec0003800000ULL, 0x0000000235557836ULL, 0x000fe20000000000ULL,
0x00000040070a7890ULL, 0x000fe2000fffe03fULL, 0x0000000435597836ULL, 0x000fe20000000000ULL,
0x00008a00000c7ab9ULL, 0x000fe20000000a00ULL, 0x0000000104327824ULL, 0x000fe200078e0255ULL,
0x000000f0363f7812ULL, 0x000fe200078ec0ffULL, 0x0000000104387824ULL, 0x000fe400078e0259ULL,
0x0000000132337824ULL, 0x040fe400078e0209ULL, 0x00000010323c7824ULL, 0x000fc400078e00ffULL,
0x0000000104307824ULL, 0x000fe400078e0235ULL, 0x0000000138327824ULL, 0x140fe200078e0209ULL,
0xfffffff03c577812ULL, 0x000fe200078ee233ULL, 0x00000010385b7824ULL, 0x000fe400078e00ffULL,
0x00000080083c7824ULL, 0x000fe400078e0230ULL, 0x0000000130317824ULL, 0x040fe200078e0209ULL,
0xfffffff05b5b7812ULL, 0x000fe200078ee232ULL, 0x00000010303a7824ULL, 0x000fe200078e00ffULL,
0x0000000a0f307c48ULL, 0x000fe2000ffe0000ULL, 0x000000023c327836ULL, 0x000fe20000000000ULL,
0x0000004f3c397210ULL, 0x000fe20007f1e0ffULL, 0x00014000073e7836ULL, 0x000fe20000000000ULL,
0xfffffff03a517812ULL, 0x000fe200078ee231ULL, 0x8000000a30317c36ULL, 0x000fe20008000000ULL,
0x0000004f32307210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff387224ULL, 0x000fe200000e06ffULL,
0x0000000c39327c11ULL, 0x040fe2000f8040ffULL, 0x000000043c3a7836ULL, 0x000fe20000000000ULL,
0x0000003104317248ULL, 0x000fe20007fe0000ULL, 0x000000ffff337224ULL, 0x000fe200018e06ffULL,
0x0000000d39397c11ULL, 0x000fe200080f4438ULL, 0x0000001051517824ULL, 0x000fe200078e023eULL,
0x0000004f3a3d7210ULL, 0x000fe20007f1e0ffULL, 0x00000001313a7824ULL, 0x000fe200078e0a04ULL,
0x0000000c303b7c11ULL, 0x000fe2000f8640ffULL, 0x0000001057577824ULL, 0x100fe200078e023eULL,
0x0000000c3d387c11ULL, 0x000fe2000f8a40ffULL, 0x000000105b5b7824ULL, 0x000fe200078e023eULL,
0x0000003a3500720cULL, 0x000fc40003f86070ULL, 0x0000000d30317c11ULL, 0x000fe200098f4433ULL,
0x000000ffff307224ULL, 0x000fe200000e06ffULL, 0x0000003f32327210ULL, 0x000fe40007f7e0ffULL,
0x0000003a5500720cULL, 0x080fe20003f06070ULL, 0x0000000635557836ULL, 0x000fe20000000000ULL,
0x0000000d3d3d7c11ULL, 0x000fe2000a8f4430ULL, 0x000000ffff337224ULL, 0x000fe200018e0639ULL,
0x0000003a5900720cULL, 0x000fe20003f66070ULL, 0x000000063c307836ULL, 0x000fe20000000000ULL,
0x0000003f38387210ULL, 0x000fe20007fde0ffULL, 0x00000001043c7824ULL, 0x000fe200078e0255ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000032517faeULL, 0x0003e4000e101c48ULL,
0x0000004f30397210ULL, 0x000fe20007f9e0ffULL, 0x000000013c4c7824ULL, 0x040fe200078e0209ULL,
0x0000003f3b307210ULL, 0x000fe20007fbe0ffULL, 0x000000103c597824ULL, 0x000fc400078e00ffULL,
0x000000ffff3c7224ULL, 0x000fe200020e06ffULL, 0x0000000c393b7c11ULL, 0x000fe2000f8840ffULL,
0x000000ffff317224ULL, 0x000fe200028e0631ULL, 0x0000003a5500720cULL, 0x000fe40003fa6070ULL,
0x0000000d39337c11ULL, 0x002fe2000a0f443cULL, 0x000000ffff397224ULL, 0x000fe200030e063dULL,
0xfffffff059597812ULL, 0x000fe200078ee24cULL, 0x0000000030577faeULL, 0x0003e2000c101c48ULL,
0x0000003f3b327210ULL, 0x000fc60007f9e0ffULL, 0x0000001059597824ULL, 0x000fe200078e023eULL,
0x00000000385b7faeULL, 0x0003e2000d901c48ULL, 0x000000ffff337224ULL, 0x000fca00020e0633ULL,
0x0000000032597faeULL, 0x0003e2000e901c48ULL, 0x0000000000e87947ULL, 0x000fea0003800000ULL,
0x0000000104307824ULL, 0x000fe200078e0235ULL, 0x00008a00000a7ab9ULL, 0x000fc60000000a00ULL,
0x0000000130317824ULL, 0x140fe400078e0209ULL, 0x00000010303a7824ULL, 0x000fe400078e00ffULL,
0x0000000230327836ULL, 0x000fe40000000000ULL, 0x0000000430387836ULL, 0x000fe20000000000ULL,
0xfffffff03a397812ULL, 0x000fe200078ee231ULL, 0x0000000132317824ULL, 0x040fe400078e0209ULL,
0x00000010323a7824ULL, 0x000fc400078e00ffULL, 0x0000008008327824ULL, 0x000fe400078e0230ULL,
0x0000000630307836ULL, 0x000fe20000000000ULL, 0xfffffff03a3b7812ULL, 0x000fe200078ee231ULL,
0x0000000138337824ULL, 0x140fe200078e0209ULL, 0x0000004f32317210ULL, 0x000fe20007f1e0ffULL,
0x0000001038387824ULL, 0x000fe400078e00ffULL, 0x00000001303a7824ULL, 0x040fe400078e0209ULL,
0x0000001030577824ULL, 0x000fe200078e00ffULL, 0xfffffff038517812ULL, 0x000fe200078ee233ULL,
0x000000ffff387224ULL, 0x000fe200000e06ffULL, 0x0000000a31337c11ULL, 0x040fe2000f8040ffULL,
0x0001400007307836ULL, 0x000fe20000000000ULL, 0xfffffff057577812ULL, 0x000fe200078ee23aULL,
0x00000002323a7836ULL, 0x000fe20000000000ULL, 0x0000000b31387c11ULL, 0x000fe200080f4438ULL,
0x00000004323c7836ULL, 0x000fc40000000000ULL, 0x00000010393d7824ULL, 0x100fe200078e0230ULL,
0x0000004f3a3a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000632327836ULL, 0x000fe20000000000ULL,
0x0000004f3c3c7210ULL, 0x000fe20007f7e0ffULL, 0x000000103b3f7824ULL, 0x100fe400078e0230ULL,
0x000000ffff317224ULL, 0x000fe200000e06ffULL, 0x0000000a3a397c11ULL, 0x040fe2000f8040ffULL,
0x0000001051557824ULL, 0x100fe200078e0230ULL, 0x0000004f323e7210ULL, 0x000fe20007f9e0ffULL,
0x0000001057597824ULL, 0x000fe200078e0230ULL, 0x0000000b3a3b7c11ULL, 0x000fe200080f4431ULL,
0x000000ffff317224ULL, 0x000fe200018e06ffULL, 0x000000f0363a7812ULL, 0x000fc400078ec0ffULL,
0x0000000a3c517c11ULL, 0x000fe4000f8640ffULL, 0x0000003a33307210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff337224ULL, 0x000fe200020e06ffULL, 0x0000000a3e577c11ULL, 0x000fe4000f8840ffULL,
0x0000000b3c3c7c11ULL, 0x000fe200098f4431ULL, 0x000000ffff317224ULL, 0x000fe200000e0638ULL,
0x0000003a39327210ULL, 0x000fe40007f1e0ffULL, 0x0000000b3e3e7c11ULL, 0x000fc4000a0f4433ULL,
0x0000003a51387210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff337224ULL, 0x000fe200000e063bULL,
0x0000003a573a7210ULL, 0x000fe20007f9e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000303d7faeULL, 0x0003e4000b901c48ULL, 0x000000ffff397224ULL, 0x000fe400018e063cULL,
0x000000ffff3b7224ULL, 0x000fe200020e063eULL, 0x00000000323f7faeULL, 0x0003e8000b901c48ULL,
0x0000000038557faeULL, 0x0003e8000b901c48ULL, 0x000000003a597faeULL, 0x0003e4000b901c48ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x00000001ff307424ULL, 0x000fe200078e00ffULL,
0x00000000ff0079b0ULL, 0x000fe20008000a45ULL, 0x0000000000007918ULL, 0x000fc80000000000ULL,
0x0186a830073079a7ULL, 0x000e64000850003fULL, 0x000000ffff4c7224ULL, 0x002fe200078e0031ULL,
0x0000000000307805ULL, 0x000fe20000015200ULL, 0x0186b053070075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff387224ULL, 0x000fce00078e00ffULL,
0x000000103800780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x000fcc0000015200ULL, 0x0000003230397210ULL, 0x000fca0007f1e1ffULL,
0x0000000133337824ULL, 0x000fe200000e0e31ULL, 0x003d09003900780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403900780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff327819ULL, 0x000fc80000011433ULL,
0x0000003932327211ULL, 0x000fca00078110ffULL, 0x000000ffff337224ULL, 0x000fca00000e0633ULL,
0x0000000232327819ULL, 0x000fc80000001233ULL, 0x000000320000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000138387836ULL, 0x000fce0000000000ULL,
0x0186b053070075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000000182947ULL, 0x000fea0003800000ULL, 0x00000002ff317819ULL, 0x000fe40000011609ULL,
0x0000000cff0d723eULL, 0x000fc600000010ffULL, 0x0000000831337836ULL, 0x000fe20000000000ULL,
0x000054100d307816ULL, 0x000fca000000000dULL, 0x00001f31300d7589ULL, 0x0002a800000e0000ULL,
0x00001f33300e7589ULL, 0x0002e400000e0000ULL, 0x012800004730783bULL, 0x0022e20000000200ULL,
0x0000000000102947ULL, 0x000fea0003800000ULL, 0x0000000d30307232ULL, 0x08cfe40000200000ULL,
0x0000000d32327232ULL, 0x000fe40000200000ULL, 0x0000000e31317232ULL, 0x080fe40000200000ULL,
0x0000000e33337232ULL, 0x000fce0000200000ULL, 0x00000000433c783bULL, 0x000f280000004200ULL,
0x000000004238783bULL, 0x000f620000004200ULL, 0x00000018ff5d7819ULL, 0x010fe2000001143cULL,
0x000001003c547824ULL, 0x040fe200078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe2000001143dULL,
0x000001003d557824ULL, 0x040fe200078e00ffULL, 0x000088803c5f7816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x000088803d637816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fe20000011454ULL,
0x0000005d005d7306ULL, 0x000fe20000202400ULL, 0x00000018ff3c7819ULL, 0x000fc4000001143cULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff537819ULL, 0x022fe40000011438ULL,
0x0000888038577816ULL, 0x000fe200000000ffULL, 0x0000005400667306ULL, 0x0003e20000202400ULL,
0x00000018ff557819ULL, 0x000fe40000011455ULL, 0x00000018ff5a7819ULL, 0x000fe4000001143fULL,
0x000088803f607816ULL, 0x000fc400000000ffULL, 0x00000018ff527819ULL, 0x000fe20000011439ULL,
0x0000003c00627306ULL, 0x0009e20000202400ULL, 0x000001003e547824ULL, 0x042fe200078e00ffULL,
0x0000888039567816ULL, 0x000fe400000000ffULL, 0x000088803e5e7816ULL, 0x040fe400000000ffULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x0000003d00657306ULL, 0x0003e20000202400ULL,
0x000001003f3c7824ULL, 0x050fe200078e00ffULL, 0x00000018ff5b7819ULL, 0x000fe2000001143eULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff507819ULL, 0x000fe2000001143aULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fc4000001143cULL,
0x0000005f005f7306ULL, 0x000fe20000202400ULL, 0x00000100383d7824ULL, 0x042fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x0001000038387824ULL, 0x000fe200078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000006300637306ULL, 0x000fe20000202400ULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x00000018ff517819ULL, 0x000fca000001143bULL, 0x0000005500687306ULL, 0x000e700000202400ULL,
0x0000005400617306ULL, 0x000ff00000202400ULL, 0x0000003c00697306ULL, 0x0009f00000202400ULL,
0x0000003800547306ULL, 0x000be20000202400ULL, 0x00000100393c7824ULL, 0x010fc400078e00ffULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff597819ULL, 0x000fe4000001143cULL,
0x0000005c005c7306ULL, 0x000f220000202400ULL, 0x000001003b387824ULL, 0x028fe200078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x000088803a3c7816ULL, 0x000fe400000000ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000003f00677306ULL, 0x000ff00000202400ULL,
0x0000003900557306ULL, 0x0003f00000202400ULL, 0x00000038003f7306ULL, 0x0007e20000202400ULL,
0x0000541063397816ULL, 0x002fce0000000068ULL, 0x0000005e005e7306ULL, 0x000e620000202400ULL,
0x000054105f387816ULL, 0x008fe20000000066ULL, 0x000100003b5f7824ULL, 0x000fca00078e00ffULL,
0x00000018ff5f7819ULL, 0x000fe2000001145fULL, 0x0000006000607306ULL, 0x000ee20000202400ULL,
0x000000383010723cULL, 0x000fee0000041810ULL, 0x0000541062387816ULL, 0x000fe2000000005dULL,
0x0000005b005b7306ULL, 0x000fe20000202400ULL, 0x0000541065397816ULL, 0x010fce000000005cULL,
0x0000005a005a7306ULL, 0x000fe20000202400ULL, 0x000000383014723cULL, 0x000fee0000041814ULL,
0x0000003e00647306ULL, 0x0009620000202400ULL, 0x000054105e387816ULL, 0x002fe40000000061ULL,
0x0000541060397816ULL, 0x008fca0000000069ULL, 0x0000003d00587306ULL, 0x0003e20000202400ULL,
0x000088803b3e7816ULL, 0x010fe200000000ffULL, 0x000000383018723cULL, 0x000fec0000041818ULL,
0x0000005700577306ULL, 0x000ee20000202400ULL, 0x000001003a3d7824ULL, 0x002fe200078e00ffULL,
0x0000541064387816ULL, 0x024fe2000000005bULL, 0x000100003a3a7824ULL, 0x000fe200078e00ffULL,
0x0000541067397816ULL, 0x000fc4000000005aULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000005600567306ULL, 0x000fe20000202400ULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x00000038301c723cULL, 0x000fea000004181cULL, 0x0000005900597306ULL, 0x000e640000202400ULL,
0x0000541057387816ULL, 0x008fcc0000000058ULL, 0x0000003c003c7306ULL, 0x000fe20000202400ULL,
0x0000541056397816ULL, 0x002fce0000000059ULL, 0x0000003d003d7306ULL, 0x000e620000202400ULL,
0x000000383020723cULL, 0x000fee0000041820ULL, 0x0000005300537306ULL, 0x000ea20000202400ULL,
0x000054103c3c7816ULL, 0x002fce000000003dULL, 0x0000005200527306ULL, 0x000e620000202400ULL,
0x0000541054387816ULL, 0x004fce0000000053ULL, 0x0000005000507306ULL, 0x000fe20000202400ULL,
0x0000541055397816ULL, 0x002fce0000000052ULL, 0x0000005100517306ULL, 0x000fe20000202400ULL,
0x000000383024723cULL, 0x000fee0000041824ULL, 0x0000003e003e7306ULL, 0x000e700000202400ULL,
0x0000003a003b7306ULL, 0x000ea20000202400ULL, 0x000054103e3d7816ULL, 0x002fce000000003fULL,
0x0000005f005c7306ULL, 0x000e620000202400ULL, 0x0000003c3028723cULL, 0x000fe20000041828ULL,
0x000054103b507816ULL, 0x004fe40000000050ULL, 0x000054105c517816ULL, 0x002fce0000000051ULL,
0x00000050302c723cULL, 0x000fe2000004182cULL, 0x012800003730783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000102947ULL, 0x000fde0003800000ULL,
0x0000000d30307232ULL, 0x084fe40000200000ULL, 0x0000000d32327232ULL, 0x000fe40000200000ULL,
0x0000000e31317232ULL, 0x080fe40000200000ULL, 0x0000000e33337232ULL, 0x000fce0000200000ULL,
0x00000000413c783bULL, 0x000ee20000004200ULL, 0x00000040070a7890ULL, 0x000fe2000fffe03fULL,
0x000000014d4d7836ULL, 0x000fe40000000000ULL, 0x000000004038783bULL, 0x000f260000004200ULL,
0x0000000a0f007c0cULL, 0x000fe4000bf03070ULL, 0x00000018ff5c7819ULL, 0x008fe2000001143cULL,
0x000001003c547824ULL, 0x040fe200078e00ffULL, 0x000088803c5e7816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5b7819ULL, 0x000fe2000001143dULL,
0x000001003d557824ULL, 0x000fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fe20000011454ULL,
0x0000005c005c7306ULL, 0x000fe20000202400ULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x000001003b6a7824ULL, 0x010fe200078e00ffULL, 0x000088803d627816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff557819ULL, 0x000fc40000011455ULL,
0x00000018ff5a7819ULL, 0x000fe2000001143eULL, 0x0000005400637306ULL, 0x0007e20000202400ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x000088803e5d7816ULL, 0x040fe400000000ffULL,
0x00000018ff537819ULL, 0x000fe40000011438ULL, 0x00000018ff527819ULL, 0x000fe20000011439ULL,
0x0000003c00677306ULL, 0x0009e20000202400ULL, 0x000001003e547824ULL, 0x008fe200078e00ffULL,
0x0000888038567816ULL, 0x000fe200000000ffULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x000088803f5f7816ULL, 0x000fc400000000ffULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x0000005e005e7306ULL, 0x000ee20000202400ULL, 0x000001003f3c7824ULL, 0x050fe200078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x00000018ff587819ULL, 0x000fe2000001143fULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000006200627306ULL, 0x000fe20000202400ULL, 0x00000018ff507819ULL, 0x000fc4000001143aULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x00000018ff517819ULL, 0x000fe4000001143bULL,
0x00000018ff6a7819ULL, 0x000fe2000001146aULL, 0x0000005500697306ULL, 0x000f300000202400ULL,
0x0000003d00647306ULL, 0x000bf00000202400ULL, 0x0000005400607306ULL, 0x0007e20000202400ULL,
0x00000100383d7824ULL, 0x022fc400078e00ffULL, 0x0001000038387824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000003c00667306ULL, 0x0003e20000202400ULL,
0x0000888039547816ULL, 0x00cfe400000000ffULL, 0x00000018ff387819ULL, 0x000fca0000011438ULL,
0x0000003e00617306ULL, 0x000fe20000202400ULL, 0x00000100393c7824ULL, 0x042fe400078e00ffULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x00000018ff397819ULL, 0x000fe20000011439ULL, 0x0000005b005b7306ULL, 0x000e700000202400ULL,
0x00000038003e7306ULL, 0x0005f00000202400ULL, 0x0000003900557306ULL, 0x0009e20000202400ULL,
0x000054105e387816ULL, 0x004fce0000000063ULL, 0x0000005d005d7306ULL, 0x000ea20000202400ULL,
0x0000541062397816ULL, 0x010fce0000000069ULL, 0x0000005f005f7306ULL, 0x000ee20000202400ULL,
0x000000383010723cULL, 0x000fee0000041810ULL, 0x000100003a397824ULL, 0x000fe200078e00ffULL,
0x0000541067387816ULL, 0x000fe2000000005cULL, 0x0000005800587306ULL, 0x000fe60000202400ULL,
0x00000018ff5c7819ULL, 0x000fc40000011439ULL, 0x0000541064397816ULL, 0x002fe2000000005bULL,
0x000100003b5b7824ULL, 0x000fe400078e00ffULL, 0x0000003f00657306ULL, 0x0003260000202400ULL,
0x00000018ff5b7819ULL, 0x000fe2000001145bULL, 0x000000383014723cULL, 0x000fe80000041814ULL,
0x0000003d00577306ULL, 0x000be20000202400ULL, 0x000088803a3f7816ULL, 0x002fc400000000ffULL,
0x000054105d387816ULL, 0x004fe40000000060ULL, 0x000054105f397816ULL, 0x008fc60000000066ULL,
0x0000005a005a7306ULL, 0x000e620000202400ULL, 0x000001003a3d7824ULL, 0x020fc600078e00ffULL,
0x000000383018723cULL, 0x000fe40000041818ULL, 0x00000018ff687819ULL, 0x000fe4000001143dULL,
0x000088803b3d7816ULL, 0x000fe200000000ffULL, 0x0000005600567306ULL, 0x000ea40000202400ULL,
0x0000541065397816ULL, 0x010fe40000000058ULL, 0x0000541061387816ULL, 0x002fc8000000005aULL,
0x0000005400547306ULL, 0x000fe60000202400ULL, 0x00000038301c723cULL, 0x000fea000004181cULL,
0x0000003c00597306ULL, 0x000e640000202400ULL, 0x0000541056387816ULL, 0x004fe20000000057ULL,
0x00000001ff567424ULL, 0x000fca00078e00ffULL, 0x0000005300537306ULL, 0x000ea20000202400ULL,
0x0000541054397816ULL, 0x002fce0000000059ULL, 0x0000005200527306ULL, 0x000e620000202400ULL,
0x000000383020723cULL, 0x000fe20000041820ULL, 0x000054103e547816ULL, 0x004fcc0000000053ULL,
0x0000005000507306ULL, 0x000fe20000202400ULL, 0x0186b856073879a7ULL, 0x0004a2000850003fULL,
0x0000541055557816ULL, 0x002fcc0000000052ULL, 0x0000005100517306ULL, 0x000fe20000202400ULL,
0x0186905607ff79a7ULL, 0x0005e2000850003fULL, 0x000000543024723cULL, 0x000fec0000041824ULL,
0x0000003f003f7306ULL, 0x000ff00000202400ULL, 0x00000068003c7306ULL, 0x000e700000202400ULL,
0x0000003d003d7306ULL, 0x000fe20000202400ULL, 0x000054103f3c7816ULL, 0x002fce000000003cULL,
0x0000006a003a7306ULL, 0x000e700000202400ULL, 0x0000005c003b7306ULL, 0x000ee20000202400ULL,
0x000054103d3d7816ULL, 0x002fce000000003aULL, 0x0000005b00587306ULL, 0x000e620000202400ULL,
0x0000003c3028723cULL, 0x000fe20000041828ULL, 0x000054103b507816ULL, 0x008fe40000000050ULL,
0x0000541058517816ULL, 0x002fce0000000051ULL, 0x00000050302c723cULL, 0x000fe2000004182cULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000007400e00947ULL, 0x004fde0003800000ULL,
0x0000000000307805ULL, 0x000fe20000015200ULL, 0x0186b839070075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff387224ULL, 0x000fce00078e00ffULL,
0x000000103800780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x000fcc0000015200ULL, 0x00000032303b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000133337824ULL, 0x000fe200000e0e31ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff327819ULL, 0x000fc80000011433ULL,
0x0000003b32327211ULL, 0x000fca00078110ffULL, 0x000000ffff337224ULL, 0x000fca00000e0633ULL,
0x0000000232327819ULL, 0x000fc80000001233ULL, 0x000000320000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000138387836ULL, 0x000fce0000000000ULL,
0x0186b839070075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000400209947ULL, 0x000fea0003800000ULL, 0x0000000104307824ULL, 0x000fe200078e0235ULL,
0x00000060070a7890ULL, 0x000fe2000fffe03fULL, 0x0000002008317811ULL, 0x000fe200078e38ffULL,
0x00000002353f7836ULL, 0x000fe40000000000ULL, 0x0000000130327824ULL, 0x040fe400078e0209ULL,
0x00000010304d7824ULL, 0x000fe400078e00ffULL, 0x0000000435537836ULL, 0x000fe40000000000ULL,
0x0000000635577836ULL, 0x000fe20000000000ULL, 0xfffffff04d4d7812ULL, 0x000fe200078ee232ULL,
0x0000000104327824ULL, 0x000fc400078e023fULL, 0x0000000130387824ULL, 0x000fe200078e0231ULL,
0x0000000a0f307c48ULL, 0x000fe2000ffe0000ULL, 0x00000001043c7824ULL, 0x040fe400078e0253ULL,
0x0000000104507824ULL, 0x000fe200078e0257ULL, 0x0000004f38387210ULL, 0x000fe20007f1e0ffULL,
0x00000001323a7824ULL, 0x040fe400078e0231ULL, 0x0000000132337824ULL, 0x040fe400078e0209ULL,
0x0000001032527824ULL, 0x000fc400078e00ffULL, 0x000000013c3e7824ULL, 0x040fe400078e0231ULL,
0x000000013c327824ULL, 0x040fe200078e0209ULL, 0xfffffff052517812ULL, 0x000fe200078ee233ULL,
0x000000103c557824ULL, 0x000fe200078e00ffULL, 0x0000004f3a337210ULL, 0x000fe20007f5e0ffULL,
0x00000001503c7824ULL, 0x040fe200078e0231ULL, 0x0000004f3e3d7210ULL, 0x000fe20007f7e0ffULL,
0x8000000a30317c36ULL, 0x000fe20008000000ULL, 0x00008a00000a7ab9ULL, 0x000fe20000000a00ULL,
0x0000000150397824ULL, 0x040fe200078e0209ULL, 0xfffffff055557812ULL, 0x000fe200078ee232ULL,
0x0000001050507824ULL, 0x000fe200078e00ffULL, 0x0000003104317248ULL, 0x000fe20007fe0000ULL,
0x000000ffff307224ULL, 0x000fe200010e06ffULL, 0x0000000a33327c11ULL, 0x000fe2000f8440ffULL,
0x000000ffff3b7224ULL, 0x000fe200000e06ffULL, 0xfffffff050597812ULL, 0x000fe200078ee239ULL,
0x00000001313a7824ULL, 0x000fe200078e0a04ULL, 0x0000000a38397c11ULL, 0x040fe2000f8040ffULL,
0x00016000073e7836ULL, 0x000fe20000000000ULL, 0x0000000b33337c11ULL, 0x000fe200090f4430ULL,
0x000000ffff307224ULL, 0x000fe200018e06ffULL, 0x0000000b38317c11ULL, 0x000fe200080f443bULL,
0x000000104d4d7824ULL, 0x100fe200078e023eULL, 0x0000003a3f00720cULL, 0x000fe20003f06070ULL,
0x0000001051517824ULL, 0x100fe200078e023eULL, 0x0000000a3d387c11ULL, 0x000fe2000f8640ffULL,
0x0000001055557824ULL, 0x100fe200078e023eULL, 0x000000f0363f7812ULL, 0x000fe200078ec0ffULL,
0x0000001059597824ULL, 0x000fe200078e023eULL, 0x0000004f3c3c7210ULL, 0x000fc40007fbe0ffULL,
0x0000000b3d3d7c11ULL, 0x000fe400098f4430ULL, 0x0000003f39307210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff397224ULL, 0x000fe200028e06ffULL, 0x0000003f32327210ULL, 0x000fe40007fbe0ffULL,
0x0000000a3c3b7c11ULL, 0x000fe2000f8640ffULL, 0x000000ffff317224ULL, 0x000fe200020e0631ULL,
0x0000003a3500720cULL, 0x080fe20003f86070ULL, 0x000000ffff337224ULL, 0x000fe200028e0633ULL,
0x0000003a5300720cULL, 0x000fc40003f46070ULL, 0x0000003a5700720cULL, 0x000fe40003fa6070ULL,
0x0000003f38387210ULL, 0x000fe40007fde0ffULL, 0x0000000b3c3c7c11ULL, 0x000fe400098f4439ULL,
0x0000003f3b3a7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff397224ULL, 0x000fe400030e063dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000304d7faeULL, 0x0003e4000e101c48ULL,
0x000000ffff3b7224ULL, 0x000fc400018e063cULL, 0x0000000032517faeULL, 0x0003e8000c101c48ULL,
0x0000000038557faeULL, 0x0003e8000d101c48ULL, 0x000000003a597faeULL, 0x0003e2000e901c48ULL,
0x0000000000ec7947ULL, 0x000fea0003800000ULL, 0x0000000104307824ULL, 0x000fe200078e0235ULL,
0x0000002008317811ULL, 0x000fe200078e38ffULL, 0x00008a00000a7ab9ULL, 0x000fe40000000a00ULL,
0x0000000130327824ULL, 0x140fe400078e0209ULL, 0x00000010303b7824ULL, 0x000fe400078e00ffULL,
0x0000000230387836ULL, 0x000fe40000000000ULL, 0x00000004303a7836ULL, 0x000fe20000000000ULL,
0xfffffff03b3c7812ULL, 0x000fe200078ee232ULL, 0x0000000138337824ULL, 0x000fc400078e0209ULL,
0x0000001038507824ULL, 0x000fe400078e00ffULL, 0x0000000130327824ULL, 0x000fe400078e0231ULL,
0x000000013a397824ULL, 0x140fe200078e0209ULL, 0xfffffff050507812ULL, 0x000fe200078ee233ULL,
0x000000103a527824ULL, 0x000fe200078e00ffULL, 0x0000004f32337210ULL, 0x000fe20007f1e0ffULL,
0x00000006303e7836ULL, 0x000fe40000000000ULL, 0x0000000131307824ULL, 0x040fe200078e0238ULL,
0xfffffff052527812ULL, 0x000fe200078ee239ULL, 0x0000000131327824ULL, 0x000fe200078e023aULL,
0x0000000a333b7c11ULL, 0x000fe2000f8440ffULL, 0x000000ffff3a7224ULL, 0x000fe200000e06ffULL,
0x000000304f307210ULL, 0x000fe20007f1e0ffULL, 0x000000013e397824ULL, 0x000fc400078e0209ULL,
0x000000103e547824ULL, 0x000fe400078e00ffULL, 0x0000000131387824ULL, 0x000fe200078e023eULL,
0x0000000b333e7c11ULL, 0x000fe200090f443aULL, 0x0001600007317836ULL, 0x000fe20000000000ULL,
0xfffffff054547812ULL, 0x000fe200078ee239ULL, 0x000000ffff3d7224ULL, 0x000fe200000e06ffULL,
0x0000000a30337c11ULL, 0x000fe2000f8040ffULL, 0x00000010504d7824ULL, 0x100fe200078e0231ULL,
0x000000324f327210ULL, 0x000fe20007f5e0ffULL, 0x000000103c3f7824ULL, 0x100fe200078e0231ULL,
0x000000f036507812ULL, 0x000fe200078ec0ffULL, 0x0000001052517824ULL, 0x100fe200078e0231ULL,
0x000000384f387210ULL, 0x000fe20007f7e0ffULL, 0x0000001054537824ULL, 0x000fe200078e0231ULL,
0x0000000b303d7c11ULL, 0x000fe200080f443dULL, 0x000000ffff317224ULL, 0x000fe200010e06ffULL,
0x000000503b307210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff3b7224ULL, 0x000fe200018e06ffULL,
0x0000000a32397c11ULL, 0x000fc4000f8040ffULL, 0x0000000a383a7c11ULL, 0x000fe4000f8440ffULL,
0x0000000b323c7c11ULL, 0x000fe200080f4431ULL, 0x000000ffff317224ULL, 0x000fe200020e063eULL,
0x0000005033327210ULL, 0x000fe40007f1e0ffULL, 0x0000000b383b7c11ULL, 0x000fe400090f443bULL,
0x0000005039387210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff337224ULL, 0x000fe200000e063dULL,
0x000000503a3a7210ULL, 0x000fe20007f7e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000303f7faeULL, 0x0003e4000b901c48ULL, 0x000000ffff397224ULL, 0x000fc400010e063cULL,
0x000000ffff3b7224ULL, 0x000fe200018e063bULL, 0x00000000324d7faeULL, 0x0003e8000b901c48ULL,
0x0000000038517faeULL, 0x0003e8000b901c48ULL, 0x000000003a537faeULL, 0x0003e4000b901c48ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x00000001ff387424ULL, 0x000fe200078e00ffULL,
0x00000000ff0079b0ULL, 0x000fe20008000a46ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0186b038075079a7ULL, 0x0002a4000850003fULL, 0x01864838033879a7ULL, 0x0022e4000850003fULL,
0x0000000000307805ULL, 0x000fce0000015200ULL, 0x01864839030075a7ULL, 0x008ee4000800017fULL,
0x00000000005c0947ULL, 0x008fea0003800000ULL, 0x000000ffff3a7224ULL, 0x000fce00078e00ffULL,
0x000000103a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x000fce0000015200ULL, 0x00000032303b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000133337824ULL, 0x000fe200000e0e31ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff327819ULL, 0x000fc80000011433ULL,
0x0000003b32327211ULL, 0x000fca00078110ffULL, 0x000000ffff337224ULL, 0x000fca00000e0633ULL,
0x0000000232327819ULL, 0x000fc80000001233ULL, 0x000000320000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013a3a7836ULL, 0x000fce0000000000ULL,
0x01864839030075a7ULL, 0x000ee4000800017fULL, 0xfffffffc00a88947ULL, 0x008fea000383ffffULL,
0x018100004b317984ULL, 0x000ee20000000800ULL, 0x00000001ff387424ULL, 0x000fc600078e00ffULL,
0x018300004b337984ULL, 0x0009220000000800ULL, 0x0000004e3100720bULL, 0x008fda0003f1d000ULL,
0x0000000000397806ULL, 0x000fc800000e0100ULL, 0x0000ffff39ff7812ULL, 0x000fda000780c0ffULL,
0x0000000000f48947ULL, 0x016fea0003800000ULL, 0x000000023400780cULL, 0x000fe40003f45270ULL,
0x0000004e3100720bULL, 0x000fd60003f14000ULL, 0x000000314e30a209ULL, 0x000fe40007810000ULL,
0x0000000000387806ULL, 0x000fc600000e0100ULL, 0x018500304b00a388ULL, 0x0003e20000000800ULL,
0x0000991038327816ULL, 0x000fc800000000ffULL, 0x000000ff3200720cULL, 0x000fda0003f05270ULL,
0x0000000000b48947ULL, 0x002fea0003800000ULL, 0x000000314e3b7209ULL, 0x000fe40007810000ULL,
0x000000ff38ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0038ff7812ULL, 0x000fe2000784c0ffULL,
0x8000003b4e307221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b30307820ULL, 0x000fc80000410000ULL,
0x00000030003b7308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff307819ULL, 0x002fcc0000011609ULL, 0x00001f303b307589ULL, 0x004e6400000e0000ULL,
0x0000003010107220ULL, 0x082fe20000410000ULL, 0x0000003011117220ULL, 0x080fe20000410000ULL,
0x0000003014147220ULL, 0x080fe20000410000ULL, 0x0000003015157220ULL, 0x080fe20000410000ULL,
0x0000003018187220ULL, 0x080fe20000410000ULL, 0x0000003019197220ULL, 0x080fe20000410000ULL,
0x000000301c1c7220ULL, 0x080fe20000410000ULL, 0x000000301d1d7220ULL, 0x080fe20000410000ULL,
0x0000003020207220ULL, 0x080fe20000410000ULL, 0x0000003021217220ULL, 0x080fe20000410000ULL,
0x0000003024247220ULL, 0x080fe20000410000ULL, 0x0000003025257220ULL, 0x080fe20000410000ULL,
0x0000003028287220ULL, 0x080fe20000410000ULL, 0x0000003029297220ULL, 0x080fe20000410000ULL,
0x000000302c2c7220ULL, 0x080fe20000410000ULL, 0x000000302d2d7220ULL, 0x000fce0000410000ULL,
0x0000003b00007220ULL, 0x004fe20000410000ULL, 0x000000000048a947ULL, 0x000fec0003800000ULL,
0x0000000809307811ULL, 0x002fcc00078ff0ffULL, 0x00001f303b307589ULL, 0x000e6400000e0000ULL,
0x0000003012127220ULL, 0x082fe20000410000ULL, 0x0000003013137220ULL, 0x080fe20000410000ULL,
0x0000003016167220ULL, 0x080fe20000410000ULL, 0x0000003017177220ULL, 0x080fe20000410000ULL,
0x000000301a1a7220ULL, 0x080fe20000410000ULL, 0x000000301b1b7220ULL, 0x080fe20000410000ULL,
0x000000301e1e7220ULL, 0x080fe20000410000ULL, 0x000000301f1f7220ULL, 0x080fe20000410000ULL,
0x0000003022227220ULL, 0x080fe20000410000ULL, 0x0000003023237220ULL, 0x080fe20000410000ULL,
0x0000003026267220ULL, 0x080fe20000410000ULL, 0x0000003027277220ULL, 0x080fe20000410000ULL,
0x000000302a2a7220ULL, 0x080fe20000410000ULL, 0x000000302b2b7220ULL, 0x080fe20000410000ULL,
0x000000302e2e7220ULL, 0x080fe20000410000ULL, 0x000000302f2f7220ULL, 0x000fce0000410000ULL,
0x0000ffff38ff7812ULL, 0x000fe20007800839ULL, 0x00000001ff387424ULL, 0x000fe200078e00ffULL,
0x000000314e4e7209ULL, 0x000fd60007810000ULL, 0x8000004e31310221ULL, 0x000fe20000010000ULL,
0x00007610ff380816ULL, 0x000fc60000000038ULL, 0x3fb8aa3b31310820ULL, 0x000fc80000410000ULL,
0x00000031000c0308ULL, 0x000ea40000000800ULL, 0x0000000c33330220ULL, 0x004fce0000410000ULL,
0x0000000033007221ULL, 0x000fe20000010000ULL, 0x0000000000307805ULL, 0x002fe20000015200ULL,
0x0186a84c070075a7ULL, 0x000ea4000800017fULL, 0x00000000005c0947ULL, 0x006fea0003800000ULL,
0x000000ffff3a7224ULL, 0x000fce00078e00ffULL, 0x000000103a00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fcc0000015200ULL,
0x0000003230397210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003900780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403900780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000003932327211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013a3a7836ULL, 0x000fce0000000000ULL, 0x0186a84c070075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000991038307816ULL, 0x000fc800000000ffULL,
0x000000ff3000720cULL, 0x000fda0003f45270ULL, 0x0000000000182947ULL, 0x000fea0003800000ULL,
0x00000002ff317819ULL, 0x000fe40000011609ULL, 0x0000000cff0d723eULL, 0x000fc600000010ffULL,
0x0000000831337836ULL, 0x000fe20000000000ULL, 0x000054100d307816ULL, 0x000fca000000000dULL,
0x00001f31300d7589ULL, 0x0002a800000e0000ULL, 0x00001f33300e7589ULL, 0x0002e400000e0000ULL,
0x013000004a30783bULL, 0x0022e20000000200ULL, 0x0000000000102947ULL, 0x000fea0003800000ULL,
0x0000000d30307232ULL, 0x08cfe40000200000ULL, 0x0000000d32327232ULL, 0x000fe40000200000ULL,
0x0000000e31317232ULL, 0x080fe40000200000ULL, 0x0000000e33337232ULL, 0x000fce0000200000ULL,
0x00000000493c783bULL, 0x000f280000004200ULL, 0x000000004838783bULL, 0x000f620000004200ULL,
0x00000018ff5d7819ULL, 0x010fe2000001143cULL, 0x000001003c547824ULL, 0x040fe200078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe2000001143dULL, 0x000001003d557824ULL, 0x040fe200078e00ffULL,
0x000088803c5f7816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x000088803d637816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff527819ULL, 0x022fe20000011438ULL, 0x0000005d005d7306ULL, 0x000fe20000202400ULL,
0x00000018ff3c7819ULL, 0x000fc4000001143cULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000888038577816ULL, 0x000fe400000000ffULL, 0x00000018ff547819ULL, 0x000fe20000011454ULL,
0x0000003c00627306ULL, 0x0003e20000202400ULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x00000018ff5a7819ULL, 0x000fe4000001143fULL, 0x000088803f607816ULL, 0x000fc400000000ffULL,
0x00000018ff537819ULL, 0x000fe20000011439ULL, 0x0000003d00657306ULL, 0x0009e20000202400ULL,
0x000001003f3c7824ULL, 0x002fe200078e00ffULL, 0x0000888039567816ULL, 0x000fe200000000ffULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x000088803e5e7816ULL, 0x000fe400000000ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000005f005f7306ULL, 0x000fe20000202400ULL,
0x00000100383d7824ULL, 0x050fe200078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x0001000038387824ULL, 0x000fe200078e00ffULL, 0x00000018ff5b7819ULL, 0x000fc4000001143eULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000005400667306ULL, 0x0003e20000202400ULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x00000018ff4c7819ULL, 0x000fe4000001143aULL,
0x00000018ff4d7819ULL, 0x000fc6000001143bULL, 0x0000006300637306ULL, 0x000fe20000202400ULL,
0x000001003e547824ULL, 0x042fe400078e00ffULL, 0x000100003e3e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x0000005500687306ULL, 0x000e620000202400ULL,
0x00000018ff3e7819ULL, 0x000fce000001143eULL, 0x0000003c00697306ULL, 0x0009f00000202400ULL,
0x0000003800557306ULL, 0x000be20000202400ULL, 0x00000100393c7824ULL, 0x050fe400078e00ffULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff597819ULL, 0x000fe4000001143cULL,
0x0000005c005c7306ULL, 0x000f220000202400ULL, 0x000001003b387824ULL, 0x028fe200078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x000088803a3c7816ULL, 0x000fe400000000ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000005400617306ULL, 0x000ff00000202400ULL,
0x0000003f00677306ULL, 0x000ff00000202400ULL, 0x0000003900547306ULL, 0x0003f00000202400ULL,
0x00000038003f7306ULL, 0x0007e20000202400ULL, 0x0000541063397816ULL, 0x002fce0000000068ULL,
0x0000005e005e7306ULL, 0x000e620000202400ULL, 0x000054105f387816ULL, 0x008fe20000000066ULL,
0x000100003b5f7824ULL, 0x000fca00078e00ffULL, 0x00000018ff5f7819ULL, 0x000fe2000001145fULL,
0x0000006000607306ULL, 0x000ee20000202400ULL, 0x000000383010723cULL, 0x000fee0000041810ULL,
0x0000003d00587306ULL, 0x000be20000202400ULL, 0x0000541062387816ULL, 0x000fc4000000005dULL,
0x0000541065397816ULL, 0x010fca000000005cULL, 0x0000005b005b7306ULL, 0x000fe20000202400ULL,
0x000001003a3d7824ULL, 0x064fe200078e00ffULL, 0x000000383014723cULL, 0x000fe20000041814ULL,
0x000100003a3a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000005a005a7306ULL, 0x000ea20000202400ULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x000054105e387816ULL, 0x002fe40000000061ULL, 0x0000541060397816ULL, 0x008fc60000000069ULL,
0x0000003e00647306ULL, 0x0002e80000202400ULL, 0x000000383018723cULL, 0x000fe80000041818ULL,
0x0000003c003c7306ULL, 0x000fe20000202400ULL, 0x000088803b3e7816ULL, 0x002fe400000000ffULL,
0x0000541067397816ULL, 0x004fc4000000005aULL, 0x0000541064387816ULL, 0x008fc6000000005bULL,
0x0000003d003d7306ULL, 0x000e680000202400ULL, 0x00000038301c723cULL, 0x000fe8000004181cULL,
0x0000005200527306ULL, 0x000ea20000202400ULL, 0x000054103c3c7816ULL, 0x002fce000000003dULL,
0x0000005300537306ULL, 0x000e620000202400ULL, 0x0000541055527816ULL, 0x004fce0000000052ULL,
0x0000004c004c7306ULL, 0x000fe20000202400ULL, 0x0000541054537816ULL, 0x002fce0000000053ULL,
0x0000004d004d7306ULL, 0x000fe20000202400ULL, 0x000000523024723cULL, 0x000fee0000041824ULL,
0x0000005700577306ULL, 0x000e700000202400ULL, 0x0000005600567306ULL, 0x000fe20000202400ULL,
0x0000541057387816ULL, 0x002fce0000000058ULL, 0x0000005900597306ULL, 0x000e700000202400ULL,
0x0000003e003e7306ULL, 0x000ea20000202400ULL, 0x0000541056397816ULL, 0x002fce0000000059ULL,
0x0000003a003b7306ULL, 0x000e620000202400ULL, 0x000000383020723cULL, 0x000fe20000041820ULL,
0x000054103e3d7816ULL, 0x004fcc000000003fULL, 0x0000005f005c7306ULL, 0x000ea20000202400ULL,
0x0000003c3028723cULL, 0x000fe20000041828ULL, 0x000054103b4c7816ULL, 0x002fe4000000004cULL,
0x000054105c4d7816ULL, 0x004fce000000004dULL, 0x0000004c302c723cULL, 0x000fe2000004182cULL,
0x013000004630783bULL, 0x0002a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000102947ULL, 0x000fde0003800000ULL, 0x0000000d30307232ULL, 0x084fe40000200000ULL,
0x0000000d32327232ULL, 0x000fe40000200000ULL, 0x0000000e31317232ULL, 0x080fe40000200000ULL,
0x0000000e33337232ULL, 0x000fce0000200000ULL, 0x00000000453c783bULL, 0x000ee80000004200ULL,
0x000000004438783bULL, 0x000f220000004200ULL, 0x00000018ff5d7819ULL, 0x008fe2000001143cULL,
0x000001003c547824ULL, 0x040fe200078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe2000001143dULL,
0x000001003d557824ULL, 0x040fe200078e00ffULL, 0x000088803c5f7816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x000088803d637816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff527819ULL, 0x010fe20000011438ULL,
0x0000005d005d7306ULL, 0x000fe20000202400ULL, 0x00000018ff3c7819ULL, 0x000fc4000001143cULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000888038577816ULL, 0x000fe400000000ffULL,
0x00000018ff547819ULL, 0x000fe20000011454ULL, 0x0000003c00627306ULL, 0x0007e20000202400ULL,
0x00000018ff557819ULL, 0x000fe40000011455ULL, 0x00000018ff5a7819ULL, 0x000fe4000001143fULL,
0x000088803f607816ULL, 0x000fc400000000ffULL, 0x00000018ff537819ULL, 0x000fe20000011439ULL,
0x0000003d00657306ULL, 0x0009e20000202400ULL, 0x000001003f3c7824ULL, 0x008fe200078e00ffULL,
0x0000888039567816ULL, 0x000fe200000000ffULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x000088803e5e7816ULL, 0x000fe400000000ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000005f005f7306ULL, 0x000fe20000202400ULL, 0x00000100383d7824ULL, 0x050fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x0001000038387824ULL, 0x000fe200078e00ffULL,
0x00000018ff5b7819ULL, 0x000fc4000001143eULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000005400667306ULL, 0x0007e20000202400ULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x00000018ff4c7819ULL, 0x000fe4000001143aULL, 0x00000018ff4d7819ULL, 0x000fc6000001143bULL,
0x0000006300637306ULL, 0x000fe20000202400ULL, 0x000001003e547824ULL, 0x048fe400078e00ffULL,
0x000100003e3e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x0000005500687306ULL, 0x000ee20000202400ULL, 0x00000018ff3e7819ULL, 0x000fce000001143eULL,
0x0000003c00697306ULL, 0x0009f00000202400ULL, 0x0000003800557306ULL, 0x000be20000202400ULL,
0x00000100393c7824ULL, 0x050fe400078e00ffULL, 0x0001000039397824ULL, 0x000fc600078e00ffULL,
0x00000018ff597819ULL, 0x000fe4000001143cULL, 0x0000005c005c7306ULL, 0x000f220000202400ULL,
0x000001003b387824ULL, 0x022fe200078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x000088803a3c7816ULL, 0x000fe400000000ffULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x0000005400617306ULL, 0x000ff00000202400ULL, 0x0000003f00677306ULL, 0x000ff00000202400ULL,
0x0000003900547306ULL, 0x0007f00000202400ULL, 0x00000038003f7306ULL, 0x0003e20000202400ULL,
0x0000541063397816ULL, 0x008fce0000000068ULL, 0x0000005e005e7306ULL, 0x000ee20000202400ULL,
0x000054105f387816ULL, 0x002fe20000000066ULL, 0x000100003b5f7824ULL, 0x000fca00078e00ffULL,
0x00000018ff5f7819ULL, 0x000fe2000001145fULL, 0x0000006000607306ULL, 0x000e620000202400ULL,
0x000000383010723cULL, 0x004fee0000041810ULL, 0x0000541062387816ULL, 0x000fe2000000005dULL,
0x0000005b005b7306ULL, 0x000fe20000202400ULL, 0x0000541065397816ULL, 0x010fce000000005cULL,
0x0000005a005a7306ULL, 0x000fe20000202400ULL, 0x000000383014723cULL, 0x000fee0000041814ULL,
0x0000003e00647306ULL, 0x0005220000202400ULL, 0x000054105e387816ULL, 0x008fe40000000061ULL,
0x0000541060397816ULL, 0x002fca0000000069ULL, 0x0000003d00587306ULL, 0x0003e20000202400ULL,
0x000088803b3e7816ULL, 0x004fe200000000ffULL, 0x000000383018723cULL, 0x000fec0000041818ULL,
0x0000005700577306ULL, 0x000ea20000202400ULL, 0x000001003a3d7824ULL, 0x002fe200078e00ffULL,
0x0000541064387816ULL, 0x010fe2000000005bULL, 0x000100003a3a7824ULL, 0x000fe200078e00ffULL,
0x0000541067397816ULL, 0x000fc4000000005aULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000005600567306ULL, 0x000fe20000202400ULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x00000038301c723cULL, 0x000fea000004181cULL, 0x0000005900597306ULL, 0x000e640000202400ULL,
0x0000541057387816ULL, 0x004fcc0000000058ULL, 0x0000003c003c7306ULL, 0x000fe20000202400ULL,
0x0000541056397816ULL, 0x002fce0000000059ULL, 0x0000003d003d7306ULL, 0x000e620000202400ULL,
0x000000383020723cULL, 0x000fee0000041820ULL, 0x0000005200527306ULL, 0x000ea20000202400ULL,
0x00000001ff387424ULL, 0x000fe200078e00ffULL, 0x000054103c3c7816ULL, 0x002fcc000000003dULL,
0x0000005300537306ULL, 0x000e620000202400ULL, 0x0186b838073879a7ULL, 0x000ee2000850003fULL,
0x0000541055527816ULL, 0x004fcc0000000052ULL, 0x0000004c004c7306ULL, 0x000fe20000202400ULL,
0x0000541054537816ULL, 0x002fce0000000053ULL, 0x0000004d004d7306ULL, 0x000fe20000202400ULL,
0x000000523024723cULL, 0x000fee0000041824ULL, 0x0000003e003e7306ULL, 0x000e700000202400ULL,
0x0000003a003b7306ULL, 0x000ea20000202400ULL, 0x000054103e3d7816ULL, 0x002fce000000003fULL,
0x0000005f005c7306ULL, 0x000e620000202400ULL, 0x0000003c3028723cULL, 0x000fe20000041828ULL,
0x000054103b4c7816ULL, 0x004fe4000000004cULL, 0x000054105c4d7816ULL, 0x002fce000000004dULL,
0x0000004c302c723cULL, 0x000fee000004182cULL, 0x0000000000307805ULL, 0x000fe20000015200ULL,
0x0186b839070075a7ULL, 0x008e64000800017fULL, 0x00000000005c0947ULL, 0x002fdc0003800000ULL,
0x000000ffff3a7224ULL, 0x000fce00078e00ffULL, 0x000000103a00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fcc0000015200ULL,
0x00000032303b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000003b32327211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013a3a7836ULL, 0x000fce0000000000ULL, 0x0186b839070075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000400209947ULL, 0x000fea0003800000ULL,
0x00000002353d7836ULL, 0x000fe20000000000ULL, 0x00000080070a7890ULL, 0x000fe2000fffe03fULL,
0x00000040083b7811ULL, 0x000fe200078e38ffULL, 0x0000000104307824ULL, 0x040fe200078e0235ULL,
0x00008a00000c7ab9ULL, 0x000fe20000000a00ULL, 0x0000000104387824ULL, 0x000fe400078e023dULL,
0x0000000130317824ULL, 0x100fe400078e0209ULL, 0x0000000138327824ULL, 0x040fe400078e0209ULL,
0x0000001038337824ULL, 0x000fc400078e00ffULL, 0x00000010303c7824ULL, 0x000fe400078e00ffULL,
0x00000001383e7824ULL, 0x100fe200078e023bULL, 0xfffffff033527812ULL, 0x000fe200078ee232ULL,
0x0000000130327824ULL, 0x000fe200078e023bULL, 0x0000000a0f307c48ULL, 0x000fe2000ffe0000ULL,
0x0000000435537836ULL, 0x000fe20000000000ULL, 0xfffffff03c3c7812ULL, 0x000fe200078ee231ULL,
0x0000000635557836ULL, 0x000fe20000000000ULL, 0x0000004f32397210ULL, 0x000fe20007f1e0ffULL,
0x8000000a30317c36ULL, 0x000fe20008000000ULL, 0x0000004f3e3e7210ULL, 0x000fe20007f7e0ffULL,
0x00000001044c7824ULL, 0x000fc400078e0253ULL, 0x000000ffff307224ULL, 0x000fe200000e06ffULL,
0x0000003104317248ULL, 0x000fe20007fe0000ULL, 0x000000ffff337224ULL, 0x000fe200018e06ffULL,
0x0000000c39327c11ULL, 0x000fe2000f8040ffULL, 0x000000014c387824ULL, 0x040fe400078e0209ULL,
0x00000001313a7824ULL, 0x000fe200078e0a04ULL, 0x0000000d39397c11ULL, 0x000fe200080f4430ULL,
0x000000104c3f7824ULL, 0x000fe200078e00ffULL, 0x0000000c3e317c11ULL, 0x000fe2000f8640ffULL,
0x000000014c307824ULL, 0x000fe200078e023bULL, 0x000000f0364c7812ULL, 0x000fe200078ec0ffULL,
0x0000000104567824ULL, 0x000fe200078e0255ULL, 0x0000003a3500720cULL, 0x000fc40003f86070ULL,
0x0000000d3e3e7c11ULL, 0x000fe400098f4433ULL, 0xfffffff03f547812ULL, 0x000fe200078ee238ULL,
0x00014000073f7836ULL, 0x000fe20000000000ULL, 0x0000004c32327210ULL, 0x000fe40007f7e0ffULL,
0x0000003a3d00720cULL, 0x080fe20003f06070ULL, 0x000000103c4d7824ULL, 0x000fe200078e023fULL,
0x0000004f303d7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff337224ULL, 0x000fe200018e0639ULL,
0x0000003a5300720cULL, 0x000fe20003f66070ULL, 0x00000001563c7824ULL, 0x000fc400078e023bULL,
0x000000ffff307224ULL, 0x000fe200028e06ffULL, 0x0000000c3d387c11ULL, 0x040fe2000f8a40ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000324d7faeULL, 0x0003e2000e101c48ULL,
0x0000004f3c397210ULL, 0x000fe20007f9e0ffULL, 0x0000000156537824ULL, 0x040fe200078e0209ULL,
0x0000000d3d3d7c11ULL, 0x000fe2000a8f4430ULL, 0x0000001056567824ULL, 0x000fe200078e00ffULL,
0x0000004c31307210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff3c7224ULL, 0x000fe200020e06ffULL,
0x0000000c393b7c11ULL, 0x000fe4000f8840ffULL, 0x0000004c38387210ULL, 0x000fe20007fde0ffULL,
0x000000ffff317224ULL, 0x000fe200028e063eULL, 0x0000003a5500720cULL, 0x000fc40003fa6070ULL,
0x0000000d39337c11ULL, 0x002fe2000a0f443cULL, 0x000000ffff397224ULL, 0x000fe200030e063dULL,
0xfffffff0563e7812ULL, 0x000fe200078ee253ULL, 0x00000010543d7824ULL, 0x100fe200078e023fULL,
0x0000004c3b327210ULL, 0x000fe20007f9e0ffULL, 0x00000010523b7824ULL, 0x100fe400078e023fULL,
0x000000103e3f7824ULL, 0x000fe400078e023fULL, 0x000000ffff337224ULL, 0x000fe200020e0633ULL,
0x00000000303b7faeULL, 0x0003e8000c101c48ULL, 0x00000000383d7faeULL, 0x0003e8000d901c48ULL,
0x00000000323f7faeULL, 0x0003e2000e901c48ULL, 0x0000000000ec7947ULL, 0x000fea0003800000ULL,
0x0000000104307824ULL, 0x000fe200078e0235ULL, 0x0000004008317811ULL, 0x000fe200078e38ffULL,
0x00008a00000a7ab9ULL, 0x000fe20000000a00ULL, 0x000000f0363f7812ULL, 0x000fe200078ec0ffULL,
0x0000000230387836ULL, 0x000fe40000000000ULL, 0x0000000130327824ULL, 0x140fe400078e0209ULL,
0x00000010303b7824ULL, 0x000fe400078e00ffULL, 0x0000000138337824ULL, 0x000fc400078e0209ULL,
0x00000010383c7824ULL, 0x000fe200078e00ffULL, 0xfffffff03b3a7812ULL, 0x000fe200078ee232ULL,
0x00000004303e7836ULL, 0x000fe40000000000ULL, 0x0000000130327824ULL, 0x000fe200078e0231ULL,
0xfffffff03c3c7812ULL, 0x000fe200078ee233ULL, 0x0000000630527836ULL, 0x000fe40000000000ULL,
0x000000013e397824ULL, 0x040fe200078e0209ULL, 0x0000004f32327210ULL, 0x000fe20007f1e0ffULL,
0x000000103e4c7824ULL, 0x000fc400078e00ffULL, 0x0000000152547824ULL, 0x040fe400078e0231ULL,
0x0000000152337824ULL, 0x040fe200078e0209ULL, 0xfffffff04c4c7812ULL, 0x000fe200078ee239ULL,
0x0000001052527824ULL, 0x000fe200078e00ffULL, 0x0000004f543b7210ULL, 0x000fe20007f9e0ffULL,
0x0000000138307824ULL, 0x100fe200078e0231ULL, 0x0000000a32387c11ULL, 0x000fe2000f8640ffULL,
0x000000ffff397224ULL, 0x000fe200000e06ffULL, 0xfffffff052527812ULL, 0x000fe200078ee233ULL,
0x000000013e3e7824ULL, 0x000fe200078e0231ULL, 0x0000004f30337210ULL, 0x000fe20007f1e0ffULL,
0x0001400007317836ULL, 0x000fe20000000000ULL, 0x0000000b323d7c11ULL, 0x000fc600098f4439ULL,
0x000000103c537824ULL, 0x100fe200078e0231ULL, 0x0000004f3e3c7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff307224ULL, 0x000fe200000e06ffULL, 0x0000000a33327c11ULL, 0x040fe2000f8040ffULL,
0x000000103a4d7824ULL, 0x100fe400078e0231ULL, 0x000000104c557824ULL, 0x100fe200078e0231ULL,
0x0000000b33337c11ULL, 0x000fe200080f4430ULL, 0x0000001052577824ULL, 0x000fe200078e0231ULL,
0x0000003f38307210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff317224ULL, 0x000fe200018e06ffULL,
0x0000000a3c397c11ULL, 0x000fe2000f8040ffULL, 0x000000ffff387224ULL, 0x000fe200020e06ffULL,
0x0000000a3b3a7c11ULL, 0x000fc4000f8640ffULL, 0x0000000b3c3c7c11ULL, 0x000fe200080f4431ULL,
0x000000ffff317224ULL, 0x000fe200028e063dULL, 0x0000003f32327210ULL, 0x000fe40007f1e0ffULL,
0x0000000b3b3b7c11ULL, 0x000fe400098f4438ULL, 0x0000003f39387210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff337224ULL, 0x000fe200000e0633ULL, 0x0000003f3a3a7210ULL, 0x000fe20007f9e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000304d7faeULL, 0x0003e4000b901c48ULL,
0x000000ffff397224ULL, 0x000fc400018e063cULL, 0x000000ffff3b7224ULL, 0x000fe200020e063bULL,
0x0000000032537faeULL, 0x0003e8000b901c48ULL, 0x0000000038557faeULL, 0x0003e8000b901c48ULL,
0x000000003a577faeULL, 0x0003e4000b901c48ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000001ff4c7424ULL, 0x000fe200078e00ffULL, 0x00000000ff0079b0ULL, 0x000fe20008000a45ULL,
0x0000000000007918ULL, 0x000fc80000000000ULL, 0x0186a84c074c79a7ULL, 0x000e64000850003fULL,
0x000000ffff4c7224ULL, 0x002fe200078e004dULL, 0x0000000000307805ULL, 0x000fe20000015200ULL,
0x0186b051070075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff387224ULL, 0x000fce00078e00ffULL, 0x000000103800780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fcc0000015200ULL,
0x0000003230397210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003900780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403900780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000003932327211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000138387836ULL, 0x000fce0000000000ULL, 0x0186b051070075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000000182947ULL, 0x000fea0003800000ULL,
0x00000002ff317819ULL, 0x000fe40000011609ULL, 0x0000000cff0d723eULL, 0x000fc600000010ffULL,
0x0000000831337836ULL, 0x000fe20000000000ULL, 0x000054100d307816ULL, 0x000fca000000000dULL,
0x00001f31300d7589ULL, 0x0002a800000e0000ULL, 0x00001f33300e7589ULL, 0x0002e400000e0000ULL,
0x013000004730783bULL, 0x0022e20000000200ULL, 0x0000000000102947ULL, 0x000fea0003800000ULL,
0x0000000d30307232ULL, 0x08cfe40000200000ULL, 0x0000000d32327232ULL, 0x000fe40000200000ULL,
0x0000000e31317232ULL, 0x080fe40000200000ULL, 0x0000000e33337232ULL, 0x000fce0000200000ULL,
0x00000000433c783bULL, 0x000f280000004200ULL, 0x000000004238783bULL, 0x000f620000004200ULL,
0x00000018ff5c7819ULL, 0x010fe2000001143cULL, 0x000001003c537824ULL, 0x040fe200078e00ffULL,
0x00000018ff5b7819ULL, 0x000fe2000001143dULL, 0x000001003d547824ULL, 0x040fe200078e00ffULL,
0x000088803c5e7816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x000088803d627816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff517819ULL, 0x022fe20000011438ULL, 0x0000005c005c7306ULL, 0x000fe20000202400ULL,
0x00000018ff3c7819ULL, 0x000fc4000001143cULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000888038567816ULL, 0x000fe400000000ffULL, 0x00000018ff537819ULL, 0x000fe20000011453ULL,
0x0000003c00617306ULL, 0x0003e20000202400ULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x00000018ff597819ULL, 0x000fe4000001143fULL, 0x000088803f5f7816ULL, 0x000fc400000000ffULL,
0x00000018ff527819ULL, 0x000fe20000011439ULL, 0x0000003d00647306ULL, 0x0009e20000202400ULL,
0x000001003f3c7824ULL, 0x002fe200078e00ffULL, 0x0000888039557816ULL, 0x000fe200000000ffULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5a7819ULL, 0x000fe4000001143eULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000005e005e7306ULL, 0x000fe20000202400ULL,
0x00000100383d7824ULL, 0x050fe200078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x0001000038387824ULL, 0x000fe200078e00ffULL, 0x000088803e5d7816ULL, 0x000fc400000000ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000005300657306ULL, 0x0003e20000202400ULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x00000018ff4d7819ULL, 0x000fe4000001143aULL,
0x00000018ff507819ULL, 0x000fc6000001143bULL, 0x0000006200627306ULL, 0x000fe20000202400ULL,
0x000001003e537824ULL, 0x042fe400078e00ffULL, 0x000100003e3e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff537819ULL, 0x000fe40000011453ULL, 0x0000005400677306ULL, 0x000e620000202400ULL,
0x00000018ff3e7819ULL, 0x000fce000001143eULL, 0x0000003c00687306ULL, 0x0009f00000202400ULL,
0x0000003800547306ULL, 0x000be20000202400ULL, 0x00000100393c7824ULL, 0x050fe400078e00ffULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff587819ULL, 0x000fe4000001143cULL,
0x0000005b005b7306ULL, 0x000f220000202400ULL, 0x000001003b387824ULL, 0x028fe200078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x000088803a3c7816ULL, 0x000fe400000000ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000005300607306ULL, 0x000ff00000202400ULL,
0x0000003f00667306ULL, 0x000ff00000202400ULL, 0x0000003900537306ULL, 0x0003f00000202400ULL,
0x00000038003f7306ULL, 0x0007e20000202400ULL, 0x0000541062397816ULL, 0x002fce0000000067ULL,
0x0000005d005d7306ULL, 0x000e620000202400ULL, 0x000054105e387816ULL, 0x008fce0000000065ULL,
0x0000005f005f7306ULL, 0x000ee20000202400ULL, 0x000000383010723cULL, 0x000fee0000041810ULL,
0x0000003e00637306ULL, 0x000be20000202400ULL, 0x0000541061387816ULL, 0x000fe4000000005cULL,
0x0000541064397816ULL, 0x010fca000000005bULL, 0x0000003d00577306ULL, 0x0009e20000202400ULL,
0x000088803b3e7816ULL, 0x064fe200000000ffULL, 0x000100003b3b7824ULL, 0x000fe200078e00ffULL,
0x000000383014723cULL, 0x000fe80000041814ULL, 0x00000018ff3b7819ULL, 0x000fe2000001143bULL,
0x0000005a005a7306ULL, 0x000ea20000202400ULL, 0x000001003a3d7824ULL, 0x050fe200078e00ffULL,
0x000054105d387816ULL, 0x002fe20000000060ULL, 0x000100003a3a7824ULL, 0x000fe200078e00ffULL,
0x000054105f397816ULL, 0x008fc40000000068ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000005900597306ULL, 0x000e620000202400ULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x000000383018723cULL, 0x000fea0000041818ULL, 0x0000005500557306ULL, 0x000fe40000202400ULL,
0x0000541063387816ULL, 0x004fc4000000005aULL, 0x0000541066397816ULL, 0x002fc80000000059ULL,
0x0000005800587306ULL, 0x000e660000202400ULL, 0x00000038301c723cULL, 0x000fea000004181cULL,
0x0000003c003c7306ULL, 0x000fe40000202400ULL, 0x0000541055397816ULL, 0x002fcc0000000058ULL,
0x0000003d003d7306ULL, 0x000e700000202400ULL, 0x0000005100517306ULL, 0x000ea20000202400ULL,
0x000054103c3c7816ULL, 0x002fce000000003dULL, 0x0000005200527306ULL, 0x000e620000202400ULL,
0x0000541054547816ULL, 0x004fce0000000051ULL, 0x0000004d004d7306ULL, 0x000fe20000202400ULL,
0x0000541053557816ULL, 0x002fce0000000052ULL, 0x0000005000507306ULL, 0x000fe20000202400ULL,
0x000000543024723cULL, 0x000fee0000041824ULL, 0x0000005600567306ULL, 0x000e700000202400ULL,
0x0000003e003e7306ULL, 0x000ea20000202400ULL, 0x0000541056387816ULL, 0x002fce0000000057ULL,
0x0000003a003a7306ULL, 0x000e620000202400ULL, 0x000000383020723cULL, 0x000fe20000041820ULL,
0x000054103e3d7816ULL, 0x004fcc000000003fULL, 0x0000003b003b7306ULL, 0x000ea20000202400ULL,
0x0000003c3028723cULL, 0x000fe20000041828ULL, 0x000054103a3a7816ULL, 0x002fe4000000004dULL,
0x000054103b3b7816ULL, 0x004fce0000000050ULL, 0x0000003a302c723cULL, 0x000fe2000004182cULL,
0x013000003730783bULL, 0x0002a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000102947ULL, 0x000fde0003800000ULL, 0x0000000d30307232ULL, 0x084fe40000200000ULL,
0x0000000d32327232ULL, 0x000fe40000200000ULL, 0x0000000e31317232ULL, 0x080fe40000200000ULL,
0x0000000e33337232ULL, 0x000fce0000200000ULL, 0x00000000413c783bULL, 0x000ee20000004200ULL,
0x00000080070a7890ULL, 0x000fc6000fffe03fULL, 0x000000004038783bULL, 0x000f260000004200ULL,
0x0000000a0f007c0cULL, 0x000fe4000bf03070ULL, 0x00000018ff5c7819ULL, 0x008fe2000001143cULL,
0x000001003c537824ULL, 0x040fe200078e00ffULL, 0x000088803c577816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5b7819ULL, 0x000fe2000001143dULL,
0x000001003d547824ULL, 0x000fe200078e00ffULL, 0x00000018ff537819ULL, 0x000fe20000011453ULL,
0x0000005c005c7306ULL, 0x000fe20000202400ULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x000001003b677824ULL, 0x010fe200078e00ffULL, 0x000088803d607816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fc40000011454ULL,
0x00000018ff597819ULL, 0x000fe2000001143fULL, 0x0000005300627306ULL, 0x0007e20000202400ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x000088803f5f7816ULL, 0x000fe400000000ffULL,
0x00000018ff517819ULL, 0x000fe40000011438ULL, 0x00000018ff527819ULL, 0x000fe20000011439ULL,
0x0000003c00637306ULL, 0x0009e20000202400ULL, 0x000001003e537824ULL, 0x008fe200078e00ffULL,
0x0000888038557816ULL, 0x000fc400000000ffULL, 0x000088803e5d7816ULL, 0x040fe400000000ffULL,
0x00000018ff537819ULL, 0x000fe40000011453ULL, 0x0000005700577306ULL, 0x000ee20000202400ULL,
0x000001003f3c7824ULL, 0x050fe200078e00ffULL, 0x00000018ff5a7819ULL, 0x000fe2000001143eULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe2000001143aULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fc4000001143cULL,
0x0000006000607306ULL, 0x000fe20000202400ULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x00000018ff507819ULL, 0x000fc6000001143bULL,
0x0000005400657306ULL, 0x000f300000202400ULL, 0x0000003d00667306ULL, 0x000bf00000202400ULL,
0x00000053005e7306ULL, 0x0007e20000202400ULL, 0x00000100383d7824ULL, 0x022fc400078e00ffULL,
0x0001000038387824ULL, 0x000fc600078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000003c00687306ULL, 0x0003e20000202400ULL, 0x0000888039537816ULL, 0x00cfe400000000ffULL,
0x00000018ff387819ULL, 0x000fca0000011438ULL, 0x0000005b005b7306ULL, 0x000ea20000202400ULL,
0x00000100393c7824ULL, 0x042fe400078e00ffULL, 0x0001000039397824ULL, 0x000fc600078e00ffULL,
0x00000018ff587819ULL, 0x000fe4000001143cULL, 0x00000018ff397819ULL, 0x000fe20000011439ULL,
0x0000003f00647306ULL, 0x000fe20000202400ULL, 0x000088803a3c7816ULL, 0x000fce00000000ffULL,
0x0000003800547306ULL, 0x0003f00000202400ULL, 0x00000039003f7306ULL, 0x0009e20000202400ULL,
0x0000541057387816ULL, 0x002fe40000000062ULL, 0x00000018ff577819ULL, 0x000fca0000011467ULL,
0x0000005d005d7306ULL, 0x000e620000202400ULL, 0x0000541060397816ULL, 0x010fce0000000065ULL,
0x0000005f005f7306ULL, 0x000ee20000202400ULL, 0x000000383010723cULL, 0x000fee0000041810ULL,
0x0000003e00617306ULL, 0x0009e20000202400ULL, 0x0000541063387816ULL, 0x000fe4000000005cULL,
0x0000541066397816ULL, 0x004fca000000005bULL, 0x0000003d00567306ULL, 0x0005e20000202400ULL,
0x000088803b3e7816ULL, 0x050fe200000000ffULL, 0x000100003b3b7824ULL, 0x000fe200078e00ffULL,
0x000000383014723cULL, 0x000fe80000041814ULL, 0x00000018ff3b7819ULL, 0x000fe2000001143bULL,
0x0000005a005a7306ULL, 0x000f220000202400ULL, 0x000001003a3d7824ULL, 0x044fe200078e00ffULL,
0x000054105d387816ULL, 0x002fe2000000005eULL, 0x000100003a3a7824ULL, 0x000fe200078e00ffULL,
0x000054105f397816ULL, 0x008fc40000000068ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000005900597306ULL, 0x000e620000202400ULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x000000383018723cULL, 0x000fea0000041818ULL, 0x0000005500557306ULL, 0x000ea40000202400ULL,
0x0000541061387816ULL, 0x010fc4000000005aULL, 0x0000541064397816ULL, 0x002fc80000000059ULL,
0x0000005300537306ULL, 0x000fe60000202400ULL, 0x00000038301c723cULL, 0x000fea000004181cULL,
0x0000005800587306ULL, 0x000e640000202400ULL, 0x0000541055387816ULL, 0x004fe20000000056ULL,
0x00000001ff567424ULL, 0x000fca00078e00ffULL, 0x0000003c003c7306ULL, 0x000fe20000202400ULL,
0x0000541053397816ULL, 0x002fce0000000058ULL, 0x0000003d003d7306ULL, 0x000e620000202400ULL,
0x000000383020723cULL, 0x000fee0000041820ULL, 0x0000005100517306ULL, 0x000ea20000202400ULL,
0x0186b856073879a7ULL, 0x0006e2000850003fULL, 0x000054103c3c7816ULL, 0x002fcc000000003dULL,
0x0000005200527306ULL, 0x000e620000202400ULL, 0x0186985607ff79a7ULL, 0x0007e2000850003fULL,
0x0000541054547816ULL, 0x004fcc0000000051ULL, 0x0000004d004d7306ULL, 0x000fe20000202400ULL,
0x000054103f557816ULL, 0x002fce0000000052ULL, 0x0000005000507306ULL, 0x000fe20000202400ULL,
0x000000543024723cULL, 0x000fee0000041824ULL, 0x0000003e003e7306ULL, 0x000ff00000202400ULL,
0x0000005700577306ULL, 0x000e700000202400ULL, 0x0000003a003a7306ULL, 0x000ea20000202400ULL,
0x000054103e3d7816ULL, 0x002fce0000000057ULL, 0x0000003b003b7306ULL, 0x000e620000202400ULL,
0x0000003c3028723cULL, 0x000fe20000041828ULL, 0x000054103a3a7816ULL, 0x004fe2000000004dULL,
0x000000010b4d7836ULL, 0x000fe20000000000ULL, 0x000054103b3b7816ULL, 0x002fce0000000050ULL,
0x0000003a302c723cULL, 0x000fe2000004182cULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000003c00040947ULL, 0x008fde0003800000ULL, 0x0000000000307805ULL, 0x000fe20000015200ULL,
0x0186b839070075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff387224ULL, 0x000fce00078e00ffULL, 0x000000103800780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fcc0000015200ULL,
0x00000032303b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff027819ULL, 0x000fc80000011433ULL, 0x0000003b02027211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000202027819ULL, 0x000fc80000001233ULL,
0x000000020000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000138387836ULL, 0x000fce0000000000ULL, 0x0186b839070075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000400209947ULL, 0x000fea0003800000ULL,
0x0000000104027824ULL, 0x000fe200078e0235ULL, 0x000000a0070a7890ULL, 0x000fe2000fffe03fULL,
0x0000000235397836ULL, 0x000fe20000000000ULL, 0x0000006008317811ULL, 0x000fe200078e38ffULL,
0x0000000435517836ULL, 0x000fe20000000000ULL, 0x00008a00000c7ab9ULL, 0x000fe20000000a00ULL,
0x0000000102307824ULL, 0x000fe200078e0209ULL, 0x000000f0363e7812ULL, 0x000fe200078ec0ffULL,
0x0000001002337824ULL, 0x000fe400078e00ffULL, 0x0000000104327824ULL, 0x000fc400078e0239ULL,
0x0000000104387824ULL, 0x000fe200078e0251ULL, 0xfffffff033337812ULL, 0x000fe200078ee230ULL,
0x0000000132307824ULL, 0x140fe400078e0209ULL, 0x00000010324d7824ULL, 0x000fe400078e00ffULL,
0x00000001383a7824ULL, 0x040fe400078e0209ULL, 0x0000001038537824ULL, 0x000fe200078e00ffULL,
0xfffffff04d4d7812ULL, 0x000fe200078ee230ULL, 0x0000000635557836ULL, 0x000fc40000000000ULL,
0x0000000102307824ULL, 0x000fe200078e0231ULL, 0xfffffff053537812ULL, 0x000fe200078ee23aULL,
0x00000001043a7824ULL, 0x000fe200078e0255ULL, 0x0000000a0f027c48ULL, 0x000fe2000ffe0000ULL,
0x00000001323c7824ULL, 0x100fe200078e0231ULL, 0x0000004f303d7210ULL, 0x000fe20007f3e0ffULL,
0x0000000138387824ULL, 0x100fe400078e0231ULL, 0x000000013a327824ULL, 0x040fe200078e0231ULL,
0x0000004f3c3c7210ULL, 0x000fe20007f5e0ffULL, 0x8000000a02317c36ULL, 0x000fe20008000000ULL,
0x0000004f383b7210ULL, 0x000fe20007f7e0ffULL, 0x000000013a387824ULL, 0x040fe200078e0209ULL,
0x0000004f324f7210ULL, 0x000fe20007f1e0ffULL, 0x000000103a577824ULL, 0x000fe200078e00ffULL,
0x0000003104317248ULL, 0x000fe20007fe0000ULL, 0x000000ffff027224ULL, 0x000fe200008e06ffULL,
0x0000000c3d307c11ULL, 0x040fe2000f8240ffULL, 0x0001600007327836ULL, 0x000fe20000000000ULL,
0xfffffff057577812ULL, 0x000fe200078ee238ULL, 0x000000ffff387224ULL, 0x000fe200000e06ffULL,
0x0000000d3d3d7c11ULL, 0x000fe200088f4402ULL, 0x0000000131027824ULL, 0x000fe200078e0a04ULL,
0x0000003e30307210ULL, 0x000fe20007f9e0ffULL, 0x00000010333f7824ULL, 0x000fc400078e0232ULL,
0x000000104d4d7824ULL, 0x100fe200078e0232ULL, 0x000000023900720cULL, 0x080fe20003f26070ULL,
0x000000ffff317224ULL, 0x000fe200010e06ffULL, 0x0000000c3c337c11ULL, 0x040fe2000f8440ffULL,
0x0000001053537824ULL, 0x100fe200078e0232ULL, 0x0000000c3b397c11ULL, 0x000fe2000f8a40ffULL,
0x0000001057577824ULL, 0x000fe200078e0232ULL, 0x0000000d3c3c7c11ULL, 0x000fe200090f4431ULL,
0x000000ffff327224ULL, 0x000fe200018e06ffULL, 0x000000023500720cULL, 0x080fe20003f66070ULL,
0x000000ffff317224ULL, 0x000fe200020e063dULL, 0x000000025100720cULL, 0x000fc40003f46070ULL,
0x0000000d3b3b7c11ULL, 0x000fe4000a8f4432ULL, 0x0000000c4f3a7c11ULL, 0x000fe4000f8a40ffULL,
0x0000003e33327210ULL, 0x000fe40007f9e0ffULL, 0x000000025500720cULL, 0x000fe40003f06070ULL,
0x0000000d4f027c11ULL, 0x000fe2000a8f4438ULL, 0x000000ffff337224ULL, 0x000fe200020e063cULL,
0x0000003e39387210ULL, 0x000fe20007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000303f7faeULL, 0x0003e2000d901c48ULL, 0x0000003e3a3a7210ULL, 0x000fc60007f9e0ffULL,
0x000000ffff397224ULL, 0x000fe200028e063bULL, 0x00000000324d7faeULL, 0x0003e2000c901c48ULL,
0x000000ffff3b7224ULL, 0x000fc600020e0602ULL, 0x0000000038537faeULL, 0x0003e8000d101c48ULL,
0x000000003a577faeULL, 0x0003e2000c101c48ULL, 0x0000000000ec7947ULL, 0x000fea0003800000ULL,
0x0000000104027824ULL, 0x000fe200078e0235ULL, 0x0000006008317811ULL, 0x000fe200078e38ffULL,
0x00008a00000a7ab9ULL, 0x000fe20000000a00ULL, 0x000000f0363e7812ULL, 0x000fe200078ec0ffULL,
0x0000000102307824ULL, 0x140fe400078e0209ULL, 0x00000010023b7824ULL, 0x000fe400078e00ffULL,
0x0000000202327836ULL, 0x000fe40000000000ULL, 0x00000006023a7836ULL, 0x000fe20000000000ULL,
0xfffffff03b3b7812ULL, 0x000fe200078ee230ULL, 0x0000000132337824ULL, 0x000fc400078e0209ULL,
0x0000001032387824ULL, 0x000fe400078e00ffULL, 0x0000000402307836ULL, 0x000fe40000000000ULL,
0x0000000102027824ULL, 0x100fe200078e0231ULL, 0xfffffff0384d7812ULL, 0x000fe200078ee233ULL,
0x00000001323c7824ULL, 0x100fe400078e0231ULL, 0x0000000130327824ULL, 0x100fe400078e0231ULL,
0x000000013a387824ULL, 0x040fe200078e0231ULL, 0x0000004f02317210ULL, 0x000fe20007f7e0ffULL,
0x000000013a3d7824ULL, 0x140fe200078e0209ULL, 0x0000004f32397210ULL, 0x000fe20007f5e0ffULL,
0x000000103a3a7824ULL, 0x000fe200078e00ffULL, 0x0000004f3c3c7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff327224ULL, 0x000fe200018e06ffULL, 0x0000004f38027210ULL, 0x000fe20007f1e0ffULL,
0x0000000130387824ULL, 0x040fe200078e0209ULL, 0x0000000a31337c11ULL, 0x040fe2000f8640ffULL,
0x00000010304f7824ULL, 0x000fe200078e00ffULL, 0xfffffff03a517812ULL, 0x000fe200078ee23dULL,
0x0001600007307836ULL, 0x000fe20000000000ULL, 0x0000000b313d7c11ULL, 0x000fe200098f4432ULL,
0x000000ffff317224ULL, 0x000fe200008e06ffULL, 0xfffffff04f4f7812ULL, 0x000fe200078ee238ULL,
0x000000103b3f7824ULL, 0x100fe200078e0230ULL, 0x0000000a3c3b7c11ULL, 0x000fe2000f8240ffULL,
0x000000104d4d7824ULL, 0x000fc400078e0230ULL, 0x000000104f4f7824ULL, 0x100fe200078e0230ULL,
0x0000000b3c3c7c11ULL, 0x000fe200088f4431ULL, 0x0000001051517824ULL, 0x000fe200078e0230ULL,
0x0000000a39387c11ULL, 0x040fe2000f8240ffULL, 0x000000ffff327224ULL, 0x000fe200010e06ffULL,
0x0000003e33307210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff337224ULL, 0x000fe200000e06ffULL,
0x0000000a023a7c11ULL, 0x000fe4000f8440ffULL, 0x0000000b39397c11ULL, 0x000fe200088f4432ULL,
0x000000ffff317224ULL, 0x000fe200018e063dULL, 0x0000003e3b327210ULL, 0x000fc40007f1e0ffULL,
0x0000000b02027c11ULL, 0x000fe400090f4433ULL, 0x0000003e38387210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff337224ULL, 0x000fe200000e063cULL, 0x0000003e3a3a7210ULL, 0x000fe20007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000303f7faeULL, 0x0003e4000b901c48ULL,
0x000000ffff397224ULL, 0x000fe400008e0639ULL, 0x000000ffff3b7224ULL, 0x000fe200010e0602ULL,
0x00000000324d7faeULL, 0x0003e8000b901c48ULL, 0x00000000384f7faeULL, 0x0003e8000b901c48ULL,
0x000000003a517faeULL, 0x0003e4000b901c48ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x000000020b337836ULL, 0x000fe40000000000ULL, 0x00000001ff387424ULL, 0x000fe400078e00ffULL,
0xffffffffff027424ULL, 0x000fe200078e00ffULL, 0x000000063300720cULL, 0x000fda0003f06070ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x00008c00ff307b82ULL, 0x000e620000000a00ULL,
0x000000010a337824ULL, 0x000fc800078e0233ULL, 0x0000000433307825ULL, 0x002fca00078e0030ULL,
0x0000000830027981ULL, 0x000324000c1e1900ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a46ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0186b038075079a7ULL, 0x0004e4000850003fULL,
0x01866838033879a7ULL, 0x004464000850003fULL, 0x0000000000307805ULL, 0x002fce0000015200ULL,
0x01866839030075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff3a7224ULL, 0x000fce00078e00ffULL, 0x000000103a00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fce0000015200ULL,
0x00000032303b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000003b32327211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013a3a7836ULL, 0x000fce0000000000ULL, 0x01866839030075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x018180004b317984ULL, 0x000e620000000800ULL,
0x00000001ff387424ULL, 0x000fc600078e00ffULL, 0x018380004b337984ULL, 0x000b620000000800ULL,
0x0000004e3100720bULL, 0x002fda0003f1d000ULL, 0x0000000000397806ULL, 0x000fc800000e0100ULL,
0x0000ffff39ff7812ULL, 0x000fda000780c0ffULL, 0x0000000000f48947ULL, 0x02cfea0003800000ULL,
0x000000033400780cULL, 0x000fe40003f25270ULL, 0x0000004e3100720bULL, 0x000fd60003f14000ULL,
0x0000004e31309209ULL, 0x000fe40007810000ULL, 0x0000000000387806ULL, 0x000fc600000e0100ULL,
0x018580304b009388ULL, 0x0003e20000000800ULL, 0x0000991038327816ULL, 0x000fc800000000ffULL,
0x000000ff3200720cULL, 0x000fda0003f05270ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x0000004e313b7209ULL, 0x000fe40007810000ULL, 0x000000ff38ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0038ff7812ULL, 0x000fe2000782c0ffULL, 0x0000004e3b307221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b30307820ULL, 0x000fc80000410000ULL, 0x00000030003b7308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff307819ULL, 0x002fcc0000011609ULL,
0x00001f303b307589ULL, 0x004e6400000e0000ULL, 0x0000003010107220ULL, 0x082fe20000410000ULL,
0x0000003011117220ULL, 0x080fe20000410000ULL, 0x0000003014147220ULL, 0x080fe20000410000ULL,
0x0000003015157220ULL, 0x080fe20000410000ULL, 0x0000003018187220ULL, 0x080fe20000410000ULL,
0x0000003019197220ULL, 0x080fe20000410000ULL, 0x000000301c1c7220ULL, 0x080fe20000410000ULL,
0x000000301d1d7220ULL, 0x080fe20000410000ULL, 0x0000003020207220ULL, 0x080fe20000410000ULL,
0x0000003021217220ULL, 0x080fe20000410000ULL, 0x0000003024247220ULL, 0x080fe20000410000ULL,
0x0000003025257220ULL, 0x080fe20000410000ULL, 0x0000003028287220ULL, 0x080fe20000410000ULL,
0x0000003029297220ULL, 0x080fe20000410000ULL, 0x000000302c2c7220ULL, 0x080fe20000410000ULL,
0x000000302d2d7220ULL, 0x000fce0000410000ULL, 0x0000003b00007220ULL, 0x004fe20000410000ULL,
0x0000000000489947ULL, 0x000fec0003800000ULL, 0x0000000809307811ULL, 0x002fcc00078ff0ffULL,
0x00001f303b307589ULL, 0x000e6400000e0000ULL, 0x0000003012127220ULL, 0x082fe20000410000ULL,
0x0000003013137220ULL, 0x080fe20000410000ULL, 0x0000003016167220ULL, 0x080fe20000410000ULL,
0x0000003017177220ULL, 0x080fe20000410000ULL, 0x000000301a1a7220ULL, 0x080fe20000410000ULL,
0x000000301b1b7220ULL, 0x080fe20000410000ULL, 0x000000301e1e7220ULL, 0x080fe20000410000ULL,
0x000000301f1f7220ULL, 0x080fe20000410000ULL, 0x0000003022227220ULL, 0x080fe20000410000ULL,
0x0000003023237220ULL, 0x080fe20000410000ULL, 0x0000003026267220ULL, 0x080fe20000410000ULL,
0x0000003027277220ULL, 0x080fe20000410000ULL, 0x000000302a2a7220ULL, 0x080fe20000410000ULL,
0x000000302b2b7220ULL, 0x080fe20000410000ULL, 0x000000302e2e7220ULL, 0x080fe20000410000ULL,
0x000000302f2f7220ULL, 0x000fce0000410000ULL, 0x0000ffff38ff7812ULL, 0x000fe20007800839ULL,
0x00000001ff387424ULL, 0x000fe200078e00ffULL, 0x0000004e314e7209ULL, 0x000fd60007810000ULL,
0x8000004e31310221ULL, 0x000fe20000010000ULL, 0x00007610ff380816ULL, 0x000fc60000000038ULL,
0x3fb8aa3b31310820ULL, 0x000fc80000410000ULL, 0x00000031000c0308ULL, 0x000ea40000000800ULL,
0x0000000c33330220ULL, 0x004fce0000410000ULL, 0x0000000033007221ULL, 0x000fce0000010000ULL,
0x0000000000307805ULL, 0x002fce0000015200ULL, 0x0186a84c070075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff3a7224ULL, 0x000fce00078e00ffULL,
0x000000103a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x000fce0000015200ULL, 0x0000003230397210ULL, 0x000fca0007f1e1ffULL,
0x0000000133337824ULL, 0x000fe200000e0e31ULL, 0x003d09003900780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403900780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff327819ULL, 0x000fc80000011433ULL,
0x0000003932327211ULL, 0x000fca00078110ffULL, 0x000000ffff337224ULL, 0x000fca00000e0633ULL,
0x0000000232327819ULL, 0x000fc80000001233ULL, 0x000000320000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013a3a7836ULL, 0x000fce0000000000ULL,
0x0186a84c070075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000991038307816ULL, 0x000fc800000000ffULL, 0x000000ff3000720cULL, 0x000fda0003f25270ULL,
0x0000000000181947ULL, 0x000fea0003800000ULL, 0x00000002ff317819ULL, 0x000fe40000011609ULL,
0x0000000cff0d723eULL, 0x000fc600000010ffULL, 0x0000000831337836ULL, 0x000fe20000000000ULL,
0x000054100d307816ULL, 0x000fca000000000dULL, 0x00001f31300d7589ULL, 0x0002a800000e0000ULL,
0x00001f33300e7589ULL, 0x0002e400000e0000ULL, 0x013800004a30783bULL, 0x0022e20000000200ULL,
0x0000000000101947ULL, 0x000fea0003800000ULL, 0x0000000d30307232ULL, 0x08cfe40000200000ULL,
0x0000000d32327232ULL, 0x000fe40000200000ULL, 0x0000000e31317232ULL, 0x080fe40000200000ULL,
0x0000000e33337232ULL, 0x000fce0000200000ULL, 0x00000000493c783bULL, 0x000f680000004200ULL,
0x000000004838783bULL, 0x000f640000004200ULL, 0x00000018ff547819ULL, 0x022fe2000001143dULL,
0x000001003d4d7824ULL, 0x040fe200078e00ffULL, 0x000088803d5e7816ULL, 0x040fe200000000ffULL,
0x000001003c4c7824ULL, 0x040fe200078e00ffULL, 0x00000018ff537819ULL, 0x000fe2000001143cULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x000088803c577816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4a7819ULL, 0x008fe20000011438ULL,
0x0000005e005e7306ULL, 0x000fe20000202400ULL, 0x00000018ff3d7819ULL, 0x000fc4000001143dULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000888038567816ULL, 0x000fe400000000ffULL,
0x00000018ff4c7819ULL, 0x000fe2000001144cULL, 0x0000003d00617306ULL, 0x0003e20000202400ULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x00000018ff4f7819ULL, 0x000fe4000001143fULL,
0x000088803f597816ULL, 0x000fc400000000ffULL, 0x00000018ff4b7819ULL, 0x000fe20000011439ULL,
0x0000003c005c7306ULL, 0x0007e20000202400ULL, 0x00000100383d7824ULL, 0x042fe200078e00ffULL,
0x0000888039587816ULL, 0x000fe200000000ffULL, 0x0001000038387824ULL, 0x000fe200078e00ffULL,
0x00000018ff527819ULL, 0x000fe4000001143eULL, 0x000088803e557816ULL, 0x000fe400000000ffULL,
0x0000005700577306ULL, 0x000fe20000202400ULL, 0x000001003f3c7824ULL, 0x048fe200078e00ffULL,
0x00000018ff387819ULL, 0x000fe20000011438ULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3d7819ULL, 0x000fc4000001143dULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000004c00607306ULL, 0x0002e20000202400ULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x00000018ff487819ULL, 0x000fe4000001143aULL, 0x00000018ff497819ULL, 0x000fc6000001143bULL,
0x0000004d00637306ULL, 0x000f620000202400ULL, 0x000001003e4c7824ULL, 0x042fe400078e00ffULL,
0x000100003e3e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe4000001144cULL,
0x0000003c00647306ULL, 0x0003e20000202400ULL, 0x00000018ff3e7819ULL, 0x000fce000001143eULL,
0x00000038004d7306ULL, 0x0007e20000202400ULL, 0x00000100393c7824ULL, 0x042fe400078e00ffULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff5d7819ULL, 0x000fe4000001143cULL,
0x0000005300537306ULL, 0x000e620000202400ULL, 0x000001003b387824ULL, 0x00cfe200078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x000088803a3c7816ULL, 0x040fe400000000ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000005400547306ULL, 0x000eb00000202400ULL,
0x0000003d005b7306ULL, 0x0007f00000202400ULL, 0x0000003f00627306ULL, 0x000fe20000202400ULL,
0x000001003a3d7824ULL, 0x008fc400078e00ffULL, 0x000100003a3a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000004c005a7306ULL, 0x000fe20000202400ULL,
0x00000018ff3a7819ULL, 0x000fce000001143aULL, 0x00000038003f7306ULL, 0x0007f00000202400ULL,
0x00000039004c7306ULL, 0x000be20000202400ULL, 0x0000541057387816ULL, 0x008fe20000000060ULL,
0x000100003b577824ULL, 0x000fca00078e00ffULL, 0x00000018ff577819ULL, 0x000fe20000011457ULL,
0x0000005500557306ULL, 0x000ee20000202400ULL, 0x000054105e397816ULL, 0x020fce0000000063ULL,
0x0000005900597306ULL, 0x000f620000202400ULL, 0x000000383010723cULL, 0x000fee0000041810ULL,
0x0000003e005f7306ULL, 0x0007e20000202400ULL, 0x000054105c387816ULL, 0x002fe40000000053ULL,
0x0000541061397816ULL, 0x004fca0000000054ULL, 0x0000003c003c7306ULL, 0x000fe20000202400ULL,
0x000088803b3e7816ULL, 0x008fe200000000ffULL, 0x000000383014723cULL, 0x000fec0000041814ULL,
0x0000003d003d7306ULL, 0x000e620000202400ULL, 0x0000541055387816ULL, 0x000fe4000000005aULL,
0x0000541059397816ULL, 0x020fca0000000064ULL, 0x0000005200527306ULL, 0x000ea40000202400ULL,
0x000000383018723cULL, 0x000fe20000041818ULL, 0x000054103c3c7816ULL, 0x002fca000000003dULL,
0x0000004f004f7306ULL, 0x000e620000202400ULL, 0x000054105f387816ULL, 0x004fce0000000052ULL,
0x0000004a004a7306ULL, 0x000ea20000202400ULL, 0x0000541062397816ULL, 0x002fce000000004fULL,
0x0000004b004b7306ULL, 0x000e620000202400ULL, 0x00000038301c723cULL, 0x000fe2000004181cULL,
0x000054104d4a7816ULL, 0x004fcc000000004aULL, 0x0000004800487306ULL, 0x000fe20000202400ULL,
0x000054104c4b7816ULL, 0x002fce000000004bULL, 0x0000004900497306ULL, 0x000fe20000202400ULL,
0x0000004a3024723cULL, 0x000fee0000041824ULL, 0x0000005600567306ULL, 0x000e700000202400ULL,
0x0000005800587306ULL, 0x000fe20000202400ULL, 0x0000541056567816ULL, 0x002fce000000005bULL,
0x0000005d005d7306ULL, 0x000ff00000202400ULL, 0x0000003e003e7306ULL, 0x000e700000202400ULL,
0x0000003a003b7306ULL, 0x000ea20000202400ULL, 0x000054103e3d7816ULL, 0x002fce000000003fULL,
0x0000005700547306ULL, 0x0002e20000202400ULL, 0x0000003c3028723cULL, 0x000fe20000041828ULL,
0x000054103b487816ULL, 0x004fe40000000048ULL, 0x0000541058577816ULL, 0x002fe4000000005dULL,
0x0000541054497816ULL, 0x008fca0000000049ULL, 0x000000563020723cULL, 0x000fec0000041820ULL,
0x00000048302c723cULL, 0x000fe2000004182cULL, 0x013800004630783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000101947ULL, 0x000fde0003800000ULL,
0x0000000d30307232ULL, 0x084fe40000200000ULL, 0x0000000d32327232ULL, 0x000fe40000200000ULL,
0x0000000e31317232ULL, 0x080fe40000200000ULL, 0x0000000e33337232ULL, 0x000fce0000200000ULL,
0x00000000453c783bULL, 0x000ee80000004200ULL, 0x000000004438783bULL, 0x000f620000004200ULL,
0x00000018ff4b7819ULL, 0x008fe2000001143cULL, 0x000001003c4d7824ULL, 0x040fe200078e00ffULL,
0x00000018ff4c7819ULL, 0x000fe2000001143dULL, 0x000001003d4f7824ULL, 0x040fe200078e00ffULL,
0x000088803c547816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x000088803d5b7816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe2000001144dULL, 0x0000004b004b7306ULL, 0x000fe20000202400ULL,
0x00000018ff3c7819ULL, 0x000fc4000001143cULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff467819ULL, 0x022fe40000011438ULL, 0x0000888038537816ULL, 0x000fe200000000ffULL,
0x0000004d005d7306ULL, 0x0003e20000202400ULL, 0x00000018ff4f7819ULL, 0x000fe4000001144fULL,
0x00000018ff497819ULL, 0x000fe4000001143fULL, 0x000088803f557816ULL, 0x000fc400000000ffULL,
0x00000018ff487819ULL, 0x000fe20000011439ULL, 0x0000003c005a7306ULL, 0x0007e20000202400ULL,
0x000001003e4d7824ULL, 0x042fe200078e00ffULL, 0x0000888039587816ULL, 0x000fe400000000ffULL,
0x00000018ff4a7819ULL, 0x000fe4000001143eULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x0000003d005f7306ULL, 0x0003e20000202400ULL, 0x000001003f3c7824ULL, 0x048fe200078e00ffULL,
0x000088803e527816ULL, 0x040fe200000000ffULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff447819ULL, 0x000fe2000001143aULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fc4000001143cULL, 0x0000005400547306ULL, 0x000fe20000202400ULL,
0x00000100383d7824ULL, 0x042fe200078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x0001000038387824ULL, 0x000fe200078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000005b005b7306ULL, 0x000fe20000202400ULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x00000018ff457819ULL, 0x000fca000001143bULL,
0x0000004f00607306ULL, 0x000e700000202400ULL, 0x0000004d00577306ULL, 0x000ff00000202400ULL,
0x0000003c005e7306ULL, 0x0007f00000202400ULL, 0x00000038004d7306ULL, 0x000be20000202400ULL,
0x00000100393c7824ULL, 0x008fc400078e00ffULL, 0x0001000039397824ULL, 0x000fc600078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000004c004c7306ULL, 0x000ee20000202400ULL,
0x000001003b387824ULL, 0x024fe200078e00ffULL, 0x00000018ff397819ULL, 0x000fc80000011439ULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000003f005c7306ULL, 0x000ff00000202400ULL,
0x00000039004f7306ULL, 0x0003f00000202400ULL, 0x00000038003f7306ULL, 0x0005e20000202400ULL,
0x000054105b397816ULL, 0x002fce0000000060ULL, 0x0000005200527306ULL, 0x000e620000202400ULL,
0x0000541054387816ULL, 0x004fe2000000005dULL, 0x000100003b547824ULL, 0x000fca00078e00ffULL,
0x00000018ff547819ULL, 0x000fe20000011454ULL, 0x0000005500557306ULL, 0x000ea20000202400ULL,
0x000000383010723cULL, 0x000fee0000041810ULL, 0x0000003e00597306ULL, 0x000be20000202400ULL,
0x000054105a387816ULL, 0x000fc4000000004bULL, 0x000054105f397816ULL, 0x008fca000000004cULL,
0x0000003d00567306ULL, 0x0007e20000202400ULL, 0x000001003a3e7824ULL, 0x060fe200078e00ffULL,
0x000000383014723cULL, 0x000fe80000041814ULL, 0x00000018ff627819ULL, 0x000fe4000001143eULL,
0x0000004600467306ULL, 0x000f620000202400ULL, 0x000088803a3d7816ULL, 0x048fe200000000ffULL,
0x000100003a3a7824ULL, 0x000fe200078e00ffULL, 0x000088803b3e7816ULL, 0x000fc400000000ffULL,
0x0000541052387816ULL, 0x002fe40000000057ULL, 0x00000018ff3a7819ULL, 0x000fe2000001143aULL,
0x0000004800487306ULL, 0x000e620000202400ULL, 0x0000541055397816ULL, 0x004fce000000005eULL,
0x0000003c00617306ULL, 0x000fe20000202400ULL, 0x000000383018723cULL, 0x000fee0000041818ULL,
0x0000003d003d7306ULL, 0x000fe20000202400ULL, 0x000054104d387816ULL, 0x020fe40000000046ULL,
0x000054104f397816ULL, 0x002fca0000000048ULL, 0x00000062003c7306ULL, 0x000e640000202400ULL,
0x000000383024723cULL, 0x000fec0000041824ULL, 0x0000004a004a7306ULL, 0x000ea20000202400ULL,
0x00000001ff387424ULL, 0x000fe200078e00ffULL, 0x000054103d3c7816ULL, 0x002fcc000000003cULL,
0x0000004900497306ULL, 0x000e620000202400ULL, 0x0186b838073879a7ULL, 0x0006e2000850003fULL,
0x00005410594a7816ULL, 0x004fcc000000004aULL, 0x0000004400447306ULL, 0x000fe20000202400ULL,
0x000054105c4b7816ULL, 0x002fce0000000049ULL, 0x0000004500457306ULL, 0x000fe20000202400ULL,
0x0000004a301c723cULL, 0x000fee000004181cULL, 0x0000005300537306ULL, 0x000e700000202400ULL,
0x0000005800587306ULL, 0x000ea20000202400ULL, 0x0000541053567816ULL, 0x002fce0000000056ULL,
0x0000003e003e7306ULL, 0x000e620000202400ULL, 0x0000541058577816ULL, 0x004fce0000000061ULL,
0x0000003a003b7306ULL, 0x000ea20000202400ULL, 0x000000563020723cULL, 0x000fe20000041820ULL,
0x000054103e3d7816ULL, 0x002fcc000000003fULL, 0x0000005400547306ULL, 0x000e620000202400ULL,
0x0000003c3028723cULL, 0x000fe20000041828ULL, 0x000054103b447816ULL, 0x004fe40000000044ULL,
0x0000541054457816ULL, 0x002fce0000000045ULL, 0x00000044302c723cULL, 0x008fde000004182cULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x0000000000307805ULL, 0x000fce0000015200ULL,
0x0186b839070075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff3a7224ULL, 0x000fce00078e00ffULL, 0x000000103a00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fce0000015200ULL,
0x00000032303b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000003b32327211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013a3a7836ULL, 0x000fce0000000000ULL, 0x0186b839070075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000204067890ULL, 0x000fe2000fffe03fULL,
0x00008400000a7ab9ULL, 0x000fe40000000800ULL, 0x0000000a02307c24ULL, 0x010fc6000f8e02ffULL,
0x0000000605007c0cULL, 0x000fe2000bf03070ULL, 0x0000008030397824ULL, 0x000fd800078e00ffULL,
0x00000004001c8947ULL, 0x000fea0003800000ULL, 0x00000002353f7836ULL, 0x000fe20000000000ULL,
0x000000c007067890ULL, 0x000fe2000fffe03fULL, 0x0000000435457836ULL, 0x000fe20000000000ULL,
0x00008a00000a7ab9ULL, 0x000fe20000000a00ULL, 0x0000000104317824ULL, 0x040fe400078e0235ULL,
0x0000000104327824ULL, 0x040fe400078e023fULL, 0x0000000104387824ULL, 0x000fe400078e0245ULL,
0x0000000131307824ULL, 0x000fc400078e0209ULL, 0x00000010313b7824ULL, 0x000fe400078e00ffULL,
0x0000000132337824ULL, 0x140fe400078e0209ULL, 0x0000001032467824ULL, 0x000fe200078e00ffULL,
0xfffffff03b447812ULL, 0x000fe200078ee230ULL, 0x0000000138327824ULL, 0x040fe200078e0209ULL,
0x000000060f307c48ULL, 0x000fe2000ffe0000ULL, 0x00000010383d7824ULL, 0x000fe200078e00ffULL,
0xfffffff046467812ULL, 0x000fe200078ee233ULL, 0x0000000635497836ULL, 0x000fc60000000000ULL,
0xfffffff03d487812ULL, 0x000fe200078ee232ULL, 0x0000008008327824ULL, 0x000fe400078e0231ULL,
0x8000000630317c36ULL, 0x000fe40008000000ULL, 0x0000000232307836ULL, 0x000fe20000000000ULL,
0x00000039323d7210ULL, 0x000fe20007f1e0ffULL, 0x0000000104387824ULL, 0x000fe200078e0249ULL,
0x0000003104317248ULL, 0x000fe20007fe0000ULL, 0x00000004323c7836ULL, 0x000fe20000000000ULL,
0x0000003930337210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff307224ULL, 0x000fe200000e06ffULL,
0x0000000a3d3b7c11ULL, 0x040fe2000f8040ffULL, 0x0000000632327836ULL, 0x000fe20000000000ULL,
0x000000393c3c7210ULL, 0x000fe20007f5e0ffULL, 0x00000001383e7824ULL, 0x040fe200078e0209ULL,
0x0000000b3d3d7c11ULL, 0x000fe200080f4430ULL, 0x00000010384b7824ULL, 0x000fe200078e00ffULL,
0x0000003932397210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff307224ULL, 0x000fe200018e06ffULL,
0x0000000a33327c11ULL, 0x000fe2000f8640ffULL, 0x00000001313a7824ULL, 0x000fe200078e0a04ULL,
0xfffffff04b4a7812ULL, 0x000fe200078ee23eULL, 0x000000ffff317224ULL, 0x000fe200010e06ffULL,
0x000000f0363e7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff367224ULL, 0x000fe200020e06ffULL,
0x0000000a3c387c11ULL, 0x000fc4000f8440ffULL, 0x0000000b33337c11ULL, 0x000fe400098f4430ULL,
0x0000003e32327210ULL, 0x000fe40007fbe0ffULL, 0x0000003e3b307210ULL, 0x000fe40007fde0ffULL,
0x0000003a3500720cULL, 0x080fe20003f06070ULL, 0x000000ffff337224ULL, 0x000fe200028e0633ULL,
0x0000003a3f00720cULL, 0x080fe40003f66070ULL, 0x0000000b3c3c7c11ULL, 0x000fe200090f4431ULL,
0x000000ffff317224ULL, 0x000fe200030e063dULL, 0x0000000a393b7c11ULL, 0x000fe2000f8840ffULL,
0x00014000073d7836ULL, 0x000fe20000000000ULL, 0x0000003a4500720cULL, 0x000fc40003f46070ULL,
0x0000003a4900720cULL, 0x000fe20003fa6070ULL, 0x00000010443f7824ULL, 0x100fe200078e023dULL,
0x0000003e38387210ULL, 0x000fe20007fde0ffULL, 0x0000001046457824ULL, 0x100fe200078e023dULL,
0x0000000b39357c11ULL, 0x000fe2000a0f4436ULL, 0x0000001048497824ULL, 0x100fe200078e023dULL,
0x0000003e3b3a7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff397224ULL, 0x000fe200030e063cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000303f7faeULL, 0x0003e2000c101c48ULL,
0x000000104a3d7824ULL, 0x000fe400078e023dULL, 0x000000ffff3b7224ULL, 0x000fe200020e0635ULL,
0x0000000032457faeULL, 0x0003e8000d901c48ULL, 0x0000000038497faeULL, 0x0003e8000d101c48ULL,
0x000000003a3d7faeULL, 0x0003e2000e901c48ULL, 0x0000000000e87947ULL, 0x000fea0003800000ULL,
0x0000000104357824ULL, 0x000fe200078e0235ULL, 0x00008a0000067ab9ULL, 0x000fe20000000a00ULL,
0x000000f036367812ULL, 0x000fe400078ec0ffULL, 0x0000000235327836ULL, 0x000fe40000000000ULL,
0x0000000435387836ULL, 0x000fe40000000000ULL, 0x0000000132317824ULL, 0x040fe400078e0209ULL,
0x00000010323a7824ULL, 0x000fc400078e00ffULL, 0x0000000138327824ULL, 0x140fe400078e0209ULL,
0x00000010383f7824ULL, 0x000fe200078e00ffULL, 0xfffffff03a3d7812ULL, 0x000fe200078ee231ULL,
0x00000006353c7836ULL, 0x000fe40000000000ULL, 0x0000000135307824ULL, 0x040fe200078e0209ULL,
0xfffffff03f3f7812ULL, 0x000fe200078ee232ULL, 0x0000008008327824ULL, 0x000fe400078e0235ULL,
0x00000010353b7824ULL, 0x000fc400078e00ffULL, 0x0000000232387836ULL, 0x000fe20000000000ULL,
0x0000003932317210ULL, 0x000fe20007f1e0ffULL, 0x00000004323a7836ULL, 0x000fe20000000000ULL,
0xfffffff03b3b7812ULL, 0x000fe200078ee230ULL, 0x00000006323e7836ULL, 0x000fe20000000000ULL,
0x0000003938387210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff327224ULL, 0x000fe200000e06ffULL,
0x0000000631337c11ULL, 0x040fe2000f8440ffULL, 0x000000013c357824ULL, 0x040fe200078e0209ULL,
0x000000393a3a7210ULL, 0x000fe20007f9e0ffULL, 0x000000103c3c7824ULL, 0x000fe200078e00ffULL,
0x0000000731327c11ULL, 0x000fe200090f4432ULL, 0x0001400007307836ULL, 0x000fe20000000000ULL,
0x000000393e3e7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff317224ULL, 0x000fe200018e06ffULL,
0xfffffff03c497812ULL, 0x000fe200078ee235ULL, 0x000000103b357824ULL, 0x100fe200078e0230ULL,
0x0000000638397c11ULL, 0x000fe2000f8440ffULL, 0x000000103d3d7824ULL, 0x000fc400078e0230ULL,
0x000000103f457824ULL, 0x100fe200078e0230ULL, 0x00000007383b7c11ULL, 0x000fe200090f4431ULL,
0x00000010494b7824ULL, 0x000fe200078e0230ULL, 0x000000063a3f7c11ULL, 0x000fe2000f8640ffULL,
0x000000ffff317224ULL, 0x000fe200020e06ffULL, 0x0000003633307210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff337224ULL, 0x000fe200000e06ffULL, 0x000000063e497c11ULL, 0x000fe4000f8840ffULL,
0x000000073a3c7c11ULL, 0x000fe200098f4431ULL, 0x000000ffff317224ULL, 0x000fe200010e0632ULL,
0x0000003639327210ULL, 0x000fc40007f1e0ffULL, 0x000000363f387210ULL, 0x000fe40007f5e0ffULL,
0x000000073e3e7c11ULL, 0x000fe2000a0f4433ULL, 0x000000ffff337224ULL, 0x000fe200000e063bULL,
0x00000036493a7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff397224ULL, 0x000fe200010e063cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030357faeULL, 0x0003e6000b901c48ULL,
0x000000ffff3b7224ULL, 0x000fe200018e063eULL, 0x00000000323d7faeULL, 0x0003e8000b901c48ULL,
0x0000000038457faeULL, 0x0003e8000b901c48ULL, 0x000000003a4b7faeULL, 0x0003e4000b901c48ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x00000001ff4c7424ULL, 0x000fe200078e00ffULL,
0x00000000ff0079b0ULL, 0x000fe20008000a45ULL, 0x0000000000007918ULL, 0x000fc80000000000ULL,
0x0186a84c074c79a7ULL, 0x000e64000850003fULL, 0x000000ffff4c7224ULL, 0x002fe200078e004dULL,
0x0000000000307805ULL, 0x000fe20000015200ULL, 0x0186b051070075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x000fcc0000015200ULL, 0x0000003230357210ULL, 0x000fca0007f1e1ffULL,
0x0000000133337824ULL, 0x000fe200000e0e31ULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff327819ULL, 0x000fc80000011433ULL,
0x0000003532327211ULL, 0x000fca00078110ffULL, 0x000000ffff337224ULL, 0x000fca00000e0633ULL,
0x0000000232327819ULL, 0x000fc80000001233ULL, 0x000000320000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x0186b051070075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000000181947ULL, 0x000fea0003800000ULL, 0x00000002ff317819ULL, 0x000fe40000011609ULL,
0x0000000cff0d723eULL, 0x000fc600000010ffULL, 0x0000000831337836ULL, 0x000fe20000000000ULL,
0x000054100d307816ULL, 0x000fca000000000dULL, 0x00001f31300d7589ULL, 0x0002a800000e0000ULL,
0x00001f33300e7589ULL, 0x0002e400000e0000ULL, 0x013800004730783bULL, 0x0022e20000000200ULL,
0x0000000000101947ULL, 0x000fea0003800000ULL, 0x0000000d30307232ULL, 0x08cfe40000200000ULL,
0x0000000d32327232ULL, 0x000fe40000200000ULL, 0x0000000e31317232ULL, 0x080fe40000200000ULL,
0x0000000e33337232ULL, 0x000fce0000200000ULL, 0x00000000433c783bULL, 0x000f280000004200ULL,
0x000000004238783bULL, 0x000f620000004200ULL, 0x000001003c497824ULL, 0x050fe200078e00ffULL,
0x00000018ff467819ULL, 0x000fe4000001143cULL, 0x000088803c487816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4a7819ULL, 0x022fe20000011438ULL,
0x00000100384d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff497819ULL, 0x000fe20000011449ULL,
0x0000004600467306ULL, 0x000fe20000202400ULL, 0x00000018ff477819ULL, 0x000fc4000001143dULL,
0x000088803d507816ULL, 0x000fe400000000ffULL, 0x00000018ff537819ULL, 0x000fe4000001143cULL,
0x00000018ff447819ULL, 0x000fe2000001143eULL, 0x0000004a00437306ULL, 0x0003e20000202400ULL,
0x000088803e3c7816ULL, 0x000fe400000000ffULL, 0x00000018ff457819ULL, 0x000fe4000001143fULL,
0x00000018ff4f7819ULL, 0x000fc4000001144dULL, 0x00000018ff427819ULL, 0x000fe20000011439ULL,
0x0000004900517306ULL, 0x0009e20000202400ULL, 0x000001003d4a7824ULL, 0x002fe200078e00ffULL,
0x00008880394d7816ULL, 0x000fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff367819ULL, 0x000fe4000001143bULL, 0x00000018ff4a7819ULL, 0x000fe4000001144aULL,
0x00000018ff3d7819ULL, 0x000fe2000001143dULL, 0x000001003e497824ULL, 0x050fe200078e00ffULL,
0x0000004a00597306ULL, 0x0003e20000202400ULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff357819ULL, 0x000fc4000001143aULL, 0x00000018ff4b7819ULL, 0x000fe40000011449ULL,
0x000088803f497816ULL, 0x040fe400000000ffULL, 0x0000003d00567306ULL, 0x0009e20000202400ULL,
0x000001003f4a7824ULL, 0x042fe200078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x000100003f3f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff4a7819ULL, 0x000fe4000001144aULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x0000003e00557306ULL, 0x0003e20000202400ULL,
0x00008880383d7816ULL, 0x050fe200000000ffULL, 0x0001000038387824ULL, 0x000fca00078e00ffULL,
0x00000018ff387819ULL, 0x000fe20000011438ULL, 0x0000004800487306ULL, 0x000fe20000202400ULL,
0x00000100393e7824ULL, 0x042fe400078e00ffULL, 0x0001000039397824ULL, 0x000fc600078e00ffULL,
0x00000018ff587819ULL, 0x000fe4000001143eULL, 0x0000003f00547306ULL, 0x0003e20000202400ULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x000088803a3e7816ULL, 0x000fca00000000ffULL,
0x0000005000507306ULL, 0x000fe20000202400ULL, 0x000001003a3f7824ULL, 0x002fce00078e00ffULL,
0x0000003800527306ULL, 0x0003300000202400ULL, 0x0000004a005a7306ULL, 0x000fe20000202400ULL,
0x000001003b387824ULL, 0x002fca00078e00ffULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x0000004f004a7306ULL, 0x0003e20000202400ULL, 0x0000541052527816ULL, 0x010fce0000000043ULL,
0x0000003900577306ULL, 0x0009e20000202400ULL, 0x00000018ff4f7819ULL, 0x002fe4000001143fULL,
0x000088803b3f7816ULL, 0x040fe200000000ffULL, 0x000100003b3b7824ULL, 0x000fc800078e00ffULL,
0x0000005300537306ULL, 0x000e620000202400ULL, 0x000100003a397824ULL, 0x010fe200078e00ffULL,
0x00000018ff3b7819ULL, 0x000fcc000001143bULL, 0x00000038003a7306ULL, 0x0009f00000202400ULL,
0x0000003c003c7306ULL, 0x000fe20000202400ULL, 0x0000541048387816ULL, 0x010fe40000000051ULL,
0x00000018ff487819ULL, 0x000fc40000011439ULL, 0x0000541050397816ULL, 0x000fc60000000059ULL,
0x0000004b004b7306ULL, 0x000fe80000202400ULL, 0x000000383010723cULL, 0x008fe80000041810ULL,
0x0000004700477306ULL, 0x000ee60000202400ULL, 0x0000541053387816ULL, 0x002fca0000000046ULL,
0x0000004400447306ULL, 0x000e620000202400ULL, 0x0000541056397816ULL, 0x008fce0000000047ULL,
0x0000004500457306ULL, 0x000ee20000202400ULL, 0x000000383014723cULL, 0x000fe20000041814ULL,
0x0000541055447816ULL, 0x002fcc0000000044ULL, 0x0000004200427306ULL, 0x000e620000202400ULL,
0x0000541054457816ULL, 0x008fce0000000045ULL, 0x0000003500357306ULL, 0x000fe20000202400ULL,
0x00000044301c723cULL, 0x000fe2000004181cULL, 0x0000541057537816ULL, 0x002fcc0000000042ULL,
0x0000003600367306ULL, 0x000fe20000202400ULL, 0x000000523024723cULL, 0x000fee0000041824ULL,
0x0000004900497306ULL, 0x000e700000202400ULL, 0x0000003d003d7306ULL, 0x000ee20000202400ULL,
0x0000541049497816ULL, 0x002fce000000005aULL, 0x0000004d004d7306ULL, 0x000fe20000202400ULL,
0x000054103d4a7816ULL, 0x008fce000000004aULL, 0x0000005800587306ULL, 0x000ff00000202400ULL,
0x0000003e003e7306ULL, 0x000ff00000202400ULL, 0x0000004f004f7306ULL, 0x000e700000202400ULL,
0x0000003f003f7306ULL, 0x000ee20000202400ULL, 0x000054103e3e7816ULL, 0x002fce000000004fULL,
0x0000004800507306ULL, 0x0003220000202400ULL, 0x000054103f3f7816ULL, 0x008fce000000003aULL,
0x0000003b003b7306ULL, 0x000ee20000202400ULL, 0x000054103c487816ULL, 0x002fe4000000004bULL,
0x000054104d4b7816ULL, 0x000fe20000000058ULL, 0x0000003e3028723cULL, 0x000fe20000041828ULL,
0x0000541050507816ULL, 0x010fca0000000035ULL, 0x000000483018723cULL, 0x000fe20000041818ULL,
0x000054103b517816ULL, 0x008fca0000000036ULL, 0x0000004a3020723cULL, 0x000fec0000041820ULL,
0x00000050302c723cULL, 0x000fe2000004182cULL, 0x013800003730783bULL, 0x0002e20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000101947ULL, 0x000fde0003800000ULL,
0x0000000d30307232ULL, 0x08cfe40000200000ULL, 0x0000000d32327232ULL, 0x000fe40000200000ULL,
0x0000000e31317232ULL, 0x080fe40000200000ULL, 0x0000000e33337232ULL, 0x000fce0000200000ULL,
0x000000004038783bULL, 0x000f280000004200ULL, 0x00000000413c783bULL, 0x000f620000004200ULL,
0x00000018ff477819ULL, 0x010fe20000011438ULL, 0x00000100394d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff427819ULL, 0x000fe40000011439ULL, 0x00000018ff467819ULL, 0x022fe2000001143cULL,
0x000001003c377824ULL, 0x040fe200078e00ffULL, 0x000088803c367816ULL, 0x040fe200000000ffULL,
0x0000004700417306ULL, 0x0003e20000202400ULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff457819ULL, 0x000fe2000001143dULL, 0x000001003e497824ULL, 0x000fe200078e00ffULL,
0x000088803d537816ULL, 0x000fc400000000ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x00000018ff447819ULL, 0x000fe2000001143eULL, 0x000001003d477824ULL, 0x042fe200078e00ffULL,
0x000088803e487816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x0000888039557816ULL, 0x040fe200000000ffULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff567819ULL, 0x000fe20000011447ULL, 0x0001000039397824ULL, 0x000fe200078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe2000001143dULL, 0x0000003c00477306ULL, 0x0003e20000202400ULL,
0x00000018ff377819ULL, 0x000fc40000011437ULL, 0x00000018ff437819ULL, 0x000fe4000001143fULL,
0x000088803f4a7816ULL, 0x040fe400000000ffULL, 0x00000018ff4f7819ULL, 0x000fe2000001144dULL,
0x0000003d00547306ULL, 0x0009e20000202400ULL, 0x000001003f3c7824ULL, 0x042fe200078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe2000001143eULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe20000011439ULL, 0x000001003a397824ULL, 0x000fe200078e00ffULL,
0x00000018ff517819ULL, 0x000fc4000001143cULL, 0x00008880383c7816ULL, 0x040fe200000000ffULL,
0x00000100383d7824ULL, 0x050fe200078e00ffULL, 0x0000003600367306ULL, 0x000fe20000202400ULL,
0x0001000038387824ULL, 0x000fe200078e00ffULL, 0x00000018ff527819ULL, 0x000fe4000001143fULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff507819ULL, 0x000fe40000011438ULL,
0x0000003700377306ULL, 0x000e620000202400ULL, 0x00000018ff357819ULL, 0x000fc4000001143aULL,
0x00000018ff407819ULL, 0x000fe4000001143bULL, 0x000088803a387816ULL, 0x040fe200000000ffULL,
0x000100003a3a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff497819ULL, 0x000fe20000011449ULL,
0x0000005300537306ULL, 0x000fe60000202400ULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x0000541036367816ULL, 0x002fc60000000037ULL, 0x0000005600567306ULL, 0x000e700000202400ULL,
0x0000003e004b7306ULL, 0x000fe20000202400ULL, 0x0000541053377816ULL, 0x002fce0000000056ULL,
0x0000003d003f7306ULL, 0x0003e20000202400ULL, 0x000000363010723cULL, 0x008fee0000041810ULL,
0x00000055003e7306ULL, 0x0007e20000202400ULL, 0x00000018ff3d7819ULL, 0x002fe40000011439ULL,
0x000088803b397816ULL, 0x000fca00000000ffULL, 0x0000003c003c7306ULL, 0x000e620000202400ULL,
0x000001003b557824ULL, 0x048fe400078e00ffULL, 0x000100003b3b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff557819ULL, 0x000fe40000011455ULL, 0x0000004f004f7306ULL, 0x000ee20000202400ULL,
0x00000018ff3b7819ULL, 0x000fe4000001143bULL, 0x000054103c367816ULL, 0x002fca000000003fULL,
0x0000004600467306ULL, 0x000e620000202400ULL, 0x00000001ff3c7424ULL, 0x000fe200078e00ffULL,
0x000054103e377816ULL, 0x008fcc000000004fULL, 0x0000004800487306ULL, 0x000fe20000202400ULL,
0x000000363020723cULL, 0x000fe20000041820ULL, 0x0000541047467816ULL, 0x002fcc0000000046ULL,
0x0000004900497306ULL, 0x000e620000202400ULL, 0x0186b83c073679a7ULL, 0x000eee000850003fULL,
0x0000004500457306ULL, 0x000f220000202400ULL, 0x0186a03c07ff79a7ULL, 0x000be2000850003fULL,
0x0000541048487816ULL, 0x002fcc0000000049ULL, 0x0000004a004a7306ULL, 0x000fe20000202400ULL,
0x0000541054477816ULL, 0x010fce0000000045ULL, 0x0000005100517306ULL, 0x000e620000202400ULL,
0x000000463014723cULL, 0x000fee0000041814ULL, 0x0000004400447306ULL, 0x000f220000202400ULL,
0x000054104a497816ULL, 0x002fce0000000051ULL, 0x0000004300437306ULL, 0x000fe20000202400ULL,
0x000000483018723cULL, 0x000fe20000041818ULL, 0x000054104b447816ULL, 0x010fcc0000000044ULL,
0x0000004200427306ULL, 0x000ff00000202400ULL, 0x0000003500357306ULL, 0x000ff00000202400ULL,
0x0000004000407306ULL, 0x000ff00000202400ULL, 0x0000005200527306ULL, 0x000e700000202400ULL,
0x0000005000507306ULL, 0x000f220000202400ULL, 0x0000541052457816ULL, 0x002fce0000000043ULL,
0x0000004d004d7306ULL, 0x000e620000202400ULL, 0x00000044301c723cULL, 0x000fe2000004181cULL,
0x0000541050507816ULL, 0x010fcc0000000041ULL, 0x0000003a003a7306ULL, 0x000f220000202400ULL,
0x000054104d517816ULL, 0x002fce0000000042ULL, 0x0000003b003b7306ULL, 0x000e620000202400ULL,
0x000000020b4d7836ULL, 0x000fe20000000000ULL, 0x000000503024723cULL, 0x000fe20000041824ULL,
0x000054103a3a7816ULL, 0x010fca0000000035ULL, 0x0000003800387306ULL, 0x000fe20000202400ULL,
0x000054103b3b7816ULL, 0x002fce0000000040ULL, 0x0000003d003d7306ULL, 0x000e620000202400ULL,
0x0000003a302c723cULL, 0x000fee000004182cULL, 0x0000003900397306ULL, 0x000fe20000202400ULL,
0x0000541038387816ULL, 0x002fce000000003dULL, 0x0000005500567306ULL, 0x000e640000202400ULL,
0x0000541039397816ULL, 0x002fce0000000056ULL, 0x000000383028723cULL, 0x000fee0000041828ULL,
0x000000ffff397224ULL, 0x02cfde00078e0037ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000104047890ULL, 0x000fcc000fffe03fULL, 0x0000000405007c0cULL, 0x000fda000bf03070ULL,
0xffffff0c00188947ULL, 0x000fea000383ffffULL, 0x000000ff0500720cULL, 0x000fe20003f05270ULL,
0x000000ffff337224ULL, 0x000fe400078e001dULL, 0x000000ffff1d7224ULL, 0x000fe400078e0019ULL,
0x000000ffff317224ULL, 0x000fd000078e0013ULL, 0x0000000000dc8947ULL, 0x000fea0003800000ULL,
0x0180000000027836ULL, 0x000fe20000000000ULL, 0x000000d000007945ULL, 0x000fe80003800000ULL,
0x7f80000002027812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0200780cULL, 0x000fda0003f04070ULL,
0x0000000000140947ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe200078e0000ULL,
0x0001096000057802ULL, 0x000fce0000000f00ULL, 0x0000007000dc7944ULL, 0x00efea0003c00000ULL,
0x000000ffff057224ULL, 0x008fe200078e0000ULL, 0x0000000000107947ULL, 0x000fec0003800000ULL,
0x0000000000057308ULL, 0x000f240000001000ULL, 0xbf80000005027423ULL, 0x010fc80000000000ULL,
0x800000ff02027221ULL, 0x000fc80000010100ULL, 0x0000000205057223ULL, 0x000fce0000000005ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009400ff027b82ULL, 0x000f240000000a00ULL,
0x0000000802027981ULL, 0x010f22000c1e9900ULL, 0x0000000000067919ULL, 0x000f640000000000ULL,
0x00000002ff007819ULL, 0x022fe40000011606ULL, 0x0000000806067811ULL, 0x000fe200078ff0ffULL,
0x0000000502057220ULL, 0x010fca0000410000ULL, 0x00001f0005007589ULL, 0x000e6800000e0000ULL,
0x00001f0605067589ULL, 0x000f2200000e0000ULL, 0x0000001000107220ULL, 0x042fe20000410000ULL,
0x0000001100117220ULL, 0x040fe20000410000ULL, 0x0000001400147220ULL, 0x040fe20000410000ULL,
0x0000001500157220ULL, 0x040fe20000410000ULL, 0x0000001800187220ULL, 0x040fe20000410000ULL,
0x0000001d001d7220ULL, 0x040fe20000410000ULL, 0x0000001c001c7220ULL, 0x040fe20000410000ULL,
0x0000003300337220ULL, 0x040fe20000410000ULL, 0x0000002000207220ULL, 0x040fe20000410000ULL,
0x0000002100217220ULL, 0x040fe20000410000ULL, 0x0000002400247220ULL, 0x040fe20000410000ULL,
0x0000002500257220ULL, 0x040fe20000410000ULL, 0x0000002800287220ULL, 0x040fe20000410000ULL,
0x0000002900297220ULL, 0x040fe20000410000ULL, 0x0000002c002c7220ULL, 0x040fe20000410000ULL,
0x0000002d002d7220ULL, 0x000fe20000410000ULL, 0x0000001206127220ULL, 0x050fe20000410000ULL,
0x0000003106317220ULL, 0x040fe20000410000ULL, 0x0000001606167220ULL, 0x040fe20000410000ULL,
0x0000001706177220ULL, 0x040fe20000410000ULL, 0x0000001a061a7220ULL, 0x040fe20000410000ULL,
0x0000001b061b7220ULL, 0x040fe20000410000ULL, 0x0000001e061e7220ULL, 0x040fe20000410000ULL,
0x0000001f061f7220ULL, 0x040fe20000410000ULL, 0x0000002206227220ULL, 0x040fe20000410000ULL,
0x0000002306237220ULL, 0x040fe20000410000ULL, 0x0000002606267220ULL, 0x040fe20000410000ULL,
0x0000002706277220ULL, 0x040fe20000410000ULL, 0x0000002a062a7220ULL, 0x040fe20000410000ULL,
0x0000002b062b7220ULL, 0x040fe20000410000ULL, 0x0000002e062e7220ULL, 0x040fe20000410000ULL,
0x0000002f062f7220ULL, 0x000fce0000410000ULL, 0x0000000000007919ULL, 0x000f220000000000ULL,
0x0000080034077824ULL, 0x002fe200078e0207ULL, 0x000000202120723eULL, 0x000fe200000010ffULL,
0x00000000000579c3ULL, 0x000e700000002700ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000282928723eULL, 0x000fe200000010ffULL, 0x0000840000047ab9ULL, 0x000fe20000000800ULL,
0x000000161716723eULL, 0x000fe200000010ffULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x0000001a1b1a723eULL, 0x000fe200000010ffULL, 0x0000860000067ab9ULL, 0x000fe20000000a00ULL,
0x000000222322723eULL, 0x000fc400000010ffULL, 0x0000002a2b2a723eULL, 0x000fe200000010ffULL,
0x00000005040472a4ULL, 0x002fe2000f8e023fULL, 0x0000000800097811ULL, 0x050fe400078ff0ffULL,
0x0000000200027812ULL, 0x000fe400078ec0ffULL, 0x00000002ff057819ULL, 0x100fe20000011600ULL,
0x0000000809067824ULL, 0x000fe200078e00ffULL, 0x0000000902037211ULL, 0x040fe400078ff8ffULL,
0x0000000502027211ULL, 0x000fe200078ff8ffULL, 0x00000008050a7824ULL, 0x048fe200078e00ffULL,
0xfffffff8060f7812ULL, 0x000fe200078ee203ULL, 0x0000000805037824ULL, 0x040fe200078e00ffULL,
0x00000003ff137819ULL, 0x000fe20000011600ULL, 0x00000008050b7824ULL, 0x000fc400078e00ffULL,
0x00000008050d7824ULL, 0x000fe200078e00ffULL, 0xfffffff803037812ULL, 0x000fe200078ee202ULL,
0x0000000202057836ULL, 0x000fe40000000000ULL, 0x0000000402067836ULL, 0x000fe40000000000ULL,
0x0000000602087836ULL, 0x000fe20000000000ULL, 0xfffffff80a097812ULL, 0x000fe200078ee205ULL,
0x00000020000a7836ULL, 0x000fe20000000000ULL, 0xfffffff80b0b7812ULL, 0x000fe200078ee206ULL,
0x0001200007027836ULL, 0x000fe20000000000ULL, 0xfffffff80d0d7812ULL, 0x000fe200078ee208ULL,
0x0000000113087824ULL, 0x000fe200078e0200ULL, 0x00000003ff197819ULL, 0x000fe2000001160aULL,
0x0000001003057824ULL, 0x100fe200078e0202ULL, 0x000000141503723eULL, 0x000fe200000010ffULL,
0x000000100f0f7824ULL, 0x000fc400078e0202ULL, 0x0000001009097824ULL, 0x100fe400078e0202ULL,
0x000000100b0b7824ULL, 0x100fe400078e0202ULL, 0x000000100d0d7824ULL, 0x000fe200078e0202ULL,
0x000000101102723eULL, 0x000fe200000010ffULL, 0x000000010a0c7824ULL, 0x000fe200078e0219ULL,
0x000000242510723eULL, 0x000fe200000010ffULL, 0x0000000800067824ULL, 0x000fe200078e00ffULL,
0x0000541002147816ULL, 0x140fe40000000003ULL, 0x0000763202157816ULL, 0x000fc40000000003ULL,
0x0000000708037812ULL, 0x000fe400078ec0ffULL, 0x000000070c117812ULL, 0x000fe400078ec0ffULL,
0x0000000806067812ULL, 0x000fe400078ec0ffULL, 0x0ffffff803087812ULL, 0x000fe400078ef800ULL,
0x0ffffff8110c7812ULL, 0x000fe200078ef80aULL, 0x0000000105057824ULL, 0x000fe200078e0206ULL,
0x000000181d02723eULL, 0x000fe200000010ffULL, 0x00000001060f7824ULL, 0x040fe200078e020fULL,
0x0000001c3303723eULL, 0x000fe200000010ffULL, 0x0000000106097824ULL, 0x040fe200078e0209ULL,
0x0000001405007388ULL, 0x0003e20000000a00ULL, 0x00000001060b7824ULL, 0x000fe200078e020bULL,
0x00005410201c7816ULL, 0x100fe20000000010ULL, 0x0000001008087824ULL, 0x000fe200078e0207ULL,
0x00007632201d7816ULL, 0x000fe20000000010ULL, 0x0000000106067824ULL, 0x000fe200078e020dULL,
0x00007632020d7816ULL, 0x000fe20000000003ULL, 0x000000100c077824ULL, 0x000fe200078e0207ULL,
0x00005410020c7816ULL, 0x000fc40000000003ULL, 0x000000123102723eULL, 0x000fe200000010ffULL,
0x0000000000057919ULL, 0x002e620000002600ULL, 0x0000002c2d14723eULL, 0x000fe400000010ffULL,
0x000000262711723eULL, 0x000fe200000010ffULL, 0x0000000c09007388ULL, 0x0007e20000000a00ULL,
0x0000002e2f15723eULL, 0x000fe400000010ffULL, 0x0000541022107816ULL, 0x140fe20000000011ULL,
0x0000001c0b007388ULL, 0x0009e20000000a00ULL, 0x0000763222117816ULL, 0x000fc40000000011ULL,
0x000076322a037816ULL, 0x000fe40000000015ULL, 0x0000001e1f0d723eULL, 0x008fe400000010ffULL,
0x00005410281c7816ULL, 0x150fe40000000014ULL, 0x00007632281d7816ULL, 0x000fe40000000014ULL,
0x000054101a0c7816ULL, 0x140fe4000000000dULL, 0x000076321a0d7816ULL, 0x000fe2000000000dULL,
0x0000001c06007388ULL, 0x0007e20000000a00ULL, 0x0000000805127824ULL, 0x002fc400078e00ffULL,
0x0000000805187824ULL, 0x000fe200078e00ffULL, 0x0000000700057812ULL, 0x000fe400078ec0ffULL,
0xfffffff812137812ULL, 0x000fe400078ee213ULL, 0x00005410021c7816ULL, 0x148fe40000000016ULL,
0x00007632021d7816ULL, 0x000fe40000000016ULL, 0x000054102a027816ULL, 0x000fe40000000015ULL,
0xfffffff818197812ULL, 0x000fe200078ee219ULL, 0x0000001c0f007388ULL, 0x000fe20000000a00ULL,
0x0000000413137c10ULL, 0x000fc4000ff1e0ffULL, 0x0000000419197c10ULL, 0x000fe2000ff3e0ffULL,
0x0004000c09007388ULL, 0x0003e20000000a00ULL, 0x1ffffff805057812ULL, 0x000fc600078ef804ULL,
0x000400100b007388ULL, 0x000fe20000000a00ULL, 0x000000ffff007224ULL, 0x000fc600008e06ffULL,
0x0004000206007388ULL, 0x0007e20000000a00ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x01200000080c7984ULL, 0x0009620000000c00ULL, 0x000000070a097812ULL, 0x002fc600078ec0ffULL,
0x0120000007147984ULL, 0x0003620000000c00ULL, 0x0000000619067c11ULL, 0x008fe4000f8248ffULL,
0x1ffffff809097812ULL, 0x000fe200078ef804ULL, 0x000000ffff087224ULL, 0x010fe200000e06ffULL,
0x0000000613027c11ULL, 0x000fe4000f8048ffULL, 0x0000000719077c11ULL, 0x002fe400088f4c00ULL,
0x0000000713037c11ULL, 0x000fc600080f4c08ULL, 0x0000001005027825ULL, 0x000fc800078e0002ULL,
0x0000001009047825ULL, 0x000fe200078e0006ULL, 0x0000000c02007986ULL, 0x024fe8000c101d08ULL,
0x0000001404007986ULL, 0x000fe2000c101d08ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff037819ULL, 0x000fe20000011634ULL, 0x00009400ff147b82ULL, 0x000e620000000a00ULL,
0x00000001ff0c7424ULL, 0x000fe400078e00ffULL, 0x000000060300720cULL, 0x000fda0003f06070ULL,
0x00009000ff0d8b82ULL, 0x000ea20000000800ULL, 0x0000000236008824ULL, 0x000fce00078e00ffULL,
0x00008c00ff128b82ULL, 0x000ee20000000a00ULL, 0x00000008140a7981ULL, 0x002322000c1e9900ULL,
0x0000000d000d8224ULL, 0x004fe400078e0203ULL, 0xffffffffff007424ULL, 0x000fe400078e00ffULL,
0x000000040d128825ULL, 0x008fe400078e0012ULL, 0x0186000c070c79a7ULL, 0x000266000850003fULL,
0x0000000812008981ULL, 0x000ea2000c1e1900ULL, 0x000001ff0b00780cULL, 0x000fe20003f04070ULL,
0x0000008008087824ULL, 0x000fc400078e00ffULL, 0x0000004034027824ULL, 0x000fe400078e00ffULL,
0x00000080170b7824ULL, 0x000fc600078e00ffULL, 0x0000004008107812ULL, 0x000fe200078ef802ULL,
0x0000000b00047224ULL, 0x004fc800078e02ffULL, 0x0000000c00a80947ULL, 0x002fea0003800000ULL,
0x000000020f117248ULL, 0x000fe20007fe0000ULL, 0x00008a0000047ab9ULL, 0x000fe20000000a00ULL,
0x00000003ff137819ULL, 0x000fe40000011609ULL, 0x000000700e0e7812ULL, 0x000fe200078ec0ffULL,
0x0000000111127824ULL, 0x000fe400078e0a02ULL, 0x0000000413157836ULL, 0x000fe40000000000ULL,
0x0000000110117824ULL, 0x040fe400078e0213ULL, 0x0000000115147824ULL, 0x040fe200078e0209ULL,
0x000000121500720cULL, 0x040fe20003f86070ULL, 0x0000000815197824ULL, 0x000fe200078e00ffULL,
0x0000001104117210ULL, 0x000fe20007f1e0ffULL, 0x0000000110157824ULL, 0x000fc400078e0215ULL,
0x0000000813177836ULL, 0x000fe20000000000ULL, 0xfffffff8191a7812ULL, 0x000fe200078ee214ULL,
0x000000ffff1e7224ULL, 0x000fe200000e06ffULL, 0x0000001504157210ULL, 0x000fe20007f3e0ffULL,
0x0000000117167824ULL, 0x040fe200078e0209ULL, 0x000000121700720cULL, 0x040fe20003fa6070ULL,
0x00000008171b7824ULL, 0x000fe200078e00ffULL, 0x0000000411257c11ULL, 0x000fe2000f8040ffULL,
0x0000000110177824ULL, 0x000fe400078e0217ULL, 0x000000ffff247224ULL, 0x000fe200008e06ffULL,
0x0000000415237c11ULL, 0x000fe2000f8240ffULL, 0x00000014131d7836ULL, 0x000fe20000000000ULL,
0x00000005111e7c11ULL, 0x000fc400080f441eULL, 0x0000001704227210ULL, 0x000fe20007f1e0ffULL,
0x0000001013177836ULL, 0x000fe20000000000ULL, 0x0000000515247c11ULL, 0x000fe200088f4424ULL,
0x0000000c13157836ULL, 0x000fe20000000000ULL, 0xfffffff81b1c7812ULL, 0x000fe200078ee216ULL,
0x0000000110197824ULL, 0x040fe400078e0217ULL, 0x00000001101b7824ULL, 0x040fe400078e021dULL,
0x0000000110117824ULL, 0x000fe200078e0215ULL, 0x0000001904197210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff217224ULL, 0x000fe200000e06ffULL, 0x0000001b041b7210ULL, 0x000fe20007f7e0ffULL,
0x0000000115167824ULL, 0x000fe200078e0209ULL, 0x0000001104117210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff267224ULL, 0x000fe200010e06ffULL, 0x00000004221f7c11ULL, 0x040fe2000f8040ffULL,
0x000000ffff147224ULL, 0x000fe200018e06ffULL, 0x000000041b277c11ULL, 0x000fe2000f8440ffULL,
0x000000ffff287224ULL, 0x000fe200008e06ffULL, 0x0000000522227c11ULL, 0x000fe200080f4421ULL,
0x0000001813217836ULL, 0x000fe20000000000ULL, 0x00000004192f7c11ULL, 0x000fe2000f8240ffULL,
0x0000000117187824ULL, 0x100fe200078e0209ULL, 0x000000051b2d7c11ULL, 0x000fe200090f4414ULL,
0x0000000113147824ULL, 0x000fe200078e0209ULL, 0x0000000519267c11ULL, 0x000fe200088f4426ULL,
0x0000000110197824ULL, 0x000fe200078e0221ULL, 0x0000000411317c11ULL, 0x000fe2000f8040ffULL,
0x00000008151b7824ULL, 0x000fe200078e00ffULL, 0x0000000714207812ULL, 0x000fc400078ec0ffULL,
0x0000001904197210ULL, 0x000fe40007fde0ffULL, 0x000000250e147210ULL, 0x000fe40007f3e0ffULL,
0x000000121500720cULL, 0x080fe20003f66070ULL, 0x000000ffff2c7224ULL, 0x000fe200030e06ffULL,
0x0000000511287c11ULL, 0x000fe200080f4428ULL, 0x000000ffff157224ULL, 0x000fe200008e061eULL,
0x00000004192b7c11ULL, 0x000fe2000f8240ffULL, 0x0000400034117824ULL, 0x000fe200078e0207ULL,
0x000000121300720cULL, 0x000fc40003f06070ULL, 0x000000121700720cULL, 0x040fe20003f46070ULL,
0x0000200011117836ULL, 0x000fe20000000000ULL, 0x0ffffff820207812ULL, 0x000fe200078ef809ULL,
0x0000000817177824ULL, 0x000fe200078e00ffULL, 0xfffffff81b1e7812ULL, 0x000fe400078ee216ULL,
0x00000005192c7c11ULL, 0x000fe200088f442cULL, 0x00000010201b7824ULL, 0x000fe200078e0211ULL,
0x000000230e167210ULL, 0x000fe20007f3e0ffULL, 0x0000001c13237836ULL, 0x000fe20000000000ULL,
0xfffffff817207812ULL, 0x000fc400078ee218ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000141b7faeULL, 0x0003e2000c101c48ULL, 0x000000ffff177224ULL, 0x000fe200008e0624ULL,
0x0000001f0e187210ULL, 0x000fe20007f3e0ffULL, 0x0000000110257824ULL, 0x000fe200078e0223ULL,
0x000000121d00720cULL, 0x0c0fe20003f06070ULL, 0x000000011d1f7824ULL, 0x040fe400078e0209ULL,
0x000000ffff197224ULL, 0x000fe200008e0622ULL, 0x0000002504257210ULL, 0x000fe20007fde0ffULL,
0x000000081d247824ULL, 0x000fe200078e00ffULL, 0x000000122100720cULL, 0x000fe20003f26070ULL,
0x000000101a1d7824ULL, 0x000fc400078e0211ULL, 0x0000000121147824ULL, 0x042fe200078e0209ULL,
0xfffffff824227812ULL, 0x000fe200078ee21fULL, 0x0000000821217824ULL, 0x000fe200078e00ffULL,
0x00000000161d7faeULL, 0x0003e2000e101c48ULL, 0x000000ffff2a7224ULL, 0x000fe200030e06ffULL,
0x0000000425297c11ULL, 0x040fe2000f8c40ffULL, 0x000000101c1f7824ULL, 0x000fe200078e0211ULL,
0xfffffff821247812ULL, 0x000fe200078ee214ULL, 0x0000002013217836ULL, 0x000fe20000000000ULL,
0x00000005252a7c11ULL, 0x000fe2000b0f442aULL, 0x00000001231c7824ULL, 0x040fe200078e0209ULL,
0x000000310e147210ULL, 0x000fe20007fde0ffULL, 0x0000000110257824ULL, 0x000fe200078e0221ULL,
0x00000000181f7faeULL, 0x0005e2000e901c48ULL, 0x0000002f0e1a7210ULL, 0x000fe20007fbe0ffULL,
0x0000002413177836ULL, 0x002fe20000000000ULL, 0x000000122300720cULL, 0x080fe20003f86070ULL,
0x000000ffff157224ULL, 0x000fe200030e0628ULL, 0x0000002504257210ULL, 0x000fe20007fde0ffULL,
0x000000ffff1b7224ULL, 0x000fe200028e0626ULL, 0x000000122100720cULL, 0x040fe20003fa6070ULL,
0x0000000121167824ULL, 0x000fc400078e0209ULL, 0x00000008232f7824ULL, 0x000fe400078e00ffULL,
0x0000000821217824ULL, 0x000fe400078e00ffULL, 0x000000ffff287224ULL, 0x000fe200030e06ffULL,
0x0000000425237c11ULL, 0x040fe2000f8c40ffULL, 0x000000101e197824ULL, 0x004fe200078e0211ULL,
0xfffffff821267812ULL, 0x000fe200078ee216ULL, 0x00000001101f7824ULL, 0x000fe200078e0217ULL,
0x0000000525287c11ULL, 0x000fe2000b0f4428ULL, 0x00000010201d7824ULL, 0x000fe200078e0211ULL,
0x0000000014197faeULL, 0x0003e2000d901c48ULL, 0x000000270e167210ULL, 0x000fe20007f7e0ffULL,
0x0000000117187824ULL, 0x040fe200078e0209ULL, 0x0000001f04207210ULL, 0x000fe20007fde0ffULL,
0x00000008171f7824ULL, 0x040fe200078e00ffULL, 0x000000001a1d7faeULL, 0x0005e2000d101c48ULL,
0x000000121700720cULL, 0x000fe20003f46070ULL, 0x000000ffff177224ULL, 0x000fe200018e062dULL,
0xfffffff82f1c7812ULL, 0x000fe200078ee21cULL, 0x000000ffff217224ULL, 0x000fe200030e06ffULL,
0x0000000420277c11ULL, 0x000fe2000f8c40ffULL, 0x0000001026257824ULL, 0x100fe200078e0211ULL,
0x0000002b0e147210ULL, 0x002fe20007f7e0ffULL, 0x0000003c132b7836ULL, 0x000fe20000000000ULL,
0xfffffff81f1e7812ULL, 0x000fe200078ee218ULL, 0x00000010221f7824ULL, 0x000fe200078e0211ULL,
0x00000005201d7c11ULL, 0x004fe2000b0f4421ULL, 0x000000ffff157224ULL, 0x000fc400018e062cULL,
0x0000001024217824ULL, 0x100fe200078e0211ULL, 0x00000000161f7faeULL, 0x0003e2000c101c48ULL,
0x000000290e187210ULL, 0x000fe20007f1e0ffULL, 0x0000003813297836ULL, 0x000fe40000000000ULL,
0x0000000014217faeULL, 0x0005e2000c901c48ULL, 0x000000230e1a7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff197224ULL, 0x000fe400000e062aULL, 0x000000101c237824ULL, 0x000fe200078e0211ULL,
0x000000270e1c7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff1b7224ULL, 0x000fe200008e0628ULL,
0x000000122900720cULL, 0x000fe20003f26070ULL, 0x0000002c13177836ULL, 0x002fe20000000000ULL,
0x0000000018237faeULL, 0x0003e2000e101c48ULL, 0x00000030131f7836ULL, 0x000fc40000000000ULL,
0x0000002813157836ULL, 0x004fe20000000000ULL, 0x000000001a257faeULL, 0x0005e2000e901c48ULL,
0x0000003413217836ULL, 0x000fe20000000000ULL, 0x000000121700720cULL, 0x080fe20003f86070ULL,
0x0000000110137824ULL, 0x000fe200078e0215ULL, 0x000000121500720cULL, 0x080fe20003fa6070ULL,
0x000000ffff1d7224ULL, 0x000fe200000e061dULL, 0x000000121f00720cULL, 0x000fe20003f66070ULL,
0x000000101e277824ULL, 0x000fe200078e0211ULL, 0x0000001304197210ULL, 0x002fe20007f1e0ffULL,
0x0000000117137824ULL, 0x000fc400078e0209ULL, 0x0000000817187824ULL, 0x000fe200078e00ffULL,
0x000000001c277faeULL, 0x0003e2000d101c48ULL, 0x0000000115147824ULL, 0x000fe200078e0209ULL,
0x000000122100720cULL, 0x080fe20003f46070ULL, 0x00000008151b7824ULL, 0x004fe200078e00ffULL,
0x0000000419157c11ULL, 0x000fe2000f8c40ffULL, 0x000000ffff1a7224ULL, 0x000fe200000e06ffULL,
0xfffffff818187812ULL, 0x000fe200078ee213ULL, 0x0000000110177824ULL, 0x000fe200078e0217ULL,
0x000000122b00720cULL, 0x000fe20003f06070ULL, 0x00000008291e7824ULL, 0x000fe200078e00ffULL,
0x0000000519137c11ULL, 0x000fc4000b0f441aULL, 0x000000150e127210ULL, 0x000fe20007fde0ffULL,
0x0000000121157824ULL, 0x040fe200078e0209ULL, 0xfffffff81b167812ULL, 0x000fe200078ee214ULL,
0x00000008211c7824ULL, 0x002fe400078e00ffULL, 0x000000ffff137224ULL, 0x000fe200030e0613ULL,
0x00000017041b7210ULL, 0x000fe20007fde0ffULL, 0x000000011f147824ULL, 0x140fe200078e0209ULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee215ULL, 0x000000081f1d7824ULL, 0x000fe400078e00ffULL,
0x000000ffff207224ULL, 0x000fe200030e06ffULL, 0x000000041b197c11ULL, 0x000fe2000f8c40ffULL,
0x0000000129177824ULL, 0x000fe200078e0209ULL, 0xfffffff81d1a7812ULL, 0x000fe200078ee214ULL,
0x00000001101f7824ULL, 0x040fe200078e021fULL, 0x000000051b157c11ULL, 0x000fe2000b0f4420ULL,
0x0000000110217824ULL, 0x040fe200078e0221ULL, 0x000000190e147210ULL, 0x000fe20007fde0ffULL,
0x0000000110297824ULL, 0x040fe200078e0229ULL, 0xfffffff81e1e7812ULL, 0x000fe200078ee217ULL,
0x0000000110197824ULL, 0x000fc400078e022bULL, 0x000000012b107824ULL, 0x040fe400078e0209ULL,
0x0000001016097824ULL, 0x000fe400078e0211ULL, 0x000000ffff157224ULL, 0x000fe200030e0615ULL,
0x0000001f041f7210ULL, 0x000fe20007fde0ffULL, 0x000000082b2b7824ULL, 0x000fe200078e00ffULL,
0x0000000012097faeULL, 0x0003e2000e901c48ULL, 0x0000002104167210ULL, 0x000fe20007fbe0ffULL,
0x0000001018177824ULL, 0x100fe400078e0211ULL, 0x000000ffff207224ULL, 0x000fe200030e06ffULL,
0x000000041f257c11ULL, 0x040fe2000f8c40ffULL, 0x000000ffff237224ULL, 0x000fe200028e06ffULL,
0xfffffff82b107812ULL, 0x000fe200078ee210ULL, 0x0000000014177faeULL, 0x0005e2000e101c48ULL,
0x0000000416217c11ULL, 0x000fe2000f8a40ffULL, 0x000000101c1b7824ULL, 0x100fe200078e0211ULL,
0x000000051f207c11ULL, 0x000fe2000b0f4420ULL, 0x00000010101f7824ULL, 0x000fe200078e0211ULL,
0x0000000516137c11ULL, 0x002fe2000a8f4423ULL, 0x000000101e1d7824ULL, 0x000fe200078e0211ULL,
0x0000002904297210ULL, 0x000fc40007f9e0ffULL, 0x000000250e107210ULL, 0x000fe40007fbe0ffULL,
0x0000001904047210ULL, 0x000fe20007fde0ffULL, 0x000000101a197824ULL, 0x000fe400078e0211ULL,
0x000000ffff187224ULL, 0x000fe200020e06ffULL, 0x0000000429157c11ULL, 0x004fe2000f8840ffULL,
0x000000ffff117224ULL, 0x000fe200028e0620ULL, 0x000000210e127210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff097224ULL, 0x000fe200030e06ffULL, 0x0000000404177c11ULL, 0x000fc4000f8c40ffULL,
0x0000000529187c11ULL, 0x000fe2000a0f4418ULL, 0x000000ffff137224ULL, 0x000fe200028e0613ULL,
0x000000150e147210ULL, 0x000fe20007f9e0ffULL, 0x0000000010197faeULL, 0x0003e2000d901c48ULL,
0x0000000504047c11ULL, 0x000fe4000b0f4409ULL, 0x000000170e167210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff157224ULL, 0x000fe200020e0618ULL, 0x00000000121b7faeULL, 0x0003e6000d101c48ULL,
0x000000ffff177224ULL, 0x000fe200028e0604ULL, 0x00000000141d7faeULL, 0x0003e8000c901c48ULL,
0x00000000161f7faeULL, 0x0003e2000c101c48ULL, 0x0000000c00587947ULL, 0x000fea0003800000ULL,
0x0000000c09197811ULL, 0x040fe200078fe8ffULL, 0x00008a0000047ab9ULL, 0x000fe20000000a00ULL,
0x0000001c09247811ULL, 0x040fe400078fe8ffULL, 0x0000000409157811ULL, 0x000fe200078fe8ffULL,
0x0000000119227824ULL, 0x100fe200078e0209ULL, 0x0000000809177811ULL, 0x000fe200078fe8ffULL,
0x0000000819137824ULL, 0x000fe200078e00ffULL, 0x0000001809217811ULL, 0x040fe200078fe8ffULL,
0x00000001241c7824ULL, 0x140fe200078e0209ULL, 0x00000010091b7811ULL, 0x040fe200078fe8ffULL,
0x0000000824257824ULL, 0x000fe200078e00ffULL, 0x00000014091d7811ULL, 0x000fe200078fe8ffULL,
0x0000000115187824ULL, 0x140fe200078e0209ULL, 0xfffffff813227812ULL, 0x000fe200078ee222ULL,
0x0000000815117824ULL, 0x000fe200078e00ffULL, 0xfffffff8251c7812ULL, 0x000fe200078ee21cULL,
0x0000000117237824ULL, 0x100fe200078e0209ULL, 0x0000002009257811ULL, 0x000fe200078fe8ffULL,
0x0000000817127824ULL, 0x000fe200078e00ffULL, 0xfffffff811187812ULL, 0x000fe200078ee218ULL,
0x00000001211e7824ULL, 0x100fe200078e0209ULL, 0x0000002809277811ULL, 0x000fe200078fe8ffULL,
0x0000000821137824ULL, 0x000fe200078e00ffULL, 0xfffffff812237812ULL, 0x000fe200078ee223ULL,
0x000000011b207824ULL, 0x100fe200078e0209ULL, 0x0000002c09287811ULL, 0x000fe200078fe8ffULL,
0x000000081b117824ULL, 0x000fe200078e00ffULL, 0xfffffff8131e7812ULL, 0x000fe200078ee21eULL,
0x000000011d1f7824ULL, 0x100fe200078e0209ULL, 0x0000002409267811ULL, 0x000fe200078fe8ffULL,
0x000000081d127824ULL, 0x000fe200078e00ffULL, 0xfffffff811207812ULL, 0x000fe200078ee220ULL,
0x00000001251a7824ULL, 0x100fe200078e0209ULL, 0x00000038092e7811ULL, 0x000fe200078fe8ffULL,
0x0000000825137824ULL, 0x000fe200078e00ffULL, 0xfffffff8121f7812ULL, 0x000fe200078ee21fULL,
0x0000000127127824ULL, 0x100fe200078e0209ULL, 0x00000034092c7811ULL, 0x000fe200078fe8ffULL,
0x00000008272b7824ULL, 0x000fe200078e00ffULL, 0xfffffff8131a7812ULL, 0x000fe200078ee21aULL,
0x0000000128117824ULL, 0x140fe200078e0209ULL, 0x0000001009137211ULL, 0x040fe200078fe8ffULL,
0x0000000828147824ULL, 0x000fe200078e00ffULL, 0x00000030092a7811ULL, 0x040fe200078fe8ffULL,
0x0000000126167824ULL, 0x040fe200078e0209ULL, 0xfffffff82b127812ULL, 0x000fe200078ee212ULL,
0x0000000826297824ULL, 0x000fe200078e00ffULL, 0xfffffff814117812ULL, 0x000fe200078ee211ULL,
0x0000000110157824ULL, 0x040fe200078e0215ULL, 0x0000000909147211ULL, 0x040fe200078fe8ffULL,
0x0000000110177824ULL, 0x040fe200078e0217ULL, 0xfffffff829167812ULL, 0x000fe200078ee216ULL,
0x00000001102d7824ULL, 0x040fe200078e0226ULL, 0x0000001304137210ULL, 0x000fe20007f1e0ffULL,
0x00000001102b7824ULL, 0x000fe200078e0225ULL, 0x0000003c09307811ULL, 0x000fe200078fe8ffULL,
0x000000012e267824ULL, 0x040fe200078e0209ULL, 0x0000001504157210ULL, 0x000fe20007f3e0ffULL,
0x000000082e3b7824ULL, 0x000fe200078e00ffULL, 0x0000001704177210ULL, 0x000fe20007f5e0ffULL,
0x0000000110297824ULL, 0x000fe200078e0224ULL, 0x0000000714147812ULL, 0x000fe200078ec0ffULL,
0x00000001102f7824ULL, 0x040fe200078e0227ULL, 0x0000002d042d7210ULL, 0x000fe20007f7e0ffULL,
0x0000000110357824ULL, 0x000fe200078e022cULL, 0x000000700e4d7812ULL, 0x000fe200078ec0ffULL,
0x000000012c257824ULL, 0x100fe200078e0209ULL, 0x000000042d467c11ULL, 0x000fe2000f8c40ffULL,
0x000000012a247824ULL, 0x000fc400078e0209ULL, 0x000000082a277824ULL, 0x000fe400078e00ffULL,
0x000000082c2c7824ULL, 0x000fe400078e00ffULL, 0x0000000110377824ULL, 0x040fe200078e022eULL,
0xfffffff83b2e7812ULL, 0x000fe200078ee226ULL, 0x0000000110317824ULL, 0x040fe200078e0228ULL,
0xfffffff82c2c7812ULL, 0x000fe200078ee225ULL, 0x0000000110337824ULL, 0x040fe200078e022aULL,
0xfffffff8272a7812ULL, 0x000fe200078ee224ULL, 0x000000ffff267224ULL, 0x000fe200000e06ffULL,
0x00000004134c7c11ULL, 0x000fe2000f8040ffULL, 0x0000000110197824ULL, 0x000fc400078e0219ULL,
0x00000001101b7824ULL, 0x040fe200078e021bULL, 0x0000000513267c11ULL, 0x000fe200080f4426ULL,
0x00000001101d7824ULL, 0x040fe200078e021dULL, 0x0000001904197210ULL, 0x000fe20007f1e0ffULL,
0x0000000110217824ULL, 0x040fe400078e0221ULL, 0x0000000110397824ULL, 0x000fe200078e0230ULL,
0x0ffffff814107812ULL, 0x000fe200078ef809ULL, 0x000000ffff287224ULL, 0x000fe200008e06ffULL,
0x0000000415257c11ULL, 0x000fe2000f8240ffULL, 0x000000ffff247224ULL, 0x000fe200010e06ffULL,
0x0000000417147c11ULL, 0x000fe2000f8440ffULL, 0x000000ffff387224ULL, 0x000fe200000e06ffULL,
0x0000000515137c11ULL, 0x000fe200088f4428ULL, 0x0000000130097824ULL, 0x040fe200078e0209ULL,
0x0000000517157c11ULL, 0x000fe200090f4424ULL, 0x0000000830307824ULL, 0x000fe200078e00ffULL,
0x0000001b041b7210ULL, 0x000fe20007f3e0ffULL, 0x00004000343b7824ULL, 0x000fe200078e0207ULL,
0x0000001d041d7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff487224ULL, 0x000fe200018e06ffULL,
0x00000004194b7c11ULL, 0x000fe2000f8040ffULL, 0x000000ffff327224ULL, 0x000fe200008e06ffULL,
0x000000041b277c11ULL, 0x000fe2000f8240ffULL, 0x000000ffff287224ULL, 0x000fe200010e06ffULL,
0x000000041d247c11ULL, 0x000fe2000f8440ffULL, 0x000020003b477836ULL, 0x000fe20000000000ULL,
0x0000000519177c11ULL, 0x000fc400080f4438ULL, 0x000000051b197c11ULL, 0x000fe200088f4432ULL,
0x00000010113f7824ULL, 0x100fe200078e0247ULL, 0x0000002104217210ULL, 0x000fe20007f1e0ffULL,
0x000000102a417824ULL, 0x100fe200078e0247ULL, 0x000000051d1b7c11ULL, 0x000fe200090f4428ULL,
0x000000102c437824ULL, 0x100fe200078e0247ULL, 0x0000002b042b7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff3a7224ULL, 0x000fe200000e06ffULL, 0x0000002904297210ULL, 0x000fe20007f3e0ffULL,
0x000000102e457824ULL, 0x100fe200078e0247ULL, 0x00000004214a7c11ULL, 0x000fe2000f8040ffULL,
0x000000ffff327224ULL, 0x000fe200010e06ffULL, 0x000000042b287c11ULL, 0x000fe2000f8440ffULL,
0x000000ffff387224ULL, 0x000fe200008e06ffULL, 0x0000000429497c11ULL, 0x000fe2000f8240ffULL,
0x00000010163b7824ULL, 0x100fe200078e0247ULL, 0x00000005211d7c11ULL, 0x000fe200080f443aULL,
0x00000010123d7824ULL, 0x000fe200078e0247ULL, 0xfffffff830307812ULL, 0x000fc400078ee209ULL,
0x000000052b217c11ULL, 0x000fe200090f4432ULL, 0x00000010182b7824ULL, 0x100fe200078e0247ULL,
0x0000000529097c11ULL, 0x000fe200088f4438ULL, 0x0000001010297824ULL, 0x100fe200078e0247ULL,
0x0000002f04447210ULL, 0x000fe20007f5e0ffULL, 0x00000010222f7824ULL, 0x100fe200078e0247ULL,
0x0000003104407210ULL, 0x000fe20007f1e0ffULL, 0x0000001020317824ULL, 0x100fe200078e0247ULL,
0x00000033043c7210ULL, 0x000fe20007f3e0ffULL, 0x000000101f337824ULL, 0x100fe200078e0247ULL,
0x000000052d487c11ULL, 0x000fe2000b0f4448ULL, 0x00000010232d7824ULL, 0x100fe200078e0247ULL,
0x0000003504387210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff237224ULL, 0x000fe200010e06ffULL,
0x0000000444427c11ULL, 0x000fe2000f8440ffULL, 0x000000ffff1f7224ULL, 0x000fe200000e06ffULL,
0x0000003704327210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff117224ULL, 0x000fe200008e06ffULL,
0x00000004403e7c11ULL, 0x000fe2000f8040ffULL, 0x000000101e357824ULL, 0x100fe200078e0247ULL,
0x000000043c3a7c11ULL, 0x000fe2000f8240ffULL, 0x000000101c377824ULL, 0x100fe200078e0247ULL,
0x0000003904047210ULL, 0x000fe20007fbe0ffULL, 0x000000101a397824ULL, 0x000fe200078e0247ULL,
0x0000000544447c11ULL, 0x000fe200090f4423ULL, 0x000000ffff237224ULL, 0x000fe200018e06ffULL,
0x0000000540407c11ULL, 0x000fe200080f441fULL, 0x000000ffff1f7224ULL, 0x000fe200020e06ffULL,
0x000000053c3c7c11ULL, 0x000fe200088f4411ULL, 0x000000ffff117224ULL, 0x000fe200028e06ffULL,
0x00000004382a7c11ULL, 0x000fe2000f8240ffULL, 0x0000001030477824ULL, 0x000fe200078e0247ULL,
0x00000004322c7c11ULL, 0x000fc4000f8440ffULL, 0x00000004042e7c11ULL, 0x000fe4000f8640ffULL,
0x0000004c4d107210ULL, 0x000fe40007f1e0ffULL, 0x0000000538307c11ULL, 0x000fe400088f4423ULL,
0x00000005320e7c11ULL, 0x000fe400090f441fULL, 0x000000254d127210ULL, 0x000fe40007f3e0ffULL,
0x0000000504047c11ULL, 0x000fe200098f4411ULL, 0x000000ffff117224ULL, 0x000fe200000e0626ULL,
0x000000144d147210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff137224ULL, 0x000fe200008e0613ULL,
0x0000004b4d167210ULL, 0x000fc40007f7e0ffULL, 0x000000274d187210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff157224ULL, 0x000fe200010e0615ULL, 0x000000244d1a7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff177224ULL, 0x000fe200018e0617ULL, 0x0000004a4d1c7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff197224ULL, 0x000fe200028e0619ULL, 0x000000494d1e7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff1b7224ULL, 0x000fe200020e061bULL, 0x000000284d207210ULL, 0x000fe20007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010297faeULL, 0x0003e2000b901c48ULL,
0x000000464d227210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff1d7224ULL, 0x000fe200000e061dULL,
0x000000424d247210ULL, 0x000fe20007fbe0ffULL, 0x00000000122b7faeULL, 0x0005e2000b901c48ULL,
0x0000003e4d267210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff1f7224ULL, 0x000fe200008e0609ULL,
0x0000003a4d287210ULL, 0x000fe20007f1e0ffULL, 0x00000000142d7faeULL, 0x0007e2000b901c48ULL,
0x0000002a4d2a7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff217224ULL, 0x000fe200010e0621ULL,
0x0000002c4d2c7210ULL, 0x000fe20007f5e0ffULL, 0x00000000162f7faeULL, 0x000be2000b901c48ULL,
0x000000ffff237224ULL, 0x000fe200018e0648ULL, 0x0000002e4d2e7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff257224ULL, 0x000fe200028e0644ULL, 0x0000000018317faeULL, 0x000be2000b901c48ULL,
0x000000ffff277224ULL, 0x000fc400020e0640ULL, 0x000000ffff297224ULL, 0x002fe200000e063cULL,
0x000000001a337faeULL, 0x0003e2000b901c48ULL, 0x000000ffff2b7224ULL, 0x004fe400008e0630ULL,
0x000000ffff2d7224ULL, 0x008fe200010e060eULL, 0x000000001c357faeULL, 0x0003e2000b901c48ULL,
0x000000ffff2f7224ULL, 0x020fc600018e0604ULL, 0x000000001e377faeULL, 0x0003e8000b901c48ULL,
0x0000000020397faeULL, 0x0003e8000b901c48ULL, 0x00000000223b7faeULL, 0x0003e8000b901c48ULL,
0x00000000243d7faeULL, 0x0003e8000b901c48ULL, 0x00000000263f7faeULL, 0x0003e8000b901c48ULL,
0x0000000028417faeULL, 0x0003e8000b901c48ULL, 0x000000002a437faeULL, 0x0003e8000b901c48ULL,
0x000000002c457faeULL, 0x0003e8000b901c48ULL, 0x000000002e477faeULL, 0x0003e4000b901c48ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000107805ULL, 0x002fce0000015200ULL,
0x0186000d070075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff0e7224ULL, 0x000fce00078e00ffULL, 0x000000100e00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fce0000015200ULL,
0x0000001210097210ULL, 0x000fca0007f1e1ffULL, 0x0000000113127824ULL, 0x000fe200000e0e11ULL,
0x003d09000900780cULL, 0x000fc80003f06070ULL, 0x000000ff1200720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400900780cULL, 0x000fc80003f06070ULL,
0x000000ff1200720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc80000011412ULL, 0x0000000904047211ULL, 0x000fca00078110ffULL,
0x000000ffff097224ULL, 0x000fca00000e0612ULL, 0x0000000204047819ULL, 0x000fc80000001209ULL,
0x000000040000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000010e0e7836ULL, 0x000fce0000000000ULL, 0x0186000d070075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000000097919ULL, 0x000e640000000000ULL,
0x0000002034047824ULL, 0x002fca00078e0209ULL, 0x00000003ff097819ULL, 0x000fe40000011604ULL,
0x0000000f04047812ULL, 0x000fe400078ec0ffULL, 0x1ffffffe09097812ULL, 0x000fc600078ec0ffULL,
0x00000001040c7836ULL, 0x000fe40000000000ULL, 0x00000001040d7824ULL, 0x040fe400078e0209ULL,
0x00000001090e7824ULL, 0x000fe400078e020cULL, 0x0000002004117824ULL, 0x040fe200078e00ffULL,
0x0000001f0d0d7812ULL, 0x000fe200078ec0ffULL, 0x0000002004127824ULL, 0x000fe200078e00ffULL,
0x0000001f0e0e7812ULL, 0x000fe200078ec0ffULL, 0x0000001009097836ULL, 0x000fc60000000000ULL,
0x000001e011107812ULL, 0x000fe400078ee20eULL, 0x000001e0120e7812ULL, 0x000fe200078ee20dULL,
0x00000001040d7824ULL, 0x000fe400078e0209ULL, 0x0000001010107824ULL, 0x100fe400078e0207ULL,
0x000000100e0e7824ULL, 0x000fe200078e0207ULL, 0x0000001f0d0d7812ULL, 0x000fe200078ec0ffULL,
0x000000010c097824ULL, 0x000fe200078e0209ULL, 0x0000000010147984ULL, 0x000e620000000c00ULL,
0x00000020040c7824ULL, 0x000fc600078e00ffULL, 0x000000000e187984ULL, 0x000ea20000000c00ULL,
0x0000001f09097812ULL, 0x000fe400078ec0ffULL, 0x000001e00c047812ULL, 0x000fe400078ee20dULL,
0x000001e0120c7812ULL, 0x000fe200078ee209ULL, 0x00000001ff127424ULL, 0x000fe400078e00ffULL,
0x0000001004047824ULL, 0x100fe400078e0207ULL, 0x000000100c0c7824ULL, 0x000fc400078e0207ULL,
0x000000ffff1e7224ULL, 0x002fe400078e0014ULL, 0x000000ffff1f7224ULL, 0x000fe400078e0016ULL,
0x000000ffff1c7224ULL, 0x004fe400078e0018ULL, 0x000000ffff1d7224ULL, 0x000fe400078e001aULL,
0x000000ffff227224ULL, 0x000fe400078e0015ULL, 0x000000ffff237224ULL, 0x000fe200078e0017ULL,
0x0000001c0e007388ULL, 0x000fe20000000c00ULL, 0x000000ffff207224ULL, 0x000fc400078e0019ULL,
0x000000ffff217224ULL, 0x000fca00078e001bULL, 0x0000002010007388ULL, 0x000fe80000000c00ULL,
0x000000000c147984ULL, 0x000e680000000c00ULL, 0x0000000004187984ULL, 0x000ea20000000c00ULL,
0x000000ffff277224ULL, 0x002fe400078e0016ULL, 0x000000ffff267224ULL, 0x000fc400078e0014ULL,
0x000000ffff167224ULL, 0x000fe400078e0015ULL, 0x000000ffff247224ULL, 0x004fe400078e0018ULL,
0x000000ffff257224ULL, 0x000fe400078e001aULL, 0x000000ffff147224ULL, 0x000fe400078e0019ULL,
0x000000ffff157224ULL, 0x000fe200078e001bULL, 0x0000002404007388ULL, 0x0003e80000000c00ULL,
0x000000140c007388ULL, 0x0003e20000000c00ULL, 0x01860012071279a7ULL, 0x0002a4000850003fULL,
0x00000000000c7805ULL, 0x002fce0000015200ULL, 0x01860013070075a7ULL, 0x004e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff0e7224ULL, 0x000fce00078e00ffULL,
0x000000100e00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000107805ULL, 0x000fce0000015200ULL, 0x000000100c097210ULL, 0x000fca0007f1e1ffULL,
0x0000000111107824ULL, 0x000fe200000e0e0dULL, 0x003d09000900780cULL, 0x000fc80003f06070ULL,
0x000000ff1000720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400900780cULL, 0x000fc80003f06070ULL, 0x000000ff1000720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc80000011410ULL,
0x0000000904047211ULL, 0x000fca00078110ffULL, 0x000000ffff097224ULL, 0x000fca00000e0610ULL,
0x0000000204047819ULL, 0x000fc80000001209ULL, 0x000000040000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000010e0e7836ULL, 0x000fce0000000000ULL,
0x01860013070075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000ff0500720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000047919ULL, 0x000e620000000000ULL, 0x0000900000047ab9ULL, 0x000fe20000000800ULL,
0x3d8000000a097820ULL, 0x010fe20000410000ULL, 0x00000008340a7824ULL, 0x140fe400078e0207ULL,
0xffffffff050c7836ULL, 0x000fe40000000000ULL, 0x00000020340d7824ULL, 0x000fe400078e0207ULL,
0x000000ffff357224ULL, 0x000fe400078e00ffULL, 0x000000ffff0e7224ULL, 0x000fc400078e00ffULL,
0x0000000436367c24ULL, 0x000fce000f8e02ffULL, 0x0000010035407824ULL, 0x000fca00078e0202ULL,
0x000000400f00720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x012fea0003800000ULL,
0x000000ffff107224ULL, 0x000fe200078e000eULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff377224ULL, 0x000fe200078e00ffULL, 0x0000000000187805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fe4000001ff00ULL, 0x0000000000247805ULL, 0x000fc4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fc4000001ff00ULL,
0x00000000003a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000387805ULL, 0x000fe4000001ff00ULL,
0x00000000003e7805ULL, 0x000fe4000001ff00ULL, 0x00000000003c7805ULL, 0x000fce000001ff00ULL,
0x0000000137147836ULL, 0x000fe40000000000ULL, 0x000000ffff447224ULL, 0x000fe400078e0037ULL,
0x0000000b00127224ULL, 0x010fe200078e02ffULL, 0x0000003514117211ULL, 0x040fe200078ff8ffULL,
0x000000ffff377224ULL, 0x000fe200078e0014ULL, 0x000000021400780cULL, 0x000fc60003f06070ULL,
0x00000001110e7836ULL, 0x000fe40000000000ULL, 0x0000010011167824ULL, 0x000fe200078e0202ULL,
0x0000000114117812ULL, 0x000fe400078ec0ffULL, 0x000000050e00720cULL, 0x000fe40003f26070ULL,
0x0000004016417812ULL, 0x000fe400078ec0ffULL, 0x00000001100e7812ULL, 0x000fc600078e0cffULL,
0x0000000108417824ULL, 0x000fcc00078e0241ULL, 0x0000000c00709947ULL, 0x000fea0003800000ULL,
0x00000003ff667819ULL, 0x102fe20000011604ULL, 0x00008a0000047ab9ULL, 0x000fe20000000a00ULL,
0x000000160f457248ULL, 0x000fe20007fe0000ULL, 0x0000000811597824ULL, 0x000fe400078e00ffULL,
0x0000000466147836ULL, 0x000fe40000000000ULL, 0x00000008661e7836ULL, 0x000fe20000000000ULL,
0xfffffff859597812ULL, 0x000fe200078ee204ULL, 0x00000001146c7824ULL, 0x040fe400078e0204ULL,
0x0000000814137824ULL, 0x000fc400078e00ffULL, 0x000000011e6a7824ULL, 0x040fe400078e0204ULL,
0x000000081e157824ULL, 0x000fe200078e00ffULL, 0xfffffff8136c7812ULL, 0x000fe200078ee26cULL,
0x0000000166137824ULL, 0x100fe400078e0241ULL, 0x0000000145457824ULL, 0x000fe200078e0a16ULL,
0xfffffff8156a7812ULL, 0x000fe200078ee26aULL, 0x0000000114157824ULL, 0x140fe200078e0241ULL,
0x0000001312167210ULL, 0x000fe20007f3e0ffULL, 0x0000000c661c7836ULL, 0x000fe20000000000ULL,
0x000000451400720cULL, 0x080fe20003f86070ULL, 0x000000011e137824ULL, 0x100fe200078e0241ULL,
0x0000001512147210ULL, 0x000fe20007f5e0ffULL, 0x000000011c157824ULL, 0x000fe200078e0241ULL,
0x000000451e00720cULL, 0x000fe20003fa6070ULL, 0x000000ffff1d7224ULL, 0x000fe200008e06ffULL,
0x00000004164c7c11ULL, 0x000fe2000f8240ffULL, 0x000000ffff177224ULL, 0x000fe200010e06ffULL,
0x0000001312137210ULL, 0x000fe20007f7e0ffULL, 0x0000001066567836ULL, 0x000fe20000000000ULL,
0x0000000414547c11ULL, 0x000fe2000f8440ffULL, 0x00000014666e7836ULL, 0x000fe20000000000ULL,
0x00000005164d7c11ULL, 0x000fe200088f441dULL, 0x000000ffff167224ULL, 0x000fe200018e06ffULL,
0x0000001512157210ULL, 0x000fe20007fde0ffULL, 0x0000001866687836ULL, 0x000fe20000000000ULL,
0x0000000413527c11ULL, 0x000fe2000f8240ffULL, 0x0000001c66607836ULL, 0x000fe20000000000ULL,
0x0000000514557c11ULL, 0x000fe200090f4417ULL, 0x000000ffff147224ULL, 0x000fe200030e06ffULL,
0x0000000415507c11ULL, 0x000fe2000f8440ffULL, 0x0000002066647836ULL, 0x000fe20000000000ULL,
0x0000000513537c11ULL, 0x000fe200088f4416ULL, 0x0000000156137824ULL, 0x100fe200078e0241ULL,
0x0000000515517c11ULL, 0x000fe200090f4414ULL, 0x000000016e157824ULL, 0x000fc400078e0241ULL,
0x0000002466627836ULL, 0x000fe20000000000ULL, 0x0000001312167210ULL, 0x000fe20007f3e0ffULL,
0x0000000168137824ULL, 0x100fe200078e0241ULL, 0x0000001512147210ULL, 0x000fe20007f5e0ffULL,
0x0000000160157824ULL, 0x000fe400078e0241ULL, 0x000000ffff1d7224ULL, 0x000fe200008e06ffULL,
0x00000004164e7c11ULL, 0x000fe2000f8240ffULL, 0x000000ffff177224ULL, 0x000fe200010e06ffULL,
0x0000001312137210ULL, 0x000fe20007f7e0ffULL, 0x0000002866587836ULL, 0x000fe20000000000ULL,
0x00000004141e7c11ULL, 0x000fe2000f8440ffULL, 0x0000002c665a7836ULL, 0x000fe20000000000ULL,
0x00000005164f7c11ULL, 0x000fe200088f441dULL, 0x000000ffff167224ULL, 0x000fe200018e06ffULL,
0x0000001512157210ULL, 0x000fe20007fde0ffULL, 0x000000011c707824ULL, 0x140fe200078e0204ULL,
0x0000000413427c11ULL, 0x000fe2000f8240ffULL, 0x000000081c5f7824ULL, 0x000fe200078e00ffULL,
0x00000005141f7c11ULL, 0x000fe200090f4417ULL, 0x000000ffff147224ULL, 0x000fe200030e06ffULL,
0x00000004154a7c11ULL, 0x000fe2000f8440ffULL, 0x0000000156727824ULL, 0x000fe200078e0204ULL,
0x0000000513437c11ULL, 0x000fe200088f4416ULL, 0x0000000164137824ULL, 0x100fe200078e0241ULL,
0x00000005154b7c11ULL, 0x000fe200090f4414ULL, 0x0000000162157824ULL, 0x100fe200078e0241ULL,
0xfffffff85f707812ULL, 0x000fe200078ee270ULL, 0x0000000856617824ULL, 0x000fe200078e00ffULL,
0x0000001312167210ULL, 0x000fe20007f3e0ffULL, 0x0000000158137824ULL, 0x100fe200078e0241ULL,
0x0000001512147210ULL, 0x000fe20007f5e0ffULL, 0x000000015a157824ULL, 0x000fe200078e0241ULL,
0xfffffff861727812ULL, 0x000fe200078ee272ULL, 0x000000ffff177224ULL, 0x000fe200008e06ffULL,
0x0000000416487c11ULL, 0x000fe2000f8240ffULL, 0x000000ffff1d7224ULL, 0x000fe200010e06ffULL,
0x0000001312137210ULL, 0x000fe20007f7e0ffULL, 0x000000016e637824ULL, 0x000fe200078e0204ULL,
0x0000000414467c11ULL, 0x000fe2000f8440ffULL, 0x0000001059547825ULL, 0x000fe200078e0054ULL,
0x0000000516497c11ULL, 0x000fc400088f4417ULL, 0x0000001512177210ULL, 0x000fe20007fde0ffULL,
0x000000ffff5e7224ULL, 0x000fe200018e06ffULL, 0x0000000514477c11ULL, 0x000fe200090f441dULL,
0x00000001661d7824ULL, 0x000fe200078e0204ULL, 0x0000000413147c11ULL, 0x000fe2000f8240ffULL,
0x000000ffff5c7224ULL, 0x000fe200030e06ffULL, 0x0000000417167c11ULL, 0x000fe2000f8440ffULL,
0x0000001059527825ULL, 0x000fe200078e0052ULL, 0x0000000513157c11ULL, 0x000fe400088f445eULL,
0x0000000517177c11ULL, 0x000fe200090f445cULL, 0x0000400034137824ULL, 0x000fe200078e0207ULL,
0x000000071d577812ULL, 0x000fe200078ec0ffULL, 0x00000030665c7836ULL, 0x000fe20000000000ULL,
0x000000456600720cULL, 0x080fe20003f66070ULL, 0x000020000e5b7824ULL, 0x000fe200078e0213ULL,
0x000000451c00720cULL, 0x080fe20003f26070ULL, 0x000000015c1d7824ULL, 0x000fe200078e0241ULL,
0x0ffffff8571c7812ULL, 0x000fe200078ef804ULL, 0x000020005b5b7836ULL, 0x000fe20000000000ULL,
0x000000455600720cULL, 0x000fe20003f46070ULL, 0x0000001059567825ULL, 0x000fe200078e004cULL,
0x0000001d121d7210ULL, 0x000fc60007fde0ffULL, 0x000000101c5d7824ULL, 0x000fe400078e025bULL,
0x00000034665e7836ULL, 0x000fe40000000000ULL, 0x000000ffff747224ULL, 0x000fe200030e06ffULL,
0x000000041d1c7c11ULL, 0x040fe2000f8c40ffULL, 0x000000015e4d7824ULL, 0x000fe200078e0241ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000565d7faeULL, 0x0003e2000d901c48ULL,
0x000000456e00720cULL, 0x0c0fe20003f66070ULL, 0x000000086e6e7824ULL, 0x000fe200078e00ffULL,
0x000000051d1d7c11ULL, 0x000fe2000b0f4474ULL, 0x000000106c5f7824ULL, 0x100fe200078e025bULL,
0x0000004d124d7210ULL, 0x000fe20007fde0ffULL, 0x000000106a617824ULL, 0x000fe200078e025bULL,
0xfffffff86e6a7812ULL, 0x000fe200078ee263ULL, 0x0000001059507825ULL, 0x000fe200078e0050ULL,
0x00000000545f7faeULL, 0x000fe6000e101c48ULL, 0x0000003866567836ULL, 0x002fe20000000000ULL,
0x0000000052617faeULL, 0x0003e2000e901c48ULL, 0x000000ffff6c7224ULL, 0x000fe200030e06ffULL,
0x000000044d4c7c11ULL, 0x040fe2000f8c40ffULL, 0x0000000156577824ULL, 0x000fe200078e0241ULL,
0x000000456800720cULL, 0x000fe20003fa6070ULL, 0x0000003c66667836ULL, 0x000fe20000000000ULL,
0x000000054d4d7c11ULL, 0x000fe2000b0f446cULL, 0x00000010594e7825ULL, 0x000fe200078e004eULL,
0x0000005712637210ULL, 0x000fc60007f9e0ffULL, 0x00000001665d7824ULL, 0x000fe200078e0241ULL,
0x0000000463527c11ULL, 0x042fe2000f8c40ffULL, 0x0000001070417824ULL, 0x100fe400078e025bULL,
0x000000ffff547224ULL, 0x000fe200020e06ffULL, 0x0000005d125d7210ULL, 0x000fe20007f9e0ffULL,
0x0000001072577824ULL, 0x000fe200078e025bULL, 0x0000000050417faeULL, 0x0003e2000c901c48ULL,
0x0000000168657824ULL, 0x040fe200078e0204ULL, 0x0000000563537c11ULL, 0x000fe2000b0f4454ULL,
0x0000000868687824ULL, 0x000fe200078e00ffULL, 0x000000004e577faeULL, 0x0005e2000d101c48ULL,
0x0000000160547824ULL, 0x100fe200078e0204ULL, 0x000000456400720cULL, 0x080fe20003f26070ULL,
0x0000000860617824ULL, 0x040fe200078e00ffULL, 0x000000456000720cULL, 0x000fe20003f46070ULL,
0x0000000164557824ULL, 0x140fe200078e0204ULL, 0xfffffff868687812ULL, 0x000fe200078ee265ULL,
0x0000000864647824ULL, 0x000fe200078e00ffULL, 0xfffffff861547812ULL, 0x000fe200078ee254ULL,
0x00000001625f7824ULL, 0x000fc400078e0204ULL, 0x0000000862607824ULL, 0x040fe200078e00ffULL,
0xfffffff864507812ULL, 0x002fe200078ee255ULL, 0x000000ffff127224ULL, 0x000fe200020e06ffULL,
0x000000456200720cULL, 0x080fe20003f86070ULL, 0x000000106a417824ULL, 0x000fe200078e025bULL,
0x000000045d4e7c11ULL, 0x004fe2000f8c40ffULL, 0x00000010591e7825ULL, 0x000fe200078e001eULL,
0xfffffff860607812ULL, 0x000fe400078ee25fULL, 0x000000055d4f7c11ULL, 0x000fe2000b0f4412ULL,
0x0000001068517824ULL, 0x000fe200078e025bULL, 0x000000001e417faeULL, 0x0003e2000d901c48ULL,
0x0000001059427825ULL, 0x000fe200078e0042ULL, 0x000000455c00720cULL, 0x000fc40003f66070ULL,
0x000000456600720cULL, 0x080fe20003fc6070ULL, 0x0000001054557824ULL, 0x000fe200078e025bULL,
0x0000000042517faeULL, 0x0005e2000e901c48ULL, 0x00000010594a7825ULL, 0x000fe200078e004aULL,
0x000000455600720cULL, 0x000fc60003fa6070ULL, 0x0000001050577824ULL, 0x000fe200078e025bULL,
0x000000004a557faeULL, 0x000fe2000d101c48ULL, 0x0000001059487825ULL, 0x000fe200078e0048ULL,
0x000000455a00720cULL, 0x000fc60003f46070ULL, 0x00000010605d7824ULL, 0x000fe200078e025bULL,
0x0000000048577faeULL, 0x000fe2000c901c48ULL, 0x0000001059467825ULL, 0x000fe200078e0046ULL,
0x000000455800720cULL, 0x000fc60003f26070ULL, 0x0000000158127824ULL, 0x140fe200078e0204ULL,
0x00000000465d7faeULL, 0x0009e2000e101c48ULL, 0x00000008585f7824ULL, 0x000fe200078e00ffULL,
0x000000455e00720cULL, 0x000fe20003f86070ULL, 0x000000015a507824ULL, 0x140fe400078e0204ULL,
0x000000085a617824ULL, 0x000fe200078e00ffULL, 0xfffffff85f127812ULL, 0x000fe200078ee212ULL,
0x000000015c1e7824ULL, 0x142fe400078e0204ULL, 0x000000085c457824ULL, 0x000fe200078e00ffULL,
0xfffffff861507812ULL, 0x000fe200078ee250ULL, 0x000000015e1f7824ULL, 0x000fc400078e0204ULL,
0x000000085e427824ULL, 0x004fe200078e00ffULL, 0xfffffff8451e7812ULL, 0x000fe200078ee21eULL,
0x0000000156417824ULL, 0x140fe400078e0204ULL, 0x0000000856467824ULL, 0x010fe200078e00ffULL,
0xfffffff842427812ULL, 0x000fe200078ee21fULL, 0x0000000166437824ULL, 0x040fe400078e0204ULL,
0x0000000866487824ULL, 0x000fe200078e00ffULL, 0xfffffff846467812ULL, 0x000fe200078ee241ULL,
0x00000010121f7824ULL, 0x000fc400078e025bULL, 0x0000001059147825ULL, 0x000fe200078e0014ULL,
0xfffffff848487812ULL, 0x000fc600078ee243ULL, 0x0000001050417824ULL, 0x000fe200078e025bULL,
0x00000000141f7faeULL, 0x0007e2000c901c48ULL, 0x0000001059167825ULL, 0x000fc800078e0016ULL,
0x000000101e437824ULL, 0x000fe200078e025bULL, 0x0000000016417faeULL, 0x0007e2000d101c48ULL,
0x00000010591c7825ULL, 0x000fc800078e001cULL, 0x0000001042457824ULL, 0x000fe200078e025bULL,
0x000000001c437faeULL, 0x0007e2000d901c48ULL, 0x00000010594c7825ULL, 0x000fc800078e004cULL,
0x0000001046477824ULL, 0x000fe200078e025bULL, 0x000000004c457faeULL, 0x0007e2000e101c48ULL,
0x0000001059527825ULL, 0x000fc800078e0052ULL, 0x00000010485b7824ULL, 0x000fe200078e025bULL,
0x0000000052477faeULL, 0x0007e2000e901c48ULL, 0x00000010594e7825ULL, 0x000fca00078e004eULL,
0x000000004e5b7faeULL, 0x0007e2000f101c48ULL, 0x0000000c00207947ULL, 0x000fea0003800000ULL,
0x0000001004517811ULL, 0x042fe200078fe8ffULL, 0x00008a0000047ab9ULL, 0x000fe20000000a00ULL,
0x0000000404147811ULL, 0x040fe200078fe8ffULL, 0x00000008116f7824ULL, 0x000fe200078e00ffULL,
0x0000001c04487811ULL, 0x040fe200078fe8ffULL, 0x0000000151677824ULL, 0x140fe200078e0204ULL,
0x0000001404527811ULL, 0x040fe200078fe8ffULL, 0x0000000851427824ULL, 0x000fe200078e00ffULL,
0x00000024044c7811ULL, 0x000fe200078fe8ffULL, 0x00000001146d7824ULL, 0x100fe200078e0204ULL,
0x00000008044f7811ULL, 0x000fe200078fe8ffULL, 0x0000000814167824ULL, 0x000fe200078e00ffULL,
0xfffffff842677812ULL, 0x000fe200078ee267ULL, 0x0000000148457824ULL, 0x100fe200078e0204ULL,
0x0000000c04507811ULL, 0x000fe200078fe8ffULL, 0x0000000848427824ULL, 0x000fe200078e00ffULL,
0xfffffff8166d7812ULL, 0x000fe200078ee26dULL, 0x0000000152657824ULL, 0x100fe200078e0204ULL,
0x0000002c04437811ULL, 0x000fe200078fe8ffULL, 0x0000000852167824ULL, 0x000fe200078e00ffULL,
0xfffffff842457812ULL, 0x000fe200078ee245ULL, 0x000000014c1d7824ULL, 0x100fe200078e0204ULL,
0x0000003004427811ULL, 0x000fe200078fe8ffULL, 0x000000084c4a7824ULL, 0x000fe200078e00ffULL,
0xfffffff816657812ULL, 0x000fe200078ee265ULL, 0x000000014f6b7824ULL, 0x140fe200078e0204ULL,
0x0000001804497811ULL, 0x000fe200078fe8ffULL, 0x0000000142167824ULL, 0x100fe200078e0204ULL,
0x0000002004477811ULL, 0x000fe200078fe8ffULL, 0x0000000842157824ULL, 0x000fe200078e00ffULL,
0xfffffff84a1d7812ULL, 0x000fe200078ee21dULL, 0x000000084f1c7824ULL, 0x000fe200078e00ffULL,
0x0000002804467811ULL, 0x000fe200078fe8ffULL, 0x0000000150697824ULL, 0x140fe200078e0204ULL,
0xfffffff815167812ULL, 0x000fe200078ee216ULL, 0x00000008501e7824ULL, 0x000fe200078e00ffULL,
0x0000004104157211ULL, 0x000fe200078fe8ffULL, 0x0000000143177824ULL, 0x140fe200078e0204ULL,
0xfffffff81c6b7812ULL, 0x000fe200078ee26bULL, 0x00000008434e7824ULL, 0x000fe200078e00ffULL,
0x00000015124d7210ULL, 0x000fe20007f3e0ffULL, 0x0000000114157824ULL, 0x100fe200078e0241ULL,
0xfffffff81e697812ULL, 0x000fe200078ee269ULL, 0x0000000149637824ULL, 0x140fe200078e0204ULL,
0xfffffff84e177812ULL, 0x000fe200078ee217ULL, 0x00000008491c7824ULL, 0x000fe200078e00ffULL,
0x00000015124a7210ULL, 0x000fe20007f5e0ffULL, 0x00000001471e7824ULL, 0x140fe200078e0204ULL,
0x00000034041f7811ULL, 0x000fe200078fe8ffULL, 0x0000000847137824ULL, 0x000fe200078e00ffULL,
0xfffffff81c637812ULL, 0x000fe200078ee263ULL, 0x000000ffff4e7224ULL, 0x000fe200008e06ffULL,
0x000000044d607c11ULL, 0x040fe2000f8240ffULL, 0x000000ffff4b7224ULL, 0x000fe200010e06ffULL,
0x000000044a5e7c11ULL, 0x000fe2000f8440ffULL, 0x00000001461c7824ULL, 0x040fe200078e0204ULL,
0xfffffff8131e7812ULL, 0x000fe200078ee21eULL, 0x0000000846137824ULL, 0x000fe200078e00ffULL,
0x000000054d617c11ULL, 0x000fe200088f444eULL, 0x00000001504d7824ULL, 0x000fe200078e0241ULL,
0x000000054a5f7c11ULL, 0x000fe200090f444bULL, 0x000000014f4b7824ULL, 0x100fe200078e0241ULL,
0xfffffff8131c7812ULL, 0x000fe200078ee21cULL, 0x00000001514f7824ULL, 0x100fe200078e0241ULL,
0x0000003804137811ULL, 0x000fe200078fe8ffULL, 0x000000011f147824ULL, 0x140fe200078e0204ULL,
0x0000004d124d7210ULL, 0x000fe20007f7e0ffULL, 0x000000081f557824ULL, 0x000fe200078e00ffULL,
0x0000004f124f7210ULL, 0x000fe20007f9e0ffULL, 0x0000000152517824ULL, 0x100fe200078e0241ULL,
0x0000004b124b7210ULL, 0x000fe20007f5e0ffULL, 0x0000000113537824ULL, 0x040fe200078e0204ULL,
0xfffffff855157812ULL, 0x000fe200078ee214ULL, 0x0000000813547824ULL, 0x000fe200078e00ffULL,
0x0000005112517210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff527224ULL, 0x000fe200018e06ffULL,
0x000000044d5c7c11ULL, 0x000fe2000f8640ffULL, 0x000000ffff507224ULL, 0x000fe200020e06ffULL,
0x000000044f5a7c11ULL, 0x000fe2000f8840ffULL, 0x0000000147477824ULL, 0x100fe200078e0241ULL,
0xfffffff854147812ULL, 0x000fe200078ee253ULL, 0x000000ffff547224ULL, 0x000fe200010e06ffULL,
0x000000054d5d7c11ULL, 0x000fe200098f4452ULL, 0x0000000149497824ULL, 0x100fe200078e0241ULL,
0x000000044b4a7c11ULL, 0x000fe2000f8440ffULL, 0x00000001484d7824ULL, 0x100fe200078e0241ULL,
0x000000054f5b7c11ULL, 0x000fe2000a0f4450ULL, 0x000000ffff4e7224ULL, 0x000fe200008e06ffULL,
0x0000004712477210ULL, 0x000fe20007f9e0ffULL, 0x000000014c4f7824ULL, 0x100fe200078e0241ULL,
0x0000000451587c11ULL, 0x000fe2000f8240ffULL, 0x0000000113137824ULL, 0x100fe200078e0241ULL,
0x000000054b4b7c11ULL, 0x000fe200090f4454ULL, 0x000000ffff4c7224ULL, 0x000fe200020e06ffULL,
0x0000004912497210ULL, 0x000fe20007f5e0ffULL, 0x0000000143437824ULL, 0x000fe200078e0241ULL,
0x0000004d124d7210ULL, 0x000fc40007f7e0ffULL, 0x0000000551597c11ULL, 0x000fe200088f444eULL,
0x000000ffff627224ULL, 0x000fe200010e06ffULL, 0x0000000447527c11ULL, 0x000fe2000f8840ffULL,
0x000000ffff4e7224ULL, 0x000fe200018e06ffULL, 0x0000004f124f7210ULL, 0x000fe40007f3e0ffULL,
0x0000000449567c11ULL, 0x000fe4000f8440ffULL, 0x000000044d547c11ULL, 0x000fe2000f8640ffULL,
0x000000ffff487224ULL, 0x000fe200008e06ffULL, 0x0000000547537c11ULL, 0x000fe2000a0f444cULL,
0x0000000146477824ULL, 0x000fe200078e0241ULL, 0x0000003c044c7811ULL, 0x000fc400078fe8ffULL,
0x000000044f507c11ULL, 0x000fe4000f8240ffULL, 0x0000000549577c11ULL, 0x000fe200090f4462ULL,
0x0000000142497824ULL, 0x100fe200078e0241ULL, 0x000000054d557c11ULL, 0x000fe200098f444eULL,
0x000000011f4d7824ULL, 0x100fe200078e0241ULL, 0x000000054f517c11ULL, 0x000fe200088f4448ULL,
0x000000014c417824ULL, 0x000fe200078e0241ULL, 0x0000000404487211ULL, 0x000fe400078fe8ffULL,
0x0000001312627210ULL, 0x000fe20007f5e0ffULL, 0x0000400034137824ULL, 0x000fe200078e0207ULL,
0x0000004712477210ULL, 0x000fc40007fde0ffULL, 0x0000004112647210ULL, 0x000fe20007f7e0ffULL,
0x000020000e467824ULL, 0x000fe200078e0213ULL, 0x0000004312427210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff757224ULL, 0x000fe200010e06ffULL, 0x0000000748417812ULL, 0x000fe200078ec0ffULL,
0x000000014c487824ULL, 0x040fe200078e0204ULL, 0x00000049121f7210ULL, 0x000fe20007f9e0ffULL,
0x000000084c497824ULL, 0x000fe200078e00ffULL, 0x0000004d12437210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff127224ULL, 0x000fe200030e06ffULL, 0x00000004474e7c11ULL, 0x000fe2000f8c40ffULL,
0x0000200046467836ULL, 0x000fe20000000000ULL, 0x0ffffff841417812ULL, 0x000fe200078ef804ULL,
0x000000ffff687224ULL, 0x000fe200020e06ffULL, 0xfffffff86f6f7812ULL, 0x000fe200078ee204ULL,
0x000000106d6d7824ULL, 0x100fe200078e0246ULL, 0xfffffff849497812ULL, 0x000fe200078ee248ULL,
0x0000001041717824ULL, 0x000fe200078e0246ULL, 0x00000005474f7c11ULL, 0x000fe2000b0f4412ULL,
0x000000ffff477224ULL, 0x000fe200028e06ffULL, 0x00000004424c7c11ULL, 0x000fe2000f8a40ffULL,
0x000000106f607825ULL, 0x000fe200078e0060ULL, 0x000000041f487c11ULL, 0x000fc4000f8840ffULL,
0x00000005424d7c11ULL, 0x000fe2000a8f4447ULL, 0x000000106f5e7825ULL, 0x000fe200078e005eULL,
0x0000000462427c11ULL, 0x000fe2000f8440ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000060717faeULL, 0x0003e4000b901c48ULL, 0x000000106b6b7824ULL, 0x000fe400078e0246ULL,
0x000000106f4a7825ULL, 0x000fe200078e004aULL, 0x000000005e6d7faeULL, 0x0003e6000b901c48ULL,
0x0000001069697824ULL, 0x100fe200078e0246ULL, 0x000000004a6b7faeULL, 0x0003e2000b901c48ULL,
0x0000001067677824ULL, 0x000fc400078e0246ULL, 0x0000001065657824ULL, 0x100fe400078e0246ULL,
0x0000001063637824ULL, 0x100fe400078e0246ULL, 0x0000001045457824ULL, 0x100fe400078e0246ULL,
0x000000101e417824ULL, 0x100fe400078e0246ULL, 0x000000101d1d7824ULL, 0x100fe400078e0246ULL,
0x000000101c1c7824ULL, 0x000fc400078e0246ULL, 0x0000001017177824ULL, 0x100fe400078e0246ULL,
0x0000001016167824ULL, 0x100fe400078e0246ULL, 0x0000001015157824ULL, 0x100fe400078e0246ULL,
0x0000001014147824ULL, 0x100fe400078e0246ULL, 0x0000001049127824ULL, 0x000fe200078e0246ULL,
0x000000051f497c11ULL, 0x000fe2000a0f4468ULL, 0x000000ffff667224ULL, 0x000fe200008e06ffULL,
0x0000000443467c11ULL, 0x000fe2000f8240ffULL, 0x000000106f5c7825ULL, 0x000fc600078e005cULL,
0x0000000543477c11ULL, 0x000fe200088f4466ULL, 0x000000106f5a7825ULL, 0x040fe200078e005aULL,
0x000000005c697faeULL, 0x0003e2000b901c48ULL, 0x0000000562437c11ULL, 0x000fe400090f4475ULL,
0x000000ffff737224ULL, 0x000fe200018e06ffULL, 0x00000004641e7c11ULL, 0x040fe2000f8640ffULL,
0x000000106f587825ULL, 0x040fe200078e0058ULL, 0x000000005a677faeULL, 0x0003e4000b901c48ULL,
0x00000005641f7c11ULL, 0x000fe200098f4473ULL, 0x000000106f567825ULL, 0x040fe200078e0056ULL,
0x0000000058657faeULL, 0x0003e6000b901c48ULL, 0x000000106f547825ULL, 0x040fe200078e0054ULL,
0x0000000056637faeULL, 0x0003e6000b901c48ULL, 0x000000106f527825ULL, 0x040fe200078e0052ULL,
0x0000000054457faeULL, 0x0003e6000b901c48ULL, 0x000000106f507825ULL, 0x040fe200078e0050ULL,
0x0000000052417faeULL, 0x0003e6000b901c48ULL, 0x000000106f4e7825ULL, 0x040fe200078e004eULL,
0x00000000501d7faeULL, 0x0003e6000b901c48ULL, 0x000000106f4c7825ULL, 0x040fe200078e004cULL,
0x000000004e1c7faeULL, 0x0003e6000b901c48ULL, 0x000000106f487825ULL, 0x040fe200078e0048ULL,
0x000000004c177faeULL, 0x0003e6000b901c48ULL, 0x000000106f467825ULL, 0x040fe200078e0046ULL,
0x0000000048167faeULL, 0x0003e6000b901c48ULL, 0x000000106f427825ULL, 0x040fe200078e0042ULL,
0x0000000046157faeULL, 0x0003e6000b901c48ULL, 0x000000106f1e7825ULL, 0x000fe200078e001eULL,
0x0000000042147faeULL, 0x0003e8000b901c48ULL, 0x000000001e127faeULL, 0x0003e4000b901c48ULL,
0x000000ff1100720cULL, 0x000fda0003f25270ULL, 0x0000000000209947ULL, 0x000fea0003800000ULL,
0x0000000203037836ULL, 0x000fe40000000000ULL, 0xffffffffff007424ULL, 0x000fc600078e00ffULL,
0x000000060300720cULL, 0x000fda0003f26070ULL, 0x0000000000101947ULL, 0x000fea0003800000ULL,
0x00008c00ff147b82ULL, 0x00ae620000000a00ULL, 0x0000000236117824ULL, 0x000fc800078e0203ULL,
0x0000000411147825ULL, 0x002fca00078e0014ULL, 0x0000000814007981ULL, 0x000324000c1e1900ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000200010417824ULL, 0x00afe200078e0213ULL,
0xfffffff804117812ULL, 0x040fe200078ec0ffULL, 0x0000002004137836ULL, 0x000fe20000000000ULL,
0x0000000704477812ULL, 0x000fe200078ec0ffULL, 0x000000ffff457224ULL, 0x000fe200078e00ffULL,
0x0000000711427812ULL, 0x000fe200078ef804ULL, 0x0000200041417836ULL, 0x000fe20000000000ULL,
0xfffffff813137812ULL, 0x000fe400078ec0ffULL, 0x0000000847437812ULL, 0x000fc400078ef804ULL,
0x0000000713467812ULL, 0x000fe200078ef804ULL, 0x000080400000791aULL, 0x000fcc0000000000ULL,
0x0000000142107824ULL, 0x140fe400078e0245ULL, 0x0000000842117824ULL, 0x000fe400078e00ffULL,
0x0000000146147824ULL, 0x140fe400078e0245ULL, 0x0000000846157824ULL, 0x000fe200078e00ffULL,
0xfffffff811107812ULL, 0x000fe200078ee210ULL, 0x0000000145497836ULL, 0x000fe40000000000ULL,
0x0000000844617824ULL, 0x000fe200078e0245ULL, 0xfffffff815147812ULL, 0x000fe200078ee214ULL,
0x0000001010107824ULL, 0x000fc400078e0241ULL, 0x0000000261617824ULL, 0x000fe400078e00ffULL,
0x0000001014147824ULL, 0x000fe400078e0241ULL, 0x000000001010783bULL, 0x000e620000000200ULL,
0x0000000245457836ULL, 0x000fc60000000000ULL, 0x000000001414783bULL, 0x000ea40000000200ULL,
0x000000084500780cULL, 0x000fe40003f25270ULL, 0x00000018ff577819ULL, 0x002fe20000011410ULL,
0x00010000101c7824ULL, 0x040fe200078e00ffULL, 0x0000888010557816ULL, 0x040fe200000000ffULL,
0x0000010010107824ULL, 0x000fe200078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe20000011411ULL,
0x00010000111d7824ULL, 0x040fe200078e00ffULL, 0x0000888011607816ULL, 0x040fe200000000ffULL,
0x0000010011117824ULL, 0x000fe200078e00ffULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x0000005700577306ULL, 0x000fe20000202400ULL, 0x00000018ff647819ULL, 0x000fc40000011412ULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x00008880125f7816ULL, 0x000fe400000000ffULL,
0x00000018ff677819ULL, 0x004fe20000011414ULL, 0x00000010005e7306ULL, 0x0003e20000202400ULL,
0x00008880146f7816ULL, 0x000fe400000000ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x00000018ff1d7819ULL, 0x000fc4000001141dULL, 0x00000018ff487819ULL, 0x000fe20000011417ULL,
0x00000011005d7306ULL, 0x0005e20000202400ULL, 0x0001000012107824ULL, 0x042fe200078e00ffULL,
0x0000888017627816ULL, 0x000fe200000000ffULL, 0x0000010012127824ULL, 0x000fe200078e00ffULL,
0x00000018ff667819ULL, 0x000fe40000011415ULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x00000018ff127819ULL, 0x000fe20000011412ULL, 0x0001000013117824ULL, 0x004fe200078e00ffULL,
0x0000001000767306ULL, 0x0003e20000202400ULL, 0x00008880156d7816ULL, 0x000fc400000000ffULL,
0x00000018ff5b7819ULL, 0x000fe40000011416ULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x0000888016697816ULL, 0x000fe200000000ffULL, 0x0000001200757306ULL, 0x0005e20000202400ULL,
0x0001000014107824ULL, 0x042fe200078e00ffULL, 0x00000018ff687819ULL, 0x000fe20000011413ULL,
0x0000010014147824ULL, 0x000fe200078e00ffULL, 0x0000888013737816ULL, 0x040fe200000000ffULL,
0x0000010013137824ULL, 0x000fe200078e00ffULL, 0x00000018ff107819ULL, 0x000fc40000011410ULL,
0x0000001100747306ULL, 0x0003e20000202400ULL, 0x0000000842127824ULL, 0x004fe200078e00ffULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x00000018ff137819ULL, 0x000fc80000011413ULL,
0x0000001c005a7306ULL, 0x000fe20000202400ULL, 0x0000000142117824ULL, 0x102fe400078e0249ULL,
0x0000000146497824ULL, 0x000fc600078e0249ULL, 0xfffffff812127812ULL, 0x000fe200078ee211ULL,
0x0001000015117824ULL, 0x040fe200078e00ffULL, 0x0000001d00777306ULL, 0x0003e20000202400ULL,
0x0000010015157824ULL, 0x000fe400078e00ffULL, 0x0000001012127824ULL, 0x000fe200078e0241ULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x00000018ff157819ULL, 0x000fe40000011415ULL,
0x0000001400707306ULL, 0x0005e20000202400ULL, 0x00000000121c783bULL, 0x002e6e0000000200ULL,
0x00000011006e7306ULL, 0x0007e20000202400ULL, 0x0000000846147824ULL, 0x004fca00078e00ffULL,
0xfffffff814147812ULL, 0x000fe400078ee249ULL, 0x0000001000727306ULL, 0x0005e60000202400ULL,
0x0000001014117824ULL, 0x008fe400078e0241ULL, 0x0001000017147824ULL, 0x040fe400078e00ffULL,
0x0000010017177824ULL, 0x000fe200078e00ffULL, 0x00000015006b7306ULL, 0x000fe20000202400ULL,
0x0001000016107824ULL, 0x044fe200078e00ffULL, 0x00000018ff147819ULL, 0x000fe20000011414ULL,
0x0000010016167824ULL, 0x000fe200078e00ffULL, 0x00000018ff177819ULL, 0x000fc40000011417ULL,
0x00000018ff6c7819ULL, 0x000fe40000011410ULL, 0x0000001400657306ULL, 0x0005e20000202400ULL,
0x00000018ff167819ULL, 0x000fce0000011416ULL, 0x0000001700637306ULL, 0x0007e20000202400ULL,
0x0000006104147211ULL, 0x004fe200078fe0ffULL, 0x000100001c157824ULL, 0x042fe200078e00ffULL,
0x00000018ff497819ULL, 0x000fe2000001141cULL, 0x000100001d567824ULL, 0x000fe200078e00ffULL,
0x00000018ff517819ULL, 0x000fe2000001141dULL, 0x0000000143147824ULL, 0x040fe200078e0214ULL,
0x00000018ff527819ULL, 0x000fe20000011415ULL, 0x00000016006a7306ULL, 0x0003e20000202400ULL,
0x0000002043177824ULL, 0x008fe200078e00ffULL, 0x000088801c4b7816ULL, 0x040fe200000000ffULL,
0x000001001c1c7824ULL, 0x000fe200078e00ffULL, 0x000088801d537816ULL, 0x040fe200000000ffULL,
0x000001001d1d7824ULL, 0x000fe200078e00ffULL, 0xffffffe017147812ULL, 0x000fe200078ee214ULL,
0x0000000261617836ULL, 0x000fe20000000000ULL, 0x0000005500557306ULL, 0x000ea20000202400ULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x000100001e597824ULL, 0x000fe200078e00ffULL,
0x00000018ff1d7819ULL, 0x000fe2000001141dULL, 0x0000001014147824ULL, 0x000fe200078e0207ULL,
0x00000018ff587819ULL, 0x000fc40000011456ULL, 0x00000018ff4f7819ULL, 0x000fe2000001141fULL,
0x0000001300717306ULL, 0x0007e20000202400ULL, 0x00000018ff507819ULL, 0x000fe2000001141eULL,
0x000000001414783bULL, 0x002e620000000200ULL, 0x000088801e787816ULL, 0x040fe200000000ffULL,
0x000001001e1e7824ULL, 0x000fc800078e00ffULL, 0x0000001c00547306ULL, 0x0005e20000202400ULL,
0x000000001110783bULL, 0x008ee20000000200ULL, 0x00000018ff1e7819ULL, 0x000fcc000001141eULL,
0x0000001d00567306ULL, 0x000be20000202400ULL, 0x00005410551c7816ULL, 0x004fe4000000005aULL,
0x00000018ff5a7819ULL, 0x000fca0000011459ULL, 0x0000005c005c7306ULL, 0x000ea20000202400ULL,
0x000054105e1d7816ULL, 0x020fe40000000057ULL, 0x000088801f577816ULL, 0x000fca00000000ffULL,
0x0000006000607306ULL, 0x000f700000202400ULL, 0x0000006400647306ULL, 0x000f620000202400ULL,
0x0000001c143c723cULL, 0x002fee000004183cULL, 0x0000005f005f7306ULL, 0x000fe20000202400ULL,
0x000100001f1c7824ULL, 0x000fe200078e00ffULL, 0x000054105d1d7816ULL, 0x004fe2000000005cULL,
0x000001001f1f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4e7819ULL, 0x008fc40000011410ULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x00008880105d7816ULL, 0x000fe200000000ffULL,
0x0000006800687306ULL, 0x000e620000202400ULL, 0x00000018ff1f7819ULL, 0x000fe4000001141fULL,
0x00000018ff4d7819ULL, 0x000fe40000011411ULL, 0x00000018ff4c7819ULL, 0x000fe40000011412ULL,
0x00000018ff4a7819ULL, 0x000fe20000011413ULL, 0x0000001c005e7306ULL, 0x000bf00000202400ULL,
0x0000001f005c7306ULL, 0x0005e20000202400ULL, 0x00005410601c7816ULL, 0x020fc40000000077ULL,
0x0000888011777816ULL, 0x000fca00000000ffULL, 0x0000001c1438723cULL, 0x000fe20000041838ULL,
0x00000020431f7824ULL, 0x004fe200078e00ffULL, 0x0000007300737306ULL, 0x000eaa0000202400ULL,
0x00010000101d7824ULL, 0x040fe400078e00ffULL, 0x00000100101c7824ULL, 0x000fe200078e00ffULL,
0x0000006104107211ULL, 0x000fe200078fe0ffULL, 0x0000001e00597306ULL, 0x0007e20000202400ULL,
0x00000018ff1d7819ULL, 0x000fc4000001141dULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x0000000143107824ULL, 0x000fc800078e0210ULL, 0x0000001d00607306ULL, 0x000be20000202400ULL,
0xffffffe01f107812ULL, 0x000fe200078ee210ULL, 0x00010000111e7824ULL, 0x008fc800078e00ffULL,
0x0000001010107824ULL, 0x000fe400078e0207ULL, 0x0000001c00617306ULL, 0x0007e20000202400ULL,
0x00005410751d7816ULL, 0x020fe20000000064ULL, 0x0000010011757824ULL, 0x000fe200078e00ffULL,
0x00000018ff647819ULL, 0x000fe4000001141eULL, 0x0000541071117816ULL, 0x002fe40000000068ULL,
0x00000018ff687819ULL, 0x000fe20000011475ULL, 0x0000006f006f7306ULL, 0x000e620000202400ULL,
0x000054105f1c7816ULL, 0x008fce0000000076ULL, 0x0000001c1430723cULL, 0x000fe20000041830ULL,
0x0000006700677306ULL, 0x000ee20000202400ULL, 0x00000000101c783bULL, 0x00056e0000000200ULL,
0x0000006600667306ULL, 0x000fe20000202400ULL, 0x0000541073107816ULL, 0x004fce0000000074ULL,
0x0000006d006d7306ULL, 0x000ea20000202400ULL, 0x00000010142c723cULL, 0x000fee000004182cULL,
0x0000888012117816ULL, 0x000fe200000000ffULL, 0x0000005b005b7306ULL, 0x000fe20000202400ULL,
0x000054106f107816ULL, 0x002fc60000000072ULL, 0x000000ffff6f7224ULL, 0x000fe200078e0011ULL,
0x0000541070117816ULL, 0x008fe20000000067ULL, 0x0001000012707824ULL, 0x000fe400078e00ffULL,
0x0000006900697306ULL, 0x000fe60000202400ULL, 0x00000018ff707819ULL, 0x000fe20000011470ULL,
0x000000101428723cULL, 0x000fe80000041828ULL, 0x0000006c006c7306ULL, 0x000e660000202400ULL,
0x000054106d107816ULL, 0x004fc4000000006eULL, 0x000054106b117816ULL, 0x000fc60000000066ULL,
0x0000004800487306ULL, 0x000fe80000202400ULL, 0x000000101424723cULL, 0x000fe80000041824ULL,
0x0000006200627306ULL, 0x000ea60000202400ULL, 0x0000010012117824ULL, 0x000fe200078e00ffULL,
0x0000541069107816ULL, 0x002fc4000000006cULL, 0x0000888013697816ULL, 0x000fe400000000ffULL,
0x00000018ff667819ULL, 0x000fe20000011411ULL, 0x0000005100517306ULL, 0x000e620000202400ULL,
0x000054106a117816ULL, 0x000fce000000005bULL, 0x000000101420723cULL, 0x000fe20000041820ULL,
0x0000005300537306ULL, 0x000fec0000202400ULL, 0x0000541062107816ULL, 0x004fe40000000065ULL,
0x0000541063117816ULL, 0x000fe20000000048ULL, 0x0000005800587306ULL, 0x000fe20000202400ULL,
0x000000ffff487224ULL, 0x000fca00078e0069ULL, 0x000000101418723cULL, 0x000fe40000041818ULL,
0x0000007800557306ULL, 0x000fea0000202400ULL, 0x0000010013157824ULL, 0x040fe200078e00ffULL,
0x0000541056117816ULL, 0x002fe20000000051ULL, 0x0001000013107824ULL, 0x000fe200078e00ffULL,
0x0000005a005a7306ULL, 0x000fe40000202400ULL, 0x00000018ff157819ULL, 0x000fc40000011415ULL,
0x00000018ff107819ULL, 0x000fc80000011410ULL, 0x0000004900497306ULL, 0x000e700000202400ULL,
0x0000005000507306ULL, 0x000ea20000202400ULL, 0x0000541054497816ULL, 0x002fce0000000049ULL,
0x0000004f004f7306ULL, 0x000fe20000202400ULL, 0x0000541059597816ULL, 0x004fce0000000050ULL,
0x0000004e004e7306ULL, 0x000e700000202400ULL, 0x0000004d004d7306ULL, 0x000fe20000202400ULL,
0x0000541061617816ULL, 0x002fce000000004eULL, 0x0000004c004c7306ULL, 0x000ff00000202400ULL,
0x0000004a004a7306ULL, 0x000ff00000202400ULL, 0x0000004b004b7306ULL, 0x000ff00000202400ULL,
0x0000005200527306ULL, 0x000ff00000202400ULL, 0x0000005700577306ULL, 0x000ff00000202400ULL,
0x0000005d005d7306ULL, 0x000e700000202400ULL, 0x00000077005f7306ULL, 0x000fe20000202400ULL,
0x000054105d607816ULL, 0x002fce0000000060ULL, 0x0000006400647306ULL, 0x000e620000202400ULL,
0x000000601c28723cULL, 0x020fee0000041828ULL, 0x0000006800687306ULL, 0x000ea20000202400ULL,
0x000054105f647816ULL, 0x002fce0000000064ULL, 0x0000006f00677306ULL, 0x000fe20000202400ULL,
0x0000541068657816ULL, 0x004fce000000004dULL, 0x0000007000127306ULL, 0x000fe20000202400ULL,
0x000000641c24723cULL, 0x000fee0000041824ULL, 0x00000066005b7306ULL, 0x000e700000202400ULL,
0x0000004800147306ULL, 0x0005e20000202400ULL, 0x000054105b5b7816ULL, 0x002fce000000004cULL,
0x0000001000137306ULL, 0x0002e20000202400ULL, 0x000054104b487816ULL, 0x004fce0000000052ULL,
0x0000001500157306ULL, 0x000ea20000202400ULL, 0x0000541053107816ULL, 0x002fe20000000058ULL,
0x000000481c3c723cULL, 0x000fe2000004183cULL, 0x0000541055587816ULL, 0x000fe4000000005aULL,
0x00005410675a7816ULL, 0x000fe40000000012ULL, 0x0000541014147816ULL, 0x008fe20000000013ULL,
0x000000101c38723cULL, 0x000fec0000041838ULL, 0x000000581c30723cULL, 0x000fe20000041830ULL,
0x0000541057107816ULL, 0x000fc4000000005eULL, 0x000054105c117816ULL, 0x000fe4000000004fULL,
0x0000541015157816ULL, 0x004fe2000000004aULL, 0x0000005a1c20723cULL, 0x000fec0000041820ULL,
0x000000101c2c723cULL, 0x000fec000004182cULL, 0x000000141c18723cULL, 0x000fe20000041818ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0xfffffff000181947ULL, 0x000fde000383ffffULL,
0x000000ffff107224ULL, 0x000fe200078e000eULL, 0xffffffd000f08947ULL, 0x000fec000383ffffULL,
0x00000001ff117424ULL, 0x000fe400078e00ffULL, 0x0000000920167220ULL, 0x080fe20000410000ULL,
0x0000000921177220ULL, 0x080fe20000410000ULL, 0x000000093c157220ULL, 0x080fe20000410000ULL,
0x000000093d3d7220ULL, 0x080fe20000410000ULL, 0x000000093e3e7220ULL, 0x080fe20000410000ULL,
0x018688110a1079a7ULL, 0x000262000850003fULL, 0x000000093f3f7220ULL, 0x080fe20000410000ULL,
0x0000000938387220ULL, 0x080fe20000410000ULL, 0x0000000939397220ULL, 0x080fe20000410000ULL,
0x000000093a3a7220ULL, 0x080fe20000410000ULL, 0x000000093b3b7220ULL, 0x080fe20000410000ULL,
0x0000000930307220ULL, 0x080fe20000410000ULL, 0x0000000931317220ULL, 0x080fe20000410000ULL,
0x0000000932327220ULL, 0x080fe20000410000ULL, 0x0000000933337220ULL, 0x080fe20000410000ULL,
0x000000092c2c7220ULL, 0x080fe20000410000ULL, 0x000000092d2d7220ULL, 0x080fe20000410000ULL,
0x000000092e2e7220ULL, 0x080fe20000410000ULL, 0x000000092f2f7220ULL, 0x080fe20000410000ULL,
0x0000000928147220ULL, 0x080fe20000410000ULL, 0x0000000929297220ULL, 0x080fe20000410000ULL,
0x000000092a2a7220ULL, 0x080fe20000410000ULL, 0x000000092b2b7220ULL, 0x080fe20000410000ULL,
0x0000000924247220ULL, 0x080fe20000410000ULL, 0x0000000925257220ULL, 0x080fe20000410000ULL,
0x0000000926267220ULL, 0x080fe20000410000ULL, 0x0000000927277220ULL, 0x080fe20000410000ULL,
0x0000000922227220ULL, 0x080fe20000410000ULL, 0x0000000923237220ULL, 0x080fe20000410000ULL,
0x0000000918187220ULL, 0x080fe20000410000ULL, 0x0000000919197220ULL, 0x080fe20000410000ULL,
0x000000091a207220ULL, 0x080fe20000410000ULL, 0x000000091b217220ULL, 0x002fce0000410000ULL,
0x0000000000127805ULL, 0x000fce0000015200ULL, 0x018688110a0075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff1c7224ULL, 0x000fce00078e00ffULL,
0x000000101c00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000001a7805ULL, 0x000fce0000015200ULL, 0x0000001a121d7210ULL, 0x000fca0007f1e1ffULL,
0x000000011b1b7824ULL, 0x000fe200000e0e13ULL, 0x003d09001d00780cULL, 0x000fc80003f06070ULL,
0x000000ff1b00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401d00780cULL, 0x000fc80003f06070ULL, 0x000000ff1b00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff1a7819ULL, 0x000fc8000001141bULL,
0x0000001d1a1a7211ULL, 0x000fca00078110ffULL, 0x000000ffff1b7224ULL, 0x000fca00000e061bULL,
0x000000021a1a7819ULL, 0x000fc8000000121bULL, 0x0000001a0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011c1c7836ULL, 0x000fce0000000000ULL,
0x018688110a0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000404107824ULL, 0x000fe200078e00ffULL, 0x0000000c3500720cULL, 0x000fe20003f05270ULL,
0x0000008034287824ULL, 0x000fc600078e0207ULL, 0xfffffff010117812ULL, 0x000fca00078ec0ffULL,
0x0000000128287824ULL, 0x000fca00078e0211ULL, 0x0184000028107984ULL, 0x0002a20000000c00ULL,
0x0000000400080947ULL, 0x000fea0003800000ULL, 0x00000002041a7824ULL, 0x000fe400078e00ffULL,
0x000000010f407824ULL, 0x000fc600078e0a40ULL, 0x000000061a1b7812ULL, 0x000fc800078ec0ffULL,
0x000000011b1d7812ULL, 0x040fe400078efcffULL, 0x000000081b1f7812ULL, 0x000fe400078efcffULL,
0x000000401d00720cULL, 0x080fe40003f26070ULL, 0x000000101b1d7812ULL, 0x000fe400078efcffULL,
0x000000401f00720cULL, 0x080fe40003f06070ULL, 0x000000401d00720cULL, 0x000fc40003fc6070ULL,
0x000000111b1f7812ULL, 0x040fe400078efcffULL, 0x000000181b1d7812ULL, 0x040fe400078efcffULL,
0x000000401b00720cULL, 0x080fe40003f46070ULL, 0x000000401f00720cULL, 0x080fe40003fa6070ULL,
0x000000401d00720cULL, 0x000fe40003f66070ULL, 0x000000091b377812ULL, 0x000fc400078efcffULL,
0x000000191b1f7812ULL, 0x040fe400078efcffULL, 0x000000201b1d7812ULL, 0x000fe400078efcffULL,
0xff8000003e3e7808ULL, 0x000fe40005000000ULL, 0xff80000015157808ULL, 0x000fe40005000000ULL,
0xff8000003f3f7808ULL, 0x000fe40004800000ULL, 0xff8000003d3d7808ULL, 0x000fc40004800000ULL,
0x000000403700720cULL, 0x080fe40003f86070ULL, 0x000000401f00720cULL, 0x080fe40003f46070ULL,
0x000000401d00720cULL, 0x000fe40003f26070ULL, 0x000000211b1f7812ULL, 0x040fe400078efcffULL,
0x000000281b1d7812ULL, 0x000fe400078efcffULL, 0xff8000003a3a7808ULL, 0x000fc40004000000ULL,
0xff80000038387808ULL, 0x000fe40004000000ULL, 0xff8000003b3b7808ULL, 0x000fe40006000000ULL,
0xff80000039397808ULL, 0x000fe40006000000ULL, 0x000000401f00720cULL, 0x080fe40003f06070ULL,
0x000000401d00720cULL, 0x000fe40003f86070ULL, 0x000000291b1f7812ULL, 0x000fc400078efcffULL,
0x000000301b1d7812ULL, 0x000fe400078efcffULL, 0xff80000032327808ULL, 0x000fe40007000000ULL,
0xff80000030307808ULL, 0x000fe40007000000ULL, 0xff80000033337808ULL, 0x000fe40006800000ULL,
0xff80000031317808ULL, 0x000fe40006800000ULL, 0x000000401f00720cULL, 0x000fc40003fc6070ULL,
0x000000401d00720cULL, 0x000fe40003fa6070ULL, 0x000000311b1f7812ULL, 0x040fe400078efcffULL,
0x000000381b1d7812ULL, 0x040fe400078efcffULL, 0x000000391b1b7812ULL, 0x000fe400078efcffULL,
0xff8000002e2e7808ULL, 0x000fe40005800000ULL, 0xff8000002c2c7808ULL, 0x000fc40005800000ULL,
0xff8000002f2f7808ULL, 0x000fe40005000000ULL, 0xff8000002d2d7808ULL, 0x000fe40005000000ULL,
0xff8000002a2a7808ULL, 0x000fe40004800000ULL, 0xff80000014147808ULL, 0x000fe40004800000ULL,
0x000000401f00720cULL, 0x080fe40003f66070ULL, 0x000000401d00720cULL, 0x000fc40003f46070ULL,
0x000000401b00720cULL, 0x000fe40003f26070ULL, 0xff8000002b2b7808ULL, 0x000fe40004000000ULL,
0xff80000029297808ULL, 0x000fe40004000000ULL, 0xff80000026267808ULL, 0x000fe40006000000ULL,
0xff80000024247808ULL, 0x000fe40006000000ULL, 0xff80000027277808ULL, 0x000fc40007000000ULL,
0xff80000025257808ULL, 0x000fe40007000000ULL, 0xff80000022227808ULL, 0x000fe40006800000ULL,
0xff80000016167808ULL, 0x000fe40006800000ULL, 0xff80000023237808ULL, 0x000fe40005800000ULL,
0xff80000017177808ULL, 0x000fe40005800000ULL, 0xff80000020207808ULL, 0x000fc40005000000ULL,
0xff80000018187808ULL, 0x000fe40005000000ULL, 0xff80000021217808ULL, 0x000fe40004800000ULL,
0xff80000019197808ULL, 0x000fce0004800000ULL, 0x000000151000720bULL, 0x004fe20003f1e000ULL,
0x3f80000000047882ULL, 0x000fe20000000000ULL, 0x0000000135357836ULL, 0x000fe40000000000ULL,
0x0000001015107208ULL, 0x000fc80004000000ULL, 0x0000003d1000720bULL, 0x000fc80003f1e000ULL,
0x000000103d1b7208ULL, 0x000fc80004000000ULL, 0x000000381b00720bULL, 0x000fc80003f1e000ULL,
0x0000001b38107208ULL, 0x000fc80004000000ULL, 0x000000391000720bULL, 0x000fc80003f1e000ULL,
0x00000010391b7208ULL, 0x000fc80004000000ULL, 0x000000301b00720bULL, 0x000fc80003f1e000ULL,
0x0000001b30107208ULL, 0x000fc80004000000ULL, 0x000000311000720bULL, 0x000fc80003f1e000ULL,
0x00000010311b7208ULL, 0x000fc80004000000ULL, 0x0000002c1b00720bULL, 0x000fc80003f1e000ULL,
0x0000001b2c107208ULL, 0x000fc80004000000ULL, 0x0000002d1000720bULL, 0x000fc80003f1e000ULL,
0x000000102d1b7208ULL, 0x000fc80004000000ULL, 0x000000141b00720bULL, 0x000fc80003f1e000ULL,
0x0000001b14107208ULL, 0x000fc80004000000ULL, 0x000000291000720bULL, 0x000fc80003f1e000ULL,
0x00000010291b7208ULL, 0x000fc80004000000ULL, 0x000000241b00720bULL, 0x000fc80003f1e000ULL,
0x0000001b24107208ULL, 0x000fe40004000000ULL, 0x0000003e1100720bULL, 0x000fe40003f1e000ULL,
0x000000251000720bULL, 0x000fc80003f3e000ULL, 0x00000010251b7208ULL, 0x000fe40004800000ULL,
0x000000113e107208ULL, 0x000fe40004000000ULL, 0x000000161b00720bULL, 0x000fe40003f3e000ULL,
0x0000003f1000720bULL, 0x000fe40003f1e000ULL, 0x0000001b161a7208ULL, 0x000fe40004800000ULL,
0x000000103f117208ULL, 0x000fc40004000000ULL, 0x000000171a00720bULL, 0x000fe40003f3e000ULL,
0x0000003a1100720bULL, 0x000fe40003f1e000ULL, 0x0000001a171b7208ULL, 0x000fe40004800000ULL,
0x000000113a107208ULL, 0x000fe40004000000ULL, 0x000000181b00720bULL, 0x000fe40003f3e000ULL,
0x0000003b1000720bULL, 0x000fc40003f1e000ULL, 0x0000001b181a7208ULL, 0x000fe40004800000ULL,
0x000000103b117208ULL, 0x000fe40004000000ULL, 0x000000191a00720bULL, 0x000fe40003f3e000ULL,
0x000000321100720bULL, 0x000fe40003f1e000ULL, 0x0000001a191a7208ULL, 0x000fe40004800000ULL,
0x0000001132107208ULL, 0x000fc60004000000ULL, 0x0c401f001a1b7f89ULL, 0x000ea200000e0000ULL,
0x000000331000720bULL, 0x000fc80003f1e000ULL, 0x0000001033117208ULL, 0x000fc80004000000ULL,
0x0000002e1100720bULL, 0x000fc80003f1e000ULL, 0x000000112e107208ULL, 0x000fc80004000000ULL,
0x0000002f1000720bULL, 0x000fc80003f1e000ULL, 0x000000102f117208ULL, 0x000fe40004000000ULL,
0x0000001b1a00720bULL, 0x004fe40003f3e000ULL, 0x0000002a1100720bULL, 0x000fe40003f1e000ULL,
0x0000001a1b1b7208ULL, 0x000fe40004800000ULL, 0x000000112a107208ULL, 0x000fc60004000000ULL,
0x0c201f001b1a7f89ULL, 0x000ea200000e0000ULL, 0x0000002b1000720bULL, 0x000fc80003f1e000ULL,
0x000000102b117208ULL, 0x000fc80004000000ULL, 0x000000261100720bULL, 0x000fc80003f1e000ULL,
0x0000001126107208ULL, 0x000fc80004000000ULL, 0x000000271000720bULL, 0x000fc80003f1e000ULL,
0x0000001027117208ULL, 0x000fe40004000000ULL, 0x0000001a1b00720bULL, 0x004fe40003f3e000ULL,
0x000000221100720bULL, 0x000fe40003f1e000ULL, 0x0000001b1a107208ULL, 0x000fe40004800000ULL,
0x00000011221a7208ULL, 0x000fc60004000000ULL, 0x3fb8aa3b101c7820ULL, 0x000fe20000410000ULL,
0x000000231a00720bULL, 0x000fc60003f1e000ULL, 0x3fb8aa3b2c1d7823ULL, 0x100fe2000001081cULL,
0x0000001a23117208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b142c7823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b15157823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b3d3d7823ULL, 0x100fe2000001081cULL,
0x000000201100720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b38387823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b39397823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b30307823ULL, 0x100fe2000001081cULL,
0x00000011201a7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b18187823ULL, 0x100fe2000001081cULL,
0x0000003d001e7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b31317823ULL, 0x100fe2000001081cULL,
0x000000211a00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b24247823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b2d1f7823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b292d7823ULL, 0x100fe2000001081cULL,
0x0000001a211a7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b16297823ULL, 0x100fe2000001081cULL,
0x00000030001b7308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b19197823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b25257823ULL, 0x100fe2000001081cULL, 0x0c401f001a117f89ULL, 0x000eea00000e0000ULL,
0x0000001500157308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b17307823ULL, 0x004fce000001081cULL,
0x00000018003d7308ULL, 0x000ff00000000800ULL, 0x0000003800387308ULL, 0x000fe20000000800ULL,
0x000000111a00720bULL, 0x008fc80003f1e000ULL, 0x0000001a11117208ULL, 0x000fc60004000000ULL,
0x0000003900397308ULL, 0x000ea40000000800ULL, 0x0c201f0011147f89ULL, 0x000eec00000e0000ULL,
0x00000031003c7308ULL, 0x000fe20000000800ULL, 0x000000383916723eULL, 0x004fce00000010ffULL,
0x0000002400317308ULL, 0x0005f00000000800ULL, 0x0000001d00377308ULL, 0x000fe20000000800ULL,
0x000000141100720bULL, 0x008fc80003f1e000ULL, 0x0000001114117208ULL, 0x000fc60004000000ULL,
0x0000001f00407308ULL, 0x000fe20000000800ULL, 0x000000151e14723eULL, 0x000fe200000010ffULL,
0x3fb8aa3b11417820ULL, 0x000fc80000410000ULL, 0x3fb8aa3b3e3e7823ULL, 0x100fe20000010841ULL,
0x3fb8aa3b3f3f7823ULL, 0x100fe20000010841ULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe20000010841ULL,
0x3fb8aa3b3b3b7823ULL, 0x100fe20000010841ULL, 0x3fb8aa3b2a1a7823ULL, 0x100fe20000010841ULL,
0x00000004ff2a7e24ULL, 0x000fe2000f8e00ffULL, 0x0000003e003e7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2b247823ULL, 0x104fe20000010841ULL, 0x3fb8aa3b32327823ULL, 0x100fe20000010841ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe20000010841ULL, 0x3f8000002a2a783eULL, 0x000fe200000010ffULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe20000010841ULL, 0x3fb8aa3b33337823ULL, 0x100fe20000010841ULL,
0x3fb8aa3b26267823ULL, 0x000fe20000010841ULL, 0x0000003f003f7308ULL, 0x000ea20000000800ULL,
0x000000ffff2b7224ULL, 0x000fc400078e002aULL, 0x3fb8aa3b27277823ULL, 0x100fe20000010841ULL,
0x3fb8aa3b23237823ULL, 0x100fe20000010841ULL, 0x3fb8aa3b20207823ULL, 0x000fc60000010841ULL,
0x0000003a00177308ULL, 0x000fe20000000800ULL, 0x0000003e3f15723eULL, 0x004fce00000010ffULL,
0x0000003b00187308ULL, 0x000eb00000000800ULL, 0x0000001900447308ULL, 0x000fe20000000800ULL,
0x000000171817723eULL, 0x004fce00000010ffULL, 0x0000003200327308ULL, 0x000fe20000000800ULL,
0x0000001b3c18723eULL, 0x000fe200000010ffULL, 0x000000ffff3c7224ULL, 0x000fe200078e002aULL,
0x0000002a141c723cULL, 0x000fea00000418ffULL, 0x0000003300197308ULL, 0x000ea20000000800ULL,
0x0c401f00122b7f89ULL, 0x000eee00000e0000ULL, 0x0000002e002e7308ULL, 0x000fe20000000800ULL,
0x000000321919723eULL, 0x004fce00000010ffULL, 0x0000002f002f7308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b22327823ULL, 0x100fe20000010841ULL, 0x3fb8aa3b21417823ULL, 0x000fe20000010841ULL,
0x0c401f0013227f89ULL, 0x000f6a00000e0000ULL, 0x0000002500427308ULL, 0x0005620000000800ULL,
0x0000002b1200720bULL, 0x008fc80003f1e000ULL, 0x000000122b127208ULL, 0x000fe40004000000ULL,
0x0000002e2f1b723eULL, 0x004fe200000010ffULL, 0x0000001a003a7308ULL, 0x0005e20000000800ULL,
0x000000ffff257224ULL, 0x000fe400078e002aULL, 0x00000800342f7824ULL, 0x000fe400078e0207ULL,
0x000000ffff3b7224ULL, 0x000fc600078e001bULL, 0x0000002400337308ULL, 0x0006e20000000800ULL,
0x00000037401a723eULL, 0x004fe400000010ffULL, 0x000000221300720bULL, 0x022fc80003f3e000ULL,
0x0000001322137208ULL, 0x000fe20004800000ULL, 0x0000002600387308ULL, 0x000fe20000000800ULL,
0x000000ffff247224ULL, 0x108fe200078e002aULL, 0x0000003d4422723eULL, 0x000fe200000010ffULL,
0x000000ffff3d7224ULL, 0x000fca00078e002aULL, 0x0000002700397308ULL, 0x0002b00000000800ULL,
0x0000002c002c7308ULL, 0x000fe20000000800ULL, 0x000000241824723cULL, 0x002fee000004181cULL,
0x0000002d002d7308ULL, 0x000e620000000800ULL, 0x00000031421e723eULL, 0x000fc400000010ffULL,
0x0000003a331d723eULL, 0x000fe200000010ffULL, 0x000120002f3a7836ULL, 0x000fe20000000000ULL,
0x00000038391f723eULL, 0x004fe200000010ffULL, 0x000000ffff2f7224ULL, 0x000fe200078e001aULL,
0x0c201f0013387f89ULL, 0x000ea200000e0000ULL, 0x0000002900297308ULL, 0x000fe20000000800ULL,
0x000000ffff317224ULL, 0x000fe400078e001eULL, 0x000000ffff337224ULL, 0x000fe400078e0022ULL,
0x000000ffff397224ULL, 0x000fe200078e0017ULL, 0x0000002c2d1c723eULL, 0x002fc400000010ffULL,
0x0000003000307308ULL, 0x000fe20000000800ULL, 0x000000ffff2c7224ULL, 0x100fe400078e002aULL,
0x000000ffff2d7224ULL, 0x000fca00078e002aULL, 0x0000003200327308ULL, 0x000fe40000000800ULL,
0x0000002c1c24723cULL, 0x000fe20000041824ULL, 0x000000381300720bULL, 0x004fca0003f3e000ULL,
0x0000002300237308ULL, 0x000e620000000800ULL, 0xfffffff8ff2c7812ULL, 0x000fe400078ee247ULL,
0x0000001338137208ULL, 0x000fe20004800000ULL, 0x000000ffff387224ULL, 0x000fe400078e0015ULL,
0x000000082c2b7824ULL, 0x000fe400078e00ffULL, 0x00000020002e7308ULL, 0x0005e20000000800ULL,
0x000000322321723eULL, 0x002fce00000010ffULL, 0x0000004100417308ULL, 0x000e620000000800ULL,
0x000000293020723eULL, 0x004fe200000010ffULL, 0x000000082c307824ULL, 0x000fe200078e00ffULL,
0x00000003ff297819ULL, 0x000fe20000011604ULL, 0x000000ffff1a7224ULL, 0x000fc600078e0021ULL,
0x0000000329297812ULL, 0x000fe400078ec0ffULL, 0x0000002e4123723eULL, 0x002fe200000010ffULL,
0x000000082c2e7836ULL, 0x000fe40000000000ULL, 0x00000001292c7824ULL, 0x040fe400078e022cULL,
0x00000001292d7824ULL, 0x000fe400078e022eULL, 0x0c201f0012297f89ULL, 0x000e6200000e0000ULL,
0x0000003c2024723cULL, 0x000fe20000041824ULL, 0x000000082e327824ULL, 0x000fe200078e00ffULL,
0xfffffff82b2a7812ULL, 0x000fe200078ee22cULL, 0x000000042c2b7836ULL, 0x000fc40000000000ULL,
0x000000082e377824ULL, 0x000fe200078e00ffULL, 0xfffffff8322d7812ULL, 0x000fe200078ee22dULL,
0x0000000c2c2c7836ULL, 0x000fe20000000000ULL, 0xfffffff8302b7812ULL, 0x000fe200078ee22bULL,
0x000000102a2a7824ULL, 0x000fe400078e023aULL, 0x000000ffff2e7224ULL, 0x000fe200078e0018ULL,
0xfffffff837377812ULL, 0x000fe200078ee22cULL, 0x000000ffff2c7224ULL, 0x000fe400078e0014ULL,
0x000000102b2b7824ULL, 0x000fc400078e023aULL, 0x000000ffff307224ULL, 0x000fe400078e001cULL,
0x000000ffff327224ULL, 0x000fe400078e0020ULL, 0x000000102d257824ULL, 0x000fe200078e023aULL,
0x000000291200720bULL, 0x002fe20003f1e000ULL, 0x000000ffff2d7224ULL, 0x000fe400078e0016ULL,
0x0000001037377824ULL, 0x000fe200078e023aULL, 0x0000001229127208ULL, 0x000fe20004000000ULL,
0x000000ffff3a7224ULL, 0x000fe200078e0019ULL, 0x0000000304ff7812ULL, 0x000fe2000780c0ffULL,
0x000000ffff187224ULL, 0x000fe200078e001dULL, 0x0000002c2a007844ULL, 0x0003e20000000200ULL,
0x000000ffff197224ULL, 0x000fc400078e001fULL, 0x000000ffff1b7224ULL, 0x000fe200078e0023ULL,
0x000000302b007844ULL, 0x0003e20000000200ULL, 0x000000ffff167224ULL, 0x000fe400078e0024ULL,
0x000000ffff177224ULL, 0x000fe200078e0026ULL, 0x0000003825007844ULL, 0x0003e20000000200ULL,
0x00000001ff147424ULL, 0x000fc600078e00ffULL, 0x0000001837007844ULL, 0x0003e80000000200ULL,
0x0180001028008388ULL, 0x0003e80000000c00ULL, 0x0182001628008388ULL, 0x0003e20000000a00ULL,
0x000000053500720cULL, 0x000fe20003f06070ULL, 0x018608140dff79a7ULL, 0x0003e2000850003fULL,
0x018610140dff79a7ULL, 0x0003e2000850003fULL, 0x018618140dff79a7ULL, 0x0003e2000850003fULL,
0x018620140dff79a7ULL, 0x0003f2000850003fULL, 0xffffffb800cc8947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0180000002007836ULL, 0x000fe20000000000ULL,
0x0000013000017945ULL, 0x000fe80003800000ULL, 0x7f80000000037812ULL, 0x000fc800078ec0ffULL,
0x018000000300780cULL, 0x000fda0003f05070ULL, 0x0000000200008308ULL, 0x0002a20000001000ULL,
0x0000000000388947ULL, 0x000fea0003800000ULL, 0x000000ff0300720cULL, 0x040fe40003f25070ULL,
0x008000000300780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x007fffff02ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000002027812ULL, 0x002fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000000000047947ULL, 0x000fec0003800000ULL,
0x0000000200007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x006fe400078e0005ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffffe80026c7950ULL, 0x000fea0003c3ffffULL, 0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000100000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000111ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000017bULL, 0x000000000000056aULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000006e8ULL, 0x0000000000000240ULL, 0x0000001600000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000928ULL, 0x00000000000000e0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000a08ULL, 0x0000000000000054ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000a5cULL, 0x0000000000000828ULL, 0x0000000a00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000004000000b2ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001288ULL, 0x0000000000000000ULL, 0x0000000a00000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000e6ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001288ULL, 0x0000000000000048ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000007bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000012d0ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001300ULL, 0x0000000000017f00ULL, 0x0000001600000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000008dULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000019200ULL, 0x0000000000000044ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000019250ULL, 0x0000000000000400ULL, 0x0000000a00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000001000000f8ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000019250ULL, 0x0000000000000260ULL, 0x0000000a00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL, 0x0000000000019830ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000019830ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x00000000000012d0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001300ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000017f00ULL,
0x0000000000017f00ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000019200ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000050ULL, 0x0000000000000450ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000019250ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000260ULL, 0x0000000000000260ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_1_kvt_int8_pagedKV_128_nqpkv_8_m_8_sm_90_cubin_len = 104832;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
