/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_1_kvt_int8_pagedKV_64_nqpkv_8_m_8_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000025650ULL, 0x00000000000252d0ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f34314944327961ULL, 0x6f6c66625f766e5fULL,
0x326a4c3236317461ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL,
0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x336a4c4536316a4cULL, 0x4c49746132454532ULL,
0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4534366aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL,
0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL,
0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL, 0x45326a4c4545316aULL, 0x7461324545316a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x4939494432796172ULL, 0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL,
0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL,
0x4c4545346a4c6a49ULL, 0x36316a4c4532336aULL, 0x624c497461324545ULL, 0x31534b5245454531ULL,
0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL,
0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL, 0x4c4545326a4c4532ULL, 0x4545316a4c45326aULL,
0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x45386a4c4545346aULL,
0x7461324545386a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL,
0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL,
0x6a4c4536316a4c45ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5f2400676e696469ULL, 0x616e7265746e695fULL, 0x635f5f245f305f6cULL,
0x30326d735f616475ULL, 0x5f6e725f7063725fULL, 0x5f3233665f7a7466ULL, 0x68746170776f6c73ULL,
0x65746e695f5f2400ULL, 0x245f315f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL,
0x6c66625f636e7973ULL, 0x695f5f2400705f79ULL, 0x5f6c616e7265746eULL, 0x6475635f5f245f32ULL,
0x735f30376d735f61ULL, 0x5f636e79736c6668ULL, 0x5f2400705f786469ULL, 0x616e7265746e695fULL,
0x635f5f245f335f6cULL, 0x30376d735f616475ULL, 0x6e797365746f765fULL, 0x746f6c6c61625f63ULL,
0x742e616c65722e00ULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL,
0x5f6c656e72656b2eULL, 0x72656b240061686dULL, 0x2461686d5f6c656eULL, 0x657479426d656d73ULL,
0x2e766e2e00667542ULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x61705f0061686d5fULL,
0x6265642e006d6172ULL, 0x656d6172665f6775ULL, 0x65642e6c65722e00ULL, 0x6d6172665f677562ULL,
0x2e616c65722e0065ULL, 0x72665f6775626564ULL, 0x2e766e2e00656d61ULL, 0x697463612e6c6572ULL,
0x0000000000006e6fULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c0001000000adULL, 0x0000000000000034ULL, 0x0000000000000010ULL, 0x000c0001000000ebULL,
0x000000000000001cULL, 0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c00010000016bULL, 0x000000000000002cULL, 0x0000000000000004ULL,
0x000c0001000001b5ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c0001000001fbULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000242ULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000c000100000288ULL, 0x0000000000000030ULL, 0x0000000000000004ULL,
0x000c0001000002d6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c000100000324ULL,
0x0000000000000018ULL, 0x0000000000000004ULL, 0x000c000100000372ULL, 0x000000000000000cULL,
0x0000000000000004ULL, 0x000c0001000003b9ULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000c000100000407ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c00010000044cULL,
0x0000000000000020ULL, 0x0000000000000004ULL, 0x000b002200000492ULL, 0x00000000000233b0ULL,
0x0000000000000190ULL, 0x000b0022000004c5ULL, 0x0000000000023540ULL, 0x0000000000000050ULL,
0x000b0022000004f0ULL, 0x0000000000023590ULL, 0x0000000000000040ULL, 0x000b00220000051aULL,
0x00000000000235d0ULL, 0x0000000000000130ULL, 0x000a000300000588ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00040003000005a8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00070003000005d8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL,
0x0000000000000000ULL, 0x0000000000023700ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000233b000000000ULL,
0x0000040400000000ULL, 0x810c000001580400ULL, 0x008b880400288080ULL, 0x0000000000000000ULL,
0x000000c4ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x80808a0828808081ULL, 0x8f082880808e0828ULL, 0x2880809008288080ULL,
0x8093082880809208ULL, 0x0828808094082880ULL, 0x8080960828808095ULL, 0x9d08288080970828ULL,
0x288080a208288080ULL, 0x80aa08288080a408ULL, 0x08288080b4082880ULL, 0x8080b808288080b6ULL,
0xbd08288080bc0828ULL, 0x288080be08288080ULL, 0x80c408288080c108ULL, 0x08288080c5082880ULL,
0x8080c708288080c6ULL, 0x8508288080c90828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL,
0x0028808085920000ULL, 0x0000000000000022ULL, 0x0000002cffffffffULL, 0x0000007000000000ULL,
0x000233b000000000ULL, 0x0000019000000000ULL, 0x00005c0400000000ULL, 0x8082288080850900ULL,
0x0000000000002880ULL, 0x000000c4ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080850828808081ULL, 0x8c082880808a0828ULL,
0x2880808e08288080ULL, 0x8090082880808f08ULL, 0x0828808092082880ULL, 0x8080940828808093ULL,
0x9608288080950828ULL, 0x2880809708288080ULL, 0x80a2082880809d08ULL, 0x08288080a4082880ULL,
0x8080b408288080aaULL, 0xb808288080b60828ULL, 0x288080bc08288080ULL, 0x80be08288080bd08ULL,
0x08288080c1082880ULL, 0x8080c508288080c4ULL, 0xc908288080c70828ULL, 0x288080ae08288080ULL,
0x0003102880828016ULL, 0x9200000000000000ULL, 0x00002200288080aeULL, 0x0000002cffffffffULL,
0x0000017800000000ULL, 0x0002354000000000ULL, 0x0000005000000000ULL, 0x00000c0400000000ULL,
0x808c288080ae0900ULL, 0x0000000000002880ULL, 0x000000c4ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080850828808081ULL,
0x8e082880808a0828ULL, 0x2880808f08288080ULL, 0x8092082880809008ULL, 0x0828808093082880ULL,
0x8080950828808094ULL, 0x9708288080960828ULL, 0x2880809d08288080ULL, 0x80a408288080a208ULL,
0x08288080aa082880ULL, 0x8080b608288080b4ULL, 0xbc08288080b80828ULL, 0x288080bd08288080ULL,
0x80c108288080be08ULL, 0x08288080c5082880ULL, 0x8080c708288080c6ULL, 0xc408288080c90828ULL,
0x2880828016288080ULL, 0x0000000000000310ULL, 0x00288080c4920000ULL, 0x0000000000000022ULL,
0x0000001cffffffffULL, 0x0000028000000000ULL, 0x0002359000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x000000c4ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080850828808081ULL, 0x8e082880808a0828ULL,
0x2880808f08288080ULL, 0x8092082880809008ULL, 0x0828808093082880ULL, 0x8080950828808094ULL,
0x9708288080960828ULL, 0x2880809d08288080ULL, 0x80a408288080a208ULL, 0x08288080aa082880ULL,
0x8080b608288080b4ULL, 0xbc08288080b80828ULL, 0x288080be08288080ULL, 0x80c408288080c108ULL,
0x08288080c5082880ULL, 0x8080c708288080c6ULL, 0xbd08288080c90828ULL, 0x2880828016288080ULL,
0x0000000000000310ULL, 0x00288080bd920000ULL, 0x0000000000000022ULL, 0x0000002cffffffffULL,
0x0000037800000000ULL, 0x000235d000000000ULL, 0x0000013000000000ULL, 0x0000140400000000ULL,
0x80bc288080bd0900ULL, 0x0000000000002880ULL, 0x0000001a00082f04ULL, 0x00082304000000efULL,
0x0000000000000016ULL, 0x0000001600081204ULL, 0x0008110400000000ULL, 0x0000000000000016ULL,
0x0000001500082304ULL, 0x0008120400000000ULL, 0x0000000000000015ULL, 0x0000001500081104ULL,
0x0008230400000000ULL, 0x0000000000000014ULL, 0x0000001400081204ULL, 0x0008110400000000ULL,
0x0000000000000014ULL, 0x0000001300082304ULL, 0x0008120400000000ULL, 0x0000000000000013ULL,
0x0000001300081104ULL, 0x0008230400000000ULL, 0x000000000000001aULL, 0x0000001a00081204ULL,
0x0008110400000000ULL, 0x000000000000001aULL, 0x0000007b00043704ULL, 0x00080a0400003501ULL,
0x0050016000000017ULL, 0x000c170400501903ULL, 0x0048000600000000ULL, 0x000c17040021f000ULL,
0x0040000500000000ULL, 0x000c17040021f000ULL, 0x0038000400000000ULL, 0x000c17040011f000ULL,
0x0018000300000000ULL, 0x000c17040081f000ULL, 0x0010000200000000ULL, 0x000c17040021f000ULL,
0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL,
0x0000002000043104ULL, 0xffffffff01982904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x01982804ffffffffULL, 0x00000100000000e0ULL, 0x000020e000000460ULL, 0x0000226000002170ULL,
0x00002820000023d0ULL, 0x000028b000002850ULL, 0x000055f000002910ULL, 0x0000568000005620ULL,
0x00008450000056e0ULL, 0x000085f0000084e0ULL, 0x00008be000008750ULL, 0x00008c7000008c10ULL,
0x0000b7c000008cd0ULL, 0x0000b8500000b7f0ULL, 0x0000e5100000b8b0ULL, 0x0000e6b00000e5a0ULL,
0x0000eca00000e810ULL, 0x0000ed300000ecd0ULL, 0x000118800000ed90ULL, 0x00011910000118b0ULL,
0x000145e000011970ULL, 0x0001478000014670ULL, 0x00014d70000148e0ULL, 0x00014e1000014da0ULL,
0x0001799000014e80ULL, 0x00017a30000179c0ULL, 0x00019a7000017aa0ULL, 0x0001a25000019a80ULL,
0x000214a000021460ULL, 0x000214c0000214b0ULL, 0x0002153000021510ULL, 0x0002156000021550ULL,
0x0002229000022230ULL, 0x0002237000022300ULL, 0x00022450000223e0ULL, 0x00022530000224c0ULL,
0x000225f000022590ULL, 0x000226d000022660ULL, 0x000227b000022740ULL, 0x0002289000022820ULL,
0x00022950000228f0ULL, 0x00022a30000229c0ULL, 0x00022b1000022aa0ULL, 0x00022bf000022b80ULL,
0x00022cb000022c50ULL, 0x00022d9000022d20ULL, 0x00022e9000022e10ULL, 0x00022f9000022f10ULL,
0x0002309000023010ULL, 0x0002319000023110ULL, 0x0002329000023210ULL, 0x0002339000023310ULL,
0x000001c006003904ULL, 0x00018600000000ffULL, 0x000001f0003f0100ULL, 0x000186080000000eULL,
0x000002a0003f0120ULL, 0x000186880000000eULL, 0x00000430003f0120ULL, 0x000186a80000000eULL,
0x00000450003f0120ULL, 0x000186b8000000ffULL, 0x000004e0003f0100ULL, 0x00018600000000ffULL,
0x00000630003f0107ULL, 0x0001868c00000007ULL, 0x00000690003f0102ULL, 0x0001868800000007ULL,
0x00000ef0003f0101ULL, 0x000186a8000000ffULL, 0x00001010003f0107ULL, 0x000186a8000000ffULL,
0x00001070003f0101ULL, 0x000186b8000000ffULL, 0x00001200003f0101ULL, 0x000186bc000000ffULL,
0x000013d0003f0105ULL, 0x000186bc000000ffULL, 0x00001c90003f0105ULL, 0x000186b0000000ffULL,
0x00001db0003f0107ULL, 0x000186b0000000ffULL, 0x00001e10003f0101ULL, 0x0001860800000007ULL,
0x00001e30003f0101ULL, 0x0001860c00000007ULL, 0x00002000003f0105ULL, 0x0001860c00000007ULL,
0x00002580003f0105ULL, 0x000186ac000000ffULL, 0x00002750003f0105ULL, 0x000186ac000000ffULL,
0x00004880003f0105ULL, 0x000186b8000000ffULL, 0x000048b0003f0101ULL, 0x000186bc000000ffULL,
0x00004a70003f0105ULL, 0x000186bc000000ffULL, 0x000052c0003f0105ULL, 0x000186a8000000ffULL,
0x00005340003f0107ULL, 0x000186a8000000ffULL, 0x00005370003f0101ULL, 0x000186b4000000ffULL,
0x00005540003f0105ULL, 0x000186b4000000ffULL, 0x00007580003f0105ULL, 0x000186b8000000ffULL,
0x000075f0003f0101ULL, 0x00018688000000ffULL, 0x00007650003f0101ULL, 0x000186bc000000ffULL,
0x00007820003f0105ULL, 0x000186bc000000ffULL, 0x00008070003f0105ULL, 0x000186b0000000ffULL,
0x00008170003f0107ULL, 0x000186b0000000ffULL, 0x000081d0003f0101ULL, 0x0001862800000007ULL,
0x000081f0003f0101ULL, 0x0001862c00000007ULL, 0x000083c0003f0105ULL, 0x0001862c00000007ULL,
0x00008940003f0105ULL, 0x000186ac000000ffULL, 0x00008b10003f0105ULL, 0x000186ac000000ffULL,
0x0000aa50003f0105ULL, 0x000186b8000000ffULL, 0x0000aa80003f0101ULL, 0x000186bc000000ffULL,
0x0000ac40003f0105ULL, 0x000186bc000000ffULL, 0x0000b490003f0105ULL, 0x000186a8000000ffULL,
0x0000b510003f0107ULL, 0x000186a8000000ffULL, 0x0000b540003f0101ULL, 0x000186b4000000ffULL,
0x0000b710003f0105ULL, 0x000186b4000000ffULL, 0x0000d650003f0105ULL, 0x000186b8000000ffULL,
0x0000d6c0003f0101ULL, 0x00018690000000ffULL, 0x0000d710003f0101ULL, 0x000186bc000000ffULL,
0x0000d8e0003f0105ULL, 0x000186bc000000ffULL, 0x0000e130003f0105ULL, 0x000186b0000000ffULL,
0x0000e230003f0107ULL, 0x000186b0000000ffULL, 0x0000e290003f0101ULL, 0x0001864800000007ULL,
0x0000e2b0003f0101ULL, 0x0001864c00000007ULL, 0x0000e480003f0105ULL, 0x0001864c00000007ULL,
0x0000ea00003f0105ULL, 0x000186ac000000ffULL, 0x0000ebd0003f0105ULL, 0x000186ac000000ffULL,
0x00010b10003f0105ULL, 0x000186b8000000ffULL, 0x00010b40003f0101ULL, 0x000186bc000000ffULL,
0x00010d00003f0105ULL, 0x000186bc000000ffULL, 0x00011550003f0105ULL, 0x000186a8000000ffULL,
0x000115d0003f0107ULL, 0x000186a8000000ffULL, 0x00011600003f0101ULL, 0x000186b4000000ffULL,
0x000117d0003f0105ULL, 0x000186b4000000ffULL, 0x00013710003f0105ULL, 0x000186b8000000ffULL,
0x00013780003f0101ULL, 0x00018698000000ffULL, 0x000137e0003f0101ULL, 0x000186bc000000ffULL,
0x000139b0003f0105ULL, 0x000186bc000000ffULL, 0x00014200003f0105ULL, 0x000186b0000000ffULL,
0x00014300003f0107ULL, 0x000186b0000000ffULL, 0x00014360003f0101ULL, 0x0001866800000007ULL,
0x00014380003f0101ULL, 0x0001866c00000007ULL, 0x00014550003f0105ULL, 0x0001866c00000007ULL,
0x00014ad0003f0105ULL, 0x000186ac000000ffULL, 0x00014ca0003f0105ULL, 0x000186ac000000ffULL,
0x00016c00003f0105ULL, 0x000186b8000000ffULL, 0x00016c30003f0101ULL, 0x000186bc000000ffULL,
0x00016df0003f0105ULL, 0x000186bc000000ffULL, 0x00017660003f0105ULL, 0x000186a8000000ffULL,
0x000176e0003f0107ULL, 0x000186a8000000ffULL, 0x00017710003f0101ULL, 0x000186b4000000ffULL,
0x000178e0003f0105ULL, 0x000186b4000000ffULL, 0x00019830003f0105ULL, 0x000186b8000000ffULL,
0x00019890003f0101ULL, 0x000186a0000000ffULL, 0x0001a4b0003f0101ULL, 0x00018600000000ffULL,
0x0001c0d0003f0101ULL, 0x00018604000000ffULL, 0x0001c2a0003f0105ULL, 0x00018604000000ffULL,
0x0001c610003f0105ULL, 0x00018600000000ffULL, 0x0001c640003f0101ULL, 0x00018604000000ffULL,
0x0001c800003f0105ULL, 0x00018604000000ffULL, 0x000208a0003f0105ULL, 0x000000000000003dULL,
0x000209b0003f0101ULL, 0x000000040000003dULL, 0x00020b80003f0105ULL, 0x000000040000003dULL,
0x00022080003f0105ULL, 0x000000000000003fULL, 0x000220e0003f0101ULL, 0x000000080000003fULL,
0x00022140003f0101ULL, 0x000000100000003fULL, 0x000221b0003f0101ULL, 0x000000180000003fULL,
0x00053803003f0101ULL, 0x0001a39000101c04ULL, 0x0001c9200001c860ULL, 0x00000401000221f0ULL,
0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x000000000000045cULL, 0x0000001a00000002ULL, 0x0000000000000364ULL,
0x0000001a00000002ULL, 0x000000000000025cULL, 0x0000001a00000002ULL, 0x0000000000000154ULL,
0x0000001a00000002ULL, 0x0000000000000044ULL, 0x0000001a00000002ULL, 0x0000000000000432ULL,
0x0000001a00000002ULL, 0x000000000000033aULL, 0x0000001a00000002ULL, 0x0000000000000237ULL,
0x0000001a00000002ULL, 0x000000000000012aULL, 0x0000001a00000002ULL, 0x0000000000018700ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x00000000000e7919ULL, 0x000e620000002100ULL,
0x00000000000c7806ULL, 0x000fe200038e0000ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x00000000000a7919ULL, 0x000ea20000002300ULL, 0x0000000c00097300ULL, 0x000ee200000e0000ULL,
0x0000000304057899ULL, 0x000fe4000800063fULL, 0x0000000000027919ULL, 0x000ea20000002200ULL,
0x0000460000067ab9ULL, 0x000fc60000000a00ULL, 0x0000000000037919ULL, 0x000f220000002600ULL,
0x0000000c00137309ULL, 0x0002a60000000000ULL, 0x00000000003b7919ULL, 0x000ee80000002700ULL,
0x00000000000b7919ULL, 0x000ee20000000000ULL, 0x00000005ff007819ULL, 0x002fcc000001160eULL,
0x00001fff00007589ULL, 0x000fe200000e0000ULL, 0x000001000a027a24ULL, 0x004fc600078e0202ULL,
0x00001fff0a0a7589ULL, 0x000e6200000e0000ULL, 0x00000000020e7a24ULL, 0x000fc600078e020eULL,
0x0000000000027919ULL, 0x000ea40000000000ULL, 0x000000ff0e00720cULL, 0x040fe40003f25270ULL,
0x0000000f0e00780cULL, 0x040fe40003f44070ULL, 0x000000030e00780cULL, 0x040fe40003f64070ULL,
0x0000007f0e00780cULL, 0x000fe40003f84070ULL, 0x0000000b0900720cULL, 0x008fca0003f02070ULL,
0x3fffff80ff049424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff059424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff06a424ULL, 0x000fe400078e00ffULL, 0x7fffffc0ff07a424ULL, 0x000fe200078e00ffULL,
0x01860004ff009388ULL, 0x0007e20000000a00ULL, 0x000000040a087824ULL, 0x002fe400078e0200ULL,
0xff317217ff09c424ULL, 0x000fe200078e00ffULL, 0x018608060e00a388ULL, 0x0009e20000008a00ULL,
0x0000000208087824ULL, 0x000fe200078e00ffULL, 0x000000010e00780cULL, 0x000fe20003f44070ULL,
0x00000010020b7824ULL, 0x004fe200078e00ffULL, 0x018400090e00c388ULL, 0x0003e20000004800ULL,
0x00000020080f7824ULL, 0x000fc400078e00ffULL, 0x3fffff60ff04b424ULL, 0x008fe200078e00ffULL,
0x000001f00b117812ULL, 0x000fe200078ec0ffULL, 0x7fffff60ff05b424ULL, 0x000fe400078e00ffULL,
0x3fffff80ff0c9424ULL, 0x000fe400078e00ffULL, 0x0000000803067824ULL, 0x010fe200078e00ffULL,
0x018688040e00b388ULL, 0x0005e20000008a00ULL, 0x0000000108077824ULL, 0x000fe400078e0202ULL,
0x000000053b067c24ULL, 0x000fc4000f8e0206ULL, 0x7fffff00ff09a424ULL, 0x002fe200078e00ffULL,
0xffffffe00f0f7812ULL, 0x000fe200078ee207ULL, 0x00000200ff077424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff0d9424ULL, 0x000fe400078e00ffULL, 0x000000100f0f7824ULL, 0x000fe200078e00ffULL,
0x0000000808047817ULL, 0x004fe20007800000ULL, 0x0000000106057824ULL, 0x000fc800078e0208ULL,
0x0000000104047824ULL, 0x000fe200078e0a08ULL, 0x0000000108087810ULL, 0x000fc80007ffe0ffULL,
0x000000ff0400720cULL, 0x000fe20003f63070ULL, 0x0000000106067824ULL, 0x000fe200078e0208ULL,
0x000000010400780cULL, 0x000fe20003f83070ULL, 0x00005c0005047625ULL, 0x000fc800078e0007ULL,
0x0000000108107824ULL, 0x000fe200078e0202ULL, 0x0000001104047210ULL, 0x000fe20007fbe0ffULL,
0x0000002008127824ULL, 0x000fe400078e00ffULL, 0x00005c0006067625ULL, 0x000fc600078e0007ULL,
0xffffffe012107812ULL, 0x000fe200078ee210ULL, 0x3fffff00ff08a424ULL, 0x000fe200078e00ffULL,
0x0000001106067210ULL, 0x000fe20007fde0ffULL, 0x000000ffff057224ULL, 0x000fe400028e0605ULL,
0x0000001010107824ULL, 0x000fe200078e00ffULL, 0x0186a8080e00a388ULL, 0x000fe20000008a00ULL,
0x000000ffff077224ULL, 0x000fc600030e0607ULL, 0x0186b80cff009388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040f7faeULL, 0x0003e2000d901c46ULL, 0x000000ffff087224ULL, 0x000fc400078e0a13ULL,
0x00000004ff097424ULL, 0x000fe200078e00ffULL, 0x0000000006107faeULL, 0x0005e8000e101c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x01860408ffff038cULL, 0x0005e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01860000ff0079b0ULL, 0x000fe20008000a3fULL, 0x000062003b047625ULL, 0x000fc600078e0009ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000604047981ULL, 0x004ea2000c1e1900ULL,
0x000000ff0a00720cULL, 0x000fe40003f05270ULL, 0x0000003f04057810ULL, 0x044fe40007ffe0ffULL,
0x000000ff040a7810ULL, 0x000fe40007ffe0ffULL, 0x00000006ff057819ULL, 0x000fe40000011605ULL,
0x00000008ff067819ULL, 0x000fca000001160aULL, 0x00019dc000008947ULL, 0x000fea0003800000ULL,
0x000001ff0a00780cULL, 0x000fe20003f24070ULL, 0x0000000800077824ULL, 0x000fe200078e00ffULL,
0x000000ff0500720cULL, 0x000fe20003f05270ULL, 0x00000003ff087424ULL, 0x000fe200078e00ffULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01868c0807ff738cULL, 0x0003e20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0186880007ff7f8cULL, 0x0005e2000c80043fULL,
0xffffffffff087424ULL, 0x002fe200078e00ffULL, 0x0000005000008947ULL, 0x000fea0003800000ULL,
0x000000023b087824ULL, 0x000fe400078e00ffULL, 0x00006400ff0a7624ULL, 0x000fc800078e00ffULL,
0x0000640008087624ULL, 0x000fc800078e020aULL, 0x0000600008087625ULL, 0x000fcc00078e0009ULL,
0x0000000608087981ULL, 0x000324000c1e1900ULL, 0x0000580008097a24ULL, 0x012fc800078e02ffULL,
0x0000004009167824ULL, 0x000fe200078e00ffULL, 0x0000043000001947ULL, 0x000fea0003800000ULL,
0x0000000704097217ULL, 0x000fe40007800000ULL, 0x00000004ff0a7819ULL, 0x000fe40000011602ULL,
0x000000f00b187812ULL, 0x000fe200078ec0ffULL, 0x0000000109097824ULL, 0x000fe200078e0a07ULL,
0x000000020a0d7810ULL, 0x040fe20007ffe0ffULL, 0x00000001070c7824ULL, 0x040fe200078e020aULL,
0x000000040a107810ULL, 0x040fe40007ffe0ffULL, 0x000000090a00720cULL, 0x0c0fe20003f06070ULL,
0x00000001070e7824ULL, 0x000fe200078e020dULL, 0x000000060a117810ULL, 0x000fe20007ffe0ffULL,
0x00000040030a7824ULL, 0x000fe200078e020cULL, 0x000000090d00720cULL, 0x080fe20003f26070ULL,
0x000000010c0d7824ULL, 0x100fe200078e0202ULL, 0x000000091000720cULL, 0x000fe20003f46070ULL,
0x000000100c0f7824ULL, 0x000fe200078e00ffULL, 0x0000000a16197210ULL, 0x000fe20007f7e0ffULL,
0x000000010e0c7824ULL, 0x000fc400078e0202ULL, 0x000000100e137824ULL, 0x000fe200078e00ffULL,
0xfffffff00f0d7812ULL, 0x000fe200078ee20dULL, 0x000000ffff127224ULL, 0x000fe200018e06ffULL,
0x000000091100720cULL, 0x000fe20003f66070ULL, 0x0000000107107824ULL, 0x040fe200078e0210ULL,
0x000000020a097810ULL, 0x040fe20007ffe0ffULL, 0x0000000107117824ULL, 0x000fe200078e0211ULL,
0xfffffff0130f7812ULL, 0x000fe400078ee20cULL, 0x00005e00190e7a11ULL, 0x000fe400078840ffULL,
0x000000040a0c7810ULL, 0x000fc40007ffe0ffULL, 0x000000060a0a7810ULL, 0x000fe40007ffe0ffULL,
0x0000000916177210ULL, 0x000fe20007fde0ffULL, 0x0000000110097824ULL, 0x040fe200078e0202ULL,
0x00005f0019197a11ULL, 0x000fe200020f4412ULL, 0x0000001010107824ULL, 0x000fe200078e00ffULL,
0x0000000a16127210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff0a7224ULL, 0x000fe200030e06ffULL,
0x0000000c16147210ULL, 0x000fe40007f9e0ffULL, 0x00005e0017167a11ULL, 0x000fe200078c40ffULL,
0x000000ffff0c7224ULL, 0x000fe200028e06ffULL, 0x000140000d0d7811ULL, 0x000fe200078e20ffULL,
0x000000ffff157224ULL, 0x000fe200020e06ffULL, 0x00005f0017177a11ULL, 0x000fc400030f440aULL,
0x0000000e180a7210ULL, 0x000fe40007fde0ffULL, 0xfffffff010107812ULL, 0x000fe200078ee209ULL,
0x0000000111097824ULL, 0x040fe200078e0202ULL, 0x00005e0014137a11ULL, 0x000fe200078840ffULL,
0x000000ffff0b7224ULL, 0x000fe200030e0619ULL, 0x00005e00120e7a11ULL, 0x000fe200078a40ffULL,
0x0000001011117824ULL, 0x000fe200078e00ffULL, 0x00005f0014147a11ULL, 0x000fe400020f4415ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a0d7faeULL, 0x0003e2000c101c46ULL,
0x00005f0012127a11ULL, 0x000fc400028f440cULL, 0x00000018130c7210ULL, 0x080fe40007f9e0ffULL,
0x000000180e0e7210ULL, 0x080fe40007fbe0ffULL, 0xfffffff011117812ULL, 0x000fe400078ee209ULL,
0x000140000f097811ULL, 0x000fe200078e20ffULL, 0x000000ffff0f7224ULL, 0x000fe200028e0612ULL,
0x0001400010107811ULL, 0x000fe200078e20ffULL, 0x000000ffff0d7224ULL, 0x002fe200020e0614ULL,
0x00000018160a7210ULL, 0x000fc40007f1e0ffULL, 0x0001400011117811ULL, 0x000fc600078e20ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e0617ULL, 0x000000000a097faeULL, 0x0003e8000c901c46ULL,
0x000000000c107faeULL, 0x0003e8000d101c46ULL, 0x000000000e117faeULL, 0x0003e2000d901c46ULL,
0x0000038000007947ULL, 0x000fea0003800000ULL, 0x0000000702097211ULL, 0x000fe400078fe0ffULL,
0x000000f00b197812ULL, 0x000fc400078ec0ffULL, 0x00000002090c7810ULL, 0x040fe20007ffe0ffULL,
0x00000001090a7824ULL, 0x140fe200078e0202ULL, 0x0000000609107810ULL, 0x040fe20007ffe0ffULL,
0x00000010090e7824ULL, 0x000fe400078e00ffULL, 0x000000010c0d7824ULL, 0x040fe400078e0202ULL,
0x000000100c0f7824ULL, 0x000fe200078e00ffULL, 0xfffffff00e0c7812ULL, 0x000fe200078ee20aULL,
0x00000040030a7824ULL, 0x000fe200078e0209ULL, 0x00000004090e7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff00f0d7812ULL, 0x000fe400078ee20dULL, 0x0000000a16187210ULL, 0x000fe20007f1e0ffULL,
0x000000100e127824ULL, 0x000fe200078e00ffULL, 0x000000020a097810ULL, 0x040fe40007ffe0ffULL,
0x000000040a0f7810ULL, 0x040fe40007ffe0ffULL, 0x000000060a117810ULL, 0x000fe20007ffe0ffULL,
0x000000010e0a7824ULL, 0x100fe200078e0202ULL, 0x0000000916157210ULL, 0x000fe20007f3e0ffULL,
0x00000001100e7824ULL, 0x000fe200078e0202ULL, 0x0000000f16137210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff097224ULL, 0x000fe200000e06ffULL, 0x00005e0018177a11ULL, 0x000fe200078040ffULL,
0x0000001010107824ULL, 0x000fe200078e00ffULL, 0x0000001116117210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200010e06ffULL, 0xfffffff0120f7812ULL, 0x000fe200078ee20aULL,
0x000000ffff167224ULL, 0x000fe200008e06ffULL, 0x00005f0018187a11ULL, 0x000fe200000f4409ULL,
0x000000ffff097224ULL, 0x000fe200018e06ffULL, 0xfffffff010127812ULL, 0x000fc400078ee20eULL,
0x00005e00130e7a11ULL, 0x000fe400078440ffULL, 0x00005e0011107a11ULL, 0x000fe400078640ffULL,
0x00000017190a7210ULL, 0x000fe40007f1e0ffULL, 0x00005e0015147a11ULL, 0x000fe400078240ffULL,
0x00005f0013137a11ULL, 0x000fe200010f440bULL, 0x000000ffff0b7224ULL, 0x000fe200000e0618ULL,
0x00005f0011117a11ULL, 0x000fc400018f4409ULL, 0x000140000c097811ULL, 0x000fe400078e20ffULL,
0x00005f0015157a11ULL, 0x000fe400008f4416ULL, 0x00000014190c7210ULL, 0x040fe20007f1e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a097faeULL, 0x0003e2000b901c46ULL,
0x0000000e190e7210ULL, 0x040fe40007f3e0ffULL, 0x0000001019107210ULL, 0x000fe40007f5e0ffULL,
0x0001400012127811ULL, 0x000fc600078e20ffULL, 0x000000ffff117224ULL, 0x000fe200010e0611ULL,
0x000140000d097811ULL, 0x002fe200078e20ffULL, 0x000000ffff0d7224ULL, 0x000fe200000e0615ULL,
0x000140000f0a7811ULL, 0x000fe200078e20ffULL, 0x000000ffff0f7224ULL, 0x000fc600008e0613ULL,
0x000000000c097faeULL, 0x0003e8000b901c46ULL, 0x000000000e0a7faeULL, 0x0003e8000b901c46ULL,
0x0000000010127faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x000000ff0600720cULL, 0x000fe20003f05270ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0186a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff1d7224ULL, 0x000fc400078e00ffULL,
0x000000ffff097224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0186a800ff387f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0186b800ff0a7f8cULL, 0x000ee2000c80043fULL,
0x000000ffff1c7224ULL, 0x000fe200078e00ffULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x000187e000008947ULL, 0x000fea0003800000ULL,
0x000000023b0a7824ULL, 0x008fe200078e00ffULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0x00006400ff0c7624ULL, 0x000fc400078e00ffULL, 0x000000ffff387224ULL, 0x002fe400078e0039ULL,
0x000000ffff447224ULL, 0x000fe400078e000bULL, 0x000064000a0a7624ULL, 0x000fe400078e020cULL,
0xff317217ff487424ULL, 0x000fe400078e00ffULL, 0x000000ffff417224ULL, 0x000fe400078e00ffULL,
0x000000ffff377224ULL, 0x000fc400078e00ffULL, 0x0000000804057899ULL, 0x000fcc000800063fULL,
0x0000000504007c0cULL, 0x000fda000bf03070ULL, 0x000186e000000947ULL, 0x004fea0003800000ULL,
0x000000ffff0b7224ULL, 0x000fc400078e0041ULL, 0x00000000000c7805ULL, 0x000fca0000015200ULL,
0x0186bc00ff117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fe40007804844ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x000000120c127210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e0dULL, 0x003d09001200780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401200780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff117819ULL, 0x000fc80000011413ULL,
0x0000001211117211ULL, 0x000fca00078110ffULL, 0x000000ffff127224ULL, 0x000fca00000e0613ULL,
0x0000000211117819ULL, 0x000fc80000001212ULL, 0x000000110000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000114147810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0186bc00ff117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fe40007804844ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000104057890ULL, 0x000fe2000fffe03fULL, 0x0000580008087a24ULL, 0x000fc800078e02ffULL,
0x0000004008157824ULL, 0x000fe200078e00ffULL, 0x0000000506007c0cULL, 0x000fda000bf23070ULL,
0x0000048000009947ULL, 0x000fea0003800000ULL, 0x00000004ff147819ULL, 0x000fe20000011602ULL,
0x0000002004057891ULL, 0x000fc6000f8e403fULL, 0x0000000214167810ULL, 0x040fe20007ffe0ffULL,
0x00000001070d7824ULL, 0x040fe200078e0214ULL, 0x00000004143d7810ULL, 0x040fe40007ffe0ffULL,
0x00000006143f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000107117824ULL, 0x000fe400078e0216ULL,
0x000000010d087824ULL, 0x100fe400078e0202ULL, 0x00000001110c7824ULL, 0x040fe400078e0202ULL,
0x00000010113c7824ULL, 0x000fc400078e00ffULL, 0x000000100d3b7824ULL, 0x000fe400078e00ffULL,
0x0000000107137824ULL, 0x040fe200078e023dULL, 0xfffffff03c3c7812ULL, 0x000fe200078ee20cULL,
0x0000000107397824ULL, 0x000fe200078e023fULL, 0x00000020030c7811ULL, 0x000fe200078e30ffULL,
0x0000000113177824ULL, 0x000fe200078e0202ULL, 0xfffffff03b3b7812ULL, 0x000fe200078ee208ULL,
0x00000010133e7824ULL, 0x000fe200078e00ffULL, 0x0000000504087c17ULL, 0x000fe2000f800000ULL,
0x000000010d0d7824ULL, 0x000fc400078e020cULL, 0x0000000111117824ULL, 0x100fe200078e020cULL,
0x8000000508087c10ULL, 0x000fe2000fffe0ffULL, 0x0000000113127824ULL, 0x100fe200078e020cULL,
0x0000000d150d7210ULL, 0x000fe20007f1e0ffULL, 0x00000001390c7824ULL, 0x000fe200078e020cULL,
0x0000001115117210ULL, 0x000fe20007f5e0ffULL, 0x00000001393a7824ULL, 0x000fe200078e0202ULL,
0x0000001215127210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff137224ULL, 0x000fe200000e06ffULL,
0x0000000c15157210ULL, 0x000fe20007fde0ffULL, 0x0000001039407824ULL, 0x000fe200078e00ffULL,
0x00005e000d0c7a11ULL, 0x000fe200078040ffULL, 0x000000ffff397224ULL, 0x000fe200010e06ffULL,
0x0000000807087217ULL, 0x000fc40007800000ULL, 0x00005f000d0d7a11ULL, 0x000fe200000f4413ULL,
0x0000001002137824ULL, 0x000fe200078e00ffULL, 0xfffffff03e3e7812ULL, 0x000fe200078ee217ULL,
0x0000000108087824ULL, 0x000fe200078e0a07ULL, 0xfffffff040407812ULL, 0x000fe400078ee23aULL,
0x00005e0011177a11ULL, 0x000fe400078840ffULL, 0x000000f0133a7812ULL, 0x000fe400078ec0ffULL,
0x000000081400720cULL, 0x000fc40003f66070ULL, 0x00005f0011397a11ULL, 0x000fe200020f4439ULL,
0x000000ffff117224ULL, 0x000fe200030e06ffULL, 0x0000003a0c0c7210ULL, 0x000fe40007f9e0ffULL,
0x000000081600720cULL, 0x080fe20003f46070ULL, 0x000000ffff167224ULL, 0x000fe200028e06ffULL,
0x00005e0012137a11ULL, 0x000fe200078a40ffULL, 0x000000ffff0d7224ULL, 0x000fe200020e060dULL,
0x000000083d00720cULL, 0x080fe40003f06070ULL, 0x000000083f00720cULL, 0x000fc40003f86070ULL,
0x000160003b087811ULL, 0x000fe400078e20ffULL, 0x00005f0012167a11ULL, 0x000fe400028f4416ULL,
0x0000003a17127210ULL, 0x000fe20007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c087faeULL, 0x0003e2000d901c46ULL, 0x00005e0015147a11ULL, 0x000fc800078c40ffULL,
0x00005f0015157a11ULL, 0x000fe400030f4411ULL, 0x000160003e117811ULL, 0x000fe400078e20ffULL,
0x0000003a130c7210ULL, 0x082fe20007f7e0ffULL, 0x000000ffff137224ULL, 0x000fe200028e0639ULL,
0x0000003a14147210ULL, 0x000fe40007fbe0ffULL, 0x000160003c087811ULL, 0x000fe200078e20ffULL,
0x000000ffff0d7224ULL, 0x000fe200018e0616ULL, 0x0001600040167811ULL, 0x000fe200078e20ffULL,
0x000000ffff157224ULL, 0x000fc400028e0615ULL, 0x0000000012087faeULL, 0x0003e8000d101c46ULL,
0x000000000c117faeULL, 0x0003e8000c101c46ULL, 0x0000000014167faeULL, 0x0003e2000e101c46ULL,
0x000003a000007947ULL, 0x000fea0003800000ULL, 0x0000000702087211ULL, 0x000fe400078fe0ffULL,
0x0000002003117811ULL, 0x000fc400078e30ffULL, 0x00000002080d7810ULL, 0x040fe20007ffe0ffULL,
0x00000001080c7824ULL, 0x140fe200078e0202ULL, 0x0000000608167810ULL, 0x040fe20007ffe0ffULL,
0x00000010083b7824ULL, 0x000fe400078e00ffULL, 0x000000010d127824ULL, 0x040fe400078e0202ULL,
0x000000100d3c7824ULL, 0x000fe200078e00ffULL, 0xfffffff03b3b7812ULL, 0x000fe200078ee20cULL,
0x000000010d0c7824ULL, 0x000fe400078e0211ULL, 0x00000010163e7824ULL, 0x000fe200078e00ffULL,
0xfffffff03c3c7812ULL, 0x000fc400078ee212ULL, 0x0000000408127810ULL, 0x040fe20007ffe0ffULL,
0x0000000108087824ULL, 0x000fe200078e0211ULL, 0x0000000c15137210ULL, 0x000fc60007f5e0ffULL,
0x00000001120d7824ULL, 0x100fe200078e0211ULL, 0x0000000815087210ULL, 0x040fe20007f1e0ffULL,
0x0000000116117824ULL, 0x000fe400078e0211ULL, 0x0000000112147824ULL, 0x140fe200078e0202ULL,
0x0000000d150d7210ULL, 0x040fe20007f7e0ffULL, 0x00000010123d7824ULL, 0x000fe200078e00ffULL,
0x0000001115117210ULL, 0x000fe20007f9e0ffULL, 0x0000001002127824ULL, 0x000fe400078e00ffULL,
0x0000000116157824ULL, 0x000fe200078e0202ULL, 0xfffffff03d3d7812ULL, 0x000fe200078ee214ULL,
0x000000ffff397224ULL, 0x000fe200000e06ffULL, 0x00005e00080c7a11ULL, 0x000fe200078040ffULL,
0x000000ffff177224ULL, 0x000fe200010e06ffULL, 0x000000f0123a7812ULL, 0x000fc400078ec0ffULL,
0xfffffff03e3e7812ULL, 0x000fe200078ee215ULL, 0x000000ffff157224ULL, 0x000fe200018e06ffULL,
0x00005f0008397a11ULL, 0x000fe200000f4439ULL, 0x000000ffff087224ULL, 0x000fe200020e06ffULL,
0x00005e000d147a11ULL, 0x000fe400078640ffULL, 0x00005e0011167a11ULL, 0x000fe400078840ffULL,
0x0000003a0c0c7210ULL, 0x000fe40007f1e0ffULL, 0x00005e0013127a11ULL, 0x000fc400078440ffULL,
0x00005f000d157a11ULL, 0x000fe200018f4415ULL, 0x000000ffff0d7224ULL, 0x000fe200000e0639ULL,
0x00005f0011117a11ULL, 0x000fe400020f4408ULL, 0x000160003b087811ULL, 0x000fe400078e20ffULL,
0x00005f0013137a11ULL, 0x000fe400010f4417ULL, 0x0000003a12127210ULL, 0x080fe20007f1e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c087faeULL, 0x0003e2000b901c46ULL,
0x0000003a14147210ULL, 0x000fc40007f5e0ffULL, 0x0000003a16167210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff137224ULL, 0x000fe400000e0613ULL, 0x000000ffff157224ULL, 0x000fe400010e0615ULL,
0x000000ffff177224ULL, 0x000fe200018e0611ULL, 0x000160003c087811ULL, 0x002fe400078e20ffULL,
0x000160003d0c7811ULL, 0x000fe400078e20ffULL, 0x000160003e0d7811ULL, 0x000fe200078e20ffULL,
0x0000000012087faeULL, 0x0003e8000b901c46ULL, 0x00000000140c7faeULL, 0x0003e8000b901c46ULL,
0x00000000160d7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000009000007945ULL, 0x000fe20003800000ULL, 0x0000000141087810ULL, 0x000fc80007ffe0ffULL,
0x000000050800720cULL, 0x000fe20003f06070ULL, 0xffffffffff087424ULL, 0x000fd800078e00ffULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000000010a0c7810ULL, 0x000fe20007ffe041ULL,
0x00000004ff0d7424ULL, 0x000fc800078e00ffULL, 0x000060000c0c7625ULL, 0x000fca00078e000dULL,
0x000000060c087981ULL, 0x000324000c1e1900ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0186b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0186b000ff547f8cULL, 0x000ee2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0186080007147f8cULL, 0x0002a4000c80043fULL,
0x00000000000c7805ULL, 0x002fc40000015200ULL, 0x01860c0007117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x006fe40007804815ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff167224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x000000120c127210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e0dULL,
0x003d09001200780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401200780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff117819ULL, 0x000fc80000011413ULL, 0x0000001211117211ULL, 0x000fca00078110ffULL,
0x000000ffff127224ULL, 0x000fca00000e0613ULL, 0x0000000211117819ULL, 0x000fc80000001212ULL,
0x000000110000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000116167810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01860c0007117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fe40007804815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000001ff0d7819ULL, 0x000fe20000011602ULL,
0x00000010020c7824ULL, 0x000fc600078e00ffULL, 0x0000000c0d117812ULL, 0x000fe400078ec0ffULL,
0x000000700c0d7812ULL, 0x000fca00078ec0ffULL, 0x000000010d0d7824ULL, 0x000fca00078e0211ULL,
0x018000000d117984ULL, 0x000e680000000800ULL, 0x018200000d127984ULL, 0x0004e20000000800ULL,
0x000000481100720bULL, 0x002fe20003f1d000ULL, 0x000201227f007947ULL, 0x000fd8000b800000ULL,
0x0000000000137806ULL, 0x004fc800000e0100ULL, 0x0000ffff13157812ULL, 0x000fe2000780c0ffULL,
0x0000045000007945ULL, 0x000fe20003800000ULL, 0x00000001ff167424ULL, 0x000fe400078e00ffULL,
0x000000ffff427224ULL, 0x000fd200078e0048ULL, 0x0000041000008947ULL, 0x000fea0003800000ULL,
0x000000ff0000720cULL, 0x000fe40003f05270ULL, 0x000000481100720bULL, 0x000fe20003f54000ULL,
0x000200f27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000137806ULL, 0x000fc400010e0100ULL,
0x0000001148427209ULL, 0x000fe20007810000ULL, 0x0000035000017945ULL, 0x000fe20003800000ULL,
0x0000991013147816ULL, 0x000fc600000000ffULL, 0x018400420d008388ULL, 0x0003e20000000800ULL,
0x000000ff1400720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x8000004248147221ULL, 0x002fe20000010000ULL, 0x000000ff13ff7812ULL, 0x000fe2000780c0ffULL,
0x0000017000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b14147820ULL, 0x000fcc0000410000ULL,
0x0000001400147308ULL, 0x000e680000000800ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff477819ULL, 0x000fe20000011602ULL, 0x000200627f007947ULL, 0x000fea000b800000ULL,
0x00001f4714477589ULL, 0x0022a400000e0000ULL, 0x0000004728287220ULL, 0x084fe40000410000ULL,
0x0000004729297220ULL, 0x080fe40000410000ULL, 0x000000472c2c7220ULL, 0x080fe40000410000ULL,
0x000000472d2d7220ULL, 0x000fc40000410000ULL, 0x0000004730307220ULL, 0x080fe40000410000ULL,
0x0000004731317220ULL, 0x080fe40000410000ULL, 0x0000004718187220ULL, 0x080fe40000410000ULL,
0x0000004719197220ULL, 0x080fe40000410000ULL, 0x000000471c1c7220ULL, 0x080fe40000410000ULL,
0x000000471d1d7220ULL, 0x000fc40000410000ULL, 0x0000004720207220ULL, 0x080fe40000410000ULL,
0x0000004721217220ULL, 0x080fe40000410000ULL, 0x0000004724247220ULL, 0x080fe40000410000ULL,
0x0000004725257220ULL, 0x080fe40000410000ULL, 0x0000004734347220ULL, 0x080fe40000410000ULL,
0x0000004735357220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0013ff7812ULL, 0x000fe2000780c0ffULL, 0x0000001409097220ULL, 0x002fd80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000802477811ULL, 0x000fe200078ff0ffULL,
0x0001ff627f007947ULL, 0x000fea000b800000ULL, 0x00001f4714477589ULL, 0x0002a400000e0000ULL,
0x000000472a2a7220ULL, 0x084fe40000410000ULL, 0x000000472b2b7220ULL, 0x080fe40000410000ULL,
0x000000472e2e7220ULL, 0x080fe40000410000ULL, 0x000000472f2f7220ULL, 0x080fe40000410000ULL,
0x0000004732327220ULL, 0x080fe40000410000ULL, 0x0000004733337220ULL, 0x000fc40000410000ULL,
0x000000471a1a7220ULL, 0x080fe40000410000ULL, 0x000000471b1b7220ULL, 0x080fe40000410000ULL,
0x000000471e1e7220ULL, 0x080fe40000410000ULL, 0x000000471f1f7220ULL, 0x080fe40000410000ULL,
0x0000004722227220ULL, 0x080fe40000410000ULL, 0x0000004723237220ULL, 0x000fc40000410000ULL,
0x0000004726267220ULL, 0x080fe40000410000ULL, 0x0000004727277220ULL, 0x080fe40000410000ULL,
0x0000004736367220ULL, 0x080fe40000410000ULL, 0x0000004737377220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff15ff7812ULL, 0x000fda0007806013ULL,
0x8000004211110221ULL, 0x000fe20000010000ULL, 0x00007610ff160816ULL, 0x000fc60000000016ULL,
0x3fb8aa3b11110820ULL, 0x000fc80000410000ULL, 0x00000011000e0308ULL, 0x000e640000000800ULL,
0x0000000e12120220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000912097221ULL, 0x008fc40000010000ULL, 0x0000000000127805ULL, 0x000fca0000015200ULL,
0x0186ac00ff117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fe40007804838ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff177224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101700780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001412147210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e13ULL, 0x003d09001400780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401400780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff117819ULL, 0x000fc80000011415ULL,
0x0000001411117211ULL, 0x000fca00078110ffULL, 0x000000ffff147224ULL, 0x000fca00000e0615ULL,
0x0000000211117819ULL, 0x000fc80000001214ULL, 0x000000110000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000117177810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0186ac00ff117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fe40007804838ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991016117816ULL, 0x000fe200000000ffULL, 0x0000017000007945ULL, 0x000fe60003800000ULL,
0x000000ff1100720cULL, 0x000fda0003f45270ULL, 0x0000014000002947ULL, 0x000fea0003800000ULL,
0x0000000eff0f723eULL, 0x000fe400000010ffULL, 0x00000002ff117819ULL, 0x000fe40000011602ULL,
0x000054100f497816ULL, 0x000fe2000000000fULL, 0x0001fb827f007947ULL, 0x000fea000b800000ULL,
0x00001f11490f7589ULL, 0x0002a400000e0000ULL, 0x0000000811107810ULL, 0x000fe20007ffe0ffULL,
0x0001fbc27f007947ULL, 0x000fea000b800000ULL, 0x00001f1049107589ULL, 0x00066400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x0000001011477810ULL, 0x000fe20007ffe0ffULL,
0x0000001fff457424ULL, 0x000fe200078e00ffULL, 0x000028c000447802ULL, 0x000fe20000000f00ULL,
0xffffffffff467424ULL, 0x000fc400078e00ffULL, 0x00020cd000007944ULL, 0x01efea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x0000001811477810ULL, 0x000fe20007ffe0ffULL,
0x0000001fff457424ULL, 0x000fe200078e00ffULL, 0x0000292000447802ULL, 0x000fe20000000f00ULL,
0xffffffffff467424ULL, 0x004fc400078e00ffULL, 0x00020c7000007944ULL, 0x01afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000802407812ULL, 0x000fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000004ff117819ULL, 0x002fc40000011602ULL,
0x0000000740407812ULL, 0x000fe400078ef802ULL, 0x0000000200157811ULL, 0x040fe200078e10ffULL,
0x0000000400587824ULL, 0x100fe200078e0211ULL, 0x0000001040167812ULL, 0x040fe200078efcffULL,
0x0000001040137824ULL, 0x040fe400078e00ffULL, 0x0000000140127824ULL, 0x000fe200078e0258ULL,
0x0000001516597210ULL, 0x000fe20007ffe011ULL, 0x0000000111437824ULL, 0x000fe400078e0215ULL,
0x0000001040147824ULL, 0x040fe200078e00ffULL, 0xfffffff013127812ULL, 0x000fe200078ee212ULL,
0x0000000140137824ULL, 0x000fc400078e0243ULL, 0x00000001585a7824ULL, 0x000fe200078e0216ULL,
0x0001400012127811ULL, 0x000fe400078e20ffULL, 0xfffffff014137812ULL, 0x000fe200078ee213ULL,
0x0000001016147824ULL, 0x040fe400078e00ffULL, 0x000000001248783bULL, 0x008e620000004200ULL,
0x0001400013137811ULL, 0x000fe200078e20ffULL, 0x0000001016167824ULL, 0x000fe200078e00ffULL,
0xfffffff0145a7812ULL, 0x000fc600078ee25aULL, 0x000000001344783bULL, 0x004ea20000004200ULL,
0x000140005a147811ULL, 0x000fe400078e20ffULL, 0xfffffff016597812ULL, 0x000fc600078ee259ULL,
0x000000001438783bULL, 0x000ee20000004200ULL, 0x0001400059157811ULL, 0x000fca00078e20ffULL,
0x00000000153c783bULL, 0x000ee20000004200ULL, 0x00000100484f7824ULL, 0x002fe200078e00ffULL,
0x00000049009a7306ULL, 0x000fe20000009400ULL, 0x00000018ff947819ULL, 0x000fe40000011449ULL,
0x00000018ff957819ULL, 0x000fe40000011448ULL, 0x00000018ff4f7819ULL, 0x000fe4000001144fULL,
0x00000018ff887819ULL, 0x000fe2000001144bULL, 0x0000004900cb7306ULL, 0x000fe20000005400ULL,
0x00000018ff4d7819ULL, 0x004fc40000011445ULL, 0x00000018ff8b7819ULL, 0x000fe4000001144aULL,
0x00000018ff7a7819ULL, 0x008fe40000011438ULL, 0x00000018ff4e7819ULL, 0x000fe20000011444ULL,
0x0000004f00cf7306ULL, 0x000fe20000209400ULL, 0x00000018ff517819ULL, 0x000fe40000011446ULL,
0x00000018ff727819ULL, 0x000fe40000011439ULL, 0x00000018ff717819ULL, 0x000fc40000011447ULL,
0x00000018ff6e7819ULL, 0x000fe2000001143aULL, 0x0000004f00ce7306ULL, 0x000e620000205400ULL,
0x00000018ff677819ULL, 0x000fe4000001143bULL, 0x00000018ff647819ULL, 0x000fe4000001143cULL,
0x00000018ff5f7819ULL, 0x000fe4000001143eULL, 0x00000018ff5d7819ULL, 0x000fe2000001143fULL,
0x0000004f00a77306ULL, 0x0004e2000020d400ULL, 0x00000018ff607819ULL, 0x000fce000001143dULL,
0x0000004900987306ULL, 0x0006e2000000d400ULL, 0x00000100494f7824ULL, 0x004fe200078e00ffULL,
0x000000cecf00720bULL, 0x002fc80003f1d000ULL, 0x00000018ff4f7819ULL, 0x000fe4000001144fULL,
0x0000004800cc7306ULL, 0x000fe20000009400ULL, 0x0001000049497824ULL, 0x008fca00078e00ffULL,
0x00000018ff497819ULL, 0x000fe40000011449ULL, 0x0000004f00d27306ULL, 0x000fe20000209400ULL,
0x00000001a7a70812ULL, 0x000fe400078efcffULL, 0x000000cb9a00720bULL, 0x000fca0003f1d000ULL,
0x0000004f00d37306ULL, 0x000e700000205400ULL, 0x0000004800cd7306ULL, 0x000ea20000005400ULL,
0x0000000198980812ULL, 0x000fce00078efcffULL, 0x00000048009b7306ULL, 0x0006a2000000d400ULL,
0x000000d3d200720bULL, 0x002fce0003f9d000ULL, 0x0000004f00a67306ULL, 0x000e62000020d400ULL,
0x0001000048487824ULL, 0x008fe200078e00ffULL, 0x000000cdcc00720bULL, 0x004fc80003fdd000ULL,
0x00000018ff487819ULL, 0x000fe40000011448ULL, 0x0000004900d47306ULL, 0x000fee0000209400ULL,
0x000000019b9b6812ULL, 0x000fe200078efcffULL, 0x0000004900d57306ULL, 0x000ea20000205400ULL,
0x00000001a6a64812ULL, 0x002fce00078efcffULL, 0x0000004900977306ULL, 0x0002f0000020d400ULL,
0x0000004a00c77306ULL, 0x000fe20000009400ULL, 0x000001004b497824ULL, 0x002fe200078e00ffULL,
0x000000d5d400720bULL, 0x004fc80003fdd000ULL, 0x00000018ff497819ULL, 0x000fe40000011449ULL,
0x0000004a00aa7306ULL, 0x000e6e0000005400ULL, 0x0000000197976812ULL, 0x008fe200078efcffULL,
0x0000004800d17306ULL, 0x000ff00000209400ULL, 0x0000004800d07306ULL, 0x000ea20000205400ULL,
0x000000aac700720bULL, 0x002fce0003f9d000ULL, 0x0000004b00ae7306ULL, 0x000ff00000009400ULL,
0x0000004b00c47306ULL, 0x000e620000005400ULL, 0x000000d0d100720bULL, 0x004fce0003f7d000ULL,
0x0000004b008e7306ULL, 0x0004f0000000d400ULL, 0x0000004900d87306ULL, 0x000fe20000209400ULL,
0x000100004b4b7824ULL, 0x004fe200078e00ffULL, 0x000000c4ae00720bULL, 0x002fc80003fdd000ULL,
0x00000018ff4b7819ULL, 0x000fe4000001144bULL, 0x0000004900d97306ULL, 0x000e6e0000205400ULL,
0x000000018e8e6812ULL, 0x008fe200078efcffULL, 0x0000004900927306ULL, 0x0004f0000020d400ULL,
0x0000004500967306ULL, 0x000fe20000009400ULL, 0x0000010045497824ULL, 0x004fe200078e00ffULL,
0x000000d9d800720bULL, 0x002fc80003f1d000ULL, 0x00000018ff497819ULL, 0x000fe40000011449ULL,
0x0000004500bf7306ULL, 0x000fee0000005400ULL, 0x0000000192920812ULL, 0x008fe200078efcffULL,
0x0000004500867306ULL, 0x0003f0000000d400ULL, 0x0000004a008f7306ULL, 0x000ea2000000d400ULL,
0x0001000045457824ULL, 0x002fca00078e00ffULL, 0x00000018ff457819ULL, 0x000fe40000011445ULL,
0x0000004800997306ULL, 0x0002f0000020d400ULL, 0x0000009400c97306ULL, 0x000fe20000209400ULL,
0x000001004a487824ULL, 0x042fe200078e00ffULL, 0x000000018f8f4812ULL, 0x004fe200078efcffULL,
0x000100004a4a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff487819ULL, 0x000fe40000011448ULL,
0x0000009400ca7306ULL, 0x000e620000205400ULL, 0x00000018ff4a7819ULL, 0x000fe4000001144aULL,
0x0000000199993812ULL, 0x008fca00078efcffULL, 0x0000004b00dc7306ULL, 0x000ff00000209400ULL,
0x0000004b00dd7306ULL, 0x000ea20000205400ULL, 0x000000cac900720bULL, 0x002fce0003f7d000ULL,
0x0000004500e97306ULL, 0x000ff00000209400ULL, 0x0000004500e87306ULL, 0x000fe20000205400ULL,
0x000000dddc00720bULL, 0x004fce0003f9d000ULL, 0x00000045004f7306ULL, 0x0003f0000020d400ULL,
0x0000008800c67306ULL, 0x000fe20000209400ULL, 0x0000010047457824ULL, 0x002fca00078e00ffULL,
0x00000018ff457819ULL, 0x000fe40000011445ULL, 0x0000008800c37306ULL, 0x000e700000205400ULL,
0x0000009400947306ULL, 0x000eb0000020d400ULL, 0x0000004b00897306ULL, 0x000ee2000020d400ULL,
0x000000c3c600720bULL, 0x002fce0003f1d000ULL, 0x0000009500757306ULL, 0x000fe20000209400ULL,
0x0000000194943812ULL, 0x004fce00078efcffULL, 0x0000009500c87306ULL, 0x000e620000205400ULL,
0x0000000189894812ULL, 0x008fe400078efcffULL, 0x000000bf9600720bULL, 0x000fca0003f9d000ULL,
0x0000004a00da7306ULL, 0x000ff00000209400ULL, 0x0000004a00db7306ULL, 0x000ea20000205400ULL,
0x000000c87500720bULL, 0x002fe40003fbd000ULL, 0x0000000186864812ULL, 0x000fca00078efcffULL,
0x0000004500e67306ULL, 0x000ff00000209400ULL, 0x0000004500e77306ULL, 0x000fe20000205400ULL,
0x000000dbda00720bULL, 0x004fce0003f7d000ULL, 0x0000004500817306ULL, 0x0003f0000020d400ULL,
0x00000038009e7306ULL, 0x000fe20000009400ULL, 0x0000010038457824ULL, 0x002fca00078e00ffULL,
0x00000018ff457819ULL, 0x000fe40000011445ULL, 0x0000003800a27306ULL, 0x000ff00000005400ULL,
0x00000038006c7306ULL, 0x0003f0000000d400ULL, 0x0000004800d67306ULL, 0x000fe20000209400ULL,
0x0001000038387824ULL, 0x002fca00078e00ffULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x0000004800d77306ULL, 0x000ff00000205400ULL, 0x0000004800937306ULL, 0x0003f0000020d400ULL,
0x0000008800887306ULL, 0x000ea2000020d400ULL, 0x0000010044487824ULL, 0x002fca00078e00ffULL,
0x00000018ff487819ULL, 0x000fe40000011448ULL, 0x0000004600567306ULL, 0x000ff00000009400ULL,
0x0000004600577306ULL, 0x000e620000005400ULL, 0x0000000188880812ULL, 0x004fce00078efcffULL,
0x0000009500957306ULL, 0x000eb0000020d400ULL, 0x0000004a008d7306ULL, 0x000ee2000020d400ULL,
0x000000575600720bULL, 0x002fe40003f1d000ULL, 0x0000000702577812ULL, 0x000fc800078ec0ffULL,
0x0000000857577812ULL, 0x000fe200078ef802ULL, 0x0000004400bd7306ULL, 0x000fe20000009400ULL,
0x0000000195955812ULL, 0x004fe400078efcffULL, 0x000000d7d600720bULL, 0x000fe20003fbd000ULL,
0x0000000111567824ULL, 0x000fc800078e0257ULL, 0x0000004400c17306ULL, 0x000e620000005400ULL,
0x000000018d8d3812ULL, 0x008fce00078efcffULL, 0x0000004d00167306ULL, 0x000fe20000209400ULL,
0x0000000193935812ULL, 0x000fce00078efcffULL, 0x0000004d00bc7306ULL, 0x000ea20000205400ULL,
0x000000c1bd00720bULL, 0x002fce0003f7d000ULL, 0x0000004800de7306ULL, 0x000ff00000209400ULL,
0x0000004800df7306ULL, 0x000e620000205400ULL, 0x000000bc1600720bULL, 0x004fce0003f9d000ULL,
0x0000003800b57306ULL, 0x000ff00000209400ULL, 0x0000003800b67306ULL, 0x000fe20000205400ULL,
0x000000dfde00720bULL, 0x002fce0003fdd000ULL, 0x00000038007e7306ULL, 0x0003f0000020d400ULL,
0x00000048004b7306ULL, 0x0004e2000020d400ULL, 0x000001003a387824ULL, 0x002fca00078e00ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000004400877306ULL, 0x000e62000000d400ULL,
0x0001000044487824ULL, 0x004fca00078e00ffULL, 0x00000018ff487819ULL, 0x000fe40000011448ULL,
0x0000004900e17306ULL, 0x000fe20000209400ULL, 0x000000014b4b6812ULL, 0x008fce00078efcffULL,
0x0000004900e07306ULL, 0x000fe20000205400ULL, 0x0000000187873812ULL, 0x002fce00078efcffULL,
0x0000004900447306ULL, 0x0003f0000020d400ULL, 0x00000046004c7306ULL, 0x0004e2000000d400ULL,
0x0000010046497824ULL, 0x002fca00078e00ffULL, 0x00000018ff497819ULL, 0x000fe40000011449ULL,
0x0000004500b77306ULL, 0x000fe20000209400ULL, 0x0001000046467824ULL, 0x004fca00078e00ffULL,
0x00000018ff467819ULL, 0x000fe40000011446ULL, 0x0000004500b87306ULL, 0x000fe20000205400ULL,
0x000000014c4c0812ULL, 0x008fce00078efcffULL, 0x00000045007d7306ULL, 0x0003f0000020d400ULL,
0x00000039009d7306ULL, 0x000fe20000009400ULL, 0x0000010039457824ULL, 0x002fca00078e00ffULL,
0x00000018ff457819ULL, 0x000fe40000011445ULL, 0x00000039009c7306ULL, 0x000ff00000005400ULL,
0x00000039006d7306ULL, 0x0003f0000000d400ULL, 0x0000003800a87306ULL, 0x000fe20000209400ULL,
0x0001000039397824ULL, 0x002fca00078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x0000003800a97306ULL, 0x000ff00000205400ULL, 0x0000003800777306ULL, 0x0003f0000020d400ULL,
0x0000004d004d7306ULL, 0x000ea2000020d400ULL, 0x000001003c387824ULL, 0x002fca00078e00ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000008b006f7306ULL, 0x000ff00000209400ULL,
0x0000008b00c57306ULL, 0x000e620000205400ULL, 0x000000014d4d4812ULL, 0x004fce00078efcffULL,
0x0000004e00c07306ULL, 0x000ff00000209400ULL, 0x0000004e00c27306ULL, 0x000ea20000205400ULL,
0x000000c56f00720bULL, 0x002fce0003fbd000ULL, 0x0000004800e47306ULL, 0x000ff00000209400ULL,
0x0000004800e37306ULL, 0x000e620000205400ULL, 0x000000c2c000720bULL, 0x004fe20003fdd000ULL,
0x0000000857c27824ULL, 0x000fcc00078e00ffULL, 0x0000004600be7306ULL, 0x000ff00000209400ULL,
0x0000004600bb7306ULL, 0x000ea20000205400ULL, 0x000000e3e400720bULL, 0x002fce0003f7d000ULL,
0x0000004700ad7306ULL, 0x000ff00000009400ULL, 0x0000004700177306ULL, 0x000fe20000005400ULL,
0x000000bbbe00720bULL, 0x004fce0003f9d000ULL, 0x0000004700507306ULL, 0x0003f0000000d400ULL,
0x0000003900b07306ULL, 0x000fe20000209400ULL, 0x0001000047477824ULL, 0x002fca00078e00ffULL,
0x00000018ff477819ULL, 0x000fe40000011447ULL, 0x0000003900b17306ULL, 0x000ff00000205400ULL,
0x0000003900767306ULL, 0x0003f0000020d400ULL, 0x0000003800bd7306ULL, 0x000fe20000209400ULL,
0x000001003b397824ULL, 0x002fca00078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x0000003800c17306ULL, 0x000ff00000205400ULL, 0x0000003800967306ULL, 0x0003f0000020d400ULL,
0x0000003a00a57306ULL, 0x000fe20000009400ULL, 0x0000000857387824ULL, 0x002fca00078e00ffULL,
0xfffffff838167812ULL, 0x000fe400078ee256ULL, 0x0000003a00a07306ULL, 0x000fe40000005400ULL,
0x0001200016387811ULL, 0x000fcc00078e20ffULL, 0x0000003a00667306ULL, 0x0003f0000000d400ULL,
0x0000003b00917306ULL, 0x000fe20000009400ULL, 0x000100003a3a7824ULL, 0x002fca00078e00ffULL,
0x00000018ff3a7819ULL, 0x000fe4000001143aULL, 0x0000003b00907306ULL, 0x000ff00000005400ULL,
0x0000003b00627306ULL, 0x0003f0000000d400ULL, 0x0000008b008b7306ULL, 0x000ea2000020d400ULL,
0x000100003b3b7824ULL, 0x002fca00078e00ffULL, 0x00000018ff3b7819ULL, 0x000fe4000001143bULL,
0x0000004e004e7306ULL, 0x000e70000020d400ULL, 0x0000004800487306ULL, 0x000ee2000020d400ULL,
0x000000018b8b5812ULL, 0x004fc400078efcffULL, 0x000000e0e100720bULL, 0x000fca0003fbd000ULL,
0x0000004600827306ULL, 0x000ea2000020d400ULL, 0x000000014e4e6812ULL, 0x002fce00078efcffULL,
0x0000004900e57306ULL, 0x000fe20000209400ULL, 0x0000000148483812ULL, 0x008fe400078efcffULL,
0x00000017ad00720bULL, 0x000fe40003f7d000ULL, 0x0000000144445812ULL, 0x000fe400078efcffULL,
0x000000e8e900720bULL, 0x000fe20003fbd000ULL, 0x0000004900e27306ULL, 0x000e620000205400ULL,
0x0000000182824812ULL, 0x004fe400078efcffULL, 0x000000b8b700720bULL, 0x000fc40003f9d000ULL,
0x0000000256177810ULL, 0x000fe40007ffe0ffULL, 0x000000484e4e723eULL, 0x000fe200000010ffULL,
0x0000004700b97306ULL, 0x000fe20000209400ULL, 0x0000000150503812ULL, 0x000fe400078efcffULL,
0x000000a29e00720bULL, 0x000fe20003f7d000ULL, 0x000001003ea27824ULL, 0x000fe200078e00ffULL,
0x000000014f4f5812ULL, 0x000fe200078efcffULL, 0x000100003f9e7824ULL, 0x000fe200078e00ffULL,
0x000000e7e600720bULL, 0x000fe20003fbd000ULL, 0x0000004700ba7306ULL, 0x000ea20000205400ULL,
0x000000e2e500720bULL, 0x002fc40003fdd000ULL, 0x000000017d7d4812ULL, 0x000fe400078efcffULL,
0xfffffff8c2177812ULL, 0x000fe400078ee217ULL, 0x0000004f4d4f723eULL, 0x000fe200000010ffULL,
0x0000004700807306ULL, 0x000e62000020d400ULL, 0x000000016c6c3812ULL, 0x000fe400078efcffULL,
0x00000018ffa27819ULL, 0x000fe400000114a2ULL, 0x0000000181815812ULL, 0x000fc400078efcffULL,
0x00000018ff9e7819ULL, 0x000fe2000001149eULL, 0x0000003900467306ULL, 0x000fe20000209400ULL,
0x000000bab900720bULL, 0x004fce0003fbd000ULL, 0x0000003900477306ULL, 0x000fec0000205400ULL,
0x0000000180805812ULL, 0x002fe400078efcffULL, 0x0000003900707306ULL, 0x0003e2000020d400ULL,
0x000000a0a500720bULL, 0x000fce0003fbd000ULL, 0x0000004500b47306ULL, 0x000fe20000209400ULL,
0x000001003d397824ULL, 0x002fca00078e00ffULL, 0x00000018ffc07819ULL, 0x000fe40000011439ULL,
0x0000004500b37306ULL, 0x000e620000205400ULL, 0x0000000166665812ULL, 0x000fce00078efcffULL,
0x00000045007f7306ULL, 0x000eb0000020d400ULL, 0x0000003a00457306ULL, 0x000fe20000209400ULL,
0x000000b3b400720bULL, 0x002fce0003f7d000ULL, 0x0000003a009a7306ULL, 0x000fec0000205400ULL,
0x000000017f7f3812ULL, 0x004fe400078efcffULL, 0x0000003a00757306ULL, 0x000fe2000020d400ULL,
0x000000909100720bULL, 0x000fce0003f7d000ULL, 0x0000003b00aa7306ULL, 0x000fec0000209400ULL,
0x0000000162623812ULL, 0x000fe400078efcffULL, 0x0000003b00ae7306ULL, 0x000ff00000205400ULL,
0x0000003b006f7306ULL, 0x0003f0000020d400ULL, 0x0000004900837306ULL, 0x000ea2000020d400ULL,
0x000000003838783bULL, 0x002e6e0000000200ULL, 0x0000005100a37306ULL, 0x000ff00000209400ULL,
0x00000051009f7306ULL, 0x000ee20000205400ULL, 0x0000000183836812ULL, 0x004fce00078efcffULL,
0x0000007a00b27306ULL, 0x000ff00000209400ULL, 0x0000007a00af7306ULL, 0x000ea20000205400ULL,
0x0000009fa300720bULL, 0x008fe20003fdd000ULL, 0x000100003ea37824ULL, 0x000fca00078e00ffULL,
0x00000018ffa37819ULL, 0x000fe200000114a3ULL, 0x0000005100517306ULL, 0x000ee2000020d400ULL,
0x0000000f3838a231ULL, 0x082fe400003400ffULL, 0x0000000f3a3aa231ULL, 0x000fe400003400ffULL,
0x000000103939a231ULL, 0x080fe400003400ffULL, 0x000000103b3ba231ULL, 0x000fe200003400ffULL,
0x0000007a007a7306ULL, 0x000e62000020d400ULL, 0x000000afb200720bULL, 0x004fce0003f9d000ULL,
0x0000007100a17306ULL, 0x000fe20000209400ULL, 0x0000000151516812ULL, 0x008fe400078efcffULL,
0x0000009c9d00720bULL, 0x000fe40003fdd000ULL, 0x000000825182723eULL, 0x000fc600000010ffULL,
0x0000007100a47306ULL, 0x000ea20000205400ULL, 0x000000017a7a4812ULL, 0x002fe400078efcffULL,
0x000000b1b000720bULL, 0x000fca0003f9d000ULL, 0x0000007100717306ULL, 0x000e62000020d400ULL,
0x000000016d6d6812ULL, 0x000fe400078efcffULL, 0x000000a9a800720bULL, 0x000fca0003fdd000ULL,
0x0000003c008c7306ULL, 0x000fe20000009400ULL, 0x000000a4a100720bULL, 0x004fe20003f1d000ULL,
0x000001003fa47824ULL, 0x000fe200078e00ffULL, 0x0000000176764812ULL, 0x000fc800078efcffULL,
0x00000018ffa47819ULL, 0x000fe200000114a4ULL, 0x0000003c008a7306ULL, 0x000ea20000005400ULL,
0x0000000177776812ULL, 0x000fe400078efcffULL, 0x0000009a4500720bULL, 0x000fc60003fdd000ULL,
0x0000000171710812ULL, 0x002fe400078efcffULL, 0x0000003c00617306ULL, 0x0002e2000000d400ULL,
0x000000b6b500720bULL, 0x000fce0003f1d000ULL, 0x0000003e00787306ULL, 0x000fe20000009400ULL,
0x000100003c3c7824ULL, 0x002fe200078e00ffULL, 0x0000008a8c00720bULL, 0x004fe40003f9d000ULL,
0x00012000178a7811ULL, 0x000fe400078e20ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000003e00797306ULL, 0x000fe20000005400ULL, 0x000000017e7e0812ULL, 0x000fe400078efcffULL,
0x0000000175756812ULL, 0x000fc400078efcffULL, 0x000000c1bd00720bULL, 0x000fe40003fdd000ULL,
0x0000000161614812ULL, 0x008fe200078efcffULL, 0x0000003e005c7306ULL, 0x0003f0000000d400ULL,
0x0000003f00637306ULL, 0x000fe20000009400ULL, 0x0000009ba73e723eULL, 0x002fc400000010ffULL,
0x0000000196966812ULL, 0x000fca00078efcffULL, 0x0000003f00657306ULL, 0x000ff00000005400ULL,
0x0000003f005b7306ULL, 0x0003f0000000d400ULL, 0x0000003d00527306ULL, 0x000fe20000009400ULL,
0x00000098a63f723eULL, 0x002fce00000010ffULL, 0x0000003d00537306ULL, 0x000fe20000005400ULL,
0x0000003e3828723cULL, 0x000bee0000041828ULL, 0x0000003d005e7306ULL, 0x0003e2000000d400ULL,
0x0000008f933e723eULL, 0x020fe400000010ffULL, 0x0000008e923f723eULL, 0x000fca00000010ffULL,
0x0000003c009f7306ULL, 0x000fe20000209400ULL, 0x000100003d3d7824ULL, 0x002fca00078e00ffULL,
0x00000018ff9d7819ULL, 0x000fe4000001143dULL, 0x0000003c00a17306ULL, 0x000e620000205400ULL,
0x00000097943d723eULL, 0x000fce00000010ffULL, 0x0000003c009c7306ULL, 0x0004f0000020d400ULL,
0x0000007200ac7306ULL, 0x000fe20000209400ULL, 0x00000099953c723eULL, 0x004fe400000010ffULL,
0x000000a19f00720bULL, 0x002fca0003fdd000ULL, 0x0000007200ab7306ULL, 0x000e620000205400ULL,
0x0000003c382c723cULL, 0x040f6e000004182cULL, 0x0000006700847306ULL, 0x000fe20000209400ULL,
0x0000003e383c723cULL, 0x000be20000041830ULL, 0x000000019c9c6812ULL, 0x008fe200078efcffULL,
0x000000008a30783bULL, 0x020eaa0000000200ULL, 0x0000006700857306ULL, 0x000ee20000205400ULL,
0x000000abac00720bULL, 0x002fce0003f1d000ULL, 0x0000007200727306ULL, 0x000e70000020d400ULL,
0x0000006700677306ULL, 0x000ea2000020d400ULL, 0x000000858400720bULL, 0x008fce0003f7d000ULL,
0x0000006e00497306ULL, 0x000fe20000209400ULL, 0x0000000172720812ULL, 0x002fe400078efcffULL,
0x000000474600720bULL, 0x000fe40003f1d000ULL, 0x0000008d8b46723eULL, 0x000fe400000010ffULL,
0x000000898847723eULL, 0x000fe200000010ffULL, 0x0000006e004a7306ULL, 0x000e620000205400ULL,
0x0000000167673812ULL, 0x004fe400078efcffULL, 0x000000864489723eULL, 0x000fe200000010ffULL,
0x0000000f3030a231ULL, 0x080fe200003400ffULL, 0x000000874b88723eULL, 0x000fe200000010ffULL,
0x000000463844723cULL, 0x000b620000041818ULL, 0x0000000f3232a231ULL, 0x000fe200003400ffULL,
0x000000c000bf7306ULL, 0x000fe20000209400ULL, 0x0000000170700812ULL, 0x000fe200078efcffULL,
0x000000103131a231ULL, 0x080fe200003400ffULL, 0x000000aeaa00720bULL, 0x000fe20003f1d000ULL,
0x000000103333a231ULL, 0x000fe200003400ffULL, 0x0000004c8318723eULL, 0x020fc400000010ffULL,
0x000000508119723eULL, 0x000fe200000010ffULL, 0x000000c000bc7306ULL, 0x000ea20000205400ULL,
0x0000004a4900720bULL, 0x002fe20003fbd000ULL, 0x0000004e384c723cULL, 0x000b620000041820ULL,
0x000000807183723eULL, 0x000fca00000010ffULL, 0x0000006e006e7306ULL, 0x000e62000020d400ULL,
0x000000016f6f0812ULL, 0x000fe200078efcffULL, 0x000000883848723cULL, 0x000be2000004181cULL,
0x000000797800720bULL, 0x000fe40003f1d000ULL, 0x000000667720723eULL, 0x020fe400000010ffULL,
0x000000627021723eULL, 0x000fe200000010ffULL, 0x000000c000ad7306ULL, 0x000ee2000020d400ULL,
0x000000bcbf00720bULL, 0x004fe40003f7d000ULL, 0x0000007e7a1c723eULL, 0x000fc400000010ffULL,
0x00000076721d723eULL, 0x000fc600000010ffULL, 0x0000009d00a07306ULL, 0x000fe20000209400ULL,
0x000000016e6e5812ULL, 0x002fe400078efcffULL, 0x000000535200720bULL, 0x000fe20003fbd000ULL,
0x0000001c301c723cULL, 0x000fe2000004182cULL, 0x000000015c5c0812ULL, 0x000fc600078efcffULL,
0x0000009d00987306ULL, 0x000e620000205400ULL, 0x00000001adad3812ULL, 0x008fc600078efcffULL,
0x000000183850723cULL, 0x040b680000041824ULL, 0x00000064007b7306ULL, 0x000fe20000209400ULL,
0x000000015e5e5812ULL, 0x000fe400078efcffULL, 0x0000006c7d18723eULL, 0x020fe200000010ffULL,
0x000000823838723cULL, 0x000f620000041834ULL, 0x0000006d7f19723eULL, 0x000fe400000010ffULL,
0x000000756e24723eULL, 0x000fe200000010ffULL, 0x00000064007c7306ULL, 0x000ea20000205400ULL,
0x00000098a000720bULL, 0x002fc40003f7d000ULL, 0x0000006f6725723eULL, 0x000fe200000010ffULL,
0x000000183018723cULL, 0x040b680000041828ULL, 0x0000009d00947306ULL, 0x000e66000020d400ULL,
0x000000619628723eULL, 0x020fe200000010ffULL, 0x000000243024723cULL, 0x000b620000041844ULL,
0x0000005ead29723eULL, 0x000fc600000010ffULL, 0x0000006000737306ULL, 0x000fe20000209400ULL,
0x0000007c7b00720bULL, 0x004fce0003f9d000ULL, 0x0000006000747306ULL, 0x000ea20000205400ULL,
0x0000000194943812ULL, 0x002fce00078efcffULL, 0x000000a2008e7306ULL, 0x000ff00000209400ULL,
0x000000a2008b7306ULL, 0x000e620000205400ULL, 0x000000747300720bULL, 0x004fce0003fbd000ULL,
0x000000a400867306ULL, 0x000ff00000209400ULL, 0x000000a400227306ULL, 0x000ea20000205400ULL,
0x0000008b8e00720bULL, 0x002fce0003fdd000ULL, 0x0000006400647306ULL, 0x000e70000020d400ULL,
0x0000006000607306ULL, 0x000ee2000020d400ULL, 0x000000228600720bULL, 0x004fe40003f7d000ULL,
0x000000203020723cULL, 0x000b6a000004183cULL, 0x000000a200a27306ULL, 0x000ea2000020d400ULL,
0x0000000164644812ULL, 0x002fc400078efcffULL, 0x000000656300720bULL, 0x000fe40003f9d000ULL,
0x0000009c642c723eULL, 0x000fc600000010ffULL, 0x000000a400a47306ULL, 0x000e62000020d400ULL,
0x0000000160605812ULL, 0x008fc800078efcffULL, 0x00000094602d723eULL, 0x000fc600000010ffULL,
0x0000005f00687306ULL, 0x000fe20000209400ULL, 0x00000001a2a26812ULL, 0x004fe400078efcffULL,
0x000000015b5b4812ULL, 0x000fe200078efcffULL, 0x0000002c302c723cULL, 0x000b68000004184cULL,
0x0000005f00697306ULL, 0x000ea20000205400ULL, 0x00000001a4a43812ULL, 0x002fce00078efcffULL,
0x0000005d006a7306ULL, 0x000ff00000209400ULL, 0x0000005d006b7306ULL, 0x000e620000205400ULL,
0x000000696800720bULL, 0x004fce0003fbd000ULL, 0x000000a300347306ULL, 0x000ff00000209400ULL,
0x000000a300357306ULL, 0x000ea20000205400ULL, 0x0000006b6a00720bULL, 0x002fce0003fdd000ULL,
0x0000009e002a7306ULL, 0x000ff00000209400ULL, 0x0000009e002b7306ULL, 0x000e620000205400ULL,
0x000000353400720bULL, 0x004fe40003f1d000ULL, 0x0000005ca234723eULL, 0x000fc400000010ffULL,
0x0000005ba435723eULL, 0x000fc600000010ffULL, 0x0000005f005f7306ULL, 0x000ea8000020d400ULL,
0x000000343034723cULL, 0x000b680000041850ULL, 0x0000005d005d7306ULL, 0x000ee2000020d400ULL,
0x0000002b2a00720bULL, 0x002fc60003f7d000ULL, 0x000000283028723cULL, 0x000b680000041848ULL,
0x000000a300a37306ULL, 0x000e62000020d400ULL, 0x000000015f5f5812ULL, 0x004fce00078efcffULL,
0x0000009e009e7306ULL, 0x000ea2000020d400ULL, 0x000000015d5d6812ULL, 0x008fe400078efcffULL,
0x00000001a3a30812ULL, 0x002fc800078efcffULL, 0x000000a35f5c723eULL, 0x000fe400000010ffULL,
0x000000019e9e3812ULL, 0x004fc800078efcffULL, 0x0000009e5d5d723eULL, 0x000fce00000010ffULL,
0x0000005c3030723cULL, 0x000b620000041838ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0186b800ff3c7f8cULL, 0x020e62000c80043fULL, 0x000000ffff3f7224ULL, 0x000fce00078e00ffULL,
0x0000000000387805ULL, 0x000fc40000015200ULL, 0x0186bc00ff3a7984ULL, 0x000ea40000000800ULL,
0x800000003aff7812ULL, 0x006fe4000780483dULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103f00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383e7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003e00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403e00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003e3a3a7211ULL, 0x000fca00078110ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013f3f7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0186bc00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe4000780483dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000580008517a24ULL, 0x010fc800078e02ffULL, 0x0000004051517824ULL, 0x000fe200078e00ffULL,
0x0000045000009947ULL, 0x000fea0003800000ULL, 0x0000000211487810ULL, 0x000fe20007ffe0ffULL,
0x0000000107387824ULL, 0x000fe200078e0211ULL, 0x00000004114a7810ULL, 0x000fe20007ffe0ffULL,
0x0000004004057891ULL, 0x000fe2000f8e403fULL, 0x000000f00c467812ULL, 0x000fe200078ec0ffULL,
0x00000001073a7824ULL, 0x000fe400078e0248ULL, 0x0000000138397824ULL, 0x040fe400078e0202ULL,
0x0000001038477824ULL, 0x000fc400078e00ffULL, 0x0000004003457824ULL, 0x000fe400078e0238ULL,
0x0000000107387824ULL, 0x000fe200078e024aULL, 0xfffffff047477812ULL, 0x000fe200078ee239ULL,
0x000000013a3b7824ULL, 0x140fe200078e0202ULL, 0x00000051453e7210ULL, 0x040fe20007f1e0ffULL,
0x000000103a497824ULL, 0x000fe200078e00ffULL, 0x0000000245447810ULL, 0x040fe20007ffe0ffULL,
0x00000001383a7824ULL, 0x040fe200078e0202ULL, 0x00000004453f7810ULL, 0x000fe20007ffe0ffULL,
0x00000010384b7824ULL, 0x000fe200078e00ffULL, 0x0000000504387c17ULL, 0x000fe2000f800000ULL,
0x000000ffff397224ULL, 0x000fe200000e06ffULL, 0x00005e003e3d7a11ULL, 0x000fc400078040ffULL,
0x8000000538387c10ULL, 0x000fe4000fffe0ffULL, 0x00005f003e3e7a11ULL, 0x000fe400000f4439ULL,
0x0000003807387217ULL, 0x000fe40007800000ULL, 0x0000005144447210ULL, 0x080fe40007f1e0ffULL,
0xfffffff049497812ULL, 0x000fe200078ee23bULL, 0x00000001383b7824ULL, 0x000fe200078e0a07ULL,
0x000000513f3f7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff387224ULL, 0x000fe200000e06ffULL,
0x00005e00443c7a11ULL, 0x000fc400078040ffULL, 0x0000003b1100720cULL, 0x000fe20003f86070ULL,
0x000000ffff397224ULL, 0x000fe200018e06ffULL, 0xfffffff04b4b7812ULL, 0x000fe400078ee23aULL,
0x00005f0044447a11ULL, 0x000fe400000f4438ULL, 0x00005e003f3a7a11ULL, 0x000fe400078a40ffULL,
0x000000463d387210ULL, 0x000fe40007f7e0ffULL, 0x00005f003f3f7a11ULL, 0x000fc400028f4439ULL,
0x0000003b4800720cULL, 0x080fe20003f06070ULL, 0x000000ffff397224ULL, 0x000fe200018e063eULL,
0x0001400047477811ULL, 0x000fe400078e20ffULL, 0x0000000611487810ULL, 0x000fe40007ffe0ffULL,
0x00000006453d7810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000038477faeULL, 0x0003e2000e101c46ULL, 0x0000003b4a00720cULL, 0x000fe20003f66070ULL,
0x00000001073e7824ULL, 0x000fe200078e0248ULL, 0x000000513d3d7210ULL, 0x000fc40007f9e0ffULL,
0x000000463a3a7210ULL, 0x080fe20007fde0ffULL, 0x000000013e457824ULL, 0x000fe200078e0202ULL,
0x0001400049497811ULL, 0x000fe400078e20ffULL, 0x000140004b4b7811ULL, 0x000fe400078e20ffULL,
0x000000463c387210ULL, 0x002fe20007fbe0ffULL, 0x000000103e477824ULL, 0x000fe400078e00ffULL,
0x000000ffff3e7224ULL, 0x000fe200020e06ffULL, 0x00005e003d3c7a11ULL, 0x040fe200078840ffULL,
0x000000ffff397224ULL, 0x000fe200028e0644ULL, 0x0000003b4800720cULL, 0x000fe20003fa6070ULL,
0x000000ffff3b7224ULL, 0x000fe200030e063fULL, 0x00005f003d3d7a11ULL, 0x000fc400020f443eULL,
0x000000463c3c7210ULL, 0x000fe20007f9e0ffULL, 0x0000000038497faeULL, 0x0003e2000c101c46ULL,
0xfffffff047457812ULL, 0x000fc600078ee245ULL, 0x000000ffff3d7224ULL, 0x000fe200020e063dULL,
0x0001400045457811ULL, 0x000fe200078e20ffULL, 0x000000003a4b7faeULL, 0x0003e8000d901c46ULL,
0x000000003c457faeULL, 0x0003e2000e901c46ULL, 0x0000038000007947ULL, 0x000fea0003800000ULL,
0x00000001073a7824ULL, 0x000fc800078e0211ULL, 0x000000013a3b7824ULL, 0x040fe200078e0202ULL,
0x000000023a387810ULL, 0x040fe20007ffe0ffULL, 0x000000103a457824ULL, 0x000fe400078e00ffULL,
0x00000040033c7824ULL, 0x000fe400078e023aULL, 0x0000000138397824ULL, 0x040fe200078e0202ULL,
0xfffffff045457812ULL, 0x000fe200078ee23bULL, 0x00000010383d7824ULL, 0x000fe200078e00ffULL,
0x000000043a387810ULL, 0x040fe40007ffe0ffULL, 0x000000063a3a7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff03d3b7812ULL, 0x000fe200078ee239ULL, 0x0000000138397824ULL, 0x100fe200078e0202ULL,
0x000000513c3e7210ULL, 0x000fe20007f1e0ffULL, 0x00000010383d7824ULL, 0x000fe200078e00ffULL,
0x000000043c467810ULL, 0x000fe20007ffe0ffULL, 0x000000013a387824ULL, 0x040fe200078e0202ULL,
0x0001400045457811ULL, 0x000fe200078e20ffULL, 0x000000103a447824ULL, 0x000fe200078e00ffULL,
0xfffffff03d3d7812ULL, 0x000fe200078ee239ULL, 0x000000ffff3a7224ULL, 0x000fe200000e06ffULL,
0x00005e003e3f7a11ULL, 0x000fc400078040ffULL, 0xfffffff044447812ULL, 0x000fe400078ee238ULL,
0x000000023c387810ULL, 0x000fe40007ffe0ffULL, 0x00005f003e3a7a11ULL, 0x000fe400000f443aULL,
0x000000063c3c7810ULL, 0x000fe40007ffe0ffULL, 0x0000005138397210ULL, 0x080fe40007f1e0ffULL,
0x0000005146477210ULL, 0x000fc40007f7e0ffULL, 0x000000f00c3e7812ULL, 0x000fe400078ec0ffULL,
0x000000513c4a7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff3c7224ULL, 0x000fe200000e06ffULL,
0x00005e0039467a11ULL, 0x000fe200078040ffULL, 0x000000ffff487224ULL, 0x000fe200018e06ffULL,
0x0000003e3f387210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff4b7224ULL, 0x000fe200028e06ffULL,
0x00005e0047497a11ULL, 0x000fe400078840ffULL, 0x00005f00393f7a11ULL, 0x000fe200000f443cULL,
0x000000ffff397224ULL, 0x000fe200018e063aULL, 0x00005e004a4c7a11ULL, 0x000fc400078a40ffULL,
0x0000003e463a7210ULL, 0x080fe40007f1e0ffULL, 0x00005f0047487a11ULL, 0x000fe200020f4448ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000038457faeULL, 0x0003e2000b901c46ULL,
0x0000003e493c7210ULL, 0x080fe40007f7e0ffULL, 0x00005f004a4b7a11ULL, 0x000fe400028f444bULL,
0x0000003e4c3e7210ULL, 0x000fe40007f9e0ffULL, 0x0001400044447811ULL, 0x000fc400078e20ffULL,
0x000140003b387811ULL, 0x002fe200078e20ffULL, 0x000000ffff3b7224ULL, 0x000fe200000e063fULL,
0x000140003d397811ULL, 0x000fe200078e20ffULL, 0x000000ffff3d7224ULL, 0x000fe400018e0648ULL,
0x000000ffff3f7224ULL, 0x000fe200020e064bULL, 0x000000003a387faeULL, 0x0003e8000b901c46ULL,
0x000000003c397faeULL, 0x0003e8000b901c46ULL, 0x000000003e447faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0186a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0186a800ff387f8cULL, 0x000e64000c80043fULL, 0x000000ffff387224ULL, 0x002fc400078e0039ULL,
0x00000000003a7805ULL, 0x000fca0000015200ULL, 0x0186b400ff397984ULL, 0x000e640000000800ULL,
0x8000000039ff7812ULL, 0x002fc40007804855ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff3e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003c7805ULL, 0x000fcc0000015200ULL,
0x0000003c3a3c7210ULL, 0x000fca0007f1e1ffULL, 0x000000013d3d7824ULL, 0x000fe200000e0e3bULL,
0x003d09003c00780cULL, 0x000fc80003f06070ULL, 0x000000ff3d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403c00780cULL, 0x000fc80003f06070ULL,
0x000000ff3d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff397819ULL, 0x000fc8000001143dULL, 0x0000003c39397211ULL, 0x000fca00078110ffULL,
0x000000ffff3c7224ULL, 0x000fca00000e063dULL, 0x0000000239397819ULL, 0x000fc8000000123cULL,
0x000000390000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0186b400ff397984ULL, 0x000e640000000800ULL, 0x8000000039ff7812ULL, 0x002fe40007804855ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000016000007945ULL, 0x000fe20003800000ULL,
0x0000014000002947ULL, 0x000fea0003800000ULL, 0x0000000eff0f723eULL, 0x000fe400000010ffULL,
0x00000002ff397819ULL, 0x000fe40000011602ULL, 0x000054100f497816ULL, 0x000fe2000000000fULL,
0x0001ce927f007947ULL, 0x000fea000b800000ULL, 0x00001f39490f7589ULL, 0x0002a400000e0000ULL,
0x0000000839107810ULL, 0x000fe20007ffe0ffULL, 0x0001ced27f007947ULL, 0x000fea000b800000ULL,
0x00001f1049107589ULL, 0x00066400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x0000001039477810ULL, 0x000fe20007ffe0ffULL, 0x0000001fff457424ULL, 0x000fe200078e00ffULL,
0x0000569000447802ULL, 0x000fe20000000f00ULL, 0xffffffffff467424ULL, 0x000fc400078e00ffULL,
0x0001df0000007944ULL, 0x00efea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x0000001839477810ULL, 0x000fe20007ffe0ffULL, 0x0000001fff457424ULL, 0x000fe200078e00ffULL,
0x000056f000447802ULL, 0x000fe20000000f00ULL, 0xffffffffff467424ULL, 0x004fc400078e00ffULL,
0x0001dea000007944ULL, 0x00afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000160005a397811ULL, 0x002fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000140587824ULL, 0x040fe200078e0258ULL, 0x00016000593a7811ULL, 0x000fe200078e20ffULL,
0x0000000140437824ULL, 0x000fe200078e0243ULL, 0x00000000393c783bULL, 0x000e620000004200ULL,
0x0000004004057891ULL, 0x000fc6000f8e403fULL, 0x000000003a48783bULL, 0x008ee20000004200ULL,
0x000001003c3b7824ULL, 0x002fe200078e00ffULL, 0x0000003c00b47306ULL, 0x000fe20000009400ULL,
0x00000018ff727819ULL, 0x000fe4000001143cULL, 0x00000018ff687819ULL, 0x000fe2000001143dULL,
0x0000010049507824ULL, 0x008fe200078e00ffULL, 0x00000018ff3b7819ULL, 0x000fe4000001143bULL,
0x00000018ff647819ULL, 0x000fe2000001143eULL, 0x0000003c00b17306ULL, 0x000fe20000005400ULL,
0x00000018ff5d7819ULL, 0x000fc4000001143fULL, 0x00000018ff5b7819ULL, 0x000fe40000011448ULL,
0x00000018ff507819ULL, 0x000fe40000011450ULL, 0x00000018ff597819ULL, 0x000fe20000011449ULL,
0x0000003b00b37306ULL, 0x000fe20000209400ULL, 0x00000018ff547819ULL, 0x000fe4000001144aULL,
0x00000018ff527819ULL, 0x000fca000001144bULL, 0x0000003b00b27306ULL, 0x000ff00000205400ULL,
0x0000003b00787306ULL, 0x0003f0000020d400ULL, 0x0000003c00777306ULL, 0x0007e2000000d400ULL,
0x000001003d3b7824ULL, 0x002fca00078e00ffULL, 0x00000018ff3b7819ULL, 0x000fe4000001143bULL,
0x0000003d00a87306ULL, 0x000fe20000009400ULL, 0x000100003c3c7824ULL, 0x008fca00078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000003b00ad7306ULL, 0x000ff00000209400ULL,
0x0000003b00ae7306ULL, 0x000ff00000205400ULL, 0x0000003b00747306ULL, 0x0003f0000020d400ULL,
0x0000003d00a57306ULL, 0x000fe20000005400ULL, 0x000001003e3b7824ULL, 0x002fca00078e00ffULL,
0x00000018ff3b7819ULL, 0x000fe4000001143bULL, 0x0000003d006f7306ULL, 0x0003f0000000d400ULL,
0x0000003b00917306ULL, 0x000fe20000209400ULL, 0x000100003d3d7824ULL, 0x002fca00078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000003b00907306ULL, 0x000ff00000205400ULL,
0x0000003b006e7306ULL, 0x0003f0000020d400ULL, 0x0000003e00aa7306ULL, 0x000fe20000009400ULL,
0x00000010403b7824ULL, 0x002fc400078e00ffULL, 0x0000001040407824ULL, 0x000fc600078e00ffULL,
0xfffffff03b3b7812ULL, 0x000fe400078ee258ULL, 0x0000003e00a77306ULL, 0x000fe20000005400ULL,
0xfffffff040407812ULL, 0x000fe200078ee243ULL, 0x0000010048437824ULL, 0x000fe200078e00ffULL,
0x000160003b3b7811ULL, 0x000fe400078e20ffULL, 0x0001600040407811ULL, 0x000fe400078e20ffULL,
0x00000018ff437819ULL, 0x000fe20000011443ULL, 0x0000003e006c7306ULL, 0x0003e4000000d400ULL,
0x000000004044783bULL, 0x004eac0000004200ULL, 0x0000003c00ac7306ULL, 0x000fe20000209400ULL,
0x000100003e3e7824ULL, 0x002fca00078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x0000003c00ab7306ULL, 0x000ff00000205400ULL, 0x0000003c00737306ULL, 0x0003f0000020d400ULL,
0x0000003f00a27306ULL, 0x000fe20000009400ULL, 0x000001003f3c7824ULL, 0x002fca00078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000003f009f7306ULL, 0x000fe20000005400ULL,
0x00000018ff8c7819ULL, 0x004fe40000011444ULL, 0x00000018ff887819ULL, 0x000fe40000011445ULL,
0x00000018ffe37819ULL, 0x000fc60000011447ULL, 0x0000003f00627306ULL, 0x0003e2000000d400ULL,
0x00000018ff827819ULL, 0x000fce0000011446ULL, 0x0000003d009c7306ULL, 0x000fe20000209400ULL,
0x000100003f3f7824ULL, 0x002fca00078e00ffULL, 0x00000018ff657819ULL, 0x000fe4000001143fULL,
0x0000003d009b7306ULL, 0x000ff00000205400ULL, 0x0000003d006d7306ULL, 0x000ff0000020d400ULL,
0x0000003c008d7306ULL, 0x000ff00000209400ULL, 0x0000003c008b7306ULL, 0x000ff00000205400ULL,
0x0000003c00667306ULL, 0x000ff0000020d400ULL, 0x0000003e00857306ULL, 0x000ff00000209400ULL,
0x0000003e00867306ULL, 0x000ff00000205400ULL, 0x0000003e006b7306ULL, 0x0003f0000020d400ULL,
0x0000004800a07306ULL, 0x000fe20000009400ULL, 0x000000003b3c783bULL, 0x002e6e0000004200ULL,
0x0000004800a17306ULL, 0x000ff00000005400ULL, 0x00000048005f7306ULL, 0x0005f0000000d400ULL,
0x0000004400c47306ULL, 0x000fe20000009400ULL, 0x0001000048487824ULL, 0x004fca00078e00ffULL,
0x00000018ff487819ULL, 0x000fe40000011448ULL, 0x0000004400c57306ULL, 0x000ff00000005400ULL,
0x00000048007a7306ULL, 0x000fe20000209400ULL, 0x000001003c8f7824ULL, 0x002fe200078e00ffULL,
0x00000018ffb57819ULL, 0x000fe2000001143dULL, 0x000001003f937824ULL, 0x000fe200078e00ffULL,
0x00000018ff9a7819ULL, 0x000fc4000001143eULL, 0x00000018ff8f7819ULL, 0x000fe4000001148fULL,
0x00000048007b7306ULL, 0x000fe20000205400ULL, 0x00000018ff937819ULL, 0x000fe40000011493ULL,
0x00000018ff957819ULL, 0x000fca000001143fULL, 0x0000008f00d77306ULL, 0x000ff00000209400ULL,
0x0000008f00d87306ULL, 0x000e700000205400ULL, 0x0000008f00bc7306ULL, 0x0004f0000020d400ULL,
0x0000004800637306ULL, 0x0009e2000020d400ULL, 0x000001003d8f7824ULL, 0x004fe200078e00ffULL,
0x000000d8d700720bULL, 0x002fe20003f7d000ULL, 0x0000010046d87824ULL, 0x000fc600078e00ffULL,
0x00000018ff8f7819ULL, 0x000fe4000001148fULL, 0x0000003c00cf7306ULL, 0x000fe20000009400ULL,
0x00000018ff487819ULL, 0x010fe4000001143cULL, 0x00000018ffd87819ULL, 0x000fc800000114d8ULL,
0x00000001bcbc3812ULL, 0x008fe200078efcffULL, 0x0000004800d17306ULL, 0x000ff00000209400ULL,
0x0000004800d07306ULL, 0x000e700000205400ULL, 0x0000003c009d7306ULL, 0x000eb00000005400ULL,
0x0000003c00ba7306ULL, 0x000722000000d400ULL, 0x000000d0d100720bULL, 0x002fce0003fbd000ULL,
0x0000008f00db7306ULL, 0x000fe20000209400ULL, 0x000100003c3c7824ULL, 0x008fe200078e00ffULL,
0x0000009dcf00720bULL, 0x004fc80003f9d000ULL, 0x00000018ffb87819ULL, 0x000fe4000001143cULL,
0x0000008f00da7306ULL, 0x000e6e0000205400ULL, 0x00000001baba4812ULL, 0x010fe200078efcffULL,
0x0000008f00bb7306ULL, 0x0004f0000020d400ULL, 0x0000003d00d37306ULL, 0x000fe20000009400ULL,
0x000001003e8f7824ULL, 0x004fe200078e00ffULL, 0x000000dadb00720bULL, 0x002fc80003f1d000ULL,
0x00000018ff8f7819ULL, 0x000fe4000001148fULL, 0x0000003d00cd7306ULL, 0x000e6e0000005400ULL,
0x00000001bbbb0812ULL, 0x008fe200078efcffULL, 0x000000b8003c7306ULL, 0x000ff00000209400ULL,
0x000000b800d97306ULL, 0x000ea20000205400ULL, 0x000000cdd300720bULL, 0x002fe20003f7d000ULL,
0x0000010047cd7824ULL, 0x000fca00078e00ffULL, 0x00000018ffcd7819ULL, 0x000fe200000114cdULL,
0x0000004800487306ULL, 0x000e70000020d400ULL, 0x0000008f00de7306ULL, 0x000fe20000209400ULL,
0x000000d93c00720bULL, 0x004fce0003fdd000ULL, 0x0000008f00dd7306ULL, 0x000ea20000205400ULL,
0x0000000148485812ULL, 0x002fce00078efcffULL, 0x0000003d00b77306ULL, 0x0002f0000000d400ULL,
0x0000009300e07306ULL, 0x000fe20000209400ULL, 0x000100003d3d7824ULL, 0x002fe200078e00ffULL,
0x000000ddde00720bULL, 0x004fc80003fbd000ULL, 0x00000018ffb67819ULL, 0x000fe4000001143dULL,
0x0000009300df7306ULL, 0x000e620000205400ULL, 0x00000001b7b73812ULL, 0x008fce00078efcffULL,
0x000000b800b87306ULL, 0x000eb0000020d400ULL, 0x000000b500d47306ULL, 0x000fe20000209400ULL,
0x000000dfe000720bULL, 0x002fce0003f7d000ULL, 0x000000b500d67306ULL, 0x000e620000205400ULL,
0x00000001b8b86812ULL, 0x004fc800078efcffULL, 0x000000b84848723eULL, 0x000fc600000010ffULL,
0x0000008f00b07306ULL, 0x0004f0000020d400ULL, 0x0000009a00ce7306ULL, 0x000fe20000209400ULL,
0x00000100448f7824ULL, 0x004fe200078e00ffULL, 0x000000d6d400720bULL, 0x002fc80003fdd000ULL,
0x00000018ff8f7819ULL, 0x000fe4000001148fULL, 0x0000009a00cc7306ULL, 0x000e620000205400ULL,
0x00000001b0b05812ULL, 0x008fce00078efcffULL, 0x0000003e00cb7306ULL, 0x000ff00000009400ULL,
0x0000003e00b97306ULL, 0x000ea20000005400ULL, 0x000000ccce00720bULL, 0x002fce0003fbd000ULL,
0x0000003e00a47306ULL, 0x0003f0000000d400ULL, 0x0000009300af7306ULL, 0x000722000020d400ULL,
0x000100003e3e7824ULL, 0x002fe200078e00ffULL, 0x000000b9cb00720bULL, 0x004fc80003f1d000ULL,
0x00000018ff9e7819ULL, 0x000fe4000001143eULL, 0x0000003f00c77306ULL, 0x000fe20000009400ULL,
0x0000010045937824ULL, 0x008fca00078e00ffULL, 0x00000018ff937819ULL, 0x000fe40000011493ULL,
0x0000003f00c97306ULL, 0x000fe20000005400ULL, 0x00000001afaf3812ULL, 0x010fe400078efcffULL,
0x00000001a4a40812ULL, 0x000fca00078efcffULL, 0x0000003f00a37306ULL, 0x0003f0000000d400ULL,
0x0000009500d57306ULL, 0x000fe20000209400ULL, 0x000100003f3f7824ULL, 0x002fca00078e00ffULL,
0x00000018ff997819ULL, 0x000fe4000001143fULL, 0x0000009500d27306ULL, 0x000e700000205400ULL,
0x000000b600dc7306ULL, 0x000ff00000209400ULL, 0x000000b6003d7306ULL, 0x000ea20000205400ULL,
0x000000d2d500720bULL, 0x002fce0003f7d000ULL, 0x0000004400927306ULL, 0x0003f0000000d400ULL,
0x000000b500b57306ULL, 0x000ee2000020d400ULL, 0x0001000044447824ULL, 0x002fe200078e00ffULL,
0x0000003ddc00720bULL, 0x004fc80003f9d000ULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x0000009e003e7306ULL, 0x000ff00000209400ULL, 0x0000009e00e17306ULL, 0x000e620000205400ULL,
0x00000001b5b56812ULL, 0x008fce00078efcffULL, 0x0000009a009a7306ULL, 0x000eb0000020d400ULL,
0x0000009300e77306ULL, 0x000fe20000209400ULL, 0x000000e13e00720bULL, 0x002fce0003fdd000ULL,
0x0000009300e87306ULL, 0x000e620000205400ULL, 0x000000019a9a5812ULL, 0x004fce00078efcffULL,
0x00000099003f7306ULL, 0x000ff00000209400ULL, 0x0000009900e27306ULL, 0x000ea20000205400ULL,
0x000000e8e700720bULL, 0x002fce0003fbd000ULL, 0x0000004300807306ULL, 0x000ff00000209400ULL,
0x00000043007f7306ULL, 0x000fe20000205400ULL, 0x000000e23f00720bULL, 0x004fe20003f1d000ULL,
0x00000008573f7824ULL, 0x000fc400078e00ffULL, 0x0000000857577824ULL, 0x000fc800078e00ffULL,
0x0000004300677306ULL, 0x000ff0000020d400ULL, 0x0000004500c67306ULL, 0x000ff00000009400ULL,
0x0000004500437306ULL, 0x000ff00000005400ULL, 0x00000045008e7306ULL, 0x0003f0000000d400ULL,
0x0000009500957306ULL, 0x000ea2000020d400ULL, 0x0001000045457824ULL, 0x002fce00078e00ffULL,
0x000000b600b67306ULL, 0x000e70000020d400ULL, 0x0000004400e97306ULL, 0x000fe20000209400ULL,
0x0000000195953812ULL, 0x004fce00078efcffULL, 0x0000004400ea7306ULL, 0x000ea20000205400ULL,
0x00000001b6b64812ULL, 0x002fe400078efcffULL, 0x000000c9c700720bULL, 0x000fca0003f9d000ULL,
0x0000008f00e57306ULL, 0x000ff00000209400ULL, 0x0000008f00e67306ULL, 0x000e620000205400ULL,
0x000000eae900720bULL, 0x004fe40003f7d000ULL, 0x00000001a3a34812ULL, 0x000fca00078efcffULL,
0x0000008f00987306ULL, 0x0005f0000020d400ULL, 0x0000009e009e7306ULL, 0x000ee2000020d400ULL,
0x00000018ff8f7819ULL, 0x004fe40000011445ULL, 0x000000e6e500720bULL, 0x002fca0003f9d000ULL,
0x0000009300937306ULL, 0x000e70000020d400ULL, 0x0000004400947306ULL, 0x000ea2000020d400ULL,
0x000000019e9e6812ULL, 0x008fe400078efcffULL, 0x000000c5c400720bULL, 0x000fc40003fdd000ULL,
0x0000000198984812ULL, 0x000fc600078efcffULL, 0x0000008f00457306ULL, 0x000fe20000209400ULL,
0x0000000193935812ULL, 0x002fce00078efcffULL, 0x0000008f00447306ULL, 0x000e620000205400ULL,
0x0000000194943812ULL, 0x004fe400078efcffULL, 0x0000000192926812ULL, 0x000fca00078efcffULL,
0x0000009900997306ULL, 0x000eb0000020d400ULL, 0x000000d800cf7306ULL, 0x000fe20000209400ULL,
0x000000444500720bULL, 0x002fce0003fbd000ULL, 0x000000d8003c7306ULL, 0x000e620000205400ULL,
0x0000000199990812ULL, 0x004fe400078efcffULL, 0x00000043c600720bULL, 0x000fe40003f1d000ULL,
0x0000000456437810ULL, 0x040fe40007ffe0ffULL, 0x0000000656567810ULL, 0x000fe20007ffe0ffULL,
0x0000004600c17306ULL, 0x000fe20000009400ULL, 0xfffffff83f437812ULL, 0x000fc800078ee243ULL,
0x0001200043447811ULL, 0x000fc600078e20ffULL, 0x0000004600c07306ULL, 0x000ea20000005400ULL,
0x0000003ccf00720bULL, 0x002fe40003f7d000ULL, 0x000000018e8e0812ULL, 0x000fca00078efcffULL,
0x00000050007e7306ULL, 0x000ff00000209400ULL, 0x00000050007d7306ULL, 0x000fe20000205400ULL,
0x000000c0c100720bULL, 0x004fce0003fdd000ULL, 0x0000005000587306ULL, 0x000ff0000020d400ULL,
0x0000008f008f7306ULL, 0x000e70000020d400ULL, 0x0000004700bf7306ULL, 0x000ff00000009400ULL,
0x0000004700507306ULL, 0x000ea20000005400ULL, 0x000000018f8f5812ULL, 0x002fce00078efcffULL,
0x0000004700817306ULL, 0x0002f0000000d400ULL, 0x000000d8009d7306ULL, 0x000f22000020d400ULL,
0x0001000047477824ULL, 0x002fe200078e00ffULL, 0x00000050bf00720bULL, 0x004fc40003fbd000ULL,
0xfffffff857507812ULL, 0x000fe400078ee256ULL, 0x00000018ff3f7819ULL, 0x000fe40000011447ULL,
0x0000008c00c87306ULL, 0x000fee0000209400ULL, 0x0000000181815812ULL, 0x008fe200078efcffULL,
0x0000008c00ca7306ULL, 0x000e620000205400ULL, 0x000000019d9d3812ULL, 0x010fc400078efcffULL,
0x000000b1b400720bULL, 0x000fe20003f7d000ULL, 0x000100004ab47824ULL, 0x000fc800078e00ffULL,
0x0000008800c37306ULL, 0x000fe20000209400ULL, 0x00000018ffb47819ULL, 0x000fce00000114b4ULL,
0x0000008800c27306ULL, 0x000ea20000205400ULL, 0x000000cac800720bULL, 0x002fe40003f9d000ULL,
0x0000000177773812ULL, 0x000fe400078efcffULL, 0x000000aead00720bULL, 0x000fc60003f7d000ULL,
0x0000004600877306ULL, 0x0002f0000000d400ULL, 0x0000003f00c07306ULL, 0x000fe20000209400ULL,
0x0001000046467824ULL, 0x002fe200078e00ffULL, 0x000000c2c300720bULL, 0x004fc40003f1d000ULL,
0x0000000174743812ULL, 0x000fe400078efcffULL, 0x00000018ff467819ULL, 0x000fe40000011446ULL,
0x0000003f003c7306ULL, 0x000e620000205400ULL, 0x0000000187876812ULL, 0x008fc800078efcffULL,
0x000000879db8723eULL, 0x000fc600000010ffULL, 0x0000008c008c7306ULL, 0x000eb0000020d400ULL,
0x0000008800887306ULL, 0x000ee2000020d400ULL, 0x0000003cc000720bULL, 0x002fe40003fbd000ULL,
0x00012000503c7811ULL, 0x000fca00078e20ffULL, 0x000000cd00d07306ULL, 0x000fe20000209400ULL,
0x000000018c8c4812ULL, 0x004fce00078efcffULL, 0x000000cd00cb7306ULL, 0x000e620000205400ULL,
0x0000000188880812ULL, 0x008fce00078efcffULL, 0x00000046003d7306ULL, 0x000ff00000209400ULL,
0x00000046003e7306ULL, 0x000ea20000205400ULL, 0x000000cbd000720bULL, 0x002fce0003f9d000ULL,
0x0000004600c47306ULL, 0x0002f0000020d400ULL, 0x0000008200bd7306ULL, 0x000fe20000209400ULL,
0x000000004444783bULL, 0x002e620000000200ULL, 0x0000003e3d00720bULL, 0x004fcc0003f1d000ULL,
0x0000008200be7306ULL, 0x000eae0000205400ULL, 0x00000001c4c40812ULL, 0x008fe200078efcffULL,
0x000000cd00b97306ULL, 0x000ee2000020d400ULL, 0x000000b2b300720bULL, 0x000fe20003f1d000ULL,
0x000001004ab37824ULL, 0x000fc400078e00ffULL, 0x000100004bb27824ULL, 0x000fc600078e00ffULL,
0x00000018ffb37819ULL, 0x000fe200000114b3ULL, 0x0000006800977306ULL, 0x000fe20000209400ULL,
0x000000bebd00720bULL, 0x004fe20003fdd000ULL, 0x000001004bbd7824ULL, 0x000fe200078e00ffULL,
0x00000018ffb27819ULL, 0x000fc600000114b2ULL, 0x0000000178780812ULL, 0x000fe400078efcffULL,
0x0000006800967306ULL, 0x000ea20000205400ULL, 0x00000001b9b94812ULL, 0x008fe400078efcffULL,
0x000000a7aa00720bULL, 0x000fe40003f1d000ULL, 0x00000018ffbd7819ULL, 0x000fe400000114bdULL,
0x00000081b9b9723eULL, 0x000fe200000010ffULL, 0x000000e300e47306ULL, 0x000fe20000209400ULL,
0x0000000f4444a231ULL, 0x002fc400003400ffULL, 0x0000000f4646a231ULL, 0x000fe400003400ffULL,
0x000000104545a231ULL, 0x080fe400003400ffULL, 0x000000104747a231ULL, 0x000fe200003400ffULL,
0x000000e300d77306ULL, 0x000e620000205400ULL, 0x000000969700720bULL, 0x004fe40003f7d000ULL,
0x000000016c6c0812ULL, 0x000fc600078efcffULL, 0x000000b84434723cULL, 0x000fe40000041834ULL,
0x0000003f00577306ULL, 0x0004f0000020d400ULL, 0x0000008200827306ULL, 0x000f22000020d400ULL,
0x000000003c3c783bULL, 0x004ea20000000200ULL, 0x000000d7e400720bULL, 0x002fcc0003f9d000ULL,
0x0000006800687306ULL, 0x000e62000020d400ULL, 0x0000000157575812ULL, 0x008fe400078efcffULL,
0x000000abac00720bULL, 0x000fca0003fbd000ULL, 0x000000e300e37306ULL, 0x000ee2000020d400ULL,
0x0000000182826812ULL, 0x010fe400078efcffULL, 0x000000a5a800720bULL, 0x000fe40003fdd000ULL,
0x000000c48282723eULL, 0x000fc600000010ffULL, 0x0000007200a67306ULL, 0x000fe20000209400ULL,
0x0000000168683812ULL, 0x002fe400078efcffULL, 0x0000008b8d00720bULL, 0x000fe40003f7d000ULL,
0x0000000173735812ULL, 0x000fe400078efcffULL, 0x0000009fa200720bULL, 0x000fe20003fbd000ULL,
0x0000007200a97306ULL, 0x000e620000205400ULL, 0x00000001e3e34812ULL, 0x008fe400078efcffULL,
0x000000016f6f6812ULL, 0x000fc400078efcffULL, 0x0000009b9c00720bULL, 0x000fc60003fdd000ULL,
0x0000004900897306ULL, 0x000fe20000009400ULL, 0x0000000f3c3ca231ULL, 0x084fe200003400ffULL,
0x0000000166663812ULL, 0x000fe200078efcffULL, 0x0000000f3e3ea231ULL, 0x000fe200003400ffULL,
0x0000000162625812ULL, 0x000fe200078efcffULL, 0x000000103d3da231ULL, 0x080fe400003400ffULL,
0x000000103f3fa231ULL, 0x000fe200003400ffULL, 0x00000049008a7306ULL, 0x000ea20000005400ULL,
0x000000a9a600720bULL, 0x002fe40003f9d000ULL, 0x000000909100720bULL, 0x000fc40003f5d000ULL,
0x000000016d6d6812ULL, 0x000fc600078efcffULL, 0x00000049005a7306ULL, 0x0002f0000000d400ULL,
0x0000007200727306ULL, 0x000f22000020d400ULL, 0x0001000049497824ULL, 0x002fe200078e00ffULL,
0x0000008a8900720bULL, 0x004fc40003fdd000ULL, 0x000000016e6e2812ULL, 0x000fe400078efcffULL,
0x00000018ff497819ULL, 0x000fe40000011449ULL, 0x00000064004e7306ULL, 0x000fe20000209400ULL,
0x000000868500720bULL, 0x000fcc0003f5d000ULL, 0x000000015a5a6812ULL, 0x008fe200078efcffULL,
0x00000064004f7306ULL, 0x000e620000205400ULL, 0x0000000172724812ULL, 0x010fe400078efcffULL,
0x000000a1a000720bULL, 0x000fc60003f9d000ULL, 0x000000016b6b2812ULL, 0x000fe400078efcffULL,
0x0000005d004c7306ULL, 0x000ff00000209400ULL, 0x0000005d004d7306ULL, 0x000ea20000205400ULL,
0x0000004f4e00720bULL, 0x002fc40003f1d000ULL, 0x000000948c4e723eULL, 0x000fe400000010ffULL,
0x0000008f884f723eULL, 0x000fe400000010ffULL, 0x000000015f5f4812ULL, 0x000fe200078efcffULL,
0x0000004900b17306ULL, 0x000fe20000209400ULL, 0x0000007b7a00720bULL, 0x000fce0003f9d000ULL,
0x0000004900a57306ULL, 0x000fe20000205400ULL, 0x0000004d4c00720bULL, 0x004fe40003f7d000ULL,
0x0000004e444c723cULL, 0x000be6000004182cULL, 0x0000000163634812ULL, 0x000fe400078efcffULL,
0x0000004900567306ULL, 0x0003e4000020d400ULL, 0x00000073722c723eULL, 0x020fc400000010ffULL,
0x0000006d682d723eULL, 0x000fc800000010ffULL, 0x0000006400647306ULL, 0x000ea2000020d400ULL,
0x000000b6b549723eULL, 0x002fce00000010ffULL, 0x0000005d005d7306ULL, 0x000e62000020d400ULL,
0x00000048441c723cULL, 0x000b6e000004181cULL, 0x0000004a00797306ULL, 0x000fe20000009400ULL,
0x0000000164640812ULL, 0x004fe400078efcffULL, 0x0000007f8000720bULL, 0x000fc40003f1d000ULL,
0x0000009e9a48723eULL, 0x020fe400000010ffULL, 0x000000999549723eULL, 0x000fe200000010ffULL,
0x0000004a007c7306ULL, 0x000ea20000005400ULL, 0x000000015d5d3812ULL, 0x002fe400078efcffULL,
0x0000007d7e00720bULL, 0x000fe40003f7d000ULL, 0x0000006b6464723eULL, 0x000fe200000010ffULL,
0x000000484424723cULL, 0x000fe40000041824ULL, 0x0000004a00557306ULL, 0x0002e2000000d400ULL,
0x0000000167670812ULL, 0x000fca00078efcffULL, 0x0000002c3c2c723cULL, 0x000be4000004181cULL,
0x0000004b00757306ULL, 0x000fe20000009400ULL, 0x000000babc4a723eULL, 0x002fe400000010ffULL,
0x0000000158583812ULL, 0x000fe400078efcffULL, 0x0000007c7900720bULL, 0x004fe40003f5d000ULL,
0x000000a5b100720bULL, 0x000fe20003f7d000ULL, 0x0000004b00767306ULL, 0x000fe20000005400ULL,
0x0000005f671c723eULL, 0x020fc400000010ffULL, 0x0000005a581d723eULL, 0x000fca00000010ffULL,
0x0000004b00537306ULL, 0x0003e4000000d400ULL, 0x0000000155552812ULL, 0x008fe400078efcffULL,
0x0000000156563812ULL, 0x000fc800078efcffULL, 0x0000006500837306ULL, 0x000fe20000209400ULL,
0x000000b7bb4b723eULL, 0x002fce00000010ffULL, 0x0000006500847306ULL, 0x000e620000205400ULL,
0x0000004a4418723cULL, 0x000b6e0000041818ULL, 0x000000a4b04a723eULL, 0x020fe200000010ffULL,
0x0000005900697306ULL, 0x000fe20000209400ULL, 0x000000a3af4b723eULL, 0x000fc400000010ffULL,
0x000000848300720bULL, 0x002fca0003fbd000ULL, 0x00000059006a7306ULL, 0x000e620000205400ULL,
0x0000004a4420723cULL, 0x000b620000041820ULL, 0x00000057e383723eULL, 0x000fcc00000010ffULL,
0x0000005b00707306ULL, 0x000fe20000209400ULL, 0x00000092984a723eULL, 0x020fe400000010ffULL,
0x0000008e934b723eULL, 0x000fca00000010ffULL, 0x0000005b00717306ULL, 0x000ea20000205400ULL,
0x0000006a6900720bULL, 0x002fe20003fdd000ULL, 0x0000004a4448723cULL, 0x040b6c0000041828ULL,
0x000000b3009f7306ULL, 0x000fe20000209400ULL, 0x0000006f7429723eULL, 0x020fe200000010ffULL,
0x000000824444723cULL, 0x000b620000041830ULL, 0x000000777828723eULL, 0x000fca00000010ffULL,
0x000000b300967306ULL, 0x000e620000205400ULL, 0x000000717000720bULL, 0x004fe20003f1d000ULL,
0x000000283c28723cULL, 0x040f640000041818ULL, 0x0000006c6e30723eULL, 0x020fe400000010ffULL,
0x000000626631723eULL, 0x000fe400000010ffULL, 0x0000005900597306ULL, 0x000eaa000020d400ULL,
0x000000303c30723cULL, 0x000b660000041820ULL, 0x0000006500657306ULL, 0x000ee2000020d400ULL,
0x000000969f00720bULL, 0x002fce0003f9d000ULL, 0x0000005b005b7306ULL, 0x000e62000020d400ULL,
0x0000000159596812ULL, 0x004fc800078efcffULL, 0x000000565921723eULL, 0x020fc600000010ffULL,
0x000000b300b37306ULL, 0x000ea2000020d400ULL, 0x0000000165655812ULL, 0x008fe400078efcffULL,
0x000000767500720bULL, 0x000fe40003fbd000ULL, 0x000000655d65723eULL, 0x000fc600000010ffULL,
0x000000bd00857306ULL, 0x000fe20000209400ULL, 0x000000015b5b0812ULL, 0x002fc600078efcffULL,
0x000000643c18723cULL, 0x000b620000041824ULL, 0x000000635b20723eULL, 0x000fc600000010ffULL,
0x000000bd00867306ULL, 0x000e620000205400ULL, 0x00000001b3b34812ULL, 0x004fe400078efcffULL,
0x0000000153535812ULL, 0x000fe200078efcffULL, 0x000000203c20723cULL, 0x000b64000004184cULL,
0x00000055b324723eULL, 0x020fe400000010ffULL, 0x0000005400617306ULL, 0x000ff00000209400ULL,
0x0000005400607306ULL, 0x000ea20000205400ULL, 0x000000868500720bULL, 0x002fce0003fdd000ULL,
0x00000052005c7306ULL, 0x000ff00000209400ULL, 0x00000052005e7306ULL, 0x000e620000205400ULL,
0x000000606100720bULL, 0x004fce0003f1d000ULL, 0x000000b400577306ULL, 0x000ff00000209400ULL,
0x000000b4006f7306ULL, 0x000ea20000205400ULL, 0x0000005e5c00720bULL, 0x002fce0003f7d000ULL,
0x000000b200687306ULL, 0x000ff00000209400ULL, 0x000000b2001e7306ULL, 0x000e620000205400ULL,
0x0000006f5700720bULL, 0x004fce0003f9d000ULL, 0x000000bd00bd7306ULL, 0x000eb0000020d400ULL,
0x0000005400547306ULL, 0x000ee2000020d400ULL, 0x0000001e6800720bULL, 0x002fe40003f5d000ULL,
0x0000001c3c1c723cULL, 0x000b6a0000041848ULL, 0x0000005200527306ULL, 0x000e62000020d400ULL,
0x00000001bdbd6812ULL, 0x004fc800078efcffULL, 0x00000053bd25723eULL, 0x000fc600000010ffULL,
0x000000b400b47306ULL, 0x000ea2000020d400ULL, 0x0000000154540812ULL, 0x008fc600078efcffULL,
0x000000243c24723cULL, 0x000b680000041834ULL, 0x000000b200b27306ULL, 0x000ee2000020d400ULL,
0x0000000152523812ULL, 0x002fe400078efcffULL, 0x00000001b4b44812ULL, 0x004fc800078efcffULL,
0x000000b45454723eULL, 0x000fe400000010ffULL, 0x00000001b2b22812ULL, 0x008fc800078efcffULL,
0x000000b25255723eULL, 0x000fce00000010ffULL, 0x000000543c34723cULL, 0x000b620000041844ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0186b800ff3c7f8cULL, 0x020e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000504007c0cULL, 0x000fe2000bf03070ULL, 0x01868800ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff447224ULL, 0x002fe200078e003dULL, 0x0000000141417810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff487224ULL, 0x000fd200078e0042ULL, 0x0001228000000947ULL, 0x000fea0003800000ULL,
0x00000000003c7805ULL, 0x000fc40000015200ULL, 0x0186bc00ff087984ULL, 0x000e640000000800ULL,
0x8000000008ff7812ULL, 0x002fe40007804844ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff417224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104100780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003e7805ULL, 0x000fcc0000015200ULL,
0x0000003e3c3e7210ULL, 0x000fca0007f1e1ffULL, 0x000000013f3f7824ULL, 0x000fe200000e0e3dULL,
0x003d09003e00780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403e00780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc8000001143fULL, 0x0000003e08087211ULL, 0x000fca00078110ffULL,
0x000000ffff3e7224ULL, 0x000fca00000e063fULL, 0x0000000208087819ULL, 0x000fc8000000123eULL,
0x000000080000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000141417810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0186bc00ff087984ULL, 0x000e640000000800ULL, 0x8000000008ff7812ULL, 0x002fe40007804844ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000046000009947ULL, 0x000fea0003800000ULL,
0x0000000107087824ULL, 0x000fe200078e0211ULL, 0x00000002113d7810ULL, 0x040fe20007ffe0ffULL,
0x0000006004057891ULL, 0x000fe2000f8e403fULL, 0x0000000411447810ULL, 0x040fe20007ffe0ffULL,
0x00000001083c7824ULL, 0x040fe200078e0202ULL, 0x00000006114c7810ULL, 0x000fe20007ffe0ffULL,
0x0000001008497824ULL, 0x000fc400078e00ffULL, 0x00000001073e7824ULL, 0x040fe400078e023dULL,
0x0000000107417824ULL, 0x000fe200078e0244ULL, 0xfffffff049497812ULL, 0x000fe200078ee23cULL,
0x000000013e3f7824ULL, 0x040fe200078e0202ULL, 0x00000020033c7811ULL, 0x000fe200078e30ffULL,
0x000000103e4a7824ULL, 0x000fe200078e00ffULL, 0x0001600049497811ULL, 0x000fe200078e20ffULL,
0x00000010414b7824ULL, 0x040fe400078e00ffULL, 0x0000000108477824ULL, 0x000fe200078e023cULL,
0xfffffff04a4a7812ULL, 0x000fe200078ee23fULL, 0x00000001413f7824ULL, 0x000fe200078e0202ULL,
0x0000000504087c17ULL, 0x000fe2000f800000ULL, 0x000000013e467824ULL, 0x100fe200078e023cULL,
0x0000005147477210ULL, 0x000fe20007f1e0ffULL, 0x0000000141417824ULL, 0x000fe200078e023cULL,
0x8000000508087c10ULL, 0x000fc4000fffe0ffULL, 0xfffffff04b4b7812ULL, 0x000fe200078ee23fULL,
0x00000001073f7824ULL, 0x040fe200078e024cULL, 0x0000000807087217ULL, 0x000fe40007800000ULL,
0x0000005146467210ULL, 0x080fe20007f9e0ffULL, 0x000000013f457824ULL, 0x000fe200078e023cULL,
0x0000005141417210ULL, 0x080fe20007f7e0ffULL, 0x000000ffff3c7224ULL, 0x000fe200000e06ffULL,
0x00005e00473e7a11ULL, 0x000fe200078040ffULL, 0x000000013f487824ULL, 0x000fe200078e0202ULL,
0x0000005145517210ULL, 0x000fe20007f5e0ffULL, 0x000000103f4d7824ULL, 0x000fe200078e00ffULL,
0x00005f0047477a11ULL, 0x000fe200000f443cULL, 0x0000000108087824ULL, 0x000fe200078e0a07ULL,
0x00005e0046457a11ULL, 0x000fe200078c40ffULL, 0x000000ffff3c7224ULL, 0x000fe200020e06ffULL,
0xfffffff04d4d7812ULL, 0x000fc400078ee248ULL, 0x000000083d00720cULL, 0x080fe20003f06070ULL,
0x000000ffff3d7224ULL, 0x000fe200018e06ffULL, 0x000000f00c487812ULL, 0x000fe400078ec0ffULL,
0x00005e00413f7a11ULL, 0x000fe400078a40ffULL, 0x000000081100720cULL, 0x000fe40003f86070ULL,
0x00005f0046467a11ULL, 0x000fe400030f443cULL, 0x000000483e3c7210ULL, 0x000fe20007fde0ffULL,
0x000000ffff3e7224ULL, 0x000fe200010e06ffULL, 0x000000084400720cULL, 0x000fc40003f66070ULL,
0x00005f0041417a11ULL, 0x000fe200028f443dULL, 0x000000ffff3d7224ULL, 0x000fe200030e0647ULL,
0x00005e0051447a11ULL, 0x040fe400078a40ffULL, 0x000000084c00720cULL, 0x000fe40003f46070ULL,
0x00005f0051087a11ULL, 0x000fe200028f443eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c497faeULL, 0x0003e2000e101c46ULL, 0x00000048453e7210ULL, 0x000fe40007fbe0ffULL,
0x000160004a4a7811ULL, 0x000fc400078e20ffULL, 0x000160004b4b7811ULL, 0x000fe400078e20ffULL,
0x000160004d4d7811ULL, 0x000fe400078e20ffULL, 0x000000483f3c7210ULL, 0x082fe20007f9e0ffULL,
0x000000ffff3f7224ULL, 0x000fe200028e0646ULL, 0x0000004844447210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff3d7224ULL, 0x000fe200020e0641ULL, 0x000000003e4a7faeULL, 0x0003e2000c101c46ULL,
0x000000ffff457224ULL, 0x000fc600028e0608ULL, 0x000000003c4b7faeULL, 0x0003e8000d901c46ULL,
0x00000000444d7faeULL, 0x0003e2000d101c46ULL, 0x0000039000007947ULL, 0x000fea0003800000ULL,
0x0000000107087824ULL, 0x000fe200078e0211ULL, 0x00000020033d7811ULL, 0x000fe400078e30ffULL,
0x000000f00c497812ULL, 0x000fe200078ec0ffULL, 0x00000001083c7824ULL, 0x040fe200078e0202ULL,
0x00000002083f7810ULL, 0x040fe20007ffe0ffULL, 0x00000010084a7824ULL, 0x040fe200078e00ffULL,
0x0000000408417810ULL, 0x000fc40007ffe0ffULL, 0x0000000608447810ULL, 0x000fe20007ffe0ffULL,
0x000000013f3e7824ULL, 0x040fe200078e0202ULL, 0xfffffff04a4a7812ULL, 0x000fe200078ee23cULL,
0x000000103f4b7824ULL, 0x000fe400078e00ffULL, 0x00000001083c7824ULL, 0x000fe200078e023dULL,
0x000160004a4a7811ULL, 0x000fe200078e20ffULL, 0x000000013d087824ULL, 0x000fe200078e023fULL,
0xfffffff04b4b7812ULL, 0x000fe200078ee23eULL, 0x00000001413f7824ULL, 0x000fe200078e0202ULL,
0x000000513c3e7210ULL, 0x000fe20007f7e0ffULL, 0x000000013d3c7824ULL, 0x000fc400078e0241ULL,
0x000000013d3d7824ULL, 0x000fe200078e0244ULL, 0x00005e003e467a11ULL, 0x000fe200078840ffULL,
0x00000010414c7824ULL, 0x000fe200078e00ffULL, 0x0000000851417210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff087224ULL, 0x000fe200018e06ffULL, 0x0000003c513c7210ULL, 0x040fe20007f5e0ffULL,
0x0000000144457824ULL, 0x040fe200078e0202ULL, 0x0000003d513d7210ULL, 0x000fe20007f7e0ffULL,
0x00000010444d7824ULL, 0x000fe200078e00ffULL, 0xfffffff04c4c7812ULL, 0x000fe200078ee23fULL,
0x000000ffff477224ULL, 0x000fe200000e06ffULL, 0x00005f003e487a11ULL, 0x000fe200020f4408ULL,
0x000000ffff3f7224ULL, 0x000fe200010e06ffULL, 0xfffffff04d4d7812ULL, 0x000fe200078ee245ULL,
0x000000ffff457224ULL, 0x000fe200018e06ffULL, 0x00005e0041087a11ULL, 0x000fc400078040ffULL,
0x00005e003c3e7a11ULL, 0x000fe400078440ffULL, 0x0000004946467210ULL, 0x080fe40007f9e0ffULL,
0x00005e003d447a11ULL, 0x000fe400078640ffULL, 0x00005f0041417a11ULL, 0x000fe200000f4447ULL,
0x000000ffff477224ULL, 0x000fe200020e0648ULL, 0x00005f003c3f7a11ULL, 0x000fe400010f443fULL,
0x00000049083c7210ULL, 0x000fc40007f1e0ffULL, 0x00005f003d457a11ULL, 0x000fe200018f4445ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000464a7faeULL, 0x0003e2000b901c46ULL,
0x000000493e3e7210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff3d7224ULL, 0x000fe200000e0641ULL,
0x0000004944447210ULL, 0x000fe40007f7e0ffULL, 0x000160004b087811ULL, 0x000fe200078e20ffULL,
0x000000ffff3f7224ULL, 0x000fe200010e063fULL, 0x000160004c417811ULL, 0x000fe200078e20ffULL,
0x000000ffff457224ULL, 0x000fe400018e0645ULL, 0x000000003c087faeULL, 0x0005e2000b901c46ULL,
0x000160004d467811ULL, 0x002fc600078e20ffULL, 0x000000003e417faeULL, 0x0005e8000b901c46ULL,
0x0000000044467faeULL, 0x0005e4000b901c46ULL, 0x0000000000007918ULL, 0x004fe20000000000ULL,
0x000000020b3c7810ULL, 0x002fc80007ffe0ffULL, 0x000000053c00720cULL, 0x000fe20003f06070ULL,
0xffffffffff087424ULL, 0x000fd800078e00ffULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x000000010a3c7824ULL, 0x000fe400078e023cULL, 0x00000004ff3d7424ULL, 0x000fc800078e00ffULL,
0x000060003c3c7625ULL, 0x000fca00078e003dULL, 0x000000063c087981ULL, 0x000324000c1e1900ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0186b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0186b000ff4a7f8cULL, 0x000ea2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0186280007447f8cULL, 0x000664000c80043fULL,
0x00000000003c7805ULL, 0x002fc40000015200ULL, 0x01862c00073e7984ULL, 0x000e640000000800ULL,
0x800000003eff7812ULL, 0x002fe40007804845ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff467224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003e7805ULL, 0x000fcc0000015200ULL,
0x0000003e3c417210ULL, 0x000fca0007f1e1ffULL, 0x000000013f3f7824ULL, 0x000fe200000e0e3dULL,
0x003d09004100780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404100780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3e7819ULL, 0x000fc8000001143fULL, 0x000000413e3e7211ULL, 0x000fca00078110ffULL,
0x000000ffff3f7224ULL, 0x000fca00000e063fULL, 0x000000023e3e7819ULL, 0x000fc8000000123fULL,
0x0000003e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000146467810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01862c00073e7984ULL, 0x000e640000000800ULL, 0x800000003eff7812ULL, 0x002fe40007804845ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x018080000d3e7984ULL, 0x000e680000000800ULL,
0x018280000d3f7984ULL, 0x0006a20000000800ULL, 0x000000423e00720bULL, 0x002fe20003f1d000ULL,
0x0001a1127f007947ULL, 0x000fd8000b800000ULL, 0x0000000000417806ULL, 0x008fc800000e0100ULL,
0x0000ffff41ff7812ULL, 0x000fe2000780c0ffULL, 0x000004a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff447424ULL, 0x000fc400078e00ffULL, 0x000000ffff487224ULL, 0x000fd200078e0042ULL,
0x0000046000008947ULL, 0x000fea0003800000ULL, 0x000000010000780cULL, 0x000fe40003f05270ULL,
0x000000423e00720bULL, 0x000fe20003f54000ULL, 0x0001a0e27f007947ULL, 0x000fd8000b800000ULL,
0x00000000003c7806ULL, 0x000fc400010e0100ULL, 0x000000423e3d8209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe80003800000ULL, 0x0184803d0d008388ULL, 0x0003e40000000800ULL,
0x000099103c3d7816ULL, 0x002fc800000000ffULL, 0x000000ff3d00720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x000000423e3d7209ULL, 0x000fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff3cff7812ULL, 0x000fc6000780c0ffULL,
0x000000423d3d7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b3d3d7820ULL, 0x000fc80000410000ULL,
0x0000003d00497308ULL, 0x000e640000000800ULL, 0x0000004909097220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff3d7819ULL, 0x000fe20000011602ULL,
0x0001a0327f007947ULL, 0x000fea000b800000ULL, 0x00001f3d493d7589ULL, 0x0002e400000e0000ULL,
0x0000003d28287220ULL, 0x088fe40000410000ULL, 0x0000003d29297220ULL, 0x080fe40000410000ULL,
0x0000003d2c2c7220ULL, 0x080fe40000410000ULL, 0x0000003d2d2d7220ULL, 0x000fc40000410000ULL,
0x0000003d30307220ULL, 0x080fe40000410000ULL, 0x0000003d31317220ULL, 0x080fe40000410000ULL,
0x0000003d18187220ULL, 0x080fe40000410000ULL, 0x0000003d19197220ULL, 0x080fe40000410000ULL,
0x0000003d1c1c7220ULL, 0x080fe40000410000ULL, 0x0000003d1d1d7220ULL, 0x000fc40000410000ULL,
0x0000003d20207220ULL, 0x080fe40000410000ULL, 0x0000003d21217220ULL, 0x080fe40000410000ULL,
0x0000003d24247220ULL, 0x080fe40000410000ULL, 0x0000003d25257220ULL, 0x080fe40000410000ULL,
0x0000003d34347220ULL, 0x080fe40000410000ULL, 0x0000003d35357220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff003cff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008023d7811ULL, 0x000fe200078ff0ffULL,
0x00019f427f007947ULL, 0x000fea000b800000ULL, 0x00001f3d493d7589ULL, 0x00066400000e0000ULL,
0x0000003d2a2a7220ULL, 0x082fe40000410000ULL, 0x0000003d2b2b7220ULL, 0x080fe40000410000ULL,
0x0000003d2e2e7220ULL, 0x080fe40000410000ULL, 0x0000003d2f2f7220ULL, 0x080fe40000410000ULL,
0x0000003d32327220ULL, 0x080fe40000410000ULL, 0x0000003d33337220ULL, 0x000fc40000410000ULL,
0x0000003d1a1a7220ULL, 0x080fe40000410000ULL, 0x0000003d1b1b7220ULL, 0x080fe40000410000ULL,
0x0000003d1e1e7220ULL, 0x080fe40000410000ULL, 0x0000003d1f1f7220ULL, 0x080fe40000410000ULL,
0x0000003d22227220ULL, 0x080fe40000410000ULL, 0x0000003d23237220ULL, 0x000fc40000410000ULL,
0x0000003d26267220ULL, 0x080fe40000410000ULL, 0x0000003d27277220ULL, 0x080fe40000410000ULL,
0x0000003d36367220ULL, 0x080fe40000410000ULL, 0x0000003d37377220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000ffff3cff7812ULL, 0x000fe20007800841ULL,
0x00000001ff447424ULL, 0x000fe200078e00ffULL, 0x000000423e427209ULL, 0x000fca0007810000ULL,
0x000000ffff487224ULL, 0x000fcc00078e0042ULL, 0x800000423e3e0221ULL, 0x000fe20000010000ULL,
0x00007610ff440816ULL, 0x000fe20000000044ULL, 0x000000ffff480224ULL, 0x000fe400078e0042ULL,
0x3fb8aa3b3e3e0820ULL, 0x000fc80000410000ULL, 0x0000003e000e0308ULL, 0x000e640000000800ULL,
0x0000000e3f3f0220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000093f097221ULL, 0x004fc40000010000ULL, 0x00000000003c7805ULL, 0x000fca0000015200ULL,
0x0186ac00ff3e7984ULL, 0x000e640000000800ULL, 0x800000003eff7812ULL, 0x002fe40007804838ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff427224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003e7805ULL, 0x000fcc0000015200ULL, 0x0000003e3c417210ULL, 0x000fca0007f1e1ffULL,
0x000000013f3f7824ULL, 0x000fe200000e0e3dULL, 0x003d09004100780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404100780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3e7819ULL, 0x000fc8000001143fULL,
0x000000413e3e7211ULL, 0x000fca00078110ffULL, 0x000000ffff3f7224ULL, 0x000fca00000e063fULL,
0x000000023e3e7819ULL, 0x000fc8000000123fULL, 0x0000003e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000142427810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0186ac00ff3e7984ULL, 0x000e640000000800ULL,
0x800000003eff7812ULL, 0x002fe40007804838ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991044387816ULL, 0x000fe200000000ffULL, 0x0000017000007945ULL, 0x000fe60003800000ULL,
0x000000ff3800720cULL, 0x000fda0003f45270ULL, 0x0000014000002947ULL, 0x000fea0003800000ULL,
0x0000000eff0f723eULL, 0x000fe400000010ffULL, 0x00000002ff387819ULL, 0x000fe40000011602ULL,
0x000054100f497816ULL, 0x008fe2000000000fULL, 0x00019b227f007947ULL, 0x000fea000b800000ULL,
0x00001f38490f7589ULL, 0x0002a400000e0000ULL, 0x0000000838107810ULL, 0x000fe20007ffe0ffULL,
0x00019b627f007947ULL, 0x000fea000b800000ULL, 0x00001f1049107589ULL, 0x00066400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x0000001038477810ULL, 0x000fe20007ffe0ffULL,
0x0000001fff457424ULL, 0x000fe200078e00ffULL, 0x00008c8000447802ULL, 0x000fe20000000f00ULL,
0xffffffffff467424ULL, 0x000fc400078e00ffULL, 0x0001a91000007944ULL, 0x01efea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x0000001838477810ULL, 0x000fe20007ffe0ffULL,
0x0000001fff457424ULL, 0x000fe200078e00ffULL, 0x00008ce000447802ULL, 0x000fe20000000f00ULL,
0xffffffffff467424ULL, 0x004fc400078e00ffULL, 0x0001a8b000007944ULL, 0x01afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000000124c783bULL, 0x000ee80000004200ULL, 0x000000001354783bULL, 0x000ea80000004200ULL,
0x000000001444783bULL, 0x004ea80000004200ULL, 0x00000000153c783bULL, 0x000e620000004200ULL,
0x000001004c6e7824ULL, 0x008fe200078e00ffULL, 0x0000004c00c97306ULL, 0x000fe20000009400ULL,
0x00000018ff937819ULL, 0x000fc4000001144dULL, 0x00000018ff947819ULL, 0x000fe2000001144cULL,
0x0000010057737824ULL, 0x000fe200078e00ffULL, 0x00000018ff6e7819ULL, 0x000fe4000001146eULL,
0x00000018ff887819ULL, 0x000fe2000001144eULL, 0x0000004c00ca7306ULL, 0x000ee20000005400ULL,
0x00000018ff867819ULL, 0x000fe4000001144fULL, 0x00000018ff5b7819ULL, 0x000fe40000011456ULL,
0x00000018ff807819ULL, 0x000fc40000011454ULL, 0x00000018ff6a7819ULL, 0x004fe20000011444ULL,
0x0000006e00cb7306ULL, 0x000fe20000209400ULL, 0x00000018ff797819ULL, 0x000fe40000011455ULL,
0x00000018ff677819ULL, 0x000fe40000011445ULL, 0x00000018ff737819ULL, 0x000fe40000011473ULL,
0x00000018ff717819ULL, 0x000fe20000011457ULL, 0x0000006e00cc7306ULL, 0x000ea20000205400ULL,
0x000000cac900720bULL, 0x008fc40003f1d000ULL, 0x00000018ff657819ULL, 0x000fe40000011446ULL,
0x00000018ff5d7819ULL, 0x000fe40000011447ULL, 0x00000018ff537819ULL, 0x002fe2000001143cULL,
0x0000006e00aa7306ULL, 0x0002e2000020d400ULL, 0x00000018ff497819ULL, 0x000fe4000001143dULL,
0x00000018ff427819ULL, 0x000fe4000001143eULL, 0x00000018ff387819ULL, 0x000fc6000001143fULL,
0x0000004d00c87306ULL, 0x000fe20000009400ULL, 0x000001004d6e7824ULL, 0x002fe200078e00ffULL,
0x000000cccb00720bULL, 0x004fc80003f7d000ULL, 0x00000018ff6e7819ULL, 0x000fe4000001146eULL,
0x0000004d00727306ULL, 0x000e6e0000005400ULL, 0x00000001aaaa3812ULL, 0x008fe200078efcffULL,
0x0000004d00997306ULL, 0x0005f0000000d400ULL, 0x0000004c009b7306ULL, 0x0006e2000000d400ULL,
0x000100004d4d7824ULL, 0x004fe200078e00ffULL, 0x00000072c800720bULL, 0x002fc80003f7d000ULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x0000006e00cf7306ULL, 0x000fe20000209400ULL,
0x000100004c4c7824ULL, 0x008fca00078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe4000001144cULL,
0x0000004d00d27306ULL, 0x000fe20000209400ULL, 0x000000019b9b0812ULL, 0x000fe400078efcffULL,
0x0000000199993812ULL, 0x000fca00078efcffULL, 0x0000004d00d17306ULL, 0x000e700000205400ULL,
0x0000004c00cd7306ULL, 0x000ff00000209400ULL, 0x0000004c00ce7306ULL, 0x000ea20000205400ULL,
0x000000d1d200720bULL, 0x002fce0003f1d000ULL, 0x0000004c009a7306ULL, 0x0002f0000020d400ULL,
0x0000006e00d07306ULL, 0x000ee20000205400ULL, 0x000001004e4c7824ULL, 0x002fe200078e00ffULL,
0x000000cecd00720bULL, 0x004fc80003fbd000ULL, 0x00000018ff4c7819ULL, 0x000fe4000001144cULL,
0x0000004d00987306ULL, 0x0002ae000020d400ULL, 0x000000019a9a5812ULL, 0x008fe200078efcffULL,
0x0000004f00c17306ULL, 0x000fe20000009400ULL, 0x000000d0cf00720bULL, 0x000fe20003fdd000ULL,
0x000001004f4d7824ULL, 0x002fca00078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe2000001144dULL,
0x0000004f006d7306ULL, 0x000e620000005400ULL, 0x0000000198980812ULL, 0x004fce00078efcffULL,
0x0000009300c67306ULL, 0x000ff00000209400ULL, 0x0000009300c77306ULL, 0x000ea20000205400ULL,
0x0000006dc100720bULL, 0x002fce0003f1d000ULL, 0x0000004c00d47306ULL, 0x000ff00000209400ULL,
0x0000004c00d37306ULL, 0x000fe20000205400ULL, 0x000000c7c600720bULL, 0x004fce0003fbd000ULL,
0x0000004c00907306ULL, 0x0003f0000020d400ULL, 0x0000004e00c47306ULL, 0x000fe20000009400ULL,
0x00000100544c7824ULL, 0x002fca00078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe4000001144cULL,
0x0000004e00ad7306ULL, 0x000ff00000005400ULL, 0x0000004e008c7306ULL, 0x0003f0000000d400ULL,
0x0000009400c57306ULL, 0x000fe20000209400ULL, 0x000100004e4e7824ULL, 0x002fca00078e00ffULL,
0x00000018ff4e7819ULL, 0x000fe4000001144eULL, 0x0000009400a87306ULL, 0x000e700000205400ULL,
0x0000006e00a97306ULL, 0x0004f0000020d400ULL, 0x0000004f008b7306ULL, 0x0006e2000000d400ULL,
0x00000100566e7824ULL, 0x004fe200078e00ffULL, 0x000000a8c500720bULL, 0x002fc80003f9d000ULL,
0x00000018ff6e7819ULL, 0x000fe4000001146eULL, 0x0000004c00dc7306ULL, 0x000fe20000209400ULL,
0x000100004f4f7824ULL, 0x008fe200078e00ffULL, 0x00000001a9a96812ULL, 0x000fe400078efcffULL,
0x000000adc400720bULL, 0x000fe40003fdd000ULL, 0x00000018ff4f7819ULL, 0x000fe4000001144fULL,
0x0000004c00db7306ULL, 0x000e620000205400ULL, 0x000000018b8b0812ULL, 0x000fce00078efcffULL,
0x0000005600b77306ULL, 0x000fe20000009400ULL, 0x000000018c8c6812ULL, 0x000fce00078efcffULL,
0x0000005600b87306ULL, 0x000fe20000005400ULL, 0x000000dbdc00720bULL, 0x002fce0003f1d000ULL,
0x0000005600767306ULL, 0x0003f0000000d400ULL, 0x0000009300937306ULL, 0x000ea2000020d400ULL,
0x0001000056567824ULL, 0x002fca00078e00ffULL, 0x00000018ff567819ULL, 0x000fe40000011456ULL,
0x0000004e00d87306ULL, 0x000ff00000209400ULL, 0x0000004e00d77306ULL, 0x000e620000205400ULL,
0x0000000193935812ULL, 0x004fce00078efcffULL, 0x0000009400947306ULL, 0x000eb0000020d400ULL,
0x0000004d00d67306ULL, 0x000fe20000209400ULL, 0x000000d7d800720bULL, 0x002fce0003fbd000ULL,
0x0000004d00d57306ULL, 0x000e620000205400ULL, 0x0000000194944812ULL, 0x004fe400078efcffULL,
0x000000d3d400720bULL, 0x000fca0003f9d000ULL, 0x0000004d008f7306ULL, 0x000eb0000020d400ULL,
0x0000004f00d97306ULL, 0x000fe20000209400ULL, 0x000000d5d600720bULL, 0x002fe40003f7d000ULL,
0x0000000190904812ULL, 0x000fca00078efcffULL, 0x0000004f00da7306ULL, 0x000e6c0000205400ULL,
0x000000018f8f3812ULL, 0x004fe400078efcffULL, 0x0000005600df7306ULL, 0x000ff00000209400ULL,
0x0000005600e07306ULL, 0x000fe20000205400ULL, 0x000000dad900720bULL, 0x002fce0003fdd000ULL,
0x0000005600817306ULL, 0x0003f0000020d400ULL, 0x0000004400a07306ULL, 0x000fe20000009400ULL,
0x0000010044567824ULL, 0x002fca00078e00ffULL, 0x00000018ff567819ULL, 0x000fe40000011456ULL,
0x0000004400a37306ULL, 0x000ff00000005400ULL, 0x00000044006f7306ULL, 0x0003f0000000d400ULL,
0x0000004c004d7306ULL, 0x000ea2000020d400ULL, 0x0001000044447824ULL, 0x002fca00078e00ffULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x0000008000bc7306ULL, 0x000ff00000209400ULL,
0x0000008000bb7306ULL, 0x000e620000205400ULL, 0x000000014d4d0812ULL, 0x004fce00078efcffULL,
0x0000004e008a7306ULL, 0x0004f0000020d400ULL, 0x0000005400bf7306ULL, 0x000fe20000009400ULL,
0x00000100554e7824ULL, 0x004fe200078e00ffULL, 0x000000bbbc00720bULL, 0x002fc80003f1d000ULL,
0x00000018ff4e7819ULL, 0x000fe4000001144eULL, 0x0000005400be7306ULL, 0x000e620000005400ULL,
0x000000018a8a5812ULL, 0x008fce00078efcffULL, 0x0000005500977306ULL, 0x000ff00000009400ULL,
0x0000005500bd7306ULL, 0x000fe20000005400ULL, 0x000000bebf00720bULL, 0x002fce0003fbd000ULL,
0x0000005500857306ULL, 0x0003f0000000d400ULL, 0x0000005600eb7306ULL, 0x000fe20000209400ULL,
0x0001000055557824ULL, 0x002fca00078e00ffULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x0000005600ec7306ULL, 0x000ff00000205400ULL, 0x00000056007b7306ULL, 0x0003f0000020d400ULL,
0x0000004500a17306ULL, 0x000fe20000009400ULL, 0x0000010045567824ULL, 0x002fca00078e00ffULL,
0x00000018ff567819ULL, 0x000fe40000011456ULL, 0x00000045009c7306ULL, 0x000ff00000005400ULL,
0x0000004500707306ULL, 0x0003f0000000d400ULL, 0x0000004400b57306ULL, 0x000fe20000209400ULL,
0x0001000045457824ULL, 0x002fca00078e00ffULL, 0x00000018ff457819ULL, 0x000fe40000011445ULL,
0x0000004400b67306ULL, 0x000ff00000205400ULL, 0x0000004400757306ULL, 0x0003f0000020d400ULL,
0x0000008800c07306ULL, 0x000fe20000209400ULL, 0x0000010046447824ULL, 0x002fca00078e00ffULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x0000008800b37306ULL, 0x000e700000205400ULL,
0x0000004f004f7306ULL, 0x000eb0000020d400ULL, 0x0000008000807306ULL, 0x000ee2000020d400ULL,
0x000000b3c000720bULL, 0x002fce0003f9d000ULL, 0x0000005700af7306ULL, 0x000fe20000009400ULL,
0x000000014f4f6812ULL, 0x004fe400078efcffULL, 0x000000bd9700720bULL, 0x000fca0003fdd000ULL,
0x0000005700ae7306ULL, 0x000e620000005400ULL, 0x0000000180800812ULL, 0x008fce00078efcffULL,
0x0000005400847306ULL, 0x0004e2000000d400ULL, 0x0000000185856812ULL, 0x000fe400078efcffULL,
0x000000b8b700720bULL, 0x000fca0003fdd000ULL, 0x0000008600c27306ULL, 0x000fe20000209400ULL,
0x0001000054547824ULL, 0x004fe200078e00ffULL, 0x000000aeaf00720bULL, 0x002fc80003f1d000ULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x0000008600c37306ULL, 0x000e620000205400ULL,
0x0000000184845812ULL, 0x008fe400078efcffULL, 0x0000000176766812ULL, 0x000fe400078efcffULL,
0x000000844d84723eULL, 0x000fc600000010ffULL, 0x0000005500e47306ULL, 0x000ff00000209400ULL,
0x0000005500e37306ULL, 0x000ea20000205400ULL, 0x000000c3c200720bULL, 0x002fce0003f7d000ULL,
0x0000007300e57306ULL, 0x000ff00000209400ULL, 0x0000007300e67306ULL, 0x000fe20000205400ULL,
0x000000e3e400720bULL, 0x004fce0003fbd000ULL, 0x00000073007d7306ULL, 0x000ff0000020d400ULL,
0x0000004500b07306ULL, 0x000ff00000209400ULL, 0x0000004500b17306ULL, 0x000ff00000205400ULL,
0x0000004500737306ULL, 0x0003f0000020d400ULL, 0x0000004400ab7306ULL, 0x000fe20000209400ULL,
0x0000010047457824ULL, 0x002fca00078e00ffULL, 0x00000018ff457819ULL, 0x000fe40000011445ULL,
0x0000004400ac7306ULL, 0x000ff00000205400ULL, 0x0000004400747306ULL, 0x0003f0000020d400ULL,
0x0000005700597306ULL, 0x0004e2000000d400ULL, 0x000001003c447824ULL, 0x002fca00078e00ffULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x0000008800887306ULL, 0x000e62000020d400ULL,
0x0001000057577824ULL, 0x004fca00078e00ffULL, 0x00000018ff577819ULL, 0x000fe40000011457ULL,
0x0000004600a47306ULL, 0x000fe20000009400ULL, 0x0000000159590812ULL, 0x008fce00078efcffULL,
0x00000046009e7306ULL, 0x000fe20000005400ULL, 0x0000000188884812ULL, 0x002fc800078efcffULL,
0x0000008a8888723eULL, 0x000fc600000010ffULL, 0x0000004600667306ULL, 0x0003f0000000d400ULL,
0x00000047008e7306ULL, 0x000fe20000009400ULL, 0x0001000046467824ULL, 0x002fca00078e00ffULL,
0x00000018ff467819ULL, 0x000fe40000011446ULL, 0x00000047008d7306ULL, 0x000ff00000005400ULL,
0x0000004700627306ULL, 0x0003f0000000d400ULL, 0x0000004e00de7306ULL, 0x000fe20000209400ULL,
0x0001000047477824ULL, 0x002fca00078e00ffULL, 0x00000018ff477819ULL, 0x000fe40000011447ULL,
0x0000004e00dd7306ULL, 0x000e700000205400ULL, 0x0000005400e17306ULL, 0x000ff00000209400ULL,
0x0000005400e27306ULL, 0x000fe20000205400ULL, 0x000000ddde00720bULL, 0x002fce0003f9d000ULL,
0x00000054004c7306ULL, 0x000ff0000020d400ULL, 0x0000005500547306ULL, 0x000e70000020d400ULL,
0x0000007100a57306ULL, 0x000ff00000209400ULL, 0x0000007100a67306ULL, 0x000ea20000205400ULL,
0x0000000154545812ULL, 0x002fc400078efcffULL, 0x000000e6e500720bULL, 0x000fca0003fbd000ULL,
0x0000006e00e77306ULL, 0x000ff00000209400ULL, 0x0000006e00e87306ULL, 0x000fe20000205400ULL,
0x000000a6a500720bULL, 0x004fe20003f1d000ULL, 0x000001003ea57824ULL, 0x040fe200078e00ffULL,
0x000000017d7d5812ULL, 0x000fe200078efcffULL, 0x000100003ea67824ULL, 0x000fc600078e00ffULL,
0x00000018ffa57819ULL, 0x000fe200000114a5ULL, 0x0000006e00557306ULL, 0x000fe2000020d400ULL,
0x00000018ffa67819ULL, 0x000fce00000114a6ULL, 0x0000008600867306ULL, 0x000e70000020d400ULL,
0x0000004500917306ULL, 0x000ff00000209400ULL, 0x0000004500927306ULL, 0x000fe20000205400ULL,
0x0000000186863812ULL, 0x002fc400078efcffULL, 0x000000e2e100720bULL, 0x000fca0003f7d000ULL,
0x00000045006e7306ULL, 0x0003f0000020d400ULL, 0x0000004400b37306ULL, 0x000fe20000209400ULL,
0x000001003d457824ULL, 0x002fe200078e00ffULL, 0x000000014c4c3812ULL, 0x000fc400078efcffULL,
0x000000e8e700720bULL, 0x000fe40003f7d000ULL, 0x00000018ffbc7819ULL, 0x000fe40000011445ULL,
0x0000004400be7306ULL, 0x000ff00000205400ULL, 0x0000004400977306ULL, 0x0003e2000020d400ULL,
0x0000000155553812ULL, 0x000fc400078efcffULL, 0x000000a3a000720bULL, 0x000fe40003f7d000ULL,
0x000000765576723eULL, 0x000fc600000010ffULL, 0x0000005700e97306ULL, 0x000fe20000209400ULL,
0x0001280016447811ULL, 0x002fce00078e20ffULL, 0x0000005700ea7306ULL, 0x000e620000205400ULL,
0x000000016f6f3812ULL, 0x000fce00078efcffULL, 0x00000057007a7306ULL, 0x000eb0000020d400ULL,
0x0000005600b47306ULL, 0x000fe20000209400ULL, 0x000000eae900720bULL, 0x002fce0003fbd000ULL,
0x0000005600b27306ULL, 0x000e6c0000205400ULL, 0x000000017a7a5812ULL, 0x004fe400078efcffULL,
0x00000056007c7306ULL, 0x000ea2000020d400ULL, 0x0000009ea400720bULL, 0x000fce0003fbd000ULL,
0x0000004600567306ULL, 0x000fe20000209400ULL, 0x000000b2b400720bULL, 0x002fca0003f7d000ULL,
0x0000000166665812ULL, 0x000fe400078efcffULL, 0x0000004600577306ULL, 0x000e6c0000205400ULL,
0x000000017c7c3812ULL, 0x004fe400078efcffULL, 0x0000004600727306ULL, 0x000ea2000020d400ULL,
0x0000008d8e00720bULL, 0x000fce0003f7d000ULL, 0x0000004700a87306ULL, 0x000fe20000209400ULL,
0x000000575600720bULL, 0x002fe40003fbd000ULL, 0x0000004c8056723eULL, 0x000fc600000010ffULL,
0x0000000162623812ULL, 0x000fe400078efcffULL, 0x0000004700ad7306ULL, 0x000e6c0000205400ULL,
0x0000000172725812ULL, 0x004fe400078efcffULL, 0x00000047006d7306ULL, 0x0004f0000020d400ULL,
0x0000004e004e7306ULL, 0x000ee2000020d400ULL, 0x000000004444783bULL, 0x004ea20000000200ULL,
0x000000ada800720bULL, 0x002fcc0003f7d000ULL, 0x0000007900ba7306ULL, 0x000fee0000209400ULL,
0x000000016d6d3812ULL, 0x008fe200078efcffULL, 0x0000007900b97306ULL, 0x000e620000205400ULL,
0x000000014e4e4812ULL, 0x000fc800078efcffULL, 0x000000854e85723eULL, 0x000fc600000010ffULL,
0x0000007100717306ULL, 0x000ef0000020d400ULL, 0x0000005b00a77306ULL, 0x000fe20000209400ULL,
0x000000b9ba00720bULL, 0x002fce0003f9d000ULL, 0x0000005b009d7306ULL, 0x000e620000205400ULL,
0x0000000171710812ULL, 0x008fe200078efcffULL, 0x0000000f4444a231ULL, 0x084fe200003400ffULL,
0x000000b6b500720bULL, 0x000fe20003f1d000ULL, 0x0000000f4646a231ULL, 0x000fe400003400ffULL,
0x000000104545a231ULL, 0x080fe400003400ffULL, 0x0000007900797306ULL, 0x000ea2000020d400ULL,
0x000000104747a231ULL, 0x000fce00003400ffULL, 0x0000005b005b7306ULL, 0x000ee2000020d400ULL,
0x0000009da700720bULL, 0x002fe20003fdd000ULL, 0x000001003fa77824ULL, 0x000fe200078e00ffULL,
0x0000000175750812ULL, 0x000fe200078efcffULL, 0x000100003f9d7824ULL, 0x000fc600078e00ffULL,
0x00000018ffa77819ULL, 0x000fe200000114a7ULL, 0x0000006700967306ULL, 0x000fe20000209400ULL,
0x0000000179794812ULL, 0x004fe400078efcffULL, 0x000000e0df00720bULL, 0x000fe40003f9d000ULL,
0x000000547957723eULL, 0x000fe400000010ffULL, 0x00000018ff9d7819ULL, 0x000fe2000001149dULL,
0x0000006700957306ULL, 0x000e620000205400ULL, 0x000000015b5b6812ULL, 0x008fc400078efcffULL,
0x0000009ca100720bULL, 0x000fe20003fdd000ULL, 0x000000564454723cULL, 0x000be80000041820ULL,
0x0000003c00897306ULL, 0x000fe20000009400ULL, 0x0000000181814812ULL, 0x000fe400078efcffULL,
0x000000eceb00720bULL, 0x000fca0003f9d000ULL, 0x0000003c00877306ULL, 0x000fe20000005400ULL,
0x000000959600720bULL, 0x002fe40003f1d000ULL, 0x0000000170706812ULL, 0x000fe400078efcffULL,
0x000000acab00720bULL, 0x000fc60003fdd000ULL, 0x0000003c005c7306ULL, 0x0003e2000000d400ULL,
0x000000017b7b4812ULL, 0x000fce00078efcffULL, 0x0000006700677306ULL, 0x000ea2000020d400ULL,
0x000100003c3c7824ULL, 0x002fe200078e00ffULL, 0x0000000174746812ULL, 0x000fc800078efcffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000003d00777306ULL, 0x000fe20000009400ULL,
0x000000667420723eULL, 0x020fce00000010ffULL, 0x0000003d00787306ULL, 0x000e620000005400ULL,
0x0000000167670812ULL, 0x004fe400078efcffULL, 0x000000929100720bULL, 0x000fca0003f1d000ULL,
0x0000003d00527306ULL, 0x0004f0000000d400ULL, 0x0000003e00587306ULL, 0x000fe20000009400ULL,
0x000100003d3d7824ULL, 0x004fe200078e00ffULL, 0x000000016e6e0812ULL, 0x000fc400078efcffULL,
0x000000787700720bULL, 0x002fe40003fbd000ULL, 0x00000018ff9e7819ULL, 0x000fe4000001143dULL,
0x0000003e005a7306ULL, 0x000e620000005400ULL, 0x00000098933d723eULL, 0x000fe400000010ffULL,
0x000000597d77723eULL, 0x000fe400000010ffULL, 0x000000626e21723eULL, 0x000fc600000010ffULL,
0x0000003e00517306ULL, 0x000462000000d400ULL, 0x0000000152525812ULL, 0x008fce00078efcffULL,
0x0000003f00637306ULL, 0x000fe20000009400ULL, 0x0000009baa3e723eULL, 0x004fe400000010ffULL,
0x0000005a5800720bULL, 0x002fca0003f7d000ULL, 0x0000003f00647306ULL, 0x000ff00000005400ULL,
0x0000003f00417306ULL, 0x0003e2000000d400ULL, 0x0000000151513812ULL, 0x000fce00078efcffULL,
0x0000003c00a07306ULL, 0x000fe20000209400ULL, 0x00000099a93f723eULL, 0x002fce00000010ffULL,
0x0000003c00a37306ULL, 0x000fe20000205400ULL, 0x0000003e4428723cULL, 0x000bee0000041828ULL,
0x0000003c009c7306ULL, 0x0003e2000020d400ULL, 0x0000008c903e723eULL, 0x020fe400000010ffULL,
0x0000008b8f3f723eULL, 0x000fca00000010ffULL, 0x0000006a00a27306ULL, 0x000fe20000209400ULL,
0x0000009a943c723eULL, 0x002fe200000010ffULL, 0x0000003e4430723cULL, 0x040f6c0000041830ULL,
0x0000006a009f7306ULL, 0x000e640000205400ULL, 0x0000003c442c723cULL, 0x000b6c000004182cULL,
0x0000006500837306ULL, 0x000fe20000209400ULL, 0x00012800173c7811ULL, 0x020fcc00078e20ffULL,
0x000000003c3c783bULL, 0x000ea20000000200ULL, 0x0000006500827306ULL, 0x000ee20000205400ULL,
0x0000009fa200720bULL, 0x002fce0003f9d000ULL, 0x0000005d007f7306ULL, 0x000ff00000209400ULL,
0x0000005d007e7306ULL, 0x000e620000205400ULL, 0x000000828300720bULL, 0x008fce0003fdd000ULL,
0x0000006a006a7306ULL, 0x000ef0000020d400ULL, 0x0000006500657306ULL, 0x000ee2000020d400ULL,
0x0000007e7f00720bULL, 0x002fe20003f1d000ULL, 0x0000000f3c3ca231ULL, 0x004fcc00003400ffULL,
0x0000005d005d7306ULL, 0x000e62000020d400ULL, 0x000000016a6a4812ULL, 0x008fe200078efcffULL,
0x0000000f3e3ea231ULL, 0x000fe200003400ffULL, 0x000000b1b000720bULL, 0x000fe20003f9d000ULL,
0x000000103d3da231ULL, 0x080fe400003400ffULL, 0x000000103f3fa231ULL, 0x000fe400003400ffULL,
0x000000bc00bb7306ULL, 0x000fe20000209400ULL, 0x0000000165656812ULL, 0x000fe400078efcffULL,
0x000000beb300720bULL, 0x000fc40003fdd000ULL, 0x000000203c20723cULL, 0x000fe60000041830ULL,
0x000000bc00b77306ULL, 0x000ea20000205400ULL, 0x000000015d5d0812ULL, 0x002fe400078efcffULL,
0x0000000173734812ULL, 0x000fe400078efcffULL, 0x000000878900720bULL, 0x000fe40003f9d000ULL,
0x0000004f8689723eULL, 0x000fe200000010ffULL, 0x000000bc00ae7306ULL, 0x000e62000020d400ULL,
0x0000000197976812ULL, 0x000fe200078efcffULL, 0x00000084444c723cULL, 0x000be2000004181cULL,
0x000000a3a000720bULL, 0x000fca0003fdd000ULL, 0x0000009e009f7306ULL, 0x000fe20000209400ULL,
0x000000b7bb00720bULL, 0x004fe20003f1d000ULL, 0x000000884418723cULL, 0x040f640000041818ULL,
0x000000815b1c723eULL, 0x020fe400000010ffULL, 0x0000007a711d723eULL, 0x000fe400000010ffULL,
0x0000006f7b1e723eULL, 0x000fe200000010ffULL, 0x0000009e00997306ULL, 0x000ea20000205400ULL,
0x000000015c5c4812ULL, 0x000fe200078efcffULL, 0x000000764458723cULL, 0x000b620000041824ULL,
0x000000019c9c6812ULL, 0x000fc400078efcffULL, 0x000000707c1f723eULL, 0x000fe400000010ffULL,
0x00000001aeae0812ULL, 0x002fe200078efcffULL, 0x00000053006b7306ULL, 0x000fe20000209400ULL,
0x000000756a24723eULL, 0x020fe200000010ffULL, 0x0000001c4434723cULL, 0x000b620000041834ULL,
0x000000736725723eULL, 0x000fe400000010ffULL, 0x0000005c975c723eULL, 0x000fc600000010ffULL,
0x00000053006c7306ULL, 0x000e620000205400ULL, 0x000000999f00720bULL, 0x004fe20003f1d000ULL,
0x000000243c24723cULL, 0x040b64000004182cULL, 0x00000072651c723eULL, 0x020fe400000010ffULL,
0x0000006d5d1d723eULL, 0x000fe400000010ffULL, 0x00000052ae5d723eULL, 0x000fe200000010ffULL,
0x0000009e00937306ULL, 0x000ea2000020d400ULL, 0x0000001e3c28723cULL, 0x040b6e0000041828ULL,
0x0000004900687306ULL, 0x000fe20000209400ULL, 0x0000006c6b00720bULL, 0x002fe20003f9d000ULL,
0x0000001c3c1c723cULL, 0x040b6c0000041818ULL, 0x0000004900697306ULL, 0x000e620000205400ULL,
0x0000000193930812ULL, 0x004fe200078efcffULL, 0x0000005c3c18723cULL, 0x000b6c000004184cULL,
0x000000a5008b7306ULL, 0x000ff00000209400ULL, 0x000000a500867306ULL, 0x000ea20000205400ULL,
0x000000696800720bULL, 0x002fce0003fbd000ULL, 0x000000a7007e7306ULL, 0x000ff00000209400ULL,
0x000000a700787306ULL, 0x000e620000205400ULL, 0x000000868b00720bULL, 0x004fce0003fdd000ULL,
0x0000005300537306ULL, 0x000eb0000020d400ULL, 0x0000004900497306ULL, 0x000ee2000020d400ULL,
0x000000787e00720bULL, 0x002fce0003f1d000ULL, 0x000000a500a57306ULL, 0x000e62000020d400ULL,
0x0000000153534812ULL, 0x004fe400078efcffULL, 0x000000646300720bULL, 0x000fca0003f9d000ULL,
0x000000a700a77306ULL, 0x000ea2000020d400ULL, 0x0000000149495812ULL, 0x008fc800078efcffULL,
0x00000093492d723eULL, 0x000fc600000010ffULL, 0x00000042005e7306ULL, 0x000fe20000209400ULL,
0x00000001a5a56812ULL, 0x002fe400078efcffULL, 0x0000000141414812ULL, 0x000fe400078efcffULL,
0x00000051a530723eULL, 0x000fc600000010ffULL, 0x00000042005f7306ULL, 0x000e620000205400ULL,
0x00000001a7a70812ULL, 0x004fc800078efcffULL, 0x00000041a731723eULL, 0x000fc600000010ffULL,
0x0000003800607306ULL, 0x000fe80000209400ULL, 0x000000303c30723cULL, 0x000b680000041858ULL,
0x0000003800617306ULL, 0x000ea20000205400ULL, 0x0000005f5e00720bULL, 0x002fce0003fbd000ULL,
0x000000a6006f7306ULL, 0x000ff00000209400ULL, 0x000000a600447306ULL, 0x000e620000205400ULL,
0x000000616000720bULL, 0x004fce0003fdd000ULL, 0x0000009d00457306ULL, 0x000ff00000209400ULL,
0x0000009d002c7306ULL, 0x000ea20000205400ULL, 0x000000446f00720bULL, 0x002fce0003f7d000ULL,
0x0000004200427306ULL, 0x000e70000020d400ULL, 0x0000003800387306ULL, 0x000ee2000020d400ULL,
0x0000002c4500720bULL, 0x004fe40003f1d000ULL, 0x0000009c532c723eULL, 0x000fca00000010ffULL,
0x000000a600a67306ULL, 0x000ea2000020d400ULL, 0x0000000142425812ULL, 0x002fe200078efcffULL,
0x0000002c3c2c723cULL, 0x000b6c0000041854ULL, 0x0000009d009d7306ULL, 0x000e62000020d400ULL,
0x0000000138386812ULL, 0x008fe400078efcffULL, 0x00000001a6a63812ULL, 0x004fc800078efcffULL,
0x000000a642a6723eULL, 0x000fe400000010ffULL, 0x000000019d9d0812ULL, 0x002fc800078efcffULL,
0x0000009d38a7723eULL, 0x000fce00000010ffULL, 0x000000a63c3c723cULL, 0x000b620000041834ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0186b800ff447f8cULL, 0x000e62000c80043fULL,
0x000000ffff417224ULL, 0x000fce00078e00ffULL, 0x0000000000347805ULL, 0x020fc40000015200ULL,
0x0186bc00ff367984ULL, 0x000ea40000000800ULL, 0x8000000036ff7812ULL, 0x006fe40007804845ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104100780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fcc0000015200ULL,
0x0000003634387210ULL, 0x000fca0007f1e1ffULL, 0x0000000137377824ULL, 0x000fe200000e0e35ULL,
0x003d09003800780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403800780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff367819ULL, 0x000fc80000011437ULL, 0x0000003836367211ULL, 0x000fca00078110ffULL,
0x000000ffff377224ULL, 0x000fca00000e0637ULL, 0x0000000236367819ULL, 0x000fc80000001237ULL,
0x000000360000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000141417810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0186bc00ff367984ULL, 0x000e640000000800ULL, 0x8000000036ff7812ULL, 0x002fe40007804845ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000580008427a24ULL, 0x010fc800078e02ffULL,
0x0000004042427824ULL, 0x000fe200078e00ffULL, 0x0000045000009947ULL, 0x000fea0003800000ULL,
0x00000002114d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000107347824ULL, 0x000fe200078e0211ULL,
0x00000004114f7810ULL, 0x000fe20007ffe0ffULL, 0x0000008004057891ULL, 0x000fe2000f8e403fULL,
0x000000f00c497812ULL, 0x000fe200078ec0ffULL, 0x0000000107367824ULL, 0x000fe400078e024dULL,
0x0000000134357824ULL, 0x040fe400078e0202ULL, 0x00000010344c7824ULL, 0x000fc400078e00ffULL,
0x0000004003477824ULL, 0x000fe400078e0234ULL, 0x0000000107347824ULL, 0x000fe200078e024fULL,
0xfffffff04c4c7812ULL, 0x000fe200078ee235ULL, 0x0000000136377824ULL, 0x140fe200078e0202ULL,
0x0000004247447210ULL, 0x040fe20007f1e0ffULL, 0x00000010364e7824ULL, 0x000fe200078e00ffULL,
0x0000000247467810ULL, 0x040fe20007ffe0ffULL, 0x0000000134367824ULL, 0x040fe200078e0202ULL,
0x0000000447457810ULL, 0x000fe20007ffe0ffULL, 0x0000001034517824ULL, 0x000fe200078e00ffULL,
0x0000000504347c17ULL, 0x000fe2000f800000ULL, 0x000000ffff357224ULL, 0x000fe200000e06ffULL,
0x00005e0044387a11ULL, 0x000fc400078040ffULL, 0x8000000534347c10ULL, 0x000fe4000fffe0ffULL,
0x00005f0044447a11ULL, 0x000fe400000f4435ULL, 0x0000003407347217ULL, 0x000fe40007800000ULL,
0x0000004246467210ULL, 0x080fe40007f1e0ffULL, 0xfffffff04e4e7812ULL, 0x000fe200078ee237ULL,
0x0000000134377824ULL, 0x000fe200078e0a07ULL, 0x0000004245457210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff347224ULL, 0x000fe200000e06ffULL, 0x00005e0046417a11ULL, 0x000fc400078040ffULL,
0x000000371100720cULL, 0x000fe20003f86070ULL, 0x000000ffff357224ULL, 0x000fe200018e06ffULL,
0xfffffff051517812ULL, 0x000fe400078ee236ULL, 0x00005f0046467a11ULL, 0x000fe400000f4434ULL,
0x00005e0045367a11ULL, 0x040fe400078a40ffULL, 0x0000004938347210ULL, 0x000fe40007f7e0ffULL,
0x00005f0045457a11ULL, 0x000fc400028f4435ULL, 0x000140004c4c7811ULL, 0x000fe200078e20ffULL,
0x000000ffff357224ULL, 0x000fe200018e0644ULL, 0x000000374d00720cULL, 0x080fe40003f06070ULL,
0x00000006114d7810ULL, 0x000fe40007ffe0ffULL, 0x0000000647387810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000344c7faeULL, 0x0003e2000e101c46ULL,
0x000000374f00720cULL, 0x000fe20003f66070ULL, 0x0000000107447824ULL, 0x000fe200078e024dULL,
0x0000004238387210ULL, 0x000fc40007f9e0ffULL, 0x0000004936367210ULL, 0x080fe20007fde0ffULL,
0x0000000144477824ULL, 0x000fe200078e0202ULL, 0x000140004e4e7811ULL, 0x000fe400078e20ffULL,
0x0001400051517811ULL, 0x000fe400078e20ffULL, 0x0000004941347210ULL, 0x002fe20007fbe0ffULL,
0x00000010444c7824ULL, 0x000fe400078e00ffULL, 0x000000ffff417224ULL, 0x000fe200020e06ffULL,
0x00005e0038447a11ULL, 0x040fe200078840ffULL, 0x000000ffff357224ULL, 0x000fe200028e0646ULL,
0x000000374d00720cULL, 0x000fe20003fa6070ULL, 0x000000ffff377224ULL, 0x000fe200030e0645ULL,
0x00005f0038387a11ULL, 0x000fc400020f4441ULL, 0x0000004944447210ULL, 0x000fe20007f9e0ffULL,
0x00000000344e7faeULL, 0x0003e2000c101c46ULL, 0xfffffff04c477812ULL, 0x000fc600078ee247ULL,
0x000000ffff457224ULL, 0x000fe200020e0638ULL, 0x0001400047477811ULL, 0x000fe200078e20ffULL,
0x0000000036517faeULL, 0x0003e8000d901c46ULL, 0x0000000044477faeULL, 0x0003e2000e901c46ULL,
0x0000038000007947ULL, 0x000fea0003800000ULL, 0x0000000107347824ULL, 0x000fe200078e0211ULL,
0x000000f00c467812ULL, 0x000fc600078ec0ffULL, 0x0000000134357824ULL, 0x040fe200078e0202ULL,
0x0000000234367810ULL, 0x040fe20007ffe0ffULL, 0x0000001034387824ULL, 0x000fc800078e00ffULL,
0x0000000136377824ULL, 0x000fe200078e0202ULL, 0xfffffff038387812ULL, 0x000fe200078ee235ULL,
0x0000001036457824ULL, 0x000fe200078e00ffULL, 0x0000000434367810ULL, 0x000fe20007ffe0ffULL,
0x0000004003357824ULL, 0x000fe200078e0234ULL, 0x0001400038387811ULL, 0x000fe400078e20ffULL,
0xfffffff045457812ULL, 0x000fe200078ee237ULL, 0x0000000136417824ULL, 0x000fe200078e0202ULL,
0x0000000634377810ULL, 0x000fe20007ffe0ffULL, 0x00000010364d7824ULL, 0x000fe200078e00ffULL,
0x0000004235347210ULL, 0x000fc60007f1e0ffULL, 0x0000000137447824ULL, 0x000fe200078e0202ULL,
0xfffffff04d4d7812ULL, 0x000fe200078ee241ULL, 0x0000001037527824ULL, 0x000fe200078e00ffULL,
0x0000000235417810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff367224ULL, 0x000fe200000e06ffULL,
0x00005e0034377a11ULL, 0x000fe400078040ffULL, 0xfffffff052527812ULL, 0x000fe400078ee244ULL,
0x00005f0034367a11ULL, 0x000fe400000f4436ULL, 0x0000000435347810ULL, 0x000fc40007ffe0ffULL,
0x0000000635357810ULL, 0x000fe40007ffe0ffULL, 0x0000004241417210ULL, 0x080fe40007f1e0ffULL,
0x0000004234477210ULL, 0x080fe40007f7e0ffULL, 0x00000042354e7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff357224ULL, 0x000fe200000e06ffULL, 0x00005e0041447a11ULL, 0x000fe200078040ffULL,
0x000000ffff497224ULL, 0x000fe200018e06ffULL, 0x0000004637347210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff4f7224ULL, 0x000fe200028e06ffULL, 0x00005e00474c7a11ULL, 0x000fc400078840ffULL,
0x00005e004e517a11ULL, 0x000fe400078a40ffULL, 0x00005f0041417a11ULL, 0x000fe200000f4435ULL,
0x000000ffff357224ULL, 0x000fe200018e0636ULL, 0x0000004644367210ULL, 0x080fe40007f1e0ffULL,
0x00005f0047497a11ULL, 0x000fe400020f4449ULL, 0x000000464c447210ULL, 0x080fe20007f7e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034387faeULL, 0x0003e2000b901c46ULL,
0x00005f004e4f7a11ULL, 0x000fe200028f444fULL, 0x000000ffff377224ULL, 0x000fe200000e0641ULL,
0x0000004651467210ULL, 0x000fc40007f9e0ffULL, 0x000140004d4d7811ULL, 0x000fe400078e20ffULL,
0x0001400052527811ULL, 0x000fe200078e20ffULL, 0x000000ffff477224ULL, 0x000fe200020e064fULL,
0x0001400045347811ULL, 0x002fe200078e20ffULL, 0x000000ffff457224ULL, 0x000fc800018e0649ULL,
0x0000000036347faeULL, 0x0003e8000b901c46ULL, 0x00000000444d7faeULL, 0x0003e8000b901c46ULL,
0x0000000046527faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0186a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0186a800ff347f8cULL, 0x000e64000c80043fULL,
0x000000ffff387224ULL, 0x002fc400078e0035ULL, 0x0000000000347805ULL, 0x000fca0000015200ULL,
0x0186b400ff367984ULL, 0x000e640000000800ULL, 0x8000000036ff7812ULL, 0x002fc4000780484bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff447224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fcc0000015200ULL, 0x0000003634417210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09004100780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404100780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000004136367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000144447810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0186b400ff367984ULL, 0x000e640000000800ULL,
0x8000000036ff7812ULL, 0x002fe4000780484bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000016000007945ULL, 0x000fe20003800000ULL, 0x0000014000002947ULL, 0x000fea0003800000ULL,
0x0000000eff0f723eULL, 0x000fe400000010ffULL, 0x00000002ff347819ULL, 0x000fe40000011602ULL,
0x000054100f497816ULL, 0x000fe2000000000fULL, 0x000170227f007947ULL, 0x000fea000b800000ULL,
0x00001f34490f7589ULL, 0x0002a400000e0000ULL, 0x0000000834107810ULL, 0x000fe20007ffe0ffULL,
0x000170627f007947ULL, 0x000fea000b800000ULL, 0x00001f1049107589ULL, 0x00066400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x0000001034477810ULL, 0x000fe20007ffe0ffULL,
0x0000001fff457424ULL, 0x000fe200078e00ffULL, 0x0000b86000447802ULL, 0x000fe20000000f00ULL,
0xffffffffff467424ULL, 0x000fc400078e00ffULL, 0x00017d3000007944ULL, 0x00efea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x0000001834477810ULL, 0x000fe20007ffe0ffULL,
0x0000001fff457424ULL, 0x000fe200078e00ffULL, 0x0000b8c000447802ULL, 0x000fe20000000f00ULL,
0xffffffffff467424ULL, 0x004fc400078e00ffULL, 0x00017cd000007944ULL, 0x00afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000003b44783bULL, 0x004ea20000004200ULL, 0x0000008004057891ULL, 0x000fc6000f8e403fULL,
0x000000004054783bULL, 0x000f280000004200ULL, 0x000000003934783bULL, 0x002e680000004200ULL,
0x000000003a4c783bULL, 0x000ee20000004200ULL, 0x00000100446f7824ULL, 0x004fe200078e00ffULL,
0x0000004400d07306ULL, 0x000fe20000009400ULL, 0x00000018ff4a7819ULL, 0x000fe20000011444ULL,
0x0000010047757824ULL, 0x000fe200078e00ffULL, 0x00000018ff8a7819ULL, 0x000fc40000011447ULL,
0x00000018ff6f7819ULL, 0x000fe4000001146fULL, 0x00000018ff4b7819ULL, 0x000fe20000011445ULL,
0x0000004400747306ULL, 0x000ea20000005400ULL, 0x00000018ff8d7819ULL, 0x000fe40000011446ULL,
0x00000018ff757819ULL, 0x000fe40000011475ULL, 0x00000018ff5b7819ULL, 0x010fe40000011456ULL,
0x00000018ff807819ULL, 0x000fe20000011454ULL, 0x0000006f00d27306ULL, 0x000fe20000209400ULL,
0x00000018ff7a7819ULL, 0x000fc40000011455ULL, 0x00000018ff6b7819ULL, 0x002fe40000011434ULL,
0x00000018ff677819ULL, 0x000fe40000011435ULL, 0x00000018ff737819ULL, 0x000fe20000011457ULL,
0x0000006f00d17306ULL, 0x000e620000205400ULL, 0x00000074d000720bULL, 0x004fe40003f1d000ULL,
0x00000018ff657819ULL, 0x000fe40000011436ULL, 0x00000018ff5f7819ULL, 0x000fc40000011437ULL,
0x00000018ff5d7819ULL, 0x008fe2000001144cULL, 0x0000006f00ab7306ULL, 0x0004e2000020d400ULL,
0x00000018ff537819ULL, 0x000fe4000001144dULL, 0x00000018ff517819ULL, 0x000fe4000001144eULL,
0x00000018ff417819ULL, 0x000fc6000001144fULL, 0x0000004400a27306ULL, 0x0008e2000000d400ULL,
0x00000100456f7824ULL, 0x004fe200078e00ffULL, 0x000000d1d200720bULL, 0x002fc80003fdd000ULL,
0x00000018ff6f7819ULL, 0x000fe4000001146fULL, 0x0000004600ca7306ULL, 0x000fe20000009400ULL,
0x0001000044447824ULL, 0x010fca00078e00ffULL, 0x00000018ffa17819ULL, 0x000fe40000011444ULL,
0x0000006f00d57306ULL, 0x000fe20000209400ULL, 0x00000001abab6812ULL, 0x008fe400078efcffULL,
0x00000001a2a20812ULL, 0x000fca00078efcffULL, 0x0000006f00d47306ULL, 0x000e700000205400ULL,
0x0000006f00aa7306ULL, 0x0004f0000020d400ULL, 0x00000046006e7306ULL, 0x000f220000005400ULL,
0x000000d4d500720bULL, 0x002fe20003f7d000ULL, 0x00000100466f7824ULL, 0x004fca00078e00ffULL,
0x00000018ff6f7819ULL, 0x000fe2000001146fULL, 0x0000004a00cd7306ULL, 0x000fec0000209400ULL,
0x00000001aaaa3812ULL, 0x008fe400078efcffULL, 0x0000004a00977306ULL, 0x000e620000205400ULL,
0x0000006eca00720bULL, 0x010fce0003f7d000ULL, 0x000000a100d37306ULL, 0x000ff00000209400ULL,
0x000000a100447306ULL, 0x000ea20000205400ULL, 0x00000097cd00720bULL, 0x002fce0003f9d000ULL,
0x0000004700c97306ULL, 0x000ff00000009400ULL, 0x0000004700b67306ULL, 0x000fe20000005400ULL,
0x00000044d300720bULL, 0x004fe40003fbd000ULL, 0x0001280043447811ULL, 0x000fca00078e20ffULL,
0x0000004700917306ULL, 0x0003f0000000d400ULL, 0x0000004500cf7306ULL, 0x000fe20000009400ULL,
0x0001000047477824ULL, 0x002fca00078e00ffULL, 0x00000018ff8c7819ULL, 0x000fe40000011447ULL,
0x0000004500ce7306ULL, 0x000e700000005400ULL, 0x0000004500a07306ULL, 0x0005f0000000d400ULL,
0x0000004600927306ULL, 0x000722000000d400ULL, 0x0001000045457824ULL, 0x004fe200078e00ffULL,
0x000000cecf00720bULL, 0x002fc80003fdd000ULL, 0x00000018ff9f7819ULL, 0x000fe40000011445ULL,
0x0000004a004a7306ULL, 0x000e62000020d400ULL, 0x0001000046467824ULL, 0x008fca00078e00ffULL,
0x00000018ff8e7819ULL, 0x000fe40000011446ULL, 0x000000a100a17306ULL, 0x000ea2000020d400ULL,
0x0000000192923812ULL, 0x010fe400078efcffULL, 0x00000001a0a06812ULL, 0x000fca00078efcffULL,
0x0000004b00cc7306ULL, 0x000fe20000209400ULL, 0x000000014a4a4812ULL, 0x002fce00078efcffULL,
0x0000004b00a97306ULL, 0x000e620000205400ULL, 0x00000001a1a15812ULL, 0x004fc800078efcffULL,
0x000000a14a4a723eULL, 0x000fc600000010ffULL, 0x0000006f00d87306ULL, 0x000ff00000209400ULL,
0x0000006f00d77306ULL, 0x000ea20000205400ULL, 0x000000a9cc00720bULL, 0x002fce0003fbd000ULL,
0x0000008c00477306ULL, 0x000ff00000209400ULL, 0x0000008c00dc7306ULL, 0x000e620000205400ULL,
0x000000d7d800720bULL, 0x004fce0003f9d000ULL, 0x0000006f00967306ULL, 0x0004f0000020d400ULL,
0x0000009f00457306ULL, 0x000fe20000209400ULL, 0x00000100546f7824ULL, 0x004fe200078e00ffULL,
0x000000dc4700720bULL, 0x002fc80003f7d000ULL, 0x00000018ff6f7819ULL, 0x000fe4000001146fULL,
0x0000009f00d67306ULL, 0x000e620000205400ULL, 0x0000000196964812ULL, 0x008fce00078efcffULL,
0x0000007500da7306ULL, 0x000ff00000209400ULL, 0x0000007500d97306ULL, 0x000ea20000205400ULL,
0x000000d64500720bULL, 0x002fce0003f1d000ULL, 0x0000004b004b7306ULL, 0x000e70000020d400ULL,
0x0000008c008c7306ULL, 0x000ee2000020d400ULL, 0x000000d9da00720bULL, 0x004fce0003fdd000ULL,
0x0000005500c47306ULL, 0x000fe20000009400ULL, 0x000000014b4b5812ULL, 0x002fce00078efcffULL,
0x0000005500c67306ULL, 0x000e620000005400ULL, 0x000000018c8c3812ULL, 0x008fce00078efcffULL,
0x0000008d00c87306ULL, 0x000ff00000209400ULL, 0x0000008d00cb7306ULL, 0x000ea20000205400ULL,
0x000000c6c400720bULL, 0x002fce0003f7d000ULL, 0x0000008e00db7306ULL, 0x000ff00000209400ULL,
0x0000008e00467306ULL, 0x000e620000205400ULL, 0x000000cbc800720bULL, 0x004fce0003f9d000ULL,
0x0000006f00dd7306ULL, 0x000ff00000209400ULL, 0x0000006f00de7306ULL, 0x000fe20000205400ULL,
0x00000046db00720bULL, 0x002fe40003fbd000ULL, 0x000000004444783bULL, 0x000e6a0000000200ULL,
0x0000006f008b7306ULL, 0x0005f0000020d400ULL, 0x0000005600bc7306ULL, 0x000fe20000009400ULL,
0x00000100566f7824ULL, 0x004fca00078e00ffULL, 0x00000018ff6f7819ULL, 0x000fe4000001146fULL,
0x0000005600b77306ULL, 0x000ff00000005400ULL, 0x0000005600797306ULL, 0x0005f0000000d400ULL,
0x0000007500957306ULL, 0x000722000020d400ULL, 0x0001000056567824ULL, 0x004fe200078e00ffULL,
0x0000000f4444a231ULL, 0x002fc400003400ffULL, 0x0000000f4646a231ULL, 0x000fe400003400ffULL,
0x00000018ff567819ULL, 0x000fe20000011456ULL, 0x000000104545a231ULL, 0x080fe200003400ffULL,
0x0000009f009f7306ULL, 0x000e62000020d400ULL, 0x0000010055757824ULL, 0x008fe200078e00ffULL,
0x000000104747a231ULL, 0x000fc800003400ffULL, 0x00000018ff757819ULL, 0x000fe40000011475ULL,
0x0000008a00c77306ULL, 0x000fe20000209400ULL, 0x0000000195956812ULL, 0x010fce00078efcffULL,
0x0000008a00bd7306ULL, 0x000ea20000205400ULL, 0x000000019f9f0812ULL, 0x002fe400078efcffULL,
0x000000b6c900720bULL, 0x000fe40003f1d000ULL, 0x0000009f4b4b723eULL, 0x000fc600000010ffULL,
0x0000005600e37306ULL, 0x000fe80000209400ULL, 0x0000004a4424723cULL, 0x000b680000041824ULL,
0x0000005600e47306ULL, 0x000fe20000205400ULL, 0x000000bdc700720bULL, 0x004fe40003fdd000ULL,
0x0000000191910812ULL, 0x000fc400078efcffULL, 0x000000dedd00720bULL, 0x000fc60003f1d000ULL,
0x0000005600837306ULL, 0x0003f0000020d400ULL, 0x0000005400c57306ULL, 0x000fe20000009400ULL,
0x0000010034567824ULL, 0x002fe200078e00ffULL, 0x000000018b8b0812ULL, 0x000fc800078efcffULL,
0x00000018ff567819ULL, 0x000fe40000011456ULL, 0x00000054009e7306ULL, 0x000ff00000005400ULL,
0x0000005400877306ULL, 0x0003f0000000d400ULL, 0x0000005500847306ULL, 0x0004e2000000d400ULL,
0x0001000054547824ULL, 0x002fca00078e00ffULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x0000008d008d7306ULL, 0x000e62000020d400ULL, 0x0001000055557824ULL, 0x004fca00078e00ffULL,
0x00000018ff557819ULL, 0x000fe40000011455ULL, 0x0000008e008e7306ULL, 0x000ea2000020d400ULL,
0x0000000184843812ULL, 0x008fce00078efcffULL, 0x0000007500df7306ULL, 0x000fe20000209400ULL,
0x000000018d8d4812ULL, 0x002fce00078efcffULL, 0x0000007500e07306ULL, 0x000e620000205400ULL,
0x000000018e8e5812ULL, 0x004fe400078efcffULL, 0x0000009ec500720bULL, 0x000fe40003fbd000ULL,
0x0000008e8d4a723eULL, 0x020fc600000010ffULL, 0x0000006f00e97306ULL, 0x000ff00000209400ULL,
0x0000006f00ea7306ULL, 0x000ea20000205400ULL, 0x000000e0df00720bULL, 0x002fe40003f9d000ULL,
0x0000000187875812ULL, 0x000fca00078efcffULL, 0x0000003400b57306ULL, 0x000ff00000009400ULL,
0x0000003400af7306ULL, 0x000fe20000005400ULL, 0x000000eae900720bULL, 0x004fce0003f7d000ULL,
0x0000003400707306ULL, 0x0003f0000000d400ULL, 0x0000007500887306ULL, 0x0004e2000020d400ULL,
0x0001000034347824ULL, 0x002fca00078e00ffULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000008a008a7306ULL, 0x000e62000020d400ULL, 0x0000010057757824ULL, 0x004fca00078e00ffULL,
0x00000018ff757819ULL, 0x000fe40000011475ULL, 0x0000005600bf7306ULL, 0x000fe20000209400ULL,
0x0000000188884812ULL, 0x008fce00078efcffULL, 0x0000005600be7306ULL, 0x000fe20000205400ULL,
0x000000018a8a6812ULL, 0x002fc800078efcffULL, 0x0000008c8a4b723eULL, 0x000fc600000010ffULL,
0x00000056007e7306ULL, 0x0003e8000020d400ULL, 0x0000004a441c723cULL, 0x000fe8000004181cULL,
0x0000003500a57306ULL, 0x000fe20000009400ULL, 0x0000010035567824ULL, 0x002fca00078e00ffULL,
0x00000018ff567819ULL, 0x000fe40000011456ULL, 0x0000003500a67306ULL, 0x000ff00000005400ULL,
0x00000035006a7306ULL, 0x0003f0000000d400ULL, 0x0000005400e27306ULL, 0x000fe20000209400ULL,
0x0001000035357824ULL, 0x002fca00078e00ffULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x0000005400e17306ULL, 0x000e700000205400ULL, 0x0000005400897306ULL, 0x000eb0000020d400ULL,
0x0000005500e67306ULL, 0x000fe20000209400ULL, 0x000000e1e200720bULL, 0x002fce0003fdd000ULL,
0x0000005500e57306ULL, 0x000e6c0000205400ULL, 0x0000000189896812ULL, 0x004fe400078efcffULL,
0x0000005500547306ULL, 0x000ea2000020d400ULL, 0x000000b7bc00720bULL, 0x000fce0003fdd000ULL,
0x0000006f00557306ULL, 0x000ee2000020d400ULL, 0x000000e5e600720bULL, 0x002fca0003fbd000ULL,
0x0000000179796812ULL, 0x000fe400078efcffULL, 0x0000003400ba7306ULL, 0x000fec0000209400ULL,
0x0000000154545812ULL, 0x004fe400078efcffULL, 0x0000003400bb7306ULL, 0x000fe20000205400ULL,
0x0000000155553812ULL, 0x008fc400078efcffULL, 0x000000afb500720bULL, 0x000fca0003f7d000ULL,
0x0000003400777306ULL, 0x0003f0000020d400ULL, 0x0000007a00c07306ULL, 0x000fe20000209400ULL,
0x0000010036347824ULL, 0x002fe200078e00ffULL, 0x0000000170703812ULL, 0x000fc800078efcffULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000007a00c17306ULL, 0x000e700000205400ULL,
0x0000007500e77306ULL, 0x000ff00000209400ULL, 0x0000007500e87306ULL, 0x000fe20000205400ULL,
0x000000c1c000720bULL, 0x002fce0003f9d000ULL, 0x00000075007f7306ULL, 0x000ff0000020d400ULL,
0x0000003500ac7306ULL, 0x000ff00000209400ULL, 0x0000003500ad7306ULL, 0x000ff00000205400ULL,
0x0000003500757306ULL, 0x0003f0000020d400ULL, 0x0000008000c27306ULL, 0x000fe20000209400ULL,
0x0000010037357824ULL, 0x002fca00078e00ffULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x0000008000c37306ULL, 0x000e700000205400ULL, 0x0000003400997306ULL, 0x000ff00000209400ULL,
0x0000003400987306ULL, 0x000fe20000205400ULL, 0x000000c3c200720bULL, 0x002fce0003f1d000ULL,
0x0000003400767306ULL, 0x0003f0000020d400ULL, 0x0000005700b17306ULL, 0x000fe20000009400ULL,
0x000001004c347824ULL, 0x002fca00078e00ffULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000005700ae7306ULL, 0x000e700000005400ULL, 0x0000005700587306ULL, 0x0004f0000000d400ULL,
0x0000007a007a7306ULL, 0x000f22000020d400ULL, 0x0001000057577824ULL, 0x004fe200078e00ffULL,
0x000000aeb100720bULL, 0x002fe20003fbd000ULL, 0x000100004fb17824ULL, 0x000fc600078e00ffULL,
0x00000018ff577819ULL, 0x000fe40000011457ULL, 0x0000003600a87306ULL, 0x000fe20000009400ULL,
0x00000018ffb17819ULL, 0x000fcc00000114b1ULL, 0x0000000158585812ULL, 0x008fe200078efcffULL,
0x0000003600a37306ULL, 0x000e620000005400ULL, 0x000000017a7a4812ULL, 0x010fe400078efcffULL,
0x000000e4e300720bULL, 0x000fca0003f9d000ULL, 0x0000003600667306ULL, 0x0004f0000000d400ULL,
0x00000037009b7306ULL, 0x000fe20000009400ULL, 0x0001000036367824ULL, 0x004fe200078e00ffULL,
0x0000000183834812ULL, 0x000fc400078efcffULL, 0x000000bebf00720bULL, 0x000fe40003f9d000ULL,
0x00000018ff367819ULL, 0x000fe40000011436ULL, 0x00000037009a7306ULL, 0x000ff00000005400ULL,
0x0000003700647306ULL, 0x0005e2000000d400ULL, 0x000000017e7e4812ULL, 0x000fc400078efcffULL,
0x000000a3a800720bULL, 0x002fe40003f9d000ULL, 0x000000707e70723eULL, 0x000fc600000010ffULL,
0x0000005600b87306ULL, 0x000fe20000209400ULL, 0x0001000037377824ULL, 0x004fca00078e00ffULL,
0x00000018ff377819ULL, 0x000fe40000011437ULL, 0x0000005600b97306ULL, 0x000e620000205400ULL,
0x0000000166664812ULL, 0x008fce00078efcffULL, 0x00000035008f7306ULL, 0x000ff00000209400ULL,
0x0000003500907306ULL, 0x000fe20000205400ULL, 0x000000b9b800720bULL, 0x002fce0003f7d000ULL,
0x00000035006f7306ULL, 0x0003f0000020d400ULL, 0x0000003400b67306ULL, 0x000fe20000209400ULL,
0x000001004d357824ULL, 0x002fca00078e00ffULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x0000003400bd7306ULL, 0x000ff00000205400ULL, 0x00000034009e7306ULL, 0x0003f0000020d400ULL,
0x0000005700eb7306ULL, 0x000fe20000209400ULL, 0x0001280050347811ULL, 0x002fce00078e20ffULL,
0x0000005700ec7306ULL, 0x000e700000205400ULL, 0x00000057007d7306ULL, 0x000eb0000020d400ULL,
0x0000005600787306ULL, 0x000ee2000020d400ULL, 0x000000eceb00720bULL, 0x002fce0003fbd000ULL,
0x0000003600567306ULL, 0x000fec0000209400ULL, 0x000000017d7d5812ULL, 0x004fe400078efcffULL,
0x0000003600577306ULL, 0x000fe20000205400ULL, 0x0000000178783812ULL, 0x008fce00078efcffULL,
0x0000003600747306ULL, 0x000ff0000020d400ULL, 0x0000003700977306ULL, 0x000ff00000209400ULL,
0x0000003700a97306ULL, 0x000ff00000205400ULL, 0x00000037006e7306ULL, 0x000ff0000020d400ULL,
0x0000003500c27306ULL, 0x000ff00000209400ULL, 0x0000003500c07306ULL, 0x000ff00000205400ULL,
0x0000003500b77306ULL, 0x0003f0000020d400ULL, 0x0000008000807306ULL, 0x000ea2000020d400ULL,
0x000000003434783bULL, 0x002e6e0000000200ULL, 0x0000005b00b47306ULL, 0x000ff00000209400ULL,
0x0000005b00b07306ULL, 0x000ee20000205400ULL, 0x0000000180800812ULL, 0x004fc400078efcffULL,
0x000000e8e700720bULL, 0x000fca0003f1d000ULL, 0x0000006700947306ULL, 0x000ff00000209400ULL,
0x0000006700937306ULL, 0x000ea20000205400ULL, 0x000000b0b400720bULL, 0x008fe20003fdd000ULL,
0x000001004fb47824ULL, 0x000fe200078e00ffULL, 0x000000017f7f0812ULL, 0x000fc800078efcffULL,
0x00000018ffb47819ULL, 0x000fe200000114b4ULL, 0x0000005b005b7306ULL, 0x000ee2000020d400ULL,
0x0000000f3434a231ULL, 0x082fe400003400ffULL, 0x0000000f3636a231ULL, 0x000fe400003400ffULL,
0x000000103535a231ULL, 0x080fe400003400ffULL, 0x000000103737a231ULL, 0x000fe200003400ffULL,
0x0000007300b27306ULL, 0x000fe20000209400ULL, 0x000000939400720bULL, 0x004fc40003f7d000ULL,
0x000000989900720bULL, 0x000fca0003f5d000ULL, 0x0000007300b37306ULL, 0x000e620000205400ULL,
0x000000015b5b6812ULL, 0x008fe400078efcffULL, 0x000000a6a500720bULL, 0x000fca0003fdd000ULL,
0x0000006700677306ULL, 0x000ea2000020d400ULL, 0x0000000176762812ULL, 0x000fe400078efcffULL,
0x000000575600720bULL, 0x000fe40003f5d000ULL, 0x000000898056723eULL, 0x000fe400000010ffULL,
0x000000547a57723eULL, 0x000fe200000010ffULL, 0x0000006b00a47306ULL, 0x000fe20000209400ULL,
0x000000b3b200720bULL, 0x002fe20003f1d000ULL, 0x000001004eb27824ULL, 0x000fe200078e00ffULL,
0x000000016a6a6812ULL, 0x000fe200078efcffULL, 0x000100004eb37824ULL, 0x000fe200078e00ffULL,
0x000000adac00720bULL, 0x000fc40003fdd000ULL, 0x00000018ffb27819ULL, 0x000fe200000114b2ULL,
0x0000006b00a77306ULL, 0x000e620000205400ULL, 0x0000000167673812ULL, 0x004fe400078efcffULL,
0x000000908f00720bULL, 0x000fe40003f7d000ULL, 0x00000018ffb37819ULL, 0x000fe400000114b3ULL,
0x0000000174742812ULL, 0x000fe200078efcffULL, 0x0000004c009c7306ULL, 0x000fe40000009400ULL,
0x0000000175756812ULL, 0x000fcc00078efcffULL, 0x0000004c009d7306ULL, 0x000fe20000005400ULL,
0x000000a7a400720bULL, 0x002fe40003fbd000ULL, 0x000000016f6f3812ULL, 0x000fca00078efcffULL,
0x0000004c005e7306ULL, 0x0003f0000000d400ULL, 0x0000007300737306ULL, 0x000ea2000020d400ULL,
0x000100004c4c7824ULL, 0x002fca00078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe4000001144cULL,
0x0000006b006b7306ULL, 0x000e70000020d400ULL, 0x0000006500817306ULL, 0x000fe20000209400ULL,
0x0000000173730812ULL, 0x004fc400078efcffULL, 0x000000bbba00720bULL, 0x000fe40003f1d000ULL,
0x0000007d737d723eULL, 0x000fc600000010ffULL, 0x0000006500827306ULL, 0x000ea20000205400ULL,
0x000000016b6b5812ULL, 0x002fe400078efcffULL, 0x0000009d9c00720bULL, 0x000fca0003fbd000ULL,
0x0000005f007b7306ULL, 0x000fe20000209400ULL, 0x0000000177770812ULL, 0x000fe400078efcffULL,
0x0000009a9b00720bULL, 0x000fca0003f1d000ULL, 0x0000005f007c7306ULL, 0x000e620000205400ULL,
0x000000828100720bULL, 0x004fe40003f9d000ULL, 0x000000015e5e5812ULL, 0x000fca00078efcffULL,
0x0000004d00857306ULL, 0x000fe20000009400ULL, 0x0000000164640812ULL, 0x000fe400078efcffULL,
0x000000a99700720bULL, 0x000fca0003f1d000ULL, 0x0000004d00867306ULL, 0x000ea20000005400ULL,
0x0000007c7b00720bULL, 0x002fe40003f7d000ULL, 0x000000835b7c723eULL, 0x000fca00000010ffULL,
0x0000004d005c7306ULL, 0x0002e2000000d400ULL, 0x000000016e6e0812ULL, 0x000fe200078efcffULL,
0x0000007c443c723cULL, 0x000fec000004183cULL, 0x0000004e00597306ULL, 0x000fe20000009400ULL,
0x000100004d4d7824ULL, 0x002fe200078e00ffULL, 0x000000868500720bULL, 0x004fcc0003fdd000ULL,
0x0000004e005a7306ULL, 0x000e6e0000005400ULL, 0x000000015c5c6812ULL, 0x008fe200078efcffULL,
0x0000004e00527306ULL, 0x0004f0000000d400ULL, 0x0000004c00af7306ULL, 0x000fe20000209400ULL,
0x00000018ff4e7819ULL, 0x004fc4000001144dULL, 0x000000a0aa4d723eULL, 0x000fe400000010ffULL,
0x0000005a5900720bULL, 0x002fc60003f5d000ULL, 0x0000004c00b07306ULL, 0x000e700000205400ULL,
0x0000004c00ae7306ULL, 0x0005e4000020d400ULL, 0x0000000152522812ULL, 0x008fcc00078efcffULL,
0x0000006500657306ULL, 0x000ee2000020d400ULL, 0x000000a2ab4c723eULL, 0x004fe400000010ffULL,
0x000000b0af00720bULL, 0x002fca0003fbd000ULL, 0x0000005f005f7306ULL, 0x000e62000020d400ULL,
0x0000004c4428723cULL, 0x000b6e0000041828ULL, 0x00000092964c723eULL, 0x020fe200000010ffULL,
0x0000005300687306ULL, 0x000fe20000209400ULL, 0x00000091954d723eULL, 0x000fc400000010ffULL,
0x0000000165654812ULL, 0x008fe400078efcffULL, 0x000000bdb600720bULL, 0x000fe40003f9d000ULL,
0x000000015f5f3812ULL, 0x002fe200078efcffULL, 0x0000004c4420723cULL, 0x000b620000041820ULL,
0x0000005300697306ULL, 0x000e620000205400ULL, 0x000000c0c200720bULL, 0x000fe40003f7d000ULL,
0x00000001aeae5812ULL, 0x000fc600078efcffULL, 0x000000878b4c723eULL, 0x020fe400000010ffULL,
0x00000084884d723eULL, 0x000fe200000010ffULL, 0x0000005d006c7306ULL, 0x000fe20000209400ULL,
0x000000019e9e4812ULL, 0x000fc800078efcffULL, 0x00000001b7b73812ULL, 0x000fe400078efcffULL,
0x000000696800720bULL, 0x002fe20003fdd000ULL, 0x0000005d006d7306ULL, 0x000e620000205400ULL,
0x0000005e9e5e723eULL, 0x000fce00000010ffULL, 0x0000004e00a47306ULL, 0x000ff00000209400ULL,
0x0000004e00a07306ULL, 0x000ea20000205400ULL, 0x0000006d6c00720bULL, 0x002fce0003f9d000ULL,
0x000000b200937306ULL, 0x000ff00000209400ULL, 0x000000b200917306ULL, 0x000e620000205400ULL,
0x000000a0a400720bULL, 0x004fce0003f7d000ULL, 0x0000004f00717306ULL, 0x000ff00000009400ULL,
0x0000004f00727306ULL, 0x000ea20000005400ULL, 0x000000919300720bULL, 0x002fce0003fbd000ULL,
0x0000004f00497306ULL, 0x000e70000000d400ULL, 0x0000004e009a7306ULL, 0x000722000020d400ULL,
0x000000727100720bULL, 0x004fe40003f1d000ULL, 0x0000006a7871723eULL, 0x000fca00000010ffULL,
0x0000005300537306ULL, 0x000ea2000020d400ULL, 0x0000004c444c723cULL, 0x048b6a0000041818ULL,
0x0000000149490812ULL, 0x002fe400078efcffULL, 0x000000795518723eULL, 0x020fe200000010ffULL,
0x0000005d005d7306ULL, 0x000e62000020d400ULL, 0x000000564454723cULL, 0x000b62000004182cULL,
0x000000587f19723eULL, 0x000fc400000010ffULL, 0x000000019a9a3812ULL, 0x010fe400078efcffULL,
0x0000000153536812ULL, 0x004fe400078efcffULL, 0x000000b200b27306ULL, 0x000ea2000020d400ULL,
0x000000776b2c723eULL, 0x020fe200000010ffULL, 0x000000184458723cULL, 0x000b620000041830ULL,
0x00000075672d723eULL, 0x000fca00000010ffULL, 0x000000b4004b7306ULL, 0x000fe20000209400ULL,
0x000000015d5d4812ULL, 0x002fe200078efcffULL, 0x0000002c342c723cULL, 0x040f640000041824ULL,
0x000000667630723eULL, 0x020fe400000010ffULL, 0x000000646f31723eULL, 0x000fe400000010ffULL,
0x000000746518723eULL, 0x000fe200000010ffULL, 0x000000b4001a7306ULL, 0x000e620000205400ULL,
0x00000001b2b25812ULL, 0x004fe200078efcffULL, 0x000000703428723cULL, 0x000f620000041828ULL,
0x0000006e5f19723eULL, 0x000fc400000010ffULL, 0x0000005cb75f723eULL, 0x000fc600000010ffULL,
0x0000005100637306ULL, 0x000fe40000209400ULL, 0x000000303430723cULL, 0x040b6c0000041820ULL,
0x0000005100627306ULL, 0x000ea20000205400ULL, 0x0000001a4b00720bULL, 0x002fe40003fdd000ULL,
0x000000ae5d20723eULL, 0x020fe200000010ffULL, 0x000000183418723cULL, 0x000b62000004181cULL,
0x0000009a5321723eULL, 0x000fc600000010ffULL, 0x0000004100607306ULL, 0x000fe80000209400ULL,
0x0000005e341c723cULL, 0x000b68000004184cULL, 0x0000004100617306ULL, 0x000e620000205400ULL,
0x000000626300720bULL, 0x004fc60003f9d000ULL, 0x000000203420723cULL, 0x000b680000041854ULL,
0x000000b3004a7306ULL, 0x000ff00000209400ULL, 0x000000b300447306ULL, 0x000ea20000205400ULL,
0x000000616000720bULL, 0x002fce0003f7d000ULL, 0x000000b100457306ULL, 0x000ff00000209400ULL,
0x000000b100247306ULL, 0x000e620000205400ULL, 0x000000444a00720bULL, 0x004fce0003fbd000ULL,
0x000000b400b47306ULL, 0x000eb0000020d400ULL, 0x0000005100517306ULL, 0x000ee2000020d400ULL,
0x000000244500720bULL, 0x002fe40003f5d000ULL, 0x00000052b224723eULL, 0x000fca00000010ffULL,
0x0000004100417306ULL, 0x000e62000020d400ULL, 0x00000001b4b46812ULL, 0x004fc800078efcffULL,
0x00000049b425723eULL, 0x000fc600000010ffULL, 0x000000b300b37306ULL, 0x000ea2000020d400ULL,
0x0000000151514812ULL, 0x008fc600078efcffULL, 0x000000243424723cULL, 0x000b680000041858ULL,
0x000000b100b17306ULL, 0x000ee2000020d400ULL, 0x0000000141413812ULL, 0x002fe400078efcffULL,
0x00000001b3b35812ULL, 0x004fc800078efcffULL, 0x000000b35144723eULL, 0x000fe400000010ffULL,
0x00000001b1b12812ULL, 0x008fc800078efcffULL, 0x000000b14145723eULL, 0x000fce00000010ffULL,
0x000000443434723cULL, 0x000b62000004183cULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0186b800ff3c7f8cULL, 0x020e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000504007c0cULL, 0x000fe2000bf03070ULL,
0x01869000ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff447224ULL, 0x002fe200078e003dULL,
0x000000020b417810ULL, 0x000fd40007ffe0ffULL, 0x0000c1c000000947ULL, 0x000fea0003800000ULL,
0x00000000003c7805ULL, 0x000fc40000015200ULL, 0x0186bc00ff087984ULL, 0x000e640000000800ULL,
0x8000000008ff7812ULL, 0x002fe40007804844ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff417224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104100780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003e7805ULL, 0x000fcc0000015200ULL,
0x0000003e3c3e7210ULL, 0x000fca0007f1e1ffULL, 0x000000013f3f7824ULL, 0x000fe200000e0e3dULL,
0x003d09003e00780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403e00780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc8000001143fULL, 0x0000003e08087211ULL, 0x000fca00078110ffULL,
0x000000ffff3e7224ULL, 0x000fca00000e063fULL, 0x0000000208087819ULL, 0x000fc8000000123eULL,
0x000000080000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000141417810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0186bc00ff087984ULL, 0x000e640000000800ULL, 0x8000000008ff7812ULL, 0x002fe40007804844ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000046000009947ULL, 0x000fea0003800000ULL,
0x0000000107087824ULL, 0x000fe200078e0211ULL, 0x00000002113d7810ULL, 0x040fe20007ffe0ffULL,
0x000000a004057891ULL, 0x000fe2000f8e403fULL, 0x0000000411447810ULL, 0x040fe20007ffe0ffULL,
0x00000001083c7824ULL, 0x040fe200078e0202ULL, 0x00000006114d7810ULL, 0x000fe20007ffe0ffULL,
0x00000010084a7824ULL, 0x000fc400078e00ffULL, 0x00000001073e7824ULL, 0x040fe400078e023dULL,
0x0000000107417824ULL, 0x000fe200078e0244ULL, 0xfffffff04a4a7812ULL, 0x000fe200078ee23cULL,
0x000000013e3f7824ULL, 0x040fe200078e0202ULL, 0x00000020033c7811ULL, 0x000fe200078e30ffULL,
0x000000103e4b7824ULL, 0x000fe200078e00ffULL, 0x000160004a4a7811ULL, 0x000fe200078e20ffULL,
0x00000010414c7824ULL, 0x000fe400078e00ffULL, 0x0000000108477824ULL, 0x000fe200078e023cULL,
0xfffffff04b4b7812ULL, 0x000fe200078ee23fULL, 0x00000001413f7824ULL, 0x000fe200078e0202ULL,
0x0000000504087c17ULL, 0x000fe2000f800000ULL, 0x000000013e467824ULL, 0x100fe200078e023cULL,
0x0000004247477210ULL, 0x000fe20007f1e0ffULL, 0x0000000141417824ULL, 0x000fe200078e023cULL,
0x8000000508087c10ULL, 0x000fc4000fffe0ffULL, 0xfffffff04c4c7812ULL, 0x000fe200078ee23fULL,
0x00000001073f7824ULL, 0x040fe200078e024dULL, 0x0000000807087217ULL, 0x000fe40007800000ULL,
0x0000004246467210ULL, 0x080fe20007f9e0ffULL, 0x000000013f457824ULL, 0x000fe200078e023cULL,
0x0000004241417210ULL, 0x080fe20007f7e0ffULL, 0x000000ffff3c7224ULL, 0x000fe200000e06ffULL,
0x00005e00473e7a11ULL, 0x000fe200078040ffULL, 0x000000013f497824ULL, 0x000fe200078e0202ULL,
0x0000004245427210ULL, 0x000fe20007f5e0ffULL, 0x000000103f4e7824ULL, 0x000fe200078e00ffULL,
0x00005f0047477a11ULL, 0x000fe200000f443cULL, 0x0000000108087824ULL, 0x000fe200078e0a07ULL,
0x00005e0046457a11ULL, 0x000fe200078c40ffULL, 0x000000ffff3c7224ULL, 0x000fe200020e06ffULL,
0xfffffff04e4e7812ULL, 0x000fc400078ee249ULL, 0x000000083d00720cULL, 0x080fe20003f06070ULL,
0x000000ffff3d7224ULL, 0x000fe200018e06ffULL, 0x000000f00c497812ULL, 0x000fe400078ec0ffULL,
0x00005e00413f7a11ULL, 0x000fe400078a40ffULL, 0x000000081100720cULL, 0x080fe40003f86070ULL,
0x00005f0046467a11ULL, 0x000fe400030f443cULL, 0x000000493e3c7210ULL, 0x000fe20007fde0ffULL,
0x000000ffff3e7224ULL, 0x000fe200010e06ffULL, 0x000000084400720cULL, 0x000fc40003f66070ULL,
0x00005f0041417a11ULL, 0x000fe200028f443dULL, 0x000000ffff3d7224ULL, 0x000fe200030e0647ULL,
0x00005e0042447a11ULL, 0x040fe400078a40ffULL, 0x000000084d00720cULL, 0x000fe40003f46070ULL,
0x00005f0042087a11ULL, 0x000fe200028f443eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c4a7faeULL, 0x0003e2000e101c46ULL, 0x00000049453e7210ULL, 0x000fe40007fbe0ffULL,
0x000160004b4b7811ULL, 0x000fc400078e20ffULL, 0x000160004c4c7811ULL, 0x000fe400078e20ffULL,
0x000160004e4e7811ULL, 0x000fe400078e20ffULL, 0x000000493f3c7210ULL, 0x082fe20007f9e0ffULL,
0x000000ffff3f7224ULL, 0x000fe200028e0646ULL, 0x0000004944447210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff3d7224ULL, 0x000fe200020e0641ULL, 0x000000003e4b7faeULL, 0x0003e2000c101c46ULL,
0x000000ffff457224ULL, 0x000fc600028e0608ULL, 0x000000003c4c7faeULL, 0x0003e8000d901c46ULL,
0x00000000444e7faeULL, 0x0003e2000d101c46ULL, 0x0000039000007947ULL, 0x000fea0003800000ULL,
0x0000000107087824ULL, 0x000fe200078e0211ULL, 0x00000020033c7811ULL, 0x000fe400078e30ffULL,
0x000000f00c497812ULL, 0x000fe200078ec0ffULL, 0x00000001083d7824ULL, 0x040fe200078e0202ULL,
0x00000002083e7810ULL, 0x040fe20007ffe0ffULL, 0x00000010084a7824ULL, 0x040fe200078e00ffULL,
0x0000000608417810ULL, 0x000fc60007ffe0ffULL, 0x000000013e3f7824ULL, 0x000fe200078e0202ULL,
0xfffffff04a4a7812ULL, 0x000fe200078ee23dULL, 0x000000103e4b7824ULL, 0x000fe400078e00ffULL,
0x00000001083d7824ULL, 0x000fe200078e023cULL, 0x000160004a4a7811ULL, 0x000fe200078e20ffULL,
0x000000013c457824ULL, 0x040fe200078e023eULL, 0xfffffff04b4b7812ULL, 0x000fe200078ee23fULL,
0x000000013c447824ULL, 0x000fe200078e0241ULL, 0x00000004083f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000141477824ULL, 0x100fe200078e0202ULL, 0x000000423d3d7210ULL, 0x080fe20007f7e0ffULL,
0x00000010414d7824ULL, 0x000fe200078e00ffULL, 0x0000004245457210ULL, 0x080fe20007f1e0ffULL,
0x000000013c087824ULL, 0x000fe200078e023fULL, 0x00005e003d467a11ULL, 0x000fe200078840ffULL,
0x000000013f3e7824ULL, 0x000fe200078e0202ULL, 0xfffffff04d4d7812ULL, 0x000fe200078ee247ULL,
0x000000103f4c7824ULL, 0x000fe200078e00ffULL, 0x00000042083f7210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff3c7224ULL, 0x000fe200018e06ffULL, 0x0000004244087210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff427224ULL, 0x000fe200000e06ffULL, 0xfffffff04c4c7812ULL, 0x000fc400078ee23eULL,
0x00005f003d477a11ULL, 0x000fe200020f443cULL, 0x000000ffff3c7224ULL, 0x000fe200018e06ffULL,
0x00005e0045417a11ULL, 0x000fe200078040ffULL, 0x000000ffff3d7224ULL, 0x000fe200010e06ffULL,
0x00005e0008447a11ULL, 0x000fe400078640ffULL, 0x00005e003f3e7a11ULL, 0x000fe400078440ffULL,
0x0000004946467210ULL, 0x000fe40007f9e0ffULL, 0x00005f0045427a11ULL, 0x000fc400000f4442ULL,
0x00005f0008087a11ULL, 0x000fe200018f443cULL, 0x000000ffff477224ULL, 0x000fe200020e0647ULL,
0x00005f003f3f7a11ULL, 0x000fe400010f443dULL, 0x00000049413c7210ULL, 0x080fe40007f1e0ffULL,
0x000000493e3e7210ULL, 0x080fe20007f5e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000464a7faeULL, 0x0003e2000b901c46ULL, 0x0000004944447210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff3d7224ULL, 0x000fe200000e0642ULL, 0x000160004b4b7811ULL, 0x000fe200078e20ffULL,
0x000000ffff3f7224ULL, 0x000fe200010e063fULL, 0x000160004c4c7811ULL, 0x000fe200078e20ffULL,
0x000000ffff457224ULL, 0x000fe200018e0608ULL, 0x000160004d4d7811ULL, 0x000fe200078e20ffULL,
0x000000003c4b7faeULL, 0x0003e8000b901c46ULL, 0x000000003e4c7faeULL, 0x0003e8000b901c46ULL,
0x00000000444d7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000030b3c7810ULL, 0x002fc80007ffe0ffULL, 0x000000053c00720cULL, 0x000fe20003f06070ULL,
0xffffffffff087424ULL, 0x000fd800078e00ffULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x000000010a3c7824ULL, 0x000fe400078e023cULL, 0x00000004ff3d7424ULL, 0x000fc800078e00ffULL,
0x000060003c3c7625ULL, 0x000fca00078e003dULL, 0x000000063c087981ULL, 0x000324000c1e1900ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0186b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0186b000ff527f8cULL, 0x000ea2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0186480007447f8cULL, 0x000664000c80043fULL,
0x00000000003c7805ULL, 0x002fc40000015200ULL, 0x01864c00073e7984ULL, 0x000e640000000800ULL,
0x800000003eff7812ULL, 0x002fe40007804845ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff427224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003e7805ULL, 0x000fcc0000015200ULL,
0x0000003e3c417210ULL, 0x000fca0007f1e1ffULL, 0x000000013f3f7824ULL, 0x000fe200000e0e3dULL,
0x003d09004100780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404100780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3e7819ULL, 0x000fc8000001143fULL, 0x000000413e3e7211ULL, 0x000fca00078110ffULL,
0x000000ffff3f7224ULL, 0x000fca00000e063fULL, 0x000000023e3e7819ULL, 0x000fc8000000123fULL,
0x0000003e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000142427810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01864c00073e7984ULL, 0x000e640000000800ULL, 0x800000003eff7812ULL, 0x002fe40007804845ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x018100000d3e7984ULL, 0x000e680000000800ULL,
0x018300000d3f7984ULL, 0x0006a20000000800ULL, 0x000000483e00720bULL, 0x002fe20003f1d000ULL,
0x000143b27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000417806ULL, 0x008fc800000e0100ULL,
0x0000ffff41ff7812ULL, 0x000fe2000780c0ffULL, 0x000004a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff447424ULL, 0x000fc400078e00ffULL, 0x000000ffff427224ULL, 0x000fd200078e0048ULL,
0x0000046000008947ULL, 0x000fea0003800000ULL, 0x000000020000780cULL, 0x000fe40003f05270ULL,
0x000000483e00720bULL, 0x000fe20003f54000ULL, 0x000143827f007947ULL, 0x000fd8000b800000ULL,
0x00000000003c7806ULL, 0x000fc400010e0100ULL, 0x0000003e483d8209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe80003800000ULL, 0x0185003d0d008388ULL, 0x0003e40000000800ULL,
0x000099103c3d7816ULL, 0x002fc800000000ffULL, 0x000000ff3d00720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000003e483d7209ULL, 0x000fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff3cff7812ULL, 0x000fc6000780c0ffULL,
0x8000003d483d7221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b3d3d7820ULL, 0x000fc80000410000ULL,
0x0000003d00497308ULL, 0x000e640000000800ULL, 0x0000004909097220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff3d7819ULL, 0x000fe20000011602ULL,
0x000142d27f007947ULL, 0x000fea000b800000ULL, 0x00001f3d493d7589ULL, 0x0002e400000e0000ULL,
0x0000003d28287220ULL, 0x088fe40000410000ULL, 0x0000003d29297220ULL, 0x080fe40000410000ULL,
0x0000003d2c2c7220ULL, 0x080fe40000410000ULL, 0x0000003d2d2d7220ULL, 0x000fc40000410000ULL,
0x0000003d30307220ULL, 0x080fe40000410000ULL, 0x0000003d31317220ULL, 0x080fe40000410000ULL,
0x0000003d18187220ULL, 0x080fe40000410000ULL, 0x0000003d19197220ULL, 0x080fe40000410000ULL,
0x0000003d1c1c7220ULL, 0x080fe40000410000ULL, 0x0000003d1d1d7220ULL, 0x000fc40000410000ULL,
0x0000003d20207220ULL, 0x080fe40000410000ULL, 0x0000003d21217220ULL, 0x080fe40000410000ULL,
0x0000003d24247220ULL, 0x080fe40000410000ULL, 0x0000003d25257220ULL, 0x080fe40000410000ULL,
0x0000003d34347220ULL, 0x080fe40000410000ULL, 0x0000003d35357220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff003cff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008023d7811ULL, 0x000fe200078ff0ffULL,
0x000141e27f007947ULL, 0x000fea000b800000ULL, 0x00001f3d493d7589ULL, 0x00066400000e0000ULL,
0x0000003d2a2a7220ULL, 0x082fe40000410000ULL, 0x0000003d2b2b7220ULL, 0x080fe40000410000ULL,
0x0000003d2e2e7220ULL, 0x080fe40000410000ULL, 0x0000003d2f2f7220ULL, 0x080fe40000410000ULL,
0x0000003d32327220ULL, 0x080fe40000410000ULL, 0x0000003d33337220ULL, 0x000fc40000410000ULL,
0x0000003d1a1a7220ULL, 0x080fe40000410000ULL, 0x0000003d1b1b7220ULL, 0x080fe40000410000ULL,
0x0000003d1e1e7220ULL, 0x080fe40000410000ULL, 0x0000003d1f1f7220ULL, 0x080fe40000410000ULL,
0x0000003d22227220ULL, 0x080fe40000410000ULL, 0x0000003d23237220ULL, 0x000fc40000410000ULL,
0x0000003d26267220ULL, 0x080fe40000410000ULL, 0x0000003d27277220ULL, 0x080fe40000410000ULL,
0x0000003d36367220ULL, 0x080fe40000410000ULL, 0x0000003d37377220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000ffff3cff7812ULL, 0x000fe20007800841ULL,
0x00000001ff447424ULL, 0x000fe200078e00ffULL, 0x0000003e48487209ULL, 0x000fca0007810000ULL,
0x000000ffff427224ULL, 0x000fcc00078e0048ULL, 0x800000483e3e0221ULL, 0x000fe20000010000ULL,
0x00007610ff440816ULL, 0x000fe20000000044ULL, 0x000000ffff420224ULL, 0x000fe400078e0048ULL,
0x3fb8aa3b3e3e0820ULL, 0x000fc80000410000ULL, 0x0000003e000e0308ULL, 0x000e640000000800ULL,
0x0000000e3f3f0220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000093f097221ULL, 0x004fc40000010000ULL, 0x00000000003c7805ULL, 0x000fca0000015200ULL,
0x0186ac00ff3e7984ULL, 0x000e640000000800ULL, 0x800000003eff7812ULL, 0x002fe40007804838ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff457224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003e7805ULL, 0x000fcc0000015200ULL, 0x0000003e3c417210ULL, 0x000fca0007f1e1ffULL,
0x000000013f3f7824ULL, 0x000fe200000e0e3dULL, 0x003d09004100780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404100780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3e7819ULL, 0x000fc8000001143fULL,
0x000000413e3e7211ULL, 0x000fca00078110ffULL, 0x000000ffff3f7224ULL, 0x000fca00000e063fULL,
0x000000023e3e7819ULL, 0x000fc8000000123fULL, 0x0000003e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000145457810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0186ac00ff3e7984ULL, 0x000e640000000800ULL,
0x800000003eff7812ULL, 0x002fe40007804838ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991044387816ULL, 0x000fe200000000ffULL, 0x0000017000007945ULL, 0x000fe60003800000ULL,
0x000000ff3800720cULL, 0x000fda0003f45270ULL, 0x0000014000002947ULL, 0x000fea0003800000ULL,
0x0000000eff0f723eULL, 0x000fe400000010ffULL, 0x00000002ff387819ULL, 0x000fe40000011602ULL,
0x000054100f497816ULL, 0x008fe2000000000fULL, 0x00013dc27f007947ULL, 0x000fea000b800000ULL,
0x00001f38490f7589ULL, 0x0002a400000e0000ULL, 0x0000000838107810ULL, 0x000fe20007ffe0ffULL,
0x00013e027f007947ULL, 0x000fea000b800000ULL, 0x00001f1049107589ULL, 0x00066400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x0000001038477810ULL, 0x000fe20007ffe0ffULL,
0x0000001fff457424ULL, 0x000fe200078e00ffULL, 0x0000ed4000447802ULL, 0x000fe20000000f00ULL,
0xffffffffff467424ULL, 0x000fc400078e00ffULL, 0x0001485000007944ULL, 0x01efea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x0000001838477810ULL, 0x000fe20007ffe0ffULL,
0x0000001fff457424ULL, 0x000fe200078e00ffULL, 0x0000eda000447802ULL, 0x000fe20000000f00ULL,
0xffffffffff467424ULL, 0x004fc400078e00ffULL, 0x000147f000007944ULL, 0x01afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000001248783bULL, 0x00ae680000004200ULL, 0x00000000134c783bULL, 0x000ee80000004200ULL,
0x000000001444783bULL, 0x004ea80000004200ULL, 0x00000000153c783bULL, 0x000ea20000004200ULL,
0x00000100486e7824ULL, 0x002fe200078e00ffULL, 0x0000004800c97306ULL, 0x000fe20000009400ULL,
0x00000018ff937819ULL, 0x000fc40000011449ULL, 0x00000018ff947819ULL, 0x000fe20000011448ULL,
0x000001004f737824ULL, 0x008fe200078e00ffULL, 0x00000018ff6e7819ULL, 0x000fe4000001146eULL,
0x00000018ff887819ULL, 0x000fe2000001144aULL, 0x0000004800ca7306ULL, 0x000e620000005400ULL,
0x00000018ff867819ULL, 0x000fe4000001144bULL, 0x00000018ff577819ULL, 0x000fe4000001144eULL,
0x00000018ff807819ULL, 0x000fc4000001144cULL, 0x00000018ff6a7819ULL, 0x004fe20000011444ULL,
0x0000006e00cb7306ULL, 0x000fe20000209400ULL, 0x00000018ff797819ULL, 0x000fe4000001144dULL,
0x00000018ff677819ULL, 0x000fe40000011445ULL, 0x00000018ff737819ULL, 0x000fe40000011473ULL,
0x00000018ff717819ULL, 0x000fe2000001144fULL, 0x0000006e00cc7306ULL, 0x000ea20000205400ULL,
0x000000cac900720bULL, 0x002fc40003f1d000ULL, 0x00000018ff657819ULL, 0x000fe40000011446ULL,
0x00000018ff5d7819ULL, 0x000fe40000011447ULL, 0x00000018ff5b7819ULL, 0x000fe2000001143cULL,
0x0000006e00aa7306ULL, 0x0002e2000020d400ULL, 0x00000018ff587819ULL, 0x000fe4000001143dULL,
0x00000018ff517819ULL, 0x000fe4000001143eULL, 0x00000018ff387819ULL, 0x000fc6000001143fULL,
0x0000004900c87306ULL, 0x000fe20000009400ULL, 0x00000100496e7824ULL, 0x002fe200078e00ffULL,
0x000000cccb00720bULL, 0x004fc80003f7d000ULL, 0x00000018ff6e7819ULL, 0x000fe4000001146eULL,
0x0000004900727306ULL, 0x000e6e0000005400ULL, 0x00000001aaaa3812ULL, 0x008fe200078efcffULL,
0x0000004900997306ULL, 0x0005f0000000d400ULL, 0x00000048009b7306ULL, 0x0006e2000000d400ULL,
0x0001000049497824ULL, 0x004fe200078e00ffULL, 0x00000072c800720bULL, 0x002fc80003f7d000ULL,
0x00000018ff497819ULL, 0x000fe40000011449ULL, 0x0000006e00cf7306ULL, 0x000fe20000209400ULL,
0x0001000048487824ULL, 0x008fca00078e00ffULL, 0x00000018ff487819ULL, 0x000fe40000011448ULL,
0x0000004900d27306ULL, 0x000fe20000209400ULL, 0x000000019b9b0812ULL, 0x000fe400078efcffULL,
0x0000000199993812ULL, 0x000fca00078efcffULL, 0x0000004900d17306ULL, 0x000e700000205400ULL,
0x0000004800cd7306ULL, 0x000ff00000209400ULL, 0x0000004800ce7306ULL, 0x000ea20000205400ULL,
0x000000d1d200720bULL, 0x002fce0003f1d000ULL, 0x00000048009a7306ULL, 0x0002f0000020d400ULL,
0x0000006e00d07306ULL, 0x000ee20000205400ULL, 0x000001004a487824ULL, 0x002fe200078e00ffULL,
0x000000cecd00720bULL, 0x004fc80003fbd000ULL, 0x00000018ff487819ULL, 0x000fe40000011448ULL,
0x0000004900987306ULL, 0x0002ae000020d400ULL, 0x000000019a9a5812ULL, 0x008fe200078efcffULL,
0x0000004b00c17306ULL, 0x000fe20000009400ULL, 0x000000d0cf00720bULL, 0x000fe20003fdd000ULL,
0x000001004b497824ULL, 0x002fca00078e00ffULL, 0x00000018ff497819ULL, 0x000fe20000011449ULL,
0x0000004b006d7306ULL, 0x000e620000005400ULL, 0x0000000198980812ULL, 0x004fce00078efcffULL,
0x0000009300c67306ULL, 0x000ff00000209400ULL, 0x0000009300c77306ULL, 0x000ea20000205400ULL,
0x0000006dc100720bULL, 0x002fce0003f1d000ULL, 0x0000004800d47306ULL, 0x000ff00000209400ULL,
0x0000004800d37306ULL, 0x000fe20000205400ULL, 0x000000c7c600720bULL, 0x004fce0003fbd000ULL,
0x0000004800907306ULL, 0x0003f0000020d400ULL, 0x0000004a00c47306ULL, 0x000fe20000009400ULL,
0x000001004c487824ULL, 0x002fca00078e00ffULL, 0x00000018ff487819ULL, 0x000fe40000011448ULL,
0x0000004a00ad7306ULL, 0x000ff00000005400ULL, 0x0000004a008c7306ULL, 0x0003f0000000d400ULL,
0x0000009400c57306ULL, 0x000fe20000209400ULL, 0x000100004a4a7824ULL, 0x002fca00078e00ffULL,
0x00000018ff4a7819ULL, 0x000fe4000001144aULL, 0x0000009400a87306ULL, 0x000e700000205400ULL,
0x0000006e00a97306ULL, 0x0004f0000020d400ULL, 0x0000004b008b7306ULL, 0x0006e2000000d400ULL,
0x000001004e6e7824ULL, 0x004fe200078e00ffULL, 0x000000a8c500720bULL, 0x002fc80003f9d000ULL,
0x00000018ff6e7819ULL, 0x000fe4000001146eULL, 0x0000004800dc7306ULL, 0x000fe20000209400ULL,
0x000100004b4b7824ULL, 0x008fe200078e00ffULL, 0x00000001a9a96812ULL, 0x000fe400078efcffULL,
0x000000adc400720bULL, 0x000fe40003fdd000ULL, 0x00000018ff4b7819ULL, 0x000fe4000001144bULL,
0x0000004800db7306ULL, 0x000e620000205400ULL, 0x000000018b8b0812ULL, 0x000fce00078efcffULL,
0x0000004e00b77306ULL, 0x000fe20000009400ULL, 0x000000018c8c6812ULL, 0x000fce00078efcffULL,
0x0000004e00b87306ULL, 0x000fe20000005400ULL, 0x000000dbdc00720bULL, 0x002fce0003f1d000ULL,
0x0000004e00767306ULL, 0x0003f0000000d400ULL, 0x0000009300937306ULL, 0x000ea2000020d400ULL,
0x000100004e4e7824ULL, 0x002fca00078e00ffULL, 0x00000018ff4e7819ULL, 0x000fe4000001144eULL,
0x0000004a00d87306ULL, 0x000ff00000209400ULL, 0x0000004a00d77306ULL, 0x000e620000205400ULL,
0x0000000193935812ULL, 0x004fce00078efcffULL, 0x0000009400947306ULL, 0x000eb0000020d400ULL,
0x0000004900d67306ULL, 0x000fe20000209400ULL, 0x000000d7d800720bULL, 0x002fce0003fbd000ULL,
0x0000004900d57306ULL, 0x000e620000205400ULL, 0x0000000194944812ULL, 0x004fe400078efcffULL,
0x000000d3d400720bULL, 0x000fca0003f9d000ULL, 0x00000049008f7306ULL, 0x000eb0000020d400ULL,
0x0000004b00d97306ULL, 0x000fe20000209400ULL, 0x000000d5d600720bULL, 0x002fe40003f7d000ULL,
0x0000000190904812ULL, 0x000fca00078efcffULL, 0x0000004b00da7306ULL, 0x000e6c0000205400ULL,
0x000000018f8f3812ULL, 0x004fe400078efcffULL, 0x0000004e00df7306ULL, 0x000ff00000209400ULL,
0x0000004e00e07306ULL, 0x000fe20000205400ULL, 0x000000dad900720bULL, 0x002fce0003fdd000ULL,
0x0000004e00817306ULL, 0x0003f0000020d400ULL, 0x0000004400a07306ULL, 0x000fe20000009400ULL,
0x00000100444e7824ULL, 0x002fca00078e00ffULL, 0x00000018ff4e7819ULL, 0x000fe4000001144eULL,
0x0000004400a37306ULL, 0x000ff00000005400ULL, 0x00000044006f7306ULL, 0x0003f0000000d400ULL,
0x0000004800497306ULL, 0x000ea2000020d400ULL, 0x0001000044447824ULL, 0x002fca00078e00ffULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x0000008000bc7306ULL, 0x000ff00000209400ULL,
0x0000008000bb7306ULL, 0x000e620000205400ULL, 0x0000000149490812ULL, 0x004fce00078efcffULL,
0x0000004a008a7306ULL, 0x0004f0000020d400ULL, 0x0000004c00bf7306ULL, 0x000fe20000009400ULL,
0x000001004d4a7824ULL, 0x004fe200078e00ffULL, 0x000000bbbc00720bULL, 0x002fc80003f1d000ULL,
0x00000018ff4a7819ULL, 0x000fe4000001144aULL, 0x0000004c00be7306ULL, 0x000e620000005400ULL,
0x000000018a8a5812ULL, 0x008fce00078efcffULL, 0x0000004d00977306ULL, 0x000ff00000009400ULL,
0x0000004d00bd7306ULL, 0x000fe20000005400ULL, 0x000000bebf00720bULL, 0x002fce0003fbd000ULL,
0x0000004d00857306ULL, 0x0003f0000000d400ULL, 0x0000004e00eb7306ULL, 0x000fe20000209400ULL,
0x000100004d4d7824ULL, 0x002fca00078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x0000004e00ec7306ULL, 0x000ff00000205400ULL, 0x0000004e007b7306ULL, 0x0003f0000020d400ULL,
0x0000004500a17306ULL, 0x000fe20000009400ULL, 0x00000100454e7824ULL, 0x002fca00078e00ffULL,
0x00000018ff4e7819ULL, 0x000fe4000001144eULL, 0x00000045009c7306ULL, 0x000ff00000005400ULL,
0x0000004500707306ULL, 0x0003f0000000d400ULL, 0x0000004400b57306ULL, 0x000fe20000209400ULL,
0x0001000045457824ULL, 0x002fca00078e00ffULL, 0x00000018ff457819ULL, 0x000fe40000011445ULL,
0x0000004400b67306ULL, 0x000ff00000205400ULL, 0x0000004400757306ULL, 0x0003f0000020d400ULL,
0x0000008800c07306ULL, 0x000fe20000209400ULL, 0x0000010046447824ULL, 0x002fca00078e00ffULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x0000008800b37306ULL, 0x000e700000205400ULL,
0x0000004b004b7306ULL, 0x000eb0000020d400ULL, 0x0000008000807306ULL, 0x000ee2000020d400ULL,
0x000000b3c000720bULL, 0x002fce0003f9d000ULL, 0x0000004f00af7306ULL, 0x000fe20000009400ULL,
0x000000014b4b6812ULL, 0x004fe400078efcffULL, 0x000000bd9700720bULL, 0x000fca0003fdd000ULL,
0x0000004f00ae7306ULL, 0x000e620000005400ULL, 0x0000000180800812ULL, 0x008fce00078efcffULL,
0x0000004c00847306ULL, 0x0004e2000000d400ULL, 0x0000000185856812ULL, 0x000fe400078efcffULL,
0x000000b8b700720bULL, 0x000fca0003fdd000ULL, 0x0000008600c27306ULL, 0x000fe20000209400ULL,
0x000100004c4c7824ULL, 0x004fe200078e00ffULL, 0x000000aeaf00720bULL, 0x002fc80003f1d000ULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x0000008600c37306ULL, 0x000e620000205400ULL,
0x0000000184845812ULL, 0x008fe400078efcffULL, 0x0000000176766812ULL, 0x000fe400078efcffULL,
0x000000844984723eULL, 0x000fc600000010ffULL, 0x0000004d00e47306ULL, 0x000ff00000209400ULL,
0x0000004d00e37306ULL, 0x000ea20000205400ULL, 0x000000c3c200720bULL, 0x002fce0003f7d000ULL,
0x0000007300e57306ULL, 0x000ff00000209400ULL, 0x0000007300e67306ULL, 0x000fe20000205400ULL,
0x000000e3e400720bULL, 0x004fce0003fbd000ULL, 0x00000073007d7306ULL, 0x000ff0000020d400ULL,
0x0000004500b07306ULL, 0x000ff00000209400ULL, 0x0000004500b17306ULL, 0x000ff00000205400ULL,
0x0000004500737306ULL, 0x0003f0000020d400ULL, 0x0000004400ab7306ULL, 0x000fe20000209400ULL,
0x0000010047457824ULL, 0x002fca00078e00ffULL, 0x00000018ff457819ULL, 0x000fe40000011445ULL,
0x0000004400ac7306ULL, 0x000ff00000205400ULL, 0x0000004400747306ULL, 0x0003f0000020d400ULL,
0x0000004f00557306ULL, 0x0004e2000000d400ULL, 0x000001003c447824ULL, 0x002fca00078e00ffULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x0000008800887306ULL, 0x000e62000020d400ULL,
0x000100004f4f7824ULL, 0x004fca00078e00ffULL, 0x00000018ff4f7819ULL, 0x000fe4000001144fULL,
0x0000004600a47306ULL, 0x000fe20000009400ULL, 0x0000000155550812ULL, 0x008fce00078efcffULL,
0x00000046009e7306ULL, 0x000fe20000005400ULL, 0x0000000188884812ULL, 0x002fc800078efcffULL,
0x0000008a8888723eULL, 0x000fc600000010ffULL, 0x0000004600667306ULL, 0x0003f0000000d400ULL,
0x00000047008e7306ULL, 0x000fe20000009400ULL, 0x0001000046467824ULL, 0x002fca00078e00ffULL,
0x00000018ff467819ULL, 0x000fe40000011446ULL, 0x00000047008d7306ULL, 0x000ff00000005400ULL,
0x0000004700627306ULL, 0x0003f0000000d400ULL, 0x0000004a00de7306ULL, 0x000fe20000209400ULL,
0x0001000047477824ULL, 0x002fca00078e00ffULL, 0x00000018ff477819ULL, 0x000fe40000011447ULL,
0x0000004a00dd7306ULL, 0x000e700000205400ULL, 0x0000004c00e17306ULL, 0x000ff00000209400ULL,
0x0000004c00e27306ULL, 0x000fe20000205400ULL, 0x000000ddde00720bULL, 0x002fce0003f9d000ULL,
0x0000004c00487306ULL, 0x000ff0000020d400ULL, 0x0000004d004c7306ULL, 0x000e70000020d400ULL,
0x0000007100a57306ULL, 0x000ff00000209400ULL, 0x0000007100a67306ULL, 0x000ea20000205400ULL,
0x000000014c4c5812ULL, 0x002fc400078efcffULL, 0x000000e6e500720bULL, 0x000fca0003fbd000ULL,
0x0000006e00e77306ULL, 0x000ff00000209400ULL, 0x0000006e00e87306ULL, 0x000fe20000205400ULL,
0x000000a6a500720bULL, 0x004fe20003f1d000ULL, 0x000001003ea57824ULL, 0x040fe200078e00ffULL,
0x000000017d7d5812ULL, 0x000fe200078efcffULL, 0x000100003ea67824ULL, 0x000fc600078e00ffULL,
0x00000018ffa57819ULL, 0x000fe200000114a5ULL, 0x0000006e004d7306ULL, 0x000fe2000020d400ULL,
0x00000018ffa67819ULL, 0x000fce00000114a6ULL, 0x0000008600867306ULL, 0x000e70000020d400ULL,
0x0000004500917306ULL, 0x000ff00000209400ULL, 0x0000004500927306ULL, 0x000fe20000205400ULL,
0x0000000186863812ULL, 0x002fc400078efcffULL, 0x000000e2e100720bULL, 0x000fca0003f7d000ULL,
0x00000045006e7306ULL, 0x0003f0000020d400ULL, 0x0000004400b37306ULL, 0x000fe20000209400ULL,
0x000001003d457824ULL, 0x002fe200078e00ffULL, 0x0000000148483812ULL, 0x000fc400078efcffULL,
0x000000e8e700720bULL, 0x000fe40003f7d000ULL, 0x00000018ffbc7819ULL, 0x000fe40000011445ULL,
0x0000004400be7306ULL, 0x000ff00000205400ULL, 0x0000004400977306ULL, 0x0003e2000020d400ULL,
0x000000014d4d3812ULL, 0x000fc400078efcffULL, 0x000000a3a000720bULL, 0x000fe40003f7d000ULL,
0x000000764d76723eULL, 0x000fc600000010ffULL, 0x0000004f00e97306ULL, 0x000fe20000209400ULL,
0x0001300016447811ULL, 0x002fce00078e20ffULL, 0x0000004f00ea7306ULL, 0x000e620000205400ULL,
0x000000016f6f3812ULL, 0x000fce00078efcffULL, 0x0000004f007a7306ULL, 0x000eb0000020d400ULL,
0x0000004e00b47306ULL, 0x000fe20000209400ULL, 0x000000eae900720bULL, 0x002fce0003fbd000ULL,
0x0000004e00b27306ULL, 0x000e6c0000205400ULL, 0x000000017a7a5812ULL, 0x004fe400078efcffULL,
0x0000004e007c7306ULL, 0x000ea2000020d400ULL, 0x0000009ea400720bULL, 0x000fce0003fbd000ULL,
0x00000046004e7306ULL, 0x000fe20000209400ULL, 0x000000b2b400720bULL, 0x002fca0003f7d000ULL,
0x0000000166665812ULL, 0x000fe400078efcffULL, 0x00000046004f7306ULL, 0x000e6c0000205400ULL,
0x000000017c7c3812ULL, 0x004fe400078efcffULL, 0x0000004600727306ULL, 0x000ea2000020d400ULL,
0x0000008d8e00720bULL, 0x000fce0003f7d000ULL, 0x0000004700a87306ULL, 0x000fe20000209400ULL,
0x0000004f4e00720bULL, 0x002fe40003fbd000ULL, 0x00000048804e723eULL, 0x000fc600000010ffULL,
0x0000000162623812ULL, 0x000fe400078efcffULL, 0x0000004700ad7306ULL, 0x000e6c0000205400ULL,
0x0000000172725812ULL, 0x004fe400078efcffULL, 0x00000047006d7306ULL, 0x0004f0000020d400ULL,
0x0000004a004a7306ULL, 0x000ee2000020d400ULL, 0x000000004444783bULL, 0x004ea20000000200ULL,
0x000000ada800720bULL, 0x002fcc0003f7d000ULL, 0x0000007900ba7306ULL, 0x000fee0000209400ULL,
0x000000016d6d3812ULL, 0x008fe200078efcffULL, 0x0000007900b97306ULL, 0x000e620000205400ULL,
0x000000014a4a4812ULL, 0x000fc800078efcffULL, 0x000000854a85723eULL, 0x000fc600000010ffULL,
0x0000007100717306ULL, 0x000ef0000020d400ULL, 0x0000005700a77306ULL, 0x000fe20000209400ULL,
0x000000b9ba00720bULL, 0x002fce0003f9d000ULL, 0x00000057009d7306ULL, 0x000e620000205400ULL,
0x0000000171710812ULL, 0x008fe200078efcffULL, 0x0000000f4444a231ULL, 0x084fe200003400ffULL,
0x000000b6b500720bULL, 0x000fe20003f1d000ULL, 0x0000000f4646a231ULL, 0x000fe400003400ffULL,
0x000000104545a231ULL, 0x080fe400003400ffULL, 0x0000007900797306ULL, 0x000ea2000020d400ULL,
0x000000104747a231ULL, 0x000fce00003400ffULL, 0x0000005700577306ULL, 0x000ee2000020d400ULL,
0x0000009da700720bULL, 0x002fe20003fdd000ULL, 0x000001003fa77824ULL, 0x000fe200078e00ffULL,
0x0000000175750812ULL, 0x000fe200078efcffULL, 0x000100003f9d7824ULL, 0x000fc600078e00ffULL,
0x00000018ffa77819ULL, 0x000fe200000114a7ULL, 0x0000006700967306ULL, 0x000fe20000209400ULL,
0x0000000179794812ULL, 0x004fe400078efcffULL, 0x000000e0df00720bULL, 0x000fe40003f9d000ULL,
0x0000004c794f723eULL, 0x000fe400000010ffULL, 0x00000018ff9d7819ULL, 0x000fe2000001149dULL,
0x0000006700957306ULL, 0x000e620000205400ULL, 0x0000000157576812ULL, 0x008fc400078efcffULL,
0x0000009ca100720bULL, 0x000fe20003fdd000ULL, 0x0000004e444c723cULL, 0x000be80000041820ULL,
0x0000003c00897306ULL, 0x000fe20000009400ULL, 0x0000000181814812ULL, 0x000fe400078efcffULL,
0x000000eceb00720bULL, 0x000fca0003f9d000ULL, 0x0000003c00877306ULL, 0x000fe20000005400ULL,
0x000000959600720bULL, 0x002fe40003f1d000ULL, 0x0000000170706812ULL, 0x000fe400078efcffULL,
0x000000acab00720bULL, 0x000fc60003fdd000ULL, 0x0000003c005c7306ULL, 0x0003e2000000d400ULL,
0x000000017b7b4812ULL, 0x000fce00078efcffULL, 0x0000006700677306ULL, 0x000ea2000020d400ULL,
0x000100003c3c7824ULL, 0x002fe200078e00ffULL, 0x0000000174746812ULL, 0x000fc800078efcffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000003d00777306ULL, 0x000fe20000009400ULL,
0x000000667420723eULL, 0x020fce00000010ffULL, 0x0000003d00787306ULL, 0x000e620000005400ULL,
0x0000000167670812ULL, 0x004fe400078efcffULL, 0x000000929100720bULL, 0x000fca0003f1d000ULL,
0x0000003d005a7306ULL, 0x0004f0000000d400ULL, 0x0000003e00547306ULL, 0x000fe20000009400ULL,
0x000100003d3d7824ULL, 0x004fe200078e00ffULL, 0x000000016e6e0812ULL, 0x000fc400078efcffULL,
0x000000787700720bULL, 0x002fe40003fbd000ULL, 0x00000018ff9e7819ULL, 0x000fe4000001143dULL,
0x0000003e00567306ULL, 0x000e620000005400ULL, 0x00000098933d723eULL, 0x000fe400000010ffULL,
0x000000557d77723eULL, 0x000fe400000010ffULL, 0x000000626e21723eULL, 0x000fc600000010ffULL,
0x0000003e00597306ULL, 0x000462000000d400ULL, 0x000000015a5a5812ULL, 0x008fce00078efcffULL,
0x0000003f00637306ULL, 0x000fe20000009400ULL, 0x0000009baa3e723eULL, 0x004fe400000010ffULL,
0x000000565400720bULL, 0x002fca0003f7d000ULL, 0x0000003f00647306ULL, 0x000ff00000005400ULL,
0x0000003f00417306ULL, 0x0003e2000000d400ULL, 0x0000000159593812ULL, 0x000fce00078efcffULL,
0x0000003c00a07306ULL, 0x000fe20000209400ULL, 0x00000099a93f723eULL, 0x002fce00000010ffULL,
0x0000003c00a37306ULL, 0x000fe20000205400ULL, 0x0000003e4428723cULL, 0x000bee0000041828ULL,
0x0000003c009c7306ULL, 0x0003e2000020d400ULL, 0x0000008c903e723eULL, 0x020fe400000010ffULL,
0x0000008b8f3f723eULL, 0x000fca00000010ffULL, 0x0000006a00a27306ULL, 0x000fe20000209400ULL,
0x0000009a943c723eULL, 0x002fe200000010ffULL, 0x0000003e4430723cULL, 0x040f6c0000041830ULL,
0x0000006a009f7306ULL, 0x000e640000205400ULL, 0x0000003c442c723cULL, 0x000b6c000004182cULL,
0x0000006500837306ULL, 0x000fe20000209400ULL, 0x00013000173c7811ULL, 0x020fcc00078e20ffULL,
0x000000003c3c783bULL, 0x000ea20000000200ULL, 0x0000006500827306ULL, 0x000ee20000205400ULL,
0x0000009fa200720bULL, 0x002fce0003f9d000ULL, 0x0000005d007f7306ULL, 0x000ff00000209400ULL,
0x0000005d007e7306ULL, 0x000e620000205400ULL, 0x000000828300720bULL, 0x008fce0003fdd000ULL,
0x0000006a006a7306ULL, 0x000ef0000020d400ULL, 0x0000006500657306ULL, 0x000ee2000020d400ULL,
0x0000007e7f00720bULL, 0x002fe20003f1d000ULL, 0x0000000f3c3ca231ULL, 0x004fcc00003400ffULL,
0x0000005d005d7306ULL, 0x000e62000020d400ULL, 0x000000016a6a4812ULL, 0x008fe200078efcffULL,
0x0000000f3e3ea231ULL, 0x000fe200003400ffULL, 0x000000b1b000720bULL, 0x000fe20003f9d000ULL,
0x000000103d3da231ULL, 0x080fe400003400ffULL, 0x000000103f3fa231ULL, 0x000fe400003400ffULL,
0x000000bc00bb7306ULL, 0x000fe20000209400ULL, 0x0000000165656812ULL, 0x000fe400078efcffULL,
0x000000beb300720bULL, 0x000fc40003fdd000ULL, 0x000000203c20723cULL, 0x000fe60000041830ULL,
0x000000bc00b77306ULL, 0x000ea20000205400ULL, 0x000000015d5d0812ULL, 0x002fe400078efcffULL,
0x0000000173734812ULL, 0x000fe400078efcffULL, 0x000000878900720bULL, 0x000fe40003f9d000ULL,
0x0000004b8689723eULL, 0x000fe200000010ffULL, 0x000000bc00ae7306ULL, 0x000e62000020d400ULL,
0x0000000197976812ULL, 0x000fe200078efcffULL, 0x000000844448723cULL, 0x000be2000004181cULL,
0x000000a3a000720bULL, 0x000fca0003fdd000ULL, 0x0000009e009f7306ULL, 0x000fe20000209400ULL,
0x000000b7bb00720bULL, 0x004fe20003f1d000ULL, 0x000000884418723cULL, 0x040f640000041818ULL,
0x00000081571c723eULL, 0x020fe400000010ffULL, 0x0000007a711d723eULL, 0x000fe400000010ffULL,
0x0000006f7b1e723eULL, 0x000fe200000010ffULL, 0x0000009e00997306ULL, 0x000ea20000205400ULL,
0x000000015c5c4812ULL, 0x000fe200078efcffULL, 0x000000764454723cULL, 0x000b620000041824ULL,
0x000000019c9c6812ULL, 0x000fc400078efcffULL, 0x000000707c1f723eULL, 0x000fe400000010ffULL,
0x00000001aeae0812ULL, 0x002fe200078efcffULL, 0x0000005b006b7306ULL, 0x000fe20000209400ULL,
0x000000756a24723eULL, 0x020fe200000010ffULL, 0x0000001c4434723cULL, 0x000b620000041834ULL,
0x000000736725723eULL, 0x000fe400000010ffULL, 0x0000005c975c723eULL, 0x000fc600000010ffULL,
0x0000005b006c7306ULL, 0x000e620000205400ULL, 0x000000999f00720bULL, 0x004fe20003f1d000ULL,
0x000000243c24723cULL, 0x040b64000004182cULL, 0x00000072651c723eULL, 0x020fe400000010ffULL,
0x0000006d5d1d723eULL, 0x000fe400000010ffULL, 0x0000005aae5d723eULL, 0x000fe200000010ffULL,
0x0000009e00937306ULL, 0x000ea2000020d400ULL, 0x0000001e3c28723cULL, 0x040b6e0000041828ULL,
0x0000005800687306ULL, 0x000fe20000209400ULL, 0x0000006c6b00720bULL, 0x002fe20003f9d000ULL,
0x0000001c3c1c723cULL, 0x040b6c0000041818ULL, 0x0000005800697306ULL, 0x000e620000205400ULL,
0x0000000193930812ULL, 0x004fe200078efcffULL, 0x0000005c3c18723cULL, 0x000b6c0000041848ULL,
0x000000a5008b7306ULL, 0x000ff00000209400ULL, 0x000000a500867306ULL, 0x000ea20000205400ULL,
0x000000696800720bULL, 0x002fce0003fbd000ULL, 0x000000a7007e7306ULL, 0x000ff00000209400ULL,
0x000000a700787306ULL, 0x000e620000205400ULL, 0x000000868b00720bULL, 0x004fce0003fdd000ULL,
0x0000005b005b7306ULL, 0x000eb0000020d400ULL, 0x0000005800587306ULL, 0x000ee2000020d400ULL,
0x000000787e00720bULL, 0x002fce0003f1d000ULL, 0x000000a500a57306ULL, 0x000e62000020d400ULL,
0x000000015b5b4812ULL, 0x004fe400078efcffULL, 0x000000646300720bULL, 0x000fca0003f9d000ULL,
0x000000a700a77306ULL, 0x000ea2000020d400ULL, 0x0000000158585812ULL, 0x008fc800078efcffULL,
0x00000093582d723eULL, 0x000fc600000010ffULL, 0x00000051005e7306ULL, 0x000fe20000209400ULL,
0x00000001a5a56812ULL, 0x002fe400078efcffULL, 0x0000000141414812ULL, 0x000fe400078efcffULL,
0x00000059a530723eULL, 0x000fc600000010ffULL, 0x00000051005f7306ULL, 0x000e620000205400ULL,
0x00000001a7a70812ULL, 0x004fc800078efcffULL, 0x00000041a731723eULL, 0x000fc600000010ffULL,
0x0000003800607306ULL, 0x000fe80000209400ULL, 0x000000303c30723cULL, 0x000b680000041854ULL,
0x0000003800617306ULL, 0x000ea20000205400ULL, 0x0000005f5e00720bULL, 0x002fce0003fbd000ULL,
0x000000a6006f7306ULL, 0x000ff00000209400ULL, 0x000000a600447306ULL, 0x000e620000205400ULL,
0x000000616000720bULL, 0x004fce0003fdd000ULL, 0x0000009d00457306ULL, 0x000ff00000209400ULL,
0x0000009d002c7306ULL, 0x000ea20000205400ULL, 0x000000446f00720bULL, 0x002fce0003f7d000ULL,
0x0000005100517306ULL, 0x000e70000020d400ULL, 0x0000003800387306ULL, 0x000ee2000020d400ULL,
0x0000002c4500720bULL, 0x004fe40003f1d000ULL, 0x0000009c5b2c723eULL, 0x000fca00000010ffULL,
0x000000a600a67306ULL, 0x000ea2000020d400ULL, 0x0000000151515812ULL, 0x002fe200078efcffULL,
0x0000002c3c2c723cULL, 0x000b6c000004184cULL, 0x0000009d009d7306ULL, 0x000e62000020d400ULL,
0x0000000138386812ULL, 0x008fe400078efcffULL, 0x00000001a6a63812ULL, 0x004fc800078efcffULL,
0x000000a651a6723eULL, 0x000fe400000010ffULL, 0x000000019d9d0812ULL, 0x002fc800078efcffULL,
0x0000009d38a7723eULL, 0x000fce00000010ffULL, 0x000000a63c3c723cULL, 0x000b620000041834ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0186b800ff447f8cULL, 0x000e62000c80043fULL,
0x000000ffff417224ULL, 0x000fce00078e00ffULL, 0x0000000000347805ULL, 0x020fc40000015200ULL,
0x0186bc00ff367984ULL, 0x000ea40000000800ULL, 0x8000000036ff7812ULL, 0x006fe40007804845ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104100780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fcc0000015200ULL,
0x0000003634387210ULL, 0x000fca0007f1e1ffULL, 0x0000000137377824ULL, 0x000fe200000e0e35ULL,
0x003d09003800780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403800780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff367819ULL, 0x000fc80000011437ULL, 0x0000003836367211ULL, 0x000fca00078110ffULL,
0x000000ffff377224ULL, 0x000fca00000e0637ULL, 0x0000000236367819ULL, 0x000fc80000001237ULL,
0x000000360000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000141417810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0186bc00ff367984ULL, 0x000e640000000800ULL, 0x8000000036ff7812ULL, 0x002fe40007804845ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000580008517a24ULL, 0x010fc800078e02ffULL,
0x0000004051517824ULL, 0x000fe200078e00ffULL, 0x0000045000009947ULL, 0x000fea0003800000ULL,
0x00000002114a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000107347824ULL, 0x000fe200078e0211ULL,
0x00000004114c7810ULL, 0x000fe20007ffe0ffULL, 0x000000c004057891ULL, 0x000fe2000f8e403fULL,
0x000000f00c487812ULL, 0x000fe200078ec0ffULL, 0x0000000107367824ULL, 0x000fe400078e024aULL,
0x0000000134357824ULL, 0x040fe400078e0202ULL, 0x0000001034497824ULL, 0x000fc400078e00ffULL,
0x0000004003477824ULL, 0x000fe400078e0234ULL, 0x0000000107347824ULL, 0x000fe200078e024cULL,
0xfffffff049497812ULL, 0x000fe200078ee235ULL, 0x0000000136377824ULL, 0x140fe200078e0202ULL,
0x0000005147447210ULL, 0x040fe20007f1e0ffULL, 0x00000010364b7824ULL, 0x000fe200078e00ffULL,
0x0000000247467810ULL, 0x040fe20007ffe0ffULL, 0x0000000134367824ULL, 0x040fe200078e0202ULL,
0x0000000447457810ULL, 0x000fe20007ffe0ffULL, 0x00000010344d7824ULL, 0x000fe200078e00ffULL,
0x0000000504347c17ULL, 0x000fe2000f800000ULL, 0x000000ffff357224ULL, 0x000fe200000e06ffULL,
0x00005e0044387a11ULL, 0x000fc400078040ffULL, 0x8000000534347c10ULL, 0x000fe4000fffe0ffULL,
0x00005f0044447a11ULL, 0x000fe400000f4435ULL, 0x0000003407347217ULL, 0x000fe40007800000ULL,
0x0000005146467210ULL, 0x080fe40007f1e0ffULL, 0xfffffff04b4b7812ULL, 0x000fe200078ee237ULL,
0x0000000134377824ULL, 0x000fe200078e0a07ULL, 0x0000005145457210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff347224ULL, 0x000fe200000e06ffULL, 0x00005e0046417a11ULL, 0x000fc400078040ffULL,
0x000000371100720cULL, 0x000fe20003f86070ULL, 0x000000ffff357224ULL, 0x000fe200018e06ffULL,
0xfffffff04d4d7812ULL, 0x000fe400078ee236ULL, 0x00005f0046467a11ULL, 0x000fe400000f4434ULL,
0x00005e0045367a11ULL, 0x040fe400078a40ffULL, 0x0000004838347210ULL, 0x000fe40007f7e0ffULL,
0x00005f0045457a11ULL, 0x000fc400028f4435ULL, 0x0001400049497811ULL, 0x000fe200078e20ffULL,
0x000000ffff357224ULL, 0x000fe200018e0644ULL, 0x000000374a00720cULL, 0x080fe40003f06070ULL,
0x00000006114a7810ULL, 0x000fe40007ffe0ffULL, 0x0000000647387810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034497faeULL, 0x0003e2000e101c46ULL,
0x000000374c00720cULL, 0x000fe20003f66070ULL, 0x0000000107447824ULL, 0x000fe200078e024aULL,
0x0000005138387210ULL, 0x000fc40007f9e0ffULL, 0x0000004836367210ULL, 0x080fe20007fde0ffULL,
0x0000000144477824ULL, 0x040fe200078e0202ULL, 0x000140004b4b7811ULL, 0x000fe400078e20ffULL,
0x000140004d4d7811ULL, 0x000fe400078e20ffULL, 0x0000004841347210ULL, 0x002fe20007fbe0ffULL,
0x0000001044497824ULL, 0x000fe400078e00ffULL, 0x000000ffff417224ULL, 0x000fe200020e06ffULL,
0x00005e0038447a11ULL, 0x000fe200078840ffULL, 0x000000ffff357224ULL, 0x000fe200028e0646ULL,
0x000000374a00720cULL, 0x000fe20003fa6070ULL, 0x000000ffff377224ULL, 0x000fe200030e0645ULL,
0x00005f0038387a11ULL, 0x000fc400020f4441ULL, 0x0000004844447210ULL, 0x000fe20007f9e0ffULL,
0x00000000344b7faeULL, 0x0003e2000c101c46ULL, 0xfffffff049477812ULL, 0x000fc600078ee247ULL,
0x000000ffff457224ULL, 0x000fe200020e0638ULL, 0x0001400047477811ULL, 0x000fe200078e20ffULL,
0x00000000364d7faeULL, 0x0003e8000d901c46ULL, 0x0000000044477faeULL, 0x0003e2000e901c46ULL,
0x0000038000007947ULL, 0x000fea0003800000ULL, 0x0000000107347824ULL, 0x000fe200078e0211ULL,
0x000000f00c467812ULL, 0x000fc600078ec0ffULL, 0x0000000134357824ULL, 0x040fe200078e0202ULL,
0x0000000234367810ULL, 0x040fe20007ffe0ffULL, 0x0000001034387824ULL, 0x000fc800078e00ffULL,
0x0000000136377824ULL, 0x000fe200078e0202ULL, 0xfffffff038387812ULL, 0x000fe200078ee235ULL,
0x0000001036457824ULL, 0x000fe200078e00ffULL, 0x0000000434367810ULL, 0x000fe20007ffe0ffULL,
0x0000004003357824ULL, 0x000fe200078e0234ULL, 0x0001400038387811ULL, 0x000fe400078e20ffULL,
0xfffffff045457812ULL, 0x000fe200078ee237ULL, 0x0000000136417824ULL, 0x000fe200078e0202ULL,
0x0000000634377810ULL, 0x000fe20007ffe0ffULL, 0x00000010364a7824ULL, 0x000fe200078e00ffULL,
0x0000005135347210ULL, 0x000fc60007f1e0ffULL, 0x0000000137447824ULL, 0x040fe200078e0202ULL,
0xfffffff04a4a7812ULL, 0x000fe200078ee241ULL, 0x00000010374e7824ULL, 0x000fe200078e00ffULL,
0x0000000235417810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff367224ULL, 0x000fe200000e06ffULL,
0x00005e0034377a11ULL, 0x000fe400078040ffULL, 0xfffffff04e4e7812ULL, 0x000fe400078ee244ULL,
0x00005f0034367a11ULL, 0x000fe400000f4436ULL, 0x0000000435347810ULL, 0x000fc40007ffe0ffULL,
0x0000000635357810ULL, 0x000fe40007ffe0ffULL, 0x0000005141417210ULL, 0x080fe40007f1e0ffULL,
0x0000005134477210ULL, 0x080fe40007f7e0ffULL, 0x00000051354b7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff357224ULL, 0x000fe200000e06ffULL, 0x00005e0041447a11ULL, 0x000fe200078040ffULL,
0x000000ffff487224ULL, 0x000fe200018e06ffULL, 0x0000004637347210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff4c7224ULL, 0x000fe200028e06ffULL, 0x00005e0047497a11ULL, 0x000fc400078840ffULL,
0x00005e004b4d7a11ULL, 0x000fe400078a40ffULL, 0x00005f0041417a11ULL, 0x000fe200000f4435ULL,
0x000000ffff357224ULL, 0x000fe200018e0636ULL, 0x0000004644367210ULL, 0x080fe40007f1e0ffULL,
0x00005f0047487a11ULL, 0x000fe400020f4448ULL, 0x0000004649447210ULL, 0x080fe20007f7e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034387faeULL, 0x0003e2000b901c46ULL,
0x00005f004b4c7a11ULL, 0x000fe200028f444cULL, 0x000000ffff377224ULL, 0x000fe200000e0641ULL,
0x000000464d467210ULL, 0x000fc40007f9e0ffULL, 0x000140004a4a7811ULL, 0x000fe400078e20ffULL,
0x000140004e4e7811ULL, 0x000fe200078e20ffULL, 0x000000ffff477224ULL, 0x000fe200020e064cULL,
0x0001400045347811ULL, 0x002fe200078e20ffULL, 0x000000ffff457224ULL, 0x000fc800018e0648ULL,
0x0000000036347faeULL, 0x0003e8000b901c46ULL, 0x00000000444a7faeULL, 0x0003e8000b901c46ULL,
0x00000000464e7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0186a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0186a800ff347f8cULL, 0x000e64000c80043fULL,
0x000000ffff387224ULL, 0x002fc400078e0035ULL, 0x0000000000347805ULL, 0x000fca0000015200ULL,
0x0186b400ff367984ULL, 0x000e640000000800ULL, 0x8000000036ff7812ULL, 0x002fc40007804853ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff447224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fcc0000015200ULL, 0x0000003634417210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09004100780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404100780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000004136367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000144447810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0186b400ff367984ULL, 0x000e640000000800ULL,
0x8000000036ff7812ULL, 0x002fe40007804853ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000016000007945ULL, 0x000fe20003800000ULL, 0x0000014000002947ULL, 0x000fea0003800000ULL,
0x0000000eff0f723eULL, 0x000fe400000010ffULL, 0x00000002ff347819ULL, 0x000fe40000011602ULL,
0x000054100f497816ULL, 0x000fe2000000000fULL, 0x000112c27f007947ULL, 0x000fea000b800000ULL,
0x00001f34490f7589ULL, 0x0002a400000e0000ULL, 0x0000000834107810ULL, 0x000fe20007ffe0ffULL,
0x000113027f007947ULL, 0x000fea000b800000ULL, 0x00001f1049107589ULL, 0x00066400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x0000001034477810ULL, 0x000fe20007ffe0ffULL,
0x0000001fff457424ULL, 0x000fe200078e00ffULL, 0x0001192000447802ULL, 0x000fe20000000f00ULL,
0xffffffffff467424ULL, 0x000fc400078e00ffULL, 0x00011c7000007944ULL, 0x00efea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x0000001834477810ULL, 0x000fe20007ffe0ffULL,
0x0000001fff457424ULL, 0x000fe200078e00ffULL, 0x0001198000447802ULL, 0x000fe20000000f00ULL,
0xffffffffff467424ULL, 0x004fc400078e00ffULL, 0x00011c1000007944ULL, 0x00afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000003b44783bULL, 0x004ea20000004200ULL, 0x000000c004057891ULL, 0x000fc6000f8e403fULL,
0x00000000404c783bULL, 0x000f280000004200ULL, 0x000000003934783bULL, 0x002e680000004200ULL,
0x000000003a48783bULL, 0x008ee20000004200ULL, 0x00000100446d7824ULL, 0x004fe200078e00ffULL,
0x0000004400d07306ULL, 0x000fe20000009400ULL, 0x00000018ff997819ULL, 0x000fe20000011444ULL,
0x0000010047737824ULL, 0x000fe200078e00ffULL, 0x00000018ff987819ULL, 0x000fc40000011445ULL,
0x00000018ff6d7819ULL, 0x000fe4000001146dULL, 0x00000018ff887819ULL, 0x000fe20000011447ULL,
0x0000004400727306ULL, 0x000ea20000005400ULL, 0x00000018ff8b7819ULL, 0x000fe40000011446ULL,
0x00000018ff737819ULL, 0x000fe40000011473ULL, 0x00000018ff577819ULL, 0x010fe4000001144eULL,
0x00000018ff7e7819ULL, 0x000fe2000001144cULL, 0x0000006d00d27306ULL, 0x000fe20000209400ULL,
0x00000018ff787819ULL, 0x000fc4000001144dULL, 0x00000018ff697819ULL, 0x002fe40000011434ULL,
0x00000018ff657819ULL, 0x000fe40000011435ULL, 0x00000018ff717819ULL, 0x000fe2000001144fULL,
0x0000006d00d17306ULL, 0x000e620000205400ULL, 0x00000072d000720bULL, 0x004fe40003f1d000ULL,
0x00000018ff637819ULL, 0x000fe40000011436ULL, 0x00000018ff5d7819ULL, 0x000fc40000011437ULL,
0x00000018ff5b7819ULL, 0x008fe20000011448ULL, 0x0000006d00ab7306ULL, 0x0005e2000020d400ULL,
0x00000018ff597819ULL, 0x000fe40000011449ULL, 0x00000018ff537819ULL, 0x000fe4000001144aULL,
0x00000018ff417819ULL, 0x000fc6000001144bULL, 0x0000004400a27306ULL, 0x000722000000d400ULL,
0x00000100456d7824ULL, 0x004fe200078e00ffULL, 0x000000d1d200720bULL, 0x002fc80003fdd000ULL,
0x00000018ff6d7819ULL, 0x000fe4000001146dULL, 0x0000004500cf7306ULL, 0x000fe20000009400ULL,
0x0001000044447824ULL, 0x008fca00078e00ffULL, 0x00000018ffa17819ULL, 0x000fe40000011444ULL,
0x0000006d00d57306ULL, 0x000fe20000209400ULL, 0x00000001a2a20812ULL, 0x010fe400078efcffULL,
0x00000001abab6812ULL, 0x000fca00078efcffULL, 0x0000006d00d47306ULL, 0x000e700000205400ULL,
0x0000004500ce7306ULL, 0x000eb00000005400ULL, 0x0000004500a07306ULL, 0x0007e2000000d400ULL,
0x000000d4d500720bULL, 0x002fce0003f7d000ULL, 0x0000006d00aa7306ULL, 0x000322000020d400ULL,
0x0001000045457824ULL, 0x008fe200078e00ffULL, 0x000000cecf00720bULL, 0x004fc80003fdd000ULL,
0x00000018ff9f7819ULL, 0x000fe40000011445ULL, 0x0000004600ca7306ULL, 0x000fe20000009400ULL,
0x00000100466d7824ULL, 0x002fca00078e00ffULL, 0x00000018ff6d7819ULL, 0x000fe4000001146dULL,
0x00000046006c7306ULL, 0x000e620000005400ULL, 0x00000001aaaa3812ULL, 0x010fe400078efcffULL,
0x00000001a0a06812ULL, 0x000fca00078efcffULL, 0x0000009900cd7306ULL, 0x000ff00000209400ULL,
0x0000009900957306ULL, 0x000ea20000205400ULL, 0x0000006cca00720bULL, 0x002fce0003f7d000ULL,
0x000000a100d37306ULL, 0x000ff00000209400ULL, 0x000000a100447306ULL, 0x000e620000205400ULL,
0x00000095cd00720bULL, 0x004fce0003f9d000ULL, 0x0000004700c97306ULL, 0x000ff00000009400ULL,
0x0000004700b67306ULL, 0x000fe20000005400ULL, 0x00000044d300720bULL, 0x002fe40003fbd000ULL,
0x0001300043447811ULL, 0x000fca00078e20ffULL, 0x00000047008f7306ULL, 0x0003f0000000d400ULL,
0x0000009f00457306ULL, 0x000fe20000209400ULL, 0x0001000047477824ULL, 0x002fca00078e00ffULL,
0x00000018ff8a7819ULL, 0x000fe40000011447ULL, 0x0000009f00d67306ULL, 0x000e700000205400ULL,
0x0000004600907306ULL, 0x0004f0000000d400ULL, 0x0000009900997306ULL, 0x000f22000020d400ULL,
0x0001000046467824ULL, 0x004fe200078e00ffULL, 0x000000d64500720bULL, 0x002fc80003f1d000ULL,
0x00000018ff8c7819ULL, 0x000fe40000011446ULL, 0x000000a100a17306ULL, 0x000e62000020d400ULL,
0x0000000190903812ULL, 0x008fce00078efcffULL, 0x0000009800cc7306ULL, 0x000fe20000209400ULL,
0x0000000199994812ULL, 0x010fce00078efcffULL, 0x0000009800a97306ULL, 0x000ea20000205400ULL,
0x00000001a1a15812ULL, 0x002fce00078efcffULL, 0x0000006d00d87306ULL, 0x000ff00000209400ULL,
0x0000006d00d77306ULL, 0x000e620000205400ULL, 0x000000a9cc00720bULL, 0x004fce0003fbd000ULL,
0x0000008a00477306ULL, 0x000ff00000209400ULL, 0x0000008a00dc7306ULL, 0x000ea20000205400ULL,
0x000000d7d800720bULL, 0x002fce0003f9d000ULL, 0x0000006d00947306ULL, 0x0002f0000020d400ULL,
0x0000009f009f7306ULL, 0x000f22000020d400ULL, 0x000001004c6d7824ULL, 0x002fe200078e00ffULL,
0x000000dc4700720bULL, 0x004fc80003f7d000ULL, 0x00000018ff6d7819ULL, 0x000fe4000001146dULL,
0x0000007300da7306ULL, 0x000fe20000209400ULL, 0x0000000194944812ULL, 0x008fce00078efcffULL,
0x0000007300d97306ULL, 0x000e620000205400ULL, 0x000000019f9f0812ULL, 0x010fe400078efcffULL,
0x000000b6c900720bULL, 0x000fca0003f1d000ULL, 0x0000009800987306ULL, 0x000eb0000020d400ULL,
0x0000008a008a7306ULL, 0x000ee2000020d400ULL, 0x000000d9da00720bULL, 0x002fe40003fdd000ULL,
0x000000018f8f0812ULL, 0x000fca00078efcffULL, 0x0000004d00c47306ULL, 0x000fe20000009400ULL,
0x0000000198985812ULL, 0x004fce00078efcffULL, 0x0000004d00c67306ULL, 0x000e620000005400ULL,
0x000000018a8a3812ULL, 0x008fce00078efcffULL, 0x0000008b00c87306ULL, 0x000ff00000209400ULL,
0x0000008b00cb7306ULL, 0x000ea20000205400ULL, 0x000000c6c400720bULL, 0x002fce0003f7d000ULL,
0x0000008c00db7306ULL, 0x000ff00000209400ULL, 0x0000008c00467306ULL, 0x000e620000205400ULL,
0x000000cbc800720bULL, 0x004fce0003f9d000ULL, 0x0000006d00dd7306ULL, 0x000ff00000209400ULL,
0x0000006d00de7306ULL, 0x000ea20000205400ULL, 0x00000046db00720bULL, 0x002fe40003fbd000ULL,
0x000000004444783bULL, 0x000e6a0000000200ULL, 0x0000006d00897306ULL, 0x000730000020d400ULL,
0x0000004e00bc7306ULL, 0x000fe20000009400ULL, 0x000001004e6d7824ULL, 0x008fe200078e00ffULL,
0x000000dedd00720bULL, 0x004fc80003f1d000ULL, 0x00000018ff6d7819ULL, 0x000fe4000001146dULL,
0x0000004e00b77306ULL, 0x000fee0000005400ULL, 0x0000000189890812ULL, 0x010fe200078efcffULL,
0x0000004e00777306ULL, 0x0005f0000000d400ULL, 0x0000007300937306ULL, 0x000722000020d400ULL,
0x000100004e4e7824ULL, 0x004fe200078e00ffULL, 0x0000000f4444a231ULL, 0x002fc400003400ffULL,
0x0000000f4646a231ULL, 0x000fe400003400ffULL, 0x00000018ff4e7819ULL, 0x000fe2000001144eULL,
0x000000104545a231ULL, 0x080fe200003400ffULL, 0x0000008800c77306ULL, 0x000fe20000209400ULL,
0x000001004d737824ULL, 0x008fe200078e00ffULL, 0x000000104747a231ULL, 0x000fc800003400ffULL,
0x00000018ff737819ULL, 0x000fe40000011473ULL, 0x0000008800bd7306ULL, 0x000e620000205400ULL,
0x0000000193936812ULL, 0x010fce00078efcffULL, 0x0000004e00e37306ULL, 0x000ff00000209400ULL,
0x0000004e00e47306ULL, 0x000fe20000205400ULL, 0x000000bdc700720bULL, 0x002fce0003fdd000ULL,
0x0000004e00817306ULL, 0x0003f0000020d400ULL, 0x0000004c00c57306ULL, 0x000fe20000009400ULL,
0x00000100344e7824ULL, 0x002fca00078e00ffULL, 0x00000018ff4e7819ULL, 0x000fe4000001144eULL,
0x0000004c009e7306ULL, 0x000ff00000005400ULL, 0x0000004c00857306ULL, 0x0003f0000000d400ULL,
0x0000004d00827306ULL, 0x0004e2000000d400ULL, 0x000100004c4c7824ULL, 0x002fca00078e00ffULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x0000008b008b7306ULL, 0x000e62000020d400ULL,
0x000100004d4d7824ULL, 0x004fca00078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x0000008c008c7306ULL, 0x000ea2000020d400ULL, 0x0000000182823812ULL, 0x008fce00078efcffULL,
0x0000007300df7306ULL, 0x000fe20000209400ULL, 0x000000018b8b4812ULL, 0x002fce00078efcffULL,
0x0000007300e07306ULL, 0x000e620000205400ULL, 0x000000018c8c5812ULL, 0x004fe400078efcffULL,
0x0000009ec500720bULL, 0x000fca0003fbd000ULL, 0x0000006d00e97306ULL, 0x000ff00000209400ULL,
0x0000006d00ea7306ULL, 0x000ea20000205400ULL, 0x000000e0df00720bULL, 0x002fe40003f9d000ULL,
0x0000000185855812ULL, 0x000fca00078efcffULL, 0x0000003400b57306ULL, 0x000ff00000009400ULL,
0x0000003400af7306ULL, 0x000fe20000005400ULL, 0x000000eae900720bULL, 0x004fce0003f7d000ULL,
0x00000034006e7306ULL, 0x0003f0000000d400ULL, 0x0000007e00c27306ULL, 0x000fe20000209400ULL,
0x0001000034347824ULL, 0x002fca00078e00ffULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000007e00c37306ULL, 0x000e700000205400ULL, 0x0000007300867306ULL, 0x0004f0000020d400ULL,
0x0000008800887306ULL, 0x000f22000020d400ULL, 0x000001004f737824ULL, 0x004fe200078e00ffULL,
0x000000c3c200720bULL, 0x002fc80003f1d000ULL, 0x00000018ff737819ULL, 0x000fe40000011473ULL,
0x0000004e00bf7306ULL, 0x000fe20000209400ULL, 0x0000000186864812ULL, 0x008fce00078efcffULL,
0x0000004e00be7306ULL, 0x000fe20000205400ULL, 0x0000000188886812ULL, 0x010fce00078efcffULL,
0x0000004e007c7306ULL, 0x0003f0000020d400ULL, 0x0000003500a57306ULL, 0x000fe20000009400ULL,
0x00000100354e7824ULL, 0x002fca00078e00ffULL, 0x00000018ff4e7819ULL, 0x000fe4000001144eULL,
0x0000003500a67306ULL, 0x000ff00000005400ULL, 0x0000003500687306ULL, 0x0003f0000000d400ULL,
0x0000004c00e27306ULL, 0x000fe20000209400ULL, 0x0001000035357824ULL, 0x002fca00078e00ffULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x0000004c00e17306ULL, 0x000e700000205400ULL,
0x0000004c00877306ULL, 0x000eb0000020d400ULL, 0x0000004d00e67306ULL, 0x000fe20000209400ULL,
0x000000e1e200720bULL, 0x002fce0003fdd000ULL, 0x0000004d00e57306ULL, 0x000e6c0000205400ULL,
0x0000000187876812ULL, 0x004fe400078efcffULL, 0x0000004d004c7306ULL, 0x000ea2000020d400ULL,
0x000000b7bc00720bULL, 0x000fce0003fdd000ULL, 0x0000006d004d7306ULL, 0x000ee2000020d400ULL,
0x000000e5e600720bULL, 0x002fca0003fbd000ULL, 0x0000000177776812ULL, 0x000fe400078efcffULL,
0x0000003400ba7306ULL, 0x000fec0000209400ULL, 0x000000014c4c5812ULL, 0x004fe400078efcffULL,
0x0000003400bb7306ULL, 0x000fe20000205400ULL, 0x000000014d4d3812ULL, 0x008fc400078efcffULL,
0x000000afb500720bULL, 0x000fca0003f7d000ULL, 0x0000003400757306ULL, 0x0003f0000020d400ULL,
0x0000007800c07306ULL, 0x000fe20000209400ULL, 0x0000010036347824ULL, 0x002fe200078e00ffULL,
0x000000016e6e3812ULL, 0x000fc800078efcffULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000007800c17306ULL, 0x000e700000205400ULL, 0x0000007300e77306ULL, 0x000ff00000209400ULL,
0x0000007300e87306ULL, 0x000fe20000205400ULL, 0x000000c1c000720bULL, 0x002fce0003f9d000ULL,
0x00000073007d7306ULL, 0x000ff0000020d400ULL, 0x0000003500ac7306ULL, 0x000ff00000209400ULL,
0x0000003500ad7306ULL, 0x000ff00000205400ULL, 0x0000003500737306ULL, 0x0003f0000020d400ULL,
0x0000007e007e7306ULL, 0x000ea2000020d400ULL, 0x0000010037357824ULL, 0x002fca00078e00ffULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x0000003400977306ULL, 0x000ff00000209400ULL,
0x0000003400967306ULL, 0x000fe20000205400ULL, 0x000000017e7e0812ULL, 0x004fc400078efcffULL,
0x000000e8e700720bULL, 0x000fca0003f1d000ULL, 0x0000003400747306ULL, 0x0003f0000020d400ULL,
0x0000004f00b17306ULL, 0x000fe20000009400ULL, 0x0000010048347824ULL, 0x002fe200078e00ffULL,
0x000000017d7d0812ULL, 0x000fc800078efcffULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000004f00ae7306ULL, 0x000e700000005400ULL, 0x0000004f00547306ULL, 0x0004f0000000d400ULL,
0x0000007800787306ULL, 0x000f22000020d400ULL, 0x000100004f4f7824ULL, 0x004fe200078e00ffULL,
0x000000aeb100720bULL, 0x002fe20003fbd000ULL, 0x000100004bb17824ULL, 0x000fc600078e00ffULL,
0x00000018ff4f7819ULL, 0x000fe4000001144fULL, 0x0000003600a87306ULL, 0x000fe20000009400ULL,
0x00000018ffb17819ULL, 0x000fcc00000114b1ULL, 0x0000000154545812ULL, 0x008fe200078efcffULL,
0x0000003600a37306ULL, 0x000e620000005400ULL, 0x0000000178784812ULL, 0x010fe400078efcffULL,
0x000000e4e300720bULL, 0x000fca0003f9d000ULL, 0x0000003600647306ULL, 0x0004f0000000d400ULL,
0x00000037009b7306ULL, 0x000fe20000009400ULL, 0x0001000036367824ULL, 0x004fe200078e00ffULL,
0x0000000181814812ULL, 0x000fc400078efcffULL, 0x000000bebf00720bULL, 0x000fe40003f9d000ULL,
0x00000018ff367819ULL, 0x000fe40000011436ULL, 0x00000037009a7306ULL, 0x000ff00000005400ULL,
0x0000003700627306ULL, 0x0005e2000000d400ULL, 0x000000017c7c4812ULL, 0x000fc400078efcffULL,
0x000000a3a800720bULL, 0x002fe40003f9d000ULL, 0x0000006e7c6e723eULL, 0x000fc600000010ffULL,
0x0000004e00b87306ULL, 0x000fe20000209400ULL, 0x0001000037377824ULL, 0x004fca00078e00ffULL,
0x00000018ff377819ULL, 0x000fe40000011437ULL, 0x0000004e00b97306ULL, 0x000e620000205400ULL,
0x0000000164644812ULL, 0x008fce00078efcffULL, 0x00000035008d7306ULL, 0x000ff00000209400ULL,
0x00000035008e7306ULL, 0x000fe20000205400ULL, 0x000000b9b800720bULL, 0x002fce0003f7d000ULL,
0x00000035006d7306ULL, 0x0003f0000020d400ULL, 0x0000003400b67306ULL, 0x000fe20000209400ULL,
0x0000010049357824ULL, 0x002fca00078e00ffULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x0000003400bd7306ULL, 0x000ff00000205400ULL, 0x00000034009e7306ULL, 0x0003f0000020d400ULL,
0x0000007100b27306ULL, 0x000fe20000209400ULL, 0x0001300050347811ULL, 0x002fce00078e20ffULL,
0x0000007100b37306ULL, 0x000e700000205400ULL, 0x0000004f00eb7306ULL, 0x000ff00000209400ULL,
0x0000004f00ec7306ULL, 0x000ea20000205400ULL, 0x000000b3b200720bULL, 0x002fe20003f1d000ULL,
0x000001004ab27824ULL, 0x000fc400078e00ffULL, 0x000100004ab37824ULL, 0x000fc600078e00ffULL,
0x00000018ffb27819ULL, 0x000fe200000114b2ULL, 0x0000004f007b7306ULL, 0x000e62000020d400ULL,
0x00000018ffb37819ULL, 0x000fce00000114b3ULL, 0x0000004e00767306ULL, 0x000ee2000020d400ULL,
0x000000eceb00720bULL, 0x004fce0003fbd000ULL, 0x00000036004e7306ULL, 0x000fec0000209400ULL,
0x000000017b7b5812ULL, 0x002fe400078efcffULL, 0x00000036004f7306ULL, 0x000fe20000205400ULL,
0x0000000176763812ULL, 0x008fce00078efcffULL, 0x0000003600727306ULL, 0x000ff0000020d400ULL,
0x0000003700957306ULL, 0x000ff00000209400ULL, 0x0000003700a97306ULL, 0x000ff00000205400ULL,
0x00000037006c7306ULL, 0x000ff0000020d400ULL, 0x0000003500c27306ULL, 0x000ff00000209400ULL,
0x0000003500c07306ULL, 0x000ff00000205400ULL, 0x0000003500b77306ULL, 0x0003f0000020d400ULL,
0x0000005700b47306ULL, 0x000fe20000209400ULL, 0x000000003434783bULL, 0x002e6e0000000200ULL,
0x0000005700b07306ULL, 0x000eb00000205400ULL, 0x0000006500927306ULL, 0x000ff00000209400ULL,
0x0000006500917306ULL, 0x000ee20000205400ULL, 0x000000b0b400720bULL, 0x004fe20003fdd000ULL,
0x000001004bb47824ULL, 0x000fca00078e00ffULL, 0x00000018ffb47819ULL, 0x000fe200000114b4ULL,
0x0000007100717306ULL, 0x000eb0000020d400ULL, 0x0000005700577306ULL, 0x000f22000020d400ULL,
0x000000919200720bULL, 0x008fe20003f7d000ULL, 0x0000000f3434a231ULL, 0x002fc400003400ffULL,
0x0000000f3636a231ULL, 0x000fe400003400ffULL, 0x000000103535a231ULL, 0x080fe400003400ffULL,
0x0000006500657306ULL, 0x000e62000020d400ULL, 0x0000000171710812ULL, 0x004fe200078efcffULL,
0x000000103737a231ULL, 0x000fe200003400ffULL, 0x000000bbba00720bULL, 0x000fe40003f1d000ULL,
0x000000969700720bULL, 0x000fe40003f5d000ULL, 0x0000007b717b723eULL, 0x000fe200000010ffULL,
0x0000006900a47306ULL, 0x000fe20000209400ULL, 0x0000000157576812ULL, 0x010fc400078efcffULL,
0x000000a6a500720bULL, 0x000fca0003fdd000ULL, 0x0000006900a77306ULL, 0x000ea20000205400ULL,
0x0000000165653812ULL, 0x002fe400078efcffULL, 0x0000008e8d00720bULL, 0x000fe40003f7d000ULL,
0x0000000175750812ULL, 0x000fe400078efcffULL, 0x0000009a9b00720bULL, 0x000fe20003f1d000ULL,
0x00000048009c7306ULL, 0x000fe20000009400ULL, 0x0000000168686812ULL, 0x000fe400078efcffULL,
0x000000adac00720bULL, 0x000fc40003fdd000ULL, 0x0000000174742812ULL, 0x000fe400078efcffULL,
0x0000004f4e00720bULL, 0x000fe20003f5d000ULL, 0x00000048009d7306ULL, 0x000fe20000005400ULL,
0x000000a7a400720bULL, 0x004fe40003fbd000ULL, 0x000000016d6d3812ULL, 0x000fe400078efcffULL,
0x000000877e4e723eULL, 0x000fe400000010ffULL, 0x0000004c784f723eULL, 0x000fe200000010ffULL,
0x00000048005c7306ULL, 0x0003e2000000d400ULL, 0x0000000162620812ULL, 0x000fc400078efcffULL,
0x000000a99500720bULL, 0x000fe40003f1d000ULL, 0x0000000173736812ULL, 0x000fe400078efcffULL,
0x0000000172722812ULL, 0x000fe200078efcffULL, 0x0000004900837306ULL, 0x000fe20000009400ULL,
0x0001000048487824ULL, 0x002fca00078e00ffULL, 0x00000018ff487819ULL, 0x000fe40000011448ULL,
0x0000004900847306ULL, 0x000e620000005400ULL, 0x000000016c6c0812ULL, 0x000fce00078efcffULL,
0x00000049005a7306ULL, 0x0004f0000000d400ULL, 0x0000006900697306ULL, 0x000f22000020d400ULL,
0x0001000049497824ULL, 0x004fe200078e00ffULL, 0x000000848300720bULL, 0x002fc80003fdd000ULL,
0x00000018ff497819ULL, 0x000fe40000011449ULL, 0x00000063007f7306ULL, 0x000fee0000209400ULL,
0x000000015a5a6812ULL, 0x008fe200078efcffULL, 0x0000006300807306ULL, 0x000e620000205400ULL,
0x0000000169695812ULL, 0x010fc400078efcffULL, 0x0000009d9c00720bULL, 0x000fca0003fbd000ULL,
0x0000005d00797306ULL, 0x000ff00000209400ULL, 0x0000005d007a7306ULL, 0x000ea20000205400ULL,
0x000000807f00720bULL, 0x002fe40003f9d000ULL, 0x000000015c5c5812ULL, 0x000fca00078efcffULL,
0x0000004a00557306ULL, 0x000ff00000009400ULL, 0x0000004a00567306ULL, 0x000e620000005400ULL,
0x0000007a7900720bULL, 0x004fe40003f7d000ULL, 0x00000081577a723eULL, 0x000fca00000010ffULL,
0x0000004a00587306ULL, 0x0004e4000000d400ULL, 0x0000007a443c723cULL, 0x000fec000004183cULL,
0x0000004b006f7306ULL, 0x000fe20000009400ULL, 0x000000a2ab4a723eULL, 0x004fe400000010ffULL,
0x000000565500720bULL, 0x002fca0003f5d000ULL, 0x0000004b00707306ULL, 0x000e700000005400ULL,
0x0000004b00527306ULL, 0x000522000000d400ULL, 0x0000000158582812ULL, 0x008fce00078efcffULL,
0x0000004800af7306ULL, 0x000fe20000209400ULL, 0x000000a0aa4b723eULL, 0x004fe400000010ffULL,
0x000000706f00720bULL, 0x002fe40003f1d000ULL, 0x00000068766f723eULL, 0x000fc600000010ffULL,
0x0000004800b07306ULL, 0x000e620000205400ULL, 0x0000004a4428723cULL, 0x000b6e0000041828ULL,
0x0000004800ae7306ULL, 0x0004e2000020d400ULL, 0x00000090944a723eULL, 0x020fe400000010ffULL,
0x0000008f934b723eULL, 0x000fc400000010ffULL, 0x0000000152520812ULL, 0x010fc600078efcffULL,
0x0000004900a47306ULL, 0x000fe20000209400ULL, 0x000000a19948723eULL, 0x004fe200000010ffULL,
0x0000004a4420723cULL, 0x000be20000041820ULL, 0x000000b0af00720bULL, 0x002fca0003fbd000ULL,
0x0000004900a07306ULL, 0x000fe20000205400ULL, 0x00000085894a723eULL, 0x020fe200000010ffULL,
0x0000006e3428723cULL, 0x000fe20000041828ULL, 0x00000082864b723eULL, 0x000fca00000010ffULL,
0x00000049009a7306ULL, 0x0003e2000020d400ULL, 0x00000001aeae5812ULL, 0x008fce00078efcffULL,
0x0000006300637306ULL, 0x000ea2000020d400ULL, 0x0000009f9849723eULL, 0x002fce00000010ffULL,
0x0000005d005d7306ULL, 0x000e62000020d400ULL, 0x000000484424723cULL, 0x000b6e0000041824ULL,
0x0000008c8b48723eULL, 0x020fe200000010ffULL, 0x0000005900667306ULL, 0x000fe20000209400ULL,
0x0000008a8849723eULL, 0x000fc400000010ffULL, 0x0000000163634812ULL, 0x004fe400078efcffULL,
0x000000bdb600720bULL, 0x000fe40003f9d000ULL, 0x000000015d5d3812ULL, 0x002fe200078efcffULL,
0x0000005900677306ULL, 0x000e620000205400ULL, 0x00000048441c723cULL, 0x000fe2000004181cULL,
0x000000c0c200720bULL, 0x000fcc0003f7d000ULL, 0x0000005b006a7306ULL, 0x000fe20000209400ULL,
0x0000004a4448723cULL, 0x000be20000041818ULL, 0x000000019e9e4812ULL, 0x000fc800078efcffULL,
0x0000005c9e5c723eULL, 0x000fe400000010ffULL, 0x0000005b006b7306ULL, 0x000ea20000205400ULL,
0x000000774d18723eULL, 0x020fe400000010ffULL, 0x0000004e444c723cULL, 0x000b62000004182cULL,
0x000000547d19723eULL, 0x000fe400000010ffULL, 0x00000001b7b73812ULL, 0x000fe400078efcffULL,
0x000000b200917306ULL, 0x000fe20000209400ULL, 0x000000676600720bULL, 0x002fc40003fdd000ULL,
0x00000075692c723eULL, 0x020fe200000010ffULL, 0x000000184454723cULL, 0x000b620000041830ULL,
0x00000073652d723eULL, 0x000fe400000010ffULL, 0x000000a0a400720bULL, 0x000fe20003f7d000ULL,
0x000000b2008f7306ULL, 0x000e620000205400ULL, 0x0000006b6a00720bULL, 0x004fe40003f9d000ULL,
0x000000647430723eULL, 0x020fe200000010ffULL, 0x0000002c342c723cULL, 0x000f620000041824ULL,
0x000000626d31723eULL, 0x000fc400000010ffULL, 0x000000726318723eULL, 0x000fe200000010ffULL,
0x0000005900597306ULL, 0x000ea2000020d400ULL, 0x0000006c5d19723eULL, 0x000fe400000010ffULL,
0x0000005ab75d723eULL, 0x000fe200000010ffULL, 0x000000303430723cULL, 0x000b620000041820ULL,
0x000000019a9a3812ULL, 0x000fc600078efcffULL, 0x0000005b005b7306ULL, 0x000ee2000020d400ULL,
0x0000008f9100720bULL, 0x002fce0003fbd000ULL, 0x000000b200b27306ULL, 0x000e62000020d400ULL,
0x0000000159596812ULL, 0x004fc800078efcffULL, 0x0000009a5921723eULL, 0x020fc600000010ffULL,
0x000000b400827306ULL, 0x000fe20000209400ULL, 0x000000015b5b4812ULL, 0x008fc800078efcffULL,
0x000000ae5b20723eULL, 0x000fc600000010ffULL, 0x000000b4001a7306ULL, 0x000ea20000205400ULL,
0x00000001b2b25812ULL, 0x002fc600078efcffULL, 0x000000203420723cULL, 0x000b68000004184cULL,
0x0000005300617306ULL, 0x000ff00000209400ULL, 0x0000005300607306ULL, 0x000e620000205400ULL,
0x0000001a8200720bULL, 0x004fc40003fdd000ULL, 0x000000183418723cULL, 0x040b6a000004181cULL,
0x00000041005e7306ULL, 0x000fe60000209400ULL, 0x0000005c341c723cULL, 0x000b6a0000041848ULL,
0x00000041005f7306ULL, 0x000ea20000205400ULL, 0x000000606100720bULL, 0x002fce0003f9d000ULL,
0x000000b300707306ULL, 0x000ff00000209400ULL, 0x000000b300447306ULL, 0x000e620000205400ULL,
0x0000005f5e00720bULL, 0x004fce0003f7d000ULL, 0x000000b100457306ULL, 0x000ff00000209400ULL,
0x000000b100247306ULL, 0x000ea20000205400ULL, 0x000000447000720bULL, 0x002fce0003fbd000ULL,
0x000000b400b47306ULL, 0x000e70000020d400ULL, 0x0000005300537306ULL, 0x000ee2000020d400ULL,
0x000000244500720bULL, 0x004fe40003f5d000ULL, 0x00000058b224723eULL, 0x000fca00000010ffULL,
0x0000004100417306ULL, 0x000ea2000020d400ULL, 0x00000001b4b46812ULL, 0x002fc800078efcffULL,
0x00000052b425723eULL, 0x000fc600000010ffULL, 0x000000b300b37306ULL, 0x000e62000020d400ULL,
0x0000000153534812ULL, 0x008fc600078efcffULL, 0x000000243424723cULL, 0x000b680000041854ULL,
0x000000b100b17306ULL, 0x000ee2000020d400ULL, 0x0000000141413812ULL, 0x004fe400078efcffULL,
0x00000001b3b35812ULL, 0x002fc800078efcffULL, 0x000000b35344723eULL, 0x000fe400000010ffULL,
0x00000001b1b12812ULL, 0x008fc800078efcffULL, 0x000000b14145723eULL, 0x000fce00000010ffULL,
0x000000443434723cULL, 0x000b62000004183cULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0186b800ff3c7f8cULL, 0x020e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000504007c0cULL, 0x000fe2000bf03070ULL,
0x01869800ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff447224ULL, 0x002fe200078e003dULL,
0x000000030b417810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff487224ULL, 0x000fd200078e0042ULL,
0x000060f000000947ULL, 0x000fea0003800000ULL, 0x00000000003c7805ULL, 0x000fc40000015200ULL,
0x0186bc00ff087984ULL, 0x000e640000000800ULL, 0x8000000008ff7812ULL, 0x002fe40007804844ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff417224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104100780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003e7805ULL, 0x000fcc0000015200ULL, 0x0000003e3c3e7210ULL, 0x000fca0007f1e1ffULL,
0x000000013f3f7824ULL, 0x000fe200000e0e3dULL, 0x003d09003e00780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403e00780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff087819ULL, 0x000fc8000001143fULL,
0x0000003e08087211ULL, 0x000fca00078110ffULL, 0x000000ffff3e7224ULL, 0x000fca00000e063fULL,
0x0000000208087819ULL, 0x000fc8000000123eULL, 0x000000080000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000141417810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0186bc00ff087984ULL, 0x000e640000000800ULL,
0x8000000008ff7812ULL, 0x002fe40007804844ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000046000009947ULL, 0x000fea0003800000ULL, 0x00000002113f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000107087824ULL, 0x000fe200078e0211ULL, 0x0000000411447810ULL, 0x040fe20007ffe0ffULL,
0x000000e004057891ULL, 0x000fe2000f8e403fULL, 0x00000006114d7810ULL, 0x000fe20007ffe0ffULL,
0x00000001073d7824ULL, 0x000fe200078e023fULL, 0x000000f00c497812ULL, 0x000fe200078ec0ffULL,
0x00000001083c7824ULL, 0x000fc400078e0202ULL, 0x00000010084a7824ULL, 0x000fe400078e00ffULL,
0x000000013d3e7824ULL, 0x040fe400078e0202ULL, 0x000000103d4b7824ULL, 0x000fe200078e00ffULL,
0xfffffff04a4a7812ULL, 0x000fe200078ee23cULL, 0x0000000107417824ULL, 0x000fe200078e0244ULL,
0x00000020033c7811ULL, 0x000fe400078e30ffULL, 0xfffffff04b4b7812ULL, 0x000fe200078ee23eULL,
0x00000001413e7824ULL, 0x040fe200078e0202ULL, 0x000160004a4a7811ULL, 0x000fe200078e20ffULL,
0x00000010414c7824ULL, 0x000fe200078e00ffULL, 0x000160004b4b7811ULL, 0x000fe200078e20ffULL,
0x0000000108487824ULL, 0x100fe200078e023cULL, 0x0000000504087c17ULL, 0x000fe2000f800000ULL,
0x000000013d477824ULL, 0x000fe200078e023cULL, 0xfffffff04c4c7812ULL, 0x000fe200078ee23eULL,
0x00000001073e7824ULL, 0x000fe200078e024dULL, 0x8000000508087c10ULL, 0x000fe2000fffe0ffULL,
0x0000000141417824ULL, 0x100fe200078e023cULL, 0x0000005147477210ULL, 0x080fe20007f3e0ffULL,
0x000000013e3c7824ULL, 0x040fe200078e023cULL, 0x0000000807087217ULL, 0x000fe20007800000ULL,
0x000000013e3d7824ULL, 0x000fe200078e0202ULL, 0x0000005148487210ULL, 0x080fe20007f1e0ffULL,
0x000000103e4e7824ULL, 0x000fe200078e00ffULL, 0x0000005141417210ULL, 0x080fe20007f9e0ffULL,
0x0000000108087824ULL, 0x000fe200078e0a07ULL, 0x000000513c517210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff3c7224ULL, 0x000fe200008e06ffULL, 0x00005e0047467a11ULL, 0x000fe200078440ffULL,
0x000000ffff3e7224ULL, 0x000fe200000e06ffULL, 0xfffffff04e4e7812ULL, 0x000fe200078ee23dULL,
0x000000ffff457224ULL, 0x000fe200020e06ffULL, 0x00005e00483d7a11ULL, 0x000fc400078040ffULL,
0x00005f0047477a11ULL, 0x000fe400010f443cULL, 0x000000081100720cULL, 0x080fe40003f46070ULL,
0x00005f0048487a11ULL, 0x000fe200000f443eULL, 0x000000ffff3e7224ULL, 0x000fe200018e06ffULL,
0x000000493d3c7210ULL, 0x000fe40007fbe0ffULL, 0x000000083f00720cULL, 0x080fe40003f26070ULL,
0x000000084400720cULL, 0x000fe20003f06070ULL, 0x000000ffff3d7224ULL, 0x000fe200028e0648ULL,
0x00005e00413f7a11ULL, 0x000fc400078840ffULL, 0x00005e0051447a11ULL, 0x000fe400078c40ffULL,
0x000000084d00720cULL, 0x000fe20003f66070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c4a7faeULL, 0x0003e2000d101c46ULL, 0x00005f0041417a11ULL, 0x000fe400020f4445ULL,
0x00005f0051087a11ULL, 0x000fe400030f443eULL, 0x000000493f3e7210ULL, 0x080fe40007f9e0ffULL,
0x0000004944447210ULL, 0x000fc40007fbe0ffULL, 0x000160004c4c7811ULL, 0x000fe200078e20ffULL,
0x000000ffff3f7224ULL, 0x000fe200020e0641ULL, 0x000160004e4e7811ULL, 0x000fe200078e20ffULL,
0x000000ffff457224ULL, 0x000fe200028e0608ULL, 0x00000049463c7210ULL, 0x002fca0007f5e0ffULL,
0x000000ffff3d7224ULL, 0x000fca00010e0647ULL, 0x000000003c4b7faeULL, 0x0003e8000c901c46ULL,
0x000000003e4c7faeULL, 0x0003e8000c101c46ULL, 0x00000000444e7faeULL, 0x0003e2000d901c46ULL,
0x0000039000007947ULL, 0x000fea0003800000ULL, 0x0000000107087824ULL, 0x000fe200078e0211ULL,
0x00000020033c7811ULL, 0x000fc400078e30ffULL, 0x000000f00c497812ULL, 0x000fe200078ec0ffULL,
0x00000001083d7824ULL, 0x040fe200078e0202ULL, 0x00000002083e7810ULL, 0x040fe20007ffe0ffULL,
0x00000010084a7824ULL, 0x040fe200078e00ffULL, 0x0000000608417810ULL, 0x000fc60007ffe0ffULL,
0x000000013e3f7824ULL, 0x000fe200078e0202ULL, 0xfffffff04a4a7812ULL, 0x000fe200078ee23dULL,
0x000000103e4b7824ULL, 0x000fe400078e00ffULL, 0x00000001083d7824ULL, 0x000fe200078e023cULL,
0x000160004a4a7811ULL, 0x000fe200078e20ffULL, 0x000000013c457824ULL, 0x040fe200078e023eULL,
0xfffffff04b4b7812ULL, 0x000fe200078ee23fULL, 0x000000013c447824ULL, 0x000fe200078e0241ULL,
0x00000004083f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000141477824ULL, 0x100fe200078e0202ULL,
0x000000513d3d7210ULL, 0x080fe20007f5e0ffULL, 0x00000010414d7824ULL, 0x000fe200078e00ffULL,
0x0000005145457210ULL, 0x080fe20007f1e0ffULL, 0x000000013c087824ULL, 0x000fe200078e023fULL,
0x00005e003d467a11ULL, 0x000fe200078640ffULL, 0x000000013f3e7824ULL, 0x000fe200078e0202ULL,
0xfffffff04d4d7812ULL, 0x000fe200078ee247ULL, 0x000000103f4c7824ULL, 0x000fe200078e00ffULL,
0x00000051083f7210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff3c7224ULL, 0x000fe200010e06ffULL,
0x0000005144087210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff477224ULL, 0x000fe200000e06ffULL,
0xfffffff04c4c7812ULL, 0x000fc400078ee23eULL, 0x00005f003d487a11ULL, 0x000fe200018f443cULL,
0x000000ffff3c7224ULL, 0x000fe200010e06ffULL, 0x00005e0045417a11ULL, 0x000fe200078040ffULL,
0x000000ffff3d7224ULL, 0x000fe200008e06ffULL, 0x00005e0008447a11ULL, 0x000fe400078440ffULL,
0x00005e003f3e7a11ULL, 0x000fe400078240ffULL, 0x0000004946467210ULL, 0x000fe40007f7e0ffULL,
0x00005f0045457a11ULL, 0x000fc400000f4447ULL, 0x00005f0008087a11ULL, 0x000fe200010f443cULL,
0x000000ffff477224ULL, 0x000fe200018e0648ULL, 0x00005f003f3f7a11ULL, 0x000fe400008f443dULL,
0x00000049413c7210ULL, 0x080fe40007f1e0ffULL, 0x000000493e3e7210ULL, 0x080fe20007f3e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000464a7faeULL, 0x0003e2000b901c46ULL,
0x0000004944447210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff3d7224ULL, 0x000fe200000e0645ULL,
0x000160004b4b7811ULL, 0x000fe200078e20ffULL, 0x000000ffff3f7224ULL, 0x000fe200008e063fULL,
0x000160004c4c7811ULL, 0x000fe200078e20ffULL, 0x000000ffff457224ULL, 0x000fe200010e0608ULL,
0x000160004d4d7811ULL, 0x000fe200078e20ffULL, 0x000000003c4b7faeULL, 0x0003e8000b901c46ULL,
0x000000003e4c7faeULL, 0x0003e8000b901c46ULL, 0x00000000444d7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x000000040b3c7810ULL, 0x002fc80007ffe0ffULL,
0x000000053c00720cULL, 0x000fe20003f06070ULL, 0xffffffffff087424ULL, 0x000fd800078e00ffULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000000010a3c7824ULL, 0x000fe400078e023cULL,
0x00000004ff3d7424ULL, 0x000fc800078e00ffULL, 0x000060003c3c7625ULL, 0x000fca00078e003dULL,
0x000000063c087981ULL, 0x000324000c1e1900ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0186b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0186b000ff4a7f8cULL, 0x000ea2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0186680007447f8cULL, 0x000664000c80043fULL, 0x00000000003c7805ULL, 0x002fc40000015200ULL,
0x01866c00073e7984ULL, 0x000e640000000800ULL, 0x800000003eff7812ULL, 0x002fe40007804845ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff467224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003e7805ULL, 0x000fcc0000015200ULL, 0x0000003e3c417210ULL, 0x000fca0007f1e1ffULL,
0x000000013f3f7824ULL, 0x000fe200000e0e3dULL, 0x003d09004100780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404100780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3e7819ULL, 0x000fc8000001143fULL,
0x000000413e3e7211ULL, 0x000fca00078110ffULL, 0x000000ffff3f7224ULL, 0x000fca00000e063fULL,
0x000000023e3e7819ULL, 0x000fc8000000123fULL, 0x0000003e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000146467810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01866c00073e7984ULL, 0x000e640000000800ULL,
0x800000003eff7812ULL, 0x002fe40007804845ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x018180000d3e7984ULL, 0x000e680000000800ULL, 0x018380000d3f7984ULL, 0x0006a20000000800ULL,
0x000000423e00720bULL, 0x002fe20003f1d000ULL, 0x0000e6427f007947ULL, 0x000fd8000b800000ULL,
0x0000000000417806ULL, 0x008fc800000e0100ULL, 0x0000ffff41ff7812ULL, 0x000fe2000780c0ffULL,
0x000004a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff447424ULL, 0x000fc400078e00ffULL,
0x000000ffff487224ULL, 0x000fd200078e0042ULL, 0x0000046000008947ULL, 0x000fea0003800000ULL,
0x000000030000780cULL, 0x000fe40003f05270ULL, 0x000000423e00720bULL, 0x000fe20003f34000ULL,
0x0000e6127f007947ULL, 0x000fd8000b800000ULL, 0x00000000003c7806ULL, 0x000fc400008e0100ULL,
0x000000423e3d8209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe80003800000ULL,
0x0185803d0d008388ULL, 0x0003e40000000800ULL, 0x000099103c0d7816ULL, 0x002fc800000000ffULL,
0x000000ff0d00720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x000000423e0d7209ULL, 0x000fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff3cff7812ULL, 0x000fc6000780c0ffULL, 0x000000420d0d7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b0d0d7820ULL, 0x000fc80000410000ULL, 0x0000000d00497308ULL, 0x000e640000000800ULL,
0x0000004909097220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff0d7819ULL, 0x000fe20000011602ULL, 0x0000e5627f007947ULL, 0x000fea000b800000ULL,
0x00001f0d490d7589ULL, 0x0002e400000e0000ULL, 0x0000000d28287220ULL, 0x088fe40000410000ULL,
0x0000000d29297220ULL, 0x080fe40000410000ULL, 0x0000000d2c2c7220ULL, 0x080fe40000410000ULL,
0x0000000d2d2d7220ULL, 0x000fc40000410000ULL, 0x0000000d30307220ULL, 0x080fe40000410000ULL,
0x0000000d31317220ULL, 0x080fe40000410000ULL, 0x0000000d18187220ULL, 0x080fe40000410000ULL,
0x0000000d19197220ULL, 0x080fe40000410000ULL, 0x0000000d1c1c7220ULL, 0x080fe40000410000ULL,
0x0000000d1d1d7220ULL, 0x000fc40000410000ULL, 0x0000000d20207220ULL, 0x080fe40000410000ULL,
0x0000000d21217220ULL, 0x080fe40000410000ULL, 0x0000000d24247220ULL, 0x080fe40000410000ULL,
0x0000000d25257220ULL, 0x080fe40000410000ULL, 0x0000000d34347220ULL, 0x080fe40000410000ULL,
0x0000000d35357220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff003cff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008020d7811ULL, 0x000fe200078ff0ffULL, 0x0000e4727f007947ULL, 0x000fea000b800000ULL,
0x00001f0d490d7589ULL, 0x00066400000e0000ULL, 0x0000000d2a2a7220ULL, 0x082fe40000410000ULL,
0x0000000d2b2b7220ULL, 0x080fe40000410000ULL, 0x0000000d2e2e7220ULL, 0x080fe40000410000ULL,
0x0000000d2f2f7220ULL, 0x080fe40000410000ULL, 0x0000000d32327220ULL, 0x080fe40000410000ULL,
0x0000000d33337220ULL, 0x000fc40000410000ULL, 0x0000000d1a1a7220ULL, 0x080fe40000410000ULL,
0x0000000d1b1b7220ULL, 0x080fe40000410000ULL, 0x0000000d1e1e7220ULL, 0x080fe40000410000ULL,
0x0000000d1f1f7220ULL, 0x080fe40000410000ULL, 0x0000000d22227220ULL, 0x080fe40000410000ULL,
0x0000000d23237220ULL, 0x000fc40000410000ULL, 0x0000000d26267220ULL, 0x080fe40000410000ULL,
0x0000000d27277220ULL, 0x080fe40000410000ULL, 0x0000000d36367220ULL, 0x080fe40000410000ULL,
0x0000000d37377220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000ffff3cff7812ULL, 0x000fe20007800841ULL, 0x00000001ff447424ULL, 0x000fe200078e00ffULL,
0x000000423e427209ULL, 0x000fca0007810000ULL, 0x000000ffff487224ULL, 0x000fcc00078e0042ULL,
0x800000423e3e0221ULL, 0x000fe20000010000ULL, 0x00007610ff440816ULL, 0x000fe20000000044ULL,
0x000000ffff480224ULL, 0x000fe400078e0042ULL, 0x3fb8aa3b3e3e0820ULL, 0x000fc80000410000ULL,
0x0000003e000e0308ULL, 0x000e640000000800ULL, 0x0000000e3f3f0220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000093f097221ULL, 0x004fc40000010000ULL,
0x00000000003c7805ULL, 0x000fca0000015200ULL, 0x0186ac00ff0d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe40007804838ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff417224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104100780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003e7805ULL, 0x000fcc0000015200ULL,
0x0000003e3c3e7210ULL, 0x000fca0007f1e1ffULL, 0x000000013f3f7824ULL, 0x000fe200000e0e3dULL,
0x003d09003e00780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403e00780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0d7819ULL, 0x000fc8000001143fULL, 0x0000003e0d0d7211ULL, 0x000fca00078110ffULL,
0x000000ffff3e7224ULL, 0x000fca00000e063fULL, 0x000000020d0d7819ULL, 0x000fc8000000123eULL,
0x0000000d0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000141417810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0186ac00ff0d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fe40007804838ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009910440d7816ULL, 0x000fe200000000ffULL,
0x0000019000007945ULL, 0x000fe60003800000ULL, 0x000000ff0d00720cULL, 0x000fda0003f25270ULL,
0x0000016000001947ULL, 0x000fea0003800000ULL, 0x0000000eff0d723eULL, 0x000fe400000010ffULL,
0x00000002ff387819ULL, 0x000fe40000011602ULL, 0x000054100d0d7816ULL, 0x000fe2000000000dULL,
0x0000e0527f007947ULL, 0x000fea000b800000ULL, 0x00001f380d0f7589ULL, 0x0002a400000e0000ULL,
0x0000000838107810ULL, 0x000fe20007ffe0ffULL, 0x0000e0a27f007947ULL, 0x000fea000b800000ULL,
0x00001f100d107589ULL, 0x0002e400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001038477810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff497224ULL, 0x008fe200078e000dULL,
0x00014e2000447802ULL, 0x000fe20000000f00ULL, 0x0000001fff457424ULL, 0x000fe400078e00ffULL,
0xffffffffff467424ULL, 0x000fc400078e00ffULL, 0x0000e77000007944ULL, 0x016fea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001838477810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff497224ULL, 0x008fe200078e000dULL, 0x00014e9000447802ULL, 0x000fe20000000f00ULL,
0x0000001fff457424ULL, 0x000fc400078e00ffULL, 0xffffffffff467424ULL, 0x004fc400078e00ffULL,
0x0000e70000007944ULL, 0x012fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000000123c783bULL, 0x000e620000004200ULL,
0x0001380016167811ULL, 0x000fe400078e20ffULL, 0x0001380017177811ULL, 0x000fe200078e20ffULL,
0x00000000134c783bULL, 0x000ee80000004200ULL, 0x000000001444783bULL, 0x004ea80000004200ULL,
0x000000001554783bULL, 0x000ea20000004200ULL, 0x000001003c667824ULL, 0x002fe200078e00ffULL,
0x00000018ff127819ULL, 0x000fe2000001143cULL, 0x000001003f6b7824ULL, 0x000fe200078e00ffULL,
0x0000003c008b7306ULL, 0x000fe20000009400ULL, 0x00000018ff7c7819ULL, 0x008fc4000001144dULL,
0x00000018ff667819ULL, 0x000fe40000011466ULL, 0x00000018ff6b7819ULL, 0x000fe4000001146bULL,
0x00000018ff137819ULL, 0x000fe2000001143dULL, 0x0000001200c57306ULL, 0x000fe20000209400ULL,
0x00000018ff8c7819ULL, 0x000fe4000001143fULL, 0x00000018ff8d7819ULL, 0x000fe4000001143eULL,
0x00000018ff607819ULL, 0x004fc40000011445ULL, 0x00000018ff717819ULL, 0x000fe2000001144fULL,
0x0000001200c47306ULL, 0x000e620000205400ULL, 0x00000018ff6f7819ULL, 0x000fe4000001144eULL,
0x00000018ff797819ULL, 0x000fe4000001144cULL, 0x00000018ff637819ULL, 0x000fe40000011444ULL,
0x00000018ff5c7819ULL, 0x000fe20000011446ULL, 0x0000003c00907306ULL, 0x000ea20000005400ULL,
0x00000018ff527819ULL, 0x000fc40000011454ULL, 0x00000018ff587819ULL, 0x000fe40000011447ULL,
0x00000018ff497819ULL, 0x000fe40000011455ULL, 0x00000018ff417819ULL, 0x000fe20000011456ULL,
0x0000006600c77306ULL, 0x000fe20000209400ULL, 0x000000c4c500720bULL, 0x002fe40003f7d000ULL,
0x00000018ff0d7819ULL, 0x000fca0000011457ULL, 0x0000006600c87306ULL, 0x000e620000205400ULL,
0x000000908b00720bULL, 0x004fce0003fdd000ULL, 0x0000006600a67306ULL, 0x0004f0000020d400ULL,
0x0000006b00d07306ULL, 0x000fe20000209400ULL, 0x000001003d667824ULL, 0x004fe200078e00ffULL,
0x000000c8c700720bULL, 0x002fc80003f1d000ULL, 0x00000018ff667819ULL, 0x000fe40000011466ULL,
0x0000006b00cf7306ULL, 0x000fee0000205400ULL, 0x00000001a6a60812ULL, 0x008fe200078efcffULL,
0x0000006b00967306ULL, 0x0003f0000020d400ULL, 0x0000003c009f7306ULL, 0x0004e2000000d400ULL,
0x000001004d6b7824ULL, 0x002fca00078e00ffULL, 0x00000018ff6b7819ULL, 0x000fe4000001146bULL,
0x0000004d00bc7306ULL, 0x000fe20000009400ULL, 0x000100003c3c7824ULL, 0x004fca00078e00ffULL,
0x00000018ff9e7819ULL, 0x000fe4000001143cULL, 0x0000004d00ba7306ULL, 0x000fe20000005400ULL,
0x000000019f9f6812ULL, 0x008fce00078efcffULL, 0x0000004d00837306ULL, 0x0003f0000000d400ULL,
0x0000003d007f7306ULL, 0x000fe20000009400ULL, 0x000100004d4d7824ULL, 0x002fca00078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x0000003d00c07306ULL, 0x000e700000005400ULL,
0x0000003d009d7306ULL, 0x0004f0000000d400ULL, 0x0000001200127306ULL, 0x000ee2000020d400ULL,
0x000100003d3d7824ULL, 0x004fe200078e00ffULL, 0x000000c07f00720bULL, 0x002fc80003f9d000ULL,
0x00000018ff9c7819ULL, 0x000fe4000001143dULL, 0x0000006600cb7306ULL, 0x000fee0000209400ULL,
0x000000019d9d4812ULL, 0x008fe200078efcffULL, 0x0000006600ca7306ULL, 0x000e620000205400ULL,
0x0000000112123812ULL, 0x000fce00078efcffULL, 0x0000006600a57306ULL, 0x0004f0000020d400ULL,
0x0000003e00bf7306ULL, 0x000fe20000009400ULL, 0x000001003e667824ULL, 0x004fe200078e00ffULL,
0x000000cacb00720bULL, 0x002fc80003fbd000ULL, 0x00000018ff667819ULL, 0x000fe40000011466ULL,
0x0000003e009b7306ULL, 0x000e6e0000005400ULL, 0x00000001a5a55812ULL, 0x008fe200078efcffULL,
0x0000009e003c7306ULL, 0x000fe20000209400ULL, 0x000000cfd000720bULL, 0x000fce0003fbd000ULL,
0x0000009e00c97306ULL, 0x000ea20000205400ULL, 0x0000009bbf00720bULL, 0x002fca0003f7d000ULL,
0x0000000196965812ULL, 0x000fe400078efcffULL, 0x0000004d00df7306ULL, 0x000ff00000209400ULL,
0x0000004d00e07306ULL, 0x000fe20000205400ULL, 0x000000c93c00720bULL, 0x004fe20003f5d000ULL,
0x00000100543c7824ULL, 0x000fca00078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x0000004d00857306ULL, 0x0003f0000020d400ULL, 0x0000009c003d7306ULL, 0x000fe20000209400ULL,
0x000001004f4d7824ULL, 0x002fca00078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x0000009c00cc7306ULL, 0x000e700000205400ULL, 0x0000003f00b07306ULL, 0x000ff00000009400ULL,
0x0000003f00937306ULL, 0x000ea20000005400ULL, 0x000000cc3d00720bULL, 0x002fe20003fdd000ULL,
0x00000100553d7824ULL, 0x000fcc00078e00ffULL, 0x0000003f00157306ULL, 0x0002f0000000d400ULL,
0x0000006600ce7306ULL, 0x000fe20000209400ULL, 0x000100003f3f7824ULL, 0x002fe200078e00ffULL,
0x00000093b000720bULL, 0x004fc80003f9d000ULL, 0x00000018ff917819ULL, 0x000fe4000001143fULL,
0x0000006600cd7306ULL, 0x000fee0000205400ULL, 0x0000000115154812ULL, 0x008fe200078efcffULL,
0x0000006600977306ULL, 0x0003e6000020d400ULL, 0x000000159615723eULL, 0x000fca00000010ffULL,
0x0000004d00d97306ULL, 0x000fe20000209400ULL, 0x000001004c667824ULL, 0x002fca00078e00ffULL,
0x00000018ff667819ULL, 0x000fe40000011466ULL, 0x0000004d00da7306ULL, 0x000ff00000205400ULL,
0x0000004d00817306ULL, 0x0003f0000020d400ULL, 0x0000003e00147306ULL, 0x0004e2000000d400ULL,
0x00000100444d7824ULL, 0x002fca00078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x0000001300c67306ULL, 0x000fe20000209400ULL, 0x000100003e3e7824ULL, 0x004fca00078e00ffULL,
0x00000018ff927819ULL, 0x000fe4000001143eULL, 0x0000001300c37306ULL, 0x000e620000205400ULL,
0x0000000114143812ULL, 0x008fce00078efcffULL, 0x0000009e009e7306ULL, 0x000eb0000020d400ULL,
0x00000091003f7306ULL, 0x000fe20000209400ULL, 0x000000c3c600720bULL, 0x002fce0003f1d000ULL,
0x0000009100d27306ULL, 0x000e620000205400ULL, 0x000000019e9e2812ULL, 0x004fe400078efcffULL,
0x000000cdce00720bULL, 0x000fe40003f5d000ULL, 0x0000009e1212723eULL, 0x000fc600000010ffULL,
0x0000009c009c7306ULL, 0x000eb0000020d400ULL, 0x0000008d00c17306ULL, 0x000fe20000209400ULL,
0x000000d23f00720bULL, 0x002fe40003f7d000ULL, 0x0000000197972812ULL, 0x000fc800078efcffULL,
0x000000149714723eULL, 0x000fe200000010ffULL, 0x0000008d00c27306ULL, 0x000e620000205400ULL,
0x000000019c9c6812ULL, 0x004fce00078efcffULL, 0x0000006600d37306ULL, 0x000ff00000209400ULL,
0x0000006600d47306ULL, 0x000ea20000205400ULL, 0x000000c2c100720bULL, 0x002fce0003fdd000ULL,
0x0000006600867306ULL, 0x0002f0000020d400ULL, 0x0000004d00e47306ULL, 0x000fe20000209400ULL,
0x000100004c667824ULL, 0x002fe200078e00ffULL, 0x000000d4d300720bULL, 0x004fc80003fbd000ULL,
0x00000018ff667819ULL, 0x000fe40000011466ULL, 0x0000004d00e37306ULL, 0x000fee0000205400ULL,
0x0000000186865812ULL, 0x008fe200078efcffULL, 0x0000004d00777306ULL, 0x0003f0000020d400ULL,
0x0000004500a87306ULL, 0x000fe20000009400ULL, 0x00000100454d7824ULL, 0x002fca00078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x0000004500a97306ULL, 0x000ff00000005400ULL,
0x0000004500697306ULL, 0x0003f0000000d400ULL, 0x0000001300137306ULL, 0x000ea2000020d400ULL,
0x0001000045457824ULL, 0x002fca00078e00ffULL, 0x00000018ff457819ULL, 0x000fe40000011445ULL,
0x00000092003e7306ULL, 0x000ff00000209400ULL, 0x0000009200d17306ULL, 0x000e620000205400ULL,
0x0000000113130812ULL, 0x004fc800078efcffULL, 0x0000009c1313723eULL, 0x000fc600000010ffULL,
0x0000009100917306ULL, 0x000eb0000020d400ULL, 0x0000004c00b77306ULL, 0x000fe20000009400ULL,
0x000000d13e00720bULL, 0x002fce0003f1d000ULL, 0x0000004c00b87306ULL, 0x000e620000005400ULL,
0x0000000191913812ULL, 0x004fce00078efcffULL, 0x0000004e00b67306ULL, 0x000ff00000009400ULL,
0x0000004e00b57306ULL, 0x000ea20000005400ULL, 0x000000b8b700720bULL, 0x002fce0003f9d000ULL,
0x0000008c00be7306ULL, 0x000ff00000209400ULL, 0x0000008c00bd7306ULL, 0x000e620000205400ULL,
0x000000b5b600720bULL, 0x004fce0003f7d000ULL, 0x0000004f00b37306ULL, 0x000ff00000009400ULL,
0x0000004f00b47306ULL, 0x000ea20000005400ULL, 0x000000bdbe00720bULL, 0x002fce0003f5d000ULL,
0x0000004f00757306ULL, 0x0002f0000000d400ULL, 0x0000006600db7306ULL, 0x000fe20000209400ULL,
0x000100004f4f7824ULL, 0x002fe200078e00ffULL, 0x000000b4b300720bULL, 0x004fe20003fbd000ULL,
0x0000010057b47824ULL, 0x000fc600078e00ffULL, 0x00000018ff4f7819ULL, 0x000fe4000001144fULL,
0x0000006600dc7306ULL, 0x000fe20000205400ULL, 0x00000018ffb47819ULL, 0x000fcc00000114b4ULL,
0x0000000175755812ULL, 0x008fe200078efcffULL, 0x0000006600847306ULL, 0x0003e2000020d400ULL,
0x000000a9a800720bULL, 0x000fce0003fbd000ULL, 0x0000004e00767306ULL, 0x0004e2000000d400ULL,
0x000001004e667824ULL, 0x002fca00078e00ffULL, 0x00000018ff667819ULL, 0x000fe40000011466ULL,
0x0000008d008d7306ULL, 0x000e62000020d400ULL, 0x000100004e4e7824ULL, 0x004fe200078e00ffULL,
0x0000000169695812ULL, 0x000fc800078efcffULL, 0x00000018ff4e7819ULL, 0x000fe4000001144eULL,
0x0000004d00e57306ULL, 0x000fe20000209400ULL, 0x0000000176763812ULL, 0x008fce00078efcffULL,
0x0000004d00e67306ULL, 0x000fe20000205400ULL, 0x000000018d8d6812ULL, 0x002fe400078efcffULL,
0x000000babc00720bULL, 0x000fca0003fdd000ULL, 0x0000004d00787306ULL, 0x0003f0000020d400ULL,
0x0000004500ae7306ULL, 0x000fe20000209400ULL, 0x00000100464d7824ULL, 0x002fe200078e00ffULL,
0x0000000183836812ULL, 0x000fc400078efcffULL, 0x000000e0df00720bULL, 0x000fe40003fdd000ULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x0000004500af7306ULL, 0x000ff00000205400ULL,
0x00000045006c7306ULL, 0x0003e2000020d400ULL, 0x0000000185856812ULL, 0x000fce00078efcffULL,
0x0000004f00e27306ULL, 0x000fe20000209400ULL, 0x0000010047457824ULL, 0x002fca00078e00ffULL,
0x00000018ff457819ULL, 0x000fe40000011445ULL, 0x0000004f00e17306ULL, 0x000ff00000205400ULL,
0x0000004f007e7306ULL, 0x000ff0000020d400ULL, 0x0000004c00827306ULL, 0x000e70000000d400ULL,
0x0000008c008c7306ULL, 0x000eb0000020d400ULL, 0x0000006600d67306ULL, 0x000fe20000209400ULL,
0x0000000182824812ULL, 0x002fc800078efcffULL, 0x000000828682723eULL, 0x000fc600000010ffULL,
0x0000006600d57306ULL, 0x000e620000205400ULL, 0x000000018c8c2812ULL, 0x004fe400078efcffULL,
0x000000dcdb00720bULL, 0x000fca0003f5d000ULL, 0x0000006600807306ULL, 0x000eb0000020d400ULL,
0x0000004e00de7306ULL, 0x000fe20000209400ULL, 0x0000000184842812ULL, 0x000fe400078efcffULL,
0x000000d5d600720bULL, 0x002fca0003f5d000ULL, 0x0000004e00dd7306ULL, 0x000e700000205400ULL,
0x0000004e007d7306ULL, 0x000ee2000020d400ULL, 0x0000000180802812ULL, 0x004fe400078efcffULL,
0x000000e1e200720bULL, 0x000fc40003f5d000ULL, 0x000000768080723eULL, 0x000fc600000010ffULL,
0x0000004d004f7306ULL, 0x000fe20000209400ULL, 0x000000ddde00720bULL, 0x002fce0003fdd000ULL,
0x0000004d00987306ULL, 0x000e620000205400ULL, 0x000000017e7e2812ULL, 0x000fca00078efcffULL,
0x000000017d7d6812ULL, 0x008fe400078efcffULL, 0x0000004d006d7306ULL, 0x000eb0000020d400ULL,
0x0000007900bb7306ULL, 0x000fe20000209400ULL, 0x000000984f00720bULL, 0x002fce0003fbd000ULL,
0x0000007900b97306ULL, 0x000e6c0000205400ULL, 0x000000016d6d5812ULL, 0x004fe400078efcffULL,
0x0000007100ac7306ULL, 0x000ff00000209400ULL, 0x0000007100ad7306ULL, 0x000ea20000205400ULL,
0x000000b9bb00720bULL, 0x002fce0003f9d000ULL, 0x00000045004d7306ULL, 0x000ff00000209400ULL,
0x00000045004e7306ULL, 0x000fe20000205400ULL, 0x000000adac00720bULL, 0x004fce0003f7d000ULL,
0x0000004500667306ULL, 0x0003f0000020d400ULL, 0x0000003c009b7306ULL, 0x000fe20000209400ULL,
0x00000018ff457819ULL, 0x002fce000001143dULL, 0x0000003c00b07306ULL, 0x000ff00000205400ULL,
0x0000003c00937306ULL, 0x0003f0000020d400ULL, 0x0000004400aa7306ULL, 0x000fe20000009400ULL,
0x00000000163c783bULL, 0x0022ae0000000200ULL, 0x0000004400ab7306ULL, 0x000fe20000005400ULL,
0x0001000054167824ULL, 0x002fce00078e00ffULL, 0x00000044006a7306ULL, 0x0003f0000000d400ULL,
0x0000009200927306ULL, 0x000ee2000020d400ULL, 0x0001000044447824ULL, 0x002fca00078e00ffULL,
0x00000018ff727819ULL, 0x000fe40000011444ULL, 0x0000006b00d87306ULL, 0x000ff00000209400ULL,
0x0000006b00d77306ULL, 0x000e620000205400ULL, 0x0000000192920812ULL, 0x008fe200078efcffULL,
0x0000000f3c3c9231ULL, 0x004fc400003400ffULL, 0x0000000f3e3e9231ULL, 0x000fe400003400ffULL,
0x000000103d3d9231ULL, 0x080fe400003400ffULL, 0x0000007900797306ULL, 0x000ea2000020d400ULL,
0x000000103f3f9231ULL, 0x000fce00003400ffULL, 0x0000007100717306ULL, 0x000ee2000020d400ULL,
0x000000d7d800720bULL, 0x002fe20003f1d000ULL, 0x000000123c2c723cULL, 0x040b6c000004182cULL,
0x0000007200e77306ULL, 0x000fe20000209400ULL, 0x0000000179794812ULL, 0x004fe200078efcffULL,
0x000000143c30723cULL, 0x000f620000041830ULL, 0x000000dad900720bULL, 0x000fc40003f9d000ULL,
0x000000918c13723eULL, 0x020fe400000010ffULL, 0x000000928d12723eULL, 0x000fe200000010ffULL,
0x0000007200447306ULL, 0x000e620000205400ULL, 0x0000000171713812ULL, 0x008fe400078efcffULL,
0x000000847984723eULL, 0x000fe400000010ffULL, 0x0000007e7171723eULL, 0x000fc600000010ffULL,
0x0000006b004c7306ULL, 0x000ea2000020d400ULL, 0x0000000181814812ULL, 0x000fe400078efcffULL,
0x000000abaa00720bULL, 0x000fe40003f9d000ULL, 0x000000758181723eULL, 0x000fc600000010ffULL,
0x0000007c00b17306ULL, 0x000fe20000209400ULL, 0x00000044e700720bULL, 0x002fe40003f7d000ULL,
0x0000009fa644723eULL, 0x000fe200000010ffULL, 0x000000803c24723cULL, 0x000fe80000041824ULL,
0x0000007c00b27306ULL, 0x000e620000205400ULL, 0x000000014c4c0812ULL, 0x004fe400078efcffULL,
0x000000016a6a4812ULL, 0x000fc400078efcffULL, 0x000000e6e500720bULL, 0x000fe40003f9d000ULL,
0x000000834c83723eULL, 0x000fe200000010ffULL, 0x0000007200727306ULL, 0x000eac000020d400ULL,
0x000000823c1c723cULL, 0x000fe4000004181cULL, 0x0000006000957306ULL, 0x000fe20000209400ULL,
0x000000b2b100720bULL, 0x002fe20003f1d000ULL, 0x0000010056b17824ULL, 0x000fe200078e00ffULL,
0x0000000178784812ULL, 0x000fe200078efcffULL, 0x0001000056b27824ULL, 0x000fc600078e00ffULL,
0x00000018ffb17819ULL, 0x000fe200000114b1ULL, 0x0000006000947306ULL, 0x000e620000205400ULL,
0x0000000172723812ULL, 0x004fe400078efcffULL, 0x00000018ffb27819ULL, 0x000fca00000114b2ULL,
0x0000004600a27306ULL, 0x000ff00000009400ULL, 0x0000004600a37306ULL, 0x000ea20000005400ULL,
0x000000949500720bULL, 0x002fce0003f7d000ULL, 0x00000046005f7306ULL, 0x0002f0000000d400ULL,
0x00000054008f7306ULL, 0x000fe20000009400ULL, 0x0001000046467824ULL, 0x002fe200078e00ffULL,
0x000000a3a200720bULL, 0x004fc80003fdd000ULL, 0x00000018ff467819ULL, 0x000fe40000011446ULL,
0x00000054008e7306ULL, 0x000e6e0000005400ULL, 0x000000015f5f6812ULL, 0x008fe200078efcffULL,
0x0000005400537306ULL, 0x000eb0000000d400ULL, 0x0000004500b77306ULL, 0x000fe20000209400ULL,
0x0000008e8f00720bULL, 0x002fce0003f9d000ULL, 0x0000004500b37306ULL, 0x000fec0000205400ULL,
0x0000000153534812ULL, 0x004fe400078efcffULL, 0x0000004500547306ULL, 0x0003f0000020d400ULL,
0x00000047009a7306ULL, 0x000fe20000009400ULL, 0x00000018ff457819ULL, 0x002fce0000011416ULL,
0x0000004700997306ULL, 0x000ff00000005400ULL, 0x00000047005b7306ULL, 0x0003f0000000d400ULL,
0x0000004600897306ULL, 0x000fe20000209400ULL, 0x0001000047477824ULL, 0x002fca00078e00ffULL,
0x00000018ff477819ULL, 0x000fe40000011447ULL, 0x00000046008a7306ULL, 0x000e700000205400ULL,
0x00000046006b7306ULL, 0x0004f0000020d400ULL, 0x0000005500887306ULL, 0x000fe20000009400ULL,
0x0001000055467824ULL, 0x004fe200078e00ffULL, 0x0000008a8900720bULL, 0x002fc80003fdd000ULL,
0x00000018ffa27819ULL, 0x000fe40000011446ULL, 0x0000005500877306ULL, 0x000fee0000005400ULL,
0x000000016b6b6812ULL, 0x008fe200078efcffULL, 0x0000005500517306ULL, 0x000ff0000000d400ULL,
0x0000005600707306ULL, 0x000ff00000009400ULL, 0x00000056006e7306ULL, 0x000e700000005400ULL,
0x0000005600427306ULL, 0x000eb0000000d400ULL, 0x0000007c007c7306ULL, 0x000ee2000020d400ULL,
0x0000006e7000720bULL, 0x002fce0003fdd000ULL, 0x0000006000607306ULL, 0x000e6c000020d400ULL,
0x0000000142426812ULL, 0x004fe400078efcffULL, 0x0000004500167306ULL, 0x000fe20000209400ULL,
0x000000017c7c0812ULL, 0x008fc800078efcffULL, 0x000000857c85723eULL, 0x000fc600000010ffULL,
0x0000004500567306ULL, 0x000ea20000205400ULL, 0x0000000160603812ULL, 0x002fe400078efcffULL,
0x0000004e4d00720bULL, 0x000fe20003f7d000ULL, 0x000000843c20723cULL, 0x040fe80000041820ULL,
0x0000004500557306ULL, 0x0002e8000020d400ULL, 0x000000123c4c723cULL, 0x000be80000041818ULL,
0x0000006f00a77306ULL, 0x000fe20000209400ULL, 0x0000009da545723eULL, 0x002fc400000010ffULL,
0x0000000166663812ULL, 0x000fe400078efcffULL, 0x000000561600720bULL, 0x004fe40003f9d000ULL,
0x0000005f6d12723eULL, 0x020fe200000010ffULL, 0x0000006f00a47306ULL, 0x000e620000205400ULL,
0x000000697819723eULL, 0x000fce00000010ffULL, 0x0000006300a07306ULL, 0x000fe40000209400ULL,
0x0000000155554812ULL, 0x008fcc00078efcffULL, 0x0000006300a17306ULL, 0x000ea20000205400ULL,
0x000000a4a700720bULL, 0x002fce0003f1d000ULL, 0x00000047008b7306ULL, 0x000ff00000209400ULL,
0x0000004700907306ULL, 0x000fe20000205400ULL, 0x000000a1a000720bULL, 0x004fce0003f5d000ULL,
0x00000047007f7306ULL, 0x0003f0000020d400ULL, 0x0000006f006f7306ULL, 0x000ea2000020d400ULL,
0x000000443c44723cULL, 0x002b640000041828ULL, 0x000000001728783bULL, 0x020e6a0000000200ULL,
0x0000006300637306ULL, 0x000ef0000020d400ULL, 0x0000005c007b7306ULL, 0x000fe20000209400ULL,
0x000000016f6f0812ULL, 0x004fc400078efcffULL, 0x000000e3e400720bULL, 0x000fe40003f1d000ULL,
0x0000007d6f70723eULL, 0x000fc600000010ffULL, 0x0000005c007a7306ULL, 0x000ea20000205400ULL,
0x0000000163632812ULL, 0x008fe400078efcffULL, 0x000000afae00720bULL, 0x000fe20003f5d000ULL,
0x000000703c34723cULL, 0x000f620000041834ULL, 0x000000726314723eULL, 0x000fc600000010ffULL,
0x0000005800737306ULL, 0x000fe20000209400ULL, 0x0000000177770812ULL, 0x000fe400078efcffULL,
0x000000999a00720bULL, 0x000fe40003f1d000ULL, 0x0000006a7718723eULL, 0x000fc600000010ffULL,
0x0000005800747306ULL, 0x000ee20000205400ULL, 0x0000007a7b00720bULL, 0x004fe40003fbd000ULL,
0x000000016c6c2812ULL, 0x000fe200078efcffULL, 0x0000000f28289231ULL, 0x082fe200003400ffULL,
0x000000878800720bULL, 0x000fe20003f5d000ULL, 0x0000000f2a2a9231ULL, 0x000fe200003400ffULL,
0x0000006c6015723eULL, 0x000fe200000010ffULL, 0x0000005c005c7306ULL, 0x000e62000020d400ULL,
0x0000001029299231ULL, 0x080fe200003400ffULL, 0x000000015b5b0812ULL, 0x000fe200078efcffULL,
0x000000102b2b9231ULL, 0x000fe200003400ffULL, 0x000000908b00720bULL, 0x000fc40003f1d000ULL,
0x0000005b6613723eULL, 0x000fe400000010ffULL, 0x0000005800587306ULL, 0x000ea2000020d400ULL,
0x000000747300720bULL, 0x008fe20003f7d000ULL, 0x000000142814723cULL, 0x000f62000004182cULL,
0x0000000151512812ULL, 0x000fca00078efcffULL, 0x0000005200647306ULL, 0x000fe20000209400ULL,
0x000000015c5c5812ULL, 0x002fe200078efcffULL, 0x000000122830723cULL, 0x040b620000041830ULL,
0x000000b09b00720bULL, 0x000fe40003fbd000ULL, 0x000000017f7f0812ULL, 0x000fe400078efcffULL,
0x0000006b5c5c723eULL, 0x000fe200000010ffULL, 0x0000005200657306ULL, 0x000e620000205400ULL,
0x0000000158583812ULL, 0x004fe200078efcffULL, 0x000000182818723cULL, 0x000f620000041844ULL,
0x000000b3b700720bULL, 0x000fca0003f7d000ULL, 0x0000004900617306ULL, 0x000fe20000209400ULL,
0x0000000193935812ULL, 0x000fc800078efcffULL, 0x000000539312723eULL, 0x020fc600000010ffULL,
0x0000004900627306ULL, 0x000ea20000205400ULL, 0x0000000154543812ULL, 0x000fe400078efcffULL,
0x000000656400720bULL, 0x002fe40003fbd000ULL, 0x000000515413723eULL, 0x000fc600000010ffULL,
0x000000a200a07306ULL, 0x000fe80000209400ULL, 0x00000012281c723cULL, 0x000b68000004181cULL,
0x000000a2009d7306ULL, 0x000e620000205400ULL, 0x000000626100720bULL, 0x004fce0003f5d000ULL,
0x000000b100947306ULL, 0x000ff00000209400ULL, 0x000000b1008c7306ULL, 0x000ea20000205400ULL,
0x0000009da000720bULL, 0x002fce0003f7d000ULL, 0x0000005700687306ULL, 0x000ff00000009400ULL,
0x0000005700677306ULL, 0x000e620000005400ULL, 0x0000008c9400720bULL, 0x004fce0003f9d000ULL,
0x0000005700387306ULL, 0x0004f0000000d400ULL, 0x0000005200527306ULL, 0x000ee2000020d400ULL,
0x0001000057577824ULL, 0x004fe200078e00ffULL, 0x000000676800720bULL, 0x002fc80003f1d000ULL,
0x00000018ff577819ULL, 0x000fe40000011457ULL, 0x0000004900497306ULL, 0x000e6e000020d400ULL,
0x0000000138380812ULL, 0x008fe200078efcffULL, 0x000000a200a27306ULL, 0x000ea2000020d400ULL,
0x0000000152525812ULL, 0x000fc800078efcffULL, 0x000000555252723eULL, 0x000fc600000010ffULL,
0x000000b100b17306ULL, 0x000ee2000020d400ULL, 0x0000000149492812ULL, 0x002fce00078efcffULL,
0x00000041005d7306ULL, 0x000fe20000209400ULL, 0x00000001a2a23812ULL, 0x004fc800078efcffULL,
0x000000a24953723eULL, 0x000fc600000010ffULL, 0x00000041005e7306ULL, 0x000e620000205400ULL,
0x00000001b1b14812ULL, 0x008fc600078efcffULL, 0x000000522820723cULL, 0x000b640000041820ULL,
0x00000042b112723eULL, 0x020fe400000010ffULL, 0x0000000d00597306ULL, 0x000ff00000209400ULL,
0x0000000d005a7306ULL, 0x000ea20000205400ULL, 0x0000005e5d00720bULL, 0x002fc40003fbd000ULL,
0x0000007f585d723eULL, 0x000fca00000010ffULL, 0x000000b400797306ULL, 0x000fe40000209400ULL,
0x0000005c284c723cULL, 0x000b6c000004184cULL, 0x000000b400737306ULL, 0x000e620000205400ULL,
0x0000005a5900720bULL, 0x004fce0003f7d000ULL, 0x000000b2003c7306ULL, 0x000ff00000209400ULL,
0x000000b2003d7306ULL, 0x000ea20000205400ULL, 0x000000737900720bULL, 0x002fce0003f5d000ULL,
0x00000057003e7306ULL, 0x000ff00000209400ULL, 0x00000057002c7306ULL, 0x000e620000205400ULL,
0x0000003d3c00720bULL, 0x004fce0003f9d000ULL, 0x0000004100417306ULL, 0x000eb0000020d400ULL,
0x0000000d000d7306ULL, 0x000ee2000020d400ULL, 0x0000002c3e00720bULL, 0x002fce0003fdd000ULL,
0x000000b400b47306ULL, 0x000e62000020d400ULL, 0x0000000141415812ULL, 0x004fce00078efcffULL,
0x000000b200b27306ULL, 0x000ea2000020d400ULL, 0x000000010d0d3812ULL, 0x008fce00078efcffULL,
0x0000005700b37306ULL, 0x000ee2000020d400ULL, 0x00000001b4b42812ULL, 0x002fc800078efcffULL,
0x00000038b413723eULL, 0x000fe400000010ffULL, 0x00000001b2b24812ULL, 0x004fc800078efcffULL,
0x000000b241b2723eULL, 0x000fe200000010ffULL, 0x000000122824723cULL, 0x000b620000041824ULL,
0x00000001b3b36812ULL, 0x008fc800078efcffULL, 0x000000b30db3723eULL, 0x000fce00000010ffULL,
0x000000b22834723cULL, 0x000b620000041834ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0186b800ff2a7f8cULL, 0x020e62000c80043fULL, 0x000000ffff2c7224ULL, 0x000fce00078e00ffULL,
0x0000000000127805ULL, 0x000fc40000015200ULL, 0x0186bc00ff0d7984ULL, 0x000ea40000000800ULL,
0x800000000dff7812ULL, 0x006fe4000780482bULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x0000002812287210ULL, 0x000fca0007f1e1ffULL,
0x0000000129297824ULL, 0x000fe200000e0e13ULL, 0x003d09002800780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402800780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0d7819ULL, 0x000fc80000011429ULL,
0x000000280d0d7211ULL, 0x000fca00078110ffULL, 0x000000ffff287224ULL, 0x000fca00000e0629ULL,
0x000000020d0d7819ULL, 0x000fc80000001228ULL, 0x0000000d0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012c2c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0186bc00ff0d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe4000780482bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000204057890ULL, 0x000fe2000fffe03fULL, 0x00005800080d7a24ULL, 0x010fc800078e02ffULL,
0x000000400d137824ULL, 0x000fe200078e00ffULL, 0x0000000506007c0cULL, 0x000fda000bf03070ULL,
0x0000045000008947ULL, 0x000fea0003800000ULL, 0x0000000107127824ULL, 0x000fe200078e0211ULL,
0x0000000211387810ULL, 0x040fe20007ffe0ffULL, 0x0000010004057891ULL, 0x000fe2000f8e403fULL,
0x00000004113d7810ULL, 0x040fe20007ffe0ffULL, 0x00000001120d7824ULL, 0x040fe200078e0202ULL,
0x00000006113f7810ULL, 0x000fe20007ffe0ffULL, 0x00000010122f7824ULL, 0x000fe400078e00ffULL,
0x0000000107287824ULL, 0x000fe400078e0238ULL, 0x0000004003127824ULL, 0x000fe200078e0212ULL,
0xfffffff02f2f7812ULL, 0x000fe200078ee20dULL, 0x0000000128297824ULL, 0x000fe200078e0202ULL,
0x00000005040d7c17ULL, 0x000fe2000f800000ULL, 0x00000010283c7824ULL, 0x000fe200078e00ffULL,
0x00000013122d7210ULL, 0x000fe20007f1e0ffULL, 0x0000000107287824ULL, 0x000fe200078e023dULL,
0x800000050d0d7c10ULL, 0x000fc4000fffe0ffULL, 0xfffffff03c3c7812ULL, 0x000fe200078ee229ULL,
0x0000000128297824ULL, 0x140fe200078e0202ULL, 0x0000000d070d7217ULL, 0x040fe20007800000ULL,
0x00000010283e7824ULL, 0x000fe200078e00ffULL, 0x00000002122c7810ULL, 0x040fe20007ffe0ffULL,
0x0000000107287824ULL, 0x000fe200078e023fULL, 0x00000004122a7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff03e3e7812ULL, 0x000fe200078ee229ULL, 0x00000001282e7824ULL, 0x000fe200078e0202ULL,
0x00000006122b7810ULL, 0x000fe20007ffe0ffULL, 0x0000001028417824ULL, 0x000fe200078e00ffULL,
0x00005e002d287a11ULL, 0x000fe200078440ffULL, 0x000000ffff297224ULL, 0x000fe200000e06ffULL,
0x000000132c2c7210ULL, 0x080fe20007f9e0ffULL, 0x000000010d127824ULL, 0x000fe200078e0a07ULL,
0x000000132a2a7210ULL, 0x000fc40007f7e0ffULL, 0xfffffff041417812ULL, 0x000fe400078ee22eULL,
0x00005f002d2d7a11ULL, 0x000fe200010f4429ULL, 0x000000ffff0d7224ULL, 0x000fe200018e06ffULL,
0x000000f00c2e7812ULL, 0x000fe400078ec0ffULL, 0x000000121100720cULL, 0x000fe20003f46070ULL,
0x000000ffff117224ULL, 0x000fe200020e06ffULL, 0x000000132b137210ULL, 0x000fe40007f1e0ffULL,
0x00005e002c2b7a11ULL, 0x000fc400078840ffULL, 0x00005e002a297a11ULL, 0x000fe400078640ffULL,
0x0000002e280c7210ULL, 0x000fe40007fbe0ffULL, 0x00005f002c2c7a11ULL, 0x000fe200020f4411ULL,
0x000000ffff117224ULL, 0x000fe200000e06ffULL, 0x00005f002a2a7a11ULL, 0x000fe200018f440dULL,
0x000000ffff0d7224ULL, 0x000fe200028e062dULL, 0x000000123800720cULL, 0x080fe40003f86070ULL,
0x000000123d00720cULL, 0x000fc40003f66070ULL, 0x000140002f2f7811ULL, 0x000fe400078e20ffULL,
0x000000123f00720cULL, 0x000fe40003f06070ULL, 0x00005e0013287a11ULL, 0x000fe200078c40ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c2f7faeULL, 0x0003e2000d101c46ULL,
0x0000002e2b127210ULL, 0x080fe40007fbe0ffULL, 0x00005f0013117a11ULL, 0x000fe400030f4411ULL,
0x000140003c3c7811ULL, 0x000fe200078e20ffULL, 0x000000ffff137224ULL, 0x000fe200028e062cULL,
0x0000002e28287210ULL, 0x000fc40007fbe0ffULL, 0x000140003e3e7811ULL, 0x000fe400078e20ffULL,
0x0001400041417811ULL, 0x000fe200078e20ffULL, 0x00000000123c7faeULL, 0x0005e2000e101c46ULL,
0x0000002e290c7210ULL, 0x002fe20007f5e0ffULL, 0x000000ffff297224ULL, 0x000fc800028e0611ULL,
0x000000ffff0d7224ULL, 0x000fca00010e062aULL, 0x000000000c3e7faeULL, 0x0005e8000d901c46ULL,
0x0000000028417faeULL, 0x0005e2000c101c46ULL, 0x0000038000007947ULL, 0x000fea0003800000ULL,
0x0000000107117824ULL, 0x000fc800078e0211ULL, 0x00000001110d7824ULL, 0x040fe200078e0202ULL,
0x0000000211127810ULL, 0x040fe20007ffe0ffULL, 0x0000001011287824ULL, 0x040fe200078e00ffULL,
0x00000006112c7810ULL, 0x000fc60007ffe0ffULL, 0x0000000112297824ULL, 0x100fe200078e0202ULL,
0xfffffff028287812ULL, 0x000fe200078ee20dULL, 0x00000010122b7824ULL, 0x000fe400078e00ffULL,
0x00000040030d7824ULL, 0x000fe400078e0211ULL, 0x000000012c3c7824ULL, 0x040fe200078e0202ULL,
0xfffffff02b2b7812ULL, 0x000fe200078ee229ULL, 0x000000102c3e7824ULL, 0x000fe200078e00ffULL,
0x0000000411297810ULL, 0x000fe40007ffe0ffULL, 0x000000130d117210ULL, 0x000fc40007f1e0ffULL,
0x000000020d127810ULL, 0x000fe20007ffe0ffULL, 0x00000001292d7824ULL, 0x000fe200078e0202ULL,
0x000000040d2a7810ULL, 0x000fe20007ffe0ffULL, 0x00000010292f7824ULL, 0x000fe200078e00ffULL,
0x000000060d2e7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0d7224ULL, 0x000fe200000e06ffULL,
0x0000001312297210ULL, 0x080fe40007f5e0ffULL, 0x00005e0011127a11ULL, 0x000fe400078040ffULL,
0x000000132a2c7210ULL, 0x000fc40007f7e0ffULL, 0x000000f00c2a7812ULL, 0x000fe400078ec0ffULL,
0x000000132e387210ULL, 0x000fe40007f9e0ffULL, 0x00005f00110d7a11ULL, 0x000fe200000f440dULL,
0x000000ffff117224ULL, 0x000fe200010e06ffULL, 0x00005e0029137a11ULL, 0x000fe400078440ffULL,
0x0000002a120c7210ULL, 0x000fe40007f1e0ffULL, 0xfffffff02f2f7812ULL, 0x000fe200078ee22dULL,
0x000000ffff2d7224ULL, 0x000fe200018e06ffULL, 0xfffffff03e3e7812ULL, 0x000fe200078ee23cULL,
0x000000ffff3c7224ULL, 0x000fe200020e06ffULL, 0x00005e002c2e7a11ULL, 0x000fe200078640ffULL,
0x000000ffff0d7224ULL, 0x000fe200000e060dULL, 0x00005e00383d7a11ULL, 0x000fc400078840ffULL,
0x00005f0029297a11ULL, 0x000fe400010f4411ULL, 0x0001400028117811ULL, 0x000fe400078e20ffULL,
0x0000002a13127210ULL, 0x080fe40007f1e0ffULL, 0x00005f002c2d7a11ULL, 0x000fe200018f442dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c117faeULL, 0x0003e2000b901c46ULL,
0x0000002a2e287210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff137224ULL, 0x000fe200000e0629ULL,
0x00005f00383c7a11ULL, 0x000fc400020f443cULL, 0x0000002a3d2a7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff297224ULL, 0x000fe200010e062dULL, 0x000140002f2f7811ULL, 0x000fe400078e20ffULL,
0x000140003e3e7811ULL, 0x000fe400078e20ffULL, 0x000140002b0c7811ULL, 0x002fe200078e20ffULL,
0x000000ffff2b7224ULL, 0x000fc800018e063cULL, 0x00000000120c7faeULL, 0x0003e8000b901c46ULL,
0x00000000282f7faeULL, 0x0003e8000b901c46ULL, 0x000000002a3e7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x006fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0186a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0186a800ff0c7f8cULL, 0x000e64000c80043fULL, 0x000000ffff387224ULL, 0x002fc400078e000dULL,
0x00000000000c7805ULL, 0x000fca0000015200ULL, 0x0186b400ff117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fc4000780484bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff287224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x000000120c127210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e0dULL,
0x003d09001200780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401200780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff117819ULL, 0x000fc80000011413ULL, 0x0000001211117211ULL, 0x000fca00078110ffULL,
0x000000ffff127224ULL, 0x000fca00000e0613ULL, 0x0000000211117819ULL, 0x000fc80000001212ULL,
0x000000110000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000128287810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0186b400ff117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fe4000780484bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000018000007945ULL, 0x000fe20003800000ULL,
0x0000016000001947ULL, 0x000fea0003800000ULL, 0x0000000eff0c723eULL, 0x000fe400000010ffULL,
0x00000002ff0d7819ULL, 0x000fe40000011602ULL, 0x000054100c0c7816ULL, 0x000fe2000000000cULL,
0x0000b5327f007947ULL, 0x000fea000b800000ULL, 0x00001f0d0c0f7589ULL, 0x0002a400000e0000ULL,
0x000000080d107810ULL, 0x000fe20007ffe0ffULL, 0x0000b5827f007947ULL, 0x000fea000b800000ULL,
0x00001f100c107589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000100d477810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff497224ULL, 0x000fe200078e000cULL,
0x00017a4000447802ULL, 0x000fe20000000f00ULL, 0x0000001fff457424ULL, 0x000fc400078e00ffULL,
0xffffffffff467424ULL, 0x000fc400078e00ffULL, 0x0000bb5000007944ULL, 0x00efea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000180d477810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff497224ULL, 0x000fe200078e000cULL, 0x00017ab000447802ULL, 0x000fe20000000f00ULL,
0x0000001fff457424ULL, 0x000fe400078e00ffULL, 0xffffffffff467424ULL, 0x004fc400078e00ffULL,
0x0000bae000007944ULL, 0x00afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000003b3c783bULL, 0x000f280000004200ULL,
0x000000004044783bULL, 0x004ea80000004200ULL, 0x00000000392c783bULL, 0x000ee80000004200ULL,
0x000000003a28783bULL, 0x000e620000004200ULL, 0x000001003c687824ULL, 0x010fe200078e00ffULL,
0x0000003d00917306ULL, 0x000fe20000009400ULL, 0x00000018ff867819ULL, 0x000fe2000001143dULL,
0x000001003f697824ULL, 0x000fe200078e00ffULL, 0x00000018ff927819ULL, 0x000fc4000001143cULL,
0x00000018ff687819ULL, 0x000fe40000011468ULL, 0x00000018ff6f7819ULL, 0x004fe20000011444ULL,
0x0000003d006a7306ULL, 0x000ea20000005400ULL, 0x00000018ff697819ULL, 0x000fe40000011469ULL,
0x00000018ff647819ULL, 0x000fe40000011445ULL, 0x00000018ff797819ULL, 0x000fe4000001143fULL,
0x00000018ff5d7819ULL, 0x000fe20000011447ULL, 0x00000068007b7306ULL, 0x000fe20000209400ULL,
0x00000018ff7a7819ULL, 0x000fc4000001143eULL, 0x00000018ff637819ULL, 0x000fe40000011446ULL,
0x00000018ff5b7819ULL, 0x008fe4000001142cULL, 0x00000018ff547819ULL, 0x000fe2000001142dULL,
0x0000006800bd7306ULL, 0x000ee20000205400ULL, 0x0000006a9100720bULL, 0x004fe20003fdd000ULL,
0x000100002a917824ULL, 0x002fe200078e00ffULL, 0x00000018ff537819ULL, 0x000fe4000001142eULL,
0x00000018ff427819ULL, 0x000fc4000001142fULL, 0x00000018ff407819ULL, 0x000fe20000011428ULL,
0x00000068009d7306ULL, 0x0002a2000020d400ULL, 0x00000018ff3a7819ULL, 0x000fe40000011429ULL,
0x00000018ff137819ULL, 0x000fe4000001142aULL, 0x00000018ff117819ULL, 0x000fe4000001142bULL,
0x00000018ff917819ULL, 0x000fe20000011491ULL, 0x0000003d000d7306ULL, 0x0008a2000000d400ULL,
0x000001003d687824ULL, 0x002fe200078e00ffULL, 0x000000bd7b00720bULL, 0x008fc80003f1d000ULL,
0x00000018ff687819ULL, 0x000fe40000011468ULL, 0x0000003c00967306ULL, 0x000fe20000009400ULL,
0x000100003d3d7824ULL, 0x010fca00078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000006800c17306ULL, 0x000fe20000209400ULL, 0x000000019d9d0812ULL, 0x004fe400078efcffULL,
0x000000010d0d6812ULL, 0x000fca00078efcffULL, 0x0000006800bf7306ULL, 0x000e700000205400ULL,
0x0000006800aa7306ULL, 0x0004f0000020d400ULL, 0x0000003c00847306ULL, 0x000f220000005400ULL,
0x000001003e687824ULL, 0x004fe200078e00ffULL, 0x000000bfc100720bULL, 0x002fc80003f1d000ULL,
0x00000018ff687819ULL, 0x000fe40000011468ULL, 0x0000003c000c7306ULL, 0x0002ae000000d400ULL,
0x00000001aaaa0812ULL, 0x008fe200078efcffULL, 0x0000003d00c57306ULL, 0x000fe20000209400ULL,
0x000100003c3c7824ULL, 0x002fe200078e00ffULL, 0x000000849600720bULL, 0x010fc40003f7d000ULL,
0x0000000daa0d723eULL, 0x000fe400000010ffULL, 0x00000018ff957819ULL, 0x000fe4000001143cULL,
0x0000003d00c47306ULL, 0x000e6e0000205400ULL, 0x000000010c0c3812ULL, 0x004fe200078efcffULL,
0x0000003d008b7306ULL, 0x000ea6000020d400ULL, 0x0000000c9d0c723eULL, 0x000fca00000010ffULL,
0x0000006800c07306ULL, 0x000fe20000209400ULL, 0x000000c4c500720bULL, 0x002fce0003f7d000ULL,
0x00000068003d7306ULL, 0x000fec0000205400ULL, 0x000000018b8b3812ULL, 0x004fe400078efcffULL,
0x0000006800877306ULL, 0x0003f0000020d400ULL, 0x0000004400af7306ULL, 0x000fe20000009400ULL,
0x0000010044687824ULL, 0x002fca00078e00ffULL, 0x00000018ff687819ULL, 0x000fe40000011468ULL,
0x0000004400ac7306ULL, 0x000ff00000005400ULL, 0x0000004400737306ULL, 0x0003f0000000d400ULL,
0x0000003f00b27306ULL, 0x000fe20000009400ULL, 0x0001000044447824ULL, 0x002fca00078e00ffULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x0000003f008c7306ULL, 0x000e700000005400ULL,
0x0000006900c37306ULL, 0x000ff00000209400ULL, 0x0000006900c27306ULL, 0x000ea20000205400ULL,
0x0000008cb200720bULL, 0x002fce0003fdd000ULL, 0x0000009500be7306ULL, 0x000ff00000209400ULL,
0x00000095003c7306ULL, 0x000e620000205400ULL, 0x000000c2c300720bULL, 0x004fce0003f1d000ULL,
0x0000004400cf7306ULL, 0x000ff00000209400ULL, 0x0000004400ce7306ULL, 0x000fe20000205400ULL,
0x0000003cbe00720bULL, 0x002fe40003fbd000ULL, 0x00013800503c7811ULL, 0x000fca00078e20ffULL,
0x0000004400777306ULL, 0x0003f0000020d400ULL, 0x00000069008a7306ULL, 0x0004e2000020d400ULL,
0x0000010046447824ULL, 0x002fca00078e00ffULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x0000004500ab7306ULL, 0x000fe20000009400ULL, 0x0000010045697824ULL, 0x004fca00078e00ffULL,
0x00000018ff697819ULL, 0x000fe40000011469ULL, 0x0000004500b07306ULL, 0x000fe20000005400ULL,
0x000000018a8a0812ULL, 0x008fce00078efcffULL, 0x00000045006c7306ULL, 0x0003f0000000d400ULL,
0x0000003f00807306ULL, 0x0004e2000000d400ULL, 0x0001000045457824ULL, 0x002fca00078e00ffULL,
0x00000018ff457819ULL, 0x000fe40000011445ULL, 0x0000009200ba7306ULL, 0x000fe20000209400ULL,
0x000100003f3f7824ULL, 0x004fca00078e00ffULL, 0x00000018ff7e7819ULL, 0x000fe4000001143fULL,
0x0000009200857306ULL, 0x000e620000205400ULL, 0x0000000180806812ULL, 0x008fe400078efcffULL,
0x000000acaf00720bULL, 0x000fca0003fdd000ULL, 0x0000009500957306ULL, 0x000eb0000020d400ULL,
0x0000006800c97306ULL, 0x000fe20000209400ULL, 0x00000085ba00720bULL, 0x002fe20003f9d000ULL,
0x000001002bba7824ULL, 0x000fe200078e00ffULL, 0x0000000173736812ULL, 0x000fe200078efcffULL,
0x000100002b857824ULL, 0x000fc600078e00ffULL, 0x00000018ffba7819ULL, 0x000fe200000114baULL,
0x0000006800c87306ULL, 0x000e620000205400ULL, 0x0000000195955812ULL, 0x004fe400078efcffULL,
0x0000003dc000720bULL, 0x000fe40003fbd000ULL, 0x00000018ff857819ULL, 0x000fc60000011485ULL,
0x0000004400cd7306ULL, 0x000ff00000209400ULL, 0x0000004400cc7306ULL, 0x000fe20000205400ULL,
0x000000c8c900720bULL, 0x002fe40003f1d000ULL, 0x0000000187875812ULL, 0x000fca00078efcffULL,
0x0000004400727306ULL, 0x0003f0000020d400ULL, 0x0000004500d27306ULL, 0x000fe20000209400ULL,
0x000001002c447824ULL, 0x002fca00078e00ffULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x0000004500d37306ULL, 0x000e700000205400ULL, 0x0000004500717306ULL, 0x0004f0000020d400ULL,
0x0000004700a57306ULL, 0x000fe20000009400ULL, 0x0000010047457824ULL, 0x004fe200078e00ffULL,
0x000000d3d200720bULL, 0x002fc80003fdd000ULL, 0x00000018ff457819ULL, 0x000fe40000011445ULL,
0x0000004700a27306ULL, 0x000fee0000005400ULL, 0x0000000171716812ULL, 0x008fe200078efcffULL,
0x0000004700617306ULL, 0x0003f0000000d400ULL, 0x0000006900ca7306ULL, 0x000fe20000209400ULL,
0x0001000047477824ULL, 0x002fca00078e00ffULL, 0x00000018ff477819ULL, 0x000fe40000011447ULL,
0x0000006900cb7306ULL, 0x000ff00000205400ULL, 0x0000006900767306ULL, 0x000ff0000020d400ULL,
0x0000008600bc7306ULL, 0x000ff00000209400ULL, 0x0000008600bb7306ULL, 0x000e700000205400ULL,
0x0000004400dd7306ULL, 0x000ff00000209400ULL, 0x0000004400dc7306ULL, 0x000fe20000205400ULL,
0x000000bbbc00720bULL, 0x002fe20003f5d000ULL, 0x0001000029bb7824ULL, 0x000fc400078e00ffULL,
0x000001002abc7824ULL, 0x000fc600078e00ffULL, 0x00000018ffbb7819ULL, 0x000fe200000114bbULL,
0x0000004400697306ULL, 0x0003e2000020d400ULL, 0x00000018ffbc7819ULL, 0x000fce00000114bcULL,
0x0000009200927306ULL, 0x000ea2000020d400ULL, 0x000001002d447824ULL, 0x002fca00078e00ffULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x0000006800787306ULL, 0x000e70000020d400ULL,
0x0000003e00b47306ULL, 0x000fe20000009400ULL, 0x0000000192924812ULL, 0x004fce00078efcffULL,
0x0000003e00b57306ULL, 0x000ea20000005400ULL, 0x0000000178780812ULL, 0x002fc800078efcffULL,
0x000000737878723eULL, 0x000fc600000010ffULL, 0x0000006400ae7306ULL, 0x000ff00000209400ULL,
0x0000006400ad7306ULL, 0x000e620000205400ULL, 0x000000b5b400720bULL, 0x004fce0003f9d000ULL,
0x0000007e00c77306ULL, 0x000ff00000209400ULL, 0x0000007e003f7306ULL, 0x000ea20000205400ULL,
0x000000adae00720bULL, 0x002fce0003f1d000ULL, 0x0000003e00817306ULL, 0x0002f0000000d400ULL,
0x0000004600a47306ULL, 0x000fe20000009400ULL, 0x000100003e3e7824ULL, 0x002fe200078e00ffULL,
0x0000003fc700720bULL, 0x004fc80003fbd000ULL, 0x00000018ff7f7819ULL, 0x000fe4000001143eULL,
0x0000004600a37306ULL, 0x000fe20000005400ULL, 0x0000000181814812ULL, 0x008fce00078efcffULL,
0x0000004600677306ULL, 0x0003f0000000d400ULL, 0x0000002c00a17306ULL, 0x000fe20000009400ULL,
0x0001000046467824ULL, 0x002fca00078e00ffULL, 0x00000018ff467819ULL, 0x000fe40000011446ULL,
0x0000002c00a07306ULL, 0x000ff00000005400ULL, 0x0000002c005f7306ULL, 0x0003f0000000d400ULL,
0x0000002d009f7306ULL, 0x000fe20000009400ULL, 0x000100002c2c7824ULL, 0x002fca00078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe4000001142cULL, 0x0000002d009e7306ULL, 0x000ff00000005400ULL,
0x0000002d00587306ULL, 0x0003f0000000d400ULL, 0x0000004700db7306ULL, 0x000fe20000209400ULL,
0x000100002d2d7824ULL, 0x002fca00078e00ffULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x0000004700da7306ULL, 0x000ff00000205400ULL, 0x0000004700687306ULL, 0x000ff0000020d400ULL,
0x0000004400d97306ULL, 0x000ff00000209400ULL, 0x0000004400d87306ULL, 0x000ff00000205400ULL,
0x0000004400477306ULL, 0x0003f0000020d400ULL, 0x0000004500d07306ULL, 0x000fe20000209400ULL,
0x000001002e447824ULL, 0x002fca00078e00ffULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x0000004500d17306ULL, 0x000ff00000205400ULL, 0x00000045006b7306ULL, 0x0003f0000020d400ULL,
0x0000002e00987306ULL, 0x000fe20000009400ULL, 0x000001002f457824ULL, 0x002fca00078e00ffULL,
0x00000018ff457819ULL, 0x000fe40000011445ULL, 0x0000002e00997306ULL, 0x000ff00000005400ULL,
0x0000002e00577306ULL, 0x0003f0000000d400ULL, 0x0000008600867306ULL, 0x000ea2000020d400ULL,
0x000100002e2e7824ULL, 0x002fca00078e00ffULL, 0x00000018ff2e7819ULL, 0x000fe4000001142eULL,
0x0000007a00b97306ULL, 0x000ff00000209400ULL, 0x0000007a00b67306ULL, 0x000e620000205400ULL,
0x0000000186862812ULL, 0x004fce00078efcffULL, 0x0000006400647306ULL, 0x000eb0000020d400ULL,
0x0000002f009c7306ULL, 0x000fe20000009400ULL, 0x000000b6b900720bULL, 0x002fce0003f5d000ULL,
0x0000002f00977306ULL, 0x000fe20000005400ULL, 0x0000000164640812ULL, 0x004fe400078efcffULL,
0x000000a0a100720bULL, 0x000fca0003f1d000ULL, 0x0000002f004b7306ULL, 0x0003f0000000d400ULL,
0x0000007900b87306ULL, 0x000fe20000209400ULL, 0x000100002f2f7824ULL, 0x002fe200078e00ffULL,
0x000000015f5f0812ULL, 0x000fc400078efcffULL, 0x000000d8d900720bULL, 0x000fe40003f1d000ULL,
0x00000018ff2f7819ULL, 0x000fe4000001142fULL, 0x0000007900b77306ULL, 0x000e700000205400ULL,
0x0000007f003e7306ULL, 0x000fe20000209400ULL, 0x0000000147470812ULL, 0x000fce00078efcffULL,
0x0000007f00c67306ULL, 0x000ea20000205400ULL, 0x000000b7b800720bULL, 0x002fce0003f9d000ULL,
0x0000007e007e7306ULL, 0x000e70000020d400ULL, 0x0000004600d47306ULL, 0x000fe20000209400ULL,
0x000000c63e00720bULL, 0x004fe40003f7d000ULL, 0x000000003c3c783bULL, 0x000eaa0000000200ULL,
0x0000004600d57306ULL, 0x000ee20000205400ULL, 0x000000017e7e5812ULL, 0x002fce00078efcffULL,
0x0000006f00b37306ULL, 0x000ff00000209400ULL, 0x0000006f00b17306ULL, 0x000e620000205400ULL,
0x000000d5d400720bULL, 0x008fce0003fdd000ULL, 0x0000004600707306ULL, 0x000ef0000020d400ULL,
0x0000002c00d77306ULL, 0x000fe20000209400ULL, 0x000000b1b300720bULL, 0x002fe20003fbd000ULL,
0x0000000f3c3c9231ULL, 0x004fc400003400ffULL, 0x0000000f3e3e9231ULL, 0x000fe400003400ffULL,
0x000000103d3d9231ULL, 0x080fe400003400ffULL, 0x0000002c00d67306ULL, 0x000fe20000205400ULL,
0x0000000170706812ULL, 0x008fe200078efcffULL, 0x000000103f3f9231ULL, 0x000fe200003400ffULL,
0x0000009e9f00720bULL, 0x000fca0003fdd000ULL, 0x0000002c00467306ULL, 0x000ff0000020d400ULL,
0x0000002d008f7306ULL, 0x000fe20000209400ULL, 0x0000000158586812ULL, 0x000fce00078efcffULL,
0x0000002d008e7306ULL, 0x000e700000205400ULL, 0x0000002d002c7306ULL, 0x000eb0000020d400ULL,
0x00000044008d7306ULL, 0x000fe20000209400ULL, 0x0000008e8f00720bULL, 0x002fce0003f1d000ULL,
0x0000004400907306ULL, 0x000e6c0000205400ULL, 0x000000012c2c0812ULL, 0x004fe400078efcffULL,
0x00000044002d7306ULL, 0x000eb0000020d400ULL, 0x0000004500887306ULL, 0x000fe20000209400ULL,
0x000000908d00720bULL, 0x002fce0003fdd000ULL, 0x0000004500897306ULL, 0x000e6c0000205400ULL,
0x000000012d2d6812ULL, 0x004fe400078efcffULL, 0x0000004500447306ULL, 0x000eb0000020d400ULL,
0x0000002e007c7306ULL, 0x000fe20000209400ULL, 0x000000898800720bULL, 0x002fce0003f1d000ULL,
0x0000002e007d7306ULL, 0x000e6c0000205400ULL, 0x0000000144440812ULL, 0x004fe400078efcffULL,
0x0000002e00457306ULL, 0x0004f0000020d400ULL, 0x0000007a007a7306ULL, 0x000f22000020d400ULL,
0x00000100282e7824ULL, 0x004fe200078e00ffULL, 0x0000007d7c00720bULL, 0x002fc80003fdd000ULL,
0x00000018ff2e7819ULL, 0x000fe4000001142eULL, 0x0000002f007b7306ULL, 0x000fee0000209400ULL,
0x0000000145456812ULL, 0x008fe200078efcffULL, 0x0000002f00847306ULL, 0x000e620000205400ULL,
0x000000017a7a2812ULL, 0x010fc400078efcffULL, 0x000000cbca00720bULL, 0x000fca0003f5d000ULL,
0x0000002f006a7306ULL, 0x0004f0000020d400ULL, 0x0000002800937306ULL, 0x000fe20000009400ULL,
0x00010000282f7824ULL, 0x004fe200078e00ffULL, 0x0000000176762812ULL, 0x000fc400078efcffULL,
0x000000cccd00720bULL, 0x000fe40003f5d000ULL, 0x00000018ff2f7819ULL, 0x000fe4000001142fULL,
0x0000002800947306ULL, 0x000fe20000005400ULL, 0x000000847b00720bULL, 0x002fce0003f1d000ULL,
0x0000002800417306ULL, 0x0003e2000000d400ULL, 0x0000000172722812ULL, 0x000fca00078efcffULL,
0x000000016a6a0812ULL, 0x008fe400078efcffULL, 0x0000007900797306ULL, 0x000ea2000020d400ULL,
0x0000010029287824ULL, 0x002fce00078e00ffULL, 0x0000007f007f7306ULL, 0x000e70000020d400ULL,
0x0000006f006f7306ULL, 0x000ee2000020d400ULL, 0x0000000179794812ULL, 0x004fe400078efcffULL,
0x000000cecf00720bULL, 0x000fca0003f9d000ULL, 0x0000002e00967306ULL, 0x000fe20000209400ULL,
0x000000017f7f3812ULL, 0x002fe400078efcffULL, 0x000000b0ab00720bULL, 0x000fca0003f7d000ULL,
0x0000002e00b47306ULL, 0x000e620000205400ULL, 0x000000016f6f5812ULL, 0x008fe400078efcffULL,
0x000000a2a500720bULL, 0x000fe40003fbd000ULL, 0x0000000177774812ULL, 0x000fe400078efcffULL,
0x000000d1d000720bULL, 0x000fe20003f9d000ULL, 0x0000002e008c7306ULL, 0x0004e2000020d400ULL,
0x000000016c6c3812ULL, 0x000fe400078efcffULL, 0x000000a3a400720bULL, 0x000fca0003f7d000ULL,
0x0000002900757306ULL, 0x000fe20000009400ULL, 0x00000018ff2e7819ULL, 0x004fe40000011428ULL,
0x0001380043287811ULL, 0x000fe400078e20ffULL, 0x0000000161615812ULL, 0x000fe400078efcffULL,
0x000000dcdd00720bULL, 0x000fe20003fbd000ULL, 0x0000002900747306ULL, 0x000fe20000005400ULL,
0x0000000167673812ULL, 0x000fe400078efcffULL, 0x000000016b6b4812ULL, 0x000fc400078efcffULL,
0x000000dadb00720bULL, 0x000fe40003f7d000ULL, 0x000000b49600720bULL, 0x002fe20003fdd000ULL,
0x00000029003b7306ULL, 0x000fe2000000d400ULL, 0x000000677272723eULL, 0x000fe400000010ffULL,
0x000000616b73723eULL, 0x000fe400000010ffULL, 0x0000000169695812ULL, 0x000fc600078efcffULL,
0x0000002a006d7306ULL, 0x000fe40000009400ULL, 0x0000000168683812ULL, 0x000fe400078efcffULL,
0x000000d6d700720bULL, 0x000fe40003f7d000ULL, 0x000000018c8c6812ULL, 0x008fe400078efcffULL,
0x0000002a006e7306ULL, 0x000ff00000005400ULL, 0x0000002a00397306ULL, 0x000fe2000000d400ULL,
0x0000000146463812ULL, 0x000fc400078efcffULL, 0x000000949300720bULL, 0x000fca0003f7d000ULL,
0x0000002b005c7306ULL, 0x000ff00000009400ULL, 0x0000002b005e7306ULL, 0x000fe20000005400ULL,
0x0000000141413812ULL, 0x000fce00078efcffULL, 0x0000002b00127306ULL, 0x0003f0000000d400ULL,
0x0000006300a87306ULL, 0x000fe20000209400ULL, 0x000000002828783bULL, 0x002e6e0000000200ULL,
0x0000006300a77306ULL, 0x000eb00000205400ULL, 0x0000005d00a97306ULL, 0x000ff00000209400ULL,
0x0000005d00a67306ULL, 0x000ee20000205400ULL, 0x000000a7a800720bULL, 0x004fce0003f5d000ULL,
0x0000005b009a7306ULL, 0x000ff00000209400ULL, 0x0000005b009b7306ULL, 0x000ea20000205400ULL,
0x000000a6a900720bULL, 0x008fe20003f9d000ULL, 0x0000000f28289231ULL, 0x002fc400003400ffULL,
0x0000000f2a2a9231ULL, 0x000fe400003400ffULL, 0x0000001029299231ULL, 0x080fe400003400ffULL,
0x0000006300637306ULL, 0x000e62000020d400ULL, 0x000000102b2b9231ULL, 0x000fe200003400ffULL,
0x000000747500720bULL, 0x000fcc0003f3d000ULL, 0x0000005d005d7306ULL, 0x000ee2000020d400ULL,
0x0000009b9a00720bULL, 0x004fe20003fbd000ULL, 0x0000000c2818723cULL, 0x040b6a0000041818ULL,
0x000000013b3b1812ULL, 0x000fe200078efcffULL, 0x0000005b005b7306ULL, 0x000ea2000020d400ULL,
0x0000000163632812ULL, 0x002fe200078efcffULL, 0x000000722824723cULL, 0x000fe20000041824ULL,
0x000000999800720bULL, 0x000fc40003f5d000ULL, 0x00000081870c723eULL, 0x020fe400000010ffULL,
0x000000808a0d723eULL, 0x000fe200000010ffULL, 0x0000005400837306ULL, 0x000fe20000209400ULL,
0x000000015d5d4812ULL, 0x008fe400078efcffULL, 0x000000979c00720bULL, 0x000fe40003f9d000ULL,
0x000000706370723eULL, 0x000fe200000010ffULL, 0x0000000c2830723cULL, 0x000be40000041830ULL,
0x0000005400827306ULL, 0x000e620000205400ULL, 0x000000015b5b5812ULL, 0x004fc400078efcffULL,
0x0000000157572812ULL, 0x000fe400078efcffULL, 0x000000776f0c723eULL, 0x020fe400000010ffULL,
0x00000071640d723eULL, 0x000fe200000010ffULL, 0x0000002e00b27306ULL, 0x000fe20000209400ULL,
0x000000014b4b4812ULL, 0x000fe400078efcffULL, 0x000000685d71723eULL, 0x000fc600000010ffULL,
0x0000000c2820723cULL, 0x000be40000041820ULL, 0x0000002e00ab7306ULL, 0x000ea20000205400ULL,
0x000000828300720bULL, 0x002fc80003fbd000ULL, 0x0000005f690c723eULL, 0x020fe200000010ffULL,
0x000000702834723cULL, 0x000fe20000041834ULL, 0x00000058470d723eULL, 0x000fe200000010ffULL,
0x0000002e00437306ULL, 0x0002f0000020d400ULL, 0x0000002f00a37306ULL, 0x000fe20000209400ULL,
0x00000095922e723eULL, 0x002fc400000010ffULL, 0x000000abb200720bULL, 0x004fca0003f1d000ULL,
0x0000002f00a07306ULL, 0x000e700000205400ULL, 0x0000002f00507306ULL, 0x000522000020d400ULL,
0x0000000143430812ULL, 0x008fc800078efcffULL, 0x0000003b4343723eULL, 0x000fc600000010ffULL,
0x0000005300657306ULL, 0x000fe20000209400ULL, 0x0000008b862f723eULL, 0x004fe400000010ffULL,
0x000000a0a300720bULL, 0x002fca0003fdd000ULL, 0x0000005300667306ULL, 0x000e620000205400ULL,
0x0000002e2814723cULL, 0x000b6e0000041814ULL, 0x0000005400547306ULL, 0x000ea2000020d400ULL,
0x0000007f7a2e723eULL, 0x020fe400000010ffULL, 0x0000007e792f723eULL, 0x000fc400000010ffULL,
0x0000006c7679723eULL, 0x000fe400000010ffULL, 0x0000000150506812ULL, 0x010fe200078efcffULL,
0x0000004200607306ULL, 0x000fe20000209400ULL, 0x000000666500720bULL, 0x002fe20003f5d000ULL,
0x0000002e284c723cULL, 0x040b6c000004184cULL, 0x0000004200627306ULL, 0x000e620000205400ULL,
0x0000000154545812ULL, 0x004fe200078efcffULL, 0x00000078281c723cULL, 0x000f64000004181cULL,
0x000000465b2e723eULL, 0x020fc400000010ffULL, 0x0000002c542f723eULL, 0x000fe400000010ffULL,
0x0000006e6d00720bULL, 0x000fe20003fbd000ULL, 0x0000005300537306ULL, 0x000ea2000020d400ULL,
0x0000000c3c28723cULL, 0x000b6e0000041818ULL, 0x0000004200427306ULL, 0x000ee2000020d400ULL,
0x000000626000720bULL, 0x002fc40003f9d000ULL, 0x000000572d0c723eULL, 0x020fe400000010ffULL,
0x0000002e3c2c723cULL, 0x040b620000041814ULL, 0x0000004b440d723eULL, 0x000fe400000010ffULL,
0x0000004000597306ULL, 0x000fe20000209400ULL, 0x0000000153532812ULL, 0x004fe400078efcffULL,
0x0000005e5c00720bULL, 0x000fe40003f5d000ULL, 0x0000000c3c30723cULL, 0x000b620000041830ULL,
0x0000000139395812ULL, 0x000fc400078efcffULL, 0x00000040005a7306ULL, 0x000e620000205400ULL,
0x0000000142424812ULL, 0x008fe400078efcffULL, 0x000000455318723eULL, 0x000fe400000010ffULL,
0x0000006a4219723eULL, 0x000fe400000010ffULL, 0x000000418c42723eULL, 0x000fe200000010ffULL,
0x0000003a00557306ULL, 0x000fe20000209400ULL, 0x0000000112122812ULL, 0x000fc600078efcffULL,
0x000000183c18723cULL, 0x000b68000004184cULL, 0x0000003a00567306ULL, 0x000ea20000205400ULL,
0x0000005a5900720bULL, 0x002fc60003f9d000ULL, 0x000000423c1c723cULL, 0x000b68000004181cULL,
0x000000bb00987306ULL, 0x000ff00000209400ULL, 0x000000bb00977306ULL, 0x000e620000205400ULL,
0x000000565500720bULL, 0x004fce0003f7d000ULL, 0x000000bc00817306ULL, 0x000ff00000209400ULL,
0x000000bc007a7306ULL, 0x000ea20000205400ULL, 0x000000979800720bULL, 0x002fce0003f1d000ULL,
0x0000004000407306ULL, 0x000e70000020d400ULL, 0x0000003a003a7306ULL, 0x000ee2000020d400ULL,
0x0000007a8100720bULL, 0x004fce0003fdd000ULL, 0x000000bb00bb7306ULL, 0x000ea2000020d400ULL,
0x0000000140404812ULL, 0x002fc800078efcffULL, 0x000000504040723eULL, 0x000fc600000010ffULL,
0x000000bc00bc7306ULL, 0x000e62000020d400ULL, 0x000000013a3a3812ULL, 0x008fce00078efcffULL,
0x0000001300517306ULL, 0x000fe20000209400ULL, 0x00000001bbbb0812ULL, 0x004fc800078efcffULL,
0x000000bb3a41723eULL, 0x000fc600000010ffULL, 0x0000001300527306ULL, 0x000ea20000205400ULL,
0x00000001bcbc6812ULL, 0x002fc600078efcffULL, 0x000000403c20723cULL, 0x000b620000041820ULL,
0x00000039bcbc723eULL, 0x000fc600000010ffULL, 0x0000001100497306ULL, 0x000ff00000209400ULL,
0x00000011004a7306ULL, 0x000e620000205400ULL, 0x000000525100720bULL, 0x004fce0003f3d000ULL,
0x000000ba006c7306ULL, 0x000ff00000209400ULL, 0x000000ba00647306ULL, 0x000ea20000205400ULL,
0x0000004a4900720bULL, 0x002fce0003f9d000ULL, 0x00000091005c7306ULL, 0x000ff00000209400ULL,
0x0000009100477306ULL, 0x000e620000205400ULL, 0x000000646c00720bULL, 0x004fce0003f1d000ULL,
0x0000008500467306ULL, 0x000ff00000209400ULL, 0x0000008500147306ULL, 0x020ea20000205400ULL,
0x000000475c00720bULL, 0x002fce0003f7d000ULL, 0x0000001300137306ULL, 0x000e70000020d400ULL,
0x0000001100117306ULL, 0x000ee2000020d400ULL, 0x000000144600720bULL, 0x004fce0003fdd000ULL,
0x000000ba00bd7306ULL, 0x000ea2000020d400ULL, 0x0000000113131812ULL, 0x002fce00078efcffULL,
0x0000009100917306ULL, 0x000e62000020d400ULL, 0x0000000111114812ULL, 0x008fce00078efcffULL,
0x00000085000d7306ULL, 0x000ee2000020d400ULL, 0x00000001bdbd0812ULL, 0x004fc800078efcffULL,
0x00000012bdbd723eULL, 0x000fe400000010ffULL, 0x0000000191913812ULL, 0x002fc800078efcffULL,
0x00000091130c723eULL, 0x000fe200000010ffULL, 0x000000bc3c24723cULL, 0x000b620000041824ULL,
0x000000010d0d6812ULL, 0x008fc800078efcffULL, 0x0000000d110d723eULL, 0x000fce00000010ffULL,
0x0000000c3c34723cULL, 0x000b620000041834ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0186b800ff0c7f8cULL, 0x020e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0186a000ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000040b417810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff447224ULL, 0x002fc400078e000dULL,
0x0000000104047890ULL, 0x000fcc000fffe03fULL, 0x0000000406007c0cULL, 0x000fda000bf03070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xfffe78b000007947ULL, 0x000fea000383ffffULL,
0x000000ff0600720cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x0180000009027810ULL, 0x000fe20007ffe0ffULL, 0x000000c000007945ULL, 0x000fe60003800000ULL,
0x7f80000002027812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0200780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000000ffff037224ULL, 0x000fe200078e0009ULL,
0x000199a000057802ULL, 0x000fc40000000f00ULL, 0x00009a1000007944ULL, 0x00efea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000900047308ULL, 0x000f240000001000ULL,
0xbf80000004097423ULL, 0x010fc80000000009ULL, 0x800000ff09097221ULL, 0x000fc80000010100ULL,
0x0000000904047223ULL, 0x000fc40000000004ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006800ff027624ULL, 0x000fe400078e00ffULL, 0x00006900ff037624ULL, 0x000fca00078e00ffULL,
0x0000000602027981ULL, 0x0048a8000c1e9900ULL, 0x0000000000057919ULL, 0x000f240000000000ULL,
0x00000002ff037819ULL, 0x010fe40000011605ULL, 0x0000000805057811ULL, 0x000fe200078ff0ffULL,
0x0000000402027220ULL, 0x004fca0000410000ULL, 0x00001f0302037589ULL, 0x000ea800000e0000ULL,
0x00001f0502027589ULL, 0x000f2200000e0000ULL, 0x0000002803287220ULL, 0x044fe40000410000ULL,
0x0000002903297220ULL, 0x040fe40000410000ULL, 0x0000002c032c7220ULL, 0x040fe40000410000ULL,
0x0000002d032d7220ULL, 0x000fc40000410000ULL, 0x0000003003307220ULL, 0x040fe40000410000ULL,
0x0000003103317220ULL, 0x040fe40000410000ULL, 0x0000001803187220ULL, 0x040fe40000410000ULL,
0x0000001903197220ULL, 0x040fe40000410000ULL, 0x0000001c031c7220ULL, 0x040fe40000410000ULL,
0x0000001d031d7220ULL, 0x000fc40000410000ULL, 0x0000002003207220ULL, 0x040fe40000410000ULL,
0x0000002103217220ULL, 0x040fe40000410000ULL, 0x0000002403247220ULL, 0x040fe40000410000ULL,
0x0000002503257220ULL, 0x040fe40000410000ULL, 0x0000003403347220ULL, 0x040fe40000410000ULL,
0x0000003503357220ULL, 0x000fc40000410000ULL, 0x0000002a022a7220ULL, 0x050fe40000410000ULL,
0x0000002b022b7220ULL, 0x040fe40000410000ULL, 0x0000002e022e7220ULL, 0x040fe40000410000ULL,
0x0000002f022f7220ULL, 0x040fe40000410000ULL, 0x0000003202327220ULL, 0x040fe40000410000ULL,
0x0000003302337220ULL, 0x000fc40000410000ULL, 0x0000001a021a7220ULL, 0x040fe40000410000ULL,
0x0000001b021b7220ULL, 0x040fe40000410000ULL, 0x0000001e021e7220ULL, 0x040fe40000410000ULL,
0x0000001f021f7220ULL, 0x040fe40000410000ULL, 0x0000002202227220ULL, 0x040fe40000410000ULL,
0x0000002302237220ULL, 0x000fc40000410000ULL, 0x0000002602267220ULL, 0x040fe40000410000ULL,
0x0000002702277220ULL, 0x040fe40000410000ULL, 0x0000003602367220ULL, 0x040fe40000410000ULL,
0x0000003702377220ULL, 0x000fc40000410000ULL, 0x0000000000147919ULL, 0x000f220000000000ULL,
0x00000000000579c3ULL, 0x000ea20000002700ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x00000002ff047819ULL, 0x010fc60000011614ULL, 0x00000005040472a4ULL, 0x004fe2000f8e023fULL,
0x0000000214027812ULL, 0x040fe400078ec0ffULL, 0x0000000814057811ULL, 0x000fe200078ff0ffULL,
0x0000000804087824ULL, 0x000fe200078e00ffULL, 0x0000000402037211ULL, 0x000fe200078ff8ffULL,
0x0000000804097824ULL, 0x000fe200078e00ffULL, 0x0000000502067211ULL, 0x000fe200078ff8ffULL,
0x00000008050a7824ULL, 0x008fe200078e00ffULL, 0x0000000203027810ULL, 0x040fe20007ffe0ffULL,
0x00000008040b7824ULL, 0x040fe200078e00ffULL, 0x0000000403057810ULL, 0x000fe20007ffe0ffULL,
0x00000008040c7824ULL, 0x000fe200078e00ffULL, 0xfffffff808047812ULL, 0x000fc400078ee203ULL,
0x0000000603037810ULL, 0x000fe40007ffe0ffULL, 0xfffffff80a0a7812ULL, 0x000fe400078ee206ULL,
0xfffffff809067812ULL, 0x000fe400078ee202ULL, 0xfffffff80c097812ULL, 0x000fe200078ee203ULL,
0x0000000814037824ULL, 0x000fe200078e00ffULL, 0xfffffff80b087812ULL, 0x000fe400078ee205ULL,
0x0001200000057811ULL, 0x000fc400078e58ffULL, 0x0000000803037812ULL, 0x000fe400078ec0ffULL,
0x000000282900723eULL, 0x000fe200000010ffULL, 0x0000001004047824ULL, 0x100fe200078e0205ULL,
0x0000002c2d02723eULL, 0x000fe200000010ffULL, 0x000000100a0a7824ULL, 0x000fe200078e0205ULL,
0x00000003ff0c7819ULL, 0x000fe20000011614ULL, 0x0000000104047824ULL, 0x000fe200078e0203ULL,
0x0000541000107816ULL, 0x100fe20000000002ULL, 0x0000001006067824ULL, 0x100fe200078e0205ULL,
0x0000763200117816ULL, 0x000fe20000000002ULL, 0x0000001008007824ULL, 0x100fe200078e0205ULL,
0x00000020140e7810ULL, 0x000fe20007ffe0ffULL, 0x0000001009027824ULL, 0x000fc400078e0205ULL,
0x0000001004007388ULL, 0x0005e20000000a00ULL, 0x00000003ff0f7819ULL, 0x000fe2000001160eULL,
0x00000001030b7824ULL, 0x040fe400078e020aULL, 0x0000000103087824ULL, 0x040fe400078e0206ULL,
0x0000000103097824ULL, 0x000fe200078e0200ULL, 0x000000303100723eULL, 0x000fe200000010ffULL,
0x00000001030a7824ULL, 0x000fe200078e0202ULL, 0x000000181902723eULL, 0x000fe200000010ffULL,
0x000000010e0d7824ULL, 0x000fe200078e020fULL, 0x0000001c1d03723eULL, 0x000fe200000010ffULL,
0x000000010c047824ULL, 0x004fe200078e0214ULL, 0x0000541000127816ULL, 0x000fc40000000002ULL,
0x0000763200137816ULL, 0x000fe40000000002ULL, 0x0000000704047812ULL, 0x000fe400078ec0ffULL,
0x000000070d0d7812ULL, 0x000fe200078ec0ffULL, 0x0000001208007388ULL, 0x000fe20000000a00ULL,
0x0ffffff804067812ULL, 0x000fe400078ef814ULL, 0x000000202104723eULL, 0x000fe400000010ffULL,
0x0ffffff80d107812ULL, 0x000fe200078ef80eULL, 0x00000010060d7824ULL, 0x000fe200078e0205ULL,
0x0000541003027816ULL, 0x000fc40000000004ULL, 0x0000763203037816ULL, 0x000fe20000000004ULL,
0x0000001010107824ULL, 0x000fe200078e0205ULL, 0x000000242500723eULL, 0x000fe400000010ffULL,
0x0000002e2f04723eULL, 0x000fe200000010ffULL, 0x0000000209007388ULL, 0x0005e20000000a00ULL,
0x000000323305723eULL, 0x000fe400000010ffULL, 0x0000001a1b06723eULL, 0x000fe400000010ffULL,
0x0000000714147812ULL, 0x000fc400078ec0ffULL, 0x000000070e0e7812ULL, 0x000fc800078ec0ffULL,
0x1ffffff80e0e7812ULL, 0x000fe400078ef807ULL, 0x000000343502723eULL, 0x004fe400000010ffULL,
0x0000002a2b03723eULL, 0x000fe400000010ffULL, 0x0000541000127816ULL, 0x140fe40000000002ULL,
0x0000763200137816ULL, 0x000fe40000000002ULL, 0x0000541003027816ULL, 0x000fc40000000004ULL,
0x0000763203037816ULL, 0x000fe20000000004ULL, 0x000000120a007388ULL, 0x000fe20000000a00ULL,
0x0000541005047816ULL, 0x140fe40000000006ULL, 0x0000763205057816ULL, 0x000fe20000000006ULL,
0x000000020b007388ULL, 0x0005e20000000a00ULL, 0x0000001e1f00723eULL, 0x000fc600000010ffULL,
0x0004000408007388ULL, 0x0007e20000000a00ULL, 0x000000222302723eULL, 0x004fe400000010ffULL,
0x000000262703723eULL, 0x000fe200000010ffULL, 0x0000000000057919ULL, 0x008ea20000002600ULL,
0x000000363704723eULL, 0x000fe400000010ffULL, 0x0000541000127816ULL, 0x140fe40000000002ULL,
0x0000763200137816ULL, 0x000fe40000000002ULL, 0x0000541003027816ULL, 0x000fc40000000004ULL,
0x0000763203037816ULL, 0x000fe20000000004ULL, 0x0004001209007388ULL, 0x000fe80000000a00ULL,
0x000400020a007388ULL, 0x0007e20000000a00ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000000000d087984ULL, 0x000f220000000c00ULL, 0x0000000805007824ULL, 0x004fc600078e00ffULL,
0x0000000010107984ULL, 0x000ea20000000c00ULL, 0x0000000805057824ULL, 0x000fe200078e00ffULL,
0xfffffff8000c7812ULL, 0x000fc800078ee20cULL, 0xfffffff8050f7812ULL, 0x000fe400078ee20fULL,
0x000000040c0c7c10ULL, 0x000fe4000ff1e0ffULL, 0x000000040f0f7c10ULL, 0x000fc6000ff3e0ffULL,
0x000000ffff007224ULL, 0x000fe200000e06ffULL, 0x00005a000c027a11ULL, 0x048fe200078048ffULL,
0x000000ffff057224ULL, 0x000fe200008e06ffULL, 0x00005a000f047a11ULL, 0x040fe400078248ffULL,
0x00005b000c037a11ULL, 0x000fe400000f4c00ULL, 0x1ffffff814007812ULL, 0x000fe400078ef807ULL,
0x00005b000f057a11ULL, 0x000fc600008f4c05ULL, 0x0000001000027825ULL, 0x000fc800078e0002ULL,
0x000000100e047825ULL, 0x000fe200078e0004ULL, 0x0000000802007986ULL, 0x010fe8000c101d06ULL,
0x0000001004007986ULL, 0x004fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x000000050000720cULL, 0x000fe20003f06070ULL, 0xffffffffff077424ULL, 0x000fd800078e00ffULL,
0x000000023b088824ULL, 0x000fc800078e00ffULL, 0x0000640008088a24ULL, 0x000fc800078e0200ULL,
0x0000600008088625ULL, 0x000fe200078e0009ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00006800ff3c7624ULL, 0x000fe200078e00ffULL, 0x0000000608078981ULL, 0x0002a2000c1e1900ULL,
0x00006900ff3d7624ULL, 0x000fca00078e00ffULL, 0x000000063c3c7981ULL, 0x000722000c1e9900ULL,
0x000001ff0a00780cULL, 0x000fe20003f04070ULL, 0x0000000604047899ULL, 0x000fe2000800063fULL,
0x0000004000387824ULL, 0x000fe200078e00ffULL, 0x01860000ff087f8cULL, 0x002e62000c80043fULL,
0x0000004003397824ULL, 0x000fc600078e00ffULL, 0x00000004070a7c24ULL, 0x004fcc000f8e02ffULL,
0x00000e8000000947ULL, 0x000fea0003800000ULL, 0x00000038040c7217ULL, 0x00afe40007800000ULL,
0x00000003ff237819ULL, 0x000fe40000011602ULL, 0x000000700b247812ULL, 0x000fe200078ec0ffULL,
0x000000010c127824ULL, 0x000fe200078e0a38ULL, 0x00000004230c7810ULL, 0x000fe20007ffe0ffULL,
0x0000004003137824ULL, 0x000fe200078e0223ULL, 0x00000008230e7810ULL, 0x000fe40007ffe0ffULL,
0x000000120c00720cULL, 0x0c0fe20003f06070ULL, 0x000000010c0d7824ULL, 0x140fe200078e0202ULL,
0x0000000413037810ULL, 0x000fe20007ffe0ffULL, 0x000000080c107824ULL, 0x000fe200078e00ffULL,
0x000000130a147210ULL, 0x000fe20007f5e0ffULL, 0x000000010e0c7824ULL, 0x000fe200078e0202ULL,
0x000000030a037210ULL, 0x000fe20007f7e0ffULL, 0x000000080e117824ULL, 0x040fe200078e00ffULL,
0x000000120e00720cULL, 0x000fe20003f26070ULL, 0x000000ffff0e7224ULL, 0x000fe200010e06ffULL,
0x00005e00140f7a11ULL, 0x000fe200078440ffULL, 0x000000ffff1c7224ULL, 0x000fe200018e06ffULL,
0xfffffff811117812ULL, 0x000fc400078ee20cULL, 0x0000000c130c7810ULL, 0x000fe40007ffe0ffULL,
0x00005e0003177a11ULL, 0x040fe400078640ffULL, 0x0000000c0a0c7210ULL, 0x000fe40007fbe0ffULL,
0x00005f00031c7a11ULL, 0x000fe400018f441cULL, 0xfffffff810107812ULL, 0x000fe200078ee20dULL,
0x000000ffff227224ULL, 0x000fe200028e06ffULL, 0x0000000813037810ULL, 0x000fc40007ffe0ffULL,
0x00005f0014147a11ULL, 0x000fe400010f440eULL, 0x00000010130d7810ULL, 0x040fe40007ffe0ffULL,
0x00005e000c217a11ULL, 0x000fe400078a40ffULL, 0x00000014130e7810ULL, 0x000fe40007ffe0ffULL,
0x000000030a037210ULL, 0x040fe40007f9e0ffULL, 0x0000000d0a0d7210ULL, 0x000fc40007f5e0ffULL,
0x00005f000c227a11ULL, 0x000fe200028f4422ULL, 0x00000001230c7824ULL, 0x000fe200078e0202ULL,
0x0000000e0a0e7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff1b7224ULL, 0x000fe200020e06ffULL,
0x00005e0003187a11ULL, 0x000fe200078840ffULL, 0x000000ffff1a7224ULL, 0x000fe200010e06ffULL,
0x00005e000d197a11ULL, 0x000fe200078440ffULL, 0x000000ffff207224ULL, 0x000fe200018e06ffULL,
0x000000070c157812ULL, 0x000fe400078ec0ffULL, 0x00005e000e1f7a11ULL, 0x000fc400078640ffULL,
0x00000018130c7810ULL, 0x000fe40007ffe0ffULL, 0x00005f00031b7a11ULL, 0x000fe400020f441bULL,
0x00005f000d1a7a11ULL, 0x000fe400010f441aULL, 0x0000000c23037810ULL, 0x040fe40007ffe0ffULL,
0x00005f000e207a11ULL, 0x000fe400018f4420ULL, 0x00000010230d7810ULL, 0x000fe20007ffe0ffULL,
0x00000001030e7824ULL, 0x140fe200078e0202ULL, 0x0000000c0a1e7210ULL, 0x000fe20007fde0ffULL,
0x0000000803257824ULL, 0x000fe200078e00ffULL, 0x0000000f240c7210ULL, 0x000fe20007f7e0ffULL,
0x000000080d267824ULL, 0x000fe200078e00ffULL, 0x000000122300720cULL, 0x080fe20003f46070ULL,
0x000000ffff0f7224ULL, 0x000fe200030e06ffULL, 0x000000120300720cULL, 0x080fe20003fa6070ULL,
0x000000010d037824ULL, 0x040fe200078e0202ULL, 0x000000120d00720cULL, 0x000fe20003f86070ULL,
0x000000ffff0d7224ULL, 0x000fe200018e0614ULL, 0x00002000000b7811ULL, 0x000fc400078e70ffULL,
0x0ffffff815167812ULL, 0x000fe400078ef802ULL, 0x00005e001e1d7a11ULL, 0x000fe200078640ffULL,
0x0000001010107824ULL, 0x100fe200078e020bULL, 0xfffffff825147812ULL, 0x000fe200078ee20eULL,
0x0000001011117824ULL, 0x000fe200078e020bULL, 0xfffffff826157812ULL, 0x000fe200078ee203ULL,
0x0000001016037824ULL, 0x000fe200078e020bULL, 0x00005f001e1e7a11ULL, 0x000fe200018f440fULL,
0x0000001014147824ULL, 0x100fe200078e020bULL, 0x00000017240e7210ULL, 0x000fe20007f7e0ffULL,
0x0000001015157824ULL, 0x000fe200078e020bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c037faeULL, 0x0003e2000d101c46ULL, 0x0000001423167810ULL, 0x000fc40007ffe0ffULL,
0x000000ffff0f7224ULL, 0x000fe200018e061cULL, 0x0000001823177810ULL, 0x000fe40007ffe0ffULL,
0x000000121600720cULL, 0x040fe20003f46070ULL, 0x0000000816257824ULL, 0x000fe200078e00ffULL,
0x000000000e107faeULL, 0x0005e2000c101c46ULL, 0x00000018240c7210ULL, 0x002fe20007f7e0ffULL,
0x0000000116037824ULL, 0x100fe200078e0202ULL, 0x0000001c13187810ULL, 0x000fe20007ffe0ffULL,
0x0000000117167824ULL, 0x000fe400078e0202ULL, 0x000000ffff0d7224ULL, 0x000fe200018e061bULL,
0x000000180a187210ULL, 0x000fc40007fde0ffULL, 0x000000121700720cULL, 0x040fe20003f66070ULL,
0x0000000817177824ULL, 0x000fe200078e00ffULL, 0x000000000c117faeULL, 0x0003e2000c901c46ULL,
0x000000ffff1c7224ULL, 0x000fe200030e06ffULL, 0x00005e00181b7a11ULL, 0x040fe400078c40ffULL,
0xfffffff817167812ULL, 0x000fe400078ee216ULL, 0x00005f00181c7a11ULL, 0x000fe400030f441cULL,
0x00000021240e7210ULL, 0x004fe20007fde0ffULL, 0x0000001016167824ULL, 0x000fe200078e020bULL,
0x0000002013187810ULL, 0x000fc40007ffe0ffULL, 0x00000019240c7210ULL, 0x002fe20007f3e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200030e0622ULL, 0x0000001c23107810ULL, 0x040fe40007ffe0ffULL,
0x0000002023177810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0d7224ULL, 0x000fe200008e061aULL,
0x000000180a187210ULL, 0x000fe20007fde0ffULL, 0x0000000110117824ULL, 0x140fe200078e0202ULL,
0x000000121000720cULL, 0x0c0fe20003f06070ULL, 0x0000000810217824ULL, 0x000fe200078e00ffULL,
0x000000121700720cULL, 0x040fe20003f26070ULL, 0x0000000117107824ULL, 0x040fe200078e0202ULL,
0x000000000e147faeULL, 0x0003e2000e901c46ULL, 0x0000000817177824ULL, 0x000fe200078e00ffULL,
0xfffffff825037812ULL, 0x000fe200078ee203ULL, 0x000000ffff1a7224ULL, 0x000fe200030e06ffULL,
0x00005e0018197a11ULL, 0x040fe200078c40ffULL, 0x000000000c157faeULL, 0x0005e2000e101c46ULL,
0xfffffff817107812ULL, 0x000fe200078ee210ULL, 0x0000001003037824ULL, 0x000fe200078e020bULL,
0x00005f00181a7a11ULL, 0x000fc400030f441aULL, 0xfffffff821117812ULL, 0x000fe400078ee211ULL,
0x00000024230e7810ULL, 0x002fe40007ffe0ffULL, 0x00000024130f7810ULL, 0x000fe20007ffe0ffULL,
0x0000001011117824ULL, 0x000fe200078e020bULL, 0x000000120e00720cULL, 0x040fe20003f86070ULL,
0x000000080e147824ULL, 0x000fe200078e00ffULL, 0x0000001f240c7210ULL, 0x004fe40007fbe0ffULL,
0x0000000f0a177210ULL, 0x000fe20007fde0ffULL, 0x000000010e0f7824ULL, 0x000fc400078e0202ULL,
0x000000ffff0d7224ULL, 0x000fe200028e0620ULL, 0x0000001d240e7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff187224ULL, 0x000fe200030e06ffULL, 0xfffffff814147812ULL, 0x000fe400078ee20fULL,
0x000000000c037faeULL, 0x0003e2000d101c46ULL, 0x000000ffff0f7224ULL, 0x000fe200028e061eULL,
0x00005e0017157a11ULL, 0x000fe200078c40ffULL, 0x0000001014147824ULL, 0x000fc600078e020bULL,
0x000000000e167faeULL, 0x0005e2000d901c46ULL, 0x00005f0017177a11ULL, 0x000fe400030f4418ULL,
0x0000001b240c7210ULL, 0x002fe20007f5e0ffULL, 0x0000001010037824ULL, 0x000fc800078e020bULL,
0x000000ffff0d7224ULL, 0x000fe200010e061cULL, 0x00000019240e7210ULL, 0x044fe40007f7e0ffULL,
0x0000001524107210ULL, 0x000fe40007f5e0ffULL, 0x000000000c117faeULL, 0x0003e2000c101c46ULL,
0x000000ffff0f7224ULL, 0x000fe200018e061aULL, 0x0000003823157810ULL, 0x040fe40007ffe0ffULL,
0x0000003c23167810ULL, 0x000fe40007ffe0ffULL, 0x000000000e037faeULL, 0x0005e2000c901c46ULL,
0x000000121500720cULL, 0x000fc40003f26070ULL, 0x000000121600720cULL, 0x000fe20003f06070ULL,
0x000000ffff117224ULL, 0x002fe200010e0617ULL, 0x00000028130c7810ULL, 0x000fc80007ffe0ffULL,
0x0000000010147faeULL, 0x0003e2000e101c46ULL, 0x0000002823037810ULL, 0x044fe40007ffe0ffULL,
0x0000002c230e7810ULL, 0x000fe40007ffe0ffULL, 0x0000000c0a0f7210ULL, 0x000fe20007fde0ffULL,
0x00000001030d7824ULL, 0x040fe200078e0202ULL, 0x000000120300720cULL, 0x0c0fe20003fa6070ULL,
0x0000000803037824ULL, 0x000fe200078e00ffULL, 0x000000120e00720cULL, 0x040fe40003f86070ULL,
0x0000003023107810ULL, 0x042fe20007ffe0ffULL, 0x000000080e117824ULL, 0x000fe200078e00ffULL,
0x0000003423147810ULL, 0x000fc40007ffe0ffULL, 0x000000121000720cULL, 0x080fe40003f66070ULL,
0x000000121400720cULL, 0x040fe20003f46070ULL, 0x000000ffff127224ULL, 0x000fe200030e06ffULL,
0x00005e000f0c7a11ULL, 0x000fe200078c40ffULL, 0x0000000814177824ULL, 0x000fe200078e00ffULL,
0xfffffff803037812ULL, 0x000fe200078ee20dULL, 0x000000010e0d7824ULL, 0x000fe200078e0202ULL,
0x00005f000f127a11ULL, 0x000fe400030f4412ULL, 0x0000000c240c7210ULL, 0x000fe20007fde0ffULL,
0x0000001003037824ULL, 0x000fe200078e020bULL, 0x0000002c130e7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff8110f7812ULL, 0x000fe200078ee20dULL, 0x0000000110117824ULL, 0x000fe400078e0202ULL,
0x000000ffff0d7224ULL, 0x000fe200030e0612ULL, 0x0000000e0a187210ULL, 0x000fe20007fde0ffULL,
0x0000000810107824ULL, 0x000fe400078e00ffULL, 0x00000001140e7824ULL, 0x000fe200078e0202ULL,
0x000000000c037faeULL, 0x0003e2000e901c46ULL, 0x000000ffff147224ULL, 0x000fe200030e06ffULL,
0xfffffff810117812ULL, 0x000fe200078ee211ULL, 0x000000100f0f7824ULL, 0x000fe200078e020bULL,
0xfffffff817107812ULL, 0x000fc400078ee20eULL, 0x00000030130e7810ULL, 0x000fe20007ffe0ffULL,
0x0000001011117824ULL, 0x100fe200078e020bULL, 0x00005e0018127a11ULL, 0x000fe200078c40ffULL,
0x0000001010107824ULL, 0x000fe200078e020bULL, 0x0000000e0a177210ULL, 0x000fe20007fbe0ffULL,
0x00000008150e7824ULL, 0x000fe200078e00ffULL, 0x00005f0018187a11ULL, 0x000fe200030f4414ULL,
0x00000001160c7824ULL, 0x142fe400078e0202ULL, 0x0000000816147824ULL, 0x000fe200078e00ffULL,
0x00005e0017167a11ULL, 0x000fe200078c40ffULL, 0x0000000115037824ULL, 0x000fc400078e0202ULL,
0x000000ffff0d7224ULL, 0x000fe200028e06ffULL, 0x0000001224027210ULL, 0x000fe40007fbe0ffULL,
0xfffffff814147812ULL, 0x000fe400078ee20cULL, 0x00000034130c7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff80e0e7812ULL, 0x000fe200078ee203ULL, 0x000000ffff037224ULL, 0x000fe200028e0618ULL,
0x00005f0017177a11ULL, 0x000fe200030f440dULL, 0x0000001014147824ULL, 0x100fe200078e020bULL,
0x00000038130d7810ULL, 0x040fe20007ffe0ffULL, 0x000000100e127824ULL, 0x000fe200078e020bULL,
0x0000000c0a0c7210ULL, 0x000fe20007fbe0ffULL, 0x00000000020f7faeULL, 0x0003e2000e101c46ULL,
0x0000003c13137810ULL, 0x000fc40007ffe0ffULL, 0x0000000d0a0d7210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff157224ULL, 0x000fe200028e06ffULL, 0x000000130a137210ULL, 0x000fe40007fde0ffULL,
0x00005e000c0a7a11ULL, 0x000fe200078a40ffULL, 0x000000ffff0b7224ULL, 0x000fc600020e06ffULL,
0x00005f000c157a11ULL, 0x000fe200028f4415ULL, 0x000000ffff0f7224ULL, 0x002fe200030e06ffULL,
0x0000001624027210ULL, 0x040fe40007fbe0ffULL, 0x00005e000d0c7a11ULL, 0x000fe400078840ffULL,
0x00005e00130e7a11ULL, 0x000fe200078c40ffULL, 0x000000ffff037224ULL, 0x000fe200028e0617ULL,
0x0000000a240a7210ULL, 0x000fe40007fbe0ffULL, 0x00005f000d0d7a11ULL, 0x000fc400020f440bULL,
0x0000000c240c7210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200028e0615ULL,
0x00005f00130f7a11ULL, 0x000fe200030f440fULL, 0x0000000002117faeULL, 0x0003e2000d901c46ULL,
0x0000000e240e7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff0d7224ULL, 0x000fe400020e060dULL,
0x000000000a107faeULL, 0x0003e4000d101c46ULL, 0x000000ffff0f7224ULL, 0x000fe400028e060fULL,
0x000000000c127faeULL, 0x0003e8000c901c46ULL, 0x000000000e147faeULL, 0x0003e2000c101c46ULL,
0x00000d4000007947ULL, 0x000fea0003800000ULL, 0x00000008020e7811ULL, 0x04afe400078fe8ffULL,
0x00000004020c7811ULL, 0x000fc400078fe8ffULL, 0x0000000c02107811ULL, 0x000fe200078fe8ffULL,
0x000000010e0f7824ULL, 0x100fe200078e0202ULL, 0x0000001402147811ULL, 0x000fe200078fe8ffULL,
0x000000080e127824ULL, 0x000fe200078e00ffULL, 0x0000001802167811ULL, 0x000fe200078fe8ffULL,
0x000000010c037824ULL, 0x100fe200078e0202ULL, 0x00000020021a7811ULL, 0x000fe200078fe8ffULL,
0x000000080c0d7824ULL, 0x000fe200078e00ffULL, 0xfffffff8120f7812ULL, 0x000fe200078ee20fULL,
0x0000000110117824ULL, 0x100fe200078e0202ULL, 0x0000001002127811ULL, 0x000fe200078fe8ffULL,
0x0000000810137824ULL, 0x000fe200078e00ffULL, 0xfffffff80d0d7812ULL, 0x000fe200078ee203ULL,
0x0000000114157824ULL, 0x100fe200078e0202ULL, 0x00000024021c7811ULL, 0x000fe200078fe8ffULL,
0x0000000814187824ULL, 0x000fe200078e00ffULL, 0xfffffff813117812ULL, 0x000fe200078ee211ULL,
0x0000000112037824ULL, 0x100fe200078e0202ULL, 0x00000028021f7811ULL, 0x000fe200078fe8ffULL,
0x0000000812137824ULL, 0x000fe200078e00ffULL, 0xfffffff818157812ULL, 0x000fe200078ee215ULL,
0x0000000116177824ULL, 0x100fe200078e0202ULL, 0x0000001c02187811ULL, 0x000fe200078fe8ffULL,
0x0000000816197824ULL, 0x000fe200078e00ffULL, 0xfffffff813137812ULL, 0x000fe200078ee203ULL,
0x000000011a1b7824ULL, 0x100fe200078e0202ULL, 0x0000003002237811ULL, 0x000fe200078fe8ffULL,
0x000000081a1e7824ULL, 0x000fe200078e00ffULL, 0xfffffff819177812ULL, 0x000fe200078ee217ULL,
0x0000000118037824ULL, 0x100fe200078e0202ULL, 0x0000003402257811ULL, 0x000fe200078fe8ffULL,
0x0000000818197824ULL, 0x000fe200078e00ffULL, 0xfffffff81e1b7812ULL, 0x000fe200078ee21bULL,
0x000000011c1d7824ULL, 0x100fe200078e0202ULL, 0x0000003802277811ULL, 0x000fe200078fe8ffULL,
0x000000081c207824ULL, 0x000fe200078e00ffULL, 0xfffffff819197812ULL, 0x000fe200078ee203ULL,
0x000000011f037824ULL, 0x100fe200078e0202ULL, 0x0000200000317811ULL, 0x000fe200078e70ffULL,
0x0000000123247824ULL, 0x000fe200078e0202ULL, 0xfffffff8201e7812ULL, 0x000fe200078ee21dULL,
0x000000081f207824ULL, 0x000fe200078e00ffULL, 0x0000002c021d7811ULL, 0x000fe200078fe8ffULL,
0x0000000823267824ULL, 0x000fe200078e00ffULL, 0x000000700b4b7812ULL, 0x000fe200078ec0ffULL,
0x00000001390c7824ULL, 0x000fe200078e020cULL, 0xfffffff820207812ULL, 0x000fe200078ee203ULL,
0x000000011d217824ULL, 0x040fe200078e0202ULL, 0x0000003902037211ULL, 0x000fe200078fe8ffULL,
0x000000081d227824ULL, 0x000fe200078e00ffULL, 0xfffffff826247812ULL, 0x000fe200078ee224ULL,
0x0000000825267824ULL, 0x000fe200078e00ffULL, 0x000000030a4a7210ULL, 0x000fe20007f1e0ffULL,
0x00000001390e7824ULL, 0x000fe200078e020eULL, 0xfffffff822227812ULL, 0x000fe200078ee221ULL,
0x0000000125217824ULL, 0x000fe200078e0202ULL, 0x0000000c0a487210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff287224ULL, 0x000fe200000e06ffULL, 0x00005e004a497a11ULL, 0x000fe200078040ffULL,
0x0000000139107824ULL, 0x040fe200078e0210ULL, 0xfffffff826267812ULL, 0x000fe200078ee221ULL,
0x000000ffff217224ULL, 0x000fe200008e06ffULL, 0x00005e0048477a11ULL, 0x000fe200078240ffULL,
0x0000000139127824ULL, 0x040fe200078e0212ULL, 0x00005f004a4a7a11ULL, 0x000fe200000f4428ULL,
0x0000000139147824ULL, 0x040fe200078e0214ULL, 0x0000000e0a0e7210ULL, 0x000fe20007f1e0ffULL,
0x0000000139167824ULL, 0x040fe200078e0216ULL, 0x00005f0048487a11ULL, 0x000fe200008f4421ULL,
0x0000000139187824ULL, 0x000fe200078e0218ULL, 0x000000100a107210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff467224ULL, 0x000fe200000e06ffULL, 0x000000120a127210ULL, 0x000fe20007f5e0ffULL,
0x0000000127037824ULL, 0x040fe200078e0202ULL, 0x00005e000e457a11ULL, 0x000fe200078040ffULL,
0x000000ffff447224ULL, 0x000fe200008e06ffULL, 0x00005e0010437a11ULL, 0x000fe200078240ffULL,
0x000000ffff427224ULL, 0x000fe200010e06ffULL, 0x00005e0012417a11ULL, 0x000fe200078440ffULL,
0x00000008270c7824ULL, 0x000fe200078e00ffULL, 0x00005f000e467a11ULL, 0x000fe200000f4446ULL,
0x00000001391a7824ULL, 0x040fe200078e021aULL, 0x000000140a147210ULL, 0x000fe20007f1e0ffULL,
0x00000001391c7824ULL, 0x040fe200078e021cULL, 0x00005f0010447a11ULL, 0x000fe200008f4444ULL,
0x00000001391f7824ULL, 0x040fe200078e021fULL, 0x00005f0012427a11ULL, 0x000fe200010f4442ULL,
0x000000ffff407224ULL, 0x000fe200000e06ffULL, 0x000000160a3f7210ULL, 0x040fe20007f3e0ffULL,
0x00000001391d7824ULL, 0x040fe200078e021dULL, 0x000000180a3e7210ULL, 0x000fe20007f5e0ffULL,
0x0000000139237824ULL, 0x040fe200078e0223ULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee203ULL,
0x000000ffff0e7224ULL, 0x000fe200008e06ffULL, 0x00005e0014127a11ULL, 0x000fe200078040ffULL,
0x000000ffff037224ULL, 0x000fe200010e06ffULL, 0x00005e003e167a11ULL, 0x000fe200078240ffULL,
0x0000000139257824ULL, 0x040fe200078e0225ULL, 0x00005f0014407a11ULL, 0x000fe200000f4440ULL,
0x0000000139277824ULL, 0x000fe200078e0227ULL, 0x00005e003f147a11ULL, 0x040fe200078040ffULL,
0x000000100c307824ULL, 0x000fe200078e0231ULL, 0x00005f003e3e7a11ULL, 0x000fe200008f4403ULL,
0x000000101e2b7824ULL, 0x100fe200078e0231ULL, 0x0000001a0a1a7210ULL, 0x000fe20007f7e0ffULL,
0x00000010202c7824ULL, 0x100fe200078e0231ULL, 0x0000000202037211ULL, 0x000fe200078fe8ffULL,
0x00000010222d7824ULL, 0x100fe200078e0231ULL, 0x00005f003f3f7a11ULL, 0x000fe200000f440eULL,
0x000000ffff3d7224ULL, 0x000fe200018e06ffULL, 0x0000003c020e7811ULL, 0x000fe200078fe8ffULL,
0x00000010262f7824ULL, 0x100fe200078e0231ULL, 0x0000000703037812ULL, 0x000fe200078ec0ffULL,
0x00000010242e7824ULL, 0x100fe200078e0231ULL, 0x0000001c0a1c7210ULL, 0x000fe20007f9e0ffULL,
0x000000010e107824ULL, 0x100fe200078e0202ULL, 0x00005e001a187a11ULL, 0x040fe200078440ffULL,
0x000000100f217824ULL, 0x000fe200078e0231ULL, 0x0ffffff803037812ULL, 0x000fe200078ef802ULL,
0x0000000139027824ULL, 0x000fe200078e020eULL, 0x00005f001a3d7a11ULL, 0x000fe200010f443dULL,
0x000000ffff3a7224ULL, 0x000fe200020e06ffULL, 0x0000001f0a377210ULL, 0x000fe20007f7e0ffULL,
0x000000080e0e7824ULL, 0x000fe200078e00ffULL, 0x0000001d0a367210ULL, 0x040fe20007f1e0ffULL,
0x00000010031d7824ULL, 0x100fe200078e0231ULL, 0x000000230a357210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200018e06ffULL, 0x00005e001c1a7a11ULL, 0x000fe200078c40ffULL,
0x000000ffff037224ULL, 0x000fe200000e06ffULL, 0x000000250a347210ULL, 0x040fe20007f5e0ffULL,
0x000000100d1f7824ULL, 0x100fe200078e0231ULL, 0x000000270a337210ULL, 0x040fe20007f9e0ffULL,
0x0000001011237824ULL, 0x100fe200078e0231ULL, 0x000000020a0a7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff027224ULL, 0x000fe200008e06ffULL, 0x00005f001c3a7a11ULL, 0x000fe200030f443aULL,
0x000000ffff0b7224ULL, 0x000fe200010e06ffULL, 0x00005e00371c7a11ULL, 0x000fe200078640ffULL,
0x000000ffff327224ULL, 0x000fe200028e06ffULL, 0x00005e00361e7a11ULL, 0x040fe200078040ffULL,
0x0000001013257824ULL, 0x100fe200078e0231ULL, 0x00005e0035207a11ULL, 0x000fe200078240ffULL,
0x0000001015277824ULL, 0x100fe200078e0231ULL, 0x00005f0037377a11ULL, 0x000fe200018f440cULL,
0x0000001017287824ULL, 0x000fe200078e0231ULL, 0x00005f0036367a11ULL, 0x000fe200000f4403ULL,
0x000000ffff037224ULL, 0x000fe200020e06ffULL, 0x00005f0035357a11ULL, 0x000fe200008f4402ULL,
0x0000001019297824ULL, 0x100fe200078e0231ULL, 0x00005e0034227a11ULL, 0x000fe200078240ffULL,
0x000000101b2a7824ULL, 0x000fe200078e0231ULL, 0x00005e000a267a11ULL, 0x000fc400078640ffULL,
0x00005e0033247a11ULL, 0x000fe400078440ffULL, 0xfffffff80e107812ULL, 0x000fe400078ee210ULL,
0x000000494b027210ULL, 0x000fe40007f1e0ffULL, 0x00005f0034347a11ULL, 0x000fe200008f440bULL,
0x0000001010317824ULL, 0x000fe200078e0231ULL, 0x00005f000a327a11ULL, 0x000fe400018f4432ULL,
0x00005f0033337a11ULL, 0x000fe200010f4403ULL, 0x000000ffff037224ULL, 0x000fe200000e064aULL,
0x000000474b0a7210ULL, 0x000fc40007f3e0ffULL, 0x000000454b0c7210ULL, 0x040fe40007f5e0ffULL,
0x000000434b0e7210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200008e0648ULL,
0x000000414b107210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff0d7224ULL, 0x000fe200010e0646ULL,
0x000000124b127210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200018e0644ULL,
0x000000144b147210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff117224ULL, 0x000fe200028e0642ULL,
0x000000164b167210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff137224ULL, 0x000fe200020e0640ULL,
0x000000184b187210ULL, 0x040fe20007f5e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000021d7faeULL, 0x0003e2000b901c46ULL, 0x0000001a4b1a7210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff157224ULL, 0x000fe200000e063fULL, 0x0000001c4b1c7210ULL, 0x040fe20007fbe0ffULL,
0x000000000a1f7faeULL, 0x0005e2000b901c46ULL, 0x0000001e4b1e7210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff177224ULL, 0x000fe200008e063eULL, 0x000000204b207210ULL, 0x040fe20007f1e0ffULL,
0x000000000c217faeULL, 0x0007e2000b901c46ULL, 0x000000224b227210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff197224ULL, 0x000fe200010e063dULL, 0x000000244b247210ULL, 0x040fe20007f5e0ffULL,
0x000000000e237faeULL, 0x0007e2000b901c46ULL, 0x000000ffff1b7224ULL, 0x000fe200018e063aULL,
0x000000264b267210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff1d7224ULL, 0x002fe200028e0637ULL,
0x0000000010257faeULL, 0x0003e2000b901c46ULL, 0x000000ffff1f7224ULL, 0x004fc600020e0636ULL,
0x0000000012277faeULL, 0x0005e2000b901c46ULL, 0x000000ffff217224ULL, 0x008fc600000e0635ULL,
0x0000000014287faeULL, 0x0007e2000b901c46ULL, 0x000000ffff237224ULL, 0x000fc600008e0634ULL,
0x0000000016297faeULL, 0x0007e2000b901c46ULL, 0x000000ffff257224ULL, 0x002fc600010e0633ULL,
0x00000000182a7faeULL, 0x0007e2000b901c46ULL, 0x000000ffff277224ULL, 0x004fc600018e0632ULL,
0x000000001a2b7faeULL, 0x0007e8000b901c46ULL, 0x000000001c2c7faeULL, 0x0007e8000b901c46ULL,
0x000000001e2d7faeULL, 0x0007e8000b901c46ULL, 0x00000000202e7faeULL, 0x0007e8000b901c46ULL,
0x00000000222f7faeULL, 0x0007e8000b901c46ULL, 0x0000000024307faeULL, 0x0007e8000b901c46ULL,
0x0000000026317faeULL, 0x0007e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000027805ULL, 0x002fc40000015200ULL, 0x01860400ff0a7984ULL, 0x000e640000000800ULL,
0x800000000aff7812ULL, 0x002fc40007804809ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0d7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100d00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a020c7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e03ULL,
0x003d09000c00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400c00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0a7819ULL, 0x000fc8000001140bULL, 0x0000000c0a0a7211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060bULL, 0x000000020a0a7819ULL, 0x000fc8000000120bULL,
0x0000000a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010d0d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01860400ff0a7984ULL, 0x000e640000000800ULL, 0x800000000aff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000e640000000000ULL,
0x0000002000027824ULL, 0x002fca00078e0202ULL, 0x00000003ff037819ULL, 0x000fe40000011602ULL,
0x0000000f02027812ULL, 0x000fe400078ec0ffULL, 0x1ffffffe03037812ULL, 0x000fe400078ec0ffULL,
0x0000000102087810ULL, 0x040fe20007ffe0ffULL, 0x00000020020c7824ULL, 0x040fe400078e00ffULL,
0x0000000102097824ULL, 0x040fe400078e0203ULL, 0x00000001030a7824ULL, 0x040fe200078e0208ULL,
0x0000001003037810ULL, 0x000fe20007ffe0ffULL, 0x00000020020b7824ULL, 0x000fe200078e00ffULL,
0x0000001f09097812ULL, 0x000fc400078ec0ffULL, 0x0000001f0a0a7812ULL, 0x000fe400078ec0ffULL,
0x000001e00b097812ULL, 0x000fe200078ee209ULL, 0x00000001020b7824ULL, 0x100fe200078e0203ULL,
0x000001e00c0a7812ULL, 0x000fe200078ee20aULL, 0x0000000108037824ULL, 0x000fe400078e0203ULL,
0x0000000009107984ULL, 0x000e62000000cc00ULL, 0x0000002002087824ULL, 0x040fe200078e00ffULL,
0x0000001f0b0b7812ULL, 0x000fe200078ec0ffULL, 0x0000002002027824ULL, 0x000fe200078e00ffULL,
0x000000000a0c7984ULL, 0x000ea2000000cc00ULL, 0x0000001f03037812ULL, 0x000fc400078ec0ffULL,
0x000001e0080b7812ULL, 0x000fe400078ee20bULL, 0x000001e002037812ULL, 0x000fe200078ee203ULL,
0x000000ffff147224ULL, 0x00afe400078e0010ULL, 0x000000ffff157224ULL, 0x000fe400078e0012ULL,
0x000000ffff177224ULL, 0x004fe400078e000eULL, 0x000000ffff167224ULL, 0x000fe400078e000cULL,
0x000000ffff0e7224ULL, 0x000fc400078e000dULL, 0x000000ffff0c7224ULL, 0x000fe200078e0011ULL,
0x0000001409007388ULL, 0x000fe2000000cc00ULL, 0x000000ffff0d7224ULL, 0x000fca00078e0013ULL,
0x0000000c0a007388ULL, 0x000fe8000000cc00ULL, 0x00000000030c7984ULL, 0x000e68000000cc00ULL,
0x000000000b107984ULL, 0x000ea2000000cc00ULL, 0x000000ffff1b7224ULL, 0x002fe400078e000eULL,
0x000000ffff1a7224ULL, 0x000fc400078e000cULL, 0x000000ffff0e7224ULL, 0x000fe400078e000dULL,
0x000000ffff187224ULL, 0x004fe400078e0010ULL, 0x000000ffff197224ULL, 0x000fe400078e0012ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0011ULL, 0x000000ffff0d7224ULL, 0x000fe200078e0013ULL,
0x000000180b007388ULL, 0x0003e8000000cc00ULL, 0x0000000c03007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01860000ff0a7f8cULL, 0x002e62000c80043fULL,
0x000000ffff0d7224ULL, 0x000fc600078e00ffULL, 0x0000000000027805ULL, 0x000fc80000015200ULL,
0x01860400ff087984ULL, 0x000ea40000000800ULL, 0x8000000008ff7812ULL, 0x006fc4000780480bULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100d00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fcc0000015200ULL,
0x00000008020c7210ULL, 0x000fca0007f1e1ffULL, 0x0000000109097824ULL, 0x000fe200000e0e03ULL,
0x003d09000c00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400c00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc80000011409ULL, 0x0000000c08087211ULL, 0x000fca00078110ffULL,
0x000000ffff097224ULL, 0x000fca00000e0609ULL, 0x0000000208087819ULL, 0x000fc80000001209ULL,
0x000000080000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010d0d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01860400ff087984ULL, 0x000e640000000800ULL, 0x8000000008ff7812ULL, 0x002fe4000780480bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff0600720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x00000000003a7919ULL, 0x000e620000000000ULL,
0x000064003b3b7a24ULL, 0x000fe200078e02ffULL, 0x00018688003d7811ULL, 0x000fe200078e18ffULL,
0x3d8000003c3c7820ULL, 0x010fe20000410000ULL, 0xffffffff063e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x00018608003f7811ULL, 0x000fe200078e28ffULL,
0x000000ffff427224ULL, 0x000fc800078e0000ULL, 0x0000010040437824ULL, 0x000fe200078e0238ULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x000000430400720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x01cfea0003800000ULL, 0x000000ffff447224ULL, 0x000fe200078e0041ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff457224ULL, 0x000fe200078e00ffULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fc4000001ff00ULL, 0x0000000145027810ULL, 0x020fe20007ffe0ffULL,
0x00001ac000007945ULL, 0x000fe20003800000ULL, 0x000000ffff467224ULL, 0x000fe200078e0045ULL,
0x0000000144417812ULL, 0x000fe200078e0cffULL, 0x00000004072e7c24ULL, 0x010fe2000f8e02ffULL,
0x0000004002287211ULL, 0x040fe200078ff8ffULL, 0x000000ffff457224ULL, 0x000fe200078e0002ULL,
0x000000020200780cULL, 0x000fc40003f06070ULL, 0x0000000128037810ULL, 0x000fe40007ffe0ffULL,
0x0000000102657812ULL, 0x000fe400078ec0ffULL, 0x000000060300720cULL, 0x000fda0003f26070ULL,
0x00000db000009947ULL, 0x000fea0003800000ULL, 0x0000010028027824ULL, 0x000fe200078e0238ULL,
0x00000003ff4f7819ULL, 0x002fe2000001163aULL, 0x00000008654c7824ULL, 0x000fe400078e00ffULL,
0x00000002004d7824ULL, 0x000fe200078e0241ULL, 0x0000000204037217ULL, 0x000fe40007800000ULL,
0x000000084f2b7810ULL, 0x040fe40007ffe0ffULL, 0x000000044f287810ULL, 0x000fe20007ffe0ffULL,
0x0000000103477824ULL, 0x000fe200078e0a02ULL, 0x0000000c4f317810ULL, 0x000fe20007ffe0ffULL,
0x000000012b2a7824ULL, 0x000fe200078e023aULL, 0x000000104f527810ULL, 0x000fe20007ffe0ffULL,
0x000000082b507824ULL, 0x000fe200078e00ffULL, 0x000000472800720cULL, 0x000fe20003f46070ULL,
0x0000000139027824ULL, 0x000fe200078e024fULL, 0x000000144f537810ULL, 0x000fe20007ffe0ffULL,
0x0000000139037824ULL, 0x040fe200078e0228ULL, 0xfffffff850507812ULL, 0x000fe200078ee22aULL,
0x0000000128297824ULL, 0x100fe200078e023aULL, 0x000000022e2a7210ULL, 0x000fe20007f3e0ffULL,
0x00000008284e7824ULL, 0x000fe200078e00ffULL, 0x000000032e287210ULL, 0x000fe20007f9e0ffULL,
0x0000000139027824ULL, 0x000fe200078e022bULL, 0x000000472b00720cULL, 0x000fe20003f66070ULL,
0x000000ffff037224ULL, 0x000fe200008e06ffULL, 0x00005e002a2c7a11ULL, 0x000fe200078240ffULL,
0x0000000131327824ULL, 0x000fe200078e023aULL, 0xfffffff84e4e7812ULL, 0x000fe200078ee229ULL,
0x000000ffff297224ULL, 0x000fe200020e06ffULL, 0x00005f002a2d7a11ULL, 0x000fe200008f4403ULL,
0x0000000139037824ULL, 0x000fe200078e0231ULL, 0x00005e0028347a11ULL, 0x000fe200078840ffULL,
0x0000000831517824ULL, 0x000fe200078e00ffULL, 0x000000022e2a7210ULL, 0x000fe20007f3e0ffULL,
0x0000000139027824ULL, 0x000fe200078e0252ULL, 0x00005f0028357a11ULL, 0x000fe200020f4429ULL,
0x0000000852547824ULL, 0x000fe200078e00ffULL, 0x000000032e287210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff037224ULL, 0x000fe200008e06ffULL, 0x00005e002a367a11ULL, 0x040fe200078240ffULL,
0x00000008535a7824ULL, 0x000fe200078e00ffULL, 0x0000001c4f567810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff297224ULL, 0x000fe200020e06ffULL, 0x00005f002a377a11ULL, 0x000fe200008f4403ULL,
0x0000000139037824ULL, 0x000fe200078e0253ULL, 0x00005e0028487a11ULL, 0x000fc400078840ffULL,
0x000000022e2b7210ULL, 0x000fe40007f3e0ffULL, 0x00005f0028497a11ULL, 0x000fe400020f4429ULL,
0x000000032e287210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff037224ULL, 0x000fe200008e06ffULL,
0x00005e002b4a7a11ULL, 0x000fe400078240ffULL, 0x000000184f557810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff297224ULL, 0x000fe200020e06ffULL, 0x00005f002b4b7a11ULL, 0x000fe200008f4403ULL,
0x0000000139037824ULL, 0x040fe200078e0256ULL, 0x00005e00282a7a11ULL, 0x040fe200078840ffULL,
0x0000000139027824ULL, 0x000fe200078e0255ULL, 0x000000204f577810ULL, 0x000fe20007ffe0ffULL,
0x00000008555b7824ULL, 0x000fe200078e00ffULL, 0x00005f00282b7a11ULL, 0x000fc400020f4429ULL,
0x000000032e037210ULL, 0x040fe40007f9e0ffULL, 0x000000022e297210ULL, 0x000fe40007f3e0ffULL,
0x000000473100720cULL, 0x000fe20003fa6070ULL, 0x000000ffff287224ULL, 0x000fe200020e06ffULL,
0x00005e0003027a11ULL, 0x000fe200078840ffULL, 0x000000ffff2f7224ULL, 0x000fe200008e06ffULL,
0x00005e0029307a11ULL, 0x000fe400078240ffULL, 0x00005f0003037a11ULL, 0x000fe200020f4428ULL,
0x000000014f287824ULL, 0x000fe200078e023aULL, 0x00005f0029317a11ULL, 0x000fc400008f442fULL,
0x000000474f00720cULL, 0x000fe40003f26070ULL, 0x0000000728297812ULL, 0x000fe200078ec0ffULL,
0x0000000139287824ULL, 0x000fe200078e0257ULL, 0xfffffff851517812ULL, 0x000fe200078ee232ULL,
0x0000000152327824ULL, 0x100fe200078e023aULL, 0x0ffffff8292f7812ULL, 0x100fe400078ef83aULL,
0x000000282e297210ULL, 0x000fe40007f9e0ffULL, 0xfffffff84c4c7812ULL, 0x000fc400078ee23aULL,
0x000020004d4d7811ULL, 0x000fe200078e68ffULL, 0x000000ffff337224ULL, 0x000fe200020e06ffULL,
0x000000244f587810ULL, 0x000fe20007ffe0ffULL, 0x000000104c2c7825ULL, 0x000fe200078e002cULL,
0x000000475200720cULL, 0x000fe40003f86070ULL, 0xfffffff854527812ULL, 0x000fe200078ee232ULL,
0x000000102f2f7824ULL, 0x000fe200078e024dULL, 0x00005e0029287a11ULL, 0x000fe200078c40ffULL,
0x0000000139327824ULL, 0x000fe200078e0258ULL, 0x000000284f597810ULL, 0x000fe20007ffe0ffULL,
0x0000000153547824ULL, 0x000fe200078e023aULL, 0x00005f0029297a11ULL, 0x000fe200030f4433ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c2f7faeULL, 0x0003e2000c901c46ULL,
0x000000322e337210ULL, 0x000fe20007f3e0ffULL, 0x000000104c2a7825ULL, 0x000fe200078e002aULL,
0xfffffff85a547812ULL, 0x000fc400078ee254ULL, 0x00005e0033327a11ULL, 0x000fe200078c40ffULL,
0x000000104c307825ULL, 0x000fe200078e0030ULL, 0x0000002c4f5a7810ULL, 0x000fc60007ffe0ffULL,
0x000000104c027825ULL, 0x000fc800078e0002ULL, 0x000000104e2f7824ULL, 0x002fe400078e024dULL,
0x000000104c2c7825ULL, 0x000fc800078e0034ULL, 0x0000000139347824ULL, 0x000fe200078e0259ULL,
0x000000002c2f7faeULL, 0x0003e2000d101c46ULL, 0x000000ffff4e7224ULL, 0x000fe200008e06ffULL,
0x000000475300720cULL, 0x000fe20003f26070ULL, 0x0000000155537824ULL, 0x000fe400078e023aULL,
0x000000104c287825ULL, 0x000fe200078e0028ULL, 0x00005f0033337a11ULL, 0x000fe400030f444eULL,
0xfffffff85b537812ULL, 0x000fe200078ee253ULL, 0x00000008565b7824ULL, 0x000fc400078e00ffULL,
0x000000104c327825ULL, 0x000fe200078e0032ULL, 0x000000342e2d7210ULL, 0x002fc60007f5e0ffULL,
0x00000010502f7824ULL, 0x000fe200078e024dULL, 0x00005e002d2c7a11ULL, 0x000fe200078c40ffULL,
0x000000104c347825ULL, 0x000fc800078e0036ULL, 0x000000ffff4e7224ULL, 0x000fe200010e06ffULL,
0x000000475500720cULL, 0x000fe20003f46070ULL, 0x0000000139367824ULL, 0x000fe200078e025aULL,
0x000000304f557810ULL, 0x000fe20007ffe0ffULL, 0x00000000342f7faeULL, 0x0003e2000d901c46ULL,
0x00005f002d2d7a11ULL, 0x000fe200030f444eULL, 0x0000000156507824ULL, 0x000fc800078e023aULL,
0x000000104c2c7825ULL, 0x000fe200078e002cULL, 0xfffffff85b507812ULL, 0x000fc600078ee250ULL,
0x00000008575b7824ULL, 0x000fe200078e00ffULL, 0x000000362e357210ULL, 0x002fe20007f7e0ffULL,
0x00000010512f7824ULL, 0x000fe400078e024dULL, 0x000000104c367825ULL, 0x000fe200078e0048ULL,
0x00005e0035347a11ULL, 0x000fc600078c40ffULL, 0x0000000139487824ULL, 0x000fe200078e0255ULL,
0x00000000362f7faeULL, 0x0003e2000e901c46ULL, 0x000000ffff4e7224ULL, 0x000fe200018e06ffULL,
0x000000475600720cULL, 0x080fe20003f66070ULL, 0x0000000157517824ULL, 0x000fe200078e023aULL,
0x000000482e497210ULL, 0x000fe40007fbe0ffULL, 0x000000344f567810ULL, 0x000fe40007ffe0ffULL,
0x00005f0035357a11ULL, 0x000fe200030f444eULL, 0x000000ffff4e7224ULL, 0x000fe200028e06ffULL,
0x00005e0049487a11ULL, 0x000fe200078c40ffULL, 0x00000010522f7824ULL, 0x002fe200078e024dULL,
0x000000475700720cULL, 0x000fe20003fa6070ULL, 0x000000104c367825ULL, 0x000fe200078e004aULL,
0x00005f0049497a11ULL, 0x000fc400030f444eULL, 0x000000384f577810ULL, 0x000fe20007ffe0ffULL,
0x00000010534a7824ULL, 0x000fe200078e024dULL, 0x00000000362f7faeULL, 0x0003e2000e101c46ULL,
0x0000003c4f537810ULL, 0x000fe20007ffe0ffULL, 0x00000001584e7824ULL, 0x140fe200078e023aULL,
0x000000475800720cULL, 0x040fe20003f86070ULL, 0x0000000858587824ULL, 0x000fe200078e00ffULL,
0xfffffff85b517812ULL, 0x000fe200078ee251ULL, 0x00000008594f7824ULL, 0x000fe400078e00ffULL,
0x000000015a527824ULL, 0x000fe200078e023aULL, 0xfffffff8584e7812ULL, 0x000fe200078ee24eULL,
0x000000104c347825ULL, 0x000fc800078e0034ULL, 0x00000001392f7824ULL, 0x002fca00078e0256ULL,
0x0000002f2e377210ULL, 0x000fe20007fde0ffULL, 0x00000010542f7824ULL, 0x000fc800078e024dULL,
0x000000ffff4b7224ULL, 0x000fe200030e06ffULL, 0x00005e0037367a11ULL, 0x040fe200078c40ffULL,
0x000000002a2f7faeULL, 0x0003e6000c901c46ULL, 0x00005f0037377a11ULL, 0x000fe200030f444bULL,
0x00000001394b7824ULL, 0x000fe200078e0257ULL, 0x00000000304a7faeULL, 0x0005e8000d101c46ULL,
0x0000004b2e4b7210ULL, 0x000fe20007f3e0ffULL, 0x00000001592f7824ULL, 0x002fc600078e023aULL,
0x00005e004b2a7a11ULL, 0x000fe200078440ffULL, 0x00000001392b7824ULL, 0x000fe400078e0253ULL,
0x000000ffff307224ULL, 0x004fe200008e06ffULL, 0xfffffff84f4f7812ULL, 0x000fe200078ee22fULL,
0x0000001051317824ULL, 0x100fe200078e024dULL, 0x0000002b2e2f7210ULL, 0x000fe20007fde0ffULL,
0x000000104e4a7824ULL, 0x100fe200078e024dULL, 0x00005f004b2b7a11ULL, 0x000fe200010f4430ULL,
0x0000001050307824ULL, 0x000fe200078e024dULL, 0x000000475a00720cULL, 0x0c0fe20003f46070ULL,
0x000000ffff4b7224ULL, 0x000fe200030e06ffULL, 0x00005e002f2e7a11ULL, 0x000fe200078c40ffULL,
0x000000085a5a7824ULL, 0x000fe200078e00ffULL, 0x0000000002307faeULL, 0x0003e2000d901c46ULL,
0x000000475500720cULL, 0x080fe20003f66070ULL, 0x000000104c2a7825ULL, 0x000fe200078e002aULL,
0x00005f002f2f7a11ULL, 0x000fe200030f444bULL, 0x0000000028317faeULL, 0x0005e2000e901c46ULL,
0x000000475700720cULL, 0x000fc40003fa6070ULL, 0x000000475300720cULL, 0x080fe20003fc6070ULL,
0x00000000324a7faeULL, 0x0007e2000e101c46ULL, 0x000000475600720cULL, 0x080fe20003f86070ULL,
0x000000104c2e7825ULL, 0x000fe200078e002eULL, 0x000000475900720cULL, 0x000fe40003f26070ULL,
0xfffffff85a527812ULL, 0x000fe200078ee252ULL, 0x0000000155027824ULL, 0x102fe400078e023aULL,
0x0000000156037824ULL, 0x100fe400078e023aULL, 0x0000000157287824ULL, 0x004fc400078e023aULL,
0x0000000855557824ULL, 0x000fe400078e00ffULL, 0x0000000856567824ULL, 0x000fe400078e00ffULL,
0x0000000857577824ULL, 0x000fe200078e00ffULL, 0xfffffff855027812ULL, 0x000fe200078ee202ULL,
0x0000000153297824ULL, 0x040fe200078e023aULL, 0xfffffff856037812ULL, 0x000fe200078ee203ULL,
0x0000000853537824ULL, 0x000fe200078e00ffULL, 0xfffffff857287812ULL, 0x000fe200078ee228ULL,
0x000000104f307824ULL, 0x000fc400078e024dULL, 0x0000001052317824ULL, 0x000fe200078e024dULL,
0xfffffff853297812ULL, 0x000fe200078ee229ULL, 0x0000001002327824ULL, 0x108fe200078e024dULL,
0x000000002c307faeULL, 0x0003e2000c901c46ULL, 0x0000001003337824ULL, 0x100fe400078e024dULL,
0x0000001028477824ULL, 0x100fe200078e024dULL, 0x0000000034317faeULL, 0x0003e2000d101c46ULL,
0x00000010294d7824ULL, 0x000fe400078e024dULL, 0x000000104c027825ULL, 0x000fc800078e0048ULL,
0x000000104c287825ULL, 0x000fe200078e0036ULL, 0x0000000002327faeULL, 0x0003e8000d901c46ULL,
0x0000000028337faeULL, 0x0003e8000e101c46ULL, 0x000000002a477faeULL, 0x0003e8000e901c46ULL,
0x000000002e4d7faeULL, 0x0003e2000f101c46ULL, 0x00000c6000007947ULL, 0x000fea0003800000ULL,
0x0000000c3a2d7811ULL, 0x042fe200078fe8ffULL, 0x00000008656a7824ULL, 0x000fe200078e00ffULL,
0x000000043a027811ULL, 0x000fc400078fe8ffULL, 0x000000083a2c7811ULL, 0x040fe200078fe8ffULL,
0x000000012d297824ULL, 0x140fe200078e023aULL, 0x000000183a377811ULL, 0x040fe200078fe8ffULL,
0x000000082d587824ULL, 0x000fe200078e00ffULL, 0x000000103a2f7811ULL, 0x000fe200078fe8ffULL,
0x0000000102037824ULL, 0x100fe200078e023aULL, 0x000000143a307811ULL, 0x000fe200078fe8ffULL,
0x0000000802567824ULL, 0x000fe200078e00ffULL, 0xfffffff858587812ULL, 0x000fe200078ee229ULL,
0x000000012c287824ULL, 0x100fe200078e023aULL, 0x000000243a4a7811ULL, 0x000fe200078fe8ffULL,
0x000000082c577824ULL, 0x000fe200078e00ffULL, 0xfffffff856567812ULL, 0x000fe200078ee203ULL,
0x0000000137297824ULL, 0x040fe200078e023aULL, 0x0000001c3a477811ULL, 0x040fe200078fe8ffULL,
0x00000008375b7824ULL, 0x000fe200078e00ffULL, 0xfffffff857577812ULL, 0x000fe200078ee228ULL,
0x000000012f037824ULL, 0x140fe200078e023aULL, 0x000000203a487811ULL, 0x000fe200078fe8ffULL,
0x000000082f597824ULL, 0x000fe200078e00ffULL, 0xfffffff85b5b7812ULL, 0x000fe200078ee229ULL,
0x0000000130287824ULL, 0x100fe200078e023aULL, 0x000000283a4e7811ULL, 0x000fe200078fe8ffULL,
0x00000008305a7824ULL, 0x000fe200078e00ffULL, 0xfffffff859597812ULL, 0x000fe200078ee203ULL,
0x000000014a297824ULL, 0x000fe200078e023aULL, 0x0000002c3a4f7811ULL, 0x000fe200078fe8ffULL,
0x000000084a5e7824ULL, 0x000fe200078e00ffULL, 0xfffffff85a5a7812ULL, 0x000fe200078ee228ULL,
0x0000000147037824ULL, 0x140fe200078e023aULL, 0x000000303a507811ULL, 0x000fe200078fe8ffULL,
0x00000008475c7824ULL, 0x000fe200078e00ffULL, 0xfffffff85e5e7812ULL, 0x000fe200078ee229ULL,
0x0000000148287824ULL, 0x100fe200078e023aULL, 0x000000393a297211ULL, 0x000fe200078fe8ffULL,
0x00000008485d7824ULL, 0x000fe200078e00ffULL, 0xfffffff85c5c7812ULL, 0x000fe200078ee203ULL,
0x000000014e037824ULL, 0x040fe200078e023aULL, 0x0000002e29297210ULL, 0x080fe20007f3e0ffULL,
0x000000084e5f7824ULL, 0x000fe200078e00ffULL, 0xfffffff85d5d7812ULL, 0x000fe200078ee228ULL,
0x000000014f287824ULL, 0x040fe200078e023aULL, 0x000000343a517811ULL, 0x040fe200078fe8ffULL,
0x000000084f607824ULL, 0x000fe200078e00ffULL, 0xfffffff85f5f7812ULL, 0x000fe200078ee203ULL,
0x000000ffff2b7224ULL, 0x000fe200008e06ffULL, 0x000000383a527811ULL, 0x000fe200078fe8ffULL,
0x0000000139037824ULL, 0x000fe200078e0202ULL, 0xfffffff860607812ULL, 0x000fe200078ee228ULL,
0x00000001502a7824ULL, 0x140fe200078e023aULL, 0x00005e0029287a11ULL, 0x000fe200078240ffULL,
0x0000000850617824ULL, 0x000fe200078e00ffULL, 0x0000002e03037210ULL, 0x080fe20007f5e0ffULL,
0x0000000151317824ULL, 0x000fe200078e023aULL, 0x00005f0029297a11ULL, 0x000fe200008f442bULL,
0x00000001392b7824ULL, 0x000fe200078e0230ULL, 0xfffffff861617812ULL, 0x000fe200078ee22aULL,
0x0000000851627824ULL, 0x000fe200078e00ffULL, 0x0000003c3a547811ULL, 0x000fe200078fe8ffULL,
0x000000ffff2a7224ULL, 0x000fe200010e06ffULL, 0x0000002e2b2b7210ULL, 0x080fe20007f3e0ffULL,
0x0000000139337824ULL, 0x000fe200078e022cULL, 0x00005e0003027a11ULL, 0x000fe200078440ffULL,
0x0000000152327824ULL, 0x000fe200078e023aULL, 0xfffffff862627812ULL, 0x000fe200078ee231ULL,
0x0000000139317824ULL, 0x000fe200078e022dULL, 0x00005f0003037a11ULL, 0x000fe200010f442aULL,
0x00000001392d7824ULL, 0x000fe200078e022fULL, 0x0000002e33337210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff2f7224ULL, 0x000fe200008e06ffULL, 0x00005e002b2a7a11ULL, 0x000fe200078240ffULL,
0x0000000852637824ULL, 0x000fe200078e00ffULL, 0x0000002e2d2d7210ULL, 0x080fe20007f9e0ffULL,
0x00000001394b7824ULL, 0x000fe200078e0237ULL, 0x0000002e31317210ULL, 0x080fe20007f7e0ffULL,
0x000000ffff367224ULL, 0x000fe200010e06ffULL, 0x00005f002b2b7a11ULL, 0x000fe200008f442fULL,
0x00000001392f7824ULL, 0x000fe200078e024aULL, 0xfffffff863637812ULL, 0x000fe200078ee232ULL,
0x000000ffff347224ULL, 0x000fe200020e06ffULL, 0x00005e002d2c7a11ULL, 0x000fe200078840ffULL,
0x0000000139377824ULL, 0x000fe200078e0248ULL, 0x00005e0033327a11ULL, 0x000fe200078440ffULL,
0x000000ffff357224ULL, 0x000fe200018e06ffULL, 0x00005e0031307a11ULL, 0x000fe200078640ffULL,
0x0000000139497824ULL, 0x000fe200078e0247ULL, 0x0000002e2f2f7210ULL, 0x080fe20007f3e0ffULL,
0x0000000139517824ULL, 0x000fe200078e0251ULL, 0x00005f002d2d7a11ULL, 0x000fe200020f4434ULL,
0x0000000139537824ULL, 0x000fe200078e0252ULL, 0x00005f0033337a11ULL, 0x000fe200010f4436ULL,
0x0000000139557824ULL, 0x000fe200078e0254ULL, 0x0000002e37377210ULL, 0x000fc40007f9e0ffULL,
0x00005f0031317a11ULL, 0x000fe200018f4435ULL, 0x000000ffff357224ULL, 0x000fe200008e06ffULL,
0x0000002e4b4b7210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff477224ULL, 0x000fe200020e06ffULL,
0x00005e002f347a11ULL, 0x000fe400078240ffULL, 0x0000002e49497210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff4d7224ULL, 0x000fe200010e06ffULL, 0x00005e0037367a11ULL, 0x000fe400078840ffULL,
0x00005e004b4a7a11ULL, 0x000fe200078440ffULL, 0x000000ffff4c7224ULL, 0x000fe200018e06ffULL,
0x00005f002f357a11ULL, 0x000fe200008f4435ULL, 0x00000001392f7824ULL, 0x000fe200078e024eULL,
0x00005e0049487a11ULL, 0x000fe200078640ffULL, 0x00000002004e7824ULL, 0x000fe200078e0241ULL,
0x00005f0037377a11ULL, 0x000fc400020f4447ULL, 0x00005f004b4b7a11ULL, 0x000fe200010f444dULL,
0x00000001394d7824ULL, 0x040fe200078e024fULL, 0x0000003a3a477211ULL, 0x000fe200078fe8ffULL,
0x00000001394f7824ULL, 0x000fe200078e0250ULL, 0x0000002e2f2f7210ULL, 0x080fe20007fde0ffULL,
0x0000000154507824ULL, 0x040fe200078e023aULL, 0x00005f0049497a11ULL, 0x000fe200018f444cULL,
0x0000000854547824ULL, 0x000fe200078e00ffULL, 0x00000007474c7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff477224ULL, 0x000fe200030e06ffULL, 0x0000002e4d4d7210ULL, 0x000fc40007fbe0ffULL,
0x0000002e4f4f7210ULL, 0x080fe40007f9e0ffULL, 0x0000002e51517210ULL, 0x080fe40007f3e0ffULL,
0x0000002e53537210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff697224ULL, 0x000fe200020e06ffULL,
0x0000002e55557210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff687224ULL, 0x000fe200008e06ffULL,
0x00005e002f2e7a11ULL, 0x040fe200078c40ffULL, 0x000000ffff677224ULL, 0x000fe200010e06ffULL,
0x000020004e647811ULL, 0x000fe200078e68ffULL, 0x000000ffff4e7224ULL, 0x000fe200028e06ffULL,
0x0ffffff84c4c7812ULL, 0x100fe200078ef83aULL, 0x000000ffff667224ULL, 0x000fe200018e06ffULL,
0xfffffff86a6a7812ULL, 0x000fe200078ee23aULL, 0x0000001056567824ULL, 0x100fe200078e0264ULL,
0x00005f002f2f7a11ULL, 0x000fe200030f4447ULL, 0x000000104c477824ULL, 0x000fe200078e0264ULL,
0xfffffff854507812ULL, 0x000fe200078ee250ULL, 0x000000106a287825ULL, 0x000fe200078e0028ULL,
0x00005e004d4c7a11ULL, 0x000fc400078a40ffULL, 0x00005e0053527a11ULL, 0x000fe200078440ffULL,
0x000000106a027825ULL, 0x000fe200078e0002ULL, 0x00005f004d4d7a11ULL, 0x000fe200028f444eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028477faeULL, 0x0003e2000b901c46ULL,
0x00005e004f4e7a11ULL, 0x000fe200078840ffULL, 0x0000001057577824ULL, 0x100fe200078e0264ULL,
0x00005e0055547a11ULL, 0x000fe200078640ffULL, 0x0000001058587824ULL, 0x100fe200078e0264ULL,
0x0000000002567faeULL, 0x0005e2000b901c46ULL, 0x0000001059597824ULL, 0x100fe200078e0264ULL,
0x00005f004f4f7a11ULL, 0x000fe200020f4469ULL, 0x000000105a5a7824ULL, 0x100fe200078e0264ULL,
0x00005f0053537a11ULL, 0x000fe200010f4467ULL, 0x000000105b5b7824ULL, 0x000fe200078e0264ULL,
0x00005f0055557a11ULL, 0x000fe200018f4466ULL, 0x000000105c5c7824ULL, 0x000fc400078e0264ULL,
0x000000105d5d7824ULL, 0x100fe400078e0264ULL, 0x000000105e5e7824ULL, 0x100fe400078e0264ULL,
0x000000105f5f7824ULL, 0x100fe400078e0264ULL, 0x0000001060607824ULL, 0x100fe400078e0264ULL,
0x0000001061617824ULL, 0x100fe400078e0264ULL, 0x0000001062627824ULL, 0x000fc400078e0264ULL,
0x0000001063637824ULL, 0x000fe400078e0264ULL, 0x000000106a327825ULL, 0x000fc800078e0032ULL,
0x0000001050647824ULL, 0x000fe200078e0264ULL, 0x00005e0051507a11ULL, 0x040fe200078240ffULL,
0x000000106a307825ULL, 0x040fe200078e0030ULL, 0x0000000032577faeULL, 0x0005e4000b901c46ULL,
0x00005f0051517a11ULL, 0x000fe200008f4468ULL, 0x000000106a2c7825ULL, 0x040fe200078e002cULL,
0x0000000030587faeULL, 0x0005e6000b901c46ULL, 0x000000106a2a7825ULL, 0x040fe200078e002aULL,
0x000000002c597faeULL, 0x0005e6000b901c46ULL, 0x000000106a4a7825ULL, 0x040fe200078e004aULL,
0x000000002a5a7faeULL, 0x0005e6000b901c46ULL, 0x000000106a487825ULL, 0x040fe200078e0048ULL,
0x000000004a5b7faeULL, 0x0005e6000b901c46ULL, 0x000000106a367825ULL, 0x040fe200078e0036ULL,
0x00000000485c7faeULL, 0x0005e6000b901c46ULL, 0x000000106a347825ULL, 0x040fe200078e0034ULL,
0x00000000365d7faeULL, 0x0005e6000b901c46ULL, 0x000000106a287825ULL, 0x042fe200078e002eULL,
0x00000000345e7faeULL, 0x0005e6000b901c46ULL, 0x000000106a2e7825ULL, 0x040fe200078e004cULL,
0x00000000285f7faeULL, 0x0005e6000b901c46ULL, 0x000000106a4c7825ULL, 0x040fe200078e004eULL,
0x000000002e607faeULL, 0x0005e6000b901c46ULL, 0x000000106a4e7825ULL, 0x040fe200078e0050ULL,
0x000000004c617faeULL, 0x0005e6000b901c46ULL, 0x000000106a507825ULL, 0x040fe200078e0052ULL,
0x000000004e627faeULL, 0x0005e6000b901c46ULL, 0x000000106a527825ULL, 0x000fe200078e0054ULL,
0x0000000050637faeULL, 0x0005e8000b901c46ULL, 0x0000000052647faeULL, 0x0005e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff6500720cULL, 0x000fe20003f25270ULL,
0x000000a000007945ULL, 0x000fd80003800000ULL, 0x0000008000009947ULL, 0x000fea0003800000ULL,
0x0000000442427810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff077424ULL, 0x000fc600078e00ffULL,
0x000000054200720cULL, 0x000fda0003f26070ULL, 0x0000004000001947ULL, 0x000fea0003800000ULL,
0x000000023b027824ULL, 0x006fe400078e0242ULL, 0x00000004ff037424ULL, 0x000fc800078e00ffULL,
0x0000600002027625ULL, 0x000fca00078e0003ULL, 0x0000000602077981ULL, 0x000324000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000ffff477224ULL, 0x002fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xfffffff83a027812ULL, 0x024fe200078ec0ffULL, 0x00000002002c7824ULL, 0x000fe200078e0244ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000001472f7810ULL, 0x000fe40007ffe0ffULL,
0x0000000702027812ULL, 0x000fe400078ef83aULL, 0x000020002c2c7811ULL, 0x000fe400078e68ffULL,
0x000000203a2d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000102037824ULL, 0x000fc400078e0247ULL,
0x0000000802287824ULL, 0x040fe200078e00ffULL, 0xfffffff82d2d7812ULL, 0x000fe200078ec0ffULL,
0x0000000102027824ULL, 0x000fc600078e022fULL, 0xfffffff828037812ULL, 0x040fe400078ee203ULL,
0xfffffff828027812ULL, 0x000fe400078ee202ULL, 0x000000072d2d7812ULL, 0x000fe200078ef83aULL,
0x0000001003037824ULL, 0x100fe400078e022cULL, 0x0000001002027824ULL, 0x000fe400078e022cULL,
0x000000012d2e7824ULL, 0x040fe200078e0247ULL, 0x000000000334783bULL, 0x000e620000000200ULL,
0x000000082d307824ULL, 0x000fc400078e00ffULL, 0x000000012d2f7824ULL, 0x040fe200078e022fULL,
0x000000000228783bULL, 0x000ea20000000200ULL, 0x000000082d2d7824ULL, 0x000fe200078e00ffULL,
0xfffffff8302e7812ULL, 0x000fc800078ee22eULL, 0xfffffff82d2f7812ULL, 0x000fe200078ee22fULL,
0x000000102e2e7824ULL, 0x000fc800078e022cULL, 0x000000102f2f7824ULL, 0x000fe200078e022cULL,
0x000000002e30783bULL, 0x000eea0000000200ULL, 0x000000002f2c783bULL, 0x000ee20000000200ULL,
0x0000003400ae7306ULL, 0x002fe20000009400ULL, 0x00000018ff037819ULL, 0x000fe20000011434ULL,
0x0001000034587824ULL, 0x000fe200078e00ffULL, 0x00000018ff7e7819ULL, 0x000fc40000011437ULL,
0x00000018ff4e7819ULL, 0x004fe40000011428ULL, 0x00000018ff587819ULL, 0x000fe20000011458ULL,
0x0000003400b27306ULL, 0x000e620000005400ULL, 0x00000018ff8c7819ULL, 0x000fe40000011435ULL,
0x00000018ff857819ULL, 0x000fe40000011436ULL, 0x00000018ff4b7819ULL, 0x000fe40000011429ULL,
0x00000018ff4c7819ULL, 0x000fe2000001142bULL, 0x0000003400937306ULL, 0x000462000000d400ULL,
0x00000018ff4d7819ULL, 0x000fe2000001142aULL, 0x0000010032d57824ULL, 0x008fe200078e00ffULL,
0x00000018ff7b7819ULL, 0x000fe20000011430ULL, 0x0001000033d67824ULL, 0x000fe200078e00ffULL,
0x00000018ff707819ULL, 0x000fc40000011431ULL, 0x00000018ffd57819ULL, 0x000fe200000114d5ULL,
0x0000002800957306ULL, 0x000fe20000009400ULL, 0x0000010034347824ULL, 0x004fe200078e00ffULL,
0x000000b2ae00720bULL, 0x002fe20003f3d000ULL, 0x0000010033ae7824ULL, 0x000fe200078e00ffULL,
0x00000018ff667819ULL, 0x000fe40000011433ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000002800947306ULL, 0x000fe20000005400ULL, 0x00000018ffae7819ULL, 0x000fc400000114aeULL,
0x00000018ff6f7819ULL, 0x000fe40000011432ULL, 0x00000018ff597819ULL, 0x000fe4000001142cULL,
0x0000000193931812ULL, 0x000fe200078efcffULL, 0x0000003400bb7306ULL, 0x000fe20000209400ULL,
0x00000018ffdf7819ULL, 0x000fe400000114d6ULL, 0x00000018ff5c7819ULL, 0x000fe4000001142dULL,
0x00000018ff5f7819ULL, 0x000fc4000001142eULL, 0x00000018ff627819ULL, 0x000fe2000001142fULL,
0x0000003400bc7306ULL, 0x000e700000205400ULL, 0x00000034009e7306ULL, 0x0004f0000020d400ULL,
0x0000002800577306ULL, 0x000fe2000000d400ULL, 0x0001000036347824ULL, 0x004fe200078e00ffULL,
0x000000bcbb00720bULL, 0x002fc80003fdd000ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000037009d7306ULL, 0x000fee0000009400ULL, 0x000000019e9e6812ULL, 0x008fe200078efcffULL,
0x0000003400c97306ULL, 0x000ff00000209400ULL, 0x0000003400cb7306ULL, 0x000ff00000205400ULL,
0x00000034008b7306ULL, 0x0003f0000020d400ULL, 0x00000037009f7306ULL, 0x000fe20000005400ULL,
0x0001000037347824ULL, 0x002fca00078e00ffULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000003700807306ULL, 0x0003f0000000d400ULL, 0x0000003400cc7306ULL, 0x000fe20000209400ULL,
0x0000010037377824ULL, 0x002fca00078e00ffULL, 0x00000018ff377819ULL, 0x000fe40000011437ULL,
0x0000003400ca7306ULL, 0x000ff00000205400ULL, 0x0000003400847306ULL, 0x0003f0000020d400ULL,
0x0000003500a97306ULL, 0x000fe20000009400ULL, 0x0001000028347824ULL, 0x002fc400078e00ffULL,
0x0000010028287824ULL, 0x000fc600078e00ffULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000018ff287819ULL, 0x000fe20000011428ULL, 0x0000003500ab7306ULL, 0x000e700000005400ULL,
0x0000003400c17306ULL, 0x000ff00000209400ULL, 0x0000003400c27306ULL, 0x000fe20000205400ULL,
0x000000aba900720bULL, 0x002fce0003f9d000ULL, 0x00000034006b7306ULL, 0x000ff0000020d400ULL,
0x0000002800c07306ULL, 0x000ff00000209400ULL, 0x0000002800bf7306ULL, 0x000ff00000205400ULL,
0x0000002800347306ULL, 0x0003f0000020d400ULL, 0x0000005800b77306ULL, 0x000fe20000209400ULL,
0x000100002a287824ULL, 0x002fca00078e00ffULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x0000005800b87306ULL, 0x000e700000205400ULL, 0x00000058009c7306ULL, 0x0005f0000020d400ULL,
0x00000035008d7306ULL, 0x0006e2000000d400ULL, 0x0001000035587824ULL, 0x004fe200078e00ffULL,
0x000000b8b700720bULL, 0x002fc80003f5d000ULL, 0x00000018ff587819ULL, 0x000fe40000011458ULL,
0x0000003700d37306ULL, 0x000fe20000209400ULL, 0x0000010035357824ULL, 0x008fca00078e00ffULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x0000003700d47306ULL, 0x000fe20000205400ULL,
0x000000018d8d4812ULL, 0x000fe400078efcffULL, 0x000000019c9c2812ULL, 0x000fca00078efcffULL,
0x0000003700837306ULL, 0x000ff0000020d400ULL, 0x0000002800887306ULL, 0x000ff00000209400ULL,
0x0000002800877306ULL, 0x000ff00000205400ULL, 0x0000002800377306ULL, 0x0003f0000020d400ULL,
0x0000008500a57306ULL, 0x000fe20000209400ULL, 0x000100002b287824ULL, 0x002fca00078e00ffULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x0000008500a37306ULL, 0x000e700000205400ULL,
0x0000003600a87306ULL, 0x000ff00000009400ULL, 0x0000003600ac7306ULL, 0x000ea20000005400ULL,
0x000000a3a500720bULL, 0x002fce0003f9d000ULL, 0x0000003600867306ULL, 0x0002f0000000d400ULL,
0x0000003500c87306ULL, 0x000fe20000209400ULL, 0x0000010036367824ULL, 0x002fe200078e00ffULL,
0x000000aca800720bULL, 0x004fe20003f7d000ULL, 0x0000000846a87824ULL, 0x000fe200078e0247ULL,
0x0000000247477810ULL, 0x000fe20007ffe0ffULL, 0x000100002cac7824ULL, 0x000fe200078e00ffULL,
0x00000018ff367819ULL, 0x000fe20000011436ULL, 0x00000002a8a87824ULL, 0x000fe200078e00ffULL,
0x0000003500c77306ULL, 0x000e640000205400ULL, 0x00000018ffac7819ULL, 0x000fc400000114acULL,
0x000000a83aa97211ULL, 0x000fe400078fe0ffULL, 0x00000002a8a87810ULL, 0x000fe40007ffe0ffULL,
0x0000003500a47306ULL, 0x000462000020d400ULL, 0x0000000186863812ULL, 0x008fe400078efcffULL,
0x000000a83aa87211ULL, 0x000fca00078fe0ffULL, 0x0000002900027306ULL, 0x000fe20000009400ULL,
0x0001000029357824ULL, 0x004fe200078e00ffULL, 0x000000c7c800720bULL, 0x002fc80003fdd000ULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x0000002900907306ULL, 0x000fee0000005400ULL,
0x00000001a4a46812ULL, 0x000fe200078efcffULL, 0x0000002900547306ULL, 0x0003e2000000d400ULL,
0x000000cacc00720bULL, 0x000fce0003fdd000ULL, 0x00000028006c7306ULL, 0x000fe20000209400ULL,
0x0000010029297824ULL, 0x002fca00078e00ffULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x00000028006d7306ULL, 0x000fe20000205400ULL, 0x0000000184846812ULL, 0x000fce00078efcffULL,
0x0000002800677306ULL, 0x0003f0000020d400ULL, 0x0000002b008e7306ULL, 0x000fe20000009400ULL,
0x0001000030287824ULL, 0x002fca00078e00ffULL, 0x00000018ff7d7819ULL, 0x000fe40000011428ULL,
0x0000002b00917306ULL, 0x000ff00000005400ULL, 0x0000002b00517306ULL, 0x0003f0000000d400ULL,
0x0000003600ce7306ULL, 0x000fe20000209400ULL, 0x000001002b2b7824ULL, 0x002fca00078e00ffULL,
0x00000018ff2b7819ULL, 0x000fe4000001142bULL, 0x0000003600cd7306ULL, 0x000ff00000205400ULL,
0x00000036008a7306ULL, 0x000ff0000020d400ULL, 0x0000008500857306ULL, 0x000e70000020d400ULL,
0x0000002900b67306ULL, 0x000ff00000209400ULL, 0x0000002900b57306ULL, 0x000fe20000205400ULL,
0x0000000185854812ULL, 0x002fce00078efcffULL, 0x0000002900367306ULL, 0x000ff0000020d400ULL,
0x0000005800c57306ULL, 0x000ff00000209400ULL, 0x0000005800c67306ULL, 0x000e700000205400ULL,
0x0000007d00287306ULL, 0x000ff00000209400ULL, 0x0000007d00297306ULL, 0x000ea20000205400ULL,
0x000000c6c500720bULL, 0x002fce0003f3d000ULL, 0x0000002b00687306ULL, 0x000ff00000209400ULL,
0x0000002b00697306ULL, 0x000fe20000205400ULL, 0x000000292800720bULL, 0x004fe20003f9d000ULL,
0x000100002d297824ULL, 0x000fcc00078e00ffULL, 0x0000002b006a7306ULL, 0x0003f0000020d400ULL,
0x0000005800a27306ULL, 0x000ea2000020d400ULL, 0x00010000312b7824ULL, 0x002fca00078e00ffULL,
0x00000018ff7c7819ULL, 0x000fe4000001142bULL, 0x0000007d007d7306ULL, 0x000e70000020d400ULL,
0x0000008c00b07306ULL, 0x000fe20000209400ULL, 0x00000001a2a21812ULL, 0x004fc400078efcffULL,
0x000000cdce00720bULL, 0x000fca0003f3d000ULL, 0x0000008c00ad7306ULL, 0x000ea20000205400ULL,
0x000000017d7d4812ULL, 0x002fce00078efcffULL, 0x0000007c002b7306ULL, 0x000fe20000209400ULL,
0x000000018a8a1812ULL, 0x000fce00078efcffULL, 0x0000007c00d77306ULL, 0x000e620000205400ULL,
0x000000adb000720bULL, 0x004fce0003f5d000ULL, 0x0000000300897306ULL, 0x000ff00000209400ULL,
0x0000000300aa7306ULL, 0x000ea20000205400ULL, 0x000000d72b00720bULL, 0x002fce0003f9d000ULL,
0x0000002a00927306ULL, 0x000ff00000009400ULL, 0x0000002a008f7306ULL, 0x000fe20000005400ULL,
0x000000aa8900720bULL, 0x004fe40003fbd000ULL, 0x000000073a897812ULL, 0x000fc800078ec0ffULL,
0x0000000889ad7812ULL, 0x000fe200078ef83aULL, 0x0000002a00527306ULL, 0x0003e8000000d400ULL,
0x00000001ada97824ULL, 0x040fe400078e02a9ULL, 0x00000001ada87824ULL, 0x000fe400078e02a8ULL,
0x0000003000b37306ULL, 0x000fe20000009400ULL, 0x000001002a2a7824ULL, 0x002fca00078e00ffULL,
0x00000018ff2a7819ULL, 0x000fe4000001142aULL, 0x0000003000b47306ULL, 0x000e700000005400ULL,
0x0000003000767306ULL, 0x0004f0000000d400ULL, 0x0000008c008c7306ULL, 0x000ee2000020d400ULL,
0x0000010030307824ULL, 0x004fe200078e00ffULL, 0x000000b4b300720bULL, 0x002fc80003f3d000ULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x0000007c007c7306ULL, 0x000e6e000020d400ULL,
0x0000000176761812ULL, 0x008fe200078efcffULL, 0x0000007e00a17306ULL, 0x000fe20000209400ULL,
0x000000018c8c2812ULL, 0x000fc400078efcffULL, 0x0000009f9d00720bULL, 0x000fe40003f5d000ULL,
0x000000767d76723eULL, 0x000fc600000010ffULL, 0x0000007e00a07306ULL, 0x000ea20000205400ULL,
0x000000017c7c4812ULL, 0x002fce00078efcffULL, 0x0000002a00827306ULL, 0x000fe20000209400ULL,
0x0000000180802812ULL, 0x000fc800078efcffULL, 0x000000808484723eULL, 0x000fc600000010ffULL,
0x0000002a00817306ULL, 0x000fe20000205400ULL, 0x000000a0a100720bULL, 0x004fce0003f7d000ULL,
0x0000002a00587306ULL, 0x000ff0000020d400ULL, 0x000000d500dc7306ULL, 0x000ff00000209400ULL,
0x000000d500db7306ULL, 0x000e700000205400ULL, 0x0000003000d87306ULL, 0x000ff00000209400ULL,
0x00000030002a7306ULL, 0x000ea20000205400ULL, 0x000000dbdc00720bULL, 0x002fce0003f9d000ULL,
0x00000030007f7306ULL, 0x0002f0000020d400ULL, 0x0000003100b17306ULL, 0x000fe20000009400ULL,
0x0001000032307824ULL, 0x002fe200078e00ffULL, 0x0000002ad800720bULL, 0x004fc80003fdd000ULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x0000003100af7306ULL, 0x000fee0000005400ULL,
0x000000017f7f6812ULL, 0x008fe200078efcffULL, 0x0000003100717306ULL, 0x0003f0000000d400ULL,
0x0000003200a77306ULL, 0x000fe20000009400ULL, 0x0000010031317824ULL, 0x002fca00078e00ffULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x0000003200a67306ULL, 0x000ff00000005400ULL,
0x00000032006e7306ULL, 0x000ff0000000d400ULL, 0x0000000300037306ULL, 0x000e70000020d400ULL,
0x0000003000dd7306ULL, 0x000ff00000209400ULL, 0x0000003000de7306ULL, 0x000fe20000205400ULL,
0x0000000103035812ULL, 0x002fc400078efcffULL, 0x000000cbc900720bULL, 0x000fe40003fbd000ULL,
0x0000009e0303723eULL, 0x000fc600000010ffULL, 0x0000003000327306ULL, 0x000ff0000020d400ULL,
0x000000ae00aa7306ULL, 0x000fe20000209400ULL, 0x000000018b8b5812ULL, 0x000fe400078efcffULL,
0x000000d4d300720bULL, 0x000fca0003fbd000ULL, 0x000000ae00ab7306ULL, 0x000ff00000205400ULL,
0x000000ae00897306ULL, 0x0003e2000020d400ULL, 0x0000000183835812ULL, 0x000fe400078efcffULL,
0x000000afb100720bULL, 0x000fca0003fbd000ULL, 0x0000007e007e7306ULL, 0x000ea2000020d400ULL,
0x00000020adae7824ULL, 0x042fe400078e00ffULL, 0x00000020adad7824ULL, 0x000fc600078e00ffULL,
0xffffffe0aea97812ULL, 0x000fe400078ee2a9ULL, 0x000000d500307306ULL, 0x000e62000020d400ULL,
0xffffffe0ada87812ULL, 0x000fe400078ee2a8ULL, 0x00000010a9287824ULL, 0x000fe200078e00ffULL,
0x0000000171715812ULL, 0x000fc800078efcffULL, 0x0000007b00d07306ULL, 0x000fe20000209400ULL,
0x000000017e7e3812ULL, 0x004fe400078efcffULL, 0x000000a6a700720bULL, 0x000fe40003f7d000ULL,
0x000000717c7c723eULL, 0x000fc600000010ffULL, 0x0000007b00d27306ULL, 0x000ea20000205400ULL,
0x0000000130304812ULL, 0x002fce00078efcffULL, 0x0000007000cf7306ULL, 0x000fe20000209400ULL,
0x000000016e6e3812ULL, 0x000fe400078efcffULL, 0x000000949500720bULL, 0x000fca0003f7d000ULL,
0x0000007000d17306ULL, 0x000e620000205400ULL, 0x000000d2d000720bULL, 0x004fce0003f5d000ULL,
0x0000006600c37306ULL, 0x000fe20000209400ULL, 0x0000000157573812ULL, 0x000fce00078efcffULL,
0x0000006600c47306ULL, 0x000ea20000205400ULL, 0x000000d1cf00720bULL, 0x002fce0003f3d000ULL,
0x0000003100da7306ULL, 0x000ff00000209400ULL, 0x0000003100d97306ULL, 0x000e620000205400ULL,
0x000000c4c300720bULL, 0x004fce0003f9d000ULL, 0x0000002c007a7306ULL, 0x000ff00000009400ULL,
0x0000002c00797306ULL, 0x000fe20000005400ULL, 0x000000d9da00720bULL, 0x002fce0003fdd000ULL,
0x0000002c00507306ULL, 0x0003f0000000d400ULL, 0x0000007b007b7306ULL, 0x000ea2000020d400ULL,
0x000001002c2c7824ULL, 0x002fca00078e00ffULL, 0x00000018ff2c7819ULL, 0x000fe4000001142cULL,
0x0000007000707306ULL, 0x000e70000020d400ULL, 0x0000006600667306ULL, 0x000ee2000020d400ULL,
0x000000017b7b2812ULL, 0x004fc400078efcffULL, 0x000000dedd00720bULL, 0x000fca0003f5d000ULL,
0x0000002c00a07306ULL, 0x000fe20000209400ULL, 0x0000000170701812ULL, 0x002fce00078efcffULL,
0x0000002c00a17306ULL, 0x000fe20000205400ULL, 0x0000000166664812ULL, 0x008fe400078efcffULL,
0x0000000132322812ULL, 0x000fe400078efcffULL, 0x000000abaa00720bULL, 0x000fe40003f5d000ULL,
0x0000006e326e723eULL, 0x000fe200000010ffULL, 0x0000002c009f7306ULL, 0x0003f0000020d400ULL,
0x0000004e00987306ULL, 0x000fe20000209400ULL, 0x00000018ff2c7819ULL, 0x002fc40000011429ULL,
0x000000002828783bULL, 0x000e620000000200ULL, 0x0000000189892812ULL, 0x000fe400078efcffULL,
0x0000008f9200720bULL, 0x000fe40003f5d000ULL, 0x0000004e00997306ULL, 0x000ea20000205400ULL,
0x000000896689723eULL, 0x000fce00000010ffULL, 0x00000033009b7306ULL, 0x000fe60000009400ULL,
0x0000000152522812ULL, 0x000fca00078efcffULL, 0x00000033009a7306ULL, 0x000ee20000005400ULL,
0x000000999800720bULL, 0x004fce0003f9d000ULL, 0x0000003100317306ULL, 0x000eb0000020d400ULL,
0x000000df00d57306ULL, 0x000fe20000209400ULL, 0x0000009a9b00720bULL, 0x008fce0003f3d000ULL,
0x000000df00d67306ULL, 0x000ee20000205400ULL, 0x0000000131316812ULL, 0x004fc800078efcffULL,
0x00000031707d723eULL, 0x000fc600000010ffULL, 0x0000004e004e7306ULL, 0x000ea8000020d400ULL,
0x0000007c2814723cULL, 0x002fe80000041814ULL, 0x0000003300657306ULL, 0x000e62000000d400ULL,
0x000000d6d500720bULL, 0x008fce0003fdd000ULL, 0x0000004b00967306ULL, 0x000fe20000209400ULL,
0x000000014e4e4812ULL, 0x004fe400078efcffULL, 0x000000b5b600720bULL, 0x000fca0003f9d000ULL,
0x0000004b00977306ULL, 0x000ea20000205400ULL, 0x0000000165651812ULL, 0x002fe400078efcffULL,
0x000000bfc000720bULL, 0x000fca0003f3d000ULL, 0x000000df00337306ULL, 0x000e62000020d400ULL,
0x0000000136364812ULL, 0x000fe400078efcffULL, 0x000000797a00720bULL, 0x000fca0003f9d000ULL,
0x0000004b004b7306ULL, 0x000ee2000020d400ULL, 0x000000979600720bULL, 0x004fe40003f7d000ULL,
0x0000000134341812ULL, 0x000fca00078efcffULL, 0x0000002d00727306ULL, 0x000fe20000009400ULL,
0x0000000133336812ULL, 0x002fe400078efcffULL, 0x000000900200720bULL, 0x000fe40003fdd000ULL,
0x000000939c02723eULL, 0x000fe400000010ffULL, 0x0000000150504812ULL, 0x000fe200078efcffULL,
0x0000002d00737306ULL, 0x000e620000005400ULL, 0x000000014b4b3812ULL, 0x008fe400078efcffULL,
0x000000818200720bULL, 0x000fe20003f7d000ULL, 0x000000022808723cULL, 0x000b680000041808ULL,
0x0000002d004f7306ULL, 0x0004e2000000d400ULL, 0x0000000154546812ULL, 0x000fc400078efcffULL,
0x000000868b02723eULL, 0x020fe200000010ffULL, 0x000100002f8b7824ULL, 0x000fe200078e00ffULL,
0x0000008a8503723eULL, 0x000fe200000010ffULL, 0x000001002e8a7824ULL, 0x000fe200078e00ffULL,
0x000000837e85723eULL, 0x000fe200000010ffULL, 0x0000006f00be7306ULL, 0x000fe20000209400ULL,
0x000001002d2d7824ULL, 0x004fe200078e00ffULL, 0x0000000158583812ULL, 0x000fe400078efcffULL,
0x000000737200720bULL, 0x002fe20003f5d000ULL, 0x000000022820723cULL, 0x000be20000041820ULL,
0x00000018ff907819ULL, 0x000fc4000001142dULL, 0x0000006f00bd7306ULL, 0x000e620000205400ULL,
0x000000a48c2d723eULL, 0x000fe200000010ffULL, 0x000100002e8c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8a7819ULL, 0x000fe4000001148aULL, 0x00000084281c723cULL, 0x000f64000004181cULL,
0x000000344e03723eULL, 0x020fe200000010ffULL, 0x0000003500ba7306ULL, 0x000fe20000209400ULL,
0x00000018ff8c7819ULL, 0x000fe4000001148cULL, 0x000000014f4f2812ULL, 0x008fc400078efcffULL,
0x000000696800720bULL, 0x000fe40003f5d000ULL, 0x00000018ff8b7819ULL, 0x000fe2000001148bULL,
0x0000003500b97306ULL, 0x000ea20000205400ULL, 0x000000bdbe00720bULL, 0x002fce0003fbd000ULL,
0x0000002c00a67306ULL, 0x000fe40000209400ULL, 0x000000016a6a2812ULL, 0x000fcc00078efcffULL,
0x0000002c009a7306ULL, 0x000e620000205400ULL, 0x000000b9ba00720bULL, 0x004fce0003f3d000ULL,
0x0000002c00947306ULL, 0x0005f0000020d400ULL, 0x0000006f006f7306ULL, 0x000ee2000020d400ULL,
0x0000008da22c723eULL, 0x004fe200000010ffULL, 0x000001002f8d7824ULL, 0x000fe200078e00ffULL,
0x0000009aa600720bULL, 0x002fc80003f9d000ULL, 0x00000018ff8d7819ULL, 0x000fe2000001148dULL,
0x0000003500357306ULL, 0x000e62000020d400ULL, 0x0000002c2824723cULL, 0x000b6e0000041824ULL,
0x0000005900747306ULL, 0x000fe20000209400ULL, 0x00000010a82c7824ULL, 0x020fe200078e00ffULL,
0x000000016f6f5812ULL, 0x008fc400078efcffULL, 0x000000c2c100720bULL, 0x000fe40003fbd000ULL,
0x0000000194944812ULL, 0x000fe400078efcffULL, 0x0000005900757306ULL, 0x000ea20000205400ULL,
0x0000000135351812ULL, 0x002fe400078efcffULL, 0x000000878800720bULL, 0x000fe40003f3d000ULL,
0x000000306f6f723eULL, 0x000fe400000010ffULL, 0x000000653388723eULL, 0x000fe200000010ffULL,
0x0000002e00637306ULL, 0x000fe20000009400ULL, 0x000000016b6b5812ULL, 0x000fc400078efcffULL,
0x000000918e00720bULL, 0x000fe20003fbd000ULL, 0x0000006e2810723cULL, 0x040fe20000041810ULL,
0x000000576b02723eULL, 0x000fe400000010ffULL, 0x000000543554723eULL, 0x000fe200000010ffULL,
0x0000002e00647306ULL, 0x000fe20000005400ULL, 0x000000757400720bULL, 0x004fe40003f7d000ULL,
0x0000000137371812ULL, 0x000fe200078efcffULL, 0x00000088280c723cULL, 0x000fe2000004180cULL,
0x0000004f9494723eULL, 0x000fc400000010ffULL, 0x000000523752723eULL, 0x000fe200000010ffULL,
0x0000002e004a7306ULL, 0x000fe2000000d400ULL, 0x0000000151515812ULL, 0x000fce00078efcffULL,
0x0000002f00557306ULL, 0x000ff00000009400ULL, 0x0000002f00567306ULL, 0x000ff00000005400ULL,
0x0000002f00497306ULL, 0x0003f0000000d400ULL, 0x0000005900597306ULL, 0x000ea2000020d400ULL,
0x000000002c2c783bULL, 0x002e6e0000000200ULL, 0x0000004c00487306ULL, 0x000ff00000209400ULL,
0x0000004c00537306ULL, 0x000ee20000205400ULL, 0x0000000159593812ULL, 0x004fc400078efcffULL,
0x0000006d6c00720bULL, 0x000fca0003f7d000ULL, 0x000000ac00a37306ULL, 0x000ff00000209400ULL,
0x000000ac00a57306ULL, 0x000ea20000205400ULL, 0x000000534800720bULL, 0x008fe40003f9d000ULL,
0x0000000167673812ULL, 0x000fca00078efcffULL, 0x0000004d00787306ULL, 0x000fe20000209400ULL,
0x000000022c08723cULL, 0x002bee0000041808ULL, 0x0000004d00777306ULL, 0x000e620000205400ULL,
0x000000a5a300720bULL, 0x004fe40003f3d000ULL, 0x000000516702723eULL, 0x020fca00000010ffULL,
0x0000004c004c7306ULL, 0x000eb0000020d400ULL, 0x000000ac009d7306ULL, 0x000ee2000020d400ULL,
0x000000777800720bULL, 0x002fe40003fdd000ULL, 0x0000007f7b77723eULL, 0x000fca00000010ffULL,
0x0000004d004d7306ULL, 0x000e62000020d400ULL, 0x000000014c4c4812ULL, 0x004fe200078efcffULL,
0x000000762818723cULL, 0x000f660000041818ULL, 0x0000006a4c03723eULL, 0x000fc600000010ffULL,
0x0000005c005a7306ULL, 0x000fe20000209400ULL, 0x000000019d9d1812ULL, 0x008fe400078efcffULL,
0x000000646300720bULL, 0x000fe20003f3d000ULL, 0x000000022c1c723cULL, 0x000b62000004181cULL,
0x000000509d50723eULL, 0x000fc600000010ffULL, 0x0000005c005b7306ULL, 0x000ea20000205400ULL,
0x000000014d4d6812ULL, 0x002fe400078efcffULL, 0x000000a1a000720bULL, 0x000fe40003fdd000ULL,
0x000000584d53723eULL, 0x000fc600000010ffULL, 0x00000090008f7306ULL, 0x000fe20000209400ULL,
0x000000014a4a1812ULL, 0x000fc600078efcffULL, 0x000000522c20723cULL, 0x000b680000041820ULL,
0x00000090008e7306ULL, 0x000e620000205400ULL, 0x0000005b5a00720bULL, 0x004fe40003fbd000ULL,
0x000000019f9f6812ULL, 0x000fe400078efcffULL, 0x000000565500720bULL, 0x000fe40003fdd000ULL,
0x000000364b55723eULL, 0x000fe200000010ffULL, 0x0000008c00867306ULL, 0x000fe20000209400ULL,
0x0000009f5951723eULL, 0x000fca00000010ffULL, 0x000000542c24723cULL, 0x000b640000041824ULL,
0x0000008c007e7306ULL, 0x000ea20000205400ULL, 0x0000008e8f00720bULL, 0x002fe40003f7d000ULL,
0x0000000149496812ULL, 0x000fc600078efcffULL, 0x000000502c18723cULL, 0x020b640000041818ULL,
0x0000008d00297306ULL, 0x000ff00000209400ULL, 0x0000008d002a7306ULL, 0x000e620000205400ULL,
0x0000007e8600720bULL, 0x004fce0003f5d000ULL, 0x0000005c005c7306ULL, 0x000eb0000020d400ULL,
0x0000009000957306ULL, 0x000ee2000020d400ULL, 0x0000002a2900720bULL, 0x002fce0003f3d000ULL,
0x0000008c008c7306ULL, 0x000e62000020d400ULL, 0x000000015c5c5812ULL, 0x004fce00078efcffULL,
0x0000005f005d7306ULL, 0x000fe20000209400ULL, 0x0000000195953812ULL, 0x008fc800078efcffULL,
0x000000955c95723eULL, 0x000fc600000010ffULL, 0x0000005f005e7306ULL, 0x000ea20000205400ULL,
0x000000018c8c2812ULL, 0x002fc600078efcffULL, 0x000000942c14723cULL, 0x000b620000041814ULL,
0x0000004a8c4a723eULL, 0x000fc600000010ffULL, 0x0000006200607306ULL, 0x000ff00000209400ULL,
0x0000006200617306ULL, 0x000e620000205400ULL, 0x0000005e5d00720bULL, 0x004fce0003f9d000ULL,
0x0000008a00787306ULL, 0x000ff00000209400ULL, 0x0000008a00317306ULL, 0x000ea20000205400ULL,
0x000000616000720bULL, 0x002fce0003f7d000ULL, 0x0000008b00307306ULL, 0x000ff00000209400ULL,
0x0000008b00287306ULL, 0x000e620000205400ULL, 0x000000317800720bULL, 0x004fce0003fbd000ULL,
0x0000008d00037306ULL, 0x000eb0000020d400ULL, 0x0000005f005f7306ULL, 0x000ee2000020d400ULL,
0x000000283000720bULL, 0x002fce0003f5d000ULL, 0x0000006200627306ULL, 0x000e62000020d400ULL,
0x0000000103031812ULL, 0x004fe400078efcffULL, 0x000000084700780cULL, 0x000fca0003f25270ULL,
0x0000008a008a7306ULL, 0x000ea2000020d400ULL, 0x000000015f5f4812ULL, 0x008fce00078efcffULL,
0x0000008b008b7306ULL, 0x000ee2000020d400ULL, 0x0000000162623812ULL, 0x002fc800078efcffULL,
0x000000036203723eULL, 0x000fe400000010ffULL, 0x000000018a8a5812ULL, 0x004fc800078efcffULL,
0x0000008a5f4b723eULL, 0x000fe400000010ffULL, 0x000000018b8b2812ULL, 0x008fca00078efcffULL,
0x0000004a2c10723cULL, 0x000b620000041810ULL, 0x000000498b02723eULL, 0x000fce00000010ffULL,
0x000000022c0c723cULL, 0x000b62000004180cULL, 0x0000001000009944ULL, 0x000fe20003c00000ULL,
0xffffe0f000007947ULL, 0x000fcc000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff447224ULL, 0x000fe200078e0041ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffc4e000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x0000003c1c1c7220ULL, 0x080fe40000410000ULL, 0x0000003c18187220ULL, 0x0a0fe40000410000ULL,
0x0000003c19197220ULL, 0x080fe40000410000ULL, 0x0000003c08087220ULL, 0x080fe40000410000ULL,
0x0000003c09097220ULL, 0x000fc40000410000ULL, 0x0000003c24247220ULL, 0x080fe40000410000ULL,
0x0000003c25257220ULL, 0x080fe40000410000ULL, 0x0000003c20207220ULL, 0x080fe40000410000ULL,
0x0000003c21217220ULL, 0x080fe40000410000ULL, 0x0000003c1d1d7220ULL, 0x080fe40000410000ULL,
0x0000003c14027220ULL, 0x000fc40000410000ULL, 0x0000003c15037220ULL, 0x080fe40000410000ULL,
0x0000003c0c0c7220ULL, 0x080fe40000410000ULL, 0x0000003c1a2c7220ULL, 0x080fe40000410000ULL,
0x0000003c1b2d7220ULL, 0x080fe40000410000ULL, 0x0000003c162e7220ULL, 0x080fe40000410000ULL,
0x0000003c172f7220ULL, 0x000fc40000410000ULL, 0x0000003c101a7220ULL, 0x080fe40000410000ULL,
0x0000003c111b7220ULL, 0x080fe40000410000ULL, 0x0000003c12307220ULL, 0x080fe40000410000ULL,
0x0000003c13317220ULL, 0x080fe40000410000ULL, 0x0000003c0e327220ULL, 0x080fe40000410000ULL,
0x0000003c0f337220ULL, 0x000fc40000410000ULL, 0x000000ffff147224ULL, 0x000fe400078e001cULL,
0x000000ffff167224ULL, 0x000fe400078e0018ULL, 0x000000ffff177224ULL, 0x000fe400078e0019ULL,
0x0000003c0a287220ULL, 0x080fe40000410000ULL, 0x0000003c0b297220ULL, 0x080fe40000410000ULL,
0x0000003c26267220ULL, 0x000fc40000410000ULL, 0x0000003c27277220ULL, 0x080fe40000410000ULL,
0x0000003c22227220ULL, 0x080fe40000410000ULL, 0x0000003c23237220ULL, 0x080fe40000410000ULL,
0x0000003c1e2a7220ULL, 0x080fe40000410000ULL, 0x0000003c1f2b7220ULL, 0x080fe40000410000ULL,
0x0000003c0d0d7220ULL, 0x000fc40000410000ULL, 0x000000ffff0e7224ULL, 0x000fe400078e0008ULL,
0x000000ffff0f7224ULL, 0x000fe400078e0009ULL, 0x000000ffff107224ULL, 0x000fe400078e0024ULL,
0x000000ffff117224ULL, 0x000fe400078e0025ULL, 0x000000ffff127224ULL, 0x000fe400078e0020ULL,
0x000000ffff137224ULL, 0x000fc400078e0021ULL, 0x000000ffff157224ULL, 0x000fe400078e001dULL,
0x000000ffff187224ULL, 0x000fe400078e0002ULL, 0x000000ffff197224ULL, 0x000fe400078e0003ULL,
0x000000ffff1c7224ULL, 0x000fe200078e000cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000003d0a7f8cULL, 0x0002a2000c80043fULL, 0x000000ffff207224ULL, 0x000fe400078e0026ULL,
0x000000ffff217224ULL, 0x000fc400078e0027ULL, 0x000000ffff1e7224ULL, 0x000fe400078e0028ULL,
0x000000ffff1f7224ULL, 0x000fe400078e0029ULL, 0x000000ffff247224ULL, 0x000fe400078e002aULL,
0x000000ffff257224ULL, 0x000fe400078e002bULL, 0x000000ffff267224ULL, 0x000fe400078e002cULL,
0x000000ffff277224ULL, 0x000fc400078e002dULL, 0x000000ffff1d7224ULL, 0x000fe400078e000dULL,
0x000000ffff287224ULL, 0x000fe400078e002eULL, 0x000000ffff297224ULL, 0x000fe400078e002fULL,
0x000000ffff2a7224ULL, 0x000fe400078e0030ULL, 0x000000ffff2b7224ULL, 0x000fe400078e0031ULL,
0x000000ffff2c7224ULL, 0x000fc400078e0032ULL, 0x000000ffff2d7224ULL, 0x000fc400078e0033ULL,
0x0000000000027805ULL, 0x006fca0000015200ULL, 0x000004003d087984ULL, 0x000e640000000800ULL,
0x8000000008ff7812ULL, 0x002fe4000780480bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0d7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100d00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fcc0000015200ULL,
0x00000008020c7210ULL, 0x000fca0007f1e1ffULL, 0x0000000109097824ULL, 0x000fe200000e0e03ULL,
0x003d09000c00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400c00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc80000011409ULL, 0x0000000c08087211ULL, 0x000fca00078110ffULL,
0x000000ffff097224ULL, 0x000fca00000e0609ULL, 0x0000000208087819ULL, 0x000fc80000001209ULL,
0x000000080000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010d0d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004003d087984ULL, 0x000e640000000800ULL, 0x8000000008ff7812ULL, 0x002fe4000780480bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000043a037824ULL, 0x000fe200078e00ffULL,
0x0000003e4000720cULL, 0x000fc80003f05270ULL, 0xfffffff003027812ULL, 0x000fca00078ec0ffULL,
0x0000008000027824ULL, 0x000fca00078e0202ULL, 0x0184000002087984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x000000023a0c7824ULL, 0x000fe400078e00ffULL,
0x0000000104437824ULL, 0x000fc600078e0a43ULL, 0x000000060c0c7812ULL, 0x000fc800078ec0ffULL,
0x000000010c0d7812ULL, 0x040fe400078efcffULL, 0x000000080c2e7812ULL, 0x040fe400078efcffULL,
0x000000430d00720cULL, 0x080fe40003f26070ULL, 0x000000100c0d7812ULL, 0x000fe400078efcffULL,
0x000000432e00720cULL, 0x080fe40003f06070ULL, 0x000000430d00720cULL, 0x000fc40003fc6070ULL,
0x000000110c2e7812ULL, 0x040fe400078efcffULL, 0x000000180c0d7812ULL, 0x040fe400078efcffULL,
0x000000430c00720cULL, 0x080fe40003f46070ULL, 0x000000432e00720cULL, 0x080fe40003fa6070ULL,
0x000000430d00720cULL, 0x000fe40003f66070ULL, 0x000000090c2f7812ULL, 0x000fc400078efcffULL,
0x000000190c2e7812ULL, 0x040fe400078efcffULL, 0x000000200c0d7812ULL, 0x000fe400078efcffULL,
0xff8000001e1e7808ULL, 0x000fe40005000000ULL, 0xff8000000e0e7808ULL, 0x000fe40005000000ULL,
0xff8000001f1f7808ULL, 0x000fe40004800000ULL, 0xff8000000f0f7808ULL, 0x000fc40004800000ULL,
0x000000432f00720cULL, 0x080fe40003f86070ULL, 0x000000432e00720cULL, 0x080fe40003f46070ULL,
0x000000430d00720cULL, 0x000fe40003f26070ULL, 0x000000210c2e7812ULL, 0x040fe400078efcffULL,
0x000000280c0d7812ULL, 0x000fe400078efcffULL, 0xff80000020207808ULL, 0x000fc40004000000ULL,
0xff80000010107808ULL, 0x000fe40004000000ULL, 0xff80000021217808ULL, 0x000fe40006000000ULL,
0xff80000011117808ULL, 0x000fe40006000000ULL, 0x000000432e00720cULL, 0x080fe40003f06070ULL,
0x000000430d00720cULL, 0x000fe40003f86070ULL, 0x000000290c2e7812ULL, 0x000fc400078efcffULL,
0x000000300c0d7812ULL, 0x000fe400078efcffULL, 0xff80000022227808ULL, 0x000fe40007000000ULL,
0xff80000012127808ULL, 0x000fe40007000000ULL, 0xff80000023237808ULL, 0x000fe40006800000ULL,
0xff80000013137808ULL, 0x000fe40006800000ULL, 0x000000432e00720cULL, 0x000fc40003fc6070ULL,
0x000000430d00720cULL, 0x000fe40003fa6070ULL, 0x000000310c2e7812ULL, 0x040fe400078efcffULL,
0x000000380c0d7812ULL, 0x040fe400078efcffULL, 0x000000390c0c7812ULL, 0x000fe400078efcffULL,
0xff80000024247808ULL, 0x000fe40005800000ULL, 0xff80000014147808ULL, 0x000fc40005800000ULL,
0xff80000025257808ULL, 0x000fe40005000000ULL, 0xff80000015157808ULL, 0x000fe40005000000ULL,
0xff80000026267808ULL, 0x000fe40004800000ULL, 0xff80000016167808ULL, 0x000fe40004800000ULL,
0x000000432e00720cULL, 0x080fe40003f66070ULL, 0x000000430d00720cULL, 0x000fc40003f46070ULL,
0x000000430c00720cULL, 0x000fe40003f26070ULL, 0xff80000027277808ULL, 0x000fe40004000000ULL,
0xff80000017177808ULL, 0x000fe40004000000ULL, 0xff80000028287808ULL, 0x000fe40006000000ULL,
0xff80000018187808ULL, 0x000fe40006000000ULL, 0xff80000029297808ULL, 0x000fc40007000000ULL,
0xff80000019197808ULL, 0x000fe40007000000ULL, 0xff8000002a2a7808ULL, 0x000fe40006800000ULL,
0xff8000001a1a7808ULL, 0x000fe40006800000ULL, 0xff8000002b2b7808ULL, 0x000fe40005800000ULL,
0xff8000001b1b7808ULL, 0x000fe40005800000ULL, 0xff8000002c2c7808ULL, 0x000fc40005000000ULL,
0xff8000001c1c7808ULL, 0x000fe40005000000ULL, 0xff8000002d2d7808ULL, 0x000fe40004800000ULL,
0xff8000001d1d7808ULL, 0x000fc40004800000ULL, 0x0000000e0800720bULL, 0x004fe40003f1e000ULL,
0x0000001e0900720bULL, 0x000fe40003f3e000ULL, 0x000000080e087208ULL, 0x000fe40004000000ULL,
0x000000091e097208ULL, 0x000fc40004800000ULL, 0x0000000f0800720bULL, 0x000fe40003f1e000ULL,
0x0000001f0900720bULL, 0x000fe40003f3e000ULL, 0x000000080f087208ULL, 0x000fe40004000000ULL,
0x000000091f097208ULL, 0x000fe40004800000ULL, 0x000000100800720bULL, 0x000fe40003f1e000ULL,
0x000000200900720bULL, 0x000fc40003f3e000ULL, 0x0000000810087208ULL, 0x000fe40004000000ULL,
0x0000000920097208ULL, 0x000fe40004800000ULL, 0x000000110800720bULL, 0x000fe40003f1e000ULL,
0x000000210900720bULL, 0x000fe40003f3e000ULL, 0x0000000811087208ULL, 0x000fe40004000000ULL,
0x0000000921097208ULL, 0x000fc40004800000ULL, 0x000000120800720bULL, 0x000fe40003f1e000ULL,
0x000000220900720bULL, 0x000fe40003f3e000ULL, 0x0000000812087208ULL, 0x000fe40004000000ULL,
0x0000000922097208ULL, 0x000fe40004800000ULL, 0x000000130800720bULL, 0x000fe40003f1e000ULL,
0x000000230900720bULL, 0x000fc40003f3e000ULL, 0x0000000813087208ULL, 0x000fe40004000000ULL,
0x0000000923097208ULL, 0x000fe40004800000ULL, 0x000000140800720bULL, 0x000fe40003f1e000ULL,
0x000000240900720bULL, 0x000fe40003f3e000ULL, 0x0000000814087208ULL, 0x000fe40004000000ULL,
0x0000000924097208ULL, 0x000fc40004800000ULL, 0x000000150800720bULL, 0x000fe40003f1e000ULL,
0x000000250900720bULL, 0x000fe40003f3e000ULL, 0x0000000815087208ULL, 0x000fe40004000000ULL,
0x0000000925097208ULL, 0x000fe40004800000ULL, 0x000000160800720bULL, 0x000fe40003f1e000ULL,
0x000000260900720bULL, 0x000fc40003f3e000ULL, 0x0000000816087208ULL, 0x000fe40004000000ULL,
0x0000000926097208ULL, 0x000fe40004800000ULL, 0x000000170800720bULL, 0x000fe40003f1e000ULL,
0x000000270900720bULL, 0x000fe40003f3e000ULL, 0x0000000817087208ULL, 0x000fe40004000000ULL,
0x0000000927097208ULL, 0x000fc40004800000ULL, 0x000000180800720bULL, 0x000fe40003f1e000ULL,
0x000000280900720bULL, 0x000fe40003f3e000ULL, 0x0000000818087208ULL, 0x000fe40004000000ULL,
0x0000000928097208ULL, 0x000fe40004800000ULL, 0x000000190800720bULL, 0x000fe40003f1e000ULL,
0x000000290900720bULL, 0x000fc40003f3e000ULL, 0x0000000819087208ULL, 0x000fe40004000000ULL,
0x0000000929097208ULL, 0x000fe40004800000ULL, 0x0000001a0800720bULL, 0x000fe40003f1e000ULL,
0x0000002a0900720bULL, 0x000fe40003f3e000ULL, 0x000000081a087208ULL, 0x000fe40004000000ULL,
0x000000092a097208ULL, 0x000fc40004800000ULL, 0x0000001b0800720bULL, 0x000fe40003f1e000ULL,
0x0000002b0900720bULL, 0x000fe40003f3e000ULL, 0x000000081b087208ULL, 0x000fe40004000000ULL,
0x000000092b097208ULL, 0x000fe40004800000ULL, 0x0000001c0800720bULL, 0x000fe40003f1e000ULL,
0x0000002c0900720bULL, 0x000fc40003f3e000ULL, 0x000000081c087208ULL, 0x000fe40004000000ULL,
0x000000092c097208ULL, 0x000fe40004800000ULL, 0x0000001d0800720bULL, 0x000fe40003f1e000ULL,
0x0000002d0900720bULL, 0x000fe40003f3e000ULL, 0x000000081d307208ULL, 0x000fe40004000000ULL,
0x000000092d097208ULL, 0x000fe20004800000ULL, 0x00001b627f007947ULL, 0x000fec000b800000ULL,
0x0c401f0030087f89ULL, 0x0004e400000e0000ULL, 0x000000083000720bULL, 0x008fc80003f1e000ULL,
0x0000003008307208ULL, 0x004fe20004000000ULL, 0x00001ba27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0009087f89ULL, 0x000ea800000e0000ULL, 0x0c401f000a0c7f89ULL, 0x000ee800000e0000ULL,
0x0c401f000b0d7f89ULL, 0x000e6200000e0000ULL, 0x000000080900720bULL, 0x004fc40003f1e000ULL,
0x0000000c0a00720bULL, 0x008fe40003f3e000ULL, 0x0000000908097208ULL, 0x000fe40004000000ULL,
0x0000000a0c0a7208ULL, 0x000fe20004800000ULL, 0x0c201f0030087f89ULL, 0x000ea200000e0000ULL,
0x0000000d0b00720bULL, 0x002fc60003f1e000ULL, 0x0c201f00090c7f89ULL, 0x000e6200000e0000ULL,
0x0000000b0d0b7208ULL, 0x000fc60004000000ULL, 0x0c201f000a2e7f89ULL, 0x000ee800000e0000ULL,
0x0c201f000b2f7f89ULL, 0x0002e200000e0000ULL, 0x000000083000720bULL, 0x004fe40003f1e000ULL,
0x0000000c0900720bULL, 0x002fe40003f3e000ULL, 0x0000003008087208ULL, 0x000fe40004000000ULL,
0x0000002e0a00720bULL, 0x008fc40003f5e000ULL, 0x000000090c097208ULL, 0x000fe40004800000ULL,
0x0000000a2e0a7208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b082e7820ULL, 0x000fe20000410000ULL,
0x3f80000000057882ULL, 0x000fe20000000000ULL, 0x3fb8aa3b09307820ULL, 0x000fe20000410000ULL,
0x0000000c03037812ULL, 0x000fe200078ec0ffULL, 0x3fb8aa3b0f0f7823ULL, 0x100fe2000001082eULL,
0x000000033aff7812ULL, 0x000fe2000780c0ffULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe2000001082eULL,
0x0000002f0b00720bULL, 0x004fe20003f3e000ULL, 0x3fb8aa3b11117823ULL, 0x000fc4000001082eULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe20000010830ULL, 0x0000000e000c7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010830ULL, 0x0000000b2f0b7208ULL, 0x000fe20004800000ULL,
0x3fb8aa3b21217823ULL, 0x000fe40000010830ULL, 0x3fb8aa3b10107823ULL, 0x000fe4000001082eULL,
0x3fb8aa3b1e1e7823ULL, 0x000fe20000010830ULL, 0x0000000f000f7308ULL, 0x000e620000000800ULL,
0x00000005ff327e24ULL, 0x000fe2000f8e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3fb8aa3b13137823ULL, 0x000fc4000001082eULL, 0x3fb8aa3b12127823ULL, 0x100fe2000001082eULL,
0x3f8000003232783eULL, 0x000fe200000010ffULL, 0x3fb8aa3b15157823ULL, 0x000fe2000001082eULL,
0x00000010000e7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b22227823ULL, 0x000fe40000010830ULL,
0x000000ffff337224ULL, 0x000fe400078e0032ULL, 0x3fb8aa3b23237823ULL, 0x100fe40000010830ULL,
0x3fb8aa3b24247823ULL, 0x100fe20000010830ULL, 0x0000001100117308ULL, 0x000ea20000000800ULL,
0x0000000c0f0c723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b25257823ULL, 0x000fc40000010830ULL,
0x3fb8aa3b14147823ULL, 0x100fe4000001082eULL, 0x3fb8aa3b16167823ULL, 0x100fe4000001082eULL,
0x0000001e000d7308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b18187823ULL, 0x100fe4000001082eULL,
0x3fb8aa3b17177823ULL, 0x100fe4000001082eULL, 0x3fb8aa3b1a1a7823ULL, 0x000fe4000001082eULL,
0x3fb8aa3b28287823ULL, 0x000fe20000010830ULL, 0x0000001f001f7308ULL, 0x000ee20000000800ULL,
0x0000000e110e723eULL, 0x004fe200000010ffULL, 0x000000ffff1e7224ULL, 0x002fc400078e0032ULL,
0x3fb8aa3b29297823ULL, 0x000fe40000010830ULL, 0x3fb8aa3b19197823ULL, 0x100fe4000001082eULL,
0x0000002000207308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1c1c7823ULL, 0x000fe4000001082eULL,
0x3fb8aa3b26267823ULL, 0x100fe40000010830ULL, 0x3fb8aa3b27277823ULL, 0x000fe40000010830ULL,
0x3fb8aa3b1d1d7823ULL, 0x000fe2000001082eULL, 0x0000002100217308ULL, 0x000e620000000800ULL,
0x0000000d1f0d723eULL, 0x008fe200000010ffULL, 0x000000ffff1f7224ULL, 0x000fc400078e0032ULL,
0x3fb8aa3b1b1b7823ULL, 0x000fe2000001082eULL, 0x00000002ff2e7819ULL, 0x000fe2000001163aULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe40000010830ULL, 0x0000001200107308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe40000010830ULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe40000010830ULL,
0x3fb8aa3b2b2b7823ULL, 0x000fe40000010830ULL, 0x000000082e307824ULL, 0x040fe200078e00ffULL,
0x00000020210f723eULL, 0x002fe200000010ffULL, 0x0000001300137308ULL, 0x000e620000000800ULL,
0x000000022e217810ULL, 0x000fca0007ffe0ffULL, 0x000000320c34723cULL, 0x000f6400000418ffULL,
0x0000001400127308ULL, 0x000ff00000000800ULL, 0x0000001500157308ULL, 0x000ea20000000800ULL,
0x000000101310723eULL, 0x002fce00000010ffULL, 0x0000002200227308ULL, 0x000ff00000000800ULL,
0x0000002300237308ULL, 0x000e620000000800ULL, 0x000000121512723eULL, 0x004fe400000010ffULL,
0x000000012e157810ULL, 0x000fca0007ffe0ffULL, 0x0000002400247308ULL, 0x000ff00000000800ULL,
0x0000002500257308ULL, 0x000ea20000000800ULL, 0x000000222311723eULL, 0x002fe200000010ffULL,
0x000000082e227824ULL, 0x000fc400078e00ffULL, 0x000000082e237824ULL, 0x000fc600078e00ffULL,
0xfffffff822227812ULL, 0x000fe200078ee215ULL, 0x0000001600147308ULL, 0x000fe20000000800ULL,
0xfffffff823237812ULL, 0x000fe200078ee221ULL, 0x000000082e217824ULL, 0x000fca00078e00ffULL,
0xfffffff821217812ULL, 0x000fe200078ee22eULL, 0x0000001800167308ULL, 0x000fe20000000800ULL,
0x000000242513723eULL, 0x004fe400000010ffULL, 0x000000032e247810ULL, 0x040fe40007ffe0ffULL,
0x000000042e257810ULL, 0x000fc60007ffe0ffULL, 0x0000001a00187308ULL, 0x000ff00000000800ULL,
0x0000001700177308ULL, 0x000e700000000800ULL, 0x0000001c001a7308ULL, 0x000ff00000000800ULL,
0x0000001d00207308ULL, 0x0004e20000000800ULL, 0x000000141714723eULL, 0x002fce00000010ffULL,
0x0000002800287308ULL, 0x000fe20000000800ULL, 0x0000001e101c723cULL, 0x024f6e0000041834ULL,
0x0000002900297308ULL, 0x000e620000000800ULL, 0x0000001a201a723eULL, 0x008fe400000010ffULL,
0x0001200000207811ULL, 0x000fca00078e58ffULL, 0x0000001900197308ULL, 0x000ea20000000800ULL,
0x0000001021217824ULL, 0x100fe400078e0220ULL, 0x0000001022227824ULL, 0x100fe400078e0220ULL,
0x0000001023237824ULL, 0x000fe400078e0220ULL, 0x0000000121217824ULL, 0x000fe200078e0203ULL,
0x0000002600267308ULL, 0x000fe20000000800ULL, 0x000000282917723eULL, 0x002fe200000010ffULL,
0x000000ffff287224ULL, 0x000fc400078e0032ULL, 0x000000ffff297224ULL, 0x000fe200078e0032ULL,
0x0000000c21007388ULL, 0x0003e20000000800ULL, 0x0000000103227824ULL, 0x000fe400078e0222ULL,
0x0000002700277308ULL, 0x000ee20000000800ULL, 0x000000161916723eULL, 0x004fe200000010ffULL,
0x0000000103237824ULL, 0x000fe200078e0223ULL, 0x0000000e22007388ULL, 0x0003e80000000800ULL,
0x0000001023007388ULL, 0x0003e20000000800ULL, 0x0000001b001b7308ULL, 0x000ea20000000800ULL,
0x000000262715723eULL, 0x008fce00000010ffULL, 0x0000002a002a7308ULL, 0x000fe20000000800ULL,
0x000000082e267824ULL, 0x040fe400078e00ffULL, 0x000000082e277824ULL, 0x000fe200078e00ffULL,
0x00000028141c723cULL, 0x020b64000004181cULL, 0xfffffff826247812ULL, 0x000fe400078ee224ULL,
0x0000002b00197308ULL, 0x0006620000000800ULL, 0x000000052e267810ULL, 0x000fe40007ffe0ffULL,
0x000000181b18723eULL, 0x004fe200000010ffULL, 0x0000001024247824ULL, 0x000fe200078e0220ULL,
0x000000082e297810ULL, 0x020fc40007ffe0ffULL, 0xfffffff827257812ULL, 0x000fe200078ee225ULL,
0x0000002c002c7308ULL, 0x000fe20000000800ULL, 0x000000082e2b7824ULL, 0x048fe200078e00ffULL,
0x000000062e277810ULL, 0x040fe20007ffe0ffULL, 0x0000000829317824ULL, 0x000fe200078e00ffULL,
0xffffffff2e287810ULL, 0x040fe20007ffe0ffULL, 0x000000082e2e7824ULL, 0x000fe200078e00ffULL,
0xfffffff82b267812ULL, 0x000fe200078ee226ULL, 0x000000ffff2b7224ULL, 0x100fe200078e0032ULL,
0x0000002d002d7308ULL, 0x000ea20000000800ULL, 0x0000002a1919723eULL, 0x002fe200000010ffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0032ULL, 0xfffffff830277812ULL, 0x000fe200078ee227ULL,
0x0000001025257824ULL, 0x000fe200078e0220ULL, 0xfffffff82e287812ULL, 0x000fe200078ee228ULL,
0x0000001026267824ULL, 0x100fe200078e0220ULL, 0xfffffff831297812ULL, 0x000fe200078ee229ULL,
0x0000001027277824ULL, 0x000fc400078e0220ULL, 0x0000001028287824ULL, 0x000fe400078e0220ULL,
0x0000000103247824ULL, 0x000fe400078e0224ULL, 0x0000001029297824ULL, 0x000fe200078e0220ULL,
0x0000002c2d1b723eULL, 0x004fe200000010ffULL, 0x0000000103257824ULL, 0x040fe200078e0225ULL,
0x0000001224007388ULL, 0x0003e20000000800ULL, 0x0000000103267824ULL, 0x040fe400078e0226ULL,
0x0000000103277824ULL, 0x040fe200078e0227ULL, 0x0000001425007388ULL, 0x0003e20000000800ULL,
0x0000002a181c723cULL, 0x000f62000004181cULL, 0x0000000103287824ULL, 0x000fc400078e0228ULL,
0x0000000103297824ULL, 0x000fe200078e0229ULL, 0x0000001626007388ULL, 0x0003e80000000800ULL,
0x0000001827007388ULL, 0x0003e80000000800ULL, 0x0000001a28007388ULL, 0x0003e80000000800ULL,
0x0000000d29007388ULL, 0x0003e80000000800ULL, 0x0004000f22007388ULL, 0x0003e80000000800ULL,
0x0004001123007388ULL, 0x0003e20000000800ULL, 0x000000ffff1d7224ULL, 0x020fc600078e001eULL,
0x0004001324007388ULL, 0x0003e80000000800ULL, 0x0004001525007388ULL, 0x0003e80000000800ULL,
0x0004001726007388ULL, 0x0003e80000000800ULL, 0x0004001927007388ULL, 0x0003e80000000800ULL,
0x0004001b28007388ULL, 0x0003e80000000800ULL, 0x0180000802008388ULL, 0x0003e80000000c00ULL,
0x0182001c02008388ULL, 0x0003e20000000a00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000003fff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000008003fff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000010003fff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000140407810ULL, 0x000fe20007ffe0ffULL, 0x000018003fff7f8cULL, 0x0003e6000c80043fULL,
0x000000064000720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffa70000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff3c7807ULL, 0x004fe20004000000ULL, 0xffffffffff447424ULL, 0x000fe200078e00ffULL,
0x00022240003d7802ULL, 0x000fc40000000f00ULL, 0x0000139000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff137224ULL, 0x000fe200078e0044ULL, 0xfffdfe9000007947ULL, 0x000fea000383ffffULL,
0x00000001ff3c7807ULL, 0x000fe20005000000ULL, 0xffffffffff447424ULL, 0x000fe200078e00ffULL,
0x000222a0003d7802ULL, 0x000fc40000000f00ULL, 0x0000133000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff137224ULL, 0x000fe200078e0044ULL, 0xfffdfec000007947ULL, 0x000fea000383ffffULL,
0x000000ffff497224ULL, 0x002fe200078e0014ULL, 0x0002231000447802ULL, 0x000fe20000000f00ULL,
0x0000001fff457424ULL, 0x000fe400078e00ffULL, 0xffffffffff467424ULL, 0x000fc400078e00ffULL,
0x0000128000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff477224ULL, 0x004fe200078e0046ULL,
0xfffdff4000007947ULL, 0x000fea000383ffffULL, 0x000000ffff497224ULL, 0x000fe200078e0014ULL,
0x0002238000447802ULL, 0x000fe20000000f00ULL, 0x0000001fff457424ULL, 0x000fc400078e00ffULL,
0xffffffffff467424ULL, 0x000fc400078e00ffULL, 0x0000121000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff477224ULL, 0x004fe200078e0046ULL, 0xfffe004000007947ULL, 0x000fea000383ffffULL,
0x000000ffff477224ULL, 0x000fe200078e0011ULL, 0x000223f000447802ULL, 0x000fe20000000f00ULL,
0x0000001fff457424ULL, 0x000fe400078e00ffULL, 0xffffffffff467424ULL, 0x000fc400078e00ffULL,
0x000011a000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e0046ULL,
0xfffe042000007947ULL, 0x000fea000383ffffULL, 0x000000ffff477224ULL, 0x000fe200078e0010ULL,
0x0002246000447802ULL, 0x000fe20000000f00ULL, 0x0000001fff457424ULL, 0x000fe400078e00ffULL,
0xffffffffff467424ULL, 0x000fc400078e00ffULL, 0x0000113000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0046ULL, 0xfffe03e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff477224ULL, 0x000fe200078e0039ULL, 0x000224d000447802ULL, 0x000fe20000000f00ULL,
0x0000001fff457424ULL, 0x000fc400078e00ffULL, 0xffffffffff467424ULL, 0x000fc400078e00ffULL,
0x000010c000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e0046ULL,
0xfffe311000007947ULL, 0x000fea000383ffffULL, 0x000000ffff477224ULL, 0x000fe200078e0010ULL,
0x0002254000447802ULL, 0x000fe20000000f00ULL, 0x0000001fff457424ULL, 0x000fe400078e00ffULL,
0xffffffffff467424ULL, 0x000fc400078e00ffULL, 0x0000105000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0046ULL, 0xfffe30d000007947ULL, 0x000fea000383ffffULL,
0x00000001ff3c7807ULL, 0x008fe20004000000ULL, 0xffffffffff447424ULL, 0x000fe200078e00ffULL,
0x000225a0003d7802ULL, 0x000fc40000000f00ULL, 0x0000103000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff417224ULL, 0x000fe200078e0044ULL, 0xfffe5ea000007947ULL, 0x000fea000383ffffULL,
0x00000001ff3c7807ULL, 0x000fe20005000000ULL, 0xffffffffff447424ULL, 0x000fe200078e00ffULL,
0x00022600003d7802ULL, 0x000fc40000000f00ULL, 0x00000fd000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff3c7224ULL, 0x000fe200078e0044ULL, 0xfffe5ed000007947ULL, 0x000fea000383ffffULL,
0x000000ffff477224ULL, 0x000fe200078e003dULL, 0x0002267000447802ULL, 0x000fe20000000f00ULL,
0x0000001fff457424ULL, 0x000fc400078e00ffULL, 0xffffffffff467424ULL, 0x000fc400078e00ffULL,
0x00000f2000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff3d7224ULL, 0x004fe200078e0046ULL,
0xfffe5f7000007947ULL, 0x000fea000383ffffULL, 0x000000ffff477224ULL, 0x000fe200078e003dULL,
0x000226e000447802ULL, 0x000fe20000000f00ULL, 0x0000001fff457424ULL, 0x000fe400078e00ffULL,
0xffffffffff467424ULL, 0x000fc400078e00ffULL, 0x00000eb000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff3d7224ULL, 0x004fe200078e0046ULL, 0xfffe606000007947ULL, 0x000fea000383ffffULL,
0x000000ffff477224ULL, 0x000fe200078e0038ULL, 0x0002275000447802ULL, 0x000fe20000000f00ULL,
0x0000001fff457424ULL, 0x000fe400078e00ffULL, 0xffffffffff467424ULL, 0x000fc400078e00ffULL,
0x00000e4000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e0046ULL,
0xfffe648000007947ULL, 0x000fea000383ffffULL, 0x000000ffff477224ULL, 0x000fe200078e0010ULL,
0x000227c000447802ULL, 0x000fe20000000f00ULL, 0x0000001fff457424ULL, 0x000fc400078e00ffULL,
0xffffffffff467424ULL, 0x000fc400078e00ffULL, 0x00000dd000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0046ULL, 0xfffe644000007947ULL, 0x000fea000383ffffULL,
0x000000ffff477224ULL, 0x000fe200078e0034ULL, 0x0002283000447802ULL, 0x000fe20000000f00ULL,
0x0000001fff457424ULL, 0x000fe400078e00ffULL, 0xffffffffff467424ULL, 0x000fc400078e00ffULL,
0x00000d6000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e0046ULL,
0xfffe8f8000007947ULL, 0x000fea000383ffffULL, 0x000000ffff477224ULL, 0x000fe200078e0010ULL,
0x000228a000447802ULL, 0x000fe20000000f00ULL, 0x0000001fff457424ULL, 0x000fe400078e00ffULL,
0xffffffffff467424ULL, 0x000fc400078e00ffULL, 0x00000cf000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0046ULL, 0xfffe8f4000007947ULL, 0x000fea000383ffffULL,
0x00000001ff3c7807ULL, 0x008fe20004000000ULL, 0xffffffffff447424ULL, 0x000fe200078e00ffULL,
0x00022900003d7802ULL, 0x000fc40000000f00ULL, 0x00000cd000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff417224ULL, 0x000fe200078e0044ULL, 0xfffebc0000007947ULL, 0x000fea000383ffffULL,
0x00000001ff3c7807ULL, 0x000fe20005000000ULL, 0xffffffffff447424ULL, 0x000fe200078e00ffULL,
0x00022960003d7802ULL, 0x000fc40000000f00ULL, 0x00000c7000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff3c7224ULL, 0x000fe200078e0044ULL, 0xfffebc3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff477224ULL, 0x000fe200078e003dULL, 0x000229d000447802ULL, 0x000fe20000000f00ULL,
0x0000001fff457424ULL, 0x000fc400078e00ffULL, 0xffffffffff467424ULL, 0x000fc400078e00ffULL,
0x00000bc000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff3d7224ULL, 0x004fe200078e0046ULL,
0xfffebcd000007947ULL, 0x000fea000383ffffULL, 0x000000ffff477224ULL, 0x000fe200078e003dULL,
0x00022a4000447802ULL, 0x000fe20000000f00ULL, 0x0000001fff457424ULL, 0x000fe400078e00ffULL,
0xffffffffff467424ULL, 0x000fc400078e00ffULL, 0x00000b5000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff3d7224ULL, 0x004fe200078e0046ULL, 0xfffebdc000007947ULL, 0x000fea000383ffffULL,
0x000000ffff477224ULL, 0x000fe200078e0038ULL, 0x00022ab000447802ULL, 0x000fe20000000f00ULL,
0x0000001fff457424ULL, 0x000fe400078e00ffULL, 0xffffffffff467424ULL, 0x000fc400078e00ffULL,
0x00000ae000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e0046ULL,
0xfffec1e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff477224ULL, 0x000fe200078e0010ULL,
0x00022b2000447802ULL, 0x000fe20000000f00ULL, 0x0000001fff457424ULL, 0x000fc400078e00ffULL,
0xffffffffff467424ULL, 0x000fc400078e00ffULL, 0x00000a7000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0046ULL, 0xfffec1a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff477224ULL, 0x000fe200078e0034ULL, 0x00022b9000447802ULL, 0x000fe20000000f00ULL,
0x0000001fff457424ULL, 0x000fe400078e00ffULL, 0xffffffffff467424ULL, 0x000fc400078e00ffULL,
0x00000a0000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e0046ULL,
0xfffeece000007947ULL, 0x000fea000383ffffULL, 0x000000ffff477224ULL, 0x000fe200078e0010ULL,
0x00022c0000447802ULL, 0x000fe20000000f00ULL, 0x0000001fff457424ULL, 0x000fe400078e00ffULL,
0xffffffffff467424ULL, 0x000fc400078e00ffULL, 0x0000099000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0046ULL, 0xfffeeca000007947ULL, 0x000fea000383ffffULL,
0x00000001ff3c7807ULL, 0x008fe20004000000ULL, 0xffffffffff447424ULL, 0x000fe200078e00ffULL,
0x00022c60003d7802ULL, 0x000fc40000000f00ULL, 0x0000097000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff417224ULL, 0x000fe200078e0044ULL, 0xffff197000007947ULL, 0x000fea000383ffffULL,
0x00000001ff3c7807ULL, 0x000fe20004800000ULL, 0xffffffffff447424ULL, 0x000fe200078e00ffULL,
0x00022cc0003d7802ULL, 0x000fc40000000f00ULL, 0x0000091000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff3c7224ULL, 0x000fe200078e0044ULL, 0xffff19a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff477224ULL, 0x000fe200078e000dULL, 0x00022d3000447802ULL, 0x000fe20000000f00ULL,
0x0000001fff457424ULL, 0x000fc400078e00ffULL, 0xffffffffff467424ULL, 0x000fc400078e00ffULL,
0x0000086000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff0d7224ULL, 0x004fe200078e0046ULL,
0xffff1a4000007947ULL, 0x000fea000383ffffULL, 0x000000ffff477224ULL, 0x000fe200078e000dULL,
0x00022da000447802ULL, 0x000fe20000000f00ULL, 0x0000001fff457424ULL, 0x000fe400078e00ffULL,
0xffffffffff467424ULL, 0x000fc400078e00ffULL, 0x000007f000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0d7224ULL, 0x004fe200078e0046ULL, 0xffff1b3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff497224ULL, 0x008fe200078e000dULL, 0x00022e2000447802ULL, 0x000fe20000000f00ULL,
0x000000ffff477224ULL, 0x000fe400078e0038ULL, 0x0000001fff457424ULL, 0x000fc400078e00ffULL,
0xffffffffff467424ULL, 0x000fc400078e00ffULL, 0x0000077000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e0046ULL, 0xffff1f4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff477224ULL, 0x000fe200078e0010ULL, 0x00022ea000447802ULL, 0x000fe20000000f00ULL,
0x000000ffff497224ULL, 0x008fe400078e000dULL, 0x0000001fff457424ULL, 0x000fe400078e00ffULL,
0xffffffffff467424ULL, 0x000fc400078e00ffULL, 0x000006f000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0046ULL, 0xffff1ef000007947ULL, 0x000fea000383ffffULL,
0x000000ffff497224ULL, 0x000fe200078e000cULL, 0x00022f2000447802ULL, 0x000fe20000000f00ULL,
0x000000ffff477224ULL, 0x000fc400078e000dULL, 0x0000001fff457424ULL, 0x000fe400078e00ffULL,
0xffffffffff467424ULL, 0x000fc400078e00ffULL, 0x0000067000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e0046ULL, 0xffff4a6000007947ULL, 0x000fea000383ffffULL,
0x000000ffff477224ULL, 0x000fe200078e0010ULL, 0x00022fa000447802ULL, 0x000fe20000000f00ULL,
0x000000ffff497224ULL, 0x000fe400078e000cULL, 0x0000001fff457424ULL, 0x000fe400078e00ffULL,
0xffffffffff467424ULL, 0x000fc400078e00ffULL, 0x000005f000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0046ULL, 0xffff4a1000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0c7224ULL, 0x000fe200078e0030ULL, 0x00023020002e7802ULL, 0x000fe20000000f00ULL,
0x00000002ff0d7424ULL, 0x000fc400078e00ffULL, 0x0000001fff2f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff317424ULL, 0x000fc400078e00ffULL, 0x0000052000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e002fULL, 0xffffe43000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0c7224ULL, 0x000fe200078e0009ULL, 0x000230a0002e7802ULL, 0x000fe20000000f00ULL,
0x00000002ff0d7424ULL, 0x000fe400078e00ffULL, 0x0000001fff2f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff317424ULL, 0x000fc400078e00ffULL, 0x000004a000007944ULL, 0x012fea0003c00000ULL,
0x0000002f0900720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e000aULL,
0x00023120002e7802ULL, 0x000fe20000000f00ULL, 0x00000002ff0d7424ULL, 0x000fe200078e00ffULL,
0x000000092f097208ULL, 0x000fe20004000000ULL, 0x0000001fff2f7424ULL, 0x000fc400078e00ffULL,
0xffffffffff317424ULL, 0x000fc400078e00ffULL, 0x0000042000007944ULL, 0x000fea0003c00000ULL,
0x0000002f0a00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e000bULL,
0x000231a0002e7802ULL, 0x000fe20000000f00ULL, 0x00000002ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000000a2f0a7208ULL, 0x000fe20004000000ULL, 0x0000001fff2f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff317424ULL, 0x000fc400078e00ffULL, 0x000003a000007944ULL, 0x000fea0003c00000ULL,
0x0000002f0b00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e0030ULL,
0x00023220002e7802ULL, 0x000fe20000000f00ULL, 0x00000001ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000000b2f0b7208ULL, 0x000fe20004000000ULL, 0x0000001fff2f7424ULL, 0x000fc400078e00ffULL,
0xffffffffff317424ULL, 0x000fc400078e00ffULL, 0x0000032000007944ULL, 0x000fea0003c00000ULL,
0x0000002f3000720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e0009ULL,
0x000232a0002e7802ULL, 0x000fe20000000f00ULL, 0x00000001ff0d7424ULL, 0x000fe200078e00ffULL,
0x000000302f087208ULL, 0x000fe20004000000ULL, 0x0000001fff2f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff317424ULL, 0x000fc400078e00ffULL, 0x000002a000007944ULL, 0x000fea0003c00000ULL,
0x0000002f0900720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e000aULL,
0x00023320002e7802ULL, 0x000fe20000000f00ULL, 0x00000001ff0d7424ULL, 0x000fe200078e00ffULL,
0x000000092f097208ULL, 0x000fe20004000000ULL, 0x0000001fff2f7424ULL, 0x000fc400078e00ffULL,
0xffffffffff317424ULL, 0x000fc400078e00ffULL, 0x0000022000007944ULL, 0x000fea0003c00000ULL,
0x0000002f0a00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e000bULL,
0x000233a0002e7802ULL, 0x000fe20000000f00ULL, 0x00000001ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000000a2f0a7208ULL, 0x000fe20004000000ULL, 0x0000001fff2f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff317424ULL, 0x000fc400078e00ffULL, 0x000001a000007944ULL, 0x000fea0003c00000ULL,
0xffffe22000007947ULL, 0x000fea000383ffffULL, 0x0180000003027810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000002047812ULL, 0x000fc800078ec0ffULL,
0x018000000400780cULL, 0x000fda0003f05070ULL, 0x0000000300028308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0400720cULL, 0x040fe40003f25070ULL,
0x008000000400780cULL, 0x000fe40003f02070ULL, 0x00000001ff047807ULL, 0x000fe40000800000ULL,
0x00000001ff027807ULL, 0x004fc80004000000ULL, 0x0000000204ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff03ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000003037812ULL, 0x002fe400078ec0ffULL, 0x00000001ff027807ULL, 0x000fc80000000000ULL,
0x0000000204ff7212ULL, 0x000fda000780c0ffULL, 0x0080000003020812ULL, 0x000fe200078efcffULL,
0x000000ffff028224ULL, 0x000fe200078e0003ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000300027308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff047224ULL, 0x00cfe400078e0002ULL, 0x000000ffff027224ULL, 0x000fe400078e0005ULL,
0x00000000ff037424ULL, 0x002fc800078e00ffULL, 0xfffdcac002007950ULL, 0x000fea0003c3ffffULL,
0x0000003100007348ULL, 0x000fe80003800000ULL, 0x0c00000d0c2f7389ULL, 0x0002a400000e002fULL,
0x000000ffff0c7224ULL, 0x002fe400078e002eULL, 0x00000000ff0d7424ULL, 0x000fc800078e00ffULL,
0xfffdca700c007950ULL, 0x000fea0003c3ffffULL, 0x0000004600007348ULL, 0x000fe80003800000ULL,
0x0000004749467389ULL, 0x0002a400000e0045ULL, 0x00000000ff457424ULL, 0x002fc800078e00ffULL,
0xfffdca3044007950ULL, 0x000fea0003c3ffffULL, 0x000000013c00780cULL, 0x000fe20003f45070ULL,
0x0000004400007348ULL, 0x000fd80003800000ULL, 0x00000000003c7806ULL, 0x000fc800050e0100ULL,
0x000000443c447212ULL, 0x000fe200078ec0ffULL, 0x000000ffff3c7224ULL, 0x000fe400078e003dULL,
0x00000000ff3d7424ULL, 0x000fc800078e00ffULL, 0xfffdc9c03c007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000100000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005e7ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000748ULL, 0x0000000000000288ULL, 0x0000001a00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009d0ULL, 0x0000000000000480ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e50ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000f10ULL, 0x0000000000000a08ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001918ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001928ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000007bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000019b8ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000019bcULL, 0x00000000000001b0ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001b80ULL, 0x0000000000023700ULL, 0xef00001a00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x0000000100000089ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000025280ULL, 0x0000000000000044ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x00000000000252d0ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000025650ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x00000000000019b8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000238c8ULL, 0x00000000000238c8ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000025280ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000025650ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_1_kvt_int8_pagedKV_64_nqpkv_8_m_8_sm_80_cubin_len = 153392;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
