/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_1_kvt_int8_pagedKV_64_nqpkv_8_m_8_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x00000000000238d0ULL, 0x0000000000023550ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f34314944327961ULL, 0x6f6c66625f766e5fULL,
0x326a4c3236317461ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL,
0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x336a4c4536316a4cULL, 0x4c49746132454532ULL,
0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45346a4c4534366aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL,
0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL,
0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL, 0x45326a4c4545316aULL, 0x7461324545316a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x4939494432796172ULL, 0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL,
0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL,
0x4c4545346a4c6a49ULL, 0x36316a4c4532336aULL, 0x624c497461324545ULL, 0x31534b5245454531ULL,
0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL,
0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL, 0x4c4545326a4c4532ULL, 0x4545316a4c45326aULL,
0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x45386a4c4545346aULL,
0x7461324545386a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL,
0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL,
0x6a4c4536316a4c45ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5f2400676e696469ULL, 0x616e7265746e695fULL, 0x635f5f245f305f6cULL,
0x30326d735f616475ULL, 0x5f6e725f7063725fULL, 0x5f3233665f7a7466ULL, 0x68746170776f6c73ULL,
0x65746e695f5f2400ULL, 0x245f315f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL,
0x6c66625f636e7973ULL, 0x695f5f2400705f79ULL, 0x5f6c616e7265746eULL, 0x6475635f5f245f32ULL,
0x735f30376d735f61ULL, 0x5f636e79736c6668ULL, 0x5f2400705f786469ULL, 0x616e7265746e695fULL,
0x635f5f245f335f6cULL, 0x30376d735f616475ULL, 0x6e797365746f765fULL, 0x746f6c6c61625f63ULL,
0x742e616c65722e00ULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL,
0x5f6c656e72656b2eULL, 0x72656b240061686dULL, 0x2461686d5f6c656eULL, 0x657479426d656d73ULL,
0x2e766e2e00667542ULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x61705f0061686d5fULL,
0x6265642e006d6172ULL, 0x656d6172665f6775ULL, 0x65642e6c65722e00ULL, 0x6d6172665f677562ULL,
0x2e616c65722e0065ULL, 0x72665f6775626564ULL, 0x2e766e2e00656d61ULL, 0x697463612e6c6572ULL,
0x0000000000006e6fULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c0001000000adULL, 0x0000000000000034ULL, 0x0000000000000010ULL, 0x000c0001000000ebULL,
0x000000000000001cULL, 0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c00010000016bULL, 0x000000000000002cULL, 0x0000000000000004ULL,
0x000c0001000001b5ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c0001000001fbULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000242ULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000c000100000288ULL, 0x0000000000000030ULL, 0x0000000000000004ULL,
0x000c0001000002d6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c000100000324ULL,
0x0000000000000018ULL, 0x0000000000000004ULL, 0x000c000100000372ULL, 0x000000000000000cULL,
0x0000000000000004ULL, 0x000c0001000003b9ULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000c000100000407ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c00010000044cULL,
0x0000000000000020ULL, 0x0000000000000004ULL, 0x000b002200000492ULL, 0x00000000000215a0ULL,
0x0000000000000190ULL, 0x000b0022000004c5ULL, 0x0000000000021730ULL, 0x0000000000000050ULL,
0x000b0022000004f0ULL, 0x0000000000021780ULL, 0x0000000000000040ULL, 0x000b00220000051aULL,
0x00000000000217c0ULL, 0x0000000000000140ULL, 0x000a000300000588ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00040003000005a8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00070003000005d8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL,
0x0000000000000000ULL, 0x0000000000021900ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000215a000000000ULL,
0x0000040400000000ULL, 0x810c0000015c0400ULL, 0x0083fc0400288080ULL, 0x0000000000000000ULL,
0x000000c4ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8f082880808e0828ULL, 0x2880809308288080ULL,
0x809c082880809a08ULL, 0x08288080a4082880ULL, 0x8080a608288080a5ULL, 0xae08288080a90828ULL,
0x288080af08288080ULL, 0x80b108288080b008ULL, 0x08288080b6082880ULL, 0x8080c008288080b7ULL,
0xc408288080c30828ULL, 0x288080c508288080ULL, 0x80c708288080c608ULL, 0x08288080c8082880ULL,
0x8080ca08288080c9ULL, 0xdc08288080cb0828ULL, 0x2880808508288080ULL, 0x0003102880828016ULL,
0x9200000000000000ULL, 0x0000220028808085ULL, 0x00000034ffffffffULL, 0x0000007000000000ULL,
0x000215a000000000ULL, 0x0000019000000000ULL, 0x0000580400000000ULL, 0x8084288080820900ULL,
0x0900000004042880ULL, 0x2880808228808085ULL, 0x000000ccffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL,
0x9008288080880828ULL, 0x2880809108288080ULL, 0x8093082880809208ULL, 0x082880809a082880ULL,
0x80809d082880809cULL, 0xa0082880809e0828ULL, 0x288080a408288080ULL, 0x80a608288080a508ULL,
0x08288080a7082880ULL, 0x8080ae08288080a9ULL, 0xb708288080b60828ULL, 0x288080c008288080ULL,
0x80c408288080c308ULL, 0x08288080c5082880ULL, 0x8080c708288080c6ULL, 0xc908288080c80828ULL,
0x288080cb08288080ULL, 0x80b008288080dc08ULL, 0x1028808280162880ULL, 0x0000000000000003ULL,
0x2200288080b09200ULL, 0x0000002cffffffffULL, 0x0000018000000000ULL, 0x0002173000000000ULL,
0x0000005000000000ULL, 0x00000c0400000000ULL, 0x8088288080b00900ULL, 0x0000000000002880ULL,
0x000000ccffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x9108288080900828ULL, 0x2880809208288080ULL,
0x809a082880809308ULL, 0x082880809c082880ULL, 0x80809e082880809dULL, 0xa408288080a00828ULL,
0x288080a508288080ULL, 0x80a708288080a608ULL, 0x08288080a9082880ULL, 0x8080b008288080aeULL,
0xb708288080b60828ULL, 0x288080c008288080ULL, 0x80c408288080c308ULL, 0x08288080c5082880ULL,
0x8080c708288080c6ULL, 0xca08288080c90828ULL, 0x288080cb08288080ULL, 0x80c808288080dc08ULL,
0x1028808280162880ULL, 0x0000000000000003ULL, 0x2200288080c89200ULL, 0x0000001cffffffffULL,
0x0000029000000000ULL, 0x0002178000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x000000ccffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x9108288080900828ULL, 0x2880809208288080ULL,
0x809a082880809308ULL, 0x082880809c082880ULL, 0x80809e082880809dULL, 0xa408288080a00828ULL,
0x288080a508288080ULL, 0x80a708288080a608ULL, 0x08288080a9082880ULL, 0x8080b008288080aeULL,
0xb708288080b60828ULL, 0x288080c008288080ULL, 0x80c408288080c308ULL, 0x08288080c5082880ULL,
0x8080c708288080c6ULL, 0xca08288080c80828ULL, 0x288080cb08288080ULL, 0x80c908288080dc08ULL,
0x1028808280162880ULL, 0x0000000000000003ULL, 0x2200288080c99200ULL, 0x0000002cffffffffULL,
0x0000039000000000ULL, 0x000217c000000000ULL, 0x0000014000000000ULL, 0x0000140400000000ULL,
0x80c8288080c90900ULL, 0x0000000000002880ULL, 0x0000001a00082f04ULL, 0x00082304000000ecULL,
0x0000000000000016ULL, 0x0000001600081204ULL, 0x0008110400000000ULL, 0x0000000000000016ULL,
0x0000001500082304ULL, 0x0008120400000000ULL, 0x0000000000000015ULL, 0x0000001500081104ULL,
0x0008230400000000ULL, 0x0000000000000014ULL, 0x0000001400081204ULL, 0x0008110400000000ULL,
0x0000000000000014ULL, 0x0000001300082304ULL, 0x0008120400000000ULL, 0x0000000000000013ULL,
0x0000001300081104ULL, 0x0008230400000000ULL, 0x000000000000001aULL, 0x0000001a00081204ULL,
0x0008110400000000ULL, 0x000000000000001aULL, 0x0000007b00043704ULL, 0x0000001700080a04ULL,
0x0050190300500160ULL, 0x00000000000c1704ULL, 0x0021f00000480006ULL, 0x00000000000c1704ULL,
0x0021f00000400005ULL, 0x00000000000c1704ULL, 0x0011f00000380004ULL, 0x00000000000c1704ULL,
0x0081f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL, 0x00000000000c1704ULL,
0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x0004310400ff1b03ULL,
0x0198290400000020ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x000000f001982804ULL, 0x0000047000000110ULL, 0x000021b000002100ULL, 0x00002410000022a0ULL,
0x0000289000002860ULL, 0x00002930000028e0ULL, 0x0000563000005600ULL, 0x000056d000005680ULL,
0x000084d000008440ULL, 0x00008740000085e0ULL, 0x00008c0000008bd0ULL, 0x00008ca000008c50ULL,
0x0000b7c00000b790ULL, 0x0000b8600000b810ULL, 0x0000e5500000e4c0ULL, 0x0000e7c00000e660ULL,
0x0000ec800000ec50ULL, 0x0000ed200000ecd0ULL, 0x0001184000011810ULL, 0x000118e000011890ULL,
0x000145e000014550ULL, 0x00014850000146f0ULL, 0x00014d1000014ce0ULL, 0x00014db000014d60ULL,
0x000178f0000178c0ULL, 0x0001799000017940ULL, 0x00019af000019ae0ULL, 0x0001f9b00001a2c0ULL,
0x0001fa000001f9f0ULL, 0x0001fa700001fa10ULL, 0x0001faa00001fa90ULL, 0x000207700001fab0ULL,
0x00020810000207c0ULL, 0x000208c000020860ULL, 0x0002098000020920ULL, 0x00020a30000209e0ULL,
0x00020ae000020a80ULL, 0x00020ba000020b40ULL, 0x00020c6000020c00ULL, 0x00020d1000020cc0ULL,
0x00020dc000020d60ULL, 0x00020e8000020e20ULL, 0x00020f4000020ee0ULL, 0x00020ff000020fa0ULL,
0x000210a000021040ULL, 0x0002116000021100ULL, 0x00021220000211c0ULL, 0x000212e000021280ULL,
0x0002139000021330ULL, 0x00021450000213f0ULL, 0x00021510000214b0ULL, 0x0600390400021570ULL,
0x000000ff000001d0ULL, 0x003f010000010600ULL, 0x0000000d00000200ULL, 0x003f012000010608ULL,
0x0000000d000002b0ULL, 0x003f012000010688ULL, 0x0000000d00000440ULL, 0x003f0120000106a8ULL,
0x000000ff00000460ULL, 0x003f0100000106b8ULL, 0x000000ff000004f0ULL, 0x003f010700010600ULL,
0x0000002b00000640ULL, 0x003f01020001068cULL, 0x0000002b000006a0ULL, 0x003f010100010688ULL,
0x000000ff00000f00ULL, 0x003f0107000106a8ULL, 0x000000ff00001020ULL, 0x003f0101000106a8ULL,
0x000000ff00001080ULL, 0x003f0101000106b8ULL, 0x000000ff00001210ULL, 0x003f0105000106bcULL,
0x000000ff000013e0ULL, 0x003f0105000106bcULL, 0x000000ff00001ca0ULL, 0x003f0107000106b0ULL,
0x000000ff00001dc0ULL, 0x003f0101000106b0ULL, 0x0000002b00001e20ULL, 0x003f010100010608ULL,
0x0000002b00001e40ULL, 0x003f01050001060cULL, 0x0000002b00002010ULL, 0x003f01050001060cULL,
0x000000ff000025c0ULL, 0x003f0105000106acULL, 0x000000ff00002790ULL, 0x003f0105000106acULL,
0x000000ff00004890ULL, 0x003f0101000106b8ULL, 0x000000ff000048c0ULL, 0x003f0105000106bcULL,
0x000000ff00004a80ULL, 0x003f0105000106bcULL, 0x000000ff000052d0ULL, 0x003f0107000106a8ULL,
0x000000ff00005350ULL, 0x003f0101000106a8ULL, 0x000000ff00005380ULL, 0x003f0105000106b4ULL,
0x000000ff00005550ULL, 0x003f0105000106b4ULL, 0x000000ff00007570ULL, 0x003f0101000106b8ULL,
0x000000ff000075e0ULL, 0x003f010100010688ULL, 0x000000ff00007640ULL, 0x003f0105000106bcULL,
0x000000ff00007810ULL, 0x003f0105000106bcULL, 0x000000ff00008060ULL, 0x003f0107000106b0ULL,
0x000000ff00008160ULL, 0x003f0101000106b0ULL, 0x0000002b000081c0ULL, 0x003f010100010628ULL,
0x0000002b000081e0ULL, 0x003f01050001062cULL, 0x0000002b000083b0ULL, 0x003f01050001062cULL,
0x000000ff00008930ULL, 0x003f0105000106acULL, 0x000000ff00008b00ULL, 0x003f0105000106acULL,
0x000000ff0000aa20ULL, 0x003f0101000106b8ULL, 0x000000ff0000aa50ULL, 0x003f0105000106bcULL,
0x000000ff0000ac10ULL, 0x003f0105000106bcULL, 0x000000ff0000b460ULL, 0x003f0107000106a8ULL,
0x000000ff0000b4e0ULL, 0x003f0101000106a8ULL, 0x000000ff0000b510ULL, 0x003f0105000106b4ULL,
0x000000ff0000b6e0ULL, 0x003f0105000106b4ULL, 0x000000ff0000d600ULL, 0x003f0101000106b8ULL,
0x000000ff0000d670ULL, 0x003f010100010690ULL, 0x000000ff0000d6c0ULL, 0x003f0105000106bcULL,
0x000000ff0000d890ULL, 0x003f0105000106bcULL, 0x000000ff0000e0e0ULL, 0x003f0107000106b0ULL,
0x000000ff0000e1e0ULL, 0x003f0101000106b0ULL, 0x0000002b0000e240ULL, 0x003f010100010648ULL,
0x0000002b0000e260ULL, 0x003f01050001064cULL, 0x0000002b0000e430ULL, 0x003f01050001064cULL,
0x000000ff0000e9b0ULL, 0x003f0105000106acULL, 0x000000ff0000eb80ULL, 0x003f0105000106acULL,
0x000000ff00010aa0ULL, 0x003f0101000106b8ULL, 0x000000ff00010ad0ULL, 0x003f0105000106bcULL,
0x000000ff00010c90ULL, 0x003f0105000106bcULL, 0x000000ff000114e0ULL, 0x003f0107000106a8ULL,
0x000000ff00011560ULL, 0x003f0101000106a8ULL, 0x000000ff00011590ULL, 0x003f0105000106b4ULL,
0x000000ff00011760ULL, 0x003f0105000106b4ULL, 0x000000ff00013680ULL, 0x003f0101000106b8ULL,
0x000000ff000136f0ULL, 0x003f010100010698ULL, 0x000000ff00013750ULL, 0x003f0105000106bcULL,
0x000000ff00013920ULL, 0x003f0105000106bcULL, 0x000000ff00014170ULL, 0x003f0107000106b0ULL,
0x000000ff00014270ULL, 0x003f0101000106b0ULL, 0x0000002b000142d0ULL, 0x003f010100010668ULL,
0x0000002b000142f0ULL, 0x003f01050001066cULL, 0x0000002b000144c0ULL, 0x003f01050001066cULL,
0x000000ff00014a40ULL, 0x003f0105000106acULL, 0x000000ff00014c10ULL, 0x003f0105000106acULL,
0x000000ff00016b30ULL, 0x003f0101000106b8ULL, 0x000000ff00016b60ULL, 0x003f0105000106bcULL,
0x000000ff00016d20ULL, 0x003f0105000106bcULL, 0x000000ff00017590ULL, 0x003f0107000106a8ULL,
0x000000ff00017610ULL, 0x003f0101000106a8ULL, 0x000000ff00017640ULL, 0x003f0105000106b4ULL,
0x000000ff00017810ULL, 0x003f0105000106b4ULL, 0x000000ff00019720ULL, 0x003f0101000106b8ULL,
0x000000ff00019780ULL, 0x003f0101000106a0ULL, 0x000000ff0001a530ULL, 0x003f010100010600ULL,
0x000000ff0001b2e0ULL, 0x003f010500010604ULL, 0x000000ff0001b4b0ULL, 0x003f010500010604ULL,
0x000000ff0001b820ULL, 0x003f010100010600ULL, 0x000000ff0001b850ULL, 0x003f010500010604ULL,
0x000000ff0001ba10ULL, 0x003f010500010604ULL, 0x0000003f0001edb0ULL, 0x003f010100000000ULL,
0x0000003f0001eee0ULL, 0x003f010500000004ULL, 0x0000003f0001f0b0ULL, 0x003f010500000004ULL,
0x0000003d000205d0ULL, 0x003f010100000000ULL, 0x0000003d00020630ULL, 0x003f010100000008ULL,
0x0000003d00020690ULL, 0x003f010100000010ULL, 0x0000003d00020700ULL, 0x003f010100000018ULL,
0x00101c0400053803ULL, 0x0001ba700001a400ULL, 0x000207400001bb40ULL, 0x000c050400000401ULL,
0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x000000000000047cULL, 0x0000001a00000002ULL, 0x000000000000037cULL,
0x0000001a00000002ULL, 0x000000000000026cULL, 0x0000001a00000002ULL, 0x0000000000000154ULL,
0x0000001a00000002ULL, 0x0000000000000044ULL, 0x0000001a00000002ULL, 0x0000000000000459ULL,
0x0000001a00000002ULL, 0x0000000000000359ULL, 0x0000001a00000002ULL, 0x0000000000000249ULL,
0x0000001a00000002ULL, 0x000000000000012fULL, 0x0000001a00000002ULL, 0x0000000000010700ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x00000000000d7919ULL, 0x000e620000002100ULL,
0x00000000000a7806ULL, 0x000fe200038e0000ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x00000000000c7919ULL, 0x000ea20000002300ULL, 0x0000000a00097300ULL, 0x000fe200000e0000ULL,
0x0000000304057899ULL, 0x000fe4000800063fULL, 0x0000000000027919ULL, 0x000ea20000002200ULL,
0x0000460000067ab9ULL, 0x000fc60000000a00ULL, 0x0000000000037919ULL, 0x000ee20000002600ULL,
0x0000000a00137309ULL, 0x000f260000000000ULL, 0x0000000000417919ULL, 0x000ee80000002700ULL,
0x00000000000b7919ULL, 0x000ee20000000000ULL, 0x00000005ff007819ULL, 0x002fe2000001160dULL,
0x000000ffff137224ULL, 0x010fca00078e0a13ULL, 0x00001fff00007589ULL, 0x000fe200000e0000ULL,
0x000001000c027a24ULL, 0x004fc600078e0202ULL, 0x00001fff0c0c7589ULL, 0x000e6200000e0000ULL,
0x00000000020d7a24ULL, 0x000fc600078e020dULL, 0x0000000000027919ULL, 0x000ea40000000000ULL,
0x000000ff0d00720cULL, 0x040fe40003f25270ULL, 0x0000000f0d00780cULL, 0x040fe40003f44070ULL,
0x000000030d00780cULL, 0x040fe40003f64070ULL, 0x0000007f0d00780cULL, 0x000fe40003f84070ULL,
0x0000000b0900720cULL, 0x008fca0003f02070ULL, 0x3fffff80ff049424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff059424ULL, 0x000fe400078e00ffULL, 0x3fffffc0ff06a424ULL, 0x000fe400078e00ffULL,
0x7fffffc0ff07a424ULL, 0x000fe200078e00ffULL, 0x01060004ff009388ULL, 0x0007e20000000a00ULL,
0x000000040c087824ULL, 0x002fe400078e0200ULL, 0xff317217ff09c424ULL, 0x000fe200078e00ffULL,
0x010608060d00a388ULL, 0x0003e20000008a00ULL, 0x0000000208087824ULL, 0x000fe200078e00ffULL,
0x000000010d00780cULL, 0x000fe20003f44070ULL, 0x00000010020e7824ULL, 0x004fe200078e00ffULL,
0x010400090d00c388ULL, 0x0005e20000004800ULL, 0x00000020080f7824ULL, 0x000fc400078e00ffULL,
0x3fffff60ff04b424ULL, 0x008fe200078e00ffULL, 0x000001f00e117812ULL, 0x000fe200078ec0ffULL,
0x7fffff60ff05b424ULL, 0x000fe400078e00ffULL, 0x3fffff80ff0a9424ULL, 0x000fe400078e00ffULL,
0x0000000803067824ULL, 0x002fe200078e00ffULL, 0x010688040d00b388ULL, 0x0003e20000008a00ULL,
0x0000000108077824ULL, 0x000fe400078e0202ULL, 0x0000000541067c24ULL, 0x000fc4000f8e0206ULL,
0x7fffff00ff09a424ULL, 0x004fe200078e00ffULL, 0xffffffe00f0f7812ULL, 0x000fe200078ee207ULL,
0x00000200ff077424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff0b9424ULL, 0x000fe400078e00ffULL,
0x000000100f0f7824ULL, 0x000fe200078e00ffULL, 0x0000000808047817ULL, 0x002fe20007800000ULL,
0x0000000106057824ULL, 0x000fc800078e0208ULL, 0x0000000104047824ULL, 0x000fe200078e0a08ULL,
0x0000000108087810ULL, 0x000fc80007ffe0ffULL, 0x000000ff0400720cULL, 0x000fe20003f63070ULL,
0x0000000106067824ULL, 0x000fe200078e0208ULL, 0x000000010400780cULL, 0x000fe20003f83070ULL,
0x00005c0005047625ULL, 0x000fc800078e0007ULL, 0x0000000108107824ULL, 0x000fe200078e0202ULL,
0x0000001104047210ULL, 0x000fe20007fbe0ffULL, 0x0000002008127824ULL, 0x000fe400078e00ffULL,
0x00005c0006067625ULL, 0x000fc600078e0007ULL, 0xffffffe012107812ULL, 0x000fe200078ee210ULL,
0x3fffff00ff08a424ULL, 0x000fe200078e00ffULL, 0x0000001106067210ULL, 0x000fe20007fde0ffULL,
0x000000ffff057224ULL, 0x000fe400028e0605ULL, 0x0000001010107824ULL, 0x000fe200078e00ffULL,
0x0106a8080d00a388ULL, 0x000fe20000008a00ULL, 0x000000ffff077224ULL, 0x000fc600030e0607ULL,
0x0106b80aff009388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040f7faeULL, 0x0003e8000d901c46ULL,
0x0000000006107faeULL, 0x0005e2000e101c46ULL, 0x000000ffff047224ULL, 0x002fc400078e0013ULL,
0x00000004ff057424ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x004fe60000000000ULL,
0x0000620041287625ULL, 0x000fe200078e0005ULL, 0x01060404ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01060000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000628287981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0c00720cULL, 0x000fc40003f05270ULL,
0x0000003f28297810ULL, 0x044fe40007ffe0ffULL, 0x000000ff28067810ULL, 0x000fe40007ffe0ffULL,
0x00000006ff297819ULL, 0x000fe40000011629ULL, 0x00000008ff2a7819ULL, 0x000fca0000011606ULL,
0x00019e2000008947ULL, 0x000fea0003800000ULL, 0x000001ff0600780cULL, 0x000fe20003f24070ULL,
0x00000008002b7824ULL, 0x000fe200078e00ffULL, 0x000000ff2900720cULL, 0x000fe20003f05270ULL,
0x00000003ff047424ULL, 0x002fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01068c042bff738cULL, 0x0003e20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010688002bff7f8cULL, 0x0005e2000c80043fULL, 0xffffffffff2c7424ULL, 0x000fe200078e00ffULL,
0x0000005000008947ULL, 0x000fea0003800000ULL, 0x0000000241047824ULL, 0x002fe400078e00ffULL,
0x00006400ff067624ULL, 0x000fc800078e00ffULL, 0x0000640004047624ULL, 0x000fc800078e0206ULL,
0x00006000042c7625ULL, 0x000fcc00078e0005ULL, 0x000000062c2c7981ULL, 0x000324000c1e1900ULL,
0x000058002c047a24ULL, 0x012fc800078e02ffULL, 0x0000004004107824ULL, 0x000fe200078e00ffULL,
0x0000043000001947ULL, 0x000fea0003800000ULL, 0x0000002b28047217ULL, 0x000fe40007800000ULL,
0x00000004ff057819ULL, 0x000fe40000011602ULL, 0x000000f00e137812ULL, 0x000fe200078ec0ffULL,
0x0000000104047824ULL, 0x000fe200078e0a2bULL, 0x0000000205077810ULL, 0x000fe20007ffe0ffULL,
0x000000012b067824ULL, 0x000fe200078e0205ULL, 0x00000004050a7810ULL, 0x040fe40007ffe0ffULL,
0x000000040500720cULL, 0x080fe20003f06070ULL, 0x000000012b087824ULL, 0x000fe200078e0207ULL,
0x00000006050b7810ULL, 0x000fe20007ffe0ffULL, 0x0000004003057824ULL, 0x000fe200078e0206ULL,
0x000000040700720cULL, 0x080fe20003f26070ULL, 0x0000000106077824ULL, 0x100fe200078e0202ULL,
0x000000040a00720cULL, 0x000fe20003f46070ULL, 0x0000001006097824ULL, 0x000fe200078e00ffULL,
0x00000005100c7210ULL, 0x000fe20007f7e0ffULL, 0x0000000108067824ULL, 0x000fc400078e0202ULL,
0x00000010080f7824ULL, 0x000fe200078e00ffULL, 0xfffffff009077812ULL, 0x000fe200078ee207ULL,
0x000000ffff0d7224ULL, 0x000fe200018e06ffULL, 0x000000040b00720cULL, 0x000fe20003f66070ULL,
0x000000012b0a7824ULL, 0x000fe200078e020aULL, 0x0000000205047810ULL, 0x000fe40007ffe0ffULL,
0x00005e000c087a11ULL, 0x000fe400078840ffULL, 0xfffffff00f097812ULL, 0x000fe400078ee206ULL,
0x0000000405067810ULL, 0x000fc40007ffe0ffULL, 0x0000000410127210ULL, 0x000fe20007fde0ffULL,
0x000000010a047824ULL, 0x000fe200078e0202ULL, 0x00005f000c0c7a11ULL, 0x000fe200020f440dULL,
0x000000100a0a7824ULL, 0x000fe200078e00ffULL, 0x0000000605057810ULL, 0x000fe40007ffe0ffULL,
0x00000006100f7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff067224ULL, 0x000fe200030e06ffULL,
0x00005e0012117a11ULL, 0x000fe400078c40ffULL, 0x00000005100d7210ULL, 0x000fe20007fbe0ffULL,
0x000000012b057824ULL, 0x000fe200078e020bULL, 0xfffffff00a0b7812ULL, 0x000fe200078ee204ULL,
0x000000ffff107224ULL, 0x000fe200020e06ffULL, 0x00005f0012127a11ULL, 0x000fe200030f4406ULL,
0x0000000105067824ULL, 0x000fe200078e0202ULL, 0x0000000813047210ULL, 0x000fe20007fde0ffULL,
0x0000001005147824ULL, 0x000fe200078e00ffULL, 0x0000c00007077811ULL, 0x000fe200078e20ffULL,
0x000000ffff0a7224ULL, 0x000fe200028e06ffULL, 0x00005e000f0e7a11ULL, 0x000fe200078840ffULL,
0x000000ffff057224ULL, 0x000fe200030e060cULL, 0x00005e000d087a11ULL, 0x000fc400078a40ffULL,
0xfffffff0140c7812ULL, 0x000fe400078ee206ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004077faeULL, 0x0003e2000c101c46ULL, 0x00005f000f0f7a11ULL, 0x000fe400020f4410ULL,
0x00005f000d0d7a11ULL, 0x000fe400028f440aULL, 0x000000130e067210ULL, 0x080fe40007f9e0ffULL,
0x0000001308087210ULL, 0x000fe40007fbe0ffULL, 0x0000c000090a7811ULL, 0x000fc400078e20ffULL,
0x0000c0000b0b7811ULL, 0x000fe200078e20ffULL, 0x000000ffff077224ULL, 0x002fe200020e060fULL,
0x0000001311047210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff097224ULL, 0x000fe200028e060dULL,
0x0000c0000c0c7811ULL, 0x000fc600078e20ffULL, 0x000000ffff057224ULL, 0x000fca00000e0612ULL,
0x00000000040a7faeULL, 0x0003e8000c901c46ULL, 0x00000000060b7faeULL, 0x0003e8000d101c46ULL,
0x00000000080c7faeULL, 0x0003e2000d901c46ULL, 0x0000038000007947ULL, 0x000fea0003800000ULL,
0x0000002b02047211ULL, 0x000fe400078fe0ffULL, 0x000000f00e137812ULL, 0x000fc400078ec0ffULL,
0x0000000204067810ULL, 0x040fe20007ffe0ffULL, 0x0000000104057824ULL, 0x140fe200078e0202ULL,
0x00000006040a7810ULL, 0x040fe20007ffe0ffULL, 0x0000001004087824ULL, 0x000fe400078e00ffULL,
0x0000000106077824ULL, 0x040fe400078e0202ULL, 0x0000001006097824ULL, 0x000fe200078e00ffULL,
0xfffffff008067812ULL, 0x000fe200078ee205ULL, 0x0000004003057824ULL, 0x000fc600078e0204ULL,
0xfffffff009097812ULL, 0x000fe400078ee207ULL, 0x0000000404077810ULL, 0x000fe40007ffe0ffULL,
0x0000000510127210ULL, 0x040fe40007f1e0ffULL, 0x0000000405087810ULL, 0x000fe20007ffe0ffULL,
0x00000010070c7824ULL, 0x000fe200078e00ffULL, 0x0000000205047810ULL, 0x040fe40007ffe0ffULL,
0x00000006050b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000107057824ULL, 0x100fe200078e0202ULL,
0x00000008100f7210ULL, 0x000fe20007f5e0ffULL, 0x000000010a077824ULL, 0x000fe200078e0202ULL,
0x0000000410117210ULL, 0x000fe20007f3e0ffULL, 0x000000100a0a7824ULL, 0x000fe200078e00ffULL,
0x0000000b100d7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x00005e0012047a11ULL, 0x000fe200078040ffULL, 0x000000ffff0e7224ULL, 0x000fe200010e06ffULL,
0xfffffff00c0b7812ULL, 0x000fe200078ee205ULL, 0x000000ffff057224ULL, 0x000fe200018e06ffULL,
0xfffffff00a0c7812ULL, 0x000fe200078ee207ULL, 0x000000ffff077224ULL, 0x000fe200008e06ffULL,
0x00005f0012127a11ULL, 0x000fc400000f4408ULL, 0x00005e0011107a11ULL, 0x000fe400078240ffULL,
0x00005e000d0a7a11ULL, 0x000fe400078640ffULL, 0x0000000413047210ULL, 0x000fe40007f1e0ffULL,
0x00005e000f087a11ULL, 0x000fe400078440ffULL, 0x00005f0011117a11ULL, 0x000fe400008f4407ULL,
0x00005f000d0d7a11ULL, 0x000fe200018f4405ULL, 0x000000ffff057224ULL, 0x000fe200000e0612ULL,
0x0000c00006077811ULL, 0x000fc400078e20ffULL, 0x0000001013067210ULL, 0x000fe40007f1e0ffULL,
0x00005f000f0e7a11ULL, 0x000fe200010f440eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004077faeULL, 0x0003e2000b901c46ULL, 0x0000000813087210ULL, 0x040fe40007f3e0ffULL,
0x0000000a130a7210ULL, 0x000fe40007f5e0ffULL, 0x0000c0000c0c7811ULL, 0x000fe400078e20ffULL,
0x0000c00009047811ULL, 0x002fe200078e20ffULL, 0x000000ffff077224ULL, 0x000fe200000e0611ULL,
0x0000c0000b057811ULL, 0x000fe200078e20ffULL, 0x000000ffff097224ULL, 0x000fc400008e060eULL,
0x000000ffff0b7224ULL, 0x000fe200010e060dULL, 0x0000000006047faeULL, 0x0003e8000b901c46ULL,
0x0000000008057faeULL, 0x0003e8000b901c46ULL, 0x000000000a0c7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x000000ff2a00720cULL, 0x000fe20003f05270ULL,
0x000000ffff2d7224ULL, 0x000fe200078e00ffULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff097224ULL, 0x000fe200078e00ffULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff247f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b800ff267f8cULL, 0x000ee2000c80043fULL, 0x000000ffff087224ULL, 0x000fe200078e00ffULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x000186c000008947ULL, 0x000fea0003800000ULL, 0x00000002412e7824ULL, 0x000fe200078e00ffULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x00006400ff1f7624ULL, 0x000fc400078e00ffULL,
0x000000ffff457224ULL, 0x002fe400078e0025ULL, 0x000064002e2e7624ULL, 0x000fe400078e021fULL,
0x000000ffff487224ULL, 0x008fe400078e0027ULL, 0xff317217ff247424ULL, 0x000fe400078e00ffULL,
0x000000ffff4d7224ULL, 0x000fe400078e00ffULL, 0x000000ffff1f7224ULL, 0x000fc400078e00ffULL,
0x0000000804057899ULL, 0x000fcc000800063fULL, 0x0000000528007c0cULL, 0x000fda000bf03070ULL,
0x000185c000000947ULL, 0x004fea0003800000ULL, 0x000000ffff2f7224ULL, 0x000fc400078e004dULL,
0x0000000000267805ULL, 0x000fca0000015200ULL, 0x0106bc00ff257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe40007804848ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff327224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000307805ULL, 0x000fcc0000015200ULL,
0x0000003026307210ULL, 0x000fca0007f1e1ffULL, 0x0000000131317824ULL, 0x000fe200000e0e27ULL,
0x003d09003000780cULL, 0x000fc80003f06070ULL, 0x000000ff3100720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403000780cULL, 0x000fc80003f06070ULL,
0x000000ff3100720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc80000011431ULL, 0x0000003025257211ULL, 0x000fca00078110ffULL,
0x000000ffff307224ULL, 0x000fca00000e0631ULL, 0x0000000225257819ULL, 0x000fc80000001230ULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000132327810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106bc00ff257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe40007804848ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000104057890ULL, 0x000fe2000fffe03fULL,
0x000058002c2c7a24ULL, 0x000fc800078e02ffULL, 0x000000402c337824ULL, 0x000fe200078e00ffULL,
0x000000052a007c0cULL, 0x000fda000bf23070ULL, 0x0000048000009947ULL, 0x000fea0003800000ULL,
0x00000004ff327819ULL, 0x000fe20000011602ULL, 0x0000002004057891ULL, 0x000fc6000f8e403fULL,
0x0000000232347810ULL, 0x040fe20007ffe0ffULL, 0x000000012b277824ULL, 0x040fe200078e0232ULL,
0x00000004323d7810ULL, 0x040fe40007ffe0ffULL, 0x00000006323f7810ULL, 0x000fe20007ffe0ffULL,
0x000000012b2c7824ULL, 0x000fe400078e0234ULL, 0x0000000127257824ULL, 0x100fe400078e0202ULL,
0x000000012c267824ULL, 0x040fe400078e0202ULL, 0x000000102c3c7824ULL, 0x000fc400078e00ffULL,
0x00000010273b7824ULL, 0x000fe400078e00ffULL, 0x000000012b317824ULL, 0x040fe200078e023dULL,
0xfffffff03c3c7812ULL, 0x000fe200078ee226ULL, 0x000000012b397824ULL, 0x000fe200078e023fULL,
0x0000002003267811ULL, 0x000fe200078e30ffULL, 0x0000000131387824ULL, 0x000fe200078e0202ULL,
0xfffffff03b3b7812ULL, 0x000fe200078ee225ULL, 0x00000010313e7824ULL, 0x000fe200078e00ffULL,
0x0000000528257c17ULL, 0x000fe2000f800000ULL, 0x0000000127277824ULL, 0x000fc400078e0226ULL,
0x000000012c2c7824ULL, 0x100fe200078e0226ULL, 0x8000000525257c10ULL, 0x000fe2000fffe0ffULL,
0x0000000131307824ULL, 0x100fe200078e0226ULL, 0x0000002733277210ULL, 0x000fe20007f1e0ffULL,
0x0000000139267824ULL, 0x000fe200078e0226ULL, 0x0000002c332c7210ULL, 0x000fe20007f5e0ffULL,
0x00000001393a7824ULL, 0x000fe200078e0202ULL, 0x0000003033307210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff317224ULL, 0x000fe200000e06ffULL, 0x0000002633337210ULL, 0x000fe20007fde0ffULL,
0x0000001039407824ULL, 0x000fe200078e00ffULL, 0x00005e0027267a11ULL, 0x000fe200078040ffULL,
0x000000ffff397224ULL, 0x000fe200010e06ffULL, 0x000000252b257217ULL, 0x000fc40007800000ULL,
0x00005f0027277a11ULL, 0x000fe200000f4431ULL, 0x0000001002317824ULL, 0x000fe200078e00ffULL,
0xfffffff03e3e7812ULL, 0x000fe200078ee238ULL, 0x0000000125257824ULL, 0x000fe200078e0a2bULL,
0xfffffff040407812ULL, 0x000fe400078ee23aULL, 0x00005e002c387a11ULL, 0x000fe400078840ffULL,
0x000000f0313a7812ULL, 0x000fe400078ec0ffULL, 0x000000253200720cULL, 0x000fc40003f66070ULL,
0x00005f002c397a11ULL, 0x000fe200020f4439ULL, 0x000000ffff2c7224ULL, 0x000fe200030e06ffULL,
0x0000003a26267210ULL, 0x000fe40007f9e0ffULL, 0x000000253400720cULL, 0x080fe20003f46070ULL,
0x000000ffff347224ULL, 0x000fe200028e06ffULL, 0x00005e0030317a11ULL, 0x000fe200078a40ffULL,
0x000000ffff277224ULL, 0x000fe200020e0627ULL, 0x000000253d00720cULL, 0x080fe40003f06070ULL,
0x000000253f00720cULL, 0x000fc40003f86070ULL, 0x0000e0003b257811ULL, 0x000fe400078e20ffULL,
0x00005f0030347a11ULL, 0x000fe400028f4434ULL, 0x0000003a38307210ULL, 0x000fe20007fbe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026257faeULL, 0x0003e2000d901c46ULL,
0x00005e0033327a11ULL, 0x000fc800078c40ffULL, 0x00005f0033337a11ULL, 0x000fe400030f442cULL,
0x0000e0003e2c7811ULL, 0x000fe400078e20ffULL, 0x0000003a31267210ULL, 0x082fe20007f7e0ffULL,
0x000000ffff317224ULL, 0x000fe200028e0639ULL, 0x0000003a32327210ULL, 0x000fe40007fbe0ffULL,
0x0000e0003c257811ULL, 0x000fe200078e20ffULL, 0x000000ffff277224ULL, 0x000fe200018e0634ULL,
0x0000e00040347811ULL, 0x000fe200078e20ffULL, 0x000000ffff337224ULL, 0x000fc400028e0633ULL,
0x0000000030257faeULL, 0x0003e8000d101c46ULL, 0x00000000262c7faeULL, 0x0003e8000c101c46ULL,
0x0000000032347faeULL, 0x0003e2000e101c46ULL, 0x000003a000007947ULL, 0x000fea0003800000ULL,
0x0000002b02257211ULL, 0x000fe400078fe0ffULL, 0x00000020032c7811ULL, 0x000fc400078e30ffULL,
0x0000000225277810ULL, 0x040fe20007ffe0ffULL, 0x0000000125267824ULL, 0x140fe200078e0202ULL,
0x0000000625347810ULL, 0x040fe20007ffe0ffULL, 0x00000010253b7824ULL, 0x000fe400078e00ffULL,
0x0000000127307824ULL, 0x040fe400078e0202ULL, 0x00000010273c7824ULL, 0x000fe200078e00ffULL,
0xfffffff03b3b7812ULL, 0x000fe200078ee226ULL, 0x0000000127267824ULL, 0x000fe400078e022cULL,
0x00000010343e7824ULL, 0x000fe200078e00ffULL, 0xfffffff03c3c7812ULL, 0x000fc400078ee230ULL,
0x0000000425307810ULL, 0x040fe20007ffe0ffULL, 0x0000000125257824ULL, 0x000fe200078e022cULL,
0x0000002633317210ULL, 0x000fc60007f5e0ffULL, 0x0000000130277824ULL, 0x100fe200078e022cULL,
0x0000002533257210ULL, 0x040fe20007f1e0ffULL, 0x00000001342c7824ULL, 0x000fe400078e022cULL,
0x0000000130327824ULL, 0x140fe200078e0202ULL, 0x0000002733277210ULL, 0x040fe20007f7e0ffULL,
0x00000010303d7824ULL, 0x000fe200078e00ffULL, 0x0000002c332c7210ULL, 0x000fe20007f9e0ffULL,
0x0000001002307824ULL, 0x000fe400078e00ffULL, 0x0000000134337824ULL, 0x000fe200078e0202ULL,
0xfffffff03d3d7812ULL, 0x000fe200078ee232ULL, 0x000000ffff397224ULL, 0x000fe200000e06ffULL,
0x00005e0025267a11ULL, 0x000fe200078040ffULL, 0x000000ffff347224ULL, 0x000fe200010e06ffULL,
0x000000f0303a7812ULL, 0x000fc400078ec0ffULL, 0xfffffff03e3e7812ULL, 0x000fe200078ee233ULL,
0x000000ffff337224ULL, 0x000fe200018e06ffULL, 0x00005f0025397a11ULL, 0x000fe200000f4439ULL,
0x000000ffff257224ULL, 0x000fe200020e06ffULL, 0x00005e0027327a11ULL, 0x000fe400078640ffULL,
0x00005e002c387a11ULL, 0x000fe400078840ffULL, 0x0000003a26267210ULL, 0x000fe40007f1e0ffULL,
0x00005e0031307a11ULL, 0x000fc400078440ffULL, 0x00005f0027337a11ULL, 0x000fe200018f4433ULL,
0x000000ffff277224ULL, 0x000fe200000e0639ULL, 0x00005f002c2c7a11ULL, 0x000fe400020f4425ULL,
0x0000e0003b257811ULL, 0x000fe400078e20ffULL, 0x00005f0031317a11ULL, 0x000fe400010f4434ULL,
0x0000003a30307210ULL, 0x080fe20007f1e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026257faeULL, 0x0003e2000b901c46ULL, 0x0000003a32327210ULL, 0x000fc40007f5e0ffULL,
0x0000003a38387210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff317224ULL, 0x000fe400000e0631ULL,
0x000000ffff337224ULL, 0x000fe400010e0633ULL, 0x000000ffff397224ULL, 0x000fe200018e062cULL,
0x0000e0003c257811ULL, 0x002fe400078e20ffULL, 0x0000e0003d267811ULL, 0x000fe400078e20ffULL,
0x0000e0003e277811ULL, 0x000fe200078e20ffULL, 0x0000000030257faeULL, 0x0003e8000b901c46ULL,
0x0000000032267faeULL, 0x0003e8000b901c46ULL, 0x0000000038277faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000009000007945ULL, 0x000fe20003800000ULL,
0xffffffffff2c7424ULL, 0x000fe200078e00ffULL, 0x000000014d257810ULL, 0x000fc80007ffe0ffULL,
0x000000292500720cULL, 0x000fda0003f06070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x000000012e267810ULL, 0x000fe20007ffe04dULL, 0x00000004ff277424ULL, 0x000fc800078e00ffULL,
0x0000600026267625ULL, 0x000fca00078e0027ULL, 0x00000006262c7981ULL, 0x000324000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff4e7f8cULL, 0x000ee2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010608002b327f8cULL, 0x0002a4000c80043fULL, 0x0000000000267805ULL, 0x002fc40000015200ULL,
0x01060c002b257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x006fe40007804833ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff347224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000307805ULL, 0x000fcc0000015200ULL, 0x0000003026307210ULL, 0x000fca0007f1e1ffULL,
0x0000000131317824ULL, 0x000fe200000e0e27ULL, 0x003d09003000780cULL, 0x000fc80003f06070ULL,
0x000000ff3100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403000780cULL, 0x000fc80003f06070ULL, 0x000000ff3100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff257819ULL, 0x000fc80000011431ULL,
0x0000003025257211ULL, 0x000fca00078110ffULL, 0x000000ffff307224ULL, 0x000fca00000e0631ULL,
0x0000000225257819ULL, 0x000fc80000001230ULL, 0x000000250000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000134347810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01060c002b257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe40007804833ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001002307824ULL, 0x000fe200078e00ffULL, 0x00000001ff257819ULL, 0x000fe20000011602ULL,
0xffffffffff327424ULL, 0x000fc600078e00ffULL, 0x0000000c25257812ULL, 0x000fe400078ec0ffULL,
0x0000007030317812ULL, 0x000fca00078ec0ffULL, 0x0000000131317824ULL, 0x000fca00078e0225ULL,
0x0100000031257984ULL, 0x000e680000000800ULL, 0x0102000031267984ULL, 0x0004e20000000800ULL,
0x000000242500720bULL, 0x002fe20003f1d000ULL, 0x0001e6527f007947ULL, 0x000fd8000b800000ULL,
0x0000000000277806ULL, 0x004fc800000e0100ULL, 0x0000ffff273a7812ULL, 0x000fe2000780c0ffULL,
0x0000047000007945ULL, 0x000fe20003800000ULL, 0x00000001ff387424ULL, 0x000fe400078e00ffULL,
0x000000ffff4c7224ULL, 0x000fc400078e0024ULL, 0x0000001fff337424ULL, 0x000fe400078e00ffULL,
0xffffffffff347424ULL, 0x000fca00078e00ffULL, 0x0000041000008947ULL, 0x000fea0003800000ULL,
0x000000ff0000720cULL, 0x000fe40003f05270ULL, 0x000000242500720bULL, 0x000fe20003f54000ULL,
0x0001e5f27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000277806ULL, 0x000fc400010e0100ULL,
0x00000025244c7209ULL, 0x000fe20007810000ULL, 0x0000035000017945ULL, 0x000fe20003800000ULL,
0x0000991027397816ULL, 0x000fc600000000ffULL, 0x0104004c31008388ULL, 0x0003e20000000800ULL,
0x000000ff3900720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x8000004c24247221ULL, 0x002fe20000010000ULL, 0x000000ff27ff7812ULL, 0x000fe2000780c0ffULL,
0x0000017000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b24247820ULL, 0x000fcc0000410000ULL,
0x0000002400247308ULL, 0x000e680000000800ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff497819ULL, 0x000fe20000011602ULL, 0x0001e5527f007947ULL, 0x000fea000b800000ULL,
0x00001f4924497589ULL, 0x0022a400000e0000ULL, 0x0000004918187220ULL, 0x084fe20000410000ULL,
0x0000004919197220ULL, 0x080fe20000410000ULL, 0x0000004914147220ULL, 0x080fe20000410000ULL,
0x0000004915157220ULL, 0x080fe20000410000ULL, 0x0000004910107220ULL, 0x080fe20000410000ULL,
0x0000004911117220ULL, 0x080fe20000410000ULL, 0x000000490c0c7220ULL, 0x080fe20000410000ULL,
0x000000490d0d7220ULL, 0x080fe20000410000ULL, 0x0000004908087220ULL, 0x080fe20000410000ULL,
0x0000004909097220ULL, 0x080fe20000410000ULL, 0x0000004904047220ULL, 0x080fe20000410000ULL,
0x0000004905057220ULL, 0x080fe20000410000ULL, 0x0000004920207220ULL, 0x080fe20000410000ULL,
0x0000004921217220ULL, 0x080fe20000410000ULL, 0x000000491c1c7220ULL, 0x080fe20000410000ULL,
0x000000491d1d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0027ff7812ULL, 0x000fe2000780c0ffULL, 0x000000242d2d7220ULL, 0x002fd80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000802497811ULL, 0x000fe200078ff0ffULL,
0x0001e4327f007947ULL, 0x000fea000b800000ULL, 0x00001f4924497589ULL, 0x0002a400000e0000ULL,
0x000000491a1a7220ULL, 0x084fe20000410000ULL, 0x000000491b1b7220ULL, 0x080fe20000410000ULL,
0x0000004916167220ULL, 0x080fe20000410000ULL, 0x0000004917177220ULL, 0x080fe20000410000ULL,
0x0000004912127220ULL, 0x080fe20000410000ULL, 0x0000004913137220ULL, 0x080fe20000410000ULL,
0x000000490e0e7220ULL, 0x080fe20000410000ULL, 0x000000490f0f7220ULL, 0x080fe20000410000ULL,
0x000000490a0a7220ULL, 0x080fe20000410000ULL, 0x000000490b0b7220ULL, 0x080fe20000410000ULL,
0x0000004906067220ULL, 0x080fe20000410000ULL, 0x0000004907077220ULL, 0x080fe20000410000ULL,
0x0000004922227220ULL, 0x080fe20000410000ULL, 0x0000004923237220ULL, 0x080fe20000410000ULL,
0x000000491e1e7220ULL, 0x080fe20000410000ULL, 0x000000491f1f7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff3aff7812ULL, 0x000fda0007806027ULL,
0x8000004c25250221ULL, 0x000fe20000010000ULL, 0x00007610ff380816ULL, 0x000fc60000000038ULL,
0x3fb8aa3b25250820ULL, 0x000fc80000410000ULL, 0x0000002500350308ULL, 0x000e640000000800ULL,
0x0000003526260220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002d262d7221ULL, 0x008fc20000010000ULL, 0x0000000000247805ULL, 0x000fcc0000015200ULL,
0x0106ac00ff267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fe40007804845ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624397210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09003900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff267819ULL, 0x000fc80000011427ULL,
0x0000003926267211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x0000000226267819ULL, 0x000fc80000001227ULL, 0x000000260000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013a3a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106ac00ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe40007804845ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991038247816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff2400720cULL, 0x000fda0003f45270ULL, 0x0000012000002947ULL, 0x000fea0003800000ULL,
0x00000035ff24723eULL, 0x000fe400000010ffULL, 0x00000002ff257819ULL, 0x000fe40000011602ULL,
0x0000541024247816ULL, 0x000fe20000000024ULL, 0x0001e0327f007947ULL, 0x000fea000b800000ULL,
0x00001f2524367589ULL, 0x0002a400000e0000ULL, 0x0000000825377810ULL, 0x000fe20007ffe0ffULL,
0x0001e0627f007947ULL, 0x000fea000b800000ULL, 0x00001f3724377589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001025497810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4a7224ULL, 0x000fe200078e0024ULL, 0x000028f000487802ULL, 0x000fc40000000f00ULL,
0x0001ee9000007944ULL, 0x01efea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001825497810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff4a7224ULL, 0x004fe200078e0024ULL,
0x0000294000487802ULL, 0x000fc40000000f00ULL, 0x0001ee4000007944ULL, 0x01afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000008023f7812ULL, 0x000fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000004ff387819ULL, 0x000fc40000011602ULL,
0x000000073f3f7812ULL, 0x000fe400078ef802ULL, 0x0000000200247811ULL, 0x04afe200078e10ffULL,
0x0000000400517824ULL, 0x000fe200078e0238ULL, 0x0000000702597812ULL, 0x000fe200078ec0ffULL,
0x000000103f267824ULL, 0x040fe400078e00ffULL, 0x000000013f257824ULL, 0x000fe200078e0251ULL,
0x0000000859597812ULL, 0x000fe200078ef802ULL, 0x0000000138507824ULL, 0x000fc600078e0224ULL,
0xfffffff026257812ULL, 0x000fe200078ee225ULL, 0x0000000138587824ULL, 0x000fc600078e0259ULL,
0x0000c00025397811ULL, 0x000fe200078e20ffULL, 0x000000013f257824ULL, 0x000fc800078e0250ULL,
0x000000003944783bULL, 0x000e620000004200ULL, 0xfffffff026257812ULL, 0x000fc800078ee225ULL,
0x0000c000253a7811ULL, 0x000fe400078e20ffULL, 0x000000103f257812ULL, 0x000fc600078efcffULL,
0x000000003a48783bULL, 0x004ea20000004200ULL, 0x0000002425527210ULL, 0x000fe20007ffe038ULL,
0x0000000151537824ULL, 0x000fe400078e0225ULL, 0x0000001025267824ULL, 0x040fe400078e00ffULL,
0x0000001025257824ULL, 0x000fc600078e00ffULL, 0xfffffff026537812ULL, 0x000fe400078ee253ULL,
0xfffffff025527812ULL, 0x000fe400078ee252ULL, 0x0000c000533b7811ULL, 0x000fe400078e20ffULL,
0x0000c000523c7811ULL, 0x000fc600078e20ffULL, 0x000000003b40783bULL, 0x000ee80000004200ULL,
0x000000003c24783bULL, 0x000ee20000004200ULL, 0x00000044003d7306ULL, 0x002fe20000009400ULL,
0x00000018ffb57819ULL, 0x000fe20000011444ULL, 0x0000010044567824ULL, 0x000fe200078e00ffULL,
0x00000018ffaa7819ULL, 0x000fe20000011445ULL, 0x0000010046ca7824ULL, 0x040fe200078e00ffULL,
0x00000018ffa07819ULL, 0x000fe20000011446ULL, 0x0001000046bd7824ULL, 0x000fe200078e00ffULL,
0x00000018ffcb7819ULL, 0x000fe20000011456ULL, 0x00000044005d7306ULL, 0x000e620000005400ULL,
0x00000018ffca7819ULL, 0x000fe200000114caULL, 0x0000010048b37824ULL, 0x044fe200078e00ffULL,
0x00000018ffbd7819ULL, 0x000fe200000114bdULL, 0x0000010047be7824ULL, 0x000fe200078e00ffULL,
0x00000018ff907819ULL, 0x000fe20000011448ULL, 0x0000010049b27824ULL, 0x000fe200078e00ffULL,
0x00000018ffb37819ULL, 0x000fe200000114b3ULL, 0x0000004400797306ULL, 0x0004e2000000d400ULL,
0x00000018ffbe7819ULL, 0x000fe200000114beULL, 0x0001000047bb7824ULL, 0x000fe200078e00ffULL,
0x00000018ffb27819ULL, 0x000fe200000114b2ULL, 0x0001000048ba7824ULL, 0x000fe200078e00ffULL,
0x00000018ff9f7819ULL, 0x000fe20000011447ULL, 0x000001004a9c7824ULL, 0x000fe200078e00ffULL,
0x00000018ffbb7819ULL, 0x000fe200000114bbULL, 0x0000004600b87306ULL, 0x000fe20000009400ULL,
0x0001000044447824ULL, 0x004fe200078e00ffULL, 0x0000005d3d00720bULL, 0x002fe20003f7d000ULL,
0x0001000049ae7824ULL, 0x000fe200078e00ffULL, 0x00000018ffba7819ULL, 0x000fe200000114baULL,
0x000100004a8d7824ULL, 0x000fe200078e00ffULL, 0x00000018ffce7819ULL, 0x000fe20000011444ULL,
0x0000010045447824ULL, 0x000fe200078e00ffULL, 0x0000004600b47306ULL, 0x000e620000005400ULL,
0x00000018ff9c7819ULL, 0x000fe2000001149cULL, 0x000001004b8e7824ULL, 0x040fe200078e00ffULL,
0x00000018ffae7819ULL, 0x000fe200000114aeULL, 0x000100004b8a7824ULL, 0x000fe200078e00ffULL,
0x00000018ffd17819ULL, 0x000fc40000011444ULL, 0x0000000179793812ULL, 0x008fe200078efcffULL,
0x000000b500a27306ULL, 0x000fe20000209400ULL, 0x00000018ff897819ULL, 0x000fe40000011440ULL,
0x00000018ff8d7819ULL, 0x000fe4000001148dULL, 0x00000018ff3e7819ULL, 0x000fe40000011449ULL,
0x00000018ff807819ULL, 0x000fe2000001144bULL, 0x000000d100d27306ULL, 0x000fe20000209400ULL,
0x000000b4b800720bULL, 0x002fc40003f7d000ULL, 0x000000d100b47245ULL, 0x000fe4000020d400ULL,
0x00000018ff8e7819ULL, 0x000fe4000001148eULL, 0x00000018ff687819ULL, 0x000fe20000011424ULL,
0x000000d100d37306ULL, 0x000e620000205400ULL, 0x00000018ff627819ULL, 0x000fe40000011425ULL,
0x00000018ff837819ULL, 0x000fe4000001144aULL, 0x00000018ff8a7819ULL, 0x000fc4000001148aULL,
0x00000018ff567819ULL, 0x000fe20000011426ULL, 0x000000b5009e7306ULL, 0x0004e20000205400ULL,
0x00000018ff577819ULL, 0x000fe40000011427ULL, 0x00000002583d7810ULL, 0x000fca0007ffe0ffULL,
0x000000cb00a37306ULL, 0x000fe20000209400ULL, 0x000000d3d200720bULL, 0x002fe40003fbd000ULL,
0x000000b500b57245ULL, 0x004fca000020d400ULL, 0x000000cb00cd7306ULL, 0x000e620000205400ULL,
0x0000009ea200720bULL, 0x008fe40003f9d000ULL, 0x000000cb009e7245ULL, 0x000fe4000020d400ULL,
0x000000ce00a27245ULL, 0x000fe4000020d400ULL, 0x00000001b4b45812ULL, 0x000fe200078efcffULL,
0x000000ca00d77306ULL, 0x000fec0000209400ULL, 0x00000001b5b54812ULL, 0x000fc400078efcffULL,
0x000000ca00d87306ULL, 0x0004e20000205400ULL, 0x000000cda300720bULL, 0x002fe20003fdd000ULL,
0x0000010040a37824ULL, 0x000fe400078e00ffULL, 0x0000000859cd7824ULL, 0x000fc600078e00ffULL,
0x00000018ffa37819ULL, 0x000fe200000114a3ULL, 0x000000ce00cf7306ULL, 0x000fe20000209400ULL,
0x000000ca00ca7245ULL, 0x004fe4000020d400ULL, 0xfffffff8cd3d7812ULL, 0x000fc600078ee23dULL,
0x000000019e9e6812ULL, 0x000fe400078efcffULL, 0x000000ce00d07306ULL, 0x000e620000205400ULL,
0x000000d8d700720bULL, 0x008fce0003fbd000ULL, 0x0000004500b77306ULL, 0x000fec0000009400ULL,
0x00000001caca5812ULL, 0x000fe400078efcffULL, 0x0000004500b67306ULL, 0x000ea20000005400ULL,
0x000000d0cf00720bULL, 0x002fce0003f1d000ULL, 0x0000004500787306ULL, 0x0002ec000000d400ULL,
0x00000001a2a20812ULL, 0x000fe400078efcffULL, 0x000000aa00af7306ULL, 0x000fe20000209400ULL,
0x0001000045457824ULL, 0x002fe200078e00ffULL, 0x000000b6b700720bULL, 0x004fc40003fdd000ULL,
0x000000a2b5a2723eULL, 0x000fe400000010ffULL, 0x00000018ffd47819ULL, 0x000fe40000011445ULL,
0x000000aa00b17306ULL, 0x0002ae0000205400ULL, 0x0000000178786812ULL, 0x008fe200078efcffULL,
0x000000bd00c97306ULL, 0x000fe20000209400ULL, 0x000000aa00aa7245ULL, 0x002fce000020d400ULL,
0x000000bd00cc7306ULL, 0x0002e20000205400ULL, 0x000000b1af00720bULL, 0x004fe40003f9d000ULL,
0x000000d400af7245ULL, 0x000fca000020d400ULL, 0x000000d400d57306ULL, 0x000fe20000209400ULL,
0x000000bd00bd7245ULL, 0x002fca000020d400ULL, 0x00000001aaaa4812ULL, 0x000fe400078efcffULL,
0x000000d400d67306ULL, 0x000e620000205400ULL, 0x000000ccc900720bULL, 0x008fce0003fbd000ULL,
0x0000004600757306ULL, 0x0004ec000000d400ULL, 0x00000001bdbd5812ULL, 0x000fe400078efcffULL,
0x000000a000a77306ULL, 0x000fe20000209400ULL, 0x000000d6d500720bULL, 0x002fe40003f1d000ULL,
0x00000018ff467819ULL, 0x004fca0000011441ULL, 0x000000a000a67306ULL, 0x0002a20000205400ULL,
0x0000000175753812ULL, 0x008fca00078efcffULL, 0x00000001afaf0812ULL, 0x000fe400078efcffULL,
0x0000004800a97306ULL, 0x000fe20000009400ULL, 0x000000a000a07245ULL, 0x002fce000020d400ULL,
0x0000004800a87306ULL, 0x000e620000005400ULL, 0x000000a6a700720bULL, 0x004fce0003f7d000ULL,
0x0000004700ab7306ULL, 0x000fec0000009400ULL, 0x00000001a0a03812ULL, 0x000fe400078efcffULL,
0x0000004700ac7306ULL, 0x000ea20000005400ULL, 0x000000a8a900720bULL, 0x002fe40003f9d000ULL,
0x000000bda0a0723eULL, 0x000fca00000010ffULL, 0x000000b300c47306ULL, 0x000ff00000209400ULL,
0x000000b300bf7306ULL, 0x0002e20000205400ULL, 0x000000acab00720bULL, 0x004fce0003fdd000ULL,
0x000000be00d97306ULL, 0x000fe20000209400ULL, 0x000000b300b37245ULL, 0x002fce000020d400ULL,
0x000000be00da7306ULL, 0x0002a20000205400ULL, 0x000000bfc400720bULL, 0x008fe20003fbd000ULL,
0x0001000043bf7824ULL, 0x000fca00078e00ffULL, 0x00000018ffbf7819ULL, 0x000fe200000114bfULL,
0x000000b200c37306ULL, 0x000fe20000209400ULL, 0x000000be00be7245ULL, 0x002fca000020d400ULL,
0x00000001b3b35812ULL, 0x000fe400078efcffULL, 0x000000b200c57306ULL, 0x0002e20000205400ULL,
0x000000dad900720bULL, 0x004fce0003f1d000ULL, 0x0000004800707306ULL, 0x0004a2000000d400ULL,
0x000000b200b27245ULL, 0x002fca000020d400ULL, 0x00000001bebe0812ULL, 0x000fe400078efcffULL,
0x0000009000947306ULL, 0x000fe20000209400ULL, 0x000000c5c300720bULL, 0x008fe40003f7d000ULL,
0x00000018ff487819ULL, 0x004fca0000011443ULL, 0x0000009000967306ULL, 0x000e620000205400ULL,
0x0000000170704812ULL, 0x000fc800078efcffULL, 0x00000070b370723eULL, 0x000fe400000010ffULL,
0x00000001b2b23812ULL, 0x000fe200078efcffULL, 0x0000004700727306ULL, 0x000eb0000000d400ULL,
0x000000bb00c77306ULL, 0x000fe20000209400ULL, 0x000000969400720bULL, 0x002fe20003f9d000ULL,
0x0001000042947824ULL, 0x000fca00078e00ffULL, 0x00000018ff947819ULL, 0x000fe20000011494ULL,
0x000000bb00c87306ULL, 0x0002e20000205400ULL, 0x0000000172726812ULL, 0x004fce00078efcffULL,
0x000000ba00c07306ULL, 0x000fe20000209400ULL, 0x000000bb00bb7245ULL, 0x002fce000020d400ULL,
0x000000ba00c67306ULL, 0x0002a20000205400ULL, 0x000000c8c700720bULL, 0x008fce0003fdd000ULL,
0x0000009f00a47306ULL, 0x000fe20000209400ULL, 0x000000ba00ba7245ULL, 0x002fca000020d400ULL,
0x00000001bbbb6812ULL, 0x000fe400078efcffULL, 0x0000009f00a57306ULL, 0x0002e20000205400ULL,
0x000000c6c000720bULL, 0x004fe20003fbd000ULL, 0x0001000025c07824ULL, 0x000fca00078e00ffULL,
0x00000018ffc07819ULL, 0x000fe200000114c0ULL, 0x0000004b008f7306ULL, 0x000fe20000009400ULL,
0x0000009f009f7245ULL, 0x002fca000020d400ULL, 0x00000001baba5812ULL, 0x000fe400078efcffULL,
0x0000004b00927306ULL, 0x000e620000005400ULL, 0x000000a5a400720bULL, 0x008fce0003f1d000ULL,
0x0000009c00c17306ULL, 0x000fec0000209400ULL, 0x000000019f9f0812ULL, 0x000fe400078efcffULL,
0x0000009c00c27306ULL, 0x0004e20000205400ULL, 0x000000928f00720bULL, 0x002fe20003f7d000ULL,
0x00010000278f7824ULL, 0x000fe200078e00ffULL, 0x0000009000927245ULL, 0x000fe2000020d400ULL,
0x0001000026907824ULL, 0x000fc600078e00ffULL, 0x0000000192924812ULL, 0x000fe200078efcffULL,
0x00000049009a7306ULL, 0x000fe20000009400ULL, 0x0000009c009c7245ULL, 0x004fe4000020d400ULL,
0x000000ba92ba723eULL, 0x000fe400000010ffULL, 0x00000018ff907819ULL, 0x000fe40000011490ULL,
0x00000018ff8f7819ULL, 0x000fe2000001148fULL, 0x00000049009b7306ULL, 0x000e620000005400ULL,
0x000000c2c100720bULL, 0x008fce0003f9d000ULL, 0x000000ae00b97306ULL, 0x000fec0000209400ULL,
0x000000019c9c4812ULL, 0x000fe400078efcffULL, 0x000000ae00bc7306ULL, 0x0004e20000205400ULL,
0x0000009b9a00720bULL, 0x002fce0003fdd000ULL, 0x0000004a00977306ULL, 0x000fe20000009400ULL,
0x000000ae00ae7245ULL, 0x004fce000020d400ULL, 0x0000004a00957306ULL, 0x000e620000005400ULL,
0x000000bcb900720bULL, 0x008fe20003fbd000ULL, 0x0000010024b97824ULL, 0x040fe400078e00ffULL,
0x0001000024bc7824ULL, 0x000fc600078e00ffULL, 0x00000018ffb97819ULL, 0x000fe200000114b9ULL,
0x0000004000817306ULL, 0x000fe20000009400ULL, 0x00000018ffbc7819ULL, 0x000fca00000114bcULL,
0x00000001aeae5812ULL, 0x000fe400078efcffULL, 0x0000004000827306ULL, 0x000fe20000005400ULL,
0x000000959700720bULL, 0x002fe40003f1d000ULL, 0x0000003e00957245ULL, 0x000fca000020d400ULL,
0x0000004000607306ULL, 0x0003f0000000d400ULL, 0x0000008d009d7306ULL, 0x000fe20000209400ULL,
0x0001000040407824ULL, 0x002fca00078e00ffULL, 0x00000018ffb17819ULL, 0x000fe20000011440ULL,
0x0000010041407824ULL, 0x000fe200078e00ffULL, 0x0000008d00a17306ULL, 0x0002a80000205400ULL,
0x00000018ffa87819ULL, 0x000fe20000011440ULL, 0x0000010042407824ULL, 0x000fc600078e00ffULL,
0x0000004900717306ULL, 0x000ee2000000d400ULL, 0x0000008d008d7245ULL, 0x002fe4000020d400ULL,
0x00000018ff9a7819ULL, 0x000fe20000011440ULL, 0x0000010043407824ULL, 0x000fc800078e00ffULL,
0x0000004a006f7306ULL, 0x000262000000d400ULL, 0x000000a19d00720bULL, 0x004fe40003f9d000ULL,
0x00000018ffa77819ULL, 0x000fe40000011440ULL, 0x000000bb9fa1723eULL, 0x000fc600000010ffULL,
0x0000003e00937306ULL, 0x000fe20000209400ULL, 0x0000000171716812ULL, 0x008fe400078efcffULL,
0x00000018ff4a7819ULL, 0x002fe40000011442ULL, 0x00000071b271723eULL, 0x000fe400000010ffULL,
0x000000018d8d4812ULL, 0x000fe200078efcffULL, 0x0000003e00917306ULL, 0x000e620000205400ULL,
0x000000016f6f0812ULL, 0x000fe400078efcffULL, 0x000000828100720bULL, 0x000fc40003f9d000ULL,
0x0000008000817245ULL, 0x000fc6000020d400ULL, 0x0000008000857306ULL, 0x000ff00000209400ULL,
0x0000008000847306ULL, 0x0004e20000205400ULL, 0x000000919300720bULL, 0x002fe20003fdd000ULL,
0x0000010026937824ULL, 0x000fe200078e00ffULL, 0x0000000160604812ULL, 0x000fe200078efcffULL,
0x0000010027917824ULL, 0x000fc600078e00ffULL, 0x00000018ff937819ULL, 0x000fe20000011493ULL,
0x0000002400777306ULL, 0x000fe20000009400ULL, 0x000000a300807245ULL, 0x004fe4000020d400ULL,
0x00000018ff917819ULL, 0x000fc60000011491ULL, 0x0000000195956812ULL, 0x000fe400078efcffULL,
0x0000002400767306ULL, 0x000fe20000005400ULL, 0x000000848500720bULL, 0x008fe40003f1d000ULL,
0x000000ae95bb723eULL, 0x000fca00000010ffULL, 0x00000024005a7306ULL, 0x0003ec000000d400ULL,
0x0000000181810812ULL, 0x000fe400078efcffULL, 0x0000002500737306ULL, 0x000fe20000009400ULL,
0x0000010025247824ULL, 0x002fce00078e00ffULL, 0x0000002500747306ULL, 0x000ff00000005400ULL,
0x00000025005b7306ULL, 0x0003f0000000d400ULL, 0x0000008e00ad7306ULL, 0x000fe20000209400ULL,
0x0000000859257824ULL, 0x002fca00078e00ffULL, 0xfffffff8253e7812ULL, 0x000fe400078ee258ULL,
0x0000008e00b07306ULL, 0x0002a20000205400ULL, 0x00000078b425723eULL, 0x000fe400000010ffULL,
0x0000a0003e407811ULL, 0x000fca00078e20ffULL, 0x00000041007f7306ULL, 0x000fe20000009400ULL,
0x0000008e008e7245ULL, 0x002fce000020d400ULL, 0x00000041007e7306ULL, 0x000e620000005400ULL,
0x000000b0ad00720bULL, 0x004fce0003fbd000ULL, 0x0000004100617306ULL, 0x0004ec000000d400ULL,
0x000000018e8e5812ULL, 0x000fe400078efcffULL, 0x0000008300877306ULL, 0x000fe20000209400ULL,
0x0001000041417824ULL, 0x004fe200078e00ffULL, 0x0000007e7f00720bULL, 0x002fc80003f1d000ULL,
0x00000018ffa57819ULL, 0x000fe40000011441ULL, 0x0000008300887306ULL, 0x0002ae0000205400ULL,
0x0000000161610812ULL, 0x008fe200078efcffULL, 0x00000042007d7306ULL, 0x000fe20000009400ULL,
0x0000008300837245ULL, 0x002fce000020d400ULL, 0x00000042007c7306ULL, 0x000e620000005400ULL,
0x000000888700720bULL, 0x004fce0003fdd000ULL, 0x00000042005e7306ULL, 0x000eac000000d400ULL,
0x0000000183836812ULL, 0x000fe400078efcffULL, 0x00000043007a7306ULL, 0x000fe20000009400ULL,
0x0000007c7d00720bULL, 0x002fce0003f9d000ULL, 0x00000043007b7306ULL, 0x000fec0000005400ULL,
0x000000015e5e4812ULL, 0x004fe400078efcffULL, 0x00000043005f7306ULL, 0x0003f0000000d400ULL,
0x0000008a00987306ULL, 0x000fe20000209400ULL, 0x000000004040783bULL, 0x002e6e0000000200ULL,
0x0000008a00997306ULL, 0x0004f00000205400ULL, 0x000000b100b77306ULL, 0x000fe20000209400ULL,
0x0000008a008a7245ULL, 0x004fce000020d400ULL, 0x000000b100ab7306ULL, 0x0004620000205400ULL,
0x000000999800720bULL, 0x008fce0003fbd000ULL, 0x0000009a00967306ULL, 0x000fe20000209400ULL,
0x000000b100b17245ULL, 0x004fca000020d400ULL, 0x000000018a8a5812ULL, 0x000fe400078efcffULL,
0x0000009a009b7306ULL, 0x0004e20000205400ULL, 0x000000abb700720bULL, 0x002fe20003fdd000ULL,
0x000000364040a231ULL, 0x080fe400003400ffULL, 0x000000364242a231ULL, 0x000fe400003400ffULL,
0x000000374141a231ULL, 0x080fe400003400ffULL, 0x0000004b006e7306ULL, 0x000e62000000d400ULL,
0x0000009a009a7245ULL, 0x004fe2000020d400ULL, 0x000000374343a231ULL, 0x000fc800003400ffULL,
0x00000001b1b16812ULL, 0x000fe400078efcffULL, 0x000000a300cb7306ULL, 0x000fe20000209400ULL,
0x0000009b9600720bULL, 0x008fe20003f1d000ULL, 0x000000704008723cULL, 0x040b620000041808ULL,
0x0000007b7a00720bULL, 0x000fe40003fdd000ULL, 0x00000018ff7b7819ULL, 0x000fe40000011424ULL,
0x000000799e24723eULL, 0x000fe200000010ffULL, 0x000000a300b67306ULL, 0x0004e20000205400ULL,
0x000000016e6e3812ULL, 0x002fe200078efcffULL, 0x000000a0400c723cULL, 0x000fe2000004180cULL,
0x0000004a00707245ULL, 0x020fc4000020d400ULL, 0x000000bf00717245ULL, 0x000fe4000020d400ULL,
0x000000019a9a0812ULL, 0x000fe200078efcffULL, 0x00000089008b7306ULL, 0x000fe20000209400ULL,
0x000000015f5f6812ULL, 0x000fe200078efcffULL, 0x000000244018723cULL, 0x000b620000041818ULL,
0x000000afaaa3723eULL, 0x004fe400000010ffULL, 0x0000005e9a5e723eULL, 0x000fc600000010ffULL,
0x00000089008c7306ULL, 0x0002a20000205400ULL, 0x000000b6cb00720bULL, 0x008fe20003f7d000ULL,
0x000000a24014723cULL, 0x000f640000041814ULL, 0x0000a0003d247811ULL, 0x020fc800078e20ffULL,
0x000000a700ac7306ULL, 0x000fe20000209400ULL, 0x0000008900897245ULL, 0x002fe2000020d400ULL,
0x000000ba4004723cULL, 0x000fe80000041804ULL, 0x0000000180803812ULL, 0x000fe400078efcffULL,
0x000000a700b87306ULL, 0x0002e20000205400ULL, 0x0000008c8b00720bULL, 0x004fce0003fbd000ULL,
0x000000a800a97306ULL, 0x000fe20000209400ULL, 0x000000a700a77245ULL, 0x002fca000020d400ULL,
0x0000000189895812ULL, 0x000fe400078efcffULL, 0x000000a800a47306ULL, 0x0002a20000205400ULL,
0x000000b8ac00720bULL, 0x008fce0003f1d000ULL, 0x000000a500a67306ULL, 0x000fe20000209400ULL,
0x000000a800a87245ULL, 0x002fca000020d400ULL, 0x00000001a7a70812ULL, 0x000fe400078efcffULL,
0x000000a500977306ULL, 0x0002e20000205400ULL, 0x000000a4a900720bULL, 0x004fe40003f7d000ULL,
0x0000005fa75f723eULL, 0x000fca00000010ffULL, 0x0000004a00457306ULL, 0x000fe20000209400ULL,
0x000000a500a57245ULL, 0x002fca000020d400ULL, 0x00000001a8a83812ULL, 0x000fe400078efcffULL,
0x0000004a00447306ULL, 0x0002a20000205400ULL, 0x00000097a600720bULL, 0x008fce0003fbd000ULL,
0x00000026006c7306ULL, 0x000fe20000009400ULL, 0x0000006f9c4a723eULL, 0x002fca00000010ffULL,
0x00000001a5a55812ULL, 0x000fe400078efcffULL, 0x00000026006b7306ULL, 0x000fe20000005400ULL,
0x000000444500720bULL, 0x004fe40003f9d000ULL, 0x000000767700720bULL, 0x000fe40003fbd000ULL,
0x0000004600767245ULL, 0x000fc6000020d400ULL, 0x0000002600547306ULL, 0x000fec000000d400ULL,
0x0000000170704812ULL, 0x000fe400078efcffULL, 0x0000002700677306ULL, 0x000fe20000009400ULL,
0x000000015a5a5812ULL, 0x000fce00078efcffULL, 0x0000002700697306ULL, 0x000ff00000005400ULL,
0x0000002700557306ULL, 0x000ff0000000d400ULL, 0x0000009400267306ULL, 0x000ff00000209400ULL,
0x0000009400277306ULL, 0x0002b00000205400ULL, 0x0000004600477306ULL, 0x000fe20000209400ULL,
0x0000009400947245ULL, 0x002fce000020d400ULL, 0x0000004600867306ULL, 0x0002e20000205400ULL,
0x000000272600720bULL, 0x004fe40003f1d000ULL, 0x000000002424783bULL, 0x000eaa0000000200ULL,
0x000000b9007e7306ULL, 0x000fe20000209400ULL, 0x00000075ca46723eULL, 0x002fca00000010ffULL,
0x0000000194940812ULL, 0x000fe400078efcffULL, 0x000000b9007a7306ULL, 0x0002620000205400ULL,
0x000000864700720bULL, 0x008fe40003f7d000ULL, 0x00000072be47723eULL, 0x000fe400000010ffULL,
0x000000947070723eULL, 0x000fc600000010ffULL, 0x000000bf00847306ULL, 0x000fe20000209400ULL,
0x000000b900b97245ULL, 0x002fe2000020d400ULL, 0x000000464044723cULL, 0x000b680000041810ULL,
0x0000000176763812ULL, 0x000fe400078efcffULL, 0x000000bf00827306ULL, 0x000e620000205400ULL,
0x0000007a7e00720bULL, 0x000fe40003f9d000ULL, 0x0000008d8310723eULL, 0x020fc400000010ffULL,
0x0000008a8111723eULL, 0x000fe400000010ffULL, 0x000000747300720bULL, 0x000fe20003f7d000ULL,
0x0000007b007c7306ULL, 0x000fe20000209400ULL, 0x000000362424a231ULL, 0x004fc600003400ffULL,
0x00000010401c723cULL, 0x000be2000004181cULL, 0x000000362626a231ULL, 0x000fe200003400ffULL,
0x00000001b9b94812ULL, 0x000fe200078efcffULL, 0x000000372525a231ULL, 0x080fe200003400ffULL,
0x0000007b00787306ULL, 0x0004e20000205400ULL, 0x000000828400720bULL, 0x002fe20003fdd000ULL,
0x000000372727a231ULL, 0x000fe200003400ffULL, 0x000000b18910723eULL, 0x020fe400000010ffULL,
0x000000015b5b3812ULL, 0x000fe400078efcffULL, 0x000000a57611723eULL, 0x000fe200000010ffULL,
0x000000bc00777306ULL, 0x000fe20000209400ULL, 0x0000007b007b7245ULL, 0x004fc4000020d400ULL,
0x0000005ab95a723eULL, 0x000fc600000010ffULL, 0x0000000171716812ULL, 0x000fe400078efcffULL,
0x000000bc00727306ULL, 0x0002a20000205400ULL, 0x000000787c00720bULL, 0x008fe40003f9d000ULL,
0x0000006b6c00720bULL, 0x000fe40003fdd000ULL, 0x00000048006b7245ULL, 0x000fc6000020d400ULL,
0x0000004800497306ULL, 0x000fe20000209400ULL, 0x000000bc00bc7245ULL, 0x002fca000020d400ULL,
0x000000017b7b4812ULL, 0x000fe400078efcffULL, 0x00000048004b7306ULL, 0x000e620000205400ULL,
0x000000727700720bULL, 0x004fe40003fbd000ULL, 0x0000000154546812ULL, 0x000fe400078efcffULL,
0x0000005b7b5b723eULL, 0x000fc600000010ffULL, 0x00000068006d7306ULL, 0x000fe80000209400ULL,
0x0000005a2408723cULL, 0x000fe40000041808ULL, 0x00000001bcbc5812ULL, 0x000fe400078efcffULL,
0x00000068006a7306ULL, 0x0004e20000205400ULL, 0x0000004b4900720bULL, 0x002fe40003f1d000ULL,
0x0000006e8e4b723eULL, 0x000fca00000010ffULL, 0x0000006200657306ULL, 0x000fe20000209400ULL,
0x0000006800687245ULL, 0x004fe2000020d400ULL, 0x0000004a4048723cULL, 0x000b680000041820ULL,
0x000000016b6b0812ULL, 0x000fe400078efcffULL, 0x0000006200667306ULL, 0x0002a20000205400ULL,
0x0000006a6d00720bULL, 0x008fe40003f9d000ULL, 0x000000608020723eULL, 0x020fc400000010ffULL,
0x00000061a821723eULL, 0x000fe400000010ffULL, 0x000000696700720bULL, 0x000fe20003f1d000ULL,
0x000000c000127306ULL, 0x000fe20000209400ULL, 0x0000006200627245ULL, 0x002fe4000020d400ULL,
0x000000c000697245ULL, 0x000fe2000020d400ULL, 0x000000202420723cULL, 0x000b620000041818ULL,
0x000000716b71723eULL, 0x000fe400000010ffULL, 0x0000000168684812ULL, 0x000fe200078efcffULL,
0x000000c000137306ULL, 0x000e620000205400ULL, 0x000000666500720bULL, 0x004fc40003fbd000ULL,
0x0000009100197245ULL, 0x020fe2000020d400ULL, 0x00000070240c723cULL, 0x000b62000004180cULL,
0x0000000155550812ULL, 0x000fe400078efcffULL, 0x000000bc6868723eULL, 0x000fe200000010ffULL,
0x0000009300737306ULL, 0x000fec0000209400ULL, 0x0000000162625812ULL, 0x000fc400078efcffULL,
0x00000093006e7306ULL, 0x0004e20000205400ULL, 0x000000131200720bULL, 0x002fe40003f7d000ULL,
0x000000102410723cULL, 0x040b6a0000041814ULL, 0x00000091006c7306ULL, 0x000fe20000209400ULL,
0x0000009300937245ULL, 0x004fe4000020d400ULL, 0x0000005e2414723cULL, 0x000b660000041844ULL,
0x0000000169693812ULL, 0x000fc400078efcffULL, 0x0000009100417306ULL, 0x000e620000205400ULL,
0x0000006e7300720bULL, 0x008fe40003f9d000ULL, 0x000000696269723eULL, 0x000fca00000010ffULL,
0x0000005600637306ULL, 0x000fe40000209400ULL, 0x000000682404723cULL, 0x000b680000041804ULL,
0x0000000193934812ULL, 0x000fe400078efcffULL, 0x0000005600647306ULL, 0x0004e20000205400ULL,
0x000000416c00720bULL, 0x002fce0003fbd000ULL, 0x00000057005c7306ULL, 0x000fe20000209400ULL,
0x0000005600567245ULL, 0x004fca000020d400ULL, 0x0000000119195812ULL, 0x000fe400078efcffULL,
0x00000057005d7306ULL, 0x000e620000205400ULL, 0x000000646300720bULL, 0x008fe40003f7d000ULL,
0x000000551919723eULL, 0x000fca00000010ffULL, 0x0000009000407306ULL, 0x000fec0000209400ULL,
0x0000000156563812ULL, 0x000fe400078efcffULL, 0x0000009000187306ULL, 0x0004e20000205400ULL,
0x0000005d5c00720bULL, 0x002fce0003f9d000ULL, 0x0000008f001a7306ULL, 0x000fe20000209400ULL,
0x0000009000907245ULL, 0x004fce000020d400ULL, 0x0000008f001b7306ULL, 0x000e620000205400ULL,
0x000000184000720bULL, 0x008fe40003fdd000ULL, 0x0000005700407245ULL, 0x000fe4000020d400ULL,
0x0000008f00577245ULL, 0x000fe4000020d400ULL, 0x0000000140404812ULL, 0x000fe400078efcffULL,
0x000000549318723eULL, 0x000fca00000010ffULL, 0x0000000190906812ULL, 0x000fe400078efcffULL,
0x0000001b1a00720bULL, 0x002fe40003fbd000ULL, 0x000000905656723eULL, 0x000fe200000010ffULL,
0x000000182418723cULL, 0x000b740000041848ULL, 0x0000000157575812ULL, 0x000fc800078efcffULL,
0x000000574057723eULL, 0x000fce00000010ffULL, 0x000000562424723cULL, 0x000b62000004181cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff407f8cULL, 0x000e62000c80043fULL,
0x000000ffff437224ULL, 0x000fce00078e00ffULL, 0x00000000001c7805ULL, 0x020fc40000015200ULL,
0x0106bc00ff1e7984ULL, 0x000ea40000000800ULL, 0x800000001eff7812ULL, 0x006fe40007804841ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104300780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000001e7805ULL, 0x000fcc0000015200ULL,
0x0000001e1c427210ULL, 0x000fca0007f1e1ffULL, 0x000000011f1f7824ULL, 0x000fe200000e0e1dULL,
0x003d09004200780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404200780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1e7819ULL, 0x000fc8000001141fULL, 0x000000421e1e7211ULL, 0x000fca00078110ffULL,
0x000000ffff1f7224ULL, 0x000fca00000e061fULL, 0x000000021e1e7819ULL, 0x000fc8000000121fULL,
0x0000001e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000143437810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106bc00ff1e7984ULL, 0x000e640000000800ULL, 0x800000001eff7812ULL, 0x002fe40007804841ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000058002c467a24ULL, 0x010fc800078e02ffULL,
0x0000004046467824ULL, 0x000fe200078e00ffULL, 0x0000045000009947ULL, 0x000fea0003800000ULL,
0x0000000238497810ULL, 0x040fe20007ffe0ffULL, 0x000000012b1c7824ULL, 0x040fe200078e0238ULL,
0x00000004384b7810ULL, 0x000fe20007ffe0ffULL, 0x0000004004057891ULL, 0x000fe2000f8e403fULL,
0x000000f030477812ULL, 0x000fe200078ec0ffULL, 0x000000012b1e7824ULL, 0x000fe400078e0249ULL,
0x000000011c1d7824ULL, 0x040fe400078e0202ULL, 0x000000101c487824ULL, 0x000fc400078e00ffULL,
0x0000004003457824ULL, 0x000fe400078e021cULL, 0x000000012b1c7824ULL, 0x000fe200078e024bULL,
0xfffffff048487812ULL, 0x000fe200078ee21dULL, 0x000000011e1f7824ULL, 0x140fe200078e0202ULL,
0x0000004645427210ULL, 0x040fe20007f1e0ffULL, 0x000000101e4a7824ULL, 0x000fe200078e00ffULL,
0x0000000245447810ULL, 0x040fe20007ffe0ffULL, 0x000000011c1e7824ULL, 0x040fe200078e0202ULL,
0x0000000445437810ULL, 0x000fe20007ffe0ffULL, 0x000000101c547824ULL, 0x000fe200078e00ffULL,
0x00000005281c7c17ULL, 0x000fe2000f800000ULL, 0x000000ffff1d7224ULL, 0x000fe200000e06ffULL,
0x00005e0042417a11ULL, 0x000fc400078040ffULL, 0x800000051c1c7c10ULL, 0x000fe4000fffe0ffULL,
0x00005f0042427a11ULL, 0x000fe400000f441dULL, 0x0000001c2b1c7217ULL, 0x000fe40007800000ULL,
0x0000004644447210ULL, 0x080fe40007f1e0ffULL, 0xfffffff04a4a7812ULL, 0x000fe200078ee21fULL,
0x000000011c1f7824ULL, 0x000fe200078e0a2bULL, 0x0000004643437210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff1c7224ULL, 0x000fe200000e06ffULL, 0x00005e0044407a11ULL, 0x000fc400078040ffULL,
0x0000001f3800720cULL, 0x000fe20003f86070ULL, 0x000000ffff1d7224ULL, 0x000fe200018e06ffULL,
0xfffffff054547812ULL, 0x000fe400078ee21eULL, 0x00005f0044447a11ULL, 0x000fe400000f441cULL,
0x00005e00431e7a11ULL, 0x000fe400078a40ffULL, 0x00000047411c7210ULL, 0x000fe40007f7e0ffULL,
0x00005f0043437a11ULL, 0x000fc400028f441dULL, 0x0000001f4900720cULL, 0x080fe20003f06070ULL,
0x000000ffff1d7224ULL, 0x000fe200018e0642ULL, 0x0000c00048487811ULL, 0x000fe400078e20ffULL,
0x0000000638497810ULL, 0x000fe40007ffe0ffULL, 0x0000000645417810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c487faeULL, 0x0003e2000e101c46ULL,
0x0000001f4b00720cULL, 0x000fe20003f66070ULL, 0x000000012b427824ULL, 0x000fe200078e0249ULL,
0x0000004641417210ULL, 0x000fc40007f9e0ffULL, 0x000000471e1e7210ULL, 0x080fe20007fde0ffULL,
0x0000000142457824ULL, 0x000fe200078e0202ULL, 0x0000c0004a4a7811ULL, 0x000fe400078e20ffULL,
0x0000c00054547811ULL, 0x000fe400078e20ffULL, 0x00000047401c7210ULL, 0x002fe20007fbe0ffULL,
0x0000001042487824ULL, 0x000fe400078e00ffULL, 0x000000ffff427224ULL, 0x000fe200020e06ffULL,
0x00005e0041407a11ULL, 0x000fe200078840ffULL, 0x000000ffff1d7224ULL, 0x000fe200028e0644ULL,
0x0000001f4900720cULL, 0x000fe20003fa6070ULL, 0x000000ffff1f7224ULL, 0x000fe200030e0643ULL,
0x00005f0041417a11ULL, 0x000fc400020f4442ULL, 0x0000004740407210ULL, 0x000fe20007f9e0ffULL,
0x000000001c4a7faeULL, 0x0003e2000c101c46ULL, 0xfffffff048457812ULL, 0x000fc600078ee245ULL,
0x000000ffff417224ULL, 0x000fe200020e0641ULL, 0x0000c00045457811ULL, 0x000fe200078e20ffULL,
0x000000001e547faeULL, 0x0003e8000d901c46ULL, 0x0000000040457faeULL, 0x0003e2000e901c46ULL,
0x0000038000007947ULL, 0x000fea0003800000ULL, 0x000000012b1e7824ULL, 0x000fc800078e0238ULL,
0x000000011e1f7824ULL, 0x040fe200078e0202ULL, 0x000000021e1c7810ULL, 0x040fe20007ffe0ffULL,
0x000000101e457824ULL, 0x000fe400078e00ffULL, 0x0000004003407824ULL, 0x000fe400078e021eULL,
0x000000011c1d7824ULL, 0x040fe200078e0202ULL, 0xfffffff045457812ULL, 0x000fe200078ee21fULL,
0x000000101c417824ULL, 0x000fe200078e00ffULL, 0x000000041e1c7810ULL, 0x040fe40007ffe0ffULL,
0x000000061e1e7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff0411f7812ULL, 0x000fe200078ee21dULL,
0x000000011c1d7824ULL, 0x100fe200078e0202ULL, 0x0000004640427210ULL, 0x000fe20007f1e0ffULL,
0x000000101c417824ULL, 0x000fe200078e00ffULL, 0x0000000440477810ULL, 0x000fe20007ffe0ffULL,
0x000000011e1c7824ULL, 0x040fe200078e0202ULL, 0x0000c00045457811ULL, 0x000fe200078e20ffULL,
0x000000101e447824ULL, 0x000fe200078e00ffULL, 0xfffffff041417812ULL, 0x000fe200078ee21dULL,
0x000000ffff1e7224ULL, 0x000fe200000e06ffULL, 0x00005e0042437a11ULL, 0x000fc400078040ffULL,
0xfffffff044447812ULL, 0x000fe400078ee21cULL, 0x00000002401c7810ULL, 0x000fe40007ffe0ffULL,
0x00005f00421e7a11ULL, 0x000fe400000f441eULL, 0x0000000640407810ULL, 0x000fe40007ffe0ffULL,
0x000000461c1d7210ULL, 0x080fe40007f1e0ffULL, 0x0000004647487210ULL, 0x000fc40007f7e0ffULL,
0x000000f030427812ULL, 0x000fe400078ec0ffULL, 0x00000046404b7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff407224ULL, 0x000fe200000e06ffULL, 0x00005e001d477a11ULL, 0x000fe200078040ffULL,
0x000000ffff497224ULL, 0x000fe200018e06ffULL, 0x00000042431c7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff547224ULL, 0x000fe200028e06ffULL, 0x00005e00484a7a11ULL, 0x000fe400078840ffULL,
0x00005f001d437a11ULL, 0x000fe200000f4440ULL, 0x000000ffff1d7224ULL, 0x000fe200018e061eULL,
0x00005e004b557a11ULL, 0x000fc400078a40ffULL, 0x00000042471e7210ULL, 0x080fe40007f1e0ffULL,
0x00005f0048497a11ULL, 0x000fe200020f4449ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c457faeULL, 0x0003e2000b901c46ULL, 0x000000424a407210ULL, 0x080fe40007f7e0ffULL,
0x00005f004b547a11ULL, 0x000fe400028f4454ULL, 0x0000004255427210ULL, 0x000fe40007f9e0ffULL,
0x0000c00044447811ULL, 0x000fc400078e20ffULL, 0x0000c0001f1c7811ULL, 0x002fe200078e20ffULL,
0x000000ffff1f7224ULL, 0x000fe200000e0643ULL, 0x0000c000411d7811ULL, 0x000fe200078e20ffULL,
0x000000ffff417224ULL, 0x000fe400018e0649ULL, 0x000000ffff437224ULL, 0x000fe200020e0654ULL,
0x000000001e1c7faeULL, 0x0003e8000b901c46ULL, 0x00000000401d7faeULL, 0x0003e8000b901c46ULL,
0x0000000042447faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff1c7f8cULL, 0x000e64000c80043fULL,
0x000000ffff457224ULL, 0x002fc400078e001dULL, 0x00000000001c7805ULL, 0x000fca0000015200ULL,
0x0106b400ff1e7984ULL, 0x000e640000000800ULL, 0x800000001eff7812ULL, 0x002fc4000780484fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff417224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104100780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001e7805ULL, 0x000fcc0000015200ULL, 0x0000001e1c407210ULL, 0x000fca0007f1e1ffULL,
0x000000011f1f7824ULL, 0x000fe200000e0e1dULL, 0x003d09004000780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404000780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1e7819ULL, 0x000fc8000001141fULL,
0x000000401e1e7211ULL, 0x000fca00078110ffULL, 0x000000ffff1f7224ULL, 0x000fca00000e061fULL,
0x000000021e1e7819ULL, 0x000fc8000000121fULL, 0x0000001e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000141417810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106b400ff1e7984ULL, 0x000e640000000800ULL,
0x800000001eff7812ULL, 0x002fe4000780484fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000014000007945ULL, 0x000fe20003800000ULL, 0x0000012000002947ULL, 0x000fea0003800000ULL,
0x00000035ff1c723eULL, 0x000fe400000010ffULL, 0x00000002ff1d7819ULL, 0x000fe40000011602ULL,
0x000054101c1c7816ULL, 0x000fe2000000001cULL, 0x0001b3527f007947ULL, 0x000fea000b800000ULL,
0x00001f1d1c367589ULL, 0x0002a400000e0000ULL, 0x000000081d377810ULL, 0x000fe20007ffe0ffULL,
0x0001b3827f007947ULL, 0x000fea000b800000ULL, 0x00001f371c377589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000101d497810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4a7224ULL, 0x000fe200078e001cULL, 0x0000569000487802ULL, 0x000fc40000000f00ULL,
0x0001c0f000007944ULL, 0x00efea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000181d497810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff4a7224ULL, 0x004fe200078e001cULL,
0x000056e000487802ULL, 0x000fc40000000f00ULL, 0x0001c0a000007944ULL, 0x00afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000013f517824ULL, 0x040fe200078e0251ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000103f407824ULL, 0x000fe200078e00ffULL,
0x0000e00053427811ULL, 0x000fe200078e20ffULL, 0x000000013f507824ULL, 0x040fe200078e0250ULL,
0x0000e00052417811ULL, 0x000fe200078e20ffULL, 0x000000103f3f7824ULL, 0x000fe200078e00ffULL,
0xfffffff040407812ULL, 0x000fe200078ee251ULL, 0x00000000421c783bULL, 0x00ae620000004200ULL,
0x0000000458437810ULL, 0x000fe20007ffe0ffULL, 0x0000004004057891ULL, 0x000fe2000f8e403fULL,
0x0000e00040407811ULL, 0x000fe200078e20ffULL, 0x000000004148783bULL, 0x004ea20000004200ULL,
0xfffffff03f3f7812ULL, 0x000fc400078ee250ULL, 0x0000000658447810ULL, 0x000fe20007ffe0ffULL,
0x000000004054783bULL, 0x000ee20000004200ULL, 0x0000e0003f3f7811ULL, 0x000fca00078e20ffULL,
0x000000003f50783bULL, 0x000f220000004200ULL, 0x0000001d00847306ULL, 0x002fe20000009400ULL,
0x00000018ff7e7819ULL, 0x000fe2000001141dULL, 0x000001001d997824ULL, 0x040fe200078e00ffULL,
0x00000018ff8e7819ULL, 0x000fe2000001141cULL, 0x000100001d9b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff647819ULL, 0x004fe20000011448ULL, 0x000100004b587824ULL, 0x000fe200078e00ffULL,
0x00000018ff5e7819ULL, 0x000fe20000011449ULL, 0x0000010054c77824ULL, 0x048fe200078e00ffULL,
0x0000005400e37306ULL, 0x000fe20000009400ULL, 0x0000010055ca7824ULL, 0x040fe200078e00ffULL,
0x00000018ffc37819ULL, 0x000fe20000011454ULL, 0x0001000054ce7824ULL, 0x000fe200078e00ffULL,
0x00000018ffc77819ULL, 0x000fe200000114c7ULL, 0x0001000055cc7824ULL, 0x000fe200078e00ffULL,
0x00000018ffca7819ULL, 0x000fe200000114caULL, 0x0000010056c97824ULL, 0x040fe200078e00ffULL,
0x0000005400e47306ULL, 0x000e620000005400ULL, 0x00000018ffb77819ULL, 0x000fe20000011456ULL,
0x0001000056cd7824ULL, 0x000fe200078e00ffULL, 0x00000018ffcc7819ULL, 0x000fe200000114ccULL,
0x0000010057c87824ULL, 0x040fe200078e00ffULL, 0x00000018ffc97819ULL, 0x000fe200000114c9ULL,
0x0001000057cb7824ULL, 0x000fe200078e00ffULL, 0x00000018ffb47819ULL, 0x000fe20000011457ULL,
0x0000005400937306ULL, 0x000ea2000000d400ULL, 0x00000018ffce7819ULL, 0x000fe200000114ceULL,
0x0000010053e97824ULL, 0x050fe200078e00ffULL, 0x00000018ffa17819ULL, 0x000fe20000011453ULL,
0x0001000053df7824ULL, 0x000fe200078e00ffULL, 0x00000018ffc87819ULL, 0x000fe200000114c8ULL,
0x0000010050c67824ULL, 0x040fe200078e00ffULL, 0x00000018ffbe7819ULL, 0x000fe20000011455ULL,
0x000000c700e57306ULL, 0x000fe20000209400ULL, 0x000000e4e300720bULL, 0x002fe20003f9d000ULL,
0x0001000050de7824ULL, 0x000fe200078e00ffULL, 0x00000018ffcb7819ULL, 0x000fe200000114cbULL,
0x0000010052e87824ULL, 0x040fe200078e00ffULL, 0x00000018ffc67819ULL, 0x000fe200000114c6ULL,
0x0001000052e27824ULL, 0x000fe200078e00ffULL, 0x00000018ffcd7819ULL, 0x000fe200000114cdULL,
0x000000c700547306ULL, 0x000e620000205400ULL, 0x00000018ffde7819ULL, 0x000fe200000114deULL,
0x000001001c917824ULL, 0x000fe200078e00ffULL, 0x00000018ffad7819ULL, 0x000fe20000011450ULL,
0x000001001e947824ULL, 0x000fe200078e00ffULL, 0x00000018ffa27819ULL, 0x000fe20000011452ULL,
0x000100001c977824ULL, 0x000fe200078e00ffULL, 0x0000000193934812ULL, 0x004fe200078efcffULL,
0x000000ca00d07306ULL, 0x000fe20000209400ULL, 0x00000018ff4e7819ULL, 0x000fe2000001144aULL,
0x000100001e757824ULL, 0x000fe200078e00ffULL, 0x00000018ff477819ULL, 0x000fe2000001144bULL,
0x000001001f7b7824ULL, 0x000fe200078e00ffULL, 0x00000018ffe27819ULL, 0x000fc400000114e2ULL,
0x00000018ffdf7819ULL, 0x000fe200000114dfULL, 0x000000ca00d87306ULL, 0x0004e20000205400ULL,
0x00000054e500720bULL, 0x002fe20003fdd000ULL, 0x000001004b547824ULL, 0x000fe200078e00ffULL,
0x00000018ffe87819ULL, 0x000fe400000114e8ULL, 0x00000018ffe97819ULL, 0x000fe400000114e9ULL,
0x00000018ff917819ULL, 0x000fe20000011491ULL, 0x0000005500c07306ULL, 0x000fe20000009400ULL,
0x000000ca00ca7245ULL, 0x004fc4000020d400ULL, 0x00000018ff947819ULL, 0x000fe40000011494ULL,
0x00000018ff727819ULL, 0x000fe4000001141eULL, 0x00000018ff7b7819ULL, 0x000fe2000001147bULL,
0x0000005500bf7306ULL, 0x000fe20000005400ULL, 0x000000d8d000720bULL, 0x008fe40003fbd000ULL,
0x00000018ff6f7819ULL, 0x000fe4000001141fULL, 0x00000018ff977819ULL, 0x000fc40000011497ULL,
0x00000018ff997819ULL, 0x000fe20000011499ULL, 0x000000cc00dc7306ULL, 0x000fe20000209400ULL,
0x00000018ff757819ULL, 0x000fe40000011475ULL, 0x00000018ff9b7819ULL, 0x000fe4000001149bULL,
0x00000018ff587819ULL, 0x000fe40000011458ULL, 0x00000001caca5812ULL, 0x000fe200078efcffULL,
0x000000cc00d77306ULL, 0x0002b00000205400ULL, 0x0000005600bc7306ULL, 0x000fe20000009400ULL,
0x000000cc00cc7245ULL, 0x002fce000020d400ULL, 0x0000005600ba7306ULL, 0x000fe20000005400ULL,
0x000000d7dc00720bULL, 0x004fce0003f9d000ULL, 0x00000056007a7306ULL, 0x0003ec000000d400ULL,
0x00000001cccc4812ULL, 0x000fe400078efcffULL, 0x000000c900d27306ULL, 0x000fe20000209400ULL,
0x0001000051567824ULL, 0x002fce00078e00ffULL, 0x000000c900d37306ULL, 0x0002b00000205400ULL,
0x0000001d00857306ULL, 0x000fe20000005400ULL, 0x000000c900c97245ULL, 0x002fce000020d400ULL,
0x0000001d00657306ULL, 0x0003e2000000d400ULL, 0x000000d3d200720bULL, 0x004fce0003fbd000ULL,
0x0000005700b67306ULL, 0x000fe20000009400ULL, 0x00000018ff1d7819ULL, 0x002fca0000011451ULL,
0x00000001c9c95812ULL, 0x000fe400078efcffULL, 0x0000005700b57306ULL, 0x000e700000005400ULL,
0x0000005700767306ULL, 0x0004f0000000d400ULL, 0x0000005100a87306ULL, 0x000fe20000009400ULL,
0x0000010051577824ULL, 0x004fe200078e00ffULL, 0x000000b5b600720bULL, 0x002fc80003f9d000ULL,
0x00000018ff577819ULL, 0x000fe40000011457ULL, 0x0000005100a97306ULL, 0x000fee0000005400ULL,
0x0000000176764812ULL, 0x008fe200078efcffULL, 0x0000005100737306ULL, 0x0003f0000000d400ULL,
0x0000005300a47306ULL, 0x000fe20000009400ULL, 0x0000010048517824ULL, 0x002fce00078e00ffULL,
0x0000005300a37306ULL, 0x000ff00000005400ULL, 0x0000005300697306ULL, 0x0003f0000000d400ULL,
0x0000004800807306ULL, 0x000fe20000009400ULL, 0x0001000048537824ULL, 0x002fce00078e00ffULL,
0x0000004800837306ULL, 0x000ff00000005400ULL, 0x00000048005c7306ULL, 0x0003f0000000d400ULL,
0x000000ce00e67306ULL, 0x000fe20000209400ULL, 0x00000018ff487819ULL, 0x002fc40000011456ULL,
0x000000c700567245ULL, 0x000fc8000020d400ULL, 0x0000000156566812ULL, 0x000fe200078efcffULL,
0x000000ce00e77306ULL, 0x0002a20000205400ULL, 0x000000bfc000720bULL, 0x000fce0003fdd000ULL,
0x0000005500907306ULL, 0x000722000000d400ULL, 0x000000ce00ce7245ULL, 0x002fce000020d400ULL,
0x000000c800d17306ULL, 0x000fe20000209400ULL, 0x000000e7e600720bULL, 0x004fe20003f7d000ULL,
0x0000000859557824ULL, 0x048fe400078e00ffULL, 0x0000000859597824ULL, 0x000fc600078e00ffULL,
0xfffffff855437812ULL, 0x000fe200078ee243ULL, 0x000000c800d47306ULL, 0x0002a20000205400ULL,
0x0000000190906812ULL, 0x010fe200078efcffULL, 0x000001004a557824ULL, 0x040fe200078e00ffULL,
0xfffffff859447812ULL, 0x000fe200078ee244ULL, 0x000100004a597824ULL, 0x000fe400078e00ffULL,
0x00000001cece3812ULL, 0x000fe400078efcffULL, 0x000000b700bb7306ULL, 0x000fe20000209400ULL,
0x000000c800c87245ULL, 0x002fc4000020d400ULL, 0x00000018ff597819ULL, 0x000fca0000011459ULL,
0x000000b700bd7306ULL, 0x0002e20000205400ULL, 0x000000d4d100720bULL, 0x004fce0003fdd000ULL,
0x000000be00c17306ULL, 0x000fe20000209400ULL, 0x000000b700b77245ULL, 0x002fca000020d400ULL,
0x00000001c8c86812ULL, 0x000fe400078efcffULL, 0x000000be00c27306ULL, 0x0002a20000205400ULL,
0x000000bdbb00720bULL, 0x008fce0003fbd000ULL, 0x000000cb00da7306ULL, 0x000fe20000209400ULL,
0x000000be00be7245ULL, 0x002fca000020d400ULL, 0x00000001b7b75812ULL, 0x000fe400078efcffULL,
0x000000cb00db7306ULL, 0x0002e20000205400ULL, 0x000000c2c100720bULL, 0x004fce0003f7d000ULL,
0x000000c600d97306ULL, 0x000fe20000209400ULL, 0x000000cb00cb7245ULL, 0x002fca000020d400ULL,
0x00000001bebe3812ULL, 0x000fe400078efcffULL, 0x000000c600d67306ULL, 0x0002a20000205400ULL,
0x000000dbda00720bULL, 0x008fce0003fdd000ULL, 0x0000005700dd7306ULL, 0x000fe20000209400ULL,
0x000000c600c67245ULL, 0x002fca000020d400ULL, 0x00000001cbcb6812ULL, 0x000fe400078efcffULL,
0x0000005700e07306ULL, 0x000e620000205400ULL, 0x000000d6d900720bULL, 0x004fe40003f9d000ULL,
0x000000a9a800720bULL, 0x000fe40003fdd000ULL, 0x0000005700a87245ULL, 0x000fe4000020d400ULL,
0x0000001d00a97245ULL, 0x000fe2000020d400ULL, 0x000000c300c47306ULL, 0x000fec0000209400ULL,
0x00000001c6c64812ULL, 0x000fc400078efcffULL, 0x000000c300c57306ULL, 0x0004e20000205400ULL,
0x000000e0dd00720bULL, 0x002fe40003fbd000ULL, 0x0000000173736812ULL, 0x000fca00078efcffULL,
0x000000cd00cf7306ULL, 0x000fe20000209400ULL, 0x000000c300c37245ULL, 0x004fca000020d400ULL,
0x00000001a8a85812ULL, 0x000fe400078efcffULL, 0x000000cd00d57306ULL, 0x0002a20000205400ULL,
0x000000c5c400720bULL, 0x008fe40003f1d000ULL, 0x00000073a8c7723eULL, 0x000fca00000010ffULL,
0x0000005000b07306ULL, 0x000fe20000009400ULL, 0x000000cd00cd7245ULL, 0x002fca000020d400ULL,
0x00000001c3c30812ULL, 0x000fe400078efcffULL, 0x0000005000b17306ULL, 0x000e620000005400ULL,
0x000000d5cf00720bULL, 0x004fe40003f7d000ULL, 0x000000babc00720bULL, 0x000fca0003f1d000ULL,
0x0000005000747306ULL, 0x0004ec000000d400ULL, 0x00000001cdcd3812ULL, 0x000fe400078efcffULL,
0x0000005200a67306ULL, 0x000fe20000009400ULL, 0x0001000049507824ULL, 0x004fe200078e00ffULL,
0x000000b1b000720bULL, 0x002fc40003f7d000ULL, 0x000000017a7a0812ULL, 0x000fc800078efcffULL,
0x0000005200a77306ULL, 0x000fee0000005400ULL, 0x0000000174743812ULL, 0x008fe200078efcffULL,
0x00000052006e7306ULL, 0x0003e6000000d400ULL, 0x00000074c6c6723eULL, 0x000fc400000010ffULL,
0x00000018ff747819ULL, 0x000fc60000011455ULL, 0x00000049008c7306ULL, 0x000fe20000009400ULL,
0x0000010049527824ULL, 0x002fce00078e00ffULL, 0x0000004900877306ULL, 0x000ff00000005400ULL,
0x00000049005b7306ULL, 0x000ff0000000d400ULL, 0x000000de00e17306ULL, 0x000ff00000209400ULL,
0x000000de00497306ULL, 0x0002b00000205400ULL, 0x0000004a007d7306ULL, 0x000fe20000009400ULL,
0x000000de00de7245ULL, 0x002fce000020d400ULL, 0x0000004a007c7306ULL, 0x000fe20000005400ULL,
0x00000049e100720bULL, 0x004fce0003f9d000ULL, 0x0000004a005a7306ULL, 0x000fec000000d400ULL,
0x00000001dede4812ULL, 0x000fe400078efcffULL, 0x0000004b006d7306ULL, 0x000fe20000009400ULL,
0x000000a7a600720bULL, 0x000fe40003f9d000ULL, 0x0000004800a67245ULL, 0x000fc4000020d400ULL,
0x000000e800a77245ULL, 0x000fc6000020d400ULL, 0x0000004b006c7306ULL, 0x000fec0000005400ULL,
0x000000016e6e4812ULL, 0x000fe400078efcffULL, 0x0000004b004f7306ULL, 0x000ff0000000d400ULL,
0x00000048004a7306ULL, 0x000ff00000209400ULL, 0x00000048004b7306ULL, 0x0002b00000205400ULL,
0x000000b400b87306ULL, 0x000fe20000209400ULL, 0x0000a00043487811ULL, 0x002fce00078e20ffULL,
0x000000b400b97306ULL, 0x0002e20000205400ULL, 0x0000004b4a00720bULL, 0x004fce0003fbd000ULL,
0x000000e200b07306ULL, 0x000fe20000209400ULL, 0x000000b400b47245ULL, 0x002fca000020d400ULL,
0x00000001a6a65812ULL, 0x000fe400078efcffULL, 0x000000e200497306ULL, 0x000e620000205400ULL,
0x000000a3a400720bULL, 0x000fe40003fbd000ULL, 0x000000b9b800720bULL, 0x008fe40003f1d000ULL,
0x000000e200a47245ULL, 0x000fe4000020d400ULL, 0x000000e900a37245ULL, 0x000fe2000020d400ULL,
0x0000001d00af7306ULL, 0x000fec0000209400ULL, 0x0000000169695812ULL, 0x000fc400078efcffULL,
0x0000001d00ae7306ULL, 0x000ea20000205400ULL, 0x00000049b000720bULL, 0x002fe40003f9d000ULL,
0x00000001b4b40812ULL, 0x000fe200078efcffULL, 0x000000004848783bULL, 0x000e660000000200ULL,
0x000000cbb4cb723eULL, 0x000fe200000010ffULL, 0x000000df00577306ULL, 0x000fec0000209400ULL,
0x00000001a4a44812ULL, 0x000fc400078efcffULL, 0x000000df001d7306ULL, 0x000ee20000205400ULL,
0x000000aeaf00720bULL, 0x004fce0003f7d000ULL, 0x000000ad00b27306ULL, 0x000fec0000209400ULL,
0x00000001a9a93812ULL, 0x000fe400078efcffULL, 0x000000ad00b37306ULL, 0x0005220000205400ULL,
0x0000001d5700720bULL, 0x008fe40003fbd000ULL, 0x000000ccbe57723eULL, 0x000fc400000010ffULL,
0x000000a6a9a9723eULL, 0x000fc600000010ffULL, 0x0000001c007f7306ULL, 0x000fe20000009400ULL,
0x000000ad00ad7245ULL, 0x004fe2000020d400ULL, 0x000000364848a231ULL, 0x082fe400003400ffULL,
0x000000364a4aa231ULL, 0x000fc800003400ffULL, 0x0000001c00867306ULL, 0x000e620000005400ULL,
0x000000b3b200720bULL, 0x010fe20003f1d000ULL, 0x000000374949a231ULL, 0x080fe400003400ffULL,
0x000000374b4ba231ULL, 0x000fc800003400ffULL, 0x000000e800ba7306ULL, 0x000fe60000209400ULL,
0x000000c64808723cULL, 0x000fe60000041808ULL, 0x00000001adad0812ULL, 0x000fe400078efcffULL,
0x000000e800b57306ULL, 0x000ea20000205400ULL, 0x000000867f00720bULL, 0x002fe40003f9d000ULL,
0x000000df007f7245ULL, 0x000fc4000020d400ULL, 0x00000018ff867819ULL, 0x000fe40000011451ULL,
0x000000017f7f5812ULL, 0x000fe200078efcffULL, 0x000000e900b67306ULL, 0x000fe20000209400ULL,
0x000000858400720bULL, 0x000fe40003fbd000ULL, 0x00000018ff857819ULL, 0x000fe40000011452ULL,
0x000000935652723eULL, 0x000fe400000010ffULL, 0x000000cec356723eULL, 0x000fe200000010ffULL,
0x000000e900b87306ULL, 0x000e620000205400ULL, 0x000000b5ba00720bULL, 0x004fc40003fdd000ULL,
0x00000076c851723eULL, 0x000fe400000010ffULL, 0x000000deada8723eULL, 0x000fe200000010ffULL,
0x000000564810723cULL, 0x040fe20000041810ULL, 0x0000000165655812ULL, 0x000fe200078efcffULL,
0x0000001c00667306ULL, 0x000eac000000d400ULL, 0x00000001a7a76812ULL, 0x000fe200078efcffULL,
0x000000a84804723cULL, 0x000fe20000041804ULL, 0x0000009100a57306ULL, 0x000fe20000209400ULL,
0x000000b8b600720bULL, 0x002fce0003f1d000ULL, 0x00000091001c7306ULL, 0x0002e20000205400ULL,
0x0000000166664812ULL, 0x004fca00078efcffULL, 0x00000001a3a30812ULL, 0x000fe400078efcffULL,
0x0000001e008f7306ULL, 0x000fe20000009400ULL, 0x0000009100917245ULL, 0x002fe4000020d400ULL,
0x00000069a355723eULL, 0x000fca00000010ffULL, 0x0000001e00887306ULL, 0x000e620000005400ULL,
0x0000001ca500720bULL, 0x008fe40003f7d000ULL, 0x0000a000441c7811ULL, 0x000fca00078e20ffULL,
0x0000001e00637306ULL, 0x000eac000000d400ULL, 0x0000000191913812ULL, 0x000fe400078efcffULL,
0x00000094009c7306ULL, 0x000fe20000209400ULL, 0x000000888f00720bULL, 0x002fce0003f9d000ULL,
0x00000094009d7306ULL, 0x0002ec0000205400ULL, 0x0000000163634812ULL, 0x004fe400078efcffULL,
0x000000a200ab7306ULL, 0x000fe20000209400ULL, 0x0000009400947245ULL, 0x002fce000020d400ULL,
0x000000a200ac7306ULL, 0x0002a20000205400ULL, 0x0000009d9c00720bULL, 0x008fce0003fbd000ULL,
0x000000a100aa7306ULL, 0x000fe20000209400ULL, 0x000000a200a27245ULL, 0x002fca000020d400ULL,
0x0000000194945812ULL, 0x000fe400078efcffULL, 0x000000a1001e7306ULL, 0x0002e20000205400ULL,
0x000000acab00720bULL, 0x004fe40003fdd000ULL, 0x000000639494723eULL, 0x000fca00000010ffULL,
0x0000001f008d7306ULL, 0x000fe20000009400ULL, 0x000000a100a17245ULL, 0x002fca000020d400ULL,
0x00000001a2a26812ULL, 0x000fe400078efcffULL, 0x0000001f00817306ULL, 0x000fe20000005400ULL,
0x0000001eaa00720bULL, 0x008fce0003f1d000ULL, 0x0000001f00627306ULL, 0x0003ec000000d400ULL,
0x00000001a1a10812ULL, 0x000fe400078efcffULL, 0x0000007b00927306ULL, 0x000fe20000209400ULL,
0x000100001f1f7824ULL, 0x002fe200078e00ffULL, 0x0000007fa17f723eULL, 0x000fc800000010ffULL,
0x00000018ffab7819ULL, 0x000fe4000001141fULL, 0x0000007b00987306ULL, 0x000e620000205400ULL,
0x000000001c1c783bULL, 0x000ea20000000200ULL, 0x000000ab00737245ULL, 0x000fcc000020d400ULL,
0x0000009700967306ULL, 0x000ff00000209400ULL, 0x0000009700957306ULL, 0x0007220000205400ULL,
0x000000989200720bULL, 0x002fce0003fbd000ULL, 0x0000008e008b7306ULL, 0x000fe20000209400ULL,
0x0000009700977245ULL, 0x008fce000020d400ULL, 0x0000008e00897306ULL, 0x0002e20000205400ULL,
0x000000959600720bULL, 0x010fe40003fdd000ULL, 0x0000007b00957245ULL, 0x000fc8000020d400ULL,
0x0000000195955812ULL, 0x000fe200078efcffULL, 0x0000007200777306ULL, 0x000fe20000209400ULL,
0x0000008e008e7245ULL, 0x002fe2000020d400ULL, 0x000000361c1ca231ULL, 0x084fe400003400ffULL,
0x000000361e1ea231ULL, 0x000fe400003400ffULL, 0x0000000197976812ULL, 0x000fe200078efcffULL,
0x000000371d1da231ULL, 0x080fe200003400ffULL, 0x0000007200787306ULL, 0x0002a20000205400ULL,
0x000000898b00720bULL, 0x008fe20003f1d000ULL, 0x000000371f1fa231ULL, 0x000fe200003400ffULL,
0x000000818d00720bULL, 0x000fc40003fdd000ULL, 0x00000018ff817819ULL, 0x000fe40000011453ULL,
0x00000090ca53723eULL, 0x000fe200000010ffULL, 0x00000099009a7306ULL, 0x000fe20000209400ULL,
0x0000007200727245ULL, 0x002fe4000020d400ULL, 0x000000838000720bULL, 0x000fe40003f5d000ULL,
0x0000007e00807245ULL, 0x000fe2000020d400ULL, 0x000000524820723cULL, 0x000f620000041820ULL,
0x000000018e8e0812ULL, 0x000fe200078efcffULL, 0x0000009900a07306ULL, 0x0002e20000205400ULL,
0x000000787700720bULL, 0x004fc40003f9d000ULL, 0x0000000162626812ULL, 0x000fe400078efcffULL,
0x000000cdb7ca723eULL, 0x000fe400000010ffULL, 0x000000629595723eULL, 0x000fe200000010ffULL,
0x0000007500797306ULL, 0x000fe20000209400ULL, 0x0000009900997245ULL, 0x002fe4000020d400ULL,
0x000000015c5c2812ULL, 0x000fe200078efcffULL, 0x000000ca480c723cULL, 0x000fe4000004180cULL,
0x0000000172724812ULL, 0x000fc400078efcffULL, 0x0000007500a57306ULL, 0x0002a20000205400ULL,
0x000000a09a00720bULL, 0x008fce0003f7d000ULL, 0x0000007e00827306ULL, 0x000fe20000209400ULL,
0x0000007500757245ULL, 0x002fca000020d400ULL, 0x0000000199993812ULL, 0x000fe400078efcffULL,
0x0000007e008a7306ULL, 0x0002e20000205400ULL, 0x000000a57900720bULL, 0x004fce0003fbd000ULL,
0x0000006f00717306ULL, 0x000fe20000209400ULL, 0x000000a4a27e723eULL, 0x002fca00000010ffULL,
0x0000000175755812ULL, 0x000fe400078efcffULL, 0x0000006f00707306ULL, 0x0002a20000205400ULL,
0x0000008a8200720bULL, 0x008fe20003f1d000ULL, 0x0000007e4824723cULL, 0x000fe20000041824ULL,
0x000000757272723eULL, 0x000fca00000010ffULL, 0x0000009b009e7306ULL, 0x000fe20000209400ULL,
0x0000006f006f7245ULL, 0x002fca000020d400ULL, 0x0000000180800812ULL, 0x000fe400078efcffULL,
0x0000009b009f7306ULL, 0x0002e20000205400ULL, 0x000000707100720bULL, 0x004fe40003fbd000ULL,
0x0000007c7d00720bULL, 0x000fe40003f1d000ULL, 0x00000018ff7d7819ULL, 0x000fe40000011450ULL,
0x00000018ff717819ULL, 0x000fe20000011454ULL, 0x0000008600967306ULL, 0x000fe20000209400ULL,
0x0000009b009b7245ULL, 0x002fc4000020d400ULL, 0x0000006ea754723eULL, 0x000fe400000010ffULL,
0x0000007ac950723eULL, 0x000fe400000010ffULL, 0x000000016f6f5812ULL, 0x000fe200078efcffULL,
0x0000008600847306ULL, 0x0002a20000205400ULL, 0x0000009f9e00720bULL, 0x008fe20003f7d000ULL,
0x000000544854723cULL, 0x000be20000041818ULL, 0x000000015a5a0812ULL, 0x000fca00078efcffULL,
0x000000ab00aa7306ULL, 0x000fe20000209400ULL, 0x0000008600867245ULL, 0x002fe2000020d400ULL,
0x000000504850723cULL, 0x000b640000041814ULL, 0x000000669118723eULL, 0x020fe400000010ffULL,
0x000000659919723eULL, 0x000fe400000010ffULL, 0x000000019b9b3812ULL, 0x000fe200078efcffULL,
0x000000ab00ac7306ULL, 0x000e620000205400ULL, 0x000000849600720bULL, 0x004fc40003f9d000ULL,
0x000000878c00720bULL, 0x000fe20003f7d000ULL, 0x000000181c18723cULL, 0x000b620000041820ULL,
0x0000007d00657245ULL, 0x000fe4000020d400ULL, 0x000000978e14723eULL, 0x000fe200000010ffULL,
0x00000064006a7306ULL, 0x000fe20000209400ULL, 0x0000009b8015723eULL, 0x000fca00000010ffULL,
0x0000000186864812ULL, 0x000fe400078efcffULL, 0x00000064006b7306ULL, 0x0004e20000205400ULL,
0x000000acaa00720bULL, 0x002fe20003fdd000ULL, 0x000000141c14723cULL, 0x000b620000041810ULL,
0x000000015b5b3812ULL, 0x000fe400078efcffULL, 0x0000005c865c723eULL, 0x000fc600000010ffULL,
0x0000008500887306ULL, 0x000fe20000209400ULL, 0x0000006400647245ULL, 0x004fe2000020d400ULL,
0x000000941c10723cULL, 0x000b680000041850ULL, 0x0000000173736812ULL, 0x000fe400078efcffULL,
0x0000008500897306ULL, 0x0002a20000205400ULL, 0x0000006b6a00720bULL, 0x008fe40003fbd000ULL,
0x0000006c6d00720bULL, 0x000fc40003fdd000ULL, 0x000000736f73723eULL, 0x000fc600000010ffULL,
0x0000005e00687306ULL, 0x000fe20000209400ULL, 0x0000008500857245ULL, 0x002fc6000020d400ULL,
0x000000721c0c723cULL, 0x000b64000004180cULL, 0x0000000164645812ULL, 0x000fe400078efcffULL,
0x0000005e00677306ULL, 0x0002e20000205400ULL, 0x000000898800720bULL, 0x004fe40003f9d000ULL,
0x000000014f4f6812ULL, 0x000fca00078efcffULL, 0x0000008100827306ULL, 0x000fe20000209400ULL,
0x0000005e005e7245ULL, 0x002fca000020d400ULL, 0x0000000185854812ULL, 0x000fe400078efcffULL,
0x00000081007c7306ULL, 0x0002a20000205400ULL, 0x000000676800720bULL, 0x008fce0003f5d000ULL,
0x0000007d00777306ULL, 0x000fe20000209400ULL, 0x0000008100817245ULL, 0x002fca000020d400ULL,
0x000000015e5e2812ULL, 0x000fe400078efcffULL, 0x0000007d00767306ULL, 0x000e620000205400ULL,
0x0000007c8200720bULL, 0x004fce0003f9d000ULL, 0x0000007400787306ULL, 0x000fec0000209400ULL,
0x0000000181814812ULL, 0x000fe400078efcffULL, 0x0000007400707306ULL, 0x0004e20000205400ULL,
0x000000767700720bULL, 0x002fe40003f7d000ULL, 0x000000816464723eULL, 0x000fca00000010ffULL,
0x00000071006c7306ULL, 0x000fe20000209400ULL, 0x0000007400747245ULL, 0x004fca000020d400ULL,
0x0000000165653812ULL, 0x000fe400078efcffULL, 0x0000007100697306ULL, 0x000e620000205400ULL,
0x000000707800720bULL, 0x008fe40003fbd000ULL, 0x000000655e65723eULL, 0x000fca00000010ffULL,
0x0000005800207306ULL, 0x020fe40000209400ULL, 0x000000641c04723cULL, 0x000b680000041804ULL,
0x0000000174745812ULL, 0x000fe400078efcffULL, 0x0000005800217306ULL, 0x000ea20000205400ULL,
0x000000696c00720bULL, 0x002fce0003f5d000ULL, 0x0000004e00607306ULL, 0x000ff00000209400ULL,
0x0000004e00617306ULL, 0x0002e20000205400ULL, 0x000000212000720bULL, 0x004fe40003f1d000ULL,
0x0000007100217245ULL, 0x000fc4000020d400ULL, 0x0000005a7420723eULL, 0x000fe400000010ffULL,
0x0000000121212812ULL, 0x000fe200078efcffULL, 0x00000047005d7306ULL, 0x000fe20000209400ULL,
0x0000004e004e7245ULL, 0x002fe4000020d400ULL, 0x0000004f2121723eULL, 0x000fe400000010ffULL,
0x00000058004f7245ULL, 0x000fc6000020d400ULL, 0x00000047005f7306ULL, 0x0002a20000205400ULL,
0x000000616000720bULL, 0x008fe20003f9d000ULL, 0x000000201c20723cULL, 0x000b620000041854ULL,
0x000000014f4f0812ULL, 0x000fca00078efcffULL, 0x0000005900677306ULL, 0x000fe20000209400ULL,
0x0000004700477245ULL, 0x002fca000020d400ULL, 0x000000014e4e4812ULL, 0x000fe400078efcffULL,
0x0000005900487306ULL, 0x0002e20000205400ULL, 0x0000005f5d00720bULL, 0x004fe40003f7d000ULL,
0x0000005b855d723eULL, 0x000fe400000010ffULL, 0x0000005900597245ULL, 0x002fca000020d400ULL,
0x0000005c1c08723cULL, 0x000b680000041808ULL, 0x0000000147473812ULL, 0x000fe400078efcffULL,
0x000000486700720bULL, 0x008fe40003fbd000ULL, 0x0000004f474f723eULL, 0x000fd600000010ffULL,
0x0000000159595812ULL, 0x000fc800078efcffULL, 0x000000594e4e723eULL, 0x000fce00000010ffULL,
0x0000004e1c1c723cULL, 0x000b620000041824ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff247f8cULL, 0x020e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000528007c0cULL, 0x000fe2000bf03070ULL,
0x01068800ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff487224ULL, 0x002fe200078e0025ULL,
0x000000014d4d7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff247224ULL, 0x000fd200078e004cULL,
0x0001218000000947ULL, 0x000fea0003800000ULL, 0x0000000000247805ULL, 0x000fc40000015200ULL,
0x0106bc00ff267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fe40007804848ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff477224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104700780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x00000026242c7210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002c00780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402c00780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff267819ULL, 0x000fc80000011427ULL,
0x0000002c26267211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x0000000226267819ULL, 0x000fc80000001227ULL, 0x000000260000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000147477810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106bc00ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe40007804848ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000046000009947ULL, 0x000fea0003800000ULL, 0x000000012b247824ULL, 0x040fe200078e0238ULL,
0x0000000238477810ULL, 0x040fe20007ffe0ffULL, 0x0000006004057891ULL, 0x000fe2000f8e403fULL,
0x0000000438507810ULL, 0x000fe20007ffe0ffULL, 0x0000000124257824ULL, 0x000fe200078e0202ULL,
0x0000000638527810ULL, 0x000fe20007ffe0ffULL, 0x00000010244e7824ULL, 0x000fe200078e00ffULL,
0x000000f0304d7812ULL, 0x000fe200078ec0ffULL, 0x000000012b267824ULL, 0x000fc400078e0247ULL,
0x000000012b2c7824ULL, 0x000fe200078e0250ULL, 0xfffffff04e4e7812ULL, 0x000fe200078ee225ULL,
0x0000000126277824ULL, 0x140fe200078e0202ULL, 0x0000002003257811ULL, 0x000fe200078e30ffULL,
0x00000010264f7824ULL, 0x000fe200078e00ffULL, 0x0000e0004e4e7811ULL, 0x000fe200078e20ffULL,
0x000000102c517824ULL, 0x000fe400078e00ffULL, 0x00000001244b7824ULL, 0x000fe200078e0225ULL,
0xfffffff04f4f7812ULL, 0x000fe200078ee227ULL, 0x000000012c277824ULL, 0x000fe200078e0202ULL,
0x0000000528247c17ULL, 0x000fe2000f800000ULL, 0x00000001264a7824ULL, 0x100fe200078e0225ULL,
0x000000464b4b7210ULL, 0x000fe20007f1e0ffULL, 0x000000012c487824ULL, 0x000fe200078e0225ULL,
0x8000000524247c10ULL, 0x000fc4000fffe0ffULL, 0xfffffff051517812ULL, 0x000fe200078ee227ULL,
0x000000012b277824ULL, 0x040fe200078e0252ULL, 0x000000242b247217ULL, 0x000fe40007800000ULL,
0x000000464a4a7210ULL, 0x080fe20007f9e0ffULL, 0x00000001272c7824ULL, 0x040fe200078e0225ULL,
0x0000004648487210ULL, 0x080fe20007f7e0ffULL, 0x0000000127497824ULL, 0x000fe200078e0202ULL,
0x0000e0004f4f7811ULL, 0x000fe200078e20ffULL, 0x0000001027537824ULL, 0x000fe200078e00ffULL,
0x000000462c2c7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff257224ULL, 0x000fe200000e06ffULL,
0x00005e004b277a11ULL, 0x000fe200078040ffULL, 0x0000000124267824ULL, 0x000fe200078e0a2bULL,
0xfffffff053537812ULL, 0x000fe200078ee249ULL, 0x000000ffff247224ULL, 0x000fe200020e06ffULL,
0x00005f004b4b7a11ULL, 0x000fe200000f4425ULL, 0x000000ffff257224ULL, 0x000fe200018e06ffULL,
0x00005e004a497a11ULL, 0x000fc400078c40ffULL, 0x000000264700720cULL, 0x080fe40003f06070ULL,
0x00005e0048477a11ULL, 0x000fe400078a40ffULL, 0x000000263800720cULL, 0x000fe40003f86070ULL,
0x00005f004a4a7a11ULL, 0x000fe400030f4424ULL, 0x0000004d27247210ULL, 0x000fe20007fde0ffULL,
0x000000ffff277224ULL, 0x000fe200010e06ffULL, 0x00005f0048487a11ULL, 0x000fc400028f4425ULL,
0x00005e002c467a11ULL, 0x000fe200078a40ffULL, 0x000000ffff257224ULL, 0x000fe200030e064bULL,
0x000000265000720cULL, 0x080fe40003f66070ULL, 0x000000265200720cULL, 0x000fe40003f46070ULL,
0x00005f002c2c7a11ULL, 0x000fe200028f4427ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000244e7faeULL, 0x0003e2000e101c46ULL, 0x0000004d49267210ULL, 0x000fe40007fbe0ffULL,
0x0000e00051517811ULL, 0x000fc400078e20ffULL, 0x0000e00053537811ULL, 0x000fe200078e20ffULL,
0x000000ffff277224ULL, 0x000fe200028e064aULL, 0x0000004d46467210ULL, 0x000fc80007fbe0ffULL,
0x00000000264f7faeULL, 0x0005e2000c101c46ULL, 0x0000004d47247210ULL, 0x002fe20007f9e0ffULL,
0x000000ffff477224ULL, 0x000fc800028e062cULL, 0x000000ffff257224ULL, 0x000fca00020e0648ULL,
0x0000000024517faeULL, 0x0005e8000d901c46ULL, 0x0000000046537faeULL, 0x0005e2000d101c46ULL,
0x0000039000007947ULL, 0x000fea0003800000ULL, 0x000000012b247824ULL, 0x000fe200078e0238ULL,
0x0000002003267811ULL, 0x000fe400078e30ffULL, 0x000000f0304d7812ULL, 0x000fe200078ec0ffULL,
0x0000000124257824ULL, 0x040fe200078e0202ULL, 0x00000002242c7810ULL, 0x040fe20007ffe0ffULL,
0x00000010244e7824ULL, 0x040fe200078e00ffULL, 0x0000000424477810ULL, 0x000fc40007ffe0ffULL,
0x0000000624487810ULL, 0x000fe20007ffe0ffULL, 0x000000012c277824ULL, 0x000fe200078e0202ULL,
0xfffffff04e4e7812ULL, 0x000fe200078ee225ULL, 0x000000102c4f7824ULL, 0x000fe400078e00ffULL,
0x0000000124257824ULL, 0x000fe200078e0226ULL, 0x0000e0004e4e7811ULL, 0x000fe200078e20ffULL,
0x0000000126247824ULL, 0x040fe200078e022cULL, 0xfffffff04f4f7812ULL, 0x000fe200078ee227ULL,
0x00000001472c7824ULL, 0x000fe200078e0202ULL, 0x0000004625277210ULL, 0x000fe20007f7e0ffULL,
0x0000000126257824ULL, 0x000fe200078e0247ULL, 0x00000024464b7210ULL, 0x000fe20007f1e0ffULL,
0x0000000126267824ULL, 0x000fc400078e0248ULL, 0x0000001047507824ULL, 0x000fe200078e00ffULL,
0x0000002546257210ULL, 0x000fe20007f5e0ffULL, 0x0000000148477824ULL, 0x040fe400078e0202ULL,
0x0000001048517824ULL, 0x000fe200078e00ffULL, 0x00005e0027487a11ULL, 0x000fe200078840ffULL,
0x000000ffff247224ULL, 0x000fe200018e06ffULL, 0x0000002646267210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff4a7224ULL, 0x000fe200010e06ffULL, 0xfffffff050507812ULL, 0x000fe200078ee22cULL,
0x000000ffff2c7224ULL, 0x000fe200000e06ffULL, 0xfffffff051517812ULL, 0x000fe200078ee247ULL,
0x000000ffff477224ULL, 0x000fe200018e06ffULL, 0x00005f0027497a11ULL, 0x000fc400020f4424ULL,
0x00005e004b247a11ULL, 0x000fe400078040ffULL, 0x0000004d48487210ULL, 0x000fe40007f9e0ffULL,
0x00005e0025277a11ULL, 0x000fe400078440ffULL, 0x00005e0026467a11ULL, 0x000fe200078640ffULL,
0x000000ffff497224ULL, 0x000fe200020e0649ULL, 0x00005f004b4b7a11ULL, 0x000fe400000f442cULL,
0x00005f00254a7a11ULL, 0x000fc400010f444aULL, 0x00005f0026477a11ULL, 0x000fe200018f4447ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000484e7faeULL, 0x0003e2000b901c46ULL,
0x0000004d24247210ULL, 0x080fe40007f1e0ffULL, 0x0000004d27267210ULL, 0x080fe40007f5e0ffULL,
0x0000004d46467210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff257224ULL, 0x000fe200000e064bULL,
0x0000e0004f2c7811ULL, 0x000fe200078e20ffULL, 0x000000ffff277224ULL, 0x000fe400010e064aULL,
0x000000ffff477224ULL, 0x000fe200018e0647ULL, 0x0000e00050487811ULL, 0x002fe200078e20ffULL,
0x00000000242c7faeULL, 0x0003e2000b901c46ULL, 0x0000e00051497811ULL, 0x000fc600078e20ffULL,
0x0000000026487faeULL, 0x0003e8000b901c46ULL, 0x0000000046497faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x006fe20000000000ULL, 0xffffffffff2c7424ULL, 0x000fe200078e00ffULL,
0x000000022f247810ULL, 0x000fc80007ffe0ffULL, 0x000000292400720cULL, 0x000fda0003f06070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000000012e247824ULL, 0x000fe400078e0224ULL,
0x00000004ff257424ULL, 0x000fc800078e00ffULL, 0x0000600024247625ULL, 0x000fca00078e0025ULL,
0x00000006242c7981ULL, 0x000324000c1e1900ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff267f8cULL, 0x000ea2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010628002b487f8cULL, 0x000664000c80043fULL, 0x0000000000247805ULL, 0x002fc40000015200ULL,
0x01062c002b467984ULL, 0x000e640000000800ULL, 0x8000000046ff7812ULL, 0x002fe40007804849ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff4b7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000467805ULL, 0x000fcc0000015200ULL, 0x00000046244a7210ULL, 0x000fca0007f1e1ffULL,
0x0000000147477824ULL, 0x000fe200000e0e25ULL, 0x003d09004a00780cULL, 0x000fc80003f06070ULL,
0x000000ff4700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404a00780cULL, 0x000fc80003f06070ULL, 0x000000ff4700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff467819ULL, 0x000fc80000011447ULL,
0x0000004a46467211ULL, 0x000fca00078110ffULL, 0x000000ffff477224ULL, 0x000fca00000e0647ULL,
0x0000000246467819ULL, 0x000fc80000001247ULL, 0x000000460000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000014b4b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01062c002b467984ULL, 0x000e640000000800ULL,
0x8000000046ff7812ULL, 0x002fe40007804849ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0100800031257984ULL, 0x000e680000000800ULL, 0x0102800031467984ULL, 0x0006a20000000800ULL,
0x0000004c2500720bULL, 0x002fe20003f1d000ULL, 0x000185d27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000477806ULL, 0x008fc800000e0100ULL, 0x0000ffff47ff7812ULL, 0x000fe2000780c0ffULL,
0x000004a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff4a7424ULL, 0x000fc400078e00ffULL,
0x000000ffff247224ULL, 0x000fd200078e004cULL, 0x0000046000008947ULL, 0x000fea0003800000ULL,
0x000000010000780cULL, 0x000fe40003f05270ULL, 0x0000004c2500720bULL, 0x000fe20003f54000ULL,
0x000185927f007947ULL, 0x000fd8000b800000ULL, 0x0000000000247806ULL, 0x000fc400010e0100ULL,
0x0000004c25488209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe80003800000ULL,
0x0104804831008388ULL, 0x0003e40000000800ULL, 0x0000991024487816ULL, 0x002fc800000000ffULL,
0x000000ff4800720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000004c25487209ULL, 0x000fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff24ff7812ULL, 0x000fc6000780c0ffULL, 0x0000004c48487221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b48487820ULL, 0x000fc80000410000ULL, 0x00000048004b7308ULL, 0x000e640000000800ULL,
0x0000004b2d2d7220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff487819ULL, 0x000fe20000011602ULL, 0x000184d27f007947ULL, 0x000fea000b800000ULL,
0x00001f484b487589ULL, 0x0002e400000e0000ULL, 0x0000004818187220ULL, 0x088fe20000410000ULL,
0x0000004819197220ULL, 0x080fe20000410000ULL, 0x0000004814147220ULL, 0x080fe20000410000ULL,
0x0000004815157220ULL, 0x080fe20000410000ULL, 0x0000004810107220ULL, 0x080fe20000410000ULL,
0x0000004811117220ULL, 0x080fe20000410000ULL, 0x000000480c0c7220ULL, 0x080fe20000410000ULL,
0x000000480d0d7220ULL, 0x080fe20000410000ULL, 0x0000004808087220ULL, 0x080fe20000410000ULL,
0x0000004809097220ULL, 0x080fe20000410000ULL, 0x0000004804047220ULL, 0x080fe20000410000ULL,
0x0000004805057220ULL, 0x080fe20000410000ULL, 0x0000004820207220ULL, 0x080fe20000410000ULL,
0x0000004821217220ULL, 0x080fe20000410000ULL, 0x000000481c1c7220ULL, 0x080fe20000410000ULL,
0x000000481d1d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0024ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000802487811ULL, 0x000fe200078ff0ffULL, 0x000183d27f007947ULL, 0x000fea000b800000ULL,
0x00001f484b487589ULL, 0x00066400000e0000ULL, 0x000000481a1a7220ULL, 0x082fe20000410000ULL,
0x000000481b1b7220ULL, 0x080fe20000410000ULL, 0x0000004816167220ULL, 0x080fe20000410000ULL,
0x0000004817177220ULL, 0x080fe20000410000ULL, 0x0000004812127220ULL, 0x080fe20000410000ULL,
0x0000004813137220ULL, 0x080fe20000410000ULL, 0x000000480e0e7220ULL, 0x080fe20000410000ULL,
0x000000480f0f7220ULL, 0x080fe20000410000ULL, 0x000000480a0a7220ULL, 0x080fe20000410000ULL,
0x000000480b0b7220ULL, 0x080fe20000410000ULL, 0x0000004806067220ULL, 0x080fe20000410000ULL,
0x0000004807077220ULL, 0x080fe20000410000ULL, 0x0000004822227220ULL, 0x080fe20000410000ULL,
0x0000004823237220ULL, 0x080fe20000410000ULL, 0x000000481e1e7220ULL, 0x080fe20000410000ULL,
0x000000481f1f7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000ffff24ff7812ULL, 0x000fe20007800847ULL, 0x00000001ff4a7424ULL, 0x000fe200078e00ffULL,
0x0000004c254c7209ULL, 0x000fca0007810000ULL, 0x000000ffff247224ULL, 0x000fcc00078e004cULL,
0x8000004c25250221ULL, 0x100fe20000010000ULL, 0x000000ffff240224ULL, 0x000fe200078e004cULL,
0x00007610ff4a0816ULL, 0x000fe4000000004aULL, 0x3fb8aa3b25250820ULL, 0x000fc80000410000ULL,
0x0000002500350308ULL, 0x000e640000000800ULL, 0x0000003546460220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002d462d7221ULL, 0x004fc40000010000ULL,
0x0000000000467805ULL, 0x000fca0000015200ULL, 0x0106ac00ff257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe40007804845ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4b7224ULL, 0x008fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104b00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000487805ULL, 0x000fcc0000015200ULL,
0x0000004846487210ULL, 0x000fca0007f1e1ffULL, 0x0000000149497824ULL, 0x000fe200000e0e47ULL,
0x003d09004800780cULL, 0x000fc80003f06070ULL, 0x000000ff4900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404800780cULL, 0x000fc80003f06070ULL,
0x000000ff4900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc80000011449ULL, 0x0000004825257211ULL, 0x000fca00078110ffULL,
0x000000ffff487224ULL, 0x000fca00000e0649ULL, 0x0000000225257819ULL, 0x000fc80000001248ULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000014b4b7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106ac00ff257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe40007804845ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099104a257816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff2500720cULL, 0x000fda0003f45270ULL,
0x0000012000002947ULL, 0x000fea0003800000ULL, 0x00000035ff25723eULL, 0x000fe400000010ffULL,
0x00000002ff457819ULL, 0x000fe40000011602ULL, 0x0000541025257816ULL, 0x000fe20000000025ULL,
0x00017fa27f007947ULL, 0x000fea000b800000ULL, 0x00001f4525367589ULL, 0x0002a400000e0000ULL,
0x0000000845377810ULL, 0x000fe20007ffe0ffULL, 0x00017fd27f007947ULL, 0x000fea000b800000ULL,
0x00001f3725377589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001045497810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff4a7224ULL, 0x000fe200078e0025ULL,
0x00008c6000487802ULL, 0x000fc40000000f00ULL, 0x00018b2000007944ULL, 0x01efea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001845497810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4a7224ULL, 0x004fe200078e0025ULL, 0x00008cb000487802ULL, 0x000fc40000000f00ULL,
0x00018ad000007944ULL, 0x01afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000000394c783bULL, 0x000ee80000004200ULL,
0x000000003a50783bULL, 0x000ea80000004200ULL, 0x000000003c54783bULL, 0x000fe80000004200ULL,
0x000000003b48783bULL, 0x004ea20000004200ULL, 0x0000004c009e7306ULL, 0x008fe20000009400ULL,
0x00000018ffc07819ULL, 0x000fe2000001144cULL, 0x000001004ca37824ULL, 0x000fe200078e00ffULL,
0x00000018ffae7819ULL, 0x000fe2000001144dULL, 0x000001004fbb7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8c7819ULL, 0x000fe2000001144fULL, 0x000100004dce7824ULL, 0x000fe200078e00ffULL,
0x00000018ffc87819ULL, 0x000fe200000114a3ULL, 0x0000004c00c17306ULL, 0x000ee20000005400ULL,
0x00000018ffbb7819ULL, 0x000fe200000114bbULL, 0x000100004fbf7824ULL, 0x000fe200078e00ffULL,
0x00000018ffce7819ULL, 0x000fe200000114ceULL, 0x000100004ebc7824ULL, 0x040fe200078e00ffULL,
0x00000018ffa07819ULL, 0x000fe2000001144eULL, 0x0000010051aa7824ULL, 0x000fe200078e00ffULL,
0x00000018ffbf7819ULL, 0x000fe200000114bfULL, 0x0000004c00857306ULL, 0x0002a2000000d400ULL,
0x00000018ffbc7819ULL, 0x000fe200000114bcULL, 0x000001004dcf7824ULL, 0x000fe200078e00ffULL,
0x00000018ffaa7819ULL, 0x000fe200000114aaULL, 0x0001000051ad7824ULL, 0x000fe200078e00ffULL,
0x00000018ff987819ULL, 0x000fe20000011450ULL, 0x000001004eba7824ULL, 0x000fe200078e00ffULL,
0x00000018ffcf7819ULL, 0x000fe200000114cfULL, 0x0000004d00cd7306ULL, 0x000fe20000009400ULL,
0x000100004c4c7824ULL, 0x002fe200078e00ffULL, 0x000000c19e00720bULL, 0x008fe20003f7d000ULL,
0x0000010050ab7824ULL, 0x040fe200078e00ffULL, 0x00000018ffad7819ULL, 0x000fe200000114adULL,
0x0001000050ac7824ULL, 0x000fe200078e00ffULL, 0x00000018ffd47819ULL, 0x000fe2000001144cULL,
0x00010000534c7824ULL, 0x000fe200078e00ffULL, 0x0000004d00c47306ULL, 0x000e620000005400ULL,
0x00000018ffba7819ULL, 0x000fe200000114baULL, 0x00000100489e7824ULL, 0x004fe200078e00ffULL,
0x00000018ff967819ULL, 0x000fc40000011451ULL, 0x00000018ffab7819ULL, 0x000fe400000114abULL,
0x0000000185853812ULL, 0x000fe200078efcffULL, 0x000000d400d57306ULL, 0x000fe20000209400ULL,
0x00000018ff257819ULL, 0x000fe40000011456ULL, 0x00000018ff807819ULL, 0x000fe40000011453ULL,
0x00000018ffac7819ULL, 0x000fe400000114acULL, 0x00000018ff4c7819ULL, 0x000fe2000001144cULL,
0x000000d400d67306ULL, 0x000ea20000205400ULL, 0x000000c4cd00720bULL, 0x002fc40003f9d000ULL,
0x000000d400c47245ULL, 0x000fe4000020d400ULL, 0x00000018ff8a7819ULL, 0x000fe40000011448ULL,
0x00000018ff7a7819ULL, 0x000fe20000011449ULL, 0x0000004d007b7306ULL, 0x0002e2000000d400ULL,
0x00000018ff737819ULL, 0x000fe4000001144aULL, 0x00000018ff837819ULL, 0x000fe40000011452ULL,
0x00000018ff5c7819ULL, 0x000fc4000001144bULL, 0x00000018ff9e7819ULL, 0x000fe2000001149eULL,
0x000000bb00d07306ULL, 0x000fe20000209400ULL, 0x000000d6d500720bULL, 0x004fe20003fbd000ULL,
0x0000010049d57824ULL, 0x000fe200078e00ffULL, 0x00000018ff6b7819ULL, 0x000fe20000011454ULL,
0x00010000524d7824ULL, 0x002fe200078e00ffULL, 0x00000018ff457819ULL, 0x000fe20000011457ULL,
0x000001004ad67824ULL, 0x000fe200078e00ffULL, 0x00000018ff667819ULL, 0x000fe20000011455ULL,
0x000000bb00db7306ULL, 0x0002a20000205400ULL, 0x000000017b7b4812ULL, 0x008fc400078efcffULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x00000018ffd67819ULL, 0x000fe400000114d6ULL,
0x00000001c4c45812ULL, 0x000fe200078efcffULL, 0x000000ae00b97306ULL, 0x000fe20000209400ULL,
0x000000bb00bb7245ULL, 0x002fce000020d400ULL, 0x000000ae00b87306ULL, 0x0002e20000205400ULL,
0x000000dbd000720bULL, 0x004fce0003f9d000ULL, 0x000000ce00d97306ULL, 0x000fe20000209400ULL,
0x000000ae00ae7245ULL, 0x002fca000020d400ULL, 0x00000001bbbb4812ULL, 0x000fe400078efcffULL,
0x000000ce00da7306ULL, 0x0002a20000205400ULL, 0x000000b8b900720bULL, 0x008fe20003fbd000ULL,
0x0000010055b97824ULL, 0x000fca00078e00ffULL, 0x00000018ffb97819ULL, 0x000fe200000114b9ULL,
0x000000bf00c67306ULL, 0x000fe20000209400ULL, 0x000000ce00ce7245ULL, 0x002fca000020d400ULL,
0x00000001aeae5812ULL, 0x000fe400078efcffULL, 0x000000bf00c77306ULL, 0x0002e20000205400ULL,
0x000000dad900720bULL, 0x004fce0003f7d000ULL, 0x000000c000cb7306ULL, 0x000fe20000209400ULL,
0x000000bf00bf7245ULL, 0x002fca000020d400ULL, 0x00000001cece3812ULL, 0x000fe400078efcffULL,
0x000000c000cc7306ULL, 0x0002a20000205400ULL, 0x000000c7c600720bULL, 0x008fce0003f9d000ULL,
0x000000c800c97306ULL, 0x000fe20000209400ULL, 0x000000c000c07245ULL, 0x002fca000020d400ULL,
0x00000001bfbf4812ULL, 0x000fe400078efcffULL, 0x000000c800d37306ULL, 0x000e620000205400ULL,
0x000000cccb00720bULL, 0x004fce0003f1d000ULL, 0x000000bc00c37306ULL, 0x000fec0000209400ULL,
0x00000001c0c00812ULL, 0x000fe400078efcffULL, 0x000000bc00ca7306ULL, 0x0004e20000205400ULL,
0x000000d3c900720bULL, 0x002fe20003fdd000ULL, 0x0001000048d37824ULL, 0x000fca00078e00ffULL,
0x00000018ffcc7819ULL, 0x000fe200000114d3ULL, 0x0000004f00a87306ULL, 0x000fe20000009400ULL,
0x000000bc00bc7245ULL, 0x004fce000020d400ULL, 0x0000004f00a97306ULL, 0x000e620000005400ULL,
0x000000cac300720bULL, 0x008fce0003fbd000ULL, 0x000000aa00c27306ULL, 0x000fec0000209400ULL,
0x00000001bcbc5812ULL, 0x000fe400078efcffULL, 0x000000aa00c57306ULL, 0x0004e20000205400ULL,
0x000000a9a800720bULL, 0x002fe40003f7d000ULL, 0x00000018ffa87819ULL, 0x000fca00000114d5ULL,
0x0000004e00b17306ULL, 0x000fe20000009400ULL, 0x000000aa00aa7245ULL, 0x004fce000020d400ULL,
0x0000004e00b27306ULL, 0x000e620000005400ULL, 0x000000c5c200720bULL, 0x008fce0003f9d000ULL,
0x0000008c008d7306ULL, 0x000fec0000209400ULL, 0x00000001aaaa4812ULL, 0x000fe400078efcffULL,
0x0000008c009f7306ULL, 0x000ea20000205400ULL, 0x000000b2b100720bULL, 0x002fe20003f1d000ULL,
0x0001000054b27824ULL, 0x000fca00078e00ffULL, 0x00000018ffb27819ULL, 0x000fe200000114b2ULL,
0x000000cf00d77306ULL, 0x000ff00000209400ULL, 0x000000cf00d87306ULL, 0x0003e20000205400ULL,
0x0000009f8d00720bULL, 0x004fe20003fbd000ULL, 0x00010000568d7824ULL, 0x000fc400078e00ffULL,
0x00000100579f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff8d7819ULL, 0x000fe2000001148dULL,
0x0000004f00767306ULL, 0x000ea2000000d400ULL, 0x000000cf00cf7245ULL, 0x002fe4000020d400ULL,
0x00000018ff9f7819ULL, 0x000fca000001149fULL, 0x0000005100a17306ULL, 0x000ff00000009400ULL,
0x0000005100a27306ULL, 0x000e620000005400ULL, 0x0000000176763812ULL, 0x004fce00078efcffULL,
0x000000ad00b77306ULL, 0x000ff00000209400ULL, 0x000000ad00b67306ULL, 0x0004e20000205400ULL,
0x000000a2a100720bULL, 0x002fe40003f7d000ULL, 0x000000a000a17245ULL, 0x000fca000020d400ULL,
0x0000004e00797306ULL, 0x0002e2000000d400ULL, 0x000000ad00ad7245ULL, 0x004fce000020d400ULL,
0x0000005000a57306ULL, 0x000fe20000009400ULL, 0x00000100534e7824ULL, 0x002fe200078e00ffULL,
0x000000b6b700720bULL, 0x008fc80003f9d000ULL, 0x00000018ff4e7819ULL, 0x000fe4000001144eULL,
0x0000005000a67306ULL, 0x000fe20000005400ULL, 0x0000000179790812ULL, 0x000fcc00078efcffULL,
0x00000001adad4812ULL, 0x000fe200078efcffULL, 0x00000050005b7306ULL, 0x0003f0000000d400ULL,
0x000000a000a77306ULL, 0x000fe20000209400ULL, 0x000000c800507245ULL, 0x002fe2000020d400ULL,
0x000100004bc87824ULL, 0x000fc600078e00ffULL, 0x0000000150506812ULL, 0x000fe400078efcffULL,
0x000000d8d700720bULL, 0x000fe20003fdd000ULL, 0x000000a000a47306ULL, 0x0002a20000205400ULL,
0x00000018ffc87819ULL, 0x000fe400000114c8ULL, 0x000000855050723eULL, 0x000fca00000010ffULL,
0x00000098009d7306ULL, 0x000fe20000209400ULL, 0x0000010056a07824ULL, 0x002fc600078e00ffULL,
0x00000001cfcf6812ULL, 0x000fe400078efcffULL, 0x00000018ffa07819ULL, 0x000fe400000114a0ULL,
0x00000098009c7306ULL, 0x0003e20000205400ULL, 0x000000a4a700720bULL, 0x004fe20003f1d000ULL,
0x0000010054a77824ULL, 0x000fca00078e00ffULL, 0x00000018ffa77819ULL, 0x000fe200000114a7ULL,
0x000000ba00d17306ULL, 0x000fe20000209400ULL, 0x0000009800987245ULL, 0x002fca000020d400ULL,
0x00000001a1a10812ULL, 0x000fe400078efcffULL, 0x000000ba00d27306ULL, 0x0002b00000205400ULL,
0x0000005100587306ULL, 0x0006e2000000d400ULL, 0x000000ba00ba7245ULL, 0x002fce000020d400ULL,
0x0000005300957306ULL, 0x000fe20000009400ULL, 0x000000d2d100720bULL, 0x004fe20003fdd000ULL,
0x0000010052517824ULL, 0x008fca00078e00ffULL, 0x00000018ff517819ULL, 0x000fe20000011451ULL,
0x0000005300947306ULL, 0x000e620000005400ULL, 0x0000000158583812ULL, 0x000fca00078efcffULL,
0x00000001baba6812ULL, 0x000fe400078efcffULL, 0x0000009600977306ULL, 0x000fe20000209400ULL,
0x000000a6a500720bULL, 0x000fce0003fdd000ULL, 0x0000009600997306ULL, 0x0004e20000205400ULL,
0x000000949500720bULL, 0x002fe40003f9d000ULL, 0x0000005100947245ULL, 0x000fc6000020d400ULL,
0x000000015b5b6812ULL, 0x000fe400078efcffULL, 0x0000005600727306ULL, 0x000fe20000009400ULL,
0x0000009600967245ULL, 0x004fce000020d400ULL, 0x00000056005f7306ULL, 0x000fe20000005400ULL,
0x000000999700720bULL, 0x008fce0003f7d000ULL, 0x0000005600467306ULL, 0x0003ec000000d400ULL,
0x0000000196963812ULL, 0x000fe400078efcffULL, 0x000000ab00be7306ULL, 0x000fe20000209400ULL,
0x0000008c00567245ULL, 0x002fe2000020d400ULL, 0x00010000578c7824ULL, 0x000fe200078e00ffULL,
0x000000ad96ad723eULL, 0x000fc400000010ffULL, 0x0000000156565812ULL, 0x000fe400078efcffULL,
0x0000009c9d00720bULL, 0x000fe20003fbd000ULL, 0x000000ab00bd7306ULL, 0x0002a20000205400ULL,
0x00000018ff8c7819ULL, 0x000fce000001148cULL, 0x0000004e00a37306ULL, 0x000fe20000209400ULL,
0x000000ab00ab7245ULL, 0x002fc6000020d400ULL, 0x0000000198985812ULL, 0x000fc800078efcffULL,
0x0000004e00b47306ULL, 0x000e620000205400ULL, 0x000000bdbe00720bULL, 0x004fce0003f1d000ULL,
0x00000053005d7306ULL, 0x000eac000000d400ULL, 0x00000001abab0812ULL, 0x000fe400078efcffULL,
0x0000004800937306ULL, 0x000fe20000009400ULL, 0x000000b4a300720bULL, 0x002fce0003fbd000ULL,
0x0000004800927306ULL, 0x000e620000005400ULL, 0x000000015d5d4812ULL, 0x004fce00078efcffULL,
0x00000080008e7306ULL, 0x000ff00000209400ULL, 0x00000080008f7306ULL, 0x0004e20000205400ULL,
0x000000929300720bULL, 0x002fe40003f7d000ULL, 0x0000004e00927245ULL, 0x000fc8000020d400ULL,
0x0000000192925812ULL, 0x000fe200078efcffULL, 0x000000ac00af7306ULL, 0x000fe20000209400ULL,
0x0000008000807245ULL, 0x004fce000020d400ULL, 0x000000ac00b57306ULL, 0x0002a20000205400ULL,
0x0000008f8e00720bULL, 0x008fe40003f9d000ULL, 0x0000004c008f7245ULL, 0x000fe4000020d400ULL,
0x0000004d008e7245ULL, 0x000fc6000020d400ULL, 0x00000052009a7306ULL, 0x000fe20000009400ULL,
0x000000ac00ac7245ULL, 0x002fca000020d400ULL, 0x0000000180804812ULL, 0x000fe400078efcffULL,
0x00000052009b7306ULL, 0x000e620000005400ULL, 0x000000b5af00720bULL, 0x004fce0003f1d000ULL,
0x0000004c00537306ULL, 0x000fec0000209400ULL, 0x00000001acac0812ULL, 0x000fe400078efcffULL,
0x0000004c00c97306ULL, 0x0004e20000205400ULL, 0x0000009b9a00720bULL, 0x002fe40003fdd000ULL,
0x000000ac98ac723eULL, 0x000fca00000010ffULL, 0x000000a800a97306ULL, 0x000fe20000209400ULL,
0x000000c4c04c723eULL, 0x004fce00000010ffULL, 0x000000a800a47306ULL, 0x0002a20000205400ULL,
0x000000c95300720bULL, 0x008fce0003fbd000ULL, 0x00000048006f7306ULL, 0x0006a2000000d400ULL,
0x000000a800a87245ULL, 0x002fca000020d400ULL, 0x000000018f8f5812ULL, 0x000fe400078efcffULL,
0x0000005100b37306ULL, 0x000fe20000209400ULL, 0x000001004b487824ULL, 0x008fe200078e00ffULL,
0x000000a4a900720bULL, 0x004fe40003f9d000ULL, 0x0000008f808f723eULL, 0x000fe400000010ffULL,
0x00000018ff9a7819ULL, 0x000fe40000011448ULL, 0x0000005100b07306ULL, 0x0002a20000205400ULL,
0x0000a8003e487811ULL, 0x000fc400078e20ffULL, 0x000000016f6f3812ULL, 0x000fc800078efcffULL,
0x00000001a8a84812ULL, 0x000fe200078efcffULL, 0x000000cc00b87306ULL, 0x000fe20000209400ULL,
0x0000007bcf51723eULL, 0x002fce00000010ffULL, 0x000000cc00b17306ULL, 0x0002e20000205400ULL,
0x000000b0b300720bULL, 0x004fce0003f1d000ULL, 0x00000049008b7306ULL, 0x000fe20000009400ULL,
0x000000cc00cc7245ULL, 0x002fca000020d400ULL, 0x0000000194940812ULL, 0x000fe400078efcffULL,
0x0000004900817306ULL, 0x000fe20000005400ULL, 0x000000b1b800720bULL, 0x008fce0003fbd000ULL,
0x00000049006e7306ULL, 0x0003ec000000d400ULL, 0x00000001cccc5812ULL, 0x000fe400078efcffULL,
0x0000004a00897306ULL, 0x000fe20000009400ULL, 0x0001000049497824ULL, 0x002fca00078e00ffULL,
0x00000018ffa27819ULL, 0x000fe40000011449ULL, 0x0000004a007d7306ULL, 0x000e700000005400ULL,
0x0000004a00687306ULL, 0x0004f0000000d400ULL, 0x0000007a00877306ULL, 0x000fe20000209400ULL,
0x000100004a4a7824ULL, 0x004fe200078e00ffULL, 0x0000007d8900720bULL, 0x002fc80003fbd000ULL,
0x00000018ff957819ULL, 0x000fe4000001144aULL, 0x0000007a00847306ULL, 0x0002ae0000205400ULL,
0x0000000168685812ULL, 0x008fe200078efcffULL, 0x0000004b00887306ULL, 0x000fe20000009400ULL,
0x0000007a007a7245ULL, 0x002fce000020d400ULL, 0x0000004b007e7306ULL, 0x000fe20000005400ULL,
0x000000848700720bULL, 0x004fce0003f9d000ULL, 0x0000004b00697306ULL, 0x0003ec000000d400ULL,
0x000000017a7a4812ULL, 0x000fe400078efcffULL, 0x00000052005e7306ULL, 0x000ea2000000d400ULL,
0x000000004848783bULL, 0x002e6e0000000200ULL, 0x0000008300907306ULL, 0x000ff00000209400ULL,
0x0000008300917306ULL, 0x0006e20000205400ULL, 0x000000015e5e6812ULL, 0x004fc800078efcffULL,
0x0000005e9494723eULL, 0x000fc600000010ffULL, 0x0000004d004f7306ULL, 0x000fe20000209400ULL,
0x0000008300837245ULL, 0x008fce000020d400ULL, 0x0000004d00527306ULL, 0x0004e20000205400ULL,
0x000000919000720bULL, 0x000fce0003fdd000ULL, 0x0000009a00977306ULL, 0x000fe20000209400ULL,
0x000000364848a231ULL, 0x082fe200003400ffULL, 0x000000ceae4d723eULL, 0x004fe200000010ffULL,
0x000000364a4aa231ULL, 0x000fe400003400ffULL, 0x000000374949a231ULL, 0x080fe200003400ffULL,
0x0000000183836812ULL, 0x000fe200078efcffULL, 0x000000374b4ba231ULL, 0x000fe200003400ffULL,
0x0000009a00997306ULL, 0x0002a20000205400ULL, 0x000000524f00720bULL, 0x008fca0003f1d000ULL,
0x000000504818723cULL, 0x000be40000041818ULL, 0x0000008a007f7306ULL, 0x000fe20000209400ULL,
0x0000009a009a7245ULL, 0x002fc8000020d400ULL, 0x00000076bb51723eULL, 0x020fe400000010ffULL,
0x000000018e8e0812ULL, 0x000fe200078efcffULL, 0x0000008a00827306ULL, 0x0002e20000205400ULL,
0x000000999700720bULL, 0x004fe40003f9d000ULL, 0x00000079ba50723eULL, 0x000fe400000010ffULL,
0x0000008e838e723eULL, 0x000fc600000010ffULL, 0x0000009e00c17306ULL, 0x000fe20000209400ULL,
0x0000008a008a7245ULL, 0x002fe2000020d400ULL, 0x000000504850723cULL, 0x040be80000041810ULL,
0x000000019a9a4812ULL, 0x000fe400078efcffULL, 0x0000009e00cb7306ULL, 0x0002a20000205400ULL,
0x000000827f00720bULL, 0x008fe20003fdd000ULL, 0x0000008e481c723cULL, 0x000fe2000004181cULL,
0x0000005bab10723eULL, 0x020fc400000010ffULL, 0x00000058aa11723eULL, 0x000fc600000010ffULL,
0x00000095004e7306ULL, 0x000fe20000209400ULL, 0x0000009e009e7245ULL, 0x002fca000020d400ULL,
0x000000018a8a6812ULL, 0x000fe400078efcffULL, 0x00000095004f7306ULL, 0x000e620000205400ULL,
0x000000cbc100720bULL, 0x004fe40003f1d000ULL, 0x0000007e8800720bULL, 0x000fca0003fdd000ULL,
0x0000007300757306ULL, 0x000fec0000209400ULL, 0x000000019e9e0812ULL, 0x000fe400078efcffULL,
0x0000007300747306ULL, 0x0004e20000205400ULL, 0x0000004f4e00720bULL, 0x002fe40003fbd000ULL,
0x000000818b00720bULL, 0x000fe20003f1d000ULL, 0x0000004c484c723cULL, 0x000b620000041814ULL,
0x0000000169696812ULL, 0x000fc400078efcffULL, 0x0000005f7200720bULL, 0x000fe20003fdd000ULL,
0x000000c800907306ULL, 0x000fe20000209400ULL, 0x0000007300737245ULL, 0x004fe4000020d400ULL,
0x0000a8003d147811ULL, 0x020fe400078e20ffULL, 0x0000005c00727245ULL, 0x000fc6000020d400ULL,
0x000000c8007f7306ULL, 0x0002a20000205400ULL, 0x000000747500720bULL, 0x008fe20003f9d000ULL,
0x000000001414783bULL, 0x000ee20000000200ULL, 0x0000009500747245ULL, 0x000fe4000020d400ULL,
0x000000016e6e0812ULL, 0x000fe400078efcffULL, 0x0000000174745812ULL, 0x000fe200078efcffULL,
0x0000005400867306ULL, 0x000fe20000009400ULL, 0x000000c800c87245ULL, 0x002fe4000020d400ULL,
0x0000005d9295723eULL, 0x000fc400000010ffULL, 0x0000000146466812ULL, 0x000fe400078efcffULL,
0x0000000173734812ULL, 0x000fe200078efcffULL, 0x00000054007c7306ULL, 0x000e620000005400ULL,
0x0000007f9000720bULL, 0x004fe20003fbd000ULL, 0x000000944820723cULL, 0x000fec0000041820ULL,
0x0000005400627306ULL, 0x000eac000000d400ULL, 0x00000001c8c85812ULL, 0x000fc400078efcffULL,
0x000000a200a57306ULL, 0x000fe20000209400ULL, 0x0000007c8600720bULL, 0x002fce0003f1d000ULL,
0x000000a200547306ULL, 0x0002620000205400ULL, 0x000000361414a231ULL, 0x088fe400003400ffULL,
0x000000361616a231ULL, 0x000fc600003400ffULL, 0x0000000162620812ULL, 0x004fe200078efcffULL,
0x000000371515a231ULL, 0x080fe200003400ffULL, 0x000000a700817306ULL, 0x000fe20000209400ULL,
0x000000a200a27245ULL, 0x002fe2000020d400ULL, 0x000000371717a231ULL, 0x000fcc00003400ffULL,
0x000000a7007d7306ULL, 0x0002a20000205400ULL, 0x00000054a500720bULL, 0x000fe40003f7d000ULL,
0x000000bca154723eULL, 0x000fca00000010ffULL, 0x0000005700717306ULL, 0x000fe20000009400ULL,
0x000000a700a77245ULL, 0x002fca000020d400ULL, 0x00000001a2a23812ULL, 0x000fe400078efcffULL,
0x0000005700707306ULL, 0x000fe20000005400ULL, 0x0000007d8100720bULL, 0x004fce0003fbd000ULL,
0x0000005700477306ULL, 0x000fec000000d400ULL, 0x00000001a7a75812ULL, 0x000fe400078efcffULL,
0x000000d600a67306ULL, 0x000fe40000209400ULL, 0x00000062a762723eULL, 0x000fcc00000010ffULL,
0x000000d600577306ULL, 0x0002b00000205400ULL, 0x000000b9007c7306ULL, 0x000fe20000209400ULL,
0x000000d600d67245ULL, 0x002fce000020d400ULL, 0x000000b9007e7306ULL, 0x0002e20000205400ULL,
0x00000057a600720bULL, 0x004fce0003f7d000ULL, 0x000000b2007b7306ULL, 0x000fe20000209400ULL,
0x000000b900b97245ULL, 0x002fca000020d400ULL, 0x00000001d6d63812ULL, 0x000fe400078efcffULL,
0x000000b200767306ULL, 0x0002a20000205400ULL, 0x0000007e7c00720bULL, 0x008fce0003fbd000ULL,
0x0000005500787306ULL, 0x000fe20000009400ULL, 0x000000b200b27245ULL, 0x002fca000020d400ULL,
0x00000001b9b95812ULL, 0x000fe400078efcffULL, 0x0000005500777306ULL, 0x000e620000005400ULL,
0x000000767b00720bULL, 0x004fce0003f1d000ULL, 0x0000005c005a7306ULL, 0x000fec0000209400ULL,
0x00000001b2b20812ULL, 0x000fe400078efcffULL, 0x0000005c00597306ULL, 0x0004e20000205400ULL,
0x000000777800720bULL, 0x002fce0003f7d000ULL, 0x0000005500637306ULL, 0x0002e2000000d400ULL,
0x000000ac485c723cULL, 0x004bee0000041804ULL, 0x0000006b006d7306ULL, 0x000fe20000209400ULL,
0x0001000055557824ULL, 0x002fe200078e00ffULL, 0x000000595a00720bULL, 0x008fc40003f9d000ULL,
0x000000104858723cULL, 0x000b640000041808ULL, 0x000000747304723eULL, 0x020fe400000010ffULL,
0x00000018ff757819ULL, 0x000fe20000011455ULL, 0x0000006b006c7306ULL, 0x0002a20000205400ULL,
0x000000bf5655723eULL, 0x000fe400000010ffULL, 0x0000006f9e10723eULL, 0x000fe400000010ffULL,
0x0000006ea811723eULL, 0x000fc400000010ffULL, 0x0000000163633812ULL, 0x000fe200078efcffULL,
0x0000006600677306ULL, 0x000fe20000209400ULL, 0x0000006b006b7245ULL, 0x002fe2000020d400ULL,
0x000000544854723cULL, 0x000b62000004180cULL, 0x0000007500b37245ULL, 0x000fe4000020d400ULL,
0x0000000172724812ULL, 0x000fe400078efcffULL, 0x000000707100720bULL, 0x000fe20003f9d000ULL,
0x00000066006a7306ULL, 0x0002e20000205400ULL, 0x0000006c6d00720bULL, 0x004fc40003fbd000ULL,
0x000000cc8a0c723eULL, 0x020fe400000010ffULL, 0x000000a27a0d723eULL, 0x000fe400000010ffULL,
0x00000068d608723eULL, 0x000fe200000010ffULL, 0x0000007500127306ULL, 0x000fe20000209400ULL,
0x0000006600667245ULL, 0x002fe4000020d400ULL, 0x000000699a09723eULL, 0x000fe200000010ffULL,
0x0000000c140c723cULL, 0x000f62000004184cULL, 0x0000000147474812ULL, 0x000fc400078efcffULL,
0x000000016b6b5812ULL, 0x000fe200078efcffULL, 0x0000007500137306ULL, 0x000e620000205400ULL,
0x0000006a6700720bULL, 0x008fe40003f1d000ULL, 0x000000c87205723eULL, 0x000fe400000010ffULL,
0x00000063b963723eULL, 0x000fe400000010ffULL, 0x000000b26bb2723eULL, 0x000fe200000010ffULL,
0x000000a000777306ULL, 0x000fe80000209400ULL, 0x000000621458723cULL, 0x000f640000041858ULL,
0x0000000166660812ULL, 0x000fc400078efcffULL, 0x000000a0000a7306ULL, 0x0004e20000205400ULL,
0x000000131200720bULL, 0x002fc60003f7d000ULL, 0x000000101410723cULL, 0x000b680000041818ULL,
0x0000009f00067306ULL, 0x000fe20000209400ULL, 0x000000a000a07245ULL, 0x004fca000020d400ULL,
0x00000001b3b33812ULL, 0x000fe400078efcffULL, 0x0000009f00077306ULL, 0x0002a20000205400ULL,
0x0000000a7700720bULL, 0x008fe40003fbd000ULL, 0x000000b366b3723eULL, 0x000fe200000010ffULL,
0x000000081408723cULL, 0x000b680000041850ULL, 0x0000002500657306ULL, 0x000fe20000209400ULL,
0x0000009f009f7245ULL, 0x002fc6000020d400ULL, 0x000000b2145c723cULL, 0x040b64000004185cULL,
0x00000001a0a05812ULL, 0x000fe400078efcffULL, 0x0000002500647306ULL, 0x0002e20000205400ULL,
0x000000070600720bULL, 0x004fe40003f1d000ULL, 0x00000046a046723eULL, 0x000fe200000010ffULL,
0x000000041404723cULL, 0x000b680000041854ULL, 0x0000004500617306ULL, 0x000fe20000209400ULL,
0x0000002500257245ULL, 0x002fca000020d400ULL, 0x000000019f9f0812ULL, 0x000fe400078efcffULL,
0x0000004500607306ULL, 0x0002a20000205400ULL, 0x000000646500720bULL, 0x008fe40003f7d000ULL,
0x000000479f47723eULL, 0x000fca00000010ffULL, 0x0000008d00487306ULL, 0x000fe20000209400ULL,
0x0000004500457245ULL, 0x002fe2000020d400ULL, 0x000000461420723cULL, 0x000b680000041820ULL,
0x0000000125253812ULL, 0x000fe400078efcffULL, 0x0000008d00187306ULL, 0x0202e20000205400ULL,
0x000000606100720bULL, 0x004fce0003fbd000ULL, 0x0000008c00197306ULL, 0x000fe20000209400ULL,
0x0000008d008d7245ULL, 0x002fca000020d400ULL, 0x0000000145455812ULL, 0x000fe400078efcffULL,
0x0000008c001a7306ULL, 0x000e620000205400ULL, 0x000000184800720bULL, 0x008fda0003fdd000ULL,
0x000000018d8d6812ULL, 0x000fe400078efcffULL, 0x0000001a1900720bULL, 0x002fe40003f1d000ULL,
0x0000008c00197245ULL, 0x000fe4000020d400ULL, 0x0000008d2518723eULL, 0x000fd200000010ffULL,
0x0000000119190812ULL, 0x000fc800078efcffULL, 0x000000194519723eULL, 0x000fce00000010ffULL,
0x000000181414723cULL, 0x000b62000004181cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff1c7f8cULL, 0x020e62000c80043fULL, 0x000000ffff1f7224ULL, 0x000fce00078e00ffULL,
0x0000000000187805ULL, 0x000fc40000015200ULL, 0x0106bc00ff1a7984ULL, 0x000ea40000000800ULL,
0x800000001aff7812ULL, 0x006fe4000780481dULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101f00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001a7805ULL, 0x000fcc0000015200ULL, 0x0000001a181e7210ULL, 0x000fca0007f1e1ffULL,
0x000000011b1b7824ULL, 0x000fe200000e0e19ULL, 0x003d09001e00780cULL, 0x000fc80003f06070ULL,
0x000000ff1b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401e00780cULL, 0x000fc80003f06070ULL, 0x000000ff1b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1a7819ULL, 0x000fc8000001141bULL,
0x0000001e1a1a7211ULL, 0x000fca00078110ffULL, 0x000000ffff1b7224ULL, 0x000fca00000e061bULL,
0x000000021a1a7819ULL, 0x000fc8000000121bULL, 0x0000001a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011f1f7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106bc00ff1a7984ULL, 0x000e640000000800ULL,
0x800000001aff7812ULL, 0x002fe4000780481dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000058002c257a24ULL, 0x010fc800078e02ffULL, 0x0000004025257824ULL, 0x000fe200078e00ffULL,
0x0000045000009947ULL, 0x000fea0003800000ULL, 0x0000000238497810ULL, 0x040fe20007ffe0ffULL,
0x000000012b187824ULL, 0x040fe200078e0238ULL, 0x00000004384b7810ULL, 0x000fe20007ffe0ffULL,
0x0000008004057891ULL, 0x000fe2000f8e403fULL, 0x000000f030477812ULL, 0x000fe200078ec0ffULL,
0x000000012b1a7824ULL, 0x000fe400078e0249ULL, 0x0000000118197824ULL, 0x040fe400078e0202ULL,
0x0000001018487824ULL, 0x000fc400078e00ffULL, 0x0000004003467824ULL, 0x000fe400078e0218ULL,
0x000000012b187824ULL, 0x000fe200078e024bULL, 0xfffffff048487812ULL, 0x000fe200078ee219ULL,
0x000000011a1b7824ULL, 0x100fe200078e0202ULL, 0x00000025461e7210ULL, 0x000fe20007f1e0ffULL,
0x000000101a4a7824ULL, 0x000fe200078e00ffULL, 0x0000000246457810ULL, 0x000fe20007ffe0ffULL,
0x00000001181a7824ULL, 0x000fe200078e0202ULL, 0x00000004461f7810ULL, 0x000fe20007ffe0ffULL,
0x00000010184c7824ULL, 0x000fe200078e00ffULL, 0x0000000528187c17ULL, 0x000fe2000f800000ULL,
0x000000ffff197224ULL, 0x000fe200000e06ffULL, 0x00005e001e1d7a11ULL, 0x000fc400078040ffULL,
0x8000000518187c10ULL, 0x000fe4000fffe0ffULL, 0x00005f001e1e7a11ULL, 0x000fe400000f4419ULL,
0x000000182b187217ULL, 0x000fe40007800000ULL, 0x0000002545457210ULL, 0x080fe40007f1e0ffULL,
0xfffffff04a4a7812ULL, 0x000fe200078ee21bULL, 0x00000001181b7824ULL, 0x000fe200078e0a2bULL,
0x000000251f1f7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff187224ULL, 0x000fe200000e06ffULL,
0x00005e00451c7a11ULL, 0x000fc400078040ffULL, 0x0000001b3800720cULL, 0x000fe20003f86070ULL,
0x000000ffff197224ULL, 0x000fe200018e06ffULL, 0xfffffff04c4c7812ULL, 0x000fe400078ee21aULL,
0x00005f0045457a11ULL, 0x000fe400000f4418ULL, 0x00005e001f1a7a11ULL, 0x000fe400078a40ffULL,
0x000000471d187210ULL, 0x000fe40007f7e0ffULL, 0x00005f001f1f7a11ULL, 0x000fc400028f4419ULL,
0x0000001b4900720cULL, 0x080fe20003f06070ULL, 0x000000ffff197224ULL, 0x000fe200018e061eULL,
0x0000c00048487811ULL, 0x000fe400078e20ffULL, 0x0000000638497810ULL, 0x000fe40007ffe0ffULL,
0x00000006461d7810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018487faeULL, 0x0003e2000e101c46ULL, 0x0000001b4b00720cULL, 0x000fe20003f66070ULL,
0x000000012b1e7824ULL, 0x000fe200078e0249ULL, 0x000000251d1d7210ULL, 0x000fc40007f9e0ffULL,
0x000000471a1a7210ULL, 0x080fe20007fde0ffULL, 0x000000011e467824ULL, 0x000fe200078e0202ULL,
0x0000c0004a4a7811ULL, 0x000fe400078e20ffULL, 0x0000c0004c4c7811ULL, 0x000fe400078e20ffULL,
0x000000471c187210ULL, 0x002fe20007fbe0ffULL, 0x000000101e487824ULL, 0x000fe400078e00ffULL,
0x000000ffff1e7224ULL, 0x000fe200020e06ffULL, 0x00005e001d1c7a11ULL, 0x000fe200078840ffULL,
0x000000ffff197224ULL, 0x000fe200028e0645ULL, 0x0000001b4900720cULL, 0x000fe20003fa6070ULL,
0x000000ffff1b7224ULL, 0x000fe200030e061fULL, 0x00005f001d1d7a11ULL, 0x000fc400020f441eULL,
0x000000471c1c7210ULL, 0x000fe20007f9e0ffULL, 0x00000000184a7faeULL, 0x0003e2000c101c46ULL,
0xfffffff048467812ULL, 0x000fc600078ee246ULL, 0x000000ffff1d7224ULL, 0x000fe200020e061dULL,
0x0000c00046467811ULL, 0x000fe200078e20ffULL, 0x000000001a4c7faeULL, 0x0003e8000d901c46ULL,
0x000000001c467faeULL, 0x0003e2000e901c46ULL, 0x0000038000007947ULL, 0x000fea0003800000ULL,
0x000000012b187824ULL, 0x000fc800078e0238ULL, 0x0000000118197824ULL, 0x040fe200078e0202ULL,
0x00000002181a7810ULL, 0x040fe20007ffe0ffULL, 0x00000010181c7824ULL, 0x000fc800078e00ffULL,
0x000000011a1b7824ULL, 0x000fe200078e0202ULL, 0xfffffff01c1c7812ULL, 0x000fe200078ee219ULL,
0x000000101a457824ULL, 0x000fe200078e00ffULL, 0x00000004181a7810ULL, 0x000fe20007ffe0ffULL,
0x0000004003197824ULL, 0x000fc600078e0218ULL, 0xfffffff045457812ULL, 0x000fe200078ee21bULL,
0x000000011a1d7824ULL, 0x100fe200078e0202ULL, 0x00000006181b7810ULL, 0x000fe20007ffe0ffULL,
0x000000101a497824ULL, 0x000fe200078e00ffULL, 0x0000002519187210ULL, 0x000fe40007f1e0ffULL,
0x0000c00045457811ULL, 0x000fe200078e20ffULL, 0x000000011b1e7824ULL, 0x000fe200078e0202ULL,
0xfffffff049497812ULL, 0x000fe200078ee21dULL, 0x000000101b4d7824ULL, 0x000fe200078e00ffULL,
0x00000002191d7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff1a7224ULL, 0x000fe200000e06ffULL,
0x00005e00181b7a11ULL, 0x000fc400078040ffULL, 0xfffffff04d4d7812ULL, 0x000fe400078ee21eULL,
0x00005f00181a7a11ULL, 0x000fe400000f441aULL, 0x0000000419187810ULL, 0x040fe40007ffe0ffULL,
0x0000000619197810ULL, 0x000fe40007ffe0ffULL, 0x000000251d1d7210ULL, 0x080fe40007f1e0ffULL,
0x0000002518467210ULL, 0x000fc40007f7e0ffULL, 0x000000f0301e7812ULL, 0x000fe400078ec0ffULL,
0x00000025194a7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff197224ULL, 0x000fe200000e06ffULL,
0x00005e001d1f7a11ULL, 0x000fe200078040ffULL, 0x000000ffff477224ULL, 0x000fe200018e06ffULL,
0x0000001e1b187210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff4b7224ULL, 0x000fe200028e06ffULL,
0x00005e0046487a11ULL, 0x000fe400078840ffULL, 0x00005e004a4c7a11ULL, 0x000fc400078a40ffULL,
0x00005f001d1d7a11ULL, 0x000fe200000f4419ULL, 0x000000ffff197224ULL, 0x000fe200018e061aULL,
0x0000c0001c1b7811ULL, 0x000fe400078e20ffULL, 0x0000001e1f1a7210ULL, 0x080fe40007f1e0ffULL,
0x00005f0046477a11ULL, 0x000fe200020f4447ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000181b7faeULL, 0x0003e2000b901c46ULL, 0x0000001e481c7210ULL, 0x000fe40007f7e0ffULL,
0x00005f004a4b7a11ULL, 0x000fc400028f444bULL, 0x0000001e4c1e7210ULL, 0x000fe40007f9e0ffULL,
0x0000c00049497811ULL, 0x000fe400078e20ffULL, 0x0000c0004d4d7811ULL, 0x000fe200078e20ffULL,
0x000000ffff1f7224ULL, 0x000fe400020e064bULL, 0x000000ffff1b7224ULL, 0x002fe400000e061dULL,
0x000000ffff1d7224ULL, 0x000fc600018e0647ULL, 0x000000001a457faeULL, 0x0003e8000b901c46ULL,
0x000000001c497faeULL, 0x0003e8000b901c46ULL, 0x000000001e4d7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff187f8cULL, 0x000e64000c80043fULL, 0x000000ffff457224ULL, 0x002fc400078e0019ULL,
0x0000000000187805ULL, 0x000fca0000015200ULL, 0x0106b400ff1a7984ULL, 0x000e640000000800ULL,
0x800000001aff7812ULL, 0x002fc40007804827ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1d7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101d00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000001a7805ULL, 0x000fcc0000015200ULL,
0x0000001a181c7210ULL, 0x000fca0007f1e1ffULL, 0x000000011b1b7824ULL, 0x000fe200000e0e19ULL,
0x003d09001c00780cULL, 0x000fc80003f06070ULL, 0x000000ff1b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401c00780cULL, 0x000fc80003f06070ULL,
0x000000ff1b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1a7819ULL, 0x000fc8000001141bULL, 0x0000001c1a1a7211ULL, 0x000fca00078110ffULL,
0x000000ffff1b7224ULL, 0x000fca00000e061bULL, 0x000000021a1a7819ULL, 0x000fc8000000121bULL,
0x0000001a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000011d1d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106b400ff1a7984ULL, 0x000e640000000800ULL, 0x800000001aff7812ULL, 0x002fe40007804827ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000014000007945ULL, 0x000fe20003800000ULL,
0x0000012000002947ULL, 0x000fea0003800000ULL, 0x00000035ff18723eULL, 0x000fe400000010ffULL,
0x00000002ff197819ULL, 0x000fe40000011602ULL, 0x0000541018187816ULL, 0x000fe20000000018ULL,
0x000154a27f007947ULL, 0x000fea000b800000ULL, 0x00001f1918367589ULL, 0x0002a400000e0000ULL,
0x0000000819377810ULL, 0x000fe20007ffe0ffULL, 0x000154d27f007947ULL, 0x000fea000b800000ULL,
0x00001f3718377589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001019497810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff4a7224ULL, 0x000fe200078e0018ULL,
0x0000b82000487802ULL, 0x000fc40000000f00ULL, 0x00015f6000007944ULL, 0x00efea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001819497810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4a7224ULL, 0x004fe200078e0018ULL, 0x0000b87000487802ULL, 0x000fc40000000f00ULL,
0x00015f1000007944ULL, 0x00afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000004048783bULL, 0x004ea20000004200ULL,
0x0000008004057891ULL, 0x000fc6000f8e403fULL, 0x000000003f18783bULL, 0x00ae680000004200ULL,
0x00000000421c783bULL, 0x000ee80000004200ULL, 0x00000000414c783bULL, 0x000f220000004200ULL,
0x0000010048977824ULL, 0x004fe200078e00ffULL, 0x0000004900cd7306ULL, 0x000fe20000009400ULL,
0x0000010049d07824ULL, 0x000fe200078e00ffULL, 0x00000018ffc07819ULL, 0x000fe20000011448ULL,
0x000001004ac57824ULL, 0x040fe200078e00ffULL, 0x00000018ffd67819ULL, 0x000fe20000011497ULL,
0x000001004bbf7824ULL, 0x040fe200078e00ffULL, 0x00000018ffd07819ULL, 0x000fe200000114d0ULL,
0x000100004bc27824ULL, 0x000fe200078e00ffULL, 0x000000d600d77306ULL, 0x000fe20000209400ULL,
0x00000018ffc57819ULL, 0x000fe200000114c5ULL, 0x000100004ac17824ULL, 0x000fe200078e00ffULL,
0x00000018ffa07819ULL, 0x000fe2000001144bULL, 0x0001000048d27824ULL, 0x000fe200078e00ffULL,
0x00000018ffb67819ULL, 0x000fe20000011449ULL, 0x0001000049c87824ULL, 0x000fe200078e00ffULL,
0x00000018ffc17819ULL, 0x000fe200000114c1ULL, 0x000000d600d87306ULL, 0x000ea20000205400ULL,
0x00000018ffd27819ULL, 0x000fe200000114d2ULL, 0x0000010018b47824ULL, 0x042fe200078e00ffULL,
0x00000018ffaa7819ULL, 0x000fe2000001144aULL, 0x0001000018b57824ULL, 0x000fe200078e00ffULL,
0x00000018ffc87819ULL, 0x000fe200000114c8ULL, 0x0000010019b17824ULL, 0x040fe200078e00ffULL,
0x00000018ff9a7819ULL, 0x000fe20000011418ULL, 0x000000d000db7306ULL, 0x000fe20000209400ULL,
0x00000018ffbf7819ULL, 0x000fe200000114bfULL, 0x000001001aa27824ULL, 0x000fe200078e00ffULL,
0x00000018ffb47819ULL, 0x000fe200000114b4ULL, 0x0001000019a77824ULL, 0x000fe200078e00ffULL,
0x00000018ffc27819ULL, 0x000fc400000114c2ULL, 0x00000018ffb57819ULL, 0x000fe200000114b5ULL,
0x000000d000dc7306ULL, 0x000e620000205400ULL, 0x000000d8d700720bULL, 0x004fe20003f1d000ULL,
0x000001001ed87824ULL, 0x008fe200078e00ffULL, 0x00000018ffb17819ULL, 0x000fe200000114b1ULL,
0x000001001dd77824ULL, 0x000fe200078e00ffULL, 0x00000018ff957819ULL, 0x000fe40000011419ULL,
0x00000018ffa27819ULL, 0x000fe200000114a2ULL, 0x00000049008e7306ULL, 0x000ea20000005400ULL,
0x00000018ffa77819ULL, 0x000fc400000114a7ULL, 0x00000018ff867819ULL, 0x000fe4000001141aULL,
0x00000018ff857819ULL, 0x000fe4000001141bULL, 0x00000018ffd87819ULL, 0x000fe200000114d8ULL,
0x000000c500d47306ULL, 0x000fe20000209400ULL, 0x000000dcdb00720bULL, 0x002fe40003f9d000ULL,
0x00000018ff8a7819ULL, 0x000fe4000001141cULL, 0x00000018ff797819ULL, 0x000fc4000001141dULL,
0x00000018ff717819ULL, 0x000fe2000001141eULL, 0x000000c500d57306ULL, 0x0002e20000205400ULL,
0x00000018ff6b7819ULL, 0x000fe4000001141fULL, 0x00000018ff617819ULL, 0x010fe4000001144cULL,
0x00000018ff527819ULL, 0x000fe4000001144dULL, 0x00000018ff267819ULL, 0x000fe2000001144eULL,
0x0000004b00b37306ULL, 0x000fe20000009400ULL, 0x000000c500c57245ULL, 0x002fc4000020d400ULL,
0x00000018ff277819ULL, 0x000fca000001144fULL, 0x0000004b00b27306ULL, 0x000ff00000005400ULL,
0x0000004b00727306ULL, 0x0003f0000000d400ULL, 0x000000c000cf7306ULL, 0x000fe20000209400ULL,
0x000000d6004b7245ULL, 0x002fc8000020d400ULL, 0x000000014b4b0812ULL, 0x000fe400078efcffULL,
0x0000008ecd00720bULL, 0x004fe20003f1d000ULL, 0x000000c000ce7306ULL, 0x0002a20000205400ULL,
0x000000d000cd7245ULL, 0x000fe4000020d400ULL, 0x000000d2008e7245ULL, 0x000fe4000020d400ULL,
0x00000001cdcd4812ULL, 0x000fe400078efcffULL, 0x000000d5d400720bULL, 0x008fe20003f9d000ULL,
0x000000c100c77306ULL, 0x000fe20000209400ULL, 0x000000c000c07245ULL, 0x002fce000020d400ULL,
0x000000c100cc7306ULL, 0x0002e20000205400ULL, 0x000000cecf00720bULL, 0x004fc60003f7d000ULL,
0x00000001c5c54812ULL, 0x000fc800078efcffULL, 0x0000004800967306ULL, 0x000fe20000009400ULL,
0x000000c100c17245ULL, 0x002fca000020d400ULL, 0x00000001c0c03812ULL, 0x000fe400078efcffULL,
0x0000004800a17306ULL, 0x000e620000005400ULL, 0x000000ccc700720bULL, 0x008fce0003f9d000ULL,
0x000000b600bd7306ULL, 0x000fec0000209400ULL, 0x00000001c1c14812ULL, 0x000fe400078efcffULL,
0x000000b600be7306ULL, 0x0004e20000205400ULL, 0x000000a19600720bULL, 0x002fe20003fdd000ULL,
0x000100001fa17824ULL, 0x000fca00078e00ffULL, 0x00000018ffa17819ULL, 0x000fe200000114a1ULL,
0x000000d200d97306ULL, 0x000fe20000209400ULL, 0x000000b600b67245ULL, 0x004fce000020d400ULL,
0x000000d200da7306ULL, 0x000e620000205400ULL, 0x000000bebd00720bULL, 0x008fce0003f7d000ULL,
0x000000a000a57306ULL, 0x000fec0000209400ULL, 0x00000001b6b63812ULL, 0x000fe400078efcffULL,
0x000000a000a67306ULL, 0x0004e20000205400ULL, 0x000000dad900720bULL, 0x002fce0003fbd000ULL,
0x0000004800877306ULL, 0x000322000000d400ULL, 0x000000a000a07245ULL, 0x004fca000020d400ULL,
0x000000018e8e5812ULL, 0x000fe400078efcffULL, 0x000000aa00af7306ULL, 0x000fe20000209400ULL,
0x000000a6a500720bULL, 0x008fe20003f9d000ULL, 0x000100001a487824ULL, 0x002fe200078e00ffULL,
0x0000008ec08e723eULL, 0x000fe200000010ffULL, 0x000100004da57824ULL, 0x000fc600078e00ffULL,
0x00000018ff487819ULL, 0x000fe20000011448ULL, 0x000000aa00b07306ULL, 0x0002a20000205400ULL,
0x0000000187876812ULL, 0x010fe400078efcffULL, 0x00000018ffa57819ULL, 0x000fc600000114a5ULL,
0x00000001a0a04812ULL, 0x000fe400078efcffULL, 0x000000c800dd7306ULL, 0x000fe20000209400ULL,
0x000000aa00aa7245ULL, 0x002fce000020d400ULL, 0x000000c800de7306ULL, 0x0002e20000205400ULL,
0x000000b0af00720bULL, 0x004fe20003f7d000ULL, 0x000100004cb07824ULL, 0x000fcc00078e00ffULL,
0x0000004a00b87306ULL, 0x000fe20000009400ULL, 0x000000c800c87245ULL, 0x002fca000020d400ULL,
0x00000001aaaa3812ULL, 0x000fe400078efcffULL, 0x0000004a00b97306ULL, 0x000e620000005400ULL,
0x000000dedd00720bULL, 0x008fe40003fdd000ULL, 0x000000c1aaaa723eULL, 0x000fca00000010ffULL,
0x0000004900787306ULL, 0x0004ec000000d400ULL, 0x00000001c8c86812ULL, 0x000fe400078efcffULL,
0x0000009a009e7306ULL, 0x000fe20000209400ULL, 0x000000b9b800720bULL, 0x002fe20003fbd000ULL,
0x000100001b497824ULL, 0x004fe200078e00ffULL, 0x000000b2b300720bULL, 0x000fe20003fdd000ULL,
0x000001004db37824ULL, 0x000fe200078e00ffULL, 0x00000018ffb97819ULL, 0x000fc400000114d7ULL,
0x00000018ff497819ULL, 0x000fe20000011449ULL, 0x0000009a009f7306ULL, 0x0002a20000205400ULL,
0x0000000178780812ULL, 0x008fe400078efcffULL, 0x00000018ffb37819ULL, 0x000fca00000114b3ULL,
0x000000bf00d17306ULL, 0x000fe20000209400ULL, 0x0000009a009a7245ULL, 0x002fe4000020d400ULL,
0x0000000172726812ULL, 0x000fca00078efcffULL, 0x000000bf00d37306ULL, 0x0002e20000205400ULL,
0x0000009f9e00720bULL, 0x004fce0003f9d000ULL, 0x000000b400c37306ULL, 0x000fe20000209400ULL,
0x000000bf00bf7245ULL, 0x002fca000020d400ULL, 0x000000019a9a4812ULL, 0x000fe400078efcffULL,
0x000000b400c47306ULL, 0x0002a20000205400ULL, 0x000000d3d100720bULL, 0x008fce0003f1d000ULL,
0x0000004a00757306ULL, 0x000722000000d400ULL, 0x000000b400b47245ULL, 0x002fca000020d400ULL,
0x00000001bfbf0812ULL, 0x000fe400078efcffULL, 0x000000c200cb7306ULL, 0x000fe20000209400ULL,
0x000001001c4a7824ULL, 0x008fe200078e00ffULL, 0x000000c4c300720bULL, 0x004fe40003f7d000ULL,
0x00000072bfbf723eULL, 0x000fe400000010ffULL, 0x00000018ff4a7819ULL, 0x000fe4000001144aULL,
0x000000c200c97306ULL, 0x0002a20000205400ULL, 0x0000000175755812ULL, 0x010fc800078efcffULL,
0x00000075c5be723eULL, 0x000fe400000010ffULL, 0x00000001b4b43812ULL, 0x000fe200078efcffULL,
0x0000001800ac7306ULL, 0x000fe20000009400ULL, 0x000000c200c27245ULL, 0x002fce000020d400ULL,
0x0000001800ab7306ULL, 0x000e620000005400ULL, 0x000000c9cb00720bULL, 0x004fce0003fbd000ULL,
0x0000001b00947306ULL, 0x000fec0000009400ULL, 0x00000001c2c25812ULL, 0x000fe400078efcffULL,
0x0000001b00937306ULL, 0x000ea20000005400ULL, 0x000000abac00720bULL, 0x002fce0003f1d000ULL,
0x0000001900ad7306ULL, 0x000ff00000009400ULL, 0x0000001900ae7306ULL, 0x000e620000005400ULL,
0x000000939400720bULL, 0x004fce0003f9d000ULL, 0x000000b500b77306ULL, 0x000ff00000209400ULL,
0x000000b500ba7306ULL, 0x0004e20000205400ULL, 0x000000aead00720bULL, 0x002fe20003fdd000ULL,
0x000001004cae7824ULL, 0x000fca00078e00ffULL, 0x00000018ffae7819ULL, 0x000fe200000114aeULL,
0x000000b100c67306ULL, 0x000fe20000209400ULL, 0x000000b500b57245ULL, 0x004fce000020d400ULL,
0x000000b100ca7306ULL, 0x0002a20000205400ULL, 0x000000bab700720bULL, 0x008fce0003f7d000ULL,
0x0000001800707306ULL, 0x000722000000d400ULL, 0x000000b100b17245ULL, 0x002fca000020d400ULL,
0x00000001b5b53812ULL, 0x000fe400078efcffULL, 0x0000001b00667306ULL, 0x000262000000d400ULL,
0x000000cac600720bULL, 0x004fe20003fbd000ULL, 0x000001001b187824ULL, 0x008fca00078e00ffULL,
0x00000018ff187819ULL, 0x000fe20000011418ULL, 0x0000001a009d7306ULL, 0x000fe20000009400ULL,
0x0000000170700812ULL, 0x010fe200078efcffULL, 0x000001001f1b7824ULL, 0x002fc800078e00ffULL,
0x00000001b1b15812ULL, 0x000fe400078efcffULL, 0x0000001a009c7306ULL, 0x000e620000005400ULL,
0x0000000166664812ULL, 0x000fce00078efcffULL, 0x0000004a00967306ULL, 0x000ff00000209400ULL,
0x0000004a00ce7306ULL, 0x0004e20000205400ULL, 0x0000009c9d00720bULL, 0x002fe40003f1d000ULL,
0x00000018ff9c7819ULL, 0x000fc4000001141bULL, 0x0000a800431b7811ULL, 0x000fc600078e20ffULL,
0x00000019006f7306ULL, 0x000e62000000d400ULL, 0x0000004a004a7245ULL, 0x004fce000020d400ULL,
0x0000009500997306ULL, 0x000fe20000209400ULL, 0x000000ce9600720bULL, 0x008fce0003f9d000ULL,
0x00000095009b7306ULL, 0x0004e20000205400ULL, 0x000000016f6f6812ULL, 0x002fc800078efcffULL,
0x0000006fb1b1723eULL, 0x000fe400000010ffULL, 0x000000014a4a4812ULL, 0x000fe200078efcffULL,
0x000000a200a87306ULL, 0x000fe20000209400ULL, 0x0000009500957245ULL, 0x004fce000020d400ULL,
0x000000a200a97306ULL, 0x0002a20000205400ULL, 0x0000009b9900720bULL, 0x008fce0003fdd000ULL,
0x000000a700bc7306ULL, 0x000fe20000209400ULL, 0x000000a200a27245ULL, 0x002fca000020d400ULL,
0x0000000195956812ULL, 0x000fe400078efcffULL, 0x000000a700bb7306ULL, 0x0002e20000205400ULL,
0x000000a9a800720bULL, 0x004fce0003f7d000ULL, 0x0000001a006c7306ULL, 0x000ea2000000d400ULL,
0x000000a700a77245ULL, 0x002fca000020d400ULL, 0x00000001a2a23812ULL, 0x000fe400078efcffULL,
0x0000001d008c7306ULL, 0x000fe20000009400ULL, 0x000000bbbc00720bULL, 0x008fce0003fbd000ULL,
0x0000001d008d7306ULL, 0x000e620000005400ULL, 0x000000016c6c0812ULL, 0x004fc800078efcffULL,
0x0000006ca26c723eULL, 0x000fe400000010ffULL, 0x00000001a7a75812ULL, 0x000fe200078efcffULL,
0x0000004800197306ULL, 0x000fe60000209400ULL, 0x000000a79595723eULL, 0x000fca00000010ffULL,
0x00000048001a7306ULL, 0x000ea20000205400ULL, 0x0000008d8c00720bULL, 0x002fce0003f9d000ULL,
0x00000086008f7306ULL, 0x000ff00000209400ULL, 0x0000008600907306ULL, 0x0002e20000205400ULL,
0x0000001a1900720bULL, 0x004fce0003f1d000ULL, 0x0000008500917306ULL, 0x000fe20000209400ULL,
0x0000008600867245ULL, 0x002fce000020d400ULL, 0x0000008500927306ULL, 0x0002a20000205400ULL,
0x000000908f00720bULL, 0x008fe40003fdd000ULL, 0x0000001800907245ULL, 0x000fe4000020d400ULL,
0x000000c8b68f723eULL, 0x000fc600000010ffULL, 0x0000001800a37306ULL, 0x000fe20000209400ULL,
0x0000008500857245ULL, 0x002fca000020d400ULL, 0x0000000186866812ULL, 0x000fe400078efcffULL,
0x0000001800a47306ULL, 0x0002e20000205400ULL, 0x000000929100720bULL, 0x004fe40003f7d000ULL,
0x0000004800917245ULL, 0x000fe4000020d400ULL, 0x000000874b48723eULL, 0x000fe400000010ffULL,
0x0000000191910812ULL, 0x000fe200078efcffULL, 0x0000001d00627306ULL, 0x000522000000d400ULL,
0x000000001b18783bULL, 0x002e6a0000000200ULL, 0x0000000185853812ULL, 0x000fc400078efcffULL,
0x0000001c007c7306ULL, 0x000fe20000009400ULL, 0x000000a4a300720bULL, 0x008fe20003fbd000ULL,
0x000100001d1d7824ULL, 0x004fca00078e00ffULL, 0x00000018ffab7819ULL, 0x000fe2000001141dULL,
0x0000001c007a7306ULL, 0x000ea20000005400ULL, 0x0000000162624812ULL, 0x010fca00078efcffULL,
0x0000000190905812ULL, 0x000fe400078efcffULL, 0x000000d800ad7306ULL, 0x000ff00000209400ULL,
0x000000d8009e7306ULL, 0x0007220000205400ULL, 0x0000007a7c00720bULL, 0x004fc40003f1d000ULL,
0x00000049007a7245ULL, 0x000fe4000020d400ULL, 0x000000ab007c7245ULL, 0x000fc6000020d400ULL,
0x0000001c00657306ULL, 0x000522000000d400ULL, 0x000000d800d87245ULL, 0x008fe2000020d400ULL,
0x000000361818a231ULL, 0x082fe400003400ffULL, 0x000000361a1aa231ULL, 0x000fe400003400ffULL,
0x000000371919a231ULL, 0x080fe400003400ffULL, 0x0000004900977306ULL, 0x000fe20000209400ULL,
0x000100001c1c7824ULL, 0x004fe200078e00ffULL, 0x0000009ead00720bULL, 0x010fe20003f9d000ULL,
0x000000371b1ba231ULL, 0x000fc600003400ffULL, 0x00000018ffcf7819ULL, 0x000fe4000001141cULL,
0x0000004900987306ULL, 0x0002a20000205400ULL, 0x0000a800441c7811ULL, 0x000fe200078e20ffULL,
0x0000008e180c723cULL, 0x000fe2000004180cULL, 0x0000000165650812ULL, 0x000fc800078efcffULL,
0x00000001d8d84812ULL, 0x000fe200078efcffULL, 0x000000cf00d07306ULL, 0x000fe20000209400ULL,
0x00000078cd49723eULL, 0x002fe200000010ffULL, 0x000000be1808723cULL, 0x040fec0000041808ULL,
0x000000cf00b87306ULL, 0x0002e20000205400ULL, 0x000000989700720bULL, 0x004fe20003fbd000ULL,
0x000000481810723cULL, 0x000b6c0000041810ULL, 0x0000001e008b7306ULL, 0x000fe20000009400ULL,
0x000000cf00cf7245ULL, 0x002fc4000020d400ULL, 0x000000918648723eULL, 0x020fc600000010ffULL,
0x000000017a7a5812ULL, 0x000fe400078efcffULL, 0x0000001e00847306ULL, 0x000e620000005400ULL,
0x000000b8d000720bULL, 0x008fe40003fdd000ULL, 0x0000007a8549723eULL, 0x000fca00000010ffULL,
0x0000001e00607306ULL, 0x0004ec000000d400ULL, 0x00000001cfcf6812ULL, 0x000fe400078efcffULL,
0x0000009c009d7306ULL, 0x000fe20000209400ULL, 0x000100001e1e7824ULL, 0x004fe200078e00ffULL,
0x000000848b00720bULL, 0x002fc80003f1d000ULL, 0x00000018ff937819ULL, 0x000fe4000001141eULL,
0x0000009c00997306ULL, 0x0002ae0000205400ULL, 0x0000000160600812ULL, 0x008fe200078efcffULL,
0x0000001f00897306ULL, 0x000fe20000009400ULL, 0x0000009c009c7245ULL, 0x002fce000020d400ULL,
0x0000001f00807306ULL, 0x000e620000005400ULL, 0x000000999d00720bULL, 0x004fce0003f9d000ULL,
0x0000001f00577306ULL, 0x0004ec000000d400ULL, 0x000000019c9c4812ULL, 0x000fe400078efcffULL,
0x0000008a007f7306ULL, 0x000fe20000209400ULL, 0x000000001c1c783bULL, 0x004ea20000000200ULL,
0x000000808900720bULL, 0x002fcc0003fdd000ULL, 0x0000008a00817306ULL, 0x00032e0000205400ULL,
0x0000000157576812ULL, 0x008fe200078efcffULL, 0x0000007100747306ULL, 0x000fe20000209400ULL,
0x0000008a008a7245ULL, 0x002fce000020d400ULL, 0x0000007100737306ULL, 0x0002e20000205400ULL,
0x000000817f00720bULL, 0x010fce0003fbd000ULL, 0x000000b900b27306ULL, 0x000fe20000209400ULL,
0x0000007100717245ULL, 0x002fca000020d400ULL, 0x000000018a8a5812ULL, 0x000fe400078efcffULL,
0x000000b900af7306ULL, 0x0003220000205400ULL, 0x000000737400720bULL, 0x008fe20003f1d000ULL,
0x000000361c1ca231ULL, 0x084fe400003400ffULL, 0x000000361e1ea231ULL, 0x000fe400003400ffULL,
0x000000371d1da231ULL, 0x080fe400003400ffULL, 0x0000009300947306ULL, 0x000fe20000209400ULL,
0x000000b900b97245ULL, 0x002fe2000020d400ULL, 0x000000371f1fa231ULL, 0x000fc800003400ffULL,
0x0000000171710812ULL, 0x000fe400078efcffULL, 0x0000009300927306ULL, 0x0002a20000205400ULL,
0x000000afb200720bULL, 0x010fce0003f7d000ULL, 0x00000079007d7306ULL, 0x000fe20000209400ULL,
0x0000009300937245ULL, 0x002fca000020d400ULL, 0x00000001b9b93812ULL, 0x000fe400078efcffULL,
0x0000007900827306ULL, 0x0002e20000205400ULL, 0x000000929400720bULL, 0x004fe40003f9d000ULL,
0x000000b59a94723eULL, 0x000fca00000010ffULL, 0x0000006b006e7306ULL, 0x000fe20000209400ULL,
0x0000007900797245ULL, 0x002fe2000020d400ULL, 0x00000094185c723cULL, 0x000fe8000004185cULL,
0x0000000193934812ULL, 0x000fe400078efcffULL, 0x0000006b006d7306ULL, 0x0002a20000205400ULL,
0x000000827d00720bULL, 0x008fce0003fbd000ULL, 0x000000ab00ac7306ULL, 0x000fe20000209400ULL,
0x0000006b006b7245ULL, 0x002fca000020d400ULL, 0x0000000179795812ULL, 0x000fe400078efcffULL,
0x000000ab00a67306ULL, 0x0002e20000205400ULL, 0x0000006d6e00720bULL, 0x004fe40003f9d000ULL,
0x00000066906d723eULL, 0x000fca00000010ffULL, 0x000000ae007f7306ULL, 0x000fe20000209400ULL,
0x000000c2a0ab723eULL, 0x002fe200000010ffULL, 0x0000006c1820723cULL, 0x040fe80000041820ULL,
0x000000016b6b4812ULL, 0x000fe400078efcffULL, 0x000000ae00807306ULL, 0x0002a20000205400ULL,
0x000000a6ac00720bULL, 0x008fe20003f7d000ULL, 0x000000aa1804723cULL, 0x000f6c0000041804ULL,
0x000000a100967306ULL, 0x000fe20000209400ULL, 0x000000ae00ae7245ULL, 0x002fca000020d400ULL,
0x000000017c7c3812ULL, 0x000fe400078efcffULL, 0x000000a100977306ULL, 0x0002e20000205400ULL,
0x000000807f00720bULL, 0x004fce0003f1d000ULL, 0x0000004c007b7306ULL, 0x000fe20000009400ULL,
0x000000a100a17245ULL, 0x002fca000020d400ULL, 0x00000001aeae0812ULL, 0x000fe400078efcffULL,
0x0000004c007e7306ULL, 0x000e620000005400ULL, 0x000000979600720bULL, 0x008fce0003fdd000ULL,
0x0000004e00777306ULL, 0x000fec0000009400ULL, 0x00000001a1a16812ULL, 0x000fe400078efcffULL,
0x0000004e00767306ULL, 0x000ea20000005400ULL, 0x0000007e7b00720bULL, 0x002fe40003f5d000ULL,
0x00000018ff7b7819ULL, 0x000fc400000114b0ULL, 0x00000070b4b0723eULL, 0x000fc600000010ffULL,
0x0000004d00887306ULL, 0x000fe80000009400ULL, 0x000000b01858723cULL, 0x000f680000041858ULL,
0x0000004d00837306ULL, 0x000e620000005400ULL, 0x000000767700720bULL, 0x004fce0003fbd000ULL,
0x0000006100677306ULL, 0x000ff00000209400ULL, 0x0000006100687306ULL, 0x0004e20000205400ULL,
0x000000838800720bULL, 0x002fce0003f7d000ULL, 0x000000b300817306ULL, 0x000fe20000209400ULL,
0x0000006100617245ULL, 0x004fce000020d400ULL, 0x000000b300827306ULL, 0x0002a20000205400ULL,
0x000000686700720bULL, 0x008fce0003f9d000ULL, 0x0000004f006a7306ULL, 0x000fe20000009400ULL,
0x000000b300b37245ULL, 0x002fca000020d400ULL, 0x0000000161614812ULL, 0x000fe400078efcffULL,
0x0000004f00697306ULL, 0x000e620000005400ULL, 0x000000828100720bULL, 0x004fce0003f1d000ULL,
0x0000004c00517306ULL, 0x0004ec000000d400ULL, 0x00000001b3b30812ULL, 0x000fe400078efcffULL,
0x0000004d00507306ULL, 0x0008e2000000d400ULL, 0x000001004f4c7824ULL, 0x004fe200078e00ffULL,
0x000000696a00720bULL, 0x002fc80003fdd000ULL, 0x00000018ff747819ULL, 0x000fe4000001144cULL,
0x0000005200647306ULL, 0x000fe20000209400ULL, 0x000001004e4d7824ULL, 0x010fe200078e00ffULL,
0x0000000151512812ULL, 0x008fe400078efcffULL, 0x000000654a4c723eULL, 0x000fe400000010ffULL,
0x00000018ff707819ULL, 0x000fe2000001144dULL, 0x000000481848723cULL, 0x000b620000041814ULL,
0x0000005200637306ULL, 0x0002a20000205400ULL, 0x00000062b94d723eULL, 0x000fc400000010ffULL,
0x0000000150503812ULL, 0x000fc600078efcffULL, 0x000000cf8a14723eULL, 0x020fe400000010ffULL,
0x0000007b007d7306ULL, 0x000fe20000209400ULL, 0x0000004c1c18723cULL, 0x000b620000041810ULL,
0x0000005200527245ULL, 0x002fe4000020d400ULL, 0x0000007c7915723eULL, 0x000fc800000010ffULL,
0x0000007b00767306ULL, 0x0002e20000205400ULL, 0x000000636400720bULL, 0x004fe40003f5d000ULL,
0x000000141c14723cULL, 0x000b64000004180cULL, 0x00000060d810723eULL, 0x020fe400000010ffULL,
0x000000579c11723eULL, 0x000fe200000010ffULL, 0x000000a500737306ULL, 0x000fe20000209400ULL,
0x0000007b007b7245ULL, 0x002fe4000020d400ULL, 0x00000093710c723eULL, 0x000fc400000010ffULL,
0x0000007400717245ULL, 0x000fe2000020d400ULL, 0x000000101c10723cULL, 0x040b620000041808ULL,
0x0000000152522812ULL, 0x000fe200078efcffULL, 0x000000a500727306ULL, 0x0002a20000205400ULL,
0x000000767d00720bULL, 0x008fe40003f1d000ULL, 0x000000a16b0d723eULL, 0x000fe400000010ffULL,
0x00000051ae08723eULL, 0x020fe400000010ffULL, 0x00000050b309723eULL, 0x000fe200000010ffULL,
0x00000070006f7306ULL, 0x000fe20000209400ULL, 0x000000a500a57245ULL, 0x002fe2000020d400ULL,
0x0000000c1c0c723cULL, 0x000b680000041804ULL, 0x000000017b7b0812ULL, 0x000fc400078efcffULL,
0x00000070006e7306ULL, 0x0002e20000205400ULL, 0x000000727300720bULL, 0x004fe20003f7d000ULL,
0x000000081c08723cULL, 0x000b640000041858ULL, 0x0000007b6104723eULL, 0x020fc800000010ffULL,
0x0000004e00477306ULL, 0x000522000000d400ULL, 0x0000007000707245ULL, 0x002fca000020d400ULL,
0x00000001a5a53812ULL, 0x000fe400078efcffULL, 0x0000004f00467306ULL, 0x000322000000d400ULL,
0x000100004e4e7824ULL, 0x004fe200078e00ffULL, 0x0000006e6f00720bULL, 0x008fe40003f9d000ULL,
0x000000a55205723eULL, 0x000fe400000010ffULL, 0x00000018ff4e7819ULL, 0x000fe4000001144eULL,
0x0000007400697306ULL, 0x000fe20000209400ULL, 0x000100004f4f7824ULL, 0x002fe200078e00ffULL,
0x0000000147475812ULL, 0x010fe200078efcffULL, 0x000000041c04723cULL, 0x000b66000004185cULL,
0x00000018ff4f7819ULL, 0x000fc4000001144fULL, 0x0000007400667306ULL, 0x000e620000205400ULL,
0x0000000170704812ULL, 0x000fe400078efcffULL, 0x0000000146466812ULL, 0x000fe400078efcffULL,
0x000000477070723eULL, 0x000fc600000010ffULL, 0x0000002600557306ULL, 0x000ff00000209400ULL,
0x0000002600567306ULL, 0x0004e20000205400ULL, 0x000000666900720bULL, 0x002fce0003f5d000ULL,
0x0000002700537306ULL, 0x000fe20000209400ULL, 0x0000002600267245ULL, 0x004fca000020d400ULL,
0x0000000171712812ULL, 0x000fe400078efcffULL, 0x0000002700547306ULL, 0x0002a20000205400ULL,
0x000000565500720bULL, 0x008fe40003f1d000ULL, 0x000000467171723eULL, 0x000fe400000010ffULL,
0x0000002700467245ULL, 0x000fc6000020d400ULL, 0x0000004e00637306ULL, 0x000fe20000209400ULL,
0x0000004f00277245ULL, 0x002fe2000020d400ULL, 0x000000701c20723cULL, 0x000b680000041820ULL,
0x0000000126260812ULL, 0x000fe400078efcffULL, 0x0000004e00627306ULL, 0x0002e20000205400ULL,
0x000000545300720bULL, 0x004fce0003f7d000ULL, 0x0000004f004c7306ULL, 0x000fe20000209400ULL,
0x0000004e004e7245ULL, 0x002fca000020d400ULL, 0x0000000146463812ULL, 0x000fe400078efcffULL,
0x0000004f004d7306ULL, 0x000e620000205400ULL, 0x000000626300720bULL, 0x008fda0003f9d000ULL,
0x000000014e4e4812ULL, 0x000fe400078efcffULL, 0x0000004d4c00720bULL, 0x002fe40003fbd000ULL,
0x0000004e2626723eULL, 0x000fd600000010ffULL, 0x0000000127275812ULL, 0x000fc800078efcffULL,
0x000000274627723eULL, 0x000fce00000010ffULL, 0x000000261c1c723cULL, 0x000b620000041848ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff267f8cULL, 0x020e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000528007c0cULL, 0x000fe2000bf03070ULL, 0x01069000ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff487224ULL, 0x002fe200078e0027ULL, 0x000000022f4d7810ULL, 0x000fd40007ffe0ffULL,
0x0000c10000000947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fc40000015200ULL,
0x0106bc00ff2c7984ULL, 0x000e640000000800ULL, 0x800000002cff7812ULL, 0x002fe40007804848ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff497224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000467805ULL, 0x000fcc0000015200ULL, 0x0000004626467210ULL, 0x000fca0007f1e1ffULL,
0x0000000147477824ULL, 0x000fe200000e0e27ULL, 0x003d09004600780cULL, 0x000fc80003f06070ULL,
0x000000ff4700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404600780cULL, 0x000fc80003f06070ULL, 0x000000ff4700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff2c7819ULL, 0x000fc80000011447ULL,
0x000000462c2c7211ULL, 0x000fca00078110ffULL, 0x000000ffff467224ULL, 0x000fca00000e0647ULL,
0x000000022c2c7819ULL, 0x000fc80000001246ULL, 0x0000002c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000149497810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106bc00ff2c7984ULL, 0x000e640000000800ULL,
0x800000002cff7812ULL, 0x002fe40007804848ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000046000009947ULL, 0x000fea0003800000ULL, 0x000000012b267824ULL, 0x000fe200078e0238ULL,
0x0000000238477810ULL, 0x040fe20007ffe0ffULL, 0x000000a004057891ULL, 0x000fe2000f8e403fULL,
0x0000000438487810ULL, 0x000fe20007ffe0ffULL, 0x0000000126277824ULL, 0x000fe200078e0202ULL,
0x0000000638517810ULL, 0x000fe20007ffe0ffULL, 0x00000010264e7824ULL, 0x000fc400078e00ffULL,
0x000000012b2c7824ULL, 0x040fe400078e0247ULL, 0x000000012b497824ULL, 0x000fe200078e0248ULL,
0xfffffff04e4e7812ULL, 0x000fe200078ee227ULL, 0x000000012c467824ULL, 0x040fe200078e0202ULL,
0x0000002003277811ULL, 0x000fe200078e30ffULL, 0x000000102c4f7824ULL, 0x000fe200078e00ffULL,
0x0000e0004e4e7811ULL, 0x000fe200078e20ffULL, 0x0000001049507824ULL, 0x000fe400078e00ffULL,
0x00000001264c7824ULL, 0x100fe200078e0227ULL, 0xfffffff04f4f7812ULL, 0x000fe200078ee246ULL,
0x0000000149467824ULL, 0x040fe200078e0202ULL, 0x0000000528267c17ULL, 0x000fe2000f800000ULL,
0x000000012c4b7824ULL, 0x100fe200078e0227ULL, 0x000000254c4c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000149497824ULL, 0x000fe200078e0227ULL, 0x8000000526267c10ULL, 0x000fc4000fffe0ffULL,
0xfffffff050507812ULL, 0x000fe200078ee246ULL, 0x000000012b467824ULL, 0x040fe200078e0251ULL,
0x000000262b267217ULL, 0x000fe40007800000ULL, 0x000000254b4b7210ULL, 0x080fe20007f9e0ffULL,
0x00000001464a7824ULL, 0x040fe200078e0227ULL, 0x0000002549497210ULL, 0x080fe20007f7e0ffULL,
0x00000001464d7824ULL, 0x040fe200078e0202ULL, 0x0000e0004f4f7811ULL, 0x000fe200078e20ffULL,
0x0000001046527824ULL, 0x000fe200078e00ffULL, 0x000000254a257210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff277224ULL, 0x000fe200000e06ffULL, 0x00005e004c467a11ULL, 0x000fe200078040ffULL,
0x00000001262c7824ULL, 0x000fe200078e0a2bULL, 0xfffffff052527812ULL, 0x000fe200078ee24dULL,
0x000000ffff267224ULL, 0x000fe200020e06ffULL, 0x00005f004c4c7a11ULL, 0x000fe200000f4427ULL,
0x000000ffff277224ULL, 0x000fe200018e06ffULL, 0x00005e004b4a7a11ULL, 0x000fc400078c40ffULL,
0x0000002c4700720cULL, 0x080fe40003f06070ULL, 0x000000f0304d7812ULL, 0x000fe400078ec0ffULL,
0x00005e0049477a11ULL, 0x000fe400078a40ffULL, 0x0000002c3800720cULL, 0x080fe40003f86070ULL,
0x00005f004b4b7a11ULL, 0x000fe400030f4426ULL, 0x0000004d46267210ULL, 0x000fe20007fde0ffULL,
0x000000ffff467224ULL, 0x000fe200010e06ffULL, 0x0000002c4800720cULL, 0x000fc40003f66070ULL,
0x00005f0049497a11ULL, 0x000fe200028f4427ULL, 0x000000ffff277224ULL, 0x000fe200030e064cULL,
0x00005e0025487a11ULL, 0x000fe400078a40ffULL, 0x0000002c5100720cULL, 0x000fe40003f46070ULL,
0x00005f0025257a11ULL, 0x000fe200028f4446ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000264e7faeULL, 0x0003e2000e101c46ULL, 0x0000004d4a467210ULL, 0x000fe40007fbe0ffULL,
0x0000e00050507811ULL, 0x000fc400078e20ffULL, 0x0000e00052527811ULL, 0x000fe400078e20ffULL,
0x0000004d47267210ULL, 0x082fe20007f9e0ffULL, 0x000000ffff477224ULL, 0x000fe200028e064bULL,
0x0000004d48487210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff277224ULL, 0x000fe200020e0649ULL,
0x00000000464f7faeULL, 0x0003e2000c101c46ULL, 0x000000ffff497224ULL, 0x000fc600028e0625ULL,
0x0000000026507faeULL, 0x0003e8000d901c46ULL, 0x0000000048527faeULL, 0x0003e2000d101c46ULL,
0x0000039000007947ULL, 0x000fea0003800000ULL, 0x000000012b267824ULL, 0x000fe200078e0238ULL,
0x0000002003277811ULL, 0x000fe400078e30ffULL, 0x000000f0304d7812ULL, 0x000fe200078ec0ffULL,
0x00000001262c7824ULL, 0x040fe200078e0202ULL, 0x0000000226467810ULL, 0x040fe20007ffe0ffULL,
0x00000010264e7824ULL, 0x040fe200078e00ffULL, 0x0000000626487810ULL, 0x000fc60007ffe0ffULL,
0x0000000146477824ULL, 0x000fe200078e0202ULL, 0xfffffff04e4e7812ULL, 0x000fe200078ee22cULL,
0x00000010464f7824ULL, 0x000fe400078e00ffULL, 0x00000001262c7824ULL, 0x000fe200078e0227ULL,
0x0000e0004e4e7811ULL, 0x000fe200078e20ffULL, 0x0000000127497824ULL, 0x000fe200078e0246ULL,
0xfffffff04f4f7812ULL, 0x000fe200078ee247ULL, 0x00000001274b7824ULL, 0x000fe200078e0248ULL,
0x0000000426477810ULL, 0x000fe20007ffe0ffULL, 0x0000001048517824ULL, 0x000fe200078e00ffULL,
0x000000252c267210ULL, 0x000fc40007f7e0ffULL, 0x0000002549497210ULL, 0x080fe20007f1e0ffULL,
0x00000001272c7824ULL, 0x000fe200078e0247ULL, 0x00005e00264a7a11ULL, 0x000fe200078840ffULL,
0x0000000147467824ULL, 0x100fe200078e0202ULL, 0x0000e0004f4f7811ULL, 0x000fe200078e20ffULL,
0x0000001047507824ULL, 0x000fe200078e00ffULL, 0x000000252c2c7210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff277224ULL, 0x000fe200018e06ffULL, 0x000000254b257210ULL, 0x000fe20007f7e0ffULL,
0x0000000148477824ULL, 0x000fe200078e0202ULL, 0xfffffff050507812ULL, 0x000fe200078ee246ULL,
0x000000ffff4b7224ULL, 0x000fe200000e06ffULL, 0x00005f00264c7a11ULL, 0x000fe200020f4427ULL,
0x000000ffff267224ULL, 0x000fe200018e06ffULL, 0xfffffff051517812ULL, 0x000fe200078ee247ULL,
0x000000ffff277224ULL, 0x000fe200010e06ffULL, 0x00005e0049477a11ULL, 0x000fc400078040ffULL,
0x00005e0025487a11ULL, 0x000fe400078640ffULL, 0x00005e002c467a11ULL, 0x000fe400078440ffULL,
0x0000004d4a4a7210ULL, 0x000fe40007f9e0ffULL, 0x00005f0049497a11ULL, 0x000fe400000f444bULL,
0x00005f0025257a11ULL, 0x000fe200018f4426ULL, 0x000000ffff4b7224ULL, 0x000fe200020e064cULL,
0x00005f002c2c7a11ULL, 0x000fc400010f4427ULL, 0x0000004d47267210ULL, 0x080fe40007f1e0ffULL,
0x0000004d46467210ULL, 0x080fe20007f5e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000004a4e7faeULL, 0x0003e2000b901c46ULL, 0x0000004d48487210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff277224ULL, 0x000fe200000e0649ULL, 0x0000e00050507811ULL, 0x000fe200078e20ffULL,
0x000000ffff477224ULL, 0x000fe200010e062cULL, 0x0000e00051517811ULL, 0x000fe200078e20ffULL,
0x000000ffff497224ULL, 0x000fe200018e0625ULL, 0x00000000264f7faeULL, 0x0003e8000b901c46ULL,
0x0000000046507faeULL, 0x0003e8000b901c46ULL, 0x0000000048517faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x000000032f267810ULL, 0x002fe20007ffe0ffULL,
0xffffffffff2c7424ULL, 0x000fc600078e00ffULL, 0x000000292600720cULL, 0x000fda0003f06070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000000012e267824ULL, 0x000fe400078e0226ULL,
0x00000004ff277424ULL, 0x000fc800078e00ffULL, 0x0000600026267625ULL, 0x000fca00078e0027ULL,
0x00000006262c7981ULL, 0x000324000c1e1900ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff467f8cULL, 0x000ea2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010648002b4a7f8cULL, 0x000664000c80043fULL, 0x0000000000267805ULL, 0x002fc40000015200ULL,
0x01064c002b257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe4000780484bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff4c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000487805ULL, 0x000fcc0000015200ULL, 0x0000004826487210ULL, 0x000fca0007f1e1ffULL,
0x0000000149497824ULL, 0x000fe200000e0e27ULL, 0x003d09004800780cULL, 0x000fc80003f06070ULL,
0x000000ff4900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404800780cULL, 0x000fc80003f06070ULL, 0x000000ff4900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff257819ULL, 0x000fc80000011449ULL,
0x0000004825257211ULL, 0x000fca00078110ffULL, 0x000000ffff487224ULL, 0x000fca00000e0649ULL,
0x0000000225257819ULL, 0x000fc80000001248ULL, 0x000000250000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000014c4c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01064c002b257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe4000780484bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0101000031257984ULL, 0x000e680000000800ULL, 0x0103000031267984ULL, 0x0006a20000000800ULL,
0x000000242500720bULL, 0x002fe20003f1d000ULL, 0x000128327f007947ULL, 0x000fd8000b800000ULL,
0x0000000000277806ULL, 0x008fc800000e0100ULL, 0x0000ffff27ff7812ULL, 0x000fe2000780c0ffULL,
0x000004a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff487424ULL, 0x000fc400078e00ffULL,
0x000000ffff5c7224ULL, 0x000fd200078e0024ULL, 0x0000046000008947ULL, 0x000fea0003800000ULL,
0x000000020000780cULL, 0x000fe40003f05270ULL, 0x000000242500720bULL, 0x000fe20003f54000ULL,
0x000127f27f007947ULL, 0x000fd8000b800000ULL, 0x00000000004b7806ULL, 0x000fc400010e0100ULL,
0x0000002524488209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe80003800000ULL,
0x0105004831008388ULL, 0x0003e40000000800ULL, 0x000099104b487816ULL, 0x002fc800000000ffULL,
0x000000ff4800720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000002524487209ULL, 0x000fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff4bff7812ULL, 0x000fc6000780c0ffULL, 0x8000004824487221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b48487820ULL, 0x000fc80000410000ULL, 0x00000048004c7308ULL, 0x000e640000000800ULL,
0x0000004c2d2d7220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff487819ULL, 0x000fe20000011602ULL, 0x000127327f007947ULL, 0x000fea000b800000ULL,
0x00001f484c487589ULL, 0x0002e400000e0000ULL, 0x0000004818187220ULL, 0x088fe20000410000ULL,
0x0000004819197220ULL, 0x080fe20000410000ULL, 0x0000004814147220ULL, 0x080fe20000410000ULL,
0x0000004815157220ULL, 0x080fe20000410000ULL, 0x0000004810107220ULL, 0x080fe20000410000ULL,
0x0000004811117220ULL, 0x080fe20000410000ULL, 0x000000480c0c7220ULL, 0x080fe20000410000ULL,
0x000000480d0d7220ULL, 0x080fe20000410000ULL, 0x0000004808087220ULL, 0x080fe20000410000ULL,
0x0000004809097220ULL, 0x080fe20000410000ULL, 0x0000004804047220ULL, 0x080fe20000410000ULL,
0x0000004805057220ULL, 0x080fe20000410000ULL, 0x0000004820207220ULL, 0x080fe20000410000ULL,
0x0000004821217220ULL, 0x080fe20000410000ULL, 0x000000481c1c7220ULL, 0x080fe20000410000ULL,
0x000000481d1d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff004bff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000802487811ULL, 0x000fe200078ff0ffULL, 0x000126327f007947ULL, 0x000fea000b800000ULL,
0x00001f484c487589ULL, 0x00066400000e0000ULL, 0x000000481a1a7220ULL, 0x082fe20000410000ULL,
0x000000481b1b7220ULL, 0x080fe20000410000ULL, 0x0000004816167220ULL, 0x080fe20000410000ULL,
0x0000004817177220ULL, 0x080fe20000410000ULL, 0x0000004812127220ULL, 0x080fe20000410000ULL,
0x0000004813137220ULL, 0x080fe20000410000ULL, 0x000000480e0e7220ULL, 0x080fe20000410000ULL,
0x000000480f0f7220ULL, 0x080fe20000410000ULL, 0x000000480a0a7220ULL, 0x080fe20000410000ULL,
0x000000480b0b7220ULL, 0x080fe20000410000ULL, 0x0000004806067220ULL, 0x080fe20000410000ULL,
0x0000004807077220ULL, 0x080fe20000410000ULL, 0x0000004822227220ULL, 0x080fe20000410000ULL,
0x0000004823237220ULL, 0x080fe20000410000ULL, 0x000000481e1e7220ULL, 0x080fe20000410000ULL,
0x000000481f1f7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000ffff4bff7812ULL, 0x000fe20007800827ULL, 0x00000001ff487424ULL, 0x000fe200078e00ffULL,
0x0000002524247209ULL, 0x000fca0007810000ULL, 0x000000ffff5c7224ULL, 0x000fcc00078e0024ULL,
0x8000002425250221ULL, 0x100fe20000010000ULL, 0x000000ffff5c0224ULL, 0x000fe200078e0024ULL,
0x00007610ff480816ULL, 0x000fe40000000048ULL, 0x3fb8aa3b25250820ULL, 0x000fc80000410000ULL,
0x0000002500350308ULL, 0x000e640000000800ULL, 0x0000003526260220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002d262d7221ULL, 0x004fc20000010000ULL,
0x0000000000247805ULL, 0x000fcc0000015200ULL, 0x0106ac00ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe40007804845ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624497210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09004900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff267819ULL, 0x000fc80000011427ULL, 0x0000004926267211ULL, 0x000fca00078110ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x0000000226267819ULL, 0x000fc80000001227ULL,
0x000000260000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000014a4a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106ac00ff267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fe40007804845ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991048247816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff2400720cULL, 0x000fda0003f45270ULL,
0x0000012000002947ULL, 0x000fea0003800000ULL, 0x00000035ff24723eULL, 0x000fe400000010ffULL,
0x00000002ff257819ULL, 0x000fe40000011602ULL, 0x0000541024247816ULL, 0x000fe20000000024ULL,
0x000122027f007947ULL, 0x000fea000b800000ULL, 0x00001f2524367589ULL, 0x0002a400000e0000ULL,
0x0000000825377810ULL, 0x000fe20007ffe0ffULL, 0x000122327f007947ULL, 0x000fea000b800000ULL,
0x00001f3724377589ULL, 0x0002e400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001025497810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff4a7224ULL, 0x000fe200078e0024ULL,
0x0000ece000487802ULL, 0x000fc40000000f00ULL, 0x00012aa000007944ULL, 0x01efea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001825497810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4a7224ULL, 0x004fe200078e0024ULL, 0x0000ed3000487802ULL, 0x000fc40000000f00ULL,
0x00012a5000007944ULL, 0x01afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000003948783bULL, 0x004ea80000004200ULL,
0x000000003a4c783bULL, 0x008ee80000004200ULL, 0x000000003c50783bULL, 0x000fe80000004200ULL,
0x000000003b24783bULL, 0x002e620000004200ULL, 0x00000048009e7306ULL, 0x004fe20000009400ULL,
0x00000018ffc07819ULL, 0x000fe20000011448ULL, 0x0000010048a37824ULL, 0x000fe200078e00ffULL,
0x00000018ffae7819ULL, 0x000fe20000011449ULL, 0x000001004bbb7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8c7819ULL, 0x000fe2000001144bULL, 0x0001000049ce7824ULL, 0x000fe200078e00ffULL,
0x00000018ffc87819ULL, 0x000fe200000114a3ULL, 0x0000004800c17306ULL, 0x000ea20000005400ULL,
0x00000018ffbb7819ULL, 0x000fe200000114bbULL, 0x000100004bbf7824ULL, 0x000fe200078e00ffULL,
0x00000018ffce7819ULL, 0x000fe200000114ceULL, 0x000100004abc7824ULL, 0x040fe200078e00ffULL,
0x00000018ffa07819ULL, 0x000fe2000001144aULL, 0x000001004daa7824ULL, 0x008fe200078e00ffULL,
0x00000018ffbf7819ULL, 0x000fe200000114bfULL, 0x0000004800857306ULL, 0x000662000000d400ULL,
0x00000018ffbc7819ULL, 0x000fe200000114bcULL, 0x0000010049cf7824ULL, 0x000fe200078e00ffULL,
0x00000018ffaa7819ULL, 0x000fe200000114aaULL, 0x000100004dad7824ULL, 0x000fe200078e00ffULL,
0x00000018ff987819ULL, 0x000fe2000001144cULL, 0x000001004aba7824ULL, 0x000fe200078e00ffULL,
0x00000018ffcf7819ULL, 0x000fe200000114cfULL, 0x0000004900cd7306ULL, 0x000fe20000009400ULL,
0x0001000048487824ULL, 0x008fe200078e00ffULL, 0x000000c19e00720bULL, 0x004fe20003f7d000ULL,
0x000001004cab7824ULL, 0x040fe200078e00ffULL, 0x00000018ffad7819ULL, 0x000fe200000114adULL,
0x000100004cac7824ULL, 0x000fe200078e00ffULL, 0x00000018ffd47819ULL, 0x000fe20000011448ULL,
0x000100004f487824ULL, 0x000fe200078e00ffULL, 0x0000004900c47306ULL, 0x000ea20000005400ULL,
0x00000018ffba7819ULL, 0x000fe200000114baULL, 0x00000100249e7824ULL, 0x002fe200078e00ffULL,
0x00000018ff967819ULL, 0x000fc4000001144dULL, 0x00000018ffab7819ULL, 0x000fe400000114abULL,
0x0000000185853812ULL, 0x000fe200078efcffULL, 0x000000d400d57306ULL, 0x000fe20000209400ULL,
0x00000018ff457819ULL, 0x000fe40000011452ULL, 0x00000018ff807819ULL, 0x000fe4000001144fULL,
0x00000018ffac7819ULL, 0x000fe400000114acULL, 0x00000018ff487819ULL, 0x000fe20000011448ULL,
0x000000d400d67306ULL, 0x000e620000205400ULL, 0x000000c4cd00720bULL, 0x004fc40003f9d000ULL,
0x000000d400c47245ULL, 0x000fe4000020d400ULL, 0x00000018ff8a7819ULL, 0x000fe40000011424ULL,
0x00000018ff7a7819ULL, 0x000fe20000011425ULL, 0x00000049007b7306ULL, 0x0004e2000000d400ULL,
0x00000018ff737819ULL, 0x000fe40000011426ULL, 0x00000018ff837819ULL, 0x000fe4000001144eULL,
0x00000018ff587819ULL, 0x000fc40000011427ULL, 0x00000018ff9e7819ULL, 0x000fe2000001149eULL,
0x000000bb00d07306ULL, 0x000fe20000209400ULL, 0x000000d6d500720bULL, 0x002fe20003fbd000ULL,
0x0000010025d57824ULL, 0x000fe200078e00ffULL, 0x00000018ff6b7819ULL, 0x000fe20000011450ULL,
0x000100004e497824ULL, 0x004fe200078e00ffULL, 0x00000018ff5d7819ULL, 0x000fe20000011453ULL,
0x0000010026d67824ULL, 0x000fe200078e00ffULL, 0x00000018ff667819ULL, 0x000fe20000011451ULL,
0x000000bb00db7306ULL, 0x0002a20000205400ULL, 0x000000017b7b4812ULL, 0x008fc400078efcffULL,
0x00000018ff497819ULL, 0x000fe40000011449ULL, 0x00000018ffd67819ULL, 0x000fe400000114d6ULL,
0x00000001c4c45812ULL, 0x000fe200078efcffULL, 0x000000ae00b97306ULL, 0x000fe20000209400ULL,
0x000000bb00bb7245ULL, 0x002fce000020d400ULL, 0x000000ae00b87306ULL, 0x0002e20000205400ULL,
0x000000dbd000720bULL, 0x004fce0003f9d000ULL, 0x000000ce00d97306ULL, 0x000fe20000209400ULL,
0x000000ae00ae7245ULL, 0x002fca000020d400ULL, 0x00000001bbbb4812ULL, 0x000fe400078efcffULL,
0x000000ce00da7306ULL, 0x0002a20000205400ULL, 0x000000b8b900720bULL, 0x008fe20003fbd000ULL,
0x0000010051b97824ULL, 0x000fca00078e00ffULL, 0x00000018ffb97819ULL, 0x000fe200000114b9ULL,
0x000000bf00c67306ULL, 0x000fe20000209400ULL, 0x000000ce00ce7245ULL, 0x002fca000020d400ULL,
0x00000001aeae5812ULL, 0x000fe400078efcffULL, 0x000000bf00c77306ULL, 0x0002e20000205400ULL,
0x000000dad900720bULL, 0x004fce0003f7d000ULL, 0x000000c000cb7306ULL, 0x000fe20000209400ULL,
0x000000bf00bf7245ULL, 0x002fca000020d400ULL, 0x00000001cece3812ULL, 0x000fe400078efcffULL,
0x000000c000cc7306ULL, 0x0002a20000205400ULL, 0x000000c7c600720bULL, 0x008fce0003f9d000ULL,
0x000000c800c97306ULL, 0x000fe20000209400ULL, 0x000000c000c07245ULL, 0x002fca000020d400ULL,
0x00000001bfbf4812ULL, 0x000fe400078efcffULL, 0x000000c800d37306ULL, 0x000e620000205400ULL,
0x000000cccb00720bULL, 0x004fce0003f1d000ULL, 0x000000bc00c37306ULL, 0x000fec0000209400ULL,
0x00000001c0c00812ULL, 0x000fe400078efcffULL, 0x000000bc00ca7306ULL, 0x0004e20000205400ULL,
0x000000d3c900720bULL, 0x002fe20003fdd000ULL, 0x0001000024d37824ULL, 0x000fca00078e00ffULL,
0x00000018ffcc7819ULL, 0x000fe200000114d3ULL, 0x0000004b00a87306ULL, 0x000fe20000009400ULL,
0x000000bc00bc7245ULL, 0x004fce000020d400ULL, 0x0000004b00a97306ULL, 0x000e620000005400ULL,
0x000000cac300720bULL, 0x008fce0003fbd000ULL, 0x000000aa00c27306ULL, 0x000fec0000209400ULL,
0x00000001bcbc5812ULL, 0x000fe400078efcffULL, 0x000000aa00c57306ULL, 0x0004e20000205400ULL,
0x000000a9a800720bULL, 0x002fe40003f7d000ULL, 0x00000018ffa87819ULL, 0x000fca00000114d5ULL,
0x0000004a00b17306ULL, 0x000fe20000009400ULL, 0x000000aa00aa7245ULL, 0x004fce000020d400ULL,
0x0000004a00b27306ULL, 0x000e620000005400ULL, 0x000000c5c200720bULL, 0x008fce0003f9d000ULL,
0x0000008c008d7306ULL, 0x000fec0000209400ULL, 0x00000001aaaa4812ULL, 0x000fe400078efcffULL,
0x0000008c009f7306ULL, 0x000ea20000205400ULL, 0x000000b2b100720bULL, 0x002fe20003f1d000ULL,
0x0001000050b27824ULL, 0x000fca00078e00ffULL, 0x00000018ffb27819ULL, 0x000fe200000114b2ULL,
0x000000cf00d77306ULL, 0x000ff00000209400ULL, 0x000000cf00d87306ULL, 0x0003e20000205400ULL,
0x0000009f8d00720bULL, 0x004fe20003fbd000ULL, 0x00010000528d7824ULL, 0x000fc400078e00ffULL,
0x00000100539f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff8d7819ULL, 0x000fe2000001148dULL,
0x0000004b00767306ULL, 0x000ea2000000d400ULL, 0x000000cf00cf7245ULL, 0x002fe4000020d400ULL,
0x00000018ff9f7819ULL, 0x000fca000001149fULL, 0x0000004d00a17306ULL, 0x000ff00000009400ULL,
0x0000004d00a27306ULL, 0x000e620000005400ULL, 0x0000000176763812ULL, 0x004fce00078efcffULL,
0x000000ad00b77306ULL, 0x000ff00000209400ULL, 0x000000ad00b67306ULL, 0x0004e20000205400ULL,
0x000000a2a100720bULL, 0x002fe40003f7d000ULL, 0x000000a000a17245ULL, 0x000fca000020d400ULL,
0x0000004a00797306ULL, 0x0002e2000000d400ULL, 0x000000ad00ad7245ULL, 0x004fce000020d400ULL,
0x0000004c00a57306ULL, 0x000fe20000009400ULL, 0x000001004f4a7824ULL, 0x002fe200078e00ffULL,
0x000000b6b700720bULL, 0x008fc80003f9d000ULL, 0x00000018ff4a7819ULL, 0x000fe4000001144aULL,
0x0000004c00a67306ULL, 0x000fe20000005400ULL, 0x0000000179790812ULL, 0x000fcc00078efcffULL,
0x00000001adad4812ULL, 0x000fe200078efcffULL, 0x0000004c00577306ULL, 0x0003f0000000d400ULL,
0x000000a000a77306ULL, 0x000fe20000209400ULL, 0x000000c8004c7245ULL, 0x002fe2000020d400ULL,
0x0001000027c87824ULL, 0x000fc600078e00ffULL, 0x000000014c4c6812ULL, 0x000fe400078efcffULL,
0x000000d8d700720bULL, 0x000fe20003fdd000ULL, 0x000000a000a47306ULL, 0x0002a20000205400ULL,
0x00000018ffc87819ULL, 0x000fe400000114c8ULL, 0x000000854c4c723eULL, 0x000fca00000010ffULL,
0x00000098009d7306ULL, 0x000fe20000209400ULL, 0x0000010052a07824ULL, 0x002fc600078e00ffULL,
0x00000001cfcf6812ULL, 0x000fe400078efcffULL, 0x00000018ffa07819ULL, 0x000fe400000114a0ULL,
0x00000098009c7306ULL, 0x0003e20000205400ULL, 0x000000a4a700720bULL, 0x004fe20003f1d000ULL,
0x0000010050a77824ULL, 0x000fca00078e00ffULL, 0x00000018ffa77819ULL, 0x000fe200000114a7ULL,
0x000000ba00d17306ULL, 0x000fe20000209400ULL, 0x0000009800987245ULL, 0x002fca000020d400ULL,
0x00000001a1a10812ULL, 0x000fe400078efcffULL, 0x000000ba00d27306ULL, 0x0002b00000205400ULL,
0x0000004d00547306ULL, 0x0006e2000000d400ULL, 0x000000ba00ba7245ULL, 0x002fce000020d400ULL,
0x0000004f00957306ULL, 0x000fe20000009400ULL, 0x000000d2d100720bULL, 0x004fe20003fdd000ULL,
0x000001004e4d7824ULL, 0x008fca00078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe2000001144dULL,
0x0000004f00947306ULL, 0x000e620000005400ULL, 0x0000000154543812ULL, 0x000fca00078efcffULL,
0x00000001baba6812ULL, 0x000fe400078efcffULL, 0x0000009600977306ULL, 0x000fe20000209400ULL,
0x000000a6a500720bULL, 0x000fce0003fdd000ULL, 0x0000009600997306ULL, 0x0004e20000205400ULL,
0x000000949500720bULL, 0x002fe40003f9d000ULL, 0x0000004d00947245ULL, 0x000fc6000020d400ULL,
0x0000000157576812ULL, 0x000fe400078efcffULL, 0x0000005200727306ULL, 0x000fe20000009400ULL,
0x0000009600967245ULL, 0x004fce000020d400ULL, 0x00000052005b7306ULL, 0x000fe20000005400ULL,
0x000000999700720bULL, 0x008fce0003f7d000ULL, 0x00000052005e7306ULL, 0x0003ec000000d400ULL,
0x0000000196963812ULL, 0x000fe400078efcffULL, 0x000000ab00be7306ULL, 0x000fe20000209400ULL,
0x0000008c00527245ULL, 0x002fe2000020d400ULL, 0x00010000538c7824ULL, 0x000fe200078e00ffULL,
0x000000ad96ad723eULL, 0x000fc400000010ffULL, 0x0000000152525812ULL, 0x000fe400078efcffULL,
0x0000009c9d00720bULL, 0x000fe20003fbd000ULL, 0x000000ab00bd7306ULL, 0x0002a20000205400ULL,
0x00000018ff8c7819ULL, 0x000fce000001148cULL, 0x0000004a00a37306ULL, 0x000fe20000209400ULL,
0x000000ab00ab7245ULL, 0x002fc6000020d400ULL, 0x0000000198985812ULL, 0x000fc800078efcffULL,
0x0000004a00b47306ULL, 0x000e620000205400ULL, 0x000000bdbe00720bULL, 0x004fce0003f1d000ULL,
0x0000004f00597306ULL, 0x000eac000000d400ULL, 0x00000001abab0812ULL, 0x000fe400078efcffULL,
0x0000002400937306ULL, 0x000fe20000009400ULL, 0x000000b4a300720bULL, 0x002fce0003fbd000ULL,
0x0000002400927306ULL, 0x000e620000005400ULL, 0x0000000159594812ULL, 0x004fce00078efcffULL,
0x00000080008e7306ULL, 0x000ff00000209400ULL, 0x00000080008f7306ULL, 0x0004e20000205400ULL,
0x000000929300720bULL, 0x002fe40003f7d000ULL, 0x0000004a00927245ULL, 0x000fc8000020d400ULL,
0x0000000192925812ULL, 0x000fe200078efcffULL, 0x000000ac00af7306ULL, 0x000fe20000209400ULL,
0x0000008000807245ULL, 0x004fce000020d400ULL, 0x000000ac00b57306ULL, 0x0002a20000205400ULL,
0x0000008f8e00720bULL, 0x008fe40003f9d000ULL, 0x00000048008f7245ULL, 0x000fe4000020d400ULL,
0x00000049008e7245ULL, 0x000fc6000020d400ULL, 0x0000004e009a7306ULL, 0x000fe20000009400ULL,
0x000000ac00ac7245ULL, 0x002fca000020d400ULL, 0x0000000180804812ULL, 0x000fe400078efcffULL,
0x0000004e009b7306ULL, 0x000e620000005400ULL, 0x000000b5af00720bULL, 0x004fce0003f1d000ULL,
0x00000048004f7306ULL, 0x000fec0000209400ULL, 0x00000001acac0812ULL, 0x000fe400078efcffULL,
0x0000004800c97306ULL, 0x0004e20000205400ULL, 0x0000009b9a00720bULL, 0x002fe40003fdd000ULL,
0x000000ac98ac723eULL, 0x000fca00000010ffULL, 0x000000a800a97306ULL, 0x000fe20000209400ULL,
0x000000c4c048723eULL, 0x004fce00000010ffULL, 0x000000a800a47306ULL, 0x0002a20000205400ULL,
0x000000c94f00720bULL, 0x008fce0003fbd000ULL, 0x00000024006f7306ULL, 0x0006a2000000d400ULL,
0x000000a800a87245ULL, 0x002fca000020d400ULL, 0x000000018f8f5812ULL, 0x000fe400078efcffULL,
0x0000004d00b37306ULL, 0x000fe20000209400ULL, 0x0000010027247824ULL, 0x008fe200078e00ffULL,
0x000000a4a900720bULL, 0x004fe40003f9d000ULL, 0x0000008f808f723eULL, 0x000fe400000010ffULL,
0x00000018ff9a7819ULL, 0x000fe40000011424ULL, 0x0000004d00b07306ULL, 0x0002a20000205400ULL,
0x0000b0003e247811ULL, 0x000fc400078e20ffULL, 0x000000016f6f3812ULL, 0x000fc800078efcffULL,
0x00000001a8a84812ULL, 0x000fe200078efcffULL, 0x000000cc00b87306ULL, 0x000fe20000209400ULL,
0x0000007bcf4d723eULL, 0x002fce00000010ffULL, 0x000000cc00b17306ULL, 0x0002e20000205400ULL,
0x000000b0b300720bULL, 0x004fce0003f1d000ULL, 0x00000025008b7306ULL, 0x000fe20000009400ULL,
0x000000cc00cc7245ULL, 0x002fca000020d400ULL, 0x0000000194940812ULL, 0x000fe400078efcffULL,
0x0000002500817306ULL, 0x000fe20000005400ULL, 0x000000b1b800720bULL, 0x008fce0003fbd000ULL,
0x00000025006e7306ULL, 0x0003ec000000d400ULL, 0x00000001cccc5812ULL, 0x000fe400078efcffULL,
0x0000002600897306ULL, 0x000fe20000009400ULL, 0x0001000025257824ULL, 0x002fca00078e00ffULL,
0x00000018ffa27819ULL, 0x000fe40000011425ULL, 0x00000026007d7306ULL, 0x000e700000005400ULL,
0x0000002600687306ULL, 0x0004f0000000d400ULL, 0x0000007a00877306ULL, 0x000fe20000209400ULL,
0x0001000026267824ULL, 0x004fe200078e00ffULL, 0x0000007d8900720bULL, 0x002fc80003fbd000ULL,
0x00000018ff957819ULL, 0x000fe40000011426ULL, 0x0000007a00847306ULL, 0x0002ae0000205400ULL,
0x0000000168685812ULL, 0x008fe200078efcffULL, 0x0000002700887306ULL, 0x000fe20000009400ULL,
0x0000007a007a7245ULL, 0x002fce000020d400ULL, 0x00000027007e7306ULL, 0x000fe20000005400ULL,
0x000000848700720bULL, 0x004fce0003f9d000ULL, 0x0000002700697306ULL, 0x0003ec000000d400ULL,
0x000000017a7a4812ULL, 0x000fe400078efcffULL, 0x0000004e005a7306ULL, 0x000ea2000000d400ULL,
0x000000002424783bULL, 0x002e6e0000000200ULL, 0x0000008300907306ULL, 0x000ff00000209400ULL,
0x0000008300917306ULL, 0x0006e20000205400ULL, 0x000000015a5a6812ULL, 0x004fc800078efcffULL,
0x0000005a9494723eULL, 0x000fc600000010ffULL, 0x00000049004b7306ULL, 0x000fe20000209400ULL,
0x0000008300837245ULL, 0x008fce000020d400ULL, 0x00000049004e7306ULL, 0x0004e20000205400ULL,
0x000000919000720bULL, 0x000fce0003fdd000ULL, 0x0000009a00977306ULL, 0x000fe20000209400ULL,
0x000000362424a231ULL, 0x082fe200003400ffULL, 0x000000ceae49723eULL, 0x004fe200000010ffULL,
0x000000362626a231ULL, 0x000fe400003400ffULL, 0x000000372525a231ULL, 0x080fe200003400ffULL,
0x0000000183836812ULL, 0x000fe200078efcffULL, 0x000000372727a231ULL, 0x000fe200003400ffULL,
0x0000009a00997306ULL, 0x0002a20000205400ULL, 0x0000004e4b00720bULL, 0x008fca0003f1d000ULL,
0x0000004c2418723cULL, 0x000be40000041818ULL, 0x0000008a007f7306ULL, 0x000fe20000209400ULL,
0x0000009a009a7245ULL, 0x002fc8000020d400ULL, 0x00000076bb4d723eULL, 0x020fe400000010ffULL,
0x000000018e8e0812ULL, 0x000fe200078efcffULL, 0x0000008a00827306ULL, 0x0002e20000205400ULL,
0x000000999700720bULL, 0x004fe40003f9d000ULL, 0x00000079ba4c723eULL, 0x000fe400000010ffULL,
0x0000008e838e723eULL, 0x000fc600000010ffULL, 0x0000009e00c17306ULL, 0x000fe20000209400ULL,
0x0000008a008a7245ULL, 0x002fe2000020d400ULL, 0x0000004c244c723cULL, 0x040be80000041810ULL,
0x000000019a9a4812ULL, 0x000fe400078efcffULL, 0x0000009e00cb7306ULL, 0x0002a20000205400ULL,
0x000000827f00720bULL, 0x008fe20003fdd000ULL, 0x0000008e241c723cULL, 0x000fe2000004181cULL,
0x00000057ab10723eULL, 0x020fc400000010ffULL, 0x00000054aa11723eULL, 0x000fc600000010ffULL,
0x00000095004a7306ULL, 0x000fe20000209400ULL, 0x0000009e009e7245ULL, 0x002fca000020d400ULL,
0x000000018a8a6812ULL, 0x000fe400078efcffULL, 0x00000095004b7306ULL, 0x000e620000205400ULL,
0x000000cbc100720bULL, 0x004fe40003f1d000ULL, 0x0000007e8800720bULL, 0x000fca0003fdd000ULL,
0x0000007300757306ULL, 0x000fec0000209400ULL, 0x000000019e9e0812ULL, 0x000fe400078efcffULL,
0x0000007300747306ULL, 0x0004e20000205400ULL, 0x0000004b4a00720bULL, 0x002fe40003fbd000ULL,
0x000000818b00720bULL, 0x000fe20003f1d000ULL, 0x000000482448723cULL, 0x000b620000041814ULL,
0x0000000169696812ULL, 0x000fc400078efcffULL, 0x0000005b7200720bULL, 0x000fe20003fdd000ULL,
0x000000c800907306ULL, 0x000fe20000209400ULL, 0x0000007300737245ULL, 0x004fe4000020d400ULL,
0x0000b0003d147811ULL, 0x020fe400078e20ffULL, 0x0000005800727245ULL, 0x000fc6000020d400ULL,
0x000000c8007f7306ULL, 0x0002a20000205400ULL, 0x000000747500720bULL, 0x008fe20003f9d000ULL,
0x000000001414783bULL, 0x000ee20000000200ULL, 0x0000009500747245ULL, 0x000fe4000020d400ULL,
0x000000016e6e0812ULL, 0x000fe400078efcffULL, 0x0000000174745812ULL, 0x000fe200078efcffULL,
0x0000005000867306ULL, 0x000fe20000009400ULL, 0x000000c800c87245ULL, 0x002fe4000020d400ULL,
0x000000599295723eULL, 0x000fc400000010ffULL, 0x000000015e5e6812ULL, 0x000fe400078efcffULL,
0x0000000173734812ULL, 0x000fe200078efcffULL, 0x00000050007c7306ULL, 0x000e620000005400ULL,
0x0000007f9000720bULL, 0x004fe20003fbd000ULL, 0x000000942420723cULL, 0x000fec0000041820ULL,
0x0000005000627306ULL, 0x000eac000000d400ULL, 0x00000001c8c85812ULL, 0x000fc400078efcffULL,
0x000000a200a57306ULL, 0x000fe20000209400ULL, 0x0000007c8600720bULL, 0x002fce0003f1d000ULL,
0x000000a200507306ULL, 0x0002620000205400ULL, 0x000000361414a231ULL, 0x088fe400003400ffULL,
0x000000361616a231ULL, 0x000fc600003400ffULL, 0x0000000162620812ULL, 0x004fe200078efcffULL,
0x000000371515a231ULL, 0x080fe200003400ffULL, 0x000000a700817306ULL, 0x000fe20000209400ULL,
0x000000a200a27245ULL, 0x002fe2000020d400ULL, 0x000000371717a231ULL, 0x000fcc00003400ffULL,
0x000000a7007d7306ULL, 0x0002a20000205400ULL, 0x00000050a500720bULL, 0x000fe40003f7d000ULL,
0x000000bca150723eULL, 0x000fca00000010ffULL, 0x0000005300717306ULL, 0x000fe20000009400ULL,
0x000000a700a77245ULL, 0x002fca000020d400ULL, 0x00000001a2a23812ULL, 0x000fe400078efcffULL,
0x0000005300707306ULL, 0x000fe20000005400ULL, 0x0000007d8100720bULL, 0x004fce0003fbd000ULL,
0x00000053005f7306ULL, 0x000fec000000d400ULL, 0x00000001a7a75812ULL, 0x000fe400078efcffULL,
0x000000d600a67306ULL, 0x000fe40000209400ULL, 0x00000062a762723eULL, 0x000fcc00000010ffULL,
0x000000d600537306ULL, 0x0002b00000205400ULL, 0x000000b9007c7306ULL, 0x000fe20000209400ULL,
0x000000d600d67245ULL, 0x002fce000020d400ULL, 0x000000b9007e7306ULL, 0x0002e20000205400ULL,
0x00000053a600720bULL, 0x004fce0003f7d000ULL, 0x000000b2007b7306ULL, 0x000fe20000209400ULL,
0x000000b900b97245ULL, 0x002fca000020d400ULL, 0x00000001d6d63812ULL, 0x000fe400078efcffULL,
0x000000b200767306ULL, 0x0002a20000205400ULL, 0x0000007e7c00720bULL, 0x008fce0003fbd000ULL,
0x0000005100787306ULL, 0x000fe20000009400ULL, 0x000000b200b27245ULL, 0x002fca000020d400ULL,
0x00000001b9b95812ULL, 0x000fe400078efcffULL, 0x0000005100777306ULL, 0x000e620000005400ULL,
0x000000767b00720bULL, 0x004fce0003f1d000ULL, 0x0000005800567306ULL, 0x000fec0000209400ULL,
0x00000001b2b20812ULL, 0x000fe400078efcffULL, 0x0000005800557306ULL, 0x0004e20000205400ULL,
0x000000777800720bULL, 0x002fce0003f7d000ULL, 0x0000005100637306ULL, 0x0002e2000000d400ULL,
0x000000ac2458723cULL, 0x004bee0000041804ULL, 0x0000006b006d7306ULL, 0x000fe20000209400ULL,
0x0001000051517824ULL, 0x002fe200078e00ffULL, 0x000000555600720bULL, 0x008fc40003f9d000ULL,
0x000000102454723cULL, 0x000b640000041808ULL, 0x000000747304723eULL, 0x020fe400000010ffULL,
0x00000018ff757819ULL, 0x000fe20000011451ULL, 0x0000006b006c7306ULL, 0x0002a20000205400ULL,
0x000000bf5251723eULL, 0x000fe400000010ffULL, 0x0000006f9e10723eULL, 0x000fe400000010ffULL,
0x0000006ea811723eULL, 0x000fc400000010ffULL, 0x0000000163633812ULL, 0x000fe200078efcffULL,
0x0000006600677306ULL, 0x000fe20000209400ULL, 0x0000006b006b7245ULL, 0x002fe2000020d400ULL,
0x000000502450723cULL, 0x000b62000004180cULL, 0x0000007500b37245ULL, 0x000fe4000020d400ULL,
0x0000000172724812ULL, 0x000fe400078efcffULL, 0x000000707100720bULL, 0x000fe20003f9d000ULL,
0x00000066006a7306ULL, 0x0002e20000205400ULL, 0x0000006c6d00720bULL, 0x004fc40003fbd000ULL,
0x000000cc8a0c723eULL, 0x020fe400000010ffULL, 0x000000a27a0d723eULL, 0x000fe400000010ffULL,
0x00000068d608723eULL, 0x000fe200000010ffULL, 0x0000007500127306ULL, 0x000fe20000209400ULL,
0x0000006600667245ULL, 0x002fe4000020d400ULL, 0x000000699a09723eULL, 0x000fe200000010ffULL,
0x0000000c140c723cULL, 0x000f620000041848ULL, 0x000000015f5f4812ULL, 0x000fc400078efcffULL,
0x000000016b6b5812ULL, 0x000fe200078efcffULL, 0x0000007500137306ULL, 0x000e620000205400ULL,
0x0000006a6700720bULL, 0x008fe40003f1d000ULL, 0x000000c87205723eULL, 0x000fe400000010ffULL,
0x00000063b963723eULL, 0x000fe400000010ffULL, 0x000000b26bb2723eULL, 0x000fe200000010ffULL,
0x000000a000777306ULL, 0x000fe80000209400ULL, 0x000000621454723cULL, 0x000f640000041854ULL,
0x0000000166660812ULL, 0x000fc400078efcffULL, 0x000000a0000a7306ULL, 0x0004e20000205400ULL,
0x000000131200720bULL, 0x002fc60003f7d000ULL, 0x000000101410723cULL, 0x000b680000041818ULL,
0x0000009f00067306ULL, 0x000fe20000209400ULL, 0x000000a000a07245ULL, 0x004fca000020d400ULL,
0x00000001b3b33812ULL, 0x000fe400078efcffULL, 0x0000009f00077306ULL, 0x0002a20000205400ULL,
0x0000000a7700720bULL, 0x008fe40003fbd000ULL, 0x000000b366b3723eULL, 0x000fe200000010ffULL,
0x000000081408723cULL, 0x000b68000004184cULL, 0x0000004500657306ULL, 0x000fe20000209400ULL,
0x0000009f009f7245ULL, 0x002fc6000020d400ULL, 0x000000b21458723cULL, 0x040b640000041858ULL,
0x00000001a0a05812ULL, 0x000fe400078efcffULL, 0x0000004500647306ULL, 0x0002e20000205400ULL,
0x000000070600720bULL, 0x004fe40003f1d000ULL, 0x0000005ea05e723eULL, 0x000fe200000010ffULL,
0x000000041404723cULL, 0x000b680000041850ULL, 0x0000005d00617306ULL, 0x000fe20000209400ULL,
0x0000004500457245ULL, 0x002fca000020d400ULL, 0x000000019f9f0812ULL, 0x000fe400078efcffULL,
0x0000005d00607306ULL, 0x0002a20000205400ULL, 0x000000646500720bULL, 0x008fe40003f7d000ULL,
0x0000005f9f5f723eULL, 0x000fca00000010ffULL, 0x0000008d00247306ULL, 0x000fe20000209400ULL,
0x0000005d005d7245ULL, 0x002fe2000020d400ULL, 0x0000005e1420723cULL, 0x000b680000041820ULL,
0x0000000145453812ULL, 0x000fe400078efcffULL, 0x0000008d00187306ULL, 0x0202e20000205400ULL,
0x000000606100720bULL, 0x004fce0003fbd000ULL, 0x0000008c00197306ULL, 0x000fe20000209400ULL,
0x0000008d008d7245ULL, 0x002fca000020d400ULL, 0x000000015d5d5812ULL, 0x000fe400078efcffULL,
0x0000008c001a7306ULL, 0x000e620000205400ULL, 0x000000182400720bULL, 0x008fda0003fdd000ULL,
0x000000018d8d6812ULL, 0x000fe400078efcffULL, 0x0000001a1900720bULL, 0x002fe40003f1d000ULL,
0x0000008c00197245ULL, 0x000fe4000020d400ULL, 0x0000008d4518723eULL, 0x000fd200000010ffULL,
0x0000000119190812ULL, 0x000fc800078efcffULL, 0x000000195d19723eULL, 0x000fce00000010ffULL,
0x000000181414723cULL, 0x000b62000004181cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff1c7f8cULL, 0x020e62000c80043fULL, 0x000000ffff1f7224ULL, 0x000fce00078e00ffULL,
0x0000000000187805ULL, 0x000fc40000015200ULL, 0x0106bc00ff1a7984ULL, 0x000ea40000000800ULL,
0x800000001aff7812ULL, 0x006fe4000780481dULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101f00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001a7805ULL, 0x000fcc0000015200ULL, 0x0000001a181e7210ULL, 0x000fca0007f1e1ffULL,
0x000000011b1b7824ULL, 0x000fe200000e0e19ULL, 0x003d09001e00780cULL, 0x000fc80003f06070ULL,
0x000000ff1b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401e00780cULL, 0x000fc80003f06070ULL, 0x000000ff1b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1a7819ULL, 0x000fc8000001141bULL,
0x0000001e1a1a7211ULL, 0x000fca00078110ffULL, 0x000000ffff1b7224ULL, 0x000fca00000e061bULL,
0x000000021a1a7819ULL, 0x000fc8000000121bULL, 0x0000001a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011f1f7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106bc00ff1a7984ULL, 0x000e640000000800ULL,
0x800000001aff7812ULL, 0x002fe4000780481dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000058002c4c7a24ULL, 0x010fc800078e02ffULL, 0x000000404c4c7824ULL, 0x000fe200078e00ffULL,
0x0000045000009947ULL, 0x000fea0003800000ULL, 0x0000000238457810ULL, 0x040fe20007ffe0ffULL,
0x000000012b187824ULL, 0x040fe200078e0238ULL, 0x0000000438497810ULL, 0x000fe20007ffe0ffULL,
0x000000c004057891ULL, 0x000fe2000f8e403fULL, 0x000000f030267812ULL, 0x000fe200078ec0ffULL,
0x000000012b1a7824ULL, 0x000fe400078e0245ULL, 0x0000000118197824ULL, 0x040fe400078e0202ULL,
0x0000001018277824ULL, 0x000fc400078e00ffULL, 0x0000004003257824ULL, 0x000fe400078e0218ULL,
0x000000012b187824ULL, 0x000fe200078e0249ULL, 0xfffffff027277812ULL, 0x000fe200078ee219ULL,
0x000000011a1b7824ULL, 0x140fe200078e0202ULL, 0x0000004c251e7210ULL, 0x040fe20007f1e0ffULL,
0x000000101a487824ULL, 0x000fe200078e00ffULL, 0x0000000225247810ULL, 0x040fe20007ffe0ffULL,
0x00000001181a7824ULL, 0x040fe200078e0202ULL, 0x00000004251f7810ULL, 0x000fe20007ffe0ffULL,
0x00000010184a7824ULL, 0x000fe200078e00ffULL, 0x0000000528187c17ULL, 0x000fe2000f800000ULL,
0x000000ffff197224ULL, 0x000fe200000e06ffULL, 0x00005e001e1d7a11ULL, 0x000fc400078040ffULL,
0x8000000518187c10ULL, 0x000fe4000fffe0ffULL, 0x00005f001e1e7a11ULL, 0x000fe400000f4419ULL,
0x000000182b187217ULL, 0x000fe40007800000ULL, 0x0000004c24247210ULL, 0x080fe40007f1e0ffULL,
0xfffffff048487812ULL, 0x000fe200078ee21bULL, 0x00000001181b7824ULL, 0x000fe200078e0a2bULL,
0x0000004c1f1f7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff187224ULL, 0x000fe200000e06ffULL,
0x00005e00241c7a11ULL, 0x000fc400078040ffULL, 0x0000001b3800720cULL, 0x000fe20003f86070ULL,
0x000000ffff197224ULL, 0x000fe200018e06ffULL, 0xfffffff04a4a7812ULL, 0x000fe400078ee21aULL,
0x00005f0024247a11ULL, 0x000fe400000f4418ULL, 0x00005e001f1a7a11ULL, 0x000fe400078a40ffULL,
0x000000261d187210ULL, 0x000fe40007f7e0ffULL, 0x00005f001f1f7a11ULL, 0x000fc400028f4419ULL,
0x0000001b4500720cULL, 0x080fe20003f06070ULL, 0x000000ffff197224ULL, 0x000fe200018e061eULL,
0x0000c00027277811ULL, 0x000fe400078e20ffULL, 0x0000000638457810ULL, 0x000fe40007ffe0ffULL,
0x00000006251d7810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018277faeULL, 0x0003e2000e101c46ULL, 0x0000001b4900720cULL, 0x000fe20003f66070ULL,
0x000000012b1e7824ULL, 0x000fe200078e0245ULL, 0x0000004c1d1d7210ULL, 0x000fc40007f9e0ffULL,
0x000000261a1a7210ULL, 0x080fe20007fde0ffULL, 0x000000011e257824ULL, 0x000fe200078e0202ULL,
0x0000c00048487811ULL, 0x000fe400078e20ffULL, 0x0000c0004a4a7811ULL, 0x000fe400078e20ffULL,
0x000000261c187210ULL, 0x002fe20007fbe0ffULL, 0x000000101e277824ULL, 0x000fe400078e00ffULL,
0x000000ffff1e7224ULL, 0x000fe200020e06ffULL, 0x00005e001d1c7a11ULL, 0x000fe200078840ffULL,
0x000000ffff197224ULL, 0x000fe200028e0624ULL, 0x0000001b4500720cULL, 0x000fe20003fa6070ULL,
0x000000ffff1b7224ULL, 0x000fe200030e061fULL, 0x00005f001d1d7a11ULL, 0x000fc400020f441eULL,
0x000000261c1c7210ULL, 0x000fe20007f9e0ffULL, 0x0000000018487faeULL, 0x0003e2000c101c46ULL,
0xfffffff027257812ULL, 0x000fc600078ee225ULL, 0x000000ffff1d7224ULL, 0x000fe200020e061dULL,
0x0000c00025257811ULL, 0x000fe200078e20ffULL, 0x000000001a4a7faeULL, 0x0003e8000d901c46ULL,
0x000000001c257faeULL, 0x0003e2000e901c46ULL, 0x0000038000007947ULL, 0x000fea0003800000ULL,
0x000000012b187824ULL, 0x000fc800078e0238ULL, 0x0000000118197824ULL, 0x040fe200078e0202ULL,
0x00000002181a7810ULL, 0x040fe20007ffe0ffULL, 0x00000010181c7824ULL, 0x000fc800078e00ffULL,
0x000000011a1b7824ULL, 0x000fe200078e0202ULL, 0xfffffff01c1c7812ULL, 0x000fe200078ee219ULL,
0x000000101a247824ULL, 0x000fe200078e00ffULL, 0x00000004181a7810ULL, 0x000fe20007ffe0ffULL,
0x0000004003197824ULL, 0x000fc600078e0218ULL, 0xfffffff024247812ULL, 0x000fe200078ee21bULL,
0x000000011a1d7824ULL, 0x100fe200078e0202ULL, 0x00000006181b7810ULL, 0x000fe20007ffe0ffULL,
0x000000101a457824ULL, 0x000fe200078e00ffULL, 0x0000004c19187210ULL, 0x000fe40007f1e0ffULL,
0x0000c00024247811ULL, 0x000fe200078e20ffULL, 0x000000011b1e7824ULL, 0x000fe200078e0202ULL,
0xfffffff045457812ULL, 0x000fe200078ee21dULL, 0x000000101b4b7824ULL, 0x000fe200078e00ffULL,
0x00000002191d7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff1a7224ULL, 0x000fe200000e06ffULL,
0x00005e00181b7a11ULL, 0x000fc400078040ffULL, 0xfffffff04b4b7812ULL, 0x000fe400078ee21eULL,
0x00005f00181a7a11ULL, 0x000fe400000f441aULL, 0x0000000419187810ULL, 0x040fe40007ffe0ffULL,
0x0000000619197810ULL, 0x000fe40007ffe0ffULL, 0x0000004c1d1d7210ULL, 0x080fe40007f1e0ffULL,
0x0000004c18257210ULL, 0x000fc40007f7e0ffULL, 0x000000f0301e7812ULL, 0x000fe400078ec0ffULL,
0x0000004c19487210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff197224ULL, 0x000fe200000e06ffULL,
0x00005e001d1f7a11ULL, 0x000fe200078040ffULL, 0x000000ffff267224ULL, 0x000fe200018e06ffULL,
0x0000001e1b187210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff497224ULL, 0x000fe200028e06ffULL,
0x00005e0025277a11ULL, 0x000fe400078840ffULL, 0x00005e00484a7a11ULL, 0x000fc400078a40ffULL,
0x00005f001d1d7a11ULL, 0x000fe200000f4419ULL, 0x000000ffff197224ULL, 0x000fe200018e061aULL,
0x0000c0001c1b7811ULL, 0x000fe400078e20ffULL, 0x0000001e1f1a7210ULL, 0x080fe40007f1e0ffULL,
0x00005f0025267a11ULL, 0x000fe200020f4426ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000181b7faeULL, 0x0003e2000b901c46ULL, 0x0000001e271c7210ULL, 0x000fe40007f7e0ffULL,
0x00005f0048497a11ULL, 0x000fc400028f4449ULL, 0x0000001e4a1e7210ULL, 0x000fe40007f9e0ffULL,
0x0000c00045457811ULL, 0x000fe400078e20ffULL, 0x0000c0004b4b7811ULL, 0x000fe200078e20ffULL,
0x000000ffff1f7224ULL, 0x000fe400020e0649ULL, 0x000000ffff1b7224ULL, 0x002fe400000e061dULL,
0x000000ffff1d7224ULL, 0x000fc600018e0626ULL, 0x000000001a247faeULL, 0x0003e8000b901c46ULL,
0x000000001c457faeULL, 0x0003e8000b901c46ULL, 0x000000001e4b7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff187f8cULL, 0x000e64000c80043fULL, 0x000000ffff457224ULL, 0x002fc400078e0019ULL,
0x0000000000187805ULL, 0x000fca0000015200ULL, 0x0106b400ff1a7984ULL, 0x000e640000000800ULL,
0x800000001aff7812ULL, 0x002fc40007804847ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1d7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101d00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000001a7805ULL, 0x000fcc0000015200ULL,
0x0000001a181c7210ULL, 0x000fca0007f1e1ffULL, 0x000000011b1b7824ULL, 0x000fe200000e0e19ULL,
0x003d09001c00780cULL, 0x000fc80003f06070ULL, 0x000000ff1b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401c00780cULL, 0x000fc80003f06070ULL,
0x000000ff1b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1a7819ULL, 0x000fc8000001141bULL, 0x0000001c1a1a7211ULL, 0x000fca00078110ffULL,
0x000000ffff1b7224ULL, 0x000fca00000e061bULL, 0x000000021a1a7819ULL, 0x000fc8000000121bULL,
0x0000001a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000011d1d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106b400ff1a7984ULL, 0x000e640000000800ULL, 0x800000001aff7812ULL, 0x002fe40007804847ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000014000007945ULL, 0x000fe20003800000ULL,
0x0000012000002947ULL, 0x000fea0003800000ULL, 0x00000035ff18723eULL, 0x000fe400000010ffULL,
0x00000002ff197819ULL, 0x000fe40000011602ULL, 0x0000541018187816ULL, 0x000fe20000000018ULL,
0x0000f7027f007947ULL, 0x000fea000b800000ULL, 0x00001f1918367589ULL, 0x0002a400000e0000ULL,
0x0000000819377810ULL, 0x000fe20007ffe0ffULL, 0x0000f7327f007947ULL, 0x000fea000b800000ULL,
0x00001f3718377589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001019497810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff4a7224ULL, 0x000fe200078e0018ULL,
0x000118a000487802ULL, 0x000fc40000000f00ULL, 0x0000fee000007944ULL, 0x00efea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001819497810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4a7224ULL, 0x004fe200078e0018ULL, 0x000118f000487802ULL, 0x000fc40000000f00ULL,
0x0000fe9000007944ULL, 0x00afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000004024783bULL, 0x000f220000004200ULL,
0x000000c004057891ULL, 0x000fc6000f8e403fULL, 0x000000003f18783bULL, 0x00ae680000004200ULL,
0x00000000421c783bULL, 0x000ee80000004200ULL, 0x000000004148783bULL, 0x004ea20000004200ULL,
0x0000010024977824ULL, 0x010fe200078e00ffULL, 0x0000002500cd7306ULL, 0x000fe20000009400ULL,
0x0000010025d07824ULL, 0x000fe200078e00ffULL, 0x00000018ffc07819ULL, 0x000fe20000011424ULL,
0x0000010026c57824ULL, 0x040fe200078e00ffULL, 0x00000018ffd67819ULL, 0x000fe20000011497ULL,
0x0000010027bf7824ULL, 0x040fe200078e00ffULL, 0x00000018ffd07819ULL, 0x000fe200000114d0ULL,
0x0001000027c27824ULL, 0x000fe200078e00ffULL, 0x000000d600d77306ULL, 0x000fe20000209400ULL,
0x00000018ffc57819ULL, 0x000fe200000114c5ULL, 0x0001000026c17824ULL, 0x000fe200078e00ffULL,
0x00000018ffa07819ULL, 0x000fe20000011427ULL, 0x0001000024d27824ULL, 0x000fe200078e00ffULL,
0x00000018ffb67819ULL, 0x000fe20000011425ULL, 0x0001000025c87824ULL, 0x000fe200078e00ffULL,
0x00000018ffc17819ULL, 0x000fe200000114c1ULL, 0x000000d600d87306ULL, 0x000f220000205400ULL,
0x00000018ffd27819ULL, 0x000fe200000114d2ULL, 0x0000010018b47824ULL, 0x042fe200078e00ffULL,
0x00000018ffaa7819ULL, 0x000fe20000011426ULL, 0x0001000018b57824ULL, 0x000fe200078e00ffULL,
0x00000018ffc87819ULL, 0x000fe200000114c8ULL, 0x0000010019b17824ULL, 0x040fe200078e00ffULL,
0x00000018ff9a7819ULL, 0x000fe20000011418ULL, 0x000000d000db7306ULL, 0x000fe20000209400ULL,
0x00000018ffbf7819ULL, 0x000fe200000114bfULL, 0x000001001aa27824ULL, 0x000fe200078e00ffULL,
0x00000018ffb47819ULL, 0x000fe200000114b4ULL, 0x0001000019a77824ULL, 0x000fe200078e00ffULL,
0x00000018ffc27819ULL, 0x000fc400000114c2ULL, 0x00000018ffb57819ULL, 0x000fe200000114b5ULL,
0x000000d000dc7306ULL, 0x000e620000205400ULL, 0x000000d8d700720bULL, 0x010fe20003f1d000ULL,
0x000001001ed87824ULL, 0x008fe200078e00ffULL, 0x00000018ffb17819ULL, 0x000fe200000114b1ULL,
0x000001001dd77824ULL, 0x000fe200078e00ffULL, 0x00000018ff957819ULL, 0x000fe40000011419ULL,
0x00000018ffa27819ULL, 0x000fe200000114a2ULL, 0x00000025008e7306ULL, 0x000ee20000005400ULL,
0x00000018ffa77819ULL, 0x000fc400000114a7ULL, 0x00000018ff867819ULL, 0x000fe4000001141aULL,
0x00000018ff857819ULL, 0x000fe4000001141bULL, 0x00000018ffd87819ULL, 0x000fe200000114d8ULL,
0x000000c500d47306ULL, 0x000fe20000209400ULL, 0x000000dcdb00720bULL, 0x002fe40003f9d000ULL,
0x00000018ff8a7819ULL, 0x000fe4000001141cULL, 0x00000018ff797819ULL, 0x000fc4000001141dULL,
0x00000018ff717819ULL, 0x000fe2000001141eULL, 0x000000c500d57306ULL, 0x0003220000205400ULL,
0x00000018ff6b7819ULL, 0x000fe4000001141fULL, 0x00000018ff617819ULL, 0x004fe40000011448ULL,
0x00000018ff517819ULL, 0x000fe40000011449ULL, 0x00000018ff467819ULL, 0x000fe2000001144aULL,
0x0000002700b37306ULL, 0x000fe20000009400ULL, 0x000000c500c57245ULL, 0x002fc4000020d400ULL,
0x00000018ff477819ULL, 0x000fca000001144bULL, 0x0000002700b27306ULL, 0x000ff00000005400ULL,
0x0000002700727306ULL, 0x0003f0000000d400ULL, 0x000000c000cf7306ULL, 0x000fe20000209400ULL,
0x000000d600277245ULL, 0x002fc8000020d400ULL, 0x0000000127270812ULL, 0x000fe400078efcffULL,
0x0000008ecd00720bULL, 0x008fe20003f1d000ULL, 0x000000c000ce7306ULL, 0x0002a20000205400ULL,
0x000000d000cd7245ULL, 0x000fe4000020d400ULL, 0x000000d2008e7245ULL, 0x000fe4000020d400ULL,
0x00000001cdcd4812ULL, 0x000fe400078efcffULL, 0x000000d5d400720bULL, 0x010fe20003f9d000ULL,
0x000000c100c77306ULL, 0x000fe20000209400ULL, 0x000000c000c07245ULL, 0x002fce000020d400ULL,
0x000000c100cc7306ULL, 0x0002e20000205400ULL, 0x000000cecf00720bULL, 0x004fc60003f7d000ULL,
0x00000001c5c54812ULL, 0x000fc800078efcffULL, 0x0000002400967306ULL, 0x000fe20000009400ULL,
0x000000c100c17245ULL, 0x002fca000020d400ULL, 0x00000001c0c03812ULL, 0x000fe400078efcffULL,
0x0000002400a17306ULL, 0x000e620000005400ULL, 0x000000ccc700720bULL, 0x008fce0003f9d000ULL,
0x000000b600bd7306ULL, 0x000fec0000209400ULL, 0x00000001c1c14812ULL, 0x000fe400078efcffULL,
0x000000b600be7306ULL, 0x0004e20000205400ULL, 0x000000a19600720bULL, 0x002fe20003fdd000ULL,
0x000100001fa17824ULL, 0x000fca00078e00ffULL, 0x00000018ffa17819ULL, 0x000fe200000114a1ULL,
0x000000d200d97306ULL, 0x000fe20000209400ULL, 0x000000b600b67245ULL, 0x004fce000020d400ULL,
0x000000d200da7306ULL, 0x000e620000205400ULL, 0x000000bebd00720bULL, 0x008fce0003f7d000ULL,
0x000000a000a57306ULL, 0x000fec0000209400ULL, 0x00000001b6b63812ULL, 0x000fe400078efcffULL,
0x000000a000a67306ULL, 0x0004e20000205400ULL, 0x000000dad900720bULL, 0x002fce0003fbd000ULL,
0x0000002400877306ULL, 0x000322000000d400ULL, 0x000000a000a07245ULL, 0x004fca000020d400ULL,
0x000000018e8e5812ULL, 0x000fe400078efcffULL, 0x000000aa00af7306ULL, 0x000fe20000209400ULL,
0x000000a6a500720bULL, 0x008fe20003f9d000ULL, 0x000100001a247824ULL, 0x002fe200078e00ffULL,
0x0000008ec08e723eULL, 0x000fe200000010ffULL, 0x0001000049a57824ULL, 0x000fc600078e00ffULL,
0x00000018ff247819ULL, 0x000fe20000011424ULL, 0x000000aa00b07306ULL, 0x0002a20000205400ULL,
0x0000000187876812ULL, 0x010fe400078efcffULL, 0x00000018ffa57819ULL, 0x000fc600000114a5ULL,
0x00000001a0a04812ULL, 0x000fe400078efcffULL, 0x000000c800dd7306ULL, 0x000fe20000209400ULL,
0x000000aa00aa7245ULL, 0x002fce000020d400ULL, 0x000000c800de7306ULL, 0x0002e20000205400ULL,
0x000000b0af00720bULL, 0x004fe20003f7d000ULL, 0x0001000048b07824ULL, 0x000fcc00078e00ffULL,
0x0000002600b87306ULL, 0x000fe20000009400ULL, 0x000000c800c87245ULL, 0x002fca000020d400ULL,
0x00000001aaaa3812ULL, 0x000fe400078efcffULL, 0x0000002600b97306ULL, 0x000e620000005400ULL,
0x000000dedd00720bULL, 0x008fe40003fdd000ULL, 0x000000c1aaaa723eULL, 0x000fca00000010ffULL,
0x0000002500787306ULL, 0x0004ec000000d400ULL, 0x00000001c8c86812ULL, 0x000fe400078efcffULL,
0x0000009a009e7306ULL, 0x000fe20000209400ULL, 0x000000b9b800720bULL, 0x002fe20003fbd000ULL,
0x000100001b257824ULL, 0x004fe200078e00ffULL, 0x000000b2b300720bULL, 0x000fe20003fdd000ULL,
0x0000010049b37824ULL, 0x000fe200078e00ffULL, 0x00000018ffb97819ULL, 0x000fc400000114d7ULL,
0x00000018ff257819ULL, 0x000fe20000011425ULL, 0x0000009a009f7306ULL, 0x0002a20000205400ULL,
0x0000000178780812ULL, 0x008fe400078efcffULL, 0x00000018ffb37819ULL, 0x000fca00000114b3ULL,
0x000000bf00d17306ULL, 0x000fe20000209400ULL, 0x0000009a009a7245ULL, 0x002fe4000020d400ULL,
0x0000000172726812ULL, 0x000fca00078efcffULL, 0x000000bf00d37306ULL, 0x0002e20000205400ULL,
0x0000009f9e00720bULL, 0x004fce0003f9d000ULL, 0x000000b400c37306ULL, 0x000fe20000209400ULL,
0x000000bf00bf7245ULL, 0x002fca000020d400ULL, 0x000000019a9a4812ULL, 0x000fe400078efcffULL,
0x000000b400c47306ULL, 0x0002a20000205400ULL, 0x000000d3d100720bULL, 0x008fce0003f1d000ULL,
0x0000002600757306ULL, 0x000722000000d400ULL, 0x000000b400b47245ULL, 0x002fca000020d400ULL,
0x00000001bfbf0812ULL, 0x000fe400078efcffULL, 0x000000c200cb7306ULL, 0x000fe20000209400ULL,
0x000001001c267824ULL, 0x008fe200078e00ffULL, 0x000000c4c300720bULL, 0x004fe40003f7d000ULL,
0x00000072bfbf723eULL, 0x000fe400000010ffULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x000000c200c97306ULL, 0x0002a20000205400ULL, 0x0000000175755812ULL, 0x010fc800078efcffULL,
0x00000075c5be723eULL, 0x000fe400000010ffULL, 0x00000001b4b43812ULL, 0x000fe200078efcffULL,
0x0000001800ac7306ULL, 0x000fe20000009400ULL, 0x000000c200c27245ULL, 0x002fce000020d400ULL,
0x0000001800ab7306ULL, 0x000e620000005400ULL, 0x000000c9cb00720bULL, 0x004fce0003fbd000ULL,
0x0000001b00947306ULL, 0x000fec0000009400ULL, 0x00000001c2c25812ULL, 0x000fe400078efcffULL,
0x0000001b00937306ULL, 0x000ea20000005400ULL, 0x000000abac00720bULL, 0x002fce0003f1d000ULL,
0x0000001900ad7306ULL, 0x000ff00000009400ULL, 0x0000001900ae7306ULL, 0x000e620000005400ULL,
0x000000939400720bULL, 0x004fce0003f9d000ULL, 0x000000b500b77306ULL, 0x000ff00000209400ULL,
0x000000b500ba7306ULL, 0x0004e20000205400ULL, 0x000000aead00720bULL, 0x002fe20003fdd000ULL,
0x0000010048ae7824ULL, 0x000fca00078e00ffULL, 0x00000018ffae7819ULL, 0x000fe200000114aeULL,
0x000000b100c67306ULL, 0x000fe20000209400ULL, 0x000000b500b57245ULL, 0x004fce000020d400ULL,
0x000000b100ca7306ULL, 0x0002a20000205400ULL, 0x000000bab700720bULL, 0x008fce0003f7d000ULL,
0x0000001800707306ULL, 0x000722000000d400ULL, 0x000000b100b17245ULL, 0x002fca000020d400ULL,
0x00000001b5b53812ULL, 0x000fe400078efcffULL, 0x0000001b00667306ULL, 0x000262000000d400ULL,
0x000000cac600720bULL, 0x004fe20003fbd000ULL, 0x000001001b187824ULL, 0x008fca00078e00ffULL,
0x00000018ff187819ULL, 0x000fe20000011418ULL, 0x0000001a009d7306ULL, 0x000fe20000009400ULL,
0x0000000170700812ULL, 0x010fe200078efcffULL, 0x000001001f1b7824ULL, 0x002fc800078e00ffULL,
0x00000001b1b15812ULL, 0x000fe400078efcffULL, 0x0000001a009c7306ULL, 0x000e620000005400ULL,
0x0000000166664812ULL, 0x000fce00078efcffULL, 0x0000002600967306ULL, 0x000ff00000209400ULL,
0x0000002600ce7306ULL, 0x0004e20000205400ULL, 0x0000009c9d00720bULL, 0x002fe40003f1d000ULL,
0x00000018ff9c7819ULL, 0x000fc4000001141bULL, 0x0000b000431b7811ULL, 0x000fc600078e20ffULL,
0x00000019006f7306ULL, 0x000e62000000d400ULL, 0x0000002600267245ULL, 0x004fce000020d400ULL,
0x0000009500997306ULL, 0x000fe20000209400ULL, 0x000000ce9600720bULL, 0x008fce0003f9d000ULL,
0x00000095009b7306ULL, 0x0004e20000205400ULL, 0x000000016f6f6812ULL, 0x002fc800078efcffULL,
0x0000006fb1b1723eULL, 0x000fe400000010ffULL, 0x0000000126264812ULL, 0x000fe200078efcffULL,
0x000000a200a87306ULL, 0x000fe20000209400ULL, 0x0000009500957245ULL, 0x004fce000020d400ULL,
0x000000a200a97306ULL, 0x0002a20000205400ULL, 0x0000009b9900720bULL, 0x008fce0003fdd000ULL,
0x000000a700bc7306ULL, 0x000fe20000209400ULL, 0x000000a200a27245ULL, 0x002fca000020d400ULL,
0x0000000195956812ULL, 0x000fe400078efcffULL, 0x000000a700bb7306ULL, 0x0002e20000205400ULL,
0x000000a9a800720bULL, 0x004fce0003f7d000ULL, 0x0000001a006c7306ULL, 0x000ea2000000d400ULL,
0x000000a700a77245ULL, 0x002fca000020d400ULL, 0x00000001a2a23812ULL, 0x000fe400078efcffULL,
0x0000001d008c7306ULL, 0x000fe20000009400ULL, 0x000000bbbc00720bULL, 0x008fce0003fbd000ULL,
0x0000001d008d7306ULL, 0x000e620000005400ULL, 0x000000016c6c0812ULL, 0x004fc800078efcffULL,
0x0000006ca26c723eULL, 0x000fe400000010ffULL, 0x00000001a7a75812ULL, 0x000fe200078efcffULL,
0x0000002400197306ULL, 0x000fe60000209400ULL, 0x000000a79595723eULL, 0x000fca00000010ffULL,
0x00000024001a7306ULL, 0x000ea20000205400ULL, 0x0000008d8c00720bULL, 0x002fce0003f9d000ULL,
0x00000086008f7306ULL, 0x000ff00000209400ULL, 0x0000008600907306ULL, 0x0002e20000205400ULL,
0x0000001a1900720bULL, 0x004fce0003f1d000ULL, 0x0000008500917306ULL, 0x000fe20000209400ULL,
0x0000008600867245ULL, 0x002fce000020d400ULL, 0x0000008500927306ULL, 0x0002a20000205400ULL,
0x000000908f00720bULL, 0x008fe40003fdd000ULL, 0x0000001800907245ULL, 0x000fe4000020d400ULL,
0x000000c8b68f723eULL, 0x000fc600000010ffULL, 0x0000001800a37306ULL, 0x000fe20000209400ULL,
0x0000008500857245ULL, 0x002fca000020d400ULL, 0x0000000186866812ULL, 0x000fe400078efcffULL,
0x0000001800a47306ULL, 0x0002e20000205400ULL, 0x000000929100720bULL, 0x004fe40003f7d000ULL,
0x0000002400917245ULL, 0x000fe4000020d400ULL, 0x000000872724723eULL, 0x000fe400000010ffULL,
0x0000000191910812ULL, 0x000fe200078efcffULL, 0x0000001d00627306ULL, 0x000522000000d400ULL,
0x000000001b18783bULL, 0x002e6a0000000200ULL, 0x0000000185853812ULL, 0x000fc400078efcffULL,
0x0000001c007c7306ULL, 0x000fe20000009400ULL, 0x000000a4a300720bULL, 0x008fe20003fbd000ULL,
0x000100001d1d7824ULL, 0x004fca00078e00ffULL, 0x00000018ffab7819ULL, 0x000fe2000001141dULL,
0x0000001c007a7306ULL, 0x000ea20000005400ULL, 0x0000000162624812ULL, 0x010fca00078efcffULL,
0x0000000190905812ULL, 0x000fe400078efcffULL, 0x000000d800ad7306ULL, 0x000ff00000209400ULL,
0x000000d8009e7306ULL, 0x0007220000205400ULL, 0x0000007a7c00720bULL, 0x004fc40003f1d000ULL,
0x00000025007a7245ULL, 0x000fe4000020d400ULL, 0x000000ab007c7245ULL, 0x000fc6000020d400ULL,
0x0000001c00657306ULL, 0x000522000000d400ULL, 0x000000d800d87245ULL, 0x008fe2000020d400ULL,
0x000000361818a231ULL, 0x082fe400003400ffULL, 0x000000361a1aa231ULL, 0x000fe400003400ffULL,
0x000000371919a231ULL, 0x080fe400003400ffULL, 0x0000002500977306ULL, 0x000fe20000209400ULL,
0x000100001c1c7824ULL, 0x004fe200078e00ffULL, 0x0000009ead00720bULL, 0x010fe20003f9d000ULL,
0x000000371b1ba231ULL, 0x000fc600003400ffULL, 0x00000018ffcf7819ULL, 0x000fe4000001141cULL,
0x0000002500987306ULL, 0x0002a20000205400ULL, 0x0000b000441c7811ULL, 0x000fe200078e20ffULL,
0x0000008e180c723cULL, 0x000fe2000004180cULL, 0x0000000165650812ULL, 0x000fc800078efcffULL,
0x00000001d8d84812ULL, 0x000fe200078efcffULL, 0x000000cf00d07306ULL, 0x000fe20000209400ULL,
0x00000078cd25723eULL, 0x002fe200000010ffULL, 0x000000be1808723cULL, 0x040fec0000041808ULL,
0x000000cf00b87306ULL, 0x0002e20000205400ULL, 0x000000989700720bULL, 0x004fe20003fbd000ULL,
0x000000241810723cULL, 0x000b6c0000041810ULL, 0x0000001e008b7306ULL, 0x000fe20000009400ULL,
0x000000cf00cf7245ULL, 0x002fc4000020d400ULL, 0x000000918624723eULL, 0x020fc600000010ffULL,
0x000000017a7a5812ULL, 0x000fe400078efcffULL, 0x0000001e00847306ULL, 0x000e620000005400ULL,
0x000000b8d000720bULL, 0x008fe40003fdd000ULL, 0x0000007a8525723eULL, 0x000fca00000010ffULL,
0x0000009c009d7306ULL, 0x000fec0000209400ULL, 0x00000001cfcf6812ULL, 0x000fe400078efcffULL,
0x0000009c00997306ULL, 0x0004e20000205400ULL, 0x000000848b00720bULL, 0x002fce0003f1d000ULL,
0x0000001e00607306ULL, 0x000322000000d400ULL, 0x0000009c009c7245ULL, 0x004fce000020d400ULL,
0x0000001f00897306ULL, 0x000fe20000009400ULL, 0x000100001e1e7824ULL, 0x002fe200078e00ffULL,
0x000000999d00720bULL, 0x008fc80003f9d000ULL, 0x00000018ff937819ULL, 0x000fe4000001141eULL,
0x0000001f00807306ULL, 0x000e620000005400ULL, 0x0000000160600812ULL, 0x010fcc00078efcffULL,
0x000000019c9c4812ULL, 0x000fe200078efcffULL, 0x0000001f005f7306ULL, 0x0004f0000000d400ULL,
0x0000008a007f7306ULL, 0x000fe20000209400ULL, 0x000000001c1c783bULL, 0x004ea20000000200ULL,
0x000000808900720bULL, 0x002fcc0003fdd000ULL, 0x0000008a00817306ULL, 0x00032e0000205400ULL,
0x000000015f5f6812ULL, 0x008fe200078efcffULL, 0x0000007100747306ULL, 0x000fe20000209400ULL,
0x0000008a008a7245ULL, 0x002fce000020d400ULL, 0x0000007100737306ULL, 0x0002e20000205400ULL,
0x000000817f00720bULL, 0x010fce0003fbd000ULL, 0x000000b900b27306ULL, 0x000fe20000209400ULL,
0x0000007100717245ULL, 0x002fca000020d400ULL, 0x000000018a8a5812ULL, 0x000fe400078efcffULL,
0x000000b900af7306ULL, 0x0003220000205400ULL, 0x000000737400720bULL, 0x008fe20003f1d000ULL,
0x000000361c1ca231ULL, 0x084fe400003400ffULL, 0x000000361e1ea231ULL, 0x000fe400003400ffULL,
0x000000371d1da231ULL, 0x080fe400003400ffULL, 0x0000009300947306ULL, 0x000fe20000209400ULL,
0x000000b900b97245ULL, 0x002fe2000020d400ULL, 0x000000371f1fa231ULL, 0x000fc800003400ffULL,
0x0000000171710812ULL, 0x000fe400078efcffULL, 0x0000009300927306ULL, 0x0002a20000205400ULL,
0x000000afb200720bULL, 0x010fce0003f7d000ULL, 0x00000079007d7306ULL, 0x000fe20000209400ULL,
0x0000009300937245ULL, 0x002fca000020d400ULL, 0x00000001b9b93812ULL, 0x000fe400078efcffULL,
0x0000007900827306ULL, 0x0002e20000205400ULL, 0x000000929400720bULL, 0x004fe40003f9d000ULL,
0x000000b59a94723eULL, 0x000fca00000010ffULL, 0x0000006b006e7306ULL, 0x000fe20000209400ULL,
0x0000007900797245ULL, 0x002fe2000020d400ULL, 0x000000941858723cULL, 0x000fe80000041858ULL,
0x0000000193934812ULL, 0x000fe400078efcffULL, 0x0000006b006d7306ULL, 0x0002a20000205400ULL,
0x000000827d00720bULL, 0x008fce0003fbd000ULL, 0x000000ab00ac7306ULL, 0x000fe20000209400ULL,
0x0000006b006b7245ULL, 0x002fca000020d400ULL, 0x0000000179795812ULL, 0x000fe400078efcffULL,
0x000000ab00a67306ULL, 0x0002e20000205400ULL, 0x0000006d6e00720bULL, 0x004fe40003f9d000ULL,
0x00000066906d723eULL, 0x000fca00000010ffULL, 0x000000ae007f7306ULL, 0x000fe20000209400ULL,
0x000000c2a0ab723eULL, 0x002fe200000010ffULL, 0x0000006c1820723cULL, 0x040fe80000041820ULL,
0x000000016b6b4812ULL, 0x000fe400078efcffULL, 0x000000ae00807306ULL, 0x0002a20000205400ULL,
0x000000a6ac00720bULL, 0x008fe20003f7d000ULL, 0x000000aa1804723cULL, 0x000f6c0000041804ULL,
0x00000048007b7306ULL, 0x000fe20000009400ULL, 0x000000ae00ae7245ULL, 0x002fca000020d400ULL,
0x000000017c7c3812ULL, 0x000fe400078efcffULL, 0x00000048007e7306ULL, 0x000e620000005400ULL,
0x000000807f00720bULL, 0x004fce0003f1d000ULL, 0x000000a100967306ULL, 0x000fec0000209400ULL,
0x00000001aeae0812ULL, 0x000fe400078efcffULL, 0x000000a100977306ULL, 0x0004e20000205400ULL,
0x0000007e7b00720bULL, 0x002fe40003f5d000ULL, 0x00000018ff7b7819ULL, 0x000fc400000114b0ULL,
0x00000070b4b0723eULL, 0x000fc600000010ffULL, 0x0000004a00777306ULL, 0x000fe20000009400ULL,
0x000000a100a17245ULL, 0x004fc6000020d400ULL, 0x000000b01854723cULL, 0x000f680000041854ULL,
0x0000004a00767306ULL, 0x000e620000005400ULL, 0x000000979600720bULL, 0x008fce0003fdd000ULL,
0x0000004900887306ULL, 0x000fec0000009400ULL, 0x00000001a1a16812ULL, 0x000fe400078efcffULL,
0x0000004900837306ULL, 0x000ea20000005400ULL, 0x000000767700720bULL, 0x002fce0003fbd000ULL,
0x0000006100677306ULL, 0x000ff00000209400ULL, 0x0000006100687306ULL, 0x0002e20000205400ULL,
0x000000838800720bULL, 0x004fce0003f7d000ULL, 0x000000b300817306ULL, 0x000fe20000209400ULL,
0x0000006100617245ULL, 0x002fce000020d400ULL, 0x000000b300827306ULL, 0x0002a20000205400ULL,
0x000000686700720bULL, 0x008fce0003f9d000ULL, 0x00000049004f7306ULL, 0x000722000000d400ULL,
0x000000b300b37245ULL, 0x002fca000020d400ULL, 0x0000000161614812ULL, 0x000fe400078efcffULL,
0x0000004800507306ULL, 0x000322000000d400ULL, 0x000001004a497824ULL, 0x008fe200078e00ffULL,
0x000000828100720bULL, 0x004fc80003f1d000ULL, 0x00000018ff707819ULL, 0x000fe40000011449ULL,
0x0000004b006a7306ULL, 0x000fe20000009400ULL, 0x000001004b487824ULL, 0x002fe200078e00ffULL,
0x00000062b949723eULL, 0x000fe400000010ffULL, 0x000000014f4f3812ULL, 0x010fe400078efcffULL,
0x00000018ff747819ULL, 0x000fe40000011448ULL, 0x0000004b00697306ULL, 0x000e620000005400ULL,
0x000000652648723eULL, 0x000fc400000010ffULL, 0x0000000150502812ULL, 0x000fe200078efcffULL,
0x000000241824723cULL, 0x000b620000041814ULL, 0x00000001b3b30812ULL, 0x000fc600078efcffULL,
0x0000005100647306ULL, 0x000fe60000209400ULL, 0x000000cf8a14723eULL, 0x020fe200000010ffULL,
0x000000481c18723cULL, 0x000b620000041810ULL, 0x0000007c7915723eULL, 0x000fc600000010ffULL,
0x0000005100637306ULL, 0x0004e20000205400ULL, 0x000000696a00720bULL, 0x002fe40003fdd000ULL,
0x00000060d810723eULL, 0x020fe200000010ffULL, 0x000000141c14723cULL, 0x000b62000004180cULL,
0x0000005f9c11723eULL, 0x000fc600000010ffULL, 0x0000007b007d7306ULL, 0x000fe20000209400ULL,
0x0000005100517245ULL, 0x004fe4000020d400ULL, 0x00000093710c723eULL, 0x020fe200000010ffULL,
0x000000101c10723cULL, 0x000b620000041808ULL, 0x000000a16b0d723eULL, 0x000fc600000010ffULL,
0x0000007b00767306ULL, 0x0002a20000205400ULL, 0x000000636400720bULL, 0x008fe40003f5d000ULL,
0x0000004fb309723eULL, 0x020fe200000010ffULL, 0x0000000c1c0c723cULL, 0x000b620000041804ULL,
0x00000074004f7245ULL, 0x000fe4000020d400ULL, 0x00000050ae08723eULL, 0x000fe200000010ffULL,
0x000000a500737306ULL, 0x000fe20000209400ULL, 0x0000007b007b7245ULL, 0x002fca000020d400ULL,
0x0000000151512812ULL, 0x000fe200078efcffULL, 0x000000081c08723cULL, 0x000b620000041854ULL,
0x000000a500727306ULL, 0x0002e20000205400ULL, 0x000000767d00720bULL, 0x004fce0003f1d000ULL,
0x00000070006f7306ULL, 0x000fe20000209400ULL, 0x000000a500a57245ULL, 0x002fca000020d400ULL,
0x000000017b7b0812ULL, 0x000fe400078efcffULL, 0x00000070006e7306ULL, 0x0002a20000205400ULL,
0x000000727300720bULL, 0x008fe40003f7d000ULL, 0x0000007b6104723eULL, 0x020fca00000010ffULL,
0x0000004a004e7306ULL, 0x000722000000d400ULL, 0x0000007000707245ULL, 0x002fca000020d400ULL,
0x00000001a5a53812ULL, 0x000fe400078efcffULL, 0x0000004b004d7306ULL, 0x000322000000d400ULL,
0x000100004a4a7824ULL, 0x008fe200078e00ffULL, 0x0000006e6f00720bULL, 0x004fe40003f9d000ULL,
0x000000a55105723eULL, 0x000fe400000010ffULL, 0x00000018ff4a7819ULL, 0x000fe4000001144aULL,
0x0000007400697306ULL, 0x000fe20000209400ULL, 0x000100004b4b7824ULL, 0x002fe200078e00ffULL,
0x000000014e4e5812ULL, 0x010fe200078efcffULL, 0x000000041c04723cULL, 0x000b660000041858ULL,
0x00000018ff4b7819ULL, 0x000fc4000001144bULL, 0x0000007400667306ULL, 0x000e620000205400ULL,
0x0000000170704812ULL, 0x000fe400078efcffULL, 0x000000014d4d6812ULL, 0x000fe400078efcffULL,
0x0000004e704e723eULL, 0x000fc600000010ffULL, 0x00000046005d7306ULL, 0x000ff00000209400ULL,
0x00000046005e7306ULL, 0x0004e20000205400ULL, 0x000000666900720bULL, 0x002fce0003f5d000ULL,
0x0000004700527306ULL, 0x000fe20000209400ULL, 0x0000004600467245ULL, 0x004fca000020d400ULL,
0x000000014f4f2812ULL, 0x000fe400078efcffULL, 0x0000004700537306ULL, 0x000e620000205400ULL,
0x0000005e5d00720bULL, 0x008fe40003f1d000ULL, 0x0000004d4f4f723eULL, 0x000fca00000010ffULL,
0x0000004a00637306ULL, 0x000fe40000209400ULL, 0x0000004e1c20723cULL, 0x000b680000041820ULL,
0x0000000146460812ULL, 0x000fe400078efcffULL, 0x0000004a00627306ULL, 0x0004e20000205400ULL,
0x000000535200720bULL, 0x002fce0003f7d000ULL, 0x0000004b00487306ULL, 0x000fe20000209400ULL,
0x0000004a004a7245ULL, 0x004fce000020d400ULL, 0x0000004b00497306ULL, 0x000e620000205400ULL,
0x000000626300720bULL, 0x008fda0003f9d000ULL, 0x000000014a4a4812ULL, 0x000fe400078efcffULL,
0x000000494800720bULL, 0x002fe40003fbd000ULL, 0x0000004700487245ULL, 0x000fe4000020d400ULL,
0x0000004b00477245ULL, 0x000fe4000020d400ULL, 0x0000000148483812ULL, 0x000fe400078efcffULL,
0x0000004a4646723eULL, 0x000fca00000010ffULL, 0x0000000147475812ULL, 0x000fc800078efcffULL,
0x000000474847723eULL, 0x000fce00000010ffULL, 0x000000461c1c723cULL, 0x000b620000041824ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff247f8cULL, 0x020e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000528007c0cULL, 0x000fe2000bf03070ULL, 0x01069800ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff487224ULL, 0x002fe200078e0025ULL, 0x000000032f4d7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff247224ULL, 0x000fd200078e005cULL, 0x0000607000000947ULL, 0x000fea0003800000ULL,
0x0000000000247805ULL, 0x000fc40000015200ULL, 0x0106bc00ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe40007804848ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff467224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x00000026242c7210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09002c00780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402c00780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff267819ULL, 0x000fc80000011427ULL, 0x0000002c26267211ULL, 0x000fca00078110ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x0000000226267819ULL, 0x000fc80000001227ULL,
0x000000260000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000146467810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106bc00ff267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fe40007804848ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000046000009947ULL, 0x000fea0003800000ULL,
0x0000000238467810ULL, 0x040fe20007ffe0ffULL, 0x000000012b247824ULL, 0x040fe200078e0238ULL,
0x000000e004057891ULL, 0x000fe2000f8e403fULL, 0x0000000438477810ULL, 0x000fe40007ffe0ffULL,
0x0000000124257824ULL, 0x000fe200078e0202ULL, 0x0000000638517810ULL, 0x000fe20007ffe0ffULL,
0x00000010244e7824ULL, 0x000fe200078e00ffULL, 0x000000f0304d7812ULL, 0x000fe200078ec0ffULL,
0x000000012b267824ULL, 0x000fc400078e0246ULL, 0x000000012b2c7824ULL, 0x000fe200078e0247ULL,
0xfffffff04e4e7812ULL, 0x000fe200078ee225ULL, 0x0000000126277824ULL, 0x140fe200078e0202ULL,
0x0000002003257811ULL, 0x000fe200078e30ffULL, 0x00000010264f7824ULL, 0x000fe200078e00ffULL,
0x0000e0004e4e7811ULL, 0x000fe200078e20ffULL, 0x000000012c487824ULL, 0x000fe400078e0202ULL,
0x00000001264b7824ULL, 0x000fe200078e0225ULL, 0xfffffff04f4f7812ULL, 0x000fe200078ee227ULL,
0x0000000124277824ULL, 0x000fe200078e0225ULL, 0x0000000528247c17ULL, 0x000fe2000f800000ULL,
0x000000102c507824ULL, 0x000fe200078e00ffULL, 0x0000004c4b4b7210ULL, 0x000fe20007f3e0ffULL,
0x000000012b497824ULL, 0x000fe200078e0251ULL, 0x8000000524247c10ULL, 0x000fc4000fffe0ffULL,
0xfffffff050507812ULL, 0x000fe200078ee248ULL, 0x000000012c487824ULL, 0x100fe200078e0225ULL,
0x000000242b247217ULL, 0x000fe20007800000ULL, 0x00000001492c7824ULL, 0x000fe200078e0225ULL,
0x0000004c27277210ULL, 0x080fe20007f1e0ffULL, 0x0000000149257824ULL, 0x000fe200078e0202ULL,
0x00005e004b4a7a11ULL, 0x000fe200078440ffULL, 0x0000001049527824ULL, 0x000fe200078e00ffULL,
0x0000004c48487210ULL, 0x080fe20007f9e0ffULL, 0x0000000124267824ULL, 0x000fe200078e0a2bULL,
0x0000004c2c2c7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff247224ULL, 0x000fe200008e06ffULL,
0xfffffff052527812ULL, 0x000fe200078ee225ULL, 0x000000ffff4c7224ULL, 0x000fe200000e06ffULL,
0x00005e0027257a11ULL, 0x000fe200078040ffULL, 0x000000ffff497224ULL, 0x000fe200020e06ffULL,
0x00005f004b4b7a11ULL, 0x000fc400010f4424ULL, 0x000000263800720cULL, 0x080fe40003f46070ULL,
0x00005f00274c7a11ULL, 0x000fe200000f444cULL, 0x000000ffff277224ULL, 0x000fe200018e06ffULL,
0x0000004d25247210ULL, 0x000fe40007fbe0ffULL, 0x000000264700720cULL, 0x080fe40003f06070ULL,
0x00005e0048477a11ULL, 0x000fe200078840ffULL, 0x000000ffff257224ULL, 0x000fe200028e064cULL,
0x000000264600720cULL, 0x000fc40003f26070ULL, 0x00005e002c467a11ULL, 0x000fe400078c40ffULL,
0x000000265100720cULL, 0x000fe20003f66070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000244e7faeULL, 0x0003e2000d101c46ULL, 0x00005f0048487a11ULL, 0x000fe400020f4449ULL,
0x0000004d47267210ULL, 0x080fe40007f9e0ffULL, 0x00005f002c2c7a11ULL, 0x000fe400030f4427ULL,
0x0000004d46467210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff277224ULL, 0x000fe200020e0648ULL,
0x0000e0004f4f7811ULL, 0x000fc400078e20ffULL, 0x0000e00050507811ULL, 0x000fe200078e20ffULL,
0x000000ffff477224ULL, 0x000fe200028e062cULL, 0x0000004d4a247210ULL, 0x002fe40007f5e0ffULL,
0x0000e00052527811ULL, 0x000fc600078e20ffULL, 0x000000ffff257224ULL, 0x000fca00010e064bULL,
0x00000000244f7faeULL, 0x0003e8000c901c46ULL, 0x0000000026507faeULL, 0x0003e8000c101c46ULL,
0x0000000046527faeULL, 0x0003e2000d901c46ULL, 0x0000039000007947ULL, 0x000fea0003800000ULL,
0x000000012b247824ULL, 0x000fe200078e0238ULL, 0x0000002003257811ULL, 0x000fc600078e30ffULL,
0x0000000124267824ULL, 0x040fe200078e0202ULL, 0x0000000224277810ULL, 0x040fe20007ffe0ffULL,
0x00000010244d7824ULL, 0x000fc800078e00ffULL, 0x00000001272c7824ULL, 0x000fe200078e0202ULL,
0xfffffff04d4d7812ULL, 0x000fe200078ee226ULL, 0x00000010274e7824ULL, 0x000fe400078e00ffULL,
0x0000000124267824ULL, 0x000fe200078e0225ULL, 0x0000e0004d4d7811ULL, 0x000fe200078e20ffULL,
0x00000001254a7824ULL, 0x000fe200078e0227ULL, 0xfffffff04e4e7812ULL, 0x000fe400078ee22cULL,
0x00000004242c7810ULL, 0x040fe40007ffe0ffULL, 0x0000000624247810ULL, 0x000fc40007ffe0ffULL,
0x0000004c26267210ULL, 0x080fe20007f5e0ffULL, 0x0000000125277824ULL, 0x040fe200078e022cULL,
0x0000004c4a4a7210ULL, 0x080fe20007f1e0ffULL, 0x0000000125467824ULL, 0x000fe200078e0224ULL,
0x00005e0026487a11ULL, 0x000fe200078640ffULL, 0x0000000124477824ULL, 0x140fe200078e0202ULL,
0x0000004c27277210ULL, 0x080fe20007f3e0ffULL, 0x0000001024507824ULL, 0x000fe200078e00ffULL,
0x0000e0004e4e7811ULL, 0x000fe200078e20ffULL, 0x000000012c257824ULL, 0x040fe400078e0202ULL,
0x000000102c4f7824ULL, 0x000fe200078e00ffULL, 0xfffffff050507812ULL, 0x000fe200078ee247ULL,
0x000000ffff247224ULL, 0x000fe200010e06ffULL, 0x0000004c462c7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff497224ULL, 0x000fe200000e06ffULL, 0xfffffff04f4f7812ULL, 0x000fe200078ee225ULL,
0x000000ffff257224ULL, 0x000fe200008e06ffULL, 0x00005f00264b7a11ULL, 0x000fe200018f4424ULL,
0x000000ffff247224ULL, 0x000fe200010e06ffULL, 0x000000f0304c7812ULL, 0x000fc400078ec0ffULL,
0x00005e004a477a11ULL, 0x000fe400078040ffULL, 0x00005e002c467a11ULL, 0x000fe400078440ffULL,
0x00005e0027267a11ULL, 0x040fe400078240ffULL, 0x0000004c48487210ULL, 0x000fe40007f7e0ffULL,
0x00005f004a4a7a11ULL, 0x000fe400000f4449ULL, 0x00005f002c2c7a11ULL, 0x000fe200010f4424ULL,
0x000000ffff497224ULL, 0x000fe200018e064bULL, 0x00005f0027277a11ULL, 0x000fc400008f4425ULL,
0x0000004c47247210ULL, 0x080fe40007f1e0ffULL, 0x0000004c26267210ULL, 0x080fe20007f3e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000484d7faeULL, 0x0003e2000b901c46ULL,
0x0000004c46467210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff257224ULL, 0x000fe200000e064aULL,
0x0000e0004f4f7811ULL, 0x000fe200078e20ffULL, 0x000000ffff277224ULL, 0x000fe200008e0627ULL,
0x0000e00050507811ULL, 0x000fe200078e20ffULL, 0x000000ffff477224ULL, 0x000fe200010e062cULL,
0x00000000244e7faeULL, 0x0003e8000b901c46ULL, 0x00000000264f7faeULL, 0x0003e8000b901c46ULL,
0x0000000046507faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0xffffffffff2c7424ULL, 0x000fe200078e00ffULL, 0x000000042f247810ULL, 0x000fc80007ffe0ffULL,
0x000000292400720cULL, 0x000fda0003f06070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x000000012e247824ULL, 0x000fe400078e0224ULL, 0x00000004ff257424ULL, 0x000fc800078e00ffULL,
0x0000600024247625ULL, 0x000fca00078e0025ULL, 0x00000006242c7981ULL, 0x000324000c1e1900ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b000ff267f8cULL, 0x000ea2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010668002b487f8cULL, 0x000664000c80043fULL,
0x0000000000247805ULL, 0x002fc40000015200ULL, 0x01066c002b467984ULL, 0x000e640000000800ULL,
0x8000000046ff7812ULL, 0x002fe40007804849ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4b7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104b00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000467805ULL, 0x000fcc0000015200ULL,
0x00000046244a7210ULL, 0x000fca0007f1e1ffULL, 0x0000000147477824ULL, 0x000fe200000e0e25ULL,
0x003d09004a00780cULL, 0x000fc80003f06070ULL, 0x000000ff4700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404a00780cULL, 0x000fc80003f06070ULL,
0x000000ff4700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff467819ULL, 0x000fc80000011447ULL, 0x0000004a46467211ULL, 0x000fca00078110ffULL,
0x000000ffff477224ULL, 0x000fca00000e0647ULL, 0x0000000246467819ULL, 0x000fc80000001247ULL,
0x000000460000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000014b4b7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01066c002b467984ULL, 0x000e640000000800ULL, 0x8000000046ff7812ULL, 0x002fe40007804849ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0101800031257984ULL, 0x000e680000000800ULL,
0x0103800031467984ULL, 0x0006a20000000800ULL, 0x0000005c2500720bULL, 0x002fe20003f1d000ULL,
0x0000ca827f007947ULL, 0x000fd8000b800000ULL, 0x0000000000477806ULL, 0x008fc800000e0100ULL,
0x0000ffff47ff7812ULL, 0x000fe2000780c0ffULL, 0x000004a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff4a7424ULL, 0x000fc400078e00ffULL, 0x000000ffff247224ULL, 0x000fd200078e005cULL,
0x0000046000008947ULL, 0x000fea0003800000ULL, 0x000000030000780cULL, 0x000fe40003f05270ULL,
0x0000005c2500720bULL, 0x000fe20003f34000ULL, 0x0000ca427f007947ULL, 0x000fd8000b800000ULL,
0x0000000000247806ULL, 0x000fc400008e0100ULL, 0x0000005c25328209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe80003800000ULL, 0x0105803231008388ULL, 0x0003e40000000800ULL,
0x0000991024317816ULL, 0x002fc800000000ffULL, 0x000000ff3100720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000005c25317209ULL, 0x000fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff24ff7812ULL, 0x000fc6000780c0ffULL,
0x0000005c31317221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b31317820ULL, 0x000fc80000410000ULL,
0x0000003100327308ULL, 0x000e640000000800ULL, 0x000000322d2d7220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff317819ULL, 0x000fe20000011602ULL,
0x0000c9827f007947ULL, 0x000fea000b800000ULL, 0x00001f3132317589ULL, 0x0002e400000e0000ULL,
0x0000003118187220ULL, 0x088fe20000410000ULL, 0x0000003119197220ULL, 0x080fe20000410000ULL,
0x0000003114147220ULL, 0x080fe20000410000ULL, 0x0000003115157220ULL, 0x080fe20000410000ULL,
0x0000003110107220ULL, 0x080fe20000410000ULL, 0x0000003111117220ULL, 0x080fe20000410000ULL,
0x000000310c0c7220ULL, 0x080fe20000410000ULL, 0x000000310d0d7220ULL, 0x080fe20000410000ULL,
0x0000003108087220ULL, 0x080fe20000410000ULL, 0x0000003109097220ULL, 0x080fe20000410000ULL,
0x0000003104047220ULL, 0x080fe20000410000ULL, 0x0000003105057220ULL, 0x080fe20000410000ULL,
0x0000003120207220ULL, 0x080fe20000410000ULL, 0x0000003121217220ULL, 0x080fe20000410000ULL,
0x000000311c1c7220ULL, 0x080fe20000410000ULL, 0x000000311d1d7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0024ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000802317811ULL, 0x000fe200078ff0ffULL,
0x0000c8827f007947ULL, 0x000fea000b800000ULL, 0x00001f3132317589ULL, 0x00066400000e0000ULL,
0x000000311a1a7220ULL, 0x082fe20000410000ULL, 0x000000311b1b7220ULL, 0x080fe20000410000ULL,
0x0000003116167220ULL, 0x080fe20000410000ULL, 0x0000003117177220ULL, 0x080fe20000410000ULL,
0x0000003112127220ULL, 0x080fe20000410000ULL, 0x0000003113137220ULL, 0x080fe20000410000ULL,
0x000000310e0e7220ULL, 0x080fe20000410000ULL, 0x000000310f0f7220ULL, 0x080fe20000410000ULL,
0x000000310a0a7220ULL, 0x080fe20000410000ULL, 0x000000310b0b7220ULL, 0x080fe20000410000ULL,
0x0000003106067220ULL, 0x080fe20000410000ULL, 0x0000003107077220ULL, 0x080fe20000410000ULL,
0x0000003122227220ULL, 0x080fe20000410000ULL, 0x0000003123237220ULL, 0x080fe20000410000ULL,
0x000000311e1e7220ULL, 0x080fe20000410000ULL, 0x000000311f1f7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000ffff24ff7812ULL, 0x000fe20007800847ULL,
0x00000001ff4a7424ULL, 0x000fe200078e00ffULL, 0x0000005c255c7209ULL, 0x000fca0007810000ULL,
0x000000ffff247224ULL, 0x000fcc00078e005cULL, 0x8000005c25250221ULL, 0x100fe20000010000ULL,
0x000000ffff240224ULL, 0x000fe200078e005cULL, 0x00007610ff4a0816ULL, 0x000fe4000000004aULL,
0x3fb8aa3b25250820ULL, 0x000fc80000410000ULL, 0x0000002500350308ULL, 0x000e640000000800ULL,
0x0000003546460220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002d462d7221ULL, 0x004fc40000010000ULL, 0x0000000000467805ULL, 0x000fca0000015200ULL,
0x0106ac00ff257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe40007804845ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff327224ULL, 0x008fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000487805ULL, 0x000fcc0000015200ULL, 0x0000004846317210ULL, 0x000fca0007f1e1ffULL,
0x0000000149487824ULL, 0x000fe200000e0e47ULL, 0x003d09003100780cULL, 0x000fc80003f06070ULL,
0x000000ff4800720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403100780cULL, 0x000fc80003f06070ULL, 0x000000ff4800720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff257819ULL, 0x000fc80000011448ULL,
0x0000003125257211ULL, 0x000fca00078110ffULL, 0x000000ffff317224ULL, 0x000fca00000e0648ULL,
0x0000000225257819ULL, 0x000fc80000001231ULL, 0x000000250000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000132327810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106ac00ff257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe40007804845ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099104a257816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff2500720cULL, 0x000fda0003f25270ULL, 0x0000012000001947ULL, 0x000fea0003800000ULL,
0x00000035ff25723eULL, 0x000fe400000010ffULL, 0x00000002ff317819ULL, 0x000fe40000011602ULL,
0x0000541025257816ULL, 0x000fe20000000025ULL, 0x0000c4527f007947ULL, 0x000fea000b800000ULL,
0x00001f3125367589ULL, 0x0002a400000e0000ULL, 0x0000000831377810ULL, 0x000fe20007ffe0ffULL,
0x0000c4827f007947ULL, 0x000fea000b800000ULL, 0x00001f3725377589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001031497810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4a7224ULL, 0x000fe200078e0025ULL, 0x00014d7000487802ULL, 0x000fc40000000f00ULL,
0x0000ca1000007944ULL, 0x01efea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001831497810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff4a7224ULL, 0x004fe200078e0025ULL,
0x00014dc000487802ULL, 0x000fc40000000f00ULL, 0x0000c9c000007944ULL, 0x01afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000003948783bULL, 0x004ea20000004200ULL, 0x0000b8003e3e7811ULL, 0x000fc400078e20ffULL,
0x0000b8003d3d7811ULL, 0x000fe200078e20ffULL, 0x000000003a4c783bULL, 0x000ee80000004200ULL,
0x000000003b50783bULL, 0x000e680000004200ULL, 0x000000003c54783bULL, 0x000e620000004200ULL,
0x0001000048b87824ULL, 0x004fe200078e00ffULL, 0x0000004900a87306ULL, 0x000fe20000009400ULL,
0x00000018ffa57819ULL, 0x000fe20000011448ULL, 0x000001004bad7824ULL, 0x040fe200078e00ffULL,
0x00000018ffa07819ULL, 0x000fe20000011449ULL, 0x000100004ab07824ULL, 0x000fe200078e00ffULL,
0x00000018ffb87819ULL, 0x000fe200000114b8ULL, 0x0000010048b57824ULL, 0x000fe200078e00ffULL,
0x00000018ffad7819ULL, 0x000fe200000114adULL, 0x0000004900aa7306ULL, 0x000ea20000005400ULL,
0x00000018ffb07819ULL, 0x000fe200000114b0ULL, 0x000100004bb27824ULL, 0x000fe200078e00ffULL,
0x00000018ffb57819ULL, 0x000fe200000114b5ULL, 0x0000010049ae7824ULL, 0x040fe200078e00ffULL,
0x00000018ff977819ULL, 0x000fe2000001144aULL, 0x000001004aab7824ULL, 0x000fe200078e00ffULL,
0x00000018ff967819ULL, 0x000fe2000001144bULL, 0x000000b800d47306ULL, 0x000fe20000209400ULL,
0x00000018ffb27819ULL, 0x000fe200000114b2ULL, 0x000100004cb37824ULL, 0x008fe200078e00ffULL,
0x00000018ffae7819ULL, 0x000fe200000114aeULL, 0x0001000049b47824ULL, 0x000fe200078e00ffULL,
0x00000018ff8f7819ULL, 0x000fe2000001144cULL, 0x000100004db17824ULL, 0x000fe200078e00ffULL,
0x00000018ffb37819ULL, 0x000fe200000114b3ULL, 0x000000b800d37306ULL, 0x0006e20000205400ULL,
0x000000aaa800720bULL, 0x004fe20003f7d000ULL, 0x0001000051dc7824ULL, 0x002fe200078e00ffULL,
0x00000018ffb47819ULL, 0x000fe200000114b4ULL, 0x000100004eaf7824ULL, 0x000fe200078e00ffULL,
0x00000018ffab7819ULL, 0x000fe200000114abULL, 0x0000010052dd7824ULL, 0x040fe200078e00ffULL,
0x00000018ffb17819ULL, 0x000fe200000114b1ULL, 0x000000a500a97306ULL, 0x000fe20000209400ULL,
0x000000b800b87245ULL, 0x008fe2000020d400ULL, 0x0000010053d87824ULL, 0x000fe200078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe2000001144fULL, 0x0000010051db7824ULL, 0x000fe200078e00ffULL,
0x00000018ffdc7819ULL, 0x000fe200000114dcULL, 0x0001000052d77824ULL, 0x000fe200078e00ffULL,
0x00000018ff827819ULL, 0x000fe20000011450ULL, 0x000000a500a77306ULL, 0x0002a20000205400ULL,
0x000000d3d400720bULL, 0x000fe20003f9d000ULL, 0x0001000053d67824ULL, 0x000fe200078e00ffULL,
0x00000018ff8e7819ULL, 0x000fc4000001144dULL, 0x00000018ffaf7819ULL, 0x000fe400000114afULL,
0x00000018ffdd7819ULL, 0x000fe200000114ddULL, 0x000000a000a47306ULL, 0x000fe20000209400ULL,
0x000000a500a57245ULL, 0x002fe4000020d400ULL, 0x00000018ff7d7819ULL, 0x000fe4000001144eULL,
0x00000018ffd87819ULL, 0x000fe400000114d8ULL, 0x00000001b8b84812ULL, 0x000fe200078efcffULL,
0x000000a000a37306ULL, 0x0002e20000205400ULL, 0x000000a7a900720bULL, 0x004fc40003fbd000ULL,
0x00000018ffa77819ULL, 0x000fe400000114dbULL, 0x00000018ff687819ULL, 0x000fe40000011452ULL,
0x00000018ffd77819ULL, 0x000fe200000114d7ULL, 0x0000004a00a67306ULL, 0x000fe20000009400ULL,
0x000000a000a07245ULL, 0x002fe4000020d400ULL, 0x00000018ff727819ULL, 0x000fe40000011451ULL,
0x00000018ff657819ULL, 0x000fc40000011453ULL, 0x00000001a5a55812ULL, 0x000fe200078efcffULL,
0x0000004a00ac7306ULL, 0x000e620000005400ULL, 0x000000a3a400720bULL, 0x008fe40003f9d000ULL,
0x00000018ffd67819ULL, 0x000fe400000114d6ULL, 0x00000018ff5b7819ULL, 0x000fe40000011454ULL,
0x00000018ff3b7819ULL, 0x000fe20000011455ULL, 0x0000004900737306ULL, 0x0004e2000000d400ULL,
0x00000018ff257819ULL, 0x000fc40000011456ULL, 0x00000018ff317819ULL, 0x000fe40000011457ULL,
0x000000b8a5b8723eULL, 0x000fe400000010ffULL, 0x00000001a0a04812ULL, 0x000fe200078efcffULL,
0x000000ad00bd7306ULL, 0x000fe20000209400ULL, 0x000000aca600720bULL, 0x002fe20003f1d000ULL,
0x000001004e497824ULL, 0x004fca00078e00ffULL, 0x00000018ff497819ULL, 0x000fe20000011449ULL,
0x000000ad00c37306ULL, 0x0002a20000205400ULL, 0x0000000173733812ULL, 0x008fce00078efcffULL,
0x0000004b00a17306ULL, 0x000fe20000009400ULL, 0x000000ad00ad7245ULL, 0x002fce000020d400ULL,
0x0000004b00a27306ULL, 0x000e620000005400ULL, 0x000000c3bd00720bULL, 0x004fce0003f7d000ULL,
0x000000b000bc7306ULL, 0x000fec0000209400ULL, 0x00000001adad3812ULL, 0x000fe400078efcffULL,
0x000000b000c17306ULL, 0x0004e20000205400ULL, 0x000000a2a100720bULL, 0x002fce0003fbd000ULL,
0x000000b500d97306ULL, 0x000fe20000209400ULL, 0x000000b000b07245ULL, 0x004fce000020d400ULL,
0x000000b500da7306ULL, 0x0002a20000205400ULL, 0x000000c1bc00720bULL, 0x008fce0003f9d000ULL,
0x0000004b006c7306ULL, 0x0006a2000000d400ULL, 0x000000b500b57245ULL, 0x002fca000020d400ULL,
0x00000001b0b04812ULL, 0x000fe400078efcffULL, 0x0000004a006d7306ULL, 0x000262000000d400ULL,
0x000001004c4b7824ULL, 0x008fe200078e00ffULL, 0x000000dad900720bULL, 0x004fc80003fdd000ULL,
0x00000018ff4b7819ULL, 0x000fe4000001144bULL, 0x00000097009d7306ULL, 0x000fe20000209400ULL,
0x000001004d4a7824ULL, 0x002fe200078e00ffULL, 0x000000016c6c5812ULL, 0x000fc800078efcffULL,
0x00000018ff4a7819ULL, 0x000fe4000001144aULL, 0x00000097009b7306ULL, 0x0002a20000205400ULL,
0x000000016d6d0812ULL, 0x000fe400078efcffULL, 0x00000001b5b56812ULL, 0x000fca00078efcffULL,
0x000000b200cb7306ULL, 0x000fe20000209400ULL, 0x0000009700977245ULL, 0x002fce000020d400ULL,
0x000000b200cc7306ULL, 0x0002e20000205400ULL, 0x0000009b9d00720bULL, 0x004fce0003f1d000ULL,
0x0000009600997306ULL, 0x000fe20000209400ULL, 0x000000b200b27245ULL, 0x002fca000020d400ULL,
0x0000000197970812ULL, 0x000fe400078efcffULL, 0x0000009600987306ULL, 0x0002a20000205400ULL,
0x000000cccb00720bULL, 0x008fe40003f7d000ULL, 0x000000b097b0723eULL, 0x000fca00000010ffULL,
0x0000004b00bb7306ULL, 0x000fe20000209400ULL, 0x0000009600967245ULL, 0x002fca000020d400ULL,
0x00000001b2b23812ULL, 0x000fe400078efcffULL, 0x0000004b00b67306ULL, 0x000e620000205400ULL,
0x000000989900720bULL, 0x004fce0003fbd000ULL, 0x0000004800d17306ULL, 0x000fec0000009400ULL,
0x0000000196965812ULL, 0x000fe400078efcffULL, 0x0000004800d27306ULL, 0x000ea20000005400ULL,
0x000000b6bb00720bULL, 0x002fce0003f9d000ULL, 0x000000ae00d07306ULL, 0x000ff00000209400ULL,
0x000000ae00d57306ULL, 0x0002e20000205400ULL, 0x000000d2d100720bULL, 0x004fce0003f5d000ULL,
0x0000004a00ba7306ULL, 0x000fe20000209400ULL, 0x000000ae00ae7245ULL, 0x002fce000020d400ULL,
0x0000004a00c07306ULL, 0x000e620000205400ULL, 0x000000d5d000720bULL, 0x008fce0003fdd000ULL,
0x0000004e00947306ULL, 0x000fec0000009400ULL, 0x00000001aeae6812ULL, 0x000fe400078efcffULL,
0x0000004e00957306ULL, 0x000ea20000005400ULL, 0x000000c0ba00720bULL, 0x002fce0003f1d000ULL,
0x0000008f00937306ULL, 0x000ff00000209400ULL, 0x0000008f00927306ULL, 0x0002e20000205400ULL,
0x000000959400720bULL, 0x004fe40003f7d000ULL, 0x0000004b00947245ULL, 0x000fc8000020d400ULL,
0x0000000194944812ULL, 0x000fe200078efcffULL, 0x000000b300b77306ULL, 0x000fe20000209400ULL,
0x0000008f008f7245ULL, 0x002fce000020d400ULL, 0x000000b300c47306ULL, 0x0002a20000205400ULL,
0x000000929300720bULL, 0x008fe40003f9d000ULL, 0x0000004a00927245ULL, 0x000fc8000020d400ULL,
0x0000000192920812ULL, 0x000fe200078efcffULL, 0x0000004800747306ULL, 0x0006a2000000d400ULL,
0x000000b300b37245ULL, 0x002fca000020d400ULL, 0x000000018f8f4812ULL, 0x000fe400078efcffULL,
0x000000b400cf7306ULL, 0x000fe20000209400ULL, 0x000001004f487824ULL, 0x008fe200078e00ffULL,
0x000000c4b700720bULL, 0x004fc80003fbd000ULL, 0x00000018ff487819ULL, 0x000fe40000011448ULL,
0x000000b400cd7306ULL, 0x0002a20000205400ULL, 0x0000000174742812ULL, 0x000fc800078efcffULL,
0x00000074b574723eULL, 0x000fe400000010ffULL, 0x00000001b3b35812ULL, 0x000fe200078efcffULL,
0x000000ab00be7306ULL, 0x000fe20000209400ULL, 0x000000b400b47245ULL, 0x002fce000020d400ULL,
0x000000ab00bf7306ULL, 0x0002e20000205400ULL, 0x000000cdcf00720bULL, 0x004fce0003f5d000ULL,
0x000000b100c97306ULL, 0x000fe20000209400ULL, 0x000000ab00ab7245ULL, 0x002fca000020d400ULL,
0x00000001b4b42812ULL, 0x000fe400078efcffULL, 0x000000b100ca7306ULL, 0x000e620000205400ULL,
0x000000bfbe00720bULL, 0x008fce0003fdd000ULL, 0x0000004f008c7306ULL, 0x000fec0000009400ULL,
0x00000001abab6812ULL, 0x000fe400078efcffULL, 0x0000004f008d7306ULL, 0x000ea20000005400ULL,
0x000000cac900720bULL, 0x002fce0003f1d000ULL, 0x0000004800c77306ULL, 0x000ff00000209400ULL,
0x0000004800ce7306ULL, 0x000e620000205400ULL, 0x0000008d8c00720bULL, 0x004fe40003fbd000ULL,
0x000000b1008d7245ULL, 0x000fc4000020d400ULL, 0x00000049008c7245ULL, 0x000fe4000020d400ULL,
0x000000018d8d0812ULL, 0x000fe200078efcffULL, 0x0000004c009f7306ULL, 0x000fe20000009400ULL,
0x000000b296b1723eULL, 0x000fce00000010ffULL, 0x0000004c009e7306ULL, 0x000ea20000005400ULL,
0x000000cec700720bULL, 0x002fce0003f9d000ULL, 0x0000004d009c7306ULL, 0x000ff00000009400ULL,
0x0000004d009a7306ULL, 0x000e620000005400ULL, 0x0000009e9f00720bULL, 0x004fce0003f5d000ULL,
0x0000004c006b7306ULL, 0x0004f0000000d400ULL, 0x0000005000867306ULL, 0x000fe20000009400ULL,
0x000100004f4c7824ULL, 0x004fe200078e00ffULL, 0x0000009a9c00720bULL, 0x002fc80003fdd000ULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x0000005000877306ULL, 0x000e620000005400ULL,
0x000000016b6b2812ULL, 0x008fc800078efcffULL, 0x0000006b9494723eULL, 0x000fc600000010ffULL,
0x0000004f00627306ULL, 0x000eb0000000d400ULL, 0x0000004c00c57306ULL, 0x000fe20000209400ULL,
0x000000878600720bULL, 0x002fe40003f1d000ULL, 0x0000004800867245ULL, 0x000fc8000020d400ULL,
0x0000000186864812ULL, 0x000fe200078efcffULL, 0x0000004c004f7306ULL, 0x000e620000205400ULL,
0x0000000162625812ULL, 0x004fce00078efcffULL, 0x0000004d006a7306ULL, 0x0004f0000000d400ULL,
0x0000004900c87306ULL, 0x000fe20000209400ULL, 0x0000004fc500720bULL, 0x002fe20003f9d000ULL,
0x00000100504d7824ULL, 0x004fca00078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe2000001144dULL,
0x0000004900c27306ULL, 0x0002a20000205400ULL, 0x000000016a6a6812ULL, 0x008fce00078efcffULL,
0x00000050005d7306ULL, 0x0006e2000000d400ULL, 0x000000003e48783bULL, 0x0022ee0000000200ULL,
0x000000dc009e7306ULL, 0x000fe20000209400ULL, 0x000000c2c800720bULL, 0x004fe20003fdd000ULL,
0x0001000050507824ULL, 0x008fe200078e00ffULL, 0x0000004c003e7245ULL, 0x002fc4000020d400ULL,
0x0000006dab4c723eULL, 0x000fe400000010ffULL, 0x000000013e3e4812ULL, 0x000fe200078efcffULL,
0x000000dc009a7306ULL, 0x000e620000205400ULL, 0x000000015d5d0812ULL, 0x000fe400078efcffULL,
0x00000018ffd27819ULL, 0x000fe20000011450ULL, 0x0000010057507824ULL, 0x000fe400078e00ffULL,
0x000000018c8c6812ULL, 0x000fe400078efcffULL, 0x0000008200837306ULL, 0x000ff00000209400ULL,
0x0000008200777306ULL, 0x0004e20000205400ULL, 0x0000009a9e00720bULL, 0x002fce0003f1d000ULL,
0x0000008e00907306ULL, 0x000fe20000209400ULL, 0x0000003648489231ULL, 0x080fe200003400ffULL,
0x0000008200827245ULL, 0x004fe2000020d400ULL, 0x000000364a4a9231ULL, 0x000fe400003400ffULL,
0x0000003749499231ULL, 0x080fe400003400ffULL, 0x000000374b4b9231ULL, 0x000fe200003400ffULL,
0x0000008e00917306ULL, 0x0002a20000205400ULL, 0x000000778300720bULL, 0x008fe40003f9d000ULL,
0x000000dc00837245ULL, 0x000fc4000020d400ULL, 0x0000004d00777245ULL, 0x000fe2000020d400ULL,
0x000000b0480c723cULL, 0x000fe2000004180cULL, 0x0000000183830812ULL, 0x000fe200078efcffULL,
0x000000af00b97306ULL, 0x000fe20000209400ULL, 0x0000008e008e7245ULL, 0x002fca000020d400ULL,
0x0000000182824812ULL, 0x000fe400078efcffULL, 0x000000af00c67306ULL, 0x0002e20000205400ULL,
0x000000919000720bULL, 0x004fce0003f5d000ULL, 0x0000007e00857306ULL, 0x000fe20000209400ULL,
0x000000af00af7245ULL, 0x002fca000020d400ULL, 0x000000018e8e2812ULL, 0x000fe400078efcffULL,
0x0000007e00847306ULL, 0x0002a20000205400ULL, 0x000000c6b900720bULL, 0x008fe40003fdd000ULL,
0x000000b4a0b9723eULL, 0x000fca00000010ffULL, 0x000000dd00987306ULL, 0x000fe20000209400ULL,
0x0000007e007e7245ULL, 0x002fe2000020d400ULL, 0x000000b84814723cULL, 0x000f680000041814ULL,
0x00000001afaf6812ULL, 0x000fe400078efcffULL, 0x000000dd00957306ULL, 0x0002e20000205400ULL,
0x000000848500720bULL, 0x004fce0003fbd000ULL, 0x0000004e00637306ULL, 0x000ea2000000d400ULL,
0x000000dd00dd7245ULL, 0x002fca000020d400ULL, 0x000000017e7e5812ULL, 0x000fe400078efcffULL,
0x0000007d008a7306ULL, 0x000fe20000209400ULL, 0x000000959800720bULL, 0x008fe40003f1d000ULL,
0x0000006a9295723eULL, 0x000fca00000010ffULL, 0x0000007d008b7306ULL, 0x0002e20000205400ULL,
0x0000000163633812ULL, 0x004fe200078efcffULL, 0x000000944808723cULL, 0x000fe60000041808ULL,
0x000000638c8c723eULL, 0x000fe400000010ffULL, 0x00000001dddd0812ULL, 0x000fe200078efcffULL,
0x0000004d004e7306ULL, 0x000fe20000209400ULL, 0x0000007d007d7245ULL, 0x002fce000020d400ULL,
0x0000004d00d17306ULL, 0x0002a20000205400ULL, 0x0000008b8a00720bULL, 0x008fce0003f7d000ULL,
0x0000005200767306ULL, 0x000fe20000009400ULL, 0x0000006cad4d723eULL, 0x002fca00000010ffULL,
0x000000017d7d3812ULL, 0x000fe400078efcffULL, 0x00000052007b7306ULL, 0x000e620000005400ULL,
0x000000d14e00720bULL, 0x004fce0003fdd000ULL, 0x000000d800937306ULL, 0x000fec0000209400ULL,
0x0000000177776812ULL, 0x000fe400078efcffULL, 0x000000d800917306ULL, 0x0004e20000205400ULL,
0x0000007b7600720bULL, 0x002fce0003fbd000ULL, 0x000000d200d37306ULL, 0x000fe20000209400ULL,
0x000000d800d87245ULL, 0x004fce000020d400ULL, 0x000000d200a67306ULL, 0x0002a20000205400ULL,
0x000000919300720bULL, 0x008fce0003f1d000ULL, 0x0000005100887306ULL, 0x000fe20000009400ULL,
0x000000d200d27245ULL, 0x002fca000020d400ULL, 0x00000001d8d80812ULL, 0x000fe400078efcffULL,
0x0000005100897306ULL, 0x000e620000005400ULL, 0x000000a6d300720bULL, 0x004fce0003f7d000ULL,
0x000000a700a37306ULL, 0x000fec0000209400ULL, 0x00000001d2d23812ULL, 0x000fe400078efcffULL,
0x000000a700a17306ULL, 0x0004e20000205400ULL, 0x000000898800720bULL, 0x002fe40003f5d000ULL,
0x000000d28282723eULL, 0x000fca00000010ffULL, 0x0000005200597306ULL, 0x0002e2000000d400ULL,
0x000000a700a77245ULL, 0x004fce000020d400ULL, 0x00000068006f7306ULL, 0x000fe20000209400ULL,
0x0000010054527824ULL, 0x002fe200078e00ffULL, 0x000000a1a300720bULL, 0x008fc80003fdd000ULL,
0x00000018ff847819ULL, 0x000fe40000011452ULL, 0x00000068006e7306ULL, 0x0002a20000205400ULL,
0x0000000159595812ULL, 0x000fcc00078efcffULL, 0x00000001a7a76812ULL, 0x000fe200078efcffULL,
0x000000d700907306ULL, 0x000fe20000209400ULL, 0x0000006800687245ULL, 0x002fce000020d400ULL,
0x000000d700877306ULL, 0x0002e20000205400ULL, 0x0000006e6f00720bULL, 0x004fce0003fbd000ULL,
0x0000005300797306ULL, 0x000fe20000009400ULL, 0x000000d700d77245ULL, 0x002fca000020d400ULL,
0x0000000168685812ULL, 0x000fe400078efcffULL, 0x00000053007a7306ULL, 0x000e620000005400ULL,
0x000000879000720bULL, 0x008fce0003f1d000ULL, 0x00000051005f7306ULL, 0x0004ec000000d400ULL,
0x00000001d7d70812ULL, 0x000fe400078efcffULL, 0x0000005500757306ULL, 0x000fe20000009400ULL,
0x0000007a7900720bULL, 0x002fe20003f7d000ULL, 0x0000010056517824ULL, 0x004fe200078e00ffULL,
0x000000d76868723eULL, 0x000fca00000010ffULL, 0x0000005500787306ULL, 0x000e620000005400ULL,
0x000000015f5f2812ULL, 0x008fc800078efcffULL, 0x0000005fa75f723eULL, 0x000fc600000010ffULL,
0x00000072007f7306ULL, 0x000ff00000209400ULL, 0x0000007200807306ULL, 0x0004e20000205400ULL,
0x000000787500720bULL, 0x002fe40003fdd000ULL, 0x00000073ae75723eULL, 0x000fca00000010ffULL,
0x0000006500697306ULL, 0x000fe20000209400ULL, 0x0000007200727245ULL, 0x004fe2000020d400ULL,
0x000000744818723cULL, 0x000fec0000041818ULL, 0x0000006500677306ULL, 0x0002a20000205400ULL,
0x000000807f00720bULL, 0x008fce0003f5d000ULL, 0x0000008400527306ULL, 0x000fe20000209400ULL,
0x0000006500657245ULL, 0x002fca000020d400ULL, 0x0000000172722812ULL, 0x000fe400078efcffULL,
0x0000008400767306ULL, 0x0002e20000205400ULL, 0x000000676900720bULL, 0x004fe40003f1d000ULL,
0x000000d600697245ULL, 0x000fe4000020d400ULL, 0x000000837283723eULL, 0x000fc600000010ffULL,
0x00000053005a7306ULL, 0x0004e2000000d400ULL, 0x0000008400847245ULL, 0x002fca000020d400ULL,
0x0000000165650812ULL, 0x000fe400078efcffULL, 0x000000d6004f7306ULL, 0x000fe20000209400ULL,
0x0000010055537824ULL, 0x004fe200078e00ffULL, 0x000000765200720bULL, 0x008fe40003fbd000ULL,
0x000000b38f52723eULL, 0x000fe400000010ffULL, 0x00000018ff797819ULL, 0x000fe40000011453ULL,
0x000000d6004e7306ULL, 0x000e620000205400ULL, 0x000000015a5a3812ULL, 0x000fc400078efcffULL,
0x0000008d8e53723eULL, 0x000fe400000010ffULL, 0x00000062868d723eULL, 0x000fe400000010ffULL,
0x0000000184845812ULL, 0x000fe200078efcffULL, 0x0000005600717306ULL, 0x000fe20000009400ULL,
0x00000018ff627819ULL, 0x000fe20000011450ULL, 0x000000524804723cULL, 0x000fe20000041804ULL,
0x000000af7d50723eULL, 0x000fca00000010ffULL, 0x0000005600707306ULL, 0x000ea20000005400ULL,
0x0000004e4f00720bULL, 0x002fe20003f7d000ULL, 0x0000008c4820723cULL, 0x040fec0000041820ULL,
0x0000005400817306ULL, 0x000fe40000009400ULL, 0x0000004c484c723cULL, 0x000b640000041810ULL,
0x000000003d10783bULL, 0x0202e40000000200ULL, 0x0000000169693812ULL, 0x000fc400078efcffULL,
0x00000054007c7306ULL, 0x000e620000005400ULL, 0x000000707100720bULL, 0x004fe40003f5d000ULL,
0x000000696569723eULL, 0x000fe400000010ffULL, 0x00000018ff3d7819ULL, 0x002fe40000011451ULL,
0x0000003e7e51723eULL, 0x000fe200000010ffULL, 0x0000005b00607306ULL, 0x000fec0000209400ULL,
0x00000050481c723cULL, 0x000b64000004181cULL, 0x0000005b00617306ULL, 0x0002a20000205400ULL,
0x0000007c8100720bULL, 0x000fc80003f9d000ULL, 0x00000059dd48723eULL, 0x020fe400000010ffULL,
0x0000005ad849723eULL, 0x000fe200000010ffULL, 0x00000079007a7306ULL, 0x000fe20000209400ULL,
0x0000005b005b7245ULL, 0x002fce000020d400ULL, 0x0000007900787306ULL, 0x0002620000205400ULL,
0x000000616000720bULL, 0x004fe20003f1d000ULL, 0x0000003610109231ULL, 0x088fe400003400ffULL,
0x0000003612129231ULL, 0x000fc800003400ffULL, 0x0000005400467306ULL, 0x0004e2000000d400ULL,
0x0000007900797245ULL, 0x002fe2000020d400ULL, 0x0000003711119231ULL, 0x080fe400003400ffULL,
0x0000003713139231ULL, 0x000fe400003400ffULL, 0x000000015b5b0812ULL, 0x000fe400078efcffULL,
0x00000055003a7306ULL, 0x0002e2000000d400ULL, 0x0001000054547824ULL, 0x004fe200078e00ffULL,
0x000000787a00720bULL, 0x000fe20003fbd000ULL, 0x000000821014723cULL, 0x000b660000041814ULL,
0x00000018ff547819ULL, 0x000fc40000011454ULL, 0x0000003b005e7306ULL, 0x000fe20000209400ULL,
0x0001000055557824ULL, 0x002fe200078e00ffULL, 0x0000000146464812ULL, 0x008fe200078efcffULL,
0x00000048104c723cULL, 0x040b66000004184cULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x0000003b005c7306ULL, 0x0002a20000205400ULL, 0x0000000179795812ULL, 0x000fe400078efcffULL,
0x000000013a3a6812ULL, 0x000fe200078efcffULL, 0x00000068100c723cULL, 0x000b62000004180cULL,
0x000000468446723eULL, 0x000fc600000010ffULL, 0x0000005400737306ULL, 0x000fe20000209400ULL,
0x0000003b003b7245ULL, 0x002fce000020d400ULL, 0x0000005400707306ULL, 0x0002e20000205400ULL,
0x0000005c5e00720bULL, 0x004fe40003f9d000ULL, 0x0000005d775e723eULL, 0x000fca00000010ffULL,
0x00000055006c7306ULL, 0x000fe20000209400ULL, 0x0000005400547245ULL, 0x002fe2000020d400ULL,
0x0000005e1018723cULL, 0x000b680000041818ULL, 0x000000013b3b4812ULL, 0x000fe400078efcffULL,
0x00000055006d7306ULL, 0x0002a20000205400ULL, 0x000000707300720bULL, 0x008fce0003fbd000ULL,
0x0000003d006a7306ULL, 0x000fe20000209400ULL, 0x0000005500557245ULL, 0x002fca000020d400ULL,
0x0000000154545812ULL, 0x000fe400078efcffULL, 0x0000003d00677306ULL, 0x0002e20000205400ULL,
0x0000006d6c00720bULL, 0x004fe40003fdd000ULL, 0x000000545b54723eULL, 0x000fca00000010ffULL,
0x0000005600327306ULL, 0x0004e2000000d400ULL, 0x0000003d003d7245ULL, 0x002fca000020d400ULL,
0x0000000155556812ULL, 0x000fe400078efcffULL, 0x0000005700667306ULL, 0x000fe20000009400ULL,
0x0001000056567824ULL, 0x004fe200078e00ffULL, 0x000000676a00720bULL, 0x008fe40003f1d000ULL,
0x000000553b55723eULL, 0x000fe400000010ffULL, 0x00000018ff567819ULL, 0x000fe40000011456ULL,
0x0000005700647306ULL, 0x000e620000005400ULL, 0x0000000132322812ULL, 0x000fc400078efcffULL,
0x000000541004723cULL, 0x000b680000041804ULL, 0x000000013d3d0812ULL, 0x000fe200078efcffULL,
0x0000005700397306ULL, 0x0004f0000000d400ULL, 0x0000006200527306ULL, 0x000fe20000209400ULL,
0x0001000057577824ULL, 0x004fe200078e00ffULL, 0x000000646600720bULL, 0x002fc80003f7d000ULL,
0x00000018ff577819ULL, 0x000fe40000011457ULL, 0x0000006200537306ULL, 0x0002ae0000205400ULL,
0x0000000139393812ULL, 0x008fe200078efcffULL, 0x0000002500587306ULL, 0x000fe20000209400ULL,
0x0000006200627245ULL, 0x002fce000020d400ULL, 0x0000002500477306ULL, 0x0002e20000205400ULL,
0x000000535200720bULL, 0x004fce0003f9d000ULL, 0x00000031003c7306ULL, 0x000fe20000209400ULL,
0x0000002500257245ULL, 0x002fca000020d400ULL, 0x0000000162624812ULL, 0x000fe400078efcffULL,
0x0000003100457306ULL, 0x0002a20000205400ULL, 0x000000475800720bULL, 0x008fe40003fbd000ULL,
0x0000003a7947723eULL, 0x000fe400000010ffULL, 0x000000323d3a723eULL, 0x000fe400000010ffULL,
0x00000039623b723eULL, 0x000fe200000010ffULL, 0x00000056003e7306ULL, 0x000fe20000209400ULL,
0x0000003100317245ULL, 0x002fe2000020d400ULL, 0x000000461008723cULL, 0x000b680000041808ULL,
0x0000000125255812ULL, 0x000fc400078efcffULL, 0x00000056004a7306ULL, 0x0002e20000205400ULL,
0x000000453c00720bULL, 0x004fe20003fdd000ULL, 0x0000003a1020723cULL, 0x000b6c0000041820ULL,
0x00000057004b7306ULL, 0x000fe20000209400ULL, 0x0000005600567245ULL, 0x002fca000020d400ULL,
0x0000000131316812ULL, 0x000fe400078efcffULL, 0x0000005700507306ULL, 0x0002a20000205400ULL,
0x0000004a3e00720bULL, 0x008fe40003f1d000ULL, 0x0000005700577245ULL, 0x002fd6000020d400ULL,
0x0000000156560812ULL, 0x000fe400078efcffULL, 0x000000504b00720bULL, 0x004fe40003f5d000ULL,
0x000000562556723eULL, 0x000fd600000010ffULL, 0x0000000157572812ULL, 0x000fc800078efcffULL,
0x000000573157723eULL, 0x000fce00000010ffULL, 0x000000561010723cULL, 0x000b62000004181cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff3a7f8cULL, 0x020e62000c80043fULL,
0x000000ffff317224ULL, 0x000fce00078e00ffULL, 0x00000000001c7805ULL, 0x000fc40000015200ULL,
0x0106bc00ff1e7984ULL, 0x000ea40000000800ULL, 0x800000001eff7812ULL, 0x006fe4000780483bULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103100780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000001e7805ULL, 0x000fcc0000015200ULL,
0x0000001e1c257210ULL, 0x000fca0007f1e1ffULL, 0x000000011f1f7824ULL, 0x000fe200000e0e1dULL,
0x003d09002500780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402500780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1e7819ULL, 0x000fc8000001141fULL, 0x000000251e1e7211ULL, 0x000fca00078110ffULL,
0x000000ffff1f7224ULL, 0x000fca00000e061fULL, 0x000000021e1e7819ULL, 0x000fc8000000121fULL,
0x0000001e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000131317810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0106bc00ff1e7984ULL, 0x000e640000000800ULL, 0x800000001eff7812ULL, 0x002fe4000780483bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000204057890ULL, 0x000fe2000fffe03fULL,
0x000058002c1c7a24ULL, 0x010fc800078e02ffULL, 0x000000401c257824ULL, 0x000fe200078e00ffULL,
0x000000052a007c0cULL, 0x000fda000bf03070ULL, 0x0000045000008947ULL, 0x000fea0003800000ULL,
0x000000012b1d7824ULL, 0x000fe200078e0238ULL, 0x00000002383d7810ULL, 0x040fe20007ffe0ffULL,
0x0000010004057891ULL, 0x000fe2000f8e403fULL, 0x0000000438457810ULL, 0x040fe20007ffe0ffULL,
0x000000011d1c7824ULL, 0x040fe200078e0202ULL, 0x0000000638477810ULL, 0x000fe20007ffe0ffULL,
0x000000101d3c7824ULL, 0x000fe400078e00ffULL, 0x000000012b1e7824ULL, 0x000fe400078e023dULL,
0x00000040031d7824ULL, 0x000fe200078e021dULL, 0xfffffff03c3c7812ULL, 0x000fe200078ee21cULL,
0x000000011e1f7824ULL, 0x000fe200078e0202ULL, 0x00000005281c7c17ULL, 0x000fe2000f800000ULL,
0x000000101e3e7824ULL, 0x000fe200078e00ffULL, 0x000000041d327810ULL, 0x000fe20007ffe0ffULL,
0x000000012b1e7824ULL, 0x000fe200078e0245ULL, 0x800000051c1c7c10ULL, 0x000fc4000fffe0ffULL,
0xfffffff03e3e7812ULL, 0x000fe200078ee21fULL, 0x000000011e1f7824ULL, 0x140fe200078e0202ULL,
0x000000251d3a7210ULL, 0x080fe20007f1e0ffULL, 0x000000101e467824ULL, 0x000fe200078e00ffULL,
0x0000001c2b1c7217ULL, 0x040fe20007800000ULL, 0x000000012b1e7824ULL, 0x000fe200078e0247ULL,
0x000000021d397810ULL, 0x040fe40007ffe0ffULL, 0x0000002532327210ULL, 0x080fe20007f7e0ffULL,
0x000000011e3b7824ULL, 0x040fe200078e0202ULL, 0x000000061d317810ULL, 0x000fe20007ffe0ffULL,
0x000000101e487824ULL, 0x000fe200078e00ffULL, 0xfffffff046467812ULL, 0x000fe200078ee21fULL,
0x000000ffff1d7224ULL, 0x000fe200000e06ffULL, 0x00005e003a1f7a11ULL, 0x000fe200078440ffULL,
0x000000011c1e7824ULL, 0x000fe200078e0a2bULL, 0x0000002539397210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff1c7224ULL, 0x000fe200018e06ffULL, 0x0000002531257210ULL, 0x000fc40007f1e0ffULL,
0xfffffff048487812ULL, 0x000fe400078ee23bULL, 0x00005e0032317a11ULL, 0x000fe400078640ffULL,
0x00005f003a3a7a11ULL, 0x000fe200010f441dULL, 0x000000ffff1d7224ULL, 0x000fe200020e06ffULL,
0x000000f0303b7812ULL, 0x000fe400078ec0ffULL, 0x0000001e3800720cULL, 0x000fe40003f46070ULL,
0x00005f0032327a11ULL, 0x000fc400018f441cULL, 0x00005e0039387a11ULL, 0x000fe400078840ffULL,
0x0000003b1f1c7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff1f7224ULL, 0x000fe200000e06ffULL,
0x00005f0039397a11ULL, 0x000fe400020f441dULL, 0x0000001e3d00720cULL, 0x080fe20003f86070ULL,
0x000000ffff1d7224ULL, 0x000fe200028e063aULL, 0x0000001e4500720cULL, 0x000fe40003f66070ULL,
0x0000c0003c3c7811ULL, 0x000fc400078e20ffULL, 0x0000001e4700720cULL, 0x000fe40003f06070ULL,
0x00005e0025307a11ULL, 0x040fe200078c40ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c3c7faeULL, 0x0003e2000d101c46ULL, 0x0000003b381e7210ULL, 0x080fe40007fbe0ffULL,
0x00005f0025257a11ULL, 0x000fe400030f441fULL, 0x0000c0003e3e7811ULL, 0x000fe200078e20ffULL,
0x000000ffff1f7224ULL, 0x000fe200028e0639ULL, 0x0000003b30307210ULL, 0x000fc40007fbe0ffULL,
0x0000c00046467811ULL, 0x000fe400078e20ffULL, 0x0000c00048487811ULL, 0x000fe200078e20ffULL,
0x000000001e3e7faeULL, 0x0005e2000e101c46ULL, 0x0000003b311c7210ULL, 0x002fe20007f5e0ffULL,
0x000000ffff317224ULL, 0x000fc800028e0625ULL, 0x000000ffff1d7224ULL, 0x000fca00010e0632ULL,
0x000000001c467faeULL, 0x0005e8000d901c46ULL, 0x0000000030487faeULL, 0x0005e2000c101c46ULL,
0x0000038000007947ULL, 0x000fea0003800000ULL, 0x000000012b387824ULL, 0x000fc800078e0238ULL,
0x00000001381c7824ULL, 0x140fe200078e0202ULL, 0x00000002381d7810ULL, 0x040fe20007ffe0ffULL,
0x00000010381f7824ULL, 0x040fe200078e00ffULL, 0x0000000438317810ULL, 0x040fe40007ffe0ffULL,
0x0000000638397810ULL, 0x000fe20007ffe0ffULL, 0x000000011d1e7824ULL, 0x000fe200078e0202ULL,
0xfffffff01f1f7812ULL, 0x000fe200078ee21cULL, 0x000000101d327824ULL, 0x000fe400078e00ffULL,
0x00000040031c7824ULL, 0x000fe200078e0238ULL, 0x0000c0001f1f7811ULL, 0x000fe200078e20ffULL,
0x00000001313a7824ULL, 0x040fe200078e0202ULL, 0xfffffff032327812ULL, 0x000fe200078ee21eULL,
0x00000010313c7824ULL, 0x000fe200078e00ffULL, 0x000000251c1d7210ULL, 0x040fe20007f1e0ffULL,
0x00000001393e7824ULL, 0x040fe200078e0202ULL, 0x000000021c1e7810ULL, 0x040fe20007ffe0ffULL,
0x0000001039467824ULL, 0x000fe200078e00ffULL, 0x000000041c387810ULL, 0x000fc40007ffe0ffULL,
0x000000061c3b7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff1c7224ULL, 0x000fe200000e06ffULL,
0x000000251e317210ULL, 0x080fe40007f5e0ffULL, 0x0000002538397210ULL, 0x080fe40007f7e0ffULL,
0x00005e001d1e7a11ULL, 0x000fe400078040ffULL, 0x000000f030387812ULL, 0x000fe400078ec0ffULL,
0x000000253b3d7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff257224ULL, 0x000fe200010e06ffULL,
0x00005f001d1d7a11ULL, 0x000fc400000f441cULL, 0x000000381e1c7210ULL, 0x000fe40007f1e0ffULL,
0xfffffff03c3c7812ULL, 0x000fe200078ee23aULL, 0x000000ffff3a7224ULL, 0x000fe200018e06ffULL,
0xfffffff046467812ULL, 0x000fe200078ee23eULL, 0x000000ffff3e7224ULL, 0x000fe200020e06ffULL,
0x00005e0031307a11ULL, 0x000fe200078440ffULL, 0x000000ffff1d7224ULL, 0x000fe200000e061dULL,
0x00005e00393b7a11ULL, 0x000fe400078640ffULL, 0x00005e003d457a11ULL, 0x000fc400078840ffULL,
0x00005f0031257a11ULL, 0x000fe200010f4425ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c1f7faeULL, 0x0003e2000b901c46ULL, 0x00000038301e7210ULL, 0x080fe40007f1e0ffULL,
0x00005f00393a7a11ULL, 0x000fe400018f443aULL, 0x000000383b307210ULL, 0x080fe40007f5e0ffULL,
0x00005f003d3e7a11ULL, 0x000fe400020f443eULL, 0x0000003845387210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff317224ULL, 0x000fe200010e063aULL, 0x0000c00032327811ULL, 0x000fe200078e20ffULL,
0x000000ffff1f7224ULL, 0x002fe200000e0625ULL, 0x0000c0003c3c7811ULL, 0x000fe200078e20ffULL,
0x000000ffff397224ULL, 0x000fe200018e063eULL, 0x0000c00046467811ULL, 0x000fc400078e20ffULL,
0x000000001e327faeULL, 0x0003e8000b901c46ULL, 0x00000000303c7faeULL, 0x0003e8000b901c46ULL,
0x0000000038467faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x004fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff1c7f8cULL, 0x000ea4000c80043fULL,
0x000000ffff457224ULL, 0x004fc400078e001dULL, 0x00000000001c7805ULL, 0x000fca0000015200ULL,
0x0106b400ff1e7984ULL, 0x002e640000000800ULL, 0x800000001eff7812ULL, 0x002fc40007804827ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff307224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001e7805ULL, 0x000fcc0000015200ULL, 0x0000001e1c257210ULL, 0x000fca0007f1e1ffULL,
0x000000011f1f7824ULL, 0x000fe200000e0e1dULL, 0x003d09002500780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402500780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1e7819ULL, 0x000fc8000001141fULL,
0x000000251e1e7211ULL, 0x000fca00078110ffULL, 0x000000ffff1f7224ULL, 0x000fca00000e061fULL,
0x000000021e1e7819ULL, 0x000fc8000000121fULL, 0x0000001e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000130307810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0106b400ff1e7984ULL, 0x000e640000000800ULL,
0x800000001eff7812ULL, 0x002fe40007804827ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000014000007945ULL, 0x000fe20003800000ULL, 0x0000012000001947ULL, 0x000fea0003800000ULL,
0x00000035ff1c723eULL, 0x000fe400000010ffULL, 0x00000002ff1d7819ULL, 0x000fe40000011602ULL,
0x000054101c1c7816ULL, 0x000fe2000000001cULL, 0x000099327f007947ULL, 0x000fea000b800000ULL,
0x00001f1d1c367589ULL, 0x0002a400000e0000ULL, 0x000000081d377810ULL, 0x000fe20007ffe0ffULL,
0x000099627f007947ULL, 0x000fea000b800000ULL, 0x00001f371c377589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000101d497810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4a7224ULL, 0x000fe200078e001cULL, 0x0001795000487802ULL, 0x000fc40000000f00ULL,
0x00009e3000007944ULL, 0x00efea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000181d497810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff4a7224ULL, 0x004fe200078e001cULL,
0x000179a000487802ULL, 0x000fc40000000f00ULL, 0x00009de000007944ULL, 0x00afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000000401c783bULL, 0x00ae680000004200ULL, 0x000000003f3c783bULL, 0x000ee80000004200ULL,
0x000000004230783bULL, 0x000f280000004200ULL, 0x000000004138783bULL, 0x000ea20000004200ULL,
0x000001001c957824ULL, 0x002fe200078e00ffULL, 0x0000001c00967306ULL, 0x000fe20000009400ULL,
0x00000018ffb17819ULL, 0x000fe2000001141cULL, 0x000100001fad7824ULL, 0x000fe200078e00ffULL,
0x00000018ff977819ULL, 0x000fe2000001141dULL, 0x000001003c997824ULL, 0x048fe200078e00ffULL,
0x00000018ffa77819ULL, 0x000fe20000011495ULL, 0x000100003c9b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8e7819ULL, 0x000fe2000001141eULL, 0x0000001c00987306ULL, 0x000e620000005400ULL,
0x00000018ff8b7819ULL, 0x000fe2000001141fULL, 0x000100003d9e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff997819ULL, 0x000fe20000011499ULL, 0x0000010031cf7824ULL, 0x010fe200078e00ffULL,
0x00000018ff9b7819ULL, 0x000fe2000001149bULL, 0x0000010032d07824ULL, 0x000fe200078e00ffULL,
0x00000018ff837819ULL, 0x000fe2000001143cULL, 0x0000001c006b7306ULL, 0x000722000000d400ULL,
0x00000018ff817819ULL, 0x000fe2000001143dULL, 0x0000010033d17824ULL, 0x000fe200078e00ffULL,
0x00000018ff9e7819ULL, 0x000fc4000001149eULL, 0x00000018ffad7819ULL, 0x000fe400000114adULL,
0x00000018ff6d7819ULL, 0x000fe2000001143eULL, 0x000000a7009a7306ULL, 0x000fe20000209400ULL,
0x000100001c1c7824ULL, 0x008fe200078e00ffULL, 0x000000989600720bULL, 0x002fe20003fbd000ULL,
0x0000010038987824ULL, 0x004fe200078e00ffULL, 0x00000018ff757819ULL, 0x000fe20000011430ULL,
0x0000010039967824ULL, 0x000fe200078e00ffULL, 0x00000018ffaf7819ULL, 0x000fe2000001141cULL,
0x000001001d1c7824ULL, 0x000fe200078e00ffULL, 0x000000a7009c7306ULL, 0x0002a20000205400ULL,
0x00000018ff6e7819ULL, 0x000fc4000001143fULL, 0x00000018ff657819ULL, 0x000fe40000011431ULL,
0x00000018ffb67819ULL, 0x000fe2000001141cULL, 0x000001001e1c7824ULL, 0x000fe200078e00ffULL,
0x000000016b6b5812ULL, 0x010fe200078efcffULL, 0x0000001d00b47306ULL, 0x000fe20000009400ULL,
0x000000a700a77245ULL, 0x002fe4000020d400ULL, 0x00000018ffc07819ULL, 0x000fe2000001141cULL,
0x000001001f1c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5c7819ULL, 0x000fc40000011432ULL,
0x00000018ff577819ULL, 0x000fe20000011433ULL, 0x0000001d00b57306ULL, 0x000e620000005400ULL,
0x0000009c9a00720bULL, 0x004fe40003f1d000ULL, 0x00000018ffc67819ULL, 0x000fe2000001141cULL,
0x000100003e1c7824ULL, 0x000fe200078e00ffULL, 0x00000018ffcf7819ULL, 0x000fe400000114cfULL,
0x00000018ffd17819ULL, 0x000fe200000114d1ULL, 0x0000001d006a7306ULL, 0x0004e2000000d400ULL,
0x00000018ff1c7819ULL, 0x000fc4000001141cULL, 0x00000018ffd07819ULL, 0x000fe400000114d0ULL,
0x00000018ff987819ULL, 0x000fe40000011498ULL, 0x00000001a7a70812ULL, 0x000fe200078efcffULL,
0x000000af00ae7306ULL, 0x000fe20000209400ULL, 0x000100001d1d7824ULL, 0x004fe200078e00ffULL,
0x000000b5b400720bULL, 0x002fe40003fdd000ULL, 0x00000018ff487819ULL, 0x000fe40000011438ULL,
0x00000018ffb97819ULL, 0x000fe2000001141dULL, 0x000001003f1d7824ULL, 0x000fe200078e00ffULL,
0x000000af00b07306ULL, 0x0002a20000205400ULL, 0x00000018ff257819ULL, 0x000fc4000001143bULL,
0x00000018ff427819ULL, 0x000fe40000011439ULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x000000016a6a6812ULL, 0x008fe200078efcffULL, 0x000000b600b77306ULL, 0x000fe20000209400ULL,
0x000000af00af7245ULL, 0x002fe4000020d400ULL, 0x00000018ff967819ULL, 0x000fe40000011496ULL,
0x00000018ff267819ULL, 0x000fc6000001143aULL, 0x000000b600b87306ULL, 0x000e620000205400ULL,
0x000000b0ae00720bULL, 0x004fe40003f7d000ULL, 0x000000b100b07245ULL, 0x000fca000020d400ULL,
0x000000b100b27306ULL, 0x000fec0000209400ULL, 0x00000001afaf3812ULL, 0x000fe400078efcffULL,
0x000000b100b37306ULL, 0x0004e20000205400ULL, 0x000000b8b700720bULL, 0x002fce0003f1d000ULL,
0x000000b900ba7306ULL, 0x000fe20000209400ULL, 0x000000b600b17245ULL, 0x004fca000020d400ULL,
0x00000001b1b10812ULL, 0x000fe400078efcffULL, 0x000000b900bb7306ULL, 0x000e620000205400ULL,
0x000000b3b200720bULL, 0x008fce0003f9d000ULL, 0x0000009700bc7306ULL, 0x000fec0000209400ULL,
0x00000001b0b04812ULL, 0x000fe400078efcffULL, 0x0000009700bd7306ULL, 0x0004e20000205400ULL,
0x000000bbba00720bULL, 0x002fce0003fbd000ULL, 0x000000c000c17306ULL, 0x000fe20000209400ULL,
0x0000009700977245ULL, 0x004fce000020d400ULL, 0x000000c000c27306ULL, 0x000e620000205400ULL,
0x000000bdbc00720bULL, 0x008fce0003f7d000ULL, 0x0000001f00a47306ULL, 0x000fec0000009400ULL,
0x0000000197973812ULL, 0x000fe400078efcffULL, 0x0000001f00a17306ULL, 0x000ea20000005400ULL,
0x000000c2c100720bULL, 0x002fce0003f1d000ULL, 0x0000001e00be7306ULL, 0x000ff00000009400ULL,
0x0000001e00bf7306ULL, 0x000e620000005400ULL, 0x000000a1a400720bULL, 0x004fe40003f9d000ULL,
0x000000b900a17245ULL, 0x000fc8000020d400ULL, 0x00000001a1a15812ULL, 0x000fe200078efcffULL,
0x0000001e00647306ULL, 0x0004e6000000d400ULL, 0x000000a197a1723eULL, 0x000fca00000010ffULL,
0x0000003c00937306ULL, 0x000fe20000009400ULL, 0x000100001e1e7824ULL, 0x004fe200078e00ffULL,
0x000000bfbe00720bULL, 0x002fc80003f5d000ULL, 0x00000018ffc37819ULL, 0x000fe2000001141eULL,
0x000001003e1e7824ULL, 0x000fe200078e00ffULL, 0x0000003c00947306ULL, 0x000e680000005400ULL,
0x00000018ff1e7819ULL, 0x000fc6000001141eULL, 0x0000000164642812ULL, 0x008fe200078efcffULL,
0x0000008e008f7306ULL, 0x000ff00000209400ULL, 0x0000008e00907306ULL, 0x0004e20000205400ULL,
0x000000949300720bULL, 0x002fc40003fbd000ULL, 0x000000c000947245ULL, 0x000fe4000020d400ULL,
0x000000c600937245ULL, 0x000fe4000020d400ULL, 0x0000000194940812ULL, 0x000fe200078efcffULL,
0x000000c300c47306ULL, 0x000fe20000209400ULL, 0x0000008e008e7245ULL, 0x004fe4000020d400ULL,
0x000000649464723eULL, 0x000fca00000010ffULL, 0x000000c300c57306ULL, 0x000e620000205400ULL,
0x000000908f00720bULL, 0x008fe40003f1d000ULL, 0x000000c3008f7245ULL, 0x000fca000020d400ULL,
0x0000001f00617306ULL, 0x0004ec000000d400ULL, 0x000000018e8e0812ULL, 0x000fe400078efcffULL,
0x0000008b00917306ULL, 0x000fe20000209400ULL, 0x000001003d1f7824ULL, 0x004fe200078e00ffULL,
0x000000c5c400720bULL, 0x002fc80003f7d000ULL, 0x00000018ff1f7819ULL, 0x000fe4000001141fULL,
0x0000008b00927306ULL, 0x0002a20000205400ULL, 0x0000000161614812ULL, 0x008fcc00078efcffULL,
0x000000018f8f3812ULL, 0x000fe200078efcffULL, 0x0000009900cb7306ULL, 0x000fe20000209400ULL,
0x0000008b008b7245ULL, 0x002fe4000020d400ULL, 0x0000008f8e8e723eULL, 0x000fca00000010ffULL,
0x0000009900cc7306ULL, 0x0002e20000205400ULL, 0x000000929100720bULL, 0x004fce0003f5d000ULL,
0x0000003d008d7306ULL, 0x000fe20000009400ULL, 0x0000009900997245ULL, 0x002fca000020d400ULL,
0x000000018b8b2812ULL, 0x000fe400078efcffULL, 0x0000003d008c7306ULL, 0x000e620000005400ULL,
0x000000cccb00720bULL, 0x008fce0003f9d000ULL, 0x0000001f00a97306ULL, 0x000fec0000209400ULL,
0x0000000199994812ULL, 0x000fe400078efcffULL, 0x0000001f00ce7306ULL, 0x000ea20000205400ULL,
0x0000008c8d00720bULL, 0x002fce0003f7d000ULL, 0x0000009b00ac7306ULL, 0x000ff00000209400ULL,
0x0000009b00cd7306ULL, 0x0002e20000205400ULL, 0x000000cea900720bULL, 0x004fce0003f1d000ULL,
0x0000008300887306ULL, 0x000fe20000209400ULL, 0x0000009b009b7245ULL, 0x002fce000020d400ULL,
0x0000008300877306ULL, 0x0002a20000205400ULL, 0x000000cdac00720bULL, 0x008fce0003f5d000ULL,
0x000000c600c77306ULL, 0x000fe20000209400ULL, 0x0000008300837245ULL, 0x002fca000020d400ULL,
0x000000019b9b2812ULL, 0x000fe400078efcffULL, 0x000000c600c87306ULL, 0x000e620000205400ULL,
0x000000878800720bULL, 0x004fe40003f9d000ULL, 0x0000001f00877245ULL, 0x000fc8000020d400ULL,
0x0000000187870812ULL, 0x000fe200078efcffULL, 0x0000003d00607306ULL, 0x0004ec000000d400ULL,
0x0000000183834812ULL, 0x000fe400078efcffULL, 0x0000008100847306ULL, 0x000fe20000209400ULL,
0x000000c8c700720bULL, 0x002fe20003fdd000ULL, 0x000100003f3d7824ULL, 0x004fca00078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe2000001143dULL, 0x0000008100827306ULL, 0x0002a20000205400ULL,
0x0000000160603812ULL, 0x008fca00078efcffULL, 0x0000000193936812ULL, 0x000fe400078efcffULL,
0x0000009e00aa7306ULL, 0x000fe20000209400ULL, 0x0000008100817245ULL, 0x002fce000020d400ULL,
0x0000009e00ab7306ULL, 0x0002e20000205400ULL, 0x000000828400720bULL, 0x004fce0003f7d000ULL,
0x0000001e00a67306ULL, 0x000fe20000209400ULL, 0x0000009e009e7245ULL, 0x002fca000020d400ULL,
0x0000000181813812ULL, 0x000fe400078efcffULL, 0x0000001e00a37306ULL, 0x000e620000205400ULL,
0x000000abaa00720bULL, 0x008fce0003f1d000ULL, 0x000000ad00c97306ULL, 0x000fec0000209400ULL,
0x000000019e9e0812ULL, 0x000fe400078efcffULL, 0x000000ad00ca7306ULL, 0x0004e20000205400ULL,
0x000000a3a600720bULL, 0x002fce0003f5d000ULL, 0x0000001d00a07306ULL, 0x000fe20000209400ULL,
0x000000ad00ad7245ULL, 0x004fce000020d400ULL, 0x0000001d00a87306ULL, 0x000e620000205400ULL,
0x000000cac900720bULL, 0x008fce0003fdd000ULL, 0x00000030007f7306ULL, 0x000fec0000009400ULL,
0x00000001adad6812ULL, 0x000fe400078efcffULL, 0x0000003000807306ULL, 0x000ea20000005400ULL,
0x000000a8a000720bULL, 0x002fe40003f9d000ULL, 0x000000afb0a0723eULL, 0x000fc400000010ffULL,
0x000000ad8b8f723eULL, 0x000fc600000010ffULL, 0x00000031007b7306ULL, 0x000ff00000009400ULL,
0x00000031007c7306ULL, 0x000e620000005400ULL, 0x000000807f00720bULL, 0x004fe40003f1d000ULL,
0x0000001e007f7245ULL, 0x000fc8000020d400ULL, 0x000000017f7f2812ULL, 0x000fe200078efcffULL,
0x0000003c005d7306ULL, 0x0004f0000000d400ULL, 0x0000006d007d7306ULL, 0x000fe20000209400ULL,
0x0000007c7b00720bULL, 0x002fe20003f7d000ULL, 0x00010000393c7824ULL, 0x004fe200078e00ffULL,
0x0000001d007b7245ULL, 0x000fc4000020d400ULL, 0x0000b800441d7811ULL, 0x000fe400078e20ffULL,
0x000000017b7b4812ULL, 0x000fe200078efcffULL, 0x0000006d007e7306ULL, 0x0002a20000205400ULL,
0x000000015d5d5812ULL, 0x008fe400078efcffULL, 0x0000006d00447245ULL, 0x000fca000020d400ULL,
0x0000003f00867306ULL, 0x000fe20000009400ULL, 0x0000006ab16d723eULL, 0x002fce00000010ffULL,
0x0000003f00857306ULL, 0x000e620000005400ULL, 0x0000007e7d00720bULL, 0x004fce0003f5d000ULL,
0x0000003e008a7306ULL, 0x000fec0000009400ULL, 0x0000000144442812ULL, 0x000fe400078efcffULL,
0x0000003e00897306ULL, 0x000ea20000005400ULL, 0x000000858600720bULL, 0x002fce0003fbd000ULL,
0x0000003e00597306ULL, 0x0002f0000000d400ULL, 0x0000003000547306ULL, 0x0008e2000000d400ULL,
0x00000100303e7824ULL, 0x002fe200078e00ffULL, 0x000000898a00720bULL, 0x004fc80003fdd000ULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x0000003d00a57306ULL, 0x000fe20000209400ULL,
0x0001000030307824ULL, 0x010fca00078e00ffULL, 0x00000018ff9c7819ULL, 0x000fe40000011430ULL,
0x0000003d00a27306ULL, 0x000e620000205400ULL, 0x0000b80043307811ULL, 0x000fe400078e20ffULL,
0x0000001c00437245ULL, 0x000fe4000020d400ULL, 0x0000000159596812ULL, 0x008fe400078efcffULL,
0x0000000154540812ULL, 0x000fe200078efcffULL, 0x0000003100517306ULL, 0x0004f0000000d400ULL,
0x0000003200777306ULL, 0x000fe20000009400ULL, 0x0001000031317824ULL, 0x004fe200078e00ffULL,
0x000000a2a500720bULL, 0x002fc80003f9d000ULL, 0x00000018ffb47819ULL, 0x000fe40000011431ULL,
0x0000003200787306ULL, 0x000fe20000005400ULL, 0x0000000151513812ULL, 0x008fce00078efcffULL,
0x0000003200507306ULL, 0x0003f0000000d400ULL, 0x0000003300767306ULL, 0x000fe20000009400ULL,
0x0001000032327824ULL, 0x002fca00078e00ffULL, 0x00000018ff827819ULL, 0x000fe40000011432ULL,
0x0000003300727306ULL, 0x000e700000005400ULL, 0x0000003300477306ULL, 0x0005f0000000d400ULL,
0x0000003f00567306ULL, 0x000722000000d400ULL, 0x0001000033337824ULL, 0x004fe200078e00ffULL,
0x000000727600720bULL, 0x002fc80003f1d000ULL, 0x00000018ff7d7819ULL, 0x000fe40000011433ULL,
0x0000006e00797306ULL, 0x000fe20000209400ULL, 0x000000003030783bULL, 0x000e620000000200ULL,
0x00010000383f7824ULL, 0x008fca00078e00ffULL, 0x00000018ff6a7819ULL, 0x000fe2000001143fULL,
0x0000006e007a7306ULL, 0x0004e20000205400ULL, 0x0000000156565812ULL, 0x010fe400078efcffULL,
0x0000009e813f723eULL, 0x000fe400000010ffULL, 0x0000000147470812ULL, 0x000fc600078efcffULL,
0x0000001c009d7306ULL, 0x000fe20000209400ULL, 0x0000006e006e7245ULL, 0x004fce000020d400ULL,
0x0000001c009f7306ULL, 0x0005220000205400ULL, 0x0000007a7900720bULL, 0x008fe40003fbd000ULL,
0x0000003d00797245ULL, 0x000fe4000020d400ULL, 0x00000060873d723eULL, 0x000fe400000010ffULL,
0x0000000179794812ULL, 0x000fe200078efcffULL, 0x0000007500737306ULL, 0x000fe20000209400ULL,
0x000000001d1c783bULL, 0x004eaa0000000200ULL, 0x000000016e6e5812ULL, 0x000fc400078efcffULL,
0x0000007500707306ULL, 0x0006e20000205400ULL, 0x0000009f9d00720bULL, 0x010fe20003fdd000ULL,
0x0000003630309231ULL, 0x082fe200003400ffULL, 0x000000b4009d7245ULL, 0x000fe2000020d400ULL,
0x0000003632329231ULL, 0x000fe400003400ffULL, 0x0000003731319231ULL, 0x080fe400003400ffULL,
0x000000cf00b37306ULL, 0x000fe20000209400ULL, 0x0000007500757245ULL, 0x008fe2000020d400ULL,
0x0000003733339231ULL, 0x000fc800003400ffULL, 0x0000000143436812ULL, 0x000fe400078efcffULL,
0x000000cf00a47306ULL, 0x0002e20000205400ULL, 0x000000707300720bULL, 0x000fe20003f9d000ULL,
0x000000a03014723cULL, 0x000f620000041814ULL, 0x0000003e00707245ULL, 0x000fca000020d400ULL,
0x0000003e00957306ULL, 0x000fe20000209400ULL, 0x000000cf00cf7245ULL, 0x002fe2000020d400ULL,
0x0000008e300c723cULL, 0x000f68000004180cULL, 0x0000000175754812ULL, 0x000fe400078efcffULL,
0x0000003e009a7306ULL, 0x0003220000205400ULL, 0x000000a4b300720bULL, 0x008fe20003fbd000ULL,
0x000000361c1c9231ULL, 0x004fc400003400ffULL, 0x000000361e1e9231ULL, 0x000fe400003400ffULL,
0x000000371d1d9231ULL, 0x080fe400003400ffULL, 0x0000006500747306ULL, 0x000fe20000209400ULL,
0x000000371f1f9231ULL, 0x000fe200003400ffULL, 0x0000009b833e723eULL, 0x002fc800000010ffULL,
0x00000001cfcf5812ULL, 0x000fe400078efcffULL, 0x0000006500717306ULL, 0x000e620000205400ULL,
0x0000009a9500720bULL, 0x010fe20003fdd000ULL, 0x0000003e3004723cULL, 0x000fec0000041804ULL,
0x0000003900677306ULL, 0x000fec0000009400ULL, 0x0000000170706812ULL, 0x000fc400078efcffULL,
0x0000003900667306ULL, 0x000ea20000005400ULL, 0x000000717400720bULL, 0x002fe40003f9d000ULL,
0x000000787700720bULL, 0x000fe40003fdd000ULL, 0x000000547054723eULL, 0x000fc600000010ffULL,
0x0000009c00ae7306ULL, 0x000ff00000209400ULL, 0x0000009c00b27306ULL, 0x0002e20000205400ULL,
0x000000666700720bULL, 0x004fe40003f3d000ULL, 0x0000006500667245ULL, 0x000fc4000020d400ULL,
0x0000000150506812ULL, 0x000fe400078efcffULL, 0x0000000166664812ULL, 0x000fe200078efcffULL,
0x000000b400b57306ULL, 0x000fe20000209400ULL, 0x0000009c009c7245ULL, 0x002fe4000020d400ULL,
0x000000619365723eULL, 0x000fca00000010ffULL, 0x000000b400907306ULL, 0x000e620000205400ULL,
0x000000b2ae00720bULL, 0x008fe20003f5d000ULL, 0x00000064304c723cULL, 0x000f6c000004184cULL,
0x000000d100857306ULL, 0x000fec0000209400ULL, 0x000000019c9c2812ULL, 0x000fc400078efcffULL,
0x000000d100847306ULL, 0x0004e20000205400ULL, 0x00000090b500720bULL, 0x002fe40003fbd000ULL,
0x0000009c759c723eULL, 0x000fca00000010ffULL, 0x000000d0008c7306ULL, 0x000fe20000209400ULL,
0x000000d100d17245ULL, 0x004fca000020d400ULL, 0x000000019d9d5812ULL, 0x000fe400078efcffULL,
0x000000d000897306ULL, 0x0002a20000205400ULL, 0x000000848500720bULL, 0x008fe40003f9d000ULL,
0x0000009d669d723eULL, 0x000fca00000010ffULL, 0x00000038006f7306ULL, 0x000fe20000009400ULL,
0x000000d000d07245ULL, 0x002fe2000020d400ULL, 0x0000009c1c14723cULL, 0x020fe80000041814ULL,
0x00000001d1d14812ULL, 0x000fe400078efcffULL, 0x00000038006c7306ULL, 0x000e620000005400ULL,
0x000000898c00720bULL, 0x004fce0003f7d000ULL, 0x0000003a00697306ULL, 0x000fec0000009400ULL,
0x00000001d0d03812ULL, 0x000fe400078efcffULL, 0x0000003a00687306ULL, 0x000ea20000005400ULL,
0x0000006c6f00720bULL, 0x002fe40003f5d000ULL, 0x0000006ba76c723eULL, 0x000fca00000010ffULL,
0x0000008200807306ULL, 0x000fe40000209400ULL, 0x0000006c3018723cULL, 0x000f6c0000041818ULL,
0x00000082007c7306ULL, 0x0002e20000205400ULL, 0x000000686900720bULL, 0x004fe40003fbd000ULL,
0x00000018ff687819ULL, 0x000fc4000001143cULL, 0x0000005d993c723eULL, 0x000fe400000010ffULL,
0x0000007d005d7245ULL, 0x000fe2000020d400ULL, 0x0000005c005f7306ULL, 0x000fe20000209400ULL,
0x0000008200827245ULL, 0x002fe4000020d400ULL, 0x0000009600997245ULL, 0x000fe2000020d400ULL,
0x0000003c3008723cULL, 0x000b680000041808ULL, 0x0000005c005e7306ULL, 0x0002a20000205400ULL,
0x0000007c8000720bULL, 0x008fc40003fdd000ULL, 0x00000043443c723eULL, 0x020fe400000010ffULL,
0x000000796e3d723eULL, 0x000fc600000010ffULL, 0x0000003b00637306ULL, 0x000fe20000009400ULL,
0x0000005c005c7245ULL, 0x002fca000020d400ULL, 0x0000000182826812ULL, 0x000fe400078efcffULL,
0x0000003b00627306ULL, 0x000e620000005400ULL, 0x0000005e5f00720bULL, 0x004fce0003f9d000ULL,
0x0000003800417306ULL, 0x0004ec000000d400ULL, 0x000000015c5c4812ULL, 0x000fe400078efcffULL,
0x00000057005b7306ULL, 0x000fe20000209400ULL, 0x000000626300720bULL, 0x002fe20003f7d000ULL,
0x000001003b387824ULL, 0x004fe200078e00ffULL, 0x000000825c5c723eULL, 0x000fca00000010ffULL,
0x00000057005a7306ULL, 0x0002a20000205400ULL, 0x0000000141412812ULL, 0x008fce00078efcffULL,
0x0000007d007e7306ULL, 0x000fe20000209400ULL, 0x0000005700577245ULL, 0x002fce000020d400ULL,
0x0000007d007a7306ULL, 0x000e620000205400ULL, 0x0000005a5b00720bULL, 0x004fe40003f1d000ULL,
0x00000018ff5b7819ULL, 0x000fe40000011438ULL, 0x000000597f38723eULL, 0x000fc600000010ffULL,
0x0000006a006b7306ULL, 0x000fec0000209400ULL, 0x0000000157570812ULL, 0x000fe400078efcffULL,
0x0000006a00677306ULL, 0x0004e20000205400ULL, 0x0000007a7e00720bULL, 0x002fce0003fdd000ULL,
0x0000009800737306ULL, 0x000fe20000209400ULL, 0x0000006a006a7245ULL, 0x004fca000020d400ULL,
0x000000015d5d6812ULL, 0x000fe400078efcffULL, 0x0000009800727306ULL, 0x0002a20000205400ULL,
0x000000676b00720bULL, 0x008fe40003f5d000ULL, 0x0000005d575d723eULL, 0x000fca00000010ffULL,
0x0000003900407306ULL, 0x000722000000d400ULL, 0x0000009800987245ULL, 0x002fe2000020d400ULL,
0x0000005c1c0c723cULL, 0x000fe8000004180cULL, 0x000000016a6a2812ULL, 0x000fe400078efcffULL,
0x0000006800627306ULL, 0x000fe20000209400ULL, 0x000001003a397824ULL, 0x008fe200078e00ffULL,
0x000000727300720bULL, 0x004fc80003f9d000ULL, 0x00000018ff5e7819ULL, 0x000fe40000011439ULL,
0x0000006800617306ULL, 0x000e620000205400ULL, 0x000000567b39723eULL, 0x000fe400000010ffULL,
0x0000000140401812ULL, 0x010fc800078efcffULL, 0x0000000198984812ULL, 0x000fe200078efcffULL,
0x0000004800557306ULL, 0x000fe20000209400ULL, 0x000000383020723cULL, 0x000f640000041820ULL,
0x000000419898723eULL, 0x000fca00000010ffULL, 0x0000004800587306ULL, 0x0004e20000205400ULL,
0x000000616200720bULL, 0x002fe20003f3d000ULL, 0x0000003c3030723cULL, 0x000b6c0000041810ULL,
0x0000002500467306ULL, 0x000fe20000209400ULL, 0x0000004800487245ULL, 0x004fe4000020d400ULL,
0x00000050d010723eULL, 0x020fc400000010ffULL, 0x00000047d111723eULL, 0x000fc600000010ffULL,
0x0000002500497306ULL, 0x0002a20000205400ULL, 0x000000585500720bULL, 0x008fe40003fdd000ULL,
0x00000051cf55723eULL, 0x000fe200000010ffULL, 0x000000101c10723cULL, 0x000b68000004184cULL,
0x0000004200537306ULL, 0x000fe20000209400ULL, 0x0000002500257245ULL, 0x002fc6000020d400ULL,
0x000000541c18723cULL, 0x000b640000041818ULL, 0x0000000148486812ULL, 0x000fe400078efcffULL,
0x0000004200527306ULL, 0x0002e20000205400ULL, 0x000000494600720bULL, 0x004fe40003f5d000ULL,
0x0000006800497245ULL, 0x000fe4000020d400ULL, 0x0000006a4848723eULL, 0x000fe400000010ffULL,
0x0000000149491812ULL, 0x000fe200078efcffULL, 0x00000096006f7306ULL, 0x000fe20000209400ULL,
0x0000004200427245ULL, 0x002fca000020d400ULL, 0x0000000125252812ULL, 0x000fe400078efcffULL,
0x0000009600717306ULL, 0x000e620000205400ULL, 0x000000525300720bULL, 0x008fce0003f1d000ULL,
0x0000003a00347306ULL, 0x0004ec000000d400ULL, 0x0000000142420812ULL, 0x000fe400078efcffULL,
0x0000003b00277306ULL, 0x0008e2000000d400ULL, 0x000100003a3a7824ULL, 0x004fe200078e00ffULL,
0x000000716f00720bULL, 0x002fc40003f9d000ULL, 0x000000494249723eULL, 0x000fe400000010ffULL,
0x00000018ff3a7819ULL, 0x000fe4000001143aULL, 0x0000005b00597306ULL, 0x000fe20000209400ULL,
0x000100003b3b7824ULL, 0x010fe200078e00ffULL, 0x0000000134345812ULL, 0x008fe200078efcffULL,
0x000000481c04723cULL, 0x000b660000041804ULL, 0x00000018ff3b7819ULL, 0x000fc4000001143bULL,
0x0000005b003e7306ULL, 0x000e620000205400ULL, 0x0000000199994812ULL, 0x000fe400078efcffULL,
0x0000000127273812ULL, 0x000fe400078efcffULL, 0x000000409999723eULL, 0x000fc600000010ffULL,
0x0000005e005f7306ULL, 0x000fe80000209400ULL, 0x000000981c08723cULL, 0x000b680000041808ULL,
0x0000005e005a7306ULL, 0x0004e20000205400ULL, 0x0000003e5900720bULL, 0x002fce0003f3d000ULL,
0x00000026004b7306ULL, 0x000fe20000209400ULL, 0x0000005e005e7245ULL, 0x004fce000020d400ULL,
0x00000026004a7306ULL, 0x0002a20000205400ULL, 0x0000005a5f00720bULL, 0x008fe40003fdd000ULL,
0x0000005b005f7245ULL, 0x000fc8000020d400ULL, 0x000000015f5f1812ULL, 0x000fe200078efcffULL,
0x0000003a00387306ULL, 0x000fe20000209400ULL, 0x0000002600267245ULL, 0x002fe4000020d400ULL,
0x000000275f5f723eULL, 0x000fe400000010ffULL, 0x0000003b00277245ULL, 0x000fe4000020d400ULL,
0x000000015e5e6812ULL, 0x000fe200078efcffULL, 0x0000003a00397306ULL, 0x0002e20000205400ULL,
0x0000004a4b00720bULL, 0x004fc40003f9d000ULL, 0x000000345e5e723eULL, 0x000fca00000010ffULL,
0x0000003b003c7306ULL, 0x000fe20000209400ULL, 0x0000003a003a7245ULL, 0x002fe2000020d400ULL,
0x0000005e1c20723cULL, 0x000b680000041820ULL, 0x0000000126264812ULL, 0x000fe400078efcffULL,
0x0000003b003d7306ULL, 0x000e620000205400ULL, 0x000000393800720bULL, 0x008fda0003f1d000ULL,
0x000000013a3a0812ULL, 0x000fe400078efcffULL, 0x0000003d3c00720bULL, 0x002fe40003fbd000ULL,
0x0000003a2626723eULL, 0x000fd600000010ffULL, 0x0000000127275812ULL, 0x000fc800078efcffULL,
0x000000272527723eULL, 0x000fce00000010ffULL, 0x000000261c1c723cULL, 0x000b620000041830ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff267f8cULL, 0x020e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a000ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000042f4d7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff487224ULL, 0x002fc400078e0027ULL, 0x0000000104047890ULL, 0x000fcc000fffe03fULL,
0x000000042a007c0cULL, 0x000fda000bf03070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xfffe79d000007947ULL, 0x000fea000383ffffULL, 0x000000ff2a00720cULL, 0x000fe20003f05270ULL,
0x000000ffff327224ULL, 0x000fe400078e001fULL, 0x000000ffff2f7224ULL, 0x000fe400078e001cULL,
0x000000ffff297224ULL, 0x000fe400078e0020ULL, 0x000000ffff317224ULL, 0x000fe400078e001eULL,
0x000000ffff307224ULL, 0x000fe400078e001dULL, 0x000000ffff2e7224ULL, 0x000fc400078e0023ULL,
0x000000ffff2c7224ULL, 0x000fe400078e0022ULL, 0x000000ffff2a7224ULL, 0x000fe400078e0021ULL,
0x000000ffff207224ULL, 0x000fe400078e000fULL, 0x000000ffff1f7224ULL, 0x000fe400078e000eULL,
0x000000ffff1c7224ULL, 0x000fe400078e0013ULL, 0x000000ffff287224ULL, 0x000fc400078e0007ULL,
0x000000ffff277224ULL, 0x008fe400078e0006ULL, 0x000000ffff267224ULL, 0x000fe400078e0005ULL,
0x000000ffff257224ULL, 0x002fe400078e0004ULL, 0x000000ffff247224ULL, 0x000fe400078e000bULL,
0x000000ffff237224ULL, 0x000fe400078e000aULL, 0x000000ffff227224ULL, 0x000fc400078e0009ULL,
0x000000ffff217224ULL, 0x000fe400078e0008ULL, 0x000000ffff1e7224ULL, 0x000fe400078e000dULL,
0x000000ffff1d7224ULL, 0x000fe400078e000cULL, 0x000000ffff137224ULL, 0x000fe400078e0012ULL,
0x000000ffff0f7224ULL, 0x000fe400078e0011ULL, 0x000000ffff0e7224ULL, 0x000fe200078e0010ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x018000002d027810ULL, 0x000fe20007ffe0ffULL,
0x000000c000007945ULL, 0x000fe60003800000ULL, 0x7f80000002027812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0200780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x000000ffff037224ULL, 0x000fe200078e002dULL, 0x00019a1000057802ULL, 0x000fc40000000f00ULL,
0x00007b9000007944ULL, 0x004fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000002d00047308ULL, 0x000e640000001000ULL, 0xbf800000042d7423ULL, 0x002fc8000000002dULL,
0x800000ff2d2d7221ULL, 0x000fc80000010100ULL, 0x0000002d04047223ULL, 0x000fc40000000004ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006800ff027624ULL, 0x000fe400078e00ffULL,
0x00006900ff037624ULL, 0x000fca00078e00ffULL, 0x0000000602027981ULL, 0x0002e8000c1e9900ULL,
0x0000000000057919ULL, 0x000e640000000000ULL, 0x00000002ff037819ULL, 0x002fe40000011605ULL,
0x0000000805057811ULL, 0x000fe200078ff0ffULL, 0x0000000402027220ULL, 0x008fca0000410000ULL,
0x00001f0302037589ULL, 0x000e6800000e0000ULL, 0x00001f0502027589ULL, 0x000ee200000e0000ULL,
0x0000001803187220ULL, 0x042fe20000410000ULL, 0x0000001903197220ULL, 0x040fe20000410000ULL,
0x0000001403147220ULL, 0x040fe20000410000ULL, 0x0000001503157220ULL, 0x040fe20000410000ULL,
0x0000000e030e7220ULL, 0x040fe20000410000ULL, 0x0000000f030f7220ULL, 0x040fe20000410000ULL,
0x0000001d031d7220ULL, 0x040fe20000410000ULL, 0x0000001e031e7220ULL, 0x040fe20000410000ULL,
0x0000002103217220ULL, 0x040fe20000410000ULL, 0x0000002203227220ULL, 0x040fe20000410000ULL,
0x0000002503257220ULL, 0x040fe20000410000ULL, 0x0000002603267220ULL, 0x040fe20000410000ULL,
0x0000002903297220ULL, 0x040fe20000410000ULL, 0x0000002a032a7220ULL, 0x040fe20000410000ULL,
0x0000002f032f7220ULL, 0x040fe20000410000ULL, 0x0000003003307220ULL, 0x000fe20000410000ULL,
0x0000001a021a7220ULL, 0x048fe20000410000ULL, 0x0000001b021b7220ULL, 0x040fe20000410000ULL,
0x0000001602167220ULL, 0x040fe20000410000ULL, 0x0000001702177220ULL, 0x040fe20000410000ULL,
0x0000001302137220ULL, 0x040fe20000410000ULL, 0x0000001c021c7220ULL, 0x040fe20000410000ULL,
0x0000001f021f7220ULL, 0x040fe20000410000ULL, 0x0000002002207220ULL, 0x040fe20000410000ULL,
0x0000002302237220ULL, 0x040fe20000410000ULL, 0x0000002402247220ULL, 0x040fe20000410000ULL,
0x0000002702277220ULL, 0x040fe20000410000ULL, 0x0000002802287220ULL, 0x040fe20000410000ULL,
0x0000002c022c7220ULL, 0x040fe20000410000ULL, 0x0000002e022e7220ULL, 0x040fe20000410000ULL,
0x0000003102317220ULL, 0x040fe20000410000ULL, 0x0000003202327220ULL, 0x000fc20000410000ULL,
0x00000000002d7919ULL, 0x000e620000000000ULL, 0x00000000000579c3ULL, 0x000ee20000002700ULL,
0x0000580000047ab9ULL, 0x000fc40000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x00000002ff047819ULL, 0x002fc6000001162dULL,
0x00000005040472a4ULL, 0x008fe2000f8e023fULL, 0x000000022d027812ULL, 0x040fe400078ec0ffULL,
0x000000082d057811ULL, 0x000fe200078ff0ffULL, 0x0000000804077824ULL, 0x000fe200078e00ffULL,
0x0000000402037211ULL, 0x000fe200078ff8ffULL, 0x0000000804087824ULL, 0x000fe200078e00ffULL,
0x0000000502067211ULL, 0x000fe200078ff8ffULL, 0x0000000805097824ULL, 0x000fe200078e00ffULL,
0x0000000203027810ULL, 0x040fe20007ffe0ffULL, 0x00000008040a7824ULL, 0x040fe200078e00ffULL,
0x0000000403057810ULL, 0x000fe20007ffe0ffULL, 0x00000008040b7824ULL, 0x000fe200078e00ffULL,
0xfffffff807047812ULL, 0x000fc400078ee203ULL, 0x0000000603037810ULL, 0x000fe40007ffe0ffULL,
0xfffffff809097812ULL, 0x000fe400078ee206ULL, 0xfffffff808067812ULL, 0x000fe400078ee202ULL,
0xfffffff80b087812ULL, 0x000fe200078ee203ULL, 0x000000082d037824ULL, 0x000fe200078e00ffULL,
0xfffffff80a077812ULL, 0x000fe400078ee205ULL, 0x0000a00000057811ULL, 0x000fc400078e58ffULL,
0x0000000803037812ULL, 0x000fe400078ec0ffULL, 0x000000181900723eULL, 0x000fe200000010ffULL,
0x0000001004047824ULL, 0x100fe200078e0205ULL, 0x000000141502723eULL, 0x000fe200000010ffULL,
0x0000001009097824ULL, 0x000fe200078e0205ULL, 0x00000003ff0b7819ULL, 0x000fe2000001162dULL,
0x0000000104047824ULL, 0x000fe200078e0203ULL, 0x00005410000c7816ULL, 0x100fe20000000002ULL,
0x0000001006067824ULL, 0x100fe200078e0205ULL, 0x00007632000d7816ULL, 0x000fe20000000002ULL,
0x0000001007007824ULL, 0x100fe200078e0205ULL, 0x000000202d107810ULL, 0x000fe20007ffe0ffULL,
0x0000001008027824ULL, 0x000fc400078e0205ULL, 0x0000000c04007388ULL, 0x0003e20000000a00ULL,
0x00000003ff117819ULL, 0x000fe20000011610ULL, 0x00000001030a7824ULL, 0x040fe400078e0209ULL,
0x0000000103077824ULL, 0x040fe400078e0206ULL, 0x0000000103087824ULL, 0x000fe200078e0200ULL,
0x0000000e0f00723eULL, 0x000fe200000010ffULL, 0x0000000103097824ULL, 0x000fe200078e0202ULL,
0x0000001d1e02723eULL, 0x000fe400000010ffULL, 0x000000212203723eULL, 0x000fe200000010ffULL,
0x000000010b047824ULL, 0x002fe200078e022dULL, 0x00005410000e7816ULL, 0x100fe20000000002ULL,
0x00000001100c7824ULL, 0x000fe200078e0211ULL, 0x00007632000f7816ULL, 0x000fc40000000002ULL,
0x0000000704047812ULL, 0x000fe400078ec0ffULL, 0x000000070c0c7812ULL, 0x000fe200078ec0ffULL,
0x0000000e07007388ULL, 0x000fe20000000a00ULL, 0x0ffffff804067812ULL, 0x000fe400078ef82dULL,
0x000000252604723eULL, 0x000fe400000010ffULL, 0x0ffffff80c0d7812ULL, 0x000fe200078ef810ULL,
0x00000010060c7824ULL, 0x000fe200078e0205ULL, 0x0000541003027816ULL, 0x000fc40000000004ULL,
0x0000763203037816ULL, 0x000fe20000000004ULL, 0x000000100d127824ULL, 0x000fe200078e0205ULL,
0x000000292a00723eULL, 0x000fe400000010ffULL, 0x000000161704723eULL, 0x000fe200000010ffULL,
0x0000000208007388ULL, 0x0003e20000000a00ULL, 0x000000131c05723eULL, 0x000fe400000010ffULL,
0x0000001f2006723eULL, 0x000fe400000010ffULL, 0x000000072d2d7812ULL, 0x000fc400078ec0ffULL,
0x0000000710107812ULL, 0x000fc800078ec0ffULL, 0x1ffffff810107812ULL, 0x000fe400078ef82bULL,
0x0000002f3002723eULL, 0x002fe400000010ffULL, 0x0000001a1b03723eULL, 0x000fe400000010ffULL,
0x00005410000e7816ULL, 0x140fe40000000002ULL, 0x00007632000f7816ULL, 0x000fe40000000002ULL,
0x0000541003027816ULL, 0x000fc40000000004ULL, 0x0000763203037816ULL, 0x000fe20000000004ULL,
0x0000000e09007388ULL, 0x000fe20000000a00ULL, 0x0000541005047816ULL, 0x140fe40000000006ULL,
0x0000763205057816ULL, 0x000fe20000000006ULL, 0x000000020a007388ULL, 0x0003e20000000a00ULL,
0x000000232400723eULL, 0x000fc600000010ffULL, 0x0004000407007388ULL, 0x0007e20000000a00ULL,
0x000000272802723eULL, 0x002fe400000010ffULL, 0x0000002c2e03723eULL, 0x000fe200000010ffULL,
0x0000000000057919ULL, 0x008e620000002600ULL, 0x000000313204723eULL, 0x000fe400000010ffULL,
0x0000541000067816ULL, 0x140fe40000000002ULL, 0x0000763200077816ULL, 0x000fe40000000002ULL,
0x0000541003027816ULL, 0x000fc40000000004ULL, 0x0000763203037816ULL, 0x000fe20000000004ULL,
0x0004000608007388ULL, 0x000fe80000000a00ULL, 0x0004000209007388ULL, 0x0007e20000000a00ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000000000c0c7984ULL, 0x000f220000000c00ULL,
0x0000000805007824ULL, 0x002fc600078e00ffULL, 0x0000000012147984ULL, 0x000e620000000c00ULL,
0x0000000805057824ULL, 0x000fe200078e00ffULL, 0xfffffff8000b7812ULL, 0x000fc800078ee20bULL,
0xfffffff805117812ULL, 0x000fe400078ee211ULL, 0x000000040b0b7c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000411117c10ULL, 0x000fc6000ff3e0ffULL, 0x000000ffff007224ULL, 0x000fe200000e06ffULL,
0x00005a000b027a11ULL, 0x008fe200078048ffULL, 0x000000ffff057224ULL, 0x000fe200008e06ffULL,
0x00005a0011047a11ULL, 0x000fe400078248ffULL, 0x00005b000b037a11ULL, 0x000fe400000f4c00ULL,
0x1ffffff82d007812ULL, 0x000fe400078ef82bULL, 0x00005b0011057a11ULL, 0x000fc600008f4c05ULL,
0x0000001000027825ULL, 0x000fc800078e0002ULL, 0x0000001010047825ULL, 0x000fe200078e0004ULL,
0x0000000c02007986ULL, 0x010fe8000c101d06ULL, 0x0000001404007986ULL, 0x002fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x000000290000720cULL, 0x000fe20003f06070ULL,
0xffffffffff397424ULL, 0x000fd800078e00ffULL, 0x0000000241048824ULL, 0x002fc800078e00ffULL,
0x0000640004048a24ULL, 0x000fc800078e0200ULL, 0x0000600004048625ULL, 0x000fe200078e0005ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000604398981ULL, 0x0002a2000c1e1900ULL,
0x000001ff0600780cULL, 0x000fe20003f04070ULL, 0x0000000604047899ULL, 0x000fe2000800063fULL,
0x00006800ff047624ULL, 0x002fe400078e00ffULL, 0x00006900ff057624ULL, 0x000fca00078e00ffULL,
0x0000000604407981ULL, 0x000322000c1e9900ULL, 0x0000004000387824ULL, 0x000fe400078e00ffULL,
0x00000040032b7824ULL, 0x000fe200078e00ffULL, 0x01060000ff047f8cULL, 0x002e62000c80043fULL,
0x0000000439167c24ULL, 0x004fe2000f8e02ffULL, 0x0000071000000947ULL, 0x000fea0003800000ULL,
0x00000002ff177819ULL, 0x002fe40000011602ULL, 0x000000300e157812ULL, 0x000fe400078ec0ffULL,
0x00002000000d7811ULL, 0x000fe200078e68ffULL, 0x00000040030c7824ULL, 0x000fca00078e0217ULL,
0x000000080c037810ULL, 0x040fe40007ffe0ffULL, 0x000000100c067810ULL, 0x000fe40007ffe0ffULL,
0x0000000316037210ULL, 0x040fe40007f3e0ffULL, 0x0000000616067210ULL, 0x040fe40007f5e0ffULL,
0x0000000c16147210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff137224ULL, 0x000fe200008e06ffULL,
0x00005e00030f7a11ULL, 0x000fe200078240ffULL, 0x000000ffff127224ULL, 0x000fe200010e06ffULL,
0x000000180c077810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0a7224ULL, 0x000fe200000e06ffULL,
0x00005e0006087a11ULL, 0x000fc400078440ffULL, 0x00005f0003137a11ULL, 0x000fe400008f4413ULL,
0x0000000716077210ULL, 0x000fe40007f7e0ffULL, 0x00005e0014097a11ULL, 0x000fe400078040ffULL,
0x0000003828037217ULL, 0x000fe20007800000ULL, 0x000000ffff117224ULL, 0x000fe200018e06ffULL,
0x00005f0006127a11ULL, 0x000fe400010f4412ULL, 0x0000000202067211ULL, 0x000fc400078fe8ffULL,
0x00005f0014147a11ULL, 0x000fe200000f440aULL, 0x00000001030a7824ULL, 0x000fe200078e0a38ULL,
0x00005e0007107a11ULL, 0x000fe400078640ffULL, 0x00000003060b7812ULL, 0x000fe400078ec0ffULL,
0x0000000817067810ULL, 0x000fe40007ffe0ffULL, 0x00005f0007117a11ULL, 0x000fe400018f4411ULL,
0x0000000a1700720cULL, 0x000fc40003f06070ULL, 0x0000001017077810ULL, 0x000fe40007ffe0ffULL,
0x0ffffffc0b037812ULL, 0x000fe400078ef802ULL, 0x0000000a0600720cULL, 0x0c0fe20003f26070ULL,
0x0000000406067824ULL, 0x000fe200078e00ffULL, 0x0000000915027210ULL, 0x000fe20007f7e0ffULL,
0x00000004070e7824ULL, 0x040fe200078e00ffULL, 0x0000000a0700720cULL, 0x000fe20003f46070ULL,
0x0000001003097824ULL, 0x000fe200078e020dULL, 0xfffffffc06077812ULL, 0x000fe200078ee20bULL,
0x000000ffff037224ULL, 0x000fe200018e0614ULL, 0x000000150f067210ULL, 0x000fc40007f7e0ffULL,
0xfffffffc0e0f7812ULL, 0x000fe200078ee20bULL, 0x00000010070e7824ULL, 0x000fe200078e020dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002097faeULL, 0x0003e2000c101c46ULL,
0x000000ffff077224ULL, 0x000fe200018e0613ULL, 0x0000001508087210ULL, 0x000fe20007f9e0ffULL,
0x000000100f0f7824ULL, 0x000fc600078e020dULL, 0x00000000060e7faeULL, 0x0005e2000c901c46ULL,
0x0000001817037810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff097224ULL, 0x000fe200020e0612ULL,
0x000000200c027810ULL, 0x000fe40007ffe0ffULL, 0x0000000a0300720cULL, 0x040fe40003f86070ULL,
0x0000000216147210ULL, 0x000fe20007f1e0ffULL, 0x0000000403067824ULL, 0x004fe200078e00ffULL,
0x0000001510027210ULL, 0x000fe20007fbe0ffULL, 0x00000000080f7faeULL, 0x0003e2000d101c46ULL,
0x00005e0014137a11ULL, 0x000fe200078c40ffULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0xfffffffc06067812ULL, 0x000fc400078ee20bULL, 0x0000002017077810ULL, 0x040fe40007ffe0ffULL,
0x00005f0014147a11ULL, 0x000fe200030f4403ULL, 0x000000ffff037224ULL, 0x000fe200028e0611ULL,
0x00000030170e7810ULL, 0x000fe20007ffe0ffULL, 0x0000001006067824ULL, 0x000fe200078e020dULL,
0x0000000a0700720cULL, 0x000fe40003f66070ULL, 0x0000002817087810ULL, 0x042fe40007ffe0ffULL,
0x00000038170f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000002067faeULL, 0x0003e2000e101c46ULL,
0x000000280c097810ULL, 0x000fc40007ffe0ffULL, 0x0000000a0800720cULL, 0x080fe40003f46070ULL,
0x0000000916127210ULL, 0x000fe40007fbe0ffULL, 0x0000000a0e00720cULL, 0x080fe40003f26070ULL,
0x0000000a0f00720cULL, 0x000fe40003f06070ULL, 0x000000300c0a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000407027824ULL, 0x002fe200078e00ffULL, 0x000000380c0c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000408037824ULL, 0x000fe200078e00ffULL, 0x0000000a16107210ULL, 0x000fe20007f9e0ffULL,
0x000000040e067824ULL, 0x000fe200078e00ffULL, 0xfffffffc02027812ULL, 0x100fe200078ee20bULL,
0x000000040f077824ULL, 0x000fe200078e00ffULL, 0xfffffffc03037812ULL, 0x000fc400078ee20bULL,
0xfffffffc06067812ULL, 0x100fe400078ee20bULL, 0xfffffffc07077812ULL, 0x000fe200078ee20bULL,
0x00000010020b7824ULL, 0x100fe200078e020dULL, 0x0000000c16097210ULL, 0x000fe20007fde0ffULL,
0x000000ffff027224ULL, 0x000fe200028e06ffULL, 0x00005e0012117a11ULL, 0x000fe200078a40ffULL,
0x00000010030c7824ULL, 0x100fe400078e020dULL, 0x00000010060e7824ULL, 0x100fe200078e020dULL,
0x00005f0012127a11ULL, 0x000fe200028f4402ULL, 0x00000010070d7824ULL, 0x000fe200078e020dULL,
0x0000001513027210ULL, 0x080fe20007fbe0ffULL, 0x000000ffff077224ULL, 0x000fe200020e06ffULL,
0x00005e0010087a11ULL, 0x000fe200078840ffULL, 0x000000ffff0f7224ULL, 0x000fe200030e06ffULL,
0x00005e00090a7a11ULL, 0x000fe200078c40ffULL, 0x000000ffff037224ULL, 0x000fe200028e0614ULL,
0x0000001511067210ULL, 0x000fc40007fbe0ffULL, 0x00005f0010107a11ULL, 0x000fe400020f4407ULL,
0x0000001508087210ULL, 0x080fe20007f9e0ffULL, 0x000000ffff077224ULL, 0x000fe200028e0612ULL,
0x00005f00090f7a11ULL, 0x000fe200030f440fULL, 0x00000000020b7faeULL, 0x0003e2000d901c46ULL,
0x000000150a0a7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff097224ULL, 0x000fe400020e0610ULL,
0x00000000060c7faeULL, 0x0005e8000d101c46ULL, 0x00000000080e7faeULL, 0x0005e2000c901c46ULL,
0x000000ffff0b7224ULL, 0x002fca00028e060fULL, 0x000000000a0d7faeULL, 0x0005e2000c101c46ULL,
0x0000065000007947ULL, 0x000fea0003800000ULL, 0x0000002b02037211ULL, 0x042fe400078ff0ffULL,
0x0000000802157811ULL, 0x000fe400078ff0ffULL, 0x0000000316037210ULL, 0x000fe40007f1e0ffULL,
0x0000001802087811ULL, 0x040fe400078ff0ffULL, 0x00000020020a7811ULL, 0x040fe200078ff0ffULL,
0x000000ffff207224ULL, 0x000fe200000e06ffULL, 0x00005e00031f7a11ULL, 0x000fe200078040ffULL,
0x000000012b097824ULL, 0x040fe200078e0208ULL, 0x0000001002067811ULL, 0x040fe200078ff0ffULL,
0x000000012b0b7824ULL, 0x000fe200078e020aULL, 0x00005f0003207a11ULL, 0x000fe200000f4420ULL,
0x000000012b037824ULL, 0x040fe200078e0215ULL, 0x00000028020c7811ULL, 0x040fe200078ff0ffULL,
0x000000012b077824ULL, 0x000fe200078e0206ULL, 0x0000000202147211ULL, 0x040fe200078fe8ffULL,
0x0000000415157824ULL, 0x000fe200078e00ffULL, 0x00000030020f7811ULL, 0x000fe200078ff0ffULL,
0x000000012b0d7824ULL, 0x000fe200078e020cULL, 0x00000003161e7210ULL, 0x000fe20007fde0ffULL,
0x0000000406037824ULL, 0x000fe200078e00ffULL, 0x0000003802117811ULL, 0x000fe200078ff0ffULL,
0x0000000408067824ULL, 0x000fe200078e00ffULL, 0x00000009161b7210ULL, 0x000fe20007f1e0ffULL,
0x000000040c087824ULL, 0x000fe200078e00ffULL, 0x0000000314147812ULL, 0x000fe200078ec0ffULL,
0x000000040f097824ULL, 0x000fe200078e00ffULL, 0x0000000b160b7210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200030e06ffULL, 0x0000000d16197210ULL, 0x000fe20007f5e0ffULL,
0x000000012b107824ULL, 0x040fe200078e020fULL, 0x00005e001e1d7a11ULL, 0x000fe200078c40ffULL,
0x000000012b127824ULL, 0x000fe200078e0211ULL, 0x0000200000177811ULL, 0x000fe200078e68ffULL,
0x000000ffff1a7224ULL, 0x000fe200008e06ffULL, 0x0ffffffc140d7812ULL, 0x000fc400078ef802ULL,
0xfffffffc03037812ULL, 0x100fe400078ee214ULL, 0x00000007161c7210ULL, 0x000fe20007fbe0ffULL,
0x000000040a077824ULL, 0x000fe200078e00ffULL, 0xfffffffc15027812ULL, 0x100fe200078ee214ULL,
0x000000100d217824ULL, 0x100fe200078e0217ULL, 0xfffffffc08087812ULL, 0x100fe200078ee214ULL,
0x00000010030f7824ULL, 0x100fe200078e0217ULL, 0xfffffffc09097812ULL, 0x000fe200078ee214ULL,
0x00000004110a7824ULL, 0x000fe200078e00ffULL, 0x00005f001e1e7a11ULL, 0x000fe200030f440cULL,
0x00000010020d7824ULL, 0x100fe200078e0217ULL, 0x00005e000b0c7a11ULL, 0x000fe200078240ffULL,
0x0000001008157824ULL, 0x100fe200078e0217ULL, 0x0000001016187210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff037224ULL, 0x000fe200028e06ffULL, 0x0000001216137210ULL, 0x000fe20007f9e0ffULL,
0x0000001009167824ULL, 0x000fe200078e0217ULL, 0xfffffffc06067812ULL, 0x100fe200078ee214ULL,
0x000000ffff027224ULL, 0x000fe200000e06ffULL, 0xfffffffc07077812ULL, 0x000fc400078ee214ULL,
0x00005e001c087a11ULL, 0x000fe200078a40ffULL, 0x0000001006117824ULL, 0x100fe200078e0217ULL,
0x00005e001b097a11ULL, 0x000fe200078040ffULL, 0x000000ffff067224ULL, 0x000fe200018e06ffULL,
0x00005f000b1a7a11ULL, 0x000fe400008f441aULL, 0x000000300e0b7812ULL, 0x000fe400078ec0ffULL,
0xfffffffc0a0a7812ULL, 0x000fe200078ee214ULL, 0x0000001007147824ULL, 0x000fe200078e0217ULL,
0x00005f001c1c7a11ULL, 0x000fe200028f4403ULL, 0x000000ffff037224ULL, 0x000fe200020e06ffULL,
0x00005f001b1b7a11ULL, 0x000fe200000f4402ULL, 0x000000ffff077224ULL, 0x000fe200010e06ffULL,
0x00005e0013127a11ULL, 0x000fe200078640ffULL, 0x000000100a177824ULL, 0x000fe200078e0217ULL,
0x0000001f0b027210ULL, 0x000fc40007f1e0ffULL, 0x00005e0018107a11ULL, 0x040fe400078440ffULL,
0x00005e00190e7a11ULL, 0x000fe400078240ffULL, 0x00005f0013137a11ULL, 0x000fe200018f4403ULL,
0x000000ffff037224ULL, 0x000fe200000e0620ULL, 0x00005f0018187a11ULL, 0x000fe400010f4406ULL,
0x00005f0019197a11ULL, 0x000fe400008f4407ULL, 0x0000001d0b067210ULL, 0x040fe20007f1e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002217faeULL, 0x0003e2000b901c46ULL,
0x000000080b087210ULL, 0x000fc40007f3e0ffULL, 0x000000090b0a7210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff077224ULL, 0x000fe200000e061eULL, 0x0000000c0b0c7210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e061cULL, 0x0000000e0b0e7210ULL, 0x040fe40007f9e0ffULL,
0x000000100b107210ULL, 0x040fe20007fbe0ffULL, 0x00000000060d7faeULL, 0x0005e2000b901c46ULL,
0x000000120b127210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff0b7224ULL, 0x000fe400010e061bULL,
0x00000000080f7faeULL, 0x0007e4000b901c46ULL, 0x000000ffff137224ULL, 0x000fc400000e0613ULL,
0x000000000a117faeULL, 0x0003e2000b901c46ULL, 0x000000ffff0d7224ULL, 0x004fe400018e061aULL,
0x000000ffff0f7224ULL, 0x008fc600020e0619ULL, 0x000000000c147faeULL, 0x0005e2000b901c46ULL,
0x000000ffff117224ULL, 0x002fc600028e0618ULL, 0x000000000e157faeULL, 0x0005e8000b901c46ULL,
0x0000000010167faeULL, 0x0005e8000b901c46ULL, 0x0000000012177faeULL, 0x0005e4000b901c46ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000027805ULL, 0x000fc40000015200ULL,
0x01060400ff067984ULL, 0x004e640000000800ULL, 0x8000000006ff7812ULL, 0x002fc40007804805ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff097224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000602087210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e03ULL, 0x003d09000800780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400800780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000000806067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000109097810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01060400ff067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000027919ULL, 0x000e640000000000ULL, 0x0000002000027824ULL, 0x002fca00078e0202ULL,
0x00000003ff037819ULL, 0x000fe40000011602ULL, 0x0000000f02027812ULL, 0x000fe400078ec0ffULL,
0x1ffffffe03037812ULL, 0x000fe400078ec0ffULL, 0x0000000102047810ULL, 0x040fe20007ffe0ffULL,
0x0000002002087824ULL, 0x040fe400078e00ffULL, 0x0000000102057824ULL, 0x040fe400078e0203ULL,
0x0000000103067824ULL, 0x040fe200078e0204ULL, 0x0000001003037810ULL, 0x000fe20007ffe0ffULL,
0x0000002002077824ULL, 0x000fe200078e00ffULL, 0x0000001f05057812ULL, 0x000fc400078ec0ffULL,
0x0000001f06067812ULL, 0x000fe400078ec0ffULL, 0x000001e007057812ULL, 0x000fe200078ee205ULL,
0x0000000102077824ULL, 0x100fe200078e0203ULL, 0x000001e008067812ULL, 0x000fe200078ee206ULL,
0x0000000104037824ULL, 0x000fe400078e0203ULL, 0x00000000050c7984ULL, 0x000e62000000cc00ULL,
0x0000002002047824ULL, 0x040fe200078e00ffULL, 0x0000001f07077812ULL, 0x000fe200078ec0ffULL,
0x0000002002027824ULL, 0x000fe200078e00ffULL, 0x0000000006087984ULL, 0x000ea2000000cc00ULL,
0x0000001f03037812ULL, 0x000fc400078ec0ffULL, 0x000001e004077812ULL, 0x000fe400078ee207ULL,
0x000001e002037812ULL, 0x000fe200078ee203ULL, 0x000000ffff107224ULL, 0x002fe400078e000cULL,
0x000000ffff117224ULL, 0x000fe400078e000eULL, 0x000000ffff137224ULL, 0x004fe400078e000aULL,
0x000000ffff127224ULL, 0x000fe400078e0008ULL, 0x000000ffff0a7224ULL, 0x000fc400078e0009ULL,
0x000000ffff087224ULL, 0x000fe200078e000dULL, 0x0000001005007388ULL, 0x000fe2000000cc00ULL,
0x000000ffff097224ULL, 0x000fca00078e000fULL, 0x0000000806007388ULL, 0x000fe8000000cc00ULL,
0x0000000003087984ULL, 0x000e68000000cc00ULL, 0x00000000070c7984ULL, 0x000ea2000000cc00ULL,
0x000000ffff177224ULL, 0x002fe400078e000aULL, 0x000000ffff167224ULL, 0x000fc400078e0008ULL,
0x000000ffff0a7224ULL, 0x000fe400078e0009ULL, 0x000000ffff147224ULL, 0x004fe400078e000cULL,
0x000000ffff157224ULL, 0x000fe400078e000eULL, 0x000000ffff087224ULL, 0x000fe400078e000dULL,
0x000000ffff097224ULL, 0x000fe200078e000fULL, 0x0000001407007388ULL, 0x0003e8000000cc00ULL,
0x0000000803007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01060000ff067f8cULL, 0x002e62000c80043fULL, 0x000000ffff097224ULL, 0x000fc600078e00ffULL,
0x0000000000027805ULL, 0x000fc80000015200ULL, 0x01060400ff047984ULL, 0x000ea40000000800ULL,
0x8000000004ff7812ULL, 0x006fc40007804807ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000047805ULL, 0x000fcc0000015200ULL, 0x0000000402087210ULL, 0x000fca0007f1e1ffULL,
0x0000000105057824ULL, 0x000fe200000e0e03ULL, 0x003d09000800780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400800780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc80000011405ULL,
0x0000000804047211ULL, 0x000fca00078110ffULL, 0x000000ffff057224ULL, 0x000fca00000e0605ULL,
0x0000000204047819ULL, 0x000fc80000001205ULL, 0x000000040000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000109097810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01060400ff047984ULL, 0x000e640000000800ULL,
0x8000000004ff7812ULL, 0x002fe40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff2a00720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000027919ULL, 0x000e620000000000ULL, 0x0000640041417a24ULL, 0x000fe200078e02ffULL,
0x3d80000040407820ULL, 0x010fe20000410000ULL, 0x00010688003f7811ULL, 0x000fe200078e18ffULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0xffffffff2a3e7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff3b7224ULL, 0x000fe200078e00ffULL, 0x00010608003d7811ULL, 0x000fe200078e28ffULL,
0x000000ffff3a7224ULL, 0x000fc400078e0000ULL, 0x000001003c037824ULL, 0x000fe200078e0238ULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x000000032800720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x01cfea0003800000ULL, 0x000000ffff427224ULL, 0x000fe200078e003bULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x000000ffff437224ULL, 0x000fe200078e00ffULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fc4000001ff00ULL, 0x0000000143247810ULL, 0x020fe20007ffe0ffULL,
0x00000d6000007945ULL, 0x000fe20003800000ULL, 0x000000ffff447224ULL, 0x000fe200078e0043ULL,
0x00000001423b7812ULL, 0x000fe200078e0cffULL, 0x0000000439377c24ULL, 0x010fe2000f8e02ffULL,
0x0000003c24267211ULL, 0x040fe200078ff0ffULL, 0x000000ffff437224ULL, 0x000fe200078e0024ULL,
0x000000042400780cULL, 0x000fc40003f06070ULL, 0x0000000126257810ULL, 0x000fe40007ffe0ffULL,
0x0000000324547812ULL, 0x000fe400078ec0ffULL, 0x0000002a2500720cULL, 0x000fda0003f26070ULL,
0x000006c000009947ULL, 0x000fea0003800000ULL, 0x00000002ff337819ULL, 0x002fe20000011602ULL,
0x0000010026257824ULL, 0x000fe400078e0238ULL, 0x0000000200477824ULL, 0x000fe200078e023bULL,
0x00000010334e7810ULL, 0x000fe20007ffe0ffULL, 0x000000012b247824ULL, 0x000fe200078e0233ULL,
0x0000000833467810ULL, 0x040fe40007ffe0ffULL, 0x00000018334f7810ULL, 0x000fe20007ffe0ffULL,
0x000000012b2c7824ULL, 0x000fe200078e024eULL, 0x0000002437317210ULL, 0x000fe20007f3e0ffULL,
0x000000012b267824ULL, 0x000fe200078e0246ULL, 0x0000002528277217ULL, 0x000fe20007800000ULL,
0x0000000446497824ULL, 0x000fe200078e00ffULL, 0x0000002c372d7210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff327224ULL, 0x000fe200008e06ffULL, 0x00000026372f7210ULL, 0x000fe20007f5e0ffULL,
0x0000000127457824ULL, 0x000fe200078e0a25ULL, 0x0000002033507810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2e7224ULL, 0x000fe200018e06ffULL, 0x00005e002d2c7a11ULL, 0x000fe200078640ffULL,
0x000000ffff307224ULL, 0x000fe200010e06ffULL, 0x00005e002f267a11ULL, 0x000fc400078440ffULL,
0x00005f002d2d7a11ULL, 0x000fe200018f442eULL, 0x000000012b2e7824ULL, 0x000fe200078e024fULL,
0x0000002833517810ULL, 0x000fe40007ffe0ffULL, 0x00005e0031247a11ULL, 0x000fe400078240ffULL,
0x0000003033527810ULL, 0x040fe40007ffe0ffULL, 0x0000003833537810ULL, 0x000fe40007ffe0ffULL,
0x00005f002f277a11ULL, 0x000fe200010f4430ULL, 0x000000012b2f7824ULL, 0x000fe200078e0250ULL,
0x00005f0031257a11ULL, 0x000fe200008f4432ULL, 0x000000012b307824ULL, 0x000fe200078e0251ULL,
0x0000002e37367210ULL, 0x000fe20007f3e0ffULL, 0x000000012b317824ULL, 0x000fe200078e0252ULL,
0x000000453300720cULL, 0x000fe20003f46070ULL, 0x000000012b327824ULL, 0x000fe200078e0253ULL,
0x0000002f37347210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff2f7224ULL, 0x000fe200008e06ffULL,
0x0000003037337210ULL, 0x000fc40007fde0ffULL, 0x0000000202307211ULL, 0x000fe400078fe8ffULL,
0x00005e00362e7a11ULL, 0x000fe200078240ffULL, 0x000000ffff4c7224ULL, 0x000fe200030e06ffULL,
0x0000003137357210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff317224ULL, 0x000fe200028e06ffULL,
0x0000003237377210ULL, 0x000fe20007f7e0ffULL, 0x0000000454327824ULL, 0x000fe200078e00ffULL,
0x00000003304d7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff4b7224ULL, 0x000fe200020e06ffULL,
0x00005f00362f7a11ULL, 0x000fe200008f442fULL, 0x000000ffff4a7224ULL, 0x000fe200018e06ffULL,
0x000000454600720cULL, 0x000fc40003f26070ULL, 0x0000200047477811ULL, 0x000fe400078e60ffULL,
0x0ffffffc4d487812ULL, 0x100fe400078ef802ULL, 0xfffffffc32467812ULL, 0x000fe400078ee202ULL,
0xfffffffc49497812ULL, 0x000fe200078ee24dULL, 0x0000001048487824ULL, 0x000fe200078e0247ULL,
0x00005e0034307a11ULL, 0x000fe200078a40ffULL, 0x0000001046247825ULL, 0x000fe200078e0024ULL,
0x00005e0037367a11ULL, 0x000fc400078640ffULL, 0x00005f0034317a11ULL, 0x000fe200028f4431ULL,
0x0000001049497824ULL, 0x000fe200078e0247ULL, 0x00005e0033327a11ULL, 0x000fe200078a40ffULL,
0x0000001046267825ULL, 0x000fe200078e0026ULL, 0x00005e0035347a11ULL, 0x000fe200078840ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024487faeULL, 0x0003e2000d101c46ULL,
0x00005f0033337a11ULL, 0x000fe400028f444cULL, 0x00005f0035357a11ULL, 0x000fe200020f444bULL,
0x0000000026497faeULL, 0x0005e2000c901c46ULL, 0x00005f0037377a11ULL, 0x000fe200018f444aULL,
0x00000004514a7824ULL, 0x000fe200078e00ffULL, 0x000000454e00720cULL, 0x080fe20003f26070ULL,
0x00000004524b7824ULL, 0x000fe200078e00ffULL, 0x000000454f00720cULL, 0x000fc40003f46070ULL,
0x000000455000720cULL, 0x080fe20003f66070ULL, 0x000000044f487824ULL, 0x002fe200078e00ffULL,
0x000000455100720cULL, 0x080fe20003f86070ULL, 0x0000001046247825ULL, 0x000fe200078e002cULL,
0x000000455200720cULL, 0x080fe40003fa6070ULL, 0x000000455300720cULL, 0x040fe20003fc6070ULL,
0x000000044e457824ULL, 0x000fe200078e00ffULL, 0xfffffffc48487812ULL, 0x100fe200078ee24dULL,
0x0000000450497824ULL, 0x004fe200078e00ffULL, 0xfffffffc4a4a7812ULL, 0x100fe200078ee24dULL,
0x0000000453537824ULL, 0x000fe200078e00ffULL, 0xfffffffc45457812ULL, 0x000fe200078ee24dULL,
0x0000001048487824ULL, 0x000fe200078e0247ULL, 0xfffffffc49497812ULL, 0x000fe200078ee24dULL,
0x0000001046267825ULL, 0x000fe200078e002eULL, 0xfffffffc4b4b7812ULL, 0x000fc400078ee24dULL,
0xfffffffc534d7812ULL, 0x000fe200078ee24dULL, 0x0000001045457824ULL, 0x100fe400078e0247ULL,
0x0000001049497824ULL, 0x000fe400078e0247ULL, 0x00000010462c7825ULL, 0x000fe200078e0030ULL,
0x0000000024457faeULL, 0x0003e6000c901c46ULL, 0x000000104a4a7824ULL, 0x000fe200078e0247ULL,
0x0000000026487faeULL, 0x0003e2000d101c46ULL, 0x00000010462e7825ULL, 0x000fc600078e0032ULL,
0x000000002c497faeULL, 0x0003e2000d901c46ULL, 0x000000104b4b7824ULL, 0x000fe400078e0247ULL,
0x0000001046307825ULL, 0x040fe200078e0034ULL, 0x000000002e4a7faeULL, 0x0003e6000e101c46ULL,
0x000000104d477824ULL, 0x000fe200078e0247ULL, 0x00000000304b7faeULL, 0x0003e2000e901c46ULL,
0x0000001046327825ULL, 0x000fca00078e0036ULL, 0x0000000032477faeULL, 0x0003e2000f101c46ULL,
0x000005f000007947ULL, 0x000fea0003800000ULL, 0x0000000802327811ULL, 0x002fe200078ff0ffULL,
0x0000000454507824ULL, 0x000fe200078e00ffULL, 0x0000002b02257211ULL, 0x040fe400078ff0ffULL,
0x0000001002347811ULL, 0x000fe200078ff0ffULL, 0x000000012b277824ULL, 0x000fe200078e0232ULL,
0x0000003725257210ULL, 0x080fe20007f3e0ffULL, 0x0000000432327824ULL, 0x000fe200078e00ffULL,
0x0000001802367811ULL, 0x040fe400078ff0ffULL, 0x0000003727277210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff2d7224ULL, 0x000fe200008e06ffULL, 0x00005e0025247a11ULL, 0x000fe200078240ffULL,
0x000000012b2f7824ULL, 0x000fe200078e0236ULL, 0x0000002002457811ULL, 0x000fe200078ff0ffULL,
0x000000ffff2c7224ULL, 0x000fe200010e06ffULL, 0x00005e0027267a11ULL, 0x000fe200078440ffULL,
0x0000000436367824ULL, 0x000fe200078e00ffULL, 0x0000002802467811ULL, 0x040fe200078ff0ffULL,
0x000000012b317824ULL, 0x000fe200078e0245ULL, 0x0000003002477811ULL, 0x000fc400078ff0ffULL,
0x0000003802487811ULL, 0x000fe200078ff0ffULL, 0x000000012b337824ULL, 0x000fe200078e0246ULL,
0x00005f0025257a11ULL, 0x000fe200008f442dULL, 0x000000012b2d7824ULL, 0x000fe200078e0234ULL,
0x00005f0027277a11ULL, 0x000fe200010f442cULL, 0x00000002002c7824ULL, 0x000fe200078e023bULL,
0x00000002022e7211ULL, 0x000fe200078fe8ffULL, 0x000000012b357824ULL, 0x000fe200078e0247ULL,
0x000000372d2d7210ULL, 0x080fe20007fde0ffULL, 0x000000012b307824ULL, 0x000fe200078e0248ULL,
0x000000372f2f7210ULL, 0x080fe20007fbe0ffULL, 0x0000000434347824ULL, 0x000fe200078e00ffULL,
0x0000003731317210ULL, 0x080fe20007f9e0ffULL, 0x0000000446497824ULL, 0x000fe200078e00ffULL,
0x0000003733337210ULL, 0x080fe20007f3e0ffULL, 0x00000004474a7824ULL, 0x000fe200078e00ffULL,
0x0000003735357210ULL, 0x080fe20007f5e0ffULL, 0x00000004484c7824ULL, 0x000fe200078e00ffULL,
0x000020002c4b7811ULL, 0x000fe200078e60ffULL, 0x00000004452c7824ULL, 0x000fe200078e00ffULL,
0x0000003730377210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff4f7224ULL, 0x000fe200020e06ffULL,
0x000000032e307812ULL, 0x000fe200078ec0ffULL, 0x000000ffff2e7224ULL, 0x000fe200030e06ffULL,
0xfffffffc50507812ULL, 0x000fe200078ee202ULL, 0x000000ffff4e7224ULL, 0x000fe200008e06ffULL,
0xfffffffc2c487812ULL, 0x000fe200078ee230ULL, 0x000000ffff4d7224ULL, 0x000fe200010e06ffULL,
0x00005e002d2c7a11ULL, 0x000fe200078c40ffULL, 0x0000001050247825ULL, 0x000fe200078e0024ULL,
0xfffffffc32457812ULL, 0x000fc400078ee230ULL, 0xfffffffc34467812ULL, 0x100fe200078ee230ULL,
0x0000001048487824ULL, 0x100fe200078e024bULL, 0xfffffffc36477812ULL, 0x100fe200078ee230ULL,
0x0000001045457824ULL, 0x100fe200078e024bULL, 0xfffffffc49497812ULL, 0x100fe200078ee230ULL,
0x0000001046467824ULL, 0x100fe200078e024bULL, 0xfffffffc4a4a7812ULL, 0x000fe200078ee230ULL,
0x0000001047477824ULL, 0x100fe200078e024bULL, 0x0ffffffc30327812ULL, 0x000fe200078ef802ULL,
0x0000001049497824ULL, 0x100fe200078e024bULL, 0xfffffffc4c347812ULL, 0x000fe200078ee230ULL,
0x000000ffff307224ULL, 0x000fe200028e06ffULL, 0x00005f002d2d7a11ULL, 0x000fe200030f442eULL,
0x0000001032517824ULL, 0x100fe200078e024bULL, 0x00005e002f2e7a11ULL, 0x000fe200078a40ffULL,
0x000000104a4a7824ULL, 0x100fe200078e024bULL, 0x00005e0033327a11ULL, 0x000fe200078240ffULL,
0x00000010344b7824ULL, 0x000fe200078e024bULL, 0x00005f002f2f7a11ULL, 0x000fe200028f4430ULL,
0x000000ffff4c7224ULL, 0x000fe200018e06ffULL, 0x00005e0031307a11ULL, 0x000fe200078840ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024517faeULL, 0x0003e2000b901c46ULL,
0x00005e0035347a11ULL, 0x000fc400078440ffULL, 0x00005e0037367a11ULL, 0x000fe400078640ffULL,
0x00005f0031317a11ULL, 0x000fe400020f444fULL, 0x00005f0033337a11ULL, 0x000fe400008f444eULL,
0x00005f0035357a11ULL, 0x000fe400010f444dULL, 0x00005f0037377a11ULL, 0x000fe200018f444cULL,
0x0000001050247825ULL, 0x002fc800078e0026ULL, 0x0000001050267825ULL, 0x040fe200078e002cULL,
0x0000000024457faeULL, 0x0003e6000b901c46ULL, 0x00000010502c7825ULL, 0x040fe200078e002eULL,
0x0000000026467faeULL, 0x0003e6000b901c46ULL, 0x00000010502e7825ULL, 0x040fe200078e0030ULL,
0x000000002c477faeULL, 0x0003e6000b901c46ULL, 0x0000001050307825ULL, 0x040fe200078e0032ULL,
0x000000002e487faeULL, 0x0003e6000b901c46ULL, 0x0000001050327825ULL, 0x040fe200078e0034ULL,
0x0000000030497faeULL, 0x0003e6000b901c46ULL, 0x0000001050347825ULL, 0x000fe200078e0036ULL,
0x00000000324a7faeULL, 0x0003e8000b901c46ULL, 0x00000000344b7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000035400780cULL, 0x000fe20003f25270ULL,
0x000000a000007945ULL, 0x000fd80003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x000000043a3a7810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff397424ULL, 0x000fc600078e00ffULL,
0x000000293a00720cULL, 0x000fda0003f26070ULL, 0x0000004000001947ULL, 0x000fea0003800000ULL,
0x0000000241247824ULL, 0x002fe400078e023aULL, 0x00000004ff257424ULL, 0x000fc800078e00ffULL,
0x0000600024247625ULL, 0x000fca00078e0025ULL, 0x0000000624397981ULL, 0x000324000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000ffff457224ULL, 0x002fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xfffffff802247812ULL, 0x020fe200078ec0ffULL, 0x00000002002c7824ULL, 0x000fe200078e0242ULL,
0x00000020022d7810ULL, 0x000fe20007ffe0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000724247812ULL, 0x000fe400078ef802ULL, 0x000020002c2c7811ULL, 0x000fe400078e60ffULL,
0x00000001ff257819ULL, 0x000fe20000011624ULL, 0x0000000424277824ULL, 0x040fe200078e00ffULL,
0xfffffff82d2d7812ULL, 0x000fe200078ec0ffULL, 0x0000000424247824ULL, 0x000fe200078e00ffULL,
0x0000000145497810ULL, 0x000fe20007ffe0ffULL, 0x0000000125267824ULL, 0x000fe200078e0245ULL,
0x000000072d2d7812ULL, 0x000fc600078ef802ULL, 0x0000000125257824ULL, 0x000fe200078e0249ULL,
0xfffffffc27267812ULL, 0x000fe200078ee226ULL, 0x000000042d307824ULL, 0x040fe200078e00ffULL,
0x00000001ff2e7819ULL, 0x000fe2000001162dULL, 0x000000042d2d7824ULL, 0x000fe200078e00ffULL,
0xfffffffc24257812ULL, 0x000fe200078ee225ULL, 0x0000001026267824ULL, 0x100fe400078e022cULL,
0x000000012e2f7824ULL, 0x040fe400078e0245ULL, 0x0000001025257824ULL, 0x000fe200078e022cULL,
0x000000002634783bULL, 0x000e620000000200ULL, 0x000000012e2e7824ULL, 0x000fe200078e0249ULL,
0xfffffffc302f7812ULL, 0x000fc600078ee22fULL, 0x000000002524783bULL, 0x000ea20000000200ULL,
0xfffffffc2d2e7812ULL, 0x000fe200078ee22eULL, 0x000000102f2f7824ULL, 0x000fc800078e022cULL,
0x000000102e2e7824ULL, 0x000fe200078e022cULL, 0x000000002f30783bULL, 0x000eea0000000200ULL,
0x000000002e2c783bULL, 0x000ee20000000200ULL, 0x0000003400b67306ULL, 0x002fe20000009400ULL,
0x00000018ffab7819ULL, 0x000fe20000011434ULL, 0x00010000344f7824ULL, 0x000fe200078e00ffULL,
0x00000018ffa37819ULL, 0x000fe20000011435ULL, 0x0001000036b77824ULL, 0x000fe200078e00ffULL,
0x00000018ff627819ULL, 0x004fe20000011426ULL, 0x0001000026797824ULL, 0x040fe200078e00ffULL,
0x00000018ffbc7819ULL, 0x000fe2000001144fULL, 0x0000003400b47306ULL, 0x000e620000005400ULL,
0x0000010026777824ULL, 0x000fe200078e00ffULL, 0x00000018ffb77819ULL, 0x000fe200000114b7ULL,
0x0000010036af7824ULL, 0x000fe200078e00ffULL, 0x00000018ff9e7819ULL, 0x008fe20000011430ULL,
0x0001000030bb7824ULL, 0x000fe200078e00ffULL, 0x00000018ff987819ULL, 0x000fe20000011431ULL,
0x0001000037ae7824ULL, 0x000fe200078e00ffULL, 0x0000003400677306ULL, 0x0004e2000000d400ULL,
0x00000018ffaf7819ULL, 0x000fe200000114afULL, 0x0001000025867824ULL, 0x040fe200078e00ffULL,
0x00000018ff4e7819ULL, 0x000fe20000011427ULL, 0x0000010025887824ULL, 0x000fe200078e00ffULL,
0x00000018ff9c7819ULL, 0x000fe20000011436ULL, 0x0000010037aa7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6b7819ULL, 0x000fe20000011425ULL, 0x000000bc00bd7306ULL, 0x000fe20000209400ULL,
0x0000010034347824ULL, 0x004fe200078e00ffULL, 0x000000b4b600720bULL, 0x002fe20003f9d000ULL,
0x0000010033b67824ULL, 0x000fe200078e00ffULL, 0x00000018ffae7819ULL, 0x000fe200000114aeULL,
0x0001000024817824ULL, 0x040fe200078e00ffULL, 0x00000018ffbf7819ULL, 0x000fe20000011434ULL,
0x0001000035347824ULL, 0x000fe200078e00ffULL, 0x000000bc00be7306ULL, 0x000e620000205400ULL,
0x00000018ff8c7819ULL, 0x000fe20000011437ULL, 0x0000010024877824ULL, 0x000fe200078e00ffULL,
0x00000018ffaa7819ULL, 0x000fc400000114aaULL, 0x00000018ffc27819ULL, 0x000fe40000011434ULL,
0x0000000167674812ULL, 0x008fe200078efcffULL, 0x000000bf00c07306ULL, 0x000fe20000209400ULL,
0x00000018ffbb7819ULL, 0x000fe400000114bbULL, 0x00000018ff957819ULL, 0x000fe40000011432ULL,
0x00000018ff8d7819ULL, 0x000fe40000011433ULL, 0x00000018ffb67819ULL, 0x000fe200000114b6ULL,
0x000000bf00c17306ULL, 0x000ea20000205400ULL, 0x000000bebd00720bULL, 0x002fe20003f5d000ULL,
0x0001000027bd7824ULL, 0x040fe200078e00ffULL, 0x00000018ff817819ULL, 0x000fe20000011481ULL,
0x0000010027be7824ULL, 0x000fe200078e00ffULL, 0x00000018ff877819ULL, 0x000fc40000011487ULL,
0x00000018ff767819ULL, 0x000fe20000011424ULL, 0x0000003500ad7306ULL, 0x000fe20000009400ULL,
0x00000018ff867819ULL, 0x000fe40000011486ULL, 0x00000018ff887819ULL, 0x000fe40000011488ULL,
0x00000018ff797819ULL, 0x000fe40000011479ULL, 0x00000018ff777819ULL, 0x000fe20000011477ULL,
0x0000003500ac7306ULL, 0x000e620000005400ULL, 0x000000c1c000720bULL, 0x004fc40003f7d000ULL,
0x00000018ff537819ULL, 0x000fe4000001142cULL, 0x00000018ff527819ULL, 0x000fe4000001142dULL,
0x00000018ff517819ULL, 0x000fe2000001142eULL, 0x0000003500667306ULL, 0x0004f0000000d400ULL,
0x000000ab00b97306ULL, 0x000fe20000209400ULL, 0x0000010035357824ULL, 0x004fe200078e00ffULL,
0x000000acad00720bULL, 0x002fc40003f3d000ULL, 0x000000bf00ac7245ULL, 0x000fe4000020d400ULL,
0x00000018ffc57819ULL, 0x000fe40000011435ULL, 0x000000ab00ba7306ULL, 0x0002a20000205400ULL,
0x00000001acac3812ULL, 0x000fe400078efcffULL, 0x00000018ff357819ULL, 0x000fc8000001142fULL,
0x0000000166661812ULL, 0x008fe200078efcffULL, 0x000000c200c37306ULL, 0x000fe20000209400ULL,
0x000000ab00ab7245ULL, 0x002fce000020d400ULL, 0x000000c200c47306ULL, 0x000e620000205400ULL,
0x000000bab900720bULL, 0x004fce0003fdd000ULL, 0x00000026006c7306ULL, 0x000fec0000009400ULL,
0x00000001abab6812ULL, 0x000fe400078efcffULL, 0x00000026006a7306ULL, 0x000fe20000005400ULL,
0x000000c4c300720bULL, 0x002fe40003fbd000ULL, 0x000000acabab723eULL, 0x000fca00000010ffULL,
0x0000002600477306ULL, 0x0003f0000000d400ULL, 0x00000030008f7306ULL, 0x000fe20000009400ULL,
0x0000010030267824ULL, 0x002fca00078e00ffULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x00000030008e7306ULL, 0x000ff00000005400ULL, 0x00000030005e7306ULL, 0x0003f0000000d400ULL,
0x000000c500c67306ULL, 0x000fe20000209400ULL, 0x0000000702307812ULL, 0x002fc800078ec0ffULL,
0x0000000830d27812ULL, 0x000fe200078ef802ULL, 0x0001000031307824ULL, 0x000fe400078e00ffULL,
0x000000c500c77306ULL, 0x000e640000205400ULL, 0x00000020d2d37824ULL, 0x000fcc00078e00ffULL,
0x0000003600a47306ULL, 0x000ff00000009400ULL, 0x0000003600a67306ULL, 0x000fe20000005400ULL,
0x000000c7c600720bULL, 0x002fce0003f7d000ULL, 0x000000a300b27306ULL, 0x000ff00000209400ULL,
0x000000a300b87306ULL, 0x0002b00000205400ULL, 0x0000003100837306ULL, 0x000fe20000009400ULL,
0x000000a300a37245ULL, 0x002fce000020d400ULL, 0x0000003100807306ULL, 0x000fe20000005400ULL,
0x000000b8b200720bULL, 0x004fe20003f9d000ULL, 0x0001000032b27824ULL, 0x000fca00078e00ffULL,
0x00000018ffb27819ULL, 0x000fe200000114b2ULL, 0x00000031005d7306ULL, 0x0003ec000000d400ULL,
0x00000001a3a34812ULL, 0x000fe400078efcffULL, 0x0000003700a27306ULL, 0x000fe20000009400ULL,
0x0000010031317824ULL, 0x002fce00078e00ffULL, 0x0000003700a17306ULL, 0x000e700000005400ULL,
0x000000b700c87306ULL, 0x000ff00000209400ULL, 0x000000b700c97306ULL, 0x000ea20000205400ULL,
0x000000a1a200720bULL, 0x002fc40003fdd000ULL, 0x000000c500a17245ULL, 0x000fc8000020d400ULL,
0x00000001a1a13812ULL, 0x000fe200078efcffULL, 0x0000002700687306ULL, 0x000ff00000009400ULL,
0x0000002700697306ULL, 0x000ff00000005400ULL, 0x0000002700487306ULL, 0x0003f0000000d400ULL,
0x000000af00ca7306ULL, 0x000fe20000209400ULL, 0x00000018ff277819ULL, 0x002fc40000011431ULL,
0x000000bc00317245ULL, 0x000fc8000020d400ULL, 0x0000000131312812ULL, 0x000fe200078efcffULL,
0x000000af00cb7306ULL, 0x0002e20000205400ULL, 0x000000a6a400720bULL, 0x000fe40003f5d000ULL,
0x000000c200a47245ULL, 0x000fc8000020d400ULL, 0x00000001a4a45812ULL, 0x000fe200078efcffULL,
0x00000024009f7306ULL, 0x000fe20000009400ULL, 0x000000c9c800720bULL, 0x004fe40003fbd000ULL,
0x000000af00af7245ULL, 0x002fe4000020d400ULL, 0x00000066a466723eULL, 0x000fc600000010ffULL,
0x0000002400a07306ULL, 0x000e620000005400ULL, 0x000000cbca00720bULL, 0x008fce0003f7d000ULL,
0x00000025006d7306ULL, 0x000fec0000009400ULL, 0x00000001afaf3812ULL, 0x000fe400078efcffULL,
0x00000025006e7306ULL, 0x000fe20000005400ULL, 0x000000a09f00720bULL, 0x002fe20003f3d000ULL,
0x0000010032a07824ULL, 0x000fca00078e00ffULL, 0x00000018ffa07819ULL, 0x000fe200000114a0ULL,
0x0000002500467306ULL, 0x0003f0000000d400ULL, 0x0000009c00a57306ULL, 0x000fe20000209400ULL,
0x0000000444257824ULL, 0x002fe200078e0245ULL, 0x0000000245457810ULL, 0x000fc60007ffe0ffULL,
0x0000000225257824ULL, 0x000fc600078e00ffULL, 0x0000009c00a97306ULL, 0x0002a40000205400ULL,
0x0000000225d07810ULL, 0x000fe40007ffe0ffULL, 0x0000002502257211ULL, 0x040fe400078fe0ffULL,
0x000000d002d17211ULL, 0x000fe400078fe0ffULL, 0x0000003600637306ULL, 0x000ee2000000d400ULL,
0x00000018ffd07819ULL, 0x000fe20000011430ULL, 0x00000001d2257824ULL, 0x040fe200078e0225ULL,
0x0000009c009c7245ULL, 0x002fe2000020d400ULL, 0x00000001d2307824ULL, 0x000fc400078e02d1ULL,
0x00000020d2d27824ULL, 0x000fe200078e00ffULL, 0xffffffe0d3257812ULL, 0x000fe200078ee225ULL,
0x000000ae00b37306ULL, 0x000fe20000209400ULL, 0x000000a9a500720bULL, 0x004fe20003f9d000ULL,
0x0001000033a97824ULL, 0x000fe200078e00ffULL, 0xffffffe0d2307812ULL, 0x000fe200078ee230ULL,
0x0000001025257824ULL, 0x000fc600078e00ffULL, 0x00000018ffa97819ULL, 0x000fe200000114a9ULL,
0x000000ae00b57306ULL, 0x0003e20000205400ULL, 0x0000000163632812ULL, 0x008fca00078efcffULL,
0x000000019c9c4812ULL, 0x000fe400078efcffULL, 0x0000008c009d7306ULL, 0x000fe20000209400ULL,
0x000000ae00ae7245ULL, 0x002fce000020d400ULL, 0x0000008c00997306ULL, 0x0002b00000205400ULL,
0x000000aa00b17306ULL, 0x000fe20000209400ULL, 0x0000008c008c7245ULL, 0x002fce000020d400ULL,
0x000000aa00b07306ULL, 0x000e620000205400ULL, 0x000000999d00720bULL, 0x004fce0003f5d000ULL,
0x000000bb00cc7306ULL, 0x000fec0000209400ULL, 0x000000018c8c2812ULL, 0x000fe400078efcffULL,
0x000000bb00cd7306ULL, 0x000ea20000205400ULL, 0x000000b0b100720bULL, 0x002fce0003f7d000ULL,
0x00000032007e7306ULL, 0x000ff00000009400ULL, 0x00000032007f7306ULL, 0x000fe20000005400ULL,
0x000000cdcc00720bULL, 0x004fce0003f9d000ULL, 0x00000032005a7306ULL, 0x0003f0000000d400ULL,
0x000000d000d17306ULL, 0x000fe20000209400ULL, 0x000000b700327245ULL, 0x002fc8000020d400ULL,
0x0000000132325812ULL, 0x000fe400078efcffULL, 0x000000b5b300720bULL, 0x000fe20003fbd000ULL,
0x000000d000b47306ULL, 0x000e620000205400ULL, 0x000000a000b37245ULL, 0x000fce000020d400ULL,
0x00000037005f7306ULL, 0x000ea8000000d400ULL, 0x00000001aeae5812ULL, 0x000fe400078efcffULL,
0x0000008e8f00720bULL, 0x000fe40003fbd000ULL, 0x0000009e00a77306ULL, 0x000fe20000209400ULL,
0x000000aa008e7245ULL, 0x000fe4000020d400ULL, 0x000000b4d100720bULL, 0x002fc40003f5d000ULL,
0x000000018e8e3812ULL, 0x000fe400078efcffULL, 0x0000006731aa723eULL, 0x000fe200000010ffULL,
0x0000009e00a87306ULL, 0x0002e20000205400ULL, 0x000000015f5f6812ULL, 0x004fe400078efcffULL,
0x000000015e5e5812ULL, 0x000fe400078efcffULL, 0x0000005faeae723eULL, 0x000fe400000010ffULL,
0x000000a1a367723eULL, 0x000fe200000010ffULL, 0x0000002600ce7306ULL, 0x000fe20000209400ULL,
0x0000009e009e7245ULL, 0x002fce000020d400ULL, 0x0000002600cf7306ULL, 0x000e620000205400ULL,
0x000000a8a700720bULL, 0x008fce0003fdd000ULL, 0x000000b200a27306ULL, 0x000fec0000209400ULL,
0x000000019e9e6812ULL, 0x000fe400078efcffULL, 0x000000b2009f7306ULL, 0x0005e20000205400ULL,
0x000000cfce00720bULL, 0x002fce0003f7d000ULL, 0x00000098009a7306ULL, 0x000fe20000209400ULL,
0x000000b200b27245ULL, 0x004fce000020d400ULL, 0x00000098009b7306ULL, 0x0002b00000205400ULL,
0x00000033007a7306ULL, 0x000fe20000009400ULL, 0x0000009800987245ULL, 0x002fce000020d400ULL,
0x00000033007b7306ULL, 0x000fe20000005400ULL, 0x0000009b9a00720bULL, 0x004fce0003fdd000ULL,
0x0000003300597306ULL, 0x0003ec000000d400ULL, 0x0000000198986812ULL, 0x000fe400078efcffULL,
0x0000002700ad7306ULL, 0x000fe20000209400ULL, 0x000000bb00337245ULL, 0x002fc8000020d400ULL,
0x0000000133334812ULL, 0x000fe400078efcffULL, 0x000000808300720bULL, 0x000fe20003f9d000ULL,
0x0000002700a67306ULL, 0x000e620000205400ULL, 0x000000d000807245ULL, 0x000fe4000020d400ULL,
0x0000002600837245ULL, 0x000fe4000020d400ULL, 0x0000000180802812ULL, 0x000fe400078efcffULL,
0x0000009fa200720bULL, 0x000fe20003f5d000ULL, 0x000000b600267306ULL, 0x000fe20000209400ULL,
0x0000000183833812ULL, 0x000fc400078efcffULL, 0x0000007f7e00720bULL, 0x000fe40003f7d000ULL,
0x00000027007f7245ULL, 0x000fe4000020d400ULL, 0x000000015d5d4812ULL, 0x000fe200078efcffULL,
0x000000b6009a7306ULL, 0x0004e20000205400ULL, 0x000000a6ad00720bULL, 0x002fe40003fbd000ULL,
0x00000018ff7e7819ULL, 0x000fe400000114bdULL, 0x00000001b2b22812ULL, 0x000fc400078efcffULL,
0x0000007b7a00720bULL, 0x000fe20003f5d000ULL, 0x0000009500977306ULL, 0x000fe20000209400ULL,
0x000000015a5a3812ULL, 0x000fe200078efcffULL, 0x000100002c7b7824ULL, 0x000fe200078e00ffULL,
0x000000b600b67245ULL, 0x004fe4000020d400ULL, 0x0000005e335e723eULL, 0x000fe400000010ffULL,
0x000000017f7f5812ULL, 0x000fe200078efcffULL, 0x0000009500967306ULL, 0x0002a20000205400ULL,
0x0000009a2600720bULL, 0x008fc40003f7d000ULL, 0x00000018ff7b7819ULL, 0x000fe4000001147bULL,
0x0000000159592812ULL, 0x000fe400078efcffULL, 0x0000005d8080723eULL, 0x000fe200000010ffULL,
0x0000008100917306ULL, 0x000fe20000209400ULL, 0x0000009500957245ULL, 0x002fe4000020d400ULL,
0x000000839e5f723eULL, 0x000fe400000010ffULL, 0x0000005ab2b2723eULL, 0x000fc400000010ffULL,
0x00000001b6b63812ULL, 0x000fe200078efcffULL, 0x0000008100947306ULL, 0x000e620000205400ULL,
0x000000969700720bULL, 0x004fce0003fbd000ULL, 0x000000a9008f7306ULL, 0x000fec0000209400ULL,
0x0000000195955812ULL, 0x000fe400078efcffULL, 0x000000a9009d7306ULL, 0x0004e20000205400ULL,
0x000000949100720bULL, 0x002fe40003f5d000ULL, 0x0000006a6c00720bULL, 0x000fc40003fbd000ULL,
0x00000081006a7245ULL, 0x000fc6000020d400ULL, 0x00000024004d7306ULL, 0x000e62000000d400ULL,
0x000000a900a97245ULL, 0x004fca000020d400ULL, 0x000000016a6a2812ULL, 0x000fe400078efcffULL,
0x0000008700907306ULL, 0x000fe20000209400ULL, 0x0000009d8f00720bULL, 0x008fe20003fdd000ULL,
0x000001002f8f7824ULL, 0x000fe200078e00ffULL, 0x0000000147475812ULL, 0x000fc800078efcffULL,
0x00000018ff8f7819ULL, 0x000fe2000001148fULL, 0x0000008700247306ULL, 0x0004e20000205400ULL,
0x000000014d4d1812ULL, 0x002fc800078efcffULL, 0x0000004d6a6a723eULL, 0x000fe400000010ffULL,
0x00000001a9a96812ULL, 0x000fe200078efcffULL, 0x0000007600707306ULL, 0x000fe20000209400ULL,
0x0000008700877245ULL, 0x004fe4000020d400ULL, 0x0000008f004d7245ULL, 0x000fca000020d400ULL,
0x0000007600717306ULL, 0x0002a20000205400ULL, 0x000000249000720bULL, 0x008fe40003f7d000ULL,
0x000000002524783bULL, 0x000eea0000000200ULL, 0x0000008d00927306ULL, 0x000fe20000209400ULL,
0x0000007600767245ULL, 0x002fca000020d400ULL, 0x0000000187873812ULL, 0x000fe400078efcffULL,
0x0000008d00937306ULL, 0x0002620000205400ULL, 0x000000717000720bULL, 0x004fce0003f5d000ULL,
0x000000a000a57306ULL, 0x000fe20000209400ULL, 0x0000008d008d7245ULL, 0x002fca000020d400ULL,
0x0000000176762812ULL, 0x000fe400078efcffULL, 0x000000a000997306ULL, 0x000e620000205400ULL,
0x000000939200720bULL, 0x000fce0003fdd000ULL, 0x0000008600857306ULL, 0x000fe20000209400ULL,
0x000000aa2418723cULL, 0x048fea0000041818ULL, 0x000000018d8d6812ULL, 0x000fe400078efcffULL,
0x0000008600897306ULL, 0x0004e20000205400ULL, 0x00000099a500720bULL, 0x002fe40003f9d000ULL,
0x000000696800720bULL, 0x000fe20003fdd000ULL, 0x000100002d687824ULL, 0x000fe200078e00ffULL,
0x000000b68d31723eULL, 0x000fe200000010ffULL, 0x000000662420723cULL, 0x000fe40000041820ULL,
0x0000006b00727306ULL, 0x000fe20000209400ULL, 0x0000008600867245ULL, 0x004fca000020d400ULL,
0x00000001b3b34812ULL, 0x000fe200078efcffULL, 0x0000005e2410723cULL, 0x000fe20000041810ULL,
0x0000006b006f7306ULL, 0x000e620000205400ULL, 0x000000898500720bULL, 0x008fe20003f3d000ULL,
0x000001002d857824ULL, 0x000fe200078e00ffULL, 0x0000006e6d00720bULL, 0x000fe20003f9d000ULL,
0x000100002e897824ULL, 0x000fe200078e00ffULL, 0x00000018ff6d7819ULL, 0x000fe400000114beULL,
0x00000018ff857819ULL, 0x000fe20000011485ULL, 0x00000088008a7306ULL, 0x000fe20000209400ULL,
0x00000018ff897819ULL, 0x000fc40000011489ULL, 0x0000000148486812ULL, 0x000fe400078efcffULL,
0x000000b395b3723eULL, 0x000fe400000010ffULL, 0x0000000186861812ULL, 0x000fe200078efcffULL,
0x00000088008b7306ULL, 0x0004e20000205400ULL, 0x0000006f7200720bULL, 0x002fe40003f5d000ULL,
0x00000018ff727819ULL, 0x000fe20000011468ULL, 0x000000b22408723cULL, 0x000fe20000041808ULL,
0x0000006b00687245ULL, 0x000fc4000020d400ULL, 0x0000000146464812ULL, 0x000fe200078efcffULL,
0x0000006200747306ULL, 0x000fe20000209400ULL, 0x0000008800887245ULL, 0x004fe4000020d400ULL,
0x000000468686723eULL, 0x000fc600000010ffULL, 0x0000000168682812ULL, 0x000fe400078efcffULL,
0x0000006200737306ULL, 0x0002a20000205400ULL, 0x0000008b8a00720bULL, 0x008fe20003f7d000ULL,
0x000001002e8a7824ULL, 0x000fe400078e00ffULL, 0x000100002f8b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff8a7819ULL, 0x000fe2000001148aULL, 0x0000002c00757306ULL, 0x000fe20000009400ULL,
0x0000006200627245ULL, 0x002fe4000020d400ULL, 0x00000018ff8b7819ULL, 0x000fc6000001148bULL,
0x0000000188883812ULL, 0x000fe400078efcffULL, 0x0000002c00787306ULL, 0x000e620000005400ULL,
0x000000737400720bULL, 0x004fe40003f3d000ULL, 0x0000008500737245ULL, 0x000fca000020d400ULL,
0x0000007900827306ULL, 0x000fec0000209400ULL, 0x0000000162621812ULL, 0x000fe400078efcffULL,
0x0000007900847306ULL, 0x0004e20000205400ULL, 0x000000787500720bULL, 0x002fce0003f9d000ULL,
0x00000077007c7306ULL, 0x000fe20000209400ULL, 0x0000007900797245ULL, 0x004fce000020d400ULL,
0x00000077007d7306ULL, 0x0002a20000205400ULL, 0x000000848200720bULL, 0x008fce0003f7d000ULL,
0x0000007e00967306ULL, 0x000fe20000209400ULL, 0x0000007700777245ULL, 0x002fca000020d400ULL,
0x0000000179793812ULL, 0x000fe400078efcffULL, 0x0000007e007a7306ULL, 0x0002e20000205400ULL,
0x0000007d7c00720bULL, 0x004fce0003f5d000ULL, 0x0000007b00697306ULL, 0x000fe20000209400ULL,
0x0000007e007e7245ULL, 0x002fca000020d400ULL, 0x0000000177772812ULL, 0x000fe400078efcffULL,
0x0000007b00707306ULL, 0x0002a20000205400ULL, 0x0000007a9600720bULL, 0x008fce0003f3d000ULL,
0x0000002c00497306ULL, 0x0006a2000000d400ULL, 0x0000007b007b7245ULL, 0x002fca000020d400ULL,
0x000000017e7e1812ULL, 0x000fe400078efcffULL, 0x0000002d00657306ULL, 0x000fe20000009400ULL,
0x000001002c2c7824ULL, 0x008fe200078e00ffULL, 0x000000706900720bULL, 0x004fe40003fbd000ULL,
0x000000487e7e723eULL, 0x000fe400000010ffULL, 0x00000018ff717819ULL, 0x000fe4000001142cULL,
0x0000002d00647306ULL, 0x000e620000005400ULL, 0x00000063322c723eULL, 0x000fc400000010ffULL,
0x0000000149494812ULL, 0x000fc800078efcffULL, 0x000000017b7b5812ULL, 0x000fe200078efcffULL,
0x0000002d004a7306ULL, 0x0004f0000000d400ULL, 0x0000002e00617306ULL, 0x000fe20000009400ULL,
0x000000af9c2d723eULL, 0x004fc400000010ffULL, 0x000000646500720bULL, 0x002fe40003f7d000ULL,
0x0000008e8caf723eULL, 0x000fc600000010ffULL, 0x0000002e00607306ULL, 0x000e620000005400ULL,
0x0000002c241c723cULL, 0x040b6e000004181cULL, 0x0000006d006c7306ULL, 0x000fe20000209400ULL,
0x00000010302c7824ULL, 0x020fe200078e00ffULL, 0x00000059a930723eULL, 0x000fe200000010ffULL,
0x000000ae2414723cULL, 0x000f620000041814ULL, 0x000000014a4a3812ULL, 0x008fc800078efcffULL,
0x0000006d006e7306ULL, 0x000ea20000205400ULL, 0x000000606100720bULL, 0x002fe40003f5d000ULL,
0x000000302404723cULL, 0x000fea0000041804ULL, 0x0000004e00557306ULL, 0x000ff00000209400ULL,
0x0000004e00587306ULL, 0x0002e20000205400ULL, 0x0000006e6c00720bULL, 0x004fce0003f9d000ULL,
0x00000053005b7306ULL, 0x000fe20000209400ULL, 0x0000004e004e7245ULL, 0x002fce000020d400ULL,
0x00000053005c7306ULL, 0x000e620000205400ULL, 0x000000585500720bULL, 0x008fce0003f3d000ULL,
0x0000007100817306ULL, 0x000fec0000209400ULL, 0x000000014e4e1812ULL, 0x000fe400078efcffULL,
0x00000071006f7306ULL, 0x0004e20000205400ULL, 0x0000005c5b00720bULL, 0x002fce0003fdd000ULL,
0x0000002e004b7306ULL, 0x000e62000000d400ULL, 0x0000007100717245ULL, 0x004fce000020d400ULL,
0x0000002f00577306ULL, 0x000fe20000009400ULL, 0x0000006f8100720bULL, 0x008fe40003fbd000ULL,
0x0000007f9881723eULL, 0x000fe400000010ffULL, 0x0000006d007f7245ULL, 0x000fc6000020d400ULL,
0x0000002f00567306ULL, 0x000ea20000005400ULL, 0x000000017f7f4812ULL, 0x000fe200078efcffULL,
0x00000080240c723cULL, 0x000b62000004180cULL, 0x000000014b4b2812ULL, 0x002fe400078efcffULL,
0x0000007f4e7f723eULL, 0x000fe400000010ffULL, 0x0000000171715812ULL, 0x000fe200078efcffULL,
0x0000002f004c7306ULL, 0x0002e2000000d400ULL, 0x0000005300277245ULL, 0x020fe4000020d400ULL,
0x000000477924723eULL, 0x000fc400000010ffULL, 0x0000000127276812ULL, 0x000fe400078efcffULL,
0x000000776225723eULL, 0x000fe200000010ffULL, 0x00000072006b7306ULL, 0x000fe20000209400ULL,
0x000000002c2c783bULL, 0x002e620000000200ULL, 0x000000565700720bULL, 0x004fe40003fbd000ULL,
0x000000497b26723eULL, 0x000fe400000010ffULL, 0x000000712727723eULL, 0x000fe400000010ffULL,
0x0000007200327306ULL, 0x0004ae0000205400ULL, 0x000000014c4c5812ULL, 0x008fe200078efcffULL,
0x0000008900337306ULL, 0x000fe20000209400ULL, 0x0000007200727245ULL, 0x004fce000020d400ULL,
0x00000089005d7306ULL, 0x0004e20000205400ULL, 0x000000326b00720bULL, 0x000fe40003f9d000ULL,
0x00000087766b723eULL, 0x000fe400000010ffULL, 0x000000886887723eULL, 0x000fc600000010ffULL,
0x0000005200347306ULL, 0x000fe20000209400ULL, 0x0000008900897245ULL, 0x004fca000020d400ULL,
0x0000000172724812ULL, 0x000fe400078efcffULL, 0x0000005200547306ULL, 0x0004a20000205400ULL,
0x0000005d3300720bULL, 0x008fe20003f7d000ULL, 0x000000242c1c723cULL, 0x002b62000004181cULL,
0x0000004a7272723eULL, 0x000fca00000010ffULL, 0x0000008500637306ULL, 0x000fe20000209400ULL,
0x0000005200527245ULL, 0x004fe2000020d400ULL, 0x0000006a2c18723cULL, 0x040b640000041818ULL,
0x0000008a00257245ULL, 0x020fe4000020d400ULL, 0x0000000189893812ULL, 0x000fe400078efcffULL,
0x0000008500607306ULL, 0x000e620000205400ULL, 0x000000543400720bULL, 0x000fe20003f3d000ULL,
0x0000007e2c14723cULL, 0x000b620000041814ULL, 0x0000004b8924723eULL, 0x000fca00000010ffULL,
0x0000008a005a7306ULL, 0x000fe40000209400ULL, 0x000000862c20723cULL, 0x040b680000041820ULL,
0x0000000152521812ULL, 0x000fe400078efcffULL, 0x0000008a00557306ULL, 0x000ea20000205400ULL,
0x000000606300720bULL, 0x002fe20003fdd000ULL, 0x000000262c10723cULL, 0x000b6c0000041810ULL,
0x0000005100507306ULL, 0x000fec0000209400ULL, 0x0000000173736812ULL, 0x000fc400078efcffULL,
0x0000005100367306ULL, 0x0002e20000205400ULL, 0x000000555a00720bULL, 0x004fe40003f3d000ULL,
0x000000735273723eULL, 0x000fca00000010ffULL, 0x0000003500377306ULL, 0x000fe20000209400ULL,
0x0000005100517245ULL, 0x002fe2000020d400ULL, 0x000000722c0c723cULL, 0x000b68000004180cULL,
0x0000000125251812ULL, 0x000fe400078efcffULL, 0x00000035004f7306ULL, 0x0002a20000205400ULL,
0x000000365000720bULL, 0x008fe40003f9d000ULL, 0x000000044500780cULL, 0x000fca0003f25270ULL,
0x0000008b00327306ULL, 0x000fe20000209400ULL, 0x0000003500357245ULL, 0x002fca000020d400ULL,
0x0000000151514812ULL, 0x000fe400078efcffULL, 0x0000008b00307306ULL, 0x0002e20000205400ULL,
0x0000004f3700720bULL, 0x004fe40003fdd000ULL, 0x000000255125723eULL, 0x000fca00000010ffULL,
0x0000008f00317306ULL, 0x000fe20000209400ULL, 0x0000008b008b7245ULL, 0x002fe2000020d400ULL,
0x000000242c08723cULL, 0x000b680000041808ULL, 0x0000000135356812ULL, 0x000fe400078efcffULL,
0x0000008f00337306ULL, 0x000e620000205400ULL, 0x000000303200720bULL, 0x008fda0003f7d000ULL,
0x000000018b8b3812ULL, 0x000fe400078efcffULL, 0x000000333100720bULL, 0x002fe40003f5d000ULL,
0x0000004c8b4c723eULL, 0x000fd600000010ffULL, 0x000000014d4d2812ULL, 0x000fc800078efcffULL,
0x0000004d354d723eULL, 0x000fce00000010ffULL, 0x0000004c2c04723cULL, 0x000b620000041804ULL,
0x0000001000009944ULL, 0x000fe20003c00000ULL, 0xffffe0c000007947ULL, 0x000fcc000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff427224ULL, 0x000fe200078e003bULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffd21000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x00000040162c7220ULL, 0x0a0fe20000410000ULL,
0x000000401a247220ULL, 0x080fe20000410000ULL, 0x00000040172d7220ULL, 0x080fe20000410000ULL,
0x0000004010167220ULL, 0x080fe20000410000ULL, 0x0000004018187220ULL, 0x080fe20000410000ULL,
0x0000004019197220ULL, 0x080fe20000410000ULL, 0x000000401b257220ULL, 0x080fe20000410000ULL,
0x0000004011177220ULL, 0x080fe20000410000ULL, 0x000000400c1a7220ULL, 0x080fe20000410000ULL,
0x0000004020207220ULL, 0x080fe20000410000ULL, 0x0000004021217220ULL, 0x080fe20000410000ULL,
0x000000401c1c7220ULL, 0x080fe20000410000ULL, 0x000000401d1d7220ULL, 0x080fe20000410000ULL,
0x0000004014147220ULL, 0x080fe20000410000ULL, 0x0000004015157220ULL, 0x080fe20000410000ULL,
0x000000400d1b7220ULL, 0x080fe20000410000ULL, 0x0000004008087220ULL, 0x080fe20000410000ULL,
0x0000004009097220ULL, 0x080fe20000410000ULL, 0x0000004004047220ULL, 0x080fe20000410000ULL,
0x00000040122e7220ULL, 0x080fe20000410000ULL, 0x00000040132f7220ULL, 0x080fe20000410000ULL,
0x000000400a327220ULL, 0x080fe20000410000ULL, 0x000000400b337220ULL, 0x080fe20000410000ULL,
0x000000ffff127224ULL, 0x000fe200078e0016ULL, 0x000000400e307220ULL, 0x080fe20000410000ULL,
0x000000400f317220ULL, 0x080fe20000410000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e0018ULL,
0x0000004022227220ULL, 0x080fe20000410000ULL, 0x000000ffff0b7224ULL, 0x000fe200078e0019ULL,
0x0000004023237220ULL, 0x080fe20000410000ULL, 0x000000ffff137224ULL, 0x000fe200078e0017ULL,
0x000000401e267220ULL, 0x080fe20000410000ULL, 0x000000ffff167224ULL, 0x000fe200078e001aULL,
0x000000401f277220ULL, 0x080fe20000410000ULL, 0x0000004005057220ULL, 0x080fe20000410000ULL,
0x0000004006067220ULL, 0x080fe20000410000ULL, 0x0000004007077220ULL, 0x000fe20000410000ULL,
0x000000ffff0c7224ULL, 0x000fc400078e0020ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0021ULL,
0x000000ffff0e7224ULL, 0x000fe400078e001cULL, 0x000000ffff0f7224ULL, 0x000fe400078e001dULL,
0x000000ffff107224ULL, 0x000fe400078e0014ULL, 0x000000ffff117224ULL, 0x000fe400078e0015ULL,
0x000000ffff177224ULL, 0x000fc400078e001bULL, 0x000000ffff187224ULL, 0x000fe400078e0008ULL,
0x000000ffff197224ULL, 0x000fe400078e0009ULL, 0x000000ffff1a7224ULL, 0x000fe200078e0004ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000003f087f8cULL, 0x0002a2000c80043fULL,
0x000000ffff1c7224ULL, 0x000fe400078e0024ULL, 0x000000ffff1d7224ULL, 0x000fe400078e0025ULL,
0x000000ffff1e7224ULL, 0x000fc400078e0022ULL, 0x000000ffff1f7224ULL, 0x000fe400078e0023ULL,
0x000000ffff207224ULL, 0x000fe400078e0026ULL, 0x000000ffff217224ULL, 0x000fe400078e0027ULL,
0x000000ffff227224ULL, 0x000fe400078e002cULL, 0x000000ffff237224ULL, 0x000fe400078e002dULL,
0x000000ffff247224ULL, 0x000fc400078e002eULL, 0x000000ffff257224ULL, 0x000fe400078e002fULL,
0x000000ffff1b7224ULL, 0x000fe400078e0005ULL, 0x000000ffff267224ULL, 0x000fe400078e0030ULL,
0x000000ffff277224ULL, 0x000fe400078e0031ULL, 0x000000ffff2c7224ULL, 0x000fe400078e0032ULL,
0x000000ffff2d7224ULL, 0x000fc400078e0033ULL, 0x000000ffff2e7224ULL, 0x000fe400078e0006ULL,
0x000000ffff2f7224ULL, 0x000fc400078e0007ULL, 0x0000000000047805ULL, 0x006fca0000015200ULL,
0x000004003f067984ULL, 0x000e640000000800ULL, 0x8000000006ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff157224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604147210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09001400780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401400780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000001406067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000115157810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004003f067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000402157824ULL, 0x000fe200078e00ffULL, 0x0000003e3c00720cULL, 0x000fc80003f05270ULL,
0xfffffff015147812ULL, 0x000fca00078ec0ffULL, 0x0000008000147824ULL, 0x000fca00078e0214ULL,
0x0104000014047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000202087824ULL, 0x000fe400078e00ffULL, 0x0000000128037824ULL, 0x000fc600078e0a03ULL,
0x0000000608087812ULL, 0x000fc800078ec0ffULL, 0x0000000108097812ULL, 0x040fe400078efcffULL,
0x0000000808307812ULL, 0x040fe400078efcffULL, 0x000000030900720cULL, 0x080fe40003f26070ULL,
0x0000001008097812ULL, 0x000fe400078efcffULL, 0x000000033000720cULL, 0x080fe40003f06070ULL,
0x000000030900720cULL, 0x000fc40003fc6070ULL, 0x0000001108307812ULL, 0x040fe400078efcffULL,
0x0000001808097812ULL, 0x040fe400078efcffULL, 0x000000030800720cULL, 0x080fe40003f46070ULL,
0x000000033000720cULL, 0x080fe40003fa6070ULL, 0x000000030900720cULL, 0x000fe40003f66070ULL,
0x0000000908317812ULL, 0x000fc400078efcffULL, 0x0000001908307812ULL, 0x040fe400078efcffULL,
0x0000002008097812ULL, 0x000fe400078efcffULL, 0xff8000001c1c7808ULL, 0x000fe40005000000ULL,
0xff8000000a0a7808ULL, 0x000fe40005000000ULL, 0xff8000001d1d7808ULL, 0x000fe40004800000ULL,
0xff8000000b0b7808ULL, 0x000fc40004800000ULL, 0x000000033100720cULL, 0x080fe40003f86070ULL,
0x000000033000720cULL, 0x080fe40003f46070ULL, 0x000000030900720cULL, 0x000fe40003f26070ULL,
0x0000002108307812ULL, 0x040fe400078efcffULL, 0x0000002808097812ULL, 0x000fe400078efcffULL,
0xff8000001e1e7808ULL, 0x000fc40004000000ULL, 0xff8000000c0c7808ULL, 0x000fe40004000000ULL,
0xff8000001f1f7808ULL, 0x000fe40006000000ULL, 0xff8000000d0d7808ULL, 0x000fe40006000000ULL,
0x000000033000720cULL, 0x080fe40003f06070ULL, 0x000000030900720cULL, 0x000fe40003f86070ULL,
0x0000002908307812ULL, 0x000fc400078efcffULL, 0x0000003008097812ULL, 0x000fe400078efcffULL,
0xff80000020207808ULL, 0x000fe40007000000ULL, 0xff8000000e0e7808ULL, 0x000fe40007000000ULL,
0xff80000021217808ULL, 0x000fe40006800000ULL, 0xff8000000f0f7808ULL, 0x000fe40006800000ULL,
0x000000033000720cULL, 0x000fc40003fc6070ULL, 0x000000030900720cULL, 0x000fe40003fa6070ULL,
0x0000003108307812ULL, 0x040fe400078efcffULL, 0x0000003808097812ULL, 0x040fe400078efcffULL,
0x0000003908087812ULL, 0x000fe400078efcffULL, 0xff80000022227808ULL, 0x000fe40005800000ULL,
0xff80000010107808ULL, 0x000fc40005800000ULL, 0xff80000023237808ULL, 0x000fe40005000000ULL,
0xff80000011117808ULL, 0x000fe40005000000ULL, 0xff80000024247808ULL, 0x000fe40004800000ULL,
0xff80000012127808ULL, 0x000fe40004800000ULL, 0x000000033000720cULL, 0x080fe40003f66070ULL,
0x000000030900720cULL, 0x000fc40003f46070ULL, 0x000000030800720cULL, 0x000fe40003f26070ULL,
0xff80000025257808ULL, 0x000fe40004000000ULL, 0xff80000013137808ULL, 0x000fe40004000000ULL,
0xff80000026267808ULL, 0x000fe40006000000ULL, 0xff80000016167808ULL, 0x000fe40006000000ULL,
0xff80000027277808ULL, 0x000fc40007000000ULL, 0xff80000017177808ULL, 0x000fe40007000000ULL,
0xff8000002c2c7808ULL, 0x000fe40006800000ULL, 0xff80000018187808ULL, 0x000fe40006800000ULL,
0xff8000002d2d7808ULL, 0x000fe40005800000ULL, 0xff80000019197808ULL, 0x000fe40005800000ULL,
0xff8000002e2e7808ULL, 0x000fc40005000000ULL, 0xff8000001a1a7808ULL, 0x000fe40005000000ULL,
0xff8000002f2f7808ULL, 0x000fe40004800000ULL, 0xff8000001b1b7808ULL, 0x000fc40004800000ULL,
0x0000000a0400720bULL, 0x004fe20003f1e000ULL, 0x0000001fff337424ULL, 0x000fe200078e00ffULL,
0x0000001c0500720bULL, 0x000fe20003f3e000ULL, 0xffffffffff347424ULL, 0x000fe200078e00ffULL,
0x000000040a047208ULL, 0x000fe40004000000ULL, 0x000000051c057208ULL, 0x000fc40004800000ULL,
0x0000000b0400720bULL, 0x000fe40003f1e000ULL, 0x0000001d0500720bULL, 0x000fe40003f3e000ULL,
0x000000040b047208ULL, 0x000fe40004000000ULL, 0x000000051d057208ULL, 0x000fe40004800000ULL,
0x0000000c0400720bULL, 0x000fe40003f1e000ULL, 0x0000001e0500720bULL, 0x000fc40003f3e000ULL,
0x000000040c047208ULL, 0x000fe40004000000ULL, 0x000000051e057208ULL, 0x000fe40004800000ULL,
0x0000000d0400720bULL, 0x000fe40003f1e000ULL, 0x0000001f0500720bULL, 0x000fe40003f3e000ULL,
0x000000040d047208ULL, 0x000fe40004000000ULL, 0x000000051f057208ULL, 0x000fc40004800000ULL,
0x0000000e0400720bULL, 0x000fe40003f1e000ULL, 0x000000200500720bULL, 0x000fe40003f3e000ULL,
0x000000040e047208ULL, 0x000fe40004000000ULL, 0x0000000520057208ULL, 0x000fe40004800000ULL,
0x0000000f0400720bULL, 0x000fe40003f1e000ULL, 0x000000210500720bULL, 0x000fc40003f3e000ULL,
0x000000040f047208ULL, 0x000fe40004000000ULL, 0x0000000521057208ULL, 0x000fe40004800000ULL,
0x000000100400720bULL, 0x000fe40003f1e000ULL, 0x000000220500720bULL, 0x000fe40003f3e000ULL,
0x0000000410047208ULL, 0x000fe40004000000ULL, 0x0000000522057208ULL, 0x000fc40004800000ULL,
0x000000110400720bULL, 0x000fe40003f1e000ULL, 0x000000230500720bULL, 0x000fe40003f3e000ULL,
0x0000000411047208ULL, 0x000fe40004000000ULL, 0x0000000523057208ULL, 0x000fe40004800000ULL,
0x000000120400720bULL, 0x000fe40003f1e000ULL, 0x000000240500720bULL, 0x000fc40003f3e000ULL,
0x0000000412047208ULL, 0x000fe40004000000ULL, 0x0000000524057208ULL, 0x000fe40004800000ULL,
0x000000130400720bULL, 0x000fe40003f1e000ULL, 0x000000250500720bULL, 0x000fe40003f3e000ULL,
0x0000000413047208ULL, 0x000fe40004000000ULL, 0x0000000525057208ULL, 0x000fc40004800000ULL,
0x000000160400720bULL, 0x000fe40003f1e000ULL, 0x000000260500720bULL, 0x000fe40003f3e000ULL,
0x0000000416047208ULL, 0x000fe40004000000ULL, 0x0000000526057208ULL, 0x000fe40004800000ULL,
0x000000170400720bULL, 0x000fe40003f1e000ULL, 0x000000270500720bULL, 0x000fc40003f3e000ULL,
0x0000000417047208ULL, 0x000fe40004000000ULL, 0x0000000527057208ULL, 0x000fe40004800000ULL,
0x000000180400720bULL, 0x000fe40003f1e000ULL, 0x0000002c0500720bULL, 0x000fe40003f3e000ULL,
0x0000000418047208ULL, 0x000fe40004000000ULL, 0x000000052c057208ULL, 0x000fc40004800000ULL,
0x000000190400720bULL, 0x000fe40003f1e000ULL, 0x0000002d0500720bULL, 0x000fe40003f3e000ULL,
0x0000000419047208ULL, 0x000fe40004000000ULL, 0x000000052d057208ULL, 0x000fe40004800000ULL,
0x0000001a0400720bULL, 0x000fe40003f1e000ULL, 0x0000002e0500720bULL, 0x000fc40003f3e000ULL,
0x000000041a047208ULL, 0x000fe40004000000ULL, 0x000000052e057208ULL, 0x000fe40004800000ULL,
0x0000001b0400720bULL, 0x000fe40003f1e000ULL, 0x0000002f0500720bULL, 0x000fe40003f3e000ULL,
0x000000041b047208ULL, 0x000fe40004000000ULL, 0x000000052f317208ULL, 0x000fe20004800000ULL,
0x000019027f007947ULL, 0x000fec000b800000ULL, 0x0c401f0004037f89ULL, 0x0004e400000e0000ULL,
0x000000030400720bULL, 0x00cfc80003f1e000ULL, 0x0000000403327208ULL, 0x000fe20004000000ULL,
0x000019127f007947ULL, 0x000fea000b800000ULL, 0x0c401f0031037f89ULL, 0x000ea800000e0000ULL,
0x0c401f0006047f89ULL, 0x000ee800000e0000ULL, 0x0c401f0007057f89ULL, 0x000e6200000e0000ULL,
0x000000033100720bULL, 0x004fc40003f1e000ULL, 0x000000040600720bULL, 0x008fe40003f3e000ULL,
0x0000003103037208ULL, 0x000fe40004000000ULL, 0x0000000604067208ULL, 0x000fe40004800000ULL,
0x000000050700720bULL, 0x002fe20003f1e000ULL, 0x0c201f0032047f89ULL, 0x000e6600000e0000ULL,
0x0000000705077208ULL, 0x000fe20004000000ULL, 0x0c201f0003087f89ULL, 0x000ea800000e0000ULL,
0x0c201f0006097f89ULL, 0x000ee800000e0000ULL, 0x0c201f0007307f89ULL, 0x0002e400000e0000ULL,
0x000000043200720bULL, 0x002fc40003f1e000ULL, 0x000000080300720bULL, 0x004fe40003f3e000ULL,
0x0000003204047208ULL, 0x000fe40004000000ULL, 0x000000090600720bULL, 0x008fe40003f5e000ULL,
0x0000000308057208ULL, 0x000fe40004800000ULL, 0x0000000609067208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b04037820ULL, 0x000fe20000410000ULL, 0x3f80000000057882ULL, 0x000fe20000000000ULL,
0x00000002ff317819ULL, 0x000fe20000011602ULL, 0x00000005ff327e24ULL, 0x000fe2000f8e00ffULL,
0x3fb8aa3b0a0a7823ULL, 0x100fe20000010803ULL, 0x3fb8aa3b0c0c7823ULL, 0x100fe20000010803ULL,
0x3fb8aa3b0e0e7823ULL, 0x100fe20000010803ULL, 0x3fb8aa3b10107823ULL, 0x100fe20000010803ULL,
0x3fb8aa3b12127823ULL, 0x100fe20000010803ULL, 0x0000000a00087308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b16167823ULL, 0x100fe20000010803ULL, 0x3fb8aa3b0b0b7823ULL, 0x100fe20000010803ULL,
0x3fb8aa3b0d0d7823ULL, 0x100fe20000010803ULL, 0x3f8000003232783eULL, 0x000fe200000010ffULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe20000010803ULL, 0x3fb8aa3b11117823ULL, 0x100fe20000010803ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000c000a7308ULL, 0x000fe20000000800ULL,
0x000000ffff337224ULL, 0x000fe200078e0032ULL, 0x3fb8aa3b13137823ULL, 0x100fe20000010803ULL,
0x3fb8aa3b17177823ULL, 0x100fe20000010803ULL, 0x3fb8aa3b18187823ULL, 0x100fe20000010803ULL,
0x3fb8aa3b19197823ULL, 0x100fe20000010803ULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe20000010803ULL,
0x3fb8aa3b1b037823ULL, 0x000fe20000010803ULL, 0x0000000e000c7308ULL, 0x000fe20000000800ULL,
0x0000000c15157812ULL, 0x000fc400078ec0ffULL, 0x0000000302ff7812ULL, 0x000fe4000780c0ffULL,
0x000000300700720bULL, 0x000fc60003f3e000ULL, 0x00000010000e7308ULL, 0x000fe20000000800ULL,
0x0000000730077208ULL, 0x000fce0004800000ULL, 0x0000001200107308ULL, 0x000ff00000000800ULL,
0x0000001600127308ULL, 0x0003f00000000800ULL, 0x0000000b000b7308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b05167820ULL, 0x002fc80000410000ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe20000010816ULL, 0x0000000d000d7308ULL, 0x000e620000000800ULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b27277823ULL, 0x100fe20000010816ULL,
0x000000080b08723eULL, 0x004fe200000010ffULL, 0x0000001c00097308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b24247823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b25257823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b2f167823ULL, 0x000fe20000010816ULL,
0x00000008312f7824ULL, 0x000fe200078e00ffULL, 0x0000001d001d7308ULL, 0x000ea20000000800ULL,
0x0000000a0d0a723eULL, 0x002fce00000010ffULL, 0x0000001e001e7308ULL, 0x000ff00000000800ULL,
0x0000001f001f7308ULL, 0x000e620000000800ULL, 0x000000091d09723eULL, 0x004fce00000010ffULL,
0x0000000f000f7308ULL, 0x000ea20000000800ULL, 0x0000001e1f0b723eULL, 0x002fce00000010ffULL,
0x0000002000207308ULL, 0x000fe20000000800ULL, 0x00000032081c723cULL, 0x000f6200000418ffULL,
0x0000000c0f0c723eULL, 0x004fcc00000010ffULL, 0x0000002100217308ULL, 0x000e700000000800ULL,
0x0000001100117308ULL, 0x000eb00000000800ULL, 0x0000002200227308ULL, 0x000fe20000000800ULL,
0x00000020210d723eULL, 0x002fe200000010ffULL, 0x000000ffff207224ULL, 0x000fc400078e0032ULL,
0x000000ffff217224ULL, 0x000fc800078e0032ULL, 0x0000002300237308ULL, 0x000e620000000800ULL,
0x0000000e110e723eULL, 0x004fe400000010ffULL, 0x0000000131117810ULL, 0x000fca0007ffe0ffULL,
0x0000001300137308ULL, 0x000ea20000000800ULL, 0x00000022230f723eULL, 0x002fce00000010ffULL,
0x0000002600267308ULL, 0x000fe20000000800ULL, 0x0000000331227810ULL, 0x040fe40007ffe0ffULL,
0x0000000431237810ULL, 0x000fe20007ffe0ffULL, 0x000000200c1c723cULL, 0x020b62000004181cULL,
0x000000101310723eULL, 0x004fc600000010ffULL, 0x0000002700277308ULL, 0x000e660000000800ULL,
0x0000000831207824ULL, 0x060fe400078e00ffULL, 0x0000000831217824ULL, 0x000fc600078e00ffULL,
0x0000001700177308ULL, 0x000ea20000000800ULL, 0xfffffff820207812ULL, 0x000fce00078ee211ULL,
0x0000002400247308ULL, 0x000fe20000000800ULL, 0x000000262713723eULL, 0x002fe200000010ffULL,
0x000000ffff267224ULL, 0x100fe400078e0032ULL, 0x000000ffff277224ULL, 0x000fc800078e0032ULL,
0x0000002500257308ULL, 0x000e620000000800ULL, 0x000000121712723eULL, 0x004fe400000010ffULL,
0x0000000231177810ULL, 0x000fc80007ffe0ffULL, 0xfffffff821217812ULL, 0x000fe200078ee217ULL,
0x0000001800187308ULL, 0x000fe20000000800ULL, 0x0000000831177824ULL, 0x000fca00078e00ffULL,
0xfffffff817177812ULL, 0x000fe400078ee231ULL, 0x000000242511723eULL, 0x002fe200000010ffULL,
0x0000001900197308ULL, 0x000e620000000800ULL, 0x0000000831247824ULL, 0x040fe400078e00ffULL,
0x0000000831257824ULL, 0x000fc600078e00ffULL, 0x00000026101c723cULL, 0x000b62000004181cULL,
0xfffffff824227812ULL, 0x000fe200078ee222ULL, 0x0000002c002c7308ULL, 0x000fe20000000800ULL,
0xfffffff825237812ULL, 0x000fe400078ee223ULL, 0x0000000531247810ULL, 0x040fe40007ffe0ffULL,
0x0000000831277810ULL, 0x060fe40007ffe0ffULL, 0x0000000631257810ULL, 0x000fe20007ffe0ffULL,
0x0000002d002d7308ULL, 0x000ea20000000800ULL, 0x000000181918723eULL, 0x002fe200000010ffULL,
0x0000000827337824ULL, 0x000fe200078e00ffULL, 0xffffffff31267810ULL, 0x000fc40007ffe0ffULL,
0xfffffff82f257812ULL, 0x000fe400078ee225ULL, 0xfffffff833277812ULL, 0x000fe200078ee227ULL,
0x0000001a001a7308ULL, 0x000ff00000000800ULL, 0x0000000300037308ULL, 0x000e620000000800ULL,
0x0000002c2d19723eULL, 0x004fe200000010ffULL, 0x000000ffff2c7224ULL, 0x000fc400078e0032ULL,
0x000000ffff2d7224ULL, 0x000fc800078e0032ULL, 0x0000002e001b7308ULL, 0x0005f00000000800ULL,
0x0000001600167308ULL, 0x000ee20000000800ULL, 0x0000001a031a723eULL, 0x002fe200000010ffULL,
0x00000008312e7824ULL, 0x044fe200078e00ffULL, 0x0000a00000037811ULL, 0x000fe200078e58ffULL,
0x0000000831317824ULL, 0x000fc600078e00ffULL, 0xfffffff82e247812ULL, 0x000fe200078ee224ULL,
0x0000001017177824ULL, 0x100fe200078e0203ULL, 0xfffffff831267812ULL, 0x000fe200078ee226ULL,
0x0000001020207824ULL, 0x100fe400078e0203ULL, 0x0000001021217824ULL, 0x100fe400078e0203ULL,
0x0000001022227824ULL, 0x100fe200078e0203ULL, 0x0000001b161b723eULL, 0x008fe200000010ffULL,
0x0000001023237824ULL, 0x000fe400078e0203ULL, 0x0000000117177824ULL, 0x000fc400078e0215ULL,
0x0000001024247824ULL, 0x100fe400078e0203ULL, 0x0000002c181c723cULL, 0x000f62000004181cULL,
0x0000000115207824ULL, 0x000fe200078e0220ULL, 0x0000000817007388ULL, 0x0003e20000000800ULL,
0x0000001025257824ULL, 0x000fe400078e0203ULL, 0x0000000115217824ULL, 0x040fe200078e0221ULL,
0x0000000a20007388ULL, 0x0003e20000000800ULL, 0x0000001026267824ULL, 0x100fe400078e0203ULL,
0x0000000115227824ULL, 0x000fe200078e0222ULL, 0x0000000c21007388ULL, 0x0003e20000000800ULL,
0x0000001027277824ULL, 0x000fc400078e0203ULL, 0x0000000115237824ULL, 0x040fe200078e0223ULL,
0x0000000e22007388ULL, 0x0003e20000000800ULL, 0x0000000115247824ULL, 0x040fe400078e0224ULL,
0x0000000115257824ULL, 0x040fe200078e0225ULL, 0x0000001023007388ULL, 0x0003e20000000800ULL,
0x0000000115267824ULL, 0x040fe400078e0226ULL, 0x0000000115277824ULL, 0x000fe200078e0227ULL,
0x0000001224007388ULL, 0x0003e40000000800ULL, 0x000000ffff1d7224ULL, 0x020fc400078e001eULL,
0x0000001825007388ULL, 0x0003e80000000800ULL, 0x0000001a26007388ULL, 0x0003e80000000800ULL,
0x0000000927007388ULL, 0x0003e80000000800ULL, 0x0004000b20007388ULL, 0x0003e80000000800ULL,
0x0004000d21007388ULL, 0x0003e80000000800ULL, 0x0004000f22007388ULL, 0x0003e80000000800ULL,
0x0004001123007388ULL, 0x0003e80000000800ULL, 0x0004001324007388ULL, 0x0003e80000000800ULL,
0x0004001925007388ULL, 0x0003e80000000800ULL, 0x0004001b26007388ULL, 0x0003e80000000800ULL,
0x0100000414008388ULL, 0x0003e80000000c00ULL, 0x0102001c14008388ULL, 0x0003e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000003dff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000008003dff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000010003dff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000013c3c7810ULL, 0x000fe20007ffe0ffULL,
0x000018003dff7f8cULL, 0x0003e6000c80043fULL, 0x0000002a3c00720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffb3d000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff487807ULL, 0x004fe40004000000ULL,
0x0002078000497802ULL, 0x000fc40000000f00ULL, 0x0000104000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff277224ULL, 0x000fe200078e004aULL, 0xfffe197000007947ULL, 0x000fea000383ffffULL,
0x00000001ff487807ULL, 0x000fe40005000000ULL, 0x000207d000497802ULL, 0x000fc40000000f00ULL,
0x00000ff000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff277224ULL, 0x000fe200078e004aULL,
0xfffe19d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4a7224ULL, 0x002fe200078e0024ULL,
0x0002082000487802ULL, 0x000fc40000000f00ULL, 0x00000f6000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff497224ULL, 0x004fe200078e004aULL, 0xfffe1a7000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4a7224ULL, 0x000fe200078e0024ULL, 0x0002087000487802ULL, 0x000fc40000000f00ULL,
0x00000f1000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff497224ULL, 0x004fe200078e004aULL,
0xfffe1b9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4a7224ULL, 0x000fe200078e0024ULL,
0x000208d000487802ULL, 0x000fe20000000f00ULL, 0x000000ffff497224ULL, 0x000fc400078e0025ULL,
0x00000eb000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff367224ULL, 0x004fe200078e004aULL,
0xfffe1f8000007947ULL, 0x000fea000383ffffULL, 0x000000ffff497224ULL, 0x000fe200078e0037ULL,
0x0002093000487802ULL, 0x000fe20000000f00ULL, 0x000000ffff4a7224ULL, 0x000fc400078e0024ULL,
0x00000e5000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff377224ULL, 0x004fe200078e004aULL,
0xfffe1f5000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4a7224ULL, 0x000fe200078e001cULL,
0x0002099000487802ULL, 0x000fe20000000f00ULL, 0x000000ffff497224ULL, 0x000fc400078e001dULL,
0x00000df000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff367224ULL, 0x004fe200078e004aULL,
0xfffe4c6000007947ULL, 0x000fea000383ffffULL, 0x000000ffff497224ULL, 0x000fe200078e0037ULL,
0x000209f000487802ULL, 0x000fe20000000f00ULL, 0x000000ffff4a7224ULL, 0x000fc400078e001cULL,
0x00000d9000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff377224ULL, 0x004fe200078e004aULL,
0xfffe4c3000007947ULL, 0x000fea000383ffffULL, 0x00000001ff487807ULL, 0x008fe40004000000ULL,
0x00020a4000497802ULL, 0x000fc40000000f00ULL, 0x00000d8000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff477224ULL, 0x000fe200078e004aULL, 0xfffe79f000007947ULL, 0x000fea000383ffffULL,
0x00000001ff487807ULL, 0x000fe40005000000ULL, 0x00020a9000497802ULL, 0x000fc40000000f00ULL,
0x00000d3000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e004aULL,
0xfffe7a3000007947ULL, 0x000fea000383ffffULL, 0x000000ffff497224ULL, 0x000fe200078e0048ULL,
0x00020af000487802ULL, 0x000fe20000000f00ULL, 0x000000ffff4a7224ULL, 0x000fc400078e004bULL,
0x00000c9000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff487224ULL, 0x004fe200078e004aULL,
0xfffe7ae000007947ULL, 0x000fea000383ffffULL, 0x000000ffff497224ULL, 0x000fe200078e0048ULL,
0x00020b5000487802ULL, 0x000fe20000000f00ULL, 0x000000ffff4a7224ULL, 0x000fc400078e004bULL,
0x00000c3000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff487224ULL, 0x004fe200078e004aULL,
0xfffe7be000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4a7224ULL, 0x000fe200078e0025ULL,
0x00020bb000487802ULL, 0x000fe20000000f00ULL, 0x000000ffff497224ULL, 0x000fc400078e0045ULL,
0x00000bd000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff367224ULL, 0x004fe200078e004aULL,
0xfffe801000007947ULL, 0x000fea000383ffffULL, 0x000000ffff497224ULL, 0x000fe200078e0037ULL,
0x00020c1000487802ULL, 0x000fe20000000f00ULL, 0x000000ffff4a7224ULL, 0x000fc400078e0025ULL,
0x00000b7000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff377224ULL, 0x004fe200078e004aULL,
0xfffe7fe000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4a7224ULL, 0x000fe200078e0018ULL,
0x00020c7000487802ULL, 0x000fe20000000f00ULL, 0x000000ffff497224ULL, 0x000fc400078e0019ULL,
0x00000b1000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff367224ULL, 0x004fe200078e004aULL,
0xfffeab1000007947ULL, 0x000fea000383ffffULL, 0x000000ffff497224ULL, 0x000fe200078e0037ULL,
0x00020cd000487802ULL, 0x000fe20000000f00ULL, 0x000000ffff4a7224ULL, 0x000fc400078e0018ULL,
0x00000ab000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff377224ULL, 0x004fe200078e004aULL,
0xfffeaae000007947ULL, 0x000fea000383ffffULL, 0x00000001ff487807ULL, 0x008fe40004000000ULL,
0x00020d2000497802ULL, 0x000fc40000000f00ULL, 0x00000aa000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff277224ULL, 0x000fe200078e004aULL, 0xfffed79000007947ULL, 0x000fea000383ffffULL,
0x00000001ff487807ULL, 0x000fe40005000000ULL, 0x00020d7000497802ULL, 0x000fc40000000f00ULL,
0x00000a5000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff4b7224ULL, 0x000fe200078e004aULL,
0xfffed7d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff497224ULL, 0x000fe200078e0048ULL,
0x00020dd000487802ULL, 0x000fe20000000f00ULL, 0x000000ffff4a7224ULL, 0x000fc400078e004cULL,
0x000009b000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff487224ULL, 0x004fe200078e004aULL,
0xfffed88000007947ULL, 0x000fea000383ffffULL, 0x000000ffff497224ULL, 0x000fe200078e0048ULL,
0x00020e3000487802ULL, 0x000fe20000000f00ULL, 0x000000ffff4a7224ULL, 0x000fc400078e004cULL,
0x0000095000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff487224ULL, 0x004fe200078e004aULL,
0xfffed98000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4a7224ULL, 0x000fe200078e0024ULL,
0x00020e9000487802ULL, 0x000fe20000000f00ULL, 0x000000ffff497224ULL, 0x000fc400078e0025ULL,
0x000008f000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff367224ULL, 0x004fe200078e004aULL,
0xfffeddb000007947ULL, 0x000fea000383ffffULL, 0x000000ffff497224ULL, 0x000fe200078e0037ULL,
0x00020ef000487802ULL, 0x000fe20000000f00ULL, 0x000000ffff4a7224ULL, 0x000fc400078e0024ULL,
0x0000089000007944ULL, 0x01efea0003c00000ULL, 0x000000ffff377224ULL, 0x004fe200078e004aULL,
0xfffedd8000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4a7224ULL, 0x000fe200078e0018ULL,
0x00020f5000487802ULL, 0x000fe20000000f00ULL, 0x000000ffff497224ULL, 0x000fc400078e0019ULL,
0x0000083000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff367224ULL, 0x004fe200078e004aULL,
0xffff08b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff497224ULL, 0x000fe200078e0037ULL,
0x00020fb000487802ULL, 0x000fe20000000f00ULL, 0x000000ffff4a7224ULL, 0x000fc400078e0018ULL,
0x000007d000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff377224ULL, 0x004fe200078e004aULL,
0xffff088000007947ULL, 0x000fea000383ffffULL, 0x00000001ff487807ULL, 0x008fe40004000000ULL,
0x0002100000497802ULL, 0x000fc40000000f00ULL, 0x000007c000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff477224ULL, 0x000fe200078e004aULL, 0xffff354000007947ULL, 0x000fea000383ffffULL,
0x00000001ff487807ULL, 0x000fe40004800000ULL, 0x0002105000497802ULL, 0x000fc40000000f00ULL,
0x0000077000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e004aULL,
0xffff358000007947ULL, 0x000fea000383ffffULL, 0x000000ffff497224ULL, 0x000fe200078e0031ULL,
0x000210b000487802ULL, 0x000fe20000000f00ULL, 0x000000ffff4a7224ULL, 0x000fc400078e0032ULL,
0x000006d000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff317224ULL, 0x004fe200078e004aULL,
0xffff363000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4a7224ULL, 0x000fe200078e0032ULL,
0x0002111000487802ULL, 0x000fe20000000f00ULL, 0x000000ffff497224ULL, 0x000fc400078e0031ULL,
0x0000067000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff317224ULL, 0x004fe200078e004aULL,
0xffff373000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4a7224ULL, 0x000fe200078e0025ULL,
0x0002117000487802ULL, 0x000fe20000000f00ULL, 0x000000ffff497224ULL, 0x000fc400078e0031ULL,
0x0000061000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff367224ULL, 0x004fe200078e004aULL,
0xffff3b6000007947ULL, 0x000fea000383ffffULL, 0x000000ffff497224ULL, 0x000fe200078e0037ULL,
0x000211d000487802ULL, 0x000fe20000000f00ULL, 0x000000ffff4a7224ULL, 0x000fc400078e0025ULL,
0x000005b000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff377224ULL, 0x004fe200078e004aULL,
0xffff3b3000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4a7224ULL, 0x000fe200078e001cULL,
0x0002123000487802ULL, 0x000fe20000000f00ULL, 0x000000ffff497224ULL, 0x000fc400078e001dULL,
0x0000055000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff367224ULL, 0x004fe200078e004aULL,
0xffff668000007947ULL, 0x000fea000383ffffULL, 0x000000ffff497224ULL, 0x000fe200078e0037ULL,
0x0002129000487802ULL, 0x000fe20000000f00ULL, 0x000000ffff4a7224ULL, 0x000fc400078e001cULL,
0x000004f000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff377224ULL, 0x004fe200078e004aULL,
0xffff665000007947ULL, 0x000fea000383ffffULL, 0x000000ffff087224ULL, 0x000fe200078e0004ULL,
0x000212f000307802ULL, 0x000fe20000000f00ULL, 0x00000002ff097424ULL, 0x000fc400078e00ffULL,
0x0000044000007944ULL, 0x012fea0003c00000ULL, 0xffffe6c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff087224ULL, 0x000fe200078e0031ULL, 0x0002134000307802ULL, 0x000fe20000000f00ULL,
0x00000002ff097424ULL, 0x000fc400078e00ffULL, 0x000003f000007944ULL, 0x012fea0003c00000ULL,
0x000000033100720bULL, 0x004fe20003f1e000ULL, 0x000000ffff087224ULL, 0x000fe200078e0006ULL,
0x000213a000307802ULL, 0x000fe20000000f00ULL, 0x00000002ff097424ULL, 0x000fe200078e00ffULL,
0x0000003103057208ULL, 0x000fc80004000000ULL, 0x0000039000007944ULL, 0x000fea0003c00000ULL,
0x000000030600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff087224ULL, 0x000fe200078e0007ULL,
0x0002140000307802ULL, 0x000fe20000000f00ULL, 0x00000002ff097424ULL, 0x000fe200078e00ffULL,
0x0000000603067208ULL, 0x000fc80004000000ULL, 0x0000033000007944ULL, 0x000fea0003c00000ULL,
0x000000030700720bULL, 0x004fe20003f1e000ULL, 0x000000ffff087224ULL, 0x000fe200078e0032ULL,
0x0002146000307802ULL, 0x000fe20000000f00ULL, 0x00000001ff097424ULL, 0x000fe200078e00ffULL,
0x0000000703077208ULL, 0x000fc80004000000ULL, 0x000002d000007944ULL, 0x000fea0003c00000ULL,
0x000000033200720bULL, 0x004fe20003f1e000ULL, 0x000000ffff087224ULL, 0x000fe200078e0005ULL,
0x000214c000307802ULL, 0x000fe20000000f00ULL, 0x00000001ff097424ULL, 0x000fe200078e00ffULL,
0x0000003203047208ULL, 0x000fc80004000000ULL, 0x0000027000007944ULL, 0x000fea0003c00000ULL,
0x000000030500720bULL, 0x004fe20003f1e000ULL, 0x000000ffff087224ULL, 0x000fe200078e0006ULL,
0x0002152000307802ULL, 0x000fe20000000f00ULL, 0x00000001ff097424ULL, 0x000fe200078e00ffULL,
0x0000000503057208ULL, 0x000fc80004000000ULL, 0x0000021000007944ULL, 0x000fea0003c00000ULL,
0x000000030600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff087224ULL, 0x000fe200078e0007ULL,
0x0002158000307802ULL, 0x000fe20000000f00ULL, 0x00000001ff097424ULL, 0x000fe200078e00ffULL,
0x0000000603067208ULL, 0x000fc80004000000ULL, 0x000001b000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff307224ULL, 0x004fe200078e0003ULL, 0xffffe58000007947ULL, 0x000fea000383ffffULL,
0x0180000003027810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000002047812ULL, 0x000fc800078ec0ffULL, 0x018000000400780cULL, 0x000fda0003f05070ULL,
0x0000000300028308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0400720cULL, 0x040fe40003f25070ULL, 0x008000000400780cULL, 0x000fe40003f02070ULL,
0x00000001ff047807ULL, 0x000fe40000800000ULL, 0x00000001ff027807ULL, 0x004fc80004000000ULL,
0x0000000204ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff03ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000003037812ULL, 0x002fe400078ec0ffULL,
0x00000001ff027807ULL, 0x000fc80000000000ULL, 0x0000000204ff7212ULL, 0x000fda000780c0ffULL,
0x0080000003020812ULL, 0x000fe200078efcffULL, 0x000000ffff028224ULL, 0x000fe200078e0003ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000300027308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff047224ULL, 0x00cfe400078e0002ULL,
0x000000ffff027224ULL, 0x000fe400078e0005ULL, 0x00000000ff037424ULL, 0x002fc800078e00ffULL,
0xfffde8d002007950ULL, 0x000fea0003c3ffffULL, 0x0000003400007348ULL, 0x000fe80003800000ULL,
0x0c00000908037389ULL, 0x0002a400000e0033ULL, 0x000000ffff087224ULL, 0x002fe400078e0030ULL,
0x00000000ff097424ULL, 0x000fc800078e00ffULL, 0xfffde88008007950ULL, 0x000fea0003c3ffffULL,
0x0000003400007348ULL, 0x000fe80003800000ULL, 0x000000494a4a7389ULL, 0x0002a400000e0033ULL,
0x00000000ff497424ULL, 0x002fc800078e00ffULL, 0xfffde84048007950ULL, 0x000fea0003c3ffffULL,
0x000000014800780cULL, 0x000fe20003f45070ULL, 0x0000003200007348ULL, 0x000fd80003800000ULL,
0x0000000000487806ULL, 0x000fc800050e0100ULL, 0x00000032484a7212ULL, 0x000fe200078ec0ffULL,
0x000000ffff487224ULL, 0x000fe400078e0049ULL, 0x00000000ff497424ULL, 0x000fc800078e00ffULL,
0xfffde7d048007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000200000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005e7ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000748ULL, 0x0000000000000288ULL, 0x0000001a00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009d0ULL, 0x00000000000004a0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e70ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000f30ULL, 0x0000000000000a04ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001938ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001948ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000007bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000019d8ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000019dcULL, 0x00000000000001b0ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001c00ULL, 0x0000000000021900ULL, 0xec00001a00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x0000000100000089ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000023500ULL, 0x0000000000000044ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000023550ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x00000000000238d0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x00000000000019d8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000021b28ULL, 0x0000000000021b28ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000023500ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x00000000000238d0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_1_kvt_int8_pagedKV_64_nqpkv_8_m_8_sm_89_cubin_len = 145840;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
