/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_4_kvt_bf16_pagedKV_128_nqpkv_1_m_1_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x00000000000286c0ULL, 0x0000000000028340ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f34314944327961ULL, 0x6f6c66625f766e5fULL,
0x326a4c3236317461ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL,
0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x336a4c4536316a4cULL, 0x4c49746132454532ULL,
0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45346a4c4534366aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL,
0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL,
0x4d6e4974736e4939ULL, 0x4c45326a4c497461ULL, 0x45346a4c4545326aULL, 0x7461324545316a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL, 0x6a4c4532336a4c45ULL,
0x4974613245453233ULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL,
0x45386a4c45346a4cULL, 0x30624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL,
0x316a4c4545346a4cULL, 0x324545386a4c4536ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x746e695f5f240067ULL, 0x5f305f6c616e7265ULL,
0x5f616475635f5f24ULL, 0x7063725f30326d73ULL, 0x5f7a74665f6e725fULL, 0x776f6c735f323366ULL,
0x5f5f240068746170ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f315fULL, 0x5f30376d735f6164ULL,
0x636e79736c666873ULL, 0x00705f796c66625fULL, 0x7265746e695f5f24ULL, 0x5f245f325f6c616eULL,
0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x5f7864695f636e79ULL, 0x746e695f5f240070ULL,
0x5f335f6c616e7265ULL, 0x5f616475635f5f24ULL, 0x746f765f30376d73ULL, 0x61625f636e797365ULL,
0x5f5f2400746f6c6cULL, 0x6c616e7265746e69ULL, 0x75635f5f245f345fULL, 0x5f30376d735f6164ULL,
0x636e797370726177ULL, 0x742e616c65722e00ULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL,
0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL, 0x72656b240061686dULL, 0x2461686d5f6c656eULL,
0x657479426d656d73ULL, 0x2e766e2e00667542ULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x61705f0061686d5fULL, 0x6265642e006d6172ULL, 0x656d6172665f6775ULL, 0x65642e6c65722e00ULL,
0x6d6172665f677562ULL, 0x2e616c65722e0065ULL, 0x72665f6775626564ULL, 0x2e766e2e00656d61ULL,
0x697463612e6c6572ULL, 0x0000000000006e6fULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0009000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000100000094ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c00030000009dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000c0001000000adULL, 0x000000000000002cULL, 0x0000000000000010ULL,
0x000c0001000000ebULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000124ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c00010000016bULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c0001000001b5ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c0001000001fbULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c000100000242ULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c000100000288ULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c0001000002d6ULL, 0x000000000000000cULL, 0x0000000000000004ULL,
0x000c000100000324ULL, 0x0000000000000020ULL, 0x0000000000000004ULL, 0x000c00010000036bULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000003b0ULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000b0022000003f6ULL, 0x0000000000026240ULL, 0x0000000000000170ULL,
0x000b002200000429ULL, 0x00000000000263b0ULL, 0x0000000000000040ULL, 0x000b002200000454ULL,
0x00000000000263f0ULL, 0x0000000000000040ULL, 0x000b00220000047eULL, 0x0000000000026430ULL,
0x0000000000000060ULL, 0x000b0022000004a9ULL, 0x0000000000026490ULL, 0x00000000000000f0ULL,
0x000a000300000510ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0004000300000530ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000560ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL, 0x0000000000026580ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0002624000000000ULL, 0x0000040400000000ULL, 0x810c000001640400ULL,
0x00971c0400288080ULL, 0x0000000000000000ULL, 0x00000074ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080850828808081ULL,
0x9b082880808d0828ULL, 0x288080a008288080ULL, 0x80a708288080a208ULL, 0x08288080a8082880ULL,
0x8080b008288080a9ULL, 0x8608288080b40828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL,
0x0028808086920000ULL, 0x0000000000000022ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL,
0x0002624000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL, 0x00000074ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080850828808081ULL, 0x8d08288080860828ULL, 0x2880808e08288080ULL, 0x809b082880808f08ULL,
0x082880809e082880ULL, 0x8080a208288080a0ULL, 0x8808288080b40828ULL, 0x2880828016288080ULL,
0x0000000000000310ULL, 0x0028808088920000ULL, 0x0000000000000022ULL, 0x0000001cffffffffULL,
0x0000011800000000ULL, 0x000263b000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x0000006cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080850828808081ULL, 0x8d08288080860828ULL, 0x2880808e08288080ULL,
0x809b082880808f08ULL, 0x082880809e082880ULL, 0x8080a208288080a0ULL, 0x8016288080b40828ULL,
0x0000000310288082ULL, 0x80b4920000000000ULL, 0x0000000022002880ULL, 0x0000001cffffffffULL,
0x000001c000000000ULL, 0x000263f000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x0000006cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080850828808081ULL, 0x8d08288080860828ULL, 0x2880808e08288080ULL,
0x809b082880808f08ULL, 0x082880809e082880ULL, 0x8080a208288080a0ULL, 0x8016288080b40828ULL,
0x0000000310288082ULL, 0x80b4920000000000ULL, 0x0000000022002880ULL, 0x0000001cffffffffULL,
0x0000026000000000ULL, 0x0002643000000000ULL, 0x0000006000000000ULL, 0x0000000000000000ULL,
0x00000074ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080850828808081ULL, 0x8808288080860828ULL, 0x2880808d08288080ULL,
0x80a0082880809b08ULL, 0x08288080a2082880ULL, 0x8080a908288080a7ULL, 0xb408288080b00828ULL,
0x288080a808288080ULL, 0x0003102880828016ULL, 0x9200000000000000ULL, 0x00002200288080a8ULL,
0x0000001cffffffffULL, 0x0000030000000000ULL, 0x0002649000000000ULL, 0x000000f000000000ULL,
0x0000000000000000ULL, 0x0000001900082f04ULL, 0x00082304000000c9ULL, 0x0000000000000015ULL,
0x0000001500081204ULL, 0x0008110400000000ULL, 0x0000000000000015ULL, 0x0000001400082304ULL,
0x0008120400000000ULL, 0x0000000000000014ULL, 0x0000001400081104ULL, 0x0008230400000000ULL,
0x0000000000000013ULL, 0x0000001300081204ULL, 0x0008110400000000ULL, 0x0000000000000013ULL,
0x0000001200082304ULL, 0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000001200081104ULL,
0x0008230400000000ULL, 0x0000000000000011ULL, 0x0000001100081204ULL, 0x0008110400000000ULL,
0x0000000000000011ULL, 0x0000001900082304ULL, 0x0008120400000000ULL, 0x0000000000000019ULL,
0x0000001900081104ULL, 0x0004370400000000ULL, 0x00080a040000007bULL, 0x0068016000000016ULL,
0x000c170400681903ULL, 0x0060000700000000ULL, 0x000c17040021f000ULL, 0x0058000600000000ULL,
0x000c17040021f000ULL, 0x0050000500000000ULL, 0x000c17040011f000ULL, 0x0038000400000000ULL,
0x000c17040061f000ULL, 0x0018000300000000ULL, 0x000c17040081f000ULL, 0x0010000200000000ULL,
0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL,
0x00ff1b030011f000ULL, 0x0000002000043104ULL, 0xffffffff020c2904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x00000100020c2804ULL, 0x000004b000000130ULL, 0x0000469000004600ULL, 0x000048f000004790ULL,
0x00004b5000004b20ULL, 0x00004bf000004ba0ULL, 0x0000714000007120ULL, 0x000071e000007190ULL,
0x00009b8000009af0ULL, 0x00009dc000009c70ULL, 0x0000a00000009fe0ULL, 0x0000a0a00000a050ULL,
0x0000c2e00000c2c0ULL, 0x0000c3800000c330ULL, 0x0000eb600000ead0ULL, 0x0000eda00000ec50ULL,
0x0000efe00000efc0ULL, 0x0000f0800000f030ULL, 0x000112c0000112a0ULL, 0x0001136000011310ULL,
0x00013b4000013ab0ULL, 0x00013d8000013c30ULL, 0x00013fc000013fa0ULL, 0x0001406000014010ULL,
0x000162a000016280ULL, 0x00016340000162f0ULL, 0x00016cb000016b70ULL, 0x0001734000017320ULL,
0x00018ca000018c90ULL, 0x00019310000192d0ULL, 0x00019de0000199a0ULL, 0x0001b3300001afb0ULL,
0x0001c4b00001b350ULL, 0x0001ca100001c4d0ULL, 0x0001dae00001ca20ULL, 0x0001e9d00001ddb0ULL,
0x0001f7300001ec10ULL, 0x000204900001f970ULL, 0x000211e0000206c0ULL, 0x00021fb000021440ULL,
0x0002327000022530ULL, 0x0002465000024610ULL, 0x0002467000024660ULL, 0x000246e000024680ULL,
0x0002472000024700ULL, 0x000253e000025390ULL, 0x000254a000025440ULL, 0x0002556000025500ULL,
0x00025620000255c0ULL, 0x000256c000025670ULL, 0x0002577000025710ULL, 0x00025830000257d0ULL,
0x000258f000025890ULL, 0x0002599000025940ULL, 0x00025a40000259e0ULL, 0x00025b0000025aa0ULL,
0x00025bc000025b60ULL, 0x00025c6000025c10ULL, 0x00025d1000025cb0ULL, 0x00025dd000025d70ULL,
0x00025e9000025e30ULL, 0x00025f3000025ee0ULL, 0x00025fd000025f80ULL, 0x0002609000026030ULL,
0x00026150000260f0ULL, 0x00026210000261b0ULL, 0x000001f007b03904ULL, 0x00014ad0000000ffULL,
0x00000270003f0100ULL, 0x00014ad80000000fULL, 0x00000370003f0120ULL, 0x00014b580000000fULL,
0x00000450003f0120ULL, 0x00014b780000000fULL, 0x00000480003f0120ULL, 0x00014b88000000ffULL,
0x00000520003f0100ULL, 0x00014ad0000000ffULL, 0x000007a0003f0107ULL, 0x00014b5c00000072ULL,
0x00000800003f0102ULL, 0x00014b5800000072ULL, 0x00000960003f0101ULL, 0x00014b88000000ffULL,
0x000009a0003f0101ULL, 0x00014b8c000000ffULL, 0x00000b60003f0105ULL, 0x00014b8c000000ffULL,
0x00001e30003f0105ULL, 0x00014b88000000ffULL, 0x00001e60003f0101ULL, 0x00014b8c000000ffULL,
0x00002030003f0105ULL, 0x00014b8c000000ffULL, 0x000021a0003f0105ULL, 0x00014b78000000ffULL,
0x00002220003f0107ULL, 0x00014b78000000ffULL, 0x00002280003f0101ULL, 0x00014b88000000ffULL,
0x00002560003f0101ULL, 0x00014b7c000000ffULL, 0x00002720003f0105ULL, 0x00014b7c000000ffULL,
0x00002780003f0105ULL, 0x00014b8c000000ffULL, 0x00002950003f0105ULL, 0x00014b8c000000ffULL,
0x00003c20003f0105ULL, 0x00014b88000000ffULL, 0x00003c50003f0101ULL, 0x00014b8c000000ffULL,
0x00003e20003f0105ULL, 0x00014b8c000000ffULL, 0x000041f0003f0105ULL, 0x00014b80000000ffULL,
0x00004270003f0107ULL, 0x00014b80000000ffULL, 0x00004320003f0101ULL, 0x00014ad800000072ULL,
0x00004350003f0101ULL, 0x00014adc00000072ULL, 0x00004520003f0105ULL, 0x00014adc00000072ULL,
0x000054b0003f0105ULL, 0x00014b88000000ffULL, 0x00005590003f0101ULL, 0x00014b84000000ffULL,
0x00005750003f0105ULL, 0x00014b84000000ffULL, 0x000057b0003f0105ULL, 0x00014b8c000000ffULL,
0x00005980003f0105ULL, 0x00014b8c000000ffULL, 0x00006c50003f0105ULL, 0x00014b88000000ffULL,
0x00006c80003f0101ULL, 0x00014b8c000000ffULL, 0x00006e50003f0105ULL, 0x00014b8c000000ffULL,
0x00007030003f0105ULL, 0x00014b78000000ffULL, 0x000070b0003f0107ULL, 0x00014b78000000ffULL,
0x000078d0003f0101ULL, 0x00014b88000000ffULL, 0x000079a0003f0101ULL, 0x00014b58000000ffULL,
0x00007a90003f0101ULL, 0x00014b7c000000ffULL, 0x00007c50003f0105ULL, 0x00014b7c000000ffULL,
0x00007cb0003f0105ULL, 0x00014b8c000000ffULL, 0x00007e80003f0105ULL, 0x00014b8c000000ffULL,
0x00009150003f0105ULL, 0x00014b88000000ffULL, 0x00009180003f0101ULL, 0x00014b8c000000ffULL,
0x00009350003f0105ULL, 0x00014b8c000000ffULL, 0x000096f0003f0105ULL, 0x00014b80000000ffULL,
0x00009770003f0107ULL, 0x00014b80000000ffULL, 0x00009810003f0101ULL, 0x00014af800000072ULL,
0x00009840003f0101ULL, 0x00014afc00000072ULL, 0x00009a10003f0105ULL, 0x00014afc00000072ULL,
0x0000a640003f0105ULL, 0x00014b88000000ffULL, 0x0000a730003f0101ULL, 0x00014b84000000ffULL,
0x0000a8f0003f0105ULL, 0x00014b84000000ffULL, 0x0000a950003f0105ULL, 0x00014b8c000000ffULL,
0x0000ab20003f0105ULL, 0x00014b8c000000ffULL, 0x0000bdf0003f0105ULL, 0x00014b88000000ffULL,
0x0000be20003f0101ULL, 0x00014b8c000000ffULL, 0x0000bff0003f0105ULL, 0x00014b8c000000ffULL,
0x0000c1d0003f0105ULL, 0x00014b78000000ffULL, 0x0000c250003f0107ULL, 0x00014b78000000ffULL,
0x0000c8d0003f0101ULL, 0x00014b88000000ffULL, 0x0000c980003f0101ULL, 0x00014b60000000ffULL,
0x0000ca70003f0101ULL, 0x00014b7c000000ffULL, 0x0000cc30003f0105ULL, 0x00014b7c000000ffULL,
0x0000cc90003f0105ULL, 0x00014b8c000000ffULL, 0x0000ce60003f0105ULL, 0x00014b8c000000ffULL,
0x0000e130003f0105ULL, 0x00014b88000000ffULL, 0x0000e160003f0101ULL, 0x00014b8c000000ffULL,
0x0000e330003f0105ULL, 0x00014b8c000000ffULL, 0x0000e6d0003f0105ULL, 0x00014b80000000ffULL,
0x0000e750003f0107ULL, 0x00014b80000000ffULL, 0x0000e7f0003f0101ULL, 0x00014b1800000072ULL,
0x0000e820003f0101ULL, 0x00014b1c00000072ULL, 0x0000e9f0003f0105ULL, 0x00014b1c00000072ULL,
0x0000f620003f0105ULL, 0x00014b88000000ffULL, 0x0000f710003f0101ULL, 0x00014b84000000ffULL,
0x0000f8d0003f0105ULL, 0x00014b84000000ffULL, 0x0000f930003f0105ULL, 0x00014b8c000000ffULL,
0x0000fb00003f0105ULL, 0x00014b8c000000ffULL, 0x00010dd0003f0105ULL, 0x00014b88000000ffULL,
0x00010e00003f0101ULL, 0x00014b8c000000ffULL, 0x00010fd0003f0105ULL, 0x00014b8c000000ffULL,
0x000111b0003f0105ULL, 0x00014b78000000ffULL, 0x00011230003f0107ULL, 0x00014b78000000ffULL,
0x000118b0003f0101ULL, 0x00014b88000000ffULL, 0x00011960003f0101ULL, 0x00014b68000000ffULL,
0x00011a50003f0101ULL, 0x00014b7c000000ffULL, 0x00011c10003f0105ULL, 0x00014b7c000000ffULL,
0x00011c70003f0105ULL, 0x00014b8c000000ffULL, 0x00011e40003f0105ULL, 0x00014b8c000000ffULL,
0x00013110003f0105ULL, 0x00014b88000000ffULL, 0x00013140003f0101ULL, 0x00014b8c000000ffULL,
0x00013310003f0105ULL, 0x00014b8c000000ffULL, 0x000136b0003f0105ULL, 0x00014b80000000ffULL,
0x00013730003f0107ULL, 0x00014b80000000ffULL, 0x000137d0003f0101ULL, 0x00014b3800000072ULL,
0x00013800003f0101ULL, 0x00014b3c00000072ULL, 0x000139d0003f0105ULL, 0x00014b3c00000072ULL,
0x00014600003f0105ULL, 0x00014b88000000ffULL, 0x000146f0003f0101ULL, 0x00014b84000000ffULL,
0x000148b0003f0105ULL, 0x00014b84000000ffULL, 0x00014910003f0105ULL, 0x00014b8c000000ffULL,
0x00014ae0003f0105ULL, 0x00014b8c000000ffULL, 0x00015db0003f0105ULL, 0x00014b88000000ffULL,
0x00015de0003f0101ULL, 0x00014b8c000000ffULL, 0x00015fb0003f0105ULL, 0x00014b8c000000ffULL,
0x00016190003f0105ULL, 0x00014b78000000ffULL, 0x00016210003f0107ULL, 0x00014b78000000ffULL,
0x00016890003f0101ULL, 0x00014b88000000ffULL, 0x00016930003f0101ULL, 0x00014b70000000ffULL,
0x00019c30003f0101ULL, 0x00014ad0000000ffULL, 0x0001afe0003f0101ULL, 0x00014ad4000000ffULL,
0x0001b1b0003f0105ULL, 0x00014ad4000000ffULL, 0x00023770003f0105ULL, 0x0000000000000072ULL,
0x00023b50003f0101ULL, 0x0000000400000072ULL, 0x00023d20003f0105ULL, 0x0000000400000072ULL,
0x000251f0003f0105ULL, 0x00014ad800000071ULL, 0x00025250003f0101ULL, 0x00014ae000000071ULL,
0x000252b0003f0101ULL, 0x00014ae800000071ULL, 0x00025320003f0101ULL, 0x00014af000000071ULL,
0x00053803003f0101ULL, 0x00019ad000101c04ULL, 0x0001b2b00001b210ULL, 0x0000040100025360ULL,
0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x0000000000000394ULL, 0x0000001900000002ULL, 0x00000000000002ecULL,
0x0000001900000002ULL, 0x000000000000024cULL, 0x0000001900000002ULL, 0x00000000000001acULL,
0x0000001900000002ULL, 0x0000000000000104ULL, 0x0000001900000002ULL, 0x0000000000000044ULL,
0x0000001900000002ULL, 0x000000000000036fULL, 0x0000001900000002ULL, 0x00000000000002c5ULL,
0x0000001900000002ULL, 0x0000000000000225ULL, 0x0000001900000002ULL, 0x0000000000000182ULL,
0x0000001900000002ULL, 0x00000000000000daULL, 0x0000001900000002ULL, 0x0000000000014c00ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x00000000000f7919ULL, 0x000e620000002100ULL,
0x0000000000107806ULL, 0x000fe200038e0000ULL, 0x00005800ff097624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x00000000000d7919ULL, 0x000ea20000002300ULL,
0x0000001000057300ULL, 0x000ee200000e0000ULL, 0x0000000409097824ULL, 0x000fe200078e00ffULL,
0x00000000000479c3ULL, 0x000f220000002500ULL, 0x0000000000007919ULL, 0x000ea20000002200ULL,
0x00000004ff177424ULL, 0x000fc600078e00ffULL, 0x0000000000157919ULL, 0x000ee20000000000ULL,
0x0000001000107309ULL, 0x000ea60000000000ULL, 0x0000000000067919ULL, 0x000ee80000000000ULL,
0x0000000000707919ULL, 0x000ee20000002600ULL, 0x00000005ff787819ULL, 0x002fcc000001160fULL,
0x00001fff78787589ULL, 0x000fe200000e0000ULL, 0x00000004ff7a7e24ULL, 0x010fe4000f8e00ffULL,
0x000001000d007a24ULL, 0x004fe400078e0200ULL, 0x00001fff0d0d7589ULL, 0x000e6400000e0000ULL,
0x00000000000f7a24ULL, 0x000fe400078e020fULL, 0x0000000000007919ULL, 0x000ea20000002700ULL,
0x000000060500720cULL, 0x008fc40003f02070ULL, 0x000000ff0f00720cULL, 0x040fe40003f25270ULL,
0x0000000f0f00780cULL, 0x040fe40003f44070ULL, 0x0000007f0f00780cULL, 0x040fe40003f84070ULL,
0x000000030f00780cULL, 0x000fce0003f64070ULL, 0x3fffff80ff029424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff039424ULL, 0x000fe400078e00ffULL, 0x000000040d047824ULL, 0x002fe400078e0278ULL,
0x7fffffc0ff05a424ULL, 0x000fe200078e00ffULL, 0x014ad002ff009388ULL, 0x0003e20000000a00ULL,
0x0000000009097224ULL, 0x004fe200078e0270ULL, 0x0000000104087819ULL, 0x000fe200000006ffULL,
0x3fffffc0ff04a424ULL, 0x000fe200078e00ffULL, 0x0000000200777819ULL, 0x000fe200000006ffULL,
0xff317217ff0ec424ULL, 0x000fe200078e00ffULL, 0x00000015080a7210ULL, 0x040fe20007ffe0ffULL,
0x00000020080b7824ULL, 0x040fe200078e00ffULL, 0x014ad8040f00a388ULL, 0x0005e20000008a00ULL,
0x3fffff60ff06b424ULL, 0x000fe200078e00ffULL, 0x0000000408037817ULL, 0x042fe20007800000ULL,
0x0000580008027a24ULL, 0x040fe200078e0209ULL, 0xffffffe00b0c7812ULL, 0x000fe200078ee20aULL,
0x7fffff60ff07b424ULL, 0x000fe200078e00ffULL, 0x00000001080a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000103037824ULL, 0x000fe200078e0a08ULL, 0x000000010f00780cULL, 0x000fe20003f44070ULL,
0x00000200ff0b7424ULL, 0x000fe200078e00ffULL, 0x0144000e0f00c388ULL, 0x0003e20000004800ULL,
0x000000010a087824ULL, 0x040fe200078e0215ULL, 0x000000010300780cULL, 0x000fe20003f83070ULL,
0x000058000a057a24ULL, 0x044fe200078e0209ULL, 0x000000050a097819ULL, 0x000fe200000006ffULL,
0x0000001015047824ULL, 0x000fe200078e00ffULL, 0x014b58060f00b388ULL, 0x0005e20000008a00ULL,
0x000000ff0300720cULL, 0x000fe20003f63070ULL, 0x00005c0002027625ULL, 0x000fe200078e000bULL,
0xffffffe0090e7812ULL, 0x002fc400078ee208ULL, 0x000001f004097812ULL, 0x000fe200078ec0ffULL,
0x00005c0005047625ULL, 0x000fc600078e000bULL, 0x0000000902027210ULL, 0x080fe20007fbe0ffULL,
0x3fffff80ff0a9424ULL, 0x000fe200078e00ffULL, 0x0000000904087210ULL, 0x000fe20007fde0ffULL,
0x3fffff00ff06a424ULL, 0x004fe200078e00ffULL, 0x00000003ff037210ULL, 0x000fe20002ffe4ffULL,
0x7fffff00ff07a424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff0b9424ULL, 0x000fe400078e00ffULL,
0x000000100c117824ULL, 0x000fe200078e00ffULL, 0x014b78060f00a388ULL, 0x000fe20000008a00ULL,
0x000000ffff097224ULL, 0x000fc400030e0605ULL, 0x000000100e137824ULL, 0x000fe200078e00ffULL,
0x014b880aff009388ULL, 0x000fe20000000a00ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0a10ULL,
0x0000620077047625ULL, 0x0c0fe200078e0017ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002117faeULL, 0x0003e2000d901c46ULL,
0x00006a0077067625ULL, 0x000fc600078e0017ULL, 0x0000000008137faeULL, 0x0003e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x014ad40cffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x014ad000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000604757981ULL, 0x000ea8000c1e1900ULL, 0x0000000606067981ULL, 0x000ee2000c1e1900ULL,
0x000000ff0d00720cULL, 0x000fe20003f05270ULL, 0xffffffffff027424ULL, 0x002fe200078e00ffULL,
0x0000007f75767810ULL, 0x004fc40007ffe0ffULL, 0x000000ff75747810ULL, 0x000fe40007ffe0ffULL,
0x00000008ff737819ULL, 0x008fe40000011606ULL, 0x00000007ff767819ULL, 0x000fe40000011676ULL,
0x00000008ff747819ULL, 0x000fc60000011674ULL, 0x000194a000008947ULL, 0x000fea0003800000ULL,
0x0000002078037824ULL, 0x040fe200078e0215ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x0000000878727824ULL, 0x000fe200078e00ffULL, 0x000000017a717819ULL, 0x040fe200000006ffULL,
0x00000003ff097424ULL, 0x000fe200078e00ffULL, 0x0000001f0300780cULL, 0x040fe20003f04070ULL,
0x000001007a047824ULL, 0x000fe200078e00ffULL, 0x000000030300780cULL, 0x000fd60003f24070ULL,
0x0000007000000947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0203ULL,
0x00014a0003057811ULL, 0x000fe200078e10ffULL, 0x0000680077067a24ULL, 0x000fc600078e0204ULL,
0x000000750800720cULL, 0x000fe20003f06070ULL, 0x0000000103067824ULL, 0x000fc800078e0206ULL,
0x0000660006067625ULL, 0x000fd000078e0017ULL, 0x0000000006057faeULL, 0x0003e4000c121846ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x014b5c0972ff738cULL, 0x0005e20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x014b580072ff7f8cULL, 0x0007e2000c80043fULL, 0x000000d000007945ULL, 0x000fe20003800000ULL,
0x000000b000001947ULL, 0x000fea0003800000ULL, 0x0000000400057824ULL, 0x002fe200078e0203ULL,
0x0000640071067a10ULL, 0x040fe40007ffe0ffULL, 0x000000767100720cULL, 0x000fe20003f06070ULL,
0x0000000205057824ULL, 0x000fe200078e00ffULL, 0x00014ac003037811ULL, 0x000fc600078e10ffULL,
0x0000640005067a24ULL, 0x000fc800078e0206ULL, 0x0000600006067625ULL, 0x000fca00078e0017ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006037faeULL, 0x0003e4000c121846ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000080000000791aULL, 0x000fc80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x014b8800ff067f8cULL, 0x002e62000c80043fULL, 0x000000ff00057202ULL, 0x000fe20000000f00ULL,
0x000000ffff0a7224ULL, 0x002fc400078e0007ULL, 0x0000000000067805ULL, 0x000fca0000015200ULL,
0x014b8c00ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe4000780480aULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x004fcc0000015200ULL,
0x0000000806087210ULL, 0x000fca0007f1e1ffULL, 0x0000000109097824ULL, 0x000fe200000e0e07ULL,
0x003d09000800780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400800780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff037819ULL, 0x000fc80000011409ULL, 0x0000000803037211ULL, 0x000fca00078110ffULL,
0x000000ffff087224ULL, 0x000fca00000e0609ULL, 0x0000000203037819ULL, 0x000fc80000001208ULL,
0x000000030000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000105057810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x014b8c00ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe4000780480aULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000017a037810ULL, 0x000fe20007ffe0ffULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x0000008070707824ULL, 0x000fe200078e00ffULL,
0x0000000704047899ULL, 0x000fe2000800063fULL, 0x000000740300720cULL, 0x000fda0003f06070ULL,
0x0000099000008947ULL, 0x000fea0003800000ULL, 0x0000000472057824ULL, 0x040fe200078e00ffULL,
0x00000000000e7919ULL, 0x000e620000000000ULL, 0x0000000172077824ULL, 0x040fe200078e0270ULL,
0x00000001720d7810ULL, 0x040fe20007ffe0ffULL, 0x00000200ff0f7424ULL, 0x000fe200078e00ffULL,
0x014a000005037984ULL, 0x000f220000000800ULL, 0x00000020720c7824ULL, 0x000fe400078e00ffULL,
0x000000100e0a7824ULL, 0x002fe400078e00ffULL, 0x0000000172097824ULL, 0x004fc600078e020eULL,
0x000001f00a117812ULL, 0x000fe200078ec0ffULL, 0x000000010d0a7824ULL, 0x000fe200078e020eULL,
0x0000000203087819ULL, 0x010fe400000006ffULL, 0x0000000475037217ULL, 0x000fc60007800000ULL,
0x014ac00008067984ULL, 0x000e640000000800ULL, 0x0000000103037824ULL, 0x000fca00078e0a04ULL,
0x0000000372037217ULL, 0x000fc80007800000ULL, 0x0000000372037210ULL, 0x000fc80007ffe1ffULL,
0x000000ff0300720cULL, 0x000fe20003f03070ULL, 0x0000000406067c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0006067625ULL, 0x000fca00078e000fULL, 0x0000001106087210ULL, 0x000fe40007f3e0ffULL,
0xffffffe00c067812ULL, 0x000fc600078ee209ULL, 0x000000ffff097224ULL, 0x000fe200008e0607ULL,
0x0000c000060b7811ULL, 0x000fe200078e20ffULL, 0x0000000170077824ULL, 0x000fe200078e020dULL,
0x000000050d0d7819ULL, 0x000fc600000006ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080b7faeULL, 0x0003e2000c101c46ULL, 0x000000010300780cULL, 0x000fe40003f03070ULL,
0xffffffe00d0a7812ULL, 0x000fe200078ee20aULL, 0x014a040005067984ULL, 0x000ea20000000800ULL,
0x00000002720d7810ULL, 0x000fe40007ffe0ffULL, 0x0000c0000a0b7811ULL, 0x002fc600078e20ffULL,
0x000000010d0a7824ULL, 0x000fe400078e020eULL, 0x00000004060c7824ULL, 0x004fca00078e00ffULL,
0x014ac0000c067984ULL, 0x000e640000000800ULL, 0x0000000406067c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0006067625ULL, 0x000fca00078e000fULL, 0x0000001106087210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe400008e0607ULL, 0x0000000170077824ULL, 0x000fe400078e020dULL,
0x000000200d0d7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080b7faeULL, 0x0003e2000c101c46ULL, 0x000000020300780cULL, 0x000fc60003f03070ULL,
0x014a080005067984ULL, 0x000ea20000000800ULL, 0xffffffe00d0a7812ULL, 0x000fe400078ee20aULL,
0x00000003720d7810ULL, 0x000fe40007ffe0ffULL, 0x0000c0000a0b7811ULL, 0x002fc600078e20ffULL,
0x000000010d0a7824ULL, 0x000fe400078e020eULL, 0x00000004060c7824ULL, 0x004fca00078e00ffULL,
0x014ac0000c067984ULL, 0x000e640000000800ULL, 0x0000000406067c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0006067625ULL, 0x000fca00078e000fULL, 0x0000001106087210ULL, 0x000fc80007f3e0ffULL,
0x00000007ff097210ULL, 0x000fe20000ffe4ffULL, 0x0000000170077824ULL, 0x000fe400078e020dULL,
0x000000200d0d7824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080b7faeULL, 0x0003e2000c101c46ULL, 0x000000030300780cULL, 0x000fe40003f03070ULL,
0xffffffe00d0a7812ULL, 0x000fe200078ee20aULL, 0x014a0c0005067984ULL, 0x000ea20000000800ULL,
0x00000004720d7810ULL, 0x000fc40007ffe0ffULL, 0x0000c0000a0b7811ULL, 0x002fc600078e20ffULL,
0x000000010d0a7824ULL, 0x000fe400078e020eULL, 0x00000004060c7824ULL, 0x004fca00078e00ffULL,
0x014ac0000c067984ULL, 0x000e640000000800ULL, 0x0000000406067c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0006067625ULL, 0x000fca00078e000fULL, 0x0000001106087210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe400008e0607ULL, 0x0000000170077824ULL, 0x000fe400078e020dULL,
0x000000200d0d7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080b7faeULL, 0x0003e2000c101c46ULL, 0x000000040300780cULL, 0x000fc60003f03070ULL,
0x014a100005067984ULL, 0x000ea20000000800ULL, 0xffffffe00d0a7812ULL, 0x000fe400078ee20aULL,
0x00000005720d7810ULL, 0x000fe40007ffe0ffULL, 0x0000c0000a0b7811ULL, 0x002fc600078e20ffULL,
0x000000010d0a7824ULL, 0x000fe200078e020eULL, 0x00000002060c7819ULL, 0x004fca00000006ffULL,
0x014ac0000c067984ULL, 0x000e640000000800ULL, 0x0000000406067c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0006067625ULL, 0x000fca00078e000fULL, 0x0000001106087210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0607ULL, 0x0000000d70077210ULL, 0x000fe20007ffe0ffULL,
0x000000200d0d7824ULL, 0x000fc600078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080b7faeULL, 0x0003e2000c101c46ULL, 0x000000050300780cULL, 0x000fe40003f03070ULL,
0xffffffe00d0a7812ULL, 0x000fe200078ee20aULL, 0x014a140005067984ULL, 0x000ea20000000800ULL,
0x00000006720d7810ULL, 0x000fe40007ffe0ffULL, 0x0000c0000a0b7811ULL, 0x002fe400078e20ffULL,
0x0000000e0d0a7210ULL, 0x000fe20007ffe0ffULL, 0x00000004060c7824ULL, 0x004fca00078e00ffULL,
0x014ac0000c067984ULL, 0x000e640000000800ULL, 0x0000000406067c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0006067625ULL, 0x000fca00078e000fULL, 0x0000001106087210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe400008e0607ULL, 0x0000000170077824ULL, 0x000fe400078e020dULL,
0x000000200d0d7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080b7faeULL, 0x0003e2000c101c46ULL, 0x000000060300780cULL, 0x000fc60003f03070ULL,
0x014a180005067984ULL, 0x000ea20000000800ULL, 0xffffffe00d0a7812ULL, 0x000fe400078ee20aULL,
0x00000007720d7810ULL, 0x000fe40007ffe0ffULL, 0x0000c0000a0b7811ULL, 0x002fc600078e20ffULL,
0x000000010d0a7824ULL, 0x000fe400078e020eULL, 0x00000004060c7824ULL, 0x004fca00078e00ffULL,
0x014ac0000c067984ULL, 0x000e640000000800ULL, 0x0000000406067c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0006067625ULL, 0x000fca00078e000fULL, 0x0000001106087210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe400008e0607ULL, 0x0000000170077824ULL, 0x000fe200078e020dULL,
0x000000050d0d7819ULL, 0x000fe400000006ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080b7faeULL, 0x0003e2000c101c46ULL, 0x000000070300780cULL, 0x000fe40003f03070ULL,
0xffffffe00d0a7812ULL, 0x000fe200078ee20aULL, 0x014a1c0005057984ULL, 0x000ea60000000800ULL,
0x0000c0000a037811ULL, 0x000fe200078e20ffULL, 0x00000004050c7824ULL, 0x004fca00078e00ffULL,
0x014ac0000c067984ULL, 0x000ea40000000800ULL, 0x0000000406067c24ULL, 0x004fc8000f8e0207ULL,
0x00005e0006067625ULL, 0x000fca00078e000fULL, 0x0000001106067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006037faeULL, 0x0003e2000c101c46ULL, 0x0000084000007947ULL, 0x000fea0003800000ULL,
0x00000000000e7919ULL, 0x000e620000000000ULL, 0x00000200ff107424ULL, 0x000fe200078e00ffULL,
0x000000720e037211ULL, 0x042fe200078fd8ffULL, 0x000000100e077824ULL, 0x000fc600078e00ffULL,
0x00000005030a7819ULL, 0x000fe200000006ffULL, 0x014a000003057984ULL, 0x000e620000004800ULL,
0x0000000170067824ULL, 0x000fe200078e0203ULL, 0x000001f0070f7812ULL, 0x000fe200078ec0ffULL,
0x0000000103097824ULL, 0x044fe200078e020eULL, 0x00000001030b7810ULL, 0x000fca0007ffe0ffULL,
0x000000010b0d7824ULL, 0x040fe400078e020eULL, 0x000000200b127824ULL, 0x000fca00078e00ffULL,
0xffffffe0120d7812ULL, 0x000fc800078ee20dULL, 0x0000c0000d0d7811ULL, 0x000fe200078e20ffULL,
0x014ac00005057984ULL, 0x002e640000004800ULL, 0x0000000405067c24ULL, 0x002fc8000f8e0206ULL,
0x00005e0006067625ULL, 0x000fca00078e0010ULL, 0x0000000f06087210ULL, 0x000fe40007f1e0ffULL,
0xffffffe00a067812ULL, 0x000fc600078ee209ULL, 0x000000ffff097224ULL, 0x000fe200000e0607ULL,
0x0000c00006057811ULL, 0x000fe200078e20ffULL, 0x0000000170077824ULL, 0x000fc800078e020bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008057faeULL, 0x0003e8000b901c46ULL,
0x014a0400030c7984ULL, 0x000ea20000004800ULL, 0x0000000203057810ULL, 0x002fca0007ffe0ffULL,
0x0000000105097824ULL, 0x040fe400078e020eULL, 0x0000002005127824ULL, 0x000fe200078e00ffULL,
0x014ac0000c0c7984ULL, 0x004e640000004800ULL, 0x000000040c077c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0007067625ULL, 0x000fca00078e0010ULL, 0x0000000f060a7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e0607ULL, 0x0000000570077210ULL, 0x000fe40007ffe0ffULL,
0xffffffe012057812ULL, 0x000fe400078ee209ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0d7faeULL, 0x0003e4000b901c46ULL, 0x0000c00005057811ULL, 0x000fe400078e20ffULL,
0x014a0800030c7984ULL, 0x000ea20000004800ULL, 0x00000003030b7810ULL, 0x002fc80007ffe0ffULL,
0x000000050b127819ULL, 0x040fe200000006ffULL, 0x000000010b0d7824ULL, 0x000fca00078e020eULL,
0xffffffe0120d7812ULL, 0x000fc800078ee20dULL, 0x0000c0000d0d7811ULL, 0x000fe200078e20ffULL,
0x014ac0000c0c7984ULL, 0x004e640000004800ULL, 0x000000040c077c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0007067625ULL, 0x000fca00078e0010ULL, 0x0000000f06087210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff097224ULL, 0x000fe400000e0607ULL, 0x0000000170077824ULL, 0x000fc600078e020bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008057faeULL, 0x0003e8000b901c46ULL,
0x014a0c00030c7984ULL, 0x000ea20000004800ULL, 0x0000000403057810ULL, 0x002fca0007ffe0ffULL,
0x0000000105097824ULL, 0x040fe400078e020eULL, 0x0000002005127824ULL, 0x000fe200078e00ffULL,
0x014ac0000c0c7984ULL, 0x004e640000004800ULL, 0x000000040c077c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0007067625ULL, 0x000fca00078e0010ULL, 0x0000000f060a7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0b7224ULL, 0x000fe400000e0607ULL, 0x0000000170077824ULL, 0x000fe200078e0205ULL,
0xffffffe012057812ULL, 0x000fe400078ee209ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0d7faeULL, 0x0003e4000b901c46ULL, 0x0000c00005057811ULL, 0x000fe400078e20ffULL,
0x014a1000030c7984ULL, 0x000ea20000004800ULL, 0x00000005030b7810ULL, 0x002fca0007ffe0ffULL,
0x000000010b0d7824ULL, 0x040fe400078e020eULL, 0x000000200b127824ULL, 0x000fca00078e00ffULL,
0xffffffe0120d7812ULL, 0x000fc800078ee20dULL, 0x0000c0000d0d7811ULL, 0x000fe200078e20ffULL,
0x014ac0000c0c7984ULL, 0x004e640000004800ULL, 0x000000040c077c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0007067625ULL, 0x000fca00078e0010ULL, 0x0000000f06087210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff097224ULL, 0x000fe200000e0607ULL, 0x0000000b70077210ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008057faeULL, 0x0003e8000b901c46ULL,
0x014a1400030c7984ULL, 0x000ea20000004800ULL, 0x0000000603057810ULL, 0x002fc80007ffe0ffULL,
0x0000000505127819ULL, 0x040fe200000006ffULL, 0x0000000105097824ULL, 0x000fe200078e020eULL,
0x014ac0000c0c7984ULL, 0x004e640000004800ULL, 0x000000040c077c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0007067625ULL, 0x000fca00078e0010ULL, 0x0000000f060a7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0b7224ULL, 0x000fe400000e0607ULL, 0x0000000170077824ULL, 0x000fe200078e0205ULL,
0xffffffe012057812ULL, 0x000fe400078ee209ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0d7faeULL, 0x0003e4000b901c46ULL, 0x0000c00005057811ULL, 0x000fe400078e20ffULL,
0x014a1800030c7984ULL, 0x000ea20000004800ULL, 0x00000007030b7810ULL, 0x002fc60007ffe0ffULL,
0x014ac0000c0c7984ULL, 0x004e640000004800ULL, 0x000000040c077c24ULL, 0x002fe4000f8e0207ULL,
0x000000010b0c7824ULL, 0x000fe400078e020eULL, 0x00005e0007067625ULL, 0x000fca00078e0010ULL,
0x0000000f06087210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff097224ULL, 0x000fe400000e0607ULL,
0x0000000170077824ULL, 0x000fe400078e020bULL, 0x000000200b0b7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008057faeULL, 0x0003e8000b901c46ULL,
0x014a1c00030a7984ULL, 0x0005220000004800ULL, 0xffffffe00b0c7812ULL, 0x000fc800078ee20cULL,
0x0000c0000c037811ULL, 0x004fe200078e20ffULL, 0x014ac0000a0a7984ULL, 0x010ea40000004800ULL,
0x000000040a077c24ULL, 0x004fc8000f8e0207ULL, 0x00005e0007067625ULL, 0x000fca00078e0010ULL,
0x0000000f06067210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006037faeULL, 0x0003e6000b901c46ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b8800ff067f8cULL, 0x002e64000c80043fULL,
0x00000007000a7202ULL, 0x002fc40000000f00ULL, 0x0000000000067805ULL, 0x000fca0000015200ULL,
0x014b8c00ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe4000780480aULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff057224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x0000000806087210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e07ULL, 0x003d09000800780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400800780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011409ULL,
0x0000000803037211ULL, 0x000fca00078110ffULL, 0x000000ffff087224ULL, 0x000fca00000e0609ULL,
0x0000000203037819ULL, 0x000fc80000001208ULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000105057810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x014b8c00ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe4000780480aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0x0000010000007945ULL, 0x000fe20003800000ULL,
0x0000002078057824ULL, 0x002fca00078e0203ULL, 0x0000001f0500780cULL, 0x000fda0003f04070ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x0000002004047810ULL, 0x000fe40007ffe0ffULL,
0x0000000400077802ULL, 0x000fe40000000f00ULL, 0x00014a0005097811ULL, 0x040fe200078e10ffULL,
0x0000000105067824ULL, 0x100fe400078e0204ULL, 0x0000680077047a24ULL, 0x000fc600078e0204ULL,
0x000000750600720cULL, 0x000fe20003f06070ULL, 0x0000000105047824ULL, 0x000fc800078e0204ULL,
0x0000660004047625ULL, 0x000fd000078e0007ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004097faeULL, 0x0003e4000c121846ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x014b7800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x014b7800ff047f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x014b8800ff067f8cULL, 0x000ea2000c80043fULL, 0x000000747a00720cULL, 0x000fe20003f06070ULL,
0x000000ffff897224ULL, 0x002fe200078e0005ULL, 0x00000000006c7805ULL, 0x000fe2000001ff00ULL,
0xff317217ff6f7424ULL, 0x000fe200078e00ffULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x000000ffff6e7224ULL, 0x000fe200078e00ffULL, 0x000000ff00317202ULL, 0x000fe20000000f00ULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff1e7224ULL, 0x000fc400078e00ffULL, 0x0000001fff1f7424ULL, 0x000fe400078e00ffULL,
0x000000ffff3c7224ULL, 0x004fe400078e0007ULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0xffffffffff207424ULL, 0x000fe200078e00ffULL, 0x0001457000000947ULL, 0x000fea0003800000ULL,
0x00005800ff217624ULL, 0x000fe200078e00ffULL, 0x0001455000007945ULL, 0x000fe20003800000ULL,
0x000000ffff6e7224ULL, 0x000fe200078e00ffULL, 0xff317217006f7802ULL, 0x000fe20000000f00ULL,
0x0000008021217824ULL, 0x000fc400078e00ffULL, 0x000001007a227824ULL, 0x000fca00078e00ffULL,
0x000000752200720cULL, 0x000fda0003f06070ULL, 0x000144a000000947ULL, 0x008fea0003800000ULL,
0x000000ffff887224ULL, 0x000fc600078e00ffULL, 0x0000007a7300720cULL, 0x000fe20003fa4070ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x00000002ff237819ULL, 0x000fe20000011688ULL,
0x000000ffff2e7224ULL, 0x000fe200078e00ffULL, 0x0000000388287812ULL, 0x040fe400078ec0ffULL,
0x0000002388237207ULL, 0x000fe40002800000ULL, 0x000000ff28287207ULL, 0x000fe40006800000ULL,
0x00000002ff2b7819ULL, 0x000fc40000011623ULL, 0x0000000323297812ULL, 0x000fc600078ec0ffULL,
0x000003002b227a24ULL, 0x000fc400078e027aULL, 0x00000000002a7805ULL, 0x000fca0000015200ULL,
0x014b7c00ff2c7984ULL, 0x000e640000000800ULL, 0x800000002cff7812ULL, 0x002fe40007804889ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000017945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002c7805ULL, 0x000fcc0000015200ULL,
0x0000002c2a2f7210ULL, 0x000fca0007f1e1ffULL, 0x000000012d2d7824ULL, 0x000fe200000e0e2bULL,
0x003d09002f00780cULL, 0x000fc80003f06070ULL, 0x000000ff2d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402f00780cULL, 0x000fc80003f06070ULL,
0x000000ff2d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff2c7819ULL, 0x000fc8000001142dULL, 0x0000002f2c2c7211ULL, 0x000fc800078110ffULL,
0x0000002dff2d7210ULL, 0x000fc800007fe4ffULL, 0x000000022c2c7819ULL, 0x000fc8000000122dULL,
0x0000002c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012e2e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x014b7c00ff2c7984ULL, 0x000e640000000800ULL, 0x800000002cff7812ULL, 0x002fe40007804889ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fc40000015200ULL,
0x014b8c00ff2d7984ULL, 0x000e640000000800ULL, 0x800000002dff7812ULL, 0x002fe4000780483cULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff2e7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002c7805ULL, 0x000fcc0000015200ULL, 0x0000002c2a2f7210ULL, 0x000fca0007f1e1ffULL,
0x000000012d2d7824ULL, 0x000fe200000e0e2bULL, 0x003d09002f00780cULL, 0x000fc80003f06070ULL,
0x000000ff2d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402f00780cULL, 0x000fc80003f06070ULL, 0x000000ff2d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff2c7819ULL, 0x000fc8000001142dULL,
0x0000002f2c2c7211ULL, 0x000fca00078110ffULL, 0x000000ffff2d7224ULL, 0x000fca00000e062dULL,
0x000000022c2c7819ULL, 0x000fc8000000122dULL, 0x0000002c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012e2e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x014b8c00ff2d7984ULL, 0x000e640000000800ULL,
0x800000002dff7812ULL, 0x002fe4000780483cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000001222b7810ULL, 0x040fe20007ffe0ffULL, 0x00000004222a7824ULL, 0x000fe200078e0229ULL,
0x0000120000017945ULL, 0x000fe40003800000ULL, 0x000000742b00720cULL, 0x000fe40003f06070ULL,
0x000000202a2d7811ULL, 0x000fc800078e30ffULL, 0x00000060702b7812ULL, 0x000fce00078ef82dULL,
0x0000098000008947ULL, 0x000fea0003800000ULL, 0x0000000472347824ULL, 0x040fe400078e00ffULL,
0x00000001722e7824ULL, 0x040fe400078e022bULL, 0x00000200ff377424ULL, 0x000fe200078e00ffULL,
0x014a0000342a7984ULL, 0x000e620000000800ULL, 0x0000000172357824ULL, 0x040fe400078e0203ULL,
0x0000002072367824ULL, 0x000fca00078e00ffULL, 0xffffffe036357812ULL, 0x000fe400078ee235ULL,
0x0000000172367810ULL, 0x000fe40007ffe0ffULL, 0x0001000035357811ULL, 0x000fe400078e20ffULL,
0x00000005363b7819ULL, 0x040fe200000006ffULL, 0x0000000136387824ULL, 0x000fe200078e0203ULL,
0x000000022a2f7819ULL, 0x002fe400000006ffULL, 0x0000002d752a7217ULL, 0x000fc60007800000ULL,
0x014ac0002f2c7984ULL, 0x000e640000000800ULL, 0x000000012a2d7824ULL, 0x000fe400078e0a2dULL,
0x00000010032a7824ULL, 0x000fc600078e00ffULL, 0x0000002d722d7217ULL, 0x000fe40007800000ULL,
0x000001f02a397812ULL, 0x000fe400078ec0ffULL, 0x0000002d72307210ULL, 0x000fc80007ffe1ffULL,
0x000000ff3000720cULL, 0x000fe20003f03070ULL, 0x0000002c212c7224ULL, 0x002fc800078e022eULL,
0x00005e002c2c7625ULL, 0x000fca00078e0037ULL, 0x000000392c2e7210ULL, 0x000fe20007f3e0ffULL,
0x00000001362c7824ULL, 0x000fe200078e022bULL, 0x0000000272367810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff2f7224ULL, 0x000fca00008e062dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002e357faeULL, 0x0003e2000c101c46ULL, 0x000000013000780cULL, 0x000fc60003f03070ULL,
0x014a0400342a7984ULL, 0x000ea20000000800ULL, 0xffffffe03b357812ULL, 0x002fe200078ee238ULL,
0x0000000136387824ULL, 0x040fe400078e0203ULL, 0x00000020363b7824ULL, 0x000fe200078e00ffULL,
0x0001000035357811ULL, 0x000fe200078e20ffULL, 0x000000042a2a7824ULL, 0x004fcc00078e00ffULL,
0x014ac0002a2a7984ULL, 0x000e640000000800ULL, 0x0000002a212c7224ULL, 0x002fc800078e022cULL,
0x00005e002c2c7625ULL, 0x000fca00078e0037ULL, 0x000000392c2e7210ULL, 0x000fe20007f3e0ffULL,
0x00000001362c7824ULL, 0x000fe200078e022bULL, 0x0000000372367810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff2f7224ULL, 0x000fca00008e062dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002e357faeULL, 0x0003e2000c101c46ULL, 0x000000023000780cULL, 0x000fc60003f03070ULL,
0x014a0800342a7984ULL, 0x000ea20000000800ULL, 0xffffffe03b357812ULL, 0x002fe200078ee238ULL,
0x0000000136387824ULL, 0x040fe400078e0203ULL, 0x00000020363b7824ULL, 0x000fe200078e00ffULL,
0x0001000035357811ULL, 0x000fe200078e20ffULL, 0x000000042a2a7824ULL, 0x004fcc00078e00ffULL,
0x014ac0002a2a7984ULL, 0x000e640000000800ULL, 0x0000002a212c7224ULL, 0x002fc800078e022cULL,
0x00005e002c2c7625ULL, 0x000fca00078e0037ULL, 0x000000392c2e7210ULL, 0x000fe20007f3e0ffULL,
0x00000001362c7824ULL, 0x000fe200078e022bULL, 0x0000000472367810ULL, 0x000fe40007ffe0ffULL,
0x0000002dff2f7210ULL, 0x000fca0000ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002e357faeULL, 0x0003e2000c101c46ULL, 0x000000033000780cULL, 0x000fc60003f03070ULL,
0x014a0c00342a7984ULL, 0x000ea20000000800ULL, 0xffffffe03b357812ULL, 0x002fe200078ee238ULL,
0x0000000136387824ULL, 0x040fe400078e0203ULL, 0x00000020363b7824ULL, 0x000fe200078e00ffULL,
0x0001000035357811ULL, 0x000fe200078e20ffULL, 0x000000042a2a7824ULL, 0x004fcc00078e00ffULL,
0x014ac0002a2a7984ULL, 0x000e640000000800ULL, 0x0000002a212c7224ULL, 0x002fc800078e022cULL,
0x00005e002c2c7625ULL, 0x000fca00078e0037ULL, 0x000000392c2e7210ULL, 0x000fe20007f3e0ffULL,
0x00000001362c7824ULL, 0x000fe200078e022bULL, 0x0000000572367810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff2f7224ULL, 0x000fca00008e062dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002e357faeULL, 0x0003e2000c101c46ULL, 0x000000043000780cULL, 0x000fc60003f03070ULL,
0x014a1000342a7984ULL, 0x000ea20000000800ULL, 0xffffffe03b357812ULL, 0x002fe200078ee238ULL,
0x0000000136387824ULL, 0x040fe400078e0203ULL, 0x00000020363b7824ULL, 0x000fe200078e00ffULL,
0x0001000035357811ULL, 0x000fe400078e20ffULL, 0x000000022a2a7819ULL, 0x004fcc00000006ffULL,
0x014ac0002a2a7984ULL, 0x000e640000000800ULL, 0x0000002a212c7224ULL, 0x002fc800078e022cULL,
0x00005e002c2c7625ULL, 0x000fca00078e0037ULL, 0x000000392c2e7210ULL, 0x000fe40007f3e0ffULL,
0x0000002b362c7210ULL, 0x000fe40007ffe0ffULL, 0x0000000672367810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2f7224ULL, 0x000fca00008e062dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002e357faeULL, 0x0003e2000c101c46ULL, 0x000000053000780cULL, 0x000fc60003f03070ULL,
0x014a1400342a7984ULL, 0x000ea20000000800ULL, 0xffffffe03b357812ULL, 0x002fe200078ee238ULL,
0x00000020363b7824ULL, 0x040fe200078e00ffULL, 0x0000000336387210ULL, 0x000fe40007ffe0ffULL,
0x0001000035357811ULL, 0x000fe200078e20ffULL, 0x000000042a2a7824ULL, 0x004fcc00078e00ffULL,
0x014ac0002a2a7984ULL, 0x000e640000000800ULL, 0x0000002a212c7224ULL, 0x002fc800078e022cULL,
0x00005e002c2c7625ULL, 0x000fca00078e0037ULL, 0x000000392c2e7210ULL, 0x000fe20007f3e0ffULL,
0x00000001362c7824ULL, 0x000fe200078e022bULL, 0x0000000772367810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff2f7224ULL, 0x000fe400008e062dULL, 0x00000001362b7824ULL, 0x000fc600078e022bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002e357faeULL, 0x0003e2000c101c46ULL,
0x000000063000780cULL, 0x000fc60003f03070ULL, 0x014a1800342a7984ULL, 0x000ea20000000800ULL,
0xffffffe03b2f7812ULL, 0x002fe200078ee238ULL, 0x0000000136357824ULL, 0x040fe200078e0203ULL,
0x0000000536367819ULL, 0x000fe400000006ffULL, 0x000100002f2f7811ULL, 0x000fe200078e20ffULL,
0x000000042a2a7824ULL, 0x004fcc00078e00ffULL, 0x014ac0002a2a7984ULL, 0x000e640000000800ULL,
0x0000002a212c7224ULL, 0x002fc800078e022cULL, 0x00005e002c2c7625ULL, 0x000fca00078e0037ULL,
0x000000392c2c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff2d7224ULL, 0x000fca00008e062dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c2f7faeULL, 0x0003e2000c101c46ULL,
0x000000073000780cULL, 0x000fc60003f03070ULL, 0x014a1c00342a7984ULL, 0x000ea20000000800ULL,
0xffffffe0362d7812ULL, 0x002fc800078ee235ULL, 0x000100002d2d7811ULL, 0x000fe200078e20ffULL,
0x000000042a2e7824ULL, 0x004fca00078e00ffULL, 0x014ac0002e2a7984ULL, 0x000e640000000800ULL,
0x0000002a212a7224ULL, 0x002fc800078e022bULL, 0x00005e002a2a7625ULL, 0x000fca00078e0037ULL,
0x000000392a2a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff2b7224ULL, 0x000fca00008e062bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a2d7faeULL, 0x0003e2000c101c46ULL,
0x0000083000007947ULL, 0x000fea0003800000ULL, 0x0000007203307211ULL, 0x040fe200078fd8ffULL,
0x00000010032d7824ULL, 0x000fe400078e00ffULL, 0x00000200ff397424ULL, 0x000fe200078e00ffULL,
0x0000000530347819ULL, 0x040fe200000006ffULL, 0x014a0000302a7984ULL, 0x000e620000004800ULL,
0x00000001302c7824ULL, 0x040fe200078e022bULL, 0x000001f02d3b7812ULL, 0x000fe200078ec0ffULL,
0x00000001302f7824ULL, 0x000fca00078e0203ULL, 0xffffffe034377812ULL, 0x000fe400078ee22fULL,
0x0000000130347810ULL, 0x000fe40007ffe0ffULL, 0x0001000037377811ULL, 0x000fc600078e20ffULL,
0x0000000134357824ULL, 0x040fe400078e0203ULL, 0x0000002034367824ULL, 0x000fe200078e00ffULL,
0x014ac0002a2a7984ULL, 0x002e640000004800ULL, 0x0000002a212c7224ULL, 0x002fc800078e022cULL,
0x00005e002c2c7625ULL, 0x000fca00078e0039ULL, 0x0000003b2c2e7210ULL, 0x000fe20007f1e0ffULL,
0x00000001342c7824ULL, 0x000fc800078e022bULL, 0x000000ffff2f7224ULL, 0x000fca00000e062dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002e377faeULL, 0x0003e8000b901c46ULL,
0x014a0400302a7984ULL, 0x000ea20000004800ULL, 0x00000002302e7810ULL, 0x002fca0007ffe0ffULL,
0x000000012e2f7824ULL, 0x000fe200078e0203ULL, 0x014ac0002a2a7984ULL, 0x004e640000004800ULL,
0x0000002a212c7224ULL, 0x002fc800078e022cULL, 0x00005e002c2c7625ULL, 0x000fca00078e0039ULL,
0x0000003b2c347210ULL, 0x000fe40007f1e0ffULL, 0xffffffe0362c7812ULL, 0x000fe200078ee235ULL,
0x000000202e367824ULL, 0x000fe200078e00ffULL, 0x0000002dff357210ULL, 0x000fe400007fe4ffULL,
0x000100002c377811ULL, 0x000fe200078e20ffULL, 0x000000012e2c7824ULL, 0x000fc800078e022bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034377faeULL, 0x0003e8000b901c46ULL,
0x014a0800302a7984ULL, 0x000ea20000004800ULL, 0x0000000330347810ULL, 0x002fca0007ffe0ffULL,
0x0000000134357824ULL, 0x000fe200078e0203ULL, 0x014ac0002a2a7984ULL, 0x004e640000004800ULL,
0x0000002a212c7224ULL, 0x002fc800078e022cULL, 0x00005e002c2c7625ULL, 0x000fca00078e0039ULL,
0x0000003b2c2e7210ULL, 0x000fe40007f1e0ffULL, 0xffffffe0362c7812ULL, 0x000fe200078ee22fULL,
0x0000002034367824ULL, 0x000fe400078e00ffULL, 0x000000ffff2f7224ULL, 0x000fe200000e062dULL,
0x000100002c377811ULL, 0x000fe400078e20ffULL, 0x0000002b342c7210ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002e377faeULL, 0x0003e8000b901c46ULL,
0x014a0c00302a7984ULL, 0x000ea20000004800ULL, 0x00000004302e7810ULL, 0x002fc80007ffe0ffULL,
0x000000032e2f7210ULL, 0x000fe20007ffe0ffULL, 0x014ac0002a2a7984ULL, 0x004e640000004800ULL,
0x0000002a212c7224ULL, 0x002fc800078e022cULL, 0x00005e002c2c7625ULL, 0x000fca00078e0039ULL,
0x0000003b2c347210ULL, 0x000fe40007f1e0ffULL, 0xffffffe0362c7812ULL, 0x000fe200078ee235ULL,
0x000000202e367824ULL, 0x000fe400078e00ffULL, 0x000000ffff357224ULL, 0x000fe200000e062dULL,
0x000100002c377811ULL, 0x000fe200078e20ffULL, 0x000000012e2c7824ULL, 0x000fc800078e022bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034377faeULL, 0x0003e8000b901c46ULL,
0x014a1000302a7984ULL, 0x000ea20000004800ULL, 0x0000000530347810ULL, 0x002fca0007ffe0ffULL,
0x0000000134357824ULL, 0x000fe200078e0203ULL, 0x014ac0002a2a7984ULL, 0x004e640000004800ULL,
0x0000002a212c7224ULL, 0x002fc800078e022cULL, 0x00005e002c2c7625ULL, 0x000fca00078e0039ULL,
0x0000003b2c2e7210ULL, 0x000fe40007f1e0ffULL, 0xffffffe0362c7812ULL, 0x000fe400078ee22fULL,
0x0000000534367819ULL, 0x000fe200000006ffULL, 0x000000ffff2f7224ULL, 0x000fe200000e062dULL,
0x000100002c377811ULL, 0x000fe200078e20ffULL, 0x00000001342c7824ULL, 0x000fc800078e022bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002e377faeULL, 0x0003e8000b901c46ULL,
0x014a1400302a7984ULL, 0x000ea20000004800ULL, 0x00000006302e7810ULL, 0x002fca0007ffe0ffULL,
0x000000202e377824ULL, 0x000fe200078e00ffULL, 0x014ac0002a2a7984ULL, 0x004e640000004800ULL,
0x0000002a212c7224ULL, 0x002fc800078e022cULL, 0x00005e002c2c7625ULL, 0x000fca00078e0039ULL,
0x0000003b2c347210ULL, 0x000fe40007f1e0ffULL, 0xffffffe0362c7812ULL, 0x000fe200078ee235ULL,
0x000000012e367824ULL, 0x000fe400078e0203ULL, 0x000000ffff357224ULL, 0x000fe200000e062dULL,
0x000100002c2f7811ULL, 0x000fe200078e20ffULL, 0x000000012e2c7824ULL, 0x000fe200078e022bULL,
0xffffffe037367812ULL, 0x000fc600078ee236ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000342f7faeULL, 0x0003e8000b901c46ULL, 0x014a1800302a7984ULL, 0x000ea20000004800ULL,
0x00010000362f7811ULL, 0x002fe400078e20ffULL, 0x0000000730347810ULL, 0x000fca0007ffe0ffULL,
0x00000001342b7824ULL, 0x040fe400078e022bULL, 0x0000000134357824ULL, 0x040fe400078e0203ULL,
0x0000002034347824ULL, 0x000fca00078e00ffULL, 0xffffffe034357812ULL, 0x000fe200078ee235ULL,
0x014ac0002a2a7984ULL, 0x004e640000004800ULL, 0x0000002a212c7224ULL, 0x002fc800078e022cULL,
0x00005e002c2c7625ULL, 0x000fca00078e0039ULL, 0x0000003b2c2c7210ULL, 0x000fc80007f1e0ffULL,
0x0000002dff2d7210ULL, 0x000fca00007fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c2f7faeULL, 0x0003e8000b901c46ULL, 0x014a1c00302e7984ULL, 0x000ea20000004800ULL,
0x00010000352d7811ULL, 0x002fc600078e20ffULL, 0x014ac0002e2e7984ULL, 0x004e640000004800ULL,
0x0000002e212b7224ULL, 0x002fc800078e022bULL, 0x00005e002b2a7625ULL, 0x000fca00078e0039ULL,
0x0000003b2a2a7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff2b7224ULL, 0x000fca00000e062bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a2d7faeULL, 0x0003e6000b901c46ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x014b8800ff2a7f8cULL, 0x002e64000c80043fULL, 0x0000002b00357202ULL, 0x002fc40000000f00ULL,
0x00000000002a7805ULL, 0x000fca0000015200ULL, 0x014b8c00ff2c7984ULL, 0x000e640000000800ULL,
0x800000002cff7812ULL, 0x002fe40007804835ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff2e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002c7805ULL, 0x000fcc0000015200ULL,
0x0000002c2a2f7210ULL, 0x000fca0007f1e1ffULL, 0x000000012d2d7824ULL, 0x000fe200000e0e2bULL,
0x003d09002f00780cULL, 0x000fc80003f06070ULL, 0x000000ff2d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402f00780cULL, 0x000fc80003f06070ULL,
0x000000ff2d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff2c7819ULL, 0x000fc8000001142dULL, 0x0000002f2c2c7211ULL, 0x000fca00078110ffULL,
0x000000ffff2d7224ULL, 0x000fca00000e062dULL, 0x000000022c2c7819ULL, 0x000fc8000000122dULL,
0x0000002c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012e2e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x014b8c00ff2c7984ULL, 0x000e640000000800ULL, 0x800000002cff7812ULL, 0x002fe40007804835ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000227300720cULL, 0x0c0fe20003f24070ULL,
0x0000027000017945ULL, 0x000fe20003800000ULL, 0x00000001282a7810ULL, 0x000fe40007ffe0ffULL,
0x000000227300720cULL, 0x000fe40003f04070ULL, 0x000000032a2b7812ULL, 0x000fc400078ec0ffULL,
0x000000032800780cULL, 0x000fca0004705270ULL, 0x00000002ff2a9819ULL, 0x000fca000001162aULL,
0x00000001292a7824ULL, 0x000fe200078e022aULL, 0x0000000123297812ULL, 0x000fe400078ec0ffULL,
0x0000000378237211ULL, 0x000fe400078e28ffULL, 0x000000012900780cULL, 0x000fe40000705470ULL,
0x00000002ff2d7819ULL, 0x000fe2000001162aULL, 0x000000402a2a7824ULL, 0x000fe200078e00ffULL,
0x0000001f2300780cULL, 0x000fc60003f84070ULL, 0x000003002d2d7a24ULL, 0x000fe200078e0222ULL,
0x000000c02a2a7812ULL, 0x000fca00078ec0ffULL, 0x000001002d2d7824ULL, 0x000fe200078e022aULL,
0x000000ff2b2a7207ULL, 0x000fe20004800000ULL, 0x0000015000000947ULL, 0x000fea0003800000ULL,
0x0000002078297824ULL, 0x000fe200078e0203ULL, 0x0000000171287812ULL, 0x000fe200078ec0ffULL,
0x00000300ff227624ULL, 0x000fc600078e00ffULL, 0x000000032900780cULL, 0x000fe40003f24070ULL,
0x000000012800780cULL, 0x000fe40003f05070ULL, 0xffffffff22227811ULL, 0x000fc800078e08ffULL,
0x0000000122227807ULL, 0x000fc80004000000ULL, 0x0000002271717210ULL, 0x000fe20007ffe0ffULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x0000000400227824ULL, 0x000fe200078e0229ULL,
0x00006400712b7a10ULL, 0x040fe20007ffe0ffULL, 0x00000004ff2f7424ULL, 0x000fe200078e00ffULL,
0x000000767100720cULL, 0x000fe20003f06070ULL, 0x0000000222227824ULL, 0x000fc800078e00ffULL,
0x0000640022227a24ULL, 0x000fe200078e022bULL, 0x00014ac0292b7811ULL, 0x000fc600078e10ffULL,
0x0000600022287625ULL, 0x000fca00078e002fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000282b7faeULL, 0x0003e4000c121846ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000e000017945ULL, 0x000fe20003800000ULL, 0x000000c000004947ULL, 0x000fea0003800000ULL,
0x0000000177227824ULL, 0x000fe200078e022aULL, 0x0000002d23287210ULL, 0x042fe20007ffe0ffULL,
0x00000004ff297424ULL, 0x000fe200078e00ffULL, 0x00014a00232b7811ULL, 0x000fe200078e10ffULL,
0x0000680022227a24ULL, 0x000fe200078e022dULL, 0x000000752800720cULL, 0x000fc60003f06070ULL,
0x0000000123227824ULL, 0x000fc800078e0222ULL, 0x0000660022287625ULL, 0x000fcc00078e0029ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000282b7faeULL, 0x0003e4000c121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x014b8000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b8000ff287f8cULL, 0x002e62000c80043fULL,
0x000000ff8800720cULL, 0x000fe20003f05270ULL, 0x0000081000017945ULL, 0x000fe20003800000ULL,
0xffffffffff227424ULL, 0x000fe400078e00ffULL, 0x000000ffff897224ULL, 0x002fd200078e0029ULL,
0x000007d000000947ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x014ad80072287f8cULL, 0x000e64000c80043fULL, 0x00000029002f7202ULL, 0x002fc40000000f00ULL,
0x0000000000287805ULL, 0x000fca0000015200ULL, 0x014adc0072247984ULL, 0x000e640000000800ULL,
0x8000000024ff7812ULL, 0x002fe4000780482fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000027945ULL, 0x000fe20003800000ULL, 0x000000ffff2c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000037945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a282d7210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2b7824ULL, 0x000fe200000e0e29ULL,
0x003d09002d00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402d00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff247819ULL, 0x000fc8000001142bULL, 0x0000002d24247211ULL, 0x000fca00078110ffULL,
0x000000ffff2b7224ULL, 0x000fca00000e062bULL, 0x0000000224247819ULL, 0x000fc8000000122bULL,
0x000000240000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012c2c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000037941ULL, 0x000fea0003800000ULL,
0x014adc0072247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fe4000780482fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000001003247824ULL, 0x000fe200078e00ffULL,
0x00000001ff287819ULL, 0x000fc80000011603ULL, 0x0000007024247812ULL, 0x000fe400078ec0ffULL,
0x0000000c28297812ULL, 0x000fc800078ec0ffULL, 0x0000002924297210ULL, 0x000fca0007ffe0ffULL,
0x0140000029287984ULL, 0x000e680000000800ULL, 0x01420000292a7984ULL, 0x0004e20000000800ULL,
0x0000006f2800720bULL, 0x002fe20003f1d000ULL, 0x00020d727f007947ULL, 0x000fd8000b800000ULL,
0x0000000000247806ULL, 0x004fc800000e0100ULL, 0x0000ffff242e7812ULL, 0x000fe2000780c0ffULL,
0x0000045000027945ULL, 0x000fe20003800000ULL, 0x00000001ff247424ULL, 0x000fe400078e00ffULL,
0x000000ffff2c7224ULL, 0x000fd200078e006fULL, 0x0000041000008947ULL, 0x000fea0003800000ULL,
0x000000ff7800720cULL, 0x000fe40003f05270ULL, 0x0000006f2800720bULL, 0x000fe20003f34000ULL,
0x00020d327f007947ULL, 0x000fd8000b800000ULL, 0x00000000002b7806ULL, 0x000fc400008e0100ULL,
0x000000286f2c7209ULL, 0x000fe20007810000ULL, 0x0000035000037945ULL, 0x000fe20003800000ULL,
0x000099102b2d7816ULL, 0x000fc600000000ffULL, 0x0144002c29008388ULL, 0x0003e20000000800ULL,
0x000000ff2d00720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x8000002c6f297221ULL, 0x002fe20000010000ULL, 0x000000ff2bff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000047945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b29297820ULL, 0x000fc80000410000ULL,
0x0000002900307308ULL, 0x000e640000000800ULL, 0x000000301e1e7220ULL, 0x002fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff297819ULL, 0x000fe20000011603ULL,
0x00020c827f007947ULL, 0x000fea000b800000ULL, 0x00001f2930297589ULL, 0x0002a400000e0000ULL,
0x000000291d1d7220ULL, 0x084fe20000410000ULL, 0x000000291c1c7220ULL, 0x080fe20000410000ULL,
0x0000002919197220ULL, 0x080fe20000410000ULL, 0x0000002918187220ULL, 0x080fe20000410000ULL,
0x0000002915157220ULL, 0x080fe20000410000ULL, 0x0000002914147220ULL, 0x080fe20000410000ULL,
0x0000002911117220ULL, 0x080fe20000410000ULL, 0x0000002910107220ULL, 0x080fe20000410000ULL,
0x000000290d0d7220ULL, 0x080fe20000410000ULL, 0x000000290c0c7220ULL, 0x080fe20000410000ULL,
0x0000002909097220ULL, 0x080fe20000410000ULL, 0x0000002908087220ULL, 0x080fe20000410000ULL,
0x0000002905057220ULL, 0x080fe20000410000ULL, 0x0000002904047220ULL, 0x080fe20000410000ULL,
0x0000002933337220ULL, 0x080fe20000410000ULL, 0x000000296c6c7220ULL, 0x000fc40000410000ULL,
0x0000000000047941ULL, 0x000fea0003800000ULL, 0x0000ff002bff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000803297811ULL, 0x000fe200078ff0ffULL,
0x00020b827f007947ULL, 0x000fea000b800000ULL, 0x00001f2930297589ULL, 0x00046400000e0000ULL,
0x000000291b1b7220ULL, 0x082fe20000410000ULL, 0x000000291a1a7220ULL, 0x080fe20000410000ULL,
0x0000002917177220ULL, 0x080fe20000410000ULL, 0x0000002916167220ULL, 0x080fe20000410000ULL,
0x0000002913137220ULL, 0x080fe20000410000ULL, 0x0000002912127220ULL, 0x080fe20000410000ULL,
0x000000290f0f7220ULL, 0x080fe20000410000ULL, 0x000000290e0e7220ULL, 0x080fe20000410000ULL,
0x000000290b0b7220ULL, 0x080fe20000410000ULL, 0x000000290a0a7220ULL, 0x080fe20000410000ULL,
0x0000002907077220ULL, 0x080fe20000410000ULL, 0x0000002906067220ULL, 0x080fe20000410000ULL,
0x0000002931317220ULL, 0x080fe20000410000ULL, 0x0000002932327220ULL, 0x080fe20000410000ULL,
0x000000296d6d7220ULL, 0x080fe20000410000ULL, 0x000000296e6e7220ULL, 0x000fc40000410000ULL,
0x0000000000037941ULL, 0x002fea0003800000ULL, 0x0000ffff2eff7812ULL, 0x000fda000780602bULL,
0x8000002c28280221ULL, 0x000fe20000010000ULL, 0x00007610ff240816ULL, 0x000fc60000000024ULL,
0x3fb8aa3b28280820ULL, 0x000fc80000410000ULL, 0x0000002800250308ULL, 0x000e640000000800ULL,
0x000000252a2a0220ULL, 0x00afcc0000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000001e2a1e7221ULL, 0x008fe20000010000ULL, 0x000000ffff6f7224ULL, 0x000fc400078e002cULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ff24ff7812ULL, 0x000fe2000782c0ffULL,
0x0000014000017945ULL, 0x000fd80003800000ULL, 0x0000012000001947ULL, 0x000fea0003800000ULL,
0x00000025ff26723eULL, 0x000fe400000010ffULL, 0x00000002ff287819ULL, 0x000fe40000011603ULL,
0x0000541026297816ULL, 0x000fe20000000026ULL, 0x000209b27f007947ULL, 0x000fea000b800000ULL,
0x00001f2829277589ULL, 0x0002a400000e0000ULL, 0x0000000828267810ULL, 0x000fe20007ffe0ffULL,
0x000209e27f007947ULL, 0x000fea000b800000ULL, 0x00001f2629267589ULL, 0x0002e400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000010283b7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0029ULL, 0x00004bb000347802ULL, 0x000fc40000000f00ULL,
0x0002184000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000018283b7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff3a7224ULL, 0x004fe200078e0029ULL,
0x00004c0000347802ULL, 0x000fc40000000f00ULL, 0x000217f000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000703827812ULL, 0x000fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000002722c7810ULL, 0x000fe20007ffe0ffULL,
0x000006e000017945ULL, 0x000fe20003800000ULL, 0x0000000882827812ULL, 0x000fc400078ef803ULL,
0x0000000803847812ULL, 0x040fe400078ec0ffULL, 0x0000002c03857211ULL, 0x040fe200078fe0ffULL,
0x00000008822f7824ULL, 0x000fe200078e00ffULL, 0x00000006722c7810ULL, 0x000fe40007ffe0ffULL,
0x0000008203817211ULL, 0x000fe400078fe0ffULL, 0x0000000382287819ULL, 0x002fe400000006ffULL,
0x00000004722a7810ULL, 0x000fc40007ffe0ffULL, 0x0000007203837211ULL, 0x040fe400078fe0ffULL,
0x0000000784847812ULL, 0x000fe400078ef803ULL, 0x0000002c038b7211ULL, 0x040fe400078fe0ffULL,
0xfffffff828287812ULL, 0x000fe200078ee281ULL, 0x0000000184297824ULL, 0x040fe200078e0283ULL,
0x0000002a03877211ULL, 0x000fe200078fe0ffULL, 0x00000020842e7824ULL, 0x000fe200078e00ffULL,
0x0000a00028347811ULL, 0x000fe200078e20ffULL, 0x00000001842a7824ULL, 0x040fe200078e0285ULL,
0x00000087842b7210ULL, 0x040fe20007ffe0ffULL, 0x00000020842d7824ULL, 0x000fe200078e00ffULL,
0xffffffe02e297812ULL, 0x000fe200078ee229ULL, 0x00000001842c7824ULL, 0x000fe200078e028bULL,
0xffffffe02e2b7812ULL, 0x000fe200078ee22bULL, 0x000000003434783bULL, 0x000e620000000200ULL,
0xffffffe02d2a7812ULL, 0x000fc400078ee22aULL, 0xffffffe02d2d7812ULL, 0x000fe400078ee22cULL,
0x0000c00029297811ULL, 0x000fe400078e20ffULL, 0x0000c0002a2a7811ULL, 0x000fe400078e20ffULL,
0x0000c0002b2b7811ULL, 0x000fe200078e20ffULL, 0x000000002950783bULL, 0x000f220000004200ULL,
0x0000c0002d2d7811ULL, 0x000fe400078e20ffULL, 0x00000002812e7810ULL, 0x000fe20007ffe0ffULL,
0x000000002a5c783bULL, 0x000ee20000004200ULL, 0x0000001084307812ULL, 0x004fc400078efcffULL,
0xfffffff82f2c7812ULL, 0x000fe200078ee22eULL, 0x000000002b64783bULL, 0x000ea20000004200ULL,
0x00000030857f7210ULL, 0x000fe20007ffe0ffULL, 0x0000000183807824ULL, 0x100fe200078e0230ULL,
0x0000a0002c387811ULL, 0x000fe200078e20ffULL, 0x000000002d3c783bULL, 0x000fe20000004200ULL,
0x0000002030397824ULL, 0x040fe200078e00ffULL, 0x0000000530447819ULL, 0x040fe200000006ffULL,
0x00000020302e7824ULL, 0x040fe200078e00ffULL, 0x00000002ff7c7819ULL, 0x000fe20000011603ULL,
0x00000001877e7824ULL, 0x000fe200078e0230ULL, 0xffffffe039807812ULL, 0x000fe200078ee280ULL,
0x00000020302f7824ULL, 0x000fe200078e00ffULL, 0xffffffe02e7f7812ULL, 0x000fe200078ee27fULL,
0x000000018b7d7824ULL, 0x000fe200078e0230ULL, 0x000000003838783bULL, 0x000ea20000000200ULL,
0x0000c000802e7811ULL, 0x000fc400078e20ffULL, 0xffffffe02f7e7812ULL, 0x000fe400078ee27eULL,
0xffffffe0447d7812ULL, 0x000fe200078ee27dULL, 0x000000002e40783bULL, 0x000ea20000004200ULL,
0x0000c0007f2f7811ULL, 0x000fe200078e20ffULL, 0x0000002734349231ULL, 0x082fe200003400ffULL,
0x0000c0007e307811ULL, 0x000fe200078e20ffULL, 0x0000002736369231ULL, 0x000fe200003400ffULL,
0x0000c0007d797811ULL, 0x000fe200078e20ffULL, 0x000000002f44783bULL, 0x000e620000004200ULL,
0x0000002635359231ULL, 0x088fe200003400ffULL, 0x000000887c00720cULL, 0x000fe20003f46070ULL,
0x0000002637379231ULL, 0x000fe200003400ffULL, 0x00000000304c783bULL, 0x000ee20000004200ULL,
0x0000007a7300720cULL, 0x000fc40003fc3070ULL, 0x000000087c7b7810ULL, 0x000fe20007ffe0ffULL,
0x000000007954783bULL, 0x000e620000004200ULL, 0x0000007a7300720cULL, 0x000fe20003f03070ULL,
0x000000503448723cULL, 0x010f6200000418ffULL, 0x000000887b00720cULL, 0x000fce0003f66070ULL,
0x0000005c3458723cULL, 0x040ff000000418ffULL, 0x000000643460723cULL, 0x004fe200000418ffULL,
0x0000002738389231ULL, 0x080fe400003400ffULL, 0x000000273a3a9231ULL, 0x000fc400003400ffULL,
0x0000002639399231ULL, 0x000fc600003400ffULL, 0x000000523450723cULL, 0x000f6200000418ffULL,
0x000000263b3b9231ULL, 0x000fce00003400ffULL, 0x0000005e345c723cULL, 0x040f7000000418ffULL,
0x000000663464723cULL, 0x040f7000000418ffULL, 0x0000003c3468723cULL, 0x040b6e00000418ffULL,
0x00000001883c7810ULL, 0x020fe20007ffe0ffULL, 0x0000003e3434723cULL, 0x000f6600000418ffULL,
0x0000003c7c00720cULL, 0x000fc40005746470ULL, 0x0000003c7b00720cULL, 0x000fc60005f66470ULL,
0x000000403848723cULL, 0x040b700000041848ULL, 0x000000423850723cULL, 0x040b700000041850ULL,
0x000000443858723cULL, 0x042b700000041858ULL, 0x00000046385c723cULL, 0x040b70000004185cULL,
0x0000004c3860723cULL, 0x048b700000041860ULL, 0x0000004e3864723cULL, 0x040b700000041864ULL,
0x000000543868723cULL, 0x040b700000041868ULL, 0x000000563834723cULL, 0x020b620000041834ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x000000481d1d7221ULL, 0x000fe20000010000ULL, 0x000000491c1c7221ULL, 0x000fe20000010000ULL,
0x0000005019197221ULL, 0x000fe20000010000ULL, 0x0000005118187221ULL, 0x000fe20000010000ULL,
0x0000005815157221ULL, 0x000fe20000010000ULL, 0x0000005914147221ULL, 0x000fe20000010000ULL,
0x0000005c11117221ULL, 0x000fe20000010000ULL, 0x0000005d10107221ULL, 0x000fe20000010000ULL,
0x000000600d0d7221ULL, 0x000fe20000010000ULL, 0x000000610c0c7221ULL, 0x000fe20000010000ULL,
0x0000006409097221ULL, 0x000fe20000010000ULL, 0x0000006508087221ULL, 0x000fe20000010000ULL,
0x0000006805057221ULL, 0x000fe20000010000ULL, 0x0000006904047221ULL, 0x000fe20000010000ULL,
0x0000003433337221ULL, 0x020fe20000010000ULL, 0x000000356c6c7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000003947ULL, 0x000fea0000000000ULL, 0x0000004a1b1b7221ULL, 0x000fe20000010000ULL,
0x0000004b1a1a7221ULL, 0x000fe20000010000ULL, 0x0000005217177221ULL, 0x000fe20000010000ULL,
0x0000005316167221ULL, 0x000fe20000010000ULL, 0x0000005a13137221ULL, 0x000fe20000010000ULL,
0x0000005b12127221ULL, 0x000fe20000010000ULL, 0x0000005e0f0f7221ULL, 0x000fe20000010000ULL,
0x0000005f0e0e7221ULL, 0x000fe20000010000ULL, 0x000000620b0b7221ULL, 0x000fe20000010000ULL,
0x000000630a0a7221ULL, 0x000fe20000010000ULL, 0x0000006607077221ULL, 0x000fe20000010000ULL,
0x0000006706067221ULL, 0x000fe20000010000ULL, 0x0000006a31317221ULL, 0x000fe20000010000ULL,
0x0000006b32327221ULL, 0x000fe20000010000ULL, 0x000000366d6d7221ULL, 0x020fe20000010000ULL,
0x000000376e6e7221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b8800ff347f8cULL, 0x020e62000c80043fULL,
0x00000002ff377819ULL, 0x000fe2000001163cULL, 0x000000ffff3e7224ULL, 0x000fe200078e00ffULL,
0x0000007a7300720cULL, 0x000fc40003f03070ULL, 0x000000373c377207ULL, 0x040fe40002800000ULL,
0x000000033c3c7812ULL, 0x000fe400078ec0ffULL, 0x00000002ff397819ULL, 0x000fe40000011637ULL,
0x0000007a7300720cULL, 0x000fe40003fc3070ULL, 0x00000001ff407803ULL, 0x000fe40000000000ULL,
0x0000000337377812ULL, 0x000fe200078ec0ffULL, 0x000000ffff3f7224ULL, 0x002fe200078e0035ULL,
0x000000ff3c357207ULL, 0x000fe20006800000ULL, 0x0000030039347a24ULL, 0x000fc400078e027aULL,
0x0000000000387805ULL, 0x000fca0000015200ULL, 0x014b8400ff367984ULL, 0x000e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000036ff7812ULL, 0x002fe20007804889ULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc8000001143bULL,
0x0000003d36367211ULL, 0x000fca00078110ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e063bULL,
0x0000000236367819ULL, 0x000fc8000000123bULL, 0x000000360000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x014b8400ff367984ULL, 0x000e640000000800ULL,
0x8000000036ff7812ULL, 0x002fe40007804889ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fc40000015200ULL, 0x014b8c00ff367984ULL, 0x000e620000000800ULL,
0x000000ff003c7202ULL, 0x000fe20000000f00ULL, 0x0000000000007918ULL, 0x000fe60000000000ULL,
0x8000000036ff7812ULL, 0x002fe2000780483fULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL, 0x000000013b3b7824ULL, 0x000fe200000e0e39ULL,
0x003d09003d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff367819ULL, 0x000fc8000001143bULL, 0x0000003d36367211ULL, 0x000fca00078110ffULL,
0x000000ffff3b7224ULL, 0x000fca00000e063bULL, 0x0000000236367819ULL, 0x000fc8000000123bULL,
0x000000360000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x014b8c00ff367984ULL, 0x000e640000000800ULL, 0x8000000036ff7812ULL, 0x002fe4000780483fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000001343b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000434367824ULL, 0x000fe200078e0237ULL, 0x0000120000017945ULL, 0x000fe40003800000ULL,
0x000000743b00720cULL, 0x000fe20003f06070ULL, 0x00000040363f7824ULL, 0x000fca00078e00ffULL,
0x0000004070397812ULL, 0x000fce00078ef83fULL, 0x0000098000008947ULL, 0x000fea0003800000ULL,
0x0000000272417819ULL, 0x040fe200000006ffULL, 0x0000000172387824ULL, 0x040fe200078e0239ULL,
0x0000000172427810ULL, 0x000fe20007ffe0ffULL, 0x00000200ff437424ULL, 0x000fe400078e00ffULL,
0x014a000041367984ULL, 0x000e640000000800ULL, 0x00000004363e7824ULL, 0x002fca00078e00ffULL,
0x014ac0003e367984ULL, 0x000e640000000800ULL, 0x0000003621367224ULL, 0x002fe400078e0238ULL,
0x0000001003387824ULL, 0x000fe400078e00ffULL, 0x00005e00363a7625ULL, 0x000fe200078e0043ULL,
0x0000003f75367217ULL, 0x000fe40007800000ULL, 0x000001f038457812ULL, 0x000fc800078ec0ffULL,
0x000000453a3c7210ULL, 0x000fe20007f1e0ffULL, 0x00000001423a7824ULL, 0x000fc600078e0239ULL,
0x0000003bff3d7210ULL, 0x000fe200007fe4ffULL, 0x00000001363b7824ULL, 0x000fe400078e0a3fULL,
0x0000000172367824ULL, 0x040fe400078e0203ULL, 0x00000020723f7824ULL, 0x040fe200078e00ffULL,
0x0000003b723b7217ULL, 0x000fc80007800000ULL, 0xffffffe03f387812ULL, 0x000fe200078ee236ULL,
0x000000013b367824ULL, 0x000fc600078e0a72ULL, 0x0000c00038477811ULL, 0x000fe400078e20ffULL,
0x000000ff3600720cULL, 0x000fda0003f03070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c477faeULL, 0x0003e8000c101c46ULL, 0x014a040041387984ULL, 0x000ea40000000800ULL,
0x0000000238387819ULL, 0x004fcc00000006ffULL, 0x014ac00038387984ULL, 0x000ea40000000800ULL,
0x00000038213a7224ULL, 0x004fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0043ULL,
0x000000453a3e7210ULL, 0x000fe20007f1e0ffULL, 0x00000001423a7824ULL, 0x000fc800078e0203ULL,
0x000000ffff3f7224ULL, 0x000fe200000e063bULL, 0x000000013600780cULL, 0x000fe20003f03070ULL,
0x00000020423b7824ULL, 0x000fe200078e00ffULL, 0x0000000272427810ULL, 0x000fc80007ffe0ffULL,
0xffffffe03b3a7812ULL, 0x000fc800078ee23aULL, 0x0000c0003a477811ULL, 0x002fe200078e20ffULL,
0x00000001423a7824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e477faeULL, 0x0003e8000c101c46ULL, 0x014a080041387984ULL, 0x000ea40000000800ULL,
0x0000000238387819ULL, 0x004fcc00000006ffULL, 0x014ac00038387984ULL, 0x000ea40000000800ULL,
0x00000038213a7224ULL, 0x004fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0043ULL,
0x000000453a3c7210ULL, 0x000fe20007f1e0ffULL, 0x00000001423a7824ULL, 0x000fc800078e0203ULL,
0x000000ffff3d7224ULL, 0x000fe200000e063bULL, 0x000000023600780cULL, 0x000fe20003f03070ULL,
0x00000020423b7824ULL, 0x000fe200078e00ffULL, 0x0000000372427810ULL, 0x000fc80007ffe0ffULL,
0xffffffe03b3a7812ULL, 0x000fc800078ee23aULL, 0x0000c0003a477811ULL, 0x002fe200078e20ffULL,
0x00000001423a7824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c477faeULL, 0x0003e8000c101c46ULL, 0x014a0c0041387984ULL, 0x000ea40000000800ULL,
0x0000000238387819ULL, 0x004fcc00000006ffULL, 0x014ac00038387984ULL, 0x000ea40000000800ULL,
0x00000038213a7224ULL, 0x004fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0043ULL,
0x000000453a3e7210ULL, 0x000fe20007f1e0ffULL, 0x00000001423a7824ULL, 0x000fc800078e0203ULL,
0x000000ffff3f7224ULL, 0x000fe200000e063bULL, 0x000000033600780cULL, 0x000fe20003f03070ULL,
0x00000020423b7824ULL, 0x000fe200078e00ffULL, 0x0000000472427810ULL, 0x000fc80007ffe0ffULL,
0xffffffe03b3a7812ULL, 0x000fc800078ee23aULL, 0x0000c0003a477811ULL, 0x002fe200078e20ffULL,
0x00000001423a7824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e477faeULL, 0x0003e8000c101c46ULL, 0x014a100041387984ULL, 0x000ea40000000800ULL,
0x0000000238387819ULL, 0x004fcc00000006ffULL, 0x014ac00038387984ULL, 0x000ea40000000800ULL,
0x00000038213a7224ULL, 0x004fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0043ULL,
0x000000453a3c7210ULL, 0x000fe20007f1e0ffULL, 0x00000001423a7824ULL, 0x000fc800078e0203ULL,
0x000000ffff3d7224ULL, 0x000fe200000e063bULL, 0x000000043600780cULL, 0x000fe20003f03070ULL,
0x00000020423b7824ULL, 0x000fe200078e00ffULL, 0x0000000572427810ULL, 0x000fc80007ffe0ffULL,
0xffffffe03b3a7812ULL, 0x000fc800078ee23aULL, 0x0000c0003a477811ULL, 0x002fe200078e20ffULL,
0x00000001423a7824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c477faeULL, 0x0003e8000c101c46ULL, 0x014a140041387984ULL, 0x000ea20000000800ULL,
0x00000006723c7810ULL, 0x002fe40007ffe0ffULL, 0x0000000238387819ULL, 0x004fcc00000006ffULL,
0x014ac00038387984ULL, 0x000e640000000800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0043ULL, 0x000000453a3e7210ULL, 0x000fe20007f1e0ffULL,
0x00000001423a7824ULL, 0x000fc800078e0203ULL, 0x000000ffff3f7224ULL, 0x000fe200000e063bULL,
0x000000053600780cULL, 0x000fe20003f03070ULL, 0x00000020423b7824ULL, 0x000fe400078e00ffULL,
0x000000013c427824ULL, 0x000fc600078e0203ULL, 0xffffffe03b3a7812ULL, 0x000fc800078ee23aULL,
0x0000c0003a3d7811ULL, 0x000fe200078e20ffULL, 0x000000013c3a7824ULL, 0x000fc800078e0239ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e3d7faeULL, 0x0003e8000c101c46ULL,
0x014a180041387984ULL, 0x000ea20000000800ULL, 0x000000203c3d7824ULL, 0x002fe200078e00ffULL,
0x00000007723e7810ULL, 0x000fc80007ffe0ffULL, 0xffffffe03d427812ULL, 0x000fe200078ee242ULL,
0x000000013e397824ULL, 0x040fe400078e0239ULL, 0x000000013e3f7824ULL, 0x000fe200078e0203ULL,
0x0000c000423d7811ULL, 0x000fe200078e20ffULL, 0x000000203e3e7824ULL, 0x000fca00078e00ffULL,
0xffffffe03e3f7812ULL, 0x000fc800078ee23fULL, 0x0000c0003f3f7811ULL, 0x000fe400078e20ffULL,
0x0000000238387819ULL, 0x004fcc00000006ffULL, 0x014ac00038387984ULL, 0x000e640000000800ULL,
0x00000038213a7224ULL, 0x002fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0043ULL,
0x000000453a3a7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff3b7224ULL, 0x000fe200000e063bULL,
0x000000063600780cULL, 0x000fda0003f03070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a3d7faeULL, 0x0003e8000c101c46ULL, 0x014a1c0041387984ULL, 0x000ea40000000800ULL,
0x00000002383c7819ULL, 0x004fca00000006ffULL, 0x014ac0003c387984ULL, 0x000ea40000000800ULL,
0x0000003821387224ULL, 0x004fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e0043ULL,
0x0000004538387210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff397224ULL, 0x000fe200000e0639ULL,
0x000000073600780cULL, 0x000fda0003f03070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383f7faeULL, 0x0003e2000c101c46ULL, 0x0000083000007947ULL, 0x000fea0003800000ULL,
0x0000007203427211ULL, 0x040fe200078fd8ffULL, 0x00000200ff417424ULL, 0x000fe400078e00ffULL,
0x00000010033c7824ULL, 0x000fe200078e00ffULL, 0x0000003942387210ULL, 0x040fe20007ffe0ffULL,
0x014a000042367984ULL, 0x000e620000004800ULL, 0x0000000142447810ULL, 0x000fe40007ffe0ffULL,
0x000001f03c437812ULL, 0x000fe200078ec0ffULL, 0x014ac00036367984ULL, 0x002e640000004800ULL,
0x0000003621387224ULL, 0x002fc800078e0238ULL, 0x00005e00383a7625ULL, 0x000fc800078e0041ULL,
0x0000000142387824ULL, 0x000fe200078e0203ULL, 0x000000433a3c7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff3d7224ULL, 0x000fe200000e063bULL, 0x00000005423b7819ULL, 0x000fc800000006ffULL,
0xffffffe03b387812ULL, 0x000fc800078ee238ULL, 0x0000c00038457811ULL, 0x000fe200078e20ffULL,
0x0000000144387824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x014a040042367984ULL, 0x000ea80000004800ULL,
0x014ac00036367984ULL, 0x004ea40000004800ULL, 0x0000003621387224ULL, 0x004fc800078e0238ULL,
0x00005e00383a7625ULL, 0x000fc800078e0041ULL, 0x0000000144387824ULL, 0x000fe200078e0203ULL,
0x000000433a3e7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff3f7224ULL, 0x000fe400000e063bULL,
0x00000020443b7824ULL, 0x000fe200078e00ffULL, 0x0000000242447810ULL, 0x000fc80007ffe0ffULL,
0xffffffe03b387812ULL, 0x000fc800078ee238ULL, 0x0000c00038457811ULL, 0x002fe400078e20ffULL,
0x0000003944387210ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e457faeULL, 0x0003e8000b901c46ULL, 0x014a080042367984ULL, 0x000ea80000004800ULL,
0x014ac00036367984ULL, 0x004ea40000004800ULL, 0x0000003621387224ULL, 0x004fc800078e0238ULL,
0x00005e00383a7625ULL, 0x000fc800078e0041ULL, 0x0000000144387824ULL, 0x000fe200078e0203ULL,
0x000000433a3c7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff3d7224ULL, 0x000fe400000e063bULL,
0x00000020443b7824ULL, 0x000fe200078e00ffULL, 0x0000000342447810ULL, 0x000fc80007ffe0ffULL,
0xffffffe03b387812ULL, 0x000fc800078ee238ULL, 0x0000c00038457811ULL, 0x002fe200078e20ffULL,
0x0000000144387824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x014a0c0042367984ULL, 0x000ea80000004800ULL,
0x014ac00036367984ULL, 0x004ea40000004800ULL, 0x0000003621387224ULL, 0x004fc800078e0238ULL,
0x00005e00383a7625ULL, 0x000fc800078e0041ULL, 0x0000000144387824ULL, 0x000fe200078e0203ULL,
0x000000433a3e7210ULL, 0x000fc80007f1e0ffULL, 0x0000003bff3f7210ULL, 0x000fe200007fe4ffULL,
0x00000020443b7824ULL, 0x000fe200078e00ffULL, 0x0000000442447810ULL, 0x000fc80007ffe0ffULL,
0xffffffe03b387812ULL, 0x000fc800078ee238ULL, 0x0000c00038457811ULL, 0x002fe200078e20ffULL,
0x0000000144387824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e457faeULL, 0x0003e8000b901c46ULL, 0x014a100042367984ULL, 0x000ea80000004800ULL,
0x014ac00036367984ULL, 0x004ea40000004800ULL, 0x0000003621387224ULL, 0x004fc800078e0238ULL,
0x00005e00383a7625ULL, 0x000fe200078e0041ULL, 0x0000000344387210ULL, 0x000fc80007ffe0ffULL,
0x000000433a3c7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff3d7224ULL, 0x000fe400000e063bULL,
0x00000020443b7824ULL, 0x000fe200078e00ffULL, 0x0000000542447810ULL, 0x000fc80007ffe0ffULL,
0xffffffe03b387812ULL, 0x000fc800078ee238ULL, 0x0000c00038457811ULL, 0x002fe200078e20ffULL,
0x0000000144387824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x014a140042367984ULL, 0x000ea20000004800ULL,
0x00000006423c7810ULL, 0x002fca0007ffe0ffULL, 0x000000203c457824ULL, 0x000fe200078e00ffULL,
0x014ac00036367984ULL, 0x004e640000004800ULL, 0x0000003621387224ULL, 0x002fc800078e0238ULL,
0x00005e00383a7625ULL, 0x000fc800078e0041ULL, 0x0000000144387824ULL, 0x000fe200078e0203ULL,
0x000000433a3e7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff3f7224ULL, 0x000fe200000e063bULL,
0x00000005443b7819ULL, 0x000fc800000006ffULL, 0xffffffe03b387812ULL, 0x000fc800078ee238ULL,
0x0000c000383d7811ULL, 0x000fe200078e20ffULL, 0x000000013c387824ULL, 0x000fc800078e0239ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e3d7faeULL, 0x0003e8000b901c46ULL,
0x014a180042367984ULL, 0x000ea80000004800ULL, 0x014ac00036367984ULL, 0x004ea40000004800ULL,
0x0000003621387224ULL, 0x004fc800078e0238ULL, 0x00005e00383a7625ULL, 0x000fc800078e0041ULL,
0x000000013c387824ULL, 0x000fe200078e0203ULL, 0x000000433a3a7210ULL, 0x000fe40007f1e0ffULL,
0x00000007423c7810ULL, 0x000fe40007ffe0ffULL, 0xffffffe045387812ULL, 0x000fe200078ee238ULL,
0x000000ffff3b7224ULL, 0x000fe200000e063bULL, 0x000000393c397210ULL, 0x040fe20007ffe0ffULL,
0x000000013c3e7824ULL, 0x002fe200078e0203ULL, 0x0000c000383d7811ULL, 0x000fe200078e20ffULL,
0x000000203c3f7824ULL, 0x000fc800078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a3d7faeULL, 0x0003e2000b901c46ULL, 0xffffffe03f3e7812ULL, 0x000fc600078ee23eULL,
0x014a1c0042367984ULL, 0x000ea20000004800ULL, 0x0000c0003e3b7811ULL, 0x002fc600078e20ffULL,
0x014ac00036367984ULL, 0x004e640000004800ULL, 0x0000003621397224ULL, 0x002fc800078e0239ULL,
0x00005e0039387625ULL, 0x000fca00078e0041ULL, 0x0000004338387210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff397224ULL, 0x000fca00000e0639ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e6000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b8800ff387f8cULL, 0x002e64000c80043fULL,
0x000000ffff3f7224ULL, 0x002fc400078e0039ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x014b8c00ff367984ULL, 0x000e620000000800ULL, 0x000000ff003c7202ULL, 0x000fe20000000f00ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000036ff7812ULL, 0x002fe2000780483fULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc8000001143bULL,
0x0000003d36367211ULL, 0x000fca00078110ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e063bULL,
0x0000000236367819ULL, 0x000fc8000000123bULL, 0x000000360000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x014b8c00ff367984ULL, 0x000e640000000800ULL,
0x8000000036ff7812ULL, 0x002fe4000780483fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000018000017945ULL, 0x000fe20003800000ULL, 0x0000016000004947ULL, 0x000fea0003800000ULL,
0x000000347300720cULL, 0x000fe40003f04070ULL, 0x00014a0023397811ULL, 0x000fe400078e10ffULL,
0x000000ff35367207ULL, 0x000fc40000000000ULL, 0x000000ff35387207ULL, 0x000fc60004000000ULL,
0x0000000137367824ULL, 0x000fe400078e0236ULL, 0x00000004ff377424ULL, 0x000fc600078e00ffULL,
0x00000002ff357819ULL, 0x000fe20000011636ULL, 0x0000004036367824ULL, 0x000fc800078e00ffULL,
0x0000030035357a24ULL, 0x000fe200078e0234ULL, 0x000000c036367812ULL, 0x000fe200078ec0ffULL,
0x0000000177347824ULL, 0x000fc600078e0238ULL, 0x0000003635357211ULL, 0x000fc800078e40ffULL,
0x0000002035357810ULL, 0x000fca0007ffe0ffULL, 0x0000000123367824ULL, 0x100fe400078e0235ULL,
0x0000680034347a24ULL, 0x000fc600078e0235ULL, 0x000000753600720cULL, 0x000fe20003f06070ULL,
0x0000000123347824ULL, 0x000fc800078e0234ULL, 0x0000660034347625ULL, 0x000fd000078e0037ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034397faeULL, 0x0003e4000c121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x014b7800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b7800ff347f8cULL, 0x000e62000c80043fULL,
0x0000013000017945ULL, 0x000fe20003800000ULL, 0x0000003500897202ULL, 0x002fe20000000f00ULL,
0x0000010000001947ULL, 0x000fea0003800000ULL, 0x00000025ff26723eULL, 0x000fc800000010ffULL,
0x0000541026367816ULL, 0x000fe20000000026ULL, 0x0001e4727f007947ULL, 0x000fea000b800000ULL,
0x00001f7c36277589ULL, 0x0002a400000e0000ULL, 0x0001e4b27f007947ULL, 0x000fea000b800000ULL,
0x00001f7b36267589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000107c3b7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0036ULL,
0x000071a000347802ULL, 0x000fc40000000f00ULL, 0x0001f25000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000ffff3a7224ULL, 0x004fe200078e0036ULL,
0x000000187c3b7810ULL, 0x002fe40007ffe0ffULL, 0x000071f000347802ULL, 0x000fc40000000f00ULL,
0x0001f20000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000882357824ULL, 0x000fe200078e00ffULL, 0x0000000481867810ULL, 0x000fe20007ffe0ffULL,
0x0000000184877824ULL, 0x040fe200078e0287ULL, 0x0000008b848b7210ULL, 0x040fe20007ffe0ffULL,
0x0000000184857824ULL, 0x040fe200078e0285ULL, 0xfffffff835867812ULL, 0x000fe200078ee286ULL,
0x0000000184837824ULL, 0x040fe200078e0283ULL, 0x0000000584387819ULL, 0x040fe200000006ffULL,
0x00000020843a7824ULL, 0x004fe200078e00ffULL, 0x0000a00086347811ULL, 0x000fe200078e20ffULL,
0x00000020843c7824ULL, 0x000fe200078e00ffULL, 0xffffffe038387812ULL, 0x000fe200078ee283ULL,
0x0000002084847824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0xffffffe03a8b7812ULL, 0x000fe200078ee28bULL, 0x000000003434783bULL, 0x00ae620000000200ULL,
0xffffffe03c837812ULL, 0x000fe200078ee287ULL, 0x0000042000017945ULL, 0x000fe20003800000ULL,
0xffffffe084847812ULL, 0x000fc400078ee285ULL, 0x0001000038857811ULL, 0x000fe200078e20ffULL,
0x0000000882387824ULL, 0x000fe200078e00ffULL, 0x0001000084847811ULL, 0x000fe400078e20ffULL,
0x0001000083837811ULL, 0x000fe200078e20ffULL, 0x000000008554783bULL, 0x000ea20000004200ULL,
0x000100008b827811ULL, 0x000fe400078e20ffULL, 0x0000000681817810ULL, 0x000fe20007ffe0ffULL,
0x00000000845c783bULL, 0x000ee20000004200ULL, 0x0001000080807811ULL, 0x000fc400078e20ffULL,
0xfffffff838817812ULL, 0x000fe200078ee281ULL, 0x000000008364783bULL, 0x000f220000004200ULL,
0x000100007f7f7811ULL, 0x000fe400078e20ffULL, 0x0000a00081387811ULL, 0x000fe200078e20ffULL,
0x00000000823c783bULL, 0x000fe20000004200ULL, 0x000100007e7e7811ULL, 0x000fe400078e20ffULL,
0x000100007d7d7811ULL, 0x000fe200078e20ffULL, 0x000000007f44783bULL, 0x000fe20000004200ULL,
0x000000ff4000720cULL, 0x000fc60003f05270ULL, 0x000000003838783bULL, 0x000f280000000200ULL,
0x000000008040783bULL, 0x000f280000004200ULL, 0x000000007e48783bULL, 0x000f220000004200ULL,
0x0000002734349231ULL, 0x002fc600003400ffULL, 0x000000007d4c783bULL, 0x000e620000004200ULL,
0x0000002736369231ULL, 0x000fe400003400ffULL, 0x0000002635359231ULL, 0x080fe400003400ffULL,
0x0000002637379231ULL, 0x000fce00003400ffULL, 0x000000543450723cULL, 0x044f7000000418ffULL,
0x0000005c3458723cULL, 0x048ff000000418ffULL, 0x000000643460723cULL, 0x010fe200000418ffULL,
0x0000002738389231ULL, 0x000fc400003400ffULL, 0x000000273a3a9231ULL, 0x000fe400003400ffULL,
0x0000002639399231ULL, 0x080fe400003400ffULL, 0x000000263b3b9231ULL, 0x000fe200003400ffULL,
0x000000563454723cULL, 0x040f7000000418ffULL, 0x0000005e345c723cULL, 0x040f7000000418ffULL,
0x000000663464723cULL, 0x040f7000000418ffULL, 0x0000003c3468723cULL, 0x040f7000000418ffULL,
0x0000003e3434723cULL, 0x000f7000000418ffULL, 0x000000403850723cULL, 0x060b700000041850ULL,
0x000000423854723cULL, 0x040b700000041854ULL, 0x000000443858723cULL, 0x040b700000041858ULL,
0x00000046385c723cULL, 0x040b70000004185cULL, 0x000000483860723cULL, 0x040b700000041860ULL,
0x0000004a3864723cULL, 0x040b700000041864ULL, 0x0000004c3868723cULL, 0x042b700000041868ULL,
0x0000004e3834723cULL, 0x000b620000041834ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0000000000ULL, 0x000000501d1d7221ULL, 0x020fe20000010000ULL,
0x000000511c1c7221ULL, 0x000fe20000010000ULL, 0x0000005419197221ULL, 0x000fe20000010000ULL,
0x0000005518187221ULL, 0x000fe20000010000ULL, 0x0000005815157221ULL, 0x000fe20000010000ULL,
0x0000005914147221ULL, 0x000fe20000010000ULL, 0x0000005c11117221ULL, 0x000fe20000010000ULL,
0x0000005d10107221ULL, 0x000fe20000010000ULL, 0x000000600d0d7221ULL, 0x000fe20000010000ULL,
0x000000610c0c7221ULL, 0x000fe20000010000ULL, 0x0000006409097221ULL, 0x000fe20000010000ULL,
0x0000006508087221ULL, 0x000fe20000010000ULL, 0x0000006805057221ULL, 0x000fe20000010000ULL,
0x0000006904047221ULL, 0x000fe20000010000ULL, 0x0000003433337221ULL, 0x000fe20000010000ULL,
0x000000356c6c7221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000003947ULL, 0x000fea0003000000ULL,
0x000000521b1b7221ULL, 0x020fe20000010000ULL, 0x000000531a1a7221ULL, 0x000fe20000010000ULL,
0x0000005617177221ULL, 0x000fe20000010000ULL, 0x0000005716167221ULL, 0x000fe20000010000ULL,
0x0000005a13137221ULL, 0x000fe20000010000ULL, 0x0000005b12127221ULL, 0x000fe20000010000ULL,
0x0000005e0f0f7221ULL, 0x000fe20000010000ULL, 0x0000005f0e0e7221ULL, 0x000fe20000010000ULL,
0x000000620b0b7221ULL, 0x000fe20000010000ULL, 0x000000630a0a7221ULL, 0x000fe20000010000ULL,
0x0000006607077221ULL, 0x000fe20000010000ULL, 0x0000006706067221ULL, 0x000fe20000010000ULL,
0x0000006a31317221ULL, 0x000fe20000010000ULL, 0x0000006b32327221ULL, 0x000fe20000010000ULL,
0x000000366d6d7221ULL, 0x000fe20000010000ULL, 0x000000376e6e7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000188887810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b8800ff347f8cULL, 0x020e62000c80043fULL,
0x00000004ff877424ULL, 0x000fca00078e00ffULL, 0x0000000187877807ULL, 0x000fc80006800000ULL,
0x000000878800720cULL, 0x000fe40003f06070ULL, 0x00000035003c7202ULL, 0x002fd60000000f00ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffab7000007947ULL, 0x000fea000383ffffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000407a347811ULL, 0x000fe200078e40ffULL,
0x014b5800ffff7f8cULL, 0x000fe6000c80043fULL, 0x000000753400720cULL, 0x000fda0003f06070ULL,
0x0000ef7000000947ULL, 0x000fea0003800000ULL, 0x000000ffff887224ULL, 0x000fca00078e00ffULL,
0x00000002ff357819ULL, 0x000fe20000011688ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000000388367812ULL, 0x040fe200078ec0ffULL, 0x000000ffff3e7224ULL, 0x000fe200078e00ffULL,
0x0000003588357207ULL, 0x000fe40002800000ULL, 0x000000ff36367207ULL, 0x000fe40006800000ULL,
0x0000000135377810ULL, 0x000fc80007ffe0ffULL, 0x00000002ff397819ULL, 0x000fe40000011637ULL,
0x0000000337357812ULL, 0x000fc600078ec0ffULL, 0x0000030039347a24ULL, 0x000fc400078e027aULL,
0x0000000000387805ULL, 0x000fca0000015200ULL, 0x014b7c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe40007804889ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000017945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078110ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x014b7c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe40007804889ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fc40000015200ULL, 0x014b8c00ff3b7984ULL, 0x000e640000000800ULL,
0x800000003bff7812ULL, 0x002fe4000780483cULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x000000ff003e7202ULL, 0x000fe20000000f00ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL, 0x000000013b3b7824ULL, 0x000fe200000e0e39ULL,
0x003d09003d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3a7819ULL, 0x000fc8000001143bULL, 0x0000003d3a3a7211ULL, 0x000fca00078110ffULL,
0x000000ffff3b7224ULL, 0x000fca00000e063bULL, 0x000000023a3a7819ULL, 0x000fc8000000123bULL,
0x0000003a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x014b8c00ff3b7984ULL, 0x000e640000000800ULL, 0x800000003bff7812ULL, 0x002fe4000780483cULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000134397810ULL, 0x040fe20007ffe0ffULL,
0x0000000434387824ULL, 0x000fe200078e0235ULL, 0x0000120000017945ULL, 0x000fe40003800000ULL,
0x000000743900720cULL, 0x000fe40003f06070ULL, 0x00000020383b7811ULL, 0x000fc800078e30ffULL,
0x0000006070397812ULL, 0x000fce00078ef83bULL, 0x0000098000008947ULL, 0x000fea0003800000ULL,
0x00000004723f7824ULL, 0x040fe200078e00ffULL, 0x0000000372407210ULL, 0x040fe20007ffe0ffULL,
0x00000001723c7824ULL, 0x040fe400078e0239ULL, 0x00000200ff417424ULL, 0x000fe200078e00ffULL,
0x014a00003f387984ULL, 0x000e620000000800ULL, 0x0000002072457824ULL, 0x000fca00078e00ffULL,
0xffffffe045407812ULL, 0x000fc800078ee240ULL, 0x0001000040457811ULL, 0x000fe400078e20ffULL,
0x0000000172407810ULL, 0x000fca0007ffe0ffULL, 0x0000000140427824ULL, 0x040fe400078e0203ULL,
0x0000002040477824ULL, 0x000fca00078e00ffULL, 0xffffffe047427812ULL, 0x000fe400078ee242ULL,
0x00000002383d7819ULL, 0x002fe400000006ffULL, 0x0000003b75387217ULL, 0x000fc60007800000ULL,
0x014ac0003d3a7984ULL, 0x000e640000000800ULL, 0x00000001383b7824ULL, 0x000fe400078e0a3bULL,
0x0000001003387824ULL, 0x000fc600078e00ffULL, 0x0000003b723b7217ULL, 0x000fe40007800000ULL,
0x000001f038437812ULL, 0x000fc600078ec0ffULL, 0x000000013b3e7824ULL, 0x000fca00078e0a72ULL,
0x000000ff3e00720cULL, 0x000fe20003f03070ULL, 0x0000003a213a7224ULL, 0x002fc800078e023cULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe40007f3e0ffULL,
0x00000039403a7210ULL, 0x000fe40007ffe0ffULL, 0x0000000272407810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fc800008e063bULL, 0x0000002040477824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000013e00780cULL, 0x000fc60003f03070ULL, 0x014a04003f387984ULL, 0x000ea20000000800ULL,
0x0001000042457811ULL, 0x002fe200078e20ffULL, 0x0000000140427824ULL, 0x000fca00078e0203ULL,
0xffffffe047427812ULL, 0x000fe200078ee242ULL, 0x0000000438387824ULL, 0x004fcc00078e00ffULL,
0x014ac00038387984ULL, 0x000e640000000800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe40007f3e0ffULL,
0x00000039403a7210ULL, 0x000fe40007ffe0ffULL, 0x0000000372407810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fc800008e063bULL, 0x0000002040477824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000023e00780cULL, 0x000fc60003f03070ULL, 0x014a08003f387984ULL, 0x000ea20000000800ULL,
0x0001000042457811ULL, 0x002fe200078e20ffULL, 0x0000000140427824ULL, 0x000fca00078e0203ULL,
0xffffffe047427812ULL, 0x000fe200078ee242ULL, 0x0000000438387824ULL, 0x004fcc00078e00ffULL,
0x014ac00038387984ULL, 0x000e640000000800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe40007f3e0ffULL,
0x00000039403a7210ULL, 0x000fe40007ffe0ffULL, 0x0000000472407810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fc800008e063bULL, 0x0000002040477824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000033e00780cULL, 0x000fc60003f03070ULL, 0x014a0c003f387984ULL, 0x000ea20000000800ULL,
0x0001000042457811ULL, 0x002fe200078e20ffULL, 0x0000000140427824ULL, 0x000fca00078e0203ULL,
0xffffffe047427812ULL, 0x000fe200078ee242ULL, 0x0000000438387824ULL, 0x004fcc00078e00ffULL,
0x014ac00038387984ULL, 0x000e640000000800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe40007f3e0ffULL,
0x00000039403a7210ULL, 0x000fe40007ffe0ffULL, 0x0000000572407810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fc800008e063bULL, 0x0000002040477824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000043e00780cULL, 0x000fc60003f03070ULL, 0x014a10003f387984ULL, 0x000ea20000000800ULL,
0x0001000042457811ULL, 0x002fe200078e20ffULL, 0x0000000140427824ULL, 0x000fca00078e0203ULL,
0xffffffe047427812ULL, 0x000fe200078ee242ULL, 0x0000000438387824ULL, 0x004fcc00078e00ffULL,
0x014ac00038387984ULL, 0x000e640000000800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe40007f3e0ffULL,
0x00000039403a7210ULL, 0x000fe40007ffe0ffULL, 0x0000000672407810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fc800008e063bULL, 0x0000002040477824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000053e00780cULL, 0x000fc60003f03070ULL, 0x014a14003f387984ULL, 0x000ea20000000800ULL,
0x0001000042457811ULL, 0x002fe200078e20ffULL, 0x0000000140427824ULL, 0x000fca00078e0203ULL,
0xffffffe047427812ULL, 0x000fe200078ee242ULL, 0x0000000438387824ULL, 0x004fcc00078e00ffULL,
0x014ac00038387984ULL, 0x000e640000000800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe40007f3e0ffULL,
0x00000039403a7210ULL, 0x000fe40007ffe0ffULL, 0x0000000772407810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fc600008e063bULL, 0x0000003940397210ULL, 0x000fe40007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000063e00780cULL, 0x000fc60003f03070ULL, 0x014a18003f387984ULL, 0x000ea20000000800ULL,
0x00010000423d7811ULL, 0x002fe200078e20ffULL, 0x0000000140427824ULL, 0x000fe400078e0203ULL,
0x0000000438387824ULL, 0x004fcc00078e00ffULL, 0x014ac00038387984ULL, 0x000e640000000800ULL,
0x00000038213a7224ULL, 0x002fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0041ULL,
0x000000433a3a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fca00008e063bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e2000c101c46ULL,
0x000000073e00780cULL, 0x000fc60003f03070ULL, 0x014a1c003f387984ULL, 0x000ea40000000800ULL,
0x00000004383c7824ULL, 0x004fca00078e00ffULL, 0x014ac0003c387984ULL, 0x000ea40000000800ULL,
0x0000003821387224ULL, 0x004fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fc800078e0041ULL,
0x0000002040417824ULL, 0x000fe200078e00ffULL, 0x0000004338387210ULL, 0x000fc80007f3e0ffULL,
0xffffffe041427812ULL, 0x000fe200078ee242ULL, 0x000000ffff397224ULL, 0x000fc600008e0639ULL,
0x00010000423b7811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e2000c101c46ULL, 0x0000083000007947ULL, 0x000fea0003800000ULL,
0x0000007203407211ULL, 0x040fe200078fd8ffULL, 0x00000200ff417424ULL, 0x000fe200078e00ffULL,
0x00000004033b7819ULL, 0x000fc600000006ffULL, 0x014a000040387984ULL, 0x000e620000004800ULL,
0x00000001403a7824ULL, 0x040fe200078e0239ULL, 0x000001f03b437812ULL, 0x000fe200078ec0ffULL,
0x00000001403d7824ULL, 0x040fe400078e0203ULL, 0x00000020403e7824ULL, 0x000fe200078e00ffULL,
0x014ac00038387984ULL, 0x002e640000004800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe40007f1e0ffULL,
0xffffffe03e3a7812ULL, 0x000fe400078ee23dULL, 0x00000001403e7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fe200000e063bULL, 0x000100003a457811ULL, 0x000fe400078e20ffULL,
0x000000393e3a7210ULL, 0x040fe20007ffe0ffULL, 0x000000013e3f7824ULL, 0x040fe400078e0203ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000b901c46ULL,
0x000000203e427824ULL, 0x000fc600078e00ffULL, 0x014a040040387984ULL, 0x000ea20000004800ULL,
0x00000002403c7810ULL, 0x002fc80007ffe0ffULL, 0x000000033c3d7210ULL, 0x000fe20007ffe0ffULL,
0x014ac00038387984ULL, 0x004e640000004800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3e7210ULL, 0x000fe40007f1e0ffULL,
0xffffffe0423a7812ULL, 0x000fe200078ee23fULL, 0x000000203c427824ULL, 0x000fe400078e00ffULL,
0x000000ffff3f7224ULL, 0x000fe200000e063bULL, 0x000100003a457811ULL, 0x000fe200078e20ffULL,
0x000000013c3a7824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e457faeULL, 0x0003e8000b901c46ULL, 0x014a080040387984ULL, 0x000ea20000004800ULL,
0x00000003403e7810ULL, 0x002fca0007ffe0ffULL, 0x000000013e3f7824ULL, 0x000fe200078e0203ULL,
0x014ac00038387984ULL, 0x004e640000004800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe40007f1e0ffULL,
0xffffffe0423a7812ULL, 0x000fe400078ee23dULL, 0x000000053e427819ULL, 0x000fe200000006ffULL,
0x000000ffff3d7224ULL, 0x000fe200000e063bULL, 0x000100003a457811ULL, 0x000fe200078e20ffULL,
0x000000013e3a7824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x014a0c0040387984ULL, 0x000ea20000004800ULL,
0x00000004403c7810ULL, 0x002fca0007ffe0ffULL, 0x000000013c3d7824ULL, 0x000fe200078e0203ULL,
0x014ac00038387984ULL, 0x004e640000004800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3e7210ULL, 0x000fe40007f1e0ffULL,
0xffffffe0423a7812ULL, 0x000fe200078ee23fULL, 0x000000203c427824ULL, 0x000fe400078e00ffULL,
0x000000ffff3f7224ULL, 0x000fe200000e063bULL, 0x000100003a457811ULL, 0x000fe200078e20ffULL,
0x000000013c3a7824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e457faeULL, 0x0003e8000b901c46ULL, 0x014a100040387984ULL, 0x000ea20000004800ULL,
0x00000005403e7810ULL, 0x002fca0007ffe0ffULL, 0x000000013e3f7824ULL, 0x000fe200078e0203ULL,
0x014ac00038387984ULL, 0x004e640000004800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe40007f1e0ffULL,
0xffffffe0423a7812ULL, 0x000fe200078ee23dULL, 0x000000203e427824ULL, 0x000fe200078e00ffULL,
0x0000003bff3d7210ULL, 0x000fe400007fe4ffULL, 0x000100003a457811ULL, 0x000fe200078e20ffULL,
0x000000013e3a7824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x014a140040387984ULL, 0x000ea20000004800ULL,
0x00000006403c7810ULL, 0x002fca0007ffe0ffULL, 0x000000203c457824ULL, 0x000fe200078e00ffULL,
0x014ac00038387984ULL, 0x004e640000004800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3e7210ULL, 0x000fe40007f1e0ffULL,
0xffffffe0423a7812ULL, 0x000fe200078ee23fULL, 0x000000013c427824ULL, 0x000fe400078e0203ULL,
0x000000ffff3f7224ULL, 0x000fe200000e063bULL, 0x000100003a3d7811ULL, 0x000fe400078e20ffULL,
0x000000393c3a7210ULL, 0x000fe40007ffe0ffULL, 0xffffffe045427812ULL, 0x000fe200078ee242ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e3d7faeULL, 0x0003e8000b901c46ULL,
0x014a180040387984ULL, 0x000ea20000004800ULL, 0x00010000423d7811ULL, 0x002fc400078e20ffULL,
0x00000007403e7810ULL, 0x000fc80007ffe0ffULL, 0x000000033e3f7210ULL, 0x040fe20007ffe0ffULL,
0x000000013e397824ULL, 0x040fe400078e0239ULL, 0x000000203e3e7824ULL, 0x000fca00078e00ffULL,
0xffffffe03e3f7812ULL, 0x000fc800078ee23fULL, 0x000100003f3f7811ULL, 0x000fe200078e20ffULL,
0x014ac00038387984ULL, 0x004e640000004800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3a7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff3b7224ULL, 0x000fca00000e063bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a3d7faeULL, 0x0003e8000b901c46ULL, 0x014a1c00403c7984ULL, 0x000ea80000004800ULL,
0x014ac0003c3c7984ULL, 0x004ea40000004800ULL, 0x0000003c21397224ULL, 0x004fc800078e0239ULL,
0x00005e0039387625ULL, 0x000fca00078e0041ULL, 0x0000004338387210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff397224ULL, 0x000fca00000e0639ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383f7faeULL, 0x0003e6000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b8800ff387f8cULL, 0x002e64000c80043fULL,
0x000000ffff3f7224ULL, 0x002fc400078e0039ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x014b8c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe4000780483fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fc80007f1e1ffULL,
0x0000003b393b7210ULL, 0x000fe400007fe5ffULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078110ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x014b8c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe4000780483fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000347300720cULL, 0x000fe20003f04070ULL, 0x0000019000017945ULL, 0x000fe20003800000ULL,
0x0000000137377812ULL, 0x000fe400078ec0ffULL, 0x000000033600780cULL, 0x000fc80004705270ULL,
0x000000013700780cULL, 0x000fda0000705470ULL, 0x0000014000000947ULL, 0x000fea0003800000ULL,
0x000000032300780cULL, 0x000fe20003f24070ULL, 0x00000300ff377624ULL, 0x000fe200078e00ffULL,
0x0000000171387812ULL, 0x000fc800078ec0ffULL, 0x000000013800780cULL, 0x000fe40003f05070ULL,
0xffffffff37377811ULL, 0x000fc800078e08ffULL, 0x0000000137387807ULL, 0x000fca0004000000ULL,
0x0000000171717824ULL, 0x000fe200078e0238ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x0000000400377824ULL, 0x000fe200078e0223ULL, 0x0000640071387a10ULL, 0x040fe20007ffe0ffULL,
0x00000004ff397424ULL, 0x000fe200078e00ffULL, 0x000000767100720cULL, 0x000fe40003f06070ULL,
0x0000000137377819ULL, 0x000fca00000006ffULL, 0x0000640037387a24ULL, 0x000fe200078e0238ULL,
0x00014ac023377811ULL, 0x000fc600078e10ffULL, 0x0000600038387625ULL, 0x000fca00078e0039ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000038377faeULL, 0x0003e4000c121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000019000017945ULL, 0x000fe20003800000ULL,
0x0000017000004947ULL, 0x000fea0003800000ULL, 0x000000347300720cULL, 0x000fe40003f04070ULL,
0x0000000136367810ULL, 0x000fc80007ffe0ffULL, 0x0000000336377812ULL, 0x002fce00078ec0ffULL,
0x00000002ff368819ULL, 0x000fca0000011636ULL, 0x0000000135357824ULL, 0x000fe200078e0236ULL,
0x000000ff37367207ULL, 0x000fe40004000000ULL, 0x00014a0023377811ULL, 0x000fe400078e10ffULL,
0x00000002ff397819ULL, 0x000fe20000011635ULL, 0x0000004035357824ULL, 0x000fc800078e00ffULL,
0x0000030039397a24ULL, 0x000fe200078e0234ULL, 0x000000c035347812ULL, 0x000fe200078ec0ffULL,
0x00000004ff357424ULL, 0x000fc800078e00ffULL, 0x0000010039397824ULL, 0x000fe200078e0234ULL,
0x0000003677347210ULL, 0x000fc60007ffe0ffULL, 0x0000000123367824ULL, 0x100fe400078e0239ULL,
0x0000680034347a24ULL, 0x000fc600078e0239ULL, 0x000000753600720cULL, 0x000fe20003f06070ULL,
0x0000000123347824ULL, 0x000fc800078e0234ULL, 0x0000660034347625ULL, 0x000fd000078e0035ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034377faeULL, 0x0003e4000c121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x014b8000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b8000ff347f8cULL, 0x000e62000c80043fULL,
0x000000ff8800720cULL, 0x000fe20003f05270ULL, 0x000007e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff897224ULL, 0x002fd600078e0035ULL, 0x000007b000000947ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014af80072347f8cULL, 0x000e64000c80043fULL,
0x00000035003b7202ULL, 0x002fc40000000f00ULL, 0x0000000000347805ULL, 0x000fca0000015200ULL,
0x014afc0072247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fe4000780483bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000027945ULL, 0x000fe20003800000ULL,
0x000000ffff387224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000037945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fcc0000015200ULL, 0x0000003634397210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003900780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403900780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff247819ULL, 0x000fc80000011437ULL,
0x0000003924247211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000224247819ULL, 0x000fc80000001237ULL, 0x000000240000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000138387810ULL, 0x000fc40007ffe0ffULL,
0x0000000000037941ULL, 0x000fea0003800000ULL, 0x014afc0072247984ULL, 0x000e640000000800ULL,
0x8000000024ff7812ULL, 0x002fe4000780483bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000001003247824ULL, 0x000fe200078e00ffULL, 0x00000001ff347819ULL, 0x000fc80000011603ULL,
0x0000007024247812ULL, 0x000fe400078ec0ffULL, 0x0000000c34357812ULL, 0x000fc800078ec0ffULL,
0x00000035243b7210ULL, 0x000fca0007ffe0ffULL, 0x014080003b367984ULL, 0x000e680000000800ULL,
0x014280003b377984ULL, 0x0004e20000000800ULL, 0x0000006f3600720bULL, 0x002fe20003f1d000ULL,
0x0001bb627f007947ULL, 0x000fd8000b800000ULL, 0x0000000000247806ULL, 0x004fc800000e0100ULL,
0x0000ffff243c7812ULL, 0x000fe2000780c0ffULL, 0x0000043000027945ULL, 0x000fe20003800000ULL,
0x00000001ff247424ULL, 0x000fe400078e00ffULL, 0x000000ffff387224ULL, 0x000fd200078e006fULL,
0x000003f000008947ULL, 0x000fea0003800000ULL, 0x000000017800780cULL, 0x000fe40003f05270ULL,
0x0000006f3600720bULL, 0x000fe20003f34000ULL, 0x0001bb227f007947ULL, 0x000fd8000b800000ULL,
0x0000000000397806ULL, 0x000fc400008e0100ULL, 0x000000366f387209ULL, 0x000fe20007810000ULL,
0x0000033000037945ULL, 0x000fe20003800000ULL, 0x0000991039347816ULL, 0x000fc600000000ffULL,
0x014480383b008388ULL, 0x0003e20000000800ULL, 0x000000ff3400720cULL, 0x000fda0003f05270ULL,
0x000002e000008947ULL, 0x000fea0003800000ULL, 0x800000386f347221ULL, 0x002fe20000010000ULL,
0x000000ff39ff7812ULL, 0x000fe2000780c0ffULL, 0x0000017000047945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b34347820ULL, 0x000fc80000410000ULL, 0x00000034003d7308ULL, 0x000e640000000800ULL,
0x0000003d1e1e7220ULL, 0x002fc80000410000ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x0001ba727f007947ULL, 0x000fea000b800000ULL, 0x00001f7c3d347589ULL, 0x0002a400000e0000ULL,
0x000000341d1d7220ULL, 0x084fe20000410000ULL, 0x000000341c1c7220ULL, 0x080fe20000410000ULL,
0x0000003419197220ULL, 0x080fe20000410000ULL, 0x0000003418187220ULL, 0x080fe20000410000ULL,
0x0000003415157220ULL, 0x080fe20000410000ULL, 0x0000003414147220ULL, 0x080fe20000410000ULL,
0x0000003411117220ULL, 0x080fe20000410000ULL, 0x0000003410107220ULL, 0x080fe20000410000ULL,
0x000000340d0d7220ULL, 0x080fe20000410000ULL, 0x000000340c0c7220ULL, 0x080fe20000410000ULL,
0x0000003409097220ULL, 0x080fe20000410000ULL, 0x0000003408087220ULL, 0x080fe20000410000ULL,
0x0000003405057220ULL, 0x080fe20000410000ULL, 0x0000003404047220ULL, 0x080fe20000410000ULL,
0x0000003433337220ULL, 0x080fe20000410000ULL, 0x000000346c6c7220ULL, 0x000fc40000410000ULL,
0x0000000000047941ULL, 0x000fea0003800000ULL, 0x0000ff0039ff7812ULL, 0x000fda000780c0ffULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x0001b9827f007947ULL, 0x000fea000b800000ULL,
0x00001f7b3d347589ULL, 0x00046400000e0000ULL, 0x000000341b1b7220ULL, 0x082fe20000410000ULL,
0x000000341a1a7220ULL, 0x080fe20000410000ULL, 0x0000003417177220ULL, 0x080fe20000410000ULL,
0x0000003416167220ULL, 0x080fe20000410000ULL, 0x0000003413137220ULL, 0x080fe20000410000ULL,
0x0000003412127220ULL, 0x080fe20000410000ULL, 0x000000340f0f7220ULL, 0x080fe20000410000ULL,
0x000000340e0e7220ULL, 0x080fe20000410000ULL, 0x000000340b0b7220ULL, 0x080fe20000410000ULL,
0x000000340a0a7220ULL, 0x080fe20000410000ULL, 0x0000003407077220ULL, 0x080fe20000410000ULL,
0x0000003406067220ULL, 0x080fe20000410000ULL, 0x0000003431317220ULL, 0x080fe20000410000ULL,
0x0000003432327220ULL, 0x080fe20000410000ULL, 0x000000346d6d7220ULL, 0x080fe20000410000ULL,
0x000000346e6e7220ULL, 0x000fc40000410000ULL, 0x0000000000037941ULL, 0x002fea0003800000ULL,
0x0000ffff3cff7812ULL, 0x000fda0007806039ULL, 0x8000003836360221ULL, 0x000fe20000010000ULL,
0x00007610ff240816ULL, 0x000fc60000000024ULL, 0x3fb8aa3b36360820ULL, 0x000fc80000410000ULL,
0x0000003600250308ULL, 0x000e640000000800ULL, 0x0000002537370220ULL, 0x00afcc0000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000001e371e7221ULL, 0x008fe20000010000ULL,
0x00000038006f7202ULL, 0x000fc40000000f00ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ff24ff7812ULL, 0x000fe2000786c0ffULL, 0x0000012000017945ULL, 0x000fd80003800000ULL,
0x0000010000003947ULL, 0x000fea0003800000ULL, 0x00000025ff26723eULL, 0x000fc800000010ffULL,
0x0000541026367816ULL, 0x000fe20000000026ULL, 0x0001b7c27f007947ULL, 0x000fea000b800000ULL,
0x00001f7c36277589ULL, 0x0002e400000e0000ULL, 0x0001b8027f007947ULL, 0x000fea000b800000ULL,
0x00001f7b36267589ULL, 0x0002a400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000107c3b7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0036ULL,
0x0000a06000347802ULL, 0x000fc40000000f00ULL, 0x0001c39000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000ffff3a7224ULL, 0x004fe200078e0036ULL,
0x000000187c3b7810ULL, 0x002fe40007ffe0ffULL, 0x0000a0b000347802ULL, 0x000fc40000000f00ULL,
0x0001c34000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000a80028347811ULL, 0x000fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000002954783bULL, 0x000fe20000004200ULL, 0x0000a8002c387811ULL, 0x000fe200078e20ffULL,
0x000003b000017945ULL, 0x000fe20003800000ULL, 0x000000887c00720cULL, 0x000fe20003f46070ULL,
0x000000003434783bULL, 0x002e620000000200ULL, 0x0000007a7300720cULL, 0x000fc40003fc3070ULL,
0x000000887b00720cULL, 0x000fe20003f26070ULL, 0x000000002a5c783bULL, 0x000fe20000004200ULL,
0x0000007a7300720cULL, 0x000fc60003f03070ULL, 0x000000002b64783bULL, 0x000fe80000004200ULL,
0x000000002d3c783bULL, 0x004fe80000004200ULL, 0x000000003838783bULL, 0x000ea80000000200ULL,
0x000000002e40783bULL, 0x000f280000004200ULL, 0x000000002f44783bULL, 0x000ee80000004200ULL,
0x000000003048783bULL, 0x000ee80000004200ULL, 0x00000000794c783bULL, 0x000ee40000004200ULL,
0x000000273434b231ULL, 0x00afc400003400ffULL, 0x000000273636b231ULL, 0x000fe400003400ffULL,
0x000000263535b231ULL, 0x080fe400003400ffULL, 0x000000263737b231ULL, 0x000fce00003400ffULL,
0x000000543450723cULL, 0x000f6200000418ffULL, 0x000000273838b231ULL, 0x084fe400003400ffULL,
0x000000273a3ab231ULL, 0x000fe400003400ffULL, 0x000000263939b231ULL, 0x000fc600003400ffULL,
0x0000005c3458723cULL, 0x000fe200000418ffULL, 0x000000263b3bb231ULL, 0x000fce00003400ffULL,
0x000000643460723cULL, 0x040ff000000418ffULL, 0x000000563454723cULL, 0x040f7000000418ffULL,
0x0000005e345c723cULL, 0x040f7000000418ffULL, 0x000000663464723cULL, 0x040f7000000418ffULL,
0x0000003c3468723cULL, 0x040b6e00000418ffULL, 0x00000001883c7810ULL, 0x020fe20007ffe0ffULL,
0x0000003e3434723cULL, 0x000f6600000418ffULL, 0x0000003c7c00720cULL, 0x000fc40005746470ULL,
0x0000003c7b00720cULL, 0x000fc60004f26470ULL, 0x000000403850723cULL, 0x050b700000041850ULL,
0x000000423854723cULL, 0x040b700000041854ULL, 0x000000443858723cULL, 0x040b700000041858ULL,
0x00000046385c723cULL, 0x040b70000004185cULL, 0x000000483860723cULL, 0x040b700000041860ULL,
0x0000004a3864723cULL, 0x040b700000041864ULL, 0x0000004c3868723cULL, 0x040b700000041868ULL,
0x0000004e3834723cULL, 0x020b620000041834ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x000000501d1d7221ULL, 0x000fe20000010000ULL,
0x000000511c1c7221ULL, 0x000fe20000010000ULL, 0x0000005419197221ULL, 0x000fe20000010000ULL,
0x0000005518187221ULL, 0x000fe20000010000ULL, 0x0000005815157221ULL, 0x000fe20000010000ULL,
0x0000005914147221ULL, 0x000fe20000010000ULL, 0x0000005c11117221ULL, 0x000fe20000010000ULL,
0x0000005d10107221ULL, 0x000fe20000010000ULL, 0x000000600d0d7221ULL, 0x000fe20000010000ULL,
0x000000610c0c7221ULL, 0x000fe20000010000ULL, 0x0000006409097221ULL, 0x000fe20000010000ULL,
0x0000006508087221ULL, 0x000fe20000010000ULL, 0x0000006805057221ULL, 0x000fe20000010000ULL,
0x0000006904047221ULL, 0x000fe20000010000ULL, 0x0000003433337221ULL, 0x020fe20000010000ULL,
0x000000356c6c7221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000001947ULL, 0x000fea0000000000ULL,
0x000000521b1b7221ULL, 0x000fe20000010000ULL, 0x000000531a1a7221ULL, 0x000fe20000010000ULL,
0x0000005617177221ULL, 0x000fe20000010000ULL, 0x0000005716167221ULL, 0x000fe20000010000ULL,
0x0000005a13137221ULL, 0x000fe20000010000ULL, 0x0000005b12127221ULL, 0x000fe20000010000ULL,
0x0000005e0f0f7221ULL, 0x000fe20000010000ULL, 0x0000005f0e0e7221ULL, 0x000fe20000010000ULL,
0x000000620b0b7221ULL, 0x000fe20000010000ULL, 0x000000630a0a7221ULL, 0x000fe20000010000ULL,
0x0000006607077221ULL, 0x000fe20000010000ULL, 0x0000006706067221ULL, 0x000fe20000010000ULL,
0x0000006a31317221ULL, 0x000fe20000010000ULL, 0x0000006b32327221ULL, 0x000fe20000010000ULL,
0x000000366d6d7221ULL, 0x020fe20000010000ULL, 0x000000376e6e7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x014b8800ff347f8cULL, 0x020e62000c80043fULL, 0x00000002ff377819ULL, 0x000fc4000001163cULL,
0x0000007a7300720cULL, 0x080fe40003fc3070ULL, 0x000000373c377207ULL, 0x040fe40002800000ULL,
0x000000033c3c7812ULL, 0x000fe400078ec0ffULL, 0x0000000137377810ULL, 0x000fe40007ffe0ffULL,
0x0000007a7300720cULL, 0x000fe40003f03070ULL, 0x00000002ff397819ULL, 0x000fc40000011637ULL,
0x00000040ff407803ULL, 0x000fe40000000000ULL, 0x000000ff003e7202ULL, 0x000fe40000000f00ULL,
0x0000000337377812ULL, 0x000fe200078ec0ffULL, 0x000000ffff3f7224ULL, 0x002fe200078e0035ULL,
0x000000ff3c357207ULL, 0x000fe20006800000ULL, 0x0000030039347a24ULL, 0x000fc400078e027aULL,
0x0000000000387805ULL, 0x000fca0000015200ULL, 0x014b8400ff367984ULL, 0x000e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000036ff7812ULL, 0x002fe200078c4889ULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000103e00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007fde1ffULL,
0x000000013b3b7824ULL, 0x000fe200030e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc8000001143bULL,
0x0000003d36367211ULL, 0x000fca00078d10ffULL, 0x000000ffff3b7224ULL, 0x000fca00030e063bULL,
0x0000000236367819ULL, 0x000fc8000000123bULL, 0x000000360000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x014b8400ff367984ULL, 0x000e640000000800ULL,
0x8000000036ff7812ULL, 0x002fe400078c4889ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fc40000015200ULL, 0x014b8c00ff367984ULL, 0x000e620000000800ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe60000000000ULL,
0x8000000036ff7812ULL, 0x002fe200078c483fULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000103c00780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383d7210ULL, 0x000fca0007fde1ffULL, 0x000000013b3b7824ULL, 0x000fe200030e0e39ULL,
0x003d09003d00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff367819ULL, 0x000fc8000001143bULL, 0x0000003d36367211ULL, 0x000fc800078d10ffULL,
0x0000003bff3b7210ULL, 0x000fc800037fe4ffULL, 0x0000000236367819ULL, 0x000fc8000000123bULL,
0x000000360000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x014b8c00ff367984ULL, 0x000e640000000800ULL, 0x8000000036ff7812ULL, 0x002fe400078c483fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000001343b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000434367824ULL, 0x000fe200078e0237ULL, 0x0000120000017945ULL, 0x000fe40003800000ULL,
0x000000743b00720cULL, 0x000fe20003fc6070ULL, 0x00000040363f7824ULL, 0x000fca00078e00ffULL,
0x0000004070397812ULL, 0x000fce00078ef83fULL, 0x000009800000e947ULL, 0x000fea0003800000ULL,
0x0000000472417824ULL, 0x040fe200078e00ffULL, 0x0000003972387210ULL, 0x040fe20007ffe0ffULL,
0x00000200ff437424ULL, 0x000fe200078e00ffULL, 0x0000000172427810ULL, 0x000fe40007ffe0ffULL,
0x014a000041367984ULL, 0x000e640000000800ULL, 0x00000004363e7824ULL, 0x002fca00078e00ffULL,
0x014ac0003e367984ULL, 0x000e640000000800ULL, 0x0000003621367224ULL, 0x002fe400078e0238ULL,
0x0000001003387824ULL, 0x000fe400078e00ffULL, 0x00005e00363a7625ULL, 0x000fe200078e0043ULL,
0x0000003f75367217ULL, 0x000fe40007800000ULL, 0x000001f038457812ULL, 0x000fc800078ec0ffULL,
0x000000453a3c7210ULL, 0x000fe20007fde0ffULL, 0x00000001423a7824ULL, 0x000fc800078e0239ULL,
0x000000ffff3d7224ULL, 0x000fe400030e063bULL, 0x00000001363b7824ULL, 0x000fe200078e0a3fULL,
0x0000000372367210ULL, 0x040fe20007ffe0ffULL, 0x00000020723f7824ULL, 0x000fc600078e00ffULL,
0x0000003b723b7217ULL, 0x000fe40007800000ULL, 0xffffffe03f387812ULL, 0x000fc600078ee236ULL,
0x000000013b367824ULL, 0x000fe200078e0a72ULL, 0x0000c00038477811ULL, 0x000fc800078e20ffULL,
0x000000ff3600720cULL, 0x000fda0003fc3070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c477faeULL, 0x0003e8000f101c46ULL, 0x014a040041387984ULL, 0x000ea40000000800ULL,
0x0000000438387824ULL, 0x004fcc00078e00ffULL, 0x014ac00038387984ULL, 0x000ea40000000800ULL,
0x00000038213a7224ULL, 0x004fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0043ULL,
0x000000453a3e7210ULL, 0x000fe20007fde0ffULL, 0x00000001423a7824ULL, 0x000fc600078e0203ULL,
0x0000003bff3f7210ULL, 0x000fe200037fe4ffULL, 0x00000020423b7824ULL, 0x000fe200078e00ffULL,
0x000000013600780cULL, 0x000fe40003fc3070ULL, 0x0000000272427810ULL, 0x000fe40007ffe0ffULL,
0xffffffe03b3a7812ULL, 0x000fc800078ee23aULL, 0x0000c0003a477811ULL, 0x002fe200078e20ffULL,
0x00000001423a7824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e477faeULL, 0x0003e8000f101c46ULL, 0x014a080041387984ULL, 0x000ea40000000800ULL,
0x0000000438387824ULL, 0x004fcc00078e00ffULL, 0x014ac00038387984ULL, 0x000ea40000000800ULL,
0x00000038213a7224ULL, 0x004fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0043ULL,
0x000000453a3c7210ULL, 0x000fe20007fde0ffULL, 0x00000001423a7824ULL, 0x000fc600078e0203ULL,
0x0000003bff3d7210ULL, 0x000fe200037fe4ffULL, 0x00000020423b7824ULL, 0x000fe200078e00ffULL,
0x000000023600780cULL, 0x000fe40003fc3070ULL, 0x0000000372427810ULL, 0x000fe40007ffe0ffULL,
0xffffffe03b3a7812ULL, 0x000fc800078ee23aULL, 0x0000c0003a477811ULL, 0x002fe200078e20ffULL,
0x00000001423a7824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c477faeULL, 0x0003e8000f101c46ULL, 0x014a0c0041387984ULL, 0x000ea40000000800ULL,
0x0000000438387824ULL, 0x004fcc00078e00ffULL, 0x014ac00038387984ULL, 0x000ea40000000800ULL,
0x00000038213a7224ULL, 0x004fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0043ULL,
0x000000453a3e7210ULL, 0x000fe20007fde0ffULL, 0x00000001423a7824ULL, 0x000fc600078e0203ULL,
0x0000003bff3f7210ULL, 0x000fe200037fe4ffULL, 0x00000020423b7824ULL, 0x000fe200078e00ffULL,
0x000000033600780cULL, 0x000fe40003fc3070ULL, 0x0000000472427810ULL, 0x000fe40007ffe0ffULL,
0xffffffe03b3a7812ULL, 0x000fc800078ee23aULL, 0x0000c0003a477811ULL, 0x002fe200078e20ffULL,
0x00000001423a7824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e477faeULL, 0x0003e8000f101c46ULL, 0x014a100041387984ULL, 0x000ea40000000800ULL,
0x0000000438387824ULL, 0x004fcc00078e00ffULL, 0x014ac00038387984ULL, 0x000ea40000000800ULL,
0x00000038213a7224ULL, 0x004fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0043ULL,
0x000000453a3c7210ULL, 0x000fe20007fde0ffULL, 0x00000001423a7824ULL, 0x000fc600078e0203ULL,
0x0000003bff3d7210ULL, 0x000fe200037fe4ffULL, 0x00000020423b7824ULL, 0x000fe200078e00ffULL,
0x000000043600780cULL, 0x000fe40003fc3070ULL, 0x0000000572427810ULL, 0x000fe40007ffe0ffULL,
0xffffffe03b3a7812ULL, 0x000fc800078ee23aULL, 0x0000c0003a477811ULL, 0x002fe200078e20ffULL,
0x00000001423a7824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c477faeULL, 0x0003e8000f101c46ULL, 0x014a140041387984ULL, 0x000ea20000000800ULL,
0x00000006723c7810ULL, 0x002fe20007ffe0ffULL, 0x0000000438387824ULL, 0x004fcc00078e00ffULL,
0x014ac00038387984ULL, 0x000e640000000800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0043ULL, 0x000000453a3e7210ULL, 0x000fe20007fde0ffULL,
0x00000001423a7824ULL, 0x000fc600078e0203ULL, 0x0000003bff3f7210ULL, 0x000fe200037fe4ffULL,
0x00000020423b7824ULL, 0x000fe200078e00ffULL, 0x000000053600780cULL, 0x000fe20003fc3070ULL,
0x000000013c427824ULL, 0x000fc600078e0203ULL, 0xffffffe03b3a7812ULL, 0x000fc800078ee23aULL,
0x0000c0003a3d7811ULL, 0x000fe200078e20ffULL, 0x000000013c3a7824ULL, 0x000fc800078e0239ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e3d7faeULL, 0x0003e8000f101c46ULL,
0x014a180041387984ULL, 0x000ea20000000800ULL, 0x000000203c3d7824ULL, 0x002fe200078e00ffULL,
0x00000007723e7810ULL, 0x000fc80007ffe0ffULL, 0xffffffe03d427812ULL, 0x000fe200078ee242ULL,
0x000000013e397824ULL, 0x040fe400078e0239ULL, 0x000000013e3f7824ULL, 0x000fe200078e0203ULL,
0x0000c000423d7811ULL, 0x000fe200078e20ffULL, 0x000000203e3e7824ULL, 0x000fca00078e00ffULL,
0xffffffe03e3f7812ULL, 0x000fc800078ee23fULL, 0x0000c0003f3f7811ULL, 0x000fe200078e20ffULL,
0x0000000438387824ULL, 0x004fcc00078e00ffULL, 0x014ac00038387984ULL, 0x000e640000000800ULL,
0x00000038213a7224ULL, 0x002fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0043ULL,
0x000000453a3a7210ULL, 0x000fc80007fde0ffULL, 0x0000003bff3b7210ULL, 0x000fe400037fe4ffULL,
0x000000063600780cULL, 0x000fda0003fc3070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a3d7faeULL, 0x0003e8000f101c46ULL, 0x014a1c0041387984ULL, 0x000ea40000000800ULL,
0x00000004383c7824ULL, 0x004fca00078e00ffULL, 0x014ac0003c387984ULL, 0x000ea40000000800ULL,
0x0000003821387224ULL, 0x004fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e0043ULL,
0x0000004538387210ULL, 0x000fc80007fde0ffULL, 0x00000039ff397210ULL, 0x000fe400037fe4ffULL,
0x000000073600780cULL, 0x000fda0003fc3070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383f7faeULL, 0x0003e2000f101c46ULL, 0x0000083000007947ULL, 0x000fea0003800000ULL,
0x0000007203427211ULL, 0x040fe200078fd8ffULL, 0x00000200ff417424ULL, 0x000fe200078e00ffULL,
0x00000004033c7819ULL, 0x000fe400000006ffULL, 0x0000000142447810ULL, 0x040fe20007ffe0ffULL,
0x014a000042367984ULL, 0x000e620000004800ULL, 0x0000000142387824ULL, 0x000fe200078e0239ULL,
0x000001f03c437812ULL, 0x000fe400078ec0ffULL, 0x014ac00036367984ULL, 0x002e640000004800ULL,
0x0000003621387224ULL, 0x002fc800078e0238ULL, 0x00005e00383a7625ULL, 0x000fc800078e0041ULL,
0x0000000142387824ULL, 0x000fe200078e0203ULL, 0x000000433a3c7210ULL, 0x000fca0007fde0ffULL,
0x000000ffff3d7224ULL, 0x000fe400030e063bULL, 0x00000020423b7824ULL, 0x000fca00078e00ffULL,
0xffffffe03b387812ULL, 0x000fc800078ee238ULL, 0x0000c00038457811ULL, 0x000fe200078e20ffULL,
0x0000000144387824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x014a040042367984ULL, 0x000ea80000004800ULL,
0x014ac00036367984ULL, 0x004ea40000004800ULL, 0x0000003621387224ULL, 0x004fc800078e0238ULL,
0x00005e00383a7625ULL, 0x000fc800078e0041ULL, 0x0000000144387824ULL, 0x000fe200078e0203ULL,
0x000000433a3e7210ULL, 0x000fc80007fde0ffULL, 0x0000003bff3f7210ULL, 0x000fe200037fe4ffULL,
0x00000020443b7824ULL, 0x000fe200078e00ffULL, 0x0000000242447810ULL, 0x000fc80007ffe0ffULL,
0xffffffe03b387812ULL, 0x000fc800078ee238ULL, 0x0000c00038457811ULL, 0x002fe200078e20ffULL,
0x0000000144387824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e457faeULL, 0x0003e8000b901c46ULL, 0x014a080042367984ULL, 0x000ea80000004800ULL,
0x014ac00036367984ULL, 0x004ea40000004800ULL, 0x0000003621387224ULL, 0x004fc800078e0238ULL,
0x00005e00383a7625ULL, 0x000fe200078e0041ULL, 0x0000000344387210ULL, 0x000fc80007ffe0ffULL,
0x000000433a3c7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3d7224ULL, 0x000fe400030e063bULL,
0x00000020443b7824ULL, 0x000fe200078e00ffULL, 0x0000000342447810ULL, 0x000fc80007ffe0ffULL,
0xffffffe03b387812ULL, 0x000fc800078ee238ULL, 0x0000c00038457811ULL, 0x002fe200078e20ffULL,
0x0000000144387824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x014a0c0042367984ULL, 0x000ea80000004800ULL,
0x014ac00036367984ULL, 0x004ea40000004800ULL, 0x0000003621387224ULL, 0x004fc800078e0238ULL,
0x00005e00383a7625ULL, 0x000fc800078e0041ULL, 0x0000000144387824ULL, 0x000fe200078e0203ULL,
0x000000433a3e7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3f7224ULL, 0x000fe200030e063bULL,
0x00000005443b7819ULL, 0x000fe400000006ffULL, 0x0000000442447810ULL, 0x000fe40007ffe0ffULL,
0xffffffe03b387812ULL, 0x000fc800078ee238ULL, 0x0000c00038457811ULL, 0x002fe200078e20ffULL,
0x0000000144387824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e457faeULL, 0x0003e8000b901c46ULL, 0x014a100042367984ULL, 0x000ea80000004800ULL,
0x014ac00036367984ULL, 0x004ea40000004800ULL, 0x0000003621387224ULL, 0x004fc800078e0238ULL,
0x00005e00383a7625ULL, 0x000fc800078e0041ULL, 0x0000000144387824ULL, 0x000fe200078e0203ULL,
0x000000433a3c7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3d7224ULL, 0x000fe400030e063bULL,
0x00000020443b7824ULL, 0x000fe200078e00ffULL, 0x0000000542447810ULL, 0x000fc80007ffe0ffULL,
0xffffffe03b387812ULL, 0x000fc800078ee238ULL, 0x0000c00038457811ULL, 0x002fe400078e20ffULL,
0x0000003944387210ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x014a140042367984ULL, 0x000ea20000004800ULL,
0x00000006423c7810ULL, 0x002fca0007ffe0ffULL, 0x000000203c457824ULL, 0x000fe200078e00ffULL,
0x014ac00036367984ULL, 0x004e640000004800ULL, 0x0000003621387224ULL, 0x002fc800078e0238ULL,
0x00005e00383a7625ULL, 0x000fc800078e0041ULL, 0x0000000144387824ULL, 0x000fe200078e0203ULL,
0x000000433a3e7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3f7224ULL, 0x000fe400030e063bULL,
0x00000020443b7824ULL, 0x000fca00078e00ffULL, 0xffffffe03b387812ULL, 0x000fc800078ee238ULL,
0x0000c000383d7811ULL, 0x000fe200078e20ffULL, 0x000000013c387824ULL, 0x000fc800078e0239ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e3d7faeULL, 0x0003e8000b901c46ULL,
0x014a180042367984ULL, 0x000ea80000004800ULL, 0x014ac00036367984ULL, 0x004ea40000004800ULL,
0x0000003621387224ULL, 0x004fc800078e0238ULL, 0x00005e00383a7625ULL, 0x000fc800078e0041ULL,
0x000000013c387824ULL, 0x000fe200078e0203ULL, 0x000000433a3a7210ULL, 0x000fe40007fde0ffULL,
0x00000007423c7810ULL, 0x000fe40007ffe0ffULL, 0xffffffe045387812ULL, 0x000fe400078ee238ULL,
0x0000003bff3b7210ULL, 0x000fe200037fe4ffULL, 0x000000013c397824ULL, 0x000fe200078e0239ULL,
0x0000c000383d7811ULL, 0x002fe200078e20ffULL, 0x000000203c3f7824ULL, 0x040fe200078e00ffULL,
0x000000033c3e7210ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a3d7faeULL, 0x0003e2000b901c46ULL, 0xffffffe03f3e7812ULL, 0x000fc600078ee23eULL,
0x014a1c0042367984ULL, 0x000ea20000004800ULL, 0x0000c0003e3b7811ULL, 0x002fc600078e20ffULL,
0x014ac00036367984ULL, 0x004e640000004800ULL, 0x0000003621397224ULL, 0x002fc800078e0239ULL,
0x00005e0039387625ULL, 0x000fca00078e0041ULL, 0x0000004338387210ULL, 0x000fca0007fde0ffULL,
0x000000ffff397224ULL, 0x000fca00030e0639ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e6000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b8800ff387f8cULL, 0x002e64000c80043fULL,
0x000000ffff3f7224ULL, 0x002fc400078e0039ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x014b8c00ff367984ULL, 0x000e620000000800ULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000036ff7812ULL, 0x002fe200078c483fULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007fde1ffULL,
0x000000013b3b7824ULL, 0x000fe200030e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc8000001143bULL,
0x0000003d36367211ULL, 0x000fc800078d10ffULL, 0x0000003bff3b7210ULL, 0x000fc800037fe4ffULL,
0x0000000236367819ULL, 0x000fc8000000123bULL, 0x000000360000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x014b8c00ff367984ULL, 0x000e640000000800ULL,
0x8000000036ff7812ULL, 0x002fe400078c483fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000018000017945ULL, 0x000fe20003800000ULL, 0x0000016000004947ULL, 0x000fea0003800000ULL,
0x000000347300720cULL, 0x000fe40003fc4070ULL, 0x00014a0023397811ULL, 0x000fe400078e10ffULL,
0x000000ff35367207ULL, 0x000fc40003000000ULL, 0x000000ff35387207ULL, 0x000fc60007000000ULL,
0x0000000137367824ULL, 0x000fe200078e0236ULL, 0x0000000400377802ULL, 0x000fc80000000f00ULL,
0x00000002ff357819ULL, 0x000fe20000011636ULL, 0x0000004036367824ULL, 0x000fc800078e00ffULL,
0x0000030035357a24ULL, 0x000fe200078e0234ULL, 0x000000c036367812ULL, 0x000fe200078ec0ffULL,
0x0000000177347824ULL, 0x000fc800078e0238ULL, 0x0000010035357824ULL, 0x000fca00078e0236ULL,
0x0000002035357810ULL, 0x000fca0007ffe0ffULL, 0x0000000123367824ULL, 0x100fe400078e0235ULL,
0x0000680034347a24ULL, 0x000fc600078e0235ULL, 0x000000753600720cULL, 0x000fe20003fc6070ULL,
0x0000000123347824ULL, 0x000fc800078e0234ULL, 0x0000660034347625ULL, 0x000fd000078e0037ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034397faeULL, 0x0003e4000f121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x014b7800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b7800ff347f8cULL, 0x000e62000c80043fULL,
0x0000013000017945ULL, 0x000fe20003800000ULL, 0x000000ffff897224ULL, 0x002fe200078e0035ULL,
0x0000010000003947ULL, 0x000fea0003800000ULL, 0x00000025ff26723eULL, 0x000fc800000010ffULL,
0x0000541026367816ULL, 0x000fe20000000026ULL, 0x000195a27f007947ULL, 0x000fea000b800000ULL,
0x00001f7c36277589ULL, 0x0002a400000e0000ULL, 0x000195e27f007947ULL, 0x000fea000b800000ULL,
0x00001f7b36267589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000107c3b7810ULL, 0x002fe40007ffe0ffULL, 0x00000036003a7202ULL, 0x000fe40000000f00ULL,
0x0000c34000347802ULL, 0x000fc40000000f00ULL, 0x0001a0b000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000ffff3a7224ULL, 0x004fe200078e0036ULL,
0x000000187c3b7810ULL, 0x002fe40007ffe0ffULL, 0x0000c39000347802ULL, 0x000fc40000000f00ULL,
0x0001a06000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000a80086347811ULL, 0x000fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000008554783bULL, 0x000fe20000004200ULL, 0x0000a80081387811ULL, 0x000fe200078e20ffULL,
0x0000035000017945ULL, 0x000fe20003800000ULL, 0x000000ff4000720cULL, 0x000fe20003fc5270ULL,
0x000000003434783bULL, 0x00ae680000000200ULL, 0x00000000845c783bULL, 0x000fe80000004200ULL,
0x000000008364783bULL, 0x000fe80000004200ULL, 0x00000000823c783bULL, 0x000fe80000004200ULL,
0x000000003838783bULL, 0x004ea80000000200ULL, 0x000000008040783bULL, 0x000ee80000004200ULL,
0x000000007f44783bULL, 0x000f280000004200ULL, 0x000000007e48783bULL, 0x000ee80000004200ULL,
0x000000007d4c783bULL, 0x000ee20000004200ULL, 0x000000273434b231ULL, 0x002fc400003400ffULL,
0x000000273636b231ULL, 0x000fe400003400ffULL, 0x000000263535b231ULL, 0x080fe400003400ffULL,
0x000000263737b231ULL, 0x000fce00003400ffULL, 0x000000543450723cULL, 0x000f6200000418ffULL,
0x000000273838b231ULL, 0x084fe400003400ffULL, 0x000000273a3ab231ULL, 0x000fe400003400ffULL,
0x000000263939b231ULL, 0x000fc600003400ffULL, 0x0000005c3458723cULL, 0x000fe200000418ffULL,
0x000000263b3bb231ULL, 0x000fce00003400ffULL, 0x000000643460723cULL, 0x040ff000000418ffULL,
0x000000563454723cULL, 0x040f7000000418ffULL, 0x0000005e345c723cULL, 0x040f7000000418ffULL,
0x000000663464723cULL, 0x040f7000000418ffULL, 0x0000003c3468723cULL, 0x040f7000000418ffULL,
0x0000003e3434723cULL, 0x000f7000000418ffULL, 0x000000403850723cULL, 0x068b700000041850ULL,
0x000000423854723cULL, 0x040b700000041854ULL, 0x000000443858723cULL, 0x050b700000041858ULL,
0x00000046385c723cULL, 0x040b70000004185cULL, 0x000000483860723cULL, 0x040b700000041860ULL,
0x0000004a3864723cULL, 0x040b700000041864ULL, 0x0000004c3868723cULL, 0x040b700000041868ULL,
0x0000004e3834723cULL, 0x000b620000041834ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x000000501d1d7221ULL, 0x020fe20000010000ULL,
0x000000511c1c7221ULL, 0x000fe20000010000ULL, 0x0000005419197221ULL, 0x000fe20000010000ULL,
0x0000005518187221ULL, 0x000fe20000010000ULL, 0x0000005815157221ULL, 0x000fe20000010000ULL,
0x0000005914147221ULL, 0x000fe20000010000ULL, 0x0000005c11117221ULL, 0x000fe20000010000ULL,
0x0000005d10107221ULL, 0x000fe20000010000ULL, 0x000000600d0d7221ULL, 0x000fe20000010000ULL,
0x000000610c0c7221ULL, 0x000fe20000010000ULL, 0x0000006409097221ULL, 0x000fe20000010000ULL,
0x0000006508087221ULL, 0x000fe20000010000ULL, 0x0000006805057221ULL, 0x000fe20000010000ULL,
0x0000006904047221ULL, 0x000fe20000010000ULL, 0x0000003433337221ULL, 0x000fe20000010000ULL,
0x000000356c6c7221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000001947ULL, 0x000fea0000000000ULL,
0x000000521b1b7221ULL, 0x020fe20000010000ULL, 0x000000531a1a7221ULL, 0x000fe20000010000ULL,
0x0000005617177221ULL, 0x000fe20000010000ULL, 0x0000005716167221ULL, 0x000fe20000010000ULL,
0x0000005a13137221ULL, 0x000fe20000010000ULL, 0x0000005b12127221ULL, 0x000fe20000010000ULL,
0x0000005e0f0f7221ULL, 0x000fe20000010000ULL, 0x0000005f0e0e7221ULL, 0x000fe20000010000ULL,
0x000000620b0b7221ULL, 0x000fe20000010000ULL, 0x000000630a0a7221ULL, 0x000fe20000010000ULL,
0x0000006607077221ULL, 0x000fe20000010000ULL, 0x0000006706067221ULL, 0x000fe20000010000ULL,
0x0000006a31317221ULL, 0x000fe20000010000ULL, 0x0000006b32327221ULL, 0x000fe20000010000ULL,
0x000000366d6d7221ULL, 0x000fe20000010000ULL, 0x000000376e6e7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000188887810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b8800ff347f8cULL, 0x020e62000c80043fULL,
0x000000878800720cULL, 0x000fe20003f06070ULL, 0x000000ffff3c7224ULL, 0x002fd800078e0035ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffb0c000007947ULL, 0x000fea000383ffffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000807a347811ULL, 0x000fe200078e40ffULL,
0x014b6000ffff7f8cULL, 0x000fe6000c80043fULL, 0x000000753400720cULL, 0x000fda0003f06070ULL,
0x00009f9000000947ULL, 0x000fea0003800000ULL, 0x000000ffff887224ULL, 0x000fca00078e00ffULL,
0x00000002ff357819ULL, 0x000fe20000011688ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000000388367812ULL, 0x040fe200078ec0ffULL, 0x000000ffff3e7224ULL, 0x000fe200078e00ffULL,
0x0000003588357207ULL, 0x000fe40002800000ULL, 0x000000ff36367207ULL, 0x000fe40006800000ULL,
0x0000000235377810ULL, 0x000fc80007ffe0ffULL, 0x00000002ff397819ULL, 0x000fe40000011637ULL,
0x0000000337357812ULL, 0x000fc600078ec0ffULL, 0x0000030039347a24ULL, 0x000fc400078e027aULL,
0x0000000000387805ULL, 0x000fca0000015200ULL, 0x014b7c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe40007804889ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000017945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fc80007f1e1ffULL,
0x0000003b393b7210ULL, 0x000fe400007fe5ffULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078110ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x014b7c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe40007804889ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fc40000015200ULL, 0x014b8c00ff3b7984ULL, 0x000e640000000800ULL,
0x800000003bff7812ULL, 0x002fe4000780483cULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff3e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL, 0x000000013b3b7824ULL, 0x000fe200000e0e39ULL,
0x003d09003d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3a7819ULL, 0x000fc8000001143bULL, 0x0000003d3a3a7211ULL, 0x000fca00078110ffULL,
0x000000ffff3b7224ULL, 0x000fca00000e063bULL, 0x000000023a3a7819ULL, 0x000fc8000000123bULL,
0x0000003a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x014b8c00ff3b7984ULL, 0x000e640000000800ULL, 0x800000003bff7812ULL, 0x002fe4000780483cULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000134397810ULL, 0x040fe20007ffe0ffULL,
0x0000121000017945ULL, 0x000fe20003800000ULL, 0x0000003534387211ULL, 0x000fe400078e10ffULL,
0x000000743900720cULL, 0x000fe40003f06070ULL, 0x00000020383b7811ULL, 0x000fc800078e30ffULL,
0x0000006070397812ULL, 0x000fce00078ef83bULL, 0x0000098000008947ULL, 0x000fea0003800000ULL,
0x00000004723f7824ULL, 0x040fe200078e00ffULL, 0x0000020000417802ULL, 0x000fe20000000f00ULL,
0x00000001723c7824ULL, 0x040fe400078e0239ULL, 0x0000000172407824ULL, 0x040fe200078e0203ULL,
0x014a00003f387984ULL, 0x000e620000000800ULL, 0x0000002072457824ULL, 0x000fca00078e00ffULL,
0xffffffe045407812ULL, 0x000fc800078ee240ULL, 0x0001000040457811ULL, 0x000fe400078e20ffULL,
0x0000000172407810ULL, 0x000fca0007ffe0ffULL, 0x0000000140427824ULL, 0x040fe400078e0203ULL,
0x0000002040477824ULL, 0x000fca00078e00ffULL, 0xffffffe047427812ULL, 0x000fe200078ee242ULL,
0x00000004383d7824ULL, 0x002fe200078e00ffULL, 0x0000003b75387217ULL, 0x000fc80007800000ULL,
0x014ac0003d3a7984ULL, 0x000e620000000800ULL, 0x00000001383b7824ULL, 0x000fe400078e0a3bULL,
0x0000001003387824ULL, 0x000fc600078e00ffULL, 0x0000003b723b7217ULL, 0x000fe40007800000ULL,
0x000001f038437812ULL, 0x000fc600078ec0ffULL, 0x000000013b3e7824ULL, 0x000fca00078e0a72ULL,
0x000000ff3e00720cULL, 0x000fe20003f03070ULL, 0x0000003a213a7224ULL, 0x002fc800078e023cULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe20007f3e0ffULL,
0x00000001403a7824ULL, 0x000fe200078e0239ULL, 0x0000000272407810ULL, 0x000fe40007ffe0ffULL,
0x0000003bff3d7210ULL, 0x000fc60000ffe4ffULL, 0x0000002040477824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000013e00780cULL, 0x000fc60003f03070ULL, 0x014a04003f387984ULL, 0x000ea20000000800ULL,
0x0001000042457811ULL, 0x002fe200078e20ffULL, 0x0000000140427824ULL, 0x000fca00078e0203ULL,
0xffffffe047427812ULL, 0x000fe200078ee242ULL, 0x0000000438387824ULL, 0x004fcc00078e00ffULL,
0x014ac00038387984ULL, 0x000e640000000800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe20007f3e0ffULL,
0x00000001403a7824ULL, 0x000fe200078e0239ULL, 0x0000000372407810ULL, 0x000fe40007ffe0ffULL,
0x0000003bff3d7210ULL, 0x000fc60000ffe4ffULL, 0x0000002040477824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000023e00780cULL, 0x000fc60003f03070ULL, 0x014a08003f387984ULL, 0x000ea20000000800ULL,
0x0001000042457811ULL, 0x002fe200078e20ffULL, 0x0000000140427824ULL, 0x000fca00078e0203ULL,
0xffffffe047427812ULL, 0x000fe200078ee242ULL, 0x0000000438387824ULL, 0x004fcc00078e00ffULL,
0x014ac00038387984ULL, 0x000e640000000800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe20007f3e0ffULL,
0x00000001403a7824ULL, 0x000fe200078e0239ULL, 0x0000000472407810ULL, 0x000fe40007ffe0ffULL,
0x0000003bff3d7210ULL, 0x000fc60000ffe4ffULL, 0x0000002040477824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000033e00780cULL, 0x000fc60003f03070ULL, 0x014a0c003f387984ULL, 0x000ea20000000800ULL,
0x0001000042457811ULL, 0x002fe200078e20ffULL, 0x0000000140427824ULL, 0x000fca00078e0203ULL,
0xffffffe047427812ULL, 0x000fe200078ee242ULL, 0x0000000438387824ULL, 0x004fcc00078e00ffULL,
0x014ac00038387984ULL, 0x000e640000000800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe20007f3e0ffULL,
0x00000001403a7824ULL, 0x000fe200078e0239ULL, 0x0000000572407810ULL, 0x000fe40007ffe0ffULL,
0x0000003bff3d7210ULL, 0x000fc60000ffe4ffULL, 0x0000002040477824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000043e00780cULL, 0x000fc60003f03070ULL, 0x014a10003f387984ULL, 0x000ea20000000800ULL,
0x0001000042457811ULL, 0x002fe200078e20ffULL, 0x0000000140427824ULL, 0x000fca00078e0203ULL,
0xffffffe047427812ULL, 0x000fe200078ee242ULL, 0x0000000438387824ULL, 0x004fcc00078e00ffULL,
0x014ac00038387984ULL, 0x000e640000000800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe20007f3e0ffULL,
0x00000001403a7824ULL, 0x000fe200078e0239ULL, 0x0000000672407810ULL, 0x000fe40007ffe0ffULL,
0x0000003bff3d7210ULL, 0x000fc60000ffe4ffULL, 0x0000002040477824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000053e00780cULL, 0x000fc60003f03070ULL, 0x014a14003f387984ULL, 0x000ea20000000800ULL,
0x0001000042457811ULL, 0x002fe200078e20ffULL, 0x0000000140427824ULL, 0x000fca00078e0203ULL,
0xffffffe047427812ULL, 0x000fe200078ee242ULL, 0x0000000438387824ULL, 0x004fcc00078e00ffULL,
0x014ac00038387984ULL, 0x000e640000000800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe20007f3e0ffULL,
0x00000001403a7824ULL, 0x000fe200078e0239ULL, 0x0000000772407810ULL, 0x000fe40007ffe0ffULL,
0x0000003bff3d7210ULL, 0x000fc60000ffe4ffULL, 0x0000000140397824ULL, 0x000fe400078e0239ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000063e00780cULL, 0x000fc60003f03070ULL, 0x014a18003f387984ULL, 0x000ea20000000800ULL,
0x00010000423d7811ULL, 0x002fe200078e20ffULL, 0x0000000140427824ULL, 0x000fe400078e0203ULL,
0x0000000438387824ULL, 0x004fcc00078e00ffULL, 0x014ac00038387984ULL, 0x000e640000000800ULL,
0x00000038213a7224ULL, 0x002fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0041ULL,
0x000000433a3a7210ULL, 0x000fc80007f3e0ffULL, 0x0000003bff3b7210ULL, 0x000fca0000ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e2000c101c46ULL,
0x000000073e00780cULL, 0x000fc60003f03070ULL, 0x014a1c003f387984ULL, 0x000ea40000000800ULL,
0x00000004383c7824ULL, 0x004fca00078e00ffULL, 0x014ac0003c387984ULL, 0x000ea40000000800ULL,
0x0000003821387224ULL, 0x004fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fc800078e0041ULL,
0x0000002040417824ULL, 0x000fe200078e00ffULL, 0x0000004338387210ULL, 0x000fc80007f3e0ffULL,
0xffffffe041427812ULL, 0x000fe400078ee242ULL, 0x00000039ff397210ULL, 0x000fe40000ffe4ffULL,
0x00010000423b7811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e2000c101c46ULL, 0x0000083000007947ULL, 0x000fea0003800000ULL,
0x0000007203407211ULL, 0x040fe200078fd8ffULL, 0x00000010033b7824ULL, 0x000fe400078e00ffULL,
0x00000200ff417424ULL, 0x000fe200078e00ffULL, 0x00000005403e7819ULL, 0x040fe200000006ffULL,
0x014a000040387984ULL, 0x000e620000004800ULL, 0x00000001403a7824ULL, 0x040fe200078e0239ULL,
0x000001f03b437812ULL, 0x000fe200078ec0ffULL, 0x00000001403d7824ULL, 0x000fe200078e0203ULL,
0x014ac00038387984ULL, 0x002e640000004800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe40007f1e0ffULL,
0xffffffe03e3a7812ULL, 0x000fe400078ee23dULL, 0x00000001403e7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fe200000e063bULL, 0x000100003a457811ULL, 0x000fc600078e20ffULL,
0x000000013e3a7824ULL, 0x040fe400078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e2000b901c46ULL, 0x000000013e3f7824ULL, 0x040fe400078e0203ULL,
0x000000203e427824ULL, 0x000fe200078e00ffULL, 0x014a040040387984ULL, 0x000ea20000004800ULL,
0x00000002403c7810ULL, 0x002fca0007ffe0ffULL, 0x000000013c3d7824ULL, 0x000fe200078e0203ULL,
0x014ac00038387984ULL, 0x004e640000004800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3e7210ULL, 0x000fe40007f1e0ffULL,
0xffffffe0423a7812ULL, 0x000fe200078ee23fULL, 0x000000203c427824ULL, 0x000fe200078e00ffULL,
0x0000003bff3f7210ULL, 0x000fe400007fe4ffULL, 0x000100003a457811ULL, 0x000fe200078e20ffULL,
0x000000013c3a7824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e457faeULL, 0x0003e8000b901c46ULL, 0x014a080040387984ULL, 0x000ea20000004800ULL,
0x00000003403e7810ULL, 0x002fca0007ffe0ffULL, 0x000000013e3f7824ULL, 0x000fe200078e0203ULL,
0x014ac00038387984ULL, 0x004e640000004800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe40007f1e0ffULL,
0xffffffe0423a7812ULL, 0x000fe200078ee23dULL, 0x000000203e427824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fe200000e063bULL, 0x000100003a457811ULL, 0x000fe400078e20ffULL,
0x000000393e3a7210ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x014a0c0040387984ULL, 0x000ea20000004800ULL,
0x00000004403c7810ULL, 0x002fc80007ffe0ffULL, 0x000000033c3d7210ULL, 0x000fe20007ffe0ffULL,
0x014ac00038387984ULL, 0x004e640000004800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3e7210ULL, 0x000fe40007f1e0ffULL,
0xffffffe0423a7812ULL, 0x000fe200078ee23fULL, 0x000000203c427824ULL, 0x000fe400078e00ffULL,
0x000000ffff3f7224ULL, 0x000fe200000e063bULL, 0x000100003a457811ULL, 0x000fe200078e20ffULL,
0x000000013c3a7824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e457faeULL, 0x0003e8000b901c46ULL, 0x014a100040387984ULL, 0x000ea20000004800ULL,
0x00000005403e7810ULL, 0x002fca0007ffe0ffULL, 0x000000013e3f7824ULL, 0x000fe200078e0203ULL,
0x014ac00038387984ULL, 0x004e640000004800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe40007f1e0ffULL,
0xffffffe0423a7812ULL, 0x000fe400078ee23dULL, 0x000000053e427819ULL, 0x000fe200000006ffULL,
0x000000ffff3d7224ULL, 0x000fe200000e063bULL, 0x000100003a457811ULL, 0x000fe200078e20ffULL,
0x000000013e3a7824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x014a140040387984ULL, 0x000ea20000004800ULL,
0x00000006403c7810ULL, 0x002fca0007ffe0ffULL, 0x000000203c457824ULL, 0x000fe200078e00ffULL,
0x014ac00038387984ULL, 0x004e640000004800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3e7210ULL, 0x000fe40007f1e0ffULL,
0xffffffe0423a7812ULL, 0x000fe200078ee23fULL, 0x000000013c427824ULL, 0x000fe400078e0203ULL,
0x000000ffff3f7224ULL, 0x000fe200000e063bULL, 0x000100003a3d7811ULL, 0x000fe200078e20ffULL,
0x000000013c3a7824ULL, 0x000fe200078e0239ULL, 0xffffffe045427812ULL, 0x000fc600078ee242ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e3d7faeULL, 0x0003e8000b901c46ULL,
0x014a180040387984ULL, 0x000ea20000004800ULL, 0x00010000423d7811ULL, 0x002fe400078e20ffULL,
0x00000007403e7810ULL, 0x000fca0007ffe0ffULL, 0x000000013e397824ULL, 0x040fe400078e0239ULL,
0x000000013e3f7824ULL, 0x040fe400078e0203ULL, 0x000000203e3e7824ULL, 0x000fca00078e00ffULL,
0xffffffe03e3f7812ULL, 0x000fc800078ee23fULL, 0x000100003f3f7811ULL, 0x000fe200078e20ffULL,
0x014ac00038387984ULL, 0x004e640000004800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3a7210ULL, 0x000fc80007f1e0ffULL,
0x0000003bff3b7210ULL, 0x000fca00007fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a3d7faeULL, 0x0003e8000b901c46ULL, 0x014a1c00403c7984ULL, 0x000ea80000004800ULL,
0x014ac0003c3c7984ULL, 0x004ea40000004800ULL, 0x0000003c21397224ULL, 0x004fc800078e0239ULL,
0x00005e0039387625ULL, 0x000fca00078e0041ULL, 0x0000004338387210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff397224ULL, 0x000fca00000e0639ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383f7faeULL, 0x0003e6000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b8800ff387f8cULL, 0x002e64000c80043fULL,
0x00000039003f7202ULL, 0x002fc40000000f00ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x014b8c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe4000780483fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078110ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x014b8c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe4000780483fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000347300720cULL, 0x000fe20003f04070ULL, 0x0000019000017945ULL, 0x000fe20003800000ULL,
0x0000000137377812ULL, 0x000fe400078ec0ffULL, 0x000000033600780cULL, 0x000fc80004705270ULL,
0x000000013700780cULL, 0x000fda0000705470ULL, 0x0000014000000947ULL, 0x000fea0003800000ULL,
0x000000032300780cULL, 0x000fe20003f24070ULL, 0x00000300ff377624ULL, 0x000fe200078e00ffULL,
0x0000000171387812ULL, 0x000fc800078ec0ffULL, 0x000000013800780cULL, 0x000fe40003f05070ULL,
0xffffffff37377811ULL, 0x000fc800078e08ffULL, 0x0000000137387807ULL, 0x000fc80004000000ULL,
0x0000003871717210ULL, 0x000fe20007ffe0ffULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x0000000400377824ULL, 0x000fe200078e0223ULL, 0x0000640071387a10ULL, 0x040fe20007ffe0ffULL,
0x00000004ff397424ULL, 0x000fe200078e00ffULL, 0x000000767100720cULL, 0x000fe20003f06070ULL,
0x0000000237377824ULL, 0x000fc800078e00ffULL, 0x0000640037387a24ULL, 0x000fe200078e0238ULL,
0x00014ac023377811ULL, 0x000fc600078e10ffULL, 0x0000600038387625ULL, 0x000fca00078e0039ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000038377faeULL, 0x0003e4000c121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000019000017945ULL, 0x000fe20003800000ULL,
0x0000017000004947ULL, 0x000fea0003800000ULL, 0x000000347300720cULL, 0x000fe40003f04070ULL,
0x0000000136367810ULL, 0x000fc80007ffe0ffULL, 0x0000000336377812ULL, 0x002fce00078ec0ffULL,
0x00000002ff368819ULL, 0x000fca0000011636ULL, 0x0000000135357824ULL, 0x000fe200078e0236ULL,
0x000000ff37367207ULL, 0x000fe40004000000ULL, 0x00014a0023377811ULL, 0x000fe400078e10ffULL,
0x00000002ff397819ULL, 0x000fe40000011635ULL, 0x0000000635357819ULL, 0x000fc600000006ffULL,
0x0000030039397a24ULL, 0x000fe200078e0234ULL, 0x000000c035347812ULL, 0x000fe200078ec0ffULL,
0x00000004ff357424ULL, 0x000fc800078e00ffULL, 0x0000010039397824ULL, 0x000fe400078e0234ULL,
0x0000000177347824ULL, 0x000fe400078e0236ULL, 0x0000000123367824ULL, 0x100fe400078e0239ULL,
0x0000680034347a24ULL, 0x000fc600078e0239ULL, 0x000000753600720cULL, 0x000fe40003f06070ULL,
0x0000003423347210ULL, 0x000fca0007ffe0ffULL, 0x0000660034347625ULL, 0x000fcc00078e0035ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034377faeULL, 0x0003e4000c121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x014b8000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b8000ff347f8cULL, 0x000e62000c80043fULL,
0x000000ff8800720cULL, 0x000fe20003f05270ULL, 0x000007e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff897224ULL, 0x002fd600078e0035ULL, 0x000007b000000947ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b180072347f8cULL, 0x000e64000c80043fULL,
0x000000ffff3b7224ULL, 0x002fc400078e0035ULL, 0x0000000000347805ULL, 0x000fca0000015200ULL,
0x014b1c0072247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fe4000780483bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000027945ULL, 0x000fe20003800000ULL,
0x000000ffff387224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000037945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fcc0000015200ULL, 0x0000003634397210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003900780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403900780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff247819ULL, 0x000fc80000011437ULL,
0x0000003924247211ULL, 0x000fc800078110ffULL, 0x00000037ff377210ULL, 0x000fc800007fe4ffULL,
0x0000000224247819ULL, 0x000fc80000001237ULL, 0x000000240000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000138387810ULL, 0x000fc40007ffe0ffULL,
0x0000000000037941ULL, 0x000fea0003800000ULL, 0x014b1c0072247984ULL, 0x000e640000000800ULL,
0x8000000024ff7812ULL, 0x002fe4000780483bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000001003247824ULL, 0x000fe200078e00ffULL, 0x00000001ff347819ULL, 0x000fc80000011603ULL,
0x0000007024247812ULL, 0x000fe400078ec0ffULL, 0x0000000c34357812ULL, 0x000fca00078ec0ffULL,
0x00000001243b7824ULL, 0x000fca00078e0235ULL, 0x014100003b367984ULL, 0x000e680000000800ULL,
0x014300003b377984ULL, 0x0004e20000000800ULL, 0x0000006f3600720bULL, 0x002fe20003f1d000ULL,
0x00016e527f007947ULL, 0x000fd8000b800000ULL, 0x0000000000247806ULL, 0x004fc800000e0100ULL,
0x0000ffff243c7812ULL, 0x000fe2000780c0ffULL, 0x0000043000027945ULL, 0x000fe20003800000ULL,
0x00000001ff247424ULL, 0x000fe200078e00ffULL, 0x0000006f00387202ULL, 0x000fd40000000f00ULL,
0x000003f000008947ULL, 0x000fea0003800000ULL, 0x000000027800780cULL, 0x000fe40003f05270ULL,
0x0000006f3600720bULL, 0x000fe20003f34000ULL, 0x00016e127f007947ULL, 0x000fd8000b800000ULL,
0x0000000000397806ULL, 0x000fc400008e0100ULL, 0x000000366f387209ULL, 0x000fe20007810000ULL,
0x0000033000037945ULL, 0x000fe20003800000ULL, 0x0000991039347816ULL, 0x000fc600000000ffULL,
0x014500383b008388ULL, 0x0003e20000000800ULL, 0x000000ff3400720cULL, 0x000fda0003f05270ULL,
0x000002e000008947ULL, 0x000fea0003800000ULL, 0x800000386f347221ULL, 0x002fe20000010000ULL,
0x000000ff39ff7812ULL, 0x000fe2000780c0ffULL, 0x0000017000047945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b34347820ULL, 0x000fc80000410000ULL, 0x00000034003d7308ULL, 0x000e640000000800ULL,
0x0000003d1e1e7220ULL, 0x002fc80000410000ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x00016d627f007947ULL, 0x000fea000b800000ULL, 0x00001f7c3d347589ULL, 0x0002a400000e0000ULL,
0x000000341d1d7220ULL, 0x084fe20000410000ULL, 0x000000341c1c7220ULL, 0x080fe20000410000ULL,
0x0000003419197220ULL, 0x080fe20000410000ULL, 0x0000003418187220ULL, 0x080fe20000410000ULL,
0x0000003415157220ULL, 0x080fe20000410000ULL, 0x0000003414147220ULL, 0x080fe20000410000ULL,
0x0000003411117220ULL, 0x080fe20000410000ULL, 0x0000003410107220ULL, 0x080fe20000410000ULL,
0x000000340d0d7220ULL, 0x080fe20000410000ULL, 0x000000340c0c7220ULL, 0x080fe20000410000ULL,
0x0000003409097220ULL, 0x080fe20000410000ULL, 0x0000003408087220ULL, 0x080fe20000410000ULL,
0x0000003405057220ULL, 0x080fe20000410000ULL, 0x0000003404047220ULL, 0x080fe20000410000ULL,
0x0000003433337220ULL, 0x080fe20000410000ULL, 0x000000346c6c7220ULL, 0x000fc40000410000ULL,
0x0000000000047941ULL, 0x000fea0003800000ULL, 0x0000ff0039ff7812ULL, 0x000fda000780c0ffULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00016c727f007947ULL, 0x000fea000b800000ULL,
0x00001f7b3d347589ULL, 0x00046400000e0000ULL, 0x000000341b1b7220ULL, 0x082fe20000410000ULL,
0x000000341a1a7220ULL, 0x080fe20000410000ULL, 0x0000003417177220ULL, 0x080fe20000410000ULL,
0x0000003416167220ULL, 0x080fe20000410000ULL, 0x0000003413137220ULL, 0x080fe20000410000ULL,
0x0000003412127220ULL, 0x080fe20000410000ULL, 0x000000340f0f7220ULL, 0x080fe20000410000ULL,
0x000000340e0e7220ULL, 0x080fe20000410000ULL, 0x000000340b0b7220ULL, 0x080fe20000410000ULL,
0x000000340a0a7220ULL, 0x080fe20000410000ULL, 0x0000003407077220ULL, 0x080fe20000410000ULL,
0x0000003406067220ULL, 0x080fe20000410000ULL, 0x0000003431317220ULL, 0x080fe20000410000ULL,
0x0000003432327220ULL, 0x080fe20000410000ULL, 0x000000346d6d7220ULL, 0x080fe20000410000ULL,
0x000000346e6e7220ULL, 0x000fc40000410000ULL, 0x0000000000037941ULL, 0x002fea0003800000ULL,
0x0000ffff3cff7812ULL, 0x000fda0007806039ULL, 0x8000003836360221ULL, 0x000fe20000010000ULL,
0x00007610ff240816ULL, 0x000fc60000000024ULL, 0x3fb8aa3b36360820ULL, 0x000fc80000410000ULL,
0x0000003600250308ULL, 0x000e640000000800ULL, 0x0000002537370220ULL, 0x00afcc0000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000001e371e7221ULL, 0x008fe20000010000ULL,
0x000000ffff6f7224ULL, 0x000fc400078e0038ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ff24ff7812ULL, 0x000fe2000786c0ffULL, 0x0000012000017945ULL, 0x000fd80003800000ULL,
0x0000010000003947ULL, 0x000fea0003800000ULL, 0x00000025ff26723eULL, 0x000fc800000010ffULL,
0x0000541026367816ULL, 0x000fe20000000026ULL, 0x00016ab27f007947ULL, 0x000fea000b800000ULL,
0x00001f7c36277589ULL, 0x0002e400000e0000ULL, 0x00016af27f007947ULL, 0x000fea000b800000ULL,
0x00001f7b36267589ULL, 0x0002a400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000107c3b7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0036ULL,
0x0000f04000347802ULL, 0x000fc40000000f00ULL, 0x000173b000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000036003a7202ULL, 0x004fe40000000f00ULL,
0x000000187c3b7810ULL, 0x002fe40007ffe0ffULL, 0x0000f09000347802ULL, 0x000fc40000000f00ULL,
0x0001736000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000b00028347811ULL, 0x000fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000002954783bULL, 0x000fe20000004200ULL, 0x0000b0002c387811ULL, 0x000fe200078e20ffULL,
0x000003b000017945ULL, 0x000fe20003800000ULL, 0x000000887c00720cULL, 0x000fe20003f46070ULL,
0x000000003434783bULL, 0x002e620000000200ULL, 0x0000007a7300720cULL, 0x000fc40003fc3070ULL,
0x000000887b00720cULL, 0x000fe20003f26070ULL, 0x000000002a5c783bULL, 0x000fe20000004200ULL,
0x0000007a7300720cULL, 0x000fc60003f03070ULL, 0x000000002b64783bULL, 0x000fe80000004200ULL,
0x000000002d3c783bULL, 0x004fe80000004200ULL, 0x000000003838783bULL, 0x000ea80000000200ULL,
0x000000002e40783bULL, 0x000f280000004200ULL, 0x000000002f44783bULL, 0x000ee80000004200ULL,
0x000000003048783bULL, 0x000ee80000004200ULL, 0x00000000794c783bULL, 0x000ee40000004200ULL,
0x000000273434b231ULL, 0x00afc400003400ffULL, 0x000000273636b231ULL, 0x000fe400003400ffULL,
0x000000263535b231ULL, 0x080fe400003400ffULL, 0x000000263737b231ULL, 0x000fce00003400ffULL,
0x000000543450723cULL, 0x000f6200000418ffULL, 0x000000273838b231ULL, 0x084fe400003400ffULL,
0x000000273a3ab231ULL, 0x000fe400003400ffULL, 0x000000263939b231ULL, 0x000fc600003400ffULL,
0x0000005c3458723cULL, 0x000fe200000418ffULL, 0x000000263b3bb231ULL, 0x000fce00003400ffULL,
0x000000643460723cULL, 0x040ff000000418ffULL, 0x000000563454723cULL, 0x040f7000000418ffULL,
0x0000005e345c723cULL, 0x040f7000000418ffULL, 0x000000663464723cULL, 0x040f7000000418ffULL,
0x0000003c3468723cULL, 0x040b6e00000418ffULL, 0x00000001883c7810ULL, 0x020fe20007ffe0ffULL,
0x0000003e3434723cULL, 0x000f6600000418ffULL, 0x0000003c7c00720cULL, 0x000fc40005746470ULL,
0x0000003c7b00720cULL, 0x000fc60004f26470ULL, 0x000000403850723cULL, 0x050b700000041850ULL,
0x000000423854723cULL, 0x040b700000041854ULL, 0x000000443858723cULL, 0x040b700000041858ULL,
0x00000046385c723cULL, 0x040b70000004185cULL, 0x000000483860723cULL, 0x040b700000041860ULL,
0x0000004a3864723cULL, 0x040b700000041864ULL, 0x0000004c3868723cULL, 0x040b700000041868ULL,
0x0000004e3834723cULL, 0x020b620000041834ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x000000501d1d7221ULL, 0x000fe20000010000ULL,
0x000000511c1c7221ULL, 0x000fe20000010000ULL, 0x0000005419197221ULL, 0x000fe20000010000ULL,
0x0000005518187221ULL, 0x000fe20000010000ULL, 0x0000005815157221ULL, 0x000fe20000010000ULL,
0x0000005914147221ULL, 0x000fe20000010000ULL, 0x0000005c11117221ULL, 0x000fe20000010000ULL,
0x0000005d10107221ULL, 0x000fe20000010000ULL, 0x000000600d0d7221ULL, 0x000fe20000010000ULL,
0x000000610c0c7221ULL, 0x000fe20000010000ULL, 0x0000006409097221ULL, 0x000fe20000010000ULL,
0x0000006508087221ULL, 0x000fe20000010000ULL, 0x0000006805057221ULL, 0x000fe20000010000ULL,
0x0000006904047221ULL, 0x000fe20000010000ULL, 0x0000003433337221ULL, 0x020fe20000010000ULL,
0x000000356c6c7221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000001947ULL, 0x000fea0000000000ULL,
0x000000521b1b7221ULL, 0x000fe20000010000ULL, 0x000000531a1a7221ULL, 0x000fe20000010000ULL,
0x0000005617177221ULL, 0x000fe20000010000ULL, 0x0000005716167221ULL, 0x000fe20000010000ULL,
0x0000005a13137221ULL, 0x000fe20000010000ULL, 0x0000005b12127221ULL, 0x000fe20000010000ULL,
0x0000005e0f0f7221ULL, 0x000fe20000010000ULL, 0x0000005f0e0e7221ULL, 0x000fe20000010000ULL,
0x000000620b0b7221ULL, 0x000fe20000010000ULL, 0x000000630a0a7221ULL, 0x000fe20000010000ULL,
0x0000006607077221ULL, 0x000fe20000010000ULL, 0x0000006706067221ULL, 0x000fe20000010000ULL,
0x0000006a31317221ULL, 0x000fe20000010000ULL, 0x0000006b32327221ULL, 0x000fe20000010000ULL,
0x000000366d6d7221ULL, 0x020fe20000010000ULL, 0x000000376e6e7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x014b8800ff347f8cULL, 0x020e62000c80043fULL, 0x00000002ff377819ULL, 0x000fe2000001163cULL,
0x000000ffff3e7224ULL, 0x000fe200078e00ffULL, 0x0000007a7300720cULL, 0x000fc40003fc3070ULL,
0x000000373c377207ULL, 0x040fe40002800000ULL, 0x000000033c3c7812ULL, 0x000fe400078ec0ffULL,
0x0000000237377810ULL, 0x000fe40007ffe0ffULL, 0x0000007a7300720cULL, 0x000fe40003f03070ULL,
0x00000002ff397819ULL, 0x000fe40000011637ULL, 0x00000040ff407803ULL, 0x000fc40000000000ULL,
0x0000000337377812ULL, 0x000fe200078ec0ffULL, 0x000000ffff3f7224ULL, 0x002fe200078e0035ULL,
0x000000ff3c357207ULL, 0x000fe20006800000ULL, 0x0000030039347a24ULL, 0x000fc400078e027aULL,
0x0000000000387805ULL, 0x000fca0000015200ULL, 0x014b8400ff367984ULL, 0x000e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000036ff7812ULL, 0x002fe200078c4889ULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000103e00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007fde1ffULL,
0x000000013b3b7824ULL, 0x000fe200030e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc8000001143bULL,
0x0000003d36367211ULL, 0x000fca00078d10ffULL, 0x000000ffff3b7224ULL, 0x000fca00030e063bULL,
0x0000000236367819ULL, 0x000fc8000000123bULL, 0x000000360000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x014b8400ff367984ULL, 0x000e640000000800ULL,
0x8000000036ff7812ULL, 0x002fe400078c4889ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fc40000015200ULL, 0x014b8c00ff367984ULL, 0x000e620000000800ULL,
0x000000ff003c7202ULL, 0x000fe20000000f00ULL, 0x0000000000007918ULL, 0x000fe60000000000ULL,
0x8000000036ff7812ULL, 0x002fe200078c483fULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000103c00780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383d7210ULL, 0x000fca0007fde1ffULL, 0x000000013b3b7824ULL, 0x000fe200030e0e39ULL,
0x003d09003d00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff367819ULL, 0x000fc8000001143bULL, 0x0000003d36367211ULL, 0x000fca00078d10ffULL,
0x000000ffff3b7224ULL, 0x000fca00030e063bULL, 0x0000000236367819ULL, 0x000fc8000000123bULL,
0x000000360000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x014b8c00ff367984ULL, 0x000e640000000800ULL, 0x8000000036ff7812ULL, 0x002fe400078c483fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000001343b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000434367824ULL, 0x000fe200078e0237ULL, 0x0000120000017945ULL, 0x000fe40003800000ULL,
0x000000743b00720cULL, 0x000fe20003fc6070ULL, 0x00000040363f7824ULL, 0x000fca00078e00ffULL,
0x0000004070397812ULL, 0x000fce00078ef83fULL, 0x000009800000e947ULL, 0x000fea0003800000ULL,
0x0000000272417819ULL, 0x040fe200000006ffULL, 0x0000000172387824ULL, 0x040fe200078e0239ULL,
0x0000000172427810ULL, 0x000fe20007ffe0ffULL, 0x00000200ff437424ULL, 0x000fe400078e00ffULL,
0x014a000041367984ULL, 0x000e640000000800ULL, 0x00000004363e7824ULL, 0x002fca00078e00ffULL,
0x014ac0003e367984ULL, 0x000e640000000800ULL, 0x0000003621367224ULL, 0x002fe400078e0238ULL,
0x0000001003387824ULL, 0x000fe400078e00ffULL, 0x00005e00363a7625ULL, 0x000fe200078e0043ULL,
0x0000003f75367217ULL, 0x000fe40007800000ULL, 0x000001f038457812ULL, 0x000fc800078ec0ffULL,
0x000000453a3c7210ULL, 0x000fe20007fde0ffULL, 0x00000001423a7824ULL, 0x000fc600078e0239ULL,
0x0000003bff3d7210ULL, 0x000fe200037fe4ffULL, 0x00000001363b7824ULL, 0x000fe400078e0a3fULL,
0x0000000172367824ULL, 0x040fe400078e0203ULL, 0x00000020723f7824ULL, 0x040fe200078e00ffULL,
0x0000003b723b7217ULL, 0x000fc80007800000ULL, 0xffffffe03f387812ULL, 0x000fe200078ee236ULL,
0x000000013b367824ULL, 0x000fc600078e0a72ULL, 0x0000c00038477811ULL, 0x000fe400078e20ffULL,
0x000000ff3600720cULL, 0x000fda0003fc3070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c477faeULL, 0x0003e8000f101c46ULL, 0x014a040041387984ULL, 0x000ea40000000800ULL,
0x0000000238387819ULL, 0x004fcc00000006ffULL, 0x014ac00038387984ULL, 0x000ea40000000800ULL,
0x00000038213a7224ULL, 0x004fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0043ULL,
0x000000453a3e7210ULL, 0x000fe20007fde0ffULL, 0x00000001423a7824ULL, 0x000fc800078e0203ULL,
0x000000ffff3f7224ULL, 0x000fe200030e063bULL, 0x000000013600780cULL, 0x000fe20003fc3070ULL,
0x00000020423b7824ULL, 0x000fe200078e00ffULL, 0x0000000272427810ULL, 0x000fc80007ffe0ffULL,
0xffffffe03b3a7812ULL, 0x000fc800078ee23aULL, 0x0000c0003a477811ULL, 0x002fe200078e20ffULL,
0x00000001423a7824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e477faeULL, 0x0003e8000f101c46ULL, 0x014a080041387984ULL, 0x000ea40000000800ULL,
0x0000000238387819ULL, 0x004fcc00000006ffULL, 0x014ac00038387984ULL, 0x000ea40000000800ULL,
0x00000038213a7224ULL, 0x004fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0043ULL,
0x000000453a3c7210ULL, 0x000fe20007fde0ffULL, 0x00000001423a7824ULL, 0x000fc800078e0203ULL,
0x000000ffff3d7224ULL, 0x000fe200030e063bULL, 0x000000023600780cULL, 0x000fe20003fc3070ULL,
0x00000020423b7824ULL, 0x000fe200078e00ffULL, 0x0000000372427810ULL, 0x000fc80007ffe0ffULL,
0xffffffe03b3a7812ULL, 0x000fc800078ee23aULL, 0x0000c0003a477811ULL, 0x002fe200078e20ffULL,
0x00000001423a7824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c477faeULL, 0x0003e8000f101c46ULL, 0x014a0c0041387984ULL, 0x000ea40000000800ULL,
0x0000000238387819ULL, 0x004fcc00000006ffULL, 0x014ac00038387984ULL, 0x000ea40000000800ULL,
0x00000038213a7224ULL, 0x004fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0043ULL,
0x000000453a3e7210ULL, 0x000fe20007fde0ffULL, 0x00000001423a7824ULL, 0x000fc800078e0203ULL,
0x000000ffff3f7224ULL, 0x000fe200030e063bULL, 0x000000033600780cULL, 0x000fe20003fc3070ULL,
0x00000020423b7824ULL, 0x000fe200078e00ffULL, 0x0000000472427810ULL, 0x000fc80007ffe0ffULL,
0xffffffe03b3a7812ULL, 0x000fc800078ee23aULL, 0x0000c0003a477811ULL, 0x002fe200078e20ffULL,
0x00000001423a7824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e477faeULL, 0x0003e8000f101c46ULL, 0x014a100041387984ULL, 0x000ea40000000800ULL,
0x0000000238387819ULL, 0x004fcc00000006ffULL, 0x014ac00038387984ULL, 0x000ea40000000800ULL,
0x00000038213a7224ULL, 0x004fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0043ULL,
0x000000453a3c7210ULL, 0x000fe20007fde0ffULL, 0x00000001423a7824ULL, 0x000fc800078e0203ULL,
0x000000ffff3d7224ULL, 0x000fe200030e063bULL, 0x000000043600780cULL, 0x000fe20003fc3070ULL,
0x00000020423b7824ULL, 0x000fe200078e00ffULL, 0x0000000572427810ULL, 0x000fc80007ffe0ffULL,
0xffffffe03b3a7812ULL, 0x000fc800078ee23aULL, 0x0000c0003a477811ULL, 0x002fe200078e20ffULL,
0x00000001423a7824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c477faeULL, 0x0003e8000f101c46ULL, 0x014a140041387984ULL, 0x000ea20000000800ULL,
0x00000006723c7810ULL, 0x002fe40007ffe0ffULL, 0x0000000238387819ULL, 0x004fcc00000006ffULL,
0x014ac00038387984ULL, 0x000e640000000800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0043ULL, 0x000000453a3e7210ULL, 0x000fe20007fde0ffULL,
0x00000001423a7824ULL, 0x000fc800078e0203ULL, 0x000000ffff3f7224ULL, 0x000fe200030e063bULL,
0x000000053600780cULL, 0x000fe20003fc3070ULL, 0x00000020423b7824ULL, 0x000fe400078e00ffULL,
0x000000013c427824ULL, 0x000fc600078e0203ULL, 0xffffffe03b3a7812ULL, 0x000fc800078ee23aULL,
0x0000c0003a3d7811ULL, 0x000fe200078e20ffULL, 0x000000013c3a7824ULL, 0x000fc800078e0239ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e3d7faeULL, 0x0003e8000f101c46ULL,
0x014a180041387984ULL, 0x000ea20000000800ULL, 0x000000203c3d7824ULL, 0x002fe200078e00ffULL,
0x00000007723e7810ULL, 0x000fc80007ffe0ffULL, 0xffffffe03d427812ULL, 0x000fe200078ee242ULL,
0x000000013e397824ULL, 0x040fe400078e0239ULL, 0x000000013e3f7824ULL, 0x000fe200078e0203ULL,
0x0000c000423d7811ULL, 0x000fe200078e20ffULL, 0x000000203e3e7824ULL, 0x000fca00078e00ffULL,
0xffffffe03e3f7812ULL, 0x000fc800078ee23fULL, 0x0000c0003f3f7811ULL, 0x000fe400078e20ffULL,
0x0000000238387819ULL, 0x004fcc00000006ffULL, 0x014ac00038387984ULL, 0x000e640000000800ULL,
0x00000038213a7224ULL, 0x002fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0043ULL,
0x000000453a3a7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3b7224ULL, 0x000fe200030e063bULL,
0x000000063600780cULL, 0x000fda0003fc3070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a3d7faeULL, 0x0003e8000f101c46ULL, 0x014a1c0041387984ULL, 0x000ea40000000800ULL,
0x00000002383c7819ULL, 0x004fca00000006ffULL, 0x014ac0003c387984ULL, 0x000ea40000000800ULL,
0x0000003821387224ULL, 0x004fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e0043ULL,
0x0000004538387210ULL, 0x000fca0007fde0ffULL, 0x000000ffff397224ULL, 0x000fe200030e0639ULL,
0x000000073600780cULL, 0x000fda0003fc3070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383f7faeULL, 0x0003e2000f101c46ULL, 0x0000083000007947ULL, 0x000fea0003800000ULL,
0x0000007203427211ULL, 0x040fe200078fd8ffULL, 0x00000200ff417424ULL, 0x000fe400078e00ffULL,
0x00000010033c7824ULL, 0x000fe200078e00ffULL, 0x0000003942387210ULL, 0x040fe20007ffe0ffULL,
0x014a000042367984ULL, 0x000e620000004800ULL, 0x0000000142447810ULL, 0x000fe40007ffe0ffULL,
0x000001f03c437812ULL, 0x000fe200078ec0ffULL, 0x014ac00036367984ULL, 0x002e640000004800ULL,
0x0000003621387224ULL, 0x002fc800078e0238ULL, 0x00005e00383a7625ULL, 0x000fc800078e0041ULL,
0x0000000142387824ULL, 0x000fe200078e0203ULL, 0x000000433a3c7210ULL, 0x000fca0007fde0ffULL,
0x000000ffff3d7224ULL, 0x000fe200030e063bULL, 0x00000005423b7819ULL, 0x000fc800000006ffULL,
0xffffffe03b387812ULL, 0x000fc800078ee238ULL, 0x0000c00038457811ULL, 0x000fe200078e20ffULL,
0x0000000144387824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x014a040042367984ULL, 0x000ea80000004800ULL,
0x014ac00036367984ULL, 0x004ea40000004800ULL, 0x0000003621387224ULL, 0x004fc800078e0238ULL,
0x00005e00383a7625ULL, 0x000fc800078e0041ULL, 0x0000000144387824ULL, 0x000fe200078e0203ULL,
0x000000433a3e7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3f7224ULL, 0x000fe400030e063bULL,
0x00000020443b7824ULL, 0x000fe200078e00ffULL, 0x0000000242447810ULL, 0x000fc80007ffe0ffULL,
0xffffffe03b387812ULL, 0x000fc800078ee238ULL, 0x0000c00038457811ULL, 0x002fe400078e20ffULL,
0x0000003944387210ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e457faeULL, 0x0003e8000b901c46ULL, 0x014a080042367984ULL, 0x000ea80000004800ULL,
0x014ac00036367984ULL, 0x004ea40000004800ULL, 0x0000003621387224ULL, 0x004fc800078e0238ULL,
0x00005e00383a7625ULL, 0x000fc800078e0041ULL, 0x0000000144387824ULL, 0x000fe200078e0203ULL,
0x000000433a3c7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3d7224ULL, 0x000fe400030e063bULL,
0x00000020443b7824ULL, 0x000fe200078e00ffULL, 0x0000000342447810ULL, 0x000fc80007ffe0ffULL,
0xffffffe03b387812ULL, 0x000fc800078ee238ULL, 0x0000c00038457811ULL, 0x002fe200078e20ffULL,
0x0000000144387824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x014a0c0042367984ULL, 0x000ea80000004800ULL,
0x014ac00036367984ULL, 0x004ea40000004800ULL, 0x0000003621387224ULL, 0x004fc800078e0238ULL,
0x00005e00383a7625ULL, 0x000fc800078e0041ULL, 0x0000000144387824ULL, 0x000fe200078e0203ULL,
0x000000433a3e7210ULL, 0x000fc80007fde0ffULL, 0x0000003bff3f7210ULL, 0x000fe200037fe4ffULL,
0x00000020443b7824ULL, 0x000fe200078e00ffULL, 0x0000000442447810ULL, 0x000fc80007ffe0ffULL,
0xffffffe03b387812ULL, 0x000fc800078ee238ULL, 0x0000c00038457811ULL, 0x002fe200078e20ffULL,
0x0000000144387824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e457faeULL, 0x0003e8000b901c46ULL, 0x014a100042367984ULL, 0x000ea80000004800ULL,
0x014ac00036367984ULL, 0x004ea40000004800ULL, 0x0000003621387224ULL, 0x004fc800078e0238ULL,
0x00005e00383a7625ULL, 0x000fe200078e0041ULL, 0x0000000344387210ULL, 0x000fc80007ffe0ffULL,
0x000000433a3c7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3d7224ULL, 0x000fe400030e063bULL,
0x00000020443b7824ULL, 0x000fe200078e00ffULL, 0x0000000542447810ULL, 0x000fc80007ffe0ffULL,
0xffffffe03b387812ULL, 0x000fc800078ee238ULL, 0x0000c00038457811ULL, 0x002fe200078e20ffULL,
0x0000000144387824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x014a140042367984ULL, 0x000ea20000004800ULL,
0x00000006423c7810ULL, 0x002fca0007ffe0ffULL, 0x000000203c457824ULL, 0x000fe200078e00ffULL,
0x014ac00036367984ULL, 0x004e640000004800ULL, 0x0000003621387224ULL, 0x002fc800078e0238ULL,
0x00005e00383a7625ULL, 0x000fc800078e0041ULL, 0x0000000144387824ULL, 0x000fe200078e0203ULL,
0x000000433a3e7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3f7224ULL, 0x000fe200030e063bULL,
0x00000005443b7819ULL, 0x000fc800000006ffULL, 0xffffffe03b387812ULL, 0x000fc800078ee238ULL,
0x0000c000383d7811ULL, 0x000fe200078e20ffULL, 0x000000013c387824ULL, 0x000fc800078e0239ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e3d7faeULL, 0x0003e8000b901c46ULL,
0x014a180042367984ULL, 0x000ea80000004800ULL, 0x014ac00036367984ULL, 0x004ea40000004800ULL,
0x0000003621387224ULL, 0x004fc800078e0238ULL, 0x00005e00383a7625ULL, 0x000fc800078e0041ULL,
0x000000013c387824ULL, 0x000fe200078e0203ULL, 0x000000433a3a7210ULL, 0x000fe40007fde0ffULL,
0x00000007423c7810ULL, 0x000fe40007ffe0ffULL, 0xffffffe045387812ULL, 0x000fe200078ee238ULL,
0x000000ffff3b7224ULL, 0x000fe200030e063bULL, 0x000000393c397210ULL, 0x040fe20007ffe0ffULL,
0x000000013c3e7824ULL, 0x002fe200078e0203ULL, 0x0000c000383d7811ULL, 0x000fe200078e20ffULL,
0x000000203c3f7824ULL, 0x000fc800078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a3d7faeULL, 0x0003e2000b901c46ULL, 0xffffffe03f3e7812ULL, 0x000fc600078ee23eULL,
0x014a1c0042367984ULL, 0x000ea20000004800ULL, 0x0000c0003e3b7811ULL, 0x002fc600078e20ffULL,
0x014ac00036367984ULL, 0x004e640000004800ULL, 0x0000003621397224ULL, 0x002fc800078e0239ULL,
0x00005e0039387625ULL, 0x000fca00078e0041ULL, 0x0000004338387210ULL, 0x000fca0007fde0ffULL,
0x000000ffff397224ULL, 0x000fca00030e0639ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e6000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b8800ff387f8cULL, 0x002e64000c80043fULL,
0x000000ffff3f7224ULL, 0x002fc400078e0039ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x014b8c00ff367984ULL, 0x000e620000000800ULL, 0x000000ff003c7202ULL, 0x000fe20000000f00ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000036ff7812ULL, 0x002fe200078c483fULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007fde1ffULL,
0x000000013b3b7824ULL, 0x000fe200030e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc8000001143bULL,
0x0000003d36367211ULL, 0x000fca00078d10ffULL, 0x000000ffff3b7224ULL, 0x000fca00030e063bULL,
0x0000000236367819ULL, 0x000fc8000000123bULL, 0x000000360000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x014b8c00ff367984ULL, 0x000e640000000800ULL,
0x8000000036ff7812ULL, 0x002fe400078c483fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000018000017945ULL, 0x000fe20003800000ULL, 0x0000016000004947ULL, 0x000fea0003800000ULL,
0x000000347300720cULL, 0x000fe40003fc4070ULL, 0x00014a0023397811ULL, 0x000fe400078e10ffULL,
0x000000ff35367207ULL, 0x000fc40003000000ULL, 0x000000ff35387207ULL, 0x000fc60007000000ULL,
0x0000000137367824ULL, 0x000fe400078e0236ULL, 0x00000004ff377424ULL, 0x000fc600078e00ffULL,
0x00000002ff357819ULL, 0x000fe20000011636ULL, 0x0000004036367824ULL, 0x000fc800078e00ffULL,
0x0000030035357a24ULL, 0x000fe200078e0234ULL, 0x000000c036367812ULL, 0x000fe200078ec0ffULL,
0x0000000177347824ULL, 0x000fc600078e0238ULL, 0x0000003635357211ULL, 0x000fc800078e40ffULL,
0x0000002035357810ULL, 0x000fca0007ffe0ffULL, 0x0000000123367824ULL, 0x100fe400078e0235ULL,
0x0000680034347a24ULL, 0x000fc600078e0235ULL, 0x000000753600720cULL, 0x000fe20003fc6070ULL,
0x0000000123347824ULL, 0x000fc800078e0234ULL, 0x0000660034347625ULL, 0x000fd000078e0037ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034397faeULL, 0x0003e4000f121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x014b7800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b7800ff347f8cULL, 0x000e62000c80043fULL,
0x0000013000017945ULL, 0x000fe20003800000ULL, 0x0000003500897202ULL, 0x002fe20000000f00ULL,
0x0000010000003947ULL, 0x000fea0003800000ULL, 0x00000025ff26723eULL, 0x000fc800000010ffULL,
0x0000541026367816ULL, 0x000fe20000000026ULL, 0x000148927f007947ULL, 0x000fea000b800000ULL,
0x00001f7c36277589ULL, 0x0002a400000e0000ULL, 0x000148d27f007947ULL, 0x000fea000b800000ULL,
0x00001f7b36267589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000107c3b7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0036ULL,
0x0001132000347802ULL, 0x000fc40000000f00ULL, 0x000150d000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000ffff3a7224ULL, 0x004fe200078e0036ULL,
0x000000187c3b7810ULL, 0x002fe40007ffe0ffULL, 0x0001137000347802ULL, 0x000fc40000000f00ULL,
0x0001508000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000b00086347811ULL, 0x000fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000008554783bULL, 0x000fe20000004200ULL, 0x0000b00081387811ULL, 0x000fe200078e20ffULL,
0x0000035000017945ULL, 0x000fe20003800000ULL, 0x000000ff4000720cULL, 0x000fe20003fc5270ULL,
0x000000003434783bULL, 0x00ae680000000200ULL, 0x00000000845c783bULL, 0x000fe80000004200ULL,
0x000000008364783bULL, 0x000fe80000004200ULL, 0x00000000823c783bULL, 0x000fe80000004200ULL,
0x000000003838783bULL, 0x004ea80000000200ULL, 0x000000008040783bULL, 0x000ee80000004200ULL,
0x000000007f44783bULL, 0x000f280000004200ULL, 0x000000007e48783bULL, 0x000ee80000004200ULL,
0x000000007d4c783bULL, 0x000ee20000004200ULL, 0x000000273434b231ULL, 0x002fc400003400ffULL,
0x000000273636b231ULL, 0x000fe400003400ffULL, 0x000000263535b231ULL, 0x080fe400003400ffULL,
0x000000263737b231ULL, 0x000fce00003400ffULL, 0x000000543450723cULL, 0x000f6200000418ffULL,
0x000000273838b231ULL, 0x084fe400003400ffULL, 0x000000273a3ab231ULL, 0x000fe400003400ffULL,
0x000000263939b231ULL, 0x000fc600003400ffULL, 0x0000005c3458723cULL, 0x000fe200000418ffULL,
0x000000263b3bb231ULL, 0x000fce00003400ffULL, 0x000000643460723cULL, 0x040ff000000418ffULL,
0x000000563454723cULL, 0x040f7000000418ffULL, 0x0000005e345c723cULL, 0x040f7000000418ffULL,
0x000000663464723cULL, 0x040f7000000418ffULL, 0x0000003c3468723cULL, 0x040f7000000418ffULL,
0x0000003e3434723cULL, 0x000f7000000418ffULL, 0x000000403850723cULL, 0x068b700000041850ULL,
0x000000423854723cULL, 0x040b700000041854ULL, 0x000000443858723cULL, 0x050b700000041858ULL,
0x00000046385c723cULL, 0x040b70000004185cULL, 0x000000483860723cULL, 0x040b700000041860ULL,
0x0000004a3864723cULL, 0x040b700000041864ULL, 0x0000004c3868723cULL, 0x040b700000041868ULL,
0x0000004e3834723cULL, 0x000b620000041834ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x000000501d1d7221ULL, 0x020fe20000010000ULL,
0x000000511c1c7221ULL, 0x000fe20000010000ULL, 0x0000005419197221ULL, 0x000fe20000010000ULL,
0x0000005518187221ULL, 0x000fe20000010000ULL, 0x0000005815157221ULL, 0x000fe20000010000ULL,
0x0000005914147221ULL, 0x000fe20000010000ULL, 0x0000005c11117221ULL, 0x000fe20000010000ULL,
0x0000005d10107221ULL, 0x000fe20000010000ULL, 0x000000600d0d7221ULL, 0x000fe20000010000ULL,
0x000000610c0c7221ULL, 0x000fe20000010000ULL, 0x0000006409097221ULL, 0x000fe20000010000ULL,
0x0000006508087221ULL, 0x000fe20000010000ULL, 0x0000006805057221ULL, 0x000fe20000010000ULL,
0x0000006904047221ULL, 0x000fe20000010000ULL, 0x0000003433337221ULL, 0x000fe20000010000ULL,
0x000000356c6c7221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000001947ULL, 0x000fea0000000000ULL,
0x000000521b1b7221ULL, 0x020fe20000010000ULL, 0x000000531a1a7221ULL, 0x000fe20000010000ULL,
0x0000005617177221ULL, 0x000fe20000010000ULL, 0x0000005716167221ULL, 0x000fe20000010000ULL,
0x0000005a13137221ULL, 0x000fe20000010000ULL, 0x0000005b12127221ULL, 0x000fe20000010000ULL,
0x0000005e0f0f7221ULL, 0x000fe20000010000ULL, 0x0000005f0e0e7221ULL, 0x000fe20000010000ULL,
0x000000620b0b7221ULL, 0x000fe20000010000ULL, 0x000000630a0a7221ULL, 0x000fe20000010000ULL,
0x0000006607077221ULL, 0x000fe20000010000ULL, 0x0000006706067221ULL, 0x000fe20000010000ULL,
0x0000006a31317221ULL, 0x000fe20000010000ULL, 0x0000006b32327221ULL, 0x000fe20000010000ULL,
0x000000366d6d7221ULL, 0x000fe20000010000ULL, 0x000000376e6e7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000188887810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b8800ff347f8cULL, 0x020e62000c80043fULL,
0x000000878800720cULL, 0x000fe20003f06070ULL, 0x000000ffff3c7224ULL, 0x002fd800078e0035ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffb0c000007947ULL, 0x000fea000383ffffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000c07a347811ULL, 0x000fe200078e40ffULL,
0x014b6800ffff7f8cULL, 0x000fe6000c80043fULL, 0x000000753400720cULL, 0x000fda0003f06070ULL,
0x00004fb000000947ULL, 0x000fea0003800000ULL, 0x000000ff00887202ULL, 0x000fc80000000f00ULL,
0x00000002ff357819ULL, 0x000fe20000011688ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000000388367812ULL, 0x040fe200078ec0ffULL, 0x000000ffff3e7224ULL, 0x000fe200078e00ffULL,
0x0000003588357207ULL, 0x000fe40002800000ULL, 0x000000ff36367207ULL, 0x000fe40006800000ULL,
0x0000000335377810ULL, 0x000fc80007ffe0ffULL, 0x00000002ff397819ULL, 0x000fe40000011637ULL,
0x0000000337357812ULL, 0x000fc600078ec0ffULL, 0x0000030039347a24ULL, 0x000fc400078e027aULL,
0x0000000000387805ULL, 0x000fca0000015200ULL, 0x014b7c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe40007804889ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000017945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078110ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x014b7c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe40007804889ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fc40000015200ULL, 0x014b8c00ff3b7984ULL, 0x000e640000000800ULL,
0x800000003bff7812ULL, 0x002fe4000780483cULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff3e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383d7210ULL, 0x000fc80007f1e1ffULL, 0x0000003b393b7210ULL, 0x000fe400007fe5ffULL,
0x003d09003d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3a7819ULL, 0x000fc8000001143bULL, 0x0000003d3a3a7211ULL, 0x000fca00078110ffULL,
0x000000ffff3b7224ULL, 0x000fca00000e063bULL, 0x000000023a3a7819ULL, 0x000fc8000000123bULL,
0x0000003a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x014b8c00ff3b7984ULL, 0x000e640000000800ULL, 0x800000003bff7812ULL, 0x002fe4000780483cULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000134397810ULL, 0x040fe20007ffe0ffULL,
0x0000000434387824ULL, 0x000fe200078e0235ULL, 0x0000120000017945ULL, 0x000fe40003800000ULL,
0x000000743900720cULL, 0x000fe40003f06070ULL, 0x00000020383b7811ULL, 0x000fc800078e30ffULL,
0x0000006070397812ULL, 0x000fce00078ef83bULL, 0x0000098000008947ULL, 0x000fea0003800000ULL,
0x00000004723f7824ULL, 0x040fe200078e00ffULL, 0x00000039723c7210ULL, 0x040fe20007ffe0ffULL,
0x00000200ff417424ULL, 0x000fe400078e00ffULL, 0x0000000172407824ULL, 0x040fe200078e0203ULL,
0x014a00003f387984ULL, 0x000e620000000800ULL, 0x0000002072457824ULL, 0x000fca00078e00ffULL,
0xffffffe045407812ULL, 0x000fc800078ee240ULL, 0x0001000040457811ULL, 0x000fe400078e20ffULL,
0x0000000172407810ULL, 0x000fc80007ffe0ffULL, 0x0000000340427210ULL, 0x040fe20007ffe0ffULL,
0x0000002040477824ULL, 0x000fca00078e00ffULL, 0xffffffe047427812ULL, 0x000fe200078ee242ULL,
0x00000004383d7824ULL, 0x002fe200078e00ffULL, 0x0000003b75387217ULL, 0x000fc80007800000ULL,
0x014ac0003d3a7984ULL, 0x000e620000000800ULL, 0x00000001383b7824ULL, 0x000fe400078e0a3bULL,
0x0000001003387824ULL, 0x000fc600078e00ffULL, 0x0000003b723b7217ULL, 0x000fe40007800000ULL,
0x000001f038437812ULL, 0x000fe400078ec0ffULL, 0x0000003b723e7210ULL, 0x000fc80007ffe1ffULL,
0x000000ff3e00720cULL, 0x000fe20003f03070ULL, 0x0000003a213a7224ULL, 0x002fc800078e023cULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe20007f3e0ffULL,
0x00000001403a7824ULL, 0x000fe200078e0239ULL, 0x0000000272407810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fe400008e063bULL, 0x0000002040477824ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000013e00780cULL, 0x000fc60003f03070ULL, 0x014a04003f387984ULL, 0x000ea20000000800ULL,
0x0001000042457811ULL, 0x002fe400078e20ffULL, 0x0000000340427210ULL, 0x000fc80007ffe0ffULL,
0xffffffe047427812ULL, 0x000fe200078ee242ULL, 0x0000000438387824ULL, 0x004fcc00078e00ffULL,
0x014ac00038387984ULL, 0x000e640000000800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe20007f3e0ffULL,
0x00000001403a7824ULL, 0x000fe200078e0239ULL, 0x0000000372407810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fe400008e063bULL, 0x0000002040477824ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000023e00780cULL, 0x000fc60003f03070ULL, 0x014a08003f387984ULL, 0x000ea20000000800ULL,
0x0001000042457811ULL, 0x002fe400078e20ffULL, 0x0000000340427210ULL, 0x000fc80007ffe0ffULL,
0xffffffe047427812ULL, 0x000fe200078ee242ULL, 0x0000000438387824ULL, 0x004fcc00078e00ffULL,
0x014ac00038387984ULL, 0x000e640000000800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe20007f3e0ffULL,
0x00000001403a7824ULL, 0x000fe200078e0239ULL, 0x0000000472407810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fe400008e063bULL, 0x0000002040477824ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000033e00780cULL, 0x000fc60003f03070ULL, 0x014a0c003f387984ULL, 0x000ea20000000800ULL,
0x0001000042457811ULL, 0x002fe400078e20ffULL, 0x0000000340427210ULL, 0x000fc80007ffe0ffULL,
0xffffffe047427812ULL, 0x000fe200078ee242ULL, 0x0000000438387824ULL, 0x004fcc00078e00ffULL,
0x014ac00038387984ULL, 0x000e640000000800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe20007f3e0ffULL,
0x00000001403a7824ULL, 0x000fe200078e0239ULL, 0x0000000572407810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fe400008e063bULL, 0x0000002040477824ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000043e00780cULL, 0x000fc60003f03070ULL, 0x014a10003f387984ULL, 0x000ea20000000800ULL,
0x0001000042457811ULL, 0x002fe400078e20ffULL, 0x0000000340427210ULL, 0x000fc80007ffe0ffULL,
0xffffffe047427812ULL, 0x000fe200078ee242ULL, 0x0000000438387824ULL, 0x004fcc00078e00ffULL,
0x014ac00038387984ULL, 0x000e640000000800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe20007f3e0ffULL,
0x00000001403a7824ULL, 0x000fe200078e0239ULL, 0x0000000672407810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fe400008e063bULL, 0x0000002040477824ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000053e00780cULL, 0x000fc60003f03070ULL, 0x014a14003f387984ULL, 0x000ea20000000800ULL,
0x0001000042457811ULL, 0x002fe400078e20ffULL, 0x0000000340427210ULL, 0x000fc80007ffe0ffULL,
0xffffffe047427812ULL, 0x000fe200078ee242ULL, 0x0000000438387824ULL, 0x004fcc00078e00ffULL,
0x014ac00038387984ULL, 0x000e640000000800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe20007f3e0ffULL,
0x00000001403a7824ULL, 0x000fe200078e0239ULL, 0x0000000772407810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fe400008e063bULL, 0x0000000140397824ULL, 0x000fc600078e0239ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000063e00780cULL, 0x000fc60003f03070ULL, 0x014a18003f387984ULL, 0x000ea20000000800ULL,
0x00010000423d7811ULL, 0x002fe400078e20ffULL, 0x0000000340427210ULL, 0x000fe20007ffe0ffULL,
0x0000000438387824ULL, 0x004fcc00078e00ffULL, 0x014ac00038387984ULL, 0x000e640000000800ULL,
0x00000038213a7224ULL, 0x002fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0041ULL,
0x000000433a3a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fca00008e063bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e2000c101c46ULL,
0x000000073e00780cULL, 0x000fc60003f03070ULL, 0x014a1c003f387984ULL, 0x000ea40000000800ULL,
0x00000004383c7824ULL, 0x004fca00078e00ffULL, 0x014ac0003c387984ULL, 0x000ea40000000800ULL,
0x0000003821387224ULL, 0x004fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fc800078e0041ULL,
0x0000002040417824ULL, 0x000fe200078e00ffULL, 0x0000004338387210ULL, 0x000fc80007f3e0ffULL,
0xffffffe041427812ULL, 0x000fe200078ee242ULL, 0x000000ffff397224ULL, 0x000fc600008e0639ULL,
0x00010000423b7811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e2000c101c46ULL, 0x0000083000007947ULL, 0x000fea0003800000ULL,
0x0000007203407211ULL, 0x040fe200078fd8ffULL, 0x00000010033b7824ULL, 0x000fe200078e00ffULL,
0x0000020000417802ULL, 0x000fc60000000f00ULL, 0x014a000040387984ULL, 0x000e620000004800ULL,
0x00000001403a7824ULL, 0x040fe200078e0239ULL, 0x000001f03b437812ULL, 0x000fe200078ec0ffULL,
0x00000001403d7824ULL, 0x040fe400078e0203ULL, 0x00000020403e7824ULL, 0x000fe200078e00ffULL,
0x014ac00038387984ULL, 0x002e640000004800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe40007f1e0ffULL,
0xffffffe03e3a7812ULL, 0x000fe400078ee23dULL, 0x00000001403e7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fe200000e063bULL, 0x000100003a457811ULL, 0x000fe400078e20ffULL,
0x000000033e3f7210ULL, 0x040fe20007ffe0ffULL, 0x000000013e3a7824ULL, 0x040fe400078e0239ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000b901c46ULL,
0x000000203e427824ULL, 0x000fc600078e00ffULL, 0x014a040040387984ULL, 0x000ea20000004800ULL,
0x00000002403c7810ULL, 0x002fca0007ffe0ffULL, 0x000000013c3d7824ULL, 0x000fe200078e0203ULL,
0x014ac00038387984ULL, 0x004e640000004800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3e7210ULL, 0x000fe40007f1e0ffULL,
0xffffffe0423a7812ULL, 0x000fe400078ee23fULL, 0x000000053c427819ULL, 0x000fe200000006ffULL,
0x000000ffff3f7224ULL, 0x000fe200000e063bULL, 0x000100003a457811ULL, 0x000fe200078e20ffULL,
0x000000013c3a7824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e457faeULL, 0x0003e8000b901c46ULL, 0x014a080040387984ULL, 0x000ea20000004800ULL,
0x00000003403e7810ULL, 0x002fca0007ffe0ffULL, 0x000000013e3f7824ULL, 0x000fe200078e0203ULL,
0x014ac00038387984ULL, 0x004e640000004800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe40007f1e0ffULL,
0xffffffe0423a7812ULL, 0x000fe200078ee23dULL, 0x000000203e427824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fe200000e063bULL, 0x000100003a457811ULL, 0x000fe200078e20ffULL,
0x000000013e3a7824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x014a0c0040387984ULL, 0x000ea20000004800ULL,
0x00000004403c7810ULL, 0x002fca0007ffe0ffULL, 0x000000013c3d7824ULL, 0x000fe200078e0203ULL,
0x014ac00038387984ULL, 0x004e640000004800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3e7210ULL, 0x000fe40007f1e0ffULL,
0xffffffe0423a7812ULL, 0x000fe200078ee23fULL, 0x000000203c427824ULL, 0x000fe200078e00ffULL,
0x0000003bff3f7210ULL, 0x000fe400007fe4ffULL, 0x000100003a457811ULL, 0x000fe200078e20ffULL,
0x000000013c3a7824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e457faeULL, 0x0003e8000b901c46ULL, 0x014a100040387984ULL, 0x000ea20000004800ULL,
0x00000005403e7810ULL, 0x002fca0007ffe0ffULL, 0x000000013e3f7824ULL, 0x000fe200078e0203ULL,
0x014ac00038387984ULL, 0x004e640000004800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe40007f1e0ffULL,
0xffffffe0423a7812ULL, 0x000fe200078ee23dULL, 0x000000203e427824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fe200000e063bULL, 0x000100003a457811ULL, 0x000fe400078e20ffULL,
0x000000393e3a7210ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x014a140040387984ULL, 0x000ea20000004800ULL,
0x00000006403c7810ULL, 0x002fca0007ffe0ffULL, 0x000000203c457824ULL, 0x000fe200078e00ffULL,
0x014ac00038387984ULL, 0x004e640000004800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3e7210ULL, 0x000fe40007f1e0ffULL,
0xffffffe0423a7812ULL, 0x000fe400078ee23fULL, 0x000000033c427210ULL, 0x000fe20007ffe0ffULL,
0x000000ffff3f7224ULL, 0x000fe200000e063bULL, 0x000100003a3d7811ULL, 0x000fe200078e20ffULL,
0x000000013c3a7824ULL, 0x000fe200078e0239ULL, 0xffffffe045427812ULL, 0x000fc600078ee242ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e3d7faeULL, 0x0003e8000b901c46ULL,
0x014a180040387984ULL, 0x000ea20000004800ULL, 0x00010000423d7811ULL, 0x002fe400078e20ffULL,
0x00000007403e7810ULL, 0x000fca0007ffe0ffULL, 0x000000013e397824ULL, 0x040fe400078e0239ULL,
0x000000013e3f7824ULL, 0x040fe200078e0203ULL, 0x000000053e3e7819ULL, 0x000fc800000006ffULL,
0xffffffe03e3f7812ULL, 0x000fc800078ee23fULL, 0x000100003f3f7811ULL, 0x000fe200078e20ffULL,
0x014ac00038387984ULL, 0x004e640000004800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3a7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff3b7224ULL, 0x000fca00000e063bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a3d7faeULL, 0x0003e8000b901c46ULL, 0x014a1c00403c7984ULL, 0x000ea80000004800ULL,
0x014ac0003c3c7984ULL, 0x004ea40000004800ULL, 0x0000003c21397224ULL, 0x004fc800078e0239ULL,
0x00005e0039387625ULL, 0x000fca00078e0041ULL, 0x0000004338387210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff397224ULL, 0x000fca00000e0639ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383f7faeULL, 0x0003e6000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b8800ff387f8cULL, 0x002e64000c80043fULL,
0x000000ffff3f7224ULL, 0x002fc400078e0039ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x014b8c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe4000780483fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fc800078110ffULL, 0x0000003bff3b7210ULL, 0x000fc800007fe4ffULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x014b8c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe4000780483fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000347300720cULL, 0x000fe20003f04070ULL, 0x0000019000017945ULL, 0x000fe20003800000ULL,
0x0000000137377812ULL, 0x000fe400078ec0ffULL, 0x000000033600780cULL, 0x000fc80004705270ULL,
0x000000013700780cULL, 0x000fda0000705470ULL, 0x0000014000000947ULL, 0x000fea0003800000ULL,
0x000000032300780cULL, 0x000fe20003f24070ULL, 0x00000300ff377624ULL, 0x000fe200078e00ffULL,
0x0000000171387812ULL, 0x000fc800078ec0ffULL, 0x000000013800780cULL, 0x000fe40003f05070ULL,
0xffffffff37377811ULL, 0x000fc800078e08ffULL, 0x0000000137387807ULL, 0x000fca0004000000ULL,
0x0000000171717824ULL, 0x000fe200078e0238ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x0000000400377824ULL, 0x000fe200078e0223ULL, 0x0000640071387a10ULL, 0x040fe40007ffe0ffULL,
0x000000767100720cULL, 0x000fe20003f06070ULL, 0x0000000237377824ULL, 0x000fe200078e00ffULL,
0x0000000400397802ULL, 0x000fc60000000f00ULL, 0x0000640037387a24ULL, 0x000fe200078e0238ULL,
0x00014ac023377811ULL, 0x000fc600078e10ffULL, 0x0000600038387625ULL, 0x000fca00078e0039ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000038377faeULL, 0x0003e4000c121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000019000017945ULL, 0x000fe20003800000ULL,
0x0000017000004947ULL, 0x000fea0003800000ULL, 0x000000347300720cULL, 0x000fe40003f04070ULL,
0x0000000136367810ULL, 0x000fc80007ffe0ffULL, 0x0000000336377812ULL, 0x002fce00078ec0ffULL,
0x00000002ff368819ULL, 0x000fca0000011636ULL, 0x0000000135357824ULL, 0x000fe200078e0236ULL,
0x000000ff37367207ULL, 0x000fe40004000000ULL, 0x00014a0023377811ULL, 0x000fe400078e10ffULL,
0x00000002ff397819ULL, 0x000fe20000011635ULL, 0x0000004035357824ULL, 0x000fc800078e00ffULL,
0x0000030039397a24ULL, 0x000fe200078e0234ULL, 0x000000c035347812ULL, 0x000fe200078ec0ffULL,
0x00000004ff357424ULL, 0x000fc800078e00ffULL, 0x0000010039397824ULL, 0x000fe400078e0234ULL,
0x0000000177347824ULL, 0x000fc600078e0236ULL, 0x0000003923367210ULL, 0x000fe20007ffe0ffULL,
0x0000680034347a24ULL, 0x000fc600078e0239ULL, 0x000000753600720cULL, 0x000fe20003f06070ULL,
0x0000000123347824ULL, 0x000fc800078e0234ULL, 0x0000660034347625ULL, 0x000fd000078e0035ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034377faeULL, 0x0003e4000c121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x014b8000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b8000ff347f8cULL, 0x000e62000c80043fULL,
0x000000ff8800720cULL, 0x000fe20003f05270ULL, 0x000007e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff897224ULL, 0x002fd600078e0035ULL, 0x000007b000000947ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b380072347f8cULL, 0x000e64000c80043fULL,
0x000000ffff3b7224ULL, 0x002fc400078e0035ULL, 0x0000000000347805ULL, 0x000fca0000015200ULL,
0x014b3c0072247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fe4000780483bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000027945ULL, 0x000fe20003800000ULL,
0x000000ff00387202ULL, 0x000fe20000000f00ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000037945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fcc0000015200ULL, 0x0000003634397210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003900780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403900780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff247819ULL, 0x000fc80000011437ULL,
0x0000003924247211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000224247819ULL, 0x000fc80000001237ULL, 0x000000240000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000138387810ULL, 0x000fc40007ffe0ffULL,
0x0000000000037941ULL, 0x000fea0003800000ULL, 0x014b3c0072247984ULL, 0x000e640000000800ULL,
0x8000000024ff7812ULL, 0x002fe4000780483bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000001003247824ULL, 0x000fe200078e00ffULL, 0x00000001ff347819ULL, 0x000fc80000011603ULL,
0x0000007024247812ULL, 0x000fe400078ec0ffULL, 0x0000000c34357812ULL, 0x000fca00078ec0ffULL,
0x00000001243b7824ULL, 0x000fca00078e0235ULL, 0x014180003b367984ULL, 0x000e680000000800ULL,
0x014380003b377984ULL, 0x0004e20000000800ULL, 0x0000006f3600720bULL, 0x002fe20003f1d000ULL,
0x000121427f007947ULL, 0x000fd8000b800000ULL, 0x0000000000247806ULL, 0x004fc800000e0100ULL,
0x0000ffff243c7812ULL, 0x000fe2000780c0ffULL, 0x0000043000027945ULL, 0x000fe20003800000ULL,
0x00000001ff247424ULL, 0x000fe400078e00ffULL, 0x000000ffff387224ULL, 0x000fd200078e006fULL,
0x000003f000008947ULL, 0x000fea0003800000ULL, 0x000000037800780cULL, 0x000fe40003f05270ULL,
0x0000006f3600720bULL, 0x000fe20003f34000ULL, 0x000121027f007947ULL, 0x000fd8000b800000ULL,
0x0000000000397806ULL, 0x000fc400008e0100ULL, 0x000000366f387209ULL, 0x000fe20007810000ULL,
0x0000033000037945ULL, 0x000fe20003800000ULL, 0x0000991039347816ULL, 0x000fc600000000ffULL,
0x014580383b008388ULL, 0x0003e20000000800ULL, 0x000000ff3400720cULL, 0x000fda0003f05270ULL,
0x000002e000008947ULL, 0x000fea0003800000ULL, 0x800000386f347221ULL, 0x002fe20000010000ULL,
0x000000ff39ff7812ULL, 0x000fe2000780c0ffULL, 0x0000017000047945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b34347820ULL, 0x000fc80000410000ULL, 0x00000034003d7308ULL, 0x000e640000000800ULL,
0x0000003d1e1e7220ULL, 0x002fc80000410000ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x000120527f007947ULL, 0x000fea000b800000ULL, 0x00001f7c3d347589ULL, 0x0002a400000e0000ULL,
0x000000341d1d7220ULL, 0x084fe20000410000ULL, 0x000000341c1c7220ULL, 0x080fe20000410000ULL,
0x0000003419197220ULL, 0x080fe20000410000ULL, 0x0000003418187220ULL, 0x080fe20000410000ULL,
0x0000003415157220ULL, 0x080fe20000410000ULL, 0x0000003414147220ULL, 0x080fe20000410000ULL,
0x0000003411117220ULL, 0x080fe20000410000ULL, 0x0000003410107220ULL, 0x080fe20000410000ULL,
0x000000340d0d7220ULL, 0x080fe20000410000ULL, 0x000000340c0c7220ULL, 0x080fe20000410000ULL,
0x0000003409097220ULL, 0x080fe20000410000ULL, 0x0000003408087220ULL, 0x080fe20000410000ULL,
0x0000003405057220ULL, 0x080fe20000410000ULL, 0x0000003404047220ULL, 0x080fe20000410000ULL,
0x0000003433337220ULL, 0x080fe20000410000ULL, 0x000000346c6c7220ULL, 0x000fc40000410000ULL,
0x0000000000047941ULL, 0x000fea0003800000ULL, 0x0000ff0039ff7812ULL, 0x000fda000780c0ffULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00011f627f007947ULL, 0x000fea000b800000ULL,
0x00001f7b3d347589ULL, 0x00046400000e0000ULL, 0x000000341b1b7220ULL, 0x082fe20000410000ULL,
0x000000341a1a7220ULL, 0x080fe20000410000ULL, 0x0000003417177220ULL, 0x080fe20000410000ULL,
0x0000003416167220ULL, 0x080fe20000410000ULL, 0x0000003413137220ULL, 0x080fe20000410000ULL,
0x0000003412127220ULL, 0x080fe20000410000ULL, 0x000000340f0f7220ULL, 0x080fe20000410000ULL,
0x000000340e0e7220ULL, 0x080fe20000410000ULL, 0x000000340b0b7220ULL, 0x080fe20000410000ULL,
0x000000340a0a7220ULL, 0x080fe20000410000ULL, 0x0000003407077220ULL, 0x080fe20000410000ULL,
0x0000003406067220ULL, 0x080fe20000410000ULL, 0x0000003431317220ULL, 0x080fe20000410000ULL,
0x0000003432327220ULL, 0x080fe20000410000ULL, 0x000000346d6d7220ULL, 0x080fe20000410000ULL,
0x000000346e6e7220ULL, 0x000fc40000410000ULL, 0x0000000000037941ULL, 0x002fea0003800000ULL,
0x0000ffff3cff7812ULL, 0x000fda0007806039ULL, 0x8000003836360221ULL, 0x000fe20000010000ULL,
0x00007610ff240816ULL, 0x000fc60000000024ULL, 0x3fb8aa3b36360820ULL, 0x000fc80000410000ULL,
0x0000003600250308ULL, 0x000e640000000800ULL, 0x0000002537370220ULL, 0x00afcc0000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000001e371e7221ULL, 0x008fe20000010000ULL,
0x000000ffff6f7224ULL, 0x000fc400078e0038ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ff24ff7812ULL, 0x000fe2000786c0ffULL, 0x0000012000017945ULL, 0x000fd80003800000ULL,
0x0000010000003947ULL, 0x000fea0003800000ULL, 0x00000025ff26723eULL, 0x000fc800000010ffULL,
0x0000541026367816ULL, 0x000fe20000000026ULL, 0x00011da27f007947ULL, 0x000fea000b800000ULL,
0x00001f7c36277589ULL, 0x0002e400000e0000ULL, 0x00011de27f007947ULL, 0x000fea000b800000ULL,
0x00001f7b36267589ULL, 0x0002a400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000107c3b7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0036ULL,
0x0001402000347802ULL, 0x000fc40000000f00ULL, 0x000123d000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000ffff3a7224ULL, 0x004fe200078e0036ULL,
0x000000187c3b7810ULL, 0x002fe40007ffe0ffULL, 0x0001407000347802ULL, 0x000fc40000000f00ULL,
0x0001238000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000b80028347811ULL, 0x000fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000002954783bULL, 0x000fe20000004200ULL, 0x0000b8002c387811ULL, 0x000fe200078e20ffULL,
0x000003b000017945ULL, 0x000fe20003800000ULL, 0x000000887c00720cULL, 0x000fe20003f46070ULL,
0x000000003434783bULL, 0x002e620000000200ULL, 0x0000007a7300720cULL, 0x000fc40003fc3070ULL,
0x000000887b00720cULL, 0x000fe20003f26070ULL, 0x000000002a5c783bULL, 0x000fe20000004200ULL,
0x0000007a7300720cULL, 0x000fc60003f03070ULL, 0x000000002b64783bULL, 0x000fe80000004200ULL,
0x000000002d3c783bULL, 0x004fe80000004200ULL, 0x000000003838783bULL, 0x000ea80000000200ULL,
0x000000002e40783bULL, 0x000f280000004200ULL, 0x000000002f44783bULL, 0x000ee80000004200ULL,
0x000000003048783bULL, 0x000ee80000004200ULL, 0x00000000794c783bULL, 0x000ee40000004200ULL,
0x000000273434b231ULL, 0x00afc400003400ffULL, 0x000000273636b231ULL, 0x000fe400003400ffULL,
0x000000263535b231ULL, 0x080fe400003400ffULL, 0x000000263737b231ULL, 0x000fce00003400ffULL,
0x000000543450723cULL, 0x000f6200000418ffULL, 0x000000273838b231ULL, 0x084fe400003400ffULL,
0x000000273a3ab231ULL, 0x000fe400003400ffULL, 0x000000263939b231ULL, 0x000fc600003400ffULL,
0x0000005c3458723cULL, 0x000fe200000418ffULL, 0x000000263b3bb231ULL, 0x000fce00003400ffULL,
0x000000643460723cULL, 0x040ff000000418ffULL, 0x000000563454723cULL, 0x040f7000000418ffULL,
0x0000005e345c723cULL, 0x040f7000000418ffULL, 0x000000663464723cULL, 0x040f7000000418ffULL,
0x0000003c3468723cULL, 0x040b6e00000418ffULL, 0x00000001883c7810ULL, 0x020fe20007ffe0ffULL,
0x0000003e3434723cULL, 0x000f6600000418ffULL, 0x0000003c7c00720cULL, 0x000fc40005746470ULL,
0x0000003c7b00720cULL, 0x000fc60004f26470ULL, 0x000000403850723cULL, 0x050b700000041850ULL,
0x000000423854723cULL, 0x040b700000041854ULL, 0x000000443858723cULL, 0x040b700000041858ULL,
0x00000046385c723cULL, 0x040b70000004185cULL, 0x000000483860723cULL, 0x040b700000041860ULL,
0x0000004a3864723cULL, 0x040b700000041864ULL, 0x0000004c3868723cULL, 0x040b700000041868ULL,
0x0000004e3834723cULL, 0x020b620000041834ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x000000501d1d7221ULL, 0x000fe20000010000ULL,
0x000000511c1c7221ULL, 0x000fe20000010000ULL, 0x0000005419197221ULL, 0x000fe20000010000ULL,
0x0000005518187221ULL, 0x000fe20000010000ULL, 0x0000005815157221ULL, 0x000fe20000010000ULL,
0x0000005914147221ULL, 0x000fe20000010000ULL, 0x0000005c11117221ULL, 0x000fe20000010000ULL,
0x0000005d10107221ULL, 0x000fe20000010000ULL, 0x000000600d0d7221ULL, 0x000fe20000010000ULL,
0x000000610c0c7221ULL, 0x000fe20000010000ULL, 0x0000006409097221ULL, 0x000fe20000010000ULL,
0x0000006508087221ULL, 0x000fe20000010000ULL, 0x0000006805057221ULL, 0x000fe20000010000ULL,
0x0000006904047221ULL, 0x000fe20000010000ULL, 0x0000003433337221ULL, 0x020fe20000010000ULL,
0x000000356c6c7221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000001947ULL, 0x000fea0000000000ULL,
0x000000521b1b7221ULL, 0x000fe20000010000ULL, 0x000000531a1a7221ULL, 0x000fe20000010000ULL,
0x0000005617177221ULL, 0x000fe20000010000ULL, 0x0000005716167221ULL, 0x000fe20000010000ULL,
0x0000005a13137221ULL, 0x000fe20000010000ULL, 0x0000005b12127221ULL, 0x000fe20000010000ULL,
0x0000005e0f0f7221ULL, 0x000fe20000010000ULL, 0x0000005f0e0e7221ULL, 0x000fe20000010000ULL,
0x000000620b0b7221ULL, 0x000fe20000010000ULL, 0x000000630a0a7221ULL, 0x000fe20000010000ULL,
0x0000006607077221ULL, 0x000fe20000010000ULL, 0x0000006706067221ULL, 0x000fe20000010000ULL,
0x0000006a31317221ULL, 0x000fe20000010000ULL, 0x0000006b32327221ULL, 0x000fe20000010000ULL,
0x000000366d6d7221ULL, 0x020fe20000010000ULL, 0x000000376e6e7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x014b8800ff347f8cULL, 0x020e62000c80043fULL, 0x00000002ff377819ULL, 0x000fe2000001163cULL,
0x000000ffff3e7224ULL, 0x000fe200078e00ffULL, 0x0000007a7300720cULL, 0x000fc40003fc3070ULL,
0x000000373c377207ULL, 0x040fe40002800000ULL, 0x000000033c3c7812ULL, 0x000fe400078ec0ffULL,
0x0000000337377810ULL, 0x000fe40007ffe0ffULL, 0x0000007a7300720cULL, 0x000fe40003f03070ULL,
0x00000002ff397819ULL, 0x000fe40000011637ULL, 0x00000040ff407803ULL, 0x000fc40000000000ULL,
0x0000000337377812ULL, 0x000fe200078ec0ffULL, 0x000000ffff3f7224ULL, 0x002fe200078e0035ULL,
0x000000ff3c357207ULL, 0x000fe20006800000ULL, 0x0000030039347a24ULL, 0x000fc400078e027aULL,
0x0000000000387805ULL, 0x000fca0000015200ULL, 0x014b8400ff367984ULL, 0x000e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000036ff7812ULL, 0x002fe200078c4889ULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000103e00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fc80007fde1ffULL,
0x0000003b393b7210ULL, 0x000fe400037fe5ffULL, 0x003d09003d00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc8000001143bULL,
0x0000003d36367211ULL, 0x000fca00078d10ffULL, 0x000000ffff3b7224ULL, 0x000fca00030e063bULL,
0x0000000236367819ULL, 0x000fc8000000123bULL, 0x000000360000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x014b8400ff367984ULL, 0x000e640000000800ULL,
0x8000000036ff7812ULL, 0x002fe400078c4889ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fc40000015200ULL, 0x014b8c00ff367984ULL, 0x000e620000000800ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe60000000000ULL,
0x8000000036ff7812ULL, 0x002fe200078c483fULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000103c00780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383d7210ULL, 0x000fca0007fde1ffULL, 0x000000013b3b7824ULL, 0x000fe200030e0e39ULL,
0x003d09003d00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff367819ULL, 0x000fc8000001143bULL, 0x0000003d36367211ULL, 0x000fca00078d10ffULL,
0x000000ffff3b7224ULL, 0x000fca00030e063bULL, 0x0000000236367819ULL, 0x000fc8000000123bULL,
0x000000360000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x014b8c00ff367984ULL, 0x000e640000000800ULL, 0x8000000036ff7812ULL, 0x002fe400078c483fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000001343b7810ULL, 0x040fe20007ffe0ffULL,
0x0000121000017945ULL, 0x000fe20003800000ULL, 0x0000003734367211ULL, 0x000fe400078e10ffULL,
0x000000743b00720cULL, 0x000fc60003fc6070ULL, 0x00000040363f7824ULL, 0x000fca00078e00ffULL,
0x0000004070397812ULL, 0x000fca00078ef83fULL, 0x000009800000e947ULL, 0x000fea0003800000ULL,
0x0000000472417824ULL, 0x040fe200078e00ffULL, 0x0000020000437802ULL, 0x000fe20000000f00ULL,
0x0000000172387824ULL, 0x040fe200078e0239ULL, 0x0000000172427810ULL, 0x000fe40007ffe0ffULL,
0x014a000041367984ULL, 0x000e640000000800ULL, 0x00000004363e7824ULL, 0x002fca00078e00ffULL,
0x014ac0003e367984ULL, 0x000e640000000800ULL, 0x0000003621367224ULL, 0x002fe400078e0238ULL,
0x0000001003387824ULL, 0x000fe400078e00ffULL, 0x00005e00363a7625ULL, 0x000fe200078e0043ULL,
0x0000003f75367217ULL, 0x000fe40007800000ULL, 0x000001f038457812ULL, 0x000fc800078ec0ffULL,
0x000000453a3c7210ULL, 0x000fe20007fde0ffULL, 0x00000001423a7824ULL, 0x000fc800078e0239ULL,
0x000000ffff3d7224ULL, 0x000fe400030e063bULL, 0x00000001363b7824ULL, 0x000fe200078e0a3fULL,
0x00000005723f7819ULL, 0x040fe200000006ffULL, 0x0000000172367824ULL, 0x000fc600078e0203ULL,
0x0000003b723b7217ULL, 0x000fe40007800000ULL, 0xffffffe03f387812ULL, 0x000fc600078ee236ULL,
0x000000013b367824ULL, 0x000fe200078e0a72ULL, 0x0000c00038477811ULL, 0x000fc800078e20ffULL,
0x000000ff3600720cULL, 0x000fda0003fc3070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c477faeULL, 0x0003e8000f101c46ULL, 0x014a040041387984ULL, 0x000ea40000000800ULL,
0x0000000438387824ULL, 0x004fcc00078e00ffULL, 0x014ac00038387984ULL, 0x000ea40000000800ULL,
0x00000038213a7224ULL, 0x004fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0043ULL,
0x000000453a3e7210ULL, 0x000fe40007fde0ffULL, 0x00000003423a7210ULL, 0x000fc60007ffe0ffULL,
0x000000ffff3f7224ULL, 0x000fe200030e063bULL, 0x000000013600780cULL, 0x000fe20003fc3070ULL,
0x00000020423b7824ULL, 0x000fe200078e00ffULL, 0x0000000272427810ULL, 0x000fc80007ffe0ffULL,
0xffffffe03b3a7812ULL, 0x000fc800078ee23aULL, 0x0000c0003a477811ULL, 0x002fe200078e20ffULL,
0x00000001423a7824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e477faeULL, 0x0003e8000f101c46ULL, 0x014a080041387984ULL, 0x000ea40000000800ULL,
0x0000000438387824ULL, 0x004fcc00078e00ffULL, 0x014ac00038387984ULL, 0x000ea40000000800ULL,
0x00000038213a7224ULL, 0x004fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0043ULL,
0x000000453a3c7210ULL, 0x000fe40007fde0ffULL, 0x00000003423a7210ULL, 0x000fc60007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fe200030e063bULL, 0x000000023600780cULL, 0x000fe20003fc3070ULL,
0x00000020423b7824ULL, 0x000fe200078e00ffULL, 0x0000000372427810ULL, 0x000fc80007ffe0ffULL,
0xffffffe03b3a7812ULL, 0x000fc800078ee23aULL, 0x0000c0003a477811ULL, 0x002fe200078e20ffULL,
0x00000001423a7824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c477faeULL, 0x0003e8000f101c46ULL, 0x014a0c0041387984ULL, 0x000ea40000000800ULL,
0x0000000438387824ULL, 0x004fcc00078e00ffULL, 0x014ac00038387984ULL, 0x000ea40000000800ULL,
0x00000038213a7224ULL, 0x004fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0043ULL,
0x000000453a3e7210ULL, 0x000fe40007fde0ffULL, 0x00000003423a7210ULL, 0x000fc60007ffe0ffULL,
0x000000ffff3f7224ULL, 0x000fe200030e063bULL, 0x000000033600780cULL, 0x000fe20003fc3070ULL,
0x00000020423b7824ULL, 0x000fe200078e00ffULL, 0x0000000472427810ULL, 0x000fc80007ffe0ffULL,
0xffffffe03b3a7812ULL, 0x000fc800078ee23aULL, 0x0000c0003a477811ULL, 0x002fe200078e20ffULL,
0x00000001423a7824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e477faeULL, 0x0003e8000f101c46ULL, 0x014a100041387984ULL, 0x000ea40000000800ULL,
0x0000000438387824ULL, 0x004fcc00078e00ffULL, 0x014ac00038387984ULL, 0x000ea40000000800ULL,
0x00000038213a7224ULL, 0x004fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0043ULL,
0x000000453a3c7210ULL, 0x000fe40007fde0ffULL, 0x00000003423a7210ULL, 0x000fc60007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fe200030e063bULL, 0x000000043600780cULL, 0x000fe20003fc3070ULL,
0x00000020423b7824ULL, 0x000fe200078e00ffULL, 0x0000000572427810ULL, 0x000fc80007ffe0ffULL,
0xffffffe03b3a7812ULL, 0x000fc800078ee23aULL, 0x0000c0003a477811ULL, 0x002fe200078e20ffULL,
0x00000001423a7824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c477faeULL, 0x0003e8000f101c46ULL, 0x014a140041387984ULL, 0x000ea20000000800ULL,
0x00000006723c7810ULL, 0x002fe20007ffe0ffULL, 0x0000000438387824ULL, 0x004fcc00078e00ffULL,
0x014ac00038387984ULL, 0x000e640000000800ULL, 0x00000038213a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0043ULL, 0x000000453a3e7210ULL, 0x000fe40007fde0ffULL,
0x00000003423a7210ULL, 0x000fc60007ffe0ffULL, 0x000000ffff3f7224ULL, 0x000fe200030e063bULL,
0x000000053600780cULL, 0x000fe20003fc3070ULL, 0x00000020423b7824ULL, 0x000fe200078e00ffULL,
0x000000033c427210ULL, 0x000fc80007ffe0ffULL, 0xffffffe03b3a7812ULL, 0x000fc800078ee23aULL,
0x0000c0003a3d7811ULL, 0x000fe200078e20ffULL, 0x000000013c3a7824ULL, 0x000fc800078e0239ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e3d7faeULL, 0x0003e8000f101c46ULL,
0x014a180041387984ULL, 0x000ea20000000800ULL, 0x000000203c3d7824ULL, 0x002fe200078e00ffULL,
0x00000007723e7810ULL, 0x000fc80007ffe0ffULL, 0xffffffe03d427812ULL, 0x000fe200078ee242ULL,
0x000000013e397824ULL, 0x040fe200078e0239ULL, 0x000000033e3f7210ULL, 0x040fe20007ffe0ffULL,
0x000000203e3e7824ULL, 0x000fe200078e00ffULL, 0x0000c000423d7811ULL, 0x000fc800078e20ffULL,
0xffffffe03e3f7812ULL, 0x000fc800078ee23fULL, 0x0000c0003f3f7811ULL, 0x000fe200078e20ffULL,
0x0000000438387824ULL, 0x004fcc00078e00ffULL, 0x014ac00038387984ULL, 0x000e640000000800ULL,
0x00000038213a7224ULL, 0x002fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0043ULL,
0x000000453a3a7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3b7224ULL, 0x000fe200030e063bULL,
0x000000063600780cULL, 0x000fda0003fc3070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a3d7faeULL, 0x0003e8000f101c46ULL, 0x014a1c0041387984ULL, 0x000ea40000000800ULL,
0x00000004383c7824ULL, 0x004fca00078e00ffULL, 0x014ac0003c387984ULL, 0x000ea40000000800ULL,
0x0000003821387224ULL, 0x004fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e0043ULL,
0x0000004538387210ULL, 0x000fca0007fde0ffULL, 0x000000ffff397224ULL, 0x000fe200030e0639ULL,
0x000000073600780cULL, 0x000fda0003fc3070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383f7faeULL, 0x0003e2000f101c46ULL, 0x0000083000007947ULL, 0x000fea0003800000ULL,
0x0000007203427211ULL, 0x040fe200078fd8ffULL, 0x00000200ff417424ULL, 0x000fe400078e00ffULL,
0x00000010033c7824ULL, 0x000fe200078e00ffULL, 0x0000000142447810ULL, 0x040fe20007ffe0ffULL,
0x014a000042367984ULL, 0x000e620000004800ULL, 0x0000000142387824ULL, 0x000fe400078e0239ULL,
0x000001f03c437812ULL, 0x000fe200078ec0ffULL, 0x014ac00036367984ULL, 0x002e640000004800ULL,
0x0000003621387224ULL, 0x002fc800078e0238ULL, 0x00005e00383a7625ULL, 0x000fc800078e0041ULL,
0x0000000142387824ULL, 0x000fe200078e0203ULL, 0x000000433a3c7210ULL, 0x000fc80007fde0ffULL,
0x0000003bff3d7210ULL, 0x000fe200037fe4ffULL, 0x00000020423b7824ULL, 0x000fca00078e00ffULL,
0xffffffe03b387812ULL, 0x000fc800078ee238ULL, 0x0000c00038457811ULL, 0x000fe200078e20ffULL,
0x0000000144387824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x014a040042367984ULL, 0x000ea80000004800ULL,
0x014ac00036367984ULL, 0x004ea40000004800ULL, 0x0000003621387224ULL, 0x004fc800078e0238ULL,
0x00005e00383a7625ULL, 0x000fe200078e0041ULL, 0x0000000344387210ULL, 0x000fc80007ffe0ffULL,
0x000000433a3e7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3f7224ULL, 0x000fe400030e063bULL,
0x00000020443b7824ULL, 0x000fe200078e00ffULL, 0x0000000242447810ULL, 0x000fc80007ffe0ffULL,
0xffffffe03b387812ULL, 0x000fc800078ee238ULL, 0x0000c00038457811ULL, 0x002fe200078e20ffULL,
0x0000000144387824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e457faeULL, 0x0003e8000b901c46ULL, 0x014a080042367984ULL, 0x000ea80000004800ULL,
0x014ac00036367984ULL, 0x004ea40000004800ULL, 0x0000003621387224ULL, 0x004fc800078e0238ULL,
0x00005e00383a7625ULL, 0x000fc800078e0041ULL, 0x0000000144387824ULL, 0x000fe200078e0203ULL,
0x000000433a3c7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3d7224ULL, 0x000fe200030e063bULL,
0x00000005443b7819ULL, 0x000fe400000006ffULL, 0x0000000342447810ULL, 0x000fe40007ffe0ffULL,
0xffffffe03b387812ULL, 0x000fc800078ee238ULL, 0x0000c00038457811ULL, 0x002fe200078e20ffULL,
0x0000000144387824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x014a0c0042367984ULL, 0x000ea80000004800ULL,
0x014ac00036367984ULL, 0x004ea40000004800ULL, 0x0000003621387224ULL, 0x004fc800078e0238ULL,
0x00005e00383a7625ULL, 0x000fc800078e0041ULL, 0x0000000144387824ULL, 0x000fe200078e0203ULL,
0x000000433a3e7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3f7224ULL, 0x000fe400030e063bULL,
0x00000020443b7824ULL, 0x000fe200078e00ffULL, 0x0000000442447810ULL, 0x000fc80007ffe0ffULL,
0xffffffe03b387812ULL, 0x000fc800078ee238ULL, 0x0000c00038457811ULL, 0x002fe400078e20ffULL,
0x0000003944387210ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e457faeULL, 0x0003e8000b901c46ULL, 0x014a100042367984ULL, 0x000ea80000004800ULL,
0x014ac00036367984ULL, 0x004ea40000004800ULL, 0x0000003621387224ULL, 0x004fc800078e0238ULL,
0x00005e00383a7625ULL, 0x000fc800078e0041ULL, 0x0000000144387824ULL, 0x000fe200078e0203ULL,
0x000000433a3c7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3d7224ULL, 0x000fe400030e063bULL,
0x00000020443b7824ULL, 0x000fe200078e00ffULL, 0x0000000542447810ULL, 0x000fc80007ffe0ffULL,
0xffffffe03b387812ULL, 0x000fc800078ee238ULL, 0x0000c00038457811ULL, 0x002fe200078e20ffULL,
0x0000000144387824ULL, 0x000fc800078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x014a140042367984ULL, 0x000ea20000004800ULL,
0x00000006423c7810ULL, 0x002fca0007ffe0ffULL, 0x000000203c457824ULL, 0x000fe200078e00ffULL,
0x014ac00036367984ULL, 0x004e640000004800ULL, 0x0000003621387224ULL, 0x002fc800078e0238ULL,
0x00005e00383a7625ULL, 0x000fc800078e0041ULL, 0x0000000144387824ULL, 0x000fe200078e0203ULL,
0x000000433a3e7210ULL, 0x000fc80007fde0ffULL, 0x0000003bff3f7210ULL, 0x000fe200037fe4ffULL,
0x00000020443b7824ULL, 0x000fca00078e00ffULL, 0xffffffe03b387812ULL, 0x000fc800078ee238ULL,
0x0000c000383d7811ULL, 0x000fe200078e20ffULL, 0x000000013c387824ULL, 0x000fc800078e0239ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e3d7faeULL, 0x0003e8000b901c46ULL,
0x014a180042367984ULL, 0x000ea80000004800ULL, 0x014ac00036367984ULL, 0x004ea40000004800ULL,
0x0000003621387224ULL, 0x004fc800078e0238ULL, 0x00005e00383a7625ULL, 0x000fe200078e0041ULL,
0x000000033c387210ULL, 0x000fe40007ffe0ffULL, 0x00000007423c7810ULL, 0x000fe40007ffe0ffULL,
0x000000433a3a7210ULL, 0x000fe40007fde0ffULL, 0xffffffe045387812ULL, 0x000fe200078ee238ULL,
0x000000013c397824ULL, 0x040fe200078e0239ULL, 0x000000053c3f7819ULL, 0x002fe200000006ffULL,
0x000000ffff3b7224ULL, 0x000fe200030e063bULL, 0x0000c000383d7811ULL, 0x000fe200078e20ffULL,
0x000000013c3e7824ULL, 0x000fc800078e0203ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a3d7faeULL, 0x0003e2000b901c46ULL, 0xffffffe03f3e7812ULL, 0x000fc600078ee23eULL,
0x014a1c0042367984ULL, 0x000ea20000004800ULL, 0x0000c0003e3b7811ULL, 0x002fc600078e20ffULL,
0x014ac00036367984ULL, 0x004e640000004800ULL, 0x0000003621397224ULL, 0x002fc800078e0239ULL,
0x00005e0039387625ULL, 0x000fca00078e0041ULL, 0x0000004338387210ULL, 0x000fca0007fde0ffULL,
0x000000ffff397224ULL, 0x000fca00030e0639ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e6000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b8800ff387f8cULL, 0x002e64000c80043fULL,
0x000000ffff3f7224ULL, 0x002fc400078e0039ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x014b8c00ff367984ULL, 0x000e620000000800ULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000036ff7812ULL, 0x002fe200078c483fULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007fde1ffULL,
0x000000013b3b7824ULL, 0x000fe200030e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc8000001143bULL,
0x0000003d36367211ULL, 0x000fca00078d10ffULL, 0x000000ffff3b7224ULL, 0x000fca00030e063bULL,
0x0000000236367819ULL, 0x000fc8000000123bULL, 0x000000360000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x014b8c00ff367984ULL, 0x000e640000000800ULL,
0x8000000036ff7812ULL, 0x002fe400078c483fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000018000017945ULL, 0x000fe20003800000ULL, 0x0000016000004947ULL, 0x000fea0003800000ULL,
0x000000347300720cULL, 0x000fe40003fc4070ULL, 0x00014a0023397811ULL, 0x000fe400078e10ffULL,
0x000000ff35367207ULL, 0x000fc40003000000ULL, 0x000000ff35387207ULL, 0x000fe40007000000ULL,
0x0000003637367210ULL, 0x000fe20007ffe0ffULL, 0x00000004ff377424ULL, 0x000fc600078e00ffULL,
0x00000002ff357819ULL, 0x000fe20000011636ULL, 0x0000004036367824ULL, 0x000fc800078e00ffULL,
0x0000030035357a24ULL, 0x000fe200078e0234ULL, 0x000000c036367812ULL, 0x000fe200078ec0ffULL,
0x0000000177347824ULL, 0x000fc800078e0238ULL, 0x0000010035357824ULL, 0x000fca00078e0236ULL,
0x0000002035357810ULL, 0x000fca0007ffe0ffULL, 0x0000000123367824ULL, 0x100fe400078e0235ULL,
0x0000680034347a24ULL, 0x000fc600078e0235ULL, 0x000000753600720cULL, 0x000fe40003fc6070ULL,
0x0000003423347210ULL, 0x000fca0007ffe0ffULL, 0x0000660034347625ULL, 0x000fcc00078e0037ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034397faeULL, 0x0003e4000f121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x014b7800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b7800ff347f8cULL, 0x000e62000c80043fULL,
0x0000013000017945ULL, 0x000fe20003800000ULL, 0x000000ffff897224ULL, 0x002fe200078e0035ULL,
0x0000010000003947ULL, 0x000fea0003800000ULL, 0x00000025ff26723eULL, 0x000fc800000010ffULL,
0x0000541026367816ULL, 0x000fe20000000026ULL, 0x0000fb827f007947ULL, 0x000fea000b800000ULL,
0x00001f7c36277589ULL, 0x0002a400000e0000ULL, 0x0000fbc27f007947ULL, 0x000fea000b800000ULL,
0x00001f7b36267589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000107c3b7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0036ULL,
0x0001630000347802ULL, 0x000fc40000000f00ULL, 0x000100f000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000036003a7202ULL, 0x004fe40000000f00ULL,
0x000000187c3b7810ULL, 0x002fe40007ffe0ffULL, 0x0001635000347802ULL, 0x000fc40000000f00ULL,
0x000100a000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000b80086347811ULL, 0x000fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000008554783bULL, 0x000fe20000004200ULL, 0x0000b80081387811ULL, 0x000fe200078e20ffULL,
0x0000035000017945ULL, 0x000fe20003800000ULL, 0x000000ff4000720cULL, 0x000fe20003fc5270ULL,
0x000000003434783bULL, 0x00ae680000000200ULL, 0x00000000845c783bULL, 0x000fe80000004200ULL,
0x000000008364783bULL, 0x000fe80000004200ULL, 0x00000000823c783bULL, 0x000fe80000004200ULL,
0x000000003838783bULL, 0x004ea80000000200ULL, 0x000000008040783bULL, 0x000ee80000004200ULL,
0x000000007f44783bULL, 0x000f280000004200ULL, 0x000000007e48783bULL, 0x000ee80000004200ULL,
0x000000007d4c783bULL, 0x000ee20000004200ULL, 0x000000273434b231ULL, 0x002fc400003400ffULL,
0x000000273636b231ULL, 0x000fe400003400ffULL, 0x000000263535b231ULL, 0x080fe400003400ffULL,
0x000000263737b231ULL, 0x000fce00003400ffULL, 0x000000543450723cULL, 0x000f6200000418ffULL,
0x000000273838b231ULL, 0x084fe400003400ffULL, 0x000000273a3ab231ULL, 0x000fe400003400ffULL,
0x000000263939b231ULL, 0x000fc600003400ffULL, 0x0000005c3458723cULL, 0x000fe200000418ffULL,
0x000000263b3bb231ULL, 0x000fce00003400ffULL, 0x000000643460723cULL, 0x040ff000000418ffULL,
0x000000563454723cULL, 0x040f7000000418ffULL, 0x0000005e345c723cULL, 0x040f7000000418ffULL,
0x000000663464723cULL, 0x040f7000000418ffULL, 0x0000003c3468723cULL, 0x040f7000000418ffULL,
0x0000003e3434723cULL, 0x000f7000000418ffULL, 0x000000403850723cULL, 0x068b700000041850ULL,
0x000000423854723cULL, 0x040b700000041854ULL, 0x000000443858723cULL, 0x050b700000041858ULL,
0x00000046385c723cULL, 0x040b70000004185cULL, 0x000000483860723cULL, 0x040b700000041860ULL,
0x0000004a3864723cULL, 0x040b700000041864ULL, 0x0000004c3868723cULL, 0x040b700000041868ULL,
0x0000004e3834723cULL, 0x000b620000041834ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x000000501d1d7221ULL, 0x020fe20000010000ULL,
0x000000511c1c7221ULL, 0x000fe20000010000ULL, 0x0000005419197221ULL, 0x000fe20000010000ULL,
0x0000005518187221ULL, 0x000fe20000010000ULL, 0x0000005815157221ULL, 0x000fe20000010000ULL,
0x0000005914147221ULL, 0x000fe20000010000ULL, 0x0000005c11117221ULL, 0x000fe20000010000ULL,
0x0000005d10107221ULL, 0x000fe20000010000ULL, 0x000000600d0d7221ULL, 0x000fe20000010000ULL,
0x000000610c0c7221ULL, 0x000fe20000010000ULL, 0x0000006409097221ULL, 0x000fe20000010000ULL,
0x0000006508087221ULL, 0x000fe20000010000ULL, 0x0000006805057221ULL, 0x000fe20000010000ULL,
0x0000006904047221ULL, 0x000fe20000010000ULL, 0x0000003433337221ULL, 0x000fe20000010000ULL,
0x000000356c6c7221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000001947ULL, 0x000fea0000000000ULL,
0x000000521b1b7221ULL, 0x020fe20000010000ULL, 0x000000531a1a7221ULL, 0x000fe20000010000ULL,
0x0000005617177221ULL, 0x000fe20000010000ULL, 0x0000005716167221ULL, 0x000fe20000010000ULL,
0x0000005a13137221ULL, 0x000fe20000010000ULL, 0x0000005b12127221ULL, 0x000fe20000010000ULL,
0x0000005e0f0f7221ULL, 0x000fe20000010000ULL, 0x0000005f0e0e7221ULL, 0x000fe20000010000ULL,
0x000000620b0b7221ULL, 0x000fe20000010000ULL, 0x000000630a0a7221ULL, 0x000fe20000010000ULL,
0x0000006607077221ULL, 0x000fe20000010000ULL, 0x0000006706067221ULL, 0x000fe20000010000ULL,
0x0000006a31317221ULL, 0x000fe20000010000ULL, 0x0000006b32327221ULL, 0x000fe20000010000ULL,
0x000000366d6d7221ULL, 0x000fe20000010000ULL, 0x000000376e6e7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000188887810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b8800ff347f8cULL, 0x020e62000c80043fULL,
0x000000878800720cULL, 0x000fe20003f06070ULL, 0x000000ffff3c7224ULL, 0x002fd800078e0035ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffb0c000007947ULL, 0x000fea000383ffffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014b7000ffff7f8cULL, 0x000fe4000c80043fULL,
0x000003007a7a7a10ULL, 0x000fc80007ffe0ffULL, 0x000000747a00720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xfffebaf000007947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000002a7919ULL, 0x000e620000002500ULL,
0x000000ffff297224ULL, 0x000fe200078e0005ULL, 0x0000000700267202ULL, 0x000fe20000000f00ULL,
0x000000ffff287224ULL, 0x000fe200078e0004ULL, 0x0000000e00057202ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fe400078e0006ULL, 0x000000ffff257224ULL, 0x000fe400078e0008ULL,
0x000000ffff237224ULL, 0x000fe400078e0009ULL, 0x000000ffff217224ULL, 0x000fc400078e000aULL,
0x000000ffff247224ULL, 0x000fe400078e000bULL, 0x000000ffff227224ULL, 0x000fe200078e000fULL,
0x000000742a00720cULL, 0x002fda0003f06070ULL, 0x0000036000000947ULL, 0x000fea0003800000ULL,
0x018000001e037810ULL, 0x000fe20007ffe0ffULL, 0x000000c000007945ULL, 0x000fe60003800000ULL,
0x7f80000003037812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0300780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000000ffff307224ULL, 0x000fe200078e001eULL,
0x00016ae000067802ULL, 0x000fc40000000f00ULL, 0x0000f76000007944ULL, 0x008fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000001e00037308ULL, 0x000e640000001000ULL,
0xbf80000003047423ULL, 0x002fc8000000001eULL, 0x800000ff04047221ULL, 0x000fc80000010100ULL,
0x0000000403037223ULL, 0x000fc40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000047919ULL, 0x000f240000000000ULL, 0x00000002ff3b7819ULL, 0x010fe20000011604ULL,
0x0000f3527f007947ULL, 0x000fea000b800000ULL, 0x00001f3b03047589ULL, 0x00c4e400000e0000ULL,
0x0000000000067919ULL, 0x000f220000000000ULL, 0x0000001d041d7220ULL, 0x048fe20000410000ULL,
0x0000001c041c7220ULL, 0x040fe20000410000ULL, 0x0000001904197220ULL, 0x040fe20000410000ULL,
0x0000001804187220ULL, 0x040fe20000410000ULL, 0x0000001504157220ULL, 0x040fe20000410000ULL,
0x0000001404147220ULL, 0x040fe20000410000ULL, 0x0000001104117220ULL, 0x040fe20000410000ULL,
0x0000001004107220ULL, 0x040fe20000410000ULL, 0x0000000d040d7220ULL, 0x040fe20000410000ULL,
0x0000000c040c7220ULL, 0x040fe20000410000ULL, 0x0000002304237220ULL, 0x040fe20000410000ULL,
0x0000002504257220ULL, 0x040fe20000410000ULL, 0x0000002904297220ULL, 0x040fe20000410000ULL,
0x0000002804287220ULL, 0x040fe20000410000ULL, 0x0000003304337220ULL, 0x040fe20000410000ULL,
0x0000006c046c7220ULL, 0x000fe20000410000ULL, 0x00000008063b7811ULL, 0x016fe200078ff0ffULL,
0x0000f2627f007947ULL, 0x000fea000b800000ULL, 0x00001f3b03037589ULL, 0x0002a400000e0000ULL,
0x0000001b031b7220ULL, 0x044fe20000410000ULL, 0x0000001a031a7220ULL, 0x040fe20000410000ULL,
0x0000001703177220ULL, 0x040fe20000410000ULL, 0x0000001603167220ULL, 0x040fe20000410000ULL,
0x0000001303137220ULL, 0x040fe20000410000ULL, 0x0000001203127220ULL, 0x040fe20000410000ULL,
0x0000002203227220ULL, 0x040fe20000410000ULL, 0x0000000503057220ULL, 0x040fe20000410000ULL,
0x0000002403247220ULL, 0x040fe20000410000ULL, 0x0000002103217220ULL, 0x040fe20000410000ULL,
0x0000002603267220ULL, 0x040fe20000410000ULL, 0x0000002703277220ULL, 0x040fe20000410000ULL,
0x0000003103317220ULL, 0x040fe20000410000ULL, 0x0000003203327220ULL, 0x040fe20000410000ULL,
0x0000006d036d7220ULL, 0x040fe20000410000ULL, 0x0000006e036e7220ULL, 0x000fc20000410000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000151407723eULL, 0x000fc400000010ffULL,
0x000000111008723eULL, 0x000fe400000010ffULL, 0x0000000d0c09723eULL, 0x000fe400000010ffULL,
0x00000013120f723eULL, 0x000fe400000010ffULL, 0x0000001d1c03723eULL, 0x000fe400000010ffULL,
0x000000191806723eULL, 0x000fe400000010ffULL, 0x00000023250a723eULL, 0x000fc400000010ffULL,
0x00000029280b723eULL, 0x000fe400000010ffULL, 0x000000336c0c723eULL, 0x000fe400000010ffULL,
0x0000001b1a0d723eULL, 0x000fe400000010ffULL, 0x00000017160e723eULL, 0x000fe400000010ffULL,
0x000000220510723eULL, 0x000fe400000010ffULL, 0x000000242111723eULL, 0x000fc400000010ffULL,
0x000000262712723eULL, 0x000fe400000010ffULL, 0x000000313213723eULL, 0x000fe400000010ffULL,
0x0000006d6e14723eULL, 0x000fc400000010ffULL, 0x0000000000197919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000002ff1b7819ULL, 0x004fc40000011619ULL,
0x0000000819287811ULL, 0x000fe400078ff0ffULL, 0x000000011b047810ULL, 0x040fe20007ffe0ffULL,
0x000000081b157824ULL, 0x040fe200078e00ffULL, 0x000000021b057810ULL, 0x040fe20007ffe0ffULL,
0x000000081b1a7824ULL, 0x040fe200078e00ffULL, 0x000000061b167810ULL, 0x040fe20007ffe0ffULL,
0x000000081b177824ULL, 0x000fe200078e00ffULL, 0xfffffff815187812ULL, 0x000fe200078ee204ULL,
0x000000081b1d7824ULL, 0x040fe200078e00ffULL, 0x000000031b047810ULL, 0x040fe20007ffe0ffULL,
0x000000081b227824ULL, 0x000fe200078e00ffULL, 0xfffffff81a1a7812ULL, 0x000fc400078ee205ULL,
0x000000051b157810ULL, 0x000fe40007ffe0ffULL, 0xfffffff8171c7812ULL, 0x000fe200078ee204ULL,
0x0000080078047824ULL, 0x000fe200078e00ffULL, 0xfffffff81d247812ULL, 0x000fe200078ee216ULL,
0x000000081b167824ULL, 0x040fe200078e00ffULL, 0x000000041b057810ULL, 0x040fe40007ffe0ffULL,
0x000000031b207819ULL, 0x002fe400000006ffULL, 0xfffffff822227812ULL, 0x000fe200078ee215ULL,
0x0000000419157824ULL, 0x000fe200078e00ffULL, 0xfffffff820207812ULL, 0x000fc400078ee205ULL,
0xfffffff816167812ULL, 0x000fe400078ee21bULL, 0x0000a00004057810ULL, 0x000fe40007ffe0ffULL,
0xffffffff1b177810ULL, 0x040fe40007ffe0ffULL, 0x000000031b267819ULL, 0x000fe200000006ffULL,
0x00000008281b7824ULL, 0x000fe200078e00ffULL, 0x0000000c15157812ULL, 0x000fe200078ec0ffULL,
0x0000001016167824ULL, 0x100fe200078e0205ULL, 0x000000051a1a7211ULL, 0x080fe200078e20ffULL,
0x0000001018187824ULL, 0x000fe200078e0205ULL, 0xfffffff826267812ULL, 0x000fe200078ee217ULL,
0x000000101c1c7824ULL, 0x100fe200078e0205ULL, 0xfffffff81b287812ULL, 0x000fe200078ee228ULL,
0x0000001020207824ULL, 0x000fe200078e0205ULL, 0x0000000526267211ULL, 0x000fe200078e20ffULL,
0x0000000116167824ULL, 0x000fe200078e0215ULL, 0x0000001c15197210ULL, 0x000fe20007ffe0ffULL,
0x0000001022227824ULL, 0x000fc400078e0205ULL, 0x0000000115177824ULL, 0x040fe200078e0218ULL,
0x0000000316007388ULL, 0x0003e20000000800ULL, 0x0000001024247824ULL, 0x100fe400078e0205ULL,
0x00000001151a7824ULL, 0x040fe200078e021aULL, 0x0000000617007388ULL, 0x0003e20000000800ULL,
0x0000001028287824ULL, 0x000fe400078e0205ULL, 0x0000000115207824ULL, 0x040fe200078e0220ULL,
0x000000071a007388ULL, 0x0003e20000000800ULL, 0x00000001151b7824ULL, 0x040fe200078e0222ULL,
0x0000002815287210ULL, 0x040fe20007ffe0ffULL, 0x0000000115247824ULL, 0x040fe200078e0224ULL,
0x0000000819007388ULL, 0x0003e20000000800ULL, 0x00000001151d7824ULL, 0x000fc600078e0226ULL,
0x0000000920007388ULL, 0x0003e80000000800ULL, 0x0000000a1b007388ULL, 0x0003e80000000800ULL,
0x0000000b24007388ULL, 0x0003e80000000800ULL, 0x0000000c1d007388ULL, 0x0003e80000000800ULL,
0x0000000d28007388ULL, 0x0003e80000000800ULL, 0x0004000e17007388ULL, 0x0003e80000000800ULL,
0x0004000f1a007388ULL, 0x0003e80000000800ULL, 0x0004001019007388ULL, 0x0003e80000000800ULL,
0x0004001120007388ULL, 0x0003e80000000800ULL, 0x000400121b007388ULL, 0x0003e80000000800ULL,
0x0004001324007388ULL, 0x0003e80000000800ULL, 0x000400141d007388ULL, 0x0003e20000000800ULL,
0x0000002000007947ULL, 0x000fea0003800000ULL, 0x0001733000287802ULL, 0x002fc40000000f00ULL,
0x0000f16000007944ULL, 0x008fea0003c00000ULL, 0x00000300ff187624ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000000011800780cULL, 0x000fda0003f05270ULL,
0x0000264000008947ULL, 0x000fea0003800000ULL, 0x0000000000077919ULL, 0x002e620000000000ULL,
0x00005800ff027624ULL, 0x000fc600078e00ffULL, 0x00000000000b7919ULL, 0x000ea20000002600ULL,
0x00006c0002027a24ULL, 0x000fc800078e02ffULL, 0x0000030002097a24ULL, 0x040fe200078e02ffULL,
0x0000000f02037811ULL, 0x000fc800078e10ffULL, 0xfffffff0030c7812ULL, 0x000fca00078ec0ffULL,
0x00000080090e7824ULL, 0x000fe400078e020cULL, 0x00000010070a7824ULL, 0x002fc600078e0204ULL,
0x0000000e09097211ULL, 0x000fe200078e38ffULL, 0x0000580000067a24ULL, 0x004fe200078e020bULL,
0x00a000000a107984ULL, 0x0002a40000000c00ULL, 0x0000007f09097810ULL, 0x000fe20007ffe0ffULL,
0x00000300060f7a24ULL, 0x000fc600078e02ffULL, 0xffffff80090d7812ULL, 0x000fe200078ec0ffULL,
0x000000010f087824ULL, 0x000fc600078e022aULL, 0x000070000d037a10ULL, 0x000fc80007f1e0ffULL,
0x0000000308027211ULL, 0x000fe200078258ffULL, 0x00007100ff037624ULL, 0x000fe200000e06ffULL,
0x000070000c147a10ULL, 0x000fc80007f1e0ffULL, 0x0000000308037211ULL, 0x000fe200008f5cffULL,
0x00007100ff167624ULL, 0x000fe200000e06ffULL, 0x000000ff7800720cULL, 0x000fc60003f25270ULL,
0x0000020078027825ULL, 0x000fcc00078e0002ULL, 0x0000001007027825ULL, 0x000fc800078e0002ULL,
0x0000011000001947ULL, 0x000fea0003800000ULL, 0x00000000000a7919ULL, 0x002e620000000000ULL,
0x0000000708097819ULL, 0x000fe200000006ffULL, 0x000000100a0b7824ULL, 0x002fe200078e00ffULL,
0x00000001ff177819ULL, 0x000fe4000001160aULL, 0x00007000090a7a10ULL, 0x000fe40007b5e00eULL,
0x000000700b157812ULL, 0x000fe400078ec0ffULL, 0x00000019ff0b7819ULL, 0x000fe40000011608ULL,
0x0000000c17087812ULL, 0x000fc400078ec0ffULL, 0x0000001415097210ULL, 0x000fe4000791e009ULL,
0x000071000b177a10ULL, 0x000fe400017e64ffULL, 0x0000000a080a7210ULL, 0x040fe40007c7e015ULL,
0x0000000908087210ULL, 0x000fe40007f5e0ffULL, 0x00000016ff097210ULL, 0x000fe400007e240bULL,
0x00000017ff0b7210ULL, 0x000fc60001fe84ffULL, 0x000000ffff097224ULL, 0x000fca00010e0609ULL,
0x0000006f08007986ULL, 0x0003e8000c101906ULL, 0x0000001e0a007986ULL, 0x0003e4000c101906ULL,
0x000000ff0700720cULL, 0x002fe20003f05270ULL, 0x0000001002007986ULL, 0x004fe2000c101d06ULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ff7800720cULL, 0x000fda0000705670ULL, 0x0000011000000947ULL, 0x000fea0003800000ULL,
0x00000004ff037424ULL, 0x000fe200078e00ffULL, 0xffffffff18097810ULL, 0x000fc60007ffe0ffULL,
0x0000700006027625ULL, 0x000fe200078e0003ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000009020279a8ULL, 0x000ea400099ee1c6ULL, 0x000000090200720cULL, 0x004fc80003f05270ULL,
0x00000001ff067807ULL, 0x000fe20000000000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000006ff007388ULL, 0x0003e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000ff027984ULL, 0x000ea40000000000ULL,
0x000000ff0200720cULL, 0x004fda0003f05270ULL, 0x000021d000008947ULL, 0x000fea0003800000ULL,
0x000000ff7800720cULL, 0x000fda0003f05270ULL, 0x00000a5000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x000001b000008947ULL, 0x000fea0003800000ULL,
0x0000001007037824ULL, 0x000fe200078e00ffULL, 0x00000001ff067819ULL, 0x002fe40000011607ULL,
0x000000140f027211ULL, 0x000fe400078038ffULL, 0x0000007003097812ULL, 0x000fe400078ec0ffULL,
0x0000000c06067812ULL, 0x000fe400078ec0ffULL, 0x000000160f037211ULL, 0x000fe400000f3cffULL,
0x0000000206027210ULL, 0x000fc8000791e009ULL, 0x00000003ff037210ULL, 0x000fca00007e24ffULL,
0x0000000602087981ULL, 0x000328000c1e1900ULL, 0x0000800602097981ULL, 0x000322000c1e1900ULL,
0x000000021800780cULL, 0x000fda0003f05270ULL, 0x000000f000008947ULL, 0x000fea0003800000ULL,
0x00010006020b7981ULL, 0x002322000c1e1900ULL, 0x000000041800780cULL, 0x000fda0003f06070ULL,
0x000000c000008947ULL, 0x000fea0003800000ULL, 0x0001800602117981ULL, 0x002322000c1e1900ULL,
0x000000041800780cULL, 0x000fda0003f05270ULL, 0x0000009000008947ULL, 0x000fea0003800000ULL,
0x0002000602137981ULL, 0x002322000c1e1900ULL, 0x000000061800780cULL, 0x000fda0003f06070ULL,
0x0000006000008947ULL, 0x000fea0003800000ULL, 0x0002800602157981ULL, 0x002322000c1e1900ULL,
0x000000061800780cULL, 0x000fda0003f05270ULL, 0x0000003000008947ULL, 0x000fea0003800000ULL,
0x000000081800780cULL, 0x002fe20003f06070ULL, 0x0003000602177981ULL, 0x000318000c1e1900ULL,
0x0003800602190981ULL, 0x000324000c1e1900ULL, 0x0000000718027810ULL, 0x002fc80007ffe0ffULL,
0x00000003ff067819ULL, 0x000fc80000011602ULL, 0x000000ff0600720cULL, 0x000fda0003f05270ULL,
0x000007d000008947ULL, 0x000fea0003800000ULL, 0x0000000c0f1d7211ULL, 0x000fe200078038ffULL,
0x000000ffff107224ULL, 0x000fe200078e00ffULL, 0x00000008001b7202ULL, 0x010fe20000000f00ULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x000070001d1d7a10ULL, 0x000fe40007f3e0ffULL,
0x000000ff0f0a7211ULL, 0x000fe400000f3cffULL, 0x000007801d1d7810ULL, 0x000fc80007f5e0ffULL,
0x00007100ff0a7a10ULL, 0x000fc400017e240aULL, 0x0000030010007a0cULL, 0x000fe20003f26070ULL,
0x0000000104047890ULL, 0x000fcc000fffe03fULL, 0x0000000406007c0cULL, 0x000fcc000bf03070ULL,
0x000006d000001947ULL, 0x012fea0003800000ULL, 0x0000000810027810ULL, 0x040fe40007ffe0ffULL,
0x0000000110037810ULL, 0x000fe40007ffe0ffULL, 0x0000030002007a0cULL, 0x000fe40003f26070ULL,
0x0000030003007a0cULL, 0x000fe40003f46070ULL, 0x0000001b08087209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001007027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011607ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x000000021d027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e060aULL, 0xfffc8006021b7981ULL, 0x000326000c1e1900ULL,
0x000005f000002947ULL, 0x000fea0003800000ULL, 0x0000000910027810ULL, 0x042fe40007ffe0ffULL,
0x0000000210037810ULL, 0x000fe40007ffe0ffULL, 0x0000030002007a0cULL, 0x000fe40003f26070ULL,
0x0000030003007a0cULL, 0x000fe40003f46070ULL, 0x0000000908087209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001007027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011607ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x000000021d027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e060aULL, 0xfffd000602097981ULL, 0x000326000c1e1900ULL,
0x0000051000002947ULL, 0x000fea0003800000ULL, 0x0000000a10027810ULL, 0x042fe40007ffe0ffULL,
0x0000000310037810ULL, 0x000fe40007ffe0ffULL, 0x0000030002007a0cULL, 0x000fe40003f26070ULL,
0x0000030003007a0cULL, 0x000fe40003f46070ULL, 0x0000000b08087209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000000407027819ULL, 0x000fe400000006ffULL,
0x00000001ff037819ULL, 0x000fe40000011607ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x000000021d027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e060aULL, 0xfffd8006020b7981ULL, 0x000326000c1e1900ULL,
0x0000043000002947ULL, 0x000fea0003800000ULL, 0x0000000b10027810ULL, 0x042fe40007ffe0ffULL,
0x0000000410037810ULL, 0x000fe40007ffe0ffULL, 0x0000030002007a0cULL, 0x000fe40003f26070ULL,
0x0000030003007a0cULL, 0x000fe40003f46070ULL, 0x0000001108087209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001007027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011607ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x000000021d027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e060aULL, 0xfffe000602117981ULL, 0x000326000c1e1900ULL,
0x0000035000002947ULL, 0x000fea0003800000ULL, 0x0000000c10027810ULL, 0x042fe40007ffe0ffULL,
0x0000000510037810ULL, 0x000fe40007ffe0ffULL, 0x0000030002007a0cULL, 0x000fe40003f26070ULL,
0x0000030003007a0cULL, 0x000fe40003f46070ULL, 0x0000001308087209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001007027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011607ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x000000021d027210ULL, 0x000fc80007f3e0ffULL,
0x0000000aff037210ULL, 0x000fca0000ffe4ffULL, 0xfffe800602137981ULL, 0x000328000c1e1900ULL,
0x0000027000002947ULL, 0x000fea0003800000ULL, 0x0000000d10027810ULL, 0x042fe40007ffe0ffULL,
0x0000000610037810ULL, 0x000fe40007ffe0ffULL, 0x0000030002007a0cULL, 0x000fe40003f26070ULL,
0x0000030003007a0cULL, 0x000fe40003f46070ULL, 0x0000001508087209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001007027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011607ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x000000021d027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e060aULL, 0xffff000602157981ULL, 0x000326000c1e1900ULL,
0x0000019000002947ULL, 0x000fea0003800000ULL, 0x0000000e10027810ULL, 0x042fe40007ffe0ffULL,
0x0000000710037810ULL, 0x000fe40007ffe0ffULL, 0x0000030002007a0cULL, 0x000fe40003f26070ULL,
0x0000030003007a0cULL, 0x000fe40003f46070ULL, 0x0000001708087209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001007027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011607ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x000000021d027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e060aULL, 0xffff800602177981ULL, 0x000326000c1e1900ULL,
0x000000b000002947ULL, 0x000fea0003800000ULL, 0x0000000f10027810ULL, 0x002fe40007ffe0ffULL,
0x0000001908087209ULL, 0x000fe40007810000ULL, 0x0000030002007a0cULL, 0x000fda0003f26070ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000000407027819ULL, 0x000fe400000006ffULL,
0x00000001ff037819ULL, 0x000fe40000011607ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x000000021d027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e060aULL, 0x0000000602197981ULL, 0x000326000c1e1900ULL,
0x000004001d1d7810ULL, 0x000fe40007f3e0ffULL, 0x0000000810107810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff0a7224ULL, 0x000fe200008e060aULL, 0xfffff8b000008947ULL, 0x000fea000383ffffULL,
0x0000000000077919ULL, 0x000ea40000000000ULL, 0x0000001007027824ULL, 0x006fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011607ULL, 0x0000007002027812ULL, 0x000fe400078ec0ffULL,
0x0000000c03037812ULL, 0x000fca00078ec0ffULL, 0x0000000102037824ULL, 0x000fca00078e0203ULL,
0x0000000803007388ULL, 0x0103e40000000800ULL, 0x000070000d027a10ULL, 0x000fe20007f1e0ffULL,
0x00000200783d7824ULL, 0x000fe200078e00ffULL, 0x00000017ff3f7819ULL, 0x000fe20000011678ULL,
0x0000001007067824ULL, 0x002fe200078e00ffULL, 0x00007100ff037a10ULL, 0x000fe200007fe4ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000008000f087825ULL, 0x000fe200078e0002ULL,
0x000000070700780cULL, 0x000fe20003f04070ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x00000001ff0a7819ULL, 0x000fe20000011607ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x0000003d08087210ULL, 0x000fe20007f3e0ffULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x000070000c427a10ULL, 0x000fe20007f5e0ffULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000007006067812ULL, 0x000fe200078ec0ffULL, 0x0000000109097824ULL, 0x000fe200008e063fULL,
0x000070000e3e7a10ULL, 0x000fe20007f3e0ffULL, 0x00007100ff447624ULL, 0x000fe200010e06ffULL,
0x0000000c0a0b7812ULL, 0x000fe200078ec0ffULL, 0x0000001078138824ULL, 0x000fe200078e0207ULL,
0x000000420f0c8211ULL, 0x040fe200078438ffULL, 0x00007100ff407624ULL, 0x000fe200008e06ffULL,
0x0000003e0f0a8211ULL, 0x040fe200078238ffULL, 0x0000000106067824ULL, 0x000fe200078e020bULL,
0x0000000c780e7819ULL, 0x040fe200000006ffULL, 0x0000001078158824ULL, 0x000fe200078e0207ULL,
0x000000400f0b8211ULL, 0x000fe200008f3cffULL, 0x0000001007087825ULL, 0x000fe200078e0008ULL,
0x00000300ff007a0cULL, 0x000fe20003f25270ULL, 0x0000000006067984ULL, 0x000e620000000800ULL,
0x000000440f0d8211ULL, 0x000fe200010f3cffULL, 0x00000010070a8825ULL, 0x040fe200078e000aULL,
0x0000000e07117211ULL, 0x000fe200078e20ffULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000458013138811ULL, 0x000fe200078e20ffULL, 0x00000010070c8825ULL, 0x000fe200078e000cULL,
0x0000418015158811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000008117faeULL, 0x0005e2000b901c46ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x000000000a138faeULL, 0x0009e2000b901c46ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x000000000c158faeULL, 0x0007e2000b901c46ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff307224ULL, 0x000fe200078e00ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000000107805ULL, 0x004fe2000001ff00ULL,
0x0000000000127805ULL, 0x010fe2000001ff00ULL, 0x0000000000147805ULL, 0x008fe2000001ff00ULL,
0x00000b9000009947ULL, 0x000fea0003800000ULL, 0x000000010f0f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff107224ULL, 0x000fc400078e00ffULL, 0x00000001ff437424ULL, 0x000fca00078e00ffULL,
0x0000030043007a0cULL, 0x000fda0003f06070ULL, 0x000001c000000947ULL, 0x000fea0003800000ULL,
0x000000070700780cULL, 0x000fe20003f44070ULL, 0x000008000f087825ULL, 0x000fe200078e0002ULL,
0x00000001430d7812ULL, 0x000fc600078ec0ffULL, 0x00000800430a7824ULL, 0x000fe200078e00ffULL,
0x0000003d08087210ULL, 0x000fc80007f1e0ffULL, 0x000008000a0b7812ULL, 0x000fe200078ec0ffULL,
0x0000000109097824ULL, 0x000fe400000e063fULL, 0x0000000d7834a211ULL, 0x040fe200078e08ffULL,
0x000000027836a824ULL, 0x000fe200078e020dULL, 0x0000003e0f0aa211ULL, 0x040fe200078038ffULL,
0x000000010e327824ULL, 0x000fe200078e020bULL, 0x000000420f0ca211ULL, 0x040fe200078238ffULL,
0x000000083433a824ULL, 0x000fe200078e0207ULL, 0x000000400f0ba211ULL, 0x000fe200000f3cffULL,
0x0000001007317824ULL, 0x000fe200078e0232ULL, 0x000000440f0da211ULL, 0x000fe200008f3cffULL,
0x0000001007087825ULL, 0x000fe200078e0008ULL, 0x000000073635a211ULL, 0x000fc400078e18ffULL,
0x000045803333a811ULL, 0x000fe200078e20ffULL, 0x00000010070aa825ULL, 0x000fe200078e000aULL,
0x000041803535a811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000008317faeULL, 0x0005e4000b901c46ULL, 0x00000010070ca825ULL, 0x000fe400078e000cULL,
0x000000000a33afaeULL, 0x0005e8000b901c46ULL, 0x000000000c35afaeULL, 0x0005e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffff43087810ULL, 0x004fe20007ffe0ffULL,
0x00000010070a7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0b7819ULL, 0x000fc40000011607ULL,
0x00000002ff3c7819ULL, 0x000fe20000011607ULL, 0x0000008008097824ULL, 0x000fe200078e00ffULL,
0x000000700a0a7812ULL, 0x000fe200078ec0ffULL, 0x0000080008087824ULL, 0x000fe200078e00ffULL,
0x0000000c0b0b7812ULL, 0x000fe200078ec0ffULL, 0x000000083c387824ULL, 0x040fe200078e00ffULL,
0x0000008009097812ULL, 0x000fe200078ec0ffULL, 0x000000083c487824ULL, 0x040fe200078e00ffULL,
0x000000033c0d7819ULL, 0x040fe200000006ffULL, 0x000000083c377824ULL, 0x040fe200078e00ffULL,
0x000000083c4e7810ULL, 0x000fe20007ffe0ffULL, 0x0000010078097824ULL, 0x000fe200078e0209ULL,
0x000000013c0c7810ULL, 0x000fc40007ffe0ffULL, 0x000000043c337810ULL, 0x000fe20007ffe0ffULL,
0x000000084e317824ULL, 0x000fe200078e00ffULL, 0x000000090b0a7210ULL, 0x000fe20007ffe00aULL,
0x0000000407097824ULL, 0x000fe200078e00ffULL, 0xfffffff80d367812ULL, 0x000fe200078ee20cULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x004180000a0b7984ULL, 0x000ea20000000800ULL,
0x0000000c09417812ULL, 0x000fe400078ec0ffULL, 0x0000080008097812ULL, 0x000fe200078ec0ffULL,
0x004580000a327984ULL, 0x0007e20000000800ULL, 0xfffffff80d087812ULL, 0x000fe400078ee23cULL,
0x000001800e097810ULL, 0x000fe40007ffe009ULL, 0x000000023c0c7810ULL, 0x040fe40007ffe0ffULL,
0x000000033c467819ULL, 0x000fe200000006ffULL, 0x0000001008087824ULL, 0x000fe200078e0209ULL,
0xfffffff8310a7812ULL, 0x008fc400078ee24eULL, 0xfffffff80d3a7812ULL, 0x000fe200078ee20cULL,
0x0000000141087824ULL, 0x040fe200078e0208ULL, 0x000000090a0a7211ULL, 0x000fe400078e20ffULL,
0x000000033c317810ULL, 0x000fe40007ffe0ffULL, 0x0000000008347984ULL, 0x0007220000000800ULL,
0x00000001410c7824ULL, 0x000fe200078e020aULL, 0xfffffff846467812ULL, 0x000fe200078ee233ULL,
0x00000010360a7824ULL, 0x000fe200078e0209ULL, 0xfffffff838367812ULL, 0x000fc400078ee231ULL,
0x000000000c387984ULL, 0x0003e20000000800ULL, 0x00000001410a7824ULL, 0x040fe200078e020aULL,
0x000000053c337810ULL, 0x000fe20007ffe0ffULL, 0x0000001036087824ULL, 0x008fe200078e0209ULL,
0x000000033c4a7819ULL, 0x000fe400000006ffULL, 0x000000000a357984ULL, 0x000fe20000000800ULL,
0xfffffff848487812ULL, 0x000fe200078ee233ULL, 0x0000000141087824ULL, 0x000fe200078e0208ULL,
0xffffffff3c0c7810ULL, 0x002fe20007ffe0ffULL, 0x000400000a397984ULL, 0x0003e20000000800ULL,
0x0000030043007a0cULL, 0x000fe20003f06070ULL, 0x0000000b060b7221ULL, 0x004fe20000010100ULL,
0xfffffff8374c7812ULL, 0x000fe200078ee20cULL, 0x00040000083b7984ULL, 0x000fe20000000800ULL,
0x00000009480c7211ULL, 0x000fe200078e20ffULL, 0x3fb8aa3b0b0b7820ULL, 0x000fe20000410000ULL,
0x00000010460a7824ULL, 0x002fe200078e0209ULL, 0x0000000008377984ULL, 0x0009e20000000800ULL,
0x000000010f0f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000b000d7308ULL, 0x0002a20000000800ULL,
0x00000001410a7824ULL, 0x000fe200078e020aULL, 0x0000000143437810ULL, 0x000fe20007ffe0ffULL,
0x00000001410c7824ULL, 0x000fc400078e020cULL, 0x000000103a0b7824ULL, 0x002fc800078e0209ULL,
0x00000001410b7824ULL, 0x000fe200078e020bULL, 0x00005410ff087816ULL, 0x010fe20000000034ULL,
0x000000320d317220ULL, 0x004fe20000410000ULL, 0x000000063c0d7810ULL, 0x000fe40007ffe0ffULL,
0x000000000b367984ULL, 0x000fe20000000800ULL, 0x0000003031307221ULL, 0x000fe20000010000ULL,
0xfffffff84a4a7812ULL, 0x000fe400078ee20dULL, 0x00001f3c31327589ULL, 0x000e6800000e0000ULL,
0x00001f4e31337589ULL, 0x000ea200000e0000ULL, 0x000000104a0d7824ULL, 0x000fc400078e0209ULL,
0x000000104c097824ULL, 0x000fe200078e0209ULL, 0x000400000b3a7984ULL, 0x0007240000000800ULL,
0x0000000d410d7210ULL, 0x040fe20007ffe0ffULL, 0x0000000141097824ULL, 0x000fe200078e0209ULL,
0x000000000a317984ULL, 0x000f220000000800ULL, 0x00007610ff0b7816ULL, 0x008fc60000000034ULL,
0x000400000a3c7984ULL, 0x000ee80000000800ULL, 0x000000000c347984ULL, 0x000ee20000000800ULL,
0x000000320b2e7223ULL, 0x082fe2000001002eULL, 0x00000032082f7223ULL, 0x000fe2000001002fULL,
0x00007610ff0b7816ULL, 0x100fe20000000038ULL, 0x000000000d0a7984ULL, 0x000fe20000000800ULL,
0x00005410ff087816ULL, 0x000fc60000000038ULL, 0x000000330b2c7223ULL, 0x084fe2000001002cULL,
0x00007610ff0b7816ULL, 0x000fe20000000035ULL, 0x00000033082d7223ULL, 0x080fe2000001002dULL,
0x00005410ff087816ULL, 0x000fe20000000035ULL, 0x000400000c387984ULL, 0x000e640000000800ULL,
0x000000320b2a7223ULL, 0x080fe2000001002aULL, 0x00007610ff0b7816ULL, 0x000fe20000000039ULL,
0x00000032082b7223ULL, 0x080fe2000001002bULL, 0x00005410ff087816ULL, 0x000fe20000000039ULL,
0x000400000d357984ULL, 0x000ea40000000800ULL, 0x000000330b287223ULL, 0x080fe20000010028ULL,
0x00007610ff0b7816ULL, 0x100fe20000000036ULL, 0x0000003308297223ULL, 0x000fe20000010029ULL,
0x00005410ff087816ULL, 0x000fe20000000036ULL, 0x00000000090c7984ULL, 0x000e640000000800ULL,
0x000000320b267223ULL, 0x000fc40000010026ULL, 0x0000003208277223ULL, 0x000fe20000010027ULL,
0x00040000090b7984ULL, 0x0006a20000000800ULL, 0x00005410ff087816ULL, 0x010fca000000003aULL,
0x0000003308257223ULL, 0x000fe20000010025ULL, 0x00005410ff087816ULL, 0x000fe40000000037ULL,
0x00007610ff097816ULL, 0x008fc6000000003aULL, 0x0000003208237223ULL, 0x000fe20000010023ULL,
0x00005410ff087816ULL, 0x000fe2000000003bULL, 0x0000003309247223ULL, 0x000fe20000010024ULL,
0x00007610ff097816ULL, 0x000fc60000000037ULL, 0x0000003308217223ULL, 0x000fe20000010021ULL,
0x00005410ff087816ULL, 0x000fe20000000031ULL, 0x0000003209227223ULL, 0x000fe20000010022ULL,
0x00007610ff097816ULL, 0x000fc6000000003bULL, 0x00000032081f7223ULL, 0x000fe2000001001fULL,
0x00005410ff087816ULL, 0x000fe2000000003cULL, 0x0000003309207223ULL, 0x000fe20000010020ULL,
0x00007610ff097816ULL, 0x000fc60000000031ULL, 0x00000033081d7223ULL, 0x000fe2000001001dULL,
0x00005410ff087816ULL, 0x000fe20000000034ULL, 0x00000032091e7223ULL, 0x000fe2000001001eULL,
0x00007610ff097816ULL, 0x000fc6000000003cULL, 0x0000003208157223ULL, 0x000fe20000010015ULL,
0x00007610ff087816ULL, 0x000fe20000000034ULL, 0x00000033091c7223ULL, 0x000fe2000001001cULL,
0x00005410ff097816ULL, 0x002fc60000000038ULL, 0x00000032081b7223ULL, 0x000fe2000001001bULL,
0x00007610ff087816ULL, 0x000fe20000000038ULL, 0x00000033091a7223ULL, 0x000fe2000001001aULL,
0x00005410ff097816ULL, 0x004fc60000000035ULL, 0x0000003308137223ULL, 0x080fe20000010013ULL,
0x00005410ff087816ULL, 0x000fe2000000000aULL, 0x0000003309187223ULL, 0x000fe20000010018ULL,
0x00005410ff097816ULL, 0x000fc6000000000cULL, 0x0000003208117223ULL, 0x080fe20000010011ULL,
0x00007610ff087816ULL, 0x000fe2000000000aULL, 0x0000003209167223ULL, 0x000fe20000010016ULL,
0x00007610ff097816ULL, 0x000fc6000000000cULL, 0x0000003208197223ULL, 0x080fe20000010019ULL,
0x00007610ff087816ULL, 0x000fe20000000035ULL, 0x0000003209147223ULL, 0x000fe20000010014ULL,
0x00005410ff097816ULL, 0x000fc6000000000bULL, 0x0000003308177223ULL, 0x080fe40000010017ULL,
0x0000003309127223ULL, 0x000fe20000010012ULL, 0x00007610ff097816ULL, 0x000fca000000000bULL,
0x0000003309107223ULL, 0x000fe20000010010ULL, 0xfffff4a000008947ULL, 0x000fea000383ffffULL,
0x0180000030027810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x7f80000002027812ULL, 0x000fe200078ec0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x01ffffff0200780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x0001920000067802ULL, 0x002fc40000000f00ULL, 0x0000d04000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff027224ULL, 0x00cfe200078e0003ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000003000037308ULL, 0x000ea40000001000ULL, 0xbf80000003027423ULL, 0x004fc80000000030ULL,
0x800000ff02027221ULL, 0x000fc80000010100ULL, 0x0000000203027223ULL, 0x000fc40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000097919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000002ff0b7819ULL, 0x004fc40000011609ULL,
0x00000008090d7811ULL, 0x040fe200078ff0ffULL, 0x0000000409097824ULL, 0x000fe200078e00ffULL,
0x000000040b0f7810ULL, 0x040fe20007ffe0ffULL, 0x00001f0b02067589ULL, 0x002e6200000e0000ULL,
0x000000020b0c7810ULL, 0x040fe20007ffe0ffULL, 0x000000080b307824ULL, 0x040fe200078e00ffULL,
0x000000030b0e7810ULL, 0x040fe20007ffe0ffULL, 0x00001f0d02077589ULL, 0x0004e200000e0000ULL,
0x000000030b317819ULL, 0x000fe200000006ffULL, 0x000000080d347824ULL, 0x000fe200078e00ffULL,
0x000000030b327819ULL, 0x000fc400000006ffULL, 0xfffffff8310e7812ULL, 0x000fe400078ee20eULL,
0xfffffff834347812ULL, 0x000fe400078ee20dULL, 0x0000000c09097812ULL, 0x000fe200078ec0ffULL,
0x000000100e0e7824ULL, 0x100fe400078e0205ULL, 0x0000001034347824ULL, 0x000fe200078e0205ULL,
0x0000001906087220ULL, 0x042fe20000410000ULL, 0x0000002f062f7220ULL, 0x040fe20000410000ULL,
0x0000002e062e7220ULL, 0x040fe20000410000ULL, 0x0000002b062b7220ULL, 0x040fe20000410000ULL,
0x0000002a062a7220ULL, 0x040fe20000410000ULL, 0x0000002706277220ULL, 0x040fe20000410000ULL,
0x0000002606267220ULL, 0x040fe20000410000ULL, 0x0000002306237220ULL, 0x040fe20000410000ULL,
0x0000002206227220ULL, 0x040fe20000410000ULL, 0x0000001f061f7220ULL, 0x040fe20000410000ULL,
0x0000001e061e7220ULL, 0x040fe20000410000ULL, 0x0000001506157220ULL, 0x040fe20000410000ULL,
0x0000001b06027220ULL, 0x044fe20000410000ULL, 0x0000001106117220ULL, 0x040fe20000410000ULL,
0x0000001606167220ULL, 0x040fe20000410000ULL, 0x0000001406037220ULL, 0x000fe20000410000ULL,
0x000000080b197824ULL, 0x040fe200078e00ffULL, 0x000000010b067810ULL, 0x000fe20007ffe0ffULL,
0x0000002d072d7220ULL, 0x048fe20000410000ULL, 0x0000002c072c7220ULL, 0x040fe20000410000ULL,
0x0000002907297220ULL, 0x040fe20000410000ULL, 0x0000002807287220ULL, 0x040fe20000410000ULL,
0x0000002507257220ULL, 0x040fe20000410000ULL, 0x0000002407247220ULL, 0x040fe20000410000ULL,
0x0000002107217220ULL, 0x040fe20000410000ULL, 0x0000002007207220ULL, 0x040fe20000410000ULL,
0x0000001d071d7220ULL, 0x040fe20000410000ULL, 0x0000001c071c7220ULL, 0x040fe20000410000ULL,
0x0000001a071a7220ULL, 0x040fe20000410000ULL, 0x0000001307137220ULL, 0x040fe20000410000ULL,
0x0000001807187220ULL, 0x040fe20000410000ULL, 0x0000001707177220ULL, 0x040fe20000410000ULL,
0x0000001207127220ULL, 0x040fe20000410000ULL, 0x0000001007077220ULL, 0x000fe20000410000ULL,
0x000000080b107824ULL, 0x000fe200078e00ffULL, 0xfffffff8190a7812ULL, 0x000fe200078ee206ULL,
0x000000080b1b7824ULL, 0x040fe200078e00ffULL, 0x000000060b197810ULL, 0x040fe20007ffe0ffULL,
0x000000080b067824ULL, 0x040fe200078e00ffULL, 0xfffffff810107812ULL, 0x000fe200078ee20fULL,
0x000000080b147824ULL, 0x000fe200078e00ffULL, 0xfffffff81b0c7812ULL, 0x000fe200078ee20cULL,
0x000000100a0a7824ULL, 0x100fe200078e0205ULL, 0x000000050b0f7810ULL, 0x040fe20007ffe0ffULL,
0x0000001010107824ULL, 0x000fe200078e0205ULL, 0xffffffff0b1b7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff806067812ULL, 0x000fe200078ee20bULL, 0x00000001090b7824ULL, 0x040fe200078e020aULL,
0xfffffff814147812ULL, 0x000fe400078ee20fULL, 0xfffffff830307812ULL, 0x000fe200078ee219ULL,
0x0000001006067824ULL, 0x000fe200078e0205ULL, 0xfffffff832327812ULL, 0x000fe200078ee21bULL,
0x0000001014147824ULL, 0x100fe200078e0205ULL, 0x000000050c0c7211ULL, 0x080fe200078e20ffULL,
0x0000001030307824ULL, 0x000fe200078e0205ULL, 0x0000000532327211ULL, 0x000fe200078e20ffULL,
0x0000000106057824ULL, 0x000fe200078e0209ULL, 0x0000002f2e2e723eULL, 0x000fe200000010ffULL,
0x00000001090d7824ULL, 0x040fe200078e020cULL, 0x0000002b2a2a723eULL, 0x000fe200000010ffULL,
0x0000000109147824ULL, 0x040fe200078e0214ULL, 0x000000272626723eULL, 0x000fe200000010ffULL,
0x0000002e05007388ULL, 0x0003e20000000800ULL, 0x000000232222723eULL, 0x000fe200000010ffULL,
0x0000000109307824ULL, 0x040fe200078e0230ULL, 0x000000110808723eULL, 0x000fe200000010ffULL,
0x0000000109117824ULL, 0x040fe200078e0210ULL, 0x0000000e090f7210ULL, 0x040fe20007ffe0ffULL,
0x0000002a0b007388ULL, 0x0003e20000000800ULL, 0x0000001f1e1e723eULL, 0x000fe200000010ffULL,
0x0000000109327824ULL, 0x000fe200078e0232ULL, 0x000000150202723eULL, 0x000fe200000010ffULL,
0x000000260d007388ULL, 0x0003e20000000800ULL, 0x000000160303723eULL, 0x000fc400000010ffULL,
0x0000002d2c2c723eULL, 0x000fe200000010ffULL, 0x000000220f007388ULL, 0x0003e20000000800ULL,
0x0000003409097210ULL, 0x000fe40007ffe0ffULL, 0x000000292828723eULL, 0x000fe200000010ffULL,
0x0000001e11007388ULL, 0x0003e20000000800ULL, 0x000000252424723eULL, 0x000fe400000010ffULL,
0x000000212020723eULL, 0x000fe200000010ffULL, 0x0000000214007388ULL, 0x0003e20000000800ULL,
0x0000001d1c1c723eULL, 0x000fc400000010ffULL, 0x0000001a1313723eULL, 0x000fe200000010ffULL,
0x0000000830007388ULL, 0x0003e20000000800ULL, 0x000000181717723eULL, 0x000fe400000010ffULL,
0x000000120707723eULL, 0x000fe200000010ffULL, 0x0000000332007388ULL, 0x0003e80000000800ULL,
0x0000002c09007388ULL, 0x0003e80000000800ULL, 0x000400280b007388ULL, 0x0003e80000000800ULL,
0x000400240d007388ULL, 0x0003e80000000800ULL, 0x000400200f007388ULL, 0x0003e80000000800ULL,
0x0004001c11007388ULL, 0x0003e80000000800ULL, 0x0004001314007388ULL, 0x0003e80000000800ULL,
0x0004001730007388ULL, 0x0003e80000000800ULL, 0x0004000732007388ULL, 0x0003e20000000800ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000000000087919ULL, 0x002e620000000000ULL,
0x0000580000007a24ULL, 0x000fc600078e02ffULL, 0x0000000000097919ULL, 0x000ea20000002600ULL,
0x00000003ff027819ULL, 0x002fca0000011608ULL, 0x0000000102037824ULL, 0x000fca00078e0208ULL,
0x0000000703037812ULL, 0x000fc800078ec0ffULL, 0x0ffffff803037812ULL, 0x000fca00078ef808ULL,
0x0000001003047824ULL, 0x000fe400078e0204ULL, 0x0000580002037a24ULL, 0x004fe200078e0209ULL,
0x0000000708097812ULL, 0x000fc600078ec0ffULL, 0x00a0000004047984ULL, 0x000e620000000c00ULL,
0x0000000300007211ULL, 0x000fe400078010ffULL, 0x1ffffff809097812ULL, 0x000fc600078ef872ULL,
0x000000ffff037224ULL, 0x000fe200000e06ffULL, 0x00005a0000027a11ULL, 0x000fc800078048ffULL,
0x00005b0000037a11ULL, 0x000fca00000f4c03ULL, 0x0000001009027825ULL, 0x000fca00078e0002ULL,
0x0000000402007986ULL, 0x002fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000040787d7824ULL, 0x040fe200078e00ffULL, 0x0000002015067810ULL, 0x040fe20007ffe0ffULL,
0x00000100787c7824ULL, 0x000fe200078e00ffULL, 0x000000031500780cULL, 0x000fe40003f44070ULL,
0x0000007d7a0a7211ULL, 0x000fe400078e40ffULL, 0x00000001ff7b7819ULL, 0x000fc60000011678ULL,
0x000000010a047824ULL, 0x040fe400078e0215ULL, 0x0000680077037a24ULL, 0x000fe400078e020aULL,
0x000000010a087824ULL, 0x100fe200078e0206ULL, 0x000000750400720cULL, 0x000fe20003f06070ULL,
0x0000000103067824ULL, 0x040fe200078e0206ULL, 0x0000001503047210ULL, 0x000fe20007ffe0ffULL,
0x0000000415037824ULL, 0x000fe200078e027cULL, 0x000000750800720cULL, 0x000fe20003f26070ULL,
0x0000660006067625ULL, 0x000fc800078e0017ULL, 0x0000660004047625ULL, 0x000fe200078e0017ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014ad000ff087f8cULL, 0x000e62000c80043fULL,
0x0000010000007945ULL, 0x000fe20003800000ULL, 0x000000027a7b7824ULL, 0x000fe400078e027bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x1460000004037faeULL, 0x0005e8000c121846ULL,
0x1468000006037faeULL, 0x0005e2000c921846ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x0000000400047824ULL, 0x004fe200078e0215ULL, 0x000000767b00720cULL, 0x000fc40003f06070ULL,
0x0000001578037211ULL, 0x000fe200078e10ffULL, 0x0000000204047824ULL, 0x000fc600078e00ffULL,
0x00014a8003037811ULL, 0x000fe200078e10ffULL, 0x0000640004047a24ULL, 0x000fc800078e027bULL,
0x0000600004047625ULL, 0x000fca00078e0017ULL, 0x0000000004037faeULL, 0x0005e4000c121846ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000017a037810ULL, 0x004fe20007ffe0ffULL, 0x0000008070067824ULL, 0x000fe200078e00ffULL,
0x0000580000047ab9ULL, 0x000fe40000000800ULL, 0x000000740300720cULL, 0x000fe20003f06070ULL,
0x0000000704047899ULL, 0x000fe2000800063fULL, 0x000000ffff037224ULL, 0x002fe200078e0009ULL,
0x0000004006177812ULL, 0x000fe200078ef80aULL, 0x000080000000791aULL, 0x000fc80000000000ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000093000008947ULL, 0x000fea0003800000ULL,
0x00000000000b7919ULL, 0x000e620000000000ULL, 0x00014a80780f7811ULL, 0x040fe200078e20ffULL,
0x00000200ff127424ULL, 0x000fe200078e00ffULL, 0x0000200078117811ULL, 0x000fe400078e68ffULL,
0x00000002ff107819ULL, 0x002fe2000001160bULL, 0x000000100b157824ULL, 0x000fc600078e00ffULL,
0x0000001017087210ULL, 0x000fe20007ffe0ffULL, 0x00000004100d7824ULL, 0x000fe200078e027cULL,
0x0000003015157812ULL, 0x000fc800078ec0ffULL, 0x014600000d047984ULL, 0x000e640000000800ULL,
0x0000000404097824ULL, 0x002fe200078e020fULL, 0x0000000a75047217ULL, 0x000fca0007800000ULL,
0x0000000009097984ULL, 0x000e620000000800ULL, 0x0000000104077824ULL, 0x000fe200078e0a0aULL,
0x00000008100a7810ULL, 0x000fc80007ffe0ffULL, 0x000000071000720cULL, 0x000fe20003f06070ULL,
0x0000000409057c24ULL, 0x002fe2000f8e0208ULL, 0x0000000b0b087211ULL, 0x000fc600078fe8ffULL,
0x00005e0005047625ULL, 0x000fe200078e0012ULL, 0x00000003080c7812ULL, 0x000fc800078ec0ffULL,
0x0000001504087210ULL, 0x000fe40007f3e0ffULL, 0x0ffffffc0c047812ULL, 0x000fe200078ef80bULL,
0x000000040a0b7824ULL, 0x000fe400078e00ffULL, 0x000000ffff097224ULL, 0x000fe200008e0605ULL,
0x0000001104137211ULL, 0x000fe200078e20ffULL, 0x0000000117057824ULL, 0x000fc800078e020aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008137faeULL, 0x0003e2000c101c46ULL,
0x000000070a00720cULL, 0x000fc60003f06070ULL, 0x014620000d047984ULL, 0x000ea20000000800ULL,
0x0000001010087810ULL, 0x002fca0007ffe0ffULL, 0x0000000408097824ULL, 0x000fe400078e00ffULL,
0x00000004040e7824ULL, 0x004fcc00078e020fULL, 0x000000000e0e7984ULL, 0x000e640000000800ULL,
0x000000040e057c24ULL, 0x002fc8000f8e0205ULL, 0x00005e0005047625ULL, 0x000fca00078e0012ULL,
0x00000015040a7210ULL, 0x000fe40007f3e0ffULL, 0xfffffffc0b047812ULL, 0x000fc600078ee20cULL,
0x000000ffff0b7224ULL, 0x000fe200008e0605ULL, 0x0000001104137211ULL, 0x000fe200078e20ffULL,
0x0000000117057824ULL, 0x000fc800078e0208ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a137faeULL, 0x0003e2000c101c46ULL, 0x000000070800720cULL, 0x000fc60003f06070ULL,
0x014640000d047984ULL, 0x000ea20000000800ULL, 0x00000018100a7810ULL, 0x002fca0007ffe0ffULL,
0x000000040a0b7824ULL, 0x000fe400078e00ffULL, 0x00000004040e7824ULL, 0x004fcc00078e020fULL,
0x000000000e0e7984ULL, 0x000e640000000800ULL, 0x000000040e057c24ULL, 0x002fc8000f8e0205ULL,
0x00005e0005047625ULL, 0x000fca00078e0012ULL, 0x0000001504087210ULL, 0x000fe40007f3e0ffULL,
0xfffffffc09047812ULL, 0x000fc600078ee20cULL, 0x000000ffff097224ULL, 0x000fe200008e0605ULL,
0x0000001104137211ULL, 0x000fe200078e20ffULL, 0x0000000117057824ULL, 0x000fc800078e020aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008137faeULL, 0x0003e2000c101c46ULL,
0x000000070a00720cULL, 0x000fc60003f06070ULL, 0x014660000d047984ULL, 0x000ea20000000800ULL,
0x0000002010087810ULL, 0x002fca0007ffe0ffULL, 0x0000000408097824ULL, 0x000fe400078e00ffULL,
0x00000004040e7824ULL, 0x004fcc00078e020fULL, 0x000000000e0e7984ULL, 0x000e640000000800ULL,
0x000000040e057c24ULL, 0x002fc8000f8e0205ULL, 0x00005e0005047625ULL, 0x000fca00078e0012ULL,
0x00000015040a7210ULL, 0x000fe40007f3e0ffULL, 0xfffffffc0b047812ULL, 0x000fc600078ee20cULL,
0x000000ffff0b7224ULL, 0x000fe200008e0605ULL, 0x0000001104137211ULL, 0x000fe200078e20ffULL,
0x0000000117057824ULL, 0x000fc800078e0208ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a137faeULL, 0x0003e2000c101c46ULL, 0x000000070800720cULL, 0x000fc60003f06070ULL,
0x014680000d047984ULL, 0x000ea20000000800ULL, 0x00000028100a7810ULL, 0x002fca0007ffe0ffULL,
0x000000040a0b7824ULL, 0x000fe400078e00ffULL, 0x00000004040e7824ULL, 0x004fcc00078e020fULL,
0x000000000e0e7984ULL, 0x000e640000000800ULL, 0x000000040e057c24ULL, 0x002fc8000f8e0205ULL,
0x00005e0005047625ULL, 0x000fca00078e0012ULL, 0x0000001504087210ULL, 0x000fe40007f3e0ffULL,
0xfffffffc09047812ULL, 0x000fc600078ee20cULL, 0x000000ffff097224ULL, 0x000fe200008e0605ULL,
0x0000001104137211ULL, 0x000fe200078e20ffULL, 0x0000000117057824ULL, 0x000fc800078e020aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008137faeULL, 0x0003e2000c101c46ULL,
0x000000070a00720cULL, 0x000fc60003f06070ULL, 0x0146a0000d047984ULL, 0x000ea20000000800ULL,
0x0000003010087810ULL, 0x002fca0007ffe0ffULL, 0x0000000408097824ULL, 0x000fe400078e00ffULL,
0x00000004040e7824ULL, 0x004fcc00078e020fULL, 0x000000000e0e7984ULL, 0x000e640000000800ULL,
0x000000040e057c24ULL, 0x002fc8000f8e0205ULL, 0x00005e0005047625ULL, 0x000fca00078e0012ULL,
0x00000015040a7210ULL, 0x000fe40007f3e0ffULL, 0xfffffffc0b047812ULL, 0x000fc600078ee20cULL,
0x000000ffff0b7224ULL, 0x000fe200008e0605ULL, 0x0000001104137211ULL, 0x000fe200078e20ffULL,
0x0000000117057824ULL, 0x000fc800078e0208ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a137faeULL, 0x0003e2000c101c46ULL, 0x000000070800720cULL, 0x000fc60003f06070ULL,
0x0146c0000d047984ULL, 0x000ea20000000800ULL, 0x00000038100a7810ULL, 0x002fe20007ffe0ffULL,
0x00000004040e7824ULL, 0x004fcc00078e020fULL, 0x000000000e0e7984ULL, 0x000e640000000800ULL,
0x000000040e057c24ULL, 0x002fc8000f8e0205ULL, 0x00005e0005047625ULL, 0x000fca00078e0012ULL,
0x0000001504087210ULL, 0x000fe40007f3e0ffULL, 0xfffffffc09047812ULL, 0x000fc600078ee20cULL,
0x000000ffff097224ULL, 0x000fe200008e0605ULL, 0x00000011040b7211ULL, 0x000fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080b7faeULL, 0x0003e2000c101c46ULL,
0x000000070a00720cULL, 0x040fe20003f06070ULL, 0x000000040a077824ULL, 0x000fe400078e00ffULL,
0x0146e0000d047984ULL, 0x000ea60000000800ULL, 0xfffffffc070c7812ULL, 0x000fc800078ee20cULL,
0x000000110c117211ULL, 0x000fe200078e20ffULL, 0x00000004040f7824ULL, 0x004fe400078e020fULL,
0x0000000117047824ULL, 0x000fc800078e020aULL, 0x000000000f0f7984ULL, 0x000ea40000000800ULL,
0x000000040f047c24ULL, 0x004fc8000f8e0204ULL, 0x00005e0004047625ULL, 0x000fca00078e0012ULL,
0x0000001504047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e0605ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004117faeULL, 0x0003e2000c101c46ULL,
0x0000088000007947ULL, 0x000fea0003800000ULL, 0x0000000000097919ULL, 0x000e620000000000ULL,
0x00014a80780f7811ULL, 0x040fe200078e20ffULL, 0x00000200ff117424ULL, 0x000fe200078e00ffULL,
0x0000200078157811ULL, 0x000fe400078e68ffULL, 0x00000002ff0c7819ULL, 0x002fe40000011609ULL,
0x00000004090a7819ULL, 0x040fe400000006ffULL, 0x0000000909087211ULL, 0x000fe200078fe8ffULL,
0x000000040c0d7824ULL, 0x000fe200078e027cULL, 0x000000300a137812ULL, 0x000fc400078ec0ffULL,
0x00000003080e7812ULL, 0x000fe400078ec0ffULL, 0x014600000d047984ULL, 0x000e620000000800ULL,
0x000000080c0a7810ULL, 0x000fc80007ffe0ffULL, 0x000000020a0b7819ULL, 0x000fe200000006ffULL,
0x0000000404077824ULL, 0x002fe400078e020fULL, 0x0000000117047824ULL, 0x000fc800078e020cULL,
0x0000000007077984ULL, 0x000e640000000800ULL, 0x0000000407047c24ULL, 0x002fc8000f8e0204ULL,
0x00005e0004047625ULL, 0x000fca00078e0011ULL, 0x0000001304087210ULL, 0x000fe40007f1e0ffULL,
0x0ffffffc0e047812ULL, 0x000fc600078ef809ULL, 0x000000ffff097224ULL, 0x000fe400000e0605ULL,
0x0000001004197824ULL, 0x000fca00078e0215ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008197faeULL, 0x0003e8000b901c46ULL, 0x014620000d047984ULL, 0x000ea20000000800ULL,
0x000000100c087810ULL, 0x002fc80007ffe0ffULL, 0x0000000208097819ULL, 0x000fe200000006ffULL,
0x0000000404077824ULL, 0x004fe400078e020fULL, 0x0000000117047824ULL, 0x000fc800078e020aULL,
0x0000000007077984ULL, 0x000e640000000800ULL, 0x0000000407047c24ULL, 0x002fc8000f8e0204ULL,
0x00005e0004047625ULL, 0x000fca00078e0011ULL, 0x00000013040a7210ULL, 0x000fe40007f1e0ffULL,
0xfffffffc0b047812ULL, 0x000fc600078ee20eULL, 0x000000ffff0b7224ULL, 0x000fe400000e0605ULL,
0x0000001004197824ULL, 0x000fca00078e0215ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a197faeULL, 0x0003e8000b901c46ULL, 0x014640000d047984ULL, 0x000ea20000000800ULL,
0x000000180c0a7810ULL, 0x002fc80007ffe0ffULL, 0x000000020a0b7819ULL, 0x000fe200000006ffULL,
0x0000000404077824ULL, 0x004fe400078e020fULL, 0x0000000117047824ULL, 0x000fc800078e0208ULL,
0x0000000007077984ULL, 0x000e640000000800ULL, 0x0000000407047c24ULL, 0x002fc8000f8e0204ULL,
0x00005e0004047625ULL, 0x000fca00078e0011ULL, 0x0000001304087210ULL, 0x000fe40007f1e0ffULL,
0xfffffffc09047812ULL, 0x000fc600078ee20eULL, 0x000000ffff097224ULL, 0x000fe400000e0605ULL,
0x0000001004197824ULL, 0x000fca00078e0215ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008197faeULL, 0x0003e8000b901c46ULL, 0x014660000d047984ULL, 0x000ea20000000800ULL,
0x000000200c087810ULL, 0x002fc80007ffe0ffULL, 0x0000000208097819ULL, 0x000fe200000006ffULL,
0x0000000404077824ULL, 0x004fe400078e020fULL, 0x0000000117047824ULL, 0x000fc800078e020aULL,
0x0000000007077984ULL, 0x000e640000000800ULL, 0x0000000407047c24ULL, 0x002fc8000f8e0204ULL,
0x00005e0004047625ULL, 0x000fca00078e0011ULL, 0x00000013040a7210ULL, 0x000fe40007f1e0ffULL,
0xfffffffc0b047812ULL, 0x000fc600078ee20eULL, 0x000000ffff0b7224ULL, 0x000fe400000e0605ULL,
0x0000001004197824ULL, 0x000fca00078e0215ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a197faeULL, 0x0003e8000b901c46ULL, 0x014680000d047984ULL, 0x000ea20000000800ULL,
0x000000280c0a7810ULL, 0x002fc80007ffe0ffULL, 0x000000020a0b7819ULL, 0x000fe200000006ffULL,
0x0000000404077824ULL, 0x004fe400078e020fULL, 0x0000000117047824ULL, 0x000fc800078e0208ULL,
0x0000000007077984ULL, 0x000e640000000800ULL, 0x0000000407047c24ULL, 0x002fc8000f8e0204ULL,
0x00005e0004047625ULL, 0x000fca00078e0011ULL, 0x0000001304087210ULL, 0x000fe40007f1e0ffULL,
0xfffffffc09047812ULL, 0x000fc600078ee20eULL, 0x000000ffff097224ULL, 0x000fe400000e0605ULL,
0x0000001004197824ULL, 0x000fca00078e0215ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008197faeULL, 0x0003e8000b901c46ULL, 0x0146a0000d047984ULL, 0x000ea20000000800ULL,
0x000000300c087810ULL, 0x042fe40007ffe0ffULL, 0x000000380c0c7810ULL, 0x000fe40007ffe0ffULL,
0x0000000208097819ULL, 0x000fe200000006ffULL, 0x0000000404077824ULL, 0x004fc400078e020fULL,
0x0000000117047824ULL, 0x000fc800078e020aULL, 0x0000000007077984ULL, 0x000e640000000800ULL,
0x0000000407047c24ULL, 0x002fc8000f8e0204ULL, 0x00005e0004047625ULL, 0x000fca00078e0011ULL,
0x00000013040a7210ULL, 0x000fe40007f1e0ffULL, 0xfffffffc0b047812ULL, 0x000fc600078ee20eULL,
0x000000ffff0b7224ULL, 0x000fe400000e0605ULL, 0x0000001004197824ULL, 0x000fca00078e0215ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a197faeULL, 0x0003e8000b901c46ULL,
0x0146c0000d047984ULL, 0x000ea40000000800ULL, 0x0000000404077824ULL, 0x004fe400078e020fULL,
0x0000000117047824ULL, 0x000fc800078e0208ULL, 0x0000000007077984ULL, 0x000ea40000000800ULL,
0x0000000407047c24ULL, 0x004fc8000f8e0204ULL, 0x00005e0004047625ULL, 0x000fca00078e0011ULL,
0x0000001304087210ULL, 0x000fe40007f1e0ffULL, 0xfffffffc09047812ULL, 0x000fc600078ee20eULL,
0x000000ffff097224ULL, 0x000fe400000e0605ULL, 0x00000010040b7824ULL, 0x002fca00078e0215ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080b7faeULL, 0x0003e8000b901c46ULL,
0x0146e0000d047984ULL, 0x000ea40000000800ULL, 0x0000000404077824ULL, 0x004fe200078e020fULL,
0x000000020c0f7819ULL, 0x000fe200000006ffULL, 0x0000000117047824ULL, 0x000fc600078e020cULL,
0xfffffffc0f0e7812ULL, 0x000fe200078ee20eULL, 0x0000000007077984ULL, 0x000ea80000000800ULL,
0x000000100e157824ULL, 0x000fe400078e0215ULL, 0x0000000407047c24ULL, 0x004fc8000f8e0204ULL,
0x00005e0004047625ULL, 0x000fca00078e0011ULL, 0x0000001304047210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004157faeULL, 0x0003e6000b901c46ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000047805ULL, 0x002fc40000015200ULL,
0x014ad400ff087984ULL, 0x000e640000000800ULL, 0x8000000008ff7812ULL, 0x002fe40007804803ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x0000000804087210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e05ULL, 0x003d09000800780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400800780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff077819ULL, 0x000fc80000011409ULL,
0x0000000807077211ULL, 0x000fc800078110ffULL, 0x00000009ff087210ULL, 0x000fc800007fe4ffULL,
0x0000000207077819ULL, 0x000fc80000001208ULL, 0x000000070000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x014ad400ff087984ULL, 0x000e640000000800ULL,
0x8000000008ff7812ULL, 0x002fe40007804803ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000747a00720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000077919ULL, 0x000e620000000000ULL, 0x00005800ff057624ULL, 0x000fe200078e00ffULL,
0x00014b5878727811ULL, 0x040fe200078e18ffULL, 0x0000002078717824ULL, 0x000fe200078e00ffULL,
0xffffffff74797810ULL, 0x000fe20007ffe0ffULL, 0x0000008005057824ULL, 0x000fc400078e00ffULL,
0x000001007a047824ULL, 0x004fe200078e027dULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x000000047500720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x008fea0003800000ULL,
0x0000007a7300720cULL, 0x000fe20003f44070ULL, 0x000000ffff707224ULL, 0x000fe200078e00ffULL,
0x0000000400037802ULL, 0x000fc80000000f00ULL, 0x0000000103037807ULL, 0x000fc40005000000ULL,
0x000080000000791aULL, 0x000fc80000000000ULL, 0x000000237f007947ULL, 0x000fea000b800000ULL,
0x0001b34000287802ULL, 0x000fc40000000f00ULL, 0x0000b15000007944ULL, 0x002fea0003c00000ULL,
0x00000002ff297819ULL, 0x000fe20000011670ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000002970297207ULL, 0x000fe20001000000ULL, 0x0000111000007945ULL, 0x000fe80003800000ULL,
0x0000030029a47a24ULL, 0x000fc800078e027aULL, 0x00000100a4a27824ULL, 0x040fe200078e027dULL,
0x00000001a4297810ULL, 0x000fc80007ffe0ffULL, 0x000000742900720cULL, 0x000fe40003f06070ULL,
0x00000040a2297812ULL, 0x000fca00078ec0ffULL, 0x0000000106a67824ULL, 0x000fcc00078e0229ULL,
0x000008a000008947ULL, 0x000fea0003800000ULL, 0x00000002ff317819ULL, 0x002fe20000011607ULL,
0x00000200ff377424ULL, 0x000fe200078e00ffULL, 0x00014a8078357811ULL, 0x040fe400078e20ffULL,
0x000000a275297217ULL, 0x000fe20007800000ULL, 0x0000000431337824ULL, 0x000fe200078e027cULL,
0x00000007072d7211ULL, 0x000fe200078fe8ffULL, 0x00000001312b7824ULL, 0x000fe200078e02a6ULL,
0x00003000782e7811ULL, 0x000fe200078e68ffULL, 0x00000001292c7824ULL, 0x000fe200078e0aa2ULL,
0x0146000033287984ULL, 0x000e620000000800ULL, 0x000000032d327812ULL, 0x000fc600078ec0ffULL,
0x0000002c3100720cULL, 0x000fe40003f26070ULL, 0x0ffffffc322f7812ULL, 0x000fca00078ef807ULL,
0x000000102f2f7824ULL, 0x000fe200078e022eULL, 0x00000035282a7211ULL, 0x002fe400078e10ffULL,
0x0000000307287812ULL, 0x000fc800078ec0ffULL, 0x000000002a2a7984ULL, 0x000e620000000800ULL,
0x00000004282d7812ULL, 0x000fe200078efcffULL, 0x0000002a052b7224ULL, 0x002fc800078e022bULL,
0x00005e002b287625ULL, 0x000fe200078e0037ULL, 0x00000008312b7810ULL, 0x000fca0007ffe0ffULL,
0x000000102d287825ULL, 0x000fc800078e0028ULL, 0x000000042b397824ULL, 0x040fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000282f7faeULL, 0x0003e2000c901c46ULL,
0x0000002c2b00720cULL, 0x000fc60003f26070ULL, 0x01462000332a7984ULL, 0x000ea20000000800ULL,
0xfffffffc39397812ULL, 0x000fca00078ee232ULL, 0x00000010392f7824ULL, 0x002fe200078e022eULL,
0x0000001031297810ULL, 0x000fca0007ffe0ffULL, 0x0000000429397824ULL, 0x000fca00078e00ffULL,
0xfffffffc39397812ULL, 0x000fe400078ee232ULL, 0x000000352a307211ULL, 0x004fe200078e10ffULL,
0x000000012b2a7824ULL, 0x000fca00078e02a6ULL, 0x0000000030307984ULL, 0x000e640000000800ULL,
0x00000030052a7224ULL, 0x002fc800078e022aULL, 0x00005e002a2a7625ULL, 0x000fcc00078e0037ULL,
0x000000102d2a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a2f7faeULL, 0x0003e2000c901c46ULL, 0x0000002c2900720cULL, 0x000fc60003f26070ULL,
0x0146400033287984ULL, 0x000ea20000000800ULL, 0x00000010392f7824ULL, 0x002fe200078e022eULL,
0x00000018312b7810ULL, 0x000fc80007ffe0ffULL, 0x000000022b397819ULL, 0x000fc800000006ffULL,
0xfffffffc39397812ULL, 0x000fe200078ee232ULL, 0x0000000428307824ULL, 0x004fe200078e0235ULL,
0x000000a629287210ULL, 0x000fca0007ffe0ffULL, 0x0000000030307984ULL, 0x000e640000000800ULL,
0x0000003005287224ULL, 0x002fc800078e0228ULL, 0x00005e0028287625ULL, 0x000fcc00078e0037ULL,
0x000000102d287825ULL, 0x000fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000282f7faeULL, 0x0003e2000c901c46ULL, 0x0000002c2b00720cULL, 0x000fc60003f26070ULL,
0x01466000332a7984ULL, 0x000ea20000000800ULL, 0x00000010392f7824ULL, 0x002fe200078e022eULL,
0x0000002031297810ULL, 0x000fca0007ffe0ffULL, 0x0000000429397824ULL, 0x000fca00078e00ffULL,
0xfffffffc39397812ULL, 0x000fe200078ee232ULL, 0x000000042a307824ULL, 0x004fe400078e0235ULL,
0x000000012b2a7824ULL, 0x000fc800078e02a6ULL, 0x0000000030307984ULL, 0x000e640000000800ULL,
0x00000030052a7224ULL, 0x002fc800078e022aULL, 0x00005e002a2a7625ULL, 0x000fcc00078e0037ULL,
0x000000102d2a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a2f7faeULL, 0x0003e2000c901c46ULL, 0x0000002c2900720cULL, 0x000fc60003f26070ULL,
0x0146800033287984ULL, 0x000ea20000000800ULL, 0x0000002e392f7211ULL, 0x002fe400078e20ffULL,
0x00000028312b7810ULL, 0x000fca0007ffe0ffULL, 0x000000042b397824ULL, 0x000fca00078e00ffULL,
0xfffffffc39397812ULL, 0x000fe200078ee232ULL, 0x0000000428307824ULL, 0x004fe400078e0235ULL,
0x0000000129287824ULL, 0x000fc800078e02a6ULL, 0x0000000030307984ULL, 0x000e640000000800ULL,
0x0000003005287224ULL, 0x002fc800078e0228ULL, 0x00005e0028287625ULL, 0x000fcc00078e0037ULL,
0x000000102d287825ULL, 0x000fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000282f7faeULL, 0x0003e2000c901c46ULL, 0x0000002c2b00720cULL, 0x000fc60003f26070ULL,
0x0146a000332a7984ULL, 0x000ea20000000800ULL, 0x00000010392f7824ULL, 0x002fe200078e022eULL,
0x0000003031297810ULL, 0x040fe40007ffe0ffULL, 0x0000003831317810ULL, 0x000fc60007ffe0ffULL,
0x0000000429397824ULL, 0x000fca00078e00ffULL, 0xfffffffc39397812ULL, 0x000fe200078ee232ULL,
0x000000042a307824ULL, 0x004fe400078e0235ULL, 0x000000012b2a7824ULL, 0x000fc800078e02a6ULL,
0x0000000030307984ULL, 0x000e640000000800ULL, 0x00000030052a7224ULL, 0x002fc800078e022aULL,
0x00005e002a2a7625ULL, 0x000fcc00078e0037ULL, 0x000000102d2a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a2f7faeULL, 0x0003e2000c901c46ULL,
0x0000002c2900720cULL, 0x000fc60003f26070ULL, 0x0146c00033287984ULL, 0x000ea20000000800ULL,
0x00000010392f7824ULL, 0x002fe200078e022eULL, 0x0000003528307211ULL, 0x004fe200078e10ffULL,
0x0000000129287824ULL, 0x000fca00078e02a6ULL, 0x0000000030307984ULL, 0x000e640000000800ULL,
0x0000003005287224ULL, 0x002fc800078e0228ULL, 0x00005e0028287625ULL, 0x000fcc00078e0037ULL,
0x000000102d287825ULL, 0x000fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000282f7faeULL, 0x0003e2000c901c46ULL, 0x0000002c3100720cULL, 0x000fc60003f26070ULL,
0x0146e000332a7984ULL, 0x000ea40000000800ULL, 0x000000042a307824ULL, 0x004fe200078e0235ULL,
0x000000a6312a7210ULL, 0x040fe20007ffe0ffULL, 0x0000000431357824ULL, 0x000fc800078e00ffULL,
0x0000000030307984ULL, 0x000ea20000000800ULL, 0xfffffffc35317812ULL, 0x000fca00078ee232ULL,
0x0000001031297824ULL, 0x002fe400078e022eULL, 0x00000030052a7224ULL, 0x004fc800078e022aULL,
0x00005e002a2a7625ULL, 0x000fcc00078e0037ULL, 0x000000102d2a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a297faeULL, 0x0003e2000c901c46ULL,
0x000007f000007947ULL, 0x000fea0003800000ULL, 0x00000002ff2d7819ULL, 0x002fe20000011607ULL,
0x00000200ff337424ULL, 0x000fe200078e00ffULL, 0x00014a8078317811ULL, 0x000fe400078e20ffULL,
0x00000007072b7211ULL, 0x000fe200078fe8ffULL, 0x000000042d307824ULL, 0x000fe200078e027cULL,
0x0000000307297812ULL, 0x000fe400078ec0ffULL, 0x000000032b2e7812ULL, 0x000fe400078ec0ffULL,
0x0146000030287984ULL, 0x000e620000000800ULL, 0x00000004292f7812ULL, 0x000fc400078efcffULL,
0x0000300078327811ULL, 0x000fe400078e68ffULL, 0x0ffffffc2e2b7812ULL, 0x000fca00078ef807ULL,
0x000000102b357824ULL, 0x000fe200078e0232ULL, 0x000000082d2b7810ULL, 0x000fc80007ffe0ffULL,
0x000000022b377819ULL, 0x000fc800000006ffULL, 0xfffffffc37377812ULL, 0x000fca00078ee22eULL,
0x0000001037377824ULL, 0x000fe400078e0232ULL, 0x00000004282a7824ULL, 0x002fe200078e0231ULL,
0x000000a62d287210ULL, 0x000fca0007ffe0ffULL, 0x000000002a2a7984ULL, 0x000e640000000800ULL,
0x0000002a05287224ULL, 0x002fc800078e0228ULL, 0x00005e0028287625ULL, 0x000fcc00078e0033ULL,
0x000000102f287825ULL, 0x000fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028357faeULL, 0x0003e8000b901c46ULL, 0x01462000302a7984ULL, 0x000ea20000000800ULL,
0x000000102d297810ULL, 0x002fca0007ffe0ffULL, 0x0000000429357824ULL, 0x000fca00078e00ffULL,
0xfffffffc35357812ULL, 0x000fc800078ee22eULL, 0x0000003235357211ULL, 0x000fe200078e20ffULL,
0x000000042a2c7824ULL, 0x004fe400078e0231ULL, 0x000000012b2a7824ULL, 0x000fc800078e02a6ULL,
0x000000002c2c7984ULL, 0x000e640000000800ULL, 0x0000002c052a7224ULL, 0x002fc800078e022aULL,
0x00005e002a2a7625ULL, 0x000fcc00078e0033ULL, 0x000000102f2a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a377faeULL, 0x0003e8000b901c46ULL,
0x0146400030287984ULL, 0x000ea20000000800ULL, 0x000000182d2b7810ULL, 0x002fca0007ffe0ffULL,
0x000000042b377824ULL, 0x000fca00078e00ffULL, 0xfffffffc37377812ULL, 0x000fca00078ee22eULL,
0x0000001037377824ULL, 0x000fe400078e0232ULL, 0x00000004282c7824ULL, 0x004fe400078e0231ULL,
0x0000000129287824ULL, 0x000fc800078e02a6ULL, 0x000000002c2c7984ULL, 0x000e640000000800ULL,
0x0000002c05287224ULL, 0x002fc800078e0228ULL, 0x00005e0028287625ULL, 0x000fcc00078e0033ULL,
0x000000102f287825ULL, 0x000fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028357faeULL, 0x0003e8000b901c46ULL, 0x01466000302a7984ULL, 0x000ea20000000800ULL,
0x000000202d297810ULL, 0x002fca0007ffe0ffULL, 0x0000000429357824ULL, 0x000fca00078e00ffULL,
0xfffffffc35357812ULL, 0x000fca00078ee22eULL, 0x0000001035357824ULL, 0x000fe400078e0232ULL,
0x000000042a2c7824ULL, 0x004fe400078e0231ULL, 0x000000012b2a7824ULL, 0x000fc800078e02a6ULL,
0x000000002c2c7984ULL, 0x000e640000000800ULL, 0x0000002c052a7224ULL, 0x002fc800078e022aULL,
0x00005e002a2a7625ULL, 0x000fcc00078e0033ULL, 0x000000102f2a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a377faeULL, 0x0003e8000b901c46ULL,
0x0146800030287984ULL, 0x000ea20000000800ULL, 0x000000282d2b7810ULL, 0x002fca0007ffe0ffULL,
0x000000042b377824ULL, 0x000fca00078e00ffULL, 0xfffffffc37377812ULL, 0x000fca00078ee22eULL,
0x0000001037377824ULL, 0x000fe200078e0232ULL, 0x00000031282c7211ULL, 0x004fe200078e10ffULL,
0x0000000129287824ULL, 0x000fca00078e02a6ULL, 0x000000002c2c7984ULL, 0x000e640000000800ULL,
0x0000002c05287224ULL, 0x002fc800078e0228ULL, 0x00005e0028287625ULL, 0x000fcc00078e0033ULL,
0x000000102f287825ULL, 0x000fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028357faeULL, 0x0003e8000b901c46ULL, 0x0146a000302a7984ULL, 0x000ea20000000800ULL,
0x000000302d297810ULL, 0x042fe40007ffe0ffULL, 0x000000382d2d7810ULL, 0x000fe40007ffe0ffULL,
0x0000000229357819ULL, 0x000fc800000006ffULL, 0xfffffffc35357812ULL, 0x000fca00078ee22eULL,
0x0000001035357824ULL, 0x000fe400078e0232ULL, 0x000000042a2c7824ULL, 0x004fe200078e0231ULL,
0x000000a62b2a7210ULL, 0x000fca0007ffe0ffULL, 0x000000002c2c7984ULL, 0x000e640000000800ULL,
0x0000002c052a7224ULL, 0x002fc800078e022aULL, 0x00005e002a2a7625ULL, 0x000fcc00078e0033ULL,
0x000000102f2a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a377faeULL, 0x0003e8000b901c46ULL, 0x0146c00030287984ULL, 0x000ea40000000800ULL,
0x00000004282c7824ULL, 0x004fe400078e0231ULL, 0x0000000129287824ULL, 0x000fc800078e02a6ULL,
0x000000002c2c7984ULL, 0x000ea40000000800ULL, 0x0000002c05287224ULL, 0x004fc800078e0228ULL,
0x00005e0028287625ULL, 0x000fcc00078e0033ULL, 0x000000102f287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028357faeULL, 0x0005e8000b901c46ULL,
0x0146e000302a7984ULL, 0x002e640000000800ULL, 0x000000042a2c7824ULL, 0x002fe400078e0231ULL,
0x000000012d2a7824ULL, 0x040fe400078e02a6ULL, 0x000000042d2d7824ULL, 0x000fc400078e00ffULL,
0x000000002c2c7984ULL, 0x000e660000000800ULL, 0xfffffffc2d2d7812ULL, 0x000fc800078ee22eULL,
0x000000322d2d7211ULL, 0x000fe200078e20ffULL, 0x0000002c052a7224ULL, 0x002fc800078e022aULL,
0x00005e002a2a7625ULL, 0x000fcc00078e0033ULL, 0x000000102f2a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a2d7faeULL, 0x0005e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000237f007947ULL, 0x000fea000b800000ULL,
0x0001c4c000287802ULL, 0x004fc40000000f00ULL, 0x00009fd000007944ULL, 0x002fea0003c00000ULL,
0x00000007072a7812ULL, 0x006fe200078ec0ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00000004ff297819ULL, 0x100fe20000011607ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000082a7e7812ULL, 0x000fe200078ef807ULL, 0xffffffff00007948ULL, 0x000fe80003800000ULL,
0x000000017e807824ULL, 0x040fe400078e0229ULL, 0x000000207e2b7824ULL, 0x000fca00078e00ffULL,
0xffffffe02b287812ULL, 0x000fca00078ee280ULL, 0x0000001028287824ULL, 0x000fc600078e00ffULL,
0x0000000829297824ULL, 0x000fe200078e00ffULL, 0x00000003ff667819ULL, 0x000fe20000011607ULL,
0x000000002848783bULL, 0x000fe20000000200ULL, 0x0000000d78a77819ULL, 0x000fe200000006ffULL,
0x000000207e327824ULL, 0x000fe200078e00ffULL, 0xfffffff8292a7812ULL, 0x000fe400078ee22aULL,
0x0000000166297812ULL, 0x000fe400078ec0ffULL, 0x000000102a2c7810ULL, 0x040fe20007ffe0ffULL,
0x000000042a647824ULL, 0x040fe200078e00ffULL, 0x000000202a2e7810ULL, 0x000fc40007ffe0ffULL,
0x000000302a307810ULL, 0x000fe20007ffe0ffULL, 0x000000042c5e7824ULL, 0x000fe200078e00ffULL,
0x000000292a2b7211ULL, 0x080fe200078ff8ffULL, 0x000000042e887824ULL, 0x000fe200078e00ffULL,
0x000000292c2d7211ULL, 0x080fe400078ff8ffULL, 0x000000292e2f7211ULL, 0x080fe400078ff8ffULL,
0x0000002930297211ULL, 0x040fe400078ff8ffULL, 0x00000002305c7819ULL, 0x000fc400000006ffULL,
0x00002000a75d7810ULL, 0x000fe40007ffe0ffULL, 0xfffffffc64647812ULL, 0x000fe400078ee22bULL,
0xfffffffc5e5e7812ULL, 0x000fe400078ee22dULL, 0xfffffffc88887812ULL, 0x000fe200078ee22fULL,
0x0000001064a37824ULL, 0x000fe200078e025dULL, 0xfffffffc5c5c7812ULL, 0x000fe200078ee229ULL,
0x000000105ea17824ULL, 0x100fe200078e025dULL, 0x000000022b867810ULL, 0x000fe20007ffe0ffULL,
0x0000001088a07824ULL, 0x100fe200078e025dULL, 0x00000000a354783bULL, 0x000e620000000200ULL,
0x000000105c9f7824ULL, 0x100fe200078e025dULL, 0x000000022d847810ULL, 0x000fe20007ffe0ffULL,
0x000000042c2b7824ULL, 0x000fe200078e00ffULL, 0x00000000a150783bULL, 0x000ea20000000200ULL,
0x0000000280317810ULL, 0x000fe20007ffe0ffULL, 0x00000004302d7824ULL, 0x000fe200078e00ffULL,
0x000000022f827810ULL, 0x000fe20007ffe0ffULL, 0x00000000a04c783bULL, 0x000ee20000000200ULL,
0xfffffffc2b847812ULL, 0x000fe200078ee284ULL, 0x000000042e2b7824ULL, 0x000fe200078e00ffULL,
0x000000022a337819ULL, 0x000fe200000006ffULL, 0x000000009f58783bULL, 0x000f220000000200ULL,
0x0000000229c67810ULL, 0x000fe20007ffe0ffULL, 0x00000010849d7824ULL, 0x000fe200078e025dULL,
0xffffffe032317812ULL, 0x000fc400078ee231ULL, 0xfffffffc2b827812ULL, 0x000fe400078ee282ULL,
0xfffffffc33867812ULL, 0x000fe200078ee286ULL, 0x0000001031317824ULL, 0x000fe200078e00ffULL,
0xfffffffc2dc67812ULL, 0x000fe200078ee2c6ULL, 0x00000010829c7824ULL, 0x100fe200078e025dULL,
0x0000005d869e7211ULL, 0x000fe200078e20ffULL, 0x000000009d40783bULL, 0x000fe40000000200ULL,
0x00000010c6857824ULL, 0x000fe400078e025dULL, 0x000000003130783bULL, 0x000fe80000000200ULL,
0x000000009e44783bULL, 0x000f280000000200ULL, 0x000000009c38783bULL, 0x000f280000000200ULL,
0x000000008528783bULL, 0x000f220000000200ULL, 0x000000544860723cULL, 0x002f6200000418ffULL,
0x000080000000791aULL, 0x000fce0000000000ULL, 0x00000050482c723cULL, 0x044f7000000418ffULL,
0x0000004c4834723cULL, 0x048f7000000418ffULL, 0x000000564854723cULL, 0x040f7000000418ffULL,
0x000000524850723cULL, 0x040f7000000418ffULL, 0x0000004e484c723cULL, 0x040f7000000418ffULL,
0x00000058483c723cULL, 0x050f7000000418ffULL, 0x0000005a4848723cULL, 0x000f7000000418ffULL,
0x000000443060723cULL, 0x060b700000041860ULL, 0x00000040302c723cULL, 0x040b70000004182cULL,
0x000000383034723cULL, 0x040b700000041834ULL, 0x000000463044723cULL, 0x040b700000041854ULL,
0x000000423040723cULL, 0x040b700000041850ULL, 0x0000003a3038723cULL, 0x040b70000004184cULL,
0x00000028303c723cULL, 0x040b70000004183cULL, 0x0000002a3030723cULL, 0x000b620000041848ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x0000002000007947ULL, 0x000fde0003800000ULL,
0x0001ca2000287802ULL, 0x020fce0000000f00ULL, 0x00009a7000007944ULL, 0x000fea0003c00000ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000108000007945ULL, 0x000fe20003800000ULL,
0x00000200ff907424ULL, 0x000fe200078e00ffULL, 0x0000088000008947ULL, 0x000fea0003800000ULL,
0x00000002ff817819ULL, 0x100fe20000011607ULL, 0x0000000166b67824ULL, 0x000fe200078e0207ULL,
0x00014a8078917811ULL, 0x000fe400078e20ffULL, 0x0000007c81927211ULL, 0x040fe200078e10ffULL,
0x0000000181b47824ULL, 0x000fe200078e02a6ULL, 0x000000a275297217ULL, 0x020fe40007800000ULL,
0x0000000307a57812ULL, 0x000fe200078ec0ffULL, 0x0146000092287984ULL, 0x000e620000000800ULL,
0x00000003b6b67812ULL, 0x000fe200078ec0ffULL, 0x00000001294a7824ULL, 0x000fe200078e0aa2ULL,
0x00000008a5497812ULL, 0x000fc400078efcffULL, 0x0ffffffcb6c47812ULL, 0x000fe400078ef807ULL,
0x0000004a8100720cULL, 0x040fe40003f26070ULL, 0x0000005dc49b7211ULL, 0x000fe400078e20ffULL,
0x00000008817f7810ULL, 0x040fe40007ffe0ffULL, 0x00000010818f7810ULL, 0x040fe40007ffe0ffULL,
0x00000018818e7810ULL, 0x000fe20007ffe0ffULL, 0x000000017fb27824ULL, 0x100fe200078e02a6ULL,
0x00000020818d7810ULL, 0x000fe20007ffe0ffULL, 0x000000047f4b7824ULL, 0x000fe200078e00ffULL,
0x000000a68eae7210ULL, 0x000fe20007ffe0ffULL, 0x000000018fb07824ULL, 0x100fe200078e02a6ULL,
0x00000028818c7810ULL, 0x000fe20007ffe0ffULL, 0x000000018dac7824ULL, 0x000fe200078e02a6ULL,
0xfffffffc4bc27812ULL, 0x000fe200078ee2b6ULL, 0x000000048f4b7824ULL, 0x000fe200078e00ffULL,
0x00000030818b7810ULL, 0x040fe20007ffe0ffULL, 0x000000018caa7824ULL, 0x000fe200078e02a6ULL,
0x00000038818a7810ULL, 0x000fe20007ffe0ffULL, 0x00000010c29a7824ULL, 0x000fe200078e025dULL,
0xfffffffc4bc07812ULL, 0x000fe200078ee2b6ULL, 0x000000048e4b7824ULL, 0x000fc400078e00ffULL,
0x000000018ba87824ULL, 0x000fe400078e02a6ULL, 0x00000010c0997824ULL, 0x000fe200078e025dULL,
0xfffffffc4bbe7812ULL, 0x000fe200078ee2b6ULL, 0x000000018aa67824ULL, 0x000fe200078e02a6ULL,
0x000000028d4b7819ULL, 0x000fe200000006ffULL, 0x00000004282a7824ULL, 0x002fc600078e0291ULL,
0xfffffffc4bbc7812ULL, 0x000fe200078ee2b6ULL, 0x00000010be987824ULL, 0x100fe400078e025dULL,
0x000000048c4b7824ULL, 0x000fe200078e00ffULL, 0x000000002a2a7984ULL, 0x000e620000000800ULL,
0x00000010bc977824ULL, 0x000fc600078e025dULL, 0xfffffffc4bba7812ULL, 0x000fe200078ee2b6ULL,
0x000000048b4b7824ULL, 0x000fc600078e00ffULL, 0x0000005dba967211ULL, 0x000fe400078e20ffULL,
0xfffffffc4bb87812ULL, 0x000fe200078ee2b6ULL, 0x000000048a4b7824ULL, 0x000fc800078e00ffULL,
0x00000010b8957824ULL, 0x000fe200078e025dULL, 0xfffffffc4bb67812ULL, 0x000fca00078ee2b6ULL,
0x00000010b6947824ULL, 0x000fe400078e025dULL, 0x0000002a05297224ULL, 0x002fc800078e02b4ULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x0000001049287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000289b7faeULL, 0x0003e2000c901c46ULL,
0x0000004a7f00720cULL, 0x000fc60003f26070ULL, 0x01462000922a7984ULL, 0x000ea40000000800ULL,
0x000000042a487824ULL, 0x004fcc00078e0291ULL, 0x0000000048487984ULL, 0x000ea40000000800ULL,
0x00000048052b7224ULL, 0x004fc800078e02b2ULL, 0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL,
0x00000010492a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a9a7faeULL, 0x0005e2000c901c46ULL, 0x0000004a8f00720cULL, 0x000fc60003f26070ULL,
0x0146400092287984ULL, 0x002e640000000800ULL, 0x0000009128487211ULL, 0x002fcc00078e10ffULL,
0x0000000048487984ULL, 0x000e640000000800ULL, 0x0000004805297224ULL, 0x002fc800078e02b0ULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x0000001049287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028997faeULL, 0x0003e2000c901c46ULL,
0x0000004a8e00720cULL, 0x000fc60003f26070ULL, 0x01466000922a7984ULL, 0x004ea40000000800ULL,
0x000000042a487824ULL, 0x004fcc00078e0291ULL, 0x0000000048487984ULL, 0x000ea40000000800ULL,
0x00000048052b7224ULL, 0x004fc800078e02aeULL, 0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL,
0x00000010492a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a987faeULL, 0x0005e2000c901c46ULL, 0x0000004a8d00720cULL, 0x000fc60003f26070ULL,
0x0146800092287984ULL, 0x002e640000000800ULL, 0x0000000428487824ULL, 0x002fcc00078e0291ULL,
0x0000000048487984ULL, 0x000e640000000800ULL, 0x0000004805297224ULL, 0x002fc800078e02acULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x0000001049287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028977faeULL, 0x0003e2000c901c46ULL,
0x0000004a8c00720cULL, 0x000fc60003f26070ULL, 0x0146a000922a7984ULL, 0x004ea40000000800ULL,
0x000000042a487824ULL, 0x004fcc00078e0291ULL, 0x0000000048487984ULL, 0x000ea40000000800ULL,
0x00000048052b7224ULL, 0x004fc800078e02aaULL, 0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL,
0x00000010492a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a967faeULL, 0x0005e2000c901c46ULL, 0x0000004a8b00720cULL, 0x000fc60003f26070ULL,
0x0146c00092287984ULL, 0x002e640000000800ULL, 0x0000000428487824ULL, 0x002fcc00078e0291ULL,
0x0000000048487984ULL, 0x000e640000000800ULL, 0x0000004805297224ULL, 0x002fc800078e02a8ULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x00000010492a7825ULL, 0x004fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a957faeULL, 0x0003e2000c901c46ULL,
0x0000004a8a00720cULL, 0x000fc60003f26070ULL, 0x0146e00092287984ULL, 0x000ea40000000800ULL,
0x0000009128487211ULL, 0x004fcc00078e10ffULL, 0x0000000048487984ULL, 0x000ea40000000800ULL,
0x0000004805297224ULL, 0x004fc800078e02a6ULL, 0x00005e0029287625ULL, 0x000fcc00078e0090ULL,
0x0000001049287825ULL, 0x000fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028947faeULL, 0x0003e2000c901c46ULL, 0x000007d000007947ULL, 0x000fea0003800000ULL,
0x00000002ff817819ULL, 0x100fe20000011607ULL, 0x0000000166667824ULL, 0x100fe200078e0207ULL,
0x00014a8078917811ULL, 0x000fe400078e20ffULL, 0x0000000307a57812ULL, 0x000fe200078ec0ffULL,
0x0000000481927824ULL, 0x040fe200078e027cULL, 0x0000000366667812ULL, 0x000fe200078ec0ffULL,
0x0000000181b47824ULL, 0x000fe200078e02a6ULL, 0x00000008a5497812ULL, 0x020fe400078efcffULL,
0x0146000092287984ULL, 0x000e620000000800ULL, 0x0ffffffc66c47812ULL, 0x000fc400078ef807ULL,
0x00000008817f7810ULL, 0x040fe40007ffe0ffULL, 0x00000010818f7810ULL, 0x000fe20007ffe0ffULL,
0x00000010c49b7824ULL, 0x100fe200078e025dULL, 0x000000a67fb27210ULL, 0x0c0fe20007ffe0ffULL,
0x000000047f4b7824ULL, 0x000fe200078e00ffULL, 0x00000018818e7810ULL, 0x000fe20007ffe0ffULL,
0x000000018fb07824ULL, 0x000fe200078e02a6ULL, 0x00000020818d7810ULL, 0x000fe40007ffe0ffULL,
0xfffffffc4bc27812ULL, 0x000fe200078ee266ULL, 0x000000018eae7824ULL, 0x100fe200078e02a6ULL,
0x000000028f4b7819ULL, 0x000fe200000006ffULL, 0x000000018dac7824ULL, 0x000fe200078e02a6ULL,
0x00000028818c7810ULL, 0x000fe20007ffe0ffULL, 0x00000010c29a7824ULL, 0x100fe200078e025dULL,
0xfffffffc4bc07812ULL, 0x000fe200078ee266ULL, 0x000000048e4b7824ULL, 0x000fe200078e00ffULL,
0x00000030818b7810ULL, 0x040fe20007ffe0ffULL, 0x000000018caa7824ULL, 0x000fe200078e02a6ULL,
0x00000038818a7810ULL, 0x000fe20007ffe0ffULL, 0x00000010c0997824ULL, 0x000fe200078e025dULL,
0xfffffffc4bbe7812ULL, 0x000fe200078ee266ULL, 0x000000048d4b7824ULL, 0x000fe200078e00ffULL,
0x000000a68ba87210ULL, 0x000fe20007ffe0ffULL, 0x000000018aa67824ULL, 0x000fe200078e02a6ULL,
0x0000005dbe987211ULL, 0x000fc400078e20ffULL, 0xfffffffc4bbc7812ULL, 0x000fe200078ee266ULL,
0x000000048c4b7824ULL, 0x000fc800078e00ffULL, 0x00000010bc977824ULL, 0x000fe200078e025dULL,
0xfffffffc4bba7812ULL, 0x000fe200078ee266ULL, 0x000000048b4b7824ULL, 0x000fe200078e00ffULL,
0x00000091282a7211ULL, 0x002fc600078e10ffULL, 0x00000010ba967824ULL, 0x100fe200078e025dULL,
0xfffffffc4bb87812ULL, 0x100fe400078ee266ULL, 0x000000028a4b7819ULL, 0x000fe200000006ffULL,
0x000000002a2a7984ULL, 0x000e640000000800ULL, 0x00000010b8957824ULL, 0x000fe200078e025dULL,
0xfffffffc4bb67812ULL, 0x000fca00078ee266ULL, 0x00000010b6947824ULL, 0x000fe400078e025dULL,
0x0000002a05297224ULL, 0x002fc800078e02b4ULL, 0x00005e0029287625ULL, 0x000fcc00078e0090ULL,
0x0000001049287825ULL, 0x000fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000289b7faeULL, 0x0003e8000b901c46ULL, 0x01462000922a7984ULL, 0x000ea40000000800ULL,
0x000000042a487824ULL, 0x004fcc00078e0291ULL, 0x0000000048487984ULL, 0x000ea40000000800ULL,
0x00000048052b7224ULL, 0x004fc800078e02b2ULL, 0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL,
0x00000010492a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a9a7faeULL, 0x0005e8000b901c46ULL, 0x0146400092287984ULL, 0x002e640000000800ULL,
0x0000000428487824ULL, 0x002fcc00078e0291ULL, 0x0000000048487984ULL, 0x000e640000000800ULL,
0x0000004805297224ULL, 0x002fc800078e02b0ULL, 0x00005e0029287625ULL, 0x000fcc00078e0090ULL,
0x0000001049287825ULL, 0x000fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028997faeULL, 0x0003e8000b901c46ULL, 0x01466000922a7984ULL, 0x004ea40000000800ULL,
0x000000042a487824ULL, 0x004fcc00078e0291ULL, 0x0000000048487984ULL, 0x000ea40000000800ULL,
0x00000048052b7224ULL, 0x004fc800078e02aeULL, 0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL,
0x00000010492a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a987faeULL, 0x0005e8000b901c46ULL, 0x0146800092287984ULL, 0x002e640000000800ULL,
0x0000000428487824ULL, 0x002fcc00078e0291ULL, 0x0000000048487984ULL, 0x000e640000000800ULL,
0x0000004805297224ULL, 0x002fc800078e02acULL, 0x00005e0029287625ULL, 0x000fcc00078e0090ULL,
0x0000001049287825ULL, 0x000fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028977faeULL, 0x0003e8000b901c46ULL, 0x0146a000922a7984ULL, 0x004ea40000000800ULL,
0x000000912a487211ULL, 0x004fcc00078e10ffULL, 0x0000000048487984ULL, 0x000ea40000000800ULL,
0x00000048052b7224ULL, 0x004fc800078e02aaULL, 0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL,
0x00000010492a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a967faeULL, 0x0005e8000b901c46ULL, 0x0146c00092287984ULL, 0x002e640000000800ULL,
0x0000000428487824ULL, 0x002fcc00078e0291ULL, 0x0000000048487984ULL, 0x000e640000000800ULL,
0x0000004805297224ULL, 0x002fc800078e02a8ULL, 0x00005e0029287625ULL, 0x000fcc00078e0090ULL,
0x00000010492a7825ULL, 0x004fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a957faeULL, 0x0003e8000b901c46ULL, 0x0146e00092287984ULL, 0x000ea40000000800ULL,
0x0000000428487824ULL, 0x004fcc00078e0291ULL, 0x0000000048487984ULL, 0x000ea40000000800ULL,
0x0000004805297224ULL, 0x004fc800078e02a6ULL, 0x00005e0029287625ULL, 0x000fcc00078e0090ULL,
0x0000001049287825ULL, 0x000fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028947faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000207e297824ULL, 0x002fe200078e00ffULL, 0x0000000480287810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00003000a7a77810ULL, 0x000fe20007ffe0ffULL,
0x000000207e2a7824ULL, 0x000fe200078e00ffULL, 0xffffffe029287812ULL, 0x000fe200078ee228ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000a75e897211ULL, 0x000fe200078e20ffULL,
0x0000001064937824ULL, 0x100fe200078e02a7ULL, 0x0000000680297810ULL, 0x000fe20007ffe0ffULL,
0x0000001028287824ULL, 0x000fe200078e00ffULL, 0x00000e3000007945ULL, 0x000fe20003800000ULL,
0x0000001088887824ULL, 0x100fe200078e02a7ULL, 0x00000000936c783bULL, 0x000fe20000000200ULL,
0x000000105c877824ULL, 0x000fe200078e02a7ULL, 0xffffffe02a297812ULL, 0x000fe200078ee229ULL,
0x0000001086867824ULL, 0x100fe200078e02a7ULL, 0x000000002858783bULL, 0x000e620000000200ULL,
0x0000001084847824ULL, 0x100fe200078e02a7ULL, 0x0000000429487819ULL, 0x000fe200000006ffULL,
0x0000001082827824ULL, 0x100fe200078e02a7ULL, 0x000000008968783bULL, 0x000ea20000000200ULL,
0x00000010c6837824ULL, 0x000fc600078e02a7ULL, 0x000000008864783bULL, 0x000ee80000000200ULL,
0x00000000875c783bULL, 0x000f280000000200ULL, 0x000000008654783bULL, 0x000fe80000000200ULL,
0x000000004848783bULL, 0x000f280000000200ULL, 0x000000008450783bULL, 0x000f280000000200ULL,
0x00000000824c783bULL, 0x000f280000000200ULL, 0x000000008328783bULL, 0x000f220000000200ULL,
0x000080000000791aULL, 0x000fc80000000000ULL, 0x0000006c5860723cULL, 0x042f700000041860ULL,
0x00000068582c723cULL, 0x044f70000004182cULL, 0x000000645834723cULL, 0x048f700000041834ULL,
0x0000006e5844723cULL, 0x040f700000041844ULL, 0x0000006a5840723cULL, 0x040f700000041840ULL,
0x000000665838723cULL, 0x040f700000041838ULL, 0x0000005c583c723cULL, 0x050f70000004183cULL,
0x0000005e5830723cULL, 0x000f700000041830ULL, 0x000000544860723cULL, 0x060b700000041860ULL,
0x00000050482c723cULL, 0x040b70000004182cULL, 0x0000004c4834723cULL, 0x040b700000041834ULL,
0x000000564854723cULL, 0x040b700000041844ULL, 0x000000524850723cULL, 0x040b700000041840ULL,
0x0000004e484c723cULL, 0x040b700000041838ULL, 0x00000028483c723cULL, 0x040b70000004183cULL,
0x0000002a4848723cULL, 0x000b620000041830ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000064000008947ULL, 0x000fca0003800000ULL, 0x0146000092287984ULL, 0x020e620000000800ULL,
0x000000a275297217ULL, 0x000fe20007800000ULL, 0x00000010c4b57824ULL, 0x100fe200078e02a7ULL,
0x0000000ca5317812ULL, 0x000fe200078efcffULL, 0x00000010c2b37824ULL, 0x100fe200078e02a7ULL,
0x00000029a2387210ULL, 0x000fe20007ffe1ffULL, 0x00000010beaf7824ULL, 0x100fe200078e02a7ULL,
0x000000a7c0b17211ULL, 0x000fe200078e20ffULL, 0x00000010bcad7824ULL, 0x100fe200078e02a7ULL,
0x000000388100720cULL, 0x000fe20003f26070ULL, 0x00000010baab7824ULL, 0x000fc400078e02a7ULL,
0x00000010b8a97824ULL, 0x000fe200078e02a7ULL, 0x000000a7b6a77211ULL, 0x000fe200078e20ffULL,
0x0000000428287824ULL, 0x002fcc00078e0291ULL, 0x0000000028287984ULL, 0x000e640000000800ULL,
0x00000028052b7224ULL, 0x002fc800078e02b4ULL, 0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL,
0x00000010312a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002ab57faeULL, 0x0003e2000c901c46ULL, 0x000000387f00720cULL, 0x000fc60003f26070ULL,
0x0146200092307984ULL, 0x000ea40000000800ULL, 0x0000000430307824ULL, 0x004fcc00078e0291ULL,
0x0000000030307984ULL, 0x000ea40000000800ULL, 0x0000003005297224ULL, 0x004fc800078e02b2ULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x0000001031287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028b37faeULL, 0x0005e2000c901c46ULL,
0x000000388f00720cULL, 0x000fc60003f26070ULL, 0x0146400092327984ULL, 0x000ee40000000800ULL,
0x0000000432327824ULL, 0x008fcc00078e0291ULL, 0x0000000032327984ULL, 0x000e640000000800ULL,
0x00000032052b7224ULL, 0x002fc800078e02b0ULL, 0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL,
0x00000010312a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002ab17faeULL, 0x0003e2000c901c46ULL, 0x000000388e00720cULL, 0x000fc60003f26070ULL,
0x0146600092307984ULL, 0x000ee40000000800ULL, 0x0000000430307824ULL, 0x008fcc00078e0291ULL,
0x0000000030307984ULL, 0x000ea40000000800ULL, 0x0000003005297224ULL, 0x004fc800078e02aeULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x0000001031287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028af7faeULL, 0x0005e2000c901c46ULL,
0x000000388d00720cULL, 0x000fc60003f26070ULL, 0x0146800092327984ULL, 0x000ee40000000800ULL,
0x0000000432327824ULL, 0x008fcc00078e0291ULL, 0x0000000032327984ULL, 0x000e640000000800ULL,
0x00000032052b7224ULL, 0x002fc800078e02acULL, 0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL,
0x00000010312a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002aad7faeULL, 0x0003e2000c901c46ULL, 0x000000388c00720cULL, 0x000fc60003f26070ULL,
0x0146a00092307984ULL, 0x000ee40000000800ULL, 0x0000009130307211ULL, 0x008fcc00078e10ffULL,
0x0000000030307984ULL, 0x000ea40000000800ULL, 0x0000003005297224ULL, 0x004fc800078e02aaULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x0000001031287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028ab7faeULL, 0x0005e2000c901c46ULL,
0x000000388b00720cULL, 0x000fc60003f26070ULL, 0x0146c00092327984ULL, 0x000ee40000000800ULL,
0x0000000432327824ULL, 0x008fcc00078e0291ULL, 0x0000000032327984ULL, 0x000e640000000800ULL,
0x00000032052b7224ULL, 0x002fc800078e02a8ULL, 0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL,
0x00000010312a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002aa97faeULL, 0x0003e2000c901c46ULL, 0x000000388a00720cULL, 0x000fc60003f26070ULL,
0x0146e00092307984ULL, 0x000ee40000000800ULL, 0x0000000430307824ULL, 0x008fcc00078e0291ULL,
0x0000000030307984ULL, 0x000ea40000000800ULL, 0x0000003005297224ULL, 0x004fc800078e02a6ULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x0000001031287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028a77faeULL, 0x0003e2000c901c46ULL,
0x0000059000007947ULL, 0x000fea0003800000ULL, 0x0146000092287984ULL, 0x020e620000000800ULL,
0x0000000ca5397812ULL, 0x000fe200078efcffULL, 0x00000010c4b57824ULL, 0x100fe200078e02a7ULL,
0x000000a7bcad7211ULL, 0x000fe200078e20ffULL, 0x00000010c2b37824ULL, 0x100fe400078e02a7ULL,
0x00000010c0b17824ULL, 0x100fe400078e02a7ULL, 0x00000010beaf7824ULL, 0x100fe400078e02a7ULL,
0x00000010baab7824ULL, 0x000fc400078e02a7ULL, 0x00000010b8a97824ULL, 0x100fe400078e02a7ULL,
0x00000010b6a77824ULL, 0x000fe400078e02a7ULL, 0x0000000428287824ULL, 0x002fcc00078e0291ULL,
0x0000000028287984ULL, 0x000e640000000800ULL, 0x00000028052b7224ULL, 0x002fc800078e02b4ULL,
0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL, 0x00000010392a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002ab57faeULL, 0x0003e8000b901c46ULL,
0x0146200092307984ULL, 0x000ea40000000800ULL, 0x0000000430327824ULL, 0x004fcc00078e0291ULL,
0x0000000032327984ULL, 0x000ea40000000800ULL, 0x0000003205297224ULL, 0x004fc800078e02b2ULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x0000001039307825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030b37faeULL, 0x0005e8000b901c46ULL,
0x0146400092287984ULL, 0x000ee40000000800ULL, 0x0000009128337211ULL, 0x008fcc00078e10ffULL,
0x0000000033337984ULL, 0x000ee40000000800ULL, 0x0000003305297224ULL, 0x008fc800078e02b0ULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x00000010392a7825ULL, 0x002fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002ab17faeULL, 0x0003e8000b901c46ULL,
0x0146600092287984ULL, 0x000ee40000000800ULL, 0x0000000428327824ULL, 0x008fcc00078e0291ULL,
0x0000000032327984ULL, 0x000ee40000000800ULL, 0x0000003205297224ULL, 0x008fc800078e02aeULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x0000001039307825ULL, 0x004fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030af7faeULL, 0x0005e8000b901c46ULL,
0x0146800092287984ULL, 0x000ee40000000800ULL, 0x0000000428337824ULL, 0x008fcc00078e0291ULL,
0x0000000033337984ULL, 0x000ee40000000800ULL, 0x0000003305297224ULL, 0x008fc800078e02acULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x00000010392a7825ULL, 0x002fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002aad7faeULL, 0x0003e8000b901c46ULL,
0x0146a00092287984ULL, 0x000ee40000000800ULL, 0x0000000428327824ULL, 0x008fcc00078e0291ULL,
0x0000000032327984ULL, 0x000ee40000000800ULL, 0x0000003205297224ULL, 0x008fc800078e02aaULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x0000001039307825ULL, 0x004fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030ab7faeULL, 0x0005e8000b901c46ULL,
0x0146c00092287984ULL, 0x000ee40000000800ULL, 0x0000000428337824ULL, 0x008fcc00078e0291ULL,
0x0000000033337984ULL, 0x000ee40000000800ULL, 0x0000003305297224ULL, 0x008fc800078e02a8ULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x00000010392a7825ULL, 0x002fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002aa97faeULL, 0x0005e8000b901c46ULL,
0x0146e00092287984ULL, 0x000e640000000800ULL, 0x0000009128327211ULL, 0x002fcc00078e10ffULL,
0x0000000032327984ULL, 0x000e640000000800ULL, 0x0000003205297224ULL, 0x002fc800078e02a6ULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x0000001039287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028a77faeULL, 0x0005e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000207e297824ULL, 0x006fe200078e00ffULL,
0x0000000880287810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0xffffffe029287812ULL, 0x000fe200078ee228ULL, 0x00000000a36c783bULL, 0x000fe20000000200ULL,
0x000000207e2a7824ULL, 0x000fe200078e00ffULL, 0x0000000a80297810ULL, 0x000fe20007ffe0ffULL,
0x00000ce000007945ULL, 0x000fe20003800000ULL, 0x0000001028287824ULL, 0x000fe200078e00ffULL,
0x00000000a168783bULL, 0x000fe20000000200ULL, 0xffffffe02a297812ULL, 0x000fc600078ee229ULL,
0x000000002858783bULL, 0x000e620000000200ULL, 0x0000000429307819ULL, 0x000fc600000006ffULL,
0x00000000a064783bULL, 0x000ea80000000200ULL, 0x000000009f5c783bULL, 0x000ee80000000200ULL,
0x000000009e44783bULL, 0x000fe80000000200ULL, 0x000000003030783bULL, 0x000f280000000200ULL,
0x000000009d40783bULL, 0x000ee80000000200ULL, 0x000000009c38783bULL, 0x000ee80000000200ULL,
0x000000008528783bULL, 0x000ee80000000200ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000006c5860723cULL, 0x042f700000041860ULL, 0x00000068582c723cULL, 0x040f70000004182cULL,
0x000000645834723cULL, 0x004f620000041834ULL, 0x000080000000791aULL, 0x000fce0000000000ULL,
0x0000006e5854723cULL, 0x040f700000041854ULL, 0x0000006a5850723cULL, 0x040f700000041850ULL,
0x00000066584c723cULL, 0x040f70000004184cULL, 0x0000005c583c723cULL, 0x048f70000004183cULL,
0x0000005e5848723cULL, 0x000f700000041848ULL, 0x000000443060723cULL, 0x070b700000041860ULL,
0x00000040302c723cULL, 0x040b70000004182cULL, 0x000000383034723cULL, 0x040b700000041834ULL,
0x000000463044723cULL, 0x040b700000041854ULL, 0x000000423040723cULL, 0x040b700000041850ULL,
0x0000003a3038723cULL, 0x040b70000004184cULL, 0x00000028303c723cULL, 0x040b70000004183cULL,
0x0000002a3030723cULL, 0x000b620000041848ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000005c000008947ULL, 0x000fca0003800000ULL, 0x0146000092287984ULL, 0x020e620000000800ULL,
0x000000a275297217ULL, 0x000fe40007800000ULL, 0x00000010a5497812ULL, 0x000fc600078efcffULL,
0x00000001294c7824ULL, 0x000fca00078e0aa2ULL, 0x0000004c8100720cULL, 0x000fe20003f26070ULL,
0x0000000428287824ULL, 0x002fcc00078e0291ULL, 0x0000000028287984ULL, 0x000e640000000800ULL,
0x00000028052b7224ULL, 0x002fc800078e02b4ULL, 0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL,
0x00000010492a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a9b7faeULL, 0x0003e2000c901c46ULL, 0x0000004c7f00720cULL, 0x000fc60003f26070ULL,
0x0146200092487984ULL, 0x000ea40000000800ULL, 0x0000000448487824ULL, 0x004fcc00078e0291ULL,
0x0000000048487984ULL, 0x000ea40000000800ULL, 0x0000004805297224ULL, 0x004fc800078e02b2ULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x0000001049287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000289a7faeULL, 0x0005e2000c901c46ULL,
0x0000004c8f00720cULL, 0x000fc60003f26070ULL, 0x01464000924a7984ULL, 0x000ee40000000800ULL,
0x000000044a4a7824ULL, 0x008fcc00078e0291ULL, 0x000000004a4a7984ULL, 0x000e640000000800ULL,
0x0000004a052b7224ULL, 0x002fc800078e02b0ULL, 0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL,
0x00000010492a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a997faeULL, 0x0003e2000c901c46ULL, 0x0000004c8e00720cULL, 0x000fc60003f26070ULL,
0x0146600092487984ULL, 0x000ee40000000800ULL, 0x0000009148487211ULL, 0x008fcc00078e10ffULL,
0x0000000048487984ULL, 0x000ea40000000800ULL, 0x0000004805297224ULL, 0x004fc800078e02aeULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x0000001049287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028987faeULL, 0x0005e2000c901c46ULL,
0x0000004c8d00720cULL, 0x000fc60003f26070ULL, 0x01468000924a7984ULL, 0x000ee40000000800ULL,
0x000000044a4a7824ULL, 0x008fcc00078e0291ULL, 0x000000004a4a7984ULL, 0x000e640000000800ULL,
0x0000004a052b7224ULL, 0x002fc800078e02acULL, 0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL,
0x00000010492a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a977faeULL, 0x0003e2000c901c46ULL, 0x0000004c8c00720cULL, 0x000fc60003f26070ULL,
0x0146a00092487984ULL, 0x000ee40000000800ULL, 0x0000000448487824ULL, 0x008fcc00078e0291ULL,
0x0000000048487984ULL, 0x000ea40000000800ULL, 0x0000004805297224ULL, 0x004fc800078e02aaULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x0000001049287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028967faeULL, 0x0005e2000c901c46ULL,
0x0000004c8b00720cULL, 0x000fc60003f26070ULL, 0x0146c000924a7984ULL, 0x000ee40000000800ULL,
0x000000044a4a7824ULL, 0x008fcc00078e0291ULL, 0x000000004a4a7984ULL, 0x000e640000000800ULL,
0x0000004a052b7224ULL, 0x002fc800078e02a8ULL, 0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL,
0x00000010492a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a957faeULL, 0x0003e2000c901c46ULL, 0x0000004c8a00720cULL, 0x000fc60003f26070ULL,
0x0146e00092487984ULL, 0x000ee40000000800ULL, 0x0000000448487824ULL, 0x008fcc00078e0291ULL,
0x0000000048487984ULL, 0x000ea40000000800ULL, 0x0000004805297224ULL, 0x004fc800078e02a6ULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x0000001049287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028947faeULL, 0x0003e2000c901c46ULL,
0x0000051000007947ULL, 0x000fea0003800000ULL, 0x0146000092287984ULL, 0x020e620000000800ULL,
0x00000010a54b7812ULL, 0x000fe400078efcffULL, 0x0000009128487211ULL, 0x002fcc00078e10ffULL,
0x0000000048487984ULL, 0x000e640000000800ULL, 0x00000048052b7224ULL, 0x002fc800078e02b4ULL,
0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL, 0x000000104b2a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a9b7faeULL, 0x0003e8000b901c46ULL,
0x0146200092287984ULL, 0x000ea40000000800ULL, 0x0000000428497824ULL, 0x004fcc00078e0291ULL,
0x0000000049497984ULL, 0x000ea40000000800ULL, 0x0000004905297224ULL, 0x004fc800078e02b2ULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x000000104b287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000289a7faeULL, 0x0005e8000b901c46ULL,
0x0146400092487984ULL, 0x000ee40000000800ULL, 0x0000000448487824ULL, 0x008fcc00078e0291ULL,
0x0000000048487984ULL, 0x000e640000000800ULL, 0x00000048052b7224ULL, 0x002fc800078e02b0ULL,
0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL, 0x000000104b2a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a997faeULL, 0x0003e8000b901c46ULL,
0x01466000924a7984ULL, 0x000ee40000000800ULL, 0x000000044a4a7824ULL, 0x008fcc00078e0291ULL,
0x000000004a4a7984ULL, 0x000ea40000000800ULL, 0x0000004a05297224ULL, 0x004fc800078e02aeULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x000000104b287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028987faeULL, 0x0005e8000b901c46ULL,
0x0146800092487984ULL, 0x000ee40000000800ULL, 0x0000000448487824ULL, 0x008fcc00078e0291ULL,
0x0000000048487984ULL, 0x000e640000000800ULL, 0x00000048052b7224ULL, 0x002fc800078e02acULL,
0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL, 0x000000104b2a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a977faeULL, 0x0003e8000b901c46ULL,
0x0146a000924a7984ULL, 0x000ee40000000800ULL, 0x000000914a4a7211ULL, 0x008fcc00078e10ffULL,
0x000000004a4a7984ULL, 0x000ea40000000800ULL, 0x0000004a05297224ULL, 0x004fc800078e02aaULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x000000104b287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028967faeULL, 0x0005e8000b901c46ULL,
0x0146c00092487984ULL, 0x000ee40000000800ULL, 0x0000000448487824ULL, 0x008fcc00078e0291ULL,
0x0000000048487984ULL, 0x000e640000000800ULL, 0x00000048052b7224ULL, 0x002fc800078e02a8ULL,
0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL, 0x000000104b2a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a957faeULL, 0x0003e8000b901c46ULL,
0x0146e000924a7984ULL, 0x000ee40000000800ULL, 0x000000044a4a7824ULL, 0x008fcc00078e0291ULL,
0x000000004a4a7984ULL, 0x000ea40000000800ULL, 0x0000004a05297224ULL, 0x004fc800078e02a6ULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x000000104b287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028947faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000207e297824ULL, 0x002fe200078e00ffULL,
0x0000000c80287810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0xffffffe029287812ULL, 0x000fe200078ee228ULL, 0x00000000936c783bULL, 0x000fe20000000200ULL,
0x0000000e80297810ULL, 0x000fe20007ffe0ffULL, 0x00000cf000007945ULL, 0x000fe20003800000ULL,
0x000000057e2a7819ULL, 0x000fe200000006ffULL, 0x0000001028287824ULL, 0x000fe200078e00ffULL,
0x000000008968783bULL, 0x000fe40000000200ULL, 0xffffffe02a297812ULL, 0x000fe400078ee229ULL,
0x000000002858783bULL, 0x000e660000000200ULL, 0x0000001029487824ULL, 0x000fe200078e00ffULL,
0x000000008864783bULL, 0x000ea80000000200ULL, 0x00000000875c783bULL, 0x000ee80000000200ULL,
0x000000008654783bULL, 0x000fe80000000200ULL, 0x000000004848783bULL, 0x000f280000000200ULL,
0x000000008450783bULL, 0x000ee80000000200ULL, 0x00000000824c783bULL, 0x000ee80000000200ULL,
0x000000008328783bULL, 0x000ee80000000200ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000006c5860723cULL, 0x042f700000041860ULL, 0x00000068582c723cULL, 0x040f70000004182cULL,
0x000000645834723cULL, 0x004f620000041834ULL, 0x000080000000791aULL, 0x000fce0000000000ULL,
0x0000006e5844723cULL, 0x040f700000041844ULL, 0x0000006a5840723cULL, 0x040f700000041840ULL,
0x000000665838723cULL, 0x040f700000041838ULL, 0x0000005c583c723cULL, 0x048f70000004183cULL,
0x0000005e5830723cULL, 0x000f700000041830ULL, 0x000000544860723cULL, 0x070b700000041860ULL,
0x00000050482c723cULL, 0x040b70000004182cULL, 0x0000004c4834723cULL, 0x040b700000041834ULL,
0x000000564854723cULL, 0x040b700000041844ULL, 0x000000524850723cULL, 0x040b700000041840ULL,
0x0000004e484c723cULL, 0x040b700000041838ULL, 0x00000028483c723cULL, 0x040b70000004183cULL,
0x0000002a4848723cULL, 0x000b620000041830ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000005c000008947ULL, 0x000fca0003800000ULL, 0x0146000092287984ULL, 0x020e620000000800ULL,
0x000000a275297217ULL, 0x000fe40007800000ULL, 0x00000014a5317812ULL, 0x000fc600078efcffULL,
0x0000000129387824ULL, 0x000fca00078e0aa2ULL, 0x000000388100720cULL, 0x000fe20003f26070ULL,
0x0000000428287824ULL, 0x002fcc00078e0291ULL, 0x0000000028287984ULL, 0x000e640000000800ULL,
0x00000028052b7224ULL, 0x002fc800078e02b4ULL, 0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL,
0x00000010312a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002ab57faeULL, 0x0003e2000c901c46ULL, 0x000000387f00720cULL, 0x000fc60003f26070ULL,
0x0146200092307984ULL, 0x000ea40000000800ULL, 0x0000000430307824ULL, 0x004fcc00078e0291ULL,
0x0000000030307984ULL, 0x000ea40000000800ULL, 0x0000003005297224ULL, 0x004fc800078e02b2ULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x0000001031287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028b37faeULL, 0x0005e2000c901c46ULL,
0x000000388f00720cULL, 0x000fc60003f26070ULL, 0x0146400092327984ULL, 0x000ee40000000800ULL,
0x0000009132327211ULL, 0x008fcc00078e10ffULL, 0x0000000032327984ULL, 0x000e640000000800ULL,
0x00000032052b7224ULL, 0x002fc800078e02b0ULL, 0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL,
0x00000010312a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002ab17faeULL, 0x0003e2000c901c46ULL, 0x000000388e00720cULL, 0x000fc60003f26070ULL,
0x0146600092307984ULL, 0x000ee40000000800ULL, 0x0000000430307824ULL, 0x008fcc00078e0291ULL,
0x0000000030307984ULL, 0x000ea40000000800ULL, 0x0000003005297224ULL, 0x004fc800078e02aeULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x0000001031287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028af7faeULL, 0x0005e2000c901c46ULL,
0x000000388d00720cULL, 0x000fc60003f26070ULL, 0x0146800092327984ULL, 0x000ee40000000800ULL,
0x0000000432327824ULL, 0x008fcc00078e0291ULL, 0x0000000032327984ULL, 0x000e640000000800ULL,
0x00000032052b7224ULL, 0x002fc800078e02acULL, 0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL,
0x00000010312a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002aad7faeULL, 0x0003e2000c901c46ULL, 0x000000388c00720cULL, 0x000fc60003f26070ULL,
0x0146a00092307984ULL, 0x000ee40000000800ULL, 0x0000000430307824ULL, 0x008fcc00078e0291ULL,
0x0000000030307984ULL, 0x000ea40000000800ULL, 0x0000003005297224ULL, 0x004fc800078e02aaULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x0000001031287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028ab7faeULL, 0x0005e2000c901c46ULL,
0x000000388b00720cULL, 0x000fc60003f26070ULL, 0x0146c00092327984ULL, 0x000ee40000000800ULL,
0x0000000432327824ULL, 0x008fcc00078e0291ULL, 0x0000000032327984ULL, 0x000e640000000800ULL,
0x00000032052b7224ULL, 0x002fc800078e02a8ULL, 0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL,
0x00000010312a7825ULL, 0x000fca00078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002aa97faeULL, 0x0003e2000c901c46ULL, 0x000000388a00720cULL, 0x000fc60003f26070ULL,
0x0146e00092307984ULL, 0x000ee40000000800ULL, 0x0000009130307211ULL, 0x008fcc00078e10ffULL,
0x0000000030307984ULL, 0x000ea40000000800ULL, 0x0000003005297224ULL, 0x004fc800078e02a6ULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x0000001031287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028a77faeULL, 0x0003e2000c901c46ULL,
0x0000051000007947ULL, 0x000fea0003800000ULL, 0x0146000092287984ULL, 0x020e620000000800ULL,
0x00000014a5337812ULL, 0x000fe200078efcffULL, 0x0000000428307824ULL, 0x002fcc00078e0291ULL,
0x0000000030307984ULL, 0x000e640000000800ULL, 0x00000030052b7224ULL, 0x002fc800078e02b4ULL,
0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL, 0x00000010332a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002ab57faeULL, 0x0003e8000b901c46ULL,
0x0146200092287984ULL, 0x000ea40000000800ULL, 0x0000000428317824ULL, 0x004fcc00078e0291ULL,
0x0000000031317984ULL, 0x000ea40000000800ULL, 0x0000003105297224ULL, 0x004fc800078e02b2ULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x0000001033287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028b37faeULL, 0x0005e8000b901c46ULL,
0x0146400092307984ULL, 0x000ee40000000800ULL, 0x0000000430307824ULL, 0x008fcc00078e0291ULL,
0x0000000030307984ULL, 0x000e640000000800ULL, 0x00000030052b7224ULL, 0x002fc800078e02b0ULL,
0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL, 0x00000010332a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002ab17faeULL, 0x0003e8000b901c46ULL,
0x0146600092327984ULL, 0x000ee40000000800ULL, 0x0000000432327824ULL, 0x008fcc00078e0291ULL,
0x0000000032327984ULL, 0x000ea40000000800ULL, 0x0000003205297224ULL, 0x004fc800078e02aeULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x0000001033287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028af7faeULL, 0x0005e8000b901c46ULL,
0x0146800092307984ULL, 0x000ee40000000800ULL, 0x0000009130307211ULL, 0x008fcc00078e10ffULL,
0x0000000030307984ULL, 0x000e640000000800ULL, 0x00000030052b7224ULL, 0x002fc800078e02acULL,
0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL, 0x00000010332a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002aad7faeULL, 0x0003e8000b901c46ULL,
0x0146a00092327984ULL, 0x000ee40000000800ULL, 0x0000000432327824ULL, 0x008fcc00078e0291ULL,
0x0000000032327984ULL, 0x000ea40000000800ULL, 0x0000003205297224ULL, 0x004fc800078e02aaULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x0000001033287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028ab7faeULL, 0x0005e8000b901c46ULL,
0x0146c00092307984ULL, 0x000ee40000000800ULL, 0x0000000430307824ULL, 0x008fcc00078e0291ULL,
0x0000000030307984ULL, 0x000e640000000800ULL, 0x00000030052b7224ULL, 0x002fc800078e02a8ULL,
0x00005e002b2a7625ULL, 0x000fcc00078e0090ULL, 0x00000010332a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002aa97faeULL, 0x0003e8000b901c46ULL,
0x0146e00092327984ULL, 0x000ee40000000800ULL, 0x0000000432327824ULL, 0x008fcc00078e0291ULL,
0x0000000032327984ULL, 0x000ea40000000800ULL, 0x0000003205297224ULL, 0x004fc800078e02a6ULL,
0x00005e0029287625ULL, 0x000fcc00078e0090ULL, 0x0000001033287825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028a77faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000207e297824ULL, 0x002fe200078e00ffULL,
0x0000001080287810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0xffffffe029287812ULL, 0x000fe200078ee228ULL, 0x00000000a36c783bULL, 0x000fe20000000200ULL,
0x00000cf000007945ULL, 0x000fe40003800000ULL, 0x0000000428587819ULL, 0x000fe200000006ffULL,
0x00000000a168783bULL, 0x000fe20000000200ULL, 0x0000001280287810ULL, 0x000fc60007ffe0ffULL,
0x00000000a064783bULL, 0x000fe20000000200ULL, 0xffffffe029287812ULL, 0x000fc600078ee228ULL,
0x000000005858783bULL, 0x000e640000000200ULL, 0x0000001028407824ULL, 0x000fe400078e00ffULL,
0x000000009f5c783bULL, 0x000ea80000000200ULL, 0x000000009e28783bULL, 0x000fe80000000200ULL,
0x000000004040783bULL, 0x000ee80000000200ULL, 0x000000009d30783bULL, 0x000f280000000200ULL,
0x000000009c38783bULL, 0x000ea80000000200ULL, 0x000000008544783bULL, 0x000ea80000000200ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000006c5860723cULL, 0x042f700000041860ULL,
0x00000068582c723cULL, 0x000f62000004182cULL, 0x000080000000791aULL, 0x000fce0000000000ULL,
0x000000645834723cULL, 0x040f700000041834ULL, 0x0000006e5854723cULL, 0x040f700000041854ULL,
0x0000006a5850723cULL, 0x040f700000041850ULL, 0x00000066584c723cULL, 0x040f70000004184cULL,
0x0000005c583c723cULL, 0x044f70000004183cULL, 0x0000005e5848723cULL, 0x000f700000041848ULL,
0x000000284060723cULL, 0x068b700000041860ULL, 0x00000030402c723cULL, 0x050b70000004182cULL,
0x000000384034723cULL, 0x040b700000041834ULL, 0x0000002a4028723cULL, 0x040b700000041854ULL,
0x000000324030723cULL, 0x040b700000041850ULL, 0x0000003a4038723cULL, 0x040b70000004184cULL,
0x00000044403c723cULL, 0x040b70000004183cULL, 0x000000464040723cULL, 0x000b620000041848ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000005c000008947ULL, 0x000fca0003800000ULL,
0x0146000092447984ULL, 0x020e620000000800ULL, 0x000000a275457217ULL, 0x000fe40007800000ULL,
0x00000018a5497812ULL, 0x000fc600078efcffULL, 0x00000001454c7824ULL, 0x000fca00078e0aa2ULL,
0x0000004c8100720cULL, 0x000fe20003f26070ULL, 0x0000000444447824ULL, 0x002fcc00078e0291ULL,
0x0000000044447984ULL, 0x000e640000000800ULL, 0x0000004405477224ULL, 0x002fc800078e02b4ULL,
0x00005e0047467625ULL, 0x000fcc00078e0090ULL, 0x0000001049467825ULL, 0x000fca00078e0046ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000469b7faeULL, 0x0003e2000c901c46ULL,
0x0000004c7f00720cULL, 0x000fc60003f26070ULL, 0x0146200092487984ULL, 0x000ea40000000800ULL,
0x0000000448487824ULL, 0x004fcc00078e0291ULL, 0x0000000048487984ULL, 0x000ea40000000800ULL,
0x0000004805457224ULL, 0x004fc800078e02b2ULL, 0x00005e0045447625ULL, 0x000fcc00078e0090ULL,
0x0000001049447825ULL, 0x000fca00078e0044ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000449a7faeULL, 0x0005e2000c901c46ULL, 0x0000004c8f00720cULL, 0x000fc60003f26070ULL,
0x01464000924a7984ULL, 0x000ee40000000800ULL, 0x000000914a4a7211ULL, 0x008fcc00078e10ffULL,
0x000000004a4a7984ULL, 0x000e640000000800ULL, 0x0000004a05477224ULL, 0x002fc800078e02b0ULL,
0x00005e0047467625ULL, 0x000fcc00078e0090ULL, 0x0000001049467825ULL, 0x000fca00078e0046ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000046997faeULL, 0x0003e2000c901c46ULL,
0x0000004c8e00720cULL, 0x000fc60003f26070ULL, 0x0146600092487984ULL, 0x000ee40000000800ULL,
0x0000000448487824ULL, 0x008fcc00078e0291ULL, 0x0000000048487984ULL, 0x000ea40000000800ULL,
0x0000004805457224ULL, 0x004fc800078e02aeULL, 0x00005e0045447625ULL, 0x000fcc00078e0090ULL,
0x0000001049447825ULL, 0x000fca00078e0044ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044987faeULL, 0x0005e2000c901c46ULL, 0x0000004c8d00720cULL, 0x000fc60003f26070ULL,
0x01468000924a7984ULL, 0x000ee40000000800ULL, 0x000000044a4a7824ULL, 0x008fcc00078e0291ULL,
0x000000004a4a7984ULL, 0x000e640000000800ULL, 0x0000004a05477224ULL, 0x002fc800078e02acULL,
0x00005e0047467625ULL, 0x000fcc00078e0090ULL, 0x0000001049467825ULL, 0x000fca00078e0046ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000046977faeULL, 0x0003e2000c901c46ULL,
0x0000004c8c00720cULL, 0x000fc60003f26070ULL, 0x0146a00092487984ULL, 0x000ee40000000800ULL,
0x0000000448487824ULL, 0x008fcc00078e0291ULL, 0x0000000048487984ULL, 0x000ea40000000800ULL,
0x0000004805457224ULL, 0x004fc800078e02aaULL, 0x00005e0045447625ULL, 0x000fcc00078e0090ULL,
0x0000001049447825ULL, 0x000fca00078e0044ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044967faeULL, 0x0005e2000c901c46ULL, 0x0000004c8b00720cULL, 0x000fc60003f26070ULL,
0x0146c000924a7984ULL, 0x000ee40000000800ULL, 0x000000044a4a7824ULL, 0x008fcc00078e0291ULL,
0x000000004a4a7984ULL, 0x000e640000000800ULL, 0x0000004a05477224ULL, 0x002fc800078e02a8ULL,
0x00005e0047467625ULL, 0x000fcc00078e0090ULL, 0x0000001049467825ULL, 0x000fca00078e0046ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000046957faeULL, 0x0003e2000c901c46ULL,
0x0000004c8a00720cULL, 0x000fc60003f26070ULL, 0x0146e00092487984ULL, 0x000ee40000000800ULL,
0x0000009148487211ULL, 0x008fcc00078e10ffULL, 0x0000000048487984ULL, 0x000ea40000000800ULL,
0x0000004805457224ULL, 0x004fc800078e02a6ULL, 0x00005e0045447625ULL, 0x000fcc00078e0090ULL,
0x0000001049447825ULL, 0x000fca00078e0044ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044947faeULL, 0x0003e2000c901c46ULL, 0x0000051000007947ULL, 0x000fea0003800000ULL,
0x0146000092447984ULL, 0x020e620000000800ULL, 0x00000018a54b7812ULL, 0x000fe200078efcffULL,
0x0000000444487824ULL, 0x002fcc00078e0291ULL, 0x0000000048487984ULL, 0x000e640000000800ULL,
0x0000004805477224ULL, 0x002fc800078e02b4ULL, 0x00005e0047467625ULL, 0x000fcc00078e0090ULL,
0x000000104b467825ULL, 0x000fca00078e0046ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000469b7faeULL, 0x0003e8000b901c46ULL, 0x0146200092447984ULL, 0x000ea40000000800ULL,
0x0000000444497824ULL, 0x004fcc00078e0291ULL, 0x0000000049497984ULL, 0x000ea40000000800ULL,
0x0000004905457224ULL, 0x004fc800078e02b2ULL, 0x00005e0045447625ULL, 0x000fcc00078e0090ULL,
0x000000104b447825ULL, 0x000fca00078e0044ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000449a7faeULL, 0x0005e8000b901c46ULL, 0x0146400092487984ULL, 0x000ee40000000800ULL,
0x0000000448487824ULL, 0x008fcc00078e0291ULL, 0x0000000048487984ULL, 0x000e640000000800ULL,
0x0000004805477224ULL, 0x002fc800078e02b0ULL, 0x00005e0047467625ULL, 0x000fcc00078e0090ULL,
0x000000104b467825ULL, 0x000fca00078e0046ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000046997faeULL, 0x0003e8000b901c46ULL, 0x01466000924a7984ULL, 0x000ee40000000800ULL,
0x000000044a4a7824ULL, 0x008fcc00078e0291ULL, 0x000000004a4a7984ULL, 0x000ea40000000800ULL,
0x0000004a05457224ULL, 0x004fc800078e02aeULL, 0x00005e0045447625ULL, 0x000fcc00078e0090ULL,
0x000000104b447825ULL, 0x000fca00078e0044ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044987faeULL, 0x0005e8000b901c46ULL, 0x0146800092487984ULL, 0x000ee40000000800ULL,
0x0000009148487211ULL, 0x008fcc00078e10ffULL, 0x0000000048487984ULL, 0x000e640000000800ULL,
0x0000004805477224ULL, 0x002fc800078e02acULL, 0x00005e0047467625ULL, 0x000fcc00078e0090ULL,
0x000000104b467825ULL, 0x000fca00078e0046ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000046977faeULL, 0x0003e8000b901c46ULL, 0x0146a000924a7984ULL, 0x000ee40000000800ULL,
0x000000044a4a7824ULL, 0x008fcc00078e0291ULL, 0x000000004a4a7984ULL, 0x000ea40000000800ULL,
0x0000004a05457224ULL, 0x004fc800078e02aaULL, 0x00005e0045447625ULL, 0x000fcc00078e0090ULL,
0x000000104b447825ULL, 0x000fca00078e0044ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044967faeULL, 0x0005e8000b901c46ULL, 0x0146c00092487984ULL, 0x000ee40000000800ULL,
0x0000000448487824ULL, 0x008fcc00078e0291ULL, 0x0000000048487984ULL, 0x000e640000000800ULL,
0x0000004805477224ULL, 0x002fc800078e02a8ULL, 0x00005e0047467625ULL, 0x000fcc00078e0090ULL,
0x000000104b467825ULL, 0x000fca00078e0046ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000046957faeULL, 0x0003e8000b901c46ULL, 0x0146e000924a7984ULL, 0x000ee40000000800ULL,
0x000000044a4a7824ULL, 0x008fcc00078e0291ULL, 0x000000004a4a7984ULL, 0x000ea40000000800ULL,
0x0000004a05457224ULL, 0x004fc800078e02a6ULL, 0x00005e0045447625ULL, 0x000fcc00078e0090ULL,
0x000000104b447825ULL, 0x000fca00078e0044ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044947faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000207e457824ULL, 0x002fe200078e00ffULL, 0x0000001480447810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0xffffffe045447812ULL, 0x000fe200078ee244ULL,
0x00000000894c783bULL, 0x000fe20000000200ULL, 0x000000207e597824ULL, 0x000fe200078e00ffULL,
0x0000001680587810ULL, 0x000fe20007ffe0ffULL, 0x00000d0000007945ULL, 0x000fe20003800000ULL,
0x0000000444487819ULL, 0x000fe200000006ffULL, 0x000000008850783bULL, 0x000fe20000000200ULL,
0xffffffe059587812ULL, 0x000fc600078ee258ULL, 0x000000009344783bULL, 0x000fe40000000200ULL,
0x00000010585c7824ULL, 0x000fe400078e00ffULL, 0x000000004848783bULL, 0x000e680000000200ULL,
0x000000008754783bULL, 0x000ea80000000200ULL, 0x000000008658783bULL, 0x000fe80000000200ULL,
0x000000005c5c783bULL, 0x000ee80000000200ULL, 0x00000000846c783bULL, 0x000f280000000200ULL,
0x000000008268783bULL, 0x000ea80000000200ULL, 0x000000008364783bULL, 0x000ea80000000200ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000444860723cULL, 0x042f700000041860ULL,
0x000000464828723cULL, 0x000f620000041828ULL, 0x000080000000791aULL, 0x000fce0000000000ULL,
0x0000004c482c723cULL, 0x040f70000004182cULL, 0x0000004e4830723cULL, 0x040f700000041830ULL,
0x000000504834723cULL, 0x040f700000041834ULL, 0x000000524838723cULL, 0x040f700000041838ULL,
0x00000054483c723cULL, 0x044f70000004183cULL, 0x000000564840723cULL, 0x000f700000041840ULL,
0x000000585c60723cULL, 0x068f700000041860ULL, 0x0000005a5c28723cULL, 0x040f700000041828ULL,
0x0000006c5c2c723cULL, 0x050f70000004182cULL, 0x0000006e5c30723cULL, 0x040f700000041830ULL,
0x000000685c34723cULL, 0x040f700000041834ULL, 0x0000006a5c38723cULL, 0x040f700000041838ULL,
0x000000645c3c723cULL, 0x040f70000004183cULL, 0x000000665c5c723cULL, 0x000b6e0000041840ULL,
0x0000000370427812ULL, 0x020fc800078ec0ffULL, 0x000000ff42427207ULL, 0x000fe20005000000ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000005c000008947ULL, 0x000fea0003800000ULL,
0x0146000092407984ULL, 0x000e620000000800ULL, 0x000000a275417217ULL, 0x000fe40007800000ULL,
0x0000001ca5a57812ULL, 0x000fc600078efcffULL, 0x0000000141a27824ULL, 0x000fca00078e0aa2ULL,
0x000000a28100720cULL, 0x000fe20003f06070ULL, 0x0000000440437824ULL, 0x002fcc00078e0291ULL,
0x0000000043437984ULL, 0x000e640000000800ULL, 0x0000004305417224ULL, 0x002fc800078e02b4ULL,
0x00005e0041407625ULL, 0x000fcc00078e0090ULL, 0x00000010a5407825ULL, 0x000fca00078e0040ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000040b57faeULL, 0x0003e2000c101c46ULL,
0x000000a27f00720cULL, 0x000fc60003f06070ULL, 0x0146200092447984ULL, 0x000ea40000000800ULL,
0x0000009144467211ULL, 0x004fcc00078e10ffULL, 0x0000000046467984ULL, 0x000ea40000000800ULL,
0x0000004605457224ULL, 0x004fc800078e02b2ULL, 0x00005e0045447625ULL, 0x000fcc00078e0090ULL,
0x00000010a5447825ULL, 0x000fca00078e0044ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044b37faeULL, 0x0005e2000c101c46ULL, 0x000000a28f00720cULL, 0x000fc60003f06070ULL,
0x0146400092487984ULL, 0x000ee40000000800ULL, 0x0000000448487824ULL, 0x008fcc00078e0291ULL,
0x0000000048487984ULL, 0x000e640000000800ULL, 0x0000004805417224ULL, 0x002fc800078e02b0ULL,
0x00005e0041407625ULL, 0x000fcc00078e0090ULL, 0x00000010a5407825ULL, 0x000fca00078e0040ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000040b17faeULL, 0x0003e2000c101c46ULL,
0x000000a28e00720cULL, 0x000fc60003f06070ULL, 0x0146600092467984ULL, 0x000ee40000000800ULL,
0x0000000446467824ULL, 0x008fcc00078e0291ULL, 0x0000000046467984ULL, 0x000ea40000000800ULL,
0x0000004605457224ULL, 0x004fc800078e02aeULL, 0x00005e0045447625ULL, 0x000fcc00078e0090ULL,
0x00000010a5447825ULL, 0x000fca00078e0044ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044af7faeULL, 0x0005e2000c101c46ULL, 0x000000a28d00720cULL, 0x000fc60003f06070ULL,
0x0146800092487984ULL, 0x000ee40000000800ULL, 0x0000000448487824ULL, 0x008fcc00078e0291ULL,
0x0000000048487984ULL, 0x000e640000000800ULL, 0x0000004805417224ULL, 0x002fc800078e02acULL,
0x00005e0041407625ULL, 0x000fcc00078e0090ULL, 0x00000010a5407825ULL, 0x000fca00078e0040ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000040ad7faeULL, 0x0003e2000c101c46ULL,
0x000000a28c00720cULL, 0x000fc60003f06070ULL, 0x0146a00092467984ULL, 0x000ee40000000800ULL,
0x0000000446467824ULL, 0x008fcc00078e0291ULL, 0x0000000046467984ULL, 0x000ea40000000800ULL,
0x0000004605457224ULL, 0x004fc800078e02aaULL, 0x00005e0045447625ULL, 0x000fcc00078e0090ULL,
0x00000010a5447825ULL, 0x000fca00078e0044ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044ab7faeULL, 0x0005e2000c101c46ULL, 0x000000a28b00720cULL, 0x000fc60003f06070ULL,
0x0146c00092487984ULL, 0x000ee40000000800ULL, 0x0000009148487211ULL, 0x008fcc00078e10ffULL,
0x0000000048487984ULL, 0x000e640000000800ULL, 0x0000004805417224ULL, 0x002fc800078e02a8ULL,
0x00005e0041407625ULL, 0x000fcc00078e0090ULL, 0x00000010a5407825ULL, 0x000fca00078e0040ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000040a97faeULL, 0x0003e2000c101c46ULL,
0x000000a28a00720cULL, 0x000fc60003f06070ULL, 0x0146e00092467984ULL, 0x000ee40000000800ULL,
0x0000000446467824ULL, 0x008fcc00078e0291ULL, 0x0000000046467984ULL, 0x000ea40000000800ULL,
0x0000004605457224ULL, 0x004fc800078e02a6ULL, 0x00005e0045447625ULL, 0x000fcc00078e0090ULL,
0x00000010a5447825ULL, 0x000fca00078e0044ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044a77faeULL, 0x0003e2000c101c46ULL, 0x0000051000007947ULL, 0x000fea0003800000ULL,
0x0146000092407984ULL, 0x000e620000000800ULL, 0x0000001ca5a57812ULL, 0x000fe200078efcffULL,
0x0000000440437824ULL, 0x002fcc00078e0291ULL, 0x0000000043437984ULL, 0x000e640000000800ULL,
0x0000004305417224ULL, 0x002fc800078e02b4ULL, 0x00005e0041407625ULL, 0x000fcc00078e0090ULL,
0x00000010a5407825ULL, 0x000fca00078e0040ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000040b57faeULL, 0x0003e8000b901c46ULL, 0x0146200092447984ULL, 0x000ea40000000800ULL,
0x0000000444467824ULL, 0x004fcc00078e0291ULL, 0x0000000046467984ULL, 0x000ea40000000800ULL,
0x0000004605457224ULL, 0x004fc800078e02b2ULL, 0x00005e0045447625ULL, 0x000fcc00078e0090ULL,
0x00000010a5447825ULL, 0x000fca00078e0044ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044b37faeULL, 0x0005e8000b901c46ULL, 0x0146400092487984ULL, 0x000ee40000000800ULL,
0x0000000448487824ULL, 0x008fcc00078e0291ULL, 0x0000000048487984ULL, 0x000e640000000800ULL,
0x0000004805417224ULL, 0x002fc800078e02b0ULL, 0x00005e0041407625ULL, 0x000fcc00078e0090ULL,
0x00000010a5407825ULL, 0x000fca00078e0040ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000040b17faeULL, 0x0003e8000b901c46ULL, 0x0146600092467984ULL, 0x000ee40000000800ULL,
0x0000009146467211ULL, 0x008fcc00078e10ffULL, 0x0000000046467984ULL, 0x000ea40000000800ULL,
0x0000004605457224ULL, 0x004fc800078e02aeULL, 0x00005e0045447625ULL, 0x000fcc00078e0090ULL,
0x00000010a5447825ULL, 0x000fca00078e0044ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044af7faeULL, 0x0005e8000b901c46ULL, 0x0146800092487984ULL, 0x000ee40000000800ULL,
0x0000000448487824ULL, 0x008fcc00078e0291ULL, 0x0000000048487984ULL, 0x000e640000000800ULL,
0x0000004805417224ULL, 0x002fc800078e02acULL, 0x00005e0041407625ULL, 0x000fcc00078e0090ULL,
0x00000010a5407825ULL, 0x000fca00078e0040ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000040ad7faeULL, 0x0003e8000b901c46ULL, 0x0146a00092467984ULL, 0x000ee40000000800ULL,
0x0000000446467824ULL, 0x008fcc00078e0291ULL, 0x0000000046467984ULL, 0x000ea40000000800ULL,
0x0000004605457224ULL, 0x004fc800078e02aaULL, 0x00005e0045447625ULL, 0x000fcc00078e0090ULL,
0x00000010a5447825ULL, 0x000fca00078e0044ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044ab7faeULL, 0x0005e8000b901c46ULL, 0x0146c00092487984ULL, 0x000ee40000000800ULL,
0x0000000448487824ULL, 0x008fcc00078e0291ULL, 0x0000000048487984ULL, 0x000e640000000800ULL,
0x0000004805417224ULL, 0x002fc800078e02a8ULL, 0x00005e0041407625ULL, 0x000fcc00078e0090ULL,
0x00000010a5407825ULL, 0x000fca00078e0040ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000040a97faeULL, 0x0003e8000b901c46ULL, 0x0146e00092467984ULL, 0x000ee40000000800ULL,
0x0000000446467824ULL, 0x008fcc00078e0291ULL, 0x0000000046467984ULL, 0x000ea40000000800ULL,
0x0000004605457224ULL, 0x004fc800078e02a6ULL, 0x00005e0045447625ULL, 0x000fcc00078e0090ULL,
0x00000010a5447825ULL, 0x000fca00078e0044ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044a77faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000142407810ULL, 0x002fe20007ffe0ffULL, 0x000000207e467824ULL, 0x000fe200078e00ffULL,
0x000000a47300720cULL, 0x000fe20003f04070ULL, 0x00000004ff477424ULL, 0x000fe200078e00ffULL,
0x00000002ff417819ULL, 0x000fe20000011640ULL, 0x0000000407a57824ULL, 0x000fe200078e00ffULL,
0x0000000340407812ULL, 0x000fe200078ec0ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000000141417807ULL, 0x000fe20004000000ULL, 0x0000026000007945ULL, 0x000fe20003800000ULL,
0x000000ff40407207ULL, 0x000fe20004000000ULL, 0x000000017c497824ULL, 0x000fe200078e02a5ULL,
0x000000a47300720cULL, 0x000fe20003f24070ULL, 0x0000030041447a24ULL, 0x000fe200078e02a4ULL,
0x000000034200780cULL, 0x000fe20003f85270ULL, 0x0000000177417824ULL, 0x000fe200078e0240ULL,
0x0000002007457810ULL, 0x000fe40007ffe0ffULL, 0x0000007d44447211ULL, 0x000fc400078e40ffULL,
0x0000001880437810ULL, 0x000fc60007ffe0ffULL, 0x0000000144427824ULL, 0x000fe200078e0207ULL,
0xffffffe046437812ULL, 0x000fe200078ee243ULL, 0x0000680041407a24ULL, 0x000fc600078e0244ULL,
0x000000754200720cULL, 0x080fe20003f06070ULL, 0x0000000145467824ULL, 0x040fe200078e0240ULL,
0x0000004445427210ULL, 0x000fe20007ffe0ffULL, 0x0000000140447824ULL, 0x000fe200078e0207ULL,
0x0000000443547819ULL, 0x000fe400000006ffULL, 0x000000754200720cULL, 0x000fe20003f66070ULL,
0x0000660044447625ULL, 0x000fc800078e0047ULL, 0x0000660046467625ULL, 0x000fe200078e0047ULL,
0x0000010000009947ULL, 0x000fea0002000000ULL, 0x000000030700780cULL, 0x000fe20003f24070ULL,
0x00000300ff407624ULL, 0x000fc800078e00ffULL, 0x00000002407b7824ULL, 0x000fd000078e027bULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x0000000400407824ULL, 0x100fe200078e0207ULL,
0x000000767b00720cULL, 0x000fe20003f26070ULL, 0x0000000478427824ULL, 0x000fe200078e0207ULL,
0x0000000400417802ULL, 0x000fe20000000f00ULL, 0x0000000240407824ULL, 0x000fc600078e00ffULL,
0x00014a8042437811ULL, 0x000fe200078e10ffULL, 0x0000640040407a24ULL, 0x000fc800078e027bULL,
0x0000600040407625ULL, 0x000fca00078e0041ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000040437faeULL, 0x0003e4000c921846ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x1460000044497faeULL, 0x0005e2000c121846ULL,
0x000000207e4b7824ULL, 0x000fe200078e00ffULL, 0x0000001a80487810ULL, 0x000fe20007ffe0ffULL,
0x00000fa000007945ULL, 0x000fe20003800000ULL, 0x1468000046497faeULL, 0x0005e4000d921846ULL,
0xffffffe04b487812ULL, 0x000fe400078ee248ULL, 0x000000005454783bULL, 0x000fe60000000200ULL,
0x00000010486c7824ULL, 0x000fe200078e00ffULL, 0x00000000a140783bULL, 0x002e680000000200ULL,
0x00000000a064783bULL, 0x000ee80000000200ULL, 0x000000009f58783bULL, 0x000f280000000200ULL,
0x000000006c44783bULL, 0x004fe80000000200ULL, 0x000000009c48783bULL, 0x0004e80000000200ULL,
0x00000000a368783bULL, 0x000f280000000200ULL, 0x000000009e50783bULL, 0x000fe20000000200ULL,
0x00000001709c7810ULL, 0x004fc60007ffe0ffULL, 0x000000009d4c783bULL, 0x000fe80000000200ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000040542c723cULL, 0x042ff0000004182cULL,
0x000000425430723cULL, 0x040be40000041830ULL, 0x000000008540783bULL, 0x020e6c0000000200ULL,
0x000000645434723cULL, 0x008f620000041834ULL, 0x000080000000791aULL, 0x000fce0000000000ULL,
0x00000058543c723cULL, 0x050f70000004183cULL, 0x0000005a545c723cULL, 0x000f70000004185cULL,
0x000000484434723cULL, 0x020bee0000041834ULL, 0x00000002ff497819ULL, 0x020fe2000001169cULL,
0x000000685460723cULL, 0x000f660000041860ULL, 0x000000499c497207ULL, 0x000fca0001000000ULL,
0x0000006a5428723cULL, 0x040f700000041828ULL, 0x000000665438723cULL, 0x000f700000041838ULL,
0x00000040443c723cULL, 0x042b6e000004183cULL, 0x0000030049407a24ULL, 0x020fe200078e027aULL,
0x00000042445c723cULL, 0x000b66000004185cULL, 0x0000010040487824ULL, 0x000fc800078e027dULL,
0x0000000140437810ULL, 0x020fe20007ffe0ffULL, 0x000000504460723cULL, 0x000b620000041860ULL,
0x0000004048417812ULL, 0x000fe400078ec0ffULL, 0x000000744300720cULL, 0x000fe40003f06070ULL,
0x0000004106407210ULL, 0x000fc60007ffe0ffULL, 0x000000524428723cULL, 0x040b700000041828ULL,
0x0000004c442c723cULL, 0x040b70000004182cULL, 0x0000004e4430723cULL, 0x040b700000041830ULL,
0x0000004a4438723cULL, 0x000b620000041838ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000006d000008947ULL, 0x000fca0003800000ULL, 0x0146000092427984ULL, 0x020e620000000800ULL,
0x0000004875417217ULL, 0x000fe20007800000ULL, 0x0000001007447824ULL, 0x000fc800078e00ffULL,
0x0000000141487824ULL, 0x000fe200078e0a48ULL, 0x00000030444b7812ULL, 0x000fc800078ec0ffULL,
0x000000488100720cULL, 0x040fe20003f06070ULL, 0x0000000442467824ULL, 0x002fe400078e0291ULL,
0x0000000181427824ULL, 0x000fc800078e0240ULL, 0x0000000046467984ULL, 0x000e640000000800ULL,
0x0000004605437224ULL, 0x002fc800078e0242ULL, 0x00005e0043427625ULL, 0x000fca00078e0090ULL,
0x0000004b42447210ULL, 0x000fc80007f3e0ffULL, 0x00000043ff457210ULL, 0x000fe20000ffe4ffULL,
0x000000017f437824ULL, 0x000fc800078e0240ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000449b7faeULL, 0x0003e2000c101c46ULL, 0x000000487f00720cULL, 0x000fc60003f06070ULL,
0x0146200092427984ULL, 0x000ea40000000800ULL, 0x0000000442417824ULL, 0x004fca00078e0291ULL,
0x0000000041427984ULL, 0x0004e40000000800ULL, 0x000000408f417210ULL, 0x004fe20007ffe0ffULL,
0x0000004205437224ULL, 0x008fc800078e0243ULL, 0x00005e0043427625ULL, 0x000fca00078e0090ULL,
0x0000004b42467210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff477224ULL, 0x000fca00008e0643ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000469a7faeULL, 0x0005e2000c101c46ULL,
0x000000488f00720cULL, 0x000fc60003f06070ULL, 0x0146400092427984ULL, 0x000ee40000000800ULL,
0x0000000442497824ULL, 0x008fca00078e0291ULL, 0x0000000049427984ULL, 0x000ee40000000800ULL,
0x0000004205417224ULL, 0x008fc800078e0241ULL, 0x00005e0041427625ULL, 0x000fca00078e0090ULL,
0x0000004b42447210ULL, 0x002fca0007f3e0ffULL, 0x000000ffff457224ULL, 0x000fe400008e0643ULL,
0x000000018e437824ULL, 0x000fc600078e0240ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044997faeULL, 0x0003e2000c101c46ULL, 0x000000488e00720cULL, 0x000fc60003f06070ULL,
0x0146600092427984ULL, 0x000ee40000000800ULL, 0x0000000442417824ULL, 0x008fca00078e0291ULL,
0x0000000041427984ULL, 0x0007240000000800ULL, 0x000000018d417824ULL, 0x008fe400078e0240ULL,
0x0000004205437224ULL, 0x010fc800078e0243ULL, 0x00005e0043427625ULL, 0x000fca00078e0090ULL,
0x0000004b42467210ULL, 0x004fca0007f3e0ffULL, 0x000000ffff477224ULL, 0x000fca00008e0643ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000046987faeULL, 0x0005e2000c101c46ULL,
0x000000488d00720cULL, 0x000fc60003f06070ULL, 0x0146800092427984ULL, 0x000ee40000000800ULL,
0x0000009142497211ULL, 0x008fca00078e10ffULL, 0x0000000049427984ULL, 0x000ee40000000800ULL,
0x0000004205417224ULL, 0x008fc800078e0241ULL, 0x00005e0041427625ULL, 0x000fca00078e0090ULL,
0x0000004b42447210ULL, 0x002fca0007f3e0ffULL, 0x000000ffff457224ULL, 0x000fe400008e0643ULL,
0x000000018c437824ULL, 0x000fc600078e0240ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044977faeULL, 0x0003e2000c101c46ULL, 0x000000488c00720cULL, 0x000fc60003f06070ULL,
0x0146a00092427984ULL, 0x000ee40000000800ULL, 0x0000000442417824ULL, 0x008fca00078e0291ULL,
0x0000000041427984ULL, 0x0007240000000800ULL, 0x000000018b417824ULL, 0x008fe200078e0240ULL,
0x000000408a407210ULL, 0x000fe20007ffe0ffULL, 0x0000004205437224ULL, 0x010fc800078e0243ULL,
0x00005e0043427625ULL, 0x000fca00078e0090ULL, 0x0000004b42467210ULL, 0x004fc80007f3e0ffULL,
0x00000043ff477210ULL, 0x000fca0000ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000046967faeULL, 0x0005e2000c101c46ULL, 0x000000488b00720cULL, 0x000fc60003f06070ULL,
0x0146c00092427984ULL, 0x000e640000000800ULL, 0x0000000442447824ULL, 0x002fcc00078e0291ULL,
0x0000000044447984ULL, 0x000e640000000800ULL, 0x0000004405417224ULL, 0x002fc800078e0241ULL,
0x00005e0041427625ULL, 0x000fca00078e0090ULL, 0x0000004b42427210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff437224ULL, 0x000fca00008e0643ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000042957faeULL, 0x0003e2000c101c46ULL, 0x000000488a00720cULL, 0x000fc60003f06070ULL,
0x0146e00092467984ULL, 0x004ea40000000800ULL, 0x0000000446467824ULL, 0x004fcc00078e0291ULL,
0x0000000046467984ULL, 0x000ea40000000800ULL, 0x0000004605917224ULL, 0x004fc800078e0240ULL,
0x00005e0091907625ULL, 0x000fca00078e0090ULL, 0x0000004b90407210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff417224ULL, 0x000fca00008e0691ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000040947faeULL, 0x0003e2000c101c46ULL, 0x0000062000007947ULL, 0x000fea0003800000ULL,
0x0146000092427984ULL, 0x020e620000000800ULL, 0x0000000181437824ULL, 0x000fe400078e0240ULL,
0x0000001007447824ULL, 0x000fca00078e00ffULL, 0x0000003044497812ULL, 0x000fe200078ec0ffULL,
0x0000000442417824ULL, 0x002fca00078e0291ULL, 0x0000000041427984ULL, 0x000e640000000800ULL,
0x0000004205437224ULL, 0x002fc800078e0243ULL, 0x00005e0043427625ULL, 0x000fca00078e0090ULL,
0x0000004942447210ULL, 0x000fc80007f1e0ffULL, 0x00000043ff457210ULL, 0x000fe200007fe4ffULL,
0x000000017f437824ULL, 0x000fc800078e0240ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000449b7faeULL, 0x0003e8000b901c46ULL, 0x0146200092427984ULL, 0x000ea40000000800ULL,
0x0000000442487824ULL, 0x004fcc00078e0291ULL, 0x0000000048487984ULL, 0x000ea40000000800ULL,
0x0000004805437224ULL, 0x004fc800078e0243ULL, 0x00005e0043427625ULL, 0x000fca00078e0090ULL,
0x0000004942467210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff477224ULL, 0x000fe200000e0643ULL,
0x000000408f437210ULL, 0x000fc80007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000469a7faeULL, 0x0005e8000b901c46ULL, 0x0146400092427984ULL, 0x000ee40000000800ULL,
0x0000000442417824ULL, 0x008fca00078e0291ULL, 0x0000000041427984ULL, 0x000ee40000000800ULL,
0x0000004205437224ULL, 0x008fc800078e0243ULL, 0x00005e0043427625ULL, 0x000fca00078e0090ULL,
0x0000004942447210ULL, 0x002fca0007f1e0ffULL, 0x000000ffff457224ULL, 0x000fe400000e0643ULL,
0x000000018e437824ULL, 0x000fc600078e0240ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044997faeULL, 0x0003e8000b901c46ULL, 0x0146600092427984ULL, 0x000ee40000000800ULL,
0x0000000442487824ULL, 0x008fcc00078e0291ULL, 0x0000000048487984ULL, 0x000ee40000000800ULL,
0x0000004805437224ULL, 0x008fc800078e0243ULL, 0x00005e0043427625ULL, 0x000fca00078e0090ULL,
0x0000004942467210ULL, 0x004fca0007f1e0ffULL, 0x000000ffff477224ULL, 0x000fe400000e0643ULL,
0x000000018d437824ULL, 0x000fc600078e0240ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000046987faeULL, 0x0005e8000b901c46ULL, 0x0146800092427984ULL, 0x000ee40000000800ULL,
0x0000009142417211ULL, 0x008fca00078e10ffULL, 0x0000000041427984ULL, 0x000ee40000000800ULL,
0x0000004205437224ULL, 0x008fc800078e0243ULL, 0x00005e0043427625ULL, 0x000fca00078e0090ULL,
0x0000004942447210ULL, 0x002fca0007f1e0ffULL, 0x000000ffff457224ULL, 0x000fe400000e0643ULL,
0x000000018c437824ULL, 0x000fc600078e0240ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044977faeULL, 0x0003e8000b901c46ULL, 0x0146a00092427984ULL, 0x000ee40000000800ULL,
0x0000000442487824ULL, 0x008fcc00078e0291ULL, 0x0000000048487984ULL, 0x000ee40000000800ULL,
0x0000004805437224ULL, 0x008fc800078e0243ULL, 0x00005e0043427625ULL, 0x000fca00078e0090ULL,
0x0000004942467210ULL, 0x004fc80007f1e0ffULL, 0x00000043ff477210ULL, 0x000fe200007fe4ffULL,
0x000000018b437824ULL, 0x000fc800078e0240ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000046967faeULL, 0x0005e8000b901c46ULL, 0x0146c00092427984ULL, 0x000ee40000000800ULL,
0x0000000442417824ULL, 0x008fca00078e0291ULL, 0x0000000041427984ULL, 0x000ee40000000800ULL,
0x0000004205437224ULL, 0x008fc800078e0243ULL, 0x00005e0043427625ULL, 0x000fca00078e0090ULL,
0x0000004942427210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff437224ULL, 0x000fca00000e0643ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000042957faeULL, 0x0005e8000b901c46ULL,
0x0146e00092447984ULL, 0x002e640000000800ULL, 0x0000000444447824ULL, 0x002fe200078e0291ULL,
0x000000408a917210ULL, 0x000fca0007ffe0ffULL, 0x0000000044447984ULL, 0x000e640000000800ULL,
0x0000004405917224ULL, 0x002fc800078e0291ULL, 0x00005e0091907625ULL, 0x000fca00078e0090ULL,
0x0000004990407210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff417224ULL, 0x000fca00000e0691ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000040947faeULL, 0x0005e6000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000207e417824ULL, 0x006fe200078e00ffULL,
0x0000001c80407810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0xffffffe041407812ULL, 0x000fe200078ee240ULL, 0x000000009358783bULL, 0x000fe20000000200ULL,
0x0000001e80807810ULL, 0x000fe40007ffe0ffULL, 0x000000708100720cULL, 0x000fe20003f06070ULL,
0x0000001040547824ULL, 0x000fe200078e00ffULL, 0x00000000896c783bULL, 0x000fe20000000200ULL,
0xffffffe041807812ULL, 0x000fe400078ee280ULL, 0x0000009c8100720cULL, 0x000fe20004706470ULL,
0x000000008868783bULL, 0x000fe20000000200ULL, 0x000000707f00720cULL, 0x000fe20003f26070ULL,
0x0000001080407824ULL, 0x000fe200078e00ffULL, 0x0000007a7300720cULL, 0x000fe20000703070ULL,
0x000000005454783bULL, 0x000e620000000200ULL, 0x0000009c7f00720cULL, 0x000fe20000f21070ULL,
0x000000ffff707224ULL, 0x000fc400078e009cULL, 0x000000008764783bULL, 0x000ea20000000200ULL,
0x0000007a7300720cULL, 0x000fc60000f24470ULL, 0x000000008644783bULL, 0x000fe80000000200ULL,
0x000000004040783bULL, 0x000ee80000000200ULL, 0x000000008450783bULL, 0x000f280000000200ULL,
0x00000000824c783bULL, 0x000ea80000000200ULL, 0x000000008348783bULL, 0x000ea80000000200ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000005a5428723cULL, 0x042f700000041828ULL,
0x0000006c542c723cULL, 0x040f70000004182cULL, 0x000000685434723cULL, 0x040f700000041834ULL,
0x0000006a5438723cULL, 0x040f700000041838ULL, 0x00000064543c723cULL, 0x044ff0000004183cULL,
0x00000066545c723cULL, 0x040ff0000004185cULL, 0x0000006e5430723cULL, 0x040ff00000041830ULL,
0x000000585460723cULL, 0x000ff00000041860ULL, 0x000000464028723cULL, 0x068f700000041828ULL,
0x00000050402c723cULL, 0x050f70000004182cULL, 0x0000004c4034723cULL, 0x040f700000041834ULL,
0x0000004e4038723cULL, 0x000f640000041838ULL, 0x000000ffff128224ULL, 0x020fe200078e0029ULL,
0x000000222b227208ULL, 0x000fe20000800000ULL, 0x000000ffff138224ULL, 0x000fe200078e0028ULL,
0x000000232a237208ULL, 0x000fc60000800000ULL, 0x00000048403c723cULL, 0x000f62000004183cULL,
0x0000002d00108202ULL, 0x000fe20000000f00ULL, 0x000000ffff118224ULL, 0x000fe200078e002cULL,
0x000000202f207208ULL, 0x000fe40000800000ULL, 0x000000212e217208ULL, 0x000fc60000800000ULL,
0x0000004a405c723cULL, 0x000f62000004185cULL, 0x000000ffff0c8224ULL, 0x000fe200078e0035ULL,
0x0000001c371c7208ULL, 0x000fe20000800000ULL, 0x000000ffff0d8224ULL, 0x000fe200078e0034ULL,
0x0000001d361d7208ULL, 0x000fc80000800000ULL, 0x000000524030723cULL, 0x040f620000041830ULL,
0x000000ffff0a8224ULL, 0x000fe200078e0039ULL, 0x00000038000b8202ULL, 0x000fe40000000f00ULL,
0x0000001a3b1a7208ULL, 0x000fe40000800000ULL, 0x0000001b3a1b7208ULL, 0x000fe40000800000ULL,
0x000000444060723cULL, 0x000f640000041860ULL, 0x000000ffff088224ULL, 0x020fe200078e003dULL,
0x000000183f187208ULL, 0x000fe20000800000ULL, 0x000000ffff098224ULL, 0x000fe200078e003cULL,
0x000000193e197208ULL, 0x000fc60000800000ULL, 0x0000005d00278202ULL, 0x000fe20000000f00ULL,
0x000000ffff268224ULL, 0x000fe200078e005cULL, 0x000000165f167208ULL, 0x000fe40000800000ULL,
0x000000175e177208ULL, 0x000fc80000800000ULL, 0x000000ffff0e8224ULL, 0x000fe200078e0031ULL,
0x0000001e331e7208ULL, 0x000fe20000800000ULL, 0x000000ffff0f8224ULL, 0x000fe200078e0030ULL,
0x0000001f321f7208ULL, 0x000fca0000800000ULL, 0x000000ffff148224ULL, 0x000fe200078e0061ULL,
0x0000006000158202ULL, 0x000fe40000000f00ULL, 0x000000039c00720cULL, 0x000fe40003f06070ULL,
0x0000002463247208ULL, 0x000fe40000800000ULL, 0x0000002562257208ULL, 0x000fd20000800000ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff7be000007947ULL, 0x000fea000383ffffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000072287f8cULL, 0x000e62000c80043fULL,
0x3d8000000c2b7820ULL, 0x000fe20000410000ULL, 0x3d8000000d2a7820ULL, 0x000fe20000410000ULL,
0x3d8000001f2f7820ULL, 0x000fe20000410000ULL, 0x3d80000013137820ULL, 0x000fe20000410000ULL,
0x3d80000009097820ULL, 0x000fe20000410000ULL, 0x3d80000024247820ULL, 0x000fe20000410000ULL,
0x3d800000222c7820ULL, 0x000fe20000410000ULL, 0x3d800000212d7820ULL, 0x000fe20000410000ULL,
0x3d800000202e7820ULL, 0x000fe20000410000ULL, 0x3d8000001e307820ULL, 0x000fe20000410000ULL,
0x3d8000001b337820ULL, 0x000fe20000410000ULL, 0x3d80000015157820ULL, 0x000fe20000410000ULL,
0x3d80000014147820ULL, 0x000fe20000410000ULL, 0x3d80000012127820ULL, 0x000fe20000410000ULL,
0x3d80000011117820ULL, 0x000fe20000410000ULL, 0x3d80000010037820ULL, 0x000fe20000410000ULL,
0x3d8000000b0b7820ULL, 0x000fe20000410000ULL, 0x3d8000000a0a7820ULL, 0x000fe20000410000ULL,
0x3d80000008087820ULL, 0x000fe20000410000ULL, 0x3d80000026267820ULL, 0x000fe20000410000ULL,
0x3d80000027277820ULL, 0x000fe20000410000ULL, 0x3d80000025257820ULL, 0x000fe20000410000ULL,
0x3d8000001d317820ULL, 0x000fe20000410000ULL, 0x000000ffff367224ULL, 0x002fe200078e0029ULL,
0x3d8000000e297820ULL, 0x000fe20000410000ULL, 0x3d8000000f287820ULL, 0x000fe20000410000ULL,
0x3d8000001c327820ULL, 0x000fe20000410000ULL, 0x3d8000001a347820ULL, 0x000fe20000410000ULL,
0x3d80000019387820ULL, 0x000fe20000410000ULL, 0x3d80000018397820ULL, 0x000fe20000410000ULL,
0x3d800000173a7820ULL, 0x000fe20000410000ULL, 0x000000ffff1a7224ULL, 0x000fe200078e002bULL,
0x0000002900187202ULL, 0x000fe20000000f00ULL, 0x000000ffff177224ULL, 0x000fe200078e0028ULL,
0x3d800000163b7820ULL, 0x000fe20000410000ULL, 0x000000ffff197224ULL, 0x000fe200078e002aULL,
0x3d80000023237820ULL, 0x000fe20000410000ULL, 0x000000ffff2b7224ULL, 0x000fe200078e002fULL,
0x00000013000e7202ULL, 0x000fe20000000f00ULL, 0x000000ffff287224ULL, 0x000fe200078e002cULL,
0x00000009001d7202ULL, 0x000fe20000000f00ULL, 0x000000ffff297224ULL, 0x000fe200078e002dULL,
0x0000002400217202ULL, 0x000fe20000000f00ULL, 0x000000ffff2a7224ULL, 0x000fe200078e002eULL,
0x00000030002c7202ULL, 0x000fe20000000f00ULL, 0x000000ffff2f7224ULL, 0x000fc400078e0033ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0015ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0014ULL,
0x000000ffff0f7224ULL, 0x000fe400078e0012ULL, 0x000000ffff107224ULL, 0x000fe400078e0011ULL,
0x000000ffff167224ULL, 0x000fe400078e0003ULL, 0x000000ffff1b7224ULL, 0x000fc400078e000bULL,
0x000000ffff1c7224ULL, 0x000fe400078e000aULL, 0x000000ffff1e7224ULL, 0x000fe400078e0008ULL,
0x000000ffff1f7224ULL, 0x000fe400078e0026ULL, 0x000000ffff207224ULL, 0x000fe400078e0027ULL,
0x000000ffff227224ULL, 0x000fe400078e0025ULL, 0x000000ffff2d7224ULL, 0x000fc400078e0031ULL,
0x000000ffff2e7224ULL, 0x000fe400078e0032ULL, 0x000000ffff337224ULL, 0x000fc400078e0034ULL,
0x0000000000087805ULL, 0x000fca0000015200ULL, 0x0000040072037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804836ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ff00117202ULL, 0x000fe20000000f00ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101100780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a080a7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e09ULL,
0x003d09000a00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400a00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff037819ULL, 0x000fc8000001140bULL, 0x0000000a03037211ULL, 0x000fca00078110ffULL,
0x000000ffff0a7224ULL, 0x000fca00000e060bULL, 0x0000000203037819ULL, 0x000fc8000000120aULL,
0x000000030000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000111117810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040072037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe40007804836ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xfffffff0a5037812ULL, 0x000fe400078ec0ffULL,
0x000000797a00720cULL, 0x000fc60003f05270ULL, 0x0000008078037824ULL, 0x000fca00078e0203ULL,
0x0144000003087984ULL, 0x0002aa0000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000207117824ULL, 0x000fe200078e00ffULL, 0x8000000475047210ULL, 0x000fc80007ffe0ffULL,
0x0000000611117812ULL, 0x000fc800078ec0ffULL, 0x0000000111137812ULL, 0x040fe400078efcffULL,
0x0000000811157812ULL, 0x000fe400078efcffULL, 0x000000041300720cULL, 0x080fe40003f26070ULL,
0x0000001011137812ULL, 0x000fe400078efcffULL, 0x000000041500720cULL, 0x080fe40003f06070ULL,
0x000000041300720cULL, 0x000fc40003fc6070ULL, 0x0000001111157812ULL, 0x040fe400078efcffULL,
0x0000001811137812ULL, 0x040fe400078efcffULL, 0x000000041100720cULL, 0x080fe40003f46070ULL,
0x000000041500720cULL, 0x080fe40003fa6070ULL, 0x000000041300720cULL, 0x000fe40003f66070ULL,
0x0000000911257812ULL, 0x000fc400078efcffULL, 0x0000001911157812ULL, 0x040fe400078efcffULL,
0x0000002011137812ULL, 0x000fe400078efcffULL, 0xff80000022227808ULL, 0x000fe40005000000ULL,
0xff8000000d0d7808ULL, 0x000fe40005000000ULL, 0xff80000021217808ULL, 0x000fe40004800000ULL,
0xff8000000c0c7808ULL, 0x000fc40004800000ULL, 0x000000042500720cULL, 0x080fe40003f86070ULL,
0x000000041500720cULL, 0x080fe40003f46070ULL, 0x000000041300720cULL, 0x000fe40003f26070ULL,
0x0000002111157812ULL, 0x040fe400078efcffULL, 0x0000002811137812ULL, 0x000fe400078efcffULL,
0xff80000023237808ULL, 0x000fc40004000000ULL, 0xff8000000e0e7808ULL, 0x000fe40004000000ULL,
0xff80000028287808ULL, 0x000fe40006000000ULL, 0xff8000000f0f7808ULL, 0x000fe40006000000ULL,
0x000000041500720cULL, 0x080fe40003f06070ULL, 0x000000041300720cULL, 0x000fe40003f86070ULL,
0x0000002911157812ULL, 0x000fc400078efcffULL, 0x0000003011137812ULL, 0x000fe400078efcffULL,
0xff80000029297808ULL, 0x000fe40007000000ULL, 0xff80000010107808ULL, 0x000fe40007000000ULL,
0xff8000002a2a7808ULL, 0x000fe40006800000ULL, 0xff80000016167808ULL, 0x000fe40006800000ULL,
0x000000041500720cULL, 0x000fc40003fc6070ULL, 0x000000041300720cULL, 0x000fe40003fa6070ULL,
0x0000003111157812ULL, 0x040fe400078efcffULL, 0x0000003811137812ULL, 0x040fe400078efcffULL,
0x0000003911117812ULL, 0x000fe400078efcffULL, 0xff8000002b2b7808ULL, 0x000fe40005800000ULL,
0xff80000017177808ULL, 0x000fc40005800000ULL, 0xff8000002c2c7808ULL, 0x000fe40005000000ULL,
0xff80000018187808ULL, 0x000fe40005000000ULL, 0xff8000002d2d7808ULL, 0x000fe40004800000ULL,
0xff80000019197808ULL, 0x000fe40004800000ULL, 0x000000041500720cULL, 0x080fe40003f66070ULL,
0x000000041300720cULL, 0x000fc40003f46070ULL, 0x000000041100720cULL, 0x000fe40003f26070ULL,
0xff8000002e2e7808ULL, 0x000fe40004000000ULL, 0xff8000001a1a7808ULL, 0x000fe40004000000ULL,
0xff8000002f2f7808ULL, 0x000fe40006000000ULL, 0xff8000001b1b7808ULL, 0x000fe40006000000ULL,
0xff80000033337808ULL, 0x000fc40007000000ULL, 0xff8000001c1c7808ULL, 0x000fe40007000000ULL,
0xff80000038387808ULL, 0x000fe40006800000ULL, 0xff8000001d1d7808ULL, 0x000fe40006800000ULL,
0xff80000039397808ULL, 0x000fe40005800000ULL, 0xff8000001e1e7808ULL, 0x000fe40005800000ULL,
0xff8000003a3a7808ULL, 0x000fc40005000000ULL, 0xff8000001f1f7808ULL, 0x000fe40005000000ULL,
0xff8000003b3b7808ULL, 0x000fe40004800000ULL, 0xff80000020207808ULL, 0x000fc40004800000ULL,
0x0000000d0800720bULL, 0x004fe20003f1e000ULL, 0x0000001fff147424ULL, 0x000fe200078e00ffULL,
0x000000220900720bULL, 0x000fe20003f3e000ULL, 0xffffffffff277424ULL, 0x000fe200078e00ffULL,
0x000000080d117208ULL, 0x000fe40004000000ULL, 0x0000000922047208ULL, 0x000fc40004800000ULL,
0x0000000c1100720bULL, 0x000fe40003f1e000ULL, 0x000000210400720bULL, 0x000fe40003f3e000ULL,
0x000000110c117208ULL, 0x000fe40004000000ULL, 0x0000000421047208ULL, 0x000fe40004800000ULL,
0x0000000e1100720bULL, 0x000fe40003f1e000ULL, 0x000000230400720bULL, 0x000fc40003f3e000ULL,
0x000000110e087208ULL, 0x000fe40004000000ULL, 0x0000000423097208ULL, 0x000fe40004800000ULL,
0x0000000f0800720bULL, 0x000fe40003f1e000ULL, 0x000000280900720bULL, 0x000fe40003f3e000ULL,
0x000000080f117208ULL, 0x000fe40004000000ULL, 0x0000000928047208ULL, 0x000fc40004800000ULL,
0x000000101100720bULL, 0x000fe40003f1e000ULL, 0x000000290400720bULL, 0x000fe40003f3e000ULL,
0x0000001110117208ULL, 0x000fe40004000000ULL, 0x0000000429097208ULL, 0x000fe40004800000ULL,
0x000000161100720bULL, 0x000fe40003f1e000ULL, 0x0000002a0900720bULL, 0x000fc40003f3e000ULL,
0x0000001116047208ULL, 0x000fe40004000000ULL, 0x000000092a087208ULL, 0x000fe40004800000ULL,
0x000000170400720bULL, 0x000fe40003f1e000ULL, 0x0000002b0800720bULL, 0x000fe40003f3e000ULL,
0x0000000417097208ULL, 0x000fe40004000000ULL, 0x000000082b117208ULL, 0x000fc40004800000ULL,
0x000000180900720bULL, 0x000fe40003f1e000ULL, 0x0000002c1100720bULL, 0x000fe40003f3e000ULL,
0x0000000918047208ULL, 0x000fe40004000000ULL, 0x000000112c087208ULL, 0x000fe40004800000ULL,
0x000000190400720bULL, 0x000fe40003f1e000ULL, 0x0000002d0800720bULL, 0x000fc40003f3e000ULL,
0x0000000419097208ULL, 0x000fe40004000000ULL, 0x000000082d117208ULL, 0x000fe40004800000ULL,
0x0000001a0900720bULL, 0x000fe40003f1e000ULL, 0x0000002e1100720bULL, 0x000fe40003f3e000ULL,
0x000000091a047208ULL, 0x000fe40004000000ULL, 0x000000112e087208ULL, 0x000fc40004800000ULL,
0x0000001b0400720bULL, 0x000fe40003f1e000ULL, 0x0000002f0800720bULL, 0x000fe40003f3e000ULL,
0x000000041b097208ULL, 0x000fe40004000000ULL, 0x000000082f087208ULL, 0x000fe40004800000ULL,
0x0000001c0900720bULL, 0x000fe40003f1e000ULL, 0x000000330800720bULL, 0x000fc40003f3e000ULL,
0x000000091c047208ULL, 0x000fe40004000000ULL, 0x0000000833097208ULL, 0x000fe40004800000ULL,
0x0000001d0400720bULL, 0x000fe40003f1e000ULL, 0x000000380900720bULL, 0x000fe40003f3e000ULL,
0x000000041d117208ULL, 0x000fe40004000000ULL, 0x0000000938047208ULL, 0x000fc40004800000ULL,
0x0000001e1100720bULL, 0x000fe40003f1e000ULL, 0x000000390400720bULL, 0x000fe40003f3e000ULL,
0x000000111e087208ULL, 0x000fe40004000000ULL, 0x0000000439097208ULL, 0x000fe40004800000ULL,
0x0000001f0800720bULL, 0x000fe40003f1e000ULL, 0x0000003a0900720bULL, 0x000fc40003f3e000ULL,
0x000000081f117208ULL, 0x000fe40004000000ULL, 0x000000093a047208ULL, 0x000fe40004800000ULL,
0x000000201100720bULL, 0x000fe40003f1e000ULL, 0x0000003b0400720bULL, 0x000fe40003f3e000ULL,
0x0000001120117208ULL, 0x000fe40004000000ULL, 0x000000043b137208ULL, 0x000fe20004800000ULL,
0x000019527f007947ULL, 0x000fec000b800000ULL, 0x0c401f0011047f89ULL, 0x0004e400000e0000ULL,
0x000000041100720bULL, 0x00cfc80003f1e000ULL, 0x0000001104157208ULL, 0x000fe20004000000ULL,
0x000019527f007947ULL, 0x000fea000b800000ULL, 0x0c401f0013047f89ULL, 0x000ea800000e0000ULL,
0x0c401f000a097f89ULL, 0x000ee800000e0000ULL, 0x0c401f000b087f89ULL, 0x000f2800000e0000ULL,
0x0c201f0015307f89ULL, 0x000e6200000e0000ULL, 0x000000041300720bULL, 0x004fc40003f1e000ULL,
0x000000090a00720bULL, 0x008fe40003f3e000ULL, 0x0000001304047208ULL, 0x000fe40004000000ULL,
0x0000000a09097208ULL, 0x000fe40004800000ULL, 0x000000080b00720bULL, 0x010fe20003f1e000ULL,
0x0c201f0004317f89ULL, 0x000ea600000e0000ULL, 0x0000000b08407208ULL, 0x000fe20004000000ULL,
0x0c201f0009327f89ULL, 0x000ee200000e0000ULL, 0x000000301500720bULL, 0x002fc60003f1e000ULL,
0x0c201f0040417f89ULL, 0x00026200000e0000ULL, 0x0000001530307208ULL, 0x000fe40004000000ULL,
0x000000310400720bULL, 0x004fe40003f3e000ULL, 0x000000320900720bULL, 0x008fe40003f5e000ULL,
0x0000000431317208ULL, 0x000fe40004800000ULL, 0x0000000932327208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b30257820ULL, 0x002fe20000410000ULL, 0x3fb8aa3b31047820ULL, 0x000fe20000410000ULL,
0x3f80000000047882ULL, 0x000fe20000000000ULL, 0x0000000881447824ULL, 0x000fe200078e00ffULL,
0x3fb8aa3b0d0d7823ULL, 0x100fe20000010825ULL, 0x3fb8aa3b0c0c7823ULL, 0x100fe20000010825ULL,
0x3fb8aa3b0e137823ULL, 0x100fe20000010825ULL, 0x3fb8aa3b0f127823ULL, 0x100fe20000010825ULL,
0x0000000d00157308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b10117823ULL, 0x100fe20000010825ULL,
0x3fb8aa3b16107823ULL, 0x100fe20000010825ULL, 0x3fb8aa3b170f7823ULL, 0x100fe20000010825ULL,
0x3fb8aa3b180e7823ULL, 0x100fe20000010825ULL, 0x3fb8aa3b1b0b7823ULL, 0x100fe20000010825ULL,
0x3fb8aa3b1c0a7823ULL, 0x100fe20000010825ULL, 0x3fb8aa3b1d097823ULL, 0x100fe20000010825ULL,
0x0000000c00147308ULL, 0x0004e20000000800ULL, 0x3fb8aa3b190d7823ULL, 0x102fe20000010825ULL,
0x3fb8aa3b1e087823ULL, 0x100fe20000010825ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010825ULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010825ULL, 0x3fb8aa3b21247823ULL, 0x100fe20000010804ULL,
0x3fb8aa3b23237823ULL, 0x100fe20000010804ULL, 0x00000004ff3c7e24ULL, 0x000fe2000f8e00ffULL,
0x0000001300137308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1a0c7823ULL, 0x004fe20000010825ULL,
0x3fb8aa3b22257823ULL, 0x100fe20000010804ULL, 0x3fb8aa3b28227823ULL, 0x100fe20000010804ULL,
0x3f8000003c3c783eULL, 0x000fe200000010ffULL, 0x3fb8aa3b29217823ULL, 0x100fe20000010804ULL,
0x3fb8aa3b2c1e7823ULL, 0x100fe20000010804ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000001200127308ULL, 0x000fe20000000800ULL, 0x0000003c003d7202ULL, 0x080fe20000000f00ULL,
0x3fb8aa3b2d1d7823ULL, 0x100fe20000010804ULL, 0x000000151428723eULL, 0x008fe200000010ffULL,
0x3fb8aa3b2e1c7823ULL, 0x100fe20000010804ULL, 0x3fb8aa3b2f1b7823ULL, 0x100fe20000010804ULL,
0x3fb8aa3b331a7823ULL, 0x100fe20000010804ULL, 0x0000000181167810ULL, 0x000fe20007ffe0ffULL,
0x0000002500257308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b38197823ULL, 0x100fe20000010804ULL,
0x3fb8aa3b39187823ULL, 0x100fe20000010804ULL, 0x3fb8aa3b3a177823ULL, 0x000fe20000010804ULL,
0x0000003c00427202ULL, 0x000fe20000000f00ULL, 0x000000ffff437224ULL, 0x100fe200078e003cULL,
0x0000000281337810ULL, 0x040fe20007ffe0ffULL, 0x00000008813f7824ULL, 0x040fe200078e00ffULL,
0x0000002400247308ULL, 0x000e620000000800ULL, 0x0000000881487824ULL, 0x040fe200078e00ffULL,
0xfffffff844447812ULL, 0x000fe200078ee233ULL, 0x00000008814c7824ULL, 0x040fe200078e00ffULL,
0x0000000481337810ULL, 0x040fe20007ffe0ffULL, 0x00000008814a7824ULL, 0x040fe200078e00ffULL,
0x00000003814e7819ULL, 0x000fe200000006ffULL, 0x000000ffff537224ULL, 0x000fe200078e003cULL,
0x0000002300237308ULL, 0x000fe20000000800ULL, 0xfffffff848487812ULL, 0x000fe200078ee233ULL,
0x000000087f507824ULL, 0x000fe200078e00ffULL, 0x0000000681337810ULL, 0x000fc40007ffe0ffULL,
0x0000003c00527202ULL, 0x000fe40000000f00ULL, 0xfffffff84c4c7812ULL, 0x000fe200078ee233ULL,
0x0000002200227308ULL, 0x000ea20000000800ULL, 0x000000252429723eULL, 0x002fe400000010ffULL,
0x0000a00078337811ULL, 0x000fe400078e58ffULL, 0xfffffff850507812ULL, 0x000fe400078ee27fULL,
0x0000000ca5a57812ULL, 0x000fe200078ec0ffULL, 0x0000001f00267308ULL, 0x0003e20000000800ULL,
0x0000001044447824ULL, 0x100fe200078e0233ULL, 0x000000334c477211ULL, 0x000fe200078e20ffULL,
0x0000001048457824ULL, 0x100fe200078e0233ULL, 0x0000000307ff7812ULL, 0x000fe2000780c0ffULL,
0x0000001050497824ULL, 0x000fe200078e0233ULL, 0x00000044a5447210ULL, 0x040fe20007ffe0ffULL,
0x00000001a5457824ULL, 0x000fe200078e0245ULL, 0x0000002000277308ULL, 0x0007e20000000800ULL,
0x3fb8aa3b2b1f7823ULL, 0x002fe20000010804ULL, 0x00000023222b723eULL, 0x004fe200000010ffULL,
0x00000001a5477824ULL, 0x000fe200078e0247ULL, 0x000000414000720bULL, 0x000fc80003f3e000ULL,
0x0000001100117308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2a207823ULL, 0x108fe20000010804ULL,
0x00000013122a723eULL, 0x000fe200000010ffULL, 0x3fb8aa3b3b047823ULL, 0x000fca0000010804ULL,
0x0000001000107308ULL, 0x000e620000000800ULL, 0x0000003c2834723cULL, 0x000f6e00000418ffULL,
0x0000000f000f7308ULL, 0x000ff00000000800ULL, 0x0000000e000e7308ULL, 0x000ea20000000800ULL,
0x00000011102c723eULL, 0x002fce00000010ffULL, 0x0000002100217308ULL, 0x000ff00000000800ULL,
0x0000002000207308ULL, 0x000e620000000800ULL, 0x0000000f0e2e723eULL, 0x004fce00000010ffULL,
0x0000001f001f7308ULL, 0x000ff00000000800ULL, 0x0000001e001e7308ULL, 0x000ea20000000800ULL,
0x00000021202d723eULL, 0x002fce00000010ffULL, 0x0000000d000d7308ULL, 0x000fe20000000800ULL,
0x0000001f1e2f723eULL, 0x004fce00000010ffULL, 0x0000000c000c7308ULL, 0x000e620000000800ULL,
0x0000003c2c34723cULL, 0x020b6e0000041834ULL, 0x0000000b000b7308ULL, 0x000fe20000000800ULL,
0x00000008813d7824ULL, 0x020fce00078e00ffULL, 0x0000000a000a7308ULL, 0x000ea20000000800ULL,
0x0000000d0c38723eULL, 0x002fe400000010ffULL, 0xfffffff83d3e7812ULL, 0x000fe400078ee216ULL,
0x0000000381167810ULL, 0x040fe40007ffe0ffULL, 0x00000005813d7810ULL, 0x000fe20007ffe0ffULL,
0x0000001d001d7308ULL, 0x000fe20000000800ULL, 0xfffffff83f467812ULL, 0x000fe400078ee216ULL,
0xfffffff84a4a7812ULL, 0x000fc400078ee23dULL, 0xffffffff813d7810ULL, 0x000fc60007ffe0ffULL,
0x0000001c001c7308ULL, 0x000e620000000800ULL, 0x0000000b0a3a723eULL, 0x004fe400000010ffULL,
0xfffffff84e4e7812ULL, 0x000fca00078ee23dULL, 0x0000001b001b7308ULL, 0x000fe20000000800ULL,
0x000000104e487824ULL, 0x000fca00078e0233ULL, 0x00000048a5487210ULL, 0x000fe40007ffe0ffULL,
0x0000001a001a7308ULL, 0x000ea20000000800ULL, 0x0000001d1c39723eULL, 0x002fce00000010ffULL,
0x0000000900097308ULL, 0x000fe20000000800ULL, 0x0000001b1a3b723eULL, 0x004fce00000010ffULL,
0x0000000800087308ULL, 0x000e620000000800ULL, 0x000000423834723cULL, 0x000b6e0000041834ULL,
0x0000001900197308ULL, 0x000fe20000000800ULL, 0x000000103e437824ULL, 0x020fe200078e0233ULL,
0x00000026273e723eULL, 0x000fe200000010ffULL, 0x0000000881427824ULL, 0x000fca00078e00ffULL,
0x0000001800187308ULL, 0x000ea20000000800ULL, 0x00000009083c723eULL, 0x002fe200000010ffULL,
0x00000001a5437824ULL, 0x000fe200078e0243ULL, 0xfffffff842427812ULL, 0x000fca00078ee281ULL,
0x0000001700177308ULL, 0x000fe20000000800ULL, 0x0000001042427824ULL, 0x000fce00078e0233ULL,
0x0000000400167308ULL, 0x0002e20000000800ULL, 0x00000019183d723eULL, 0x004fe200000010ffULL,
0x0000001046047824ULL, 0x102fe400078e0233ULL, 0x000000104a467824ULL, 0x000fe400078e0233ULL,
0x00000001a5337824ULL, 0x040fe400078e0242ULL, 0x00000001a5047824ULL, 0x040fe200078e0204ULL,
0x00000017163f723eULL, 0x008fe200000010ffULL, 0x00000001a5467824ULL, 0x040fe200078e0246ULL,
0x0000002833007388ULL, 0x0003e20000000800ULL, 0x00000001a5427824ULL, 0x000fc600078e0249ULL,
0x0000002a43007388ULL, 0x0005e20000000800ULL, 0x000000523c34723cULL, 0x000f660000041834ULL,
0x0000002c44007388ULL, 0x0005e20000000800ULL, 0x0000004041337208ULL, 0x002fc60004800000ULL,
0x0000002e04007388ULL, 0x0005e80000000800ULL, 0x0000003845007388ULL, 0x0005e80000000800ULL,
0x0000003a46007388ULL, 0x0005e80000000800ULL, 0x0000003c47007388ULL, 0x0005e80000000800ULL,
0x0000003e48007388ULL, 0x0005e20000000800ULL, 0x000000ffff357224ULL, 0x020fc600078e0036ULL,
0x0000002942007388ULL, 0x0005e80000000800ULL, 0x0004002b43007388ULL, 0x0005e80000000800ULL,
0x0004002d44007388ULL, 0x0005e80000000800ULL, 0x0004002f04007388ULL, 0x0005e80000000800ULL,
0x0004003945007388ULL, 0x0005e80000000800ULL, 0x0004003b46007388ULL, 0x0005e80000000800ULL,
0x0004003d47007388ULL, 0x0005e80000000800ULL, 0x0004003f48007388ULL, 0x0005e80000000800ULL,
0x0140003003008388ULL, 0x0005e80000000c00ULL, 0x0142003403008388ULL, 0x0005e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014ad80071ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014ae00071ff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014ae80071ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000003007a7a7a10ULL, 0x000fe20007ffe0ffULL,
0x014af00071ff7f8cULL, 0x0003e6000c80043fULL, 0x000000747a00720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffff5f2000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff357807ULL, 0x004fe40004000000ULL,
0x000253a000347802ULL, 0x000fc40000000f00ULL, 0x0000109000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e0039ULL, 0xfffdf25000007947ULL, 0x000fea000383ffffULL,
0x00000001ff357807ULL, 0x000fe40004800000ULL, 0x000253f000347802ULL, 0x000fc40000000f00ULL,
0x0000104000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff2b7224ULL, 0x000fe200078e0039ULL,
0xfffdf29000007947ULL, 0x000fea000383ffffULL, 0x00000029003b7202ULL, 0x000fe20000000f00ULL,
0x000000ffff3a7224ULL, 0x000fe200078e0030ULL, 0x0002545000347802ULL, 0x000fc40000000f00ULL,
0x00000fa000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff297224ULL, 0x004fe200078e003aULL,
0xfffdf33000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0030ULL,
0x000254b000347802ULL, 0x000fe20000000f00ULL, 0x000000ffff3b7224ULL, 0x002fc400078e0029ULL,
0x00000f4000007944ULL, 0x008fea0003c00000ULL, 0x0000003a00297202ULL, 0x004fe20000000f00ULL,
0xfffdf43000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0029ULL,
0x0002551000347802ULL, 0x000fe20000000f00ULL, 0x000000ffff3b7224ULL, 0x000fc400078e0028ULL,
0x00000ee000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff277224ULL, 0x004fe200078e003aULL,
0xfffdf60000007947ULL, 0x000fea000383ffffULL, 0x00000026003b7202ULL, 0x002fe20000000f00ULL,
0x000000ffff3a7224ULL, 0x000fe200078e0029ULL, 0x0002557000347802ULL, 0x000fc40000000f00ULL,
0x00000e8000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff267224ULL, 0x004fe200078e003aULL,
0xfffdf5d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0036ULL,
0x000255d000347802ULL, 0x000fe20000000f00ULL, 0x000000ffff3b7224ULL, 0x000fc400078e007cULL,
0x00000e2000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff277224ULL, 0x004fe200078e003aULL,
0xfffe1b4000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0036ULL,
0x0000007b003b7202ULL, 0x002fc40000000f00ULL, 0x0002563000347802ULL, 0x000fc40000000f00ULL,
0x00000dc000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff267224ULL, 0x004fe200078e003aULL,
0xfffe1b0000007947ULL, 0x000fea000383ffffULL, 0x00000001ff357807ULL, 0x004fe40004000000ULL,
0x0002568000347802ULL, 0x000fc40000000f00ULL, 0x00000db000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e0039ULL, 0xfffe446000007947ULL, 0x000fea000383ffffULL,
0x00000001ff357807ULL, 0x000fe40004800000ULL, 0x000256d000347802ULL, 0x000fc40000000f00ULL,
0x00000d6000007944ULL, 0x008fea0003c00000ULL, 0xfffe44b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e003dULL, 0x0000007c003b7202ULL, 0x000fe40000000f00ULL,
0x0002572000347802ULL, 0x000fc40000000f00ULL, 0x00000cd000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff347224ULL, 0x004fe200078e003aULL, 0xfffe454000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e003dULL, 0x0002578000347802ULL, 0x000fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x002fc400078e007bULL, 0x00000c7000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff347224ULL, 0x004fe200078e003aULL, 0xfffe463000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0036ULL, 0x000257e000347802ULL, 0x000fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x000fc400078e007cULL, 0x00000c1000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff277224ULL, 0x004fe200078e003aULL, 0xfffe47f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0036ULL, 0x0000007b003b7202ULL, 0x002fc40000000f00ULL,
0x0002584000347802ULL, 0x000fc40000000f00ULL, 0x00000bb000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff267224ULL, 0x004fe200078e003aULL, 0xfffe47b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0036ULL, 0x0000007c003b7202ULL, 0x000fe40000000f00ULL,
0x000258a000347802ULL, 0x000fc40000000f00ULL, 0x00000b5000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff277224ULL, 0x004fe200078e003aULL, 0xfffe6a1000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0036ULL, 0x0002590000347802ULL, 0x000fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x002fc400078e007bULL, 0x00000af000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff267224ULL, 0x004fe200078e003aULL, 0xfffe69d000007947ULL, 0x000fea000383ffffULL,
0x00000001ff357807ULL, 0x004fe40004000000ULL, 0x0002595000347802ULL, 0x000fc40000000f00ULL,
0x00000ae000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e0039ULL,
0xfffe917000007947ULL, 0x000fea000383ffffULL, 0x00000001ff357807ULL, 0x000fe40004800000ULL,
0x000259a000347802ULL, 0x000fc40000000f00ULL, 0x00000a9000007944ULL, 0x008fea0003c00000ULL,
0xfffe91c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x000fe200078e003dULL,
0x000259f000347802ULL, 0x000fe20000000f00ULL, 0x000000ffff3b7224ULL, 0x000fc400078e007cULL,
0x00000a0000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff347224ULL, 0x004fe200078e003aULL,
0xfffe925000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x000fe200078e003dULL,
0x0000007b003b7202ULL, 0x002fc40000000f00ULL, 0x00025a5000347802ULL, 0x000fc40000000f00ULL,
0x000009a000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff347224ULL, 0x004fe200078e003aULL,
0xfffe934000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0036ULL,
0x00025ab000347802ULL, 0x000fe20000000f00ULL, 0x000000ffff3b7224ULL, 0x000fc400078e007cULL,
0x0000094000007944ULL, 0x004fea0003c00000ULL, 0x0000003a00277202ULL, 0x004fe20000000f00ULL,
0xfffe950000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0036ULL,
0x00025b1000347802ULL, 0x000fe20000000f00ULL, 0x000000ffff3b7224ULL, 0x002fc400078e007bULL,
0x000008e000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff267224ULL, 0x004fe200078e003aULL,
0xfffe94c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0036ULL,
0x00025b7000347802ULL, 0x000fe20000000f00ULL, 0x000000ffff3b7224ULL, 0x000fc400078e007cULL,
0x0000088000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff277224ULL, 0x004fe200078e003aULL,
0xfffeb72000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0036ULL,
0x0000007b003b7202ULL, 0x002fc40000000f00ULL, 0x00025bd000347802ULL, 0x000fc40000000f00ULL,
0x0000082000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff267224ULL, 0x004fe200078e003aULL,
0xfffeb6e000007947ULL, 0x000fea000383ffffULL, 0x00000001ff357807ULL, 0x004fe40004000000ULL,
0x00025c2000347802ULL, 0x000fc40000000f00ULL, 0x0000081000007944ULL, 0x008fea0003c00000ULL,
0x0000003900247202ULL, 0x000fe20000000f00ULL, 0xfffede8000007947ULL, 0x000fea000383ffffULL,
0x00000001ff357807ULL, 0x000fe40004800000ULL, 0x00025c7000347802ULL, 0x000fc40000000f00ULL,
0x000007c000007944ULL, 0x008fea0003c00000ULL, 0xfffeded000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e003dULL, 0x00025cc000347802ULL, 0x000fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x000fc400078e007cULL, 0x0000073000007944ULL, 0x008fea0003c00000ULL,
0x0000003a00347202ULL, 0x004fe20000000f00ULL, 0xfffedf6000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e003dULL, 0x00025d2000347802ULL, 0x000fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x002fc400078e007bULL, 0x000006d000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff347224ULL, 0x004fe200078e003aULL, 0xfffee05000007947ULL, 0x000fea000383ffffULL,
0x00000036003a7202ULL, 0x000fe20000000f00ULL, 0x000000ffff3b7224ULL, 0x000fe200078e007cULL,
0x00025d8000347802ULL, 0x000fc40000000f00ULL, 0x0000067000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff277224ULL, 0x004fe200078e003aULL, 0xfffee21000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0036ULL, 0x00025de000347802ULL, 0x000fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x002fc400078e007bULL, 0x0000061000007944ULL, 0x00cfea0003c00000ULL,
0x0000003a00267202ULL, 0x004fe20000000f00ULL, 0xfffee1d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0036ULL, 0x00025e4000347802ULL, 0x000fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x000fc400078e007cULL, 0x000005b000007944ULL, 0x000fea0003c00000ULL,
0x0000003a00277202ULL, 0x004fe20000000f00ULL, 0xffff043000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0036ULL, 0x00025ea000347802ULL, 0x000fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x002fc400078e007bULL, 0x0000055000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff267224ULL, 0x004fe200078e003aULL, 0xffff03f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x00cfe200078e0003ULL, 0x00025ef000347802ULL, 0x000fc40000000f00ULL,
0x0000050000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e003aULL,
0xffff0c7000007947ULL, 0x000fea000383ffffULL, 0x00000003003a7202ULL, 0x000fe40000000f00ULL,
0x00025f4000347802ULL, 0x000fc40000000f00ULL, 0x000004b000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff037224ULL, 0x004fe200078e003aULL, 0xffff0d6000007947ULL, 0x000fea000383ffffULL,
0x00000002ff127424ULL, 0x000fe200078e00ffULL, 0x00025f9000087802ULL, 0x000fc40000000f00ULL,
0x0000042000007944ULL, 0x002fea0003c00000ULL, 0xffffe68000007947ULL, 0x000fea000383ffffULL,
0x000000ffff117224ULL, 0x002fe200078e0013ULL, 0x0000000200127802ULL, 0x000fc40000000f00ULL,
0x00025fe000087802ULL, 0x000fc40000000f00ULL, 0x000003d000007944ULL, 0x000fea0003c00000ULL,
0x000000041300720bULL, 0x004fe20003f1e000ULL, 0x000000ffff117224ULL, 0x002fe200078e000aULL,
0x0002604000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff127424ULL, 0x000fe200078e00ffULL,
0x0000001304137208ULL, 0x000fc80004000000ULL, 0x0000037000007944ULL, 0x000fea0003c00000ULL,
0x000000040a00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff117224ULL, 0x002fe200078e000bULL,
0x000260a000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff127424ULL, 0x000fe200078e00ffULL,
0x0000000a04257208ULL, 0x000fc80004000000ULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x000000040b00720bULL, 0x004fe20003f1e000ULL, 0x00000001ff127424ULL, 0x002fe200078e00ffULL,
0x0000001500117202ULL, 0x000fc40000000f00ULL, 0x0000000b04407208ULL, 0x000fe40004000000ULL,
0x0002610000087802ULL, 0x000fc40000000f00ULL, 0x000002b000007944ULL, 0x000fea0003c00000ULL,
0x000000041500720bULL, 0x004fe20003f1e000ULL, 0x000000ffff117224ULL, 0x002fe200078e0013ULL,
0x0002616000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff127424ULL, 0x000fe200078e00ffULL,
0x0000001504307208ULL, 0x000fc80004000000ULL, 0x0000025000007944ULL, 0x000fea0003c00000ULL,
0x000000041300720bULL, 0x004fe20003f1e000ULL, 0x000000ffff117224ULL, 0x002fe200078e0025ULL,
0x0000000100127802ULL, 0x000fe40000000f00ULL, 0x0000001304317208ULL, 0x000fc40004000000ULL,
0x000261c000087802ULL, 0x000fc40000000f00ULL, 0x000001f000007944ULL, 0x000fea0003c00000ULL,
0x000000042500720bULL, 0x004fe20003f1e000ULL, 0x000000ffff117224ULL, 0x002fe200078e0040ULL,
0x0002622000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff127424ULL, 0x000fe200078e00ffULL,
0x0000002504327208ULL, 0x000fc80004000000ULL, 0x0000019000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff417224ULL, 0x004fe200078e0004ULL, 0xffffe54000007947ULL, 0x000fea000383ffffULL,
0x0180000030037810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000003077812ULL, 0x000fc800078ec0ffULL, 0x018000000700780cULL, 0x000fda0003f05070ULL,
0x0000003000038308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0700720cULL, 0x040fe40003f25070ULL, 0x008000000700780cULL, 0x000fe40003f02070ULL,
0x00000001ff0a7807ULL, 0x000fe40000800000ULL, 0x00000001ff037807ULL, 0x004fc80004000000ULL,
0x000000030aff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff30ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000030077812ULL, 0x000fe400078ec0ffULL,
0x00000001ff037807ULL, 0x000fc80000000000ULL, 0x000000030aff7212ULL, 0x000fda000780c0ffULL,
0x0080000007030812ULL, 0x000fe200078efcffULL, 0x000000ffff038224ULL, 0x000fe200078e0007ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000003000037308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000ff077424ULL, 0x000fc800078e00ffULL,
0xfffd9c5006007950ULL, 0x000fea0003c3ffffULL, 0x0000000000097802ULL, 0x000fe20000000f00ULL,
0x0000002700007348ULL, 0x000fe80003800000ULL, 0x0c00001211047389ULL, 0x0002a200000e0014ULL,
0xfffd9c1008007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff357424ULL, 0x000fe200078e00ffULL,
0x0000002000007348ULL, 0x000fe80003800000ULL, 0x0000003b3a3a7389ULL, 0x0002a200000e001fULL,
0xfffd9bd034007950ULL, 0x000fea0003c3ffffULL, 0x000000013500780cULL, 0x000fe20003f25070ULL,
0x0000002200007348ULL, 0x000fd80003800000ULL, 0x0000000000357806ULL, 0x000fc800048e0100ULL,
0x0000002235397212ULL, 0x000fe200078ec0ffULL, 0x00000000ff357424ULL, 0x000fc800078e00ffULL,
0xfffd9b7034007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff297424ULL, 0x000fe200078e00ffULL,
0x0000000200007348ULL, 0x000fe80003800000ULL, 0xfffd9b4028007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000001ULL, 0x0000000800000002ULL, 0x0000000100000001ULL, 0x0000000800000004ULL,
0x0000001000000001ULL, 0x0000000300000001ULL, 0x0000000400000004ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x000000000000056fULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000006d0ULL,
0x0000000000000270ULL, 0x0000001900000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000940ULL,
0x00000000000003a8ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000ce8ULL,
0x00000000000000e4ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000dccULL,
0x0000000000000cacULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001a78ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001a88ULL,
0x00000000000000b0ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000007bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001b38ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001b3cULL,
0x00000000000001c8ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001d80ULL,
0x0000000000026580ULL, 0xc900001900000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x0000000100000089ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000028300ULL,
0x000000000000003cULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000028340ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x00000000000286c0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001b38ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000267c8ULL,
0x00000000000267c8ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000028300ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x00000000000286c0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_4_kvt_bf16_pagedKV_128_nqpkv_1_m_1_sm_89_cubin_len = 165792;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
