/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_4_kvt_e4m3_pagedKV_128_nqpkv_1_m_1_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000024ac8ULL, 0x0000000000024748ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x766e2e0000000000ULL, 0x2e6c61626f6c672eULL, 0x65722e0074696e69ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6e6f632e766e2e00ULL, 0x000033746e617473ULL, 0x536d656d73000000ULL, 0x2e766e2e00657a69ULL,
0x692e6c61626f6c67ULL, 0x4e5a5a5f0074696eULL, 0x7473336164756334ULL, 0x5f5f38345f5f3364ULL,
0x31326c6961746564ULL, 0x676e6f7274735f5fULL, 0x726564726f5f7265ULL, 0x696945616475635fULL,
0x726f66785f5f3745ULL, 0x374b4e5a5a5f006dULL, 0x4944327961727241ULL, 0x326a4c45326a4c66ULL,
0x624c497461324545ULL, 0x6a664b5245454530ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x326a4c66495f5349ULL, 0x6a4c4545326a4c45ULL,
0x324545386a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f30534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x625f766e5f5f3431ULL,
0x32363174616f6c66ULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6a49636556334944ULL, 0x316a4c4545346a4cULL, 0x324545386a4c4536ULL, 0x454531624c497461ULL,
0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL,
0x4944327961727241ULL, 0x6a4c6a4963655633ULL, 0x4536316a4c454534ULL, 0x6132454532336a4cULL,
0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4534366a4c4545ULL,
0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL,
0x45326a4c45326a4cULL, 0x316a4c45316a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL,
0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL,
0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL, 0x4c4545316a4c4534ULL, 0x4545316a4c45326aULL,
0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x6e4974736e493949ULL, 0x45346a4c4974614dULL,
0x326a4c4545326a4cULL, 0x61324545316a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL,
0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL, 0x746132454536316aULL, 0x5245454531624c49ULL,
0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL,
0x4939494432796172ULL, 0x74614d6e4974736eULL, 0x326a4c45326a4c49ULL, 0x6a4c45326a4c4545ULL,
0x4c49746132454531ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x4545386a4c45346aULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x36316a4c4545346aULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x5f24000000000000ULL, 0x616e7265746e695fULL, 0x635f5f245f305f6cULL, 0x30326d735f616475ULL,
0x5f6e725f7063725fULL, 0x5f3233665f7a7466ULL, 0x68746170776f6c73ULL, 0x65742e6c65722e00ULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x747865742e616c65ULL, 0x5f6c656e72656b2eULL,
0x72656b240061686dULL, 0x2461686d5f6c656eULL, 0x657479426d656d73ULL, 0x6265642e00667542ULL,
0x656d6172665f6775ULL, 0x65642e6c65722e00ULL, 0x6d6172665f677562ULL, 0x2e616c65722e0065ULL,
0x72665f6775626564ULL, 0x2e766e2e00656d61ULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x0000000061686d5fULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000100000098ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b0003000000a1ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b0001000000b1ULL, 0x0000000000000034ULL, 0x0000000000000010ULL, 0x000b0001000000efULL,
0x000000000000001cULL, 0x0000000000000004ULL, 0x000b000100000128ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000b00010000016fULL, 0x000000000000002cULL, 0x0000000000000004ULL,
0x000b0001000001b9ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b0001000001ffULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000b000100000246ULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000b00010000028cULL, 0x0000000000000030ULL, 0x0000000000000004ULL,
0x000b0001000002daULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000328ULL,
0x0000000000000018ULL, 0x0000000000000004ULL, 0x000b000100000376ULL, 0x000000000000000cULL,
0x0000000000000004ULL, 0x000b0001000003bdULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000b00010000040bULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000b000100000450ULL,
0x0000000000000020ULL, 0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000a0022000004abULL, 0x0000000000022d50ULL, 0x0000000000000230ULL,
0x0004000300000521ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a101200000040ULL,
0x0000000000000000ULL, 0x0000000000022f80ULL, 0x000d000300000551ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000024ffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00022d5000000000ULL, 0x0000700400000000ULL,
0x0000288080810c00ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880808492ULL, 0x0000002cffffffffULL, 0x0000006000000000ULL,
0x00022d5000000000ULL, 0x0000023000000000ULL, 0x0000580400000000ULL, 0x8082288080840900ULL,
0x0000000000002880ULL, 0x0000001600082f04ULL, 0x0008230400000079ULL, 0x0000000000000014ULL,
0x0000001400081204ULL, 0x0008110400000000ULL, 0x0000000000000014ULL, 0x0000001600082304ULL,
0x0008120400000000ULL, 0x0000000000000016ULL, 0x0000001600081104ULL, 0x0004370400000000ULL,
0x000c17040000007bULL, 0x0060000700000000ULL, 0x000c17040021f000ULL, 0x0058000600000000ULL,
0x000c17040021f000ULL, 0x0050000500000000ULL, 0x000c17040011f000ULL, 0x0038000400000000ULL,
0x000c17040061f000ULL, 0x0018000300000000ULL, 0x000c17040081f000ULL, 0x0010000200000000ULL,
0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL,
0x00801b030011f000ULL, 0xffffffff00c82904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x00c82804ffffffffULL, 0x00000100000000b0ULL,
0x0000330000000780ULL, 0x0000343000003370ULL, 0x0000382000003570ULL, 0x0000651000003830ULL,
0x0000954000006520ULL, 0x00009660000095b0ULL, 0x0000996000009790ULL, 0x0000c4a000009970ULL,
0x0000f3e00000c4b0ULL, 0x0000f5000000f450ULL, 0x0000f8000000f630ULL, 0x000123400000f810ULL,
0x0001528000012350ULL, 0x000153a0000152f0ULL, 0x000156a0000154d0ULL, 0x000181e0000156b0ULL,
0x00019cd0000181f0ULL, 0x0001a42000019ce0ULL, 0x0001cba00001a790ULL, 0x0001f8300001d5d0ULL,
0x00021f0000021ec0ULL, 0x00022290000221e0ULL, 0x00022510000224a0ULL, 0x000227c000022580ULL,
0x0000021007d03904ULL, 0x00018ad0000000ffULL, 0x000002f000040100ULL, 0x00018ad800000008ULL,
0x00000400003f0100ULL, 0x00018b5800000008ULL, 0x00000520003f0100ULL, 0x00018b7800000003ULL,
0x00000610003f0100ULL, 0x00018b88000000ffULL, 0x000008f000040100ULL, 0x00018ad0000000ffULL,
0x00000b7000070107ULL, 0x00018b580000005dULL, 0x00000bb000070101ULL, 0x00018b88000000ffULL,
0x00000be000070101ULL, 0x00018b88000000ffULL, 0x00000d5000070109ULL, 0x00018b88000000ffULL,
0x000017d000070109ULL, 0x00018b88000000ffULL, 0x0000180000070101ULL, 0x00018b88000000ffULL,
0x0000197000070109ULL, 0x00018b88000000ffULL, 0x00001ad000070109ULL, 0x00018b78000000ffULL,
0x00001b1000070107ULL, 0x00018b78000000ffULL, 0x00001b9000070101ULL, 0x00018b88000000ffULL,
0x00001d9000070101ULL, 0x00018b78000000ffULL, 0x00001f0000070109ULL, 0x00018b78000000ffULL,
0x00001f3000070109ULL, 0x00018b88000000ffULL, 0x000020a000070109ULL, 0x00018b88000000ffULL,
0x00002b2000070109ULL, 0x00018b88000000ffULL, 0x00002b5000070101ULL, 0x00018b88000000ffULL,
0x00002cc000070109ULL, 0x00018b88000000ffULL, 0x0000305000070109ULL, 0x00018b80000000ffULL,
0x0000309000070107ULL, 0x00018b80000000ffULL, 0x000030b000070101ULL, 0x00018ad80000005dULL,
0x000030e000070101ULL, 0x00018ad80000005dULL, 0x0000325000070109ULL, 0x00018ad80000005dULL,
0x000052b000070109ULL, 0x00018b88000000ffULL, 0x0000537000070101ULL, 0x00018b80000000ffULL,
0x000054e000070109ULL, 0x00018b80000000ffULL, 0x0000551000070109ULL, 0x00018b88000000ffULL,
0x0000568000070109ULL, 0x00018b88000000ffULL, 0x000060f000070109ULL, 0x00018b88000000ffULL,
0x0000612000070101ULL, 0x00018b88000000ffULL, 0x0000629000070109ULL, 0x00018b88000000ffULL,
0x0000648000070109ULL, 0x00000000000000ffULL, 0x000064d000080107ULL, 0x00018b78000000ffULL,
0x00007ed000070101ULL, 0x00018b88000000ffULL, 0x00007f2000070101ULL, 0x00018b58000000ffULL,
0x00007ff000070101ULL, 0x00018b78000000ffULL, 0x0000816000070109ULL, 0x00018b78000000ffULL,
0x0000819000070109ULL, 0x00018b88000000ffULL, 0x0000830000070109ULL, 0x00018b88000000ffULL,
0x00008d8000070109ULL, 0x00018b88000000ffULL, 0x00008db000070101ULL, 0x00018b88000000ffULL,
0x00008f2000070109ULL, 0x00018b88000000ffULL, 0x0000928000070109ULL, 0x00000000000000ffULL,
0x000092b0000d0107ULL, 0x00018b80000000ffULL, 0x000092f000070101ULL, 0x00018af80000005dULL,
0x0000932000070101ULL, 0x00018af80000005dULL, 0x0000949000070109ULL, 0x00018af80000005dULL,
0x0000b28000070109ULL, 0x00018b88000000ffULL, 0x0000b35000070101ULL, 0x00018b80000000ffULL,
0x0000b4c000070109ULL, 0x00018b80000000ffULL, 0x0000b4f000070109ULL, 0x00018b88000000ffULL,
0x0000b66000070109ULL, 0x00018b88000000ffULL, 0x0000c0d000070109ULL, 0x00018b88000000ffULL,
0x0000c10000070101ULL, 0x00018b88000000ffULL, 0x0000c27000070109ULL, 0x00018b88000000ffULL,
0x0000c43000070109ULL, 0x00000000000000ffULL, 0x0000c46000080107ULL, 0x00018b78000000ffULL,
0x0000dd8000070101ULL, 0x00018b88000000ffULL, 0x0000ddc000070101ULL, 0x00018b60000000ffULL,
0x0000de9000070101ULL, 0x00018b78000000ffULL, 0x0000e00000070109ULL, 0x00018b78000000ffULL,
0x0000e03000070109ULL, 0x00018b88000000ffULL, 0x0000e1a000070109ULL, 0x00018b88000000ffULL,
0x0000ec2000070109ULL, 0x00018b88000000ffULL, 0x0000ec5000070101ULL, 0x00018b88000000ffULL,
0x0000edc000070109ULL, 0x00018b88000000ffULL, 0x0000f12000070109ULL, 0x00000000000000ffULL,
0x0000f150000d0107ULL, 0x00018b80000000ffULL, 0x0000f19000070101ULL, 0x00018b180000005dULL,
0x0000f1c000070101ULL, 0x00018b180000005dULL, 0x0000f33000070109ULL, 0x00018b180000005dULL,
0x0001112000070109ULL, 0x00018b88000000ffULL, 0x000111f000070101ULL, 0x00018b80000000ffULL,
0x0001136000070109ULL, 0x00018b80000000ffULL, 0x0001139000070109ULL, 0x00018b88000000ffULL,
0x0001150000070109ULL, 0x00018b88000000ffULL, 0x00011f7000070109ULL, 0x00018b88000000ffULL,
0x00011fa000070101ULL, 0x00018b88000000ffULL, 0x0001211000070109ULL, 0x00018b88000000ffULL,
0x000122d000070109ULL, 0x00000000000000ffULL, 0x0001230000080107ULL, 0x00018b78000000ffULL,
0x00013c2000070101ULL, 0x00018b88000000ffULL, 0x00013c6000070101ULL, 0x00018b68000000ffULL,
0x00013d3000070101ULL, 0x00018b78000000ffULL, 0x00013ea000070109ULL, 0x00018b78000000ffULL,
0x00013ed000070109ULL, 0x00018b88000000ffULL, 0x0001404000070109ULL, 0x00018b88000000ffULL,
0x00014ac000070109ULL, 0x00018b88000000ffULL, 0x00014af000070101ULL, 0x00018b88000000ffULL,
0x00014c6000070109ULL, 0x00018b88000000ffULL, 0x00014fc000070109ULL, 0x00000000000000ffULL,
0x00014ff0000d0107ULL, 0x00018b80000000ffULL, 0x0001503000070101ULL, 0x00018b380000005dULL,
0x0001506000070101ULL, 0x00018b380000005dULL, 0x000151d000070109ULL, 0x00018b380000005dULL,
0x00016fc000070109ULL, 0x00018b88000000ffULL, 0x0001709000070101ULL, 0x00018b80000000ffULL,
0x0001720000070109ULL, 0x00018b80000000ffULL, 0x0001723000070109ULL, 0x00018b88000000ffULL,
0x000173a000070109ULL, 0x00018b88000000ffULL, 0x00017e1000070109ULL, 0x00018b88000000ffULL,
0x00017e4000070101ULL, 0x00018b88000000ffULL, 0x00017fb000070109ULL, 0x00018b88000000ffULL,
0x0001817000070109ULL, 0x00000000000000ffULL, 0x000181a000080107ULL, 0x00018b78000000ffULL,
0x00019ac000070101ULL, 0x00018b88000000ffULL, 0x00019b0000070101ULL, 0x00018b70000000ffULL,
0x0001a6a000070101ULL, 0x00018ad0000000ffULL, 0x0001cbd000070101ULL, 0x00018ad0000000ffULL,
0x0001cd4000070109ULL, 0x00018ad0000000ffULL, 0x0001d0a000070109ULL, 0x00018ad0000000ffULL,
0x0001d0d000070101ULL, 0x00018ad0000000ffULL, 0x0001d24000070109ULL, 0x00018ad0000000ffULL,
0x000216a000070109ULL, 0x00018b5800000003ULL, 0x00021880003f0101ULL, 0x00018b5800000003ULL,
0x000219f0003f0109ULL, 0x00018b5800000003ULL, 0x00022cf0003f0109ULL, 0x00018ad800000004ULL,
0x00022d00003f0101ULL, 0x00018ae000000004ULL, 0x00022d10003f0101ULL, 0x00018ae800000004ULL,
0x00022d20003f0101ULL, 0x00018af000000004ULL, 0x00053803003f0101ULL, 0x0001a4d000101c04ULL,
0x0001d3400001d270ULL, 0x000c050400022d40ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL,
0x0068190300000000ULL, 0x0000001700080a04ULL, 0x0000000000680210ULL, 0x00000000000000bcULL,
0x0000001600000002ULL, 0x0000000000022d50ULL, 0x0000000000000044ULL, 0x0000001600000002ULL,
0x0000000000000000ULL, 0x0000000000000098ULL, 0x0000001600000002ULL, 0x0000000000000000ULL,
0x0000000000018c00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e620000000800ULL, 0x00000000000e7919ULL, 0x000ea20000002300ULL,
0x0000010000047ab9ULL, 0x000fcc0000000800ULL, 0x00008800ff067b82ULL, 0x000ee20000000a00ULL,
0x0000021000007945ULL, 0x000fe20003800000ULL, 0x0000000000037919ULL, 0x000ea20000002200ULL,
0x0000000000617919ULL, 0x000f220000002100ULL, 0x0000000000027919ULL, 0x000ee20000000000ULL,
0x0000000000137919ULL, 0x000ee20000002700ULL, 0x000000040e007c24ULL, 0x004fe2000f8e0203ULL,
0x0000000000047ab9ULL, 0x000fe20000000800ULL, 0x00001fff0e0e7589ULL, 0x000fe400000e0000ULL,
0x0000000400037c24ULL, 0x110fe2000f8e0261ULL, 0x00000005ff617819ULL, 0x000fe20000011661ULL,
0x0000000000007919ULL, 0x000ee60000002600ULL, 0x0000007f0300780cULL, 0x000fc40003f64070ULL,
0x00001fff61617589ULL, 0x000ea200000e0000ULL, 0x000000ff0300720cULL, 0x040fe40003f45270ULL,
0x0000000f0300780cULL, 0x040fe40003f04070ULL, 0x000000030300780cULL, 0x040fe40003fa4070ULL,
0x000000010300780cULL, 0x000fc80003f84070ULL, 0x000000000005b919ULL, 0x000f220000008800ULL,
0x000004000004b802ULL, 0x000fe20000000f00ULL, 0xff317217ff09b424ULL, 0x000fc600078e00ffULL,
0x000006540504b816ULL, 0x012fe20000000004ULL, 0x000000040e057824ULL, 0x004fc800078e0261ULL,
0x000000040304b824ULL, 0x000fe200078e0204ULL, 0x0000000000242947ULL, 0x008fec0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000067882ULL, 0x000fe20000000000ULL, 0x7ffc000000077882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000e740000000000ULL, 0x018ad006043f75b2ULL, 0x0002640008000100ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000380947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x0000000403087c11ULL, 0x000fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000080612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x018ad804063f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000385947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffb000000057882ULL, 0x000fc60000000000ULL,
0x0000000403087c11ULL, 0x000fe2000f8e18ffULL, 0x001ffec000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000080612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x018b5804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x018400090400b388ULL, 0x0003e20000000800ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ff8000000057882ULL, 0x000fc60000000000ULL,
0x0000000403037c11ULL, 0x000fe2000f8e18ffULL, 0x001ffe0000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x002fca0000000000ULL, 0x00000000030612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x018b7804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000b000007945ULL, 0x000fe80003800000ULL, 0x0000000000242947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000ea20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000067882ULL, 0x000fe20000000000ULL, 0x7ffc000000077882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x004fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000eb40000000000ULL, 0x018b8806043f75b2ULL, 0x0004a40008000100ULL,
0x0000000000007918ULL, 0x004fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000ea20000008800ULL, 0x0000840000067ab9ULL, 0x000fe20000000800ULL,
0x0000000205057824ULL, 0x000fe200078e00ffULL, 0x0000000206047899ULL, 0x000fe2000800063fULL,
0x0000001002107824ULL, 0x000fe200078e00ffULL, 0x00008200000a7ab9ULL, 0x000fe20000000a00ULL,
0x00000001050c7836ULL, 0x000fe20000000000ULL, 0x0000000405047848ULL, 0x002fe20007fe0000ULL,
0x0000000105087824ULL, 0x000fe200078e0202ULL, 0x000001f0100f7812ULL, 0x000fe200078ec0ffULL,
0x0000000413037c24ULL, 0x000fe2000f8e0200ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x00000020050d7824ULL, 0x000fc400078e00ffULL, 0x0000000104097824ULL, 0x000fe400078e0a05ULL,
0x0000000605057c24ULL, 0x100fe4000f8e0203ULL, 0x000000060c0b7c24ULL, 0x040fe2000f8e0203ULL,
0xffffffe00d037812ULL, 0x000fe200078ee208ULL, 0x0000020005047825ULL, 0x100fe200078e0006ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000002000b067825ULL, 0x000fe200078e0006ULL,
0x000000ff0900720cULL, 0x040fe20003f03070ULL, 0x0000065405077896ULL, 0x004fe20008000004ULL,
0x000000010900780cULL, 0x000fe20003f23070ULL, 0x000000010c0d7824ULL, 0x040fe200078e0202ULL,
0x0000000f04087210ULL, 0x000fe20007f5e0ffULL, 0x000000200c0c7824ULL, 0x000fe200078e00ffULL,
0x0000000f06067210ULL, 0x000fe20007f7e0ffULL, 0x00018ad007047890ULL, 0x000fc4000fffe03fULL,
0x0000000703037c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff097224ULL, 0x000fe200010e0605ULL,
0xffffffe00c0d7812ULL, 0x000fe200078ee20dULL, 0x000000ffff077224ULL, 0x000fe200018e0607ULL,
0x00008e00ff0a7b82ULL, 0x000e620000000a00ULL, 0x00000004135c7824ULL, 0x000fe200078e00ffULL,
0x000000070d0f7c11ULL, 0x000fe2000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008037faeULL, 0x000fe8000c101c4aULL, 0x00000000060f7faeULL, 0x0005e2000c901c4aULL,
0x00009600ff0c7b82ULL, 0x000ee20000000a00ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000ffffff79a7ULL, 0x000fe20008200404ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a84ULL,
0x000000045c047825ULL, 0x002fe200078e000aULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x0000000a04047981ULL, 0x000f22000c1e1900ULL, 0x000000045c067825ULL, 0x00cfcc00078e000cULL,
0x0000000a06067981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0e00720cULL, 0x000fe40003f05270ULL,
0x00000000040972caULL, 0x010fe400000e0000ULL, 0x00000008ff5f7819ULL, 0x004fd60000011606ULL,
0x0000007f09047890ULL, 0x000fe4000fffe03fULL, 0x000000ff09087890ULL, 0x000fe4000fffe03fULL,
0x000000073f057899ULL, 0x000fe40008011604ULL, 0x000000083f0c7899ULL, 0x000fe20008011608ULL,
0x0000019800bc8947ULL, 0x000ff60003800000ULL, 0x0000002061067824ULL, 0x040fe400078e0202ULL,
0x00000008615d7824ULL, 0x000fc600078e00ffULL, 0x000000030600780cULL, 0x040fe40003f44070ULL,
0x0000001f0600780cULL, 0x000fd60003f04070ULL, 0x00009000ff08ab82ULL, 0x000e620000000800ULL,
0x000000041307a824ULL, 0x000fe200078e0206ULL, 0x0000000906008c0cULL, 0x000fe4000bf26070ULL,
0x00000005ff00ac0cULL, 0x000fe2000bf65270ULL, 0x000000020707a824ULL, 0x000fc600078e00ffULL,
0x00009400ff0b8b82ULL, 0x000eb00000000800ULL, 0x00008c00ff04ab82ULL, 0x000ef00000000a00ULL,
0x00009200ff028b82ULL, 0x000f220000000a00ULL, 0x000000080709a224ULL, 0x002fc400078e0208ULL,
0x00000004ff087424ULL, 0x000fe400078e00ffULL, 0x0000000b5c078224ULL, 0x004fe200078e0206ULL,
0x00000007060bac11ULL, 0x040fe2000f8e10ffULL, 0x000000040904a825ULL, 0x008fe200078e0004ULL,
0x0000000706098c11ULL, 0x000fc6000f8e10ffULL, 0x00000001ff067424ULL, 0x000fe400078e00ffULL,
0x0000000407028825ULL, 0x010fca00078e0002ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x18a0000002098faeULL, 0x0003e2000c92184aULL, 0x018b58085dff79a7ULL, 0x0005e60008500007ULL,
0x18ac0000040bafaeULL, 0x0007e8000992184aULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000080000000791aULL, 0x000fc80000000000ULL, 0x018b8806ff0679a7ULL, 0x000ea40008500007ULL,
0x000000ffff087224ULL, 0x004fe200078e0007ULL, 0x0000000000027805ULL, 0x002fc60000015200ULL,
0x018b8808ff0075a7ULL, 0x000e640008000147ULL, 0x00000000005c0947ULL, 0x00afea0003800000ULL,
0x000000ffff067224ULL, 0x000fce00078e00ffULL, 0x000000100600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fcc0000015200ULL,
0x0000000402077210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e03ULL,
0x003d09000700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc80000011405ULL, 0x0000000704047211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000204047819ULL, 0x000fc80000001205ULL,
0x000000040000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000106067836ULL, 0x000fce0000000000ULL, 0x018b8808ff0075a7ULL, 0x000e640008000147ULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000001ff0800788cULL, 0x000fe2000bf04070ULL,
0x00000080005b7824ULL, 0x000fe200078e00ffULL, 0x0000840000047ab9ULL, 0x000fe40000000800ULL,
0x0000000704047899ULL, 0x000fe4000800063fULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000400540947ULL, 0x000fea0003800000ULL, 0x0000000000117919ULL, 0x000e620000000000ULL,
0x00008a00ff067b82ULL, 0x000ea20000000a00ULL, 0x0001400007067890ULL, 0x000fe2000fffe03fULL,
0x00000004ff087819ULL, 0x002fe20000011611ULL, 0x00000010110f7824ULL, 0x000fc800078e00ffULL,
0x000000015d047824ULL, 0x000fe200078e0208ULL, 0x000000f00f0f7812ULL, 0x000fc600078ec0ffULL,
0x000000015b037824ULL, 0x000fe200078e0204ULL, 0x0000000704097c11ULL, 0x040fe2000f8e10ffULL,
0x0000000104057824ULL, 0x000fc800078e0211ULL, 0x018a000009007984ULL, 0x000e640000000800ULL,
0x00000007000a7c11ULL, 0x002fe4000f8e10ffULL, 0x000000095d007c48ULL, 0x000fc6000ffe0000ULL,
0x018ac0000a027984ULL, 0x0002e40000000800ULL, 0x0000000100007824ULL, 0x000fca00078e0a5dULL,
0x000000000800720cULL, 0x000fe20003f06070ULL, 0x00000010040a7824ULL, 0x002fe400078e00ffULL,
0x0000000402037c24ULL, 0x008fc8000f8e0203ULL, 0x0000010003027825ULL, 0x004fc600078e0006ULL,
0x0000000f02047210ULL, 0x000fe40007f3e0ffULL, 0xfffffff00a027812ULL, 0x000fc600078ee205ULL,
0x000000ffff057224ULL, 0x000fe200008e0603ULL, 0x00000006020b7c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040b7faeULL, 0x0003e8000c101c4aULL,
0x018a080009027984ULL, 0x000ea40000000800ULL, 0x00000007020d7c11ULL, 0x004fe2000f8e10ffULL,
0x0000000208027836ULL, 0x000fc80000000000ULL, 0x018ac0000d037984ULL, 0x000ea20000000800ULL,
0x000000015d0a7824ULL, 0x000fe200078e0202ULL, 0x000000000200720cULL, 0x000fc60003f06070ULL,
0x000000015b0c7824ULL, 0x000fe400078e020aULL, 0x000000100a057824ULL, 0x042fe400078e00ffULL,
0x0000000403037c24ULL, 0x004fe4000f8e020cULL, 0x000000010a0c7824ULL, 0x000fe400078e0211ULL,
0x0000010003027825ULL, 0x000fc600078e0006ULL, 0xfffffff0050c7812ULL, 0x000fe400078ee20cULL,
0x0000000f02047210ULL, 0x000fe40007f3e0ffULL, 0x000000060c0b7c11ULL, 0x000fc6000f8e20ffULL,
0x000000ffff057224ULL, 0x000fca00008e0603ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040b7faeULL, 0x0003e8000c101c4aULL, 0x018a100009027984ULL, 0x000ea40000000800ULL,
0x00000007020d7c11ULL, 0x004fe2000f8e10ffULL, 0x0000000408027836ULL, 0x000fe40000000000ULL,
0x0000000608087836ULL, 0x000fe40000000000ULL, 0x018ac0000d037984ULL, 0x000ea20000000800ULL,
0x000000015d0a7824ULL, 0x000fe200078e0202ULL, 0x000000000200720cULL, 0x000fc60003f06070ULL,
0x000000015b0c7824ULL, 0x000fe400078e020aULL, 0x000000100a057824ULL, 0x042fe400078e00ffULL,
0x0000000403037c24ULL, 0x004fe4000f8e020cULL, 0x000000010a0c7824ULL, 0x000fe400078e0211ULL,
0x0000010003027825ULL, 0x000fc600078e0006ULL, 0xfffffff0050c7812ULL, 0x000fe200078ee20cULL,
0x000000015d0a7824ULL, 0x000fe200078e0208ULL, 0x0000000f02047210ULL, 0x000fe40007f3e0ffULL,
0x000000060c0b7c11ULL, 0x000fc6000f8e20ffULL, 0x000000ffff057224ULL, 0x000fe400008e0603ULL,
0x000000015b037824ULL, 0x000fc600078e020aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040b7faeULL, 0x0003e2000c101c4aULL, 0x000000000800720cULL, 0x000fe20003f06070ULL,
0x000000010a007824ULL, 0x040fe400078e0211ULL, 0x018a180009097984ULL, 0x000ea20000000800ULL,
0x000000100a057824ULL, 0x002fca00078e00ffULL, 0xfffffff005007812ULL, 0x000fc800078ee200ULL,
0x0000000600057c11ULL, 0x000fe4000f8e20ffULL, 0x00000007090c7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0000c027984ULL, 0x000e640000000800ULL, 0x0000000402037c24ULL, 0x002fc8000f8e0203ULL,
0x0000010003027825ULL, 0x000fc600078e0006ULL, 0x0000000f02027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e0603ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002057faeULL, 0x0003e2000c101c4aULL, 0x0000000400287947ULL, 0x000fea0003800000ULL,
0x00000000000d7919ULL, 0x000e620000000000ULL, 0x00008a00ff087b82ULL, 0x000ea20000000a00ULL,
0x0001400007067890ULL, 0x000fe2000fffe03fULL, 0x0000005d0d007211ULL, 0x042fe200078fe0ffULL,
0x000000100d047824ULL, 0x000fc600078e00ffULL, 0x00000007000a7c11ULL, 0x000fe2000f8e10ffULL,
0x000000015b037824ULL, 0x000fe200078e0200ULL, 0x000000f0040f7812ULL, 0x000fe200078ec0ffULL,
0x0000000100057824ULL, 0x040fe400078e020dULL, 0x018a00000a027984ULL, 0x000e620000000800ULL,
0x00000010000c7824ULL, 0x000fe200078e00ffULL, 0x0000000702067c11ULL, 0x002fca000f8e10ffULL,
0x018ac00006027984ULL, 0x0002e40000000800ULL, 0x0000000200067836ULL, 0x002fc80000000000ULL,
0x0000000106077824ULL, 0x040fe400078e020dULL, 0x00000010060e7824ULL, 0x000fe400078e00ffULL,
0x0000000402037c24ULL, 0x008fc8000f8e0203ULL, 0x0000010003027825ULL, 0x004fc600078e0008ULL,
0x0000000f02047210ULL, 0x000fe40007f1e0ffULL, 0xfffffff00c027812ULL, 0x000fc600078ee205ULL,
0x000000ffff057224ULL, 0x000fe200000e0603ULL, 0x00000006020b7c11ULL, 0x000fe2000f8e20ffULL,
0x000000015b037824ULL, 0x000fc800078e0206ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040b7faeULL, 0x0003e8000b901c4aULL, 0x018a08000a027984ULL, 0x000ea20000000800ULL,
0x0000000400047836ULL, 0x002fe40000000000ULL, 0x0000000600007836ULL, 0x000fe40000000000ULL,
0x0000000104057824ULL, 0x000fe200078e020dULL, 0x00000007020c7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0000c027984ULL, 0x000e640000000800ULL, 0x0000000402037c24ULL, 0x002fc8000f8e0203ULL,
0x0000010003027825ULL, 0x000fc600078e0008ULL, 0x0000000f02067210ULL, 0x000fe40007f1e0ffULL,
0xfffffff00e027812ULL, 0x000fe200078ee207ULL, 0x00000010040e7824ULL, 0x000fe400078e00ffULL,
0x000000ffff077224ULL, 0x000fe200000e0603ULL, 0x00000006020b7c11ULL, 0x000fe2000f8e20ffULL,
0x000000015b037824ULL, 0x000fc800078e0204ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000060b7faeULL, 0x0003e8000b901c4aULL, 0x018a10000a027984ULL, 0x000ea20000000800ULL,
0x0000000100067824ULL, 0x002fe200078e020dULL, 0x00000007020c7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0000c027984ULL, 0x000e640000000800ULL, 0x0000000402037c24ULL, 0x002fc8000f8e0203ULL,
0x0000010003027825ULL, 0x000fc600078e0008ULL, 0x0000000f02047210ULL, 0x000fe40007f1e0ffULL,
0xfffffff00e027812ULL, 0x000fc600078ee205ULL, 0x000000ffff057224ULL, 0x000fe200000e0603ULL,
0x0000000602077c11ULL, 0x000fe2000f8e20ffULL, 0x000000015b037824ULL, 0x000fc800078e0200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004077faeULL, 0x0003e8000b901c4aULL,
0x018a18000a0a7984ULL, 0x000ea40000000800ULL, 0x000000070a0b7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0000b027984ULL, 0x000ea40000000800ULL, 0x0000000402037c24ULL, 0x004fc8000f8e0203ULL,
0x0000010003027825ULL, 0x000fc800078e0008ULL, 0x0000001000097824ULL, 0x000fe200078e00ffULL,
0x0000000f02027210ULL, 0x000fc80007f1e0ffULL, 0xfffffff009067812ULL, 0x000fe200078ee206ULL,
0x000000ffff037224ULL, 0x000fc600000e0603ULL, 0x0000000606057c11ULL, 0x002fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002057faeULL, 0x0003e4000b901c4aULL,
0x00000001ff027424ULL, 0x002fcc00078e00ffULL, 0x018b8802ff0279a7ULL, 0x000e640008500007ULL,
0x000000ffff067224ULL, 0x002fe200078e0003ULL, 0x0000000000027805ULL, 0x000fc60000015200ULL,
0x018b8806ff0075a7ULL, 0x000e640008000147ULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff087224ULL, 0x000fce00078e00ffULL, 0x000000100800780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fcc0000015200ULL,
0x0000000402077210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e03ULL,
0x003d09000700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011405ULL, 0x0000000700007211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000200007819ULL, 0x000fc80000001205ULL,
0x000000000000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000108087836ULL, 0x000fce0000000000ULL, 0x018b8806ff0075a7ULL, 0x000e640008000147ULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000000127919ULL, 0x000e620000000000ULL,
0x00018b7807087890ULL, 0x000fe2000fffe03fULL, 0x0000011000007945ULL, 0x000fe20003800000ULL,
0x00000001ff047424ULL, 0x000fe400078e00ffULL, 0x0000002061077824ULL, 0x002fca00078e0212ULL,
0x0000001f0700780cULL, 0x000fda0003f04070ULL, 0x0000000000300947ULL, 0x000fea0003800000ULL,
0x00009200ff027b82ULL, 0x000e620000000a00ULL, 0x0000002007007836ULL, 0x000fe20000000000ULL,
0x0000940000047ab9ULL, 0x000fe40000000800ULL, 0x000000045c057c24ULL, 0x000fe2000f8e0207ULL,
0x0000000707077c11ULL, 0x000fe4000f8e10ffULL, 0x0000000900007c0cULL, 0x000fe2000bf06070ULL,
0x0000002005057836ULL, 0x000fc80000000000ULL, 0x0000000405027825ULL, 0x002fd000078e0002ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18a0000002077faeULL, 0x0003e4000c12184aULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a48ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000cff007c0cULL, 0x000fe2000bf05270ULL, 0x018b7804ff0279a7ULL, 0x0026a20008500007ULL,
0x000000ffff5a7224ULL, 0x000fe200078e00ffULL, 0x0000000000587805ULL, 0x000fe4000001ff00ULL,
0x0000000000567805ULL, 0x000fe4000001ff00ULL, 0x0000000000547805ULL, 0x000fc4000001ff00ULL,
0x0000000000527805ULL, 0x000fe4000001ff00ULL, 0x00000000004e7805ULL, 0x000fe4000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x018b8804ff0479a7ULL, 0x008e620008500007ULL,
0x00000000004a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000487805ULL, 0x000fe4000001ff00ULL,
0x0000000000467805ULL, 0x000fc4000001ff00ULL, 0x0000000000447805ULL, 0x000fe4000001ff00ULL,
0x0000000000427805ULL, 0x000fe4000001ff00ULL, 0x0000000000407805ULL, 0x000fe4000001ff00ULL,
0x0000000000107805ULL, 0x000fe4000001ff00ULL, 0x00000000000e7805ULL, 0x000fe4000001ff00ULL,
0x00000000000c7805ULL, 0x000fc4000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000017c00bc8947ULL, 0x002fec0003800000ULL, 0x0000840000047ab9ULL, 0x000fe20000000800ULL,
0x000000ffff157224ULL, 0x004fe200078e0003ULL, 0x0000000704067899ULL, 0x000fe2000800063fULL,
0x000000ffff1c7224ULL, 0x002fe400078e0005ULL, 0xff317217ff097424ULL, 0x000fe200078e00ffULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x000000ffff5a7224ULL, 0x000fe400078e00ffULL,
0x000000ffff087224ULL, 0x000fce00078e00ffULL, 0x0000010008007824ULL, 0x000fca00078e00ffULL,
0x0000000900007c0cULL, 0x000fda000bf06070ULL, 0x0000017c00840947ULL, 0x006fea0003800000ULL,
0x000000ffff6b7224ULL, 0x000fce00078e00ffULL, 0x000000085f00720cULL, 0x000fe40003f04070ULL,
0x00000002ff007819ULL, 0x000fe4000001166bULL, 0x000000036b027812ULL, 0x040fe400078ec0ffULL,
0x000000006b057207ULL, 0x000fe40000000000ULL, 0x000000ff02027207ULL, 0x000fe40004000000ULL,
0x0000000305177812ULL, 0x000fc400078ec0ffULL, 0x0000000805007211ULL, 0x004fe400078ff0ffULL,
0x0000000000187805ULL, 0x000fe20000015200ULL, 0x018b7815ff0075a7ULL, 0x000e640008020147ULL,
0x00000000005c1947ULL, 0x002fea0003800000ULL, 0x000000ffff167224ULL, 0x000fce00078e00ffULL,
0x000000101600780cULL, 0x000fda0003f26270ULL, 0x0000000000449947ULL, 0x000fea0003800000ULL,
0x00000000001a7805ULL, 0x000fcc0000015200ULL, 0x0000001a181d7210ULL, 0x000fca0007f3e1ffULL,
0x000000011b1b7824ULL, 0x000fe200008e0e19ULL, 0x003d09001d00780cULL, 0x000fc80003f26070ULL,
0x000000ff1b00720cULL, 0x000fda0003f26310ULL, 0x0000000000089947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401d00780cULL, 0x000fc80003f26070ULL, 0x000000ff1b00720cULL, 0x000fda0003f26310ULL,
0x00000000001c9947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc8000001141bULL,
0x0000001d14147211ULL, 0x000fca00078310ffULL, 0x000000ffff1b7224ULL, 0x000fca00008e061bULL,
0x0000000214147819ULL, 0x000fc8000000121bULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000116167836ULL, 0x000fce0000000000ULL,
0x018b7815ff0075a7ULL, 0x000e640008020147ULL, 0xfffffffc00a89947ULL, 0x002fea000383ffffULL,
0x0000000000147805ULL, 0x000fe20000015200ULL, 0x018b881cff0075a7ULL, 0x000e640008020147ULL,
0x00000000005c1947ULL, 0x002fea0003800000ULL, 0x000000ffff1a7224ULL, 0x000fce00078e00ffULL,
0x000000101a00780cULL, 0x000fda0003f26270ULL, 0x0000000000449947ULL, 0x000fea0003800000ULL,
0x0000000000187805ULL, 0x000fcc0000015200ULL, 0x00000018141b7210ULL, 0x000fca0007f3e1ffULL,
0x0000000119197824ULL, 0x000fe200008e0e15ULL, 0x003d09001b00780cULL, 0x000fc80003f26070ULL,
0x000000ff1900720cULL, 0x000fda0003f26310ULL, 0x0000000000089947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401b00780cULL, 0x000fc80003f26070ULL, 0x000000ff1900720cULL, 0x000fda0003f26310ULL,
0x00000000001c9947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011419ULL,
0x0000001b16167211ULL, 0x000fca00078310ffULL, 0x000000ffff197224ULL, 0x000fca00008e0619ULL,
0x0000000216167819ULL, 0x000fc80000001219ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011a1a7836ULL, 0x000fce0000000000ULL,
0x018b881cff0075a7ULL, 0x000e640008020147ULL, 0xfffffffc00a89947ULL, 0x002fea000383ffffULL,
0x0000000100157836ULL, 0x000fe40000000000ULL, 0x0000000400147824ULL, 0x000fc600078e0217ULL,
0x0000000c15007c0cULL, 0x000fe4000bf26070ULL, 0x00000020141a7811ULL, 0x000fc800078e30ffULL,
0x000000605b167812ULL, 0x000fce00078ef81aULL, 0x0000000400589947ULL, 0x000fea0003800000ULL,
0x00000004ff1f7819ULL, 0x000fe20000011612ULL, 0x00000010121c7824ULL, 0x000fe200078e00ffULL,
0x000000091a187c48ULL, 0x000fe2000ffe0000ULL, 0x00016000070d7890ULL, 0x000fe4000fffe03fULL,
0x000000015d1d7824ULL, 0x000fe200078e021fULL, 0x000000f01c217812ULL, 0x000fe200078ec0ffULL,
0x0000000118187824ULL, 0x000fe400078e0a1aULL, 0x000000011d1a7824ULL, 0x040fe200078e0216ULL,
0x000000071d207c11ULL, 0x040fe2000f8e10ffULL, 0x000000011d1e7824ULL, 0x040fe200078e0212ULL,
0x000000185d187248ULL, 0x000fe20007fe0000ULL, 0x000000101d1d7824ULL, 0x000fc400078e00ffULL,
0x018a000020147984ULL, 0x000e620000000800ULL, 0x000000021f227836ULL, 0x000fe40000000000ULL,
0x00000001181c7824ULL, 0x000fe200078e0a5dULL, 0xfffffff01d1d7812ULL, 0x000fe200078ee21eULL,
0x000000015d237824ULL, 0x000fc600078e0222ULL, 0x0000001c1f00720cULL, 0x000fe20003f26070ULL,
0x0000000123247824ULL, 0x000fe200078e0212ULL, 0x0000000d1d1d7c11ULL, 0x000fe4000f8e20ffULL,
0x00000007141b7c11ULL, 0x002fe4000f8e10ffULL, 0x00008a00ff147b82ULL, 0x000e660000000a00ULL,
0x018ac0001b197984ULL, 0x000ea40000000800ULL, 0x0000000619197c24ULL, 0x004fc8000f8e021aULL,
0x0000010019187825ULL, 0x002fc600078e0014ULL, 0x00000021181a7210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff1b7224ULL, 0x000fe400010e0619ULL, 0x0000000123197824ULL, 0x000fc600078e0216ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a1d7faeULL, 0x0003e2000c901c4aULL,
0x0000001c2200720cULL, 0x000fe20003f26070ULL, 0x000000041f227836ULL, 0x000fe40000000000ULL,
0x018a080020187984ULL, 0x000ea20000000800ULL, 0x000000061f1f7836ULL, 0x000fe40000000000ULL,
0x00000010231d7824ULL, 0x002fe400078e00ffULL, 0x000000015d237824ULL, 0x000fc600078e0222ULL,
0xfffffff01d1d7812ULL, 0x000fe200078ee224ULL, 0x0000000123247824ULL, 0x000fc600078e0212ULL,
0x0000000d1d1d7c11ULL, 0x000fe4000f8e20ffULL, 0x00000007181e7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001e187984ULL, 0x000e640000000800ULL, 0x0000000618197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x00000021181a7210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff1b7224ULL, 0x000fe400010e0619ULL, 0x0000000123197824ULL, 0x000fc600078e0216ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a1d7faeULL, 0x0003e2000c901c4aULL,
0x0000001c2200720cULL, 0x000fc60003f26070ULL, 0x018a100020187984ULL, 0x000ea20000000800ULL,
0x00000010231b7824ULL, 0x002fe400078e00ffULL, 0x000000015d237824ULL, 0x000fc600078e021fULL,
0xfffffff01b1b7812ULL, 0x000fe200078ee224ULL, 0x00000001231d7824ULL, 0x040fe400078e0216ULL,
0x0000000123167824ULL, 0x000fe200078e0212ULL, 0x0000000d1b1b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000001023237824ULL, 0x000fca00078e00ffULL, 0xfffffff023167812ULL, 0x000fe400078ee216ULL,
0x00000007181e7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0001e187984ULL, 0x000e640000000800ULL,
0x0000000618197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000002118187210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff197224ULL, 0x000fca00010e0619ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000181b7faeULL, 0x0003e2000c901c4aULL,
0x0000001c1f00720cULL, 0x000fc60003f26070ULL, 0x018a1800201a7984ULL, 0x000ea20000000800ULL,
0x0000000d16197c11ULL, 0x002fe4000f8e20ffULL, 0x000000071a1a7c11ULL, 0x004fcc000f8e10ffULL,
0x018ac0001a1a7984ULL, 0x000e640000000800ULL, 0x000000061a1d7c24ULL, 0x002fc8000f8e021dULL,
0x000001001d147825ULL, 0x000fc600078e0014ULL, 0x0000002114147210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff157224ULL, 0x000fca00010e0615ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014197faeULL, 0x0003e2000c901c4aULL, 0x0000000400247947ULL, 0x000fea0003800000ULL,
0x0000005d12217211ULL, 0x040fe200078fe0ffULL, 0x00000010121a7824ULL, 0x000fe200078e00ffULL,
0x00016000070d7890ULL, 0x000fe4000fffe03fULL, 0x0000000721207c11ULL, 0x040fe2000f8e10ffULL,
0x0000000121197824ULL, 0x040fe200078e0216ULL, 0x000000f01a237812ULL, 0x000fe200078ec0ffULL,
0x00000001211b7824ULL, 0x040fe400078e0212ULL, 0x018a000020147984ULL, 0x000e620000000800ULL,
0x00000010211e7824ULL, 0x000fc400078e00ffULL, 0x00000002211d7836ULL, 0x000fc60000000000ULL,
0xfffffff01e1f7812ULL, 0x000fe200078ee21bULL, 0x000000011d227824ULL, 0x000fc600078e0212ULL,
0x0000000d1f1f7c11ULL, 0x000fe4000f8e20ffULL, 0x00000007141c7c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e660000000a00ULL, 0x018ac0001c187984ULL, 0x000ea40000000800ULL,
0x0000000618197c24ULL, 0x004fc8000f8e0219ULL, 0x0000010019187825ULL, 0x002fc600078e0014ULL,
0x00000023181a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff1b7224ULL, 0x000fe400008e0619ULL,
0x000000011d197824ULL, 0x040fe400078e0216ULL, 0x000000101d1d7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a1f7faeULL, 0x0003e8000b901c4aULL,
0x018a080020187984ULL, 0x000ea20000000800ULL, 0xfffffff01d1b7812ULL, 0x002fe200078ee222ULL,
0x00000004211f7836ULL, 0x000fc40000000000ULL, 0x0000000621217836ULL, 0x000fe20000000000ULL,
0x0000000d1b1b7c11ULL, 0x000fe4000f8e20ffULL, 0x00000007181e7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001e187984ULL, 0x0002a40000000800ULL, 0x000000011f1e7824ULL, 0x002fe400078e0212ULL,
0x0000000618197c24ULL, 0x004fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x00000023181c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff1d7224ULL, 0x000fe400008e0619ULL,
0x000000011f197824ULL, 0x140fe400078e0216ULL, 0x000000101f1f7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c1b7faeULL, 0x0003e8000b901c4aULL,
0x018a100020187984ULL, 0x000ea20000000800ULL, 0xfffffff01f1b7812ULL, 0x002fe200078ee21eULL,
0x00000001211d7824ULL, 0x000fc400078e0216ULL, 0x0000000121167824ULL, 0x000fe200078e0212ULL,
0x0000000d1b1b7c11ULL, 0x000fe2000f8e20ffULL, 0x0000001021217824ULL, 0x000fca00078e00ffULL,
0xfffffff021167812ULL, 0x000fe400078ee216ULL, 0x00000007181a7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001a187984ULL, 0x000e640000000800ULL, 0x0000000618197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000002318187210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff197224ULL, 0x000fca00008e0619ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000181b7faeULL, 0x0003e8000b901c4aULL, 0x018a1800201a7984ULL, 0x000ea20000000800ULL,
0x0000000d16197c11ULL, 0x002fe4000f8e20ffULL, 0x000000071a1a7c11ULL, 0x004fcc000f8e10ffULL,
0x018ac0001a1a7984ULL, 0x000e640000000800ULL, 0x000000061a1d7c24ULL, 0x002fc8000f8e021dULL,
0x000001001d147825ULL, 0x000fc600078e0014ULL, 0x0000002314147210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff157224ULL, 0x000fca00008e0615ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014197faeULL, 0x0003e6000b901c4aULL, 0x00000001ff147424ULL, 0x002fcc00078e00ffULL,
0x018b8814ff1479a7ULL, 0x000e640008500007ULL, 0x000000ffff1a7224ULL, 0x002fe200078e0015ULL,
0x0000000000147805ULL, 0x000fc60000015200ULL, 0x018b881aff0075a7ULL, 0x000e640008020147ULL,
0x00000000005c1947ULL, 0x002fea0003800000ULL, 0x000000ffff1c7224ULL, 0x000fce00078e00ffULL,
0x000000101c00780cULL, 0x000fda0003f26270ULL, 0x0000000000449947ULL, 0x000fea0003800000ULL,
0x0000000000187805ULL, 0x000fcc0000015200ULL, 0x00000018141b7210ULL, 0x000fca0007f3e1ffULL,
0x0000000119197824ULL, 0x000fe200008e0e15ULL, 0x003d09001b00780cULL, 0x000fc80003f26070ULL,
0x000000ff1900720cULL, 0x000fda0003f26310ULL, 0x0000000000089947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401b00780cULL, 0x000fc80003f26070ULL, 0x000000ff1900720cULL, 0x000fda0003f26310ULL,
0x00000000001c9947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011419ULL,
0x0000001b16167211ULL, 0x000fca00078310ffULL, 0x000000ffff197224ULL, 0x000fca00008e0619ULL,
0x0000000216167819ULL, 0x000fc80000001219ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011c1c7836ULL, 0x000fce0000000000ULL,
0x018b881aff0075a7ULL, 0x000e640008020147ULL, 0xfffffffc00a89947ULL, 0x002fea000383ffffULL,
0x000000005f00720cULL, 0x0c0fe20003f64070ULL, 0x0000000102147836ULL, 0x000fe20000000000ULL,
0x000000005f00720cULL, 0x000fe20003f24070ULL, 0x00000020616e7824ULL, 0x000fe200078e0212ULL,
0x0000000105057812ULL, 0x000fe200078ec0ffULL, 0x00018b80070d7890ULL, 0x000fe2000fffe03fULL,
0x0000000314157812ULL, 0x000fe200078ec0ffULL, 0x00000001ff6c7424ULL, 0x000fe200078e00ffULL,
0x000000030200780cULL, 0x000fc80004f25270ULL, 0x000000010500780cULL, 0x000fe40000f45470ULL,
0x00000002ff14b819ULL, 0x000fe40000011614ULL, 0x0000001f6e00780cULL, 0x000fc60003f24070ULL,
0x0000000117177824ULL, 0x000fc800078e0214ULL, 0x0000004017027824ULL, 0x040fe200078e00ffULL,
0x0000000017007211ULL, 0x000fe400078ff0ffULL, 0x000000ff15177207ULL, 0x000fe40005800000ULL,
0x000000c002057812ULL, 0x000fca00078ec0ffULL, 0x0000010000197824ULL, 0x000fe200078e0205ULL,
0x0000000000502947ULL, 0x000fec0003800000ULL, 0x0000002061027824ULL, 0x000fe200078e0212ULL,
0x0000000104047890ULL, 0x000fe2000fffe03fULL, 0x0000011000007945ULL, 0x000fe60003800000ULL,
0x000000030200780cULL, 0x000fda0003f44070ULL, 0x0000000000382947ULL, 0x000fea0003800000ULL,
0x00009000ff167b82ULL, 0x000e620000000800ULL, 0x000000050400728cULL, 0x000fe2000bf06070ULL,
0x0000000413007824ULL, 0x000fe200078e0202ULL, 0x00000007021b7c11ULL, 0x000fc6000f8e10ffULL,
0x0000000200057824ULL, 0x000fe200078e00ffULL, 0x000000000000781cULL, 0x000fe20003f4f008ULL,
0x00008c00ff147b82ULL, 0x000ea20000000a00ULL, 0x0000000416007c36ULL, 0x002fc80008000000ULL,
0x0000001605057224ULL, 0x000fc800078e0200ULL, 0x0000000405147825ULL, 0x004fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18ac0000141b7faeULL, 0x0003e4000d12184aULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe80003800000ULL,
0x0000000000341947ULL, 0x000fea0003800000ULL, 0x00009400ff057b82ULL, 0x000ea20000000800ULL,
0x000000016e027824ULL, 0x000fe400078e0219ULL, 0x000000015c007824ULL, 0x000fe200078e0217ULL,
0x000000076e177c11ULL, 0x000fe4000f8e10ffULL, 0x0000000902007c0cULL, 0x000fe4000bf46070ULL,
0x00009200ff147b82ULL, 0x002e620000000a00ULL, 0x0000000500057224ULL, 0x004fc800078e0219ULL,
0x000000016e057824ULL, 0x000fc800078e0205ULL, 0x0000000405147825ULL, 0x002fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18a0000014177faeULL, 0x0003e4000d12184aULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a4dULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000ff6b00720cULL, 0x000fe20003f45270ULL, 0x018b806cff6479a7ULL, 0x0004d80008500007ULL,
0x0000000400942947ULL, 0x004fea0003800000ULL, 0x018ad86c5d1479a7ULL, 0x002e640008500007ULL,
0x000000ffff027224ULL, 0x002fce00078e0015ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x018ad8025d0075a7ULL, 0x000e640008040147ULL, 0x00000000005c2947ULL, 0x002fea0003800000ULL,
0x000000ffff077224ULL, 0x000fce00078e00ffULL, 0x000000100700780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614057210ULL, 0x000fca0007f5e1ffULL, 0x0000000117167824ULL, 0x000fe200010e0e15ULL,
0x003d09000500780cULL, 0x000fc80003f46070ULL, 0x000000ff1600720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400500780cULL, 0x000fc80003f46070ULL,
0x000000ff1600720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011416ULL, 0x0000000500007211ULL, 0x000fca00078510ffULL,
0x000000ffff057224ULL, 0x000fca00010e0616ULL, 0x0000000200007819ULL, 0x000fc80000001205ULL,
0x000000000000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000107077836ULL, 0x000fce0000000000ULL, 0x018ad8025d0075a7ULL, 0x000e640008040147ULL,
0xfffffffc00a8a947ULL, 0x002fea000383ffffULL, 0x0000001012007824ULL, 0x000fe200078e00ffULL,
0x00000001ff027819ULL, 0x000fe20000011612ULL, 0x00000001ff077424ULL, 0x000fc600078e00ffULL,
0x0000007000007812ULL, 0x000fe400078ec0ffULL, 0x0000000c02057812ULL, 0x000fc800078ec0ffULL,
0x0000000705007c10ULL, 0x000fca000fffe000ULL, 0x0180000000027984ULL, 0x000e680000000800ULL,
0x0182000000157984ULL, 0x0004a20000000800ULL, 0x000000090200720bULL, 0x002fda0003f5d000ULL,
0x0000000000057806ULL, 0x000fc800010e0100ULL, 0x0000ffff05167812ULL, 0x000fe2000784c0ffULL,
0x000000ffff057224ULL, 0x000fd800078e0009ULL, 0x0000000000e8a947ULL, 0x00cfea0003800000ULL,
0x000000090200720bULL, 0x000fe40003f54000ULL, 0x000000ff6100720cULL, 0x000fe40003f65270ULL,
0x0000000209057209ULL, 0x000fd20007810000ULL, 0x0000000000177806ULL, 0x000fe400010e0100ULL,
0x018400050000b388ULL, 0x0003e40000000800ULL, 0x0000991017147816ULL, 0x000fc800000000ffULL,
0x000000ff1400720cULL, 0x000fda0003f45270ULL, 0x0000000000b0a947ULL, 0x002fea0003800000ULL,
0x8000000509007221ULL, 0x000fe20000010000ULL, 0x000000ff17ff7812ULL, 0x040fe4000784c0ffULL,
0x0000ff0017ff7812ULL, 0x000fe2000786c0ffULL, 0x3fb8aa3b00007820ULL, 0x000fc80000410000ULL,
0x0000000000097308ULL, 0x0002ac0000000800ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x00000002ff007819ULL, 0x002fcc0000011612ULL, 0x00001f0009007589ULL, 0x004e6400000e0000ULL,
0x000000000b0b7220ULL, 0x082fe20000410000ULL, 0x000000000c0c7220ULL, 0x080fe20000410000ULL,
0x000000000f0f7220ULL, 0x080fe20000410000ULL, 0x0000000010107220ULL, 0x080fe20000410000ULL,
0x0000000041417220ULL, 0x080fe20000410000ULL, 0x0000000042427220ULL, 0x080fe20000410000ULL,
0x0000000045457220ULL, 0x080fe20000410000ULL, 0x0000000046467220ULL, 0x080fe20000410000ULL,
0x0000000049497220ULL, 0x080fe20000410000ULL, 0x000000004a4a7220ULL, 0x080fe20000410000ULL,
0x000000004d4d7220ULL, 0x080fe20000410000ULL, 0x000000004e4e7220ULL, 0x080fe20000410000ULL,
0x0000000053537220ULL, 0x080fe20000410000ULL, 0x0000000054547220ULL, 0x080fe20000410000ULL,
0x0000000057577220ULL, 0x080fe20000410000ULL, 0x0000000058587220ULL, 0x000fce0000410000ULL,
0x000000090a0a7220ULL, 0x004fe20000410000ULL, 0x000000000048b947ULL, 0x000fec0003800000ULL,
0x0000000812007811ULL, 0x002fcc00078ff0ffULL, 0x00001f0009007589ULL, 0x000e6400000e0000ULL,
0x000000000d0d7220ULL, 0x082fe20000410000ULL, 0x000000000e0e7220ULL, 0x080fe20000410000ULL,
0x0000000011117220ULL, 0x080fe20000410000ULL, 0x0000000040407220ULL, 0x080fe20000410000ULL,
0x0000000043437220ULL, 0x080fe20000410000ULL, 0x0000000044447220ULL, 0x080fe20000410000ULL,
0x0000000047477220ULL, 0x080fe20000410000ULL, 0x0000000048487220ULL, 0x080fe20000410000ULL,
0x000000004b4b7220ULL, 0x080fe20000410000ULL, 0x000000004c4c7220ULL, 0x080fe20000410000ULL,
0x000000004f4f7220ULL, 0x080fe20000410000ULL, 0x0000000052527220ULL, 0x080fe20000410000ULL,
0x0000000055557220ULL, 0x080fe20000410000ULL, 0x0000000056567220ULL, 0x080fe20000410000ULL,
0x0000000059597220ULL, 0x080fe20000410000ULL, 0x000000005a5a7220ULL, 0x000fce0000410000ULL,
0x0000ffff16ff7812ULL, 0x000fda0007846017ULL, 0x8000000502022221ULL, 0x000fe20000010000ULL,
0x00007610ff072816ULL, 0x000fc60000000007ULL, 0x3fb8aa3b02022820ULL, 0x000fc80000410000ULL,
0x0000000200062308ULL, 0x000ea40000000800ULL, 0x0000000615152220ULL, 0x004fce0000410000ULL,
0x0000000a150a7221ULL, 0x000fe20000010000ULL, 0x000000ffff097224ULL, 0x000fce00078e0005ULL,
0x0000000712677812ULL, 0x040fe400078ec0ffULL, 0x000000ff07ff7812ULL, 0x000fe4000786c0ffULL,
0x00000004ff667819ULL, 0x000fe40000011612ULL, 0x0000000867677812ULL, 0x000fe400078ef812ULL,
0x00000008126d7812ULL, 0x000fe200078ec0ffULL, 0x0000000461707824ULL, 0x000fe400078e0266ULL,
0x00000001666a7824ULL, 0x000fe200078e0267ULL, 0x000000076d6d7812ULL, 0x000fe200078ef812ULL,
0x0000000867057824ULL, 0x000fc800078e00ffULL, 0x000000016d027824ULL, 0x040fe200078e0270ULL,
0xfffffff805057812ULL, 0x000fe200078ee26aULL, 0x000000106d177824ULL, 0x002fc600078e00ffULL,
0x0000000705057c11ULL, 0x000fe2000f8e20ffULL, 0x0000000000183947ULL, 0x000fec0003800000ULL,
0x00000002ff037819ULL, 0x000fe40000011612ULL, 0x00000006ff00723eULL, 0x000fc600000010ffULL,
0x0000000803157836ULL, 0x000fe20000000000ULL, 0x0000541000007816ULL, 0x000fca0000000000ULL,
0x00001f0300037589ULL, 0x0002a800000e0000ULL, 0x00001f1500047589ULL, 0x0002e400000e0000ULL,
0x01200000051c783bULL, 0x0002e20000000200ULL, 0x0000000000103947ULL, 0x000fea0003800000ULL,
0x000000031c1c7232ULL, 0x08cfe40000200000ULL, 0x000000031e1e7232ULL, 0x000fe40000200000ULL,
0x000000041d1d7232ULL, 0x080fe40000200000ULL, 0x000000041f1f7232ULL, 0x000fce0000200000ULL,
0x0000000261397811ULL, 0x000fe200078e10ffULL, 0x00014000070e7890ULL, 0x000fe2000fffe03fULL,
0xfffffff017027812ULL, 0x000fe200078ee202ULL, 0x000000106d197824ULL, 0x040fe400078e00ffULL,
0x0000000166647824ULL, 0x008fe400078e0239ULL, 0x0000000e02027c11ULL, 0x000fe4000f8e20ffULL,
0x000000016d007824ULL, 0x002fc600078e0264ULL, 0x000000000214783bULL, 0x000e640000004200ULL,
0xfffffff019007812ULL, 0x000fc800078ee200ULL, 0x0000000e00007c11ULL, 0x000fca000f8e20ffULL,
0x000000000018783bULL, 0x000ee20000004200ULL, 0x00000018ff207819ULL, 0x102fe40000011614ULL,
0x0000ffff14367812ULL, 0x000fe400078ec0ffULL, 0x00000020ff20723eULL, 0x000fe400020006ffULL,
0x00000010ff357819ULL, 0x000fe40000011615ULL, 0x0000ffff15347812ULL, 0x000fe200078ec0ffULL,
0x20000020ff307230ULL, 0x000fe20000004100ULL, 0x00000010ff377819ULL, 0x000fc40000011614ULL,
0x000000ff18387812ULL, 0x008fe400078ec0ffULL, 0x0000ffff162b7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff367819ULL, 0x000fe40000011636ULL, 0x000000ff35357812ULL, 0x000fe400078ec0ffULL,
0x00000038ff20723eULL, 0x000fe400020006ffULL, 0x00000010ff337819ULL, 0x000fc40000011616ULL,
0x00000008ff387819ULL, 0x000fe20000011634ULL, 0x20000020ff207230ULL, 0x000fe20000004100ULL,
0x000000ff37377812ULL, 0x000fe400078ec0ffULL, 0x00000036ff36723eULL, 0x000fe400020006ffULL,
0x00000008ff2b7819ULL, 0x000fe4000001162bULL, 0x00000035ff35723eULL, 0x000fe400020006ffULL,
0x00000010ff2d7819ULL, 0x000fc40000011617ULL, 0x00000038ff38723eULL, 0x000fe400020006ffULL,
0x000000ff33337812ULL, 0x000fe400078ec0ffULL, 0x0000ffff172e7812ULL, 0x000fe400078ec0ffULL,
0x00000037ff34723eULL, 0x000fe200020006ffULL, 0x20000036ff377230ULL, 0x000fe20000004100ULL,
0x0000002bff2b723eULL, 0x000fe200020006ffULL, 0x20000035ff367230ULL, 0x000fe20000004100ULL,
0x00000010ff237819ULL, 0x000fe20000011619ULL, 0x20000034ff347230ULL, 0x000fe20000004100ULL,
0x00000033ff35723eULL, 0x000fe200020006ffULL, 0x20000038ff337230ULL, 0x000fe20000004100ULL,
0x000000ff2d2d7812ULL, 0x000fe200078ec0ffULL, 0x2000002bff387230ULL, 0x000fe20000004100ULL,
0x0000ffff192c7812ULL, 0x000fe200078ec0ffULL, 0x20000035ff357230ULL, 0x000fe20000004100ULL,
0x00000008ff2e7819ULL, 0x000fc4000001162eULL, 0x000000ff193a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff232b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff15247812ULL, 0x000fe400078ec0ffULL,
0x0000ffff18327812ULL, 0x000fe400078ec0ffULL, 0x0000002dff2d723eULL, 0x000fe400020006ffULL,
0x00000010ff287819ULL, 0x000fc4000001161aULL, 0x000000ff1a3c7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff3b7819ULL, 0x000fe4000001161aULL, 0x0000ffff1a297812ULL, 0x000fe400078ec0ffULL,
0x00000010ff2a7819ULL, 0x000fe4000001161bULL, 0x0000002eff2e723eULL, 0x000fe400020006ffULL,
0x00000008ff2c7819ULL, 0x000fc4000001162cULL, 0x000000ff14217812ULL, 0x000fe400078ec0ffULL,
0x000000ff1b3e7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001161bULL,
0x0000ffff1b1a7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff147819ULL, 0x000fe40000011615ULL,
0x00000010ff2f7819ULL, 0x000fc40000011618ULL, 0x0000003aff1b723eULL, 0x000fe400020006ffULL,
0x0000002bff2b723eULL, 0x000fe400020006ffULL, 0x000000ff16257812ULL, 0x000fe200078ec0ffULL,
0x2000001bff1b7230ULL, 0x000fe20000004100ULL, 0x00000018ff157819ULL, 0x000fe40000011616ULL,
0x00000024ff24723eULL, 0x000fe400020006ffULL, 0x00000008ff3a7819ULL, 0x000fe20000011632ULL,
0x2000002dff327230ULL, 0x000fe20000004100ULL, 0x000000ff17267812ULL, 0x000fe200078ec0ffULL,
0x2000002eff2d7230ULL, 0x000fe20000004100ULL, 0x00000018ff167819ULL, 0x000fe20000011617ULL,
0x20000024ff317230ULL, 0x000fe20000004100ULL, 0x0000002cff2c723eULL, 0x000fc400020006ffULL,
0x000000ff2a2a7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff177819ULL, 0x000fe40000011618ULL,
0x000000ff2f2f7812ULL, 0x000fe400078ec0ffULL, 0x000000ff282e7812ULL, 0x000fe200078ec0ffULL,
0x2000002bff287230ULL, 0x000fe20000004100ULL, 0x00000021ff21723eULL, 0x000fe400020006ffULL,
0x00000026ff26723eULL, 0x000fc400020006ffULL, 0x0000002aff2b723eULL, 0x000fe200020006ffULL,
0x2000002cff2a7230ULL, 0x000fe20000004100ULL, 0x00000025ff25723eULL, 0x000fe200020006ffULL,
0x20000021ff227230ULL, 0x000fe20000004100ULL, 0x00000017ff17723eULL, 0x000fe200020006ffULL,
0x20000026ff267230ULL, 0x000fe20000004100ULL, 0x00000014ff14723eULL, 0x000fe200020006ffULL,
0x20000025ff277230ULL, 0x000fe20000004100ULL, 0x00000015ff15723eULL, 0x000fe200020006ffULL,
0x2000002bff2b7230ULL, 0x000fe20000004100ULL, 0x0000002fff2f723eULL, 0x000fe200020006ffULL,
0x20000014ff247230ULL, 0x000fe20000004100ULL, 0x00000008ff2c7819ULL, 0x000fe2000001161aULL,
0x20000015ff257230ULL, 0x000fe20000004100ULL, 0x00000018ff187819ULL, 0x000fe20000011619ULL,
0x20000017ff197230ULL, 0x000fe20000004100ULL, 0x00000016ff16723eULL, 0x000fe200020006ffULL,
0x2000002fff2f7230ULL, 0x000fe20000004100ULL, 0x00000010ff317819ULL, 0x000fc40000011631ULL,
0x00000010ff367819ULL, 0x000fe20000011636ULL, 0x20000016ff217230ULL, 0x000fe20000004100ULL,
0x0000002cff2c723eULL, 0x000fe400020006ffULL, 0x00000018ff17723eULL, 0x000fe400020006ffULL,
0x0000003cff18723eULL, 0x000fe400020006ffULL, 0x0000003dff15723eULL, 0x000fe200020006ffULL,
0x20000017ff177230ULL, 0x000fe20000004100ULL, 0x0000002eff2e723eULL, 0x000fe200020006ffULL,
0x20000018ff187230ULL, 0x000fe20000004100ULL, 0x00001054363d7816ULL, 0x000fe20000000031ULL,
0x20000015ff157230ULL, 0x000fe20000004100ULL, 0x0000003eff16723eULL, 0x000fe200020006ffULL,
0x2000002eff2e7230ULL, 0x000fe20000004100ULL, 0x00000010ff3c7819ULL, 0x000fe20000011622ULL,
0x2000002cff227230ULL, 0x000fe20000004100ULL, 0x00000010ff267819ULL, 0x000fe20000011626ULL,
0x20000016ff167230ULL, 0x000fe20000004100ULL, 0x00000010ff317819ULL, 0x000fc40000011632ULL,
0x00000008ff297819ULL, 0x000fe40000011629ULL, 0x00000010ff247819ULL, 0x000fe40000011624ULL,
0x00000010ff257819ULL, 0x000fe40000011625ULL, 0x00000010ff337819ULL, 0x000fe40000011633ULL,
0x00000010ff2c7819ULL, 0x000fe40000011638ULL, 0x00000010ff207819ULL, 0x000fc40000011620ULL,
0x00000010ff2f7819ULL, 0x000fe4000001162fULL, 0x0000003bff14723eULL, 0x000fe400020006ffULL,
0x00000010ff3b7819ULL, 0x000fe40000011630ULL, 0x0000105431317816ULL, 0x000fe20000000026ULL,
0x20000014ff147230ULL, 0x000fe20000004100ULL, 0x0000003aff3a723eULL, 0x000fe400020006ffULL,
0x00000010ff307819ULL, 0x000fc40000011635ULL, 0x00000010ff267819ULL, 0x000fe20000011628ULL,
0x2000003aff237230ULL, 0x000fe20000004100ULL, 0x00000029ff29723eULL, 0x000fe400020006ffULL,
0x0000105424357816ULL, 0x000fe40000000033ULL, 0x00001054252c7816ULL, 0x000fe2000000002cULL,
0x20000029ff1a7230ULL, 0x000fe20000004100ULL, 0x000010542f287816ULL, 0x000fe40000000020ULL,
0x00000010ff247819ULL, 0x000fc40000011621ULL, 0x00000010ff2d7819ULL, 0x000fe4000001162dULL,
0x00000010ff207819ULL, 0x000fe40000011617ULL, 0x00000010ff257819ULL, 0x000fe4000001162aULL,
0x00000010ff187819ULL, 0x000fe40000011618ULL, 0x00000010ff177819ULL, 0x000fe4000001162eULL,
0x00000010ff167819ULL, 0x000fc40000011616ULL, 0x00000010ff217819ULL, 0x000fe4000001162bULL,
0x00001054242d7816ULL, 0x000fe4000000002dULL, 0x0000105420257816ULL, 0x000fe40000000025ULL,
0x00000010ff247819ULL, 0x000fe20000011619ULL, 0x0000000867197824ULL, 0x000fe200078e00ffULL,
0x0000105417207816ULL, 0x000fe20000000018ULL, 0x000000026a187836ULL, 0x000fe20000000000ULL,
0x00000010ff297819ULL, 0x000fe20000011634ULL, 0x0000002c1c2c723cULL, 0x000fe200000418ffULL,
0x0000105421217816ULL, 0x000fc40000000016ULL, 0x00000010ff347819ULL, 0x000fe40000011637ULL,
0x00000010ff277819ULL, 0x000fe40000011627ULL, 0x00000010ff1b7819ULL, 0x000fe4000001161bULL,
0x00000010ff237819ULL, 0x000fe40000011623ULL, 0x00000010ff177819ULL, 0x000fe40000011614ULL,
0x00000010ff167819ULL, 0x000fc40000011615ULL, 0x00000010ff147819ULL, 0x000fe4000001161aULL,
0x00000010ff157819ULL, 0x000fe40000011622ULL, 0x00001054293c7816ULL, 0x000fe4000000003cULL,
0xfffffff819187812ULL, 0x000fe400078ee218ULL, 0x000010543b347816ULL, 0x000fe40000000034ULL,
0x0000105430307816ULL, 0x000fe20000000027ULL, 0x0000003c1c3c723cULL, 0x000fe200000418ffULL,
0x0000105426297816ULL, 0x000fc4000000001bULL, 0x0000105424247816ULL, 0x000fe40000000023ULL,
0x000000106d3b7812ULL, 0x000fe200078efcffULL, 0x000000341c34723cULL, 0x000fe200000418ffULL,
0x0000105417147816ULL, 0x000fe40000000014ULL, 0x0000105416157816ULL, 0x000fe20000000015ULL,
0x0000000170687824ULL, 0x000fe200078e023bULL, 0x00000007185e7c11ULL, 0x000fe2000f8e20ffULL,
0x000000103b177824ULL, 0x000fe200078e00ffULL, 0x000000301c30723cULL, 0x000fe600000418ffULL,
0x012000005e18783bULL, 0x0002e20000000200ULL, 0xfffffff017687812ULL, 0x000fc400078ee268ULL,
0x000000281c28723cULL, 0x000fec00000418ffULL, 0x000000241c24723cULL, 0x000fec00000418ffULL,
0x000000201c20723cULL, 0x000fec00000418ffULL, 0x000000141c1c723cULL, 0x000fe200000418ffULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000103947ULL, 0x002fde0003800000ULL,
0x0000000318187232ULL, 0x08cfe40000200000ULL, 0x000000031a1a7232ULL, 0x000fe40000200000ULL,
0x0000000419197232ULL, 0x080fe40000200000ULL, 0x000000041b1b7232ULL, 0x000fce0000200000ULL,
0x0000000e68627c11ULL, 0x000fe2000f8e20ffULL, 0x000000103b507824ULL, 0x040fe200078e00ffULL,
0x000000393b697210ULL, 0x000fe20007ffe066ULL, 0x00000c8000007945ULL, 0x000fe20003800000ULL,
0x000000085f00720cULL, 0x0c0fe20003fc3070ULL, 0x000000006214783bULL, 0x000e620000004200ULL,
0xfffffff050697812ULL, 0x000fe400078ee269ULL, 0x000000085f00720cULL, 0x000fe40003f43070ULL,
0x0000000e69607c11ULL, 0x000fc4000f8e20ffULL, 0x000000ff14387812ULL, 0x002fe400078ec0ffULL,
0x000000ff153a7812ULL, 0x000fe400078ec0ffULL, 0x00000038ff39723eULL, 0x000fe400020006ffULL,
0x0000003aff3b723eULL, 0x000fe400020006ffULL, 0x00000010ff387819ULL, 0x000fe20000011614ULL,
0x20000039ff507230ULL, 0x000fe20000004100ULL, 0x00000010ff3a7819ULL, 0x000fe20000011615ULL,
0x2000003bff6f7230ULL, 0x000fe20000004100ULL, 0x000000ff38387812ULL, 0x000fc400078ec0ffULL,
0x000000ff3a3a7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff14397812ULL, 0x000fe400078ec0ffULL,
0x00000038ff38723eULL, 0x000fe400020006ffULL, 0x0000003aff3a723eULL, 0x000fe400020006ffULL,
0x00000018ff147819ULL, 0x000fe20000011614ULL, 0x20000038ff517230ULL, 0x000fe20000004100ULL,
0x00000008ff397819ULL, 0x000fe20000011639ULL, 0x2000003aff717230ULL, 0x000fe20000004100ULL,
0x00000014ff63723eULL, 0x000fc400020006ffULL, 0x00000039ff14723eULL, 0x000fe400020006ffULL,
0x000000006038783bULL, 0x000e620000004200ULL, 0x00000010ff507819ULL, 0x000fe20000011650ULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x00000010ff517819ULL, 0x000fe20000011651ULL,
0x20000014ff147230ULL, 0x000fe20000004100ULL, 0x00000010ff6f7819ULL, 0x000fe4000001166fULL,
0x00000010ff727819ULL, 0x000fe40000011671ULL, 0x0000105451507816ULL, 0x000fc40000000050ULL,
0x0000105472517816ULL, 0x000fe4000000006fULL, 0x00000018ff6f7819ULL, 0x000fe40000011615ULL,
0x000000ff16727812ULL, 0x000fe400078ec0ffULL, 0x0000006fff6f723eULL, 0x000fe200020006ffULL,
0x00000050183c723cULL, 0x008fe2000004183cULL, 0x00000010ff717819ULL, 0x000fe40000011663ULL,
0x00000010ff147819ULL, 0x000fc40000011614ULL, 0x000000ff17747812ULL, 0x000fe400078ec0ffULL,
0x0000ffff15507812ULL, 0x000fe400078ec0ffULL, 0x00000010ff517819ULL, 0x000fe40000011616ULL,
0x00000008ff507819ULL, 0x000fe40000011650ULL, 0x00000072ff63723eULL, 0x000fe200020006ffULL,
0x2000006fff727230ULL, 0x000fe20000004100ULL, 0x00000050ff50723eULL, 0x000fc400020006ffULL,
0x0000105471147816ULL, 0x000fe20000000014ULL, 0x20000063ff637230ULL, 0x000fe20000004100ULL,
0x00000018ff737819ULL, 0x000fe20000011616ULL, 0x20000050ff6f7230ULL, 0x000fe20000004100ULL,
0x00000074ff75723eULL, 0x000fe400020006ffULL, 0x00000010ff717819ULL, 0x000fe40000011617ULL,
0x000000ff51747812ULL, 0x000fe200078ec0ffULL, 0x20000075ff507230ULL, 0x000fe20000004100ULL,
0x00000073ff51723eULL, 0x000fc400020006ffULL, 0x00000018ff157819ULL, 0x000fe40000011617ULL,
0x00000074ff74723eULL, 0x000fe200020006ffULL, 0x20000051ff517230ULL, 0x000fe20000004100ULL,
0x000000ff71737812ULL, 0x000fe400078ec0ffULL, 0x00000010ff727819ULL, 0x000fe20000011672ULL,
0x20000074ff747230ULL, 0x000fe20000004100ULL, 0x00000010ff717819ULL, 0x000fe4000001166fULL,
0x00000015ff6f723eULL, 0x000fc400020006ffULL, 0x0000105472157816ULL, 0x000fe40000000071ULL,
0x000000ff38727812ULL, 0x002fe200078ec0ffULL, 0x2000006fff6f7230ULL, 0x000fe20000004100ULL,
0x0000ffff16167812ULL, 0x000fe400078ec0ffULL, 0x0000ffff17177812ULL, 0x000fe200078ec0ffULL,
0x000000141834723cULL, 0x000fe20000041834ULL, 0x00000010ff717819ULL, 0x000fe40000011663ULL,
0x00000073ff73723eULL, 0x000fc400020006ffULL, 0x00000010ff747819ULL, 0x000fe40000011674ULL,
0x00000072ff63723eULL, 0x000fe200020006ffULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x00000008ff727819ULL, 0x000fe40000011616ULL, 0x00000008ff177819ULL, 0x000fe20000011617ULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x0000105474167816ULL, 0x000fe40000000071ULL,
0x00000010ff747819ULL, 0x000fc40000011638ULL, 0x00000072ff72723eULL, 0x000fe400020006ffULL,
0x00000017ff71723eULL, 0x000fe400020006ffULL, 0x000000ff74757812ULL, 0x000fe200078ec0ffULL,
0x20000072ff727230ULL, 0x000fe20000004100ULL, 0x00000010ff177819ULL, 0x000fe20000011650ULL,
0x20000071ff717230ULL, 0x000fe20000004100ULL, 0x00000010ff747819ULL, 0x000fe40000011673ULL,
0x00000010ff517819ULL, 0x000fc40000011651ULL, 0x0000105474177816ULL, 0x000fe40000000017ULL,
0x00000010ff747819ULL, 0x000fe4000001166fULL, 0x00000010ff147819ULL, 0x000fe40000011672ULL,
0x00000010ff157819ULL, 0x000fe20000011671ULL, 0x000000161830723cULL, 0x000fe20000041830ULL,
0x0000105451147816ULL, 0x000fe40000000014ULL, 0x0000105474157816ULL, 0x000fc40000000015ULL,
0x00000075ff50723eULL, 0x000fe400020006ffULL, 0x00000018ff717819ULL, 0x000fe40000011638ULL,
0x0000ffff38737812ULL, 0x000fe200078ec0ffULL, 0x20000050ff507230ULL, 0x000fe20000004100ULL,
0x00000014182c723cULL, 0x000fe2000004182cULL, 0x000000ff3a387812ULL, 0x000fe400078ec0ffULL,
0x00000010ff517819ULL, 0x000fe4000001163aULL, 0x00000010ff177819ULL, 0x000fc40000011650ULL,
0x00000018ff147819ULL, 0x100fe40000011639ULL, 0x00000018ff747819ULL, 0x000fe4000001163aULL,
0x0000ffff3a507812ULL, 0x000fe400078ec0ffULL, 0x00000014ff14723eULL, 0x000fe400020006ffULL,
0x00000038ff3a723eULL, 0x000fe400020006ffULL, 0x00000010ff157819ULL, 0x000fe20000011639ULL,
0x20000014ff387230ULL, 0x000fe20000004100ULL, 0x00000071ff71723eULL, 0x000fe200020006ffULL,
0x2000003aff147230ULL, 0x000fe20000004100ULL, 0x0000ffff39727812ULL, 0x000fc400078ec0ffULL,
0x000000ff396f7812ULL, 0x000fe200078ec0ffULL, 0x20000071ff397230ULL, 0x000fe20000004100ULL,
0x000000ff153a7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff737819ULL, 0x000fe40000011673ULL,
0x00000010ff167819ULL, 0x000fe40000011663ULL, 0x00000074ff74723eULL, 0x000fe400020006ffULL,
0x00000008ff727819ULL, 0x000fc40000011672ULL, 0x0000006fff6f723eULL, 0x000fe400020006ffULL,
0x00000018ff757819ULL, 0x100fe4000001163bULL, 0x0000003aff71723eULL, 0x000fe200020006ffULL,
0x20000074ff3a7230ULL, 0x000fe20000004100ULL, 0x00000010ff637819ULL, 0x000fe2000001163bULL,
0x2000006fff6f7230ULL, 0x000fe20000004100ULL, 0x00000073ff73723eULL, 0x000fe400020006ffULL,
0x0000105417167816ULL, 0x000fc40000000016ULL, 0x00000072ff72723eULL, 0x000fe400020006ffULL,
0x000000ff3b767812ULL, 0x040fe400078ec0ffULL, 0x0000ffff3b177812ULL, 0x000fe400078ec0ffULL,
0x00000075ff3b723eULL, 0x000fe400020006ffULL, 0x000000ff51747812ULL, 0x000fe200078ec0ffULL,
0x20000071ff517230ULL, 0x000fe20000004100ULL, 0x000000ff63757812ULL, 0x000fe200078ec0ffULL,
0x20000073ff637230ULL, 0x000fe20000004100ULL, 0x00000008ff737819ULL, 0x000fe20000011650ULL,
0x20000072ff717230ULL, 0x000fe20000004100ULL, 0x00000008ff727819ULL, 0x000fe20000011617ULL,
0x2000003bff3b7230ULL, 0x000fe20000004100ULL, 0x00000010ff6f7819ULL, 0x000fc4000001166fULL,
0x00000010ff507819ULL, 0x000fe40000011651ULL, 0x00000073ff51723eULL, 0x000fe400020006ffULL,
0x00000072ff73723eULL, 0x000fe400020006ffULL, 0x00000010ff727819ULL, 0x000fe20000011638ULL,
0x20000051ff517230ULL, 0x000fe20000004100ULL, 0x0000105450177816ULL, 0x000fe4000000006fULL,
0x00000010ff397819ULL, 0x000fc40000011639ULL, 0x00000010ff387819ULL, 0x000fe20000011663ULL,
0x20000073ff637230ULL, 0x000fe20000004100ULL, 0x00000010ff717819ULL, 0x000fe20000011671ULL,
0x000000161828723cULL, 0x000fe20000041828ULL, 0x0000105439387816ULL, 0x000fe40000000038ULL,
0x0000105472397816ULL, 0x000fe40000000071ULL, 0x00000076ff76723eULL, 0x000fe400020006ffULL,
0x00000010ff177819ULL, 0x000fc4000001163aULL, 0x00000074ff74723eULL, 0x000fe200020006ffULL,
0x000000381824723cULL, 0x000fe20000041824ULL, 0x00000075ff75723eULL, 0x000fe200020006ffULL,
0x20000076ff157230ULL, 0x000fe20000004100ULL, 0x00000010ff3a7819ULL, 0x000fe20000011663ULL,
0x20000074ff747230ULL, 0x000fe20000004100ULL, 0x00000002ff637819ULL, 0x000fe20000011612ULL,
0x20000075ff507230ULL, 0x000fe20000004100ULL, 0x00000010ff167819ULL, 0x000fe20000011651ULL,
0x000000016b397836ULL, 0x000fe20000000000ULL, 0x0000006b6300720cULL, 0x000fc40003f86070ULL,
0x00000010ff147819ULL, 0x000fe40000011614ULL, 0x000000396300720cULL, 0x000fe40006786470ULL,
0x00000010ff6f7819ULL, 0x000fe40000011674ULL, 0x00000010ff157819ULL, 0x000fe40000011615ULL,
0x00000010ff3b7819ULL, 0x000fe4000001163bULL, 0x00000010ff507819ULL, 0x000fc40000011650ULL,
0x0000105417167816ULL, 0x000fe40000000016ULL, 0x000010546f147816ULL, 0x000fe40000000014ULL,
0x0000105450157816ULL, 0x000fe40000000015ULL, 0x000010543b177816ULL, 0x000fe2000000003aULL,
0x00000008633a7836ULL, 0x000fc80000000000ULL, 0x000000141820723cULL, 0x000fe20000041820ULL,
0x0000006b3a00720cULL, 0x000fc80003fa6070ULL, 0x000000393a00720cULL, 0x000fe20006fa6470ULL,
0x00000016181c723cULL, 0x000fe2000004181cULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000404947ULL, 0x000fde0003000000ULL, 0x0000003c0b0b7221ULL, 0x000fe20000010000ULL,
0x0000003d0c0c7221ULL, 0x000fe20000010000ULL, 0x000000340f0f7221ULL, 0x000fe20000010000ULL,
0x0000003510107221ULL, 0x000fe20000010000ULL, 0x0000003041417221ULL, 0x000fe20000010000ULL,
0x0000003142427221ULL, 0x000fe20000010000ULL, 0x0000002c45457221ULL, 0x000fe20000010000ULL,
0x0000002d46467221ULL, 0x000fe20000010000ULL, 0x0000002849497221ULL, 0x000fe20000010000ULL,
0x000000294a4a7221ULL, 0x000fe20000010000ULL, 0x000000244d4d7221ULL, 0x000fe20000010000ULL,
0x000000254e4e7221ULL, 0x000fe20000010000ULL, 0x0000002053537221ULL, 0x000fe20000010000ULL,
0x0000002154547221ULL, 0x000fe20000010000ULL, 0x0000001c57577221ULL, 0x000fe20000010000ULL,
0x0000001d58587221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000012000007945ULL, 0x000fe80003800000ULL, 0x0000000000405947ULL, 0x000fea0001000000ULL,
0x0000003e0d0d7221ULL, 0x000fe20000010000ULL, 0x0000003f0e0e7221ULL, 0x000fe20000010000ULL,
0x0000003611117221ULL, 0x000fe20000010000ULL, 0x0000003740407221ULL, 0x000fe20000010000ULL,
0x0000003243437221ULL, 0x000fe20000010000ULL, 0x0000003344447221ULL, 0x000fe20000010000ULL,
0x0000002e47477221ULL, 0x000fe20000010000ULL, 0x0000002f48487221ULL, 0x000fe20000010000ULL,
0x0000002a4b4b7221ULL, 0x000fe20000010000ULL, 0x0000002b4c4c7221ULL, 0x000fe20000010000ULL,
0x000000264f4f7221ULL, 0x000fe20000010000ULL, 0x0000002752527221ULL, 0x000fe20000010000ULL,
0x0000002255557221ULL, 0x000fe20000010000ULL, 0x0000002356567221ULL, 0x000fe20000010000ULL,
0x0000001e59597221ULL, 0x000fe20000010000ULL, 0x0000001f5a5a7221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x018b886cff1479a7ULL, 0x000e620008500007ULL,
0x00000003391a7812ULL, 0x000fe400078ec0ffULL, 0x000000085f00720cULL, 0x0c0fe40003f43070ULL,
0x000000085f00720cULL, 0x000fe40003fc3070ULL, 0x00000004ff387803ULL, 0x000fe40000000000ULL,
0x000000ff1a1a7207ULL, 0x000fe40004000000ULL, 0x00000002ff147819ULL, 0x002fe20000011639ULL,
0x000000ffff187224ULL, 0x000fc600078e0015ULL, 0x0000001439397207ULL, 0x000fc80000000000ULL,
0x00000003391b7812ULL, 0x040fe400078ec0ffULL, 0x00000008391c7211ULL, 0x000fce00078ff0ffULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x018b8065ff0075a7ULL, 0x000e640008040147ULL,
0x00000000005c2947ULL, 0x002fea0003800000ULL, 0x000000ffff1d7224ULL, 0x000fce00078e00ffULL,
0x000000101d00780cULL, 0x000fda0003f46270ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x0000001416197210ULL, 0x000fca0007f5e1ffULL,
0x0000000115157824ULL, 0x000fe200010e0e17ULL, 0x003d09001900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x000000000008a947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x00000000001ca947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001914147211ULL, 0x000fca00078510ffULL, 0x000000ffff157224ULL, 0x000fca00010e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011d1d7836ULL, 0x000fce0000000000ULL,
0x018b8065ff0075a7ULL, 0x000e640008040147ULL, 0xfffffffc00a8a947ULL, 0x002fea000383ffffULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x018b8818ff0075a7ULL, 0x000e640008040147ULL,
0x00000000005c2947ULL, 0x002fea0003800000ULL, 0x000000ffff1d7224ULL, 0x000fce00078e00ffULL,
0x000000101d00780cULL, 0x000fda0003f46270ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x0000001416197210ULL, 0x000fca0007f5e1ffULL,
0x0000000115157824ULL, 0x000fe200010e0e17ULL, 0x003d09001900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x000000000008a947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x00000000001ca947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001914147211ULL, 0x000fca00078510ffULL, 0x000000ffff157224ULL, 0x000fca00010e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011d1d7836ULL, 0x000fce0000000000ULL,
0x018b8818ff0075a7ULL, 0x000e640008040147ULL, 0xfffffffc00a8a947ULL, 0x002fea000383ffffULL,
0x000000041c147824ULL, 0x000fc800078e021bULL, 0x00000040141e7824ULL, 0x000fe400078e00ffULL,
0x000000011c147836ULL, 0x000fc60000000000ULL, 0x000000405b1d7812ULL, 0x000fe400078ef81eULL,
0x0000000c14007c0cULL, 0x000fda000bf46070ULL, 0x000000040054a947ULL, 0x000fea0003800000ULL,
0x000000015d207824ULL, 0x000fe200078e0266ULL, 0x000000091e187c48ULL, 0x000fe2000ffe0000ULL,
0x00000010121f7824ULL, 0x000fe200078e00ffULL, 0x00014000070e7890ULL, 0x000fe2000fffe03fULL,
0x0000000120177824ULL, 0x040fe200078e021dULL, 0x0000000720227c11ULL, 0x000fe2000f8e10ffULL,
0x0000000118187824ULL, 0x000fe200078e0a1eULL, 0x000000f01f1f7812ULL, 0x000fc600078ec0ffULL,
0x018a000022147984ULL, 0x000e620000000800ULL, 0x000000185d187248ULL, 0x000fca0007fe0000ULL,
0x0000000118217824ULL, 0x000fe200078e0a5dULL, 0x0000000714197c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e660000000a00ULL, 0x018ac00019167984ULL, 0x0007240000000800ULL,
0x0000000120197824ULL, 0x048fe400078e0212ULL, 0x0000001020207824ULL, 0x000fca00078e00ffULL,
0xfffffff020197812ULL, 0x000fe200078ee219ULL, 0x0000000266207836ULL, 0x000fc60000000000ULL,
0x0000000e19237c11ULL, 0x000fe2000f8e20ffULL, 0x000000015d247824ULL, 0x000fc800078e0220ULL,
0x0000000124197824ULL, 0x000fe400078e021dULL, 0x0000000616177c24ULL, 0x010fc8000f8e0217ULL,
0x0000010017167825ULL, 0x002fc600078e0014ULL, 0x0000001f16167210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff177224ULL, 0x000fe200010e0617ULL, 0x000000216600720cULL, 0x000fda0003f46070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e8000d101c4aULL,
0x018a080022187984ULL, 0x000ee20000000800ULL, 0x0000000124167824ULL, 0x042fe400078e0212ULL,
0x0000001024177824ULL, 0x000fca00078e00ffULL, 0xfffffff017167812ULL, 0x000fc800078ee216ULL,
0x0000000e16237c11ULL, 0x000fe4000f8e20ffULL, 0x00000007181e7c11ULL, 0x008fca000f8e10ffULL,
0x018ac0001e187984ULL, 0x000e640000000800ULL, 0x0000000618197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000001f18187210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff197224ULL, 0x000fe200010e0619ULL, 0x000000212000720cULL, 0x000fe20003f46070ULL,
0x0000000466207836ULL, 0x000fe40000000000ULL, 0x0000000666667836ULL, 0x000fe40000000000ULL,
0x000000015d247824ULL, 0x000fc800078e0220ULL, 0x0000000124177824ULL, 0x000fc800078e021dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018237faeULL, 0x0003e8000d101c4aULL,
0x018a100022167984ULL, 0x000ee20000000800ULL, 0x0000000124187824ULL, 0x042fe400078e0212ULL,
0x0000001024197824ULL, 0x000fca00078e00ffULL, 0xfffffff019187812ULL, 0x000fc800078ee218ULL,
0x0000000e18197c11ULL, 0x000fe4000f8e20ffULL, 0x00000007161e7c11ULL, 0x008fca000f8e10ffULL,
0x018ac0001e167984ULL, 0x0002e40000000800ULL, 0x000000015d1e7824ULL, 0x002fc800078e0266ULL,
0x000000011e1d7824ULL, 0x000fe400078e021dULL, 0x0000000616177c24ULL, 0x008fc8000f8e0217ULL,
0x0000010017167825ULL, 0x000fc600078e0014ULL, 0x0000001f16167210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff177224ULL, 0x000fe200010e0617ULL, 0x000000212000720cULL, 0x000fda0003f46070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016197faeULL, 0x0003e8000d101c4aULL,
0x018a180022187984ULL, 0x000ee20000000800ULL, 0x000000011e167824ULL, 0x042fe400078e0212ULL,
0x000000101e177824ULL, 0x000fca00078e00ffULL, 0xfffffff017167812ULL, 0x000fc800078ee216ULL,
0x0000000e16177c11ULL, 0x000fe4000f8e20ffULL, 0x0000000718187c11ULL, 0x008fcc000f8e10ffULL,
0x018ac00018187984ULL, 0x000e640000000800ULL, 0x00000006181d7c24ULL, 0x002fc8000f8e021dULL,
0x000001001d147825ULL, 0x000fc600078e0014ULL, 0x0000001f14147210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff157224ULL, 0x000fe200010e0615ULL, 0x000000216600720cULL, 0x000fda0003f46070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e2000d101c4aULL,
0x0000000400247947ULL, 0x000fea0003800000ULL, 0x000000015d667824ULL, 0x000fe200078e0266ULL,
0x00014000070e7890ULL, 0x000fe2000fffe03fULL, 0x0000001012197824ULL, 0x000fe400078e00ffULL,
0x0000000166177824ULL, 0x040fe200078e021dULL, 0x0000000766227c11ULL, 0x040fe2000f8e10ffULL,
0x00000010661e7824ULL, 0x040fe200078e00ffULL, 0x000000f019237812ULL, 0x000fe200078ec0ffULL,
0x0000000166197824ULL, 0x000fe400078e0212ULL, 0x018a000022147984ULL, 0x000e660000000800ULL,
0xfffffff01e197812ULL, 0x000fe200078ee219ULL, 0x00000002661e7836ULL, 0x000fc60000000000ULL,
0x0000000e19217c11ULL, 0x000fe2000f8e20ffULL, 0x000000011d197824ULL, 0x000fe400078e021eULL,
0x000000011e1f7824ULL, 0x040fe400078e0212ULL, 0x000000101e1e7824ULL, 0x000fca00078e00ffULL,
0xfffffff01e1f7812ULL, 0x000fe200078ee21fULL, 0x00000004661e7836ULL, 0x000fc60000000000ULL,
0x0000000e1f1f7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000714187c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e660000000a00ULL, 0x018ac00018167984ULL, 0x000ee40000000800ULL,
0x0000000616177c24ULL, 0x008fc8000f8e0217ULL, 0x0000010017167825ULL, 0x002fc600078e0014ULL,
0x0000002316167210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff177224ULL, 0x000fca00010e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016217faeULL, 0x0003e8000b901c4aULL,
0x018a080022187984ULL, 0x000ee20000000800ULL, 0x000000011d177824ULL, 0x002fe200078e021eULL,
0x0000000718207c11ULL, 0x008fca000f8e10ffULL, 0x018ac00020187984ULL, 0x0002e40000000800ULL,
0x000000011e207824ULL, 0x002fe400078e0212ULL, 0x0000000618197c24ULL, 0x008fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000002318187210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff197224ULL, 0x000fca00010e0619ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000181f7faeULL, 0x0003e8000b901c4aULL, 0x018a100022167984ULL, 0x000ee20000000800ULL,
0x000000101e197824ULL, 0x002fca00078e00ffULL, 0xfffffff019207812ULL, 0x000fc800078ee220ULL,
0x0000000e20197c11ULL, 0x000fe4000f8e20ffULL, 0x0000000716217c11ULL, 0x008fca000f8e10ffULL,
0x018ac00021167984ULL, 0x000e640000000800ULL, 0x0000000616177c24ULL, 0x002fc8000f8e0217ULL,
0x0000010017167825ULL, 0x000fc600078e0014ULL, 0x0000002316167210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff177224ULL, 0x000fca00010e0617ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016197faeULL, 0x0003e8000b901c4aULL, 0x018a180022187984ULL, 0x000ee40000000800ULL,
0x00000007181e7c11ULL, 0x008fe2000f8e10ffULL, 0x0000000666187836ULL, 0x000fc80000000000ULL,
0x000000011d1d7824ULL, 0x000fe200078e0218ULL, 0x018ac0001e1e7984ULL, 0x000ee60000000800ULL,
0x000000061e1d7c24ULL, 0x008fc8000f8e021dULL, 0x000001001d147825ULL, 0x000fc800078e0014ULL,
0x00000001181d7824ULL, 0x040fe200078e0212ULL, 0x0000002314147210ULL, 0x000fe20007f5e0ffULL,
0x0000001018187824ULL, 0x000fc800078e00ffULL, 0x000000ffff157224ULL, 0x000fe200010e0615ULL,
0xfffffff0181d7812ULL, 0x000fc800078ee21dULL, 0x0000000e1d1d7c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000141d7faeULL, 0x0003e4000b901c4aULL,
0x00000001ff147424ULL, 0x002fcc00078e00ffULL, 0x018b8814ff1479a7ULL, 0x000e640008500007ULL,
0x000000ffff187224ULL, 0x002fce00078e0015ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x018b8818ff0075a7ULL, 0x000e640008040147ULL, 0x00000000005c2947ULL, 0x002fea0003800000ULL,
0x000000ffff1d7224ULL, 0x000fce00078e00ffULL, 0x000000101d00780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x0000001416197210ULL, 0x000fca0007f5e1ffULL, 0x0000000115157824ULL, 0x000fe200010e0e17ULL,
0x003d09001900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078510ffULL,
0x000000ffff157224ULL, 0x000fca00010e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011d1d7836ULL, 0x000fce0000000000ULL, 0x018b8818ff0075a7ULL, 0x000e640008040147ULL,
0xfffffffc00a8a947ULL, 0x002fea000383ffffULL, 0x000000046a147836ULL, 0x000fe20000000000ULL,
0x000001b000007945ULL, 0x000fe20003800000ULL, 0x0000000867157824ULL, 0x000fe400078e00ffULL,
0x000000016d707824ULL, 0x000fc600078e0270ULL, 0xfffffff815667812ULL, 0x000fe200078ee214ULL,
0x0000000000581947ULL, 0x000fec0003800000ULL, 0x0000001c5f00720cULL, 0x000fe20003f44070ULL,
0x00009400ff187b82ULL, 0x000e620000000800ULL, 0x000000076e197c11ULL, 0x000fe4000f8e10ffULL,
0x000000ff1a147207ULL, 0x040fe40001000000ULL, 0x000000ff1a177207ULL, 0x000fc60005000000ULL,
0x000000011b1b7824ULL, 0x000fe400078e0214ULL, 0x00009200ff147b82ULL, 0x000ee20000000a00ULL,
0x000000015c177824ULL, 0x000fe400078e0217ULL, 0x000000401b167824ULL, 0x040fe200078e00ffULL,
0x0000001c1b1b7211ULL, 0x000fc800078ff0ffULL, 0x000000c016167812ULL, 0x000fca00078ec0ffULL,
0x000001001b167824ULL, 0x000fc800078e0216ULL, 0x0000002016167836ULL, 0x000fc80000000000ULL,
0x0000001817177224ULL, 0x102fe400078e0216ULL, 0x000000016e167824ULL, 0x040fe400078e0216ULL,
0x000000016e177824ULL, 0x000fc600078e0217ULL, 0x0000000916007c0cULL, 0x000fe2000bf46070ULL,
0x0000000417147825ULL, 0x008fd800078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x18a0000014197faeULL, 0x0003e4000d12184aULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x00000001ff6e7424ULL, 0x000fe200078e00ffULL,
0x0000000766667c11ULL, 0x000fe2000f8e20ffULL, 0x00000000ff0079b0ULL, 0x000fe20008000a48ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x018b786eff6e79a7ULL, 0x000e620008500007ULL,
0x0000000000103947ULL, 0x000fea0003800000ULL, 0x00000006ff03723eULL, 0x004fc800000010ffULL,
0x0000541003147816ULL, 0x000fca0000000003ULL, 0x00001f3a14047589ULL, 0x0004e800000e0000ULL,
0x00001f6314037589ULL, 0x00046400000e0000ULL, 0x012000006630783bULL, 0x0006a20000000200ULL,
0x000000106d657824ULL, 0x000fe200078e00ffULL, 0x0000000000103947ULL, 0x000fec0003800000ULL,
0x0000000330307232ULL, 0x086fe40000200000ULL, 0x0000000332327232ULL, 0x000fe40000200000ULL,
0x0000000431317232ULL, 0x088fe40000200000ULL, 0x0000000433337232ULL, 0x000fce0000200000ULL,
0x000000016d647824ULL, 0x040fe200078e0264ULL, 0x00016000070e7890ULL, 0x000fe2000fffe03fULL,
0x000000106d6d7824ULL, 0x000fe200078e00ffULL, 0xfffffff065657812ULL, 0x000fe200078ee270ULL,
0x000000066a6a7836ULL, 0x000fe40000000000ULL, 0x0000000867677824ULL, 0x000fe200078e00ffULL,
0xfffffff06d647812ULL, 0x000fe400078ee264ULL, 0x0000000e65657c11ULL, 0x000fe4000f8e20ffULL,
0x0000000e64647c11ULL, 0x000fc4000f8e20ffULL, 0xfffffff867677812ULL, 0x000fe200078ee26aULL,
0x000000006514783bULL, 0x004ea60000004200ULL, 0x0000000767677c11ULL, 0x000fe2000f8e20ffULL,
0x000000006418783bULL, 0x000f220000004200ULL, 0x00000010ff287819ULL, 0x004fe40000011617ULL,
0x00000018ff1c7819ULL, 0x000fe40000011614ULL, 0x00000010ff2f7819ULL, 0x000fc40000011616ULL,
0x000000ff16257812ULL, 0x040fe400078ec0ffULL, 0x00000018ff237819ULL, 0x000fe40000011616ULL,
0x0000ffff16267812ULL, 0x000fe400078ec0ffULL, 0x0000ffff14367812ULL, 0x000fe400078ec0ffULL,
0x00000018ff167819ULL, 0x000fe40000011617ULL, 0x000000ff182b7812ULL, 0x010fc400078ec0ffULL,
0x000000ff141d7812ULL, 0x000fe400078ec0ffULL, 0x000000ff28287812ULL, 0x000fe400078ec0ffULL,
0x00000018ff1e7819ULL, 0x000fe40000011615ULL, 0x000000ff172a7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff17297812ULL, 0x000fe400078ec0ffULL, 0x00000018ff397819ULL, 0x000fc40000011619ULL,
0x0000001cff1c723eULL, 0x000fe400020006ffULL, 0x00000018ff177819ULL, 0x000fe40000011618ULL,
0x00000016ff16723eULL, 0x000fe400020006ffULL, 0x00000008ff367819ULL, 0x000fe40000011636ULL,
0x00000010ff377819ULL, 0x000fe40000011614ULL, 0x000000ff193a7812ULL, 0x000fc400078ec0ffULL,
0x0000002bff2b723eULL, 0x000fe400020006ffULL, 0x00000010ff357819ULL, 0x000fe40000011615ULL,
0x0000001dff14723eULL, 0x000fe400020006ffULL, 0x00000010ff207819ULL, 0x000fe40000011619ULL,
0x0000ffff19277812ULL, 0x000fe200078ec0ffULL, 0x20000014ff147230ULL, 0x000fe20000004100ULL,
0x00000018ff3b7819ULL, 0x000fc4000001161aULL, 0x00000028ff28723eULL, 0x000fe400020006ffULL,
0x0000ffff15347812ULL, 0x000fe400078ec0ffULL, 0x00000010ff2d7819ULL, 0x000fe40000011618ULL,
0x0000ffff182e7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff1f7819ULL, 0x000fe4000001161bULL,
0x0000001eff19723eULL, 0x000fc400020006ffULL, 0x00000025ff1d723eULL, 0x000fe200020006ffULL,
0x2000001cff257230ULL, 0x000fe20000004100ULL, 0x00000039ff39723eULL, 0x000fe200020006ffULL,
0x20000019ff197230ULL, 0x000fe20000004100ULL, 0x00000010ff187819ULL, 0x000fe2000001161aULL,
0x2000001dff1d7230ULL, 0x000fe20000004100ULL, 0x000000ff1a3c7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff1a217812ULL, 0x000fe400078ec0ffULL, 0x00000017ff1e723eULL, 0x000fe200020006ffULL,
0x20000016ff177230ULL, 0x000fe20000004100ULL, 0x00000036ff36723eULL, 0x000fe200020006ffULL,
0x2000002bff167230ULL, 0x000fe20000004100ULL, 0x00000010ff247819ULL, 0x000fe2000001161bULL,
0x2000001eff1e7230ULL, 0x000fe20000004100ULL, 0x0000002aff1c723eULL, 0x000fc400020006ffULL,
0x0000003aff1a723eULL, 0x000fe400020006ffULL, 0x000000ff37377812ULL, 0x000fe200078ec0ffULL,
0x2000001cff1c7230ULL, 0x000fe20000004100ULL, 0x0000003bff2a723eULL, 0x000fe200020006ffULL,
0x20000028ff3b7230ULL, 0x000fe20000004100ULL, 0x000000ff35357812ULL, 0x000fe200078ec0ffULL,
0x2000001aff1a7230ULL, 0x000fe20000004100ULL, 0x000000ff2f3a7812ULL, 0x000fe200078ec0ffULL,
0x2000002aff2a7230ULL, 0x000fe20000004100ULL, 0x00000008ff267819ULL, 0x000fc40000011626ULL,
0x0000001fff2b723eULL, 0x000fe200020006ffULL, 0x20000039ff1f7230ULL, 0x000fe20000004100ULL,
0x00000008ff347819ULL, 0x000fe20000011634ULL, 0x20000036ff397230ULL, 0x000fe20000004100ULL,
0x00000008ff287819ULL, 0x000fe20000011621ULL, 0x2000002bff2b7230ULL, 0x000fe20000004100ULL,
0x000000ff15227812ULL, 0x000fe400078ec0ffULL, 0x00000037ff37723eULL, 0x000fe400020006ffULL,
0x000000ff24247812ULL, 0x000fc400078ec0ffULL, 0x00000035ff35723eULL, 0x000fe200020006ffULL,
0x20000037ff2f7230ULL, 0x000fe20000004100ULL, 0x0000003aff36723eULL, 0x000fe400020006ffULL,
0x00000026ff26723eULL, 0x000fe200020006ffULL, 0x20000035ff377230ULL, 0x000fe20000004100ULL,
0x000000ff20207812ULL, 0x000fe200078ec0ffULL, 0x20000036ff367230ULL, 0x000fe20000004100ULL,
0x00000034ff34723eULL, 0x000fe200020006ffULL, 0x20000026ff3a7230ULL, 0x000fe20000004100ULL,
0x00000008ff297819ULL, 0x000fc40000011629ULL, 0x0000ffff1b157812ULL, 0x000fe200078ec0ffULL,
0x20000034ff357230ULL, 0x000fe20000004100ULL, 0x00000008ff2e7819ULL, 0x000fe4000001162eULL,
0x000000ff18187812ULL, 0x000fe400078ec0ffULL, 0x00000028ff28723eULL, 0x000fe400020006ffULL,
0x00000022ff22723eULL, 0x000fe400020006ffULL, 0x000000ff2d2d7812ULL, 0x000fc400078ec0ffULL,
0x00000024ff24723eULL, 0x000fe200020006ffULL, 0x20000022ff2c7230ULL, 0x000fe20000004100ULL,
0x00000020ff20723eULL, 0x000fe400020006ffULL, 0x00000029ff29723eULL, 0x000fe400020006ffULL,
0x0000002eff26723eULL, 0x000fe200020006ffULL, 0x20000028ff2e7230ULL, 0x000fe20000004100ULL,
0x00000018ff18723eULL, 0x000fe200020006ffULL, 0x20000024ff287230ULL, 0x000fe20000004100ULL,
0x00000008ff157819ULL, 0x000fe20000011615ULL, 0x20000020ff217230ULL, 0x000fe20000004100ULL,
0x0000002dff34723eULL, 0x000fe200020006ffULL, 0x20000029ff2d7230ULL, 0x000fe20000004100ULL,
0x00000008ff277819ULL, 0x000fe20000011627ULL, 0x20000018ff297230ULL, 0x000fe20000004100ULL,
0x00000010ff247819ULL, 0x000fe2000001161cULL, 0x20000034ff347230ULL, 0x000fe20000004100ULL,
0x00000015ff20723eULL, 0x000fe200020006ffULL, 0x20000026ff267230ULL, 0x000fe20000004100ULL,
0x00000010ff1d7819ULL, 0x000fc4000001161dULL, 0x00000010ff1c7819ULL, 0x000fe40000011636ULL,
0x000000ff1b3d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff3b7819ULL, 0x000fe4000001163bULL,
0x00000010ff147819ULL, 0x000fe40000011614ULL, 0x00000010ff257819ULL, 0x000fe40000011625ULL,
0x00000010ff157819ULL, 0x000fe2000001162fULL, 0x20000020ff2f7230ULL, 0x000fe20000004100ULL,
0x00000010ff187819ULL, 0x000fc40000011639ULL, 0x00000023ff1b723eULL, 0x000fe400020006ffULL,
0x00000027ff27723eULL, 0x000fe400020006ffULL, 0x00000010ff2c7819ULL, 0x000fe2000001162cULL,
0x2000001bff1b7230ULL, 0x000fe20000004100ULL, 0x00000010ff377819ULL, 0x000fe20000011637ULL,
0x20000027ff277230ULL, 0x000fe20000004100ULL, 0x0000003cff23723eULL, 0x000fe400020006ffULL,
0x000010541c1c7816ULL, 0x000fc4000000001dULL, 0x0000003dff22723eULL, 0x000fe200020006ffULL,
0x20000023ff237230ULL, 0x000fe20000004100ULL, 0x000010543b1d7816ULL, 0x000fe40000000024ULL,
0x0000105415147816ULL, 0x000fe20000000014ULL, 0x20000022ff227230ULL, 0x000fe20000004100ULL,
0x0000105425187816ULL, 0x000fe40000000018ULL, 0x00000010ff207819ULL, 0x000fe40000011619ULL,
0x00000010ff247819ULL, 0x000fc40000011617ULL, 0x00000010ff2d7819ULL, 0x000fe4000001162dULL,
0x0000105437157816ULL, 0x000fe4000000002cULL, 0x00000010ff197819ULL, 0x000fe40000011635ULL,
0x00000010ff257819ULL, 0x000fe40000011616ULL, 0x00000010ff347819ULL, 0x000fe20000011634ULL,
0x000000143014723cULL, 0x000fe200000418ffULL, 0x00000010ff2c7819ULL, 0x000fc4000001161aULL,
0x00000010ff357819ULL, 0x000fe40000011621ULL, 0x0000105424217816ULL, 0x000fe4000000002dULL,
0x0000105434247816ULL, 0x000fe40000000025ULL, 0x0000105435257816ULL, 0x000fe4000000002cULL,
0x00000010ff2c7819ULL, 0x000fe4000001161fULL, 0x00000010ff277819ULL, 0x000fc40000011627ULL,
0x00000010ff2d7819ULL, 0x000fe4000001161eULL, 0x00000010ff347819ULL, 0x000fe20000011623ULL,
0x0000001c301c723cULL, 0x000fe200000418ffULL, 0x00000010ff267819ULL, 0x000fe40000011626ULL,
0x00000010ff357819ULL, 0x000fe40000011629ULL, 0x00000010ff367819ULL, 0x000fe40000011622ULL,
0x00000010ff377819ULL, 0x000fc40000011628ULL, 0x000010542c297816ULL, 0x000fe40000000027ULL,
0x000010542d287816ULL, 0x000fe40000000026ULL, 0x00001054352c7816ULL, 0x000fe20000000034ULL,
0x000000243024723cULL, 0x000fe200000418ffULL, 0x00000010ff1b7819ULL, 0x000fe4000001161bULL,
0x00000010ff3a7819ULL, 0x000fe4000001163aULL, 0x00001054372d7816ULL, 0x000fc40000000036ULL,
0x00000010ff357819ULL, 0x000fe4000001162aULL, 0x00000010ff2e7819ULL, 0x000fe4000001162eULL,
0x00000010ff367819ULL, 0x000fe4000001162bULL, 0x00000010ff2f7819ULL, 0x000fe2000001162fULL,
0x000000283028723cULL, 0x000fe200000418ffULL, 0x0000105420197816ULL, 0x000fe40000000019ULL,
0x000010541b207816ULL, 0x000fc4000000003aULL, 0x0000105435347816ULL, 0x000fe4000000002eULL,
0x0000105436357816ULL, 0x000fe2000000002fULL, 0x000000183018723cULL, 0x000fec00000418ffULL,
0x000000203020723cULL, 0x000fec00000418ffULL, 0x0000002c302c723cULL, 0x000fec00000418ffULL,
0x000000343030723cULL, 0x000fe200000418ffULL, 0x012000006734783bULL, 0x0004e20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000103947ULL, 0x000fde0003800000ULL,
0x0000000334347232ULL, 0x08afe40000200000ULL, 0x0000000336367232ULL, 0x000fe40000200000ULL,
0x0000000435357232ULL, 0x080fe40000200000ULL, 0x0000000437377232ULL, 0x000fce0000200000ULL,
0x0000000e68687c11ULL, 0x000fe2000f8e20ffULL, 0x00000bf000007945ULL, 0x000fe20003800000ULL,
0x000000ff3800720cULL, 0x000fe40003f45270ULL, 0x0000000e69697c11ULL, 0x000fe2000f8e20ffULL,
0x000000006838783bULL, 0x000f240000004200ULL, 0x000000ff383c7812ULL, 0x010fe400078ec0ffULL,
0x000000ff393d7812ULL, 0x000fe400078ec0ffULL, 0x0000003cff3c723eULL, 0x000fc400020006ffULL,
0x0000003dff51723eULL, 0x000fe400020006ffULL, 0x00000018ff3d7819ULL, 0x100fe20000011638ULL,
0x2000003cff507230ULL, 0x000fe20000004100ULL, 0x00000010ff3c7819ULL, 0x000fe20000011638ULL,
0x20000051ff517230ULL, 0x000fe20000004100ULL, 0x0000003dff3e723eULL, 0x000fe400020006ffULL,
0x00000010ff3d7819ULL, 0x000fe40000011639ULL, 0x0000ffff38387812ULL, 0x000fe200078ec0ffULL,
0x2000003eff6c7230ULL, 0x000fe20000004100ULL, 0x000000ff3d3f7812ULL, 0x000fc400078ec0ffULL,
0x000000ff3c3c7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff3d7819ULL, 0x000fe40000011638ULL,
0x0000003cff38723eULL, 0x000fe400020006ffULL, 0x0000003fff70723eULL, 0x000fe400020006ffULL,
0x0000003dff6a723eULL, 0x000fe200020006ffULL, 0x20000038ff387230ULL, 0x000fe20000004100ULL,
0x00000000693c783bULL, 0x000f220000004200ULL, 0x20000070ff717230ULL, 0x000fe20000004100ULL,
0x00000018ff6d7819ULL, 0x000fe20000011639ULL, 0x2000006aff6a7230ULL, 0x000fe20000004100ULL,
0x00000010ff707819ULL, 0x000fc40000011651ULL, 0x0000ffff39727812ULL, 0x000fe400078ec0ffULL,
0x00000010ff507819ULL, 0x000fe40000011650ULL, 0x00000010ff517819ULL, 0x000fe40000011638ULL,
0x0000006dff39723eULL, 0x000fe400020006ffULL, 0x00000010ff717819ULL, 0x000fe40000011671ULL,
0x00000010ff6d7819ULL, 0x000fc4000001166cULL, 0x00000010ff387819ULL, 0x000fe4000001166aULL,
0x00000008ff727819ULL, 0x000fe40000011672ULL, 0x0000105451507816ULL, 0x000fe40000000050ULL,
0x0000105471517816ULL, 0x000fe40000000070ULL, 0x000010546d387816ULL, 0x000fe40000000038ULL,
0x00000010ff717819ULL, 0x000fc4000001163aULL, 0x000000ff3a6d7812ULL, 0x000fe200078ec0ffULL,
0x000000503414723cULL, 0x008fe20000041814ULL, 0x00000072ff6a723eULL, 0x000fe400020006ffULL,
0x000000ff71717812ULL, 0x000fe400078ec0ffULL, 0x0000006dff73723eULL, 0x000fe200020006ffULL,
0x20000039ff6d7230ULL, 0x000fe20000004100ULL, 0x00000018ff727819ULL, 0x000fe2000001163aULL,
0x2000006aff397230ULL, 0x000fe20000004100ULL, 0x00000071ff71723eULL, 0x000fe200020006ffULL,
0x20000073ff737230ULL, 0x000fe20000004100ULL, 0x00000072ff6a723eULL, 0x000fc400020006ffULL,
0x0000ffff3a6c7812ULL, 0x000fe200078ec0ffULL, 0x20000071ff717230ULL, 0x000fe20000004100ULL,
0x00000010ff727819ULL, 0x000fe2000001166dULL, 0x2000006aff6a7230ULL, 0x000fe20000004100ULL,
0x00000010ff397819ULL, 0x000fe40000011639ULL, 0x00000010ff3a7819ULL, 0x000fe4000001163bULL,
0x0000105472397816ULL, 0x000fe40000000039ULL, 0x000000ff3b747812ULL, 0x000fc400078ec0ffULL,
0x000000ff3a727812ULL, 0x000fe400078ec0ffULL, 0x00000010ff3a7819ULL, 0x000fe20000011673ULL,
0x000000383418723cULL, 0x000fe20000041818ULL, 0x00000010ff717819ULL, 0x000fe40000011671ULL,
0x00000018ff707819ULL, 0x000fe4000001163bULL, 0x00000074ff74723eULL, 0x000fe400020006ffULL,
0x0000ffff3b3b7812ULL, 0x000fc400078ec0ffULL, 0x00001054713a7816ULL, 0x000fe2000000003aULL,
0x20000074ff6d7230ULL, 0x000fe20000004100ULL, 0x00000010ff717819ULL, 0x010fe4000001163cULL,
0x00000008ff3b7819ULL, 0x000fe4000001163bULL, 0x000000ff3c747812ULL, 0x000fe400078ec0ffULL,
0x000000ff71767812ULL, 0x000fe400078ec0ffULL, 0x00000008ff6c7819ULL, 0x000fc4000001166cULL,
0x00000072ff72723eULL, 0x000fe400020006ffULL, 0x00000070ff70723eULL, 0x000fe400020006ffULL,
0x0000003bff75723eULL, 0x000fe200020006ffULL, 0x20000072ff737230ULL, 0x000fe20000004100ULL,
0x00000074ff74723eULL, 0x000fe200020006ffULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x00000076ff76723eULL, 0x000fe200020006ffULL, 0x20000075ff507230ULL, 0x000fe20000004100ULL,
0x0000006cff6c723eULL, 0x000fe200020006ffULL, 0x20000074ff717230ULL, 0x000fe20000004100ULL,
0x00000010ff3b7819ULL, 0x000fe2000001166dULL, 0x20000076ff517230ULL, 0x000fe20000004100ULL,
0x00000010ff747819ULL, 0x000fe20000011673ULL, 0x2000006cff727230ULL, 0x000fe20000004100ULL,
0x00000010ff6d7819ULL, 0x000fc4000001166aULL, 0x00000010ff737819ULL, 0x000fe40000011670ULL,
0x00000010ff387819ULL, 0x000fe40000011650ULL, 0x00000010ff717819ULL, 0x000fe40000011671ULL,
0x00000010ff6a7819ULL, 0x000fe40000011651ULL, 0x00000018ff397819ULL, 0x000fe4000001163cULL,
0x00000010ff727819ULL, 0x000fc40000011672ULL, 0x00001054743b7816ULL, 0x000fe4000000003bULL,
0x0000105473517816ULL, 0x000fe40000000038ULL, 0x000010546a387816ULL, 0x000fe40000000071ULL,
0x00000039ff39723eULL, 0x000fe200020006ffULL, 0x0000003a341c723cULL, 0x000fe2000004181cULL,
0x000010546d507816ULL, 0x000fe40000000072ULL, 0x000000ff3e6a7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff707819ULL, 0x100fe4000001163eULL, 0x00000018ff727819ULL, 0x000fe2000001163eULL,
0x000000503420723cULL, 0x000fe20000041820ULL, 0x0000ffff3e6d7812ULL, 0x000fe400078ec0ffULL,
0x000000ff3f3e7812ULL, 0x000fe400078ec0ffULL, 0x0000006aff73723eULL, 0x000fe200020006ffULL,
0x20000039ff6a7230ULL, 0x000fe20000004100ULL, 0x00000018ff3a7819ULL, 0x000fc4000001163dULL,
0x00000010ff3b7819ULL, 0x000fe4000001163dULL, 0x0000003eff39723eULL, 0x000fe400020006ffULL,
0x000000ff3d6c7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff3c3c7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff757819ULL, 0x000fe4000001163fULL, 0x0000003aff3a723eULL, 0x000fc400020006ffULL,
0x00000072ff74723eULL, 0x000fe400020006ffULL, 0x00000010ff717819ULL, 0x000fe2000001163fULL,
0x2000003aff3e7230ULL, 0x000fe20000004100ULL, 0x000000ff3b727812ULL, 0x000fe200078ec0ffULL,
0x20000039ff3b7230ULL, 0x000fe20000004100ULL, 0x0000006cff6c723eULL, 0x000fe200020006ffULL,
0x20000073ff3a7230ULL, 0x000fe20000004100ULL, 0x0000ffff3d3d7812ULL, 0x000fe400078ec0ffULL,
0x00000075ff75723eULL, 0x000fe200020006ffULL, 0x2000006cff6c7230ULL, 0x000fe20000004100ULL,
0x00000008ff397819ULL, 0x000fe2000001163cULL, 0x20000074ff3c7230ULL, 0x000fe20000004100ULL,
0x000000ff71717812ULL, 0x000fc400078ec0ffULL, 0x0000ffff3f3f7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff737819ULL, 0x000fe2000001163dULL, 0x20000075ff3d7230ULL, 0x000fe20000004100ULL,
0x00000039ff39723eULL, 0x000fe400020006ffULL, 0x000000ff70707812ULL, 0x000fe400078ec0ffULL,
0x00000072ff72723eULL, 0x000fe400020006ffULL, 0x00000071ff75723eULL, 0x000fc400020006ffULL,
0x00000070ff74723eULL, 0x000fe200020006ffULL, 0x20000039ff707230ULL, 0x000fe20000004100ULL,
0x00000008ff6d7819ULL, 0x000fe2000001166dULL, 0x20000072ff727230ULL, 0x000fe20000004100ULL,
0x00000008ff3f7819ULL, 0x000fe2000001163fULL, 0x20000074ff747230ULL, 0x000fe20000004100ULL,
0x00000010ff397819ULL, 0x000fe2000001166cULL, 0x20000075ff6c7230ULL, 0x000fe20000004100ULL,
0x00000073ff73723eULL, 0x000fe400020006ffULL, 0x0000006dff6d723eULL, 0x000fc400020006ffULL,
0x0000003fff75723eULL, 0x000fe200020006ffULL, 0x20000073ff717230ULL, 0x000fe20000004100ULL,
0x00000010ff727819ULL, 0x000fe20000011672ULL, 0x2000006dff6d7230ULL, 0x000fe20000004100ULL,
0x00000010ff3f7819ULL, 0x000fe2000001166aULL, 0x20000075ff6a7230ULL, 0x000fe20000004100ULL,
0x0000105472397816ULL, 0x000fe40000000039ULL, 0x00000010ff727819ULL, 0x000fe4000001163eULL,
0x00000010ff3e7819ULL, 0x000fc40000011670ULL, 0x00000010ff517819ULL, 0x000fe2000001163cULL,
0x000000383424723cULL, 0x000fe20000041824ULL, 0x00000010ff507819ULL, 0x000fe4000001163dULL,
0x00000010ff3a7819ULL, 0x000fe4000001163aULL, 0x00000010ff717819ULL, 0x000fe40000011671ULL,
0x00000010ff737819ULL, 0x000fe40000011674ULL, 0x00000010ff3b7819ULL, 0x000fc4000001163bULL,
0x00000010ff6c7819ULL, 0x000fe4000001166cULL, 0x00000010ff3c7819ULL, 0x000fe4000001166dULL,
0x00000010ff3d7819ULL, 0x000fe4000001166aULL, 0x000010543f3e7816ULL, 0x000fe4000000003eULL,
0x00001054723f7816ULL, 0x000fe40000000071ULL, 0x00001054733a7816ULL, 0x000fc4000000003aULL,
0x000010546c3b7816ULL, 0x000fe4000000003bULL, 0x00001054513c7816ULL, 0x000fe2000000003cULL,
0x0000003e3428723cULL, 0x000fe20000041828ULL, 0x00001054503d7816ULL, 0x000fca000000003dULL,
0x0000003a342c723cULL, 0x000fec000004182cULL, 0x0000003c3430723cULL, 0x000fe20000041830ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000404947ULL, 0x000fde0001000000ULL,
0x000000140b0b7221ULL, 0x000fe20000010000ULL, 0x000000150c0c7221ULL, 0x000fe20000010000ULL,
0x000000180f0f7221ULL, 0x000fe20000010000ULL, 0x0000001910107221ULL, 0x000fe20000010000ULL,
0x0000001c41417221ULL, 0x000fe20000010000ULL, 0x0000001d42427221ULL, 0x000fe20000010000ULL,
0x0000002045457221ULL, 0x000fe20000010000ULL, 0x0000002146467221ULL, 0x000fe20000010000ULL,
0x0000002449497221ULL, 0x000fe20000010000ULL, 0x000000254a4a7221ULL, 0x000fe20000010000ULL,
0x000000284d4d7221ULL, 0x000fe20000010000ULL, 0x000000294e4e7221ULL, 0x000fe20000010000ULL,
0x0000002c53537221ULL, 0x000fe20000010000ULL, 0x0000002d54547221ULL, 0x000fe20000010000ULL,
0x0000003057577221ULL, 0x000fe20000010000ULL, 0x0000003158587221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x000000ffff157224ULL, 0x002fc600078e006fULL, 0x0000000000405947ULL, 0x000fea0003000000ULL,
0x000000160d0d7221ULL, 0x000fe20000010000ULL, 0x000000170e0e7221ULL, 0x000fe20000010000ULL,
0x0000001a11117221ULL, 0x000fe20000010000ULL, 0x0000001b40407221ULL, 0x000fe20000010000ULL,
0x0000001e43437221ULL, 0x000fe20000010000ULL, 0x0000001f44447221ULL, 0x000fe20000010000ULL,
0x0000002247477221ULL, 0x000fe20000010000ULL, 0x0000002348487221ULL, 0x000fe20000010000ULL,
0x000000264b4b7221ULL, 0x000fe20000010000ULL, 0x000000274c4c7221ULL, 0x000fe20000010000ULL,
0x0000002a4f4f7221ULL, 0x000fe20000010000ULL, 0x0000002b52527221ULL, 0x000fe20000010000ULL,
0x0000002e55557221ULL, 0x000fe20000010000ULL, 0x0000002f56567221ULL, 0x000fe20000010000ULL,
0x0000003259597221ULL, 0x000fe20000010000ULL, 0x000000335a5a7221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000001ff147424ULL, 0x000fe400078e00ffULL,
0x000000016b6b7836ULL, 0x000fe40000000000ULL, 0x018b8814ff1679a7ULL, 0x000e620008500007ULL,
0x00000004146a7807ULL, 0x000fc80000000000ULL, 0x0000006a6b00720cULL, 0x000fe20003f46070ULL,
0x000000ffff1c7224ULL, 0x002fd800078e0017ULL, 0xffffff9c007ca947ULL, 0x000fea000383ffffULL,
0x018b5814ffff79a7ULL, 0x0003e40008500007ULL, 0x0000004008147811ULL, 0x002fc800078e40ffULL,
0x0000000914007c0cULL, 0x000fda000bf46070ULL, 0x0000011800ec2947ULL, 0x000fea0003800000ULL,
0x000000ffff6b7224ULL, 0x000fce00078e00ffULL, 0x00000002ff147819ULL, 0x000fe4000001166bULL,
0x000000036b1b7812ULL, 0x040fe400078ec0ffULL, 0x000000146b147207ULL, 0x000fe40000000000ULL,
0x000000ff1b1b7207ULL, 0x000fc60004000000ULL, 0x00000001141f7836ULL, 0x000fca0000000000ULL,
0x000000031f1d7812ULL, 0x040fe400078ec0ffULL, 0x000000081f1a7211ULL, 0x004fce00078ff0ffULL,
0x0000000000187805ULL, 0x000fce0000015200ULL, 0x018b7815ff0075a7ULL, 0x000e640008040147ULL,
0x00000000005c2947ULL, 0x002fea0003800000ULL, 0x000000ffff1e7224ULL, 0x000fce00078e00ffULL,
0x000000101e00780cULL, 0x000fda0003f46270ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000001618217210ULL, 0x000fca0007f5e1ffULL,
0x0000000117177824ULL, 0x000fe200010e0e19ULL, 0x003d09002100780cULL, 0x000fc80003f46070ULL,
0x000000ff1700720cULL, 0x000fda0003f46320ULL, 0x000000000008a947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c402100780cULL, 0x000fc80003f46070ULL, 0x000000ff1700720cULL, 0x000fda0003f46320ULL,
0x00000000001ca947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011417ULL,
0x0000002114147211ULL, 0x000fca00078510ffULL, 0x000000ffff177224ULL, 0x000fca00010e0617ULL,
0x0000000214147819ULL, 0x000fc80000001217ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011e1e7836ULL, 0x000fce0000000000ULL,
0x018b7815ff0075a7ULL, 0x000e640008040147ULL, 0xfffffffc00a8a947ULL, 0x002fea000383ffffULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x018b881cff0075a7ULL, 0x000e640008040147ULL,
0x00000000005c2947ULL, 0x002fea0003800000ULL, 0x000000ffff187224ULL, 0x000fce00078e00ffULL,
0x000000101800780cULL, 0x000fda0003f46270ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x0000001416197210ULL, 0x000fca0007f5e1ffULL,
0x0000000115157824ULL, 0x000fe200010e0e17ULL, 0x003d09001900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x000000000008a947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x00000000001ca947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001914147211ULL, 0x000fca00078510ffULL, 0x000000ffff157224ULL, 0x000fca00010e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000118187836ULL, 0x000fce0000000000ULL,
0x018b881cff0075a7ULL, 0x000e640008040147ULL, 0xfffffffc00a8a947ULL, 0x002fea000383ffffULL,
0x000000011a157836ULL, 0x000fe20000000000ULL, 0x00000004ff707819ULL, 0x000fe20000011612ULL,
0x000000041a147824ULL, 0x000fc600078e021dULL, 0x0000000c15007c0cULL, 0x000fe4000bf46070ULL,
0x0000002014187811ULL, 0x000fc800078e30ffULL, 0x000000605b1c7812ULL, 0x000fce00078ef818ULL,
0x000000040054a947ULL, 0x000fea0003800000ULL, 0x000000015d237824ULL, 0x000fe200078e0270ULL,
0x0000000918167c48ULL, 0x000fe2000ffe0000ULL, 0x00000010121e7824ULL, 0x000fe200078e00ffULL,
0x00016000070e7890ULL, 0x000fe2000fffe03fULL, 0x0000000270227836ULL, 0x000fe20000000000ULL,
0x0000000723207c11ULL, 0x040fe2000f8e10ffULL, 0x0000000116167824ULL, 0x000fe200078e0a18ULL,
0x000000f01e257812ULL, 0x000fe200078ec0ffULL, 0x0000000123187824ULL, 0x000fe400078e021cULL,
0x018a000020147984ULL, 0x000e620000000800ULL, 0x000000165d167248ULL, 0x000fe20007fe0000ULL,
0x000000015d277824ULL, 0x000fc800078e0222ULL, 0x0000000116217824ULL, 0x000fe400078e0a5dULL,
0x0000000127247824ULL, 0x000fc600078e0212ULL, 0x000000217000720cULL, 0x000fe40003f46070ULL,
0x0000000714197c11ULL, 0x002fe4000f8e10ffULL, 0x00008a00ff147b82ULL, 0x000e660000000a00ULL,
0x018ac00019177984ULL, 0x0007240000000800ULL, 0x0000000127197824ULL, 0x048fe400078e021cULL,
0x0000001027277824ULL, 0x000fca00078e00ffULL, 0xfffffff027247812ULL, 0x000fe200078ee224ULL,
0x0000000617177c24ULL, 0x010fe4000f8e0218ULL, 0x0000000123187824ULL, 0x000fe400078e0212ULL,
0x0000010017167825ULL, 0x002fc800078e0014ULL, 0x0000001023237824ULL, 0x000fe200078e00ffULL,
0x0000002516167210ULL, 0x000fc80007f7e0ffULL, 0xfffffff023187812ULL, 0x000fe200078ee218ULL,
0x000000ffff177224ULL, 0x000fc600018e0617ULL, 0x0000000e18237c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e2000d101c4aULL,
0x000000212200720cULL, 0x000fe20003f46070ULL, 0x0000000470227836ULL, 0x000fe40000000000ULL,
0x018a080020187984ULL, 0x000ee40000000800ULL, 0x000000015d277824ULL, 0x000fe200078e0222ULL,
0x0000000e24237c11ULL, 0x002fc6000f8e20ffULL, 0x0000000127247824ULL, 0x000fe200078e0212ULL,
0x00000007181e7c11ULL, 0x008fca000f8e10ffULL, 0x018ac0001e187984ULL, 0x000e640000000800ULL,
0x0000000618197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000002518167210ULL, 0x000fca0007f7e0ffULL, 0x000000ffff177224ULL, 0x000fe400018e0619ULL,
0x0000000127197824ULL, 0x040fe400078e021cULL, 0x0000001027277824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e2000d101c4aULL,
0x000000212200720cULL, 0x000fc60003f46070ULL, 0x018a100020187984ULL, 0x000ee20000000800ULL,
0xfffffff027247812ULL, 0x000fc800078ee224ULL, 0x0000000e24237c11ULL, 0x002fe4000f8e20ffULL,
0x00000007181e7c11ULL, 0x008fca000f8e10ffULL, 0x018ac0001e187984ULL, 0x0002e40000000800ULL,
0x00000006701e7836ULL, 0x002fc80000000000ULL, 0x000000015d277824ULL, 0x000fe400078e021eULL,
0x0000000618197c24ULL, 0x008fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000002518167210ULL, 0x000fca0007f7e0ffULL, 0x000000ffff177224ULL, 0x000fe400018e0619ULL,
0x0000000127197824ULL, 0x040fe400078e021cULL, 0x00000001271c7824ULL, 0x040fe200078e0212ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e2000d101c4aULL,
0x0000001027277824ULL, 0x000fe200078e00ffULL, 0x000000211e00720cULL, 0x000fe40003f46070ULL,
0x018a180020187984ULL, 0x000ee40000000800ULL, 0xfffffff0271c7812ULL, 0x000fc800078ee21cULL,
0x0000000e1c177c11ULL, 0x002fe4000f8e20ffULL, 0x0000000718187c11ULL, 0x008fcc000f8e10ffULL,
0x018ac00018187984ULL, 0x000e640000000800ULL, 0x0000000618197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019147825ULL, 0x000fc600078e0014ULL, 0x0000002514147210ULL, 0x000fca0007f7e0ffULL,
0x000000ffff157224ULL, 0x000fca00018e0615ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014177faeULL, 0x0003e2000d101c4aULL, 0x0000000400247947ULL, 0x000fea0003800000ULL,
0x000000015d237824ULL, 0x000fe200078e0270ULL, 0x00016000070e7890ULL, 0x000fe2000fffe03fULL,
0x0000001012197824ULL, 0x000fe400078e00ffULL, 0x0000000123177824ULL, 0x040fe200078e021cULL,
0x0000000723207c11ULL, 0x040fe2000f8e10ffULL, 0x00000010231e7824ULL, 0x000fe200078e00ffULL,
0x000000f019257812ULL, 0x000fe200078ec0ffULL, 0x0000000123197824ULL, 0x000fe400078e0212ULL,
0x018a000020147984ULL, 0x000e620000000800ULL, 0x0000000223277836ULL, 0x000fc40000000000ULL,
0xfffffff01e197812ULL, 0x000fe400078ee219ULL, 0x0000000127227824ULL, 0x000fe400078e0212ULL,
0x0000000e19217c11ULL, 0x000fe2000f8e20ffULL, 0x0000000127197824ULL, 0x040fe400078e021cULL,
0x0000001027277824ULL, 0x000fe200078e00ffULL, 0x0000000714187c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e660000000a00ULL, 0x018ac00018167984ULL, 0x000ee40000000800ULL,
0x0000000616177c24ULL, 0x008fc8000f8e0217ULL, 0x0000010017167825ULL, 0x002fc600078e0014ULL,
0x0000002516167210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff177224ULL, 0x000fca00010e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016217faeULL, 0x0003e8000b901c4aULL,
0x018a080020187984ULL, 0x000ee20000000800ULL, 0xfffffff027217812ULL, 0x002fe200078ee222ULL,
0x0000000423277836ULL, 0x000fe40000000000ULL, 0x0000000623237836ULL, 0x000fe20000000000ULL,
0x0000000e21217c11ULL, 0x000fe2000f8e20ffULL, 0x0000000127177824ULL, 0x000fc400078e021cULL,
0x0000000127227824ULL, 0x040fe400078e0212ULL, 0x0000001027277824ULL, 0x000fe200078e00ffULL,
0x00000007181e7c11ULL, 0x008fca000f8e10ffULL, 0x018ac0001e187984ULL, 0x000e640000000800ULL,
0x0000000618197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000002518187210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff197224ULL, 0x000fca00010e0619ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018217faeULL, 0x0003e8000b901c4aULL,
0x018a100020167984ULL, 0x000ee20000000800ULL, 0xfffffff027197812ULL, 0x002fe200078ee222ULL,
0x0000000123217824ULL, 0x040fe400078e021cULL, 0x00000001231c7824ULL, 0x000fe200078e0212ULL,
0x0000000e19197c11ULL, 0x000fe2000f8e20ffULL, 0x0000001023237824ULL, 0x000fe200078e00ffULL,
0x00000007161e7c11ULL, 0x008fca000f8e10ffULL, 0x018ac0001e167984ULL, 0x000e640000000800ULL,
0x0000000616177c24ULL, 0x002fc8000f8e0217ULL, 0x0000010017167825ULL, 0x000fc600078e0014ULL,
0x0000002516167210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff177224ULL, 0x000fca00010e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016197faeULL, 0x0003e8000b901c4aULL,
0x018a180020187984ULL, 0x000ee20000000800ULL, 0xfffffff023177812ULL, 0x002fc800078ee21cULL,
0x0000000e17177c11ULL, 0x000fe4000f8e20ffULL, 0x0000000718187c11ULL, 0x008fcc000f8e10ffULL,
0x018ac00018187984ULL, 0x000e640000000800ULL, 0x0000000618217c24ULL, 0x002fc8000f8e0221ULL,
0x0000010021147825ULL, 0x000fc600078e0014ULL, 0x0000002514147210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff157224ULL, 0x000fca00010e0615ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014177faeULL, 0x0003e6000b901c4aULL, 0x00000001ff147424ULL, 0x002fcc00078e00ffULL,
0x018b8814ff1479a7ULL, 0x000e640008500007ULL, 0x000000ffff187224ULL, 0x002fce00078e0015ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x018b8818ff0075a7ULL, 0x000e640008040147ULL,
0x00000000005c2947ULL, 0x002fea0003800000ULL, 0x000000ffff1c7224ULL, 0x000fce00078e00ffULL,
0x000000101c00780cULL, 0x000fda0003f46270ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x0000001416197210ULL, 0x000fca0007f5e1ffULL,
0x0000000115157824ULL, 0x000fe200010e0e17ULL, 0x003d09001900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x000000000008a947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x00000000001ca947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001914147211ULL, 0x000fca00078510ffULL, 0x000000ffff157224ULL, 0x000fca00010e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011c1c7836ULL, 0x000fce0000000000ULL,
0x018b8818ff0075a7ULL, 0x000e640008040147ULL, 0xfffffffc00a8a947ULL, 0x002fea000383ffffULL,
0x0000001a5f00720cULL, 0x000fe20003f44070ULL, 0x00000001ff1c7424ULL, 0x000fe200078e00ffULL,
0x000000011f1f7812ULL, 0x000fe200078ec0ffULL, 0x00000020616e7824ULL, 0x000fe200078e0212ULL,
0x000000031b00780cULL, 0x000fc80005745270ULL, 0x000000011f00780cULL, 0x000fda0001745470ULL,
0x00000000004c2947ULL, 0x000fea0003800000ULL, 0x000000036e00780cULL, 0x000fe20003f44070ULL,
0x0000000104047890ULL, 0x000fe2000fffe03fULL, 0x0000010000007945ULL, 0x000ff60003800000ULL,
0x0000000000382947ULL, 0x000fea0003800000ULL, 0x00009000ff177b82ULL, 0x000e620000000800ULL,
0x000000050400728cULL, 0x000fe2000bf06070ULL, 0x0000000413167824ULL, 0x000fe200078e026eULL,
0x000000076e197c11ULL, 0x000fc6000f8e10ffULL, 0x0000000216167824ULL, 0x000fe200078e00ffULL,
0x000000000000781cULL, 0x000fe20003f4f008ULL, 0x00008c00ff147b82ULL, 0x000ee20000000a00ULL,
0x0000000417187c36ULL, 0x002fc80008000000ULL, 0x0000001716177224ULL, 0x000fc800078e0218ULL,
0x0000000417147825ULL, 0x008fca00078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x18ac000014197faeULL, 0x0003e4000d12184aULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000019000007945ULL, 0x000fe80003800000ULL, 0x00000000005c1947ULL, 0x000fea0003800000ULL,
0x0000001a5f00720cULL, 0x000fe20003f44070ULL, 0x000000011b147836ULL, 0x002fe20000000000ULL,
0x00009400ff187b82ULL, 0x000e680000000800ULL, 0x0000000314167812ULL, 0x000fc800078ec0ffULL,
0x000000ff16197207ULL, 0x000fc60005000000ULL, 0x00000002ff14a819ULL, 0x000fe40000011614ULL,
0x000000015c167824ULL, 0x000fc600078e0219ULL, 0x000000011d1d7824ULL, 0x000fe400078e0214ULL,
0x00009200ff147b82ULL, 0x000ee40000000a00ULL, 0x000000401d177824ULL, 0x040fe200078e00ffULL,
0x0000001a1d1a7211ULL, 0x000fc800078ff0ffULL, 0x000000c017177812ULL, 0x000fca00078ec0ffULL,
0x000001001a177824ULL, 0x000fc800078e0217ULL, 0x000000016e197824ULL, 0x100fe400078e0217ULL,
0x0000001816177224ULL, 0x002fc600078e0217ULL, 0x0000000919007c0cULL, 0x000fe2000bf46070ULL,
0x000000016e177824ULL, 0x040fe200078e0217ULL, 0x000000076e197c11ULL, 0x000fc6000f8e10ffULL,
0x0000000417147825ULL, 0x008fd000078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x18a0000014197faeULL, 0x0003e4000d12184aULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a4dULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x018b801cff6c79a7ULL, 0x0002e20008500007ULL,
0x000000ff6b00720cULL, 0x000fe20003f45270ULL, 0x00000008636c7836ULL, 0x008fd80000000000ULL,
0x00000004008c2947ULL, 0x002fea0003800000ULL, 0x018af81c5d1479a7ULL, 0x000e640008500007ULL,
0x000000ffff187224ULL, 0x002fce00078e0015ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x018af8185d0075a7ULL, 0x000e640008040147ULL, 0x00000000005c2947ULL, 0x002fea0003800000ULL,
0x000000ffff197224ULL, 0x000fce00078e00ffULL, 0x000000101900780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x0000001416147210ULL, 0x000fca0007f5e1ffULL, 0x0000000115157824ULL, 0x000fe200010e0e17ULL,
0x003d09001400780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401400780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff077819ULL, 0x000fc80000011415ULL, 0x0000001407077211ULL, 0x000fca00078510ffULL,
0x000000ffff147224ULL, 0x000fca00010e0615ULL, 0x0000000207077819ULL, 0x000fc80000001214ULL,
0x000000070000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000119197836ULL, 0x000fce0000000000ULL, 0x018af8185d0075a7ULL, 0x000e640008040147ULL,
0xfffffffc00a8a947ULL, 0x002fea000383ffffULL, 0x0000001012077824ULL, 0x000fe200078e00ffULL,
0x00000001ff147819ULL, 0x000fe20000011612ULL, 0x000000ffff167224ULL, 0x000fc600078e0009ULL,
0x0000007007077812ULL, 0x000fe400078ec0ffULL, 0x0000000c14147812ULL, 0x000fc800078ec0ffULL,
0x00000007141b7c10ULL, 0x000fca000fffe007ULL, 0x018080001b147984ULL, 0x000e680000000800ULL,
0x018280001b157984ULL, 0x0006e20000000800ULL, 0x000000091400720bULL, 0x002fda0003f5d000ULL,
0x0000000000077806ULL, 0x000fc800010e0100ULL, 0x0000ffff07187812ULL, 0x000fe2000784c0ffULL,
0x00000001ff077424ULL, 0x000fd800078e00ffULL, 0x0000000000e0a947ULL, 0x00cfea0003800000ULL,
0x000000091400720bULL, 0x000fe40003f54000ULL, 0x000000016100780cULL, 0x000fe40003f65270ULL,
0x0000001409167209ULL, 0x000fd20007810000ULL, 0x0000000000197806ULL, 0x000fe400010e0100ULL,
0x018480161b00b388ULL, 0x0003e40000000800ULL, 0x0000991019177816ULL, 0x000fc800000000ffULL,
0x000000ff1700720cULL, 0x000fda0003f45270ULL, 0x0000000000a8a947ULL, 0x002fea0003800000ULL,
0x8000001609097221ULL, 0x000fe20000010000ULL, 0x000000ff19ff7812ULL, 0x040fe4000784c0ffULL,
0x0000ff0019ff7812ULL, 0x000fe2000786c0ffULL, 0x3fb8aa3b09097820ULL, 0x000fc80000410000ULL,
0x0000000900177308ULL, 0x0002ac0000000800ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x00001f6317097589ULL, 0x006e6400000e0000ULL, 0x000000090b0b7220ULL, 0x082fe20000410000ULL,
0x000000090c0c7220ULL, 0x080fe20000410000ULL, 0x000000090f0f7220ULL, 0x080fe20000410000ULL,
0x0000000910107220ULL, 0x080fe20000410000ULL, 0x0000000941417220ULL, 0x080fe20000410000ULL,
0x0000000942427220ULL, 0x080fe20000410000ULL, 0x0000000945457220ULL, 0x080fe20000410000ULL,
0x0000000946467220ULL, 0x080fe20000410000ULL, 0x0000000949497220ULL, 0x080fe20000410000ULL,
0x000000094a4a7220ULL, 0x080fe20000410000ULL, 0x000000094d4d7220ULL, 0x080fe20000410000ULL,
0x000000094e4e7220ULL, 0x080fe20000410000ULL, 0x0000000953537220ULL, 0x080fe20000410000ULL,
0x0000000954547220ULL, 0x080fe20000410000ULL, 0x0000000957577220ULL, 0x080fe20000410000ULL,
0x0000000958587220ULL, 0x000fce0000410000ULL, 0x000000170a0a7220ULL, 0x004fe20000410000ULL,
0x000000000044b947ULL, 0x000fec0003800000ULL, 0x00001f6c17097589ULL, 0x002e6400000e0000ULL,
0x000000090d0d7220ULL, 0x082fe20000410000ULL, 0x000000090e0e7220ULL, 0x080fe20000410000ULL,
0x0000000911117220ULL, 0x080fe20000410000ULL, 0x0000000940407220ULL, 0x080fe20000410000ULL,
0x0000000943437220ULL, 0x080fe20000410000ULL, 0x0000000944447220ULL, 0x080fe20000410000ULL,
0x0000000947477220ULL, 0x080fe20000410000ULL, 0x0000000948487220ULL, 0x080fe20000410000ULL,
0x000000094b4b7220ULL, 0x080fe20000410000ULL, 0x000000094c4c7220ULL, 0x080fe20000410000ULL,
0x000000094f4f7220ULL, 0x080fe20000410000ULL, 0x0000000952527220ULL, 0x080fe20000410000ULL,
0x0000000955557220ULL, 0x080fe20000410000ULL, 0x0000000956567220ULL, 0x080fe20000410000ULL,
0x0000000959597220ULL, 0x080fe20000410000ULL, 0x000000095a5a7220ULL, 0x000fce0000410000ULL,
0x0000ffff18ff7812ULL, 0x000fda0007846019ULL, 0x8000001614142221ULL, 0x000fe20000010000ULL,
0x00007610ff072816ULL, 0x000fc60000000007ULL, 0x3fb8aa3b14142820ULL, 0x000fc80000410000ULL,
0x0000001400062308ULL, 0x000ea40000000800ULL, 0x0000000615152220ULL, 0x004fce0000410000ULL,
0x0000000a150a7221ULL, 0x000fe20000010000ULL, 0x000000ffff097224ULL, 0x002fce00078e0016ULL,
0x000000ff07ff7812ULL, 0x000fda000784c0ffULL, 0x0000000000102947ULL, 0x000fea0003800000ULL,
0x00000006ff03723eULL, 0x000fc800000010ffULL, 0x0000541003147816ULL, 0x000fca0000000003ULL,
0x00001f6314037589ULL, 0x0002e800000e0000ULL, 0x00001f6c14047589ULL, 0x0002a400000e0000ULL,
0x01280000051c783bULL, 0x0002e20000000200ULL, 0x0000000000102947ULL, 0x000fea0003800000ULL,
0x000000031c1c7232ULL, 0x088fe40000200000ULL, 0x000000031e1e7232ULL, 0x000fe40000200000ULL,
0x000000041d1d7232ULL, 0x084fe40000200000ULL, 0x000000041f1f7232ULL, 0x000fce0000200000ULL,
0x000000000214783bULL, 0x002e680000004200ULL, 0x000000000018783bULL, 0x000f220000004200ULL,
0x00000018ff207819ULL, 0x102fe40000011614ULL, 0x000000ff16257812ULL, 0x000fe400078ec0ffULL,
0x00000020ff20723eULL, 0x000fe400020006ffULL, 0x00000010ff377819ULL, 0x000fc40000011614ULL,
0x000000ff14217812ULL, 0x040fe200078ec0ffULL, 0x20000020ff2b7230ULL, 0x000fe20000004100ULL,
0x0000ffff14367812ULL, 0x000fe400078ec0ffULL, 0x00000010ff347819ULL, 0x100fe40000011615ULL,
0x000000ff15237812ULL, 0x040fe400078ec0ffULL, 0x00000018ff227819ULL, 0x000fe40000011615ULL,
0x0000ffff15357812ULL, 0x000fc400078ec0ffULL, 0x00000018ff387819ULL, 0x000fe40000011617ULL,
0x00000018ff147819ULL, 0x010fe4000001161aULL, 0x00000025ff25723eULL, 0x000fe400020006ffULL,
0x00000018ff157819ULL, 0x000fe4000001161bULL, 0x000000ff17397812ULL, 0x000fe200078ec0ffULL,
0x20000025ff267230ULL, 0x000fe20000004100ULL, 0x00000038ff20723eULL, 0x000fc400020006ffULL,
0x00000014ff14723eULL, 0x000fe400020006ffULL, 0x00000010ff337819ULL, 0x000fe20000011616ULL,
0x20000020ff207230ULL, 0x000fe20000004100ULL, 0x00000015ff38723eULL, 0x000fe200020006ffULL,
0x20000014ff157230ULL, 0x000fe20000004100ULL, 0x0000ffff162e7812ULL, 0x000fe400078ec0ffULL,
0x00000039ff25723eULL, 0x000fe200020006ffULL, 0x20000038ff147230ULL, 0x000fe20000004100ULL,
0x00000008ff397819ULL, 0x000fc40000011635ULL, 0x000000ff37377812ULL, 0x000fe200078ec0ffULL,
0x20000025ff257230ULL, 0x000fe20000004100ULL, 0x000000ff33337812ULL, 0x000fe400078ec0ffULL,
0x00000008ff2e7819ULL, 0x000fe4000001162eULL, 0x000000ff34387812ULL, 0x000fe400078ec0ffULL,
0x00000039ff39723eULL, 0x000fe400020006ffULL, 0x00000037ff34723eULL, 0x000fc400020006ffULL,
0x00000010ff2f7819ULL, 0x000fe40000011617ULL, 0x0000ffff17317812ULL, 0x000fe200078ec0ffULL,
0x20000034ff347230ULL, 0x000fe20000004100ULL, 0x00000010ff307819ULL, 0x000fe40000011618ULL,
0x00000033ff37723eULL, 0x000fe200020006ffULL, 0x20000039ff337230ULL, 0x000fe20000004100ULL,
0x0000002eff2e723eULL, 0x000fe400020006ffULL, 0x0000ffff192d7812ULL, 0x000fc400078ec0ffULL,
0x00000038ff35723eULL, 0x000fe400020006ffULL, 0x00000010ff287819ULL, 0x000fe4000001161aULL,
0x000000ff2f2f7812ULL, 0x000fe200078ec0ffULL, 0x20000035ff357230ULL, 0x000fe20000004100ULL,
0x00000008ff387819ULL, 0x000fe20000011631ULL, 0x20000037ff317230ULL, 0x000fe20000004100ULL,
0x000000ff30397812ULL, 0x000fe200078ec0ffULL, 0x2000002eff377230ULL, 0x000fe20000004100ULL,
0x00000010ff2a7819ULL, 0x000fc4000001161bULL, 0x00000008ff2e7819ULL, 0x000fe4000001162dULL,
0x00000018ff247819ULL, 0x000fe40000011616ULL, 0x0000002fff2f723eULL, 0x000fe400020006ffULL,
0x00000039ff39723eULL, 0x000fe400020006ffULL, 0x000000ff28287812ULL, 0x000fe200078ec0ffULL,
0x2000002fff307230ULL, 0x000fe20000004100ULL, 0x000000ff1b167812ULL, 0x000fe200078ec0ffULL,
0x20000039ff2d7230ULL, 0x000fe20000004100ULL, 0x00000038ff38723eULL, 0x000fc400020006ffULL,
0x0000ffff1b1b7812ULL, 0x000fe400078ec0ffULL, 0x0000002eff2e723eULL, 0x000fe200020006ffULL,
0x20000038ff2f7230ULL, 0x000fe20000004100ULL, 0x000000ff2a2a7812ULL, 0x000fe400078ec0ffULL,
0x00000021ff21723eULL, 0x000fe400020006ffULL, 0x00000028ff28723eULL, 0x000fe400020006ffULL,
0x00000010ff297819ULL, 0x000fe20000011619ULL, 0x20000021ff277230ULL, 0x000fe20000004100ULL,
0x00000008ff397819ULL, 0x000fc4000001161bULL, 0x0000002aff38723eULL, 0x000fe200020006ffULL,
0x2000002eff2a7230ULL, 0x000fe20000004100ULL, 0x000000ff183b7812ULL, 0x040fe200078ec0ffULL,
0x20000028ff2e7230ULL, 0x000fe20000004100ULL, 0x00000018ff3a7819ULL, 0x000fe40000011618ULL,
0x0000ffff18327812ULL, 0x000fe400078ec0ffULL, 0x000000ff193c7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff187819ULL, 0x000fc40000011619ULL, 0x000000ff1a3d7812ULL, 0x040fe400078ec0ffULL,
0x00000023ff23723eULL, 0x000fe400020006ffULL, 0x0000ffff1a1a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff29297812ULL, 0x000fe200078ec0ffULL, 0x20000023ff2c7230ULL, 0x000fe20000004100ULL,
0x00000039ff28723eULL, 0x000fe400020006ffULL, 0x00000022ff22723eULL, 0x000fc400020006ffULL,
0x00000024ff17723eULL, 0x000fe400020006ffULL, 0x0000003cff19723eULL, 0x000fe200020006ffULL,
0x20000022ff247230ULL, 0x000fe20000004100ULL, 0x00000018ff18723eULL, 0x000fe200020006ffULL,
0x20000017ff237230ULL, 0x000fe20000004100ULL, 0x0000003bff21723eULL, 0x000fe200020006ffULL,
0x20000019ff197230ULL, 0x000fe20000004100ULL, 0x00000029ff29723eULL, 0x000fe200020006ffULL,
0x20000018ff187230ULL, 0x000fe20000004100ULL, 0x00000008ff1a7819ULL, 0x000fe2000001161aULL,
0x20000021ff217230ULL, 0x000fe20000004100ULL, 0x00000010ff3c7819ULL, 0x000fe20000011627ULL,
0x20000028ff277230ULL, 0x000fe20000004100ULL, 0x00000008ff367819ULL, 0x000fe20000011636ULL,
0x20000029ff297230ULL, 0x000fe20000004100ULL, 0x00000008ff327819ULL, 0x000fc40000011632ULL,
0x00000010ff267819ULL, 0x000fe40000011626ULL, 0x00000010ff317819ULL, 0x000fe40000011631ULL,
0x00000010ff257819ULL, 0x000fe40000011625ULL, 0x00000010ff287819ULL, 0x000fe40000011630ULL,
0x0000001aff1a723eULL, 0x000fe400020006ffULL, 0x00000010ff207819ULL, 0x000fc40000011620ULL,
0x00000010ff2f7819ULL, 0x000fe2000001162fULL, 0x2000001aff1b7230ULL, 0x000fe20000004100ULL,
0x0000003aff22723eULL, 0x000fe200020006ffULL, 0x20000038ff1a7230ULL, 0x000fe20000004100ULL,
0x0000003dff17723eULL, 0x000fe400020006ffULL, 0x00000016ff16723eULL, 0x000fe200020006ffULL,
0x20000022ff227230ULL, 0x000fe20000004100ULL, 0x00000036ff36723eULL, 0x000fe200020006ffULL,
0x20000017ff177230ULL, 0x000fe20000004100ULL, 0x00000032ff32723eULL, 0x000fe200020006ffULL,
0x20000016ff167230ULL, 0x000fe20000004100ULL, 0x00000010ff2c7819ULL, 0x000fe2000001162cULL,
0x20000036ff367230ULL, 0x000fe20000004100ULL, 0x00000010ff357819ULL, 0x000fe20000011635ULL,
0x20000032ff327230ULL, 0x000fe20000004100ULL, 0x0000105431307816ULL, 0x000fc40000000026ULL,
0x0000105428317816ULL, 0x000fe40000000025ULL, 0x00000010ff287819ULL, 0x000fe4000001162dULL,
0x00001054202d7816ULL, 0x000fe4000000002fULL, 0x00001054353d7816ULL, 0x000fe4000000002cULL,
0x00000010ff207819ULL, 0x000fe40000011618ULL, 0x00000010ff247819ULL, 0x000fc40000011624ULL,
0x00000010ff237819ULL, 0x000fe40000011623ULL, 0x00000010ff337819ULL, 0x000fe40000011633ULL,
0x00000010ff2c7819ULL, 0x000fe40000011637ULL, 0x00000010ff217819ULL, 0x000fe40000011621ULL,
0x00000010ff197819ULL, 0x000fe40000011619ULL, 0x00000010ff187819ULL, 0x000fc40000011629ULL,
0x00000010ff397819ULL, 0x000fe4000001162bULL, 0x00000010ff2b7819ULL, 0x000fe40000011634ULL,
0x0000105424357816ULL, 0x000fe40000000033ULL, 0x00001054232c7816ULL, 0x000fe4000000002cULL,
0x0000105428287816ULL, 0x000fe40000000021ULL, 0x00000010ff257819ULL, 0x000fc4000001162aULL,
0x0000105418297816ULL, 0x000fe40000000019ULL, 0x00000010ff347819ULL, 0x000fe40000011636ULL,
0x00000010ff237819ULL, 0x000fe40000011622ULL, 0x00000010ff247819ULL, 0x000fe40000011632ULL,
0x00000010ff177819ULL, 0x000fe20000011617ULL, 0x000000301c30723cULL, 0x008fe200000418ffULL,
0x00000010ff2e7819ULL, 0x000fc4000001162eULL, 0x00000010ff187819ULL, 0x000fe40000011615ULL,
0x00000010ff167819ULL, 0x000fe40000011616ULL, 0x00000010ff217819ULL, 0x000fe4000001161aULL,
0x00000010ff1b7819ULL, 0x000fe4000001161bULL, 0x00000010ff1a7819ULL, 0x000fe40000011614ULL,
0x00000010ff157819ULL, 0x000fc40000011627ULL, 0x0000105420257816ULL, 0x000fe40000000025ULL,
0x000010542b3c7816ULL, 0x000fe4000000003cULL, 0x0000105439347816ULL, 0x000fe20000000034ULL,
0x000000281c28723cULL, 0x000fe200000418ffULL, 0x0000105423247816ULL, 0x000fe40000000024ULL,
0x000010542e207816ULL, 0x000fe40000000017ULL, 0x0000105421217816ULL, 0x000fe20000000016ULL,
0x0000003c1c3c723cULL, 0x000fe200000418ffULL, 0x0000105418147816ULL, 0x000fc4000000001bULL,
0x000010541a157816ULL, 0x000fe40000000015ULL, 0x012800005e18783bULL, 0x0002e20000000200ULL,
0x000000341c34723cULL, 0x000fec00000418ffULL, 0x0000002c1c2c723cULL, 0x000fec00000418ffULL,
0x000000241c24723cULL, 0x000fec00000418ffULL, 0x000000201c20723cULL, 0x000fec00000418ffULL,
0x000000141c1c723cULL, 0x000fe200000418ffULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000102947ULL, 0x002fde0003800000ULL, 0x0000000318187232ULL, 0x088fe40000200000ULL,
0x000000031a1a7232ULL, 0x000fe40000200000ULL, 0x0000000419197232ULL, 0x084fe40000200000ULL,
0x000000041b1b7232ULL, 0x000fce0000200000ULL, 0x000000006214783bULL, 0x000e620000004200ULL,
0x0000006b6300720cULL, 0x080fe20003f66070ULL, 0x00000c3000007945ULL, 0x000fe20003800000ULL,
0x000000085f00720cULL, 0x0c0fe40003fc3070ULL, 0x0000006b6c00720cULL, 0x000fe40003f86070ULL,
0x000000085f00720cULL, 0x000fe40003fa3070ULL, 0x00000010ff387819ULL, 0x002fe40000011614ULL,
0x00000010ff3a7819ULL, 0x000fc40000011615ULL, 0x000000ff14397812ULL, 0x000fe400078ec0ffULL,
0x000000ff38387812ULL, 0x000fe400078ec0ffULL, 0x000000ff3a3a7812ULL, 0x000fe400078ec0ffULL,
0x00000039ff39723eULL, 0x000fe400020006ffULL, 0x00000038ff38723eULL, 0x000fe400020006ffULL,
0x0000003aff50723eULL, 0x000fe200020006ffULL, 0x20000039ff397230ULL, 0x000fe20000004100ULL,
0x000000ff153b7812ULL, 0x000fe200078ec0ffULL, 0x20000038ff3a7230ULL, 0x000fe20000004100ULL,
0x00000018ff387819ULL, 0x000fe20000011614ULL, 0x20000050ff727230ULL, 0x000fe20000004100ULL,
0x0000003bff3b723eULL, 0x000fc400020006ffULL, 0x00000010ff397819ULL, 0x000fe40000011639ULL,
0x00000010ff3a7819ULL, 0x000fe2000001163aULL, 0x2000003bff717230ULL, 0x000fe20000004100ULL,
0x00000038ff51723eULL, 0x000fe400020006ffULL, 0x000010543a507816ULL, 0x000fe40000000039ULL,
0x000000006038783bULL, 0x000e620000004200ULL, 0x00000010ff717819ULL, 0x000fe40000011671ULL,
0x00000010ff727819ULL, 0x000fc40000011672ULL, 0x00000018ff6f7819ULL, 0x000fe40000011615ULL,
0x0000ffff14747812ULL, 0x000fe200078ec0ffULL, 0x20000051ff147230ULL, 0x000fe20000004100ULL,
0x000000ff16737812ULL, 0x000fe400078ec0ffULL, 0x0000105472517816ULL, 0x000fe40000000071ULL,
0x0000006fff6f723eULL, 0x000fe400020006ffULL, 0x0000ffff15157812ULL, 0x000fc400078ec0ffULL,
0x00000008ff717819ULL, 0x000fe20000011674ULL, 0x00000050183c723cULL, 0x008fe2000004183cULL,
0x00000073ff73723eULL, 0x000fe400020006ffULL, 0x00000008ff727819ULL, 0x000fe20000011615ULL,
0x2000006fff157230ULL, 0x000fe20000004100ULL, 0x00000071ff71723eULL, 0x000fe200020006ffULL,
0x20000073ff6f7230ULL, 0x000fe20000004100ULL, 0x000000ff17747812ULL, 0x000fe400078ec0ffULL,
0x00000010ff737819ULL, 0x000fe20000011616ULL, 0x20000071ff717230ULL, 0x000fe20000004100ULL,
0x00000072ff72723eULL, 0x000fc400020006ffULL, 0x00000074ff50723eULL, 0x000fe400020006ffULL,
0x000000ff73747812ULL, 0x000fe200078ec0ffULL, 0x20000072ff727230ULL, 0x000fe20000004100ULL,
0x00000010ff737819ULL, 0x000fe40000011614ULL, 0x00000010ff147819ULL, 0x000fe40000011671ULL,
0x00000074ff71723eULL, 0x000fe400020006ffULL, 0x00000010ff747819ULL, 0x000fc40000011615ULL,
0x0000105473147816ULL, 0x000fe40000000014ULL, 0x00000010ff157819ULL, 0x000fe20000011672ULL,
0x20000071ff727230ULL, 0x000fe20000004100ULL, 0x00000010ff737819ULL, 0x000fe40000011617ULL,
0x00000018ff517819ULL, 0x000fe40000011616ULL, 0x0000ffff16717812ULL, 0x000fe400078ec0ffULL,
0x000000ff73737812ULL, 0x000fc400078ec0ffULL, 0x00000010ff167819ULL, 0x000fe4000001166fULL,
0x00000010ff6f7819ULL, 0x000fe40000011672ULL, 0x00000018ff727819ULL, 0x000fe40000011617ULL,
0x0000105474157816ULL, 0x000fe40000000015ULL, 0x00000073ff73723eULL, 0x000fe400020006ffULL,
0x0000ffff17757812ULL, 0x000fe200078ec0ffULL, 0x20000050ff177230ULL, 0x000fe20000004100ULL,
0x000010546f167816ULL, 0x000fe20000000016ULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x00000072ff6f723eULL, 0x000fe200020006ffULL, 0x000000141834723cULL, 0x000fe20000041834ULL,
0x00000008ff727819ULL, 0x000fc40000011671ULL, 0x000000ff38747812ULL, 0x002fe200078ec0ffULL,
0x2000006fff6f7230ULL, 0x000fe20000004100ULL, 0x00000008ff717819ULL, 0x000fe40000011675ULL,
0x00000051ff51723eULL, 0x000fe400020006ffULL, 0x00000072ff72723eULL, 0x000fe400020006ffULL,
0x00000010ff147819ULL, 0x000fe20000011638ULL, 0x20000051ff517230ULL, 0x000fe20000004100ULL,
0x00000074ff50723eULL, 0x000fe200020006ffULL, 0x20000072ff727230ULL, 0x000fe20000004100ULL,
0x00000071ff71723eULL, 0x000fc400020006ffULL, 0x00000010ff157819ULL, 0x000fe20000011639ULL,
0x20000050ff507230ULL, 0x000fe20000004100ULL, 0x00000010ff177819ULL, 0x000fe20000011617ULL,
0x20000071ff717230ULL, 0x000fe20000004100ULL, 0x00000010ff747819ULL, 0x000fe40000011673ULL,
0x000000ff39737812ULL, 0x000fe400078ec0ffULL, 0x000000ff14147812ULL, 0x000fe400078ec0ffULL,
0x000000ff15157812ULL, 0x000fc400078ec0ffULL, 0x0000105474177816ULL, 0x000fe40000000017ULL,
0x00000073ff74723eULL, 0x000fe400020006ffULL, 0x00000014ff73723eULL, 0x000fe400020006ffULL,
0x00000015ff75723eULL, 0x000fe200020006ffULL, 0x000000161830723cULL, 0x000fe20000041830ULL,
0x00000010ff157819ULL, 0x000fe20000011651ULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x00000010ff147819ULL, 0x000fe20000011672ULL, 0x20000075ff757230ULL, 0x000fe20000004100ULL,
0x00000010ff727819ULL, 0x000fe2000001166fULL, 0x20000074ff517230ULL, 0x000fe20000004100ULL,
0x00000010ff717819ULL, 0x000fc40000011671ULL, 0x0000105415147816ULL, 0x000fe40000000014ULL,
0x0000105472157816ULL, 0x000fe40000000071ULL, 0x00000018ff167819ULL, 0x000fe40000011638ULL,
0x00000010ff177819ULL, 0x000fe40000011650ULL, 0x00000010ff727819ULL, 0x000fe20000011673ULL,
0x00000014182c723cULL, 0x000fe2000004182cULL, 0x00000010ff747819ULL, 0x000fc40000011675ULL,
0x00000016ff50723eULL, 0x000fe400020006ffULL, 0x0000105472167816ULL, 0x000fe40000000017ULL,
0x0000ffff38757812ULL, 0x000fe400078ec0ffULL, 0x00000010ff717819ULL, 0x000fe40000011651ULL,
0x00000010ff727819ULL, 0x000fe4000001163aULL, 0x000000ff3a157812ULL, 0x000fc400078ec0ffULL,
0x00000018ff147819ULL, 0x000fe4000001163aULL, 0x0000ffff3a387812ULL, 0x000fe400078ec0ffULL,
0x000000ff3b3a7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff6f7819ULL, 0x000fe40000011639ULL,
0x0000ffff39737812ULL, 0x000fe200078ec0ffULL, 0x20000050ff397230ULL, 0x000fe20000004100ULL,
0x0000105474177816ULL, 0x000fc40000000071ULL, 0x00000015ff15723eULL, 0x000fe400020006ffULL,
0x00000018ff747819ULL, 0x100fe4000001163bULL, 0x0000003aff50723eULL, 0x000fe200020006ffULL,
0x000000161828723cULL, 0x000fe20000041828ULL, 0x0000006fff51723eULL, 0x000fe400020006ffULL,
0x00000010ff717819ULL, 0x000fe4000001163bULL, 0x0000ffff3b6f7812ULL, 0x000fe200078ec0ffULL,
0x20000051ff517230ULL, 0x000fe20000004100ULL, 0x00000008ff3a7819ULL, 0x000fc40000011675ULL,
0x00000014ff3b723eULL, 0x000fe200020006ffULL, 0x20000015ff147230ULL, 0x000fe20000004100ULL,
0x00000008ff737819ULL, 0x000fe20000011673ULL, 0x20000050ff157230ULL, 0x000fe20000004100ULL,
0x00000074ff74723eULL, 0x000fe400020006ffULL, 0x0000003aff50723eULL, 0x000fe200020006ffULL,
0x2000003bff3a7230ULL, 0x000fe20000004100ULL, 0x000000ff72727812ULL, 0x000fe200078ec0ffULL,
0x20000074ff3b7230ULL, 0x000fe20000004100ULL, 0x00000073ff73723eULL, 0x000fc400020006ffULL,
0x000000ff71747812ULL, 0x000fe200078ec0ffULL, 0x20000050ff717230ULL, 0x000fe20000004100ULL,
0x00000072ff72723eULL, 0x000fe200020006ffULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x00000008ff387819ULL, 0x000fe40000011638ULL, 0x00000074ff75723eULL, 0x000fe200020006ffULL,
0x20000072ff507230ULL, 0x000fe20000004100ULL, 0x00000038ff74723eULL, 0x000fe400020006ffULL,
0x00000010ff397819ULL, 0x000fc40000011639ULL, 0x00000010ff387819ULL, 0x000fe20000011671ULL,
0x20000074ff717230ULL, 0x000fe20000004100ULL, 0x00000010ff727819ULL, 0x000fe40000011651ULL,
0x00000010ff737819ULL, 0x000fe40000011673ULL, 0x0000105439387816ULL, 0x000fe40000000038ULL,
0x00000008ff6f7819ULL, 0x000fe4000001166fULL, 0x0000105472397816ULL, 0x000fc40000000073ULL,
0x0000006fff76723eULL, 0x000fe200020006ffULL, 0x20000075ff6f7230ULL, 0x000fe20000004100ULL,
0x00000010ff177819ULL, 0x000fe40000011615ULL, 0x00000010ff147819ULL, 0x000fe20000011614ULL,
0x000000381824723cULL, 0x000fe20000041824ULL, 0x20000076ff517230ULL, 0x000fe20000004100ULL,
0x00000010ff157819ULL, 0x000fe40000011650ULL, 0x00000010ff3a7819ULL, 0x000fe4000001163aULL,
0x00000010ff727819ULL, 0x000fe2000001163bULL, 0x000000016b387836ULL, 0x000fe20000000000ULL,
0x00000010ff507819ULL, 0x000fc4000001166fULL, 0x00000010ff717819ULL, 0x000fe40000011671ULL,
0x000000386300720cULL, 0x000fe40005f66470ULL, 0x00000010ff517819ULL, 0x000fe40000011651ULL,
0x0000105415167816ULL, 0x000fe40000000014ULL, 0x0000105450177816ULL, 0x000fe40000000017ULL,
0x000010543a147816ULL, 0x000fc40000000071ULL, 0x0000105472157816ULL, 0x000fe40000000051ULL,
0x000000386c00720cULL, 0x000fe20006786470ULL, 0x000000161820723cULL, 0x000fec0000041820ULL,
0x00000014181c723cULL, 0x000fe2000004181cULL, 0x00000001ff167424ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000403947ULL, 0x000fde0003000000ULL,
0x0000003c0b0b7221ULL, 0x000fe20000010000ULL, 0x0000003d0c0c7221ULL, 0x000fe20000010000ULL,
0x000000340f0f7221ULL, 0x000fe20000010000ULL, 0x0000003510107221ULL, 0x000fe20000010000ULL,
0x0000003041417221ULL, 0x000fe20000010000ULL, 0x0000003142427221ULL, 0x000fe20000010000ULL,
0x0000002c45457221ULL, 0x000fe20000010000ULL, 0x0000002d46467221ULL, 0x000fe20000010000ULL,
0x0000002849497221ULL, 0x000fe20000010000ULL, 0x000000294a4a7221ULL, 0x000fe20000010000ULL,
0x000000244d4d7221ULL, 0x000fe20000010000ULL, 0x000000254e4e7221ULL, 0x000fe20000010000ULL,
0x0000002053537221ULL, 0x000fe20000010000ULL, 0x0000002154547221ULL, 0x000fe20000010000ULL,
0x0000001c57577221ULL, 0x000fe20000010000ULL, 0x0000001d58587221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000012000007945ULL, 0x000fe80003800000ULL,
0x0000000000404947ULL, 0x000fea0002800000ULL, 0x0000003e0d0d7221ULL, 0x000fe20000010000ULL,
0x0000003f0e0e7221ULL, 0x000fe20000010000ULL, 0x0000003611117221ULL, 0x000fe20000010000ULL,
0x0000003740407221ULL, 0x000fe20000010000ULL, 0x0000003243437221ULL, 0x000fe20000010000ULL,
0x0000003344447221ULL, 0x000fe20000010000ULL, 0x0000002e47477221ULL, 0x000fe20000010000ULL,
0x0000002f48487221ULL, 0x000fe20000010000ULL, 0x0000002a4b4b7221ULL, 0x000fe20000010000ULL,
0x0000002b4c4c7221ULL, 0x000fe20000010000ULL, 0x000000264f4f7221ULL, 0x000fe20000010000ULL,
0x0000002752527221ULL, 0x000fe20000010000ULL, 0x0000002255557221ULL, 0x000fe20000010000ULL,
0x0000002356567221ULL, 0x000fe20000010000ULL, 0x0000001e59597221ULL, 0x000fe20000010000ULL,
0x0000001f5a5a7221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x018b8816ff1479a7ULL, 0x000e620008500007ULL, 0x00000002ff177819ULL, 0x000fe40000011638ULL,
0x000000085f00720cULL, 0x0c0fe40003fc3070ULL, 0x0000001738177207ULL, 0x040fe40000000000ULL,
0x00000003381a7812ULL, 0x000fe400078ec0ffULL, 0x000000085f00720cULL, 0x000fe20003fa3070ULL,
0x0000000117177836ULL, 0x000fe20000000000ULL, 0x00000040ff387803ULL, 0x000fc40000000000ULL,
0x000000ff1a1a7207ULL, 0x000fe40004000000ULL, 0x00000003171b7812ULL, 0x040fe400078ec0ffULL,
0x00000008171c7211ULL, 0x000fe200078ff0ffULL, 0x000000ffff187224ULL, 0x002fce00078e0015ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x018b806dff0075a7ULL, 0x000e6400080c0147ULL,
0x00000000005c6947ULL, 0x002fea0003800000ULL, 0x000000ffff1d7224ULL, 0x000fce00078e00ffULL,
0x000000101d00780cULL, 0x000fda0003fc6270ULL, 0x000000000044e947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x0000001416197210ULL, 0x000fca0007fde1ffULL,
0x0000000115157824ULL, 0x000fe200030e0e17ULL, 0x003d09001900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x000000000008e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x00000000001ce947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001914147211ULL, 0x000fca00078d10ffULL, 0x000000ffff157224ULL, 0x000fca00030e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011d1d7836ULL, 0x000fce0000000000ULL,
0x018b806dff0075a7ULL, 0x000e6400080c0147ULL, 0xfffffffc00a8e947ULL, 0x002fea000383ffffULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x018b8818ff0075a7ULL, 0x000e6400080c0147ULL,
0x00000000005c6947ULL, 0x002fea0003800000ULL, 0x000000ffff1d7224ULL, 0x000fce00078e00ffULL,
0x000000101d00780cULL, 0x000fda0003fc6270ULL, 0x000000000044e947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x0000001416197210ULL, 0x000fca0007fde1ffULL,
0x0000000115157824ULL, 0x000fe200030e0e17ULL, 0x003d09001900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x000000000008e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x00000000001ce947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001914147211ULL, 0x000fca00078d10ffULL, 0x000000ffff157224ULL, 0x000fca00030e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011d1d7836ULL, 0x000fce0000000000ULL,
0x018b8818ff0075a7ULL, 0x000e6400080c0147ULL, 0xfffffffc00a8e947ULL, 0x002fea000383ffffULL,
0x000000041c147824ULL, 0x000fc800078e021bULL, 0x00000040141e7824ULL, 0x000fe400078e00ffULL,
0x000000011c147836ULL, 0x000fc60000000000ULL, 0x000000405b1d7812ULL, 0x000fe400078ef81eULL,
0x0000000c14007c0cULL, 0x000fda000bfc6070ULL, 0x000000040054e947ULL, 0x000fea0003800000ULL,
0x000000015d207824ULL, 0x000fe200078e0270ULL, 0x000000091e187c48ULL, 0x000fe2000ffe0000ULL,
0x00000010121f7824ULL, 0x000fe200078e00ffULL, 0x00014000070e7890ULL, 0x000fe2000fffe03fULL,
0x0000000120177824ULL, 0x040fe200078e021dULL, 0x0000000720227c11ULL, 0x000fe2000f8e10ffULL,
0x0000000118187824ULL, 0x000fe200078e0a1eULL, 0x000000f01f1f7812ULL, 0x000fc600078ec0ffULL,
0x018a000022147984ULL, 0x000e620000000800ULL, 0x000000185d187248ULL, 0x000fca0007fe0000ULL,
0x0000000118217824ULL, 0x000fe200078e0a5dULL, 0x0000000714197c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e660000000a00ULL, 0x018ac00019167984ULL, 0x0007240000000800ULL,
0x0000000120197824ULL, 0x048fe400078e0212ULL, 0x0000001020207824ULL, 0x000fca00078e00ffULL,
0xfffffff020197812ULL, 0x000fe200078ee219ULL, 0x0000000270207836ULL, 0x000fc60000000000ULL,
0x0000000e19237c11ULL, 0x000fe2000f8e20ffULL, 0x000000015d247824ULL, 0x000fc800078e0220ULL,
0x0000000124197824ULL, 0x000fe400078e021dULL, 0x0000000616177c24ULL, 0x010fc8000f8e0217ULL,
0x0000010017167825ULL, 0x002fc600078e0014ULL, 0x0000001f16167210ULL, 0x000fca0007fde0ffULL,
0x000000ffff177224ULL, 0x000fe200030e0617ULL, 0x000000217000720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e8000f101c4aULL,
0x018a080022187984ULL, 0x000ee20000000800ULL, 0x0000000124167824ULL, 0x042fe400078e0212ULL,
0x0000001024177824ULL, 0x000fca00078e00ffULL, 0xfffffff017167812ULL, 0x000fc800078ee216ULL,
0x0000000e16237c11ULL, 0x000fe4000f8e20ffULL, 0x00000007181e7c11ULL, 0x008fca000f8e10ffULL,
0x018ac0001e187984ULL, 0x000e640000000800ULL, 0x0000000618197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000001f18187210ULL, 0x000fca0007fde0ffULL,
0x000000ffff197224ULL, 0x000fe200030e0619ULL, 0x000000212000720cULL, 0x000fe20003fc6070ULL,
0x0000000470207836ULL, 0x000fe40000000000ULL, 0x0000000670707836ULL, 0x000fe40000000000ULL,
0x000000015d247824ULL, 0x000fc800078e0220ULL, 0x0000000124177824ULL, 0x000fc800078e021dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018237faeULL, 0x0003e8000f101c4aULL,
0x018a100022167984ULL, 0x000ee20000000800ULL, 0x0000000124187824ULL, 0x042fe400078e0212ULL,
0x0000001024197824ULL, 0x000fca00078e00ffULL, 0xfffffff019187812ULL, 0x000fc800078ee218ULL,
0x0000000e18197c11ULL, 0x000fe4000f8e20ffULL, 0x00000007161e7c11ULL, 0x008fca000f8e10ffULL,
0x018ac0001e167984ULL, 0x0002e40000000800ULL, 0x000000015d1e7824ULL, 0x002fc800078e0270ULL,
0x000000011e1d7824ULL, 0x000fe400078e021dULL, 0x0000000616177c24ULL, 0x008fc8000f8e0217ULL,
0x0000010017167825ULL, 0x000fc600078e0014ULL, 0x0000001f16167210ULL, 0x000fca0007fde0ffULL,
0x000000ffff177224ULL, 0x000fe200030e0617ULL, 0x000000212000720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016197faeULL, 0x0003e8000f101c4aULL,
0x018a180022187984ULL, 0x000ee20000000800ULL, 0x000000011e167824ULL, 0x042fe400078e0212ULL,
0x000000101e177824ULL, 0x000fca00078e00ffULL, 0xfffffff017167812ULL, 0x000fc800078ee216ULL,
0x0000000e16177c11ULL, 0x000fe4000f8e20ffULL, 0x0000000718187c11ULL, 0x008fcc000f8e10ffULL,
0x018ac00018187984ULL, 0x000e640000000800ULL, 0x00000006181d7c24ULL, 0x002fc8000f8e021dULL,
0x000001001d147825ULL, 0x000fc600078e0014ULL, 0x0000001f14147210ULL, 0x000fca0007fde0ffULL,
0x000000ffff157224ULL, 0x000fe200030e0615ULL, 0x000000217000720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e2000f101c4aULL,
0x0000000400247947ULL, 0x000fea0003800000ULL, 0x000000015d707824ULL, 0x000fe200078e0270ULL,
0x00014000070e7890ULL, 0x000fe2000fffe03fULL, 0x0000001012197824ULL, 0x000fe400078e00ffULL,
0x0000000170177824ULL, 0x040fe200078e021dULL, 0x00000007701f7c11ULL, 0x040fe2000f8e10ffULL,
0x00000010701e7824ULL, 0x040fe200078e00ffULL, 0x000000f019217812ULL, 0x000fe200078ec0ffULL,
0x0000000170197824ULL, 0x000fe400078e0212ULL, 0x018a00001f147984ULL, 0x000e620000000800ULL,
0x0000000270207836ULL, 0x000fc40000000000ULL, 0xfffffff01e197812ULL, 0x000fe400078ee219ULL,
0x0000000120227824ULL, 0x040fe400078e0212ULL, 0x0000000e19237c11ULL, 0x000fe2000f8e20ffULL,
0x0000000120197824ULL, 0x000fe200078e021dULL, 0x0000000714187c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e660000000a00ULL, 0x018ac00018167984ULL, 0x000ee40000000800ULL,
0x0000000616177c24ULL, 0x008fc8000f8e0217ULL, 0x0000010017167825ULL, 0x002fc600078e0014ULL,
0x0000002116167210ULL, 0x000fca0007fde0ffULL, 0x000000ffff177224ULL, 0x000fca00030e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e8000b901c4aULL,
0x018a08001f187984ULL, 0x000ee20000000800ULL, 0x0000001020177824ULL, 0x002fe400078e00ffULL,
0x0000000470207836ULL, 0x000fe40000000000ULL, 0x0000000670707836ULL, 0x000fe20000000000ULL,
0xfffffff017227812ULL, 0x000fe200078ee222ULL, 0x0000000120177824ULL, 0x000fc400078e021dULL,
0x00000001701d7824ULL, 0x000fe200078e021dULL, 0x0000000e22237c11ULL, 0x000fe2000f8e20ffULL,
0x0000000120227824ULL, 0x000fe200078e0212ULL, 0x00000007181e7c11ULL, 0x008fca000f8e10ffULL,
0x018ac0001e187984ULL, 0x000e640000000800ULL, 0x0000000618197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000002118187210ULL, 0x000fca0007fde0ffULL,
0x000000ffff197224ULL, 0x000fca00030e0619ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018237faeULL, 0x0003e8000b901c4aULL, 0x018a10001f167984ULL, 0x000ee20000000800ULL,
0x0000001020197824ULL, 0x002fca00078e00ffULL, 0xfffffff019227812ULL, 0x000fc800078ee222ULL,
0x0000000e22197c11ULL, 0x000fe4000f8e20ffULL, 0x00000007161e7c11ULL, 0x008fca000f8e10ffULL,
0x018ac0001e167984ULL, 0x000e640000000800ULL, 0x0000000616177c24ULL, 0x002fc8000f8e0217ULL,
0x0000010017167825ULL, 0x000fc600078e0014ULL, 0x0000002116167210ULL, 0x000fca0007fde0ffULL,
0x000000ffff177224ULL, 0x000fca00030e0617ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016197faeULL, 0x0003e8000b901c4aULL, 0x018a18001f187984ULL, 0x000ee40000000800ULL,
0x0000000718187c11ULL, 0x008fcc000f8e10ffULL, 0x018ac00018187984ULL, 0x000ee40000000800ULL,
0x00000006181d7c24ULL, 0x008fc8000f8e021dULL, 0x000001001d147825ULL, 0x000fc800078e0014ULL,
0x00000001701d7824ULL, 0x040fe200078e0212ULL, 0x0000002114147210ULL, 0x000fe20007fde0ffULL,
0x0000001070707824ULL, 0x000fc800078e00ffULL, 0x000000ffff157224ULL, 0x000fe200030e0615ULL,
0xfffffff0701d7812ULL, 0x000fc800078ee21dULL, 0x0000000e1d1d7c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000141d7faeULL, 0x0003e4000b901c4aULL,
0x00000001ff147424ULL, 0x002fcc00078e00ffULL, 0x018b8814ff1479a7ULL, 0x000e640008500007ULL,
0x000000ffff187224ULL, 0x002fce00078e0015ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x018b8818ff0075a7ULL, 0x000e6400080c0147ULL, 0x00000000005c6947ULL, 0x002fea0003800000ULL,
0x000000ffff1d7224ULL, 0x000fce00078e00ffULL, 0x000000101d00780cULL, 0x000fda0003fc6270ULL,
0x000000000044e947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x0000001416197210ULL, 0x000fca0007fde1ffULL, 0x0000000115157824ULL, 0x000fe200030e0e17ULL,
0x003d09001900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x000000000008e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x00000000001ce947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078d10ffULL,
0x000000ffff157224ULL, 0x000fca00030e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011d1d7836ULL, 0x000fce0000000000ULL, 0x018b8818ff0075a7ULL, 0x000e6400080c0147ULL,
0xfffffffc00a8e947ULL, 0x002fea000383ffffULL, 0x0000019000007945ULL, 0x000fe20003800000ULL,
0x00000001ff6f7424ULL, 0x000fc600078e00ffULL, 0x0000000000581947ULL, 0x000fea0003800000ULL,
0x0000001c5f00720cULL, 0x000fe20003fc4070ULL, 0x00009400ff187b82ULL, 0x000e620000000800ULL,
0x000000076e197c11ULL, 0x000fe4000f8e10ffULL, 0x000000ff1a147207ULL, 0x040fe40003000000ULL,
0x000000ff1a177207ULL, 0x000fc60007000000ULL, 0x000000011b1b7824ULL, 0x000fe400078e0214ULL,
0x00009200ff147b82ULL, 0x000ee20000000a00ULL, 0x000000015c177824ULL, 0x000fe400078e0217ULL,
0x000000401b167824ULL, 0x040fe200078e00ffULL, 0x0000001c1b1b7211ULL, 0x000fc800078ff0ffULL,
0x000000c016167812ULL, 0x000fca00078ec0ffULL, 0x000001001b167824ULL, 0x000fc800078e0216ULL,
0x0000002016167836ULL, 0x000fc80000000000ULL, 0x0000001817177224ULL, 0x102fe400078e0216ULL,
0x000000016e167824ULL, 0x040fe400078e0216ULL, 0x000000016e177824ULL, 0x000fc600078e0217ULL,
0x0000000916007c0cULL, 0x000fe2000bfc6070ULL, 0x0000000417147825ULL, 0x008fd800078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18a0000014197faeULL, 0x0003e4000f12184aULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a48ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x018b786fff6e79a7ULL, 0x000e620008500007ULL, 0x0000000000102947ULL, 0x000fea0003800000ULL,
0x00000006ff03723eULL, 0x000fc800000010ffULL, 0x0000541003147816ULL, 0x000fca0000000003ULL,
0x00001f6c14047589ULL, 0x0044e800000e0000ULL, 0x00001f6314037589ULL, 0x00046400000e0000ULL,
0x012800006630783bULL, 0x0006a20000000200ULL, 0x0000000000102947ULL, 0x000fea0003800000ULL,
0x0000000330307232ULL, 0x086fe40000200000ULL, 0x0000000332327232ULL, 0x000fe40000200000ULL,
0x0000000431317232ULL, 0x088fe40000200000ULL, 0x0000000433337232ULL, 0x000fce0000200000ULL,
0x000000006514783bULL, 0x004ea80000004200ULL, 0x000000006418783bULL, 0x000f220000004200ULL,
0x0000ffff162a7812ULL, 0x044fe400078ec0ffULL, 0x00000010ff2b7819ULL, 0x000fe40000011617ULL,
0x000000ff16227812ULL, 0x000fe400078ec0ffULL, 0x00000008ff2a7819ULL, 0x000fc4000001162aULL,
0x000000ff2b2b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff151f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff2f7819ULL, 0x100fe40000011616ULL, 0x00000018ff207819ULL, 0x000fe40000011616ULL,
0x0000ffff182e7812ULL, 0x010fe400078ec0ffULL, 0x00000022ff22723eULL, 0x000fc400020006ffULL,
0x00000018ff167819ULL, 0x000fe40000011617ULL, 0x000000ff17237812ULL, 0x040fe400078ec0ffULL,
0x0000ffff172c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff18267812ULL, 0x000fe400078ec0ffULL,
0x000000ff193a7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff3b7819ULL, 0x000fc4000001161aULL,
0x0000002aff2a723eULL, 0x000fe400020006ffULL, 0x0000002bff2b723eULL, 0x000fe400020006ffULL,
0x00000010ff2d7819ULL, 0x100fe40000011618ULL, 0x00000018ff177819ULL, 0x000fe40000011618ULL,
0x00000010ff217819ULL, 0x100fe40000011619ULL, 0x00000018ff397819ULL, 0x000fc40000011619ULL,
0x0000ffff19277812ULL, 0x000fe400078ec0ffULL, 0x00000010ff357819ULL, 0x100fe40000011615ULL,
0x00000018ff1e7819ULL, 0x000fe40000011615ULL, 0x0000ffff15347812ULL, 0x000fe400078ec0ffULL,
0x00000010ff187819ULL, 0x000fe4000001161aULL, 0x000000ff1a3c7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff1a247812ULL, 0x000fe400078ec0ffULL, 0x0000001fff1f723eULL, 0x000fe400020006ffULL,
0x00000020ff19723eULL, 0x000fe200020006ffULL, 0x20000022ff207230ULL, 0x000fe20000004100ULL,
0x00000008ff2e7819ULL, 0x000fe2000001162eULL, 0x2000001fff297230ULL, 0x000fe20000004100ULL,
0x00000010ff257819ULL, 0x000fe2000001161bULL, 0x20000019ff197230ULL, 0x000fe20000004100ULL,
0x000000ff1b3d7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff1a7819ULL, 0x000fe4000001161bULL,
0x0000ffff1b157812ULL, 0x000fe400078ec0ffULL, 0x00000016ff16723eULL, 0x000fe400020006ffULL,
0x00000026ff26723eULL, 0x000fe400020006ffULL, 0x0000003aff1b723eULL, 0x000fe200020006ffULL,
0x2000002aff3a7230ULL, 0x000fe20000004100ULL, 0x0000003bff22723eULL, 0x000fe200020006ffULL,
0x2000002bff3b7230ULL, 0x000fe20000004100ULL, 0x00000010ff377819ULL, 0x000fe20000011614ULL,
0x20000016ff1f7230ULL, 0x000fe20000004100ULL, 0x00000039ff39723eULL, 0x000fe200020006ffULL,
0x20000026ff167230ULL, 0x000fe20000004100ULL, 0x0000002eff2a723eULL, 0x000fe200020006ffULL,
0x2000001bff1b7230ULL, 0x000fe20000004100ULL, 0x000000ff212b7812ULL, 0x000fe200078ec0ffULL,
0x20000022ff227230ULL, 0x000fe20000004100ULL, 0x0000ffff14367812ULL, 0x040fe200078ec0ffULL,
0x2000002aff217230ULL, 0x000fe20000004100ULL, 0x000000ff141d7812ULL, 0x000fc400078ec0ffULL,
0x000000ff37377812ULL, 0x000fe400078ec0ffULL, 0x0000001aff26723eULL, 0x000fe200020006ffULL,
0x20000039ff1a7230ULL, 0x000fe20000004100ULL, 0x000000ff35357812ULL, 0x000fe400078ec0ffULL,
0x00000008ff2c7819ULL, 0x000fe2000001162cULL, 0x20000026ff267230ULL, 0x000fe20000004100ULL,
0x0000002bff2b723eULL, 0x000fe400020006ffULL, 0x00000008ff277819ULL, 0x000fc40000011627ULL,
0x00000018ff1c7819ULL, 0x000fe40000011614ULL, 0x00000008ff397819ULL, 0x000fe40000011636ULL,
0x000000ff252a7812ULL, 0x000fe200078ec0ffULL, 0x2000002bff257230ULL, 0x000fe20000004100ULL,
0x0000001dff14723eULL, 0x000fe400020006ffULL, 0x00000037ff36723eULL, 0x000fe400020006ffULL,
0x00000035ff35723eULL, 0x000fe200020006ffULL, 0x20000014ff147230ULL, 0x000fe20000004100ULL,
0x0000002cff2c723eULL, 0x000fe200020006ffULL, 0x20000036ff367230ULL, 0x000fe20000004100ULL,
0x00000008ff247819ULL, 0x000fe20000011624ULL, 0x20000035ff377230ULL, 0x000fe20000004100ULL,
0x00000027ff27723eULL, 0x000fe200020006ffULL, 0x2000002cff2e7230ULL, 0x000fe20000004100ULL,
0x00000008ff347819ULL, 0x000fc40000011634ULL, 0x0000002aff2b723eULL, 0x000fe200020006ffULL,
0x20000027ff2c7230ULL, 0x000fe20000004100ULL, 0x000000ff2f2f7812ULL, 0x000fe400078ec0ffULL,
0x00000024ff24723eULL, 0x000fe200020006ffULL, 0x2000002bff277230ULL, 0x000fe20000004100ULL,
0x00000008ff157819ULL, 0x000fe40000011615ULL, 0x0000001cff1c723eULL, 0x000fe200020006ffULL,
0x20000024ff2a7230ULL, 0x000fe20000004100ULL, 0x0000001eff1e723eULL, 0x000fc400020006ffULL,
0x00000023ff1d723eULL, 0x000fe200020006ffULL, 0x2000001cff287230ULL, 0x000fe20000004100ULL,
0x00000034ff34723eULL, 0x000fe200020006ffULL, 0x2000001eff1c7230ULL, 0x000fe20000004100ULL,
0x0000002fff35723eULL, 0x000fe200020006ffULL, 0x2000001dff1d7230ULL, 0x000fe20000004100ULL,
0x00000015ff2b723eULL, 0x000fe200020006ffULL, 0x20000034ff2f7230ULL, 0x000fe20000004100ULL,
0x00000010ff147819ULL, 0x000fe20000011614ULL, 0x20000035ff347230ULL, 0x000fe20000004100ULL,
0x00000010ff157819ULL, 0x000fe20000011636ULL, 0x2000002bff2b7230ULL, 0x000fe20000004100ULL,
0x00000010ff297819ULL, 0x000fc40000011629ULL, 0x00000010ff247819ULL, 0x000fe40000011637ULL,
0x00000017ff17723eULL, 0x000fe400020006ffULL, 0x0000105415147816ULL, 0x000fe40000000014ULL,
0x000000ff2d2d7812ULL, 0x000fe200078ec0ffULL, 0x20000017ff177230ULL, 0x000fe20000004100ULL,
0x0000105424157816ULL, 0x000fe40000000029ULL, 0x000000ff18187812ULL, 0x000fc400078ec0ffULL,
0x00000010ff297819ULL, 0x000fe40000011619ULL, 0x00000010ff1c7819ULL, 0x000fe4000001161cULL,
0x00000010ff247819ULL, 0x000fe4000001161dULL, 0x00000010ff197819ULL, 0x000fe4000001162fULL,
0x00000010ff207819ULL, 0x000fe40000011620ULL, 0x00000010ff1d7819ULL, 0x000fc40000011634ULL,
0x0000002dff2d723eULL, 0x000fe400020006ffULL, 0x00000010ff3a7819ULL, 0x000fe4000001163aULL,
0x00000018ff18723eULL, 0x000fe200020006ffULL, 0x2000002dff357230ULL, 0x000fe20000004100ULL,
0x000010541c197816ULL, 0x000fe40000000019ULL, 0x0000003cff1e723eULL, 0x000fe200020006ffULL,
0x20000018ff2d7230ULL, 0x000fe20000004100ULL, 0x0000003dff23723eULL, 0x000fc400020006ffULL,
0x00000039ff39723eULL, 0x000fe200020006ffULL, 0x2000001eff1e7230ULL, 0x000fe20000004100ULL,
0x000010541d1c7816ULL, 0x000fe20000000020ULL, 0x20000023ff237230ULL, 0x000fe20000004100ULL,
0x00000010ff1f7819ULL, 0x000fe2000001161fULL, 0x20000039ff397230ULL, 0x000fe20000004100ULL,
0x00000010ff2e7819ULL, 0x000fe4000001162eULL, 0x00000010ff3d7819ULL, 0x000fe40000011628ULL,
0x0000105429207816ULL, 0x000fc4000000003aULL, 0x00000010ff297819ULL, 0x000fe40000011617ULL,
0x00000010ff287819ULL, 0x000fe40000011621ULL, 0x000010541f217816ULL, 0x000fe4000000002eULL,
0x00000010ff3b7819ULL, 0x000fe4000001163bULL, 0x00000010ff1f7819ULL, 0x000fe4000001161bULL,
0x00000010ff2e7819ULL, 0x000fc40000011625ULL, 0x0000105429287816ULL, 0x000fe40000000028ULL,
0x00000010ff297819ULL, 0x000fe4000001162cULL, 0x00000010ff347819ULL, 0x000fe4000001161aULL,
0x00000010ff2c7819ULL, 0x000fe4000001162dULL, 0x000010543b1d7816ULL, 0x000fe40000000024ULL,
0x000010542e257816ULL, 0x000fc4000000001fULL, 0x00000010ff2d7819ULL, 0x000fe40000011622ULL,
0x00000010ff2a7819ULL, 0x000fe4000001162aULL, 0x00000010ff187819ULL, 0x000fe40000011639ULL,
0x00000010ff247819ULL, 0x000fe40000011616ULL, 0x00000010ff357819ULL, 0x000fe20000011635ULL,
0x000000143014723cULL, 0x000fe200000418ffULL, 0x00000010ff2f7819ULL, 0x000fc4000001161eULL,
0x00000010ff2e7819ULL, 0x000fe40000011623ULL, 0x00000010ff277819ULL, 0x000fe20000011627ULL,
0x0000001c301c723cULL, 0x000fe200000418ffULL, 0x00000010ff367819ULL, 0x000fe40000011626ULL,
0x00000010ff2b7819ULL, 0x000fe4000001162bULL, 0x0000105434297816ULL, 0x000fe20000000029ULL,
0x000000203020723cULL, 0x000fe200000418ffULL, 0x000010542d347816ULL, 0x000fc4000000002aULL,
0x000010543d187816ULL, 0x000fe40000000018ULL, 0x0000105435247816ULL, 0x000fe40000000024ULL,
0x000010542c2c7816ULL, 0x000fe4000000002fULL, 0x00001054272d7816ULL, 0x000fe2000000002eULL,
0x000000183018723cULL, 0x000fe200000418ffULL, 0x0000105436357816ULL, 0x000fca000000002bULL,
0x000000243024723cULL, 0x000fec00000418ffULL, 0x000000283028723cULL, 0x000fec00000418ffULL,
0x0000002c302c723cULL, 0x000fec00000418ffULL, 0x000000343030723cULL, 0x000fe200000418ffULL,
0x012800006734783bULL, 0x0004e20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000102947ULL, 0x000fde0003800000ULL, 0x0000000334347232ULL, 0x08afe40000200000ULL,
0x0000000336367232ULL, 0x000fe40000200000ULL, 0x0000000435357232ULL, 0x080fe40000200000ULL,
0x0000000437377232ULL, 0x000fce0000200000ULL, 0x000000ff3800720cULL, 0x000fe20003f45270ULL,
0x00000bd000007945ULL, 0x000fe20003800000ULL, 0x000000006838783bULL, 0x000f240000004200ULL,
0x000000ff383c7812ULL, 0x010fe400078ec0ffULL, 0x000000ff393e7812ULL, 0x000fe400078ec0ffULL,
0x0000003cff50723eULL, 0x000fe400020006ffULL, 0x00000018ff3d7819ULL, 0x000fc40000011638ULL,
0x00000010ff3c7819ULL, 0x000fe20000011638ULL, 0x20000050ff507230ULL, 0x000fe20000004100ULL,
0x0000003eff51723eULL, 0x000fe400020006ffULL, 0x0000003dff3d723eULL, 0x000fe400020006ffULL,
0x00000018ff3e7819ULL, 0x000fe20000011639ULL, 0x20000051ff517230ULL, 0x000fe20000004100ULL,
0x000000ff3c3c7812ULL, 0x000fe200078ec0ffULL, 0x2000003dff6d7230ULL, 0x000fe20000004100ULL,
0x0000003eff71723eULL, 0x000fc400020006ffULL, 0x0000003cff6c723eULL, 0x000fe400020006ffULL,
0x00000000693c783bULL, 0x000f220000004200ULL, 0x00000010ff707819ULL, 0x000fe40000011639ULL,
0x0000ffff38727812ULL, 0x000fe200078ec0ffULL, 0x20000071ff387230ULL, 0x000fe20000004100ULL,
0x0000ffff39737812ULL, 0x000fe200078ec0ffULL, 0x2000006cff397230ULL, 0x000fe20000004100ULL,
0x000000ff70717812ULL, 0x000fe400078ec0ffULL, 0x00000008ff707819ULL, 0x000fc40000011672ULL,
0x00000008ff727819ULL, 0x000fe40000011673ULL, 0x00000071ff71723eULL, 0x000fe400020006ffULL,
0x00000072ff73723eULL, 0x000fe400020006ffULL, 0x00000070ff6c723eULL, 0x000fe200020006ffULL,
0x20000071ff727230ULL, 0x000fe20000004100ULL, 0x00000010ff507819ULL, 0x000fe20000011650ULL,
0x20000073ff737230ULL, 0x000fe20000004100ULL, 0x00000010ff517819ULL, 0x000fe20000011651ULL,
0x2000006cff717230ULL, 0x000fe20000004100ULL, 0x00000010ff397819ULL, 0x000fc40000011639ULL,
0x00000010ff727819ULL, 0x000fe40000011672ULL, 0x000000ff3b747812ULL, 0x000fe400078ec0ffULL,
0x0000105439507816ULL, 0x000fe40000000050ULL, 0x0000105472517816ULL, 0x000fe40000000051ULL,
0x00000074ff6c723eULL, 0x000fe400020006ffULL, 0x00000010ff747819ULL, 0x000fc40000011638ULL,
0x00000010ff6d7819ULL, 0x000fe2000001166dULL, 0x000000503414723cULL, 0x008fe20000041814ULL,
0x00000010ff387819ULL, 0x000fe20000011671ULL, 0x2000006cff6c7230ULL, 0x000fe20000004100ULL,
0x00000010ff737819ULL, 0x000fe40000011673ULL, 0x000010546d387816ULL, 0x000fe40000000038ULL,
0x0000105474397816ULL, 0x000fe40000000073ULL, 0x000000ff3c507812ULL, 0x010fc400078ec0ffULL,
0x000000ff3a707812ULL, 0x040fe400078ec0ffULL, 0x00000010ff737819ULL, 0x100fe2000001163aULL,
0x000000383418723cULL, 0x000fe20000041818ULL, 0x00000018ff717819ULL, 0x000fe4000001163aULL,
0x0000ffff3a6d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff3a7819ULL, 0x100fe4000001163bULL,
0x00000018ff727819ULL, 0x000fc4000001163bULL, 0x0000ffff3b3b7812ULL, 0x000fe400078ec0ffULL,
0x00000050ff50723eULL, 0x000fe400020006ffULL, 0x000000ff3d517812ULL, 0x000fe400078ec0ffULL,
0x000000ff73737812ULL, 0x000fe200078ec0ffULL, 0x20000050ff397230ULL, 0x000fe20000004100ULL,
0x00000008ff6d7819ULL, 0x000fe4000001166dULL, 0x00000008ff3b7819ULL, 0x000fc4000001163bULL,
0x00000051ff74723eULL, 0x000fe400020006ffULL, 0x00000070ff70723eULL, 0x000fe400020006ffULL,
0x00000073ff51723eULL, 0x000fe200020006ffULL, 0x20000074ff387230ULL, 0x000fe20000004100ULL,
0x000000ff3a3a7812ULL, 0x000fe200078ec0ffULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x0000006dff50723eULL, 0x000fe200020006ffULL, 0x20000051ff517230ULL, 0x000fe20000004100ULL,
0x00000010ff737819ULL, 0x000fc4000001163cULL, 0x0000003bff6d723eULL, 0x000fe200020006ffULL,
0x20000050ff507230ULL, 0x000fe20000004100ULL, 0x00000010ff3b7819ULL, 0x000fe4000001163dULL,
0x0000003aff3a723eULL, 0x000fe400020006ffULL, 0x000000ff73737812ULL, 0x000fe400078ec0ffULL,
0x000000ff3b757812ULL, 0x000fe200078ec0ffULL, 0x2000003aff747230ULL, 0x000fe20000004100ULL,
0x00000071ff71723eULL, 0x000fc400020006ffULL, 0x00000073ff73723eULL, 0x000fe400020006ffULL,
0x00000010ff3a7819ULL, 0x000fe20000011670ULL, 0x20000071ff717230ULL, 0x000fe20000004100ULL,
0x00000010ff517819ULL, 0x000fe20000011651ULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x00000075ff75723eULL, 0x000fe400020006ffULL, 0x00000010ff3b7819ULL, 0x000fe4000001166cULL,
0x00000018ff6c7819ULL, 0x000fe2000001163cULL, 0x20000075ff757230ULL, 0x000fe20000004100ULL,
0x00000018ff707819ULL, 0x000fc4000001163dULL, 0x00000072ff72723eULL, 0x000fe400020006ffULL,
0x00001054513a7816ULL, 0x000fe2000000003aULL, 0x2000006dff517230ULL, 0x000fe20000004100ULL,
0x00000010ff747819ULL, 0x000fe20000011674ULL, 0x20000072ff727230ULL, 0x000fe20000004100ULL,
0x0000006cff6d723eULL, 0x000fe400020006ffULL, 0x00000070ff6c723eULL, 0x000fe400020006ffULL,
0x00000010ff707819ULL, 0x000fe20000011638ULL, 0x2000006dff6d7230ULL, 0x000fe20000004100ULL,
0x00000010ff717819ULL, 0x000fe20000011671ULL, 0x2000006cff6c7230ULL, 0x000fe20000004100ULL,
0x00000010ff397819ULL, 0x000fc40000011639ULL, 0x00000010ff507819ULL, 0x000fe40000011650ULL,
0x00000010ff387819ULL, 0x000fe40000011673ULL, 0x00001054743b7816ULL, 0x000fe4000000003bULL,
0x00000010ff757819ULL, 0x000fe40000011675ULL, 0x0000105471507816ULL, 0x000fe40000000050ULL,
0x0000105438387816ULL, 0x000fe20000000039ULL, 0x0000003a341c723cULL, 0x000fe2000004181cULL,
0x00000010ff727819ULL, 0x000fc40000011672ULL, 0x00000010ff517819ULL, 0x000fe40000011651ULL,
0x0000105475397816ULL, 0x000fe40000000070ULL, 0x000000ff3f717812ULL, 0x000fe400078ec0ffULL,
0x0000ffff3c757812ULL, 0x000fe400078ec0ffULL, 0x0000105472517816ULL, 0x000fe20000000051ULL,
0x000000383424723cULL, 0x000fe20000041824ULL, 0x000000ff3e3b7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff3a7819ULL, 0x000fe4000001163eULL, 0x00000071ff74723eULL, 0x000fe200020006ffULL,
0x000000503420723cULL, 0x000fe20000041820ULL, 0x00000018ff727819ULL, 0x000fe4000001163fULL,
0x00000008ff717819ULL, 0x000fe40000011675ULL, 0x0000ffff3d3c7812ULL, 0x000fe400078ec0ffULL,
0x0000003bff3b723eULL, 0x000fc400020006ffULL, 0x0000003aff73723eULL, 0x000fe400020006ffULL,
0x00000072ff75723eULL, 0x000fe200020006ffULL, 0x2000003bff3a7230ULL, 0x000fe20000004100ULL,
0x00000071ff71723eULL, 0x000fe200020006ffULL, 0x20000074ff3b7230ULL, 0x000fe20000004100ULL,
0x00000010ff3d7819ULL, 0x000fe4000001163eULL, 0x00000008ff727819ULL, 0x000fe2000001163cULL,
0x20000073ff3c7230ULL, 0x000fe20000004100ULL, 0x00000010ff707819ULL, 0x000fe2000001163fULL,
0x20000071ff717230ULL, 0x000fe20000004100ULL, 0x0000ffff3e3e7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff3f3f7812ULL, 0x000fe400078ec0ffULL, 0x000000ff3d737812ULL, 0x000fe200078ec0ffULL,
0x20000075ff3d7230ULL, 0x000fe20000004100ULL, 0x00000072ff72723eULL, 0x000fe400020006ffULL,
0x000000ff70747812ULL, 0x000fe400078ec0ffULL, 0x00000008ff707819ULL, 0x000fe2000001163eULL,
0x20000072ff727230ULL, 0x000fe20000004100ULL, 0x00000008ff757819ULL, 0x000fc4000001163fULL,
0x00000010ff3f7819ULL, 0x000fe4000001166dULL, 0x00000010ff3e7819ULL, 0x000fe40000011671ULL,
0x00000073ff73723eULL, 0x000fe400020006ffULL, 0x00000074ff74723eULL, 0x000fe400020006ffULL,
0x00000070ff70723eULL, 0x000fe200020006ffULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x00000075ff75723eULL, 0x000fe200020006ffULL, 0x20000074ff6d7230ULL, 0x000fe20000004100ULL,
0x000010543f3e7816ULL, 0x000fe2000000003eULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x00000010ff6c7819ULL, 0x000fe2000001166cULL, 0x20000075ff757230ULL, 0x000fe20000004100ULL,
0x00000010ff3f7819ULL, 0x000fc40000011672ULL, 0x00000010ff517819ULL, 0x000fe4000001163cULL,
0x000010546c3f7816ULL, 0x000fe4000000003fULL, 0x00000010ff6c7819ULL, 0x000fe4000001163dULL,
0x00000010ff3a7819ULL, 0x000fe4000001163aULL, 0x00000010ff737819ULL, 0x000fe20000011673ULL,
0x0000003e3428723cULL, 0x000fe20000041828ULL, 0x00000010ff3b7819ULL, 0x000fc4000001163bULL,
0x00000010ff507819ULL, 0x000fe4000001166dULL, 0x00000010ff3c7819ULL, 0x000fe40000011670ULL,
0x00000010ff3d7819ULL, 0x000fe40000011675ULL, 0x00001054733a7816ULL, 0x000fe4000000003aULL,
0x00001054503b7816ULL, 0x000fe4000000003bULL, 0x00001054513c7816ULL, 0x000fc4000000003cULL,
0x000010546c3d7816ULL, 0x000fc6000000003dULL, 0x0000003a342c723cULL, 0x000fec000004182cULL,
0x0000003c3430723cULL, 0x000fe20000041830ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000403947ULL, 0x000fde0001000000ULL, 0x000000140b0b7221ULL, 0x000fe20000010000ULL,
0x000000150c0c7221ULL, 0x000fe20000010000ULL, 0x000000180f0f7221ULL, 0x000fe20000010000ULL,
0x0000001910107221ULL, 0x000fe20000010000ULL, 0x0000001c41417221ULL, 0x000fe20000010000ULL,
0x0000001d42427221ULL, 0x000fe20000010000ULL, 0x0000002045457221ULL, 0x000fe20000010000ULL,
0x0000002146467221ULL, 0x000fe20000010000ULL, 0x0000002449497221ULL, 0x000fe20000010000ULL,
0x000000254a4a7221ULL, 0x000fe20000010000ULL, 0x000000284d4d7221ULL, 0x000fe20000010000ULL,
0x000000294e4e7221ULL, 0x000fe20000010000ULL, 0x0000002c53537221ULL, 0x000fe20000010000ULL,
0x0000002d54547221ULL, 0x000fe20000010000ULL, 0x0000003057577221ULL, 0x000fe20000010000ULL,
0x0000003158587221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x000000ffff157224ULL, 0x002fc600078e006fULL,
0x0000000000404947ULL, 0x000fea0002800000ULL, 0x000000160d0d7221ULL, 0x000fe20000010000ULL,
0x000000170e0e7221ULL, 0x000fe20000010000ULL, 0x0000001a11117221ULL, 0x000fe20000010000ULL,
0x0000001b40407221ULL, 0x000fe20000010000ULL, 0x0000001e43437221ULL, 0x000fe20000010000ULL,
0x0000001f44447221ULL, 0x000fe20000010000ULL, 0x0000002247477221ULL, 0x000fe20000010000ULL,
0x0000002348487221ULL, 0x000fe20000010000ULL, 0x000000264b4b7221ULL, 0x000fe20000010000ULL,
0x000000274c4c7221ULL, 0x000fe20000010000ULL, 0x0000002a4f4f7221ULL, 0x000fe20000010000ULL,
0x0000002b52527221ULL, 0x000fe20000010000ULL, 0x0000002e55557221ULL, 0x000fe20000010000ULL,
0x0000002f56567221ULL, 0x000fe20000010000ULL, 0x0000003259597221ULL, 0x000fe20000010000ULL,
0x000000335a5a7221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001ff147424ULL, 0x000fe400078e00ffULL, 0x000000016b6b7836ULL, 0x000fe40000000000ULL,
0x018b8814ff1679a7ULL, 0x000e660008500007ULL, 0x0000006a6b00720cULL, 0x000fe20003f46070ULL,
0x000000ffff1c7224ULL, 0x002fd800078e0017ULL, 0xffffffa0006ca947ULL, 0x000fea000383ffffULL,
0x018b6014ffff79a7ULL, 0x0003e40008500007ULL, 0x0000008008147811ULL, 0x002fc800078e40ffULL,
0x0000000914007c0cULL, 0x000fda000bf46070ULL, 0x000000bc00442947ULL, 0x000fea0003800000ULL,
0x000000ffff6b7224ULL, 0x000fce00078e00ffULL, 0x00000002ff147819ULL, 0x000fe4000001166bULL,
0x000000036b1b7812ULL, 0x040fe400078ec0ffULL, 0x000000146b147207ULL, 0x000fe40000000000ULL,
0x000000ff1b1b7207ULL, 0x000fc60004000000ULL, 0x00000002141f7836ULL, 0x000fca0000000000ULL,
0x000000031f1d7812ULL, 0x040fe400078ec0ffULL, 0x000000081f1a7211ULL, 0x004fce00078ff0ffULL,
0x0000000000187805ULL, 0x000fce0000015200ULL, 0x018b7815ff0075a7ULL, 0x000e640008040147ULL,
0x00000000005c2947ULL, 0x002fea0003800000ULL, 0x000000ffff1e7224ULL, 0x000fce00078e00ffULL,
0x000000101e00780cULL, 0x000fda0003f46270ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000001618217210ULL, 0x000fca0007f5e1ffULL,
0x0000000117177824ULL, 0x000fe200010e0e19ULL, 0x003d09002100780cULL, 0x000fc80003f46070ULL,
0x000000ff1700720cULL, 0x000fda0003f46320ULL, 0x000000000008a947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c402100780cULL, 0x000fc80003f46070ULL, 0x000000ff1700720cULL, 0x000fda0003f46320ULL,
0x00000000001ca947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011417ULL,
0x0000002114147211ULL, 0x000fca00078510ffULL, 0x000000ffff177224ULL, 0x000fca00010e0617ULL,
0x0000000214147819ULL, 0x000fc80000001217ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011e1e7836ULL, 0x000fce0000000000ULL,
0x018b7815ff0075a7ULL, 0x000e640008040147ULL, 0xfffffffc00a8a947ULL, 0x002fea000383ffffULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x018b881cff0075a7ULL, 0x000e640008040147ULL,
0x00000000005c2947ULL, 0x002fea0003800000ULL, 0x000000ffff187224ULL, 0x000fce00078e00ffULL,
0x000000101800780cULL, 0x000fda0003f46270ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x0000001416197210ULL, 0x000fca0007f5e1ffULL,
0x0000000115157824ULL, 0x000fe200010e0e17ULL, 0x003d09001900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x000000000008a947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x00000000001ca947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001914147211ULL, 0x000fca00078510ffULL, 0x000000ffff157224ULL, 0x000fca00010e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000118187836ULL, 0x000fce0000000000ULL,
0x018b881cff0075a7ULL, 0x000e640008040147ULL, 0xfffffffc00a8a947ULL, 0x002fea000383ffffULL,
0x000000011a157836ULL, 0x000fe20000000000ULL, 0x00000004ff707819ULL, 0x000fe20000011612ULL,
0x000000041a147824ULL, 0x000fc600078e021dULL, 0x0000000c15007c0cULL, 0x000fe4000bf46070ULL,
0x0000002014187811ULL, 0x000fc800078e30ffULL, 0x000000605b1c7812ULL, 0x000fce00078ef818ULL,
0x000000040054a947ULL, 0x000fea0003800000ULL, 0x000000015d237824ULL, 0x000fe200078e0270ULL,
0x0000000918167c48ULL, 0x000fe2000ffe0000ULL, 0x00000010121e7824ULL, 0x000fe200078e00ffULL,
0x00016000070e7890ULL, 0x000fe2000fffe03fULL, 0x0000000270227836ULL, 0x000fe20000000000ULL,
0x0000000723207c11ULL, 0x040fe2000f8e10ffULL, 0x0000000116167824ULL, 0x000fe200078e0a18ULL,
0x000000f01e257812ULL, 0x000fe200078ec0ffULL, 0x0000000123187824ULL, 0x000fe400078e021cULL,
0x018a000020147984ULL, 0x000e620000000800ULL, 0x000000165d167248ULL, 0x000fe20007fe0000ULL,
0x000000015d277824ULL, 0x000fc800078e0222ULL, 0x0000000116217824ULL, 0x000fe400078e0a5dULL,
0x0000000127247824ULL, 0x000fc600078e0212ULL, 0x000000217000720cULL, 0x000fe40003f46070ULL,
0x0000000714197c11ULL, 0x002fe4000f8e10ffULL, 0x00008a00ff147b82ULL, 0x000e660000000a00ULL,
0x018ac00019177984ULL, 0x0007240000000800ULL, 0x0000000127197824ULL, 0x048fe400078e021cULL,
0x0000001027277824ULL, 0x000fca00078e00ffULL, 0xfffffff027247812ULL, 0x000fe200078ee224ULL,
0x0000000617177c24ULL, 0x010fe4000f8e0218ULL, 0x0000000123187824ULL, 0x000fe400078e0212ULL,
0x0000010017167825ULL, 0x002fc800078e0014ULL, 0x0000001023237824ULL, 0x000fe200078e00ffULL,
0x0000002516167210ULL, 0x000fc80007f7e0ffULL, 0xfffffff023187812ULL, 0x000fe200078ee218ULL,
0x000000ffff177224ULL, 0x000fc600018e0617ULL, 0x0000000e18237c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e2000d101c4aULL,
0x000000212200720cULL, 0x000fe20003f46070ULL, 0x0000000470227836ULL, 0x000fe40000000000ULL,
0x018a080020187984ULL, 0x000ee40000000800ULL, 0x000000015d277824ULL, 0x000fe200078e0222ULL,
0x0000000e24237c11ULL, 0x002fc6000f8e20ffULL, 0x0000000127247824ULL, 0x000fe200078e0212ULL,
0x00000007181e7c11ULL, 0x008fca000f8e10ffULL, 0x018ac0001e187984ULL, 0x000e640000000800ULL,
0x0000000618197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000002518167210ULL, 0x000fca0007f7e0ffULL, 0x000000ffff177224ULL, 0x000fe400018e0619ULL,
0x0000000127197824ULL, 0x040fe400078e021cULL, 0x0000001027277824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e2000d101c4aULL,
0x000000212200720cULL, 0x000fc60003f46070ULL, 0x018a100020187984ULL, 0x000ee20000000800ULL,
0xfffffff027247812ULL, 0x000fc800078ee224ULL, 0x0000000e24237c11ULL, 0x002fe4000f8e20ffULL,
0x00000007181e7c11ULL, 0x008fca000f8e10ffULL, 0x018ac0001e187984ULL, 0x0002e40000000800ULL,
0x00000006701e7836ULL, 0x002fc80000000000ULL, 0x000000015d277824ULL, 0x000fe400078e021eULL,
0x0000000618197c24ULL, 0x008fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000002518167210ULL, 0x000fca0007f7e0ffULL, 0x000000ffff177224ULL, 0x000fe400018e0619ULL,
0x0000000127197824ULL, 0x040fe400078e021cULL, 0x00000001271c7824ULL, 0x040fe200078e0212ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e2000d101c4aULL,
0x0000001027277824ULL, 0x000fe200078e00ffULL, 0x000000211e00720cULL, 0x000fe40003f46070ULL,
0x018a180020187984ULL, 0x000ee40000000800ULL, 0xfffffff0271c7812ULL, 0x000fc800078ee21cULL,
0x0000000e1c177c11ULL, 0x002fe4000f8e20ffULL, 0x0000000718187c11ULL, 0x008fcc000f8e10ffULL,
0x018ac00018187984ULL, 0x000e640000000800ULL, 0x0000000618197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019147825ULL, 0x000fc600078e0014ULL, 0x0000002514147210ULL, 0x000fca0007f7e0ffULL,
0x000000ffff157224ULL, 0x000fca00018e0615ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014177faeULL, 0x0003e2000d101c4aULL, 0x0000000400247947ULL, 0x000fea0003800000ULL,
0x000000015d217824ULL, 0x000fe200078e0270ULL, 0x00016000070e7890ULL, 0x000fe2000fffe03fULL,
0x0000001012197824ULL, 0x000fe400078e00ffULL, 0x0000000121177824ULL, 0x040fe200078e021cULL,
0x0000000721207c11ULL, 0x040fe2000f8e10ffULL, 0x00000010211e7824ULL, 0x000fe200078e00ffULL,
0x000000f019237812ULL, 0x000fe200078ec0ffULL, 0x0000000121197824ULL, 0x000fe400078e0212ULL,
0x018a000020147984ULL, 0x000e620000000800ULL, 0x0000000221277836ULL, 0x000fc40000000000ULL,
0xfffffff01e197812ULL, 0x000fe400078ee219ULL, 0x0000000127227824ULL, 0x000fe400078e0212ULL,
0x0000000e19257c11ULL, 0x000fe2000f8e20ffULL, 0x0000000127197824ULL, 0x040fe400078e021cULL,
0x0000001027277824ULL, 0x000fca00078e00ffULL, 0xfffffff027227812ULL, 0x000fe200078ee222ULL,
0x0000000421277836ULL, 0x000fe40000000000ULL, 0x0000000621217836ULL, 0x000fe20000000000ULL,
0x0000000714187c11ULL, 0x002fe4000f8e10ffULL, 0x00008a00ff147b82ULL, 0x000e660000000a00ULL,
0x018ac00018167984ULL, 0x000ee40000000800ULL, 0x0000000616177c24ULL, 0x008fc8000f8e0217ULL,
0x0000010017167825ULL, 0x002fc600078e0014ULL, 0x0000002316167210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff177224ULL, 0x000fca00010e0617ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016257faeULL, 0x0003e8000b901c4aULL, 0x018a080020187984ULL, 0x000ee20000000800ULL,
0x0000000e22257c11ULL, 0x002fe2000f8e20ffULL, 0x0000000127177824ULL, 0x040fe400078e021cULL,
0x0000000127227824ULL, 0x040fe400078e0212ULL, 0x0000001027277824ULL, 0x000fca00078e00ffULL,
0xfffffff027227812ULL, 0x000fe400078ee222ULL, 0x00000007181e7c11ULL, 0x008fca000f8e10ffULL,
0x018ac0001e187984ULL, 0x000e640000000800ULL, 0x0000000618197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000002318187210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff197224ULL, 0x000fca00010e0619ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018257faeULL, 0x0003e8000b901c4aULL, 0x018a100020167984ULL, 0x000ee20000000800ULL,
0x0000000e22257c11ULL, 0x002fe2000f8e20ffULL, 0x0000000121197824ULL, 0x040fe400078e021cULL,
0x00000010211c7824ULL, 0x000fe200078e00ffULL, 0x00000007161e7c11ULL, 0x008fca000f8e10ffULL,
0x018ac0001e167984ULL, 0x000e640000000800ULL, 0x0000000616177c24ULL, 0x002fc8000f8e0217ULL,
0x0000010017167825ULL, 0x000fc600078e0014ULL, 0x0000002316167210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff177224ULL, 0x000fca00010e0617ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016257faeULL, 0x0003e8000b901c4aULL, 0x018a180020187984ULL, 0x000ee40000000800ULL,
0x0000000718187c11ULL, 0x008fcc000f8e10ffULL, 0x018ac00018187984ULL, 0x000ee40000000800ULL,
0x0000000618197c24ULL, 0x008fc8000f8e0219ULL, 0x0000010019147825ULL, 0x000fc800078e0014ULL,
0x0000000121197824ULL, 0x000fe200078e0212ULL, 0x0000002314147210ULL, 0x000fc80007f5e0ffULL,
0xfffffff01c197812ULL, 0x000fe200078ee219ULL, 0x000000ffff157224ULL, 0x000fc600010e0615ULL,
0x0000000e19197c11ULL, 0x000fca000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014197faeULL, 0x0003e4000b901c4aULL, 0x00000001ff147424ULL, 0x002fcc00078e00ffULL,
0x018b8814ff1479a7ULL, 0x000e640008500007ULL, 0x000000ffff187224ULL, 0x002fce00078e0015ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x018b8818ff0075a7ULL, 0x000e640008040147ULL,
0x00000000005c2947ULL, 0x002fea0003800000ULL, 0x000000ffff1c7224ULL, 0x000fce00078e00ffULL,
0x000000101c00780cULL, 0x000fda0003f46270ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x0000001416197210ULL, 0x000fca0007f5e1ffULL,
0x0000000115157824ULL, 0x000fe200010e0e17ULL, 0x003d09001900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x000000000008a947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x00000000001ca947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001914147211ULL, 0x000fca00078510ffULL, 0x000000ffff157224ULL, 0x000fca00010e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011c1c7836ULL, 0x000fce0000000000ULL,
0x018b8818ff0075a7ULL, 0x000e640008040147ULL, 0xfffffffc00a8a947ULL, 0x002fea000383ffffULL,
0x0000001a5f00720cULL, 0x000fe20003f44070ULL, 0x00000001ff1c7424ULL, 0x000fe200078e00ffULL,
0x000000011f1f7812ULL, 0x000fe200078ec0ffULL, 0x00000020616e7824ULL, 0x000fe200078e0212ULL,
0x000000031b00780cULL, 0x000fc80005745270ULL, 0x000000011f00780cULL, 0x000fda0001745470ULL,
0x00000000004c2947ULL, 0x000fea0003800000ULL, 0x000000036e00780cULL, 0x000fe20003f44070ULL,
0x0000000104047890ULL, 0x000fe2000fffe03fULL, 0x0000010000007945ULL, 0x000ff60003800000ULL,
0x0000000000382947ULL, 0x000fea0003800000ULL, 0x00009000ff177b82ULL, 0x000e620000000800ULL,
0x000000050400728cULL, 0x000fe2000bf06070ULL, 0x0000000413167824ULL, 0x000fe200078e026eULL,
0x000000076e197c11ULL, 0x000fc6000f8e10ffULL, 0x0000000216167824ULL, 0x000fe200078e00ffULL,
0x000000000000781cULL, 0x000fe20003f4f008ULL, 0x00008c00ff147b82ULL, 0x000ee20000000a00ULL,
0x0000000417187c36ULL, 0x002fc80008000000ULL, 0x0000001716177224ULL, 0x000fc800078e0218ULL,
0x0000000417147825ULL, 0x008fca00078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x18ac000014197faeULL, 0x0003e4000d12184aULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000019000007945ULL, 0x000fe80003800000ULL, 0x00000000005c1947ULL, 0x000fea0003800000ULL,
0x0000001a5f00720cULL, 0x000fe20003f44070ULL, 0x000000011b147836ULL, 0x002fe20000000000ULL,
0x00009400ff187b82ULL, 0x000e680000000800ULL, 0x0000000314167812ULL, 0x000fc800078ec0ffULL,
0x000000ff16197207ULL, 0x000fc60005000000ULL, 0x00000002ff14a819ULL, 0x000fe40000011614ULL,
0x000000015c167824ULL, 0x000fc600078e0219ULL, 0x000000011d1d7824ULL, 0x000fe400078e0214ULL,
0x00009200ff147b82ULL, 0x000ee40000000a00ULL, 0x000000401d177824ULL, 0x040fe200078e00ffULL,
0x0000001a1d1a7211ULL, 0x000fc800078ff0ffULL, 0x000000c017177812ULL, 0x000fca00078ec0ffULL,
0x000001001a177824ULL, 0x000fc800078e0217ULL, 0x000000016e197824ULL, 0x100fe400078e0217ULL,
0x0000001816177224ULL, 0x002fc600078e0217ULL, 0x0000000919007c0cULL, 0x000fe2000bf46070ULL,
0x000000016e177824ULL, 0x040fe200078e0217ULL, 0x000000076e197c11ULL, 0x000fc6000f8e10ffULL,
0x0000000417147825ULL, 0x008fd000078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x18a0000014197faeULL, 0x0003e4000d12184aULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a4dULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x018b801cff6c79a7ULL, 0x0002e20008500007ULL,
0x000000ff6b00720cULL, 0x000fe20003f45270ULL, 0x00000008636c7836ULL, 0x008fd80000000000ULL,
0x00000004008c2947ULL, 0x002fea0003800000ULL, 0x018b181c5d1479a7ULL, 0x000e640008500007ULL,
0x000000ffff187224ULL, 0x002fce00078e0015ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x018b18185d0075a7ULL, 0x000e640008040147ULL, 0x00000000005c2947ULL, 0x002fea0003800000ULL,
0x000000ffff197224ULL, 0x000fce00078e00ffULL, 0x000000101900780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x0000001416147210ULL, 0x000fca0007f5e1ffULL, 0x0000000115157824ULL, 0x000fe200010e0e17ULL,
0x003d09001400780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401400780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff077819ULL, 0x000fc80000011415ULL, 0x0000001407077211ULL, 0x000fca00078510ffULL,
0x000000ffff147224ULL, 0x000fca00010e0615ULL, 0x0000000207077819ULL, 0x000fc80000001214ULL,
0x000000070000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000119197836ULL, 0x000fce0000000000ULL, 0x018b18185d0075a7ULL, 0x000e640008040147ULL,
0xfffffffc00a8a947ULL, 0x002fea000383ffffULL, 0x0000001012077824ULL, 0x000fe200078e00ffULL,
0x00000001ff147819ULL, 0x000fe20000011612ULL, 0x000000ffff167224ULL, 0x000fc600078e0009ULL,
0x0000007007077812ULL, 0x000fe400078ec0ffULL, 0x0000000c14147812ULL, 0x000fc800078ec0ffULL,
0x00000007141b7c10ULL, 0x000fca000fffe007ULL, 0x018100001b147984ULL, 0x000e680000000800ULL,
0x018300001b157984ULL, 0x0006e20000000800ULL, 0x000000091400720bULL, 0x002fda0003f5d000ULL,
0x0000000000077806ULL, 0x000fc800010e0100ULL, 0x0000ffff07187812ULL, 0x000fe2000784c0ffULL,
0x00000001ff077424ULL, 0x000fd800078e00ffULL, 0x0000000000e0a947ULL, 0x00cfea0003800000ULL,
0x000000091400720bULL, 0x000fe40003f54000ULL, 0x000000026100780cULL, 0x000fe40003f65270ULL,
0x0000001409167209ULL, 0x000fd20007810000ULL, 0x0000000000197806ULL, 0x000fe400010e0100ULL,
0x018500161b00b388ULL, 0x0003e40000000800ULL, 0x0000991019177816ULL, 0x000fc800000000ffULL,
0x000000ff1700720cULL, 0x000fda0003f45270ULL, 0x0000000000a8a947ULL, 0x002fea0003800000ULL,
0x8000001609097221ULL, 0x000fe20000010000ULL, 0x000000ff19ff7812ULL, 0x040fe4000784c0ffULL,
0x0000ff0019ff7812ULL, 0x000fe2000786c0ffULL, 0x3fb8aa3b09097820ULL, 0x000fc80000410000ULL,
0x0000000900177308ULL, 0x0002ac0000000800ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x00001f6317097589ULL, 0x006e6400000e0000ULL, 0x000000090b0b7220ULL, 0x082fe20000410000ULL,
0x000000090c0c7220ULL, 0x080fe20000410000ULL, 0x000000090f0f7220ULL, 0x080fe20000410000ULL,
0x0000000910107220ULL, 0x080fe20000410000ULL, 0x0000000941417220ULL, 0x080fe20000410000ULL,
0x0000000942427220ULL, 0x080fe20000410000ULL, 0x0000000945457220ULL, 0x080fe20000410000ULL,
0x0000000946467220ULL, 0x080fe20000410000ULL, 0x0000000949497220ULL, 0x080fe20000410000ULL,
0x000000094a4a7220ULL, 0x080fe20000410000ULL, 0x000000094d4d7220ULL, 0x080fe20000410000ULL,
0x000000094e4e7220ULL, 0x080fe20000410000ULL, 0x0000000953537220ULL, 0x080fe20000410000ULL,
0x0000000954547220ULL, 0x080fe20000410000ULL, 0x0000000957577220ULL, 0x080fe20000410000ULL,
0x0000000958587220ULL, 0x000fce0000410000ULL, 0x000000170a0a7220ULL, 0x004fe20000410000ULL,
0x000000000044b947ULL, 0x000fec0003800000ULL, 0x00001f6c17097589ULL, 0x002e6400000e0000ULL,
0x000000090d0d7220ULL, 0x082fe20000410000ULL, 0x000000090e0e7220ULL, 0x080fe20000410000ULL,
0x0000000911117220ULL, 0x080fe20000410000ULL, 0x0000000940407220ULL, 0x080fe20000410000ULL,
0x0000000943437220ULL, 0x080fe20000410000ULL, 0x0000000944447220ULL, 0x080fe20000410000ULL,
0x0000000947477220ULL, 0x080fe20000410000ULL, 0x0000000948487220ULL, 0x080fe20000410000ULL,
0x000000094b4b7220ULL, 0x080fe20000410000ULL, 0x000000094c4c7220ULL, 0x080fe20000410000ULL,
0x000000094f4f7220ULL, 0x080fe20000410000ULL, 0x0000000952527220ULL, 0x080fe20000410000ULL,
0x0000000955557220ULL, 0x080fe20000410000ULL, 0x0000000956567220ULL, 0x080fe20000410000ULL,
0x0000000959597220ULL, 0x080fe20000410000ULL, 0x000000095a5a7220ULL, 0x000fce0000410000ULL,
0x0000ffff18ff7812ULL, 0x000fda0007846019ULL, 0x8000001614142221ULL, 0x000fe20000010000ULL,
0x00007610ff072816ULL, 0x000fc60000000007ULL, 0x3fb8aa3b14142820ULL, 0x000fc80000410000ULL,
0x0000001400062308ULL, 0x000ea40000000800ULL, 0x0000000615152220ULL, 0x004fce0000410000ULL,
0x0000000a150a7221ULL, 0x000fe20000010000ULL, 0x000000ffff097224ULL, 0x002fce00078e0016ULL,
0x000000ff07ff7812ULL, 0x000fda000784c0ffULL, 0x0000000000102947ULL, 0x000fea0003800000ULL,
0x00000006ff03723eULL, 0x000fc800000010ffULL, 0x0000541003147816ULL, 0x000fca0000000003ULL,
0x00001f6314037589ULL, 0x0002e800000e0000ULL, 0x00001f6c14047589ULL, 0x0002a400000e0000ULL,
0x01300000051c783bULL, 0x0002e20000000200ULL, 0x0000000000102947ULL, 0x000fea0003800000ULL,
0x000000031c1c7232ULL, 0x088fe40000200000ULL, 0x000000031e1e7232ULL, 0x000fe40000200000ULL,
0x000000041d1d7232ULL, 0x084fe40000200000ULL, 0x000000041f1f7232ULL, 0x000fce0000200000ULL,
0x000000000214783bULL, 0x002e680000004200ULL, 0x000000000018783bULL, 0x000f220000004200ULL,
0x00000018ff207819ULL, 0x102fe40000011614ULL, 0x000000ff16257812ULL, 0x000fe400078ec0ffULL,
0x00000020ff20723eULL, 0x000fe400020006ffULL, 0x00000010ff377819ULL, 0x000fc40000011614ULL,
0x000000ff14217812ULL, 0x040fe200078ec0ffULL, 0x20000020ff2b7230ULL, 0x000fe20000004100ULL,
0x0000ffff14367812ULL, 0x000fe400078ec0ffULL, 0x00000010ff347819ULL, 0x100fe40000011615ULL,
0x000000ff15237812ULL, 0x040fe400078ec0ffULL, 0x00000018ff227819ULL, 0x000fe40000011615ULL,
0x0000ffff15357812ULL, 0x000fc400078ec0ffULL, 0x00000018ff387819ULL, 0x000fe40000011617ULL,
0x00000018ff147819ULL, 0x010fe4000001161aULL, 0x00000025ff25723eULL, 0x000fe400020006ffULL,
0x00000018ff157819ULL, 0x000fe4000001161bULL, 0x000000ff17397812ULL, 0x000fe200078ec0ffULL,
0x20000025ff267230ULL, 0x000fe20000004100ULL, 0x00000038ff20723eULL, 0x000fc400020006ffULL,
0x00000014ff14723eULL, 0x000fe400020006ffULL, 0x00000010ff337819ULL, 0x000fe20000011616ULL,
0x20000020ff207230ULL, 0x000fe20000004100ULL, 0x00000015ff38723eULL, 0x000fe200020006ffULL,
0x20000014ff157230ULL, 0x000fe20000004100ULL, 0x0000ffff162e7812ULL, 0x000fe400078ec0ffULL,
0x00000039ff25723eULL, 0x000fe200020006ffULL, 0x20000038ff147230ULL, 0x000fe20000004100ULL,
0x00000008ff397819ULL, 0x000fc40000011635ULL, 0x000000ff37377812ULL, 0x000fe200078ec0ffULL,
0x20000025ff257230ULL, 0x000fe20000004100ULL, 0x000000ff33337812ULL, 0x000fe400078ec0ffULL,
0x00000008ff2e7819ULL, 0x000fe4000001162eULL, 0x000000ff34387812ULL, 0x000fe400078ec0ffULL,
0x00000039ff39723eULL, 0x000fe400020006ffULL, 0x00000037ff34723eULL, 0x000fc400020006ffULL,
0x00000010ff2f7819ULL, 0x000fe40000011617ULL, 0x0000ffff17317812ULL, 0x000fe200078ec0ffULL,
0x20000034ff347230ULL, 0x000fe20000004100ULL, 0x00000010ff307819ULL, 0x000fe40000011618ULL,
0x00000033ff37723eULL, 0x000fe200020006ffULL, 0x20000039ff337230ULL, 0x000fe20000004100ULL,
0x0000002eff2e723eULL, 0x000fe400020006ffULL, 0x0000ffff192d7812ULL, 0x000fc400078ec0ffULL,
0x00000038ff35723eULL, 0x000fe400020006ffULL, 0x00000010ff287819ULL, 0x000fe4000001161aULL,
0x000000ff2f2f7812ULL, 0x000fe200078ec0ffULL, 0x20000035ff357230ULL, 0x000fe20000004100ULL,
0x00000008ff387819ULL, 0x000fe20000011631ULL, 0x20000037ff317230ULL, 0x000fe20000004100ULL,
0x000000ff30397812ULL, 0x000fe200078ec0ffULL, 0x2000002eff377230ULL, 0x000fe20000004100ULL,
0x00000010ff2a7819ULL, 0x000fc4000001161bULL, 0x00000008ff2e7819ULL, 0x000fe4000001162dULL,
0x00000018ff247819ULL, 0x000fe40000011616ULL, 0x0000002fff2f723eULL, 0x000fe400020006ffULL,
0x00000039ff39723eULL, 0x000fe400020006ffULL, 0x000000ff28287812ULL, 0x000fe200078ec0ffULL,
0x2000002fff307230ULL, 0x000fe20000004100ULL, 0x000000ff1b167812ULL, 0x000fe200078ec0ffULL,
0x20000039ff2d7230ULL, 0x000fe20000004100ULL, 0x00000038ff38723eULL, 0x000fc400020006ffULL,
0x0000ffff1b1b7812ULL, 0x000fe400078ec0ffULL, 0x0000002eff2e723eULL, 0x000fe200020006ffULL,
0x20000038ff2f7230ULL, 0x000fe20000004100ULL, 0x000000ff2a2a7812ULL, 0x000fe400078ec0ffULL,
0x00000021ff21723eULL, 0x000fe400020006ffULL, 0x00000028ff28723eULL, 0x000fe400020006ffULL,
0x00000010ff297819ULL, 0x000fe20000011619ULL, 0x20000021ff277230ULL, 0x000fe20000004100ULL,
0x00000008ff397819ULL, 0x000fc4000001161bULL, 0x0000002aff38723eULL, 0x000fe200020006ffULL,
0x2000002eff2a7230ULL, 0x000fe20000004100ULL, 0x000000ff183b7812ULL, 0x040fe200078ec0ffULL,
0x20000028ff2e7230ULL, 0x000fe20000004100ULL, 0x00000018ff3a7819ULL, 0x000fe40000011618ULL,
0x0000ffff18327812ULL, 0x000fe400078ec0ffULL, 0x000000ff193c7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff187819ULL, 0x000fc40000011619ULL, 0x000000ff1a3d7812ULL, 0x040fe400078ec0ffULL,
0x00000023ff23723eULL, 0x000fe400020006ffULL, 0x0000ffff1a1a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff29297812ULL, 0x000fe200078ec0ffULL, 0x20000023ff2c7230ULL, 0x000fe20000004100ULL,
0x00000039ff28723eULL, 0x000fe400020006ffULL, 0x00000022ff22723eULL, 0x000fc400020006ffULL,
0x00000024ff17723eULL, 0x000fe400020006ffULL, 0x0000003cff19723eULL, 0x000fe200020006ffULL,
0x20000022ff247230ULL, 0x000fe20000004100ULL, 0x00000018ff18723eULL, 0x000fe200020006ffULL,
0x20000017ff237230ULL, 0x000fe20000004100ULL, 0x0000003bff21723eULL, 0x000fe200020006ffULL,
0x20000019ff197230ULL, 0x000fe20000004100ULL, 0x00000029ff29723eULL, 0x000fe200020006ffULL,
0x20000018ff187230ULL, 0x000fe20000004100ULL, 0x00000008ff1a7819ULL, 0x000fe2000001161aULL,
0x20000021ff217230ULL, 0x000fe20000004100ULL, 0x00000010ff3c7819ULL, 0x000fe20000011627ULL,
0x20000028ff277230ULL, 0x000fe20000004100ULL, 0x00000008ff367819ULL, 0x000fe20000011636ULL,
0x20000029ff297230ULL, 0x000fe20000004100ULL, 0x00000008ff327819ULL, 0x000fc40000011632ULL,
0x00000010ff267819ULL, 0x000fe40000011626ULL, 0x00000010ff317819ULL, 0x000fe40000011631ULL,
0x00000010ff257819ULL, 0x000fe40000011625ULL, 0x00000010ff287819ULL, 0x000fe40000011630ULL,
0x0000001aff1a723eULL, 0x000fe400020006ffULL, 0x00000010ff207819ULL, 0x000fc40000011620ULL,
0x00000010ff2f7819ULL, 0x000fe2000001162fULL, 0x2000001aff1b7230ULL, 0x000fe20000004100ULL,
0x0000003aff22723eULL, 0x000fe200020006ffULL, 0x20000038ff1a7230ULL, 0x000fe20000004100ULL,
0x0000003dff17723eULL, 0x000fe400020006ffULL, 0x00000016ff16723eULL, 0x000fe200020006ffULL,
0x20000022ff227230ULL, 0x000fe20000004100ULL, 0x00000036ff36723eULL, 0x000fe200020006ffULL,
0x20000017ff177230ULL, 0x000fe20000004100ULL, 0x00000032ff32723eULL, 0x000fe200020006ffULL,
0x20000016ff167230ULL, 0x000fe20000004100ULL, 0x00000010ff2c7819ULL, 0x000fe2000001162cULL,
0x20000036ff367230ULL, 0x000fe20000004100ULL, 0x00000010ff357819ULL, 0x000fe20000011635ULL,
0x20000032ff327230ULL, 0x000fe20000004100ULL, 0x0000105431307816ULL, 0x000fc40000000026ULL,
0x0000105428317816ULL, 0x000fe40000000025ULL, 0x00000010ff287819ULL, 0x000fe4000001162dULL,
0x00001054202d7816ULL, 0x000fe4000000002fULL, 0x00001054353d7816ULL, 0x000fe4000000002cULL,
0x00000010ff207819ULL, 0x000fe40000011618ULL, 0x00000010ff247819ULL, 0x000fc40000011624ULL,
0x00000010ff237819ULL, 0x000fe40000011623ULL, 0x00000010ff337819ULL, 0x000fe40000011633ULL,
0x00000010ff2c7819ULL, 0x000fe40000011637ULL, 0x00000010ff217819ULL, 0x000fe40000011621ULL,
0x00000010ff197819ULL, 0x000fe40000011619ULL, 0x00000010ff187819ULL, 0x000fc40000011629ULL,
0x00000010ff397819ULL, 0x000fe4000001162bULL, 0x00000010ff2b7819ULL, 0x000fe40000011634ULL,
0x0000105424357816ULL, 0x000fe40000000033ULL, 0x00001054232c7816ULL, 0x000fe4000000002cULL,
0x0000105428287816ULL, 0x000fe40000000021ULL, 0x00000010ff257819ULL, 0x000fc4000001162aULL,
0x0000105418297816ULL, 0x000fe40000000019ULL, 0x00000010ff347819ULL, 0x000fe40000011636ULL,
0x00000010ff237819ULL, 0x000fe40000011622ULL, 0x00000010ff247819ULL, 0x000fe40000011632ULL,
0x00000010ff177819ULL, 0x000fe20000011617ULL, 0x000000301c30723cULL, 0x008fe200000418ffULL,
0x00000010ff2e7819ULL, 0x000fc4000001162eULL, 0x00000010ff187819ULL, 0x000fe40000011615ULL,
0x00000010ff167819ULL, 0x000fe40000011616ULL, 0x00000010ff217819ULL, 0x000fe4000001161aULL,
0x00000010ff1b7819ULL, 0x000fe4000001161bULL, 0x00000010ff1a7819ULL, 0x000fe40000011614ULL,
0x00000010ff157819ULL, 0x000fc40000011627ULL, 0x0000105420257816ULL, 0x000fe40000000025ULL,
0x000010542b3c7816ULL, 0x000fe4000000003cULL, 0x0000105439347816ULL, 0x000fe20000000034ULL,
0x000000281c28723cULL, 0x000fe200000418ffULL, 0x0000105423247816ULL, 0x000fe40000000024ULL,
0x000010542e207816ULL, 0x000fe40000000017ULL, 0x0000105421217816ULL, 0x000fe20000000016ULL,
0x0000003c1c3c723cULL, 0x000fe200000418ffULL, 0x0000105418147816ULL, 0x000fc4000000001bULL,
0x000010541a157816ULL, 0x000fe40000000015ULL, 0x013000005e18783bULL, 0x0002e20000000200ULL,
0x000000341c34723cULL, 0x000fec00000418ffULL, 0x0000002c1c2c723cULL, 0x000fec00000418ffULL,
0x000000241c24723cULL, 0x000fec00000418ffULL, 0x000000201c20723cULL, 0x000fec00000418ffULL,
0x000000141c1c723cULL, 0x000fe200000418ffULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000102947ULL, 0x002fde0003800000ULL, 0x0000000318187232ULL, 0x088fe40000200000ULL,
0x000000031a1a7232ULL, 0x000fe40000200000ULL, 0x0000000419197232ULL, 0x084fe40000200000ULL,
0x000000041b1b7232ULL, 0x000fce0000200000ULL, 0x000000006214783bULL, 0x000e620000004200ULL,
0x0000006b6300720cULL, 0x080fe20003f66070ULL, 0x00000c3000007945ULL, 0x000fe20003800000ULL,
0x000000085f00720cULL, 0x0c0fe40003fc3070ULL, 0x0000006b6c00720cULL, 0x000fe40003f86070ULL,
0x000000085f00720cULL, 0x000fe40003fa3070ULL, 0x00000010ff387819ULL, 0x002fe40000011614ULL,
0x00000010ff3a7819ULL, 0x000fc40000011615ULL, 0x000000ff14397812ULL, 0x000fe400078ec0ffULL,
0x000000ff38387812ULL, 0x000fe400078ec0ffULL, 0x000000ff3a3a7812ULL, 0x000fe400078ec0ffULL,
0x00000039ff39723eULL, 0x000fe400020006ffULL, 0x00000038ff38723eULL, 0x000fe400020006ffULL,
0x0000003aff50723eULL, 0x000fe200020006ffULL, 0x20000039ff397230ULL, 0x000fe20000004100ULL,
0x000000ff153b7812ULL, 0x000fe200078ec0ffULL, 0x20000038ff3a7230ULL, 0x000fe20000004100ULL,
0x00000018ff387819ULL, 0x000fe20000011614ULL, 0x20000050ff727230ULL, 0x000fe20000004100ULL,
0x0000003bff3b723eULL, 0x000fc400020006ffULL, 0x00000010ff397819ULL, 0x000fe40000011639ULL,
0x00000010ff3a7819ULL, 0x000fe2000001163aULL, 0x2000003bff717230ULL, 0x000fe20000004100ULL,
0x00000038ff51723eULL, 0x000fe400020006ffULL, 0x000010543a507816ULL, 0x000fe40000000039ULL,
0x000000006038783bULL, 0x000e620000004200ULL, 0x00000010ff717819ULL, 0x000fe40000011671ULL,
0x00000010ff727819ULL, 0x000fc40000011672ULL, 0x00000018ff6f7819ULL, 0x000fe40000011615ULL,
0x0000ffff14747812ULL, 0x000fe200078ec0ffULL, 0x20000051ff147230ULL, 0x000fe20000004100ULL,
0x000000ff16737812ULL, 0x000fe400078ec0ffULL, 0x0000105472517816ULL, 0x000fe40000000071ULL,
0x0000006fff6f723eULL, 0x000fe400020006ffULL, 0x0000ffff15157812ULL, 0x000fc400078ec0ffULL,
0x00000008ff717819ULL, 0x000fe20000011674ULL, 0x00000050183c723cULL, 0x008fe2000004183cULL,
0x00000073ff73723eULL, 0x000fe400020006ffULL, 0x00000008ff727819ULL, 0x000fe20000011615ULL,
0x2000006fff157230ULL, 0x000fe20000004100ULL, 0x00000071ff71723eULL, 0x000fe200020006ffULL,
0x20000073ff6f7230ULL, 0x000fe20000004100ULL, 0x000000ff17747812ULL, 0x000fe400078ec0ffULL,
0x00000010ff737819ULL, 0x000fe20000011616ULL, 0x20000071ff717230ULL, 0x000fe20000004100ULL,
0x00000072ff72723eULL, 0x000fc400020006ffULL, 0x00000074ff50723eULL, 0x000fe400020006ffULL,
0x000000ff73747812ULL, 0x000fe200078ec0ffULL, 0x20000072ff727230ULL, 0x000fe20000004100ULL,
0x00000010ff737819ULL, 0x000fe40000011614ULL, 0x00000010ff147819ULL, 0x000fe40000011671ULL,
0x00000074ff71723eULL, 0x000fe400020006ffULL, 0x00000010ff747819ULL, 0x000fc40000011615ULL,
0x0000105473147816ULL, 0x000fe40000000014ULL, 0x00000010ff157819ULL, 0x000fe20000011672ULL,
0x20000071ff727230ULL, 0x000fe20000004100ULL, 0x00000010ff737819ULL, 0x000fe40000011617ULL,
0x00000018ff517819ULL, 0x000fe40000011616ULL, 0x0000ffff16717812ULL, 0x000fe400078ec0ffULL,
0x000000ff73737812ULL, 0x000fc400078ec0ffULL, 0x00000010ff167819ULL, 0x000fe4000001166fULL,
0x00000010ff6f7819ULL, 0x000fe40000011672ULL, 0x00000018ff727819ULL, 0x000fe40000011617ULL,
0x0000105474157816ULL, 0x000fe40000000015ULL, 0x00000073ff73723eULL, 0x000fe400020006ffULL,
0x0000ffff17757812ULL, 0x000fe200078ec0ffULL, 0x20000050ff177230ULL, 0x000fe20000004100ULL,
0x000010546f167816ULL, 0x000fe20000000016ULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x00000072ff6f723eULL, 0x000fe200020006ffULL, 0x000000141834723cULL, 0x000fe20000041834ULL,
0x00000008ff727819ULL, 0x000fc40000011671ULL, 0x000000ff38747812ULL, 0x002fe200078ec0ffULL,
0x2000006fff6f7230ULL, 0x000fe20000004100ULL, 0x00000008ff717819ULL, 0x000fe40000011675ULL,
0x00000051ff51723eULL, 0x000fe400020006ffULL, 0x00000072ff72723eULL, 0x000fe400020006ffULL,
0x00000010ff147819ULL, 0x000fe20000011638ULL, 0x20000051ff517230ULL, 0x000fe20000004100ULL,
0x00000074ff50723eULL, 0x000fe200020006ffULL, 0x20000072ff727230ULL, 0x000fe20000004100ULL,
0x00000071ff71723eULL, 0x000fc400020006ffULL, 0x00000010ff157819ULL, 0x000fe20000011639ULL,
0x20000050ff507230ULL, 0x000fe20000004100ULL, 0x00000010ff177819ULL, 0x000fe20000011617ULL,
0x20000071ff717230ULL, 0x000fe20000004100ULL, 0x00000010ff747819ULL, 0x000fe40000011673ULL,
0x000000ff39737812ULL, 0x000fe400078ec0ffULL, 0x000000ff14147812ULL, 0x000fe400078ec0ffULL,
0x000000ff15157812ULL, 0x000fc400078ec0ffULL, 0x0000105474177816ULL, 0x000fe40000000017ULL,
0x00000073ff74723eULL, 0x000fe400020006ffULL, 0x00000014ff73723eULL, 0x000fe400020006ffULL,
0x00000015ff75723eULL, 0x000fe200020006ffULL, 0x000000161830723cULL, 0x000fe20000041830ULL,
0x00000010ff157819ULL, 0x000fe20000011651ULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x00000010ff147819ULL, 0x000fe20000011672ULL, 0x20000075ff757230ULL, 0x000fe20000004100ULL,
0x00000010ff727819ULL, 0x000fe2000001166fULL, 0x20000074ff517230ULL, 0x000fe20000004100ULL,
0x00000010ff717819ULL, 0x000fc40000011671ULL, 0x0000105415147816ULL, 0x000fe40000000014ULL,
0x0000105472157816ULL, 0x000fe40000000071ULL, 0x00000018ff167819ULL, 0x000fe40000011638ULL,
0x00000010ff177819ULL, 0x000fe40000011650ULL, 0x00000010ff727819ULL, 0x000fe20000011673ULL,
0x00000014182c723cULL, 0x000fe2000004182cULL, 0x00000010ff747819ULL, 0x000fc40000011675ULL,
0x00000016ff50723eULL, 0x000fe400020006ffULL, 0x0000105472167816ULL, 0x000fe40000000017ULL,
0x0000ffff38757812ULL, 0x000fe400078ec0ffULL, 0x00000010ff717819ULL, 0x000fe40000011651ULL,
0x00000010ff727819ULL, 0x000fe4000001163aULL, 0x000000ff3a157812ULL, 0x000fc400078ec0ffULL,
0x00000018ff147819ULL, 0x000fe4000001163aULL, 0x0000ffff3a387812ULL, 0x000fe400078ec0ffULL,
0x000000ff3b3a7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff6f7819ULL, 0x000fe40000011639ULL,
0x0000ffff39737812ULL, 0x000fe200078ec0ffULL, 0x20000050ff397230ULL, 0x000fe20000004100ULL,
0x0000105474177816ULL, 0x000fc40000000071ULL, 0x00000015ff15723eULL, 0x000fe400020006ffULL,
0x00000018ff747819ULL, 0x100fe4000001163bULL, 0x0000003aff50723eULL, 0x000fe200020006ffULL,
0x000000161828723cULL, 0x000fe20000041828ULL, 0x0000006fff51723eULL, 0x000fe400020006ffULL,
0x00000010ff717819ULL, 0x000fe4000001163bULL, 0x0000ffff3b6f7812ULL, 0x000fe200078ec0ffULL,
0x20000051ff517230ULL, 0x000fe20000004100ULL, 0x00000008ff3a7819ULL, 0x000fc40000011675ULL,
0x00000014ff3b723eULL, 0x000fe200020006ffULL, 0x20000015ff147230ULL, 0x000fe20000004100ULL,
0x00000008ff737819ULL, 0x000fe20000011673ULL, 0x20000050ff157230ULL, 0x000fe20000004100ULL,
0x00000074ff74723eULL, 0x000fe400020006ffULL, 0x0000003aff50723eULL, 0x000fe200020006ffULL,
0x2000003bff3a7230ULL, 0x000fe20000004100ULL, 0x000000ff72727812ULL, 0x000fe200078ec0ffULL,
0x20000074ff3b7230ULL, 0x000fe20000004100ULL, 0x00000073ff73723eULL, 0x000fc400020006ffULL,
0x000000ff71747812ULL, 0x000fe200078ec0ffULL, 0x20000050ff717230ULL, 0x000fe20000004100ULL,
0x00000072ff72723eULL, 0x000fe200020006ffULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x00000008ff387819ULL, 0x000fe40000011638ULL, 0x00000074ff75723eULL, 0x000fe200020006ffULL,
0x20000072ff507230ULL, 0x000fe20000004100ULL, 0x00000038ff74723eULL, 0x000fe400020006ffULL,
0x00000010ff397819ULL, 0x000fc40000011639ULL, 0x00000010ff387819ULL, 0x000fe20000011671ULL,
0x20000074ff717230ULL, 0x000fe20000004100ULL, 0x00000010ff727819ULL, 0x000fe40000011651ULL,
0x00000010ff737819ULL, 0x000fe40000011673ULL, 0x0000105439387816ULL, 0x000fe40000000038ULL,
0x00000008ff6f7819ULL, 0x000fe4000001166fULL, 0x0000105472397816ULL, 0x000fc40000000073ULL,
0x0000006fff76723eULL, 0x000fe200020006ffULL, 0x20000075ff6f7230ULL, 0x000fe20000004100ULL,
0x00000010ff177819ULL, 0x000fe40000011615ULL, 0x00000010ff147819ULL, 0x000fe20000011614ULL,
0x000000381824723cULL, 0x000fe20000041824ULL, 0x20000076ff517230ULL, 0x000fe20000004100ULL,
0x00000010ff157819ULL, 0x000fe40000011650ULL, 0x00000010ff3a7819ULL, 0x000fe4000001163aULL,
0x00000010ff727819ULL, 0x000fe2000001163bULL, 0x000000016b387836ULL, 0x000fe20000000000ULL,
0x00000010ff507819ULL, 0x000fc4000001166fULL, 0x00000010ff717819ULL, 0x000fe40000011671ULL,
0x000000386300720cULL, 0x000fe40005f66470ULL, 0x00000010ff517819ULL, 0x000fe40000011651ULL,
0x0000105415167816ULL, 0x000fe40000000014ULL, 0x0000105450177816ULL, 0x000fe40000000017ULL,
0x000010543a147816ULL, 0x000fc40000000071ULL, 0x0000105472157816ULL, 0x000fe40000000051ULL,
0x000000386c00720cULL, 0x000fe20006786470ULL, 0x000000161820723cULL, 0x000fec0000041820ULL,
0x00000014181c723cULL, 0x000fe2000004181cULL, 0x00000001ff167424ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000403947ULL, 0x000fde0003000000ULL,
0x0000003c0b0b7221ULL, 0x000fe20000010000ULL, 0x0000003d0c0c7221ULL, 0x000fe20000010000ULL,
0x000000340f0f7221ULL, 0x000fe20000010000ULL, 0x0000003510107221ULL, 0x000fe20000010000ULL,
0x0000003041417221ULL, 0x000fe20000010000ULL, 0x0000003142427221ULL, 0x000fe20000010000ULL,
0x0000002c45457221ULL, 0x000fe20000010000ULL, 0x0000002d46467221ULL, 0x000fe20000010000ULL,
0x0000002849497221ULL, 0x000fe20000010000ULL, 0x000000294a4a7221ULL, 0x000fe20000010000ULL,
0x000000244d4d7221ULL, 0x000fe20000010000ULL, 0x000000254e4e7221ULL, 0x000fe20000010000ULL,
0x0000002053537221ULL, 0x000fe20000010000ULL, 0x0000002154547221ULL, 0x000fe20000010000ULL,
0x0000001c57577221ULL, 0x000fe20000010000ULL, 0x0000001d58587221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000012000007945ULL, 0x000fe80003800000ULL,
0x0000000000404947ULL, 0x000fea0002800000ULL, 0x0000003e0d0d7221ULL, 0x000fe20000010000ULL,
0x0000003f0e0e7221ULL, 0x000fe20000010000ULL, 0x0000003611117221ULL, 0x000fe20000010000ULL,
0x0000003740407221ULL, 0x000fe20000010000ULL, 0x0000003243437221ULL, 0x000fe20000010000ULL,
0x0000003344447221ULL, 0x000fe20000010000ULL, 0x0000002e47477221ULL, 0x000fe20000010000ULL,
0x0000002f48487221ULL, 0x000fe20000010000ULL, 0x0000002a4b4b7221ULL, 0x000fe20000010000ULL,
0x0000002b4c4c7221ULL, 0x000fe20000010000ULL, 0x000000264f4f7221ULL, 0x000fe20000010000ULL,
0x0000002752527221ULL, 0x000fe20000010000ULL, 0x0000002255557221ULL, 0x000fe20000010000ULL,
0x0000002356567221ULL, 0x000fe20000010000ULL, 0x0000001e59597221ULL, 0x000fe20000010000ULL,
0x0000001f5a5a7221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x018b8816ff1479a7ULL, 0x000e620008500007ULL, 0x00000002ff177819ULL, 0x000fe40000011638ULL,
0x000000085f00720cULL, 0x0c0fe40003fc3070ULL, 0x0000001738177207ULL, 0x040fe40000000000ULL,
0x00000003381a7812ULL, 0x000fe400078ec0ffULL, 0x000000085f00720cULL, 0x000fe20003fa3070ULL,
0x0000000217177836ULL, 0x000fe20000000000ULL, 0x00000040ff387803ULL, 0x000fc40000000000ULL,
0x000000ff1a1a7207ULL, 0x000fe40004000000ULL, 0x00000003171b7812ULL, 0x040fe400078ec0ffULL,
0x00000008171c7211ULL, 0x000fe200078ff0ffULL, 0x000000ffff187224ULL, 0x002fce00078e0015ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x018b806dff0075a7ULL, 0x000e6400080c0147ULL,
0x00000000005c6947ULL, 0x002fea0003800000ULL, 0x000000ffff1d7224ULL, 0x000fce00078e00ffULL,
0x000000101d00780cULL, 0x000fda0003fc6270ULL, 0x000000000044e947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x0000001416197210ULL, 0x000fca0007fde1ffULL,
0x0000000115157824ULL, 0x000fe200030e0e17ULL, 0x003d09001900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x000000000008e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x00000000001ce947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001914147211ULL, 0x000fca00078d10ffULL, 0x000000ffff157224ULL, 0x000fca00030e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011d1d7836ULL, 0x000fce0000000000ULL,
0x018b806dff0075a7ULL, 0x000e6400080c0147ULL, 0xfffffffc00a8e947ULL, 0x002fea000383ffffULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x018b8818ff0075a7ULL, 0x000e6400080c0147ULL,
0x00000000005c6947ULL, 0x002fea0003800000ULL, 0x000000ffff1d7224ULL, 0x000fce00078e00ffULL,
0x000000101d00780cULL, 0x000fda0003fc6270ULL, 0x000000000044e947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x0000001416197210ULL, 0x000fca0007fde1ffULL,
0x0000000115157824ULL, 0x000fe200030e0e17ULL, 0x003d09001900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x000000000008e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x00000000001ce947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001914147211ULL, 0x000fca00078d10ffULL, 0x000000ffff157224ULL, 0x000fca00030e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011d1d7836ULL, 0x000fce0000000000ULL,
0x018b8818ff0075a7ULL, 0x000e6400080c0147ULL, 0xfffffffc00a8e947ULL, 0x002fea000383ffffULL,
0x000000041c147824ULL, 0x000fc800078e021bULL, 0x00000040141e7824ULL, 0x000fe400078e00ffULL,
0x000000011c147836ULL, 0x000fc60000000000ULL, 0x000000405b1d7812ULL, 0x000fe400078ef81eULL,
0x0000000c14007c0cULL, 0x000fda000bfc6070ULL, 0x000000040054e947ULL, 0x000fea0003800000ULL,
0x000000015d207824ULL, 0x000fe200078e0270ULL, 0x000000091e187c48ULL, 0x000fe2000ffe0000ULL,
0x00000010121f7824ULL, 0x000fe200078e00ffULL, 0x00014000070e7890ULL, 0x000fe2000fffe03fULL,
0x0000000120177824ULL, 0x040fe200078e021dULL, 0x0000000720227c11ULL, 0x000fe2000f8e10ffULL,
0x0000000118187824ULL, 0x000fe200078e0a1eULL, 0x000000f01f1f7812ULL, 0x000fc600078ec0ffULL,
0x018a000022147984ULL, 0x000e620000000800ULL, 0x000000185d187248ULL, 0x000fca0007fe0000ULL,
0x0000000118217824ULL, 0x000fe200078e0a5dULL, 0x0000000714197c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e660000000a00ULL, 0x018ac00019167984ULL, 0x0007240000000800ULL,
0x0000000120197824ULL, 0x048fe400078e0212ULL, 0x0000001020207824ULL, 0x000fca00078e00ffULL,
0xfffffff020197812ULL, 0x000fe200078ee219ULL, 0x0000000270207836ULL, 0x000fc60000000000ULL,
0x0000000e19237c11ULL, 0x000fe2000f8e20ffULL, 0x000000015d247824ULL, 0x000fc800078e0220ULL,
0x0000000124197824ULL, 0x000fe400078e021dULL, 0x0000000616177c24ULL, 0x010fc8000f8e0217ULL,
0x0000010017167825ULL, 0x002fc600078e0014ULL, 0x0000001f16167210ULL, 0x000fca0007fde0ffULL,
0x000000ffff177224ULL, 0x000fe200030e0617ULL, 0x000000217000720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e8000f101c4aULL,
0x018a080022187984ULL, 0x000ee20000000800ULL, 0x0000000124167824ULL, 0x042fe400078e0212ULL,
0x0000001024177824ULL, 0x000fca00078e00ffULL, 0xfffffff017167812ULL, 0x000fc800078ee216ULL,
0x0000000e16237c11ULL, 0x000fe4000f8e20ffULL, 0x00000007181e7c11ULL, 0x008fca000f8e10ffULL,
0x018ac0001e187984ULL, 0x000e640000000800ULL, 0x0000000618197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000001f18187210ULL, 0x000fca0007fde0ffULL,
0x000000ffff197224ULL, 0x000fe200030e0619ULL, 0x000000212000720cULL, 0x000fe20003fc6070ULL,
0x0000000470207836ULL, 0x000fe40000000000ULL, 0x0000000670707836ULL, 0x000fe40000000000ULL,
0x000000015d247824ULL, 0x000fc800078e0220ULL, 0x0000000124177824ULL, 0x000fc800078e021dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018237faeULL, 0x0003e8000f101c4aULL,
0x018a100022167984ULL, 0x000ee20000000800ULL, 0x0000000124187824ULL, 0x042fe400078e0212ULL,
0x0000001024197824ULL, 0x000fca00078e00ffULL, 0xfffffff019187812ULL, 0x000fc800078ee218ULL,
0x0000000e18197c11ULL, 0x000fe4000f8e20ffULL, 0x00000007161e7c11ULL, 0x008fca000f8e10ffULL,
0x018ac0001e167984ULL, 0x0002e40000000800ULL, 0x000000015d1e7824ULL, 0x002fc800078e0270ULL,
0x000000011e1d7824ULL, 0x000fe400078e021dULL, 0x0000000616177c24ULL, 0x008fc8000f8e0217ULL,
0x0000010017167825ULL, 0x000fc600078e0014ULL, 0x0000001f16167210ULL, 0x000fca0007fde0ffULL,
0x000000ffff177224ULL, 0x000fe200030e0617ULL, 0x000000212000720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016197faeULL, 0x0003e8000f101c4aULL,
0x018a180022187984ULL, 0x000ee20000000800ULL, 0x000000011e167824ULL, 0x042fe400078e0212ULL,
0x000000101e177824ULL, 0x000fca00078e00ffULL, 0xfffffff017167812ULL, 0x000fc800078ee216ULL,
0x0000000e16177c11ULL, 0x000fe4000f8e20ffULL, 0x0000000718187c11ULL, 0x008fcc000f8e10ffULL,
0x018ac00018187984ULL, 0x000e640000000800ULL, 0x00000006181d7c24ULL, 0x002fc8000f8e021dULL,
0x000001001d147825ULL, 0x000fc600078e0014ULL, 0x0000001f14147210ULL, 0x000fca0007fde0ffULL,
0x000000ffff157224ULL, 0x000fe200030e0615ULL, 0x000000217000720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e2000f101c4aULL,
0x0000000400247947ULL, 0x000fea0003800000ULL, 0x000000015d707824ULL, 0x000fe200078e0270ULL,
0x00014000070e7890ULL, 0x000fe2000fffe03fULL, 0x0000001012197824ULL, 0x000fe400078e00ffULL,
0x0000000170177824ULL, 0x040fe200078e021dULL, 0x00000007701f7c11ULL, 0x040fe2000f8e10ffULL,
0x00000010701e7824ULL, 0x040fe200078e00ffULL, 0x000000f019217812ULL, 0x000fe200078ec0ffULL,
0x0000000170197824ULL, 0x000fe400078e0212ULL, 0x018a00001f147984ULL, 0x000e620000000800ULL,
0x0000000270207836ULL, 0x000fc40000000000ULL, 0xfffffff01e197812ULL, 0x000fe400078ee219ULL,
0x0000000120227824ULL, 0x040fe400078e0212ULL, 0x0000000e19237c11ULL, 0x000fe2000f8e20ffULL,
0x0000000120197824ULL, 0x000fe200078e021dULL, 0x0000000714187c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e660000000a00ULL, 0x018ac00018167984ULL, 0x000ee40000000800ULL,
0x0000000616177c24ULL, 0x008fc8000f8e0217ULL, 0x0000010017167825ULL, 0x002fc600078e0014ULL,
0x0000002116167210ULL, 0x000fca0007fde0ffULL, 0x000000ffff177224ULL, 0x000fca00030e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e8000b901c4aULL,
0x018a08001f187984ULL, 0x000ee20000000800ULL, 0x0000001020177824ULL, 0x002fe400078e00ffULL,
0x0000000470207836ULL, 0x000fe40000000000ULL, 0x0000000670707836ULL, 0x000fe20000000000ULL,
0xfffffff017227812ULL, 0x000fe200078ee222ULL, 0x0000000120177824ULL, 0x000fc400078e021dULL,
0x00000001701d7824ULL, 0x000fe200078e021dULL, 0x0000000e22237c11ULL, 0x000fe2000f8e20ffULL,
0x0000000120227824ULL, 0x000fe200078e0212ULL, 0x00000007181e7c11ULL, 0x008fca000f8e10ffULL,
0x018ac0001e187984ULL, 0x000e640000000800ULL, 0x0000000618197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000002118187210ULL, 0x000fca0007fde0ffULL,
0x000000ffff197224ULL, 0x000fca00030e0619ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018237faeULL, 0x0003e8000b901c4aULL, 0x018a10001f167984ULL, 0x000ee20000000800ULL,
0x0000001020197824ULL, 0x002fca00078e00ffULL, 0xfffffff019227812ULL, 0x000fc800078ee222ULL,
0x0000000e22197c11ULL, 0x000fe4000f8e20ffULL, 0x00000007161e7c11ULL, 0x008fca000f8e10ffULL,
0x018ac0001e167984ULL, 0x000e640000000800ULL, 0x0000000616177c24ULL, 0x002fc8000f8e0217ULL,
0x0000010017167825ULL, 0x000fc600078e0014ULL, 0x0000002116167210ULL, 0x000fca0007fde0ffULL,
0x000000ffff177224ULL, 0x000fca00030e0617ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016197faeULL, 0x0003e8000b901c4aULL, 0x018a18001f187984ULL, 0x000ee40000000800ULL,
0x0000000718187c11ULL, 0x008fcc000f8e10ffULL, 0x018ac00018187984ULL, 0x000ee40000000800ULL,
0x00000006181d7c24ULL, 0x008fc8000f8e021dULL, 0x000001001d147825ULL, 0x000fc800078e0014ULL,
0x00000001701d7824ULL, 0x040fe200078e0212ULL, 0x0000002114147210ULL, 0x000fe20007fde0ffULL,
0x0000001070707824ULL, 0x000fc800078e00ffULL, 0x000000ffff157224ULL, 0x000fe200030e0615ULL,
0xfffffff0701d7812ULL, 0x000fc800078ee21dULL, 0x0000000e1d1d7c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000141d7faeULL, 0x0003e4000b901c4aULL,
0x00000001ff147424ULL, 0x002fcc00078e00ffULL, 0x018b8814ff1479a7ULL, 0x000e640008500007ULL,
0x000000ffff187224ULL, 0x002fce00078e0015ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x018b8818ff0075a7ULL, 0x000e6400080c0147ULL, 0x00000000005c6947ULL, 0x002fea0003800000ULL,
0x000000ffff1d7224ULL, 0x000fce00078e00ffULL, 0x000000101d00780cULL, 0x000fda0003fc6270ULL,
0x000000000044e947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x0000001416197210ULL, 0x000fca0007fde1ffULL, 0x0000000115157824ULL, 0x000fe200030e0e17ULL,
0x003d09001900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x000000000008e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x00000000001ce947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078d10ffULL,
0x000000ffff157224ULL, 0x000fca00030e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011d1d7836ULL, 0x000fce0000000000ULL, 0x018b8818ff0075a7ULL, 0x000e6400080c0147ULL,
0xfffffffc00a8e947ULL, 0x002fea000383ffffULL, 0x0000019000007945ULL, 0x000fe20003800000ULL,
0x00000001ff6f7424ULL, 0x000fc600078e00ffULL, 0x0000000000581947ULL, 0x000fea0003800000ULL,
0x0000001c5f00720cULL, 0x000fe20003fc4070ULL, 0x00009400ff187b82ULL, 0x000e620000000800ULL,
0x000000076e197c11ULL, 0x000fe4000f8e10ffULL, 0x000000ff1a147207ULL, 0x040fe40003000000ULL,
0x000000ff1a177207ULL, 0x000fc60007000000ULL, 0x000000011b1b7824ULL, 0x000fe400078e0214ULL,
0x00009200ff147b82ULL, 0x000ee20000000a00ULL, 0x000000015c177824ULL, 0x000fe400078e0217ULL,
0x000000401b167824ULL, 0x040fe200078e00ffULL, 0x0000001c1b1b7211ULL, 0x000fc800078ff0ffULL,
0x000000c016167812ULL, 0x000fca00078ec0ffULL, 0x000001001b167824ULL, 0x000fc800078e0216ULL,
0x0000002016167836ULL, 0x000fc80000000000ULL, 0x0000001817177224ULL, 0x102fe400078e0216ULL,
0x000000016e167824ULL, 0x040fe400078e0216ULL, 0x000000016e177824ULL, 0x000fc600078e0217ULL,
0x0000000916007c0cULL, 0x000fe2000bfc6070ULL, 0x0000000417147825ULL, 0x008fd800078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18a0000014197faeULL, 0x0003e4000f12184aULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a48ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x018b786fff6e79a7ULL, 0x000e620008500007ULL, 0x0000000000102947ULL, 0x000fea0003800000ULL,
0x00000006ff03723eULL, 0x000fc800000010ffULL, 0x0000541003147816ULL, 0x000fca0000000003ULL,
0x00001f6c14047589ULL, 0x0044e800000e0000ULL, 0x00001f6314037589ULL, 0x00046400000e0000ULL,
0x013000006630783bULL, 0x0006a20000000200ULL, 0x0000000000102947ULL, 0x000fea0003800000ULL,
0x0000000330307232ULL, 0x086fe40000200000ULL, 0x0000000332327232ULL, 0x000fe40000200000ULL,
0x0000000431317232ULL, 0x088fe40000200000ULL, 0x0000000433337232ULL, 0x000fce0000200000ULL,
0x000000006514783bULL, 0x004ea80000004200ULL, 0x000000006418783bULL, 0x000f220000004200ULL,
0x0000ffff162a7812ULL, 0x044fe400078ec0ffULL, 0x00000010ff2b7819ULL, 0x000fe40000011617ULL,
0x000000ff16227812ULL, 0x000fe400078ec0ffULL, 0x00000008ff2a7819ULL, 0x000fc4000001162aULL,
0x000000ff2b2b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff151f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff2f7819ULL, 0x100fe40000011616ULL, 0x00000018ff207819ULL, 0x000fe40000011616ULL,
0x0000ffff182e7812ULL, 0x010fe400078ec0ffULL, 0x00000022ff22723eULL, 0x000fc400020006ffULL,
0x00000018ff167819ULL, 0x000fe40000011617ULL, 0x000000ff17237812ULL, 0x040fe400078ec0ffULL,
0x0000ffff172c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff18267812ULL, 0x000fe400078ec0ffULL,
0x000000ff193a7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff3b7819ULL, 0x000fc4000001161aULL,
0x0000002aff2a723eULL, 0x000fe400020006ffULL, 0x0000002bff2b723eULL, 0x000fe400020006ffULL,
0x00000010ff2d7819ULL, 0x100fe40000011618ULL, 0x00000018ff177819ULL, 0x000fe40000011618ULL,
0x00000010ff217819ULL, 0x100fe40000011619ULL, 0x00000018ff397819ULL, 0x000fc40000011619ULL,
0x0000ffff19277812ULL, 0x000fe400078ec0ffULL, 0x00000010ff357819ULL, 0x100fe40000011615ULL,
0x00000018ff1e7819ULL, 0x000fe40000011615ULL, 0x0000ffff15347812ULL, 0x000fe400078ec0ffULL,
0x00000010ff187819ULL, 0x000fe4000001161aULL, 0x000000ff1a3c7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff1a247812ULL, 0x000fe400078ec0ffULL, 0x0000001fff1f723eULL, 0x000fe400020006ffULL,
0x00000020ff19723eULL, 0x000fe200020006ffULL, 0x20000022ff207230ULL, 0x000fe20000004100ULL,
0x00000008ff2e7819ULL, 0x000fe2000001162eULL, 0x2000001fff297230ULL, 0x000fe20000004100ULL,
0x00000010ff257819ULL, 0x000fe2000001161bULL, 0x20000019ff197230ULL, 0x000fe20000004100ULL,
0x000000ff1b3d7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff1a7819ULL, 0x000fe4000001161bULL,
0x0000ffff1b157812ULL, 0x000fe400078ec0ffULL, 0x00000016ff16723eULL, 0x000fe400020006ffULL,
0x00000026ff26723eULL, 0x000fe400020006ffULL, 0x0000003aff1b723eULL, 0x000fe200020006ffULL,
0x2000002aff3a7230ULL, 0x000fe20000004100ULL, 0x0000003bff22723eULL, 0x000fe200020006ffULL,
0x2000002bff3b7230ULL, 0x000fe20000004100ULL, 0x00000010ff377819ULL, 0x000fe20000011614ULL,
0x20000016ff1f7230ULL, 0x000fe20000004100ULL, 0x00000039ff39723eULL, 0x000fe200020006ffULL,
0x20000026ff167230ULL, 0x000fe20000004100ULL, 0x0000002eff2a723eULL, 0x000fe200020006ffULL,
0x2000001bff1b7230ULL, 0x000fe20000004100ULL, 0x000000ff212b7812ULL, 0x000fe200078ec0ffULL,
0x20000022ff227230ULL, 0x000fe20000004100ULL, 0x0000ffff14367812ULL, 0x040fe200078ec0ffULL,
0x2000002aff217230ULL, 0x000fe20000004100ULL, 0x000000ff141d7812ULL, 0x000fc400078ec0ffULL,
0x000000ff37377812ULL, 0x000fe400078ec0ffULL, 0x0000001aff26723eULL, 0x000fe200020006ffULL,
0x20000039ff1a7230ULL, 0x000fe20000004100ULL, 0x000000ff35357812ULL, 0x000fe400078ec0ffULL,
0x00000008ff2c7819ULL, 0x000fe2000001162cULL, 0x20000026ff267230ULL, 0x000fe20000004100ULL,
0x0000002bff2b723eULL, 0x000fe400020006ffULL, 0x00000008ff277819ULL, 0x000fc40000011627ULL,
0x00000018ff1c7819ULL, 0x000fe40000011614ULL, 0x00000008ff397819ULL, 0x000fe40000011636ULL,
0x000000ff252a7812ULL, 0x000fe200078ec0ffULL, 0x2000002bff257230ULL, 0x000fe20000004100ULL,
0x0000001dff14723eULL, 0x000fe400020006ffULL, 0x00000037ff36723eULL, 0x000fe400020006ffULL,
0x00000035ff35723eULL, 0x000fe200020006ffULL, 0x20000014ff147230ULL, 0x000fe20000004100ULL,
0x0000002cff2c723eULL, 0x000fe200020006ffULL, 0x20000036ff367230ULL, 0x000fe20000004100ULL,
0x00000008ff247819ULL, 0x000fe20000011624ULL, 0x20000035ff377230ULL, 0x000fe20000004100ULL,
0x00000027ff27723eULL, 0x000fe200020006ffULL, 0x2000002cff2e7230ULL, 0x000fe20000004100ULL,
0x00000008ff347819ULL, 0x000fc40000011634ULL, 0x0000002aff2b723eULL, 0x000fe200020006ffULL,
0x20000027ff2c7230ULL, 0x000fe20000004100ULL, 0x000000ff2f2f7812ULL, 0x000fe400078ec0ffULL,
0x00000024ff24723eULL, 0x000fe200020006ffULL, 0x2000002bff277230ULL, 0x000fe20000004100ULL,
0x00000008ff157819ULL, 0x000fe40000011615ULL, 0x0000001cff1c723eULL, 0x000fe200020006ffULL,
0x20000024ff2a7230ULL, 0x000fe20000004100ULL, 0x0000001eff1e723eULL, 0x000fc400020006ffULL,
0x00000023ff1d723eULL, 0x000fe200020006ffULL, 0x2000001cff287230ULL, 0x000fe20000004100ULL,
0x00000034ff34723eULL, 0x000fe200020006ffULL, 0x2000001eff1c7230ULL, 0x000fe20000004100ULL,
0x0000002fff35723eULL, 0x000fe200020006ffULL, 0x2000001dff1d7230ULL, 0x000fe20000004100ULL,
0x00000015ff2b723eULL, 0x000fe200020006ffULL, 0x20000034ff2f7230ULL, 0x000fe20000004100ULL,
0x00000010ff147819ULL, 0x000fe20000011614ULL, 0x20000035ff347230ULL, 0x000fe20000004100ULL,
0x00000010ff157819ULL, 0x000fe20000011636ULL, 0x2000002bff2b7230ULL, 0x000fe20000004100ULL,
0x00000010ff297819ULL, 0x000fc40000011629ULL, 0x00000010ff247819ULL, 0x000fe40000011637ULL,
0x00000017ff17723eULL, 0x000fe400020006ffULL, 0x0000105415147816ULL, 0x000fe40000000014ULL,
0x000000ff2d2d7812ULL, 0x000fe200078ec0ffULL, 0x20000017ff177230ULL, 0x000fe20000004100ULL,
0x0000105424157816ULL, 0x000fe40000000029ULL, 0x000000ff18187812ULL, 0x000fc400078ec0ffULL,
0x00000010ff297819ULL, 0x000fe40000011619ULL, 0x00000010ff1c7819ULL, 0x000fe4000001161cULL,
0x00000010ff247819ULL, 0x000fe4000001161dULL, 0x00000010ff197819ULL, 0x000fe4000001162fULL,
0x00000010ff207819ULL, 0x000fe40000011620ULL, 0x00000010ff1d7819ULL, 0x000fc40000011634ULL,
0x0000002dff2d723eULL, 0x000fe400020006ffULL, 0x00000010ff3a7819ULL, 0x000fe4000001163aULL,
0x00000018ff18723eULL, 0x000fe200020006ffULL, 0x2000002dff357230ULL, 0x000fe20000004100ULL,
0x000010541c197816ULL, 0x000fe40000000019ULL, 0x0000003cff1e723eULL, 0x000fe200020006ffULL,
0x20000018ff2d7230ULL, 0x000fe20000004100ULL, 0x0000003dff23723eULL, 0x000fc400020006ffULL,
0x00000039ff39723eULL, 0x000fe200020006ffULL, 0x2000001eff1e7230ULL, 0x000fe20000004100ULL,
0x000010541d1c7816ULL, 0x000fe20000000020ULL, 0x20000023ff237230ULL, 0x000fe20000004100ULL,
0x00000010ff1f7819ULL, 0x000fe2000001161fULL, 0x20000039ff397230ULL, 0x000fe20000004100ULL,
0x00000010ff2e7819ULL, 0x000fe4000001162eULL, 0x00000010ff3d7819ULL, 0x000fe40000011628ULL,
0x0000105429207816ULL, 0x000fc4000000003aULL, 0x00000010ff297819ULL, 0x000fe40000011617ULL,
0x00000010ff287819ULL, 0x000fe40000011621ULL, 0x000010541f217816ULL, 0x000fe4000000002eULL,
0x00000010ff3b7819ULL, 0x000fe4000001163bULL, 0x00000010ff1f7819ULL, 0x000fe4000001161bULL,
0x00000010ff2e7819ULL, 0x000fc40000011625ULL, 0x0000105429287816ULL, 0x000fe40000000028ULL,
0x00000010ff297819ULL, 0x000fe4000001162cULL, 0x00000010ff347819ULL, 0x000fe4000001161aULL,
0x00000010ff2c7819ULL, 0x000fe4000001162dULL, 0x000010543b1d7816ULL, 0x000fe40000000024ULL,
0x000010542e257816ULL, 0x000fc4000000001fULL, 0x00000010ff2d7819ULL, 0x000fe40000011622ULL,
0x00000010ff2a7819ULL, 0x000fe4000001162aULL, 0x00000010ff187819ULL, 0x000fe40000011639ULL,
0x00000010ff247819ULL, 0x000fe40000011616ULL, 0x00000010ff357819ULL, 0x000fe20000011635ULL,
0x000000143014723cULL, 0x000fe200000418ffULL, 0x00000010ff2f7819ULL, 0x000fc4000001161eULL,
0x00000010ff2e7819ULL, 0x000fe40000011623ULL, 0x00000010ff277819ULL, 0x000fe20000011627ULL,
0x0000001c301c723cULL, 0x000fe200000418ffULL, 0x00000010ff367819ULL, 0x000fe40000011626ULL,
0x00000010ff2b7819ULL, 0x000fe4000001162bULL, 0x0000105434297816ULL, 0x000fe20000000029ULL,
0x000000203020723cULL, 0x000fe200000418ffULL, 0x000010542d347816ULL, 0x000fc4000000002aULL,
0x000010543d187816ULL, 0x000fe40000000018ULL, 0x0000105435247816ULL, 0x000fe40000000024ULL,
0x000010542c2c7816ULL, 0x000fe4000000002fULL, 0x00001054272d7816ULL, 0x000fe2000000002eULL,
0x000000183018723cULL, 0x000fe200000418ffULL, 0x0000105436357816ULL, 0x000fca000000002bULL,
0x000000243024723cULL, 0x000fec00000418ffULL, 0x000000283028723cULL, 0x000fec00000418ffULL,
0x0000002c302c723cULL, 0x000fec00000418ffULL, 0x000000343030723cULL, 0x000fe200000418ffULL,
0x013000006734783bULL, 0x0004e20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000102947ULL, 0x000fde0003800000ULL, 0x0000000334347232ULL, 0x08afe40000200000ULL,
0x0000000336367232ULL, 0x000fe40000200000ULL, 0x0000000435357232ULL, 0x080fe40000200000ULL,
0x0000000437377232ULL, 0x000fce0000200000ULL, 0x000000ff3800720cULL, 0x000fe20003f45270ULL,
0x00000bd000007945ULL, 0x000fe20003800000ULL, 0x000000006838783bULL, 0x000f240000004200ULL,
0x000000ff383c7812ULL, 0x010fe400078ec0ffULL, 0x000000ff393e7812ULL, 0x000fe400078ec0ffULL,
0x0000003cff50723eULL, 0x000fe400020006ffULL, 0x00000018ff3d7819ULL, 0x000fc40000011638ULL,
0x00000010ff3c7819ULL, 0x000fe20000011638ULL, 0x20000050ff507230ULL, 0x000fe20000004100ULL,
0x0000003eff51723eULL, 0x000fe400020006ffULL, 0x0000003dff3d723eULL, 0x000fe400020006ffULL,
0x00000018ff3e7819ULL, 0x000fe20000011639ULL, 0x20000051ff517230ULL, 0x000fe20000004100ULL,
0x000000ff3c3c7812ULL, 0x000fe200078ec0ffULL, 0x2000003dff6d7230ULL, 0x000fe20000004100ULL,
0x0000003eff71723eULL, 0x000fc400020006ffULL, 0x0000003cff6c723eULL, 0x000fe400020006ffULL,
0x00000000693c783bULL, 0x000f220000004200ULL, 0x00000010ff707819ULL, 0x000fe40000011639ULL,
0x0000ffff38727812ULL, 0x000fe200078ec0ffULL, 0x20000071ff387230ULL, 0x000fe20000004100ULL,
0x0000ffff39737812ULL, 0x000fe200078ec0ffULL, 0x2000006cff397230ULL, 0x000fe20000004100ULL,
0x000000ff70717812ULL, 0x000fe400078ec0ffULL, 0x00000008ff707819ULL, 0x000fc40000011672ULL,
0x00000008ff727819ULL, 0x000fe40000011673ULL, 0x00000071ff71723eULL, 0x000fe400020006ffULL,
0x00000072ff73723eULL, 0x000fe400020006ffULL, 0x00000070ff6c723eULL, 0x000fe200020006ffULL,
0x20000071ff727230ULL, 0x000fe20000004100ULL, 0x00000010ff507819ULL, 0x000fe20000011650ULL,
0x20000073ff737230ULL, 0x000fe20000004100ULL, 0x00000010ff517819ULL, 0x000fe20000011651ULL,
0x2000006cff717230ULL, 0x000fe20000004100ULL, 0x00000010ff397819ULL, 0x000fc40000011639ULL,
0x00000010ff727819ULL, 0x000fe40000011672ULL, 0x000000ff3b747812ULL, 0x000fe400078ec0ffULL,
0x0000105439507816ULL, 0x000fe40000000050ULL, 0x0000105472517816ULL, 0x000fe40000000051ULL,
0x00000074ff6c723eULL, 0x000fe400020006ffULL, 0x00000010ff747819ULL, 0x000fc40000011638ULL,
0x00000010ff6d7819ULL, 0x000fe2000001166dULL, 0x000000503414723cULL, 0x008fe20000041814ULL,
0x00000010ff387819ULL, 0x000fe20000011671ULL, 0x2000006cff6c7230ULL, 0x000fe20000004100ULL,
0x00000010ff737819ULL, 0x000fe40000011673ULL, 0x000010546d387816ULL, 0x000fe40000000038ULL,
0x0000105474397816ULL, 0x000fe40000000073ULL, 0x000000ff3c507812ULL, 0x010fc400078ec0ffULL,
0x000000ff3a707812ULL, 0x040fe400078ec0ffULL, 0x00000010ff737819ULL, 0x100fe2000001163aULL,
0x000000383418723cULL, 0x000fe20000041818ULL, 0x00000018ff717819ULL, 0x000fe4000001163aULL,
0x0000ffff3a6d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff3a7819ULL, 0x100fe4000001163bULL,
0x00000018ff727819ULL, 0x000fc4000001163bULL, 0x0000ffff3b3b7812ULL, 0x000fe400078ec0ffULL,
0x00000050ff50723eULL, 0x000fe400020006ffULL, 0x000000ff3d517812ULL, 0x000fe400078ec0ffULL,
0x000000ff73737812ULL, 0x000fe200078ec0ffULL, 0x20000050ff397230ULL, 0x000fe20000004100ULL,
0x00000008ff6d7819ULL, 0x000fe4000001166dULL, 0x00000008ff3b7819ULL, 0x000fc4000001163bULL,
0x00000051ff74723eULL, 0x000fe400020006ffULL, 0x00000070ff70723eULL, 0x000fe400020006ffULL,
0x00000073ff51723eULL, 0x000fe200020006ffULL, 0x20000074ff387230ULL, 0x000fe20000004100ULL,
0x000000ff3a3a7812ULL, 0x000fe200078ec0ffULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x0000006dff50723eULL, 0x000fe200020006ffULL, 0x20000051ff517230ULL, 0x000fe20000004100ULL,
0x00000010ff737819ULL, 0x000fc4000001163cULL, 0x0000003bff6d723eULL, 0x000fe200020006ffULL,
0x20000050ff507230ULL, 0x000fe20000004100ULL, 0x00000010ff3b7819ULL, 0x000fe4000001163dULL,
0x0000003aff3a723eULL, 0x000fe400020006ffULL, 0x000000ff73737812ULL, 0x000fe400078ec0ffULL,
0x000000ff3b757812ULL, 0x000fe200078ec0ffULL, 0x2000003aff747230ULL, 0x000fe20000004100ULL,
0x00000071ff71723eULL, 0x000fc400020006ffULL, 0x00000073ff73723eULL, 0x000fe400020006ffULL,
0x00000010ff3a7819ULL, 0x000fe20000011670ULL, 0x20000071ff717230ULL, 0x000fe20000004100ULL,
0x00000010ff517819ULL, 0x000fe20000011651ULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x00000075ff75723eULL, 0x000fe400020006ffULL, 0x00000010ff3b7819ULL, 0x000fe4000001166cULL,
0x00000018ff6c7819ULL, 0x000fe2000001163cULL, 0x20000075ff757230ULL, 0x000fe20000004100ULL,
0x00000018ff707819ULL, 0x000fc4000001163dULL, 0x00000072ff72723eULL, 0x000fe400020006ffULL,
0x00001054513a7816ULL, 0x000fe2000000003aULL, 0x2000006dff517230ULL, 0x000fe20000004100ULL,
0x00000010ff747819ULL, 0x000fe20000011674ULL, 0x20000072ff727230ULL, 0x000fe20000004100ULL,
0x0000006cff6d723eULL, 0x000fe400020006ffULL, 0x00000070ff6c723eULL, 0x000fe400020006ffULL,
0x00000010ff707819ULL, 0x000fe20000011638ULL, 0x2000006dff6d7230ULL, 0x000fe20000004100ULL,
0x00000010ff717819ULL, 0x000fe20000011671ULL, 0x2000006cff6c7230ULL, 0x000fe20000004100ULL,
0x00000010ff397819ULL, 0x000fc40000011639ULL, 0x00000010ff507819ULL, 0x000fe40000011650ULL,
0x00000010ff387819ULL, 0x000fe40000011673ULL, 0x00001054743b7816ULL, 0x000fe4000000003bULL,
0x00000010ff757819ULL, 0x000fe40000011675ULL, 0x0000105471507816ULL, 0x000fe40000000050ULL,
0x0000105438387816ULL, 0x000fe20000000039ULL, 0x0000003a341c723cULL, 0x000fe2000004181cULL,
0x00000010ff727819ULL, 0x000fc40000011672ULL, 0x00000010ff517819ULL, 0x000fe40000011651ULL,
0x0000105475397816ULL, 0x000fe40000000070ULL, 0x000000ff3f717812ULL, 0x000fe400078ec0ffULL,
0x0000ffff3c757812ULL, 0x000fe400078ec0ffULL, 0x0000105472517816ULL, 0x000fe20000000051ULL,
0x000000383424723cULL, 0x000fe20000041824ULL, 0x000000ff3e3b7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff3a7819ULL, 0x000fe4000001163eULL, 0x00000071ff74723eULL, 0x000fe200020006ffULL,
0x000000503420723cULL, 0x000fe20000041820ULL, 0x00000018ff727819ULL, 0x000fe4000001163fULL,
0x00000008ff717819ULL, 0x000fe40000011675ULL, 0x0000ffff3d3c7812ULL, 0x000fe400078ec0ffULL,
0x0000003bff3b723eULL, 0x000fc400020006ffULL, 0x0000003aff73723eULL, 0x000fe400020006ffULL,
0x00000072ff75723eULL, 0x000fe200020006ffULL, 0x2000003bff3a7230ULL, 0x000fe20000004100ULL,
0x00000071ff71723eULL, 0x000fe200020006ffULL, 0x20000074ff3b7230ULL, 0x000fe20000004100ULL,
0x00000010ff3d7819ULL, 0x000fe4000001163eULL, 0x00000008ff727819ULL, 0x000fe2000001163cULL,
0x20000073ff3c7230ULL, 0x000fe20000004100ULL, 0x00000010ff707819ULL, 0x000fe2000001163fULL,
0x20000071ff717230ULL, 0x000fe20000004100ULL, 0x0000ffff3e3e7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff3f3f7812ULL, 0x000fe400078ec0ffULL, 0x000000ff3d737812ULL, 0x000fe200078ec0ffULL,
0x20000075ff3d7230ULL, 0x000fe20000004100ULL, 0x00000072ff72723eULL, 0x000fe400020006ffULL,
0x000000ff70747812ULL, 0x000fe400078ec0ffULL, 0x00000008ff707819ULL, 0x000fe2000001163eULL,
0x20000072ff727230ULL, 0x000fe20000004100ULL, 0x00000008ff757819ULL, 0x000fc4000001163fULL,
0x00000010ff3f7819ULL, 0x000fe4000001166dULL, 0x00000010ff3e7819ULL, 0x000fe40000011671ULL,
0x00000073ff73723eULL, 0x000fe400020006ffULL, 0x00000074ff74723eULL, 0x000fe400020006ffULL,
0x00000070ff70723eULL, 0x000fe200020006ffULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x00000075ff75723eULL, 0x000fe200020006ffULL, 0x20000074ff6d7230ULL, 0x000fe20000004100ULL,
0x000010543f3e7816ULL, 0x000fe2000000003eULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x00000010ff6c7819ULL, 0x000fe2000001166cULL, 0x20000075ff757230ULL, 0x000fe20000004100ULL,
0x00000010ff3f7819ULL, 0x000fc40000011672ULL, 0x00000010ff517819ULL, 0x000fe4000001163cULL,
0x000010546c3f7816ULL, 0x000fe4000000003fULL, 0x00000010ff6c7819ULL, 0x000fe4000001163dULL,
0x00000010ff3a7819ULL, 0x000fe4000001163aULL, 0x00000010ff737819ULL, 0x000fe20000011673ULL,
0x0000003e3428723cULL, 0x000fe20000041828ULL, 0x00000010ff3b7819ULL, 0x000fc4000001163bULL,
0x00000010ff507819ULL, 0x000fe4000001166dULL, 0x00000010ff3c7819ULL, 0x000fe40000011670ULL,
0x00000010ff3d7819ULL, 0x000fe40000011675ULL, 0x00001054733a7816ULL, 0x000fe4000000003aULL,
0x00001054503b7816ULL, 0x000fe4000000003bULL, 0x00001054513c7816ULL, 0x000fc4000000003cULL,
0x000010546c3d7816ULL, 0x000fc6000000003dULL, 0x0000003a342c723cULL, 0x000fec000004182cULL,
0x0000003c3430723cULL, 0x000fe20000041830ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000403947ULL, 0x000fde0001000000ULL, 0x000000140b0b7221ULL, 0x000fe20000010000ULL,
0x000000150c0c7221ULL, 0x000fe20000010000ULL, 0x000000180f0f7221ULL, 0x000fe20000010000ULL,
0x0000001910107221ULL, 0x000fe20000010000ULL, 0x0000001c41417221ULL, 0x000fe20000010000ULL,
0x0000001d42427221ULL, 0x000fe20000010000ULL, 0x0000002045457221ULL, 0x000fe20000010000ULL,
0x0000002146467221ULL, 0x000fe20000010000ULL, 0x0000002449497221ULL, 0x000fe20000010000ULL,
0x000000254a4a7221ULL, 0x000fe20000010000ULL, 0x000000284d4d7221ULL, 0x000fe20000010000ULL,
0x000000294e4e7221ULL, 0x000fe20000010000ULL, 0x0000002c53537221ULL, 0x000fe20000010000ULL,
0x0000002d54547221ULL, 0x000fe20000010000ULL, 0x0000003057577221ULL, 0x000fe20000010000ULL,
0x0000003158587221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x000000ffff157224ULL, 0x002fc600078e006fULL,
0x0000000000404947ULL, 0x000fea0002800000ULL, 0x000000160d0d7221ULL, 0x000fe20000010000ULL,
0x000000170e0e7221ULL, 0x000fe20000010000ULL, 0x0000001a11117221ULL, 0x000fe20000010000ULL,
0x0000001b40407221ULL, 0x000fe20000010000ULL, 0x0000001e43437221ULL, 0x000fe20000010000ULL,
0x0000001f44447221ULL, 0x000fe20000010000ULL, 0x0000002247477221ULL, 0x000fe20000010000ULL,
0x0000002348487221ULL, 0x000fe20000010000ULL, 0x000000264b4b7221ULL, 0x000fe20000010000ULL,
0x000000274c4c7221ULL, 0x000fe20000010000ULL, 0x0000002a4f4f7221ULL, 0x000fe20000010000ULL,
0x0000002b52527221ULL, 0x000fe20000010000ULL, 0x0000002e55557221ULL, 0x000fe20000010000ULL,
0x0000002f56567221ULL, 0x000fe20000010000ULL, 0x0000003259597221ULL, 0x000fe20000010000ULL,
0x000000335a5a7221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001ff147424ULL, 0x000fe400078e00ffULL, 0x000000016b6b7836ULL, 0x000fe40000000000ULL,
0x018b8814ff1679a7ULL, 0x000e660008500007ULL, 0x0000006a6b00720cULL, 0x000fe20003f46070ULL,
0x000000ffff1c7224ULL, 0x002fd800078e0017ULL, 0xffffffa0006ca947ULL, 0x000fea000383ffffULL,
0x018b6814ffff79a7ULL, 0x0003e40008500007ULL, 0x000000c008147811ULL, 0x002fc800078e40ffULL,
0x0000000914007c0cULL, 0x000fda000bf46070ULL, 0x0000005c009c2947ULL, 0x000fea0003800000ULL,
0x000000ffff6b7224ULL, 0x000fce00078e00ffULL, 0x00000002ff147819ULL, 0x000fe4000001166bULL,
0x000000036b1b7812ULL, 0x040fe400078ec0ffULL, 0x000000146b147207ULL, 0x000fe40000000000ULL,
0x000000ff1b1b7207ULL, 0x000fc60004000000ULL, 0x00000003141f7836ULL, 0x000fca0000000000ULL,
0x000000031f1d7812ULL, 0x040fe400078ec0ffULL, 0x000000081f1a7211ULL, 0x004fce00078ff0ffULL,
0x0000000000187805ULL, 0x000fce0000015200ULL, 0x018b7815ff0075a7ULL, 0x000e640008040147ULL,
0x00000000005c2947ULL, 0x002fea0003800000ULL, 0x000000ffff1e7224ULL, 0x000fce00078e00ffULL,
0x000000101e00780cULL, 0x000fda0003f46270ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000001618217210ULL, 0x000fca0007f5e1ffULL,
0x0000000117177824ULL, 0x000fe200010e0e19ULL, 0x003d09002100780cULL, 0x000fc80003f46070ULL,
0x000000ff1700720cULL, 0x000fda0003f46320ULL, 0x000000000008a947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c402100780cULL, 0x000fc80003f46070ULL, 0x000000ff1700720cULL, 0x000fda0003f46320ULL,
0x00000000001ca947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011417ULL,
0x0000002114147211ULL, 0x000fca00078510ffULL, 0x000000ffff177224ULL, 0x000fca00010e0617ULL,
0x0000000214147819ULL, 0x000fc80000001217ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011e1e7836ULL, 0x000fce0000000000ULL,
0x018b7815ff0075a7ULL, 0x000e640008040147ULL, 0xfffffffc00a8a947ULL, 0x002fea000383ffffULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x018b881cff0075a7ULL, 0x000e640008040147ULL,
0x00000000005c2947ULL, 0x002fea0003800000ULL, 0x000000ffff187224ULL, 0x000fce00078e00ffULL,
0x000000101800780cULL, 0x000fda0003f46270ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x0000001416197210ULL, 0x000fca0007f5e1ffULL,
0x0000000115157824ULL, 0x000fe200010e0e17ULL, 0x003d09001900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x000000000008a947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x00000000001ca947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001914147211ULL, 0x000fca00078510ffULL, 0x000000ffff157224ULL, 0x000fca00010e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000118187836ULL, 0x000fce0000000000ULL,
0x018b881cff0075a7ULL, 0x000e640008040147ULL, 0xfffffffc00a8a947ULL, 0x002fea000383ffffULL,
0x000000011a157836ULL, 0x000fe20000000000ULL, 0x00000004ff707819ULL, 0x000fe20000011612ULL,
0x000000041a147824ULL, 0x000fc600078e021dULL, 0x0000000c15007c0cULL, 0x000fe4000bf46070ULL,
0x0000002014187811ULL, 0x000fc800078e30ffULL, 0x000000605b1c7812ULL, 0x000fce00078ef818ULL,
0x000000040054a947ULL, 0x000fea0003800000ULL, 0x000000015d237824ULL, 0x000fe200078e0270ULL,
0x0000000918167c48ULL, 0x000fe2000ffe0000ULL, 0x00000010121e7824ULL, 0x000fe200078e00ffULL,
0x00016000070e7890ULL, 0x000fe2000fffe03fULL, 0x0000000270227836ULL, 0x000fe20000000000ULL,
0x0000000723207c11ULL, 0x040fe2000f8e10ffULL, 0x0000000116167824ULL, 0x000fe200078e0a18ULL,
0x000000f01e257812ULL, 0x000fe200078ec0ffULL, 0x0000000123187824ULL, 0x000fe400078e021cULL,
0x018a000020147984ULL, 0x000e620000000800ULL, 0x000000165d167248ULL, 0x000fe20007fe0000ULL,
0x000000015d277824ULL, 0x000fc800078e0222ULL, 0x0000000116217824ULL, 0x000fe400078e0a5dULL,
0x0000000127247824ULL, 0x000fc600078e0212ULL, 0x000000217000720cULL, 0x000fe40003f46070ULL,
0x0000000714197c11ULL, 0x002fe4000f8e10ffULL, 0x00008a00ff147b82ULL, 0x000e660000000a00ULL,
0x018ac00019177984ULL, 0x0007240000000800ULL, 0x0000000127197824ULL, 0x048fe400078e021cULL,
0x0000001027277824ULL, 0x000fca00078e00ffULL, 0xfffffff027247812ULL, 0x000fe200078ee224ULL,
0x0000000617177c24ULL, 0x010fe4000f8e0218ULL, 0x0000000123187824ULL, 0x000fe400078e0212ULL,
0x0000010017167825ULL, 0x002fc800078e0014ULL, 0x0000001023237824ULL, 0x000fe200078e00ffULL,
0x0000002516167210ULL, 0x000fc80007f7e0ffULL, 0xfffffff023187812ULL, 0x000fe200078ee218ULL,
0x000000ffff177224ULL, 0x000fc600018e0617ULL, 0x0000000e18237c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e2000d101c4aULL,
0x000000212200720cULL, 0x000fe20003f46070ULL, 0x0000000470227836ULL, 0x000fe40000000000ULL,
0x018a080020187984ULL, 0x000ee40000000800ULL, 0x000000015d277824ULL, 0x000fe200078e0222ULL,
0x0000000e24237c11ULL, 0x002fc6000f8e20ffULL, 0x0000000127247824ULL, 0x000fe200078e0212ULL,
0x00000007181e7c11ULL, 0x008fca000f8e10ffULL, 0x018ac0001e187984ULL, 0x000e640000000800ULL,
0x0000000618197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000002518167210ULL, 0x000fca0007f7e0ffULL, 0x000000ffff177224ULL, 0x000fe400018e0619ULL,
0x0000000127197824ULL, 0x040fe400078e021cULL, 0x0000001027277824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e2000d101c4aULL,
0x000000212200720cULL, 0x000fc60003f46070ULL, 0x018a100020187984ULL, 0x000ee20000000800ULL,
0xfffffff027247812ULL, 0x000fc800078ee224ULL, 0x0000000e24237c11ULL, 0x002fe4000f8e20ffULL,
0x00000007181e7c11ULL, 0x008fca000f8e10ffULL, 0x018ac0001e187984ULL, 0x0002e40000000800ULL,
0x00000006701e7836ULL, 0x002fc80000000000ULL, 0x000000015d277824ULL, 0x000fe400078e021eULL,
0x0000000618197c24ULL, 0x008fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000002518167210ULL, 0x000fca0007f7e0ffULL, 0x000000ffff177224ULL, 0x000fe400018e0619ULL,
0x0000000127197824ULL, 0x040fe400078e021cULL, 0x00000001271c7824ULL, 0x040fe200078e0212ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e2000d101c4aULL,
0x0000001027277824ULL, 0x000fe200078e00ffULL, 0x000000211e00720cULL, 0x000fe40003f46070ULL,
0x018a180020187984ULL, 0x000ee40000000800ULL, 0xfffffff0271c7812ULL, 0x000fc800078ee21cULL,
0x0000000e1c177c11ULL, 0x002fe4000f8e20ffULL, 0x0000000718187c11ULL, 0x008fcc000f8e10ffULL,
0x018ac00018187984ULL, 0x000e640000000800ULL, 0x0000000618197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019147825ULL, 0x000fc600078e0014ULL, 0x0000002514147210ULL, 0x000fca0007f7e0ffULL,
0x000000ffff157224ULL, 0x000fca00018e0615ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014177faeULL, 0x0003e2000d101c4aULL, 0x0000000400247947ULL, 0x000fea0003800000ULL,
0x000000015d217824ULL, 0x000fe200078e0270ULL, 0x00016000070e7890ULL, 0x000fe2000fffe03fULL,
0x0000001012197824ULL, 0x000fe400078e00ffULL, 0x0000000121177824ULL, 0x040fe200078e021cULL,
0x0000000721207c11ULL, 0x040fe2000f8e10ffULL, 0x00000010211e7824ULL, 0x000fe200078e00ffULL,
0x000000f019237812ULL, 0x000fe200078ec0ffULL, 0x0000000121197824ULL, 0x000fe400078e0212ULL,
0x018a000020147984ULL, 0x000e620000000800ULL, 0x0000000221277836ULL, 0x000fc40000000000ULL,
0xfffffff01e197812ULL, 0x000fe400078ee219ULL, 0x0000000127227824ULL, 0x000fe400078e0212ULL,
0x0000000e19257c11ULL, 0x000fe2000f8e20ffULL, 0x0000000127197824ULL, 0x040fe400078e021cULL,
0x0000001027277824ULL, 0x000fca00078e00ffULL, 0xfffffff027227812ULL, 0x000fe200078ee222ULL,
0x0000000421277836ULL, 0x000fe40000000000ULL, 0x0000000621217836ULL, 0x000fe20000000000ULL,
0x0000000714187c11ULL, 0x002fe4000f8e10ffULL, 0x00008a00ff147b82ULL, 0x000e660000000a00ULL,
0x018ac00018167984ULL, 0x000ee40000000800ULL, 0x0000000616177c24ULL, 0x008fc8000f8e0217ULL,
0x0000010017167825ULL, 0x002fc600078e0014ULL, 0x0000002316167210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff177224ULL, 0x000fca00010e0617ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016257faeULL, 0x0003e8000b901c4aULL, 0x018a080020187984ULL, 0x000ee20000000800ULL,
0x0000000e22257c11ULL, 0x002fe2000f8e20ffULL, 0x0000000127177824ULL, 0x040fe400078e021cULL,
0x0000000127227824ULL, 0x040fe400078e0212ULL, 0x0000001027277824ULL, 0x000fca00078e00ffULL,
0xfffffff027227812ULL, 0x000fe400078ee222ULL, 0x00000007181e7c11ULL, 0x008fca000f8e10ffULL,
0x018ac0001e187984ULL, 0x000e640000000800ULL, 0x0000000618197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000002318187210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff197224ULL, 0x000fca00010e0619ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018257faeULL, 0x0003e8000b901c4aULL, 0x018a100020167984ULL, 0x000ee20000000800ULL,
0x0000000e22257c11ULL, 0x002fe2000f8e20ffULL, 0x0000000121197824ULL, 0x040fe400078e021cULL,
0x00000010211c7824ULL, 0x000fe200078e00ffULL, 0x00000007161e7c11ULL, 0x008fca000f8e10ffULL,
0x018ac0001e167984ULL, 0x000e640000000800ULL, 0x0000000616177c24ULL, 0x002fc8000f8e0217ULL,
0x0000010017167825ULL, 0x000fc600078e0014ULL, 0x0000002316167210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff177224ULL, 0x000fca00010e0617ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016257faeULL, 0x0003e8000b901c4aULL, 0x018a180020187984ULL, 0x000ee40000000800ULL,
0x0000000718187c11ULL, 0x008fcc000f8e10ffULL, 0x018ac00018187984ULL, 0x000ee40000000800ULL,
0x0000000618197c24ULL, 0x008fc8000f8e0219ULL, 0x0000010019147825ULL, 0x000fc800078e0014ULL,
0x0000000121197824ULL, 0x000fe200078e0212ULL, 0x0000002314147210ULL, 0x000fc80007f5e0ffULL,
0xfffffff01c197812ULL, 0x000fe200078ee219ULL, 0x000000ffff157224ULL, 0x000fc600010e0615ULL,
0x0000000e19197c11ULL, 0x000fca000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014197faeULL, 0x0003e4000b901c4aULL, 0x00000001ff147424ULL, 0x002fcc00078e00ffULL,
0x018b8814ff1479a7ULL, 0x000e640008500007ULL, 0x000000ffff187224ULL, 0x002fce00078e0015ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x018b8818ff0075a7ULL, 0x000e640008040147ULL,
0x00000000005c2947ULL, 0x002fea0003800000ULL, 0x000000ffff1c7224ULL, 0x000fce00078e00ffULL,
0x000000101c00780cULL, 0x000fda0003f46270ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x0000001416197210ULL, 0x000fca0007f5e1ffULL,
0x0000000115157824ULL, 0x000fe200010e0e17ULL, 0x003d09001900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x000000000008a947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x00000000001ca947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001914147211ULL, 0x000fca00078510ffULL, 0x000000ffff157224ULL, 0x000fca00010e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011c1c7836ULL, 0x000fce0000000000ULL,
0x018b8818ff0075a7ULL, 0x000e640008040147ULL, 0xfffffffc00a8a947ULL, 0x002fea000383ffffULL,
0x0000001a5f00720cULL, 0x000fe20003f44070ULL, 0x00000001ff1c7424ULL, 0x000fe200078e00ffULL,
0x000000011f1f7812ULL, 0x000fe200078ec0ffULL, 0x00000020616e7824ULL, 0x000fe200078e0212ULL,
0x000000031b00780cULL, 0x000fc80005745270ULL, 0x000000011f00780cULL, 0x000fda0001745470ULL,
0x00000000004c2947ULL, 0x000fea0003800000ULL, 0x000000036e00780cULL, 0x000fe20003f44070ULL,
0x0000000104047890ULL, 0x000fe2000fffe03fULL, 0x0000010000007945ULL, 0x000ff60003800000ULL,
0x0000000000382947ULL, 0x000fea0003800000ULL, 0x00009000ff177b82ULL, 0x000e620000000800ULL,
0x000000050400728cULL, 0x000fe2000bf06070ULL, 0x0000000413167824ULL, 0x000fe200078e026eULL,
0x000000076e197c11ULL, 0x000fc6000f8e10ffULL, 0x0000000216167824ULL, 0x000fe200078e00ffULL,
0x000000000000781cULL, 0x000fe20003f4f008ULL, 0x00008c00ff147b82ULL, 0x000ee20000000a00ULL,
0x0000000417187c36ULL, 0x002fc80008000000ULL, 0x0000001716177224ULL, 0x000fc800078e0218ULL,
0x0000000417147825ULL, 0x008fca00078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x18ac000014197faeULL, 0x0003e4000d12184aULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000019000007945ULL, 0x000fe80003800000ULL, 0x00000000005c1947ULL, 0x000fea0003800000ULL,
0x0000001a5f00720cULL, 0x000fe20003f44070ULL, 0x000000011b147836ULL, 0x002fe20000000000ULL,
0x00009400ff187b82ULL, 0x000e680000000800ULL, 0x0000000314167812ULL, 0x000fc800078ec0ffULL,
0x000000ff16197207ULL, 0x000fc60005000000ULL, 0x00000002ff14a819ULL, 0x000fe40000011614ULL,
0x000000015c167824ULL, 0x000fc600078e0219ULL, 0x000000011d1d7824ULL, 0x000fe400078e0214ULL,
0x00009200ff147b82ULL, 0x000ee40000000a00ULL, 0x000000401d177824ULL, 0x040fe200078e00ffULL,
0x0000001a1d1a7211ULL, 0x000fc800078ff0ffULL, 0x000000c017177812ULL, 0x000fca00078ec0ffULL,
0x000001001a177824ULL, 0x000fc800078e0217ULL, 0x000000016e197824ULL, 0x100fe400078e0217ULL,
0x0000001816177224ULL, 0x002fc600078e0217ULL, 0x0000000919007c0cULL, 0x000fe2000bf46070ULL,
0x000000016e177824ULL, 0x040fe200078e0217ULL, 0x000000076e197c11ULL, 0x000fc6000f8e10ffULL,
0x0000000417147825ULL, 0x008fd000078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x18a0000014197faeULL, 0x0003e4000d12184aULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a4dULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x018b801cff6c79a7ULL, 0x0002e20008500007ULL,
0x000000ff6b00720cULL, 0x000fe20003f45270ULL, 0x00000008636c7836ULL, 0x008fd80000000000ULL,
0x00000004008c2947ULL, 0x002fea0003800000ULL, 0x018b381c5d1479a7ULL, 0x000e640008500007ULL,
0x000000ffff187224ULL, 0x002fce00078e0015ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x018b38185d0075a7ULL, 0x000e640008040147ULL, 0x00000000005c2947ULL, 0x002fea0003800000ULL,
0x000000ffff197224ULL, 0x000fce00078e00ffULL, 0x000000101900780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x0000001416147210ULL, 0x000fca0007f5e1ffULL, 0x0000000115157824ULL, 0x000fe200010e0e17ULL,
0x003d09001400780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401400780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff077819ULL, 0x000fc80000011415ULL, 0x0000001407077211ULL, 0x000fca00078510ffULL,
0x000000ffff147224ULL, 0x000fca00010e0615ULL, 0x0000000207077819ULL, 0x000fc80000001214ULL,
0x000000070000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000119197836ULL, 0x000fce0000000000ULL, 0x018b38185d0075a7ULL, 0x000e640008040147ULL,
0xfffffffc00a8a947ULL, 0x002fea000383ffffULL, 0x0000001012077824ULL, 0x000fe200078e00ffULL,
0x00000001ff147819ULL, 0x000fe20000011612ULL, 0x000000ffff167224ULL, 0x000fc600078e0009ULL,
0x0000007007077812ULL, 0x000fe400078ec0ffULL, 0x0000000c14147812ULL, 0x000fc800078ec0ffULL,
0x00000007141b7c10ULL, 0x000fca000fffe007ULL, 0x018180001b147984ULL, 0x000e680000000800ULL,
0x018380001b157984ULL, 0x0006e20000000800ULL, 0x000000091400720bULL, 0x002fda0003f5d000ULL,
0x0000000000077806ULL, 0x000fc800010e0100ULL, 0x0000ffff07187812ULL, 0x000fe2000784c0ffULL,
0x00000001ff077424ULL, 0x000fd800078e00ffULL, 0x0000000000e0a947ULL, 0x00cfea0003800000ULL,
0x000000091400720bULL, 0x000fe40003f54000ULL, 0x000000036100780cULL, 0x000fe40003f65270ULL,
0x0000001409167209ULL, 0x000fd20007810000ULL, 0x0000000000197806ULL, 0x000fe400010e0100ULL,
0x018580161b00b388ULL, 0x0003e40000000800ULL, 0x0000991019177816ULL, 0x000fc800000000ffULL,
0x000000ff1700720cULL, 0x000fda0003f45270ULL, 0x0000000000a8a947ULL, 0x002fea0003800000ULL,
0x8000001609097221ULL, 0x000fe20000010000ULL, 0x000000ff19ff7812ULL, 0x040fe4000784c0ffULL,
0x0000ff0019ff7812ULL, 0x000fe2000786c0ffULL, 0x3fb8aa3b09097820ULL, 0x000fc80000410000ULL,
0x0000000900177308ULL, 0x0002ac0000000800ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x00001f6317097589ULL, 0x006e6400000e0000ULL, 0x000000090b0b7220ULL, 0x082fe20000410000ULL,
0x000000090c0c7220ULL, 0x080fe20000410000ULL, 0x000000090f0f7220ULL, 0x080fe20000410000ULL,
0x0000000910107220ULL, 0x080fe20000410000ULL, 0x0000000941417220ULL, 0x080fe20000410000ULL,
0x0000000942427220ULL, 0x080fe20000410000ULL, 0x0000000945457220ULL, 0x080fe20000410000ULL,
0x0000000946467220ULL, 0x080fe20000410000ULL, 0x0000000949497220ULL, 0x080fe20000410000ULL,
0x000000094a4a7220ULL, 0x080fe20000410000ULL, 0x000000094d4d7220ULL, 0x080fe20000410000ULL,
0x000000094e4e7220ULL, 0x080fe20000410000ULL, 0x0000000953537220ULL, 0x080fe20000410000ULL,
0x0000000954547220ULL, 0x080fe20000410000ULL, 0x0000000957577220ULL, 0x080fe20000410000ULL,
0x0000000958587220ULL, 0x000fce0000410000ULL, 0x000000170a0a7220ULL, 0x004fe20000410000ULL,
0x000000000044b947ULL, 0x000fec0003800000ULL, 0x00001f6c17097589ULL, 0x002e6400000e0000ULL,
0x000000090d0d7220ULL, 0x082fe20000410000ULL, 0x000000090e0e7220ULL, 0x080fe20000410000ULL,
0x0000000911117220ULL, 0x080fe20000410000ULL, 0x0000000940407220ULL, 0x080fe20000410000ULL,
0x0000000943437220ULL, 0x080fe20000410000ULL, 0x0000000944447220ULL, 0x080fe20000410000ULL,
0x0000000947477220ULL, 0x080fe20000410000ULL, 0x0000000948487220ULL, 0x080fe20000410000ULL,
0x000000094b4b7220ULL, 0x080fe20000410000ULL, 0x000000094c4c7220ULL, 0x080fe20000410000ULL,
0x000000094f4f7220ULL, 0x080fe20000410000ULL, 0x0000000952527220ULL, 0x080fe20000410000ULL,
0x0000000955557220ULL, 0x080fe20000410000ULL, 0x0000000956567220ULL, 0x080fe20000410000ULL,
0x0000000959597220ULL, 0x080fe20000410000ULL, 0x000000095a5a7220ULL, 0x000fce0000410000ULL,
0x0000ffff18ff7812ULL, 0x000fda0007846019ULL, 0x8000001614142221ULL, 0x000fe20000010000ULL,
0x00007610ff072816ULL, 0x000fc60000000007ULL, 0x3fb8aa3b14142820ULL, 0x000fc80000410000ULL,
0x0000001400062308ULL, 0x000ea40000000800ULL, 0x0000000615152220ULL, 0x004fce0000410000ULL,
0x0000000a150a7221ULL, 0x000fe20000010000ULL, 0x000000ffff097224ULL, 0x002fce00078e0016ULL,
0x000000ff07ff7812ULL, 0x000fda000784c0ffULL, 0x0000000000102947ULL, 0x000fea0003800000ULL,
0x00000006ff03723eULL, 0x000fc800000010ffULL, 0x0000541003147816ULL, 0x000fca0000000003ULL,
0x00001f6314037589ULL, 0x0002e800000e0000ULL, 0x00001f6c14047589ULL, 0x0002a400000e0000ULL,
0x01380000051c783bULL, 0x0002e20000000200ULL, 0x0000000000102947ULL, 0x000fea0003800000ULL,
0x000000031c1c7232ULL, 0x088fe40000200000ULL, 0x000000031e1e7232ULL, 0x000fe40000200000ULL,
0x000000041d1d7232ULL, 0x084fe40000200000ULL, 0x000000041f1f7232ULL, 0x000fce0000200000ULL,
0x000000000214783bULL, 0x002e680000004200ULL, 0x000000000018783bULL, 0x000f220000004200ULL,
0x00000018ff207819ULL, 0x102fe40000011614ULL, 0x000000ff16257812ULL, 0x000fe400078ec0ffULL,
0x00000020ff20723eULL, 0x000fe400020006ffULL, 0x00000010ff377819ULL, 0x000fc40000011614ULL,
0x000000ff14217812ULL, 0x040fe200078ec0ffULL, 0x20000020ff2b7230ULL, 0x000fe20000004100ULL,
0x0000ffff14367812ULL, 0x000fe400078ec0ffULL, 0x00000010ff347819ULL, 0x100fe40000011615ULL,
0x000000ff15237812ULL, 0x040fe400078ec0ffULL, 0x00000018ff227819ULL, 0x000fe40000011615ULL,
0x0000ffff15357812ULL, 0x000fc400078ec0ffULL, 0x00000018ff387819ULL, 0x000fe40000011617ULL,
0x00000018ff147819ULL, 0x010fe4000001161aULL, 0x00000025ff25723eULL, 0x000fe400020006ffULL,
0x00000018ff157819ULL, 0x000fe4000001161bULL, 0x000000ff17397812ULL, 0x000fe200078ec0ffULL,
0x20000025ff267230ULL, 0x000fe20000004100ULL, 0x00000038ff20723eULL, 0x000fc400020006ffULL,
0x00000014ff14723eULL, 0x000fe400020006ffULL, 0x00000010ff337819ULL, 0x000fe20000011616ULL,
0x20000020ff207230ULL, 0x000fe20000004100ULL, 0x00000015ff38723eULL, 0x000fe200020006ffULL,
0x20000014ff157230ULL, 0x000fe20000004100ULL, 0x0000ffff162e7812ULL, 0x000fe400078ec0ffULL,
0x00000039ff25723eULL, 0x000fe200020006ffULL, 0x20000038ff147230ULL, 0x000fe20000004100ULL,
0x00000008ff397819ULL, 0x000fc40000011635ULL, 0x000000ff37377812ULL, 0x000fe200078ec0ffULL,
0x20000025ff257230ULL, 0x000fe20000004100ULL, 0x000000ff33337812ULL, 0x000fe400078ec0ffULL,
0x00000008ff2e7819ULL, 0x000fe4000001162eULL, 0x000000ff34387812ULL, 0x000fe400078ec0ffULL,
0x00000039ff39723eULL, 0x000fe400020006ffULL, 0x00000037ff34723eULL, 0x000fc400020006ffULL,
0x00000010ff2f7819ULL, 0x000fe40000011617ULL, 0x0000ffff17317812ULL, 0x000fe200078ec0ffULL,
0x20000034ff347230ULL, 0x000fe20000004100ULL, 0x00000010ff307819ULL, 0x000fe40000011618ULL,
0x00000033ff37723eULL, 0x000fe200020006ffULL, 0x20000039ff337230ULL, 0x000fe20000004100ULL,
0x0000002eff2e723eULL, 0x000fe400020006ffULL, 0x0000ffff192d7812ULL, 0x000fc400078ec0ffULL,
0x00000038ff35723eULL, 0x000fe400020006ffULL, 0x00000010ff287819ULL, 0x000fe4000001161aULL,
0x000000ff2f2f7812ULL, 0x000fe200078ec0ffULL, 0x20000035ff357230ULL, 0x000fe20000004100ULL,
0x00000008ff387819ULL, 0x000fe20000011631ULL, 0x20000037ff317230ULL, 0x000fe20000004100ULL,
0x000000ff30397812ULL, 0x000fe200078ec0ffULL, 0x2000002eff377230ULL, 0x000fe20000004100ULL,
0x00000010ff2a7819ULL, 0x000fc4000001161bULL, 0x00000008ff2e7819ULL, 0x000fe4000001162dULL,
0x00000018ff247819ULL, 0x000fe40000011616ULL, 0x0000002fff2f723eULL, 0x000fe400020006ffULL,
0x00000039ff39723eULL, 0x000fe400020006ffULL, 0x000000ff28287812ULL, 0x000fe200078ec0ffULL,
0x2000002fff307230ULL, 0x000fe20000004100ULL, 0x000000ff1b167812ULL, 0x000fe200078ec0ffULL,
0x20000039ff2d7230ULL, 0x000fe20000004100ULL, 0x00000038ff38723eULL, 0x000fc400020006ffULL,
0x0000ffff1b1b7812ULL, 0x000fe400078ec0ffULL, 0x0000002eff2e723eULL, 0x000fe200020006ffULL,
0x20000038ff2f7230ULL, 0x000fe20000004100ULL, 0x000000ff2a2a7812ULL, 0x000fe400078ec0ffULL,
0x00000021ff21723eULL, 0x000fe400020006ffULL, 0x00000028ff28723eULL, 0x000fe400020006ffULL,
0x00000010ff297819ULL, 0x000fe20000011619ULL, 0x20000021ff277230ULL, 0x000fe20000004100ULL,
0x00000008ff397819ULL, 0x000fc4000001161bULL, 0x0000002aff38723eULL, 0x000fe200020006ffULL,
0x2000002eff2a7230ULL, 0x000fe20000004100ULL, 0x000000ff183b7812ULL, 0x040fe200078ec0ffULL,
0x20000028ff2e7230ULL, 0x000fe20000004100ULL, 0x00000018ff3a7819ULL, 0x000fe40000011618ULL,
0x0000ffff18327812ULL, 0x000fe400078ec0ffULL, 0x000000ff193c7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff187819ULL, 0x000fc40000011619ULL, 0x000000ff1a3d7812ULL, 0x040fe400078ec0ffULL,
0x00000023ff23723eULL, 0x000fe400020006ffULL, 0x0000ffff1a1a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff29297812ULL, 0x000fe200078ec0ffULL, 0x20000023ff2c7230ULL, 0x000fe20000004100ULL,
0x00000039ff28723eULL, 0x000fe400020006ffULL, 0x00000022ff22723eULL, 0x000fc400020006ffULL,
0x00000024ff17723eULL, 0x000fe400020006ffULL, 0x0000003cff19723eULL, 0x000fe200020006ffULL,
0x20000022ff247230ULL, 0x000fe20000004100ULL, 0x00000018ff18723eULL, 0x000fe200020006ffULL,
0x20000017ff237230ULL, 0x000fe20000004100ULL, 0x0000003bff21723eULL, 0x000fe200020006ffULL,
0x20000019ff197230ULL, 0x000fe20000004100ULL, 0x00000029ff29723eULL, 0x000fe200020006ffULL,
0x20000018ff187230ULL, 0x000fe20000004100ULL, 0x00000008ff1a7819ULL, 0x000fe2000001161aULL,
0x20000021ff217230ULL, 0x000fe20000004100ULL, 0x00000010ff3c7819ULL, 0x000fe20000011627ULL,
0x20000028ff277230ULL, 0x000fe20000004100ULL, 0x00000008ff367819ULL, 0x000fe20000011636ULL,
0x20000029ff297230ULL, 0x000fe20000004100ULL, 0x00000008ff327819ULL, 0x000fc40000011632ULL,
0x00000010ff267819ULL, 0x000fe40000011626ULL, 0x00000010ff317819ULL, 0x000fe40000011631ULL,
0x00000010ff257819ULL, 0x000fe40000011625ULL, 0x00000010ff287819ULL, 0x000fe40000011630ULL,
0x0000001aff1a723eULL, 0x000fe400020006ffULL, 0x00000010ff207819ULL, 0x000fc40000011620ULL,
0x00000010ff2f7819ULL, 0x000fe2000001162fULL, 0x2000001aff1b7230ULL, 0x000fe20000004100ULL,
0x0000003aff22723eULL, 0x000fe200020006ffULL, 0x20000038ff1a7230ULL, 0x000fe20000004100ULL,
0x0000003dff17723eULL, 0x000fe400020006ffULL, 0x00000016ff16723eULL, 0x000fe200020006ffULL,
0x20000022ff227230ULL, 0x000fe20000004100ULL, 0x00000036ff36723eULL, 0x000fe200020006ffULL,
0x20000017ff177230ULL, 0x000fe20000004100ULL, 0x00000032ff32723eULL, 0x000fe200020006ffULL,
0x20000016ff167230ULL, 0x000fe20000004100ULL, 0x00000010ff2c7819ULL, 0x000fe2000001162cULL,
0x20000036ff367230ULL, 0x000fe20000004100ULL, 0x00000010ff357819ULL, 0x000fe20000011635ULL,
0x20000032ff327230ULL, 0x000fe20000004100ULL, 0x0000105431307816ULL, 0x000fc40000000026ULL,
0x0000105428317816ULL, 0x000fe40000000025ULL, 0x00000010ff287819ULL, 0x000fe4000001162dULL,
0x00001054202d7816ULL, 0x000fe4000000002fULL, 0x00001054353d7816ULL, 0x000fe4000000002cULL,
0x00000010ff207819ULL, 0x000fe40000011618ULL, 0x00000010ff247819ULL, 0x000fc40000011624ULL,
0x00000010ff237819ULL, 0x000fe40000011623ULL, 0x00000010ff337819ULL, 0x000fe40000011633ULL,
0x00000010ff2c7819ULL, 0x000fe40000011637ULL, 0x00000010ff217819ULL, 0x000fe40000011621ULL,
0x00000010ff197819ULL, 0x000fe40000011619ULL, 0x00000010ff187819ULL, 0x000fc40000011629ULL,
0x00000010ff397819ULL, 0x000fe4000001162bULL, 0x00000010ff2b7819ULL, 0x000fe40000011634ULL,
0x0000105424357816ULL, 0x000fe40000000033ULL, 0x00001054232c7816ULL, 0x000fe4000000002cULL,
0x0000105428287816ULL, 0x000fe40000000021ULL, 0x00000010ff257819ULL, 0x000fc4000001162aULL,
0x0000105418297816ULL, 0x000fe40000000019ULL, 0x00000010ff347819ULL, 0x000fe40000011636ULL,
0x00000010ff237819ULL, 0x000fe40000011622ULL, 0x00000010ff247819ULL, 0x000fe40000011632ULL,
0x00000010ff177819ULL, 0x000fe20000011617ULL, 0x000000301c30723cULL, 0x008fe200000418ffULL,
0x00000010ff2e7819ULL, 0x000fc4000001162eULL, 0x00000010ff187819ULL, 0x000fe40000011615ULL,
0x00000010ff167819ULL, 0x000fe40000011616ULL, 0x00000010ff217819ULL, 0x000fe4000001161aULL,
0x00000010ff1b7819ULL, 0x000fe4000001161bULL, 0x00000010ff1a7819ULL, 0x000fe40000011614ULL,
0x00000010ff157819ULL, 0x000fc40000011627ULL, 0x0000105420257816ULL, 0x000fe40000000025ULL,
0x000010542b3c7816ULL, 0x000fe4000000003cULL, 0x0000105439347816ULL, 0x000fe20000000034ULL,
0x000000281c28723cULL, 0x000fe200000418ffULL, 0x0000105423247816ULL, 0x000fe40000000024ULL,
0x000010542e207816ULL, 0x000fe40000000017ULL, 0x0000105421217816ULL, 0x000fe20000000016ULL,
0x0000003c1c3c723cULL, 0x000fe200000418ffULL, 0x0000105418147816ULL, 0x000fc4000000001bULL,
0x000010541a157816ULL, 0x000fe40000000015ULL, 0x013800005e18783bULL, 0x0002e20000000200ULL,
0x000000341c34723cULL, 0x000fec00000418ffULL, 0x0000002c1c2c723cULL, 0x000fec00000418ffULL,
0x000000241c24723cULL, 0x000fec00000418ffULL, 0x000000201c20723cULL, 0x000fec00000418ffULL,
0x000000141c1c723cULL, 0x000fe200000418ffULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000102947ULL, 0x002fde0003800000ULL, 0x0000000318187232ULL, 0x088fe40000200000ULL,
0x000000031a1a7232ULL, 0x000fe40000200000ULL, 0x0000000419197232ULL, 0x084fe40000200000ULL,
0x000000041b1b7232ULL, 0x000fce0000200000ULL, 0x000000006214783bULL, 0x000e620000004200ULL,
0x0000006b6300720cULL, 0x080fe20003f66070ULL, 0x00000c3000007945ULL, 0x000fe20003800000ULL,
0x000000085f00720cULL, 0x0c0fe40003fc3070ULL, 0x0000006b6c00720cULL, 0x000fe40003f86070ULL,
0x000000085f00720cULL, 0x000fe40003fa3070ULL, 0x00000010ff387819ULL, 0x002fe40000011614ULL,
0x00000010ff3a7819ULL, 0x000fc40000011615ULL, 0x000000ff14397812ULL, 0x000fe400078ec0ffULL,
0x000000ff38387812ULL, 0x000fe400078ec0ffULL, 0x000000ff3a3a7812ULL, 0x000fe400078ec0ffULL,
0x00000039ff39723eULL, 0x000fe400020006ffULL, 0x00000038ff38723eULL, 0x000fe400020006ffULL,
0x0000003aff50723eULL, 0x000fe200020006ffULL, 0x20000039ff397230ULL, 0x000fe20000004100ULL,
0x000000ff153b7812ULL, 0x000fe200078ec0ffULL, 0x20000038ff3a7230ULL, 0x000fe20000004100ULL,
0x00000018ff387819ULL, 0x000fe20000011614ULL, 0x20000050ff727230ULL, 0x000fe20000004100ULL,
0x0000003bff3b723eULL, 0x000fc400020006ffULL, 0x00000010ff397819ULL, 0x000fe40000011639ULL,
0x00000010ff3a7819ULL, 0x000fe2000001163aULL, 0x2000003bff717230ULL, 0x000fe20000004100ULL,
0x00000038ff51723eULL, 0x000fe400020006ffULL, 0x000010543a507816ULL, 0x000fe40000000039ULL,
0x000000006038783bULL, 0x000e620000004200ULL, 0x00000010ff717819ULL, 0x000fe40000011671ULL,
0x00000010ff727819ULL, 0x000fc40000011672ULL, 0x00000018ff6f7819ULL, 0x000fe40000011615ULL,
0x0000ffff14747812ULL, 0x000fe200078ec0ffULL, 0x20000051ff147230ULL, 0x000fe20000004100ULL,
0x000000ff16737812ULL, 0x000fe400078ec0ffULL, 0x0000105472517816ULL, 0x000fe40000000071ULL,
0x0000006fff6f723eULL, 0x000fe400020006ffULL, 0x0000ffff15157812ULL, 0x000fc400078ec0ffULL,
0x00000008ff717819ULL, 0x000fe20000011674ULL, 0x00000050183c723cULL, 0x008fe2000004183cULL,
0x00000073ff73723eULL, 0x000fe400020006ffULL, 0x00000008ff727819ULL, 0x000fe20000011615ULL,
0x2000006fff157230ULL, 0x000fe20000004100ULL, 0x00000071ff71723eULL, 0x000fe200020006ffULL,
0x20000073ff6f7230ULL, 0x000fe20000004100ULL, 0x000000ff17747812ULL, 0x000fe400078ec0ffULL,
0x00000010ff737819ULL, 0x000fe20000011616ULL, 0x20000071ff717230ULL, 0x000fe20000004100ULL,
0x00000072ff72723eULL, 0x000fc400020006ffULL, 0x00000074ff50723eULL, 0x000fe400020006ffULL,
0x000000ff73747812ULL, 0x000fe200078ec0ffULL, 0x20000072ff727230ULL, 0x000fe20000004100ULL,
0x00000010ff737819ULL, 0x000fe40000011614ULL, 0x00000010ff147819ULL, 0x000fe40000011671ULL,
0x00000074ff71723eULL, 0x000fe400020006ffULL, 0x00000010ff747819ULL, 0x000fc40000011615ULL,
0x0000105473147816ULL, 0x000fe40000000014ULL, 0x00000010ff157819ULL, 0x000fe20000011672ULL,
0x20000071ff727230ULL, 0x000fe20000004100ULL, 0x00000010ff737819ULL, 0x000fe40000011617ULL,
0x00000018ff517819ULL, 0x000fe40000011616ULL, 0x0000ffff16717812ULL, 0x000fe400078ec0ffULL,
0x000000ff73737812ULL, 0x000fc400078ec0ffULL, 0x00000010ff167819ULL, 0x000fe4000001166fULL,
0x00000010ff6f7819ULL, 0x000fe40000011672ULL, 0x00000018ff727819ULL, 0x000fe40000011617ULL,
0x0000105474157816ULL, 0x000fe40000000015ULL, 0x00000073ff73723eULL, 0x000fe400020006ffULL,
0x0000ffff17757812ULL, 0x000fe200078ec0ffULL, 0x20000050ff177230ULL, 0x000fe20000004100ULL,
0x000010546f167816ULL, 0x000fe20000000016ULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x00000072ff6f723eULL, 0x000fe200020006ffULL, 0x000000141834723cULL, 0x000fe20000041834ULL,
0x00000008ff727819ULL, 0x000fc40000011671ULL, 0x000000ff38747812ULL, 0x002fe200078ec0ffULL,
0x2000006fff6f7230ULL, 0x000fe20000004100ULL, 0x00000008ff717819ULL, 0x000fe40000011675ULL,
0x00000051ff51723eULL, 0x000fe400020006ffULL, 0x00000072ff72723eULL, 0x000fe400020006ffULL,
0x00000010ff147819ULL, 0x000fe20000011638ULL, 0x20000051ff517230ULL, 0x000fe20000004100ULL,
0x00000074ff50723eULL, 0x000fe200020006ffULL, 0x20000072ff727230ULL, 0x000fe20000004100ULL,
0x00000071ff71723eULL, 0x000fc400020006ffULL, 0x00000010ff157819ULL, 0x000fe20000011639ULL,
0x20000050ff507230ULL, 0x000fe20000004100ULL, 0x00000010ff177819ULL, 0x000fe20000011617ULL,
0x20000071ff717230ULL, 0x000fe20000004100ULL, 0x00000010ff747819ULL, 0x000fe40000011673ULL,
0x000000ff39737812ULL, 0x000fe400078ec0ffULL, 0x000000ff14147812ULL, 0x000fe400078ec0ffULL,
0x000000ff15157812ULL, 0x000fc400078ec0ffULL, 0x0000105474177816ULL, 0x000fe40000000017ULL,
0x00000073ff74723eULL, 0x000fe400020006ffULL, 0x00000014ff73723eULL, 0x000fe400020006ffULL,
0x00000015ff75723eULL, 0x000fe200020006ffULL, 0x000000161830723cULL, 0x000fe20000041830ULL,
0x00000010ff157819ULL, 0x000fe20000011651ULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x00000010ff147819ULL, 0x000fe20000011672ULL, 0x20000075ff757230ULL, 0x000fe20000004100ULL,
0x00000010ff727819ULL, 0x000fe2000001166fULL, 0x20000074ff517230ULL, 0x000fe20000004100ULL,
0x00000010ff717819ULL, 0x000fc40000011671ULL, 0x0000105415147816ULL, 0x000fe40000000014ULL,
0x0000105472157816ULL, 0x000fe40000000071ULL, 0x00000018ff167819ULL, 0x000fe40000011638ULL,
0x00000010ff177819ULL, 0x000fe40000011650ULL, 0x00000010ff727819ULL, 0x000fe20000011673ULL,
0x00000014182c723cULL, 0x000fe2000004182cULL, 0x00000010ff747819ULL, 0x000fc40000011675ULL,
0x00000016ff50723eULL, 0x000fe400020006ffULL, 0x0000105472167816ULL, 0x000fe40000000017ULL,
0x0000ffff38757812ULL, 0x000fe400078ec0ffULL, 0x00000010ff717819ULL, 0x000fe40000011651ULL,
0x00000010ff727819ULL, 0x000fe4000001163aULL, 0x000000ff3a157812ULL, 0x000fc400078ec0ffULL,
0x00000018ff147819ULL, 0x000fe4000001163aULL, 0x0000ffff3a387812ULL, 0x000fe400078ec0ffULL,
0x000000ff3b3a7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff6f7819ULL, 0x000fe40000011639ULL,
0x0000ffff39737812ULL, 0x000fe200078ec0ffULL, 0x20000050ff397230ULL, 0x000fe20000004100ULL,
0x0000105474177816ULL, 0x000fc40000000071ULL, 0x00000015ff15723eULL, 0x000fe400020006ffULL,
0x00000018ff747819ULL, 0x100fe4000001163bULL, 0x0000003aff50723eULL, 0x000fe200020006ffULL,
0x000000161828723cULL, 0x000fe20000041828ULL, 0x0000006fff51723eULL, 0x000fe400020006ffULL,
0x00000010ff717819ULL, 0x000fe4000001163bULL, 0x0000ffff3b6f7812ULL, 0x000fe200078ec0ffULL,
0x20000051ff517230ULL, 0x000fe20000004100ULL, 0x00000008ff3a7819ULL, 0x000fc40000011675ULL,
0x00000014ff3b723eULL, 0x000fe200020006ffULL, 0x20000015ff147230ULL, 0x000fe20000004100ULL,
0x00000008ff737819ULL, 0x000fe20000011673ULL, 0x20000050ff157230ULL, 0x000fe20000004100ULL,
0x00000074ff74723eULL, 0x000fe400020006ffULL, 0x0000003aff50723eULL, 0x000fe200020006ffULL,
0x2000003bff3a7230ULL, 0x000fe20000004100ULL, 0x000000ff72727812ULL, 0x000fe200078ec0ffULL,
0x20000074ff3b7230ULL, 0x000fe20000004100ULL, 0x00000073ff73723eULL, 0x000fc400020006ffULL,
0x000000ff71747812ULL, 0x000fe200078ec0ffULL, 0x20000050ff717230ULL, 0x000fe20000004100ULL,
0x00000072ff72723eULL, 0x000fe200020006ffULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x00000008ff387819ULL, 0x000fe40000011638ULL, 0x00000074ff75723eULL, 0x000fe200020006ffULL,
0x20000072ff507230ULL, 0x000fe20000004100ULL, 0x00000038ff74723eULL, 0x000fe400020006ffULL,
0x00000010ff397819ULL, 0x000fc40000011639ULL, 0x00000010ff387819ULL, 0x000fe20000011671ULL,
0x20000074ff717230ULL, 0x000fe20000004100ULL, 0x00000010ff727819ULL, 0x000fe40000011651ULL,
0x00000010ff737819ULL, 0x000fe40000011673ULL, 0x0000105439387816ULL, 0x000fe40000000038ULL,
0x00000008ff6f7819ULL, 0x000fe4000001166fULL, 0x0000105472397816ULL, 0x000fc40000000073ULL,
0x0000006fff76723eULL, 0x000fe200020006ffULL, 0x20000075ff6f7230ULL, 0x000fe20000004100ULL,
0x00000010ff177819ULL, 0x000fe40000011615ULL, 0x00000010ff147819ULL, 0x000fe20000011614ULL,
0x000000381824723cULL, 0x000fe20000041824ULL, 0x20000076ff517230ULL, 0x000fe20000004100ULL,
0x00000010ff157819ULL, 0x000fe40000011650ULL, 0x00000010ff3a7819ULL, 0x000fe4000001163aULL,
0x00000010ff727819ULL, 0x000fe2000001163bULL, 0x000000016b387836ULL, 0x000fe20000000000ULL,
0x00000010ff507819ULL, 0x000fc4000001166fULL, 0x00000010ff717819ULL, 0x000fe40000011671ULL,
0x000000386300720cULL, 0x000fe40005f66470ULL, 0x00000010ff517819ULL, 0x000fe40000011651ULL,
0x0000105415167816ULL, 0x000fe40000000014ULL, 0x0000105450177816ULL, 0x000fe40000000017ULL,
0x000010543a147816ULL, 0x000fc40000000071ULL, 0x0000105472157816ULL, 0x000fe40000000051ULL,
0x000000386c00720cULL, 0x000fe20006786470ULL, 0x000000161820723cULL, 0x000fec0000041820ULL,
0x00000014181c723cULL, 0x000fe2000004181cULL, 0x00000001ff167424ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000403947ULL, 0x000fde0003000000ULL,
0x0000003c0b0b7221ULL, 0x000fe20000010000ULL, 0x0000003d0c0c7221ULL, 0x000fe20000010000ULL,
0x000000340f0f7221ULL, 0x000fe20000010000ULL, 0x0000003510107221ULL, 0x000fe20000010000ULL,
0x0000003041417221ULL, 0x000fe20000010000ULL, 0x0000003142427221ULL, 0x000fe20000010000ULL,
0x0000002c45457221ULL, 0x000fe20000010000ULL, 0x0000002d46467221ULL, 0x000fe20000010000ULL,
0x0000002849497221ULL, 0x000fe20000010000ULL, 0x000000294a4a7221ULL, 0x000fe20000010000ULL,
0x000000244d4d7221ULL, 0x000fe20000010000ULL, 0x000000254e4e7221ULL, 0x000fe20000010000ULL,
0x0000002053537221ULL, 0x000fe20000010000ULL, 0x0000002154547221ULL, 0x000fe20000010000ULL,
0x0000001c57577221ULL, 0x000fe20000010000ULL, 0x0000001d58587221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000012000007945ULL, 0x000fe80003800000ULL,
0x0000000000404947ULL, 0x000fea0002800000ULL, 0x0000003e0d0d7221ULL, 0x000fe20000010000ULL,
0x0000003f0e0e7221ULL, 0x000fe20000010000ULL, 0x0000003611117221ULL, 0x000fe20000010000ULL,
0x0000003740407221ULL, 0x000fe20000010000ULL, 0x0000003243437221ULL, 0x000fe20000010000ULL,
0x0000003344447221ULL, 0x000fe20000010000ULL, 0x0000002e47477221ULL, 0x000fe20000010000ULL,
0x0000002f48487221ULL, 0x000fe20000010000ULL, 0x0000002a4b4b7221ULL, 0x000fe20000010000ULL,
0x0000002b4c4c7221ULL, 0x000fe20000010000ULL, 0x000000264f4f7221ULL, 0x000fe20000010000ULL,
0x0000002752527221ULL, 0x000fe20000010000ULL, 0x0000002255557221ULL, 0x000fe20000010000ULL,
0x0000002356567221ULL, 0x000fe20000010000ULL, 0x0000001e59597221ULL, 0x000fe20000010000ULL,
0x0000001f5a5a7221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x018b8816ff1479a7ULL, 0x000e620008500007ULL, 0x00000002ff177819ULL, 0x000fe40000011638ULL,
0x000000085f00720cULL, 0x0c0fe40003fc3070ULL, 0x0000001738177207ULL, 0x040fe40000000000ULL,
0x00000003381a7812ULL, 0x000fe400078ec0ffULL, 0x000000085f00720cULL, 0x000fe20003fa3070ULL,
0x0000000317177836ULL, 0x000fe20000000000ULL, 0x00000040ff387803ULL, 0x000fc40000000000ULL,
0x000000ff1a1a7207ULL, 0x000fe40004000000ULL, 0x00000003171b7812ULL, 0x040fe400078ec0ffULL,
0x00000008171c7211ULL, 0x000fe200078ff0ffULL, 0x000000ffff187224ULL, 0x002fce00078e0015ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x018b806dff0075a7ULL, 0x000e6400080c0147ULL,
0x00000000005c6947ULL, 0x002fea0003800000ULL, 0x000000ffff1d7224ULL, 0x000fce00078e00ffULL,
0x000000101d00780cULL, 0x000fda0003fc6270ULL, 0x000000000044e947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x0000001416197210ULL, 0x000fca0007fde1ffULL,
0x0000000115157824ULL, 0x000fe200030e0e17ULL, 0x003d09001900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x000000000008e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x00000000001ce947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001914147211ULL, 0x000fca00078d10ffULL, 0x000000ffff157224ULL, 0x000fca00030e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011d1d7836ULL, 0x000fce0000000000ULL,
0x018b806dff0075a7ULL, 0x000e6400080c0147ULL, 0xfffffffc00a8e947ULL, 0x002fea000383ffffULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x018b8818ff0075a7ULL, 0x000e6400080c0147ULL,
0x00000000005c6947ULL, 0x002fea0003800000ULL, 0x000000ffff1d7224ULL, 0x000fce00078e00ffULL,
0x000000101d00780cULL, 0x000fda0003fc6270ULL, 0x000000000044e947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x0000001416197210ULL, 0x000fca0007fde1ffULL,
0x0000000115157824ULL, 0x000fe200030e0e17ULL, 0x003d09001900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x000000000008e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x00000000001ce947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001914147211ULL, 0x000fca00078d10ffULL, 0x000000ffff157224ULL, 0x000fca00030e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011d1d7836ULL, 0x000fce0000000000ULL,
0x018b8818ff0075a7ULL, 0x000e6400080c0147ULL, 0xfffffffc00a8e947ULL, 0x002fea000383ffffULL,
0x000000041c147824ULL, 0x000fc800078e021bULL, 0x00000040141e7824ULL, 0x000fe400078e00ffULL,
0x000000011c147836ULL, 0x000fc60000000000ULL, 0x000000405b1d7812ULL, 0x000fe400078ef81eULL,
0x0000000c14007c0cULL, 0x000fda000bfc6070ULL, 0x000000040054e947ULL, 0x000fea0003800000ULL,
0x000000015d207824ULL, 0x000fe200078e0270ULL, 0x000000091e187c48ULL, 0x000fe2000ffe0000ULL,
0x00000010121f7824ULL, 0x000fe200078e00ffULL, 0x00014000070e7890ULL, 0x000fe2000fffe03fULL,
0x0000000120177824ULL, 0x040fe200078e021dULL, 0x0000000720227c11ULL, 0x000fe2000f8e10ffULL,
0x0000000118187824ULL, 0x000fe200078e0a1eULL, 0x000000f01f1f7812ULL, 0x000fc600078ec0ffULL,
0x018a000022147984ULL, 0x000e620000000800ULL, 0x000000185d187248ULL, 0x000fca0007fe0000ULL,
0x0000000118217824ULL, 0x000fe200078e0a5dULL, 0x0000000714197c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e660000000a00ULL, 0x018ac00019167984ULL, 0x0007240000000800ULL,
0x0000000120197824ULL, 0x048fe400078e0212ULL, 0x0000001020207824ULL, 0x000fca00078e00ffULL,
0xfffffff020197812ULL, 0x000fe200078ee219ULL, 0x0000000270207836ULL, 0x000fc60000000000ULL,
0x0000000e19237c11ULL, 0x000fe2000f8e20ffULL, 0x000000015d247824ULL, 0x000fc800078e0220ULL,
0x0000000124197824ULL, 0x000fe400078e021dULL, 0x0000000616177c24ULL, 0x010fc8000f8e0217ULL,
0x0000010017167825ULL, 0x002fc600078e0014ULL, 0x0000001f16167210ULL, 0x000fca0007fde0ffULL,
0x000000ffff177224ULL, 0x000fe200030e0617ULL, 0x000000217000720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e8000f101c4aULL,
0x018a080022187984ULL, 0x000ee20000000800ULL, 0x0000000124167824ULL, 0x042fe400078e0212ULL,
0x0000001024177824ULL, 0x000fca00078e00ffULL, 0xfffffff017167812ULL, 0x000fc800078ee216ULL,
0x0000000e16237c11ULL, 0x000fe4000f8e20ffULL, 0x00000007181e7c11ULL, 0x008fca000f8e10ffULL,
0x018ac0001e187984ULL, 0x000e640000000800ULL, 0x0000000618197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000001f18187210ULL, 0x000fca0007fde0ffULL,
0x000000ffff197224ULL, 0x000fe200030e0619ULL, 0x000000212000720cULL, 0x000fe20003fc6070ULL,
0x0000000470207836ULL, 0x000fe40000000000ULL, 0x0000000670707836ULL, 0x000fe40000000000ULL,
0x000000015d247824ULL, 0x000fc800078e0220ULL, 0x0000000124177824ULL, 0x000fc800078e021dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018237faeULL, 0x0003e8000f101c4aULL,
0x018a100022167984ULL, 0x000ee20000000800ULL, 0x0000000124187824ULL, 0x042fe400078e0212ULL,
0x0000001024197824ULL, 0x000fca00078e00ffULL, 0xfffffff019187812ULL, 0x000fc800078ee218ULL,
0x0000000e18197c11ULL, 0x000fe4000f8e20ffULL, 0x00000007161e7c11ULL, 0x008fca000f8e10ffULL,
0x018ac0001e167984ULL, 0x0002e40000000800ULL, 0x000000015d1e7824ULL, 0x002fc800078e0270ULL,
0x000000011e1d7824ULL, 0x000fe400078e021dULL, 0x0000000616177c24ULL, 0x008fc8000f8e0217ULL,
0x0000010017167825ULL, 0x000fc600078e0014ULL, 0x0000001f16167210ULL, 0x000fca0007fde0ffULL,
0x000000ffff177224ULL, 0x000fe200030e0617ULL, 0x000000212000720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016197faeULL, 0x0003e8000f101c4aULL,
0x018a180022187984ULL, 0x000ee20000000800ULL, 0x000000011e167824ULL, 0x042fe400078e0212ULL,
0x000000101e177824ULL, 0x000fca00078e00ffULL, 0xfffffff017167812ULL, 0x000fc800078ee216ULL,
0x0000000e16177c11ULL, 0x000fe4000f8e20ffULL, 0x0000000718187c11ULL, 0x008fcc000f8e10ffULL,
0x018ac00018187984ULL, 0x000e640000000800ULL, 0x00000006181d7c24ULL, 0x002fc8000f8e021dULL,
0x000001001d147825ULL, 0x000fc600078e0014ULL, 0x0000001f14147210ULL, 0x000fca0007fde0ffULL,
0x000000ffff157224ULL, 0x000fe200030e0615ULL, 0x000000217000720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e2000f101c4aULL,
0x0000000400247947ULL, 0x000fea0003800000ULL, 0x000000015d707824ULL, 0x000fe200078e0270ULL,
0x00014000070e7890ULL, 0x000fe2000fffe03fULL, 0x0000001012197824ULL, 0x000fe400078e00ffULL,
0x0000000170177824ULL, 0x040fe200078e021dULL, 0x00000007701f7c11ULL, 0x040fe2000f8e10ffULL,
0x00000010701e7824ULL, 0x040fe200078e00ffULL, 0x000000f019217812ULL, 0x000fe200078ec0ffULL,
0x0000000170197824ULL, 0x000fe400078e0212ULL, 0x018a00001f147984ULL, 0x000e620000000800ULL,
0x0000000270207836ULL, 0x000fc40000000000ULL, 0xfffffff01e197812ULL, 0x000fe400078ee219ULL,
0x0000000120227824ULL, 0x040fe400078e0212ULL, 0x0000000e19237c11ULL, 0x000fe2000f8e20ffULL,
0x0000000120197824ULL, 0x000fe200078e021dULL, 0x0000000714187c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e660000000a00ULL, 0x018ac00018167984ULL, 0x000ee40000000800ULL,
0x0000000616177c24ULL, 0x008fc8000f8e0217ULL, 0x0000010017167825ULL, 0x002fc600078e0014ULL,
0x0000002116167210ULL, 0x000fca0007fde0ffULL, 0x000000ffff177224ULL, 0x000fca00030e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e8000b901c4aULL,
0x018a08001f187984ULL, 0x000ee20000000800ULL, 0x0000001020177824ULL, 0x002fe400078e00ffULL,
0x0000000470207836ULL, 0x000fe40000000000ULL, 0x0000000670707836ULL, 0x000fe20000000000ULL,
0xfffffff017227812ULL, 0x000fe200078ee222ULL, 0x0000000120177824ULL, 0x000fc400078e021dULL,
0x00000001701d7824ULL, 0x000fe200078e021dULL, 0x0000000e22237c11ULL, 0x000fe2000f8e20ffULL,
0x0000000120227824ULL, 0x000fe200078e0212ULL, 0x00000007181e7c11ULL, 0x008fca000f8e10ffULL,
0x018ac0001e187984ULL, 0x000e640000000800ULL, 0x0000000618197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000002118187210ULL, 0x000fca0007fde0ffULL,
0x000000ffff197224ULL, 0x000fca00030e0619ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018237faeULL, 0x0003e8000b901c4aULL, 0x018a10001f167984ULL, 0x000ee20000000800ULL,
0x0000001020197824ULL, 0x002fca00078e00ffULL, 0xfffffff019227812ULL, 0x000fc800078ee222ULL,
0x0000000e22197c11ULL, 0x000fe4000f8e20ffULL, 0x00000007161e7c11ULL, 0x008fca000f8e10ffULL,
0x018ac0001e167984ULL, 0x000e640000000800ULL, 0x0000000616177c24ULL, 0x002fc8000f8e0217ULL,
0x0000010017167825ULL, 0x000fc600078e0014ULL, 0x0000002116167210ULL, 0x000fca0007fde0ffULL,
0x000000ffff177224ULL, 0x000fca00030e0617ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016197faeULL, 0x0003e8000b901c4aULL, 0x018a18001f187984ULL, 0x000ee40000000800ULL,
0x0000000718187c11ULL, 0x008fcc000f8e10ffULL, 0x018ac00018187984ULL, 0x000ee40000000800ULL,
0x00000006181d7c24ULL, 0x008fc8000f8e021dULL, 0x000001001d147825ULL, 0x000fc800078e0014ULL,
0x00000001701d7824ULL, 0x040fe200078e0212ULL, 0x0000002114147210ULL, 0x000fe20007fde0ffULL,
0x0000001070707824ULL, 0x000fc800078e00ffULL, 0x000000ffff157224ULL, 0x000fe200030e0615ULL,
0xfffffff0701d7812ULL, 0x000fc800078ee21dULL, 0x0000000e1d1d7c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000141d7faeULL, 0x0003e4000b901c4aULL,
0x00000001ff147424ULL, 0x002fcc00078e00ffULL, 0x018b8814ff1479a7ULL, 0x000e640008500007ULL,
0x000000ffff187224ULL, 0x002fce00078e0015ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x018b8818ff0075a7ULL, 0x000e6400080c0147ULL, 0x00000000005c6947ULL, 0x002fea0003800000ULL,
0x000000ffff1d7224ULL, 0x000fce00078e00ffULL, 0x000000101d00780cULL, 0x000fda0003fc6270ULL,
0x000000000044e947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x0000001416197210ULL, 0x000fca0007fde1ffULL, 0x0000000115157824ULL, 0x000fe200030e0e17ULL,
0x003d09001900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x000000000008e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x00000000001ce947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078d10ffULL,
0x000000ffff157224ULL, 0x000fca00030e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011d1d7836ULL, 0x000fce0000000000ULL, 0x018b8818ff0075a7ULL, 0x000e6400080c0147ULL,
0xfffffffc00a8e947ULL, 0x002fea000383ffffULL, 0x0000019000007945ULL, 0x000fe20003800000ULL,
0x00000001ff6f7424ULL, 0x000fc600078e00ffULL, 0x0000000000581947ULL, 0x000fea0003800000ULL,
0x0000001c5f00720cULL, 0x000fe20003fc4070ULL, 0x00009400ff187b82ULL, 0x000e620000000800ULL,
0x000000076e197c11ULL, 0x000fe4000f8e10ffULL, 0x000000ff1a147207ULL, 0x040fe40003000000ULL,
0x000000ff1a177207ULL, 0x000fc60007000000ULL, 0x000000011b1b7824ULL, 0x000fe400078e0214ULL,
0x00009200ff147b82ULL, 0x000ee20000000a00ULL, 0x000000015c177824ULL, 0x000fe400078e0217ULL,
0x000000401b167824ULL, 0x040fe200078e00ffULL, 0x0000001c1b1b7211ULL, 0x000fc800078ff0ffULL,
0x000000c016167812ULL, 0x000fca00078ec0ffULL, 0x000001001b167824ULL, 0x000fc800078e0216ULL,
0x0000002016167836ULL, 0x000fc80000000000ULL, 0x0000001817177224ULL, 0x102fe400078e0216ULL,
0x000000016e167824ULL, 0x040fe400078e0216ULL, 0x000000016e177824ULL, 0x000fc600078e0217ULL,
0x0000000916007c0cULL, 0x000fe2000bfc6070ULL, 0x0000000417147825ULL, 0x008fd800078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18a0000014197faeULL, 0x0003e4000f12184aULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a48ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x018b786fff6e79a7ULL, 0x000e620008500007ULL, 0x0000000000102947ULL, 0x000fea0003800000ULL,
0x00000006ff03723eULL, 0x000fc800000010ffULL, 0x0000541003147816ULL, 0x000fca0000000003ULL,
0x00001f6c14047589ULL, 0x0044e800000e0000ULL, 0x00001f6314037589ULL, 0x00046400000e0000ULL,
0x013800006630783bULL, 0x0006a20000000200ULL, 0x0000000000102947ULL, 0x000fea0003800000ULL,
0x0000000330307232ULL, 0x086fe40000200000ULL, 0x0000000332327232ULL, 0x000fe40000200000ULL,
0x0000000431317232ULL, 0x088fe40000200000ULL, 0x0000000433337232ULL, 0x000fce0000200000ULL,
0x000000006514783bULL, 0x004ea80000004200ULL, 0x000000006418783bULL, 0x000f220000004200ULL,
0x0000ffff162a7812ULL, 0x044fe400078ec0ffULL, 0x00000010ff2b7819ULL, 0x000fe40000011617ULL,
0x000000ff16227812ULL, 0x000fe400078ec0ffULL, 0x00000008ff2a7819ULL, 0x000fc4000001162aULL,
0x000000ff2b2b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff151f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff2f7819ULL, 0x100fe40000011616ULL, 0x00000018ff207819ULL, 0x000fe40000011616ULL,
0x0000ffff182e7812ULL, 0x010fe400078ec0ffULL, 0x00000022ff22723eULL, 0x000fc400020006ffULL,
0x00000018ff167819ULL, 0x000fe40000011617ULL, 0x000000ff17237812ULL, 0x040fe400078ec0ffULL,
0x0000ffff172c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff18267812ULL, 0x000fe400078ec0ffULL,
0x000000ff193a7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff3b7819ULL, 0x000fc4000001161aULL,
0x0000002aff2a723eULL, 0x000fe400020006ffULL, 0x0000002bff2b723eULL, 0x000fe400020006ffULL,
0x00000010ff2d7819ULL, 0x100fe40000011618ULL, 0x00000018ff177819ULL, 0x000fe40000011618ULL,
0x00000010ff217819ULL, 0x100fe40000011619ULL, 0x00000018ff397819ULL, 0x000fc40000011619ULL,
0x0000ffff19277812ULL, 0x000fe400078ec0ffULL, 0x00000010ff357819ULL, 0x100fe40000011615ULL,
0x00000018ff1e7819ULL, 0x000fe40000011615ULL, 0x0000ffff15347812ULL, 0x000fe400078ec0ffULL,
0x00000010ff187819ULL, 0x000fe4000001161aULL, 0x000000ff1a3c7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff1a247812ULL, 0x000fe400078ec0ffULL, 0x0000001fff1f723eULL, 0x000fe400020006ffULL,
0x00000020ff19723eULL, 0x000fe200020006ffULL, 0x20000022ff207230ULL, 0x000fe20000004100ULL,
0x00000008ff2e7819ULL, 0x000fe2000001162eULL, 0x2000001fff297230ULL, 0x000fe20000004100ULL,
0x00000010ff257819ULL, 0x000fe2000001161bULL, 0x20000019ff197230ULL, 0x000fe20000004100ULL,
0x000000ff1b3d7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff1a7819ULL, 0x000fe4000001161bULL,
0x0000ffff1b157812ULL, 0x000fe400078ec0ffULL, 0x00000016ff16723eULL, 0x000fe400020006ffULL,
0x00000026ff26723eULL, 0x000fe400020006ffULL, 0x0000003aff1b723eULL, 0x000fe200020006ffULL,
0x2000002aff3a7230ULL, 0x000fe20000004100ULL, 0x0000003bff22723eULL, 0x000fe200020006ffULL,
0x2000002bff3b7230ULL, 0x000fe20000004100ULL, 0x00000010ff377819ULL, 0x000fe20000011614ULL,
0x20000016ff1f7230ULL, 0x000fe20000004100ULL, 0x00000039ff39723eULL, 0x000fe200020006ffULL,
0x20000026ff167230ULL, 0x000fe20000004100ULL, 0x0000002eff2a723eULL, 0x000fe200020006ffULL,
0x2000001bff1b7230ULL, 0x000fe20000004100ULL, 0x000000ff212b7812ULL, 0x000fe200078ec0ffULL,
0x20000022ff227230ULL, 0x000fe20000004100ULL, 0x0000ffff14367812ULL, 0x040fe200078ec0ffULL,
0x2000002aff217230ULL, 0x000fe20000004100ULL, 0x000000ff141d7812ULL, 0x000fc400078ec0ffULL,
0x000000ff37377812ULL, 0x000fe400078ec0ffULL, 0x0000001aff26723eULL, 0x000fe200020006ffULL,
0x20000039ff1a7230ULL, 0x000fe20000004100ULL, 0x000000ff35357812ULL, 0x000fe400078ec0ffULL,
0x00000008ff2c7819ULL, 0x000fe2000001162cULL, 0x20000026ff267230ULL, 0x000fe20000004100ULL,
0x0000002bff2b723eULL, 0x000fe400020006ffULL, 0x00000008ff277819ULL, 0x000fc40000011627ULL,
0x00000018ff1c7819ULL, 0x000fe40000011614ULL, 0x00000008ff397819ULL, 0x000fe40000011636ULL,
0x000000ff252a7812ULL, 0x000fe200078ec0ffULL, 0x2000002bff257230ULL, 0x000fe20000004100ULL,
0x0000001dff14723eULL, 0x000fe400020006ffULL, 0x00000037ff36723eULL, 0x000fe400020006ffULL,
0x00000035ff35723eULL, 0x000fe200020006ffULL, 0x20000014ff147230ULL, 0x000fe20000004100ULL,
0x0000002cff2c723eULL, 0x000fe200020006ffULL, 0x20000036ff367230ULL, 0x000fe20000004100ULL,
0x00000008ff247819ULL, 0x000fe20000011624ULL, 0x20000035ff377230ULL, 0x000fe20000004100ULL,
0x00000027ff27723eULL, 0x000fe200020006ffULL, 0x2000002cff2e7230ULL, 0x000fe20000004100ULL,
0x00000008ff347819ULL, 0x000fc40000011634ULL, 0x0000002aff2b723eULL, 0x000fe200020006ffULL,
0x20000027ff2c7230ULL, 0x000fe20000004100ULL, 0x000000ff2f2f7812ULL, 0x000fe400078ec0ffULL,
0x00000024ff24723eULL, 0x000fe200020006ffULL, 0x2000002bff277230ULL, 0x000fe20000004100ULL,
0x00000008ff157819ULL, 0x000fe40000011615ULL, 0x0000001cff1c723eULL, 0x000fe200020006ffULL,
0x20000024ff2a7230ULL, 0x000fe20000004100ULL, 0x0000001eff1e723eULL, 0x000fc400020006ffULL,
0x00000023ff1d723eULL, 0x000fe200020006ffULL, 0x2000001cff287230ULL, 0x000fe20000004100ULL,
0x00000034ff34723eULL, 0x000fe200020006ffULL, 0x2000001eff1c7230ULL, 0x000fe20000004100ULL,
0x0000002fff35723eULL, 0x000fe200020006ffULL, 0x2000001dff1d7230ULL, 0x000fe20000004100ULL,
0x00000015ff2b723eULL, 0x000fe200020006ffULL, 0x20000034ff2f7230ULL, 0x000fe20000004100ULL,
0x00000010ff147819ULL, 0x000fe20000011614ULL, 0x20000035ff347230ULL, 0x000fe20000004100ULL,
0x00000010ff157819ULL, 0x000fe20000011636ULL, 0x2000002bff2b7230ULL, 0x000fe20000004100ULL,
0x00000010ff297819ULL, 0x000fc40000011629ULL, 0x00000010ff247819ULL, 0x000fe40000011637ULL,
0x00000017ff17723eULL, 0x000fe400020006ffULL, 0x0000105415147816ULL, 0x000fe40000000014ULL,
0x000000ff2d2d7812ULL, 0x000fe200078ec0ffULL, 0x20000017ff177230ULL, 0x000fe20000004100ULL,
0x0000105424157816ULL, 0x000fe40000000029ULL, 0x000000ff18187812ULL, 0x000fc400078ec0ffULL,
0x00000010ff297819ULL, 0x000fe40000011619ULL, 0x00000010ff1c7819ULL, 0x000fe4000001161cULL,
0x00000010ff247819ULL, 0x000fe4000001161dULL, 0x00000010ff197819ULL, 0x000fe4000001162fULL,
0x00000010ff207819ULL, 0x000fe40000011620ULL, 0x00000010ff1d7819ULL, 0x000fc40000011634ULL,
0x0000002dff2d723eULL, 0x000fe400020006ffULL, 0x00000010ff3a7819ULL, 0x000fe4000001163aULL,
0x00000018ff18723eULL, 0x000fe200020006ffULL, 0x2000002dff357230ULL, 0x000fe20000004100ULL,
0x000010541c197816ULL, 0x000fe40000000019ULL, 0x0000003cff1e723eULL, 0x000fe200020006ffULL,
0x20000018ff2d7230ULL, 0x000fe20000004100ULL, 0x0000003dff23723eULL, 0x000fc400020006ffULL,
0x00000039ff39723eULL, 0x000fe200020006ffULL, 0x2000001eff1e7230ULL, 0x000fe20000004100ULL,
0x000010541d1c7816ULL, 0x000fe20000000020ULL, 0x20000023ff237230ULL, 0x000fe20000004100ULL,
0x00000010ff1f7819ULL, 0x000fe2000001161fULL, 0x20000039ff397230ULL, 0x000fe20000004100ULL,
0x00000010ff2e7819ULL, 0x000fe4000001162eULL, 0x00000010ff3d7819ULL, 0x000fe40000011628ULL,
0x0000105429207816ULL, 0x000fc4000000003aULL, 0x00000010ff297819ULL, 0x000fe40000011617ULL,
0x00000010ff287819ULL, 0x000fe40000011621ULL, 0x000010541f217816ULL, 0x000fe4000000002eULL,
0x00000010ff3b7819ULL, 0x000fe4000001163bULL, 0x00000010ff1f7819ULL, 0x000fe4000001161bULL,
0x00000010ff2e7819ULL, 0x000fc40000011625ULL, 0x0000105429287816ULL, 0x000fe40000000028ULL,
0x00000010ff297819ULL, 0x000fe4000001162cULL, 0x00000010ff347819ULL, 0x000fe4000001161aULL,
0x00000010ff2c7819ULL, 0x000fe4000001162dULL, 0x000010543b1d7816ULL, 0x000fe40000000024ULL,
0x000010542e257816ULL, 0x000fc4000000001fULL, 0x00000010ff2d7819ULL, 0x000fe40000011622ULL,
0x00000010ff2a7819ULL, 0x000fe4000001162aULL, 0x00000010ff187819ULL, 0x000fe40000011639ULL,
0x00000010ff247819ULL, 0x000fe40000011616ULL, 0x00000010ff357819ULL, 0x000fe20000011635ULL,
0x000000143014723cULL, 0x000fe200000418ffULL, 0x00000010ff2f7819ULL, 0x000fc4000001161eULL,
0x00000010ff2e7819ULL, 0x000fe40000011623ULL, 0x00000010ff277819ULL, 0x000fe20000011627ULL,
0x0000001c301c723cULL, 0x000fe200000418ffULL, 0x00000010ff367819ULL, 0x000fe40000011626ULL,
0x00000010ff2b7819ULL, 0x000fe4000001162bULL, 0x0000105434297816ULL, 0x000fe20000000029ULL,
0x000000203020723cULL, 0x000fe200000418ffULL, 0x000010542d347816ULL, 0x000fc4000000002aULL,
0x000010543d187816ULL, 0x000fe40000000018ULL, 0x0000105435247816ULL, 0x000fe40000000024ULL,
0x000010542c2c7816ULL, 0x000fe4000000002fULL, 0x00001054272d7816ULL, 0x000fe2000000002eULL,
0x000000183018723cULL, 0x000fe200000418ffULL, 0x0000105436357816ULL, 0x000fca000000002bULL,
0x000000243024723cULL, 0x000fec00000418ffULL, 0x000000283028723cULL, 0x000fec00000418ffULL,
0x0000002c302c723cULL, 0x000fec00000418ffULL, 0x000000343030723cULL, 0x000fe200000418ffULL,
0x013800006734783bULL, 0x0004e20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000102947ULL, 0x000fde0003800000ULL, 0x0000000334347232ULL, 0x08afe40000200000ULL,
0x0000000336367232ULL, 0x000fe40000200000ULL, 0x0000000435357232ULL, 0x080fe40000200000ULL,
0x0000000437377232ULL, 0x000fce0000200000ULL, 0x000000ff3800720cULL, 0x000fe20003f45270ULL,
0x00000bd000007945ULL, 0x000fe20003800000ULL, 0x000000006838783bULL, 0x000f240000004200ULL,
0x000000ff383c7812ULL, 0x010fe400078ec0ffULL, 0x000000ff393e7812ULL, 0x000fe400078ec0ffULL,
0x0000003cff50723eULL, 0x000fe400020006ffULL, 0x00000018ff3d7819ULL, 0x000fc40000011638ULL,
0x00000010ff3c7819ULL, 0x000fe20000011638ULL, 0x20000050ff507230ULL, 0x000fe20000004100ULL,
0x0000003eff51723eULL, 0x000fe400020006ffULL, 0x0000003dff3d723eULL, 0x000fe400020006ffULL,
0x00000018ff3e7819ULL, 0x000fe20000011639ULL, 0x20000051ff517230ULL, 0x000fe20000004100ULL,
0x000000ff3c3c7812ULL, 0x000fe200078ec0ffULL, 0x2000003dff6d7230ULL, 0x000fe20000004100ULL,
0x0000003eff71723eULL, 0x000fc400020006ffULL, 0x0000003cff6c723eULL, 0x000fe400020006ffULL,
0x00000000693c783bULL, 0x000f220000004200ULL, 0x00000010ff707819ULL, 0x000fe40000011639ULL,
0x0000ffff38727812ULL, 0x000fe200078ec0ffULL, 0x20000071ff387230ULL, 0x000fe20000004100ULL,
0x0000ffff39737812ULL, 0x000fe200078ec0ffULL, 0x2000006cff397230ULL, 0x000fe20000004100ULL,
0x000000ff70717812ULL, 0x000fe400078ec0ffULL, 0x00000008ff707819ULL, 0x000fc40000011672ULL,
0x00000008ff727819ULL, 0x000fe40000011673ULL, 0x00000071ff71723eULL, 0x000fe400020006ffULL,
0x00000072ff73723eULL, 0x000fe400020006ffULL, 0x00000070ff6c723eULL, 0x000fe200020006ffULL,
0x20000071ff727230ULL, 0x000fe20000004100ULL, 0x00000010ff507819ULL, 0x000fe20000011650ULL,
0x20000073ff737230ULL, 0x000fe20000004100ULL, 0x00000010ff517819ULL, 0x000fe20000011651ULL,
0x2000006cff717230ULL, 0x000fe20000004100ULL, 0x00000010ff397819ULL, 0x000fc40000011639ULL,
0x00000010ff727819ULL, 0x000fe40000011672ULL, 0x000000ff3b747812ULL, 0x000fe400078ec0ffULL,
0x0000105439507816ULL, 0x000fe40000000050ULL, 0x0000105472517816ULL, 0x000fe40000000051ULL,
0x00000074ff6c723eULL, 0x000fe400020006ffULL, 0x00000010ff747819ULL, 0x000fc40000011638ULL,
0x00000010ff6d7819ULL, 0x000fe2000001166dULL, 0x000000503414723cULL, 0x008fe20000041814ULL,
0x00000010ff387819ULL, 0x000fe20000011671ULL, 0x2000006cff6c7230ULL, 0x000fe20000004100ULL,
0x00000010ff737819ULL, 0x000fe40000011673ULL, 0x000010546d387816ULL, 0x000fe40000000038ULL,
0x0000105474397816ULL, 0x000fe40000000073ULL, 0x000000ff3c507812ULL, 0x010fc400078ec0ffULL,
0x000000ff3a707812ULL, 0x040fe400078ec0ffULL, 0x00000010ff737819ULL, 0x100fe2000001163aULL,
0x000000383418723cULL, 0x000fe20000041818ULL, 0x00000018ff717819ULL, 0x000fe4000001163aULL,
0x0000ffff3a6d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff3a7819ULL, 0x100fe4000001163bULL,
0x00000018ff727819ULL, 0x000fc4000001163bULL, 0x0000ffff3b3b7812ULL, 0x000fe400078ec0ffULL,
0x00000050ff50723eULL, 0x000fe400020006ffULL, 0x000000ff3d517812ULL, 0x000fe400078ec0ffULL,
0x000000ff73737812ULL, 0x000fe200078ec0ffULL, 0x20000050ff397230ULL, 0x000fe20000004100ULL,
0x00000008ff6d7819ULL, 0x000fe4000001166dULL, 0x00000008ff3b7819ULL, 0x000fc4000001163bULL,
0x00000051ff74723eULL, 0x000fe400020006ffULL, 0x00000070ff70723eULL, 0x000fe400020006ffULL,
0x00000073ff51723eULL, 0x000fe200020006ffULL, 0x20000074ff387230ULL, 0x000fe20000004100ULL,
0x000000ff3a3a7812ULL, 0x000fe200078ec0ffULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x0000006dff50723eULL, 0x000fe200020006ffULL, 0x20000051ff517230ULL, 0x000fe20000004100ULL,
0x00000010ff737819ULL, 0x000fc4000001163cULL, 0x0000003bff6d723eULL, 0x000fe200020006ffULL,
0x20000050ff507230ULL, 0x000fe20000004100ULL, 0x00000010ff3b7819ULL, 0x000fe4000001163dULL,
0x0000003aff3a723eULL, 0x000fe400020006ffULL, 0x000000ff73737812ULL, 0x000fe400078ec0ffULL,
0x000000ff3b757812ULL, 0x000fe200078ec0ffULL, 0x2000003aff747230ULL, 0x000fe20000004100ULL,
0x00000071ff71723eULL, 0x000fc400020006ffULL, 0x00000073ff73723eULL, 0x000fe400020006ffULL,
0x00000010ff3a7819ULL, 0x000fe20000011670ULL, 0x20000071ff717230ULL, 0x000fe20000004100ULL,
0x00000010ff517819ULL, 0x000fe20000011651ULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x00000075ff75723eULL, 0x000fe400020006ffULL, 0x00000010ff3b7819ULL, 0x000fe4000001166cULL,
0x00000018ff6c7819ULL, 0x000fe2000001163cULL, 0x20000075ff757230ULL, 0x000fe20000004100ULL,
0x00000018ff707819ULL, 0x000fc4000001163dULL, 0x00000072ff72723eULL, 0x000fe400020006ffULL,
0x00001054513a7816ULL, 0x000fe2000000003aULL, 0x2000006dff517230ULL, 0x000fe20000004100ULL,
0x00000010ff747819ULL, 0x000fe20000011674ULL, 0x20000072ff727230ULL, 0x000fe20000004100ULL,
0x0000006cff6d723eULL, 0x000fe400020006ffULL, 0x00000070ff6c723eULL, 0x000fe400020006ffULL,
0x00000010ff707819ULL, 0x000fe20000011638ULL, 0x2000006dff6d7230ULL, 0x000fe20000004100ULL,
0x00000010ff717819ULL, 0x000fe20000011671ULL, 0x2000006cff6c7230ULL, 0x000fe20000004100ULL,
0x00000010ff397819ULL, 0x000fc40000011639ULL, 0x00000010ff507819ULL, 0x000fe40000011650ULL,
0x00000010ff387819ULL, 0x000fe40000011673ULL, 0x00001054743b7816ULL, 0x000fe4000000003bULL,
0x00000010ff757819ULL, 0x000fe40000011675ULL, 0x0000105471507816ULL, 0x000fe40000000050ULL,
0x0000105438387816ULL, 0x000fe20000000039ULL, 0x0000003a341c723cULL, 0x000fe2000004181cULL,
0x00000010ff727819ULL, 0x000fc40000011672ULL, 0x00000010ff517819ULL, 0x000fe40000011651ULL,
0x0000105475397816ULL, 0x000fe40000000070ULL, 0x000000ff3f717812ULL, 0x000fe400078ec0ffULL,
0x0000ffff3c757812ULL, 0x000fe400078ec0ffULL, 0x0000105472517816ULL, 0x000fe20000000051ULL,
0x000000383424723cULL, 0x000fe20000041824ULL, 0x000000ff3e3b7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff3a7819ULL, 0x000fe4000001163eULL, 0x00000071ff74723eULL, 0x000fe200020006ffULL,
0x000000503420723cULL, 0x000fe20000041820ULL, 0x00000018ff727819ULL, 0x000fe4000001163fULL,
0x00000008ff717819ULL, 0x000fe40000011675ULL, 0x0000ffff3d3c7812ULL, 0x000fe400078ec0ffULL,
0x0000003bff3b723eULL, 0x000fc400020006ffULL, 0x0000003aff73723eULL, 0x000fe400020006ffULL,
0x00000072ff75723eULL, 0x000fe200020006ffULL, 0x2000003bff3a7230ULL, 0x000fe20000004100ULL,
0x00000071ff71723eULL, 0x000fe200020006ffULL, 0x20000074ff3b7230ULL, 0x000fe20000004100ULL,
0x00000010ff3d7819ULL, 0x000fe4000001163eULL, 0x00000008ff727819ULL, 0x000fe2000001163cULL,
0x20000073ff3c7230ULL, 0x000fe20000004100ULL, 0x00000010ff707819ULL, 0x000fe2000001163fULL,
0x20000071ff717230ULL, 0x000fe20000004100ULL, 0x0000ffff3e3e7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff3f3f7812ULL, 0x000fe400078ec0ffULL, 0x000000ff3d737812ULL, 0x000fe200078ec0ffULL,
0x20000075ff3d7230ULL, 0x000fe20000004100ULL, 0x00000072ff72723eULL, 0x000fe400020006ffULL,
0x000000ff70747812ULL, 0x000fe400078ec0ffULL, 0x00000008ff707819ULL, 0x000fe2000001163eULL,
0x20000072ff727230ULL, 0x000fe20000004100ULL, 0x00000008ff757819ULL, 0x000fc4000001163fULL,
0x00000010ff3f7819ULL, 0x000fe4000001166dULL, 0x00000010ff3e7819ULL, 0x000fe40000011671ULL,
0x00000073ff73723eULL, 0x000fe400020006ffULL, 0x00000074ff74723eULL, 0x000fe400020006ffULL,
0x00000070ff70723eULL, 0x000fe200020006ffULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x00000075ff75723eULL, 0x000fe200020006ffULL, 0x20000074ff6d7230ULL, 0x000fe20000004100ULL,
0x000010543f3e7816ULL, 0x000fe2000000003eULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x00000010ff6c7819ULL, 0x000fe2000001166cULL, 0x20000075ff757230ULL, 0x000fe20000004100ULL,
0x00000010ff3f7819ULL, 0x000fc40000011672ULL, 0x00000010ff517819ULL, 0x000fe4000001163cULL,
0x000010546c3f7816ULL, 0x000fe4000000003fULL, 0x00000010ff6c7819ULL, 0x000fe4000001163dULL,
0x00000010ff3a7819ULL, 0x000fe4000001163aULL, 0x00000010ff737819ULL, 0x000fe20000011673ULL,
0x0000003e3428723cULL, 0x000fe20000041828ULL, 0x00000010ff3b7819ULL, 0x000fc4000001163bULL,
0x00000010ff507819ULL, 0x000fe4000001166dULL, 0x00000010ff3c7819ULL, 0x000fe40000011670ULL,
0x00000010ff3d7819ULL, 0x000fe40000011675ULL, 0x00001054733a7816ULL, 0x000fe4000000003aULL,
0x00001054503b7816ULL, 0x000fe4000000003bULL, 0x00001054513c7816ULL, 0x000fc4000000003cULL,
0x000010546c3d7816ULL, 0x000fc6000000003dULL, 0x0000003a342c723cULL, 0x000fec000004182cULL,
0x0000003c3430723cULL, 0x000fe20000041830ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000403947ULL, 0x000fde0001000000ULL, 0x000000140b0b7221ULL, 0x000fe20000010000ULL,
0x000000150c0c7221ULL, 0x000fe20000010000ULL, 0x000000180f0f7221ULL, 0x000fe20000010000ULL,
0x0000001910107221ULL, 0x000fe20000010000ULL, 0x0000001c41417221ULL, 0x000fe20000010000ULL,
0x0000001d42427221ULL, 0x000fe20000010000ULL, 0x0000002045457221ULL, 0x000fe20000010000ULL,
0x0000002146467221ULL, 0x000fe20000010000ULL, 0x0000002449497221ULL, 0x000fe20000010000ULL,
0x000000254a4a7221ULL, 0x000fe20000010000ULL, 0x000000284d4d7221ULL, 0x000fe20000010000ULL,
0x000000294e4e7221ULL, 0x000fe20000010000ULL, 0x0000002c53537221ULL, 0x000fe20000010000ULL,
0x0000002d54547221ULL, 0x000fe20000010000ULL, 0x0000003057577221ULL, 0x000fe20000010000ULL,
0x0000003158587221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x000000ffff157224ULL, 0x002fc600078e006fULL,
0x0000000000404947ULL, 0x000fea0002800000ULL, 0x000000160d0d7221ULL, 0x000fe20000010000ULL,
0x000000170e0e7221ULL, 0x000fe20000010000ULL, 0x0000001a11117221ULL, 0x000fe20000010000ULL,
0x0000001b40407221ULL, 0x000fe20000010000ULL, 0x0000001e43437221ULL, 0x000fe20000010000ULL,
0x0000001f44447221ULL, 0x000fe20000010000ULL, 0x0000002247477221ULL, 0x000fe20000010000ULL,
0x0000002348487221ULL, 0x000fe20000010000ULL, 0x000000264b4b7221ULL, 0x000fe20000010000ULL,
0x000000274c4c7221ULL, 0x000fe20000010000ULL, 0x0000002a4f4f7221ULL, 0x000fe20000010000ULL,
0x0000002b52527221ULL, 0x000fe20000010000ULL, 0x0000002e55557221ULL, 0x000fe20000010000ULL,
0x0000002f56567221ULL, 0x000fe20000010000ULL, 0x0000003259597221ULL, 0x000fe20000010000ULL,
0x000000335a5a7221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001ff147424ULL, 0x000fe400078e00ffULL, 0x000000016b6b7836ULL, 0x000fe40000000000ULL,
0x018b8814ff1679a7ULL, 0x000e660008500007ULL, 0x0000006a6b00720cULL, 0x000fe20003f46070ULL,
0x000000ffff1c7224ULL, 0x002fd800078e0017ULL, 0xffffffa0006ca947ULL, 0x000fea000383ffffULL,
0x018b7014ffff79a7ULL, 0x0003e40008500007ULL, 0x0000000108087836ULL, 0x000fca0000000000ULL,
0x0000000c08007c0cULL, 0x000fda000bf06070ULL, 0xfffffe8000648947ULL, 0x000fea000383ffffULL,
0x0000000cff007c0cULL, 0x000fe2000bf05270ULL, 0x000000ffff127224ULL, 0x000fe400078e0011ULL,
0x000000ffff117224ULL, 0x000fe400078e0010ULL, 0x000000ffff107224ULL, 0x000fe400078e000eULL,
0x000000ffff097224ULL, 0x000fcc00078e000cULL, 0x0000000000d48947ULL, 0x000fea0003800000ULL,
0x018000000a007836ULL, 0x000fe20000000000ULL, 0x000000b000007945ULL, 0x000fe80003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x00000000000c0947ULL, 0x000fea0003800000ULL, 0x00019c1000047802ULL, 0x002fce0000000f00ULL,
0x0000009000507944ULL, 0x004fea0003c00000ULL, 0x0000000000107947ULL, 0x000fea0003800000ULL,
0x0000000a00037308ULL, 0x004ea40000001000ULL, 0xbf80000003007423ULL, 0x004fc8000000000aULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003007223ULL, 0x000fce0000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009a00ff027b82ULL, 0x000f240000000a00ULL,
0x0000000a02037981ULL, 0x010f22000c1e9900ULL, 0x0000000000057919ULL, 0x002e640000000000ULL,
0x00000002ff077819ULL, 0x002fe40000011605ULL, 0x0000000805057811ULL, 0x000fe200078ff0ffULL,
0x0000000003007220ULL, 0x01cfca0000410000ULL, 0x00001f0700047589ULL, 0x000e6800000e0000ULL,
0x00001f0500057589ULL, 0x000ea200000e0000ULL, 0x0000000b040b7220ULL, 0x042fe20000410000ULL,
0x0000000904097220ULL, 0x040fe20000410000ULL, 0x0000000f040f7220ULL, 0x040fe20000410000ULL,
0x0000001104117220ULL, 0x040fe20000410000ULL, 0x0000004104417220ULL, 0x040fe20000410000ULL,
0x0000004204427220ULL, 0x040fe20000410000ULL, 0x0000004504457220ULL, 0x040fe20000410000ULL,
0x0000004604467220ULL, 0x040fe20000410000ULL, 0x0000004904497220ULL, 0x040fe20000410000ULL,
0x0000004a044a7220ULL, 0x040fe20000410000ULL, 0x0000004d044d7220ULL, 0x040fe20000410000ULL,
0x0000004e044e7220ULL, 0x040fe20000410000ULL, 0x0000005304537220ULL, 0x040fe20000410000ULL,
0x0000005404547220ULL, 0x040fe20000410000ULL, 0x0000005704577220ULL, 0x040fe20000410000ULL,
0x0000005804587220ULL, 0x000fe20000410000ULL, 0x0000000d050d7220ULL, 0x044fe20000410000ULL,
0x0000001005107220ULL, 0x040fe20000410000ULL, 0x0000001205127220ULL, 0x040fe20000410000ULL,
0x0000004005407220ULL, 0x040fe20000410000ULL, 0x0000004305437220ULL, 0x040fe20000410000ULL,
0x0000004405447220ULL, 0x040fe20000410000ULL, 0x0000004705477220ULL, 0x040fe20000410000ULL,
0x0000004805487220ULL, 0x040fe20000410000ULL, 0x0000004b054b7220ULL, 0x040fe20000410000ULL,
0x0000004c054c7220ULL, 0x040fe20000410000ULL, 0x0000004f054f7220ULL, 0x040fe20000410000ULL,
0x0000005205527220ULL, 0x040fe20000410000ULL, 0x0000005505557220ULL, 0x040fe20000410000ULL,
0x0000005605567220ULL, 0x040fe20000410000ULL, 0x0000005905597220ULL, 0x040fe20000410000ULL,
0x0000005a055a7220ULL, 0x000fce0000410000ULL, 0x0000000000147919ULL, 0x002e620000000000ULL,
0x0000000761617c11ULL, 0x000fe2000f8e58ffULL, 0x00000000000479c3ULL, 0x000ee20000002600ULL,
0x0000004d4e4d723eULL, 0x000fce00000010ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000535453723eULL, 0x000fe400000010ffULL, 0x000000575857723eULL, 0x000fe400000010ffULL,
0x000000434443723eULL, 0x000fc400000010ffULL, 0x000000474847723eULL, 0x000fe400000010ffULL,
0x0000004b4c4b723eULL, 0x000fe400000010ffULL, 0x0000004f524f723eULL, 0x000fe400000010ffULL,
0x000000555655723eULL, 0x000fe400000010ffULL, 0x000000595a59723eULL, 0x000fe400000010ffULL,
0x000054104b4e7816ULL, 0x000fc4000000004fULL, 0x000076324b4f7816ULL, 0x000fe4000000004fULL,
0x0000541055587816ULL, 0x100fe40000000059ULL, 0x00000002ff077819ULL, 0x002fe40000011614ULL,
0x0000000214007812ULL, 0x040fe400078ec0ffULL, 0x0000000814057811ULL, 0x000fe200078ff0ffULL,
0x0000000807157824ULL, 0x040fe200078e00ffULL, 0x0000000700027211ULL, 0x044fe200078ff8ffULL,
0x0000000807087824ULL, 0x000fe200078e00ffULL, 0x0000000500037211ULL, 0x000fe200078ff8ffULL,
0x00000008050c7824ULL, 0x000fe200078e00ffULL, 0x0000763255597816ULL, 0x000fe20000000059ULL,
0x0000000807057824ULL, 0x000fc400078e00ffULL, 0x0000000202007836ULL, 0x000fe20000000000ULL,
0xfffffff80c0c7812ULL, 0x000fe200078ee203ULL, 0x0000000402037836ULL, 0x000fe40000000000ULL,
0x0000000807077824ULL, 0x000fe200078e00ffULL, 0xfffffff805067812ULL, 0x000fe400078ee200ULL,
0x00000003ff057819ULL, 0x100fe40000011614ULL, 0xfffffff815007812ULL, 0x000fe200078ee202ULL,
0x0000000602027836ULL, 0x000fe20000000000ULL, 0xfffffff808087812ULL, 0x000fe200078ee203ULL,
0x0000000105047824ULL, 0x000fc400078e0214ULL, 0x0001200061037836ULL, 0x000fe20000000000ULL,
0xfffffff8070a7812ULL, 0x000fe200078ee202ULL, 0x0000000814027824ULL, 0x000fe200078e00ffULL,
0x0000000704077812ULL, 0x000fe200078ec0ffULL, 0x0000001000047824ULL, 0x100fe400078e0203ULL,
0x000000100c0c7824ULL, 0x100fe200078e0203ULL, 0x0ffffff807007812ULL, 0x000fe200078ef814ULL,
0x0000001006067824ULL, 0x100fe200078e0203ULL, 0x0000000714147812ULL, 0x000fe200078ec0ffULL,
0x0000001008087824ULL, 0x000fc400078e0203ULL, 0x000000100a0a7824ULL, 0x000fe200078e0203ULL,
0x0000000802037812ULL, 0x000fe200078ec0ffULL, 0x0000001000617824ULL, 0x000fe200078e0261ULL,
0x0000000b0900723eULL, 0x000fe400000010ffULL, 0x0000000f1102723eULL, 0x000fe200000010ffULL,
0x0000000104047824ULL, 0x000fe200078e0203ULL, 0x1ffffff8145d7812ULL, 0x000fe200078ef85dULL,
0x0000000103067824ULL, 0x040fe200078e0206ULL, 0x00005410000e7816ULL, 0x040fe20000000002ULL,
0x00000001030c7824ULL, 0x040fe200078e020cULL, 0x00007632000f7816ULL, 0x000fe20000000002ULL,
0x0000000103087824ULL, 0x040fe200078e0208ULL, 0x000000414200723eULL, 0x000fe200000010ffULL,
0x00000001030a7824ULL, 0x000fe200078e020aULL, 0x000000454602723eULL, 0x000fe200000010ffULL,
0x0000000e04007388ULL, 0x0003e20000000a00ULL, 0x000000494a03723eULL, 0x000fc400000010ffULL,
0x0000541043467816ULL, 0x140fe40000000047ULL, 0x0000763243477816ULL, 0x000fe40000000047ULL,
0x00005410000e7816ULL, 0x142fe40000000002ULL, 0x00007632000f7816ULL, 0x000fe40000000002ULL,
0x0000000d1000723eULL, 0x000fe400000010ffULL, 0x000000124002723eULL, 0x000fe200000010ffULL,
0x0000000e06007388ULL, 0x0003e40000000a00ULL, 0x00005410030e7816ULL, 0x002fc4000000004dULL,
0x00007632030f7816ULL, 0x000fca000000004dULL, 0x0000000e08007388ULL, 0x0003e40000000a00ULL,
0x00005410530e7816ULL, 0x142fe40000000057ULL, 0x00007632530f7816ULL, 0x000fca0000000057ULL,
0x0000000e0a007388ULL, 0x0003e40000000a00ULL, 0x00005410000e7816ULL, 0x142fe40000000002ULL,
0x00007632000f7816ULL, 0x000fe40000000002ULL, 0x00008400ff007b82ULL, 0x000e660000000800ULL,
0x0000000e0c007388ULL, 0x000fe80000000a00ULL, 0x0004004606007388ULL, 0x000fe80000000a00ULL,
0x0004004e08007388ULL, 0x000fe80000000a00ULL, 0x000400580a007388ULL, 0x000fe20000000a00ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x01200000610c7984ULL, 0x000ea20000000c00ULL,
0x0000000013137224ULL, 0x082fe400078e02ffULL, 0x0000000405007e24ULL, 0x008fe2000f8e0200ULL,
0x0000860000047ab9ULL, 0x000fc80000000a00ULL, 0x0000000013007211ULL, 0x000fca00078010ffULL,
0x000000ffff037224ULL, 0x000fe200000e06ffULL, 0x0000000400027c11ULL, 0x000fc8000f8048ffULL,
0x0000000500037c11ULL, 0x000fc600080f4c03ULL, 0x000000105d027825ULL, 0x000fca00078e0002ULL,
0x0000000c02007986ULL, 0x004fe2000c101d0aULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x000000030200780cULL, 0x040fe20003f44070ULL, 0x00009400ff037b82ULL, 0x000e620000000800ULL,
0x0000004061477824ULL, 0x040fe200078e00ffULL, 0x00000001ff437819ULL, 0x000fe20000011661ULL,
0x0000002002047836ULL, 0x000fe20000000000ULL, 0x0000000761457c11ULL, 0x000fe2000f8e40ffULL,
0x0000000147067824ULL, 0x040fe400078e0202ULL, 0x0000000147057824ULL, 0x000fe200078e0204ULL,
0x00009200ff087b82ULL, 0x000ea20000000a00ULL, 0x00000004020f7824ULL, 0x000fe200078e0245ULL,
0x0000000906007c0cULL, 0x000fc4000bf06070ULL, 0x0000000905007c0cULL, 0x000fe2000bf26070ULL,
0x000000041305a824ULL, 0x000fe200078e0202ULL, 0x000000054300ac0cULL, 0x000fe4000bf66070ULL,
0x00009000ff0eab82ULL, 0x000ef00000000800ULL, 0x00008c00ff0aab82ULL, 0x000f220000000a00ULL,
0x000000035c037224ULL, 0x002fc800078e0247ULL, 0x0000000103077824ULL, 0x040fe400078e0202ULL,
0x0000000103037824ULL, 0x000fe200078e0204ULL, 0x00009a00ff0c7b82ULL, 0x000e620000000a00ULL,
0x000000020504a824ULL, 0x000fe200078e00ffULL, 0x000000076105ac11ULL, 0x000fe2000f8e20ffULL,
0x0000000407067825ULL, 0x004fc800078e0008ULL, 0x0000000403087825ULL, 0x000fc800078e0008ULL,
0x0000000e0403a224ULL, 0x008fe400078e0243ULL, 0x00000001ff047424ULL, 0x000fe400078e00ffULL,
0x000000040211a824ULL, 0x000fe400078e0205ULL, 0x00000004030aa825ULL, 0x010fe400078e000aULL,
0x018ad004ff0479a7ULL, 0x000ea20008500007ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x18600000060f7faeULL, 0x0007e8000c12184aULL, 0x18680000080f7faeULL, 0x0007e8000c92184aULL,
0x18a800000a11afaeULL, 0x0007e8000d92184aULL, 0x00000000000079afULL, 0x000e280000000000ULL,
0x0000000a0c037981ULL, 0x002722000c1e9900ULL, 0x000001ff0800788cULL, 0x000fe2000bf04070ULL,
0x0000008000007824ULL, 0x000fe200078e00ffULL, 0x0000000706067899ULL, 0x000fc8000800063fULL,
0x000000000000781cULL, 0x000fe40003f0f008ULL, 0x0000004000047812ULL, 0x004fe200078ef847ULL,
0x000080000000791aULL, 0x000fc80000000000ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000001000a40947ULL, 0x008fea0003800000ULL, 0x00000003ff097819ULL, 0x100fe40000011602ULL,
0x0000000761087c11ULL, 0x000fe4000f8e20ffULL, 0x00000009470e7c48ULL, 0x000fe2000ffe0000ULL,
0x00000004090a7824ULL, 0x040fe400078e0245ULL, 0x00000001040c7824ULL, 0x000fe400078e0209ULL,
0x00000001090f7824ULL, 0x000fe200078e0202ULL, 0x018600000a077984ULL, 0x000e620000000800ULL,
0x000000010e0e7824ULL, 0x000fc600078e0a47ULL, 0x000000070f0f7812ULL, 0x000fe400078ec0ffULL,
0x0000000e0900720cULL, 0x000fe20003f06070ULL, 0x00000004070d7824ULL, 0x002fe400078e0208ULL,
0x00008a00ff067b82ULL, 0x000e660000000a00ULL, 0x018a80000d0b7984ULL, 0x0004e40000000800ULL,
0x0ffffff80f0d7812ULL, 0x004fe200078ef802ULL, 0x000000060b117c24ULL, 0x008fe2000f8e020cULL,
0x00000070100b7812ULL, 0x000fc400078ec0ffULL, 0x00000007610c7c11ULL, 0x000fe2000f8e70ffULL,
0x0000010011107825ULL, 0x002fc800078e0006ULL, 0x000020000c0c7836ULL, 0x000fe20000000000ULL,
0x000000100b147210ULL, 0x000fc60007f3e0ffULL, 0x000000100d0d7824ULL, 0x000fe400078e020cULL,
0x000000ffff157224ULL, 0x000fca00008e0611ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000140d7faeULL, 0x0003e8000c101c4aULL, 0x018610000a0f7984ULL, 0x000ea40000000800ULL,
0x000000040f167824ULL, 0x004fe400078e0208ULL, 0x00000004090f7836ULL, 0x000fc60000000000ULL,
0x018a800016107984ULL, 0x000ea20000000800ULL, 0x0000000104117824ULL, 0x000fe200078e020fULL,
0x0000000e0f00720cULL, 0x040fe20003f06070ULL, 0x000000010f127824ULL, 0x040fe400078e0202ULL,
0x000000080f0f7824ULL, 0x000fca00078e00ffULL, 0xfffffff80f0d7812ULL, 0x002fca00078ee212ULL,
0x000000100d0d7824ULL, 0x000fe400078e020cULL, 0x0000000610117c24ULL, 0x004fc8000f8e0211ULL,
0x0000010011107825ULL, 0x000fc600078e0006ULL, 0x000000100b147210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff157224ULL, 0x000fca00008e0611ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000140d7faeULL, 0x0003e8000c101c4aULL, 0x018620000a0f7984ULL, 0x000ea40000000800ULL,
0x000000040f167824ULL, 0x004fe400078e0208ULL, 0x00000008090f7836ULL, 0x000fc60000000000ULL,
0x018a800016107984ULL, 0x000ea20000000800ULL, 0x0000000104117824ULL, 0x000fe200078e020fULL,
0x0000000e0f00720cULL, 0x040fe20003f06070ULL, 0x000000010f127824ULL, 0x040fe400078e0202ULL,
0x000000080f0f7824ULL, 0x000fca00078e00ffULL, 0xfffffff80f0d7812ULL, 0x002fca00078ee212ULL,
0x000000100d0d7824ULL, 0x000fe400078e020cULL, 0x0000000610117c24ULL, 0x004fc8000f8e0211ULL,
0x0000010011107825ULL, 0x000fc600078e0006ULL, 0x000000100b147210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff157224ULL, 0x000fca00008e0611ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000140d7faeULL, 0x0003e8000c101c4aULL, 0x018630000a0f7984ULL, 0x000ea40000000800ULL,
0x000000040f167824ULL, 0x004fe400078e0208ULL, 0x0000000c090f7836ULL, 0x000fc60000000000ULL,
0x018a800016107984ULL, 0x000ea20000000800ULL, 0x0000000104117824ULL, 0x000fe200078e020fULL,
0x0000000e0f00720cULL, 0x040fe20003f06070ULL, 0x000000010f127824ULL, 0x040fe400078e0202ULL,
0x000000080f0f7824ULL, 0x000fca00078e00ffULL, 0xfffffff80f0d7812ULL, 0x002fca00078ee212ULL,
0x000000100d0d7824ULL, 0x000fe400078e020cULL, 0x0000000610117c24ULL, 0x004fc8000f8e0211ULL,
0x0000010011107825ULL, 0x000fc600078e0006ULL, 0x000000100b147210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff157224ULL, 0x000fca00008e0611ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000140d7faeULL, 0x0003e8000c101c4aULL, 0x018640000a0f7984ULL, 0x000ea40000000800ULL,
0x000000040f167824ULL, 0x004fe400078e0208ULL, 0x00000010090f7836ULL, 0x000fc60000000000ULL,
0x018a800016107984ULL, 0x000ea20000000800ULL, 0x0000000104117824ULL, 0x000fe200078e020fULL,
0x0000000e0f00720cULL, 0x040fe20003f06070ULL, 0x000000010f127824ULL, 0x040fe400078e0202ULL,
0x000000080f0f7824ULL, 0x000fca00078e00ffULL, 0xfffffff80f0d7812ULL, 0x002fca00078ee212ULL,
0x000000100d0d7824ULL, 0x000fe400078e020cULL, 0x0000000610117c24ULL, 0x004fc8000f8e0211ULL,
0x0000010011107825ULL, 0x000fc600078e0006ULL, 0x000000100b147210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff157224ULL, 0x000fca00008e0611ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000140d7faeULL, 0x0003e8000c101c4aULL, 0x018650000a0f7984ULL, 0x000ea40000000800ULL,
0x000000040f167824ULL, 0x004fe400078e0208ULL, 0x00000014090f7836ULL, 0x000fc60000000000ULL,
0x018a800016107984ULL, 0x000ea20000000800ULL, 0x0000000104117824ULL, 0x000fe200078e020fULL,
0x0000000e0f00720cULL, 0x040fe20003f06070ULL, 0x000000010f127824ULL, 0x040fe400078e0202ULL,
0x000000080f0f7824ULL, 0x000fca00078e00ffULL, 0xfffffff80f0d7812ULL, 0x002fca00078ee212ULL,
0x000000100d0d7824ULL, 0x000fe400078e020cULL, 0x0000000610117c24ULL, 0x004fc8000f8e0211ULL,
0x0000010011107825ULL, 0x000fc600078e0006ULL, 0x000000100b147210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff157224ULL, 0x000fca00008e0611ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000140d7faeULL, 0x0003e8000c101c4aULL, 0x018660000a0f7984ULL, 0x000ea40000000800ULL,
0x000000040f167824ULL, 0x004fe400078e0208ULL, 0x00000018090f7836ULL, 0x000fc60000000000ULL,
0x018a800016107984ULL, 0x000ea20000000800ULL, 0x0000000104117824ULL, 0x000fe200078e020fULL,
0x0000000e0f00720cULL, 0x040fe20003f06070ULL, 0x000000010f127824ULL, 0x040fe400078e0202ULL,
0x000000080f0f7824ULL, 0x000fca00078e00ffULL, 0xfffffff80f0d7812ULL, 0x002fca00078ee212ULL,
0x000000100d0d7824ULL, 0x000fe400078e020cULL, 0x0000000610117c24ULL, 0x004fc8000f8e0211ULL,
0x0000010011107825ULL, 0x000fc600078e0006ULL, 0x000000100b147210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff157224ULL, 0x000fca00008e0611ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000140d7faeULL, 0x0003e8000c101c4aULL, 0x018670000a0f7984ULL, 0x000ea40000000800ULL,
0x000000040f167824ULL, 0x004fe400078e0208ULL, 0x0000001c090f7836ULL, 0x000fc60000000000ULL,
0x018a800016107984ULL, 0x000ea20000000800ULL, 0x0000000104117824ULL, 0x000fe200078e020fULL,
0x0000000e0f00720cULL, 0x040fe20003f06070ULL, 0x000000010f127824ULL, 0x040fe400078e0202ULL,
0x000000080f0f7824ULL, 0x000fca00078e00ffULL, 0xfffffff80f0d7812ULL, 0x002fca00078ee212ULL,
0x000000100d0d7824ULL, 0x000fe400078e020cULL, 0x0000000610117c24ULL, 0x004fc8000f8e0211ULL,
0x0000010011107825ULL, 0x000fc600078e0006ULL, 0x000000100b147210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff157224ULL, 0x000fca00008e0611ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000140d7faeULL, 0x0003e8000c101c4aULL, 0x018680000a0f7984ULL, 0x000ea40000000800ULL,
0x000000040f167824ULL, 0x004fe400078e0208ULL, 0x00000020090f7836ULL, 0x000fc60000000000ULL,
0x018a800016107984ULL, 0x000ea20000000800ULL, 0x0000000104117824ULL, 0x000fe200078e020fULL,
0x0000000e0f00720cULL, 0x040fe20003f06070ULL, 0x000000010f127824ULL, 0x040fe400078e0202ULL,
0x000000080f0f7824ULL, 0x000fca00078e00ffULL, 0xfffffff80f0d7812ULL, 0x002fca00078ee212ULL,
0x000000100d0d7824ULL, 0x000fe400078e020cULL, 0x0000000610117c24ULL, 0x004fc8000f8e0211ULL,
0x0000010011107825ULL, 0x000fc600078e0006ULL, 0x000000100b147210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff157224ULL, 0x000fca00008e0611ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000140d7faeULL, 0x0003e8000c101c4aULL, 0x018690000a0f7984ULL, 0x000ea40000000800ULL,
0x000000040f167824ULL, 0x004fe400078e0208ULL, 0x00000024090f7836ULL, 0x000fc60000000000ULL,
0x018a800016107984ULL, 0x000ea20000000800ULL, 0x0000000104117824ULL, 0x000fe200078e020fULL,
0x0000000e0f00720cULL, 0x040fe20003f06070ULL, 0x000000010f127824ULL, 0x040fe400078e0202ULL,
0x000000080f0f7824ULL, 0x000fca00078e00ffULL, 0xfffffff80f0d7812ULL, 0x002fca00078ee212ULL,
0x000000100d0d7824ULL, 0x000fe400078e020cULL, 0x0000000610117c24ULL, 0x004fc8000f8e0211ULL,
0x0000010011107825ULL, 0x000fc600078e0006ULL, 0x000000100b147210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff157224ULL, 0x000fca00008e0611ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000140d7faeULL, 0x0003e8000c101c4aULL, 0x0186a0000a0f7984ULL, 0x000ea40000000800ULL,
0x000000040f167824ULL, 0x004fe400078e0208ULL, 0x00000028090f7836ULL, 0x000fc60000000000ULL,
0x018a800016107984ULL, 0x000ea20000000800ULL, 0x0000000104117824ULL, 0x000fe200078e020fULL,
0x0000000e0f00720cULL, 0x040fe20003f06070ULL, 0x000000010f127824ULL, 0x040fe400078e0202ULL,
0x000000080f0f7824ULL, 0x000fca00078e00ffULL, 0xfffffff80f0d7812ULL, 0x002fca00078ee212ULL,
0x000000100d0d7824ULL, 0x000fe400078e020cULL, 0x0000000610117c24ULL, 0x004fc8000f8e0211ULL,
0x0000010011107825ULL, 0x000fc600078e0006ULL, 0x000000100b147210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff157224ULL, 0x000fca00008e0611ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000140d7faeULL, 0x0003e8000c101c4aULL, 0x0186b0000a0f7984ULL, 0x000ea40000000800ULL,
0x000000040f167824ULL, 0x004fe400078e0208ULL, 0x0000002c090f7836ULL, 0x000fc60000000000ULL,
0x018a800016107984ULL, 0x000ea20000000800ULL, 0x0000000104117824ULL, 0x000fe200078e020fULL,
0x0000000e0f00720cULL, 0x040fe20003f06070ULL, 0x000000010f127824ULL, 0x040fe400078e0202ULL,
0x000000080f0f7824ULL, 0x000fca00078e00ffULL, 0xfffffff80f0d7812ULL, 0x002fca00078ee212ULL,
0x000000100d0d7824ULL, 0x000fe400078e020cULL, 0x0000000610117c24ULL, 0x004fc8000f8e0211ULL,
0x0000010011107825ULL, 0x000fc600078e0006ULL, 0x000000100b147210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff157224ULL, 0x000fca00008e0611ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000140d7faeULL, 0x0003e8000c101c4aULL, 0x0186c0000a0f7984ULL, 0x000ea40000000800ULL,
0x000000040f167824ULL, 0x004fe400078e0208ULL, 0x00000030090f7836ULL, 0x000fc60000000000ULL,
0x018a800016107984ULL, 0x000ea20000000800ULL, 0x0000000104117824ULL, 0x000fe200078e020fULL,
0x0000000e0f00720cULL, 0x040fe20003f06070ULL, 0x000000010f127824ULL, 0x040fe400078e0202ULL,
0x000000080f0f7824ULL, 0x000fca00078e00ffULL, 0xfffffff80f0d7812ULL, 0x002fca00078ee212ULL,
0x000000100d0d7824ULL, 0x000fe400078e020cULL, 0x0000000610117c24ULL, 0x004fc8000f8e0211ULL,
0x0000010011107825ULL, 0x000fc600078e0006ULL, 0x000000100b147210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff157224ULL, 0x000fca00008e0611ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000140d7faeULL, 0x0003e8000c101c4aULL, 0x0186d0000a0f7984ULL, 0x000ea40000000800ULL,
0x000000040f167824ULL, 0x004fe400078e0208ULL, 0x00000034090f7836ULL, 0x000fc60000000000ULL,
0x018a800016107984ULL, 0x000ea20000000800ULL, 0x0000000104117824ULL, 0x000fe200078e020fULL,
0x0000000e0f00720cULL, 0x040fe20003f06070ULL, 0x000000010f127824ULL, 0x040fe400078e0202ULL,
0x000000080f0f7824ULL, 0x000fca00078e00ffULL, 0xfffffff80f0d7812ULL, 0x002fca00078ee212ULL,
0x000000100d0d7824ULL, 0x000fe400078e020cULL, 0x0000000610117c24ULL, 0x004fc8000f8e0211ULL,
0x0000010011107825ULL, 0x000fc600078e0006ULL, 0x000000100b147210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff157224ULL, 0x000fca00008e0611ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000140d7faeULL, 0x0003e8000c101c4aULL, 0x0186e0000a0f7984ULL, 0x000ea40000000800ULL,
0x000000040f167824ULL, 0x004fe400078e0208ULL, 0x00000038090f7836ULL, 0x000fe40000000000ULL,
0x0000003c09097836ULL, 0x000fe20000000000ULL, 0x018a800016107984ULL, 0x000ea20000000800ULL,
0x0000000104117824ULL, 0x000fe200078e020fULL, 0x0000000e0f00720cULL, 0x040fe20003f06070ULL,
0x000000010f127824ULL, 0x000fc400078e0202ULL, 0x000000080f0f7824ULL, 0x000fe400078e00ffULL,
0x0000000109027824ULL, 0x000fc600078e0202ULL, 0xfffffff80f0d7812ULL, 0x002fca00078ee212ULL,
0x000000100d0d7824ULL, 0x000fe400078e020cULL, 0x0000000610117c24ULL, 0x004fc8000f8e0211ULL,
0x0000010011107825ULL, 0x000fc600078e0006ULL, 0x000000100b107210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff117224ULL, 0x000fca00008e0611ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000100d7faeULL, 0x0003e2000c101c4aULL, 0x0000000e0900720cULL, 0x000fc60003f06070ULL,
0x0186f0000a0f7984ULL, 0x000ea40000000800ULL, 0x000000040f087824ULL, 0x004fe400078e0208ULL,
0x00000001040f7824ULL, 0x000fe400078e0209ULL, 0x0000000809097824ULL, 0x000fe400078e00ffULL,
0x018a800008087984ULL, 0x000ea60000000800ULL, 0xfffffff809097812ULL, 0x000fca00078ee202ULL,
0x0000001009097824ULL, 0x000fe400078e020cULL, 0x00000006080f7c24ULL, 0x004fc8000f8e020fULL,
0x000001000f067825ULL, 0x000fc600078e0006ULL, 0x000000060b067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006097faeULL, 0x0003e2000c101c4aULL, 0x0000001000587947ULL, 0x000fea0003800000ULL,
0x00000003ff097819ULL, 0x000fe40000011602ULL, 0x00000007610a7c11ULL, 0x040fe4000f8e20ffULL,
0x0000000761127c11ULL, 0x000fe2000f8e70ffULL, 0x00000004090c7824ULL, 0x000fe200078e0245ULL,
0x00000070100b7812ULL, 0x000fe200078ec0ffULL, 0x00000001040f7824ULL, 0x000fe400078e0209ULL,
0x0000000409157836ULL, 0x000fe20000000000ULL, 0x018600000c077984ULL, 0x000e660000000800ULL,
0x0000000815167824ULL, 0x000fc400078e00ffULL, 0x00000004070d7824ULL, 0x002fe400078e020aULL,
0x00008a00ff067b82ULL, 0x000e660000000a00ULL, 0x018a80000d087984ULL, 0x000ea40000000800ULL,
0x00000006080f7c24ULL, 0x004fe4000f8e020fULL, 0x0000000109087824ULL, 0x000fe400078e0202ULL,
0x000001000f0e7825ULL, 0x002fc600078e0006ULL, 0x0000000708117812ULL, 0x000fe200078ec0ffULL,
0x0000200012087836ULL, 0x000fe20000000000ULL, 0x0000000b0e107210ULL, 0x000fe20007f1e0ffULL,
0x00000001040e7824ULL, 0x000fe200078e0215ULL, 0x0ffffff8110d7812ULL, 0x000fc600078ef802ULL,
0x000000ffff117224ULL, 0x000fe400000e060fULL, 0x000000100d177824ULL, 0x000fca00078e0208ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010177faeULL, 0x0003e8000b901c4aULL,
0x018610000c0d7984ULL, 0x000ea20000000800ULL, 0x0000000809117836ULL, 0x002fe40000000000ULL,
0x000000040d127824ULL, 0x004fca00078e020aULL, 0x018a8000120d7984ULL, 0x000e640000000800ULL,
0x000000060d0d7c24ULL, 0x002fc8000f8e020eULL, 0x000001000d0e7825ULL, 0x000fc800078e0006ULL,
0x00000001150d7824ULL, 0x000fe200078e0202ULL, 0x0000000b0e147210ULL, 0x000fe20007f1e0ffULL,
0x00000001040e7824ULL, 0x000fc600078e0211ULL, 0xfffffff8160d7812ULL, 0x000fe200078ee20dULL,
0x000000ffff157224ULL, 0x000fe400000e060fULL, 0x0000000811167824ULL, 0x000fe400078e00ffULL,
0x000000100d177824ULL, 0x000fca00078e0208ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014177faeULL, 0x0003e8000b901c4aULL, 0x018620000c0d7984ULL, 0x000ea20000000800ULL,
0x0000000c09157836ULL, 0x002fe40000000000ULL, 0x000000040d127824ULL, 0x004fca00078e020aULL,
0x018a8000120d7984ULL, 0x000e640000000800ULL, 0x000000060d0d7c24ULL, 0x002fc8000f8e020eULL,
0x000001000d0e7825ULL, 0x000fc800078e0006ULL, 0x00000001110d7824ULL, 0x000fe200078e0202ULL,
0x0000000b0e107210ULL, 0x000fe20007f1e0ffULL, 0x00000001040e7824ULL, 0x000fc600078e0215ULL,
0xfffffff8160d7812ULL, 0x000fe200078ee20dULL, 0x000000ffff117224ULL, 0x000fe400000e060fULL,
0x0000000815167824ULL, 0x000fe400078e00ffULL, 0x000000100d177824ULL, 0x000fca00078e0208ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010177faeULL, 0x0003e8000b901c4aULL,
0x018630000c0d7984ULL, 0x000ea20000000800ULL, 0x0000001009117836ULL, 0x002fe40000000000ULL,
0x000000040d127824ULL, 0x004fca00078e020aULL, 0x018a8000120d7984ULL, 0x000e640000000800ULL,
0x000000060d0d7c24ULL, 0x002fc8000f8e020eULL, 0x000001000d0e7825ULL, 0x000fc800078e0006ULL,
0x00000001150d7824ULL, 0x000fe200078e0202ULL, 0x0000000b0e147210ULL, 0x000fe20007f1e0ffULL,
0x00000001040e7824ULL, 0x000fc600078e0211ULL, 0xfffffff8160d7812ULL, 0x000fe200078ee20dULL,
0x000000ffff157224ULL, 0x000fe400000e060fULL, 0x0000000811167824ULL, 0x000fe400078e00ffULL,
0x000000100d177824ULL, 0x000fca00078e0208ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014177faeULL, 0x0003e8000b901c4aULL, 0x018640000c0d7984ULL, 0x000ea20000000800ULL,
0x0000001409157836ULL, 0x002fe40000000000ULL, 0x000000040d127824ULL, 0x004fca00078e020aULL,
0x018a8000120d7984ULL, 0x000e640000000800ULL, 0x000000060d0d7c24ULL, 0x002fc8000f8e020eULL,
0x000001000d0e7825ULL, 0x000fc800078e0006ULL, 0x00000001110d7824ULL, 0x000fe200078e0202ULL,
0x0000000b0e107210ULL, 0x000fe20007f1e0ffULL, 0x00000001040e7824ULL, 0x000fc600078e0215ULL,
0xfffffff8160d7812ULL, 0x000fe200078ee20dULL, 0x000000ffff117224ULL, 0x000fe400000e060fULL,
0x0000000815167824ULL, 0x000fe400078e00ffULL, 0x000000100d177824ULL, 0x000fca00078e0208ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010177faeULL, 0x0003e8000b901c4aULL,
0x018650000c0d7984ULL, 0x000ea20000000800ULL, 0x0000001809117836ULL, 0x002fe40000000000ULL,
0x000000040d127824ULL, 0x004fca00078e020aULL, 0x018a8000120d7984ULL, 0x000e640000000800ULL,
0x000000060d0d7c24ULL, 0x002fc8000f8e020eULL, 0x000001000d0e7825ULL, 0x000fc800078e0006ULL,
0x00000001150d7824ULL, 0x000fe200078e0202ULL, 0x0000000b0e147210ULL, 0x000fe20007f1e0ffULL,
0x00000001040e7824ULL, 0x000fc600078e0211ULL, 0xfffffff8160d7812ULL, 0x000fe200078ee20dULL,
0x000000ffff157224ULL, 0x000fe400000e060fULL, 0x0000000811167824ULL, 0x000fe400078e00ffULL,
0x000000100d177824ULL, 0x000fca00078e0208ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014177faeULL, 0x0003e8000b901c4aULL, 0x018660000c0d7984ULL, 0x000ea20000000800ULL,
0x0000001c09157836ULL, 0x002fe40000000000ULL, 0x000000040d127824ULL, 0x004fca00078e020aULL,
0x018a8000120d7984ULL, 0x000e640000000800ULL, 0x000000060d0d7c24ULL, 0x002fc8000f8e020eULL,
0x000001000d0e7825ULL, 0x000fc800078e0006ULL, 0x00000001110d7824ULL, 0x000fe200078e0202ULL,
0x0000000b0e107210ULL, 0x000fe20007f1e0ffULL, 0x00000001040e7824ULL, 0x000fc600078e0215ULL,
0xfffffff8160d7812ULL, 0x000fe200078ee20dULL, 0x000000ffff117224ULL, 0x000fe400000e060fULL,
0x0000000815167824ULL, 0x000fe400078e00ffULL, 0x000000100d177824ULL, 0x000fca00078e0208ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010177faeULL, 0x0003e8000b901c4aULL,
0x018670000c0d7984ULL, 0x000ea20000000800ULL, 0x0000002009117836ULL, 0x002fe40000000000ULL,
0x000000040d127824ULL, 0x004fca00078e020aULL, 0x018a8000120d7984ULL, 0x000e640000000800ULL,
0x000000060d0d7c24ULL, 0x002fc8000f8e020eULL, 0x000001000d0e7825ULL, 0x000fc800078e0006ULL,
0x00000001150d7824ULL, 0x000fe200078e0202ULL, 0x0000000b0e147210ULL, 0x000fe20007f1e0ffULL,
0x00000001040e7824ULL, 0x000fc600078e0211ULL, 0xfffffff8160d7812ULL, 0x000fe200078ee20dULL,
0x000000ffff157224ULL, 0x000fe400000e060fULL, 0x0000000811167824ULL, 0x000fe400078e00ffULL,
0x000000100d177824ULL, 0x000fca00078e0208ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014177faeULL, 0x0003e8000b901c4aULL, 0x018680000c0d7984ULL, 0x000ea20000000800ULL,
0x0000002409157836ULL, 0x002fe40000000000ULL, 0x000000040d127824ULL, 0x004fca00078e020aULL,
0x018a8000120d7984ULL, 0x000e640000000800ULL, 0x000000060d0d7c24ULL, 0x002fc8000f8e020eULL,
0x000001000d0e7825ULL, 0x000fc800078e0006ULL, 0x00000001110d7824ULL, 0x000fe200078e0202ULL,
0x0000000b0e107210ULL, 0x000fe20007f1e0ffULL, 0x00000001040e7824ULL, 0x000fc600078e0215ULL,
0xfffffff8160d7812ULL, 0x000fe200078ee20dULL, 0x000000ffff117224ULL, 0x000fe400000e060fULL,
0x0000000815167824ULL, 0x000fe400078e00ffULL, 0x000000100d177824ULL, 0x000fca00078e0208ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010177faeULL, 0x0003e8000b901c4aULL,
0x018690000c0d7984ULL, 0x000ea20000000800ULL, 0x0000002809117836ULL, 0x002fe40000000000ULL,
0x000000040d127824ULL, 0x004fca00078e020aULL, 0x018a8000120d7984ULL, 0x000e640000000800ULL,
0x000000060d0d7c24ULL, 0x002fc8000f8e020eULL, 0x000001000d0e7825ULL, 0x000fc800078e0006ULL,
0x00000001150d7824ULL, 0x000fe200078e0202ULL, 0x0000000b0e147210ULL, 0x000fe20007f1e0ffULL,
0x00000001040e7824ULL, 0x000fc600078e0211ULL, 0xfffffff8160d7812ULL, 0x000fe200078ee20dULL,
0x000000ffff157224ULL, 0x000fe400000e060fULL, 0x0000000811167824ULL, 0x000fe400078e00ffULL,
0x000000100d177824ULL, 0x000fca00078e0208ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014177faeULL, 0x0003e8000b901c4aULL, 0x0186a0000c0d7984ULL, 0x000ea20000000800ULL,
0x0000002c09157836ULL, 0x002fe40000000000ULL, 0x000000040d127824ULL, 0x004fca00078e020aULL,
0x018a8000120d7984ULL, 0x000e640000000800ULL, 0x000000060d0d7c24ULL, 0x002fc8000f8e020eULL,
0x000001000d0e7825ULL, 0x000fc800078e0006ULL, 0x00000001110d7824ULL, 0x000fe200078e0202ULL,
0x0000000b0e107210ULL, 0x000fe20007f1e0ffULL, 0x00000001040e7824ULL, 0x000fc600078e0215ULL,
0xfffffff8160d7812ULL, 0x000fe200078ee20dULL, 0x000000ffff117224ULL, 0x000fe400000e060fULL,
0x0000000815167824ULL, 0x000fe400078e00ffULL, 0x000000100d177824ULL, 0x000fca00078e0208ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010177faeULL, 0x0003e8000b901c4aULL,
0x0186b0000c0d7984ULL, 0x000ea20000000800ULL, 0x0000003009117836ULL, 0x002fe40000000000ULL,
0x000000040d127824ULL, 0x004fca00078e020aULL, 0x018a8000120d7984ULL, 0x000e640000000800ULL,
0x000000060d0d7c24ULL, 0x002fc8000f8e020eULL, 0x000001000d0e7825ULL, 0x000fc800078e0006ULL,
0x00000001150d7824ULL, 0x000fe200078e0202ULL, 0x0000000b0e147210ULL, 0x000fe20007f1e0ffULL,
0x00000001040e7824ULL, 0x000fc600078e0211ULL, 0xfffffff8160d7812ULL, 0x000fe200078ee20dULL,
0x000000ffff157224ULL, 0x000fe400000e060fULL, 0x0000000811167824ULL, 0x000fe400078e00ffULL,
0x000000100d177824ULL, 0x000fca00078e0208ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014177faeULL, 0x0003e8000b901c4aULL, 0x0186c0000c0d7984ULL, 0x000ea20000000800ULL,
0x0000003409157836ULL, 0x002fe40000000000ULL, 0x000000040d127824ULL, 0x004fca00078e020aULL,
0x018a8000120d7984ULL, 0x000e640000000800ULL, 0x000000060d0d7c24ULL, 0x002fc8000f8e020eULL,
0x000001000d0e7825ULL, 0x000fc800078e0006ULL, 0x00000001110d7824ULL, 0x000fe200078e0202ULL,
0x0000000b0e107210ULL, 0x000fe20007f1e0ffULL, 0x00000001040e7824ULL, 0x000fc600078e0215ULL,
0xfffffff8160d7812ULL, 0x000fe200078ee20dULL, 0x000000ffff117224ULL, 0x000fe400000e060fULL,
0x0000000815167824ULL, 0x000fe400078e00ffULL, 0x000000100d177824ULL, 0x000fca00078e0208ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010177faeULL, 0x0003e8000b901c4aULL,
0x0186d0000c0d7984ULL, 0x000ea20000000800ULL, 0x0000003809177836ULL, 0x002fe40000000000ULL,
0x000000040d127824ULL, 0x004fca00078e020aULL, 0x018a8000120d7984ULL, 0x0002a40000000800ULL,
0x0000000817127824ULL, 0x002fe400078e00ffULL, 0x000000060d0d7c24ULL, 0x004fc8000f8e020eULL,
0x000001000d0e7825ULL, 0x000fc800078e0006ULL, 0x00000001150d7824ULL, 0x000fe200078e0202ULL,
0x0000000b0e147210ULL, 0x000fe20007f1e0ffULL, 0x00000001040e7824ULL, 0x000fc600078e0217ULL,
0xfffffff8160d7812ULL, 0x000fe200078ee20dULL, 0x000000ffff157224ULL, 0x000fc800000e060fULL,
0x000000100d117824ULL, 0x000fca00078e0208ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014117faeULL, 0x0003e8000b901c4aULL, 0x0186e0000c0d7984ULL, 0x000ea40000000800ULL,
0x000000040d107824ULL, 0x004fca00078e020aULL, 0x018a8000100d7984ULL, 0x000ea40000000800ULL,
0x000000060d0d7c24ULL, 0x004fc8000f8e020eULL, 0x000001000d0e7825ULL, 0x000fc800078e0006ULL,
0x00000001170d7824ULL, 0x000fe200078e0202ULL, 0x0000000b0e0e7210ULL, 0x000fc80007f1e0ffULL,
0xfffffff8120d7812ULL, 0x000fe200078ee20dULL, 0x000000ffff0f7224ULL, 0x000fc800000e060fULL,
0x000000100d117824ULL, 0x002fca00078e0208ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e117faeULL, 0x0003e8000b901c4aULL, 0x0186f0000c0d7984ULL, 0x000ea40000000800ULL,
0x000000040d0a7824ULL, 0x004fe400078e020aULL, 0x0000003c090d7836ULL, 0x000fc80000000000ULL,
0x018a80000a0a7984ULL, 0x000ea20000000800ULL, 0x0000000104097824ULL, 0x000fe400078e020dULL,
0x000000010d027824ULL, 0x000fe400078e0202ULL, 0x000000060a097c24ULL, 0x004fc8000f8e0209ULL,
0x0000010009067825ULL, 0x000fc800078e0006ULL, 0x000000080d097824ULL, 0x000fe200078e00ffULL,
0x0000000b06067210ULL, 0x000fc80007f1e0ffULL, 0xfffffff809097812ULL, 0x000fe200078ee202ULL,
0x000000ffff077224ULL, 0x000fc800000e0607ULL, 0x0000001009097824ULL, 0x000fca00078e0208ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006097faeULL, 0x0003e4000b901c4aULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000067805ULL, 0x002fce0000015200ULL, 0x018ad005ff0075a7ULL, 0x000e640008000147ULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff047224ULL, 0x000fce00078e00ffULL,
0x000000100400780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fce0000015200ULL, 0x00000008060b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e07ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff027819ULL, 0x000fc80000011409ULL,
0x0000000b02027211ULL, 0x000fca00078110ffULL, 0x000000ffff097224ULL, 0x000fca00000e0609ULL,
0x0000000202027819ULL, 0x000fc80000001209ULL, 0x000000020000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000104047836ULL, 0x000fce0000000000ULL,
0x018ad005ff0075a7ULL, 0x000e640008000147ULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000000027919ULL, 0x000e640000000000ULL, 0x0000002061027824ULL, 0x002fca00078e0202ULL,
0x00000003ff047819ULL, 0x000fe40000011602ULL, 0x0000000f02027812ULL, 0x000fe400078ec0ffULL,
0x1ffffffe04057812ULL, 0x000fc600078ec0ffULL, 0x0000000102047836ULL, 0x000fe40000000000ULL,
0x0000000102067824ULL, 0x040fe400078e0205ULL, 0x0000000105077824ULL, 0x000fe400078e0204ULL,
0x0000002002087824ULL, 0x000fe200078e00ffULL, 0x0000001f06067812ULL, 0x000fe200078ec0ffULL,
0x0000002002097824ULL, 0x000fe200078e00ffULL, 0x0000001f07077812ULL, 0x000fe200078ec0ffULL,
0x0000001005057836ULL, 0x000fc40000000000ULL, 0x0000002002117824ULL, 0x040fe200078e00ffULL,
0x000001e008077812ULL, 0x000fe200078ee207ULL, 0x0000000102107824ULL, 0x100fe200078e0205ULL,
0x000001e009067812ULL, 0x000fe200078ee206ULL, 0x0000000104047824ULL, 0x000fe200078e0205ULL,
0x0000000707077c11ULL, 0x000fe2000f8e20ffULL, 0x0000002002057824ULL, 0x000fe200078e00ffULL,
0x0000000706067c11ULL, 0x000fe4000f8e20ffULL, 0x0000001f10107812ULL, 0x000fe200078ec0ffULL,
0x0000000007087984ULL, 0x000e620000000c00ULL, 0x0000001f04047812ULL, 0x000fc400078ec0ffULL,
0x000001e005107812ULL, 0x000fe200078ee210ULL, 0x00000000060c7984ULL, 0x000ea20000000c00ULL,
0x000001e011047812ULL, 0x000fe400078ee204ULL, 0x0000000710107c11ULL, 0x000fe4000f8e20ffULL,
0x0000000704027c11ULL, 0x000fe2000f8e20ffULL, 0x00000001ff047424ULL, 0x000fe400078e00ffULL,
0x000000ffff167224ULL, 0x002fe400078e0008ULL, 0x000000ffff177224ULL, 0x000fc400078e000aULL,
0x000000ffff147224ULL, 0x004fe400078e000cULL, 0x000000ffff157224ULL, 0x000fe400078e000eULL,
0x000000ffff1a7224ULL, 0x000fe400078e0009ULL, 0x000000ffff1b7224ULL, 0x000fe200078e000bULL,
0x0000001406007388ULL, 0x000fe20000000c00ULL, 0x000000ffff187224ULL, 0x000fe400078e000dULL,
0x000000ffff197224ULL, 0x000fca00078e000fULL, 0x0000001807007388ULL, 0x000fe80000000c00ULL,
0x0000000002087984ULL, 0x000e680000000c00ULL, 0x00000000100c7984ULL, 0x000ea20000000c00ULL,
0x000000ffff1e7224ULL, 0x002fe400078e0008ULL, 0x000000ffff1f7224ULL, 0x000fc400078e000aULL,
0x000000ffff1c7224ULL, 0x004fe400078e000cULL, 0x000000ffff1d7224ULL, 0x000fe400078e000eULL,
0x000000ffff227224ULL, 0x000fe400078e0009ULL, 0x000000ffff237224ULL, 0x000fe200078e000bULL,
0x0000001c10007388ULL, 0x0003e20000000c00ULL, 0x000000ffff207224ULL, 0x000fe400078e000dULL,
0x000000ffff217224ULL, 0x000fca00078e000fULL, 0x0000002002007388ULL, 0x0003e20000000c00ULL,
0x018ad004ff0479a7ULL, 0x000ea40008500007ULL, 0x000000ffff087224ULL, 0x006fce00078e0005ULL,
0x0000000000047805ULL, 0x000fce0000015200ULL, 0x018ad008ff0075a7ULL, 0x000e640008000147ULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff0a7224ULL, 0x000fce00078e00ffULL,
0x000000100a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fce0000015200ULL, 0x0000000604097210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff027819ULL, 0x000fc80000011407ULL,
0x0000000902027211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000202027819ULL, 0x000fc80000001207ULL, 0x000000020000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000010a0a7836ULL, 0x000fce0000000000ULL,
0x018ad008ff0075a7ULL, 0x000e640008000147ULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000cff007c0cULL, 0x000fda000bf05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000027919ULL, 0x000e620000000000ULL, 0x3d80000003037820ULL, 0x010fe20000410000ULL,
0x0000000761047c11ULL, 0x000fe2000f8e28ffULL, 0x000000ffff447224ULL, 0x000fe200078e00ffULL,
0x0000840000047ab9ULL, 0x000fe20000000800ULL, 0x000000ffff067224ULL, 0x000fe200078e00ffULL,
0x00000000030e72caULL, 0x000fe200000e0000ULL, 0xffffffff0c0d7890ULL, 0x000fe2000fffe03fULL,
0x0000000761037c11ULL, 0x000fe2000f8e18ffULL, 0x0000000704087899ULL, 0x000fd8000800063fULL,
0x0000010044607824ULL, 0x000fca00078e0247ULL, 0x0000000960007c0cULL, 0x000fda000bf01070ULL,
0x000000000000894dULL, 0x00afea0003800000ULL, 0x00000001ff677424ULL, 0x000fe200078e00ffULL,
0x000000445f00720cULL, 0x000fe20003f44070ULL, 0x0000003f00047c82ULL, 0x000fc60008000000ULL,
0x0000000467677807ULL, 0x000fd20001000000ULL, 0x000000ffff1a7224ULL, 0x000fe200078e0006ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x000000ffff6a7224ULL, 0x000fe200078e00ffULL,
0x0000000000147805ULL, 0x000fe4000001ff00ULL, 0x00000000001e7805ULL, 0x000fe4000001ff00ULL,
0x00000000001c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fe4000001ff00ULL,
0x0000000000207805ULL, 0x000fc4000001ff00ULL, 0x0000000000267805ULL, 0x000fe4000001ff00ULL,
0x0000000000247805ULL, 0x000fe4000001ff00ULL, 0x00000000002a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000287805ULL, 0x000fe4000001ff00ULL, 0x0000000000367805ULL, 0x000fe4000001ff00ULL,
0x0000000000347805ULL, 0x000fc4000001ff00ULL, 0x0000000000327805ULL, 0x000fe4000001ff00ULL,
0x0000000000307805ULL, 0x000fe4000001ff00ULL, 0x00000000002e7805ULL, 0x000fe4000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000400067c82ULL, 0x000fcc0008000000ULL,
0x000000016a0c7836ULL, 0x000fe20000000000ULL, 0x000080000000791aULL, 0x000fc80000000000ULL,
0x000000040c0d7c11ULL, 0x040fe2000f8ff8ffULL, 0x000000ffff667224ULL, 0x000fe200078e006aULL,
0x000000020c00780cULL, 0x040fe20003f06070ULL, 0x000000ffff6a7224ULL, 0x000fe200078e000cULL,
0x000000030d397812ULL, 0x000fe400078ec0ffULL, 0x00000002ff0da819ULL, 0x000fe4000001160dULL,
0x000000010c1b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff39397207ULL, 0x000fe20005000000ULL,
0x000000010d387824ULL, 0x000fc800078e0244ULL, 0x0000000138067836ULL, 0x000fe40000000000ULL,
0x0000010038187824ULL, 0x000fc600078e0247ULL, 0x0000000c06007c0cULL, 0x000fe4000bf26070ULL,
0x0000004018537812ULL, 0x000fe400078ec0ffULL, 0x000000011a067812ULL, 0x000fc600078e0cffULL,
0x0000000100537824ULL, 0x000fe200078e0253ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000010006c9947ULL, 0x000fea0003800000ULL, 0x00000003ff3a7819ULL, 0x002fe20000011602ULL,
0x000000081b3f7824ULL, 0x000fe200078e00ffULL, 0x00000007613b7c11ULL, 0x040fe4000f8e20ffULL,
0x0000000918517c48ULL, 0x000fe2000ffe0000ULL, 0x000000043a3e7824ULL, 0x040fe200078e0245ULL,
0x00000007613d7c11ULL, 0x000fe2000f8e70ffULL, 0x000000013a0f7824ULL, 0x040fe200078e0253ULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee202ULL, 0x0000000151517824ULL, 0x000fe200078e0a18ULL,
0x018600003e0c7984ULL, 0x000e620000000800ULL, 0x000000013a187824ULL, 0x000fc400078e0202ULL,
0x00002000063c7824ULL, 0x000fe200078e023dULL, 0x000000513a00720cULL, 0x000fe20003f26070ULL,
0x000000043a527836ULL, 0x000fe20000000000ULL, 0x0000000718197812ULL, 0x000fe200078ec0ffULL,
0x000020003c3c7836ULL, 0x000fe40000000000ULL, 0x0000000152627824ULL, 0x040fe200078e0202ULL,
0x0ffffff819197812ULL, 0x000fe200078ef802ULL, 0x0000000852697824ULL, 0x000fc800078e00ffULL,
0x0000001019657824ULL, 0x000fe400078e023cULL, 0x0000000152197824ULL, 0x000fe400078e0253ULL,
0x000000040c0e7824ULL, 0x002fe400078e023bULL, 0x00008a00ff0c7b82ULL, 0x000e680000000a00ULL,
0x018a80000e0e7984ULL, 0x000ea40000000800ULL, 0x000000080e0f7c24ULL, 0x004fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x002fc800078e000cULL, 0x000000103f0e7825ULL, 0x000fca00078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e657faeULL, 0x0003e2000c901c4aULL,
0x000000515200720cULL, 0x000fe20003f26070ULL, 0x000000083a527836ULL, 0x000fe40000000000ULL,
0x018610003e187984ULL, 0x000ea20000000800ULL, 0xfffffff869657812ULL, 0x002fe200078ee262ULL,
0x00000001520f7824ULL, 0x040fe400078e0253ULL, 0x0000000152627824ULL, 0x000fe400078e0202ULL,
0x0000001065657824ULL, 0x000fc400078e023cULL, 0x0000000852697824ULL, 0x000fe400078e00ffULL,
0x0000000418507824ULL, 0x004fca00078e023bULL, 0x018a800050187984ULL, 0x000e640000000800ULL,
0x0000000818197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc800078e000cULL,
0x000000103f187825ULL, 0x000fca00078e0018ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018657faeULL, 0x0003e2000c901c4aULL, 0x000000515200720cULL, 0x000fe20003f26070ULL,
0x0000000c3a527836ULL, 0x000fe40000000000ULL, 0x018620003e0e7984ULL, 0x000ea20000000800ULL,
0xfffffff869657812ULL, 0x002fe200078ee262ULL, 0x0000000152197824ULL, 0x040fe400078e0253ULL,
0x0000000152627824ULL, 0x000fe400078e0202ULL, 0x0000001065657824ULL, 0x000fc400078e023cULL,
0x0000000852697824ULL, 0x000fe400078e00ffULL, 0x000000040e507824ULL, 0x004fca00078e023bULL,
0x018a8000500e7984ULL, 0x000e640000000800ULL, 0x000000080e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc800078e000cULL, 0x000000103f0e7825ULL, 0x000fca00078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e657faeULL, 0x0003e2000c901c4aULL,
0x000000515200720cULL, 0x000fe20003f26070ULL, 0x000000103a527836ULL, 0x000fe40000000000ULL,
0x018630003e187984ULL, 0x000ea20000000800ULL, 0xfffffff869657812ULL, 0x002fe200078ee262ULL,
0x00000001520f7824ULL, 0x040fe400078e0253ULL, 0x0000000152627824ULL, 0x000fe400078e0202ULL,
0x0000001065657824ULL, 0x000fc400078e023cULL, 0x0000000852697824ULL, 0x000fe400078e00ffULL,
0x0000000418507824ULL, 0x004fca00078e023bULL, 0x018a800050187984ULL, 0x000e640000000800ULL,
0x0000000818197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc800078e000cULL,
0x000000103f187825ULL, 0x000fca00078e0018ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018657faeULL, 0x0003e2000c901c4aULL, 0x000000515200720cULL, 0x000fe20003f26070ULL,
0x000000143a527836ULL, 0x000fe40000000000ULL, 0x018640003e0e7984ULL, 0x000ea20000000800ULL,
0xfffffff869657812ULL, 0x002fe200078ee262ULL, 0x0000000152197824ULL, 0x040fe400078e0253ULL,
0x0000000152627824ULL, 0x000fe400078e0202ULL, 0x0000001065657824ULL, 0x000fc400078e023cULL,
0x0000000852697824ULL, 0x000fe400078e00ffULL, 0x000000040e507824ULL, 0x004fca00078e023bULL,
0x018a8000500e7984ULL, 0x000e640000000800ULL, 0x000000080e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc800078e000cULL, 0x000000103f0e7825ULL, 0x000fca00078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e657faeULL, 0x0003e2000c901c4aULL,
0x000000515200720cULL, 0x000fe20003f26070ULL, 0x000000183a527836ULL, 0x000fe40000000000ULL,
0x018650003e187984ULL, 0x000ea20000000800ULL, 0xfffffff869657812ULL, 0x002fe200078ee262ULL,
0x00000001520f7824ULL, 0x040fe400078e0253ULL, 0x0000000152627824ULL, 0x000fe400078e0202ULL,
0x0000001065657824ULL, 0x000fc400078e023cULL, 0x0000000852697824ULL, 0x000fe400078e00ffULL,
0x0000000418507824ULL, 0x004fca00078e023bULL, 0x018a800050187984ULL, 0x000e640000000800ULL,
0x0000000818197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc800078e000cULL,
0x000000103f187825ULL, 0x000fca00078e0018ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018657faeULL, 0x0003e2000c901c4aULL, 0x000000515200720cULL, 0x000fe20003f26070ULL,
0x0000001c3a527836ULL, 0x000fe40000000000ULL, 0x018660003e0e7984ULL, 0x000ea20000000800ULL,
0xfffffff869657812ULL, 0x002fe200078ee262ULL, 0x0000000152197824ULL, 0x040fe400078e0253ULL,
0x0000000152627824ULL, 0x000fe400078e0202ULL, 0x0000001065657824ULL, 0x000fc400078e023cULL,
0x0000000852697824ULL, 0x000fe400078e00ffULL, 0x000000040e507824ULL, 0x004fca00078e023bULL,
0x018a8000500e7984ULL, 0x000e640000000800ULL, 0x000000080e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc800078e000cULL, 0x000000103f0e7825ULL, 0x000fca00078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e657faeULL, 0x0003e2000c901c4aULL,
0x000000515200720cULL, 0x000fe20003f26070ULL, 0x000000203a527836ULL, 0x000fe40000000000ULL,
0x018670003e187984ULL, 0x000ea20000000800ULL, 0xfffffff869657812ULL, 0x002fe200078ee262ULL,
0x00000001520f7824ULL, 0x040fe400078e0253ULL, 0x0000000152627824ULL, 0x000fe400078e0202ULL,
0x0000001065657824ULL, 0x000fc400078e023cULL, 0x0000000852697824ULL, 0x000fe400078e00ffULL,
0x0000000418507824ULL, 0x004fca00078e023bULL, 0x018a800050187984ULL, 0x000e640000000800ULL,
0x0000000818197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc800078e000cULL,
0x000000103f187825ULL, 0x000fca00078e0018ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018657faeULL, 0x0003e2000c901c4aULL, 0x000000515200720cULL, 0x000fe20003f26070ULL,
0x000000243a527836ULL, 0x000fe40000000000ULL, 0x018680003e0e7984ULL, 0x000ea20000000800ULL,
0xfffffff869657812ULL, 0x002fe200078ee262ULL, 0x0000000152197824ULL, 0x040fe400078e0253ULL,
0x0000000152627824ULL, 0x000fe400078e0202ULL, 0x0000001065657824ULL, 0x000fc400078e023cULL,
0x0000000852697824ULL, 0x000fe400078e00ffULL, 0x000000040e507824ULL, 0x004fca00078e023bULL,
0x018a8000500e7984ULL, 0x000e640000000800ULL, 0x000000080e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc800078e000cULL, 0x000000103f0e7825ULL, 0x000fca00078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e657faeULL, 0x0003e2000c901c4aULL,
0x000000515200720cULL, 0x000fe20003f26070ULL, 0x000000283a527836ULL, 0x000fe40000000000ULL,
0x018690003e187984ULL, 0x000ea20000000800ULL, 0xfffffff869657812ULL, 0x002fe200078ee262ULL,
0x00000001520f7824ULL, 0x040fe400078e0253ULL, 0x0000000152627824ULL, 0x000fe400078e0202ULL,
0x0000001065657824ULL, 0x000fc400078e023cULL, 0x0000000852697824ULL, 0x000fe400078e00ffULL,
0x0000000418507824ULL, 0x004fca00078e023bULL, 0x018a800050187984ULL, 0x000e640000000800ULL,
0x0000000818197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc800078e000cULL,
0x000000103f187825ULL, 0x000fca00078e0018ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018657faeULL, 0x0003e2000c901c4aULL, 0x000000515200720cULL, 0x000fe20003f26070ULL,
0x0000002c3a527836ULL, 0x000fe40000000000ULL, 0x0186a0003e0e7984ULL, 0x000ea20000000800ULL,
0xfffffff869657812ULL, 0x002fe200078ee262ULL, 0x0000000152197824ULL, 0x040fe400078e0253ULL,
0x0000000152627824ULL, 0x000fe400078e0202ULL, 0x0000001065657824ULL, 0x000fc400078e023cULL,
0x0000000852697824ULL, 0x000fe400078e00ffULL, 0x000000040e507824ULL, 0x004fca00078e023bULL,
0x018a8000500e7984ULL, 0x000e640000000800ULL, 0x000000080e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc800078e000cULL, 0x000000103f0e7825ULL, 0x000fca00078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e657faeULL, 0x0003e2000c901c4aULL,
0x000000515200720cULL, 0x000fe20003f26070ULL, 0x000000303a527836ULL, 0x000fe40000000000ULL,
0x0186b0003e187984ULL, 0x000ea20000000800ULL, 0xfffffff869657812ULL, 0x002fe200078ee262ULL,
0x00000001520f7824ULL, 0x040fe400078e0253ULL, 0x0000000152627824ULL, 0x000fe400078e0202ULL,
0x0000001065657824ULL, 0x000fc400078e023cULL, 0x0000000852697824ULL, 0x000fe400078e00ffULL,
0x0000000418507824ULL, 0x004fca00078e023bULL, 0x018a800050187984ULL, 0x000e640000000800ULL,
0x0000000818197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc800078e000cULL,
0x000000103f187825ULL, 0x000fca00078e0018ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018657faeULL, 0x0003e2000c901c4aULL, 0x000000515200720cULL, 0x000fe20003f26070ULL,
0x000000343a527836ULL, 0x000fe40000000000ULL, 0x0186c0003e0e7984ULL, 0x000ea20000000800ULL,
0xfffffff869657812ULL, 0x002fe200078ee262ULL, 0x0000000152197824ULL, 0x040fe400078e0253ULL,
0x0000000152627824ULL, 0x000fe400078e0202ULL, 0x0000001065657824ULL, 0x000fc400078e023cULL,
0x0000000852697824ULL, 0x000fe400078e00ffULL, 0x000000040e507824ULL, 0x004fca00078e023bULL,
0x018a8000500e7984ULL, 0x000e640000000800ULL, 0x000000080e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc800078e000cULL, 0x000000103f0e7825ULL, 0x000fca00078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e657faeULL, 0x0003e2000c901c4aULL,
0x000000515200720cULL, 0x000fe20003f26070ULL, 0x000000383a527836ULL, 0x000fe40000000000ULL,
0x0186d0003e187984ULL, 0x000ea20000000800ULL, 0x0000003c3a3a7836ULL, 0x000fe20000000000ULL,
0xfffffff869657812ULL, 0x002fe200078ee262ULL, 0x00000001520f7824ULL, 0x040fe400078e0253ULL,
0x0000000152627824ULL, 0x000fe400078e0202ULL, 0x0000001065657824ULL, 0x000fc400078e023cULL,
0x0000000852697824ULL, 0x000fe400078e00ffULL, 0x000000013a537824ULL, 0x000fe400078e0253ULL,
0x0000000418507824ULL, 0x004fca00078e023bULL, 0x018a800050187984ULL, 0x000e640000000800ULL,
0x0000000818197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc800078e000cULL,
0x000000103f187825ULL, 0x000fca00078e0018ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018657faeULL, 0x0003e2000c901c4aULL, 0x000000515200720cULL, 0x000fc60003f26070ULL,
0x0186e0003e0e7984ULL, 0x000ea20000000800ULL, 0xfffffff869197812ULL, 0x002fe200078ee262ULL,
0x000000083a657824ULL, 0x000fc800078e00ffULL, 0x0000001019197824ULL, 0x000fe400078e023cULL,
0x000000040e507824ULL, 0x004fca00078e023bULL, 0x018a8000500e7984ULL, 0x0002a40000000800ULL,
0x000000013a507824ULL, 0x002fe400078e0202ULL, 0x000000080e0f7c24ULL, 0x004fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc800078e000cULL, 0x000000103f0e7825ULL, 0x000fca00078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e197faeULL, 0x0003e2000c901c4aULL,
0x000000513a00720cULL, 0x000fc60003f26070ULL, 0x0186f0003e3e7984ULL, 0x000ea20000000800ULL,
0xfffffff8650f7812ULL, 0x002fca00078ee250ULL, 0x000000100f0f7824ULL, 0x000fe400078e023cULL,
0x000000043e187824ULL, 0x004fcc00078e023bULL, 0x018a800018187984ULL, 0x000e640000000800ULL,
0x0000000818537c24ULL, 0x002fc8000f8e0253ULL, 0x00000100530c7825ULL, 0x000fc800078e000cULL,
0x000000103f0c7825ULL, 0x000fca00078e000cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c0f7faeULL, 0x0003e2000c901c4aULL, 0x0000001000207947ULL, 0x000fea0003800000ULL,
0x00000003ff3a7819ULL, 0x102fe20000011602ULL, 0x000000081b3f7824ULL, 0x000fe200078e00ffULL,
0x00000007613b7c11ULL, 0x040fe4000f8e20ffULL, 0x00000007613d7c11ULL, 0x000fe2000f8e70ffULL,
0x000000043a3e7824ULL, 0x040fe200078e0245ULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee202ULL,
0x000000013a0f7824ULL, 0x040fe400078e0253ULL, 0x000000013a187824ULL, 0x000fe200078e0202ULL,
0x018600003e0c7984ULL, 0x000e620000000800ULL, 0x00002000063c7824ULL, 0x000fc400078e023dULL,
0x000000043a527836ULL, 0x000fe20000000000ULL, 0x0000000718197812ULL, 0x000fe200078ec0ffULL,
0x000020003c3c7836ULL, 0x000fe40000000000ULL, 0x0000000152627824ULL, 0x040fe200078e0202ULL,
0x0ffffff819197812ULL, 0x000fe200078ef802ULL, 0x0000000852657824ULL, 0x000fc800078e00ffULL,
0x0000001019517824ULL, 0x000fe200078e023cULL, 0xfffffff865657812ULL, 0x000fe200078ee262ULL,
0x0000000152197824ULL, 0x000fc800078e0253ULL, 0x0000001065657824ULL, 0x000fe400078e023cULL,
0x000000040c0e7824ULL, 0x002fe400078e023bULL, 0x00008a00ff0c7b82ULL, 0x000e680000000a00ULL,
0x018a80000e0e7984ULL, 0x000ea40000000800ULL, 0x000000080e0f7c24ULL, 0x004fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x002fc800078e000cULL, 0x000000103f0e7825ULL, 0x000fca00078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e517faeULL, 0x0003e8000b901c4aULL,
0x018610003e187984ULL, 0x000ea20000000800ULL, 0x000000083a517836ULL, 0x002fc80000000000ULL,
0x00000001510f7824ULL, 0x040fe400078e0253ULL, 0x0000000151527824ULL, 0x040fe400078e0202ULL,
0x0000000851517824ULL, 0x000fca00078e00ffULL, 0xfffffff851517812ULL, 0x000fe200078ee252ULL,
0x0000000c3a527836ULL, 0x000fc80000000000ULL, 0x0000001051517824ULL, 0x000fe400078e023cULL,
0x0000000152627824ULL, 0x000fe400078e0202ULL, 0x0000000418507824ULL, 0x004fca00078e023bULL,
0x018a800050187984ULL, 0x000e640000000800ULL, 0x0000000818197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc800078e000cULL, 0x000000103f187825ULL, 0x000fca00078e0018ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018657faeULL, 0x0003e8000b901c4aULL,
0x018620003e0e7984ULL, 0x000ea20000000800ULL, 0x0000000152197824ULL, 0x042fe400078e0253ULL,
0x0000000852657824ULL, 0x000fca00078e00ffULL, 0xfffffff865657812ULL, 0x000fca00078ee262ULL,
0x0000001065657824ULL, 0x000fe400078e023cULL, 0x000000040e507824ULL, 0x004fca00078e023bULL,
0x018a8000500e7984ULL, 0x000e640000000800ULL, 0x000000080e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc800078e000cULL, 0x000000103f0e7825ULL, 0x000fca00078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e517faeULL, 0x0003e8000b901c4aULL,
0x018630003e187984ULL, 0x000ea20000000800ULL, 0x000000103a517836ULL, 0x002fc80000000000ULL,
0x00000001510f7824ULL, 0x040fe400078e0253ULL, 0x0000000151527824ULL, 0x040fe400078e0202ULL,
0x0000000851517824ULL, 0x000fca00078e00ffULL, 0xfffffff851517812ULL, 0x000fe200078ee252ULL,
0x000000143a527836ULL, 0x000fc80000000000ULL, 0x0000001051517824ULL, 0x000fe400078e023cULL,
0x0000000152627824ULL, 0x000fe400078e0202ULL, 0x0000000418507824ULL, 0x004fca00078e023bULL,
0x018a800050187984ULL, 0x000e640000000800ULL, 0x0000000818197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc800078e000cULL, 0x000000103f187825ULL, 0x000fca00078e0018ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018657faeULL, 0x0003e8000b901c4aULL,
0x018640003e0e7984ULL, 0x000ea20000000800ULL, 0x0000000152197824ULL, 0x042fe400078e0253ULL,
0x0000000852657824ULL, 0x000fca00078e00ffULL, 0xfffffff865657812ULL, 0x000fca00078ee262ULL,
0x0000001065657824ULL, 0x000fe400078e023cULL, 0x000000040e507824ULL, 0x004fca00078e023bULL,
0x018a8000500e7984ULL, 0x000e640000000800ULL, 0x000000080e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc800078e000cULL, 0x000000103f0e7825ULL, 0x000fca00078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e517faeULL, 0x0003e8000b901c4aULL,
0x018650003e187984ULL, 0x000ea20000000800ULL, 0x000000183a517836ULL, 0x002fc80000000000ULL,
0x00000001510f7824ULL, 0x040fe400078e0253ULL, 0x0000000151527824ULL, 0x040fe400078e0202ULL,
0x0000000851517824ULL, 0x000fca00078e00ffULL, 0xfffffff851517812ULL, 0x000fe200078ee252ULL,
0x0000001c3a527836ULL, 0x000fc80000000000ULL, 0x0000001051517824ULL, 0x000fe400078e023cULL,
0x0000000152627824ULL, 0x000fe400078e0202ULL, 0x0000000418507824ULL, 0x004fca00078e023bULL,
0x018a800050187984ULL, 0x000e640000000800ULL, 0x0000000818197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc800078e000cULL, 0x000000103f187825ULL, 0x000fca00078e0018ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018657faeULL, 0x0003e8000b901c4aULL,
0x018660003e0e7984ULL, 0x000ea20000000800ULL, 0x0000000152197824ULL, 0x042fe400078e0253ULL,
0x0000000852657824ULL, 0x000fca00078e00ffULL, 0xfffffff865657812ULL, 0x000fca00078ee262ULL,
0x0000001065657824ULL, 0x000fe400078e023cULL, 0x000000040e507824ULL, 0x004fca00078e023bULL,
0x018a8000500e7984ULL, 0x000e640000000800ULL, 0x000000080e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc800078e000cULL, 0x000000103f0e7825ULL, 0x000fca00078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e517faeULL, 0x0003e8000b901c4aULL,
0x018670003e187984ULL, 0x000ea20000000800ULL, 0x000000203a517836ULL, 0x002fc80000000000ULL,
0x00000001510f7824ULL, 0x040fe400078e0253ULL, 0x0000000151527824ULL, 0x040fe400078e0202ULL,
0x0000000851517824ULL, 0x000fca00078e00ffULL, 0xfffffff851517812ULL, 0x000fe200078ee252ULL,
0x000000243a527836ULL, 0x000fc80000000000ULL, 0x0000001051517824ULL, 0x000fe400078e023cULL,
0x0000000152627824ULL, 0x000fe400078e0202ULL, 0x0000000418507824ULL, 0x004fca00078e023bULL,
0x018a800050187984ULL, 0x000e640000000800ULL, 0x0000000818197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc800078e000cULL, 0x000000103f187825ULL, 0x000fca00078e0018ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018657faeULL, 0x0003e8000b901c4aULL,
0x018680003e0e7984ULL, 0x000ea20000000800ULL, 0x0000000152197824ULL, 0x042fe400078e0253ULL,
0x0000000852657824ULL, 0x000fca00078e00ffULL, 0xfffffff865657812ULL, 0x000fca00078ee262ULL,
0x0000001065657824ULL, 0x000fe400078e023cULL, 0x000000040e507824ULL, 0x004fca00078e023bULL,
0x018a8000500e7984ULL, 0x000e640000000800ULL, 0x000000080e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc800078e000cULL, 0x000000103f0e7825ULL, 0x000fca00078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e517faeULL, 0x0003e8000b901c4aULL,
0x018690003e187984ULL, 0x000ea20000000800ULL, 0x000000283a517836ULL, 0x002fc80000000000ULL,
0x00000001510f7824ULL, 0x040fe400078e0253ULL, 0x0000000151527824ULL, 0x040fe400078e0202ULL,
0x0000000851517824ULL, 0x000fca00078e00ffULL, 0xfffffff851517812ULL, 0x000fe200078ee252ULL,
0x0000002c3a527836ULL, 0x000fc80000000000ULL, 0x0000001051517824ULL, 0x000fe400078e023cULL,
0x0000000152627824ULL, 0x000fe400078e0202ULL, 0x0000000418507824ULL, 0x004fca00078e023bULL,
0x018a800050187984ULL, 0x000e640000000800ULL, 0x0000000818197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc800078e000cULL, 0x000000103f187825ULL, 0x000fca00078e0018ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018657faeULL, 0x0003e8000b901c4aULL,
0x0186a0003e0e7984ULL, 0x000ea20000000800ULL, 0x0000000152197824ULL, 0x042fe400078e0253ULL,
0x0000000852657824ULL, 0x000fca00078e00ffULL, 0xfffffff865657812ULL, 0x000fca00078ee262ULL,
0x0000001065657824ULL, 0x000fe400078e023cULL, 0x000000040e507824ULL, 0x004fca00078e023bULL,
0x018a8000500e7984ULL, 0x000e640000000800ULL, 0x000000080e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc800078e000cULL, 0x000000103f0e7825ULL, 0x000fca00078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e517faeULL, 0x0003e8000b901c4aULL,
0x0186b0003e187984ULL, 0x000ea20000000800ULL, 0x000000303a517836ULL, 0x002fc80000000000ULL,
0x00000001510f7824ULL, 0x040fe400078e0253ULL, 0x0000000151527824ULL, 0x040fe400078e0202ULL,
0x0000000851517824ULL, 0x000fca00078e00ffULL, 0xfffffff851517812ULL, 0x000fe200078ee252ULL,
0x000000343a527836ULL, 0x000fc80000000000ULL, 0x0000001051517824ULL, 0x000fe400078e023cULL,
0x0000000152627824ULL, 0x000fe400078e0202ULL, 0x0000000418507824ULL, 0x004fca00078e023bULL,
0x018a800050187984ULL, 0x000e640000000800ULL, 0x0000000818197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc800078e000cULL, 0x000000103f187825ULL, 0x000fca00078e0018ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018657faeULL, 0x0003e8000b901c4aULL,
0x0186c0003e0e7984ULL, 0x000ea20000000800ULL, 0x0000000152197824ULL, 0x042fe400078e0253ULL,
0x0000000852657824ULL, 0x000fca00078e00ffULL, 0xfffffff865657812ULL, 0x000fca00078ee262ULL,
0x0000001065657824ULL, 0x000fe400078e023cULL, 0x000000040e507824ULL, 0x004fca00078e023bULL,
0x018a8000500e7984ULL, 0x000e640000000800ULL, 0x000000080e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc800078e000cULL, 0x000000103f0e7825ULL, 0x000fca00078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e517faeULL, 0x0003e8000b901c4aULL,
0x0186d0003e187984ULL, 0x000ea20000000800ULL, 0x000000383a517836ULL, 0x002fe40000000000ULL,
0x0000003c3a3a7836ULL, 0x000fe40000000000ULL, 0x00000001510f7824ULL, 0x040fe400078e0253ULL,
0x0000000151527824ULL, 0x000fc400078e0202ULL, 0x0000000851517824ULL, 0x000fca00078e00ffULL,
0xfffffff851517812ULL, 0x000fca00078ee252ULL, 0x0000001051517824ULL, 0x000fe400078e023cULL,
0x0000000418507824ULL, 0x004fca00078e023bULL, 0x018a800050187984ULL, 0x000e640000000800ULL,
0x0000000818197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc800078e000cULL,
0x000000103f187825ULL, 0x000fca00078e0018ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018657faeULL, 0x0003e8000b901c4aULL, 0x0186e0003e0e7984ULL, 0x000ea20000000800ULL,
0x000000013a197824ULL, 0x042fe400078e0253ULL, 0x000000083a537824ULL, 0x000fe400078e00ffULL,
0x000000040e507824ULL, 0x004fca00078e023bULL, 0x018a8000500e7984ULL, 0x0002a40000000800ULL,
0x000000013a507824ULL, 0x002fe400078e0202ULL, 0x000000080e0f7c24ULL, 0x004fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc800078e000cULL, 0x000000103f0e7825ULL, 0x000fca00078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e517faeULL, 0x0003e8000b901c4aULL,
0x0186f0003e3e7984ULL, 0x000ea40000000800ULL, 0x000000043e187824ULL, 0x004fcc00078e023bULL,
0x018a800018187984ULL, 0x000ea40000000800ULL, 0x0000000818197c24ULL, 0x004fc8000f8e0219ULL,
0x00000100190c7825ULL, 0x000fe200078e000cULL, 0xfffffff853197812ULL, 0x000fca00078ee250ULL,
0x0000001019197824ULL, 0x000fe400078e023cULL, 0x000000103f0c7825ULL, 0x000fca00078e000cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c197faeULL, 0x0003e4000b901c4aULL,
0x000000ff1b00720cULL, 0x000fe20003f25270ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000000000bc9947ULL, 0x000fea0003800000ULL, 0x00009200ff0c7b82ULL, 0x002e620000000a00ULL,
0x00000001390e7836ULL, 0x000fe20000000000ULL, 0x000000033900780cULL, 0x000fe20003f85270ULL,
0x00000020023a7836ULL, 0x000fe20000000000ULL, 0x000000385f00720cULL, 0x0c0fe40003f64070ULL,
0x000000385f00720cULL, 0x000fe40003f24070ULL, 0x00000002ff0f7819ULL, 0x000fe4000001160eULL,
0x000000030e0e7812ULL, 0x000fc400078ec0ffULL, 0x000000010f0f7807ULL, 0x000fe40004800000ULL,
0x000000ff0e197207ULL, 0x000fc60004800000ULL, 0x0000000138387824ULL, 0x000fe400078e020fULL,
0x000000015c187824ULL, 0x000fe400078e0219ULL, 0x0000010038197824ULL, 0x000fe200078e0247ULL,
0x000000000044b947ULL, 0x000fec0002000000ULL, 0x000000030200780cULL, 0x000fe20003f24070ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x0000000243437836ULL, 0x000fd60000000000ULL,
0x0000000000301947ULL, 0x000fea0003800000ULL, 0x00008c00ff0e7b82ULL, 0x000ea20000000a00ULL,
0x00000004131b7824ULL, 0x000fe200078e0202ULL, 0x0000000543007c0cULL, 0x000fe2000bf26070ULL,
0x00009000000f7ab9ULL, 0x000fe20000000800ULL, 0x00000004023b7824ULL, 0x000fe400078e023bULL,
0x000000021b387824ULL, 0x000fc800078e00ffULL, 0x0000000f381b7c24ULL, 0x000fc8000f8e0243ULL,
0x000000041b0e7825ULL, 0x004fca00078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x18a800000e3b7faeULL, 0x0005e4000c92184aULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001190e7824ULL, 0x104fe200078e0202ULL, 0x00009400000f7ab9ULL, 0x000fe20000000800ULL,
0x000000013a0f7824ULL, 0x100fe400078e0219ULL, 0x0000000f18197c24ULL, 0x000fe2000f8e0219ULL,
0x000000090e007c0cULL, 0x000fe2000bf26070ULL, 0x00000004021b7824ULL, 0x000fe200078e0245ULL,
0x000000090f007c0cULL, 0x000fe2000bf66070ULL, 0x00000001190f7824ULL, 0x000fe400078e0202ULL,
0x000000013a197824ULL, 0x000fc400078e0219ULL, 0x000000040f0e7825ULL, 0x002fc800078e000cULL,
0x00000004190c7825ULL, 0x000fe400078e000cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x186000000e1b7faeULL, 0x0003e8000c92184aULL, 0x186800000c1b7faeULL, 0x0003e4000d92184aULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000020020d7836ULL, 0x002fe20000000000ULL,
0xfffffff802697812ULL, 0x000fe200078ec0ffULL, 0x000020001a647824ULL, 0x000fe200078e023dULL,
0x0000000702657812ULL, 0x000fe200078ec0ffULL, 0x000000ffff6b7224ULL, 0x000fe200078e00ffULL,
0xfffffff80d0d7812ULL, 0x000fe200078ec0ffULL, 0x0000200064647836ULL, 0x000fe20000000000ULL,
0x0000000769697812ULL, 0x000fe400078ef802ULL, 0x0000000865627812ULL, 0x000fc400078ef802ULL,
0x000000070d687812ULL, 0x000fce00078ef802ULL, 0x00000001690c7824ULL, 0x140fe400078e026bULL,
0x00000008690d7824ULL, 0x000fe400078e00ffULL, 0x0000000866197824ULL, 0x100fe400078e026bULL,
0x000000016b187836ULL, 0x000fe20000000000ULL, 0xfffffff80d0d7812ULL, 0x000fe200078ee20cULL,
0x0000000219197824ULL, 0x000fe400078e00ffULL, 0x0000000168717824ULL, 0x000fc400078e026bULL,
0x000000100d0d7824ULL, 0x000fe200078e0264ULL, 0x00000019021b7211ULL, 0x000fe200078fe0ffULL,
0x00000008681a7824ULL, 0x040fe400078e00ffULL, 0x0000000169517824ULL, 0x100fe400078e0218ULL,
0x000000000d0c783bULL, 0x000e620000000200ULL, 0x00000001683f7824ULL, 0x000fe200078e0218ULL,
0xfffffff81a717812ULL, 0x000fe200078ee271ULL, 0x0000002062397824ULL, 0x040fe400078e00ffULL,
0x0000000162187824ULL, 0x000fc400078e021bULL, 0x0000000219197836ULL, 0x000fe40000000000ULL,
0x00000008691a7824ULL, 0x000fe200078e00ffULL, 0xffffffe039187812ULL, 0x000fe200078ee218ULL,
0x0000000868387824ULL, 0x000fe200078e00ffULL, 0x0000001902397211ULL, 0x000fe200078fe0ffULL,
0x00000020623e7824ULL, 0x000fe200078e00ffULL, 0xfffffff81a517812ULL, 0x000fe200078ee251ULL,
0x000000026b6b7836ULL, 0x000fe20000000000ULL, 0x0000000718187c11ULL, 0x000fe2000f8e20ffULL,
0x0000000162397824ULL, 0x000fe200078e0239ULL, 0xfffffff8383f7812ULL, 0x000fc400078ee23fULL,
0x000000086b00780cULL, 0x000fe40003f25270ULL, 0xffffffe03e3e7812ULL, 0x000fe200078ee239ULL,
0x000000103f3f7824ULL, 0x000fe200078e0264ULL, 0x00000018ff1a7819ULL, 0x002fe4000001160cULL,
0x000000ff0c1b7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff197819ULL, 0x000fe4000001160dULL,
0x00000018ff527819ULL, 0x000fc4000001160eULL, 0x0000001aff1a723eULL, 0x000fe400020006ffULL,
0x0000001bff1b723eULL, 0x000fe400020006ffULL, 0x000000ff0e537812ULL, 0x040fe200078ec0ffULL,
0x2000001aff397230ULL, 0x000fe20000004100ULL, 0x00000019ff19723eULL, 0x000fe200020006ffULL,
0x2000001bff6e7230ULL, 0x000fe20000004100ULL, 0x00000010ff387819ULL, 0x000fe4000001160eULL,
0x0000ffff0e6d7812ULL, 0x000fc400078ec0ffULL, 0x00000052ff0e723eULL, 0x000fe400020006ffULL,
0x00000053ff52723eULL, 0x000fe200020006ffULL, 0x20000019ff537230ULL, 0x000fe20000004100ULL,
0x000000ff0d507812ULL, 0x000fe200078ec0ffULL, 0x000000001818783bULL, 0x000e620000000200ULL,
0x00000018ff707819ULL, 0x000fe2000001160fULL, 0x20000052ff527230ULL, 0x000fe20000004100ULL,
0x00000010ff3c7819ULL, 0x000fe4000001160cULL, 0x00000050ff50723eULL, 0x000fc400020006ffULL,
0x0000ffff0c0c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff3d7819ULL, 0x000fe2000001160dULL,
0x20000050ff6c7230ULL, 0x000fe20000004100ULL, 0x0000ffff0d6f7812ULL, 0x000fe200078ec0ffULL,
0x2000000eff507230ULL, 0x000fe20000004100ULL, 0x00000010ff3a7819ULL, 0x000fe2000001160fULL,
0x00000010710e7824ULL, 0x000fe200078e0264ULL, 0x000000ff0f0d7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff0f3b7812ULL, 0x000fc400078ec0ffULL, 0x00000070ff70723eULL, 0x000fe400020006ffULL,
0x000000ff3c0f7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff0c7819ULL, 0x000fe2000001160cULL,
0x20000070ff3c7230ULL, 0x000fe20000004100ULL, 0x0000000dff72723eULL, 0x000fe400020006ffULL,
0x000000ff3d737812ULL, 0x000fe400078ec0ffULL, 0x0000000fff71723eULL, 0x000fe200020006ffULL,
0x20000072ff3d7230ULL, 0x000fe20000004100ULL, 0x00000008ff6f7819ULL, 0x000fc4000001166fULL,
0x0000000cff70723eULL, 0x000fe200020006ffULL, 0x20000071ff727230ULL, 0x000fe20000004100ULL,
0x00000073ff74723eULL, 0x000fe200020006ffULL, 0x000000000e0c783bULL, 0x000ea20000000200ULL,
0x0000006fff73723eULL, 0x000fe200020006ffULL, 0x20000070ff717230ULL, 0x000fe20000004100ULL,
0x000000ff38387812ULL, 0x000fe200078ec0ffULL, 0x20000074ff6f7230ULL, 0x000fe20000004100ULL,
0x00000008ff6d7819ULL, 0x000fe2000001166dULL, 0x20000073ff707230ULL, 0x000fe20000004100ULL,
0x00000038ff73723eULL, 0x000fc400020006ffULL, 0x00000010ff747819ULL, 0x000fe40000011639ULL,
0x00000010ff387819ULL, 0x000fe2000001166eULL, 0x20000073ff6e7230ULL, 0x000fe20000004100ULL,
0x00000010ff397819ULL, 0x000fe40000011672ULL, 0x00000010ff717819ULL, 0x000fe40000011671ULL,
0x0000006dff6d723eULL, 0x000fe400020006ffULL, 0x0000105474397816ULL, 0x000fc40000000039ULL,
0x0000105471387816ULL, 0x000fe20000000038ULL, 0x2000006dff6d7230ULL, 0x000fe20000004100ULL,
0x000000ff3a737812ULL, 0x000fe400078ec0ffULL, 0x00000008ff717819ULL, 0x000fe4000001163bULL,
0x00000010ff727819ULL, 0x000fe20000011653ULL, 0x00000038182c723cULL, 0x002fe2000004182cULL,
0x00000010ff3a7819ULL, 0x000fe4000001166cULL, 0x00000010ff3b7819ULL, 0x000fc4000001166fULL,
0x00000010ff537819ULL, 0x000fe40000011670ULL, 0x00000010ff507819ULL, 0x000fe40000011650ULL,
0x00000010ff387819ULL, 0x000fe40000011652ULL, 0x00000010ff397819ULL, 0x000fe4000001166eULL,
0x00000010ff6d7819ULL, 0x000fe4000001166dULL, 0x00000073ff73723eULL, 0x000fc400020006ffULL,
0x00001054723b7816ULL, 0x000fe4000000003bULL, 0x00001054533a7816ULL, 0x000fe2000000003aULL,
0x20000073ff737230ULL, 0x000fe20000004100ULL, 0x0000105450397816ULL, 0x000fe40000000039ULL,
0x000010546d387816ULL, 0x000fe40000000038ULL, 0x00000071ff71723eULL, 0x000fe200020006ffULL,
0x0000003a1830723cULL, 0x000fe20000041830ULL, 0x000000ff0c507812ULL, 0x004fc400078ec0ffULL,
0x00000018ff6f7819ULL, 0x100fe2000001160cULL, 0x20000071ff717230ULL, 0x000fe20000004100ULL,
0x00000010ff727819ULL, 0x000fe2000001160cULL, 0x000000381834723cULL, 0x000fe20000041834ULL,
0x00000010ff3a7819ULL, 0x000fe4000001163cULL, 0x00000010ff3c7819ULL, 0x000fe4000001163dULL,
0x00000010ff3d7819ULL, 0x000fe40000011673ULL, 0x0000001051387824ULL, 0x000fe200078e0264ULL,
0x00000010ff717819ULL, 0x000fc40000011671ULL, 0x000010543a3d7816ULL, 0x000fe4000000003dULL,
0x0000ffff0c517812ULL, 0x000fe200078ec0ffULL, 0x000000003838783bULL, 0x000e620000000200ULL,
0x00000050ff50723eULL, 0x000fe400020006ffULL, 0x00000018ff0c7819ULL, 0x000fe4000001160dULL,
0x00000018ff747819ULL, 0x000fe4000001160eULL, 0x000000ff0f737812ULL, 0x000fc400078ec0ffULL,
0x00001054713c7816ULL, 0x000fe4000000003cULL, 0x00000010ff717819ULL, 0x000fe4000001160dULL,
0x00000010ff527819ULL, 0x000fe4000001160eULL, 0x000000ff0e757812ULL, 0x040fe200078ec0ffULL,
0x0000003c1828723cULL, 0x000fe20000041828ULL, 0x0000ffff0e707812ULL, 0x000fe400078ec0ffULL,
0x0000000cff6d723eULL, 0x000fe200020006ffULL, 0x20000050ff0c7230ULL, 0x000fe20000004100ULL,
0x000000ff72727812ULL, 0x000fc400078ec0ffULL, 0x00000074ff0e723eULL, 0x000fe200020006ffULL,
0x2000006dff6d7230ULL, 0x000fe20000004100ULL, 0x00000073ff74723eULL, 0x000fe400020006ffULL,
0x00000008ff507819ULL, 0x000fe20000011651ULL, 0x2000000eff0e7230ULL, 0x000fe20000004100ULL,
0x00000072ff72723eULL, 0x000fe400020006ffULL, 0x000000ff71717812ULL, 0x000fe400078ec0ffULL,
0x00000050ff73723eULL, 0x000fe200020006ffULL, 0x20000074ff507230ULL, 0x000fe20000004100ULL,
0x000000ff0d6c7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff0d6e7812ULL, 0x000fe200078ec0ffULL,
0x20000073ff737230ULL, 0x000fe20000004100ULL, 0x00000010ff0d7819ULL, 0x100fe4000001160fULL,
0x00000071ff74723eULL, 0x000fe200020006ffULL, 0x20000072ff717230ULL, 0x000fe20000004100ULL,
0x0000ffff0f537812ULL, 0x000fe400078ec0ffULL, 0x0000006fff6f723eULL, 0x000fe400020006ffULL,
0x00000018ff767819ULL, 0x000fc4000001160fULL, 0x000000ff52727812ULL, 0x000fe200078ec0ffULL,
0x2000006fff6f7230ULL, 0x000fe20000004100ULL, 0x00000008ff527819ULL, 0x000fe20000011670ULL,
0x20000074ff707230ULL, 0x000fe20000004100ULL, 0x000000ff0d3c7812ULL, 0x000fe400078ec0ffULL,
0x00000075ff0f723eULL, 0x000fe400020006ffULL, 0x00000008ff0d7819ULL, 0x000fe40000011653ULL,
0x00000076ff76723eULL, 0x000fe200020006ffULL, 0x2000000fff0f7230ULL, 0x000fe20000004100ULL,
0x00000072ff75723eULL, 0x000fc400020006ffULL, 0x00000052ff72723eULL, 0x000fe200020006ffULL,
0x20000076ff517230ULL, 0x000fe20000004100ULL, 0x0000000dff3d723eULL, 0x000fe200020006ffULL,
0x20000075ff527230ULL, 0x000fe20000004100ULL, 0x00000018ff747819ULL, 0x002fe20000011638ULL,
0x20000072ff537230ULL, 0x000fe20000004100ULL, 0x00000008ff6e7819ULL, 0x000fe4000001166eULL,
0x00000010ff767819ULL, 0x000fe4000001166fULL, 0x00000010ff0d7819ULL, 0x000fe20000011671ULL,
0x2000003dff717230ULL, 0x000fe20000004100ULL, 0x0000003cff72723eULL, 0x000fc400020006ffULL,
0x00000074ff3c723eULL, 0x000fe400020006ffULL, 0x00000018ff6f7819ULL, 0x000fe20000011639ULL,
0x20000072ff727230ULL, 0x000fe20000004100ULL, 0x0000006cff6c723eULL, 0x000fe400020006ffULL,
0x0000006eff6e723eULL, 0x000fe400020006ffULL, 0x00000010ff0c7819ULL, 0x000fe2000001160cULL,
0x2000006cff6c7230ULL, 0x000fe20000004100ULL, 0x00000010ff737819ULL, 0x000fe20000011673ULL,
0x2000006eff6e7230ULL, 0x000fe20000004100ULL, 0x00000010ff3d7819ULL, 0x000fc40000011670ULL,
0x00001054760d7816ULL, 0x000fe4000000000dULL, 0x00000010ff707819ULL, 0x000fe40000011638ULL,
0x00000010ff767819ULL, 0x000fe4000001166dULL, 0x0000006fff6d723eULL, 0x000fe200020006ffULL,
0x2000003cff6f7230ULL, 0x000fe20000004100ULL, 0x000000ff38747812ULL, 0x000fe400078ec0ffULL,
0x00001054730c7816ULL, 0x000fe2000000000cULL, 0x2000006dff6d7230ULL, 0x000fe20000004100ULL,
0x000000ff39737812ULL, 0x000fc400078ec0ffULL, 0x000000ff703c7812ULL, 0x000fe400078ec0ffULL,
0x00001054763d7816ULL, 0x000fe2000000003dULL, 0x0000000c1824723cULL, 0x000fe20000041824ULL,
0x00000074ff74723eULL, 0x000fe400020006ffULL, 0x0000ffff38767812ULL, 0x000fe400078ec0ffULL,
0x00000073ff75723eULL, 0x000fe200020006ffULL, 0x20000074ff707230ULL, 0x000fe20000004100ULL,
0x0000003cff38723eULL, 0x000fc400020006ffULL, 0x00000010ff3c7819ULL, 0x000fe4000001166cULL,
0x00000010ff737819ULL, 0x000fe2000001166eULL, 0x20000075ff6e7230ULL, 0x000fe20000004100ULL,
0x00000008ff747819ULL, 0x000fe20000011676ULL, 0x20000038ff387230ULL, 0x000fe20000004100ULL,
0x00001054733c7816ULL, 0x000fe4000000003cULL, 0x000000073e767c11ULL, 0x000fe4000f8e20ffULL,
0x00000010ff757819ULL, 0x000fc4000001160eULL, 0x00000010ff3e7819ULL, 0x000fe2000001160fULL,
0x0000003c1820723cULL, 0x000fe20000041820ULL, 0x00000010ff527819ULL, 0x000fe20000011652ULL,
0x00000000760c783bULL, 0x000e620000000200ULL, 0x00000010ff737819ULL, 0x000fe40000011653ULL,
0x0000105475537816ULL, 0x000fe40000000052ULL, 0x0000105473527816ULL, 0x000fe4000000003eULL,
0x000000003f3c783bULL, 0x000ea20000000200ULL, 0x00000074ff6c723eULL, 0x000fc400020006ffULL,
0x00000010ff747819ULL, 0x000fe40000011651ULL, 0x00000010ff517819ULL, 0x000fe20000011672ULL,
0x2000006cff6c7230ULL, 0x000fe20000004100ULL, 0x00000010ff727819ULL, 0x000fe20000011639ULL,
0x00000052181c723cULL, 0x000fe2000004181cULL, 0x0000ffff39397812ULL, 0x000fe400078ec0ffULL,
0x00000010ff507819ULL, 0x000fe40000011650ULL, 0x00000010ff717819ULL, 0x000fc40000011671ULL,
0x000000ff72727812ULL, 0x000fe400078ec0ffULL, 0x00000008ff397819ULL, 0x000fe40000011639ULL,
0x0000105474517816ULL, 0x000fe40000000051ULL, 0x0000105471507816ULL, 0x000fe40000000050ULL,
0x00000072ff72723eULL, 0x000fe400020006ffULL, 0x00000039ff39723eULL, 0x000fc400020006ffULL,
0x00000018ff737819ULL, 0x000fe2000001163aULL, 0x000000501814723cULL, 0x000fe20000041814ULL,
0x20000072ff727230ULL, 0x000fe20000004100ULL, 0x000000ff3a717812ULL, 0x000fe200078ec0ffULL,
0x20000039ff397230ULL, 0x000fe20000004100ULL, 0x00000073ff73723eULL, 0x000fe400020006ffULL,
0x00000071ff71723eULL, 0x000fe400020006ffULL, 0x00000010ff187819ULL, 0x000fe2000001166fULL,
0x20000073ff737230ULL, 0x000fe20000004100ULL, 0x00000010ff1a7819ULL, 0x000fe20000011670ULL,
0x20000071ff717230ULL, 0x000fe20000004100ULL, 0x00000010ff1b7819ULL, 0x000fc40000011638ULL,
0x00000010ff197819ULL, 0x000fe4000001166cULL, 0x00001054181b7816ULL, 0x000fe4000000001bULL,
0x00001054191a7816ULL, 0x000fe4000000001aULL, 0x00000010ff387819ULL, 0x000fe4000001166dULL,
0x00000010ff187819ULL, 0x000fe4000001166eULL, 0x00000010ff197819ULL, 0x000fe20000011672ULL,
0x0000001a0c2c723cULL, 0x002fe2000004182cULL, 0x00000010ff397819ULL, 0x000fc40000011639ULL,
0x0000105438197816ULL, 0x000fe40000000019ULL, 0x0000105439187816ULL, 0x000fe40000000018ULL,
0x00000010ff507819ULL, 0x000fe4000001163aULL, 0x0000ffff3a397812ULL, 0x000fe400078ec0ffULL,
0x00000018ff3a7819ULL, 0x000fe2000001163bULL, 0x000000180c30723cULL, 0x000fe20000041830ULL,
0x00000018ff527819ULL, 0x004fc4000001163cULL, 0x00000018ff747819ULL, 0x000fe4000001163eULL,
0x00000010ff1a7819ULL, 0x000fe4000001163bULL, 0x00000018ff187819ULL, 0x000fe4000001163dULL,
0x00000010ff707819ULL, 0x000fe4000001163cULL, 0x000000ff3c767812ULL, 0x040fe400078ec0ffULL,
0x0000ffff3c727812ULL, 0x000fc400078ec0ffULL, 0x00000010ff6f7819ULL, 0x000fe4000001163dULL,
0x000000ff3d757812ULL, 0x040fe400078ec0ffULL, 0x0000ffff3d6d7812ULL, 0x000fe400078ec0ffULL,
0x000000ff3b387812ULL, 0x040fe400078ec0ffULL, 0x0000ffff3b1b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff537819ULL, 0x000fc4000001163fULL, 0x00000018ff3d7819ULL, 0x000fe4000001163fULL,
0x000000ff3f3c7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff3f517812ULL, 0x000fe400078ec0ffULL,
0x0000003aff19723eULL, 0x000fe400020006ffULL, 0x000000ff50507812ULL, 0x000fe400078ec0ffULL,
0x00000010ff6c7819ULL, 0x000fe2000001163eULL, 0x20000019ff197230ULL, 0x000fe20000004100ULL,
0x000000ff3e3b7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff3e6e7812ULL, 0x000fe400078ec0ffULL,
0x00000052ff3a723eULL, 0x000fe400020006ffULL, 0x00000074ff3f723eULL, 0x000fe400020006ffULL,
0x00000008ff397819ULL, 0x000fe40000011639ULL, 0x00000018ff3e723eULL, 0x000fe200020006ffULL,
0x2000003aff187230ULL, 0x000fe20000004100ULL, 0x000000ff1a747812ULL, 0x000fe200078ec0ffULL,
0x2000003fff3f7230ULL, 0x000fe20000004100ULL, 0x00000075ff75723eULL, 0x000fe200020006ffULL,
0x2000003eff3a7230ULL, 0x000fe20000004100ULL, 0x00000050ff50723eULL, 0x000fc400020006ffULL,
0x00000039ff1a723eULL, 0x000fe400020006ffULL, 0x00000008ff397819ULL, 0x000fe2000001161bULL,
0x20000050ff1b7230ULL, 0x000fe20000004100ULL, 0x00000074ff74723eULL, 0x000fe200020006ffULL,
0x2000001aff1a7230ULL, 0x000fe20000004100ULL, 0x0000003bff3e723eULL, 0x000fe200020006ffULL,
0x20000075ff3b7230ULL, 0x000fe20000004100ULL, 0x00000008ff727819ULL, 0x000fe40000011672ULL,
0x0000003cff75723eULL, 0x000fe200020006ffULL, 0x2000003eff3c7230ULL, 0x000fe20000004100ULL,
0x00000039ff50723eULL, 0x000fe200020006ffULL, 0x20000074ff397230ULL, 0x000fe20000004100ULL,
0x000000ff6f747812ULL, 0x000fe200078ec0ffULL, 0x20000075ff3e7230ULL, 0x000fe20000004100ULL,
0x00000072ff72723eULL, 0x000fe200020006ffULL, 0x20000050ff6f7230ULL, 0x000fe20000004100ULL,
0x00000008ff6d7819ULL, 0x000fc4000001166dULL, 0x00000008ff6e7819ULL, 0x000fe4000001166eULL,
0x00000074ff50723eULL, 0x000fe400020006ffULL, 0x000000ff6c757812ULL, 0x000fe200078ec0ffULL,
0x20000072ff6c7230ULL, 0x000fe20000004100ULL, 0x0000006dff74723eULL, 0x000fe200020006ffULL,
0x20000050ff6d7230ULL, 0x000fe20000004100ULL, 0x0000006eff72723eULL, 0x000fe400020006ffULL,
0x000000ff536e7812ULL, 0x000fe200078ec0ffULL, 0x20000074ff537230ULL, 0x000fe20000004100ULL,
0x00000038ff38723eULL, 0x000fc400020006ffULL, 0x00000010ff507819ULL, 0x000fe40000011673ULL,
0x00000010ff1b7819ULL, 0x000fe2000001161bULL, 0x20000038ff527230ULL, 0x000fe20000004100ULL,
0x00000010ff717819ULL, 0x000fe40000011671ULL, 0x00000010ff1a7819ULL, 0x000fe4000001161aULL,
0x0000006eff74723eULL, 0x000fe400020006ffULL, 0x00001054501b7816ULL, 0x000fe2000000001bULL,
0x20000072ff507230ULL, 0x000fe20000004100ULL, 0x000010541a1a7816ULL, 0x000fc40000000071ULL,
0x00000008ff737819ULL, 0x000fe20000011651ULL, 0x20000074ff517230ULL, 0x000fe20000004100ULL,
0x000000ff70707812ULL, 0x000fe400078ec0ffULL, 0x00000010ff727819ULL, 0x000fe20000011619ULL,
0x0000001a0c34723cULL, 0x000fe20000041834ULL, 0x00000010ff747819ULL, 0x000fe40000011618ULL,
0x00000010ff717819ULL, 0x000fe40000011652ULL, 0x00000010ff197819ULL, 0x000fc40000011639ULL,
0x00000010ff187819ULL, 0x000fe4000001166fULL, 0x00000076ff76723eULL, 0x000fe400020006ffULL,
0x0000003dff3d723eULL, 0x000fe400020006ffULL, 0x00000070ff70723eULL, 0x000fe200020006ffULL,
0x20000076ff387230ULL, 0x000fe20000004100ULL, 0x00000075ff75723eULL, 0x000fe200020006ffULL,
0x2000003dff3d7230ULL, 0x000fe20000004100ULL, 0x00000073ff73723eULL, 0x000fe200020006ffULL,
0x20000070ff707230ULL, 0x000fe20000004100ULL, 0x0000105472197816ULL, 0x000fe20000000019ULL,
0x20000075ff6e7230ULL, 0x000fe20000004100ULL, 0x0000105418187816ULL, 0x000fe20000000071ULL,
0x20000073ff527230ULL, 0x000fe20000004100ULL, 0x00000010ff1a7819ULL, 0x000fc4000001163aULL,
0x00000010ff3a7819ULL, 0x000fe4000001163bULL, 0x00000010ff3b7819ULL, 0x000fe2000001166dULL,
0x000000180c28723cULL, 0x000fe20000041828ULL, 0x00000010ff387819ULL, 0x000fe40000011638ULL,
0x000010541a3b7816ULL, 0x000fe4000000003bULL, 0x00000010ff1a7819ULL, 0x000fe4000001163cULL,
0x00000010ff1b7819ULL, 0x000fc4000001166cULL, 0x00000010ff3c7819ULL, 0x000fe4000001163dULL,
0x00000010ff197819ULL, 0x000fe40000011650ULL, 0x00000010ff397819ULL, 0x000fe40000011670ULL,
0x00000010ff3f7819ULL, 0x000fe4000001163fULL, 0x00000010ff537819ULL, 0x000fe40000011653ULL,
0x00000010ff6e7819ULL, 0x000fc4000001166eULL, 0x00000010ff517819ULL, 0x000fe40000011651ULL,
0x00000010ff187819ULL, 0x000fe4000001163eULL, 0x00000010ff3d7819ULL, 0x000fe40000011652ULL,
0x000010541b387816ULL, 0x000fe40000000038ULL, 0x00001054191a7816ULL, 0x000fe4000000001aULL,
0x0000105474397816ULL, 0x000fc40000000039ULL, 0x00001054533a7816ULL, 0x000fe4000000003aULL,
0x000010543f1b7816ULL, 0x000fe4000000006eULL, 0x000010543c197816ULL, 0x000fe20000000051ULL,
0x000000380c24723cULL, 0x000fe20000041824ULL, 0x000010543d187816ULL, 0x000fca0000000018ULL,
0x0000003a0c20723cULL, 0x000fec0000041820ULL, 0x0000001a0c1c723cULL, 0x000fec000004181cULL,
0x000000180c14723cULL, 0x000fe20000041814ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0xffffffe800201947ULL, 0x000fde000383ffffULL, 0x000000ffff1a7224ULL, 0x000fe200078e0006ULL,
0xffffffc0004c8947ULL, 0x000fec000383ffffULL, 0x00000002ff0c7819ULL, 0x000fc80000011602ULL,
0x000000040c007c0cULL, 0x000fe2000bf06070ULL, 0x0000000104047890ULL, 0x000fcc000fffe03fULL,
0x000000040c007c0cULL, 0x000fe2000c706470ULL, 0x000000080c0c7836ULL, 0x000fc60000000000ULL,
0x000000445f00720cULL, 0x000fe40000703070ULL, 0x000000060c007c0cULL, 0x000fc8000bf26070ULL,
0x000000040c007c0cULL, 0x000fc80008f21070ULL, 0x000000445f00720cULL, 0x000fc60000f24470ULL,
0x000000ffff5b8224ULL, 0x000fe200078e0015ULL, 0x0000005e175e7208ULL, 0x000fe20000800000ULL,
0x000000ffff588224ULL, 0x000fe200078e0014ULL, 0x0000006316637208ULL, 0x000fe20000800000ULL,
0x000000ffff598224ULL, 0x000fe200078e001dULL, 0x0000005a1f5a7208ULL, 0x000fe20000800000ULL,
0x000000ffff568224ULL, 0x000fe200078e001cULL, 0x0000005d1e5d7208ULL, 0x000fe20000800000ULL,
0x000000ffff578224ULL, 0x000fe200078e0021ULL, 0x0000000823087208ULL, 0x000fe20000800000ULL,
0x000000ffff548224ULL, 0x000fe200078e0020ULL, 0x0000000722077208ULL, 0x000fe20000800000ULL,
0x000000ffff558224ULL, 0x000fe200078e0025ULL, 0x0000000a270a7208ULL, 0x000fe20000800000ULL,
0x000000ffff4e8224ULL, 0x000fe200078e0024ULL, 0x0000000926097208ULL, 0x000fe20000800000ULL,
0x000000ffff4f8224ULL, 0x000fe200078e0029ULL, 0x000000102b107208ULL, 0x000fe20000800000ULL,
0x000000ffff4c8224ULL, 0x000fe200078e0028ULL, 0x0000000b2a0b7208ULL, 0x000fe20000800000ULL,
0x000000ffff4d8224ULL, 0x000fe200078e0035ULL, 0x0000001237127208ULL, 0x000fe20000800000ULL,
0x000000ffff4a8224ULL, 0x000fe200078e0034ULL, 0x0000001136117208ULL, 0x000fe20000800000ULL,
0x000000ffff4b8224ULL, 0x000fe200078e0031ULL, 0x0000004033407208ULL, 0x000fe20000800000ULL,
0x000000ffff488224ULL, 0x000fe200078e0030ULL, 0x0000004132417208ULL, 0x000fe20000800000ULL,
0x000000ffff498224ULL, 0x000fe200078e002dULL, 0x000000422f427208ULL, 0x000fe20000800000ULL,
0x000000ffff468224ULL, 0x000fe200078e002cULL, 0x0000000467007c0cULL, 0x000fc4000bf03070ULL,
0x000000052e057208ULL, 0x000fd60000800000ULL, 0xffffffbc00548947ULL, 0x000fea000383ffffULL,
0x00000001ff0e7424ULL, 0x000fe400078e00ffULL, 0x0000000e460d7c20ULL, 0x000fe20008410000ULL,
0x0000000e49497c20ULL, 0x000fe20008410000ULL, 0x0000000e48487c20ULL, 0x000fe20008410000ULL,
0x0000000e4b4b7c20ULL, 0x000fe20008410000ULL, 0x0000000e4a4a7c20ULL, 0x000fe20008410000ULL,
0x018b580e030e79a7ULL, 0x000e62000850003fULL, 0x0000000e4d4d7c20ULL, 0x000fe20008410000ULL,
0x0000000e4c4c7c20ULL, 0x000fe20008410000ULL, 0x0000000e4f4f7c20ULL, 0x000fe20008410000ULL,
0x0000000e4e4e7c20ULL, 0x000fe20008410000ULL, 0x0000000e55557c20ULL, 0x000fe20008410000ULL,
0x0000000e54547c20ULL, 0x000fe20008410000ULL, 0x0000000e57577c20ULL, 0x000fe20008410000ULL,
0x0000000e56567c20ULL, 0x000fe20008410000ULL, 0x0000000e59597c20ULL, 0x000fe20008410000ULL,
0x0000000e58587c20ULL, 0x000fe20008410000ULL, 0x0000000e5b5b7c20ULL, 0x000fe20008410000ULL,
0x0000000e050c7c20ULL, 0x000fe20008410000ULL, 0x0000000e42427c20ULL, 0x000fe20008410000ULL,
0x0000000e41417c20ULL, 0x000fe20008410000ULL, 0x0000000e40407c20ULL, 0x000fe20008410000ULL,
0x0000000e11117c20ULL, 0x000fe20008410000ULL, 0x0000000e12127c20ULL, 0x000fe20008410000ULL,
0x0000000e0b0b7c20ULL, 0x000fe20008410000ULL, 0x0000000e10107c20ULL, 0x000fe20008410000ULL,
0x0000000e09097c20ULL, 0x000fe20008410000ULL, 0x0000000e0a0a7c20ULL, 0x000fe20008410000ULL,
0x0000000e07077c20ULL, 0x000fe20008410000ULL, 0x0000000e08087c20ULL, 0x000fe20008410000ULL,
0x000000ffff167224ULL, 0x002fc400078e000fULL, 0x0000000e5d5d7c20ULL, 0x000fe20008410000ULL,
0x0000000e5a5a7c20ULL, 0x000fe20008410000ULL, 0x0000000e63637c20ULL, 0x000fe20008410000ULL,
0x0000000e5e5e7c20ULL, 0x000fe20008410000ULL, 0x00000000000e7805ULL, 0x000fe20000015200ULL,
0x018b5816030075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff177224ULL, 0x000fce00078e00ffULL, 0x000000101700780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x000000140e147210ULL, 0x000fca0007f1e1ffULL, 0x0000000115157824ULL, 0x000fe200000e0e0fULL,
0x003d09001400780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401400780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff057819ULL, 0x000fc80000011415ULL, 0x0000001405057211ULL, 0x000fca00078110ffULL,
0x000000ffff147224ULL, 0x000fca00000e0615ULL, 0x0000000205057819ULL, 0x000fc80000001214ULL,
0x000000050000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000117177836ULL, 0x000fce0000000000ULL, 0x018b5816030075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000402057824ULL, 0x000fe200078e00ffULL,
0x0000000761307c11ULL, 0x000fe4000f8e38ffULL, 0x0000000d44007c0cULL, 0x000fe4000bf05270ULL,
0xfffffff005057812ULL, 0x000fca00078ec0ffULL, 0x0000000130307824ULL, 0x000fca00078e0205ULL,
0x01840000301c7984ULL, 0x0002a20000000c00ULL, 0x0000000400080947ULL, 0x000fea0003800000ULL,
0x0000000202057824ULL, 0x000fe200078e00ffULL, 0x0000000960607c10ULL, 0x000fc8000fffe1ffULL,
0x0000000605057812ULL, 0x000fc800078ec0ffULL, 0x00000001050f7812ULL, 0x040fe400078efcffULL,
0x0000000805157812ULL, 0x000fe400078efcffULL, 0x000000600f00720cULL, 0x080fe40003f26070ULL,
0x00000010050f7812ULL, 0x000fe400078efcffULL, 0x000000601500720cULL, 0x080fe40003f06070ULL,
0x000000600f00720cULL, 0x000fc40003fc6070ULL, 0x0000001105157812ULL, 0x040fe400078efcffULL,
0x00000018050f7812ULL, 0x040fe400078efcffULL, 0x000000600500720cULL, 0x080fe40003f46070ULL,
0x000000601500720cULL, 0x080fe40003fa6070ULL, 0x000000600f00720cULL, 0x000fe40003f66070ULL,
0x0000000905177812ULL, 0x000fc400078efcffULL, 0x0000001905157812ULL, 0x040fe400078efcffULL,
0x00000020050f7812ULL, 0x000fe400078efcffULL, 0xff8000000c0c7808ULL, 0x000fe40005000000ULL,
0xff8000000d0d7808ULL, 0x000fe40005000000ULL, 0xff80000042427808ULL, 0x000fe40004800000ULL,
0xff80000049497808ULL, 0x000fc40004800000ULL, 0x000000601700720cULL, 0x080fe40003f86070ULL,
0x000000601500720cULL, 0x080fe40003f46070ULL, 0x000000600f00720cULL, 0x000fe40003f26070ULL,
0x0000002105157812ULL, 0x040fe400078efcffULL, 0x00000028050f7812ULL, 0x000fe400078efcffULL,
0xff80000041417808ULL, 0x000fc40004000000ULL, 0xff80000048487808ULL, 0x000fe40004000000ULL,
0xff80000040407808ULL, 0x000fe40006000000ULL, 0xff8000004b4b7808ULL, 0x000fe40006000000ULL,
0x000000601500720cULL, 0x080fe40003f06070ULL, 0x000000600f00720cULL, 0x000fe40003f86070ULL,
0x0000002905157812ULL, 0x000fc400078efcffULL, 0x00000030050f7812ULL, 0x000fe400078efcffULL,
0xff80000011117808ULL, 0x000fe40007000000ULL, 0xff8000004a4a7808ULL, 0x000fe40007000000ULL,
0xff80000012127808ULL, 0x000fe40006800000ULL, 0xff8000004d4d7808ULL, 0x000fe40006800000ULL,
0x000000601500720cULL, 0x000fc40003fc6070ULL, 0x000000600f00720cULL, 0x000fe40003fa6070ULL,
0x0000003105157812ULL, 0x040fe400078efcffULL, 0x00000038050f7812ULL, 0x040fe400078efcffULL,
0x0000003905057812ULL, 0x000fe400078efcffULL, 0xff8000000b0b7808ULL, 0x000fe40005800000ULL,
0xff8000004c4c7808ULL, 0x000fc40005800000ULL, 0xff80000010107808ULL, 0x000fe40005000000ULL,
0xff8000004f4f7808ULL, 0x000fe40005000000ULL, 0xff80000009097808ULL, 0x000fe40004800000ULL,
0xff8000004e4e7808ULL, 0x000fe40004800000ULL, 0x000000601500720cULL, 0x080fe40003f66070ULL,
0x000000600f00720cULL, 0x000fc40003f46070ULL, 0x000000600500720cULL, 0x000fe40003f26070ULL,
0xff8000000a0a7808ULL, 0x000fe40004000000ULL, 0xff80000055557808ULL, 0x000fe40004000000ULL,
0xff80000007077808ULL, 0x000fe40006000000ULL, 0xff80000054547808ULL, 0x000fe40006000000ULL,
0xff80000008087808ULL, 0x000fc40007000000ULL, 0xff80000057577808ULL, 0x000fe40007000000ULL,
0xff8000005d5d7808ULL, 0x000fe40006800000ULL, 0xff80000056567808ULL, 0x000fe40006800000ULL,
0xff8000005a5a7808ULL, 0x000fe40005800000ULL, 0xff80000059597808ULL, 0x000fe40005800000ULL,
0xff80000063637808ULL, 0x000fc40005000000ULL, 0xff80000058587808ULL, 0x000fe40005000000ULL,
0xff8000005e5e7808ULL, 0x000fe40004800000ULL, 0xff8000005b5b7808ULL, 0x000fce0004800000ULL,
0x0000000d1c00720bULL, 0x004fe20003f1e000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0x0c401f001e257f89ULL, 0x000fe200000e0000ULL, 0x00000007612a7c11ULL, 0x000fe2000f8e58ffULL,
0x0000000144447836ULL, 0x000fe20000000000ULL, 0x0000001c0d1c7208ULL, 0x000fe20004000000ULL,
0x0c401f001f247f89ULL, 0x000fe400000e0000ULL, 0x000120002a357836ULL, 0x000fe20000000000ULL,
0x000000491c00720bULL, 0x000fc80003f1e000ULL, 0x0000001c49057208ULL, 0x000fe20004000000ULL,
0x00000004ff1c7e24ULL, 0x000fc6000f8e00ffULL, 0x000000480500720bULL, 0x000fe40003f1e000ULL,
0x3f8000001c1c783eULL, 0x000fe400000010ffULL, 0x00000005480e7208ULL, 0x000fc80004000000ULL,
0x0000004b0e00720bULL, 0x000fc80003f1e000ULL, 0x0000000e4b057208ULL, 0x000fc80004000000ULL,
0x0000004a0500720bULL, 0x000fc80003f1e000ULL, 0x000000054a0e7208ULL, 0x000fc80004000000ULL,
0x0000004d0e00720bULL, 0x000fc80003f1e000ULL, 0x0000000e4d057208ULL, 0x000fc80004000000ULL,
0x0000004c0500720bULL, 0x000fc80003f1e000ULL, 0x000000054c0e7208ULL, 0x000fc80004000000ULL,
0x0000004f0e00720bULL, 0x000fc80003f1e000ULL, 0x0000000e4f057208ULL, 0x000fc80004000000ULL,
0x0000004e0500720bULL, 0x000fc80003f1e000ULL, 0x000000054e0e7208ULL, 0x000fc80004000000ULL,
0x000000550e00720bULL, 0x000fc80003f1e000ULL, 0x0000000e55057208ULL, 0x000fc80004000000ULL,
0x000000540500720bULL, 0x000fc80003f1e000ULL, 0x00000005540e7208ULL, 0x000fe40004000000ULL,
0x0000000c1d00720bULL, 0x000fe40003f1e000ULL, 0x000000570e00720bULL, 0x000fe40003f3e000ULL,
0x0000001d0c1d7208ULL, 0x000fe40004000000ULL, 0x0000000e57057208ULL, 0x000fe40004800000ULL,
0x000000421d00720bULL, 0x000fc40003f1e000ULL, 0x000000560500720bULL, 0x000fe40003f3e000ULL,
0x0000001d420e7208ULL, 0x000fe20004000000ULL, 0x000000ffff1d7224ULL, 0x000fe200078e001cULL,
0x0000000556147208ULL, 0x000fe40004800000ULL, 0x000000410e00720bULL, 0x000fe40003f1e000ULL,
0x000000591400720bULL, 0x000fe40003f3e000ULL, 0x0000000e41057208ULL, 0x000fc40004000000ULL,
0x00000014590f7208ULL, 0x000fe40004800000ULL, 0x000000400500720bULL, 0x000fe40003f1e000ULL,
0x000000580f00720bULL, 0x000fe40003f3e000ULL, 0x00000005400e7208ULL, 0x000fe40004000000ULL,
0x0000000f58147208ULL, 0x000fe40004800000ULL, 0x000000110e00720bULL, 0x000fc40003f1e000ULL,
0x0000005b1400720bULL, 0x000fe40003f3e000ULL, 0x0000000e11057208ULL, 0x000fe40004000000ULL,
0x000000145b147208ULL, 0x000fe40004800000ULL, 0x000000120500720bULL, 0x000fc60003f1e000ULL,
0x0c401f00140f7f89ULL, 0x000ea200000e0000ULL, 0x00000005120e7208ULL, 0x000fc80004000000ULL,
0x0000000b0e00720bULL, 0x000fc80003f1e000ULL, 0x0000000e0b057208ULL, 0x000fc80004000000ULL,
0x000000100500720bULL, 0x000fc80003f1e000ULL, 0x00000005100e7208ULL, 0x000fc80004000000ULL,
0x000000090e00720bULL, 0x000fe40003f1e000ULL, 0x0000000f1400720bULL, 0x004fe40003f3e000ULL,
0x0000000e09057208ULL, 0x000fe40004000000ULL, 0x000000140f0f7208ULL, 0x000fe40004800000ULL,
0x0000000a0500720bULL, 0x000fc60003f1e000ULL, 0x0c201f000f2c7f89ULL, 0x000ea200000e0000ULL,
0x000000050a0e7208ULL, 0x000fc80004000000ULL, 0x000000070e00720bULL, 0x000fc80003f1e000ULL,
0x0000000e07057208ULL, 0x000fc80004000000ULL, 0x000000080500720bULL, 0x000fc80003f1e000ULL,
0x00000005080e7208ULL, 0x000fc80004000000ULL, 0x0000005d0e00720bULL, 0x000fe40003f1e000ULL,
0x0000002c0f00720bULL, 0x004fe40003f3e000ULL, 0x0000000e5d057208ULL, 0x000fe40004000000ULL,
0x0000000f2c2c7208ULL, 0x000fe40004800000ULL, 0x0000005a0500720bULL, 0x000fe40003f1e000ULL,
0x000000241f00720bULL, 0x000fe20003f3e000ULL, 0x3fb8aa3b2c147820ULL, 0x000fe20000410000ULL,
0x000000055a0e7208ULL, 0x000fc40004000000ULL, 0x0000001f242f7208ULL, 0x000fe20004800000ULL,
0x3fb8aa3b49497823ULL, 0x100fe20000010814ULL, 0x000000630e00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b48487823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b4b4b7823ULL, 0x100fe20000010814ULL,
0x3fb8aa3b0d0d7823ULL, 0x100fe20000010814ULL, 0x0000000e63057208ULL, 0x000fe20004000000ULL,
0x0000004900497308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b4a4a7823ULL, 0x100fe20000010814ULL,
0x3fb8aa3b4d4d7823ULL, 0x100fe20000010814ULL, 0x0000005e0500720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b4c4c7823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b4f4f7823ULL, 0x100fe20000010814ULL,
0x3fb8aa3b4e4e7823ULL, 0x100fe20000010814ULL, 0x000000055e057208ULL, 0x000fe20004000000ULL,
0x0000000d00467308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b55557823ULL, 0x100fe20000010814ULL,
0x3fb8aa3b54547823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b57577823ULL, 0x100fe20000010814ULL,
0x0c401f00050e7f89ULL, 0x000ea200000e0000ULL, 0x3fb8aa3b56567823ULL, 0x100fe20000010814ULL,
0x3fb8aa3b59597823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b58587823ULL, 0x100fe20000010814ULL,
0x0000004800487308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b5b5b7823ULL, 0x000fe20000010814ULL,
0x00000003ff1f7819ULL, 0x000fe20000011602ULL, 0x0c201f002f327f89ULL, 0x000eea00000e0000ULL,
0x0000004b004b7308ULL, 0x000ff00000000800ULL, 0x0000004a004a7308ULL, 0x000fe20000000800ULL,
0x0000000e0500720bULL, 0x004fc80003f1e000ULL, 0x000000050e057208ULL, 0x000fc60004000000ULL,
0x0000004d004d7308ULL, 0x000ea20000000800ULL, 0x000000322f00720bULL, 0x008fe20003f3e000ULL,
0x0c201f00050e7f89ULL, 0x000ee600000e0000ULL, 0x0000002f322f7208ULL, 0x000fc60004800000ULL,
0x0000004c004c7308ULL, 0x000fe20000000800ULL, 0x0000004a4d14723eULL, 0x004fce00000010ffULL,
0x0000004f004f7308ULL, 0x000eb00000000800ULL, 0x0000004e004e7308ULL, 0x000fe20000000800ULL,
0x0000000e0500720bULL, 0x008fe40003f1e000ULL, 0x0000004c4f16723eULL, 0x004fca00000010ffULL,
0x0000005500557308ULL, 0x000ea20000000800ULL, 0x000000050e2d7208ULL, 0x000fe40004000000ULL,
0x000000484b0e723eULL, 0x000fe400000010ffULL, 0x000000251e00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b2d277820ULL, 0x000fe40000410000ULL, 0x0000005400547308ULL, 0x000fe20000000800ULL,
0x0000001e252e7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b0c057823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b42427823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b41417823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b40407823ULL, 0x100fe20000010827ULL, 0x00000046490c723eULL, 0x000fe200000010ffULL,
0x3fb8aa3b11117823ULL, 0x100fe20000010827ULL, 0x0000000500057308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b12127823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b0b0b7823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b10107823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b09097823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b0a0a7823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b07077823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b08087823ULL, 0x100fe20000010827ULL, 0x0000004200427308ULL, 0x000ee20000000800ULL,
0x0000004e5518723eULL, 0x004fe200000010ffULL, 0x3fb8aa3b5d5d7823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b5a5a7823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b63637823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b5e5e7823ULL, 0x000fe20000010827ULL, 0xfffffff8ff1e7812ULL, 0x000fe200078ee265ULL,
0x0c201f002e317f89ULL, 0x000ea200000e0000ULL, 0x0000004100417308ULL, 0x000fe20000000800ULL,
0x000000ffff257224ULL, 0x000fc400078e001cULL, 0x000000081e247836ULL, 0x000fe40000000000ULL,
0x000000081e277824ULL, 0x000fe200078e00ffULL, 0x00000005420d723eULL, 0x008fe400000010ffULL,
0x0000004000407308ULL, 0x000ee20000000800ULL, 0x0000000824347824ULL, 0x040fe400078e00ffULL,
0x0000000824337824ULL, 0x000fe400078e00ffULL, 0x000000081e2b7824ULL, 0x000fc600078e00ffULL,
0x0000001100117308ULL, 0x000fe20000000800ULL, 0x00000041400f723eULL, 0x008fce00000010ffULL,
0x0000001200127308ULL, 0x000ee20000000800ULL, 0x000000312e00720bULL, 0x004fc80003f1e000ULL,
0x0000002e312e7208ULL, 0x000fe20004000000ULL, 0x0000001c0c20723cULL, 0x000fe200000418ffULL,
0x0000000302ff7812ULL, 0x000fe2000780c0ffULL, 0x0000000b000b7308ULL, 0x000fe20000000800ULL,
0x000000111215723eULL, 0x008fce00000010ffULL, 0x0000001000107308ULL, 0x000eb00000000800ULL,
0x0000005700577308ULL, 0x000ee20000000800ULL, 0x0000000b1017723eULL, 0x004fce00000010ffULL,
0x0000000900097308ULL, 0x000fe20000000800ULL, 0x0000001c1420723cULL, 0x000fe20000041820ULL,
0x00000054571a723eULL, 0x008fcc00000010ffULL, 0x0000000a000a7308ULL, 0x000eb00000000800ULL,
0x0000000700077308ULL, 0x000fe20000000800ULL, 0x000000090a19723eULL, 0x004fce00000010ffULL,
0x0000000800087308ULL, 0x000eb00000000800ULL, 0x0000005600567308ULL, 0x000fe20000000800ULL,
0x00000007081b723eULL, 0x004fce00000010ffULL, 0x0000005900597308ULL, 0x000ea20000000800ULL,
0x0000001c1820723cULL, 0x000fee0000041820ULL, 0x0000005800587308ULL, 0x000fe20000000800ULL,
0x000000031f1d7812ULL, 0x000fce00078ec0ffULL, 0x0000005b005b7308ULL, 0x000ee20000000800ULL,
0x000000011d297824ULL, 0x040fe400078e0224ULL, 0x000000011d267824ULL, 0x000fe400078e021eULL,
0x000000ffff247224ULL, 0x000fe200078e001cULL, 0x00000056591c723eULL, 0x004fe400000010ffULL,
0x0000005d005d7308ULL, 0x000fe20000000800ULL, 0x0000000426287836ULL, 0x000fe20000000000ULL,
0xfffffff827277812ULL, 0x000fe200078ee226ULL, 0x0000000c26267836ULL, 0x000fe20000000000ULL,
0xfffffff834297812ULL, 0x000fe200078ee229ULL, 0x000000ffff2a7224ULL, 0x000fe200078e001cULL,
0xfffffff82b287812ULL, 0x000fc400078ee228ULL, 0x0000005a005a7308ULL, 0x000ea20000000800ULL,
0x000000585b1e723eULL, 0x008fe400000010ffULL, 0xfffffff833347812ULL, 0x000fe200078ee226ULL,
0x000000ffff267224ULL, 0x000fe400078e0014ULL, 0x0000001029337824ULL, 0x000fe400078e0235ULL,
0x0000006300637308ULL, 0x000fe20000000800ULL, 0x000000ffff297224ULL, 0x000fe400078e001aULL,
0x000000ffff2b7224ULL, 0x000fc400078e001eULL, 0x0000001034347824ULL, 0x000fe200078e0235ULL,
0x0000005d5a1d723eULL, 0x004fe400000010ffULL, 0x0000005e005e7308ULL, 0x000ea20000000800ULL,
0x000000ffff147224ULL, 0x000fe400078e0019ULL, 0x00000001ff197424ULL, 0x000fe200078e00ffULL,
0x000000635e1f723eULL, 0x004fce00000010ffULL, 0x000000241c20723cULL, 0x000fee0000041820ULL,
0x000000ffff247224ULL, 0x000fe400078e000cULL, 0x000000ffff257224ULL, 0x000fe400078e000eULL,
0x000000ffff0c7224ULL, 0x000fc400078e000dULL, 0x000000ffff0d7224ULL, 0x000fe400078e000fULL,
0x000000ffff0e7224ULL, 0x000fe400078e0015ULL, 0x000000ffff0f7224ULL, 0x000fe400078e0017ULL,
0x000000ffff157224ULL, 0x000fe400078e001bULL, 0x0000001027217824ULL, 0x000fe400078e0235ULL,
0x000000ffff277224ULL, 0x000fc400078e0016ULL, 0x0000001028237824ULL, 0x000fe400078e0235ULL,
0x000000ffff287224ULL, 0x000fe200078e0018ULL, 0x0000002421007844ULL, 0x0005e20000000200ULL,
0x000000ffff167224ULL, 0x000fe400078e001dULL, 0x000000ffff177224ULL, 0x000fe200078e001fULL,
0x0000002823007844ULL, 0x0007e80000000200ULL, 0x0000000c33007844ULL, 0x0007e80000000200ULL,
0x0000001434007844ULL, 0x0007e20000000200ULL, 0x000000ffff217224ULL, 0x004fc600078e0022ULL,
0x0180002c30008388ULL, 0x0007e80000000c00ULL, 0x0182002030008388ULL, 0x0007e20000000a00ULL,
0x0000000c44007c0cULL, 0x000fe2000bf06070ULL, 0x018ad81904ff79a7ULL, 0x0007e2000850003fULL,
0x018ae01904ff79a7ULL, 0x0007e2000850003fULL, 0x018ae81904ff79a7ULL, 0x0007e2000850003fULL,
0x018af01904ff79a7ULL, 0x0007f2000850003fULL, 0xffffffa400788947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x018000000a007836ULL, 0x000fe20000000000ULL,
0x0000013000017945ULL, 0x000fe80003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000000a00008308ULL, 0x0002a20000001000ULL,
0x0000000000388947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x007fffff0aff7812ULL, 0x040fe4000780c0ffULL,
0x800000000a027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000000000047947ULL, 0x000fec0003800000ULL,
0x0000000a00007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffffdd0024c7950ULL, 0x000fea0003c3ffffULL, 0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000100000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000040ULL, 0x0000000000000111ULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000000000000017bULL, 0x000000000000056aULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000006e8ULL, 0x0000000000000240ULL, 0x0000001600000002ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x00000001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000928ULL, 0x00000000000000e0ULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000a08ULL, 0x0000000000000054ULL, 0x0000000000000003ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000a5cULL, 0x0000000000000a38ULL, 0x0000000a00000003ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x00000004000000b2ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000001498ULL, 0x0000000000000000ULL, 0x0000000a00000003ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x00000004000000e6ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000001498ULL, 0x0000000000000048ULL, 0x0000000400000003ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x000000010000007bULL, 0x0000000000000002ULL, 0x0000000000000000ULL,
0x00000000000014e0ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL,
0x0000000000001500ULL, 0x0000000000022f80ULL, 0x0000001600000003ULL, 0x0000000000000080ULL,
0x0000000000000000ULL, 0x000000010000008dULL, 0x0000000000000003ULL, 0x0000000000000000ULL,
0x0000000000024480ULL, 0x0000000000000044ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL,
0x00000000000244d0ULL, 0x0000000000000400ULL, 0x0000000a00000000ULL, 0x0000000000000010ULL,
0x0000000000000000ULL, 0x00000001000000f8ULL, 0x0000000000000002ULL, 0x0000000000000000ULL,
0x00000000000244d0ULL, 0x0000000000000278ULL, 0x0000000a00000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000400000006ULL, 0x0000000000024ac8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x0000000000024ac8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x00000000000014e0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001500ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000022f80ULL, 0x0000000000022f80ULL,
0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000024480ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000050ULL, 0x0000000000000450ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x00000000000244d0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000278ULL, 0x0000000000000278ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_4_kvt_e4m3_pagedKV_128_nqpkv_1_m_1_sm_90_cubin_len = 150552;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
