/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_4_kvt_e4m3_pagedKV_64_nqpkv_1_m_1_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000024a48ULL, 0x00000000000246c8ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x766e2e0000000000ULL, 0x2e6c61626f6c672eULL, 0x65722e0074696e69ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6e6f632e766e2e00ULL, 0x000033746e617473ULL, 0x536d656d73000000ULL, 0x2e766e2e00657a69ULL,
0x692e6c61626f6c67ULL, 0x4e5a5a5f0074696eULL, 0x7473336164756334ULL, 0x5f5f38345f5f3364ULL,
0x31326c6961746564ULL, 0x676e6f7274735f5fULL, 0x726564726f5f7265ULL, 0x696945616475635fULL,
0x726f66785f5f3745ULL, 0x374b4e5a5a5f006dULL, 0x4944327961727241ULL, 0x326a4c45326a4c66ULL,
0x624c497461324545ULL, 0x6a664b5245454530ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x326a4c66495f5349ULL, 0x6a4c4545326a4c45ULL,
0x324545386a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f30534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x625f766e5f5f3431ULL,
0x32363174616f6c66ULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6a49636556334944ULL, 0x316a4c4545346a4cULL, 0x324545386a4c4536ULL, 0x454531624c497461ULL,
0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL,
0x4944327961727241ULL, 0x6a4c6a4963655633ULL, 0x4536316a4c454534ULL, 0x6132454532336a4cULL,
0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4534366a4c4545ULL,
0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL,
0x45326a4c45326a4cULL, 0x316a4c45316a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL,
0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL,
0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL, 0x4c4545316a4c4534ULL, 0x4545316a4c45326aULL,
0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x6e4974736e493949ULL, 0x45346a4c4974614dULL,
0x326a4c4545326a4cULL, 0x61324545316a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL,
0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL, 0x746132454536316aULL, 0x5245454531624c49ULL,
0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL,
0x4939494432796172ULL, 0x74614d6e4974736eULL, 0x326a4c45326a4c49ULL, 0x6a4c45326a4c4545ULL,
0x4c49746132454531ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x4545386a4c45346aULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x36316a4c4545346aULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x5f24000000000000ULL, 0x616e7265746e695fULL, 0x635f5f245f305f6cULL, 0x30326d735f616475ULL,
0x5f6e725f7063725fULL, 0x5f3233665f7a7466ULL, 0x68746170776f6c73ULL, 0x65742e6c65722e00ULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x747865742e616c65ULL, 0x5f6c656e72656b2eULL,
0x72656b240061686dULL, 0x2461686d5f6c656eULL, 0x657479426d656d73ULL, 0x6265642e00667542ULL,
0x656d6172665f6775ULL, 0x65642e6c65722e00ULL, 0x6d6172665f677562ULL, 0x2e616c65722e0065ULL,
0x72665f6775626564ULL, 0x2e766e2e00656d61ULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x0000000061686d5fULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000100000098ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b0003000000a1ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b0001000000b1ULL, 0x0000000000000034ULL, 0x0000000000000010ULL, 0x000b0001000000efULL,
0x000000000000001cULL, 0x0000000000000004ULL, 0x000b000100000128ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000b00010000016fULL, 0x000000000000002cULL, 0x0000000000000004ULL,
0x000b0001000001b9ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b0001000001ffULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000b000100000246ULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000b00010000028cULL, 0x0000000000000030ULL, 0x0000000000000004ULL,
0x000b0001000002daULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000328ULL,
0x0000000000000018ULL, 0x0000000000000004ULL, 0x000b000100000376ULL, 0x000000000000000cULL,
0x0000000000000004ULL, 0x000b0001000003bdULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000b00010000040bULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000b000100000450ULL,
0x0000000000000020ULL, 0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000a0022000004abULL, 0x0000000000022cd0ULL, 0x0000000000000230ULL,
0x0004000300000521ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a101200000040ULL,
0x0000000000000000ULL, 0x0000000000022f00ULL, 0x000d000300000551ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000024ffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00022cd000000000ULL, 0x0000700400000000ULL,
0x0000288080810c00ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880808492ULL, 0x0000002cffffffffULL, 0x0000006000000000ULL,
0x00022cd000000000ULL, 0x0000023000000000ULL, 0x0000580400000000ULL, 0x8082288080840900ULL,
0x0000000000002880ULL, 0x0000001600082f04ULL, 0x000823040000007bULL, 0x0000000000000014ULL,
0x0000001400081204ULL, 0x0008110400000000ULL, 0x0000000000000014ULL, 0x0000001600082304ULL,
0x0008120400000000ULL, 0x0000000000000016ULL, 0x0000001600081104ULL, 0x0004370400000000ULL,
0x000c17040000007bULL, 0x0060000700000000ULL, 0x000c17040021f000ULL, 0x0058000600000000ULL,
0x000c17040021f000ULL, 0x0050000500000000ULL, 0x000c17040011f000ULL, 0x0038000400000000ULL,
0x000c17040061f000ULL, 0x0018000300000000ULL, 0x000c17040081f000ULL, 0x0010000200000000ULL,
0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL,
0x00801b030011f000ULL, 0xffffffff00c82904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x00c82804ffffffffULL, 0x00000100000000e0ULL,
0x0000331000000780ULL, 0x0000343000003370ULL, 0x0000382000003570ULL, 0x000064f000003830ULL,
0x0000952000006500ULL, 0x0000964000009590ULL, 0x0000994000009770ULL, 0x0000c47000009950ULL,
0x0000f3b00000c480ULL, 0x0000f4d00000f420ULL, 0x0000f7d00000f600ULL, 0x000123000000f7e0ULL,
0x0001524000012310ULL, 0x00015360000152b0ULL, 0x0001566000015490ULL, 0x0001819000015670ULL,
0x00019c80000181a0ULL, 0x0001a3d000019c90ULL, 0x0001cb200001a710ULL, 0x0001f7b00001d520ULL,
0x00021e8000021e40ULL, 0x0002222000022170ULL, 0x000224b000022470ULL, 0x0002277000022530ULL,
0x0000021007d03904ULL, 0x00018ad0000000ffULL, 0x000002f000040100ULL, 0x00018ad800000008ULL,
0x00000400003f0100ULL, 0x00018b5800000008ULL, 0x00000520003f0100ULL, 0x00018b7800000002ULL,
0x00000610003f0100ULL, 0x00018b88000000ffULL, 0x000008f000040100ULL, 0x00018ad0000000ffULL,
0x00000b6000060107ULL, 0x00018b580000005bULL, 0x00000bb000060101ULL, 0x00018b88000000ffULL,
0x00000be000060101ULL, 0x00018b88000000ffULL, 0x00000d5000060109ULL, 0x00018b88000000ffULL,
0x000017c000060109ULL, 0x00018b88000000ffULL, 0x000017f000060101ULL, 0x00018b88000000ffULL,
0x0000196000060109ULL, 0x00018b88000000ffULL, 0x00001ac000060109ULL, 0x00018b78000000ffULL,
0x00001b0000060107ULL, 0x00018b78000000ffULL, 0x00001b8000060101ULL, 0x00018b88000000ffULL,
0x00001da000060101ULL, 0x00018b78000000ffULL, 0x00001f1000060109ULL, 0x00018b78000000ffULL,
0x00001f4000060109ULL, 0x00018b88000000ffULL, 0x000020b000060109ULL, 0x00018b88000000ffULL,
0x00002b4000060109ULL, 0x00018b88000000ffULL, 0x00002b7000060101ULL, 0x00018b88000000ffULL,
0x00002ce000060109ULL, 0x00018b88000000ffULL, 0x0000305000060109ULL, 0x00018b80000000ffULL,
0x0000309000060107ULL, 0x00018b80000000ffULL, 0x000030b000060101ULL, 0x00018ad80000005bULL,
0x000030e000060101ULL, 0x00018ad80000005bULL, 0x0000325000060109ULL, 0x00018ad80000005bULL,
0x000052b000060109ULL, 0x00018b88000000ffULL, 0x0000536000060101ULL, 0x00018b80000000ffULL,
0x000054d000060109ULL, 0x00018b80000000ffULL, 0x0000550000060109ULL, 0x00018b88000000ffULL,
0x0000567000060109ULL, 0x00018b88000000ffULL, 0x000060d000060109ULL, 0x00018b88000000ffULL,
0x0000610000060101ULL, 0x00018b88000000ffULL, 0x0000627000060109ULL, 0x00018b88000000ffULL,
0x0000646000060109ULL, 0x00000000000000ffULL, 0x000064b000090107ULL, 0x00018b78000000ffULL,
0x00007eb000060101ULL, 0x00018b88000000ffULL, 0x00007f0000060101ULL, 0x00018b58000000ffULL,
0x00007fd000060101ULL, 0x00018b78000000ffULL, 0x0000814000060109ULL, 0x00018b78000000ffULL,
0x0000817000060109ULL, 0x00018b88000000ffULL, 0x000082e000060109ULL, 0x00018b88000000ffULL,
0x00008d7000060109ULL, 0x00018b88000000ffULL, 0x00008da000060101ULL, 0x00018b88000000ffULL,
0x00008f1000060109ULL, 0x00018b88000000ffULL, 0x0000925000060109ULL, 0x00000000000000ffULL,
0x00009280000a0107ULL, 0x00018b80000000ffULL, 0x000092d000060101ULL, 0x00018af80000005bULL,
0x0000930000060101ULL, 0x00018af80000005bULL, 0x0000947000060109ULL, 0x00018af80000005bULL,
0x0000b26000060109ULL, 0x00018b88000000ffULL, 0x0000b33000060101ULL, 0x00018b80000000ffULL,
0x0000b4a000060109ULL, 0x00018b80000000ffULL, 0x0000b4d000060109ULL, 0x00018b88000000ffULL,
0x0000b64000060109ULL, 0x00018b88000000ffULL, 0x0000c0a000060109ULL, 0x00018b88000000ffULL,
0x0000c0d000060101ULL, 0x00018b88000000ffULL, 0x0000c24000060109ULL, 0x00018b88000000ffULL,
0x0000c40000060109ULL, 0x00000000000000ffULL, 0x0000c43000090107ULL, 0x00018b78000000ffULL,
0x0000dd6000060101ULL, 0x00018b88000000ffULL, 0x0000dd9000060101ULL, 0x00018b60000000ffULL,
0x0000de6000060101ULL, 0x00018b78000000ffULL, 0x0000dfd000060109ULL, 0x00018b78000000ffULL,
0x0000e00000060109ULL, 0x00018b88000000ffULL, 0x0000e17000060109ULL, 0x00018b88000000ffULL,
0x0000ec0000060109ULL, 0x00018b88000000ffULL, 0x0000ec3000060101ULL, 0x00018b88000000ffULL,
0x0000eda000060109ULL, 0x00018b88000000ffULL, 0x0000f0e000060109ULL, 0x00000000000000ffULL,
0x0000f110000a0107ULL, 0x00018b80000000ffULL, 0x0000f16000060101ULL, 0x00018b180000005bULL,
0x0000f19000060101ULL, 0x00018b180000005bULL, 0x0000f30000060109ULL, 0x00018b180000005bULL,
0x000110f000060109ULL, 0x00018b88000000ffULL, 0x000111c000060101ULL, 0x00018b80000000ffULL,
0x0001133000060109ULL, 0x00018b80000000ffULL, 0x0001136000060109ULL, 0x00018b88000000ffULL,
0x000114d000060109ULL, 0x00018b88000000ffULL, 0x00011f3000060109ULL, 0x00018b88000000ffULL,
0x00011f6000060101ULL, 0x00018b88000000ffULL, 0x000120d000060109ULL, 0x00018b88000000ffULL,
0x0001229000060109ULL, 0x00000000000000ffULL, 0x000122c000090107ULL, 0x00018b78000000ffULL,
0x00013bf000060101ULL, 0x00018b88000000ffULL, 0x00013c2000060101ULL, 0x00018b68000000ffULL,
0x00013cf000060101ULL, 0x00018b78000000ffULL, 0x00013e6000060109ULL, 0x00018b78000000ffULL,
0x00013e9000060109ULL, 0x00018b88000000ffULL, 0x0001400000060109ULL, 0x00018b88000000ffULL,
0x00014a9000060109ULL, 0x00018b88000000ffULL, 0x00014ac000060101ULL, 0x00018b88000000ffULL,
0x00014c3000060109ULL, 0x00018b88000000ffULL, 0x00014f7000060109ULL, 0x00000000000000ffULL,
0x00014fa0000a0107ULL, 0x00018b80000000ffULL, 0x00014ff000060101ULL, 0x00018b380000005bULL,
0x0001502000060101ULL, 0x00018b380000005bULL, 0x0001519000060109ULL, 0x00018b380000005bULL,
0x00016f8000060109ULL, 0x00018b88000000ffULL, 0x0001705000060101ULL, 0x00018b80000000ffULL,
0x000171c000060109ULL, 0x00018b80000000ffULL, 0x000171f000060109ULL, 0x00018b88000000ffULL,
0x0001736000060109ULL, 0x00018b88000000ffULL, 0x00017dc000060109ULL, 0x00018b88000000ffULL,
0x00017df000060101ULL, 0x00018b88000000ffULL, 0x00017f6000060109ULL, 0x00018b88000000ffULL,
0x0001812000060109ULL, 0x00000000000000ffULL, 0x0001815000090107ULL, 0x00018b78000000ffULL,
0x00019a8000060101ULL, 0x00018b88000000ffULL, 0x00019aa000060101ULL, 0x00018b70000000ffULL,
0x0001a65000060101ULL, 0x00018ad0000000ffULL, 0x0001cb5000060101ULL, 0x00018ad0000000ffULL,
0x0001ccc000060109ULL, 0x00018ad0000000ffULL, 0x0001d01000060109ULL, 0x00018ad0000000ffULL,
0x0001d04000060101ULL, 0x00018ad0000000ffULL, 0x0001d1b000060109ULL, 0x00018ad0000000ffULL,
0x0002162000060109ULL, 0x00018b5800000044ULL, 0x00021800003f0101ULL, 0x00018b5800000044ULL,
0x00021970003f0109ULL, 0x00018b5800000044ULL, 0x00022c70003f0109ULL, 0x00018ad800000000ULL,
0x00022c80003f0101ULL, 0x00018ae000000000ULL, 0x00022c90003f0101ULL, 0x00018ae800000000ULL,
0x00022ca0003f0101ULL, 0x00018af000000000ULL, 0x00053803003f0101ULL, 0x0001a48000101c04ULL,
0x0001d2c00001d1e0ULL, 0x000c050400022cc0ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL,
0x0068190300000000ULL, 0x0000001700080a04ULL, 0x0000000000680210ULL, 0x00000000000000bcULL,
0x0000001600000002ULL, 0x0000000000022cd0ULL, 0x0000000000000044ULL, 0x0000001600000002ULL,
0x0000000000000000ULL, 0x0000000000000098ULL, 0x0000001600000002ULL, 0x0000000000000000ULL,
0x0000000000018c00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e620000000800ULL, 0x0000000000047919ULL, 0x000ea20000002300ULL,
0x0000010000047ab9ULL, 0x000fcc0000000800ULL, 0x00008800ff067b82ULL, 0x000ee20000000a00ULL,
0x0000021000007945ULL, 0x000fe20003800000ULL, 0x0000000000037919ULL, 0x000ea20000002200ULL,
0x00000000005f7919ULL, 0x000f220000002100ULL, 0x0000000000137919ULL, 0x000ee20000002600ULL,
0x0000000000127919ULL, 0x000ee20000002700ULL, 0x0000000404007c24ULL, 0x004fe2000f8e0203ULL,
0x0000000000047ab9ULL, 0x000fe20000000800ULL, 0x0000000000037919ULL, 0x000ee40000000000ULL,
0x0000000400027c24ULL, 0x110fe2000f8e025fULL, 0x00000005ff5f7819ULL, 0x000fe2000001165fULL,
0x00001fff04007589ULL, 0x000fe600000e0000ULL, 0x0000007f0200780cULL, 0x000fc40003f64070ULL,
0x00001fff5f5f7589ULL, 0x000ea200000e0000ULL, 0x000000ff0200720cULL, 0x040fe40003f45270ULL,
0x0000000f0200780cULL, 0x040fe40003f04070ULL, 0x000000030200780cULL, 0x040fe40003fa4070ULL,
0x000000010200780cULL, 0x000fc80003f84070ULL, 0x000000000008b919ULL, 0x000f220000008800ULL,
0x000004000005b802ULL, 0x000fe20000000f00ULL, 0xff317217ff09b424ULL, 0x000fc600078e00ffULL,
0x00000654080bb816ULL, 0x012fe20000000005ULL, 0x0000000400057824ULL, 0x004fc800078e025fULL,
0x000000040204b824ULL, 0x000fe200078e020bULL, 0x0000000000242947ULL, 0x008fec0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000067882ULL, 0x000fe20000000000ULL, 0x7ffc000000077882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000e740000000000ULL, 0x018ad006043f75b2ULL, 0x0002640008000100ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000380947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x0000000402087c11ULL, 0x000fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000080612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x018ad804063f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000385947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffb000000057882ULL, 0x000fc60000000000ULL,
0x0000000402087c11ULL, 0x000fe2000f8e18ffULL, 0x001ffec000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000080612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x018b5804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x018400090400b388ULL, 0x0003e20000000800ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ff8000000057882ULL, 0x000fc60000000000ULL,
0x0000000402027c11ULL, 0x000fe2000f8e18ffULL, 0x001ffe0000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x002fca0000000000ULL, 0x00000000020612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x018b7804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000b000007945ULL, 0x000fe80003800000ULL, 0x0000000000242947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000ea20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000067882ULL, 0x000fe20000000000ULL, 0x7ffc000000077882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x004fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000eb40000000000ULL, 0x018b8806043f75b2ULL, 0x0004a40008000100ULL,
0x0000000000007918ULL, 0x004fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000ea20000008800ULL, 0x0000840000047ab9ULL, 0x000fe20000000800ULL,
0x0000000205057824ULL, 0x000fe200078e00ffULL, 0x0000000204067899ULL, 0x000fe2000800063fULL,
0x00000010030e7824ULL, 0x000fe200078e00ffULL, 0x00008200000e7ab9ULL, 0x000fe20000000a00ULL,
0x00000001050c7836ULL, 0x000fe20000000000ULL, 0x0000000405047848ULL, 0x002fe20007fe0000ULL,
0x0000000105087824ULL, 0x040fe200078e0203ULL, 0x000001f00e0f7812ULL, 0x000fe200078ec0ffULL,
0x0000000612027c24ULL, 0x000fe2000f8e0213ULL, 0x0000040000067882ULL, 0x000fe20000000000ULL,
0x00000020050d7824ULL, 0x000fc400078e00ffULL, 0x0000000104097824ULL, 0x000fe400078e0a05ULL,
0x0000000405057c24ULL, 0x100fe4000f8e0202ULL, 0x000000040c0b7c24ULL, 0x040fe2000f8e0202ULL,
0xffffffe00d027812ULL, 0x000fe200078ee208ULL, 0x0000020005047825ULL, 0x100fe200078e0006ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000002000b067825ULL, 0x000fe200078e0006ULL,
0x000000ff0900720cULL, 0x040fe20003f03070ULL, 0x0000065405067896ULL, 0x004fe20008000006ULL,
0x000000010900780cULL, 0x000fe20003f23070ULL, 0x000000010c0d7824ULL, 0x040fe200078e0203ULL,
0x0000000f04087210ULL, 0x000fe20007f5e0ffULL, 0x000000200c0c7824ULL, 0x000fe200078e00ffULL,
0x0000000f06067210ULL, 0x000fe20007f7e0ffULL, 0x00018ad006057890ULL, 0x000fc4000fffe03fULL,
0x00000006020f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff097224ULL, 0x000fe200010e0605ULL,
0xffffffe00c0d7812ULL, 0x000fe200078ee20dULL, 0x000000ffff077224ULL, 0x000fe200018e0607ULL,
0x00008e00ff0a7b82ULL, 0x000e620000000a00ULL, 0x00000004125d7824ULL, 0x000fe200078e00ffULL,
0x000000060d117c11ULL, 0x000fe2000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080f7faeULL, 0x000fe8000c101c4eULL, 0x0000000006117faeULL, 0x0005e2000c901c4eULL,
0x00009600ff0c7b82ULL, 0x000ee20000000a00ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000ffffff79a7ULL, 0x000fe20008200405ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a85ULL,
0x000000045d047825ULL, 0x002fe200078e000aULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x0000000e04047981ULL, 0x000f22000c1e1900ULL, 0x000000045d067825ULL, 0x00cfcc00078e000cULL,
0x0000000e06067981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0000720cULL, 0x000fe40003f05270ULL,
0x00000000040d72caULL, 0x010fe400000e0000ULL, 0x00000008ff5c7819ULL, 0x004fd60000011606ULL,
0x0000003f0d077890ULL, 0x000fe4000fffe03fULL, 0x000000ff0d057890ULL, 0x000fe4000fffe03fULL,
0x000000063f077899ULL, 0x000fe40008011607ULL, 0x000000083f107899ULL, 0x000fe20008011605ULL,
0x0000019800a88947ULL, 0x000ff60003800000ULL, 0x000000205f007824ULL, 0x040fe400078e0203ULL,
0x000000085f5b7824ULL, 0x000fc600078e00ffULL, 0x000000030000780cULL, 0x040fe40003f44070ULL,
0x0000001f0000780cULL, 0x000fd60003f04070ULL, 0x00009000ff09ab82ULL, 0x000e620000000800ULL,
0x000000041206a824ULL, 0x000fe200078e0200ULL, 0x0000000d00008c0cULL, 0x000fe4000bf26070ULL,
0x00000007ff00ac0cULL, 0x000fe2000bf65270ULL, 0x000000020606a824ULL, 0x000fe200078e00ffULL,
0x00000006000bac11ULL, 0x000fe4000f8e10ffULL, 0x00009400ff078b82ULL, 0x000eb00000000800ULL,
0x00008c00ff04ab82ULL, 0x000ef00000000a00ULL, 0x00009200ff028b82ULL, 0x000f220000000a00ULL,
0x000000090609a224ULL, 0x002fc400078e0209ULL, 0x00000004ff067424ULL, 0x000fe400078e00ffULL,
0x000000075d078224ULL, 0x004fe400078e0200ULL, 0x000000040904a825ULL, 0x008fe200078e0004ULL,
0x0000000600098c11ULL, 0x000fc6000f8e10ffULL, 0x0000000407028825ULL, 0x010fca00078e0002ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18a0000002098faeULL, 0x0003e2000c92184eULL,
0x018b58065bff79a7ULL, 0x0005e60008500006ULL, 0x18ac0000040bafaeULL, 0x0007e8000992184eULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000001ff067424ULL, 0x004fe200078e00ffULL,
0x000080000000791aULL, 0x000fca0000000000ULL, 0x018b8806ff0679a7ULL, 0x000ea40008500006ULL,
0x000000ffff087224ULL, 0x004fe200078e0007ULL, 0x0000000000027805ULL, 0x002fc60000015200ULL,
0x018b8808ff0075a7ULL, 0x000e640008000146ULL, 0x00000000005c0947ULL, 0x00afea0003800000ULL,
0x000000ffff067224ULL, 0x000fce00078e00ffULL, 0x000000100600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fcc0000015200ULL,
0x0000000402077210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e03ULL,
0x003d09000700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011405ULL, 0x0000000700007211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000200007819ULL, 0x000fc80000001205ULL,
0x000000000000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000106067836ULL, 0x000fce0000000000ULL, 0x018b8808ff0075a7ULL, 0x000e640008000146ULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000001ff0500788cULL, 0x000fe2000bf04070ULL,
0x0000840000047ab9ULL, 0x000fe40000000800ULL, 0x0000000604047899ULL, 0x000fc6000800063fULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000400540947ULL, 0x000fea0003800000ULL,
0x0000000000117919ULL, 0x000e620000000000ULL, 0x00008a00ff067b82ULL, 0x000ea20000000a00ULL,
0x0001400006057890ULL, 0x000fe2000fffe03fULL, 0x00000004ff087819ULL, 0x002fe20000011611ULL,
0x00000010110f7824ULL, 0x000fc800078e00ffULL, 0x000000015b047824ULL, 0x000fe200078e0208ULL,
0x000000f00f0f7812ULL, 0x000fc600078ec0ffULL, 0x00000040130b7824ULL, 0x000fe200078e0204ULL,
0x0000000604097c11ULL, 0x040fe2000f8e10ffULL, 0x0000000104057824ULL, 0x000fc800078e0211ULL,
0x018a000009007984ULL, 0x000e640000000800ULL, 0x00000006000a7c11ULL, 0x002fe4000f8e10ffULL,
0x0000000d5b007c48ULL, 0x000fc6000ffe0000ULL, 0x018ac0000a027984ULL, 0x0002e40000000800ULL,
0x0000000100007824ULL, 0x000fca00078e0a5bULL, 0x000000000800720cULL, 0x000fe20003f06070ULL,
0x00000010040a7824ULL, 0x002fe400078e00ffULL, 0x0000000402037c24ULL, 0x008fc8000f8e020bULL,
0x0000010003027825ULL, 0x004fc600078e0006ULL, 0x0000000f02047210ULL, 0x000fe40007f3e0ffULL,
0xfffffff00a027812ULL, 0x000fe200078ee205ULL, 0x000000020b0a7836ULL, 0x000fe40000000000ULL,
0x000000ffff057224ULL, 0x000fe200008e0603ULL, 0x00000005020d7c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040d7faeULL, 0x0003e8000c101c4eULL,
0x018a080009027984ULL, 0x000ea40000000800ULL, 0x00000006020e7c11ULL, 0x004fe2000f8e10ffULL,
0x0000000208027836ULL, 0x000fc80000000000ULL, 0x018ac0000e037984ULL, 0x000ea20000000800ULL,
0x000000000200720cULL, 0x000fe20003f06070ULL, 0x0000000403037c24ULL, 0x004fe4000f8e020aULL,
0x000000015b0a7824ULL, 0x000fe400078e0202ULL, 0x0000010003027825ULL, 0x000fc800078e0006ULL,
0x000000010a0c7824ULL, 0x040fe200078e0211ULL, 0x0000000f02047210ULL, 0x002fe20007f3e0ffULL,
0x000000100a057824ULL, 0x000fe400078e00ffULL, 0x000000040b0a7836ULL, 0x000fe40000000000ULL,
0x000000060b0b7836ULL, 0x000fe20000000000ULL, 0xfffffff0050c7812ULL, 0x000fe200078ee20cULL,
0x000000ffff057224ULL, 0x000fc600008e0603ULL, 0x000000050c0d7c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040d7faeULL, 0x0003e8000c101c4eULL,
0x018a100009027984ULL, 0x000ea40000000800ULL, 0x00000006020e7c11ULL, 0x004fe2000f8e10ffULL,
0x0000000408027836ULL, 0x000fe40000000000ULL, 0x0000000608087836ULL, 0x000fe40000000000ULL,
0x018ac0000e037984ULL, 0x000ea20000000800ULL, 0x000000000200720cULL, 0x000fe20003f06070ULL,
0x0000000403037c24ULL, 0x004fc4000f8e020aULL, 0x000000015b0a7824ULL, 0x000fe400078e0202ULL,
0x0000010003027825ULL, 0x000fc800078e0006ULL, 0x000000010a0c7824ULL, 0x040fe200078e0211ULL,
0x0000000f02047210ULL, 0x002fe20007f3e0ffULL, 0x000000100a057824ULL, 0x000fe400078e00ffULL,
0x000000015b0a7824ULL, 0x000fc600078e0208ULL, 0xfffffff0050c7812ULL, 0x000fe200078ee20cULL,
0x000000ffff057224ULL, 0x000fc600008e0603ULL, 0x000000050c0d7c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040d7faeULL, 0x0003e2000c101c4eULL,
0x000000000800720cULL, 0x000fe20003f06070ULL, 0x000000010a007824ULL, 0x040fe400078e0211ULL,
0x018a180009097984ULL, 0x000ea20000000800ULL, 0x000000100a057824ULL, 0x002fca00078e00ffULL,
0xfffffff005007812ULL, 0x000fc800078ee200ULL, 0x0000000500057c11ULL, 0x000fe4000f8e20ffULL,
0x00000006090c7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0000c027984ULL, 0x000e640000000800ULL,
0x0000000402037c24ULL, 0x002fc8000f8e020bULL, 0x0000010003027825ULL, 0x000fc600078e0006ULL,
0x0000000f02027210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff037224ULL, 0x000fca00008e0603ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002057faeULL, 0x0003e2000c101c4eULL,
0x0000000400287947ULL, 0x000fea0003800000ULL, 0x00000000000f7919ULL, 0x000e620000000000ULL,
0x00008a00ff087b82ULL, 0x000ea20000000a00ULL, 0x0001400006057890ULL, 0x000fe2000fffe03fULL,
0x0000005b0f007211ULL, 0x042fe200078fe0ffULL, 0x000000100f047824ULL, 0x000fc600078e00ffULL,
0x00000006000a7c11ULL, 0x000fe2000f8e10ffULL, 0x00000040130b7824ULL, 0x000fe200078e0200ULL,
0x000000f004117812ULL, 0x000fe200078ec0ffULL, 0x0000000100057824ULL, 0x040fe400078e020fULL,
0x018a00000a027984ULL, 0x000e620000000800ULL, 0x00000010000c7824ULL, 0x000fe200078e00ffULL,
0x0000000602067c11ULL, 0x002fca000f8e10ffULL, 0x018ac00006027984ULL, 0x0002e40000000800ULL,
0x0000000200067836ULL, 0x002fc80000000000ULL, 0x0000000106077824ULL, 0x040fe400078e020fULL,
0x00000010060e7824ULL, 0x000fe400078e00ffULL, 0x0000000402037c24ULL, 0x008fc8000f8e020bULL,
0x0000010003027825ULL, 0x004fc600078e0008ULL, 0x0000001102047210ULL, 0x000fe40007f1e0ffULL,
0xfffffff00c027812ULL, 0x000fc600078ee205ULL, 0x000000ffff057224ULL, 0x000fe200000e0603ULL,
0x00000005020d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000020b037836ULL, 0x000fc80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040d7faeULL, 0x0003e8000b901c4eULL,
0x018a08000a027984ULL, 0x000ea20000000800ULL, 0x0000000400047836ULL, 0x002fe40000000000ULL,
0x0000000600007836ULL, 0x000fe40000000000ULL, 0x0000000104057824ULL, 0x000fe200078e020fULL,
0x00000006020c7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0000c027984ULL, 0x000e640000000800ULL,
0x0000000402037c24ULL, 0x002fc8000f8e0203ULL, 0x0000010003027825ULL, 0x000fc600078e0008ULL,
0x0000001102067210ULL, 0x000fe40007f1e0ffULL, 0xfffffff00e027812ULL, 0x000fe200078ee207ULL,
0x00000010040e7824ULL, 0x000fe400078e00ffULL, 0x000000ffff077224ULL, 0x000fe200000e0603ULL,
0x00000005020d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000040b037836ULL, 0x000fe40000000000ULL,
0x000000060b0b7836ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000060d7faeULL, 0x0003e8000b901c4eULL, 0x018a10000a027984ULL, 0x000ea20000000800ULL,
0x0000000100067824ULL, 0x002fe200078e020fULL, 0x00000006020c7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0000c027984ULL, 0x000e640000000800ULL, 0x0000000402037c24ULL, 0x002fc8000f8e0203ULL,
0x0000010003027825ULL, 0x000fc600078e0008ULL, 0x0000001102047210ULL, 0x000fe40007f1e0ffULL,
0xfffffff00e027812ULL, 0x000fc600078ee205ULL, 0x000000ffff057224ULL, 0x000fe200000e0603ULL,
0x0000000502077c11ULL, 0x000fca000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004077faeULL, 0x0003e8000b901c4eULL, 0x018a18000a0a7984ULL, 0x000ea40000000800ULL,
0x000000060a0c7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0000c027984ULL, 0x000ea40000000800ULL,
0x0000000402037c24ULL, 0x004fc8000f8e020bULL, 0x0000010003027825ULL, 0x000fc800078e0008ULL,
0x0000001000097824ULL, 0x000fe200078e00ffULL, 0x0000001102027210ULL, 0x000fc80007f1e0ffULL,
0xfffffff009067812ULL, 0x000fe200078ee206ULL, 0x000000ffff037224ULL, 0x000fc600000e0603ULL,
0x0000000506057c11ULL, 0x002fca000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002057faeULL, 0x0003e4000b901c4eULL, 0x00000001ff027424ULL, 0x002fcc00078e00ffULL,
0x018b8802ff0279a7ULL, 0x000e640008500006ULL, 0x000000ffff067224ULL, 0x002fe200078e0003ULL,
0x0000000000027805ULL, 0x000fc60000015200ULL, 0x018b8806ff0075a7ULL, 0x000e640008000146ULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff087224ULL, 0x000fce00078e00ffULL,
0x000000100800780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000047805ULL, 0x000fcc0000015200ULL, 0x0000000402077210ULL, 0x000fca0007f1e1ffULL,
0x0000000105057824ULL, 0x000fe200000e0e03ULL, 0x003d09000700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011405ULL,
0x0000000700007211ULL, 0x000fca00078110ffULL, 0x000000ffff057224ULL, 0x000fca00000e0605ULL,
0x0000000200007819ULL, 0x000fc80000001205ULL, 0x000000000000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000108087836ULL, 0x000fce0000000000ULL,
0x018b8806ff0075a7ULL, 0x000e640008000146ULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000000107919ULL, 0x000e620000000000ULL, 0x00018b7806097890ULL, 0x000fe2000fffe03fULL,
0x0000011000007945ULL, 0x000fe20003800000ULL, 0x00000001ff047424ULL, 0x000fe400078e00ffULL,
0x000000205f007824ULL, 0x002fca00078e0210ULL, 0x0000001f0000780cULL, 0x000fda0003f04070ULL,
0x0000000000300947ULL, 0x000fea0003800000ULL, 0x00009200ff027b82ULL, 0x000e620000000a00ULL,
0x0000002000067836ULL, 0x000fe20000000000ULL, 0x0000940000047ab9ULL, 0x000fe20000000800ULL,
0x0000000600077c11ULL, 0x000fe2000f8e10ffULL, 0x000000045d057c24ULL, 0x000fe4000f8e0200ULL,
0x0000000d06007c0cULL, 0x000fe4000bf06070ULL, 0x0000002005057836ULL, 0x000fc80000000000ULL,
0x0000000405027825ULL, 0x002fce00078e0002ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x18a0000002077faeULL, 0x0003e4000c12184eULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a49ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000010ff007c0cULL, 0x000fe2000bf05270ULL,
0x018b7804ff0279a7ULL, 0x0026a20008500006ULL, 0x000000ffff5a7224ULL, 0x000fe200078e00ffULL,
0x0000000000587805ULL, 0x000fe4000001ff00ULL, 0x0000000000567805ULL, 0x000fe4000001ff00ULL,
0x0000000000547805ULL, 0x000fc4000001ff00ULL, 0x0000000000527805ULL, 0x000fe4000001ff00ULL,
0x00000000004e7805ULL, 0x000fe4000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x018b8804ff0479a7ULL, 0x008e620008500006ULL, 0x00000000004a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000487805ULL, 0x000fe4000001ff00ULL, 0x0000000000467805ULL, 0x000fc4000001ff00ULL,
0x0000000000447805ULL, 0x000fe4000001ff00ULL, 0x0000000000427805ULL, 0x000fe4000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x000000ffff117224ULL, 0x000fe200078e00ffULL,
0x00000000000e7805ULL, 0x000fe4000001ff00ULL, 0x00000000000c7805ULL, 0x000fe4000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff097224ULL, 0x000fe200078e00ffULL,
0x0000017c00a88947ULL, 0x002fec0003800000ULL, 0x0000840000047ab9ULL, 0x000fe20000000800ULL,
0x000000ffff157224ULL, 0x004fe200078e0003ULL, 0x0000000604087899ULL, 0x000fe2000800063fULL,
0x000000ffff1d7224ULL, 0x002fe200078e0005ULL, 0x0000003f00057c82ULL, 0x000fe20008000000ULL,
0xff317217ff087424ULL, 0x000fe200078e00ffULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0x000000ffff5a7224ULL, 0x000fce00078e00ffULL, 0x00000008040a7899ULL, 0x000fc8000800063fULL,
0x0000000d0a00728cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000017c00680947ULL, 0x00efea0003800000ULL, 0x000000ffff6a7224ULL, 0x000fce00078e00ffULL,
0x000000045c007c0cULL, 0x000fe4000bf04070ULL, 0x00000002ff057819ULL, 0x000fe4000001166aULL,
0x000000036a007812ULL, 0x040fe400078ec0ffULL, 0x000000056a057207ULL, 0x000fe40000000000ULL,
0x000000ff00007207ULL, 0x000fe40004000000ULL, 0x0000000305027812ULL, 0x000fc400078ec0ffULL,
0x0000000405057c11ULL, 0x00cfe4000f8ff0ffULL, 0x0000000000167805ULL, 0x000fe20000015200ULL,
0x018b7815ff0075a7ULL, 0x000e640008020146ULL, 0x00000000005c1947ULL, 0x002fea0003800000ULL,
0x000000ffff1a7224ULL, 0x000fce00078e00ffULL, 0x000000101a00780cULL, 0x000fda0003f26270ULL,
0x0000000000449947ULL, 0x000fea0003800000ULL, 0x0000000000187805ULL, 0x000fcc0000015200ULL,
0x00000018161b7210ULL, 0x000fca0007f3e1ffULL, 0x0000000119197824ULL, 0x000fe200008e0e17ULL,
0x003d09001b00780cULL, 0x000fc80003f26070ULL, 0x000000ff1900720cULL, 0x000fda0003f26310ULL,
0x0000000000089947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401b00780cULL, 0x000fc80003f26070ULL,
0x000000ff1900720cULL, 0x000fda0003f26310ULL, 0x00000000001c9947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011419ULL, 0x0000001b14147211ULL, 0x000fca00078310ffULL,
0x000000ffff197224ULL, 0x000fca00008e0619ULL, 0x0000000214147819ULL, 0x000fc80000001219ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011a1a7836ULL, 0x000fce0000000000ULL, 0x018b7815ff0075a7ULL, 0x000e640008020146ULL,
0xfffffffc00a89947ULL, 0x002fea000383ffffULL, 0x0000000000147805ULL, 0x000fe20000015200ULL,
0x018b881dff0075a7ULL, 0x000e640008020146ULL, 0x00000000005c1947ULL, 0x002fea0003800000ULL,
0x000000ffff187224ULL, 0x000fce00078e00ffULL, 0x000000101800780cULL, 0x000fda0003f26270ULL,
0x0000000000449947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x0000001614197210ULL, 0x000fca0007f3e1ffULL, 0x0000000117177824ULL, 0x000fe200008e0e15ULL,
0x003d09001900780cULL, 0x000fc80003f26070ULL, 0x000000ff1700720cULL, 0x000fda0003f26310ULL,
0x0000000000089947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f26070ULL,
0x000000ff1700720cULL, 0x000fda0003f26310ULL, 0x00000000001c9947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000001916167211ULL, 0x000fca00078310ffULL,
0x000000ffff177224ULL, 0x000fca00008e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000118187836ULL, 0x000fce0000000000ULL, 0x018b881dff0075a7ULL, 0x000e640008020146ULL,
0xfffffffc00a89947ULL, 0x002fea000383ffffULL, 0x0000000105147836ULL, 0x000fca0000000000ULL,
0x0000001014007c0cULL, 0x000fda000bf26070ULL, 0x0000000400649947ULL, 0x000fea0003800000ULL,
0x00000004ff1e7819ULL, 0x000fe20000011610ULL, 0x0000000405167824ULL, 0x000fe200078e0202ULL,
0x00000020131b7811ULL, 0x000fe200078e30ffULL, 0x00000010101a7824ULL, 0x000fe200078e00ffULL,
0x00016000060a7890ULL, 0x000fe2000fffe03fULL, 0x000000015b197824ULL, 0x000fe200078e021eULL,
0x0000002016167811ULL, 0x000fe200078e30ffULL, 0x000000021e207836ULL, 0x000fe20000000000ULL,
0x000000f01a217812ULL, 0x000fe200078ec0ffULL, 0x00000001191c7824ULL, 0x040fe200078e0210ULL,
0x00000006191f7c11ULL, 0x000fe2000f8e10ffULL, 0x000000015b227824ULL, 0x000fe200078e0220ULL,
0x0000000d16177c48ULL, 0x000fc6000ffe0000ULL, 0x018a00001f147984ULL, 0x000e620000000800ULL,
0x0000000122237824ULL, 0x000fe400078e0210ULL, 0x0000000117167824ULL, 0x000fe400078e0a16ULL,
0x0000000119177824ULL, 0x040fe400078e021bULL, 0x0000001019197824ULL, 0x000fe200078e00ffULL,
0x000000165b167248ULL, 0x000fc80007fe0000ULL, 0xfffffff0191c7812ULL, 0x000fe200078ee21cULL,
0x00000001161a7824ULL, 0x000fc600078e0a5bULL, 0x0000000a1c1d7c11ULL, 0x000fe4000f8e20ffULL,
0x0000001a1e00720cULL, 0x000fe40003f26070ULL, 0x0000000614187c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e680000000a00ULL, 0x018ac00018187984ULL, 0x000ea40000000800ULL,
0x0000000818177c24ULL, 0x004fc8000f8e0217ULL, 0x0000010017167825ULL, 0x002fc600078e0014ULL,
0x0000002116187210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff197224ULL, 0x000fe400010e0617ULL,
0x0000000122177824ULL, 0x040fe400078e021bULL, 0x0000001022227824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000181d7faeULL, 0x0003e2000c901c4eULL,
0x0000001a2000720cULL, 0x000fe20003f26070ULL, 0x000000041e207836ULL, 0x000fe40000000000ULL,
0x018a08001f167984ULL, 0x000ea20000000800ULL, 0x000000061e1e7836ULL, 0x000fe20000000000ULL,
0xfffffff0221d7812ULL, 0x002fe200078ee223ULL, 0x000000015b227824ULL, 0x000fc600078e0220ULL,
0x0000000a1d1d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000122237824ULL, 0x000fe200078e0210ULL,
0x00000006161c7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0001c167984ULL, 0x000e640000000800ULL,
0x0000000816177c24ULL, 0x002fc8000f8e0217ULL, 0x0000010017167825ULL, 0x000fc600078e0014ULL,
0x0000002116187210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff197224ULL, 0x000fe400010e0617ULL,
0x0000000122177824ULL, 0x040fe400078e021bULL, 0x0000001022227824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000181d7faeULL, 0x0003e2000c901c4eULL,
0x0000001a2000720cULL, 0x000fc60003f26070ULL, 0x018a10001f167984ULL, 0x000ea20000000800ULL,
0xfffffff022197812ULL, 0x002fc800078ee223ULL, 0x0000000a19197c11ULL, 0x000fe4000f8e20ffULL,
0x00000006161c7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0001c167984ULL, 0x0002a40000000800ULL,
0x000000015b1c7824ULL, 0x002fc800078e021eULL, 0x000000011c1b7824ULL, 0x040fe400078e021bULL,
0x000000011c1d7824ULL, 0x040fe400078e0210ULL, 0x000000101c1c7824ULL, 0x000fe400078e00ffULL,
0x0000000816177c24ULL, 0x004fc8000f8e0217ULL, 0x0000010017167825ULL, 0x000fc600078e0014ULL,
0x0000002116167210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff177224ULL, 0x000fca00010e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016197faeULL, 0x0003e2000c901c4eULL,
0x0000001a1e00720cULL, 0x000fc60003f26070ULL, 0x018a18001f187984ULL, 0x000ea20000000800ULL,
0xfffffff01c177812ULL, 0x002fc800078ee21dULL, 0x0000000a17177c11ULL, 0x000fe4000f8e20ffULL,
0x0000000618187c11ULL, 0x004fcc000f8e10ffULL, 0x018ac00018187984ULL, 0x000e640000000800ULL,
0x00000008181b7c24ULL, 0x002fc8000f8e021bULL, 0x000001001b147825ULL, 0x000fc600078e0014ULL,
0x0000002114147210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff157224ULL, 0x000fca00010e0615ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e2000c901c4eULL,
0x0000000400287947ULL, 0x000fea0003800000ULL, 0x0000005b101f7211ULL, 0x040fe200078fe0ffULL,
0x0000001010197824ULL, 0x000fe200078e00ffULL, 0x0000002013207811ULL, 0x000fe200078e30ffULL,
0x00016000060a7890ULL, 0x000fe4000fffe03fULL, 0x000000061f1e7c11ULL, 0x040fe2000f8e10ffULL,
0x000000101f1a7824ULL, 0x000fe200078e00ffULL, 0x000000f019217812ULL, 0x000fe200078ec0ffULL,
0x000000011f177824ULL, 0x040fe400078e0220ULL, 0x018a00001e147984ULL, 0x000e620000000800ULL,
0x000000011f197824ULL, 0x000fc400078e0210ULL, 0x000000021f1b7836ULL, 0x000fc60000000000ULL,
0xfffffff01a1d7812ULL, 0x000fe200078ee219ULL, 0x000000011b227824ULL, 0x000fc600078e0210ULL,
0x0000000a1d1d7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000614187c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e660000000a00ULL, 0x018ac00018167984ULL, 0x000ea40000000800ULL,
0x0000000816177c24ULL, 0x004fc8000f8e0217ULL, 0x0000010017167825ULL, 0x002fc600078e0014ULL,
0x0000002116187210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff197224ULL, 0x000fe400008e0617ULL,
0x000000011b177824ULL, 0x040fe400078e0220ULL, 0x000000101b1b7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000181d7faeULL, 0x0003e8000b901c4eULL,
0x018a08001e167984ULL, 0x000ea20000000800ULL, 0xfffffff01b197812ULL, 0x002fe200078ee222ULL,
0x000000041f1d7836ULL, 0x000fc40000000000ULL, 0x000000061f1f7836ULL, 0x000fe20000000000ULL,
0x0000000a19197c11ULL, 0x000fe4000f8e20ffULL, 0x00000006161c7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001c167984ULL, 0x0002a40000000800ULL, 0x000000011d1c7824ULL, 0x002fe400078e0210ULL,
0x0000000816177c24ULL, 0x004fc8000f8e0217ULL, 0x0000010017167825ULL, 0x000fc600078e0014ULL,
0x00000021161a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff1b7224ULL, 0x000fe400008e0617ULL,
0x000000011d177824ULL, 0x140fe400078e0220ULL, 0x000000101d1d7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a197faeULL, 0x0003e8000b901c4eULL,
0x018a10001e167984ULL, 0x000ea20000000800ULL, 0xfffffff01d197812ULL, 0x002fe200078ee21cULL,
0x000000011f1b7824ULL, 0x000fc400078e0220ULL, 0x000000011f1a7824ULL, 0x000fe200078e0210ULL,
0x0000000a19197c11ULL, 0x000fe2000f8e20ffULL, 0x000000101f1f7824ULL, 0x000fe200078e00ffULL,
0x0000000616187c11ULL, 0x004fca000f8e10ffULL, 0x018ac00018167984ULL, 0x000e640000000800ULL,
0x0000000816177c24ULL, 0x002fc8000f8e0217ULL, 0x0000010017167825ULL, 0x000fc600078e0014ULL,
0x0000002116167210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff177224ULL, 0x000fca00008e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016197faeULL, 0x0003e8000b901c4eULL,
0x018a18001e187984ULL, 0x000ea20000000800ULL, 0xfffffff01f177812ULL, 0x002fc800078ee21aULL,
0x0000000a17177c11ULL, 0x000fe4000f8e20ffULL, 0x0000000618187c11ULL, 0x004fcc000f8e10ffULL,
0x018ac00018187984ULL, 0x000e640000000800ULL, 0x00000008181b7c24ULL, 0x002fc8000f8e021bULL,
0x000001001b147825ULL, 0x000fc600078e0014ULL, 0x0000002114147210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff157224ULL, 0x000fca00008e0615ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014177faeULL, 0x0003e6000b901c4eULL, 0x00000001ff147424ULL, 0x002fcc00078e00ffULL,
0x018b8814ff1479a7ULL, 0x000e640008500006ULL, 0x000000ffff187224ULL, 0x002fe200078e0015ULL,
0x0000000000147805ULL, 0x000fc60000015200ULL, 0x018b8818ff0075a7ULL, 0x000e640008020146ULL,
0x00000000005c1947ULL, 0x002fea0003800000ULL, 0x000000ffff1a7224ULL, 0x000fce00078e00ffULL,
0x000000101a00780cULL, 0x000fda0003f26270ULL, 0x0000000000449947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614197210ULL, 0x000fca0007f3e1ffULL,
0x0000000117177824ULL, 0x000fe200008e0e15ULL, 0x003d09001900780cULL, 0x000fc80003f26070ULL,
0x000000ff1700720cULL, 0x000fda0003f26310ULL, 0x0000000000089947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f26070ULL, 0x000000ff1700720cULL, 0x000fda0003f26310ULL,
0x00000000001c9947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000001916167211ULL, 0x000fca00078310ffULL, 0x000000ffff177224ULL, 0x000fca00008e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011a1a7836ULL, 0x000fce0000000000ULL,
0x018b8818ff0075a7ULL, 0x000e640008020146ULL, 0xfffffffc00a89947ULL, 0x002fea000383ffffULL,
0x000000055c00720cULL, 0x080fe20003f44070ULL, 0x0000000100157836ULL, 0x000fe20000000000ULL,
0x000000030000780cULL, 0x000fe20003f85270ULL, 0x000000205f6b7824ULL, 0x000fe200078e0210ULL,
0x000000055c00720cULL, 0x000fe20003f64070ULL, 0x00018b80060a7890ULL, 0x000fe2000fffe03fULL,
0x0000000315147812ULL, 0x000fe200078ec0ffULL, 0x00000001ff6e7424ULL, 0x000fe200078e00ffULL,
0x0000001f6b00780cULL, 0x000fca0003f24070ULL, 0x00000002ff15a819ULL, 0x000fca0000011615ULL,
0x0000000102027824ULL, 0x000fc800078e0215ULL, 0x0000004002007824ULL, 0x040fe200078e00ffULL,
0x0000000502027211ULL, 0x000fc800078ff0ffULL, 0x000000c000057812ULL, 0x000fca00078ec0ffULL,
0x0000010002167824ULL, 0x000fe200078e0205ULL, 0x000000ff14027207ULL, 0x000fe20005000000ULL,
0x000000000050b947ULL, 0x000fec0002000000ULL, 0x000000205f177824ULL, 0x000fe200078e0210ULL,
0x0000000105057890ULL, 0x000fe2000fffe03fULL, 0x0000011000007945ULL, 0x000fe60003800000ULL,
0x000000031700780cULL, 0x000fda0003f44070ULL, 0x0000000000382947ULL, 0x000fea0003800000ULL,
0x00009000ff187b82ULL, 0x000e620000000800ULL, 0x000000070500728cULL, 0x000fe2000bf06070ULL,
0x0000000412007824ULL, 0x000fe200078e0217ULL, 0x0000000617177c11ULL, 0x000fc6000f8e10ffULL,
0x0000000200057824ULL, 0x000fe200078e00ffULL, 0x000000000000781cULL, 0x000fe20003f4f008ULL,
0x00008c00ff147b82ULL, 0x000ea20000000a00ULL, 0x0000000518007c36ULL, 0x002fc80008000000ULL,
0x0000001805057224ULL, 0x000fc800078e0200ULL, 0x0000000405147825ULL, 0x004fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18ac000014177faeULL, 0x0003e4000d12184eULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe80003800000ULL,
0x0000000000341947ULL, 0x000fea0003800000ULL, 0x00009200ff147b82ULL, 0x002e620000000a00ULL,
0x000000015d007824ULL, 0x000fe200078e0202ULL, 0x00009400000b7ab9ULL, 0x000fe20000000800ULL,
0x000000016b027824ULL, 0x140fe200078e0216ULL, 0x000000066b177c11ULL, 0x000fe2000f8e10ffULL,
0x0000000b00007c24ULL, 0x000fc6000f8e0216ULL, 0x0000000d02007c0cULL, 0x000fe2000bf46070ULL,
0x000000016b057824ULL, 0x000fc800078e0200ULL, 0x0000000405147825ULL, 0x002fd000078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18a0000014177faeULL, 0x0003e4000d12184eULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a4aULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000ff6a00720cULL, 0x000fe20003f45270ULL, 0x018b806eff6479a7ULL, 0x0004d80008500006ULL,
0x0000000400942947ULL, 0x004fea0003800000ULL, 0x018ad86e5b1479a7ULL, 0x002e640008500006ULL,
0x000000ffff027224ULL, 0x002fce00078e0015ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x018ad8025b0075a7ULL, 0x000e640008040146ULL, 0x00000000005c2947ULL, 0x002fea0003800000ULL,
0x000000ffff077224ULL, 0x000fce00078e00ffULL, 0x000000100700780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614057210ULL, 0x000fca0007f5e1ffULL, 0x0000000117167824ULL, 0x000fe200010e0e15ULL,
0x003d09000500780cULL, 0x000fc80003f46070ULL, 0x000000ff1600720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400500780cULL, 0x000fc80003f46070ULL,
0x000000ff1600720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011416ULL, 0x0000000500007211ULL, 0x000fca00078510ffULL,
0x000000ffff057224ULL, 0x000fca00010e0616ULL, 0x0000000200007819ULL, 0x000fc80000001205ULL,
0x000000000000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000107077836ULL, 0x000fce0000000000ULL, 0x018ad8025b0075a7ULL, 0x000e640008040146ULL,
0xfffffffc00a8a947ULL, 0x002fea000383ffffULL, 0x0000001010007824ULL, 0x000fe200078e00ffULL,
0x00000001ff027819ULL, 0x000fe20000011610ULL, 0x00000001ff077424ULL, 0x000fe400078e00ffULL,
0x000000ffff157224ULL, 0x000fe200078e0008ULL, 0x0000007000007812ULL, 0x000fe400078ec0ffULL,
0x0000000c02057812ULL, 0x000fc800078ec0ffULL, 0x0000000605007c10ULL, 0x000fca000fffe000ULL,
0x0180000000057984ULL, 0x000e680000000800ULL, 0x0182000000147984ULL, 0x0004a20000000800ULL,
0x000000080500720bULL, 0x002fda0003f5d000ULL, 0x0000000000027806ULL, 0x000fc800010e0100ULL,
0x0000ffff02167812ULL, 0x000fda000784c0ffULL, 0x0000000000e8a947ULL, 0x00cfea0003800000ULL,
0x000000080500720bULL, 0x000fe40003f54000ULL, 0x000000ff5f00720cULL, 0x000fe40003f65270ULL,
0x0000000508157209ULL, 0x000fd20007810000ULL, 0x0000000000177806ULL, 0x000fe400010e0100ULL,
0x018400150000b388ULL, 0x0003e40000000800ULL, 0x0000991017027816ULL, 0x000fc800000000ffULL,
0x000000ff0200720cULL, 0x000fda0003f45270ULL, 0x0000000000b0a947ULL, 0x002fea0003800000ULL,
0x8000001508007221ULL, 0x000fe20000010000ULL, 0x000000ff17ff7812ULL, 0x040fe4000784c0ffULL,
0x0000ff0017ff7812ULL, 0x000fe2000786c0ffULL, 0x3fb8aa3b00007820ULL, 0x000fc80000410000ULL,
0x0000000000197308ULL, 0x0002ac0000000800ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x00000002ff007819ULL, 0x002fcc0000011610ULL, 0x00001f0019007589ULL, 0x004e6400000e0000ULL,
0x000000000b0b7220ULL, 0x082fe20000410000ULL, 0x000000000a0a7220ULL, 0x080fe20000410000ULL,
0x000000000f0f7220ULL, 0x080fe20000410000ULL, 0x000000000e0e7220ULL, 0x080fe20000410000ULL,
0x0000000041417220ULL, 0x080fe20000410000ULL, 0x0000000042427220ULL, 0x080fe20000410000ULL,
0x0000000045457220ULL, 0x080fe20000410000ULL, 0x0000000046467220ULL, 0x080fe20000410000ULL,
0x0000000049497220ULL, 0x080fe20000410000ULL, 0x000000004a4a7220ULL, 0x080fe20000410000ULL,
0x000000004d4d7220ULL, 0x080fe20000410000ULL, 0x000000004e4e7220ULL, 0x080fe20000410000ULL,
0x0000000053537220ULL, 0x080fe20000410000ULL, 0x0000000054547220ULL, 0x080fe20000410000ULL,
0x0000000057577220ULL, 0x080fe20000410000ULL, 0x0000000058587220ULL, 0x000fce0000410000ULL,
0x0000001909097220ULL, 0x004fe20000410000ULL, 0x000000000048b947ULL, 0x000fec0003800000ULL,
0x0000000810007811ULL, 0x002fcc00078ff0ffULL, 0x00001f0019007589ULL, 0x000e6400000e0000ULL,
0x000000000d0d7220ULL, 0x082fe20000410000ULL, 0x000000000c0c7220ULL, 0x080fe20000410000ULL,
0x0000000011117220ULL, 0x080fe20000410000ULL, 0x0000000040407220ULL, 0x080fe20000410000ULL,
0x0000000043437220ULL, 0x080fe20000410000ULL, 0x0000000044447220ULL, 0x080fe20000410000ULL,
0x0000000047477220ULL, 0x080fe20000410000ULL, 0x0000000048487220ULL, 0x080fe20000410000ULL,
0x000000004b4b7220ULL, 0x080fe20000410000ULL, 0x000000004c4c7220ULL, 0x080fe20000410000ULL,
0x000000004f4f7220ULL, 0x080fe20000410000ULL, 0x0000000052527220ULL, 0x080fe20000410000ULL,
0x0000000055557220ULL, 0x080fe20000410000ULL, 0x0000000056567220ULL, 0x080fe20000410000ULL,
0x0000000059597220ULL, 0x080fe20000410000ULL, 0x000000005a5a7220ULL, 0x000fce0000410000ULL,
0x0000ffff16ff7812ULL, 0x000fda0007846017ULL, 0x8000001505052221ULL, 0x000fe20000010000ULL,
0x00007610ff072816ULL, 0x000fc60000000007ULL, 0x3fb8aa3b05052820ULL, 0x000fc80000410000ULL,
0x0000000500062308ULL, 0x000ea40000000800ULL, 0x0000000614142220ULL, 0x004fce0000410000ULL,
0x0000000914097221ULL, 0x000fe20000010000ULL, 0x000000ffff087224ULL, 0x000fce00078e0015ULL,
0x0000000710057812ULL, 0x040fe400078ec0ffULL, 0x000000ff07ff7812ULL, 0x000fe4000786c0ffULL,
0x00000004ff647819ULL, 0x008fe40000011610ULL, 0x0000000805667812ULL, 0x000fe400078ef810ULL,
0x0000000810057812ULL, 0x000fe200078ec0ffULL, 0x000000045f6d7824ULL, 0x000fe400078e0264ULL,
0x0000000164697824ULL, 0x000fe200078e0266ULL, 0x00000007056c7812ULL, 0x000fe200078ef810ULL,
0x0000000866007824ULL, 0x002fc800078e00ffULL, 0x000000016c027824ULL, 0x040fe200078e026dULL,
0xfffffff800057812ULL, 0x000fe200078ee269ULL, 0x000000106c177824ULL, 0x000fc600078e00ffULL,
0x0000000605057c11ULL, 0x000fe2000f8e20ffULL, 0x0000000000183947ULL, 0x000fec0003800000ULL,
0x00000002ff037819ULL, 0x000fe40000011610ULL, 0x00000006ff00723eULL, 0x000fc600000010ffULL,
0x0000000803157836ULL, 0x000fe20000000000ULL, 0x0000541000007816ULL, 0x000fca0000000000ULL,
0x00001f0300037589ULL, 0x0002a800000e0000ULL, 0x00001f1500047589ULL, 0x0002e400000e0000ULL,
0x012000000530783bULL, 0x0002e20000000200ULL, 0x0000000000103947ULL, 0x000fea0003800000ULL,
0x0000000330307232ULL, 0x08cfe40000200000ULL, 0x0000000332327232ULL, 0x000fe40000200000ULL,
0x0000000431317232ULL, 0x080fe40000200000ULL, 0x0000000433337232ULL, 0x000fce0000200000ULL,
0x000000025f3d7811ULL, 0x000fe200078e10ffULL, 0x00014000060b7890ULL, 0x000fe2000fffe03fULL,
0xfffffff017027812ULL, 0x000fe200078ee202ULL, 0x000000106c197824ULL, 0x000fe400078e00ffULL,
0x0000000164637824ULL, 0x000fe400078e023dULL, 0x0000000b02027c11ULL, 0x000fe4000f8e20ffULL,
0x000000016c007824ULL, 0x002fc600078e0263ULL, 0x000000000214783bULL, 0x000e640000004200ULL,
0xfffffff019007812ULL, 0x000fc800078ee200ULL, 0x0000000b00007c11ULL, 0x000fca000f8e20ffULL,
0x000000000018783bULL, 0x000f220000004200ULL, 0x00000010ff367819ULL, 0x002fe40000011614ULL,
0x00000010ff267819ULL, 0x000fe40000011617ULL, 0x000000ff36367812ULL, 0x000fe400078ec0ffULL,
0x00000010ff2f7819ULL, 0x100fe40000011616ULL, 0x000000ff16237812ULL, 0x000fe400078ec0ffULL,
0x00000018ff227819ULL, 0x000fc40000011616ULL, 0x0000ffff16297812ULL, 0x000fe400078ec0ffULL,
0x000000ff19397812ULL, 0x010fe400078ec0ffULL, 0x000000ff172a7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff167819ULL, 0x000fe40000011617ULL, 0x0000ffff172e7812ULL, 0x000fe400078ec0ffULL,
0x000000ff26267812ULL, 0x000fc400078ec0ffULL, 0x00000010ff277819ULL, 0x100fe40000011618ULL,
0x000000ff182b7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff177819ULL, 0x000fe40000011618ULL,
0x0000ffff18287812ULL, 0x000fe400078ec0ffULL, 0x00000010ff187819ULL, 0x000fe4000001161aULL,
0x000000ff1a3b7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff3a7819ULL, 0x000fe4000001161aULL,
0x0000ffff1a217812ULL, 0x000fe400078ec0ffULL, 0x00000036ff36723eULL, 0x000fe400020006ffULL,
0x00000039ff1a723eULL, 0x000fe400020006ffULL, 0x000000ff2f397812ULL, 0x000fe200078ec0ffULL,
0x20000036ff2f7230ULL, 0x000fe20000004100ULL, 0x00000026ff26723eULL, 0x000fe200020006ffULL,
0x2000001aff1a7230ULL, 0x000fe20000004100ULL, 0x000000ff27277812ULL, 0x000fc400078ec0ffULL,
0x00000008ff287819ULL, 0x000fe40000011628ULL, 0x0000ffff19257812ULL, 0x000fe400078ec0ffULL,
0x0000ffff14377812ULL, 0x000fe400078ec0ffULL, 0x00000039ff36723eULL, 0x000fe200020006ffULL,
0x20000026ff397230ULL, 0x000fe20000004100ULL, 0x00000010ff357819ULL, 0x000fe40000011615ULL,
0x00000027ff27723eULL, 0x000fe200020006ffULL, 0x20000036ff367230ULL, 0x000fe20000004100ULL,
0x0000ffff15347812ULL, 0x000fc400078ec0ffULL, 0x00000028ff26723eULL, 0x000fe400020006ffULL,
0x00000008ff287819ULL, 0x000fe20000011625ULL, 0x20000027ff257230ULL, 0x000fe20000004100ULL,
0x00000008ff377819ULL, 0x000fe20000011637ULL, 0x20000026ff267230ULL, 0x000fe20000004100ULL,
0x00000018ff1c7819ULL, 0x000fe40000011614ULL, 0x00000010ff247819ULL, 0x000fe4000001161bULL,
0x000000ff35357812ULL, 0x000fc400078ec0ffULL, 0x00000008ff347819ULL, 0x000fe40000011634ULL,
0x000000ff141d7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff1e7819ULL, 0x000fe40000011615ULL,
0x00000008ff2e7819ULL, 0x000fe4000001162eULL, 0x00000028ff27723eULL, 0x000fe400020006ffULL,
0x000000ff151f7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff207819ULL, 0x100fe20000011619ULL,
0x20000027ff277230ULL, 0x000fe20000004100ULL, 0x00000018ff387819ULL, 0x000fe40000011619ULL,
0x00000037ff37723eULL, 0x000fe400020006ffULL, 0x00000008ff287819ULL, 0x000fe40000011621ULL,
0x0000001cff1c723eULL, 0x000fe400020006ffULL, 0x00000035ff35723eULL, 0x000fc400020006ffULL,
0x000000ff24247812ULL, 0x000fe200078ec0ffULL, 0x2000001cff2c7230ULL, 0x000fe20000004100ULL,
0x00000034ff34723eULL, 0x000fe400020006ffULL, 0x0000001dff14723eULL, 0x000fe400020006ffULL,
0x0000ffff1b157812ULL, 0x000fe400078ec0ffULL, 0x0000001eff19723eULL, 0x000fe200020006ffULL,
0x20000014ff147230ULL, 0x000fe20000004100ULL, 0x0000002eff2e723eULL, 0x000fc400020006ffULL,
0x0000001fff1f723eULL, 0x000fe200020006ffULL, 0x20000019ff197230ULL, 0x000fe20000004100ULL,
0x00000038ff1e723eULL, 0x000fe200020006ffULL, 0x20000037ff387230ULL, 0x000fe20000004100ULL,
0x000000ff20207812ULL, 0x000fe200078ec0ffULL, 0x20000035ff377230ULL, 0x000fe20000004100ULL,
0x00000028ff28723eULL, 0x000fe200020006ffULL, 0x20000034ff357230ULL, 0x000fe20000004100ULL,
0x00000024ff24723eULL, 0x000fe200020006ffULL, 0x2000002eff347230ULL, 0x000fe20000004100ULL,
0x0000002aff1c723eULL, 0x000fe200020006ffULL, 0x2000001fff2d7230ULL, 0x000fe20000004100ULL,
0x00000008ff297819ULL, 0x000fe20000011629ULL, 0x20000028ff2e7230ULL, 0x000fe20000004100ULL,
0x00000008ff157819ULL, 0x000fe20000011615ULL, 0x20000024ff287230ULL, 0x000fe20000004100ULL,
0x00000023ff1d723eULL, 0x000fe200020006ffULL, 0x2000001cff1c7230ULL, 0x000fe20000004100ULL,
0x00000020ff20723eULL, 0x000fe200020006ffULL, 0x2000001eff1e7230ULL, 0x000fe20000004100ULL,
0x000000ff1b3e7812ULL, 0x000fe200078ec0ffULL, 0x2000001dff1d7230ULL, 0x000fe20000004100ULL,
0x00000018ff3c7819ULL, 0x000fe2000001161bULL, 0x20000020ff217230ULL, 0x000fe20000004100ULL,
0x00000022ff1b723eULL, 0x000fc400020006ffULL, 0x00000029ff29723eULL, 0x000fe400020006ffULL,
0x00000015ff24723eULL, 0x000fe200020006ffULL, 0x2000001bff1b7230ULL, 0x000fe20000004100ULL,
0x00000016ff16723eULL, 0x000fe400020006ffULL, 0x00000010ff147819ULL, 0x000fe40000011614ULL,
0x00000010ff157819ULL, 0x000fe2000001162fULL, 0x20000024ff2f7230ULL, 0x000fe20000004100ULL,
0x0000002bff2b723eULL, 0x000fc400020006ffULL, 0x00000010ff2d7819ULL, 0x000fe4000001162dULL,
0x00000010ff207819ULL, 0x000fe40000011637ULL, 0x0000003aff2a723eULL, 0x000fe200020006ffULL,
0x20000029ff3a7230ULL, 0x000fe20000004100ULL, 0x00000017ff23723eULL, 0x000fe200020006ffULL,
0x20000016ff177230ULL, 0x000fe20000004100ULL, 0x000000ff18187812ULL, 0x000fe200078ec0ffULL,
0x2000002bff167230ULL, 0x000fe20000004100ULL, 0x0000105415147816ULL, 0x000fe20000000014ULL,
0x20000023ff237230ULL, 0x000fe20000004100ULL, 0x00000010ff247819ULL, 0x000fe2000001161cULL,
0x2000002aff2a7230ULL, 0x000fe20000004100ULL, 0x0000105420157816ULL, 0x000fc4000000002dULL,
0x00000010ff1d7819ULL, 0x000fe4000001161dULL, 0x00000010ff1c7819ULL, 0x000fe40000011636ULL,
0x00000010ff207819ULL, 0x000fe40000011619ULL, 0x00000010ff397819ULL, 0x000fe40000011639ULL,
0x00000010ff197819ULL, 0x000fe40000011635ULL, 0x0000003bff1f723eULL, 0x000fc400020006ffULL,
0x0000003eff22723eULL, 0x000fe400020006ffULL, 0x00000018ff18723eULL, 0x000fe200020006ffULL,
0x2000001fff1f7230ULL, 0x000fe20000004100ULL, 0x00000010ff1b7819ULL, 0x000fe2000001161bULL,
0x20000022ff227230ULL, 0x000fe20000004100ULL, 0x00000010ff3a7819ULL, 0x000fe2000001163aULL,
0x20000018ff297230ULL, 0x000fe20000004100ULL, 0x000010541c1c7816ULL, 0x000fe4000000001dULL,
0x00001054391d7816ULL, 0x000fc40000000024ULL, 0x00000010ff3b7819ULL, 0x000fe4000001162cULL,
0x0000105420197816ULL, 0x000fe40000000019ULL, 0x00000010ff247819ULL, 0x000fe40000011616ULL,
0x00000010ff257819ULL, 0x000fe40000011625ULL, 0x000010541b207816ULL, 0x000fe4000000003aULL,
0x00000010ff2c7819ULL, 0x000fc4000001161aULL, 0x00000010ff2d7819ULL, 0x000fe40000011621ULL,
0x00000010ff1b7819ULL, 0x000fe40000011617ULL, 0x00000010ff347819ULL, 0x000fe20000011634ULL,
0x000000143014723cULL, 0x008fe200000418ffULL, 0x0000105425247816ULL, 0x000fe40000000024ULL,
0x0000003cff2b723eULL, 0x000fe400020006ffULL, 0x000010542d257816ULL, 0x000fc4000000002cULL,
0x000010541b217816ULL, 0x000fe20000000034ULL, 0x2000002bff2b7230ULL, 0x000fe20000004100ULL,
0x00000010ff2d7819ULL, 0x000fe40000011623ULL, 0x00000010ff2c7819ULL, 0x000fe4000001161eULL,
0x00000010ff267819ULL, 0x000fe40000011626ULL, 0x00000010ff277819ULL, 0x000fe40000011627ULL,
0x00000010ff347819ULL, 0x000fc4000001161fULL, 0x00000010ff367819ULL, 0x000fe20000011622ULL,
0x0000001c301c723cULL, 0x000fe200000418ffULL, 0x00000010ff357819ULL, 0x000fe40000011629ULL,
0x00000010ff377819ULL, 0x000fe40000011628ULL, 0x000010542d287816ULL, 0x000fe20000000026ULL,
0x000000203020723cULL, 0x000fe200000418ffULL, 0x000010542c297816ULL, 0x000fe40000000027ULL,
0x00001054352c7816ULL, 0x000fe20000000034ULL, 0x0000000269347836ULL, 0x000fe20000000000ULL,
0x00001054372d7816ULL, 0x000fe20000000036ULL, 0x0000000866377824ULL, 0x000fe200078e00ffULL,
0x00000010ff187819ULL, 0x000fe20000011638ULL, 0x000000243024723cULL, 0x000fe200000418ffULL,
0x00000010ff357819ULL, 0x000fc4000001162aULL, 0x00000010ff2e7819ULL, 0x000fe4000001162eULL,
0x00000010ff367819ULL, 0x000fe4000001162bULL, 0x00000010ff2f7819ULL, 0x000fe2000001162fULL,
0x000000283028723cULL, 0x000fe200000418ffULL, 0x000000106c3c7812ULL, 0x000fe400078efcffULL,
0xfffffff8375e7812ULL, 0x000fe400078ee234ULL, 0x000010543b187816ULL, 0x000fe20000000018ULL,
0x000000016d687824ULL, 0x000fe200078e023cULL, 0x0000105435347816ULL, 0x000fe2000000002eULL,
0x000000103c377824ULL, 0x000fe200078e00ffULL, 0x0000105436357816ULL, 0x000fc4000000002fULL,
0x000000065e5e7c11ULL, 0x000fe2000f8e20ffULL, 0x000000183018723cULL, 0x000fe200000418ffULL,
0xfffffff037687812ULL, 0x000fca00078ee268ULL, 0x0000002c302c723cULL, 0x000fec00000418ffULL,
0x000000343030723cULL, 0x000fe200000418ffULL, 0x012000005e34783bULL, 0x0002e20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000103947ULL, 0x000fde0003800000ULL,
0x0000000334347232ULL, 0x08cfe40000200000ULL, 0x0000000336367232ULL, 0x000fe40000200000ULL,
0x0000000435357232ULL, 0x080fe40000200000ULL, 0x0000000437377232ULL, 0x000fce0000200000ULL,
0x0000000b68607c11ULL, 0x000fe2000f8e20ffULL, 0x00000ca000007945ULL, 0x000fe20003800000ULL,
0x0000003d3c677210ULL, 0x040fe20007ffe064ULL, 0x000000103c3c7824ULL, 0x000fe200078e00ffULL,
0x000000045c007c0cULL, 0x040fe2000bfc3070ULL, 0x000000006038783bULL, 0x000f220000004200ULL,
0x000000045c007c0cULL, 0x000fe4000bf43070ULL, 0xfffffff03c677812ULL, 0x000fc800078ee267ULL,
0x0000000b67617c11ULL, 0x000fe4000f8e20ffULL, 0x000000ff383e7812ULL, 0x010fe400078ec0ffULL,
0x000000ff393f7812ULL, 0x000fe400078ec0ffULL, 0x0000003eff3e723eULL, 0x000fe400020006ffULL,
0x0000003fff3f723eULL, 0x000fe400020006ffULL, 0x00000018ff3d7819ULL, 0x100fe20000011638ULL,
0x2000003eff3c7230ULL, 0x000fe20000004100ULL, 0x00000010ff507819ULL, 0x000fe20000011639ULL,
0x2000003fff3e7230ULL, 0x000fe20000004100ULL, 0x00000010ff3f7819ULL, 0x000fc40000011638ULL,
0x0000ffff38387812ULL, 0x000fe400078ec0ffULL, 0x00000018ff517819ULL, 0x000fe40000011639ULL,
0x000000ff3f3f7812ULL, 0x000fe400078ec0ffULL, 0x000000ff50507812ULL, 0x000fe400078ec0ffULL,
0x00000008ff387819ULL, 0x000fe40000011638ULL, 0x0000003dff3d723eULL, 0x000fc400020006ffULL,
0x00000051ff51723eULL, 0x000fe400020006ffULL, 0x0000ffff39397812ULL, 0x000fe200078ec0ffULL,
0x2000003dff3d7230ULL, 0x000fe20000004100ULL, 0x0000003fff3f723eULL, 0x000fe200020006ffULL,
0x20000051ff517230ULL, 0x000fe20000004100ULL, 0x00000050ff50723eULL, 0x000fe400020006ffULL,
0x00000038ff38723eULL, 0x000fe200020006ffULL, 0x2000003fff3f7230ULL, 0x000fe20000004100ULL,
0x00000008ff397819ULL, 0x000fe20000011639ULL, 0x20000050ff507230ULL, 0x000fe20000004100ULL,
0x00000010ff3c7819ULL, 0x000fe2000001163cULL, 0x20000038ff387230ULL, 0x000fe20000004100ULL,
0x00000039ff39723eULL, 0x000fc400020006ffULL, 0x00000010ff3e7819ULL, 0x000fe4000001163eULL,
0x00000010ff3d7819ULL, 0x000fe2000001163dULL, 0x20000039ff397230ULL, 0x000fe20000004100ULL,
0x00000010ff707819ULL, 0x000fe40000011651ULL, 0x00000010ff3f7819ULL, 0x000fe4000001163fULL,
0x00000010ff517819ULL, 0x000fe40000011650ULL, 0x00000010ff387819ULL, 0x000fc40000011638ULL,
0x000010543f507816ULL, 0x000fe4000000003cULL, 0x0000105451517816ULL, 0x000fe4000000003eULL,
0x000010543d387816ULL, 0x000fe40000000038ULL, 0x00000000613c783bULL, 0x000f220000004200ULL,
0x00000010ff397819ULL, 0x000fe40000011639ULL, 0x000000ff3b627812ULL, 0x000fe200078ec0ffULL,
0x000000503414723cULL, 0x008fe20000041814ULL, 0x0000105470397816ULL, 0x000fc40000000039ULL,
0x00000010ff707819ULL, 0x100fe4000001163aULL, 0x00000018ff717819ULL, 0x000fe4000001163aULL,
0x00000062ff62723eULL, 0x000fe200020006ffULL, 0x000000383418723cULL, 0x000fe20000041818ULL,
0x000000ff3a6f7812ULL, 0x000fe400078ec0ffULL, 0x00000071ff72723eULL, 0x000fe400020006ffULL,
0x000000ff70707812ULL, 0x000fc400078ec0ffULL, 0x0000ffff3a757812ULL, 0x000fe400078ec0ffULL,
0x0000ffff3b767812ULL, 0x000fe400078ec0ffULL, 0x00000010ff737819ULL, 0x100fe4000001163bULL,
0x00000018ff747819ULL, 0x000fe2000001163bULL, 0x20000062ff3b7230ULL, 0x000fe20000004100ULL,
0x0000006fff6f723eULL, 0x000fe200020006ffULL, 0x20000072ff627230ULL, 0x000fe20000004100ULL,
0x00000070ff71723eULL, 0x000fc400020006ffULL, 0x00000008ff707819ULL, 0x000fe20000011675ULL,
0x2000006fff3a7230ULL, 0x000fe20000004100ULL, 0x00000008ff727819ULL, 0x000fe20000011676ULL,
0x20000071ff717230ULL, 0x000fe20000004100ULL, 0x000000ff73737812ULL, 0x000fe400078ec0ffULL,
0x00000070ff70723eULL, 0x000fe400020006ffULL, 0x00000074ff6f723eULL, 0x000fe400020006ffULL,
0x00000072ff72723eULL, 0x000fe200020006ffULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x00000073ff73723eULL, 0x000fe200020006ffULL, 0x2000006fff6f7230ULL, 0x000fe20000004100ULL,
0x00000010ff397819ULL, 0x000fe20000011662ULL, 0x20000072ff727230ULL, 0x000fe20000004100ULL,
0x00000010ff387819ULL, 0x000fe20000011670ULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x00000010ff6f7819ULL, 0x000fc4000001166fULL, 0x00000010ff727819ULL, 0x000fe40000011672ULL,
0x00000010ff3a7819ULL, 0x000fe4000001163aULL, 0x00000010ff3b7819ULL, 0x000fe4000001163bULL,
0x00000010ff717819ULL, 0x000fe40000011671ULL, 0x00000010ff507819ULL, 0x000fe40000011673ULL,
0x0000105439387816ULL, 0x000fc40000000038ULL, 0x000010546f397816ULL, 0x000fe40000000072ULL,
0x00001054713a7816ULL, 0x000fe4000000003aULL, 0x00001054503b7816ULL, 0x000fe4000000003bULL,
0x00000018ff507819ULL, 0x010fe2000001163cULL, 0x000000383420723cULL, 0x000fe20000041820ULL,
0x00000018ff737819ULL, 0x000fe4000001163dULL, 0x000000ff3e747812ULL, 0x000fc400078ec0ffULL,
0x000000ff3f757812ULL, 0x000fe200078ec0ffULL, 0x0000003a341c723cULL, 0x000fe2000004181cULL,
0x000000ff3c707812ULL, 0x040fe400078ec0ffULL, 0x00000010ff397819ULL, 0x000fe4000001163cULL,
0x0000ffff3c717812ULL, 0x000fe400078ec0ffULL, 0x00000050ff3c723eULL, 0x000fe400020006ffULL,
0x000000ff3d3b7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff727819ULL, 0x000fe2000001163dULL,
0x2000003cff3c7230ULL, 0x000fe20000004100ULL, 0x0000ffff3d6f7812ULL, 0x000fe400078ec0ffULL,
0x00000073ff50723eULL, 0x000fe400020006ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001163eULL,
0x00000074ff74723eULL, 0x000fe200020006ffULL, 0x20000050ff507230ULL, 0x000fe20000004100ULL,
0x00000075ff73723eULL, 0x000fc400020006ffULL, 0x00000010ff517819ULL, 0x000fe4000001163eULL,
0x0000ffff3e3a7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff3e7819ULL, 0x100fe4000001163fULL,
0x00000010ff627819ULL, 0x000fe4000001163fULL, 0x0000ffff3f387812ULL, 0x000fe400078ec0ffULL,
0x0000003dff75723eULL, 0x000fe200020006ffULL, 0x20000074ff3d7230ULL, 0x000fe20000004100ULL,
0x000000ff393f7812ULL, 0x000fe200078ec0ffULL, 0x20000073ff397230ULL, 0x000fe20000004100ULL,
0x0000003eff74723eULL, 0x000fe200020006ffULL, 0x20000075ff3e7230ULL, 0x000fe20000004100ULL,
0x000000ff72737812ULL, 0x000fc400078ec0ffULL, 0x0000003fff72723eULL, 0x000fe200020006ffULL,
0x20000074ff3f7230ULL, 0x000fe20000004100ULL, 0x00000008ff717819ULL, 0x000fe40000011671ULL,
0x00000070ff70723eULL, 0x000fe200020006ffULL, 0x20000072ff727230ULL, 0x000fe20000004100ULL,
0x0000003bff3b723eULL, 0x000fe400020006ffULL, 0x00000073ff73723eULL, 0x000fe200020006ffULL,
0x20000070ff707230ULL, 0x000fe20000004100ULL, 0x00000008ff747819ULL, 0x000fe2000001166fULL,
0x2000003bff3b7230ULL, 0x000fe20000004100ULL, 0x00000071ff6f723eULL, 0x000fc400020006ffULL,
0x000000ff51717812ULL, 0x000fe200078ec0ffULL, 0x20000073ff517230ULL, 0x000fe20000004100ULL,
0x000000ff62627812ULL, 0x000fe200078ec0ffULL, 0x2000006fff6f7230ULL, 0x000fe20000004100ULL,
0x00000074ff74723eULL, 0x000fe400020006ffULL, 0x00000062ff75723eULL, 0x000fe400020006ffULL,
0x00000010ff737819ULL, 0x000fe40000011672ULL, 0x00000008ff627819ULL, 0x000fc4000001163aULL,
0x00000008ff727819ULL, 0x000fe40000011638ULL, 0x00000010ff3a7819ULL, 0x000fe20000011670ULL,
0x20000074ff707230ULL, 0x000fe20000004100ULL, 0x00000010ff3b7819ULL, 0x000fe4000001163bULL,
0x00000010ff387819ULL, 0x000fe20000011651ULL, 0x20000075ff517230ULL, 0x000fe20000004100ULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x00001054733a7816ULL, 0x000fc4000000003aULL,
0x00001054383b7816ULL, 0x000fe2000000003bULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x00000010ff737819ULL, 0x000fe4000001163cULL, 0x00000010ff387819ULL, 0x000fe4000001163dULL,
0x00000010ff507819ULL, 0x000fe20000011650ULL, 0x0000003a3424723cULL, 0x000fe20000041824ULL,
0x00000010ff3c7819ULL, 0x000fe4000001166fULL, 0x00000010ff3d7819ULL, 0x000fc40000011670ULL,
0x00001054733c7816ULL, 0x000fe4000000003cULL, 0x00001054503d7816ULL, 0x000fe4000000003dULL,
0x00000071ff71723eULL, 0x000fe400020006ffULL, 0x00000072ff72723eULL, 0x000fe400020006ffULL,
0x00000010ff3a7819ULL, 0x000fe20000011662ULL, 0x0000003c3428723cULL, 0x000fe20000041828ULL,
0x00000002ff627819ULL, 0x000fe20000011610ULL, 0x20000071ff717230ULL, 0x000fe20000004100ULL,
0x00000010ff3b7819ULL, 0x000fe2000001163eULL, 0x20000072ff727230ULL, 0x000fe20000004100ULL,
0x0000006a6200720cULL, 0x000fc40003f86070ULL, 0x000000016a3c7836ULL, 0x000fe20000000000ULL,
0x00000010ff717819ULL, 0x000fe40000011671ULL, 0x00000010ff397819ULL, 0x000fe40000011639ULL,
0x0000003c6200720cULL, 0x000fe40006786470ULL, 0x00000010ff3f7819ULL, 0x000fe4000001163fULL,
0x00000010ff3e7819ULL, 0x000fe40000011651ULL, 0x00000010ff727819ULL, 0x000fc40000011672ULL,
0x000010543b3a7816ULL, 0x000fe4000000003aULL, 0x0000105471387816ULL, 0x000fe40000000038ULL,
0x000010543e397816ULL, 0x000fe40000000039ULL, 0x000010543f3b7816ULL, 0x000fe20000000072ULL,
0x00000008623f7836ULL, 0x000fc80000000000ULL, 0x00000038342c723cULL, 0x000fe2000004182cULL,
0x0000006a3f00720cULL, 0x000fc80003fa6070ULL, 0x0000003c3f00720cULL, 0x000fe20006fa6470ULL,
0x0000003a3430723cULL, 0x000fe20000041830ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000404947ULL, 0x000fde0003000000ULL, 0x000000140b0b7221ULL, 0x000fe20000010000ULL,
0x000000150a0a7221ULL, 0x000fe20000010000ULL, 0x000000180f0f7221ULL, 0x000fe20000010000ULL,
0x000000190e0e7221ULL, 0x000fe20000010000ULL, 0x0000001c41417221ULL, 0x000fe20000010000ULL,
0x0000001d42427221ULL, 0x000fe20000010000ULL, 0x0000002045457221ULL, 0x000fe20000010000ULL,
0x0000002146467221ULL, 0x000fe20000010000ULL, 0x0000002449497221ULL, 0x000fe20000010000ULL,
0x000000254a4a7221ULL, 0x000fe20000010000ULL, 0x000000284d4d7221ULL, 0x000fe20000010000ULL,
0x000000294e4e7221ULL, 0x000fe20000010000ULL, 0x0000002c53537221ULL, 0x000fe20000010000ULL,
0x0000002d54547221ULL, 0x000fe20000010000ULL, 0x0000003057577221ULL, 0x000fe20000010000ULL,
0x0000003158587221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000012000007945ULL, 0x000fe80003800000ULL, 0x0000000000405947ULL, 0x000fea0001000000ULL,
0x000000160d0d7221ULL, 0x000fe20000010000ULL, 0x000000170c0c7221ULL, 0x000fe20000010000ULL,
0x0000001a11117221ULL, 0x000fe20000010000ULL, 0x0000001b40407221ULL, 0x000fe20000010000ULL,
0x0000001e43437221ULL, 0x000fe20000010000ULL, 0x0000001f44447221ULL, 0x000fe20000010000ULL,
0x0000002247477221ULL, 0x000fe20000010000ULL, 0x0000002348487221ULL, 0x000fe20000010000ULL,
0x000000264b4b7221ULL, 0x000fe20000010000ULL, 0x000000274c4c7221ULL, 0x000fe20000010000ULL,
0x0000002a4f4f7221ULL, 0x000fe20000010000ULL, 0x0000002b52527221ULL, 0x000fe20000010000ULL,
0x0000002e55557221ULL, 0x000fe20000010000ULL, 0x0000002f56567221ULL, 0x000fe20000010000ULL,
0x0000003259597221ULL, 0x000fe20000010000ULL, 0x000000335a5a7221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x018b886eff6e79a7ULL, 0x000ee20008500006ULL,
0x00000002ff157819ULL, 0x000fe4000001163cULL, 0x000000045c007c0cULL, 0x000fe4000bf43070ULL,
0x000000033c1a7812ULL, 0x040fe400078ec0ffULL, 0x000000153c157207ULL, 0x000fe40000000000ULL,
0x000000045c007c0cULL, 0x000fe4000bfc3070ULL, 0x00000004ff387803ULL, 0x000fc40000000000ULL,
0x000000ff1a1a7207ULL, 0x000fe40004000000ULL, 0x00000003151b7812ULL, 0x040fe400078ec0ffULL,
0x00000004151c7c11ULL, 0x000fce000f8ff0ffULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x018b8065ff0075a7ULL, 0x000f240008040146ULL, 0x00000000005c2947ULL, 0x010fea0003800000ULL,
0x000000ffff187224ULL, 0x000fce00078e00ffULL, 0x000000101800780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x0000001416197210ULL, 0x000fca0007f5e1ffULL, 0x0000000115157824ULL, 0x000fe200010e0e17ULL,
0x003d09001900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078510ffULL,
0x000000ffff157224ULL, 0x000fca00010e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000118187836ULL, 0x000fce0000000000ULL, 0x018b8065ff0075a7ULL, 0x000f240008040146ULL,
0xfffffffc00a8a947ULL, 0x010fea000383ffffULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x018b886fff0075a7ULL, 0x008ee40008040146ULL, 0x00000000005c2947ULL, 0x008fea0003800000ULL,
0x000000ffff187224ULL, 0x000fce00078e00ffULL, 0x000000101800780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x0000001416197210ULL, 0x000fca0007f5e1ffULL, 0x0000000115157824ULL, 0x000fe200010e0e17ULL,
0x003d09001900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078510ffULL,
0x000000ffff157224ULL, 0x000fca00010e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000118187836ULL, 0x000fce0000000000ULL, 0x018b886fff0075a7ULL, 0x000ee40008040146ULL,
0xfffffffc00a8a947ULL, 0x008fea000383ffffULL, 0x000000011c147836ULL, 0x000fca0000000000ULL,
0x0000001014007c0cULL, 0x000fda000bf46070ULL, 0x00000004005ca947ULL, 0x000fea0003800000ULL,
0x000000015b1d7824ULL, 0x000fe200078e0264ULL, 0x00014000060b7890ULL, 0x000fe2000fffe03fULL,
0x0000001010187824ULL, 0x000fe400078e00ffULL, 0x0000004013217824ULL, 0x000fe200078e021dULL,
0x000000061d1f7c11ULL, 0x040fe2000f8e10ffULL, 0x000000101d1e7824ULL, 0x000fe200078e00ffULL,
0x000000f018237812ULL, 0x000fe200078ec0ffULL, 0x000000041c187824ULL, 0x000fe400078e021bULL,
0x018a00001f147984ULL, 0x000ee20000000800ULL, 0x0000000264207836ULL, 0x000fc40000000000ULL,
0x0000004018187824ULL, 0x000fe400078e00ffULL, 0x000000015b277824ULL, 0x000fe200078e0220ULL,
0x0000000614197c11ULL, 0x008fe4000f8e10ffULL, 0x00008a00ff147b82ULL, 0x000ee60000000a00ULL,
0x018ac00019167984ULL, 0x0009640000000800ULL, 0x0000000d18197c48ULL, 0x010fca000ffe0000ULL,
0x0000000119187824ULL, 0x000fe400078e0a18ULL, 0x000000011d197824ULL, 0x000fc600078e0210ULL,
0x000000185b187248ULL, 0x000fe40007fe0000ULL, 0xfffffff01e197812ULL, 0x000fc600078ee219ULL,
0x00000001181d7824ULL, 0x000fe200078e0a5bULL, 0x0000000b19257c11ULL, 0x000fe2000f8e20ffULL,
0x0000000221197836ULL, 0x000fe40000000000ULL, 0x0000000816177c24ULL, 0x022fc8000f8e0221ULL,
0x0000010017167825ULL, 0x008fc600078e0014ULL, 0x0000002316167210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff177224ULL, 0x000fe200010e0617ULL, 0x0000001d6400720cULL, 0x000fda0003f46070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016257faeULL, 0x0003e8000d101c4eULL,
0x018a08001f187984ULL, 0x000ee20000000800ULL, 0x0000000127167824ULL, 0x042fe400078e0210ULL,
0x0000001027277824ULL, 0x000fe400078e00ffULL, 0x0000000421177836ULL, 0x000fc60000000000ULL,
0xfffffff027167812ULL, 0x000fc800078ee216ULL, 0x0000000b16257c11ULL, 0x000fe4000f8e20ffULL,
0x00000006181e7c11ULL, 0x008fca000f8e10ffULL, 0x018ac0001e187984ULL, 0x000e640000000800ULL,
0x0000000818197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000002318187210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff197224ULL, 0x000fe200010e0619ULL,
0x0000001d2000720cULL, 0x000fe20003f46070ULL, 0x0000000464207836ULL, 0x000fe40000000000ULL,
0x0000000664647836ULL, 0x000fe40000000000ULL, 0x000000015b277824ULL, 0x000fd000078e0220ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018257faeULL, 0x0003e8000d101c4eULL,
0x018a10001f167984ULL, 0x000ee20000000800ULL, 0x0000000127187824ULL, 0x042fe400078e0210ULL,
0x0000001027277824ULL, 0x000fe400078e00ffULL, 0x0000000621197836ULL, 0x000fc60000000000ULL,
0xfffffff027187812ULL, 0x000fc800078ee218ULL, 0x0000000b18257c11ULL, 0x000fe4000f8e20ffULL,
0x00000006161e7c11ULL, 0x008fca000f8e10ffULL, 0x018ac0001e167984ULL, 0x000e640000000800ULL,
0x0000000816177c24ULL, 0x002fc8000f8e0217ULL, 0x0000010017167825ULL, 0x000fc600078e0014ULL,
0x0000002316167210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff177224ULL, 0x000fe200010e0617ULL,
0x0000001d2000720cULL, 0x000fda0003f46070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016257faeULL, 0x0003e8000d101c4eULL, 0x018a18001f187984ULL, 0x000ee40000000800ULL,
0x0000000618187c11ULL, 0x008fcc000f8e10ffULL, 0x018ac00018187984ULL, 0x000ee40000000800ULL,
0x0000000818197c24ULL, 0x008fc8000f8e0219ULL, 0x0000010019147825ULL, 0x000fc800078e0014ULL,
0x000000015b197824ULL, 0x000fe200078e0264ULL, 0x0000002314147210ULL, 0x000fc60007f5e0ffULL,
0x0000000119167824ULL, 0x042fe400078e0210ULL, 0x000000ffff157224ULL, 0x000fe200010e0615ULL,
0x0000001d6400720cULL, 0x000fe20003f46070ULL, 0x0000001019197824ULL, 0x000fca00078e00ffULL,
0xfffffff019167812ULL, 0x000fc800078ee216ULL, 0x0000000b16177c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e2000d101c4eULL,
0x0000000400247947ULL, 0x000fea0003800000ULL, 0x000000015b647824ULL, 0x000fe200078e0264ULL,
0x00014000060b7890ULL, 0x000fe2000fffe03fULL, 0x0000001010197824ULL, 0x000fe400078e00ffULL,
0x0000004013237824ULL, 0x000fe200078e0264ULL, 0x0000000664217c11ULL, 0x040fe2000f8e10ffULL,
0x00000010641e7824ULL, 0x040fe200078e00ffULL, 0x000000f019257812ULL, 0x000fe200078ec0ffULL,
0x0000000164197824ULL, 0x000fe400078e0210ULL, 0x018a000021147984ULL, 0x000ee20000000800ULL,
0x00000002641d7836ULL, 0x000fc40000000000ULL, 0xfffffff01e197812ULL, 0x000fe400078ee219ULL,
0x000000011d1e7824ULL, 0x000fe400078e0210ULL, 0x0000000b19277c11ULL, 0x000fe2000f8e20ffULL,
0x0000000223197836ULL, 0x000fe40000000000ULL, 0x000000101d1d7824ULL, 0x000fca00078e00ffULL,
0xfffffff01d1e7812ULL, 0x000fc800078ee21eULL, 0x0000000b1e1d7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000614187c11ULL, 0x008fe4000f8e10ffULL, 0x00008a00ff147b82ULL, 0x000ee60000000a00ULL,
0x018ac00018167984ULL, 0x000f240000000800ULL, 0x0000000816177c24ULL, 0x010fc8000f8e0223ULL,
0x0000010017167825ULL, 0x008fc600078e0014ULL, 0x0000002516167210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff177224ULL, 0x000fca00010e0617ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016277faeULL, 0x0007e8000b901c4eULL, 0x018a080021187984ULL, 0x000f220000000800ULL,
0x0000000423177836ULL, 0x008fe20000000000ULL, 0x00000006181f7c11ULL, 0x010fca000f8e10ffULL,
0x018ac0001f187984ULL, 0x0007240000000800ULL, 0x00000004641f7836ULL, 0x008fc80000000000ULL,
0x000000011f1e7824ULL, 0x040fe400078e0210ULL, 0x000000101f1f7824ULL, 0x000fca00078e00ffULL,
0xfffffff01f1e7812ULL, 0x000fe200078ee21eULL, 0x0000000818197c24ULL, 0x010fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000002518187210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff197224ULL, 0x000fca00010e0619ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000181d7faeULL, 0x0007e8000b901c4eULL, 0x018a100021167984ULL, 0x000f220000000800ULL,
0x0000000b1e197c11ULL, 0x008fe2000f8e20ffULL, 0x00000006231d7836ULL, 0x000fe20000000000ULL,
0x0000000616207c11ULL, 0x010fca000f8e10ffULL, 0x018ac00020167984ULL, 0x000ee40000000800ULL,
0x0000000816177c24ULL, 0x008fc8000f8e0217ULL, 0x0000010017167825ULL, 0x000fc600078e0014ULL,
0x0000002516167210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff177224ULL, 0x000fca00010e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016197faeULL, 0x0007e8000b901c4eULL,
0x018a180021187984ULL, 0x000f240000000800ULL, 0x00000006181e7c11ULL, 0x010fca000f8e10ffULL,
0x018ac0001e187984ULL, 0x000f240000000800ULL, 0x00000008181d7c24ULL, 0x010fc8000f8e021dULL,
0x000001001d147825ULL, 0x000fc800078e0014ULL, 0x00000006641d7836ULL, 0x000fe20000000000ULL,
0x0000002514147210ULL, 0x000fc60007f5e0ffULL, 0x000000011d187824ULL, 0x040fe400078e0210ULL,
0x000000101d1d7824ULL, 0x000fe400078e00ffULL, 0x000000ffff157224ULL, 0x000fc600010e0615ULL,
0xfffffff01d187812ULL, 0x000fc800078ee218ULL, 0x0000000b18177c11ULL, 0x008fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0007e4000b901c4eULL,
0x00000001ff147424ULL, 0x00afcc00078e00ffULL, 0x018b8814ff1479a7ULL, 0x000e640008500006ULL,
0x000000ffff187224ULL, 0x002fce00078e0015ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x018b8818ff0075a7ULL, 0x000e640008040146ULL, 0x00000000005c2947ULL, 0x002fea0003800000ULL,
0x000000ffff1d7224ULL, 0x000fce00078e00ffULL, 0x000000101d00780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x0000001416197210ULL, 0x000fca0007f5e1ffULL, 0x0000000115157824ULL, 0x000fe200010e0e17ULL,
0x003d09001900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078510ffULL,
0x000000ffff157224ULL, 0x000fca00010e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011d1d7836ULL, 0x000fce0000000000ULL, 0x018b8818ff0075a7ULL, 0x000e640008040146ULL,
0xfffffffc00a8a947ULL, 0x002fea000383ffffULL, 0x0000000469147836ULL, 0x000fe20000000000ULL,
0x000001b000007945ULL, 0x000fe20003800000ULL, 0x0000000866657824ULL, 0x000fe400078e00ffULL,
0x000000016c6d7824ULL, 0x000fc600078e026dULL, 0xfffffff865657812ULL, 0x000fe200078ee214ULL,
0x0000000000581947ULL, 0x000fec0003800000ULL, 0x0000001c5c00720cULL, 0x000fe20003f44070ULL,
0x00009400000b7ab9ULL, 0x000fc60000000800ULL, 0x000000ff1a147207ULL, 0x040fe40001000000ULL,
0x000000ff1a1a7207ULL, 0x000fc60005000000ULL, 0x000000011b1b7824ULL, 0x000fe400078e0214ULL,
0x00009200ff147b82ULL, 0x000e620000000a00ULL, 0x000000015d177824ULL, 0x000fe400078e021aULL,
0x000000401b167824ULL, 0x040fe200078e00ffULL, 0x0000001c1b1b7211ULL, 0x000fc800078ff0ffULL,
0x000000c016167812ULL, 0x000fca00078ec0ffULL, 0x000001001b167824ULL, 0x000fc800078e0216ULL,
0x0000002016187836ULL, 0x000fc80000000000ULL, 0x0000000b17167c24ULL, 0x000fc8000f8e0218ULL,
0x000000016b177824ULL, 0x040fe400078e0216ULL, 0x000000016b167824ULL, 0x040fe200078e0218ULL,
0x000000066b6b7c11ULL, 0x000fe2000f8e10ffULL, 0x0000000417147825ULL, 0x002fc600078e0014ULL,
0x0000000d16007c0cULL, 0x000fda000bf46070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x18a00000146b7faeULL, 0x0003e4000d12184eULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x00000001ff6e7424ULL, 0x000fe200078e00ffULL,
0x0000000665657c11ULL, 0x000fe2000f8e20ffULL, 0x00000000ff0079b0ULL, 0x000fe20008000a49ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x018b786eff6e79a7ULL, 0x000e620008500006ULL,
0x0000000000103947ULL, 0x000fea0003800000ULL, 0x00000006ff03723eULL, 0x004fc800000010ffULL,
0x0000541003147816ULL, 0x000fca0000000003ULL, 0x00001f3f14047589ULL, 0x0004e800000e0000ULL,
0x00001f6214037589ULL, 0x00046400000e0000ULL, 0x012000006530783bULL, 0x0006a20000000200ULL,
0x000000106c647824ULL, 0x000fe200078e00ffULL, 0x0000000000103947ULL, 0x000fec0003800000ULL,
0x0000000330307232ULL, 0x086fe40000200000ULL, 0x0000000332327232ULL, 0x000fe40000200000ULL,
0x0000000431317232ULL, 0x088fe40000200000ULL, 0x0000000433337232ULL, 0x000fce0000200000ULL,
0x000000016c637824ULL, 0x040fe200078e0263ULL, 0x00016000060b7890ULL, 0x000fe2000fffe03fULL,
0x000000106c6c7824ULL, 0x000fe200078e00ffULL, 0xfffffff064647812ULL, 0x000fe200078ee26dULL,
0x0000000669697836ULL, 0x000fe40000000000ULL, 0x0000000866667824ULL, 0x000fe200078e00ffULL,
0xfffffff06c637812ULL, 0x000fe400078ee263ULL, 0x0000000b64647c11ULL, 0x000fe4000f8e20ffULL,
0x0000000b63637c11ULL, 0x000fc4000f8e20ffULL, 0xfffffff866667812ULL, 0x000fe200078ee269ULL,
0x000000006414783bULL, 0x004ea60000004200ULL, 0x0000000666667c11ULL, 0x000fe2000f8e20ffULL,
0x000000006318783bULL, 0x000f220000004200ULL, 0x0000ffff14377812ULL, 0x004fe400078ec0ffULL,
0x00000010ff347819ULL, 0x000fe40000011615ULL, 0x000000ff151f7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff287819ULL, 0x010fe40000011618ULL, 0x00000008ff377819ULL, 0x000fe40000011637ULL,
0x000000ff34347812ULL, 0x000fe400078ec0ffULL, 0x0000001fff1f723eULL, 0x000fe400020006ffULL,
0x000000ff28287812ULL, 0x000fe400078ec0ffULL, 0x00000010ff367819ULL, 0x000fe20000011614ULL,
0x2000001fff2d7230ULL, 0x000fe20000004100ULL, 0x00000018ff397819ULL, 0x000fc40000011619ULL,
0x00000037ff37723eULL, 0x000fe400020006ffULL, 0x00000034ff34723eULL, 0x000fe400020006ffULL,
0x00000010ff267819ULL, 0x000fe40000011617ULL, 0x00000028ff28723eULL, 0x000fe400020006ffULL,
0x0000ffff1a217812ULL, 0x000fe400078ec0ffULL, 0x00000039ff1f723eULL, 0x000fe200020006ffULL,
0x20000037ff397230ULL, 0x000fe20000004100ULL, 0x000000ff36367812ULL, 0x000fe200078ec0ffULL,
0x20000034ff377230ULL, 0x000fe20000004100ULL, 0x00000010ff2f7819ULL, 0x100fe20000011616ULL,
0x20000028ff347230ULL, 0x000fe20000004100ULL, 0x000000ff16237812ULL, 0x000fe200078ec0ffULL,
0x2000001fff1f7230ULL, 0x000fe20000004100ULL, 0x00000018ff227819ULL, 0x000fc40000011616ULL,
0x0000ffff16257812ULL, 0x000fe400078ec0ffULL, 0x000000ff193a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff247819ULL, 0x000fe4000001161bULL, 0x000000ff141d7812ULL, 0x000fe400078ec0ffULL,
0x000000ff172a7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff167819ULL, 0x000fc40000011617ULL,
0x0000ffff17297812ULL, 0x000fe400078ec0ffULL, 0x000000ff26267812ULL, 0x000fe400078ec0ffULL,
0x000000ff182b7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff177819ULL, 0x000fe40000011618ULL,
0x0000ffff182e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff207819ULL, 0x000fc40000011619ULL,
0x00000010ff187819ULL, 0x100fe4000001161aULL, 0x000000ff1a3c7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff3b7819ULL, 0x000fe4000001161aULL, 0x00000036ff36723eULL, 0x000fe400020006ffULL,
0x00000008ff287819ULL, 0x000fe40000011621ULL, 0x00000018ff1c7819ULL, 0x000fc40000011614ULL,
0x0000ffff15357812ULL, 0x000fe400078ec0ffULL, 0x0000003aff1a723eULL, 0x000fe400020006ffULL,
0x000000ff24247812ULL, 0x000fe400078ec0ffULL, 0x00000018ff1e7819ULL, 0x000fe20000011615ULL,
0x2000001aff1a7230ULL, 0x000fe20000004100ULL, 0x0000001dff14723eULL, 0x000fe400020006ffULL,
0x000000ff2f3a7812ULL, 0x000fe200078ec0ffULL, 0x20000036ff2f7230ULL, 0x000fe20000004100ULL,
0x00000026ff26723eULL, 0x000fe200020006ffULL, 0x20000014ff147230ULL, 0x000fe20000004100ULL,
0x0000ffff1b157812ULL, 0x000fc400078ec0ffULL, 0x000000ff20207812ULL, 0x000fe400078ec0ffULL,
0x00000008ff2e7819ULL, 0x000fe4000001162eULL, 0x00000028ff28723eULL, 0x000fe400020006ffULL,
0x00000008ff357819ULL, 0x000fe40000011635ULL, 0x00000024ff24723eULL, 0x000fe400020006ffULL,
0x0000003aff36723eULL, 0x000fe200020006ffULL, 0x20000026ff3a7230ULL, 0x000fe20000004100ULL,
0x00000008ff257819ULL, 0x000fc40000011625ULL, 0x0000ffff19277812ULL, 0x000fe200078ec0ffULL,
0x20000036ff367230ULL, 0x000fe20000004100ULL, 0x0000001cff1c723eULL, 0x000fe400020006ffULL,
0x00000020ff20723eULL, 0x000fe400020006ffULL, 0x00000008ff157819ULL, 0x000fe20000011615ULL,
0x2000001cff2c7230ULL, 0x000fe20000004100ULL, 0x0000001eff19723eULL, 0x000fe200020006ffULL,
0x20000020ff217230ULL, 0x000fe20000004100ULL, 0x0000002eff26723eULL, 0x000fe200020006ffULL,
0x20000028ff2e7230ULL, 0x000fe20000004100ULL, 0x000000ff1b3e7812ULL, 0x000fe200078ec0ffULL,
0x20000024ff287230ULL, 0x000fe20000004100ULL, 0x00000018ff3d7819ULL, 0x000fe2000001161bULL,
0x20000019ff197230ULL, 0x000fe20000004100ULL, 0x00000035ff35723eULL, 0x000fe200020006ffULL,
0x20000026ff267230ULL, 0x000fe20000004100ULL, 0x00000022ff1b723eULL, 0x000fc400020006ffULL,
0x00000025ff25723eULL, 0x000fe200020006ffULL, 0x20000035ff357230ULL, 0x000fe20000004100ULL,
0x00000008ff297819ULL, 0x000fe20000011629ULL, 0x2000001bff1b7230ULL, 0x000fe20000004100ULL,
0x00000015ff24723eULL, 0x000fe400020006ffULL, 0x00000010ff147819ULL, 0x000fe40000011614ULL,
0x00000010ff157819ULL, 0x000fe2000001162fULL, 0x20000024ff2f7230ULL, 0x000fe20000004100ULL,
0x0000002aff1c723eULL, 0x000fc400020006ffULL, 0x00000010ff2d7819ULL, 0x000fe4000001162dULL,
0x00000010ff207819ULL, 0x000fe20000011637ULL, 0x2000001cff1c7230ULL, 0x000fe20000004100ULL,
0x0000003bff2a723eULL, 0x000fe200020006ffULL, 0x20000025ff3b7230ULL, 0x000fe20000004100ULL,
0x00000016ff16723eULL, 0x000fe400020006ffULL, 0x00000029ff29723eULL, 0x000fe200020006ffULL,
0x2000002aff2a7230ULL, 0x000fe20000004100ULL, 0x0000002bff2b723eULL, 0x000fc400020006ffULL,
0x0000105415147816ULL, 0x000fe20000000014ULL, 0x20000029ff257230ULL, 0x000fe20000004100ULL,
0x00000008ff277819ULL, 0x000fe40000011627ULL, 0x0000105420157816ULL, 0x000fe4000000002dULL,
0x000000ff18187812ULL, 0x000fe400078ec0ffULL, 0x00000010ff207819ULL, 0x000fe40000011619ULL,
0x00000017ff1e723eULL, 0x000fe200020006ffULL, 0x20000016ff177230ULL, 0x000fe20000004100ULL,
0x00000010ff197819ULL, 0x000fe20000011635ULL, 0x2000002bff167230ULL, 0x000fe20000004100ULL,
0x00000010ff247819ULL, 0x000fe2000001161bULL, 0x2000001eff1e7230ULL, 0x000fe20000004100ULL,
0x00000010ff3b7819ULL, 0x000fc4000001163bULL, 0x00000023ff1d723eULL, 0x000fe400020006ffULL,
0x00000027ff27723eULL, 0x000fe400020006ffULL, 0x0000003cff23723eULL, 0x000fe200020006ffULL,
0x2000001dff1d7230ULL, 0x000fe20000004100ULL, 0x00000018ff18723eULL, 0x000fe200020006ffULL,
0x20000027ff277230ULL, 0x000fe20000004100ULL, 0x0000003eff22723eULL, 0x000fe200020006ffULL,
0x20000023ff237230ULL, 0x000fe20000004100ULL, 0x0000105420197816ULL, 0x000fe20000000019ULL,
0x20000018ff297230ULL, 0x000fe20000004100ULL, 0x0000003dff2b723eULL, 0x000fe200020006ffULL,
0x20000022ff227230ULL, 0x000fe20000004100ULL, 0x0000105424207816ULL, 0x000fc4000000003bULL,
0x00000010ff3d7819ULL, 0x000fe2000001162cULL, 0x2000002bff2b7230ULL, 0x000fe20000004100ULL,
0x00000010ff247819ULL, 0x000fe40000011617ULL, 0x00000010ff257819ULL, 0x000fe40000011625ULL,
0x00000010ff2c7819ULL, 0x000fe40000011616ULL, 0x00000010ff2d7819ULL, 0x000fe20000011634ULL,
0x000000143014723cULL, 0x000fe200000418ffULL, 0x00000010ff357819ULL, 0x000fc4000001161aULL,
0x00000010ff347819ULL, 0x000fe40000011621ULL, 0x0000105424217816ULL, 0x000fe40000000025ULL,
0x000010542d247816ULL, 0x000fe4000000002cULL, 0x00000010ff1b7819ULL, 0x000fe4000001161cULL,
0x0000105434257816ULL, 0x000fe40000000035ULL, 0x00000010ff2c7819ULL, 0x000fc4000001161fULL,
0x00000010ff277819ULL, 0x000fe40000011627ULL, 0x00000010ff1c7819ULL, 0x000fe40000011636ULL,
0x00000010ff2d7819ULL, 0x000fe4000001161eULL, 0x00000010ff347819ULL, 0x000fe40000011623ULL,
0x00000010ff267819ULL, 0x000fe40000011626ULL, 0x00000010ff357819ULL, 0x000fc40000011629ULL,
0x00000010ff367819ULL, 0x000fe40000011622ULL, 0x00000010ff377819ULL, 0x000fe20000011628ULL,
0x000000203020723cULL, 0x000fe200000418ffULL, 0x000010542c297816ULL, 0x000fe40000000027ULL,
0x00000010ff1d7819ULL, 0x000fe4000001161dULL, 0x000010542d287816ULL, 0x000fe40000000026ULL,
0x00001054352c7816ULL, 0x000fe20000000034ULL, 0x000000243024723cULL, 0x000fe200000418ffULL,
0x00000010ff187819ULL, 0x000fc40000011639ULL, 0x00000010ff3a7819ULL, 0x000fe4000001163aULL,
0x00001054372d7816ULL, 0x000fe40000000036ULL, 0x00000010ff357819ULL, 0x000fe4000001162aULL,
0x00000010ff2e7819ULL, 0x000fe4000001162eULL, 0x00000010ff367819ULL, 0x000fe4000001162bULL,
0x00000010ff2f7819ULL, 0x000fe2000001162fULL, 0x000000283028723cULL, 0x000fe200000418ffULL,
0x000010541c1c7816ULL, 0x000fc4000000001dULL, 0x000010543d187816ULL, 0x000fe40000000018ULL,
0x000010543a1d7816ULL, 0x000fe4000000001bULL, 0x0000105435347816ULL, 0x000fe4000000002eULL,
0x0000105436357816ULL, 0x000fe2000000002fULL, 0x000000183018723cULL, 0x000fec00000418ffULL,
0x0000001c301c723cULL, 0x000fec00000418ffULL, 0x0000002c302c723cULL, 0x000fec00000418ffULL,
0x000000343030723cULL, 0x000fe200000418ffULL, 0x012000006634783bULL, 0x0004e20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000103947ULL, 0x000fde0003800000ULL,
0x0000000334347232ULL, 0x08afe40000200000ULL, 0x0000000336367232ULL, 0x000fe40000200000ULL,
0x0000000435357232ULL, 0x080fe40000200000ULL, 0x0000000437377232ULL, 0x000fce0000200000ULL,
0x0000000b68687c11ULL, 0x000fe2000f8e20ffULL, 0x00000bf000007945ULL, 0x000fe20003800000ULL,
0x000000ff3800720cULL, 0x000fe40003f45270ULL, 0x0000000b67677c11ULL, 0x000fe2000f8e20ffULL,
0x000000006838783bULL, 0x000f240000004200ULL, 0x00000010ff3c7819ULL, 0x010fe40000011638ULL,
0x00000010ff3e7819ULL, 0x000fe40000011639ULL, 0x000000ff383d7812ULL, 0x000fc400078ec0ffULL,
0x000000ff393f7812ULL, 0x000fe400078ec0ffULL, 0x000000ff3c3c7812ULL, 0x000fe400078ec0ffULL,
0x000000ff3e3e7812ULL, 0x000fe400078ec0ffULL, 0x0000003dff3d723eULL, 0x000fe400020006ffULL,
0x0000003fff3f723eULL, 0x000fe400020006ffULL, 0x0000003cff3c723eULL, 0x000fe200020006ffULL,
0x2000003dff3d7230ULL, 0x000fe20000004100ULL, 0x0000003eff3e723eULL, 0x000fe200020006ffULL,
0x2000003fff3f7230ULL, 0x000fe20000004100ULL, 0x00000018ff6d7819ULL, 0x000fe20000011639ULL,
0x2000003cff3c7230ULL, 0x000fe20000004100ULL, 0x00000010ff3d7819ULL, 0x000fe2000001163dULL,
0x2000003eff3e7230ULL, 0x000fe20000004100ULL, 0x00000010ff3f7819ULL, 0x000fc4000001163fULL,
0x00000010ff3c7819ULL, 0x000fe4000001163cULL, 0x00000010ff3e7819ULL, 0x000fe4000001163eULL,
0x000010543c507816ULL, 0x000fe4000000003dULL, 0x000010543e517816ULL, 0x000fe4000000003fULL,
0x00000000673c783bULL, 0x000f220000004200ULL, 0x0000ffff39767812ULL, 0x000fe400078ec0ffULL,
0x000000ff3a397812ULL, 0x000fc400078ec0ffULL, 0x0000ffff38747812ULL, 0x000fe200078ec0ffULL,
0x000000503414723cULL, 0x008fe20000041814ULL, 0x0000006dff6d723eULL, 0x000fe400020006ffULL,
0x00000039ff71723eULL, 0x000fe400020006ffULL, 0x00000008ff397819ULL, 0x000fe40000011674ULL,
0x00000018ff6b7819ULL, 0x000fe40000011638ULL, 0x00000010ff707819ULL, 0x000fc4000001163aULL,
0x00000018ff727819ULL, 0x000fe4000001163aULL, 0x0000ffff3a6c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff3a7819ULL, 0x100fe4000001163bULL, 0x000000ff3b737812ULL, 0x040fe400078ec0ffULL,
0x00000018ff387819ULL, 0x000fe4000001163bULL, 0x0000ffff3b697812ULL, 0x000fe200078ec0ffULL,
0x2000006dff3b7230ULL, 0x000fe20000004100ULL, 0x00000039ff6d723eULL, 0x000fe200020006ffULL,
0x20000071ff397230ULL, 0x000fe20000004100ULL, 0x00000073ff75723eULL, 0x000fc400020006ffULL,
0x00000008ff717819ULL, 0x000fe40000011676ULL, 0x00000072ff74723eULL, 0x000fe400020006ffULL,
0x000000ff70737812ULL, 0x000fe200078ec0ffULL, 0x2000006dff707230ULL, 0x000fe20000004100ULL,
0x00000071ff72723eULL, 0x000fe200020006ffULL, 0x20000075ff6d7230ULL, 0x000fe20000004100ULL,
0x000000ff3a757812ULL, 0x000fe400078ec0ffULL, 0x0000006bff6b723eULL, 0x000fe200020006ffULL,
0x20000072ff727230ULL, 0x000fe20000004100ULL, 0x00000073ff73723eULL, 0x000fc400020006ffULL,
0x00000075ff75723eULL, 0x000fe200020006ffULL, 0x2000006bff6b7230ULL, 0x000fe20000004100ULL,
0x00000010ff3a7819ULL, 0x000fe20000011670ULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x00000008ff707819ULL, 0x000fe2000001166cULL, 0x20000075ff757230ULL, 0x000fe20000004100ULL,
0x00000010ff6c7819ULL, 0x000fe4000001163bULL, 0x00000010ff3b7819ULL, 0x000fe40000011672ULL,
0x00000010ff717819ULL, 0x000fe2000001166bULL, 0x20000074ff6b7230ULL, 0x000fe20000004100ULL,
0x000010546c3b7816ULL, 0x000fc4000000003bULL, 0x00000010ff397819ULL, 0x000fe40000011639ULL,
0x00000010ff6c7819ULL, 0x000fe40000011673ULL, 0x00000070ff70723eULL, 0x000fe400020006ffULL,
0x00000010ff6d7819ULL, 0x000fe4000001166dULL, 0x00000010ff727819ULL, 0x000fe20000011675ULL,
0x20000070ff707230ULL, 0x000fe20000004100ULL, 0x00001054713a7816ULL, 0x000fc4000000003aULL,
0x00000038ff50723eULL, 0x000fe400020006ffULL, 0x000010546c387816ULL, 0x000fe40000000039ULL,
0x0000105472397816ULL, 0x000fe2000000006dULL, 0x0000003a3418723cULL, 0x000fe20000041818ULL,
0x00000018ff717819ULL, 0x110fe4000001163cULL, 0x000000ff3c747812ULL, 0x040fe400078ec0ffULL,
0x000000ff3d737812ULL, 0x000fe200078ec0ffULL, 0x00000038341c723cULL, 0x000fe2000004181cULL,
0x00000010ff757819ULL, 0x000fe2000001163cULL, 0x20000050ff3b7230ULL, 0x000fe20000004100ULL,
0x0000ffff3c517812ULL, 0x000fc400078ec0ffULL, 0x00000010ff6b7819ULL, 0x000fe4000001166bULL,
0x00000010ff3a7819ULL, 0x000fe40000011670ULL, 0x00000071ff71723eULL, 0x000fe400020006ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001163eULL, 0x00000074ff74723eULL, 0x000fe400020006ffULL,
0x00000073ff73723eULL, 0x000fc400020006ffULL, 0x00000018ff387819ULL, 0x100fe4000001163dULL,
0x000000ff3f787812ULL, 0x000fe400078ec0ffULL, 0x000010546b3a7816ULL, 0x000fe4000000003aULL,
0x0000003cff50723eULL, 0x000fe200020006ffULL, 0x20000071ff3c7230ULL, 0x000fe20000004100ULL,
0x00000010ff397819ULL, 0x000fe4000001163dULL, 0x00000010ff6c7819ULL, 0x000fe2000001163eULL,
0x20000050ff507230ULL, 0x000fe20000004100ULL, 0x000000ff3e777812ULL, 0x000fc400078ec0ffULL,
0x0000ffff3e6b7812ULL, 0x000fe200078ec0ffULL, 0x20000074ff3e7230ULL, 0x000fe20000004100ULL,
0x00000038ff76723eULL, 0x000fe200020006ffULL, 0x20000073ff387230ULL, 0x000fe20000004100ULL,
0x00000008ff717819ULL, 0x000fe40000011669ULL, 0x0000ffff3d707812ULL, 0x000fe400078ec0ffULL,
0x00000078ff74723eULL, 0x000fe400020006ffULL, 0x00000018ff3d7819ULL, 0x000fc4000001163fULL,
0x000000ff75737812ULL, 0x000fe400078ec0ffULL, 0x000000ff39757812ULL, 0x000fe200078ec0ffULL,
0x20000074ff397230ULL, 0x000fe20000004100ULL, 0x00000071ff71723eULL, 0x000fe400020006ffULL,
0x0000003dff69723eULL, 0x000fe200020006ffULL, 0x20000076ff3d7230ULL, 0x000fe20000004100ULL,
0x00000010ff727819ULL, 0x000fe4000001163fULL, 0x0000ffff3f6d7812ULL, 0x000fc400078ec0ffULL,
0x00000075ff74723eULL, 0x000fe400020006ffULL, 0x00000077ff3f723eULL, 0x000fe200020006ffULL,
0x20000071ff777230ULL, 0x000fe20000004100ULL, 0x00000008ff767819ULL, 0x000fe20000011651ULL,
0x20000069ff517230ULL, 0x000fe20000004100ULL, 0x00000073ff73723eULL, 0x000fe200020006ffULL,
0x20000074ff697230ULL, 0x000fe20000004100ULL, 0x00000008ff757819ULL, 0x000fe20000011670ULL,
0x2000003fff3f7230ULL, 0x000fe20000004100ULL, 0x00000008ff717819ULL, 0x000fe2000001166bULL,
0x20000073ff737230ULL, 0x000fe20000004100ULL, 0x000000ff6c6c7812ULL, 0x000fc400078ec0ffULL,
0x000000ff72707812ULL, 0x000fe400078ec0ffULL, 0x00000008ff6d7819ULL, 0x000fe4000001166dULL,
0x00000010ff747819ULL, 0x000fe4000001163bULL, 0x00000010ff3b7819ULL, 0x000fe40000011677ULL,
0x00000071ff71723eULL, 0x000fe400020006ffULL, 0x00000076ff76723eULL, 0x000fc400020006ffULL,
0x00000075ff75723eULL, 0x000fe200020006ffULL, 0x20000071ff717230ULL, 0x000fe20000004100ULL,
0x0000006cff6c723eULL, 0x000fe200020006ffULL, 0x20000076ff6b7230ULL, 0x000fe20000004100ULL,
0x00000070ff70723eULL, 0x000fe200020006ffULL, 0x20000075ff727230ULL, 0x000fe20000004100ULL,
0x0000006dff6d723eULL, 0x000fe200020006ffULL, 0x2000006cff6c7230ULL, 0x000fe20000004100ULL,
0x00001054743b7816ULL, 0x000fe2000000003bULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x00000010ff3e7819ULL, 0x000fe2000001163eULL, 0x2000006dff6d7230ULL, 0x000fe20000004100ULL,
0x00000010ff737819ULL, 0x000fc40000011673ULL, 0x00000010ff757819ULL, 0x000fe2000001163fULL,
0x0000003a3420723cULL, 0x000fe20000041820ULL, 0x00001054733e7816ULL, 0x000fe4000000003eULL,
0x00000010ff387819ULL, 0x000fe40000011638ULL, 0x00000010ff737819ULL, 0x000fe4000001163cULL,
0x00000010ff747819ULL, 0x000fe4000001163dULL, 0x00000010ff3f7819ULL, 0x000fc40000011669ULL,
0x00000010ff3b7819ULL, 0x000fe40000011650ULL, 0x00000010ff3a7819ULL, 0x000fe40000011671ULL,
0x00000010ff3c7819ULL, 0x000fe4000001166bULL, 0x00000010ff3d7819ULL, 0x000fe40000011672ULL,
0x00000010ff6c7819ULL, 0x000fe4000001166cULL, 0x00000010ff397819ULL, 0x000fc40000011639ULL,
0x00000010ff707819ULL, 0x000fe40000011670ULL, 0x00000010ff507819ULL, 0x000fe40000011651ULL,
0x00000010ff6d7819ULL, 0x000fe4000001166dULL, 0x000010543f3f7816ULL, 0x000fe40000000038ULL,
0x000010543b3a7816ULL, 0x000fe4000000003aULL, 0x00001054733c7816ULL, 0x000fc4000000003cULL,
0x00001054743d7816ULL, 0x000fe2000000003dULL, 0x0000003e3424723cULL, 0x000fe20000041824ULL,
0x000010546c387816ULL, 0x000fe40000000075ULL, 0x0000105470397816ULL, 0x000fe40000000039ULL,
0x00001054503b7816ULL, 0x000fe2000000006dULL, 0x0000003c3428723cULL, 0x000fec0000041828ULL,
0x00000038342c723cULL, 0x000fec000004182cULL, 0x0000003a3430723cULL, 0x000fe20000041830ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000404947ULL, 0x000fde0001000000ULL,
0x000000140b0b7221ULL, 0x000fe20000010000ULL, 0x000000150a0a7221ULL, 0x000fe20000010000ULL,
0x000000180f0f7221ULL, 0x000fe20000010000ULL, 0x000000190e0e7221ULL, 0x000fe20000010000ULL,
0x0000001c41417221ULL, 0x000fe20000010000ULL, 0x0000001d42427221ULL, 0x000fe20000010000ULL,
0x0000002045457221ULL, 0x000fe20000010000ULL, 0x0000002146467221ULL, 0x000fe20000010000ULL,
0x0000002449497221ULL, 0x000fe20000010000ULL, 0x000000254a4a7221ULL, 0x000fe20000010000ULL,
0x000000284d4d7221ULL, 0x000fe20000010000ULL, 0x000000294e4e7221ULL, 0x000fe20000010000ULL,
0x0000002c53537221ULL, 0x000fe20000010000ULL, 0x0000002d54547221ULL, 0x000fe20000010000ULL,
0x0000003057577221ULL, 0x000fe20000010000ULL, 0x0000003158587221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x000000ffff157224ULL, 0x002fc600078e006fULL, 0x0000000000405947ULL, 0x000fea0003000000ULL,
0x000000160d0d7221ULL, 0x000fe20000010000ULL, 0x000000170c0c7221ULL, 0x000fe20000010000ULL,
0x0000001a11117221ULL, 0x000fe20000010000ULL, 0x0000001b40407221ULL, 0x000fe20000010000ULL,
0x0000001e43437221ULL, 0x000fe20000010000ULL, 0x0000001f44447221ULL, 0x000fe20000010000ULL,
0x0000002247477221ULL, 0x000fe20000010000ULL, 0x0000002348487221ULL, 0x000fe20000010000ULL,
0x000000264b4b7221ULL, 0x000fe20000010000ULL, 0x000000274c4c7221ULL, 0x000fe20000010000ULL,
0x0000002a4f4f7221ULL, 0x000fe20000010000ULL, 0x0000002b52527221ULL, 0x000fe20000010000ULL,
0x0000002e55557221ULL, 0x000fe20000010000ULL, 0x0000002f56567221ULL, 0x000fe20000010000ULL,
0x0000003259597221ULL, 0x000fe20000010000ULL, 0x000000335a5a7221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000001ff147424ULL, 0x000fe400078e00ffULL,
0x000000016a6a7836ULL, 0x000fe40000000000ULL, 0x018b8814ff1c79a7ULL, 0x0002e20008500006ULL,
0x0000000414697807ULL, 0x000fc80000000000ULL, 0x000000696a00720cULL, 0x000fda0003f46070ULL,
0xffffff9c008ca947ULL, 0x002fea000383ffffULL, 0x00000040040b7891ULL, 0x000fe2000f8e403fULL,
0x018b5814ffff79a7ULL, 0x0003e60008500006ULL, 0x0000000d0b00728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f4f008ULL, 0x0000011800dc2947ULL, 0x002fea0003800000ULL,
0x000000ffff6a7224ULL, 0x000fce00078e00ffULL, 0x00000002ff177819ULL, 0x000fe4000001166aULL,
0x000000036a1a7812ULL, 0x040fe400078ec0ffULL, 0x000000176a177207ULL, 0x000fe40000000000ULL,
0x000000ff1a1a7207ULL, 0x000fc60004000000ULL, 0x0000000117177836ULL, 0x000fca0000000000ULL,
0x00000003171c7812ULL, 0x048fe400078ec0ffULL, 0x00000004171b7c11ULL, 0x004fce000f8ff0ffULL,
0x0000000000187805ULL, 0x000fce0000015200ULL, 0x018b7815ff0075a7ULL, 0x000e640008040146ULL,
0x00000000005c2947ULL, 0x002fea0003800000ULL, 0x000000ffff1e7224ULL, 0x000fce00078e00ffULL,
0x000000101e00780cULL, 0x000fda0003f46270ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x00000016181f7210ULL, 0x000fca0007f5e1ffULL,
0x0000000117177824ULL, 0x000fe200010e0e19ULL, 0x003d09001f00780cULL, 0x000fc80003f46070ULL,
0x000000ff1700720cULL, 0x000fda0003f46320ULL, 0x000000000008a947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401f00780cULL, 0x000fc80003f46070ULL, 0x000000ff1700720cULL, 0x000fda0003f46320ULL,
0x00000000001ca947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011417ULL,
0x0000001f14147211ULL, 0x000fca00078510ffULL, 0x000000ffff177224ULL, 0x000fca00010e0617ULL,
0x0000000214147819ULL, 0x000fc80000001217ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011e1e7836ULL, 0x000fce0000000000ULL,
0x018b7815ff0075a7ULL, 0x000e640008040146ULL, 0xfffffffc00a8a947ULL, 0x002fea000383ffffULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x018b881dff0075a7ULL, 0x000e640008040146ULL,
0x00000000005c2947ULL, 0x002fea0003800000ULL, 0x000000ffff187224ULL, 0x000fce00078e00ffULL,
0x000000101800780cULL, 0x000fda0003f46270ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000001614197210ULL, 0x000fca0007f5e1ffULL,
0x0000000117177824ULL, 0x000fe200010e0e15ULL, 0x003d09001900780cULL, 0x000fc80003f46070ULL,
0x000000ff1700720cULL, 0x000fda0003f46320ULL, 0x000000000008a947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f46070ULL, 0x000000ff1700720cULL, 0x000fda0003f46320ULL,
0x00000000001ca947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000001916167211ULL, 0x000fca00078510ffULL, 0x000000ffff177224ULL, 0x000fca00010e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000118187836ULL, 0x000fce0000000000ULL,
0x018b881dff0075a7ULL, 0x000e640008040146ULL, 0xfffffffc00a8a947ULL, 0x002fea000383ffffULL,
0x000000011b147836ULL, 0x000fe20000000000ULL, 0x00000004ff6c7819ULL, 0x000fc80000011610ULL,
0x0000001014007c0cULL, 0x000fda000bf46070ULL, 0x000000040060a947ULL, 0x000fea0003800000ULL,
0x000000015b197824ULL, 0x000fe200078e026cULL, 0x0000002013207811ULL, 0x000fe200078e30ffULL,
0x000000041b167824ULL, 0x000fe200078e021cULL, 0x00016000060b7890ULL, 0x000fe2000fffe03fULL,
0x00000010101d7824ULL, 0x000fe200078e00ffULL, 0x00000006191f7c11ULL, 0x000fe2000f8e10ffULL,
0x000000026c227836ULL, 0x000fe20000000000ULL, 0x0000002016167811ULL, 0x000fe400078e30ffULL,
0x000000f01d217812ULL, 0x000fe200078ec0ffULL, 0x018a00001f147984ULL, 0x000e620000000800ULL,
0x0000000d16177c48ULL, 0x000fe2000ffe0000ULL, 0x000000015b257824ULL, 0x000fc800078e0222ULL,
0x0000000117167824ULL, 0x000fe400078e0a16ULL, 0x0000000119177824ULL, 0x000fe400078e0220ULL,
0x0000000125247824ULL, 0x000fe200078e0210ULL, 0x000000165b167248ULL, 0x000fca0007fe0000ULL,
0x00000001161d7824ULL, 0x000fca00078e0a5bULL, 0x0000001d6c00720cULL, 0x000fe40003f46070ULL,
0x0000000614187c11ULL, 0x002fe4000f8e10ffULL, 0x00008a00ff147b82ULL, 0x000e680000000a00ULL,
0x018ac00018187984ULL, 0x000ee40000000800ULL, 0x0000000818177c24ULL, 0x008fc4000f8e0217ULL,
0x0000000119187824ULL, 0x000fe400078e0210ULL, 0x0000010017167825ULL, 0x002fc800078e0014ULL,
0x0000001019197824ULL, 0x000fe200078e00ffULL, 0x0000002116167210ULL, 0x000fc80007f7e0ffULL,
0xfffffff019187812ULL, 0x000fe200078ee218ULL, 0x000000ffff177224ULL, 0x000fe400018e0617ULL,
0x0000000125197824ULL, 0x040fe200078e0220ULL, 0x0000000b18237c11ULL, 0x000fe2000f8e20ffULL,
0x0000001025257824ULL, 0x000fc800078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0003e2000d101c4eULL, 0x0000001d2200720cULL, 0x000fe20003f46070ULL,
0x000000046c227836ULL, 0x000fe20000000000ULL, 0xfffffff025247812ULL, 0x000fe200078ee224ULL,
0x018a08001f187984ULL, 0x000ee40000000800ULL, 0x000000015b257824ULL, 0x000fe200078e0222ULL,
0x0000000b24237c11ULL, 0x002fc6000f8e20ffULL, 0x0000000125247824ULL, 0x000fe200078e0210ULL,
0x00000006181e7c11ULL, 0x008fca000f8e10ffULL, 0x018ac0001e187984ULL, 0x000e640000000800ULL,
0x0000000818197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000002118167210ULL, 0x000fca0007f7e0ffULL, 0x000000ffff177224ULL, 0x000fe400018e0619ULL,
0x0000000125197824ULL, 0x040fe400078e0220ULL, 0x0000001025257824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e2000d101c4eULL,
0x0000001d2200720cULL, 0x000fc60003f46070ULL, 0x018a10001f187984ULL, 0x000ee20000000800ULL,
0xfffffff025247812ULL, 0x000fc800078ee224ULL, 0x0000000b24237c11ULL, 0x002fe4000f8e20ffULL,
0x00000006181e7c11ULL, 0x008fca000f8e10ffULL, 0x018ac0001e187984ULL, 0x0002e40000000800ULL,
0x000000066c1e7836ULL, 0x002fc80000000000ULL, 0x000000015b257824ULL, 0x000fe400078e021eULL,
0x0000000818197c24ULL, 0x008fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000002118167210ULL, 0x000fca0007f7e0ffULL, 0x000000ffff177224ULL, 0x000fe400018e0619ULL,
0x0000000125197824ULL, 0x040fe400078e0220ULL, 0x0000000125207824ULL, 0x040fe200078e0210ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e2000d101c4eULL,
0x0000001025257824ULL, 0x000fe200078e00ffULL, 0x0000001d1e00720cULL, 0x000fe40003f46070ULL,
0x018a18001f187984ULL, 0x000ee40000000800ULL, 0xfffffff025207812ULL, 0x000fc800078ee220ULL,
0x0000000b20177c11ULL, 0x002fe4000f8e20ffULL, 0x0000000618187c11ULL, 0x008fcc000f8e10ffULL,
0x018ac00018187984ULL, 0x000e640000000800ULL, 0x0000000818197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019147825ULL, 0x000fc600078e0014ULL, 0x0000002114147210ULL, 0x000fca0007f7e0ffULL,
0x000000ffff157224ULL, 0x000fca00018e0615ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014177faeULL, 0x0003e2000d101c4eULL, 0x0000000400287947ULL, 0x000fea0003800000ULL,
0x000000015b1f7824ULL, 0x000fe200078e026cULL, 0x0000002013227811ULL, 0x000fe200078e30ffULL,
0x0000001010197824ULL, 0x000fe200078e00ffULL, 0x00016000060b7890ULL, 0x000fe2000fffe03fULL,
0x000000101f1e7824ULL, 0x040fe200078e00ffULL, 0x000000061f207c11ULL, 0x040fe2000f8e10ffULL,
0x000000011f177824ULL, 0x000fe200078e0222ULL, 0x000000f019217812ULL, 0x000fe200078ec0ffULL,
0x000000011f197824ULL, 0x000fe400078e0210ULL, 0x018a000020147984ULL, 0x000e620000000800ULL,
0x000000021f237836ULL, 0x000fc40000000000ULL, 0xfffffff01e197812ULL, 0x000fe400078ee219ULL,
0x0000000123247824ULL, 0x000fe400078e0210ULL, 0x0000000b191d7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000122197824ULL, 0x000fe400078e0223ULL, 0x0000001023237824ULL, 0x000fe200078e00ffULL,
0x0000000614187c11ULL, 0x002fe4000f8e10ffULL, 0x00008a00ff147b82ULL, 0x000e660000000a00ULL,
0x018ac00018167984ULL, 0x000ee40000000800ULL, 0x0000000816177c24ULL, 0x008fc8000f8e0217ULL,
0x0000010017167825ULL, 0x002fc600078e0014ULL, 0x0000002116167210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff177224ULL, 0x000fca00010e0617ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000161d7faeULL, 0x0003e8000b901c4eULL, 0x018a080020187984ULL, 0x000ee20000000800ULL,
0xfffffff0231d7812ULL, 0x002fe200078ee224ULL, 0x000000041f237836ULL, 0x000fe40000000000ULL,
0x000000061f1f7836ULL, 0x000fe20000000000ULL, 0x0000000b1d1d7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000122177824ULL, 0x000fc400078e0223ULL, 0x0000000123247824ULL, 0x040fe400078e0210ULL,
0x0000001023237824ULL, 0x000fe200078e00ffULL, 0x00000006181e7c11ULL, 0x008fca000f8e10ffULL,
0x018ac0001e187984ULL, 0x000e640000000800ULL, 0x0000000818197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000002118187210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff197224ULL, 0x000fca00010e0619ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000181d7faeULL, 0x0003e8000b901c4eULL, 0x018a100020167984ULL, 0x000ee20000000800ULL,
0xfffffff023197812ULL, 0x002fe200078ee224ULL, 0x00000001221d7824ULL, 0x000fc600078e021fULL,
0x0000000b19197c11ULL, 0x000fe4000f8e20ffULL, 0x00000006161e7c11ULL, 0x008fca000f8e10ffULL,
0x018ac0001e167984ULL, 0x0002e40000000800ULL, 0x000000101f1e7824ULL, 0x002fe400078e00ffULL,
0x0000000816177c24ULL, 0x008fc8000f8e0217ULL, 0x0000010017167825ULL, 0x000fc600078e0014ULL,
0x0000002116167210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff177224ULL, 0x000fca00010e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016197faeULL, 0x0003e8000b901c4eULL,
0x018a180020187984ULL, 0x000ee40000000800ULL, 0x0000000618187c11ULL, 0x008fcc000f8e10ffULL,
0x018ac00018187984ULL, 0x000ee40000000800ULL, 0x00000008181d7c24ULL, 0x008fc8000f8e021dULL,
0x000001001d147825ULL, 0x000fc800078e0014ULL, 0x000000011f1d7824ULL, 0x000fe200078e0210ULL,
0x0000002114147210ULL, 0x000fc80007f5e0ffULL, 0xfffffff01e177812ULL, 0x002fe200078ee21dULL,
0x000000ffff157224ULL, 0x000fc600010e0615ULL, 0x0000000b17177c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e4000b901c4eULL,
0x00000001ff147424ULL, 0x002fcc00078e00ffULL, 0x018b8814ff1479a7ULL, 0x000e640008500006ULL,
0x000000ffff187224ULL, 0x002fce00078e0015ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x018b8818ff0075a7ULL, 0x000e640008040146ULL, 0x00000000005c2947ULL, 0x002fea0003800000ULL,
0x000000ffff1d7224ULL, 0x000fce00078e00ffULL, 0x000000101d00780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x0000001416197210ULL, 0x000fca0007f5e1ffULL, 0x0000000115157824ULL, 0x000fe200010e0e17ULL,
0x003d09001900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078510ffULL,
0x000000ffff157224ULL, 0x000fca00010e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011d1d7836ULL, 0x000fce0000000000ULL, 0x018b8818ff0075a7ULL, 0x000e640008040146ULL,
0xfffffffc00a8a947ULL, 0x002fea000383ffffULL, 0x0000001b5c00720cULL, 0x000fe20003f44070ULL,
0x00000001ff1e7424ULL, 0x000fe200078e00ffULL, 0x000000031a00780cULL, 0x000fe20003f65270ULL,
0x000000205f6f7824ULL, 0x000fd800078e0210ULL, 0x00000000004ca947ULL, 0x000fea0001800000ULL,
0x000000036f00780cULL, 0x000fe20003f44070ULL, 0x0000000105057890ULL, 0x000fe2000fffe03fULL,
0x0000010000007945ULL, 0x000ff60003800000ULL, 0x0000000000382947ULL, 0x000fea0003800000ULL,
0x00009000ff177b82ULL, 0x000e620000000800ULL, 0x000000070500728cULL, 0x000fe2000bf06070ULL,
0x0000000412167824ULL, 0x000fe200078e026fULL, 0x000000066f197c11ULL, 0x000fc6000f8e10ffULL,
0x0000000216167824ULL, 0x000fe200078e00ffULL, 0x000000000000781cULL, 0x000fe20003f4f008ULL,
0x00008c00ff147b82ULL, 0x000ee20000000a00ULL, 0x0000000517187c36ULL, 0x002fc80008000000ULL,
0x0000001716177224ULL, 0x000fc800078e0218ULL, 0x0000000417147825ULL, 0x008fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18ac000014197faeULL, 0x0003e4000d12184eULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000019000007945ULL, 0x000fe80003800000ULL,
0x00000000005c1947ULL, 0x000fea0003800000ULL, 0x0000001b5c00720cULL, 0x000fe20003f44070ULL,
0x000000011a157836ULL, 0x002fe20000000000ULL, 0x00009400000b7ab9ULL, 0x000fe20000000800ULL,
0x000000066f197c11ULL, 0x000fc6000f8e10ffULL, 0x0000000315167812ULL, 0x000fc800078ec0ffULL,
0x000000ff16167207ULL, 0x000fc60005000000ULL, 0x00000002ff15a819ULL, 0x000fe40000011615ULL,
0x000000015d167824ULL, 0x000fc600078e0216ULL, 0x000000011c1c7824ULL, 0x000fe400078e0215ULL,
0x00009200ff147b82ULL, 0x000e640000000a00ULL, 0x000000401c177824ULL, 0x040fe200078e00ffULL,
0x0000001b1c1b7211ULL, 0x000fc800078ff0ffULL, 0x000000c017187812ULL, 0x000fca00078ec0ffULL,
0x000001001b187824ULL, 0x000fc800078e0218ULL, 0x000000016f177824ULL, 0x100fe400078e0218ULL,
0x0000000b16167c24ULL, 0x000fc6000f8e0218ULL, 0x0000000d17007c0cULL, 0x000fe2000bf46070ULL,
0x000000016f177824ULL, 0x000fc800078e0216ULL, 0x0000000417147825ULL, 0x002fd000078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18a0000014197faeULL, 0x0003e4000d12184eULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a4aULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x018b801eff1479a7ULL, 0x000e620008500006ULL, 0x000000ff6a00720cULL, 0x000fe20003f45270ULL,
0x00000008626d7836ULL, 0x000fe40000000000ULL, 0x000000ffff6b7224ULL, 0x002fd400078e0015ULL,
0x00000004008c2947ULL, 0x000fea0003800000ULL, 0x018af81e5b1479a7ULL, 0x000e640008500006ULL,
0x000000ffff187224ULL, 0x002fce00078e0015ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x018af8185b0075a7ULL, 0x000e640008040146ULL, 0x00000000005c2947ULL, 0x002fea0003800000ULL,
0x000000ffff197224ULL, 0x000fce00078e00ffULL, 0x000000101900780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x0000001416147210ULL, 0x000fca0007f5e1ffULL, 0x0000000115157824ULL, 0x000fe200010e0e17ULL,
0x003d09001400780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401400780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff077819ULL, 0x000fc80000011415ULL, 0x0000001407077211ULL, 0x000fca00078510ffULL,
0x000000ffff147224ULL, 0x000fca00010e0615ULL, 0x0000000207077819ULL, 0x000fc80000001214ULL,
0x000000070000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000119197836ULL, 0x000fce0000000000ULL, 0x018af8185b0075a7ULL, 0x000e640008040146ULL,
0xfffffffc00a8a947ULL, 0x002fea000383ffffULL, 0x0000001010077824ULL, 0x000fe200078e00ffULL,
0x00000001ff147819ULL, 0x000fe20000011610ULL, 0x000000ffff167224ULL, 0x000fc600078e0008ULL,
0x0000007007077812ULL, 0x000fe400078ec0ffULL, 0x0000000c14147812ULL, 0x000fc800078ec0ffULL,
0x00000006141b7c10ULL, 0x000fca000fffe007ULL, 0x018080001b157984ULL, 0x000e680000000800ULL,
0x018280001b147984ULL, 0x0006e20000000800ULL, 0x000000081500720bULL, 0x002fda0003f5d000ULL,
0x0000000000077806ULL, 0x000fc800010e0100ULL, 0x0000ffff07187812ULL, 0x000fe2000784c0ffULL,
0x00000001ff077424ULL, 0x000fd800078e00ffULL, 0x0000000000e0a947ULL, 0x00cfea0003800000ULL,
0x000000081500720bULL, 0x000fe40003f54000ULL, 0x000000015f00780cULL, 0x000fe40003f65270ULL,
0x0000001508167209ULL, 0x000fd20007810000ULL, 0x0000000000197806ULL, 0x000fe400010e0100ULL,
0x018480161b00b388ULL, 0x0003e40000000800ULL, 0x0000991019177816ULL, 0x000fc800000000ffULL,
0x000000ff1700720cULL, 0x000fda0003f45270ULL, 0x0000000000a8a947ULL, 0x002fea0003800000ULL,
0x8000001608087221ULL, 0x000fe20000010000ULL, 0x000000ff19ff7812ULL, 0x040fe4000784c0ffULL,
0x0000ff0019ff7812ULL, 0x000fe2000786c0ffULL, 0x3fb8aa3b08087820ULL, 0x000fc80000410000ULL,
0x00000008001a7308ULL, 0x0002ac0000000800ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x00001f621a087589ULL, 0x006e6400000e0000ULL, 0x000000080b0b7220ULL, 0x082fe20000410000ULL,
0x000000080a0a7220ULL, 0x080fe20000410000ULL, 0x000000080f0f7220ULL, 0x080fe20000410000ULL,
0x000000080e0e7220ULL, 0x080fe20000410000ULL, 0x0000000841417220ULL, 0x080fe20000410000ULL,
0x0000000842427220ULL, 0x080fe20000410000ULL, 0x0000000845457220ULL, 0x080fe20000410000ULL,
0x0000000846467220ULL, 0x080fe20000410000ULL, 0x0000000849497220ULL, 0x080fe20000410000ULL,
0x000000084a4a7220ULL, 0x080fe20000410000ULL, 0x000000084d4d7220ULL, 0x080fe20000410000ULL,
0x000000084e4e7220ULL, 0x080fe20000410000ULL, 0x0000000853537220ULL, 0x080fe20000410000ULL,
0x0000000854547220ULL, 0x080fe20000410000ULL, 0x0000000857577220ULL, 0x080fe20000410000ULL,
0x0000000858587220ULL, 0x000fce0000410000ULL, 0x0000001a09097220ULL, 0x004fe20000410000ULL,
0x000000000044b947ULL, 0x000fec0003800000ULL, 0x00001f6d1a087589ULL, 0x002e6400000e0000ULL,
0x000000080d0d7220ULL, 0x082fe20000410000ULL, 0x000000080c0c7220ULL, 0x080fe20000410000ULL,
0x0000000811117220ULL, 0x080fe20000410000ULL, 0x0000000840407220ULL, 0x080fe20000410000ULL,
0x0000000843437220ULL, 0x080fe20000410000ULL, 0x0000000844447220ULL, 0x080fe20000410000ULL,
0x0000000847477220ULL, 0x080fe20000410000ULL, 0x0000000848487220ULL, 0x080fe20000410000ULL,
0x000000084b4b7220ULL, 0x080fe20000410000ULL, 0x000000084c4c7220ULL, 0x080fe20000410000ULL,
0x000000084f4f7220ULL, 0x080fe20000410000ULL, 0x0000000852527220ULL, 0x080fe20000410000ULL,
0x0000000855557220ULL, 0x080fe20000410000ULL, 0x0000000856567220ULL, 0x080fe20000410000ULL,
0x0000000859597220ULL, 0x080fe20000410000ULL, 0x000000085a5a7220ULL, 0x000fce0000410000ULL,
0x0000ffff18ff7812ULL, 0x000fda0007846019ULL, 0x8000001615152221ULL, 0x000fe20000010000ULL,
0x00007610ff072816ULL, 0x000fc60000000007ULL, 0x3fb8aa3b15152820ULL, 0x000fc80000410000ULL,
0x0000001500062308ULL, 0x000ea40000000800ULL, 0x0000000614142220ULL, 0x004fce0000410000ULL,
0x0000000914097221ULL, 0x000fe20000010000ULL, 0x000000ffff087224ULL, 0x002fce00078e0016ULL,
0x000000ff07ff7812ULL, 0x000fda000784c0ffULL, 0x0000000000102947ULL, 0x000fea0003800000ULL,
0x00000006ff03723eULL, 0x000fc800000010ffULL, 0x0000541003147816ULL, 0x000fca0000000003ULL,
0x00001f6214037589ULL, 0x0002e800000e0000ULL, 0x00001f6d14047589ULL, 0x0002a400000e0000ULL,
0x01280000051c783bULL, 0x0002e20000000200ULL, 0x0000000000102947ULL, 0x000fea0003800000ULL,
0x000000031c1c7232ULL, 0x088fe40000200000ULL, 0x000000031e1e7232ULL, 0x000fe40000200000ULL,
0x000000041d1d7232ULL, 0x084fe40000200000ULL, 0x000000041f1f7232ULL, 0x000fce0000200000ULL,
0x000000000214783bULL, 0x002e680000004200ULL, 0x000000000018783bULL, 0x000f220000004200ULL,
0x00000018ff207819ULL, 0x002fe40000011614ULL, 0x0000ffff15347812ULL, 0x000fe400078ec0ffULL,
0x00000020ff20723eULL, 0x000fe400020006ffULL, 0x000000ff18387812ULL, 0x010fc400078ec0ffULL,
0x0000ffff162e7812ULL, 0x000fe200078ec0ffULL, 0x20000020ff2b7230ULL, 0x000fe20000004100ULL,
0x00000010ff377819ULL, 0x000fe40000011614ULL, 0x00000038ff20723eULL, 0x000fe400020006ffULL,
0x00000010ff337819ULL, 0x000fe40000011616ULL, 0x00000008ff387819ULL, 0x000fe20000011634ULL,
0x20000020ff207230ULL, 0x000fe20000004100ULL, 0x00000008ff2e7819ULL, 0x000fc4000001162eULL,
0x000000ff37377812ULL, 0x000fe400078ec0ffULL, 0x00000010ff357819ULL, 0x100fe40000011615ULL,
0x000000ff15237812ULL, 0x000fe400078ec0ffULL, 0x00000018ff227819ULL, 0x000fe40000011615ULL,
0x00000038ff38723eULL, 0x000fe400020006ffULL, 0x000000ff33337812ULL, 0x000fc400078ec0ffULL,
0x000000ff16247812ULL, 0x000fe400078ec0ffULL, 0x00000018ff157819ULL, 0x000fe40000011616ULL,
0x00000010ff2f7819ULL, 0x100fe40000011617ULL, 0x000000ff19397812ULL, 0x000fe400078ec0ffULL,
0x000000ff17257812ULL, 0x000fe400078ec0ffULL, 0x00000018ff167819ULL, 0x000fc40000011617ULL,
0x0000ffff17307812ULL, 0x000fe400078ec0ffULL, 0x00000010ff317819ULL, 0x100fe40000011618ULL,
0x0000002eff2e723eULL, 0x000fe400020006ffULL, 0x00000018ff177819ULL, 0x000fe40000011618ULL,
0x0000ffff18327812ULL, 0x000fe400078ec0ffULL, 0x00000037ff34723eULL, 0x000fc400020006ffULL,
0x00000010ff297819ULL, 0x100fe40000011619ULL, 0x00000018ff187819ULL, 0x000fe20000011619ULL,
0x20000034ff347230ULL, 0x000fe20000004100ULL, 0x0000ffff192d7812ULL, 0x000fe400078ec0ffULL,
0x00000033ff37723eULL, 0x000fe200020006ffULL, 0x20000038ff337230ULL, 0x000fe20000004100ULL,
0x00000010ff287819ULL, 0x000fe4000001161aULL, 0x00000023ff23723eULL, 0x000fc400020006ffULL,
0x00000039ff19723eULL, 0x000fe400020006ffULL, 0x000000ff2f2f7812ULL, 0x000fe200078ec0ffULL,
0x20000023ff2c7230ULL, 0x000fe20000004100ULL, 0x00000015ff15723eULL, 0x000fe200020006ffULL,
0x20000019ff197230ULL, 0x000fe20000004100ULL, 0x00000008ff387819ULL, 0x000fe20000011630ULL,
0x20000037ff307230ULL, 0x000fe20000004100ULL, 0x000000ff31397812ULL, 0x000fe200078ec0ffULL,
0x2000002eff317230ULL, 0x000fe20000004100ULL, 0x000000ff14217812ULL, 0x000fe200078ec0ffULL,
0x20000015ff237230ULL, 0x000fe20000004100ULL, 0x00000018ff3a7819ULL, 0x000fc4000001161aULL,
0x00000010ff2a7819ULL, 0x000fe4000001161bULL, 0x00000008ff2e7819ULL, 0x000fe4000001162dULL,
0x0000ffff14367812ULL, 0x000fe400078ec0ffULL, 0x0000002fff2f723eULL, 0x000fe400020006ffULL,
0x000000ff28287812ULL, 0x000fe400078ec0ffULL, 0x000000ff1b3c7812ULL, 0x000fe200078ec0ffULL,
0x2000002fff377230ULL, 0x000fe20000004100ULL, 0x00000018ff147819ULL, 0x000fc4000001161bULL,
0x00000038ff38723eULL, 0x000fe400020006ffULL, 0x00000021ff21723eULL, 0x000fe400020006ffULL,
0x0000ffff1b1b7812ULL, 0x000fe200078ec0ffULL, 0x20000038ff2f7230ULL, 0x000fe20000004100ULL,
0x0000003aff15723eULL, 0x000fe200020006ffULL, 0x20000021ff277230ULL, 0x000fe20000004100ULL,
0x0000002eff2e723eULL, 0x000fe400020006ffULL, 0x000000ff2a2a7812ULL, 0x000fe200078ec0ffULL,
0x20000015ff157230ULL, 0x000fe20000004100ULL, 0x00000022ff22723eULL, 0x000fc400020006ffULL,
0x00000008ff3a7819ULL, 0x000fe40000011632ULL, 0x00000028ff28723eULL, 0x000fe400020006ffULL,
0x00000016ff16723eULL, 0x000fe400020006ffULL, 0x00000039ff32723eULL, 0x000fe400020006ffULL,
0x00000008ff397819ULL, 0x000fe4000001161bULL, 0x000000ff35357812ULL, 0x000fe200078ec0ffULL,
0x20000032ff327230ULL, 0x000fe20000004100ULL, 0x0000002aff38723eULL, 0x000fe200020006ffULL,
0x2000002eff2a7230ULL, 0x000fe20000004100ULL, 0x00000024ff26723eULL, 0x000fe200020006ffULL,
0x20000022ff247230ULL, 0x000fe20000004100ULL, 0x00000035ff35723eULL, 0x000fe200020006ffULL,
0x20000028ff2e7230ULL, 0x000fe20000004100ULL, 0x00000039ff28723eULL, 0x000fe200020006ffULL,
0x20000016ff227230ULL, 0x000fe20000004100ULL, 0x0000003cff16723eULL, 0x000fe200020006ffULL,
0x20000026ff267230ULL, 0x000fe20000004100ULL, 0x00000010ff397819ULL, 0x000fe2000001162bULL,
0x20000035ff357230ULL, 0x000fe20000004100ULL, 0x00000010ff3c7819ULL, 0x000fe20000011627ULL,
0x20000028ff277230ULL, 0x000fe20000004100ULL, 0x00000010ff2b7819ULL, 0x000fe20000011634ULL,
0x20000016ff167230ULL, 0x000fe20000004100ULL, 0x00000025ff25723eULL, 0x000fc400020006ffULL,
0x00000017ff17723eULL, 0x000fe400020006ffULL, 0x000000ff1a3b7812ULL, 0x040fe200078ec0ffULL,
0x20000025ff257230ULL, 0x000fe20000004100ULL, 0x0000ffff1a1a7812ULL, 0x000fe200078ec0ffULL,
0x20000017ff217230ULL, 0x000fe20000004100ULL, 0x000000ff29297812ULL, 0x000fe400078ec0ffULL,
0x000010542b3c7816ULL, 0x000fe4000000003cULL, 0x00000010ff2b7819ULL, 0x000fc40000011623ULL,
0x00000010ff267819ULL, 0x000fe40000011626ULL, 0x00000010ff237819ULL, 0x000fe40000011630ULL,
0x00000018ff18723eULL, 0x000fe400020006ffULL, 0x00000029ff29723eULL, 0x000fe400020006ffULL,
0x00000008ff1a7819ULL, 0x000fe2000001161aULL, 0x20000018ff187230ULL, 0x000fe20000004100ULL,
0x00000008ff367819ULL, 0x000fe20000011636ULL, 0x20000029ff297230ULL, 0x000fe20000004100ULL,
0x00000010ff2c7819ULL, 0x000fc4000001162cULL, 0x00000010ff357819ULL, 0x000fe40000011635ULL,
0x0000105423307816ULL, 0x000fe40000000026ULL, 0x00000010ff257819ULL, 0x000fe40000011625ULL,
0x00000010ff287819ULL, 0x000fe40000011637ULL, 0x00000010ff237819ULL, 0x000fe40000011621ULL,
0x0000001aff1a723eULL, 0x000fc400020006ffULL, 0x00000010ff207819ULL, 0x000fe40000011620ULL,
0x00000010ff217819ULL, 0x000fe20000011632ULL, 0x2000001aff1b7230ULL, 0x000fe20000004100ULL,
0x0000003bff17723eULL, 0x000fe200020006ffULL, 0x20000038ff1a7230ULL, 0x000fe20000004100ULL,
0x00000036ff36723eULL, 0x000fe400020006ffULL, 0x0000003aff3a723eULL, 0x000fe200020006ffULL,
0x20000017ff177230ULL, 0x000fe20000004100ULL, 0x00001054353d7816ULL, 0x000fe2000000002cULL,
0x20000036ff367230ULL, 0x000fe20000004100ULL, 0x00000014ff14723eULL, 0x000fe200020006ffULL,
0x2000003aff2d7230ULL, 0x000fe20000004100ULL, 0x00000010ff2c7819ULL, 0x000fc40000011631ULL,
0x0000105428317816ULL, 0x000fe20000000025ULL, 0x20000014ff147230ULL, 0x000fe20000004100ULL,
0x0000105421287816ULL, 0x000fe20000000020ULL, 0x0000003c1c3c723cULL, 0x008fe200000418ffULL,
0x00000010ff207819ULL, 0x000fe40000011618ULL, 0x00000010ff247819ULL, 0x000fe40000011624ULL,
0x00000010ff337819ULL, 0x000fe40000011633ULL, 0x00000010ff197819ULL, 0x000fc40000011619ULL,
0x00000010ff187819ULL, 0x000fe40000011629ULL, 0x0000105424357816ULL, 0x000fe40000000033ULL,
0x00000010ff257819ULL, 0x000fe2000001162aULL, 0x000000301c30723cULL, 0x000fe200000418ffULL,
0x0000105418297816ULL, 0x000fe40000000019ULL, 0x00000010ff347819ULL, 0x000fe40000011636ULL,
0x00000010ff227819ULL, 0x000fc40000011622ULL, 0x00000010ff2f7819ULL, 0x000fe4000001162fULL,
0x00000010ff247819ULL, 0x000fe4000001162dULL, 0x00000010ff177819ULL, 0x000fe40000011617ULL,
0x00000010ff2e7819ULL, 0x000fe4000001162eULL, 0x00000010ff187819ULL, 0x000fe40000011615ULL,
0x00000010ff167819ULL, 0x000fc40000011616ULL, 0x00000010ff217819ULL, 0x000fe4000001161aULL,
0x00000010ff1b7819ULL, 0x000fe4000001161bULL, 0x00000010ff1a7819ULL, 0x000fe40000011614ULL,
0x00000010ff157819ULL, 0x000fe40000011627ULL, 0x0000105420257816ULL, 0x000fe40000000025ULL,
0x0000105439347816ULL, 0x000fc40000000034ULL, 0x000010542b2c7816ULL, 0x000fe4000000002cULL,
0x00001054222d7816ULL, 0x000fe2000000002fULL, 0x000000281c28723cULL, 0x000fe200000418ffULL,
0x0000105423247816ULL, 0x000fe40000000024ULL, 0x000010542e207816ULL, 0x000fe40000000017ULL,
0x0000105421217816ULL, 0x000fe20000000016ULL, 0x000000341c34723cULL, 0x000fe200000418ffULL,
0x0000105418147816ULL, 0x000fc4000000001bULL, 0x000010541a157816ULL, 0x000fe40000000015ULL,
0x012800005e18783bULL, 0x0002e20000000200ULL, 0x0000002c1c2c723cULL, 0x000fec00000418ffULL,
0x000000241c24723cULL, 0x000fec00000418ffULL, 0x000000201c20723cULL, 0x000fec00000418ffULL,
0x000000141c1c723cULL, 0x000fe200000418ffULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000102947ULL, 0x002fde0003800000ULL, 0x0000000318187232ULL, 0x088fe40000200000ULL,
0x000000031a1a7232ULL, 0x000fe40000200000ULL, 0x0000000419197232ULL, 0x084fe40000200000ULL,
0x000000041b1b7232ULL, 0x000fce0000200000ULL, 0x000000006014783bULL, 0x000e620000004200ULL,
0x0000006a6200720cULL, 0x080fe20003f66070ULL, 0x00000c3000007945ULL, 0x000fe20003800000ULL,
0x000000045c007c0cULL, 0x040fe4000bfc3070ULL, 0x0000006a6d00720cULL, 0x000fe40003f86070ULL,
0x000000045c007c0cULL, 0x000fe4000bfa3070ULL, 0x000000ff14397812ULL, 0x002fe400078ec0ffULL,
0x00000010ff387819ULL, 0x000fc40000011614ULL, 0x00000039ff39723eULL, 0x000fe400020006ffULL,
0x00000010ff3a7819ULL, 0x000fe40000011615ULL, 0x000000ff153b7812ULL, 0x000fe200078ec0ffULL,
0x20000039ff507230ULL, 0x000fe20000004100ULL, 0x000000ff38387812ULL, 0x000fe400078ec0ffULL,
0x000000ff3a3a7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff14397812ULL, 0x000fc400078ec0ffULL,
0x0000003bff3b723eULL, 0x000fe400020006ffULL, 0x00000038ff38723eULL, 0x000fe400020006ffULL,
0x0000003aff3a723eULL, 0x000fe200020006ffULL, 0x2000003bff707230ULL, 0x000fe20000004100ULL,
0x00000018ff147819ULL, 0x000fe20000011614ULL, 0x20000038ff517230ULL, 0x000fe20000004100ULL,
0x00000008ff397819ULL, 0x000fe20000011639ULL, 0x2000003aff717230ULL, 0x000fe20000004100ULL,
0x00000014ff6e723eULL, 0x000fc400020006ffULL, 0x00000039ff14723eULL, 0x000fe400020006ffULL,
0x000000006138783bULL, 0x000e620000004200ULL, 0x00000010ff507819ULL, 0x000fe20000011650ULL,
0x2000006eff6e7230ULL, 0x000fe20000004100ULL, 0x00000010ff517819ULL, 0x000fe20000011651ULL,
0x20000014ff147230ULL, 0x000fe20000004100ULL, 0x00000010ff707819ULL, 0x000fe40000011670ULL,
0x00000010ff717819ULL, 0x000fe40000011671ULL, 0x0000105451507816ULL, 0x000fc40000000050ULL,
0x0000105471517816ULL, 0x000fe40000000070ULL, 0x00000018ff707819ULL, 0x000fe40000011615ULL,
0x000000ff16727812ULL, 0x000fe400078ec0ffULL, 0x00000070ff70723eULL, 0x000fe200020006ffULL,
0x00000050183c723cULL, 0x008fe2000004183cULL, 0x00000010ff717819ULL, 0x000fe4000001166eULL,
0x00000010ff147819ULL, 0x000fc40000011614ULL, 0x000000ff17747812ULL, 0x000fe400078ec0ffULL,
0x0000ffff15507812ULL, 0x000fe400078ec0ffULL, 0x00000010ff517819ULL, 0x000fe40000011616ULL,
0x00000008ff507819ULL, 0x000fe40000011650ULL, 0x00000072ff6e723eULL, 0x000fe200020006ffULL,
0x20000070ff727230ULL, 0x000fe20000004100ULL, 0x00000050ff50723eULL, 0x000fc400020006ffULL,
0x0000105471147816ULL, 0x000fe20000000014ULL, 0x2000006eff6e7230ULL, 0x000fe20000004100ULL,
0x00000018ff737819ULL, 0x000fe20000011616ULL, 0x20000050ff707230ULL, 0x000fe20000004100ULL,
0x00000074ff75723eULL, 0x000fe400020006ffULL, 0x00000010ff717819ULL, 0x000fe40000011617ULL,
0x000000ff51747812ULL, 0x000fe200078ec0ffULL, 0x20000075ff507230ULL, 0x000fe20000004100ULL,
0x00000073ff51723eULL, 0x000fc400020006ffULL, 0x00000018ff157819ULL, 0x000fe40000011617ULL,
0x00000074ff74723eULL, 0x000fe200020006ffULL, 0x20000051ff517230ULL, 0x000fe20000004100ULL,
0x000000ff71737812ULL, 0x000fe400078ec0ffULL, 0x00000010ff727819ULL, 0x000fe20000011672ULL,
0x20000074ff747230ULL, 0x000fe20000004100ULL, 0x00000010ff717819ULL, 0x000fe40000011670ULL,
0x00000015ff70723eULL, 0x000fc400020006ffULL, 0x0000105472157816ULL, 0x000fe40000000071ULL,
0x000000ff38727812ULL, 0x002fe200078ec0ffULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x0000ffff16167812ULL, 0x000fe400078ec0ffULL, 0x0000ffff17177812ULL, 0x000fe200078ec0ffULL,
0x000000141834723cULL, 0x000fe20000041834ULL, 0x00000010ff717819ULL, 0x000fe4000001166eULL,
0x00000010ff747819ULL, 0x000fc40000011674ULL, 0x00000072ff6e723eULL, 0x000fe400020006ffULL,
0x00000008ff727819ULL, 0x000fe40000011616ULL, 0x00000008ff177819ULL, 0x000fe20000011617ULL,
0x2000006eff6e7230ULL, 0x000fe20000004100ULL, 0x0000105474167816ULL, 0x000fe40000000071ULL,
0x00000072ff72723eULL, 0x000fe400020006ffULL, 0x00000017ff71723eULL, 0x000fc400020006ffULL,
0x00000073ff73723eULL, 0x000fe200020006ffULL, 0x20000072ff727230ULL, 0x000fe20000004100ULL,
0x00000010ff747819ULL, 0x000fe20000011638ULL, 0x20000071ff717230ULL, 0x000fe20000004100ULL,
0x00000010ff517819ULL, 0x000fe20000011651ULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x00000010ff707819ULL, 0x000fe40000011670ULL, 0x00000010ff147819ULL, 0x000fe40000011672ULL,
0x00000010ff157819ULL, 0x000fc40000011671ULL, 0x000000ff74757812ULL, 0x000fe400078ec0ffULL,
0x00000010ff177819ULL, 0x000fe40000011650ULL, 0x00000010ff747819ULL, 0x000fe40000011673ULL,
0x0000105451147816ULL, 0x000fe40000000014ULL, 0x0000105470157816ULL, 0x000fe40000000015ULL,
0x0000105474177816ULL, 0x000fc40000000017ULL, 0x00000018ff717819ULL, 0x000fe40000011638ULL,
0x0000ffff38737812ULL, 0x000fe200078ec0ffULL, 0x00000014182c723cULL, 0x000fe2000004182cULL,
0x000000ff3a387812ULL, 0x000fe400078ec0ffULL, 0x00000075ff50723eULL, 0x000fe400020006ffULL,
0x00000010ff707819ULL, 0x100fe2000001163aULL, 0x000000161830723cULL, 0x000fe20000041830ULL,
0x00000018ff147819ULL, 0x000fe20000011639ULL, 0x20000050ff507230ULL, 0x000fe20000004100ULL,
0x00000018ff747819ULL, 0x000fc4000001163aULL, 0x00000014ff14723eULL, 0x000fe400020006ffULL,
0x00000010ff167819ULL, 0x000fe4000001166eULL, 0x0000ffff3a6e7812ULL, 0x000fe400078ec0ffULL,
0x00000038ff3a723eULL, 0x000fe200020006ffULL, 0x20000014ff387230ULL, 0x000fe20000004100ULL,
0x00000010ff157819ULL, 0x000fe40000011639ULL, 0x00000071ff71723eULL, 0x000fe200020006ffULL,
0x2000003aff147230ULL, 0x000fe20000004100ULL, 0x000000ff39517812ULL, 0x000fc400078ec0ffULL,
0x0000ffff39727812ULL, 0x000fe200078ec0ffULL, 0x20000071ff397230ULL, 0x000fe20000004100ULL,
0x00000074ff74723eULL, 0x000fe400020006ffULL, 0x000000ff153a7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff737819ULL, 0x000fe40000011673ULL, 0x00000010ff177819ULL, 0x000fe40000011650ULL,
0x00000051ff51723eULL, 0x000fc400020006ffULL, 0x0000003aff71723eULL, 0x000fe200020006ffULL,
0x20000074ff3a7230ULL, 0x000fe20000004100ULL, 0x00000008ff727819ULL, 0x000fe20000011672ULL,
0x20000051ff517230ULL, 0x000fe20000004100ULL, 0x00000073ff73723eULL, 0x000fe400020006ffULL,
0x000000ff70747812ULL, 0x000fe400078ec0ffULL, 0x0000105417167816ULL, 0x000fe40000000016ULL,
0x0000ffff3b177812ULL, 0x000fc400078ec0ffULL, 0x00000072ff70723eULL, 0x000fe200020006ffULL,
0x20000071ff727230ULL, 0x000fe20000004100ULL, 0x00000074ff74723eULL, 0x000fe400020006ffULL,
0x00000008ff717819ULL, 0x000fe2000001166eULL, 0x20000073ff6e7230ULL, 0x000fe20000004100ULL,
0x00000008ff737819ULL, 0x000fe20000011617ULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x00000010ff177819ULL, 0x000fe20000011651ULL, 0x20000074ff517230ULL, 0x000fe20000004100ULL,
0x00000073ff74723eULL, 0x000fc400020006ffULL, 0x00000010ff737819ULL, 0x000fe40000011638ULL,
0x00000010ff507819ULL, 0x000fe4000001163bULL, 0x00000010ff397819ULL, 0x000fe40000011639ULL,
0x00000010ff387819ULL, 0x000fe2000001166eULL, 0x20000074ff6e7230ULL, 0x000fe20000004100ULL,
0x00000010ff707819ULL, 0x000fe40000011670ULL, 0x000000ff3b767812ULL, 0x000fc400078ec0ffULL,
0x000000ff50507812ULL, 0x000fe400078ec0ffULL, 0x0000105439387816ULL, 0x000fe40000000038ULL,
0x00000018ff757819ULL, 0x000fe4000001163bULL, 0x0000105473397816ULL, 0x000fe40000000070ULL,
0x00000076ff76723eULL, 0x000fe400020006ffULL, 0x00000050ff50723eULL, 0x000fc400020006ffULL,
0x00000075ff3b723eULL, 0x000fe200020006ffULL, 0x000000381824723cULL, 0x000fe20000041824ULL,
0x00000071ff71723eULL, 0x000fe200020006ffULL, 0x20000076ff157230ULL, 0x000fe20000004100ULL,
0x00000010ff727819ULL, 0x000fe20000011672ULL, 0x20000050ff507230ULL, 0x000fe20000004100ULL,
0x00000010ff147819ULL, 0x000fe20000011614ULL, 0x2000003bff3b7230ULL, 0x000fe20000004100ULL,
0x0000105472177816ULL, 0x000fe20000000017ULL, 0x000000016a387836ULL, 0x000fe20000000000ULL,
0x00000010ff157819ULL, 0x000fe20000011615ULL, 0x20000071ff717230ULL, 0x000fe20000004100ULL,
0x00000010ff517819ULL, 0x000fc40000011651ULL, 0x00000010ff507819ULL, 0x000fe20000011650ULL,
0x000000161828723cULL, 0x000fe20000041828ULL, 0x000000386200720cULL, 0x000fe40005f66470ULL,
0x00000010ff3a7819ULL, 0x000fe4000001163aULL, 0x00000010ff3b7819ULL, 0x000fe4000001163bULL,
0x00000010ff717819ULL, 0x000fe40000011671ULL, 0x00000010ff6e7819ULL, 0x000fc4000001166eULL,
0x0000105451167816ULL, 0x000fe40000000014ULL, 0x0000105450177816ULL, 0x000fe40000000015ULL,
0x000010543a147816ULL, 0x000fe40000000071ULL, 0x000010543b157816ULL, 0x000fe4000000006eULL,
0x000000386d00720cULL, 0x000fe20006786470ULL, 0x000000161820723cULL, 0x000fec0000041820ULL,
0x00000014181c723cULL, 0x000fe2000004181cULL, 0x00000001ff167424ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000403947ULL, 0x000fde0003000000ULL,
0x0000003c0b0b7221ULL, 0x000fe20000010000ULL, 0x0000003d0a0a7221ULL, 0x000fe20000010000ULL,
0x000000340f0f7221ULL, 0x000fe20000010000ULL, 0x000000350e0e7221ULL, 0x000fe20000010000ULL,
0x0000003041417221ULL, 0x000fe20000010000ULL, 0x0000003142427221ULL, 0x000fe20000010000ULL,
0x0000002c45457221ULL, 0x000fe20000010000ULL, 0x0000002d46467221ULL, 0x000fe20000010000ULL,
0x0000002849497221ULL, 0x000fe20000010000ULL, 0x000000294a4a7221ULL, 0x000fe20000010000ULL,
0x000000244d4d7221ULL, 0x000fe20000010000ULL, 0x000000254e4e7221ULL, 0x000fe20000010000ULL,
0x0000002053537221ULL, 0x000fe20000010000ULL, 0x0000002154547221ULL, 0x000fe20000010000ULL,
0x0000001c57577221ULL, 0x000fe20000010000ULL, 0x0000001d58587221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000012000007945ULL, 0x000fe80003800000ULL,
0x0000000000404947ULL, 0x000fea0002800000ULL, 0x0000003e0d0d7221ULL, 0x000fe20000010000ULL,
0x0000003f0c0c7221ULL, 0x000fe20000010000ULL, 0x0000003611117221ULL, 0x000fe20000010000ULL,
0x0000003740407221ULL, 0x000fe20000010000ULL, 0x0000003243437221ULL, 0x000fe20000010000ULL,
0x0000003344447221ULL, 0x000fe20000010000ULL, 0x0000002e47477221ULL, 0x000fe20000010000ULL,
0x0000002f48487221ULL, 0x000fe20000010000ULL, 0x0000002a4b4b7221ULL, 0x000fe20000010000ULL,
0x0000002b4c4c7221ULL, 0x000fe20000010000ULL, 0x000000264f4f7221ULL, 0x000fe20000010000ULL,
0x0000002752527221ULL, 0x000fe20000010000ULL, 0x0000002255557221ULL, 0x000fe20000010000ULL,
0x0000002356567221ULL, 0x000fe20000010000ULL, 0x0000001e59597221ULL, 0x000fe20000010000ULL,
0x0000001f5a5a7221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x018b8816ff1479a7ULL, 0x000e620008500006ULL, 0x00000002ff177819ULL, 0x000fe40000011638ULL,
0x000000045c007c0cULL, 0x000fe4000bfc3070ULL, 0x0000001738177207ULL, 0x040fe40000000000ULL,
0x00000003381a7812ULL, 0x000fe400078ec0ffULL, 0x000000045c007c0cULL, 0x000fe2000bfa3070ULL,
0x0000000117177836ULL, 0x000fe20000000000ULL, 0x00000040ff387803ULL, 0x000fc40000000000ULL,
0x000000ff1a1a7207ULL, 0x000fe40004000000ULL, 0x00000003171b7812ULL, 0x040fe400078ec0ffULL,
0x00000004171c7c11ULL, 0x000fe2000f8ff0ffULL, 0x000000ffff187224ULL, 0x002fce00078e0015ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x018b806bff0075a7ULL, 0x000e6400080c0146ULL,
0x00000000005c6947ULL, 0x002fea0003800000ULL, 0x000000ffff1d7224ULL, 0x000fce00078e00ffULL,
0x000000101d00780cULL, 0x000fda0003fc6270ULL, 0x000000000044e947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x0000001416197210ULL, 0x000fca0007fde1ffULL,
0x0000000115157824ULL, 0x000fe200030e0e17ULL, 0x003d09001900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x000000000008e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x00000000001ce947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001914147211ULL, 0x000fca00078d10ffULL, 0x000000ffff157224ULL, 0x000fca00030e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011d1d7836ULL, 0x000fce0000000000ULL,
0x018b806bff0075a7ULL, 0x000e6400080c0146ULL, 0xfffffffc00a8e947ULL, 0x002fea000383ffffULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x018b8818ff0075a7ULL, 0x000e6400080c0146ULL,
0x00000000005c6947ULL, 0x002fea0003800000ULL, 0x000000ffff1d7224ULL, 0x000fce00078e00ffULL,
0x000000101d00780cULL, 0x000fda0003fc6270ULL, 0x000000000044e947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x0000001416197210ULL, 0x000fca0007fde1ffULL,
0x0000000115157824ULL, 0x000fe200030e0e17ULL, 0x003d09001900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x000000000008e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x00000000001ce947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001914147211ULL, 0x000fca00078d10ffULL, 0x000000ffff157224ULL, 0x000fca00030e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011d1d7836ULL, 0x000fce0000000000ULL,
0x018b8818ff0075a7ULL, 0x000e6400080c0146ULL, 0xfffffffc00a8e947ULL, 0x002fea000383ffffULL,
0x000000011c147836ULL, 0x000fca0000000000ULL, 0x0000001014007c0cULL, 0x000fda000bfc6070ULL,
0x00000004005ce947ULL, 0x000fea0003800000ULL, 0x000000015b1d7824ULL, 0x000fe200078e026cULL,
0x00014000060b7890ULL, 0x000fe2000fffe03fULL, 0x0000001010187824ULL, 0x000fe400078e00ffULL,
0x0000004013217824ULL, 0x000fe200078e021dULL, 0x000000061d1f7c11ULL, 0x040fe2000f8e10ffULL,
0x000000101d1e7824ULL, 0x000fe200078e00ffULL, 0x000000f018237812ULL, 0x000fe200078ec0ffULL,
0x000000041c187824ULL, 0x000fe400078e021bULL, 0x018a00001f147984ULL, 0x000e620000000800ULL,
0x000000026c207836ULL, 0x000fc40000000000ULL, 0x0000004018187824ULL, 0x000fe400078e00ffULL,
0x000000015b277824ULL, 0x000fe200078e0220ULL, 0x0000000614197c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e660000000a00ULL, 0x018ac00019167984ULL, 0x0007240000000800ULL,
0x0000000d18197c48ULL, 0x008fca000ffe0000ULL, 0x0000000119187824ULL, 0x000fe400078e0a18ULL,
0x000000011d197824ULL, 0x000fc600078e0210ULL, 0x000000185b187248ULL, 0x000fe40007fe0000ULL,
0xfffffff01e197812ULL, 0x000fc600078ee219ULL, 0x00000001181d7824ULL, 0x000fe200078e0a5bULL,
0x0000000b19257c11ULL, 0x000fe2000f8e20ffULL, 0x0000000221197836ULL, 0x000fe40000000000ULL,
0x0000000816177c24ULL, 0x010fc8000f8e0221ULL, 0x0000010017167825ULL, 0x002fc600078e0014ULL,
0x0000002316167210ULL, 0x000fca0007fde0ffULL, 0x000000ffff177224ULL, 0x000fe200030e0617ULL,
0x0000001d6c00720cULL, 0x000fda0003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016257faeULL, 0x0003e8000f101c4eULL, 0x018a08001f187984ULL, 0x000ee20000000800ULL,
0x0000000127167824ULL, 0x042fe400078e0210ULL, 0x0000001027277824ULL, 0x000fe400078e00ffULL,
0x0000000421177836ULL, 0x000fc60000000000ULL, 0xfffffff027167812ULL, 0x000fc800078ee216ULL,
0x0000000b16257c11ULL, 0x000fe4000f8e20ffULL, 0x00000006181e7c11ULL, 0x008fca000f8e10ffULL,
0x018ac0001e187984ULL, 0x000e640000000800ULL, 0x0000000818197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000002318187210ULL, 0x000fca0007fde0ffULL,
0x000000ffff197224ULL, 0x000fe200030e0619ULL, 0x0000001d2000720cULL, 0x000fe20003fc6070ULL,
0x000000046c207836ULL, 0x000fe40000000000ULL, 0x000000066c6c7836ULL, 0x000fe40000000000ULL,
0x000000015b277824ULL, 0x000fd000078e0220ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018257faeULL, 0x0003e8000f101c4eULL, 0x018a10001f167984ULL, 0x000ee20000000800ULL,
0x0000000127187824ULL, 0x042fe400078e0210ULL, 0x0000001027277824ULL, 0x000fe400078e00ffULL,
0x0000000621197836ULL, 0x000fc60000000000ULL, 0xfffffff027187812ULL, 0x000fc800078ee218ULL,
0x0000000b18257c11ULL, 0x000fe4000f8e20ffULL, 0x00000006161e7c11ULL, 0x008fca000f8e10ffULL,
0x018ac0001e167984ULL, 0x000e640000000800ULL, 0x0000000816177c24ULL, 0x002fc8000f8e0217ULL,
0x0000010017167825ULL, 0x000fc600078e0014ULL, 0x0000002316167210ULL, 0x000fca0007fde0ffULL,
0x000000ffff177224ULL, 0x000fe200030e0617ULL, 0x0000001d2000720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016257faeULL, 0x0003e8000f101c4eULL,
0x018a18001f187984ULL, 0x000ee40000000800ULL, 0x0000000618187c11ULL, 0x008fcc000f8e10ffULL,
0x018ac00018187984ULL, 0x000ee40000000800ULL, 0x0000000818197c24ULL, 0x008fc8000f8e0219ULL,
0x0000010019147825ULL, 0x000fc800078e0014ULL, 0x000000015b197824ULL, 0x000fe200078e026cULL,
0x0000002314147210ULL, 0x000fc60007fde0ffULL, 0x0000000119167824ULL, 0x042fe400078e0210ULL,
0x000000ffff157224ULL, 0x000fe200030e0615ULL, 0x0000001d6c00720cULL, 0x000fe20003fc6070ULL,
0x0000001019197824ULL, 0x000fca00078e00ffULL, 0xfffffff019167812ULL, 0x000fc800078ee216ULL,
0x0000000b16177c11ULL, 0x000fca000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014177faeULL, 0x0003e2000f101c4eULL, 0x0000000400247947ULL, 0x000fea0003800000ULL,
0x000000015b6c7824ULL, 0x000fe200078e026cULL, 0x00014000060b7890ULL, 0x000fe2000fffe03fULL,
0x0000001010197824ULL, 0x000fe400078e00ffULL, 0x00000040131f7824ULL, 0x000fe200078e026cULL,
0x000000066c1e7c11ULL, 0x040fe2000f8e10ffULL, 0x000000106c207824ULL, 0x040fe200078e00ffULL,
0x000000f019217812ULL, 0x000fe200078ec0ffULL, 0x000000016c197824ULL, 0x000fe400078e0210ULL,
0x018a00001e147984ULL, 0x000e620000000800ULL, 0x000000026c257836ULL, 0x000fc40000000000ULL,
0xfffffff020197812ULL, 0x000fe400078ee219ULL, 0x0000000125207824ULL, 0x000fe400078e0210ULL,
0x0000000b19237c11ULL, 0x000fe2000f8e20ffULL, 0x000000021f197836ULL, 0x000fe40000000000ULL,
0x0000001025257824ULL, 0x000fca00078e00ffULL, 0xfffffff025207812ULL, 0x000fe200078ee220ULL,
0x000000046c257836ULL, 0x000fe20000000000ULL, 0x0000000614187c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e660000000a00ULL, 0x018ac00018167984ULL, 0x000ee40000000800ULL,
0x0000000816177c24ULL, 0x008fc8000f8e021fULL, 0x0000010017167825ULL, 0x002fc600078e0014ULL,
0x0000002116167210ULL, 0x000fca0007fde0ffULL, 0x000000ffff177224ULL, 0x000fca00030e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e8000b901c4eULL,
0x018a08001e187984ULL, 0x000ee20000000800ULL, 0x0000000b20237c11ULL, 0x002fe2000f8e20ffULL,
0x000000041f177836ULL, 0x000fe40000000000ULL, 0x0000000125207824ULL, 0x040fe400078e0210ULL,
0x0000001025257824ULL, 0x000fca00078e00ffULL, 0xfffffff025207812ULL, 0x000fe400078ee220ULL,
0x00000006181d7c11ULL, 0x008fca000f8e10ffULL, 0x018ac0001d187984ULL, 0x000e640000000800ULL,
0x0000000818197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000002118187210ULL, 0x000fca0007fde0ffULL, 0x000000ffff197224ULL, 0x000fca00030e0619ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018237faeULL, 0x0003e8000b901c4eULL,
0x018a10001e167984ULL, 0x000ee20000000800ULL, 0x0000000b20237c11ULL, 0x002fe2000f8e20ffULL,
0x000000061f197836ULL, 0x000fe20000000000ULL, 0x00000006161d7c11ULL, 0x008fca000f8e10ffULL,
0x018ac0001d167984ULL, 0x000e640000000800ULL, 0x0000000816177c24ULL, 0x002fc8000f8e0217ULL,
0x0000010017167825ULL, 0x000fc600078e0014ULL, 0x0000002116167210ULL, 0x000fca0007fde0ffULL,
0x000000ffff177224ULL, 0x000fca00030e0617ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0003e8000b901c4eULL, 0x018a18001e187984ULL, 0x000ee40000000800ULL,
0x0000000618187c11ULL, 0x008fcc000f8e10ffULL, 0x018ac00018187984ULL, 0x000ee40000000800ULL,
0x0000000818197c24ULL, 0x008fc8000f8e0219ULL, 0x0000010019147825ULL, 0x000fc800078e0014ULL,
0x000000066c197836ULL, 0x000fe20000000000ULL, 0x0000002114147210ULL, 0x000fc60007fde0ffULL,
0x00000001191d7824ULL, 0x040fe400078e0210ULL, 0x0000001019167824ULL, 0x002fe400078e00ffULL,
0x000000ffff157224ULL, 0x000fc600030e0615ULL, 0xfffffff0161d7812ULL, 0x000fc800078ee21dULL,
0x0000000b1d1d7c11ULL, 0x000fca000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000141d7faeULL, 0x0003e4000b901c4eULL, 0x00000001ff147424ULL, 0x002fcc00078e00ffULL,
0x018b8814ff1479a7ULL, 0x000e640008500006ULL, 0x000000ffff187224ULL, 0x002fce00078e0015ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x018b8818ff0075a7ULL, 0x000e6400080c0146ULL,
0x00000000005c6947ULL, 0x002fea0003800000ULL, 0x000000ffff1d7224ULL, 0x000fce00078e00ffULL,
0x000000101d00780cULL, 0x000fda0003fc6270ULL, 0x000000000044e947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x0000001416197210ULL, 0x000fca0007fde1ffULL,
0x0000000115157824ULL, 0x000fe200030e0e17ULL, 0x003d09001900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x000000000008e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x00000000001ce947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001914147211ULL, 0x000fca00078d10ffULL, 0x000000ffff157224ULL, 0x000fca00030e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011d1d7836ULL, 0x000fce0000000000ULL,
0x018b8818ff0075a7ULL, 0x000e6400080c0146ULL, 0xfffffffc00a8e947ULL, 0x002fea000383ffffULL,
0x0000019000007945ULL, 0x000fe20003800000ULL, 0x00000001ff6e7424ULL, 0x000fc600078e00ffULL,
0x0000000000581947ULL, 0x000fea0003800000ULL, 0x0000001c5c00720cULL, 0x000fe20003fc4070ULL,
0x00009400000b7ab9ULL, 0x000fc60000000800ULL, 0x000000ff1a147207ULL, 0x040fe40003000000ULL,
0x000000ff1a1a7207ULL, 0x000fc60007000000ULL, 0x000000011b1b7824ULL, 0x000fe400078e0214ULL,
0x00009200ff147b82ULL, 0x000e620000000a00ULL, 0x000000015d177824ULL, 0x000fe400078e021aULL,
0x000000401b167824ULL, 0x040fe200078e00ffULL, 0x0000001c1b1b7211ULL, 0x000fc800078ff0ffULL,
0x000000c016167812ULL, 0x000fca00078ec0ffULL, 0x000001001b167824ULL, 0x000fc800078e0216ULL,
0x0000002016187836ULL, 0x000fc80000000000ULL, 0x0000000b17167c24ULL, 0x000fc8000f8e0218ULL,
0x000000016f177824ULL, 0x040fe400078e0216ULL, 0x000000016f167824ULL, 0x040fe200078e0218ULL,
0x000000066f6f7c11ULL, 0x000fe2000f8e10ffULL, 0x0000000417147825ULL, 0x002fc600078e0014ULL,
0x0000000d16007c0cULL, 0x000fda000bfc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x18a00000146f7faeULL, 0x0003e4000f12184eULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a49ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x018b786eff6e79a7ULL, 0x000e620008500006ULL,
0x0000000000102947ULL, 0x000fea0003800000ULL, 0x00000006ff03723eULL, 0x000fc800000010ffULL,
0x0000541003147816ULL, 0x000fca0000000003ULL, 0x00001f6d14047589ULL, 0x0044e800000e0000ULL,
0x00001f6214037589ULL, 0x00046400000e0000ULL, 0x012800006530783bULL, 0x0006a20000000200ULL,
0x0000000000102947ULL, 0x000fea0003800000ULL, 0x0000000330307232ULL, 0x086fe40000200000ULL,
0x0000000332327232ULL, 0x000fe40000200000ULL, 0x0000000431317232ULL, 0x088fe40000200000ULL,
0x0000000433337232ULL, 0x000fce0000200000ULL, 0x000000006414783bULL, 0x004ea80000004200ULL,
0x000000006318783bULL, 0x000f220000004200ULL, 0x0000ffff16277812ULL, 0x044fe400078ec0ffULL,
0x000000ff16227812ULL, 0x000fe400078ec0ffULL, 0x00000008ff277819ULL, 0x000fe40000011627ULL,
0x00000018ff207819ULL, 0x000fc40000011616ULL, 0x00000010ff2a7819ULL, 0x010fe40000011618ULL,
0x00000022ff22723eULL, 0x000fe400020006ffULL, 0x00000010ff367819ULL, 0x000fe40000011614ULL,
0x0000ffff14377812ULL, 0x000fe400078ec0ffULL, 0x00000010ff347819ULL, 0x000fe40000011615ULL,
0x00000018ff3b7819ULL, 0x000fc4000001161aULL, 0x00000027ff27723eULL, 0x000fe400020006ffULL,
0x00000010ff287819ULL, 0x000fe40000011617ULL, 0x00000010ff217819ULL, 0x100fe40000011619ULL,
0x000000ff193a7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff397819ULL, 0x000fe40000011619ULL,
0x0000ffff19297812ULL, 0x000fc400078ec0ffULL, 0x0000ffff172b7812ULL, 0x000fe400078ec0ffULL,
0x00000020ff19723eULL, 0x000fe200020006ffULL, 0x20000022ff207230ULL, 0x000fe20000004100ULL,
0x000000ff2a2a7812ULL, 0x000fe400078ec0ffULL, 0x000000ff141d7812ULL, 0x000fe200078ec0ffULL,
0x20000019ff197230ULL, 0x000fe20000004100ULL, 0x000000ff36367812ULL, 0x000fe400078ec0ffULL,
0x00000008ff377819ULL, 0x000fc40000011637ULL, 0x000000ff151f7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff1a247812ULL, 0x000fe400078ec0ffULL, 0x0000003bff22723eULL, 0x000fe200020006ffULL,
0x20000027ff3b7230ULL, 0x000fe20000004100ULL, 0x000000ff34347812ULL, 0x000fe400078ec0ffULL,
0x000000ff28287812ULL, 0x000fe200078ec0ffULL, 0x20000022ff227230ULL, 0x000fe20000004100ULL,
0x00000018ff1c7819ULL, 0x000fc40000011614ULL, 0x0000ffff15357812ULL, 0x000fe400078ec0ffULL,
0x00000008ff2b7819ULL, 0x000fe4000001162bULL, 0x0000002aff2a723eULL, 0x000fe400020006ffULL,
0x000000ff21277812ULL, 0x000fe400078ec0ffULL, 0x00000018ff1e7819ULL, 0x000fe20000011615ULL,
0x2000002aff217230ULL, 0x000fe20000004100ULL, 0x00000010ff2f7819ULL, 0x000fc40000011616ULL,
0x0000001dff14723eULL, 0x000fe400020006ffULL, 0x00000036ff36723eULL, 0x000fe400020006ffULL,
0x00000037ff37723eULL, 0x000fe200020006ffULL, 0x20000014ff147230ULL, 0x000fe20000004100ULL,
0x000000ff17237812ULL, 0x000fe200078ec0ffULL, 0x20000036ff367230ULL, 0x000fe20000004100ULL,
0x00000018ff167819ULL, 0x000fe40000011617ULL, 0x00000010ff257819ULL, 0x000fc4000001161bULL,
0x0000ffff1b157812ULL, 0x000fe400078ec0ffULL, 0x0000001fff1f723eULL, 0x000fe400020006ffULL,
0x00000034ff34723eULL, 0x000fe400020006ffULL, 0x00000008ff247819ULL, 0x000fe20000011624ULL,
0x2000001fff2d7230ULL, 0x000fe20000004100ULL, 0x000000ff18267812ULL, 0x000fe400078ec0ffULL,
0x00000018ff177819ULL, 0x000fc40000011618ULL, 0x0000ffff182e7812ULL, 0x000fe400078ec0ffULL,
0x00000028ff28723eULL, 0x000fe400020006ffULL, 0x00000010ff187819ULL, 0x000fe4000001161aULL,
0x000000ff1a3c7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff357819ULL, 0x000fe40000011635ULL,
0x0000002bff2b723eULL, 0x000fc400020006ffULL, 0x00000027ff27723eULL, 0x000fe400020006ffULL,
0x00000039ff1a723eULL, 0x000fe200020006ffULL, 0x20000037ff397230ULL, 0x000fe20000004100ULL,
0x000000ff2f2f7812ULL, 0x000fe200078ec0ffULL, 0x20000034ff377230ULL, 0x000fe20000004100ULL,
0x000000ff1b3e7812ULL, 0x000fe200078ec0ffULL, 0x2000001aff1a7230ULL, 0x000fe20000004100ULL,
0x00000018ff3d7819ULL, 0x000fe4000001161bULL, 0x000000ff252a7812ULL, 0x000fe200078ec0ffULL,
0x20000027ff257230ULL, 0x000fe20000004100ULL, 0x00000024ff24723eULL, 0x000fc400020006ffULL,
0x00000008ff157819ULL, 0x000fe40000011615ULL, 0x0000001cff1c723eULL, 0x000fe400020006ffULL,
0x0000003aff1b723eULL, 0x000fe200020006ffULL, 0x20000028ff3a7230ULL, 0x000fe20000004100ULL,
0x0000001eff1e723eULL, 0x000fe200020006ffULL, 0x2000002bff287230ULL, 0x000fe20000004100ULL,
0x00000023ff1d723eULL, 0x000fe200020006ffULL, 0x2000001cff2c7230ULL, 0x000fe20000004100ULL,
0x00000035ff35723eULL, 0x000fe200020006ffULL, 0x2000001eff1c7230ULL, 0x000fe20000004100ULL,
0x00000016ff16723eULL, 0x000fe200020006ffULL, 0x2000001dff1d7230ULL, 0x000fe20000004100ULL,
0x0000002fff34723eULL, 0x000fe200020006ffULL, 0x20000035ff2f7230ULL, 0x000fe20000004100ULL,
0x00000026ff26723eULL, 0x000fe200020006ffULL, 0x20000016ff1f7230ULL, 0x000fe20000004100ULL,
0x0000002aff27723eULL, 0x000fe200020006ffULL, 0x20000024ff2a7230ULL, 0x000fe20000004100ULL,
0x00000015ff2b723eULL, 0x000fe200020006ffULL, 0x20000034ff347230ULL, 0x000fe20000004100ULL,
0x00000008ff2e7819ULL, 0x000fe2000001162eULL, 0x20000026ff167230ULL, 0x000fe20000004100ULL,
0x00000010ff147819ULL, 0x000fe20000011614ULL, 0x2000001bff1b7230ULL, 0x000fe20000004100ULL,
0x00000010ff157819ULL, 0x000fe20000011636ULL, 0x20000027ff277230ULL, 0x000fe20000004100ULL,
0x00000010ff2d7819ULL, 0x000fe2000001162dULL, 0x2000002bff2b7230ULL, 0x000fe20000004100ULL,
0x00000010ff247819ULL, 0x000fc40000011637ULL, 0x00000017ff17723eULL, 0x000fe400020006ffULL,
0x0000002eff2e723eULL, 0x000fe400020006ffULL, 0x0000105415147816ULL, 0x000fe20000000014ULL,
0x20000017ff177230ULL, 0x000fe20000004100ULL, 0x0000003dff26723eULL, 0x000fe200020006ffULL,
0x2000002eff357230ULL, 0x000fe20000004100ULL, 0x0000105424157816ULL, 0x000fe4000000002dULL,
0x000000ff18187812ULL, 0x000fe200078ec0ffULL, 0x20000026ff267230ULL, 0x000fe20000004100ULL,
0x00000010ff3d7819ULL, 0x000fc4000001162cULL, 0x00000010ff247819ULL, 0x000fe40000011619ULL,
0x00000010ff1c7819ULL, 0x000fe4000001161cULL, 0x00000010ff2c7819ULL, 0x000fe4000001161dULL,
0x00000010ff197819ULL, 0x000fe4000001162fULL, 0x00000010ff207819ULL, 0x000fe40000011620ULL,
0x00000010ff1d7819ULL, 0x000fc40000011634ULL, 0x00000010ff2d7819ULL, 0x000fe4000001163aULL,
0x0000003cff1e723eULL, 0x000fe400020006ffULL, 0x00000008ff297819ULL, 0x000fe40000011629ULL,
0x00000018ff18723eULL, 0x000fe200020006ffULL, 0x2000001eff1e7230ULL, 0x000fe20000004100ULL,
0x00000010ff3b7819ULL, 0x000fe4000001163bULL, 0x000010541c197816ULL, 0x000fe20000000019ULL,
0x20000018ff2e7230ULL, 0x000fe20000004100ULL, 0x000010541d1c7816ULL, 0x000fc40000000020ULL,
0x000010542d1d7816ULL, 0x000fe4000000002cULL, 0x00000010ff1f7819ULL, 0x000fe4000001161fULL,
0x00000010ff287819ULL, 0x000fe40000011628ULL, 0x00000029ff29723eULL, 0x000fe400020006ffULL,
0x0000105424207816ULL, 0x000fe4000000003bULL, 0x00000010ff2c7819ULL, 0x000fe20000011617ULL,
0x20000029ff297230ULL, 0x000fe20000004100ULL, 0x00000010ff357819ULL, 0x000fc40000011635ULL,
0x00000010ff247819ULL, 0x000fe40000011616ULL, 0x00000010ff2d7819ULL, 0x000fe20000011621ULL,
0x000000143014723cULL, 0x000fe200000418ffULL, 0x0000003eff23723eULL, 0x000fe400020006ffULL,
0x000010541f217816ULL, 0x000fe40000000028ULL, 0x000010542c287816ULL, 0x000fe20000000035ULL,
0x20000023ff237230ULL, 0x000fe20000004100ULL, 0x000010542d247816ULL, 0x000fc40000000024ULL,
0x00000010ff1f7819ULL, 0x000fe4000001161bULL, 0x00000010ff2c7819ULL, 0x000fe40000011625ULL,
0x00000010ff2d7819ULL, 0x000fe4000001161eULL, 0x00000010ff2e7819ULL, 0x000fe4000001162eULL,
0x000010542c257816ULL, 0x000fe4000000001fULL, 0x00000010ff347819ULL, 0x000fe2000001161aULL,
0x0000001c301c723cULL, 0x000fe200000418ffULL, 0x00000010ff297819ULL, 0x000fc40000011629ULL,
0x000010542e2c7816ULL, 0x000fe4000000002dULL, 0x00000010ff2d7819ULL, 0x000fe40000011622ULL,
0x00000010ff2a7819ULL, 0x000fe4000001162aULL, 0x00000010ff187819ULL, 0x000fe40000011639ULL,
0x00000010ff2e7819ULL, 0x000fe40000011623ULL, 0x00000010ff277819ULL, 0x000fe20000011627ULL,
0x000000203020723cULL, 0x000fe200000418ffULL, 0x00000010ff367819ULL, 0x000fc40000011626ULL,
0x00000010ff2b7819ULL, 0x000fe4000001162bULL, 0x0000105434297816ULL, 0x000fe40000000029ULL,
0x000010542d347816ULL, 0x000fe4000000002aULL, 0x000010543d187816ULL, 0x000fe40000000018ULL,
0x00001054272d7816ULL, 0x000fe4000000002eULL, 0x0000105436357816ULL, 0x000fe2000000002bULL,
0x000000243024723cULL, 0x000fec00000418ffULL, 0x000000183018723cULL, 0x000fec00000418ffULL,
0x000000283028723cULL, 0x000fec00000418ffULL, 0x0000002c302c723cULL, 0x000fec00000418ffULL,
0x000000343030723cULL, 0x000fe200000418ffULL, 0x012800006634783bULL, 0x0004e20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000102947ULL, 0x000fde0003800000ULL,
0x0000000334347232ULL, 0x08afe40000200000ULL, 0x0000000336367232ULL, 0x000fe40000200000ULL,
0x0000000435357232ULL, 0x080fe40000200000ULL, 0x0000000437377232ULL, 0x000fce0000200000ULL,
0x000000ff3800720cULL, 0x000fe20003f45270ULL, 0x00000bd000007945ULL, 0x000fe20003800000ULL,
0x000000006838783bULL, 0x000f240000004200ULL, 0x000000ff383c7812ULL, 0x010fe400078ec0ffULL,
0x000000ff393e7812ULL, 0x000fe400078ec0ffULL, 0x0000003cff3c723eULL, 0x000fe400020006ffULL,
0x00000018ff3d7819ULL, 0x000fc40000011638ULL, 0x0000003eff3f723eULL, 0x000fe200020006ffULL,
0x2000003cff507230ULL, 0x000fe20000004100ULL, 0x0000003dff3e723eULL, 0x000fe400020006ffULL,
0x00000010ff3c7819ULL, 0x000fe20000011638ULL, 0x2000003fff707230ULL, 0x000fe20000004100ULL,
0x00000010ff3d7819ULL, 0x000fe20000011639ULL, 0x2000003eff6c7230ULL, 0x000fe20000004100ULL,
0x0000ffff38387812ULL, 0x000fe400078ec0ffULL, 0x000000ff3d3f7812ULL, 0x000fc400078ec0ffULL,
0x000000ff3c3c7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff3d7819ULL, 0x000fe40000011638ULL,
0x0000003cff38723eULL, 0x000fe400020006ffULL, 0x0000003fff6b723eULL, 0x000fe400020006ffULL,
0x0000003dff51723eULL, 0x000fe200020006ffULL, 0x20000038ff387230ULL, 0x000fe20000004100ULL,
0x00000000673c783bULL, 0x000f220000004200ULL, 0x2000006bff717230ULL, 0x000fe20000004100ULL,
0x00000018ff6d7819ULL, 0x000fe20000011639ULL, 0x20000051ff6b7230ULL, 0x000fe20000004100ULL,
0x0000ffff39727812ULL, 0x000fc400078ec0ffULL, 0x00000010ff507819ULL, 0x000fe40000011650ULL,
0x00000010ff517819ULL, 0x000fe40000011638ULL, 0x0000006dff39723eULL, 0x000fe400020006ffULL,
0x00000010ff707819ULL, 0x000fe40000011670ULL, 0x00000010ff717819ULL, 0x000fe40000011671ULL,
0x00000010ff6d7819ULL, 0x000fc4000001166cULL, 0x00000010ff387819ULL, 0x000fe4000001166bULL,
0x00000008ff727819ULL, 0x000fe40000011672ULL, 0x0000105451507816ULL, 0x000fe40000000050ULL,
0x0000105471517816ULL, 0x000fe40000000070ULL, 0x000010546d387816ULL, 0x000fe40000000038ULL,
0x00000010ff717819ULL, 0x000fc4000001163aULL, 0x000000ff3a6d7812ULL, 0x000fe200078ec0ffULL,
0x000000503414723cULL, 0x008fe20000041814ULL, 0x00000072ff6b723eULL, 0x000fe400020006ffULL,
0x000000ff71717812ULL, 0x000fe400078ec0ffULL, 0x0000006dff73723eULL, 0x000fe200020006ffULL,
0x20000039ff6d7230ULL, 0x000fe20000004100ULL, 0x00000018ff727819ULL, 0x000fe2000001163aULL,
0x2000006bff397230ULL, 0x000fe20000004100ULL, 0x00000071ff71723eULL, 0x000fe200020006ffULL,
0x20000073ff737230ULL, 0x000fe20000004100ULL, 0x00000072ff6b723eULL, 0x000fc400020006ffULL,
0x0000ffff3a6c7812ULL, 0x000fe200078ec0ffULL, 0x20000071ff717230ULL, 0x000fe20000004100ULL,
0x00000010ff727819ULL, 0x000fe2000001166dULL, 0x2000006bff6b7230ULL, 0x000fe20000004100ULL,
0x00000010ff397819ULL, 0x000fe40000011639ULL, 0x00000010ff3a7819ULL, 0x000fe4000001163bULL,
0x0000105472397816ULL, 0x000fe40000000039ULL, 0x000000ff3b747812ULL, 0x000fc400078ec0ffULL,
0x000000ff3a727812ULL, 0x000fe400078ec0ffULL, 0x00000010ff3a7819ULL, 0x000fe20000011673ULL,
0x000000383418723cULL, 0x000fe20000041818ULL, 0x00000010ff717819ULL, 0x000fe40000011671ULL,
0x00000018ff707819ULL, 0x000fe4000001163bULL, 0x00000074ff74723eULL, 0x000fe400020006ffULL,
0x0000ffff3b3b7812ULL, 0x000fc400078ec0ffULL, 0x00001054713a7816ULL, 0x000fe2000000003aULL,
0x20000074ff6d7230ULL, 0x000fe20000004100ULL, 0x00000010ff717819ULL, 0x010fe4000001163cULL,
0x00000008ff6c7819ULL, 0x000fe4000001166cULL, 0x00000008ff3b7819ULL, 0x000fe4000001163bULL,
0x000000ff3c747812ULL, 0x000fe400078ec0ffULL, 0x000000ff71767812ULL, 0x000fc400078ec0ffULL,
0x00000072ff72723eULL, 0x000fe400020006ffULL, 0x00000070ff70723eULL, 0x000fe400020006ffULL,
0x0000006cff6c723eULL, 0x000fe200020006ffULL, 0x20000072ff737230ULL, 0x000fe20000004100ULL,
0x0000003bff75723eULL, 0x000fe200020006ffULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x00000074ff74723eULL, 0x000fe200020006ffULL, 0x2000006cff727230ULL, 0x000fe20000004100ULL,
0x00000076ff76723eULL, 0x000fe200020006ffULL, 0x20000075ff507230ULL, 0x000fe20000004100ULL,
0x00000010ff3b7819ULL, 0x000fe2000001166dULL, 0x20000074ff717230ULL, 0x000fe20000004100ULL,
0x00000010ff747819ULL, 0x000fe20000011673ULL, 0x20000076ff517230ULL, 0x000fe20000004100ULL,
0x00000010ff6b7819ULL, 0x000fc4000001166bULL, 0x00000010ff6d7819ULL, 0x000fe40000011670ULL,
0x00000010ff727819ULL, 0x000fe40000011672ULL, 0x00000010ff387819ULL, 0x000fe40000011650ULL,
0x00000018ff397819ULL, 0x000fe4000001163cULL, 0x00000010ff717819ULL, 0x000fe40000011671ULL,
0x00000010ff707819ULL, 0x000fc40000011651ULL, 0x00001054743b7816ULL, 0x000fe4000000003bULL,
0x000010546b507816ULL, 0x000fe40000000072ULL, 0x000010546d517816ULL, 0x000fe40000000038ULL,
0x00000039ff39723eULL, 0x000fe200020006ffULL, 0x0000003a341c723cULL, 0x000fe2000004181cULL,
0x0000105470387816ULL, 0x000fe40000000071ULL, 0x000000ff3e6b7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff707819ULL, 0x100fe2000001163eULL, 0x000000503420723cULL, 0x000fe20000041820ULL,
0x00000018ff727819ULL, 0x000fe4000001163eULL, 0x0000ffff3e6d7812ULL, 0x000fe400078ec0ffULL,
0x000000ff3f3e7812ULL, 0x000fe400078ec0ffULL, 0x0000006bff73723eULL, 0x000fe200020006ffULL,
0x20000039ff6b7230ULL, 0x000fe20000004100ULL, 0x00000018ff3a7819ULL, 0x000fc4000001163dULL,
0x00000010ff3b7819ULL, 0x000fe4000001163dULL, 0x0000003eff39723eULL, 0x000fe400020006ffULL,
0x000000ff3d6c7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff3c3c7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff757819ULL, 0x000fe4000001163fULL, 0x0000003aff3a723eULL, 0x000fc400020006ffULL,
0x00000072ff74723eULL, 0x000fe400020006ffULL, 0x00000010ff717819ULL, 0x000fe2000001163fULL,
0x2000003aff3e7230ULL, 0x000fe20000004100ULL, 0x000000ff3b727812ULL, 0x000fe200078ec0ffULL,
0x20000039ff3b7230ULL, 0x000fe20000004100ULL, 0x0000006cff6c723eULL, 0x000fe200020006ffULL,
0x20000073ff3a7230ULL, 0x000fe20000004100ULL, 0x0000ffff3d3d7812ULL, 0x000fe400078ec0ffULL,
0x00000075ff75723eULL, 0x000fe200020006ffULL, 0x2000006cff6c7230ULL, 0x000fe20000004100ULL,
0x00000008ff397819ULL, 0x000fe2000001163cULL, 0x20000074ff3c7230ULL, 0x000fe20000004100ULL,
0x000000ff71717812ULL, 0x000fc400078ec0ffULL, 0x0000ffff3f3f7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff737819ULL, 0x000fe2000001163dULL, 0x20000075ff3d7230ULL, 0x000fe20000004100ULL,
0x00000039ff39723eULL, 0x000fe400020006ffULL, 0x000000ff70707812ULL, 0x000fe400078ec0ffULL,
0x00000072ff72723eULL, 0x000fe400020006ffULL, 0x00000071ff75723eULL, 0x000fc400020006ffULL,
0x00000070ff74723eULL, 0x000fe200020006ffULL, 0x20000039ff707230ULL, 0x000fe20000004100ULL,
0x00000008ff6d7819ULL, 0x000fe2000001166dULL, 0x20000072ff727230ULL, 0x000fe20000004100ULL,
0x00000008ff3f7819ULL, 0x000fe2000001163fULL, 0x20000074ff747230ULL, 0x000fe20000004100ULL,
0x00000010ff397819ULL, 0x000fe2000001166cULL, 0x20000075ff6c7230ULL, 0x000fe20000004100ULL,
0x00000073ff73723eULL, 0x000fe400020006ffULL, 0x0000006dff6d723eULL, 0x000fc400020006ffULL,
0x0000003fff75723eULL, 0x000fe200020006ffULL, 0x20000073ff717230ULL, 0x000fe20000004100ULL,
0x00000010ff727819ULL, 0x000fe20000011672ULL, 0x2000006dff6d7230ULL, 0x000fe20000004100ULL,
0x00000010ff3f7819ULL, 0x000fe2000001166bULL, 0x20000075ff6b7230ULL, 0x000fe20000004100ULL,
0x0000105472397816ULL, 0x000fe40000000039ULL, 0x00000010ff727819ULL, 0x000fe4000001163eULL,
0x00000010ff3e7819ULL, 0x000fc40000011670ULL, 0x00000010ff517819ULL, 0x000fe2000001163cULL,
0x000000383424723cULL, 0x000fe20000041824ULL, 0x00000010ff507819ULL, 0x000fe4000001163dULL,
0x00000010ff3a7819ULL, 0x000fe4000001163aULL, 0x00000010ff717819ULL, 0x000fe40000011671ULL,
0x00000010ff737819ULL, 0x000fe40000011674ULL, 0x00000010ff3b7819ULL, 0x000fc4000001163bULL,
0x00000010ff6c7819ULL, 0x000fe4000001166cULL, 0x00000010ff3c7819ULL, 0x000fe4000001166dULL,
0x00000010ff3d7819ULL, 0x000fe4000001166bULL, 0x000010543f3e7816ULL, 0x000fe4000000003eULL,
0x00001054723f7816ULL, 0x000fe40000000071ULL, 0x00001054733a7816ULL, 0x000fc4000000003aULL,
0x000010546c3b7816ULL, 0x000fe4000000003bULL, 0x00001054513c7816ULL, 0x000fe2000000003cULL,
0x0000003e3428723cULL, 0x000fe20000041828ULL, 0x00001054503d7816ULL, 0x000fca000000003dULL,
0x0000003a342c723cULL, 0x000fec000004182cULL, 0x0000003c3430723cULL, 0x000fe20000041830ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000403947ULL, 0x000fde0001000000ULL,
0x000000140b0b7221ULL, 0x000fe20000010000ULL, 0x000000150a0a7221ULL, 0x000fe20000010000ULL,
0x000000180f0f7221ULL, 0x000fe20000010000ULL, 0x000000190e0e7221ULL, 0x000fe20000010000ULL,
0x0000001c41417221ULL, 0x000fe20000010000ULL, 0x0000001d42427221ULL, 0x000fe20000010000ULL,
0x0000002045457221ULL, 0x000fe20000010000ULL, 0x0000002146467221ULL, 0x000fe20000010000ULL,
0x0000002449497221ULL, 0x000fe20000010000ULL, 0x000000254a4a7221ULL, 0x000fe20000010000ULL,
0x000000284d4d7221ULL, 0x000fe20000010000ULL, 0x000000294e4e7221ULL, 0x000fe20000010000ULL,
0x0000002c53537221ULL, 0x000fe20000010000ULL, 0x0000002d54547221ULL, 0x000fe20000010000ULL,
0x0000003057577221ULL, 0x000fe20000010000ULL, 0x0000003158587221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x000000ffff157224ULL, 0x002fc600078e006fULL, 0x0000000000404947ULL, 0x000fea0002800000ULL,
0x000000160d0d7221ULL, 0x000fe20000010000ULL, 0x000000170c0c7221ULL, 0x000fe20000010000ULL,
0x0000001a11117221ULL, 0x000fe20000010000ULL, 0x0000001b40407221ULL, 0x000fe20000010000ULL,
0x0000001e43437221ULL, 0x000fe20000010000ULL, 0x0000001f44447221ULL, 0x000fe20000010000ULL,
0x0000002247477221ULL, 0x000fe20000010000ULL, 0x0000002348487221ULL, 0x000fe20000010000ULL,
0x000000264b4b7221ULL, 0x000fe20000010000ULL, 0x000000274c4c7221ULL, 0x000fe20000010000ULL,
0x0000002a4f4f7221ULL, 0x000fe20000010000ULL, 0x0000002b52527221ULL, 0x000fe20000010000ULL,
0x0000002e55557221ULL, 0x000fe20000010000ULL, 0x0000002f56567221ULL, 0x000fe20000010000ULL,
0x0000003259597221ULL, 0x000fe20000010000ULL, 0x000000335a5a7221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000016a6a7836ULL, 0x000fe40000000000ULL,
0x00000001ff147424ULL, 0x000fc600078e00ffULL, 0x000000696a00720cULL, 0x000fe20003f46070ULL,
0x018b8814ff1c79a7ULL, 0x0002d80008500006ULL, 0xffffffa00074a947ULL, 0x002fea000383ffffULL,
0x00000080040b7891ULL, 0x000fe2000f8e403fULL, 0x018b6014ffff79a7ULL, 0x0003e60008500006ULL,
0x0000000d0b00728cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f4f008ULL,
0x000000bc00382947ULL, 0x002fea0003800000ULL, 0x000000ffff6a7224ULL, 0x000fce00078e00ffULL,
0x00000002ff177819ULL, 0x000fe4000001166aULL, 0x000000036a1a7812ULL, 0x040fe400078ec0ffULL,
0x000000176a177207ULL, 0x000fe40000000000ULL, 0x000000ff1a1a7207ULL, 0x000fc60004000000ULL,
0x0000000217177836ULL, 0x000fca0000000000ULL, 0x00000003171c7812ULL, 0x048fe400078ec0ffULL,
0x00000004171b7c11ULL, 0x004fce000f8ff0ffULL, 0x0000000000187805ULL, 0x000fce0000015200ULL,
0x018b7815ff0075a7ULL, 0x000e640008040146ULL, 0x00000000005c2947ULL, 0x002fea0003800000ULL,
0x000000ffff1e7224ULL, 0x000fce00078e00ffULL, 0x000000101e00780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x00000016181f7210ULL, 0x000fca0007f5e1ffULL, 0x0000000117177824ULL, 0x000fe200010e0e19ULL,
0x003d09001f00780cULL, 0x000fc80003f46070ULL, 0x000000ff1700720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401f00780cULL, 0x000fc80003f46070ULL,
0x000000ff1700720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011417ULL, 0x0000001f14147211ULL, 0x000fca00078510ffULL,
0x000000ffff177224ULL, 0x000fca00010e0617ULL, 0x0000000214147819ULL, 0x000fc80000001217ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011e1e7836ULL, 0x000fce0000000000ULL, 0x018b7815ff0075a7ULL, 0x000e640008040146ULL,
0xfffffffc00a8a947ULL, 0x002fea000383ffffULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x018b881dff0075a7ULL, 0x000e640008040146ULL, 0x00000000005c2947ULL, 0x002fea0003800000ULL,
0x000000ffff187224ULL, 0x000fce00078e00ffULL, 0x000000101800780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614197210ULL, 0x000fca0007f5e1ffULL, 0x0000000117177824ULL, 0x000fe200010e0e15ULL,
0x003d09001900780cULL, 0x000fc80003f46070ULL, 0x000000ff1700720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f46070ULL,
0x000000ff1700720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000001916167211ULL, 0x000fca00078510ffULL,
0x000000ffff177224ULL, 0x000fca00010e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000118187836ULL, 0x000fce0000000000ULL, 0x018b881dff0075a7ULL, 0x000e640008040146ULL,
0xfffffffc00a8a947ULL, 0x002fea000383ffffULL, 0x000000011b147836ULL, 0x000fe20000000000ULL,
0x00000004ff6c7819ULL, 0x000fc80000011610ULL, 0x0000001014007c0cULL, 0x000fda000bf46070ULL,
0x000000040060a947ULL, 0x000fea0003800000ULL, 0x000000015b197824ULL, 0x000fe200078e026cULL,
0x0000002013207811ULL, 0x000fe200078e30ffULL, 0x000000041b167824ULL, 0x000fe200078e021cULL,
0x00016000060b7890ULL, 0x000fe2000fffe03fULL, 0x00000010101d7824ULL, 0x000fe200078e00ffULL,
0x00000006191f7c11ULL, 0x000fe2000f8e10ffULL, 0x000000026c227836ULL, 0x000fe20000000000ULL,
0x0000002016167811ULL, 0x000fe400078e30ffULL, 0x000000f01d217812ULL, 0x000fe200078ec0ffULL,
0x018a00001f147984ULL, 0x000e620000000800ULL, 0x0000000d16177c48ULL, 0x000fe2000ffe0000ULL,
0x000000015b257824ULL, 0x000fc800078e0222ULL, 0x0000000117167824ULL, 0x000fe400078e0a16ULL,
0x0000000119177824ULL, 0x000fe400078e0220ULL, 0x0000000125247824ULL, 0x000fe200078e0210ULL,
0x000000165b167248ULL, 0x000fca0007fe0000ULL, 0x00000001161d7824ULL, 0x000fca00078e0a5bULL,
0x0000001d6c00720cULL, 0x000fe40003f46070ULL, 0x0000000614187c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e680000000a00ULL, 0x018ac00018187984ULL, 0x000ee40000000800ULL,
0x0000000818177c24ULL, 0x008fc4000f8e0217ULL, 0x0000000119187824ULL, 0x000fe400078e0210ULL,
0x0000010017167825ULL, 0x002fc800078e0014ULL, 0x0000001019197824ULL, 0x000fe200078e00ffULL,
0x0000002116167210ULL, 0x000fc80007f7e0ffULL, 0xfffffff019187812ULL, 0x000fe200078ee218ULL,
0x000000ffff177224ULL, 0x000fe400018e0617ULL, 0x0000000125197824ULL, 0x040fe200078e0220ULL,
0x0000000b18237c11ULL, 0x000fe2000f8e20ffULL, 0x0000001025257824ULL, 0x000fc800078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e2000d101c4eULL,
0x0000001d2200720cULL, 0x000fe20003f46070ULL, 0x000000046c227836ULL, 0x000fe20000000000ULL,
0xfffffff025247812ULL, 0x000fe200078ee224ULL, 0x018a08001f187984ULL, 0x000ee40000000800ULL,
0x000000015b257824ULL, 0x000fe200078e0222ULL, 0x0000000b24237c11ULL, 0x002fc6000f8e20ffULL,
0x0000000125247824ULL, 0x000fe200078e0210ULL, 0x00000006181e7c11ULL, 0x008fca000f8e10ffULL,
0x018ac0001e187984ULL, 0x000e640000000800ULL, 0x0000000818197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000002118167210ULL, 0x000fca0007f7e0ffULL,
0x000000ffff177224ULL, 0x000fe400018e0619ULL, 0x0000000125197824ULL, 0x040fe400078e0220ULL,
0x0000001025257824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0003e2000d101c4eULL, 0x0000001d2200720cULL, 0x000fc60003f46070ULL,
0x018a10001f187984ULL, 0x000ee20000000800ULL, 0xfffffff025247812ULL, 0x000fc800078ee224ULL,
0x0000000b24237c11ULL, 0x002fe4000f8e20ffULL, 0x00000006181e7c11ULL, 0x008fca000f8e10ffULL,
0x018ac0001e187984ULL, 0x0002e40000000800ULL, 0x000000066c1e7836ULL, 0x002fc80000000000ULL,
0x000000015b257824ULL, 0x000fe400078e021eULL, 0x0000000818197c24ULL, 0x008fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000002118167210ULL, 0x000fca0007f7e0ffULL,
0x000000ffff177224ULL, 0x000fe400018e0619ULL, 0x0000000125197824ULL, 0x040fe400078e0220ULL,
0x0000000125207824ULL, 0x040fe200078e0210ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0003e2000d101c4eULL, 0x0000001025257824ULL, 0x000fe200078e00ffULL,
0x0000001d1e00720cULL, 0x000fe40003f46070ULL, 0x018a18001f187984ULL, 0x000ee40000000800ULL,
0xfffffff025207812ULL, 0x000fc800078ee220ULL, 0x0000000b20177c11ULL, 0x002fe4000f8e20ffULL,
0x0000000618187c11ULL, 0x008fcc000f8e10ffULL, 0x018ac00018187984ULL, 0x000e640000000800ULL,
0x0000000818197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019147825ULL, 0x000fc600078e0014ULL,
0x0000002114147210ULL, 0x000fca0007f7e0ffULL, 0x000000ffff157224ULL, 0x000fca00018e0615ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e2000d101c4eULL,
0x0000000400287947ULL, 0x000fea0003800000ULL, 0x000000015b1f7824ULL, 0x000fe200078e026cULL,
0x0000002013207811ULL, 0x000fe200078e30ffULL, 0x0000001010197824ULL, 0x000fe200078e00ffULL,
0x00016000060b7890ULL, 0x000fe2000fffe03fULL, 0x000000101f227824ULL, 0x040fe200078e00ffULL,
0x000000061f1e7c11ULL, 0x040fe2000f8e10ffULL, 0x000000011f177824ULL, 0x000fe200078e0220ULL,
0x000000f019217812ULL, 0x000fe200078ec0ffULL, 0x000000011f197824ULL, 0x000fe400078e0210ULL,
0x018a00001e147984ULL, 0x000e620000000800ULL, 0x000000021f257836ULL, 0x000fc40000000000ULL,
0xfffffff022197812ULL, 0x000fe400078ee219ULL, 0x0000000125227824ULL, 0x000fe400078e0210ULL,
0x0000000b19237c11ULL, 0x000fe2000f8e20ffULL, 0x0000000120197824ULL, 0x000fe400078e0225ULL,
0x0000001025257824ULL, 0x000fca00078e00ffULL, 0xfffffff025227812ULL, 0x000fe200078ee222ULL,
0x000000041f257836ULL, 0x000fe40000000000ULL, 0x000000061f1f7836ULL, 0x000fe20000000000ULL,
0x0000000614187c11ULL, 0x002fe4000f8e10ffULL, 0x00008a00ff147b82ULL, 0x000e660000000a00ULL,
0x018ac00018167984ULL, 0x000ee40000000800ULL, 0x0000000816177c24ULL, 0x008fc8000f8e0217ULL,
0x0000010017167825ULL, 0x002fc600078e0014ULL, 0x0000002116167210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff177224ULL, 0x000fca00010e0617ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0003e8000b901c4eULL, 0x018a08001e187984ULL, 0x000ee20000000800ULL,
0x0000000b22237c11ULL, 0x002fe2000f8e20ffULL, 0x0000000120177824ULL, 0x000fe400078e0225ULL,
0x0000000125227824ULL, 0x040fe400078e0210ULL, 0x0000001025257824ULL, 0x000fca00078e00ffULL,
0xfffffff025227812ULL, 0x000fe400078ee222ULL, 0x00000006181d7c11ULL, 0x008fca000f8e10ffULL,
0x018ac0001d187984ULL, 0x000e640000000800ULL, 0x0000000818197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000002118187210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff197224ULL, 0x000fca00010e0619ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018237faeULL, 0x0003e8000b901c4eULL, 0x018a10001e167984ULL, 0x000ee20000000800ULL,
0x0000000b22237c11ULL, 0x002fe2000f8e20ffULL, 0x0000000120197824ULL, 0x000fe400078e021fULL,
0x000000101f207824ULL, 0x000fe200078e00ffULL, 0x00000006161d7c11ULL, 0x008fca000f8e10ffULL,
0x018ac0001d167984ULL, 0x000e640000000800ULL, 0x0000000816177c24ULL, 0x002fc8000f8e0217ULL,
0x0000010017167825ULL, 0x000fc600078e0014ULL, 0x0000002116167210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff177224ULL, 0x000fca00010e0617ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0003e8000b901c4eULL, 0x018a18001e187984ULL, 0x000ee40000000800ULL,
0x0000000618187c11ULL, 0x008fcc000f8e10ffULL, 0x018ac00018187984ULL, 0x000ee40000000800ULL,
0x0000000818197c24ULL, 0x008fc8000f8e0219ULL, 0x0000010019147825ULL, 0x000fc800078e0014ULL,
0x000000011f197824ULL, 0x000fe200078e0210ULL, 0x0000002114147210ULL, 0x000fc80007f5e0ffULL,
0xfffffff020197812ULL, 0x000fe200078ee219ULL, 0x000000ffff157224ULL, 0x000fc600010e0615ULL,
0x0000000b19197c11ULL, 0x000fca000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014197faeULL, 0x0003e4000b901c4eULL, 0x00000001ff147424ULL, 0x002fcc00078e00ffULL,
0x018b8814ff1479a7ULL, 0x000e640008500006ULL, 0x000000ffff187224ULL, 0x002fce00078e0015ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x018b8818ff0075a7ULL, 0x000e640008040146ULL,
0x00000000005c2947ULL, 0x002fea0003800000ULL, 0x000000ffff1d7224ULL, 0x000fce00078e00ffULL,
0x000000101d00780cULL, 0x000fda0003f46270ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x0000001416197210ULL, 0x000fca0007f5e1ffULL,
0x0000000115157824ULL, 0x000fe200010e0e17ULL, 0x003d09001900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x000000000008a947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x00000000001ca947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001914147211ULL, 0x000fca00078510ffULL, 0x000000ffff157224ULL, 0x000fca00010e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011d1d7836ULL, 0x000fce0000000000ULL,
0x018b8818ff0075a7ULL, 0x000e640008040146ULL, 0xfffffffc00a8a947ULL, 0x002fea000383ffffULL,
0x0000001b5c00720cULL, 0x000fe20003f44070ULL, 0x00000001ff1e7424ULL, 0x000fe200078e00ffULL,
0x000000031a00780cULL, 0x000fe20003f65270ULL, 0x000000205f6f7824ULL, 0x000fd800078e0210ULL,
0x00000000004ca947ULL, 0x000fea0001800000ULL, 0x000000036f00780cULL, 0x000fe20003f44070ULL,
0x0000000105057890ULL, 0x000fe2000fffe03fULL, 0x0000010000007945ULL, 0x000ff60003800000ULL,
0x0000000000382947ULL, 0x000fea0003800000ULL, 0x00009000ff177b82ULL, 0x000e620000000800ULL,
0x000000070500728cULL, 0x000fe2000bf06070ULL, 0x0000000412167824ULL, 0x000fe200078e026fULL,
0x000000066f197c11ULL, 0x000fc6000f8e10ffULL, 0x0000000216167824ULL, 0x000fe200078e00ffULL,
0x000000000000781cULL, 0x000fe20003f4f008ULL, 0x00008c00ff147b82ULL, 0x000ee20000000a00ULL,
0x0000000517187c36ULL, 0x002fc80008000000ULL, 0x0000001716177224ULL, 0x000fc800078e0218ULL,
0x0000000417147825ULL, 0x008fca00078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x18ac000014197faeULL, 0x0003e4000d12184eULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000019000007945ULL, 0x000fe80003800000ULL, 0x00000000005c1947ULL, 0x000fea0003800000ULL,
0x0000001b5c00720cULL, 0x000fe20003f44070ULL, 0x000000011a157836ULL, 0x002fe20000000000ULL,
0x00009400000b7ab9ULL, 0x000fe20000000800ULL, 0x000000066f197c11ULL, 0x000fc6000f8e10ffULL,
0x0000000315167812ULL, 0x000fc800078ec0ffULL, 0x000000ff16167207ULL, 0x000fc60005000000ULL,
0x00000002ff15a819ULL, 0x000fe40000011615ULL, 0x000000015d167824ULL, 0x000fc600078e0216ULL,
0x000000011c1c7824ULL, 0x000fe400078e0215ULL, 0x00009200ff147b82ULL, 0x000e640000000a00ULL,
0x000000401c177824ULL, 0x040fe200078e00ffULL, 0x0000001b1c1b7211ULL, 0x000fc800078ff0ffULL,
0x000000c017187812ULL, 0x000fca00078ec0ffULL, 0x000001001b187824ULL, 0x000fc800078e0218ULL,
0x000000016f177824ULL, 0x100fe400078e0218ULL, 0x0000000b16167c24ULL, 0x000fc6000f8e0218ULL,
0x0000000d17007c0cULL, 0x000fe2000bf46070ULL, 0x000000016f177824ULL, 0x000fc800078e0216ULL,
0x0000000417147825ULL, 0x002fd000078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x18a0000014197faeULL, 0x0003e4000d12184eULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a4aULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x018b801eff1479a7ULL, 0x000e620008500006ULL,
0x000000ff6a00720cULL, 0x000fe20003f45270ULL, 0x00000008626d7836ULL, 0x000fe40000000000ULL,
0x000000ffff6b7224ULL, 0x002fd400078e0015ULL, 0x00000004008c2947ULL, 0x000fea0003800000ULL,
0x018b181e5b1479a7ULL, 0x000e640008500006ULL, 0x000000ffff187224ULL, 0x002fce00078e0015ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x018b18185b0075a7ULL, 0x000e640008040146ULL,
0x00000000005c2947ULL, 0x002fea0003800000ULL, 0x000000ffff197224ULL, 0x000fce00078e00ffULL,
0x000000101900780cULL, 0x000fda0003f46270ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x0000001416147210ULL, 0x000fca0007f5e1ffULL,
0x0000000115157824ULL, 0x000fe200010e0e17ULL, 0x003d09001400780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x000000000008a947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401400780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x00000000001ca947ULL, 0x000fea0003800000ULL, 0x0000001fff077819ULL, 0x000fc80000011415ULL,
0x0000001407077211ULL, 0x000fca00078510ffULL, 0x000000ffff147224ULL, 0x000fca00010e0615ULL,
0x0000000207077819ULL, 0x000fc80000001214ULL, 0x000000070000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000119197836ULL, 0x000fce0000000000ULL,
0x018b18185b0075a7ULL, 0x000e640008040146ULL, 0xfffffffc00a8a947ULL, 0x002fea000383ffffULL,
0x0000001010077824ULL, 0x000fe200078e00ffULL, 0x00000001ff147819ULL, 0x000fe20000011610ULL,
0x000000ffff167224ULL, 0x000fc600078e0008ULL, 0x0000007007077812ULL, 0x000fe400078ec0ffULL,
0x0000000c14147812ULL, 0x000fc800078ec0ffULL, 0x00000006141b7c10ULL, 0x000fca000fffe007ULL,
0x018100001b157984ULL, 0x000e680000000800ULL, 0x018300001b147984ULL, 0x0006e20000000800ULL,
0x000000081500720bULL, 0x002fda0003f5d000ULL, 0x0000000000077806ULL, 0x000fc800010e0100ULL,
0x0000ffff07187812ULL, 0x000fe2000784c0ffULL, 0x00000001ff077424ULL, 0x000fd800078e00ffULL,
0x0000000000e0a947ULL, 0x00cfea0003800000ULL, 0x000000081500720bULL, 0x000fe40003f54000ULL,
0x000000025f00780cULL, 0x000fe40003f65270ULL, 0x0000001508167209ULL, 0x000fd20007810000ULL,
0x0000000000197806ULL, 0x000fe400010e0100ULL, 0x018500161b00b388ULL, 0x0003e40000000800ULL,
0x0000991019177816ULL, 0x000fc800000000ffULL, 0x000000ff1700720cULL, 0x000fda0003f45270ULL,
0x0000000000a8a947ULL, 0x002fea0003800000ULL, 0x8000001608087221ULL, 0x000fe20000010000ULL,
0x000000ff19ff7812ULL, 0x040fe4000784c0ffULL, 0x0000ff0019ff7812ULL, 0x000fe2000786c0ffULL,
0x3fb8aa3b08087820ULL, 0x000fc80000410000ULL, 0x00000008001a7308ULL, 0x0002ac0000000800ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x00001f621a087589ULL, 0x006e6400000e0000ULL,
0x000000080b0b7220ULL, 0x082fe20000410000ULL, 0x000000080a0a7220ULL, 0x080fe20000410000ULL,
0x000000080f0f7220ULL, 0x080fe20000410000ULL, 0x000000080e0e7220ULL, 0x080fe20000410000ULL,
0x0000000841417220ULL, 0x080fe20000410000ULL, 0x0000000842427220ULL, 0x080fe20000410000ULL,
0x0000000845457220ULL, 0x080fe20000410000ULL, 0x0000000846467220ULL, 0x080fe20000410000ULL,
0x0000000849497220ULL, 0x080fe20000410000ULL, 0x000000084a4a7220ULL, 0x080fe20000410000ULL,
0x000000084d4d7220ULL, 0x080fe20000410000ULL, 0x000000084e4e7220ULL, 0x080fe20000410000ULL,
0x0000000853537220ULL, 0x080fe20000410000ULL, 0x0000000854547220ULL, 0x080fe20000410000ULL,
0x0000000857577220ULL, 0x080fe20000410000ULL, 0x0000000858587220ULL, 0x000fce0000410000ULL,
0x0000001a09097220ULL, 0x004fe20000410000ULL, 0x000000000044b947ULL, 0x000fec0003800000ULL,
0x00001f6d1a087589ULL, 0x002e6400000e0000ULL, 0x000000080d0d7220ULL, 0x082fe20000410000ULL,
0x000000080c0c7220ULL, 0x080fe20000410000ULL, 0x0000000811117220ULL, 0x080fe20000410000ULL,
0x0000000840407220ULL, 0x080fe20000410000ULL, 0x0000000843437220ULL, 0x080fe20000410000ULL,
0x0000000844447220ULL, 0x080fe20000410000ULL, 0x0000000847477220ULL, 0x080fe20000410000ULL,
0x0000000848487220ULL, 0x080fe20000410000ULL, 0x000000084b4b7220ULL, 0x080fe20000410000ULL,
0x000000084c4c7220ULL, 0x080fe20000410000ULL, 0x000000084f4f7220ULL, 0x080fe20000410000ULL,
0x0000000852527220ULL, 0x080fe20000410000ULL, 0x0000000855557220ULL, 0x080fe20000410000ULL,
0x0000000856567220ULL, 0x080fe20000410000ULL, 0x0000000859597220ULL, 0x080fe20000410000ULL,
0x000000085a5a7220ULL, 0x000fce0000410000ULL, 0x0000ffff18ff7812ULL, 0x000fda0007846019ULL,
0x8000001615152221ULL, 0x000fe20000010000ULL, 0x00007610ff072816ULL, 0x000fc60000000007ULL,
0x3fb8aa3b15152820ULL, 0x000fc80000410000ULL, 0x0000001500062308ULL, 0x000ea40000000800ULL,
0x0000000614142220ULL, 0x004fce0000410000ULL, 0x0000000914097221ULL, 0x000fe20000010000ULL,
0x000000ffff087224ULL, 0x002fce00078e0016ULL, 0x000000ff07ff7812ULL, 0x000fda000784c0ffULL,
0x0000000000102947ULL, 0x000fea0003800000ULL, 0x00000006ff03723eULL, 0x000fc800000010ffULL,
0x0000541003147816ULL, 0x000fca0000000003ULL, 0x00001f6214037589ULL, 0x0002e800000e0000ULL,
0x00001f6d14047589ULL, 0x0002a400000e0000ULL, 0x01300000051c783bULL, 0x0002e20000000200ULL,
0x0000000000102947ULL, 0x000fea0003800000ULL, 0x000000031c1c7232ULL, 0x088fe40000200000ULL,
0x000000031e1e7232ULL, 0x000fe40000200000ULL, 0x000000041d1d7232ULL, 0x084fe40000200000ULL,
0x000000041f1f7232ULL, 0x000fce0000200000ULL, 0x000000000214783bULL, 0x002e680000004200ULL,
0x000000000018783bULL, 0x000f220000004200ULL, 0x00000018ff207819ULL, 0x002fe40000011614ULL,
0x0000ffff15347812ULL, 0x000fe400078ec0ffULL, 0x00000020ff20723eULL, 0x000fe400020006ffULL,
0x000000ff18387812ULL, 0x010fc400078ec0ffULL, 0x0000ffff162e7812ULL, 0x000fe200078ec0ffULL,
0x20000020ff2b7230ULL, 0x000fe20000004100ULL, 0x00000010ff377819ULL, 0x000fe40000011614ULL,
0x00000038ff20723eULL, 0x000fe400020006ffULL, 0x00000010ff337819ULL, 0x000fe40000011616ULL,
0x00000008ff387819ULL, 0x000fe20000011634ULL, 0x20000020ff207230ULL, 0x000fe20000004100ULL,
0x00000008ff2e7819ULL, 0x000fc4000001162eULL, 0x000000ff37377812ULL, 0x000fe400078ec0ffULL,
0x00000010ff357819ULL, 0x100fe40000011615ULL, 0x000000ff15237812ULL, 0x000fe400078ec0ffULL,
0x00000018ff227819ULL, 0x000fe40000011615ULL, 0x00000038ff38723eULL, 0x000fe400020006ffULL,
0x000000ff33337812ULL, 0x000fc400078ec0ffULL, 0x000000ff16247812ULL, 0x000fe400078ec0ffULL,
0x00000018ff157819ULL, 0x000fe40000011616ULL, 0x00000010ff2f7819ULL, 0x100fe40000011617ULL,
0x000000ff19397812ULL, 0x000fe400078ec0ffULL, 0x000000ff17257812ULL, 0x000fe400078ec0ffULL,
0x00000018ff167819ULL, 0x000fc40000011617ULL, 0x0000ffff17307812ULL, 0x000fe400078ec0ffULL,
0x00000010ff317819ULL, 0x100fe40000011618ULL, 0x0000002eff2e723eULL, 0x000fe400020006ffULL,
0x00000018ff177819ULL, 0x000fe40000011618ULL, 0x0000ffff18327812ULL, 0x000fe400078ec0ffULL,
0x00000037ff34723eULL, 0x000fc400020006ffULL, 0x00000010ff297819ULL, 0x100fe40000011619ULL,
0x00000018ff187819ULL, 0x000fe20000011619ULL, 0x20000034ff347230ULL, 0x000fe20000004100ULL,
0x0000ffff192d7812ULL, 0x000fe400078ec0ffULL, 0x00000033ff37723eULL, 0x000fe200020006ffULL,
0x20000038ff337230ULL, 0x000fe20000004100ULL, 0x00000010ff287819ULL, 0x000fe4000001161aULL,
0x00000023ff23723eULL, 0x000fc400020006ffULL, 0x00000039ff19723eULL, 0x000fe400020006ffULL,
0x000000ff2f2f7812ULL, 0x000fe200078ec0ffULL, 0x20000023ff2c7230ULL, 0x000fe20000004100ULL,
0x00000015ff15723eULL, 0x000fe200020006ffULL, 0x20000019ff197230ULL, 0x000fe20000004100ULL,
0x00000008ff387819ULL, 0x000fe20000011630ULL, 0x20000037ff307230ULL, 0x000fe20000004100ULL,
0x000000ff31397812ULL, 0x000fe200078ec0ffULL, 0x2000002eff317230ULL, 0x000fe20000004100ULL,
0x000000ff14217812ULL, 0x000fe200078ec0ffULL, 0x20000015ff237230ULL, 0x000fe20000004100ULL,
0x00000018ff3a7819ULL, 0x000fc4000001161aULL, 0x00000010ff2a7819ULL, 0x000fe4000001161bULL,
0x00000008ff2e7819ULL, 0x000fe4000001162dULL, 0x0000ffff14367812ULL, 0x000fe400078ec0ffULL,
0x0000002fff2f723eULL, 0x000fe400020006ffULL, 0x000000ff28287812ULL, 0x000fe400078ec0ffULL,
0x000000ff1b3c7812ULL, 0x000fe200078ec0ffULL, 0x2000002fff377230ULL, 0x000fe20000004100ULL,
0x00000018ff147819ULL, 0x000fc4000001161bULL, 0x00000038ff38723eULL, 0x000fe400020006ffULL,
0x00000021ff21723eULL, 0x000fe400020006ffULL, 0x0000ffff1b1b7812ULL, 0x000fe200078ec0ffULL,
0x20000038ff2f7230ULL, 0x000fe20000004100ULL, 0x0000003aff15723eULL, 0x000fe200020006ffULL,
0x20000021ff277230ULL, 0x000fe20000004100ULL, 0x0000002eff2e723eULL, 0x000fe400020006ffULL,
0x000000ff2a2a7812ULL, 0x000fe200078ec0ffULL, 0x20000015ff157230ULL, 0x000fe20000004100ULL,
0x00000022ff22723eULL, 0x000fc400020006ffULL, 0x00000008ff3a7819ULL, 0x000fe40000011632ULL,
0x00000028ff28723eULL, 0x000fe400020006ffULL, 0x00000016ff16723eULL, 0x000fe400020006ffULL,
0x00000039ff32723eULL, 0x000fe400020006ffULL, 0x00000008ff397819ULL, 0x000fe4000001161bULL,
0x000000ff35357812ULL, 0x000fe200078ec0ffULL, 0x20000032ff327230ULL, 0x000fe20000004100ULL,
0x0000002aff38723eULL, 0x000fe200020006ffULL, 0x2000002eff2a7230ULL, 0x000fe20000004100ULL,
0x00000024ff26723eULL, 0x000fe200020006ffULL, 0x20000022ff247230ULL, 0x000fe20000004100ULL,
0x00000035ff35723eULL, 0x000fe200020006ffULL, 0x20000028ff2e7230ULL, 0x000fe20000004100ULL,
0x00000039ff28723eULL, 0x000fe200020006ffULL, 0x20000016ff227230ULL, 0x000fe20000004100ULL,
0x0000003cff16723eULL, 0x000fe200020006ffULL, 0x20000026ff267230ULL, 0x000fe20000004100ULL,
0x00000010ff397819ULL, 0x000fe2000001162bULL, 0x20000035ff357230ULL, 0x000fe20000004100ULL,
0x00000010ff3c7819ULL, 0x000fe20000011627ULL, 0x20000028ff277230ULL, 0x000fe20000004100ULL,
0x00000010ff2b7819ULL, 0x000fe20000011634ULL, 0x20000016ff167230ULL, 0x000fe20000004100ULL,
0x00000025ff25723eULL, 0x000fc400020006ffULL, 0x00000017ff17723eULL, 0x000fe400020006ffULL,
0x000000ff1a3b7812ULL, 0x040fe200078ec0ffULL, 0x20000025ff257230ULL, 0x000fe20000004100ULL,
0x0000ffff1a1a7812ULL, 0x000fe200078ec0ffULL, 0x20000017ff217230ULL, 0x000fe20000004100ULL,
0x000000ff29297812ULL, 0x000fe400078ec0ffULL, 0x000010542b3c7816ULL, 0x000fe4000000003cULL,
0x00000010ff2b7819ULL, 0x000fc40000011623ULL, 0x00000010ff267819ULL, 0x000fe40000011626ULL,
0x00000010ff237819ULL, 0x000fe40000011630ULL, 0x00000018ff18723eULL, 0x000fe400020006ffULL,
0x00000029ff29723eULL, 0x000fe400020006ffULL, 0x00000008ff1a7819ULL, 0x000fe2000001161aULL,
0x20000018ff187230ULL, 0x000fe20000004100ULL, 0x00000008ff367819ULL, 0x000fe20000011636ULL,
0x20000029ff297230ULL, 0x000fe20000004100ULL, 0x00000010ff2c7819ULL, 0x000fc4000001162cULL,
0x00000010ff357819ULL, 0x000fe40000011635ULL, 0x0000105423307816ULL, 0x000fe40000000026ULL,
0x00000010ff257819ULL, 0x000fe40000011625ULL, 0x00000010ff287819ULL, 0x000fe40000011637ULL,
0x00000010ff237819ULL, 0x000fe40000011621ULL, 0x0000001aff1a723eULL, 0x000fc400020006ffULL,
0x00000010ff207819ULL, 0x000fe40000011620ULL, 0x00000010ff217819ULL, 0x000fe20000011632ULL,
0x2000001aff1b7230ULL, 0x000fe20000004100ULL, 0x0000003bff17723eULL, 0x000fe200020006ffULL,
0x20000038ff1a7230ULL, 0x000fe20000004100ULL, 0x00000036ff36723eULL, 0x000fe400020006ffULL,
0x0000003aff3a723eULL, 0x000fe200020006ffULL, 0x20000017ff177230ULL, 0x000fe20000004100ULL,
0x00001054353d7816ULL, 0x000fe2000000002cULL, 0x20000036ff367230ULL, 0x000fe20000004100ULL,
0x00000014ff14723eULL, 0x000fe200020006ffULL, 0x2000003aff2d7230ULL, 0x000fe20000004100ULL,
0x00000010ff2c7819ULL, 0x000fc40000011631ULL, 0x0000105428317816ULL, 0x000fe20000000025ULL,
0x20000014ff147230ULL, 0x000fe20000004100ULL, 0x0000105421287816ULL, 0x000fe20000000020ULL,
0x0000003c1c3c723cULL, 0x008fe200000418ffULL, 0x00000010ff207819ULL, 0x000fe40000011618ULL,
0x00000010ff247819ULL, 0x000fe40000011624ULL, 0x00000010ff337819ULL, 0x000fe40000011633ULL,
0x00000010ff197819ULL, 0x000fc40000011619ULL, 0x00000010ff187819ULL, 0x000fe40000011629ULL,
0x0000105424357816ULL, 0x000fe40000000033ULL, 0x00000010ff257819ULL, 0x000fe2000001162aULL,
0x000000301c30723cULL, 0x000fe200000418ffULL, 0x0000105418297816ULL, 0x000fe40000000019ULL,
0x00000010ff347819ULL, 0x000fe40000011636ULL, 0x00000010ff227819ULL, 0x000fc40000011622ULL,
0x00000010ff2f7819ULL, 0x000fe4000001162fULL, 0x00000010ff247819ULL, 0x000fe4000001162dULL,
0x00000010ff177819ULL, 0x000fe40000011617ULL, 0x00000010ff2e7819ULL, 0x000fe4000001162eULL,
0x00000010ff187819ULL, 0x000fe40000011615ULL, 0x00000010ff167819ULL, 0x000fc40000011616ULL,
0x00000010ff217819ULL, 0x000fe4000001161aULL, 0x00000010ff1b7819ULL, 0x000fe4000001161bULL,
0x00000010ff1a7819ULL, 0x000fe40000011614ULL, 0x00000010ff157819ULL, 0x000fe40000011627ULL,
0x0000105420257816ULL, 0x000fe40000000025ULL, 0x0000105439347816ULL, 0x000fc40000000034ULL,
0x000010542b2c7816ULL, 0x000fe4000000002cULL, 0x00001054222d7816ULL, 0x000fe2000000002fULL,
0x000000281c28723cULL, 0x000fe200000418ffULL, 0x0000105423247816ULL, 0x000fe40000000024ULL,
0x000010542e207816ULL, 0x000fe40000000017ULL, 0x0000105421217816ULL, 0x000fe20000000016ULL,
0x000000341c34723cULL, 0x000fe200000418ffULL, 0x0000105418147816ULL, 0x000fc4000000001bULL,
0x000010541a157816ULL, 0x000fe40000000015ULL, 0x013000005e18783bULL, 0x0002e20000000200ULL,
0x0000002c1c2c723cULL, 0x000fec00000418ffULL, 0x000000241c24723cULL, 0x000fec00000418ffULL,
0x000000201c20723cULL, 0x000fec00000418ffULL, 0x000000141c1c723cULL, 0x000fe200000418ffULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000102947ULL, 0x002fde0003800000ULL,
0x0000000318187232ULL, 0x088fe40000200000ULL, 0x000000031a1a7232ULL, 0x000fe40000200000ULL,
0x0000000419197232ULL, 0x084fe40000200000ULL, 0x000000041b1b7232ULL, 0x000fce0000200000ULL,
0x000000006014783bULL, 0x000e620000004200ULL, 0x0000006a6200720cULL, 0x080fe20003f66070ULL,
0x00000c3000007945ULL, 0x000fe20003800000ULL, 0x000000045c007c0cULL, 0x040fe4000bfc3070ULL,
0x0000006a6d00720cULL, 0x000fe40003f86070ULL, 0x000000045c007c0cULL, 0x000fe4000bfa3070ULL,
0x000000ff14397812ULL, 0x002fe400078ec0ffULL, 0x00000010ff387819ULL, 0x000fc40000011614ULL,
0x00000039ff39723eULL, 0x000fe400020006ffULL, 0x00000010ff3a7819ULL, 0x000fe40000011615ULL,
0x000000ff153b7812ULL, 0x000fe200078ec0ffULL, 0x20000039ff507230ULL, 0x000fe20000004100ULL,
0x000000ff38387812ULL, 0x000fe400078ec0ffULL, 0x000000ff3a3a7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff14397812ULL, 0x000fc400078ec0ffULL, 0x0000003bff3b723eULL, 0x000fe400020006ffULL,
0x00000038ff38723eULL, 0x000fe400020006ffULL, 0x0000003aff3a723eULL, 0x000fe200020006ffULL,
0x2000003bff707230ULL, 0x000fe20000004100ULL, 0x00000018ff147819ULL, 0x000fe20000011614ULL,
0x20000038ff517230ULL, 0x000fe20000004100ULL, 0x00000008ff397819ULL, 0x000fe20000011639ULL,
0x2000003aff717230ULL, 0x000fe20000004100ULL, 0x00000014ff6e723eULL, 0x000fc400020006ffULL,
0x00000039ff14723eULL, 0x000fe400020006ffULL, 0x000000006138783bULL, 0x000e620000004200ULL,
0x00000010ff507819ULL, 0x000fe20000011650ULL, 0x2000006eff6e7230ULL, 0x000fe20000004100ULL,
0x00000010ff517819ULL, 0x000fe20000011651ULL, 0x20000014ff147230ULL, 0x000fe20000004100ULL,
0x00000010ff707819ULL, 0x000fe40000011670ULL, 0x00000010ff717819ULL, 0x000fe40000011671ULL,
0x0000105451507816ULL, 0x000fc40000000050ULL, 0x0000105471517816ULL, 0x000fe40000000070ULL,
0x00000018ff707819ULL, 0x000fe40000011615ULL, 0x000000ff16727812ULL, 0x000fe400078ec0ffULL,
0x00000070ff70723eULL, 0x000fe200020006ffULL, 0x00000050183c723cULL, 0x008fe2000004183cULL,
0x00000010ff717819ULL, 0x000fe4000001166eULL, 0x00000010ff147819ULL, 0x000fc40000011614ULL,
0x000000ff17747812ULL, 0x000fe400078ec0ffULL, 0x0000ffff15507812ULL, 0x000fe400078ec0ffULL,
0x00000010ff517819ULL, 0x000fe40000011616ULL, 0x00000008ff507819ULL, 0x000fe40000011650ULL,
0x00000072ff6e723eULL, 0x000fe200020006ffULL, 0x20000070ff727230ULL, 0x000fe20000004100ULL,
0x00000050ff50723eULL, 0x000fc400020006ffULL, 0x0000105471147816ULL, 0x000fe20000000014ULL,
0x2000006eff6e7230ULL, 0x000fe20000004100ULL, 0x00000018ff737819ULL, 0x000fe20000011616ULL,
0x20000050ff707230ULL, 0x000fe20000004100ULL, 0x00000074ff75723eULL, 0x000fe400020006ffULL,
0x00000010ff717819ULL, 0x000fe40000011617ULL, 0x000000ff51747812ULL, 0x000fe200078ec0ffULL,
0x20000075ff507230ULL, 0x000fe20000004100ULL, 0x00000073ff51723eULL, 0x000fc400020006ffULL,
0x00000018ff157819ULL, 0x000fe40000011617ULL, 0x00000074ff74723eULL, 0x000fe200020006ffULL,
0x20000051ff517230ULL, 0x000fe20000004100ULL, 0x000000ff71737812ULL, 0x000fe400078ec0ffULL,
0x00000010ff727819ULL, 0x000fe20000011672ULL, 0x20000074ff747230ULL, 0x000fe20000004100ULL,
0x00000010ff717819ULL, 0x000fe40000011670ULL, 0x00000015ff70723eULL, 0x000fc400020006ffULL,
0x0000105472157816ULL, 0x000fe40000000071ULL, 0x000000ff38727812ULL, 0x002fe200078ec0ffULL,
0x20000070ff707230ULL, 0x000fe20000004100ULL, 0x0000ffff16167812ULL, 0x000fe400078ec0ffULL,
0x0000ffff17177812ULL, 0x000fe200078ec0ffULL, 0x000000141834723cULL, 0x000fe20000041834ULL,
0x00000010ff717819ULL, 0x000fe4000001166eULL, 0x00000010ff747819ULL, 0x000fc40000011674ULL,
0x00000072ff6e723eULL, 0x000fe400020006ffULL, 0x00000008ff727819ULL, 0x000fe40000011616ULL,
0x00000008ff177819ULL, 0x000fe20000011617ULL, 0x2000006eff6e7230ULL, 0x000fe20000004100ULL,
0x0000105474167816ULL, 0x000fe40000000071ULL, 0x00000072ff72723eULL, 0x000fe400020006ffULL,
0x00000017ff71723eULL, 0x000fc400020006ffULL, 0x00000073ff73723eULL, 0x000fe200020006ffULL,
0x20000072ff727230ULL, 0x000fe20000004100ULL, 0x00000010ff747819ULL, 0x000fe20000011638ULL,
0x20000071ff717230ULL, 0x000fe20000004100ULL, 0x00000010ff517819ULL, 0x000fe20000011651ULL,
0x20000073ff737230ULL, 0x000fe20000004100ULL, 0x00000010ff707819ULL, 0x000fe40000011670ULL,
0x00000010ff147819ULL, 0x000fe40000011672ULL, 0x00000010ff157819ULL, 0x000fc40000011671ULL,
0x000000ff74757812ULL, 0x000fe400078ec0ffULL, 0x00000010ff177819ULL, 0x000fe40000011650ULL,
0x00000010ff747819ULL, 0x000fe40000011673ULL, 0x0000105451147816ULL, 0x000fe40000000014ULL,
0x0000105470157816ULL, 0x000fe40000000015ULL, 0x0000105474177816ULL, 0x000fc40000000017ULL,
0x00000018ff717819ULL, 0x000fe40000011638ULL, 0x0000ffff38737812ULL, 0x000fe200078ec0ffULL,
0x00000014182c723cULL, 0x000fe2000004182cULL, 0x000000ff3a387812ULL, 0x000fe400078ec0ffULL,
0x00000075ff50723eULL, 0x000fe400020006ffULL, 0x00000010ff707819ULL, 0x100fe2000001163aULL,
0x000000161830723cULL, 0x000fe20000041830ULL, 0x00000018ff147819ULL, 0x000fe20000011639ULL,
0x20000050ff507230ULL, 0x000fe20000004100ULL, 0x00000018ff747819ULL, 0x000fc4000001163aULL,
0x00000014ff14723eULL, 0x000fe400020006ffULL, 0x00000010ff167819ULL, 0x000fe4000001166eULL,
0x0000ffff3a6e7812ULL, 0x000fe400078ec0ffULL, 0x00000038ff3a723eULL, 0x000fe200020006ffULL,
0x20000014ff387230ULL, 0x000fe20000004100ULL, 0x00000010ff157819ULL, 0x000fe40000011639ULL,
0x00000071ff71723eULL, 0x000fe200020006ffULL, 0x2000003aff147230ULL, 0x000fe20000004100ULL,
0x000000ff39517812ULL, 0x000fc400078ec0ffULL, 0x0000ffff39727812ULL, 0x000fe200078ec0ffULL,
0x20000071ff397230ULL, 0x000fe20000004100ULL, 0x00000074ff74723eULL, 0x000fe400020006ffULL,
0x000000ff153a7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff737819ULL, 0x000fe40000011673ULL,
0x00000010ff177819ULL, 0x000fe40000011650ULL, 0x00000051ff51723eULL, 0x000fc400020006ffULL,
0x0000003aff71723eULL, 0x000fe200020006ffULL, 0x20000074ff3a7230ULL, 0x000fe20000004100ULL,
0x00000008ff727819ULL, 0x000fe20000011672ULL, 0x20000051ff517230ULL, 0x000fe20000004100ULL,
0x00000073ff73723eULL, 0x000fe400020006ffULL, 0x000000ff70747812ULL, 0x000fe400078ec0ffULL,
0x0000105417167816ULL, 0x000fe40000000016ULL, 0x0000ffff3b177812ULL, 0x000fc400078ec0ffULL,
0x00000072ff70723eULL, 0x000fe200020006ffULL, 0x20000071ff727230ULL, 0x000fe20000004100ULL,
0x00000074ff74723eULL, 0x000fe400020006ffULL, 0x00000008ff717819ULL, 0x000fe2000001166eULL,
0x20000073ff6e7230ULL, 0x000fe20000004100ULL, 0x00000008ff737819ULL, 0x000fe20000011617ULL,
0x20000070ff707230ULL, 0x000fe20000004100ULL, 0x00000010ff177819ULL, 0x000fe20000011651ULL,
0x20000074ff517230ULL, 0x000fe20000004100ULL, 0x00000073ff74723eULL, 0x000fc400020006ffULL,
0x00000010ff737819ULL, 0x000fe40000011638ULL, 0x00000010ff507819ULL, 0x000fe4000001163bULL,
0x00000010ff397819ULL, 0x000fe40000011639ULL, 0x00000010ff387819ULL, 0x000fe2000001166eULL,
0x20000074ff6e7230ULL, 0x000fe20000004100ULL, 0x00000010ff707819ULL, 0x000fe40000011670ULL,
0x000000ff3b767812ULL, 0x000fc400078ec0ffULL, 0x000000ff50507812ULL, 0x000fe400078ec0ffULL,
0x0000105439387816ULL, 0x000fe40000000038ULL, 0x00000018ff757819ULL, 0x000fe4000001163bULL,
0x0000105473397816ULL, 0x000fe40000000070ULL, 0x00000076ff76723eULL, 0x000fe400020006ffULL,
0x00000050ff50723eULL, 0x000fc400020006ffULL, 0x00000075ff3b723eULL, 0x000fe200020006ffULL,
0x000000381824723cULL, 0x000fe20000041824ULL, 0x00000071ff71723eULL, 0x000fe200020006ffULL,
0x20000076ff157230ULL, 0x000fe20000004100ULL, 0x00000010ff727819ULL, 0x000fe20000011672ULL,
0x20000050ff507230ULL, 0x000fe20000004100ULL, 0x00000010ff147819ULL, 0x000fe20000011614ULL,
0x2000003bff3b7230ULL, 0x000fe20000004100ULL, 0x0000105472177816ULL, 0x000fe20000000017ULL,
0x000000016a387836ULL, 0x000fe20000000000ULL, 0x00000010ff157819ULL, 0x000fe20000011615ULL,
0x20000071ff717230ULL, 0x000fe20000004100ULL, 0x00000010ff517819ULL, 0x000fc40000011651ULL,
0x00000010ff507819ULL, 0x000fe20000011650ULL, 0x000000161828723cULL, 0x000fe20000041828ULL,
0x000000386200720cULL, 0x000fe40005f66470ULL, 0x00000010ff3a7819ULL, 0x000fe4000001163aULL,
0x00000010ff3b7819ULL, 0x000fe4000001163bULL, 0x00000010ff717819ULL, 0x000fe40000011671ULL,
0x00000010ff6e7819ULL, 0x000fc4000001166eULL, 0x0000105451167816ULL, 0x000fe40000000014ULL,
0x0000105450177816ULL, 0x000fe40000000015ULL, 0x000010543a147816ULL, 0x000fe40000000071ULL,
0x000010543b157816ULL, 0x000fe4000000006eULL, 0x000000386d00720cULL, 0x000fe20006786470ULL,
0x000000161820723cULL, 0x000fec0000041820ULL, 0x00000014181c723cULL, 0x000fe2000004181cULL,
0x00000001ff167424ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000403947ULL, 0x000fde0003000000ULL, 0x0000003c0b0b7221ULL, 0x000fe20000010000ULL,
0x0000003d0a0a7221ULL, 0x000fe20000010000ULL, 0x000000340f0f7221ULL, 0x000fe20000010000ULL,
0x000000350e0e7221ULL, 0x000fe20000010000ULL, 0x0000003041417221ULL, 0x000fe20000010000ULL,
0x0000003142427221ULL, 0x000fe20000010000ULL, 0x0000002c45457221ULL, 0x000fe20000010000ULL,
0x0000002d46467221ULL, 0x000fe20000010000ULL, 0x0000002849497221ULL, 0x000fe20000010000ULL,
0x000000294a4a7221ULL, 0x000fe20000010000ULL, 0x000000244d4d7221ULL, 0x000fe20000010000ULL,
0x000000254e4e7221ULL, 0x000fe20000010000ULL, 0x0000002053537221ULL, 0x000fe20000010000ULL,
0x0000002154547221ULL, 0x000fe20000010000ULL, 0x0000001c57577221ULL, 0x000fe20000010000ULL,
0x0000001d58587221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000012000007945ULL, 0x000fe80003800000ULL, 0x0000000000404947ULL, 0x000fea0002800000ULL,
0x0000003e0d0d7221ULL, 0x000fe20000010000ULL, 0x0000003f0c0c7221ULL, 0x000fe20000010000ULL,
0x0000003611117221ULL, 0x000fe20000010000ULL, 0x0000003740407221ULL, 0x000fe20000010000ULL,
0x0000003243437221ULL, 0x000fe20000010000ULL, 0x0000003344447221ULL, 0x000fe20000010000ULL,
0x0000002e47477221ULL, 0x000fe20000010000ULL, 0x0000002f48487221ULL, 0x000fe20000010000ULL,
0x0000002a4b4b7221ULL, 0x000fe20000010000ULL, 0x0000002b4c4c7221ULL, 0x000fe20000010000ULL,
0x000000264f4f7221ULL, 0x000fe20000010000ULL, 0x0000002752527221ULL, 0x000fe20000010000ULL,
0x0000002255557221ULL, 0x000fe20000010000ULL, 0x0000002356567221ULL, 0x000fe20000010000ULL,
0x0000001e59597221ULL, 0x000fe20000010000ULL, 0x0000001f5a5a7221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x018b8816ff1479a7ULL, 0x000e620008500006ULL,
0x00000002ff177819ULL, 0x000fe40000011638ULL, 0x000000045c007c0cULL, 0x000fe4000bfc3070ULL,
0x0000001738177207ULL, 0x040fe40000000000ULL, 0x00000003381a7812ULL, 0x000fe400078ec0ffULL,
0x000000045c007c0cULL, 0x000fe2000bfa3070ULL, 0x0000000217177836ULL, 0x000fe20000000000ULL,
0x00000040ff387803ULL, 0x000fc40000000000ULL, 0x000000ff1a1a7207ULL, 0x000fe40004000000ULL,
0x00000003171b7812ULL, 0x040fe400078ec0ffULL, 0x00000004171c7c11ULL, 0x000fe2000f8ff0ffULL,
0x000000ffff187224ULL, 0x002fce00078e0015ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x018b806bff0075a7ULL, 0x000e6400080c0146ULL, 0x00000000005c6947ULL, 0x002fea0003800000ULL,
0x000000ffff1d7224ULL, 0x000fce00078e00ffULL, 0x000000101d00780cULL, 0x000fda0003fc6270ULL,
0x000000000044e947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x0000001416197210ULL, 0x000fca0007fde1ffULL, 0x0000000115157824ULL, 0x000fe200030e0e17ULL,
0x003d09001900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x000000000008e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x00000000001ce947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078d10ffULL,
0x000000ffff157224ULL, 0x000fca00030e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011d1d7836ULL, 0x000fce0000000000ULL, 0x018b806bff0075a7ULL, 0x000e6400080c0146ULL,
0xfffffffc00a8e947ULL, 0x002fea000383ffffULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x018b8818ff0075a7ULL, 0x000e6400080c0146ULL, 0x00000000005c6947ULL, 0x002fea0003800000ULL,
0x000000ffff1d7224ULL, 0x000fce00078e00ffULL, 0x000000101d00780cULL, 0x000fda0003fc6270ULL,
0x000000000044e947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x0000001416197210ULL, 0x000fca0007fde1ffULL, 0x0000000115157824ULL, 0x000fe200030e0e17ULL,
0x003d09001900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x000000000008e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x00000000001ce947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078d10ffULL,
0x000000ffff157224ULL, 0x000fca00030e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011d1d7836ULL, 0x000fce0000000000ULL, 0x018b8818ff0075a7ULL, 0x000e6400080c0146ULL,
0xfffffffc00a8e947ULL, 0x002fea000383ffffULL, 0x000000011c147836ULL, 0x000fca0000000000ULL,
0x0000001014007c0cULL, 0x000fda000bfc6070ULL, 0x00000004005ce947ULL, 0x000fea0003800000ULL,
0x000000015b1d7824ULL, 0x000fe200078e026cULL, 0x00014000060b7890ULL, 0x000fe2000fffe03fULL,
0x0000001010187824ULL, 0x000fe400078e00ffULL, 0x0000004013217824ULL, 0x000fe200078e021dULL,
0x000000061d1f7c11ULL, 0x040fe2000f8e10ffULL, 0x000000101d1e7824ULL, 0x000fe200078e00ffULL,
0x000000f018237812ULL, 0x000fe200078ec0ffULL, 0x000000041c187824ULL, 0x000fe400078e021bULL,
0x018a00001f147984ULL, 0x000e620000000800ULL, 0x000000026c207836ULL, 0x000fc40000000000ULL,
0x0000004018187824ULL, 0x000fe400078e00ffULL, 0x000000015b277824ULL, 0x000fe200078e0220ULL,
0x0000000614197c11ULL, 0x002fe4000f8e10ffULL, 0x00008a00ff147b82ULL, 0x000e660000000a00ULL,
0x018ac00019167984ULL, 0x0007240000000800ULL, 0x0000000d18197c48ULL, 0x008fca000ffe0000ULL,
0x0000000119187824ULL, 0x000fe400078e0a18ULL, 0x000000011d197824ULL, 0x000fc600078e0210ULL,
0x000000185b187248ULL, 0x000fe40007fe0000ULL, 0xfffffff01e197812ULL, 0x000fc600078ee219ULL,
0x00000001181d7824ULL, 0x000fe200078e0a5bULL, 0x0000000b19257c11ULL, 0x000fe2000f8e20ffULL,
0x0000000221197836ULL, 0x000fe40000000000ULL, 0x0000000816177c24ULL, 0x010fc8000f8e0221ULL,
0x0000010017167825ULL, 0x002fc600078e0014ULL, 0x0000002316167210ULL, 0x000fca0007fde0ffULL,
0x000000ffff177224ULL, 0x000fe200030e0617ULL, 0x0000001d6c00720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016257faeULL, 0x0003e8000f101c4eULL,
0x018a08001f187984ULL, 0x000ee20000000800ULL, 0x0000000127167824ULL, 0x042fe400078e0210ULL,
0x0000001027277824ULL, 0x000fe400078e00ffULL, 0x0000000421177836ULL, 0x000fc60000000000ULL,
0xfffffff027167812ULL, 0x000fc800078ee216ULL, 0x0000000b16257c11ULL, 0x000fe4000f8e20ffULL,
0x00000006181e7c11ULL, 0x008fca000f8e10ffULL, 0x018ac0001e187984ULL, 0x000e640000000800ULL,
0x0000000818197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000002318187210ULL, 0x000fca0007fde0ffULL, 0x000000ffff197224ULL, 0x000fe200030e0619ULL,
0x0000001d2000720cULL, 0x000fe20003fc6070ULL, 0x000000046c207836ULL, 0x000fe40000000000ULL,
0x000000066c6c7836ULL, 0x000fe40000000000ULL, 0x000000015b277824ULL, 0x000fd000078e0220ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018257faeULL, 0x0003e8000f101c4eULL,
0x018a10001f167984ULL, 0x000ee20000000800ULL, 0x0000000127187824ULL, 0x042fe400078e0210ULL,
0x0000001027277824ULL, 0x000fe400078e00ffULL, 0x0000000621197836ULL, 0x000fc60000000000ULL,
0xfffffff027187812ULL, 0x000fc800078ee218ULL, 0x0000000b18257c11ULL, 0x000fe4000f8e20ffULL,
0x00000006161e7c11ULL, 0x008fca000f8e10ffULL, 0x018ac0001e167984ULL, 0x000e640000000800ULL,
0x0000000816177c24ULL, 0x002fc8000f8e0217ULL, 0x0000010017167825ULL, 0x000fc600078e0014ULL,
0x0000002316167210ULL, 0x000fca0007fde0ffULL, 0x000000ffff177224ULL, 0x000fe200030e0617ULL,
0x0000001d2000720cULL, 0x000fda0003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016257faeULL, 0x0003e8000f101c4eULL, 0x018a18001f187984ULL, 0x000ee40000000800ULL,
0x0000000618187c11ULL, 0x008fcc000f8e10ffULL, 0x018ac00018187984ULL, 0x000ee40000000800ULL,
0x0000000818197c24ULL, 0x008fc8000f8e0219ULL, 0x0000010019147825ULL, 0x000fc800078e0014ULL,
0x000000015b197824ULL, 0x000fe200078e026cULL, 0x0000002314147210ULL, 0x000fc60007fde0ffULL,
0x0000000119167824ULL, 0x042fe400078e0210ULL, 0x000000ffff157224ULL, 0x000fe200030e0615ULL,
0x0000001d6c00720cULL, 0x000fe20003fc6070ULL, 0x0000001019197824ULL, 0x000fca00078e00ffULL,
0xfffffff019167812ULL, 0x000fc800078ee216ULL, 0x0000000b16177c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e2000f101c4eULL,
0x0000000400247947ULL, 0x000fea0003800000ULL, 0x000000015b6c7824ULL, 0x000fe200078e026cULL,
0x00014000060b7890ULL, 0x000fe2000fffe03fULL, 0x0000001010197824ULL, 0x000fe400078e00ffULL,
0x00000040131f7824ULL, 0x000fe200078e026cULL, 0x000000066c1e7c11ULL, 0x040fe2000f8e10ffULL,
0x000000106c207824ULL, 0x040fe200078e00ffULL, 0x000000f019217812ULL, 0x000fe200078ec0ffULL,
0x000000016c197824ULL, 0x000fe400078e0210ULL, 0x018a00001e147984ULL, 0x000e620000000800ULL,
0x000000026c257836ULL, 0x000fc40000000000ULL, 0xfffffff020197812ULL, 0x000fe400078ee219ULL,
0x0000000125207824ULL, 0x000fe400078e0210ULL, 0x0000000b19237c11ULL, 0x000fe2000f8e20ffULL,
0x000000021f197836ULL, 0x000fe40000000000ULL, 0x0000001025257824ULL, 0x000fca00078e00ffULL,
0xfffffff025207812ULL, 0x000fe200078ee220ULL, 0x000000046c257836ULL, 0x000fe20000000000ULL,
0x0000000614187c11ULL, 0x002fe4000f8e10ffULL, 0x00008a00ff147b82ULL, 0x000e660000000a00ULL,
0x018ac00018167984ULL, 0x000ee40000000800ULL, 0x0000000816177c24ULL, 0x008fc8000f8e021fULL,
0x0000010017167825ULL, 0x002fc600078e0014ULL, 0x0000002116167210ULL, 0x000fca0007fde0ffULL,
0x000000ffff177224ULL, 0x000fca00030e0617ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0003e8000b901c4eULL, 0x018a08001e187984ULL, 0x000ee20000000800ULL,
0x0000000b20237c11ULL, 0x002fe2000f8e20ffULL, 0x000000041f177836ULL, 0x000fe40000000000ULL,
0x0000000125207824ULL, 0x040fe400078e0210ULL, 0x0000001025257824ULL, 0x000fca00078e00ffULL,
0xfffffff025207812ULL, 0x000fe400078ee220ULL, 0x00000006181d7c11ULL, 0x008fca000f8e10ffULL,
0x018ac0001d187984ULL, 0x000e640000000800ULL, 0x0000000818197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000002118187210ULL, 0x000fca0007fde0ffULL,
0x000000ffff197224ULL, 0x000fca00030e0619ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018237faeULL, 0x0003e8000b901c4eULL, 0x018a10001e167984ULL, 0x000ee20000000800ULL,
0x0000000b20237c11ULL, 0x002fe2000f8e20ffULL, 0x000000061f197836ULL, 0x000fe20000000000ULL,
0x00000006161d7c11ULL, 0x008fca000f8e10ffULL, 0x018ac0001d167984ULL, 0x000e640000000800ULL,
0x0000000816177c24ULL, 0x002fc8000f8e0217ULL, 0x0000010017167825ULL, 0x000fc600078e0014ULL,
0x0000002116167210ULL, 0x000fca0007fde0ffULL, 0x000000ffff177224ULL, 0x000fca00030e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e8000b901c4eULL,
0x018a18001e187984ULL, 0x000ee40000000800ULL, 0x0000000618187c11ULL, 0x008fcc000f8e10ffULL,
0x018ac00018187984ULL, 0x000ee40000000800ULL, 0x0000000818197c24ULL, 0x008fc8000f8e0219ULL,
0x0000010019147825ULL, 0x000fc800078e0014ULL, 0x000000066c197836ULL, 0x000fe20000000000ULL,
0x0000002114147210ULL, 0x000fc60007fde0ffULL, 0x00000001191d7824ULL, 0x040fe400078e0210ULL,
0x0000001019167824ULL, 0x002fe400078e00ffULL, 0x000000ffff157224ULL, 0x000fc600030e0615ULL,
0xfffffff0161d7812ULL, 0x000fc800078ee21dULL, 0x0000000b1d1d7c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000141d7faeULL, 0x0003e4000b901c4eULL,
0x00000001ff147424ULL, 0x002fcc00078e00ffULL, 0x018b8814ff1479a7ULL, 0x000e640008500006ULL,
0x000000ffff187224ULL, 0x002fce00078e0015ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x018b8818ff0075a7ULL, 0x000e6400080c0146ULL, 0x00000000005c6947ULL, 0x002fea0003800000ULL,
0x000000ffff1d7224ULL, 0x000fce00078e00ffULL, 0x000000101d00780cULL, 0x000fda0003fc6270ULL,
0x000000000044e947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x0000001416197210ULL, 0x000fca0007fde1ffULL, 0x0000000115157824ULL, 0x000fe200030e0e17ULL,
0x003d09001900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x000000000008e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x00000000001ce947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078d10ffULL,
0x000000ffff157224ULL, 0x000fca00030e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011d1d7836ULL, 0x000fce0000000000ULL, 0x018b8818ff0075a7ULL, 0x000e6400080c0146ULL,
0xfffffffc00a8e947ULL, 0x002fea000383ffffULL, 0x0000019000007945ULL, 0x000fe20003800000ULL,
0x00000001ff6e7424ULL, 0x000fc600078e00ffULL, 0x0000000000581947ULL, 0x000fea0003800000ULL,
0x0000001c5c00720cULL, 0x000fe20003fc4070ULL, 0x00009400000b7ab9ULL, 0x000fc60000000800ULL,
0x000000ff1a147207ULL, 0x040fe40003000000ULL, 0x000000ff1a1a7207ULL, 0x000fc60007000000ULL,
0x000000011b1b7824ULL, 0x000fe400078e0214ULL, 0x00009200ff147b82ULL, 0x000e620000000a00ULL,
0x000000015d177824ULL, 0x000fe400078e021aULL, 0x000000401b167824ULL, 0x040fe200078e00ffULL,
0x0000001c1b1b7211ULL, 0x000fc800078ff0ffULL, 0x000000c016167812ULL, 0x000fca00078ec0ffULL,
0x000001001b167824ULL, 0x000fc800078e0216ULL, 0x0000002016187836ULL, 0x000fc80000000000ULL,
0x0000000b17167c24ULL, 0x000fc8000f8e0218ULL, 0x000000016f177824ULL, 0x040fe400078e0216ULL,
0x000000016f167824ULL, 0x040fe200078e0218ULL, 0x000000066f6f7c11ULL, 0x000fe2000f8e10ffULL,
0x0000000417147825ULL, 0x002fc600078e0014ULL, 0x0000000d16007c0cULL, 0x000fda000bfc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18a00000146f7faeULL, 0x0003e4000f12184eULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a49ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x018b786eff6e79a7ULL, 0x000e620008500006ULL, 0x0000000000102947ULL, 0x000fea0003800000ULL,
0x00000006ff03723eULL, 0x000fc800000010ffULL, 0x0000541003147816ULL, 0x000fca0000000003ULL,
0x00001f6d14047589ULL, 0x0044e800000e0000ULL, 0x00001f6214037589ULL, 0x00046400000e0000ULL,
0x013000006530783bULL, 0x0006a20000000200ULL, 0x0000000000102947ULL, 0x000fea0003800000ULL,
0x0000000330307232ULL, 0x086fe40000200000ULL, 0x0000000332327232ULL, 0x000fe40000200000ULL,
0x0000000431317232ULL, 0x088fe40000200000ULL, 0x0000000433337232ULL, 0x000fce0000200000ULL,
0x000000006414783bULL, 0x004ea80000004200ULL, 0x000000006318783bULL, 0x000f220000004200ULL,
0x0000ffff16277812ULL, 0x044fe400078ec0ffULL, 0x000000ff16227812ULL, 0x000fe400078ec0ffULL,
0x00000008ff277819ULL, 0x000fe40000011627ULL, 0x00000018ff207819ULL, 0x000fc40000011616ULL,
0x00000010ff2a7819ULL, 0x010fe40000011618ULL, 0x00000022ff22723eULL, 0x000fe400020006ffULL,
0x00000010ff367819ULL, 0x000fe40000011614ULL, 0x0000ffff14377812ULL, 0x000fe400078ec0ffULL,
0x00000010ff347819ULL, 0x000fe40000011615ULL, 0x00000018ff3b7819ULL, 0x000fc4000001161aULL,
0x00000027ff27723eULL, 0x000fe400020006ffULL, 0x00000010ff287819ULL, 0x000fe40000011617ULL,
0x00000010ff217819ULL, 0x100fe40000011619ULL, 0x000000ff193a7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff397819ULL, 0x000fe40000011619ULL, 0x0000ffff19297812ULL, 0x000fc400078ec0ffULL,
0x0000ffff172b7812ULL, 0x000fe400078ec0ffULL, 0x00000020ff19723eULL, 0x000fe200020006ffULL,
0x20000022ff207230ULL, 0x000fe20000004100ULL, 0x000000ff2a2a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff141d7812ULL, 0x000fe200078ec0ffULL, 0x20000019ff197230ULL, 0x000fe20000004100ULL,
0x000000ff36367812ULL, 0x000fe400078ec0ffULL, 0x00000008ff377819ULL, 0x000fc40000011637ULL,
0x000000ff151f7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff1a247812ULL, 0x000fe400078ec0ffULL,
0x0000003bff22723eULL, 0x000fe200020006ffULL, 0x20000027ff3b7230ULL, 0x000fe20000004100ULL,
0x000000ff34347812ULL, 0x000fe400078ec0ffULL, 0x000000ff28287812ULL, 0x000fe200078ec0ffULL,
0x20000022ff227230ULL, 0x000fe20000004100ULL, 0x00000018ff1c7819ULL, 0x000fc40000011614ULL,
0x0000ffff15357812ULL, 0x000fe400078ec0ffULL, 0x00000008ff2b7819ULL, 0x000fe4000001162bULL,
0x0000002aff2a723eULL, 0x000fe400020006ffULL, 0x000000ff21277812ULL, 0x000fe400078ec0ffULL,
0x00000018ff1e7819ULL, 0x000fe20000011615ULL, 0x2000002aff217230ULL, 0x000fe20000004100ULL,
0x00000010ff2f7819ULL, 0x000fc40000011616ULL, 0x0000001dff14723eULL, 0x000fe400020006ffULL,
0x00000036ff36723eULL, 0x000fe400020006ffULL, 0x00000037ff37723eULL, 0x000fe200020006ffULL,
0x20000014ff147230ULL, 0x000fe20000004100ULL, 0x000000ff17237812ULL, 0x000fe200078ec0ffULL,
0x20000036ff367230ULL, 0x000fe20000004100ULL, 0x00000018ff167819ULL, 0x000fe40000011617ULL,
0x00000010ff257819ULL, 0x000fc4000001161bULL, 0x0000ffff1b157812ULL, 0x000fe400078ec0ffULL,
0x0000001fff1f723eULL, 0x000fe400020006ffULL, 0x00000034ff34723eULL, 0x000fe400020006ffULL,
0x00000008ff247819ULL, 0x000fe20000011624ULL, 0x2000001fff2d7230ULL, 0x000fe20000004100ULL,
0x000000ff18267812ULL, 0x000fe400078ec0ffULL, 0x00000018ff177819ULL, 0x000fc40000011618ULL,
0x0000ffff182e7812ULL, 0x000fe400078ec0ffULL, 0x00000028ff28723eULL, 0x000fe400020006ffULL,
0x00000010ff187819ULL, 0x000fe4000001161aULL, 0x000000ff1a3c7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff357819ULL, 0x000fe40000011635ULL, 0x0000002bff2b723eULL, 0x000fc400020006ffULL,
0x00000027ff27723eULL, 0x000fe400020006ffULL, 0x00000039ff1a723eULL, 0x000fe200020006ffULL,
0x20000037ff397230ULL, 0x000fe20000004100ULL, 0x000000ff2f2f7812ULL, 0x000fe200078ec0ffULL,
0x20000034ff377230ULL, 0x000fe20000004100ULL, 0x000000ff1b3e7812ULL, 0x000fe200078ec0ffULL,
0x2000001aff1a7230ULL, 0x000fe20000004100ULL, 0x00000018ff3d7819ULL, 0x000fe4000001161bULL,
0x000000ff252a7812ULL, 0x000fe200078ec0ffULL, 0x20000027ff257230ULL, 0x000fe20000004100ULL,
0x00000024ff24723eULL, 0x000fc400020006ffULL, 0x00000008ff157819ULL, 0x000fe40000011615ULL,
0x0000001cff1c723eULL, 0x000fe400020006ffULL, 0x0000003aff1b723eULL, 0x000fe200020006ffULL,
0x20000028ff3a7230ULL, 0x000fe20000004100ULL, 0x0000001eff1e723eULL, 0x000fe200020006ffULL,
0x2000002bff287230ULL, 0x000fe20000004100ULL, 0x00000023ff1d723eULL, 0x000fe200020006ffULL,
0x2000001cff2c7230ULL, 0x000fe20000004100ULL, 0x00000035ff35723eULL, 0x000fe200020006ffULL,
0x2000001eff1c7230ULL, 0x000fe20000004100ULL, 0x00000016ff16723eULL, 0x000fe200020006ffULL,
0x2000001dff1d7230ULL, 0x000fe20000004100ULL, 0x0000002fff34723eULL, 0x000fe200020006ffULL,
0x20000035ff2f7230ULL, 0x000fe20000004100ULL, 0x00000026ff26723eULL, 0x000fe200020006ffULL,
0x20000016ff1f7230ULL, 0x000fe20000004100ULL, 0x0000002aff27723eULL, 0x000fe200020006ffULL,
0x20000024ff2a7230ULL, 0x000fe20000004100ULL, 0x00000015ff2b723eULL, 0x000fe200020006ffULL,
0x20000034ff347230ULL, 0x000fe20000004100ULL, 0x00000008ff2e7819ULL, 0x000fe2000001162eULL,
0x20000026ff167230ULL, 0x000fe20000004100ULL, 0x00000010ff147819ULL, 0x000fe20000011614ULL,
0x2000001bff1b7230ULL, 0x000fe20000004100ULL, 0x00000010ff157819ULL, 0x000fe20000011636ULL,
0x20000027ff277230ULL, 0x000fe20000004100ULL, 0x00000010ff2d7819ULL, 0x000fe2000001162dULL,
0x2000002bff2b7230ULL, 0x000fe20000004100ULL, 0x00000010ff247819ULL, 0x000fc40000011637ULL,
0x00000017ff17723eULL, 0x000fe400020006ffULL, 0x0000002eff2e723eULL, 0x000fe400020006ffULL,
0x0000105415147816ULL, 0x000fe20000000014ULL, 0x20000017ff177230ULL, 0x000fe20000004100ULL,
0x0000003dff26723eULL, 0x000fe200020006ffULL, 0x2000002eff357230ULL, 0x000fe20000004100ULL,
0x0000105424157816ULL, 0x000fe4000000002dULL, 0x000000ff18187812ULL, 0x000fe200078ec0ffULL,
0x20000026ff267230ULL, 0x000fe20000004100ULL, 0x00000010ff3d7819ULL, 0x000fc4000001162cULL,
0x00000010ff247819ULL, 0x000fe40000011619ULL, 0x00000010ff1c7819ULL, 0x000fe4000001161cULL,
0x00000010ff2c7819ULL, 0x000fe4000001161dULL, 0x00000010ff197819ULL, 0x000fe4000001162fULL,
0x00000010ff207819ULL, 0x000fe40000011620ULL, 0x00000010ff1d7819ULL, 0x000fc40000011634ULL,
0x00000010ff2d7819ULL, 0x000fe4000001163aULL, 0x0000003cff1e723eULL, 0x000fe400020006ffULL,
0x00000008ff297819ULL, 0x000fe40000011629ULL, 0x00000018ff18723eULL, 0x000fe200020006ffULL,
0x2000001eff1e7230ULL, 0x000fe20000004100ULL, 0x00000010ff3b7819ULL, 0x000fe4000001163bULL,
0x000010541c197816ULL, 0x000fe20000000019ULL, 0x20000018ff2e7230ULL, 0x000fe20000004100ULL,
0x000010541d1c7816ULL, 0x000fc40000000020ULL, 0x000010542d1d7816ULL, 0x000fe4000000002cULL,
0x00000010ff1f7819ULL, 0x000fe4000001161fULL, 0x00000010ff287819ULL, 0x000fe40000011628ULL,
0x00000029ff29723eULL, 0x000fe400020006ffULL, 0x0000105424207816ULL, 0x000fe4000000003bULL,
0x00000010ff2c7819ULL, 0x000fe20000011617ULL, 0x20000029ff297230ULL, 0x000fe20000004100ULL,
0x00000010ff357819ULL, 0x000fc40000011635ULL, 0x00000010ff247819ULL, 0x000fe40000011616ULL,
0x00000010ff2d7819ULL, 0x000fe20000011621ULL, 0x000000143014723cULL, 0x000fe200000418ffULL,
0x0000003eff23723eULL, 0x000fe400020006ffULL, 0x000010541f217816ULL, 0x000fe40000000028ULL,
0x000010542c287816ULL, 0x000fe20000000035ULL, 0x20000023ff237230ULL, 0x000fe20000004100ULL,
0x000010542d247816ULL, 0x000fc40000000024ULL, 0x00000010ff1f7819ULL, 0x000fe4000001161bULL,
0x00000010ff2c7819ULL, 0x000fe40000011625ULL, 0x00000010ff2d7819ULL, 0x000fe4000001161eULL,
0x00000010ff2e7819ULL, 0x000fe4000001162eULL, 0x000010542c257816ULL, 0x000fe4000000001fULL,
0x00000010ff347819ULL, 0x000fe2000001161aULL, 0x0000001c301c723cULL, 0x000fe200000418ffULL,
0x00000010ff297819ULL, 0x000fc40000011629ULL, 0x000010542e2c7816ULL, 0x000fe4000000002dULL,
0x00000010ff2d7819ULL, 0x000fe40000011622ULL, 0x00000010ff2a7819ULL, 0x000fe4000001162aULL,
0x00000010ff187819ULL, 0x000fe40000011639ULL, 0x00000010ff2e7819ULL, 0x000fe40000011623ULL,
0x00000010ff277819ULL, 0x000fe20000011627ULL, 0x000000203020723cULL, 0x000fe200000418ffULL,
0x00000010ff367819ULL, 0x000fc40000011626ULL, 0x00000010ff2b7819ULL, 0x000fe4000001162bULL,
0x0000105434297816ULL, 0x000fe40000000029ULL, 0x000010542d347816ULL, 0x000fe4000000002aULL,
0x000010543d187816ULL, 0x000fe40000000018ULL, 0x00001054272d7816ULL, 0x000fe4000000002eULL,
0x0000105436357816ULL, 0x000fe2000000002bULL, 0x000000243024723cULL, 0x000fec00000418ffULL,
0x000000183018723cULL, 0x000fec00000418ffULL, 0x000000283028723cULL, 0x000fec00000418ffULL,
0x0000002c302c723cULL, 0x000fec00000418ffULL, 0x000000343030723cULL, 0x000fe200000418ffULL,
0x013000006634783bULL, 0x0004e20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000102947ULL, 0x000fde0003800000ULL, 0x0000000334347232ULL, 0x08afe40000200000ULL,
0x0000000336367232ULL, 0x000fe40000200000ULL, 0x0000000435357232ULL, 0x080fe40000200000ULL,
0x0000000437377232ULL, 0x000fce0000200000ULL, 0x000000ff3800720cULL, 0x000fe20003f45270ULL,
0x00000bd000007945ULL, 0x000fe20003800000ULL, 0x000000006838783bULL, 0x000f240000004200ULL,
0x000000ff383c7812ULL, 0x010fe400078ec0ffULL, 0x000000ff393e7812ULL, 0x000fe400078ec0ffULL,
0x0000003cff3c723eULL, 0x000fe400020006ffULL, 0x00000018ff3d7819ULL, 0x000fc40000011638ULL,
0x0000003eff3f723eULL, 0x000fe200020006ffULL, 0x2000003cff507230ULL, 0x000fe20000004100ULL,
0x0000003dff3e723eULL, 0x000fe400020006ffULL, 0x00000010ff3c7819ULL, 0x000fe20000011638ULL,
0x2000003fff707230ULL, 0x000fe20000004100ULL, 0x00000010ff3d7819ULL, 0x000fe20000011639ULL,
0x2000003eff6c7230ULL, 0x000fe20000004100ULL, 0x0000ffff38387812ULL, 0x000fe400078ec0ffULL,
0x000000ff3d3f7812ULL, 0x000fc400078ec0ffULL, 0x000000ff3c3c7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff3d7819ULL, 0x000fe40000011638ULL, 0x0000003cff38723eULL, 0x000fe400020006ffULL,
0x0000003fff6b723eULL, 0x000fe400020006ffULL, 0x0000003dff51723eULL, 0x000fe200020006ffULL,
0x20000038ff387230ULL, 0x000fe20000004100ULL, 0x00000000673c783bULL, 0x000f220000004200ULL,
0x2000006bff717230ULL, 0x000fe20000004100ULL, 0x00000018ff6d7819ULL, 0x000fe20000011639ULL,
0x20000051ff6b7230ULL, 0x000fe20000004100ULL, 0x0000ffff39727812ULL, 0x000fc400078ec0ffULL,
0x00000010ff507819ULL, 0x000fe40000011650ULL, 0x00000010ff517819ULL, 0x000fe40000011638ULL,
0x0000006dff39723eULL, 0x000fe400020006ffULL, 0x00000010ff707819ULL, 0x000fe40000011670ULL,
0x00000010ff717819ULL, 0x000fe40000011671ULL, 0x00000010ff6d7819ULL, 0x000fc4000001166cULL,
0x00000010ff387819ULL, 0x000fe4000001166bULL, 0x00000008ff727819ULL, 0x000fe40000011672ULL,
0x0000105451507816ULL, 0x000fe40000000050ULL, 0x0000105471517816ULL, 0x000fe40000000070ULL,
0x000010546d387816ULL, 0x000fe40000000038ULL, 0x00000010ff717819ULL, 0x000fc4000001163aULL,
0x000000ff3a6d7812ULL, 0x000fe200078ec0ffULL, 0x000000503414723cULL, 0x008fe20000041814ULL,
0x00000072ff6b723eULL, 0x000fe400020006ffULL, 0x000000ff71717812ULL, 0x000fe400078ec0ffULL,
0x0000006dff73723eULL, 0x000fe200020006ffULL, 0x20000039ff6d7230ULL, 0x000fe20000004100ULL,
0x00000018ff727819ULL, 0x000fe2000001163aULL, 0x2000006bff397230ULL, 0x000fe20000004100ULL,
0x00000071ff71723eULL, 0x000fe200020006ffULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x00000072ff6b723eULL, 0x000fc400020006ffULL, 0x0000ffff3a6c7812ULL, 0x000fe200078ec0ffULL,
0x20000071ff717230ULL, 0x000fe20000004100ULL, 0x00000010ff727819ULL, 0x000fe2000001166dULL,
0x2000006bff6b7230ULL, 0x000fe20000004100ULL, 0x00000010ff397819ULL, 0x000fe40000011639ULL,
0x00000010ff3a7819ULL, 0x000fe4000001163bULL, 0x0000105472397816ULL, 0x000fe40000000039ULL,
0x000000ff3b747812ULL, 0x000fc400078ec0ffULL, 0x000000ff3a727812ULL, 0x000fe400078ec0ffULL,
0x00000010ff3a7819ULL, 0x000fe20000011673ULL, 0x000000383418723cULL, 0x000fe20000041818ULL,
0x00000010ff717819ULL, 0x000fe40000011671ULL, 0x00000018ff707819ULL, 0x000fe4000001163bULL,
0x00000074ff74723eULL, 0x000fe400020006ffULL, 0x0000ffff3b3b7812ULL, 0x000fc400078ec0ffULL,
0x00001054713a7816ULL, 0x000fe2000000003aULL, 0x20000074ff6d7230ULL, 0x000fe20000004100ULL,
0x00000010ff717819ULL, 0x010fe4000001163cULL, 0x00000008ff6c7819ULL, 0x000fe4000001166cULL,
0x00000008ff3b7819ULL, 0x000fe4000001163bULL, 0x000000ff3c747812ULL, 0x000fe400078ec0ffULL,
0x000000ff71767812ULL, 0x000fc400078ec0ffULL, 0x00000072ff72723eULL, 0x000fe400020006ffULL,
0x00000070ff70723eULL, 0x000fe400020006ffULL, 0x0000006cff6c723eULL, 0x000fe200020006ffULL,
0x20000072ff737230ULL, 0x000fe20000004100ULL, 0x0000003bff75723eULL, 0x000fe200020006ffULL,
0x20000070ff707230ULL, 0x000fe20000004100ULL, 0x00000074ff74723eULL, 0x000fe200020006ffULL,
0x2000006cff727230ULL, 0x000fe20000004100ULL, 0x00000076ff76723eULL, 0x000fe200020006ffULL,
0x20000075ff507230ULL, 0x000fe20000004100ULL, 0x00000010ff3b7819ULL, 0x000fe2000001166dULL,
0x20000074ff717230ULL, 0x000fe20000004100ULL, 0x00000010ff747819ULL, 0x000fe20000011673ULL,
0x20000076ff517230ULL, 0x000fe20000004100ULL, 0x00000010ff6b7819ULL, 0x000fc4000001166bULL,
0x00000010ff6d7819ULL, 0x000fe40000011670ULL, 0x00000010ff727819ULL, 0x000fe40000011672ULL,
0x00000010ff387819ULL, 0x000fe40000011650ULL, 0x00000018ff397819ULL, 0x000fe4000001163cULL,
0x00000010ff717819ULL, 0x000fe40000011671ULL, 0x00000010ff707819ULL, 0x000fc40000011651ULL,
0x00001054743b7816ULL, 0x000fe4000000003bULL, 0x000010546b507816ULL, 0x000fe40000000072ULL,
0x000010546d517816ULL, 0x000fe40000000038ULL, 0x00000039ff39723eULL, 0x000fe200020006ffULL,
0x0000003a341c723cULL, 0x000fe2000004181cULL, 0x0000105470387816ULL, 0x000fe40000000071ULL,
0x000000ff3e6b7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff707819ULL, 0x100fe2000001163eULL,
0x000000503420723cULL, 0x000fe20000041820ULL, 0x00000018ff727819ULL, 0x000fe4000001163eULL,
0x0000ffff3e6d7812ULL, 0x000fe400078ec0ffULL, 0x000000ff3f3e7812ULL, 0x000fe400078ec0ffULL,
0x0000006bff73723eULL, 0x000fe200020006ffULL, 0x20000039ff6b7230ULL, 0x000fe20000004100ULL,
0x00000018ff3a7819ULL, 0x000fc4000001163dULL, 0x00000010ff3b7819ULL, 0x000fe4000001163dULL,
0x0000003eff39723eULL, 0x000fe400020006ffULL, 0x000000ff3d6c7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff3c3c7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff757819ULL, 0x000fe4000001163fULL,
0x0000003aff3a723eULL, 0x000fc400020006ffULL, 0x00000072ff74723eULL, 0x000fe400020006ffULL,
0x00000010ff717819ULL, 0x000fe2000001163fULL, 0x2000003aff3e7230ULL, 0x000fe20000004100ULL,
0x000000ff3b727812ULL, 0x000fe200078ec0ffULL, 0x20000039ff3b7230ULL, 0x000fe20000004100ULL,
0x0000006cff6c723eULL, 0x000fe200020006ffULL, 0x20000073ff3a7230ULL, 0x000fe20000004100ULL,
0x0000ffff3d3d7812ULL, 0x000fe400078ec0ffULL, 0x00000075ff75723eULL, 0x000fe200020006ffULL,
0x2000006cff6c7230ULL, 0x000fe20000004100ULL, 0x00000008ff397819ULL, 0x000fe2000001163cULL,
0x20000074ff3c7230ULL, 0x000fe20000004100ULL, 0x000000ff71717812ULL, 0x000fc400078ec0ffULL,
0x0000ffff3f3f7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff737819ULL, 0x000fe2000001163dULL,
0x20000075ff3d7230ULL, 0x000fe20000004100ULL, 0x00000039ff39723eULL, 0x000fe400020006ffULL,
0x000000ff70707812ULL, 0x000fe400078ec0ffULL, 0x00000072ff72723eULL, 0x000fe400020006ffULL,
0x00000071ff75723eULL, 0x000fc400020006ffULL, 0x00000070ff74723eULL, 0x000fe200020006ffULL,
0x20000039ff707230ULL, 0x000fe20000004100ULL, 0x00000008ff6d7819ULL, 0x000fe2000001166dULL,
0x20000072ff727230ULL, 0x000fe20000004100ULL, 0x00000008ff3f7819ULL, 0x000fe2000001163fULL,
0x20000074ff747230ULL, 0x000fe20000004100ULL, 0x00000010ff397819ULL, 0x000fe2000001166cULL,
0x20000075ff6c7230ULL, 0x000fe20000004100ULL, 0x00000073ff73723eULL, 0x000fe400020006ffULL,
0x0000006dff6d723eULL, 0x000fc400020006ffULL, 0x0000003fff75723eULL, 0x000fe200020006ffULL,
0x20000073ff717230ULL, 0x000fe20000004100ULL, 0x00000010ff727819ULL, 0x000fe20000011672ULL,
0x2000006dff6d7230ULL, 0x000fe20000004100ULL, 0x00000010ff3f7819ULL, 0x000fe2000001166bULL,
0x20000075ff6b7230ULL, 0x000fe20000004100ULL, 0x0000105472397816ULL, 0x000fe40000000039ULL,
0x00000010ff727819ULL, 0x000fe4000001163eULL, 0x00000010ff3e7819ULL, 0x000fc40000011670ULL,
0x00000010ff517819ULL, 0x000fe2000001163cULL, 0x000000383424723cULL, 0x000fe20000041824ULL,
0x00000010ff507819ULL, 0x000fe4000001163dULL, 0x00000010ff3a7819ULL, 0x000fe4000001163aULL,
0x00000010ff717819ULL, 0x000fe40000011671ULL, 0x00000010ff737819ULL, 0x000fe40000011674ULL,
0x00000010ff3b7819ULL, 0x000fc4000001163bULL, 0x00000010ff6c7819ULL, 0x000fe4000001166cULL,
0x00000010ff3c7819ULL, 0x000fe4000001166dULL, 0x00000010ff3d7819ULL, 0x000fe4000001166bULL,
0x000010543f3e7816ULL, 0x000fe4000000003eULL, 0x00001054723f7816ULL, 0x000fe40000000071ULL,
0x00001054733a7816ULL, 0x000fc4000000003aULL, 0x000010546c3b7816ULL, 0x000fe4000000003bULL,
0x00001054513c7816ULL, 0x000fe2000000003cULL, 0x0000003e3428723cULL, 0x000fe20000041828ULL,
0x00001054503d7816ULL, 0x000fca000000003dULL, 0x0000003a342c723cULL, 0x000fec000004182cULL,
0x0000003c3430723cULL, 0x000fe20000041830ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000403947ULL, 0x000fde0001000000ULL, 0x000000140b0b7221ULL, 0x000fe20000010000ULL,
0x000000150a0a7221ULL, 0x000fe20000010000ULL, 0x000000180f0f7221ULL, 0x000fe20000010000ULL,
0x000000190e0e7221ULL, 0x000fe20000010000ULL, 0x0000001c41417221ULL, 0x000fe20000010000ULL,
0x0000001d42427221ULL, 0x000fe20000010000ULL, 0x0000002045457221ULL, 0x000fe20000010000ULL,
0x0000002146467221ULL, 0x000fe20000010000ULL, 0x0000002449497221ULL, 0x000fe20000010000ULL,
0x000000254a4a7221ULL, 0x000fe20000010000ULL, 0x000000284d4d7221ULL, 0x000fe20000010000ULL,
0x000000294e4e7221ULL, 0x000fe20000010000ULL, 0x0000002c53537221ULL, 0x000fe20000010000ULL,
0x0000002d54547221ULL, 0x000fe20000010000ULL, 0x0000003057577221ULL, 0x000fe20000010000ULL,
0x0000003158587221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x000000ffff157224ULL, 0x002fc600078e006fULL,
0x0000000000404947ULL, 0x000fea0002800000ULL, 0x000000160d0d7221ULL, 0x000fe20000010000ULL,
0x000000170c0c7221ULL, 0x000fe20000010000ULL, 0x0000001a11117221ULL, 0x000fe20000010000ULL,
0x0000001b40407221ULL, 0x000fe20000010000ULL, 0x0000001e43437221ULL, 0x000fe20000010000ULL,
0x0000001f44447221ULL, 0x000fe20000010000ULL, 0x0000002247477221ULL, 0x000fe20000010000ULL,
0x0000002348487221ULL, 0x000fe20000010000ULL, 0x000000264b4b7221ULL, 0x000fe20000010000ULL,
0x000000274c4c7221ULL, 0x000fe20000010000ULL, 0x0000002a4f4f7221ULL, 0x000fe20000010000ULL,
0x0000002b52527221ULL, 0x000fe20000010000ULL, 0x0000002e55557221ULL, 0x000fe20000010000ULL,
0x0000002f56567221ULL, 0x000fe20000010000ULL, 0x0000003259597221ULL, 0x000fe20000010000ULL,
0x000000335a5a7221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000016a6a7836ULL, 0x000fe40000000000ULL, 0x00000001ff147424ULL, 0x000fc600078e00ffULL,
0x000000696a00720cULL, 0x000fe20003f46070ULL, 0x018b8814ff1c79a7ULL, 0x0002d80008500006ULL,
0xffffffa00074a947ULL, 0x002fea000383ffffULL, 0x000000c0040b7891ULL, 0x000fe2000f8e403fULL,
0x018b6814ffff79a7ULL, 0x0003e60008500006ULL, 0x0000000d0b00728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f4f008ULL, 0x0000005c00942947ULL, 0x002fea0003800000ULL,
0x000000ffff6a7224ULL, 0x000fce00078e00ffULL, 0x00000002ff177819ULL, 0x000fe4000001166aULL,
0x000000036a1a7812ULL, 0x040fe400078ec0ffULL, 0x000000176a177207ULL, 0x000fe40000000000ULL,
0x000000ff1a1a7207ULL, 0x000fc60004000000ULL, 0x0000000317177836ULL, 0x000fca0000000000ULL,
0x00000003171c7812ULL, 0x048fe400078ec0ffULL, 0x00000004171b7c11ULL, 0x004fce000f8ff0ffULL,
0x0000000000187805ULL, 0x000fce0000015200ULL, 0x018b7815ff0075a7ULL, 0x000e640008040146ULL,
0x00000000005c2947ULL, 0x002fea0003800000ULL, 0x000000ffff1e7224ULL, 0x000fce00078e00ffULL,
0x000000101e00780cULL, 0x000fda0003f46270ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x00000016181f7210ULL, 0x000fca0007f5e1ffULL,
0x0000000117177824ULL, 0x000fe200010e0e19ULL, 0x003d09001f00780cULL, 0x000fc80003f46070ULL,
0x000000ff1700720cULL, 0x000fda0003f46320ULL, 0x000000000008a947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401f00780cULL, 0x000fc80003f46070ULL, 0x000000ff1700720cULL, 0x000fda0003f46320ULL,
0x00000000001ca947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011417ULL,
0x0000001f14147211ULL, 0x000fca00078510ffULL, 0x000000ffff177224ULL, 0x000fca00010e0617ULL,
0x0000000214147819ULL, 0x000fc80000001217ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011e1e7836ULL, 0x000fce0000000000ULL,
0x018b7815ff0075a7ULL, 0x000e640008040146ULL, 0xfffffffc00a8a947ULL, 0x002fea000383ffffULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x018b881dff0075a7ULL, 0x000e640008040146ULL,
0x00000000005c2947ULL, 0x002fea0003800000ULL, 0x000000ffff187224ULL, 0x000fce00078e00ffULL,
0x000000101800780cULL, 0x000fda0003f46270ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000001614197210ULL, 0x000fca0007f5e1ffULL,
0x0000000117177824ULL, 0x000fe200010e0e15ULL, 0x003d09001900780cULL, 0x000fc80003f46070ULL,
0x000000ff1700720cULL, 0x000fda0003f46320ULL, 0x000000000008a947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f46070ULL, 0x000000ff1700720cULL, 0x000fda0003f46320ULL,
0x00000000001ca947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000001916167211ULL, 0x000fca00078510ffULL, 0x000000ffff177224ULL, 0x000fca00010e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000118187836ULL, 0x000fce0000000000ULL,
0x018b881dff0075a7ULL, 0x000e640008040146ULL, 0xfffffffc00a8a947ULL, 0x002fea000383ffffULL,
0x000000011b147836ULL, 0x000fe20000000000ULL, 0x00000004ff6c7819ULL, 0x000fc80000011610ULL,
0x0000001014007c0cULL, 0x000fda000bf46070ULL, 0x000000040060a947ULL, 0x000fea0003800000ULL,
0x000000015b197824ULL, 0x000fe200078e026cULL, 0x0000002013207811ULL, 0x000fe200078e30ffULL,
0x000000041b167824ULL, 0x000fe200078e021cULL, 0x00016000060b7890ULL, 0x000fe2000fffe03fULL,
0x00000010101d7824ULL, 0x000fe200078e00ffULL, 0x00000006191f7c11ULL, 0x000fe2000f8e10ffULL,
0x000000026c227836ULL, 0x000fe20000000000ULL, 0x0000002016167811ULL, 0x000fe400078e30ffULL,
0x000000f01d217812ULL, 0x000fe200078ec0ffULL, 0x018a00001f147984ULL, 0x000e620000000800ULL,
0x0000000d16177c48ULL, 0x000fe2000ffe0000ULL, 0x000000015b257824ULL, 0x000fc800078e0222ULL,
0x0000000117167824ULL, 0x000fe400078e0a16ULL, 0x0000000119177824ULL, 0x000fe400078e0220ULL,
0x0000000125247824ULL, 0x000fe200078e0210ULL, 0x000000165b167248ULL, 0x000fca0007fe0000ULL,
0x00000001161d7824ULL, 0x000fca00078e0a5bULL, 0x0000001d6c00720cULL, 0x000fe40003f46070ULL,
0x0000000614187c11ULL, 0x002fe4000f8e10ffULL, 0x00008a00ff147b82ULL, 0x000e680000000a00ULL,
0x018ac00018187984ULL, 0x000ee40000000800ULL, 0x0000000818177c24ULL, 0x008fc4000f8e0217ULL,
0x0000000119187824ULL, 0x000fe400078e0210ULL, 0x0000010017167825ULL, 0x002fc800078e0014ULL,
0x0000001019197824ULL, 0x000fe200078e00ffULL, 0x0000002116167210ULL, 0x000fc80007f7e0ffULL,
0xfffffff019187812ULL, 0x000fe200078ee218ULL, 0x000000ffff177224ULL, 0x000fe400018e0617ULL,
0x0000000125197824ULL, 0x040fe200078e0220ULL, 0x0000000b18237c11ULL, 0x000fe2000f8e20ffULL,
0x0000001025257824ULL, 0x000fc800078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0003e2000d101c4eULL, 0x0000001d2200720cULL, 0x000fe20003f46070ULL,
0x000000046c227836ULL, 0x000fe20000000000ULL, 0xfffffff025247812ULL, 0x000fe200078ee224ULL,
0x018a08001f187984ULL, 0x000ee40000000800ULL, 0x000000015b257824ULL, 0x000fe200078e0222ULL,
0x0000000b24237c11ULL, 0x002fc6000f8e20ffULL, 0x0000000125247824ULL, 0x000fe200078e0210ULL,
0x00000006181e7c11ULL, 0x008fca000f8e10ffULL, 0x018ac0001e187984ULL, 0x000e640000000800ULL,
0x0000000818197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000002118167210ULL, 0x000fca0007f7e0ffULL, 0x000000ffff177224ULL, 0x000fe400018e0619ULL,
0x0000000125197824ULL, 0x040fe400078e0220ULL, 0x0000001025257824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e2000d101c4eULL,
0x0000001d2200720cULL, 0x000fc60003f46070ULL, 0x018a10001f187984ULL, 0x000ee20000000800ULL,
0xfffffff025247812ULL, 0x000fc800078ee224ULL, 0x0000000b24237c11ULL, 0x002fe4000f8e20ffULL,
0x00000006181e7c11ULL, 0x008fca000f8e10ffULL, 0x018ac0001e187984ULL, 0x0002e40000000800ULL,
0x000000066c1e7836ULL, 0x002fc80000000000ULL, 0x000000015b257824ULL, 0x000fe400078e021eULL,
0x0000000818197c24ULL, 0x008fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000002118167210ULL, 0x000fca0007f7e0ffULL, 0x000000ffff177224ULL, 0x000fe400018e0619ULL,
0x0000000125197824ULL, 0x040fe400078e0220ULL, 0x0000000125207824ULL, 0x040fe200078e0210ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e2000d101c4eULL,
0x0000001025257824ULL, 0x000fe200078e00ffULL, 0x0000001d1e00720cULL, 0x000fe40003f46070ULL,
0x018a18001f187984ULL, 0x000ee40000000800ULL, 0xfffffff025207812ULL, 0x000fc800078ee220ULL,
0x0000000b20177c11ULL, 0x002fe4000f8e20ffULL, 0x0000000618187c11ULL, 0x008fcc000f8e10ffULL,
0x018ac00018187984ULL, 0x000e640000000800ULL, 0x0000000818197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019147825ULL, 0x000fc600078e0014ULL, 0x0000002114147210ULL, 0x000fca0007f7e0ffULL,
0x000000ffff157224ULL, 0x000fca00018e0615ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014177faeULL, 0x0003e2000d101c4eULL, 0x0000000400287947ULL, 0x000fea0003800000ULL,
0x000000015b1f7824ULL, 0x000fe200078e026cULL, 0x0000002013207811ULL, 0x000fe200078e30ffULL,
0x0000001010197824ULL, 0x000fe200078e00ffULL, 0x00016000060b7890ULL, 0x000fe2000fffe03fULL,
0x000000101f227824ULL, 0x040fe200078e00ffULL, 0x000000061f1e7c11ULL, 0x040fe2000f8e10ffULL,
0x000000011f177824ULL, 0x000fe200078e0220ULL, 0x000000f019217812ULL, 0x000fe200078ec0ffULL,
0x000000011f197824ULL, 0x000fe400078e0210ULL, 0x018a00001e147984ULL, 0x000e620000000800ULL,
0x000000021f257836ULL, 0x000fc40000000000ULL, 0xfffffff022197812ULL, 0x000fe400078ee219ULL,
0x0000000125227824ULL, 0x000fe400078e0210ULL, 0x0000000b19237c11ULL, 0x000fe2000f8e20ffULL,
0x0000000120197824ULL, 0x000fe400078e0225ULL, 0x0000001025257824ULL, 0x000fca00078e00ffULL,
0xfffffff025227812ULL, 0x000fe200078ee222ULL, 0x000000041f257836ULL, 0x000fe40000000000ULL,
0x000000061f1f7836ULL, 0x000fe20000000000ULL, 0x0000000614187c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e660000000a00ULL, 0x018ac00018167984ULL, 0x000ee40000000800ULL,
0x0000000816177c24ULL, 0x008fc8000f8e0217ULL, 0x0000010017167825ULL, 0x002fc600078e0014ULL,
0x0000002116167210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff177224ULL, 0x000fca00010e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e8000b901c4eULL,
0x018a08001e187984ULL, 0x000ee20000000800ULL, 0x0000000b22237c11ULL, 0x002fe2000f8e20ffULL,
0x0000000120177824ULL, 0x000fe400078e0225ULL, 0x0000000125227824ULL, 0x040fe400078e0210ULL,
0x0000001025257824ULL, 0x000fca00078e00ffULL, 0xfffffff025227812ULL, 0x000fe400078ee222ULL,
0x00000006181d7c11ULL, 0x008fca000f8e10ffULL, 0x018ac0001d187984ULL, 0x000e640000000800ULL,
0x0000000818197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000002118187210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff197224ULL, 0x000fca00010e0619ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018237faeULL, 0x0003e8000b901c4eULL,
0x018a10001e167984ULL, 0x000ee20000000800ULL, 0x0000000b22237c11ULL, 0x002fe2000f8e20ffULL,
0x0000000120197824ULL, 0x000fe400078e021fULL, 0x000000101f207824ULL, 0x000fe200078e00ffULL,
0x00000006161d7c11ULL, 0x008fca000f8e10ffULL, 0x018ac0001d167984ULL, 0x000e640000000800ULL,
0x0000000816177c24ULL, 0x002fc8000f8e0217ULL, 0x0000010017167825ULL, 0x000fc600078e0014ULL,
0x0000002116167210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff177224ULL, 0x000fca00010e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e8000b901c4eULL,
0x018a18001e187984ULL, 0x000ee40000000800ULL, 0x0000000618187c11ULL, 0x008fcc000f8e10ffULL,
0x018ac00018187984ULL, 0x000ee40000000800ULL, 0x0000000818197c24ULL, 0x008fc8000f8e0219ULL,
0x0000010019147825ULL, 0x000fc800078e0014ULL, 0x000000011f197824ULL, 0x000fe200078e0210ULL,
0x0000002114147210ULL, 0x000fc80007f5e0ffULL, 0xfffffff020197812ULL, 0x000fe200078ee219ULL,
0x000000ffff157224ULL, 0x000fc600010e0615ULL, 0x0000000b19197c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014197faeULL, 0x0003e4000b901c4eULL,
0x00000001ff147424ULL, 0x002fcc00078e00ffULL, 0x018b8814ff1479a7ULL, 0x000e640008500006ULL,
0x000000ffff187224ULL, 0x002fce00078e0015ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x018b8818ff0075a7ULL, 0x000e640008040146ULL, 0x00000000005c2947ULL, 0x002fea0003800000ULL,
0x000000ffff1d7224ULL, 0x000fce00078e00ffULL, 0x000000101d00780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x0000001416197210ULL, 0x000fca0007f5e1ffULL, 0x0000000115157824ULL, 0x000fe200010e0e17ULL,
0x003d09001900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078510ffULL,
0x000000ffff157224ULL, 0x000fca00010e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011d1d7836ULL, 0x000fce0000000000ULL, 0x018b8818ff0075a7ULL, 0x000e640008040146ULL,
0xfffffffc00a8a947ULL, 0x002fea000383ffffULL, 0x0000001b5c00720cULL, 0x000fe20003f44070ULL,
0x00000001ff1e7424ULL, 0x000fe200078e00ffULL, 0x000000031a00780cULL, 0x000fe20003f65270ULL,
0x000000205f6f7824ULL, 0x000fd800078e0210ULL, 0x00000000004ca947ULL, 0x000fea0001800000ULL,
0x000000036f00780cULL, 0x000fe20003f44070ULL, 0x0000000105057890ULL, 0x000fe2000fffe03fULL,
0x0000010000007945ULL, 0x000ff60003800000ULL, 0x0000000000382947ULL, 0x000fea0003800000ULL,
0x00009000ff177b82ULL, 0x000e620000000800ULL, 0x000000070500728cULL, 0x000fe2000bf06070ULL,
0x0000000412167824ULL, 0x000fe200078e026fULL, 0x000000066f197c11ULL, 0x000fc6000f8e10ffULL,
0x0000000216167824ULL, 0x000fe200078e00ffULL, 0x000000000000781cULL, 0x000fe20003f4f008ULL,
0x00008c00ff147b82ULL, 0x000ee20000000a00ULL, 0x0000000517187c36ULL, 0x002fc80008000000ULL,
0x0000001716177224ULL, 0x000fc800078e0218ULL, 0x0000000417147825ULL, 0x008fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18ac000014197faeULL, 0x0003e4000d12184eULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000019000007945ULL, 0x000fe80003800000ULL,
0x00000000005c1947ULL, 0x000fea0003800000ULL, 0x0000001b5c00720cULL, 0x000fe20003f44070ULL,
0x000000011a157836ULL, 0x002fe20000000000ULL, 0x00009400000b7ab9ULL, 0x000fe20000000800ULL,
0x000000066f197c11ULL, 0x000fc6000f8e10ffULL, 0x0000000315167812ULL, 0x000fc800078ec0ffULL,
0x000000ff16167207ULL, 0x000fc60005000000ULL, 0x00000002ff15a819ULL, 0x000fe40000011615ULL,
0x000000015d167824ULL, 0x000fc600078e0216ULL, 0x000000011c1c7824ULL, 0x000fe400078e0215ULL,
0x00009200ff147b82ULL, 0x000e640000000a00ULL, 0x000000401c177824ULL, 0x040fe200078e00ffULL,
0x0000001b1c1b7211ULL, 0x000fc800078ff0ffULL, 0x000000c017187812ULL, 0x000fca00078ec0ffULL,
0x000001001b187824ULL, 0x000fc800078e0218ULL, 0x000000016f177824ULL, 0x100fe400078e0218ULL,
0x0000000b16167c24ULL, 0x000fc6000f8e0218ULL, 0x0000000d17007c0cULL, 0x000fe2000bf46070ULL,
0x000000016f177824ULL, 0x000fc800078e0216ULL, 0x0000000417147825ULL, 0x002fd000078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18a0000014197faeULL, 0x0003e4000d12184eULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a4aULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x018b801eff1479a7ULL, 0x000e620008500006ULL, 0x000000ff6a00720cULL, 0x000fe20003f45270ULL,
0x00000008626d7836ULL, 0x000fe40000000000ULL, 0x000000ffff6b7224ULL, 0x002fd400078e0015ULL,
0x00000004008c2947ULL, 0x000fea0003800000ULL, 0x018b381e5b1479a7ULL, 0x000e640008500006ULL,
0x000000ffff187224ULL, 0x002fce00078e0015ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x018b38185b0075a7ULL, 0x000e640008040146ULL, 0x00000000005c2947ULL, 0x002fea0003800000ULL,
0x000000ffff197224ULL, 0x000fce00078e00ffULL, 0x000000101900780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x0000001416147210ULL, 0x000fca0007f5e1ffULL, 0x0000000115157824ULL, 0x000fe200010e0e17ULL,
0x003d09001400780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401400780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff077819ULL, 0x000fc80000011415ULL, 0x0000001407077211ULL, 0x000fca00078510ffULL,
0x000000ffff147224ULL, 0x000fca00010e0615ULL, 0x0000000207077819ULL, 0x000fc80000001214ULL,
0x000000070000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000119197836ULL, 0x000fce0000000000ULL, 0x018b38185b0075a7ULL, 0x000e640008040146ULL,
0xfffffffc00a8a947ULL, 0x002fea000383ffffULL, 0x0000001010077824ULL, 0x000fe200078e00ffULL,
0x00000001ff147819ULL, 0x000fe20000011610ULL, 0x000000ffff167224ULL, 0x000fc600078e0008ULL,
0x0000007007077812ULL, 0x000fe400078ec0ffULL, 0x0000000c14147812ULL, 0x000fc800078ec0ffULL,
0x00000006141b7c10ULL, 0x000fca000fffe007ULL, 0x018180001b157984ULL, 0x000e680000000800ULL,
0x018380001b147984ULL, 0x0006e20000000800ULL, 0x000000081500720bULL, 0x002fda0003f5d000ULL,
0x0000000000077806ULL, 0x000fc800010e0100ULL, 0x0000ffff07187812ULL, 0x000fe2000784c0ffULL,
0x00000001ff077424ULL, 0x000fd800078e00ffULL, 0x0000000000e0a947ULL, 0x00cfea0003800000ULL,
0x000000081500720bULL, 0x000fe40003f54000ULL, 0x000000035f00780cULL, 0x000fe40003f65270ULL,
0x0000001508167209ULL, 0x000fd20007810000ULL, 0x0000000000197806ULL, 0x000fe400010e0100ULL,
0x018580161b00b388ULL, 0x0003e40000000800ULL, 0x0000991019177816ULL, 0x000fc800000000ffULL,
0x000000ff1700720cULL, 0x000fda0003f45270ULL, 0x0000000000a8a947ULL, 0x002fea0003800000ULL,
0x8000001608087221ULL, 0x000fe20000010000ULL, 0x000000ff19ff7812ULL, 0x040fe4000784c0ffULL,
0x0000ff0019ff7812ULL, 0x000fe2000786c0ffULL, 0x3fb8aa3b08087820ULL, 0x000fc80000410000ULL,
0x00000008001a7308ULL, 0x0002ac0000000800ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x00001f621a087589ULL, 0x006e6400000e0000ULL, 0x000000080b0b7220ULL, 0x082fe20000410000ULL,
0x000000080a0a7220ULL, 0x080fe20000410000ULL, 0x000000080f0f7220ULL, 0x080fe20000410000ULL,
0x000000080e0e7220ULL, 0x080fe20000410000ULL, 0x0000000841417220ULL, 0x080fe20000410000ULL,
0x0000000842427220ULL, 0x080fe20000410000ULL, 0x0000000845457220ULL, 0x080fe20000410000ULL,
0x0000000846467220ULL, 0x080fe20000410000ULL, 0x0000000849497220ULL, 0x080fe20000410000ULL,
0x000000084a4a7220ULL, 0x080fe20000410000ULL, 0x000000084d4d7220ULL, 0x080fe20000410000ULL,
0x000000084e4e7220ULL, 0x080fe20000410000ULL, 0x0000000853537220ULL, 0x080fe20000410000ULL,
0x0000000854547220ULL, 0x080fe20000410000ULL, 0x0000000857577220ULL, 0x080fe20000410000ULL,
0x0000000858587220ULL, 0x000fce0000410000ULL, 0x0000001a09097220ULL, 0x004fe20000410000ULL,
0x000000000044b947ULL, 0x000fec0003800000ULL, 0x00001f6d1a087589ULL, 0x002e6400000e0000ULL,
0x000000080d0d7220ULL, 0x082fe20000410000ULL, 0x000000080c0c7220ULL, 0x080fe20000410000ULL,
0x0000000811117220ULL, 0x080fe20000410000ULL, 0x0000000840407220ULL, 0x080fe20000410000ULL,
0x0000000843437220ULL, 0x080fe20000410000ULL, 0x0000000844447220ULL, 0x080fe20000410000ULL,
0x0000000847477220ULL, 0x080fe20000410000ULL, 0x0000000848487220ULL, 0x080fe20000410000ULL,
0x000000084b4b7220ULL, 0x080fe20000410000ULL, 0x000000084c4c7220ULL, 0x080fe20000410000ULL,
0x000000084f4f7220ULL, 0x080fe20000410000ULL, 0x0000000852527220ULL, 0x080fe20000410000ULL,
0x0000000855557220ULL, 0x080fe20000410000ULL, 0x0000000856567220ULL, 0x080fe20000410000ULL,
0x0000000859597220ULL, 0x080fe20000410000ULL, 0x000000085a5a7220ULL, 0x000fce0000410000ULL,
0x0000ffff18ff7812ULL, 0x000fda0007846019ULL, 0x8000001615152221ULL, 0x000fe20000010000ULL,
0x00007610ff072816ULL, 0x000fc60000000007ULL, 0x3fb8aa3b15152820ULL, 0x000fc80000410000ULL,
0x0000001500062308ULL, 0x000ea40000000800ULL, 0x0000000614142220ULL, 0x004fce0000410000ULL,
0x0000000914097221ULL, 0x000fe20000010000ULL, 0x000000ffff087224ULL, 0x002fce00078e0016ULL,
0x000000ff07ff7812ULL, 0x000fda000784c0ffULL, 0x0000000000102947ULL, 0x000fea0003800000ULL,
0x00000006ff03723eULL, 0x000fc800000010ffULL, 0x0000541003147816ULL, 0x000fca0000000003ULL,
0x00001f6214037589ULL, 0x0002e800000e0000ULL, 0x00001f6d14047589ULL, 0x0002a400000e0000ULL,
0x01380000051c783bULL, 0x0002e20000000200ULL, 0x0000000000102947ULL, 0x000fea0003800000ULL,
0x000000031c1c7232ULL, 0x088fe40000200000ULL, 0x000000031e1e7232ULL, 0x000fe40000200000ULL,
0x000000041d1d7232ULL, 0x084fe40000200000ULL, 0x000000041f1f7232ULL, 0x000fce0000200000ULL,
0x000000000214783bULL, 0x002e680000004200ULL, 0x000000000018783bULL, 0x000f220000004200ULL,
0x00000018ff207819ULL, 0x002fe40000011614ULL, 0x0000ffff15347812ULL, 0x000fe400078ec0ffULL,
0x00000020ff20723eULL, 0x000fe400020006ffULL, 0x000000ff18387812ULL, 0x010fc400078ec0ffULL,
0x0000ffff162e7812ULL, 0x000fe200078ec0ffULL, 0x20000020ff2b7230ULL, 0x000fe20000004100ULL,
0x00000010ff377819ULL, 0x000fe40000011614ULL, 0x00000038ff20723eULL, 0x000fe400020006ffULL,
0x00000010ff337819ULL, 0x000fe40000011616ULL, 0x00000008ff387819ULL, 0x000fe20000011634ULL,
0x20000020ff207230ULL, 0x000fe20000004100ULL, 0x00000008ff2e7819ULL, 0x000fc4000001162eULL,
0x000000ff37377812ULL, 0x000fe400078ec0ffULL, 0x00000010ff357819ULL, 0x100fe40000011615ULL,
0x000000ff15237812ULL, 0x000fe400078ec0ffULL, 0x00000018ff227819ULL, 0x000fe40000011615ULL,
0x00000038ff38723eULL, 0x000fe400020006ffULL, 0x000000ff33337812ULL, 0x000fc400078ec0ffULL,
0x000000ff16247812ULL, 0x000fe400078ec0ffULL, 0x00000018ff157819ULL, 0x000fe40000011616ULL,
0x00000010ff2f7819ULL, 0x100fe40000011617ULL, 0x000000ff19397812ULL, 0x000fe400078ec0ffULL,
0x000000ff17257812ULL, 0x000fe400078ec0ffULL, 0x00000018ff167819ULL, 0x000fc40000011617ULL,
0x0000ffff17307812ULL, 0x000fe400078ec0ffULL, 0x00000010ff317819ULL, 0x100fe40000011618ULL,
0x0000002eff2e723eULL, 0x000fe400020006ffULL, 0x00000018ff177819ULL, 0x000fe40000011618ULL,
0x0000ffff18327812ULL, 0x000fe400078ec0ffULL, 0x00000037ff34723eULL, 0x000fc400020006ffULL,
0x00000010ff297819ULL, 0x100fe40000011619ULL, 0x00000018ff187819ULL, 0x000fe20000011619ULL,
0x20000034ff347230ULL, 0x000fe20000004100ULL, 0x0000ffff192d7812ULL, 0x000fe400078ec0ffULL,
0x00000033ff37723eULL, 0x000fe200020006ffULL, 0x20000038ff337230ULL, 0x000fe20000004100ULL,
0x00000010ff287819ULL, 0x000fe4000001161aULL, 0x00000023ff23723eULL, 0x000fc400020006ffULL,
0x00000039ff19723eULL, 0x000fe400020006ffULL, 0x000000ff2f2f7812ULL, 0x000fe200078ec0ffULL,
0x20000023ff2c7230ULL, 0x000fe20000004100ULL, 0x00000015ff15723eULL, 0x000fe200020006ffULL,
0x20000019ff197230ULL, 0x000fe20000004100ULL, 0x00000008ff387819ULL, 0x000fe20000011630ULL,
0x20000037ff307230ULL, 0x000fe20000004100ULL, 0x000000ff31397812ULL, 0x000fe200078ec0ffULL,
0x2000002eff317230ULL, 0x000fe20000004100ULL, 0x000000ff14217812ULL, 0x000fe200078ec0ffULL,
0x20000015ff237230ULL, 0x000fe20000004100ULL, 0x00000018ff3a7819ULL, 0x000fc4000001161aULL,
0x00000010ff2a7819ULL, 0x000fe4000001161bULL, 0x00000008ff2e7819ULL, 0x000fe4000001162dULL,
0x0000ffff14367812ULL, 0x000fe400078ec0ffULL, 0x0000002fff2f723eULL, 0x000fe400020006ffULL,
0x000000ff28287812ULL, 0x000fe400078ec0ffULL, 0x000000ff1b3c7812ULL, 0x000fe200078ec0ffULL,
0x2000002fff377230ULL, 0x000fe20000004100ULL, 0x00000018ff147819ULL, 0x000fc4000001161bULL,
0x00000038ff38723eULL, 0x000fe400020006ffULL, 0x00000021ff21723eULL, 0x000fe400020006ffULL,
0x0000ffff1b1b7812ULL, 0x000fe200078ec0ffULL, 0x20000038ff2f7230ULL, 0x000fe20000004100ULL,
0x0000003aff15723eULL, 0x000fe200020006ffULL, 0x20000021ff277230ULL, 0x000fe20000004100ULL,
0x0000002eff2e723eULL, 0x000fe400020006ffULL, 0x000000ff2a2a7812ULL, 0x000fe200078ec0ffULL,
0x20000015ff157230ULL, 0x000fe20000004100ULL, 0x00000022ff22723eULL, 0x000fc400020006ffULL,
0x00000008ff3a7819ULL, 0x000fe40000011632ULL, 0x00000028ff28723eULL, 0x000fe400020006ffULL,
0x00000016ff16723eULL, 0x000fe400020006ffULL, 0x00000039ff32723eULL, 0x000fe400020006ffULL,
0x00000008ff397819ULL, 0x000fe4000001161bULL, 0x000000ff35357812ULL, 0x000fe200078ec0ffULL,
0x20000032ff327230ULL, 0x000fe20000004100ULL, 0x0000002aff38723eULL, 0x000fe200020006ffULL,
0x2000002eff2a7230ULL, 0x000fe20000004100ULL, 0x00000024ff26723eULL, 0x000fe200020006ffULL,
0x20000022ff247230ULL, 0x000fe20000004100ULL, 0x00000035ff35723eULL, 0x000fe200020006ffULL,
0x20000028ff2e7230ULL, 0x000fe20000004100ULL, 0x00000039ff28723eULL, 0x000fe200020006ffULL,
0x20000016ff227230ULL, 0x000fe20000004100ULL, 0x0000003cff16723eULL, 0x000fe200020006ffULL,
0x20000026ff267230ULL, 0x000fe20000004100ULL, 0x00000010ff397819ULL, 0x000fe2000001162bULL,
0x20000035ff357230ULL, 0x000fe20000004100ULL, 0x00000010ff3c7819ULL, 0x000fe20000011627ULL,
0x20000028ff277230ULL, 0x000fe20000004100ULL, 0x00000010ff2b7819ULL, 0x000fe20000011634ULL,
0x20000016ff167230ULL, 0x000fe20000004100ULL, 0x00000025ff25723eULL, 0x000fc400020006ffULL,
0x00000017ff17723eULL, 0x000fe400020006ffULL, 0x000000ff1a3b7812ULL, 0x040fe200078ec0ffULL,
0x20000025ff257230ULL, 0x000fe20000004100ULL, 0x0000ffff1a1a7812ULL, 0x000fe200078ec0ffULL,
0x20000017ff217230ULL, 0x000fe20000004100ULL, 0x000000ff29297812ULL, 0x000fe400078ec0ffULL,
0x000010542b3c7816ULL, 0x000fe4000000003cULL, 0x00000010ff2b7819ULL, 0x000fc40000011623ULL,
0x00000010ff267819ULL, 0x000fe40000011626ULL, 0x00000010ff237819ULL, 0x000fe40000011630ULL,
0x00000018ff18723eULL, 0x000fe400020006ffULL, 0x00000029ff29723eULL, 0x000fe400020006ffULL,
0x00000008ff1a7819ULL, 0x000fe2000001161aULL, 0x20000018ff187230ULL, 0x000fe20000004100ULL,
0x00000008ff367819ULL, 0x000fe20000011636ULL, 0x20000029ff297230ULL, 0x000fe20000004100ULL,
0x00000010ff2c7819ULL, 0x000fc4000001162cULL, 0x00000010ff357819ULL, 0x000fe40000011635ULL,
0x0000105423307816ULL, 0x000fe40000000026ULL, 0x00000010ff257819ULL, 0x000fe40000011625ULL,
0x00000010ff287819ULL, 0x000fe40000011637ULL, 0x00000010ff237819ULL, 0x000fe40000011621ULL,
0x0000001aff1a723eULL, 0x000fc400020006ffULL, 0x00000010ff207819ULL, 0x000fe40000011620ULL,
0x00000010ff217819ULL, 0x000fe20000011632ULL, 0x2000001aff1b7230ULL, 0x000fe20000004100ULL,
0x0000003bff17723eULL, 0x000fe200020006ffULL, 0x20000038ff1a7230ULL, 0x000fe20000004100ULL,
0x00000036ff36723eULL, 0x000fe400020006ffULL, 0x0000003aff3a723eULL, 0x000fe200020006ffULL,
0x20000017ff177230ULL, 0x000fe20000004100ULL, 0x00001054353d7816ULL, 0x000fe2000000002cULL,
0x20000036ff367230ULL, 0x000fe20000004100ULL, 0x00000014ff14723eULL, 0x000fe200020006ffULL,
0x2000003aff2d7230ULL, 0x000fe20000004100ULL, 0x00000010ff2c7819ULL, 0x000fc40000011631ULL,
0x0000105428317816ULL, 0x000fe20000000025ULL, 0x20000014ff147230ULL, 0x000fe20000004100ULL,
0x0000105421287816ULL, 0x000fe20000000020ULL, 0x0000003c1c3c723cULL, 0x008fe200000418ffULL,
0x00000010ff207819ULL, 0x000fe40000011618ULL, 0x00000010ff247819ULL, 0x000fe40000011624ULL,
0x00000010ff337819ULL, 0x000fe40000011633ULL, 0x00000010ff197819ULL, 0x000fc40000011619ULL,
0x00000010ff187819ULL, 0x000fe40000011629ULL, 0x0000105424357816ULL, 0x000fe40000000033ULL,
0x00000010ff257819ULL, 0x000fe2000001162aULL, 0x000000301c30723cULL, 0x000fe200000418ffULL,
0x0000105418297816ULL, 0x000fe40000000019ULL, 0x00000010ff347819ULL, 0x000fe40000011636ULL,
0x00000010ff227819ULL, 0x000fc40000011622ULL, 0x00000010ff2f7819ULL, 0x000fe4000001162fULL,
0x00000010ff247819ULL, 0x000fe4000001162dULL, 0x00000010ff177819ULL, 0x000fe40000011617ULL,
0x00000010ff2e7819ULL, 0x000fe4000001162eULL, 0x00000010ff187819ULL, 0x000fe40000011615ULL,
0x00000010ff167819ULL, 0x000fc40000011616ULL, 0x00000010ff217819ULL, 0x000fe4000001161aULL,
0x00000010ff1b7819ULL, 0x000fe4000001161bULL, 0x00000010ff1a7819ULL, 0x000fe40000011614ULL,
0x00000010ff157819ULL, 0x000fe40000011627ULL, 0x0000105420257816ULL, 0x000fe40000000025ULL,
0x0000105439347816ULL, 0x000fc40000000034ULL, 0x000010542b2c7816ULL, 0x000fe4000000002cULL,
0x00001054222d7816ULL, 0x000fe2000000002fULL, 0x000000281c28723cULL, 0x000fe200000418ffULL,
0x0000105423247816ULL, 0x000fe40000000024ULL, 0x000010542e207816ULL, 0x000fe40000000017ULL,
0x0000105421217816ULL, 0x000fe20000000016ULL, 0x000000341c34723cULL, 0x000fe200000418ffULL,
0x0000105418147816ULL, 0x000fc4000000001bULL, 0x000010541a157816ULL, 0x000fe40000000015ULL,
0x013800005e18783bULL, 0x0002e20000000200ULL, 0x0000002c1c2c723cULL, 0x000fec00000418ffULL,
0x000000241c24723cULL, 0x000fec00000418ffULL, 0x000000201c20723cULL, 0x000fec00000418ffULL,
0x000000141c1c723cULL, 0x000fe200000418ffULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000102947ULL, 0x002fde0003800000ULL, 0x0000000318187232ULL, 0x088fe40000200000ULL,
0x000000031a1a7232ULL, 0x000fe40000200000ULL, 0x0000000419197232ULL, 0x084fe40000200000ULL,
0x000000041b1b7232ULL, 0x000fce0000200000ULL, 0x000000006014783bULL, 0x000e620000004200ULL,
0x0000006a6200720cULL, 0x080fe20003f66070ULL, 0x00000c3000007945ULL, 0x000fe20003800000ULL,
0x000000045c007c0cULL, 0x040fe4000bfc3070ULL, 0x0000006a6d00720cULL, 0x000fe40003f86070ULL,
0x000000045c007c0cULL, 0x000fe4000bfa3070ULL, 0x000000ff14397812ULL, 0x002fe400078ec0ffULL,
0x00000010ff387819ULL, 0x000fc40000011614ULL, 0x00000039ff39723eULL, 0x000fe400020006ffULL,
0x00000010ff3a7819ULL, 0x000fe40000011615ULL, 0x000000ff153b7812ULL, 0x000fe200078ec0ffULL,
0x20000039ff507230ULL, 0x000fe20000004100ULL, 0x000000ff38387812ULL, 0x000fe400078ec0ffULL,
0x000000ff3a3a7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff14397812ULL, 0x000fc400078ec0ffULL,
0x0000003bff3b723eULL, 0x000fe400020006ffULL, 0x00000038ff38723eULL, 0x000fe400020006ffULL,
0x0000003aff3a723eULL, 0x000fe200020006ffULL, 0x2000003bff707230ULL, 0x000fe20000004100ULL,
0x00000018ff147819ULL, 0x000fe20000011614ULL, 0x20000038ff517230ULL, 0x000fe20000004100ULL,
0x00000008ff397819ULL, 0x000fe20000011639ULL, 0x2000003aff717230ULL, 0x000fe20000004100ULL,
0x00000014ff6e723eULL, 0x000fc400020006ffULL, 0x00000039ff14723eULL, 0x000fe400020006ffULL,
0x000000006138783bULL, 0x000e620000004200ULL, 0x00000010ff507819ULL, 0x000fe20000011650ULL,
0x2000006eff6e7230ULL, 0x000fe20000004100ULL, 0x00000010ff517819ULL, 0x000fe20000011651ULL,
0x20000014ff147230ULL, 0x000fe20000004100ULL, 0x00000010ff707819ULL, 0x000fe40000011670ULL,
0x00000010ff717819ULL, 0x000fe40000011671ULL, 0x0000105451507816ULL, 0x000fc40000000050ULL,
0x0000105471517816ULL, 0x000fe40000000070ULL, 0x00000018ff707819ULL, 0x000fe40000011615ULL,
0x000000ff16727812ULL, 0x000fe400078ec0ffULL, 0x00000070ff70723eULL, 0x000fe200020006ffULL,
0x00000050183c723cULL, 0x008fe2000004183cULL, 0x00000010ff717819ULL, 0x000fe4000001166eULL,
0x00000010ff147819ULL, 0x000fc40000011614ULL, 0x000000ff17747812ULL, 0x000fe400078ec0ffULL,
0x0000ffff15507812ULL, 0x000fe400078ec0ffULL, 0x00000010ff517819ULL, 0x000fe40000011616ULL,
0x00000008ff507819ULL, 0x000fe40000011650ULL, 0x00000072ff6e723eULL, 0x000fe200020006ffULL,
0x20000070ff727230ULL, 0x000fe20000004100ULL, 0x00000050ff50723eULL, 0x000fc400020006ffULL,
0x0000105471147816ULL, 0x000fe20000000014ULL, 0x2000006eff6e7230ULL, 0x000fe20000004100ULL,
0x00000018ff737819ULL, 0x000fe20000011616ULL, 0x20000050ff707230ULL, 0x000fe20000004100ULL,
0x00000074ff75723eULL, 0x000fe400020006ffULL, 0x00000010ff717819ULL, 0x000fe40000011617ULL,
0x000000ff51747812ULL, 0x000fe200078ec0ffULL, 0x20000075ff507230ULL, 0x000fe20000004100ULL,
0x00000073ff51723eULL, 0x000fc400020006ffULL, 0x00000018ff157819ULL, 0x000fe40000011617ULL,
0x00000074ff74723eULL, 0x000fe200020006ffULL, 0x20000051ff517230ULL, 0x000fe20000004100ULL,
0x000000ff71737812ULL, 0x000fe400078ec0ffULL, 0x00000010ff727819ULL, 0x000fe20000011672ULL,
0x20000074ff747230ULL, 0x000fe20000004100ULL, 0x00000010ff717819ULL, 0x000fe40000011670ULL,
0x00000015ff70723eULL, 0x000fc400020006ffULL, 0x0000105472157816ULL, 0x000fe40000000071ULL,
0x000000ff38727812ULL, 0x002fe200078ec0ffULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x0000ffff16167812ULL, 0x000fe400078ec0ffULL, 0x0000ffff17177812ULL, 0x000fe200078ec0ffULL,
0x000000141834723cULL, 0x000fe20000041834ULL, 0x00000010ff717819ULL, 0x000fe4000001166eULL,
0x00000010ff747819ULL, 0x000fc40000011674ULL, 0x00000072ff6e723eULL, 0x000fe400020006ffULL,
0x00000008ff727819ULL, 0x000fe40000011616ULL, 0x00000008ff177819ULL, 0x000fe20000011617ULL,
0x2000006eff6e7230ULL, 0x000fe20000004100ULL, 0x0000105474167816ULL, 0x000fe40000000071ULL,
0x00000072ff72723eULL, 0x000fe400020006ffULL, 0x00000017ff71723eULL, 0x000fc400020006ffULL,
0x00000073ff73723eULL, 0x000fe200020006ffULL, 0x20000072ff727230ULL, 0x000fe20000004100ULL,
0x00000010ff747819ULL, 0x000fe20000011638ULL, 0x20000071ff717230ULL, 0x000fe20000004100ULL,
0x00000010ff517819ULL, 0x000fe20000011651ULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x00000010ff707819ULL, 0x000fe40000011670ULL, 0x00000010ff147819ULL, 0x000fe40000011672ULL,
0x00000010ff157819ULL, 0x000fc40000011671ULL, 0x000000ff74757812ULL, 0x000fe400078ec0ffULL,
0x00000010ff177819ULL, 0x000fe40000011650ULL, 0x00000010ff747819ULL, 0x000fe40000011673ULL,
0x0000105451147816ULL, 0x000fe40000000014ULL, 0x0000105470157816ULL, 0x000fe40000000015ULL,
0x0000105474177816ULL, 0x000fc40000000017ULL, 0x00000018ff717819ULL, 0x000fe40000011638ULL,
0x0000ffff38737812ULL, 0x000fe200078ec0ffULL, 0x00000014182c723cULL, 0x000fe2000004182cULL,
0x000000ff3a387812ULL, 0x000fe400078ec0ffULL, 0x00000075ff50723eULL, 0x000fe400020006ffULL,
0x00000010ff707819ULL, 0x100fe2000001163aULL, 0x000000161830723cULL, 0x000fe20000041830ULL,
0x00000018ff147819ULL, 0x000fe20000011639ULL, 0x20000050ff507230ULL, 0x000fe20000004100ULL,
0x00000018ff747819ULL, 0x000fc4000001163aULL, 0x00000014ff14723eULL, 0x000fe400020006ffULL,
0x00000010ff167819ULL, 0x000fe4000001166eULL, 0x0000ffff3a6e7812ULL, 0x000fe400078ec0ffULL,
0x00000038ff3a723eULL, 0x000fe200020006ffULL, 0x20000014ff387230ULL, 0x000fe20000004100ULL,
0x00000010ff157819ULL, 0x000fe40000011639ULL, 0x00000071ff71723eULL, 0x000fe200020006ffULL,
0x2000003aff147230ULL, 0x000fe20000004100ULL, 0x000000ff39517812ULL, 0x000fc400078ec0ffULL,
0x0000ffff39727812ULL, 0x000fe200078ec0ffULL, 0x20000071ff397230ULL, 0x000fe20000004100ULL,
0x00000074ff74723eULL, 0x000fe400020006ffULL, 0x000000ff153a7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff737819ULL, 0x000fe40000011673ULL, 0x00000010ff177819ULL, 0x000fe40000011650ULL,
0x00000051ff51723eULL, 0x000fc400020006ffULL, 0x0000003aff71723eULL, 0x000fe200020006ffULL,
0x20000074ff3a7230ULL, 0x000fe20000004100ULL, 0x00000008ff727819ULL, 0x000fe20000011672ULL,
0x20000051ff517230ULL, 0x000fe20000004100ULL, 0x00000073ff73723eULL, 0x000fe400020006ffULL,
0x000000ff70747812ULL, 0x000fe400078ec0ffULL, 0x0000105417167816ULL, 0x000fe40000000016ULL,
0x0000ffff3b177812ULL, 0x000fc400078ec0ffULL, 0x00000072ff70723eULL, 0x000fe200020006ffULL,
0x20000071ff727230ULL, 0x000fe20000004100ULL, 0x00000074ff74723eULL, 0x000fe400020006ffULL,
0x00000008ff717819ULL, 0x000fe2000001166eULL, 0x20000073ff6e7230ULL, 0x000fe20000004100ULL,
0x00000008ff737819ULL, 0x000fe20000011617ULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x00000010ff177819ULL, 0x000fe20000011651ULL, 0x20000074ff517230ULL, 0x000fe20000004100ULL,
0x00000073ff74723eULL, 0x000fc400020006ffULL, 0x00000010ff737819ULL, 0x000fe40000011638ULL,
0x00000010ff507819ULL, 0x000fe4000001163bULL, 0x00000010ff397819ULL, 0x000fe40000011639ULL,
0x00000010ff387819ULL, 0x000fe2000001166eULL, 0x20000074ff6e7230ULL, 0x000fe20000004100ULL,
0x00000010ff707819ULL, 0x000fe40000011670ULL, 0x000000ff3b767812ULL, 0x000fc400078ec0ffULL,
0x000000ff50507812ULL, 0x000fe400078ec0ffULL, 0x0000105439387816ULL, 0x000fe40000000038ULL,
0x00000018ff757819ULL, 0x000fe4000001163bULL, 0x0000105473397816ULL, 0x000fe40000000070ULL,
0x00000076ff76723eULL, 0x000fe400020006ffULL, 0x00000050ff50723eULL, 0x000fc400020006ffULL,
0x00000075ff3b723eULL, 0x000fe200020006ffULL, 0x000000381824723cULL, 0x000fe20000041824ULL,
0x00000071ff71723eULL, 0x000fe200020006ffULL, 0x20000076ff157230ULL, 0x000fe20000004100ULL,
0x00000010ff727819ULL, 0x000fe20000011672ULL, 0x20000050ff507230ULL, 0x000fe20000004100ULL,
0x00000010ff147819ULL, 0x000fe20000011614ULL, 0x2000003bff3b7230ULL, 0x000fe20000004100ULL,
0x0000105472177816ULL, 0x000fe20000000017ULL, 0x000000016a387836ULL, 0x000fe20000000000ULL,
0x00000010ff157819ULL, 0x000fe20000011615ULL, 0x20000071ff717230ULL, 0x000fe20000004100ULL,
0x00000010ff517819ULL, 0x000fc40000011651ULL, 0x00000010ff507819ULL, 0x000fe20000011650ULL,
0x000000161828723cULL, 0x000fe20000041828ULL, 0x000000386200720cULL, 0x000fe40005f66470ULL,
0x00000010ff3a7819ULL, 0x000fe4000001163aULL, 0x00000010ff3b7819ULL, 0x000fe4000001163bULL,
0x00000010ff717819ULL, 0x000fe40000011671ULL, 0x00000010ff6e7819ULL, 0x000fc4000001166eULL,
0x0000105451167816ULL, 0x000fe40000000014ULL, 0x0000105450177816ULL, 0x000fe40000000015ULL,
0x000010543a147816ULL, 0x000fe40000000071ULL, 0x000010543b157816ULL, 0x000fe4000000006eULL,
0x000000386d00720cULL, 0x000fe20006786470ULL, 0x000000161820723cULL, 0x000fec0000041820ULL,
0x00000014181c723cULL, 0x000fe2000004181cULL, 0x00000001ff167424ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000403947ULL, 0x000fde0003000000ULL,
0x0000003c0b0b7221ULL, 0x000fe20000010000ULL, 0x0000003d0a0a7221ULL, 0x000fe20000010000ULL,
0x000000340f0f7221ULL, 0x000fe20000010000ULL, 0x000000350e0e7221ULL, 0x000fe20000010000ULL,
0x0000003041417221ULL, 0x000fe20000010000ULL, 0x0000003142427221ULL, 0x000fe20000010000ULL,
0x0000002c45457221ULL, 0x000fe20000010000ULL, 0x0000002d46467221ULL, 0x000fe20000010000ULL,
0x0000002849497221ULL, 0x000fe20000010000ULL, 0x000000294a4a7221ULL, 0x000fe20000010000ULL,
0x000000244d4d7221ULL, 0x000fe20000010000ULL, 0x000000254e4e7221ULL, 0x000fe20000010000ULL,
0x0000002053537221ULL, 0x000fe20000010000ULL, 0x0000002154547221ULL, 0x000fe20000010000ULL,
0x0000001c57577221ULL, 0x000fe20000010000ULL, 0x0000001d58587221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000012000007945ULL, 0x000fe80003800000ULL,
0x0000000000404947ULL, 0x000fea0002800000ULL, 0x0000003e0d0d7221ULL, 0x000fe20000010000ULL,
0x0000003f0c0c7221ULL, 0x000fe20000010000ULL, 0x0000003611117221ULL, 0x000fe20000010000ULL,
0x0000003740407221ULL, 0x000fe20000010000ULL, 0x0000003243437221ULL, 0x000fe20000010000ULL,
0x0000003344447221ULL, 0x000fe20000010000ULL, 0x0000002e47477221ULL, 0x000fe20000010000ULL,
0x0000002f48487221ULL, 0x000fe20000010000ULL, 0x0000002a4b4b7221ULL, 0x000fe20000010000ULL,
0x0000002b4c4c7221ULL, 0x000fe20000010000ULL, 0x000000264f4f7221ULL, 0x000fe20000010000ULL,
0x0000002752527221ULL, 0x000fe20000010000ULL, 0x0000002255557221ULL, 0x000fe20000010000ULL,
0x0000002356567221ULL, 0x000fe20000010000ULL, 0x0000001e59597221ULL, 0x000fe20000010000ULL,
0x0000001f5a5a7221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x018b8816ff1479a7ULL, 0x000e620008500006ULL, 0x00000002ff177819ULL, 0x000fe40000011638ULL,
0x000000045c007c0cULL, 0x000fe4000bfc3070ULL, 0x0000001738177207ULL, 0x040fe40000000000ULL,
0x00000003381a7812ULL, 0x000fe400078ec0ffULL, 0x000000045c007c0cULL, 0x000fe2000bfa3070ULL,
0x0000000317177836ULL, 0x000fe20000000000ULL, 0x00000040ff387803ULL, 0x000fc40000000000ULL,
0x000000ff1a1a7207ULL, 0x000fe40004000000ULL, 0x00000003171b7812ULL, 0x040fe400078ec0ffULL,
0x00000004171c7c11ULL, 0x000fe2000f8ff0ffULL, 0x000000ffff187224ULL, 0x002fce00078e0015ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x018b806bff0075a7ULL, 0x000e6400080c0146ULL,
0x00000000005c6947ULL, 0x002fea0003800000ULL, 0x000000ffff1d7224ULL, 0x000fce00078e00ffULL,
0x000000101d00780cULL, 0x000fda0003fc6270ULL, 0x000000000044e947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x0000001416197210ULL, 0x000fca0007fde1ffULL,
0x0000000115157824ULL, 0x000fe200030e0e17ULL, 0x003d09001900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x000000000008e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x00000000001ce947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001914147211ULL, 0x000fca00078d10ffULL, 0x000000ffff157224ULL, 0x000fca00030e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011d1d7836ULL, 0x000fce0000000000ULL,
0x018b806bff0075a7ULL, 0x000e6400080c0146ULL, 0xfffffffc00a8e947ULL, 0x002fea000383ffffULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x018b8818ff0075a7ULL, 0x000e6400080c0146ULL,
0x00000000005c6947ULL, 0x002fea0003800000ULL, 0x000000ffff1d7224ULL, 0x000fce00078e00ffULL,
0x000000101d00780cULL, 0x000fda0003fc6270ULL, 0x000000000044e947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x0000001416197210ULL, 0x000fca0007fde1ffULL,
0x0000000115157824ULL, 0x000fe200030e0e17ULL, 0x003d09001900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x000000000008e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x00000000001ce947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001914147211ULL, 0x000fca00078d10ffULL, 0x000000ffff157224ULL, 0x000fca00030e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011d1d7836ULL, 0x000fce0000000000ULL,
0x018b8818ff0075a7ULL, 0x000e6400080c0146ULL, 0xfffffffc00a8e947ULL, 0x002fea000383ffffULL,
0x000000011c147836ULL, 0x000fca0000000000ULL, 0x0000001014007c0cULL, 0x000fda000bfc6070ULL,
0x00000004005ce947ULL, 0x000fea0003800000ULL, 0x000000015b1d7824ULL, 0x000fe200078e026cULL,
0x00014000060b7890ULL, 0x000fe2000fffe03fULL, 0x0000001010187824ULL, 0x000fe400078e00ffULL,
0x0000004013217824ULL, 0x000fe200078e021dULL, 0x000000061d1f7c11ULL, 0x040fe2000f8e10ffULL,
0x000000101d1e7824ULL, 0x000fe200078e00ffULL, 0x000000f018237812ULL, 0x000fe200078ec0ffULL,
0x000000041c187824ULL, 0x000fe400078e021bULL, 0x018a00001f147984ULL, 0x000e620000000800ULL,
0x000000026c207836ULL, 0x000fc40000000000ULL, 0x0000004018187824ULL, 0x000fe400078e00ffULL,
0x000000015b277824ULL, 0x000fe200078e0220ULL, 0x0000000614197c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e660000000a00ULL, 0x018ac00019167984ULL, 0x0007240000000800ULL,
0x0000000d18197c48ULL, 0x008fca000ffe0000ULL, 0x0000000119187824ULL, 0x000fe400078e0a18ULL,
0x000000011d197824ULL, 0x000fc600078e0210ULL, 0x000000185b187248ULL, 0x000fe40007fe0000ULL,
0xfffffff01e197812ULL, 0x000fc600078ee219ULL, 0x00000001181d7824ULL, 0x000fe200078e0a5bULL,
0x0000000b19257c11ULL, 0x000fe2000f8e20ffULL, 0x0000000221197836ULL, 0x000fe40000000000ULL,
0x0000000816177c24ULL, 0x010fc8000f8e0221ULL, 0x0000010017167825ULL, 0x002fc600078e0014ULL,
0x0000002316167210ULL, 0x000fca0007fde0ffULL, 0x000000ffff177224ULL, 0x000fe200030e0617ULL,
0x0000001d6c00720cULL, 0x000fda0003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016257faeULL, 0x0003e8000f101c4eULL, 0x018a08001f187984ULL, 0x000ee20000000800ULL,
0x0000000127167824ULL, 0x042fe400078e0210ULL, 0x0000001027277824ULL, 0x000fe400078e00ffULL,
0x0000000421177836ULL, 0x000fc60000000000ULL, 0xfffffff027167812ULL, 0x000fc800078ee216ULL,
0x0000000b16257c11ULL, 0x000fe4000f8e20ffULL, 0x00000006181e7c11ULL, 0x008fca000f8e10ffULL,
0x018ac0001e187984ULL, 0x000e640000000800ULL, 0x0000000818197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000002318187210ULL, 0x000fca0007fde0ffULL,
0x000000ffff197224ULL, 0x000fe200030e0619ULL, 0x0000001d2000720cULL, 0x000fe20003fc6070ULL,
0x000000046c207836ULL, 0x000fe40000000000ULL, 0x000000066c6c7836ULL, 0x000fe40000000000ULL,
0x000000015b277824ULL, 0x000fd000078e0220ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018257faeULL, 0x0003e8000f101c4eULL, 0x018a10001f167984ULL, 0x000ee20000000800ULL,
0x0000000127187824ULL, 0x042fe400078e0210ULL, 0x0000001027277824ULL, 0x000fe400078e00ffULL,
0x0000000621197836ULL, 0x000fc60000000000ULL, 0xfffffff027187812ULL, 0x000fc800078ee218ULL,
0x0000000b18257c11ULL, 0x000fe4000f8e20ffULL, 0x00000006161e7c11ULL, 0x008fca000f8e10ffULL,
0x018ac0001e167984ULL, 0x000e640000000800ULL, 0x0000000816177c24ULL, 0x002fc8000f8e0217ULL,
0x0000010017167825ULL, 0x000fc600078e0014ULL, 0x0000002316167210ULL, 0x000fca0007fde0ffULL,
0x000000ffff177224ULL, 0x000fe200030e0617ULL, 0x0000001d2000720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016257faeULL, 0x0003e8000f101c4eULL,
0x018a18001f187984ULL, 0x000ee40000000800ULL, 0x0000000618187c11ULL, 0x008fcc000f8e10ffULL,
0x018ac00018187984ULL, 0x000ee40000000800ULL, 0x0000000818197c24ULL, 0x008fc8000f8e0219ULL,
0x0000010019147825ULL, 0x000fc800078e0014ULL, 0x000000015b197824ULL, 0x000fe200078e026cULL,
0x0000002314147210ULL, 0x000fc60007fde0ffULL, 0x0000000119167824ULL, 0x042fe400078e0210ULL,
0x000000ffff157224ULL, 0x000fe200030e0615ULL, 0x0000001d6c00720cULL, 0x000fe20003fc6070ULL,
0x0000001019197824ULL, 0x000fca00078e00ffULL, 0xfffffff019167812ULL, 0x000fc800078ee216ULL,
0x0000000b16177c11ULL, 0x000fca000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014177faeULL, 0x0003e2000f101c4eULL, 0x0000000400247947ULL, 0x000fea0003800000ULL,
0x000000015b6c7824ULL, 0x000fe200078e026cULL, 0x00014000060b7890ULL, 0x000fe2000fffe03fULL,
0x0000001010197824ULL, 0x000fe400078e00ffULL, 0x00000040131f7824ULL, 0x000fe200078e026cULL,
0x000000066c1e7c11ULL, 0x040fe2000f8e10ffULL, 0x000000106c207824ULL, 0x040fe200078e00ffULL,
0x000000f019217812ULL, 0x000fe200078ec0ffULL, 0x000000016c197824ULL, 0x000fe400078e0210ULL,
0x018a00001e147984ULL, 0x000e620000000800ULL, 0x000000026c257836ULL, 0x000fc40000000000ULL,
0xfffffff020197812ULL, 0x000fe400078ee219ULL, 0x0000000125207824ULL, 0x000fe400078e0210ULL,
0x0000000b19237c11ULL, 0x000fe2000f8e20ffULL, 0x000000021f197836ULL, 0x000fe40000000000ULL,
0x0000001025257824ULL, 0x000fca00078e00ffULL, 0xfffffff025207812ULL, 0x000fe200078ee220ULL,
0x000000046c257836ULL, 0x000fe20000000000ULL, 0x0000000614187c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e660000000a00ULL, 0x018ac00018167984ULL, 0x000ee40000000800ULL,
0x0000000816177c24ULL, 0x008fc8000f8e021fULL, 0x0000010017167825ULL, 0x002fc600078e0014ULL,
0x0000002116167210ULL, 0x000fca0007fde0ffULL, 0x000000ffff177224ULL, 0x000fca00030e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e8000b901c4eULL,
0x018a08001e187984ULL, 0x000ee20000000800ULL, 0x0000000b20237c11ULL, 0x002fe2000f8e20ffULL,
0x000000041f177836ULL, 0x000fe40000000000ULL, 0x0000000125207824ULL, 0x040fe400078e0210ULL,
0x0000001025257824ULL, 0x000fca00078e00ffULL, 0xfffffff025207812ULL, 0x000fe400078ee220ULL,
0x00000006181d7c11ULL, 0x008fca000f8e10ffULL, 0x018ac0001d187984ULL, 0x000e640000000800ULL,
0x0000000818197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000002118187210ULL, 0x000fca0007fde0ffULL, 0x000000ffff197224ULL, 0x000fca00030e0619ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018237faeULL, 0x0003e8000b901c4eULL,
0x018a10001e167984ULL, 0x000ee20000000800ULL, 0x0000000b20237c11ULL, 0x002fe2000f8e20ffULL,
0x000000061f197836ULL, 0x000fe20000000000ULL, 0x00000006161d7c11ULL, 0x008fca000f8e10ffULL,
0x018ac0001d167984ULL, 0x000e640000000800ULL, 0x0000000816177c24ULL, 0x002fc8000f8e0217ULL,
0x0000010017167825ULL, 0x000fc600078e0014ULL, 0x0000002116167210ULL, 0x000fca0007fde0ffULL,
0x000000ffff177224ULL, 0x000fca00030e0617ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0003e8000b901c4eULL, 0x018a18001e187984ULL, 0x000ee40000000800ULL,
0x0000000618187c11ULL, 0x008fcc000f8e10ffULL, 0x018ac00018187984ULL, 0x000ee40000000800ULL,
0x0000000818197c24ULL, 0x008fc8000f8e0219ULL, 0x0000010019147825ULL, 0x000fc800078e0014ULL,
0x000000066c197836ULL, 0x000fe20000000000ULL, 0x0000002114147210ULL, 0x000fc60007fde0ffULL,
0x00000001191d7824ULL, 0x040fe400078e0210ULL, 0x0000001019167824ULL, 0x002fe400078e00ffULL,
0x000000ffff157224ULL, 0x000fc600030e0615ULL, 0xfffffff0161d7812ULL, 0x000fc800078ee21dULL,
0x0000000b1d1d7c11ULL, 0x000fca000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000141d7faeULL, 0x0003e4000b901c4eULL, 0x00000001ff147424ULL, 0x002fcc00078e00ffULL,
0x018b8814ff1479a7ULL, 0x000e640008500006ULL, 0x000000ffff187224ULL, 0x002fce00078e0015ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x018b8818ff0075a7ULL, 0x000e6400080c0146ULL,
0x00000000005c6947ULL, 0x002fea0003800000ULL, 0x000000ffff1d7224ULL, 0x000fce00078e00ffULL,
0x000000101d00780cULL, 0x000fda0003fc6270ULL, 0x000000000044e947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x0000001416197210ULL, 0x000fca0007fde1ffULL,
0x0000000115157824ULL, 0x000fe200030e0e17ULL, 0x003d09001900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x000000000008e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x00000000001ce947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001914147211ULL, 0x000fca00078d10ffULL, 0x000000ffff157224ULL, 0x000fca00030e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011d1d7836ULL, 0x000fce0000000000ULL,
0x018b8818ff0075a7ULL, 0x000e6400080c0146ULL, 0xfffffffc00a8e947ULL, 0x002fea000383ffffULL,
0x0000019000007945ULL, 0x000fe20003800000ULL, 0x00000001ff6e7424ULL, 0x000fc600078e00ffULL,
0x0000000000581947ULL, 0x000fea0003800000ULL, 0x0000001c5c00720cULL, 0x000fe20003fc4070ULL,
0x00009400000b7ab9ULL, 0x000fc60000000800ULL, 0x000000ff1a147207ULL, 0x040fe40003000000ULL,
0x000000ff1a1a7207ULL, 0x000fc60007000000ULL, 0x000000011b1b7824ULL, 0x000fe400078e0214ULL,
0x00009200ff147b82ULL, 0x000e620000000a00ULL, 0x000000015d177824ULL, 0x000fe400078e021aULL,
0x000000401b167824ULL, 0x040fe200078e00ffULL, 0x0000001c1b1b7211ULL, 0x000fc800078ff0ffULL,
0x000000c016167812ULL, 0x000fca00078ec0ffULL, 0x000001001b167824ULL, 0x000fc800078e0216ULL,
0x0000002016187836ULL, 0x000fc80000000000ULL, 0x0000000b17167c24ULL, 0x000fc8000f8e0218ULL,
0x000000016f177824ULL, 0x040fe400078e0216ULL, 0x000000016f167824ULL, 0x040fe200078e0218ULL,
0x000000066f6f7c11ULL, 0x000fe2000f8e10ffULL, 0x0000000417147825ULL, 0x002fc600078e0014ULL,
0x0000000d16007c0cULL, 0x000fda000bfc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x18a00000146f7faeULL, 0x0003e4000f12184eULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a49ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x018b786eff6e79a7ULL, 0x000e620008500006ULL,
0x0000000000102947ULL, 0x000fea0003800000ULL, 0x00000006ff03723eULL, 0x000fc800000010ffULL,
0x0000541003147816ULL, 0x000fca0000000003ULL, 0x00001f6d14047589ULL, 0x0044e800000e0000ULL,
0x00001f6214037589ULL, 0x00046400000e0000ULL, 0x013800006530783bULL, 0x0006a20000000200ULL,
0x0000000000102947ULL, 0x000fea0003800000ULL, 0x0000000330307232ULL, 0x086fe40000200000ULL,
0x0000000332327232ULL, 0x000fe40000200000ULL, 0x0000000431317232ULL, 0x088fe40000200000ULL,
0x0000000433337232ULL, 0x000fce0000200000ULL, 0x000000006414783bULL, 0x004ea80000004200ULL,
0x000000006318783bULL, 0x000f220000004200ULL, 0x0000ffff16277812ULL, 0x044fe400078ec0ffULL,
0x000000ff16227812ULL, 0x000fe400078ec0ffULL, 0x00000008ff277819ULL, 0x000fe40000011627ULL,
0x00000018ff207819ULL, 0x000fc40000011616ULL, 0x00000010ff2a7819ULL, 0x010fe40000011618ULL,
0x00000022ff22723eULL, 0x000fe400020006ffULL, 0x00000010ff367819ULL, 0x000fe40000011614ULL,
0x0000ffff14377812ULL, 0x000fe400078ec0ffULL, 0x00000010ff347819ULL, 0x000fe40000011615ULL,
0x00000018ff3b7819ULL, 0x000fc4000001161aULL, 0x00000027ff27723eULL, 0x000fe400020006ffULL,
0x00000010ff287819ULL, 0x000fe40000011617ULL, 0x00000010ff217819ULL, 0x100fe40000011619ULL,
0x000000ff193a7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff397819ULL, 0x000fe40000011619ULL,
0x0000ffff19297812ULL, 0x000fc400078ec0ffULL, 0x0000ffff172b7812ULL, 0x000fe400078ec0ffULL,
0x00000020ff19723eULL, 0x000fe200020006ffULL, 0x20000022ff207230ULL, 0x000fe20000004100ULL,
0x000000ff2a2a7812ULL, 0x000fe400078ec0ffULL, 0x000000ff141d7812ULL, 0x000fe200078ec0ffULL,
0x20000019ff197230ULL, 0x000fe20000004100ULL, 0x000000ff36367812ULL, 0x000fe400078ec0ffULL,
0x00000008ff377819ULL, 0x000fc40000011637ULL, 0x000000ff151f7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff1a247812ULL, 0x000fe400078ec0ffULL, 0x0000003bff22723eULL, 0x000fe200020006ffULL,
0x20000027ff3b7230ULL, 0x000fe20000004100ULL, 0x000000ff34347812ULL, 0x000fe400078ec0ffULL,
0x000000ff28287812ULL, 0x000fe200078ec0ffULL, 0x20000022ff227230ULL, 0x000fe20000004100ULL,
0x00000018ff1c7819ULL, 0x000fc40000011614ULL, 0x0000ffff15357812ULL, 0x000fe400078ec0ffULL,
0x00000008ff2b7819ULL, 0x000fe4000001162bULL, 0x0000002aff2a723eULL, 0x000fe400020006ffULL,
0x000000ff21277812ULL, 0x000fe400078ec0ffULL, 0x00000018ff1e7819ULL, 0x000fe20000011615ULL,
0x2000002aff217230ULL, 0x000fe20000004100ULL, 0x00000010ff2f7819ULL, 0x000fc40000011616ULL,
0x0000001dff14723eULL, 0x000fe400020006ffULL, 0x00000036ff36723eULL, 0x000fe400020006ffULL,
0x00000037ff37723eULL, 0x000fe200020006ffULL, 0x20000014ff147230ULL, 0x000fe20000004100ULL,
0x000000ff17237812ULL, 0x000fe200078ec0ffULL, 0x20000036ff367230ULL, 0x000fe20000004100ULL,
0x00000018ff167819ULL, 0x000fe40000011617ULL, 0x00000010ff257819ULL, 0x000fc4000001161bULL,
0x0000ffff1b157812ULL, 0x000fe400078ec0ffULL, 0x0000001fff1f723eULL, 0x000fe400020006ffULL,
0x00000034ff34723eULL, 0x000fe400020006ffULL, 0x00000008ff247819ULL, 0x000fe20000011624ULL,
0x2000001fff2d7230ULL, 0x000fe20000004100ULL, 0x000000ff18267812ULL, 0x000fe400078ec0ffULL,
0x00000018ff177819ULL, 0x000fc40000011618ULL, 0x0000ffff182e7812ULL, 0x000fe400078ec0ffULL,
0x00000028ff28723eULL, 0x000fe400020006ffULL, 0x00000010ff187819ULL, 0x000fe4000001161aULL,
0x000000ff1a3c7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff357819ULL, 0x000fe40000011635ULL,
0x0000002bff2b723eULL, 0x000fc400020006ffULL, 0x00000027ff27723eULL, 0x000fe400020006ffULL,
0x00000039ff1a723eULL, 0x000fe200020006ffULL, 0x20000037ff397230ULL, 0x000fe20000004100ULL,
0x000000ff2f2f7812ULL, 0x000fe200078ec0ffULL, 0x20000034ff377230ULL, 0x000fe20000004100ULL,
0x000000ff1b3e7812ULL, 0x000fe200078ec0ffULL, 0x2000001aff1a7230ULL, 0x000fe20000004100ULL,
0x00000018ff3d7819ULL, 0x000fe4000001161bULL, 0x000000ff252a7812ULL, 0x000fe200078ec0ffULL,
0x20000027ff257230ULL, 0x000fe20000004100ULL, 0x00000024ff24723eULL, 0x000fc400020006ffULL,
0x00000008ff157819ULL, 0x000fe40000011615ULL, 0x0000001cff1c723eULL, 0x000fe400020006ffULL,
0x0000003aff1b723eULL, 0x000fe200020006ffULL, 0x20000028ff3a7230ULL, 0x000fe20000004100ULL,
0x0000001eff1e723eULL, 0x000fe200020006ffULL, 0x2000002bff287230ULL, 0x000fe20000004100ULL,
0x00000023ff1d723eULL, 0x000fe200020006ffULL, 0x2000001cff2c7230ULL, 0x000fe20000004100ULL,
0x00000035ff35723eULL, 0x000fe200020006ffULL, 0x2000001eff1c7230ULL, 0x000fe20000004100ULL,
0x00000016ff16723eULL, 0x000fe200020006ffULL, 0x2000001dff1d7230ULL, 0x000fe20000004100ULL,
0x0000002fff34723eULL, 0x000fe200020006ffULL, 0x20000035ff2f7230ULL, 0x000fe20000004100ULL,
0x00000026ff26723eULL, 0x000fe200020006ffULL, 0x20000016ff1f7230ULL, 0x000fe20000004100ULL,
0x0000002aff27723eULL, 0x000fe200020006ffULL, 0x20000024ff2a7230ULL, 0x000fe20000004100ULL,
0x00000015ff2b723eULL, 0x000fe200020006ffULL, 0x20000034ff347230ULL, 0x000fe20000004100ULL,
0x00000008ff2e7819ULL, 0x000fe2000001162eULL, 0x20000026ff167230ULL, 0x000fe20000004100ULL,
0x00000010ff147819ULL, 0x000fe20000011614ULL, 0x2000001bff1b7230ULL, 0x000fe20000004100ULL,
0x00000010ff157819ULL, 0x000fe20000011636ULL, 0x20000027ff277230ULL, 0x000fe20000004100ULL,
0x00000010ff2d7819ULL, 0x000fe2000001162dULL, 0x2000002bff2b7230ULL, 0x000fe20000004100ULL,
0x00000010ff247819ULL, 0x000fc40000011637ULL, 0x00000017ff17723eULL, 0x000fe400020006ffULL,
0x0000002eff2e723eULL, 0x000fe400020006ffULL, 0x0000105415147816ULL, 0x000fe20000000014ULL,
0x20000017ff177230ULL, 0x000fe20000004100ULL, 0x0000003dff26723eULL, 0x000fe200020006ffULL,
0x2000002eff357230ULL, 0x000fe20000004100ULL, 0x0000105424157816ULL, 0x000fe4000000002dULL,
0x000000ff18187812ULL, 0x000fe200078ec0ffULL, 0x20000026ff267230ULL, 0x000fe20000004100ULL,
0x00000010ff3d7819ULL, 0x000fc4000001162cULL, 0x00000010ff247819ULL, 0x000fe40000011619ULL,
0x00000010ff1c7819ULL, 0x000fe4000001161cULL, 0x00000010ff2c7819ULL, 0x000fe4000001161dULL,
0x00000010ff197819ULL, 0x000fe4000001162fULL, 0x00000010ff207819ULL, 0x000fe40000011620ULL,
0x00000010ff1d7819ULL, 0x000fc40000011634ULL, 0x00000010ff2d7819ULL, 0x000fe4000001163aULL,
0x0000003cff1e723eULL, 0x000fe400020006ffULL, 0x00000008ff297819ULL, 0x000fe40000011629ULL,
0x00000018ff18723eULL, 0x000fe200020006ffULL, 0x2000001eff1e7230ULL, 0x000fe20000004100ULL,
0x00000010ff3b7819ULL, 0x000fe4000001163bULL, 0x000010541c197816ULL, 0x000fe20000000019ULL,
0x20000018ff2e7230ULL, 0x000fe20000004100ULL, 0x000010541d1c7816ULL, 0x000fc40000000020ULL,
0x000010542d1d7816ULL, 0x000fe4000000002cULL, 0x00000010ff1f7819ULL, 0x000fe4000001161fULL,
0x00000010ff287819ULL, 0x000fe40000011628ULL, 0x00000029ff29723eULL, 0x000fe400020006ffULL,
0x0000105424207816ULL, 0x000fe4000000003bULL, 0x00000010ff2c7819ULL, 0x000fe20000011617ULL,
0x20000029ff297230ULL, 0x000fe20000004100ULL, 0x00000010ff357819ULL, 0x000fc40000011635ULL,
0x00000010ff247819ULL, 0x000fe40000011616ULL, 0x00000010ff2d7819ULL, 0x000fe20000011621ULL,
0x000000143014723cULL, 0x000fe200000418ffULL, 0x0000003eff23723eULL, 0x000fe400020006ffULL,
0x000010541f217816ULL, 0x000fe40000000028ULL, 0x000010542c287816ULL, 0x000fe20000000035ULL,
0x20000023ff237230ULL, 0x000fe20000004100ULL, 0x000010542d247816ULL, 0x000fc40000000024ULL,
0x00000010ff1f7819ULL, 0x000fe4000001161bULL, 0x00000010ff2c7819ULL, 0x000fe40000011625ULL,
0x00000010ff2d7819ULL, 0x000fe4000001161eULL, 0x00000010ff2e7819ULL, 0x000fe4000001162eULL,
0x000010542c257816ULL, 0x000fe4000000001fULL, 0x00000010ff347819ULL, 0x000fe2000001161aULL,
0x0000001c301c723cULL, 0x000fe200000418ffULL, 0x00000010ff297819ULL, 0x000fc40000011629ULL,
0x000010542e2c7816ULL, 0x000fe4000000002dULL, 0x00000010ff2d7819ULL, 0x000fe40000011622ULL,
0x00000010ff2a7819ULL, 0x000fe4000001162aULL, 0x00000010ff187819ULL, 0x000fe40000011639ULL,
0x00000010ff2e7819ULL, 0x000fe40000011623ULL, 0x00000010ff277819ULL, 0x000fe20000011627ULL,
0x000000203020723cULL, 0x000fe200000418ffULL, 0x00000010ff367819ULL, 0x000fc40000011626ULL,
0x00000010ff2b7819ULL, 0x000fe4000001162bULL, 0x0000105434297816ULL, 0x000fe40000000029ULL,
0x000010542d347816ULL, 0x000fe4000000002aULL, 0x000010543d187816ULL, 0x000fe40000000018ULL,
0x00001054272d7816ULL, 0x000fe4000000002eULL, 0x0000105436357816ULL, 0x000fe2000000002bULL,
0x000000243024723cULL, 0x000fec00000418ffULL, 0x000000183018723cULL, 0x000fec00000418ffULL,
0x000000283028723cULL, 0x000fec00000418ffULL, 0x0000002c302c723cULL, 0x000fec00000418ffULL,
0x000000343030723cULL, 0x000fe200000418ffULL, 0x013800006634783bULL, 0x0004e20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000102947ULL, 0x000fde0003800000ULL,
0x0000000334347232ULL, 0x08afe40000200000ULL, 0x0000000336367232ULL, 0x000fe40000200000ULL,
0x0000000435357232ULL, 0x080fe40000200000ULL, 0x0000000437377232ULL, 0x000fce0000200000ULL,
0x000000ff3800720cULL, 0x000fe20003f45270ULL, 0x00000bd000007945ULL, 0x000fe20003800000ULL,
0x000000006838783bULL, 0x000f240000004200ULL, 0x000000ff383c7812ULL, 0x010fe400078ec0ffULL,
0x000000ff393e7812ULL, 0x000fe400078ec0ffULL, 0x0000003cff3c723eULL, 0x000fe400020006ffULL,
0x00000018ff3d7819ULL, 0x000fc40000011638ULL, 0x0000003eff3f723eULL, 0x000fe200020006ffULL,
0x2000003cff507230ULL, 0x000fe20000004100ULL, 0x0000003dff3e723eULL, 0x000fe400020006ffULL,
0x00000010ff3c7819ULL, 0x000fe20000011638ULL, 0x2000003fff707230ULL, 0x000fe20000004100ULL,
0x00000010ff3d7819ULL, 0x000fe20000011639ULL, 0x2000003eff6c7230ULL, 0x000fe20000004100ULL,
0x0000ffff38387812ULL, 0x000fe400078ec0ffULL, 0x000000ff3d3f7812ULL, 0x000fc400078ec0ffULL,
0x000000ff3c3c7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff3d7819ULL, 0x000fe40000011638ULL,
0x0000003cff38723eULL, 0x000fe400020006ffULL, 0x0000003fff6b723eULL, 0x000fe400020006ffULL,
0x0000003dff51723eULL, 0x000fe200020006ffULL, 0x20000038ff387230ULL, 0x000fe20000004100ULL,
0x00000000673c783bULL, 0x000f220000004200ULL, 0x2000006bff717230ULL, 0x000fe20000004100ULL,
0x00000018ff6d7819ULL, 0x000fe20000011639ULL, 0x20000051ff6b7230ULL, 0x000fe20000004100ULL,
0x0000ffff39727812ULL, 0x000fc400078ec0ffULL, 0x00000010ff507819ULL, 0x000fe40000011650ULL,
0x00000010ff517819ULL, 0x000fe40000011638ULL, 0x0000006dff39723eULL, 0x000fe400020006ffULL,
0x00000010ff707819ULL, 0x000fe40000011670ULL, 0x00000010ff717819ULL, 0x000fe40000011671ULL,
0x00000010ff6d7819ULL, 0x000fc4000001166cULL, 0x00000010ff387819ULL, 0x000fe4000001166bULL,
0x00000008ff727819ULL, 0x000fe40000011672ULL, 0x0000105451507816ULL, 0x000fe40000000050ULL,
0x0000105471517816ULL, 0x000fe40000000070ULL, 0x000010546d387816ULL, 0x000fe40000000038ULL,
0x00000010ff717819ULL, 0x000fc4000001163aULL, 0x000000ff3a6d7812ULL, 0x000fe200078ec0ffULL,
0x000000503414723cULL, 0x008fe20000041814ULL, 0x00000072ff6b723eULL, 0x000fe400020006ffULL,
0x000000ff71717812ULL, 0x000fe400078ec0ffULL, 0x0000006dff73723eULL, 0x000fe200020006ffULL,
0x20000039ff6d7230ULL, 0x000fe20000004100ULL, 0x00000018ff727819ULL, 0x000fe2000001163aULL,
0x2000006bff397230ULL, 0x000fe20000004100ULL, 0x00000071ff71723eULL, 0x000fe200020006ffULL,
0x20000073ff737230ULL, 0x000fe20000004100ULL, 0x00000072ff6b723eULL, 0x000fc400020006ffULL,
0x0000ffff3a6c7812ULL, 0x000fe200078ec0ffULL, 0x20000071ff717230ULL, 0x000fe20000004100ULL,
0x00000010ff727819ULL, 0x000fe2000001166dULL, 0x2000006bff6b7230ULL, 0x000fe20000004100ULL,
0x00000010ff397819ULL, 0x000fe40000011639ULL, 0x00000010ff3a7819ULL, 0x000fe4000001163bULL,
0x0000105472397816ULL, 0x000fe40000000039ULL, 0x000000ff3b747812ULL, 0x000fc400078ec0ffULL,
0x000000ff3a727812ULL, 0x000fe400078ec0ffULL, 0x00000010ff3a7819ULL, 0x000fe20000011673ULL,
0x000000383418723cULL, 0x000fe20000041818ULL, 0x00000010ff717819ULL, 0x000fe40000011671ULL,
0x00000018ff707819ULL, 0x000fe4000001163bULL, 0x00000074ff74723eULL, 0x000fe400020006ffULL,
0x0000ffff3b3b7812ULL, 0x000fc400078ec0ffULL, 0x00001054713a7816ULL, 0x000fe2000000003aULL,
0x20000074ff6d7230ULL, 0x000fe20000004100ULL, 0x00000010ff717819ULL, 0x010fe4000001163cULL,
0x00000008ff6c7819ULL, 0x000fe4000001166cULL, 0x00000008ff3b7819ULL, 0x000fe4000001163bULL,
0x000000ff3c747812ULL, 0x000fe400078ec0ffULL, 0x000000ff71767812ULL, 0x000fc400078ec0ffULL,
0x00000072ff72723eULL, 0x000fe400020006ffULL, 0x00000070ff70723eULL, 0x000fe400020006ffULL,
0x0000006cff6c723eULL, 0x000fe200020006ffULL, 0x20000072ff737230ULL, 0x000fe20000004100ULL,
0x0000003bff75723eULL, 0x000fe200020006ffULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x00000074ff74723eULL, 0x000fe200020006ffULL, 0x2000006cff727230ULL, 0x000fe20000004100ULL,
0x00000076ff76723eULL, 0x000fe200020006ffULL, 0x20000075ff507230ULL, 0x000fe20000004100ULL,
0x00000010ff3b7819ULL, 0x000fe2000001166dULL, 0x20000074ff717230ULL, 0x000fe20000004100ULL,
0x00000010ff747819ULL, 0x000fe20000011673ULL, 0x20000076ff517230ULL, 0x000fe20000004100ULL,
0x00000010ff6b7819ULL, 0x000fc4000001166bULL, 0x00000010ff6d7819ULL, 0x000fe40000011670ULL,
0x00000010ff727819ULL, 0x000fe40000011672ULL, 0x00000010ff387819ULL, 0x000fe40000011650ULL,
0x00000018ff397819ULL, 0x000fe4000001163cULL, 0x00000010ff717819ULL, 0x000fe40000011671ULL,
0x00000010ff707819ULL, 0x000fc40000011651ULL, 0x00001054743b7816ULL, 0x000fe4000000003bULL,
0x000010546b507816ULL, 0x000fe40000000072ULL, 0x000010546d517816ULL, 0x000fe40000000038ULL,
0x00000039ff39723eULL, 0x000fe200020006ffULL, 0x0000003a341c723cULL, 0x000fe2000004181cULL,
0x0000105470387816ULL, 0x000fe40000000071ULL, 0x000000ff3e6b7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff707819ULL, 0x100fe2000001163eULL, 0x000000503420723cULL, 0x000fe20000041820ULL,
0x00000018ff727819ULL, 0x000fe4000001163eULL, 0x0000ffff3e6d7812ULL, 0x000fe400078ec0ffULL,
0x000000ff3f3e7812ULL, 0x000fe400078ec0ffULL, 0x0000006bff73723eULL, 0x000fe200020006ffULL,
0x20000039ff6b7230ULL, 0x000fe20000004100ULL, 0x00000018ff3a7819ULL, 0x000fc4000001163dULL,
0x00000010ff3b7819ULL, 0x000fe4000001163dULL, 0x0000003eff39723eULL, 0x000fe400020006ffULL,
0x000000ff3d6c7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff3c3c7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff757819ULL, 0x000fe4000001163fULL, 0x0000003aff3a723eULL, 0x000fc400020006ffULL,
0x00000072ff74723eULL, 0x000fe400020006ffULL, 0x00000010ff717819ULL, 0x000fe2000001163fULL,
0x2000003aff3e7230ULL, 0x000fe20000004100ULL, 0x000000ff3b727812ULL, 0x000fe200078ec0ffULL,
0x20000039ff3b7230ULL, 0x000fe20000004100ULL, 0x0000006cff6c723eULL, 0x000fe200020006ffULL,
0x20000073ff3a7230ULL, 0x000fe20000004100ULL, 0x0000ffff3d3d7812ULL, 0x000fe400078ec0ffULL,
0x00000075ff75723eULL, 0x000fe200020006ffULL, 0x2000006cff6c7230ULL, 0x000fe20000004100ULL,
0x00000008ff397819ULL, 0x000fe2000001163cULL, 0x20000074ff3c7230ULL, 0x000fe20000004100ULL,
0x000000ff71717812ULL, 0x000fc400078ec0ffULL, 0x0000ffff3f3f7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff737819ULL, 0x000fe2000001163dULL, 0x20000075ff3d7230ULL, 0x000fe20000004100ULL,
0x00000039ff39723eULL, 0x000fe400020006ffULL, 0x000000ff70707812ULL, 0x000fe400078ec0ffULL,
0x00000072ff72723eULL, 0x000fe400020006ffULL, 0x00000071ff75723eULL, 0x000fc400020006ffULL,
0x00000070ff74723eULL, 0x000fe200020006ffULL, 0x20000039ff707230ULL, 0x000fe20000004100ULL,
0x00000008ff6d7819ULL, 0x000fe2000001166dULL, 0x20000072ff727230ULL, 0x000fe20000004100ULL,
0x00000008ff3f7819ULL, 0x000fe2000001163fULL, 0x20000074ff747230ULL, 0x000fe20000004100ULL,
0x00000010ff397819ULL, 0x000fe2000001166cULL, 0x20000075ff6c7230ULL, 0x000fe20000004100ULL,
0x00000073ff73723eULL, 0x000fe400020006ffULL, 0x0000006dff6d723eULL, 0x000fc400020006ffULL,
0x0000003fff75723eULL, 0x000fe200020006ffULL, 0x20000073ff717230ULL, 0x000fe20000004100ULL,
0x00000010ff727819ULL, 0x000fe20000011672ULL, 0x2000006dff6d7230ULL, 0x000fe20000004100ULL,
0x00000010ff3f7819ULL, 0x000fe2000001166bULL, 0x20000075ff6b7230ULL, 0x000fe20000004100ULL,
0x0000105472397816ULL, 0x000fe40000000039ULL, 0x00000010ff727819ULL, 0x000fe4000001163eULL,
0x00000010ff3e7819ULL, 0x000fc40000011670ULL, 0x00000010ff517819ULL, 0x000fe2000001163cULL,
0x000000383424723cULL, 0x000fe20000041824ULL, 0x00000010ff507819ULL, 0x000fe4000001163dULL,
0x00000010ff3a7819ULL, 0x000fe4000001163aULL, 0x00000010ff717819ULL, 0x000fe40000011671ULL,
0x00000010ff737819ULL, 0x000fe40000011674ULL, 0x00000010ff3b7819ULL, 0x000fc4000001163bULL,
0x00000010ff6c7819ULL, 0x000fe4000001166cULL, 0x00000010ff3c7819ULL, 0x000fe4000001166dULL,
0x00000010ff3d7819ULL, 0x000fe4000001166bULL, 0x000010543f3e7816ULL, 0x000fe4000000003eULL,
0x00001054723f7816ULL, 0x000fe40000000071ULL, 0x00001054733a7816ULL, 0x000fc4000000003aULL,
0x000010546c3b7816ULL, 0x000fe4000000003bULL, 0x00001054513c7816ULL, 0x000fe2000000003cULL,
0x0000003e3428723cULL, 0x000fe20000041828ULL, 0x00001054503d7816ULL, 0x000fca000000003dULL,
0x0000003a342c723cULL, 0x000fec000004182cULL, 0x0000003c3430723cULL, 0x000fe20000041830ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000403947ULL, 0x000fde0001000000ULL,
0x000000140b0b7221ULL, 0x000fe20000010000ULL, 0x000000150a0a7221ULL, 0x000fe20000010000ULL,
0x000000180f0f7221ULL, 0x000fe20000010000ULL, 0x000000190e0e7221ULL, 0x000fe20000010000ULL,
0x0000001c41417221ULL, 0x000fe20000010000ULL, 0x0000001d42427221ULL, 0x000fe20000010000ULL,
0x0000002045457221ULL, 0x000fe20000010000ULL, 0x0000002146467221ULL, 0x000fe20000010000ULL,
0x0000002449497221ULL, 0x000fe20000010000ULL, 0x000000254a4a7221ULL, 0x000fe20000010000ULL,
0x000000284d4d7221ULL, 0x000fe20000010000ULL, 0x000000294e4e7221ULL, 0x000fe20000010000ULL,
0x0000002c53537221ULL, 0x000fe20000010000ULL, 0x0000002d54547221ULL, 0x000fe20000010000ULL,
0x0000003057577221ULL, 0x000fe20000010000ULL, 0x0000003158587221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x000000ffff157224ULL, 0x002fc600078e006fULL, 0x0000000000404947ULL, 0x000fea0002800000ULL,
0x000000160d0d7221ULL, 0x000fe20000010000ULL, 0x000000170c0c7221ULL, 0x000fe20000010000ULL,
0x0000001a11117221ULL, 0x000fe20000010000ULL, 0x0000001b40407221ULL, 0x000fe20000010000ULL,
0x0000001e43437221ULL, 0x000fe20000010000ULL, 0x0000001f44447221ULL, 0x000fe20000010000ULL,
0x0000002247477221ULL, 0x000fe20000010000ULL, 0x0000002348487221ULL, 0x000fe20000010000ULL,
0x000000264b4b7221ULL, 0x000fe20000010000ULL, 0x000000274c4c7221ULL, 0x000fe20000010000ULL,
0x0000002a4f4f7221ULL, 0x000fe20000010000ULL, 0x0000002b52527221ULL, 0x000fe20000010000ULL,
0x0000002e55557221ULL, 0x000fe20000010000ULL, 0x0000002f56567221ULL, 0x000fe20000010000ULL,
0x0000003259597221ULL, 0x000fe20000010000ULL, 0x000000335a5a7221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000016a6a7836ULL, 0x000fe40000000000ULL,
0x00000001ff147424ULL, 0x000fc600078e00ffULL, 0x000000696a00720cULL, 0x000fe20003f46070ULL,
0x018b8814ff1c79a7ULL, 0x0002d80008500006ULL, 0xffffffa00074a947ULL, 0x002fea000383ffffULL,
0x018b7014ffff79a7ULL, 0x0003e40008500006ULL, 0x0000000104047890ULL, 0x000fc8000fffe03fULL,
0x000000100400728cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0xfffffe8000788947ULL, 0x000fea000383ffffULL, 0x00000010ff007c0cULL, 0x000fe2000bf05270ULL,
0x000000ffff147224ULL, 0x002fe400078e0011ULL, 0x000000ffff107224ULL, 0x000fe400078e000dULL,
0x000000ffff117224ULL, 0x000fe400078e000cULL, 0x000000ffff0d7224ULL, 0x000fcc00078e000aULL,
0x0000000000d48947ULL, 0x000fea0003800000ULL, 0x0180000009007836ULL, 0x000fe20000000000ULL,
0x000000b000007945ULL, 0x000fe80003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x00000000000c0947ULL, 0x000fea0003800000ULL,
0x00019bc000047802ULL, 0x000fce0000000f00ULL, 0x0000009000447944ULL, 0x00cfea0003c00000ULL,
0x0000000000107947ULL, 0x000fea0003800000ULL, 0x0000000900007308ULL, 0x000e640000001000ULL,
0xbf80000000027423ULL, 0x006fc80000000009ULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000300007223ULL, 0x000fce0000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009a00ff027b82ULL, 0x000f240000000a00ULL, 0x0000000e02037981ULL, 0x010f22000c1e9900ULL,
0x0000000000057919ULL, 0x000f640000000000ULL, 0x00000002ff077819ULL, 0x022fe40000011605ULL,
0x0000000805057811ULL, 0x000fe200078ff0ffULL, 0x0000000003007220ULL, 0x01cfca0000410000ULL,
0x00001f0700047589ULL, 0x000e6800000e0000ULL, 0x00001f0500057589ULL, 0x000ea200000e0000ULL,
0x0000000b040b7220ULL, 0x042fe20000410000ULL, 0x0000000d040d7220ULL, 0x040fe20000410000ULL,
0x0000000f040f7220ULL, 0x040fe20000410000ULL, 0x0000000e040e7220ULL, 0x040fe20000410000ULL,
0x0000004104417220ULL, 0x040fe20000410000ULL, 0x0000004204427220ULL, 0x040fe20000410000ULL,
0x0000004504457220ULL, 0x040fe20000410000ULL, 0x0000004604467220ULL, 0x040fe20000410000ULL,
0x0000004904497220ULL, 0x040fe20000410000ULL, 0x0000004a044a7220ULL, 0x040fe20000410000ULL,
0x0000004d044d7220ULL, 0x040fe20000410000ULL, 0x0000004e044e7220ULL, 0x040fe20000410000ULL,
0x0000005304537220ULL, 0x040fe20000410000ULL, 0x0000005404547220ULL, 0x040fe20000410000ULL,
0x0000005704577220ULL, 0x040fe20000410000ULL, 0x0000005804587220ULL, 0x000fe20000410000ULL,
0x0000001005107220ULL, 0x044fe20000410000ULL, 0x0000001105117220ULL, 0x040fe20000410000ULL,
0x0000001405147220ULL, 0x040fe20000410000ULL, 0x0000004005407220ULL, 0x040fe20000410000ULL,
0x0000004305437220ULL, 0x040fe20000410000ULL, 0x0000004405447220ULL, 0x040fe20000410000ULL,
0x0000004705477220ULL, 0x040fe20000410000ULL, 0x0000004805487220ULL, 0x040fe20000410000ULL,
0x0000004b054b7220ULL, 0x040fe20000410000ULL, 0x0000004c054c7220ULL, 0x040fe20000410000ULL,
0x0000004f054f7220ULL, 0x040fe20000410000ULL, 0x0000005205527220ULL, 0x040fe20000410000ULL,
0x0000005505557220ULL, 0x040fe20000410000ULL, 0x0000005605567220ULL, 0x040fe20000410000ULL,
0x0000005905597220ULL, 0x040fe20000410000ULL, 0x0000005a055a7220ULL, 0x000fce0000410000ULL,
0x0000000000167919ULL, 0x000e620000000000ULL, 0x000000065f5f7c11ULL, 0x000fe2000f8e58ffULL,
0x00000000000479c3ULL, 0x000ee20000002600ULL, 0x0000004d4e4d723eULL, 0x000fce00000010ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000535453723eULL, 0x000fe400000010ffULL,
0x000000575857723eULL, 0x000fe400000010ffULL, 0x000000434443723eULL, 0x000fc400000010ffULL,
0x000000474847723eULL, 0x000fe400000010ffULL, 0x0000004b4c4b723eULL, 0x000fe400000010ffULL,
0x0000004f524f723eULL, 0x000fe400000010ffULL, 0x000000555655723eULL, 0x000fe400000010ffULL,
0x000000595a59723eULL, 0x000fe400000010ffULL, 0x000054104b4e7816ULL, 0x000fc4000000004fULL,
0x000076324b4f7816ULL, 0x000fe4000000004fULL, 0x0000541055587816ULL, 0x100fe40000000059ULL,
0x00000002ff077819ULL, 0x002fe40000011616ULL, 0x0000000216007812ULL, 0x040fe400078ec0ffULL,
0x0000000816057811ULL, 0x000fe200078ff0ffULL, 0x0000000807097824ULL, 0x040fe200078e00ffULL,
0x0000000700027211ULL, 0x044fe200078ff8ffULL, 0x0000000807087824ULL, 0x000fe200078e00ffULL,
0x0000000500037211ULL, 0x000fe200078ff8ffULL, 0x00000008050c7824ULL, 0x000fe200078e00ffULL,
0x0000763255597816ULL, 0x000fe20000000059ULL, 0x0000000807057824ULL, 0x000fc400078e00ffULL,
0x0000000202007836ULL, 0x000fe20000000000ULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee203ULL,
0x0000000402037836ULL, 0x000fe40000000000ULL, 0x0000000807077824ULL, 0x000fe200078e00ffULL,
0xfffffff805067812ULL, 0x000fe400078ee200ULL, 0x00000003ff057819ULL, 0x100fe40000011616ULL,
0xfffffff809007812ULL, 0x000fe200078ee202ULL, 0x0000000602027836ULL, 0x000fe20000000000ULL,
0xfffffff808087812ULL, 0x000fe200078ee203ULL, 0x0000000105047824ULL, 0x000fc400078e0216ULL,
0x000120005f037836ULL, 0x000fe20000000000ULL, 0xfffffff8070a7812ULL, 0x000fe200078ee202ULL,
0x0000000816027824ULL, 0x000fe200078e00ffULL, 0x0000000704077812ULL, 0x000fe200078ec0ffULL,
0x0000001000047824ULL, 0x100fe400078e0203ULL, 0x000000100c0c7824ULL, 0x100fe200078e0203ULL,
0x0ffffff807007812ULL, 0x000fe200078ef816ULL, 0x0000001006067824ULL, 0x100fe200078e0203ULL,
0x0000000716167812ULL, 0x000fe200078ec0ffULL, 0x0000001008087824ULL, 0x000fc400078e0203ULL,
0x000000100a0a7824ULL, 0x000fe200078e0203ULL, 0x0000000802037812ULL, 0x000fe200078ec0ffULL,
0x00000010005f7824ULL, 0x000fe200078e025fULL, 0x0000000b0d00723eULL, 0x000fe400000010ffULL,
0x0000000f0e02723eULL, 0x000fe200000010ffULL, 0x0000000104047824ULL, 0x000fe200078e0203ULL,
0x1ffffff8165b7812ULL, 0x000fe200078ef85bULL, 0x0000000103067824ULL, 0x040fe200078e0206ULL,
0x00005410000e7816ULL, 0x040fe20000000002ULL, 0x00000001030c7824ULL, 0x040fe200078e020cULL,
0x00007632000f7816ULL, 0x000fe20000000002ULL, 0x0000000103087824ULL, 0x040fe200078e0208ULL,
0x000000414200723eULL, 0x000fe200000010ffULL, 0x00000001030a7824ULL, 0x000fe200078e020aULL,
0x000000454602723eULL, 0x000fe200000010ffULL, 0x0000000e04007388ULL, 0x0003e20000000a00ULL,
0x000000494a03723eULL, 0x000fc400000010ffULL, 0x0000541043467816ULL, 0x140fe40000000047ULL,
0x0000763243477816ULL, 0x000fe40000000047ULL, 0x00005410000e7816ULL, 0x142fe40000000002ULL,
0x00007632000f7816ULL, 0x000fe40000000002ULL, 0x000000101100723eULL, 0x000fe400000010ffULL,
0x000000144002723eULL, 0x000fe200000010ffULL, 0x0000000e06007388ULL, 0x0003e40000000a00ULL,
0x00005410030e7816ULL, 0x002fc4000000004dULL, 0x00007632030f7816ULL, 0x000fca000000004dULL,
0x0000000e08007388ULL, 0x0003e40000000a00ULL, 0x00005410530e7816ULL, 0x142fe40000000057ULL,
0x00007632530f7816ULL, 0x000fca0000000057ULL, 0x0000000e0a007388ULL, 0x0003e40000000a00ULL,
0x00005410000e7816ULL, 0x142fe40000000002ULL, 0x00007632000f7816ULL, 0x000fe40000000002ULL,
0x00008400ff007b82ULL, 0x000e660000000800ULL, 0x0000000e0c007388ULL, 0x000fe80000000a00ULL,
0x0004004606007388ULL, 0x000fe80000000a00ULL, 0x0004004e08007388ULL, 0x000fe80000000a00ULL,
0x000400580a007388ULL, 0x000fe20000000a00ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x012000005f0c7984ULL, 0x000ea20000000c00ULL, 0x0000000012127224ULL, 0x082fe400078e02ffULL,
0x0000000405057e24ULL, 0x008fe2000f8e0200ULL, 0x0000860000047ab9ULL, 0x000fc80000000a00ULL,
0x0000000512057211ULL, 0x000fca00078010ffULL, 0x000000ffff007224ULL, 0x000fe200000e06ffULL,
0x0000000405027c11ULL, 0x000fc8000f8048ffULL, 0x0000000505037c11ULL, 0x000fc600080f4c00ULL,
0x000000105b027825ULL, 0x000fca00078e0002ULL, 0x0000000c02007986ULL, 0x004fe2000c101d0eULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x000000030300780cULL, 0x000fe20003f44070ULL,
0x00009200ff087b82ULL, 0x000e620000000a00ULL, 0x000000405f487824ULL, 0x040fe200078e00ffULL,
0x0000940000087ab9ULL, 0x000fe20000000800ULL, 0x0000002003057836ULL, 0x000fe20000000000ULL,
0x000000065f467c11ULL, 0x000fe2000f8e40ffULL, 0x000000085d007c24ULL, 0x000fe4000f8e0248ULL,
0x0000000148067824ULL, 0x040fe200078e0203ULL, 0x00009a00ff0c7b82ULL, 0x000ea20000000a00ULL,
0x00000001480f7824ULL, 0x000fc400078e0205ULL, 0x0000000100077824ULL, 0x100fe200078e0203ULL,
0x0000000d06007c0cULL, 0x000fe2000bf06070ULL, 0x000000041202a824ULL, 0x000fe200078e0203ULL,
0x0000000d0f007c0cULL, 0x000fe2000bf26070ULL, 0x0000000100057824ULL, 0x000fe200078e0205ULL,
0x00009000ff04ab82ULL, 0x000ee20000000800ULL, 0x000000020200a824ULL, 0x000fe200078e00ffULL,
0x000000075f00ac0cULL, 0x000fe2000bf66070ULL, 0x00000004030f7824ULL, 0x000fe400078e0246ULL,
0x0000000407067825ULL, 0x002fc600078e0008ULL, 0x00008c00ff0aab82ULL, 0x000e620000000a00ULL,
0x0000000405087825ULL, 0x000fc800078e0008ULL, 0x000000040005a224ULL, 0x008fe200078e025fULL,
0x000000065f00ac11ULL, 0x000fe2000f8e20ffULL, 0x00000001ff047424ULL, 0x000fc800078e00ffULL,
0x000000040311a824ULL, 0x000fe400078e0200ULL, 0x0000000e0c007981ULL, 0x004522000c1e9900ULL,
0x00000004050aa825ULL, 0x002fe400078e000aULL, 0x018ad004ff0479a7ULL, 0x000ea20008500006ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18600000060f7faeULL, 0x0005e8000c12184eULL,
0x18680000080f7faeULL, 0x0005e8000c92184eULL, 0x18a800000a11afaeULL, 0x0005e8000d92184eULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000001ff0500788cULL, 0x000fcc000bf04070ULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x0000000604047899ULL, 0x000fe2000800063fULL,
0x000080000000791aULL, 0x000fc80000000000ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000001000a40947ULL, 0x004fea0003800000ULL, 0x00000003ff027819ULL, 0x100fe40000011603ULL,
0x000000065f087c11ULL, 0x000fe4000f8e20ffULL, 0x0000000d480d7c48ULL, 0x000fe2000ffe0000ULL,
0x0000000402097824ULL, 0x000fe200078e0246ULL, 0x000000700e047812ULL, 0x000fe200078ec0ffULL,
0x00000040130a7824ULL, 0x000fe200078e0202ULL, 0x000000065f0c7c11ULL, 0x000fe2000f8e70ffULL,
0x0000000102117824ULL, 0x000fe200078e0203ULL, 0x0186000009077984ULL, 0x000e620000000800ULL,
0x000000010d0d7824ULL, 0x000fc600078e0a48ULL, 0x0000000711147812ULL, 0x000fe400078ec0ffULL,
0x0000000d0200720cULL, 0x000fe40003f06070ULL, 0x0ffffff814147812ULL, 0x000fe200078ef803ULL,
0x0000000407107824ULL, 0x002fe400078e0208ULL, 0x00008a00ff067b82ULL, 0x000e660000000a00ULL,
0x018a8000100b7984ULL, 0x000ea40000000800ULL, 0x000000040b0b7c24ULL, 0x004fc8000f8e020aULL,
0x000001000b0e7825ULL, 0x002fc800078e0006ULL, 0x000020000c0b7836ULL, 0x000fe20000000000ULL,
0x0000000e04107210ULL, 0x000fe20007f3e0ffULL, 0x00000004020c7836ULL, 0x000fe40000000000ULL,
0x0000001014157824ULL, 0x000fe400078e020bULL, 0x000000ffff117224ULL, 0x000fe400008e060fULL,
0x000000010c147824ULL, 0x040fe400078e0203ULL, 0x000000080c177824ULL, 0x040fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010157faeULL, 0x0003e2000c101c4eULL,
0x0000000d0c00720cULL, 0x000fe20003f06070ULL, 0x00000008020c7836ULL, 0x000fc40000000000ULL,
0x01861000090f7984ULL, 0x000ea20000000800ULL, 0xfffffff817147812ULL, 0x000fe200078ee214ULL,
0x000000080c177824ULL, 0x000fc800078e00ffULL, 0x0000001014157824ULL, 0x002fe400078e020bULL,
0x000000010c147824ULL, 0x000fca00078e0203ULL, 0xfffffff817147812ULL, 0x000fe200078ee214ULL,
0x000000040f167824ULL, 0x004fe400078e0208ULL, 0x000000040a0f7836ULL, 0x000fc60000000000ULL,
0x018a8000160e7984ULL, 0x000e640000000800ULL, 0x000000040e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc600078e0006ULL, 0x0000000e04107210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff117224ULL, 0x000fca00008e060fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010157faeULL, 0x0003e2000c101c4eULL, 0x0000000d0c00720cULL, 0x000fe20003f06070ULL,
0x0000000c020c7836ULL, 0x000fe40000000000ULL, 0x01862000090f7984ULL, 0x000ea40000000800ULL,
0x000000080c177824ULL, 0x000fe400078e00ffULL, 0x0000001014157824ULL, 0x002fe400078e020bULL,
0x000000010c147824ULL, 0x000fca00078e0203ULL, 0xfffffff817147812ULL, 0x000fe200078ee214ULL,
0x000000040f167824ULL, 0x004fe400078e0208ULL, 0x000000080a0f7836ULL, 0x000fc60000000000ULL,
0x018a8000160e7984ULL, 0x000e640000000800ULL, 0x000000040e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc600078e0006ULL, 0x0000000e04107210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff117224ULL, 0x000fca00008e060fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010157faeULL, 0x0003e2000c101c4eULL, 0x0000000d0c00720cULL, 0x000fe20003f06070ULL,
0x00000010020c7836ULL, 0x000fe40000000000ULL, 0x01863000090f7984ULL, 0x000ea40000000800ULL,
0x000000080c177824ULL, 0x000fe400078e00ffULL, 0x0000001014157824ULL, 0x002fe400078e020bULL,
0x000000010c147824ULL, 0x000fca00078e0203ULL, 0xfffffff817147812ULL, 0x000fe200078ee214ULL,
0x000000040f167824ULL, 0x004fe400078e0208ULL, 0x0000000c0a0f7836ULL, 0x000fc60000000000ULL,
0x018a8000160e7984ULL, 0x000e640000000800ULL, 0x000000040e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc600078e0006ULL, 0x0000000e04107210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff117224ULL, 0x000fca00008e060fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010157faeULL, 0x0003e2000c101c4eULL, 0x0000000d0c00720cULL, 0x000fe20003f06070ULL,
0x00000014020c7836ULL, 0x000fe40000000000ULL, 0x01864000090f7984ULL, 0x000ea40000000800ULL,
0x000000080c177824ULL, 0x000fe400078e00ffULL, 0x0000001014157824ULL, 0x002fe400078e020bULL,
0x000000010c147824ULL, 0x000fca00078e0203ULL, 0xfffffff817147812ULL, 0x000fe200078ee214ULL,
0x000000040f167824ULL, 0x004fe400078e0208ULL, 0x000000100a0f7836ULL, 0x000fc60000000000ULL,
0x018a8000160e7984ULL, 0x000e640000000800ULL, 0x000000040e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc600078e0006ULL, 0x0000000e04107210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff117224ULL, 0x000fca00008e060fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010157faeULL, 0x0003e2000c101c4eULL, 0x0000000d0c00720cULL, 0x000fe20003f06070ULL,
0x00000018020c7836ULL, 0x000fe40000000000ULL, 0x01865000090f7984ULL, 0x000ea40000000800ULL,
0x000000080c177824ULL, 0x000fe400078e00ffULL, 0x0000001014157824ULL, 0x002fe400078e020bULL,
0x000000010c147824ULL, 0x000fca00078e0203ULL, 0xfffffff817147812ULL, 0x000fe200078ee214ULL,
0x000000040f167824ULL, 0x004fe400078e0208ULL, 0x000000140a0f7836ULL, 0x000fc60000000000ULL,
0x018a8000160e7984ULL, 0x000e640000000800ULL, 0x000000040e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc600078e0006ULL, 0x0000000e04107210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff117224ULL, 0x000fca00008e060fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010157faeULL, 0x0003e2000c101c4eULL, 0x0000000d0c00720cULL, 0x000fe20003f06070ULL,
0x0000001c020c7836ULL, 0x000fe40000000000ULL, 0x01866000090f7984ULL, 0x000ea40000000800ULL,
0x000000080c177824ULL, 0x000fe400078e00ffULL, 0x0000001014157824ULL, 0x002fe400078e020bULL,
0x000000010c147824ULL, 0x000fca00078e0203ULL, 0xfffffff817147812ULL, 0x000fe200078ee214ULL,
0x000000040f167824ULL, 0x004fe400078e0208ULL, 0x000000180a0f7836ULL, 0x000fc60000000000ULL,
0x018a8000160e7984ULL, 0x000e640000000800ULL, 0x000000040e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc600078e0006ULL, 0x0000000e04107210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff117224ULL, 0x000fca00008e060fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010157faeULL, 0x0003e2000c101c4eULL, 0x0000000d0c00720cULL, 0x000fe20003f06070ULL,
0x00000020020c7836ULL, 0x000fe40000000000ULL, 0x01867000090f7984ULL, 0x000ea40000000800ULL,
0x000000080c177824ULL, 0x000fe400078e00ffULL, 0x0000001014157824ULL, 0x002fe400078e020bULL,
0x000000010c147824ULL, 0x000fca00078e0203ULL, 0xfffffff817147812ULL, 0x000fe200078ee214ULL,
0x000000040f167824ULL, 0x004fe400078e0208ULL, 0x0000001c0a0f7836ULL, 0x000fc60000000000ULL,
0x018a8000160e7984ULL, 0x000e640000000800ULL, 0x000000040e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc600078e0006ULL, 0x0000000e04107210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff117224ULL, 0x000fca00008e060fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010157faeULL, 0x0003e2000c101c4eULL, 0x0000000d0c00720cULL, 0x000fe20003f06070ULL,
0x00000024020c7836ULL, 0x000fe40000000000ULL, 0x01868000090f7984ULL, 0x000ea40000000800ULL,
0x000000080c177824ULL, 0x000fe400078e00ffULL, 0x0000001014157824ULL, 0x002fe400078e020bULL,
0x000000010c147824ULL, 0x000fca00078e0203ULL, 0xfffffff817147812ULL, 0x000fe200078ee214ULL,
0x000000040f167824ULL, 0x004fe400078e0208ULL, 0x000000200a0f7836ULL, 0x000fc60000000000ULL,
0x018a8000160e7984ULL, 0x000e640000000800ULL, 0x000000040e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc600078e0006ULL, 0x0000000e04107210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff117224ULL, 0x000fca00008e060fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010157faeULL, 0x0003e2000c101c4eULL, 0x0000000d0c00720cULL, 0x000fe20003f06070ULL,
0x00000028020c7836ULL, 0x000fe40000000000ULL, 0x01869000090f7984ULL, 0x000ea40000000800ULL,
0x000000080c177824ULL, 0x000fe400078e00ffULL, 0x0000001014157824ULL, 0x002fe400078e020bULL,
0x000000010c147824ULL, 0x000fca00078e0203ULL, 0xfffffff817147812ULL, 0x000fe200078ee214ULL,
0x000000040f167824ULL, 0x004fe400078e0208ULL, 0x000000240a0f7836ULL, 0x000fc60000000000ULL,
0x018a8000160e7984ULL, 0x000e640000000800ULL, 0x000000040e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc600078e0006ULL, 0x0000000e04107210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff117224ULL, 0x000fca00008e060fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010157faeULL, 0x0003e2000c101c4eULL, 0x0000000d0c00720cULL, 0x000fe20003f06070ULL,
0x0000002c020c7836ULL, 0x000fe40000000000ULL, 0x0186a000090f7984ULL, 0x000ea40000000800ULL,
0x000000080c177824ULL, 0x000fe400078e00ffULL, 0x0000001014157824ULL, 0x002fe400078e020bULL,
0x000000010c147824ULL, 0x000fca00078e0203ULL, 0xfffffff817147812ULL, 0x000fe200078ee214ULL,
0x000000040f167824ULL, 0x004fe400078e0208ULL, 0x000000280a0f7836ULL, 0x000fc60000000000ULL,
0x018a8000160e7984ULL, 0x000e640000000800ULL, 0x000000040e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc600078e0006ULL, 0x0000000e04107210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff117224ULL, 0x000fca00008e060fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010157faeULL, 0x0003e2000c101c4eULL, 0x0000000d0c00720cULL, 0x000fe20003f06070ULL,
0x00000030020c7836ULL, 0x000fe40000000000ULL, 0x0186b000090f7984ULL, 0x000ea40000000800ULL,
0x000000080c177824ULL, 0x000fe400078e00ffULL, 0x0000001014157824ULL, 0x002fe400078e020bULL,
0x000000010c147824ULL, 0x000fca00078e0203ULL, 0xfffffff817147812ULL, 0x000fe200078ee214ULL,
0x000000040f167824ULL, 0x004fe400078e0208ULL, 0x0000002c0a0f7836ULL, 0x000fc60000000000ULL,
0x018a8000160e7984ULL, 0x000e640000000800ULL, 0x000000040e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc600078e0006ULL, 0x0000000e04107210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff117224ULL, 0x000fca00008e060fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010157faeULL, 0x0003e2000c101c4eULL, 0x0000000d0c00720cULL, 0x000fe20003f06070ULL,
0x00000034020c7836ULL, 0x000fe40000000000ULL, 0x0186c000090f7984ULL, 0x000ea40000000800ULL,
0x000000080c177824ULL, 0x000fe400078e00ffULL, 0x0000001014157824ULL, 0x002fe400078e020bULL,
0x000000010c147824ULL, 0x000fca00078e0203ULL, 0xfffffff817147812ULL, 0x000fe200078ee214ULL,
0x000000040f167824ULL, 0x004fe400078e0208ULL, 0x000000300a0f7836ULL, 0x000fc60000000000ULL,
0x018a8000160e7984ULL, 0x000e640000000800ULL, 0x000000040e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc600078e0006ULL, 0x0000000e04107210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff117224ULL, 0x000fca00008e060fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010157faeULL, 0x0003e2000c101c4eULL, 0x0000000d0c00720cULL, 0x000fe20003f06070ULL,
0x00000038020c7836ULL, 0x000fe40000000000ULL, 0x0186d000090f7984ULL, 0x000ea20000000800ULL,
0x0000003c02027836ULL, 0x000fe40000000000ULL, 0x000000080c177824ULL, 0x000fe400078e00ffULL,
0x0000001014157824ULL, 0x002fe400078e020bULL, 0x000000010c147824ULL, 0x000fc400078e0203ULL,
0x0000000102037824ULL, 0x000fc600078e0203ULL, 0xfffffff817147812ULL, 0x000fe200078ee214ULL,
0x000000040f167824ULL, 0x004fe400078e0208ULL, 0x000000340a0f7836ULL, 0x000fc60000000000ULL,
0x018a8000160e7984ULL, 0x000e640000000800ULL, 0x000000040e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc600078e0006ULL, 0x0000000e04107210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff117224ULL, 0x000fca00008e060fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010157faeULL, 0x0003e2000c101c4eULL, 0x0000000d0c00720cULL, 0x000fc60003f06070ULL,
0x0186e000090f7984ULL, 0x000ea20000000800ULL, 0x0000001014117824ULL, 0x002fe400078e020bULL,
0x0000003c0a157836ULL, 0x000fe40000000000ULL, 0x000000040f167824ULL, 0x004fe400078e0208ULL,
0x000000380a0f7836ULL, 0x000fe40000000000ULL, 0x00000008020a7824ULL, 0x000fe200078e00ffULL,
0x018a8000160e7984ULL, 0x000e640000000800ULL, 0x000000040e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc600078e0006ULL, 0x0000000e040e7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0f7224ULL, 0x000fca00008e060fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e117faeULL, 0x0003e2000c101c4eULL, 0x0000000d0200720cULL, 0x000fc60003f06070ULL,
0x0186f00009097984ULL, 0x000ea40000000800ULL, 0x0000000409087824ULL, 0x004fcc00078e0208ULL,
0x018a800008087984ULL, 0x000ea40000000800ULL, 0x0000000408157c24ULL, 0x004fc8000f8e0215ULL,
0x0000010015067825ULL, 0x000fc600078e0006ULL, 0x0000000604027210ULL, 0x000fe40007f3e0ffULL,
0xfffffff80a047812ULL, 0x000fc600078ee203ULL, 0x000000ffff037224ULL, 0x000fe400008e0607ULL,
0x00000010040b7824ULL, 0x000fca00078e020bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000020b7faeULL, 0x0003e2000c101c4eULL, 0x0000001000587947ULL, 0x000fea0003800000ULL,
0x00000003ff047819ULL, 0x100fe40000011603ULL, 0x000000065f087c11ULL, 0x040fe4000f8e20ffULL,
0x000000065f0f7c11ULL, 0x000fe2000f8e70ffULL, 0x00000004040b7824ULL, 0x040fe400078e0246ULL,
0x00000040130a7824ULL, 0x000fe400078e0204ULL, 0x0000000104027824ULL, 0x000fe200078e0203ULL,
0x018600000b077984ULL, 0x000e680000000800ULL, 0x0000000702147812ULL, 0x000fe200078ec0ffULL,
0x000020000f027836ULL, 0x000fc60000000000ULL, 0x0ffffff814117812ULL, 0x000fca00078ef803ULL,
0x0000001011157824ULL, 0x000fe400078e0202ULL, 0x0000000407107824ULL, 0x002fe400078e0208ULL,
0x00008a00ff067b82ULL, 0x000e660000000a00ULL, 0x018a800010097984ULL, 0x0004e40000000800ULL,
0x0000000404107836ULL, 0x004fc80000000000ULL, 0x0000000110117824ULL, 0x040fe400078e0203ULL,
0x0000000810167824ULL, 0x000fe400078e00ffULL, 0x0000000409097c24ULL, 0x008fc8000f8e020aULL,
0x00000100090c7825ULL, 0x002fe200078e0006ULL, 0x000000700e097812ULL, 0x000fc800078ec0ffULL,
0x000000090c0e7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e157faeULL, 0x0003e8000b901c4eULL,
0x018610000b0d7984ULL, 0x000ea20000000800ULL, 0xfffffff8160f7812ULL, 0x002fe200078ee211ULL,
0x00000008040e7836ULL, 0x000fc80000000000ULL, 0x000000100f157824ULL, 0x000fe400078e0202ULL,
0x000000010e0f7824ULL, 0x040fe400078e0203ULL, 0x000000080e167824ULL, 0x000fe400078e00ffULL,
0x000000040d147824ULL, 0x004fe400078e0208ULL, 0x000000040a0d7836ULL, 0x000fc60000000000ULL,
0x018a8000140c7984ULL, 0x000e640000000800ULL, 0x000000040c0d7c24ULL, 0x002fc8000f8e020dULL,
0x000001000d0c7825ULL, 0x000fc600078e0006ULL, 0x000000090c107210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff117224ULL, 0x000fca00000e060dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010157faeULL, 0x0003e8000b901c4eULL, 0x018620000b0d7984ULL, 0x000ea20000000800ULL,
0xfffffff816117812ULL, 0x002fe200078ee20fULL, 0x0000000c04107836ULL, 0x000fc80000000000ULL,
0x0000001011157824ULL, 0x000fe400078e0202ULL, 0x0000000110117824ULL, 0x040fe400078e0203ULL,
0x0000000810167824ULL, 0x000fe400078e00ffULL, 0x000000040d147824ULL, 0x004fe400078e0208ULL,
0x000000080a0d7836ULL, 0x000fc60000000000ULL, 0x018a8000140c7984ULL, 0x000e640000000800ULL,
0x000000040c0d7c24ULL, 0x002fc8000f8e020dULL, 0x000001000d0c7825ULL, 0x000fc600078e0006ULL,
0x000000090c0e7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e157faeULL, 0x0003e8000b901c4eULL,
0x018630000b0d7984ULL, 0x000ea20000000800ULL, 0xfffffff8160f7812ULL, 0x002fe200078ee211ULL,
0x00000010040e7836ULL, 0x000fc80000000000ULL, 0x000000100f157824ULL, 0x000fe400078e0202ULL,
0x000000010e0f7824ULL, 0x040fe400078e0203ULL, 0x000000080e167824ULL, 0x000fe400078e00ffULL,
0x000000040d147824ULL, 0x004fe400078e0208ULL, 0x0000000c0a0d7836ULL, 0x000fc60000000000ULL,
0x018a8000140c7984ULL, 0x000e640000000800ULL, 0x000000040c0d7c24ULL, 0x002fc8000f8e020dULL,
0x000001000d0c7825ULL, 0x000fc600078e0006ULL, 0x000000090c107210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff117224ULL, 0x000fca00000e060dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010157faeULL, 0x0003e8000b901c4eULL, 0x018640000b0d7984ULL, 0x000ea20000000800ULL,
0xfffffff816117812ULL, 0x002fe200078ee20fULL, 0x0000001404107836ULL, 0x000fc80000000000ULL,
0x0000001011157824ULL, 0x000fe400078e0202ULL, 0x0000000110117824ULL, 0x040fe400078e0203ULL,
0x0000000810167824ULL, 0x000fe400078e00ffULL, 0x000000040d147824ULL, 0x004fe400078e0208ULL,
0x000000100a0d7836ULL, 0x000fc60000000000ULL, 0x018a8000140c7984ULL, 0x000e640000000800ULL,
0x000000040c0d7c24ULL, 0x002fc8000f8e020dULL, 0x000001000d0c7825ULL, 0x000fc600078e0006ULL,
0x000000090c0e7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e157faeULL, 0x0003e8000b901c4eULL,
0x018650000b0d7984ULL, 0x000ea20000000800ULL, 0xfffffff8160f7812ULL, 0x002fe200078ee211ULL,
0x00000018040e7836ULL, 0x000fc80000000000ULL, 0x000000100f157824ULL, 0x000fe400078e0202ULL,
0x000000010e0f7824ULL, 0x040fe400078e0203ULL, 0x000000080e167824ULL, 0x000fe400078e00ffULL,
0x000000040d147824ULL, 0x004fe400078e0208ULL, 0x000000140a0d7836ULL, 0x000fc60000000000ULL,
0x018a8000140c7984ULL, 0x000e640000000800ULL, 0x000000040c0d7c24ULL, 0x002fc8000f8e020dULL,
0x000001000d0c7825ULL, 0x000fc600078e0006ULL, 0x000000090c107210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff117224ULL, 0x000fca00000e060dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010157faeULL, 0x0003e8000b901c4eULL, 0x018660000b0d7984ULL, 0x000ea20000000800ULL,
0xfffffff816117812ULL, 0x002fe200078ee20fULL, 0x0000001c04107836ULL, 0x000fc80000000000ULL,
0x0000001011157824ULL, 0x000fe400078e0202ULL, 0x0000000110117824ULL, 0x040fe400078e0203ULL,
0x0000000810167824ULL, 0x000fe400078e00ffULL, 0x000000040d147824ULL, 0x004fe400078e0208ULL,
0x000000180a0d7836ULL, 0x000fc60000000000ULL, 0x018a8000140c7984ULL, 0x000e640000000800ULL,
0x000000040c0d7c24ULL, 0x002fc8000f8e020dULL, 0x000001000d0c7825ULL, 0x000fc600078e0006ULL,
0x000000090c0e7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e157faeULL, 0x0003e8000b901c4eULL,
0x018670000b0d7984ULL, 0x000ea20000000800ULL, 0xfffffff8160f7812ULL, 0x002fe200078ee211ULL,
0x00000020040e7836ULL, 0x000fc80000000000ULL, 0x000000100f157824ULL, 0x000fe400078e0202ULL,
0x000000010e0f7824ULL, 0x040fe400078e0203ULL, 0x000000080e167824ULL, 0x000fe400078e00ffULL,
0x000000040d147824ULL, 0x004fe400078e0208ULL, 0x0000001c0a0d7836ULL, 0x000fc60000000000ULL,
0x018a8000140c7984ULL, 0x000e640000000800ULL, 0x000000040c0d7c24ULL, 0x002fc8000f8e020dULL,
0x000001000d0c7825ULL, 0x000fc600078e0006ULL, 0x000000090c107210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff117224ULL, 0x000fca00000e060dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010157faeULL, 0x0003e8000b901c4eULL, 0x018680000b0d7984ULL, 0x000ea20000000800ULL,
0xfffffff816117812ULL, 0x002fe200078ee20fULL, 0x0000002404107836ULL, 0x000fc80000000000ULL,
0x0000001011157824ULL, 0x000fe400078e0202ULL, 0x0000000110117824ULL, 0x040fe400078e0203ULL,
0x0000000810167824ULL, 0x000fe400078e00ffULL, 0x000000040d147824ULL, 0x004fe400078e0208ULL,
0x000000200a0d7836ULL, 0x000fc60000000000ULL, 0x018a8000140c7984ULL, 0x000e640000000800ULL,
0x000000040c0d7c24ULL, 0x002fc8000f8e020dULL, 0x000001000d0c7825ULL, 0x000fc600078e0006ULL,
0x000000090c0e7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e157faeULL, 0x0003e8000b901c4eULL,
0x018690000b0d7984ULL, 0x000ea20000000800ULL, 0xfffffff8160f7812ULL, 0x002fe200078ee211ULL,
0x00000028040e7836ULL, 0x000fc80000000000ULL, 0x000000100f157824ULL, 0x000fe400078e0202ULL,
0x000000010e0f7824ULL, 0x040fe400078e0203ULL, 0x000000080e167824ULL, 0x000fe400078e00ffULL,
0x000000040d147824ULL, 0x004fe400078e0208ULL, 0x000000240a0d7836ULL, 0x000fc60000000000ULL,
0x018a8000140c7984ULL, 0x000e640000000800ULL, 0x000000040c0d7c24ULL, 0x002fc8000f8e020dULL,
0x000001000d0c7825ULL, 0x000fc600078e0006ULL, 0x000000090c107210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff117224ULL, 0x000fca00000e060dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010157faeULL, 0x0003e8000b901c4eULL, 0x0186a0000b0d7984ULL, 0x000ea20000000800ULL,
0xfffffff816117812ULL, 0x002fe200078ee20fULL, 0x0000002c04107836ULL, 0x000fc80000000000ULL,
0x0000001011157824ULL, 0x000fe400078e0202ULL, 0x0000000110117824ULL, 0x040fe400078e0203ULL,
0x0000000810167824ULL, 0x000fe400078e00ffULL, 0x000000040d147824ULL, 0x004fe400078e0208ULL,
0x000000280a0d7836ULL, 0x000fc60000000000ULL, 0x018a8000140c7984ULL, 0x000e640000000800ULL,
0x000000040c0d7c24ULL, 0x002fc8000f8e020dULL, 0x000001000d0c7825ULL, 0x000fc600078e0006ULL,
0x000000090c0e7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e157faeULL, 0x0003e8000b901c4eULL,
0x0186b0000b0d7984ULL, 0x000ea20000000800ULL, 0xfffffff8160f7812ULL, 0x002fe200078ee211ULL,
0x00000030040e7836ULL, 0x000fc80000000000ULL, 0x000000100f157824ULL, 0x000fe400078e0202ULL,
0x000000010e0f7824ULL, 0x040fe400078e0203ULL, 0x000000080e167824ULL, 0x000fe400078e00ffULL,
0x000000040d147824ULL, 0x004fe400078e0208ULL, 0x0000002c0a0d7836ULL, 0x000fc60000000000ULL,
0x018a8000140c7984ULL, 0x000e640000000800ULL, 0x000000040c0d7c24ULL, 0x002fc8000f8e020dULL,
0x000001000d0c7825ULL, 0x000fc600078e0006ULL, 0x000000090c107210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff117224ULL, 0x000fca00000e060dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010157faeULL, 0x0003e8000b901c4eULL, 0x0186c0000b0d7984ULL, 0x000ea20000000800ULL,
0xfffffff816117812ULL, 0x002fe200078ee20fULL, 0x0000003404107836ULL, 0x000fc80000000000ULL,
0x0000001011157824ULL, 0x000fe400078e0202ULL, 0x0000000110117824ULL, 0x040fe400078e0203ULL,
0x0000000810167824ULL, 0x000fe400078e00ffULL, 0x000000040d147824ULL, 0x004fe400078e0208ULL,
0x000000300a0d7836ULL, 0x000fc60000000000ULL, 0x018a8000140c7984ULL, 0x000e640000000800ULL,
0x000000040c0d7c24ULL, 0x002fc8000f8e020dULL, 0x000001000d0c7825ULL, 0x000fc600078e0006ULL,
0x000000090c0e7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e157faeULL, 0x0003e8000b901c4eULL,
0x0186d0000b0d7984ULL, 0x000ea20000000800ULL, 0xfffffff8160f7812ULL, 0x002fca00078ee211ULL,
0x000000100f0f7824ULL, 0x000fe400078e0202ULL, 0x000000040d147824ULL, 0x004fe400078e0208ULL,
0x000000340a0d7836ULL, 0x000fc60000000000ULL, 0x018a8000140c7984ULL, 0x0002a40000000800ULL,
0x0000003804147836ULL, 0x002fe40000000000ULL, 0x0000003c04047836ULL, 0x000fe40000000000ULL,
0x0000000114157824ULL, 0x140fe400078e0203ULL, 0x0000000814147824ULL, 0x000fe400078e00ffULL,
0x0000000104037824ULL, 0x000fc400078e0203ULL, 0x0000000804047824ULL, 0x000fe200078e00ffULL,
0xfffffff814157812ULL, 0x000fc800078ee215ULL, 0xfffffff804037812ULL, 0x000fe200078ee203ULL,
0x0000001015157824ULL, 0x000fc800078e0202ULL, 0x0000001003037824ULL, 0x000fe400078e0202ULL,
0x000000040c0d7c24ULL, 0x004fc8000f8e020dULL, 0x000001000d0c7825ULL, 0x000fc600078e0006ULL,
0x000000090c107210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff117224ULL, 0x000fca00000e060dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000100f7faeULL, 0x0003e8000b901c4eULL,
0x0186e0000b0d7984ULL, 0x000ea20000000800ULL, 0x0000003c0a0f7836ULL, 0x002fe40000000000ULL,
0x000000040d0e7824ULL, 0x004fe400078e0208ULL, 0x000000380a0d7836ULL, 0x000fc60000000000ULL,
0x018a80000e0c7984ULL, 0x000e640000000800ULL, 0x000000040c0d7c24ULL, 0x002fc8000f8e020dULL,
0x000001000d0c7825ULL, 0x000fc600078e0006ULL, 0x000000090c0c7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0d7224ULL, 0x000fca00000e060dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c157faeULL, 0x0003e8000b901c4eULL, 0x0186f0000b0b7984ULL, 0x000ea40000000800ULL,
0x000000040b087824ULL, 0x004fcc00078e0208ULL, 0x018a800008087984ULL, 0x000ea40000000800ULL,
0x00000004080f7c24ULL, 0x004fc8000f8e020fULL, 0x000001000f067825ULL, 0x000fc600078e0006ULL,
0x0000000906067210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006037faeULL, 0x0003e6000b901c4eULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000027805ULL, 0x002fce0000015200ULL, 0x018ad005ff0075a7ULL, 0x000e640008000146ULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff087224ULL, 0x000fce00078e00ffULL,
0x000000100800780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fce0000015200ULL, 0x0000000602097210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e03ULL, 0x003d09000900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc80000011407ULL,
0x0000000904047211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000204047819ULL, 0x000fc80000001207ULL, 0x000000040000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000108087836ULL, 0x000fce0000000000ULL,
0x018ad005ff0075a7ULL, 0x000e640008000146ULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000000027919ULL, 0x000e640000000000ULL, 0x000000205f027824ULL, 0x002fca00078e0202ULL,
0x00000003ff037819ULL, 0x000fe40000011602ULL, 0x0000000f02027812ULL, 0x000fe400078ec0ffULL,
0x1ffffffe03037812ULL, 0x000fc600078ec0ffULL, 0x0000000102047836ULL, 0x000fe40000000000ULL,
0x0000000102057824ULL, 0x040fe400078e0203ULL, 0x0000000103067824ULL, 0x000fe400078e0204ULL,
0x0000002002077824ULL, 0x040fe200078e00ffULL, 0x0000001f05057812ULL, 0x000fe200078ec0ffULL,
0x0000002002087824ULL, 0x000fe200078e00ffULL, 0x0000001f06067812ULL, 0x000fe200078ec0ffULL,
0x0000001003037836ULL, 0x000fc60000000000ULL, 0x000001e007067812ULL, 0x000fe200078ee206ULL,
0x0000000102077824ULL, 0x100fe200078e0203ULL, 0x000001e008057812ULL, 0x000fe200078ee205ULL,
0x0000000104037824ULL, 0x000fe200078e0203ULL, 0x0000000606067c11ULL, 0x000fe2000f8e20ffULL,
0x0000002002047824ULL, 0x040fe200078e00ffULL, 0x0000000605057c11ULL, 0x000fe2000f8e20ffULL,
0x0000002002027824ULL, 0x000fe200078e00ffULL, 0x0000001f03037812ULL, 0x000fe200078ec0ffULL,
0x0000000006087984ULL, 0x000e620000000c00ULL, 0x0000001f07077812ULL, 0x000fc400078ec0ffULL,
0x000001e002037812ULL, 0x000fe200078ee203ULL, 0x00000000050c7984ULL, 0x000ea20000000c00ULL,
0x000001e004077812ULL, 0x000fe200078ee207ULL, 0x00000001ff027424ULL, 0x000fe200078e00ffULL,
0x0000000603047c11ULL, 0x000fe4000f8e20ffULL, 0x0000000607077c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff167224ULL, 0x002fe400078e0008ULL, 0x000000ffff177224ULL, 0x000fe400078e000aULL,
0x000000ffff147224ULL, 0x004fc400078e000cULL, 0x000000ffff157224ULL, 0x000fe400078e000eULL,
0x000000ffff1a7224ULL, 0x000fe400078e0009ULL, 0x000000ffff1b7224ULL, 0x000fe200078e000bULL,
0x0000001405007388ULL, 0x000fe20000000c00ULL, 0x000000ffff187224ULL, 0x000fe400078e000dULL,
0x000000ffff197224ULL, 0x000fca00078e000fULL, 0x0000001806007388ULL, 0x000fe80000000c00ULL,
0x0000000004087984ULL, 0x000e680000000c00ULL, 0x00000000070c7984ULL, 0x000ea20000000c00ULL,
0x000000ffff1f7224ULL, 0x002fe400078e000aULL, 0x000000ffff1e7224ULL, 0x000fc400078e0008ULL,
0x000000ffff0a7224ULL, 0x000fe400078e0009ULL, 0x000000ffff1c7224ULL, 0x004fe400078e000cULL,
0x000000ffff1d7224ULL, 0x000fe400078e000eULL, 0x000000ffff087224ULL, 0x000fe400078e000dULL,
0x000000ffff097224ULL, 0x000fe200078e000fULL, 0x0000001c07007388ULL, 0x0003e80000000c00ULL,
0x0000000804007388ULL, 0x0003e20000000c00ULL, 0x018ad002ff0279a7ULL, 0x000ea40008500006ULL,
0x000000ffff067224ULL, 0x006fce00078e0003ULL, 0x0000000000027805ULL, 0x000fce0000015200ULL,
0x018ad006ff0075a7ULL, 0x000e640008000146ULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff087224ULL, 0x000fce00078e00ffULL, 0x000000100800780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fce0000015200ULL,
0x0000000402077210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e03ULL,
0x003d09000700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc80000011405ULL, 0x0000000704047211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000204047819ULL, 0x000fc80000001205ULL,
0x000000040000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000108087836ULL, 0x000fce0000000000ULL, 0x018ad006ff0075a7ULL, 0x000e640008000146ULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00000010ff007c0cULL, 0x000fda000bf05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e620000000000ULL,
0x3d80000000007820ULL, 0x010fe20000410000ULL, 0x0000840000047ab9ULL, 0x000fe20000000800ULL,
0x000000065f447c11ULL, 0x040fe2000f8e18ffULL, 0x000000ffff437224ULL, 0x000fe200078e00ffULL,
0x00000006040b7899ULL, 0x000fe2000800063fULL, 0x00000000001272caULL, 0x000fe200000e0000ULL,
0x000000ffff027224ULL, 0x000fe200078e005fULL, 0x000000065f007c11ULL, 0x000fe2000f8e28ffULL,
0xffffffff10117890ULL, 0x000fe2000fffe03fULL, 0x0000003f00047c82ULL, 0x000fd60008000000ULL,
0x00000100435b7824ULL, 0x000fca00078e0248ULL, 0x0000000d5b007c0cULL, 0x000fda000bf01070ULL,
0x000000000000894dULL, 0x00afea0003800000ULL, 0x00000001ff637424ULL, 0x000fe200078e00ffULL,
0x000000435c00720cULL, 0x000fe20003f44070ULL, 0x0000003f00057c82ULL, 0x000fc60008000000ULL,
0x0000000463637807ULL, 0x000fd20001000000ULL, 0x000000ffff667224ULL, 0x000fe200078e00ffULL,
0x0000000000167805ULL, 0x000fe4000001ff00ULL, 0x0000000000147805ULL, 0x000fe4000001ff00ULL,
0x00000000001e7805ULL, 0x000fe4000001ff00ULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fc4000001ff00ULL,
0x0000000000267805ULL, 0x000fe4000001ff00ULL, 0x0000000000247805ULL, 0x000fe4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fc4000001ff00ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x0000000000367805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000005000a7c82ULL, 0x000fe20008000000ULL, 0x0000000400087c82ULL, 0x000fca0008000000ULL,
0x00000001660c7836ULL, 0x000fe20000000000ULL, 0x000080000000791aULL, 0x000fc80000000000ULL,
0x000000050c0e7c11ULL, 0x040fe2000f8ff8ffULL, 0x0000000108047892ULL, 0x000fe2000f8e0c3fULL,
0x000000ffff627224ULL, 0x000fe200078e0066ULL, 0x000000020c00780cULL, 0x000fe20003f06070ULL,
0x000000ffff667224ULL, 0x000fe200078e000cULL, 0x000000030e387812ULL, 0x000fe400078ec0ffULL,
0x00000002ff0ea819ULL, 0x000fe4000001160eULL, 0x000000010c1a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff38387207ULL, 0x000fe20005000000ULL, 0x000000010e1b7824ULL, 0x000fc800078e0243ULL,
0x000000011b0d7836ULL, 0x000fca0000000000ULL, 0x000000100d007c0cULL, 0x000fe2000bf26070ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000001000749947ULL, 0x000fea0003800000ULL,
0x00000003ff3c7819ULL, 0x002fe20000011603ULL, 0x000001001b3b7824ULL, 0x000fe200078e0248ULL,
0x000000065f3a7c11ULL, 0x040fe2000f8e20ffULL, 0x000000081a527824ULL, 0x000fe200078e00ffULL,
0x000000065f0e7c11ULL, 0x000fe2000f8e70ffULL, 0x000000043c3e7824ULL, 0x000fe400078e0246ULL,
0x00000040133d7824ULL, 0x000fe200078e023cULL, 0x000000000e0c72caULL, 0x000fe200000e0000ULL,
0x000000043c607836ULL, 0x000fe20000000000ULL, 0x018600003e0d7984ULL, 0x000e620000000800ULL,
0x0000000d3b0e7c48ULL, 0x000fc4000ffe0000ULL, 0xfffffff852397812ULL, 0x000fe200078ee203ULL,
0x0000000160537824ULL, 0x000fe400078e0203ULL, 0x000000010e3b7824ULL, 0x000fe400078e0a3bULL,
0x000000013c0e7824ULL, 0x000fe400078e0203ULL, 0x0000000860647824ULL, 0x000fe200078e00ffULL,
0x0000000c04097291ULL, 0x000fe2000f8e683fULL, 0x0000003b3c00720cULL, 0x000fc60003f26070ULL,
0x0000200009097890ULL, 0x000fe2000fffe03fULL, 0x000000040d187824ULL, 0x002fe400078e023aULL,
0x00008a00ff0c7b82ULL, 0x000e680000000a00ULL, 0x018a800018187984ULL, 0x000ea40000000800ULL,
0x0000000b180f7c24ULL, 0x004fe2000f8e023dULL, 0x000000070e187812ULL, 0x000fc600078ec0ffULL,
0x000001000f0e7825ULL, 0x002fe200078e000cULL, 0x0ffffff818187812ULL, 0x000fc800078ef803ULL,
0x00000009183f7c11ULL, 0x000fe2000f8e20ffULL, 0x00000010390e7825ULL, 0x000fca00078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e3f7faeULL, 0x0003e2000c901c4eULL,
0x0000003b6000720cULL, 0x000fe20003f26070ULL, 0x000000083c607836ULL, 0x000fe40000000000ULL,
0x018610003e197984ULL, 0x000ea20000000800ULL, 0xfffffff8643f7812ULL, 0x002fe200078ee253ULL,
0x0000000160537824ULL, 0x040fe400078e0203ULL, 0x0000000860647824ULL, 0x000fe200078e00ffULL,
0x000000093f3f7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000419527824ULL, 0x004fc400078e023aULL,
0x000000043d197836ULL, 0x000fc60000000000ULL, 0x018a800052187984ULL, 0x000e640000000800ULL,
0x0000000b18197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc800078e000cULL,
0x0000001039187825ULL, 0x000fca00078e0018ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000183f7faeULL, 0x0003e2000c901c4eULL, 0x0000003b6000720cULL, 0x000fe20003f26070ULL,
0x0000000c3c607836ULL, 0x000fe40000000000ULL, 0x018620003e0f7984ULL, 0x000ea20000000800ULL,
0xfffffff8643f7812ULL, 0x002fe200078ee253ULL, 0x0000000160537824ULL, 0x040fe400078e0203ULL,
0x0000000860647824ULL, 0x000fe200078e00ffULL, 0x000000093f3f7c11ULL, 0x000fe2000f8e20ffULL,
0x000000040f527824ULL, 0x004fc400078e023aULL, 0x000000083d0f7836ULL, 0x000fc60000000000ULL,
0x018a8000520e7984ULL, 0x000e640000000800ULL, 0x0000000b0e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc800078e000cULL, 0x00000010390e7825ULL, 0x000fca00078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e3f7faeULL, 0x0003e2000c901c4eULL,
0x0000003b6000720cULL, 0x000fe20003f26070ULL, 0x000000103c607836ULL, 0x000fe40000000000ULL,
0x018630003e197984ULL, 0x000ea20000000800ULL, 0xfffffff8643f7812ULL, 0x002fe200078ee253ULL,
0x0000000160537824ULL, 0x040fe400078e0203ULL, 0x0000000860647824ULL, 0x000fe200078e00ffULL,
0x000000093f3f7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000419527824ULL, 0x004fc400078e023aULL,
0x0000000c3d197836ULL, 0x000fc60000000000ULL, 0x018a800052187984ULL, 0x000e640000000800ULL,
0x0000000b18197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc800078e000cULL,
0x0000001039187825ULL, 0x000fca00078e0018ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000183f7faeULL, 0x0003e2000c901c4eULL, 0x0000003b6000720cULL, 0x000fe20003f26070ULL,
0x000000143c607836ULL, 0x000fe40000000000ULL, 0x018640003e0f7984ULL, 0x000ea20000000800ULL,
0xfffffff8643f7812ULL, 0x002fe200078ee253ULL, 0x0000000160537824ULL, 0x040fe400078e0203ULL,
0x0000000860647824ULL, 0x000fe200078e00ffULL, 0x000000093f3f7c11ULL, 0x000fe2000f8e20ffULL,
0x000000040f527824ULL, 0x004fc400078e023aULL, 0x000000103d0f7836ULL, 0x000fc60000000000ULL,
0x018a8000520e7984ULL, 0x000e640000000800ULL, 0x0000000b0e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc800078e000cULL, 0x00000010390e7825ULL, 0x000fca00078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e3f7faeULL, 0x0003e2000c901c4eULL,
0x0000003b6000720cULL, 0x000fe20003f26070ULL, 0x000000183c607836ULL, 0x000fe40000000000ULL,
0x018650003e197984ULL, 0x000ea20000000800ULL, 0xfffffff8643f7812ULL, 0x002fe200078ee253ULL,
0x0000000160537824ULL, 0x040fe400078e0203ULL, 0x0000000860647824ULL, 0x000fe200078e00ffULL,
0x000000093f3f7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000419527824ULL, 0x004fc400078e023aULL,
0x000000143d197836ULL, 0x000fc60000000000ULL, 0x018a800052187984ULL, 0x000e640000000800ULL,
0x0000000b18197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc800078e000cULL,
0x0000001039187825ULL, 0x000fca00078e0018ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000183f7faeULL, 0x0003e2000c901c4eULL, 0x0000003b6000720cULL, 0x000fe20003f26070ULL,
0x0000001c3c607836ULL, 0x000fe40000000000ULL, 0x018660003e0f7984ULL, 0x000ea20000000800ULL,
0xfffffff8643f7812ULL, 0x002fe200078ee253ULL, 0x0000000160537824ULL, 0x040fe400078e0203ULL,
0x0000000860647824ULL, 0x000fe200078e00ffULL, 0x000000093f3f7c11ULL, 0x000fe2000f8e20ffULL,
0x000000040f527824ULL, 0x004fc400078e023aULL, 0x000000183d0f7836ULL, 0x000fc60000000000ULL,
0x018a8000520e7984ULL, 0x000e640000000800ULL, 0x0000000b0e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc800078e000cULL, 0x00000010390e7825ULL, 0x000fca00078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e3f7faeULL, 0x0003e2000c901c4eULL,
0x0000003b6000720cULL, 0x000fe20003f26070ULL, 0x000000203c607836ULL, 0x000fe40000000000ULL,
0x018670003e197984ULL, 0x000ea20000000800ULL, 0xfffffff8643f7812ULL, 0x002fe200078ee253ULL,
0x0000000160537824ULL, 0x040fe400078e0203ULL, 0x0000000860647824ULL, 0x000fe200078e00ffULL,
0x000000093f3f7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000419527824ULL, 0x004fc400078e023aULL,
0x0000001c3d197836ULL, 0x000fc60000000000ULL, 0x018a800052187984ULL, 0x000e640000000800ULL,
0x0000000b18197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc800078e000cULL,
0x0000001039187825ULL, 0x000fca00078e0018ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000183f7faeULL, 0x0003e2000c901c4eULL, 0x0000003b6000720cULL, 0x000fe20003f26070ULL,
0x000000243c607836ULL, 0x000fe40000000000ULL, 0x018680003e0f7984ULL, 0x000ea20000000800ULL,
0xfffffff8643f7812ULL, 0x002fe200078ee253ULL, 0x0000000160537824ULL, 0x040fe400078e0203ULL,
0x0000000860647824ULL, 0x000fe200078e00ffULL, 0x000000093f3f7c11ULL, 0x000fe2000f8e20ffULL,
0x000000040f527824ULL, 0x004fc400078e023aULL, 0x000000203d0f7836ULL, 0x000fc60000000000ULL,
0x018a8000520e7984ULL, 0x000e640000000800ULL, 0x0000000b0e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc800078e000cULL, 0x00000010390e7825ULL, 0x000fca00078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e3f7faeULL, 0x0003e2000c901c4eULL,
0x0000003b6000720cULL, 0x000fe20003f26070ULL, 0x000000283c607836ULL, 0x000fe40000000000ULL,
0x018690003e197984ULL, 0x000ea20000000800ULL, 0xfffffff8643f7812ULL, 0x002fe200078ee253ULL,
0x0000000160537824ULL, 0x040fe400078e0203ULL, 0x0000000860647824ULL, 0x000fe200078e00ffULL,
0x000000093f3f7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000419527824ULL, 0x004fc400078e023aULL,
0x000000243d197836ULL, 0x000fc60000000000ULL, 0x018a800052187984ULL, 0x000e640000000800ULL,
0x0000000b18197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc800078e000cULL,
0x0000001039187825ULL, 0x000fca00078e0018ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000183f7faeULL, 0x0003e2000c901c4eULL, 0x0000003b6000720cULL, 0x000fe20003f26070ULL,
0x0000002c3c607836ULL, 0x000fe40000000000ULL, 0x0186a0003e0f7984ULL, 0x000ea20000000800ULL,
0xfffffff8643f7812ULL, 0x002fe200078ee253ULL, 0x0000000160537824ULL, 0x040fe400078e0203ULL,
0x0000000860647824ULL, 0x000fe200078e00ffULL, 0x000000093f3f7c11ULL, 0x000fe2000f8e20ffULL,
0x000000040f527824ULL, 0x004fc400078e023aULL, 0x000000283d0f7836ULL, 0x000fc60000000000ULL,
0x018a8000520e7984ULL, 0x000e640000000800ULL, 0x0000000b0e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc800078e000cULL, 0x00000010390e7825ULL, 0x000fca00078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e3f7faeULL, 0x0003e2000c901c4eULL,
0x0000003b6000720cULL, 0x000fe20003f26070ULL, 0x000000303c607836ULL, 0x000fe40000000000ULL,
0x0186b0003e197984ULL, 0x000ea20000000800ULL, 0xfffffff8643f7812ULL, 0x002fe200078ee253ULL,
0x0000000160537824ULL, 0x040fe400078e0203ULL, 0x0000000860647824ULL, 0x000fe200078e00ffULL,
0x000000093f3f7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000419527824ULL, 0x004fc400078e023aULL,
0x0000002c3d197836ULL, 0x000fc60000000000ULL, 0x018a800052187984ULL, 0x000e640000000800ULL,
0x0000000b18197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc800078e000cULL,
0x0000001039187825ULL, 0x000fca00078e0018ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000183f7faeULL, 0x0003e2000c901c4eULL, 0x0000003b6000720cULL, 0x000fe20003f26070ULL,
0x000000343c607836ULL, 0x000fe40000000000ULL, 0x0186c0003e0f7984ULL, 0x000ea20000000800ULL,
0xfffffff8643f7812ULL, 0x002fe200078ee253ULL, 0x0000000160537824ULL, 0x040fe400078e0203ULL,
0x0000000860647824ULL, 0x000fe200078e00ffULL, 0x000000093f3f7c11ULL, 0x000fe2000f8e20ffULL,
0x000000040f527824ULL, 0x004fc400078e023aULL, 0x000000303d0f7836ULL, 0x000fc60000000000ULL,
0x018a8000520e7984ULL, 0x000e640000000800ULL, 0x0000000b0e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc800078e000cULL, 0x00000010390e7825ULL, 0x000fca00078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e3f7faeULL, 0x0003e2000c901c4eULL,
0x0000003b6000720cULL, 0x000fe20003f26070ULL, 0x000000383c607836ULL, 0x000fe40000000000ULL,
0x0186d0003e197984ULL, 0x000ea20000000800ULL, 0x0000003c3c3c7836ULL, 0x000fe20000000000ULL,
0xfffffff8643f7812ULL, 0x002fe200078ee253ULL, 0x0000000160537824ULL, 0x040fe400078e0203ULL,
0x0000000860647824ULL, 0x000fe200078e00ffULL, 0x000000093f3f7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000419527824ULL, 0x004fc400078e023aULL, 0x000000343d197836ULL, 0x000fc60000000000ULL,
0x018a800052187984ULL, 0x000e640000000800ULL, 0x0000000b18197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc800078e000cULL, 0x0000001039187825ULL, 0x000fca00078e0018ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000183f7faeULL, 0x0003e2000c901c4eULL,
0x0000003b6000720cULL, 0x000fc60003f26070ULL, 0x0186e0003e0f7984ULL, 0x000ea20000000800ULL,
0xfffffff864197812ULL, 0x002fc800078ee253ULL, 0x0000000919197c11ULL, 0x000fe2000f8e20ffULL,
0x000000040f527824ULL, 0x004fe400078e023aULL, 0x000000383d0f7836ULL, 0x000fe40000000000ULL,
0x0000003c3d3d7836ULL, 0x000fe20000000000ULL, 0x018a8000520e7984ULL, 0x0002a40000000800ULL,
0x000000083c527824ULL, 0x002fe400078e00ffULL, 0x0000000b0e0f7c24ULL, 0x004fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc800078e000cULL, 0x00000010390e7825ULL, 0x000fca00078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e197faeULL, 0x0003e2000c901c4eULL,
0x0000003b3c00720cULL, 0x000fc60003f26070ULL, 0x0186f0003e3f7984ULL, 0x000ea40000000800ULL,
0x000000043f187824ULL, 0x004fe400078e023aULL, 0x000000013c3f7824ULL, 0x000fc800078e0203ULL,
0x018a800018187984ULL, 0x000ea20000000800ULL, 0xfffffff8520f7812ULL, 0x002fc800078ee23fULL,
0x000000090f0f7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000b183d7c24ULL, 0x004fc8000f8e023dULL,
0x000001003d0c7825ULL, 0x000fc800078e000cULL, 0x00000010390c7825ULL, 0x000fca00078e000cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c0f7faeULL, 0x0003e2000c901c4eULL,
0x0000001000247947ULL, 0x000fea0003800000ULL, 0x00000003ff3c7819ULL, 0x102fe20000011603ULL,
0x000000081a3e7824ULL, 0x000fe200078e00ffULL, 0x000000065f3a7c11ULL, 0x040fe4000f8e20ffULL,
0x000000065f0f7c11ULL, 0x000fe2000f8e70ffULL, 0x000000043c3d7824ULL, 0x040fe200078e0246ULL,
0xfffffff83e397812ULL, 0x000fe200078ee203ULL, 0x00000040133b7824ULL, 0x000fe200078e023cULL,
0x000000000f0c72caULL, 0x000fe200000e0000ULL, 0x000000013c187824ULL, 0x000fe200078e0203ULL,
0x018600003d0d7984ULL, 0x000e620000000800ULL, 0x000000043c527836ULL, 0x000fc60000000000ULL,
0x0000000718187812ULL, 0x000fe200078ec0ffULL, 0x0000000152537824ULL, 0x040fe400078e0203ULL,
0x0000000852527824ULL, 0x000fe200078e00ffULL, 0x0ffffff818187812ULL, 0x000fc600078ef803ULL,
0x0000000c04097291ULL, 0x000fe2000f8e683fULL, 0xfffffff852537812ULL, 0x000fe200078ee253ULL,
0x000000083c527836ULL, 0x000fe40000000000ULL, 0x0000200009097890ULL, 0x000fcc000fffe03fULL,
0x00000009183f7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000953537c11ULL, 0x000fe2000f8e20ffULL,
0x000000040d0e7824ULL, 0x002fe400078e023aULL, 0x00008a00ff0c7b82ULL, 0x000e680000000a00ULL,
0x018a80000e0e7984ULL, 0x000ea40000000800ULL, 0x0000000b0e0f7c24ULL, 0x004fc8000f8e023bULL,
0x000001000f0e7825ULL, 0x002fc800078e000cULL, 0x00000010390e7825ULL, 0x000fca00078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e3f7faeULL, 0x0003e8000b901c4eULL,
0x018610003d197984ULL, 0x000ea20000000800ULL, 0x00000001523f7824ULL, 0x042fe400078e0203ULL,
0x0000000852527824ULL, 0x000fca00078e00ffULL, 0xfffffff8523f7812ULL, 0x000fe200078ee23fULL,
0x0000000c3c527836ULL, 0x000fc60000000000ULL, 0x000000093f3f7c11ULL, 0x000fe2000f8e20ffULL,
0x00000004193e7824ULL, 0x004fe400078e023aULL, 0x000000043b197836ULL, 0x000fc60000000000ULL,
0x018a80003e187984ULL, 0x000e640000000800ULL, 0x0000000b18197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc800078e000cULL, 0x0000001039187825ULL, 0x000fca00078e0018ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018537faeULL, 0x0003e8000b901c4eULL,
0x018620003d0f7984ULL, 0x000ea20000000800ULL, 0x0000000152537824ULL, 0x042fe400078e0203ULL,
0x0000000852527824ULL, 0x000fca00078e00ffULL, 0xfffffff852537812ULL, 0x000fe200078ee253ULL,
0x000000103c527836ULL, 0x000fc60000000000ULL, 0x0000000953537c11ULL, 0x000fe2000f8e20ffULL,
0x000000040f3e7824ULL, 0x004fe400078e023aULL, 0x000000083b0f7836ULL, 0x000fc60000000000ULL,
0x018a80003e0e7984ULL, 0x000e640000000800ULL, 0x0000000b0e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc800078e000cULL, 0x00000010390e7825ULL, 0x000fca00078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e3f7faeULL, 0x0003e8000b901c4eULL,
0x018630003d197984ULL, 0x000ea20000000800ULL, 0x00000001523f7824ULL, 0x042fe400078e0203ULL,
0x0000000852527824ULL, 0x000fca00078e00ffULL, 0xfffffff8523f7812ULL, 0x000fe200078ee23fULL,
0x000000143c527836ULL, 0x000fc60000000000ULL, 0x000000093f3f7c11ULL, 0x000fe2000f8e20ffULL,
0x00000004193e7824ULL, 0x004fe400078e023aULL, 0x0000000c3b197836ULL, 0x000fc60000000000ULL,
0x018a80003e187984ULL, 0x000e640000000800ULL, 0x0000000b18197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc800078e000cULL, 0x0000001039187825ULL, 0x000fca00078e0018ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018537faeULL, 0x0003e8000b901c4eULL,
0x018640003d0f7984ULL, 0x000ea20000000800ULL, 0x0000000152537824ULL, 0x042fe400078e0203ULL,
0x0000000852527824ULL, 0x000fca00078e00ffULL, 0xfffffff852537812ULL, 0x000fe200078ee253ULL,
0x000000183c527836ULL, 0x000fc60000000000ULL, 0x0000000953537c11ULL, 0x000fe2000f8e20ffULL,
0x000000040f3e7824ULL, 0x004fe400078e023aULL, 0x000000103b0f7836ULL, 0x000fc60000000000ULL,
0x018a80003e0e7984ULL, 0x000e640000000800ULL, 0x0000000b0e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc800078e000cULL, 0x00000010390e7825ULL, 0x000fca00078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e3f7faeULL, 0x0003e8000b901c4eULL,
0x018650003d197984ULL, 0x000ea20000000800ULL, 0x00000001523f7824ULL, 0x042fe400078e0203ULL,
0x0000000852527824ULL, 0x000fca00078e00ffULL, 0xfffffff8523f7812ULL, 0x000fe200078ee23fULL,
0x0000001c3c527836ULL, 0x000fc60000000000ULL, 0x000000093f3f7c11ULL, 0x000fe2000f8e20ffULL,
0x00000004193e7824ULL, 0x004fe400078e023aULL, 0x000000143b197836ULL, 0x000fc60000000000ULL,
0x018a80003e187984ULL, 0x000e640000000800ULL, 0x0000000b18197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc800078e000cULL, 0x0000001039187825ULL, 0x000fca00078e0018ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018537faeULL, 0x0003e8000b901c4eULL,
0x018660003d0f7984ULL, 0x000ea20000000800ULL, 0x0000000152537824ULL, 0x042fe400078e0203ULL,
0x0000000852527824ULL, 0x000fca00078e00ffULL, 0xfffffff852537812ULL, 0x000fe200078ee253ULL,
0x000000203c527836ULL, 0x000fc60000000000ULL, 0x0000000953537c11ULL, 0x000fe2000f8e20ffULL,
0x000000040f3e7824ULL, 0x004fe400078e023aULL, 0x000000183b0f7836ULL, 0x000fc60000000000ULL,
0x018a80003e0e7984ULL, 0x000e640000000800ULL, 0x0000000b0e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc800078e000cULL, 0x00000010390e7825ULL, 0x000fca00078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e3f7faeULL, 0x0003e8000b901c4eULL,
0x018670003d197984ULL, 0x000ea20000000800ULL, 0x00000001523f7824ULL, 0x042fe400078e0203ULL,
0x0000000852527824ULL, 0x000fca00078e00ffULL, 0xfffffff8523f7812ULL, 0x000fe200078ee23fULL,
0x000000243c527836ULL, 0x000fc60000000000ULL, 0x000000093f3f7c11ULL, 0x000fe2000f8e20ffULL,
0x00000004193e7824ULL, 0x004fe400078e023aULL, 0x0000001c3b197836ULL, 0x000fc60000000000ULL,
0x018a80003e187984ULL, 0x000e640000000800ULL, 0x0000000b18197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc800078e000cULL, 0x0000001039187825ULL, 0x000fca00078e0018ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018537faeULL, 0x0003e8000b901c4eULL,
0x018680003d0f7984ULL, 0x000ea20000000800ULL, 0x0000000152537824ULL, 0x042fe400078e0203ULL,
0x0000000852527824ULL, 0x000fca00078e00ffULL, 0xfffffff852537812ULL, 0x000fe200078ee253ULL,
0x000000283c527836ULL, 0x000fc60000000000ULL, 0x0000000953537c11ULL, 0x000fe2000f8e20ffULL,
0x000000040f3e7824ULL, 0x004fe400078e023aULL, 0x000000203b0f7836ULL, 0x000fc60000000000ULL,
0x018a80003e0e7984ULL, 0x000e640000000800ULL, 0x0000000b0e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc800078e000cULL, 0x00000010390e7825ULL, 0x000fca00078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e3f7faeULL, 0x0003e8000b901c4eULL,
0x018690003d197984ULL, 0x000ea20000000800ULL, 0x00000001523f7824ULL, 0x042fe400078e0203ULL,
0x0000000852527824ULL, 0x000fca00078e00ffULL, 0xfffffff8523f7812ULL, 0x000fe200078ee23fULL,
0x0000002c3c527836ULL, 0x000fc60000000000ULL, 0x000000093f3f7c11ULL, 0x000fe2000f8e20ffULL,
0x00000004193e7824ULL, 0x004fe400078e023aULL, 0x000000243b197836ULL, 0x000fc60000000000ULL,
0x018a80003e187984ULL, 0x000e640000000800ULL, 0x0000000b18197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc800078e000cULL, 0x0000001039187825ULL, 0x000fca00078e0018ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018537faeULL, 0x0003e8000b901c4eULL,
0x0186a0003d0f7984ULL, 0x000ea20000000800ULL, 0x0000000152537824ULL, 0x042fe400078e0203ULL,
0x0000000852527824ULL, 0x000fca00078e00ffULL, 0xfffffff852537812ULL, 0x000fe200078ee253ULL,
0x000000303c527836ULL, 0x000fc60000000000ULL, 0x0000000953537c11ULL, 0x000fe2000f8e20ffULL,
0x000000040f3e7824ULL, 0x004fe400078e023aULL, 0x000000283b0f7836ULL, 0x000fc60000000000ULL,
0x018a80003e0e7984ULL, 0x000e640000000800ULL, 0x0000000b0e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc800078e000cULL, 0x00000010390e7825ULL, 0x000fca00078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e3f7faeULL, 0x0003e8000b901c4eULL,
0x0186b0003d197984ULL, 0x000ea20000000800ULL, 0x00000001523f7824ULL, 0x042fe400078e0203ULL,
0x0000000852527824ULL, 0x000fca00078e00ffULL, 0xfffffff8523f7812ULL, 0x000fe200078ee23fULL,
0x000000343c527836ULL, 0x000fc60000000000ULL, 0x000000093f3f7c11ULL, 0x000fe2000f8e20ffULL,
0x00000004193e7824ULL, 0x004fe400078e023aULL, 0x0000002c3b197836ULL, 0x000fc60000000000ULL,
0x018a80003e187984ULL, 0x000e640000000800ULL, 0x0000000b18197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc800078e000cULL, 0x0000001039187825ULL, 0x000fca00078e0018ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018537faeULL, 0x0003e8000b901c4eULL,
0x0186c0003d0f7984ULL, 0x000ea20000000800ULL, 0x0000000152537824ULL, 0x042fe400078e0203ULL,
0x0000000852527824ULL, 0x000fca00078e00ffULL, 0xfffffff852537812ULL, 0x000fe200078ee253ULL,
0x000000383c527836ULL, 0x000fe40000000000ULL, 0x0000003c3c3c7836ULL, 0x000fe20000000000ULL,
0x0000000953537c11ULL, 0x000fe2000f8e20ffULL, 0x000000040f3e7824ULL, 0x004fe400078e023aULL,
0x000000303b0f7836ULL, 0x000fc60000000000ULL, 0x018a80003e0e7984ULL, 0x000e640000000800ULL,
0x0000000b0e0f7c24ULL, 0x002fc8000f8e020fULL, 0x000001000f0e7825ULL, 0x000fc800078e000cULL,
0x00000010390e7825ULL, 0x000fca00078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e3f7faeULL, 0x0003e8000b901c4eULL, 0x0186d0003d197984ULL, 0x000ea20000000800ULL,
0x00000001523f7824ULL, 0x042fe400078e0203ULL, 0x0000000852527824ULL, 0x000fca00078e00ffULL,
0xfffffff8523f7812ULL, 0x000fc800078ee23fULL, 0x000000093f3f7c11ULL, 0x000fe2000f8e20ffULL,
0x00000004193e7824ULL, 0x004fe400078e023aULL, 0x000000343b197836ULL, 0x000fc60000000000ULL,
0x018a80003e187984ULL, 0x000e640000000800ULL, 0x0000000b18197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc800078e000cULL, 0x0000001039187825ULL, 0x000fca00078e0018ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018537faeULL, 0x0003e8000b901c4eULL,
0x0186e0003d0f7984ULL, 0x000ea20000000800ULL, 0x0000003c3b197836ULL, 0x002fe40000000000ULL,
0x000000040f3e7824ULL, 0x004fe400078e023aULL, 0x000000383b0f7836ULL, 0x000fe40000000000ULL,
0x000000013c3b7824ULL, 0x040fe200078e0203ULL, 0x018a80003e0e7984ULL, 0x000e620000000800ULL,
0x000000083c3c7824ULL, 0x000fca00078e00ffULL, 0xfffffff83c3b7812ULL, 0x000fc800078ee23bULL,
0x000000093b3b7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000b0e0f7c24ULL, 0x002fc8000f8e020fULL,
0x000001000f0e7825ULL, 0x000fc800078e000cULL, 0x00000010390e7825ULL, 0x000fca00078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e3f7faeULL, 0x0003e8000b901c4eULL,
0x0186f0003d3d7984ULL, 0x000ea40000000800ULL, 0x000000043d187824ULL, 0x004fcc00078e023aULL,
0x018a800018187984ULL, 0x000ea40000000800ULL, 0x0000000b18197c24ULL, 0x004fc8000f8e0219ULL,
0x00000100190c7825ULL, 0x000fc800078e000cULL, 0x00000010390c7825ULL, 0x000fca00078e000cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c3b7faeULL, 0x0003e4000b901c4eULL,
0x000000ff1a00720cULL, 0x000fe20003f25270ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000000000bc9947ULL, 0x000fea0003800000ULL, 0x00009200ff0c7b82ULL, 0x002e620000000a00ULL,
0x00000001380e7836ULL, 0x000fe20000000000ULL, 0x000000033800780cULL, 0x000fe20003f85270ULL,
0x00000020033b7836ULL, 0x000fe20000000000ULL, 0x0000001b5c00720cULL, 0x0c0fe40003f64070ULL,
0x0000001b5c00720cULL, 0x000fe40003f24070ULL, 0x00000002ff0f7819ULL, 0x000fe4000001160eULL,
0x000000030e0e7812ULL, 0x000fc400078ec0ffULL, 0x000000010f187807ULL, 0x000fe40004800000ULL,
0x000000ff0e0e7207ULL, 0x000fc60004800000ULL, 0x000000011b1b7824ULL, 0x000fe400078e0218ULL,
0x000000015d397824ULL, 0x000fe400078e020eULL, 0x000001001b187824ULL, 0x000fe200078e0248ULL,
0x000000000044b947ULL, 0x000fec0002000000ULL, 0x000000030300780cULL, 0x000fe20003f24070ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x0000000402027836ULL, 0x000fd60000000000ULL,
0x0000000000301947ULL, 0x000fea0003800000ULL, 0x00008c00ff0e7b82ULL, 0x000ea20000000a00ULL,
0x0000000412197824ULL, 0x000fe200078e0203ULL, 0x0000000702007c0cULL, 0x000fe2000bf26070ULL,
0x0000900000097ab9ULL, 0x000fe20000000800ULL, 0x00000004031b7824ULL, 0x000fe400078e023aULL,
0x0000000219197824ULL, 0x000fc800078e00ffULL, 0x0000000919197c24ULL, 0x000fc8000f8e0202ULL,
0x00000004190e7825ULL, 0x004fca00078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x18a800000e1b7faeULL, 0x0005e4000c92184eULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001180e7824ULL, 0x104fe200078e0203ULL, 0x0000940000097ab9ULL, 0x000fe20000000800ULL,
0x000000013b0f7824ULL, 0x100fe400078e0218ULL, 0x0000000939187c24ULL, 0x000fe2000f8e0218ULL,
0x0000000d0e007c0cULL, 0x000fe2000bf26070ULL, 0x00000004031b7824ULL, 0x000fe200078e0246ULL,
0x0000000d0f007c0cULL, 0x000fe2000bf66070ULL, 0x00000001180f7824ULL, 0x000fe400078e0203ULL,
0x000000013b197824ULL, 0x000fc400078e0218ULL, 0x000000040f0e7825ULL, 0x002fc800078e000cULL,
0x00000004190c7825ULL, 0x000fe400078e000cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x186000000e1b7faeULL, 0x0003e8000c92184eULL, 0x186800000c1b7faeULL, 0x0003e4000d92184eULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000002003647836ULL, 0x000fe20000000000ULL,
0xfffffff8030c7812ULL, 0x042fe200078ec0ffULL, 0x0000000c08087291ULL, 0x000fe2000f8e683fULL,
0x0000000703607812ULL, 0x000fe200078ec0ffULL, 0x000000ffff677224ULL, 0x000fe200078e00ffULL,
0xfffffff864647812ULL, 0x000fe200078ec0ffULL, 0x0000200008087890ULL, 0x000fe2000fffe03fULL,
0x000000070c657812ULL, 0x000fe400078ef803ULL, 0x0000000860617812ULL, 0x000fc400078ef803ULL,
0x0000000764647812ULL, 0x000fce00078ef803ULL, 0x00000001650c7824ULL, 0x140fe400078e0267ULL,
0x00000008650d7824ULL, 0x000fe400078e00ffULL, 0x00000008623a7824ULL, 0x100fe400078e0267ULL,
0x00000020610f7824ULL, 0x000fe200078e00ffULL, 0xfffffff80d0c7812ULL, 0x000fe200078ee20cULL,
0x000000023a3a7824ULL, 0x000fe400078e00ffULL, 0x00000001640d7824ULL, 0x000fe200078e0267ULL,
0x000000080c187c11ULL, 0x000fe2000f8e20ffULL, 0x0000000864387824ULL, 0x000fe200078e00ffULL,
0x0000003a030c7211ULL, 0x000fe200078fe0ffULL, 0x00000001670e7836ULL, 0x000fc40000000000ULL,
0x0000000864397824ULL, 0x040fe200078e00ffULL, 0x000000001818783bULL, 0x000e620000000200ULL,
0x00000001610c7824ULL, 0x000fe200078e020cULL, 0xfffffff8386d7812ULL, 0x000fe200078ee20dULL,
0x0000000165537824ULL, 0x140fe400078e020eULL, 0x00000001643c7824ULL, 0x000fe200078e020eULL,
0xffffffe00f0c7812ULL, 0x000fe200078ee20cULL, 0x00000008653e7824ULL, 0x000fe400078e00ffULL,
0x000000023a3a7836ULL, 0x000fe20000000000ULL, 0x000000060c0c7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000267677836ULL, 0x000fe20000000000ULL, 0xfffffff8393c7812ULL, 0x000fc400078ee23cULL,
0xfffffff83e537812ULL, 0x000fe400078ee253ULL, 0x000000000c0c783bULL, 0x000ea20000000200ULL,
0x000000083c3c7c11ULL, 0x000fe4000f8e20ffULL, 0x000000086700780cULL, 0x000fe40003f25270ULL,
0x00000010ff6e7819ULL, 0x102fe40000011618ULL, 0x00000018ff6f7819ULL, 0x000fe40000011618ULL,
0x000000ff18707812ULL, 0x000fc400078ec0ffULL, 0x0000ffff18187812ULL, 0x000fe400078ec0ffULL,
0x00000010ff3b7819ULL, 0x100fe40000011619ULL, 0x00000008ff187819ULL, 0x000fe40000011618ULL,
0x00000018ff397819ULL, 0x000fe40000011619ULL, 0x000000ff19387812ULL, 0x040fe400078ec0ffULL,
0x0000ffff196b7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff19723eULL, 0x000fe400020006ffULL,
0x000000086d187c11ULL, 0x000fe4000f8e20ffULL, 0x00000010ff6c7819ULL, 0x100fe2000001161aULL,
0x20000019ff6d7230ULL, 0x000fe20000004100ULL, 0x00000018ff687819ULL, 0x000fe4000001161aULL,
0x000000ff1a527812ULL, 0x040fe400078ec0ffULL, 0x0000ffff1a3e7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff3d7819ULL, 0x100fe4000001161bULL, 0x00000018ff6a7819ULL, 0x000fe4000001161bULL,
0x000000ff1b3f7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff1b697812ULL, 0x000fe400078ec0ffULL,
0x000000001818783bULL, 0x000e620000000200ULL, 0x000000ff6e6e7812ULL, 0x000fe400078ec0ffULL,
0x0000006fff6f723eULL, 0x000fc400020006ffULL, 0x00000070ff70723eULL, 0x000fe400020006ffULL,
0x0000006eff6e723eULL, 0x000fe200020006ffULL, 0x2000006fff6f7230ULL, 0x000fe20000004100ULL,
0x000000ff3b3b7812ULL, 0x000fe200078ec0ffULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x00000008ff6b7819ULL, 0x000fe2000001166bULL, 0x2000006eff6e7230ULL, 0x000fe20000004100ULL,
0x00000010ff727819ULL, 0x000fe4000001166fULL, 0x00000010ff707819ULL, 0x000fc40000011670ULL,
0x00000010ff717819ULL, 0x000fe4000001166eULL, 0x00000010ff6f7819ULL, 0x000fe4000001166dULL,
0x00000039ff6e723eULL, 0x000fe400020006ffULL, 0x00000038ff6d723eULL, 0x000fe400020006ffULL,
0x0000105472397816ULL, 0x000fe20000000071ULL, 0x2000006eff6e7230ULL, 0x000fe20000004100ULL,
0x000010546f387816ULL, 0x000fe20000000070ULL, 0x2000006dff6d7230ULL, 0x000fe20000004100ULL,
0x0000003bff3b723eULL, 0x000fc400020006ffULL, 0x0000006bff6b723eULL, 0x000fe400020006ffULL,
0x000000ff6c6c7812ULL, 0x000fe200078ec0ffULL, 0x2000003bff3b7230ULL, 0x000fe20000004100ULL,
0x00000068ff68723eULL, 0x000fe200020006ffULL, 0x2000006bff6b7230ULL, 0x000fe20000004100ULL,
0x0000006cff6c723eULL, 0x000fe200020006ffULL, 0x000000380c34723cULL, 0x004fe20000041834ULL,
0x00000010ff6e7819ULL, 0x000fe2000001166eULL, 0x20000068ff687230ULL, 0x000fe20000004100ULL,
0x00000010ff3b7819ULL, 0x000fe2000001163bULL, 0x2000006cff6c7230ULL, 0x000fe20000004100ULL,
0x00000010ff6b7819ULL, 0x000fc4000001166bULL, 0x0000003a03387211ULL, 0x000fe400078fe0ffULL,
0x00000010ff3a7819ULL, 0x000fe2000001166dULL, 0x00000020616d7824ULL, 0x040fe200078e00ffULL,
0x000010546e3b7816ULL, 0x000fe2000000003bULL, 0x0000000161387824ULL, 0x000fe200078e0238ULL,
0x000010546b3a7816ULL, 0x000fe4000000003aULL, 0x00000010ff6e7819ULL, 0x000fe40000011668ULL,
0x00000010ff397819ULL, 0x000fc4000001166cULL, 0x00000008ff3e7819ULL, 0x000fe2000001163eULL,
0x0000003a0c30723cULL, 0x000fe20000041830ULL, 0xffffffe06d687812ULL, 0x000fe400078ee238ULL,
0x0000006aff38723eULL, 0x000fe400020006ffULL, 0x00000018ff757819ULL, 0x002fe40000011619ULL,
0x00000052ff52723eULL, 0x000fe400020006ffULL, 0x000010546e397816ULL, 0x000fc40000000039ULL,
0x000000ff196b7812ULL, 0x000fe200078ec0ffULL, 0x20000052ff527230ULL, 0x000fe20000004100ULL,
0x0000003eff3e723eULL, 0x000fe400020006ffULL, 0x00000010ff3b7819ULL, 0x100fe40000011618ULL,
0x00000018ff6e7819ULL, 0x000fe20000011618ULL, 0x2000003eff3e7230ULL, 0x000fe20000004100ULL,
0x000000ff186f7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff18717812ULL, 0x000fc400078ec0ffULL,
0x00000010ff187819ULL, 0x100fe4000001161bULL, 0x00000018ff747819ULL, 0x000fe4000001161bULL,
0x000000ff1b727812ULL, 0x040fe400078ec0ffULL, 0x0000ffff1b6a7812ULL, 0x000fe200078ec0ffULL,
0x20000038ff1b7230ULL, 0x000fe20000004100ULL, 0x0000003fff3f723eULL, 0x000fe400020006ffULL,
0x00000075ff75723eULL, 0x000fc400020006ffULL, 0x00000018ff6c7819ULL, 0x000fe2000001161aULL,
0x2000003fff707230ULL, 0x000fe20000004100ULL, 0x0000006bff38723eULL, 0x000fe200020006ffULL,
0x20000075ff6b7230ULL, 0x000fe20000004100ULL, 0x000000ff1a737812ULL, 0x000fe400078ec0ffULL,
0x0000006cff3f723eULL, 0x000fe200020006ffULL, 0x20000038ff6c7230ULL, 0x000fe20000004100ULL,
0x00000072ff72723eULL, 0x000fe400020006ffULL, 0x00000073ff75723eULL, 0x000fe200020006ffULL,
0x2000003fff3f7230ULL, 0x000fe20000004100ULL, 0x00000010ff387819ULL, 0x000fc40000011652ULL,
0x00000010ff737819ULL, 0x000fe2000001163eULL, 0x20000072ff3e7230ULL, 0x000fe20000004100ULL,
0x000000ff3d3d7812ULL, 0x000fe200078ec0ffULL, 0x20000075ff527230ULL, 0x000fe20000004100ULL,
0x0000105473387816ULL, 0x000fe40000000038ULL, 0x00000008ff727819ULL, 0x000fe40000011669ULL,
0x00000074ff76723eULL, 0x000fe400020006ffULL, 0x000000ff3b737812ULL, 0x000fe200078ec0ffULL,
0x000000380c2c723cULL, 0x000fe2000004182cULL, 0x0000003dff74723eULL, 0x000fe200020006ffULL,
0x20000076ff3d7230ULL, 0x000fe20000004100ULL, 0x00000008ff3b7819ULL, 0x000fc40000011671ULL,
0x00000010ff3a7819ULL, 0x000fe20000011619ULL, 0x20000074ff697230ULL, 0x000fe20000004100ULL,
0x00000072ff71723eULL, 0x000fe400020006ffULL, 0x0000ffff19197812ULL, 0x000fe400078ec0ffULL,
0x00000073ff72723eULL, 0x000fe200020006ffULL, 0x20000071ff717230ULL, 0x000fe20000004100ULL,
0x00000008ff737819ULL, 0x000fe40000011619ULL, 0x00000010ff6d7819ULL, 0x000fe2000001161aULL,
0x20000072ff197230ULL, 0x000fe20000004100ULL, 0x00000010ff727819ULL, 0x000fc4000001161bULL,
0x00000010ff1b7819ULL, 0x000fe40000011669ULL, 0x0000ffff1a1a7812ULL, 0x000fe400078ec0ffULL,
0x0000006fff6f723eULL, 0x000fe400020006ffULL, 0x0000000853767c11ULL, 0x000fe4000f8e20ffULL,
0x0000003bff53723eULL, 0x000fe200020006ffULL, 0x2000006fff6f7230ULL, 0x000fe20000004100ULL,
0x00001054721b7816ULL, 0x000fc4000000001bULL, 0x0000006eff6e723eULL, 0x000fe400020006ffULL,
0x00000008ff727819ULL, 0x000fe4000001161aULL, 0x00000010ff1a7819ULL, 0x000fe20000011670ULL,
0x2000006eff6e7230ULL, 0x000fe20000004100ULL, 0x00000010ff717819ULL, 0x000fe40000011671ULL,
0x000000ff3a747812ULL, 0x000fe400078ec0ffULL, 0x000000ff6d757812ULL, 0x000fe200078ec0ffULL,
0x000000007638783bULL, 0x000e620000000200ULL, 0x20000053ff6d7230ULL, 0x000fe20000004100ULL,
0x00001054711a7816ULL, 0x000fc4000000001aULL, 0x000000ff18717812ULL, 0x000fe400078ec0ffULL,
0x00000010ff187819ULL, 0x000fe4000001166fULL, 0x00000074ff74723eULL, 0x000fe200020006ffULL,
0x0000001a0c28723cULL, 0x000fe20000041828ULL, 0x00000010ff6f7819ULL, 0x000fe4000001166dULL,
0x00000073ff73723eULL, 0x000fe200020006ffULL, 0x20000074ff697230ULL, 0x000fe20000004100ULL,
0x00000010ff6e7819ULL, 0x000fc4000001166eULL, 0x00000010ff197819ULL, 0x000fe20000011619ULL,
0x20000073ff707230ULL, 0x000fe20000004100ULL, 0x00000075ff53723eULL, 0x000fe400020006ffULL,
0x00000072ff72723eULL, 0x000fe400020006ffULL, 0x000010546f187816ULL, 0x000fe20000000018ULL,
0x20000053ff537230ULL, 0x000fe20000004100ULL, 0x00000008ff6f7819ULL, 0x000fe2000001166aULL,
0x20000072ff6d7230ULL, 0x000fe20000004100ULL, 0x000010546e197816ULL, 0x000fc40000000019ULL,
0x0000006fff6f723eULL, 0x000fe400020006ffULL, 0x00000010ff1b7819ULL, 0x000fe40000011669ULL,
0x00000010ff6e7819ULL, 0x000fe2000001166bULL, 0x000000180c24723cULL, 0x000fe20000041824ULL,
0x00000010ff1a7819ULL, 0x000fe2000001166cULL, 0x2000006fff6f7230ULL, 0x000fe20000004100ULL,
0x00000010ff697819ULL, 0x000fe40000011670ULL, 0x00000010ff6c7819ULL, 0x000fc4000001163fULL,
0x00000010ff187819ULL, 0x000fe40000011652ULL, 0x00000010ff197819ULL, 0x000fe40000011653ULL,
0x00000010ff6d7819ULL, 0x000fe4000001166dULL, 0x000010546e1b7816ULL, 0x000fe4000000001bULL,
0x00001054691a7816ULL, 0x000fe4000000001aULL, 0x00000071ff71723eULL, 0x000fc400020006ffULL,
0x000010546c197816ULL, 0x000fe40000000019ULL, 0x000010546d187816ULL, 0x000fe20000000018ULL,
0x20000071ff6a7230ULL, 0x000fe20000004100ULL, 0x00000010ff3e7819ULL, 0x000fe2000001163eULL,
0x0000001a0c20723cULL, 0x000fe20000041820ULL, 0x00000010ff6f7819ULL, 0x000fe4000001166fULL,
0x00000010ff537819ULL, 0x000fe4000001166aULL, 0x000010546f527816ULL, 0x000fe2000000003eULL,
0x000000180c1c723cULL, 0x000fe2000004181cULL, 0x00000010ff1a7819ULL, 0x000fc4000001163dULL,
0x000000003c3c783bULL, 0x000ea20000000200ULL, 0x00000018ff697819ULL, 0x002fe40000011638ULL,
0x000010541a537816ULL, 0x000fe40000000053ULL, 0x0000000668187c11ULL, 0x000fe4000f8e20ffULL,
0x000000ff386b7812ULL, 0x000fe400078ec0ffULL, 0x00000069ff69723eULL, 0x000fe200020006ffULL,
0x000000520c14723cULL, 0x000fe20000041814ULL, 0x000000001818783bULL, 0x000e620000000200ULL,
0x00000018ff6e7819ULL, 0x000fc40000011639ULL, 0x0000006bff6b723eULL, 0x000fe400020006ffULL,
0x00000010ff707819ULL, 0x000fe40000011638ULL, 0x0000ffff38737812ULL, 0x000fe400078ec0ffULL,
0x0000006eff75723eULL, 0x000fe200020006ffULL, 0x20000069ff6e7230ULL, 0x000fe20000004100ULL,
0x0000ffff39717812ULL, 0x040fe400078ec0ffULL, 0x000000ff70697812ULL, 0x000fe200078ec0ffULL,
0x2000006bff707230ULL, 0x000fe20000004100ULL, 0x000000ff39727812ULL, 0x000fc400078ec0ffULL,
0x00000008ff6b7819ULL, 0x000fe40000011673ULL, 0x00000008ff717819ULL, 0x000fe40000011671ULL,
0x00000010ff6f7819ULL, 0x000fe40000011639ULL, 0x00000072ff74723eULL, 0x000fe400020006ffULL,
0x00000069ff73723eULL, 0x000fe200020006ffULL, 0x20000075ff697230ULL, 0x000fe20000004100ULL,
0x0000006bff72723eULL, 0x000fe200020006ffULL, 0x20000074ff6b7230ULL, 0x000fe20000004100ULL,
0x00000071ff71723eULL, 0x000fe200020006ffULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x000000ff6f6f7812ULL, 0x000fe200078ec0ffULL, 0x20000072ff727230ULL, 0x000fe20000004100ULL,
0x000000ff3a6d7812ULL, 0x000fe200078ec0ffULL, 0x20000071ff717230ULL, 0x000fe20000004100ULL,
0x0000006fff6f723eULL, 0x000fc400020006ffULL, 0x00000018ff6c7819ULL, 0x000fe4000001163aULL,
0x00000018ff6a7819ULL, 0x000fe2000001163bULL, 0x2000006fff6f7230ULL, 0x000fe20000004100ULL,
0x000000ff3b687812ULL, 0x000fe400078ec0ffULL, 0x00000010ff6e7819ULL, 0x000fe4000001166eULL,
0x00000010ff0e7819ULL, 0x000fe40000011670ULL, 0x00000010ff0f7819ULL, 0x000fc40000011673ULL,
0x00000010ff0d7819ULL, 0x000fe40000011672ULL, 0x00000010ff0c7819ULL, 0x000fe4000001166bULL,
0x00000010ff717819ULL, 0x000fe40000011671ULL, 0x0000006dff6d723eULL, 0x000fe400020006ffULL,
0x0000006cff6c723eULL, 0x000fe400020006ffULL, 0x00000018ff6b7819ULL, 0x004fc4000001163cULL,
0x0000006aff6a723eULL, 0x000fe200020006ffULL, 0x2000006cff737230ULL, 0x000fe20000004100ULL,
0x00000068ff68723eULL, 0x000fe400020006ffULL, 0x000010546e0f7816ULL, 0x000fe2000000000fULL,
0x2000006aff6c7230ULL, 0x000fe20000004100ULL, 0x000010540d0e7816ULL, 0x000fe4000000000eULL,
0x00000010ff527819ULL, 0x000fe40000011669ULL, 0x00001054710c7816ULL, 0x000fe2000000000cULL,
0x2000006dff717230ULL, 0x000fe20000004100ULL, 0x00000018ff747819ULL, 0x000fe2000001163dULL,
0x0000000e1834723cULL, 0x002fe20000041834ULL, 0x000000ff3d537812ULL, 0x000fc400078ec0ffULL,
0x00000010ff0d7819ULL, 0x000fe4000001166fULL, 0x00000018ff697819ULL, 0x000fe4000001163eULL,
0x000000ff3c757812ULL, 0x000fe400078ec0ffULL, 0x0000006bff6d723eULL, 0x000fe200020006ffULL,
0x20000068ff6b7230ULL, 0x000fe20000004100ULL, 0x00000074ff68723eULL, 0x000fe400020006ffULL,
0x00000053ff6a723eULL, 0x000fe200020006ffULL, 0x2000006dff6d7230ULL, 0x000fe20000004100ULL,
0x00000010ff397819ULL, 0x000fe2000001163aULL, 0x20000068ff687230ULL, 0x000fe20000004100ULL,
0x00001054520d7816ULL, 0x000fc4000000000dULL, 0x00000069ff74723eULL, 0x000fe200020006ffULL,
0x2000006aff697230ULL, 0x000fe20000004100ULL, 0x0000ffff3a3a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff6f7819ULL, 0x000fe2000001163dULL, 0x20000074ff6a7230ULL, 0x000fe20000004100ULL,
0x0000ffff3d527812ULL, 0x000fe200078ec0ffULL, 0x0000000c1830723cULL, 0x000fe20000041830ULL,
0x00000075ff75723eULL, 0x000fe400020006ffULL, 0x00000010ff387819ULL, 0x000fc4000001163bULL,
0x00000010ff0f7819ULL, 0x000fe2000001163eULL, 0x20000075ff537230ULL, 0x000fe20000004100ULL,
0x000000ff3e3d7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff3e6e7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff3b3b7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff3e7819ULL, 0x000fe4000001163fULL,
0x0000ffff3c727812ULL, 0x000fc400078ec0ffULL, 0x00000010ff707819ULL, 0x000fe4000001163cULL,
0x00000008ff3a7819ULL, 0x000fe4000001163aULL, 0x000000ff3f3c7812ULL, 0x000fe400078ec0ffULL,
0x0000003dff3d723eULL, 0x000fe400020006ffULL, 0x000000ff39397812ULL, 0x000fe400078ec0ffULL,
0x000000ff38747812ULL, 0x000fc400078ec0ffULL, 0x0000003eff75723eULL, 0x000fe400020006ffULL,
0x00000008ff387819ULL, 0x000fe4000001163bULL, 0x00000008ff727819ULL, 0x000fe40000011672ULL,
0x0000003aff3a723eULL, 0x000fe400020006ffULL, 0x0000003cff3e723eULL, 0x000fe200020006ffULL,
0x2000003dff3c7230ULL, 0x000fe20000004100ULL, 0x00000039ff39723eULL, 0x000fe200020006ffULL,
0x20000075ff3d7230ULL, 0x000fe20000004100ULL, 0x00000038ff38723eULL, 0x000fe200020006ffULL,
0x2000003eff3e7230ULL, 0x000fe20000004100ULL, 0x00000072ff72723eULL, 0x000fe200020006ffULL,
0x20000039ff3b7230ULL, 0x000fe20000004100ULL, 0x00000074ff75723eULL, 0x000fe200020006ffULL,
0x2000003aff747230ULL, 0x000fe20000004100ULL, 0x00000008ff6e7819ULL, 0x000fc4000001166eULL,
0x00000010ff0e7819ULL, 0x000fe2000001163fULL, 0x20000075ff397230ULL, 0x000fe20000004100ULL,
0x000000ff6f3a7812ULL, 0x000fe200078ec0ffULL, 0x20000038ff6f7230ULL, 0x000fe20000004100ULL,
0x000000ff0f0f7812ULL, 0x000fe200078ec0ffULL, 0x20000072ff387230ULL, 0x000fe20000004100ULL,
0x0000006eff72723eULL, 0x000fe400020006ffULL, 0x0000000fff75723eULL, 0x000fe400020006ffULL,
0x000000ff0e6e7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff0e7819ULL, 0x000fe40000011673ULL,
0x00000010ff0f7819ULL, 0x000fe4000001163bULL, 0x00000008ff527819ULL, 0x000fe40000011652ULL,
0x000010540e0f7816ULL, 0x000fe4000000000fULL, 0x00000010ff0e7819ULL, 0x000fe40000011671ULL,
0x0000ffff3f3f7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff717819ULL, 0x000fe40000011674ULL,
0x0000003aff3a723eULL, 0x000fe400020006ffULL, 0x00000052ff52723eULL, 0x000fe400020006ffULL,
0x000000ff70707812ULL, 0x000fe200078ec0ffULL, 0x2000003aff3a7230ULL, 0x000fe20000004100ULL,
0x00000008ff737819ULL, 0x000fe2000001163fULL, 0x20000052ff3b7230ULL, 0x000fe20000004100ULL,
0x00001054710e7816ULL, 0x000fe2000000000eULL, 0x20000072ff3f7230ULL, 0x000fe20000004100ULL,
0x00000010ff6c7819ULL, 0x000fc4000001166cULL, 0x00000010ff0c7819ULL, 0x000fe4000001166bULL,
0x00000010ff0d7819ULL, 0x000fe20000011639ULL, 0x0000000e182c723cULL, 0x000fe2000004182cULL,
0x00000010ff6f7819ULL, 0x000fe4000001166fULL, 0x00000070ff70723eULL, 0x000fe400020006ffULL,
0x0000006eff52723eULL, 0x000fe200020006ffULL, 0x20000075ff6e7230ULL, 0x000fe20000004100ULL,
0x00000073ff73723eULL, 0x000fe200020006ffULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x000010546c0d7816ULL, 0x000fe2000000000dULL, 0x20000052ff527230ULL, 0x000fe20000004100ULL,
0x000010546f0c7816ULL, 0x000fe2000000000cULL, 0x20000073ff6b7230ULL, 0x000fe20000004100ULL,
0x00000010ff0f7819ULL, 0x000fc40000011668ULL, 0x00000010ff0e7819ULL, 0x000fe4000001163aULL,
0x00000010ff3a7819ULL, 0x000fe2000001163bULL, 0x0000000c1828723cULL, 0x000fe20000041828ULL,
0x000010540f3b7816ULL, 0x000fe4000000000eULL, 0x00000010ff727819ULL, 0x000fe4000001166dULL,
0x00000010ff0e7819ULL, 0x000fe4000001163cULL, 0x00000010ff397819ULL, 0x000fc40000011670ULL,
0x00000010ff537819ULL, 0x000fe40000011653ULL, 0x00000010ff697819ULL, 0x000fe40000011669ULL,
0x00000010ff6d7819ULL, 0x000fe4000001166aULL, 0x00000010ff387819ULL, 0x000fe40000011638ULL,
0x00000010ff6e7819ULL, 0x000fe4000001166eULL, 0x00000010ff3c7819ULL, 0x000fc4000001163dULL,
0x00000010ff3f7819ULL, 0x000fe4000001163fULL, 0x00000010ff0d7819ULL, 0x000fe40000011652ULL,
0x00000010ff0c7819ULL, 0x000fe4000001163eULL, 0x00000010ff6b7819ULL, 0x000fe4000001166bULL,
0x0000105472397816ULL, 0x000fe40000000039ULL, 0x0000105438387816ULL, 0x000fc40000000053ULL,
0x000010543a3a7816ULL, 0x000fe40000000069ULL, 0x000010546d0f7816ULL, 0x000fe4000000006eULL,
0x000010543f0e7816ULL, 0x000fe2000000000eULL, 0x000000381824723cULL, 0x000fe20000041824ULL,
0x000010543c0d7816ULL, 0x000fe4000000000dULL, 0x000010546b0c7816ULL, 0x000fc6000000000cULL,
0x0000003a1820723cULL, 0x000fec0000041820ULL, 0x0000000e181c723cULL, 0x000fec000004181cULL,
0x0000000c1814723cULL, 0x000fe20000041814ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0xffffffe800201947ULL, 0x000fde000383ffffULL, 0x0000000400087c82ULL, 0x000fe20008000000ULL,
0xffffffc0004c8947ULL, 0x000fea000383ffffULL, 0x00000002ff0c7819ULL, 0x000fc80000011603ULL,
0x000000050c007c0cULL, 0x000fe2000bf06070ULL, 0x0000000105057890ULL, 0x000fcc000fffe03fULL,
0x000000050c007c0cULL, 0x000fe2000c706470ULL, 0x000000080c0c7836ULL, 0x000fc60000000000ULL,
0x000000435c00720cULL, 0x000fe40000703070ULL, 0x0000000a0c007c0cULL, 0x000fc8000bf26070ULL,
0x000000050c007c0cULL, 0x000fc80008f21070ULL, 0x000000435c00720cULL, 0x000fc60000f24470ULL,
0x000000ffff588224ULL, 0x000fe200078e0015ULL, 0x0000005e175e7208ULL, 0x000fe20000800000ULL,
0x000000ffff558224ULL, 0x000fe200078e0014ULL, 0x0000005916597208ULL, 0x000fe20000800000ULL,
0x000000ffff568224ULL, 0x000fe200078e001dULL, 0x0000005a1f5a7208ULL, 0x000fe20000800000ULL,
0x000000ffff518224ULL, 0x000fe200078e001cULL, 0x000000571e577208ULL, 0x000fe20000800000ULL,
0x000000ffff548224ULL, 0x000fe200078e0021ULL, 0x0000000623067208ULL, 0x000fe20000800000ULL,
0x000000ffff4f8224ULL, 0x000fe200078e0020ULL, 0x0000000722077208ULL, 0x000fe20000800000ULL,
0x000000ffff508224ULL, 0x000fe200078e0025ULL, 0x0000000827087208ULL, 0x000fe20000800000ULL,
0x000000ffff4d8224ULL, 0x000fe200078e0024ULL, 0x0000000926097208ULL, 0x000fe20000800000ULL,
0x000000ffff4e8224ULL, 0x000fe200078e0029ULL, 0x0000000a2b0a7208ULL, 0x000fe20000800000ULL,
0x000000ffff4b8224ULL, 0x000fe200078e0028ULL, 0x0000000b2a0b7208ULL, 0x000fe20000800000ULL,
0x000000ffff4c8224ULL, 0x000fe200078e002dULL, 0x000000102f107208ULL, 0x000fe20000800000ULL,
0x000000ffff498224ULL, 0x000fe200078e002cULL, 0x000000112e117208ULL, 0x000fe20000800000ULL,
0x000000ffff4a8224ULL, 0x000fe200078e0031ULL, 0x0000004033407208ULL, 0x000fe20000800000ULL,
0x000000ffff478224ULL, 0x000fe200078e0030ULL, 0x0000004132417208ULL, 0x000fe20000800000ULL,
0x000000ffff458224ULL, 0x000fe200078e0035ULL, 0x0000004237427208ULL, 0x000fe20000800000ULL,
0x000000ffff048224ULL, 0x000fe200078e0034ULL, 0x0000000563007c0cULL, 0x000fc4000bf03070ULL,
0x0000000536057208ULL, 0x000fd60000800000ULL, 0xffffffbc00548947ULL, 0x000fea000383ffffULL,
0x00000001ff0f7424ULL, 0x000fe400078e00ffULL, 0x00000012040d7c20ULL, 0x000fe20008410000ULL,
0x0000001245457c20ULL, 0x000fe20008410000ULL, 0x0000001247477c20ULL, 0x000fe20008410000ULL,
0x000000124a4a7c20ULL, 0x000fe20008410000ULL, 0x0000001249497c20ULL, 0x000fe20008410000ULL,
0x018b580f440e79a7ULL, 0x000e62000850003fULL, 0x000000124c4c7c20ULL, 0x000fe20008410000ULL,
0x000000124b4b7c20ULL, 0x000fe20008410000ULL, 0x000000124e4e7c20ULL, 0x000fe20008410000ULL,
0x000000124d4d7c20ULL, 0x000fe20008410000ULL, 0x0000001250507c20ULL, 0x000fe20008410000ULL,
0x000000124f4f7c20ULL, 0x000fe20008410000ULL, 0x0000001254547c20ULL, 0x000fe20008410000ULL,
0x0000001251517c20ULL, 0x000fe20008410000ULL, 0x0000001256567c20ULL, 0x000fe20008410000ULL,
0x0000001255557c20ULL, 0x000fe20008410000ULL, 0x0000001258587c20ULL, 0x000fe20008410000ULL,
0x00000012050c7c20ULL, 0x000fe20008410000ULL, 0x0000001242427c20ULL, 0x000fe20008410000ULL,
0x0000001241417c20ULL, 0x000fe20008410000ULL, 0x0000001240407c20ULL, 0x000fe20008410000ULL,
0x0000001211117c20ULL, 0x000fe20008410000ULL, 0x0000001210107c20ULL, 0x000fe20008410000ULL,
0x000000120b0b7c20ULL, 0x000fe20008410000ULL, 0x000000120a0a7c20ULL, 0x000fe20008410000ULL,
0x0000001209097c20ULL, 0x000fe20008410000ULL, 0x0000001208087c20ULL, 0x000fe20008410000ULL,
0x0000001207077c20ULL, 0x000fe20008410000ULL, 0x0000001206067c20ULL, 0x000fe20008410000ULL,
0x000000ffff177224ULL, 0x002fc400078e000fULL, 0x0000001257577c20ULL, 0x000fe20008410000ULL,
0x000000125a5a7c20ULL, 0x000fe20008410000ULL, 0x0000001259597c20ULL, 0x000fe20008410000ULL,
0x000000125e5e7c20ULL, 0x000fe20008410000ULL, 0x0000000000047805ULL, 0x000fe20000015200ULL,
0x018b5817440075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff147224ULL, 0x000fce00078e00ffULL, 0x000000101400780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000000e7805ULL, 0x000fcc0000015200ULL,
0x0000000e04157210ULL, 0x000fca0007f1e1ffULL, 0x000000010f0f7824ULL, 0x000fe200000e0e05ULL,
0x003d09001500780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401500780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff0e7819ULL, 0x000fc8000001140fULL, 0x000000150e0e7211ULL, 0x000fca00078110ffULL,
0x000000ffff0f7224ULL, 0x000fca00000e060fULL, 0x000000020e0e7819ULL, 0x000fc8000000120fULL,
0x0000000e0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000114147836ULL, 0x000fce0000000000ULL, 0x018b5817440075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000403047824ULL, 0x000fe200078e00ffULL,
0x000000065f307c11ULL, 0x000fe4000f8e38ffULL, 0x0000001143007c0cULL, 0x000fe4000bf05270ULL,
0xfffffff004057812ULL, 0x000fca00078ec0ffULL, 0x0000000130307824ULL, 0x000fca00078e0205ULL,
0x01840000301c7984ULL, 0x0002a20000000c00ULL, 0x0000000400080947ULL, 0x000fea0003800000ULL,
0x0000000203047824ULL, 0x000fe200078e00ffULL, 0x0000000d5b5b7c10ULL, 0x000fc8000fffe1ffULL,
0x0000000604047812ULL, 0x000fc800078ec0ffULL, 0x00000001040e7812ULL, 0x040fe400078efcffULL,
0x0000000804147812ULL, 0x000fe400078efcffULL, 0x0000005b0e00720cULL, 0x080fe40003f26070ULL,
0x00000010040e7812ULL, 0x000fe400078efcffULL, 0x0000005b1400720cULL, 0x080fe40003f06070ULL,
0x0000005b0e00720cULL, 0x000fc40003fc6070ULL, 0x0000001104147812ULL, 0x040fe400078efcffULL,
0x00000018040e7812ULL, 0x040fe400078efcffULL, 0x0000005b0400720cULL, 0x080fe40003f46070ULL,
0x0000005b1400720cULL, 0x080fe40003fa6070ULL, 0x0000005b0e00720cULL, 0x000fe40003f66070ULL,
0x0000000904167812ULL, 0x000fc400078efcffULL, 0x0000001904147812ULL, 0x040fe400078efcffULL,
0x00000020040e7812ULL, 0x000fe400078efcffULL, 0xff8000000c0c7808ULL, 0x000fe40005000000ULL,
0xff8000000d0d7808ULL, 0x000fe40005000000ULL, 0xff80000042427808ULL, 0x000fe40004800000ULL,
0xff80000045457808ULL, 0x000fc40004800000ULL, 0x0000005b1600720cULL, 0x080fe40003f86070ULL,
0x0000005b1400720cULL, 0x080fe40003f46070ULL, 0x0000005b0e00720cULL, 0x000fe40003f26070ULL,
0x0000002104147812ULL, 0x040fe400078efcffULL, 0x00000028040e7812ULL, 0x000fe400078efcffULL,
0xff80000041417808ULL, 0x000fc40004000000ULL, 0xff80000047477808ULL, 0x000fe40004000000ULL,
0xff80000040407808ULL, 0x000fe40006000000ULL, 0xff8000004a4a7808ULL, 0x000fe40006000000ULL,
0x0000005b1400720cULL, 0x080fe40003f06070ULL, 0x0000005b0e00720cULL, 0x000fe40003f86070ULL,
0x0000002904147812ULL, 0x000fc400078efcffULL, 0x00000030040e7812ULL, 0x000fe400078efcffULL,
0xff80000011117808ULL, 0x000fe40007000000ULL, 0xff80000049497808ULL, 0x000fe40007000000ULL,
0xff80000010107808ULL, 0x000fe40006800000ULL, 0xff8000004c4c7808ULL, 0x000fe40006800000ULL,
0x0000005b1400720cULL, 0x000fc40003fc6070ULL, 0x0000005b0e00720cULL, 0x000fe40003fa6070ULL,
0x0000003104147812ULL, 0x040fe400078efcffULL, 0x00000038040e7812ULL, 0x040fe400078efcffULL,
0x0000003904047812ULL, 0x000fe400078efcffULL, 0xff8000000b0b7808ULL, 0x000fe40005800000ULL,
0xff8000004b4b7808ULL, 0x000fc40005800000ULL, 0xff8000000a0a7808ULL, 0x000fe40005000000ULL,
0xff8000004e4e7808ULL, 0x000fe40005000000ULL, 0xff80000009097808ULL, 0x000fe40004800000ULL,
0xff8000004d4d7808ULL, 0x000fe40004800000ULL, 0x0000005b1400720cULL, 0x080fe40003f66070ULL,
0x0000005b0e00720cULL, 0x000fc40003f46070ULL, 0x0000005b0400720cULL, 0x000fe40003f26070ULL,
0xff80000008087808ULL, 0x000fe40004000000ULL, 0xff80000050507808ULL, 0x000fe40004000000ULL,
0xff80000007077808ULL, 0x000fe40006000000ULL, 0xff8000004f4f7808ULL, 0x000fe40006000000ULL,
0xff80000006067808ULL, 0x000fc40007000000ULL, 0xff80000054547808ULL, 0x000fe40007000000ULL,
0xff80000057577808ULL, 0x000fe40006800000ULL, 0xff80000051517808ULL, 0x000fe40006800000ULL,
0xff8000005a5a7808ULL, 0x000fe40005800000ULL, 0xff80000056567808ULL, 0x000fe40005800000ULL,
0xff80000059597808ULL, 0x000fc40005000000ULL, 0xff80000055557808ULL, 0x000fe40005000000ULL,
0xff8000005e5e7808ULL, 0x000fe40004800000ULL, 0xff80000058587808ULL, 0x000fce0004800000ULL,
0x0000000d1c00720bULL, 0x004fe20003f1e000ULL, 0x3f80000000057882ULL, 0x000fe20000000000ULL,
0x0c401f001e257f89ULL, 0x000fe200000e0000ULL, 0xfffffff8ff607812ULL, 0x000fe200078ee260ULL,
0x0000000143437836ULL, 0x000fe20000000000ULL, 0x0000001c0d1c7208ULL, 0x000fe20004000000ULL,
0x0c401f001f247f89ULL, 0x000fe200000e0000ULL, 0x000000065f297c11ULL, 0x000fe2000f8e58ffULL,
0x00000008602a7824ULL, 0x000fe200078e00ffULL, 0x000000451c00720bULL, 0x000fc60003f1e000ULL,
0x0001200029357836ULL, 0x000fe20000000000ULL, 0x0000001c451c7208ULL, 0x000fc80004000000ULL,
0x000000471c00720bULL, 0x000fc80003f1e000ULL, 0x0000001c47057208ULL, 0x000fe20004000000ULL,
0x00000005ff1c7e24ULL, 0x000fc6000f8e00ffULL, 0x0000004a0500720bULL, 0x000fe40003f1e000ULL,
0x3f8000001c1c783eULL, 0x000fe400000010ffULL, 0x000000054a047208ULL, 0x000fc80004000000ULL,
0x000000490400720bULL, 0x000fc80003f1e000ULL, 0x0000000449057208ULL, 0x000fc80004000000ULL,
0x0000004c0500720bULL, 0x000fc80003f1e000ULL, 0x000000054c047208ULL, 0x000fc80004000000ULL,
0x0000004b0400720bULL, 0x000fc80003f1e000ULL, 0x000000044b057208ULL, 0x000fc80004000000ULL,
0x0000004e0500720bULL, 0x000fc80003f1e000ULL, 0x000000054e047208ULL, 0x000fc80004000000ULL,
0x0000004d0400720bULL, 0x000fc80003f1e000ULL, 0x000000044d057208ULL, 0x000fc80004000000ULL,
0x000000500500720bULL, 0x000fc80003f1e000ULL, 0x0000000550047208ULL, 0x000fc80004000000ULL,
0x0000004f0400720bULL, 0x000fc80003f1e000ULL, 0x000000044f057208ULL, 0x000fe40004000000ULL,
0x0000000c1d00720bULL, 0x000fe40003f1e000ULL, 0x000000540500720bULL, 0x000fe40003f3e000ULL,
0x0000001d0c1d7208ULL, 0x000fe40004000000ULL, 0x0000000554047208ULL, 0x000fe40004800000ULL,
0x000000421d00720bULL, 0x000fc40003f1e000ULL, 0x000000510400720bULL, 0x000fc80003f3e000ULL,
0x0000000451057208ULL, 0x000fe40004800000ULL, 0x0000001d42047208ULL, 0x000fe20004000000ULL,
0x000000ffff1d7224ULL, 0x000fe200078e001cULL, 0x000000560500720bULL, 0x000fe40003f3e000ULL,
0x000000410400720bULL, 0x000fe40003f1e000ULL, 0x00000005560e7208ULL, 0x000fe40004800000ULL,
0x0000000441057208ULL, 0x000fc40004000000ULL, 0x000000550e00720bULL, 0x000fe40003f3e000ULL,
0x000000400500720bULL, 0x000fe40003f1e000ULL, 0x0000000e550f7208ULL, 0x000fe40004800000ULL,
0x0000000540047208ULL, 0x000fe40004000000ULL, 0x000000580f00720bULL, 0x000fe40003f3e000ULL,
0x000000110400720bULL, 0x000fc40003f1e000ULL, 0x0000000f580f7208ULL, 0x000fe40004800000ULL,
0x0000000411057208ULL, 0x000fc60004000000ULL, 0x0c401f000f0e7f89ULL, 0x000ea200000e0000ULL,
0x000000100500720bULL, 0x000fc80003f1e000ULL, 0x0000000510047208ULL, 0x000fc80004000000ULL,
0x0000000b0400720bULL, 0x000fc80003f1e000ULL, 0x000000040b057208ULL, 0x000fc80004000000ULL,
0x0000000a0500720bULL, 0x000fc80003f1e000ULL, 0x000000050a047208ULL, 0x000fe40004000000ULL,
0x0000000e0f00720bULL, 0x004fe40003f3e000ULL, 0x000000090400720bULL, 0x000fe40003f1e000ULL,
0x0000000f0e0e7208ULL, 0x000fe40004800000ULL, 0x0000000409057208ULL, 0x000fc60004000000ULL,
0x0c201f000e0f7f89ULL, 0x000ea200000e0000ULL, 0x000000080500720bULL, 0x000fc80003f1e000ULL,
0x0000000508047208ULL, 0x000fc80004000000ULL, 0x000000070400720bULL, 0x000fc80003f1e000ULL,
0x0000000407057208ULL, 0x000fc80004000000ULL, 0x000000060500720bULL, 0x000fc80003f1e000ULL,
0x0000000506047208ULL, 0x000fe40004000000ULL, 0x0000000f0e00720bULL, 0x004fe40003f3e000ULL,
0x000000570400720bULL, 0x000fe40003f1e000ULL, 0x0000000e0f2c7208ULL, 0x000fe40004800000ULL,
0x0000000457057208ULL, 0x000fe40004000000ULL, 0x000000241f00720bULL, 0x000fe20003f3e000ULL,
0x3fb8aa3b2c147820ULL, 0x000fe20000410000ULL, 0x0000005a0500720bULL, 0x000fc40003f1e000ULL,
0x0000001f242f7208ULL, 0x000fe20004800000ULL, 0x3fb8aa3b0d047823ULL, 0x100fe20000010814ULL,
0x000000055a0e7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b45457823ULL, 0x100fe20000010814ULL,
0x3fb8aa3b47477823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b4a4a7823ULL, 0x100fe20000010814ULL,
0x000000590e00720bULL, 0x000fe20003f1e000ULL, 0x0000000400047308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b49497823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b4c4c7823ULL, 0x100fe20000010814ULL,
0x0000000e59057208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b4b4b7823ULL, 0x100fe20000010814ULL,
0x3fb8aa3b4e4e7823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b4d4d7823ULL, 0x100fe20000010814ULL,
0x0000005e0500720bULL, 0x000fe20003f1e000ULL, 0x0000004500457308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b50507823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b4f4f7823ULL, 0x100fe20000010814ULL,
0x000000055e057208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b54547823ULL, 0x100fe20000010814ULL,
0x3fb8aa3b51517823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b56567823ULL, 0x100fe20000010814ULL,
0x3fb8aa3b55557823ULL, 0x100fe20000010814ULL, 0x0c401f00050e7f89ULL, 0x000ea200000e0000ULL,
0x0000004700477308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b58587823ULL, 0x000fe20000010814ULL,
0x00000008601f7824ULL, 0x000fe200078e00ffULL, 0x0c201f002f327f89ULL, 0x000ee200000e0000ULL,
0x000000ffff247224ULL, 0x000fc800078e001cULL, 0x0000004a004a7308ULL, 0x000ff00000000800ULL,
0x0000004900497308ULL, 0x000fe20000000800ULL, 0x0000000e0500720bULL, 0x004fce0003f1e000ULL,
0x0000004c004c7308ULL, 0x000ea20000000800ULL, 0x000000050e057208ULL, 0x000fe40004000000ULL,
0x000000322f00720bULL, 0x008fc60003f3e000ULL, 0x0c201f00050e7f89ULL, 0x000ee400000e0000ULL,
0x0000004b004b7308ULL, 0x000fe20000000800ULL, 0x0000002f322f7208ULL, 0x000fe40004800000ULL,
0x000000494c14723eULL, 0x004fca00000010ffULL, 0x0000004e004e7308ULL, 0x000eb00000000800ULL,
0x0000004d004d7308ULL, 0x000fe20000000800ULL, 0x0000000e0500720bULL, 0x008fce0003f1e000ULL,
0x0000005000507308ULL, 0x000ee20000000800ULL, 0x0000004b4e16723eULL, 0x004fe400000010ffULL,
0x000000050e2d7208ULL, 0x000fe40004000000ULL, 0x000000474a0e723eULL, 0x000fe400000010ffULL,
0x000000251e00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b2d277820ULL, 0x000fe20000410000ULL,
0x0000004f004f7308ULL, 0x000fe40000000800ULL, 0x0000001e252e7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b0c057823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b42427823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b41417823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b40407823ULL, 0x100fe20000010827ULL,
0x00000004450c723eULL, 0x000fe200000010ffULL, 0x3fb8aa3b11117823ULL, 0x100fe20000010827ULL,
0x0000000500057308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b10107823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b0b0b7823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b0a0a7823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b09097823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b08087823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b07077823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b06067823ULL, 0x100fe20000010827ULL,
0x0000004200427308ULL, 0x000ea20000000800ULL, 0x0000004d5018723eULL, 0x008fe200000010ffULL,
0x3fb8aa3b57577823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b5a5a7823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b59597823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b5e5e7823ULL, 0x000fe20000010827ULL,
0x00000003ff1e7819ULL, 0x000fe20000011603ULL, 0x0c201f002e317f89ULL, 0x000ee200000e0000ULL,
0x0000004100417308ULL, 0x000fe20000000800ULL, 0x000000ffff257224ULL, 0x000fe200078e001cULL,
0x00000005420d723eULL, 0x004fcc00000010ffULL, 0x0000004000407308ULL, 0x000eb00000000800ULL,
0x0000001100117308ULL, 0x000fe20000000800ULL, 0x00000041400f723eULL, 0x004fce00000010ffULL,
0x0000001000107308ULL, 0x000ea20000000800ULL, 0x000000312e00720bULL, 0x008fc80003f1e000ULL,
0x0000002e312e7208ULL, 0x000fe20004000000ULL, 0x0000001c0c20723cULL, 0x000fe200000418ffULL,
0x0000000303ff7812ULL, 0x000fe2000780c0ffULL, 0x0000000b000b7308ULL, 0x000fe20000000800ULL,
0x000000111015723eULL, 0x004fce00000010ffULL, 0x0000000a000a7308ULL, 0x000eb00000000800ULL,
0x0000005400547308ULL, 0x000ee20000000800ULL, 0x0000000b0a17723eULL, 0x004fce00000010ffULL,
0x0000000900097308ULL, 0x000fe20000000800ULL, 0x0000001c1420723cULL, 0x000fe20000041820ULL,
0x0000004f541a723eULL, 0x008fcc00000010ffULL, 0x0000000800087308ULL, 0x000ea20000000800ULL,
0x000000ffff297224ULL, 0x000fce00078e001aULL, 0x0000000700077308ULL, 0x000fe20000000800ULL,
0x000000090819723eULL, 0x004fce00000010ffULL, 0x0000000600067308ULL, 0x000eb00000000800ULL,
0x0000005100517308ULL, 0x000fe20000000800ULL, 0x00000007061b723eULL, 0x004fce00000010ffULL,
0x0000005600567308ULL, 0x000ea20000000800ULL, 0x0000001c1820723cULL, 0x000fee0000041820ULL,
0x0000005500557308ULL, 0x000fe20000000800ULL, 0x000000031e1d7812ULL, 0x000fe200078ec0ffULL,
0x00000008601e7836ULL, 0x000fe20000000000ULL, 0x00000051561c723eULL, 0x004fca00000010ffULL,
0x0000005800587308ULL, 0x000ea20000000800ULL, 0x000000011d607824ULL, 0x040fe400078e0260ULL,
0x000000011d287824ULL, 0x000fe400078e021eULL, 0x000000081e2b7824ULL, 0x040fe200078e00ffULL,
0xfffffff81f267812ULL, 0x000fe400078ee260ULL, 0x0000005700577308ULL, 0x000fe20000000800ULL,
0x000000081e337824ULL, 0x000fe400078e00ffULL, 0x0000000460277836ULL, 0x000fe20000000000ULL,
0xfffffff82b287812ULL, 0x000fe200078ee228ULL, 0x0000000c60607836ULL, 0x000fe20000000000ULL,
0x00000055581e723eULL, 0x004fc400000010ffULL, 0x0000005a005a7308ULL, 0x000ea20000000800ULL,
0xfffffff82a277812ULL, 0x000fe200078ee227ULL, 0x000000ffff2a7224ULL, 0x000fe200078e001cULL,
0xfffffff833607812ULL, 0x000fe200078ee260ULL, 0x0000001028337824ULL, 0x100fe400078e0235ULL,
0x000000ffff287224ULL, 0x000fe400078e0018ULL, 0x0000005900597308ULL, 0x000fe20000000800ULL,
0x000000ffff2b7224ULL, 0x000fe400078e001eULL, 0x0000001060607824ULL, 0x000fe200078e0235ULL,
0x000000575a1d723eULL, 0x004fc800000010ffULL, 0x0000005e005e7308ULL, 0x000ea40000000800ULL,
0x000000595e1f723eULL, 0x004fce00000010ffULL, 0x000000241c20723cULL, 0x000fee0000041820ULL,
0x000000ffff247224ULL, 0x000fe400078e000cULL, 0x000000ffff257224ULL, 0x000fe400078e000eULL,
0x000000ffff0c7224ULL, 0x000fc400078e000dULL, 0x000000ffff0d7224ULL, 0x000fe400078e000fULL,
0x000000ffff0e7224ULL, 0x000fe400078e0015ULL, 0x000000ffff0f7224ULL, 0x000fe400078e0017ULL,
0x000000ffff157224ULL, 0x000fe400078e001bULL, 0x0000001026217824ULL, 0x100fe400078e0235ULL,
0x0000001027237824ULL, 0x000fc400078e0235ULL, 0x000000ffff267224ULL, 0x000fe400078e0014ULL,
0x000000ffff277224ULL, 0x000fe400078e0016ULL, 0x000000ffff147224ULL, 0x000fe400078e0019ULL,
0x000000ffff167224ULL, 0x000fe200078e001dULL, 0x0000002421007844ULL, 0x0005e20000000200ULL,
0x000000ffff177224ULL, 0x000fe400078e001fULL, 0x00000001ff197424ULL, 0x000fe200078e00ffULL,
0x0000002823007844ULL, 0x0007e80000000200ULL, 0x0000000c33007844ULL, 0x0007e80000000200ULL,
0x0000001460007844ULL, 0x0007e20000000200ULL, 0x000000ffff217224ULL, 0x004fc600078e0022ULL,
0x0180002c30008388ULL, 0x0007e80000000c00ULL, 0x0182002030008388ULL, 0x0007e20000000a00ULL,
0x0000001043007c0cULL, 0x000fe2000bf06070ULL, 0x018ad81900ff79a7ULL, 0x0007e2000850003fULL,
0x018ae01900ff79a7ULL, 0x0007e2000850003fULL, 0x018ae81900ff79a7ULL, 0x0007e2000850003fULL,
0x018af01900ff79a7ULL, 0x0007f2000850003fULL, 0xffffffa400788947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0180000009007836ULL, 0x000fe20000000000ULL,
0x0000013000017945ULL, 0x000fe80003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000000900008308ULL, 0x0002a20000001000ULL,
0x0000000000388947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x007fffff09ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000009027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000000000047947ULL, 0x000fec0003800000ULL,
0x0000000900007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffffdd0026c7950ULL, 0x000fea0003c3ffffULL, 0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000100000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000040ULL, 0x0000000000000111ULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000000000000017bULL, 0x000000000000056aULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000006e8ULL, 0x0000000000000240ULL, 0x0000001600000002ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x00000001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000928ULL, 0x00000000000000e0ULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000a08ULL, 0x0000000000000054ULL, 0x0000000000000003ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000a5cULL, 0x0000000000000a38ULL, 0x0000000a00000003ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x00000004000000b2ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000001498ULL, 0x0000000000000000ULL, 0x0000000a00000003ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x00000004000000e6ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000001498ULL, 0x0000000000000048ULL, 0x0000000400000003ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x000000010000007bULL, 0x0000000000000002ULL, 0x0000000000000000ULL,
0x00000000000014e0ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL,
0x0000000000001500ULL, 0x0000000000022f00ULL, 0x0000001600000003ULL, 0x0000000000000080ULL,
0x0000000000000000ULL, 0x000000010000008dULL, 0x0000000000000003ULL, 0x0000000000000000ULL,
0x0000000000024400ULL, 0x0000000000000044ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL,
0x0000000000024450ULL, 0x0000000000000400ULL, 0x0000000a00000000ULL, 0x0000000000000010ULL,
0x0000000000000000ULL, 0x00000001000000f8ULL, 0x0000000000000002ULL, 0x0000000000000000ULL,
0x0000000000024450ULL, 0x0000000000000278ULL, 0x0000000a00000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000400000006ULL, 0x0000000000024a48ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x0000000000024a48ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x00000000000014e0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001500ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000022f00ULL, 0x0000000000022f00ULL,
0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000024400ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000050ULL, 0x0000000000000450ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x0000000000024450ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000278ULL, 0x0000000000000278ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_4_kvt_e4m3_pagedKV_64_nqpkv_1_m_1_sm_90_cubin_len = 150424;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
