/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_4_kvt_int8_pagedKV_64_nqpkv_1_m_1_sm_86_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000029c50ULL, 0x00000000000298d0ULL, 0x0038004000560556ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f34314944327961ULL, 0x6f6c66625f766e5fULL,
0x326a4c3236317461ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL,
0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x336a4c4536316a4cULL, 0x4c49746132454532ULL,
0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45346a4c4534366aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL,
0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL,
0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL, 0x45326a4c4545316aULL, 0x7461324545316a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x4939494432796172ULL, 0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL,
0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL,
0x4c4545346a4c6a49ULL, 0x36316a4c4532336aULL, 0x624c497461324545ULL, 0x31534b5245454531ULL,
0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL,
0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL, 0x4c4545326a4c4532ULL, 0x4545316a4c45326aULL,
0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x45346a4c4545346aULL,
0x7461324545386a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL,
0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL,
0x6a4c4536316a4c45ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5f2400676e696469ULL, 0x616e7265746e695fULL, 0x635f5f245f305f6cULL,
0x30326d735f616475ULL, 0x5f6e725f7063725fULL, 0x5f3233665f7a7466ULL, 0x68746170776f6c73ULL,
0x65746e695f5f2400ULL, 0x245f315f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL,
0x6c66625f636e7973ULL, 0x695f5f2400705f79ULL, 0x5f6c616e7265746eULL, 0x6475635f5f245f32ULL,
0x735f30376d735f61ULL, 0x5f636e79736c6668ULL, 0x5f2400705f786469ULL, 0x616e7265746e695fULL,
0x635f5f245f335f6cULL, 0x30376d735f616475ULL, 0x6e797365746f765fULL, 0x746f6c6c61625f63ULL,
0x65746e695f5f2400ULL, 0x245f345f6c616e72ULL, 0x735f616475635f5fULL, 0x707261775f30376dULL,
0x65722e00636e7973ULL, 0x2e747865742e616cULL, 0x6d5f6c656e72656bULL, 0x2e6c65722e006168ULL,
0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x5f6c656e72656b24ULL, 0x6d656d732461686dULL,
0x0066754265747942ULL, 0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL,
0x006d617261705f00ULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x2e6c65722e766e2eULL,
0x00006e6f69746361ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c0001000000adULL, 0x0000000000000034ULL, 0x0000000000000010ULL, 0x000c0001000000ebULL,
0x000000000000001cULL, 0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c00010000016bULL, 0x000000000000002cULL, 0x0000000000000004ULL,
0x000c0001000001b5ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c0001000001fbULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000242ULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000c000100000288ULL, 0x0000000000000030ULL, 0x0000000000000004ULL,
0x000c0001000002d6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c000100000324ULL,
0x0000000000000018ULL, 0x0000000000000004ULL, 0x000c000100000372ULL, 0x000000000000000cULL,
0x0000000000000004ULL, 0x000c0001000003b9ULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000c000100000407ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c00010000044cULL,
0x0000000000000020ULL, 0x0000000000000004ULL, 0x000b002200000492ULL, 0x00000000000276f0ULL,
0x0000000000000180ULL, 0x000b0022000004c5ULL, 0x0000000000027870ULL, 0x0000000000000040ULL,
0x000b0022000004f0ULL, 0x00000000000278b0ULL, 0x0000000000000040ULL, 0x000b00220000051aULL,
0x00000000000278f0ULL, 0x0000000000000060ULL, 0x000b002200000545ULL, 0x0000000000027950ULL,
0x0000000000000130ULL, 0x000a0003000005acULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000005ccULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000005fcULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL,
0x0000000000027a80ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000276f000000000ULL, 0x0000040400000000ULL,
0x810c000001600400ULL, 0x009c500400288080ULL, 0x0000000000000000ULL, 0x0000007cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8608288080820828ULL, 0x2880808708288080ULL, 0x8097082880808f08ULL,
0x08288080a4082880ULL, 0x8080be08288080b8ULL, 0xd508288080bf0828ULL, 0x288080e208288080ULL,
0x8280162880808408ULL, 0x0000000003102880ULL, 0x8080849200000000ULL, 0x0000000000220028ULL,
0x00000034ffffffffULL, 0x0000007000000000ULL, 0x000276f000000000ULL, 0x0000018000000000ULL,
0x0000480400000000ULL, 0x8080288080820900ULL, 0x0900000010042880ULL, 0x2880808228808084ULL,
0x0000007cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8608288080820828ULL, 0x2880808708288080ULL,
0x8097082880808f08ULL, 0x08288080a4082880ULL, 0x8080b808288080adULL, 0xd508288080bf0828ULL,
0x288080e208288080ULL, 0x8280162880808808ULL, 0x0000000003102880ULL, 0x8080889200000000ULL,
0x0000000000220028ULL, 0x0000001cffffffffULL, 0x0000013800000000ULL, 0x0002787000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x00000074ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8608288080820828ULL, 0x2880808708288080ULL, 0x8097082880808f08ULL, 0x08288080a4082880ULL,
0x8080bf08288080beULL, 0xe208288080d50828ULL, 0x288080b808288080ULL, 0x0003102880828016ULL,
0x9200000000000000ULL, 0x00002200288080b8ULL, 0x0000001cffffffffULL, 0x000001e800000000ULL,
0x000278b000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x00000074ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8608288080820828ULL, 0x2880808708288080ULL, 0x8097082880808f08ULL,
0x08288080a4082880ULL, 0x8080bf08288080beULL, 0xe208288080d50828ULL, 0x288080b808288080ULL,
0x0003102880828016ULL, 0x9200000000000000ULL, 0x00002200288080b8ULL, 0x0000001cffffffffULL,
0x0000029000000000ULL, 0x000278f000000000ULL, 0x0000006000000000ULL, 0x0000000000000000ULL,
0x0000007cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8408288080820828ULL, 0x2880808608288080ULL,
0x808f082880808708ULL, 0x0828808095082880ULL, 0x8080b80828808097ULL, 0xbf08288080be0828ULL,
0x288080d508288080ULL, 0x80a408288080e208ULL, 0x1028808280162880ULL, 0x0000000000000003ULL,
0x2200288080a49200ULL, 0x0000001cffffffffULL, 0x0000033800000000ULL, 0x0002795000000000ULL,
0x0000013000000000ULL, 0x0000000000000000ULL, 0x0000001b00082f04ULL, 0x00082304000000f0ULL,
0x0000000000000017ULL, 0x0000001700081204ULL, 0x0008110400000000ULL, 0x0000000000000017ULL,
0x0000001600082304ULL, 0x0008120400000000ULL, 0x0000000000000016ULL, 0x0000001600081104ULL,
0x0008230400000000ULL, 0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL,
0x0000000000000015ULL, 0x0000001400082304ULL, 0x0008120400000000ULL, 0x0000000000000014ULL,
0x0000001400081104ULL, 0x0008230400000000ULL, 0x0000000000000013ULL, 0x0000001300081204ULL,
0x0008110400000000ULL, 0x0000000000000013ULL, 0x0000001b00082304ULL, 0x0008120400000000ULL,
0x000000000000001bULL, 0x0000001b00081104ULL, 0x0004370400000000ULL, 0x000035010000007bULL,
0x0000001800080a04ULL, 0x0068190300680160ULL, 0x00000000000c1704ULL, 0x0021f00000600007ULL,
0x00000000000c1704ULL, 0x0021f00000580006ULL, 0x00000000000c1704ULL, 0x0011f00000500005ULL,
0x00000000000c1704ULL, 0x0061f00000380004ULL, 0x00000000000c1704ULL, 0x0081f00000180003ULL,
0x00000000000c1704ULL, 0x0021f00000100002ULL, 0x00000000000c1704ULL, 0x0021f00000080001ULL,
0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x0004310400ff1b03ULL, 0x01bc290400000020ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x01bc2804ffffffffULL,
0x0000012000000100ULL, 0x000033d000000460ULL, 0x0000356000003460ULL, 0x000038f0000036c0ULL,
0x0000397000003920ULL, 0x00006fd0000039c0ULL, 0x0000704000006ff0ULL, 0x0000aaa000007090ULL,
0x0000ac200000ab30ULL, 0x0000af900000ad70ULL, 0x0000b0000000afb0ULL, 0x0000e4700000b050ULL,
0x0000e4e00000e490ULL, 0x00011e200000e530ULL, 0x00011fa000011eb0ULL, 0x00012310000120f0ULL,
0x0001238000012330ULL, 0x000157f0000123d0ULL, 0x0001586000015810ULL, 0x000191a0000158b0ULL,
0x0001932000019230ULL, 0x0001969000019470ULL, 0x00019700000196b0ULL, 0x0001cb7000019750ULL,
0x0001cbe00001cb90ULL, 0x0001eea00001cc30ULL, 0x0001f5c00001efe0ULL, 0x0001f9d00001f5e0ULL,
0x0002160000020ba0ULL, 0x000227d000021620ULL, 0x00025ad0000227f0ULL, 0x00025b2000025b10ULL,
0x00025b8000025b30ULL, 0x00025bc000025ba0ULL, 0x0002684000025bd0ULL, 0x000268f000026890ULL,
0x000269b000026950ULL, 0x00026a7000026a10ULL, 0x00026b2000026ad0ULL, 0x00026bc000026b70ULL,
0x00026c8000026c20ULL, 0x00026d4000026ce0ULL, 0x00026df000026da0ULL, 0x00026e9000026e40ULL,
0x00026f5000026ef0ULL, 0x0002701000026fb0ULL, 0x000270c000027070ULL, 0x0002716000027110ULL,
0x00027220000271c0ULL, 0x000272e000027280ULL, 0x0002739000027340ULL, 0x00027430000273e0ULL,
0x000274f000027490ULL, 0x000275b000027550ULL, 0x0002767000027610ULL, 0x07e03904000276d0ULL,
0x000000ff00000220ULL, 0x003f010000010ad0ULL, 0x0000000f00000280ULL, 0x003f012000010ad8ULL,
0x0000000f000002d0ULL, 0x003f012000010b58ULL, 0x0000000f00000400ULL, 0x003f012000010b78ULL,
0x000000ff00000430ULL, 0x003f010000010b88ULL, 0x000000ff00000500ULL, 0x003f010700010ad0ULL,
0x0000006200000750ULL, 0x003f010200010b5cULL, 0x00000062000007b0ULL, 0x003f010100010b58ULL,
0x000000ff00000910ULL, 0x003f010100010b88ULL, 0x000000ff00000950ULL, 0x003f010500010b8cULL,
0x000000ff00000b10ULL, 0x003f010500010b8cULL, 0x000000ff00001520ULL, 0x003f010100010b88ULL,
0x000000ff00001550ULL, 0x003f010500010b8cULL, 0x000000ff00001720ULL, 0x003f010500010b8cULL,
0x000000ff00001880ULL, 0x003f010700010b78ULL, 0x000000ff00001900ULL, 0x003f010100010b78ULL,
0x000000ff00001970ULL, 0x003f010100010b88ULL, 0x000000ff00001c30ULL, 0x003f010500010b7cULL,
0x000000ff00001df0ULL, 0x003f010500010b7cULL, 0x000000ff00001e50ULL, 0x003f010500010b8cULL,
0x000000ff00002020ULL, 0x003f010500010b8cULL, 0x000000ff00002a80ULL, 0x003f010100010b88ULL,
0x000000ff00002ab0ULL, 0x003f010500010b8cULL, 0x000000ff00002c80ULL, 0x003f010500010b8cULL,
0x000000ff00002fd0ULL, 0x003f010700010b80ULL, 0x000000ff00003060ULL, 0x003f010100010b80ULL,
0x00000062000030f0ULL, 0x003f010100010ad8ULL, 0x0000006200003120ULL, 0x003f010500010adcULL,
0x00000062000032f0ULL, 0x003f010500010adcULL, 0x000000ff00005c20ULL, 0x003f010100010b88ULL,
0x000000ff00005cf0ULL, 0x003f010500010b84ULL, 0x000000ff00005eb0ULL, 0x003f010500010b84ULL,
0x000000ff00005f10ULL, 0x003f010500010b8cULL, 0x000000ff000060e0ULL, 0x003f010500010b8cULL,
0x000000ff00006b10ULL, 0x003f010100010b88ULL, 0x000000ff00006b40ULL, 0x003f010500010b8cULL,
0x000000ff00006d10ULL, 0x003f010500010b8cULL, 0x000000ff00006ee0ULL, 0x003f010700010b78ULL,
0x000000ff00006f60ULL, 0x003f010100010b78ULL, 0x000000ff000091a0ULL, 0x003f010100010b88ULL,
0x000000ff00009270ULL, 0x003f010100010b58ULL, 0x000000ff00009350ULL, 0x003f010500010b7cULL,
0x000000ff00009510ULL, 0x003f010500010b7cULL, 0x000000ff00009570ULL, 0x003f010500010b8cULL,
0x000000ff00009740ULL, 0x003f010500010b8cULL, 0x000000ff0000a190ULL, 0x003f010100010b88ULL,
0x000000ff0000a1c0ULL, 0x003f010500010b8cULL, 0x000000ff0000a390ULL, 0x003f010500010b8cULL,
0x000000ff0000a6b0ULL, 0x003f010700010b80ULL, 0x000000ff0000a740ULL, 0x003f010100010b80ULL,
0x000000620000a7c0ULL, 0x003f010100010af8ULL, 0x000000620000a7f0ULL, 0x003f010500010afcULL,
0x000000620000a9c0ULL, 0x003f010500010afcULL, 0x000000ff0000d0b0ULL, 0x003f010100010b88ULL,
0x000000ff0000d190ULL, 0x003f010500010b84ULL, 0x000000ff0000d350ULL, 0x003f010500010b84ULL,
0x000000ff0000d3b0ULL, 0x003f010500010b8cULL, 0x000000ff0000d580ULL, 0x003f010500010b8cULL,
0x000000ff0000dfb0ULL, 0x003f010100010b88ULL, 0x000000ff0000dfe0ULL, 0x003f010500010b8cULL,
0x000000ff0000e1b0ULL, 0x003f010500010b8cULL, 0x000000ff0000e380ULL, 0x003f010700010b78ULL,
0x000000ff0000e400ULL, 0x003f010100010b78ULL, 0x000000ff00010540ULL, 0x003f010100010b88ULL,
0x000000ff000105f0ULL, 0x003f010100010b60ULL, 0x000000ff000106d0ULL, 0x003f010500010b7cULL,
0x000000ff00010890ULL, 0x003f010500010b7cULL, 0x000000ff000108f0ULL, 0x003f010500010b8cULL,
0x000000ff00010ac0ULL, 0x003f010500010b8cULL, 0x000000ff00011510ULL, 0x003f010100010b88ULL,
0x000000ff00011540ULL, 0x003f010500010b8cULL, 0x000000ff00011710ULL, 0x003f010500010b8cULL,
0x000000ff00011a30ULL, 0x003f010700010b80ULL, 0x000000ff00011ac0ULL, 0x003f010100010b80ULL,
0x0000006200011b40ULL, 0x003f010100010b18ULL, 0x0000006200011b70ULL, 0x003f010500010b1cULL,
0x0000006200011d40ULL, 0x003f010500010b1cULL, 0x000000ff00014430ULL, 0x003f010100010b88ULL,
0x000000ff00014510ULL, 0x003f010500010b84ULL, 0x000000ff000146d0ULL, 0x003f010500010b84ULL,
0x000000ff00014730ULL, 0x003f010500010b8cULL, 0x000000ff00014900ULL, 0x003f010500010b8cULL,
0x000000ff00015330ULL, 0x003f010100010b88ULL, 0x000000ff00015360ULL, 0x003f010500010b8cULL,
0x000000ff00015530ULL, 0x003f010500010b8cULL, 0x000000ff00015700ULL, 0x003f010700010b78ULL,
0x000000ff00015780ULL, 0x003f010100010b78ULL, 0x000000ff000178c0ULL, 0x003f010100010b88ULL,
0x000000ff00017970ULL, 0x003f010100010b68ULL, 0x000000ff00017a50ULL, 0x003f010500010b7cULL,
0x000000ff00017c10ULL, 0x003f010500010b7cULL, 0x000000ff00017c70ULL, 0x003f010500010b8cULL,
0x000000ff00017e40ULL, 0x003f010500010b8cULL, 0x000000ff00018890ULL, 0x003f010100010b88ULL,
0x000000ff000188c0ULL, 0x003f010500010b8cULL, 0x000000ff00018a90ULL, 0x003f010500010b8cULL,
0x000000ff00018db0ULL, 0x003f010700010b80ULL, 0x000000ff00018e40ULL, 0x003f010100010b80ULL,
0x0000006200018ec0ULL, 0x003f010100010b38ULL, 0x0000006200018ef0ULL, 0x003f010500010b3cULL,
0x00000062000190c0ULL, 0x003f010500010b3cULL, 0x000000ff0001b7b0ULL, 0x003f010100010b88ULL,
0x000000ff0001b890ULL, 0x003f010500010b84ULL, 0x000000ff0001ba50ULL, 0x003f010500010b84ULL,
0x000000ff0001bab0ULL, 0x003f010500010b8cULL, 0x000000ff0001bc80ULL, 0x003f010500010b8cULL,
0x000000ff0001c6b0ULL, 0x003f010100010b88ULL, 0x000000ff0001c6e0ULL, 0x003f010500010b8cULL,
0x000000ff0001c8b0ULL, 0x003f010500010b8cULL, 0x000000ff0001ca80ULL, 0x003f010700010b78ULL,
0x000000ff0001cb00ULL, 0x003f010100010b78ULL, 0x000000ff0001ec40ULL, 0x003f010100010b88ULL,
0x000000ff0001ece0ULL, 0x003f010100010b70ULL, 0x000000ff0001f830ULL, 0x003f010100010ad0ULL,
0x000000ff00020bd0ULL, 0x003f010500010ad4ULL, 0x000000ff00020da0ULL, 0x003f010500010ad4ULL,
0x000000ff00021110ULL, 0x003f010100010ad0ULL, 0x000000ff00021150ULL, 0x003f010500010ad4ULL,
0x000000ff00021310ULL, 0x003f010500010ad4ULL, 0x0000003d00024dd0ULL, 0x003f010100000000ULL,
0x0000003d00025000ULL, 0x003f010500000004ULL, 0x0000003d000251d0ULL, 0x003f010500000004ULL,
0x0000003f000266a0ULL, 0x003f010100000000ULL, 0x0000003f00026700ULL, 0x003f010100000008ULL,
0x0000003f00026760ULL, 0x003f010100000010ULL, 0x0000003f000267d0ULL, 0x003f010100000018ULL,
0x00101c0400053803ULL, 0x000213700001f6f0ULL, 0x0002681000021450ULL, 0x000c050400000401ULL,
0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x00000000000003d4ULL, 0x0000001b00000002ULL, 0x0000000000000324ULL,
0x0000001b00000002ULL, 0x000000000000027cULL, 0x0000001b00000002ULL, 0x00000000000001d4ULL,
0x0000001b00000002ULL, 0x000000000000010cULL, 0x0000001b00000002ULL, 0x0000000000000044ULL,
0x0000001b00000002ULL, 0x00000000000003b1ULL, 0x0000001b00000002ULL, 0x00000000000002ffULL,
0x0000001b00000002ULL, 0x0000000000000257ULL, 0x0000001b00000002ULL, 0x00000000000001acULL,
0x0000001b00000002ULL, 0x00000000000000e4ULL, 0x0000001b00000002ULL, 0x0000000000010c00ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x00000000000f7919ULL, 0x000e620000002100ULL,
0x0000000000137806ULL, 0x000fe200038e0000ULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x00000200ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000000000037919ULL, 0x000ea20000002300ULL,
0x0000001300047300ULL, 0x000ee200000e0000ULL, 0x0000000204047899ULL, 0x000fe4000800063fULL,
0x0000000000027919ULL, 0x000f220000002200ULL, 0x0000460000067ab9ULL, 0x000fc60000000a00ULL,
0x0000000000127919ULL, 0x000ee20000000000ULL, 0x0000001300137309ULL, 0x000ea60000000000ULL,
0x0000000000057919ULL, 0x000ee80000000000ULL, 0x0000000000367919ULL, 0x000ee20000002700ULL,
0x00000005ff657819ULL, 0x002fc6000001160fULL, 0x0000000000347919ULL, 0x000e680000002600ULL,
0x00001fff03007589ULL, 0x0045e200000e0000ULL, 0x0000010003027a24ULL, 0x010fc600078e0202ULL,
0x00001fff65657589ULL, 0x000f2200000e0000ULL, 0x00000000020f7a24ULL, 0x000fe200078e020fULL,
0x000000050400720cULL, 0x008fc80003f02070ULL, 0x000000ff0f00720cULL, 0x040fe40003f25270ULL,
0x0000000f0f00780cULL, 0x040fe20003f44070ULL, 0x0000000436637824ULL, 0x000fe200078e00ffULL,
0x000000030f00780cULL, 0x040fe40003f64070ULL, 0x0000007f0f00780cULL, 0x000fce0003f84070ULL,
0x7fffff80ff039424ULL, 0x004fe400078e00ffULL, 0x0000000400027824ULL, 0x010fe400078e0265ULL,
0x3fffffc0ff04a424ULL, 0x000fe400078e00ffULL, 0x0000000202097824ULL, 0x000fe400078e00ffULL,
0x3fffff80ff029424ULL, 0x000fe400078e00ffULL, 0x0000000109087824ULL, 0x040fe200078e0212ULL,
0x00000004090a7817ULL, 0x040fe20007800000ULL, 0x00000020090b7824ULL, 0x000fe200078e00ffULL,
0x010ad002ff009388ULL, 0x0005e20000000a00ULL, 0x7fffffc0ff05a424ULL, 0x000fc400078e00ffULL,
0x3fffff60ff06b424ULL, 0x000fe200078e00ffULL, 0xffffffe00b0e7812ULL, 0x000fe200078ee208ULL,
0x0000000436087c24ULL, 0x002fe2000f8e0234ULL, 0x00000001090b7810ULL, 0x000fe20007ffe0ffULL,
0x010ad8040f00a388ULL, 0x0003e20000008a00ULL, 0x000000010f00780cULL, 0x000fe20003f44070ULL,
0x7fffff60ff07b424ULL, 0x000fe400078e00ffULL, 0x000000010b037824ULL, 0x044fe400078e0212ULL,
0x000000200b107824ULL, 0x000fe200078e00ffULL, 0x010b58060f00b388ULL, 0x0005e20000008a00ULL,
0x0000580009027a24ULL, 0x000fc400078e0208ULL, 0xff317217ff0cc424ULL, 0x000fe200078e00ffULL,
0xffffffe010107812ULL, 0x000fe200078ee203ULL, 0x0000001012047824ULL, 0x002fe400078e00ffULL,
0x000000010a0a7824ULL, 0x000fe200078e0a09ULL, 0x0104000c0f00c388ULL, 0x0003e20000004800ULL,
0x000058000b057a24ULL, 0x000fe200078e0208ULL, 0x000001f004097812ULL, 0x000fe200078ec0ffULL,
0x00005c0002027625ULL, 0x080fe200078e000dULL, 0x000000ff0a00720cULL, 0x040fe40003f63070ULL,
0x000000010a00780cULL, 0x000fe20003f83070ULL, 0x00005c0005047625ULL, 0x000fe200078e000dULL,
0x0000000902067210ULL, 0x004fc60007fbe0ffULL, 0x3fffff00ff0aa424ULL, 0x000fe200078e00ffULL,
0x0000000904087210ULL, 0x000fe20007fde0ffULL, 0x7fffff00ff0ba424ULL, 0x000fe400078e00ffULL,
0x3fffff80ff0c9424ULL, 0x002fe400078e00ffULL, 0x7fffff80ff0d9424ULL, 0x000fe200078e00ffULL,
0x010b780a0f00a388ULL, 0x000fe20000008a00ULL, 0x000000ffff027224ULL, 0x000fe400078e0a13ULL,
0x000000ffff077224ULL, 0x000fe200028e0603ULL, 0x010b880cff009388ULL, 0x000fe20000000a00ULL,
0x000000100e117824ULL, 0x000fc400078e00ffULL, 0x000000ffff097224ULL, 0x000fe200030e0605ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000001010137824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006117faeULL, 0x0003e2000d901c46ULL,
0x000000ffff0a7224ULL, 0x000fe400078e0002ULL, 0x00000004ff0e7424ULL, 0x000fe200078e00ffULL,
0x0000000008137faeULL, 0x0003e6000e101c46ULL, 0x0000620063027625ULL, 0x0c0fe200078e000eULL,
0x0000000000007918ULL, 0x000fe60000000000ULL, 0x00006a0063047625ULL, 0x000fe200078e000eULL,
0x010ad40affff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x010ad000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000602617981ULL, 0x000ea8000c1e1900ULL,
0x0000000604047981ULL, 0x000ee2000c1e1900ULL, 0x000000ff0000720cULL, 0x000fe20003f05270ULL,
0xffffffffff337424ULL, 0x000fe200078e00ffULL, 0x0000003f61647810ULL, 0x004fc40007ffe0ffULL,
0x000000ff61007810ULL, 0x000fe40007ffe0ffULL, 0x00000008ff357819ULL, 0x008fe40000011604ULL,
0x00000006ff647819ULL, 0x000fe40000011664ULL, 0x00000008ff377819ULL, 0x000fc60000011600ULL,
0x0001f0d000008947ULL, 0x000fea0003800000ULL, 0x0000002065047824ULL, 0x040fe200078e0212ULL,
0x000000b000007945ULL, 0x000fe20003800000ULL, 0x0000000865627824ULL, 0x000fe400078e00ffULL,
0x00000003ff077424ULL, 0x002fe200078e00ffULL, 0x0000001f0400780cULL, 0x040fe40003f04070ULL,
0x000000030400780cULL, 0x000fd60003f24070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000610400720cULL, 0x040fe20003f06070ULL, 0x0000680063027a24ULL, 0x000fe200078e0204ULL,
0x00010a0004057811ULL, 0x000fc600078e10ffULL, 0x0000660002027625ULL, 0x000fd000078e000eULL,
0x0000000002057faeULL, 0x0003e4000c121846ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b5c0762ff738cULL, 0x0005e20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b580062ff7f8cULL, 0x0007e2000c80043fULL,
0x000000d000007945ULL, 0x000fe20003800000ULL, 0x000000b000001947ULL, 0x000fea0003800000ULL,
0x0000000436027824ULL, 0x002fe200078e0204ULL, 0x000000ff6400720cULL, 0x000fe20003f05270ULL,
0x00006400ff037624ULL, 0x000fe200078e00ffULL, 0x00010ac004057811ULL, 0x000fe200078e10ffULL,
0x0000000202027824ULL, 0x000fc800078e00ffULL, 0x0000640002027624ULL, 0x000fc800078e0203ULL,
0x0000600002027625ULL, 0x000fca00078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002057faeULL, 0x0003e40008121846ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000080000000791aULL, 0x000fc80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8800ff027f8cULL, 0x002e62000c80043fULL,
0x000000ffff067224ULL, 0x000fe400078e00ffULL, 0x000000ffff097224ULL, 0x002fc400078e0003ULL,
0x0000000000027805ULL, 0x000fca0000015200ULL, 0x010b8c00ff047984ULL, 0x000e640000000800ULL,
0x8000000004ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000047805ULL, 0x000fcc0000015200ULL, 0x0000000402077210ULL, 0x004fca0007f1e1ffULL,
0x0000000105057824ULL, 0x000fe200000e0e03ULL, 0x003d09000700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc80000011405ULL,
0x0000000704047211ULL, 0x000fca00078110ffULL, 0x000000ffff057224ULL, 0x000fca00000e0605ULL,
0x0000000204047819ULL, 0x000fc80000001205ULL, 0x000000040000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000106067810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x010b8c00ff047984ULL, 0x000e640000000800ULL,
0x8000000004ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000001ff0000780cULL, 0x000fe20003f04070ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x0000000604047899ULL, 0x000fd4000800063fULL, 0x000004f000000947ULL, 0x000fea0003800000ULL,
0x0000000000157919ULL, 0x000e620000000000ULL, 0x0000006261037217ULL, 0x000fe20007800000ULL,
0x00000100ff137424ULL, 0x000fc800078e00ffULL, 0x0000000103007824ULL, 0x000fe200078e0a62ULL,
0x00000004ff077819ULL, 0x006fe20000011615ULL, 0x0000001015117824ULL, 0x000fc600078e00ffULL,
0x000000000700720cULL, 0x000fe20003f06070ULL, 0x0000000162097824ULL, 0x000fe200078e0207ULL,
0x000000f011117812ULL, 0x000fc600078ec0ffULL, 0x00000040340b7824ULL, 0x000fe200078e0209ULL,
0x010a000009047984ULL, 0x000e620000004800ULL, 0x0000000109057824ULL, 0x040fe400078e0215ULL,
0x0000001009067824ULL, 0x000fe200078e00ffULL, 0x000000020b0f7810ULL, 0x000fe20007ffe0ffULL,
0x010ac00004047984ULL, 0x002e640000004800ULL, 0x0000000404027c24ULL, 0x002fc8000f8e020bULL,
0x00005e0002027625ULL, 0x000fca00078e0013ULL, 0x0000001102047210ULL, 0x000fe40007f3e0ffULL,
0xfffffff006027812ULL, 0x000fc600078ee205ULL, 0x000000ffff057224ULL, 0x000fe200008e0603ULL,
0x0000c000020d7811ULL, 0x000fe400078e20ffULL, 0x0000000207037810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040d7faeULL, 0x0003e2000c101c46ULL,
0x000000000300720cULL, 0x000fe20003f06070ULL, 0x0000000162067824ULL, 0x000fe400078e0203ULL,
0x010a080009087984ULL, 0x000ea40000004800ULL, 0x00000001060a7824ULL, 0x000fe400078e0215ULL,
0x010ac00008087984ULL, 0x004ea40000004800ULL, 0x0000000408027c24ULL, 0x004fc4000f8e020fULL,
0x00000010060f7824ULL, 0x000fe400078e00ffULL, 0x00005e0002027625ULL, 0x000fc600078e0013ULL,
0xfffffff00f0a7812ULL, 0x000fe400078ee20aULL, 0x0000001102047210ULL, 0x002fe40007f3e0ffULL,
0x0000c0000a0d7811ULL, 0x000fe400078e20ffULL, 0x000000040b0f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff057224ULL, 0x000fe200008e0603ULL, 0x0000000407037810ULL, 0x000fe40007ffe0ffULL,
0x000000060b0b7810ULL, 0x000fc40007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040d7faeULL, 0x0003e2000c101c46ULL, 0x0000000162067824ULL, 0x000fe200078e0203ULL,
0x000000000300720cULL, 0x000fe40003f06070ULL, 0x010a100009087984ULL, 0x000ea20000004800ULL,
0x00000001060a7824ULL, 0x000fe200078e0215ULL, 0x0000000607077810ULL, 0x000fe40007ffe0ffULL,
0x010ac00008087984ULL, 0x004ea40000004800ULL, 0x0000000408027c24ULL, 0x004fc4000f8e020fULL,
0x00000010060f7824ULL, 0x000fe400078e00ffULL, 0x00005e0002027625ULL, 0x000fc600078e0013ULL,
0xfffffff00f0a7812ULL, 0x000fe200078ee20aULL, 0x0000000162067824ULL, 0x000fe200078e0207ULL,
0x0000001102047210ULL, 0x002fe40007f3e0ffULL, 0x0000c0000a0d7811ULL, 0x000fc600078e20ffULL,
0x000000ffff057224ULL, 0x000fca00008e0603ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040d7faeULL, 0x0003e2000c101c46ULL, 0x000000000700720cULL, 0x000fe20003f06070ULL,
0x0000000106007824ULL, 0x040fe400078e0215ULL, 0x010a180009097984ULL, 0x000ea20000004800ULL,
0x0000001006077824ULL, 0x000fca00078e00ffULL, 0xfffffff007007812ULL, 0x000fc800078ee200ULL,
0x0000c00000057811ULL, 0x002fe200078e20ffULL, 0x010ac00009027984ULL, 0x004e640000004800ULL,
0x0000000402027c24ULL, 0x002fc8000f8e020bULL, 0x00005e0002027625ULL, 0x000fca00078e0013ULL,
0x0000001102027210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff037224ULL, 0x000fca00008e0603ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002057faeULL, 0x0003e2000c101c46ULL,
0x0000044000007947ULL, 0x000fea0003800000ULL, 0x00000000000f7919ULL, 0x000e620000000000ULL,
0x00000100ff0a7424ULL, 0x000fe200078e00ffULL, 0x000000620f097211ULL, 0x042fe200078fe0ffULL,
0x000000100f037824ULL, 0x000fc800078e00ffULL, 0x010a000009007984ULL, 0x000e620000004800ULL,
0x00000040340b7824ULL, 0x000fe200078e0209ULL, 0x000000f003117812ULL, 0x000fe200078ec0ffULL,
0x0000000109057824ULL, 0x040fe400078e020fULL, 0x0000001009067824ULL, 0x040fe200078e00ffULL,
0x010ac00000007984ULL, 0x002e640000004800ULL, 0x0000000400027c24ULL, 0x002fe2000f8e020bULL,
0x0000000209007810ULL, 0x000fc60007ffe0ffULL, 0x00005e0002027625ULL, 0x000fc800078e000aULL,
0x0000000100077824ULL, 0x004fe200078e020fULL, 0x0000001102047210ULL, 0x000fe20007f1e0ffULL,
0x0000001000007824ULL, 0x000fe200078e00ffULL, 0xfffffff006027812ULL, 0x000fc600078ee205ULL,
0x000000ffff057224ULL, 0x000fe200000e0603ULL, 0x0000c000020d7811ULL, 0x000fe400078e20ffULL,
0x000000020b037810ULL, 0x000fe40007ffe0ffULL, 0xfffffff000007812ULL, 0x000fe200078ee207ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040d7faeULL, 0x0003e8000b901c46ULL,
0x010a080009087984ULL, 0x000ea20000004800ULL, 0x0000c000000d7811ULL, 0x002fc400078e20ffULL,
0x0000000409007810ULL, 0x000fca0007ffe0ffULL, 0x0000000100057824ULL, 0x040fe400078e020fULL,
0x0000001000007824ULL, 0x000fca00078e00ffULL, 0xfffffff000007812ULL, 0x000fe200078ee205ULL,
0x010ac00008087984ULL, 0x004e640000004800ULL, 0x0000000408037c24ULL, 0x002fc8000f8e0203ULL,
0x00005e0003027625ULL, 0x000fca00078e000aULL, 0x0000001102067210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff077224ULL, 0x000fe200000e0603ULL, 0x000000040b037810ULL, 0x040fe40007ffe0ffULL,
0x000000060b0b7810ULL, 0x000fe40007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000060d7faeULL, 0x0003e8000b901c46ULL, 0x010a100009087984ULL, 0x000ea20000004800ULL,
0x0000c00000077811ULL, 0x002fc400078e20ffULL, 0x0000000609007810ULL, 0x000fe20007ffe0ffULL,
0x010ac00008087984ULL, 0x004e640000004800ULL, 0x0000000408037c24ULL, 0x002fe4000f8e0203ULL,
0x0000000100087824ULL, 0x000fe400078e020fULL, 0x00005e0003027625ULL, 0x000fca00078e000aULL,
0x0000001102047210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff057224ULL, 0x000fca00000e0603ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004077faeULL, 0x0003e8000b901c46ULL,
0x010a180009067984ULL, 0x000ea80000004800ULL, 0x010ac00006067984ULL, 0x004ea40000004800ULL,
0x0000000406027c24ULL, 0x004fc4000f8e020bULL, 0x00000010000b7824ULL, 0x000fe400078e00ffULL,
0x00005e0002027625ULL, 0x000fc600078e000aULL, 0xfffffff00b087812ULL, 0x000fe400078ee208ULL,
0x0000001102027210ULL, 0x000fe40007f1e0ffULL, 0x0000c00008057811ULL, 0x002fc600078e20ffULL,
0x000000ffff037224ULL, 0x000fca00000e0603ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002057faeULL, 0x0003e6000b901c46ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8800ff027f8cULL, 0x002e64000c80043fULL, 0x000000ffff097224ULL, 0x002fc400078e0003ULL,
0x0000000000027805ULL, 0x000fca0000015200ULL, 0x010b8c00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff067224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fcc0000015200ULL,
0x0000000402077210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e03ULL,
0x003d09000700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011405ULL, 0x0000000700007211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000200007819ULL, 0x000fc80000001205ULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000106067810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x010b8c00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000327919ULL, 0x000e620000000000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x0000002065047824ULL, 0x002fca00078e0232ULL,
0x0000001f0400780cULL, 0x000fda0003f04070ULL, 0x000000b000000947ULL, 0x000fea0003800000ULL,
0x0000002004007810ULL, 0x040fe20007ffe0ffULL, 0x0000680063027a24ULL, 0x000fe200078e0204ULL,
0x00010a0004057811ULL, 0x000fe200078e10ffULL, 0x00000004ff037424ULL, 0x000fe200078e00ffULL,
0x000000610000720cULL, 0x000fe40003f06070ULL, 0x0000002002027810ULL, 0x000fca0007ffe0ffULL,
0x0000660002027625ULL, 0x000fcc00078e0003ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002057faeULL, 0x0003e4000c121846ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x010b7800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b7800ff027f8cULL, 0x002e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000ff3700720cULL, 0x000fe20003f05270ULL, 0x010b8800ff047f8cULL, 0x000ea2000c80043fULL,
0x000000ffff607224ULL, 0x000fe200078e00ffULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000001fff117424ULL, 0x000fc400078e00ffULL,
0xffffffffff107424ULL, 0x000fe200078e00ffULL, 0x0001d28000008947ULL, 0x000fea0003800000ULL,
0x00005800ff0c7624ULL, 0x000fe200078e00ffULL, 0x0001d26000007945ULL, 0x000fe20003800000ULL,
0x000000ffff717224ULL, 0x002fe400078e0003ULL, 0x000000ffff3e7224ULL, 0x004fe400078e0005ULL,
0xff317217ff0f7424ULL, 0x000fe400078e00ffULL, 0x000000ffff607224ULL, 0x000fe400078e00ffULL,
0x000000ffff0e7224ULL, 0x000fc400078e00ffULL, 0x000000ffff0d7224ULL, 0x000fe400078e00ffULL,
0x000000400c0c7824ULL, 0x000fc400078e00ffULL, 0x000001000e007824ULL, 0x000fca00078e00ffULL,
0x000000610000720cULL, 0x000fda0003f06070ULL, 0x0001d17000000947ULL, 0x008fea0003800000ULL,
0x000000ffff727224ULL, 0x000fc600078e00ffULL, 0x0000000e3500720cULL, 0x000fe20003fa4070ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x00000002ff037819ULL, 0x000fe20000011672ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x0000000372007812ULL, 0x040fe400078ec0ffULL,
0x0000000372037207ULL, 0x000fe40002800000ULL, 0x000000ff003a7207ULL, 0x000fe40006800000ULL,
0x00000003033b7812ULL, 0x000fc400078ec0ffULL, 0x0000000e033c7211ULL, 0x000fc400078ff0ffULL,
0x0000000000027805ULL, 0x000fca0000015200ULL, 0x010b7c00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007804871ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000017945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000047805ULL, 0x000fcc0000015200ULL, 0x00000004020b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000105057824ULL, 0x000fe200000e0e03ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011405ULL,
0x0000000b00007211ULL, 0x000fca00078110ffULL, 0x000000ffff057224ULL, 0x000fca00000e0605ULL,
0x0000000200007819ULL, 0x000fc80000001205ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b7c00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007804871ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000027805ULL, 0x000fc40000015200ULL, 0x010b8c00ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe4000780483eULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fcc0000015200ULL,
0x00000004020b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e03ULL,
0x003d09000b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011405ULL, 0x0000000b00007211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000200007819ULL, 0x000fc80000001205ULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8c00ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe4000780483eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000013c007810ULL, 0x000fe20007ffe0ffULL,
0x000009a000017945ULL, 0x000fe60003800000ULL, 0x000000370000720cULL, 0x000fda0003f06070ULL,
0x0000053000008947ULL, 0x000fea0003800000ULL, 0x00000004ff397819ULL, 0x100fe20000011632ULL,
0x000000043c007824ULL, 0x000fe200078e023bULL, 0x00000020340a7811ULL, 0x000fe200078e30ffULL,
0x0000001032047824ULL, 0x000fe200078e00ffULL, 0x0000000239417810ULL, 0x000fe20007ffe0ffULL,
0x00000001623d7824ULL, 0x000fe200078e0239ULL, 0x0000002000007811ULL, 0x000fe200078e30ffULL,
0x00000100ff3e7424ULL, 0x000fe200078e00ffULL, 0x000000f0043f7812ULL, 0x000fe200078ec0ffULL,
0x000000013d0b7824ULL, 0x000fe200078e0232ULL, 0x010a00003d027984ULL, 0x000e620000004800ULL,
0x0000000061037217ULL, 0x000fe20007800000ULL, 0x000000103d387824ULL, 0x000fc400078e00ffULL,
0x0000000162437824ULL, 0x000fe400078e0241ULL, 0x0000000103037824ULL, 0x000fe200078e0a00ULL,
0xfffffff0380b7812ULL, 0x000fe200078ee20bULL, 0x000000013d007824ULL, 0x000fe400078e020aULL,
0x0000000143407824ULL, 0x000fe200078e0232ULL, 0x0000000362037217ULL, 0x000fe40007800000ULL,
0x0000e0000b0b7811ULL, 0x000fe200078e20ffULL, 0x010ac00002057984ULL, 0x002e640000004800ULL,
0x000000050c057224ULL, 0x002fc400078e0200ULL, 0x0000000103007824ULL, 0x000fe400078e0a62ULL,
0x00005e0005027625ULL, 0x000fc600078e003eULL, 0x000000003900720cULL, 0x000fe40003f06070ULL,
0x0000003f02047210ULL, 0x000fe20007f3e0ffULL, 0x0000000143027824ULL, 0x040fe400078e020aULL,
0x0000001043437824ULL, 0x000fe400078e00ffULL, 0x000000ffff057224ULL, 0x000fcc00008e0603ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040b7faeULL, 0x0003e2000c101c46ULL,
0x000000004100720cULL, 0x000fe40003f06070ULL, 0x0000000439417810ULL, 0x040fe20007ffe0ffULL,
0x010a08003d387984ULL, 0x000ea20000004800ULL, 0x0000000639397810ULL, 0x000fe40007ffe0ffULL,
0xfffffff0430b7812ULL, 0x002fe200078ee240ULL, 0x0000000162437824ULL, 0x000fc600078e0241ULL,
0x0000e0000b0b7811ULL, 0x000fe200078e20ffULL, 0x0000000143407824ULL, 0x000fe200078e0232ULL,
0x010ac00038037984ULL, 0x004e640000004800ULL, 0x000000030c027224ULL, 0x002fc800078e0202ULL,
0x00005e0002027625ULL, 0x000fca00078e003eULL, 0x0000003f02047210ULL, 0x000fe20007f3e0ffULL,
0x0000000143027824ULL, 0x040fe400078e020aULL, 0x0000001043437824ULL, 0x000fe400078e00ffULL,
0x000000ffff057224ULL, 0x000fca00008e0603ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040b7faeULL, 0x0003e2000c101c46ULL, 0x000000004100720cULL, 0x000fe20003f06070ULL,
0x0000000162417824ULL, 0x000fe400078e0239ULL, 0x010a10003d387984ULL, 0x000ea40000004800ULL,
0x00000001410a7824ULL, 0x000fe200078e020aULL, 0xfffffff0430b7812ULL, 0x002fc800078ee240ULL,
0x0000e0000b0b7811ULL, 0x000fe200078e20ffULL, 0x010ac00038037984ULL, 0x004e640000004800ULL,
0x000000030c027224ULL, 0x002fc800078e0202ULL, 0x00005e0002027625ULL, 0x000fca00078e003eULL,
0x0000003f02047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e0603ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040b7faeULL, 0x0003e2000c101c46ULL,
0x000000003900720cULL, 0x000fc60003f06070ULL, 0x010a18003d387984ULL, 0x000ea80000004800ULL,
0x010ac00038037984ULL, 0x004ea40000004800ULL, 0x000000030c037224ULL, 0x004fe400078e020aULL,
0x00000001410a7824ULL, 0x000fe400078e0232ULL, 0x00005e0003027625ULL, 0x000fc800078e003eULL,
0x0000001041417824ULL, 0x000fe200078e00ffULL, 0x0000003f02027210ULL, 0x000fc80007f3e0ffULL,
0xfffffff041057812ULL, 0x002fe200078ee20aULL, 0x000000ffff037224ULL, 0x000fc600008e0603ULL,
0x0000e00005057811ULL, 0x000fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002057faeULL, 0x0003e2000c101c46ULL, 0x0000044000007947ULL, 0x000fea0003800000ULL,
0x00000062323d7211ULL, 0x040fe200078fe0ffULL, 0x0000001032047824ULL, 0x000fe200078e00ffULL,
0x0000002034387811ULL, 0x000fe200078e30ffULL, 0x00000100ff3f7424ULL, 0x000fe200078e00ffULL,
0x000000023d0b7810ULL, 0x040fe20007ffe0ffULL, 0x010a00003d007984ULL, 0x000e620000004800ULL,
0x000000f004417812ULL, 0x000fe200078ec0ffULL, 0x000000013d027824ULL, 0x040fe400078e0238ULL,
0x000000013d057824ULL, 0x000fc400078e0232ULL, 0x000000103d0a7824ULL, 0x000fe400078e00ffULL,
0x000000010b3e7824ULL, 0x000fc600078e0232ULL, 0xfffffff00a397812ULL, 0x000fc800078ee205ULL,
0x0000e00039397811ULL, 0x000fe200078e20ffULL, 0x010ac00000037984ULL, 0x002e640000004800ULL,
0x000000030c027224ULL, 0x002fc800078e0202ULL, 0x00005e0002027625ULL, 0x000fca00078e003fULL,
0x0000004102047210ULL, 0x000fe20007f1e0ffULL, 0x000000010b027824ULL, 0x040fe400078e0238ULL,
0x000000100b0b7824ULL, 0x000fe400078e00ffULL, 0x000000ffff057224ULL, 0x000fc600000e0603ULL,
0xfffffff00b3e7812ULL, 0x000fe400078ee23eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004397faeULL, 0x0003e8000b901c46ULL, 0x010a08003d007984ULL, 0x000ea20000004800ULL,
0x0000e0003e397811ULL, 0x002fe400078e20ffULL, 0x000000043d057810ULL, 0x000fca0007ffe0ffULL,
0x00000001053e7824ULL, 0x000fe200078e0232ULL, 0x010ac00000037984ULL, 0x004e640000004800ULL,
0x000000030c027224ULL, 0x002fc800078e0202ULL, 0x00005e0002027625ULL, 0x000fca00078e003fULL,
0x00000041020a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000105027824ULL, 0x040fe400078e0238ULL,
0x0000001005057824ULL, 0x000fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x000fc600000e0603ULL,
0xfffffff0053e7812ULL, 0x000fe400078ee23eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a397faeULL, 0x0003e8000b901c46ULL, 0x010a10003d007984ULL, 0x000ea20000004800ULL,
0x0000e0003e0b7811ULL, 0x002fe400078e20ffULL, 0x000000063d397810ULL, 0x000fca0007ffe0ffULL,
0x00000001390a7824ULL, 0x000fe200078e0232ULL, 0x010ac00000037984ULL, 0x004e640000004800ULL,
0x000000030c027224ULL, 0x002fc800078e0202ULL, 0x00005e0002027625ULL, 0x000fca00078e003fULL,
0x0000004102047210ULL, 0x000fe20007f1e0ffULL, 0x0000000139027824ULL, 0x040fe400078e0238ULL,
0x0000001039397824ULL, 0x000fe400078e00ffULL, 0x000000ffff057224ULL, 0x000fc600000e0603ULL,
0xfffffff0390a7812ULL, 0x000fe400078ee20aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040b7faeULL, 0x0003e8000b901c46ULL, 0x010a18003d007984ULL, 0x000ea20000004800ULL,
0x0000e0000a057811ULL, 0x002fc600078e20ffULL, 0x010ac00000037984ULL, 0x004e640000004800ULL,
0x000000030c027224ULL, 0x002fc800078e0202ULL, 0x00005e0002027625ULL, 0x000fca00078e003fULL,
0x0000004102027210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff037224ULL, 0x000fca00000e0603ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002057faeULL, 0x0003e6000b901c46ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8800ff027f8cULL, 0x002e64000c80043fULL, 0x000000ffff397224ULL, 0x002fc400078e0003ULL,
0x0000000000027805ULL, 0x000fca0000015200ULL, 0x010b8c00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007804839ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fcc0000015200ULL,
0x00000004020b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e03ULL,
0x003d09000b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011405ULL, 0x0000000b00007211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000200007819ULL, 0x000fc80000001205ULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8c00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007804839ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000003c3500720cULL, 0x000fe20003f04070ULL,
0x00000020650b7824ULL, 0x000fe200078e0232ULL, 0x000000013a007810ULL, 0x040fe20007ffe0ffULL,
0x000001d000017945ULL, 0x000fe20003800000ULL, 0x000000033a00780cULL, 0x000fe40003f45270ULL,
0x0000000300027812ULL, 0x000fc400078ec0ffULL, 0x0000003c3500720cULL, 0x000fe40003f24070ULL,
0x0000001f0b00780cULL, 0x000fe40003f84070ULL, 0x000000ff02047207ULL, 0x000fe40004000000ULL,
0x00000002ff008819ULL, 0x000fca0000011600ULL, 0x000000013b007824ULL, 0x000fc800078e0200ULL,
0x0000004000037824ULL, 0x040fe200078e00ffULL, 0x0000003c00007211ULL, 0x000fc800078ff0ffULL,
0x000000c003037812ULL, 0x000fca00078ec0ffULL, 0x0000010000057824ULL, 0x000fe200078e0203ULL,
0x0000010000009947ULL, 0x000fea0001000000ULL, 0x0000002065037824ULL, 0x000fe200078e0232ULL,
0x000000010d0d7810ULL, 0x000fc80007ffe0ffULL, 0x000000030300780cULL, 0x000fda0003f04070ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x0000000436027824ULL, 0x000fe200078e0203ULL,
0x000064000d007a10ULL, 0x040fe20007ffe0ffULL, 0x00000004ff3b7424ULL, 0x000fe200078e00ffULL,
0x000000640d00720cULL, 0x000fe20003f06070ULL, 0x0000000202397824ULL, 0x000fc800078e00ffULL,
0x0000640039007a24ULL, 0x000fe200078e0200ULL, 0x00010ac003397811ULL, 0x000fc600078e10ffULL,
0x0000600000027625ULL, 0x000fca00078e003bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002397faeULL, 0x0003e4000c121846ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000e000017945ULL, 0x000fe20003800000ULL, 0x000000c000004947ULL, 0x000fea0003800000ULL,
0x000000010b027824ULL, 0x102fe400078e0205ULL, 0x0000000163007824ULL, 0x000fe400078e0204ULL,
0x00000004ff037424ULL, 0x000fe200078e00ffULL, 0x000000610200720cULL, 0x000fe20003f06070ULL,
0x0000680000007a24ULL, 0x000fe200078e0205ULL, 0x00010a000b057811ULL, 0x000fc600078e10ffULL,
0x000000010b007824ULL, 0x000fc800078e0200ULL, 0x0000660000027625ULL, 0x000fca00078e0003ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002057faeULL, 0x0003e4000c121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x010b8000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000ff7200720cULL, 0x000fe20003f05270ULL,
0x010b8000ff6c7f8cULL, 0x000ea2000c80043fULL, 0x0000080000017945ULL, 0x000fe20003800000ULL,
0xffffffffff0a7424ULL, 0x000fd400078e00ffULL, 0x000007d000000947ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010ad80062027f8cULL, 0x002e64000c80043fULL,
0x000000ffff397224ULL, 0x002fc400078e0003ULL, 0x0000000000027805ULL, 0x000fca0000015200ULL,
0x010adc0062007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007804839ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000027945ULL, 0x000fe20003800000ULL,
0x000000ffff387224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000037945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000047805ULL, 0x000fcc0000015200ULL, 0x0000000402097210ULL, 0x000fca0007f1e1ffULL,
0x0000000105057824ULL, 0x000fe200000e0e03ULL, 0x003d09000900780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400900780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011405ULL,
0x0000000900007211ULL, 0x000fca00078110ffULL, 0x000000ffff057224ULL, 0x000fca00000e0605ULL,
0x0000000200007819ULL, 0x000fc80000001205ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000138387810ULL, 0x000fc40007ffe0ffULL,
0x0000000000037941ULL, 0x000fea0003800000ULL, 0x010adc0062007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007804839ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000001032007824ULL, 0x000fe200078e00ffULL, 0x00000001ff027819ULL, 0x000fc80000011632ULL,
0x0000007000007812ULL, 0x000fe400078ec0ffULL, 0x0000000c02037812ULL, 0x000fca00078ec0ffULL,
0x0000000100007824ULL, 0x000fca00078e0203ULL, 0x0100000000027984ULL, 0x000e680000000800ULL,
0x0102000000037984ULL, 0x0006a20000000800ULL, 0x0000000f0200720bULL, 0x002fe20003f1d000ULL,
0x000234527f007947ULL, 0x000fd8000b800000ULL, 0x0000000000047806ULL, 0x008fc800000e0100ULL,
0x0000ffff043b7812ULL, 0x000fe2000780c0ffULL, 0x0000045000027945ULL, 0x000fe20003800000ULL,
0x00000001ff097424ULL, 0x000fe400078e00ffULL, 0x000000ffff057224ULL, 0x000fd200078e000fULL,
0x0000041000008947ULL, 0x000fea0003800000ULL, 0x000000ff6500720cULL, 0x000fe40003f05270ULL,
0x0000000f0200720bULL, 0x000fe20003f34000ULL, 0x000234127f007947ULL, 0x000fd8000b800000ULL,
0x0000000000047806ULL, 0x000fc400008e0100ULL, 0x000000020f057209ULL, 0x000fe20007810000ULL,
0x0000035000037945ULL, 0x000fe20003800000ULL, 0x0000991004387816ULL, 0x000fc600000000ffULL,
0x0104000500008388ULL, 0x0003e20000000800ULL, 0x000000ff3800720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x800000050f007221ULL, 0x002fe20000010000ULL,
0x000000ff04ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000047945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b00007820ULL, 0x000fc80000410000ULL, 0x00000000000f7308ULL, 0x000e640000000800ULL,
0x0000000f12127220ULL, 0x002fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff007819ULL, 0x000fe20000011632ULL, 0x000233627f007947ULL, 0x000fea000b800000ULL,
0x00001f000f007589ULL, 0x0002e400000e0000ULL, 0x0000000013137220ULL, 0x088fe20000410000ULL,
0x0000000014147220ULL, 0x080fe20000410000ULL, 0x0000000017177220ULL, 0x080fe20000410000ULL,
0x0000000018187220ULL, 0x080fe20000410000ULL, 0x000000001b1b7220ULL, 0x080fe20000410000ULL,
0x000000001c1c7220ULL, 0x080fe20000410000ULL, 0x000000001f1f7220ULL, 0x080fe20000410000ULL,
0x0000000020207220ULL, 0x080fe20000410000ULL, 0x0000000023237220ULL, 0x080fe20000410000ULL,
0x0000000024247220ULL, 0x080fe20000410000ULL, 0x0000000027277220ULL, 0x080fe20000410000ULL,
0x0000000028287220ULL, 0x080fe20000410000ULL, 0x000000002b2b7220ULL, 0x080fe20000410000ULL,
0x000000002c2c7220ULL, 0x080fe20000410000ULL, 0x000000002f2f7220ULL, 0x080fe20000410000ULL,
0x0000000030307220ULL, 0x000fc40000410000ULL, 0x0000000000047941ULL, 0x000fea0003800000ULL,
0x0000ff0004ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000832007811ULL, 0x000fe200078ff0ffULL, 0x000232627f007947ULL, 0x000fea000b800000ULL,
0x00001f000f007589ULL, 0x00066400000e0000ULL, 0x0000000015157220ULL, 0x082fe20000410000ULL,
0x0000000016167220ULL, 0x080fe20000410000ULL, 0x0000000019197220ULL, 0x080fe20000410000ULL,
0x000000001a1a7220ULL, 0x080fe20000410000ULL, 0x000000001d1d7220ULL, 0x080fe20000410000ULL,
0x000000001e1e7220ULL, 0x080fe20000410000ULL, 0x0000000021217220ULL, 0x080fe20000410000ULL,
0x0000000022227220ULL, 0x080fe20000410000ULL, 0x0000000025257220ULL, 0x080fe20000410000ULL,
0x0000000026267220ULL, 0x080fe20000410000ULL, 0x0000000029297220ULL, 0x080fe20000410000ULL,
0x000000002a2a7220ULL, 0x080fe20000410000ULL, 0x000000002d2d7220ULL, 0x080fe20000410000ULL,
0x000000002e2e7220ULL, 0x080fe20000410000ULL, 0x0000000031317220ULL, 0x080fe20000410000ULL,
0x0000000060607220ULL, 0x000fc40000410000ULL, 0x0000000000037941ULL, 0x002fea0003800000ULL,
0x0000ffff3bff7812ULL, 0x000fda0007806004ULL, 0x8000000502020221ULL, 0x000fe20000010000ULL,
0x00007610ff090816ULL, 0x000fc60000000009ULL, 0x3fb8aa3b02020820ULL, 0x000fc80000410000ULL,
0x0000000200080308ULL, 0x000e640000000800ULL, 0x0000000803030220ULL, 0x006fcc0000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000001203127221ULL, 0x004fe20000010000ULL,
0x000000ffff0f7224ULL, 0x008fc400078e0005ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ff09ff7812ULL, 0x000fe2000782c0ffULL, 0x0000014000017945ULL, 0x000fd80003800000ULL,
0x0000012000001947ULL, 0x000fea0003800000ULL, 0x00000008ff00723eULL, 0x000fe400000010ffULL,
0x00000002ff037819ULL, 0x002fe40000011632ULL, 0x0000541000007816ULL, 0x000fe20000000000ULL,
0x000230927f007947ULL, 0x000fea000b800000ULL, 0x00001f0300077589ULL, 0x0002e400000e0000ULL,
0x0000000803067810ULL, 0x000fe20007ffe0ffULL, 0x000230c27f007947ULL, 0x000fea000b800000ULL,
0x00001f0600067589ULL, 0x0002e400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000010033f7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff3e7224ULL, 0x000fe200078e0000ULL,
0x0000398000387802ULL, 0x000fc40000000f00ULL, 0x00023f3000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000018033f7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff3e7224ULL, 0x004fe200078e0000ULL, 0x000039d000387802ULL, 0x000fc40000000f00ULL,
0x00023ee000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000832037812ULL, 0x002fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000004ff057819ULL, 0x100fe20000011632ULL, 0x0000208000017945ULL, 0x000fe20003800000ULL,
0x00000007035c7812ULL, 0x000fc400078ef832ULL, 0x0000000265007811ULL, 0x040fe200078e10ffULL,
0x00000004655f7824ULL, 0x000fe200078e0205ULL, 0x000000105c387812ULL, 0x040fe200078efcffULL,
0x000000105c037824ULL, 0x040fe400078e00ffULL, 0x000000015c027824ULL, 0x000fe200078e025fULL,
0x00000000386a7210ULL, 0x040fe20007ffe005ULL, 0x00000001055d7824ULL, 0x000fe400078e0200ULL,
0x000000015f6b7824ULL, 0x000fe200078e0238ULL, 0xfffffff003027812ULL, 0x000fe200078ee202ULL,
0x00000010383d7824ULL, 0x000fc600078e00ffULL, 0x0000c00002047811ULL, 0x000fe200078e20ffULL,
0x000000015c027824ULL, 0x000fe200078e025dULL, 0xfffffff03d6a7812ULL, 0x000fc600078ee26aULL,
0x000000000440783bULL, 0x000e620000004200ULL, 0xfffffff003027812ULL, 0x000fe400078ee202ULL,
0x0000c0006a007811ULL, 0x000fe400078e20ffULL, 0x0000c00002037811ULL, 0x000fe200078e20ffULL,
0x0000001038027824ULL, 0x000fe400078e00ffULL, 0x00000000003c783bULL, 0x004ea60000004200ULL,
0xfffffff0026b7812ULL, 0x000fe200078ee26bULL, 0x000000000344783bULL, 0x000f260000004200ULL,
0x0000c0006b027811ULL, 0x000fca00078e20ffULL, 0x000000000238783bULL, 0x000ee20000004200ULL,
0x0000004000697306ULL, 0x002fe20000009400ULL, 0x00000018ffab7819ULL, 0x000fe20000011440ULL,
0x0000010040527824ULL, 0x000fe200078e00ffULL, 0x00000018ffa27819ULL, 0x000fe40000011441ULL,
0x00000018ff9d7819ULL, 0x000fe40000011442ULL, 0x00000018ff927819ULL, 0x000fe20000011452ULL,
0x00000040006c7306ULL, 0x000e620000005400ULL, 0x00000018ff9a7819ULL, 0x000fc40000011443ULL,
0x00000018ff827819ULL, 0x004fe2000001143cULL, 0x0000010044b67824ULL, 0x050fe200078e00ffULL,
0x00000018ff8d7819ULL, 0x000fe20000011445ULL, 0x0001000044ba7824ULL, 0x000fe200078e00ffULL,
0x00000018ff707819ULL, 0x000fe20000011444ULL, 0x00000040004f7306ULL, 0x000522000000d400ULL,
0x00000018ffb67819ULL, 0x000fe200000114b6ULL, 0x0000010045b47824ULL, 0x040fe200078e00ffULL,
0x00000018ffba7819ULL, 0x000fe200000114baULL, 0x0000010046a57824ULL, 0x000fe200078e00ffULL,
0x00000018ff897819ULL, 0x000fe20000011446ULL, 0x0001000045ac7824ULL, 0x000fe200078e00ffULL,
0x00000018ffb47819ULL, 0x000fe200000114b4ULL, 0x0000009200757306ULL, 0x000fe20000209400ULL,
0x0001000040407824ULL, 0x004fe200078e00ffULL, 0x0000006c6900720bULL, 0x002fe20003fdd000ULL,
0x0000010047a87824ULL, 0x040fe200078e00ffULL, 0x00000018ffa57819ULL, 0x000fe200000114a5ULL,
0x0001000047a77824ULL, 0x000fe200078e00ffULL, 0x00000018ffa07819ULL, 0x000fe20000011440ULL,
0x0000010041407824ULL, 0x000fe200078e00ffULL, 0x0000009200767306ULL, 0x0002a20000205400ULL,
0x00000018ffac7819ULL, 0x000fe200000114acULL, 0x0001000046a97824ULL, 0x000fe200078e00ffULL,
0x00000018ffa87819ULL, 0x000fc400000114a8ULL, 0x00000018ffbd7819ULL, 0x000fe20000011440ULL,
0x0000010042407824ULL, 0x000fe200078e00ffULL, 0x000000014f4f6812ULL, 0x010fe200078efcffULL,
0x000000a000777306ULL, 0x000fe20000209400ULL, 0x0000009200927245ULL, 0x002fe4000020d400ULL,
0x00000018ffc57819ULL, 0x000fe20000011440ULL, 0x0000010043407824ULL, 0x000fe200078e00ffULL,
0x00000018ffa77819ULL, 0x000fe400000114a7ULL, 0x00000018ff8e7819ULL, 0x008fe20000011438ULL,
0x000000a000bc7306ULL, 0x0002e20000205400ULL, 0x000000767500720bULL, 0x004fc40003f7d000ULL,
0x00000018ffcb7819ULL, 0x000fe40000011440ULL, 0x00000018ffa97819ULL, 0x000fe400000114a9ULL,
0x00000018ff547819ULL, 0x000fe20000011447ULL, 0x0000004100bb7306ULL, 0x000fe20000009400ULL,
0x000000a000a07245ULL, 0x002fe4000020d400ULL, 0x00000018ff837819ULL, 0x000fe4000001143bULL,
0x00000018ff7f7819ULL, 0x000fc4000001143dULL, 0x0000000192923812ULL, 0x000fe200078efcffULL,
0x0000004100c07306ULL, 0x000e620000005400ULL, 0x000000bc7700720bULL, 0x008fe40003f5d000ULL,
0x00000018ff697819ULL, 0x000fe4000001143eULL, 0x00000018ff6c7819ULL, 0x000fc6000001143fULL,
0x00000041004e7306ULL, 0x0004ec000000d400ULL, 0x00000001a0a02812ULL, 0x000fe400078efcffULL,
0x000000ab00b17306ULL, 0x000fe20000209400ULL, 0x0001000041417824ULL, 0x004fe200078e00ffULL,
0x000000c0bb00720bULL, 0x002fe20003fdd000ULL, 0x0000010038bb7824ULL, 0x000fc600078e00ffULL,
0x00000018ffc17819ULL, 0x000fe40000011441ULL, 0x000000ab00be7306ULL, 0x0002a20000205400ULL,
0x00000018ffbb7819ULL, 0x000fcc00000114bbULL, 0x000000014e4e6812ULL, 0x008fe200078efcffULL,
0x000000bd00bf7306ULL, 0x000fe20000209400ULL, 0x000000ab00ab7245ULL, 0x002fce000020d400ULL,
0x000000bd00c27306ULL, 0x000e620000205400ULL, 0x000000beb100720bULL, 0x004fe40003f1d000ULL,
0x000000bd00b17245ULL, 0x000fca000020d400ULL, 0x000000c100c37306ULL, 0x000fec0000209400ULL,
0x00000001abab0812ULL, 0x000fe400078efcffULL, 0x000000c100c47306ULL, 0x000ea20000205400ULL,
0x000000c2bf00720bULL, 0x002fce0003f7d000ULL, 0x0000004200a37306ULL, 0x000fec0000009400ULL,
0x00000001b1b13812ULL, 0x000fe400078efcffULL, 0x0000004200a47306ULL, 0x000e620000005400ULL,
0x000000c4c300720bULL, 0x004fce0003f5d000ULL, 0x0000004200587306ULL, 0x0004f0000000d400ULL,
0x000000a200787306ULL, 0x000fe20000209400ULL, 0x0001000042427824ULL, 0x004fe200078e00ffULL,
0x000000a4a300720bULL, 0x002fc40003fdd000ULL, 0x000000c500a37245ULL, 0x000fe4000020d400ULL,
0x00000018ffc87819ULL, 0x000fe40000011442ULL, 0x000000a200b97306ULL, 0x0002a20000205400ULL,
0x000000cb00a47245ULL, 0x000fe4000020d400ULL, 0x00000018ff427819ULL, 0x000fc8000001143aULL,
0x0000000158586812ULL, 0x008fe200078efcffULL, 0x000000c500c67306ULL, 0x000fe20000209400ULL,
0x000000a200a27245ULL, 0x002fce000020d400ULL, 0x000000c500c77306ULL, 0x000e620000205400ULL,
0x000000b97800720bULL, 0x004fe40003f1d000ULL, 0x000000c100b97245ULL, 0x000fc8000020d400ULL,
0x00000001b9b92812ULL, 0x000fe200078efcffULL, 0x000000c800c97306ULL, 0x000fec0000209400ULL,
0x00000001a2a20812ULL, 0x000fe400078efcffULL, 0x000000c800ca7306ULL, 0x000ea20000205400ULL,
0x000000c7c600720bULL, 0x002fce0003f7d000ULL, 0x00000043009e7306ULL, 0x000fec0000009400ULL,
0x00000001a3a33812ULL, 0x000fe400078efcffULL, 0x00000043009f7306ULL, 0x000e620000005400ULL,
0x000000cac900720bULL, 0x004fe40003f5d000ULL, 0x00000058a358723eULL, 0x000fca00000010ffULL,
0x0000004300597306ULL, 0x0004f0000000d400ULL, 0x0000009d00a17306ULL, 0x000fe20000209400ULL,
0x0001000043437824ULL, 0x004fe200078e00ffULL, 0x0000009f9e00720bULL, 0x002fc40003fdd000ULL,
0x0000009d009e7245ULL, 0x000fe4000020d400ULL, 0x00000018ffce7819ULL, 0x000fe40000011443ULL,
0x0000009d00a67306ULL, 0x000e6e0000205400ULL, 0x0000000159596812ULL, 0x008fe200078efcffULL,
0x000000cb00cc7306ULL, 0x000ff00000209400ULL, 0x000000cb00cd7306ULL, 0x000ea20000205400ULL,
0x000000a6a100720bULL, 0x002fc40003f1d000ULL, 0x000000c800a17245ULL, 0x000fc8000020d400ULL,
0x00000001a1a12812ULL, 0x000fe200078efcffULL, 0x000000ce00cf7306ULL, 0x000fec0000209400ULL,
0x000000019e9e0812ULL, 0x000fe400078efcffULL, 0x000000ce00d07306ULL, 0x000e620000205400ULL,
0x000000cdcc00720bULL, 0x004fce0003f7d000ULL, 0x0000004400997306ULL, 0x000fec0000009400ULL,
0x00000001a4a43812ULL, 0x000fe400078efcffULL, 0x0000004400987306ULL, 0x000ea20000005400ULL,
0x000000d0cf00720bULL, 0x002fe40003f5d000ULL, 0x00000059a459723eULL, 0x000fca00000010ffULL,
0x0000009a009c7306ULL, 0x000ff00000209400ULL, 0x0000009a009b7306ULL, 0x0002e20000205400ULL,
0x000000989900720bULL, 0x004fe40003fdd000ULL, 0x000000b600997245ULL, 0x000fca000020d400ULL,
0x000000b600d17306ULL, 0x000fe20000209400ULL, 0x0000009a009a7245ULL, 0x002fce000020d400ULL,
0x000000b600d27306ULL, 0x000e620000205400ULL, 0x0000009b9c00720bULL, 0x008fe40003f1d000ULL,
0x000000ce009b7245ULL, 0x000fc8000020d400ULL, 0x000000019b9b2812ULL, 0x000fe200078efcffULL,
0x000000ba00d37306ULL, 0x000fec0000209400ULL, 0x000000019a9a0812ULL, 0x000fe400078efcffULL,
0x000000ba00d47306ULL, 0x0004e20000205400ULL, 0x000000d2d100720bULL, 0x002fce0003f7d000ULL,
0x0000004400487306ULL, 0x000e62000000d400ULL, 0x000000ba00ba7245ULL, 0x004fca000020d400ULL,
0x0000000199993812ULL, 0x000fe400078efcffULL, 0x00000045006e7306ULL, 0x000fe20000009400ULL,
0x000000d4d300720bULL, 0x008fce0003f5d000ULL, 0x0000004500937306ULL, 0x000ea20000005400ULL,
0x0000000148486812ULL, 0x002fc800078efcffULL, 0x000000489948723eULL, 0x000fe400000010ffULL,
0x00000001baba2812ULL, 0x000fe200078efcffULL, 0x000000b400d57306ULL, 0x000ff00000209400ULL,
0x000000b400d67306ULL, 0x0002e20000205400ULL, 0x000000936e00720bULL, 0x004fc40003fdd000ULL,
0x0000007000937245ULL, 0x000fca000020d400ULL, 0x0000008d00947306ULL, 0x000fe20000209400ULL,
0x000000b400b47245ULL, 0x002fce000020d400ULL, 0x0000008d00957306ULL, 0x0002a20000205400ULL,
0x000000d6d500720bULL, 0x008fce0003f7d000ULL, 0x0000007000967306ULL, 0x000fe20000209400ULL,
0x0000008d008d7245ULL, 0x002fca000020d400ULL, 0x00000001b4b43812ULL, 0x000fe400078efcffULL,
0x0000007000977306ULL, 0x000e620000205400ULL, 0x000000959400720bULL, 0x004fe20003f5d000ULL,
0x000001003a947824ULL, 0x000fcc00078e00ffULL, 0x0000004500497306ULL, 0x0004ec000000d400ULL,
0x000000018d8d2812ULL, 0x000fe400078efcffULL, 0x00000046008f7306ULL, 0x000fe20000009400ULL,
0x000000979600720bULL, 0x002fe40003f1d000ULL, 0x00000018ff457819ULL, 0x004fca0000011439ULL,
0x0000004600667306ULL, 0x000e620000005400ULL, 0x0000000149496812ULL, 0x008fc800078efcffULL,
0x00000049b449723eULL, 0x000fe400000010ffULL, 0x0000000193930812ULL, 0x000fe200078efcffULL,
0x000000a500b77306ULL, 0x000ff00000209400ULL, 0x000000a500b87306ULL, 0x000ea20000205400ULL,
0x000000668f00720bULL, 0x002fc40003fdd000ULL, 0x000000a8008f7245ULL, 0x000fca000020d400ULL,
0x00000089008c7306ULL, 0x000ff00000209400ULL, 0x00000089008b7306ULL, 0x000e620000205400ULL,
0x000000b8b700720bULL, 0x004fce0003f7d000ULL, 0x000000ac00b57306ULL, 0x000ff00000209400ULL,
0x000000ac00b27306ULL, 0x0004e20000205400ULL, 0x0000008b8c00720bULL, 0x002fe20003f5d000ULL,
0x000001003f8c7824ULL, 0x000fca00078e00ffULL, 0x00000018ff8c7819ULL, 0x000fe2000001148cULL,
0x00000046004d7306ULL, 0x000e62000000d400ULL, 0x000000ac00ac7245ULL, 0x004fce000020d400ULL,
0x0000004700677306ULL, 0x000fe20000009400ULL, 0x000000b2b500720bULL, 0x008fe40003f1d000ULL,
0x00000018ffb27819ULL, 0x000fe40000011494ULL, 0x000000a500947245ULL, 0x000fc6000020d400ULL,
0x0000004700887306ULL, 0x000ea20000005400ULL, 0x000000014d4d6812ULL, 0x002fe400078efcffULL,
0x0000000194943812ULL, 0x000fc600078efcffULL, 0x00000001acac0812ULL, 0x000fe400078efcffULL,
0x000000a800b07306ULL, 0x000ff00000209400ULL, 0x000000a800b37306ULL, 0x000e620000205400ULL,
0x000000886700720bULL, 0x004fc40003fdd000ULL, 0x0000008900887245ULL, 0x000fe2000020d400ULL,
0x000100003f897824ULL, 0x000fc600078e00ffULL, 0x0000000188882812ULL, 0x000fe200078efcffULL,
0x000000a700ae7306ULL, 0x000ff00000209400ULL, 0x000000a700af7306ULL, 0x0004e20000205400ULL,
0x000000b3b000720bULL, 0x002fe20003f7d000ULL, 0x000100003eb07824ULL, 0x000fca00078e00ffULL,
0x00000018ffb07819ULL, 0x000fe200000114b0ULL, 0x0000003800567306ULL, 0x000fe20000009400ULL,
0x000000a700a77245ULL, 0x004fca000020d400ULL, 0x000000018f8f3812ULL, 0x000fe400078efcffULL,
0x0000003800557306ULL, 0x000fe20000005400ULL, 0x000000afae00720bULL, 0x008fe20003f5d000ULL,
0x000001003eaf7824ULL, 0x000fca00078e00ffULL, 0x00000018ffaf7819ULL, 0x000fe200000114afULL,
0x00000038007e7306ULL, 0x0003ec000000d400ULL, 0x00000001a7a72812ULL, 0x000fe400078efcffULL,
0x000000bb00bc7306ULL, 0x000fe20000209400ULL, 0x0001000038387824ULL, 0x002fca00078e00ffULL,
0x00000018ff9f7819ULL, 0x000fe20000011438ULL, 0x0000010039387824ULL, 0x000fe200078e00ffULL,
0x000000bb00bd7306ULL, 0x0002a40000205400ULL, 0x0000009f008b7245ULL, 0x000fe4000020d400ULL,
0x00000018ff987819ULL, 0x000fc80000011438ULL, 0x0000009f009d7306ULL, 0x000fe20000209400ULL,
0x000000bb00bb7245ULL, 0x002fce000020d400ULL, 0x0000009f009c7306ULL, 0x000e620000205400ULL,
0x000000bdbc00720bULL, 0x004fce0003f7d000ULL, 0x0000003900867306ULL, 0x000fec0000009400ULL,
0x00000001bbbb3812ULL, 0x000fe400078efcffULL, 0x0000003900877306ULL, 0x000fe20000005400ULL,
0x0000009c9d00720bULL, 0x002fce0003f5d000ULL, 0x00000039007d7306ULL, 0x0003ec000000d400ULL,
0x000000018b8b2812ULL, 0x000fe400078efcffULL, 0x000000a900aa7306ULL, 0x000fe20000209400ULL,
0x0001000039397824ULL, 0x002fca00078e00ffULL, 0x00000018ff957819ULL, 0x000fe40000011439ULL,
0x000000a900ad7306ULL, 0x0002a20000205400ULL, 0x0000000732397812ULL, 0x000fc800078ec0ffULL,
0x0000000839707812ULL, 0x000fc600078ef832ULL, 0x0000008e00907306ULL, 0x000fe20000209400ULL,
0x000000a900a97245ULL, 0x002fe2000020d400ULL, 0x00000001056e7824ULL, 0x000fe400078e0270ULL,
0x0000000870b57824ULL, 0x040fe400078e00ffULL, 0x0000000870677824ULL, 0x000fe200078e00ffULL,
0x000000026e387810ULL, 0x000fe20007ffe0ffULL, 0x0000008e00917306ULL, 0x0002e20000205400ULL,
0x000000adaa00720bULL, 0x004fe40003f1d000ULL, 0xfffffff8b5667812ULL, 0x000fc400078ee238ULL,
0xfffffff867677812ULL, 0x000fc600078ee26eULL, 0x0000009500967306ULL, 0x000fe20000209400ULL,
0x0000008e008e7245ULL, 0x002fca000020d400ULL, 0x00000001a9a90812ULL, 0x000fe400078efcffULL,
0x0000009500397306ULL, 0x0002a20000205400ULL, 0x000000919000720bULL, 0x008fe40003f7d000ULL,
0x0000009500907245ULL, 0x000fe4000020d400ULL, 0x0000004500917245ULL, 0x000fc6000020d400ULL,
0x00000047004c7306ULL, 0x000ee2000000d400ULL, 0x000000b200957245ULL, 0x002fca000020d400ULL,
0x000000018e8e3812ULL, 0x000fe400078efcffULL, 0x0000005400577306ULL, 0x000fe20000209400ULL,
0x000000399600720bULL, 0x004fe20003f5d000ULL, 0x000001003c397824ULL, 0x000fe200078e00ffULL,
0x0000009800967245ULL, 0x000fc8000020d400ULL, 0x00000018ff9f7819ULL, 0x000fe20000011439ULL,
0x00000054008a7306ULL, 0x000e620000205400ULL, 0x000000014c4c6812ULL, 0x008fe400078efcffULL,
0x000000555600720bULL, 0x000fe40003fdd000ULL, 0x0000a00067557811ULL, 0x000fe400078e20ffULL,
0x0000000190902812ULL, 0x000fe200078efcffULL, 0x0000003a00847306ULL, 0x000fe20000009400ULL,
0x000000b9a239723eULL, 0x000fce00000010ffULL, 0x0000003a00857306ULL, 0x000ea20000005400ULL,
0x0000008a5700720bULL, 0x002fe20003f1d000ULL, 0x000001003b577824ULL, 0x000fe200078e00ffULL,
0x00000054008a7245ULL, 0x000fe4000020d400ULL, 0x000000017e7e6812ULL, 0x000fe400078efcffULL,
0x00000018ffa87819ULL, 0x000fe20000011457ULL, 0x000000b200387306ULL, 0x000fe20000209400ULL,
0x000000005554783bULL, 0x000e6a0000000200ULL, 0x000000018a8a0812ULL, 0x000fc400078efcffULL,
0x000000b200a57306ULL, 0x000ee20000205400ULL, 0x000000858400720bULL, 0x004fe40003f7d000ULL,
0x000000878600720bULL, 0x000fca0003f1d000ULL, 0x0000003a007c7306ULL, 0x000530000000d400ULL,
0x0000009800a67306ULL, 0x000fe20000209400ULL, 0x000100003a3a7824ULL, 0x004fe200078e00ffULL,
0x000000a53800720bULL, 0x008fc40003f5d000ULL, 0x000000017d7d0812ULL, 0x000fe400078efcffULL,
0x00000018ff3a7819ULL, 0x000fe4000001143aULL, 0x0000009800977306ULL, 0x000ea20000205400ULL,
0x000000017c7c3812ULL, 0x010fe400078efcffULL, 0x000000a0ab38723eULL, 0x000fc800000010ffULL,
0x0000000195952812ULL, 0x000fe200078efcffULL, 0x0000004200437306ULL, 0x000fe20000209400ULL,
0x0000000754549231ULL, 0x082fe400003400ffULL, 0x0000000756569231ULL, 0x000fe400003400ffULL,
0x0000000655559231ULL, 0x080fe400003400ffULL, 0x0000000657579231ULL, 0x000fe200003400ffULL,
0x0000004200447306ULL, 0x0002e20000205400ULL, 0x00000097a600720bULL, 0x004fe20003fdd000ULL,
0x000001003d977824ULL, 0x000fc400078e00ffULL, 0x000100003da67824ULL, 0x000fc600078e00ffULL,
0x00000018ffa27819ULL, 0x000fe20000011497ULL, 0x0000003a00aa7306ULL, 0x000fe20000209400ULL,
0x0000004200977245ULL, 0x000fe4000020d400ULL, 0x0000a00066427811ULL, 0x002fe400078e20ffULL,
0x00000018ffa67819ULL, 0x000fe400000114a6ULL, 0x0000000196966812ULL, 0x000fe200078efcffULL,
0x0000003a00ad7306ULL, 0x000e620000205400ULL, 0x000000444300720bULL, 0x008fc40003f7d000ULL,
0x000000a19e44723eULL, 0x000fe400000010ffULL, 0x000000a600997245ULL, 0x000fc6000020d400ULL,
0x0000003b005b7306ULL, 0x000fec0000009400ULL, 0x0000000197973812ULL, 0x000fe400078efcffULL,
0x0000003b005a7306ULL, 0x000ea20000005400ULL, 0x000000adaa00720bULL, 0x002fce0003f5d000ULL,
0x0000004500467306ULL, 0x000ff00000209400ULL, 0x0000004500477306ULL, 0x0002e20000205400ULL,
0x0000005a5b00720bULL, 0x004fe40003fdd000ULL, 0x000000585458723cULL, 0x000fea00000418ffULL,
0x0000008300407306ULL, 0x000fe20000209400ULL, 0x0000009b9a45723eULL, 0x002fce00000010ffULL,
0x0000008300417306ULL, 0x000e620000205400ULL, 0x000000474600720bULL, 0x008fe40003f1d000ULL,
0x000000445444723cULL, 0x000f6a00000418ffULL, 0x000000a800ae7306ULL, 0x000fec0000209400ULL,
0x0000000191910812ULL, 0x000fc400078efcffULL, 0x000000a8009d7306ULL, 0x0005e20000205400ULL,
0x000000414000720bULL, 0x002fe40003f7d000ULL, 0x000000004240783bULL, 0x000e6a0000000200ULL,
0x0000003b007b7306ULL, 0x000722000000d400ULL, 0x000000a800a87245ULL, 0x004fce000020d400ULL,
0x0000009f00847306ULL, 0x000fe20000209400ULL, 0x000100003b3b7824ULL, 0x008fca00078e00ffULL,
0x00000018ff867819ULL, 0x000fe2000001143bULL, 0x000100003c3b7824ULL, 0x000fe200078e00ffULL,
0x0000009f00857306ULL, 0x000ea20000205400ULL, 0x000000017b7b6812ULL, 0x010fc600078efcffULL,
0x00000018ff987819ULL, 0x000fc8000001143bULL, 0x0000003c004a7306ULL, 0x000ff00000009400ULL,
0x0000003c004b7306ULL, 0x000ee20000005400ULL, 0x000000858400720bULL, 0x004fe40003fdd000ULL,
0x0000004d9484723eULL, 0x000fe200000010ffULL, 0x0000000740409231ULL, 0x082fe200003400ffULL,
0x0000008300947245ULL, 0x000fe2000020d400ULL, 0x0000000742429231ULL, 0x000fe200003400ffULL,
0x0000004c8f85723eULL, 0x000fe200000010ffULL, 0x0000003c00717306ULL, 0x0002a2000000d400ULL,
0x0000000194943812ULL, 0x000fe200078efcffULL, 0x0000000641419231ULL, 0x000fc400003400ffULL,
0x0000000643439231ULL, 0x000fc800003400ffULL, 0x0000008600877306ULL, 0x000fe20000209400ULL,
0x0000004f923c723eULL, 0x002fe400000010ffULL, 0x0000003a00927245ULL, 0x000fe4000020d400ULL,
0x0000004b4a00720bULL, 0x008fe20003f1d000ULL, 0x000000385438723cULL, 0x000fe200000418ffULL,
0x0000000192922812ULL, 0x000fe200078efcffULL, 0x00000086009c7306ULL, 0x000e620000205400ULL,
0x0000009dae00720bULL, 0x000fe40003f5d000ULL, 0x000000ac8d4f723eULL, 0x000fc400000010ffULL,
0x000000929792723eULL, 0x000fe200000010ffULL, 0x000000485448723cULL, 0x000f6400000418ffULL,
0x0000009800a57306ULL, 0x000fe40000209400ULL, 0x0000000171710812ULL, 0x004fc800078efcffULL,
0x00000001a8a82812ULL, 0x000fe400078efcffULL, 0x0000009800a07306ULL, 0x0005e20000205400ULL,
0x0000009c8700720bULL, 0x002fe40003f5d000ULL, 0x000000a78a87723eULL, 0x000fe400000010ffULL,
0x0000007ba87b723eULL, 0x000fc600000010ffULL, 0x000000a200a37306ULL, 0x000fe20000209400ULL,
0x0000009800987245ULL, 0x004fce000020d400ULL, 0x000000a2009a7306ULL, 0x0002b00000205400ULL,
0x0000008200527306ULL, 0x000fe20000209400ULL, 0x000000a200a27245ULL, 0x002fce000020d400ULL,
0x0000008200537306ULL, 0x000e620000205400ULL, 0x0000009aa300720bULL, 0x004fce0003f1d000ULL,
0x0000003d00517306ULL, 0x000fec0000009400ULL, 0x00000001a2a20812ULL, 0x000fe400078efcffULL,
0x0000003d00507306ULL, 0x000ea20000005400ULL, 0x000000535200720bULL, 0x002fce0003f7d000ULL,
0x0000003d00737306ULL, 0x0003f0000000d400ULL, 0x000000a6009b7306ULL, 0x000fe20000209400ULL,
0x0000004eb13d723eULL, 0x002fe400000010ffULL, 0x000000ba934e723eULL, 0x000fc400000010ffULL,
0x0000008600937245ULL, 0x000fe4000020d400ULL, 0x000000a98886723eULL, 0x000fe200000010ffULL,
0x000000a6009c7306ULL, 0x000e620000205400ULL, 0x0000009f00887245ULL, 0x000fe2000020d400ULL,
0x0000004e544c723cULL, 0x000f6200000418ffULL, 0x0000000193932812ULL, 0x000fe400078efcffULL,
0x0000000188886812ULL, 0x000fe400078efcffULL, 0x000000a0a500720bULL, 0x000fe20003fdd000ULL,
0x0000007f00817306ULL, 0x000fe20000209400ULL, 0x000000505100720bULL, 0x004fc40003f5d000ULL,
0x000000845450723cULL, 0x000be200000418ffULL, 0x000000939493723eULL, 0x000fe400000010ffULL,
0x000000718888723eULL, 0x000fe400000010ffULL, 0x0000007f00807306ULL, 0x000ea40000205400ULL,
0x0000007d9685723eULL, 0x020fe200000010ffULL, 0x000000924044723cULL, 0x000fe20000041844ULL,
0x0000000198986812ULL, 0x000fe400078efcffULL, 0x0000009c9b00720bULL, 0x002fc40003fdd000ULL,
0x0000003e007a7306ULL, 0x000fe20000009400ULL, 0x00000082007d7245ULL, 0x000fe4000020d400ULL,
0x0000000173732812ULL, 0x000fe400078efcffULL, 0x000000017d7d3812ULL, 0x000fe400078efcffULL,
0x0000007ebb84723eULL, 0x000fe200000010ffULL, 0x0000003e00797306ULL, 0x000e620000005400ULL,
0x000000808100720bULL, 0x004fe40003f1d000ULL, 0x0000000199996812ULL, 0x000fc400078efcffULL,
0x000000987d98723eULL, 0x000fc600000010ffULL, 0x0000003e00687306ULL, 0x000eb0000000d400ULL,
0x0000003f006f7306ULL, 0x000fe20000009400ULL, 0x000000797a00720bULL, 0x002fe40003f7d000ULL,
0x0000007c957a723eULL, 0x000fc400000010ffULL, 0x00000018ff797819ULL, 0x000fe40000011489ULL,
0x0000007f007c7245ULL, 0x000fe2000020d400ULL, 0x0000003f00747306ULL, 0x000e620000005400ULL,
0x0000007900b17245ULL, 0x000fe2000020d400ULL, 0x0000007a4058723cULL, 0x000fe20000041858ULL,
0x000000017c7c0812ULL, 0x000fe400078efcffULL, 0x00000073a289723eULL, 0x000fe400000010ffULL,
0x0000000168683812ULL, 0x004fe200078efcffULL, 0x0000003f005e7306ULL, 0x0004e2000000d400ULL,
0x000000997c99723eULL, 0x000fc600000010ffULL, 0x000000884048723cULL, 0x000fe80000041848ULL,
0x000000af008d7306ULL, 0x000fe20000209400ULL, 0x000000746f00720bULL, 0x002fe40003f1d000ULL,
0x0000008c006f7245ULL, 0x000fe2000020d400ULL, 0x0000003c543c723cULL, 0x044f6800000418ffULL,
0x000000af009e7306ULL, 0x0002a80000205400ULL, 0x000000865454723cULL, 0x000b6400000418ffULL,
0x000000015e5e0812ULL, 0x008fc400078efcffULL, 0x0000008c008a7306ULL, 0x000fe20000209400ULL,
0x000000af00af7245ULL, 0x002fe4000020d400ULL, 0x0000008b8e86723eULL, 0x020fe200000010ffULL,
0x00000098404c723cULL, 0x000b62000004184cULL, 0x000000909187723eULL, 0x000fc600000010ffULL,
0x0000008c008b7306ULL, 0x000e620000205400ULL, 0x0000009e8d00720bULL, 0x004fc60003f5d000ULL,
0x00000084403c723cULL, 0x040b68000004183cULL, 0x0000006900757306ULL, 0x000fe80000209400ULL,
0x000000864038723cULL, 0x000b640000041838ULL, 0x00000001afaf2812ULL, 0x000fc400078efcffULL,
0x0000006900767306ULL, 0x000ea20000205400ULL, 0x0000008b8a00720bULL, 0x002fe40003fdd000ULL,
0x00000068af74723eULL, 0x000fca00000010ffULL, 0x000000b000837306ULL, 0x000fec0000209400ULL,
0x000000016f6f6812ULL, 0x000fe400078efcffULL, 0x000000b0007e7306ULL, 0x0002e20000205400ULL,
0x000000767500720bULL, 0x004fe40003f5d000ULL, 0x0000005e6f75723eULL, 0x000fc400000010ffULL,
0x00000069006f7245ULL, 0x000fe4000020d400ULL, 0x00000002ff697819ULL, 0x000fe20000011632ULL,
0x0000006c00777306ULL, 0x000fe20000209400ULL, 0x000000b000b07245ULL, 0x002fe2000020d400ULL,
0x000000744050723cULL, 0x000b620000041850ULL, 0x00000001725e7810ULL, 0x000fe40007ffe0ffULL,
0x0000000869687810ULL, 0x000fe40007ffe0ffULL, 0x000000016f6f2812ULL, 0x000fe200078efcffULL,
0x0000006c00787306ULL, 0x0002a20000205400ULL, 0x0000007e8300720bULL, 0x008fc40003fdd000ULL,
0x000000726900720cULL, 0x000fc80003f46070ULL, 0x0000005e6900720cULL, 0x000fe20005746470ULL,
0x0000007900807306ULL, 0x000fe20000209400ULL, 0x0000006c006c7245ULL, 0x002fca000020d400ULL,
0x00000001b0b06812ULL, 0x000fe400078efcffULL, 0x00000079007b7306ULL, 0x000e620000205400ULL,
0x000000787700720bULL, 0x004fe40003f7d000ULL, 0x0000000e3500720cULL, 0x000fe40003fc3070ULL,
0x000000b06fb0723eULL, 0x000fd200000010ffULL, 0x000000016c6c3812ULL, 0x000fe400078efcffULL,
0x0000007b8000720bULL, 0x002fe40003f1d000ULL, 0x000000726800720cULL, 0x000fc80003f66070ULL,
0x0000005e6800720cULL, 0x000fce0005f66470ULL, 0x00000001b1b10812ULL, 0x000fe400078efcffULL,
0x0000000e3500720cULL, 0x000fe40003f03070ULL, 0x000000b16cb1723eULL, 0x000fce00000010ffULL,
0x000000b04054723cULL, 0x000b620000041854ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x0000003c13137221ULL, 0x020fe20000010000ULL,
0x0000003d14147221ULL, 0x000fe20000010000ULL, 0x0000003817177221ULL, 0x000fe20000010000ULL,
0x0000003918187221ULL, 0x000fe20000010000ULL, 0x000000581b1b7221ULL, 0x000fe20000010000ULL,
0x000000591c1c7221ULL, 0x000fe20000010000ULL, 0x000000441f1f7221ULL, 0x000fe20000010000ULL,
0x0000004520207221ULL, 0x000fe20000010000ULL, 0x0000004823237221ULL, 0x000fe20000010000ULL,
0x0000004924247221ULL, 0x000fe20000010000ULL, 0x0000004c27277221ULL, 0x000fe20000010000ULL,
0x0000004d28287221ULL, 0x000fe20000010000ULL, 0x000000502b2b7221ULL, 0x000fe20000010000ULL,
0x000000512c2c7221ULL, 0x000fe20000010000ULL, 0x000000542f2f7221ULL, 0x000fe20000010000ULL,
0x0000005530307221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000003947ULL, 0x000fea0000000000ULL,
0x0000003e15157221ULL, 0x020fe20000010000ULL, 0x0000003f16167221ULL, 0x000fe20000010000ULL,
0x0000003a19197221ULL, 0x000fe20000010000ULL, 0x0000003b1a1a7221ULL, 0x000fe20000010000ULL,
0x0000005a1d1d7221ULL, 0x000fe20000010000ULL, 0x0000005b1e1e7221ULL, 0x000fe20000010000ULL,
0x0000004621217221ULL, 0x000fe20000010000ULL, 0x0000004722227221ULL, 0x000fe20000010000ULL,
0x0000004a25257221ULL, 0x000fe20000010000ULL, 0x0000004b26267221ULL, 0x000fe20000010000ULL,
0x0000004e29297221ULL, 0x000fe20000010000ULL, 0x0000004f2a2a7221ULL, 0x000fe20000010000ULL,
0x000000522d2d7221ULL, 0x000fe20000010000ULL, 0x000000532e2e7221ULL, 0x000fe20000010000ULL,
0x0000005631317221ULL, 0x000fe20000010000ULL, 0x0000005760607221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8800ff387f8cULL, 0x020e62000c80043fULL, 0x00000002ff3b7819ULL, 0x000fe2000001165eULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x0000000e3500720cULL, 0x000fc40003f03070ULL,
0x0000003b5e3b7207ULL, 0x040fe40002800000ULL, 0x0000000e3500720cULL, 0x080fe40003fc3070ULL,
0x00000001ff8f7803ULL, 0x000fe40000000000ULL, 0x000000033b417812ULL, 0x040fe400078ec0ffULL,
0x0000000e3b427211ULL, 0x000fe400078ff0ffULL, 0x000000035e387812ULL, 0x002fe200078ec0ffULL,
0x000000ffff3f7224ULL, 0x000fc600078e0039ULL, 0x000000ff38407207ULL, 0x000fc40006800000ULL,
0x0000000000387805ULL, 0x000fca0000015200ULL, 0x010b8400ff3a7984ULL, 0x000e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x800000003aff7812ULL, 0x002fe2000780486dULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078110ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8400ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe4000780486dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fc40000015200ULL, 0x010b8c00ff3a7984ULL, 0x000e620000000800ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe60000000000ULL,
0x800000003aff7812ULL, 0x002fe2000780483fULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL, 0x000000013b3b7824ULL, 0x000fe200000e0e39ULL,
0x003d09003d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3a7819ULL, 0x000fc8000001143bULL, 0x0000003d3a3a7211ULL, 0x000fca00078110ffULL,
0x000000ffff3b7224ULL, 0x000fca00000e063bULL, 0x000000023a3a7819ULL, 0x000fc8000000123bULL,
0x0000003a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe4000780483fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000142387810ULL, 0x000fe20007ffe0ffULL,
0x0000097000017945ULL, 0x000fe60003800000ULL, 0x000000373800720cULL, 0x000fda0003f06070ULL,
0x0000051000008947ULL, 0x000fea0003800000ULL, 0x0000000162437824ULL, 0x000fe400078e0205ULL,
0x00000100ff457424ULL, 0x000fe400078e00ffULL, 0x0000004034447824ULL, 0x000fe200078e0243ULL,
0x010a0000433c7984ULL, 0x000e620000004800ULL, 0x00000010323a7824ULL, 0x000fe400078e00ffULL,
0x00000010433d7824ULL, 0x000fc600078e00ffULL, 0x000000f03a477812ULL, 0x000fe200078ec0ffULL,
0x010ac0003c397984ULL, 0x002e640000004800ULL, 0x000000390c397224ULL, 0x002fc800078e0244ULL,
0x00005e0039387625ULL, 0x000fca00078e0045ULL, 0x00000047383a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000442387824ULL, 0x000fc800078e0241ULL, 0x0000004038387824ULL, 0x000fe400078e00ffULL,
0x000000ffff3b7224ULL, 0x000fc600000e0639ULL, 0x0000003861397217ULL, 0x000fca0007800000ULL,
0x0000000139397824ULL, 0x000fe400078e0a38ULL, 0x0000000143387824ULL, 0x000fc600078e0232ULL,
0x0000003962397217ULL, 0x000fe40007800000ULL, 0xfffffff03d387812ULL, 0x000fc600078ee238ULL,
0x00000001393e7824ULL, 0x000fe200078e0a62ULL, 0x0000c00038497811ULL, 0x000fe400078e20ffULL,
0x0000000244387810ULL, 0x000fe40007ffe0ffULL, 0x0000003e0500720cULL, 0x000fda0003f06070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a497faeULL, 0x0003e8000c101c46ULL,
0x010a0800433f7984ULL, 0x000ea80000004800ULL, 0x010ac0003f3f7984ULL, 0x004ea40000004800ULL,
0x0000003f0c387224ULL, 0x004fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fca00078e0045ULL,
0x00000047383c7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff3d7224ULL, 0x000fe200000e0639ULL,
0x0000000205397810ULL, 0x000fc80007ffe0ffULL, 0x0000003e3900720cULL, 0x000fe20003f06070ULL,
0x00000001624b7824ULL, 0x000fc800078e0239ULL, 0x000000014b387824ULL, 0x040fe400078e0232ULL,
0x000000104b4b7824ULL, 0x000fca00078e00ffULL, 0xfffffff04b387812ULL, 0x000fc800078ee238ULL,
0x0000c00038497811ULL, 0x002fe400078e20ffULL, 0x0000000444387810ULL, 0x040fe40007ffe0ffULL,
0x0000000644447810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c497faeULL, 0x0003e8000c101c46ULL, 0x010a1000433f7984ULL, 0x000ea80000004800ULL,
0x010ac0003f3f7984ULL, 0x004ea40000004800ULL, 0x0000003f0c387224ULL, 0x004fe200078e0238ULL,
0x00000006053f7810ULL, 0x000fc60007ffe0ffULL, 0x00005e0038387625ULL, 0x000fca00078e0045ULL,
0x00000047383a7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff3b7224ULL, 0x000fe200000e0639ULL,
0x0000000405397810ULL, 0x000fc80007ffe0ffULL, 0x0000003e3900720cULL, 0x000fe20003f06070ULL,
0x00000001624b7824ULL, 0x000fc800078e0239ULL, 0x000000014b387824ULL, 0x040fe400078e0232ULL,
0x000000104b4b7824ULL, 0x000fca00078e00ffULL, 0xfffffff04b387812ULL, 0x000fc800078ee238ULL,
0x0000c000383d7811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a3d7faeULL, 0x0003e8000c101c46ULL, 0x010a1800433c7984ULL, 0x000ea80000004800ULL,
0x010ac0003c397984ULL, 0x004ea40000004800ULL, 0x000000390c397224ULL, 0x004fc800078e0244ULL,
0x00005e0039387625ULL, 0x000fc800078e0045ULL, 0x0000000162457824ULL, 0x000fe200078e023fULL,
0x0000004738387210ULL, 0x000fc60007f1e0ffULL, 0x0000000145447824ULL, 0x000fe400078e0232ULL,
0x000000ffff397224ULL, 0x000fe200000e0639ULL, 0x0000003e3f00720cULL, 0x000fe20003f06070ULL,
0x0000001045457824ULL, 0x000fca00078e00ffULL, 0xfffffff045447812ULL, 0x000fc800078ee244ULL,
0x0000c000443b7811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e2000c101c46ULL, 0x0000043000007947ULL, 0x000fea0003800000ULL,
0x0000000162437824ULL, 0x000fe400078e0205ULL, 0x00000100ff467424ULL, 0x000fe400078e00ffULL,
0x0000004034447824ULL, 0x000fe200078e0243ULL, 0x010a0000433c7984ULL, 0x000e620000004800ULL,
0x00000010323a7824ULL, 0x000fca00078e00ffULL, 0x000000f03a457812ULL, 0x000fe200078ec0ffULL,
0x010ac0003c397984ULL, 0x002e640000004800ULL, 0x000000390c397224ULL, 0x002fc800078e0244ULL,
0x00005e0039387625ULL, 0x000fca00078e0046ULL, 0x00000045383a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000143387824ULL, 0x000fc800078e0232ULL, 0x000000ffff3b7224ULL, 0x000fe400000e0639ULL,
0x0000001043397824ULL, 0x000fca00078e00ffULL, 0xfffffff039387812ULL, 0x000fc800078ee238ULL,
0x0000c000383f7811ULL, 0x000fe400078e20ffULL, 0x0000000244387810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3f7faeULL, 0x0003e8000b901c46ULL,
0x010a0800433e7984ULL, 0x000ea80000004800ULL, 0x010ac0003e397984ULL, 0x004ea40000004800ULL,
0x000000390c397224ULL, 0x004fc800078e0238ULL, 0x00005e0039387625ULL, 0x000fca00078e0046ULL,
0x00000045383c7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff3d7224ULL, 0x000fe200000e0639ULL,
0x0000000243397810ULL, 0x000fca0007ffe0ffULL, 0x0000000139387824ULL, 0x040fe400078e0232ULL,
0x0000001039397824ULL, 0x000fca00078e00ffULL, 0xfffffff039387812ULL, 0x000fc800078ee238ULL,
0x0000c000383f7811ULL, 0x002fe400078e20ffULL, 0x0000000444387810ULL, 0x040fe40007ffe0ffULL,
0x0000000644447810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c3f7faeULL, 0x0003e8000b901c46ULL, 0x010a1000433e7984ULL, 0x000ea20000004800ULL,
0x00000006433f7810ULL, 0x002fc60007ffe0ffULL, 0x010ac0003e397984ULL, 0x0042a40000004800ULL,
0x000000013f3e7824ULL, 0x042fe400078e0232ULL, 0x000000103f3f7824ULL, 0x000fca00078e00ffULL,
0xfffffff03f3e7812ULL, 0x000fe200078ee23eULL, 0x000000390c397224ULL, 0x004fc800078e0238ULL,
0x00005e0039387625ULL, 0x000fca00078e0046ULL, 0x00000045383a7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff3b7224ULL, 0x000fe200000e0639ULL, 0x0000000443397810ULL, 0x000fca0007ffe0ffULL,
0x0000000139387824ULL, 0x040fe400078e0232ULL, 0x0000001039397824ULL, 0x000fca00078e00ffULL,
0xfffffff039387812ULL, 0x000fc800078ee238ULL, 0x0000c000383d7811ULL, 0x000fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e8000b901c46ULL,
0x010a1800433c7984ULL, 0x000ea20000004800ULL, 0x0000c0003e3b7811ULL, 0x002fc600078e20ffULL,
0x010ac0003c397984ULL, 0x004e640000004800ULL, 0x000000390c397224ULL, 0x002fc800078e0244ULL,
0x00005e0039387625ULL, 0x000fca00078e0046ULL, 0x0000004538387210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff397224ULL, 0x000fca00000e0639ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e6000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8800ff387f8cULL, 0x002e64000c80043fULL,
0x000000ffff3f7224ULL, 0x002fc400078e0039ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x010b8c00ff3a7984ULL, 0x000e620000000800ULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x800000003aff7812ULL, 0x002fe2000780483fULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078110ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe4000780483fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000017000017945ULL, 0x000fe20003800000ULL, 0x0000015000004947ULL, 0x000fea0003800000ULL,
0x000000423500720cULL, 0x000fe40003f04070ULL, 0x00010a000b3b7811ULL, 0x000fe400078e10ffULL,
0x000000ff40387207ULL, 0x000fc40000000000ULL, 0x000000ff40407207ULL, 0x000fc60004000000ULL,
0x0000000141387824ULL, 0x000fc800078e0238ULL, 0x0000004038397824ULL, 0x040fe200078e00ffULL,
0x0000004238387211ULL, 0x000fc800078ff0ffULL, 0x000000c039397812ULL, 0x000fca00078ec0ffULL,
0x0000010038387824ULL, 0x000fe400078e0239ULL, 0x0000000163397824ULL, 0x000fc600078e0240ULL,
0x00000020383a7810ULL, 0x000fca0007ffe0ffULL, 0x0000680039387a24ULL, 0x100fe400078e023aULL,
0x000000010b3a7824ULL, 0x040fe400078e023aULL, 0x00000004ff397424ULL, 0x000fe400078e00ffULL,
0x000000010b387824ULL, 0x000fe200078e0238ULL, 0x000000613a00720cULL, 0x000fc60003f06070ULL,
0x0000660038387625ULL, 0x000fd400078e0039ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e4000c121846ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x010b7800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b7800ff387f8cULL, 0x000e62000c80043fULL, 0x0000013000017945ULL, 0x000fe20003800000ULL,
0x000000ffff717224ULL, 0x002fe200078e0039ULL, 0x0000010000001947ULL, 0x000fea0003800000ULL,
0x00000008ff06723eULL, 0x000fc800000010ffULL, 0x00005410063a7816ULL, 0x000fe20000000006ULL,
0x0001fa727f007947ULL, 0x000fea000b800000ULL, 0x00001f693a077589ULL, 0x0002a400000e0000ULL,
0x0001fab27f007947ULL, 0x000fea000b800000ULL, 0x00001f683a067589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000010693f7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff3e7224ULL, 0x000fe200078e003aULL, 0x0000705000387802ULL, 0x000fc40000000f00ULL,
0x0002086000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000ffff3e7224ULL, 0x004fe200078e003aULL, 0x00000018693f7810ULL, 0x002fe40007ffe0ffULL,
0x000070a000387802ULL, 0x000fc40000000f00ULL, 0x0002081000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000e0006b6b7811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000e0006a6a7811ULL, 0x000fe200078e20ffULL,
0x000000015c5f7824ULL, 0x000fe200078e025fULL, 0x000000046e6f7810ULL, 0x000fe20007ffe0ffULL,
0x000000006b3c783bULL, 0x006e620000004200ULL, 0x000000015c5d7824ULL, 0x000fe200078e025dULL,
0x000000066e6e7810ULL, 0x000fe20007ffe0ffULL, 0x00001ed000017945ULL, 0x000fe20003800000ULL,
0x0000003c00387306ULL, 0x002ff00000009400ULL, 0x0000003c00397306ULL, 0x000e700000005400ULL,
0x0000003c00897306ULL, 0x000ea2000000d400ULL, 0x000000393800720bULL, 0x002fce0003f1d000ULL,
0x0000003d00877306ULL, 0x000ff0000000d400ULL, 0x0000003d00387306ULL, 0x000fe20000009400ULL,
0x0000000189890812ULL, 0x004fce00078efcffULL, 0x0000003d00397306ULL, 0x000e700000005400ULL,
0x0000003e007c7306ULL, 0x000fe2000000d400ULL, 0x000000393800720bULL, 0x002fce0003f1d000ULL,
0x0000003f007a7306ULL, 0x000ff0000000d400ULL, 0x0000003e00387306ULL, 0x000fe20000009400ULL,
0x0000000187870812ULL, 0x000fce00078efcffULL, 0x0000003e00397306ULL, 0x000e640000005400ULL,
0x000000393800720bULL, 0x002fcc0003f1d000ULL, 0x0000003f00387306ULL, 0x000ff00000009400ULL,
0x0000003f00397306ULL, 0x000e620000005400ULL, 0x000000017c7c0812ULL, 0x000fe400078efcffULL,
0x000000393800720bULL, 0x002fc40003f1d000ULL, 0x000000006a38783bULL, 0x008e760000004200ULL,
0x000000017a7a0812ULL, 0x000fe200078efcffULL, 0x0000003800407306ULL, 0x002fe20000009400ULL,
0x00000018ff467819ULL, 0x000fc8000001143aULL, 0x0000004600737245ULL, 0x000fc6000020d400ULL,
0x0000003800417306ULL, 0x000e700000005400ULL, 0x0000003800787306ULL, 0x000ea2000000d400ULL,
0x000000414000720bULL, 0x002fce0003f1d000ULL, 0x0000003900797306ULL, 0x000ff0000000d400ULL,
0x0000003900407306ULL, 0x000fe20000009400ULL, 0x0000000178780812ULL, 0x004fce00078efcffULL,
0x0000003900417306ULL, 0x000e700000005400ULL, 0x0000003a00757306ULL, 0x000fe2000000d400ULL,
0x000000414000720bULL, 0x002fce0003f1d000ULL, 0x0000003a00407306ULL, 0x000ff00000009400ULL,
0x0000003a00417306ULL, 0x000e620000005400ULL, 0x0000000179790812ULL, 0x000fe400078efcffULL,
0x000000414000720bULL, 0x002fc40003f1d000ULL, 0x00000018ff407819ULL, 0x000fc8000001143cULL,
0x0000004000417306ULL, 0x000fe20000209400ULL, 0x0000004000827245ULL, 0x000fcc000020d400ULL,
0x0000000175750812ULL, 0x000fe200078efcffULL, 0x0000004000427306ULL, 0x000e640000205400ULL,
0x000000424100720bULL, 0x002fe40003f1d000ULL, 0x00000018ff417819ULL, 0x000fc8000001143dULL,
0x0000004100427306ULL, 0x000fe20000209400ULL, 0x00000041007d7245ULL, 0x000fcc000020d400ULL,
0x0000000182820812ULL, 0x000fe200078efcffULL, 0x0000004100437306ULL, 0x000e640000205400ULL,
0x000000434200720bULL, 0x002fe40003f1d000ULL, 0x00000018ff427819ULL, 0x000fc8000001143eULL,
0x0000004200407306ULL, 0x000fe20000209400ULL, 0x00000042007b7245ULL, 0x000fcc000020d400ULL,
0x000000017d7d0812ULL, 0x000fe200078efcffULL, 0x0000004200437306ULL, 0x000e640000205400ULL,
0x000000434000720bULL, 0x002fe40003f1d000ULL, 0x00000018ff407819ULL, 0x000fc8000001143fULL,
0x0000004000417306ULL, 0x000fe20000209400ULL, 0x0000004000777245ULL, 0x000fcc000020d400ULL,
0x000000017b7b0812ULL, 0x000fe200078efcffULL, 0x0000004000447306ULL, 0x000e640000205400ULL,
0x000000444100720bULL, 0x002fe40003f1d000ULL, 0x00000018ff417819ULL, 0x000fc80000011438ULL,
0x0000004100427306ULL, 0x000fe20000209400ULL, 0x0000004100767245ULL, 0x000fcc000020d400ULL,
0x0000000177770812ULL, 0x000fe200078efcffULL, 0x0000004100437306ULL, 0x000e700000205400ULL,
0x0000004600417306ULL, 0x000fe20000205400ULL, 0x000000434200720bULL, 0x002fc40003f1d000ULL,
0x00000018ff427819ULL, 0x000fca0000011439ULL, 0x0000004200407306ULL, 0x000fe20000209400ULL,
0x0000004200747245ULL, 0x000fca000020d400ULL, 0x0000000176760812ULL, 0x000fe400078efcffULL,
0x0000004200437306ULL, 0x000e640000205400ULL, 0x000000434000720bULL, 0x002fcc0003f1d000ULL,
0x0000004600407306ULL, 0x000e6e0000209400ULL, 0x0000000174740812ULL, 0x000fe400078efcffULL,
0x000000414000720bULL, 0x002fe20003f1d000ULL, 0x000000105c407824ULL, 0x000fc400078e00ffULL,
0x000000105c5c7824ULL, 0x000fc600078e00ffULL, 0xfffffff0405f7812ULL, 0x000fe400078ee25fULL,
0xfffffff05c5d7812ULL, 0x000fe400078ee25dULL, 0x0000e0005f6d7811ULL, 0x000fe400078e20ffULL,
0x0000e0005d6c7811ULL, 0x000fe400078e20ffULL, 0x0000000173730812ULL, 0x000fe200078efcffULL,
0x000000006d40783bULL, 0x000e640000004200ULL, 0x0000004000447306ULL, 0x002ff00000009400ULL,
0x0000004000457306ULL, 0x000e700000005400ULL, 0x00000040004a7306ULL, 0x000ea2000000d400ULL,
0x000000454400720bULL, 0x002fce0003f1d000ULL, 0x00000041004b7306ULL, 0x000ff0000000d400ULL,
0x0000004100447306ULL, 0x000fe20000009400ULL, 0x000000014a4a0812ULL, 0x004fce00078efcffULL,
0x0000004100457306ULL, 0x000e700000005400ULL, 0x0000004200487306ULL, 0x000fe2000000d400ULL,
0x000000454400720bULL, 0x002fce0003f1d000ULL, 0x0000004300497306ULL, 0x000ff0000000d400ULL,
0x0000004200447306ULL, 0x000fe20000009400ULL, 0x000000014b4b0812ULL, 0x000fce00078efcffULL,
0x0000004200457306ULL, 0x000e640000005400ULL, 0x000000454400720bULL, 0x002fcc0003f1d000ULL,
0x0000004300447306ULL, 0x000ff00000009400ULL, 0x0000004300457306ULL, 0x000e620000005400ULL,
0x0000000148480812ULL, 0x000fe400078efcffULL, 0x000000454400720bULL, 0x002fc40003f1d000ULL,
0x000000006c44783bULL, 0x000e760000004200ULL, 0x0000000149490812ULL, 0x000fe200078efcffULL,
0x00000044004c7306ULL, 0x002ff00000009400ULL, 0x00000044004d7306ULL, 0x000e700000005400ULL,
0x0000004400507306ULL, 0x000ea2000000d400ULL, 0x0000004d4c00720bULL, 0x002fce0003f1d000ULL,
0x0000004500517306ULL, 0x000ff0000000d400ULL, 0x00000045004c7306ULL, 0x000fe20000009400ULL,
0x0000000150500812ULL, 0x004fce00078efcffULL, 0x00000045004d7306ULL, 0x000e700000005400ULL,
0x0000004600587306ULL, 0x000fe2000000d400ULL, 0x0000004d4c00720bULL, 0x002fce0003f1d000ULL,
0x0000004700597306ULL, 0x000ff0000000d400ULL, 0x00000046004c7306ULL, 0x000fe20000009400ULL,
0x0000000151510812ULL, 0x000fce00078efcffULL, 0x00000046004d7306ULL, 0x000e640000005400ULL,
0x0000004d4c00720bULL, 0x002fcc0003f1d000ULL, 0x00000047004c7306ULL, 0x000ff00000009400ULL,
0x00000047004d7306ULL, 0x000e620000005400ULL, 0x0000000158580812ULL, 0x000fe400078efcffULL,
0x0000004d4c00720bULL, 0x002fe20003f1d000ULL, 0x000001003c4c7824ULL, 0x000fc400078e00ffULL,
0x000100003c3c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe4000001144cULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000004c004d7306ULL, 0x000fe20000209400ULL,
0x0000004c008c7245ULL, 0x000fe4000020d400ULL, 0x0000000159590812ULL, 0x000fe400078efcffULL,
0x0000003c008d7245ULL, 0x000fc6000020d400ULL, 0x0000004c004e7306ULL, 0x0002a40000205400ULL,
0x000001003d4c7824ULL, 0x042fe400078e00ffULL, 0x000100003d3d7824ULL, 0x000fc600078e00ffULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x0000004e4d00720bULL, 0x004fe40003f1d000ULL,
0x0000003c004d7306ULL, 0x000fe20000209400ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000004c008e7245ULL, 0x000fe4000020d400ULL, 0x0000003d008a7245ULL, 0x000fc6000020d400ULL,
0x0000003c004e7306ULL, 0x000e660000205400ULL, 0x000000018c8c0812ULL, 0x000fca00078efcffULL,
0x0000003d003c7306ULL, 0x000fe20000209400ULL, 0x0000004e4d00720bULL, 0x002fce0003f1d000ULL,
0x0000004c004d7306ULL, 0x000ff00000209400ULL, 0x0000004c004e7306ULL, 0x000e620000205400ULL,
0x000000018d8d0812ULL, 0x000fe400078efcffULL, 0x0000004e4d00720bULL, 0x002fca0003f1d000ULL,
0x0000003d004d7306ULL, 0x000e700000205400ULL, 0x000000018e8e0812ULL, 0x000fe400078efcffULL,
0x0000004d3c00720bULL, 0x002fe20003f1d000ULL, 0x000001003e3c7824ULL, 0x000fc400078e00ffULL,
0x000100003e3e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x0000003c004c7306ULL, 0x000fe20000209400ULL,
0x0000003c008b7245ULL, 0x000fe4000020d400ULL, 0x000000018a8a0812ULL, 0x000fe400078efcffULL,
0x0000003e00887245ULL, 0x000fc6000020d400ULL, 0x0000003c004d7306ULL, 0x0002b00000205400ULL,
0x0000003e003d7306ULL, 0x000fe20000209400ULL, 0x000001003f3c7824ULL, 0x042fe400078e00ffULL,
0x000100003f3f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000004d4c00720bULL, 0x004fe40003f1d000ULL, 0x0000003e004c7306ULL, 0x000e620000205400ULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x0000003c00857245ULL, 0x000fe4000020d400ULL,
0x0000003f00847245ULL, 0x000fc6000020d400ULL, 0x0000003f003e7306ULL, 0x000fe60000205400ULL,
0x000000018b8b0812ULL, 0x000fc800078efcffULL, 0x0000007c8b7c723eULL, 0x000fe400000010ffULL,
0x0000004c3d00720bULL, 0x002fe40003f1d000ULL, 0x0000003c003d7306ULL, 0x000ff00000209400ULL,
0x0000003c004c7306ULL, 0x0002a60000205400ULL, 0x0000000188880812ULL, 0x000fc800078efcffULL,
0x000000887b88723eULL, 0x000fe200000010ffULL, 0x00000100383c7824ULL, 0x042fe400078e00ffULL,
0x0001000038387824ULL, 0x000fc600078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000004c3d00720bULL, 0x004fe40003f1d000ULL, 0x0000003f003d7306ULL, 0x000e620000209400ULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000003c00837245ULL, 0x000fe4000020d400ULL,
0x0000003800817245ULL, 0x000fe4000020d400ULL, 0x00000018ff4c7819ULL, 0x000fc80000011447ULL,
0x0000000185850812ULL, 0x000fe400078efcffULL, 0x0000003e3d00720bULL, 0x002fe40003f1d000ULL,
0x0000003c003d7306ULL, 0x000ff00000209400ULL, 0x0000003c003e7306ULL, 0x0002a60000205400ULL,
0x0000000184840812ULL, 0x000fe200078efcffULL, 0x00000100393c7824ULL, 0x002fc400078e00ffULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000003e3d00720bULL, 0x004fe40003f1d000ULL, 0x00000038003d7306ULL, 0x000fe20000209400ULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000003c00867245ULL, 0x000fe4000020d400ULL,
0x00000039007f7245ULL, 0x000fc6000020d400ULL, 0x00000038003e7306ULL, 0x000e660000205400ULL,
0x0000000183830812ULL, 0x000fc800078efcffULL, 0x000000788378723eULL, 0x000fe200000010ffULL,
0x0000003900387306ULL, 0x000fe20000209400ULL, 0x0000003e3d00720bULL, 0x002fce0003f1d000ULL,
0x0000003c003d7306ULL, 0x000ff00000209400ULL, 0x0000003c003e7306ULL, 0x000e620000205400ULL,
0x0000000181810812ULL, 0x000fc800078efcffULL, 0x000000817676723eULL, 0x000fe400000010ffULL,
0x0000003e3d00720bULL, 0x002fe40003f1d000ULL, 0x00000039003d7306ULL, 0x000e760000205400ULL,
0x0000000186860812ULL, 0x000fc800078efcffULL, 0x000000798679723eULL, 0x000fe400000010ffULL,
0x0000003d3800720bULL, 0x002fe20003f1d000ULL, 0x000001003a387824ULL, 0x040fe400078e00ffULL,
0x000100003a3a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x00000018ff397819ULL, 0x000fe4000001143aULL, 0x00000038003c7306ULL, 0x000fe20000209400ULL,
0x00000038007e7245ULL, 0x000fe4000020d400ULL, 0x000000017f7f0812ULL, 0x000fe400078efcffULL,
0x00000039003a7245ULL, 0x000fc6000020d400ULL, 0x00000038003d7306ULL, 0x0002a40000205400ULL,
0x000001003b387824ULL, 0x002fe200078e00ffULL, 0x0000003d3c00720bULL, 0x004fca0003f1d000ULL,
0x00000039003c7306ULL, 0x000ff00000209400ULL, 0x00000039003d7306ULL, 0x000e620000205400ULL,
0x000000017e7e0812ULL, 0x000fc800078efcffULL, 0x000000757e7e723eULL, 0x000fe400000010ffULL,
0x0000003d3c00720bULL, 0x002fe40003f1d000ULL, 0x00000018ff3d7819ULL, 0x000fc80000011438ULL,
0x0000003d00387306ULL, 0x000fe20000209400ULL, 0x0000003d00807245ULL, 0x000fcc000020d400ULL,
0x000000013a3a0812ULL, 0x000fe200078efcffULL, 0x0000003d003f7306ULL, 0x000e660000205400ULL,
0x0000003a733a723eULL, 0x000fe400000010ffULL, 0x0000003f3800720bULL, 0x002fe40003f1d000ULL,
0x00000018ff387819ULL, 0x000fe20000011440ULL, 0x0000004c003f7306ULL, 0x000fe60000205400ULL,
0x00000038004f7245ULL, 0x000fca000020d400ULL, 0x0000003800397306ULL, 0x000fe40000209400ULL,
0x0000000180800812ULL, 0x000fcc00078efcffULL, 0x00000038003c7306ULL, 0x000e640000205400ULL,
0x0000003c3900720bULL, 0x002fe40003f1d000ULL, 0x00000018ff397819ULL, 0x000fc80000011441ULL,
0x00000039003c7306ULL, 0x000fe20000209400ULL, 0x0000003900537245ULL, 0x000fcc000020d400ULL,
0x000000014f4f0812ULL, 0x000fe200078efcffULL, 0x00000039003d7306ULL, 0x000e640000205400ULL,
0x0000003d3c00720bULL, 0x002fe40003f1d000ULL, 0x00000018ff3c7819ULL, 0x000fc80000011442ULL,
0x0000003c00387306ULL, 0x000fe20000209400ULL, 0x0000003c005b7245ULL, 0x000fcc000020d400ULL,
0x0000000153530812ULL, 0x000fe200078efcffULL, 0x0000003c003d7306ULL, 0x000e640000205400ULL,
0x0000003d3800720bULL, 0x002fe40003f1d000ULL, 0x00000018ff387819ULL, 0x000fc80000011443ULL,
0x0000003800397306ULL, 0x000fe20000209400ULL, 0x00000038004d7245ULL, 0x000fcc000020d400ULL,
0x000000015b5b0812ULL, 0x000fe200078efcffULL, 0x00000038003e7306ULL, 0x000e640000205400ULL,
0x0000003e3900720bULL, 0x002fe40003f1d000ULL, 0x00000018ff397819ULL, 0x000fc80000011444ULL,
0x00000039003c7306ULL, 0x000fe20000209400ULL, 0x0000003900547245ULL, 0x000fcc000020d400ULL,
0x000000014d4d0812ULL, 0x000fe200078efcffULL, 0x00000039003d7306ULL, 0x000e640000205400ULL,
0x0000003d3c00720bULL, 0x002fe40003f1d000ULL, 0x00000018ff3c7819ULL, 0x000fc80000011445ULL,
0x0000003c00387306ULL, 0x000fe20000209400ULL, 0x0000003c00557245ULL, 0x000fcc000020d400ULL,
0x0000000154540812ULL, 0x000fe200078efcffULL, 0x0000003c003d7306ULL, 0x000e700000205400ULL,
0x0000004c003c7306ULL, 0x000fe20000209400ULL, 0x0000003d3800720bULL, 0x002fc40003f1d000ULL,
0x00000018ff3d7819ULL, 0x000fca0000011446ULL, 0x0000003d00397306ULL, 0x000fe20000209400ULL,
0x0000003d00387245ULL, 0x000fca000020d400ULL, 0x0000000155550812ULL, 0x000fe400078efcffULL,
0x0000003d003e7306ULL, 0x000e640000205400ULL, 0x0000003e3900720bULL, 0x002fe40003f1d000ULL,
0x0000004c00397245ULL, 0x000fd6000020d400ULL, 0x0000000138380812ULL, 0x000fe400078efcffULL,
0x0000003f3c00720bULL, 0x000fe20003f1d000ULL, 0x00000100403c7824ULL, 0x040fe400078e00ffULL,
0x0001000040407824ULL, 0x000fc600078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x00000018ff407819ULL, 0x000fe40000011440ULL, 0x0000003c003d7306ULL, 0x000fe20000209400ULL,
0x0000003c003f7245ULL, 0x000fe4000020d400ULL, 0x0000000139390812ULL, 0x000fe400078efcffULL,
0x00000040004c7245ULL, 0x000fc6000020d400ULL, 0x0000003c003e7306ULL, 0x0002a40000205400ULL,
0x00000100413c7824ULL, 0x042fe400078e00ffULL, 0x0001000041417824ULL, 0x000fc600078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000003e3d00720bULL, 0x004fe40003f1d000ULL,
0x00000040003d7306ULL, 0x000fe20000209400ULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x0000003c004e7245ULL, 0x000fe4000020d400ULL, 0x0000004100527245ULL, 0x000fc6000020d400ULL,
0x00000040003e7306ULL, 0x0002a60000205400ULL, 0x000000013f3f0812ULL, 0x000fc800078efcffULL,
0x0000004a3f40723eULL, 0x002fe400000010ffULL, 0x0000003e3d00720bULL, 0x004fe40003f1d000ULL,
0x0000003c003d7306ULL, 0x000ff00000209400ULL, 0x0000003c003e7306ULL, 0x0002a60000205400ULL,
0x000000014c4c0812ULL, 0x000fe200078efcffULL, 0x00000100423c7824ULL, 0x002fc400078e00ffULL,
0x0001000042427824ULL, 0x000fc600078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000003e3d00720bULL, 0x004fe40003f1d000ULL, 0x00000041003d7306ULL, 0x000fe20000209400ULL,
0x00000018ff427819ULL, 0x000fe40000011442ULL, 0x0000003c00577245ULL, 0x000fe4000020d400ULL,
0x0000004200567245ULL, 0x000fc6000020d400ULL, 0x00000041003e7306ULL, 0x0002a60000205400ULL,
0x000000014e4e0812ULL, 0x000fc800078efcffULL, 0x0000004b4e41723eULL, 0x002fe400000010ffULL,
0x0000003e3d00720bULL, 0x004fe40003f1d000ULL, 0x0000003c003d7306ULL, 0x000ff00000209400ULL,
0x0000003c003e7306ULL, 0x0002a60000205400ULL, 0x0000000152520812ULL, 0x000fe200078efcffULL,
0x00000100433c7824ULL, 0x002fc400078e00ffULL, 0x0001000043437824ULL, 0x000fc600078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000003e3d00720bULL, 0x004fe40003f1d000ULL,
0x00000042003d7306ULL, 0x000fe20000209400ULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0x0000003c005a7245ULL, 0x000fe4000020d400ULL, 0x0000004300907245ULL, 0x000fc6000020d400ULL,
0x00000042003e7306ULL, 0x000e660000205400ULL, 0x0000000157570812ULL, 0x000fc800078efcffULL,
0x000000485748723eULL, 0x000fe400000010ffULL, 0x0000003e3d00720bULL, 0x002fe40003f1d000ULL,
0x0000003c003d7306ULL, 0x000ff00000209400ULL, 0x0000003c003e7306ULL, 0x0002a60000205400ULL,
0x0000000156560812ULL, 0x000fe200078efcffULL, 0x00000100443c7824ULL, 0x002fc400078e00ffULL,
0x0001000044447824ULL, 0x000fc600078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000003e3d00720bULL, 0x004fe40003f1d000ULL, 0x00000043003d7306ULL, 0x000fe20000209400ULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x0000003c00917245ULL, 0x000fe4000020d400ULL,
0x0000004400937245ULL, 0x000fc6000020d400ULL, 0x00000043003e7306ULL, 0x000e660000205400ULL,
0x000000015a5a0812ULL, 0x000fc800078efcffULL, 0x000000495a49723eULL, 0x000fe400000010ffULL,
0x0000003e3d00720bULL, 0x002fe40003f1d000ULL, 0x0000003c003d7306ULL, 0x000ff00000209400ULL,
0x0000003c003e7306ULL, 0x0002a60000205400ULL, 0x0000000190900812ULL, 0x000fc800078efcffULL,
0x000000904d4d723eULL, 0x000fe200000010ffULL, 0x000100003b907824ULL, 0x000fe400078e00ffULL,
0x00000100453c7824ULL, 0x042fe400078e00ffULL, 0x0001000045457824ULL, 0x000fc600078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000003e3d00720bULL, 0x004fe40003f1d000ULL,
0x00000044003d7306ULL, 0x000fe20000209400ULL, 0x00000018ff457819ULL, 0x000fe40000011445ULL,
0x0000003c00927245ULL, 0x000fe4000020d400ULL, 0x0000004500947245ULL, 0x000fc6000020d400ULL,
0x00000044003e7306ULL, 0x0002a60000205400ULL, 0x0000000191910812ULL, 0x000fc800078efcffULL,
0x000000509150723eULL, 0x000fe400000010ffULL, 0x0000004c4f44723eULL, 0x002fe400000010ffULL,
0x000000565b4c723eULL, 0x000fe400000010ffULL, 0x000000878e91723eULL, 0x000fe400000010ffULL,
0x0000003e3d00720bULL, 0x004fe40003f1d000ULL, 0x0000003c003d7306ULL, 0x000ff00000209400ULL,
0x0000003c003e7306ULL, 0x0002a60000205400ULL, 0x0000000193930812ULL, 0x000fc800078efcffULL,
0x000000935454723eULL, 0x000fe200000010ffULL, 0x00000100463c7824ULL, 0x042fe200078e00ffULL,
0x0000003b00937306ULL, 0x000fe20000005400ULL, 0x0001000046467824ULL, 0x000fc600078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000003e3d00720bULL, 0x004fe40003f1d000ULL,
0x00000045003d7306ULL, 0x000fe20000209400ULL, 0x00000018ff467819ULL, 0x000fe40000011446ULL,
0x0000003c00957245ULL, 0x000fe4000020d400ULL, 0x0000004600977245ULL, 0x000fc6000020d400ULL,
0x00000045003e7306ULL, 0x0002a60000205400ULL, 0x0000000192920812ULL, 0x000fc800078efcffULL,
0x000000519251723eULL, 0x000fe400000010ffULL, 0x000000525345723eULL, 0x002fe400000010ffULL,
0x00000018ff927819ULL, 0x000fe40000011490ULL, 0x000000898c90723eULL, 0x000fe400000010ffULL,
0x0000009200877306ULL, 0x000fe20000209400ULL, 0x0000003e3d00720bULL, 0x004fe40003f1d000ULL,
0x000000847789723eULL, 0x000fc400000010ffULL, 0x0000007f7477723eULL, 0x000fc600000010ffULL,
0x0000003c003d7306ULL, 0x000fec0000209400ULL, 0x0000000194940812ULL, 0x000fe400078efcffULL,
0x0000003c003e7306ULL, 0x0002a40000205400ULL, 0x000000945555723eULL, 0x000fcc00000010ffULL,
0x00000092008c7306ULL, 0x000fe20000205400ULL, 0x00000100473c7824ULL, 0x042fe400078e00ffULL,
0x0001000047477824ULL, 0x000fc600078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000003e3d00720bULL, 0x004fe40003f1d000ULL, 0x00000046003d7306ULL, 0x000fe20000209400ULL,
0x0000003c00967245ULL, 0x000fe4000020d400ULL, 0x00000018ff477819ULL, 0x000fc80000011447ULL,
0x0000004700987245ULL, 0x000fe2000020d400ULL, 0x00000046003e7306ULL, 0x000e660000205400ULL,
0x0000000195950812ULL, 0x000fc800078efcffULL, 0x000000589558723eULL, 0x000fe400000010ffULL,
0x0000003b00957306ULL, 0x000fe2000000d400ULL, 0x0000003e3d00720bULL, 0x002fce0003f1d000ULL,
0x0000003c003d7306ULL, 0x000ff00000209400ULL, 0x0000003c003e7306ULL, 0x0002a20000205400ULL,
0x0000000197970812ULL, 0x000fc800078efcffULL, 0x000000973838723eULL, 0x000fe200000010ffULL,
0x00000008703c7824ULL, 0x002fca00078e00ffULL, 0xfffffff83c6f7812ULL, 0x000fe400078ee26fULL,
0x0000003e3d00720bULL, 0x004fe40003f1d000ULL, 0x00000047003d7306ULL, 0x000fe20000209400ULL,
0x0000a0006f3c7811ULL, 0x000fca00078e20ffULL, 0x000000003c5c783bULL, 0x0002a40000000200ULL,
0x00000047003e7306ULL, 0x000ee60000205400ULL, 0x0000000196960812ULL, 0x000fc800078efcffULL,
0x000000599659723eULL, 0x000fe400000010ffULL, 0x0000003e3d00720bULL, 0x008fe20003f1d000ULL,
0x00000008703d7824ULL, 0x000fe400078e00ffULL, 0x0000003b00707306ULL, 0x000ee60000009400ULL,
0xfffffff83d6e7812ULL, 0x000fc800078ee26eULL, 0x0000a0006e3c7811ULL, 0x002fc600078e20ffULL,
0x0000000198980812ULL, 0x000fc600078efcffULL, 0x000000003c3c783bULL, 0x000e620000000200ULL,
0x000000983939723eULL, 0x000fe400000010ffULL, 0x000000937000720bULL, 0x008fe40003f1d000ULL,
0x00000018ff707819ULL, 0x000fe2000001143bULL, 0x000000075c5c9231ULL, 0x084fe200003400ffULL,
0x00000092003b7245ULL, 0x000fe2000020d400ULL, 0x000000075e5e9231ULL, 0x000fe400003400ffULL,
0x000000065d5d9231ULL, 0x000fc400003400ffULL, 0x000000065f5f9231ULL, 0x000fc800003400ffULL,
0x0000000195950812ULL, 0x000fe400078efcffULL, 0x0000008c8700720bULL, 0x000fe20003f1d000ULL,
0x000000445c44723cULL, 0x000fe200000418ffULL, 0x00000095807f723eULL, 0x000fce00000010ffULL,
0x000000405c40723cULL, 0x000f6800000418ffULL, 0x000000013b3b0812ULL, 0x000fc800078efcffULL,
0x000000485c48723cULL, 0x000f6200000418ffULL, 0x000000073c3c9231ULL, 0x082fe400003400ffULL,
0x000000073e3e9231ULL, 0x000fca00003400ffULL, 0x0000004c5c4c723cULL, 0x000f6200000418ffULL,
0x000000063d3d9231ULL, 0x080fe400003400ffULL, 0x000000063f3f9231ULL, 0x000fe200003400ffULL,
0x000000ff8f00720cULL, 0x000fc80003f25270ULL, 0x000000505c50723cULL, 0x040f7000000418ffULL,
0x000000545c54723cULL, 0x040f7000000418ffULL, 0x000000585c58723cULL, 0x040f7000000418ffULL,
0x000000385c5c723cULL, 0x000b6e00000418ffULL, 0x0000008d8238723eULL, 0x020fe200000010ffULL,
0x000000903c40723cULL, 0x000f620000041840ULL, 0x0000008a7d39723eULL, 0x000fe200000010ffULL,
0x0000007000827306ULL, 0x000fe20000209400ULL, 0x0000007a857d723eULL, 0x000fca00000010ffULL,
0x000000383c44723cULL, 0x040b640000041844ULL, 0x0000007000397306ULL, 0x0202ac0000205400ULL,
0x0000007c3c48723cULL, 0x000b620000041848ULL, 0x0000007000707245ULL, 0x002fce000020d400ULL,
0x000000883c4c723cULL, 0x000b62000004184cULL, 0x000000398200720bULL, 0x004fce0003f1d000ULL,
0x000000783c50723cULL, 0x040b6c0000041850ULL, 0x0000000170700812ULL, 0x000fe400078efcffULL,
0x000000763c54723cULL, 0x000b640000041854ULL, 0x0000003b703b723eULL, 0x000fcc00000010ffULL,
0x0000007e3c58723cULL, 0x040b700000041858ULL, 0x0000003a3c5c723cULL, 0x000b62000004185cULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0000800000ULL,
0x0000004013137221ULL, 0x000fe20000010000ULL, 0x0000004114147221ULL, 0x000fe20000010000ULL,
0x0000004417177221ULL, 0x000fe20000010000ULL, 0x0000004518187221ULL, 0x000fe20000010000ULL,
0x000000481b1b7221ULL, 0x020fe20000010000ULL, 0x000000491c1c7221ULL, 0x000fe20000010000ULL,
0x0000004c1f1f7221ULL, 0x000fe20000010000ULL, 0x0000004d20207221ULL, 0x000fe20000010000ULL,
0x0000005023237221ULL, 0x000fe20000010000ULL, 0x0000005124247221ULL, 0x000fe20000010000ULL,
0x0000005427277221ULL, 0x000fe20000010000ULL, 0x0000005528287221ULL, 0x000fe20000010000ULL,
0x000000582b2b7221ULL, 0x000fe20000010000ULL, 0x000000592c2c7221ULL, 0x000fe20000010000ULL,
0x0000005c2f2f7221ULL, 0x000fe20000010000ULL, 0x0000005d30307221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000003947ULL, 0x000fea0003000000ULL, 0x0000004215157221ULL, 0x000fe20000010000ULL,
0x0000004316167221ULL, 0x000fe20000010000ULL, 0x0000004619197221ULL, 0x000fe20000010000ULL,
0x000000471a1a7221ULL, 0x000fe20000010000ULL, 0x0000004a1d1d7221ULL, 0x020fe20000010000ULL,
0x0000004b1e1e7221ULL, 0x000fe20000010000ULL, 0x0000004e21217221ULL, 0x000fe20000010000ULL,
0x0000004f22227221ULL, 0x000fe20000010000ULL, 0x0000005225257221ULL, 0x000fe20000010000ULL,
0x0000005326267221ULL, 0x000fe20000010000ULL, 0x0000005629297221ULL, 0x000fe20000010000ULL,
0x000000572a2a7221ULL, 0x000fe20000010000ULL, 0x0000005a2d2d7221ULL, 0x000fe20000010000ULL,
0x0000005b2e2e7221ULL, 0x000fe20000010000ULL, 0x0000005e31317221ULL, 0x000fe20000010000ULL,
0x0000005f60607221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000172727810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8800ff387f8cULL, 0x000e62000c80043fULL, 0x00000004ff707424ULL, 0x000fca00078e00ffULL,
0x0000000170707807ULL, 0x000fc80006800000ULL, 0x000000707200720cULL, 0x000fe20003f06070ULL,
0x000000ffff3e7224ULL, 0x022fd800078e0039ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffff898000007947ULL, 0x000fea000383ffffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000400e387811ULL, 0x000fe200078e40ffULL, 0x010b5800ffff7f8cULL, 0x000fe6000c80043fULL,
0x000000613800720cULL, 0x000fda0003f06070ULL, 0x00015a5000000947ULL, 0x000fea0003800000ULL,
0x000000ffff727224ULL, 0x000fca00078e00ffULL, 0x00000002ff397819ULL, 0x000fe20000011672ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000000372387812ULL, 0x040fe200078ec0ffULL,
0x000000ffff407224ULL, 0x000fe200078e00ffULL, 0x0000003972397207ULL, 0x000fe40002800000ULL,
0x000000ff38427207ULL, 0x000fe40006800000ULL, 0x00000001393b7810ULL, 0x000fc80007ffe0ffULL,
0x000000033b397812ULL, 0x040fe400078ec0ffULL, 0x0000000e3b387211ULL, 0x000fc400078ff0ffULL,
0x00000000003a7805ULL, 0x000fca0000015200ULL, 0x010b7c00ff3c7984ULL, 0x000e640000000800ULL,
0x800000003cff7812ULL, 0x002fe40007804871ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000017945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003c7805ULL, 0x000fcc0000015200ULL, 0x0000003c3a3f7210ULL, 0x000fca0007f1e1ffULL,
0x000000013d3d7824ULL, 0x000fe200000e0e3bULL, 0x003d09003f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3c7819ULL, 0x000fc8000001143dULL,
0x0000003f3c3c7211ULL, 0x000fca00078110ffULL, 0x000000ffff3d7224ULL, 0x000fca00000e063dULL,
0x000000023c3c7819ULL, 0x000fc8000000123dULL, 0x0000003c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000140407810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b7c00ff3c7984ULL, 0x000e640000000800ULL,
0x800000003cff7812ULL, 0x002fe40007804871ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fc40000015200ULL, 0x010b8c00ff3d7984ULL, 0x000e640000000800ULL,
0x800000003dff7812ULL, 0x002fe4000780483eULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff407224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003c7805ULL, 0x000fcc0000015200ULL,
0x0000003c3a3f7210ULL, 0x000fca0007f1e1ffULL, 0x000000013d3d7824ULL, 0x000fe200000e0e3bULL,
0x003d09003f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3c7819ULL, 0x000fc8000001143dULL, 0x0000003f3c3c7211ULL, 0x000fca00078110ffULL,
0x000000ffff3d7224ULL, 0x000fca00000e063dULL, 0x000000023c3c7819ULL, 0x000fc8000000123dULL,
0x0000003c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000140407810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8c00ff3d7984ULL, 0x000e640000000800ULL, 0x800000003dff7812ULL, 0x002fe4000780483eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000001383a7810ULL, 0x000fe20007ffe0ffULL,
0x0000099000017945ULL, 0x000fe60003800000ULL, 0x000000373a00720cULL, 0x000fda0003f06070ULL,
0x0000052000008947ULL, 0x000fea0003800000ULL, 0x0000000162417824ULL, 0x000fe200078e0205ULL,
0x0000002034407811ULL, 0x000fe200078e30ffULL, 0x00000004383a7824ULL, 0x000fe200078e0239ULL,
0x0000000205497810ULL, 0x000fe20007ffe0ffULL, 0x00000010323e7824ULL, 0x000fe200078e00ffULL,
0x010a0000413c7984ULL, 0x000e620000004800ULL, 0x00000100ff437424ULL, 0x000fe200078e00ffULL,
0x000000203a3a7811ULL, 0x000fe200078e30ffULL, 0x0000001041447824ULL, 0x000fe200078e00ffULL,
0x000000f03e457812ULL, 0x000fe200078ec0ffULL, 0x00000001624b7824ULL, 0x000fe200078e0249ULL,
0x0000003a613b7217ULL, 0x000fca0007800000ULL, 0x000000013b3b7824ULL, 0x000fe400078e0a3aULL,
0x00000001413a7824ULL, 0x000fc600078e0240ULL, 0x0000003b623b7217ULL, 0x000fca0007800000ULL,
0x000000013b3e7824ULL, 0x000fca00078e0a62ULL, 0x0000003e0500720cULL, 0x000fe20003f06070ULL,
0x010ac0003c3d7984ULL, 0x002e640000004800ULL, 0x0000003d0c3a7224ULL, 0x002fe400078e023aULL,
0x00000001413d7824ULL, 0x000fe400078e0232ULL, 0x00005e003a3a7625ULL, 0x000fca00078e0043ULL,
0x000000453a3c7210ULL, 0x000fe40007f3e0ffULL, 0xfffffff0443a7812ULL, 0x000fe200078ee23dULL,
0x000000014b447824ULL, 0x040fe400078e0232ULL, 0x000000ffff3d7224ULL, 0x000fe200008e063bULL,
0x0000e0003a477811ULL, 0x000fe200078e20ffULL, 0x000000014b3a7824ULL, 0x040fe400078e0240ULL,
0x000000104b4b7824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c477faeULL, 0x0003e2000c101c46ULL, 0x0000003e4900720cULL, 0x000fc40003f06070ULL,
0xfffffff04b447812ULL, 0x000fe200078ee244ULL, 0x010a0800413f7984ULL, 0x000ea20000004800ULL,
0x0000000405497810ULL, 0x000fca0007ffe0ffULL, 0x00000001624b7824ULL, 0x000fe200078e0249ULL,
0x0000e00044477811ULL, 0x002fc600078e20ffULL, 0x000000014b447824ULL, 0x000fe200078e0232ULL,
0x010ac0003f3f7984ULL, 0x004e640000004800ULL, 0x0000003f0c3a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0043ULL, 0x000000453a3c7210ULL, 0x000fe20007f3e0ffULL,
0x000000014b3a7824ULL, 0x040fe400078e0240ULL, 0x000000104b4b7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fc600008e063bULL, 0xfffffff04b447812ULL, 0x000fe400078ee244ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c477faeULL, 0x0003e2000c101c46ULL,
0x0000003e4900720cULL, 0x000fe40003f06070ULL, 0x0000000605497810ULL, 0x000fe20007ffe0ffULL,
0x010a1000413f7984ULL, 0x000ea80000004800ULL, 0x00000001624b7824ULL, 0x000fe200078e0249ULL,
0x0000e00044477811ULL, 0x002fe200078e20ffULL, 0x010ac0003f3f7984ULL, 0x004e640000004800ULL,
0x0000003f0c3a7224ULL, 0x002fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0043ULL,
0x000000453a3c7210ULL, 0x000fe20007f3e0ffULL, 0x000000014b3a7824ULL, 0x040fe400078e0240ULL,
0x000000014b407824ULL, 0x040fe400078e0232ULL, 0x000000ffff3d7224ULL, 0x000fe400008e063bULL,
0x000000104b4b7824ULL, 0x000fc600078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c477faeULL, 0x0003e2000c101c46ULL, 0x0000003e4900720cULL, 0x000fe40003f06070ULL,
0xfffffff04b407812ULL, 0x000fe200078ee240ULL, 0x010a1800413f7984ULL, 0x000ea60000004800ULL,
0x0000e000403d7811ULL, 0x002fe200078e20ffULL, 0x010ac0003f3f7984ULL, 0x004e640000004800ULL,
0x0000003f0c3a7224ULL, 0x002fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0043ULL,
0x000000453a3a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fca00008e063bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e2000c101c46ULL,
0x0000044000007947ULL, 0x000fea0003800000ULL, 0x0000000162437824ULL, 0x000fe200078e0205ULL,
0x0000002034447811ULL, 0x000fe200078e30ffULL, 0x00000010323c7824ULL, 0x000fe400078e00ffULL,
0x00000100ff457424ULL, 0x000fe200078e00ffULL, 0x010a0000433e7984ULL, 0x000e620000004800ULL,
0x00000001433a7824ULL, 0x040fe200078e0244ULL, 0x000000f03c477812ULL, 0x000fe200078ec0ffULL,
0x00000001433d7824ULL, 0x040fe200078e0232ULL, 0x00000002433f7810ULL, 0x040fe20007ffe0ffULL,
0x0000001043407824ULL, 0x000fc800078e00ffULL, 0x000000013f467824ULL, 0x000fe200078e0232ULL,
0x010ac0003e3b7984ULL, 0x002e640000004800ULL, 0x0000003b0c3b7224ULL, 0x002fc800078e023aULL,
0x00005e003b3a7625ULL, 0x000fca00078e0045ULL, 0x000000473a3c7210ULL, 0x000fe40007f1e0ffULL,
0xfffffff0403a7812ULL, 0x000fc600078ee23dULL, 0x000000ffff3d7224ULL, 0x000fe200000e063bULL,
0x0000e0003a417811ULL, 0x000fe200078e20ffULL, 0x00000001443a7824ULL, 0x000fe400078e023fULL,
0x000000103f3f7824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c417faeULL, 0x0003e6000b901c46ULL, 0xfffffff03f467812ULL, 0x000fe200078ee246ULL,
0x010a080043407984ULL, 0x000ea60000004800ULL, 0x0000e00046417811ULL, 0x002fc400078e20ffULL,
0x00000004433d7810ULL, 0x000fca0007ffe0ffULL, 0x000000013d467824ULL, 0x000fe200078e0232ULL,
0x010ac000403b7984ULL, 0x004e640000004800ULL, 0x0000003b0c3a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0045ULL, 0x000000473a3e7210ULL, 0x000fe20007f1e0ffULL,
0x00000001443a7824ULL, 0x000fe400078e023dULL, 0x000000103d3d7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3f7224ULL, 0x000fc600000e063bULL, 0xfffffff03d467812ULL, 0x000fe400078ee246ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e417faeULL, 0x0003e8000b901c46ULL,
0x010a100043407984ULL, 0x000ea20000004800ULL, 0x0000e000463f7811ULL, 0x002fe400078e20ffULL,
0x0000000643417810ULL, 0x000fe20007ffe0ffULL, 0x010ac000403b7984ULL, 0x0042a80000004800ULL,
0x0000000141407824ULL, 0x002fc400078e0232ULL, 0x0000003b0c3a7224ULL, 0x004fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0045ULL, 0x000000473a3c7210ULL, 0x000fe20007f1e0ffULL,
0x00000001443a7824ULL, 0x000fe400078e0241ULL, 0x0000001041417824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fc600000e063bULL, 0xfffffff041407812ULL, 0x000fe400078ee240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c3f7faeULL, 0x0003e8000b901c46ULL,
0x010a1800433e7984ULL, 0x000ea20000004800ULL, 0x0000e000403d7811ULL, 0x002fc600078e20ffULL,
0x010ac0003e3b7984ULL, 0x004e640000004800ULL, 0x0000003b0c3a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0045ULL, 0x000000473a3a7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff3b7224ULL, 0x000fca00000e063bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a3d7faeULL, 0x0003e6000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8800ff3a7f8cULL, 0x002e64000c80043fULL,
0x000000ffff417224ULL, 0x002fc400078e003bULL, 0x00000000003a7805ULL, 0x000fca0000015200ULL,
0x010b8c00ff3c7984ULL, 0x000e640000000800ULL, 0x800000003cff7812ULL, 0x002fe40007804841ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff3e7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003c7805ULL, 0x000fcc0000015200ULL, 0x0000003c3a3f7210ULL, 0x000fca0007f1e1ffULL,
0x000000013d3d7824ULL, 0x000fe200000e0e3bULL, 0x003d09003f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3c7819ULL, 0x000fc8000001143dULL,
0x0000003f3c3c7211ULL, 0x000fca00078110ffULL, 0x000000ffff3d7224ULL, 0x000fca00000e063dULL,
0x000000023c3c7819ULL, 0x000fc8000000123dULL, 0x0000003c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8c00ff3c7984ULL, 0x000e640000000800ULL,
0x800000003cff7812ULL, 0x002fe40007804841ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000383500720cULL, 0x000fe20003f04070ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x000000034200780cULL, 0x000fda0003f25270ULL, 0x000000f000008947ULL, 0x000fea0000800000ULL,
0x000000030b00780cULL, 0x000fe40003f04070ULL, 0x000000010d0d7810ULL, 0x000fd60007ffe0ffULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x00000004363a7824ULL, 0x000fe200078e020bULL,
0x000064000d3b7a10ULL, 0x040fe20007ffe0ffULL, 0x00000004ff3d7424ULL, 0x000fe200078e00ffULL,
0x000000640d00720cULL, 0x000fe20003f06070ULL, 0x000000023a3a7824ULL, 0x000fe200078e00ffULL,
0x00010ac00b3f7811ULL, 0x000fc600078e10ffULL, 0x000064003a3a7a24ULL, 0x000fc800078e023bULL,
0x000060003a3a7625ULL, 0x000fca00078e003dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a3f7faeULL, 0x0003e4000c121846ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000018000017945ULL, 0x000fe20003800000ULL, 0x0000016000004947ULL, 0x000fea0003800000ULL,
0x000000383500720cULL, 0x000fe40003f04070ULL, 0x00000001423a7810ULL, 0x002fc80007ffe0ffULL,
0x000000033a3b7812ULL, 0x000fce00078ec0ffULL, 0x00000002ff3a8819ULL, 0x000fca000001163aULL,
0x0000000139397824ULL, 0x000fc800078e023aULL, 0x00000040393a7824ULL, 0x040fe200078e00ffULL,
0x0000003839387211ULL, 0x000fc800078ff0ffULL, 0x000000c03a397812ULL, 0x000fe400078ec0ffULL,
0x000000ff3b3a7207ULL, 0x000fe40004000000ULL, 0x00010a000b3b7811ULL, 0x000fe200078e10ffULL,
0x0000010038397824ULL, 0x000fe400078e0239ULL, 0x0000000163387824ULL, 0x000fe400078e023aULL,
0x000000010b3a7824ULL, 0x100fe400078e0239ULL, 0x0000680038387a24ULL, 0x000fc400078e0239ULL,
0x00000004ff397424ULL, 0x000fe200078e00ffULL, 0x000000613a00720cULL, 0x000fe20003f06070ULL,
0x000000010b387824ULL, 0x000fc800078e0238ULL, 0x0000660038387625ULL, 0x000fd000078e0039ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000383b7faeULL, 0x0003e4000c121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x010b8000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000ff7200720cULL, 0x000fe20003f05270ULL,
0x010b8000ff5c7f8cULL, 0x000e62000c80043fULL, 0x000007d000017945ULL, 0x000ff60003800000ULL,
0x000007b000000947ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010af80062387f8cULL, 0x000ea4000c80043fULL, 0x000000ffff3c7224ULL, 0x004fc400078e0039ULL,
0x0000000000387805ULL, 0x000fca0000015200ULL, 0x010afc0062097984ULL, 0x000ea40000000800ULL,
0x8000000009ff7812ULL, 0x004fc4000780483cULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000027945ULL, 0x000fe20003800000ULL, 0x000000ffff3d7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103d00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000037945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383a7210ULL, 0x000fca0007f1e1ffULL, 0x000000013b3b7824ULL, 0x000fe200000e0e39ULL,
0x003d09003a00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403a00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff097819ULL, 0x000fc8000001143bULL, 0x0000003a09097211ULL, 0x000fca00078110ffULL,
0x000000ffff3a7224ULL, 0x000fca00000e063bULL, 0x0000000209097819ULL, 0x000fc8000000123aULL,
0x000000090000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000037941ULL, 0x000fea0003800000ULL,
0x010afc0062097984ULL, 0x000ea40000000800ULL, 0x8000000009ff7812ULL, 0x004fe4000780483cULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000001032097824ULL, 0x000fe200078e00ffULL,
0x00000001ff387819ULL, 0x000fc80000011632ULL, 0x0000007009097812ULL, 0x000fe400078ec0ffULL,
0x0000000c38387812ULL, 0x000fca00078ec0ffULL, 0x00000001093f7824ULL, 0x000fca00078e0238ULL,
0x010080003f3a7984ULL, 0x000ea80000000800ULL, 0x010280003f3b7984ULL, 0x0006620000000800ULL,
0x0000000f3a00720bULL, 0x004fe20003f1d000ULL, 0x0001c0627f007947ULL, 0x000fd8000b800000ULL,
0x0000000000097806ULL, 0x008fc800000e0100ULL, 0x0000ffff09407812ULL, 0x000fe2000780c0ffULL,
0x0000043000027945ULL, 0x000fe20003800000ULL, 0x00000001ff097424ULL, 0x000fe400078e00ffULL,
0x000000ffff3c7224ULL, 0x000fd200078e000fULL, 0x000003f000008947ULL, 0x000fea0003800000ULL,
0x000000016500780cULL, 0x000fe40003f05270ULL, 0x0000000f3a00720bULL, 0x000fe20003f34000ULL,
0x0001c0227f007947ULL, 0x000fd8000b800000ULL, 0x00000000003d7806ULL, 0x000fc400008e0100ULL,
0x0000003a0f3c7209ULL, 0x000fe20007810000ULL, 0x0000033000037945ULL, 0x000fe20003800000ULL,
0x000099103d387816ULL, 0x000fc600000000ffULL, 0x0104803c3f008388ULL, 0x0005e20000000800ULL,
0x000000ff3800720cULL, 0x000fda0003f05270ULL, 0x000002e000008947ULL, 0x000fea0003800000ULL,
0x8000003c0f0f7221ULL, 0x004fe20000010000ULL, 0x000000ff3dff7812ULL, 0x000fe2000780c0ffULL,
0x0000017000047945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b0f0f7820ULL, 0x000fc80000410000ULL,
0x0000000f00417308ULL, 0x000ea40000000800ULL, 0x0000004112127220ULL, 0x004fc80000410000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x0001bf727f007947ULL, 0x000fea000b800000ULL,
0x00001f69410f7589ULL, 0x0004e400000e0000ULL, 0x0000000f13137220ULL, 0x088fe20000410000ULL,
0x0000000f14147220ULL, 0x080fe20000410000ULL, 0x0000000f17177220ULL, 0x080fe20000410000ULL,
0x0000000f18187220ULL, 0x080fe20000410000ULL, 0x0000000f1b1b7220ULL, 0x080fe20000410000ULL,
0x0000000f1c1c7220ULL, 0x080fe20000410000ULL, 0x0000000f1f1f7220ULL, 0x080fe20000410000ULL,
0x0000000f20207220ULL, 0x080fe20000410000ULL, 0x0000000f23237220ULL, 0x080fe20000410000ULL,
0x0000000f24247220ULL, 0x080fe20000410000ULL, 0x0000000f27277220ULL, 0x080fe20000410000ULL,
0x0000000f28287220ULL, 0x080fe20000410000ULL, 0x0000000f2b2b7220ULL, 0x080fe20000410000ULL,
0x0000000f2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000f2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000f30307220ULL, 0x000fc40000410000ULL, 0x0000000000047941ULL, 0x000fea0003800000ULL,
0x0000ff003dff7812ULL, 0x000fda000780c0ffULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x0001be827f007947ULL, 0x000fea000b800000ULL, 0x00001f68410f7589ULL, 0x0006a400000e0000ULL,
0x0000000f15157220ULL, 0x084fe20000410000ULL, 0x0000000f16167220ULL, 0x080fe20000410000ULL,
0x0000000f19197220ULL, 0x080fe20000410000ULL, 0x0000000f1a1a7220ULL, 0x080fe20000410000ULL,
0x0000000f1d1d7220ULL, 0x080fe20000410000ULL, 0x0000000f1e1e7220ULL, 0x080fe20000410000ULL,
0x0000000f21217220ULL, 0x080fe20000410000ULL, 0x0000000f22227220ULL, 0x080fe20000410000ULL,
0x0000000f25257220ULL, 0x080fe20000410000ULL, 0x0000000f26267220ULL, 0x080fe20000410000ULL,
0x0000000f29297220ULL, 0x080fe20000410000ULL, 0x0000000f2a2a7220ULL, 0x080fe20000410000ULL,
0x0000000f2d2d7220ULL, 0x080fe20000410000ULL, 0x0000000f2e2e7220ULL, 0x080fe20000410000ULL,
0x0000000f31317220ULL, 0x080fe20000410000ULL, 0x0000000f60607220ULL, 0x000fc40000410000ULL,
0x0000000000037941ULL, 0x004fea0003800000ULL, 0x0000ffff40ff7812ULL, 0x000fda000780603dULL,
0x8000003c3a3a0221ULL, 0x000fe20000010000ULL, 0x00007610ff090816ULL, 0x000fc60000000009ULL,
0x3fb8aa3b3a3a0820ULL, 0x000fc80000410000ULL, 0x0000003a00080308ULL, 0x000ea40000000800ULL,
0x000000083b3b0220ULL, 0x006fcc0000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x000000123b127221ULL, 0x002fe20000010000ULL, 0x000000ffff0f7224ULL, 0x000fc400078e003cULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ff09ff7812ULL, 0x000fe2000786c0ffULL,
0x0000012000017945ULL, 0x000fd80003800000ULL, 0x0000010000003947ULL, 0x000fea0003800000ULL,
0x00000008ff06723eULL, 0x000fc800000010ffULL, 0x00005410063a7816ULL, 0x000fe20000000006ULL,
0x0001bcc27f007947ULL, 0x000fea000b800000ULL, 0x00001f693a077589ULL, 0x0004e400000e0000ULL,
0x0001bd027f007947ULL, 0x000fea000b800000ULL, 0x00001f683a067589ULL, 0x0004e400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000010693f7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff3e7224ULL, 0x000fe200078e003aULL, 0x0000b01000387802ULL, 0x000fc40000000f00ULL,
0x0001c8a000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000ffff3e7224ULL, 0x004fe200078e003aULL, 0x00000018693f7810ULL, 0x002fe40007ffe0ffULL,
0x0000b06000387802ULL, 0x000fc40000000f00ULL, 0x0001c85000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000000440783bULL, 0x008ee20000004200ULL, 0x00001e9000017945ULL, 0x000fe60003800000ULL,
0x000000000244783bULL, 0x000f280000004200ULL, 0x000000000038783bULL, 0x004ea80000004200ULL,
0x00000000033c783bULL, 0x002e620000004200ULL, 0x0000010040ae7824ULL, 0x008fe200078e00ffULL,
0x0000004000b47306ULL, 0x000fe20000009400ULL, 0x00000018ffd07819ULL, 0x000fe20000011440ULL,
0x0000010042cf7824ULL, 0x040fe200078e00ffULL, 0x00000018ffbd7819ULL, 0x000fe20000011441ULL,
0x0001000042ca7824ULL, 0x000fe200078e00ffULL, 0x00000018ffb87819ULL, 0x000fe200000114aeULL,
0x0001000040ae7824ULL, 0x000fe200078e00ffULL, 0x00000018ffcf7819ULL, 0x000fe200000114cfULL,
0x0000004000b77306ULL, 0x000ee20000005400ULL, 0x0000010043c87824ULL, 0x040fe200078e00ffULL,
0x00000018ffca7819ULL, 0x000fe200000114caULL, 0x0001000043c37824ULL, 0x000fe200078e00ffULL,
0x00000018ffbe7819ULL, 0x000fe200000114aeULL, 0x0000010041ae7824ULL, 0x040fe200078e00ffULL,
0x00000018ffc87819ULL, 0x000fe200000114c8ULL, 0x0000010044c17824ULL, 0x050fe200078e00ffULL,
0x0000004000977306ULL, 0x000f22000000d400ULL, 0x00000018ffac7819ULL, 0x000fe20000011442ULL,
0x0001000044b67824ULL, 0x000fe200078e00ffULL, 0x00000018ffd57819ULL, 0x000fe200000114aeULL,
0x0001000041ae7824ULL, 0x000fe200078e00ffULL, 0x00000018ff8b7819ULL, 0x000fe20000011443ULL,
0x0000010045b17824ULL, 0x000fe200078e00ffULL, 0x00000018ff9d7819ULL, 0x000fe20000011446ULL,
0x000000b800b97306ULL, 0x000fe20000209400ULL, 0x000000b7b400720bULL, 0x008fc40003f1d000ULL,
0x00000018ffd77819ULL, 0x000fe200000114aeULL, 0x0001000045ae7824ULL, 0x000fe200078e00ffULL,
0x00000018ff547819ULL, 0x000fe40000011447ULL, 0x000000d000b47245ULL, 0x000fe2000020d400ULL,
0x000000b800407306ULL, 0x000ee20000205400ULL, 0x00000018ffc37819ULL, 0x000fe400000114c3ULL,
0x00000018ffc17819ULL, 0x000fe400000114c1ULL, 0x00000018ffb67819ULL, 0x000fc400000114b6ULL,
0x0000000197970812ULL, 0x010fe200078efcffULL, 0x000000be00bc7306ULL, 0x000fe20000209400ULL,
0x00000018ff8d7819ULL, 0x000fe40000011444ULL, 0x00000018ffb17819ULL, 0x000fe400000114b1ULL,
0x00000018ffae7819ULL, 0x000fe400000114aeULL, 0x00000018ffa37819ULL, 0x000fe20000011445ULL,
0x000000be00cb7306ULL, 0x000f220000205400ULL, 0x00000040b900720bULL, 0x008fe20003f3d000ULL,
0x0001000047b97824ULL, 0x000fe200078e00ffULL, 0x000000b800407245ULL, 0x000fc4000020d400ULL,
0x000000d500b87245ULL, 0x000fe4000020d400ULL, 0x00000018ff827819ULL, 0x004fe20000011438ULL,
0x0000004100d37306ULL, 0x000fe20000009400ULL, 0x00000018ffb97819ULL, 0x000fe400000114b9ULL,
0x00000018ff987819ULL, 0x002fe4000001143cULL, 0x00000018ff5b7819ULL, 0x000fe4000001143dULL,
0x0000000140401812ULL, 0x000fe200078efcffULL, 0x0000004100d47306ULL, 0x000e620000005400ULL,
0x000000cbbc00720bULL, 0x010fc40003f5d000ULL, 0x00000018ff4c7819ULL, 0x000fe4000001143eULL,
0x00000018ff5c7819ULL, 0x000fe4000001143aULL, 0x00000018ff4e7819ULL, 0x000fe2000001143fULL,
0x00000041008f7306ULL, 0x000ea2000000d400ULL, 0x00000018ff7b7819ULL, 0x000fe40000011439ULL,
0x00000018ff5e7819ULL, 0x000fca000001143bULL, 0x000000d500d67306ULL, 0x000fe20000209400ULL,
0x000000d4d300720bULL, 0x002fce0003f1d000ULL, 0x000000d500417306ULL, 0x000e6c0000205400ULL,
0x000000018f8f0812ULL, 0x004fe400078efcffULL, 0x000000d000d17306ULL, 0x000ff00000209400ULL,
0x000000d000d27306ULL, 0x000ea20000205400ULL, 0x00000041d600720bULL, 0x002fc40003f3d000ULL,
0x000000be00417245ULL, 0x000fc8000020d400ULL, 0x0000000141412812ULL, 0x000fe200078efcffULL,
0x000000d700d87306ULL, 0x000fec0000209400ULL, 0x00000001b8b81812ULL, 0x000fe400078efcffULL,
0x000000d700d97306ULL, 0x000e620000205400ULL, 0x000000d2d100720bULL, 0x004fce0003fdd000ULL,
0x000000cf00da7306ULL, 0x000fec0000209400ULL, 0x00000001b4b46812ULL, 0x000fe400078efcffULL,
0x000000cf00db7306ULL, 0x000ea20000205400ULL, 0x000000d9d800720bULL, 0x002fce0003f5d000ULL,
0x0000004200ba7306ULL, 0x000ff00000009400ULL, 0x0000004200bb7306ULL, 0x000e620000005400ULL,
0x000000dbda00720bULL, 0x004fce0003f3d000ULL, 0x000000bd00bf7306ULL, 0x000ff00000209400ULL,
0x000000bd00c07306ULL, 0x0004e20000205400ULL, 0x000000bbba00720bULL, 0x002fe40003f1d000ULL,
0x000000cf00bb7245ULL, 0x000fc4000020d400ULL, 0x000000bd00ba7245ULL, 0x000fe4000020d400ULL,
0x00000001bbbb1812ULL, 0x000fe200078efcffULL, 0x000000ca00dc7306ULL, 0x000fe20000209400ULL,
0x000000ca00bd7245ULL, 0x004fce000020d400ULL, 0x000000ca00dd7306ULL, 0x000fe20000205400ULL,
0x000000c0bf00720bULL, 0x008fe40003fdd000ULL, 0x000000ac00c07245ULL, 0x000fca000020d400ULL,
0x0000004200587306ULL, 0x0002ac000000d400ULL, 0x00000001baba6812ULL, 0x000fe400078efcffULL,
0x0000004300af7306ULL, 0x000fe20000009400ULL, 0x0001000046427824ULL, 0x002fca00078e00ffULL,
0x00000018ff427819ULL, 0x000fe40000011442ULL, 0x00000043008e7306ULL, 0x000e620000005400ULL,
0x0000000158580812ULL, 0x004fc800078efcffULL, 0x00000058bb58723eULL, 0x000fc600000010ffULL,
0x0000004300597306ULL, 0x0004f0000000d400ULL, 0x000000c800ce7306ULL, 0x000fe20000209400ULL,
0x0000010046437824ULL, 0x004fe200078e00ffULL, 0x0000008eaf00720bULL, 0x002fc80003f1d000ULL,
0x00000018ff437819ULL, 0x000fe40000011443ULL, 0x000000c800df7306ULL, 0x000e6e0000205400ULL,
0x0000000159590812ULL, 0x008fe200078efcffULL, 0x0000004600a47306ULL, 0x000ff00000009400ULL,
0x0000004600a57306ULL, 0x000fe20000005400ULL, 0x000000dfce00720bULL, 0x002fce0003f3d000ULL,
0x0000004600817306ULL, 0x0003f0000000d400ULL, 0x00000047009f7306ULL, 0x000fe20000009400ULL,
0x0000010047467824ULL, 0x002fca00078e00ffULL, 0x00000018ff467819ULL, 0x000fe40000011446ULL,
0x0000004700a07306ULL, 0x000ff00000005400ULL, 0x0000004700807306ULL, 0x0003f0000000d400ULL,
0x000000ac00857306ULL, 0x000fe20000209400ULL, 0x0000010038477824ULL, 0x002fca00078e00ffULL,
0x00000018ffbf7819ULL, 0x000fe40000011447ULL, 0x000000ac00887306ULL, 0x0002a20000205400ULL,
0x000000d700477245ULL, 0x000fc8000020d400ULL, 0x0000000147472812ULL, 0x000fe400078efcffULL,
0x000000dddc00720bULL, 0x000fe20003f5d000ULL, 0x000000c300cc7306ULL, 0x000fe20000209400ULL,
0x000000c800ac7245ULL, 0x002fc8000020d400ULL, 0x00000001acac1812ULL, 0x000fc600078efcffULL,
0x000000c300cd7306ULL, 0x000e620000205400ULL, 0x000000888500720bULL, 0x004fe40003fdd000ULL,
0x00000059ac59723eULL, 0x000fe400000010ffULL, 0x00000001bdbd2812ULL, 0x000fc600078efcffULL,
0x0000008b00ad7306ULL, 0x000fec0000209400ULL, 0x00000001c0c06812ULL, 0x000fe400078efcffULL,
0x0000008b008a7306ULL, 0x000ea20000205400ULL, 0x000000cdcc00720bULL, 0x002fce0003f5d000ULL,
0x000000c100c67306ULL, 0x000ff00000209400ULL, 0x000000c100c97306ULL, 0x000e620000205400ULL,
0x0000008aad00720bULL, 0x004fe40003f3d000ULL, 0x0000008b00ad7245ULL, 0x000fc4000020d400ULL,
0x000000c1008b7245ULL, 0x000fc6000020d400ULL, 0x0000004400aa7306ULL, 0x000fec0000009400ULL,
0x00000001adad1812ULL, 0x000fe400078efcffULL, 0x0000004400897306ULL, 0x000ea20000005400ULL,
0x000000c9c600720bULL, 0x002fce0003f1d000ULL, 0x000000b600c47306ULL, 0x000fec0000209400ULL,
0x000000018b8b0812ULL, 0x000fe400078efcffULL, 0x000000b600c57306ULL, 0x000e620000205400ULL,
0x00000089aa00720bULL, 0x004fe40003fdd000ULL, 0x000000c300aa7245ULL, 0x000fc8000020d400ULL,
0x00000001aaaa2812ULL, 0x000fe200078efcffULL, 0x00000045008c7306ULL, 0x000ff00000009400ULL,
0x0000004500a97306ULL, 0x000ea20000005400ULL, 0x000000c5c400720bULL, 0x002fce0003f5d000ULL,
0x0000008d00a87306ULL, 0x000ff00000209400ULL, 0x0000008d00ab7306ULL, 0x0002e20000205400ULL,
0x000000a98c00720bULL, 0x004fe40003f3d000ULL, 0x000000b6008c7245ULL, 0x000fc8000020d400ULL,
0x000000018c8c2812ULL, 0x000fe200078efcffULL, 0x0000004400847306ULL, 0x000ea2000000d400ULL,
0x0000008d008d7245ULL, 0x002fce000020d400ULL, 0x000000b100c27306ULL, 0x000fe20000209400ULL,
0x000000aba800720bULL, 0x008fe20003f1d000ULL, 0x000100003ca87824ULL, 0x000fca00078e00ffULL,
0x00000018ffa97819ULL, 0x000fe200000114a8ULL, 0x000000b100c77306ULL, 0x000e620000205400ULL,
0x0000000184846812ULL, 0x004fe400078efcffULL, 0x000000b100a87245ULL, 0x000fe4000020d400ULL,
0x000000848b84723eULL, 0x000fe400000010ffULL, 0x000000018d8d0812ULL, 0x000fe200078efcffULL,
0x000000ae00b57306ULL, 0x000fe20000209400ULL, 0x000000a5a400720bULL, 0x000fe20003f1d000ULL,
0x000001003da47824ULL, 0x000fca00078e00ffULL, 0x00000018ffa57819ULL, 0x000fe200000114a4ULL,
0x000000ae00b27306ULL, 0x0004e20000205400ULL, 0x000000c7c200720bULL, 0x002fe40003fdd000ULL,
0x0000004300a47245ULL, 0x000fc6000020d400ULL, 0x0000000181810812ULL, 0x000fe400078efcffULL,
0x0000004500837306ULL, 0x000e62000000d400ULL, 0x000000ae00ae7245ULL, 0x004fca000020d400ULL,
0x00000001a8a86812ULL, 0x000fe400078efcffULL, 0x0000004300b07306ULL, 0x000fe20000209400ULL,
0x000000b2b500720bULL, 0x008fce0003f5d000ULL, 0x0000004300b37306ULL, 0x000ea20000205400ULL,
0x0000000183831812ULL, 0x002fca00078efcffULL, 0x00000001aeae2812ULL, 0x000fe400078efcffULL,
0x000000a300a67306ULL, 0x000ff00000209400ULL, 0x000000a300a77306ULL, 0x0002e20000205400ULL,
0x000000b3b000720bULL, 0x004fe20003f3d000ULL, 0x000100003ab07824ULL, 0x000fca00078e00ffULL,
0x00000018ffb07819ULL, 0x000fe200000114b0ULL, 0x0000004200447306ULL, 0x000fe20000209400ULL,
0x000000a300a37245ULL, 0x002fca000020d400ULL, 0x00000001a4a41812ULL, 0x000fe400078efcffULL,
0x0000004200457306ULL, 0x000e620000205400ULL, 0x000000a7a600720bULL, 0x008fce0003fdd000ULL,
0x0000009d00a17306ULL, 0x000fec0000209400ULL, 0x00000001a3a36812ULL, 0x000fe400078efcffULL,
0x0000009d00a27306ULL, 0x0004e20000205400ULL, 0x000000454400720bULL, 0x002fe40003f5d000ULL,
0x000000a09f00720bULL, 0x000fc40003fdd000ULL, 0x00000042009f7245ULL, 0x000fe4000020d400ULL,
0x0000009d00a07245ULL, 0x000fe2000020d400ULL, 0x0000003800917306ULL, 0x000fe20000009400ULL,
0x00000046009d7245ULL, 0x004fca000020d400ULL, 0x000000019f9f2812ULL, 0x000fe400078efcffULL,
0x0000003800967306ULL, 0x000fe20000005400ULL, 0x000000a2a100720bULL, 0x008fe40003f3d000ULL,
0x0000000180806812ULL, 0x000fe400078efcffULL, 0x000000bf00a27245ULL, 0x000fc6000020d400ULL,
0x0000003800777306ULL, 0x0003ec000000d400ULL, 0x00000001a0a01812ULL, 0x000fe400078efcffULL,
0x0000004600b77306ULL, 0x000fe20000209400ULL, 0x0001000038387824ULL, 0x002fe200078e00ffULL,
0x0000009fa0a0723eULL, 0x000fc800000010ffULL, 0x00000018ff887819ULL, 0x000fe20000011438ULL,
0x0000010039387824ULL, 0x000fe200078e00ffULL, 0x0000004600bc7306ULL, 0x0002a80000205400ULL,
0x00000018ff897819ULL, 0x000fe20000011438ULL, 0x000001003c387824ULL, 0x000fc600078e00ffULL,
0x000000b900be7306ULL, 0x000fe20000209400ULL, 0x000001003e467824ULL, 0x002fe200078e00ffULL,
0x00000018ff387819ULL, 0x000fc80000011438ULL, 0x00000018ffa17819ULL, 0x000fe40000011446ULL,
0x000000b900cb7306ULL, 0x0002e20000205400ULL, 0x000000bcb700720bULL, 0x004fe40003f1d000ULL,
0x000000a500467245ULL, 0x000fca000020d400ULL, 0x0000005400577306ULL, 0x000fe20000209400ULL,
0x000000b900b97245ULL, 0x002fca000020d400ULL, 0x000000019d9d0812ULL, 0x000fe400078efcffULL,
0x00000054009e7306ULL, 0x000e620000205400ULL, 0x000000cbbe00720bULL, 0x008fe40003f5d000ULL,
0x000000809d9d723eULL, 0x000fca00000010ffULL, 0x000000bf00d07306ULL, 0x000fec0000209400ULL,
0x00000001b9b92812ULL, 0x000fe400078efcffULL, 0x000000bf00cf7306ULL, 0x000ea20000205400ULL,
0x0000009e5700720bULL, 0x002fe40003f3d000ULL, 0x00000054009e7245ULL, 0x000fca000020d400ULL,
0x0000003c00557306ULL, 0x000fec0000009400ULL, 0x000000019e9e1812ULL, 0x000fe400078efcffULL,
0x0000003c00567306ULL, 0x000e620000005400ULL, 0x000000cfd000720bULL, 0x004fce0003f1d000ULL,
0x0000003c00487306ULL, 0x000eac000000d400ULL, 0x00000001a2a20812ULL, 0x000fe400078efcffULL,
0x0000003800af7306ULL, 0x000fe20000209400ULL, 0x000000565500720bULL, 0x002fe40003fdd000ULL,
0x0000a80067557811ULL, 0x000fca00078e20ffULL, 0x00000038003c7306ULL, 0x000e620000205400ULL,
0x000000005554783bULL, 0x000eea0000000200ULL, 0x0000000148486812ULL, 0x004fe400078efcffULL,
0x000000a900ab7306ULL, 0x000ff00000209400ULL, 0x000000a900a67306ULL, 0x0005220000205400ULL,
0x0000003caf00720bULL, 0x002fe20003f5d000ULL, 0x000001003aaf7824ULL, 0x000fca00078e00ffULL,
0x00000018ffaf7819ULL, 0x000fe200000114afULL, 0x0000003d009b7306ULL, 0x000fe20000009400ULL,
0x000000a900a97245ULL, 0x004fce000020d400ULL, 0x0000003d009a7306ULL, 0x000e620000005400ULL,
0x000000a6ab00720bULL, 0x010fe20003f3d000ULL, 0x0001000039ab7824ULL, 0x000fca00078e00ffULL,
0x00000018ffab7819ULL, 0x000fe200000114abULL, 0x0000003d00497306ULL, 0x000522000000d400ULL,
0x000000075454b231ULL, 0x088fe400003400ffULL, 0x000000075656b231ULL, 0x000fe400003400ffULL,
0x000000065555b231ULL, 0x080fe200003400ffULL, 0x00000001a9a91812ULL, 0x000fe200078efcffULL,
0x000000065757b231ULL, 0x000fe200003400ffULL, 0x00000098009c7306ULL, 0x000fe20000209400ULL,
0x000100003d3d7824ULL, 0x004fe200078e00ffULL, 0x0000009a9b00720bULL, 0x002fc40003f1d000ULL,
0x00000038009b7245ULL, 0x000fe2000020d400ULL, 0x000001003f387824ULL, 0x000fe200078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000009800997306ULL, 0x0002a20000205400ULL,
0x000000019b9b2812ULL, 0x000fe400078efcffULL, 0x00000098009a7245ULL, 0x000fe4000020d400ULL,
0x00000018ffa67819ULL, 0x000fe40000011438ULL, 0x0000000149490812ULL, 0x010fe200078efcffULL,
0x000000a500437306ULL, 0x000fe20000209400ULL, 0x00000041b438723eULL, 0x000fe200000010ffULL,
0x000100003b987824ULL, 0x002fe200078e00ffULL, 0x000000489b48723eULL, 0x000fc800000010ffULL,
0x00000018ff987819ULL, 0x000fe20000011498ULL, 0x000000a500447306ULL, 0x000e620000205400ULL,
0x000000999c00720bULL, 0x004fe20003fdd000ULL, 0x000001003b997824ULL, 0x000fe200078e00ffULL,
0x0000009800b17245ULL, 0x000fc8000020d400ULL, 0x00000018ff997819ULL, 0x000fe20000011499ULL,
0x0000003d00427306ULL, 0x000fec0000209400ULL, 0x000000019a9a6812ULL, 0x000fe400078efcffULL,
0x0000003d00457306ULL, 0x0004e20000205400ULL, 0x000000444300720bULL, 0x002fc40003f5d000ULL,
0x000000969100720bULL, 0x000fe40003fdd000ULL, 0x0000003d00917245ULL, 0x000fe4000020d400ULL,
0x000000bdc044723eULL, 0x000fe200000010ffULL, 0x0000005b00957306ULL, 0x000fe20000209400ULL,
0x0000008fb83d723eULL, 0x004fca00000010ffULL, 0x0000000146462812ULL, 0x000fe400078efcffULL,
0x0000005b00947306ULL, 0x000e620000205400ULL, 0x000000454200720bULL, 0x008fe40003f3d000ULL,
0x000000aaad45723eULL, 0x000fe400000010ffULL, 0x000000494649723eULL, 0x000fe400000010ffULL,
0x0000000177776812ULL, 0x000fe200078efcffULL, 0x000000a1003c7306ULL, 0x000fe60000209400ULL,
0x00000077a2a2723eULL, 0x000fc600000010ffULL, 0x0000000191911812ULL, 0x000fe400078efcffULL,
0x000000a100a77306ULL, 0x0004e20000205400ULL, 0x000000949500720bULL, 0x002fce0003f5d000ULL,
0x0000003e00937306ULL, 0x000fe20000009400ULL, 0x000000a100a17245ULL, 0x004fce000020d400ULL,
0x0000003e00927306ULL, 0x000e620000005400ULL, 0x000000a73c00720bULL, 0x008fe40003f3d000ULL,
0x00000097403c723eULL, 0x000fe400000010ffULL, 0x0000a80066407811ULL, 0x000fc600078e20ffULL,
0x0000003e00507306ULL, 0x0004ec000000d400ULL, 0x00000001a1a11812ULL, 0x000fe400078efcffULL,
0x0000003f004d7306ULL, 0x000fe20000009400ULL, 0x000100003e3e7824ULL, 0x004fe200078e00ffULL,
0x000000929300720bULL, 0x002fc40003f1d000ULL, 0x0000005b00927245ULL, 0x000fe4000020d400ULL,
0x00000018ff9c7819ULL, 0x000fe4000001143eULL, 0x0000003f005a7306ULL, 0x000e620000005400ULL,
0x0000000192922812ULL, 0x000fcc00078efcffULL, 0x0000000150500812ULL, 0x008fe200078efcffULL,
0x0000003a007d7306ULL, 0x000fe60000009400ULL, 0x00000050a150723eULL, 0x000fe400000010ffULL,
0x000000b99ea1723eULL, 0x000fc600000010ffULL, 0x0000003a007c7306ULL, 0x000fe20000005400ULL,
0x0000005a4d00720bULL, 0x002fe40003f5d000ULL, 0x000000585458723cULL, 0x000f6a00000418ffULL,
0x0000003a00717306ULL, 0x000ff0000000d400ULL, 0x0000009c00437306ULL, 0x000ff00000209400ULL,
0x0000009c003a7306ULL, 0x0002b00000205400ULL, 0x0000004c00877306ULL, 0x000fe20000209400ULL,
0x0000009c009c7245ULL, 0x002fce000020d400ULL, 0x0000004c00907306ULL, 0x000e620000205400ULL,
0x0000003a4300720bULL, 0x004fe40003f3d000ULL, 0x000000004040783bULL, 0x000eaa0000000200ULL,
0x0000003f00517306ULL, 0x00072c000000d400ULL, 0x000000019c9c1812ULL, 0x000fc400078efcffULL,
0x000000a600967306ULL, 0x000fe20000209400ULL, 0x000100003f3f7824ULL, 0x008fe200078e00ffULL,
0x000000908700720bULL, 0x002fe40003f1d000ULL, 0x0000004c00877245ULL, 0x000fe4000020d400ULL,
0x00000018ff8f7819ULL, 0x000fe4000001143fULL, 0x000000a600937306ULL, 0x0002e20000205400ULL,
0x0000000151512812ULL, 0x010fe200078efcffULL, 0x0000003c543c723cULL, 0x000f6200000418ffULL,
0x0000004e00907245ULL, 0x000fc4000020d400ULL, 0x000000a99a4c723eULL, 0x000fe400000010ffULL,
0x0000000187870812ULL, 0x000fe200078efcffULL, 0x0000004e004a7306ULL, 0x000fe20000209400ULL,
0x000000a600a67245ULL, 0x002fce000020d400ULL, 0x0000004e004b7306ULL, 0x000e620000205400ULL,
0x000000939600720bULL, 0x008fe20003f3d000ULL, 0x000000074040b231ULL, 0x084fe400003400ffULL,
0x000000074242b231ULL, 0x000fe400003400ffULL, 0x000000064141b231ULL, 0x080fe400003400ffULL,
0x0000008f00947306ULL, 0x000fe20000209400ULL, 0x000000064343b231ULL, 0x000fca00003400ffULL,
0x00000001a6a61812ULL, 0x000fe400078efcffULL, 0x0000008f004d7306ULL, 0x0004e20000205400ULL,
0x0000004b4a00720bULL, 0x002fe40003f1d000ULL, 0x00000051a651723eULL, 0x000fe200000010ffULL,
0x000000485448723cULL, 0x000fe800000418ffULL, 0x0000003900867306ULL, 0x000fe20000009400ULL,
0x0000008f008f7245ULL, 0x004fca000020d400ULL, 0x0000000190900812ULL, 0x000fe400078efcffULL,
0x00000039004f7306ULL, 0x000e620000005400ULL, 0x0000004d9400720bULL, 0x008fe40003f5d000ULL,
0x00000091924d723eULL, 0x000fca00000010ffULL, 0x00000089008a7306ULL, 0x000fec0000209400ULL,
0x000000018f8f2812ULL, 0x000fe400078efcffULL, 0x0000008900957306ULL, 0x000ea20000205400ULL,
0x0000004f8600720bULL, 0x002fe40003f3d000ULL, 0x0000009c8786723eULL, 0x000fe200000010ffULL,
0x0000004c544c723cULL, 0x000fe200000418ffULL, 0x0000008f9087723eULL, 0x000fc400000010ffULL,
0x00000081a49c723eULL, 0x000fe200000010ffULL, 0x0000008200537306ULL, 0x000fec0000209400ULL,
0x0000009c4058723cULL, 0x020fe40000041858ULL, 0x0000008200527306ULL, 0x000e620000205400ULL,
0x000000958a00720bULL, 0x004fce0003fdd000ULL, 0x0000008800857306ULL, 0x000ff00000209400ULL,
0x00000088008e7306ULL, 0x0004e20000205400ULL, 0x000000525300720bULL, 0x002fe40003f5d000ULL,
0x000000505450723cULL, 0x000fea00000418ffULL, 0x0000003900787306ULL, 0x000322000000d400ULL,
0x0000008800887245ULL, 0x004fce000020d400ULL, 0x0000007b007f7306ULL, 0x000fe20000209400ULL,
0x00000047ba39723eULL, 0x002fe400000010ffULL, 0x0000008e8500720bULL, 0x008fe20003f1d000ULL,
0x000000445444723cULL, 0x000f6200000418ffULL, 0x00000083a885723eULL, 0x000fe400000010ffULL,
0x0000008200837245ULL, 0x000fe2000020d400ULL, 0x0000007b007e7306ULL, 0x000fe20000205400ULL,
0x0000000178781812ULL, 0x010fe400078efcffULL, 0x0000000183832812ULL, 0x000fe200078efcffULL,
0x00000084403c723cULL, 0x000fe2000004183cULL, 0x0000007c7d00720bULL, 0x000fc40003f5d000ULL,
0x0000007b007c7245ULL, 0x000fe2000020d400ULL, 0x000000ab00937306ULL, 0x000fe20000209400ULL,
0x0000000188880812ULL, 0x000fc800078efcffULL, 0x000000888388723eULL, 0x000fc600000010ffULL,
0x000000ab00947306ULL, 0x000e640000205400ULL, 0x0000000171712812ULL, 0x000fe400078efcffULL,
0x000000a04044723cULL, 0x020fe80000041844ULL, 0x0000003b00797306ULL, 0x000ff00000009400ULL,
0x0000003b007a7306ULL, 0x000fe20000005400ULL, 0x000000949300720bULL, 0x002fce0003f1d000ULL,
0x0000003b005f7306ULL, 0x0003f0000000d400ULL, 0x000000af00917306ULL, 0x000fe20000209400ULL,
0x000000385438723cULL, 0x042f6e00000418ffULL, 0x000000af00927306ULL, 0x000e620000205400ULL,
0x000000865454723cULL, 0x000b6e00000418ffULL, 0x000000aea387723eULL, 0x020fe200000010ffULL,
0x00000099008a7306ULL, 0x000fe20000209400ULL, 0x0000008900a37245ULL, 0x000fc4000020d400ULL,
0x000000ab00897245ULL, 0x000fe4000020d400ULL, 0x00000001a3a36812ULL, 0x000fe400078efcffULL,
0x0000007e7f00720bULL, 0x000fe20003fdd000ULL, 0x00000099008b7306ULL, 0x000ea20000205400ULL,
0x0000000189890812ULL, 0x000fe400078efcffULL, 0x000000929100720bULL, 0x002fe40003f3d000ULL,
0x00000078a3a3723eULL, 0x000fc400000010ffULL, 0x0000009900787245ULL, 0x000fe2000020d400ULL,
0x0000005e00757306ULL, 0x000fe20000209400ULL, 0x0000008c8d86723eULL, 0x000fc600000010ffULL,
0x000000017c7c6812ULL, 0x000fe200078efcffULL, 0x000000a24048723cULL, 0x040b620000041848ULL,
0x0000007a7900720bULL, 0x000fe40003fdd000ULL, 0x0000005e00767306ULL, 0x0002e20000205400ULL,
0x0000008b8a00720bULL, 0x004fe40003f1d000ULL, 0x000000af007a7245ULL, 0x000fe4000020d400ULL,
0x000000897c89723eULL, 0x000fe200000010ffULL, 0x000000864038723cULL, 0x000b620000041838ULL,
0x000000017a7a1812ULL, 0x000fe200078efcffULL, 0x00000098007e7306ULL, 0x000fe20000209400ULL,
0x0000005e005e7245ULL, 0x002fc4000020d400ULL, 0x000000015f5f6812ULL, 0x000fe400078efcffULL,
0x000000717a7a723eULL, 0x000fe200000010ffULL, 0x00000088404c723cULL, 0x000b62000004184cULL,
0x0000000178780812ULL, 0x000fe200078efcffULL, 0x0000009800797306ULL, 0x000e620000205400ULL,
0x000000767500720bULL, 0x008fe40003f5d000ULL, 0x0000005f787b723eULL, 0x000fe400000010ffULL,
0x0000005c005f7245ULL, 0x000fc6000020d400ULL, 0x0000005c00737306ULL, 0x000fe40000209400ULL,
0x0000007a4050723cULL, 0x000b680000041850ULL, 0x000000015e5e2812ULL, 0x000fe400078efcffULL,
0x0000005c00747306ULL, 0x0004e20000205400ULL, 0x000000797e00720bULL, 0x002fe40003fdd000ULL,
0x000000726900720cULL, 0x000fca0003f46070ULL, 0x000000b0008e7306ULL, 0x000fe20000209400ULL,
0x00000001725c7810ULL, 0x004fc80007ffe0ffULL, 0x0000005c6900720cULL, 0x000fe40005746470ULL,
0x00000001b1b16812ULL, 0x000fe200078efcffULL, 0x000000b0007d7306ULL, 0x0002a20000205400ULL,
0x000000747300720bULL, 0x008fe40003f3d000ULL, 0x0000000e3500720cULL, 0x000fe40003fc3070ULL,
0x000000b15eb1723eULL, 0x000fe400000010ffULL, 0x000000b000b07245ULL, 0x002fce000020d400ULL,
0x000000015f5f1812ULL, 0x000fe400078efcffULL, 0x0000007d8e00720bULL, 0x004fe40003f1d000ULL,
0x000000726800720cULL, 0x000fc80003f26070ULL, 0x0000005c6800720cULL, 0x000fce0004f26470ULL,
0x00000001b0b00812ULL, 0x000fe400078efcffULL, 0x0000000e3500720cULL, 0x000fe40003f03070ULL,
0x000000b05fb0723eULL, 0x000fce00000010ffULL, 0x000000b04054723cULL, 0x000b620000041854ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x0000003c13137221ULL, 0x000fe20000010000ULL, 0x0000003d14147221ULL, 0x000fe20000010000ULL,
0x0000003817177221ULL, 0x020fe20000010000ULL, 0x0000003918187221ULL, 0x000fe20000010000ULL,
0x000000581b1b7221ULL, 0x000fe20000010000ULL, 0x000000591c1c7221ULL, 0x000fe20000010000ULL,
0x000000441f1f7221ULL, 0x000fe20000010000ULL, 0x0000004520207221ULL, 0x000fe20000010000ULL,
0x0000004823237221ULL, 0x000fe20000010000ULL, 0x0000004924247221ULL, 0x000fe20000010000ULL,
0x0000004c27277221ULL, 0x000fe20000010000ULL, 0x0000004d28287221ULL, 0x000fe20000010000ULL,
0x000000502b2b7221ULL, 0x000fe20000010000ULL, 0x000000512c2c7221ULL, 0x000fe20000010000ULL,
0x000000542f2f7221ULL, 0x000fe20000010000ULL, 0x0000005530307221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000001947ULL, 0x000fea0000000000ULL, 0x0000003e15157221ULL, 0x000fe20000010000ULL,
0x0000003f16167221ULL, 0x000fe20000010000ULL, 0x0000003a19197221ULL, 0x020fe20000010000ULL,
0x0000003b1a1a7221ULL, 0x000fe20000010000ULL, 0x0000005a1d1d7221ULL, 0x000fe20000010000ULL,
0x0000005b1e1e7221ULL, 0x000fe20000010000ULL, 0x0000004621217221ULL, 0x000fe20000010000ULL,
0x0000004722227221ULL, 0x000fe20000010000ULL, 0x0000004a25257221ULL, 0x000fe20000010000ULL,
0x0000004b26267221ULL, 0x000fe20000010000ULL, 0x0000004e29297221ULL, 0x000fe20000010000ULL,
0x0000004f2a2a7221ULL, 0x000fe20000010000ULL, 0x000000522d2d7221ULL, 0x000fe20000010000ULL,
0x000000532e2e7221ULL, 0x000fe20000010000ULL, 0x0000005631317221ULL, 0x000fe20000010000ULL,
0x0000005760607221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8800ff387f8cULL, 0x020e62000c80043fULL,
0x00000002ff3b7819ULL, 0x000fe2000001165cULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x0000000e3500720cULL, 0x000fc40003fc3070ULL, 0x0000003b5c3b7207ULL, 0x040fe40002800000ULL,
0x000000035c5c7812ULL, 0x000fe400078ec0ffULL, 0x000000013b3b7810ULL, 0x000fe40007ffe0ffULL,
0x0000000e3500720cULL, 0x000fe40003f03070ULL, 0x00000040ff5e7803ULL, 0x000fe40000000000ULL,
0x000000ff5c5c7207ULL, 0x000fc40006800000ULL, 0x000000033b417812ULL, 0x040fe400078ec0ffULL,
0x0000000e3b407211ULL, 0x000fe200078ff0ffULL, 0x000000ffff3f7224ULL, 0x002fc400078e0039ULL,
0x0000000000387805ULL, 0x000fca0000015200ULL, 0x010b8400ff3a7984ULL, 0x000e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x800000003aff7812ULL, 0x002fe200078c485dULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007fde1ffULL,
0x000000013b3b7824ULL, 0x000fe200030e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078d10ffULL, 0x000000ffff3b7224ULL, 0x000fca00030e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8400ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe400078c485dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fc40000015200ULL, 0x010b8c00ff3a7984ULL, 0x000e620000000800ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe60000000000ULL,
0x800000003aff7812ULL, 0x002fe200078c483fULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000103c00780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383d7210ULL, 0x000fca0007fde1ffULL, 0x000000013b3b7824ULL, 0x000fe200030e0e39ULL,
0x003d09003d00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff3a7819ULL, 0x000fc8000001143bULL, 0x0000003d3a3a7211ULL, 0x000fca00078d10ffULL,
0x000000ffff3b7224ULL, 0x000fca00030e063bULL, 0x000000023a3a7819ULL, 0x000fc8000000123bULL,
0x0000003a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe400078c483fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000140387810ULL, 0x000fe20007ffe0ffULL,
0x0000097000017945ULL, 0x000fe60003800000ULL, 0x000000373800720cULL, 0x000fda0003fc6070ULL,
0x000005100000e947ULL, 0x000fea0003800000ULL, 0x0000000162437824ULL, 0x000fe400078e0205ULL,
0x00000100ff447424ULL, 0x000fe400078e00ffULL, 0x0000004034427824ULL, 0x000fe200078e0243ULL,
0x010a0000433c7984ULL, 0x000e620000004800ULL, 0x00000010323a7824ULL, 0x000fe400078e00ffULL,
0x00000010433d7824ULL, 0x000fc600078e00ffULL, 0x000000f03a457812ULL, 0x000fe200078ec0ffULL,
0x010ac0003c397984ULL, 0x002e640000004800ULL, 0x000000390c397224ULL, 0x002fc800078e0242ULL,
0x00005e0039387625ULL, 0x000fca00078e0044ULL, 0x00000045383a7210ULL, 0x000fe20007fde0ffULL,
0x0000000440387824ULL, 0x000fc800078e0241ULL, 0x0000004038387824ULL, 0x000fe400078e00ffULL,
0x000000ffff3b7224ULL, 0x000fc600030e0639ULL, 0x0000003861397217ULL, 0x000fca0007800000ULL,
0x0000000139397824ULL, 0x000fe400078e0a38ULL, 0x0000000143387824ULL, 0x000fc600078e0232ULL,
0x0000003962397217ULL, 0x000fe40007800000ULL, 0xfffffff03d387812ULL, 0x000fc600078ee238ULL,
0x00000001393e7824ULL, 0x000fe200078e0a62ULL, 0x0000c00038477811ULL, 0x000fe400078e20ffULL,
0x0000000242387810ULL, 0x000fe40007ffe0ffULL, 0x0000003e0500720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a477faeULL, 0x0003e8000f101c46ULL,
0x010a0800433f7984ULL, 0x000ea80000004800ULL, 0x010ac0003f3f7984ULL, 0x004ea40000004800ULL,
0x0000003f0c387224ULL, 0x004fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fca00078e0044ULL,
0x00000045383c7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3d7224ULL, 0x000fe200030e0639ULL,
0x0000000205397810ULL, 0x000fc80007ffe0ffULL, 0x0000003e3900720cULL, 0x000fe20003fc6070ULL,
0x0000000162497824ULL, 0x000fc800078e0239ULL, 0x0000000149387824ULL, 0x040fe400078e0232ULL,
0x0000001049497824ULL, 0x000fca00078e00ffULL, 0xfffffff049387812ULL, 0x000fc800078ee238ULL,
0x0000c00038477811ULL, 0x002fe400078e20ffULL, 0x0000000442387810ULL, 0x040fe40007ffe0ffULL,
0x0000000642427810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c477faeULL, 0x0003e8000f101c46ULL, 0x010a1000433f7984ULL, 0x000ea80000004800ULL,
0x010ac0003f3f7984ULL, 0x004ea40000004800ULL, 0x0000003f0c387224ULL, 0x004fe200078e0238ULL,
0x00000006053f7810ULL, 0x000fc60007ffe0ffULL, 0x00005e0038387625ULL, 0x000fca00078e0044ULL,
0x00000045383a7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3b7224ULL, 0x000fe200030e0639ULL,
0x0000000405397810ULL, 0x000fc80007ffe0ffULL, 0x0000003e3900720cULL, 0x000fe20003fc6070ULL,
0x0000000162497824ULL, 0x000fc800078e0239ULL, 0x0000000149387824ULL, 0x040fe400078e0232ULL,
0x0000001049497824ULL, 0x000fca00078e00ffULL, 0xfffffff049387812ULL, 0x000fc800078ee238ULL,
0x0000c000383d7811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a3d7faeULL, 0x0003e8000f101c46ULL, 0x010a1800433c7984ULL, 0x000ea80000004800ULL,
0x010ac0003c397984ULL, 0x004ea40000004800ULL, 0x000000390c397224ULL, 0x004fc800078e0242ULL,
0x00005e0039387625ULL, 0x000fca00078e0044ULL, 0x0000004538387210ULL, 0x000fe20007fde0ffULL,
0x0000000162457824ULL, 0x000fc800078e023fULL, 0x0000000145427824ULL, 0x000fe400078e0232ULL,
0x000000ffff397224ULL, 0x000fe200030e0639ULL, 0x0000003e3f00720cULL, 0x000fe20003fc6070ULL,
0x0000001045457824ULL, 0x000fca00078e00ffULL, 0xfffffff045427812ULL, 0x000fc800078ee242ULL,
0x0000c000423b7811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e2000f101c46ULL, 0x0000043000007947ULL, 0x000fea0003800000ULL,
0x00000001623f7824ULL, 0x000fe400078e0205ULL, 0x00000100ff447424ULL, 0x000fe400078e00ffULL,
0x0000004034427824ULL, 0x000fe200078e023fULL, 0x010a00003f3c7984ULL, 0x000e620000004800ULL,
0x00000010323a7824ULL, 0x000fca00078e00ffULL, 0x000000f03a437812ULL, 0x000fe200078ec0ffULL,
0x010ac0003c397984ULL, 0x002e640000004800ULL, 0x000000390c397224ULL, 0x002fc800078e0242ULL,
0x00005e0039387625ULL, 0x000fca00078e0044ULL, 0x00000043383a7210ULL, 0x000fe20007fde0ffULL,
0x000000013f387824ULL, 0x000fc800078e0232ULL, 0x000000ffff3b7224ULL, 0x000fe400030e0639ULL,
0x000000103f397824ULL, 0x000fca00078e00ffULL, 0xfffffff039387812ULL, 0x000fc800078ee238ULL,
0x0000c00038457811ULL, 0x000fe400078e20ffULL, 0x0000000242387810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a457faeULL, 0x0003e8000b901c46ULL,
0x010a08003f3e7984ULL, 0x000ea80000004800ULL, 0x010ac0003e397984ULL, 0x004ea40000004800ULL,
0x000000390c397224ULL, 0x004fc800078e0238ULL, 0x00005e0039387625ULL, 0x000fca00078e0044ULL,
0x00000043383c7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3d7224ULL, 0x000fe200030e0639ULL,
0x000000023f397810ULL, 0x000fca0007ffe0ffULL, 0x0000000139387824ULL, 0x040fe400078e0232ULL,
0x0000001039397824ULL, 0x000fca00078e00ffULL, 0xfffffff039387812ULL, 0x000fc800078ee238ULL,
0x0000c00038457811ULL, 0x002fe400078e20ffULL, 0x0000000442387810ULL, 0x040fe40007ffe0ffULL,
0x0000000642427810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x010a10003f3e7984ULL, 0x000ea80000004800ULL,
0x010ac0003e397984ULL, 0x004ea40000004800ULL, 0x000000390c397224ULL, 0x004fc800078e0238ULL,
0x00005e0039387625ULL, 0x000fca00078e0044ULL, 0x00000043383a7210ULL, 0x000fca0007fde0ffULL,
0x000000ffff3b7224ULL, 0x000fe200030e0639ULL, 0x000000043f397810ULL, 0x000fca0007ffe0ffULL,
0x0000000139387824ULL, 0x040fe400078e0232ULL, 0x0000001039397824ULL, 0x000fca00078e00ffULL,
0xfffffff039387812ULL, 0x000fc800078ee238ULL, 0x0000c000383d7811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e8000b901c46ULL,
0x010a18003f3c7984ULL, 0x000ea80000004800ULL, 0x010ac0003c397984ULL, 0x004ea40000004800ULL,
0x000000390c397224ULL, 0x004fc800078e0242ULL, 0x00005e0039387625ULL, 0x000fca00078e0044ULL,
0x0000004338387210ULL, 0x000fe40007fde0ffULL, 0x000000063f437810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff397224ULL, 0x000fe400030e0639ULL, 0x00000001433e7824ULL, 0x040fe400078e0232ULL,
0x0000001043437824ULL, 0x000fca00078e00ffULL, 0xfffffff0433e7812ULL, 0x000fc800078ee23eULL,
0x0000c0003e3b7811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e4000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8800ff387f8cULL, 0x002e64000c80043fULL,
0x000000ffff3f7224ULL, 0x002fc400078e0039ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x010b8c00ff3a7984ULL, 0x000e620000000800ULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x800000003aff7812ULL, 0x002fe200078c483fULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007fde1ffULL,
0x000000013b3b7824ULL, 0x000fe200030e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078d10ffULL, 0x000000ffff3b7224ULL, 0x000fca00030e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe400078c483fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000017000017945ULL, 0x000fe20003800000ULL, 0x0000015000004947ULL, 0x000fea0003800000ULL,
0x000000403500720cULL, 0x000fe40003fc4070ULL, 0x00010a000b3b7811ULL, 0x000fe400078e10ffULL,
0x000000ff5c387207ULL, 0x000fc40003000000ULL, 0x000000ff5c5c7207ULL, 0x000fc60007000000ULL,
0x0000000141387824ULL, 0x000fc800078e0238ULL, 0x0000004038397824ULL, 0x040fe200078e00ffULL,
0x0000004038387211ULL, 0x000fc800078ff0ffULL, 0x000000c039397812ULL, 0x000fca00078ec0ffULL,
0x0000010038387824ULL, 0x000fe400078e0239ULL, 0x0000000163397824ULL, 0x000fc600078e025cULL,
0x00000020383a7810ULL, 0x000fca0007ffe0ffULL, 0x0000680039387a24ULL, 0x100fe400078e023aULL,
0x000000010b3a7824ULL, 0x040fe400078e023aULL, 0x00000004ff397424ULL, 0x000fe400078e00ffULL,
0x000000010b387824ULL, 0x000fe200078e0238ULL, 0x000000613a00720cULL, 0x000fc60003fc6070ULL,
0x0000660038387625ULL, 0x000fd400078e0039ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e4000f121846ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x010b7800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b7800ff387f8cULL, 0x000e62000c80043fULL, 0x0000013000017945ULL, 0x000fe20003800000ULL,
0x000000ffff717224ULL, 0x002fe200078e0039ULL, 0x0000010000003947ULL, 0x000fea0003800000ULL,
0x00000008ff06723eULL, 0x000fc800000010ffULL, 0x00005410063a7816ULL, 0x000fe20000000006ULL,
0x000188a27f007947ULL, 0x000fea000b800000ULL, 0x00001f693a077589ULL, 0x0002a400000e0000ULL,
0x000188e27f007947ULL, 0x000fea000b800000ULL, 0x00001f683a067589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000010693f7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff3e7224ULL, 0x000fe200078e003aULL, 0x0000e4f000387802ULL, 0x000fc40000000f00ULL,
0x000193c000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000ffff3e7224ULL, 0x004fe200078e003aULL, 0x00000018693f7810ULL, 0x002fe40007ffe0ffULL,
0x0000e54000387802ULL, 0x000fc40000000f00ULL, 0x0001937000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000006d3c783bULL, 0x006e620000004200ULL, 0x00001e3000017945ULL, 0x000fe60003800000ULL,
0x000000006c40783bULL, 0x000ea80000004200ULL, 0x000000006b44783bULL, 0x000f220000004200ULL,
0x0000003c00387306ULL, 0x002fe20000009400ULL, 0x00000018ff577819ULL, 0x004fce0000011440ULL,
0x0000003c00397306ULL, 0x000e700000005400ULL, 0x0000003c004a7306ULL, 0x000ea2000000d400ULL,
0x000000393800720bULL, 0x002fce0003fdd000ULL, 0x0000003d004b7306ULL, 0x000ff0000000d400ULL,
0x0000003d00387306ULL, 0x000fe20000009400ULL, 0x000000014a4a6812ULL, 0x004fce00078efcffULL,
0x0000003d00397306ULL, 0x000e700000005400ULL, 0x0000003e00487306ULL, 0x000fe2000000d400ULL,
0x000000393800720bULL, 0x002fce0003fdd000ULL, 0x0000003f00497306ULL, 0x000ff0000000d400ULL,
0x0000003e00387306ULL, 0x000fe20000009400ULL, 0x000000014b4b6812ULL, 0x000fce00078efcffULL,
0x0000003e00397306ULL, 0x000e700000005400ULL, 0x0000004000507306ULL, 0x000fe2000000d400ULL,
0x000000393800720bULL, 0x002fce0003fdd000ULL, 0x0000004100517306ULL, 0x000ff0000000d400ULL,
0x0000003f00387306ULL, 0x000fe20000009400ULL, 0x0000000148486812ULL, 0x000fce00078efcffULL,
0x0000003f00397306ULL, 0x000e700000005400ULL, 0x0000004200567306ULL, 0x000fe2000000d400ULL,
0x000000393800720bULL, 0x002fce0003fdd000ULL, 0x0000004300587306ULL, 0x000ff0000000d400ULL,
0x0000004000387306ULL, 0x000fe20000009400ULL, 0x0000000149496812ULL, 0x000fce00078efcffULL,
0x0000004000397306ULL, 0x000e700000005400ULL, 0x00000044007e7306ULL, 0x010fe2000000d400ULL,
0x000000393800720bULL, 0x002fce0003fdd000ULL, 0x00000045007d7306ULL, 0x000ff0000000d400ULL,
0x0000004100387306ULL, 0x000fe20000009400ULL, 0x0000000150506812ULL, 0x000fce00078efcffULL,
0x0000004100397306ULL, 0x000e700000005400ULL, 0x00000046007a7306ULL, 0x000fe2000000d400ULL,
0x000000393800720bULL, 0x002fce0003fdd000ULL, 0x0000004700787306ULL, 0x000ff0000000d400ULL,
0x0000004200387306ULL, 0x000fe20000009400ULL, 0x0000000151516812ULL, 0x000fce00078efcffULL,
0x0000004200397306ULL, 0x000e640000005400ULL, 0x000000393800720bULL, 0x002fcc0003fdd000ULL,
0x0000004300387306ULL, 0x000ff00000009400ULL, 0x0000004300397306ULL, 0x000e620000005400ULL,
0x0000000156566812ULL, 0x000fe400078efcffULL, 0x000000393800720bULL, 0x002fca0003fdd000ULL,
0x0000004400387306ULL, 0x000ff00000009400ULL, 0x0000004400397306ULL, 0x000e620000005400ULL,
0x0000000158586812ULL, 0x000fe400078efcffULL, 0x000000393800720bULL, 0x002fca0003fdd000ULL,
0x0000004500387306ULL, 0x000ff00000009400ULL, 0x0000004500397306ULL, 0x000e620000005400ULL,
0x000000017e7e6812ULL, 0x000fe400078efcffULL, 0x000000393800720bULL, 0x002fca0003fdd000ULL,
0x0000004600387306ULL, 0x000ff00000009400ULL, 0x0000004600397306ULL, 0x000e620000005400ULL,
0x000000017d7d6812ULL, 0x000fe400078efcffULL, 0x000000393800720bULL, 0x002fca0003fdd000ULL,
0x0000004700387306ULL, 0x000ff00000009400ULL, 0x0000004700397306ULL, 0x000e620000005400ULL,
0x000000017a7a6812ULL, 0x000fe400078efcffULL, 0x000000393800720bULL, 0x002fc40003fdd000ULL,
0x000000006a38783bULL, 0x008e760000004200ULL, 0x0000000178786812ULL, 0x000fe200078efcffULL,
0x00000038004c7306ULL, 0x002ff00000009400ULL, 0x00000038004d7306ULL, 0x000e700000005400ULL,
0x0000003800757306ULL, 0x000ea2000000d400ULL, 0x0000004d4c00720bULL, 0x002fce0003fdd000ULL,
0x0000003900767306ULL, 0x000ff0000000d400ULL, 0x00000039004c7306ULL, 0x000fe20000009400ULL,
0x0000000175756812ULL, 0x004fce00078efcffULL, 0x00000039004d7306ULL, 0x000e700000005400ULL,
0x0000003a00737306ULL, 0x000fe2000000d400ULL, 0x0000004d4c00720bULL, 0x002fce0003fdd000ULL,
0x0000003b00977306ULL, 0x000ff0000000d400ULL, 0x0000003a004c7306ULL, 0x000fe20000009400ULL,
0x0000000176766812ULL, 0x000fce00078efcffULL, 0x0000003a004d7306ULL, 0x000e640000005400ULL,
0x0000004d4c00720bULL, 0x002fe40003fdd000ULL, 0x00000018ff4c7819ULL, 0x000fc8000001143cULL,
0x0000004c004d7306ULL, 0x000fe20000209400ULL, 0x0000004c004f7245ULL, 0x000fcc000020d400ULL,
0x0000000173736812ULL, 0x000fe200078efcffULL, 0x0000004c004e7306ULL, 0x000e640000205400ULL,
0x0000004e4d00720bULL, 0x002fe40003fdd000ULL, 0x00000018ff4d7819ULL, 0x000fc8000001143dULL,
0x0000004d00527306ULL, 0x000fe20000209400ULL, 0x0000004d004e7245ULL, 0x000fcc000020d400ULL,
0x000000014f4f6812ULL, 0x000fe200078efcffULL, 0x0000004d00537306ULL, 0x000e640000205400ULL,
0x000000535200720bULL, 0x002fe40003fdd000ULL, 0x00000018ff527819ULL, 0x000fc8000001143eULL,
0x0000005200537306ULL, 0x000fe20000209400ULL, 0x00000052004c7245ULL, 0x000fcc000020d400ULL,
0x000000014e4e6812ULL, 0x000fe200078efcffULL, 0x0000005200547306ULL, 0x000e700000205400ULL,
0x0000005700527306ULL, 0x000fe20000209400ULL, 0x000000545300720bULL, 0x002fc40003fdd000ULL,
0x00000018ff537819ULL, 0x000fca000001143fULL, 0x0000005300547306ULL, 0x000fe20000209400ULL,
0x00000053004d7245ULL, 0x000fca000020d400ULL, 0x000000014c4c6812ULL, 0x000fe400078efcffULL,
0x0000005300557306ULL, 0x000e640000205400ULL, 0x000000555400720bULL, 0x002fcc0003fdd000ULL,
0x0000005700557306ULL, 0x000e620000205400ULL, 0x0000005700547245ULL, 0x000fcc000020d400ULL,
0x000000014d4d6812ULL, 0x000fe400078efcffULL, 0x000000555200720bULL, 0x002fe40003fdd000ULL,
0x00000018ff527819ULL, 0x000fc80000011441ULL, 0x0000005200537306ULL, 0x000fe20000209400ULL,
0x0000005200557245ULL, 0x000fcc000020d400ULL, 0x0000000154546812ULL, 0x000fe200078efcffULL,
0x00000052005a7306ULL, 0x000e640000205400ULL, 0x0000005a5300720bULL, 0x002fe40003fdd000ULL,
0x00000018ff537819ULL, 0x000fc80000011442ULL, 0x0000005300577306ULL, 0x000fe20000209400ULL,
0x0000005300597245ULL, 0x000fcc000020d400ULL, 0x0000000155556812ULL, 0x000fe200078efcffULL,
0x00000053005a7306ULL, 0x000e640000205400ULL, 0x0000005a5700720bULL, 0x002fe40003fdd000ULL,
0x00000018ff577819ULL, 0x000fc80000011443ULL, 0x0000005700527306ULL, 0x000fe20000209400ULL,
0x00000057005a7245ULL, 0x000fcc000020d400ULL, 0x0000000159596812ULL, 0x000fe200078efcffULL,
0x00000057005b7306ULL, 0x000e640000205400ULL, 0x0000005b5200720bULL, 0x002fe40003fdd000ULL,
0x00000018ff527819ULL, 0x000fc80000011444ULL, 0x0000005200537306ULL, 0x000fe20000209400ULL,
0x0000005200807245ULL, 0x000fcc000020d400ULL, 0x000000015a5a6812ULL, 0x000fe200078efcffULL,
0x00000052005c7306ULL, 0x000e640000205400ULL, 0x0000005c5300720bULL, 0x002fe40003fdd000ULL,
0x00000018ff537819ULL, 0x000fc80000011445ULL, 0x0000005300577306ULL, 0x000fe20000209400ULL,
0x00000053007f7245ULL, 0x000fcc000020d400ULL, 0x0000000180806812ULL, 0x000fe200078efcffULL,
0x00000053005c7306ULL, 0x000e640000205400ULL, 0x0000005c5700720bULL, 0x002fe40003fdd000ULL,
0x00000018ff577819ULL, 0x000fc80000011446ULL, 0x0000005700527306ULL, 0x000fe20000209400ULL,
0x00000057007c7245ULL, 0x000fcc000020d400ULL, 0x000000017f7f6812ULL, 0x000fe200078efcffULL,
0x00000057005b7306ULL, 0x000e640000205400ULL, 0x0000005b5200720bULL, 0x002fe40003fdd000ULL,
0x00000018ff527819ULL, 0x000fc80000011447ULL, 0x0000005200537306ULL, 0x000fe20000209400ULL,
0x00000052007b7245ULL, 0x000fcc000020d400ULL, 0x000000017c7c6812ULL, 0x000fe200078efcffULL,
0x00000052005c7306ULL, 0x000e640000205400ULL, 0x0000005c5300720bULL, 0x002fe40003fdd000ULL,
0x00000018ff537819ULL, 0x000fc80000011438ULL, 0x0000005300577306ULL, 0x000fe20000209400ULL,
0x0000005300797245ULL, 0x000fcc000020d400ULL, 0x000000017b7b6812ULL, 0x000fe200078efcffULL,
0x00000053005c7306ULL, 0x000e640000205400ULL, 0x0000005c5700720bULL, 0x002fe40003fdd000ULL,
0x00000018ff577819ULL, 0x000fc80000011439ULL, 0x0000005700527306ULL, 0x000fe20000209400ULL,
0x0000005700777245ULL, 0x000fcc000020d400ULL, 0x0000000179796812ULL, 0x000fe200078efcffULL,
0x00000057005b7306ULL, 0x000e640000205400ULL, 0x0000005b5200720bULL, 0x002fe40003fdd000ULL,
0x00000018ff5b7819ULL, 0x000fc8000001143aULL, 0x0000005b00527306ULL, 0x000fe20000209400ULL,
0x0000005b00747245ULL, 0x000fcc000020d400ULL, 0x0000000177776812ULL, 0x000fe200078efcffULL,
0x0000005b00537306ULL, 0x000e640000205400ULL, 0x000000535200720bULL, 0x002fe20003fdd000ULL,
0x000001003c527824ULL, 0x040fe400078e00ffULL, 0x000100003c3c7824ULL, 0x000fc600078e00ffULL,
0x00000018ff527819ULL, 0x000fc80000011452ULL, 0x0000005200577306ULL, 0x000fe20000209400ULL,
0x0000005200537245ULL, 0x000fe4000020d400ULL, 0x0000000174746812ULL, 0x000fca00078efcffULL,
0x00000052005c7306ULL, 0x0002a40000205400ULL, 0x000001003d527824ULL, 0x042fe400078e00ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x0000005c5700720bULL, 0x004fe40003fdd000ULL,
0x00000018ff577819ULL, 0x000fc8000001143cULL, 0x00000057005b7306ULL, 0x000fe20000209400ULL,
0x00000057003c7245ULL, 0x000fcc000020d400ULL, 0x0000000153536812ULL, 0x000fe200078efcffULL,
0x00000057005c7306ULL, 0x0002a40000205400ULL, 0x00000018ff577819ULL, 0x002fc8000001143dULL,
0x00000057003d7245ULL, 0x000fe4000020d400ULL, 0x0000005c5b00720bULL, 0x004fe40003fdd000ULL,
0x00000018ff5b7819ULL, 0x000fc80000011452ULL, 0x0000005b005c7306ULL, 0x000fe20000209400ULL,
0x0000005b00527245ULL, 0x000fcc000020d400ULL, 0x000000013c3c6812ULL, 0x000fe200078efcffULL,
0x0000005b005d7306ULL, 0x0002a40000205400ULL, 0x000001003e5b7824ULL, 0x042fe400078e00ffULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x0000005d5c00720bULL, 0x004fc60003fdd000ULL,
0x00000057005c7306ULL, 0x000fe20000209400ULL, 0x00000018ff3e7819ULL, 0x000fce000001143eULL,
0x00000057005d7306ULL, 0x0002a40000205400ULL, 0x0000000152526812ULL, 0x000fe400078efcffULL,
0x0000003e00577245ULL, 0x002fe4000020d400ULL, 0x0000005d5c00720bULL, 0x004fe40003fdd000ULL,
0x00000018ff5c7819ULL, 0x000fc8000001145bULL, 0x0000005c005d7306ULL, 0x000fe20000209400ULL,
0x0000005c005b7245ULL, 0x000fcc000020d400ULL, 0x000000013d3d6812ULL, 0x000fe200078efcffULL,
0x0000005c00827306ULL, 0x0002a40000205400ULL, 0x000001003f5c7824ULL, 0x042fe400078e00ffULL,
0x000100003f3f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe4000001145cULL,
0x000000825d00720bULL, 0x004fe40003fdd000ULL, 0x0000003e005d7306ULL, 0x000fe20000209400ULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x0000005c00847245ULL, 0x000fca000020d400ULL,
0x0000003e00827306ULL, 0x0002a60000205400ULL, 0x000000015b5b6812ULL, 0x000fc800078efcffULL,
0x000000485b48723eULL, 0x000fe400000010ffULL, 0x0000003f003e7245ULL, 0x002fe4000020d400ULL,
0x000000825d00720bULL, 0x004fe40003fdd000ULL, 0x0000005c005d7306ULL, 0x000ff00000209400ULL,
0x0000005c00827306ULL, 0x0002a60000205400ULL, 0x0000000157576812ULL, 0x000fc800078efcffULL,
0x000000574c4c723eULL, 0x000fe200000010ffULL, 0x00000100405c7824ULL, 0x042fe400078e00ffULL,
0x0001000040407824ULL, 0x000fc600078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe4000001145cULL,
0x000000825d00720bULL, 0x004fe40003fdd000ULL, 0x0000003f005d7306ULL, 0x000fe20000209400ULL,
0x00000018ff407819ULL, 0x000fe40000011440ULL, 0x0000005c00837245ULL, 0x000fe4000020d400ULL,
0x0000004000817245ULL, 0x000fc6000020d400ULL, 0x0000003f00827306ULL, 0x000e660000205400ULL,
0x0000000184846812ULL, 0x000fc800078efcffULL, 0x000000498449723eULL, 0x000fe200000010ffULL,
0x00000040003f7306ULL, 0x000fe20000209400ULL, 0x000000825d00720bULL, 0x002fce0003fdd000ULL,
0x0000005c005d7306ULL, 0x000ff00000209400ULL, 0x0000005c00827306ULL, 0x000e620000205400ULL,
0x000000013e3e6812ULL, 0x000fc800078efcffULL, 0x0000003e4d4d723eULL, 0x000fe400000010ffULL,
0x000000825d00720bULL, 0x002fe40003fdd000ULL, 0x0000004000827306ULL, 0x000e760000205400ULL,
0x0000000183836812ULL, 0x000fc800078efcffULL, 0x000000508350723eULL, 0x000fe400000010ffULL,
0x000000823f00720bULL, 0x002fe20003fdd000ULL, 0x00000100413f7824ULL, 0x040fe400078e00ffULL,
0x0001000041417824ULL, 0x000fc600078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x0000003f005c7306ULL, 0x000fe20000209400ULL,
0x0000003f00867245ULL, 0x000fe4000020d400ULL, 0x0000000181816812ULL, 0x000fe400078efcffULL,
0x0000004100827245ULL, 0x000fe4000020d400ULL, 0x000000815454723eULL, 0x000fe200000010ffULL,
0x0000003f005d7306ULL, 0x0002b00000205400ULL, 0x0000004100407306ULL, 0x000fe20000209400ULL,
0x00000100423f7824ULL, 0x002fc400078e00ffULL, 0x0001000042427824ULL, 0x000fc600078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x0000005d5c00720bULL, 0x004fe20003fdd000ULL,
0x0000003b00817306ULL, 0x000fe20000005400ULL, 0x00000018ff427819ULL, 0x000fe40000011442ULL,
0x0000003f00857245ULL, 0x000fe4000020d400ULL, 0x0000004200887245ULL, 0x000fc6000020d400ULL,
0x00000041005d7306ULL, 0x000e680000205400ULL, 0x0000000186866812ULL, 0x000fc800078efcffULL,
0x0000004200417306ULL, 0x000fe20000205400ULL, 0x000000518651723eULL, 0x000fe400000010ffULL,
0x0000005d4000720bULL, 0x002fca0003fdd000ULL, 0x0000003f00407306ULL, 0x000ff00000209400ULL,
0x0000003f005d7306ULL, 0x0002a20000205400ULL, 0x0000000182826812ULL, 0x000fc800078efcffULL,
0x000000825555723eULL, 0x000fe200000010ffULL, 0x00000100433f7824ULL, 0x042fe400078e00ffULL,
0x0001000043437824ULL, 0x000fc600078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x0000005d4000720bULL, 0x004fe40003fdd000ULL, 0x0000004200407306ULL, 0x000e620000209400ULL,
0x00000018ff437819ULL, 0x000fe40000011443ULL, 0x0000003f00877245ULL, 0x000fe4000020d400ULL,
0x0000004300897245ULL, 0x000fcc000020d400ULL, 0x0000000185856812ULL, 0x000fe400078efcffULL,
0x000000414000720bULL, 0x002fe40003fdd000ULL, 0x0000003f00407306ULL, 0x000ff00000209400ULL,
0x0000003f00417306ULL, 0x0002a60000205400ULL, 0x0000000188886812ULL, 0x000fc800078efcffULL,
0x000000885988723eULL, 0x000fe200000010ffULL, 0x00000100443f7824ULL, 0x042fe400078e00ffULL,
0x0001000044447824ULL, 0x000fc600078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x000000414000720bULL, 0x004fe40003fdd000ULL, 0x0000004300407306ULL, 0x000fe20000209400ULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x0000003f008d7245ULL, 0x000fe4000020d400ULL,
0x00000044008b7245ULL, 0x000fc6000020d400ULL, 0x0000004300417306ULL, 0x000e660000205400ULL,
0x0000000187876812ULL, 0x000fe400078efcffULL, 0x000000414000720bULL, 0x002fc60003fdd000ULL,
0x0000003f00407306ULL, 0x000ff00000209400ULL, 0x0000003f00417306ULL, 0x0002a40000205400ULL,
0x0000000189896812ULL, 0x000fc800078efcffULL, 0x000000895a89723eULL, 0x000fe200000010ffULL,
0x00000100453f7824ULL, 0x042fe400078e00ffULL, 0x0001000045457824ULL, 0x000fc600078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x000000414000720bULL, 0x004fe40003fdd000ULL,
0x0000004400407306ULL, 0x000fe20000209400ULL, 0x00000018ff457819ULL, 0x000fe40000011445ULL,
0x0000003f008c7245ULL, 0x000fe4000020d400ULL, 0x00000045008a7245ULL, 0x000fc6000020d400ULL,
0x0000004400417306ULL, 0x0002a60000205400ULL, 0x000000018d8d6812ULL, 0x000fe400078efcffULL,
0x0000003c4f44723eULL, 0x002fe400000010ffULL, 0x0000a8006e3c7811ULL, 0x000fe400078e20ffULL,
0x000000414000720bULL, 0x004fe40003fdd000ULL, 0x0000003f00407306ULL, 0x000ff00000209400ULL,
0x0000003f00417306ULL, 0x0002a60000205400ULL, 0x000000018b8b6812ULL, 0x000fe200078efcffULL,
0x00000100463f7824ULL, 0x002fc400078e00ffULL, 0x0001000046467824ULL, 0x000fc600078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x000000414000720bULL, 0x004fe40003fdd000ULL,
0x0000004500407306ULL, 0x000fe20000209400ULL, 0x00000018ff467819ULL, 0x000fe40000011446ULL,
0x0000003f00917245ULL, 0x000fe4000020d400ULL, 0x00000046008f7245ULL, 0x000fc6000020d400ULL,
0x0000004500417306ULL, 0x0002a60000205400ULL, 0x000000018c8c6812ULL, 0x000fe400078efcffULL,
0x0000003d4e45723eULL, 0x002fe400000010ffULL, 0x000000414000720bULL, 0x004fe40003fdd000ULL,
0x0000003f00407306ULL, 0x000ff00000209400ULL, 0x0000003f00417306ULL, 0x0002a60000205400ULL,
0x000000018a8a6812ULL, 0x000fc800078efcffULL, 0x0000008a7f7f723eULL, 0x000fe200000010ffULL,
0x00000100473f7824ULL, 0x042fe400078e00ffULL, 0x0001000047477824ULL, 0x000fc600078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x000000414000720bULL, 0x004fe40003fdd000ULL,
0x0000004600407306ULL, 0x000fe20000209400ULL, 0x00000018ff477819ULL, 0x000fe40000011447ULL,
0x0000003f00937245ULL, 0x000fe4000020d400ULL, 0x00000047008e7245ULL, 0x000fc6000020d400ULL,
0x0000004600417306ULL, 0x000e660000205400ULL, 0x0000000191916812ULL, 0x000fe400078efcffULL,
0x000000414000720bULL, 0x002fc60003fdd000ULL, 0x0000003f00407306ULL, 0x000ff00000209400ULL,
0x0000003f00417306ULL, 0x0002a40000205400ULL, 0x000000018f8f6812ULL, 0x000fe200078efcffULL,
0x00000100383f7824ULL, 0x002fc400078e00ffULL, 0x0001000038387824ULL, 0x000fc600078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x000000414000720bULL, 0x004fe40003fdd000ULL,
0x0000004700407306ULL, 0x000fe20000209400ULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x0000003f00927245ULL, 0x000fe4000020d400ULL, 0x0000003800907245ULL, 0x000fc6000020d400ULL,
0x0000004700417306ULL, 0x000e660000205400ULL, 0x0000000193936812ULL, 0x000fe400078efcffULL,
0x000000414000720bULL, 0x002fc60003fdd000ULL, 0x0000003f00407306ULL, 0x000ff00000209400ULL,
0x0000003f00417306ULL, 0x0002a40000205400ULL, 0x000000018e8e6812ULL, 0x000fc800078efcffULL,
0x0000008e7b7b723eULL, 0x000fe200000010ffULL, 0x00000100393f7824ULL, 0x042fe400078e00ffULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x000000414000720bULL, 0x004fe40003fdd000ULL, 0x0000003800407306ULL, 0x000fe20000209400ULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000003f00957245ULL, 0x000fe4000020d400ULL,
0x0000003900947245ULL, 0x000fc6000020d400ULL, 0x0000003800417306ULL, 0x000e660000205400ULL,
0x0000000192926812ULL, 0x000fc800078efcffULL, 0x000000759292723eULL, 0x000fe200000010ffULL,
0x0000003900387306ULL, 0x000fe20000209400ULL, 0x000000414000720bULL, 0x002fce0003fdd000ULL,
0x0000003f00407306ULL, 0x000ff00000209400ULL, 0x0000003f00417306ULL, 0x000e620000205400ULL,
0x0000000190906812ULL, 0x000fe400078efcffULL, 0x000000414000720bULL, 0x002fca0003fdd000ULL,
0x0000003900417306ULL, 0x000e700000205400ULL, 0x0000000195956812ULL, 0x000fe400078efcffULL,
0x000000413800720bULL, 0x002fe20003fdd000ULL, 0x000001003a387824ULL, 0x000fe200078e00ffULL,
0x0000004b5241723eULL, 0x000fe200000010ffULL, 0x000100003a3a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x00000038003f7306ULL, 0x000fe20000209400ULL, 0x0000003800967245ULL, 0x000fe4000020d400ULL,
0x0000000194946812ULL, 0x000fe400078efcffULL, 0x0000003a00997245ULL, 0x000fe4000020d400ULL,
0x000000947777723eULL, 0x000fe200000010ffULL, 0x0000003800407306ULL, 0x0002b00000205400ULL,
0x0000003a00397306ULL, 0x000fe20000209400ULL, 0x000001003b387824ULL, 0x002fe200078e00ffULL,
0x000000403f00720bULL, 0x004fcc0003fdd000ULL, 0x0000003a00407306ULL, 0x000e700000205400ULL,
0x0000003b003a7306ULL, 0x000fe20000009400ULL, 0x0000000196966812ULL, 0x000fc800078efcffULL,
0x000000739696723eULL, 0x000fe400000010ffULL, 0x000000403900720bULL, 0x002fe40003fdd000ULL,
0x00000018ff397819ULL, 0x000fe40000011438ULL, 0x0000004a5340723eULL, 0x000fe400000010ffULL,
0x0000003900387306ULL, 0x000fe20000209400ULL, 0x0000003900987245ULL, 0x000fcc000020d400ULL,
0x0000000199996812ULL, 0x000fe200078efcffULL, 0x00000039003f7306ULL, 0x0002a60000205400ULL,
0x000000997474723eULL, 0x000fe400000010ffULL, 0x000000588739723eULL, 0x002fe400000010ffULL,
0x0000003f3800720bULL, 0x004fe40003fdd000ULL, 0x0000a8006f387811ULL, 0x000fe200078e20ffULL,
0x000000003c3c783bULL, 0x000e740000000200ULL, 0x0000000198986812ULL, 0x000fc400078efcffULL,
0x000000ff5e00720cULL, 0x000fe40003fc5270ULL, 0x00000000385c783bULL, 0x0004e40000000200ULL,
0x000000568538723eULL, 0x004fe200000010ffULL, 0x000000073c3cb231ULL, 0x082fe400003400ffULL,
0x000000073e3eb231ULL, 0x000fe400003400ffULL, 0x000000063d3db231ULL, 0x080fe400003400ffULL,
0x000000063f3fb231ULL, 0x000fc400003400ffULL, 0x000000075c5cb231ULL, 0x088fe400003400ffULL,
0x000000075e5eb231ULL, 0x000fe400003400ffULL, 0x000000065d5db231ULL, 0x080fe400003400ffULL,
0x000000065f5fb231ULL, 0x000fe200003400ffULL, 0x000000813a00720bULL, 0x000fcc0003f7d000ULL,
0x000000385c58723cULL, 0x040bee00000418ffULL, 0x000100003b387824ULL, 0x020fe200078e00ffULL,
0x0000007d8c39723eULL, 0x000fe200000010ffULL, 0x000000405c40723cULL, 0x000f6200000418ffULL,
0x00000018ff3b7819ULL, 0x000fc4000001143bULL, 0x00000018ff827819ULL, 0x000fe40000011438ULL,
0x0000000197973812ULL, 0x000fe200078efcffULL, 0x0000003b003a7306ULL, 0x000fe20000209400ULL,
0x0000007e8d38723eULL, 0x000fe200000010ffULL, 0x000000485c48723cULL, 0x040fe200000418ffULL,
0x0000008200757245ULL, 0x000fe4000020d400ULL, 0x0000008b807e723eULL, 0x000fe400000010ffULL,
0x000000979897723eULL, 0x000fe200000010ffULL, 0x00000082007d7306ULL, 0x000fe40000209400ULL,
0x000000445c44723cULL, 0x040f6c00000418ffULL, 0x0000008200847306ULL, 0x000e640000205400ULL,
0x0000004c5c4c723cULL, 0x040f7000000418ffULL, 0x000000505c50723cULL, 0x000f6200000418ffULL,
0x000000847d00720bULL, 0x002fc40003f7d000ULL, 0x0000003b007d7306ULL, 0x000e6a0000205400ULL,
0x000000545c54723cULL, 0x040f7000000418ffULL, 0x000000885c5c723cULL, 0x000f6200000418ffULL,
0x0000000175753812ULL, 0x000fc400078efcffULL, 0x0000007d3a00720bULL, 0x002fca0003f7d000ULL,
0x000000383c40723cULL, 0x060b6e0000041840ULL, 0x0000007a9138723eULL, 0x020fe200000010ffULL,
0x0000007e3c44723cULL, 0x000f620000041844ULL, 0x000000789339723eULL, 0x000fe400000010ffULL,
0x000000769593723eULL, 0x000fc400000010ffULL, 0x0000008f7c7a723eULL, 0x000fe400000010ffULL,
0x000000907976723eULL, 0x000fe200000010ffULL, 0x000000383c48723cULL, 0x040b6e0000041848ULL,
0x0000003b00387245ULL, 0x020fe2000020d400ULL, 0x0000007a3c4c723cULL, 0x000b66000004184cULL,
0x0000000138383812ULL, 0x000fc800078efcffULL, 0x000000753875723eULL, 0x000fe200000010ffULL,
0x000000923c50723cULL, 0x040b700000041850ULL, 0x000000763c54723cULL, 0x040b700000041854ULL,
0x000000963c58723cULL, 0x040b700000041858ULL, 0x000000743c5c723cULL, 0x000b62000004185cULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x0000004013137221ULL, 0x000fe20000010000ULL, 0x0000004114147221ULL, 0x000fe20000010000ULL,
0x0000004417177221ULL, 0x000fe20000010000ULL, 0x0000004518187221ULL, 0x000fe20000010000ULL,
0x000000481b1b7221ULL, 0x000fe20000010000ULL, 0x000000491c1c7221ULL, 0x000fe20000010000ULL,
0x0000004c1f1f7221ULL, 0x020fe20000010000ULL, 0x0000004d20207221ULL, 0x000fe20000010000ULL,
0x0000005023237221ULL, 0x000fe20000010000ULL, 0x0000005124247221ULL, 0x000fe20000010000ULL,
0x0000005427277221ULL, 0x000fe20000010000ULL, 0x0000005528287221ULL, 0x000fe20000010000ULL,
0x000000582b2b7221ULL, 0x000fe20000010000ULL, 0x000000592c2c7221ULL, 0x000fe20000010000ULL,
0x0000005c2f2f7221ULL, 0x000fe20000010000ULL, 0x0000005d30307221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000001947ULL, 0x000fea0000000000ULL, 0x0000004215157221ULL, 0x000fe20000010000ULL,
0x0000004316167221ULL, 0x000fe20000010000ULL, 0x0000004619197221ULL, 0x000fe20000010000ULL,
0x000000471a1a7221ULL, 0x000fe20000010000ULL, 0x0000004a1d1d7221ULL, 0x000fe20000010000ULL,
0x0000004b1e1e7221ULL, 0x000fe20000010000ULL, 0x0000004e21217221ULL, 0x020fe20000010000ULL,
0x0000004f22227221ULL, 0x000fe20000010000ULL, 0x0000005225257221ULL, 0x000fe20000010000ULL,
0x0000005326267221ULL, 0x000fe20000010000ULL, 0x0000005629297221ULL, 0x000fe20000010000ULL,
0x000000572a2a7221ULL, 0x000fe20000010000ULL, 0x0000005a2d2d7221ULL, 0x000fe20000010000ULL,
0x0000005b2e2e7221ULL, 0x000fe20000010000ULL, 0x0000005e31317221ULL, 0x000fe20000010000ULL,
0x0000005f60607221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000172727810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8800ff387f8cULL, 0x000e62000c80043fULL, 0x000000707200720cULL, 0x000fe20003f06070ULL,
0x000000ffff3e7224ULL, 0x022fd800078e0039ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffff8d2000007947ULL, 0x000fea000383ffffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000800e387811ULL, 0x000fe200078e40ffULL, 0x010b6000ffff7f8cULL, 0x000fe6000c80043fULL,
0x000000613800720cULL, 0x000fda0003f06070ULL, 0x0000e6d000000947ULL, 0x000fea0003800000ULL,
0x000000ffff727224ULL, 0x000fca00078e00ffULL, 0x00000002ff397819ULL, 0x000fe20000011672ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000000372387812ULL, 0x040fe200078ec0ffULL,
0x000000ffff407224ULL, 0x000fe200078e00ffULL, 0x0000003972397207ULL, 0x000fe40002800000ULL,
0x000000ff38417207ULL, 0x000fe40006800000ULL, 0x00000002393b7810ULL, 0x000fc80007ffe0ffULL,
0x000000033b397812ULL, 0x040fe400078ec0ffULL, 0x0000000e3b387211ULL, 0x000fc400078ff0ffULL,
0x00000000003a7805ULL, 0x000fca0000015200ULL, 0x010b7c00ff3c7984ULL, 0x000e640000000800ULL,
0x800000003cff7812ULL, 0x002fe40007804871ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000017945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003c7805ULL, 0x000fcc0000015200ULL, 0x0000003c3a3f7210ULL, 0x000fca0007f1e1ffULL,
0x000000013d3d7824ULL, 0x000fe200000e0e3bULL, 0x003d09003f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3c7819ULL, 0x000fc8000001143dULL,
0x0000003f3c3c7211ULL, 0x000fca00078110ffULL, 0x000000ffff3d7224ULL, 0x000fca00000e063dULL,
0x000000023c3c7819ULL, 0x000fc8000000123dULL, 0x0000003c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000140407810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b7c00ff3c7984ULL, 0x000e640000000800ULL,
0x800000003cff7812ULL, 0x002fe40007804871ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fc40000015200ULL, 0x010b8c00ff3d7984ULL, 0x000e640000000800ULL,
0x800000003dff7812ULL, 0x002fe4000780483eULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff407224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003c7805ULL, 0x000fcc0000015200ULL,
0x0000003c3a3f7210ULL, 0x000fca0007f1e1ffULL, 0x000000013d3d7824ULL, 0x000fe200000e0e3bULL,
0x003d09003f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3c7819ULL, 0x000fc8000001143dULL, 0x0000003f3c3c7211ULL, 0x000fca00078110ffULL,
0x000000ffff3d7224ULL, 0x000fca00000e063dULL, 0x000000023c3c7819ULL, 0x000fc8000000123dULL,
0x0000003c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000140407810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8c00ff3d7984ULL, 0x000e640000000800ULL, 0x800000003dff7812ULL, 0x002fe4000780483eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000001383a7810ULL, 0x000fe20007ffe0ffULL,
0x0000099000017945ULL, 0x000fe60003800000ULL, 0x000000373a00720cULL, 0x000fda0003f06070ULL,
0x0000052000008947ULL, 0x000fea0003800000ULL, 0x0000000162437824ULL, 0x000fe200078e0205ULL,
0x0000002034407811ULL, 0x000fe200078e30ffULL, 0x00000004383a7824ULL, 0x000fe200078e0239ULL,
0x00000002054b7810ULL, 0x000fe20007ffe0ffULL, 0x00000010323e7824ULL, 0x000fe200078e00ffULL,
0x010a0000433c7984ULL, 0x000e620000004800ULL, 0x00000100ff457424ULL, 0x000fe200078e00ffULL,
0x000000203a3a7811ULL, 0x000fe200078e30ffULL, 0x0000001043427824ULL, 0x000fe200078e00ffULL,
0x000000f03e477812ULL, 0x000fe200078ec0ffULL, 0x00000001624d7824ULL, 0x000fe200078e024bULL,
0x0000003a613b7217ULL, 0x000fca0007800000ULL, 0x000000013b3b7824ULL, 0x000fe400078e0a3aULL,
0x00000001433a7824ULL, 0x000fc600078e0240ULL, 0x0000003b623b7217ULL, 0x000fca0007800000ULL,
0x000000013b3e7824ULL, 0x000fca00078e0a62ULL, 0x0000003e0500720cULL, 0x000fe20003f06070ULL,
0x010ac0003c3d7984ULL, 0x002e640000004800ULL, 0x0000003d0c3a7224ULL, 0x002fe400078e023aULL,
0x00000001433d7824ULL, 0x000fe400078e0232ULL, 0x00005e003a3a7625ULL, 0x000fca00078e0045ULL,
0x000000473a3c7210ULL, 0x000fe40007f3e0ffULL, 0xfffffff0423a7812ULL, 0x000fe200078ee23dULL,
0x000000014d427824ULL, 0x040fe400078e0232ULL, 0x000000ffff3d7224ULL, 0x000fe200008e063bULL,
0x0000e0003a497811ULL, 0x000fe200078e20ffULL, 0x000000014d3a7824ULL, 0x040fe400078e0240ULL,
0x000000104d4d7824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c497faeULL, 0x0003e2000c101c46ULL, 0x0000003e4b00720cULL, 0x000fc40003f06070ULL,
0xfffffff04d427812ULL, 0x000fe200078ee242ULL, 0x010a0800433f7984ULL, 0x000ea20000004800ULL,
0x00000004054b7810ULL, 0x000fca0007ffe0ffULL, 0x00000001624d7824ULL, 0x000fe200078e024bULL,
0x0000e00042497811ULL, 0x002fc600078e20ffULL, 0x000000014d427824ULL, 0x000fe200078e0232ULL,
0x010ac0003f3f7984ULL, 0x004e640000004800ULL, 0x0000003f0c3a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0045ULL, 0x000000473a3c7210ULL, 0x000fe20007f3e0ffULL,
0x000000014d3a7824ULL, 0x040fe400078e0240ULL, 0x000000104d4d7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fc600008e063bULL, 0xfffffff04d427812ULL, 0x000fe400078ee242ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c497faeULL, 0x0003e2000c101c46ULL,
0x0000003e4b00720cULL, 0x000fe40003f06070ULL, 0x00000006054b7810ULL, 0x000fe20007ffe0ffULL,
0x010a1000433f7984ULL, 0x000ea80000004800ULL, 0x00000001624d7824ULL, 0x000fe200078e024bULL,
0x0000e00042497811ULL, 0x002fe200078e20ffULL, 0x010ac0003f3f7984ULL, 0x004e640000004800ULL,
0x0000003f0c3a7224ULL, 0x002fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0045ULL,
0x000000473a3c7210ULL, 0x000fe20007f3e0ffULL, 0x000000014d3a7824ULL, 0x040fe400078e0240ULL,
0x000000014d407824ULL, 0x040fe400078e0232ULL, 0x000000ffff3d7224ULL, 0x000fe400008e063bULL,
0x000000104d4d7824ULL, 0x000fc600078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c497faeULL, 0x0003e2000c101c46ULL, 0x0000003e4b00720cULL, 0x000fe40003f06070ULL,
0xfffffff04d407812ULL, 0x000fe200078ee240ULL, 0x010a1800433f7984ULL, 0x000ea60000004800ULL,
0x0000e000403d7811ULL, 0x002fe200078e20ffULL, 0x010ac0003f3f7984ULL, 0x004e640000004800ULL,
0x0000003f0c3a7224ULL, 0x002fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0045ULL,
0x000000473a3a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fca00008e063bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e2000c101c46ULL,
0x0000044000007947ULL, 0x000fea0003800000ULL, 0x0000000162437824ULL, 0x000fe200078e0205ULL,
0x0000002034427811ULL, 0x000fe200078e30ffULL, 0x00000010323c7824ULL, 0x000fe400078e00ffULL,
0x00000100ff447424ULL, 0x000fe200078e00ffULL, 0x010a0000433e7984ULL, 0x000e620000004800ULL,
0x00000001433a7824ULL, 0x040fe200078e0242ULL, 0x000000f03c457812ULL, 0x000fe200078ec0ffULL,
0x00000001433d7824ULL, 0x040fe200078e0232ULL, 0x00000002433f7810ULL, 0x040fe20007ffe0ffULL,
0x0000001043407824ULL, 0x000fc800078e00ffULL, 0x000000013f467824ULL, 0x000fe200078e0232ULL,
0x010ac0003e3b7984ULL, 0x002e640000004800ULL, 0x0000003b0c3b7224ULL, 0x002fc800078e023aULL,
0x00005e003b3a7625ULL, 0x000fca00078e0044ULL, 0x000000453a3c7210ULL, 0x000fe40007f1e0ffULL,
0xfffffff0403a7812ULL, 0x000fc600078ee23dULL, 0x000000ffff3d7224ULL, 0x000fe200000e063bULL,
0x0000e0003a477811ULL, 0x000fe200078e20ffULL, 0x00000001423a7824ULL, 0x000fe400078e023fULL,
0x000000103f3f7824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c477faeULL, 0x0003e6000b901c46ULL, 0xfffffff03f467812ULL, 0x000fe200078ee246ULL,
0x010a080043407984ULL, 0x000ea60000004800ULL, 0x0000e00046477811ULL, 0x002fc400078e20ffULL,
0x00000004433d7810ULL, 0x000fca0007ffe0ffULL, 0x000000013d467824ULL, 0x000fe200078e0232ULL,
0x010ac000403b7984ULL, 0x004e640000004800ULL, 0x0000003b0c3b7224ULL, 0x002fc800078e023aULL,
0x00005e003b3a7625ULL, 0x000fca00078e0044ULL, 0x000000453a3e7210ULL, 0x000fe20007f1e0ffULL,
0x00000001423a7824ULL, 0x000fe400078e023dULL, 0x000000103d3d7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3f7224ULL, 0x000fc600000e063bULL, 0xfffffff03d467812ULL, 0x000fe400078ee246ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e477faeULL, 0x0003e8000b901c46ULL,
0x010a100043407984ULL, 0x000ea20000004800ULL, 0x0000e000463f7811ULL, 0x002fe400078e20ffULL,
0x0000000643477810ULL, 0x000fca0007ffe0ffULL, 0x0000000142427824ULL, 0x000fe200078e0247ULL,
0x010ac000403b7984ULL, 0x0042a40000004800ULL, 0x0000000147407824ULL, 0x042fe400078e0232ULL,
0x0000001047477824ULL, 0x000fca00078e00ffULL, 0xfffffff047407812ULL, 0x000fe200078ee240ULL,
0x0000003b0c3b7224ULL, 0x004fc800078e023aULL, 0x00005e003b3a7625ULL, 0x000fca00078e0044ULL,
0x000000453a3c7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff3d7224ULL, 0x000fca00000e063bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c3f7faeULL, 0x0003e8000b901c46ULL,
0x010a1800433e7984ULL, 0x000ea20000004800ULL, 0x0000e000403d7811ULL, 0x002fc600078e20ffULL,
0x010ac0003e3b7984ULL, 0x004e640000004800ULL, 0x0000003b0c3b7224ULL, 0x002fc800078e0242ULL,
0x00005e003b3a7625ULL, 0x000fca00078e0044ULL, 0x000000453a3a7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff3b7224ULL, 0x000fca00000e063bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a3d7faeULL, 0x0003e6000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8800ff3a7f8cULL, 0x002e64000c80043fULL,
0x000000ffff437224ULL, 0x002fc400078e003bULL, 0x00000000003a7805ULL, 0x000fca0000015200ULL,
0x010b8c00ff3c7984ULL, 0x000e640000000800ULL, 0x800000003cff7812ULL, 0x002fe40007804843ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff3e7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003c7805ULL, 0x000fcc0000015200ULL, 0x0000003c3a3f7210ULL, 0x000fca0007f1e1ffULL,
0x000000013d3d7824ULL, 0x000fe200000e0e3bULL, 0x003d09003f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3c7819ULL, 0x000fc8000001143dULL,
0x0000003f3c3c7211ULL, 0x000fca00078110ffULL, 0x000000ffff3d7224ULL, 0x000fca00000e063dULL,
0x000000023c3c7819ULL, 0x000fc8000000123dULL, 0x0000003c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8c00ff3c7984ULL, 0x000e640000000800ULL,
0x800000003cff7812ULL, 0x002fe40007804843ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000383500720cULL, 0x000fe20003f04070ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x000000034100780cULL, 0x000fda0003f25270ULL, 0x000000f000008947ULL, 0x000fea0000800000ULL,
0x000000030b00780cULL, 0x000fe40003f04070ULL, 0x000000010d0d7810ULL, 0x000fd60007ffe0ffULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x00000004363a7824ULL, 0x000fe200078e020bULL,
0x000064000d3b7a10ULL, 0x040fe20007ffe0ffULL, 0x00000004ff3d7424ULL, 0x000fe200078e00ffULL,
0x000000640d00720cULL, 0x000fe20003f06070ULL, 0x000000023a3a7824ULL, 0x000fe200078e00ffULL,
0x00010ac00b3f7811ULL, 0x000fc600078e10ffULL, 0x000064003a3a7a24ULL, 0x000fc800078e023bULL,
0x000060003a3a7625ULL, 0x000fca00078e003dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a3f7faeULL, 0x0003e4000c121846ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000018000017945ULL, 0x000fe20003800000ULL, 0x0000016000004947ULL, 0x000fea0003800000ULL,
0x000000383500720cULL, 0x000fe40003f04070ULL, 0x00000001413a7810ULL, 0x002fc80007ffe0ffULL,
0x000000033a3b7812ULL, 0x000fce00078ec0ffULL, 0x00000002ff3a8819ULL, 0x000fca000001163aULL,
0x0000000139397824ULL, 0x000fc800078e023aULL, 0x00000040393a7824ULL, 0x040fe200078e00ffULL,
0x0000003839387211ULL, 0x000fc800078ff0ffULL, 0x000000c03a397812ULL, 0x000fe400078ec0ffULL,
0x000000ff3b3a7207ULL, 0x000fe40004000000ULL, 0x00010a000b3b7811ULL, 0x000fe200078e10ffULL,
0x0000010038397824ULL, 0x000fe400078e0239ULL, 0x0000000163387824ULL, 0x000fe400078e023aULL,
0x000000010b3a7824ULL, 0x100fe400078e0239ULL, 0x0000680038387a24ULL, 0x000fc400078e0239ULL,
0x00000004ff397424ULL, 0x000fe200078e00ffULL, 0x000000613a00720cULL, 0x000fe20003f06070ULL,
0x000000010b387824ULL, 0x000fc800078e0238ULL, 0x0000660038387625ULL, 0x000fd000078e0039ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000383b7faeULL, 0x0003e4000c121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x010b8000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000ff7200720cULL, 0x000fe20003f05270ULL,
0x010b8000ff5c7f8cULL, 0x000e62000c80043fULL, 0x000007d000017945ULL, 0x000ff60003800000ULL,
0x000007b000000947ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b180062387f8cULL, 0x000ea4000c80043fULL, 0x000000ffff3c7224ULL, 0x004fc400078e0039ULL,
0x0000000000387805ULL, 0x000fca0000015200ULL, 0x010b1c0062097984ULL, 0x000ea40000000800ULL,
0x8000000009ff7812ULL, 0x004fc4000780483cULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000027945ULL, 0x000fe20003800000ULL, 0x000000ffff3d7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103d00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000037945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383a7210ULL, 0x000fca0007f1e1ffULL, 0x000000013b3b7824ULL, 0x000fe200000e0e39ULL,
0x003d09003a00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403a00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff097819ULL, 0x000fc8000001143bULL, 0x0000003a09097211ULL, 0x000fca00078110ffULL,
0x000000ffff3a7224ULL, 0x000fca00000e063bULL, 0x0000000209097819ULL, 0x000fc8000000123aULL,
0x000000090000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000037941ULL, 0x000fea0003800000ULL,
0x010b1c0062097984ULL, 0x000ea40000000800ULL, 0x8000000009ff7812ULL, 0x004fe4000780483cULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000001032097824ULL, 0x000fe200078e00ffULL,
0x00000001ff387819ULL, 0x000fc80000011632ULL, 0x0000007009097812ULL, 0x000fe400078ec0ffULL,
0x0000000c38387812ULL, 0x000fca00078ec0ffULL, 0x00000001093f7824ULL, 0x000fca00078e0238ULL,
0x010100003f3a7984ULL, 0x000ea80000000800ULL, 0x010300003f3b7984ULL, 0x0006620000000800ULL,
0x0000000f3a00720bULL, 0x004fe20003f1d000ULL, 0x00014fb27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000097806ULL, 0x008fc800000e0100ULL, 0x0000ffff09407812ULL, 0x000fe2000780c0ffULL,
0x0000043000027945ULL, 0x000fe20003800000ULL, 0x00000001ff097424ULL, 0x000fe400078e00ffULL,
0x000000ffff3c7224ULL, 0x000fd200078e000fULL, 0x000003f000008947ULL, 0x000fea0003800000ULL,
0x000000026500780cULL, 0x000fe40003f05270ULL, 0x0000000f3a00720bULL, 0x000fe20003f34000ULL,
0x00014f727f007947ULL, 0x000fd8000b800000ULL, 0x00000000003d7806ULL, 0x000fc400008e0100ULL,
0x0000003a0f3c7209ULL, 0x000fe20007810000ULL, 0x0000033000037945ULL, 0x000fe20003800000ULL,
0x000099103d387816ULL, 0x000fc600000000ffULL, 0x0105003c3f008388ULL, 0x0005e20000000800ULL,
0x000000ff3800720cULL, 0x000fda0003f05270ULL, 0x000002e000008947ULL, 0x000fea0003800000ULL,
0x8000003c0f0f7221ULL, 0x004fe20000010000ULL, 0x000000ff3dff7812ULL, 0x000fe2000780c0ffULL,
0x0000017000047945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b0f0f7820ULL, 0x000fc80000410000ULL,
0x0000000f00417308ULL, 0x000ea40000000800ULL, 0x0000004112127220ULL, 0x004fc80000410000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00014ec27f007947ULL, 0x000fea000b800000ULL,
0x00001f69410f7589ULL, 0x0004e400000e0000ULL, 0x0000000f13137220ULL, 0x088fe20000410000ULL,
0x0000000f14147220ULL, 0x080fe20000410000ULL, 0x0000000f17177220ULL, 0x080fe20000410000ULL,
0x0000000f18187220ULL, 0x080fe20000410000ULL, 0x0000000f1b1b7220ULL, 0x080fe20000410000ULL,
0x0000000f1c1c7220ULL, 0x080fe20000410000ULL, 0x0000000f1f1f7220ULL, 0x080fe20000410000ULL,
0x0000000f20207220ULL, 0x080fe20000410000ULL, 0x0000000f23237220ULL, 0x080fe20000410000ULL,
0x0000000f24247220ULL, 0x080fe20000410000ULL, 0x0000000f27277220ULL, 0x080fe20000410000ULL,
0x0000000f28287220ULL, 0x080fe20000410000ULL, 0x0000000f2b2b7220ULL, 0x080fe20000410000ULL,
0x0000000f2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000f2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000f30307220ULL, 0x000fc40000410000ULL, 0x0000000000047941ULL, 0x000fea0003800000ULL,
0x0000ff003dff7812ULL, 0x000fda000780c0ffULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x00014dd27f007947ULL, 0x000fea000b800000ULL, 0x00001f68410f7589ULL, 0x0006a400000e0000ULL,
0x0000000f15157220ULL, 0x084fe20000410000ULL, 0x0000000f16167220ULL, 0x080fe20000410000ULL,
0x0000000f19197220ULL, 0x080fe20000410000ULL, 0x0000000f1a1a7220ULL, 0x080fe20000410000ULL,
0x0000000f1d1d7220ULL, 0x080fe20000410000ULL, 0x0000000f1e1e7220ULL, 0x080fe20000410000ULL,
0x0000000f21217220ULL, 0x080fe20000410000ULL, 0x0000000f22227220ULL, 0x080fe20000410000ULL,
0x0000000f25257220ULL, 0x080fe20000410000ULL, 0x0000000f26267220ULL, 0x080fe20000410000ULL,
0x0000000f29297220ULL, 0x080fe20000410000ULL, 0x0000000f2a2a7220ULL, 0x080fe20000410000ULL,
0x0000000f2d2d7220ULL, 0x080fe20000410000ULL, 0x0000000f2e2e7220ULL, 0x080fe20000410000ULL,
0x0000000f31317220ULL, 0x080fe20000410000ULL, 0x0000000f60607220ULL, 0x000fc40000410000ULL,
0x0000000000037941ULL, 0x004fea0003800000ULL, 0x0000ffff40ff7812ULL, 0x000fda000780603dULL,
0x8000003c3a3a0221ULL, 0x000fe20000010000ULL, 0x00007610ff090816ULL, 0x000fc60000000009ULL,
0x3fb8aa3b3a3a0820ULL, 0x000fc80000410000ULL, 0x0000003a00080308ULL, 0x000ea40000000800ULL,
0x000000083b3b0220ULL, 0x006fcc0000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x000000123b127221ULL, 0x002fe20000010000ULL, 0x000000ffff0f7224ULL, 0x000fc400078e003cULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ff09ff7812ULL, 0x000fe2000786c0ffULL,
0x0000012000017945ULL, 0x000fd80003800000ULL, 0x0000010000003947ULL, 0x000fea0003800000ULL,
0x00000008ff06723eULL, 0x000fc800000010ffULL, 0x00005410063a7816ULL, 0x000fe20000000006ULL,
0x00014c127f007947ULL, 0x000fea000b800000ULL, 0x00001f693a077589ULL, 0x0004e400000e0000ULL,
0x00014c527f007947ULL, 0x000fea000b800000ULL, 0x00001f683a067589ULL, 0x0004e400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000010693f7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff3e7224ULL, 0x000fe200078e003aULL, 0x0001239000387802ULL, 0x000fc40000000f00ULL,
0x0001552000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000ffff3e7224ULL, 0x004fe200078e003aULL, 0x00000018693f7810ULL, 0x002fe40007ffe0ffULL,
0x000123e000387802ULL, 0x000fc40000000f00ULL, 0x000154d000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000000440783bULL, 0x008ee20000004200ULL, 0x00001e9000017945ULL, 0x000fe60003800000ULL,
0x000000000244783bULL, 0x000f280000004200ULL, 0x000000000038783bULL, 0x004ea80000004200ULL,
0x00000000033c783bULL, 0x002e620000004200ULL, 0x0000010040ae7824ULL, 0x008fe200078e00ffULL,
0x0000004000b47306ULL, 0x000fe20000009400ULL, 0x00000018ffd07819ULL, 0x000fe20000011440ULL,
0x0000010042cf7824ULL, 0x040fe200078e00ffULL, 0x00000018ffbd7819ULL, 0x000fe20000011441ULL,
0x0001000042ca7824ULL, 0x000fe200078e00ffULL, 0x00000018ffb87819ULL, 0x000fe200000114aeULL,
0x0001000040ae7824ULL, 0x000fe200078e00ffULL, 0x00000018ffcf7819ULL, 0x000fe200000114cfULL,
0x0000004000b77306ULL, 0x000ee20000005400ULL, 0x0000010043c87824ULL, 0x040fe200078e00ffULL,
0x00000018ffca7819ULL, 0x000fe200000114caULL, 0x0001000043c37824ULL, 0x000fe200078e00ffULL,
0x00000018ffbe7819ULL, 0x000fe200000114aeULL, 0x0000010041ae7824ULL, 0x040fe200078e00ffULL,
0x00000018ffc87819ULL, 0x000fe200000114c8ULL, 0x0000010044c17824ULL, 0x050fe200078e00ffULL,
0x0000004000977306ULL, 0x000f22000000d400ULL, 0x00000018ffac7819ULL, 0x000fe20000011442ULL,
0x0001000044b67824ULL, 0x000fe200078e00ffULL, 0x00000018ffd57819ULL, 0x000fe200000114aeULL,
0x0001000041ae7824ULL, 0x000fe200078e00ffULL, 0x00000018ff8b7819ULL, 0x000fe20000011443ULL,
0x0000010045b17824ULL, 0x000fe200078e00ffULL, 0x00000018ff9d7819ULL, 0x000fe20000011446ULL,
0x000000b800b97306ULL, 0x000fe20000209400ULL, 0x000000b7b400720bULL, 0x008fc40003f1d000ULL,
0x00000018ffd77819ULL, 0x000fe200000114aeULL, 0x0001000045ae7824ULL, 0x000fe200078e00ffULL,
0x00000018ff547819ULL, 0x000fe40000011447ULL, 0x000000d000b47245ULL, 0x000fe2000020d400ULL,
0x000000b800407306ULL, 0x000ee20000205400ULL, 0x00000018ffc37819ULL, 0x000fe400000114c3ULL,
0x00000018ffc17819ULL, 0x000fe400000114c1ULL, 0x00000018ffb67819ULL, 0x000fc400000114b6ULL,
0x0000000197970812ULL, 0x010fe200078efcffULL, 0x000000be00bc7306ULL, 0x000fe20000209400ULL,
0x00000018ff8d7819ULL, 0x000fe40000011444ULL, 0x00000018ffb17819ULL, 0x000fe400000114b1ULL,
0x00000018ffae7819ULL, 0x000fe400000114aeULL, 0x00000018ffa37819ULL, 0x000fe20000011445ULL,
0x000000be00cb7306ULL, 0x000f220000205400ULL, 0x00000040b900720bULL, 0x008fe20003f3d000ULL,
0x0001000047b97824ULL, 0x000fe200078e00ffULL, 0x000000b800407245ULL, 0x000fc4000020d400ULL,
0x000000d500b87245ULL, 0x000fe4000020d400ULL, 0x00000018ff827819ULL, 0x004fe20000011438ULL,
0x0000004100d37306ULL, 0x000fe20000009400ULL, 0x00000018ffb97819ULL, 0x000fe400000114b9ULL,
0x00000018ff987819ULL, 0x002fe4000001143cULL, 0x00000018ff5b7819ULL, 0x000fe4000001143dULL,
0x0000000140401812ULL, 0x000fe200078efcffULL, 0x0000004100d47306ULL, 0x000e620000005400ULL,
0x000000cbbc00720bULL, 0x010fc40003f5d000ULL, 0x00000018ff4c7819ULL, 0x000fe4000001143eULL,
0x00000018ff5c7819ULL, 0x000fe4000001143aULL, 0x00000018ff4e7819ULL, 0x000fe2000001143fULL,
0x00000041008f7306ULL, 0x000ea2000000d400ULL, 0x00000018ff7b7819ULL, 0x000fe40000011439ULL,
0x00000018ff5e7819ULL, 0x000fca000001143bULL, 0x000000d500d67306ULL, 0x000fe20000209400ULL,
0x000000d4d300720bULL, 0x002fce0003f1d000ULL, 0x000000d500417306ULL, 0x000e6c0000205400ULL,
0x000000018f8f0812ULL, 0x004fe400078efcffULL, 0x000000d000d17306ULL, 0x000ff00000209400ULL,
0x000000d000d27306ULL, 0x000ea20000205400ULL, 0x00000041d600720bULL, 0x002fc40003f3d000ULL,
0x000000be00417245ULL, 0x000fc8000020d400ULL, 0x0000000141412812ULL, 0x000fe200078efcffULL,
0x000000d700d87306ULL, 0x000fec0000209400ULL, 0x00000001b8b81812ULL, 0x000fe400078efcffULL,
0x000000d700d97306ULL, 0x000e620000205400ULL, 0x000000d2d100720bULL, 0x004fce0003fdd000ULL,
0x000000cf00da7306ULL, 0x000fec0000209400ULL, 0x00000001b4b46812ULL, 0x000fe400078efcffULL,
0x000000cf00db7306ULL, 0x000ea20000205400ULL, 0x000000d9d800720bULL, 0x002fce0003f5d000ULL,
0x0000004200ba7306ULL, 0x000ff00000009400ULL, 0x0000004200bb7306ULL, 0x000e620000005400ULL,
0x000000dbda00720bULL, 0x004fce0003f3d000ULL, 0x000000bd00bf7306ULL, 0x000ff00000209400ULL,
0x000000bd00c07306ULL, 0x0004e20000205400ULL, 0x000000bbba00720bULL, 0x002fe40003f1d000ULL,
0x000000cf00bb7245ULL, 0x000fc4000020d400ULL, 0x000000bd00ba7245ULL, 0x000fe4000020d400ULL,
0x00000001bbbb1812ULL, 0x000fe200078efcffULL, 0x000000ca00dc7306ULL, 0x000fe20000209400ULL,
0x000000ca00bd7245ULL, 0x004fce000020d400ULL, 0x000000ca00dd7306ULL, 0x000fe20000205400ULL,
0x000000c0bf00720bULL, 0x008fe40003fdd000ULL, 0x000000ac00c07245ULL, 0x000fca000020d400ULL,
0x0000004200587306ULL, 0x0002ac000000d400ULL, 0x00000001baba6812ULL, 0x000fe400078efcffULL,
0x0000004300af7306ULL, 0x000fe20000009400ULL, 0x0001000046427824ULL, 0x002fca00078e00ffULL,
0x00000018ff427819ULL, 0x000fe40000011442ULL, 0x00000043008e7306ULL, 0x000e620000005400ULL,
0x0000000158580812ULL, 0x004fc800078efcffULL, 0x00000058bb58723eULL, 0x000fc600000010ffULL,
0x0000004300597306ULL, 0x0004f0000000d400ULL, 0x000000c800ce7306ULL, 0x000fe20000209400ULL,
0x0000010046437824ULL, 0x004fe200078e00ffULL, 0x0000008eaf00720bULL, 0x002fc80003f1d000ULL,
0x00000018ff437819ULL, 0x000fe40000011443ULL, 0x000000c800df7306ULL, 0x000e6e0000205400ULL,
0x0000000159590812ULL, 0x008fe200078efcffULL, 0x0000004600a47306ULL, 0x000ff00000009400ULL,
0x0000004600a57306ULL, 0x000fe20000005400ULL, 0x000000dfce00720bULL, 0x002fce0003f3d000ULL,
0x0000004600817306ULL, 0x0003f0000000d400ULL, 0x00000047009f7306ULL, 0x000fe20000009400ULL,
0x0000010047467824ULL, 0x002fca00078e00ffULL, 0x00000018ff467819ULL, 0x000fe40000011446ULL,
0x0000004700a07306ULL, 0x000ff00000005400ULL, 0x0000004700807306ULL, 0x0003f0000000d400ULL,
0x000000ac00857306ULL, 0x000fe20000209400ULL, 0x0000010038477824ULL, 0x002fca00078e00ffULL,
0x00000018ffbf7819ULL, 0x000fe40000011447ULL, 0x000000ac00887306ULL, 0x0002a20000205400ULL,
0x000000d700477245ULL, 0x000fc8000020d400ULL, 0x0000000147472812ULL, 0x000fe400078efcffULL,
0x000000dddc00720bULL, 0x000fe20003f5d000ULL, 0x000000c300cc7306ULL, 0x000fe20000209400ULL,
0x000000c800ac7245ULL, 0x002fc8000020d400ULL, 0x00000001acac1812ULL, 0x000fc600078efcffULL,
0x000000c300cd7306ULL, 0x000e620000205400ULL, 0x000000888500720bULL, 0x004fe40003fdd000ULL,
0x00000059ac59723eULL, 0x000fe400000010ffULL, 0x00000001bdbd2812ULL, 0x000fc600078efcffULL,
0x0000008b00ad7306ULL, 0x000fec0000209400ULL, 0x00000001c0c06812ULL, 0x000fe400078efcffULL,
0x0000008b008a7306ULL, 0x000ea20000205400ULL, 0x000000cdcc00720bULL, 0x002fce0003f5d000ULL,
0x000000c100c67306ULL, 0x000ff00000209400ULL, 0x000000c100c97306ULL, 0x000e620000205400ULL,
0x0000008aad00720bULL, 0x004fe40003f3d000ULL, 0x0000008b00ad7245ULL, 0x000fc4000020d400ULL,
0x000000c1008b7245ULL, 0x000fc6000020d400ULL, 0x0000004400aa7306ULL, 0x000fec0000009400ULL,
0x00000001adad1812ULL, 0x000fe400078efcffULL, 0x0000004400897306ULL, 0x000ea20000005400ULL,
0x000000c9c600720bULL, 0x002fce0003f1d000ULL, 0x000000b600c47306ULL, 0x000fec0000209400ULL,
0x000000018b8b0812ULL, 0x000fe400078efcffULL, 0x000000b600c57306ULL, 0x000e620000205400ULL,
0x00000089aa00720bULL, 0x004fe40003fdd000ULL, 0x000000c300aa7245ULL, 0x000fc8000020d400ULL,
0x00000001aaaa2812ULL, 0x000fe200078efcffULL, 0x00000045008c7306ULL, 0x000ff00000009400ULL,
0x0000004500a97306ULL, 0x000ea20000005400ULL, 0x000000c5c400720bULL, 0x002fce0003f5d000ULL,
0x0000008d00a87306ULL, 0x000ff00000209400ULL, 0x0000008d00ab7306ULL, 0x0002e20000205400ULL,
0x000000a98c00720bULL, 0x004fe40003f3d000ULL, 0x000000b6008c7245ULL, 0x000fc8000020d400ULL,
0x000000018c8c2812ULL, 0x000fe200078efcffULL, 0x0000004400847306ULL, 0x000ea2000000d400ULL,
0x0000008d008d7245ULL, 0x002fce000020d400ULL, 0x000000b100c27306ULL, 0x000fe20000209400ULL,
0x000000aba800720bULL, 0x008fe20003f1d000ULL, 0x000100003ca87824ULL, 0x000fca00078e00ffULL,
0x00000018ffa97819ULL, 0x000fe200000114a8ULL, 0x000000b100c77306ULL, 0x000e620000205400ULL,
0x0000000184846812ULL, 0x004fe400078efcffULL, 0x000000b100a87245ULL, 0x000fe4000020d400ULL,
0x000000848b84723eULL, 0x000fe400000010ffULL, 0x000000018d8d0812ULL, 0x000fe200078efcffULL,
0x000000ae00b57306ULL, 0x000fe20000209400ULL, 0x000000a5a400720bULL, 0x000fe20003f1d000ULL,
0x000001003da47824ULL, 0x000fca00078e00ffULL, 0x00000018ffa57819ULL, 0x000fe200000114a4ULL,
0x000000ae00b27306ULL, 0x0004e20000205400ULL, 0x000000c7c200720bULL, 0x002fe40003fdd000ULL,
0x0000004300a47245ULL, 0x000fc6000020d400ULL, 0x0000000181810812ULL, 0x000fe400078efcffULL,
0x0000004500837306ULL, 0x000e62000000d400ULL, 0x000000ae00ae7245ULL, 0x004fca000020d400ULL,
0x00000001a8a86812ULL, 0x000fe400078efcffULL, 0x0000004300b07306ULL, 0x000fe20000209400ULL,
0x000000b2b500720bULL, 0x008fce0003f5d000ULL, 0x0000004300b37306ULL, 0x000ea20000205400ULL,
0x0000000183831812ULL, 0x002fca00078efcffULL, 0x00000001aeae2812ULL, 0x000fe400078efcffULL,
0x000000a300a67306ULL, 0x000ff00000209400ULL, 0x000000a300a77306ULL, 0x0002e20000205400ULL,
0x000000b3b000720bULL, 0x004fe20003f3d000ULL, 0x000100003ab07824ULL, 0x000fca00078e00ffULL,
0x00000018ffb07819ULL, 0x000fe200000114b0ULL, 0x0000004200447306ULL, 0x000fe20000209400ULL,
0x000000a300a37245ULL, 0x002fca000020d400ULL, 0x00000001a4a41812ULL, 0x000fe400078efcffULL,
0x0000004200457306ULL, 0x000e620000205400ULL, 0x000000a7a600720bULL, 0x008fce0003fdd000ULL,
0x0000009d00a17306ULL, 0x000fec0000209400ULL, 0x00000001a3a36812ULL, 0x000fe400078efcffULL,
0x0000009d00a27306ULL, 0x0004e20000205400ULL, 0x000000454400720bULL, 0x002fe40003f5d000ULL,
0x000000a09f00720bULL, 0x000fc40003fdd000ULL, 0x00000042009f7245ULL, 0x000fe4000020d400ULL,
0x0000009d00a07245ULL, 0x000fe2000020d400ULL, 0x0000003800917306ULL, 0x000fe20000009400ULL,
0x00000046009d7245ULL, 0x004fca000020d400ULL, 0x000000019f9f2812ULL, 0x000fe400078efcffULL,
0x0000003800967306ULL, 0x000fe20000005400ULL, 0x000000a2a100720bULL, 0x008fe40003f3d000ULL,
0x0000000180806812ULL, 0x000fe400078efcffULL, 0x000000bf00a27245ULL, 0x000fc6000020d400ULL,
0x0000003800777306ULL, 0x0003ec000000d400ULL, 0x00000001a0a01812ULL, 0x000fe400078efcffULL,
0x0000004600b77306ULL, 0x000fe20000209400ULL, 0x0001000038387824ULL, 0x002fe200078e00ffULL,
0x0000009fa0a0723eULL, 0x000fc800000010ffULL, 0x00000018ff887819ULL, 0x000fe20000011438ULL,
0x0000010039387824ULL, 0x000fe200078e00ffULL, 0x0000004600bc7306ULL, 0x0002a80000205400ULL,
0x00000018ff897819ULL, 0x000fe20000011438ULL, 0x000001003c387824ULL, 0x000fc600078e00ffULL,
0x000000b900be7306ULL, 0x000fe20000209400ULL, 0x000001003e467824ULL, 0x002fe200078e00ffULL,
0x00000018ff387819ULL, 0x000fc80000011438ULL, 0x00000018ffa17819ULL, 0x000fe40000011446ULL,
0x000000b900cb7306ULL, 0x0002e20000205400ULL, 0x000000bcb700720bULL, 0x004fe40003f1d000ULL,
0x000000a500467245ULL, 0x000fca000020d400ULL, 0x0000005400577306ULL, 0x000fe20000209400ULL,
0x000000b900b97245ULL, 0x002fca000020d400ULL, 0x000000019d9d0812ULL, 0x000fe400078efcffULL,
0x00000054009e7306ULL, 0x000e620000205400ULL, 0x000000cbbe00720bULL, 0x008fe40003f5d000ULL,
0x000000809d9d723eULL, 0x000fca00000010ffULL, 0x000000bf00d07306ULL, 0x000fec0000209400ULL,
0x00000001b9b92812ULL, 0x000fe400078efcffULL, 0x000000bf00cf7306ULL, 0x000ea20000205400ULL,
0x0000009e5700720bULL, 0x002fe40003f3d000ULL, 0x00000054009e7245ULL, 0x000fca000020d400ULL,
0x0000003c00557306ULL, 0x000fec0000009400ULL, 0x000000019e9e1812ULL, 0x000fe400078efcffULL,
0x0000003c00567306ULL, 0x000e620000005400ULL, 0x000000cfd000720bULL, 0x004fce0003f1d000ULL,
0x0000003c00487306ULL, 0x000eac000000d400ULL, 0x00000001a2a20812ULL, 0x000fe400078efcffULL,
0x0000003800af7306ULL, 0x000fe20000209400ULL, 0x000000565500720bULL, 0x002fe40003fdd000ULL,
0x0000b00067557811ULL, 0x000fca00078e20ffULL, 0x00000038003c7306ULL, 0x000e620000205400ULL,
0x000000005554783bULL, 0x000eea0000000200ULL, 0x0000000148486812ULL, 0x004fe400078efcffULL,
0x000000a900ab7306ULL, 0x000ff00000209400ULL, 0x000000a900a67306ULL, 0x0005220000205400ULL,
0x0000003caf00720bULL, 0x002fe20003f5d000ULL, 0x000001003aaf7824ULL, 0x000fca00078e00ffULL,
0x00000018ffaf7819ULL, 0x000fe200000114afULL, 0x0000003d009b7306ULL, 0x000fe20000009400ULL,
0x000000a900a97245ULL, 0x004fce000020d400ULL, 0x0000003d009a7306ULL, 0x000e620000005400ULL,
0x000000a6ab00720bULL, 0x010fe20003f3d000ULL, 0x0001000039ab7824ULL, 0x000fca00078e00ffULL,
0x00000018ffab7819ULL, 0x000fe200000114abULL, 0x0000003d00497306ULL, 0x000522000000d400ULL,
0x000000075454b231ULL, 0x088fe400003400ffULL, 0x000000075656b231ULL, 0x000fe400003400ffULL,
0x000000065555b231ULL, 0x080fe200003400ffULL, 0x00000001a9a91812ULL, 0x000fe200078efcffULL,
0x000000065757b231ULL, 0x000fe200003400ffULL, 0x00000098009c7306ULL, 0x000fe20000209400ULL,
0x000100003d3d7824ULL, 0x004fe200078e00ffULL, 0x0000009a9b00720bULL, 0x002fc40003f1d000ULL,
0x00000038009b7245ULL, 0x000fe2000020d400ULL, 0x000001003f387824ULL, 0x000fe200078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000009800997306ULL, 0x0002a20000205400ULL,
0x000000019b9b2812ULL, 0x000fe400078efcffULL, 0x00000098009a7245ULL, 0x000fe4000020d400ULL,
0x00000018ffa67819ULL, 0x000fe40000011438ULL, 0x0000000149490812ULL, 0x010fe200078efcffULL,
0x000000a500437306ULL, 0x000fe20000209400ULL, 0x00000041b438723eULL, 0x000fe200000010ffULL,
0x000100003b987824ULL, 0x002fe200078e00ffULL, 0x000000489b48723eULL, 0x000fc800000010ffULL,
0x00000018ff987819ULL, 0x000fe20000011498ULL, 0x000000a500447306ULL, 0x000e620000205400ULL,
0x000000999c00720bULL, 0x004fe20003fdd000ULL, 0x000001003b997824ULL, 0x000fe200078e00ffULL,
0x0000009800b17245ULL, 0x000fc8000020d400ULL, 0x00000018ff997819ULL, 0x000fe20000011499ULL,
0x0000003d00427306ULL, 0x000fec0000209400ULL, 0x000000019a9a6812ULL, 0x000fe400078efcffULL,
0x0000003d00457306ULL, 0x0004e20000205400ULL, 0x000000444300720bULL, 0x002fc40003f5d000ULL,
0x000000969100720bULL, 0x000fe40003fdd000ULL, 0x0000003d00917245ULL, 0x000fe4000020d400ULL,
0x000000bdc044723eULL, 0x000fe200000010ffULL, 0x0000005b00957306ULL, 0x000fe20000209400ULL,
0x0000008fb83d723eULL, 0x004fca00000010ffULL, 0x0000000146462812ULL, 0x000fe400078efcffULL,
0x0000005b00947306ULL, 0x000e620000205400ULL, 0x000000454200720bULL, 0x008fe40003f3d000ULL,
0x000000aaad45723eULL, 0x000fe400000010ffULL, 0x000000494649723eULL, 0x000fe400000010ffULL,
0x0000000177776812ULL, 0x000fe200078efcffULL, 0x000000a1003c7306ULL, 0x000fe60000209400ULL,
0x00000077a2a2723eULL, 0x000fc600000010ffULL, 0x0000000191911812ULL, 0x000fe400078efcffULL,
0x000000a100a77306ULL, 0x0004e20000205400ULL, 0x000000949500720bULL, 0x002fce0003f5d000ULL,
0x0000003e00937306ULL, 0x000fe20000009400ULL, 0x000000a100a17245ULL, 0x004fce000020d400ULL,
0x0000003e00927306ULL, 0x000e620000005400ULL, 0x000000a73c00720bULL, 0x008fe40003f3d000ULL,
0x00000097403c723eULL, 0x000fe400000010ffULL, 0x0000b00066407811ULL, 0x000fc600078e20ffULL,
0x0000003e00507306ULL, 0x0004ec000000d400ULL, 0x00000001a1a11812ULL, 0x000fe400078efcffULL,
0x0000003f004d7306ULL, 0x000fe20000009400ULL, 0x000100003e3e7824ULL, 0x004fe200078e00ffULL,
0x000000929300720bULL, 0x002fc40003f1d000ULL, 0x0000005b00927245ULL, 0x000fe4000020d400ULL,
0x00000018ff9c7819ULL, 0x000fe4000001143eULL, 0x0000003f005a7306ULL, 0x000e620000005400ULL,
0x0000000192922812ULL, 0x000fcc00078efcffULL, 0x0000000150500812ULL, 0x008fe200078efcffULL,
0x0000003a007d7306ULL, 0x000fe60000009400ULL, 0x00000050a150723eULL, 0x000fe400000010ffULL,
0x000000b99ea1723eULL, 0x000fc600000010ffULL, 0x0000003a007c7306ULL, 0x000fe20000005400ULL,
0x0000005a4d00720bULL, 0x002fe40003f5d000ULL, 0x000000585458723cULL, 0x000f6a00000418ffULL,
0x0000003a00717306ULL, 0x000ff0000000d400ULL, 0x0000009c00437306ULL, 0x000ff00000209400ULL,
0x0000009c003a7306ULL, 0x0002b00000205400ULL, 0x0000004c00877306ULL, 0x000fe20000209400ULL,
0x0000009c009c7245ULL, 0x002fce000020d400ULL, 0x0000004c00907306ULL, 0x000e620000205400ULL,
0x0000003a4300720bULL, 0x004fe40003f3d000ULL, 0x000000004040783bULL, 0x000eaa0000000200ULL,
0x0000003f00517306ULL, 0x00072c000000d400ULL, 0x000000019c9c1812ULL, 0x000fc400078efcffULL,
0x000000a600967306ULL, 0x000fe20000209400ULL, 0x000100003f3f7824ULL, 0x008fe200078e00ffULL,
0x000000908700720bULL, 0x002fe40003f1d000ULL, 0x0000004c00877245ULL, 0x000fe4000020d400ULL,
0x00000018ff8f7819ULL, 0x000fe4000001143fULL, 0x000000a600937306ULL, 0x0002e20000205400ULL,
0x0000000151512812ULL, 0x010fe200078efcffULL, 0x0000003c543c723cULL, 0x000f6200000418ffULL,
0x0000004e00907245ULL, 0x000fc4000020d400ULL, 0x000000a99a4c723eULL, 0x000fe400000010ffULL,
0x0000000187870812ULL, 0x000fe200078efcffULL, 0x0000004e004a7306ULL, 0x000fe20000209400ULL,
0x000000a600a67245ULL, 0x002fce000020d400ULL, 0x0000004e004b7306ULL, 0x000e620000205400ULL,
0x000000939600720bULL, 0x008fe20003f3d000ULL, 0x000000074040b231ULL, 0x084fe400003400ffULL,
0x000000074242b231ULL, 0x000fe400003400ffULL, 0x000000064141b231ULL, 0x080fe400003400ffULL,
0x0000008f00947306ULL, 0x000fe20000209400ULL, 0x000000064343b231ULL, 0x000fca00003400ffULL,
0x00000001a6a61812ULL, 0x000fe400078efcffULL, 0x0000008f004d7306ULL, 0x0004e20000205400ULL,
0x0000004b4a00720bULL, 0x002fe40003f1d000ULL, 0x00000051a651723eULL, 0x000fe200000010ffULL,
0x000000485448723cULL, 0x000fe800000418ffULL, 0x0000003900867306ULL, 0x000fe20000009400ULL,
0x0000008f008f7245ULL, 0x004fca000020d400ULL, 0x0000000190900812ULL, 0x000fe400078efcffULL,
0x00000039004f7306ULL, 0x000e620000005400ULL, 0x0000004d9400720bULL, 0x008fe40003f5d000ULL,
0x00000091924d723eULL, 0x000fca00000010ffULL, 0x00000089008a7306ULL, 0x000fec0000209400ULL,
0x000000018f8f2812ULL, 0x000fe400078efcffULL, 0x0000008900957306ULL, 0x000ea20000205400ULL,
0x0000004f8600720bULL, 0x002fe40003f3d000ULL, 0x0000009c8786723eULL, 0x000fe200000010ffULL,
0x0000004c544c723cULL, 0x000fe200000418ffULL, 0x0000008f9087723eULL, 0x000fc400000010ffULL,
0x00000081a49c723eULL, 0x000fe200000010ffULL, 0x0000008200537306ULL, 0x000fec0000209400ULL,
0x0000009c4058723cULL, 0x020fe40000041858ULL, 0x0000008200527306ULL, 0x000e620000205400ULL,
0x000000958a00720bULL, 0x004fce0003fdd000ULL, 0x0000008800857306ULL, 0x000ff00000209400ULL,
0x00000088008e7306ULL, 0x0004e20000205400ULL, 0x000000525300720bULL, 0x002fe40003f5d000ULL,
0x000000505450723cULL, 0x000fea00000418ffULL, 0x0000003900787306ULL, 0x000322000000d400ULL,
0x0000008800887245ULL, 0x004fce000020d400ULL, 0x0000007b007f7306ULL, 0x000fe20000209400ULL,
0x00000047ba39723eULL, 0x002fe400000010ffULL, 0x0000008e8500720bULL, 0x008fe20003f1d000ULL,
0x000000445444723cULL, 0x000f6200000418ffULL, 0x00000083a885723eULL, 0x000fe400000010ffULL,
0x0000008200837245ULL, 0x000fe2000020d400ULL, 0x0000007b007e7306ULL, 0x000fe20000205400ULL,
0x0000000178781812ULL, 0x010fe400078efcffULL, 0x0000000183832812ULL, 0x000fe200078efcffULL,
0x00000084403c723cULL, 0x000fe2000004183cULL, 0x0000007c7d00720bULL, 0x000fc40003f5d000ULL,
0x0000007b007c7245ULL, 0x000fe2000020d400ULL, 0x000000ab00937306ULL, 0x000fe20000209400ULL,
0x0000000188880812ULL, 0x000fc800078efcffULL, 0x000000888388723eULL, 0x000fc600000010ffULL,
0x000000ab00947306ULL, 0x000e640000205400ULL, 0x0000000171712812ULL, 0x000fe400078efcffULL,
0x000000a04044723cULL, 0x020fe80000041844ULL, 0x0000003b00797306ULL, 0x000ff00000009400ULL,
0x0000003b007a7306ULL, 0x000fe20000005400ULL, 0x000000949300720bULL, 0x002fce0003f1d000ULL,
0x0000003b005f7306ULL, 0x0003f0000000d400ULL, 0x000000af00917306ULL, 0x000fe20000209400ULL,
0x000000385438723cULL, 0x042f6e00000418ffULL, 0x000000af00927306ULL, 0x000e620000205400ULL,
0x000000865454723cULL, 0x000b6e00000418ffULL, 0x000000aea387723eULL, 0x020fe200000010ffULL,
0x00000099008a7306ULL, 0x000fe20000209400ULL, 0x0000008900a37245ULL, 0x000fc4000020d400ULL,
0x000000ab00897245ULL, 0x000fe4000020d400ULL, 0x00000001a3a36812ULL, 0x000fe400078efcffULL,
0x0000007e7f00720bULL, 0x000fe20003fdd000ULL, 0x00000099008b7306ULL, 0x000ea20000205400ULL,
0x0000000189890812ULL, 0x000fe400078efcffULL, 0x000000929100720bULL, 0x002fe40003f3d000ULL,
0x00000078a3a3723eULL, 0x000fc400000010ffULL, 0x0000009900787245ULL, 0x000fe2000020d400ULL,
0x0000005e00757306ULL, 0x000fe20000209400ULL, 0x0000008c8d86723eULL, 0x000fc600000010ffULL,
0x000000017c7c6812ULL, 0x000fe200078efcffULL, 0x000000a24048723cULL, 0x040b620000041848ULL,
0x0000007a7900720bULL, 0x000fe40003fdd000ULL, 0x0000005e00767306ULL, 0x0002e20000205400ULL,
0x0000008b8a00720bULL, 0x004fe40003f1d000ULL, 0x000000af007a7245ULL, 0x000fe4000020d400ULL,
0x000000897c89723eULL, 0x000fe200000010ffULL, 0x000000864038723cULL, 0x000b620000041838ULL,
0x000000017a7a1812ULL, 0x000fe200078efcffULL, 0x00000098007e7306ULL, 0x000fe20000209400ULL,
0x0000005e005e7245ULL, 0x002fc4000020d400ULL, 0x000000015f5f6812ULL, 0x000fe400078efcffULL,
0x000000717a7a723eULL, 0x000fe200000010ffULL, 0x00000088404c723cULL, 0x000b62000004184cULL,
0x0000000178780812ULL, 0x000fe200078efcffULL, 0x0000009800797306ULL, 0x000e620000205400ULL,
0x000000767500720bULL, 0x008fe40003f5d000ULL, 0x0000005f787b723eULL, 0x000fe400000010ffULL,
0x0000005c005f7245ULL, 0x000fc6000020d400ULL, 0x0000005c00737306ULL, 0x000fe40000209400ULL,
0x0000007a4050723cULL, 0x000b680000041850ULL, 0x000000015e5e2812ULL, 0x000fe400078efcffULL,
0x0000005c00747306ULL, 0x0004e20000205400ULL, 0x000000797e00720bULL, 0x002fe40003fdd000ULL,
0x000000726900720cULL, 0x000fca0003f46070ULL, 0x000000b0008e7306ULL, 0x000fe20000209400ULL,
0x00000001725c7810ULL, 0x004fc80007ffe0ffULL, 0x0000005c6900720cULL, 0x000fe40005746470ULL,
0x00000001b1b16812ULL, 0x000fe200078efcffULL, 0x000000b0007d7306ULL, 0x0002a20000205400ULL,
0x000000747300720bULL, 0x008fe40003f3d000ULL, 0x0000000e3500720cULL, 0x000fe40003fc3070ULL,
0x000000b15eb1723eULL, 0x000fe400000010ffULL, 0x000000b000b07245ULL, 0x002fce000020d400ULL,
0x000000015f5f1812ULL, 0x000fe400078efcffULL, 0x0000007d8e00720bULL, 0x004fe40003f1d000ULL,
0x000000726800720cULL, 0x000fc80003f26070ULL, 0x0000005c6800720cULL, 0x000fce0004f26470ULL,
0x00000001b0b00812ULL, 0x000fe400078efcffULL, 0x0000000e3500720cULL, 0x000fe40003f03070ULL,
0x000000b05fb0723eULL, 0x000fce00000010ffULL, 0x000000b04054723cULL, 0x000b620000041854ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x0000003c13137221ULL, 0x000fe20000010000ULL, 0x0000003d14147221ULL, 0x000fe20000010000ULL,
0x0000003817177221ULL, 0x020fe20000010000ULL, 0x0000003918187221ULL, 0x000fe20000010000ULL,
0x000000581b1b7221ULL, 0x000fe20000010000ULL, 0x000000591c1c7221ULL, 0x000fe20000010000ULL,
0x000000441f1f7221ULL, 0x000fe20000010000ULL, 0x0000004520207221ULL, 0x000fe20000010000ULL,
0x0000004823237221ULL, 0x000fe20000010000ULL, 0x0000004924247221ULL, 0x000fe20000010000ULL,
0x0000004c27277221ULL, 0x000fe20000010000ULL, 0x0000004d28287221ULL, 0x000fe20000010000ULL,
0x000000502b2b7221ULL, 0x000fe20000010000ULL, 0x000000512c2c7221ULL, 0x000fe20000010000ULL,
0x000000542f2f7221ULL, 0x000fe20000010000ULL, 0x0000005530307221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000001947ULL, 0x000fea0000000000ULL, 0x0000003e15157221ULL, 0x000fe20000010000ULL,
0x0000003f16167221ULL, 0x000fe20000010000ULL, 0x0000003a19197221ULL, 0x020fe20000010000ULL,
0x0000003b1a1a7221ULL, 0x000fe20000010000ULL, 0x0000005a1d1d7221ULL, 0x000fe20000010000ULL,
0x0000005b1e1e7221ULL, 0x000fe20000010000ULL, 0x0000004621217221ULL, 0x000fe20000010000ULL,
0x0000004722227221ULL, 0x000fe20000010000ULL, 0x0000004a25257221ULL, 0x000fe20000010000ULL,
0x0000004b26267221ULL, 0x000fe20000010000ULL, 0x0000004e29297221ULL, 0x000fe20000010000ULL,
0x0000004f2a2a7221ULL, 0x000fe20000010000ULL, 0x000000522d2d7221ULL, 0x000fe20000010000ULL,
0x000000532e2e7221ULL, 0x000fe20000010000ULL, 0x0000005631317221ULL, 0x000fe20000010000ULL,
0x0000005760607221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8800ff387f8cULL, 0x020e62000c80043fULL,
0x00000002ff3b7819ULL, 0x000fe2000001165cULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x0000000e3500720cULL, 0x000fc40003fc3070ULL, 0x0000003b5c3b7207ULL, 0x040fe40002800000ULL,
0x000000035c5c7812ULL, 0x000fe400078ec0ffULL, 0x000000023b3b7810ULL, 0x000fe40007ffe0ffULL,
0x0000000e3500720cULL, 0x000fe40003f03070ULL, 0x00000040ff5e7803ULL, 0x000fe40000000000ULL,
0x000000ff5c5c7207ULL, 0x000fc40006800000ULL, 0x000000033b417812ULL, 0x040fe400078ec0ffULL,
0x0000000e3b407211ULL, 0x000fe200078ff0ffULL, 0x000000ffff3f7224ULL, 0x002fc400078e0039ULL,
0x0000000000387805ULL, 0x000fca0000015200ULL, 0x010b8400ff3a7984ULL, 0x000e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x800000003aff7812ULL, 0x002fe200078c485dULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007fde1ffULL,
0x000000013b3b7824ULL, 0x000fe200030e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078d10ffULL, 0x000000ffff3b7224ULL, 0x000fca00030e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8400ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe400078c485dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fc40000015200ULL, 0x010b8c00ff3a7984ULL, 0x000e620000000800ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe60000000000ULL,
0x800000003aff7812ULL, 0x002fe200078c483fULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000103c00780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383d7210ULL, 0x000fca0007fde1ffULL, 0x000000013b3b7824ULL, 0x000fe200030e0e39ULL,
0x003d09003d00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff3a7819ULL, 0x000fc8000001143bULL, 0x0000003d3a3a7211ULL, 0x000fca00078d10ffULL,
0x000000ffff3b7224ULL, 0x000fca00030e063bULL, 0x000000023a3a7819ULL, 0x000fc8000000123bULL,
0x0000003a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe400078c483fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000140387810ULL, 0x000fe20007ffe0ffULL,
0x0000097000017945ULL, 0x000fe60003800000ULL, 0x000000373800720cULL, 0x000fda0003fc6070ULL,
0x000005100000e947ULL, 0x000fea0003800000ULL, 0x0000000162437824ULL, 0x000fe400078e0205ULL,
0x00000100ff447424ULL, 0x000fe400078e00ffULL, 0x0000004034427824ULL, 0x000fe200078e0243ULL,
0x010a0000433c7984ULL, 0x000e620000004800ULL, 0x00000010323a7824ULL, 0x000fe400078e00ffULL,
0x00000010433d7824ULL, 0x000fc600078e00ffULL, 0x000000f03a457812ULL, 0x000fe200078ec0ffULL,
0x010ac0003c397984ULL, 0x002e640000004800ULL, 0x000000390c397224ULL, 0x002fc800078e0242ULL,
0x00005e0039387625ULL, 0x000fca00078e0044ULL, 0x00000045383a7210ULL, 0x000fe20007fde0ffULL,
0x0000000440387824ULL, 0x000fc800078e0241ULL, 0x0000004038387824ULL, 0x000fe400078e00ffULL,
0x000000ffff3b7224ULL, 0x000fc600030e0639ULL, 0x0000003861397217ULL, 0x000fca0007800000ULL,
0x0000000139397824ULL, 0x000fe400078e0a38ULL, 0x0000000143387824ULL, 0x000fc600078e0232ULL,
0x0000003962397217ULL, 0x000fe40007800000ULL, 0xfffffff03d387812ULL, 0x000fc600078ee238ULL,
0x00000001393e7824ULL, 0x000fe200078e0a62ULL, 0x0000c00038477811ULL, 0x000fe400078e20ffULL,
0x0000000242387810ULL, 0x000fe40007ffe0ffULL, 0x0000003e0500720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a477faeULL, 0x0003e8000f101c46ULL,
0x010a0800433f7984ULL, 0x000ea80000004800ULL, 0x010ac0003f3f7984ULL, 0x004ea40000004800ULL,
0x0000003f0c387224ULL, 0x004fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fca00078e0044ULL,
0x00000045383c7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3d7224ULL, 0x000fe200030e0639ULL,
0x0000000205397810ULL, 0x000fc80007ffe0ffULL, 0x0000003e3900720cULL, 0x000fe20003fc6070ULL,
0x0000000162497824ULL, 0x000fc800078e0239ULL, 0x0000000149387824ULL, 0x040fe400078e0232ULL,
0x0000001049497824ULL, 0x000fca00078e00ffULL, 0xfffffff049387812ULL, 0x000fc800078ee238ULL,
0x0000c00038477811ULL, 0x002fe400078e20ffULL, 0x0000000442387810ULL, 0x040fe40007ffe0ffULL,
0x0000000642427810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c477faeULL, 0x0003e8000f101c46ULL, 0x010a1000433f7984ULL, 0x000ea80000004800ULL,
0x010ac0003f3f7984ULL, 0x004ea40000004800ULL, 0x0000003f0c387224ULL, 0x004fe200078e0238ULL,
0x00000006053f7810ULL, 0x000fc60007ffe0ffULL, 0x00005e0038387625ULL, 0x000fca00078e0044ULL,
0x00000045383a7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3b7224ULL, 0x000fe200030e0639ULL,
0x0000000405397810ULL, 0x000fc80007ffe0ffULL, 0x0000003e3900720cULL, 0x000fe20003fc6070ULL,
0x0000000162497824ULL, 0x000fc800078e0239ULL, 0x0000000149387824ULL, 0x040fe400078e0232ULL,
0x0000001049497824ULL, 0x000fca00078e00ffULL, 0xfffffff049387812ULL, 0x000fc800078ee238ULL,
0x0000c000383d7811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a3d7faeULL, 0x0003e8000f101c46ULL, 0x010a1800433c7984ULL, 0x000ea80000004800ULL,
0x010ac0003c397984ULL, 0x004ea40000004800ULL, 0x000000390c397224ULL, 0x004fc800078e0242ULL,
0x00005e0039387625ULL, 0x000fca00078e0044ULL, 0x0000004538387210ULL, 0x000fe20007fde0ffULL,
0x0000000162457824ULL, 0x000fc800078e023fULL, 0x0000000145427824ULL, 0x000fe400078e0232ULL,
0x000000ffff397224ULL, 0x000fe200030e0639ULL, 0x0000003e3f00720cULL, 0x000fe20003fc6070ULL,
0x0000001045457824ULL, 0x000fca00078e00ffULL, 0xfffffff045427812ULL, 0x000fc800078ee242ULL,
0x0000c000423b7811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e2000f101c46ULL, 0x0000043000007947ULL, 0x000fea0003800000ULL,
0x00000001623f7824ULL, 0x000fe400078e0205ULL, 0x00000100ff447424ULL, 0x000fe400078e00ffULL,
0x0000004034427824ULL, 0x000fe200078e023fULL, 0x010a00003f3c7984ULL, 0x000e620000004800ULL,
0x00000010323a7824ULL, 0x000fca00078e00ffULL, 0x000000f03a437812ULL, 0x000fe200078ec0ffULL,
0x010ac0003c397984ULL, 0x002e640000004800ULL, 0x000000390c397224ULL, 0x002fc800078e0242ULL,
0x00005e0039387625ULL, 0x000fca00078e0044ULL, 0x00000043383a7210ULL, 0x000fe20007fde0ffULL,
0x000000013f387824ULL, 0x000fc800078e0232ULL, 0x000000ffff3b7224ULL, 0x000fe400030e0639ULL,
0x000000103f397824ULL, 0x000fca00078e00ffULL, 0xfffffff039387812ULL, 0x000fc800078ee238ULL,
0x0000c00038457811ULL, 0x000fe400078e20ffULL, 0x0000000242387810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a457faeULL, 0x0003e8000b901c46ULL,
0x010a08003f3e7984ULL, 0x000ea80000004800ULL, 0x010ac0003e397984ULL, 0x004ea40000004800ULL,
0x000000390c397224ULL, 0x004fc800078e0238ULL, 0x00005e0039387625ULL, 0x000fca00078e0044ULL,
0x00000043383c7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3d7224ULL, 0x000fe200030e0639ULL,
0x000000023f397810ULL, 0x000fca0007ffe0ffULL, 0x0000000139387824ULL, 0x040fe400078e0232ULL,
0x0000001039397824ULL, 0x000fca00078e00ffULL, 0xfffffff039387812ULL, 0x000fc800078ee238ULL,
0x0000c00038457811ULL, 0x002fe400078e20ffULL, 0x0000000442387810ULL, 0x040fe40007ffe0ffULL,
0x0000000642427810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x010a10003f3e7984ULL, 0x000ea80000004800ULL,
0x010ac0003e397984ULL, 0x004ea40000004800ULL, 0x000000390c397224ULL, 0x004fc800078e0238ULL,
0x00005e0039387625ULL, 0x000fca00078e0044ULL, 0x00000043383a7210ULL, 0x000fca0007fde0ffULL,
0x000000ffff3b7224ULL, 0x000fe200030e0639ULL, 0x000000043f397810ULL, 0x000fca0007ffe0ffULL,
0x0000000139387824ULL, 0x040fe400078e0232ULL, 0x0000001039397824ULL, 0x000fca00078e00ffULL,
0xfffffff039387812ULL, 0x000fc800078ee238ULL, 0x0000c000383d7811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e8000b901c46ULL,
0x010a18003f3c7984ULL, 0x000ea80000004800ULL, 0x010ac0003c397984ULL, 0x004ea40000004800ULL,
0x000000390c397224ULL, 0x004fc800078e0242ULL, 0x00005e0039387625ULL, 0x000fca00078e0044ULL,
0x0000004338387210ULL, 0x000fe40007fde0ffULL, 0x000000063f437810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff397224ULL, 0x000fe400030e0639ULL, 0x00000001433e7824ULL, 0x040fe400078e0232ULL,
0x0000001043437824ULL, 0x000fca00078e00ffULL, 0xfffffff0433e7812ULL, 0x000fc800078ee23eULL,
0x0000c0003e3b7811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e4000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8800ff387f8cULL, 0x002e64000c80043fULL,
0x000000ffff3f7224ULL, 0x002fc400078e0039ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x010b8c00ff3a7984ULL, 0x000e620000000800ULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x800000003aff7812ULL, 0x002fe200078c483fULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007fde1ffULL,
0x000000013b3b7824ULL, 0x000fe200030e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078d10ffULL, 0x000000ffff3b7224ULL, 0x000fca00030e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe400078c483fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000017000017945ULL, 0x000fe20003800000ULL, 0x0000015000004947ULL, 0x000fea0003800000ULL,
0x000000403500720cULL, 0x000fe40003fc4070ULL, 0x00010a000b3b7811ULL, 0x000fe400078e10ffULL,
0x000000ff5c387207ULL, 0x000fc40003000000ULL, 0x000000ff5c5c7207ULL, 0x000fc60007000000ULL,
0x0000000141387824ULL, 0x000fc800078e0238ULL, 0x0000004038397824ULL, 0x040fe200078e00ffULL,
0x0000004038387211ULL, 0x000fc800078ff0ffULL, 0x000000c039397812ULL, 0x000fca00078ec0ffULL,
0x0000010038387824ULL, 0x000fe400078e0239ULL, 0x0000000163397824ULL, 0x000fc600078e025cULL,
0x00000020383a7810ULL, 0x000fca0007ffe0ffULL, 0x0000680039387a24ULL, 0x100fe400078e023aULL,
0x000000010b3a7824ULL, 0x040fe400078e023aULL, 0x00000004ff397424ULL, 0x000fe400078e00ffULL,
0x000000010b387824ULL, 0x000fe200078e0238ULL, 0x000000613a00720cULL, 0x000fc60003fc6070ULL,
0x0000660038387625ULL, 0x000fd400078e0039ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e4000f121846ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x010b7800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b7800ff387f8cULL, 0x000e62000c80043fULL, 0x0000013000017945ULL, 0x000fe20003800000ULL,
0x000000ffff717224ULL, 0x002fe200078e0039ULL, 0x0000010000003947ULL, 0x000fea0003800000ULL,
0x00000008ff06723eULL, 0x000fc800000010ffULL, 0x00005410063a7816ULL, 0x000fe20000000006ULL,
0x000117f27f007947ULL, 0x000fea000b800000ULL, 0x00001f693a077589ULL, 0x0002a400000e0000ULL,
0x000118327f007947ULL, 0x000fea000b800000ULL, 0x00001f683a067589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000010693f7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff3e7224ULL, 0x000fe200078e003aULL, 0x0001587000387802ULL, 0x000fc40000000f00ULL,
0x0001204000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000ffff3e7224ULL, 0x004fe200078e003aULL, 0x00000018693f7810ULL, 0x002fe40007ffe0ffULL,
0x000158c000387802ULL, 0x000fc40000000f00ULL, 0x00011ff000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000006d3c783bULL, 0x006e620000004200ULL, 0x00001e3000017945ULL, 0x000fe60003800000ULL,
0x000000006c40783bULL, 0x000ea80000004200ULL, 0x000000006b44783bULL, 0x000f220000004200ULL,
0x0000003c00387306ULL, 0x002fe20000009400ULL, 0x00000018ff577819ULL, 0x004fce0000011440ULL,
0x0000003c00397306ULL, 0x000e700000005400ULL, 0x0000003c004a7306ULL, 0x000ea2000000d400ULL,
0x000000393800720bULL, 0x002fce0003fdd000ULL, 0x0000003d004b7306ULL, 0x000ff0000000d400ULL,
0x0000003d00387306ULL, 0x000fe20000009400ULL, 0x000000014a4a6812ULL, 0x004fce00078efcffULL,
0x0000003d00397306ULL, 0x000e700000005400ULL, 0x0000003e00487306ULL, 0x000fe2000000d400ULL,
0x000000393800720bULL, 0x002fce0003fdd000ULL, 0x0000003f00497306ULL, 0x000ff0000000d400ULL,
0x0000003e00387306ULL, 0x000fe20000009400ULL, 0x000000014b4b6812ULL, 0x000fce00078efcffULL,
0x0000003e00397306ULL, 0x000e700000005400ULL, 0x0000004000507306ULL, 0x000fe2000000d400ULL,
0x000000393800720bULL, 0x002fce0003fdd000ULL, 0x0000004100517306ULL, 0x000ff0000000d400ULL,
0x0000003f00387306ULL, 0x000fe20000009400ULL, 0x0000000148486812ULL, 0x000fce00078efcffULL,
0x0000003f00397306ULL, 0x000e700000005400ULL, 0x0000004200567306ULL, 0x000fe2000000d400ULL,
0x000000393800720bULL, 0x002fce0003fdd000ULL, 0x0000004300587306ULL, 0x000ff0000000d400ULL,
0x0000004000387306ULL, 0x000fe20000009400ULL, 0x0000000149496812ULL, 0x000fce00078efcffULL,
0x0000004000397306ULL, 0x000e700000005400ULL, 0x00000044007e7306ULL, 0x010fe2000000d400ULL,
0x000000393800720bULL, 0x002fce0003fdd000ULL, 0x00000045007d7306ULL, 0x000ff0000000d400ULL,
0x0000004100387306ULL, 0x000fe20000009400ULL, 0x0000000150506812ULL, 0x000fce00078efcffULL,
0x0000004100397306ULL, 0x000e700000005400ULL, 0x00000046007a7306ULL, 0x000fe2000000d400ULL,
0x000000393800720bULL, 0x002fce0003fdd000ULL, 0x0000004700787306ULL, 0x000ff0000000d400ULL,
0x0000004200387306ULL, 0x000fe20000009400ULL, 0x0000000151516812ULL, 0x000fce00078efcffULL,
0x0000004200397306ULL, 0x000e640000005400ULL, 0x000000393800720bULL, 0x002fcc0003fdd000ULL,
0x0000004300387306ULL, 0x000ff00000009400ULL, 0x0000004300397306ULL, 0x000e620000005400ULL,
0x0000000156566812ULL, 0x000fe400078efcffULL, 0x000000393800720bULL, 0x002fca0003fdd000ULL,
0x0000004400387306ULL, 0x000ff00000009400ULL, 0x0000004400397306ULL, 0x000e620000005400ULL,
0x0000000158586812ULL, 0x000fe400078efcffULL, 0x000000393800720bULL, 0x002fca0003fdd000ULL,
0x0000004500387306ULL, 0x000ff00000009400ULL, 0x0000004500397306ULL, 0x000e620000005400ULL,
0x000000017e7e6812ULL, 0x000fe400078efcffULL, 0x000000393800720bULL, 0x002fca0003fdd000ULL,
0x0000004600387306ULL, 0x000ff00000009400ULL, 0x0000004600397306ULL, 0x000e620000005400ULL,
0x000000017d7d6812ULL, 0x000fe400078efcffULL, 0x000000393800720bULL, 0x002fca0003fdd000ULL,
0x0000004700387306ULL, 0x000ff00000009400ULL, 0x0000004700397306ULL, 0x000e620000005400ULL,
0x000000017a7a6812ULL, 0x000fe400078efcffULL, 0x000000393800720bULL, 0x002fc40003fdd000ULL,
0x000000006a38783bULL, 0x008e760000004200ULL, 0x0000000178786812ULL, 0x000fe200078efcffULL,
0x00000038004c7306ULL, 0x002ff00000009400ULL, 0x00000038004d7306ULL, 0x000e700000005400ULL,
0x0000003800757306ULL, 0x000ea2000000d400ULL, 0x0000004d4c00720bULL, 0x002fce0003fdd000ULL,
0x0000003900767306ULL, 0x000ff0000000d400ULL, 0x00000039004c7306ULL, 0x000fe20000009400ULL,
0x0000000175756812ULL, 0x004fce00078efcffULL, 0x00000039004d7306ULL, 0x000e700000005400ULL,
0x0000003a00737306ULL, 0x000fe2000000d400ULL, 0x0000004d4c00720bULL, 0x002fce0003fdd000ULL,
0x0000003b00977306ULL, 0x000ff0000000d400ULL, 0x0000003a004c7306ULL, 0x000fe20000009400ULL,
0x0000000176766812ULL, 0x000fce00078efcffULL, 0x0000003a004d7306ULL, 0x000e640000005400ULL,
0x0000004d4c00720bULL, 0x002fe40003fdd000ULL, 0x00000018ff4c7819ULL, 0x000fc8000001143cULL,
0x0000004c004d7306ULL, 0x000fe20000209400ULL, 0x0000004c004f7245ULL, 0x000fcc000020d400ULL,
0x0000000173736812ULL, 0x000fe200078efcffULL, 0x0000004c004e7306ULL, 0x000e640000205400ULL,
0x0000004e4d00720bULL, 0x002fe40003fdd000ULL, 0x00000018ff4d7819ULL, 0x000fc8000001143dULL,
0x0000004d00527306ULL, 0x000fe20000209400ULL, 0x0000004d004e7245ULL, 0x000fcc000020d400ULL,
0x000000014f4f6812ULL, 0x000fe200078efcffULL, 0x0000004d00537306ULL, 0x000e640000205400ULL,
0x000000535200720bULL, 0x002fe40003fdd000ULL, 0x00000018ff527819ULL, 0x000fc8000001143eULL,
0x0000005200537306ULL, 0x000fe20000209400ULL, 0x00000052004c7245ULL, 0x000fcc000020d400ULL,
0x000000014e4e6812ULL, 0x000fe200078efcffULL, 0x0000005200547306ULL, 0x000e700000205400ULL,
0x0000005700527306ULL, 0x000fe20000209400ULL, 0x000000545300720bULL, 0x002fc40003fdd000ULL,
0x00000018ff537819ULL, 0x000fca000001143fULL, 0x0000005300547306ULL, 0x000fe20000209400ULL,
0x00000053004d7245ULL, 0x000fca000020d400ULL, 0x000000014c4c6812ULL, 0x000fe400078efcffULL,
0x0000005300557306ULL, 0x000e640000205400ULL, 0x000000555400720bULL, 0x002fcc0003fdd000ULL,
0x0000005700557306ULL, 0x000e620000205400ULL, 0x0000005700547245ULL, 0x000fcc000020d400ULL,
0x000000014d4d6812ULL, 0x000fe400078efcffULL, 0x000000555200720bULL, 0x002fe40003fdd000ULL,
0x00000018ff527819ULL, 0x000fc80000011441ULL, 0x0000005200537306ULL, 0x000fe20000209400ULL,
0x0000005200557245ULL, 0x000fcc000020d400ULL, 0x0000000154546812ULL, 0x000fe200078efcffULL,
0x00000052005a7306ULL, 0x000e640000205400ULL, 0x0000005a5300720bULL, 0x002fe40003fdd000ULL,
0x00000018ff537819ULL, 0x000fc80000011442ULL, 0x0000005300577306ULL, 0x000fe20000209400ULL,
0x0000005300597245ULL, 0x000fcc000020d400ULL, 0x0000000155556812ULL, 0x000fe200078efcffULL,
0x00000053005a7306ULL, 0x000e640000205400ULL, 0x0000005a5700720bULL, 0x002fe40003fdd000ULL,
0x00000018ff577819ULL, 0x000fc80000011443ULL, 0x0000005700527306ULL, 0x000fe20000209400ULL,
0x00000057005a7245ULL, 0x000fcc000020d400ULL, 0x0000000159596812ULL, 0x000fe200078efcffULL,
0x00000057005b7306ULL, 0x000e640000205400ULL, 0x0000005b5200720bULL, 0x002fe40003fdd000ULL,
0x00000018ff527819ULL, 0x000fc80000011444ULL, 0x0000005200537306ULL, 0x000fe20000209400ULL,
0x0000005200807245ULL, 0x000fcc000020d400ULL, 0x000000015a5a6812ULL, 0x000fe200078efcffULL,
0x00000052005c7306ULL, 0x000e640000205400ULL, 0x0000005c5300720bULL, 0x002fe40003fdd000ULL,
0x00000018ff537819ULL, 0x000fc80000011445ULL, 0x0000005300577306ULL, 0x000fe20000209400ULL,
0x00000053007f7245ULL, 0x000fcc000020d400ULL, 0x0000000180806812ULL, 0x000fe200078efcffULL,
0x00000053005c7306ULL, 0x000e640000205400ULL, 0x0000005c5700720bULL, 0x002fe40003fdd000ULL,
0x00000018ff577819ULL, 0x000fc80000011446ULL, 0x0000005700527306ULL, 0x000fe20000209400ULL,
0x00000057007c7245ULL, 0x000fcc000020d400ULL, 0x000000017f7f6812ULL, 0x000fe200078efcffULL,
0x00000057005b7306ULL, 0x000e640000205400ULL, 0x0000005b5200720bULL, 0x002fe40003fdd000ULL,
0x00000018ff527819ULL, 0x000fc80000011447ULL, 0x0000005200537306ULL, 0x000fe20000209400ULL,
0x00000052007b7245ULL, 0x000fcc000020d400ULL, 0x000000017c7c6812ULL, 0x000fe200078efcffULL,
0x00000052005c7306ULL, 0x000e640000205400ULL, 0x0000005c5300720bULL, 0x002fe40003fdd000ULL,
0x00000018ff537819ULL, 0x000fc80000011438ULL, 0x0000005300577306ULL, 0x000fe20000209400ULL,
0x0000005300797245ULL, 0x000fcc000020d400ULL, 0x000000017b7b6812ULL, 0x000fe200078efcffULL,
0x00000053005c7306ULL, 0x000e640000205400ULL, 0x0000005c5700720bULL, 0x002fe40003fdd000ULL,
0x00000018ff577819ULL, 0x000fc80000011439ULL, 0x0000005700527306ULL, 0x000fe20000209400ULL,
0x0000005700777245ULL, 0x000fcc000020d400ULL, 0x0000000179796812ULL, 0x000fe200078efcffULL,
0x00000057005b7306ULL, 0x000e640000205400ULL, 0x0000005b5200720bULL, 0x002fe40003fdd000ULL,
0x00000018ff5b7819ULL, 0x000fc8000001143aULL, 0x0000005b00527306ULL, 0x000fe20000209400ULL,
0x0000005b00747245ULL, 0x000fcc000020d400ULL, 0x0000000177776812ULL, 0x000fe200078efcffULL,
0x0000005b00537306ULL, 0x000e640000205400ULL, 0x000000535200720bULL, 0x002fe20003fdd000ULL,
0x000001003c527824ULL, 0x040fe400078e00ffULL, 0x000100003c3c7824ULL, 0x000fc600078e00ffULL,
0x00000018ff527819ULL, 0x000fc80000011452ULL, 0x0000005200577306ULL, 0x000fe20000209400ULL,
0x0000005200537245ULL, 0x000fe4000020d400ULL, 0x0000000174746812ULL, 0x000fca00078efcffULL,
0x00000052005c7306ULL, 0x0002a40000205400ULL, 0x000001003d527824ULL, 0x042fe400078e00ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x0000005c5700720bULL, 0x004fe40003fdd000ULL,
0x00000018ff577819ULL, 0x000fc8000001143cULL, 0x00000057005b7306ULL, 0x000fe20000209400ULL,
0x00000057003c7245ULL, 0x000fcc000020d400ULL, 0x0000000153536812ULL, 0x000fe200078efcffULL,
0x00000057005c7306ULL, 0x0002a40000205400ULL, 0x00000018ff577819ULL, 0x002fc8000001143dULL,
0x00000057003d7245ULL, 0x000fe4000020d400ULL, 0x0000005c5b00720bULL, 0x004fe40003fdd000ULL,
0x00000018ff5b7819ULL, 0x000fc80000011452ULL, 0x0000005b005c7306ULL, 0x000fe20000209400ULL,
0x0000005b00527245ULL, 0x000fcc000020d400ULL, 0x000000013c3c6812ULL, 0x000fe200078efcffULL,
0x0000005b005d7306ULL, 0x0002a40000205400ULL, 0x000001003e5b7824ULL, 0x042fe400078e00ffULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x0000005d5c00720bULL, 0x004fc60003fdd000ULL,
0x00000057005c7306ULL, 0x000fe20000209400ULL, 0x00000018ff3e7819ULL, 0x000fce000001143eULL,
0x00000057005d7306ULL, 0x0002a40000205400ULL, 0x0000000152526812ULL, 0x000fe400078efcffULL,
0x0000003e00577245ULL, 0x002fe4000020d400ULL, 0x0000005d5c00720bULL, 0x004fe40003fdd000ULL,
0x00000018ff5c7819ULL, 0x000fc8000001145bULL, 0x0000005c005d7306ULL, 0x000fe20000209400ULL,
0x0000005c005b7245ULL, 0x000fcc000020d400ULL, 0x000000013d3d6812ULL, 0x000fe200078efcffULL,
0x0000005c00827306ULL, 0x0002a40000205400ULL, 0x000001003f5c7824ULL, 0x042fe400078e00ffULL,
0x000100003f3f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe4000001145cULL,
0x000000825d00720bULL, 0x004fe40003fdd000ULL, 0x0000003e005d7306ULL, 0x000fe20000209400ULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x0000005c00847245ULL, 0x000fca000020d400ULL,
0x0000003e00827306ULL, 0x0002a60000205400ULL, 0x000000015b5b6812ULL, 0x000fc800078efcffULL,
0x000000485b48723eULL, 0x000fe400000010ffULL, 0x0000003f003e7245ULL, 0x002fe4000020d400ULL,
0x000000825d00720bULL, 0x004fe40003fdd000ULL, 0x0000005c005d7306ULL, 0x000ff00000209400ULL,
0x0000005c00827306ULL, 0x0002a60000205400ULL, 0x0000000157576812ULL, 0x000fc800078efcffULL,
0x000000574c4c723eULL, 0x000fe200000010ffULL, 0x00000100405c7824ULL, 0x042fe400078e00ffULL,
0x0001000040407824ULL, 0x000fc600078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe4000001145cULL,
0x000000825d00720bULL, 0x004fe40003fdd000ULL, 0x0000003f005d7306ULL, 0x000fe20000209400ULL,
0x00000018ff407819ULL, 0x000fe40000011440ULL, 0x0000005c00837245ULL, 0x000fe4000020d400ULL,
0x0000004000817245ULL, 0x000fc6000020d400ULL, 0x0000003f00827306ULL, 0x000e660000205400ULL,
0x0000000184846812ULL, 0x000fc800078efcffULL, 0x000000498449723eULL, 0x000fe200000010ffULL,
0x00000040003f7306ULL, 0x000fe20000209400ULL, 0x000000825d00720bULL, 0x002fce0003fdd000ULL,
0x0000005c005d7306ULL, 0x000ff00000209400ULL, 0x0000005c00827306ULL, 0x000e620000205400ULL,
0x000000013e3e6812ULL, 0x000fc800078efcffULL, 0x0000003e4d4d723eULL, 0x000fe400000010ffULL,
0x000000825d00720bULL, 0x002fe40003fdd000ULL, 0x0000004000827306ULL, 0x000e760000205400ULL,
0x0000000183836812ULL, 0x000fc800078efcffULL, 0x000000508350723eULL, 0x000fe400000010ffULL,
0x000000823f00720bULL, 0x002fe20003fdd000ULL, 0x00000100413f7824ULL, 0x040fe400078e00ffULL,
0x0001000041417824ULL, 0x000fc600078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x0000003f005c7306ULL, 0x000fe20000209400ULL,
0x0000003f00867245ULL, 0x000fe4000020d400ULL, 0x0000000181816812ULL, 0x000fe400078efcffULL,
0x0000004100827245ULL, 0x000fe4000020d400ULL, 0x000000815454723eULL, 0x000fe200000010ffULL,
0x0000003f005d7306ULL, 0x0002b00000205400ULL, 0x0000004100407306ULL, 0x000fe20000209400ULL,
0x00000100423f7824ULL, 0x002fc400078e00ffULL, 0x0001000042427824ULL, 0x000fc600078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x0000005d5c00720bULL, 0x004fe20003fdd000ULL,
0x0000003b00817306ULL, 0x000fe20000005400ULL, 0x00000018ff427819ULL, 0x000fe40000011442ULL,
0x0000003f00857245ULL, 0x000fe4000020d400ULL, 0x0000004200887245ULL, 0x000fc6000020d400ULL,
0x00000041005d7306ULL, 0x000e680000205400ULL, 0x0000000186866812ULL, 0x000fc800078efcffULL,
0x0000004200417306ULL, 0x000fe20000205400ULL, 0x000000518651723eULL, 0x000fe400000010ffULL,
0x0000005d4000720bULL, 0x002fca0003fdd000ULL, 0x0000003f00407306ULL, 0x000ff00000209400ULL,
0x0000003f005d7306ULL, 0x0002a20000205400ULL, 0x0000000182826812ULL, 0x000fc800078efcffULL,
0x000000825555723eULL, 0x000fe200000010ffULL, 0x00000100433f7824ULL, 0x042fe400078e00ffULL,
0x0001000043437824ULL, 0x000fc600078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x0000005d4000720bULL, 0x004fe40003fdd000ULL, 0x0000004200407306ULL, 0x000e620000209400ULL,
0x00000018ff437819ULL, 0x000fe40000011443ULL, 0x0000003f00877245ULL, 0x000fe4000020d400ULL,
0x0000004300897245ULL, 0x000fcc000020d400ULL, 0x0000000185856812ULL, 0x000fe400078efcffULL,
0x000000414000720bULL, 0x002fe40003fdd000ULL, 0x0000003f00407306ULL, 0x000ff00000209400ULL,
0x0000003f00417306ULL, 0x0002a60000205400ULL, 0x0000000188886812ULL, 0x000fc800078efcffULL,
0x000000885988723eULL, 0x000fe200000010ffULL, 0x00000100443f7824ULL, 0x042fe400078e00ffULL,
0x0001000044447824ULL, 0x000fc600078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x000000414000720bULL, 0x004fe40003fdd000ULL, 0x0000004300407306ULL, 0x000fe20000209400ULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x0000003f008d7245ULL, 0x000fe4000020d400ULL,
0x00000044008b7245ULL, 0x000fc6000020d400ULL, 0x0000004300417306ULL, 0x000e660000205400ULL,
0x0000000187876812ULL, 0x000fe400078efcffULL, 0x000000414000720bULL, 0x002fc60003fdd000ULL,
0x0000003f00407306ULL, 0x000ff00000209400ULL, 0x0000003f00417306ULL, 0x0002a40000205400ULL,
0x0000000189896812ULL, 0x000fc800078efcffULL, 0x000000895a89723eULL, 0x000fe200000010ffULL,
0x00000100453f7824ULL, 0x042fe400078e00ffULL, 0x0001000045457824ULL, 0x000fc600078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x000000414000720bULL, 0x004fe40003fdd000ULL,
0x0000004400407306ULL, 0x000fe20000209400ULL, 0x00000018ff457819ULL, 0x000fe40000011445ULL,
0x0000003f008c7245ULL, 0x000fe4000020d400ULL, 0x00000045008a7245ULL, 0x000fc6000020d400ULL,
0x0000004400417306ULL, 0x0002a60000205400ULL, 0x000000018d8d6812ULL, 0x000fe400078efcffULL,
0x0000003c4f44723eULL, 0x002fe400000010ffULL, 0x0000b0006e3c7811ULL, 0x000fe400078e20ffULL,
0x000000414000720bULL, 0x004fe40003fdd000ULL, 0x0000003f00407306ULL, 0x000ff00000209400ULL,
0x0000003f00417306ULL, 0x0002a60000205400ULL, 0x000000018b8b6812ULL, 0x000fe200078efcffULL,
0x00000100463f7824ULL, 0x002fc400078e00ffULL, 0x0001000046467824ULL, 0x000fc600078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x000000414000720bULL, 0x004fe40003fdd000ULL,
0x0000004500407306ULL, 0x000fe20000209400ULL, 0x00000018ff467819ULL, 0x000fe40000011446ULL,
0x0000003f00917245ULL, 0x000fe4000020d400ULL, 0x00000046008f7245ULL, 0x000fc6000020d400ULL,
0x0000004500417306ULL, 0x0002a60000205400ULL, 0x000000018c8c6812ULL, 0x000fe400078efcffULL,
0x0000003d4e45723eULL, 0x002fe400000010ffULL, 0x000000414000720bULL, 0x004fe40003fdd000ULL,
0x0000003f00407306ULL, 0x000ff00000209400ULL, 0x0000003f00417306ULL, 0x0002a60000205400ULL,
0x000000018a8a6812ULL, 0x000fc800078efcffULL, 0x0000008a7f7f723eULL, 0x000fe200000010ffULL,
0x00000100473f7824ULL, 0x042fe400078e00ffULL, 0x0001000047477824ULL, 0x000fc600078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x000000414000720bULL, 0x004fe40003fdd000ULL,
0x0000004600407306ULL, 0x000fe20000209400ULL, 0x00000018ff477819ULL, 0x000fe40000011447ULL,
0x0000003f00937245ULL, 0x000fe4000020d400ULL, 0x00000047008e7245ULL, 0x000fc6000020d400ULL,
0x0000004600417306ULL, 0x000e660000205400ULL, 0x0000000191916812ULL, 0x000fe400078efcffULL,
0x000000414000720bULL, 0x002fc60003fdd000ULL, 0x0000003f00407306ULL, 0x000ff00000209400ULL,
0x0000003f00417306ULL, 0x0002a40000205400ULL, 0x000000018f8f6812ULL, 0x000fe200078efcffULL,
0x00000100383f7824ULL, 0x002fc400078e00ffULL, 0x0001000038387824ULL, 0x000fc600078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x000000414000720bULL, 0x004fe40003fdd000ULL,
0x0000004700407306ULL, 0x000fe20000209400ULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x0000003f00927245ULL, 0x000fe4000020d400ULL, 0x0000003800907245ULL, 0x000fc6000020d400ULL,
0x0000004700417306ULL, 0x000e660000205400ULL, 0x0000000193936812ULL, 0x000fe400078efcffULL,
0x000000414000720bULL, 0x002fc60003fdd000ULL, 0x0000003f00407306ULL, 0x000ff00000209400ULL,
0x0000003f00417306ULL, 0x0002a40000205400ULL, 0x000000018e8e6812ULL, 0x000fc800078efcffULL,
0x0000008e7b7b723eULL, 0x000fe200000010ffULL, 0x00000100393f7824ULL, 0x042fe400078e00ffULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x000000414000720bULL, 0x004fe40003fdd000ULL, 0x0000003800407306ULL, 0x000fe20000209400ULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000003f00957245ULL, 0x000fe4000020d400ULL,
0x0000003900947245ULL, 0x000fc6000020d400ULL, 0x0000003800417306ULL, 0x000e660000205400ULL,
0x0000000192926812ULL, 0x000fc800078efcffULL, 0x000000759292723eULL, 0x000fe200000010ffULL,
0x0000003900387306ULL, 0x000fe20000209400ULL, 0x000000414000720bULL, 0x002fce0003fdd000ULL,
0x0000003f00407306ULL, 0x000ff00000209400ULL, 0x0000003f00417306ULL, 0x000e620000205400ULL,
0x0000000190906812ULL, 0x000fe400078efcffULL, 0x000000414000720bULL, 0x002fca0003fdd000ULL,
0x0000003900417306ULL, 0x000e700000205400ULL, 0x0000000195956812ULL, 0x000fe400078efcffULL,
0x000000413800720bULL, 0x002fe20003fdd000ULL, 0x000001003a387824ULL, 0x000fe200078e00ffULL,
0x0000004b5241723eULL, 0x000fe200000010ffULL, 0x000100003a3a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x00000038003f7306ULL, 0x000fe20000209400ULL, 0x0000003800967245ULL, 0x000fe4000020d400ULL,
0x0000000194946812ULL, 0x000fe400078efcffULL, 0x0000003a00997245ULL, 0x000fe4000020d400ULL,
0x000000947777723eULL, 0x000fe200000010ffULL, 0x0000003800407306ULL, 0x0002b00000205400ULL,
0x0000003a00397306ULL, 0x000fe20000209400ULL, 0x000001003b387824ULL, 0x002fe200078e00ffULL,
0x000000403f00720bULL, 0x004fcc0003fdd000ULL, 0x0000003a00407306ULL, 0x000e700000205400ULL,
0x0000003b003a7306ULL, 0x000fe20000009400ULL, 0x0000000196966812ULL, 0x000fc800078efcffULL,
0x000000739696723eULL, 0x000fe400000010ffULL, 0x000000403900720bULL, 0x002fe40003fdd000ULL,
0x00000018ff397819ULL, 0x000fe40000011438ULL, 0x0000004a5340723eULL, 0x000fe400000010ffULL,
0x0000003900387306ULL, 0x000fe20000209400ULL, 0x0000003900987245ULL, 0x000fcc000020d400ULL,
0x0000000199996812ULL, 0x000fe200078efcffULL, 0x00000039003f7306ULL, 0x0002a60000205400ULL,
0x000000997474723eULL, 0x000fe400000010ffULL, 0x000000588739723eULL, 0x002fe400000010ffULL,
0x0000003f3800720bULL, 0x004fe40003fdd000ULL, 0x0000b0006f387811ULL, 0x000fe200078e20ffULL,
0x000000003c3c783bULL, 0x000e740000000200ULL, 0x0000000198986812ULL, 0x000fc400078efcffULL,
0x000000ff5e00720cULL, 0x000fe40003fc5270ULL, 0x00000000385c783bULL, 0x0004e40000000200ULL,
0x000000568538723eULL, 0x004fe200000010ffULL, 0x000000073c3cb231ULL, 0x082fe400003400ffULL,
0x000000073e3eb231ULL, 0x000fe400003400ffULL, 0x000000063d3db231ULL, 0x080fe400003400ffULL,
0x000000063f3fb231ULL, 0x000fc400003400ffULL, 0x000000075c5cb231ULL, 0x088fe400003400ffULL,
0x000000075e5eb231ULL, 0x000fe400003400ffULL, 0x000000065d5db231ULL, 0x080fe400003400ffULL,
0x000000065f5fb231ULL, 0x000fe200003400ffULL, 0x000000813a00720bULL, 0x000fcc0003f7d000ULL,
0x000000385c58723cULL, 0x040bee00000418ffULL, 0x000100003b387824ULL, 0x020fe200078e00ffULL,
0x0000007d8c39723eULL, 0x000fe200000010ffULL, 0x000000405c40723cULL, 0x000f6200000418ffULL,
0x00000018ff3b7819ULL, 0x000fc4000001143bULL, 0x00000018ff827819ULL, 0x000fe40000011438ULL,
0x0000000197973812ULL, 0x000fe200078efcffULL, 0x0000003b003a7306ULL, 0x000fe20000209400ULL,
0x0000007e8d38723eULL, 0x000fe200000010ffULL, 0x000000485c48723cULL, 0x040fe200000418ffULL,
0x0000008200757245ULL, 0x000fe4000020d400ULL, 0x0000008b807e723eULL, 0x000fe400000010ffULL,
0x000000979897723eULL, 0x000fe200000010ffULL, 0x00000082007d7306ULL, 0x000fe40000209400ULL,
0x000000445c44723cULL, 0x040f6c00000418ffULL, 0x0000008200847306ULL, 0x000e640000205400ULL,
0x0000004c5c4c723cULL, 0x040f7000000418ffULL, 0x000000505c50723cULL, 0x000f6200000418ffULL,
0x000000847d00720bULL, 0x002fc40003f7d000ULL, 0x0000003b007d7306ULL, 0x000e6a0000205400ULL,
0x000000545c54723cULL, 0x040f7000000418ffULL, 0x000000885c5c723cULL, 0x000f6200000418ffULL,
0x0000000175753812ULL, 0x000fc400078efcffULL, 0x0000007d3a00720bULL, 0x002fca0003f7d000ULL,
0x000000383c40723cULL, 0x060b6e0000041840ULL, 0x0000007a9138723eULL, 0x020fe200000010ffULL,
0x0000007e3c44723cULL, 0x000f620000041844ULL, 0x000000789339723eULL, 0x000fe400000010ffULL,
0x000000769593723eULL, 0x000fc400000010ffULL, 0x0000008f7c7a723eULL, 0x000fe400000010ffULL,
0x000000907976723eULL, 0x000fe200000010ffULL, 0x000000383c48723cULL, 0x040b6e0000041848ULL,
0x0000003b00387245ULL, 0x020fe2000020d400ULL, 0x0000007a3c4c723cULL, 0x000b66000004184cULL,
0x0000000138383812ULL, 0x000fc800078efcffULL, 0x000000753875723eULL, 0x000fe200000010ffULL,
0x000000923c50723cULL, 0x040b700000041850ULL, 0x000000763c54723cULL, 0x040b700000041854ULL,
0x000000963c58723cULL, 0x040b700000041858ULL, 0x000000743c5c723cULL, 0x000b62000004185cULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x0000004013137221ULL, 0x000fe20000010000ULL, 0x0000004114147221ULL, 0x000fe20000010000ULL,
0x0000004417177221ULL, 0x000fe20000010000ULL, 0x0000004518187221ULL, 0x000fe20000010000ULL,
0x000000481b1b7221ULL, 0x000fe20000010000ULL, 0x000000491c1c7221ULL, 0x000fe20000010000ULL,
0x0000004c1f1f7221ULL, 0x020fe20000010000ULL, 0x0000004d20207221ULL, 0x000fe20000010000ULL,
0x0000005023237221ULL, 0x000fe20000010000ULL, 0x0000005124247221ULL, 0x000fe20000010000ULL,
0x0000005427277221ULL, 0x000fe20000010000ULL, 0x0000005528287221ULL, 0x000fe20000010000ULL,
0x000000582b2b7221ULL, 0x000fe20000010000ULL, 0x000000592c2c7221ULL, 0x000fe20000010000ULL,
0x0000005c2f2f7221ULL, 0x000fe20000010000ULL, 0x0000005d30307221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000001947ULL, 0x000fea0000000000ULL, 0x0000004215157221ULL, 0x000fe20000010000ULL,
0x0000004316167221ULL, 0x000fe20000010000ULL, 0x0000004619197221ULL, 0x000fe20000010000ULL,
0x000000471a1a7221ULL, 0x000fe20000010000ULL, 0x0000004a1d1d7221ULL, 0x000fe20000010000ULL,
0x0000004b1e1e7221ULL, 0x000fe20000010000ULL, 0x0000004e21217221ULL, 0x020fe20000010000ULL,
0x0000004f22227221ULL, 0x000fe20000010000ULL, 0x0000005225257221ULL, 0x000fe20000010000ULL,
0x0000005326267221ULL, 0x000fe20000010000ULL, 0x0000005629297221ULL, 0x000fe20000010000ULL,
0x000000572a2a7221ULL, 0x000fe20000010000ULL, 0x0000005a2d2d7221ULL, 0x000fe20000010000ULL,
0x0000005b2e2e7221ULL, 0x000fe20000010000ULL, 0x0000005e31317221ULL, 0x000fe20000010000ULL,
0x0000005f60607221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000172727810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8800ff387f8cULL, 0x000e62000c80043fULL, 0x000000707200720cULL, 0x000fe20003f06070ULL,
0x000000ffff3e7224ULL, 0x022fd800078e0039ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffff8d2000007947ULL, 0x000fea000383ffffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000c00e387811ULL, 0x000fe200078e40ffULL, 0x010b6800ffff7f8cULL, 0x000fe6000c80043fULL,
0x000000613800720cULL, 0x000fda0003f06070ULL, 0x0000735000000947ULL, 0x000fea0003800000ULL,
0x000000ffff727224ULL, 0x000fca00078e00ffULL, 0x00000002ff397819ULL, 0x000fe20000011672ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000000372387812ULL, 0x040fe200078ec0ffULL,
0x000000ffff407224ULL, 0x000fe200078e00ffULL, 0x0000003972397207ULL, 0x000fe40002800000ULL,
0x000000ff38417207ULL, 0x000fe40006800000ULL, 0x00000003393b7810ULL, 0x000fc80007ffe0ffULL,
0x000000033b397812ULL, 0x040fe400078ec0ffULL, 0x0000000e3b387211ULL, 0x000fc400078ff0ffULL,
0x00000000003a7805ULL, 0x000fca0000015200ULL, 0x010b7c00ff3c7984ULL, 0x000e640000000800ULL,
0x800000003cff7812ULL, 0x002fe40007804871ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000017945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003c7805ULL, 0x000fcc0000015200ULL, 0x0000003c3a3f7210ULL, 0x000fca0007f1e1ffULL,
0x000000013d3d7824ULL, 0x000fe200000e0e3bULL, 0x003d09003f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3c7819ULL, 0x000fc8000001143dULL,
0x0000003f3c3c7211ULL, 0x000fca00078110ffULL, 0x000000ffff3d7224ULL, 0x000fca00000e063dULL,
0x000000023c3c7819ULL, 0x000fc8000000123dULL, 0x0000003c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000140407810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b7c00ff3c7984ULL, 0x000e640000000800ULL,
0x800000003cff7812ULL, 0x002fe40007804871ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fc40000015200ULL, 0x010b8c00ff3d7984ULL, 0x000e640000000800ULL,
0x800000003dff7812ULL, 0x002fe4000780483eULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff407224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003c7805ULL, 0x000fcc0000015200ULL,
0x0000003c3a3f7210ULL, 0x000fca0007f1e1ffULL, 0x000000013d3d7824ULL, 0x000fe200000e0e3bULL,
0x003d09003f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3c7819ULL, 0x000fc8000001143dULL, 0x0000003f3c3c7211ULL, 0x000fca00078110ffULL,
0x000000ffff3d7224ULL, 0x000fca00000e063dULL, 0x000000023c3c7819ULL, 0x000fc8000000123dULL,
0x0000003c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000140407810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8c00ff3d7984ULL, 0x000e640000000800ULL, 0x800000003dff7812ULL, 0x002fe4000780483eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000001383a7810ULL, 0x000fe20007ffe0ffULL,
0x0000099000017945ULL, 0x000fe60003800000ULL, 0x000000373a00720cULL, 0x000fda0003f06070ULL,
0x0000052000008947ULL, 0x000fea0003800000ULL, 0x0000000162437824ULL, 0x000fe200078e0205ULL,
0x0000002034407811ULL, 0x000fe200078e30ffULL, 0x00000004383a7824ULL, 0x000fe200078e0239ULL,
0x00000002054b7810ULL, 0x000fe20007ffe0ffULL, 0x00000010323e7824ULL, 0x000fe200078e00ffULL,
0x010a0000433c7984ULL, 0x000e620000004800ULL, 0x00000100ff457424ULL, 0x000fe200078e00ffULL,
0x000000203a3a7811ULL, 0x000fe200078e30ffULL, 0x0000001043427824ULL, 0x000fe200078e00ffULL,
0x000000f03e477812ULL, 0x000fe200078ec0ffULL, 0x00000001624d7824ULL, 0x000fe200078e024bULL,
0x0000003a613b7217ULL, 0x000fca0007800000ULL, 0x000000013b3b7824ULL, 0x000fe400078e0a3aULL,
0x00000001433a7824ULL, 0x000fc600078e0240ULL, 0x0000003b623b7217ULL, 0x000fca0007800000ULL,
0x000000013b3e7824ULL, 0x000fca00078e0a62ULL, 0x0000003e0500720cULL, 0x000fe20003f06070ULL,
0x010ac0003c3d7984ULL, 0x002e640000004800ULL, 0x0000003d0c3a7224ULL, 0x002fe400078e023aULL,
0x00000001433d7824ULL, 0x000fe400078e0232ULL, 0x00005e003a3a7625ULL, 0x000fca00078e0045ULL,
0x000000473a3c7210ULL, 0x000fe40007f3e0ffULL, 0xfffffff0423a7812ULL, 0x000fe200078ee23dULL,
0x000000014d427824ULL, 0x040fe400078e0232ULL, 0x000000ffff3d7224ULL, 0x000fe200008e063bULL,
0x0000e0003a497811ULL, 0x000fe200078e20ffULL, 0x000000014d3a7824ULL, 0x040fe400078e0240ULL,
0x000000104d4d7824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c497faeULL, 0x0003e2000c101c46ULL, 0x0000003e4b00720cULL, 0x000fc40003f06070ULL,
0xfffffff04d427812ULL, 0x000fe200078ee242ULL, 0x010a0800433f7984ULL, 0x000ea20000004800ULL,
0x00000004054b7810ULL, 0x000fca0007ffe0ffULL, 0x00000001624d7824ULL, 0x000fe200078e024bULL,
0x0000e00042497811ULL, 0x002fc600078e20ffULL, 0x000000014d427824ULL, 0x000fe200078e0232ULL,
0x010ac0003f3f7984ULL, 0x004e640000004800ULL, 0x0000003f0c3a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0045ULL, 0x000000473a3c7210ULL, 0x000fe20007f3e0ffULL,
0x000000014d3a7824ULL, 0x040fe400078e0240ULL, 0x000000104d4d7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fc600008e063bULL, 0xfffffff04d427812ULL, 0x000fe400078ee242ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c497faeULL, 0x0003e2000c101c46ULL,
0x0000003e4b00720cULL, 0x000fe40003f06070ULL, 0x00000006054b7810ULL, 0x000fe20007ffe0ffULL,
0x010a1000433f7984ULL, 0x000ea80000004800ULL, 0x00000001624d7824ULL, 0x000fe200078e024bULL,
0x0000e00042497811ULL, 0x002fe200078e20ffULL, 0x010ac0003f3f7984ULL, 0x004e640000004800ULL,
0x0000003f0c3a7224ULL, 0x002fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0045ULL,
0x000000473a3c7210ULL, 0x000fe20007f3e0ffULL, 0x000000014d3a7824ULL, 0x040fe400078e0240ULL,
0x000000014d407824ULL, 0x040fe400078e0232ULL, 0x000000ffff3d7224ULL, 0x000fe400008e063bULL,
0x000000104d4d7824ULL, 0x000fc600078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c497faeULL, 0x0003e2000c101c46ULL, 0x0000003e4b00720cULL, 0x000fe40003f06070ULL,
0xfffffff04d407812ULL, 0x000fe200078ee240ULL, 0x010a1800433f7984ULL, 0x000ea60000004800ULL,
0x0000e000403d7811ULL, 0x002fe200078e20ffULL, 0x010ac0003f3f7984ULL, 0x004e640000004800ULL,
0x0000003f0c3a7224ULL, 0x002fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0045ULL,
0x000000473a3a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fca00008e063bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e2000c101c46ULL,
0x0000044000007947ULL, 0x000fea0003800000ULL, 0x0000000162437824ULL, 0x000fe200078e0205ULL,
0x0000002034427811ULL, 0x000fe200078e30ffULL, 0x00000010323c7824ULL, 0x000fe400078e00ffULL,
0x00000100ff447424ULL, 0x000fe200078e00ffULL, 0x010a0000433e7984ULL, 0x000e620000004800ULL,
0x00000001433a7824ULL, 0x040fe200078e0242ULL, 0x000000f03c457812ULL, 0x000fe200078ec0ffULL,
0x00000001433d7824ULL, 0x040fe200078e0232ULL, 0x00000002433f7810ULL, 0x040fe20007ffe0ffULL,
0x0000001043407824ULL, 0x000fc800078e00ffULL, 0x000000013f467824ULL, 0x000fe200078e0232ULL,
0x010ac0003e3b7984ULL, 0x002e640000004800ULL, 0x0000003b0c3b7224ULL, 0x002fc800078e023aULL,
0x00005e003b3a7625ULL, 0x000fca00078e0044ULL, 0x000000453a3c7210ULL, 0x000fe40007f1e0ffULL,
0xfffffff0403a7812ULL, 0x000fc600078ee23dULL, 0x000000ffff3d7224ULL, 0x000fe200000e063bULL,
0x0000e0003a477811ULL, 0x000fe200078e20ffULL, 0x00000001423a7824ULL, 0x000fe400078e023fULL,
0x000000103f3f7824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c477faeULL, 0x0003e6000b901c46ULL, 0xfffffff03f467812ULL, 0x000fe200078ee246ULL,
0x010a080043407984ULL, 0x000ea60000004800ULL, 0x0000e00046477811ULL, 0x002fc400078e20ffULL,
0x00000004433d7810ULL, 0x000fca0007ffe0ffULL, 0x000000013d467824ULL, 0x000fe200078e0232ULL,
0x010ac000403b7984ULL, 0x004e640000004800ULL, 0x0000003b0c3b7224ULL, 0x002fc800078e023aULL,
0x00005e003b3a7625ULL, 0x000fca00078e0044ULL, 0x000000453a3e7210ULL, 0x000fe20007f1e0ffULL,
0x00000001423a7824ULL, 0x000fe400078e023dULL, 0x000000103d3d7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3f7224ULL, 0x000fc600000e063bULL, 0xfffffff03d467812ULL, 0x000fe400078ee246ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e477faeULL, 0x0003e8000b901c46ULL,
0x010a100043407984ULL, 0x000ea20000004800ULL, 0x0000e000463f7811ULL, 0x002fe400078e20ffULL,
0x0000000643477810ULL, 0x000fca0007ffe0ffULL, 0x0000000142427824ULL, 0x000fe200078e0247ULL,
0x010ac000403b7984ULL, 0x0042a40000004800ULL, 0x0000000147407824ULL, 0x042fe400078e0232ULL,
0x0000001047477824ULL, 0x000fca00078e00ffULL, 0xfffffff047407812ULL, 0x000fe200078ee240ULL,
0x0000003b0c3b7224ULL, 0x004fc800078e023aULL, 0x00005e003b3a7625ULL, 0x000fca00078e0044ULL,
0x000000453a3c7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff3d7224ULL, 0x000fca00000e063bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c3f7faeULL, 0x0003e8000b901c46ULL,
0x010a1800433e7984ULL, 0x000ea20000004800ULL, 0x0000e000403d7811ULL, 0x002fc600078e20ffULL,
0x010ac0003e3b7984ULL, 0x004e640000004800ULL, 0x0000003b0c3b7224ULL, 0x002fc800078e0242ULL,
0x00005e003b3a7625ULL, 0x000fca00078e0044ULL, 0x000000453a3a7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff3b7224ULL, 0x000fca00000e063bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a3d7faeULL, 0x0003e6000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8800ff3a7f8cULL, 0x002e64000c80043fULL,
0x000000ffff437224ULL, 0x002fc400078e003bULL, 0x00000000003a7805ULL, 0x000fca0000015200ULL,
0x010b8c00ff3c7984ULL, 0x000e640000000800ULL, 0x800000003cff7812ULL, 0x002fe40007804843ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff3e7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003c7805ULL, 0x000fcc0000015200ULL, 0x0000003c3a3f7210ULL, 0x000fca0007f1e1ffULL,
0x000000013d3d7824ULL, 0x000fe200000e0e3bULL, 0x003d09003f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3c7819ULL, 0x000fc8000001143dULL,
0x0000003f3c3c7211ULL, 0x000fca00078110ffULL, 0x000000ffff3d7224ULL, 0x000fca00000e063dULL,
0x000000023c3c7819ULL, 0x000fc8000000123dULL, 0x0000003c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8c00ff3c7984ULL, 0x000e640000000800ULL,
0x800000003cff7812ULL, 0x002fe40007804843ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000383500720cULL, 0x000fe20003f04070ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x000000034100780cULL, 0x000fda0003f25270ULL, 0x000000f000008947ULL, 0x000fea0000800000ULL,
0x000000030b00780cULL, 0x000fe40003f04070ULL, 0x000000010d0d7810ULL, 0x000fd60007ffe0ffULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x00000004363a7824ULL, 0x000fe200078e020bULL,
0x000064000d3b7a10ULL, 0x040fe20007ffe0ffULL, 0x00000004ff3d7424ULL, 0x000fe200078e00ffULL,
0x000000640d00720cULL, 0x000fe20003f06070ULL, 0x000000023a3a7824ULL, 0x000fe200078e00ffULL,
0x00010ac00b3f7811ULL, 0x000fc600078e10ffULL, 0x000064003a3a7a24ULL, 0x000fc800078e023bULL,
0x000060003a3a7625ULL, 0x000fca00078e003dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a3f7faeULL, 0x0003e4000c121846ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000018000017945ULL, 0x000fe20003800000ULL, 0x0000016000004947ULL, 0x000fea0003800000ULL,
0x000000383500720cULL, 0x000fe40003f04070ULL, 0x00000001413a7810ULL, 0x002fc80007ffe0ffULL,
0x000000033a3b7812ULL, 0x000fce00078ec0ffULL, 0x00000002ff3a8819ULL, 0x000fca000001163aULL,
0x0000000139397824ULL, 0x000fc800078e023aULL, 0x00000040393a7824ULL, 0x040fe200078e00ffULL,
0x0000003839387211ULL, 0x000fc800078ff0ffULL, 0x000000c03a397812ULL, 0x000fe400078ec0ffULL,
0x000000ff3b3a7207ULL, 0x000fe40004000000ULL, 0x00010a000b3b7811ULL, 0x000fe200078e10ffULL,
0x0000010038397824ULL, 0x000fe400078e0239ULL, 0x0000000163387824ULL, 0x000fe400078e023aULL,
0x000000010b3a7824ULL, 0x100fe400078e0239ULL, 0x0000680038387a24ULL, 0x000fc400078e0239ULL,
0x00000004ff397424ULL, 0x000fe200078e00ffULL, 0x000000613a00720cULL, 0x000fe20003f06070ULL,
0x000000010b387824ULL, 0x000fc800078e0238ULL, 0x0000660038387625ULL, 0x000fd000078e0039ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000383b7faeULL, 0x0003e4000c121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x010b8000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000ff7200720cULL, 0x000fe20003f05270ULL,
0x010b8000ff5c7f8cULL, 0x000e62000c80043fULL, 0x000007d000017945ULL, 0x000ff60003800000ULL,
0x000007b000000947ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b380062387f8cULL, 0x000ea4000c80043fULL, 0x000000ffff3c7224ULL, 0x004fc400078e0039ULL,
0x0000000000387805ULL, 0x000fca0000015200ULL, 0x010b3c0062097984ULL, 0x000ea40000000800ULL,
0x8000000009ff7812ULL, 0x004fc4000780483cULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000027945ULL, 0x000fe20003800000ULL, 0x000000ffff3d7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103d00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000037945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383a7210ULL, 0x000fca0007f1e1ffULL, 0x000000013b3b7824ULL, 0x000fe200000e0e39ULL,
0x003d09003a00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403a00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff097819ULL, 0x000fc8000001143bULL, 0x0000003a09097211ULL, 0x000fca00078110ffULL,
0x000000ffff3a7224ULL, 0x000fca00000e063bULL, 0x0000000209097819ULL, 0x000fc8000000123aULL,
0x000000090000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000037941ULL, 0x000fea0003800000ULL,
0x010b3c0062097984ULL, 0x000ea40000000800ULL, 0x8000000009ff7812ULL, 0x004fe4000780483cULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000001032097824ULL, 0x000fe200078e00ffULL,
0x00000001ff387819ULL, 0x000fc80000011632ULL, 0x0000007009097812ULL, 0x000fe400078ec0ffULL,
0x0000000c38387812ULL, 0x000fca00078ec0ffULL, 0x00000001093f7824ULL, 0x000fca00078e0238ULL,
0x010180003f3a7984ULL, 0x000ea80000000800ULL, 0x010380003f3b7984ULL, 0x0006620000000800ULL,
0x0000000f3a00720bULL, 0x004fe20003f1d000ULL, 0x0000df027f007947ULL, 0x000fd8000b800000ULL,
0x0000000000097806ULL, 0x008fc800000e0100ULL, 0x0000ffff09407812ULL, 0x000fe2000780c0ffULL,
0x0000043000027945ULL, 0x000fe20003800000ULL, 0x00000001ff097424ULL, 0x000fe400078e00ffULL,
0x000000ffff3c7224ULL, 0x000fd200078e000fULL, 0x000003f000008947ULL, 0x000fea0003800000ULL,
0x000000036500780cULL, 0x000fe40003f05270ULL, 0x0000000f3a00720bULL, 0x000fe20003f34000ULL,
0x0000dec27f007947ULL, 0x000fd8000b800000ULL, 0x00000000003d7806ULL, 0x000fc400008e0100ULL,
0x0000003a0f3c7209ULL, 0x000fe20007810000ULL, 0x0000033000037945ULL, 0x000fe20003800000ULL,
0x000099103d387816ULL, 0x000fc600000000ffULL, 0x0105803c3f008388ULL, 0x0005e20000000800ULL,
0x000000ff3800720cULL, 0x000fda0003f05270ULL, 0x000002e000008947ULL, 0x000fea0003800000ULL,
0x8000003c0f0f7221ULL, 0x004fe20000010000ULL, 0x000000ff3dff7812ULL, 0x000fe2000780c0ffULL,
0x0000017000047945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b0f0f7820ULL, 0x000fc80000410000ULL,
0x0000000f00417308ULL, 0x000ea40000000800ULL, 0x0000004112127220ULL, 0x004fc80000410000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x0000de127f007947ULL, 0x000fea000b800000ULL,
0x00001f69410f7589ULL, 0x0004e400000e0000ULL, 0x0000000f13137220ULL, 0x088fe20000410000ULL,
0x0000000f14147220ULL, 0x080fe20000410000ULL, 0x0000000f17177220ULL, 0x080fe20000410000ULL,
0x0000000f18187220ULL, 0x080fe20000410000ULL, 0x0000000f1b1b7220ULL, 0x080fe20000410000ULL,
0x0000000f1c1c7220ULL, 0x080fe20000410000ULL, 0x0000000f1f1f7220ULL, 0x080fe20000410000ULL,
0x0000000f20207220ULL, 0x080fe20000410000ULL, 0x0000000f23237220ULL, 0x080fe20000410000ULL,
0x0000000f24247220ULL, 0x080fe20000410000ULL, 0x0000000f27277220ULL, 0x080fe20000410000ULL,
0x0000000f28287220ULL, 0x080fe20000410000ULL, 0x0000000f2b2b7220ULL, 0x080fe20000410000ULL,
0x0000000f2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000f2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000f30307220ULL, 0x000fc40000410000ULL, 0x0000000000047941ULL, 0x000fea0003800000ULL,
0x0000ff003dff7812ULL, 0x000fda000780c0ffULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x0000dd227f007947ULL, 0x000fea000b800000ULL, 0x00001f68410f7589ULL, 0x0006a400000e0000ULL,
0x0000000f15157220ULL, 0x084fe20000410000ULL, 0x0000000f16167220ULL, 0x080fe20000410000ULL,
0x0000000f19197220ULL, 0x080fe20000410000ULL, 0x0000000f1a1a7220ULL, 0x080fe20000410000ULL,
0x0000000f1d1d7220ULL, 0x080fe20000410000ULL, 0x0000000f1e1e7220ULL, 0x080fe20000410000ULL,
0x0000000f21217220ULL, 0x080fe20000410000ULL, 0x0000000f22227220ULL, 0x080fe20000410000ULL,
0x0000000f25257220ULL, 0x080fe20000410000ULL, 0x0000000f26267220ULL, 0x080fe20000410000ULL,
0x0000000f29297220ULL, 0x080fe20000410000ULL, 0x0000000f2a2a7220ULL, 0x080fe20000410000ULL,
0x0000000f2d2d7220ULL, 0x080fe20000410000ULL, 0x0000000f2e2e7220ULL, 0x080fe20000410000ULL,
0x0000000f31317220ULL, 0x080fe20000410000ULL, 0x0000000f60607220ULL, 0x000fc40000410000ULL,
0x0000000000037941ULL, 0x004fea0003800000ULL, 0x0000ffff40ff7812ULL, 0x000fda000780603dULL,
0x8000003c3a3a0221ULL, 0x000fe20000010000ULL, 0x00007610ff090816ULL, 0x000fc60000000009ULL,
0x3fb8aa3b3a3a0820ULL, 0x000fc80000410000ULL, 0x0000003a00080308ULL, 0x000ea40000000800ULL,
0x000000083b3b0220ULL, 0x006fcc0000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x000000123b127221ULL, 0x002fe20000010000ULL, 0x000000ffff0f7224ULL, 0x000fc400078e003cULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ff09ff7812ULL, 0x000fe2000786c0ffULL,
0x0000012000017945ULL, 0x000fd80003800000ULL, 0x0000010000003947ULL, 0x000fea0003800000ULL,
0x00000008ff06723eULL, 0x000fc800000010ffULL, 0x00005410063a7816ULL, 0x000fe20000000006ULL,
0x0000db627f007947ULL, 0x000fea000b800000ULL, 0x00001f693a077589ULL, 0x0004e400000e0000ULL,
0x0000dba27f007947ULL, 0x000fea000b800000ULL, 0x00001f683a067589ULL, 0x0004e400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000010693f7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff3e7224ULL, 0x000fe200078e003aULL, 0x0001971000387802ULL, 0x000fc40000000f00ULL,
0x0000e1a000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000ffff3e7224ULL, 0x004fe200078e003aULL, 0x00000018693f7810ULL, 0x002fe40007ffe0ffULL,
0x0001976000387802ULL, 0x000fc40000000f00ULL, 0x0000e15000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000000440783bULL, 0x008ee20000004200ULL, 0x00001e9000017945ULL, 0x000fe60003800000ULL,
0x000000000244783bULL, 0x000f280000004200ULL, 0x000000000038783bULL, 0x004ea80000004200ULL,
0x00000000033c783bULL, 0x002e620000004200ULL, 0x0000010040ae7824ULL, 0x008fe200078e00ffULL,
0x0000004000b47306ULL, 0x000fe20000009400ULL, 0x00000018ffd07819ULL, 0x000fe20000011440ULL,
0x0000010042cf7824ULL, 0x040fe200078e00ffULL, 0x00000018ffbd7819ULL, 0x000fe20000011441ULL,
0x0001000042ca7824ULL, 0x000fe200078e00ffULL, 0x00000018ffb87819ULL, 0x000fe200000114aeULL,
0x0001000040ae7824ULL, 0x000fe200078e00ffULL, 0x00000018ffcf7819ULL, 0x000fe200000114cfULL,
0x0000004000b77306ULL, 0x000ee20000005400ULL, 0x0000010043c87824ULL, 0x040fe200078e00ffULL,
0x00000018ffca7819ULL, 0x000fe200000114caULL, 0x0001000043c37824ULL, 0x000fe200078e00ffULL,
0x00000018ffbe7819ULL, 0x000fe200000114aeULL, 0x0000010041ae7824ULL, 0x040fe200078e00ffULL,
0x00000018ffc87819ULL, 0x000fe200000114c8ULL, 0x0000010044c17824ULL, 0x050fe200078e00ffULL,
0x0000004000977306ULL, 0x000f22000000d400ULL, 0x00000018ffac7819ULL, 0x000fe20000011442ULL,
0x0001000044b67824ULL, 0x000fe200078e00ffULL, 0x00000018ffd57819ULL, 0x000fe200000114aeULL,
0x0001000041ae7824ULL, 0x000fe200078e00ffULL, 0x00000018ff8b7819ULL, 0x000fe20000011443ULL,
0x0000010045b17824ULL, 0x000fe200078e00ffULL, 0x00000018ff9d7819ULL, 0x000fe20000011446ULL,
0x000000b800b97306ULL, 0x000fe20000209400ULL, 0x000000b7b400720bULL, 0x008fc40003f1d000ULL,
0x00000018ffd77819ULL, 0x000fe200000114aeULL, 0x0001000045ae7824ULL, 0x000fe200078e00ffULL,
0x00000018ff547819ULL, 0x000fe40000011447ULL, 0x000000d000b47245ULL, 0x000fe2000020d400ULL,
0x000000b800407306ULL, 0x000ee20000205400ULL, 0x00000018ffc37819ULL, 0x000fe400000114c3ULL,
0x00000018ffc17819ULL, 0x000fe400000114c1ULL, 0x00000018ffb67819ULL, 0x000fc400000114b6ULL,
0x0000000197970812ULL, 0x010fe200078efcffULL, 0x000000be00bc7306ULL, 0x000fe20000209400ULL,
0x00000018ff8d7819ULL, 0x000fe40000011444ULL, 0x00000018ffb17819ULL, 0x000fe400000114b1ULL,
0x00000018ffae7819ULL, 0x000fe400000114aeULL, 0x00000018ffa37819ULL, 0x000fe20000011445ULL,
0x000000be00cb7306ULL, 0x000f220000205400ULL, 0x00000040b900720bULL, 0x008fe20003f3d000ULL,
0x0001000047b97824ULL, 0x000fe200078e00ffULL, 0x000000b800407245ULL, 0x000fc4000020d400ULL,
0x000000d500b87245ULL, 0x000fe4000020d400ULL, 0x00000018ff827819ULL, 0x004fe20000011438ULL,
0x0000004100d37306ULL, 0x000fe20000009400ULL, 0x00000018ffb97819ULL, 0x000fe400000114b9ULL,
0x00000018ff987819ULL, 0x002fe4000001143cULL, 0x00000018ff5b7819ULL, 0x000fe4000001143dULL,
0x0000000140401812ULL, 0x000fe200078efcffULL, 0x0000004100d47306ULL, 0x000e620000005400ULL,
0x000000cbbc00720bULL, 0x010fc40003f5d000ULL, 0x00000018ff4c7819ULL, 0x000fe4000001143eULL,
0x00000018ff5c7819ULL, 0x000fe4000001143aULL, 0x00000018ff4e7819ULL, 0x000fe2000001143fULL,
0x00000041008f7306ULL, 0x000ea2000000d400ULL, 0x00000018ff7b7819ULL, 0x000fe40000011439ULL,
0x00000018ff5e7819ULL, 0x000fca000001143bULL, 0x000000d500d67306ULL, 0x000fe20000209400ULL,
0x000000d4d300720bULL, 0x002fce0003f1d000ULL, 0x000000d500417306ULL, 0x000e6c0000205400ULL,
0x000000018f8f0812ULL, 0x004fe400078efcffULL, 0x000000d000d17306ULL, 0x000ff00000209400ULL,
0x000000d000d27306ULL, 0x000ea20000205400ULL, 0x00000041d600720bULL, 0x002fc40003f3d000ULL,
0x000000be00417245ULL, 0x000fc8000020d400ULL, 0x0000000141412812ULL, 0x000fe200078efcffULL,
0x000000d700d87306ULL, 0x000fec0000209400ULL, 0x00000001b8b81812ULL, 0x000fe400078efcffULL,
0x000000d700d97306ULL, 0x000e620000205400ULL, 0x000000d2d100720bULL, 0x004fce0003fdd000ULL,
0x000000cf00da7306ULL, 0x000fec0000209400ULL, 0x00000001b4b46812ULL, 0x000fe400078efcffULL,
0x000000cf00db7306ULL, 0x000ea20000205400ULL, 0x000000d9d800720bULL, 0x002fce0003f5d000ULL,
0x0000004200ba7306ULL, 0x000ff00000009400ULL, 0x0000004200bb7306ULL, 0x000e620000005400ULL,
0x000000dbda00720bULL, 0x004fce0003f3d000ULL, 0x000000bd00bf7306ULL, 0x000ff00000209400ULL,
0x000000bd00c07306ULL, 0x0004e20000205400ULL, 0x000000bbba00720bULL, 0x002fe40003f1d000ULL,
0x000000cf00bb7245ULL, 0x000fc4000020d400ULL, 0x000000bd00ba7245ULL, 0x000fe4000020d400ULL,
0x00000001bbbb1812ULL, 0x000fe200078efcffULL, 0x000000ca00dc7306ULL, 0x000fe20000209400ULL,
0x000000ca00bd7245ULL, 0x004fce000020d400ULL, 0x000000ca00dd7306ULL, 0x000fe20000205400ULL,
0x000000c0bf00720bULL, 0x008fe40003fdd000ULL, 0x000000ac00c07245ULL, 0x000fca000020d400ULL,
0x0000004200587306ULL, 0x0002ac000000d400ULL, 0x00000001baba6812ULL, 0x000fe400078efcffULL,
0x0000004300af7306ULL, 0x000fe20000009400ULL, 0x0001000046427824ULL, 0x002fca00078e00ffULL,
0x00000018ff427819ULL, 0x000fe40000011442ULL, 0x00000043008e7306ULL, 0x000e620000005400ULL,
0x0000000158580812ULL, 0x004fc800078efcffULL, 0x00000058bb58723eULL, 0x000fc600000010ffULL,
0x0000004300597306ULL, 0x0004f0000000d400ULL, 0x000000c800ce7306ULL, 0x000fe20000209400ULL,
0x0000010046437824ULL, 0x004fe200078e00ffULL, 0x0000008eaf00720bULL, 0x002fc80003f1d000ULL,
0x00000018ff437819ULL, 0x000fe40000011443ULL, 0x000000c800df7306ULL, 0x000e6e0000205400ULL,
0x0000000159590812ULL, 0x008fe200078efcffULL, 0x0000004600a47306ULL, 0x000ff00000009400ULL,
0x0000004600a57306ULL, 0x000fe20000005400ULL, 0x000000dfce00720bULL, 0x002fce0003f3d000ULL,
0x0000004600817306ULL, 0x0003f0000000d400ULL, 0x00000047009f7306ULL, 0x000fe20000009400ULL,
0x0000010047467824ULL, 0x002fca00078e00ffULL, 0x00000018ff467819ULL, 0x000fe40000011446ULL,
0x0000004700a07306ULL, 0x000ff00000005400ULL, 0x0000004700807306ULL, 0x0003f0000000d400ULL,
0x000000ac00857306ULL, 0x000fe20000209400ULL, 0x0000010038477824ULL, 0x002fca00078e00ffULL,
0x00000018ffbf7819ULL, 0x000fe40000011447ULL, 0x000000ac00887306ULL, 0x0002a20000205400ULL,
0x000000d700477245ULL, 0x000fc8000020d400ULL, 0x0000000147472812ULL, 0x000fe400078efcffULL,
0x000000dddc00720bULL, 0x000fe20003f5d000ULL, 0x000000c300cc7306ULL, 0x000fe20000209400ULL,
0x000000c800ac7245ULL, 0x002fc8000020d400ULL, 0x00000001acac1812ULL, 0x000fc600078efcffULL,
0x000000c300cd7306ULL, 0x000e620000205400ULL, 0x000000888500720bULL, 0x004fe40003fdd000ULL,
0x00000059ac59723eULL, 0x000fe400000010ffULL, 0x00000001bdbd2812ULL, 0x000fc600078efcffULL,
0x0000008b00ad7306ULL, 0x000fec0000209400ULL, 0x00000001c0c06812ULL, 0x000fe400078efcffULL,
0x0000008b008a7306ULL, 0x000ea20000205400ULL, 0x000000cdcc00720bULL, 0x002fce0003f5d000ULL,
0x000000c100c67306ULL, 0x000ff00000209400ULL, 0x000000c100c97306ULL, 0x000e620000205400ULL,
0x0000008aad00720bULL, 0x004fe40003f3d000ULL, 0x0000008b00ad7245ULL, 0x000fc4000020d400ULL,
0x000000c1008b7245ULL, 0x000fc6000020d400ULL, 0x0000004400aa7306ULL, 0x000fec0000009400ULL,
0x00000001adad1812ULL, 0x000fe400078efcffULL, 0x0000004400897306ULL, 0x000ea20000005400ULL,
0x000000c9c600720bULL, 0x002fce0003f1d000ULL, 0x000000b600c47306ULL, 0x000fec0000209400ULL,
0x000000018b8b0812ULL, 0x000fe400078efcffULL, 0x000000b600c57306ULL, 0x000e620000205400ULL,
0x00000089aa00720bULL, 0x004fe40003fdd000ULL, 0x000000c300aa7245ULL, 0x000fc8000020d400ULL,
0x00000001aaaa2812ULL, 0x000fe200078efcffULL, 0x00000045008c7306ULL, 0x000ff00000009400ULL,
0x0000004500a97306ULL, 0x000ea20000005400ULL, 0x000000c5c400720bULL, 0x002fce0003f5d000ULL,
0x0000008d00a87306ULL, 0x000ff00000209400ULL, 0x0000008d00ab7306ULL, 0x0002e20000205400ULL,
0x000000a98c00720bULL, 0x004fe40003f3d000ULL, 0x000000b6008c7245ULL, 0x000fc8000020d400ULL,
0x000000018c8c2812ULL, 0x000fe200078efcffULL, 0x0000004400847306ULL, 0x000ea2000000d400ULL,
0x0000008d008d7245ULL, 0x002fce000020d400ULL, 0x000000b100c27306ULL, 0x000fe20000209400ULL,
0x000000aba800720bULL, 0x008fe20003f1d000ULL, 0x000100003ca87824ULL, 0x000fca00078e00ffULL,
0x00000018ffa97819ULL, 0x000fe200000114a8ULL, 0x000000b100c77306ULL, 0x000e620000205400ULL,
0x0000000184846812ULL, 0x004fe400078efcffULL, 0x000000b100a87245ULL, 0x000fe4000020d400ULL,
0x000000848b84723eULL, 0x000fe400000010ffULL, 0x000000018d8d0812ULL, 0x000fe200078efcffULL,
0x000000ae00b57306ULL, 0x000fe20000209400ULL, 0x000000a5a400720bULL, 0x000fe20003f1d000ULL,
0x000001003da47824ULL, 0x000fca00078e00ffULL, 0x00000018ffa57819ULL, 0x000fe200000114a4ULL,
0x000000ae00b27306ULL, 0x0004e20000205400ULL, 0x000000c7c200720bULL, 0x002fe40003fdd000ULL,
0x0000004300a47245ULL, 0x000fc6000020d400ULL, 0x0000000181810812ULL, 0x000fe400078efcffULL,
0x0000004500837306ULL, 0x000e62000000d400ULL, 0x000000ae00ae7245ULL, 0x004fca000020d400ULL,
0x00000001a8a86812ULL, 0x000fe400078efcffULL, 0x0000004300b07306ULL, 0x000fe20000209400ULL,
0x000000b2b500720bULL, 0x008fce0003f5d000ULL, 0x0000004300b37306ULL, 0x000ea20000205400ULL,
0x0000000183831812ULL, 0x002fca00078efcffULL, 0x00000001aeae2812ULL, 0x000fe400078efcffULL,
0x000000a300a67306ULL, 0x000ff00000209400ULL, 0x000000a300a77306ULL, 0x0002e20000205400ULL,
0x000000b3b000720bULL, 0x004fe20003f3d000ULL, 0x000100003ab07824ULL, 0x000fca00078e00ffULL,
0x00000018ffb07819ULL, 0x000fe200000114b0ULL, 0x0000004200447306ULL, 0x000fe20000209400ULL,
0x000000a300a37245ULL, 0x002fca000020d400ULL, 0x00000001a4a41812ULL, 0x000fe400078efcffULL,
0x0000004200457306ULL, 0x000e620000205400ULL, 0x000000a7a600720bULL, 0x008fce0003fdd000ULL,
0x0000009d00a17306ULL, 0x000fec0000209400ULL, 0x00000001a3a36812ULL, 0x000fe400078efcffULL,
0x0000009d00a27306ULL, 0x0004e20000205400ULL, 0x000000454400720bULL, 0x002fe40003f5d000ULL,
0x000000a09f00720bULL, 0x000fc40003fdd000ULL, 0x00000042009f7245ULL, 0x000fe4000020d400ULL,
0x0000009d00a07245ULL, 0x000fe2000020d400ULL, 0x0000003800917306ULL, 0x000fe20000009400ULL,
0x00000046009d7245ULL, 0x004fca000020d400ULL, 0x000000019f9f2812ULL, 0x000fe400078efcffULL,
0x0000003800967306ULL, 0x000fe20000005400ULL, 0x000000a2a100720bULL, 0x008fe40003f3d000ULL,
0x0000000180806812ULL, 0x000fe400078efcffULL, 0x000000bf00a27245ULL, 0x000fc6000020d400ULL,
0x0000003800777306ULL, 0x0003ec000000d400ULL, 0x00000001a0a01812ULL, 0x000fe400078efcffULL,
0x0000004600b77306ULL, 0x000fe20000209400ULL, 0x0001000038387824ULL, 0x002fe200078e00ffULL,
0x0000009fa0a0723eULL, 0x000fc800000010ffULL, 0x00000018ff887819ULL, 0x000fe20000011438ULL,
0x0000010039387824ULL, 0x000fe200078e00ffULL, 0x0000004600bc7306ULL, 0x0002a80000205400ULL,
0x00000018ff897819ULL, 0x000fe20000011438ULL, 0x000001003c387824ULL, 0x000fc600078e00ffULL,
0x000000b900be7306ULL, 0x000fe20000209400ULL, 0x000001003e467824ULL, 0x002fe200078e00ffULL,
0x00000018ff387819ULL, 0x000fc80000011438ULL, 0x00000018ffa17819ULL, 0x000fe40000011446ULL,
0x000000b900cb7306ULL, 0x0002e20000205400ULL, 0x000000bcb700720bULL, 0x004fe40003f1d000ULL,
0x000000a500467245ULL, 0x000fca000020d400ULL, 0x0000005400577306ULL, 0x000fe20000209400ULL,
0x000000b900b97245ULL, 0x002fca000020d400ULL, 0x000000019d9d0812ULL, 0x000fe400078efcffULL,
0x00000054009e7306ULL, 0x000e620000205400ULL, 0x000000cbbe00720bULL, 0x008fe40003f5d000ULL,
0x000000809d9d723eULL, 0x000fca00000010ffULL, 0x000000bf00d07306ULL, 0x000fec0000209400ULL,
0x00000001b9b92812ULL, 0x000fe400078efcffULL, 0x000000bf00cf7306ULL, 0x000ea20000205400ULL,
0x0000009e5700720bULL, 0x002fe40003f3d000ULL, 0x00000054009e7245ULL, 0x000fca000020d400ULL,
0x0000003c00557306ULL, 0x000fec0000009400ULL, 0x000000019e9e1812ULL, 0x000fe400078efcffULL,
0x0000003c00567306ULL, 0x000e620000005400ULL, 0x000000cfd000720bULL, 0x004fce0003f1d000ULL,
0x0000003c00487306ULL, 0x000eac000000d400ULL, 0x00000001a2a20812ULL, 0x000fe400078efcffULL,
0x0000003800af7306ULL, 0x000fe20000209400ULL, 0x000000565500720bULL, 0x002fe40003fdd000ULL,
0x0000b80067557811ULL, 0x000fca00078e20ffULL, 0x00000038003c7306ULL, 0x000e620000205400ULL,
0x000000005554783bULL, 0x000eea0000000200ULL, 0x0000000148486812ULL, 0x004fe400078efcffULL,
0x000000a900ab7306ULL, 0x000ff00000209400ULL, 0x000000a900a67306ULL, 0x0005220000205400ULL,
0x0000003caf00720bULL, 0x002fe20003f5d000ULL, 0x000001003aaf7824ULL, 0x000fca00078e00ffULL,
0x00000018ffaf7819ULL, 0x000fe200000114afULL, 0x0000003d009b7306ULL, 0x000fe20000009400ULL,
0x000000a900a97245ULL, 0x004fce000020d400ULL, 0x0000003d009a7306ULL, 0x000e620000005400ULL,
0x000000a6ab00720bULL, 0x010fe20003f3d000ULL, 0x0001000039ab7824ULL, 0x000fca00078e00ffULL,
0x00000018ffab7819ULL, 0x000fe200000114abULL, 0x0000003d00497306ULL, 0x000522000000d400ULL,
0x000000075454b231ULL, 0x088fe400003400ffULL, 0x000000075656b231ULL, 0x000fe400003400ffULL,
0x000000065555b231ULL, 0x080fe200003400ffULL, 0x00000001a9a91812ULL, 0x000fe200078efcffULL,
0x000000065757b231ULL, 0x000fe200003400ffULL, 0x00000098009c7306ULL, 0x000fe20000209400ULL,
0x000100003d3d7824ULL, 0x004fe200078e00ffULL, 0x0000009a9b00720bULL, 0x002fc40003f1d000ULL,
0x00000038009b7245ULL, 0x000fe2000020d400ULL, 0x000001003f387824ULL, 0x000fe200078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000009800997306ULL, 0x0002a20000205400ULL,
0x000000019b9b2812ULL, 0x000fe400078efcffULL, 0x00000098009a7245ULL, 0x000fe4000020d400ULL,
0x00000018ffa67819ULL, 0x000fe40000011438ULL, 0x0000000149490812ULL, 0x010fe200078efcffULL,
0x000000a500437306ULL, 0x000fe20000209400ULL, 0x00000041b438723eULL, 0x000fe200000010ffULL,
0x000100003b987824ULL, 0x002fe200078e00ffULL, 0x000000489b48723eULL, 0x000fc800000010ffULL,
0x00000018ff987819ULL, 0x000fe20000011498ULL, 0x000000a500447306ULL, 0x000e620000205400ULL,
0x000000999c00720bULL, 0x004fe20003fdd000ULL, 0x000001003b997824ULL, 0x000fe200078e00ffULL,
0x0000009800b17245ULL, 0x000fc8000020d400ULL, 0x00000018ff997819ULL, 0x000fe20000011499ULL,
0x0000003d00427306ULL, 0x000fec0000209400ULL, 0x000000019a9a6812ULL, 0x000fe400078efcffULL,
0x0000003d00457306ULL, 0x0004e20000205400ULL, 0x000000444300720bULL, 0x002fc40003f5d000ULL,
0x000000969100720bULL, 0x000fe40003fdd000ULL, 0x0000003d00917245ULL, 0x000fe4000020d400ULL,
0x000000bdc044723eULL, 0x000fe200000010ffULL, 0x0000005b00957306ULL, 0x000fe20000209400ULL,
0x0000008fb83d723eULL, 0x004fca00000010ffULL, 0x0000000146462812ULL, 0x000fe400078efcffULL,
0x0000005b00947306ULL, 0x000e620000205400ULL, 0x000000454200720bULL, 0x008fe40003f3d000ULL,
0x000000aaad45723eULL, 0x000fe400000010ffULL, 0x000000494649723eULL, 0x000fe400000010ffULL,
0x0000000177776812ULL, 0x000fe200078efcffULL, 0x000000a1003c7306ULL, 0x000fe60000209400ULL,
0x00000077a2a2723eULL, 0x000fc600000010ffULL, 0x0000000191911812ULL, 0x000fe400078efcffULL,
0x000000a100a77306ULL, 0x0004e20000205400ULL, 0x000000949500720bULL, 0x002fce0003f5d000ULL,
0x0000003e00937306ULL, 0x000fe20000009400ULL, 0x000000a100a17245ULL, 0x004fce000020d400ULL,
0x0000003e00927306ULL, 0x000e620000005400ULL, 0x000000a73c00720bULL, 0x008fe40003f3d000ULL,
0x00000097403c723eULL, 0x000fe400000010ffULL, 0x0000b80066407811ULL, 0x000fc600078e20ffULL,
0x0000003e00507306ULL, 0x0004ec000000d400ULL, 0x00000001a1a11812ULL, 0x000fe400078efcffULL,
0x0000003f004d7306ULL, 0x000fe20000009400ULL, 0x000100003e3e7824ULL, 0x004fe200078e00ffULL,
0x000000929300720bULL, 0x002fc40003f1d000ULL, 0x0000005b00927245ULL, 0x000fe4000020d400ULL,
0x00000018ff9c7819ULL, 0x000fe4000001143eULL, 0x0000003f005a7306ULL, 0x000e620000005400ULL,
0x0000000192922812ULL, 0x000fcc00078efcffULL, 0x0000000150500812ULL, 0x008fe200078efcffULL,
0x0000003a007d7306ULL, 0x000fe60000009400ULL, 0x00000050a150723eULL, 0x000fe400000010ffULL,
0x000000b99ea1723eULL, 0x000fc600000010ffULL, 0x0000003a007c7306ULL, 0x000fe20000005400ULL,
0x0000005a4d00720bULL, 0x002fe40003f5d000ULL, 0x000000585458723cULL, 0x000f6a00000418ffULL,
0x0000003a00717306ULL, 0x000ff0000000d400ULL, 0x0000009c00437306ULL, 0x000ff00000209400ULL,
0x0000009c003a7306ULL, 0x0002b00000205400ULL, 0x0000004c00877306ULL, 0x000fe20000209400ULL,
0x0000009c009c7245ULL, 0x002fce000020d400ULL, 0x0000004c00907306ULL, 0x000e620000205400ULL,
0x0000003a4300720bULL, 0x004fe40003f3d000ULL, 0x000000004040783bULL, 0x000eaa0000000200ULL,
0x0000003f00517306ULL, 0x00072c000000d400ULL, 0x000000019c9c1812ULL, 0x000fc400078efcffULL,
0x000000a600967306ULL, 0x000fe20000209400ULL, 0x000100003f3f7824ULL, 0x008fe200078e00ffULL,
0x000000908700720bULL, 0x002fe40003f1d000ULL, 0x0000004c00877245ULL, 0x000fe4000020d400ULL,
0x00000018ff8f7819ULL, 0x000fe4000001143fULL, 0x000000a600937306ULL, 0x0002e20000205400ULL,
0x0000000151512812ULL, 0x010fe200078efcffULL, 0x0000003c543c723cULL, 0x000f6200000418ffULL,
0x0000004e00907245ULL, 0x000fc4000020d400ULL, 0x000000a99a4c723eULL, 0x000fe400000010ffULL,
0x0000000187870812ULL, 0x000fe200078efcffULL, 0x0000004e004a7306ULL, 0x000fe20000209400ULL,
0x000000a600a67245ULL, 0x002fce000020d400ULL, 0x0000004e004b7306ULL, 0x000e620000205400ULL,
0x000000939600720bULL, 0x008fe20003f3d000ULL, 0x000000074040b231ULL, 0x084fe400003400ffULL,
0x000000074242b231ULL, 0x000fe400003400ffULL, 0x000000064141b231ULL, 0x080fe400003400ffULL,
0x0000008f00947306ULL, 0x000fe20000209400ULL, 0x000000064343b231ULL, 0x000fca00003400ffULL,
0x00000001a6a61812ULL, 0x000fe400078efcffULL, 0x0000008f004d7306ULL, 0x0004e20000205400ULL,
0x0000004b4a00720bULL, 0x002fe40003f1d000ULL, 0x00000051a651723eULL, 0x000fe200000010ffULL,
0x000000485448723cULL, 0x000fe800000418ffULL, 0x0000003900867306ULL, 0x000fe20000009400ULL,
0x0000008f008f7245ULL, 0x004fca000020d400ULL, 0x0000000190900812ULL, 0x000fe400078efcffULL,
0x00000039004f7306ULL, 0x000e620000005400ULL, 0x0000004d9400720bULL, 0x008fe40003f5d000ULL,
0x00000091924d723eULL, 0x000fca00000010ffULL, 0x00000089008a7306ULL, 0x000fec0000209400ULL,
0x000000018f8f2812ULL, 0x000fe400078efcffULL, 0x0000008900957306ULL, 0x000ea20000205400ULL,
0x0000004f8600720bULL, 0x002fe40003f3d000ULL, 0x0000009c8786723eULL, 0x000fe200000010ffULL,
0x0000004c544c723cULL, 0x000fe200000418ffULL, 0x0000008f9087723eULL, 0x000fc400000010ffULL,
0x00000081a49c723eULL, 0x000fe200000010ffULL, 0x0000008200537306ULL, 0x000fec0000209400ULL,
0x0000009c4058723cULL, 0x020fe40000041858ULL, 0x0000008200527306ULL, 0x000e620000205400ULL,
0x000000958a00720bULL, 0x004fce0003fdd000ULL, 0x0000008800857306ULL, 0x000ff00000209400ULL,
0x00000088008e7306ULL, 0x0004e20000205400ULL, 0x000000525300720bULL, 0x002fe40003f5d000ULL,
0x000000505450723cULL, 0x000fea00000418ffULL, 0x0000003900787306ULL, 0x000322000000d400ULL,
0x0000008800887245ULL, 0x004fce000020d400ULL, 0x0000007b007f7306ULL, 0x000fe20000209400ULL,
0x00000047ba39723eULL, 0x002fe400000010ffULL, 0x0000008e8500720bULL, 0x008fe20003f1d000ULL,
0x000000445444723cULL, 0x000f6200000418ffULL, 0x00000083a885723eULL, 0x000fe400000010ffULL,
0x0000008200837245ULL, 0x000fe2000020d400ULL, 0x0000007b007e7306ULL, 0x000fe20000205400ULL,
0x0000000178781812ULL, 0x010fe400078efcffULL, 0x0000000183832812ULL, 0x000fe200078efcffULL,
0x00000084403c723cULL, 0x000fe2000004183cULL, 0x0000007c7d00720bULL, 0x000fc40003f5d000ULL,
0x0000007b007c7245ULL, 0x000fe2000020d400ULL, 0x000000ab00937306ULL, 0x000fe20000209400ULL,
0x0000000188880812ULL, 0x000fc800078efcffULL, 0x000000888388723eULL, 0x000fc600000010ffULL,
0x000000ab00947306ULL, 0x000e640000205400ULL, 0x0000000171712812ULL, 0x000fe400078efcffULL,
0x000000a04044723cULL, 0x020fe80000041844ULL, 0x0000003b00797306ULL, 0x000ff00000009400ULL,
0x0000003b007a7306ULL, 0x000fe20000005400ULL, 0x000000949300720bULL, 0x002fce0003f1d000ULL,
0x0000003b005f7306ULL, 0x0003f0000000d400ULL, 0x000000af00917306ULL, 0x000fe20000209400ULL,
0x000000385438723cULL, 0x042f6e00000418ffULL, 0x000000af00927306ULL, 0x000e620000205400ULL,
0x000000865454723cULL, 0x000b6e00000418ffULL, 0x000000aea387723eULL, 0x020fe200000010ffULL,
0x00000099008a7306ULL, 0x000fe20000209400ULL, 0x0000008900a37245ULL, 0x000fc4000020d400ULL,
0x000000ab00897245ULL, 0x000fe4000020d400ULL, 0x00000001a3a36812ULL, 0x000fe400078efcffULL,
0x0000007e7f00720bULL, 0x000fe20003fdd000ULL, 0x00000099008b7306ULL, 0x000ea20000205400ULL,
0x0000000189890812ULL, 0x000fe400078efcffULL, 0x000000929100720bULL, 0x002fe40003f3d000ULL,
0x00000078a3a3723eULL, 0x000fc400000010ffULL, 0x0000009900787245ULL, 0x000fe2000020d400ULL,
0x0000005e00757306ULL, 0x000fe20000209400ULL, 0x0000008c8d86723eULL, 0x000fc600000010ffULL,
0x000000017c7c6812ULL, 0x000fe200078efcffULL, 0x000000a24048723cULL, 0x040b620000041848ULL,
0x0000007a7900720bULL, 0x000fe40003fdd000ULL, 0x0000005e00767306ULL, 0x0002e20000205400ULL,
0x0000008b8a00720bULL, 0x004fe40003f1d000ULL, 0x000000af007a7245ULL, 0x000fe4000020d400ULL,
0x000000897c89723eULL, 0x000fe200000010ffULL, 0x000000864038723cULL, 0x000b620000041838ULL,
0x000000017a7a1812ULL, 0x000fe200078efcffULL, 0x00000098007e7306ULL, 0x000fe20000209400ULL,
0x0000005e005e7245ULL, 0x002fc4000020d400ULL, 0x000000015f5f6812ULL, 0x000fe400078efcffULL,
0x000000717a7a723eULL, 0x000fe200000010ffULL, 0x00000088404c723cULL, 0x000b62000004184cULL,
0x0000000178780812ULL, 0x000fe200078efcffULL, 0x0000009800797306ULL, 0x000e620000205400ULL,
0x000000767500720bULL, 0x008fe40003f5d000ULL, 0x0000005f787b723eULL, 0x000fe400000010ffULL,
0x0000005c005f7245ULL, 0x000fc6000020d400ULL, 0x0000005c00737306ULL, 0x000fe40000209400ULL,
0x0000007a4050723cULL, 0x000b680000041850ULL, 0x000000015e5e2812ULL, 0x000fe400078efcffULL,
0x0000005c00747306ULL, 0x0004e20000205400ULL, 0x000000797e00720bULL, 0x002fe40003fdd000ULL,
0x000000726900720cULL, 0x000fca0003f46070ULL, 0x000000b0008e7306ULL, 0x000fe20000209400ULL,
0x00000001725c7810ULL, 0x004fc80007ffe0ffULL, 0x0000005c6900720cULL, 0x000fe40005746470ULL,
0x00000001b1b16812ULL, 0x000fe200078efcffULL, 0x000000b0007d7306ULL, 0x0002a20000205400ULL,
0x000000747300720bULL, 0x008fe40003f3d000ULL, 0x0000000e3500720cULL, 0x000fe40003fc3070ULL,
0x000000b15eb1723eULL, 0x000fe400000010ffULL, 0x000000b000b07245ULL, 0x002fce000020d400ULL,
0x000000015f5f1812ULL, 0x000fe400078efcffULL, 0x0000007d8e00720bULL, 0x004fe40003f1d000ULL,
0x000000726800720cULL, 0x000fc80003f26070ULL, 0x0000005c6800720cULL, 0x000fce0004f26470ULL,
0x00000001b0b00812ULL, 0x000fe400078efcffULL, 0x0000000e3500720cULL, 0x000fe40003f03070ULL,
0x000000b05fb0723eULL, 0x000fce00000010ffULL, 0x000000b04054723cULL, 0x000b620000041854ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x0000003c13137221ULL, 0x000fe20000010000ULL, 0x0000003d14147221ULL, 0x000fe20000010000ULL,
0x0000003817177221ULL, 0x020fe20000010000ULL, 0x0000003918187221ULL, 0x000fe20000010000ULL,
0x000000581b1b7221ULL, 0x000fe20000010000ULL, 0x000000591c1c7221ULL, 0x000fe20000010000ULL,
0x000000441f1f7221ULL, 0x000fe20000010000ULL, 0x0000004520207221ULL, 0x000fe20000010000ULL,
0x0000004823237221ULL, 0x000fe20000010000ULL, 0x0000004924247221ULL, 0x000fe20000010000ULL,
0x0000004c27277221ULL, 0x000fe20000010000ULL, 0x0000004d28287221ULL, 0x000fe20000010000ULL,
0x000000502b2b7221ULL, 0x000fe20000010000ULL, 0x000000512c2c7221ULL, 0x000fe20000010000ULL,
0x000000542f2f7221ULL, 0x000fe20000010000ULL, 0x0000005530307221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000001947ULL, 0x000fea0000000000ULL, 0x0000003e15157221ULL, 0x000fe20000010000ULL,
0x0000003f16167221ULL, 0x000fe20000010000ULL, 0x0000003a19197221ULL, 0x020fe20000010000ULL,
0x0000003b1a1a7221ULL, 0x000fe20000010000ULL, 0x0000005a1d1d7221ULL, 0x000fe20000010000ULL,
0x0000005b1e1e7221ULL, 0x000fe20000010000ULL, 0x0000004621217221ULL, 0x000fe20000010000ULL,
0x0000004722227221ULL, 0x000fe20000010000ULL, 0x0000004a25257221ULL, 0x000fe20000010000ULL,
0x0000004b26267221ULL, 0x000fe20000010000ULL, 0x0000004e29297221ULL, 0x000fe20000010000ULL,
0x0000004f2a2a7221ULL, 0x000fe20000010000ULL, 0x000000522d2d7221ULL, 0x000fe20000010000ULL,
0x000000532e2e7221ULL, 0x000fe20000010000ULL, 0x0000005631317221ULL, 0x000fe20000010000ULL,
0x0000005760607221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8800ff387f8cULL, 0x020e62000c80043fULL,
0x00000002ff3b7819ULL, 0x000fe2000001165cULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x0000000e3500720cULL, 0x000fc40003fc3070ULL, 0x0000003b5c3b7207ULL, 0x040fe40002800000ULL,
0x000000035c5c7812ULL, 0x000fe400078ec0ffULL, 0x000000033b3b7810ULL, 0x000fe40007ffe0ffULL,
0x0000000e3500720cULL, 0x000fe40003f03070ULL, 0x00000040ff5e7803ULL, 0x000fe40000000000ULL,
0x000000ff5c5c7207ULL, 0x000fc40006800000ULL, 0x000000033b417812ULL, 0x040fe400078ec0ffULL,
0x0000000e3b407211ULL, 0x000fe200078ff0ffULL, 0x000000ffff3f7224ULL, 0x002fc400078e0039ULL,
0x0000000000387805ULL, 0x000fca0000015200ULL, 0x010b8400ff3a7984ULL, 0x000e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x800000003aff7812ULL, 0x002fe200078c485dULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007fde1ffULL,
0x000000013b3b7824ULL, 0x000fe200030e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078d10ffULL, 0x000000ffff3b7224ULL, 0x000fca00030e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8400ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe400078c485dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fc40000015200ULL, 0x010b8c00ff3a7984ULL, 0x000e620000000800ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe60000000000ULL,
0x800000003aff7812ULL, 0x002fe200078c483fULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000103c00780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383d7210ULL, 0x000fca0007fde1ffULL, 0x000000013b3b7824ULL, 0x000fe200030e0e39ULL,
0x003d09003d00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff3a7819ULL, 0x000fc8000001143bULL, 0x0000003d3a3a7211ULL, 0x000fca00078d10ffULL,
0x000000ffff3b7224ULL, 0x000fca00030e063bULL, 0x000000023a3a7819ULL, 0x000fc8000000123bULL,
0x0000003a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe400078c483fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000140387810ULL, 0x000fe20007ffe0ffULL,
0x0000097000017945ULL, 0x000fe60003800000ULL, 0x000000373800720cULL, 0x000fda0003fc6070ULL,
0x000005100000e947ULL, 0x000fea0003800000ULL, 0x0000000162437824ULL, 0x000fe400078e0205ULL,
0x00000100ff447424ULL, 0x000fe400078e00ffULL, 0x0000004034427824ULL, 0x000fe200078e0243ULL,
0x010a0000433c7984ULL, 0x000e620000004800ULL, 0x00000010323a7824ULL, 0x000fe400078e00ffULL,
0x00000010433d7824ULL, 0x000fc600078e00ffULL, 0x000000f03a457812ULL, 0x000fe200078ec0ffULL,
0x010ac0003c397984ULL, 0x002e640000004800ULL, 0x000000390c397224ULL, 0x002fc800078e0242ULL,
0x00005e0039387625ULL, 0x000fca00078e0044ULL, 0x00000045383a7210ULL, 0x000fe20007fde0ffULL,
0x0000000440387824ULL, 0x000fc800078e0241ULL, 0x0000004038387824ULL, 0x000fe400078e00ffULL,
0x000000ffff3b7224ULL, 0x000fc600030e0639ULL, 0x0000003861397217ULL, 0x000fca0007800000ULL,
0x0000000139397824ULL, 0x000fe400078e0a38ULL, 0x0000000143387824ULL, 0x000fc600078e0232ULL,
0x0000003962397217ULL, 0x000fe40007800000ULL, 0xfffffff03d387812ULL, 0x000fc600078ee238ULL,
0x00000001393e7824ULL, 0x000fe200078e0a62ULL, 0x0000c00038477811ULL, 0x000fe400078e20ffULL,
0x0000000242387810ULL, 0x000fe40007ffe0ffULL, 0x0000003e0500720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a477faeULL, 0x0003e8000f101c46ULL,
0x010a0800433f7984ULL, 0x000ea80000004800ULL, 0x010ac0003f3f7984ULL, 0x004ea40000004800ULL,
0x0000003f0c387224ULL, 0x004fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fca00078e0044ULL,
0x00000045383c7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3d7224ULL, 0x000fe200030e0639ULL,
0x0000000205397810ULL, 0x000fc80007ffe0ffULL, 0x0000003e3900720cULL, 0x000fe20003fc6070ULL,
0x0000000162497824ULL, 0x000fc800078e0239ULL, 0x0000000149387824ULL, 0x040fe400078e0232ULL,
0x0000001049497824ULL, 0x000fca00078e00ffULL, 0xfffffff049387812ULL, 0x000fc800078ee238ULL,
0x0000c00038477811ULL, 0x002fe400078e20ffULL, 0x0000000442387810ULL, 0x040fe40007ffe0ffULL,
0x0000000642427810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c477faeULL, 0x0003e8000f101c46ULL, 0x010a1000433f7984ULL, 0x000ea80000004800ULL,
0x010ac0003f3f7984ULL, 0x004ea40000004800ULL, 0x0000003f0c387224ULL, 0x004fe200078e0238ULL,
0x00000006053f7810ULL, 0x000fc60007ffe0ffULL, 0x00005e0038387625ULL, 0x000fca00078e0044ULL,
0x00000045383a7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3b7224ULL, 0x000fe200030e0639ULL,
0x0000000405397810ULL, 0x000fc80007ffe0ffULL, 0x0000003e3900720cULL, 0x000fe20003fc6070ULL,
0x0000000162497824ULL, 0x000fc800078e0239ULL, 0x0000000149387824ULL, 0x040fe400078e0232ULL,
0x0000001049497824ULL, 0x000fca00078e00ffULL, 0xfffffff049387812ULL, 0x000fc800078ee238ULL,
0x0000c000383d7811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a3d7faeULL, 0x0003e8000f101c46ULL, 0x010a1800433c7984ULL, 0x000ea80000004800ULL,
0x010ac0003c397984ULL, 0x004ea40000004800ULL, 0x000000390c397224ULL, 0x004fc800078e0242ULL,
0x00005e0039387625ULL, 0x000fca00078e0044ULL, 0x0000004538387210ULL, 0x000fe20007fde0ffULL,
0x0000000162457824ULL, 0x000fc800078e023fULL, 0x0000000145427824ULL, 0x000fe400078e0232ULL,
0x000000ffff397224ULL, 0x000fe200030e0639ULL, 0x0000003e3f00720cULL, 0x000fe20003fc6070ULL,
0x0000001045457824ULL, 0x000fca00078e00ffULL, 0xfffffff045427812ULL, 0x000fc800078ee242ULL,
0x0000c000423b7811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e2000f101c46ULL, 0x0000043000007947ULL, 0x000fea0003800000ULL,
0x00000001623f7824ULL, 0x000fe400078e0205ULL, 0x00000100ff447424ULL, 0x000fe400078e00ffULL,
0x0000004034427824ULL, 0x000fe200078e023fULL, 0x010a00003f3c7984ULL, 0x000e620000004800ULL,
0x00000010323a7824ULL, 0x000fca00078e00ffULL, 0x000000f03a437812ULL, 0x000fe200078ec0ffULL,
0x010ac0003c397984ULL, 0x002e640000004800ULL, 0x000000390c397224ULL, 0x002fc800078e0242ULL,
0x00005e0039387625ULL, 0x000fca00078e0044ULL, 0x00000043383a7210ULL, 0x000fe20007fde0ffULL,
0x000000013f387824ULL, 0x000fc800078e0232ULL, 0x000000ffff3b7224ULL, 0x000fe400030e0639ULL,
0x000000103f397824ULL, 0x000fca00078e00ffULL, 0xfffffff039387812ULL, 0x000fc800078ee238ULL,
0x0000c00038457811ULL, 0x000fe400078e20ffULL, 0x0000000242387810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a457faeULL, 0x0003e8000b901c46ULL,
0x010a08003f3e7984ULL, 0x000ea80000004800ULL, 0x010ac0003e397984ULL, 0x004ea40000004800ULL,
0x000000390c397224ULL, 0x004fc800078e0238ULL, 0x00005e0039387625ULL, 0x000fca00078e0044ULL,
0x00000043383c7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3d7224ULL, 0x000fe200030e0639ULL,
0x000000023f397810ULL, 0x000fca0007ffe0ffULL, 0x0000000139387824ULL, 0x040fe400078e0232ULL,
0x0000001039397824ULL, 0x000fca00078e00ffULL, 0xfffffff039387812ULL, 0x000fc800078ee238ULL,
0x0000c00038457811ULL, 0x002fe400078e20ffULL, 0x0000000442387810ULL, 0x040fe40007ffe0ffULL,
0x0000000642427810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x010a10003f3e7984ULL, 0x000ea80000004800ULL,
0x010ac0003e397984ULL, 0x004ea40000004800ULL, 0x000000390c397224ULL, 0x004fc800078e0238ULL,
0x00005e0039387625ULL, 0x000fca00078e0044ULL, 0x00000043383a7210ULL, 0x000fca0007fde0ffULL,
0x000000ffff3b7224ULL, 0x000fe200030e0639ULL, 0x000000043f397810ULL, 0x000fca0007ffe0ffULL,
0x0000000139387824ULL, 0x040fe400078e0232ULL, 0x0000001039397824ULL, 0x000fca00078e00ffULL,
0xfffffff039387812ULL, 0x000fc800078ee238ULL, 0x0000c000383d7811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e8000b901c46ULL,
0x010a18003f3c7984ULL, 0x000ea80000004800ULL, 0x010ac0003c397984ULL, 0x004ea40000004800ULL,
0x000000390c397224ULL, 0x004fc800078e0242ULL, 0x00005e0039387625ULL, 0x000fca00078e0044ULL,
0x0000004338387210ULL, 0x000fe40007fde0ffULL, 0x000000063f437810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff397224ULL, 0x000fe400030e0639ULL, 0x00000001433e7824ULL, 0x040fe400078e0232ULL,
0x0000001043437824ULL, 0x000fca00078e00ffULL, 0xfffffff0433e7812ULL, 0x000fc800078ee23eULL,
0x0000c0003e3b7811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e4000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8800ff387f8cULL, 0x002e64000c80043fULL,
0x000000ffff3f7224ULL, 0x002fc400078e0039ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x010b8c00ff3a7984ULL, 0x000e620000000800ULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x800000003aff7812ULL, 0x002fe200078c483fULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007fde1ffULL,
0x000000013b3b7824ULL, 0x000fe200030e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078d10ffULL, 0x000000ffff3b7224ULL, 0x000fca00030e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe400078c483fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000017000017945ULL, 0x000fe20003800000ULL, 0x0000015000004947ULL, 0x000fea0003800000ULL,
0x000000403500720cULL, 0x000fe40003fc4070ULL, 0x00010a000b3b7811ULL, 0x000fe400078e10ffULL,
0x000000ff5c387207ULL, 0x000fc40003000000ULL, 0x000000ff5c5c7207ULL, 0x000fc60007000000ULL,
0x0000000141387824ULL, 0x000fc800078e0238ULL, 0x0000004038397824ULL, 0x040fe200078e00ffULL,
0x0000004038387211ULL, 0x000fc800078ff0ffULL, 0x000000c039397812ULL, 0x000fca00078ec0ffULL,
0x0000010038387824ULL, 0x000fe400078e0239ULL, 0x0000000163397824ULL, 0x000fc600078e025cULL,
0x00000020383a7810ULL, 0x000fca0007ffe0ffULL, 0x0000680039387a24ULL, 0x100fe400078e023aULL,
0x000000010b3a7824ULL, 0x040fe400078e023aULL, 0x00000004ff397424ULL, 0x000fe400078e00ffULL,
0x000000010b387824ULL, 0x000fe200078e0238ULL, 0x000000613a00720cULL, 0x000fc60003fc6070ULL,
0x0000660038387625ULL, 0x000fd400078e0039ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e4000f121846ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x010b7800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b7800ff387f8cULL, 0x000e62000c80043fULL, 0x0000013000017945ULL, 0x000fe20003800000ULL,
0x000000ffff717224ULL, 0x002fe200078e0039ULL, 0x0000010000003947ULL, 0x000fea0003800000ULL,
0x00000008ff06723eULL, 0x000fc800000010ffULL, 0x00005410063a7816ULL, 0x000fe20000000006ULL,
0x0000a7427f007947ULL, 0x000fea000b800000ULL, 0x00001f693a077589ULL, 0x0002a400000e0000ULL,
0x0000a7827f007947ULL, 0x000fea000b800000ULL, 0x00001f683a067589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000010693f7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff3e7224ULL, 0x000fe200078e003aULL, 0x0001cbf000387802ULL, 0x000fc40000000f00ULL,
0x0000acc000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000ffff3e7224ULL, 0x004fe200078e003aULL, 0x00000018693f7810ULL, 0x002fe40007ffe0ffULL,
0x0001cc4000387802ULL, 0x000fc40000000f00ULL, 0x0000ac7000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000006d3c783bULL, 0x006e620000004200ULL, 0x00001e3000017945ULL, 0x000fe60003800000ULL,
0x000000006c40783bULL, 0x000ea80000004200ULL, 0x000000006b44783bULL, 0x000f220000004200ULL,
0x0000003c00387306ULL, 0x002fe20000009400ULL, 0x00000018ff577819ULL, 0x004fce0000011440ULL,
0x0000003c00397306ULL, 0x000e700000005400ULL, 0x0000003c004a7306ULL, 0x000ea2000000d400ULL,
0x000000393800720bULL, 0x002fce0003fdd000ULL, 0x0000003d004b7306ULL, 0x000ff0000000d400ULL,
0x0000003d00387306ULL, 0x000fe20000009400ULL, 0x000000014a4a6812ULL, 0x004fce00078efcffULL,
0x0000003d00397306ULL, 0x000e700000005400ULL, 0x0000003e00487306ULL, 0x000fe2000000d400ULL,
0x000000393800720bULL, 0x002fce0003fdd000ULL, 0x0000003f00497306ULL, 0x000ff0000000d400ULL,
0x0000003e00387306ULL, 0x000fe20000009400ULL, 0x000000014b4b6812ULL, 0x000fce00078efcffULL,
0x0000003e00397306ULL, 0x000e700000005400ULL, 0x0000004000507306ULL, 0x000fe2000000d400ULL,
0x000000393800720bULL, 0x002fce0003fdd000ULL, 0x0000004100517306ULL, 0x000ff0000000d400ULL,
0x0000003f00387306ULL, 0x000fe20000009400ULL, 0x0000000148486812ULL, 0x000fce00078efcffULL,
0x0000003f00397306ULL, 0x000e700000005400ULL, 0x0000004200567306ULL, 0x000fe2000000d400ULL,
0x000000393800720bULL, 0x002fce0003fdd000ULL, 0x0000004300587306ULL, 0x000ff0000000d400ULL,
0x0000004000387306ULL, 0x000fe20000009400ULL, 0x0000000149496812ULL, 0x000fce00078efcffULL,
0x0000004000397306ULL, 0x000e700000005400ULL, 0x00000044007e7306ULL, 0x010fe2000000d400ULL,
0x000000393800720bULL, 0x002fce0003fdd000ULL, 0x00000045007d7306ULL, 0x000ff0000000d400ULL,
0x0000004100387306ULL, 0x000fe20000009400ULL, 0x0000000150506812ULL, 0x000fce00078efcffULL,
0x0000004100397306ULL, 0x000e700000005400ULL, 0x00000046007a7306ULL, 0x000fe2000000d400ULL,
0x000000393800720bULL, 0x002fce0003fdd000ULL, 0x0000004700787306ULL, 0x000ff0000000d400ULL,
0x0000004200387306ULL, 0x000fe20000009400ULL, 0x0000000151516812ULL, 0x000fce00078efcffULL,
0x0000004200397306ULL, 0x000e640000005400ULL, 0x000000393800720bULL, 0x002fcc0003fdd000ULL,
0x0000004300387306ULL, 0x000ff00000009400ULL, 0x0000004300397306ULL, 0x000e620000005400ULL,
0x0000000156566812ULL, 0x000fe400078efcffULL, 0x000000393800720bULL, 0x002fca0003fdd000ULL,
0x0000004400387306ULL, 0x000ff00000009400ULL, 0x0000004400397306ULL, 0x000e620000005400ULL,
0x0000000158586812ULL, 0x000fe400078efcffULL, 0x000000393800720bULL, 0x002fca0003fdd000ULL,
0x0000004500387306ULL, 0x000ff00000009400ULL, 0x0000004500397306ULL, 0x000e620000005400ULL,
0x000000017e7e6812ULL, 0x000fe400078efcffULL, 0x000000393800720bULL, 0x002fca0003fdd000ULL,
0x0000004600387306ULL, 0x000ff00000009400ULL, 0x0000004600397306ULL, 0x000e620000005400ULL,
0x000000017d7d6812ULL, 0x000fe400078efcffULL, 0x000000393800720bULL, 0x002fca0003fdd000ULL,
0x0000004700387306ULL, 0x000ff00000009400ULL, 0x0000004700397306ULL, 0x000e620000005400ULL,
0x000000017a7a6812ULL, 0x000fe400078efcffULL, 0x000000393800720bULL, 0x002fc40003fdd000ULL,
0x000000006a38783bULL, 0x008e760000004200ULL, 0x0000000178786812ULL, 0x000fe200078efcffULL,
0x00000038004c7306ULL, 0x002ff00000009400ULL, 0x00000038004d7306ULL, 0x000e700000005400ULL,
0x0000003800757306ULL, 0x000ea2000000d400ULL, 0x0000004d4c00720bULL, 0x002fce0003fdd000ULL,
0x0000003900767306ULL, 0x000ff0000000d400ULL, 0x00000039004c7306ULL, 0x000fe20000009400ULL,
0x0000000175756812ULL, 0x004fce00078efcffULL, 0x00000039004d7306ULL, 0x000e700000005400ULL,
0x0000003a00737306ULL, 0x000fe2000000d400ULL, 0x0000004d4c00720bULL, 0x002fce0003fdd000ULL,
0x0000003b00977306ULL, 0x000ff0000000d400ULL, 0x0000003a004c7306ULL, 0x000fe20000009400ULL,
0x0000000176766812ULL, 0x000fce00078efcffULL, 0x0000003a004d7306ULL, 0x000e640000005400ULL,
0x0000004d4c00720bULL, 0x002fe40003fdd000ULL, 0x00000018ff4c7819ULL, 0x000fc8000001143cULL,
0x0000004c004d7306ULL, 0x000fe20000209400ULL, 0x0000004c004f7245ULL, 0x000fcc000020d400ULL,
0x0000000173736812ULL, 0x000fe200078efcffULL, 0x0000004c004e7306ULL, 0x000e640000205400ULL,
0x0000004e4d00720bULL, 0x002fe40003fdd000ULL, 0x00000018ff4d7819ULL, 0x000fc8000001143dULL,
0x0000004d00527306ULL, 0x000fe20000209400ULL, 0x0000004d004e7245ULL, 0x000fcc000020d400ULL,
0x000000014f4f6812ULL, 0x000fe200078efcffULL, 0x0000004d00537306ULL, 0x000e640000205400ULL,
0x000000535200720bULL, 0x002fe40003fdd000ULL, 0x00000018ff527819ULL, 0x000fc8000001143eULL,
0x0000005200537306ULL, 0x000fe20000209400ULL, 0x00000052004c7245ULL, 0x000fcc000020d400ULL,
0x000000014e4e6812ULL, 0x000fe200078efcffULL, 0x0000005200547306ULL, 0x000e700000205400ULL,
0x0000005700527306ULL, 0x000fe20000209400ULL, 0x000000545300720bULL, 0x002fc40003fdd000ULL,
0x00000018ff537819ULL, 0x000fca000001143fULL, 0x0000005300547306ULL, 0x000fe20000209400ULL,
0x00000053004d7245ULL, 0x000fca000020d400ULL, 0x000000014c4c6812ULL, 0x000fe400078efcffULL,
0x0000005300557306ULL, 0x000e640000205400ULL, 0x000000555400720bULL, 0x002fcc0003fdd000ULL,
0x0000005700557306ULL, 0x000e620000205400ULL, 0x0000005700547245ULL, 0x000fcc000020d400ULL,
0x000000014d4d6812ULL, 0x000fe400078efcffULL, 0x000000555200720bULL, 0x002fe40003fdd000ULL,
0x00000018ff527819ULL, 0x000fc80000011441ULL, 0x0000005200537306ULL, 0x000fe20000209400ULL,
0x0000005200557245ULL, 0x000fcc000020d400ULL, 0x0000000154546812ULL, 0x000fe200078efcffULL,
0x00000052005a7306ULL, 0x000e640000205400ULL, 0x0000005a5300720bULL, 0x002fe40003fdd000ULL,
0x00000018ff537819ULL, 0x000fc80000011442ULL, 0x0000005300577306ULL, 0x000fe20000209400ULL,
0x0000005300597245ULL, 0x000fcc000020d400ULL, 0x0000000155556812ULL, 0x000fe200078efcffULL,
0x00000053005a7306ULL, 0x000e640000205400ULL, 0x0000005a5700720bULL, 0x002fe40003fdd000ULL,
0x00000018ff577819ULL, 0x000fc80000011443ULL, 0x0000005700527306ULL, 0x000fe20000209400ULL,
0x00000057005a7245ULL, 0x000fcc000020d400ULL, 0x0000000159596812ULL, 0x000fe200078efcffULL,
0x00000057005b7306ULL, 0x000e640000205400ULL, 0x0000005b5200720bULL, 0x002fe40003fdd000ULL,
0x00000018ff527819ULL, 0x000fc80000011444ULL, 0x0000005200537306ULL, 0x000fe20000209400ULL,
0x0000005200807245ULL, 0x000fcc000020d400ULL, 0x000000015a5a6812ULL, 0x000fe200078efcffULL,
0x00000052005c7306ULL, 0x000e640000205400ULL, 0x0000005c5300720bULL, 0x002fe40003fdd000ULL,
0x00000018ff537819ULL, 0x000fc80000011445ULL, 0x0000005300577306ULL, 0x000fe20000209400ULL,
0x00000053007f7245ULL, 0x000fcc000020d400ULL, 0x0000000180806812ULL, 0x000fe200078efcffULL,
0x00000053005c7306ULL, 0x000e640000205400ULL, 0x0000005c5700720bULL, 0x002fe40003fdd000ULL,
0x00000018ff577819ULL, 0x000fc80000011446ULL, 0x0000005700527306ULL, 0x000fe20000209400ULL,
0x00000057007c7245ULL, 0x000fcc000020d400ULL, 0x000000017f7f6812ULL, 0x000fe200078efcffULL,
0x00000057005b7306ULL, 0x000e640000205400ULL, 0x0000005b5200720bULL, 0x002fe40003fdd000ULL,
0x00000018ff527819ULL, 0x000fc80000011447ULL, 0x0000005200537306ULL, 0x000fe20000209400ULL,
0x00000052007b7245ULL, 0x000fcc000020d400ULL, 0x000000017c7c6812ULL, 0x000fe200078efcffULL,
0x00000052005c7306ULL, 0x000e640000205400ULL, 0x0000005c5300720bULL, 0x002fe40003fdd000ULL,
0x00000018ff537819ULL, 0x000fc80000011438ULL, 0x0000005300577306ULL, 0x000fe20000209400ULL,
0x0000005300797245ULL, 0x000fcc000020d400ULL, 0x000000017b7b6812ULL, 0x000fe200078efcffULL,
0x00000053005c7306ULL, 0x000e640000205400ULL, 0x0000005c5700720bULL, 0x002fe40003fdd000ULL,
0x00000018ff577819ULL, 0x000fc80000011439ULL, 0x0000005700527306ULL, 0x000fe20000209400ULL,
0x0000005700777245ULL, 0x000fcc000020d400ULL, 0x0000000179796812ULL, 0x000fe200078efcffULL,
0x00000057005b7306ULL, 0x000e640000205400ULL, 0x0000005b5200720bULL, 0x002fe40003fdd000ULL,
0x00000018ff5b7819ULL, 0x000fc8000001143aULL, 0x0000005b00527306ULL, 0x000fe20000209400ULL,
0x0000005b00747245ULL, 0x000fcc000020d400ULL, 0x0000000177776812ULL, 0x000fe200078efcffULL,
0x0000005b00537306ULL, 0x000e640000205400ULL, 0x000000535200720bULL, 0x002fe20003fdd000ULL,
0x000001003c527824ULL, 0x040fe400078e00ffULL, 0x000100003c3c7824ULL, 0x000fc600078e00ffULL,
0x00000018ff527819ULL, 0x000fc80000011452ULL, 0x0000005200577306ULL, 0x000fe20000209400ULL,
0x0000005200537245ULL, 0x000fe4000020d400ULL, 0x0000000174746812ULL, 0x000fca00078efcffULL,
0x00000052005c7306ULL, 0x0002a40000205400ULL, 0x000001003d527824ULL, 0x042fe400078e00ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x0000005c5700720bULL, 0x004fe40003fdd000ULL,
0x00000018ff577819ULL, 0x000fc8000001143cULL, 0x00000057005b7306ULL, 0x000fe20000209400ULL,
0x00000057003c7245ULL, 0x000fcc000020d400ULL, 0x0000000153536812ULL, 0x000fe200078efcffULL,
0x00000057005c7306ULL, 0x0002a40000205400ULL, 0x00000018ff577819ULL, 0x002fc8000001143dULL,
0x00000057003d7245ULL, 0x000fe4000020d400ULL, 0x0000005c5b00720bULL, 0x004fe40003fdd000ULL,
0x00000018ff5b7819ULL, 0x000fc80000011452ULL, 0x0000005b005c7306ULL, 0x000fe20000209400ULL,
0x0000005b00527245ULL, 0x000fcc000020d400ULL, 0x000000013c3c6812ULL, 0x000fe200078efcffULL,
0x0000005b005d7306ULL, 0x0002a40000205400ULL, 0x000001003e5b7824ULL, 0x042fe400078e00ffULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x0000005d5c00720bULL, 0x004fc60003fdd000ULL,
0x00000057005c7306ULL, 0x000fe20000209400ULL, 0x00000018ff3e7819ULL, 0x000fce000001143eULL,
0x00000057005d7306ULL, 0x0002a40000205400ULL, 0x0000000152526812ULL, 0x000fe400078efcffULL,
0x0000003e00577245ULL, 0x002fe4000020d400ULL, 0x0000005d5c00720bULL, 0x004fe40003fdd000ULL,
0x00000018ff5c7819ULL, 0x000fc8000001145bULL, 0x0000005c005d7306ULL, 0x000fe20000209400ULL,
0x0000005c005b7245ULL, 0x000fcc000020d400ULL, 0x000000013d3d6812ULL, 0x000fe200078efcffULL,
0x0000005c00827306ULL, 0x0002a40000205400ULL, 0x000001003f5c7824ULL, 0x042fe400078e00ffULL,
0x000100003f3f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe4000001145cULL,
0x000000825d00720bULL, 0x004fe40003fdd000ULL, 0x0000003e005d7306ULL, 0x000fe20000209400ULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x0000005c00847245ULL, 0x000fca000020d400ULL,
0x0000003e00827306ULL, 0x0002a60000205400ULL, 0x000000015b5b6812ULL, 0x000fc800078efcffULL,
0x000000485b48723eULL, 0x000fe400000010ffULL, 0x0000003f003e7245ULL, 0x002fe4000020d400ULL,
0x000000825d00720bULL, 0x004fe40003fdd000ULL, 0x0000005c005d7306ULL, 0x000ff00000209400ULL,
0x0000005c00827306ULL, 0x0002a60000205400ULL, 0x0000000157576812ULL, 0x000fc800078efcffULL,
0x000000574c4c723eULL, 0x000fe200000010ffULL, 0x00000100405c7824ULL, 0x042fe400078e00ffULL,
0x0001000040407824ULL, 0x000fc600078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe4000001145cULL,
0x000000825d00720bULL, 0x004fe40003fdd000ULL, 0x0000003f005d7306ULL, 0x000fe20000209400ULL,
0x00000018ff407819ULL, 0x000fe40000011440ULL, 0x0000005c00837245ULL, 0x000fe4000020d400ULL,
0x0000004000817245ULL, 0x000fc6000020d400ULL, 0x0000003f00827306ULL, 0x000e660000205400ULL,
0x0000000184846812ULL, 0x000fc800078efcffULL, 0x000000498449723eULL, 0x000fe200000010ffULL,
0x00000040003f7306ULL, 0x000fe20000209400ULL, 0x000000825d00720bULL, 0x002fce0003fdd000ULL,
0x0000005c005d7306ULL, 0x000ff00000209400ULL, 0x0000005c00827306ULL, 0x000e620000205400ULL,
0x000000013e3e6812ULL, 0x000fc800078efcffULL, 0x0000003e4d4d723eULL, 0x000fe400000010ffULL,
0x000000825d00720bULL, 0x002fe40003fdd000ULL, 0x0000004000827306ULL, 0x000e760000205400ULL,
0x0000000183836812ULL, 0x000fc800078efcffULL, 0x000000508350723eULL, 0x000fe400000010ffULL,
0x000000823f00720bULL, 0x002fe20003fdd000ULL, 0x00000100413f7824ULL, 0x040fe400078e00ffULL,
0x0001000041417824ULL, 0x000fc600078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x0000003f005c7306ULL, 0x000fe20000209400ULL,
0x0000003f00867245ULL, 0x000fe4000020d400ULL, 0x0000000181816812ULL, 0x000fe400078efcffULL,
0x0000004100827245ULL, 0x000fe4000020d400ULL, 0x000000815454723eULL, 0x000fe200000010ffULL,
0x0000003f005d7306ULL, 0x0002b00000205400ULL, 0x0000004100407306ULL, 0x000fe20000209400ULL,
0x00000100423f7824ULL, 0x002fc400078e00ffULL, 0x0001000042427824ULL, 0x000fc600078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x0000005d5c00720bULL, 0x004fe20003fdd000ULL,
0x0000003b00817306ULL, 0x000fe20000005400ULL, 0x00000018ff427819ULL, 0x000fe40000011442ULL,
0x0000003f00857245ULL, 0x000fe4000020d400ULL, 0x0000004200887245ULL, 0x000fc6000020d400ULL,
0x00000041005d7306ULL, 0x000e680000205400ULL, 0x0000000186866812ULL, 0x000fc800078efcffULL,
0x0000004200417306ULL, 0x000fe20000205400ULL, 0x000000518651723eULL, 0x000fe400000010ffULL,
0x0000005d4000720bULL, 0x002fca0003fdd000ULL, 0x0000003f00407306ULL, 0x000ff00000209400ULL,
0x0000003f005d7306ULL, 0x0002a20000205400ULL, 0x0000000182826812ULL, 0x000fc800078efcffULL,
0x000000825555723eULL, 0x000fe200000010ffULL, 0x00000100433f7824ULL, 0x042fe400078e00ffULL,
0x0001000043437824ULL, 0x000fc600078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x0000005d4000720bULL, 0x004fe40003fdd000ULL, 0x0000004200407306ULL, 0x000e620000209400ULL,
0x00000018ff437819ULL, 0x000fe40000011443ULL, 0x0000003f00877245ULL, 0x000fe4000020d400ULL,
0x0000004300897245ULL, 0x000fcc000020d400ULL, 0x0000000185856812ULL, 0x000fe400078efcffULL,
0x000000414000720bULL, 0x002fe40003fdd000ULL, 0x0000003f00407306ULL, 0x000ff00000209400ULL,
0x0000003f00417306ULL, 0x0002a60000205400ULL, 0x0000000188886812ULL, 0x000fc800078efcffULL,
0x000000885988723eULL, 0x000fe200000010ffULL, 0x00000100443f7824ULL, 0x042fe400078e00ffULL,
0x0001000044447824ULL, 0x000fc600078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x000000414000720bULL, 0x004fe40003fdd000ULL, 0x0000004300407306ULL, 0x000fe20000209400ULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x0000003f008d7245ULL, 0x000fe4000020d400ULL,
0x00000044008b7245ULL, 0x000fc6000020d400ULL, 0x0000004300417306ULL, 0x000e660000205400ULL,
0x0000000187876812ULL, 0x000fe400078efcffULL, 0x000000414000720bULL, 0x002fc60003fdd000ULL,
0x0000003f00407306ULL, 0x000ff00000209400ULL, 0x0000003f00417306ULL, 0x0002a40000205400ULL,
0x0000000189896812ULL, 0x000fc800078efcffULL, 0x000000895a89723eULL, 0x000fe200000010ffULL,
0x00000100453f7824ULL, 0x042fe400078e00ffULL, 0x0001000045457824ULL, 0x000fc600078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x000000414000720bULL, 0x004fe40003fdd000ULL,
0x0000004400407306ULL, 0x000fe20000209400ULL, 0x00000018ff457819ULL, 0x000fe40000011445ULL,
0x0000003f008c7245ULL, 0x000fe4000020d400ULL, 0x00000045008a7245ULL, 0x000fc6000020d400ULL,
0x0000004400417306ULL, 0x0002a60000205400ULL, 0x000000018d8d6812ULL, 0x000fe400078efcffULL,
0x0000003c4f44723eULL, 0x002fe400000010ffULL, 0x0000b8006e3c7811ULL, 0x000fe400078e20ffULL,
0x000000414000720bULL, 0x004fe40003fdd000ULL, 0x0000003f00407306ULL, 0x000ff00000209400ULL,
0x0000003f00417306ULL, 0x0002a60000205400ULL, 0x000000018b8b6812ULL, 0x000fe200078efcffULL,
0x00000100463f7824ULL, 0x002fc400078e00ffULL, 0x0001000046467824ULL, 0x000fc600078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x000000414000720bULL, 0x004fe40003fdd000ULL,
0x0000004500407306ULL, 0x000fe20000209400ULL, 0x00000018ff467819ULL, 0x000fe40000011446ULL,
0x0000003f00917245ULL, 0x000fe4000020d400ULL, 0x00000046008f7245ULL, 0x000fc6000020d400ULL,
0x0000004500417306ULL, 0x0002a60000205400ULL, 0x000000018c8c6812ULL, 0x000fe400078efcffULL,
0x0000003d4e45723eULL, 0x002fe400000010ffULL, 0x000000414000720bULL, 0x004fe40003fdd000ULL,
0x0000003f00407306ULL, 0x000ff00000209400ULL, 0x0000003f00417306ULL, 0x0002a60000205400ULL,
0x000000018a8a6812ULL, 0x000fc800078efcffULL, 0x0000008a7f7f723eULL, 0x000fe200000010ffULL,
0x00000100473f7824ULL, 0x042fe400078e00ffULL, 0x0001000047477824ULL, 0x000fc600078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x000000414000720bULL, 0x004fe40003fdd000ULL,
0x0000004600407306ULL, 0x000fe20000209400ULL, 0x00000018ff477819ULL, 0x000fe40000011447ULL,
0x0000003f00937245ULL, 0x000fe4000020d400ULL, 0x00000047008e7245ULL, 0x000fc6000020d400ULL,
0x0000004600417306ULL, 0x000e660000205400ULL, 0x0000000191916812ULL, 0x000fe400078efcffULL,
0x000000414000720bULL, 0x002fc60003fdd000ULL, 0x0000003f00407306ULL, 0x000ff00000209400ULL,
0x0000003f00417306ULL, 0x0002a40000205400ULL, 0x000000018f8f6812ULL, 0x000fe200078efcffULL,
0x00000100383f7824ULL, 0x002fc400078e00ffULL, 0x0001000038387824ULL, 0x000fc600078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x000000414000720bULL, 0x004fe40003fdd000ULL,
0x0000004700407306ULL, 0x000fe20000209400ULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x0000003f00927245ULL, 0x000fe4000020d400ULL, 0x0000003800907245ULL, 0x000fc6000020d400ULL,
0x0000004700417306ULL, 0x000e660000205400ULL, 0x0000000193936812ULL, 0x000fe400078efcffULL,
0x000000414000720bULL, 0x002fc60003fdd000ULL, 0x0000003f00407306ULL, 0x000ff00000209400ULL,
0x0000003f00417306ULL, 0x0002a40000205400ULL, 0x000000018e8e6812ULL, 0x000fc800078efcffULL,
0x0000008e7b7b723eULL, 0x000fe200000010ffULL, 0x00000100393f7824ULL, 0x042fe400078e00ffULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x000000414000720bULL, 0x004fe40003fdd000ULL, 0x0000003800407306ULL, 0x000fe20000209400ULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000003f00957245ULL, 0x000fe4000020d400ULL,
0x0000003900947245ULL, 0x000fc6000020d400ULL, 0x0000003800417306ULL, 0x000e660000205400ULL,
0x0000000192926812ULL, 0x000fc800078efcffULL, 0x000000759292723eULL, 0x000fe200000010ffULL,
0x0000003900387306ULL, 0x000fe20000209400ULL, 0x000000414000720bULL, 0x002fce0003fdd000ULL,
0x0000003f00407306ULL, 0x000ff00000209400ULL, 0x0000003f00417306ULL, 0x000e620000205400ULL,
0x0000000190906812ULL, 0x000fe400078efcffULL, 0x000000414000720bULL, 0x002fca0003fdd000ULL,
0x0000003900417306ULL, 0x000e700000205400ULL, 0x0000000195956812ULL, 0x000fe400078efcffULL,
0x000000413800720bULL, 0x002fe20003fdd000ULL, 0x000001003a387824ULL, 0x000fe200078e00ffULL,
0x0000004b5241723eULL, 0x000fe200000010ffULL, 0x000100003a3a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x00000038003f7306ULL, 0x000fe20000209400ULL, 0x0000003800967245ULL, 0x000fe4000020d400ULL,
0x0000000194946812ULL, 0x000fe400078efcffULL, 0x0000003a00997245ULL, 0x000fe4000020d400ULL,
0x000000947777723eULL, 0x000fe200000010ffULL, 0x0000003800407306ULL, 0x0002b00000205400ULL,
0x0000003a00397306ULL, 0x000fe20000209400ULL, 0x000001003b387824ULL, 0x002fe200078e00ffULL,
0x000000403f00720bULL, 0x004fcc0003fdd000ULL, 0x0000003a00407306ULL, 0x000e700000205400ULL,
0x0000003b003a7306ULL, 0x000fe20000009400ULL, 0x0000000196966812ULL, 0x000fc800078efcffULL,
0x000000739696723eULL, 0x000fe400000010ffULL, 0x000000403900720bULL, 0x002fe40003fdd000ULL,
0x00000018ff397819ULL, 0x000fe40000011438ULL, 0x0000004a5340723eULL, 0x000fe400000010ffULL,
0x0000003900387306ULL, 0x000fe20000209400ULL, 0x0000003900987245ULL, 0x000fcc000020d400ULL,
0x0000000199996812ULL, 0x000fe200078efcffULL, 0x00000039003f7306ULL, 0x0002a60000205400ULL,
0x000000997474723eULL, 0x000fe400000010ffULL, 0x000000588739723eULL, 0x002fe400000010ffULL,
0x0000003f3800720bULL, 0x004fe40003fdd000ULL, 0x0000b8006f387811ULL, 0x000fe200078e20ffULL,
0x000000003c3c783bULL, 0x000e740000000200ULL, 0x0000000198986812ULL, 0x000fc400078efcffULL,
0x000000ff5e00720cULL, 0x000fe40003fc5270ULL, 0x00000000385c783bULL, 0x0004e40000000200ULL,
0x000000568538723eULL, 0x004fe200000010ffULL, 0x000000073c3cb231ULL, 0x082fe400003400ffULL,
0x000000073e3eb231ULL, 0x000fe400003400ffULL, 0x000000063d3db231ULL, 0x080fe400003400ffULL,
0x000000063f3fb231ULL, 0x000fc400003400ffULL, 0x000000075c5cb231ULL, 0x088fe400003400ffULL,
0x000000075e5eb231ULL, 0x000fe400003400ffULL, 0x000000065d5db231ULL, 0x080fe400003400ffULL,
0x000000065f5fb231ULL, 0x000fe200003400ffULL, 0x000000813a00720bULL, 0x000fcc0003f7d000ULL,
0x000000385c58723cULL, 0x040bee00000418ffULL, 0x000100003b387824ULL, 0x020fe200078e00ffULL,
0x0000007d8c39723eULL, 0x000fe200000010ffULL, 0x000000405c40723cULL, 0x000f6200000418ffULL,
0x00000018ff3b7819ULL, 0x000fc4000001143bULL, 0x00000018ff827819ULL, 0x000fe40000011438ULL,
0x0000000197973812ULL, 0x000fe200078efcffULL, 0x0000003b003a7306ULL, 0x000fe20000209400ULL,
0x0000007e8d38723eULL, 0x000fe200000010ffULL, 0x000000485c48723cULL, 0x040fe200000418ffULL,
0x0000008200757245ULL, 0x000fe4000020d400ULL, 0x0000008b807e723eULL, 0x000fe400000010ffULL,
0x000000979897723eULL, 0x000fe200000010ffULL, 0x00000082007d7306ULL, 0x000fe40000209400ULL,
0x000000445c44723cULL, 0x040f6c00000418ffULL, 0x0000008200847306ULL, 0x000e640000205400ULL,
0x0000004c5c4c723cULL, 0x040f7000000418ffULL, 0x000000505c50723cULL, 0x000f6200000418ffULL,
0x000000847d00720bULL, 0x002fc40003f7d000ULL, 0x0000003b007d7306ULL, 0x000e6a0000205400ULL,
0x000000545c54723cULL, 0x040f7000000418ffULL, 0x000000885c5c723cULL, 0x000f6200000418ffULL,
0x0000000175753812ULL, 0x000fc400078efcffULL, 0x0000007d3a00720bULL, 0x002fca0003f7d000ULL,
0x000000383c40723cULL, 0x060b6e0000041840ULL, 0x0000007a9138723eULL, 0x020fe200000010ffULL,
0x0000007e3c44723cULL, 0x000f620000041844ULL, 0x000000789339723eULL, 0x000fe400000010ffULL,
0x000000769593723eULL, 0x000fc400000010ffULL, 0x0000008f7c7a723eULL, 0x000fe400000010ffULL,
0x000000907976723eULL, 0x000fe200000010ffULL, 0x000000383c48723cULL, 0x040b6e0000041848ULL,
0x0000003b00387245ULL, 0x020fe2000020d400ULL, 0x0000007a3c4c723cULL, 0x000b66000004184cULL,
0x0000000138383812ULL, 0x000fc800078efcffULL, 0x000000753875723eULL, 0x000fe200000010ffULL,
0x000000923c50723cULL, 0x040b700000041850ULL, 0x000000763c54723cULL, 0x040b700000041854ULL,
0x000000963c58723cULL, 0x040b700000041858ULL, 0x000000743c5c723cULL, 0x000b62000004185cULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x0000004013137221ULL, 0x000fe20000010000ULL, 0x0000004114147221ULL, 0x000fe20000010000ULL,
0x0000004417177221ULL, 0x000fe20000010000ULL, 0x0000004518187221ULL, 0x000fe20000010000ULL,
0x000000481b1b7221ULL, 0x000fe20000010000ULL, 0x000000491c1c7221ULL, 0x000fe20000010000ULL,
0x0000004c1f1f7221ULL, 0x020fe20000010000ULL, 0x0000004d20207221ULL, 0x000fe20000010000ULL,
0x0000005023237221ULL, 0x000fe20000010000ULL, 0x0000005124247221ULL, 0x000fe20000010000ULL,
0x0000005427277221ULL, 0x000fe20000010000ULL, 0x0000005528287221ULL, 0x000fe20000010000ULL,
0x000000582b2b7221ULL, 0x000fe20000010000ULL, 0x000000592c2c7221ULL, 0x000fe20000010000ULL,
0x0000005c2f2f7221ULL, 0x000fe20000010000ULL, 0x0000005d30307221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000001947ULL, 0x000fea0000000000ULL, 0x0000004215157221ULL, 0x000fe20000010000ULL,
0x0000004316167221ULL, 0x000fe20000010000ULL, 0x0000004619197221ULL, 0x000fe20000010000ULL,
0x000000471a1a7221ULL, 0x000fe20000010000ULL, 0x0000004a1d1d7221ULL, 0x000fe20000010000ULL,
0x0000004b1e1e7221ULL, 0x000fe20000010000ULL, 0x0000004e21217221ULL, 0x020fe20000010000ULL,
0x0000004f22227221ULL, 0x000fe20000010000ULL, 0x0000005225257221ULL, 0x000fe20000010000ULL,
0x0000005326267221ULL, 0x000fe20000010000ULL, 0x0000005629297221ULL, 0x000fe20000010000ULL,
0x000000572a2a7221ULL, 0x000fe20000010000ULL, 0x0000005a2d2d7221ULL, 0x000fe20000010000ULL,
0x0000005b2e2e7221ULL, 0x000fe20000010000ULL, 0x0000005e31317221ULL, 0x000fe20000010000ULL,
0x0000005f60607221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000172727810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8800ff387f8cULL, 0x000e62000c80043fULL, 0x000000707200720cULL, 0x000fe20003f06070ULL,
0x000000ffff3e7224ULL, 0x022fd800078e0039ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffff8d2000007947ULL, 0x000fea000383ffffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b7000ffff7f8cULL, 0x000fe4000c80043fULL, 0x000000010e0e7810ULL, 0x000fc80007ffe0ffULL,
0x000000370e00720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xfffe2e2000007947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff3700720cULL, 0x000fda0003f05270ULL, 0x0000039000008947ULL, 0x000fea0003800000ULL,
0x0180000012007810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0001edd000047802ULL, 0x004fc40000000f00ULL,
0x0000892000007944ULL, 0x00afea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000001200037308ULL, 0x002e640000001000ULL, 0xbf80000003007423ULL, 0x002fc80000000012ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003007223ULL, 0x000fc40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006f00ff037624ULL, 0x000fe400078e00ffULL,
0x00006e00ff027624ULL, 0x000fca00078e00ffULL, 0x0000000602037981ULL, 0x000f28000c1e9900ULL,
0x0000000000047919ULL, 0x004ea40000000000ULL, 0x00000002ff3f7819ULL, 0x004fe20000011604ULL,
0x0000000003047220ULL, 0x018fe20000410000ULL, 0x000084d27f007947ULL, 0x000fea000b800000ULL,
0x00001f3f04007589ULL, 0x0004e400000e0000ULL, 0x0000000000027919ULL, 0x000f220000000000ULL,
0x0000001300137220ULL, 0x048fe20000410000ULL, 0x0000001400147220ULL, 0x040fe20000410000ULL,
0x0000001700177220ULL, 0x040fe20000410000ULL, 0x0000001800187220ULL, 0x040fe20000410000ULL,
0x0000001b001b7220ULL, 0x040fe20000410000ULL, 0x0000001c001c7220ULL, 0x040fe20000410000ULL,
0x0000001f001f7220ULL, 0x040fe20000410000ULL, 0x0000002000207220ULL, 0x040fe20000410000ULL,
0x0000002300237220ULL, 0x040fe20000410000ULL, 0x0000002400247220ULL, 0x040fe20000410000ULL,
0x0000002700277220ULL, 0x040fe20000410000ULL, 0x0000002800287220ULL, 0x040fe20000410000ULL,
0x0000002b002b7220ULL, 0x040fe20000410000ULL, 0x0000002c002c7220ULL, 0x040fe20000410000ULL,
0x0000002f002f7220ULL, 0x040fe20000410000ULL, 0x0000003000307220ULL, 0x000fe20000410000ULL,
0x00000008023f7811ULL, 0x016fe200078ff0ffULL, 0x000083e27f007947ULL, 0x000fea000b800000ULL,
0x00001f3f04007589ULL, 0x0002a400000e0000ULL, 0x0000001500157220ULL, 0x044fe20000410000ULL,
0x0000001600167220ULL, 0x040fe20000410000ULL, 0x0000001900197220ULL, 0x040fe20000410000ULL,
0x0000001a001a7220ULL, 0x040fe20000410000ULL, 0x0000001d001d7220ULL, 0x040fe20000410000ULL,
0x0000001e001e7220ULL, 0x040fe20000410000ULL, 0x0000002100217220ULL, 0x040fe20000410000ULL,
0x0000002200227220ULL, 0x040fe20000410000ULL, 0x0000002500257220ULL, 0x040fe20000410000ULL,
0x0000002600267220ULL, 0x040fe20000410000ULL, 0x0000002900297220ULL, 0x040fe20000410000ULL,
0x0000002a002a7220ULL, 0x040fe20000410000ULL, 0x0000002d002d7220ULL, 0x040fe20000410000ULL,
0x0000002e002e7220ULL, 0x040fe20000410000ULL, 0x0000003100317220ULL, 0x040fe20000410000ULL,
0x0000006000607220ULL, 0x000fc20000410000ULL, 0x0000000000357919ULL, 0x000ee20000002600ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000131400723eULL, 0x000fc400000010ffULL,
0x000000171802723eULL, 0x002fe400000010ffULL, 0x0000001b1c03723eULL, 0x000fe400000010ffULL,
0x0000001f2004723eULL, 0x004fe400000010ffULL, 0x000000232405723eULL, 0x000fe400000010ffULL,
0x000000272806723eULL, 0x000fe400000010ffULL, 0x0000002b2c07723eULL, 0x000fc400000010ffULL,
0x0000002f3008723eULL, 0x000fe400000010ffULL, 0x000000151609723eULL, 0x000fe400000010ffULL,
0x000000191a0a723eULL, 0x000fe400000010ffULL, 0x0000001d1e0b723eULL, 0x000fe400000010ffULL,
0x00000021220c723eULL, 0x000fe400000010ffULL, 0x00000025260d723eULL, 0x000fc400000010ffULL,
0x000000292a0e723eULL, 0x000fe400000010ffULL, 0x0000002d2e0f723eULL, 0x000fe400000010ffULL,
0x000000316010723eULL, 0x000fc400000010ffULL, 0x0000000000147919ULL, 0x008e620000000000ULL,
0x0000a00065657811ULL, 0x000fe400078e58ffULL, 0x00005410001c7816ULL, 0x140fe20000000002ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00007632001d7816ULL, 0x000fc40000000002ULL,
0x0000541003027816ULL, 0x140fe40000000004ULL, 0x0000763203037816ULL, 0x000fe40000000004ULL,
0x0000541005047816ULL, 0x140fe40000000006ULL, 0x0000763205057816ULL, 0x000fe40000000006ULL,
0x0000541007067816ULL, 0x140fe40000000008ULL, 0x0000763207077816ULL, 0x000fc40000000008ULL,
0x0000000814127811ULL, 0x042fe400078ff0ffULL, 0x0000000214117812ULL, 0x000fe400078ec0ffULL,
0x0000541009087816ULL, 0x000fe2000000000aULL, 0x00000008121a7824ULL, 0x000fe200078e00ffULL,
0x0000001211137211ULL, 0x000fe200078ff8ffULL, 0x0000000814127824ULL, 0x000fe200078e00ffULL,
0x00000002ff147819ULL, 0x000fe40000011614ULL, 0xfffffff81a1a7812ULL, 0x000fc400078ee213ULL,
0x0000000812137812ULL, 0x000fe200078ec0ffULL, 0x0000000814127824ULL, 0x040fe200078e00ffULL,
0x0000001411117211ULL, 0x000fe200078ff8ffULL, 0x0000000814177824ULL, 0x040fe200078e00ffULL,
0x0000763209097816ULL, 0x000fe2000000000aULL, 0x0000000814167824ULL, 0x000fe200078e00ffULL,
0xfffffff812127812ULL, 0x000fe200078ee211ULL, 0x0000000814187824ULL, 0x000fe200078e00ffULL,
0x0000000211147810ULL, 0x040fe20007ffe0ffULL, 0x000000101a1a7824ULL, 0x100fe200078e0265ULL,
0x0000000411157810ULL, 0x040fe20007ffe0ffULL, 0x0000001012127824ULL, 0x000fe200078e0265ULL,
0x0000000611117810ULL, 0x000fe20007ffe0ffULL, 0x00000001131a7824ULL, 0x000fe200078e021aULL,
0xfffffff817147812ULL, 0x000fe200078ee214ULL, 0x0000000112127824ULL, 0x000fe200078e0213ULL,
0xfffffff816167812ULL, 0x000fc400078ee215ULL, 0xfffffff818187812ULL, 0x000fe200078ee211ULL,
0x0000001014147824ULL, 0x100fe200078e0265ULL, 0x000054100b0a7816ULL, 0x140fe2000000000cULL,
0x0000001016167824ULL, 0x100fe200078e0265ULL, 0x000076320b0b7816ULL, 0x000fe2000000000cULL,
0x0000001018187824ULL, 0x000fe200078e0265ULL, 0x000054100d0c7816ULL, 0x000fe2000000000eULL,
0x0000000113147824ULL, 0x040fe200078e0214ULL, 0x0000001c12007388ULL, 0x0003e20000000a00ULL,
0x0000000113167824ULL, 0x000fe200078e0216ULL, 0x000076320d0d7816ULL, 0x000fe2000000000eULL,
0x0000000113187824ULL, 0x000fe200078e0218ULL, 0x0000000214007388ULL, 0x0003e20000000a00ULL,
0x000054100f0e7816ULL, 0x000fc40000000010ULL, 0x000076320f0f7816ULL, 0x000fe20000000010ULL,
0x0000000416007388ULL, 0x0003e80000000a00ULL, 0x0000000618007388ULL, 0x0003e80000000a00ULL,
0x000000081a007388ULL, 0x0003e80000000a00ULL, 0x0004000a14007388ULL, 0x0003e80000000a00ULL,
0x0004000c16007388ULL, 0x0003e80000000a00ULL, 0x0004000e18007388ULL, 0x0003e20000000a00ULL,
0x0000002000007947ULL, 0x000fea0003800000ULL, 0x0001f5d000247802ULL, 0x000fc40000000f00ULL,
0x0000838000007944ULL, 0x002fea0003c00000ULL, 0x0000000000057919ULL, 0x002e620000000000ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000580036367a24ULL, 0x000fe200078e02ffULL,
0x00000003ff007819ULL, 0x002fca0000011605ULL, 0x0000000100027824ULL, 0x040fe400078e0205ULL,
0x0000580000037a24ULL, 0x000fc600078e0235ULL, 0x0000000702027812ULL, 0x000fe400078ec0ffULL,
0x0000000336037211ULL, 0x000fe400078010ffULL, 0x0ffffff802027812ULL, 0x000fe400078ef805ULL,
0x0000000705057812ULL, 0x000fe200078ec0ffULL, 0x000000ffff007224ULL, 0x000fe400000e06ffULL,
0x0000001002657824ULL, 0x000fe200078e0265ULL, 0x00005a0003027a11ULL, 0x000fc400078048ffULL,
0x1ffffff805057812ULL, 0x000fe400078ef862ULL, 0x00005b0003037a11ULL, 0x000fe200000f4c00ULL,
0x0000000065647984ULL, 0x000e680000000c00ULL, 0x0000001005027825ULL, 0x000fca00078e0002ULL,
0x0000006402007986ULL, 0x002fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0000004065307824ULL, 0x040fe200078e00ffULL, 0x0000002012057810ULL, 0x040fe20007ffe0ffULL,
0x0000010065317824ULL, 0x000fe200078e00ffULL, 0x000000031200780cULL, 0x000fe20003f44070ULL,
0x0000680063027a24ULL, 0x000fe400078e0230ULL, 0x0000000130047824ULL, 0x140fe400078e0212ULL,
0x0000000130067824ULL, 0x102fe400078e0205ULL, 0x0000000102037824ULL, 0x000fe200078e0212ULL,
0x000000610400720cULL, 0x080fe20003f06070ULL, 0x0000000102057824ULL, 0x000fe200078e0205ULL,
0x000000610600720cULL, 0x000fe20003f26070ULL, 0x0000000412097824ULL, 0x000fc400078e0231ULL,
0x0000660003027625ULL, 0x000fc800078e000eULL, 0x0000660005047625ULL, 0x000fe200078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010ad000ff067f8cULL, 0x000e62000c80043fULL,
0x0000011000007945ULL, 0x000fe20003800000ULL, 0x00006e00ff3c7624ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x1060000002097faeULL, 0x0005e2000c121846ULL,
0x00006f00ff3d7624ULL, 0x000fc600078e00ffULL, 0x1068000004097faeULL, 0x0005e2000c921846ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x0000000436027824ULL, 0x104fe200078e0212ULL,
0x000000646500720cULL, 0x040fe20003f06070ULL, 0x0000000465057824ULL, 0x000fe400078e0212ULL,
0x0000000202027824ULL, 0x000fc600078e00ffULL, 0x00010a8005057811ULL, 0x000fe200078e10ffULL,
0x0000640002027a24ULL, 0x000fc800078e0265ULL, 0x0000600002027625ULL, 0x000fca00078e000eULL,
0x0000000002057faeULL, 0x0005e4000c121846ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000001ff0000780cULL, 0x000fe20003f04070ULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x000000063c3c7981ULL, 0x000728000c1e9900ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000604047899ULL, 0x000fe2000800063fULL, 0x000000ffff177224ULL, 0x002fe200078e0007ULL,
0x000080000000791aULL, 0x000fc80000000000ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000093000000947ULL, 0x000fea0003800000ULL, 0x0000000000077919ULL, 0x008e620000000000ULL,
0x00010a80650b7811ULL, 0x000fe200078e20ffULL, 0x00000100ff0e7424ULL, 0x000fe200078e00ffULL,
0x0000003061037217ULL, 0x004fe40007800000ULL, 0x00002000650d7811ULL, 0x000fe400078e68ffULL,
0x00000002ff137819ULL, 0x002fe20000011607ULL, 0x0000001007117824ULL, 0x040fe200078e00ffULL,
0x0000000707047211ULL, 0x000fc600078fe8ffULL, 0x0000000413097824ULL, 0x000fe200078e0231ULL,
0x0000003011117812ULL, 0x000fe200078ec0ffULL, 0x00000040340a7824ULL, 0x000fe200078e0213ULL,
0x0000000304087812ULL, 0x000fe400078ec0ffULL, 0x0106000009007984ULL, 0x000e640000000800ULL,
0x0000000400057824ULL, 0x002fe400078e020bULL, 0x0000000103007824ULL, 0x000fc800078e0a30ULL,
0x0000000005057984ULL, 0x000e620000000800ULL, 0x000000001300720cULL, 0x000fe20003f06070ULL,
0x0000000405027c24ULL, 0x002fc8000f8e020aULL, 0x00005e0002027625ULL, 0x000fca00078e000eULL,
0x0000001102047210ULL, 0x000fe40007f3e0ffULL, 0x0ffffffc08027812ULL, 0x000fe400078ef807ULL,
0x0000000813077810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff057224ULL, 0x000fe200008e0603ULL,
0x000000080a037810ULL, 0x000fe20007ffe0ffULL, 0x00000010020f7824ULL, 0x000fca00078e020dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040f7faeULL, 0x0003e2000c101c46ULL,
0x000000000700720cULL, 0x040fe20003f06070ULL, 0x0000000407077824ULL, 0x000fe400078e00ffULL,
0x0106200009027984ULL, 0x000ea20000000800ULL, 0x0000001013057810ULL, 0x002fe20007ffe0ffULL,
0x00000004020c7824ULL, 0x004fcc00078e020bULL, 0x000000000c0c7984ULL, 0x000e640000000800ULL,
0x000000040c037c24ULL, 0x002fc8000f8e0203ULL, 0x00005e0003027625ULL, 0x000fca00078e000eULL,
0x0000001102067210ULL, 0x000fe40007f3e0ffULL, 0xfffffffc07027812ULL, 0x000fc600078ee208ULL,
0x000000ffff077224ULL, 0x000fe200008e0603ULL, 0x000000100a037810ULL, 0x000fe20007ffe0ffULL,
0x00000010020f7824ULL, 0x000fca00078e020dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000060f7faeULL, 0x0003e2000c101c46ULL, 0x000000000500720cULL, 0x040fe20003f06070ULL,
0x0000000405057824ULL, 0x000fe400078e00ffULL, 0x0106400009027984ULL, 0x000ea20000000800ULL,
0x0000001813077810ULL, 0x002fe20007ffe0ffULL, 0x00000004020c7824ULL, 0x004fcc00078e020bULL,
0x000000000c0c7984ULL, 0x000e640000000800ULL, 0x000000040c037c24ULL, 0x002fc8000f8e0203ULL,
0x00005e0003027625ULL, 0x000fca00078e000eULL, 0x0000001102047210ULL, 0x000fe40007f3e0ffULL,
0xfffffffc05027812ULL, 0x000fc600078ee208ULL, 0x000000ffff057224ULL, 0x000fe200008e0603ULL,
0x000000180a037810ULL, 0x000fe20007ffe0ffULL, 0x00000010020f7824ULL, 0x000fca00078e020dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040f7faeULL, 0x0003e2000c101c46ULL,
0x000000000700720cULL, 0x040fe20003f06070ULL, 0x0000000407077824ULL, 0x000fe400078e00ffULL,
0x0106600009027984ULL, 0x000ea20000000800ULL, 0x0000002013057810ULL, 0x002fe20007ffe0ffULL,
0x00000004020c7824ULL, 0x004fcc00078e020bULL, 0x000000000c0c7984ULL, 0x000e640000000800ULL,
0x000000040c037c24ULL, 0x002fc8000f8e0203ULL, 0x00005e0003027625ULL, 0x000fca00078e000eULL,
0x0000001102067210ULL, 0x000fe40007f3e0ffULL, 0xfffffffc07027812ULL, 0x000fc600078ee208ULL,
0x000000ffff077224ULL, 0x000fe200008e0603ULL, 0x000000200a037810ULL, 0x000fe20007ffe0ffULL,
0x00000010020f7824ULL, 0x000fca00078e020dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000060f7faeULL, 0x0003e2000c101c46ULL, 0x000000000500720cULL, 0x040fe20003f06070ULL,
0x0000000405057824ULL, 0x000fe400078e00ffULL, 0x0106800009027984ULL, 0x000ea20000000800ULL,
0x0000002813077810ULL, 0x002fe20007ffe0ffULL, 0x00000004020c7824ULL, 0x004fcc00078e020bULL,
0x000000000c0c7984ULL, 0x000e640000000800ULL, 0x000000040c037c24ULL, 0x002fc8000f8e0203ULL,
0x00005e0003027625ULL, 0x000fca00078e000eULL, 0x0000001102047210ULL, 0x000fe40007f3e0ffULL,
0xfffffffc05027812ULL, 0x000fc600078ee208ULL, 0x000000ffff057224ULL, 0x000fe200008e0603ULL,
0x000000280a037810ULL, 0x000fe20007ffe0ffULL, 0x00000010020f7824ULL, 0x000fca00078e020dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040f7faeULL, 0x0003e2000c101c46ULL,
0x000000000700720cULL, 0x040fe20003f06070ULL, 0x0000000407077824ULL, 0x000fe400078e00ffULL,
0x0106a00009027984ULL, 0x000ea20000000800ULL, 0x0000003013057810ULL, 0x002fe20007ffe0ffULL,
0x00000004020c7824ULL, 0x004fcc00078e020bULL, 0x000000000c0c7984ULL, 0x000e640000000800ULL,
0x000000040c037c24ULL, 0x002fc8000f8e0203ULL, 0x00005e0003027625ULL, 0x000fca00078e000eULL,
0x0000001102067210ULL, 0x000fe40007f3e0ffULL, 0xfffffffc07027812ULL, 0x000fc600078ee208ULL,
0x000000ffff077224ULL, 0x000fe200008e0603ULL, 0x000000300a037810ULL, 0x000fe20007ffe0ffULL,
0x00000010020f7824ULL, 0x000fca00078e020dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000060f7faeULL, 0x0003e2000c101c46ULL, 0x000000000500720cULL, 0x040fe20003f06070ULL,
0x0000000405057824ULL, 0x000fe400078e00ffULL, 0x0106c00009027984ULL, 0x000ea40000000800ULL,
0x00000004020c7824ULL, 0x004fcc00078e020bULL, 0x000000000c0c7984ULL, 0x000ea40000000800ULL,
0x000000040c037c24ULL, 0x004fc8000f8e0203ULL, 0x00005e0003027625ULL, 0x000fca00078e000eULL,
0x0000001102047210ULL, 0x000fe40007f3e0ffULL, 0xfffffffc05027812ULL, 0x000fc600078ee208ULL,
0x000000ffff057224ULL, 0x000fe200008e0603ULL, 0x000000380a037810ULL, 0x000fe20007ffe0ffULL,
0x0000001002077824ULL, 0x002fca00078e020dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004077faeULL, 0x0003e8000c101c46ULL, 0x0106e00009027984ULL, 0x000ea40000000800ULL,
0x0000000402067824ULL, 0x004fe200078e020bULL, 0x00000038130b7810ULL, 0x000fc80007ffe0ffULL,
0x000000000b00720cULL, 0x040fe20003f06070ULL, 0x0000000006067984ULL, 0x000ea20000000800ULL,
0x000000040b0b7824ULL, 0x000fca00078e00ffULL, 0xfffffffc0b087812ULL, 0x000fca00078ee208ULL,
0x00000010080d7824ULL, 0x000fe400078e020dULL, 0x0000000406037c24ULL, 0x004fc8000f8e0203ULL,
0x00005e0003027625ULL, 0x000fca00078e000eULL, 0x0000001102027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e0603ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000020d7faeULL, 0x0003e2000c101c46ULL, 0x0000088000007947ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x00ce620000000000ULL, 0x00010a80650b7811ULL, 0x040fe200078e20ffULL,
0x00000100ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000200065137811ULL, 0x000fe400078e68ffULL,
0x00000002ff087819ULL, 0x002fe20000011605ULL, 0x0000001005067824ULL, 0x040fe200078e00ffULL,
0x0000000505047211ULL, 0x000fc600078fe8ffULL, 0x0000000408097824ULL, 0x000fe200078e0231ULL,
0x0000003006117812ULL, 0x000fe200078ec0ffULL, 0x00000040340d7824ULL, 0x000fe200078e0208ULL,
0x00000003040a7812ULL, 0x000fe400078ec0ffULL, 0x0106000009007984ULL, 0x000e620000000800ULL,
0x0000000808067810ULL, 0x000fca0007ffe0ffULL, 0x0000000406077824ULL, 0x000fe400078e00ffULL,
0x0000000400007824ULL, 0x002fcc00078e020bULL, 0x0000000000007984ULL, 0x000e640000000800ULL,
0x0000000400027c24ULL, 0x002fe2000f8e020dULL, 0x0ffffffc0a007812ULL, 0x000fc600078ef805ULL,
0x00005e0002027625ULL, 0x000fc800078e000fULL, 0x0000001000157824ULL, 0x000fe200078e0213ULL,
0x0000001102047210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff057224ULL, 0x000fe200000e0603ULL,
0x000000080d037810ULL, 0x000fc80007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004157faeULL, 0x0003e8000b901c46ULL, 0x0106200009007984ULL, 0x000ea20000000800ULL,
0x0000001008047810ULL, 0x002fca0007ffe0ffULL, 0x0000000404057824ULL, 0x000fe400078e00ffULL,
0x0000000400007824ULL, 0x004fcc00078e020bULL, 0x0000000000007984ULL, 0x000e640000000800ULL,
0x0000000400027c24ULL, 0x002fc8000f8e0203ULL, 0x00005e0002027625ULL, 0x000fca00078e000fULL,
0x0000001102067210ULL, 0x000fe40007f1e0ffULL, 0xfffffffc07027812ULL, 0x000fc600078ee20aULL,
0x000000ffff077224ULL, 0x000fe200000e0603ULL, 0x000000100d037810ULL, 0x000fe20007ffe0ffULL,
0x0000001002157824ULL, 0x000fca00078e0213ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006157faeULL, 0x0003e8000b901c46ULL, 0x0106400009007984ULL, 0x000ea20000000800ULL,
0x0000001808067810ULL, 0x002fca0007ffe0ffULL, 0x0000000406077824ULL, 0x000fe400078e00ffULL,
0x0000000400007824ULL, 0x004fcc00078e020bULL, 0x0000000000007984ULL, 0x000e640000000800ULL,
0x0000000400027c24ULL, 0x002fc8000f8e0203ULL, 0x00005e0002027625ULL, 0x000fca00078e000fULL,
0x0000001102047210ULL, 0x000fe40007f1e0ffULL, 0xfffffffc05027812ULL, 0x000fc600078ee20aULL,
0x000000ffff057224ULL, 0x000fe200000e0603ULL, 0x000000180d037810ULL, 0x000fe20007ffe0ffULL,
0x0000001002157824ULL, 0x000fca00078e0213ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004157faeULL, 0x0003e8000b901c46ULL, 0x0106600009007984ULL, 0x000ea20000000800ULL,
0x0000002008047810ULL, 0x002fca0007ffe0ffULL, 0x0000000404057824ULL, 0x000fe400078e00ffULL,
0x0000000400007824ULL, 0x004fcc00078e020bULL, 0x0000000000007984ULL, 0x000e640000000800ULL,
0x0000000400027c24ULL, 0x002fc8000f8e0203ULL, 0x00005e0002027625ULL, 0x000fca00078e000fULL,
0x0000001102067210ULL, 0x000fe40007f1e0ffULL, 0xfffffffc07027812ULL, 0x000fc600078ee20aULL,
0x000000ffff077224ULL, 0x000fe200000e0603ULL, 0x000000200d037810ULL, 0x000fe20007ffe0ffULL,
0x0000001002157824ULL, 0x000fca00078e0213ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006157faeULL, 0x0003e8000b901c46ULL, 0x0106800009007984ULL, 0x000ea20000000800ULL,
0x0000002808067810ULL, 0x002fca0007ffe0ffULL, 0x0000000406077824ULL, 0x000fe400078e00ffULL,
0x0000000400007824ULL, 0x004fcc00078e020bULL, 0x0000000000007984ULL, 0x000e640000000800ULL,
0x0000000400027c24ULL, 0x002fc8000f8e0203ULL, 0x00005e0002027625ULL, 0x000fca00078e000fULL,
0x0000001102047210ULL, 0x000fe40007f1e0ffULL, 0xfffffffc05027812ULL, 0x000fc600078ee20aULL,
0x000000ffff057224ULL, 0x000fe200000e0603ULL, 0x000000280d037810ULL, 0x000fe20007ffe0ffULL,
0x0000001002157824ULL, 0x000fca00078e0213ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004157faeULL, 0x0003e8000b901c46ULL, 0x0106a00009007984ULL, 0x000ea20000000800ULL,
0x0000003008047810ULL, 0x042fe40007ffe0ffULL, 0x0000003808087810ULL, 0x000fc60007ffe0ffULL,
0x0000000404057824ULL, 0x000fe400078e00ffULL, 0x0000000400007824ULL, 0x004fcc00078e020bULL,
0x0000000000007984ULL, 0x000e640000000800ULL, 0x0000000400027c24ULL, 0x002fc8000f8e0203ULL,
0x00005e0002027625ULL, 0x000fca00078e000fULL, 0x0000001102067210ULL, 0x000fe40007f1e0ffULL,
0xfffffffc07027812ULL, 0x000fc600078ee20aULL, 0x000000ffff077224ULL, 0x000fe200000e0603ULL,
0x000000300d037810ULL, 0x040fe20007ffe0ffULL, 0x0000001002157824ULL, 0x000fe200078e0213ULL,
0x000000380d0d7810ULL, 0x000fc80007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006157faeULL, 0x0003e8000b901c46ULL, 0x0106c00009007984ULL, 0x000ea40000000800ULL,
0x0000000400007824ULL, 0x004fcc00078e020bULL, 0x0000000000007984ULL, 0x000ea40000000800ULL,
0x0000000400027c24ULL, 0x004fc8000f8e0203ULL, 0x00005e0002027625ULL, 0x000fca00078e000fULL,
0x0000001102047210ULL, 0x000fe40007f1e0ffULL, 0xfffffffc05027812ULL, 0x000fc600078ee20aULL,
0x000000ffff057224ULL, 0x000fe400000e0603ULL, 0x0000001002077824ULL, 0x002fca00078e0213ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004077faeULL, 0x0003e8000b901c46ULL,
0x0106e00009007984ULL, 0x000ea40000000800ULL, 0x0000000400007824ULL, 0x004fe400078e020bULL,
0x00000004080b7824ULL, 0x000fc800078e00ffULL, 0x0000000000007984ULL, 0x000ea20000000800ULL,
0xfffffffc0b0a7812ULL, 0x000fca00078ee20aULL, 0x000000100a137824ULL, 0x000fe400078e0213ULL,
0x0000000400027c24ULL, 0x004fc8000f8e020dULL, 0x00005e0002027625ULL, 0x000fca00078e000fULL,
0x0000001102027210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff037224ULL, 0x000fca00000e0603ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002137faeULL, 0x0003e6000b901c46ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000027805ULL, 0x002fc40000015200ULL, 0x010ad400ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007804817ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff067224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fcc0000015200ULL,
0x0000000402077210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e03ULL,
0x003d09000700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011405ULL, 0x0000000700007211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000200007819ULL, 0x000fc80000001205ULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000106067810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x010ad400ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007804817ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x000e640000000000ULL,
0x0000002065007824ULL, 0x002fca00078e0200ULL, 0x00000003ff027819ULL, 0x000fe40000011600ULL,
0x0000000f00007812ULL, 0x000fe400078ec0ffULL, 0x1ffffffe02037812ULL, 0x000fe400078ec0ffULL,
0x0000000100027810ULL, 0x040fe20007ffe0ffULL, 0x0000002000067824ULL, 0x040fe400078e00ffULL,
0x0000000100047824ULL, 0x040fe400078e0203ULL, 0x0000000103057824ULL, 0x040fe200078e0202ULL,
0x0000001003037810ULL, 0x000fe20007ffe0ffULL, 0x0000002000077824ULL, 0x000fe200078e00ffULL,
0x0000001f04047812ULL, 0x000fc400078ec0ffULL, 0x0000001f05057812ULL, 0x000fe200078ec0ffULL,
0x0000000102027824ULL, 0x000fe200078e0203ULL, 0x000001e007047812ULL, 0x040fe400078ee204ULL,
0x000001e006057812ULL, 0x000fe200078ee205ULL, 0x0000000100067824ULL, 0x000fe200078e0203ULL,
0x0000001f02027812ULL, 0x000fe200078ec0ffULL, 0x00000000040c7984ULL, 0x000e62000000cc00ULL,
0x0000002000037824ULL, 0x000fe400078e00ffULL, 0x0000001f06067812ULL, 0x000fe200078ec0ffULL,
0x0000000005087984ULL, 0x000ea2000000cc00ULL, 0x000001e007027812ULL, 0x000fc400078ee202ULL,
0x000001e003067812ULL, 0x000fe200078ee206ULL, 0x000000ffff107224ULL, 0x002fe400078e000cULL,
0x000000ffff117224ULL, 0x000fe400078e000eULL, 0x000000ffff127224ULL, 0x004fe400078e0008ULL,
0x000000ffff137224ULL, 0x000fe400078e000aULL, 0x000000ffff167224ULL, 0x000fe400078e0009ULL,
0x000000ffff177224ULL, 0x000fe200078e000bULL, 0x0000001004007388ULL, 0x000fe2000000cc00ULL,
0x000000ffff147224ULL, 0x000fc400078e000dULL, 0x000000ffff157224ULL, 0x000fca00078e000fULL,
0x0000001405007388ULL, 0x000fe8000000cc00ULL, 0x0000000002087984ULL, 0x000e68000000cc00ULL,
0x00000000060c7984ULL, 0x000ea2000000cc00ULL, 0x000000ffff1b7224ULL, 0x002fe400078e000aULL,
0x000000ffff1a7224ULL, 0x000fc400078e0008ULL, 0x000000ffff0a7224ULL, 0x000fe400078e0009ULL,
0x000000ffff187224ULL, 0x004fe400078e000cULL, 0x000000ffff197224ULL, 0x000fe400078e000eULL,
0x000000ffff087224ULL, 0x000fe400078e000dULL, 0x000000ffff097224ULL, 0x000fe200078e000fULL,
0x0000001806007388ULL, 0x0003e8000000cc00ULL, 0x0000000802007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010ad000ff027f8cULL, 0x002e62000c80043fULL,
0x000000ffff067224ULL, 0x000fc400078e00ffULL, 0x000000ffff097224ULL, 0x002fc400078e0003ULL,
0x0000000000027805ULL, 0x000fca0000015200ULL, 0x010ad400ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000047805ULL, 0x000fcc0000015200ULL, 0x0000000402077210ULL, 0x000fca0007f1e1ffULL,
0x0000000105057824ULL, 0x000fe200000e0e03ULL, 0x003d09000700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011405ULL,
0x0000000700007211ULL, 0x000fca00078110ffULL, 0x000000ffff057224ULL, 0x000fca00000e0605ULL,
0x0000000200007819ULL, 0x000fc80000001205ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000106067810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x010ad400ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff3700720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000327919ULL, 0x000e620000000000ULL, 0x00005800ff437624ULL, 0x000fe200078e00ffULL,
0x3d8000003c3c7820ULL, 0x010fe20000410000ULL, 0x00010b58653d7811ULL, 0x000fe200078e18ffULL,
0x000000ffff407224ULL, 0x000fe200078e00ffULL, 0xffffffff373e7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff427224ULL, 0x000fe200078e00ffULL, 0x00010ad8653f7811ULL, 0x000fe200078e28ffULL,
0x000000ffff417224ULL, 0x000fe400078e0065ULL, 0x0000004043437824ULL, 0x000fc400078e00ffULL,
0x0000010040447824ULL, 0x000fe200078e0230ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x000000446100720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x00cfea0003800000ULL,
0x00000004ff467424ULL, 0x000fe200078e00ffULL, 0x000000403500720cULL, 0x000fe20003f44070ULL,
0x000000ffff457224ULL, 0x000fc600078e00ffULL, 0x0000000146467807ULL, 0x000fc40005000000ULL,
0x000000ffff487224ULL, 0x000fe200078e0042ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff477224ULL, 0x000fe200078e0045ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x000000ffff497224ULL, 0x000fe200078e00ffULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x0000000000047805ULL, 0x000fc4000001ff00ULL, 0x000080000000791aULL, 0x000fc80000000000ULL,
0x000000237f007947ULL, 0x020fea000b800000ULL, 0x0002161000247802ULL, 0x000fc40000000f00ULL,
0x0000634000007944ULL, 0x002fea0003c00000ULL, 0x0000000149527810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000004552037211ULL, 0x000fe200078ff0ffULL,
0x0000116000007945ULL, 0x000fe20003800000ULL, 0x0000000148427812ULL, 0x000fe400078e0cffULL,
0x0000000303007812ULL, 0x000fe400078ec0ffULL, 0x00000002ff03a819ULL, 0x000fe40000011603ULL,
0x00000003524d7812ULL, 0x000fe400078ec0ffULL, 0x000000ff00007207ULL, 0x000fe20005000000ULL,
0x0000000103027824ULL, 0x000fca00078e0240ULL, 0x0000000102247810ULL, 0x000fc80007ffe0ffULL,
0x000000372400720cULL, 0x000fda0003f06070ULL, 0x000008c000008947ULL, 0x000fea0003800000ULL,
0x00000002ff2c7819ULL, 0x002fe20000011632ULL, 0x0000010002247824ULL, 0x000fe200078e0230ULL,
0x00010a80652f7811ULL, 0x000fe200078e20ffULL, 0x000000044d297824ULL, 0x000fe200078e00ffULL,
0x0000003232277211ULL, 0x000fe200078fe8ffULL, 0x000000042c2e7824ULL, 0x040fe200078e0231ULL,
0x000000082c3a7810ULL, 0x000fe20007ffe0ffULL, 0x0000004034387824ULL, 0x000fe200078e022cULL,
0x00000003272d7812ULL, 0x000fe200078ec0ffULL, 0x0000000265287824ULL, 0x000fe200078e0242ULL,
0x010600002e037984ULL, 0x000e620000000800ULL, 0x00000100ff397424ULL, 0x000fe200078e00ffULL,
0xfffffffc29297812ULL, 0x000fe200078ee232ULL, 0x000000043a4e7824ULL, 0x000fe200078e00ffULL,
0x0000200028287811ULL, 0x000fc400078e60ffULL, 0x0ffffffc2d2b7812ULL, 0x000fe400078ef832ULL,
0xfffffffc4e3b7812ULL, 0x000fc600078ee22dULL, 0x000000102b2b7824ULL, 0x000fe400078e0228ULL,
0x0000000403257824ULL, 0x002fe200078e022fULL, 0x0000002461037217ULL, 0x000fc80007800000ULL,
0x0000000025267984ULL, 0x000e620000000800ULL, 0x0000000103037824ULL, 0x000fca00078e0a24ULL,
0x000000032c00720cULL, 0x000fe20003f06070ULL, 0x0000002643247224ULL, 0x002fc800078e0238ULL,
0x00005e0024247625ULL, 0x000fcc00078e0039ULL, 0x0000001029247825ULL, 0x000fca00078e0024ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000242b7faeULL, 0x0003e2000c101c46ULL,
0x000000033a00720cULL, 0x000fe40003f06070ULL, 0x000000102c3a7810ULL, 0x000fe20007ffe0ffULL,
0x010620002e267984ULL, 0x000ea80000000800ULL, 0x000000043a4e7824ULL, 0x000fe400078e00ffULL,
0x000000103b2b7824ULL, 0x002fc600078e0228ULL, 0xfffffffc4e3b7812ULL, 0x000fe200078ee22dULL,
0x00000004262a7824ULL, 0x004fe200078e022fULL, 0x0000000838267810ULL, 0x000fca0007ffe0ffULL,
0x000000002a2a7984ULL, 0x000e640000000800ULL, 0x0000002a43267224ULL, 0x002fc800078e0226ULL,
0x00005e0026267625ULL, 0x000fcc00078e0039ULL, 0x0000001029267825ULL, 0x000fca00078e0026ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262b7faeULL, 0x0003e2000c101c46ULL,
0x000000033a00720cULL, 0x000fe40003f06070ULL, 0x000000182c3a7810ULL, 0x000fe20007ffe0ffULL,
0x010640002e247984ULL, 0x000ea80000000800ULL, 0x000000043a4e7824ULL, 0x000fe400078e00ffULL,
0x000000103b2b7824ULL, 0x002fc600078e0228ULL, 0xfffffffc4e3b7812ULL, 0x000fe200078ee22dULL,
0x00000004242a7824ULL, 0x004fe200078e022fULL, 0x0000001038247810ULL, 0x000fca0007ffe0ffULL,
0x000000002a2a7984ULL, 0x000e640000000800ULL, 0x0000002a43247224ULL, 0x002fc800078e0224ULL,
0x00005e0024247625ULL, 0x000fcc00078e0039ULL, 0x0000001029247825ULL, 0x000fca00078e0024ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000242b7faeULL, 0x0003e2000c101c46ULL,
0x000000033a00720cULL, 0x000fe40003f06070ULL, 0x000000202c3a7810ULL, 0x000fe20007ffe0ffULL,
0x010660002e267984ULL, 0x000ea80000000800ULL, 0x000000043a4e7824ULL, 0x000fe400078e00ffULL,
0x000000103b2b7824ULL, 0x002fc600078e0228ULL, 0xfffffffc4e3b7812ULL, 0x000fe200078ee22dULL,
0x00000004262a7824ULL, 0x004fe200078e022fULL, 0x0000001838267810ULL, 0x000fca0007ffe0ffULL,
0x000000002a2a7984ULL, 0x000e640000000800ULL, 0x0000002a43267224ULL, 0x002fc800078e0226ULL,
0x00005e0026267625ULL, 0x000fcc00078e0039ULL, 0x0000001029267825ULL, 0x000fca00078e0026ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262b7faeULL, 0x0003e2000c101c46ULL,
0x000000033a00720cULL, 0x000fe40003f06070ULL, 0x000000282c3a7810ULL, 0x000fe20007ffe0ffULL,
0x010680002e247984ULL, 0x000ea80000000800ULL, 0x000000043a4e7824ULL, 0x000fe400078e00ffULL,
0x000000103b2b7824ULL, 0x002fc600078e0228ULL, 0xfffffffc4e3b7812ULL, 0x000fe200078ee22dULL,
0x00000004242a7824ULL, 0x004fe200078e022fULL, 0x0000002038247810ULL, 0x000fca0007ffe0ffULL,
0x000000002a2a7984ULL, 0x000e640000000800ULL, 0x0000002a43247224ULL, 0x002fc800078e0224ULL,
0x00005e0024247625ULL, 0x000fcc00078e0039ULL, 0x0000001029247825ULL, 0x000fca00078e0024ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000242b7faeULL, 0x0003e2000c101c46ULL,
0x000000033a00720cULL, 0x000fe40003f06070ULL, 0x000000302c3a7810ULL, 0x040fe20007ffe0ffULL,
0x0106a0002e267984ULL, 0x000ea20000000800ULL, 0x000000382c2c7810ULL, 0x000fc60007ffe0ffULL,
0x000000043a4e7824ULL, 0x000fe400078e00ffULL, 0x000000103b2b7824ULL, 0x002fc600078e0228ULL,
0xfffffffc4e3b7812ULL, 0x000fe200078ee22dULL, 0x00000004262a7824ULL, 0x004fe200078e022fULL,
0x0000002838267810ULL, 0x000fca0007ffe0ffULL, 0x000000002a2a7984ULL, 0x000e640000000800ULL,
0x0000002a43267224ULL, 0x002fc800078e0226ULL, 0x00005e0026267625ULL, 0x000fcc00078e0039ULL,
0x0000001029267825ULL, 0x000fca00078e0026ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000262b7faeULL, 0x0003e2000c101c46ULL, 0x000000033a00720cULL, 0x000fc60003f06070ULL,
0x0106c0002e247984ULL, 0x000ea20000000800ULL, 0x000000103b2b7824ULL, 0x002fe400078e0228ULL,
0x00000004242a7824ULL, 0x004fe200078e022fULL, 0x0000003038247810ULL, 0x000fca0007ffe0ffULL,
0x000000002a2a7984ULL, 0x000e640000000800ULL, 0x0000002a43247224ULL, 0x002fc800078e0224ULL,
0x00005e0024247625ULL, 0x000fcc00078e0039ULL, 0x0000001029247825ULL, 0x000fca00078e0024ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000242b7faeULL, 0x0003e2000c101c46ULL,
0x000000032c00720cULL, 0x000fc60003f06070ULL, 0x0106e0002e267984ULL, 0x000ea40000000800ULL,
0x00000004262a7824ULL, 0x004fe200078e022fULL, 0x0000003838267810ULL, 0x000fe20007ffe0ffULL,
0x000000042c387824ULL, 0x000fc800078e00ffULL, 0x000000002a2a7984ULL, 0x000ea20000000800ULL,
0xfffffffc38037812ULL, 0x000fca00078ee22dULL, 0x0000001003037824ULL, 0x000fe400078e0228ULL,
0x0000002a43267224ULL, 0x004fc800078e0226ULL, 0x00005e0026267625ULL, 0x000fcc00078e0039ULL,
0x0000001029267825ULL, 0x000fca00078e0026ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026037faeULL, 0x0003e2000c101c46ULL, 0x0000080000007947ULL, 0x000fea0003800000ULL,
0x00000002ff287819ULL, 0x002fe20000011632ULL, 0x000000044d297824ULL, 0x000fe200078e00ffULL,
0x00010a80652d7811ULL, 0x040fe200078e20ffULL, 0x0000000265267824ULL, 0x000fe200078e0242ULL,
0x0000003232257211ULL, 0x000fe200078fe8ffULL, 0x00000004282a7824ULL, 0x000fe200078e0231ULL,
0xfffffffc29297812ULL, 0x000fe200078ee232ULL, 0x00000040342c7824ULL, 0x000fe200078e0228ULL,
0x00000003252b7812ULL, 0x000fe200078ec0ffULL, 0x00000100ff2f7424ULL, 0x000fe200078e00ffULL,
0x010600002a037984ULL, 0x000e620000000800ULL, 0x00002000262e7811ULL, 0x000fc400078e60ffULL,
0x000000082c387810ULL, 0x000fe40007ffe0ffULL, 0x0000000828277810ULL, 0x000fe20007ffe0ffULL,
0x0000000403037824ULL, 0x002fca00078e022dULL, 0x0000000003247984ULL, 0x0002a40000000800ULL,
0x0ffffffc2b037812ULL, 0x002fca00078ef832ULL, 0x0000001003397824ULL, 0x000fe400078e022eULL,
0x0000002443247224ULL, 0x004fc800078e022cULL, 0x00005e0024247625ULL, 0x000fcc00078e002fULL,
0x0000001029247825ULL, 0x000fca00078e0024ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024397faeULL, 0x0003e8000b901c46ULL, 0x010620002a037984ULL, 0x000ea20000000800ULL,
0x0000001028257810ULL, 0x002fe20007ffe0ffULL, 0x0000000403037824ULL, 0x004fca00078e022dULL,
0x0000000003267984ULL, 0x000e640000000800ULL, 0x0000002643267224ULL, 0x002fe400078e0238ULL,
0x0000000427387824ULL, 0x000fe400078e00ffULL, 0x00005e0026267625ULL, 0x000fc600078e002fULL,
0xfffffffc383b7812ULL, 0x000fe400078ee22bULL, 0x000000102c387810ULL, 0x000fe20007ffe0ffULL,
0x0000001029267825ULL, 0x000fc800078e0026ULL, 0x000000103b3b7824ULL, 0x000fca00078e022eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000263b7faeULL, 0x0003e8000b901c46ULL,
0x010640002a247984ULL, 0x000ea20000000800ULL, 0x0000001828277810ULL, 0x002fe20007ffe0ffULL,
0x0000000424037824ULL, 0x004fca00078e022dULL, 0x0000000003247984ULL, 0x000e640000000800ULL,
0x0000002443247224ULL, 0x002fe400078e0238ULL, 0x0000000425387824ULL, 0x000fe400078e00ffULL,
0x00005e0024247625ULL, 0x000fc600078e002fULL, 0xfffffffc38397812ULL, 0x000fe400078ee22bULL,
0x000000182c387810ULL, 0x000fe20007ffe0ffULL, 0x0000001029247825ULL, 0x000fc800078e0024ULL,
0x0000001039397824ULL, 0x000fca00078e022eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024397faeULL, 0x0003e8000b901c46ULL, 0x010660002a267984ULL, 0x000ea20000000800ULL,
0x0000002028257810ULL, 0x002fe20007ffe0ffULL, 0x0000000426037824ULL, 0x004fca00078e022dULL,
0x0000000003267984ULL, 0x000e640000000800ULL, 0x0000002643267224ULL, 0x002fe400078e0238ULL,
0x0000000427387824ULL, 0x000fe400078e00ffULL, 0x00005e0026267625ULL, 0x000fc600078e002fULL,
0xfffffffc383b7812ULL, 0x000fe400078ee22bULL, 0x000000202c387810ULL, 0x000fe20007ffe0ffULL,
0x0000001029267825ULL, 0x000fc800078e0026ULL, 0x000000103b3b7824ULL, 0x000fca00078e022eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000263b7faeULL, 0x0003e8000b901c46ULL,
0x010680002a247984ULL, 0x000ea20000000800ULL, 0x0000002828277810ULL, 0x002fe20007ffe0ffULL,
0x0000000424037824ULL, 0x004fca00078e022dULL, 0x0000000003247984ULL, 0x000e640000000800ULL,
0x0000002443247224ULL, 0x002fe400078e0238ULL, 0x0000000425387824ULL, 0x000fe400078e00ffULL,
0x00005e0024247625ULL, 0x000fc600078e002fULL, 0xfffffffc38397812ULL, 0x000fe400078ee22bULL,
0x000000282c387810ULL, 0x000fe20007ffe0ffULL, 0x0000001029247825ULL, 0x000fc800078e0024ULL,
0x0000001039397824ULL, 0x000fca00078e022eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024397faeULL, 0x0003e8000b901c46ULL, 0x0106a0002a267984ULL, 0x000ea20000000800ULL,
0x0000003028257810ULL, 0x042fe40007ffe0ffULL, 0x0000003828287810ULL, 0x000fca0007ffe0ffULL,
0x0000000428287824ULL, 0x000fe400078e00ffULL, 0x0000000426037824ULL, 0x004fca00078e022dULL,
0x0000000003267984ULL, 0x000e640000000800ULL, 0x0000002643267224ULL, 0x002fe400078e0238ULL,
0x0000000427387824ULL, 0x000fe400078e00ffULL, 0x00005e0026267625ULL, 0x000fc600078e002fULL,
0xfffffffc383b7812ULL, 0x000fe400078ee22bULL, 0x000000302c387810ULL, 0x040fe20007ffe0ffULL,
0x0000001029267825ULL, 0x000fe200078e0026ULL, 0x000000382c2c7810ULL, 0x000fc60007ffe0ffULL,
0x000000103b3b7824ULL, 0x000fca00078e022eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000263b7faeULL, 0x0003e8000b901c46ULL, 0x0106c0002a247984ULL, 0x000ea40000000800ULL,
0x0000000424037824ULL, 0x004fca00078e022dULL, 0x0000000003247984ULL, 0x000ea40000000800ULL,
0x0000002443247224ULL, 0x004fe400078e0238ULL, 0x0000000425387824ULL, 0x000fe400078e00ffULL,
0x00005e0024247625ULL, 0x000fc600078e002fULL, 0xfffffffc38397812ULL, 0x100fe400078ee22bULL,
0xfffffffc282b7812ULL, 0x000fe200078ee22bULL, 0x0000001029247825ULL, 0x000fc800078e0024ULL,
0x0000001039397824ULL, 0x100fe400078e022eULL, 0x000000102b2b7824ULL, 0x000fc600078e022eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024397faeULL, 0x0005e8000b901c46ULL,
0x0106e0002a267984ULL, 0x002e640000000800ULL, 0x0000000426037824ULL, 0x002fca00078e022dULL,
0x0000000003267984ULL, 0x000e640000000800ULL, 0x0000002643267224ULL, 0x002fc800078e022cULL,
0x00005e0026267625ULL, 0x000fcc00078e002fULL, 0x0000001029267825ULL, 0x000fca00078e0026ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262b7faeULL, 0x0005e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000237f007947ULL, 0x000fea000b800000ULL,
0x000227e000247802ULL, 0x006fc40000000f00ULL, 0x0000517000007944ULL, 0x000fea0003c00000ULL,
0x000000034d00780cULL, 0x000fe20003f05270ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000030000007945ULL, 0x000fec0003800000ULL, 0x000002e000000947ULL, 0x000fea0003800000ULL,
0x0000000100037810ULL, 0x002fe20007ffe0ffULL, 0x00000004ff277424ULL, 0x004fe200078e00ffULL,
0x000000023500720cULL, 0x000fe20003f04070ULL, 0x0000025000017945ULL, 0x000fe20003800000ULL,
0x00000002ff247819ULL, 0x000fe20000011603ULL, 0x00000004322b7824ULL, 0x000fe200078e0231ULL,
0x0000000303037812ULL, 0x000fc400078ec0ffULL, 0x0000000124257807ULL, 0x000fe40004000000ULL,
0x000000ff03247207ULL, 0x000fe40004000000ULL, 0x0000002032287810ULL, 0x000fe20007ffe0ffULL,
0x0000000102257824ULL, 0x000fe200078e0225ULL, 0x000000023500720cULL, 0x000fe20003f04070ULL,
0x0000000163247824ULL, 0x000fe200078e0224ULL, 0x000000030000780cULL, 0x000fe20003f85270ULL,
0x0000010025257824ULL, 0x000fc800078e0230ULL, 0x0000000125027824ULL, 0x100fe400078e0232ULL,
0x0000000128267824ULL, 0x100fe400078e0225ULL, 0x0000680024257a24ULL, 0x000fe200078e0225ULL,
0x000000610200720cULL, 0x080fe40003f26070ULL, 0x000000612600720cULL, 0x000fe20003f66070ULL,
0x0000000125247824ULL, 0x000fe400078e0232ULL, 0x0000000128267824ULL, 0x000fc400078e0225ULL,
0x0000660024247625ULL, 0x000fc800078e0027ULL, 0x0000660026267625ULL, 0x000fe200078e0027ULL,
0x000000f000008947ULL, 0x000fea0002000000ULL, 0x000000033200780cULL, 0x000fe40003f04070ULL,
0x0000000441417810ULL, 0x000fd60007ffe0ffULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x0000000436007824ULL, 0x100fe200078e0232ULL, 0x000000644100720cULL, 0x000fe20003f06070ULL,
0x0000000465287824ULL, 0x000fe400078e0232ULL, 0x0000000200007824ULL, 0x000fe400078e00ffULL,
0x00000004ff037424ULL, 0x000fe200078e00ffULL, 0x00010a8028297811ULL, 0x000fe200078e10ffULL,
0x0000640000027a24ULL, 0x000fc800078e0241ULL, 0x0000600002027625ULL, 0x000fca00078e0003ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002297faeULL, 0x0003e4000c121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x10600000242b7faeULL, 0x0005e8000c921846ULL, 0x10680000262b7faeULL, 0x0005e4000d921846ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000ffff4e7224ULL, 0x000fc600078e00ffULL, 0xfffffff832037812ULL, 0x022fe200078ec0ffULL,
0x0000000265297824ULL, 0x000fe200078e0248ULL, 0x000000014e2a7810ULL, 0x000fe20007ffe0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000703037812ULL, 0x000fe400078ef832ULL,
0x0000200029297811ULL, 0x000fc400078e60ffULL, 0x00000001ff257819ULL, 0x004fe20000011603ULL,
0x0000000403277824ULL, 0x040fe200078e00ffULL, 0x0000000732ed7812ULL, 0x000fe200078ec0ffULL,
0x0000000403037824ULL, 0x000fe400078e00ffULL, 0x0000000125007824ULL, 0x040fe400078e024eULL,
0x0000000125027824ULL, 0x000fc600078e022aULL, 0xfffffffc27007812ULL, 0x000fe400078ee200ULL,
0xfffffffc03027812ULL, 0x000fe400078ee202ULL, 0x0000002032037810ULL, 0x000fe20007ffe0ffULL,
0x0000001000007824ULL, 0x100fe400078e0229ULL, 0x00000010022c7824ULL, 0x000fe200078e0229ULL,
0xfffffff803037812ULL, 0x000fe400078ec0ffULL, 0x000000000024783bULL, 0x000e640000000200ULL,
0x0000000703037812ULL, 0x000fc400078ef832ULL, 0x000000002c2c783bULL, 0x000ea40000000200ULL,
0x00000001ff2b7819ULL, 0x000fe20000011603ULL, 0x0000000403397824ULL, 0x040fe400078e00ffULL,
0x0000000403037824ULL, 0x000fe400078e00ffULL, 0x000000012b287824ULL, 0x040fe400078e024eULL,
0x000000012b2a7824ULL, 0x000fc600078e022aULL, 0xfffffffc39287812ULL, 0x000fe400078ee228ULL,
0xfffffffc032a7812ULL, 0x000fc600078ee22aULL, 0x0000001028287824ULL, 0x100fe400078e0229ULL,
0x000000102a2a7824ULL, 0x000fc600078e0229ULL, 0x000000002838783bULL, 0x000ee80000000200ULL,
0x000000002a28783bULL, 0x000f220000000200ULL, 0x0001000024ea7824ULL, 0x042fe200078e00ffULL,
0x0000002400dc7306ULL, 0x000fe20000009400ULL, 0x0000010024e77824ULL, 0x000fe200078e00ffULL,
0x00000018ffd07819ULL, 0x000fe20000011425ULL, 0x0001000025c37824ULL, 0x040fe200078e00ffULL,
0x00000018ffea7819ULL, 0x000fe200000114eaULL, 0x0000010025d97824ULL, 0x000fe200078e00ffULL,
0x00000018ffe77819ULL, 0x000fe200000114e7ULL, 0x0001000026d37824ULL, 0x040fe200078e00ffULL,
0x00000024007b7306ULL, 0x000e620000005400ULL, 0x00000018ffc77819ULL, 0x000fe20000011424ULL,
0x0000010026d47824ULL, 0x000fe200078e00ffULL, 0x00000018ffc37819ULL, 0x000fe200000114c3ULL,
0x0001000027cd7824ULL, 0x040fe200078e00ffULL, 0x00000018ffd97819ULL, 0x000fe200000114d9ULL,
0x0000010027ce7824ULL, 0x000fe200078e00ffULL, 0x00000018ffd37819ULL, 0x000fe200000114d3ULL,
0x000000ea00e07306ULL, 0x000fe20000209400ULL, 0x00000018ffc67819ULL, 0x000fe20000011426ULL,
0x000100002ca67824ULL, 0x044fe200078e00ffULL, 0x00000018ffd47819ULL, 0x000fe200000114d4ULL,
0x000001002cb07824ULL, 0x000fe200078e00ffULL, 0x00000018ffcd7819ULL, 0x000fe200000114cdULL,
0x000100002daf7824ULL, 0x040fe200078e00ffULL, 0x00000018ffac7819ULL, 0x000fe20000011427ULL,
0x000000ea00e97306ULL, 0x000ea20000205400ULL, 0x0000007bdc00720bULL, 0x002fe20003f9d000ULL,
0x0000010038dc7824ULL, 0x008fe200078e00ffULL, 0x00000018ffc27819ULL, 0x000fe20000011438ULL,
0x000001002db17824ULL, 0x000fe200078e00ffULL, 0x00000018ffbb7819ULL, 0x000fe20000011439ULL,
0x000100002e917824ULL, 0x040fe200078e00ffULL, 0x00000018ff777819ULL, 0x000fe2000001142fULL,
0x000000e700eb7306ULL, 0x000fe20000209400ULL, 0x00000018ffce7819ULL, 0x000fe200000114ceULL,
0x000001002e907824ULL, 0x000fe200078e00ffULL, 0x00000018ffb97819ULL, 0x000fc4000001143aULL,
0x00000018ffdc7819ULL, 0x000fe400000114dcULL, 0x00000018ffa67819ULL, 0x000fe200000114a6ULL,
0x000000e700ec7306ULL, 0x000e620000205400ULL, 0x000000e9e000720bULL, 0x004fe40003f7d000ULL,
0x00000018ffb07819ULL, 0x000fe400000114b0ULL, 0x00000018ffaf7819ULL, 0x000fe400000114afULL,
0x00000018ff9d7819ULL, 0x000fe2000001142cULL, 0x0000002400027306ULL, 0x0004e2000000d400ULL,
0x00000018ffb17819ULL, 0x000fc400000114b1ULL, 0x00000018ff8b7819ULL, 0x000fe4000001142eULL,
0x00000018ff937819ULL, 0x000fe4000001142dULL, 0x00000018ff917819ULL, 0x000fe20000011491ULL,
0x00000026007e7306ULL, 0x000fe20000009400ULL, 0x000000eceb00720bULL, 0x002fe40003fbd000ULL,
0x00000018ff247819ULL, 0x004fe4000001143bULL, 0x00000018ff907819ULL, 0x000fc40000011490ULL,
0x00000018ff787819ULL, 0x010fe2000001142aULL, 0x0000002600db7306ULL, 0x000e620000005400ULL,
0x0000000102024812ULL, 0x008fce00078efcffULL, 0x0000002700e87306ULL, 0x000ff00000009400ULL,
0x0000002700b77306ULL, 0x000ea20000005400ULL, 0x000000db7e00720bULL, 0x002fe20003f3d000ULL,
0x0001000038db7824ULL, 0x000fca00078e00ffULL, 0x00000018ffdb7819ULL, 0x000fe200000114dbULL,
0x000000d000e37306ULL, 0x000ff00000209400ULL, 0x000000d000c07306ULL, 0x000e620000205400ULL,
0x000000b7e800720bULL, 0x004fc40003fdd000ULL, 0x000000ea00b77245ULL, 0x000fc8000020d400ULL,
0x00000001b7b73812ULL, 0x000fe200078efcffULL, 0x000000c700e57306ULL, 0x000fe60000209400ULL,
0x00000002b702723eULL, 0x000fca00000010ffULL, 0x000000c700e67306ULL, 0x000ea20000205400ULL,
0x000000c0e300720bULL, 0x002fe40003f9d000ULL, 0x000000e700c07245ULL, 0x000fc8000020d400ULL,
0x00000001c0c05812ULL, 0x000fe200078efcffULL, 0x000000c300e17306ULL, 0x000ff00000209400ULL,
0x000000c300e47306ULL, 0x0002e20000205400ULL, 0x000000e6e500720bULL, 0x004fc40003f7d000ULL,
0x00000008ede67812ULL, 0x000fca00078ef832ULL, 0x00000025007d7306ULL, 0x000fe20000009400ULL,
0x000000c300c37245ULL, 0x002fe2000020d400ULL, 0x00000020e6e87824ULL, 0x000fcc00078e00ffULL,
0x00000025007c7306ULL, 0x000e620000005400ULL, 0x000000e4e100720bULL, 0x008fe20003fbd000ULL,
0x0000010039e17824ULL, 0x000fca00078e00ffULL, 0x00000018ffe17819ULL, 0x000fe200000114e1ULL,
0x0000003800b67306ULL, 0x000fec0000009400ULL, 0x00000001c3c35812ULL, 0x000fe400078efcffULL,
0x0000003800b57306ULL, 0x000fe20000005400ULL, 0x0000007c7d00720bULL, 0x002fc40003f1d000ULL,
0x00000018ff7c7819ULL, 0x000fca000001142bULL, 0x0000003800887306ULL, 0x0003f0000000d400ULL,
0x000000d900de7306ULL, 0x000fe20000209400ULL, 0x0001000039387824ULL, 0x002fca00078e00ffULL,
0x00000018ffe57819ULL, 0x000fe20000011438ULL, 0x0000000449387824ULL, 0x000fe200078e024eULL,
0x000000d900df7306ULL, 0x000fe20000205400ULL, 0x000000024e4e7810ULL, 0x000fe40007ffe0ffULL,
0x0000000238e77824ULL, 0x000fca00078e00ffULL, 0x000000d300da7306ULL, 0x000fe20000209400ULL,
0x00000002e7ed7810ULL, 0x000fe40007ffe0ffULL, 0x000000e732e77211ULL, 0x040fe400078fe0ffULL,
0x000000ed32ed7211ULL, 0x000fc600078fe0ffULL, 0x000000d300dd7306ULL, 0x000e620000205400ULL,
0x00000001e6e77824ULL, 0x040fe400078e02e7ULL, 0x00000001e6387824ULL, 0x040fe400078e02edULL,
0x00000020e6ed7824ULL, 0x000fc600078e00ffULL, 0x0000002500927306ULL, 0x000ea4000000d400ULL,
0xffffffe0ed387812ULL, 0x000fcc00078ee238ULL, 0x0000002c00c47306ULL, 0x000fe20000009400ULL,
0x000000ddda00720bULL, 0x002fce0003fbd000ULL, 0x0000002c00cf7306ULL, 0x000e620000005400ULL,
0x0000000192920812ULL, 0x004fce00078efcffULL, 0x0000003900aa7306ULL, 0x000ff00000009400ULL,
0x0000003900a37306ULL, 0x000fe20000005400ULL, 0x000000cfc400720bULL, 0x002fe20003f1d000ULL,
0x000001003acf7824ULL, 0x000fe200078e00ffULL, 0x000000d000c47245ULL, 0x000fc8000020d400ULL,
0x00000001c4c44812ULL, 0x000fe200078efcffULL, 0x0000003900877306ULL, 0x0003e2000000d400ULL,
0x00000018ffcf7819ULL, 0x000fce00000114cfULL, 0x000000c600cb7306ULL, 0x000fe20000209400ULL,
0x000000c700397245ULL, 0x002fe4000020d400ULL, 0xffffffe0e8c77812ULL, 0x000fe200078ee2e7ULL,
0x000100002fe77824ULL, 0x000fe200078e00ffULL, 0x0000000139393812ULL, 0x000fe400078efcffULL,
0x000000dfde00720bULL, 0x000fe20003f7d000ULL, 0x000000c600cc7306ULL, 0x000e620000205400ULL,
0x000100003adf7824ULL, 0x000fe400078e00ffULL, 0x000001002fde7824ULL, 0x000fc600078e00ffULL,
0x00000018ffdf7819ULL, 0x000fe400000114dfULL, 0x000000d400d67306ULL, 0x000fe20000209400ULL,
0x00000018ffde7819ULL, 0x000fce00000114deULL, 0x000000d400d77306ULL, 0x0005e20000205400ULL,
0x000000cccb00720bULL, 0x002fe20003f9d000ULL, 0x000100003bcc7824ULL, 0x000fca00078e00ffULL,
0x00000018ffcc7819ULL, 0x000fe200000114ccULL, 0x000000cd00d57306ULL, 0x000fe20000209400ULL,
0x000000d400d47245ULL, 0x004fce000020d400ULL, 0x000000cd00d87306ULL, 0x0003f00000205400ULL,
0x00000026008f7306ULL, 0x000ea2000000d400ULL, 0x000000cd00cd7245ULL, 0x002fce000020d400ULL,
0x000000ac00c87306ULL, 0x000ff00000209400ULL, 0x000000ac00c57306ULL, 0x000e620000205400ULL,
0x000000018f8f1812ULL, 0x004fce00078efcffULL, 0x0000002f009b7306ULL, 0x000ff00000009400ULL,
0x0000002f009e7306ULL, 0x000fe20000005400ULL, 0x000000c5c800720bULL, 0x002fe40003f3d000ULL,
0x000000c200c57245ULL, 0x000fca000020d400ULL, 0x0000002f00757306ULL, 0x0003f0000000d400ULL,
0x0000003a00a07306ULL, 0x000fe20000009400ULL, 0x000000d9002f7245ULL, 0x002fc8000020d400ULL,
0x000000012f2f3812ULL, 0x000fe400078efcffULL, 0x000000d7d600720bULL, 0x000fe20003f7d000ULL,
0x0000003a00a57306ULL, 0x000ff00000005400ULL, 0x0000003a00867306ULL, 0x0003e8000000d400ULL,
0x00000001d4d43812ULL, 0x000fc800078efcffULL, 0x000000ce00d17306ULL, 0x000fe20000209400ULL,
0x000000d3003a7245ULL, 0x002fe2000020d400ULL, 0x000001003bd37824ULL, 0x000fc600078e00ffULL,
0x000000013a3a5812ULL, 0x000fe400078efcffULL, 0x000000d8d500720bULL, 0x000fe20003fbd000ULL,
0x000000ce00d27306ULL, 0x0002a20000205400ULL, 0x00000018ffd37819ULL, 0x000fce00000114d3ULL,
0x000000db00e27306ULL, 0x000fe20000209400ULL, 0x000000ce00ce7245ULL, 0x002fc6000020d400ULL,
0x00000001cdcd5812ULL, 0x000fe400078efcffULL, 0x000000b5b600720bULL, 0x000fe40003fbd000ULL,
0x000000db00e97306ULL, 0x0003e20000205400ULL, 0x000000d2d100720bULL, 0x004fe40003f7d000ULL,
0x000000ac00b57245ULL, 0x000fe4000020d400ULL, 0x000000bb00ac7245ULL, 0x000fe4000020d400ULL,
0x00000001b5b51812ULL, 0x000fe200078efcffULL, 0x00000027008e7306ULL, 0x000ea2000000d400ULL,
0x000000db00db7245ULL, 0x002fc4000020d400ULL, 0x0000000188885812ULL, 0x000fc600078efcffULL,
0x00000001cece3812ULL, 0x000fe400078efcffULL, 0x000000c200c97306ULL, 0x000ff00000209400ULL,
0x000000c200ca7306ULL, 0x000e620000205400ULL, 0x000000018e8e6812ULL, 0x004fc800078efcffULL,
0x0000008ecd8e723eULL, 0x000fc600000010ffULL, 0x000000e500e37306ULL, 0x000ff00000209400ULL,
0x000000e500e47306ULL, 0x000ea20000205400ULL, 0x000000cac900720bULL, 0x002fce0003fdd000ULL,
0x0000003b00a87306ULL, 0x000fec0000009400ULL, 0x00000001c5c56812ULL, 0x000fe400078efcffULL,
0x0000003b00ab7306ULL, 0x000fe20000005400ULL, 0x000000e4e300720bULL, 0x004fce0003f3d000ULL,
0x0000003b007f7306ULL, 0x0003f0000000d400ULL, 0x000000dc00e07306ULL, 0x000fe20000209400ULL,
0x000000c6003b7245ULL, 0x002fc8000020d400ULL, 0x000000013b3b4812ULL, 0x000fe400078efcffULL,
0x000000e9e200720bULL, 0x000fe20003f9d000ULL, 0x000000dc00eb7306ULL, 0x0002b00000205400ULL,
0x000000e100e67306ULL, 0x000fe20000209400ULL, 0x000000dc00dc7245ULL, 0x002fc6000020d400ULL,
0x00000001dbdb4812ULL, 0x000fe400078efcffULL, 0x000000a3aa00720bULL, 0x000fe40003f9d000ULL,
0x000000e100ed7306ULL, 0x000e620000205400ULL, 0x000000ebe000720bULL, 0x004fe40003f7d000ULL,
0x000000e500aa7245ULL, 0x000fe4000020d400ULL, 0x000000e100a37245ULL, 0x000fe4000020d400ULL,
0x00000001aaaa1812ULL, 0x000fe200078efcffULL, 0x000000bb00be7306ULL, 0x000fe20000209400ULL,
0x00000088db88723eULL, 0x000fc400000010ffULL, 0x0000000187874812ULL, 0x000fc600078efcffULL,
0x00000001dcdc3812ULL, 0x000fe400078efcffULL, 0x000000bb00c17306ULL, 0x000ea20000205400ULL,
0x000000ede600720bULL, 0x002fe40003fbd000ULL, 0x000000a5a000720bULL, 0x000fe40003f7d000ULL,
0x000000df00a57245ULL, 0x000fe4000020d400ULL, 0x00000018ffa07819ULL, 0x000fe200000114e7ULL,
0x000000df00d97306ULL, 0x000fe20000209400ULL, 0x00000087aaaa723eULL, 0x000fca00000010ffULL,
0x00000001a3a35812ULL, 0x000fe400078efcffULL, 0x000000df00d07306ULL, 0x000e620000205400ULL,
0x000000c1be00720bULL, 0x004fe40003fdd000ULL, 0x0000000186863812ULL, 0x000fca00078efcffULL,
0x000000cf00cb7306ULL, 0x000fec0000209400ULL, 0x00000001acac6812ULL, 0x000fe400078efcffULL,
0x000000cf00c67306ULL, 0x000ea20000205400ULL, 0x000000d0d900720bULL, 0x002fce0003f3d000ULL,
0x000000b900ba7306ULL, 0x000fec0000209400ULL, 0x00000001a5a51812ULL, 0x000fe400078efcffULL,
0x000000b900257306ULL, 0x0002e20000205400ULL, 0x000000c6cb00720bULL, 0x004fe40003f9d000ULL,
0x000000aba800720bULL, 0x000fc40003f3d000ULL, 0x000000cf00a87245ULL, 0x000fe4000020d400ULL,
0x00000086a586723eULL, 0x000fe200000010ffULL, 0x000000cc00c87306ULL, 0x000fe20000209400ULL,
0x000000b900b97245ULL, 0x002fca000020d400ULL, 0x00000001a8a84812ULL, 0x000fe400078efcffULL,
0x000000cc00c97306ULL, 0x000e620000205400ULL, 0x00000025ba00720bULL, 0x008fe20003fbd000ULL,
0x00000010c7257824ULL, 0x000fe200078e00ffULL, 0x000000017f7f1812ULL, 0x000fe200078efcffULL,
0x0001000028ba7824ULL, 0x000fc800078e00ffULL, 0x0000002d00a17306ULL, 0x000fe20000009400ULL,
0x00000018ffba7819ULL, 0x000fca00000114baULL, 0x00000001b9b95812ULL, 0x000fe400078efcffULL,
0x0000002d00a47306ULL, 0x000ea20000005400ULL, 0x000000c9c800720bULL, 0x002fe40003fdd000ULL,
0x000000a8b987723eULL, 0x000fca00000010ffULL, 0x0000002e00a97306ULL, 0x000ff00000009400ULL,
0x0000002e00a27306ULL, 0x000e620000005400ULL, 0x000000a4a100720bULL, 0x004fe40003f9d000ULL,
0x000000cc00a47245ULL, 0x000fc4000020d400ULL, 0x000000d300a17245ULL, 0x000fe4000020d400ULL,
0x00000001a4a46812ULL, 0x000fe200078efcffULL, 0x0000002400277306ULL, 0x000ff00000209400ULL,
0x0000002400b87306ULL, 0x000ea20000205400ULL, 0x000000a2a900720bULL, 0x002fc40003fbd000ULL,
0x0000002400a27245ULL, 0x000fe4000020d400ULL, 0x000000a600a97245ULL, 0x000fc6000020d400ULL,
0x000000a600267306ULL, 0x000ff00000209400ULL, 0x000000a600bd7306ULL, 0x000e620000205400ULL,
0x000000b82700720bULL, 0x004fce0003fdd000ULL, 0x000000d300c27306ULL, 0x000fec0000209400ULL,
0x00000001a2a26812ULL, 0x000fe400078efcffULL, 0x000000d300c17306ULL, 0x000ea20000205400ULL,
0x000000bd2600720bULL, 0x002fe40003f3d000ULL, 0x000000002524783bULL, 0x000e620000000200ULL,
0x0000009e9b00720bULL, 0x000fe20003fdd000ULL, 0x00000100289e7824ULL, 0x000fc400078e00ffULL,
0x000100002b9b7824ULL, 0x000fe200078e00ffULL, 0x000000b000bf7306ULL, 0x000fe40000209400ULL,
0x00000018ff9e7819ULL, 0x000fe4000001149eULL, 0x00000018ff9b7819ULL, 0x000fe4000001149bULL,
0x00000001a9a91812ULL, 0x000fe400078efcffULL, 0x000000b000bc7306ULL, 0x0007220000205400ULL,
0x000000c1c200720bULL, 0x004fc40003f7d000ULL, 0x0000000175756812ULL, 0x000fca00078efcffULL,
0x0000002c00767306ULL, 0x000462000000d400ULL, 0x000000b000b07245ULL, 0x008fca000020d400ULL,
0x00000001a1a13812ULL, 0x000fe400078efcffULL, 0x000000af00ad7306ULL, 0x000fe20000209400ULL,
0x000000bcbf00720bULL, 0x010fe20003f7d000ULL, 0x000001002abc7824ULL, 0x000fe200078e00ffULL,
0x00000018ff2c7819ULL, 0x004fe40000011428ULL, 0x000000a1a2a1723eULL, 0x000fe400000010ffULL,
0x00000018ffbc7819ULL, 0x000fe200000114bcULL, 0x000000af00b27306ULL, 0x0004e20000205400ULL,
0x0000000176760812ULL, 0x002fe200078efcffULL, 0x000000862414723cULL, 0x000fe60000041814ULL,
0x00000076a976723eULL, 0x000fc400000010ffULL, 0x00000001b0b03812ULL, 0x000fe200078efcffULL,
0x0000009d00037306ULL, 0x000fe20000209400ULL, 0x000000af00af7245ULL, 0x004fce000020d400ULL,
0x0000009d00967306ULL, 0x0002a20000205400ULL, 0x000000b2ad00720bULL, 0x008fce0003f1d000ULL,
0x000000b100b37306ULL, 0x000fe20000209400ULL, 0x0000009d009d7245ULL, 0x002fca000020d400ULL,
0x00000001afaf0812ULL, 0x000fe400078efcffULL, 0x000000b100b47306ULL, 0x0002e20000205400ULL,
0x000000960300720bULL, 0x004fe20003f3d000ULL, 0x000001002b967824ULL, 0x000fe200078e00ffULL,
0x000000c03903723eULL, 0x000fc800000010ffULL, 0x00000018ff967819ULL, 0x000fe20000011496ULL,
0x0000008b009a7306ULL, 0x000fe20000209400ULL, 0x000000b100b17245ULL, 0x002fe2000020d400ULL,
0x000000022404723cULL, 0x000b680000041804ULL, 0x000000019d9d1812ULL, 0x000fe400078efcffULL,
0x0000008b00997306ULL, 0x000e620000205400ULL, 0x000000b4b300720bULL, 0x008fe20003f7d000ULL,
0x0000010029b37824ULL, 0x000fe200078e00ffULL, 0x0000008f3a02723eULL, 0x020fe200000010ffULL,
0x000100002ab47824ULL, 0x000fe200078e00ffULL, 0x000000d43b03723eULL, 0x000fc400000010ffULL,
0x000000ceb58f723eULL, 0x000fe200000010ffULL, 0x00000028009c7306ULL, 0x000fe20000009400ULL,
0x00000018ffb37819ULL, 0x000fe400000114b3ULL, 0x00000018ffb47819ULL, 0x000fe200000114b4ULL,
0x000000022420723cULL, 0x000be20000041820ULL, 0x000000ba003b7245ULL, 0x000fe4000020d400ULL,
0x00000001b1b13812ULL, 0x000fe200078efcffULL, 0x00000028009f7306ULL, 0x000fe20000005400ULL,
0x000000999a00720bULL, 0x002fc40003f1d000ULL, 0x0000008b00037245ULL, 0x020fe2000020d400ULL,
0x0000008e2408723cULL, 0x000fe20000041808ULL, 0x000000a000027245ULL, 0x000fe4000020d400ULL,
0x000000bc00b57245ULL, 0x000fe2000020d400ULL, 0x0000002800747306ULL, 0x0003ec000000d400ULL,
0x0000000103030812ULL, 0x000fc400078efcffULL, 0x0000009300977306ULL, 0x000fe20000209400ULL,
0x0001000029287824ULL, 0x002fca00078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011428ULL,
0x0000009300987306ULL, 0x000e620000205400ULL, 0x00000092c328723eULL, 0x000fce00000010ffULL,
0x0000002d00007306ULL, 0x0004f0000000d400ULL, 0x00000029008d7306ULL, 0x000fe20000009400ULL,
0x00000018ff2d7819ULL, 0x004fe40000011429ULL, 0x000000989700720bULL, 0x002fc40003f3d000ULL,
0x0000009300987245ULL, 0x000fc6000020d400ULL, 0x00000029008c7306ULL, 0x000fe20000005400ULL,
0x0000000100004812ULL, 0x008fe400078efcffULL, 0x0000009f9c00720bULL, 0x000fca0003f9d000ULL,
0x0000002900727306ULL, 0x0003e2000000d400ULL, 0x0000000198981812ULL, 0x000fc800078efcffULL,
0x000000b198b1723eULL, 0x000fc600000010ffULL, 0x000000a000b67306ULL, 0x000fe20000209400ULL,
0x0000002fc429723eULL, 0x002fe400000010ffULL, 0x0000000174744812ULL, 0x000fe400078efcffULL,
0x00000077002f7245ULL, 0x000fc6000020d400ULL, 0x000000a000bb7306ULL, 0x0002a20000205400ULL,
0x00000028241c723cULL, 0x000b6e000004181cULL, 0x0000009100a77306ULL, 0x000fe20000209400ULL,
0x0000001038287824ULL, 0x020fe200078e00ffULL, 0x0000007fa4a0723eULL, 0x002fcc00000010ffULL,
0x0000009100ae7306ULL, 0x0002e20000205400ULL, 0x000000bbb600720bULL, 0x004fe20003f1d000ULL,
0x000000a02418723cULL, 0x000fec0000041818ULL, 0x0000009000947306ULL, 0x000fe20000209400ULL,
0x0000009100917245ULL, 0x002fca000020d400ULL, 0x0000000102020812ULL, 0x000fe400078efcffULL,
0x0000009000957306ULL, 0x0002a20000205400ULL, 0x000000aea700720bULL, 0x008fce0003f7d000ULL,
0x0000002a008a7306ULL, 0x000fe20000009400ULL, 0x0000009000907245ULL, 0x002fca000020d400ULL,
0x0000000191913812ULL, 0x000fe400078efcffULL, 0x0000002a00897306ULL, 0x000e620000005400ULL,
0x000000959400720bULL, 0x004fe40003f3d000ULL, 0x0000008c8d00720bULL, 0x000fca0003f7d000ULL,
0x0000002a004f7306ULL, 0x000eac000000d400ULL, 0x0000000190901812ULL, 0x000fe400078efcffULL,
0x0000002b00807306ULL, 0x000fe20000009400ULL, 0x000000898a00720bULL, 0x002fe40003f3d000ULL,
0x000000dcc589723eULL, 0x000fc400000010ffULL, 0x0000000172723812ULL, 0x000fe400078efcffULL,
0x000000900303723eULL, 0x000fe200000010ffULL, 0x0000002b00817306ULL, 0x000fe40000005400ULL,
0x00000088240c723cULL, 0x000fe8000004180cULL, 0x000000014f4f1812ULL, 0x004fe400078efcffULL,
0x0000002b004d7306ULL, 0x0003f0000000d400ULL, 0x0000007700827306ULL, 0x000fe20000209400ULL,
0x000000002828783bULL, 0x002e6e0000000200ULL, 0x0000007700837306ULL, 0x0004f00000205400ULL,
0x000000de00ab7306ULL, 0x000fe20000209400ULL, 0x000000b09d77723eULL, 0x004fc400000010ffULL,
0x00000000afb0723eULL, 0x000fe400000010ffULL, 0x0000002d00007245ULL, 0x000fc6000020d400ULL,
0x000000de00b87306ULL, 0x0005220000205400ULL, 0x000000838200720bULL, 0x008fce0003f1d000ULL,
0x0000002c00847306ULL, 0x000fe20000209400ULL, 0x000000de00de7245ULL, 0x004fca000020d400ULL,
0x000000012f2f0812ULL, 0x000fe400078efcffULL, 0x0000002c00857306ULL, 0x000ea20000205400ULL,
0x000000b8ab00720bULL, 0x010fe20003f9d000ULL, 0x000000762804723cULL, 0x002fe20000041804ULL,
0x000000a3acab723eULL, 0x000fca00000010ffULL, 0x0000002e00507306ULL, 0x000e64000000d400ULL,
0x000000aa2410723cULL, 0x000b680000041810ULL, 0x00000001dede4812ULL, 0x000fe400078efcffULL,
0x000000ba00a67306ULL, 0x000fe20000209400ULL, 0x000000858400720bULL, 0x004fe20003fdd000ULL,
0x000000b0281c723cULL, 0x000f64000004181cULL, 0x000000750224723eULL, 0x020fc400000010ffULL,
0x000000de2f25723eULL, 0x000fe400000010ffULL, 0x0000002c00757245ULL, 0x000fe2000020d400ULL,
0x000000ba00ad7306ULL, 0x000ea20000205400ULL, 0x0000000150505812ULL, 0x002fc600078efcffULL,
0x000000242808723cULL, 0x040f620000041808ULL, 0x000000509102723eULL, 0x000fe400000010ffULL,
0x0000000175756812ULL, 0x000fe200078efcffULL, 0x0000003900937306ULL, 0x000fe80000209400ULL,
0x000000022820723cULL, 0x000b680000041820ULL, 0x00000039003a7306ULL, 0x0002e20000205400ULL,
0x000000ada600720bULL, 0x004fce0003fbd000ULL, 0x0000002d002e7306ULL, 0x000fe20000209400ULL,
0x0000003900397245ULL, 0x002fca000020d400ULL, 0x000000013b3b5812ULL, 0x000fe400078efcffULL,
0x0000002d00797306ULL, 0x000e620000205400ULL, 0x0000003a9300720bULL, 0x008fe40003f9d000ULL,
0x000000743b74723eULL, 0x000fca00000010ffULL, 0x000000b3008c7306ULL, 0x000fec0000209400ULL,
0x0000000139394812ULL, 0x000fe400078efcffULL, 0x000000b3008b7306ULL, 0x0004e20000205400ULL,
0x000000792e00720bULL, 0x002fe40003f1d000ULL, 0x000000723902723eULL, 0x020fca00000010ffULL,
0x0000009e00b27306ULL, 0x000fe20000209400ULL, 0x000000b300b37245ULL, 0x004fca000020d400ULL,
0x0000000100000812ULL, 0x000fe400078efcffULL, 0x0000009e00977306ULL, 0x0002a20000205400ULL,
0x0000008b8c00720bULL, 0x008fce0003fdd000ULL, 0x000000b400387306ULL, 0x000fe20000209400ULL,
0x0000009e009e7245ULL, 0x002fca000020d400ULL, 0x00000001b3b36812ULL, 0x000fe400078efcffULL,
0x000000b4008d7306ULL, 0x0002e20000205400ULL, 0x00000097b200720bULL, 0x004fe40003fbd000ULL,
0x000000b30003723eULL, 0x000fe400000010ffULL, 0x0000009b00007245ULL, 0x000fc6000020d400ULL,
0x000000bc00887306ULL, 0x000fe20000209400ULL, 0x000000b400b47245ULL, 0x002fe2000020d400ULL,
0x000000022810723cULL, 0x000b680000041810ULL, 0x000000019e9e5812ULL, 0x000fe400078efcffULL,
0x000000bc007f7306ULL, 0x000e620000205400ULL, 0x0000008d3800720bULL, 0x008fe40003f7d000ULL,
0x000000818000720bULL, 0x000fc40003fbd000ULL, 0x0000009600037245ULL, 0x020fe4000020d400ULL,
0x0000009e7575723eULL, 0x000fe200000010ffULL, 0x00000078007a7306ULL, 0x000fec0000209400ULL,
0x00000001b4b43812ULL, 0x000fe200078efcffULL, 0x00000074280c723cULL, 0x000b62000004180cULL,
0x00000078007b7306ULL, 0x0004e20000205400ULL, 0x0000007f8800720bULL, 0x002fc40003f1d000ULL,
0x000000014d4d5812ULL, 0x000fe400078efcffULL, 0x0000004fb4b4723eULL, 0x000fc600000010ffULL,
0x0000007c007d7306ULL, 0x000fe20000209400ULL, 0x0000007800787245ULL, 0x004fca000020d400ULL,
0x00000001b5b50812ULL, 0x000fe400078efcffULL, 0x0000007c007e7306ULL, 0x0002a20000205400ULL,
0x0000007b7a00720bULL, 0x008fe40003f9d000ULL, 0x000000044e00780cULL, 0x000fca0003f05270ULL,
0x0000009b003a7306ULL, 0x000fe20000209400ULL, 0x0000007c007c7245ULL, 0x002fca000020d400ULL,
0x0000000178784812ULL, 0x000fe400078efcffULL, 0x0000009b00277306ULL, 0x000e620000205400ULL,
0x0000007e7d00720bULL, 0x004fe40003fdd000ULL, 0x000000b578b5723eULL, 0x000fca00000010ffULL,
0x0000009600267306ULL, 0x000fe40000209400ULL, 0x000000b42814723cULL, 0x000b680000041814ULL,
0x000000017c7c6812ULL, 0x000fe400078efcffULL, 0x0000009600257306ULL, 0x000ea20000205400ULL,
0x000000273a00720bULL, 0x002fda0003f7d000ULL, 0x0000000100003812ULL, 0x000fe400078efcffULL,
0x000000252600720bULL, 0x004fe40003f3d000ULL, 0x0000004d0002723eULL, 0x000fd600000010ffULL,
0x0000000103031812ULL, 0x000fc800078efcffULL, 0x000000037c03723eULL, 0x000fce00000010ffULL,
0x000000022818723cULL, 0x000b620000041818ULL, 0x0000001000008944ULL, 0x000fe20003c00000ULL,
0xffffe0c000007947ULL, 0x000fcc000383ffffULL, 0x000000045200780cULL, 0x000fe20003f06070ULL,
0x000000ffff497224ULL, 0x000fe400078e0052ULL, 0x000000ffff487224ULL, 0x000fd400078e0042ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffcb1000007947ULL, 0x000fea000383ffffULL,
0x00000002ff007819ULL, 0x000fc80000011632ULL, 0x000000450000720cULL, 0x040fe40003f06070ULL,
0x0000000145457810ULL, 0x000fe40007ffe0ffULL, 0x0000000800027810ULL, 0x060fe40007ffe0ffULL,
0x000000450000720cULL, 0x000fe40004706470ULL, 0x000000470200720cULL, 0x000fe40003f26070ULL,
0x000000403500720cULL, 0x000fc40000703070ULL, 0x000000450200720cULL, 0x000fc80000f21070ULL,
0x000000403500720cULL, 0x000fc80000f24470ULL, 0x000000661b667208ULL, 0x000fe40000800000ULL,
0x000000691a697208ULL, 0x000fe20000800000ULL, 0x000000ffff538224ULL, 0x000fe200078e0019ULL,
0x0000006817687208ULL, 0x000fe20000800000ULL, 0x000000ffff548224ULL, 0x000fe200078e0018ULL,
0x0000006b166b7208ULL, 0x000fe20000800000ULL, 0x000000ffff558224ULL, 0x000fe200078e0015ULL,
0x0000006a136a7208ULL, 0x000fe20000800000ULL, 0x000000ffff568224ULL, 0x000fe200078e0014ULL,
0x0000006d126d7208ULL, 0x000fe20000800000ULL, 0x000000ffff578224ULL, 0x000fe200078e0011ULL,
0x0000006c0f6c7208ULL, 0x000fe20000800000ULL, 0x000000ffff588224ULL, 0x000fe200078e0010ULL,
0x0000006f0e6f7208ULL, 0x000fe20000800000ULL, 0x000000ffff598224ULL, 0x000fe200078e000dULL,
0x0000006e0b6e7208ULL, 0x000fe20000800000ULL, 0x000000ffff5a8224ULL, 0x000fe200078e000cULL,
0x000000710a717208ULL, 0x000fe20000800000ULL, 0x000000ffff5b8224ULL, 0x000fe200078e0009ULL,
0x0000007023707208ULL, 0x000fe20000800000ULL, 0x000000ffff5c8224ULL, 0x000fe200078e0008ULL,
0x0000007322737208ULL, 0x000fe20000800000ULL, 0x000000ffff5d8224ULL, 0x000fe200078e0021ULL,
0x0000004a1f4a7208ULL, 0x000fe20000800000ULL, 0x000000ffff5e8224ULL, 0x000fe200078e0020ULL,
0x0000004b1e4b7208ULL, 0x000fe20000800000ULL, 0x000000ffff5f8224ULL, 0x000fe200078e001dULL,
0x0000004c074c7208ULL, 0x000fe20000800000ULL, 0x000000ffff608224ULL, 0x000fe200078e001cULL,
0x0000005106517208ULL, 0x000fe20000800000ULL, 0x000000ffff678224ULL, 0x000fc400078e0005ULL,
0x000000ffff628224ULL, 0x000fe200078e0004ULL, 0x000000464500720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffc72000007947ULL, 0x000fea000383ffffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000003d047f8cULL, 0x000e62000c80043fULL,
0x0000003c620b7220ULL, 0x080fe20000410000ULL, 0x0000003c670a7220ULL, 0x080fe20000410000ULL,
0x0000003c600c7220ULL, 0x080fe20000410000ULL, 0x0000003c5f0d7220ULL, 0x080fe20000410000ULL,
0x0000003c5e0e7220ULL, 0x080fe20000410000ULL, 0x0000003c5d0f7220ULL, 0x080fe20000410000ULL,
0x0000003c5c107220ULL, 0x080fe20000410000ULL, 0x0000003c5b117220ULL, 0x080fe20000410000ULL,
0x0000003c5a127220ULL, 0x080fe20000410000ULL, 0x0000003c59137220ULL, 0x080fe20000410000ULL,
0x0000003c58147220ULL, 0x080fe20000410000ULL, 0x0000003c57157220ULL, 0x080fe20000410000ULL,
0x0000003c56167220ULL, 0x080fe20000410000ULL, 0x0000003c55177220ULL, 0x080fe20000410000ULL,
0x0000003c54197220ULL, 0x080fe20000410000ULL, 0x0000003c531a7220ULL, 0x080fe20000410000ULL,
0x0000003c511c7220ULL, 0x080fe20000410000ULL, 0x0000003c4c1b7220ULL, 0x080fe20000410000ULL,
0x0000003c4b1d7220ULL, 0x080fe20000410000ULL, 0x0000003c4a1e7220ULL, 0x080fe20000410000ULL,
0x0000003c731f7220ULL, 0x080fe20000410000ULL, 0x0000003c70207220ULL, 0x080fe20000410000ULL,
0x0000003c71217220ULL, 0x080fe20000410000ULL, 0x000000ffff087224ULL, 0x002fe200078e0005ULL,
0x0000003c6e227220ULL, 0x080fe20000410000ULL, 0x0000003c6f237220ULL, 0x080fe20000410000ULL,
0x0000003c6c247220ULL, 0x080fe20000410000ULL, 0x0000003c6d257220ULL, 0x080fe20000410000ULL,
0x0000003c6a267220ULL, 0x080fe20000410000ULL, 0x0000003c6b277220ULL, 0x080fe20000410000ULL,
0x0000003c68287220ULL, 0x080fe20000410000ULL, 0x0000003c69297220ULL, 0x080fe20000410000ULL,
0x0000003c662a7220ULL, 0x000fc20000410000ULL, 0x0000000000047805ULL, 0x000fcc0000015200ULL,
0x000004003d037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fc40007804808ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff097224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604067210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000600780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400600780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011407ULL,
0x0000000603037211ULL, 0x000fca00078110ffULL, 0x000000ffff067224ULL, 0x000fca00000e0607ULL,
0x0000000203037819ULL, 0x000fc80000001206ULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000109097810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004003d037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804808ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000432187824ULL, 0x000fe200078e00ffULL, 0x0000003e4000720cULL, 0x000fc80003f05270ULL,
0xfffffff018047812ULL, 0x000fca00078ec0ffULL, 0x0000008065037824ULL, 0x000fca00078e0204ULL,
0x0104000003047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000232087824ULL, 0x000fe400078e00ffULL, 0x0000000161447824ULL, 0x000fc600078e0a44ULL,
0x0000000608097812ULL, 0x000fc800078ec0ffULL, 0x00000001092b7812ULL, 0x040fe400078efcffULL,
0x00000008092d7812ULL, 0x000fe400078efcffULL, 0x000000442b00720cULL, 0x080fe40003f26070ULL,
0x00000010092b7812ULL, 0x000fe400078efcffULL, 0x000000442d00720cULL, 0x080fe40003f06070ULL,
0x000000442b00720cULL, 0x000fc40003fc6070ULL, 0x00000011092d7812ULL, 0x040fe400078efcffULL,
0x00000018092b7812ULL, 0x040fe400078efcffULL, 0x000000440900720cULL, 0x080fe40003f46070ULL,
0x000000442d00720cULL, 0x080fe40003fa6070ULL, 0x000000442b00720cULL, 0x000fe40003f66070ULL,
0x00000009092f7812ULL, 0x000fc400078efcffULL, 0x00000019092d7812ULL, 0x040fe400078efcffULL,
0x00000020092b7812ULL, 0x000fe400078efcffULL, 0xff8000001c1c7808ULL, 0x000fe40005000000ULL,
0xff8000000b0b7808ULL, 0x000fe40005000000ULL, 0xff8000001b1b7808ULL, 0x000fe40004800000ULL,
0xff8000000a0a7808ULL, 0x000fc40004800000ULL, 0x000000442f00720cULL, 0x080fe40003f86070ULL,
0x000000442d00720cULL, 0x080fe40003f46070ULL, 0x000000442b00720cULL, 0x000fe40003f26070ULL,
0x00000021092d7812ULL, 0x040fe400078efcffULL, 0x00000028092b7812ULL, 0x000fe400078efcffULL,
0xff8000001d1d7808ULL, 0x000fc40004000000ULL, 0xff8000000c0c7808ULL, 0x000fe40004000000ULL,
0xff8000001e1e7808ULL, 0x000fe40006000000ULL, 0xff8000000d0d7808ULL, 0x000fe40006000000ULL,
0x000000442d00720cULL, 0x080fe40003f06070ULL, 0x000000442b00720cULL, 0x000fe40003f86070ULL,
0x00000029092d7812ULL, 0x000fc400078efcffULL, 0x00000030092b7812ULL, 0x000fe400078efcffULL,
0xff8000001f1f7808ULL, 0x000fe40007000000ULL, 0xff8000000e0e7808ULL, 0x000fe40007000000ULL,
0xff80000020207808ULL, 0x000fe40006800000ULL, 0xff8000000f0f7808ULL, 0x000fe40006800000ULL,
0x000000442d00720cULL, 0x000fc40003fc6070ULL, 0x000000442b00720cULL, 0x000fe40003fa6070ULL,
0x00000031092d7812ULL, 0x040fe400078efcffULL, 0x00000038092b7812ULL, 0x040fe400078efcffULL,
0x0000003909097812ULL, 0x000fe400078efcffULL, 0xff80000021217808ULL, 0x000fe40005800000ULL,
0xff80000010107808ULL, 0x000fc40005800000ULL, 0xff80000022227808ULL, 0x000fe40005000000ULL,
0xff80000011117808ULL, 0x000fe40005000000ULL, 0xff80000023237808ULL, 0x000fe40004800000ULL,
0xff80000012127808ULL, 0x000fe40004800000ULL, 0x000000442d00720cULL, 0x080fe40003f66070ULL,
0x000000442b00720cULL, 0x000fc40003f46070ULL, 0x000000440900720cULL, 0x000fe40003f26070ULL,
0xff80000024247808ULL, 0x000fe40004000000ULL, 0xff80000013137808ULL, 0x000fe40004000000ULL,
0xff80000025257808ULL, 0x000fe40006000000ULL, 0xff80000014147808ULL, 0x000fe40006000000ULL,
0xff80000026267808ULL, 0x000fc40007000000ULL, 0xff80000015157808ULL, 0x000fe40007000000ULL,
0xff80000027277808ULL, 0x000fe40006800000ULL, 0xff80000016167808ULL, 0x000fe40006800000ULL,
0xff80000028287808ULL, 0x000fe40005800000ULL, 0xff80000017177808ULL, 0x000fe40005800000ULL,
0xff80000029297808ULL, 0x000fc40005000000ULL, 0xff80000019197808ULL, 0x000fe40005000000ULL,
0xff8000002a2a7808ULL, 0x000fe40004800000ULL, 0xff8000001a1a7808ULL, 0x000fc40004800000ULL,
0x0000000b0400720bULL, 0x004fe20003f1e000ULL, 0x0000001fff397424ULL, 0x000fe200078e00ffULL,
0x0000001c0500720bULL, 0x000fe20003f3e000ULL, 0xffffffffff447424ULL, 0x000fe200078e00ffULL,
0x000000040b097208ULL, 0x000fe40004000000ULL, 0x000000051c047208ULL, 0x000fc40004800000ULL,
0x0000000a0900720bULL, 0x000fe40003f1e000ULL, 0x0000001b0400720bULL, 0x000fe40003f3e000ULL,
0x000000090a097208ULL, 0x000fe40004000000ULL, 0x000000041b047208ULL, 0x000fe40004800000ULL,
0x0000000c0900720bULL, 0x000fe40003f1e000ULL, 0x0000001d0400720bULL, 0x000fc40003f3e000ULL,
0x000000090c087208ULL, 0x000fe40004000000ULL, 0x000000041d057208ULL, 0x000fe40004800000ULL,
0x0000000d0800720bULL, 0x000fe40003f1e000ULL, 0x0000001e0500720bULL, 0x000fe40003f3e000ULL,
0x000000080d097208ULL, 0x000fe40004000000ULL, 0x000000051e047208ULL, 0x000fc40004800000ULL,
0x0000000e0900720bULL, 0x000fe40003f1e000ULL, 0x0000001f0400720bULL, 0x000fe40003f3e000ULL,
0x000000090e087208ULL, 0x000fe40004000000ULL, 0x000000041f057208ULL, 0x000fe40004800000ULL,
0x0000000f0800720bULL, 0x000fe40003f1e000ULL, 0x000000200500720bULL, 0x000fc40003f3e000ULL,
0x000000080f097208ULL, 0x000fe40004000000ULL, 0x0000000520047208ULL, 0x000fe40004800000ULL,
0x000000100900720bULL, 0x000fe40003f1e000ULL, 0x000000210400720bULL, 0x000fe40003f3e000ULL,
0x0000000910087208ULL, 0x000fe40004000000ULL, 0x0000000421057208ULL, 0x000fc40004800000ULL,
0x000000110800720bULL, 0x000fe40003f1e000ULL, 0x000000220500720bULL, 0x000fe40003f3e000ULL,
0x0000000811097208ULL, 0x000fe40004000000ULL, 0x0000000522047208ULL, 0x000fe40004800000ULL,
0x000000120900720bULL, 0x000fe40003f1e000ULL, 0x000000230400720bULL, 0x000fc40003f3e000ULL,
0x0000000912087208ULL, 0x000fe40004000000ULL, 0x0000000423057208ULL, 0x000fe40004800000ULL,
0x000000130800720bULL, 0x000fe40003f1e000ULL, 0x000000240500720bULL, 0x000fe40003f3e000ULL,
0x0000000813097208ULL, 0x000fe40004000000ULL, 0x0000000524047208ULL, 0x000fc40004800000ULL,
0x000000140900720bULL, 0x000fe40003f1e000ULL, 0x000000250400720bULL, 0x000fe40003f3e000ULL,
0x0000000914087208ULL, 0x000fe40004000000ULL, 0x0000000425057208ULL, 0x000fe40004800000ULL,
0x000000150800720bULL, 0x000fe40003f1e000ULL, 0x000000260500720bULL, 0x000fc40003f3e000ULL,
0x0000000815097208ULL, 0x000fe40004000000ULL, 0x0000000526047208ULL, 0x000fe40004800000ULL,
0x000000160900720bULL, 0x000fe40003f1e000ULL, 0x000000270400720bULL, 0x000fe40003f3e000ULL,
0x0000000916087208ULL, 0x000fe40004000000ULL, 0x0000000427057208ULL, 0x000fc40004800000ULL,
0x000000170800720bULL, 0x000fe40003f1e000ULL, 0x000000280500720bULL, 0x000fe40003f3e000ULL,
0x0000000817087208ULL, 0x000fe40004000000ULL, 0x0000000528047208ULL, 0x000fe40004800000ULL,
0x000000190800720bULL, 0x000fe40003f1e000ULL, 0x000000290400720bULL, 0x000fc40003f3e000ULL,
0x0000000819057208ULL, 0x000fe40004000000ULL, 0x0000000429097208ULL, 0x000fe40004800000ULL,
0x0000001a0500720bULL, 0x000fe40003f1e000ULL, 0x0000002a0900720bULL, 0x000fe40003f3e000ULL,
0x000000051a2d7208ULL, 0x000fe40004000000ULL, 0x000000092a2f7208ULL, 0x000fe20004800000ULL,
0x000019427f007947ULL, 0x000fec000b800000ULL, 0x0c401f002d047f89ULL, 0x0004e400000e0000ULL,
0x000000042d00720bULL, 0x008fc80003f1e000ULL, 0x0000002d04387208ULL, 0x000fe20004000000ULL,
0x000019527f007947ULL, 0x000fea000b800000ULL, 0x0c401f002f047f89ULL, 0x000ee800000e0000ULL,
0x0c401f0006057f89ULL, 0x000f2800000e0000ULL, 0x0c401f00072c7f89ULL, 0x000e6200000e0000ULL,
0x000000042f00720bULL, 0x008fc40003f1e000ULL, 0x000000050600720bULL, 0x010fe40003f3e000ULL,
0x0000002f04087208ULL, 0x000fe40004000000ULL, 0x0000000605097208ULL, 0x000fe20004800000ULL,
0x0c201f0038047f89ULL, 0x000ee200000e0000ULL, 0x0000002c0700720bULL, 0x002fc60003f1e000ULL,
0x0c201f0008057f89ULL, 0x000e6200000e0000ULL, 0x000000072c2c7208ULL, 0x000fc60004000000ULL,
0x0c201f00092e7f89ULL, 0x000f2800000e0000ULL, 0x0c201f002c2b7f89ULL, 0x0004a200000e0000ULL,
0x000000043800720bULL, 0x008fe40003f1e000ULL, 0x000000050800720bULL, 0x002fe40003f3e000ULL,
0x0000003804047208ULL, 0x000fe40004000000ULL, 0x0000002e0900720bULL, 0x010fc40003f5e000ULL,
0x0000000805057208ULL, 0x000fe40004800000ULL, 0x000000092e067208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b04077820ULL, 0x004fe20000410000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0x0000a000652d7811ULL, 0x002fe400078e58ffULL, 0x3fb8aa3b10107823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0b0b7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0a0a7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0c0c7823ULL, 0x100fe20000010807ULL, 0x00000010005c7308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b0d0d7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b11117823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b12127823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b13137823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b14147823ULL, 0x100fe20000010807ULL, 0x0000000b00627308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b05107820ULL, 0x002fe20000410000ULL, 0x3fb8aa3b15157823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b16167823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b17177823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe20000010810ULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe20000010810ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe20000010810ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe20000010810ULL,
0x0000000a00677308ULL, 0x000e620000000800ULL, 0x3fb8aa3b19197823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b1a077823ULL, 0x000fe20000010807ULL, 0x00000004ff1a7e24ULL, 0x000fe2000f8e00ffULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe20000010810ULL, 0x3fb8aa3b20207823ULL, 0x100fe20000010810ULL,
0x3fb8aa3b21217823ULL, 0x100fe20000010810ULL, 0x3fb8aa3b22227823ULL, 0x100fe20000010810ULL,
0x0000000c00607308ULL, 0x0003e20000000800ULL, 0x3f8000001a1a783eULL, 0x000fe200000010ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010810ULL,
0x3fb8aa3b24247823ULL, 0x100fe20000010810ULL, 0x3fb8aa3b25257823ULL, 0x100fe20000010810ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010810ULL, 0x3fb8aa3b27277823ULL, 0x100fe20000010810ULL,
0x0000000d005f7308ULL, 0x000fe20000000800ULL, 0x00000062670c723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b28287823ULL, 0x100fe20000010810ULL, 0x3fb8aa3b29297823ULL, 0x100fe20000010810ULL,
0x3fb8aa3b2a2a7823ULL, 0x000fe20000010810ULL, 0x000000ffff2e7224ULL, 0x100fe200078e001aULL,
0x0000000332ff7812ULL, 0x000fe2000780c0ffULL, 0x000000ffff2f7224ULL, 0x000fe200078e001aULL,
0x0000001c00517308ULL, 0x0003e20000000800ULL, 0x0000002b2c00720bULL, 0x000fce0003f3e000ULL,
0x0000001b004c7308ULL, 0x0004e20000000800ULL, 0x00000008001c7824ULL, 0x002fce00078e00ffULL,
0x0000001d004b7308ULL, 0x0003e20000000800ULL, 0x000000ffff1b7224ULL, 0x004fce00078e001aULL,
0x0000001e004a7308ULL, 0x0005220000000800ULL, 0x000000514c0d723eULL, 0x008fe400000010ffULL,
0x00000004001d7810ULL, 0x002fca0007ffe0ffULL, 0x0000000e005e7308ULL, 0x0003e20000000800ULL,
0x00000008001e7824ULL, 0x004fca00078e00ffULL, 0xfffffff81e1e7812ULL, 0x000fe400078ee21dULL,
0x0000000f005d7308ULL, 0x0008a20000000800ULL, 0x000000605f0e723eULL, 0x002fe400000010ffULL,
0x00000006001d7810ULL, 0x000fca0007ffe0ffULL, 0x0000001400587308ULL, 0x000fe20000000800ULL,
0x0000004b4a0f723eULL, 0x010fce00000010ffULL, 0x0000001500577308ULL, 0x000fe20000000800ULL,
0x0000005e5d08723eULL, 0x004fce00000010ffULL, 0x0000001600567308ULL, 0x000ff00000000800ULL,
0x0000001700557308ULL, 0x0003f00000000800ULL, 0x00000011005b7308ULL, 0x0004e20000000800ULL,
0x0000001a0c14723cULL, 0x002f6e00000418ffULL, 0x0000001f00737308ULL, 0x0003e20000000800ULL,
0x0000000200117810ULL, 0x004fce0007ffe0ffULL, 0x0000002000707308ULL, 0x0005220000000800ULL,
0x0000005c5b0a723eULL, 0x008fe400000010ffULL, 0x00000005001f7810ULL, 0x002fca0007ffe0ffULL,
0x0000002100717308ULL, 0x0003e20000000800ULL, 0x0000000800207824ULL, 0x004fca00078e00ffULL,
0xfffffff820207812ULL, 0x000fe400078ee21fULL, 0x00000022006e7308ULL, 0x0004e20000000800ULL,
0x000000737009723eULL, 0x010fe200000010ffULL, 0x0000000802217824ULL, 0x002fe200078e00ffULL,
0xffffffff001f7810ULL, 0x000fc80007ffe0ffULL, 0xfffffff821027812ULL, 0x000fe200078ee202ULL,
0x00000012005a7308ULL, 0x0003e20000000800ULL, 0x000000ffff227224ULL, 0x004fe200078e001aULL,
0x000000716e0b723eULL, 0x008fcc00000010ffULL, 0x0000001300597308ULL, 0x000ea20000000800ULL,
0x0000000800127824ULL, 0x002fe200078e00ffULL, 0x0000001a0814723cULL, 0x020b6c0000041814ULL,
0x00000023006f7308ULL, 0x0003e20000000800ULL, 0xfffffff81c1b7812ULL, 0x020fce00078ee211ULL,
0x00000024006c7308ULL, 0x0007220000000800ULL, 0x000000ffff237224ULL, 0x002fe200078e001aULL,
0x0000005a5910723eULL, 0x004fcc00000010ffULL, 0x00000025006d7308ULL, 0x0003e20000000800ULL,
0x0000000800247824ULL, 0x008fca00078e00ffULL, 0xfffffff824247812ULL, 0x000fe200078ee21fULL,
0x000000101b1f7824ULL, 0x100fe200078e022dULL, 0x00000026006a7308ULL, 0x000ea20000000800ULL,
0x0000006f6c11723eULL, 0x010fe200000010ffULL, 0x0000001020257824ULL, 0x002fcc00078e022dULL,
0x0000000700537308ULL, 0x0003f00000000800ULL, 0x0000001900547308ULL, 0x0007220000000800ULL,
0x0000000100077810ULL, 0x002fe40007ffe0ffULL, 0x0000006d6a13723eULL, 0x004fca00000010ffULL,
0x00000027006b7308ULL, 0x000fe20000000800ULL, 0xfffffff812197812ULL, 0x008fe400078ee207ULL,
0x000000585712723eULL, 0x000fe400000010ffULL, 0x0000000300077810ULL, 0x000fc60007ffe0ffULL,
0x0000002800687308ULL, 0x000e620000000800ULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee207ULL,
0x000000221014723cULL, 0x000b620000041814ULL, 0x0000000800077824ULL, 0x000fe200078e00ffULL,
0x00000054531a723eULL, 0x010fe400000010ffULL, 0x000000101c217824ULL, 0x100fe400078e022dULL,
0x0000002900697308ULL, 0x0005e20000000800ULL, 0x0000000800227824ULL, 0x020fe200078e00ffULL,
0xfffffff807077812ULL, 0x000fe200078ee200ULL, 0x000000101e237824ULL, 0x000fe200078e022dULL,
0x0000000c18007812ULL, 0x000fc400078ec0ffULL, 0xfffffff822227812ULL, 0x000fe200078ee21dULL,
0x00000010191d7824ULL, 0x100fe200078e022dULL, 0x0000002a00667308ULL, 0x000ee20000000800ULL,
0x000000565518723eULL, 0x000fe200000010ffULL, 0x0000001007077824ULL, 0x000fe200078e022dULL,
0x0000006b6819723eULL, 0x002fe200000010ffULL, 0x00000001001d7824ULL, 0x000fe400078e021dULL,
0x0000000107077824ULL, 0x000fe400078e0200ULL, 0x0000001022277824ULL, 0x000fc400078e022dULL,
0x00000001001f7824ULL, 0x000fe200078e021fULL, 0x0000000c07007388ULL, 0x0003e20000000800ULL,
0x0000001024297824ULL, 0x004fe400078e022dULL, 0x0000000100217824ULL, 0x000fe200078e0221ULL,
0x0000000e1d007388ULL, 0x0005e20000000800ULL, 0x00000069661b723eULL, 0x008fe200000010ffULL,
0x00000010022d7824ULL, 0x000fe400078e022dULL, 0x0000000100237824ULL, 0x040fe200078e0223ULL,
0x000000081f007388ULL, 0x0005e20000000800ULL, 0x0000000100257824ULL, 0x040fe200078e0225ULL,
0x0000002c2b077208ULL, 0x002fe20004800000ULL, 0x0000002e1814723cULL, 0x000f620000041814ULL,
0x0000000100277824ULL, 0x040fe200078e0227ULL, 0x0000000a21007388ULL, 0x0005e20000000800ULL,
0x0000000100297824ULL, 0x000fc400078e0229ULL, 0x0000000100007824ULL, 0x000fe200078e022dULL,
0x0000001023007388ULL, 0x0005e80000000800ULL, 0x0000001225007388ULL, 0x0005e80000000800ULL,
0x0000001827007388ULL, 0x0005e80000000800ULL, 0x0000001a29007388ULL, 0x0005e80000000800ULL,
0x0000000d00007388ULL, 0x0005e40000000800ULL, 0x000000ffff157224ULL, 0x020fc400078e0016ULL,
0x0004000f1d007388ULL, 0x0005e80000000800ULL, 0x000400091f007388ULL, 0x0005e80000000800ULL,
0x0004000b21007388ULL, 0x0005e80000000800ULL, 0x0004001123007388ULL, 0x0005e80000000800ULL,
0x0004001325007388ULL, 0x0005e80000000800ULL, 0x0004001927007388ULL, 0x0005e80000000800ULL,
0x0004001b29007388ULL, 0x0005e80000000800ULL, 0x0100000403008388ULL, 0x0005e80000000c00ULL,
0x0102001403008388ULL, 0x0005e20000000a00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000003fff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000008003fff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000010003fff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000140407810ULL, 0x000fe20007ffe0ffULL, 0x000018003fff7f8cULL, 0x0003e6000c80043fULL,
0x000000374000720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffac1000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff397807ULL, 0x008fe40004000000ULL, 0x0002685000387802ULL, 0x000fc40000000f00ULL,
0x000010a000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff047224ULL, 0x000fe200078e003dULL,
0xfffdcb7000007947ULL, 0x000fea000383ffffULL, 0x00000001ff397807ULL, 0x000fe40004800000ULL,
0x000268a000387802ULL, 0x000fc40000000f00ULL, 0x0000105000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff047224ULL, 0x000fe200078e003dULL, 0xfffdcbb000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3f7224ULL, 0x000fe200078e0000ULL, 0x0002690000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff3e7224ULL, 0x000fc400078e000fULL, 0x00000fb000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff007224ULL, 0x004fe200078e003eULL, 0xfffdcc5000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3e7224ULL, 0x000fe200078e000fULL, 0x0002696000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff3f7224ULL, 0x002fc400078e0000ULL, 0x00000f5000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff007224ULL, 0x004fe200078e003eULL, 0xfffdcd5000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3e7224ULL, 0x000fe200078e0000ULL, 0x000269c000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff3f7224ULL, 0x000fc400078e0003ULL, 0x00000ef000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e003eULL, 0xfffdcf2000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3f7224ULL, 0x002fe200078e0006ULL, 0x00026a2000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff3e7224ULL, 0x000fc400078e0000ULL, 0x00000e9000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e003eULL, 0xfffdcef000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3e7224ULL, 0x000fe200078e003aULL, 0x00026a8000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff3f7224ULL, 0x000fc400078e0069ULL, 0x00000e3000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e003eULL, 0xfffe054000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3e7224ULL, 0x000fe200078e003aULL, 0x00026ae000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff3f7224ULL, 0x002fc400078e0068ULL, 0x00000dd000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e003eULL, 0xfffe050000007947ULL, 0x000fea000383ffffULL,
0x00000001ff397807ULL, 0x008fe40004000000ULL, 0x00026b3000387802ULL, 0x000fc40000000f00ULL,
0x00000dc000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff097224ULL, 0x000fe200078e003dULL,
0xfffe3f6000007947ULL, 0x000fea000383ffffULL, 0x00000001ff397807ULL, 0x000fe40004800000ULL,
0x00026b8000387802ULL, 0x000fc40000000f00ULL, 0x00000d7000007944ULL, 0x002fea0003c00000ULL,
0xfffe3fb000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3e7224ULL, 0x000fe200078e0041ULL,
0x00026bd000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff3f7224ULL, 0x000fc400078e0069ULL,
0x00000ce000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e003eULL,
0xfffe404000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3e7224ULL, 0x000fe200078e0041ULL,
0x00026c3000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff3f7224ULL, 0x002fc400078e0068ULL,
0x00000c8000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e003eULL,
0xfffe413000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3e7224ULL, 0x000fe200078e003aULL,
0x00026c9000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff3f7224ULL, 0x000fc400078e0069ULL,
0x00000c2000007944ULL, 0x00afea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e003eULL,
0xfffe42f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3e7224ULL, 0x000fe200078e003aULL,
0x00026cf000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff3f7224ULL, 0x002fc400078e0068ULL,
0x00000bc000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e003eULL,
0xfffe42b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3e7224ULL, 0x000fe200078e003aULL,
0x00026d5000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff3f7224ULL, 0x000fc400078e0069ULL,
0x00000b6000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e003eULL,
0xfffe771000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3e7224ULL, 0x000fe200078e003aULL,
0x00026db000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff3f7224ULL, 0x002fc400078e0068ULL,
0x00000b0000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e003eULL,
0xfffe76d000007947ULL, 0x000fea000383ffffULL, 0x00000001ff397807ULL, 0x008fe40004000000ULL,
0x00026e0000387802ULL, 0x000fc40000000f00ULL, 0x00000af000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff097224ULL, 0x000fe200078e003dULL, 0xfffeb01000007947ULL, 0x000fea000383ffffULL,
0x00000001ff397807ULL, 0x000fe40004800000ULL, 0x00026e5000387802ULL, 0x000fc40000000f00ULL,
0x00000aa000007944ULL, 0x002fea0003c00000ULL, 0xfffeb06000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3e7224ULL, 0x000fe200078e0041ULL, 0x00026ea000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff3f7224ULL, 0x000fc400078e0069ULL, 0x00000a1000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e003eULL, 0xfffeb0f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3e7224ULL, 0x000fe200078e0041ULL, 0x00026f0000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff3f7224ULL, 0x002fc400078e0068ULL, 0x000009b000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e003eULL, 0xfffeb1e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3e7224ULL, 0x000fe200078e003aULL, 0x00026f6000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff3f7224ULL, 0x000fc400078e0069ULL, 0x0000095000007944ULL, 0x00afea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e003eULL, 0xfffeb3a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3e7224ULL, 0x000fe200078e003aULL, 0x00026fc000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff3f7224ULL, 0x002fc400078e0068ULL, 0x000008f000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e003eULL, 0xfffeb36000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3e7224ULL, 0x000fe200078e003aULL, 0x0002702000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff3f7224ULL, 0x000fc400078e0069ULL, 0x0000089000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e003eULL, 0xfffee7c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3e7224ULL, 0x000fe200078e003aULL, 0x0002708000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff3f7224ULL, 0x002fc400078e0068ULL, 0x0000083000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e003eULL, 0xfffee78000007947ULL, 0x000fea000383ffffULL,
0x00000001ff397807ULL, 0x008fe40004000000ULL, 0x000270d000387802ULL, 0x000fc40000000f00ULL,
0x0000082000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff097224ULL, 0x000fe200078e003dULL,
0xffff20c000007947ULL, 0x000fea000383ffffULL, 0x00000001ff397807ULL, 0x000fe40004800000ULL,
0x0002712000387802ULL, 0x000fc40000000f00ULL, 0x000007d000007944ULL, 0x002fea0003c00000ULL,
0xffff211000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3e7224ULL, 0x000fe200078e0041ULL,
0x0002717000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff3f7224ULL, 0x000fc400078e0069ULL,
0x0000074000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e003eULL,
0xffff21a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3e7224ULL, 0x000fe200078e0041ULL,
0x000271d000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff3f7224ULL, 0x002fc400078e0068ULL,
0x000006e000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e003eULL,
0xffff229000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3e7224ULL, 0x000fe200078e003aULL,
0x0002723000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff3f7224ULL, 0x000fc400078e0069ULL,
0x0000068000007944ULL, 0x00afea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e003eULL,
0xffff245000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3e7224ULL, 0x000fe200078e003aULL,
0x0002729000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff3f7224ULL, 0x002fc400078e0068ULL,
0x0000062000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e003eULL,
0xffff241000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3e7224ULL, 0x000fe200078e003aULL,
0x000272f000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff3f7224ULL, 0x000fc400078e0069ULL,
0x000005c000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e003eULL,
0xffff587000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3e7224ULL, 0x000fe200078e003aULL,
0x0002735000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff3f7224ULL, 0x002fc400078e0068ULL,
0x0000056000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e003eULL,
0xffff583000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3e7224ULL, 0x000fe200078e0004ULL,
0x000273a000387802ULL, 0x000fc40000000f00ULL, 0x0000051000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff007224ULL, 0x004fe200078e003eULL, 0xffff7af000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3e7224ULL, 0x000fe200078e0004ULL, 0x000273f000387802ULL, 0x000fc40000000f00ULL,
0x000004c000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e003eULL,
0xffff7be000007947ULL, 0x000fea000383ffffULL, 0x00000002ff2e7424ULL, 0x000fe200078e00ffULL,
0x0002744000087802ULL, 0x000fc40000000f00ULL, 0x0000043000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e002bULL, 0xffffe68000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2d7224ULL, 0x006fe200078e002fULL, 0x000274a000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff2e7424ULL, 0x000fc400078e00ffULL, 0x000003d000007944ULL, 0x000fea0003c00000ULL,
0x0000002b2f00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff2d7224ULL, 0x002fe200078e0006ULL,
0x0002750000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff2e7424ULL, 0x000fe200078e00ffULL,
0x0000002f2b3a7208ULL, 0x000fc80004000000ULL, 0x0000037000007944ULL, 0x000fea0003c00000ULL,
0x0000002b0600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff2d7224ULL, 0x002fe200078e0007ULL,
0x0002756000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff2e7424ULL, 0x000fe200078e00ffULL,
0x000000062b067208ULL, 0x000fc80004000000ULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x0000002b0700720bULL, 0x004fe20003f1e000ULL, 0x000000ffff2d7224ULL, 0x002fe200078e0038ULL,
0x000275c000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff2e7424ULL, 0x000fe200078e00ffULL,
0x000000072b2c7208ULL, 0x000fc80004000000ULL, 0x000002b000007944ULL, 0x000fea0003c00000ULL,
0x0000002b3800720bULL, 0x004fe20003f1e000ULL, 0x000000ffff2d7224ULL, 0x002fe200078e003aULL,
0x0002762000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff2e7424ULL, 0x000fe200078e00ffULL,
0x000000382b047208ULL, 0x000fc80004000000ULL, 0x0000025000007944ULL, 0x000fea0003c00000ULL,
0x0000002b3a00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff2d7224ULL, 0x002fe200078e0006ULL,
0x0002768000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff2e7424ULL, 0x000fe200078e00ffULL,
0x0000003a2b057208ULL, 0x000fc80004000000ULL, 0x000001f000007944ULL, 0x000fea0003c00000ULL,
0x0000002b0600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff2d7224ULL, 0x002fe200078e002cULL,
0x000276e000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff2e7424ULL, 0x000fe200078e00ffULL,
0x000000062b067208ULL, 0x000fc80004000000ULL, 0x0000019000007944ULL, 0x000fea0003c00000ULL,
0xffffe55000007947ULL, 0x000fea000383ffffULL, 0x0180000012007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000001200008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff12ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000012027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000001200007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffd879002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff097424ULL, 0x000fe200078e00ffULL,
0x0000004400007348ULL, 0x000fe80003800000ULL, 0x0c00002e2d2b7389ULL, 0x0002a200000e0039ULL,
0xfffd875008007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff397424ULL, 0x000fe200078e00ffULL,
0x0000001000007348ULL, 0x000fe80003800000ULL, 0x0000003f3e3e7389ULL, 0x0002a200000e0011ULL,
0xfffd871038007950ULL, 0x000fea0003c3ffffULL, 0x000000013900780cULL, 0x000fe20003f25070ULL,
0x0000000a00007348ULL, 0x000fd80003800000ULL, 0x0000000000397806ULL, 0x000fc800048e0100ULL,
0x0000000a393d7212ULL, 0x000fe200078ec0ffULL, 0x00000000ff397424ULL, 0x000fc800078e00ffULL,
0xfffd86b038007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff257424ULL, 0x000fe200078e00ffULL,
0x0000003300007348ULL, 0x000fe80003800000ULL, 0xfffd868024007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000200000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x000000000000060bULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000768ULL, 0x00000000000002a0ULL, 0x0000001b00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000a08ULL, 0x00000000000003e8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000df0ULL, 0x00000000000000e4ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000ed4ULL, 0x0000000000000c40ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001b18ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001b28ULL, 0x00000000000000b0ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000007bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001bd8ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001bdcULL, 0x00000000000001c8ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001e00ULL, 0x0000000000027a80ULL, 0xf000001b00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x0000000100000089ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000029880ULL, 0x0000000000000044ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x00000000000298d0ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000029c50ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001bd8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000027ca8ULL, 0x0000000000027ca8ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000029880ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000029c50ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_4_kvt_int8_pagedKV_64_nqpkv_1_m_1_sm_86_cubin_len = 171312;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
