/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_nqpkv_0_m_32_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000018c40ULL, 0x00000000000188c0ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6c61685f5f374944ULL, 0x6a4c45346a4c3266ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL,
0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL, 0x454536316a4c4532ULL,
0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x34366a4c4545346aULL,
0x61324545346a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL, 0x614d6e4974736e49ULL,
0x6a4c45326a4c4974ULL, 0x4c45326a4c454532ULL, 0x497461324545316aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL, 0x316a4c45326a4c45ULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL,
0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL,
0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL,
0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL, 0x61324545316a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x2400676e6964696cULL, 0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL,
0x6e725f7063725f30ULL, 0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x746e695f5f240068ULL,
0x5f315f6c616e7265ULL, 0x5f616475635f5f24ULL, 0x6668735f30376d73ULL, 0x66625f636e79736cULL,
0x5f5f2400705f796cULL, 0x6c616e7265746e69ULL, 0x75635f5f245f325fULL, 0x5f30376d735f6164ULL,
0x636e79736c666873ULL, 0x2400705f7864695fULL, 0x6e7265746e695f5fULL, 0x5f5f245f335f6c61ULL,
0x376d735f61647563ULL, 0x797365746f765f30ULL, 0x6f6c6c61625f636eULL, 0x2e616c65722e0074ULL,
0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x7865742e6c65722eULL, 0x6c656e72656b2e74ULL,
0x656b240061686d5fULL, 0x61686d5f6c656e72ULL, 0x7479426d656d7324ULL, 0x766e2e0066754265ULL,
0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL, 0x705f0061686d5f6cULL, 0x65642e006d617261ULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x00000000006e6f69ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b1ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL, 0x0000000000000030ULL,
0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000c000100000131ULL, 0x0000000000000020ULL, 0x0000000000000004ULL, 0x000c000100000178ULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000001baULL, 0x000000000000002cULL,
0x0000000000000004ULL, 0x000c000100000200ULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000c000100000247ULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c00010000028dULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000002dbULL, 0x0000000000000028ULL,
0x0000000000000004ULL, 0x000c000100000329ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c000100000377ULL, 0x000000000000001cULL, 0x0000000000000004ULL, 0x000c0001000003c5ULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b00220000040bULL, 0x0000000000016ca0ULL,
0x0000000000000180ULL, 0x000b00220000043eULL, 0x0000000000016e20ULL, 0x0000000000000040ULL,
0x000b002200000469ULL, 0x0000000000016e60ULL, 0x0000000000000050ULL, 0x000b002200000493ULL,
0x0000000000016eb0ULL, 0x0000000000000150ULL, 0x000a000300000501ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0004000300000521ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0007000300000551ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL,
0x0000000000000000ULL, 0x0000000000017000ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00016ca000000000ULL,
0x0000040400000000ULL, 0x810c000001640400ULL, 0x0059b80400288080ULL, 0x0000000000000000ULL,
0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x0022002880808492ULL, 0x0000002cffffffffULL, 0x0000007000000000ULL, 0x00016ca000000000ULL,
0x0000018000000000ULL, 0x0000580400000000ULL, 0x8082288080840900ULL, 0x0000000000002880ULL,
0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8408288080820828ULL, 0x2880808508288080ULL,
0x8087082880808608ULL, 0x082880809d082880ULL, 0x8080a1082880809fULL, 0xa508288080a30828ULL,
0x288080ba08288080ULL, 0x80ec08288080ea08ULL, 0x08288080f0082880ULL, 0x8080d208288080f2ULL,
0x0310288082801628ULL, 0x0000000000000000ULL, 0x002200288080d292ULL, 0x0000001cffffffffULL,
0x000000f000000000ULL, 0x00016e2000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8408288080820828ULL, 0x2880808508288080ULL,
0x8087082880808608ULL, 0x082880809d082880ULL, 0x8080a1082880809fULL, 0xa608288080a30828ULL,
0x288080ba08288080ULL, 0x80ec08288080ea08ULL, 0x08288080f0082880ULL, 0x8080a508288080f2ULL,
0x0310288082801628ULL, 0x0000000000000000ULL, 0x002200288080a592ULL, 0x0000002cffffffffULL,
0x000001b000000000ULL, 0x00016e6000000000ULL, 0x0000005000000000ULL, 0x0000040400000000ULL,
0x80ea288080a50900ULL, 0x0000000000002880ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8408288080820828ULL, 0x2880808508288080ULL, 0x8087082880808608ULL, 0x082880809d082880ULL,
0x8080a1082880809fULL, 0xa508288080a30828ULL, 0x288080ba08288080ULL, 0x80ec08288080ea08ULL,
0x08288080f0082880ULL, 0x8080a608288080f2ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x002200288080a692ULL, 0x0000001cffffffffULL, 0x0000028000000000ULL, 0x00016eb000000000ULL,
0x0000015000000000ULL, 0x0000000000000000ULL, 0x0000001900082f04ULL, 0x00082304000000daULL,
0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL, 0x0000000000000015ULL,
0x0000001400082304ULL, 0x0008120400000000ULL, 0x0000000000000014ULL, 0x0000001400081104ULL,
0x0008230400000000ULL, 0x0000000000000013ULL, 0x0000001300081204ULL, 0x0008110400000000ULL,
0x0000000000000013ULL, 0x0000001200082304ULL, 0x0008120400000000ULL, 0x0000000000000012ULL,
0x0000001200081104ULL, 0x0008230400000000ULL, 0x0000000000000019ULL, 0x0000001900081204ULL,
0x0008110400000000ULL, 0x0000000000000019ULL, 0x0000007b00043704ULL, 0x0000001600080a04ULL,
0x0058190300580160ULL, 0x00000000000c1704ULL, 0x0021f00000500009ULL, 0x00000000000c1704ULL,
0x0021f00000480008ULL, 0x00000000000c1704ULL, 0x0011f00000400007ULL, 0x00000000000c1704ULL,
0x0061f00000280006ULL, 0x00000000000c1704ULL, 0x0021f00000200005ULL, 0x00000000000c1704ULL,
0x0021f00000180004ULL, 0x00000000000c1704ULL, 0x0021f00000100003ULL, 0x00000000000c1704ULL,
0x0011f00000080002ULL, 0x00000000000c1704ULL, 0x0011f00000040001ULL, 0x00000000000c1704ULL,
0x0011f00000000000ULL, 0x0004310400ff1b03ULL, 0x019c290400000b00ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x019c2804ffffffffULL, 0x000002e000000110ULL,
0x000026d000000580ULL, 0x0000289000002780ULL, 0x00002b7000002a00ULL, 0x0000315000002cd0ULL,
0x000031a000003190ULL, 0x00005330000031d0ULL, 0x000054e0000053d0ULL, 0x000057c000005650ULL,
0x00005d9000005920ULL, 0x00005de000005dd0ULL, 0x00007ee000005e10ULL, 0x0000809000007f80ULL,
0x0000837000008200ULL, 0x00008940000084d0ULL, 0x0000899000008980ULL, 0x0000a930000089c0ULL,
0x0000aae00000a9d0ULL, 0x0000adc00000ac50ULL, 0x0000b3800000af20ULL, 0x0000b3d00000b3c0ULL,
0x0000c8f00000b400ULL, 0x0000c9100000c900ULL, 0x00014be00000c920ULL, 0x00014c3000014c20ULL,
0x00014c9000014c40ULL, 0x00014cd000014cb0ULL, 0x0001602000014ce0ULL, 0x000160b000016070ULL,
0x00016110000160e0ULL, 0x0001618000016140ULL, 0x00016200000161c0ULL, 0x0001629000016240ULL,
0x00016320000162e0ULL, 0x0001638000016350ULL, 0x000163f0000163b0ULL, 0x0001647000016430ULL,
0x00016500000164b0ULL, 0x0001659000016550ULL, 0x000165f0000165c0ULL, 0x0001666000016620ULL,
0x000166e0000166a0ULL, 0x0001677000016720ULL, 0x00016800000167c0ULL, 0x0001686000016830ULL,
0x000168d000016890ULL, 0x0001695000016910ULL, 0x000169e000016990ULL, 0x00016aa000016a40ULL,
0x00016b6000016b00ULL, 0x00016c2000016bc0ULL, 0x0440390400016c80ULL, 0x000000ff000003b0ULL,
0x003f010000012600ULL, 0x0000000b00000430ULL, 0x003f012000012608ULL, 0x0000000b000004f0ULL,
0x003f012000012688ULL, 0x0000000b00000520ULL, 0x003f0120000126a8ULL, 0x0000000b00000550ULL,
0x003f0120000126c8ULL, 0x000000ff00000b10ULL, 0x003f010700012600ULL, 0x0000001400000c70ULL,
0x003f01020001268cULL, 0x0000001400000d00ULL, 0x003f010100012688ULL, 0x000000ff00001630ULL,
0x0004010700000000ULL, 0x000000ff000016b0ULL, 0x0004010100000000ULL, 0x0000000200001710ULL,
0x003f010100000020ULL, 0x0000000c00001880ULL, 0x003f0105000126ccULL, 0x0000000c00001a50ULL,
0x003f0105000126ccULL, 0x0000001f00002270ULL, 0x003f0107000126b0ULL, 0x0000001f00002330ULL,
0x003f0101000126b0ULL, 0x0000001c00002390ULL, 0x003f010100012608ULL, 0x00000023000023d0ULL,
0x003f01050001260cULL, 0x00000023000025b0ULL, 0x003f01050001260cULL, 0x0000001f00002e80ULL,
0x003f0105000126acULL, 0x0000001f00003070ULL, 0x003f0105000126acULL, 0x0000006800004550ULL,
0x003f010100000000ULL, 0x0000001f000045b0ULL, 0x003f010100012688ULL, 0x0000000d000045d0ULL,
0x003f010500000004ULL, 0x0000000d000047a0ULL, 0x003f010500000004ULL, 0x0000000800004ef0ULL,
0x003f010700000000ULL, 0x0000000800004fd0ULL, 0x003f010100000000ULL, 0x0000002300005030ULL,
0x003f010100012628ULL, 0x0000006a00005090ULL, 0x003f01050001262cULL, 0x0000006a00005260ULL,
0x003f01050001262cULL, 0x0000006a00005af0ULL, 0x003f0105000126b4ULL, 0x0000006a00005cc0ULL,
0x003f0105000126b4ULL, 0x0000006a00007120ULL, 0x003f010100000000ULL, 0x0000002600007180ULL,
0x003f010100012690ULL, 0x0000000d000071a0ULL, 0x003f010500000004ULL, 0x0000000d00007370ULL,
0x003f010500000004ULL, 0x000000ff00007af0ULL, 0x0004010700000008ULL, 0x0000006800007b80ULL,
0x003f0101000126b0ULL, 0x0000002300007be0ULL, 0x003f010100012648ULL, 0x0000002300007c40ULL,
0x003f01050001264cULL, 0x0000002300007e10ULL, 0x003f01050001264cULL, 0x00000008000086a0ULL,
0x003f010500000004ULL, 0x0000000800008870ULL, 0x003f010500000004ULL, 0x0000002600009b90ULL,
0x003f010100000000ULL, 0x0000006a00009bf0ULL, 0x003f010100012698ULL, 0x0000000d00009c10ULL,
0x003f010500000004ULL, 0x0000000d00009de0ULL, 0x003f010500000004ULL, 0x000000ff0000a580ULL,
0x0004010700000000ULL, 0x000000080000a630ULL, 0x003f010100000000ULL, 0x0000000c0000a690ULL,
0x003f010100012668ULL, 0x0000000c0000a6b0ULL, 0x003f01050001266cULL, 0x0000000c0000a880ULL,
0x003f01050001266cULL, 0x000000260000b0e0ULL, 0x003f0105000126b4ULL, 0x000000260000b2b0ULL,
0x003f0105000126b4ULL, 0x0000000d0000c640ULL, 0x003f010100000000ULL, 0x0000000a0000c6c0ULL,
0x003f010100000000ULL, 0x000000ff0000e430ULL, 0x003f010100012600ULL, 0x000000ff0000efe0ULL,
0x003f010500012604ULL, 0x000000ff0000f1b0ULL, 0x003f010500012604ULL, 0x000000ff0000f530ULL,
0x003f010100012600ULL, 0x000000ff0000f560ULL, 0x003f010500012604ULL, 0x000000ff0000f720ULL,
0x003f010500012604ULL, 0x00000056000120a0ULL, 0x003f010100000000ULL, 0x00000056000121d0ULL,
0x003f010500000004ULL, 0x00000056000123a0ULL, 0x003f010500000004ULL, 0x0000005500015e80ULL,
0x003f010100000000ULL, 0x0000005500015ee0ULL, 0x003f010100000008ULL, 0x0000005500015f40ULL,
0x003f010100000010ULL, 0x0000005500015fb0ULL, 0x003f010100000018ULL, 0x00301c0400053803ULL,
0x0000d8400000d810ULL, 0x0000db700000da10ULL, 0x0000de300000dcd0ULL, 0x0000e0f00000df90ULL,
0x0000e3800000e280ULL, 0x00015ff00000f780ULL, 0x000c050400000401ULL, 0x0000000100000100ULL,
0x00041e0400000001ULL, 0x0000000000000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x000000000000032cULL, 0x0000001900000002ULL, 0x000000000000025cULL, 0x0000001900000002ULL,
0x000000000000019cULL, 0x0000001900000002ULL, 0x00000000000000ccULL, 0x0000001900000002ULL,
0x0000000000000044ULL, 0x0000001900000002ULL, 0x0000000000000308ULL, 0x0000001900000002ULL,
0x0000000000000238ULL, 0x0000001900000002ULL, 0x0000000000000178ULL, 0x0000001900000002ULL,
0x00000000000000a8ULL, 0x0000001900000002ULL, 0x0000000000012700ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000590000007b06ULL, 0x000e620000209000ULL,
0x00005900ff107624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f45070ULL,
0x0000000000067919ULL, 0x000ea20000002600ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x00005a0000057ab9ULL, 0x000fe20000000800ULL, 0x0000000000097919ULL, 0x000ee20000002300ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x00005a0010757a19ULL, 0x000fe200000006ffULL,
0x0000460000087ab9ULL, 0x000fe20000000a00ULL, 0x0000000000077919ULL, 0x000f280000002100ULL,
0x00000000000e7919ULL, 0x000ea20000002700ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027810ULL, 0x002fc40007ffe0ffULL, 0x00000005ff1a7819ULL, 0x010fc80000011607ULL,
0x0000000200037305ULL, 0x000324000021f000ULL, 0x00001fff1a1a7589ULL, 0x000fe200000e0000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x000000ffff057224ULL, 0x010fc800078e0a03ULL,
0x0000590005057a24ULL, 0x000fc800078e02ffULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x00000400031b7a27ULL, 0x000fc800078e00ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a1bULL,
0x0000040003007624ULL, 0x000fca00078e0210ULL, 0x0000590000007a0cULL, 0x000fda0003f06070ULL,
0x8000590000000a10ULL, 0x000fe40007ffe0ffULL, 0x000000011b1b0810ULL, 0x000fe40007ffe0ffULL,
0x0000590000007a0cULL, 0x000fda0003f26070ULL, 0x000000011b1b1810ULL, 0x000fe40007ffe0ffULL,
0x00005900ff1baa12ULL, 0x000fc800078e33ffULL, 0x0000001b00007306ULL, 0x000e620000209000ULL,
0x000000ff1b00720cULL, 0x000fce0003f85070ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL, 0x0000000200037305ULL, 0x000324000021f000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x000000031b047224ULL, 0x010fc800078e02ffULL,
0x000000ffff057224ULL, 0x000fe400078e0a04ULL, 0x0000000000047919ULL, 0x000ee40000002200ULL,
0x0000000503037227ULL, 0x000fcc00078e0002ULL, 0x0000000603127227ULL, 0x004fc800078e00ffULL,
0x000000ffff007224ULL, 0x000fc800078e0a12ULL, 0x000000001b007224ULL, 0x000fca00078e0206ULL,
0x0000001b0000720cULL, 0x000fe20003f46070ULL, 0x0000010009027a24ULL, 0x008fe400078e0204ULL,
0x00001fff09097589ULL, 0x000e6400000e0000ULL, 0x00000000020b7a24ULL, 0x000fca00078e0207ULL,
0x000000ff0b00720cULL, 0x000fc60003fa5270ULL, 0x0000000100002824ULL, 0x000fe200078e0a1bULL,
0x0000000112122810ULL, 0x000fe40007ffe0ffULL, 0x0000007f0b00780cULL, 0x040fe40003f04070ULL,
0x0000001b0000720cULL, 0x000fe40003f66070ULL, 0x0000000f0b00780cULL, 0x040fe40003f24070ULL,
0x000000030b00780cULL, 0x000fe20003f44070ULL, 0x3fffff80ff02d424ULL, 0x000fc400078e00ffULL,
0x7fffff80ff03d424ULL, 0x000fc800078e00ffULL, 0xff317217ff088424ULL, 0x000fe400078e00ffULL,
0x0000000112123810ULL, 0x000fe20007ffe0ffULL, 0x01260002ff00d388ULL, 0x0005e20000000a00ULL,
0x0000001bff12c212ULL, 0x000fe200078e33ffULL, 0x3fffffc0ff049424ULL, 0x000fe200078e00ffULL,
0x000000010b00780cULL, 0x000fe20003f64070ULL, 0x012400080b008388ULL, 0x0007e20000004800ULL,
0x7fffffc0ff059424ULL, 0x000fe200078e00ffULL, 0x00005a0012187a19ULL, 0x000fe200000006ffULL,
0x000000ffff007224ULL, 0x000fc600078e0a12ULL, 0x012608040b009388ULL, 0x0009e20000008a00ULL,
0x000000001b1b7224ULL, 0x000fe400078e0206ULL, 0x3fffff60ff02a424ULL, 0x004fe400078e00ffULL,
0x000000201b007824ULL, 0x000fe400078e00ffULL, 0x7fffff60ff03a424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff06b424ULL, 0x000fe200078e00ffULL, 0x0000000400087c10ULL, 0x048fe2000fffe1ffULL,
0x7fffffc0ff07b424ULL, 0x000fe200078e00ffULL, 0x0000000400007c0cULL, 0x000fe2000bf03070ULL,
0x3fffff80ff04a424ULL, 0x010fe200078e00ffULL, 0x0000002008087817ULL, 0x000fe20003800000ULL,
0x7fffff80ff05a424ULL, 0x000fe200078e00ffULL, 0x012688020b00a388ULL, 0x0005e40000008a00ULL,
0x000000ff08197207ULL, 0x000fe20000000000ULL, 0x0000000409087824ULL, 0x002fe200078e021aULL,
0x0126a8040b00a388ULL, 0x000fe40000008a00ULL, 0x000000201900780cULL, 0x000fe20003f05270ULL,
0x0000000408087824ULL, 0x000fe200078e00ffULL, 0x0126c8060b00b388ULL, 0x000fe20000008a00ULL,
0x000058000e027a24ULL, 0x004fc800078e02ffULL, 0x0000007502027224ULL, 0x000fe200078e0218ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000002e000008947ULL, 0x000fea0003800000ULL,
0x0000000000177919ULL, 0x000e620000000000ULL, 0xffffffff00047882ULL, 0x000fe20000000000ULL,
0x0000000819037217ULL, 0x000fe20007800000ULL, 0x00005a0000057ab9ULL, 0x000fc40000000800ULL,
0x0000000504047299ULL, 0x000fe4000800063fULL, 0x0000000103037824ULL, 0x000fe200078e0a08ULL,
0x00000004ff047819ULL, 0x002fc80000011617ULL, 0x00000002040b7810ULL, 0x000fe20007ffe0ffULL,
0x00000001080a7824ULL, 0x000fe200078e0204ULL, 0x000000030400720cULL, 0x080fe20003f06070ULL,
0x0000001017047824ULL, 0x000fe200078e00ffULL, 0x000000030b00720cULL, 0x000fe20003f26070ULL,
0x00000001080c7824ULL, 0x000fe400078e020bULL, 0x0000000100057824ULL, 0x040fe400078e020aULL,
0x00000001000d7824ULL, 0x000fe400078e020cULL, 0x000000100a0b7824ULL, 0x000fe200078e00ffULL,
0x0000000405077c12ULL, 0x000fc4000f8e30ffULL, 0x000000040d0f7c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff067a19ULL, 0x000fe20000011605ULL, 0x0000000102077824ULL, 0x040fe200078e0207ULL,
0x00005a00ff087a19ULL, 0x000fe2000001160dULL, 0x00000001020f7824ULL, 0x000fe200078e020fULL,
0x000000f004057812ULL, 0x000fe200078ec0ffULL, 0x0000007506027224ULL, 0x080fe400078e0207ULL,
0x0000007508067224ULL, 0x000fe400078e020fULL, 0x0000010002027825ULL, 0x000fc800078e00ffULL,
0x0000010006067825ULL, 0x000fe200078e00ffULL, 0x0000000502027212ULL, 0x000fc600078efcffULL,
0x000000010a087824ULL, 0x100fe200078e0217ULL, 0x0000000506057212ULL, 0x000fe200078efcffULL,
0x000000010c0a7824ULL, 0x000fe200078e0217ULL, 0x00005e0002027a10ULL, 0x000fe20007f5e0ffULL,
0x000000100c0d7824ULL, 0x000fe200078e00ffULL, 0xfffffff00b087812ULL, 0x000fe400078ee208ULL,
0x00005e0005067a10ULL, 0x000fe40007f7e0ffULL, 0xfffffff00d0a7812ULL, 0x000fe200078ee20aULL,
0x0000001008057824ULL, 0x000fe200078e00ffULL, 0x00005f0003037a10ULL, 0x000fc400017fe4ffULL,
0x00005f0007077a10ULL, 0x000fe20001ffe4ffULL, 0x000000100a0b7824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002057faeULL, 0x0003e8000c101c48ULL,
0x00000000060b7faeULL, 0x0003e2000c901c48ULL, 0x0000027000007947ULL, 0x000fea0003800000ULL,
0x0000000000177919ULL, 0x000e620000000000ULL, 0xffffffff00047882ULL, 0x000fe40000000000ULL,
0x00005a0000057ab9ULL, 0x000fc40000000800ULL, 0x0000000504047299ULL, 0x000fe2000800063fULL,
0x0000000817087211ULL, 0x002fc800078fe0ffULL, 0x00000002080a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000100037824ULL, 0x000fe400078e0208ULL, 0x00000010080c7824ULL, 0x000fe400078e00ffULL,
0x0000000100067824ULL, 0x000fe200078e020aULL, 0x0000000403057c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff047a19ULL, 0x000fe40000011603ULL, 0x0000000406077c12ULL, 0x000fe2000f8e30ffULL,
0x0000000102057824ULL, 0x000fe200078e0205ULL, 0x00005a00ff067a19ULL, 0x000fc60000011606ULL,
0x0000000102077824ULL, 0x000fe400078e0207ULL, 0x0000007504027224ULL, 0x080fe400078e0205ULL,
0x0000001017047824ULL, 0x000fe400078e00ffULL, 0x0000007506067224ULL, 0x000fe400078e0207ULL,
0x0000010002027825ULL, 0x000fe200078e00ffULL, 0x000000f0040b7812ULL, 0x000fc600078ec0ffULL,
0x0000010006067825ULL, 0x000fe200078e00ffULL, 0x0000000b02027212ULL, 0x000fc600078efcffULL,
0x0000000108057824ULL, 0x100fe200078e0217ULL, 0x0000000b06067212ULL, 0x000fe200078efcffULL,
0x000000010a087824ULL, 0x000fe200078e0217ULL, 0x00005e0002027a10ULL, 0x000fe20007f1e0ffULL,
0x000000100a0b7824ULL, 0x000fe200078e00ffULL, 0xfffffff00c057812ULL, 0x000fe400078ee205ULL,
0x00005e0006067a10ULL, 0x000fe40007f3e0ffULL, 0xfffffff00b087812ULL, 0x000fe200078ee208ULL,
0x0000001005057824ULL, 0x000fe200078e00ffULL, 0x00005f0003037a10ULL, 0x000fc400007fe4ffULL,
0x00005f0007077a10ULL, 0x000fe20000ffe4ffULL, 0x00000010080b7824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002057faeULL, 0x0003e8000b901c48ULL,
0x00000000060b7faeULL, 0x0003e4000b901c48ULL, 0x0000000000037919ULL, 0x002e620000000000ULL,
0x0000000000057806ULL, 0x000fc600038e0000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000500027300ULL, 0x000e7000000e0000ULL, 0x0000000500067309ULL, 0x000ea20000000000ULL,
0x000000030200720cULL, 0x002fe20003f02070ULL, 0x00000004ff037424ULL, 0x000fc400078e00ffULL,
0x000000ffff067224ULL, 0x004fe400078e0a06ULL, 0x000064000e027625ULL, 0x000fd000078e0003ULL,
0x01260406ffff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01260000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000802167981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0900720cULL, 0x000fe40003f05270ULL, 0x000000ff16057810ULL, 0x004fc80007ffe0ffULL,
0x00000008ff157819ULL, 0x000fce0000011605ULL, 0x0000d75000008947ULL, 0x000fea0003800000ULL,
0x000000081a147824ULL, 0x000fe400078e00ffULL, 0x00000003ff037424ULL, 0x000fe200078e00ffULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01268c0314ff738cULL, 0x0005e20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000001ff0500780cULL, 0x000fe20003f04070ULL,
0x000000020e007824ULL, 0x000fe200078e00ffULL, 0x00000001ff137819ULL, 0x000fe2000001161aULL,
0x0126880014ff7f8cULL, 0x0007e2000c80043fULL, 0x000000011a117812ULL, 0x000fe200078ec0ffULL,
0x0000590000037624ULL, 0x004fe400078e0210ULL, 0x00000020136e7824ULL, 0x000fc400078e00ffULL,
0x0000000112127824ULL, 0x000fc800078e0203ULL, 0x0000660012007a24ULL, 0x000fe200078e026eULL,
0x000003e000000947ULL, 0x000fea0003800000ULL, 0x0000006e16037217ULL, 0x008fe20007800000ULL,
0x0000001011027824ULL, 0x000fe200078e00ffULL, 0x00000003ff057819ULL, 0x000fc60000011617ULL,
0x0000000103037824ULL, 0x000fe200078e0a6eULL, 0x0000000405087810ULL, 0x000fe20007ffe0ffULL,
0x0000000102067824ULL, 0x002fc600078e0205ULL, 0x0000000203037217ULL, 0x000fe20007800000ULL,
0x0000000106077824ULL, 0x040fe400078e0217ULL, 0x00000008060c7824ULL, 0x000fe400078e00ffULL,
0x0000000103037824ULL, 0x000fe400078e0a02ULL, 0x0000000100067824ULL, 0x000fe200078e0206ULL,
0xfffffff80c0c7812ULL, 0x000fe400078ee207ULL, 0x0000000805077810ULL, 0x000fc40007ffe0ffULL,
0x000000030500720cULL, 0x0c0fe40003f66070ULL, 0x0000000c05057810ULL, 0x000fe40007ffe0ffULL,
0x000000030800720cULL, 0x080fe20003f46070ULL, 0x0000000102087824ULL, 0x040fe200078e0208ULL,
0x000000030700720cULL, 0x080fe20003f26070ULL, 0x0000000102077824ULL, 0x040fe200078e0207ULL,
0x000000030500720cULL, 0x000fe20003f06070ULL, 0x00000001020a7824ULL, 0x000fe400078e0205ULL,
0x0000008006027825ULL, 0x000fc800078e00ffULL, 0x0000000100067824ULL, 0x000fe200078e0208ULL,
0x00000070020b7812ULL, 0x000fe200078ef804ULL, 0x0000000108057824ULL, 0x040fe400078e0217ULL,
0x00000008080e7824ULL, 0x000fe400078e00ffULL, 0x0000000100087824ULL, 0x000fe400078e0207ULL,
0x0000000107097824ULL, 0x040fe400078e0217ULL, 0x0000000807107824ULL, 0x000fc400078e00ffULL,
0x00000001000d7824ULL, 0x000fe200078e020aULL, 0xfffffff80e007812ULL, 0x000fe200078ee205ULL,
0x000000010a027824ULL, 0x000fe200078e0217ULL, 0xfffffff8100e7812ULL, 0x000fe200078ee209ULL,
0x000000080a077824ULL, 0x000fe200078e00ffULL, 0x000062000b0a7a10ULL, 0x000fe40007f9e0ffULL,
0x0000e00013057811ULL, 0x000fe400078e68ffULL, 0xfffffff807107812ULL, 0x000fe400078ee202ULL,
0x00006300030b7a10ULL, 0x000fe200027fe4ffULL, 0x0000008006027825ULL, 0x000fc800078e00ffULL,
0x0000008008067825ULL, 0x000fe200078e00ffULL, 0x0000007002027812ULL, 0x000fc600078ef804ULL,
0x000000800d087825ULL, 0x000fe200078e00ffULL, 0x0000620002027a10ULL, 0x000fc60007f9e0ffULL,
0x00000010000f7824ULL, 0x100fe200078e0205ULL, 0x0000007006007812ULL, 0x100fe200078ef804ULL,
0x000000100c0d7824ULL, 0x100fe200078e0205ULL, 0x0000007008067812ULL, 0x000fe200078ef804ULL,
0x000000100e1d7824ULL, 0x100fe200078e0205ULL, 0x0000620000047a10ULL, 0x000fe20007fbe0ffULL,
0x00000010101f7824ULL, 0x000fe200078e0205ULL, 0x0000620006067a10ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a0d7faeULL, 0x0003e2000d901c48ULL,
0x0000630003037a10ULL, 0x000fe400027fe4ffULL, 0x0000630007057a10ULL, 0x000fc40002ffe4ffULL,
0x0000630009077a10ULL, 0x000fe200037fe4ffULL, 0x00000000020f7faeULL, 0x0003e8000d101c48ULL,
0x00000000041d7faeULL, 0x0003e8000c901c48ULL, 0x00000000061f7faeULL, 0x0003e2000c101c48ULL,
0x0000031000007947ULL, 0x000fea0003800000ULL, 0x0000001011027824ULL, 0x008fe200078e00ffULL,
0x0000e000131f7811ULL, 0x000fc800078e68ffULL, 0x0000000217027211ULL, 0x000fc800078fe8ffULL,
0x0000000402067810ULL, 0x002fe20007ffe0ffULL, 0x0000000100037824ULL, 0x000fe200078e0202ULL,
0x0000000802097810ULL, 0x040fe20007ffe0ffULL, 0x0000000102057824ULL, 0x040fe200078e0217ULL,
0x0000000c020a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000802087824ULL, 0x000fe400078e00ffULL,
0x0000008003027825ULL, 0x000fc600078e00ffULL, 0xfffffff808057812ULL, 0x000fe200078ee205ULL,
0x0000000100077824ULL, 0x000fe400078e0206ULL, 0x0000000106087824ULL, 0x040fe400078e0217ULL,
0x00000008060f7824ULL, 0x000fe400078e00ffULL, 0x0000000100067824ULL, 0x040fe400078e0209ULL,
0x00000001000d7824ULL, 0x000fe200078e020aULL, 0x0000007002007812ULL, 0x000fe200078ef804ULL,
0x00000001090b7824ULL, 0x000fc400078e0217ULL, 0x00000008090c7824ULL, 0x000fe400078e00ffULL,
0x000000010a027824ULL, 0x040fe400078e0217ULL, 0x000000080a097824ULL, 0x000fe200078e00ffULL,
0x00006200000a7a10ULL, 0x000fe40007f1e0ffULL, 0xfffffff80c0c7812ULL, 0x000fe400078ee20bULL,
0xfffffff8090e7812ULL, 0x000fe400078ee202ULL, 0x00006300030b7a10ULL, 0x000fe200007fe4ffULL,
0x0000008007027825ULL, 0x000fe200078e00ffULL, 0xfffffff80f007812ULL, 0x000fc600078ee208ULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0x0000007002027812ULL, 0x000fc600078ef804ULL,
0x000000800d087825ULL, 0x000fe200078e00ffULL, 0x0000620002027a10ULL, 0x000fc60007f1e0ffULL,
0x00000010050d7824ULL, 0x100fe200078e021fULL, 0x0000007006057812ULL, 0x100fe200078ef804ULL,
0x00000010000f7824ULL, 0x100fe200078e021fULL, 0x0000007008067812ULL, 0x000fe200078ef804ULL,
0x000000100c1d7824ULL, 0x100fe200078e021fULL, 0x0000620005047a10ULL, 0x000fe20007f3e0ffULL,
0x000000100e1f7824ULL, 0x000fe200078e021fULL, 0x0000620006067a10ULL, 0x000fe20007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a0d7faeULL, 0x0003e2000b901c48ULL,
0x0000630003037a10ULL, 0x000fe400007fe4ffULL, 0x0000630007057a10ULL, 0x000fc40000ffe4ffULL,
0x0000630009077a10ULL, 0x000fe200017fe4ffULL, 0x00000000020f7faeULL, 0x0003e8000b901c48ULL,
0x00000000041d7faeULL, 0x0003e8000b901c48ULL, 0x00000000061f7faeULL, 0x0003e4000b901c48ULL,
0x00000000130473c2ULL, 0x000ea200000e0000ULL, 0x000000ff1500720cULL, 0x000fe20003f05270ULL,
0x000000ffff227224ULL, 0x000fe200078e00ffULL, 0x000126a813027811ULL, 0x002fe200078e18ffULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x000126a804047891ULL, 0x004fe2000f8e203fULL, 0x0000000000527805ULL, 0x000fe2000001ff00ULL,
0x0000000000507805ULL, 0x000fe2000001ff00ULL, 0x0000000000567805ULL, 0x000fe2000001ff00ULL,
0x000000ffff557224ULL, 0x000fca00078e00ffULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000ff6c7f8cULL, 0x000e62000c800404ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000200002027f8cULL, 0x000ea2000c80043fULL,
0x000000ffff547224ULL, 0x000fe200078e00ffULL, 0x00000000005a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000587805ULL, 0x000fe2000001ff00ULL, 0x00000000005e7805ULL, 0x000fe2000001ff00ULL,
0x00000000005c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000627805ULL, 0x000fe2000001ff00ULL,
0x0000000000607805ULL, 0x000fe2000001ff00ULL, 0x0000000000667805ULL, 0x000fe2000001ff00ULL,
0x0000000000647805ULL, 0x000fe2000001ff00ULL, 0x0000af4000008947ULL, 0x000fea0003800000ULL,
0x00000010130e7824ULL, 0x000fe200078e00ffULL, 0x00000002ff107819ULL, 0x000fe2000001161aULL,
0x000000ffff007224ULL, 0x004fc400078e0003ULL, 0xff317217ff087424ULL, 0x000fe200078e00ffULL,
0x000000100e0e7812ULL, 0x000fe200078ee2ffULL, 0x000000ffff0f7224ULL, 0x000fe400078e00ffULL,
0x000000ffff2b7224ULL, 0x000fc400078e00ffULL, 0x000000ffff1c7224ULL, 0x00afca00078e00ffULL,
0x0000000000027805ULL, 0x000fc40000015200ULL, 0x000000041a0a7824ULL, 0x000fca00078e00ffULL,
0xfffffff80a0c7812ULL, 0x000fc800078ec0ffULL, 0x000126c80c0d7810ULL, 0x000fe20007ffe0ffULL,
0x0126cc000c0b7984ULL, 0x000ea40000000800ULL, 0x800000000bff7812ULL, 0x004fe40007804800ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001f000007945ULL, 0x000fe20003800000ULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000101c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a021d7210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e03ULL, 0x003d09001d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0a7819ULL, 0x000fc8000001140bULL,
0x0000001d0a0a7211ULL, 0x000fca00078110ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e060bULL,
0x000000020a0a7819ULL, 0x000fc8000000120bULL, 0x0000000a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011c1c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0126cc000c0b7984ULL, 0x000ea40000000800ULL,
0x800000000bff7812ULL, 0x004fe40007804800ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000010f007810ULL, 0x040fe20007ffe0ffULL,
0x000001000f0c7824ULL, 0x000fc600078e026eULL, 0x000000150000720cULL, 0x000fe40003f46070ULL,
0x000000400c037810ULL, 0x000fca0007ffe0ffULL, 0x00006600121f7a24ULL, 0x000fcc00078e0203ULL,
0x000004000000a947ULL, 0x000fea0003800000ULL, 0x00000003ff0a7819ULL, 0x000fe20000011617ULL,
0x00000010110b7824ULL, 0x000fe200078e00ffULL, 0x0000000316007217ULL, 0x000fe40007800000ULL,
0x000000080a1d7810ULL, 0x040fe20007ffe0ffULL, 0x000000010b027824ULL, 0x040fe200078e020aULL,
0x0000000c0a247810ULL, 0x000fe20007ffe0ffULL, 0x0000000100007824ULL, 0x000fe400078e0a03ULL,
0x00000001021c7824ULL, 0x040fe400078e0217ULL, 0x0000000802237824ULL, 0x000fe200078e00ffULL,
0x000000000b007217ULL, 0x000fe20007800000ULL, 0x0000001017037824ULL, 0x000fc400078e00ffULL,
0x0000000102027824ULL, 0x000fe200078e021fULL, 0xfffffff823237812ULL, 0x000fe200078ee21cULL,
0x0000000100007824ULL, 0x000fe200078e0a0bULL, 0x000000040a1c7810ULL, 0x000fe20007ffe0ffULL,
0x000000010b207824ULL, 0x000fe200078e021dULL, 0x0000007003217812ULL, 0x000fe200078ec0ffULL,
0x0000008002027825ULL, 0x000fe200078e00ffULL, 0x000000000a00720cULL, 0x080fe40003fa6070ULL,
0x000000001c00720cULL, 0x080fe20003f86070ULL, 0x000000010b1e7824ULL, 0x040fe200078e021cULL,
0x00000021021c7212ULL, 0x000fe200078efcffULL, 0x000000010b267824ULL, 0x000fe200078e0224ULL,
0x000000001d00720cULL, 0x080fe20003f66070ULL, 0x000000011e0a7824ULL, 0x000fe200078e021fULL,
0x000000002400720cULL, 0x000fe20003f06070ULL, 0x000000011e007824ULL, 0x000fe200078e0217ULL,
0x000062001c1c7a10ULL, 0x000fe20007fde0ffULL, 0x000000800a0a7825ULL, 0x000fc600078e00ffULL,
0x00006300031d7a10ULL, 0x000fe200037fe4ffULL, 0x000000081e257824ULL, 0x000fe200078e00ffULL,
0x000000210a1e7212ULL, 0x080fe200078efcffULL, 0x0000000120027824ULL, 0x100fe400078e021fULL,
0x00000001260a7824ULL, 0x000fe200078e021fULL, 0x000062001e1e7a10ULL, 0x000fe20007fde0ffULL,
0x0000008002027825ULL, 0x000fe200078e00ffULL, 0xfffffff825257812ULL, 0x000fe400078ee200ULL,
0x000063000b1f7a10ULL, 0x000fe200037fe4ffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000002102027212ULL, 0x000fc400078efcffULL, 0x0000f00013007811ULL, 0x000fe200078e68ffULL,
0x0000000120247824ULL, 0x100fe200078e0217ULL, 0x0000620002027a10ULL, 0x000fe20007fde0ffULL,
0x0000000820277824ULL, 0x000fe200078e00ffULL, 0x000000210a0a7212ULL, 0x000fe200078efcffULL,
0x0000000126207824ULL, 0x040fe200078e0217ULL, 0x0000630003037a10ULL, 0x000fe200037fe4ffULL,
0x0000000826697824ULL, 0x000fe200078e00ffULL, 0xfffffff827277812ULL, 0x000fe200078ee224ULL,
0x0000001023217824ULL, 0x100fe200078e0200ULL, 0x000062000a0a7a10ULL, 0x000fe20007fde0ffULL,
0x0000001025237824ULL, 0x000fe200078e0200ULL, 0xfffffff869697812ULL, 0x000fe200078ee220ULL,
0x0000001027257824ULL, 0x100fe200078e0200ULL, 0x000063000b0b7a10ULL, 0x000fe200037fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c217faeULL, 0x0005e4000e901c48ULL,
0x0000001069277824ULL, 0x000fc400078e0200ULL, 0x000000001e237faeULL, 0x0005e8000e101c48ULL,
0x0000000002257faeULL, 0x0005e8000d901c48ULL, 0x000000000a277faeULL, 0x0005e2000c101c48ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x0000001011007824ULL, 0x000fe400078e00ffULL,
0x0000001017027824ULL, 0x000fc600078e00ffULL, 0x0000000017007211ULL, 0x000fe400078fe8ffULL,
0x0000007002257812ULL, 0x000fe400078ec0ffULL, 0x0000000c00247810ULL, 0x040fe20007ffe0ffULL,
0x0000000100037824ULL, 0x040fe200078e0217ULL, 0x0000000800207810ULL, 0x040fe20007ffe0ffULL,
0x00000008000a7824ULL, 0x040fe400078e00ffULL, 0x0000000100027824ULL, 0x000fe400078e021fULL,
0x0000000824697824ULL, 0x000fe200078e00ffULL, 0xfffffff80a217812ULL, 0x000fe200078ee203ULL,
0x0000008002027825ULL, 0x000fe200078e00ffULL, 0x00000004000a7810ULL, 0x000fc60007ffe0ffULL,
0x00000001201d7824ULL, 0x000fe200078e0217ULL, 0x00000025021e7212ULL, 0x000fe200078efcffULL,
0x000000010a007824ULL, 0x040fe400078e021fULL, 0x000000010a0b7824ULL, 0x100fe200078e0217ULL,
0x000062001e1e7a10ULL, 0x000fe20007f1e0ffULL, 0x000000080a267824ULL, 0x000fe400078e00ffULL,
0x0000000124027824ULL, 0x000fe400078e0217ULL, 0x00000001200a7824ULL, 0x000fe200078e021fULL,
0xfffffff826237812ULL, 0x000fe200078ee20bULL, 0x0000000820207824ULL, 0x000fe200078e00ffULL,
0xfffffff869697812ULL, 0x000fe200078ee202ULL, 0x00000001241c7824ULL, 0x000fe200078e021fULL,
0x00006300031f7a10ULL, 0x000fe200007fe4ffULL, 0x0000008000027825ULL, 0x000fe200078e00ffULL,
0xfffffff820277812ULL, 0x000fc400078ee21dULL, 0x0000f00013207811ULL, 0x000fe200078e68ffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000002502027212ULL, 0x000fc600078efcffULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x000000250a0a7212ULL, 0x080fe400078efcffULL,
0x0000620002027a10ULL, 0x000fe20007f1e0ffULL, 0x0000001021217824ULL, 0x100fe200078e0220ULL,
0x000000251c1c7212ULL, 0x000fe200078efcffULL, 0x0000001023237824ULL, 0x100fe200078e0220ULL,
0x000062000a0a7a10ULL, 0x000fe20007f7e0ffULL, 0x0000001027257824ULL, 0x100fe200078e0220ULL,
0x000062001c1c7a10ULL, 0x000fe20007f9e0ffULL, 0x0000001069277824ULL, 0x000fe200078e0220ULL,
0x0000630003037a10ULL, 0x000fe200007fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e217faeULL, 0x0005e2000b901c48ULL, 0x000063000b0b7a10ULL, 0x000fc40001ffe4ffULL,
0x000063001d1d7a10ULL, 0x000fe200027fe4ffULL, 0x0000000002237faeULL, 0x0005e8000b901c48ULL,
0x000000000a257faeULL, 0x0005e8000b901c48ULL, 0x000000001c277faeULL, 0x0005e4000b901c48ULL,
0xfffffff0141f7812ULL, 0x044fe400078ec0ffULL, 0xffffffe014007812ULL, 0x000fc400078ec0ffULL,
0x000000001f0573c2ULL, 0x000ea200000e0000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000001014037812ULL, 0x000fca00078ec0ffULL, 0x0000000100007824ULL, 0x000fc800078e0203ULL,
0x00000008111c7824ULL, 0x000fe200078e0200ULL, 0x000126b005057890ULL, 0x004fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a05ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0126b0001f207f8cULL, 0x0004e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x012608001c1c7f8cULL, 0x000ea4000c80043fULL,
0x0000000000027805ULL, 0x000fc40000015200ULL, 0x00000008140b7812ULL, 0x000fca00078ec0ffULL,
0x0000000100237824ULL, 0x000fca00078e020bULL, 0x01260c00230b7984ULL, 0x000f240000000800ULL,
0x800000000bff7812ULL, 0x014fe4000780481dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1e7224ULL, 0x000fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000101e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a02257210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e03ULL, 0x003d09002500780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402500780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc8000001140bULL,
0x0000002500007211ULL, 0x000fca00078110ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e060bULL,
0x0000000200007819ULL, 0x000fc8000000120bULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011e1e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x01260c00230b7984ULL, 0x000ea40000000800ULL,
0x800000000bff7812ULL, 0x004fe4000780481dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000010170b7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0a7819ULL, 0x000fe20000011617ULL, 0x000000201a007824ULL, 0x000fe400078e00ffULL,
0xffffffffff6f7424ULL, 0x000fe200078e00ffULL, 0x000000700b0b7812ULL, 0x000fc400078ec0ffULL,
0xffffff8000007812ULL, 0x000fe400078ec0ffULL, 0x0000000c0a0a7812ULL, 0x000fc800078ec0ffULL,
0x000000000a007210ULL, 0x000fca0007ffe00bULL, 0x0120000000037984ULL, 0x000ea80000000800ULL,
0x0122000000027984ULL, 0x0006620000000800ULL, 0x000000080300720bULL, 0x004fe20003f1d000ULL,
0x000139327f007947ULL, 0x000fd8000b800000ULL, 0x0000000000007806ULL, 0x008fc800000e0100ULL,
0x000000ff0000720cULL, 0x000fe20003f05270ULL, 0x0000076000007945ULL, 0x000fe20003800000ULL,
0x00000001ff247424ULL, 0x000fe400078e00ffULL, 0x000000ffff1e7224ULL, 0x000fc400078e0008ULL,
0x0000001fff777424ULL, 0x000fe400078e00ffULL, 0xffffffffff747424ULL, 0x000fca00078e00ffULL,
0x0000070000008947ULL, 0x000fea0003800000ULL, 0x0000001a1000720cULL, 0x000fe40003f05270ULL,
0x000000080300720bULL, 0x000fe20003f74000ULL, 0x000138d27f007947ULL, 0x000fd8000b800000ULL,
0x00000000001d7806ULL, 0x000fc400018e0100ULL, 0x000000801a258824ULL, 0x000fe200078e020bULL,
0x00000008031e7209ULL, 0x000fe20007810000ULL, 0x0000063000017945ULL, 0x000fe40003800000ULL,
0x000000010a258824ULL, 0x000fca00078e0225ULL, 0x0124001e25008388ULL, 0x0005e20000000800ULL,
0x000000ff1d00720cULL, 0x000fda0003f05270ULL, 0x000005e000008947ULL, 0x000fea0003800000ULL,
0x000000081e087221ULL, 0x004fe20000010100ULL, 0x000000ff1dff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b08087820ULL, 0x000fc80000410000ULL,
0x0000000800277308ULL, 0x000ea40000000800ULL, 0x0000002722227220ULL, 0x004fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff267819ULL, 0x000fe20000011617ULL,
0x000138127f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0004e400000e0000ULL,
0x0000002664647220ULL, 0x08cfe20000410000ULL, 0x0000002665657220ULL, 0x080fe20000410000ULL,
0x0000002660607220ULL, 0x080fe20000410000ULL, 0x0000002661617220ULL, 0x080fe20000410000ULL,
0x000000265c5c7220ULL, 0x080fe20000410000ULL, 0x000000265d5d7220ULL, 0x080fe20000410000ULL,
0x0000002658587220ULL, 0x080fe20000410000ULL, 0x0000002659597220ULL, 0x080fe20000410000ULL,
0x0000002654547220ULL, 0x080fe20000410000ULL, 0x0000002655557220ULL, 0x080fe20000410000ULL,
0x0000002650507220ULL, 0x080fe20000410000ULL, 0x0000002651517220ULL, 0x080fe20000410000ULL,
0x000000264c4c7220ULL, 0x080fe20000410000ULL, 0x000000264d4d7220ULL, 0x080fe20000410000ULL,
0x0000002648487220ULL, 0x080fe20000410000ULL, 0x0000002649497220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff001dff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000817267811ULL, 0x000fe200078ff0ffULL, 0x000136d27f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0004e400000e0000ULL, 0x0000002666667220ULL, 0x08cfe20000410000ULL,
0x0000002667677220ULL, 0x080fe20000410000ULL, 0x0000002662627220ULL, 0x080fe20000410000ULL,
0x0000002663637220ULL, 0x080fe20000410000ULL, 0x000000265e5e7220ULL, 0x080fe20000410000ULL,
0x000000265f5f7220ULL, 0x080fe20000410000ULL, 0x000000265a5a7220ULL, 0x080fe20000410000ULL,
0x000000265b5b7220ULL, 0x080fe20000410000ULL, 0x0000002656567220ULL, 0x080fe20000410000ULL,
0x0000002657577220ULL, 0x080fe20000410000ULL, 0x0000002652527220ULL, 0x080fe20000410000ULL,
0x0000002653537220ULL, 0x080fe20000410000ULL, 0x000000264e4e7220ULL, 0x080fe20000410000ULL,
0x000000264f4f7220ULL, 0x080fe20000410000ULL, 0x000000264a4a7220ULL, 0x080fe20000410000ULL,
0x000000264b4b7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff00001dff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001017267811ULL, 0x000fe200078ff0ffULL,
0x000135927f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0004e400000e0000ULL,
0x0000002644447220ULL, 0x08cfe20000410000ULL, 0x0000002645457220ULL, 0x080fe20000410000ULL,
0x0000002640407220ULL, 0x080fe20000410000ULL, 0x0000002641417220ULL, 0x080fe20000410000ULL,
0x000000263c3c7220ULL, 0x080fe20000410000ULL, 0x000000263d3d7220ULL, 0x080fe20000410000ULL,
0x0000002638387220ULL, 0x080fe20000410000ULL, 0x0000002639397220ULL, 0x080fe20000410000ULL,
0x0000002634347220ULL, 0x080fe20000410000ULL, 0x0000002635357220ULL, 0x080fe20000410000ULL,
0x0000002630307220ULL, 0x080fe20000410000ULL, 0x0000002631317220ULL, 0x080fe20000410000ULL,
0x000000262c2c7220ULL, 0x080fe20000410000ULL, 0x000000262d2d7220ULL, 0x080fe20000410000ULL,
0x0000002628287220ULL, 0x080fe20000410000ULL, 0x0000002629297220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff0000001dff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001817267811ULL, 0x000fe200078ff0ffULL,
0x000134627f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0004e400000e0000ULL,
0x0000002646467220ULL, 0x08cfe20000410000ULL, 0x0000002647477220ULL, 0x080fe20000410000ULL,
0x0000002642427220ULL, 0x080fe20000410000ULL, 0x0000002643437220ULL, 0x080fe20000410000ULL,
0x000000263e3e7220ULL, 0x080fe20000410000ULL, 0x000000263f3f7220ULL, 0x080fe20000410000ULL,
0x000000263a3a7220ULL, 0x080fe20000410000ULL, 0x000000263b3b7220ULL, 0x080fe20000410000ULL,
0x0000002636367220ULL, 0x080fe20000410000ULL, 0x0000002637377220ULL, 0x080fe20000410000ULL,
0x0000002632327220ULL, 0x080fe20000410000ULL, 0x0000002633337220ULL, 0x080fe20000410000ULL,
0x000000262e2e7220ULL, 0x080fe20000410000ULL, 0x000000262f2f7220ULL, 0x080fe20000410000ULL,
0x000000262a2a7220ULL, 0x080fe20000410000ULL, 0x000000262b2b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000001d00ff7212ULL, 0x000fda00078030ffULL,
0x8000001e03030221ULL, 0x000fe20000010000ULL, 0x00007610ff240816ULL, 0x000fc60000000024ULL,
0x3fb8aa3b03030820ULL, 0x000fc80000410000ULL, 0x0000000300090308ULL, 0x000ea40000000800ULL,
0x0000000902020220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002202227221ULL, 0x002fc40000010000ULL, 0x0000000000027805ULL, 0x000fca0000015200ULL,
0x0126ac001f007984ULL, 0x000e620000000800ULL, 0x000126a81f087810ULL, 0x000fe40007ffe0ffULL,
0x8000000000ff7812ULL, 0x002fe2000780486dULL, 0x0000000000007918ULL, 0x000fd40000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff267224ULL, 0x000fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000102600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001c7805ULL, 0x000fcc0000015200ULL, 0x0000001c02257210ULL, 0x000fca0007f1e1ffULL,
0x000000011d1d7824ULL, 0x000fe200000e0e03ULL, 0x003d09002500780cULL, 0x000fc80003f06070ULL,
0x000000ff1d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402500780cULL, 0x000fc80003f06070ULL, 0x000000ff1d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc8000001141dULL,
0x0000002500007211ULL, 0x000fca00078110ffULL, 0x000000ffff1d7224ULL, 0x000fca00000e061dULL,
0x0000000200007819ULL, 0x000fc8000000121dULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000126267810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0126ac001f007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe4000780486dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991024007816ULL, 0x000fe200000000ffULL,
0x0000010000007945ULL, 0x000fe60003800000ULL, 0x000000ff0000720cULL, 0x000fda0003f05270ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000009ff00723eULL, 0x000fe400000000ffULL,
0x00000002ff027819ULL, 0x000fe40000011617ULL, 0x0000541000277816ULL, 0x000fe20000000000ULL,
0x000130127f007947ULL, 0x000fea000b800000ULL, 0x00001f0227077589ULL, 0x0002a400000e0000ULL,
0x0000000802267810ULL, 0x000fe20007ffe0ffULL, 0x000130327f007947ULL, 0x000fea000b800000ULL,
0x0000001002007810ULL, 0x000fe20007ffe0ffULL, 0x00001f2627067589ULL, 0x00066800000e0000ULL,
0x00001f0027057589ULL, 0x0006a400000e0000ULL, 0x0000001802267810ULL, 0x008fe20007ffe0ffULL,
0x000130627f007947ULL, 0x000fea000b800000ULL, 0x00001f2627047589ULL, 0x0006a400000e0000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000413767824ULL, 0x000fe200078e00ffULL,
0x0000000817007812ULL, 0x000fe200078ec0ffULL, 0x000004001a1d7824ULL, 0x000fe200078e00ffULL,
0x00000004ff7c7819ULL, 0x100fe20000011617ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000476767812ULL, 0x000fe200078ec0ffULL, 0x000001f000007945ULL, 0x000fe20003800000ULL,
0x0000000700037812ULL, 0x000fc400078ef817ULL, 0x0000007617007211ULL, 0x000fe400078fe0ffULL,
0x0000001003027812ULL, 0x042fe200078efcffULL, 0x00000008031f7824ULL, 0x000fe200078e00ffULL,
0xfffff0001d1d7812ULL, 0x000fe200078ec0ffULL, 0x00000001031c7824ULL, 0x000fe400078e0200ULL,
0x0000000100007824ULL, 0x000fe200078e0202ULL, 0x0000a0001d7d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000802257824ULL, 0x000fe200078e00ffULL, 0xfffffff81f1c7812ULL, 0x000fe200078ee21cULL,
0x00000004111f7824ULL, 0x000fc400078e027cULL, 0x0000000803277824ULL, 0x008fe200078e00ffULL,
0xfffffff8251d7812ULL, 0x000fe200078ee200ULL, 0x00000001036c7824ULL, 0x000fe200078e021fULL,
0x0000e00013007811ULL, 0x000fe200078e68ffULL, 0x000000101c687824ULL, 0x100fe400078e027dULL,
0x000000101d247824ULL, 0x000fe200078e027dULL, 0xfffffff827257812ULL, 0x000fc600078ee26cULL,
0x000000006868783bULL, 0x000e640000000200ULL, 0x0000001025707824ULL, 0x000fe400078e0200ULL,
0x000000002424783bULL, 0x000ee20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000768687232ULL, 0x086fe40000000000ULL, 0x000000076a6a7232ULL, 0x000fe40000000000ULL,
0x0000000669697232ULL, 0x080fe40000000000ULL, 0x000000066b6b7232ULL, 0x000fc40000000000ULL,
0x0000000524247232ULL, 0x088fe40000000000ULL, 0x0000000526267232ULL, 0x000fe40000000000ULL,
0x0000000425257232ULL, 0x080fe40000000000ULL, 0x0000000427277232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000008036d7824ULL, 0x000fe200078e00ffULL,
0x000000026c6c7810ULL, 0x000fe20007ffe0ffULL, 0x000000007070783bULL, 0x000f220000004200ULL,
0x00000001021f7824ULL, 0x000fe200078e021fULL, 0x000008d000007945ULL, 0x000fe20003800000ULL,
0xfffffff86d6d7812ULL, 0x000fca00078ee26cULL, 0x000000106d6d7824ULL, 0x000fca00078e0200ULL,
0x000000006d78783bULL, 0x000ee20000004200ULL, 0x00000010ff6c7819ULL, 0x010fe40000011670ULL,
0x00000010ff807819ULL, 0x000fe40000011671ULL, 0x000000ff707f7812ULL, 0x000fe400078ec0ffULL,
0x000000ff6c6c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff71817812ULL, 0x000fe400078ec0ffULL,
0x000000ff80807812ULL, 0x000fc400078ec0ffULL, 0x00000018ff7e7819ULL, 0x000fe40000011670ULL,
0x0000ffff70927812ULL, 0x000fe400078ec0ffULL, 0x00000018ff707819ULL, 0x000fe40000011671ULL,
0x0000007fff7f723eULL, 0x000fe400020006ffULL, 0x0000006cff6c723eULL, 0x000fe400020006ffULL,
0x0000ffff79977812ULL, 0x008fc400078ec0ffULL, 0x0000ffff71937812ULL, 0x000fe400078ec0ffULL,
0x00000010ff877819ULL, 0x100fe40000011678ULL, 0x000000ff78897812ULL, 0x040fe400078ec0ffULL,
0x00000018ff887819ULL, 0x000fe40000011678ULL, 0x0000ffff78967812ULL, 0x000fe400078ec0ffULL,
0x00000081ff6d723eULL, 0x000fc400020006ffULL, 0x00000080ff80723eULL, 0x000fe400020006ffULL,
0x00000010ff827819ULL, 0x100fe40000011672ULL, 0x000000ff72837812ULL, 0x040fe400078ec0ffULL,
0x00000018ff717819ULL, 0x000fe40000011672ULL, 0x0000ffff72947812ULL, 0x000fe400078ec0ffULL,
0x00000018ff787819ULL, 0x000fc40000011679ULL, 0x00000070ff72723eULL, 0x000fe400020006ffULL,
0x000054107f6c7816ULL, 0x000fe4000000006cULL, 0x0000ffff73957812ULL, 0x000fe400078ec0ffULL,
0x00000008ff707819ULL, 0x000fe40000011692ULL, 0x00000008ff7f7819ULL, 0x000fe40000011697ULL,
0x000054106d6d7816ULL, 0x000fc40000000080ULL, 0x00000010ff8a7819ULL, 0x000fe40000011679ULL,
0x000000ff798b7812ULL, 0x000fe400078ec0ffULL, 0x00000078ff80723eULL, 0x000fe200020006ffULL,
0x0000006c6864723cULL, 0x002f620000001864ULL, 0x00000010ff8c7819ULL, 0x100fe4000001167aULL,
0x000000ff7a8e7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff8d7819ULL, 0x000fc4000001167aULL,
0x0000ffff7a987812ULL, 0x000fe200078ec0ffULL, 0x0000006c2444723cULL, 0x000b620000001844ULL,
0x00000071ff79723eULL, 0x000fe400020006ffULL, 0x00000008ff787819ULL, 0x000fe40000011694ULL,
0x00000018ff857819ULL, 0x000fe40000011673ULL, 0x0000007eff7e723eULL, 0x000fe200020006ffULL,
0x00000008026c7824ULL, 0x020fe200078e00ffULL, 0x00000008ff717819ULL, 0x000fc40000011693ULL,
0x00000070ff70723eULL, 0x000fe400020006ffULL, 0x00000008ff7a7819ULL, 0x000fe40000011695ULL,
0x0000007fff7f723eULL, 0x000fe400020006ffULL, 0x00000010ff847819ULL, 0x000fe40000011673ULL,
0x00000010ff8f7819ULL, 0x000fe4000001167bULL, 0x0000ffff7b997812ULL, 0x000fc400078ec0ffULL,
0x00000078ff78723eULL, 0x000fe400020006ffULL, 0x00000085ff85723eULL, 0x000fe400020006ffULL,
0x00000071ff71723eULL, 0x000fe400020006ffULL, 0x0000541070707816ULL, 0x000fe4000000007eULL,
0x0000007aff7a723eULL, 0x000fe400020006ffULL, 0x000054107f7f7816ULL, 0x000fc40000000080ULL,
0x000000ff73867812ULL, 0x000fe400078ec0ffULL, 0x000000ff7b917812ULL, 0x000fe400078ec0ffULL,
0x00000018ff907819ULL, 0x000fe4000001167bULL, 0x000000ff82827812ULL, 0x000fe400078ec0ffULL,
0x000000ff84847812ULL, 0x000fe400078ec0ffULL, 0x000000ff87877812ULL, 0x000fc400078ec0ffULL,
0x000000ff8a8a7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff7e7819ULL, 0x000fe40000011696ULL,
0x000000ff8c8c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff8f8f7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff807819ULL, 0x000fe40000011698ULL, 0x00000008ff817819ULL, 0x000fc40000011699ULL,
0x0000541078787816ULL, 0x000fe40000000079ULL, 0x0000541071717816ULL, 0x000fe40000000072ULL,
0x000054107a797816ULL, 0x000fe40000000085ULL, 0x00000083ff83723eULL, 0x000fe400020006ffULL,
0x00000086ff73723eULL, 0x000fe200020006ffULL, 0x000000706860723cULL, 0x000f620000001860ULL,
0x00000089ff89723eULL, 0x000fc400020006ffULL, 0x0000008bff7b723eULL, 0x000fe400020006ffULL,
0x00000088ff88723eULL, 0x000fe400020006ffULL, 0x00000082ff72723eULL, 0x000fe200020006ffULL,
0x000000786858723cULL, 0x000f620000001858ULL, 0x00000084ff84723eULL, 0x000fe400020006ffULL,
0x0000008eff8e723eULL, 0x000fe400020006ffULL, 0x00000087ff7a723eULL, 0x000fc400020006ffULL,
0x0000008aff8a723eULL, 0x000fe200020006ffULL, 0x000000702440723cULL, 0x040f620000001840ULL,
0x00000091ff91723eULL, 0x000fe400020006ffULL, 0x0000007eff7e723eULL, 0x000fe400020006ffULL,
0x0000008dff8d723eULL, 0x000fe400020006ffULL, 0x0000008cff8c723eULL, 0x000fe200020006ffULL,
0x000000782438723cULL, 0x000f620000001838ULL, 0x0000008fff8f723eULL, 0x000fc400020006ffULL,
0x00000090ff90723eULL, 0x000fe400020006ffULL, 0x00000080ff80723eULL, 0x000fe400020006ffULL,
0x00000081ff81723eULL, 0x000fe400020006ffULL, 0x0000541083727816ULL, 0x000fe40000000072ULL,
0x0000541073737816ULL, 0x000fe40000000084ULL, 0x00005410897a7816ULL, 0x000fc4000000007aULL,
0x000054107b7b7816ULL, 0x000fe4000000008aULL, 0x000054107e7e7816ULL, 0x000fe20000000088ULL,
0x00000072685c723cULL, 0x040f62000000185cULL, 0x000054108e8e7816ULL, 0x000fe4000000008cULL,
0x00005410918f7816ULL, 0x000fe4000000008fULL, 0x0000541080807816ULL, 0x000fe4000000008dULL,
0x0000541081817816ULL, 0x000fe20000000090ULL, 0x0000007a6854723cULL, 0x040f700000001854ULL,
0x0000007e6850723cULL, 0x040f700000001850ULL, 0x0000008e684c723cULL, 0x040f70000000184cULL,
0x000000806848723cULL, 0x000b6e0000001848ULL, 0x0000000276697812ULL, 0x020fe200078efcffULL,
0x00000008036b7824ULL, 0x000fe200078e00ffULL, 0x00000072243c723cULL, 0x000f62000000183cULL,
0x00000008026a7824ULL, 0x000fc400078e00ffULL, 0x000000017c697824ULL, 0x000fc800078e0269ULL,
0x0000000103687824ULL, 0x100fe200078e0269ULL, 0x0000007a2434723cULL, 0x000f620000001834ULL,
0x0000000102697824ULL, 0x000fc600078e0269ULL, 0xfffffff86b687812ULL, 0x000fe400078ee268ULL,
0xfffffff86a6a7812ULL, 0x000fe400078ee269ULL, 0xfffffff86c697812ULL, 0x000fe200078ee21fULL,
0x0000001068687824ULL, 0x100fe200078e027dULL, 0x0000007e2430723cULL, 0x040f620000001830ULL,
0x000000106a7d7824ULL, 0x000fe400078e027dULL, 0x0000001069707824ULL, 0x000fe400078e0200ULL,
0x000000006868783bULL, 0x000e660000000200ULL, 0x0000008e242c723cULL, 0x040f70000000182cULL,
0x000000802428723cULL, 0x000b640000001828ULL, 0x000000007d24783bULL, 0x0206a20000000200ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x0000008000000947ULL, 0x000fde0003800000ULL,
0x0000000768687232ULL, 0x086fe40000000000ULL, 0x000000076a6a7232ULL, 0x000fc40000000000ULL,
0x0000000669697232ULL, 0x080fe40000000000ULL, 0x000000066b6b7232ULL, 0x000fe40000000000ULL,
0x0000000524247232ULL, 0x080fe40000000000ULL, 0x0000000526267232ULL, 0x000fe40000000000ULL,
0x0000000425257232ULL, 0x080fe40000000000ULL, 0x0000000427277232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000008026c7824ULL, 0x000fe200078e00ffULL,
0x000000021f1f7810ULL, 0x000fe20007ffe0ffULL, 0x000000007070783bULL, 0x000f260000004200ULL,
0xfffffff86c1f7812ULL, 0x000fca00078ee21fULL, 0x000000101f1f7824ULL, 0x000fca00078e0200ULL,
0x000000001f78783bULL, 0x0006a20000004200ULL, 0x00000010ff6c7819ULL, 0x010fe40000011670ULL,
0x00000018ff1f7819ULL, 0x008fe40000011672ULL, 0x0000ffff708d7812ULL, 0x040fe400078ec0ffULL,
0x000000ff70767812ULL, 0x000fe400078ec0ffULL, 0x000000ff6c6c7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff6d7819ULL, 0x000fc40000011670ULL, 0x00000010ff7c7819ULL, 0x000fe40000011671ULL,
0x00000010ff827819ULL, 0x104fe40000011678ULL, 0x000000ff78847812ULL, 0x040fe400078ec0ffULL,
0x00000018ff837819ULL, 0x000fe40000011678ULL, 0x0000ffff78917812ULL, 0x000fe400078ec0ffULL,
0x00000010ff857819ULL, 0x000fc40000011679ULL, 0x000000ff79867812ULL, 0x040fe400078ec0ffULL,
0x00000018ff787819ULL, 0x000fe40000011679ULL, 0x0000ffff79927812ULL, 0x000fe400078ec0ffULL,
0x00000018ff707819ULL, 0x000fe40000011671ULL, 0x0000001fff79723eULL, 0x000fe400020006ffULL,
0x00000008ff1f7819ULL, 0x000fc4000001168dULL, 0x00000010ff7e7819ULL, 0x000fe40000011672ULL,
0x000000ff727f7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff728f7812ULL, 0x000fe400078ec0ffULL,
0x00000076ff76723eULL, 0x000fe400020006ffULL, 0x0000006cff6c723eULL, 0x000fe400020006ffULL,
0x00000010ff807819ULL, 0x000fc40000011673ULL, 0x000000ff73817812ULL, 0x040fe400078ec0ffULL,
0x00000018ff727819ULL, 0x000fe40000011673ULL, 0x0000ffff73907812ULL, 0x000fe400078ec0ffULL,
0x00000070ff73723eULL, 0x000fe400020006ffULL, 0x000000ff7c7c7812ULL, 0x000fe400078ec0ffULL,
0x0000001fff70723eULL, 0x000fc400020006ffULL, 0x000000ff717d7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff718e7812ULL, 0x000fe400078ec0ffULL, 0x00005410766c7816ULL, 0x000fe4000000006cULL,
0x00000008ff1f7819ULL, 0x000fe4000001168fULL, 0x0000006dff71723eULL, 0x000fe400020006ffULL,
0x00000008ff767819ULL, 0x000fc40000011690ULL, 0x0000007cff6d723eULL, 0x000fe400020006ffULL,
0x00000078ff7c723eULL, 0x000fe400020006ffULL, 0x00000010ff877819ULL, 0x100fe4000001167aULL,
0x000000ff7a897812ULL, 0x040fe400078ec0ffULL, 0x00000018ff887819ULL, 0x000fe4000001167aULL,
0x0000ffff7a937812ULL, 0x000fc400078ec0ffULL, 0x0000001fff78723eULL, 0x000fe400020006ffULL,
0x00000072ff7a723eULL, 0x000fe400020006ffULL, 0x00000076ff76723eULL, 0x000fe400020006ffULL,
0x00000008ff1f7819ULL, 0x000fe40000011691ULL, 0x0000541078787816ULL, 0x000fe40000000079ULL,
0x0000541076797816ULL, 0x000fc4000000007aULL, 0x00000008ff767819ULL, 0x000fe40000011692ULL,
0x00000008ff727819ULL, 0x000fe4000001168eULL, 0x00000083ff83723eULL, 0x000fe200020006ffULL,
0x000000782438723cULL, 0x000f620000001838ULL, 0x0000001fff1f723eULL, 0x000fe400020006ffULL,
0x000000ff87877812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8a7819ULL, 0x000fc4000001167bULL,
0x0000ffff7b947812ULL, 0x040fe200078ec0ffULL, 0x000000786858723cULL, 0x002f620000001858ULL,
0x000000ff7b8c7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff8b7819ULL, 0x000fe4000001167bULL,
0x00000076ff7b723eULL, 0x000fe400020006ffULL, 0x0000007dff7d723eULL, 0x000fe400020006ffULL,
0x00000072ff72723eULL, 0x000fc400020006ffULL, 0x00000089ff89723eULL, 0x000fe400020006ffULL,
0x000054101f7a7816ULL, 0x000fe40000000083ULL, 0x00000087ff87723eULL, 0x000fe400020006ffULL,
0x000000ff7e7e7812ULL, 0x000fe400078ec0ffULL, 0x000000ff80807812ULL, 0x000fe400078ec0ffULL,
0x000000ff82827812ULL, 0x000fc400078ec0ffULL, 0x000000ff85857812ULL, 0x000fe400078ec0ffULL,
0x000000ff8a8a7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff1f7819ULL, 0x000fe40000011693ULL,
0x00000008ff767819ULL, 0x000fe40000011694ULL, 0x0000541070707816ULL, 0x000fe40000000071ULL,
0x000054107b7b7816ULL, 0x000fc4000000007cULL, 0x000054107d6d7816ULL, 0x000fe4000000006dULL,
0x0000541072717816ULL, 0x000fe40000000073ULL, 0x00005410897c7816ULL, 0x000fe20000000087ULL,
0x0000007a2430723cULL, 0x000f620000001830ULL, 0x0000007fff7f723eULL, 0x000fe400020006ffULL,
0x00000081ff81723eULL, 0x000fe400020006ffULL, 0x00000084ff84723eULL, 0x000fc400020006ffULL,
0x00000086ff86723eULL, 0x000fe200020006ffULL, 0x0000006c2444723cULL, 0x040f620000001844ULL,
0x0000007eff72723eULL, 0x000fe400020006ffULL, 0x00000080ff73723eULL, 0x000fe400020006ffULL,
0x00000082ff82723eULL, 0x000fe400020006ffULL, 0x00000085ff85723eULL, 0x000fe200020006ffULL,
0x000000702440723cULL, 0x000f620000001840ULL, 0x0000008cff7d723eULL, 0x000fc400020006ffULL,
0x00000088ff88723eULL, 0x000fe400020006ffULL, 0x0000008aff8a723eULL, 0x000fe400020006ffULL,
0x0000008bff8b723eULL, 0x000fe200020006ffULL, 0x0000006c6864723cULL, 0x000f620000001864ULL,
0x0000001fff1f723eULL, 0x000fe400020006ffULL, 0x00000076ff89723eULL, 0x000fe400020006ffULL,
0x000054107f727816ULL, 0x000fc40000000072ULL, 0x0000541081737816ULL, 0x000fe20000000073ULL,
0x000000706860723cULL, 0x000f620000001860ULL, 0x0000541084847816ULL, 0x000fe40000000082ULL,
0x0000541086857816ULL, 0x000fe40000000085ULL, 0x000054107d7d7816ULL, 0x000fe4000000008aULL,
0x000054101f887816ULL, 0x000fe20000000088ULL, 0x00000072243c723cULL, 0x000f62000000183cULL,
0x0000541089897816ULL, 0x000fe2000000008bULL, 0x000000021a1f7824ULL, 0x000fca00078e00ffULL,
0xfffffff81f1f7812ULL, 0x000fe200078ec0ffULL, 0x000000842434723cULL, 0x040f700000001834ULL,
0x0000007c242c723cULL, 0x040f70000000182cULL, 0x000000882428723cULL, 0x000f700000001828ULL,
0x00000072685c723cULL, 0x040f70000000185cULL, 0x000000846854723cULL, 0x040f700000001854ULL,
0x0000007a6850723cULL, 0x040f700000001850ULL, 0x0000007c684c723cULL, 0x040f70000000184cULL,
0x000000886848723cULL, 0x000b6e0000001848ULL, 0x000126c813687811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x0000000068687f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x012688001fff7f8cULL, 0x0005e4000c80043fULL,
0x0000000000247805ULL, 0x000fc40000015200ULL, 0x000004000d1f7984ULL, 0x004ea40000000800ULL,
0x800000001fff7812ULL, 0x006fc40007804869ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff6a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000106a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624267210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09002600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1f7819ULL, 0x000fc80000011427ULL, 0x000000261f1f7211ULL, 0x000fca00078110ffULL,
0x000000ffff267224ULL, 0x000fca00000e0627ULL, 0x000000021f1f7819ULL, 0x000fc80000001226ULL,
0x0000001f0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000016a6a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004000d1f7984ULL, 0x000e640000000800ULL, 0x800000001fff7812ULL, 0x002fe40007804869ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000800c257810ULL, 0x000fca0007ffe0ffULL,
0x00006600126c7a24ULL, 0x000fe200078e0225ULL, 0x000003d00000a947ULL, 0x000fea0003800000ULL,
0x00000025161f7217ULL, 0x000fe20007800000ULL, 0x0000001011707824ULL, 0x000fe200078e00ffULL,
0x00000003ff277819ULL, 0x000fc60000011617ULL, 0x000000011f1f7824ULL, 0x000fe200078e0a25ULL,
0x0000000427697810ULL, 0x040fe20007ffe0ffULL, 0x0000000170247824ULL, 0x040fe200078e0227ULL,
0x00000008276b7810ULL, 0x040fe40007ffe0ffULL, 0x0000001f701f7217ULL, 0x000fe20007800000ULL,
0x0000000124257824ULL, 0x040fe200078e0217ULL, 0x0000000c27737810ULL, 0x000fe20007ffe0ffULL,
0x0000000824267824ULL, 0x000fe400078e00ffULL, 0x0000000170717824ULL, 0x000fc400078e0269ULL,
0x0000000124247824ULL, 0x000fe200078e026cULL, 0xfffffff8266d7812ULL, 0x000fe200078ee225ULL,
0x000000011f1f7824ULL, 0x000fe400078e0a70ULL, 0x0000000171267824ULL, 0x000fe400078e026cULL,
0x0000008024247825ULL, 0x000fe200078e00ffULL, 0x0000001f2700720cULL, 0x080fe40003f06070ULL,
0x0000001f6900720cULL, 0x000fe20003f86070ULL, 0x0000000170727824ULL, 0x000fe200078e026bULL,
0x0000000b246a7212ULL, 0x000fe200078efcffULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x0000001f6b00720cULL, 0x000fc40003f66070ULL, 0x000062006a6a7a10ULL, 0x000fe20007fbe0ffULL,
0x0000000170707824ULL, 0x000fe200078e0273ULL, 0x0000000b26267212ULL, 0x000fe200078efcffULL,
0x0000000172687824ULL, 0x100fe200078e026cULL, 0x00006300256b7a10ULL, 0x000fe20002ffe4ffULL,
0x0000000170247824ULL, 0x000fe200078e026cULL, 0x0000620026267a10ULL, 0x000fe20007fde0ffULL,
0x0000008068687825ULL, 0x000fe200078e00ffULL, 0x0000001f7300720cULL, 0x000fe40003fa6070ULL,
0x0000630027277a10ULL, 0x000fe200037fe4ffULL, 0x00000001716c7824ULL, 0x040fe200078e0217ULL,
0x0000000b68687212ULL, 0x000fe200078efcffULL, 0x0000000871717824ULL, 0x000fc400078e00ffULL,
0x0000008024247825ULL, 0x000fe200078e00ffULL, 0x0000620068687a10ULL, 0x000fe40007fde0ffULL,
0xfffffff8711f7812ULL, 0x000fe200078ee26cULL, 0x00000001726c7824ULL, 0x100fe200078e0217ULL,
0x0000000b24247212ULL, 0x000fe200078efcffULL, 0x0000000872717824ULL, 0x000fe200078e00ffULL,
0x0000630069697a10ULL, 0x000fe200037fe4ffULL, 0x0000000170727824ULL, 0x000fe200078e0217ULL,
0x0000620024247a10ULL, 0x000fe20007fde0ffULL, 0x0000000870737824ULL, 0x000fe200078e00ffULL,
0xfffffff871717812ULL, 0x000fe200078ee26cULL, 0x000000106d6d7824ULL, 0x100fe200078e0200ULL,
0x0000630025257a10ULL, 0x000fe200037fe4ffULL, 0x000000101f1f7824ULL, 0x000fe200078e0200ULL,
0xfffffff873737812ULL, 0x000fe200078ee272ULL, 0x0000001071717824ULL, 0x100fe200078e0200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000006a6d7faeULL, 0x0003e6000c101c48ULL,
0x0000001073737824ULL, 0x000fe200078e0200ULL, 0x00000000261f7faeULL, 0x0003e8000e101c48ULL,
0x0000000068717faeULL, 0x0003e8000d901c48ULL, 0x0000000024737faeULL, 0x0003e2000e901c48ULL,
0x0000030000007947ULL, 0x000fea0003800000ULL, 0x0000001011247824ULL, 0x000fca00078e00ffULL,
0x00000024171f7211ULL, 0x000fc800078fe8ffULL, 0x000000041f267810ULL, 0x040fe20007ffe0ffULL,
0x000000011f247824ULL, 0x140fe200078e0217ULL, 0x000000081f687810ULL, 0x040fe20007ffe0ffULL,
0x000000081f6d7824ULL, 0x000fe400078e00ffULL, 0x0000000126257824ULL, 0x140fe400078e0217ULL,
0x00000008266a7824ULL, 0x000fe200078e00ffULL, 0xfffffff86d6d7812ULL, 0x000fe200078ee224ULL,
0x000000011f247824ULL, 0x040fe200078e026cULL, 0x0000000c1f1f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000168277824ULL, 0x000fe200078e0217ULL, 0xfffffff86a717812ULL, 0x000fe200078ee225ULL,
0x0000000868707824ULL, 0x000fc400078e00ffULL, 0x0000000126267824ULL, 0x000fe400078e026cULL,
0x0000008024247825ULL, 0x000fe200078e00ffULL, 0xfffffff870737812ULL, 0x000fc600078ee227ULL,
0x0000000168687824ULL, 0x100fe200078e026cULL, 0x0000000b24247212ULL, 0x000fe200078efcffULL,
0x000000011f6a7824ULL, 0x000fe400078e026cULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x0000620024247a10ULL, 0x000fc60007f1e0ffULL, 0x0000008068687825ULL, 0x000fe200078e00ffULL,
0x0000000b26267212ULL, 0x080fe400078efcffULL, 0x0000630025257a10ULL, 0x000fe200007fe4ffULL,
0x000000806a6a7825ULL, 0x000fe200078e00ffULL, 0x0000000b68687212ULL, 0x080fe400078efcffULL,
0x0000620026267a10ULL, 0x000fe20007f7e0ffULL, 0x000000011f6c7824ULL, 0x040fe200078e0217ULL,
0x0000000b6a6a7212ULL, 0x000fe200078efcffULL, 0x000000081f1f7824ULL, 0x000fe200078e00ffULL,
0x0000620068687a10ULL, 0x000fe20007f1e0ffULL, 0x000000106d6d7824ULL, 0x100fe200078e0200ULL,
0x000062006a6a7a10ULL, 0x000fe20007f9e0ffULL, 0x0000001071717824ULL, 0x000fe200078e0200ULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee26cULL, 0x0000001073737824ULL, 0x100fe200078e0200ULL,
0x0000630027277a10ULL, 0x000fe20001ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000246d7faeULL, 0x0003e2000b901c48ULL, 0x0000630069697a10ULL, 0x000fe200007fe4ffULL,
0x000000101f1f7824ULL, 0x000fe200078e0200ULL, 0x000063006b6b7a10ULL, 0x000fe200027fe4ffULL,
0x0000000026717faeULL, 0x0003e8000b901c48ULL, 0x0000000068737faeULL, 0x0003e8000b901c48ULL,
0x000000006a1f7faeULL, 0x0003e4000b901c48ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fda0003f0f070ULL,
0x00000000080503c2ULL, 0x000e640000020000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0099b0ULL, 0x002fe20008000a05ULL,
0x000000000000081cULL, 0x000fe20000f0f070ULL, 0xffffff8000001947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000086c7f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0126280023687f8cULL, 0x000664000c80043fULL,
0x0000000000247805ULL, 0x000fc40000015200ULL, 0xffffffe0141f7812ULL, 0x040fe400078ec0ffULL,
0x0000001014267812ULL, 0x000fca00078ec0ffULL, 0x000000011f267824ULL, 0x000fc800078e0226ULL,
0x00000008116a7824ULL, 0x000fca00078e0226ULL, 0x01262c006a1f7984ULL, 0x000f240000000800ULL,
0x800000001fff7812ULL, 0x012fe40007804869ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff6b7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000106b00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624267210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09002600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1f7819ULL, 0x000fc80000011427ULL, 0x000000261f1f7211ULL, 0x000fca00078110ffULL,
0x000000ffff267224ULL, 0x000fca00000e0627ULL, 0x000000021f1f7819ULL, 0x000fc80000001226ULL,
0x0000001f0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000016b6b7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01262c006a1f7984ULL, 0x000e640000000800ULL, 0x800000001fff7812ULL, 0x002fe40007804869ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000201a1f7824ULL, 0x000fca00078e00ffULL,
0xffffff801f247812ULL, 0x000fc800078ec0ffULL, 0x000000800b1f7810ULL, 0x000fca0007ffe024ULL,
0x000000010a1f7824ULL, 0x000fca00078e021fULL, 0x012000001f697984ULL, 0x000e680000000800ULL,
0x012200001f687984ULL, 0x0006a20000000800ULL, 0x0000001e6900720bULL, 0x002fe20003f1d000ULL,
0x00010f427f007947ULL, 0x000fd8000b800000ULL, 0x00000000001f7806ULL, 0x008fc800000e0100ULL,
0x000000ff1f00720cULL, 0x000fe20003f05270ULL, 0x0000076000007945ULL, 0x000fe20003800000ULL,
0x00000001ff257424ULL, 0x000fe400078e00ffULL, 0x000000ffff247224ULL, 0x000fd200078e001eULL,
0x0000072000008947ULL, 0x000fea0003800000ULL, 0x0000000110257810ULL, 0x000fe40007ffe0ffULL,
0x0000001e6900720bULL, 0x000fe40003f74000ULL, 0x0000001a2500720cULL, 0x000fe20003f05270ULL,
0x00010ef27f007947ULL, 0x000fd4000b800000ULL, 0x0000000000707806ULL, 0x000fc400018e0100ULL,
0x000000801a258824ULL, 0x000fe200078e020bULL, 0x0000001e69247209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x000000010a258824ULL, 0x000fca00078e0225ULL,
0x0124002425008388ULL, 0x0003e20000000800ULL, 0x000000ff7000720cULL, 0x000fda0003f05270ULL,
0x000005e000008947ULL, 0x000fea0003800000ULL, 0x0000001e241e7221ULL, 0x002fe20000010100ULL,
0x000000ff70ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b1e1e7820ULL, 0x000fc80000410000ULL, 0x0000001e00277308ULL, 0x000e640000000800ULL,
0x0000002722227220ULL, 0x002fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff267819ULL, 0x000fe20000011617ULL, 0x00010e327f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0002e400000e0000ULL, 0x0000002664647220ULL, 0x08cfe20000410000ULL,
0x0000002665657220ULL, 0x080fe20000410000ULL, 0x0000002660607220ULL, 0x080fe20000410000ULL,
0x0000002661617220ULL, 0x080fe20000410000ULL, 0x000000265c5c7220ULL, 0x080fe20000410000ULL,
0x000000265d5d7220ULL, 0x080fe20000410000ULL, 0x0000002658587220ULL, 0x080fe20000410000ULL,
0x0000002659597220ULL, 0x080fe20000410000ULL, 0x0000002654547220ULL, 0x080fe20000410000ULL,
0x0000002655557220ULL, 0x080fe20000410000ULL, 0x0000002650507220ULL, 0x080fe20000410000ULL,
0x0000002651517220ULL, 0x080fe20000410000ULL, 0x000000264c4c7220ULL, 0x080fe20000410000ULL,
0x000000264d4d7220ULL, 0x080fe20000410000ULL, 0x0000002648487220ULL, 0x080fe20000410000ULL,
0x0000002649497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0070ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000817267811ULL, 0x000fe200078ff0ffULL,
0x00010cf27f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x00066400000e0000ULL,
0x0000002666667220ULL, 0x086fe20000410000ULL, 0x0000002667677220ULL, 0x080fe20000410000ULL,
0x0000002662627220ULL, 0x080fe20000410000ULL, 0x0000002663637220ULL, 0x080fe20000410000ULL,
0x000000265e5e7220ULL, 0x080fe20000410000ULL, 0x000000265f5f7220ULL, 0x080fe20000410000ULL,
0x000000265a5a7220ULL, 0x080fe20000410000ULL, 0x000000265b5b7220ULL, 0x080fe20000410000ULL,
0x0000002656567220ULL, 0x080fe20000410000ULL, 0x0000002657577220ULL, 0x080fe20000410000ULL,
0x0000002652527220ULL, 0x080fe20000410000ULL, 0x0000002653537220ULL, 0x080fe20000410000ULL,
0x000000264e4e7220ULL, 0x080fe20000410000ULL, 0x000000264f4f7220ULL, 0x080fe20000410000ULL,
0x000000264a4a7220ULL, 0x080fe20000410000ULL, 0x000000264b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000070ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001017267811ULL, 0x000fe200078ff0ffULL, 0x00010bb27f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0002e400000e0000ULL, 0x0000002644447220ULL, 0x08cfe20000410000ULL,
0x0000002645457220ULL, 0x080fe20000410000ULL, 0x0000002640407220ULL, 0x080fe20000410000ULL,
0x0000002641417220ULL, 0x080fe20000410000ULL, 0x000000263c3c7220ULL, 0x080fe20000410000ULL,
0x000000263d3d7220ULL, 0x080fe20000410000ULL, 0x0000002638387220ULL, 0x080fe20000410000ULL,
0x0000002639397220ULL, 0x080fe20000410000ULL, 0x0000002634347220ULL, 0x080fe20000410000ULL,
0x0000002635357220ULL, 0x080fe20000410000ULL, 0x0000002630307220ULL, 0x080fe20000410000ULL,
0x0000002631317220ULL, 0x080fe20000410000ULL, 0x000000262c2c7220ULL, 0x080fe20000410000ULL,
0x000000262d2d7220ULL, 0x080fe20000410000ULL, 0x0000002628287220ULL, 0x080fe20000410000ULL,
0x0000002629297220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000070ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001817267811ULL, 0x000fe200078ff0ffULL, 0x00010a827f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0002e400000e0000ULL, 0x0000002646467220ULL, 0x08cfe20000410000ULL,
0x0000002647477220ULL, 0x080fe20000410000ULL, 0x0000002642427220ULL, 0x080fe20000410000ULL,
0x0000002643437220ULL, 0x080fe20000410000ULL, 0x000000263e3e7220ULL, 0x080fe20000410000ULL,
0x000000263f3f7220ULL, 0x080fe20000410000ULL, 0x000000263a3a7220ULL, 0x080fe20000410000ULL,
0x000000263b3b7220ULL, 0x080fe20000410000ULL, 0x0000002636367220ULL, 0x080fe20000410000ULL,
0x0000002637377220ULL, 0x080fe20000410000ULL, 0x0000002632327220ULL, 0x080fe20000410000ULL,
0x0000002633337220ULL, 0x080fe20000410000ULL, 0x000000262e2e7220ULL, 0x080fe20000410000ULL,
0x000000262f2f7220ULL, 0x080fe20000410000ULL, 0x000000262a2a7220ULL, 0x080fe20000410000ULL,
0x000000262b2b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x000000701fff7212ULL, 0x000fe200078030ffULL, 0x00000001ff257424ULL, 0x000fd800078e00ffULL,
0x8000002469690221ULL, 0x000fe20000010000ULL, 0x00007610ff250816ULL, 0x000fc60000000025ULL,
0x3fb8aa3b69690820ULL, 0x000fc80000410000ULL, 0x0000006900090308ULL, 0x000e640000000800ULL,
0x0000000968680220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002268227221ULL, 0x004fc20000010000ULL, 0x00000000001e7805ULL, 0x000fcc0000015200ULL,
0xfffffff0146a7812ULL, 0x000fca00078ec0ffULL, 0x0126b4006a277984ULL, 0x008e640000000800ULL,
0x8000000027ff7812ULL, 0x002fe40007804821ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff687224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000106800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x000000261e697210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e1fULL,
0x003d09006900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c406900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff267819ULL, 0x000fc80000011427ULL, 0x0000006926267211ULL, 0x000fca00078110ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x0000000226267819ULL, 0x000fc80000001227ULL,
0x000000260000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000168687810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0126b4006a277984ULL, 0x000e640000000800ULL, 0x8000000027ff7812ULL, 0x002fe40007804821ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009910251e7816ULL, 0x000fe200000000ffULL,
0x0000010000007945ULL, 0x000fe60003800000ULL, 0x000000ff1e00720cULL, 0x000fda0003f05270ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000009ff04723eULL, 0x000fe400000000ffULL,
0x00000002ff1e7819ULL, 0x000fe40000011617ULL, 0x0000541004277816ULL, 0x000fe20000000004ULL,
0x000106427f007947ULL, 0x000fea000b800000ULL, 0x00001f1e27077589ULL, 0x0002a400000e0000ULL,
0x000000081e267810ULL, 0x000fe20007ffe0ffULL, 0x000106627f007947ULL, 0x000fea000b800000ULL,
0x000000101e047810ULL, 0x000fe20007ffe0ffULL, 0x00001f2627067589ULL, 0x00066800000e0000ULL,
0x00001f0427057589ULL, 0x0006a400000e0000ULL, 0x000000181e267810ULL, 0x008fe20007ffe0ffULL,
0x000106927f007947ULL, 0x000fea000b800000ULL, 0x00001f2627047589ULL, 0x0006a400000e0000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000041a1e7824ULL, 0x042fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000004001a207824ULL, 0x040fe200078e00ffULL,
0x0000019000007945ULL, 0x000fe20003800000ULL, 0x000010001a1f7824ULL, 0x000fe200078e00ffULL,
0x000000041e1e7812ULL, 0x000fe200078ec0ffULL, 0x0000000803217824ULL, 0x000fe200078e00ffULL,
0xfffff00020207812ULL, 0x000fc400078ec0ffULL, 0x0000001e17257211ULL, 0x000fe400078fe0ffULL,
0x0000b00020207810ULL, 0x000fe40007ffe0ffULL, 0xffffe0001f1f7812ULL, 0x000fe200078ec0ffULL,
0x00000001031e7824ULL, 0x000fe400078e0225ULL, 0x000000101c707824ULL, 0x100fe200078e0220ULL,
0x0000f0001f1f7810ULL, 0x000fe20007ffe0ffULL, 0x000000101d1d7824ULL, 0x000fe200078e0220ULL,
0xfffffff8211c7812ULL, 0x000fc600078ee21eULL, 0x000000007070783bULL, 0x000e640000000200ULL,
0x000000101c787824ULL, 0x000fe400078e021fULL, 0x000000001d68783bULL, 0x0006a20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000770707232ULL, 0x086fe40000000000ULL,
0x0000000772727232ULL, 0x000fe40000000000ULL, 0x0000000671717232ULL, 0x080fe40000000000ULL,
0x0000000673737232ULL, 0x000fc40000000000ULL, 0x0000000568687232ULL, 0x080fe40000000000ULL,
0x000000056a6a7232ULL, 0x000fe40000000000ULL, 0x0000000469697232ULL, 0x080fe40000000000ULL,
0x000000046b6b7232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000007878783bULL, 0x000f220000004200ULL, 0x0000000803267824ULL, 0x008fe200078e00ffULL,
0x000000021e217810ULL, 0x000fe20007ffe0ffULL, 0x0000000102257824ULL, 0x000fe200078e0225ULL,
0x0000090000007945ULL, 0x000fe40003800000ULL, 0xfffffff826217812ULL, 0x000fca00078ee221ULL,
0x00000010217c7824ULL, 0x000fcc00078e021fULL, 0x000000007c7c783bULL, 0x000ee20000004200ULL,
0x00000010ff267819ULL, 0x110fe40000011679ULL, 0x00000010ff1d7819ULL, 0x000fe40000011678ULL,
0x00000018ff767819ULL, 0x000fe40000011679ULL, 0x000000ff79277812ULL, 0x040fe400078ec0ffULL,
0x0000ffff79917812ULL, 0x000fe400078ec0ffULL, 0x000000ff26267812ULL, 0x000fc400078ec0ffULL,
0x0000ffff78907812ULL, 0x040fe400078ec0ffULL, 0x00000018ff797819ULL, 0x100fe4000001167aULL,
0x000000ff781f7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff807819ULL, 0x000fe4000001167aULL,
0x000000ff7a817812ULL, 0x040fe400078ec0ffULL, 0x0000ffff7a927812ULL, 0x000fc400078ec0ffULL,
0x000000ff1d1d7812ULL, 0x000fe400078ec0ffULL, 0x00000076ff7a723eULL, 0x000fe400020006ffULL,
0x00000010ff827819ULL, 0x100fe4000001167bULL, 0x000000ff7b847812ULL, 0x040fe400078ec0ffULL,
0x00000018ff837819ULL, 0x000fe4000001167bULL, 0x0000ffff7b937812ULL, 0x000fc400078ec0ffULL,
0x00000026ff76723eULL, 0x000fe400020006ffULL, 0x00000018ff1e7819ULL, 0x000fe40000011678ULL,
0x00000079ff7b723eULL, 0x000fe400020006ffULL, 0x00000008ff267819ULL, 0x000fe40000011690ULL,
0x0000001fff1f723eULL, 0x000fe400020006ffULL, 0x0000001dff1d723eULL, 0x000fc400020006ffULL,
0x00000008ff797819ULL, 0x000fe40000011691ULL, 0x00000027ff78723eULL, 0x000fe400020006ffULL,
0x0000001eff27723eULL, 0x000fe400020006ffULL, 0x00000026ff26723eULL, 0x000fe400020006ffULL,
0x000054101f1e7816ULL, 0x000fe4000000001dULL, 0x00000079ff79723eULL, 0x000fc400020006ffULL,
0x00000008ff1d7819ULL, 0x000fe40000011692ULL, 0x0000ffff7c947812ULL, 0x008fe400078ec0ffULL,
0x0000541026267816ULL, 0x000fe40000000027ULL, 0x0000541079277816ULL, 0x000fe4000000007aULL,
0x0000001dff7a723eULL, 0x000fe400020006ffULL, 0x00000018ff867819ULL, 0x000fc4000001167cULL,
0x00000008ff1d7819ULL, 0x000fe20000011694ULL, 0x000000267060723cULL, 0x082f620000001860ULL,
0x00005410781f7816ULL, 0x000fe40000000076ULL, 0x00000008ff767819ULL, 0x000fe40000011693ULL,
0x00000086ff86723eULL, 0x000fe400020006ffULL, 0x0000001dff1d723eULL, 0x000fe200020006ffULL,
0x000000266840723cULL, 0x004b620000001840ULL, 0x0000ffff7e967812ULL, 0x000fc400078ec0ffULL,
0x00000010ff8b7819ULL, 0x100fe4000001167eULL, 0x00000083ff83723eULL, 0x000fe400020006ffULL,
0x00000076ff76723eULL, 0x000fe200020006ffULL, 0x000000021a267824ULL, 0x020fe200078e00ffULL,
0x0000ffff7d957812ULL, 0x000fe200078ec0ffULL, 0x0000001e7064723cULL, 0x000f620000001864ULL,
0x000000ff7e8d7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff8c7819ULL, 0x000fc4000001167eULL,
0x000054101d867816ULL, 0x000fe40000000086ULL, 0x00000010ff7e7819ULL, 0x000fe2000001167fULL,
0x0000001e6844723cULL, 0x000b620000001844ULL, 0x00000008ff1d7819ULL, 0x000fe40000011696ULL,
0x000000ff80807812ULL, 0x000fe400078ec0ffULL, 0x000054107a7a7816ULL, 0x000fe4000000007bULL,
0x000000ff8b8b7812ULL, 0x000fe200078ec0ffULL, 0x00000008021f7824ULL, 0x020fe200078e00ffULL,
0x00000010ff857819ULL, 0x000fc4000001167cULL, 0x000000ff7c877812ULL, 0x000fe400078ec0ffULL,
0x00000010ff887819ULL, 0x000fe4000001167dULL, 0x0000ffff7f977812ULL, 0x000fe400078ec0ffULL,
0x00005410767b7816ULL, 0x000fe40000000083ULL, 0x00000008ff767819ULL, 0x000fe40000011695ULL,
0x0000008cff8c723eULL, 0x000fc400020006ffULL, 0x000000ff7e7e7812ULL, 0x000fe200078ec0ffULL,
0x0000007a7058723cULL, 0x080f620000001858ULL, 0x0000001dff1d723eULL, 0x000fe400020006ffULL,
0x00000080ff78723eULL, 0x000fe400020006ffULL, 0x0000008dff8d723eULL, 0x000fe400020006ffULL,
0x0000008bff8b723eULL, 0x000fe200020006ffULL, 0x0000007a6838723cULL, 0x000f620000001838ULL,
0x000000ff7d8a7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff897819ULL, 0x000fe4000001167dULL,
0x000000ff7f8f7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff8e7819ULL, 0x000fe4000001167fULL,
0x00000087ff7c723eULL, 0x000fe400020006ffULL, 0x000000ff82827812ULL, 0x000fe400078ec0ffULL,
0x000000ff85857812ULL, 0x000fc400078ec0ffULL, 0x000000ff88887812ULL, 0x000fe400078ec0ffULL,
0x00000008ff807819ULL, 0x000fe40000011697ULL, 0x00000076ff87723eULL, 0x000fe400020006ffULL,
0x0000007eff76723eULL, 0x000fe400020006ffULL, 0x000054101d8c7816ULL, 0x000fe4000000008cULL,
0x000054108d7e7816ULL, 0x000fc4000000008bULL, 0x00000004261d7812ULL, 0x000fe400078ec0ffULL,
0x00000081ff81723eULL, 0x000fe400020006ffULL, 0x00000084ff84723eULL, 0x000fe400020006ffULL,
0x0000008aff7d723eULL, 0x000fe400020006ffULL, 0x00000082ff79723eULL, 0x000fe400020006ffULL,
0x00000089ff89723eULL, 0x000fc400020006ffULL, 0x00000085ff85723eULL, 0x000fe400020006ffULL,
0x00000088ff88723eULL, 0x000fe400020006ffULL, 0x0000008fff7f723eULL, 0x000fe400020006ffULL,
0x0000008eff8e723eULL, 0x000fe400020006ffULL, 0x00000080ff8d723eULL, 0x000fe400020006ffULL,
0x000000021d1e7812ULL, 0x000fc400078efcffULL, 0x0000541081787816ULL, 0x000fe40000000078ULL,
0x0000541084797816ULL, 0x000fe40000000079ULL, 0x000054107c7c7816ULL, 0x000fe40000000085ULL,
0x000054107d7d7816ULL, 0x000fe40000000088ULL, 0x0000541087877816ULL, 0x000fe20000000089ULL,
0x00000078705c723cULL, 0x000f62000000185cULL, 0x000054107f7f7816ULL, 0x000fc40000000076ULL,
0x000054108d8d7816ULL, 0x000fe4000000008eULL, 0x0000001e171e7211ULL, 0x000fe400078fe0ffULL,
0x0000100000277810ULL, 0x000fe20007ffe0ffULL, 0x0000007c7054723cULL, 0x000f640000001854ULL,
0x00000001031d7824ULL, 0x100fe400078e021eULL, 0x00000001021e7824ULL, 0x000fc800078e021eULL,
0x000000867050723cULL, 0x000f620000001850ULL, 0xfffffff81f1e7812ULL, 0x000fce00078ee21eULL,
0x0000007e704c723cULL, 0x040f70000000184cULL, 0x0000008c7048723cULL, 0x000b6e0000001848ULL,
0x0000000803707824ULL, 0x020fe200078e00ffULL, 0x00000078683c723cULL, 0x000b62000000183cULL,
0x0000000802727824ULL, 0x000fc600078e00ffULL, 0xfffffff8701d7812ULL, 0x000fe400078ee21dULL,
0xfffffff8721f7812ULL, 0x000fe400078ee225ULL, 0x0000007c6834723cULL, 0x040f620000001834ULL,
0x000000101d707824ULL, 0x100fe400078e0220ULL, 0x000000101e207824ULL, 0x000fe400078e0220ULL,
0x000000101f787824ULL, 0x020fe400078e0227ULL, 0x000000007070783bULL, 0x000e620000000200ULL,
0x000000866830723cULL, 0x040f700000001830ULL, 0x0000007e682c723cULL, 0x040f70000000182cULL,
0x0000008c6828723cULL, 0x000b640000001828ULL, 0x000000002068783bULL, 0x0204e20000000200ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x0000008000000947ULL, 0x000fde0003800000ULL,
0x0000000770707232ULL, 0x082fe40000000000ULL, 0x0000000772727232ULL, 0x000fc40000000000ULL,
0x0000000671717232ULL, 0x080fe40000000000ULL, 0x0000000673737232ULL, 0x000fe40000000000ULL,
0x0000000568687232ULL, 0x088fe40000000000ULL, 0x000000056a6a7232ULL, 0x000fe40000000000ULL,
0x0000000469697232ULL, 0x080fe40000000000ULL, 0x000000046b6b7232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000008027d7824ULL, 0x000fe200078e00ffULL,
0x0000000225207810ULL, 0x004fe20007ffe0ffULL, 0x000000007878783bULL, 0x000ea20000004200ULL,
0xfffffff826267812ULL, 0x000fc400078ec0ffULL, 0xfffffff87d207812ULL, 0x000fca00078ee220ULL,
0x00000010207c7824ULL, 0x000fcc00078e0227ULL, 0x000000007c7c783bULL, 0x000f220000004200ULL,
0x00000010ff257819ULL, 0x104fe40000011678ULL, 0x000000ff78767812ULL, 0x040fe400078ec0ffULL,
0x000000ff25257812ULL, 0x000fe400078ec0ffULL, 0x00000018ff277819ULL, 0x000fe40000011678ULL,
0x0000ffff78937812ULL, 0x000fe400078ec0ffULL, 0x00000076ff78723eULL, 0x000fc400020006ffULL,
0x00000025ff25723eULL, 0x000fe400020006ffULL, 0x0000ffff7a957812ULL, 0x040fe400078ec0ffULL,
0x000000ff79827812ULL, 0x000fe400078ec0ffULL, 0x00000010ff837819ULL, 0x100fe4000001167aULL,
0x000000ff7a857812ULL, 0x000fe400078ec0ffULL, 0x00000018ff847819ULL, 0x000fc4000001167aULL,
0x00000018ff7a7819ULL, 0x000fe4000001167bULL, 0x00000027ff76723eULL, 0x000fe400020006ffULL,
0x00000008ff277819ULL, 0x000fe40000011693ULL, 0x0000541078787816ULL, 0x000fe40000000025ULL,
0x00000010ff807819ULL, 0x100fe40000011679ULL, 0x00000018ff817819ULL, 0x000fc40000011679ULL,
0x0000ffff79947812ULL, 0x000fe400078ec0ffULL, 0x0000ffff7b967812ULL, 0x000fe400078ec0ffULL,
0x00000008ff257819ULL, 0x000fe40000011695ULL, 0x0000ffff7c977812ULL, 0x010fe400078ec0ffULL,
0x00000082ff79723eULL, 0x000fe400020006ffULL, 0x0000007aff82723eULL, 0x000fc400020006ffULL,
0x00000010ff867819ULL, 0x000fe4000001167bULL, 0x000000ff7b877812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8d7819ULL, 0x100fe4000001167eULL, 0x000000ff7e8f7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff8e7819ULL, 0x000fe4000001167eULL, 0x0000ffff7e997812ULL, 0x000fc400078ec0ffULL,
0x00000027ff7a723eULL, 0x000fe400020006ffULL, 0x000000ff7c7b7812ULL, 0x000fe400078ec0ffULL,
0x000000ff80807812ULL, 0x000fe400078ec0ffULL, 0x000000ff83837812ULL, 0x000fe400078ec0ffULL,
0x00000008ff277819ULL, 0x000fe40000011696ULL, 0x00000025ff7e723eULL, 0x000fc400020006ffULL,
0x00000010ff887819ULL, 0x100fe4000001167cULL, 0x00000018ff897819ULL, 0x000fe4000001167cULL,
0x0000ffff7d987812ULL, 0x000fe400078ec0ffULL, 0x00000008ff257819ULL, 0x000fe40000011697ULL,
0x00000010ff907819ULL, 0x000fe4000001167fULL, 0x000000ff7f927812ULL, 0x000fc400078ec0ffULL,
0x00000018ff917819ULL, 0x000fe4000001167fULL, 0x0000ffff7f9a7812ULL, 0x000fe400078ec0ffULL,
0x00000085ff7c723eULL, 0x000fe400020006ffULL, 0x0000007bff85723eULL, 0x000fe400020006ffULL,
0x00000080ff80723eULL, 0x000fe400020006ffULL, 0x00000083ff83723eULL, 0x000fc400020006ffULL,
0x00000027ff7f723eULL, 0x000fe400020006ffULL, 0x00000008ff7b7819ULL, 0x000fe40000011694ULL,
0x00000089ff89723eULL, 0x000fe400020006ffULL, 0x000000ff88887812ULL, 0x000fe400078ec0ffULL,
0x00000008ff277819ULL, 0x000fe40000011698ULL, 0x00000025ff25723eULL, 0x000fc400020006ffULL,
0x000000ff8d8d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8a7819ULL, 0x000fe4000001167dULL,
0x00000084ff84723eULL, 0x000fe400020006ffULL, 0x0000541079797816ULL, 0x000fe40000000080ULL,
0x000054107c7c7816ULL, 0x000fe40000000083ULL, 0x000054107f7f7816ULL, 0x000fc40000000082ULL,
0x00000081ff81723eULL, 0x000fe200020006ffULL, 0x000000787064723cULL, 0x082f620000001864ULL,
0x0000007bff7b723eULL, 0x000fe400020006ffULL, 0x0000008fff8f723eULL, 0x000fe400020006ffULL,
0x00000088ff80723eULL, 0x000fe400020006ffULL, 0x00000027ff83723eULL, 0x000fe200020006ffULL,
0x000000786844723cULL, 0x008f620000001844ULL, 0x0000541025827816ULL, 0x000fc40000000089ULL,
0x0000008dff8d723eULL, 0x000fe400020006ffULL, 0x000000ff7d8c7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff8b7819ULL, 0x000fe4000001167dULL, 0x000000ff86867812ULL, 0x000fe400078ec0ffULL,
0x000000ff8a8a7812ULL, 0x000fe400078ec0ffULL, 0x000000ff90907812ULL, 0x000fc400078ec0ffULL,
0x00000008ff257819ULL, 0x000fe40000011699ULL, 0x00000008ff277819ULL, 0x000fe4000001169aULL,
0x000054107e7e7816ULL, 0x000fe40000000084ULL, 0x000054107b7b7816ULL, 0x000fe40000000081ULL,
0x0000541085807816ULL, 0x000fe40000000080ULL, 0x000054108f847816ULL, 0x000fe2000000008dULL,
0x0000007e7058723cULL, 0x000f620000001858ULL, 0x00000087ff7d723eULL, 0x000fc400020006ffULL,
0x0000008cff8c723eULL, 0x000fe400020006ffULL, 0x00000086ff86723eULL, 0x000fe400020006ffULL,
0x0000008bff8b723eULL, 0x000fe200020006ffULL, 0x0000007e6838723cULL, 0x000f620000001838ULL,
0x0000008aff81723eULL, 0x000fe400020006ffULL, 0x00000092ff92723eULL, 0x000fe400020006ffULL,
0x0000008eff8e723eULL, 0x000fc400020006ffULL, 0x00000090ff85723eULL, 0x000fe400020006ffULL,
0x00000091ff91723eULL, 0x000fe400020006ffULL, 0x00000025ff25723eULL, 0x000fe400020006ffULL,
0x00000027ff8f723eULL, 0x000fe400020006ffULL, 0x000054107a7a7816ULL, 0x000fe40000000076ULL,
0x000054107d7d7816ULL, 0x000fc40000000086ULL, 0x000054108c817816ULL, 0x000fe40000000081ULL,
0x0000541083837816ULL, 0x000fe2000000008bULL, 0x0000007a7060723cULL, 0x000f620000001860ULL,
0x0000541092857816ULL, 0x000fe40000000085ULL, 0x00005410258e7816ULL, 0x000fe4000000008eULL,
0x000054108f8f7816ULL, 0x000fc60000000091ULL, 0x0000007c705c723cULL, 0x040f70000000185cULL,
0x000000807054723cULL, 0x040f700000001854ULL, 0x000000827050723cULL, 0x040f700000001850ULL,
0x00000084704c723cULL, 0x040f70000000184cULL, 0x0000008e7048723cULL, 0x000f700000001848ULL,
0x0000007a6840723cULL, 0x040f700000001840ULL, 0x0000007c683c723cULL, 0x040f70000000183cULL,
0x000000806834723cULL, 0x040f700000001834ULL, 0x000000826830723cULL, 0x040f700000001830ULL,
0x00000084682c723cULL, 0x040f70000000182cULL, 0x0000008e6828723cULL, 0x000b6e0000001828ULL,
0x000126c8136a7811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x000000006a6a7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126900026ff7f8cULL, 0x0005e4000c80043fULL, 0x0000000000267805ULL, 0x004fc40000015200ULL,
0x000004000d257984ULL, 0x000ea40000000800ULL, 0x8000000025ff7812ULL, 0x006fc4000780486bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff707224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000107000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000687805ULL, 0x000fcc0000015200ULL, 0x0000006826687210ULL, 0x000fca0007f1e1ffULL,
0x0000000169697824ULL, 0x000fe200000e0e27ULL, 0x003d09006800780cULL, 0x000fc80003f06070ULL,
0x000000ff6900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c406800780cULL, 0x000fc80003f06070ULL, 0x000000ff6900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff257819ULL, 0x000fc80000011469ULL,
0x0000006825257211ULL, 0x000fca00078110ffULL, 0x000000ffff687224ULL, 0x000fca00000e0669ULL,
0x0000000225257819ULL, 0x000fc80000001268ULL, 0x000000250000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000170707810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004000d257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe4000780486bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000c00c277810ULL, 0x000fca0007ffe0ffULL, 0x0000660012717a24ULL, 0x000fe200078e0227ULL,
0x000003e00000a947ULL, 0x000fea0003800000ULL, 0x0000002716257217ULL, 0x000fe20007800000ULL,
0x0000001011707824ULL, 0x000fe200078e00ffULL, 0x00000003ff687819ULL, 0x000fe40000011617ULL,
0x00001000007b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000125257824ULL, 0x000fe200078e0a27ULL,
0x0000000468697810ULL, 0x000fe20007ffe0ffULL, 0x0000000170267824ULL, 0x000fe200078e0268ULL,
0x00000008686b7810ULL, 0x000fe40007ffe0ffULL, 0x0000002570257217ULL, 0x000fe20007800000ULL,
0x0000000126277824ULL, 0x000fc400078e0217ULL, 0x0000000826727824ULL, 0x040fe400078e00ffULL,
0x0000000125257824ULL, 0x000fe400078e0a70ULL, 0x0000000126267824ULL, 0x000fe200078e0271ULL,
0xfffffff872727812ULL, 0x000fe200078ee227ULL, 0x0000000170767824ULL, 0x000fe200078e0269ULL,
0x000000256900720cULL, 0x080fe20003f86070ULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x0000000c68697810ULL, 0x040fe40007ffe0ffULL, 0x000000256800720cULL, 0x080fe20003fa6070ULL,
0x0000000176687824ULL, 0x000fe200078e0271ULL, 0x000000256900720cULL, 0x000fe20003f06070ULL,
0x00000001707a7824ULL, 0x000fe200078e0269ULL, 0x0000000b266a7212ULL, 0x000fe200078efcffULL,
0x0000008068687825ULL, 0x000fe200078e00ffULL, 0x000000256b00720cULL, 0x000fc40003f66070ULL,
0x000062006a6a7a10ULL, 0x000fe20007fde0ffULL, 0x0000000170787824ULL, 0x000fe200078e026bULL,
0x0000000b68707212ULL, 0x000fe200078efcffULL, 0x0000000176257824ULL, 0x000fe200078e0217ULL,
0x00006300276b7a10ULL, 0x000fe200037fe4ffULL, 0x0000000178267824ULL, 0x000fe200078e0271ULL,
0x0000620070707a10ULL, 0x000fe20007fde0ffULL, 0x0000000876767824ULL, 0x000fe400078e00ffULL,
0x0000008026267825ULL, 0x000fc600078e00ffULL, 0xfffffff876767812ULL, 0x000fe200078ee225ULL,
0x000000017a687824ULL, 0x000fe200078e0271ULL, 0x0000630069717a10ULL, 0x000fe200037fe4ffULL,
0x0000000178737824ULL, 0x000fe200078e0217ULL, 0x0000000b26267212ULL, 0x000fe200078efcffULL,
0x0000008068687825ULL, 0x000fc600078e00ffULL, 0x0000620026267a10ULL, 0x000fe20007fde0ffULL,
0x0000000878787824ULL, 0x000fe200078e00ffULL, 0x0000000b68687212ULL, 0x000fe200078efcffULL,
0x000000017a257824ULL, 0x040fe200078e0217ULL, 0x0000630027277a10ULL, 0x000fe200037fe4ffULL,
0x000000087a7a7824ULL, 0x000fe200078e00ffULL, 0xfffffff878787812ULL, 0x000fe200078ee273ULL,
0x0000001076737824ULL, 0x000fe200078e027bULL, 0x0000620068687a10ULL, 0x000fe40007fde0ffULL,
0xfffffff87a7a7812ULL, 0x000fe200078ee225ULL, 0x0000001072257824ULL, 0x100fe200078e027bULL,
0x0000630069697a10ULL, 0x000fe200037fe4ffULL, 0x0000001078797824ULL, 0x000fc400078e027bULL,
0x000000107a7b7824ULL, 0x000fe200078e027bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006a257faeULL, 0x0003e8000e901c48ULL, 0x0000000070737faeULL, 0x0003e8000e101c48ULL,
0x0000000026797faeULL, 0x0003e8000d901c48ULL, 0x00000000687b7faeULL, 0x0003e2000c101c48ULL,
0x0000031000007947ULL, 0x000fea0003800000ULL, 0x0000001011267824ULL, 0x000fe200078e00ffULL,
0x00001000007b7810ULL, 0x000fc80007ffe0ffULL, 0x0000002617687211ULL, 0x000fc800078fe8ffULL,
0x00000004686a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000168267824ULL, 0x040fe200078e0271ULL,
0x0000000868767810ULL, 0x040fe20007ffe0ffULL, 0x0000000168257824ULL, 0x040fe200078e0217ULL,
0x0000000c68787810ULL, 0x040fe20007ffe0ffULL, 0x0000000868727824ULL, 0x000fe400078e00ffULL,
0x0000008026267825ULL, 0x000fc600078e00ffULL, 0xfffffff872727812ULL, 0x000fe200078ee225ULL,
0x000000016a257824ULL, 0x000fe200078e0271ULL, 0x0000000b26707212ULL, 0x000fe200078efcffULL,
0x000000016a697824ULL, 0x040fe400078e0217ULL, 0x000000086a7a7824ULL, 0x000fe200078e00ffULL,
0x0000620070707a10ULL, 0x000fe20007f1e0ffULL, 0x0000000176687824ULL, 0x100fe400078e0271ULL,
0x00000001786a7824ULL, 0x040fe400078e0271ULL, 0x0000000178267824ULL, 0x000fc400078e0217ULL,
0x0000000878717824ULL, 0x000fe400078e00ffULL, 0x00000001766b7824ULL, 0x040fe400078e0217ULL,
0x00000008767c7824ULL, 0x000fe200078e00ffULL, 0xfffffff87a767812ULL, 0x000fe200078ee269ULL,
0x0000008068687825ULL, 0x000fe200078e00ffULL, 0xfffffff8717a7812ULL, 0x000fe400078ee226ULL,
0x0000630027717a10ULL, 0x000fe200007fe4ffULL, 0x0000008025267825ULL, 0x000fe200078e00ffULL,
0xfffffff87c787812ULL, 0x000fc400078ee26bULL, 0x0000000b68687212ULL, 0x080fe200078efcffULL,
0x000000806a6a7825ULL, 0x000fe200078e00ffULL, 0x0000000b26267212ULL, 0x080fe400078efcffULL,
0x0000620068687a10ULL, 0x000fe20007f7e0ffULL, 0x0000001072257824ULL, 0x100fe200078e027bULL,
0x0000000b6a6a7212ULL, 0x000fe200078efcffULL, 0x0000001076737824ULL, 0x100fe200078e027bULL,
0x0000620026267a10ULL, 0x000fe20007f1e0ffULL, 0x0000001078797824ULL, 0x100fe200078e027bULL,
0x000062006a6a7a10ULL, 0x000fe20007f9e0ffULL, 0x000000107a7b7824ULL, 0x000fe200078e027bULL,
0x0000630027277a10ULL, 0x000fe200007fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000070257faeULL, 0x0003e2000b901c48ULL, 0x0000630069697a10ULL, 0x000fc40001ffe4ffULL,
0x000063006b6b7a10ULL, 0x000fe200027fe4ffULL, 0x0000000026737faeULL, 0x0003e8000b901c48ULL,
0x0000000068797faeULL, 0x0003e8000b901c48ULL, 0x000000006a7b7faeULL, 0x0003e4000b901c48ULL,
0x0000000804057890ULL, 0x000fe2000fffe03fULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0xfffffff014687812ULL, 0x000fce00078ec0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126b00068687f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126480023707f8cULL, 0x0004e4000c80043fULL, 0x0000000000267805ULL, 0x000fc40000015200ULL,
0xffffffe014237812ULL, 0x044fe400078ec0ffULL, 0x00000010146a7812ULL, 0x040fe400078ec0ffULL,
0x0000000814257812ULL, 0x000fc800078ec0ffULL, 0x0000002325237210ULL, 0x000fca0007ffe06aULL,
0x01264c0023257984ULL, 0x000ea40000000800ULL, 0x8000000025ff7812ULL, 0x00cfe40007804871ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff727224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000107200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000006a7805ULL, 0x000fcc0000015200ULL, 0x0000006a266a7210ULL, 0x000fca0007f1e1ffULL,
0x000000016b6b7824ULL, 0x000fe200000e0e27ULL, 0x003d09006a00780cULL, 0x000fc80003f06070ULL,
0x000000ff6b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c406a00780cULL, 0x000fc80003f06070ULL, 0x000000ff6b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff257819ULL, 0x000fc8000001146bULL,
0x0000006a25257211ULL, 0x000fca00078110ffULL, 0x000000ffff6a7224ULL, 0x000fca00000e066bULL,
0x0000000225257819ULL, 0x000fc8000000126aULL, 0x000000250000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000172727810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01264c0023257984ULL, 0x000ea40000000800ULL,
0x8000000025ff7812ULL, 0x004fe40007804871ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000201a237824ULL, 0x000fca00078e00ffULL, 0xffffff8023267812ULL, 0x000fc800078ec0ffULL,
0x000001000b237810ULL, 0x000fca0007ffe026ULL, 0x000000010a237824ULL, 0x000fca00078e0223ULL,
0x0120000023717984ULL, 0x000ea80000000800ULL, 0x0122000023707984ULL, 0x0006620000000800ULL,
0x000000247100720bULL, 0x004fe20003f1d000ULL, 0x0000e6027f007947ULL, 0x000fd8000b800000ULL,
0x0000000000727806ULL, 0x008fc800000e0100ULL, 0x000000ff7200720cULL, 0x000fe20003f05270ULL,
0x0000077000007945ULL, 0x000fe20003800000ULL, 0x00000001ff6a7424ULL, 0x000fe400078e00ffULL,
0x000000ffff237224ULL, 0x000fd200078e0024ULL, 0x0000073000008947ULL, 0x000fea0003800000ULL,
0x0000000210237810ULL, 0x000fe40007ffe0ffULL, 0x000000247100720bULL, 0x000fe40003f74000ULL,
0x0000001a2300720cULL, 0x000fe20003f05270ULL, 0x0000e5b27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000237806ULL, 0x000fc400018e0100ULL, 0x000000801a278824ULL, 0x000fe200078e020bULL,
0x0000002471257209ULL, 0x000fe20007810000ULL, 0x0000063000017945ULL, 0x000fe40003800000ULL,
0x000000010a268824ULL, 0x000fca00078e0227ULL, 0x0124002526008388ULL, 0x0005e20000000800ULL,
0x000000ff2300720cULL, 0x000fda0003f05270ULL, 0x000005e000008947ULL, 0x000fea0003800000ULL,
0x8000002524257221ULL, 0x004fe20000010000ULL, 0x000000ff23ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b25257820ULL, 0x000fc80000410000ULL,
0x0000002500277308ULL, 0x000ea40000000800ULL, 0x0000002722227220ULL, 0x004fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff267819ULL, 0x000fe20000011617ULL,
0x0000e4f27f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0004e400000e0000ULL,
0x0000002664647220ULL, 0x08cfe20000410000ULL, 0x0000002665657220ULL, 0x080fe20000410000ULL,
0x0000002660607220ULL, 0x080fe20000410000ULL, 0x0000002661617220ULL, 0x080fe20000410000ULL,
0x000000265c5c7220ULL, 0x080fe20000410000ULL, 0x000000265d5d7220ULL, 0x080fe20000410000ULL,
0x0000002658587220ULL, 0x080fe20000410000ULL, 0x0000002659597220ULL, 0x080fe20000410000ULL,
0x0000002654547220ULL, 0x080fe20000410000ULL, 0x0000002655557220ULL, 0x080fe20000410000ULL,
0x0000002650507220ULL, 0x080fe20000410000ULL, 0x0000002651517220ULL, 0x080fe20000410000ULL,
0x000000264c4c7220ULL, 0x080fe20000410000ULL, 0x000000264d4d7220ULL, 0x080fe20000410000ULL,
0x0000002648487220ULL, 0x080fe20000410000ULL, 0x0000002649497220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0023ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000817267811ULL, 0x000fe200078ff0ffULL, 0x0000e3b27f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0004e400000e0000ULL, 0x0000002666667220ULL, 0x08cfe20000410000ULL,
0x0000002667677220ULL, 0x080fe20000410000ULL, 0x0000002662627220ULL, 0x080fe20000410000ULL,
0x0000002663637220ULL, 0x080fe20000410000ULL, 0x000000265e5e7220ULL, 0x080fe20000410000ULL,
0x000000265f5f7220ULL, 0x080fe20000410000ULL, 0x000000265a5a7220ULL, 0x080fe20000410000ULL,
0x000000265b5b7220ULL, 0x080fe20000410000ULL, 0x0000002656567220ULL, 0x080fe20000410000ULL,
0x0000002657577220ULL, 0x080fe20000410000ULL, 0x0000002652527220ULL, 0x080fe20000410000ULL,
0x0000002653537220ULL, 0x080fe20000410000ULL, 0x000000264e4e7220ULL, 0x080fe20000410000ULL,
0x000000264f4f7220ULL, 0x080fe20000410000ULL, 0x000000264a4a7220ULL, 0x080fe20000410000ULL,
0x000000264b4b7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff000023ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001017267811ULL, 0x000fe200078ff0ffULL,
0x0000e2727f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0004e400000e0000ULL,
0x0000002644447220ULL, 0x08cfe20000410000ULL, 0x0000002645457220ULL, 0x080fe20000410000ULL,
0x0000002640407220ULL, 0x080fe20000410000ULL, 0x0000002641417220ULL, 0x080fe20000410000ULL,
0x000000263c3c7220ULL, 0x080fe20000410000ULL, 0x000000263d3d7220ULL, 0x080fe20000410000ULL,
0x0000002638387220ULL, 0x080fe20000410000ULL, 0x0000002639397220ULL, 0x080fe20000410000ULL,
0x0000002634347220ULL, 0x080fe20000410000ULL, 0x0000002635357220ULL, 0x080fe20000410000ULL,
0x0000002630307220ULL, 0x080fe20000410000ULL, 0x0000002631317220ULL, 0x080fe20000410000ULL,
0x000000262c2c7220ULL, 0x080fe20000410000ULL, 0x000000262d2d7220ULL, 0x080fe20000410000ULL,
0x0000002628287220ULL, 0x080fe20000410000ULL, 0x0000002629297220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff00000023ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001817267811ULL, 0x000fe200078ff0ffULL,
0x0000e1427f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0004e400000e0000ULL,
0x0000002646467220ULL, 0x08cfe20000410000ULL, 0x0000002647477220ULL, 0x080fe20000410000ULL,
0x0000002642427220ULL, 0x080fe20000410000ULL, 0x0000002643437220ULL, 0x080fe20000410000ULL,
0x000000263e3e7220ULL, 0x080fe20000410000ULL, 0x000000263f3f7220ULL, 0x080fe20000410000ULL,
0x000000263a3a7220ULL, 0x080fe20000410000ULL, 0x000000263b3b7220ULL, 0x080fe20000410000ULL,
0x0000002636367220ULL, 0x080fe20000410000ULL, 0x0000002637377220ULL, 0x080fe20000410000ULL,
0x0000002632327220ULL, 0x080fe20000410000ULL, 0x0000002633337220ULL, 0x080fe20000410000ULL,
0x000000262e2e7220ULL, 0x080fe20000410000ULL, 0x000000262f2f7220ULL, 0x080fe20000410000ULL,
0x000000262a2a7220ULL, 0x080fe20000410000ULL, 0x000000262b2b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000002372ff7212ULL, 0x000fe200078030ffULL,
0x00000001ff6a7424ULL, 0x000fe200078e00ffULL, 0x0000002471237209ULL, 0x000fd60007810000ULL,
0x8000002371710221ULL, 0x000fe20000010000ULL, 0x00007610ff6a0816ULL, 0x000fc6000000006aULL,
0x3fb8aa3b71710820ULL, 0x000fc80000410000ULL, 0x0000007100090308ULL, 0x000ea40000000800ULL,
0x0000000970700220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002270227221ULL, 0x002fc20000010000ULL, 0x0000000000247805ULL, 0x000fcc0000015200ULL,
0x0000040008277984ULL, 0x000e640000000800ULL, 0x8000000027ff7812ULL, 0x002fe4000780486dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff707224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000107000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x00000026246b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09006b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c406b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff267819ULL, 0x000fc80000011427ULL,
0x0000006b26267211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x0000000226267819ULL, 0x000fc80000001227ULL, 0x000000260000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000170707810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040008277984ULL, 0x000e640000000800ULL,
0x8000000027ff7812ULL, 0x002fe4000780486dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099106a247816ULL, 0x000fe200000000ffULL, 0x0000010000007945ULL, 0x000fe60003800000ULL,
0x000000ff2400720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000009ff04723eULL, 0x000fe400000000ffULL, 0x00000002ff247819ULL, 0x000fe40000011617ULL,
0x0000541004277816ULL, 0x000fe20000000004ULL, 0x0000dd027f007947ULL, 0x000fea000b800000ULL,
0x00001f2427077589ULL, 0x0002a400000e0000ULL, 0x0000000824267810ULL, 0x000fe20007ffe0ffULL,
0x0000dd227f007947ULL, 0x000fea000b800000ULL, 0x0000001024047810ULL, 0x000fe20007ffe0ffULL,
0x00001f2627067589ULL, 0x00066800000e0000ULL, 0x00001f0427057589ULL, 0x0006a400000e0000ULL,
0x0000001824267810ULL, 0x008fe20007ffe0ffULL, 0x0000dd527f007947ULL, 0x000fea000b800000ULL,
0x00001f2627047589ULL, 0x0006a400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000021a6a7824ULL, 0x040fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000004001a267824ULL, 0x008fe200078e00ffULL, 0x0000019000007945ULL, 0x000fe20003800000ULL,
0x00000008036c7824ULL, 0x000fe200078e00ffULL, 0x000000046a247812ULL, 0x002fe200078ec0ffULL,
0x0000000802277824ULL, 0x000fe200078e00ffULL, 0xfffff000266b7812ULL, 0x000fe200078ec0ffULL,
0x000000101c787824ULL, 0x000fe200078e0200ULL, 0x0000002417247211ULL, 0x000fc400078fe0ffULL,
0x0000c0006b6b7810ULL, 0x000fc60007ffe0ffULL, 0x0000000103257824ULL, 0x100fe400078e0224ULL,
0x0000000102267824ULL, 0x000fc600078e0224ULL, 0xfffffff86c247812ULL, 0x000fe400078ee225ULL,
0xfffffff827267812ULL, 0x000fc600078ee226ULL, 0x0000001024707824ULL, 0x100fe400078e026bULL,
0x0000001026267824ULL, 0x000fc800078e026bULL, 0x000000007070783bULL, 0x000e680000000200ULL,
0x000000002624783bULL, 0x000ee20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000770707232ULL, 0x086fe40000000000ULL, 0x0000000772727232ULL, 0x000fe40000000000ULL,
0x0000000671717232ULL, 0x080fe40000000000ULL, 0x0000000673737232ULL, 0x000fc40000000000ULL,
0x0000000524247232ULL, 0x088fe40000000000ULL, 0x0000000526267232ULL, 0x000fe40000000000ULL,
0x0000000425257232ULL, 0x080fe40000000000ULL, 0x0000000427277232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000007878783bULL, 0x000f220000004200ULL,
0x00000010217c7824ULL, 0x000fe200078e0200ULL, 0x0000081000007945ULL, 0x000fea0003800000ULL,
0x000000007c7c783bULL, 0x000ee20000004200ULL, 0x00000010ff217819ULL, 0x010fc40000011678ULL,
0x00000010ff767819ULL, 0x000fe40000011679ULL, 0x000000ff786d7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff6c7819ULL, 0x000fe40000011678ULL, 0x0000ffff78917812ULL, 0x000fe400078ec0ffULL,
0x00000018ff787819ULL, 0x000fe4000001167aULL, 0x000000ff21217812ULL, 0x000fc400078ec0ffULL,
0x000000ff79817812ULL, 0x000fe400078ec0ffULL, 0x00000010ff827819ULL, 0x000fe4000001167aULL,
0x000000ff7a837812ULL, 0x040fe400078ec0ffULL, 0x0000ffff7a937812ULL, 0x000fe400078ec0ffULL,
0x000000ff76767812ULL, 0x000fe400078ec0ffULL, 0x00000018ff7a7819ULL, 0x000fc4000001167bULL,
0x00000010ff867819ULL, 0x108fe4000001167cULL, 0x000000ff7c887812ULL, 0x040fe400078ec0ffULL,
0x00000018ff877819ULL, 0x000fe4000001167cULL, 0x0000ffff7c957812ULL, 0x000fe400078ec0ffULL,
0x0000ffff79927812ULL, 0x000fe400078ec0ffULL, 0x00000010ff897819ULL, 0x000fc4000001167dULL,
0x000000ff7d8a7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff7c7819ULL, 0x000fe4000001167dULL,
0x0000ffff7d967812ULL, 0x000fe400078ec0ffULL, 0x0000006dff6d723eULL, 0x000fe400020006ffULL,
0x00000078ff7d723eULL, 0x000fe400020006ffULL, 0x00000021ff21723eULL, 0x000fc400020006ffULL,
0x00000010ff8b7819ULL, 0x100fe4000001167eULL, 0x00000018ff8c7819ULL, 0x000fe4000001167eULL,
0x000000ff7e8d7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff7e977812ULL, 0x000fe400078ec0ffULL,
0x00000081ff81723eULL, 0x000fe400020006ffULL, 0x00000076ff78723eULL, 0x000fc400020006ffULL,
0x00000018ff807819ULL, 0x000fe40000011679ULL, 0x0000007aff7e723eULL, 0x000fe400020006ffULL,
0x00000008ff767819ULL, 0x000fe40000011691ULL, 0x0000006cff79723eULL, 0x000fe400020006ffULL,
0x00000008ff7a7819ULL, 0x000fe40000011692ULL, 0x000054106d6c7816ULL, 0x000fc40000000021ULL,
0x00005410816d7816ULL, 0x000fe40000000078ULL, 0x00000076ff78723eULL, 0x000fe400020006ffULL,
0x0000ffff7b947812ULL, 0x000fe400078ec0ffULL, 0x00000080ff80723eULL, 0x000fe200020006ffULL,
0x0000006c7064723cULL, 0x002f620000001864ULL, 0x0000007aff7a723eULL, 0x000fe400020006ffULL,
0x000000ff82827812ULL, 0x000fc400078ec0ffULL, 0x0000541078787816ULL, 0x000fe40000000079ULL,
0x00000008ff217819ULL, 0x000fe20000011693ULL, 0x0000006c2444723cULL, 0x000f620000001844ULL,
0x000054107a797816ULL, 0x000fe40000000080ULL, 0x00000008ff767819ULL, 0x000fe40000011694ULL,
0x00000082ff7a723eULL, 0x000fe400020006ffULL, 0x0000007cff82723eULL, 0x000fe200020006ffULL,
0x000000787060723cULL, 0x000f620000001860ULL, 0x00000021ff7c723eULL, 0x000fc400020006ffULL,
0x00000076ff76723eULL, 0x000fe400020006ffULL, 0x00000008ff217819ULL, 0x000fe40000011695ULL,
0x000054107c7c7816ULL, 0x000fe2000000007dULL, 0x000000782440723cULL, 0x000b620000001840ULL,
0x00005410767d7816ULL, 0x000fe4000000007eULL, 0x00000008ff767819ULL, 0x000fe40000011696ULL,
0x00000087ff87723eULL, 0x000fc400020006ffULL, 0x00000021ff21723eULL, 0x000fe200020006ffULL,
0x0000007c7058723cULL, 0x080f620000001858ULL, 0x000000ff8b8b7812ULL, 0x000fe200078ec0ffULL,
0x000000101f787824ULL, 0x020fe200078e0200ULL, 0x00000010ff847819ULL, 0x000fe4000001167bULL,
0x00000010ff8e7819ULL, 0x000fe4000001167fULL, 0x0000ffff7f987812ULL, 0x000fe200078ec0ffULL,
0x0000007c2438723cULL, 0x000f620000001838ULL, 0x00000076ff81723eULL, 0x000fc400020006ffULL,
0x00000083ff83723eULL, 0x000fe400020006ffULL, 0x0000008dff8d723eULL, 0x000fe400020006ffULL,
0x0000541021807816ULL, 0x000fe40000000087ULL, 0x0000008bff8b723eULL, 0x000fe400020006ffULL,
0x000000ff7b857812ULL, 0x000fe400078ec0ffULL, 0x00000018ff8f7819ULL, 0x000fc4000001167fULL,
0x000000ff7f907812ULL, 0x000fe400078ec0ffULL, 0x000000ff84847812ULL, 0x000fe400078ec0ffULL,
0x000000ff86867812ULL, 0x000fe400078ec0ffULL, 0x000000ff89897812ULL, 0x000fe400078ec0ffULL,
0x000000ff8e8e7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff217819ULL, 0x000fc40000011697ULL,
0x00000008ff767819ULL, 0x000fe40000011698ULL, 0x0000541081817816ULL, 0x000fe40000000082ULL,
0x00005410837a7816ULL, 0x000fe4000000007aULL, 0x000054108d827816ULL, 0x000fe4000000008bULL,
0x00000085ff7b723eULL, 0x000fe200020006ffULL, 0x000000807050723cULL, 0x000f620000001850ULL,
0x00000088ff88723eULL, 0x000fc400020006ffULL, 0x0000008aff7f723eULL, 0x000fe400020006ffULL,
0x00000084ff84723eULL, 0x000fe400020006ffULL, 0x0000008cff8c723eULL, 0x000fe200020006ffULL,
0x000000802430723cULL, 0x000f620000001830ULL, 0x00000086ff7e723eULL, 0x000fe400020006ffULL,
0x00000089ff89723eULL, 0x000fe400020006ffULL, 0x00000090ff83723eULL, 0x000fc400020006ffULL,
0x0000008eff8e723eULL, 0x000fe400020006ffULL, 0x0000008fff8f723eULL, 0x000fe400020006ffULL,
0x00000021ff21723eULL, 0x000fe400020006ffULL, 0x00000076ff8d723eULL, 0x000fe400020006ffULL,
0x000054107b7b7816ULL, 0x000fe40000000084ULL, 0x00005410887e7816ULL, 0x000fc4000000007eULL,
0x000054107f7f7816ULL, 0x000fe40000000089ULL, 0x0000541083837816ULL, 0x000fe2000000008eULL,
0x0000007a705c723cULL, 0x000f62000000185cULL, 0x00005410218c7816ULL, 0x000fe4000000008cULL,
0x000054108d8d7816ULL, 0x000fca000000008fULL, 0x0000007e7054723cULL, 0x040f700000001854ULL,
0x00000082704c723cULL, 0x040f70000000184cULL, 0x0000008c7048723cULL, 0x000b6e0000001848ULL,
0x000000101d707824ULL, 0x120fe200078e026bULL, 0x0000007a243c723cULL, 0x000f62000000183cULL,
0x000000101e6b7824ULL, 0x000fc800078e026bULL, 0x000000007070783bULL, 0x000e660000000200ULL,
0x0000007e2434723cULL, 0x040f700000001834ULL, 0x00000082242c723cULL, 0x040f70000000182cULL,
0x0000008c2428723cULL, 0x000b640000001828ULL, 0x000000006b24783bULL, 0x0206a20000000200ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x0000008000000947ULL, 0x000fde0003800000ULL,
0x0000000770707232ULL, 0x086fe40000000000ULL, 0x0000000772727232ULL, 0x000fc40000000000ULL,
0x0000000671717232ULL, 0x080fe40000000000ULL, 0x0000000673737232ULL, 0x000fe40000000000ULL,
0x0000000524247232ULL, 0x080fe40000000000ULL, 0x0000000526267232ULL, 0x000fe40000000000ULL,
0x0000000425257232ULL, 0x080fe40000000000ULL, 0x0000000427277232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000007878783bULL, 0x000f220000004200ULL,
0x00000010207c7824ULL, 0x000fe200078e0200ULL, 0xfffffff86a6a7812ULL, 0x000fca00078ec0ffULL,
0x000000007c7c783bULL, 0x000ee20000004200ULL, 0x00000010ff6c7819ULL, 0x010fe40000011679ULL,
0x000000ff796d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff207819ULL, 0x100fe40000011678ULL,
0x00000018ff217819ULL, 0x000fe40000011678ULL, 0x000000ff6c6c7812ULL, 0x000fe400078ec0ffULL,
0x000000ff786b7812ULL, 0x008fc400078ec0ffULL, 0x0000ffff78907812ULL, 0x000fe400078ec0ffULL,
0x00000018ff767819ULL, 0x000fe40000011679ULL, 0x0000ffff79917812ULL, 0x000fe400078ec0ffULL,
0x0000006dff78723eULL, 0x000fe400020006ffULL, 0x00000021ff6d723eULL, 0x000fe400020006ffULL,
0x000000ff20207812ULL, 0x000fc400078ec0ffULL, 0x0000006cff21723eULL, 0x000fe400020006ffULL,
0x00000076ff79723eULL, 0x000fe400020006ffULL, 0x00000008ff6c7819ULL, 0x000fe40000011690ULL,
0x00000010ff807819ULL, 0x100fe4000001167aULL, 0x000000ff7a827812ULL, 0x000fe400078ec0ffULL,
0x00000018ff817819ULL, 0x000fc4000001167aULL, 0x0000ffff7a927812ULL, 0x000fe400078ec0ffULL,
0x00000008ff767819ULL, 0x000fe40000011691ULL, 0x00000010ff7a7819ULL, 0x000fe4000001167bULL,
0x0000006bff6b723eULL, 0x000fe400020006ffULL, 0x00000020ff20723eULL, 0x000fe400020006ffULL,
0x0000006cff6c723eULL, 0x000fc400020006ffULL, 0x00000076ff76723eULL, 0x000fe400020006ffULL,
0x000054106b207816ULL, 0x000fe40000000020ULL, 0x000000ff7a7a7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff7b937812ULL, 0x000fe400078ec0ffULL, 0x00000008ff6b7819ULL, 0x000fe40000011692ULL,
0x0000ffff7c947812ULL, 0x000fc400078ec0ffULL, 0x000054106c6c7816ULL, 0x000fe4000000006dULL,
0x000000ff7b847812ULL, 0x000fe400078ec0ffULL, 0x00000018ff837819ULL, 0x000fe4000001167bULL,
0x00005410766d7816ULL, 0x000fe40000000079ULL, 0x00000018ff7b7819ULL, 0x000fe4000001167cULL,
0x0000007aff79723eULL, 0x000fc400020006ffULL, 0x00000008ff767819ULL, 0x000fe20000011693ULL,
0x0000006c7060723cULL, 0x082f620000001860ULL, 0x0000006bff7a723eULL, 0x000fe400020006ffULL,
0x0000ffff7d957812ULL, 0x000fe400078ec0ffULL, 0x00000008ff6b7819ULL, 0x000fe40000011694ULL,
0x00000010ff8a7819ULL, 0x100fe2000001167eULL, 0x0000006c2440723cULL, 0x004f620000001840ULL,
0x00000018ff8b7819ULL, 0x000fc4000001167eULL, 0x000000ff7e8c7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff7e967812ULL, 0x000fe400078ec0ffULL, 0x0000007bff7e723eULL, 0x000fe400020006ffULL,
0x00000076ff7b723eULL, 0x000fe400020006ffULL, 0x00000008ff767819ULL, 0x000fe40000011695ULL,
0x0000006bff6b723eULL, 0x000fc400020006ffULL, 0x00000010ff857819ULL, 0x000fe4000001167cULL,
0x00000010ff877819ULL, 0x000fe4000001167dULL, 0x00000010ff8d7819ULL, 0x100fe4000001167fULL,
0x0000ffff7f977812ULL, 0x040fe400078ec0ffULL, 0x00000018ff8e7819ULL, 0x000fe4000001167fULL,
0x000000ff7f8f7812ULL, 0x000fc400078ec0ffULL, 0x00000081ff81723eULL, 0x000fe400020006ffULL,
0x00000076ff7f723eULL, 0x000fe400020006ffULL, 0x000054106b7e7816ULL, 0x000fe4000000007eULL,
0x000000ff7c867812ULL, 0x000fe400078ec0ffULL, 0x000000ff7d897812ULL, 0x000fe400078ec0ffULL,
0x00000018ff887819ULL, 0x000fc4000001167dULL, 0x000000ff80807812ULL, 0x000fe400078ec0ffULL,
0x000000ff85857812ULL, 0x000fe400078ec0ffULL, 0x000000ff87877812ULL, 0x000fe400078ec0ffULL,
0x000000ff8a8a7812ULL, 0x000fe400078ec0ffULL, 0x000000ff8d8d7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff6b7819ULL, 0x000fc40000011696ULL, 0x00000008ff767819ULL, 0x000fe40000011697ULL,
0x0000541078217816ULL, 0x000fe40000000021ULL, 0x000054107a7a7816ULL, 0x000fe40000000081ULL,
0x00000082ff82723eULL, 0x000fe400020006ffULL, 0x00000084ff84723eULL, 0x000fe200020006ffULL,
0x000000207064723cULL, 0x000f620000001864ULL, 0x00000083ff83723eULL, 0x000fc400020006ffULL,
0x00000086ff7c723eULL, 0x000fe400020006ffULL, 0x00000089ff7d723eULL, 0x000fe400020006ffULL,
0x00000080ff78723eULL, 0x000fe200020006ffULL, 0x000000202444723cULL, 0x000f620000001844ULL,
0x00000088ff88723eULL, 0x000fe400020006ffULL, 0x0000008bff8b723eULL, 0x000fe400020006ffULL,
0x00000085ff85723eULL, 0x000fc400020006ffULL, 0x00000087ff87723eULL, 0x000fe400020006ffULL,
0x0000008cff8c723eULL, 0x000fe400020006ffULL, 0x0000008fff8f723eULL, 0x000fe400020006ffULL,
0x0000008aff8a723eULL, 0x000fe400020006ffULL, 0x0000008dff8d723eULL, 0x000fe400020006ffULL,
0x0000008eff8e723eULL, 0x000fc400020006ffULL, 0x0000006bff6b723eULL, 0x000fe400020006ffULL,
0x00000076ff81723eULL, 0x000fe400020006ffULL, 0x0000541082787816ULL, 0x000fe40000000078ULL,
0x0000541084797816ULL, 0x000fe40000000079ULL, 0x000054107b7b7816ULL, 0x000fe40000000083ULL,
0x000054107c7c7816ULL, 0x000fc40000000085ULL, 0x000054107d7d7816ULL, 0x000fe20000000087ULL,
0x00000078705c723cULL, 0x040f62000000185cULL, 0x000054107f7f7816ULL, 0x000fe40000000088ULL,
0x000054108c8c7816ULL, 0x000fe4000000008aULL, 0x000054108f8d7816ULL, 0x000fe4000000008dULL,
0x000054106b807816ULL, 0x000fe2000000008bULL, 0x0000007a7058723cULL, 0x000f620000001858ULL,
0x0000541081817816ULL, 0x000fce000000008eULL, 0x0000007c7054723cULL, 0x040f700000001854ULL,
0x0000007e7050723cULL, 0x040f700000001850ULL, 0x0000008c704c723cULL, 0x040f70000000184cULL,
0x000000807048723cULL, 0x000f700000001848ULL, 0x00000078243c723cULL, 0x040f70000000183cULL,
0x0000007a2438723cULL, 0x040f700000001838ULL, 0x0000007c2434723cULL, 0x040f700000001834ULL,
0x0000007e2430723cULL, 0x040f700000001830ULL, 0x0000008c242c723cULL, 0x040f70000000182cULL,
0x000000802428723cULL, 0x000b6e0000001828ULL, 0x000126c813267811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x0000000026267f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x012698006aff7f8cULL, 0x0005e4000c80043fULL,
0x0000000000207805ULL, 0x000fc40000015200ULL, 0x000004000d257984ULL, 0x000ee40000000800ULL,
0x8000000025ff7812ULL, 0x00afc40007804827ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff6a7224ULL, 0x004fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000106a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000247805ULL, 0x000fcc0000015200ULL,
0x00000024206b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000125257824ULL, 0x000fe200000e0e21ULL,
0x003d09006b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c406b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff247819ULL, 0x000fc80000011425ULL, 0x0000006b24247211ULL, 0x000fca00078110ffULL,
0x000000ffff257224ULL, 0x000fca00000e0625ULL, 0x0000000224247819ULL, 0x000fc80000001225ULL,
0x000000240000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000016a6a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004000d257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe40007804827ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000010f207810ULL, 0x000fc80007ffe0ffULL,
0x000000152000720cULL, 0x000fda0003f06070ULL, 0x0000072000000947ULL, 0x000fea0003800000ULL,
0x000000020f207810ULL, 0x000fe40007ffe0ffULL, 0x000001000c217810ULL, 0x000fe40007ffe0ffULL,
0x000000152000720cULL, 0x000fc60003f06070ULL, 0x00006600126c7a24ULL, 0x000fd400078e0221ULL,
0x000003d000008947ULL, 0x000fea0003800000ULL, 0x00000021160c7217ULL, 0x000fe20007800000ULL,
0x0000001011277824ULL, 0x000fe200078e00ffULL, 0x00000003ff257819ULL, 0x000fc60000011617ULL,
0x000000010c0c7824ULL, 0x000fe200078e0a21ULL, 0x00000004256b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000127207824ULL, 0x000fe200078e0225ULL, 0x0000000825717810ULL, 0x000fe40007ffe0ffULL,
0x0000000c270c7217ULL, 0x000fe20007800000ULL, 0x0000000120217824ULL, 0x040fe200078e0217ULL,
0x0000000c25737810ULL, 0x000fe20007ffe0ffULL, 0x0000000820247824ULL, 0x000fe400078e00ffULL,
0x0000000127707824ULL, 0x000fc400078e026bULL, 0x0000000120207824ULL, 0x100fe200078e026cULL,
0xfffffff8246d7812ULL, 0x000fe200078ee221ULL, 0x000000010c0c7824ULL, 0x000fe400078e0a27ULL,
0x0000000170247824ULL, 0x000fe400078e026cULL, 0x0000008020207825ULL, 0x000fe200078e00ffULL,
0x0000000c2500720cULL, 0x080fe40003f06070ULL, 0x0000000c7100720cULL, 0x080fe20003f66070ULL,
0x0000000127727824ULL, 0x000fe200078e0271ULL, 0x0000000b206a7212ULL, 0x000fe200078efcffULL,
0x0000008024247825ULL, 0x000fe200078e00ffULL, 0x0000000c6b00720cULL, 0x000fc40003f86070ULL,
0x000062006a6a7a10ULL, 0x000fe20007fbe0ffULL, 0x0000000172267824ULL, 0x100fe200078e026cULL,
0x0000000b24247212ULL, 0x080fe200078efcffULL, 0x0000000127767824ULL, 0x000fe200078e0273ULL,
0x00006300216b7a10ULL, 0x000fe20002ffe4ffULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x0000620024247a10ULL, 0x000fe40007fde0ffULL, 0x0000000c7300720cULL, 0x000fe20003fa6070ULL,
0x0000000176207824ULL, 0x000fe200078e026cULL, 0x0000000b26267212ULL, 0x000fe200078efcffULL,
0x00000001706c7824ULL, 0x040fe200078e0217ULL, 0x0000630025257a10ULL, 0x000fe200037fe4ffULL,
0x0000000870717824ULL, 0x000fe200078e00ffULL, 0x0000620026267a10ULL, 0x000fe20007fde0ffULL,
0x0000008020207825ULL, 0x000fc600078e00ffULL, 0xfffffff871717812ULL, 0x000fe200078ee26cULL,
0x00000001720c7824ULL, 0x100fe200078e0217ULL, 0x0000000b20207212ULL, 0x000fe200078efcffULL,
0x0000000872737824ULL, 0x000fe200078e00ffULL, 0x0000630027277a10ULL, 0x000fe200037fe4ffULL,
0x00000001766c7824ULL, 0x000fe200078e0217ULL, 0x0000620020207a10ULL, 0x000fe20007fde0ffULL,
0x0000000876797824ULL, 0x000fe200078e00ffULL, 0xfffffff873737812ULL, 0x000fe200078ee20cULL,
0x000000106d6d7824ULL, 0x100fe200078e0200ULL, 0x0000630021217a10ULL, 0x000fe200037fe4ffULL,
0x0000001071717824ULL, 0x000fe200078e0200ULL, 0xfffffff879797812ULL, 0x000fe200078ee26cULL,
0x0000001073737824ULL, 0x100fe200078e0200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006a6d7faeULL, 0x0003e6000c101c48ULL, 0x0000001079797824ULL, 0x000fe200078e0200ULL,
0x0000000024717faeULL, 0x0003e8000e101c48ULL, 0x0000000026737faeULL, 0x0003e8000d901c48ULL,
0x0000000020797faeULL, 0x0003e2000e901c48ULL, 0x0000030000007947ULL, 0x000fea0003800000ULL,
0x00000010110c7824ULL, 0x000fca00078e00ffULL, 0x0000000c170c7211ULL, 0x000fc800078fe8ffULL,
0x000000040c247810ULL, 0x040fe20007ffe0ffULL, 0x000000010c207824ULL, 0x140fe200078e0217ULL,
0x000000080c267810ULL, 0x040fe20007ffe0ffULL, 0x000000080c6d7824ULL, 0x000fe400078e00ffULL,
0x0000000124217824ULL, 0x140fe400078e0217ULL, 0x00000008246a7824ULL, 0x000fe200078e00ffULL,
0xfffffff86d6d7812ULL, 0x000fe200078ee220ULL, 0x000000010c207824ULL, 0x040fe200078e026cULL,
0x0000000c0c0c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000126257824ULL, 0x000fe200078e0217ULL,
0xfffffff86a717812ULL, 0x000fe200078ee221ULL, 0x0000000826707824ULL, 0x000fc400078e00ffULL,
0x0000000124247824ULL, 0x000fe400078e026cULL, 0x0000008020207825ULL, 0x000fe200078e00ffULL,
0xfffffff870737812ULL, 0x000fc600078ee225ULL, 0x0000000126267824ULL, 0x100fe200078e026cULL,
0x0000000b20207212ULL, 0x000fe200078efcffULL, 0x000000010c6a7824ULL, 0x000fe400078e026cULL,
0x0000008024247825ULL, 0x000fe200078e00ffULL, 0x0000620020207a10ULL, 0x000fc60007f1e0ffULL,
0x0000008026267825ULL, 0x000fe200078e00ffULL, 0x0000000b24247212ULL, 0x080fe400078efcffULL,
0x0000630021217a10ULL, 0x000fe200007fe4ffULL, 0x000000806a6a7825ULL, 0x000fe200078e00ffULL,
0x0000000b26267212ULL, 0x080fe400078efcffULL, 0x0000620024247a10ULL, 0x000fe20007f7e0ffULL,
0x000000010c6c7824ULL, 0x000fe200078e0217ULL, 0x0000000b6a6a7212ULL, 0x000fe200078efcffULL,
0x000000080c797824ULL, 0x000fe200078e00ffULL, 0x0000620026267a10ULL, 0x000fe20007f1e0ffULL,
0x000000106d6d7824ULL, 0x100fe200078e0200ULL, 0x000062006a6a7a10ULL, 0x000fe20007f9e0ffULL,
0x0000001071717824ULL, 0x000fe200078e0200ULL, 0xfffffff879797812ULL, 0x000fe200078ee26cULL,
0x0000001073737824ULL, 0x100fe200078e0200ULL, 0x0000630025257a10ULL, 0x000fe20001ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000206d7faeULL, 0x0003e2000b901c48ULL,
0x0000630027277a10ULL, 0x000fe200007fe4ffULL, 0x0000001079797824ULL, 0x000fe200078e0200ULL,
0x000063006b6b7a10ULL, 0x000fe200027fe4ffULL, 0x0000000024717faeULL, 0x0003e8000b901c48ULL,
0x0000000026737faeULL, 0x0003e8000b901c48ULL, 0x000000006a797faeULL, 0x0003e4000b901c48ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000814217812ULL, 0x000fe200078ec0ffULL,
0x00000020100c7824ULL, 0x000fc400078e020eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe40008000a04ULL,
0x00000001210c7824ULL, 0x000fe200078e020cULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000086c7f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x012668000c267f8cULL, 0x000664000c80043fULL,
0x0000000000207805ULL, 0x000fc40000015200ULL, 0x01266c000c257984ULL, 0x000f240000000800ULL,
0x8000000025ff7812ULL, 0x012fe40007804827ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff6a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000106a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000247805ULL, 0x000fcc0000015200ULL,
0x00000024206b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000125257824ULL, 0x000fe200000e0e21ULL,
0x003d09006b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c406b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc80000011425ULL, 0x0000006b08087211ULL, 0x000fca00078110ffULL,
0x000000ffff257224ULL, 0x000fca00000e0625ULL, 0x0000000208087819ULL, 0x000fc80000001225ULL,
0x000000080000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000016a6a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01266c000c257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe40007804827ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000018010087811ULL, 0x000fc800078e38ffULL,
0x000000080a087210ULL, 0x000fca0007ffe00bULL, 0x01200000080c7984ULL, 0x008e680000000800ULL,
0x0122000008207984ULL, 0x0006a20000000800ULL, 0x000000230c00720bULL, 0x002fe20003f1d000ULL,
0x0000be227f007947ULL, 0x000fd8000b800000ULL, 0x0000000000217806ULL, 0x008fc800000e0100ULL,
0x000000ff2100720cULL, 0x000fe20003f05270ULL, 0x0000075000007945ULL, 0x000fe20003800000ULL,
0x00000001ff247424ULL, 0x000fe400078e00ffULL, 0x000000ffff087224ULL, 0x000fd200078e0023ULL,
0x0000071000008947ULL, 0x000fea0003800000ULL, 0x0000000310257810ULL, 0x000fe40007ffe0ffULL,
0x000000230c00720bULL, 0x000fe40003f74000ULL, 0x0000001a2500720cULL, 0x000fe20003f05270ULL,
0x0000bdd27f007947ULL, 0x000fd4000b800000ULL, 0x00000000006c7806ULL, 0x004fc400018e0100ULL,
0x000000801a0b8824ULL, 0x000fe200078e020bULL, 0x000000230c087209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x000000010a0b8824ULL, 0x000fca00078e020bULL,
0x012400080b008388ULL, 0x0003e20000000800ULL, 0x000000ff6c00720cULL, 0x000fda0003f05270ULL,
0x000005e000008947ULL, 0x000fea0003800000ULL, 0x00000023080a7221ULL, 0x002fe20000010100ULL,
0x000000ff6cff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b0a0a7820ULL, 0x000fc80000410000ULL, 0x0000000a00277308ULL, 0x000e640000000800ULL,
0x0000002722227220ULL, 0x002fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff267819ULL, 0x000fe20000011617ULL, 0x0000bd127f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0002a400000e0000ULL, 0x0000002664647220ULL, 0x084fe20000410000ULL,
0x0000002665657220ULL, 0x080fe20000410000ULL, 0x0000002660607220ULL, 0x080fe20000410000ULL,
0x0000002661617220ULL, 0x080fe20000410000ULL, 0x000000265c5c7220ULL, 0x080fe20000410000ULL,
0x000000265d5d7220ULL, 0x080fe20000410000ULL, 0x0000002658587220ULL, 0x080fe20000410000ULL,
0x0000002659597220ULL, 0x080fe20000410000ULL, 0x0000002654547220ULL, 0x080fe20000410000ULL,
0x0000002655557220ULL, 0x080fe20000410000ULL, 0x0000002650507220ULL, 0x080fe20000410000ULL,
0x0000002651517220ULL, 0x080fe20000410000ULL, 0x000000264c4c7220ULL, 0x080fe20000410000ULL,
0x000000264d4d7220ULL, 0x080fe20000410000ULL, 0x0000002648487220ULL, 0x080fe20000410000ULL,
0x0000002649497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff006cff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000817267811ULL, 0x000fe200078ff0ffULL,
0x0000bbd27f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0004e400000e0000ULL,
0x0000002666667220ULL, 0x08cfe20000410000ULL, 0x0000002667677220ULL, 0x080fe20000410000ULL,
0x0000002662627220ULL, 0x080fe20000410000ULL, 0x0000002663637220ULL, 0x080fe20000410000ULL,
0x000000265e5e7220ULL, 0x080fe20000410000ULL, 0x000000265f5f7220ULL, 0x080fe20000410000ULL,
0x000000265a5a7220ULL, 0x080fe20000410000ULL, 0x000000265b5b7220ULL, 0x080fe20000410000ULL,
0x0000002656567220ULL, 0x080fe20000410000ULL, 0x0000002657577220ULL, 0x080fe20000410000ULL,
0x0000002652527220ULL, 0x080fe20000410000ULL, 0x0000002653537220ULL, 0x080fe20000410000ULL,
0x000000264e4e7220ULL, 0x080fe20000410000ULL, 0x000000264f4f7220ULL, 0x080fe20000410000ULL,
0x000000264a4a7220ULL, 0x080fe20000410000ULL, 0x000000264b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff00006cff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001017267811ULL, 0x000fe200078ff0ffULL, 0x0000ba927f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0004e400000e0000ULL, 0x0000002644447220ULL, 0x08cfe20000410000ULL,
0x0000002645457220ULL, 0x080fe20000410000ULL, 0x0000002640407220ULL, 0x080fe20000410000ULL,
0x0000002641417220ULL, 0x080fe20000410000ULL, 0x000000263c3c7220ULL, 0x080fe20000410000ULL,
0x000000263d3d7220ULL, 0x080fe20000410000ULL, 0x0000002638387220ULL, 0x080fe20000410000ULL,
0x0000002639397220ULL, 0x080fe20000410000ULL, 0x0000002634347220ULL, 0x080fe20000410000ULL,
0x0000002635357220ULL, 0x080fe20000410000ULL, 0x0000002630307220ULL, 0x080fe20000410000ULL,
0x0000002631317220ULL, 0x080fe20000410000ULL, 0x000000262c2c7220ULL, 0x080fe20000410000ULL,
0x000000262d2d7220ULL, 0x080fe20000410000ULL, 0x0000002628287220ULL, 0x080fe20000410000ULL,
0x0000002629297220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff0000006cff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001817267811ULL, 0x000fe200078ff0ffULL, 0x0000b9627f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0004e400000e0000ULL, 0x0000002646467220ULL, 0x08cfe20000410000ULL,
0x0000002647477220ULL, 0x080fe20000410000ULL, 0x0000002642427220ULL, 0x080fe20000410000ULL,
0x0000002643437220ULL, 0x080fe20000410000ULL, 0x000000263e3e7220ULL, 0x080fe20000410000ULL,
0x000000263f3f7220ULL, 0x080fe20000410000ULL, 0x000000263a3a7220ULL, 0x080fe20000410000ULL,
0x000000263b3b7220ULL, 0x080fe20000410000ULL, 0x0000002636367220ULL, 0x080fe20000410000ULL,
0x0000002637377220ULL, 0x080fe20000410000ULL, 0x0000002632327220ULL, 0x080fe20000410000ULL,
0x0000002633337220ULL, 0x080fe20000410000ULL, 0x000000262e2e7220ULL, 0x080fe20000410000ULL,
0x000000262f2f7220ULL, 0x080fe20000410000ULL, 0x000000262a2a7220ULL, 0x080fe20000410000ULL,
0x000000262b2b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000006c21ff7212ULL, 0x000fda00078030ffULL, 0x0000000c080c0221ULL, 0x000fe20000010100ULL,
0x00007610ff240816ULL, 0x000fc60000000024ULL, 0x3fb8aa3b0c0c0820ULL, 0x000fc80000410000ULL,
0x0000000c00090308ULL, 0x000e640000000800ULL, 0x0000000920200220ULL, 0x002fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002220227221ULL, 0x004fc20000010000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0xfffffff014267812ULL, 0x000fca00078ec0ffULL,
0x0126b40026217984ULL, 0x000e640000000800ULL, 0x8000000021ff7812ULL, 0x002fe40007804869ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff257224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000207805ULL, 0x000fcc0000015200ULL, 0x000000200a237210ULL, 0x000fca0007f1e1ffULL,
0x0000000121217824ULL, 0x000fe200000e0e0bULL, 0x003d09002300780cULL, 0x000fc80003f06070ULL,
0x000000ff2100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402300780cULL, 0x000fc80003f06070ULL, 0x000000ff2100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0c7819ULL, 0x000fc80000011421ULL,
0x000000230c0c7211ULL, 0x000fca00078110ffULL, 0x000000ffff217224ULL, 0x000fca00000e0621ULL,
0x000000020c0c7819ULL, 0x000fc80000001221ULL, 0x0000000c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000125257810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0126b40026217984ULL, 0x000e640000000800ULL,
0x8000000021ff7812ULL, 0x002fe40007804869ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009910240a7816ULL, 0x000fe200000000ffULL, 0x0000010000007945ULL, 0x000fe60003800000ULL,
0x000000ff0a00720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000009ff04723eULL, 0x000fe400000000ffULL, 0x00000002ff0a7819ULL, 0x000fe40000011617ULL,
0x0000541004277816ULL, 0x000fe20000000004ULL, 0x0000b5327f007947ULL, 0x000fea000b800000ULL,
0x00001f0a27077589ULL, 0x0002a400000e0000ULL, 0x000000080a267810ULL, 0x000fe20007ffe0ffULL,
0x0000b5527f007947ULL, 0x000fea000b800000ULL, 0x000000100a047810ULL, 0x000fe20007ffe0ffULL,
0x00001f2627067589ULL, 0x00066800000e0000ULL, 0x00001f0427057589ULL, 0x0006a400000e0000ULL,
0x000000180a267810ULL, 0x008fe20007ffe0ffULL, 0x0000b5827f007947ULL, 0x000fea000b800000ULL,
0x00001f2627047589ULL, 0x0006a400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001130a7812ULL, 0x002fe200078ec0ffULL, 0x0000000803247824ULL, 0x040fe200078e00ffULL,
0x00000004ff0b7819ULL, 0x000fe20000011617ULL, 0x0000000802217824ULL, 0x000fe200078e00ffULL,
0x0000100000007810ULL, 0x000fe20007ffe0ffULL, 0x000000041a207824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000040a0a7824ULL, 0x000fe200078e020bULL,
0x0000017000007945ULL, 0x000fe20003800000ULL, 0x000000101c707824ULL, 0x000fe200078e0200ULL,
0x0000000420207812ULL, 0x000fe200078ec0ffULL, 0x00000001030b7824ULL, 0x000fc400078e020aULL,
0x00000001020c7824ULL, 0x000fe200078e020aULL, 0x0000000220207812ULL, 0x000fe400078efcffULL,
0xfffffff8240a7812ULL, 0x000fe400078ee20bULL, 0x0000d000100b7811ULL, 0x000fe400078e60ffULL,
0xfffffff8210c7812ULL, 0x000fc600078ee20cULL, 0x000000100a687824ULL, 0x100fe200078e020bULL,
0x00000020170a7211ULL, 0x000fe200078fe0ffULL, 0x000000100c0c7824ULL, 0x000fc800078e020bULL,
0x000000006868783bULL, 0x000e680000000200ULL, 0x000000000c24783bULL, 0x0086a20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000768687232ULL, 0x086fe40000000000ULL,
0x000000076a6a7232ULL, 0x000fe40000000000ULL, 0x0000000669697232ULL, 0x080fe40000000000ULL,
0x000000066b6b7232ULL, 0x000fc40000000000ULL, 0x0000000524247232ULL, 0x080fe40000000000ULL,
0x0000000526267232ULL, 0x000fe40000000000ULL, 0x0000000425257232ULL, 0x080fe40000000000ULL,
0x0000000427277232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000008030c7824ULL, 0x048fe200078e00ffULL, 0x000000007070783bULL, 0x000ee20000004200ULL,
0x0000000103037824ULL, 0x000fe200078e020aULL, 0x0000083000007945ULL, 0x000fe20003800000ULL,
0x000000101e1e7824ULL, 0x000fc600078e020bULL, 0xfffffff80c037812ULL, 0x000fca00078ee203ULL,
0x0000001003037824ULL, 0x000fca00078e0200ULL, 0x000000000378783bULL, 0x0008a20000004200ULL,
0x000000ff73777812ULL, 0x008fe400078ec0ffULL, 0x00000018ff037819ULL, 0x010fe40000011672ULL,
0x00000010ff0c7819ULL, 0x000fe40000011670ULL, 0x0000ffff70867812ULL, 0x000fe400078ec0ffULL,
0x00000010ff217819ULL, 0x000fe40000011671ULL, 0x000000ff716c7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff237819ULL, 0x000fe40000011671ULL, 0x0000ffff71877812ULL, 0x000fe400078ec0ffULL,
0x00000010ff767819ULL, 0x100fe40000011673ULL, 0x00000018ff717819ULL, 0x000fe40000011673ULL,
0x0000ffff73897812ULL, 0x000fe400078ec0ffULL, 0x000000ff70207812ULL, 0x000fc400078ec0ffULL,
0x00000018ff1c7819ULL, 0x000fe40000011670ULL, 0x00000077ff73723eULL, 0x000fe400020006ffULL,
0x000000ff72707812ULL, 0x000fe400078ec0ffULL, 0x00000003ff77723eULL, 0x000fe400020006ffULL,
0x000000ff0c0c7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff037819ULL, 0x000fc40000011686ULL,
0x000000ff76767812ULL, 0x000fe400078ec0ffULL, 0x0000ffff72887812ULL, 0x000fe400078ec0ffULL,
0x00000010ff747819ULL, 0x000fe40000011672ULL, 0x00000070ff72723eULL, 0x000fe400020006ffULL,
0x00000020ff20723eULL, 0x000fe400020006ffULL, 0x0000000cff0c723eULL, 0x000fc400020006ffULL,
0x00000003ff70723eULL, 0x000fe400020006ffULL, 0x00000076ff76723eULL, 0x000fe400020006ffULL,
0x00000008ff037819ULL, 0x000fe40000011688ULL, 0x0000ffff788a7812ULL, 0x004fe400078ec0ffULL,
0x0000541020207816ULL, 0x000fe4000000000cULL, 0x0000541073737816ULL, 0x000fc40000000076ULL,
0x00000008ff0c7819ULL, 0x000fe40000011689ULL, 0x00000003ff76723eULL, 0x000fe400020006ffULL,
0x00000018ff7d7819ULL, 0x000fe40000011678ULL, 0x00000008ff037819ULL, 0x000fe4000001168aULL,
0x00000010ff7c7819ULL, 0x000fe40000011678ULL, 0x000000ff787e7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff7f7819ULL, 0x100fe40000011679ULL, 0x000000ff79817812ULL, 0x040fe400078ec0ffULL,
0x00000018ff807819ULL, 0x000fe40000011679ULL, 0x0000ffff798b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff827819ULL, 0x000fe4000001167aULL, 0x000000ff7a797812ULL, 0x000fc400078ec0ffULL,
0x00000018ff837819ULL, 0x000fe4000001167aULL, 0x0000ffff7a8c7812ULL, 0x000fe400078ec0ffULL,
0x00000023ff6f723eULL, 0x000fe400020006ffULL, 0x00000071ff78723eULL, 0x000fe400020006ffULL,
0x0000000cff0c723eULL, 0x000fe400020006ffULL, 0x00000010ff7a7819ULL, 0x000fc4000001167bULL,
0x000000ff7b857812ULL, 0x040fe400078ec0ffULL, 0x00000018ff847819ULL, 0x000fe4000001167bULL,
0x00000008ff237819ULL, 0x000fe40000011687ULL, 0x0000007dff7d723eULL, 0x000fe400020006ffULL,
0x00000003ff03723eULL, 0x000fe400020006ffULL, 0x0000ffff7b7b7812ULL, 0x000fc400078ec0ffULL,
0x0000001cff1c723eULL, 0x000fe400020006ffULL, 0x0000541076767816ULL, 0x000fe40000000077ULL,
0x000054100c777816ULL, 0x000fe40000000078ULL, 0x00000023ff71723eULL, 0x000fe400020006ffULL,
0x00000008ff0c7819ULL, 0x000fe4000001168bULL, 0x000000ff7a7a7812ULL, 0x000fe200078ec0ffULL,
0x000000766858723cULL, 0x002f620000001858ULL, 0x0000541003787816ULL, 0x000fc4000000007dULL,
0x000000ff21217812ULL, 0x000fe400078ec0ffULL, 0x000000ff74747812ULL, 0x000fe400078ec0ffULL,
0x000000ff7c7c7812ULL, 0x000fe200078ec0ffULL, 0x000000762438723cULL, 0x000f620000001838ULL,
0x000000ff7f7f7812ULL, 0x000fe400078ec0ffULL, 0x000000ff82827812ULL, 0x000fe400078ec0ffULL,
0x00000008ff037819ULL, 0x000fc4000001168cULL, 0x00000008ff237819ULL, 0x000fe4000001167bULL,
0x0000541070707816ULL, 0x000fe4000000001cULL, 0x00000079ff1c723eULL, 0x000fe400020006ffULL,
0x00000085ff85723eULL, 0x000fe400020006ffULL, 0x0000000cff79723eULL, 0x000fe400020006ffULL,
0x0000007aff7a723eULL, 0x000fc400020006ffULL, 0x0000006cff6c723eULL, 0x000fe400020006ffULL,
0x0000007eff7e723eULL, 0x000fe400020006ffULL, 0x00000021ff21723eULL, 0x000fe400020006ffULL,
0x00000081ff81723eULL, 0x000fe400020006ffULL, 0x00000074ff74723eULL, 0x000fe400020006ffULL,
0x00000080ff80723eULL, 0x000fc400020006ffULL, 0x0000007cff7c723eULL, 0x000fe400020006ffULL,
0x0000007fff7f723eULL, 0x000fe400020006ffULL, 0x00000083ff0c723eULL, 0x000fe400020006ffULL,
0x00000082ff82723eULL, 0x000fe400020006ffULL, 0x00000084ff84723eULL, 0x000fe400020006ffULL,
0x00000003ff03723eULL, 0x000fc400020006ffULL, 0x00000023ff7b723eULL, 0x000fe400020006ffULL,
0x0000541085837816ULL, 0x000fe4000000007aULL, 0x000054106c217816ULL, 0x000fe40000000021ULL,
0x0000541071717816ULL, 0x000fe4000000006fULL, 0x0000541072727816ULL, 0x000fe40000000074ULL,
0x000054107e7e7816ULL, 0x000fe2000000007cULL, 0x000000206864723cULL, 0x000f620000001864ULL,
0x00005410817f7816ULL, 0x000fc4000000007fULL, 0x0000541079797816ULL, 0x000fe40000000080ULL,
0x000054101c827816ULL, 0x000fe40000000082ULL, 0x00005410037a7816ULL, 0x000fe2000000000cULL,
0x000000101d037824ULL, 0x000fe200078e020bULL, 0x000054107b7b7816ULL, 0x000fe20000000084ULL,
0x000000706860723cULL, 0x040f700000001860ULL, 0x00000072685c723cULL, 0x040f70000000185cULL,
0x0000007e6854723cULL, 0x040f700000001854ULL, 0x000000786850723cULL, 0x040f700000001850ULL,
0x00000082684c723cULL, 0x040f70000000184cULL, 0x0000007a6848723cULL, 0x000b6e0000001848ULL,
0x000000101f687824ULL, 0x020fe200078e0200ULL, 0x000000202444723cULL, 0x040f620000001844ULL,
0x000000001e1c783bULL, 0x000e6e0000000200ULL, 0x000000702440723cULL, 0x040f700000001840ULL,
0x00000072243c723cULL, 0x040f70000000183cULL, 0x0000007e2434723cULL, 0x040f700000001834ULL,
0x000000782430723cULL, 0x040f700000001830ULL, 0x00000082242c723cULL, 0x040f70000000182cULL,
0x0000007a2428723cULL, 0x000b640000001828ULL, 0x000000000324783bULL, 0x0204e20000000200ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x0000008000000947ULL, 0x000fde0003800000ULL,
0x0000000724247232ULL, 0x08afe40000000000ULL, 0x0000000726267232ULL, 0x000fc40000000000ULL,
0x0000000625257232ULL, 0x080fe40000000000ULL, 0x0000000627277232ULL, 0x000fe40000000000ULL,
0x000000051c1c7232ULL, 0x080fe40000000000ULL, 0x000000051e1e7232ULL, 0x000fe40000000000ULL,
0x000000041d1d7232ULL, 0x080fe40000000000ULL, 0x000000041f1f7232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x002fea0003800000ULL, 0x000000006868783bULL, 0x000e620000004200ULL,
0x0000000802037824ULL, 0x004fc400078e00ffULL, 0x0000000102027824ULL, 0x000fca00078e020aULL,
0xfffffff803037812ULL, 0x000fca00078ee202ULL, 0x0000001003037824ULL, 0x000fca00078e0200ULL,
0x000000000370783bULL, 0x0005220000004200ULL, 0x00000010ff007819ULL, 0x002fe40000011668ULL,
0x00000010ff0b7819ULL, 0x100fe40000011669ULL, 0x000000ff680a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff00007812ULL, 0x000fe400078ec0ffULL, 0x000000ff690c7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff207819ULL, 0x000fc40000011669ULL, 0x00000018ff027819ULL, 0x000fe40000011668ULL,
0x0000ffff687e7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff697f7812ULL, 0x000fe400078ec0ffULL,
0x000000ff0b0b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff687819ULL, 0x000fe4000001166aULL,
0x000000ff6a697812ULL, 0x000fc400078ec0ffULL, 0x00000018ff217819ULL, 0x000fe4000001166aULL,
0x0000ffff6a807812ULL, 0x000fe400078ec0ffULL, 0x0000000aff0a723eULL, 0x000fe400020006ffULL,
0x00000000ff00723eULL, 0x000fe400020006ffULL, 0x000000ff6b6a7812ULL, 0x000fe400078ec0ffULL,
0x0000000cff03723eULL, 0x004fc400020006ffULL, 0x00000020ff23723eULL, 0x000fe400020006ffULL,
0x00000002ff0c723eULL, 0x000fe400020006ffULL, 0x0000000bff20723eULL, 0x000fe400020006ffULL,
0x00000010ff6c7819ULL, 0x100fe4000001166bULL, 0x00000018ff6f7819ULL, 0x000fe4000001166bULL,
0x0000ffff6b817812ULL, 0x000fc400078ec0ffULL, 0x00000008ff0b7819ULL, 0x000fe4000001167eULL,
0x000054100a027816ULL, 0x000fe40000000000ULL, 0x0000006aff6b723eULL, 0x000fe400020006ffULL,
0x00000008ff007819ULL, 0x000fe40000011680ULL, 0x00000021ff6a723eULL, 0x000fe400020006ffULL,
0x00000008ff217819ULL, 0x000fc4000001167fULL, 0x0000000bff0a723eULL, 0x000fe400020006ffULL,
0x000000ff6c6c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff747819ULL, 0x010fe40000011670ULL,
0x00000000ff00723eULL, 0x000fe400020006ffULL, 0x0000ffff70827812ULL, 0x000fe400078ec0ffULL,
0x00000021ff0b723eULL, 0x000fc400020006ffULL, 0x000000ff70777812ULL, 0x000fe400078ec0ffULL,
0x00000018ff767819ULL, 0x000fe40000011670ULL, 0x000054100a0a7816ULL, 0x000fe4000000000cULL,
0x0000006cff21723eULL, 0x000fe400020006ffULL, 0x00000010ff707819ULL, 0x000fe40000011671ULL,
0x000000ff71797812ULL, 0x000fc400078ec0ffULL, 0x00000018ff787819ULL, 0x000fe40000011671ULL,
0x0000ffff71837812ULL, 0x000fe400078ec0ffULL, 0x00000008ff0c7819ULL, 0x000fe40000011681ULL,
0x000000ff74747812ULL, 0x000fe400078ec0ffULL, 0x00005410006a7816ULL, 0x000fe4000000006aULL,
0x00000010ff717819ULL, 0x000fc40000011672ULL, 0x00000008ff007819ULL, 0x000fe40000011682ULL,
0x000000ff68687812ULL, 0x000fe400078ec0ffULL, 0x000054106b217816ULL, 0x000fe40000000021ULL,
0x00000018ff7a7819ULL, 0x000fe40000011672ULL, 0x000000ff727b7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff72847812ULL, 0x000fc400078ec0ffULL, 0x00000077ff77723eULL, 0x000fe400020006ffULL,
0x0000000cff6b723eULL, 0x000fe400020006ffULL, 0x00000074ff74723eULL, 0x000fe400020006ffULL,
0x00000010ff727819ULL, 0x100fe40000011673ULL, 0x00000018ff7c7819ULL, 0x000fe40000011673ULL,
0x000000ff737d7812ULL, 0x000fc400078ec0ffULL, 0x00000076ff76723eULL, 0x000fe400020006ffULL,
0x00000008ff0c7819ULL, 0x000fe40000011683ULL, 0x00000000ff00723eULL, 0x000fe400020006ffULL,
0x000000ff71717812ULL, 0x000fe400078ec0ffULL, 0x0000ffff73737812ULL, 0x000fe400078ec0ffULL,
0x0000541003037816ULL, 0x000fc40000000020ULL, 0x00000069ff69723eULL, 0x000fe400020006ffULL,
0x00000068ff20723eULL, 0x000fe400020006ffULL, 0x000000ff70707812ULL, 0x000fe200078ec0ffULL,
0x000000022464723cULL, 0x008b620000001864ULL, 0x0000541077687816ULL, 0x000fe40000000074ULL,
0x0000007bff7b723eULL, 0x000fe400020006ffULL, 0x0000000cff77723eULL, 0x000fc400020006ffULL,
0x0000541000767816ULL, 0x000fe20000000076ULL, 0x000000021c44723cULL, 0x000b620000001844ULL,
0x00000071ff71723eULL, 0x000fe400020006ffULL, 0x000000ff72727812ULL, 0x000fe400078ec0ffULL,
0x00000008ff007819ULL, 0x000fe40000011684ULL, 0x00000008ff0c7819ULL, 0x000fe40000011673ULL,
0x0000541069207816ULL, 0x000fc40000000020ULL, 0x00000070ff69723eULL, 0x000fe400020006ffULL,
0x000054107b707816ULL, 0x000fe40000000071ULL, 0x0000006fff6f723eULL, 0x000fe200020006ffULL,
0x00000020245c723cULL, 0x000b62000000185cULL, 0x00000079ff79723eULL, 0x000fe400020006ffULL,
0x00000078ff78723eULL, 0x000fe400020006ffULL, 0x0000007aff7a723eULL, 0x000fc400020006ffULL,
0x0000007dff7d723eULL, 0x000fe200020006ffULL, 0x000000201c3c723cULL, 0x000b62000000183cULL,
0x00000072ff72723eULL, 0x000fe400020006ffULL, 0x0000007cff7c723eULL, 0x000fe400020006ffULL,
0x00000000ff00723eULL, 0x000fe400020006ffULL, 0x0000000cff7b723eULL, 0x000fe400020006ffULL,
0x000054100b0b7816ULL, 0x000fc40000000023ULL, 0x000054106b6b7816ULL, 0x000fe4000000006fULL,
0x0000541079697816ULL, 0x000fe40000000069ULL, 0x0000541077777816ULL, 0x000fe20000000078ULL,
0x0000000a2460723cULL, 0x000b620000001860ULL, 0x000054107d717816ULL, 0x000fe40000000072ULL,
0x00005410007a7816ULL, 0x000fe4000000007aULL, 0x000054107b7b7816ULL, 0x000fc6000000007cULL,
0x0000006a2458723cULL, 0x040b700000001858ULL, 0x000000682454723cULL, 0x040b700000001854ULL,
0x000000762450723cULL, 0x040b700000001850ULL, 0x00000070244c723cULL, 0x040b70000000184cULL,
0x0000007a2448723cULL, 0x000b700000001848ULL, 0x0000000a1c40723cULL, 0x040b700000001840ULL,
0x0000006a1c38723cULL, 0x040b700000001838ULL, 0x000000681c34723cULL, 0x040b700000001834ULL,
0x000000761c30723cULL, 0x040b700000001830ULL, 0x000000701c2c723cULL, 0x040b70000000182cULL,
0x0000007a1c28723cULL, 0x000b620000001828ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fda0000008000ULL,
0x000000000d027f8cULL, 0x0202a2000c80043fULL, 0x000000010f0f7810ULL, 0x000fc40007ffe0ffULL,
0x000126a0100a7811ULL, 0x000fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000000aff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff007224ULL, 0x004fe200078e0003ULL,
0x0000001000002944ULL, 0x000fe20003c00000ULL, 0xffff513000007947ULL, 0x000fea000383ffffULL,
0x000000ff1500720cULL, 0x000fe20003f05270ULL, 0x000000ffff0f7224ULL, 0x000fe400078e002bULL,
0x000000ffff687224ULL, 0x000fe400078e002aULL, 0x000000ffff0d7224ULL, 0x002fe400078e002fULL,
0x000000ffff247224ULL, 0x000fc400078e002eULL, 0x000000ffff0b7224ULL, 0x000fe400078e0033ULL,
0x000000ffff207224ULL, 0x000fe400078e0032ULL, 0x000005b000008947ULL, 0x000fea0003800000ULL,
0x0180000022007810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0000c7f000047802ULL, 0x000fc40000000f00ULL,
0x0000a4b000007944ULL, 0x00cfea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000002200037308ULL, 0x004e640000001000ULL, 0xbf80000003007423ULL, 0x002fc80000000022ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003007223ULL, 0x000fc40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006b00ff037624ULL, 0x000fe400078e00ffULL,
0x00006a00ff027624ULL, 0x000fca00078e00ffULL, 0x0000000802037981ULL, 0x000f28000c1e9900ULL,
0x0000000000087919ULL, 0x000e680000000000ULL, 0x0000000000047919ULL, 0x000ee20000000000ULL,
0x0000001808057811ULL, 0x042fe400078ff0ffULL, 0x0000000808097811ULL, 0x000fc400078ff0ffULL,
0x00000002ff077819ULL, 0x008fe40000011604ULL, 0x0000001008157811ULL, 0x000fe200078ff0ffULL,
0x0000000003067220ULL, 0x014fca0000410000ULL, 0x00001f0706007589ULL, 0x000e6800000e0000ULL,
0x00001f0506057589ULL, 0x000ea800000e0000ULL, 0x00001f0906047589ULL, 0x000ee800000e0000ULL,
0x00001f1506027589ULL, 0x000f2200000e0000ULL, 0x0000006400647220ULL, 0x042fe20000410000ULL,
0x0000006500657220ULL, 0x040fe20000410000ULL, 0x0000006000607220ULL, 0x040fe20000410000ULL,
0x0000006100617220ULL, 0x040fe20000410000ULL, 0x0000005c005c7220ULL, 0x040fe20000410000ULL,
0x0000005d005d7220ULL, 0x040fe20000410000ULL, 0x0000005800587220ULL, 0x040fe20000410000ULL,
0x0000005900597220ULL, 0x040fe20000410000ULL, 0x0000005400547220ULL, 0x040fe20000410000ULL,
0x0000005500557220ULL, 0x040fe20000410000ULL, 0x0000005000507220ULL, 0x040fe20000410000ULL,
0x0000005100517220ULL, 0x040fe20000410000ULL, 0x0000004c004c7220ULL, 0x040fe20000410000ULL,
0x0000004d004d7220ULL, 0x040fe20000410000ULL, 0x0000004800487220ULL, 0x040fe20000410000ULL,
0x0000004900497220ULL, 0x000fe20000410000ULL, 0x0000004605467220ULL, 0x044fe20000410000ULL,
0x0000004705477220ULL, 0x040fe20000410000ULL, 0x0000004205427220ULL, 0x040fe20000410000ULL,
0x0000004305437220ULL, 0x040fe20000410000ULL, 0x0000003e053e7220ULL, 0x040fe20000410000ULL,
0x0000003f053f7220ULL, 0x040fe20000410000ULL, 0x0000003a053a7220ULL, 0x040fe20000410000ULL,
0x0000003b053b7220ULL, 0x040fe20000410000ULL, 0x0000003605367220ULL, 0x040fe20000410000ULL,
0x0000003705377220ULL, 0x040fe20000410000ULL, 0x0000002005207220ULL, 0x040fe20000410000ULL,
0x0000000b050b7220ULL, 0x040fe20000410000ULL, 0x0000002405247220ULL, 0x040fe20000410000ULL,
0x0000000d050d7220ULL, 0x040fe20000410000ULL, 0x0000006805687220ULL, 0x040fe20000410000ULL,
0x0000000f050f7220ULL, 0x000fe20000410000ULL, 0x0000000466667220ULL, 0x088fe20000410000ULL,
0x0000000467677220ULL, 0x080fe20000410000ULL, 0x0000000462627220ULL, 0x080fe20000410000ULL,
0x0000000463637220ULL, 0x080fe20000410000ULL, 0x000000045e5e7220ULL, 0x080fe20000410000ULL,
0x000000045f5f7220ULL, 0x080fe20000410000ULL, 0x000000045a5a7220ULL, 0x080fe20000410000ULL,
0x000000045b5b7220ULL, 0x080fe20000410000ULL, 0x0000000456567220ULL, 0x080fe20000410000ULL,
0x0000000457577220ULL, 0x080fe20000410000ULL, 0x0000000452527220ULL, 0x080fe20000410000ULL,
0x0000000453537220ULL, 0x080fe20000410000ULL, 0x000000044e4e7220ULL, 0x080fe20000410000ULL,
0x000000044f4f7220ULL, 0x080fe20000410000ULL, 0x000000044a4a7220ULL, 0x080fe20000410000ULL,
0x000000044b4b7220ULL, 0x000fe20000410000ULL, 0x0000000244447220ULL, 0x090fe20000410000ULL,
0x0000000245457220ULL, 0x080fe20000410000ULL, 0x0000000240407220ULL, 0x080fe20000410000ULL,
0x0000000241417220ULL, 0x080fe20000410000ULL, 0x000000023c3c7220ULL, 0x080fe20000410000ULL,
0x000000023d3d7220ULL, 0x080fe20000410000ULL, 0x0000000238387220ULL, 0x080fe20000410000ULL,
0x0000000239397220ULL, 0x080fe20000410000ULL, 0x0000000234347220ULL, 0x080fe20000410000ULL,
0x0000000235357220ULL, 0x080fe20000410000ULL, 0x0000000230307220ULL, 0x080fe20000410000ULL,
0x0000000231317220ULL, 0x080fe20000410000ULL, 0x000000022c2c7220ULL, 0x080fe20000410000ULL,
0x000000022d2d7220ULL, 0x080fe20000410000ULL, 0x0000000228287220ULL, 0x080fe20000410000ULL,
0x0000000229297220ULL, 0x000fc20000410000ULL, 0x0000000000037919ULL, 0x004e620000000000ULL,
0x000000666766723eULL, 0x000fc400000000ffULL, 0x000000626333723eULL, 0x000fe200000000ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000005e5f5e723eULL, 0x000fe400000000ffULL,
0x0000005a5b2f723eULL, 0x000fe400000000ffULL, 0x000000565756723eULL, 0x000fc400000000ffULL,
0x00000052532b723eULL, 0x000fe400000000ffULL, 0x0000004e4f4e723eULL, 0x000fe400000000ffULL,
0x0000004a4b27723eULL, 0x000fe400000000ffULL, 0x0000541066327816ULL, 0x000fe40000000033ULL,
0x0000000803057811ULL, 0x042fe400078ff0ffULL, 0x0000001003097811ULL, 0x000fc400078ff0ffULL,
0x0000000203007812ULL, 0x000fe200078ec0ffULL, 0x0000000805177824ULL, 0x000fe200078e00ffULL,
0x00000002ff077819ULL, 0x000fe20000011603ULL, 0x0000000809127824ULL, 0x000fe200078e00ffULL,
0x0000001803157811ULL, 0x000fe400078ff0ffULL, 0x0000000500047211ULL, 0x040fe200078ff8ffULL,
0x00000008070e7824ULL, 0x040fe200078e00ffULL, 0x0000000700027211ULL, 0x040fe400078ff8ffULL,
0x0000000900057211ULL, 0x040fe200078ff8ffULL, 0x0000000807097824ULL, 0x000fe200078e00ffULL,
0x0000001500067211ULL, 0x000fe200078ff8ffULL, 0x0000000815157824ULL, 0x000fe200078e00ffULL,
0x0000000202007810ULL, 0x000fc40007ffe0ffULL, 0xfffffff812127812ULL, 0x000fe200078ee205ULL,
0x0000000807057824ULL, 0x000fe200078e00ffULL, 0xfffffff809087812ULL, 0x000fe200078ee200ULL,
0x0000200011007824ULL, 0x000fe200078e00ffULL, 0xfffffff8170a7812ULL, 0x008fe400078ee204ULL,
0xfffffff815147812ULL, 0x000fe400078ee206ULL, 0xfffffff805047812ULL, 0x000fe200078ee202ULL,
0x0000100013057824ULL, 0x000fe200078e0200ULL, 0x0000000402067810ULL, 0x000fc40007ffe0ffULL,
0x0000000602077810ULL, 0x000fe20007ffe0ffULL, 0x0000000803027824ULL, 0x000fe200078e00ffULL,
0xfffffff8090c7812ULL, 0x000fe200078ee206ULL, 0x0000001004067824ULL, 0x000fe200078e0205ULL,
0xfffffff80e0e7812ULL, 0x000fe200078ee207ULL, 0x000000100a107824ULL, 0x100fe200078e0205ULL,
0x0000000802077812ULL, 0x000fe200078ec0ffULL, 0x00000010080a7824ULL, 0x100fe200078e0205ULL,
0x000000646502723eULL, 0x000fe200000000ffULL, 0x0000001012127824ULL, 0x000fe200078e0205ULL,
0x000000606104723eULL, 0x000fe200000000ffULL, 0x0000000106087824ULL, 0x000fe200078e0207ULL,
0x000000505106723eULL, 0x000fe200000000ffULL, 0x0000001014147824ULL, 0x100fe200078e0205ULL,
0x00005410021c7816ULL, 0x100fe20000000004ULL, 0x000000100c0c7824ULL, 0x100fe200078e0205ULL,
0x00007632021d7816ULL, 0x000fe20000000004ULL, 0x000000100e0e7824ULL, 0x000fe200078e0205ULL,
0x0000005c5d02723eULL, 0x000fe200000000ffULL, 0x0000000107107824ULL, 0x000fe200078e0210ULL,
0x000000585904723eULL, 0x000fe200000000ffULL, 0x0000001c08007388ULL, 0x0003e20000000a00ULL,
0x000000545505723eULL, 0x000fe200000000ffULL, 0x0000000107127824ULL, 0x000fe200078e0212ULL,
0x000000444544723eULL, 0x000fe200000000ffULL, 0x0000000107147824ULL, 0x000fe200078e0214ULL,
0x000000404122723eULL, 0x000fe200000000ffULL, 0x00000001070a7824ULL, 0x040fe200078e020aULL,
0x0000763266337816ULL, 0x000fe20000000033ULL, 0x00000001070c7824ULL, 0x040fe200078e020cULL,
0x000054105e2e7816ULL, 0x000fe2000000002fULL, 0x00000001070e7824ULL, 0x000fe200078e020eULL,
0x0000004c4d07723eULL, 0x000fc400000000ffULL, 0x000000484908723eULL, 0x002fe400000000ffULL,
0x00005410021c7816ULL, 0x140fe40000000004ULL, 0x00007632021d7816ULL, 0x000fe40000000004ULL,
0x0000541005047816ULL, 0x140fe40000000006ULL, 0x0000763205057816ULL, 0x000fe20000000006ULL,
0x0000001c0a007388ULL, 0x000fe20000000a00ULL, 0x0000541007067816ULL, 0x000fc40000000008ULL,
0x0000763207077816ULL, 0x000fe20000000008ULL, 0x000000040c007388ULL, 0x000fe20000000a00ULL,
0x0000003c3d3c723eULL, 0x000fe400000000ffULL, 0x00000038391e723eULL, 0x000fe200000000ffULL,
0x000000060e007388ULL, 0x0003e20000000a00ULL, 0x000076325e2f7816ULL, 0x000fe4000000002fULL,
0x00005410562a7816ULL, 0x140fe2000000002bULL, 0x0000003210007388ULL, 0x000fe20000000a00ULL,
0x00007632562b7816ULL, 0x000fc4000000002bULL, 0x000054104e267816ULL, 0x140fe20000000027ULL,
0x0004002e0a007388ULL, 0x000fe20000000a00ULL, 0x000076324e277816ULL, 0x000fe40000000027ULL,
0x000054103c087816ULL, 0x000fe2000000001eULL, 0x0004002a0c007388ULL, 0x000fe20000000a00ULL,
0x0000541044067816ULL, 0x142fe40000000022ULL, 0x0000763244077816ULL, 0x000fe20000000022ULL,
0x000400260e007388ULL, 0x000fe20000000a00ULL, 0x000076323c097816ULL, 0x000fc4000000001eULL,
0x000000343534723eULL, 0x000fe200000000ffULL, 0x0000000612007388ULL, 0x000fe20000000a00ULL,
0x00000030311a723eULL, 0x000fe400000000ffULL, 0x0000002c2d2c723eULL, 0x000fe200000000ffULL,
0x000800080a007388ULL, 0x0003e20000000a00ULL, 0x000000282916723eULL, 0x000fe400000000ffULL,
0x000000464702723eULL, 0x000fe400000000ffULL, 0x000000424304723eULL, 0x000fc400000000ffULL,
0x000054102c1c7816ULL, 0x140fe40000000016ULL, 0x000076322c1d7816ULL, 0x000fe40000000016ULL,
0x0000003e3f05723eULL, 0x000fe400000000ffULL, 0x0000541034087816ULL, 0x142fe4000000001aULL,
0x0000763234097816ULL, 0x000fe4000000001aULL, 0x0000003a3b06723eULL, 0x000fc400000000ffULL,
0x0000541002167816ULL, 0x140fe20000000004ULL, 0x000800080c007388ULL, 0x0003e20000000a00ULL,
0x0000763202177816ULL, 0x000fe40000000004ULL, 0x000000363702723eULL, 0x000fe200000000ffULL,
0x0008001c0e007388ULL, 0x0005e20000000a00ULL, 0x000000200b04723eULL, 0x000fe400000000ffULL,
0x000000240d07723eULL, 0x000fe200000000ffULL, 0x0000001614007388ULL, 0x000fe20000000a00ULL,
0x00005410022c7816ULL, 0x000fc40000000004ULL, 0x00007632022d7816ULL, 0x000fe40000000004ULL,
0x000000680f08723eULL, 0x002fe400000000ffULL, 0x000000ff1300720cULL, 0x000fe40003f05270ULL,
0x00005410051c7816ULL, 0x144fe40000000006ULL, 0x00007632051d7816ULL, 0x000fe20000000006ULL,
0x000000016e057824ULL, 0x000fe200078e0203ULL, 0x0000541007067816ULL, 0x000fc40000000008ULL,
0x0000763207077816ULL, 0x000fe20000000008ULL, 0x0000001005057824ULL, 0x000fe200078e0200ULL,
0x000c001c0a007388ULL, 0x000fe80000000a00ULL, 0x000c002c0c007388ULL, 0x000fe80000000a00ULL,
0x000c00060e007388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000005147984ULL, 0x000e680000000c00ULL, 0x00040000051c7984ULL, 0x000ea80000000c00ULL,
0x0008000005247984ULL, 0x000ee80000000c00ULL, 0x000c0000052c7984ULL, 0x000f280000000c00ULL,
0x0010000005087984ULL, 0x000ee80000000c00ULL, 0x0014000005207984ULL, 0x000f280000000c00ULL,
0x0018000005287984ULL, 0x000f280000000c00ULL, 0x001c000005307984ULL, 0x000f220000000c00ULL,
0x200000ff17177230ULL, 0x002fc40000000000ULL, 0x200000ff16167230ULL, 0x000fe40000000000ULL,
0x200000ff15157230ULL, 0x000fe40000000000ULL, 0x200000ff14147230ULL, 0x000fe40000000000ULL,
0x200000ff1f1f7230ULL, 0x004fe40000000000ULL, 0x200000ff1e1e7230ULL, 0x000fe40000000000ULL,
0x200000ff1d1d7230ULL, 0x000fc40000000000ULL, 0x200000ff1c1c7230ULL, 0x000fe40000000000ULL,
0x200000ff27277230ULL, 0x008fe40000000000ULL, 0x200000ff26267230ULL, 0x000fe40000000000ULL,
0x200000ff25257230ULL, 0x000fe40000000000ULL, 0x200000ff24247230ULL, 0x000fe40000000000ULL,
0x200000ff2f2f7230ULL, 0x010fc40000000000ULL, 0x200000ff2e2e7230ULL, 0x000fe40000000000ULL,
0x200000ff2d2d7230ULL, 0x000fe40000000000ULL, 0x200000ff2c2c7230ULL, 0x000fe40000000000ULL,
0x0000000b17177230ULL, 0x000fe40000000000ULL, 0x0000000a16167230ULL, 0x000fe40000000000ULL,
0x0000000915157230ULL, 0x000fc40000000000ULL, 0x0000000814147230ULL, 0x000fe40000000000ULL,
0x000000231f1f7230ULL, 0x000fe40000000000ULL, 0x000000221e1e7230ULL, 0x000fe20000000000ULL,
0x0000001405007388ULL, 0x000fe20000000c00ULL, 0x000000211d1d7230ULL, 0x000fe40000000000ULL,
0x000000201c1c7230ULL, 0x000fe40000000000ULL, 0x0000002b27277230ULL, 0x000fc40000000000ULL,
0x0000002a26267230ULL, 0x000fe20000000000ULL, 0x0004001c05007388ULL, 0x000fe20000000c00ULL,
0x0000002925257230ULL, 0x000fe40000000000ULL, 0x0000002824247230ULL, 0x000fe40000000000ULL,
0x000000332f2f7230ULL, 0x000fe40000000000ULL, 0x000000322e2e7230ULL, 0x000fe20000000000ULL,
0x0008002405007388ULL, 0x000fe20000000c00ULL, 0x000000312d2d7230ULL, 0x000fc40000000000ULL,
0x000000302c2c7230ULL, 0x000fca0000000000ULL, 0x000c002c05007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff047819ULL, 0x000fc80000011603ULL, 0x000000190400720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000000479c3ULL, 0x000e620000002700ULL,
0x0000000104027824ULL, 0x000fe200078e0203ULL, 0xffffffff00057882ULL, 0x000fe20000000000ULL,
0x00000007030e7812ULL, 0x000fe200078ec0ffULL, 0x00005a0000067ab9ULL, 0x000fe40000000800ULL,
0x0000000702027812ULL, 0x000fe200078ec0ffULL, 0x0000000605057299ULL, 0x000fc6000800063fULL,
0x0ffffff802057812ULL, 0x000fe200078ef803ULL, 0x000000201b027824ULL, 0x000fe200078e0204ULL,
0x0000580000067ab9ULL, 0x000fc60000000800ULL, 0x0000001005057824ULL, 0x000fe200078e0200ULL,
0x0000000502077c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff027a19ULL, 0x000fe40000011602ULL,
0x0000000005087984ULL, 0x0004e20000000c00ULL, 0x0000000118077824ULL, 0x000fe200078e0207ULL,
0x00000006040472a4ULL, 0x002fc6000f8e023fULL, 0x0000007502077224ULL, 0x000fe200078e0207ULL,
0x0000002003027810ULL, 0x000fe40007ffe0ffULL, 0x0000000475067c24ULL, 0x000fca000f8e02ffULL,
0x0000000706077210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200000e06ffULL,
0x00005c0007047a11ULL, 0x000fc800078040ffULL, 0x00005d0007057a11ULL, 0x004fe200000f440cULL,
0x0000000811077824ULL, 0x000fe200078e020eULL, 0x00000003ff0c7819ULL, 0x000fc60000011602ULL,
0x0000001007047825ULL, 0x000fe200078e0004ULL, 0x000000190c00720cULL, 0x000fc80003f06070ULL,
0x0000000804007986ULL, 0x0083f2000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000102047824ULL, 0x102fe400078e020cULL, 0x000000201b0c7824ULL, 0x000fc600078e020cULL,
0x0000000704057812ULL, 0x000fc800078ec0ffULL, 0x0ffffff805057812ULL, 0x000fe400078ef802ULL,
0x0000000702027812ULL, 0x000fc600078ec0ffULL, 0x0000001005077824ULL, 0x000fe200078e0200ULL,
0x000000050c057c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff0c7a19ULL, 0x000fe4000001160cULL,
0x0000000007087984ULL, 0x0002a20000000c00ULL, 0x0000000118057824ULL, 0x000fc800078e0205ULL,
0x000000750c057224ULL, 0x000fe200078e0205ULL, 0x00000040030c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000811077824ULL, 0x002fc600078e0202ULL, 0x0000000506057210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x00005c0005047a11ULL, 0x000fc800078040ffULL,
0x00005d0005057a11ULL, 0x000fe400000f440eULL, 0x00000003ff0e7819ULL, 0x000fc6000001160cULL,
0x0000001007047825ULL, 0x000fe200078e0004ULL, 0x000000190e00720cULL, 0x000fc80003f06070ULL,
0x0000000804007986ULL, 0x0043f2000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010c027824ULL, 0x100fe200078e020eULL, 0x00000060030d7810ULL, 0x000fe20007ffe0ffULL,
0x000000201b0e7824ULL, 0x000fc600078e020eULL, 0x0000000702057812ULL, 0x002fc800078ec0ffULL,
0x0ffffff805057812ULL, 0x000fe400078ef80cULL, 0x000000070c0c7812ULL, 0x000fc600078ec0ffULL,
0x0000001005027824ULL, 0x000fe200078e0200ULL, 0x000000050e057c12ULL, 0x000fe2000f8e30ffULL,
0x0000000811077824ULL, 0x000fe200078e020cULL, 0x00005a00ff0e7a19ULL, 0x000fe4000001160eULL,
0x0000000002087984ULL, 0x0002a20000000c00ULL, 0x0000000118057824ULL, 0x000fc800078e0205ULL,
0x000000750e057224ULL, 0x000fe200078e0205ULL, 0x00000003ff027819ULL, 0x002fc8000001160dULL,
0x0000000506057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x000fc800078040ffULL, 0x00005d0005057a11ULL, 0x000fe400000f440eULL,
0x000000190200720cULL, 0x000fc60003f06070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0043ea000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010d047824ULL, 0x102fe200078e0202ULL, 0x00000080030c7810ULL, 0x000fe20007ffe0ffULL,
0x000000201b027824ULL, 0x000fc600078e0202ULL, 0x0000000704047812ULL, 0x000fc800078ec0ffULL,
0x0ffffff804057812ULL, 0x000fca00078ef80dULL, 0x0000001005077824ULL, 0x000fe200078e0200ULL,
0x0000000502057c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff027a19ULL, 0x000fe40000011602ULL,
0x0000000007087984ULL, 0x0002a20000000c00ULL, 0x0000000118057824ULL, 0x000fc800078e0205ULL,
0x0000007502057224ULL, 0x000fe200078e0205ULL, 0x000000070d027812ULL, 0x000fc800078ec0ffULL,
0x0000000506057210ULL, 0x000fe20007f1e0ffULL, 0x0000000811077824ULL, 0x002fc800078e0202ULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x00005c0005047a11ULL, 0x000fc800078040ffULL,
0x00005d0005057a11ULL, 0x000fe400000f440eULL, 0x00000003ff0e7819ULL, 0x000fc6000001160cULL,
0x0000001007047825ULL, 0x000fe200078e0004ULL, 0x000000190e00720cULL, 0x000fc80003f06070ULL,
0x0000000804007986ULL, 0x0043f2000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010c027824ULL, 0x100fe200078e020eULL, 0x000000a0030d7810ULL, 0x000fe20007ffe0ffULL,
0x000000201b0e7824ULL, 0x000fc600078e020eULL, 0x0000000702057812ULL, 0x002fc800078ec0ffULL,
0x0ffffff805057812ULL, 0x000fe400078ef80cULL, 0x000000070c0c7812ULL, 0x000fc600078ec0ffULL,
0x0000001005027824ULL, 0x000fe200078e0200ULL, 0x000000050e057c12ULL, 0x000fe2000f8e30ffULL,
0x0000000811077824ULL, 0x000fe200078e020cULL, 0x00005a00ff0e7a19ULL, 0x000fe4000001160eULL,
0x0000000002087984ULL, 0x0002a20000000c00ULL, 0x0000000118057824ULL, 0x000fc800078e0205ULL,
0x000000750e057224ULL, 0x000fe200078e0205ULL, 0x00000003ff027819ULL, 0x002fc8000001160dULL,
0x0000000506057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x000fc800078040ffULL, 0x00005d0005057a11ULL, 0x000fe400000f440eULL,
0x000000190200720cULL, 0x000fc60003f06070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0043ea000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010d047824ULL, 0x102fe200078e0202ULL, 0x000000c0030c7810ULL, 0x000fe20007ffe0ffULL,
0x000000201b027824ULL, 0x000fc600078e0202ULL, 0x0000000704047812ULL, 0x000fc800078ec0ffULL,
0x0ffffff804057812ULL, 0x000fca00078ef80dULL, 0x0000001005077824ULL, 0x000fe200078e0200ULL,
0x0000000502057c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff027a19ULL, 0x000fe40000011602ULL,
0x0000000007087984ULL, 0x0002a20000000c00ULL, 0x0000000118057824ULL, 0x000fc800078e0205ULL,
0x0000007502057224ULL, 0x000fe200078e0205ULL, 0x000000070d027812ULL, 0x000fc800078ec0ffULL,
0x0000000506057210ULL, 0x000fe20007f1e0ffULL, 0x0000000811077824ULL, 0x002fc800078e0202ULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x00005c0005047a11ULL, 0x000fc800078040ffULL,
0x00005d0005057a11ULL, 0x000fe400000f440eULL, 0x00000003ff0e7819ULL, 0x000fc6000001160cULL,
0x0000001007047825ULL, 0x000fe200078e0004ULL, 0x000000190e00720cULL, 0x000fc80003f06070ULL,
0x0000000804007986ULL, 0x0043f2000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010c027824ULL, 0x100fe200078e020eULL, 0x000000e003047810ULL, 0x002fe20007ffe0ffULL,
0x000000201b0e7824ULL, 0x000fc600078e020eULL, 0x0000000702057812ULL, 0x000fe400078ec0ffULL,
0x000000050e077c12ULL, 0x000fe4000f8e30ffULL, 0x0ffffff805057812ULL, 0x000fe400078ef80cULL,
0x00005a00ff0e7a19ULL, 0x000fe2000001160eULL, 0x0000000118077824ULL, 0x000fe200078e0207ULL,
0x000000070c0c7812ULL, 0x000fe200078ec0ffULL, 0x0000001005057824ULL, 0x000fe400078e0200ULL,
0x000000750e077224ULL, 0x000fe200078e0207ULL, 0x00000003ff0e7819ULL, 0x000fc40000011604ULL,
0x0000000005087984ULL, 0x0002a40000000c00ULL, 0x0000000706077210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff107224ULL, 0x000fe200000e06ffULL, 0x00005c0007027a11ULL, 0x000fe200078040ffULL,
0x0000000811057824ULL, 0x002fc600078e020cULL, 0x00005d0007037a11ULL, 0x000fe200000f4410ULL,
0x0000000104077824ULL, 0x000fe200078e020eULL, 0x000000190e00720cULL, 0x000fc60003f06070ULL,
0x0000001005027825ULL, 0x000fe200078e0002ULL, 0x0000000707077812ULL, 0x000fc800078ec0ffULL,
0xfffffff807077812ULL, 0x000fe200078ef804ULL, 0x0000000802007986ULL, 0x0043e8000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000001007077824ULL, 0x000fe200078e0200ULL,
0x0000000704047812ULL, 0x000fe200078ec0ffULL, 0x000000201b0e7824ULL, 0x000fc600078e020eULL,
0x0000000007087984ULL, 0x002e620000000c00ULL, 0x0000000811117824ULL, 0x000fe200078e0204ULL,
0x000000050e037c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff0e7a19ULL, 0x000fc6000001160eULL,
0x0000000118037824ULL, 0x000fc800078e0203ULL, 0x000000750e037224ULL, 0x000fca00078e0203ULL,
0x0000000306037210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff007224ULL, 0x000fe200000e06ffULL,
0x00005c0003027a11ULL, 0x000fc800078040ffULL, 0x00005d0003037a11ULL, 0x000fca00000f4400ULL,
0x0000001011027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x002fe2000c101d08ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00006a00ff027624ULL, 0x000fe400078e00ffULL,
0x00006b00ff037624ULL, 0x000fca00078e00ffULL, 0x0000000802577981ULL, 0x000522000c1e9900ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000001ff0500780cULL, 0x000fe20003f04070ULL,
0x000000020e097824ULL, 0x000fe200078e00ffULL, 0x01260000ff067f8cULL, 0x002e62000c80043fULL,
0x000000401a037824ULL, 0x004fe400078e00ffULL, 0x0000590009027a24ULL, 0x000fc800078e0212ULL,
0x0000660002147a24ULL, 0x000fc800078e0203ULL, 0x0000060000000947ULL, 0x000fea0003800000ULL,
0x00000002ff217819ULL, 0x000fe40000011617ULL, 0x0000001717127211ULL, 0x000fe400078fe8ffULL,
0x0000000821137810ULL, 0x040fe20007ffe0ffULL, 0x0000000114087824ULL, 0x000fe200078e0221ULL,
0x0000001821237810ULL, 0x040fe40007ffe0ffULL, 0x0000001021227810ULL, 0x040fe20007ffe0ffULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x00000020211d7810ULL, 0x000fc40007ffe0ffULL,
0x00000003121c7812ULL, 0x000fe200078ec0ffULL, 0x00000001140a7824ULL, 0x000fe200078e0213ULL,
0x0000003008107812ULL, 0x000fe200078ef804ULL, 0x00000001140e7824ULL, 0x000fe200078e0223ULL,
0x0000000316087217ULL, 0x000fe20007800000ULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000620010107a10ULL, 0x000fe40007f1e0ffULL, 0x00000028211f7810ULL, 0x000fe20007ffe0ffULL,
0x00000001140c7824ULL, 0x040fe200078e0222ULL, 0x0000630009117a10ULL, 0x000fe200007fe4ffULL,
0x0000000114097824ULL, 0x000fe200078e021dULL, 0x000000300a0a7812ULL, 0x000fe200078ef804ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000020001a1e7811ULL, 0x000fc400078e68ffULL,
0x000062000a0a7a10ULL, 0x000fe20007f3e0ffULL, 0x0000000108057824ULL, 0x000fe200078e0a03ULL,
0x000000300e0e7812ULL, 0x100fe200078ef804ULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x000063000b0b7a10ULL, 0x000fe40000ffe4ffULL, 0x000062000e0e7a10ULL, 0x000fe20007f3e0ffULL,
0x0000008009087825ULL, 0x000fe200078e00ffULL, 0x000000300c0c7812ULL, 0x100fe400078ef804ULL,
0x000063000f0f7a10ULL, 0x000fe20000ffe4ffULL, 0x0000000413197824ULL, 0x000fe200078e00ffULL,
0x0000003008127812ULL, 0x000fe200078ef804ULL, 0x0000000114087824ULL, 0x000fe200078e021fULL,
0x000062000c0c7a10ULL, 0x000fc40007f1e0ffULL, 0x0000620012127a10ULL, 0x000fe40007f5e0ffULL,
0x000000051300720cULL, 0x080fe40003f26070ULL, 0x000063000d0d7a10ULL, 0x000fe400007fe4ffULL,
0x0000630009137a10ULL, 0x000fe200017fe4ffULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x000000052100720cULL, 0x000fe40003f06070ULL, 0x0ffffffc1c177812ULL, 0x000fc400078ef817ULL,
0xfffffffc19197812ULL, 0x000fe400078ee21cULL, 0x0000003021207810ULL, 0x000fe20007ffe0ffULL,
0x0000001017177824ULL, 0x000fe200078e021eULL, 0x0000003008187812ULL, 0x000fe200078ef804ULL,
0x00000010191b7824ULL, 0x000fe200078e021eULL, 0x0000003821217810ULL, 0x000fe20007ffe0ffULL,
0x0000000114087824ULL, 0x000fe200078e0220ULL, 0x0000620018187a10ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010177faeULL, 0x0005e2000c101c48ULL,
0x000000052200720cULL, 0x000fc40003fa6070ULL, 0x0000630009197a10ULL, 0x000fe200037fe4ffULL,
0x000000000a1b7faeULL, 0x0007e2000c901c48ULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x000000052300720cULL, 0x080fe40003f86070ULL, 0x000000051d00720cULL, 0x080fe40003f66070ULL,
0x000000051f00720cULL, 0x080fe40003f46070ULL, 0x000000052000720cULL, 0x080fe20003f26070ULL,
0x0000000423177824ULL, 0x004fe200078e00ffULL, 0x000000052100720cULL, 0x000fe20003f06070ULL,
0x0000000422057824ULL, 0x000fe200078e00ffULL, 0x0000003008087812ULL, 0x000fe200078ef804ULL,
0x00000001140a7824ULL, 0x008fe200078e0221ULL, 0xfffffffc17177812ULL, 0x100fe200078ee21cULL,
0x000000041d1b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc05057812ULL, 0x000fe200078ee21cULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000620008087a10ULL, 0x000fc40007fde0ffULL,
0xfffffffc1b1b7812ULL, 0x000fe200078ee21cULL, 0x000000041f1d7824ULL, 0x000fe200078e00ffULL,
0x000000300a047812ULL, 0x000fe200078ef804ULL, 0x00000004201f7824ULL, 0x000fe200078e00ffULL,
0x0000630009097a10ULL, 0x000fe200037fe4ffULL, 0x0000000421217824ULL, 0x000fe200078e00ffULL,
0xfffffffc1d1d7812ULL, 0x000fe200078ee21cULL, 0x0000001005117824ULL, 0x000fe200078e021eULL,
0xfffffffc1f1f7812ULL, 0x000fe200078ee21cULL, 0x0000001017177824ULL, 0x000fe200078e021eULL,
0xfffffffc21217812ULL, 0x000fe200078ee21cULL, 0x000000101b1b7824ULL, 0x100fe200078e021eULL,
0x0000620004047a10ULL, 0x000fe20007fde0ffULL, 0x000000101d1d7824ULL, 0x100fe200078e021eULL,
0x000000000c117faeULL, 0x0005e2000e901c48ULL, 0x000000101f1f7824ULL, 0x100fe200078e021eULL,
0x000063000b057a10ULL, 0x000fe200037fe4ffULL, 0x0000001021217824ULL, 0x000fe200078e021eULL,
0x000000000e177faeULL, 0x0005e8000e101c48ULL, 0x00000000121b7faeULL, 0x0005e8000d901c48ULL,
0x00000000181d7faeULL, 0x0005e8000d101c48ULL, 0x00000000081f7faeULL, 0x0005e8000c901c48ULL,
0x0000000004217faeULL, 0x0005e2000c101c48ULL, 0x0000054000007947ULL, 0x000fea0003800000ULL,
0x0000001017117811ULL, 0x040fe400078ff0ffULL, 0x0000001817137811ULL, 0x000fc400078ff0ffULL,
0x00000017170a7211ULL, 0x040fe200078fe8ffULL, 0x00000001140c7824ULL, 0x040fe200078e0211ULL,
0x00000008170f7811ULL, 0x000fe200078ff0ffULL, 0x0000000411117824ULL, 0x000fe200078e00ffULL,
0x00000030170b7811ULL, 0x040fe200078ff0ffULL, 0x00000001140e7824ULL, 0x040fe200078e0213ULL,
0x0000002017057811ULL, 0x000fe200078ff0ffULL, 0x0000000413137824ULL, 0x000fe200078e00ffULL,
0x00000038170d7811ULL, 0x040fe200078ff0ffULL, 0x0000000114227824ULL, 0x000fe200078e020bULL,
0x000000030a127812ULL, 0x000fe200078ec0ffULL, 0x00000001140a7824ULL, 0x000fe200078e020fULL,
0x0000002817097811ULL, 0x000fe200078ff0ffULL, 0x000000040f0f7824ULL, 0x000fe200078e00ffULL,
0x0000001417087211ULL, 0x000fe200078ff0ffULL, 0x0000000405197824ULL, 0x000fe200078e00ffULL,
0xfffffffc11107812ULL, 0x100fe200078ee212ULL, 0x000000040b0b7824ULL, 0x000fe200078e00ffULL,
0x0ffffffc12177812ULL, 0x000fe200078ef817ULL, 0x0000000114247824ULL, 0x000fe200078e020dULL,
0xfffffffc13117812ULL, 0x100fe200078ee212ULL, 0x000000040d0d7824ULL, 0x000fe200078e00ffULL,
0x000020001a267811ULL, 0x000fe200078e68ffULL, 0x00000001141e7824ULL, 0x040fe200078e0205ULL,
0xfffffffc0f057812ULL, 0x100fe200078ee212ULL, 0x0000000114207824ULL, 0x000fe200078e0209ULL,
0xfffffffc19137812ULL, 0x100fe200078ee212ULL, 0x00000004091b7824ULL, 0x000fe200078e00ffULL,
0xfffffffc0b187812ULL, 0x100fe200078ee212ULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0xfffffffc0d197812ULL, 0x000fc400078ee212ULL, 0xfffffffc1b147812ULL, 0x000fe200078ee212ULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000003008127812ULL, 0x000fc600078ef804ULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x0000620012127a10ULL, 0x000fc60007f1e0ffULL,
0x0000001017297824ULL, 0x000fe200078e0226ULL, 0x000000300c1c7812ULL, 0x000fe200078ef804ULL,
0x0000001005177824ULL, 0x000fe200078e0226ULL, 0x000000300a057812ULL, 0x000fe200078ef804ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000062001c1c7a10ULL, 0x000fc60007f5e0ffULL,
0x0000001018257824ULL, 0x100fe200078e0226ULL, 0x0000620005187a10ULL, 0x000fe20007f3e0ffULL,
0x0000001013217824ULL, 0x100fe200078e0226ULL, 0x0000630009137a10ULL, 0x000fe200007fe4ffULL,
0x0000001019277824ULL, 0x000fe200078e0226ULL, 0x000000300e0e7812ULL, 0x100fe200078ef804ULL,
0x000000801e087825ULL, 0x000fe200078e00ffULL, 0x000063000b197a10ULL, 0x000fe20000ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012297faeULL, 0x0005e2000b901c48ULL,
0x000063000d1d7a10ULL, 0x000fe200017fe4ffULL, 0x00000080200a7825ULL, 0x000fe200078e00ffULL,
0x000062000e0e7a10ULL, 0x000fe20007f1e0ffULL, 0x0000000018177faeULL, 0x0005e2000b901c48ULL,
0x0000003008057812ULL, 0x000fe200078ef804ULL, 0x00000010101b7824ULL, 0x000fe200078e0226ULL,
0x000000300a087812ULL, 0x000fe200078ef804ULL, 0x00000010111f7824ULL, 0x000fe200078e0226ULL,
0x000063000f0f7a10ULL, 0x000fe200007fe4ffULL, 0x00000080220c7825ULL, 0x000fe200078e00ffULL,
0x0000620008087a10ULL, 0x000fe20007f3e0ffULL, 0x000000001c1b7faeULL, 0x0005e4000b901c48ULL,
0x0000008024107825ULL, 0x000fe200078e00ffULL, 0x000000300c0a7812ULL, 0x000fe200078ef804ULL,
0x000000000e1f7faeULL, 0x0005e4000b901c48ULL, 0x0000001014237824ULL, 0x000fe200078e0226ULL,
0x00000030100c7812ULL, 0x000fc400078ef804ULL, 0x0000620005047a10ULL, 0x000fe40007f1e0ffULL,
0x000062000a0a7a10ULL, 0x000fe40007f5e0ffULL, 0x000062000c0c7a10ULL, 0x000fe40007f7e0ffULL,
0x0000630009057a10ULL, 0x000fe400007fe4ffULL, 0x000063000b097a10ULL, 0x000fe40000ffe4ffULL,
0x000063000d0b7a10ULL, 0x000fe200017fe4ffULL, 0x0000000004217faeULL, 0x0005e2000b901c48ULL,
0x00006300110d7a10ULL, 0x000fc60001ffe4ffULL, 0x0000000008237faeULL, 0x0005e8000b901c48ULL,
0x000000000a257faeULL, 0x0005e8000b901c48ULL, 0x000000000c277faeULL, 0x0005e4000b901c48ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000047805ULL, 0x004fc40000015200ULL,
0x01260400ff097984ULL, 0x000ea40000000800ULL, 0x8000000009ff7812ULL, 0x006fc40007804807ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x00000008040b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e05ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff087819ULL, 0x000fc80000011409ULL,
0x0000000b08087211ULL, 0x000fca00078110ffULL, 0x000000ffff097224ULL, 0x000fca00000e0609ULL,
0x0000000208087819ULL, 0x000fc80000001209ULL, 0x000000080000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01260400ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000e640000000000ULL, 0x000000201a047824ULL, 0x002fca00078e0205ULL,
0x00000004ff057819ULL, 0x000fe40000011604ULL, 0x0000000104067810ULL, 0x040fe40007ffe0ffULL,
0x0ffffffe05077812ULL, 0x000fe400078ec0ffULL, 0x0000001f04057812ULL, 0x000fc600078ec0ffULL,
0x0000000107097824ULL, 0x040fe400078e0206ULL, 0x0000000104087824ULL, 0x000fe200078e0207ULL,
0x0000000807077810ULL, 0x000fe20007ffe0ffULL, 0x00000010050a7824ULL, 0x000fe200078e00ffULL,
0x0000000f09097812ULL, 0x000fe200078ec0ffULL, 0x00000010050b7824ULL, 0x000fe200078e00ffULL,
0x0000000f08087812ULL, 0x000fe200078ec0ffULL, 0x0000000106067824ULL, 0x000fe200078e0207ULL,
0x000001f00a097812ULL, 0x000fe200078ee209ULL, 0x0000000104047824ULL, 0x000fe200078e0207ULL,
0x000001f00b087812ULL, 0x000fe200078ee208ULL, 0x0000001005077824ULL, 0x040fe200078e00ffULL,
0x0000000f06067812ULL, 0x000fe200078ec0ffULL, 0x00000000090c7984ULL, 0x000e62000000cc00ULL,
0x0000001005057824ULL, 0x000fe200078e00ffULL, 0x0000000f04047812ULL, 0x000fc400078ec0ffULL,
0x0000000008107984ULL, 0x000ea4000000cc00ULL, 0x000001f005067812ULL, 0x000fe400078ee206ULL,
0x000001f007047812ULL, 0x000fe200078ee204ULL, 0x000000ffff1e7224ULL, 0x002fe400078e000cULL,
0x000000ffff1f7224ULL, 0x000fe400078e000eULL, 0x000000ffff1c7224ULL, 0x004fe400078e0010ULL,
0x000000ffff1d7224ULL, 0x000fc400078e0012ULL, 0x000000ffff227224ULL, 0x000fe400078e000dULL,
0x000000ffff237224ULL, 0x000fe200078e000fULL, 0x0000001c08007388ULL, 0x000fe2000000cc00ULL,
0x000000ffff207224ULL, 0x000fe400078e0011ULL, 0x000000ffff217224ULL, 0x000fca00078e0013ULL,
0x0000002009007388ULL, 0x000fe8000000cc00ULL, 0x00000000060c7984ULL, 0x000e68000000cc00ULL,
0x0000000004107984ULL, 0x000ea2000000cc00ULL, 0x000000ffff277224ULL, 0x002fe400078e000eULL,
0x000000ffff267224ULL, 0x000fc400078e000cULL, 0x000000ffff0e7224ULL, 0x000fe400078e000dULL,
0x000000ffff247224ULL, 0x004fe400078e0010ULL, 0x000000ffff257224ULL, 0x000fe400078e0012ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0011ULL, 0x000000ffff0d7224ULL, 0x000fe200078e0013ULL,
0x0000002404007388ULL, 0x0003e8000000cc00ULL, 0x0000000c06007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01260000ff087f8cULL, 0x000ea2000c80043fULL,
0x000000ffff0a7224ULL, 0x000fc600078e00ffULL, 0x0000000000047805ULL, 0x002fc80000015200ULL,
0x01260400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x006fc40007804809ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x00000006040b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09000b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011407ULL, 0x0000000b06067211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000206067819ULL, 0x000fc80000001207ULL,
0x000000060000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01260400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff1500720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000597919ULL, 0x000e620000000000ULL,
0x0000001fff047424ULL, 0x000fe200078e00ffULL, 0x8000580016177a10ULL, 0x000fe20007ffe0ffULL,
0x00000001ff197424ULL, 0x000fe200078e00ffULL, 0x3db504f357577820ULL, 0x010fe20000410000ULL,
0x00005800ff187624ULL, 0x000fe200078e00ffULL, 0x0000580004047a10ULL, 0x000fe20007ffe0ffULL,
0x000000ffff547224ULL, 0x000fe200078e00ffULL, 0x000126881a567811ULL, 0x000fe200078e18ffULL,
0x000000ffff1b7224ULL, 0x000fe200078e00ffULL, 0x00000004ff047819ULL, 0x000fc40000011604ULL,
0x000126081a557811ULL, 0x000fe400078e28ffULL, 0x0000580019197a10ULL, 0x000fe40007ffe1ffULL,
0x0000000918187810ULL, 0x000fe40007ffe0ffULL, 0x00000008ff177819ULL, 0x000fe40000011617ULL,
0x0ffffffe04147812ULL, 0x000fc400078ec0ffULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x000000ffff5b7224ULL, 0x000fe200078e001bULL, 0x0000000000067805ULL, 0x004fe2000001ff00ULL,
0x000000ffff587224ULL, 0x000fe200078e00ffULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x008fc4000001ff00ULL,
0x000000015800780cULL, 0x000fe20003f25270ULL, 0x00000bc000007945ULL, 0x000fe20003800000ULL,
0x0000000154087810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff5a7224ULL, 0x000fe200078e0058ULL,
0x0000000158097810ULL, 0x000fc40007ffe0ffULL, 0x000000015b1b7812ULL, 0x000fe400078e0cffULL,
0x000000020900780cULL, 0x000fe20003f06070ULL, 0x000000ffff587224ULL, 0x000fc800078e0009ULL,
0x000000ffff081224ULL, 0x000fc800078e0254ULL, 0x00000100085f7824ULL, 0x060fe200078e0203ULL,
0x00000001080a7810ULL, 0x000fe40007ffe0ffULL, 0x000000ff09087207ULL, 0x000fe20000800000ULL,
0x0000660002647a24ULL, 0x000fe200078e025fULL, 0x000000150a00720cULL, 0x000fda0003f46070ULL,
0x000005d00000a947ULL, 0x000fea0003800000ULL, 0x0000001059097824ULL, 0x002fe200078e00ffULL,
0x00000002ff6b7819ULL, 0x000fe20000011659ULL, 0x000000021a637824ULL, 0x000fe200078e021bULL,
0x0000005f165c7217ULL, 0x000fe40007800000ULL, 0x0000003009097812ULL, 0x000fe200078ec0ffULL,
0x000000016b0b7824ULL, 0x140fe200078e0264ULL, 0x000000186b6d7810ULL, 0x040fe20007ffe0ffULL,
0x000000015c627824ULL, 0x000fe200078e0a5fULL, 0x000000086b617810ULL, 0x040fe20007ffe0ffULL,
0x0000004008087824ULL, 0x000fe200078e0209ULL, 0x000000106b657810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff097224ULL, 0x000fe200078e00ffULL, 0x000000206b6f7810ULL, 0x000fe20007ffe0ffULL,
0x000000016d5d7824ULL, 0x000fe200078e0264ULL, 0x0000200063637811ULL, 0x000fe200078e60ffULL,
0x000000800b0a7825ULL, 0x000fe200078e0008ULL, 0x000000286b717810ULL, 0x000fc40007ffe0ffULL,
0x000000306b737810ULL, 0x000fe20007ffe0ffULL, 0x0000000161517824ULL, 0x000fe200078e0264ULL,
0x000062000a5e7a10ULL, 0x000fe20007f3e0ffULL, 0x000000805d5c7825ULL, 0x000fe200078e0008ULL,
0x00000059590a7211ULL, 0x000fe400078fe8ffULL, 0x000063000b5f7a10ULL, 0x000fe20000ffe4ffULL,
0x0000000164537824ULL, 0x000fe200078e0265ULL, 0x000062005c5c7a10ULL, 0x000fe20007f3e0ffULL,
0x0000008051507825ULL, 0x000fe200078e0008ULL, 0x000000030a667812ULL, 0x000fc400078ec0ffULL,
0x000063005d5d7a10ULL, 0x000fe20000ffe4ffULL, 0x0000008053527825ULL, 0x000fe200078e0008ULL,
0x0000620050507a10ULL, 0x000fe40007f5e0ffULL, 0x000000626b00720cULL, 0x080fe20003f26070ULL,
0x000000016f0b7824ULL, 0x000fe200078e0264ULL, 0x0000620052527a10ULL, 0x000fe20007f7e0ffULL,
0x0000000465677824ULL, 0x000fe200078e00ffULL, 0x0000630051517a10ULL, 0x000fe200017fe4ffULL,
0x000000800b0a7825ULL, 0x000fe200078e0008ULL, 0x000000626100720cULL, 0x000fc40003f46070ULL,
0x0ffffffc66687812ULL, 0x000fe200078ef859ULL, 0x0000000461617824ULL, 0x000fe200078e00ffULL,
0x0000630053537a10ULL, 0x000fe40001ffe4ffULL, 0x000062000a607a10ULL, 0x000fe40007f9e0ffULL,
0x000000626500720cULL, 0x000fe20003f66070ULL, 0x0000001068657824ULL, 0x100fe200078e0263ULL,
0xfffffffc610a7812ULL, 0x000fe400078ee266ULL, 0x000063000b617a10ULL, 0x000fe200027fe4ffULL,
0x00000001710b7824ULL, 0x000fe200078e0264ULL, 0xfffffffc67687812ULL, 0x000fe200078ee266ULL,
0x000000100a677824ULL, 0x000fe200078e0263ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000005e657faeULL, 0x0003e2000c901c48ULL, 0x000000800b0a7825ULL, 0x000fe200078e0008ULL,
0x000000386b6b7810ULL, 0x000fc40007ffe0ffULL, 0x0000000050677faeULL, 0x0005e2000d101c48ULL,
0x0000001068697824ULL, 0x000fe200078e0263ULL, 0x000000626d00720cULL, 0x0c0fe20003fa6070ULL,
0x000000046d6d7824ULL, 0x000fe200078e00ffULL, 0x000000626f00720cULL, 0x0c0fe20003f86070ULL,
0x000000046f6f7824ULL, 0x000fe200078e00ffULL, 0x0000000052697faeULL, 0x0007e2000d901c48ULL,
0x000062000a0a7a10ULL, 0x000fe20007fde0ffULL, 0x00000001735f7824ULL, 0x102fe200078e0264ULL,
0x000000627100720cULL, 0x080fe20003f66070ULL, 0x000000016b657824ULL, 0x000fe200078e0264ULL,
0x000000627300720cULL, 0x080fe20003f46070ULL, 0x000000805f507825ULL, 0x004fe200078e0008ULL,
0x000000626b00720cULL, 0x000fc40003f26070ULL, 0x000063000b0b7a10ULL, 0x000fe200037fe4ffULL,
0x0000000471717824ULL, 0x000fe200078e00ffULL, 0x0000620050507a10ULL, 0x000fe20007fde0ffULL,
0x0000000473737824ULL, 0x000fe200078e00ffULL, 0xfffffffc6d527812ULL, 0x108fe200078ee266ULL,
0x000000046b6b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc6f5e7812ULL, 0x000fe200078ee266ULL,
0x0000008065087825ULL, 0x000fe200078e0008ULL, 0xfffffffc71627812ULL, 0x100fe400078ee266ULL,
0xfffffffc73647812ULL, 0x100fe200078ee266ULL, 0x0000001052537824ULL, 0x100fe200078e0263ULL,
0xfffffffc6b667812ULL, 0x000fe200078ee266ULL, 0x000000105e5f7824ULL, 0x100fe200078e0263ULL,
0x0000630051517a10ULL, 0x000fe200037fe4ffULL, 0x0000001062657824ULL, 0x100fe200078e0263ULL,
0x0000620008087a10ULL, 0x000fe20007fde0ffULL, 0x0000001064677824ULL, 0x100fe200078e0263ULL,
0x000000005c537faeULL, 0x0003e2000e901c48ULL, 0x0000001066637824ULL, 0x000fe200078e0263ULL,
0x0000630009097a10ULL, 0x000fc400037fe4ffULL, 0x00000000605f7faeULL, 0x0003e8000e101c48ULL,
0x000000000a657faeULL, 0x0003e8000d901c48ULL, 0x0000000050677faeULL, 0x0003e8000d101c48ULL,
0x0000000008637faeULL, 0x0003e2000c901c48ULL, 0x0000051000007947ULL, 0x000fea0003800000ULL,
0x0000001059097824ULL, 0x042fe200078e00ffULL, 0x0000001059537811ULL, 0x040fe200078ff0ffULL,
0x000000021a0b7824ULL, 0x000fe200078e021bULL, 0x00000018595d7811ULL, 0x000fc400078ff0ffULL,
0x0000003009097812ULL, 0x000fe200078ec0ffULL, 0x0000000153517824ULL, 0x100fe200078e0264ULL,
0x00000020595f7811ULL, 0x000fe200078ff0ffULL, 0x0000000453657824ULL, 0x000fe200078e00ffULL,
0x0000002859617811ULL, 0x040fe200078ff0ffULL, 0x0000004008627824ULL, 0x000fe200078e0209ULL,
0x0000000859097811ULL, 0x000fe200078ff0ffULL, 0x000000015d537824ULL, 0x100fe200078e0264ULL,
0x0000003059637811ULL, 0x000fe200078ff0ffULL, 0x000000045d677824ULL, 0x000fe200078e00ffULL,
0x0000003859717811ULL, 0x000fe200078ff0ffULL, 0x000000015f5d7824ULL, 0x100fe200078e0264ULL,
0x00000059590a7211ULL, 0x000fe200078fe8ffULL, 0x000000045f697824ULL, 0x000fe200078e00ffULL,
0x000020000b737811ULL, 0x000fe200078e60ffULL, 0x00000001090b7824ULL, 0x100fe200078e0264ULL,
0x000000030a0a7812ULL, 0x000fe200078ec0ffULL, 0x00000001615f7824ULL, 0x000fc400078e0264ULL,
0x0000000409097824ULL, 0x000fe200078e00ffULL, 0xfffffffc65507812ULL, 0x100fe200078ee20aULL,
0x0000000461617824ULL, 0x000fe200078e00ffULL, 0xfffffffc67527812ULL, 0x100fe200078ee20aULL,
0x00000004636b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc09087812ULL, 0x100fe200078ee20aULL,
0x00000004716d7824ULL, 0x000fe200078e00ffULL, 0xfffffffc695c7812ULL, 0x100fe200078ee20aULL,
0x0000001050677824ULL, 0x100fe200078e0273ULL, 0xfffffffc615e7812ULL, 0x000fe200078ee20aULL,
0x0000000163617824ULL, 0x000fe200078e0264ULL, 0xfffffffc6b607812ULL, 0x100fe200078ee20aULL,
0x000000ffff637224ULL, 0x000fe200078e00ffULL, 0xfffffffc6d667812ULL, 0x000fe200078ee20aULL,
0x0000001008657824ULL, 0x000fe200078e0273ULL, 0x0ffffffc0a0a7812ULL, 0x000fe200078ef859ULL,
0x0000001052697824ULL, 0x000fe200078e0273ULL, 0x0000006459097211ULL, 0x000fe200078ff0ffULL,
0x0000008051507825ULL, 0x000fc800078e0062ULL, 0x000000100a757824ULL, 0x000fe200078e0273ULL,
0x0000620050507a10ULL, 0x000fe20007f7e0ffULL, 0x0000008009087825ULL, 0x000fc600078e0062ULL,
0x0000630051517a10ULL, 0x000fe20001ffe4ffULL, 0x000000800b0a7825ULL, 0x000fe200078e0062ULL,
0x0000620008087a10ULL, 0x000fc60007f3e0ffULL, 0x0000008053527825ULL, 0x000fe200078e0062ULL,
0x000062000a0a7a10ULL, 0x000fe40007f5e0ffULL, 0x0000630009097a10ULL, 0x000fe20000ffe4ffULL,
0x0000000171717824ULL, 0x000fe200078e0264ULL, 0x0000620052527a10ULL, 0x000fe20007f9e0ffULL,
0x000000105c6b7824ULL, 0x100fe200078e0273ULL, 0x000063000b0b7a10ULL, 0x000fe200017fe4ffULL,
0x000000105e6d7824ULL, 0x000fe200078e0273ULL, 0x0000630053537a10ULL, 0x000fe200027fe4ffULL,
0x000000805d5c7825ULL, 0x000fe200078e0062ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008757faeULL, 0x0003e6000b901c48ULL, 0x00000010606f7824ULL, 0x000fe200078e0273ULL,
0x000062005c5c7a10ULL, 0x000fe20007f3e0ffULL, 0x000000805f5e7825ULL, 0x100fe200078e0062ULL,
0x000000000a657faeULL, 0x0003e4000b901c48ULL, 0x000063005d5d7a10ULL, 0x000fe20000ffe4ffULL,
0x0000008061607825ULL, 0x100fe200078e0062ULL, 0x000062005e5e7a10ULL, 0x000fe20007f5e0ffULL,
0x0000000050677faeULL, 0x0003e4000b901c48ULL, 0x0000008071627825ULL, 0x000fe200078e0062ULL,
0x0000620060607a10ULL, 0x000fe20007f7e0ffULL, 0x0000000052697faeULL, 0x0003e2000b901c48ULL,
0x000063005f5f7a10ULL, 0x000fe200017fe4ffULL, 0x0000001066737824ULL, 0x000fe200078e0273ULL,
0x0000620062627a10ULL, 0x000fe20007f9e0ffULL, 0x000000005c6b7faeULL, 0x0003e2000b901c48ULL,
0x0000630061617a10ULL, 0x000fc40001ffe4ffULL, 0x0000630063637a10ULL, 0x000fe200027fe4ffULL,
0x000000005e6d7faeULL, 0x0003e8000b901c48ULL, 0x00000000606f7faeULL, 0x0003e8000b901c48ULL,
0x0000000062737faeULL, 0x0003e4000b901c48ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000085a677824ULL, 0x002fc400078e00ffULL,
0x000000ffff6d7224ULL, 0x000fe400078e00ffULL, 0x00000010ff657424ULL, 0x000fe200078e00ffULL,
0x0000001267667810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff647224ULL, 0x000fe200078e00ffULL,
0x0000000267677810ULL, 0x000fe20007ffe0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xfffffff859087812ULL, 0x040fe200078ec0ffULL, 0x000000021a687824ULL, 0x000fe200078e025bULL,
0x00000008590a7812ULL, 0x020fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000007086e7812ULL, 0x000fc400078ef859ULL, 0x0000200068687811ULL, 0x000fe400078e60ffULL,
0x00000001ff6f7819ULL, 0x000fe2000001166eULL, 0x000000046e097824ULL, 0x040fe200078e00ffULL,
0x00000007590b7812ULL, 0x000fe200078ec0ffULL, 0x000000046e6e7824ULL, 0x000fe200078e00ffULL,
0x000000070a757812ULL, 0x000fe200078ef859ULL, 0x000000016f087824ULL, 0x000fe200078e0264ULL,
0x00000020596a7810ULL, 0x000fe40007ffe0ffULL, 0x00000010756b7812ULL, 0x000fc400078efcffULL,
0xfffffffc09097812ULL, 0x000fe400078ee208ULL, 0x0000000a59087211ULL, 0x000fe400078fe0ffULL,
0xfffffff86a6a7812ULL, 0x000fe200078ec0ffULL, 0x00000010095c7824ULL, 0x000fe200078e0268ULL,
0x00000001647a7810ULL, 0x000fe20007ffe0ffULL, 0x000000010b6c7824ULL, 0x000fe200078e0208ULL,
0x000000076a6a7812ULL, 0x000fe200078ef859ULL, 0x000000085a097824ULL, 0x000fe400078e026dULL,
0x000000005c5c783bULL, 0x000e620000000200ULL, 0x0000001075087824ULL, 0x000fe200078e00ffULL,
0x00000001ff697819ULL, 0x000fe2000001166aULL, 0x000000016c097824ULL, 0x040fe200078e0209ULL,
0x000000666c797210ULL, 0x000fe20007ffe06dULL, 0x000000085a0b7824ULL, 0x000fc400078e0265ULL,
0x000000046a617824ULL, 0x000fe200078e00ffULL, 0xfffffff008097812ULL, 0x000fe200078ee209ULL,
0x000000016c0b7824ULL, 0x000fe400078e020bULL, 0x000000106b087824ULL, 0x000fe400078e00ffULL,
0x0000001009507824ULL, 0x000fe400078e00ffULL, 0x0000000169607824ULL, 0x000fe200078e0264ULL,
0xfffffff0080b7812ULL, 0x000fe200078ee20bULL, 0x0000001075757824ULL, 0x000fe200078e00ffULL,
0x0000000264647810ULL, 0x000fe20007ffe0ffULL, 0x000000005050783bULL, 0x000ea20000000200ULL,
0xfffffffc61617812ULL, 0x000fe200078ee260ULL, 0x000000100b0b7824ULL, 0x000fc400078e00ffULL,
0x000000016f6f7824ULL, 0x000fe400078e027aULL, 0x0000001061617824ULL, 0x000fe400078e0268ULL,
0x000000000b08783bULL, 0x000ee20000000200ULL, 0xfffffffc6e777812ULL, 0x000fe200078ee26fULL,
0x0000000169697824ULL, 0x000fe400078e027aULL, 0x000000046a6a7824ULL, 0x000fca00078e00ffULL,
0xfffffffc6a697812ULL, 0x000fe400078ee269ULL, 0x00000018ff627819ULL, 0x102fe4000001165cULL,
0x00000010ff607819ULL, 0x000fe4000001165cULL, 0x0000ffff5c707812ULL, 0x000fe400078ec0ffULL,
0x00000062ff63723eULL, 0x000fe400020006ffULL, 0x000000ff60627812ULL, 0x000fc400078ec0ffULL,
0x000000ff5c5c7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff607819ULL, 0x000fe40000011670ULL,
0x00000018ff707819ULL, 0x000fe4000001165dULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x00000060ff60723eULL, 0x000fe400020006ffULL, 0x00000062ff71723eULL, 0x000fc400020006ffULL,
0x00000070ff73723eULL, 0x000fe400020006ffULL, 0x000054105c707816ULL, 0x000fe40000000060ULL,
0x0000541071717816ULL, 0x000fe40000000063ULL, 0x00000010ff5c7819ULL, 0x000fe2000001165dULL,
0x000000006160783bULL, 0x000e620000000200ULL, 0x0000ffff5d747812ULL, 0x040fe400078ec0ffULL,
0x000000ff5c727812ULL, 0x000fe200078ec0ffULL, 0x000000705034723cULL, 0x004f620000001834ULL,
0x000000ff5d5d7812ULL, 0x000fc400078ec0ffULL, 0x00000008ff5c7819ULL, 0x000fe40000011674ULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x0000005cff5c723eULL, 0x000fe200020006ffULL,
0x000000700810723cULL, 0x008b620000001810ULL, 0x0000ffff5f747812ULL, 0x000fcc00078ec0ffULL,
0x00000072ff71723eULL, 0x020fe400020006ffULL, 0x000054105d707816ULL, 0x000fe4000000005cULL,
0x0000541071717816ULL, 0x000fe40000000073ULL, 0x00000010ff5c7819ULL, 0x100fe4000001165eULL,
0x0000ffff5e737812ULL, 0x000fe400078ec0ffULL, 0x00000018ff727819ULL, 0x000fe2000001165eULL,
0x000000705024723cULL, 0x000f620000001824ULL, 0x000000ff5c5d7812ULL, 0x000fc400078ec0ffULL,
0x000000ff5e5e7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff5c7819ULL, 0x000fe40000011673ULL,
0x00000072ff72723eULL, 0x000fe200020006ffULL, 0x000000700828723cULL, 0x000b620000001828ULL,
0x0000005eff5e723eULL, 0x000fe400020006ffULL, 0x0000005dff5d723eULL, 0x000fe400020006ffULL,
0x0000005cff5c723eULL, 0x000fc400020006ffULL, 0x000054105d5d7816ULL, 0x000fe40000000072ULL,
0x000054105e5c7816ULL, 0x000fe4000000005cULL, 0x000000676c5e7210ULL, 0x000fe40007ffe06dULL,
0x00000010ff6c7819ULL, 0x002fe40000011660ULL, 0xfffffff075787812ULL, 0x000fe200078ee25eULL,
0x0000005c5038723cULL, 0x000fe20000001838ULL, 0x000000ff5f5e7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff6d7819ULL, 0x000fe40000011660ULL, 0x000000ff606e7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff607b7812ULL, 0x000fe200078ec0ffULL, 0x0000005c083c723cULL, 0x000be2000000183cULL,
0x00000010ff607819ULL, 0x000fe40000011661ULL, 0x0000005eff5e723eULL, 0x000fe400020006ffULL,
0x00000018ff717819ULL, 0x020fc40000011662ULL, 0x00000010ff5c7819ULL, 0x100fe4000001165fULL,
0x00000018ff5d7819ULL, 0x000fe4000001165fULL, 0x000000ff5c5f7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff5c7819ULL, 0x000fe40000011674ULL, 0x0000005dff5d723eULL, 0x000fe400020006ffULL,
0x0000005fff5f723eULL, 0x000fc400020006ffULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x000000ff60607812ULL, 0x000fe400078ec0ffULL, 0x00000018ff6f7819ULL, 0x000fe40000011661ULL,
0x000054105f5f7816ULL, 0x000fe4000000005dULL, 0x000054105e5e7816ULL, 0x000fe4000000005cULL,
0x00000071ff74723eULL, 0x000fc400020006ffULL, 0x000000ff61707812ULL, 0x040fe400078ec0ffULL,
0x0000ffff617c7812ULL, 0x000fe200078ec0ffULL, 0x0000005e501c723cULL, 0x080f62000000181cULL,
0x00000010ff727819ULL, 0x000fe40000011662ULL, 0x000000ff62737812ULL, 0x040fe400078ec0ffULL,
0x0000ffff627d7812ULL, 0x000fe400078ec0ffULL, 0x00000060ff71723eULL, 0x000fe200020006ffULL,
0x0000001077607824ULL, 0x000fe200078e0268ULL, 0x00000010ff627819ULL, 0x000fe20000011663ULL,
0x0000005e084c723cULL, 0x000b62000000184cULL, 0x0000006fff61723eULL, 0x000fc400020006ffULL,
0x00000008ff5c7819ULL, 0x000fe4000001167bULL, 0x00000008ff5d7819ULL, 0x000fe4000001167cULL,
0x00000018ff757819ULL, 0x000fe40000011663ULL, 0x000000ff63767812ULL, 0x040fe400078ec0ffULL,
0x0000ffff637e7812ULL, 0x000fe400078ec0ffULL, 0x000000ff625e7812ULL, 0x020fc400078ec0ffULL,
0x0000541071717816ULL, 0x000fe40000000061ULL, 0x000000006060783bULL, 0x000e620000000200ULL,
0x0000006eff6e723eULL, 0x000fe400020006ffULL, 0x00000070ff70723eULL, 0x000fe400020006ffULL,
0x000000ff6c6c7812ULL, 0x000fe400078ec0ffULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x0000005dff5d723eULL, 0x000fc400020006ffULL, 0x0000006dff6d723eULL, 0x000fe400020006ffULL,
0x0000006cff6f723eULL, 0x000fe400020006ffULL, 0x000054106e6e7816ULL, 0x000fe4000000005cULL,
0x0000541070707816ULL, 0x000fe4000000005dULL, 0x000000ff72727812ULL, 0x000fe400078ec0ffULL,
0x00000008ff5c7819ULL, 0x000fc4000001167dULL, 0x00000008ff5d7819ULL, 0x000fe2000001167eULL,
0x000000705044723cULL, 0x040fe20000001844ULL, 0x000054106f6f7816ULL, 0x000fe4000000006dULL,
0x00000073ff73723eULL, 0x000fe400020006ffULL, 0x00000075ff75723eULL, 0x000fe400020006ffULL,
0x00000072ff6d723eULL, 0x000fe200020006ffULL, 0x0000006e5048723cULL, 0x000fe20000001848ULL,
0x0000005cff5c723eULL, 0x000fc400020006ffULL, 0x00000076ff76723eULL, 0x000fe400020006ffULL,
0x0000005eff77723eULL, 0x000fe200020006ffULL, 0x000000106b5e7824ULL, 0x000fe200078e00ffULL,
0x0000005dff5d723eULL, 0x000fe200020006ffULL, 0x0000006e0830723cULL, 0x000fe20000001830ULL,
0x000054106d6d7816ULL, 0x000fe40000000074ULL, 0x00005410736c7816ULL, 0x000fe2000000005cULL,
0x00000010785c7824ULL, 0x000fe200078e00ffULL, 0x0000541077777816ULL, 0x000fc40000000075ULL,
0x0000541076767816ULL, 0x000fe2000000005dULL, 0x00000070082c723cULL, 0x000fe2000000182cULL,
0xfffffff05e797812ULL, 0x000fe400078ee279ULL, 0x000000005c5c783bULL, 0x000ea20000000200ULL,
0x00000018ff6b7819ULL, 0x102fe40000011660ULL, 0x00000010ff6a7819ULL, 0x000fe40000011660ULL,
0x0000006c5020723cULL, 0x040f700000001820ULL, 0x000000765040723cULL, 0x000bee0000001840ULL,
0x0000001079507824ULL, 0x020fe200078e00ffULL, 0x0000006c080c723cULL, 0x040b6a000000180cULL,
0x000000005050783bULL, 0x000e640000000200ULL, 0x0000ffff606d7812ULL, 0x020fe200078ec0ffULL,
0x000000760804723cULL, 0x000b620000001804ULL, 0x0000006bff6c723eULL, 0x000fc400020006ffULL,
0x000000ff6a6b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff60607812ULL, 0x000fe400078ec0ffULL,
0x0000001069087824ULL, 0x020fe200078e0268ULL, 0x00000008ff6a7819ULL, 0x000fe4000001166dULL,
0x00000060ff60723eULL, 0x000fe400020006ffULL, 0x0000006aff6a723eULL, 0x000fe200020006ffULL,
0x000000000808783bULL, 0x000ee20000000200ULL, 0x0000006bff6b723eULL, 0x000fc400020006ffULL,
0x00005410606a7816ULL, 0x000fe4000000006aULL, 0x0000ffff61607812ULL, 0x040fe400078ec0ffULL,
0x00000010ff687819ULL, 0x100fe40000011661ULL, 0x00000018ff697819ULL, 0x000fe40000011661ULL,
0x000000ff61617812ULL, 0x000fe400078ec0ffULL, 0x00000008ff607819ULL, 0x000fc40000011660ULL,
0x000054106b6b7816ULL, 0x000fe4000000006cULL, 0x000000ff68687812ULL, 0x000fe400078ec0ffULL,
0x00000061ff61723eULL, 0x000fe400020006ffULL, 0x00000060ff60723eULL, 0x000fe200020006ffULL,
0x0000006a5c34723cULL, 0x004f620000001834ULL, 0x00000069ff6c723eULL, 0x000fe400020006ffULL,
0x00000068ff69723eULL, 0x000fc400020006ffULL, 0x0000541061687816ULL, 0x000fe40000000060ULL,
0x00000010ff607819ULL, 0x000fe20000011663ULL, 0x0000006a5010723cULL, 0x002b620000001810ULL,
0x0000541069697816ULL, 0x000fe4000000006cULL, 0x000000ff60617812ULL, 0x000fc800078ec0ffULL,
0x0000ffff636b7812ULL, 0x060fe200078ec0ffULL, 0x000000685c24723cULL, 0x080f620000001824ULL,
0x00000018ff6a7819ULL, 0x000fe40000011663ULL, 0x000000ff63637812ULL, 0x000fe400078ec0ffULL,
0x00000008ff607819ULL, 0x000fe4000001166bULL, 0x0000006aff6a723eULL, 0x000fe200020006ffULL,
0x000000685028723cULL, 0x000b620000001828ULL, 0x00000063ff63723eULL, 0x000fc400020006ffULL,
0x0000ffff626b7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff08737812ULL, 0x008fe400078ec0ffULL,
0x00000061ff69723eULL, 0x020fe400020006ffULL, 0x00000060ff68723eULL, 0x000fe400020006ffULL,
0x00000010ff607819ULL, 0x000fe40000011662ULL, 0x0000541069697816ULL, 0x000fc4000000006aULL,
0x0000541063687816ULL, 0x000fe40000000068ULL, 0x00000018ff617819ULL, 0x000fe40000011662ULL,
0x000000ff60637812ULL, 0x000fe400078ec0ffULL, 0x000000ff62627812ULL, 0x000fe200078ec0ffULL,
0x000000685c1c723cULL, 0x000f62000000181cULL, 0x00000008ff607819ULL, 0x000fe4000001166bULL,
0x00000062ff62723eULL, 0x000fc400020006ffULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x000000ff086a7812ULL, 0x000fe200078ec0ffULL, 0x00000068504c723cULL, 0x000b62000000184cULL,
0x0000541062627816ULL, 0x000fe40000000060ULL, 0x0000ffff09747812ULL, 0x000fe400078ec0ffULL,
0x00000010ff6d7819ULL, 0x000fe4000001160aULL, 0x00000010ff687819ULL, 0x020fc40000011608ULL,
0x00000018ff697819ULL, 0x000fe40000011608ULL, 0x00000018ff087819ULL, 0x000fe40000011609ULL,
0x00000018ff6e7819ULL, 0x000fe4000001160aULL, 0x00000008ff60723eULL, 0x000fe400020006ffULL,
0x00000008ff087819ULL, 0x000fe40000011673ULL, 0x000000ff0a6f7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff0a757812ULL, 0x000fe400078ec0ffULL, 0x000000ff096b7812ULL, 0x000fe400078ec0ffULL,
0x0000006aff6a723eULL, 0x000fe400020006ffULL, 0x00000008ff08723eULL, 0x000fe400020006ffULL,
0x00000008ff0a7819ULL, 0x000fe40000011674ULL, 0x00000010ff6c7819ULL, 0x000fc40000011609ULL,
0x0000006bff09723eULL, 0x000fe400020006ffULL, 0x000054106a6a7816ULL, 0x000fe40000000008ULL,
0x0000000aff0a723eULL, 0x000fe400020006ffULL, 0x000000ff6d6d7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff087819ULL, 0x000fe40000011675ULL, 0x00005410090a7816ULL, 0x000fc4000000000aULL,
0x0000006eff6e723eULL, 0x000fe400020006ffULL, 0x0000006fff6f723eULL, 0x000fe400020006ffULL,
0x0000006dff09723eULL, 0x000fe400020006ffULL, 0x00000008ff08723eULL, 0x000fe400020006ffULL,
0x000000ff6c6c7812ULL, 0x000fe400078ec0ffULL, 0x0000541009097816ULL, 0x000fc4000000006eULL,
0x000054106f087816ULL, 0x000fe40000000008ULL, 0x00000010ff707819ULL, 0x100fe4000001160bULL,
0x00000018ff717819ULL, 0x000fe4000001160bULL, 0x000000ff0b727812ULL, 0x040fe200078ec0ffULL,
0x000000085c20723cULL, 0x000f620000001820ULL, 0x0000ffff0b767812ULL, 0x000fe400078ec0ffULL,
0x0000006cff0b723eULL, 0x000fc400020006ffULL, 0x000000ff68687812ULL, 0x000fe400078ec0ffULL,
0x000054100b0b7816ULL, 0x000fe20000000060ULL, 0x00000008500c723cULL, 0x000b62000000180cULL,
0x000000ff70707812ULL, 0x000fe400078ec0ffULL, 0x00000008ff607819ULL, 0x000fe40000011676ULL,
0x00000061ff61723eULL, 0x000fe400020006ffULL, 0x0000000465087810ULL, 0x020fe20007ffe0ffULL,
0x0000000a5c44723cULL, 0x000b620000001844ULL, 0x00000063ff63723eULL, 0x000fc400020006ffULL,
0x000000180800780cULL, 0x000fe40003f25270ULL, 0x00000069ff69723eULL, 0x000fe400020006ffULL,
0x00000068ff6b723eULL, 0x000fe200020006ffULL, 0x0000000a502c723cULL, 0x000b62000000182cULL,
0x00000071ff71723eULL, 0x000fe400020006ffULL, 0x00000072ff72723eULL, 0x000fe400020006ffULL,
0x00000070ff73723eULL, 0x000fc400020006ffULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x0000541063637816ULL, 0x000fe40000000061ULL, 0x000054106b6b7816ULL, 0x000fe40000000069ULL,
0x0000541073737816ULL, 0x000fe40000000071ULL, 0x0000541072727816ULL, 0x000fe20000000060ULL,
0x000000625c38723cULL, 0x000b620000001838ULL, 0xfffffff4656d7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff657224ULL, 0x000fcc00078e0008ULL, 0x00000062503c723cULL, 0x000b70000000183cULL,
0x0000006a5c48723cULL, 0x040b700000001848ULL, 0x000000725c40723cULL, 0x000b700000001840ULL,
0x0000006a5030723cULL, 0x040b700000001830ULL, 0x000000725004723cULL, 0x000b620000001804ULL,
0x0000001000009944ULL, 0x000fe20003c00000ULL, 0xffffede000007947ULL, 0x000fcc000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff5b7224ULL, 0x000fe200078e001bULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffe14000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x0000005734517220ULL, 0x0a0fe20000410000ULL,
0x0000005724247220ULL, 0x080fe20000410000ULL, 0x0000005725257220ULL, 0x080fe20000410000ULL,
0x0000005741417220ULL, 0x080fe20000410000ULL, 0x000000573e657220ULL, 0x080fe20000410000ULL,
0x0000005735357220ULL, 0x080fe20000410000ULL, 0x0000005736367220ULL, 0x080fe20000410000ULL,
0x0000005737377220ULL, 0x080fe20000410000ULL, 0x0000005726267220ULL, 0x080fe20000410000ULL,
0x0000005727277220ULL, 0x080fe20000410000ULL, 0x0000005739397220ULL, 0x080fe20000410000ULL,
0x000000573a3a7220ULL, 0x080fe20000410000ULL, 0x0000005748487220ULL, 0x080fe20000410000ULL,
0x0000005744447220ULL, 0x080fe20000410000ULL, 0x0000005745457220ULL, 0x080fe20000410000ULL,
0x0000005722347220ULL, 0x080fe20000410000ULL, 0x0000005740407220ULL, 0x080fe20000410000ULL,
0x0000005712617220ULL, 0x080fe20000410000ULL, 0x0000005713627220ULL, 0x080fe20000410000ULL,
0x000000574c3e7220ULL, 0x080fe20000410000ULL, 0x000000573b3b7220ULL, 0x080fe20000410000ULL,
0x000000571c1c7220ULL, 0x080fe20000410000ULL, 0x000000571d1d7220ULL, 0x080fe20000410000ULL,
0x000000571e1e7220ULL, 0x080fe20000410000ULL, 0x000000571f1f7220ULL, 0x080fe20000410000ULL,
0x0000005749087220ULL, 0x080fe20000410000ULL, 0x000000574a097220ULL, 0x080fe20000410000ULL,
0x000000574b0a7220ULL, 0x080fe20000410000ULL, 0x00000057460b7220ULL, 0x080fe20000410000ULL,
0x0000005720207220ULL, 0x080fe20000410000ULL, 0x0000005721217220ULL, 0x080fe20000410000ULL,
0x0000005723527220ULL, 0x080fe20000410000ULL, 0x0000005742537220ULL, 0x080fe20000410000ULL,
0x0000005743587220ULL, 0x080fe20000410000ULL, 0x0000005710107220ULL, 0x080fe20000410000ULL,
0x0000005711117220ULL, 0x080fe20000410000ULL, 0x0000005728127220ULL, 0x080fe20000410000ULL,
0x0000005729137220ULL, 0x080fe20000410000ULL, 0x000000573c5a7220ULL, 0x080fe20000410000ULL,
0x000000573d5b7220ULL, 0x080fe20000410000ULL, 0x000000574d5c7220ULL, 0x080fe20000410000ULL,
0x00000057305d7220ULL, 0x080fe20000410000ULL, 0x00000057315e7220ULL, 0x080fe20000410000ULL,
0x000000572c5f7220ULL, 0x080fe20000410000ULL, 0x000000572d607220ULL, 0x080fe20000410000ULL,
0x000000570c0c7220ULL, 0x080fe20000410000ULL, 0x000000570d0d7220ULL, 0x080fe20000410000ULL,
0x0000005704047220ULL, 0x080fe20000410000ULL, 0x0000005738507220ULL, 0x080fe20000410000ULL,
0x000000574f687220ULL, 0x080fe20000410000ULL, 0x0000005747387220ULL, 0x080fe20000410000ULL,
0x000000572a637220ULL, 0x080fe20000410000ULL, 0x000000574e677220ULL, 0x080fe20000410000ULL,
0x0000005732697220ULL, 0x080fe20000410000ULL, 0x000000ffff4f7224ULL, 0x000fe200078e0024ULL,
0x000000572b647220ULL, 0x080fe20000410000ULL, 0x000000ffff4b7224ULL, 0x000fe200078e0025ULL,
0x000000573f667220ULL, 0x080fe20000410000ULL, 0x000000ffff427224ULL, 0x000fe200078e0041ULL,
0x00000057336a7220ULL, 0x080fe20000410000ULL, 0x000000572e6b7220ULL, 0x080fe20000410000ULL,
0x000000572f6c7220ULL, 0x080fe20000410000ULL, 0x000000ffff4a7224ULL, 0x000fe200078e0035ULL,
0x000000570e0e7220ULL, 0x080fe20000410000ULL, 0x000000ffff4c7224ULL, 0x000fe200078e0039ULL,
0x000000570f0f7220ULL, 0x080fe20000410000ULL, 0x000000ffff4e7224ULL, 0x000fe200078e0048ULL,
0x0000005705057220ULL, 0x080fe20000410000ULL, 0x000000ffff477224ULL, 0x000fe200078e0044ULL,
0x0000005706067220ULL, 0x080fe20000410000ULL, 0x000000ffff467224ULL, 0x000fe200078e0045ULL,
0x0000005707077220ULL, 0x000fe20000410000ULL, 0x000000ffff437224ULL, 0x000fc400078e0040ULL,
0x000000ffff227224ULL, 0x000fe400078e0036ULL, 0x000000ffff417224ULL, 0x000fe400078e0037ULL,
0x000000ffff237224ULL, 0x000fe400078e0026ULL, 0x000000ffff257224ULL, 0x000fe400078e0027ULL,
0x000000ffff247224ULL, 0x000fe400078e003aULL, 0x000000ffff2a7224ULL, 0x000fc400078e0034ULL,
0x000000ffff327224ULL, 0x000fe400078e003eULL, 0x000000ffff497224ULL, 0x000fe400078e001cULL,
0x000000ffff4d7224ULL, 0x000fe400078e001dULL, 0x000000ffff487224ULL, 0x000fe400078e0008ULL,
0x000000ffff457224ULL, 0x000fe400078e0020ULL, 0x000000ffff447224ULL, 0x000fc400078e0021ULL,
0x000000ffff407224ULL, 0x000fe400078e003bULL, 0x000000ffff267224ULL, 0x000fe400078e001eULL,
0x000000ffff287224ULL, 0x000fe400078e001fULL, 0x000000ffff277224ULL, 0x000fe400078e0009ULL,
0x000000ffff3f7224ULL, 0x000fe400078e000aULL, 0x000000ffff297224ULL, 0x000fc400078e000bULL,
0x000000ffff2b7224ULL, 0x000fe400078e0052ULL, 0x000000ffff3d7224ULL, 0x000fe400078e0053ULL,
0x000000ffff3c7224ULL, 0x000fe400078e0058ULL, 0x000000ffff2d7224ULL, 0x000fe400078e0010ULL,
0x000000ffff2c7224ULL, 0x000fe400078e0011ULL, 0x000000ffff2e7224ULL, 0x000fc400078e0012ULL,
0x000000ffff2f7224ULL, 0x000fe400078e0013ULL, 0x000000ffff307224ULL, 0x000fe400078e005aULL,
0x000000ffff317224ULL, 0x000fe400078e005bULL, 0x000000ffff337224ULL, 0x000fe400078e005cULL,
0x000000ffff347224ULL, 0x000fe400078e005dULL, 0x000000ffff357224ULL, 0x000fc400078e005eULL,
0x000000ffff367224ULL, 0x000fe400078e005fULL, 0x000000ffff377224ULL, 0x000fe400078e0060ULL,
0x000000ffff3e7224ULL, 0x000fe400078e000cULL, 0x000000ffff397224ULL, 0x000fe400078e000dULL,
0x000000ffff3a7224ULL, 0x000fe200078e0004ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000056087f8cULL, 0x0002a2000c80043fULL, 0x000000ffff0c7224ULL, 0x000fc400078e000eULL,
0x000000ffff0d7224ULL, 0x000fe400078e000fULL, 0x000000ffff3b7224ULL, 0x000fe400078e0005ULL,
0x000000ffff207224ULL, 0x000fe400078e0061ULL, 0x000000ffff1f7224ULL, 0x000fe400078e0062ULL,
0x000000ffff1e7224ULL, 0x000fe400078e0063ULL, 0x000000ffff1d7224ULL, 0x000fc400078e0064ULL,
0x000000ffff1c7224ULL, 0x000fe400078e0065ULL, 0x000000ffff137224ULL, 0x000fe400078e0066ULL,
0x000000ffff217224ULL, 0x000fe400078e0067ULL, 0x000000ffff127224ULL, 0x000fe400078e0068ULL,
0x000000ffff117224ULL, 0x000fe400078e0069ULL, 0x000000ffff107224ULL, 0x000fc400078e006aULL,
0x000000ffff0a7224ULL, 0x000fe400078e006bULL, 0x000000ffff0b7224ULL, 0x000fe400078e006cULL,
0x000000ffff0e7224ULL, 0x000fe400078e0006ULL, 0x000000ffff0f7224ULL, 0x000fc400078e0007ULL,
0x0000000000047805ULL, 0x006fca0000015200ULL, 0x0000040056077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff527224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000105200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x0000000604537210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09005300780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c405300780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011407ULL, 0x0000005306067211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000206067819ULL, 0x000fc80000001207ULL,
0x000000060000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000152527810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040056077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000459097824ULL, 0x000fe200078e00ffULL,
0x000000175400720cULL, 0x000fc80003f06070ULL, 0xfffffff009057812ULL, 0x000fca00078ec0ffULL,
0x000000801a087824ULL, 0x000fca00078e0205ULL, 0x0124000008047984ULL, 0x0002a20000000c00ULL,
0x00001f6000008947ULL, 0x000fea0003800000ULL, 0x0000010054537824ULL, 0x000fe200078e0203ULL,
0x0000000059587211ULL, 0x040fe200078ff0ffULL, 0x00000002595a7824ULL, 0x000fe400078e00ffULL,
0x00000002ff727424ULL, 0x000fe200078e00ffULL, 0x0000005316527217ULL, 0x000fe40007800000ULL,
0x00000008585b7810ULL, 0x040fe40007ffe0ffULL, 0x0000001058607810ULL, 0x000fe20007ffe0ffULL,
0x0000000152527824ULL, 0x000fe200078e0a53ULL, 0x000000065a537812ULL, 0x000fc400078ec0ffULL,
0x00005a00ff5e7a19ULL, 0x000fe4000001165bULL, 0x00005800535b7a10ULL, 0x000fe20007ffe0ffULL,
0x00000001185d7824ULL, 0x000fe200078e0253ULL, 0x00005a00ff5a7a19ULL, 0x000fe40000011658ULL,
0x0000001858617810ULL, 0x000fe20007ffe0ffULL, 0x000000015d5c7824ULL, 0x140fe200078e0a52ULL,
0x000000525d00720cULL, 0x000fe20003f26070ULL, 0x000000015b587824ULL, 0x000fe200078e0a52ULL,
0x0000005a195d7217ULL, 0x000fc40003800000ULL, 0x0000005c195c7217ULL, 0x000fe40003800000ULL,
0x000000525b00720cULL, 0x000fe20003f06070ULL, 0x0000005d14857224ULL, 0x000fe200078e02ffULL,
0x00000004ff5c7819ULL, 0x000fe4000001165cULL, 0x0000005819587217ULL, 0x040fe40003800000ULL,
0x0000005e195f7217ULL, 0x000fe40003800000ULL, 0x00005a00ff607a19ULL, 0x000fc40000011660ULL,
0x000000ff5c627207ULL, 0x000fe20000800000ULL, 0x0000005f14877224ULL, 0x000fe200078e02ffULL,
0x000000ff58687207ULL, 0x000fe40000000000ULL, 0x00005a00ff587a19ULL, 0x000fe20000011661ULL,
0x00000001855d7824ULL, 0x000fe200078e0262ULL, 0x0000006019637217ULL, 0x000fe40003800000ULL,
0x00000085685f7211ULL, 0x040fe200078fe0ffULL, 0x000060005d5c7625ULL, 0x000fe200078e0072ULL,
0x0000008768617211ULL, 0x000fc400078fe0ffULL, 0x0000005819657217ULL, 0x000fe20003800000ULL,
0x0000006314897224ULL, 0x040fe200078e02ffULL, 0x0000001053637812ULL, 0x000fe200078efcffULL,
0x000060005f5e7625ULL, 0x080fe200078e0072ULL, 0x000000085c5d7981ULL, 0x000726000c1e9500ULL,
0x0000600061607625ULL, 0x000fe200078e0072ULL, 0x000000085e587981ULL, 0x000326000c1e9500ULL,
0x00000065148b7224ULL, 0x000fe200078e02ffULL, 0x0000580063657a10ULL, 0x000fe20007ffe0ffULL,
0x0000000118697824ULL, 0x000fe200078e0263ULL, 0x00000008605a7981ULL, 0x000522000c1e9500ULL,
0x00000089686d7211ULL, 0x000fe200078fe0ffULL, 0x00000001626b7824ULL, 0x000fc400078e0287ULL,
0x00000001626f7824ULL, 0x040fe400078e0289ULL, 0x0000000162677824ULL, 0x000fe400078e028bULL,
0x0000000169627824ULL, 0x100fe400078e0a52ULL, 0x0000000165607824ULL, 0x044fe200078e0a52ULL,
0x000000526500720cULL, 0x000fe20003f06070ULL, 0x000060006d6c7625ULL, 0x000fe200078e0072ULL,
0x0000006219627217ULL, 0x040fe40003800000ULL, 0x0000006019607217ULL, 0x000fe20003800000ULL,
0x000060006b6a7625ULL, 0x080fe200078e0072ULL, 0x000000086c5c7981ULL, 0x0084e6000c1e9500ULL,
0x000060006f6e7625ULL, 0x000fe200078e0072ULL, 0x000000086a5f7981ULL, 0x0022e2000c1e9500ULL,
0x000000ff60787207ULL, 0x000fc60000000000ULL, 0x000000086e617981ULL, 0x0002e2000c1e9500ULL,
0x000000526900720cULL, 0x000fe40003f26070ULL, 0x00000004ff627819ULL, 0x000fe40000011662ULL,
0x0000008b68717211ULL, 0x000fe200078fe0ffULL, 0x0000600067667625ULL, 0x080fe200078e0072ULL,
0x000000ff62647207ULL, 0x000fe40000800000ULL, 0x00000087786f7211ULL, 0x002fe200078fe0ffULL,
0x0000600071707625ULL, 0x000fc400078e0072ULL, 0x0000000866677981ULL, 0x0002e4000c1e9500ULL,
0x000060006f6e7625ULL, 0x080fe400078e0072ULL, 0x00000008705e7981ULL, 0x0002e4000c1e9500ULL,
0x00000001856d7824ULL, 0x004fe200078e0264ULL, 0x00000085786b7211ULL, 0x000fe200078fe0ffULL,
0x0000000164757824ULL, 0x000fe200078e028bULL, 0x000000086e627981ULL, 0x0004e2000c1e9500ULL,
0x000060006d6c7625ULL, 0x000fc800078e0072ULL, 0x0000000164717824ULL, 0x002fe200078e0287ULL,
0x000000086c697981ULL, 0x0002e2000c1e9500ULL, 0x00006000756e7625ULL, 0x004fe200078e0072ULL,
0x0000002053757812ULL, 0x000fc600078efcffULL, 0x000060006b6a7625ULL, 0x000fc800078e0072ULL,
0x0000000164737824ULL, 0x000fe200078e0289ULL, 0x000000086a607981ULL, 0x0004e2000c1e9500ULL,
0x0000600071707625ULL, 0x000fe200078e0072ULL, 0x0000580075777a10ULL, 0x000fe40007ffe0ffULL,
0x00000089787d7211ULL, 0x000fe200078fe0ffULL, 0x00000001186d7824ULL, 0x002fe200078e0275ULL,
0x0000008b787f7211ULL, 0x000fe200078fe0ffULL, 0x000000086e7b7981ULL, 0x0002e4000c1e9500ULL,
0x000000016d747824ULL, 0x000fc400078e0a52ULL, 0x00006000736a7625ULL, 0x004fe400078e0072ULL,
0x0000000870737981ULL, 0x0004e2000c1e9500ULL, 0x0000007419747217ULL, 0x000fe20003800000ULL,
0x00000001776c7824ULL, 0x040fe200078e0a52ULL, 0x000000527700720cULL, 0x000fe20003f06070ULL,
0x000060007d7c7625ULL, 0x000fe200078e0072ULL, 0x000000526d00720cULL, 0x000fe20003f26070ULL,
0x000000086a797981ULL, 0x0002e2000c1e9500ULL, 0x0000006c196c7217ULL, 0x000fe20003800000ULL,
0x000060007f7e7625ULL, 0x000fe200078e0072ULL, 0x00000004ff747819ULL, 0x000fe20000011674ULL,
0x000000087c647981ULL, 0x0004e2000c1e9500ULL, 0x000000ff6c7a7207ULL, 0x000fc60000000000ULL,
0x000000087e667981ULL, 0x0004e2000c1e9500ULL, 0x000000ff746a7207ULL, 0x002fe40000800000ULL,
0x000000877a837211ULL, 0x000fc600078fe0ffULL, 0x000000016a717824ULL, 0x004fe400078e0287ULL,
0x0000600083827625ULL, 0x000fe200078e0072ULL, 0x000000857a6d7211ULL, 0x000fc600078fe0ffULL,
0x0000600071707625ULL, 0x080fe200078e0072ULL, 0x0000000882767981ULL, 0x0002a6000c1e9500ULL,
0x00000001857f7824ULL, 0x000fe200078e026aULL, 0x0000000870cd7981ULL, 0x0002a2000c1e9500ULL,
0x000060006d6c7625ULL, 0x080fe200078e0072ULL, 0x000000897a6f7211ULL, 0x040fe400078fe0ffULL,
0x0000008b7a6b7211ULL, 0x000fe200078fe0ffULL, 0x000060007f7e7625ULL, 0x000fe200078e0072ULL,
0x0000003053b37812ULL, 0x000fe200078efcffULL, 0x000000086c747981ULL, 0x0002a4000c1e9500ULL,
0x000000016a7d7824ULL, 0x000fc400078e0289ULL, 0x000000016a8d7824ULL, 0x000fe200078e028bULL,
0x000000087e817981ULL, 0x0002a2000c1e9500ULL, 0x000060006f6e7625ULL, 0x000fe200078e0072ULL,
0x00005800b3b57a10ULL, 0x000fc60007ffe0ffULL, 0x000060006b6a7625ULL, 0x080fe200078e0072ULL,
0x000000086ed17981ULL, 0x0002a6000c1e9500ULL, 0x000060007d7c7625ULL, 0x080fe200078e0072ULL,
0x000000086ad57981ULL, 0x0002a6000c1e9500ULL, 0x000060008d6c7625ULL, 0x002fe200078e0072ULL,
0x000000087c887981ULL, 0x0002a6000c1e9500ULL, 0x00000001187f7824ULL, 0x000fe200078e02b3ULL,
0x000000086c8c7981ULL, 0x0002a6000c1e9500ULL, 0x000000017f807824ULL, 0x000fc400078e0a52ULL,
0x00000001b57e7824ULL, 0x000fc600078e0a52ULL, 0x0000008019807217ULL, 0x000fe40003800000ULL,
0x000000527f00720cULL, 0x080fe40003f26070ULL, 0x00000052b500720cULL, 0x000fe40003f06070ULL,
0x0000007e197e7217ULL, 0x000fe40003800000ULL, 0x00000004ff6a7819ULL, 0x000fe40000011680ULL,
0x000000ff7e807207ULL, 0x000fc40000000000ULL, 0x000000ff6a827207ULL, 0x000fe40000800000ULL,
0x00000085807d7211ULL, 0x042fe400078fe0ffULL, 0x00000089806d7211ULL, 0x000fe200078fe0ffULL,
0x00000001857f7824ULL, 0x000fe400078e0282ULL, 0x00000001826f7824ULL, 0x000fe400078e0289ULL,
0x000060007d7c7625ULL, 0x000fc800078e0072ULL, 0x000060007f7e7625ULL, 0x080fe200078e0072ULL,
0x000000087cb77981ULL, 0x0002a6000c1e9500ULL, 0x000060006d6c7625ULL, 0x080fe200078e0072ULL,
0x000000087e847981ULL, 0x0002a6000c1e9500ULL, 0x000060006f6e7625ULL, 0x000fe200078e0072ULL,
0x000000086cd37981ULL, 0x0002a2000c1e9500ULL, 0x00000087806b7211ULL, 0x000fc600078fe0ffULL,
0x000000086e8a7981ULL, 0x0002a2000c1e9500ULL, 0x0000000182717824ULL, 0x000fe400078e0287ULL,
0x000060006b6a7625ULL, 0x000fc800078e0072ULL, 0x0000600071707625ULL, 0x080fe200078e0072ULL,
0x000000086acf7981ULL, 0x0002a4000c1e9500ULL, 0x0000008b807d7211ULL, 0x002fe400078fe0ffULL,
0x0000000870867981ULL, 0x0002a2000c1e9500ULL, 0x00000001827f7824ULL, 0x000fe400078e028bULL,
0x000060007d7c7625ULL, 0x000fc800078e0072ULL, 0x000060007f7e7625ULL, 0x000fe200078e0072ULL,
0x000000087cd77981ULL, 0x0002a8000c1e9500ULL, 0x000000087e8e7981ULL, 0x0002a2000c1e9500ULL,
0xfffffff0686b7812ULL, 0x000fe200078ec0ffULL, 0x00000001ffcb7424ULL, 0x000fc800078e00ffULL,
0x0000000152687824ULL, 0x000fe200078e026bULL, 0xfffffff0786b7812ULL, 0x000fc600078ec0ffULL,
0x000000015b6a7824ULL, 0x000fe200078e0a68ULL, 0x0000000153837812ULL, 0x000fe200078efcffULL,
0x0000000152707824ULL, 0x002fc600078e026bULL, 0x0000006acb6b7219ULL, 0x000fe400000006ffULL,
0x00005800836d7a10ULL, 0x000fe40007ffe0ffULL, 0xfffffff07a6f7812ULL, 0x000fc600078ec0ffULL,
0x000000016d6c7824ULL, 0x100fe200078e0a68ULL, 0x0000000853857812ULL, 0x040fe200078efcffULL,
0x0000000152727824ULL, 0x000fe200078e026fULL, 0x0000000953877812ULL, 0x000fe400078efcffULL,
0x0000006ccb6f7219ULL, 0x000fe400000006ffULL, 0x0000580085717a10ULL, 0x000fe40007ffe0ffULL,
0x00005800877f7a10ULL, 0x000fe40007ffe0ffULL, 0xfffffff0807d7812ULL, 0x000fe200078ec0ffULL,
0x00000001716e7824ULL, 0x000fc400078e0a68ULL, 0x000000017f687824ULL, 0x000fe200078e0a68ULL,
0x00000011538d7812ULL, 0x000fe200078efcffULL, 0x00000001527c7824ULL, 0x000fe200078e027dULL,
0x0000006ecb7d7219ULL, 0x040fe400000006ffULL, 0x00000068cb897219ULL, 0x000fe400000006ffULL,
0x000058008d8f7a10ULL, 0x000fe20007ffe0ffULL, 0x0000000165687824ULL, 0x000fe200078e0a70ULL,
0x0000001853937812ULL, 0x000fc600078efcffULL, 0x000000018f6a7824ULL, 0x000fe200078e0a70ULL,
0x0000541058587816ULL, 0x010fc8000000005dULL, 0x000000586bff7212ULL, 0x000fc800078ac0ffULL,
0x000000525b00720cULL, 0x000fc80002fa1470ULL, 0x000000525300720cULL, 0x000fe40002fa1070ULL,
0x000000586fff7212ULL, 0x000fe4000782c0ffULL, 0xff80000051517808ULL, 0x000fe40002800000ULL,
0x000000526d00720cULL, 0x000fe40000f21470ULL, 0x000054105a5a7816ULL, 0x008fe4000000005fULL,
0x000054105c5c7816ULL, 0x000fc40000000061ULL, 0x0000005a6bff7212ULL, 0x040fe4000784c0ffULL,
0x0000005c6bff7212ULL, 0x000fe4000788c0ffULL, 0x0000005a6fff7212ULL, 0x000fe400078ac0ffULL,
0x000000525b00720cULL, 0x0c0fe40001741470ULL, 0x000000525b00720cULL, 0x080fe40002781470ULL,
0x000000526d00720cULL, 0x000fc40002fa1470ULL, 0x000000525300720cULL, 0x0c0fe40001741070ULL,
0x000000525300720cULL, 0x080fe40002781070ULL, 0x000000528300720cULL, 0x0c0fe40000f21070ULL,
0x000000528300720cULL, 0x000fe40002fa1070ULL, 0x000054105e5e7816ULL, 0x000fe40000000067ULL,
0xff80000022227808ULL, 0x000fc40001000000ULL, 0xff8000002d2d7808ULL, 0x000fe40002000000ULL,
0xff8000004a4a7808ULL, 0x000fe40000800000ULL, 0xff80000041417808ULL, 0x000fe40002800000ULL,
0x000000587dff7212ULL, 0x000fe4000786c0ffULL, 0x0000005e6bff7212ULL, 0x000fe4000780c0ffULL,
0x0000005c6fff7212ULL, 0x000fc4000784c0ffULL, 0x0000005e6fff7212ULL, 0x000fe4000788c0ffULL,
0x0000005a89ff7212ULL, 0x000fe4000782c0ffULL, 0x0000005c7dff7212ULL, 0x000fe400078ac0ffULL,
0x000000525b00720cULL, 0x080fe40000701470ULL, 0x000000526d00720cULL, 0x0c0fe40001741470ULL,
0x000000526d00720cULL, 0x000fc40002781470ULL, 0x000000527100720cULL, 0x0c0fe40001f61470ULL,
0x000000527100720cULL, 0x080fe40002fa1470ULL, 0x000000527f00720cULL, 0x080fe40000f21470ULL,
0x0000001953997812ULL, 0x040fe400078efcffULL, 0x000000525300720cULL, 0x080fe40000701070ULL,
0x000000528300720cULL, 0x000fc40001741070ULL, 0x000000528300720cULL, 0x080fe40002781070ULL,
0x000000528500720cULL, 0x0c0fe40001f61070ULL, 0x000000528500720cULL, 0x080fe40002fa1070ULL,
0x000000528700720cULL, 0x000fe40000f21070ULL, 0x00000068cb8b7219ULL, 0x040fe400000006ffULL,
0x0000006acb917219ULL, 0x000fc400000006ffULL, 0x0000541060607816ULL, 0x000fe40000000069ULL,
0x0000541062627816ULL, 0x000fe40000000073ULL, 0x0000580093957a10ULL, 0x000fe40007ffe0ffULL,
0x00005800999b7a10ULL, 0x000fe40007ffe0ffULL, 0xff80000020207808ULL, 0x000fe40000000000ULL,
0xff8000002c2c7808ULL, 0x000fc40001000000ULL, 0xff8000001f1f7808ULL, 0x000fe40002000000ULL,
0xff8000004f4f7808ULL, 0x000fe40001800000ULL, 0xff8000002e2e7808ULL, 0x000fe40002800000ULL,
0xff80000025257808ULL, 0x000fe40000800000ULL, 0x0000005a7dff7212ULL, 0x000fe4000780c0ffULL,
0x0000005c89ff7212ULL, 0x000fc4000784c0ffULL, 0x0000005e7dff7212ULL, 0x080fe4000788c0ffULL,
0x0000005e89ff7212ULL, 0x000fe4000786c0ffULL, 0x0000006091ff7212ULL, 0x000fe400078ac0ffULL,
0x000000628bff7212ULL, 0x000fe2000782c0ffULL, 0x00000001956c7824ULL, 0x100fe200078e0a70ULL,
0x000000527100720cULL, 0x080fe20000701470ULL, 0x000000019b707824ULL, 0x000fe200078e0a70ULL,
0x000000527100720cULL, 0x000fc40002781470ULL, 0x000000527f00720cULL, 0x0c0fe40001741470ULL,
0x000000527f00720cULL, 0x080fe40001f61470ULL, 0x000000526500720cULL, 0x080fe40000f21470ULL,
0x000000528f00720cULL, 0x080fe40002fa1470ULL, 0x000000528500720cULL, 0x0c0fe40000701070ULL,
0x000000528500720cULL, 0x000fc40002781070ULL, 0x000000528700720cULL, 0x0c0fe40001741070ULL,
0x000000528700720cULL, 0x080fe40001f61070ULL, 0x000000526300720cULL, 0x080fe40000f21070ULL,
0x000000528d00720cULL, 0x000fe40002fa1070ULL, 0x0000006ccb977219ULL, 0x040fe400000006ffULL,
0x00000070cb9d7219ULL, 0x000fc400000006ffULL, 0x0000541064647816ULL, 0x000fe40000000079ULL,
0x0000541066667816ULL, 0x000fe4000000007bULL, 0xff80000023237808ULL, 0x000fe40000000000ULL,
0xff8000001e1e7808ULL, 0x000fe40002000000ULL, 0xff8000002f2f7808ULL, 0x000fe40001000000ULL,
0xff8000001d1d7808ULL, 0x000fc40001800000ULL, 0xff80000024247808ULL, 0x000fe40000800000ULL,
0xff8000004c4c7808ULL, 0x000fe40002800000ULL, 0x000000608bff7212ULL, 0x080fe4000780c0ffULL,
0x0000006097ff7212ULL, 0x000fe4000788c0ffULL, 0x000000648bff7212ULL, 0x040fe4000784c0ffULL,
0x000000668bff7212ULL, 0x000fc4000786c0ffULL, 0x0000006491ff7212ULL, 0x000fe4000782c0ffULL,
0x000000629dff7212ULL, 0x000fe200078ac0ffULL, 0x00000001776e7824ULL, 0x000fe200078e0a72ULL,
0x000000526500720cULL, 0x0c0fe40000701470ULL, 0x000000526500720cULL, 0x0c0fe40001741470ULL,
0x000000526500720cULL, 0x080fe40001f61470ULL, 0x000000528f00720cULL, 0x000fc40000f21470ULL,
0x000000529500720cULL, 0x080fe40002781470ULL, 0x000000529b00720cULL, 0x080fe40002fa1470ULL,
0x0000002153a17812ULL, 0x000fe400078efcffULL, 0x000000526300720cULL, 0x0c0fe40000701070ULL,
0x000000526300720cULL, 0x0c0fe40001741070ULL, 0x000000526300720cULL, 0x000fc40001f61070ULL,
0x000000528d00720cULL, 0x080fe40000f21070ULL, 0x000000529300720cULL, 0x080fe40002781070ULL,
0x000000529900720cULL, 0x000fe40002fa1070ULL, 0x0000006ecb9f7219ULL, 0x000fe400000006ffULL,
0x0000541076767816ULL, 0x004fe400000000cdULL, 0x00005800a1a37a10ULL, 0x000fc40007ffe0ffULL,
0xff80000050507808ULL, 0x000fe40000000000ULL, 0xff80000030307808ULL, 0x000fe40001000000ULL,
0xff8000001c1c7808ULL, 0x000fe40001800000ULL, 0xff80000031317808ULL, 0x000fe40000800000ULL,
0xff80000049497808ULL, 0x000fe40002000000ULL, 0xff80000028287808ULL, 0x000fc40002800000ULL,
0x0000006291ff7212ULL, 0x040fe4000780c0ffULL, 0x0000006691ff7212ULL, 0x000fe4000784c0ffULL,
0x0000006297ff7212ULL, 0x000fe4000786c0ffULL, 0x000000649dff7212ULL, 0x040fe4000782c0ffULL,
0x000000669dff7212ULL, 0x000fe4000788c0ffULL, 0x000000769fff7212ULL, 0x000fe200078ac0ffULL,
0x00000001a3787824ULL, 0x000fe200078e0a72ULL, 0x000000528f00720cULL, 0x000fc40000701470ULL,
0x000000528f00720cULL, 0x080fe40001741470ULL, 0x000000529500720cULL, 0x080fe40001f61470ULL,
0x000000529b00720cULL, 0x0c0fe40000f21470ULL, 0x000000529b00720cULL, 0x080fe40002781470ULL,
0x000000527700720cULL, 0x000fe40002fa1470ULL, 0x0000002853a77812ULL, 0x000fc400078efcffULL,
0x0000002953ad7812ULL, 0x000fe400078efcffULL, 0x000000528d00720cULL, 0x0c0fe40000701070ULL,
0x000000528d00720cULL, 0x080fe40001741070ULL, 0x000000529300720cULL, 0x080fe40001f61070ULL,
0x000000529900720cULL, 0x0c0fe40000f21070ULL, 0x000000529900720cULL, 0x000fc40002781070ULL,
0x000000527500720cULL, 0x000fe40002fa1070ULL, 0x00000078cba57219ULL, 0x000fe400000006ffULL,
0x0000541074747816ULL, 0x000fe40000000081ULL, 0x00005410d1887816ULL, 0x000fe40000000088ULL,
0x00005410d58c7816ULL, 0x000fe4000000008cULL, 0x00005800a7a97a10ULL, 0x000fc40007ffe0ffULL,
0x00005800adaf7a10ULL, 0x000fe40007ffe0ffULL, 0xff80000040407808ULL, 0x000fe40000000000ULL,
0xff80000013137808ULL, 0x000fe40001000000ULL, 0xff80000026267808ULL, 0x000fe40001800000ULL,
0xff80000033337808ULL, 0x000fe40000800000ULL, 0xff80000012127808ULL, 0x000fc40002000000ULL,
0xff80000027277808ULL, 0x000fe40002800000ULL, 0x0000005889ff7212ULL, 0x000fe400078cc0ffULL,
0x0000006497ff7212ULL, 0x040fe4000780c0ffULL, 0x0000006697ff7212ULL, 0x000fe4000784c0ffULL,
0x000000749fff7212ULL, 0x040fe4000786c0ffULL, 0x000000889fff7212ULL, 0x000fc4000782c0ffULL,
0x0000008c9fff7212ULL, 0x000fe4000788c0ffULL, 0x00000088a5ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001a97a7824ULL, 0x100fe200078e0a72ULL, 0x000000527f00720cULL, 0x080fe200037c1470ULL,
0x00000001af727824ULL, 0x000fe200078e0a72ULL, 0x000000529500720cULL, 0x0c0fe40000701470ULL,
0x000000529500720cULL, 0x080fe40001741470ULL, 0x000000527700720cULL, 0x000fc40001f61470ULL,
0x000000527700720cULL, 0x0c0fe40000f21470ULL, 0x000000527700720cULL, 0x080fe40002781470ULL,
0x00000052a300720cULL, 0x080fe40002fa1470ULL, 0x000000528700720cULL, 0x080fe400037c1070ULL,
0x000000529300720cULL, 0x0c0fe40000701070ULL, 0x000000529300720cULL, 0x000fc40001741070ULL,
0x000000527500720cULL, 0x0c0fe40001f61070ULL, 0x000000527500720cULL, 0x0c0fe40000f21070ULL,
0x000000527500720cULL, 0x080fe40002781070ULL, 0x00000052a100720cULL, 0x000fe40002fa1070ULL,
0x0000007acbab7219ULL, 0x040fe400000006ffULL, 0x00000072cbb17219ULL, 0x000fc400000006ffULL,
0xff8000004b4b7808ULL, 0x000fe40003000000ULL, 0xff80000032327808ULL, 0x000fe40000000000ULL,
0xff80000021217808ULL, 0x000fe40001000000ULL, 0xff8000004e4e7808ULL, 0x000fe40001800000ULL,
0xff80000034347808ULL, 0x000fe40000800000ULL, 0xff80000011117808ULL, 0x000fc40002000000ULL,
0xff80000035357808ULL, 0x000fe40002800000ULL, 0x000000609dff7212ULL, 0x000fe400078cc0ffULL,
0x00000074a5ff7212ULL, 0x080fe4000780c0ffULL, 0x00000074abff7212ULL, 0x000fe4000784c0ffULL,
0x00000076a5ff7212ULL, 0x040fe4000786c0ffULL, 0x0000008ca5ff7212ULL, 0x000fc4000782c0ffULL,
0x00000076abff7212ULL, 0x000fe4000788c0ffULL, 0x00000088b1ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001b57e7824ULL, 0x000fe200078e0a7cULL, 0x000000529b00720cULL, 0x080fe400037c1470ULL,
0x00000052a300720cULL, 0x0c0fe40000701470ULL, 0x00000052a300720cULL, 0x0c0fe40001f61470ULL,
0x00000052a300720cULL, 0x000fc40000f21470ULL, 0x00000052a900720cULL, 0x0c0fe40001741470ULL,
0x00000052a900720cULL, 0x080fe40002781470ULL, 0x00000052af00720cULL, 0x000fe40002fa1470ULL,
0x0000003153bb7812ULL, 0x040fe400078efcffULL, 0x0000003853c17812ULL, 0x040fe400078efcffULL,
0x0000003953c77812ULL, 0x000fc400078efcffULL, 0x000000529900720cULL, 0x080fe400037c1070ULL,
0x00000052a100720cULL, 0x0c0fe40000701070ULL, 0x00000052a100720cULL, 0x0c0fe40001f61070ULL,
0x00000052a100720cULL, 0x080fe40000f21070ULL, 0x00000052a700720cULL, 0x0c0fe40001741070ULL,
0x00000052a700720cULL, 0x000fc40002781070ULL, 0x00000052ad00720cULL, 0x000fe40002fa1070ULL,
0x0000007ecbb97219ULL, 0x000fe400000006ffULL, 0x00005410b7847816ULL, 0x000fe40000000084ULL,
0x00005410d38a7816ULL, 0x000fe4000000008aULL, 0x00005800bbbd7a10ULL, 0x000fe40007ffe0ffULL,
0x00005800c1c37a10ULL, 0x000fc40007ffe0ffULL, 0x00005800c7c97a10ULL, 0x000fe40007ffe0ffULL,
0xff8000004d4d7808ULL, 0x000fe40003000000ULL, 0xff80000048487808ULL, 0x000fe40000000000ULL,
0xff8000003f3f7808ULL, 0x000fe40001800000ULL, 0xff80000010107808ULL, 0x000fe40000800000ULL,
0xff80000047477808ULL, 0x000fc40001000000ULL, 0xff80000029297808ULL, 0x000fe40002000000ULL,
0xff80000037377808ULL, 0x000fe40002800000ULL, 0x00000074b1ff7212ULL, 0x040fe400078cc0ffULL,
0x00000076b1ff7212ULL, 0x000fe4000780c0ffULL, 0x00000088abff7212ULL, 0x040fe4000786c0ffULL,
0x0000008cabff7212ULL, 0x000fc4000782c0ffULL, 0x0000008cb1ff7212ULL, 0x000fe4000784c0ffULL,
0x00000084b9ff7212ULL, 0x040fe4000788c0ffULL, 0x0000008ab9ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001bd807824ULL, 0x100fe200078e0a7cULL, 0x00000052a900720cULL, 0x080fe20001f61470ULL,
0x00000001c3827824ULL, 0x100fe200078e0a7cULL, 0x00000052a900720cULL, 0x080fe20000f21470ULL,
0x00000001c97c7824ULL, 0x000fe200078e0a7cULL, 0x00000052af00720cULL, 0x000fc400037c1470ULL,
0x00000052af00720cULL, 0x0c0fe40000701470ULL, 0x00000052af00720cULL, 0x080fe40001741470ULL,
0x00000052b500720cULL, 0x0c0fe40002781470ULL, 0x00000052b500720cULL, 0x000fe40002fa1470ULL,
0x00000080cbbf7219ULL, 0x040fe400000006ffULL, 0x00000082cbc57219ULL, 0x000fc400000006ffULL,
0x00000052a700720cULL, 0x0c0fe40001f61070ULL, 0x00000052a700720cULL, 0x080fe40000f21070ULL,
0x00000052ad00720cULL, 0x0c0fe400037c1070ULL, 0x00000052ad00720cULL, 0x0c0fe40000701070ULL,
0x00000052ad00720cULL, 0x080fe40001741070ULL, 0x00000052b300720cULL, 0x000fc40002781070ULL,
0x00000052b300720cULL, 0x000fe40002fa1070ULL, 0x0000007ccbcb7219ULL, 0x000fe400000006ffULL,
0x00005410cf867816ULL, 0x000fe40000000086ULL, 0xff80000036367808ULL, 0x000fe40001800000ULL,
0xff8000000a0a7808ULL, 0x000fe40000800000ULL, 0xff80000046467808ULL, 0x000fc40003000000ULL,
0xff80000038387808ULL, 0x000fe40000000000ULL, 0xff8000000b0b7808ULL, 0x000fe40001000000ULL,
0xff80000045457808ULL, 0x000fe40002000000ULL, 0xff8000003e3e7808ULL, 0x000fe40002800000ULL,
0x00000084bfff7212ULL, 0x080fe4000786c0ffULL, 0x00000084c5ff7212ULL, 0x000fc4000782c0ffULL,
0x00000084cbff7212ULL, 0x000fe400078cc0ffULL, 0x00000086b9ff7212ULL, 0x080fe4000780c0ffULL,
0x00000086bfff7212ULL, 0x080fe4000784c0ffULL, 0x00000086c5ff7212ULL, 0x000fe4000788c0ffULL,
0x0000008abfff7212ULL, 0x000fe400078ac0ffULL, 0x00000052b500720cULL, 0x000fc40000701470ULL,
0x00000052bd00720cULL, 0x0c0fe40001f61470ULL, 0x00000052bd00720cULL, 0x0c0fe40001741470ULL,
0x00000052bd00720cULL, 0x080fe40002fa1470ULL, 0x00000052c300720cULL, 0x080fe40000f21470ULL,
0x00000052c900720cULL, 0x080fe400037c1470ULL, 0x00000052c300720cULL, 0x000fc40002781470ULL,
0x00000052b300720cULL, 0x080fe40000701070ULL, 0x00000052bb00720cULL, 0x0c0fe40001f61070ULL,
0x00000052bb00720cULL, 0x0c0fe40001741070ULL, 0x00000052bb00720cULL, 0x080fe40002fa1070ULL,
0x00000052c100720cULL, 0x080fe40000f21070ULL, 0x00000052c700720cULL, 0x000fc400037c1070ULL,
0x00000052c100720cULL, 0x000fe40002781070ULL, 0x00005410d78e7816ULL, 0x000fe4000000008eULL,
0xff8000002a2a7808ULL, 0x000fe40000000000ULL, 0xff80000044447808ULL, 0x000fe40001800000ULL,
0xff8000002b2b7808ULL, 0x000fe40001000000ULL, 0xff80000039397808ULL, 0x000fc40002800000ULL,
0xff80000043437808ULL, 0x000fe40000800000ULL, 0xff80000042427808ULL, 0x000fe40003000000ULL,
0xff8000003d3d7808ULL, 0x000fe40002000000ULL, 0x00000086cbff7212ULL, 0x000fe4000780c0ffULL,
0x0000008ac5ff7212ULL, 0x080fe4000786c0ffULL, 0x0000008acbff7212ULL, 0x000fc4000784c0ffULL,
0x0000008eb9ff7212ULL, 0x080fe400078ac0ffULL, 0x0000008ebfff7212ULL, 0x080fe4000782c0ffULL,
0x0000008ec5ff7212ULL, 0x080fe400078cc0ffULL, 0x0000008ecbff7212ULL, 0x000fe4000788c0ffULL,
0x00000052b500720cULL, 0x080fe40002fa1470ULL, 0x00000052bd00720cULL, 0x000fc40000f21470ULL,
0x00000052c300720cULL, 0x0c0fe40001f61470ULL, 0x00000052c300720cULL, 0x080fe400037c1470ULL,
0x00000052c900720cULL, 0x0c0fe40000701470ULL, 0x00000052c900720cULL, 0x0c0fe40001741470ULL,
0x00000052c900720cULL, 0x080fe40002781470ULL, 0x00000052b300720cULL, 0x000fc40002fa1070ULL,
0x00000052bb00720cULL, 0x080fe40000f21070ULL, 0x00000052c700720cULL, 0x080fe40000701070ULL,
0x00000052c100720cULL, 0x0c0fe40001f61070ULL, 0x00000052c100720cULL, 0x080fe400037c1070ULL,
0x00000052c700720cULL, 0x0c0fe40001741070ULL, 0x00000052c700720cULL, 0x000fc40002781070ULL,
0xff8000003c3c7808ULL, 0x000fe40000000000ULL, 0xff8000003a3a7808ULL, 0x000fe40001800000ULL,
0xff8000003b3b7808ULL, 0x000fe40001000000ULL, 0xff8000000c0c7808ULL, 0x000fe40002800000ULL,
0xff8000000d0d7808ULL, 0x000fe40000800000ULL, 0xff8000000e0e7808ULL, 0x000fc40003000000ULL,
0xff8000000f0f7808ULL, 0x000fc40002000000ULL, 0x000000510400720bULL, 0x004fe20003f1e000ULL,
0x0000001fff5f7424ULL, 0x000fe200078e00ffULL, 0x000000220500720bULL, 0x000fe20003f3e000ULL,
0xffffffffff607424ULL, 0x000fe200078e00ffULL, 0x0000002d0600720bULL, 0x000fe40003f5e000ULL,
0x000000200700720bULL, 0x000fe40003f7e000ULL, 0x0000000451537208ULL, 0x000fe40004000000ULL,
0x0000000522047208ULL, 0x000fc40004800000ULL, 0x000000062d057208ULL, 0x000fe40005000000ULL,
0x0000000720067208ULL, 0x000fe40005800000ULL, 0x0000004a5300720bULL, 0x000fe40003f1e000ULL,
0x000000410400720bULL, 0x000fe40003f3e000ULL, 0x0000002c0500720bULL, 0x000fe40003f5e000ULL,
0x0000001f0600720bULL, 0x000fc40003f7e000ULL, 0x000000534a527208ULL, 0x000fe40004000000ULL,
0x0000000441047208ULL, 0x000fe40004800000ULL, 0x000000052c057208ULL, 0x000fe40005000000ULL,
0x000000061f077208ULL, 0x000fe40005800000ULL, 0x0000004f5200720bULL, 0x000fe40003f1e000ULL,
0x000000230400720bULL, 0x000fc40003f3e000ULL, 0x0000002e0500720bULL, 0x000fe40003f5e000ULL,
0x0000001e0700720bULL, 0x000fe40003f7e000ULL, 0x000000524f527208ULL, 0x000fe40004000000ULL,
0x0000000423047208ULL, 0x000fe40004800000ULL, 0x000000052e067208ULL, 0x000fe40005000000ULL,
0x000000071e587208ULL, 0x000fc40005800000ULL, 0x0000004b5200720bULL, 0x000fe40003f1e000ULL,
0x000000250400720bULL, 0x000fe40003f3e000ULL, 0x0000002f0600720bULL, 0x000fe40003f5e000ULL,
0x0000001d5800720bULL, 0x000fe40003f7e000ULL, 0x000000524b057208ULL, 0x000fe40004000000ULL,
0x0000000425077208ULL, 0x000fc40004800000ULL, 0x000000062f537208ULL, 0x000fe40005000000ULL,
0x000000581d5b7208ULL, 0x000fe40005800000ULL, 0x000000500500720bULL, 0x000fe40003f1e000ULL,
0x000000240700720bULL, 0x000fe40003f3e000ULL, 0x000000305300720bULL, 0x000fe40003f5e000ULL,
0x0000001c5b00720bULL, 0x000fc40003f7e000ULL, 0x0000000550057208ULL, 0x000fe40004000000ULL,
0x0000000724077208ULL, 0x000fe40004800000ULL, 0x0000005330047208ULL, 0x000fe40005000000ULL,
0x0000005b1c067208ULL, 0x000fe40005800000ULL, 0x0000004c0500720bULL, 0x000fe40003f1e000ULL,
0x000000400700720bULL, 0x000fc40003f3e000ULL, 0x000000310400720bULL, 0x000fe40003f5e000ULL,
0x000000130600720bULL, 0x000fe40003f7e000ULL, 0x000000054c527208ULL, 0x000fe40004000000ULL,
0x0000000740077208ULL, 0x000fe40004800000ULL, 0x0000000431057208ULL, 0x000fe40005000000ULL,
0x0000000613067208ULL, 0x000fc40005800000ULL, 0x000000260700720bULL, 0x000fe40003f3e000ULL,
0x000000495200720bULL, 0x000fe40003f1e000ULL, 0x000000320500720bULL, 0x000fe40003f5e000ULL,
0x000000210600720bULL, 0x000fe40003f7e000ULL, 0x0000000726077208ULL, 0x000fe40004800000ULL,
0x0000005249527208ULL, 0x000fc40004000000ULL, 0x0000000532047208ULL, 0x000fe40005000000ULL,
0x0000000621057208ULL, 0x000fe40005800000ULL, 0x000000280700720bULL, 0x000fe40003f3e000ULL,
0x0000004d5200720bULL, 0x000fe40003f1e000ULL, 0x000000330400720bULL, 0x000fe40003f5e000ULL,
0x000000120500720bULL, 0x000fc40003f7e000ULL, 0x0000000728067208ULL, 0x000fe40004800000ULL,
0x000000524d537208ULL, 0x000fe40004000000ULL, 0x0000000433077208ULL, 0x000fe40005000000ULL,
0x0000000512047208ULL, 0x000fe40005800000ULL, 0x0000004e5300720bULL, 0x000fe40003f1e000ULL,
0x000000270600720bULL, 0x000fc40003f3e000ULL, 0x000000340700720bULL, 0x000fe40003f5e000ULL,
0x000000110400720bULL, 0x000fe40003f7e000ULL, 0x000000534e537208ULL, 0x000fe40004000000ULL,
0x0000000627067208ULL, 0x000fe40004800000ULL, 0x0000000734527208ULL, 0x000fe40005000000ULL,
0x0000000411057208ULL, 0x000fc40005800000ULL, 0x000000485300720bULL, 0x000fe40003f1e000ULL,
0x0000003f0600720bULL, 0x000fe40003f3e000ULL, 0x000000355200720bULL, 0x000fe40003f5e000ULL,
0x000000100500720bULL, 0x000fe40003f7e000ULL, 0x0000005348047208ULL, 0x000fe40004000000ULL,
0x000000063f067208ULL, 0x000fc40004800000ULL, 0x0000005235077208ULL, 0x000fe40005000000ULL,
0x0000000510057208ULL, 0x000fe40005800000ULL, 0x000000470400720bULL, 0x000fe40003f1e000ULL,
0x000000290600720bULL, 0x000fe40003f3e000ULL, 0x000000360700720bULL, 0x000fe40003f5e000ULL,
0x0000000a0500720bULL, 0x000fc40003f7e000ULL, 0x0000000447537208ULL, 0x000fe40004000000ULL,
0x00000006295b7208ULL, 0x000fe40004800000ULL, 0x0000000736047208ULL, 0x000fe40005000000ULL,
0x000000050a067208ULL, 0x000fe40005800000ULL, 0x000000465300720bULL, 0x000fe40003f1e000ULL,
0x000000385b00720bULL, 0x000fc40003f3e000ULL, 0x000000370400720bULL, 0x000fe40003f5e000ULL,
0x0000000b0600720bULL, 0x000fe40003f7e000ULL, 0x0000005346527208ULL, 0x000fe40004000000ULL,
0x0000005b385b7208ULL, 0x000fe40004800000ULL, 0x0000000437057208ULL, 0x000fe40005000000ULL,
0x000000060b077208ULL, 0x000fc40005800000ULL, 0x000000455200720bULL, 0x000fe40003f1e000ULL,
0x0000002a5b00720bULL, 0x000fe40003f3e000ULL, 0x0000003e0500720bULL, 0x000fe40003f5e000ULL,
0x0000000c0700720bULL, 0x000fe40003f7e000ULL, 0x0000005245537208ULL, 0x000fe40004000000ULL,
0x0000005b2a047208ULL, 0x000fc40004800000ULL, 0x000000053e067208ULL, 0x000fe40005000000ULL,
0x000000070c527208ULL, 0x000fe40005800000ULL, 0x0000002b0400720bULL, 0x000fe40003f3e000ULL,
0x000000445300720bULL, 0x000fe40003f1e000ULL, 0x000000390600720bULL, 0x000fe40003f5e000ULL,
0x0000000d5200720bULL, 0x000fc40003f7e000ULL, 0x000000042b047208ULL, 0x000fe40004800000ULL,
0x0000005344587208ULL, 0x000fe40004000000ULL, 0x0000000639057208ULL, 0x000fe40005000000ULL,
0x000000520d077208ULL, 0x000fe40005800000ULL, 0x0000003d0400720bULL, 0x000fe40003f3e000ULL,
0x000000435800720bULL, 0x000fc40003f1e000ULL, 0x0000003a0500720bULL, 0x000fe40003f5e000ULL,
0x0000000e0700720bULL, 0x000fe40003f7e000ULL, 0x000000043d5b7208ULL, 0x000fe40004800000ULL,
0x0000005843537208ULL, 0x000fe40004000000ULL, 0x000000053a047208ULL, 0x000fe40005000000ULL,
0x000000070e067208ULL, 0x000fc40005800000ULL, 0x000000425300720bULL, 0x000fe40003f1e000ULL,
0x0000003c5b00720bULL, 0x000fe40003f3e000ULL, 0x0000003b0400720bULL, 0x000fe40003f5e000ULL,
0x0000000f0600720bULL, 0x000fe40003f7e000ULL, 0x0000005342077208ULL, 0x000fe40004000000ULL,
0x0000005b3c587208ULL, 0x000fc40004800000ULL, 0x000000043b5c7208ULL, 0x000fe40005000000ULL,
0x000000060f5d7208ULL, 0x000fe20005800000ULL, 0x00001de27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0007047f89ULL, 0x0004e400000e0000ULL, 0x000000040700720bULL, 0x008fc80003f1e000ULL,
0x00000007045e7208ULL, 0x000fe20004000000ULL, 0x00001df27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0058047f89ULL, 0x000ee800000e0000ULL, 0x0c401f005c057f89ULL, 0x000f2800000e0000ULL,
0x0c401f005d067f89ULL, 0x000e6200000e0000ULL, 0x000000045800720bULL, 0x008fc40003f1e000ULL,
0x000000055c00720bULL, 0x010fe40003f3e000ULL, 0x0000005804077208ULL, 0x006fe40004000000ULL,
0x0000005c05527208ULL, 0x000fe20004800000ULL, 0x0c201f005e047f89ULL, 0x000e6200000e0000ULL,
0x000000065d00720bULL, 0x000fc60003f1e000ULL, 0x0c201f00075a7f89ULL, 0x000ea200000e0000ULL,
0x0000005d06587208ULL, 0x000fc60004000000ULL, 0x0c201f0052537f89ULL, 0x000ee800000e0000ULL,
0x0c201f00585b7f89ULL, 0x0002e400000e0000ULL, 0x000000045e00720bULL, 0x002fe40003f1e000ULL,
0x0000005a0700720bULL, 0x004fe40003f3e000ULL, 0x0000005e04047208ULL, 0x000fc40004000000ULL,
0x000000535200720bULL, 0x008fe40003f5e000ULL, 0x000000075a057208ULL, 0x000fe40004800000ULL,
0x0000005253067208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b04077820ULL, 0x002fe20000410000ULL,
0x0000005b5800720bULL, 0x004fe20003f1e000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000002ff647819ULL, 0x000fe20000011659ULL, 0x3fb8aa3b495a7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b51517823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b4a4a7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b4f4f7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b4b4b7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b50507823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b4c4c7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b4d4d7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b4e497823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b48487823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b47477823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b46467823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b45457823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b44447823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b43437823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b42427823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b05077820ULL, 0x000fe20000410000ULL,
0x0000004b00527308ULL, 0x000fe20000000800ULL, 0x00000008646f7824ULL, 0x000fc400078e00ffULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b41417823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b23237823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b25257823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b24247823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b40407823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b3f3f7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b38387823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b3d3d7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b3c077823ULL, 0x000fe20000010807ULL,
0x00000024004b7308ULL, 0x0003e20000000800ULL, 0x0000000864677824ULL, 0x000fce00078e00ffULL,
0x00000007003c7308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b06247820ULL, 0x002fc80000410000ULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe20000010824ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe20000010824ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe20000010824ULL, 0x00000029005e7308ULL, 0x0003e20000000800ULL,
0x000000585b077208ULL, 0x004fe20004000000ULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe20000010824ULL,
0x3fb8aa3b30307823ULL, 0x100fe20000010824ULL, 0x3fb8aa3b32327823ULL, 0x100fe20000010824ULL,
0x3fb8aa3b39397823ULL, 0x100fe20000010824ULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe20000010824ULL,
0x3fb8aa3b31317823ULL, 0x100fe20000010824ULL, 0x0000004c00537308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b07297820ULL, 0x002fe20000410000ULL, 0x3fb8aa3b33337823ULL, 0x100fe20000010824ULL,
0x3fb8aa3b34347823ULL, 0x100fe20000010824ULL, 0x3fb8aa3b35357823ULL, 0x100fe20000010824ULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010829ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010829ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010829ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe20000010829ULL,
0x00000028005d7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe20000010829ULL,
0x3fb8aa3b13137823ULL, 0x100fe20000010829ULL, 0x3fb8aa3b36367823ULL, 0x100fe20000010824ULL,
0x3fb8aa3b37377823ULL, 0x100fe20000010824ULL, 0x3fb8aa3b3e3e7823ULL, 0x100fe20000010824ULL,
0x3fb8aa3b3b247823ULL, 0x000fe20000010824ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010829ULL,
0x0000002a00607308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b12127823ULL, 0x100fe20000010829ULL,
0x3fb8aa3b11117823ULL, 0x100fe20000010829ULL, 0x3fb8aa3b0a0a7823ULL, 0x100fe20000010829ULL,
0x3fb8aa3b0b0b7823ULL, 0x000fe20000010829ULL, 0x0000000359ff7812ULL, 0x000fc6000780c0ffULL,
0x0000005100517308ULL, 0x000ff00000000800ULL, 0x0000004a004a7308ULL, 0x000ff00000000800ULL,
0x0000004f004f7308ULL, 0x000e700000000800ULL, 0x0000002200227308ULL, 0x000ff00000000800ULL,
0x0000004100417308ULL, 0x000eb00000000800ULL, 0x0000002300237308ULL, 0x000ff00000000800ULL,
0x00000025004c7308ULL, 0x0007f00000000800ULL, 0x0000002b00617308ULL, 0x000fe20000000800ULL,
0x0000000264257810ULL, 0x008fce0007ffe0ffULL, 0x0000003000287308ULL, 0x000ff00000000800ULL,
0x00000032002a7308ULL, 0x000ff00000000800ULL, 0x0000003900657308ULL, 0x000ff00000000800ULL,
0x0000002d002d7308ULL, 0x000ff00000000800ULL, 0x0000002c002c7308ULL, 0x000ff00000000800ULL,
0x0000002e002e7308ULL, 0x000ff00000000800ULL, 0x0000002f002f7308ULL, 0x000ef00000000800ULL,
0x00000020002b7308ULL, 0x0009f00000000800ULL, 0x0000001f00307308ULL, 0x0003e20000000800ULL,
0x0000000864207824ULL, 0x010fca00078e00ffULL, 0xfffffff820697812ULL, 0x000fe400078ee225ULL,
0x0000001e00327308ULL, 0x0009e20000000800ULL, 0x00000003641f7810ULL, 0x002fce0007ffe0ffULL,
0x0000001d00397308ULL, 0x0002e20000000800ULL, 0x00000005641e7810ULL, 0x010fc80007ffe0ffULL,
0xfffffff86f6f7812ULL, 0x000fe400078ee21eULL, 0x0000004f521e723eULL, 0x000fe200000000ffULL,
0x00000026004e7308ULL, 0x0008e20000000800ULL, 0x00000004641d7810ULL, 0x002fe20007ffe0ffULL,
0x3fb8aa3b0e4f7823ULL, 0x000fc60000010829ULL, 0xfffffff8206d7812ULL, 0x000fe400078ee21dULL,
0x00000022411d723eULL, 0x004fe200000000ffULL, 0x0000003a00627308ULL, 0x000fe20000000800ULL,
0x0000000864267824ULL, 0x010fe200078e00ffULL, 0x0000002e2f22723eULL, 0x008fc800000000ffULL,
0xfffffff8266b7812ULL, 0x000fe400078ee21fULL, 0x0000001c003a7308ULL, 0x0003e20000000800ULL,
0x00000006641f7810ULL, 0x000fce0007ffe0ffULL, 0x00000013003b7308ULL, 0x0005e20000000800ULL,
0x00000008641c7824ULL, 0x002fca00078e00ffULL, 0xfffffff81c717812ULL, 0x000fe400078ee21fULL,
0x00000038005f7308ULL, 0x000e620000000800ULL, 0xffffffff64137810ULL, 0x004fe40007ffe0ffULL,
0x000000514a1c723eULL, 0x000fe200000000ffULL, 0x3fb8aa3b0f517823ULL, 0x100fe20000010829ULL,
0x000000234c1f723eULL, 0x000fe200000000ffULL, 0x3fb8aa3b0d4c7823ULL, 0x000fe20000010829ULL,
0xfffffff820737812ULL, 0x000fe200078ee213ULL, 0x0000003400387308ULL, 0x0005e20000000800ULL,
0x0000002d2c20723eULL, 0x000fc400000000ffULL, 0x000000323923723eULL, 0x000fe200000000ffULL,
0x3fb8aa3b0c327823ULL, 0x000fe20000010829ULL, 0x0000004e5d0f723eULL, 0x000fe400000000ffULL,
0x00000018645d7810ULL, 0x000fe20007ffe0ffULL, 0x0000003500637308ULL, 0x0007220000000800ULL,
0x3c003c00ff347424ULL, 0x004fe200078e00ffULL, 0x0000005e5f2f723eULL, 0x002fcc00000000ffULL,
0x0000002100587308ULL, 0x0003e20000000800ULL, 0x3c003c00ff357424ULL, 0x008fce00078e00ffULL,
0x00000024005b7308ULL, 0x0004e20000000800ULL, 0x0000002b3021723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b102b7823ULL, 0x000fe20000010829ULL, 0x0000003a3b29723eULL, 0x000fe200000000ffULL,
0x000000085d307824ULL, 0x000fe200078e00ffULL, 0x000000386338723eULL, 0x010fc600000000ffULL,
0x00000027005c7308ULL, 0x0003e20000000800ULL, 0x0000000164247810ULL, 0x004fe40007ffe0ffULL,
0xfffffff8305d7812ULL, 0x000fe400078ee25dULL, 0xfffffff867677812ULL, 0x000fc600078ee224ULL,
0x0000001200417308ULL, 0x000fe20000000800ULL, 0x000000341c24723cULL, 0x002f6200000018ffULL,
0x000000625b4e723eULL, 0x008fcc00000000ffULL, 0x00000011004a7308ULL, 0x0003f00000000800ULL,
0x0000005000507308ULL, 0x000ea20000000800ULL, 0x000000342010723cULL, 0x002f6e00000018ffULL,
0x0000005a005a7308ULL, 0x000ff00000000800ULL, 0x0000004d004d7308ULL, 0x000e620000000800ULL,
0x00000050530c723eULL, 0x004fc400000000ffULL, 0x0000001064537810ULL, 0x000fca0007ffe0ffULL,
0x0000004000407308ULL, 0x000ea20000000800ULL, 0x00000008532e7824ULL, 0x000fca00078e00ffULL,
0xfffffff82e537812ULL, 0x000fe400078ee253ULL, 0x0000003100317308ULL, 0x000ee20000000800ULL,
0x0000005a4d0e723eULL, 0x002fe400000000ffULL, 0x00000008644d7810ULL, 0x000fca0007ffe0ffULL,
0x0000003300337308ULL, 0x000e620000000800ULL, 0x0000004b400d723eULL, 0x004fe200000000ffULL,
0x000000084d2c7824ULL, 0x000fe400078e00ffULL, 0x00000008644b7824ULL, 0x000fc600078e00ffULL,
0xfffffff82c4d7812ULL, 0x000fe200078ee24dULL, 0x0000002b00397308ULL, 0x0005220000000800ULL,
0x000000283128723eULL, 0x008fe200000000ffULL, 0x000000340c24723cULL, 0x020f620000001824ULL,
0xfffffff84b4b7812ULL, 0x000fe400078ee264ULL, 0x000000606131723eULL, 0x000fe400000000ffULL,
0x0000002a332a723eULL, 0x002fe200000000ffULL, 0x0000004900497308ULL, 0x000fe20000000800ULL,
0x00000058412b723eULL, 0x004fc400000000ffULL, 0x0000004a3939723eULL, 0x010fca00000000ffULL,
0x0000004800487308ULL, 0x000e620000000800ULL, 0x000000342810723cULL, 0x000f6e0000001810ULL,
0x0000004700477308ULL, 0x000ff00000000800ULL, 0x0000004600467308ULL, 0x000ea20000000800ULL,
0x00000049482c723eULL, 0x002fce00000000ffULL, 0x0000003f003f7308ULL, 0x000e700000000800ULL,
0x0000003600367308ULL, 0x000fe20000000800ULL, 0x00000047462e723eULL, 0x004fce00000000ffULL,
0x0000003700377308ULL, 0x000ea20000000800ULL, 0x0000005c3f2d723eULL, 0x002fce00000000ffULL,
0x0000000a000a7308ULL, 0x000fe20000000800ULL, 0x000000342c24723cULL, 0x020f6e0000001824ULL,
0x0000000b000b7308ULL, 0x000e620000000800ULL, 0x00000036373a723eULL, 0x004fe400000000ffULL,
0x0000a0001a367811ULL, 0x000fca00078e60ffULL, 0x0000003d003d7308ULL, 0x000ea20000000800ULL,
0x000000104b4b7824ULL, 0x100fe400078e0236ULL, 0x0000001067677824ULL, 0x100fe400078e0236ULL,
0x0000001069697824ULL, 0x100fe400078e0236ULL, 0x000000106b6b7824ULL, 0x100fe200078e0236ULL,
0x0000000a0b3b723eULL, 0x002fe200000000ffULL, 0x0000004500457308ULL, 0x000fe20000000800ULL,
0x000000106d6d7824ULL, 0x000fc400078e0236ULL, 0x000000106f6f7824ULL, 0x100fe400078e0236ULL,
0x0000001071717824ULL, 0x100fe200078e0236ULL, 0x000000343810723cULL, 0x000fe20000001810ULL,
0x0000003d3c33723eULL, 0x004fe200000000ffULL, 0x0000004400447308ULL, 0x000e620000000800ULL,
0x0000000c093c7812ULL, 0x000fe200078ec0ffULL, 0x000000104d097824ULL, 0x100fe400078e0236ULL,
0x0000001073737824ULL, 0x000fe400078e0236ULL, 0x000000014b4b7824ULL, 0x000fc400078e023cULL,
0x0000004300437308ULL, 0x000fe20000000800ULL, 0x000000013c677824ULL, 0x040fe400078e0267ULL,
0x000000013c697824ULL, 0x040fe200078e0269ULL, 0x0000001c4b007388ULL, 0x0005e20000000800ULL,
0x000000013c6b7824ULL, 0x040fe400078e026bULL, 0x000000013c6d7824ULL, 0x000fe200078e026dULL,
0x0000004200427308ULL, 0x000ee20000000800ULL, 0x000000454430723eULL, 0x002fe200000000ffULL,
0x000000013c6f7824ULL, 0x040fe200078e026fULL, 0x0000001e67007388ULL, 0x0005e20000000800ULL,
0x000000013c717824ULL, 0x000fc400078e0271ULL, 0x000000013c737824ULL, 0x040fe200078e0273ULL,
0x0000000c69007388ULL, 0x0005e20000000800ULL, 0x0000003e003e7308ULL, 0x000e620000000800ULL,
0x0000001053537824ULL, 0x100fe400078e0236ULL, 0x0000000e6b007388ULL, 0x0005e20000000800ULL,
0x000000105d5d7824ULL, 0x000fe400078e0236ULL, 0x000000013c537824ULL, 0x000fe200078e0253ULL,
0x0000002c6d007388ULL, 0x0005e20000000800ULL, 0x0000003200407308ULL, 0x0007e60000000800ULL,
0x0000002e6f007388ULL, 0x0005e80000000800ULL, 0x0000003071007388ULL, 0x0005e20000000800ULL,
0x0000004c00417308ULL, 0x0003220000000800ULL, 0x000000434232723eULL, 0x008fca00000000ffULL,
0x0000003273007388ULL, 0x0005e40000000800ULL, 0x0000004f004f7308ULL, 0x000fe20000000800ULL,
0x0000003e654c723eULL, 0x002fe200000000ffULL, 0x000000343024723cULL, 0x020f6c0000001824ULL,
0x00000051000a7308ULL, 0x000e620000000800ULL, 0x00000040414d723eULL, 0x010fc400000000ffULL,
0x0000004f0a4f723eULL, 0x002fe200000000ffULL, 0x000000013c0a7824ULL, 0x040fe400078e0209ULL,
0x000000013c3c7824ULL, 0x000fd800078e025dULL, 0x000000ffff257224ULL, 0x020fe200078e0026ULL,
0x0000001d0a007388ULL, 0x0005e20000000800ULL, 0x000000344c10723cULL, 0x000f660000001810ULL,
0x0004001f67007388ULL, 0x0005e80000000800ULL, 0x0004000d69007388ULL, 0x0005e80000000800ULL,
0x0004000f6b007388ULL, 0x0005e80000000800ULL, 0x0004002d6d007388ULL, 0x0005e80000000800ULL,
0x0004002f6f007388ULL, 0x0005e80000000800ULL, 0x0004003171007388ULL, 0x0005e20000000800ULL,
0x000000ffff267224ULL, 0x020fc400078e0010ULL, 0x000000ffff277224ULL, 0x000fe200078e0012ULL,
0x0004003373007388ULL, 0x0005e80000000800ULL, 0x0000002053007388ULL, 0x0005e80000000800ULL,
0x0008002267007388ULL, 0x0005e80000000800ULL, 0x0008002869007388ULL, 0x0005e80000000800ULL,
0x0008002a6b007388ULL, 0x0005e80000000800ULL, 0x000800386d007388ULL, 0x0005e80000000800ULL,
0x0008003a6f007388ULL, 0x0005e80000000800ULL, 0x0008004c71007388ULL, 0x0005e80000000800ULL,
0x0008004e73007388ULL, 0x0005e80000000800ULL, 0x000000213c007388ULL, 0x0005e80000000800ULL,
0x000c002367007388ULL, 0x0005e80000000800ULL, 0x000c002969007388ULL, 0x0005e80000000800ULL,
0x000c002b6b007388ULL, 0x0005e80000000800ULL, 0x000c00396d007388ULL, 0x0005e80000000800ULL,
0x000c003b6f007388ULL, 0x0005e80000000800ULL, 0x000c004d71007388ULL, 0x0005e80000000800ULL,
0x000c004f73007388ULL, 0x0005e80000000800ULL, 0x0120000408008388ULL, 0x0005e80000000c00ULL,
0x0122002408008388ULL, 0x0005e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000055ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000080055ff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000100055ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000154547810ULL, 0x000fe20007ffe0ffULL, 0x0000180055ff7f8cULL, 0x0003e6000c80043fULL,
0x000000155400720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffff98a000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff257807ULL, 0x008fe40004000000ULL, 0x0001603000267802ULL, 0x000fc40000000f00ULL,
0x00000e8000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff007224ULL, 0x000fe200078e0025ULL,
0xfffec69000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x000fe40005800000ULL,
0x0001608000267802ULL, 0x000fc40000000f00ULL, 0x00000e3000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff1d7224ULL, 0x000fe200078e0025ULL, 0xfffec6f000007947ULL, 0x000fea000383ffffULL,
0x000160c000257802ULL, 0x000fc40000000f00ULL, 0x00000da000007944ULL, 0x002fea0003c00000ULL,
0xfffec7d000007947ULL, 0x000fea000383ffffULL, 0x000160f000257802ULL, 0x000fc40000000f00ULL,
0x00000d7000007944ULL, 0x002fea0003c00000ULL, 0xfffec91000007947ULL, 0x000fea000383ffffULL,
0x0001612000257802ULL, 0x000fc40000000f00ULL, 0x00000d4000007944ULL, 0x002fea0003c00000ULL,
0xfffeca5000007947ULL, 0x000fea000383ffffULL, 0x0001615000257802ULL, 0x000fc40000000f00ULL,
0x00000d1000007944ULL, 0x002fea0003c00000ULL, 0xfffecb8000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0002ULL, 0x0001619000257802ULL, 0x000fc40000000f00ULL,
0x00000cd000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e0026ULL,
0xfffecfb000007947ULL, 0x000fea000383ffffULL, 0x000161d000257802ULL, 0x000fc40000000f00ULL,
0x00000c9000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e0026ULL,
0x0000001002267810ULL, 0x000fe40007ffe0ffULL, 0x0001621000257802ULL, 0x000fc40000000f00ULL,
0x00000c5000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff057224ULL, 0x004fe200078e0026ULL,
0xfffecf8000007947ULL, 0x000fea000383ffffULL, 0x0001625000257802ULL, 0x000fc40000000f00ULL,
0x00000c1000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0026ULL,
0xfffecf7000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x008fe40004000000ULL,
0x000162a000267802ULL, 0x000fc40000000f00ULL, 0x00000c1000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff1f7224ULL, 0x000fe200078e0025ULL, 0xfffef08000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x000fe40005800000ULL, 0x000162f000267802ULL, 0x000fc40000000f00ULL,
0x00000bc000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff707224ULL, 0x000fe200078e0025ULL,
0xfffef0d000007947ULL, 0x000fea000383ffffULL, 0x0001633000257802ULL, 0x000fc40000000f00ULL,
0x00000b3000007944ULL, 0x004fea0003c00000ULL, 0xfffef1b000007947ULL, 0x000fea000383ffffULL,
0x0001636000257802ULL, 0x000fc40000000f00ULL, 0x00000b0000007944ULL, 0x006fea0003c00000ULL,
0xfffef2f000007947ULL, 0x000fea000383ffffULL, 0x0001639000257802ULL, 0x000fc40000000f00ULL,
0x00000ad000007944ULL, 0x00efea0003c00000ULL, 0xfffef43000007947ULL, 0x000fea000383ffffULL,
0x000163c000257802ULL, 0x000fc40000000f00ULL, 0x00000aa000007944ULL, 0x00efea0003c00000ULL,
0xfffef56000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e001eULL,
0x0001640000257802ULL, 0x000fc40000000f00ULL, 0x00000a6000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e0026ULL, 0xfffef98000007947ULL, 0x000fea000383ffffULL,
0x0001644000257802ULL, 0x000fc40000000f00ULL, 0x00000a2000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e0026ULL, 0x000000101e267810ULL, 0x000fc40007ffe0ffULL,
0x0001648000257802ULL, 0x000fc40000000f00ULL, 0x000009e000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff057224ULL, 0x004fe200078e0026ULL, 0xfffef95000007947ULL, 0x000fea000383ffffULL,
0x000164c000257802ULL, 0x000fc40000000f00ULL, 0x000009a000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0026ULL, 0xfffef94000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x008fe40004000000ULL, 0x0001651000267802ULL, 0x000fc40000000f00ULL,
0x000009a000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff727224ULL, 0x000fe200078e0025ULL,
0xffff19c000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x000fe40005800000ULL,
0x0001656000267802ULL, 0x000fc40000000f00ULL, 0x0000095000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff237224ULL, 0x000fe200078e0025ULL, 0xffff1a1000007947ULL, 0x000fea000383ffffULL,
0x000165a000257802ULL, 0x000fc40000000f00ULL, 0x000008c000007944ULL, 0x002fea0003c00000ULL,
0xffff1af000007947ULL, 0x000fea000383ffffULL, 0x000165d000257802ULL, 0x000fc40000000f00ULL,
0x0000089000007944ULL, 0x002fea0003c00000ULL, 0xffff1c3000007947ULL, 0x000fea000383ffffULL,
0x0001660000257802ULL, 0x000fc40000000f00ULL, 0x0000086000007944ULL, 0x002fea0003c00000ULL,
0xffff1d7000007947ULL, 0x000fea000383ffffULL, 0x0001663000257802ULL, 0x000fc40000000f00ULL,
0x0000083000007944ULL, 0x002fea0003c00000ULL, 0xffff1ea000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0024ULL, 0x0001667000257802ULL, 0x000fc40000000f00ULL,
0x000007f000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e0026ULL,
0xffff22c000007947ULL, 0x000fea000383ffffULL, 0x000166b000257802ULL, 0x000fc40000000f00ULL,
0x000007b000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e0026ULL,
0x0000001024267810ULL, 0x000fc40007ffe0ffULL, 0x000166f000257802ULL, 0x000fc40000000f00ULL,
0x0000077000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff057224ULL, 0x004fe200078e0026ULL,
0xffff229000007947ULL, 0x000fea000383ffffULL, 0x0001673000257802ULL, 0x000fc40000000f00ULL,
0x0000073000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0026ULL,
0xffff228000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x008fe40004000000ULL,
0x0001678000267802ULL, 0x000fc40000000f00ULL, 0x0000073000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff217224ULL, 0x000fe200078e0025ULL, 0xffff41a000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x000fe40005800000ULL, 0x000167d000267802ULL, 0x000fc40000000f00ULL,
0x000006e000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff6c7224ULL, 0x000fe200078e0025ULL,
0xffff41f000007947ULL, 0x000fea000383ffffULL, 0x0001681000257802ULL, 0x000fc40000000f00ULL,
0x0000065000007944ULL, 0x000fea0003c00000ULL, 0xffff42d000007947ULL, 0x000fea000383ffffULL,
0x0001684000257802ULL, 0x000fc40000000f00ULL, 0x0000062000007944ULL, 0x002fea0003c00000ULL,
0xffff441000007947ULL, 0x000fea000383ffffULL, 0x0001687000257802ULL, 0x000fc40000000f00ULL,
0x000005f000007944ULL, 0x002fea0003c00000ULL, 0xffff455000007947ULL, 0x000fea000383ffffULL,
0x000168a000257802ULL, 0x000fc40000000f00ULL, 0x000005c000007944ULL, 0x002fea0003c00000ULL,
0xffff468000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e000aULL,
0x000168e000257802ULL, 0x000fc40000000f00ULL, 0x0000058000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e0026ULL, 0xffff4a9000007947ULL, 0x000fea000383ffffULL,
0x0001692000257802ULL, 0x000fc40000000f00ULL, 0x0000054000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e0026ULL, 0x000000100a267810ULL, 0x000fc40007ffe0ffULL,
0x0001696000257802ULL, 0x000fc40000000f00ULL, 0x0000050000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff057224ULL, 0x004fe200078e0026ULL, 0xffff4a6000007947ULL, 0x000fea000383ffffULL,
0x000169a000257802ULL, 0x000fc40000000f00ULL, 0x000004c000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0026ULL, 0xffff4a5000007947ULL, 0x000fea000383ffffULL,
0x00000002ff5a7424ULL, 0x000fe200078e00ffULL, 0x000169f000527802ULL, 0x000fc40000000f00ULL,
0x0000043000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e005bULL,
0xffffe1e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff077224ULL, 0x006fe200078e0058ULL,
0x00016a5000527802ULL, 0x000fe20000000f00ULL, 0x00000002ff5a7424ULL, 0x000fc400078e00ffULL,
0x000003d000007944ULL, 0x000fea0003c00000ULL, 0x0000005b5800720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e005cULL, 0x00016ab000527802ULL, 0x000fe20000000f00ULL,
0x00000002ff5a7424ULL, 0x000fe200078e00ffULL, 0x000000585b067208ULL, 0x000fc80004000000ULL,
0x0000037000007944ULL, 0x000fea0003c00000ULL, 0x0000005b5c00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e005dULL, 0x00016b1000527802ULL, 0x000fe20000000f00ULL,
0x00000002ff5a7424ULL, 0x000fe200078e00ffULL, 0x0000005c5b5c7208ULL, 0x000fc80004000000ULL,
0x0000031000007944ULL, 0x000fea0003c00000ULL, 0x0000005b5d00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e005eULL, 0x00016b7000527802ULL, 0x000fe20000000f00ULL,
0x00000001ff5a7424ULL, 0x000fe200078e00ffULL, 0x0000005d5b587208ULL, 0x000fc80004000000ULL,
0x000002b000007944ULL, 0x000fea0003c00000ULL, 0x0000005b5e00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0006ULL, 0x00016bd000527802ULL, 0x000fe20000000f00ULL,
0x00000001ff5a7424ULL, 0x000fe200078e00ffULL, 0x0000005e5b047208ULL, 0x000fc80004000000ULL,
0x0000025000007944ULL, 0x000fea0003c00000ULL, 0x0000005b0600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e005cULL, 0x00016c3000527802ULL, 0x000fe20000000f00ULL,
0x00000001ff5a7424ULL, 0x000fe200078e00ffULL, 0x000000065b057208ULL, 0x000fc80004000000ULL,
0x000001f000007944ULL, 0x000fea0003c00000ULL, 0x0000005b5c00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0058ULL, 0x00016c9000527802ULL, 0x000fe20000000f00ULL,
0x00000001ff5a7424ULL, 0x000fe200078e00ffULL, 0x0000005c5b067208ULL, 0x000fc80004000000ULL,
0x0000019000007944ULL, 0x000fea0003c00000ULL, 0xffffe0b000007947ULL, 0x000fea000383ffffULL,
0x0180000022007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000027812ULL, 0x000fc800078ec0ffULL, 0x018000000200780cULL, 0x000fda0003f05070ULL,
0x0000002200008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x040fe40003f25070ULL, 0x008000000200780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff22ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000022027812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000002200007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e0004ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffe91e002007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff537424ULL, 0x000fe200078e00ffULL, 0x0000006000007348ULL, 0x000fe80003800000ULL,
0x0c00005a075b7389ULL, 0x0002a200000e005fULL, 0xfffe91a052007950ULL, 0x000fea0003c3ffffULL,
0x000000ffff6a7224ULL, 0x000fe200078e0025ULL, 0x0000007400007348ULL, 0x000fe80003800000ULL,
0x00000000ff6b7424ULL, 0x000fe200078e00ffULL, 0x0000002627267389ULL, 0x0002a600000e0077ULL,
0xfffe91506a007950ULL, 0x000fea0003c3ffffULL, 0x000000012500780cULL, 0x000fe20003f65070ULL,
0x00000000ff277424ULL, 0x000fe200078e00ffULL, 0x0000006f00007348ULL, 0x000ff60003800000ULL,
0x0000000000257806ULL, 0x000fc800058e0100ULL, 0x0000006f25257212ULL, 0x000fe200078ec0ffULL,
0xfffe90f026007950ULL, 0x000fec0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000002000000008ULL, 0x0000000400000001ULL, 0x0000001000000004ULL, 0x0000000800000001ULL,
0x0000000200000001ULL, 0x0000000100000008ULL, 0x0000000400000003ULL, 0x0000000300000004ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x0000000000000560ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000006c0ULL,
0x0000000000000270ULL, 0x0000001900000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000930ULL,
0x0000000000000340ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c70ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000d30ULL,
0x000000000000089cULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000015d0ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000015e0ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001670ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001674ULL,
0x00000000000001b8ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001880ULL,
0x0000000000017000ULL, 0xda00001900000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000018880ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x00000000000188c0ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x0000000000018c40ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001670ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000017210ULL,
0x0000000000017210ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000018880ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000018c40ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_nqpkv_0_m_32_sm_89_cubin_len = 101664;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
