/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_nqpkv_0_m_32_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000017c28ULL, 0x00000000000178a8ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x65722e0000000000ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x72655073776f7200ULL, 0x6e2e006b636f6c42ULL,
0x6174736e6f632e76ULL, 0x000000000033746eULL, 0x657a69536d656d73ULL, 0x7563344e5a5a5f00ULL,
0x5f33647473336164ULL, 0x7465645f5f38345fULL, 0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL,
0x75635f726564726fULL, 0x5f37456969456164ULL, 0x5f006d726f66785fULL, 0x727241374b4e5a5aULL,
0x6a4c664944327961ULL, 0x324545326a4c4532ULL, 0x454530624c497461ULL, 0x31456a6a664b5245ULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL,
0x6a4c45326a4c6649ULL, 0x4c45326a4c454532ULL, 0x497461324545386aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3053ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x5f5f374944327961ULL, 0x346a4c32666c6168ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL,
0x456a6a5f30534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL,
0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL, 0x497461324545386aULL,
0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x316a4c4532336a4cULL,
0x4c49746132454536ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x45386a4c4534366aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL,
0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4532ULL, 0x454530624c497461ULL,
0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL,
0x4944327961727241ULL, 0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL, 0x45326a4c4545316aULL,
0x7461324545316a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL,
0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x4939494432796172ULL, 0x74614d6e4974736eULL,
0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL, 0x534b524545453062ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x736e493949443279ULL, 0x4c4974614d6e4974ULL, 0x4545326a4c45326aULL, 0x45316a4c45346a4cULL,
0x30624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL,
0x324545386a4c4532ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x0000000000000067ULL, 0x0000000000000000ULL, 0x2400000000000000ULL,
0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL, 0x6e725f7063725f30ULL,
0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x742e6c65722e0068ULL, 0x6e72656b2e747865ULL,
0x2e0061686d5f6c65ULL, 0x7865742e616c6572ULL, 0x6c656e72656b2e74ULL, 0x656b240061686d5fULL,
0x61686d5f6c656e72ULL, 0x7479426d656d7324ULL, 0x65642e0066754265ULL, 0x6d6172665f677562ULL,
0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL, 0x665f67756265642eULL,
0x766e2e00656d6172ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL, 0x00000061686d5f6cULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b000100000096ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b5ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b0001000000beULL, 0x0000000000000030ULL,
0x0000000000000010ULL, 0x000b0001000000fcULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000b000100000135ULL, 0x0000000000000020ULL, 0x0000000000000004ULL, 0x000b00010000017cULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000b0001000001beULL, 0x000000000000002cULL,
0x0000000000000004ULL, 0x000b000100000204ULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000b00010000024bULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000b000100000291ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b0001000002dfULL, 0x0000000000000028ULL,
0x0000000000000004ULL, 0x000b00010000032dULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000b00010000037bULL, 0x000000000000001cULL, 0x0000000000000004ULL, 0x000b0001000003c9ULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000a002200000424ULL, 0x0000000000016230ULL, 0x0000000000000250ULL,
0x000400030000049aULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a101200000040ULL,
0x0000000000000000ULL, 0x0000000000016480ULL, 0x000d0003000004caULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000024ffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0001623000000000ULL, 0x00010c0400000000ULL,
0x0000288080810c00ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880808492ULL, 0x0000002cffffffffULL, 0x0000006000000000ULL,
0x0001623000000000ULL, 0x0000025000000000ULL, 0x0000580400000000ULL, 0x8082288080840900ULL,
0x0000000000002880ULL, 0x0000001500082f04ULL, 0x00082304000000b9ULL, 0x0000000000000013ULL,
0x0000001300081204ULL, 0x0008110400000000ULL, 0x0000000000000013ULL, 0x0000001500082304ULL,
0x0008120400000000ULL, 0x0000000000000015ULL, 0x0000001500081104ULL, 0x0004370400000000ULL,
0x000c17040000007bULL, 0x0050000900000000ULL, 0x000c17040021f000ULL, 0x0048000800000000ULL,
0x000c17040021f000ULL, 0x0040000700000000ULL, 0x000c17040011f000ULL, 0x0028000600000000ULL,
0x000c17040061f000ULL, 0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL,
0x000c17040021f000ULL, 0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL,
0x000c17040011f000ULL, 0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL,
0x00ff1b030011f000ULL, 0xffffffff00dc2904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x000001c000dc2804ULL, 0x0000096000000260ULL, 0x000029d000002960ULL,
0x00002be000002ab0ULL, 0x00002e5000002d10ULL, 0x000033e0000033d0ULL, 0x00003400000033f0ULL,
0x000051a000005130ULL, 0x000053c000005290ULL, 0x00005630000054f0ULL, 0x00005b0000005af0ULL,
0x00005b2000005b10ULL, 0x00007940000078d0ULL, 0x00007b6000007a30ULL, 0x00007dd000007c90ULL,
0x000082b0000082a0ULL, 0x000082d0000082c0ULL, 0x00009f5000009ee0ULL, 0x0000a1700000a040ULL,
0x0000a3e00000a2a0ULL, 0x0000a8f00000a8e0ULL, 0x0000a9100000a900ULL, 0x0000bb700000bb60ULL,
0x0000bb900000bb80ULL, 0x00014af000014a40ULL, 0x00014ed000014db0ULL, 0x000153b0000152b0ULL,
0x0001571000015650ULL, 0x0000048004303904ULL, 0x0001a600000000ffULL, 0x0000056000040100ULL,
0x0001a60800000007ULL, 0x00000670003f0100ULL, 0x0001a68800000007ULL, 0x00000790003f0100ULL,
0x0001a6a800000003ULL, 0x000008a0003f0100ULL, 0x0001a6c800000002ULL, 0x00000fe0003f0100ULL,
0x0001a60000000009ULL, 0x00001100003f0107ULL, 0x0001a68800000000ULL, 0x00001a50003f0101ULL,
0x00000000000000ffULL, 0x00001ad000040107ULL, 0x00000000000000ffULL, 0x00001b5000040101ULL,
0x0000002000000003ULL, 0x00001c70003f0101ULL, 0x0001a6c800000038ULL, 0x00001df0003f0109ULL,
0x0001a6c800000038ULL, 0x00002650003f0109ULL, 0x0001a6b00000003aULL, 0x000026b0003f0107ULL,
0x0001a6b00000003aULL, 0x000026c0003f0101ULL, 0x0001a60800000038ULL, 0x00002700003f0101ULL,
0x0001a60800000075ULL, 0x00002870003f0109ULL, 0x0001a60800000075ULL, 0x00002fe0003f0109ULL,
0x0001a6a80000003aULL, 0x00003170003f0109ULL, 0x0001a6a80000003aULL, 0x00004520003f0109ULL,
0x0001a6c800000035ULL, 0x00004550003f0101ULL, 0x0001a68800000036ULL, 0x000045a0003f0101ULL,
0x0000000000000006ULL, 0x00004710003f0109ULL, 0x0000000000000006ULL, 0x00004e60003f0109ULL,
0x00000000000000ffULL, 0x00004ea000050107ULL, 0x00000000000000ffULL, 0x00004eb000050101ULL,
0x0001a62800000075ULL, 0x00004f10003f0101ULL, 0x0001a6280000004dULL, 0x00005080003f0109ULL,
0x0001a6280000004dULL, 0x000057f0003f0109ULL, 0x0001a6b000000037ULL, 0x00005960003f0109ULL,
0x0001a6b000000037ULL, 0x00006c70003f0109ULL, 0x0001a6c800000034ULL, 0x00006c90003f0101ULL,
0x0001a69000000080ULL, 0x00006cf0003f0101ULL, 0x0000000000000006ULL, 0x00006e60003f0109ULL,
0x0000000000000006ULL, 0x000075e0003f0109ULL, 0x00000008000000ffULL, 0x0000764000040107ULL,
0x0000000800000084ULL, 0x00007650003f0101ULL, 0x0001a64800000075ULL, 0x000076c0003f0101ULL,
0x0001a6480000004dULL, 0x00007830003f0109ULL, 0x0001a6480000004dULL, 0x00007f90003f0109ULL,
0x00000000000000ffULL, 0x0000810000050109ULL, 0x00000000000000ffULL, 0x000092d000050109ULL,
0x0001a6c800000034ULL, 0x000092f0003f0101ULL, 0x0001a69800000036ULL, 0x00009350003f0101ULL,
0x0000000000000006ULL, 0x000094c0003f0109ULL, 0x0000000000000006ULL, 0x00009c60003f0109ULL,
0x00000000000000ffULL, 0x00009ca000040107ULL, 0x00000000000000ffULL, 0x00009cb000050101ULL,
0x0001a66800000008ULL, 0x00009cd0003f0101ULL, 0x0001a66800000008ULL, 0x00009e40003f0109ULL,
0x0001a66800000008ULL, 0x0000a590003f0109ULL, 0x0001a6b000000037ULL, 0x0000a700003f0109ULL,
0x0001a6b000000037ULL, 0x0000b980003f0109ULL, 0x0000000000000006ULL, 0x0000b9c0003f0101ULL,
0x0001a6a000000006ULL, 0x0000d690003f0101ULL, 0x0001a60000000009ULL, 0x0000eec0003f0101ULL,
0x0001a60000000009ULL, 0x0000f030003f0109ULL, 0x0001a60000000009ULL, 0x0000f380003f0109ULL,
0x0001a60000000009ULL, 0x0000f3a0003f0101ULL, 0x0001a60000000009ULL, 0x0000f510003f0109ULL,
0x0001a60000000009ULL, 0x00012330003f0109ULL, 0x0001a68800000075ULL, 0x00012700003f0101ULL,
0x0001a68800000075ULL, 0x00012870003f0109ULL, 0x0001a68800000075ULL, 0x000161d0003f0109ULL,
0x0001a60800000074ULL, 0x000161e0003f0101ULL, 0x0001a61000000074ULL, 0x000161f0003f0101ULL,
0x0001a61800000074ULL, 0x00016200003f0101ULL, 0x0001a62000000074ULL, 0x00053803003f0101ULL,
0x0000ca8000301c04ULL, 0x0000cc900000cae0ULL, 0x0000cf500000cdf0ULL, 0x0000d2100000d0b0ULL,
0x0000d5000000d370ULL, 0x0000f5400000d600ULL, 0x000c050400016220ULL, 0x0000000100000100ULL,
0x00041e0400000001ULL, 0x0058190300000000ULL, 0x0000001600080a04ULL, 0x0000000000580210ULL,
0x00000000000000bcULL, 0x0000001500000002ULL, 0x0000000000016230ULL, 0x0000000000000044ULL,
0x0000001500000002ULL, 0x0000000000000000ULL, 0x0000000000000098ULL, 0x0000001500000002ULL,
0x0000000000000000ULL, 0x000000000001a700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e700000000800ULL, 0x00008400ff047b82ULL, 0x000ea20000000a00ULL,
0x0000040000047ab9ULL, 0x000fe20000000800ULL, 0x00000000000f7919ULL, 0x000ee20000002300ULL,
0x0000010000057ab9ULL, 0x000fe20000000800ULL, 0x0000047000007945ULL, 0x000fe20003800000ULL,
0x0000000000087919ULL, 0x000ee60000002200ULL, 0x00008600ff197b82ULL, 0x000f220000000800ULL,
0x0000000000177919ULL, 0x000f220000002700ULL, 0x0000000500007306ULL, 0x004ea20000209000ULL,
0x000000ff0500720cULL, 0x000fce0003f45070ULL, 0x0000000000007308ULL, 0x004ea40000001000ULL,
0x0ffffffe00027836ULL, 0x004fcc0000000000ULL, 0x0000000200037305ULL, 0x000564000021f000ULL,
0x000000ffff027224ULL, 0x004fe400078e00ffULL, 0x000000ffff067224ULL, 0x020fc800078e0a03ULL,
0x0000000506077224ULL, 0x000fc800078e02ffULL, 0x0000000703037227ULL, 0x000fe400078e0002ULL,
0x0000000000077919ULL, 0x000ea80000002100ULL, 0x0000000403657c27ULL, 0x000fc8000f8e00ffULL,
0x000000ffff067224ULL, 0x000fc800078e0a65ULL, 0x0000000405007e24ULL, 0x000fe2000f8e0206ULL,
0x00000000000479c3ULL, 0x000f680000002600ULL, 0x000000050000720cULL, 0x000fda0003f06070ULL,
0x0000000100000824ULL, 0x000fe400078e0a05ULL, 0x0000000165650836ULL, 0x000fe20000000000ULL,
0x00000005ff787819ULL, 0x004fe40000011607ULL, 0x000000050000720cULL, 0x000fc80003f26070ULL,
0x00001fff78787589ULL, 0x000f3200000e0000ULL, 0x0000000165651836ULL, 0x000fe20000000000ULL,
0x00000005ff65a212ULL, 0x000fc800078e33ffULL, 0x0000006500007306ULL, 0x000ea20000209000ULL,
0x000000ff6500720cULL, 0x000fce0003f45070ULL, 0x0000000000007308ULL, 0x006e640000001000ULL,
0x0ffffffe00027836ULL, 0x002fe40000000000ULL, 0x000000050f007c24ULL, 0x008fe2000f8e0208ULL,
0x0000000000057ab9ULL, 0x000fc60000000800ULL, 0x0000000200037305ULL, 0x0002a2000021f000ULL,
0x00001fff0f0f7589ULL, 0x000f2200000e0000ULL, 0x000000ffff027224ULL, 0x002fe400078e00ffULL,
0x0000000365067224ULL, 0x004fc800078e02ffULL, 0x000000ffff097224ULL, 0x000fc800078e0a06ULL,
0x0000000903037227ULL, 0x000fc800078e0002ULL, 0x0000000500027c24ULL, 0x000fe4000f8e0207ULL,
0x0000000403087c27ULL, 0x020fc6000f8e00ffULL, 0x0000007f0200780cULL, 0x040fe20003f64070ULL,
0x000000ffff007224ULL, 0x000fe200078e0a08ULL, 0x000000030200780cULL, 0x000fc60003f84070ULL,
0x0000000465007e24ULL, 0x000fca000f8e0200ULL, 0x000000650000720cULL, 0x000fc60003f06070ULL,
0x000000000003b919ULL, 0x000e620000008800ULL, 0xff317217ff06b424ULL, 0x000fd200078e00ffULL,
0x0000000100000824ULL, 0x000fe400078e0a65ULL, 0x0000000108080836ULL, 0x000fe20000000000ULL,
0x000000ff0200720cULL, 0x000fe40003f05270ULL, 0x000000650000720cULL, 0x000fe40003f26070ULL,
0x000004000000b802ULL, 0x000fd60000000f00ULL, 0x0000000108081836ULL, 0x000fe20000000000ULL,
0x00000065ff08a212ULL, 0x000fe400078e33ffULL, 0x0000000f0200780cULL, 0x040fe40003f24070ULL,
0x000006540303b816ULL, 0x002fe20000000000ULL, 0x000000ffff007224ULL, 0x000fe200078e0a08ULL,
0x000000010200780cULL, 0x000fc60003f44070ULL, 0x0000000465657e24ULL, 0x000fe4000f8e0200ULL,
0x000000040203b824ULL, 0x000fe400078e0203ULL, 0x0000002065007824ULL, 0x000fe200078e00ffULL,
0x0000000000240947ULL, 0x010fec0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x001fff0000067882ULL, 0x000fe20000000000ULL,
0x7ffc000000077882ULL, 0x000fe20000000000ULL, 0x0000065405047896ULL, 0x002fe20008000004ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000000073c6ULL, 0x000e740000000000ULL,
0x01a60006043f75b2ULL, 0x0002640008000100ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000381947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000402077c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000070612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01a60804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000384947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffb000000057882ULL, 0x000fc60000000000ULL, 0x0000000402077c11ULL, 0x000fe2000f8e18ffULL,
0x001ffec000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000070612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x01a68804063f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x01a400060300b388ULL, 0x0003e20000000800ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000384947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000ea20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x004fc60008000004ULL,
0x7ffc000000057882ULL, 0x000fc60000000000ULL, 0x0000000402037c11ULL, 0x002fe2000f8e18ffULL,
0x001fff0000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000030612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x01a6a804063f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000382947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000402027c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x002fca0000000000ULL, 0x00000000020612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01a6c804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe200078e0a00ULL, 0x0000001904037219ULL, 0x082fe200000006ffULL,
0x0000000417047224ULL, 0x000fe200078e02ffULL, 0x00000019050b7219ULL, 0x080fe200000006ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000300720cULL, 0x000fe20003f06070ULL,
0x0000820000067ab9ULL, 0x000fe20000000a00ULL, 0x0000002003637446ULL, 0x000fe20003800002ULL,
0x000000040f027824ULL, 0x000fe200078e0278ULL, 0x0000001908767219ULL, 0x000fc400000006ffULL,
0x000000ff63637207ULL, 0x000fe20000000000ULL, 0x0000000402027824ULL, 0x000fe400078e00ffULL,
0x0000000b04047224ULL, 0x000fe200078e0276ULL, 0x000000206300780cULL, 0x000fda0003f05270ULL,
0x0000000000c48947ULL, 0x000fea0003800000ULL, 0x00000000000a7919ULL, 0x000e620000000000ULL,
0xffffffffff0c7424ULL, 0x000fe200078e00ffULL, 0x0000000263037248ULL, 0x000fe20007fe0000ULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000000127919ULL, 0x000ea20000008800ULL,
0x0000040000097802ULL, 0x000fe40000000f00ULL, 0x000000190c077219ULL, 0x000fe200000006ffULL,
0x0000000103037824ULL, 0x000fe200078e0a02ULL, 0x00000004ff067819ULL, 0x002fc8000001160aULL,
0x000000030600720cULL, 0x080fe20003f06070ULL, 0x00000002060e7836ULL, 0x000fe20000000000ULL,
0x0000065412097816ULL, 0x004fe20000000009ULL, 0x0000000102137824ULL, 0x040fe400078e0206ULL,
0x0000000102157824ULL, 0x000fe200078e020eULL, 0x000000030e00720cULL, 0x000fe20003f26070ULL,
0x00000001000c7824ULL, 0x040fe400078e0213ULL, 0x0000000100107824ULL, 0x000fe400078e0215ULL,
0x000000100a037824ULL, 0x000fe200078e00ffULL, 0x000000070c0d7212ULL, 0x080fe200078e30ffULL,
0x0000000113027824ULL, 0x040fe200078e020aULL, 0x0000000710077212ULL, 0x000fe200078e30ffULL,
0x0000001013137824ULL, 0x000fe200078e00ffULL, 0x00000019ff0c7219ULL, 0x080fe2000001160cULL,
0x00000001040d7824ULL, 0x040fe200078e020dULL, 0x00000019ff107219ULL, 0x000fe20000011610ULL,
0x0000000104077824ULL, 0x000fe200078e0207ULL, 0x000000f003117812ULL, 0x000fe200078ec0ffULL,
0x0000000b0c067224ULL, 0x080fe200078e020dULL, 0xfffffff013027812ULL, 0x000fe200078ee202ULL,
0x0000000b100c7224ULL, 0x000fc400078e0207ULL, 0x0000010006067825ULL, 0x000fc800078e00ffULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0x0000001106067212ULL, 0x000fc600078efcffULL,
0x0000000115047824ULL, 0x040fe200078e020aULL, 0x000000110c0c7212ULL, 0x000fe200078efcffULL,
0x0000001015157824ULL, 0x000fe200078e00ffULL, 0x0000000406067c10ULL, 0x000fe2000ff5e0ffULL,
0x0000001002117824ULL, 0x100fe200078e0209ULL, 0x000000040c0c7c10ULL, 0x000fe4000ff7e0ffULL,
0xfffffff015047812ULL, 0x000fe400078ee204ULL, 0x0000000507077c10ULL, 0x000fe400097fe4ffULL,
0x000000050d0d7c10ULL, 0x000fe20009ffe4ffULL, 0x0000001004137824ULL, 0x000fc400078e0209ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006117faeULL, 0x0003e8000c101c46ULL,
0x000000000c137faeULL, 0x0003e2000c901c46ULL, 0x0000000000a87947ULL, 0x000fea0003800000ULL,
0x00000000000a7919ULL, 0x000e620000000000ULL, 0x0000040000097802ULL, 0x000fe20000000f00ULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x00000000000c7919ULL, 0x000ea20000008800ULL,
0x000000020a117211ULL, 0x002fe200078fe0ffULL, 0xffffffffff027424ULL, 0x000fe200078e00ffULL,
0x000006540c097816ULL, 0x004fc60000000009ULL, 0x0000000211137836ULL, 0x000fe20000000000ULL,
0x0000001902077219ULL, 0x000fe200000006ffULL, 0x0000000100027824ULL, 0x040fe400078e0211ULL,
0x0000000100067824ULL, 0x000fc600078e0213ULL, 0x0000000702037212ULL, 0x080fe400078e30ffULL,
0x0000000706077212ULL, 0x000fe400078e30ffULL, 0x00000019ff027219ULL, 0x080fe20000011602ULL,
0x0000000104037824ULL, 0x040fe200078e0203ULL, 0x00000019ff067219ULL, 0x000fe20000011606ULL,
0x0000000104077824ULL, 0x000fe400078e0207ULL, 0x0000000b02027224ULL, 0x000fe400078e0203ULL,
0x000000100a037824ULL, 0x000fc400078e00ffULL, 0x0000000b060c7224ULL, 0x000fe400078e0207ULL,
0x0000010002067825ULL, 0x000fe200078e00ffULL, 0x000000f003157812ULL, 0x000fc600078ec0ffULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0x0000001506067212ULL, 0x000fc600078efcffULL,
0x0000000111027824ULL, 0x140fe200078e020aULL, 0x000000150c0c7212ULL, 0x000fe200078efcffULL,
0x0000001011117824ULL, 0x000fe200078e00ffULL, 0x0000000406067c10ULL, 0x000fe2000ff1e0ffULL,
0x0000000113047824ULL, 0x040fe200078e020aULL, 0x000000040c0c7c10ULL, 0x000fe2000ff3e0ffULL,
0x0000001013137824ULL, 0x000fe200078e00ffULL, 0xfffffff011027812ULL, 0x000fe400078ee202ULL,
0x0000000507077c10ULL, 0x000fe400087fe4ffULL, 0xfffffff013047812ULL, 0x000fe200078ee204ULL,
0x0000001002117824ULL, 0x000fe200078e0209ULL, 0x000000050d0d7c10ULL, 0x000fc60008ffe4ffULL,
0x0000001004137824ULL, 0x000fe200078e0209ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006117faeULL, 0x0003e8000b901c46ULL, 0x000000000c137faeULL, 0x0003e4000b901c46ULL,
0x00000000090472caULL, 0x000fe200000e0000ULL, 0x00009000ff067b82ULL, 0x002e620000000a00ULL,
0x0000000000007918ULL, 0x000fd60000000000ULL, 0x0001a60004047890ULL, 0x000fd2000fffe03fULL,
0x000000ffffff79a7ULL, 0x000fe20008200404ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a84ULL,
0x0000000417067825ULL, 0x002fe200078e0006ULL, 0x0000000000007918ULL, 0x000fc80000000000ULL,
0x0000000606617981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0f00720cULL, 0x000fe20003f05270ULL,
0x000000ff61027836ULL, 0x004fca0000000000ULL, 0x00000008ff5b7819ULL, 0x000fce0000011602ULL,
0x000000c400608947ULL, 0x000fea0003800000ULL, 0x0000000878627824ULL, 0x000fe200078e00ffULL,
0x000001ff0200780cULL, 0x000fe20003f04070ULL, 0x00000004ff077424ULL, 0x000fe200078e00ffULL,
0x00000001ff607819ULL, 0x000fe20000011678ULL, 0x0000000109007824ULL, 0x000fe200078e0262ULL,
0x0000920000047ab9ULL, 0x000fe20000000800ULL, 0x0000000178647812ULL, 0x000fe400078ec0ffULL,
0x01a6880700ff79a7ULL, 0x0003e2000850003fULL, 0x00000020605a7824ULL, 0x000fe400078e00ffULL,
0x0000000217007824ULL, 0x002fc800078e00ffULL, 0x0000000500597224ULL, 0x000fc800078e0205ULL,
0x0000000108597824ULL, 0x000fc800078e0259ULL, 0x0000000459007c24ULL, 0x000fe2000f8e025aULL,
0x0000000400000947ULL, 0x000fec0003800000ULL, 0x0000005a61057248ULL, 0x000fe20007fe0000ULL,
0x0000001064027824ULL, 0x000fe200078e00ffULL, 0x00000003ff047819ULL, 0x000fe2000001160aULL,
0x00008e0000047ab9ULL, 0x000fe40000000a00ULL, 0x0000000105057824ULL, 0x000fe400078e0a5aULL,
0x0000000102077824ULL, 0x000fe400078e0204ULL, 0x00000004040c7836ULL, 0x000fe20000000000ULL,
0x0000000205057248ULL, 0x000fe20007fe0000ULL, 0x0000000107067824ULL, 0x000fc400078e020aULL,
0x00000008070d7824ULL, 0x000fe400078e00ffULL, 0x0000000105057824ULL, 0x000fe400078e0a02ULL,
0x00000008040e7836ULL, 0x000fe20000000000ULL, 0xfffffff80d087812ULL, 0x000fe200078ee206ULL,
0x00000001020d7824ULL, 0x000fe200078e020cULL, 0x000000050c00720cULL, 0x080fe20003f46070ULL,
0x0000000c040c7836ULL, 0x000fe20000000000ULL, 0x000000050400720cULL, 0x080fe20003f66070ULL,
0x0000000100047824ULL, 0x000fe200078e0207ULL, 0x000000050e00720cULL, 0x080fe20003f26070ULL,
0x000000010d067824ULL, 0x000fe200078e020aULL, 0x000000050c00720cULL, 0x000fe20003f06070ULL,
0x0000008004047825ULL, 0x000fc800078e00ffULL, 0x000000080d117824ULL, 0x000fe400078e00ffULL,
0x00000001020f7824ULL, 0x040fe400078e020cULL, 0x0000000102077824ULL, 0x000fe200078e020eULL,
0x00000070040e7812ULL, 0x000fe200078ef803ULL, 0x0000000100127824ULL, 0x000fe200078e020fULL,
0xfffffff811027812ULL, 0x000fe200078ee206ULL, 0x000000010f047824ULL, 0x040fe200078e020aULL,
0x000000040e0e7c10ULL, 0x000fe2000ff9e0ffULL, 0x000000080f0f7824ULL, 0x000fc400078e00ffULL,
0x0000000100067824ULL, 0x040fe400078e0207ULL, 0x00000001070c7824ULL, 0x040fe200078e020aULL,
0xfffffff80f147812ULL, 0x000fe200078ee204ULL, 0x00000001000d7824ULL, 0x000fe200078e020dULL,
0x00000005050f7c10ULL, 0x000fe2000a7fe4ffULL, 0x0000000807077824ULL, 0x000fe400078e00ffULL,
0x0000200060007824ULL, 0x000fe400078e0209ULL, 0x000000800d047825ULL, 0x000fe200078e00ffULL,
0xfffffff807107812ULL, 0x000fc600078ee20cULL, 0x0001600000117836ULL, 0x000fe40000000000ULL,
0x0000008006067825ULL, 0x000fc800078e00ffULL, 0x00000080120c7825ULL, 0x000fc800078e00ffULL,
0x0000001002157824ULL, 0x100fe200078e0211ULL, 0x0000007004027812ULL, 0x000fe200078ef803ULL,
0x0000001008137824ULL, 0x100fe200078e0211ULL, 0x0000007006047812ULL, 0x000fe200078ef803ULL,
0x0000001010177824ULL, 0x100fe200078e0211ULL, 0x000000700c037812ULL, 0x000fe200078ef803ULL,
0x0000001014117824ULL, 0x000fe200078e0211ULL, 0x0000000402027c10ULL, 0x000fe2000ff9e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e137faeULL, 0x0003e2000d901c46ULL,
0x0000000404047c10ULL, 0x000fe4000ffbe0ffULL, 0x0000000403067c10ULL, 0x000fc4000ffde0ffULL,
0x0000000505037c10ULL, 0x000fe4000a7fe4ffULL, 0x0000000507057c10ULL, 0x000fe4000affe4ffULL,
0x000000050d077c10ULL, 0x000fe2000b7fe4ffULL, 0x0000000002157faeULL, 0x0003e8000d101c46ULL,
0x0000000004177faeULL, 0x0003e8000c901c46ULL, 0x0000000006117faeULL, 0x0003e2000c101c46ULL,
0x0000000000cc7947ULL, 0x000fea0003800000ULL, 0x0000001064057824ULL, 0x000fe200078e00ffULL,
0x00008e0000047ab9ULL, 0x000fc80000000a00ULL, 0x000000050a057211ULL, 0x000fca00078fe8ffULL,
0x0000000405077836ULL, 0x000fe40000000000ULL, 0x0000000105027824ULL, 0x140fe400078e020aULL,
0x00000008050d7824ULL, 0x000fe400078e00ffULL, 0x0000000107067824ULL, 0x040fe400078e020aULL,
0x00000008070f7824ULL, 0x000fe200078e00ffULL, 0xfffffff80d027812ULL, 0x000fe200078ee202ULL,
0x0000000100047824ULL, 0x000fc400078e0205ULL, 0x00000008050d7836ULL, 0x000fe20000000000ULL,
0xfffffff80f087812ULL, 0x000fe200078ee206ULL, 0x0000000c050f7836ULL, 0x000fe40000000000ULL,
0x0000008004047825ULL, 0x000fc800078e00ffULL, 0x00000001000c7824ULL, 0x040fe200078e020fULL,
0x00000070040e7812ULL, 0x000fe200078ef803ULL, 0x000000010f047824ULL, 0x140fe400078e020aULL,
0x000000080f0f7824ULL, 0x000fe200078e00ffULL, 0x000000040e0e7c10ULL, 0x000fe2000ff1e0ffULL,
0x0000000100077824ULL, 0x040fe400078e0207ULL, 0x0000000100067824ULL, 0x000fe200078e020dULL,
0xfffffff80f107812ULL, 0x000fe200078ee204ULL, 0x000000010d007824ULL, 0x040fe200078e020aULL,
0x00000005050f7c10ULL, 0x000fe200087fe4ffULL, 0x000000080d117824ULL, 0x000fc400078e00ffULL,
0x00002000600d7824ULL, 0x000fe400078e0209ULL, 0x0000008007047825ULL, 0x000fe200078e00ffULL,
0xfffffff811007812ULL, 0x000fc600078ee200ULL, 0x000160000d177836ULL, 0x000fe40000000000ULL,
0x0000008006067825ULL, 0x000fc800078e00ffULL, 0x000000800c0c7825ULL, 0x000fc800078e00ffULL,
0x0000001002117824ULL, 0x100fe200078e0217ULL, 0x0000007004027812ULL, 0x000fe200078ef803ULL,
0x0000001008137824ULL, 0x100fe200078e0217ULL, 0x0000007006047812ULL, 0x000fe200078ef803ULL,
0x0000001000157824ULL, 0x100fe200078e0217ULL, 0x000000700c037812ULL, 0x000fe200078ef803ULL,
0x0000001010177824ULL, 0x000fe200078e0217ULL, 0x0000000402027c10ULL, 0x000fe2000ff1e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e117faeULL, 0x0003e2000b901c46ULL,
0x0000000404047c10ULL, 0x000fe4000ff3e0ffULL, 0x0000000403067c10ULL, 0x000fc4000ff5e0ffULL,
0x0000000505037c10ULL, 0x000fe400087fe4ffULL, 0x0000000507057c10ULL, 0x000fe40008ffe4ffULL,
0x000000050d077c10ULL, 0x000fe200097fe4ffULL, 0x0000000002137faeULL, 0x0003e8000b901c46ULL,
0x0000000004157faeULL, 0x0003e8000b901c46ULL, 0x0000000006177faeULL, 0x0003e4000b901c46ULL,
0x0001a6a809037836ULL, 0x002fe20000000000ULL, 0x00000000600472caULL, 0x000fe200000e0000ULL,
0x00000001ff027424ULL, 0x000fe200078e00ffULL, 0x000000ff5b00720cULL, 0x000fe20003f05270ULL,
0x000000ffff7d7224ULL, 0x000fe200078e00ffULL, 0x00000000030572caULL, 0x000fe400000e0000ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fc4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x00000000001e7805ULL, 0x000fe4000001ff00ULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x00000000001a7805ULL, 0x000fc4000001ff00ULL, 0x0000000000187805ULL, 0x000fe4000001ff00ULL,
0x0000000000167805ULL, 0x000fe4000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000504047291ULL, 0x000fe2000f8e203fULL, 0x0000000000127805ULL, 0x000fe4000001ff00ULL,
0x0000000000107805ULL, 0x000fe4000001ff00ULL, 0x00000000000e7805ULL, 0x000fc4000001ff00ULL,
0x00000000000c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000267805ULL, 0x000fe4000001ff00ULL,
0x0000000000247805ULL, 0x000fe4000001ff00ULL, 0x00000000002a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000527805ULL, 0x000fc4000001ff00ULL, 0x0000000000507805ULL, 0x000fe4000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x000000ffff497224ULL, 0x000fe400078e00ffULL, 0x0000000860037824ULL, 0x000fe200078e0203ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000002ff8079a7ULL, 0x0002a20008500004ULL,
0x000000ffff487224ULL, 0x000fe200078e00ffULL, 0x0000000000467805ULL, 0x000fc4000001ff00ULL,
0x0000000000447805ULL, 0x000fe4000001ff00ULL, 0x0000000000427805ULL, 0x000fe4000001ff00ULL,
0x0000000000407805ULL, 0x000fe4000001ff00ULL, 0x00000000003e7805ULL, 0x000fe4000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x00002002030279a7ULL, 0x002e62000850003fULL,
0x0000000000567805ULL, 0x000fc4000001ff00ULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x0000009c00988947ULL, 0x000fec0003800000ULL, 0x00000002ff587819ULL, 0x000fe20000011678ULL,
0x000000ffff397224ULL, 0x002fe200078e0003ULL, 0x0000000160007812ULL, 0x000fe200078ec0ffULL,
0xff317217ff7c7424ULL, 0x000fe200078e00ffULL, 0x0000000862087812ULL, 0x000fe200078ec0ffULL,
0x0000002058057824ULL, 0x000fe400078e0209ULL, 0x000000ffff077224ULL, 0x000fe400078e00ffULL,
0x0000001000057824ULL, 0x000fe400078e0205ULL, 0x000000ffff2f7224ULL, 0x000fc400078e00ffULL,
0x0000000108087824ULL, 0x000fce00078e0205ULL, 0x0000000000347805ULL, 0x006fce0000015200ULL,
0x0000000478067824ULL, 0x000fca00078e00ffULL, 0xfffffff806067812ULL, 0x000fca00078ec0ffULL,
0x0000000109387824ULL, 0x000fc800078e0206ULL, 0x01a6c839380075a7ULL, 0x000e62000800017fULL,
0x0001a6c838067836ULL, 0x000fe20000000000ULL, 0x00000000005c0947ULL, 0x002fec0003800000ULL,
0x000000ffff3a7224ULL, 0x000fce00078e00ffULL, 0x000000103a00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fce0000015200ULL,
0x00000036343b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000137377824ULL, 0x000fe200000e0e35ULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff367819ULL, 0x000fc80000011437ULL, 0x0000003b36367211ULL, 0x000fca00078110ffULL,
0x000000ffff377224ULL, 0x000fca00000e0637ULL, 0x0000000236367819ULL, 0x000fc80000001237ULL,
0x000000360000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013a3a7836ULL, 0x000fce0000000000ULL, 0x01a6c839380075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000107347836ULL, 0x000fe20000000000ULL,
0x0000920000057ab9ULL, 0x000fe20000000800ULL, 0x0000010007717824ULL, 0x000fc600078e025aULL,
0x0000005b3400720cULL, 0x000fe20003f26070ULL, 0x0000004071367836ULL, 0x000fc80000000000ULL,
0x00000005593a7c24ULL, 0x000fd0000f8e0236ULL, 0x0000000400089947ULL, 0x000fea0003800000ULL,
0x0000003661347248ULL, 0x000fe20007fe0000ULL, 0x0000001064357824ULL, 0x000fe200078e00ffULL,
0x00000003ff377819ULL, 0x000fe2000001160aULL, 0x00008e0000087ab9ULL, 0x000fe40000000a00ULL,
0x0000000134347824ULL, 0x000fe400078e0a36ULL, 0x0000000135397824ULL, 0x000fe400078e0237ULL,
0x0000000437387836ULL, 0x000fe20000000000ULL, 0x0000003435347248ULL, 0x000fe20007fe0000ULL,
0x0000000139367824ULL, 0x000fc400078e020aULL, 0x00000008394f7824ULL, 0x000fe400078e00ffULL,
0x0000000134347824ULL, 0x000fe400078e0a35ULL, 0x00000001353b7824ULL, 0x000fe200078e0238ULL,
0xfffffff84f4f7812ULL, 0x000fe400078ee236ULL, 0x000000343800720cULL, 0x080fe20003f66070ULL,
0x0000000837387836ULL, 0x000fe20000000000ULL, 0x000000343700720cULL, 0x000fe20003f86070ULL,
0x0000000c37377836ULL, 0x000fc40000000000ULL, 0x000000013b367824ULL, 0x040fe200078e020aULL,
0x000000343800720cULL, 0x080fe20003f46070ULL, 0x000000083b5d7824ULL, 0x000fe200078e00ffULL,
0x000000343700720cULL, 0x000fe20003f06070ULL, 0x00000001354d7824ULL, 0x040fe400078e0238ULL,
0x0000000135357824ULL, 0x000fe200078e0237ULL, 0xfffffff85d5d7812ULL, 0x000fe200078ee236ULL,
0x000000100a377824ULL, 0x000fe400078e00ffULL, 0x0000000139347824ULL, 0x000fc400078e023aULL,
0x000000013b367824ULL, 0x100fe400078e023aULL, 0x000000014d387824ULL, 0x100fe400078e023aULL,
0x00000001353a7824ULL, 0x000fe400078e023aULL, 0x000000014d397824ULL, 0x140fe400078e020aULL,
0x000000084d4c7824ULL, 0x000fe200078e00ffULL, 0x00000070374d7812ULL, 0x000fe200078ec0ffULL,
0x00000001353b7824ULL, 0x000fc400078e020aULL, 0x00000008354e7824ULL, 0x000fe200078e00ffULL,
0xfffffff84c5f7812ULL, 0x000fe200078ee239ULL, 0x0000008034347825ULL, 0x000fc600078e00ffULL,
0xfffffff84e677812ULL, 0x000fe200078ee23bULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000004d34347212ULL, 0x000fc600078efcffULL, 0x0000008038387825ULL, 0x000fe200078e00ffULL,
0x0000004d36367212ULL, 0x080fe400078efcffULL, 0x0000000834347c10ULL, 0x000fe2000ffbe0ffULL,
0x000000803a3a7825ULL, 0x000fe200078e00ffULL, 0x0000000836367c10ULL, 0x000fe4000ffde0ffULL,
0x0000004d38387212ULL, 0x080fe200078efcffULL, 0x00002000604c7824ULL, 0x000fe200078e0209ULL,
0x0000004d3a3a7212ULL, 0x000fe400078efcffULL, 0x0000000935357c10ULL, 0x000fe2000affe4ffULL,
0x000170004c4c7836ULL, 0x000fe20000000000ULL, 0x0000000937377c10ULL, 0x000fc4000b7fe4ffULL,
0x0000000838387c10ULL, 0x000fe2000ffbe0ffULL, 0x000000104f4d7824ULL, 0x100fe200078e024cULL,
0x000000083a3a7c10ULL, 0x000fe2000ffde0ffULL, 0x000000105d4f7824ULL, 0x100fe200078e024cULL,
0x0000000939397c10ULL, 0x000fe2000affe4ffULL, 0x000000105f5d7824ULL, 0x100fe200078e024cULL,
0x000000093b3b7c10ULL, 0x000fe2000b7fe4ffULL, 0x00000010675f7824ULL, 0x000fe200078e024cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000344d7faeULL, 0x0003e8000e101c46ULL,
0x00000000364f7faeULL, 0x0003e8000d901c46ULL, 0x00000000385d7faeULL, 0x0003e8000d101c46ULL,
0x000000003a5f7faeULL, 0x0003e2000c101c46ULL, 0x0000000000d47947ULL, 0x000fea0003800000ULL,
0x0000001064357824ULL, 0x000fe200078e00ffULL, 0x00008e0000087ab9ULL, 0x000fe20000000a00ULL,
0x000000100a367824ULL, 0x000fc600078e00ffULL, 0x000000350a357211ULL, 0x000fe400078fe8ffULL,
0x00000070365d7812ULL, 0x000fc600078ec0ffULL, 0x0000000435377836ULL, 0x000fe40000000000ULL,
0x0000000135347824ULL, 0x140fe400078e020aULL, 0x00000008354d7824ULL, 0x000fe400078e00ffULL,
0x0000000137387824ULL, 0x040fe400078e020aULL, 0x00000008374f7824ULL, 0x000fe200078e00ffULL,
0xfffffff84d4d7812ULL, 0x000fe200078ee234ULL, 0x0000000835397836ULL, 0x000fc40000000000ULL,
0x0000000135347824ULL, 0x000fe200078e023aULL, 0xfffffff84f4f7812ULL, 0x000fe200078ee238ULL,
0x0000000c355f7836ULL, 0x000fe40000000000ULL, 0x00000001393b7824ULL, 0x040fe400078e020aULL,
0x00000008394c7824ULL, 0x000fe400078e00ffULL, 0x0000000137367824ULL, 0x100fe400078e023aULL,
0x0000000139387824ULL, 0x000fc400078e023aULL, 0x0000008034347825ULL, 0x000fc800078e00ffULL,
0x000000015f397824ULL, 0x040fe200078e020aULL, 0x0000005d34347212ULL, 0x000fe200078efcffULL,
0x000000085f4e7824ULL, 0x040fe400078e00ffULL, 0x0000200060377824ULL, 0x000fe200078e0209ULL,
0x0000000834347c10ULL, 0x000fe2000ff1e0ffULL, 0x000000015f3a7824ULL, 0x000fe200078e023aULL,
0xfffffff84c5f7812ULL, 0x000fe200078ee23bULL, 0x00017000374c7836ULL, 0x000fe20000000000ULL,
0xfffffff84e677812ULL, 0x000fe200078ee239ULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000000935357c10ULL, 0x000fc600087fe4ffULL, 0x0000008038387825ULL, 0x000fe200078e00ffULL,
0x0000005d36367212ULL, 0x000fc600078efcffULL, 0x000000803a3a7825ULL, 0x000fe200078e00ffULL,
0x0000005d38387212ULL, 0x080fe400078efcffULL, 0x0000000836367c10ULL, 0x000fe2000ff1e0ffULL,
0x000000104d4d7824ULL, 0x100fe200078e024cULL, 0x0000005d3a3a7212ULL, 0x000fe200078efcffULL,
0x000000104f4f7824ULL, 0x100fe200078e024cULL, 0x0000000838387c10ULL, 0x000fe2000ff5e0ffULL,
0x000000105f5d7824ULL, 0x100fe200078e024cULL, 0x000000083a3a7c10ULL, 0x000fe2000ff7e0ffULL,
0x00000010675f7824ULL, 0x000fe200078e024cULL, 0x0000000937377c10ULL, 0x000fe200087fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000344d7faeULL, 0x0003e2000b901c46ULL,
0x0000000939397c10ULL, 0x000fc400097fe4ffULL, 0x000000093b3b7c10ULL, 0x000fe20009ffe4ffULL,
0x00000000364f7faeULL, 0x0003e8000b901c46ULL, 0x00000000385d7faeULL, 0x0003e8000b901c46ULL,
0x000000003a5f7faeULL, 0x0003e4000b901c46ULL, 0xfffffff062347812ULL, 0x042fe200078ec0ffULL,
0x00000001ff397424ULL, 0x000fe200078e00ffULL, 0x0000001062357812ULL, 0x000fc600078ec0ffULL,
0x00000001093a7824ULL, 0x000fe200078e0234ULL, 0xffffffe062347812ULL, 0x000fc800078ec0ffULL,
0x000000003a0572caULL, 0x000fe200000e0000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000935377210ULL, 0x000fca0007ffe034ULL, 0x0000000864387824ULL, 0x000fcc00078e0237ULL,
0x0001a6b005057890ULL, 0x000fd2000fffe03fULL, 0x00000000ff0079b0ULL, 0x000fe20008000a45ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01a6b0393a8479a7ULL, 0x0002e4000850003fULL,
0x01a60839383879a7ULL, 0x002e64000850003fULL, 0x0000000000347805ULL, 0x000fce0000015200ULL,
0x0000000862367812ULL, 0x000fca00078ec0ffULL, 0x0000000137757824ULL, 0x000fc800078e0236ULL,
0x01a60839750075a7ULL, 0x002e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff4c7224ULL, 0x000fce00078e00ffULL, 0x000000104c00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fce0000015200ULL,
0x00000036343b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000137377824ULL, 0x000fe200000e0e35ULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff367819ULL, 0x000fc80000011437ULL, 0x0000003b36367211ULL, 0x000fca00078110ffULL,
0x000000ffff377224ULL, 0x000fca00000e0637ULL, 0x0000000236367819ULL, 0x000fc80000001237ULL,
0x000000360000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000014c4c7836ULL, 0x000fce0000000000ULL, 0x01a60839750075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000100a727824ULL, 0x000fe200078e00ffULL,
0x00000001ff737819ULL, 0x000fe2000001160aULL, 0x0000002078347824ULL, 0x000fe400078e00ffULL,
0x00000001ff387424ULL, 0x000fe200078e00ffULL, 0x0000007072727812ULL, 0x000fe200078ec0ffULL,
0x000000ffff7a7224ULL, 0x000fe200078e007cULL, 0xffffff8034347812ULL, 0x000fe400078ec0ffULL,
0x0000000c73737812ULL, 0x000fe400078ec0ffULL, 0x0000000972347210ULL, 0x000fca0007ffe034ULL,
0x0000000134347824ULL, 0x000fca00078e0273ULL, 0x01a0000034357984ULL, 0x000e680000000800ULL,
0x01a2000034367984ULL, 0x0009220000000800ULL, 0x0000007c3500720bULL, 0x002fda0003f1d000ULL,
0x0000000000397806ULL, 0x000fc800000e0100ULL, 0x000000ff3900720cULL, 0x000fda0003f05270ULL,
0x00000004008c8947ULL, 0x01cfea0003800000ULL, 0x000000785800720cULL, 0x000fe40003f45270ULL,
0x0000007c3500720bULL, 0x0c0fe40003f14000ULL, 0x0000007c357a7209ULL, 0x000fd20007810000ULL,
0x000000807834a824ULL, 0x000fe400078e0209ULL, 0x00000000004c7806ULL, 0x000fc600000e0100ULL,
0x000000347337a210ULL, 0x000fe40007ffe072ULL, 0x000000ff4c00720cULL, 0x000fc60003f05270ULL,
0x01a4007a3700a388ULL, 0x0003f40000000800ULL, 0x0000000400508947ULL, 0x002fea0003800000ULL,
0x0000007c7a347221ULL, 0x000fe20000010100ULL, 0x000000ff4cff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff004cff7812ULL, 0x000fe2000784c0ffULL, 0x3fb8aa3b34347820ULL, 0x000fe20000410000ULL,
0x00ff00004cff7812ULL, 0x040fe4000786c0ffULL, 0xff0000004cff7812ULL, 0x000fe2000788c0ffULL,
0x0000003400377308ULL, 0x0002ac0000000800ULL, 0x0000000000488947ULL, 0x000fec0003800000ULL,
0x00000002ff347819ULL, 0x002fcc000001160aULL, 0x00001f3437347589ULL, 0x004e6400000e0000ULL,
0x0000003454547220ULL, 0x082fe20000410000ULL, 0x0000003455557220ULL, 0x080fe20000410000ULL,
0x000000343c3c7220ULL, 0x080fe20000410000ULL, 0x000000343d3d7220ULL, 0x080fe20000410000ULL,
0x0000003440407220ULL, 0x080fe20000410000ULL, 0x0000003441417220ULL, 0x080fe20000410000ULL,
0x0000003444447220ULL, 0x080fe20000410000ULL, 0x0000003445457220ULL, 0x080fe20000410000ULL,
0x0000003448487220ULL, 0x080fe20000410000ULL, 0x0000003449497220ULL, 0x080fe20000410000ULL,
0x0000003450507220ULL, 0x080fe20000410000ULL, 0x0000003451517220ULL, 0x080fe20000410000ULL,
0x0000003428287220ULL, 0x080fe20000410000ULL, 0x0000003429297220ULL, 0x080fe20000410000ULL,
0x0000003424247220ULL, 0x080fe20000410000ULL, 0x0000003425257220ULL, 0x000fce0000410000ULL,
0x000000000048a947ULL, 0x000fea0003800000ULL, 0x000000080a347811ULL, 0x002fcc00078ff0ffULL,
0x00001f3437347589ULL, 0x004e6400000e0000ULL, 0x0000003456567220ULL, 0x082fe20000410000ULL,
0x0000003457577220ULL, 0x080fe20000410000ULL, 0x000000343e3e7220ULL, 0x080fe20000410000ULL,
0x000000343f3f7220ULL, 0x080fe20000410000ULL, 0x0000003442427220ULL, 0x080fe20000410000ULL,
0x0000003443437220ULL, 0x080fe20000410000ULL, 0x0000003446467220ULL, 0x080fe20000410000ULL,
0x0000003447477220ULL, 0x080fe20000410000ULL, 0x000000344a4a7220ULL, 0x080fe20000410000ULL,
0x000000344b4b7220ULL, 0x080fe20000410000ULL, 0x0000003452527220ULL, 0x080fe20000410000ULL,
0x0000003453537220ULL, 0x080fe20000410000ULL, 0x000000342a2a7220ULL, 0x080fe20000410000ULL,
0x000000342b2b7220ULL, 0x080fe20000410000ULL, 0x0000003426267220ULL, 0x080fe20000410000ULL,
0x0000003427277220ULL, 0x000fce0000410000ULL, 0x000000000048b947ULL, 0x000fea0003800000ULL,
0x000000100a347811ULL, 0x002fcc00078ff0ffULL, 0x00001f3437347589ULL, 0x004e6400000e0000ULL,
0x000000340c0c7220ULL, 0x082fe20000410000ULL, 0x000000340d0d7220ULL, 0x080fe20000410000ULL,
0x0000003410107220ULL, 0x080fe20000410000ULL, 0x0000003411117220ULL, 0x080fe20000410000ULL,
0x0000003414147220ULL, 0x080fe20000410000ULL, 0x0000003415157220ULL, 0x080fe20000410000ULL,
0x0000003418187220ULL, 0x080fe20000410000ULL, 0x0000003419197220ULL, 0x080fe20000410000ULL,
0x000000341c1c7220ULL, 0x080fe20000410000ULL, 0x000000341d1d7220ULL, 0x080fe20000410000ULL,
0x0000003420207220ULL, 0x080fe20000410000ULL, 0x0000003421217220ULL, 0x080fe20000410000ULL,
0x0000003430307220ULL, 0x080fe20000410000ULL, 0x0000003431317220ULL, 0x080fe20000410000ULL,
0x000000342c2c7220ULL, 0x080fe20000410000ULL, 0x000000342d2d7220ULL, 0x000fce0000410000ULL,
0x000000377d7d7220ULL, 0x004fe20000410000ULL, 0x000000000048c947ULL, 0x000fec0003800000ULL,
0x000000180a347811ULL, 0x002fcc00078ff0ffULL, 0x00001f3437347589ULL, 0x000e6400000e0000ULL,
0x000000340e0e7220ULL, 0x082fe20000410000ULL, 0x000000340f0f7220ULL, 0x080fe20000410000ULL,
0x0000003412127220ULL, 0x080fe20000410000ULL, 0x0000003413137220ULL, 0x080fe20000410000ULL,
0x0000003416167220ULL, 0x080fe20000410000ULL, 0x0000003417177220ULL, 0x080fe20000410000ULL,
0x000000341a1a7220ULL, 0x080fe20000410000ULL, 0x000000341b1b7220ULL, 0x080fe20000410000ULL,
0x000000341e1e7220ULL, 0x080fe20000410000ULL, 0x000000341f1f7220ULL, 0x080fe20000410000ULL,
0x0000003422227220ULL, 0x080fe20000410000ULL, 0x0000003423237220ULL, 0x080fe20000410000ULL,
0x0000003432327220ULL, 0x080fe20000410000ULL, 0x0000003433337220ULL, 0x080fe20000410000ULL,
0x000000342e2e7220ULL, 0x080fe20000410000ULL, 0x000000342f2f7220ULL, 0x000fce0000410000ULL,
0x0000004c39ff7212ULL, 0x000fda00078030ffULL, 0x8000007a35350221ULL, 0x000fe20000010000ULL,
0x00007610ff380816ULL, 0x000fc60000000038ULL, 0x3fb8aa3b35350820ULL, 0x000fc80000410000ULL,
0x0000003500040308ULL, 0x000ea40000000800ULL, 0x0000000436360220ULL, 0x004fce0000410000ULL,
0x0000007d367d7221ULL, 0x000fe20000010000ULL, 0x0000000000347805ULL, 0x002fe20000015200ULL,
0x01a6a8813a0075a7ULL, 0x000ea2000800017fULL, 0x0001a6a83a397836ULL, 0x000fca0000000000ULL,
0x00000000390572caULL, 0x000fe200000e0000ULL, 0x0000000000600947ULL, 0x006fdc0003800000ULL,
0x000000ffff4c7224ULL, 0x000fce00078e00ffULL, 0x000000104c00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fcc0000015200ULL,
0x00000036343b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000137377824ULL, 0x000fe200000e0e35ULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff367819ULL, 0x000fc80000011437ULL, 0x0000003b36367211ULL, 0x000fca00078110ffULL,
0x000000ffff377224ULL, 0x000fca00000e0637ULL, 0x0000000236367819ULL, 0x000fc80000001237ULL,
0x000000360000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000014c4c7836ULL, 0x000fce0000000000ULL, 0x01a6a8813a0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00000000390572caULL, 0x000fde00000e0000ULL,
0x0000000460817824ULL, 0x000fe200078e00ffULL, 0x000000080a357812ULL, 0x000fe200078ec0ffULL,
0x0000200060707824ULL, 0x000fe200078e0209ULL, 0x0000991038387816ULL, 0x000fe400000000ffULL,
0x0000000481817812ULL, 0x000fe200078ec0ffULL, 0x00016000706f7836ULL, 0x000fe20000000000ULL,
0x00000007356e7812ULL, 0x000fe200078ef80aULL, 0x000000ffff357224ULL, 0x000fe200078e0038ULL,
0x000000810a347211ULL, 0x000fe400078fe0ffULL, 0x00000004ff7f7819ULL, 0x000fe2000001160aULL,
0x000000086e367824ULL, 0x040fe200078e00ffULL, 0x000000ff3500720cULL, 0x000fe20003f05270ULL,
0x000000016e797824ULL, 0x040fe200078e0234ULL, 0x000000106e777812ULL, 0x000fe200078efcffULL,
0x0000040078357824ULL, 0x000fc400078e00ffULL, 0x00000004647c7824ULL, 0x000fe200078e027fULL,
0xfffffff836797812ULL, 0x000fe200078ee279ULL, 0x000000086e377824ULL, 0x040fe200078e00ffULL,
0xfffff00035367812ULL, 0x000fe200078ec0ffULL, 0x000000016e5c7824ULL, 0x000fe400078e027cULL,
0x0000000134747824ULL, 0x000fe200078e0277ULL, 0x00012000097b7810ULL, 0x000fe20007ffe036ULL,
0x0000000877357824ULL, 0x000fe200078e00ffULL, 0xfffffff837347812ULL, 0x000fc600078ee25cULL,
0x0000001079367824ULL, 0x000fe200078e027bULL, 0xfffffff835747812ULL, 0x000fe200078ee274ULL,
0x00000010344c7824ULL, 0x000fc800078e026fULL, 0x0000001074387824ULL, 0x000fe200078e027bULL,
0x0000000000280947ULL, 0x000fec0003800000ULL, 0x00000002ff037819ULL, 0x000fe4000001160aULL,
0x00000004ff00723eULL, 0x000fc600000000ffULL, 0x0000001003057836ULL, 0x000fe20000000000ULL,
0x0000541000347816ULL, 0x000fe20000000000ULL, 0x0000000803357836ULL, 0x000fe40000000000ULL,
0x0000001803377836ULL, 0x000fe40000000000ULL, 0x00001f0534057589ULL, 0x0002a800000e0000ULL,
0x00001f3534027589ULL, 0x0002e800000e0000ULL, 0x00001f0334037589ULL, 0x00026800000e0000ULL,
0x00001f3734007589ULL, 0x00026400000e0000ULL, 0x000000003634783bULL, 0x002e680000000200ULL,
0x000000003838783bULL, 0x000ee20000000200ULL, 0x0000000000200947ULL, 0x000fea0003800000ULL,
0x0000000334347232ULL, 0x082fe40000000000ULL, 0x0000000336367232ULL, 0x000fe40000000000ULL,
0x0000000235357232ULL, 0x088fe40000000000ULL, 0x0000000237377232ULL, 0x000fe40000000000ULL,
0x0000000538387232ULL, 0x084fe40000000000ULL, 0x000000053a3a7232ULL, 0x000fc40000000000ULL,
0x0000000039397232ULL, 0x080fe40000000000ULL, 0x000000003b3b7232ULL, 0x000fce0000000000ULL,
0x000000086e5d7824ULL, 0x000fe200078e00ffULL, 0x000000004c4c783bULL, 0x000f220000004200ULL,
0x000000025c5c7836ULL, 0x000fe40000000000ULL, 0x00000001777c7824ULL, 0x000fc600078e027cULL,
0xfffffff85d5c7812ULL, 0x000fca00078ee25cULL, 0x000000105c5c7824ULL, 0x000fcc00078e026fULL,
0x000000005c5c783bULL, 0x000f620000004200ULL, 0x00000018ff677819ULL, 0x010fe4000001164eULL,
0x00000010ff907819ULL, 0x100fe4000001164dULL, 0x000000ff4d8c7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff897819ULL, 0x000fe4000001164dULL, 0x0000ffff4d8e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4d7819ULL, 0x000fc4000001164fULL, 0x0000ffff4c6c7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff8e7819ULL, 0x000fe4000001168eULL, 0x00000010ff8b7819ULL, 0x000fe4000001164eULL,
0x000000ff5d917812ULL, 0x028fe400078ec0ffULL, 0x00000010ff867819ULL, 0x000fe4000001165eULL,
0x000000ff5e937812ULL, 0x000fc400078ec0ffULL, 0x00000018ff927819ULL, 0x000fe4000001165eULL,
0x0000ffff5e687812ULL, 0x000fe400078ec0ffULL, 0x00000067ff5e723eULL, 0x000fe400020006ffULL,
0x00000091ff67723eULL, 0x000fe400020006ffULL, 0x000000ff90917812ULL, 0x000fe400078ec0ffULL,
0x000000ff4d4d7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff887819ULL, 0x000fe4000001164cULL,
0x000000ff4e877812ULL, 0x040fe400078ec0ffULL, 0x0000ffff4e8a7812ULL, 0x000fe400078ec0ffULL,
0x0000008cff8c723eULL, 0x000fe400020006ffULL, 0x00000008ff907819ULL, 0x000fe4000001166cULL,
0x00000091ff91723eULL, 0x000fc400020006ffULL, 0x00000010ff8f7819ULL, 0x000fe4000001164cULL,
0x00000010ff4e7819ULL, 0x000fe4000001165cULL, 0x00000092ff6c723eULL, 0x000fe400020006ffULL,
0x0000008eff92723eULL, 0x000fe400020006ffULL, 0x000000ff8b8b7812ULL, 0x000fe400078ec0ffULL,
0x0000004dff8e723eULL, 0x000fc400020006ffULL, 0x000000ff5c827812ULL, 0x000fe400078ec0ffULL,
0x00000018ff807819ULL, 0x000fe4000001165cULL, 0x00000088ff88723eULL, 0x000fe400020006ffULL,
0x00000090ff90723eULL, 0x000fe400020006ffULL, 0x000054108c4d7816ULL, 0x000fe40000000091ULL,
0x000000ff4c8d7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff697819ULL, 0x000fe4000001164fULL,
0x0000ffff5c5c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff8f8f7812ULL, 0x000fe400078ec0ffULL,
0x000000ff4e8c7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff6d7819ULL, 0x000fe4000001165dULL,
0x00000087ff87723eULL, 0x000fc400020006ffULL, 0x0000008bff8b723eULL, 0x000fe400020006ffULL,
0x0000ffff4f4c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff667819ULL, 0x100fe4000001165fULL,
0x000000ff5f947812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6a7819ULL, 0x000fe4000001165fULL,
0x0000ffff5f7e7812ULL, 0x000fc400078ec0ffULL, 0x00005410904e7816ULL, 0x000fe40000000088ULL,
0x000000ff4f6b7812ULL, 0x000fe400078ec0ffULL, 0x0000008dff8d723eULL, 0x000fe400020006ffULL,
0x00000069ff5f723eULL, 0x000fe400020006ffULL, 0x00000082ff82723eULL, 0x000fe400020006ffULL,
0x0000008fff8f723eULL, 0x000fc400020006ffULL, 0x0000008cff8c723eULL, 0x000fe400020006ffULL,
0x00000008ff887819ULL, 0x000fe4000001165cULL, 0x00000010ff4f7819ULL, 0x000fe4000001165dULL,
0x0000ffff5d837812ULL, 0x000fe400078ec0ffULL, 0x0000006dff69723eULL, 0x000fe400020006ffULL,
0x00000093ff6d723eULL, 0x000fc400020006ffULL, 0x00005410875c7816ULL, 0x000fe4000000008bULL,
0x00000008ff937819ULL, 0x000fe4000001164cULL, 0x000000ff66877812ULL, 0x000fe400078ec0ffULL,
0x00000080ff80723eULL, 0x000fe400020006ffULL, 0x000054108d4c7816ULL, 0x000fe4000000008fULL,
0x00000088ff88723eULL, 0x000fc400020006ffULL, 0x000000ff86867812ULL, 0x000fe400078ec0ffULL,
0x0000541082667816ULL, 0x000fe2000000008cULL, 0x0000004c3454723cULL, 0x002fe20000001854ULL,
0x00000008ff8a7819ULL, 0x000fe4000001168aULL, 0x000000ff4f8d7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff837819ULL, 0x000fe20000011683ULL, 0x0000004c380c723cULL, 0x000fe2000000180cULL,
0x00000008ff827819ULL, 0x000fc40000011668ULL, 0x00000008ff7e7819ULL, 0x000fe4000001167eULL,
0x0000006bff5d723eULL, 0x000fe400020006ffULL, 0x00000086ff86723eULL, 0x000fe200020006ffULL,
0x000000086e4c7824ULL, 0x000fe200078e00ffULL, 0x0000541088687816ULL, 0x000fe20000000080ULL,
0x00000008774d7824ULL, 0x000fe200078e00ffULL, 0x00000089ff89723eULL, 0x000fe400020006ffULL,
0x00000094ff6b723eULL, 0x000fc400020006ffULL, 0x0000008aff8a723eULL, 0x000fe400020006ffULL,
0x00000093ff93723eULL, 0x000fe400020006ffULL, 0x0000008dff8d723eULL, 0x000fe400020006ffULL,
0x00000083ff83723eULL, 0x000fe400020006ffULL, 0x00000087ff87723eULL, 0x000fe400020006ffULL,
0x0000006aff80723eULL, 0x000fc400020006ffULL, 0x00000082ff82723eULL, 0x000fe400020006ffULL,
0x0000007eff7e723eULL, 0x000fe400020006ffULL, 0x000054106d6a7816ULL, 0x000fe40000000086ULL,
0x00005410924f7816ULL, 0x000fe40000000089ULL, 0x000054105d5d7816ULL, 0x000fe4000000008eULL,
0x000054108a5e7816ULL, 0x000fc4000000005eULL, 0x00005410935f7816ULL, 0x000fe2000000005fULL,
0x0000004e343c723cULL, 0x000fe2000000183cULL, 0x0000541067677816ULL, 0x000fe4000000008dULL,
0x0000541083697816ULL, 0x000fe40000000069ULL, 0x000054106b6b7816ULL, 0x000fe20000000087ULL,
0x0000005c3440723cULL, 0x000fe20000001840ULL, 0x00005410826c7816ULL, 0x000fe4000000006cULL,
0x000054107e6d7816ULL, 0x000fc60000000080ULL, 0x0000005e3444723cULL, 0x000fec0000001844ULL,
0x000000663448723cULL, 0x000fec0000001848ULL, 0x000000683450723cULL, 0x000fec0000001850ULL,
0x0000006a3428723cULL, 0x000fec0000001828ULL, 0x0000006c3424723cULL, 0x000fec0000001824ULL,
0x0000004e3810723cULL, 0x000fe20000001810ULL, 0x0000000281347812ULL, 0x000fe200078efcffULL,
0x0000000877377824ULL, 0x000fc800078e00ffULL, 0x000000017f347824ULL, 0x000fe200078e0234ULL,
0x0000005c3814723cULL, 0x000fe60000001814ULL, 0x000000016e357824ULL, 0x100fe400078e0234ULL,
0x0000000177367824ULL, 0x000fe200078e0234ULL, 0x0000005e3818723cULL, 0x000fe40000001818ULL,
0xfffffff84c347812ULL, 0x000fe400078ee235ULL, 0xfffffff837367812ULL, 0x000fc400078ee236ULL,
0x00000066381c723cULL, 0x000fe2000000181cULL, 0x0000001034347824ULL, 0x100fe200078e027bULL,
0xfffffff84d4c7812ULL, 0x000fe200078ee27cULL, 0x00000010367b7824ULL, 0x000fc600078e027bULL,
0x000000683820723cULL, 0x000fe20000001820ULL, 0x000000003434783bULL, 0x000e620000000200ULL,
0x000000104c4c7824ULL, 0x000fc800078e026fULL, 0x0000006a3830723cULL, 0x000fec0000001830ULL,
0x0000006c3838723cULL, 0x000fe2000000182cULL, 0x000000007b2c783bULL, 0x0006a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000200947ULL, 0x000fde0003800000ULL,
0x0000000334347232ULL, 0x082fe40000000000ULL, 0x0000000336367232ULL, 0x000fe40000000000ULL,
0x0000000235357232ULL, 0x080fe40000000000ULL, 0x0000000237377232ULL, 0x000fe40000000000ULL,
0x000000052c2c7232ULL, 0x084fe40000000000ULL, 0x000000052e2e7232ULL, 0x000fc40000000000ULL,
0x000000002d2d7232ULL, 0x080fe40000000000ULL, 0x000000002f2f7232ULL, 0x000fce0000000000ULL,
0x00000008775d7824ULL, 0x000fe200078e00ffULL, 0x000000004c4c783bULL, 0x000f220000004200ULL,
0x000000027c7c7836ULL, 0x000fca0000000000ULL, 0xfffffff85d7c7812ULL, 0x000fca00078ee27cULL,
0x000000107c5c7824ULL, 0x000fcc00078e026fULL, 0x000000005c5c783bULL, 0x000f620000004200ULL,
0x00000018ff677819ULL, 0x010fe4000001164eULL, 0x00000010ff6b7819ULL, 0x100fe4000001164cULL,
0x000000ff4f6c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff4c867812ULL, 0x040fe400078ec0ffULL,
0x00000018ff827819ULL, 0x000fe4000001164cULL, 0x0000ffff4c907812ULL, 0x000fc400078ec0ffULL,
0x00000010ff8c7819ULL, 0x000fe4000001164dULL, 0x00000010ff887819ULL, 0x100fe4000001164fULL,
0x00000018ff697819ULL, 0x000fe4000001164fULL, 0x000000ff5d8b7812ULL, 0x028fe400078ec0ffULL,
0x00000010ff7f7819ULL, 0x100fe4000001165eULL, 0x00000018ff8d7819ULL, 0x000fc4000001165eULL,
0x000000ff5e8e7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff5e687812ULL, 0x000fe400078ec0ffULL,
0x00000067ff5e723eULL, 0x000fe400020006ffULL, 0x0000ffff4f4c7812ULL, 0x000fe400078ec0ffULL,
0x0000008bff67723eULL, 0x000fe400020006ffULL, 0x00000010ff4f7819ULL, 0x000fc4000001165dULL,
0x00000018ff6d7819ULL, 0x000fe4000001165dULL, 0x0000ffff5d807812ULL, 0x000fe400078ec0ffULL,
0x000000ff6b8b7812ULL, 0x000fe400078ec0ffULL, 0x0000006cff5d723eULL, 0x000fe400020006ffULL,
0x000000ff5f8f7812ULL, 0x000fe400078ec0ffULL, 0x0000008dff6c723eULL, 0x000fc400020006ffULL,
0x000000ff4d877812ULL, 0x040fe400078ec0ffULL, 0x00000018ff837819ULL, 0x000fe4000001164dULL,
0x0000ffff4d8a7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff897819ULL, 0x000fe4000001164eULL,
0x000000ff8c8d7812ULL, 0x000fe400078ec0ffULL, 0x000000ff4e817812ULL, 0x000fc400078ec0ffULL,
0x0000ffff4e4d7812ULL, 0x000fe400078ec0ffULL, 0x00000086ff86723eULL, 0x000fe400020006ffULL,
0x00000008ff8c7819ULL, 0x000fe40000011690ULL, 0x0000008bff8b723eULL, 0x000fe400020006ffULL,
0x00000010ff4e7819ULL, 0x000fe4000001165cULL, 0x0000008fff6b723eULL, 0x000fc400020006ffULL,
0x000000ff89897812ULL, 0x000fe400078ec0ffULL, 0x00000008ff8f7819ULL, 0x000fe4000001164cULL,
0x000000ff5c7e7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff7b7819ULL, 0x000fe4000001165cULL,
0x00000082ff82723eULL, 0x000fe400020006ffULL, 0x0000008cff8c723eULL, 0x000fc400020006ffULL,
0x00005410864c7816ULL, 0x000fe4000000008bULL, 0x0000ffff5c5c7812ULL, 0x000fe400078ec0ffULL,
0x000000ff4e867812ULL, 0x000fe400078ec0ffULL, 0x00000010ff667819ULL, 0x100fe4000001165fULL,
0x00000018ff6a7819ULL, 0x000fe4000001165fULL, 0x0000ffff5f7c7812ULL, 0x000fc400078ec0ffULL,
0x00000081ff81723eULL, 0x000fe400020006ffULL, 0x00000089ff89723eULL, 0x000fe400020006ffULL,
0x00000069ff5f723eULL, 0x000fe400020006ffULL, 0x000054108c4e7816ULL, 0x000fe40000000082ULL,
0x00000087ff87723eULL, 0x000fe400020006ffULL, 0x0000007eff7e723eULL, 0x000fc400020006ffULL,
0x0000006dff69723eULL, 0x000fe400020006ffULL, 0x0000008dff8d723eULL, 0x000fe400020006ffULL,
0x00000086ff86723eULL, 0x000fe400020006ffULL, 0x00000008ff827819ULL, 0x000fe4000001165cULL,
0x0000008eff6d723eULL, 0x000fe400020006ffULL, 0x000000ff888e7812ULL, 0x000fc400078ec0ffULL,
0x00005410815c7816ULL, 0x000fe40000000089ULL, 0x00000008ff887819ULL, 0x000fe4000001164dULL,
0x000000ff66817812ULL, 0x000fe400078ec0ffULL, 0x0000007bff7b723eULL, 0x000fe400020006ffULL,
0x00005410874d7816ULL, 0x000fe4000000008dULL, 0x00000082ff82723eULL, 0x000fc400020006ffULL,
0x000000ff7f7f7812ULL, 0x000fe400078ec0ffULL, 0x000054107e667816ULL, 0x000fe20000000086ULL,
0x0000004c3454723cULL, 0x002fe20000001854ULL, 0x00000008ff8a7819ULL, 0x000fe4000001168aULL,
0x000000ff4f877812ULL, 0x000fe400078ec0ffULL, 0x00000008ff807819ULL, 0x000fe20000011680ULL,
0x0000004c2c0c723cULL, 0x004fe2000000180cULL, 0x00000008ff7e7819ULL, 0x000fc40000011668ULL,
0x00000008ff7c7819ULL, 0x000fe4000001167cULL, 0x0000007fff7f723eULL, 0x000fe400020006ffULL,
0x0000541082687816ULL, 0x000fe4000000007bULL, 0x00000083ff83723eULL, 0x000fe400020006ffULL,
0x0000008aff8a723eULL, 0x000fe400020006ffULL, 0x0000008eff8e723eULL, 0x000fc400020006ffULL,
0x00000088ff88723eULL, 0x000fe400020006ffULL, 0x0000008fff8f723eULL, 0x000fe400020006ffULL,
0x00000087ff87723eULL, 0x000fe400020006ffULL, 0x00000080ff80723eULL, 0x000fe400020006ffULL,
0x00000081ff81723eULL, 0x000fe400020006ffULL, 0x0000006aff7b723eULL, 0x000fc400020006ffULL,
0x0000007eff7e723eULL, 0x000fe400020006ffULL, 0x0000007cff7c723eULL, 0x000fe400020006ffULL,
0x000054106d6a7816ULL, 0x000fe4000000007fULL, 0x000054108a4f7816ULL, 0x000fe40000000083ULL,
0x000054105d5d7816ULL, 0x000fe4000000008eULL, 0x00005410885e7816ULL, 0x000fc4000000005eULL,
0x000054108f5f7816ULL, 0x000fe2000000005fULL, 0x0000004e343c723cULL, 0x000fe2000000183cULL,
0x0000541067677816ULL, 0x000fe40000000087ULL, 0x0000541080697816ULL, 0x000fe40000000069ULL,
0x000054106b6b7816ULL, 0x000fe20000000081ULL, 0x0000005c3440723cULL, 0x000fe20000001840ULL,
0x000054107e6c7816ULL, 0x000fe4000000006cULL, 0x000054107c6d7816ULL, 0x000fc6000000007bULL,
0x0000005e3444723cULL, 0x000fec0000001844ULL, 0x000000663448723cULL, 0x000fec0000001848ULL,
0x000000683450723cULL, 0x000fec0000001850ULL, 0x0000006a3428723cULL, 0x000fec0000001828ULL,
0x0000006c3424723cULL, 0x000fec0000001824ULL, 0x0000004e2c10723cULL, 0x000fe20000001810ULL,
0x0000000278347824ULL, 0x000fc400078e00ffULL, 0x0000000860357824ULL, 0x000fe400078e0209ULL,
0x00000001ff377424ULL, 0x000fe200078e00ffULL, 0xfffffff834347812ULL, 0x000fe200078ec0ffULL,
0x0000005c2c14723cULL, 0x000fe80000001814ULL, 0x0000000109367824ULL, 0x000fe400078e0234ULL,
0x01a6c837353479a7ULL, 0x000e62000850003fULL, 0x0000005e2c18723cULL, 0x000fec0000001818ULL,
0x000000662c1c723cULL, 0x000fe2000000181cULL, 0x01a6883736ff79a7ULL, 0x0005ea000850003fULL,
0x000000682c20723cULL, 0x000fec0000001820ULL, 0x0000006a2c30723cULL, 0x000fec0000001830ULL,
0x0000006c2c38723cULL, 0x000fee0000001838ULL, 0x00000000002c7805ULL, 0x000fe20000015200ULL,
0x00000035060075a7ULL, 0x002e64000800017fULL, 0x00000000005c0947ULL, 0x006fdc0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000002e7805ULL, 0x000fcc0000015200ULL,
0x0000002e2c377210ULL, 0x000fca0007f1e1ffULL, 0x000000012f2f7824ULL, 0x000fe200000e0e2dULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff2e7819ULL, 0x000fc8000001142fULL, 0x000000372e2e7211ULL, 0x000fca00078110ffULL,
0x000000ffff2f7224ULL, 0x000fca00000e062fULL, 0x000000022e2e7819ULL, 0x000fc8000000122fULL,
0x0000002e0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x00000035060075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00000080712e7836ULL, 0x000fe20000000000ULL,
0x0000920000087ab9ULL, 0x000fc60000000800ULL, 0x0000000859357c24ULL, 0x000fe2000f8e022eULL,
0x0000000000f89947ULL, 0x000fec0003800000ULL, 0x0000002e612c7248ULL, 0x000fe20007fe0000ULL,
0x00000010642f7824ULL, 0x000fe200078e00ffULL, 0x00000003ff2d7819ULL, 0x000fe2000001160aULL,
0x00008e0000087ab9ULL, 0x000fe40000000a00ULL, 0x000000012c2c7824ULL, 0x000fe400078e0a2eULL,
0x000000012f2e7824ULL, 0x000fe400078e022dULL, 0x000000042d367836ULL, 0x000fe20000000000ULL,
0x0000002c2f2c7248ULL, 0x000fe20007fe0000ULL, 0x000000012e347824ULL, 0x000fc400078e020aULL,
0x000000082e377824ULL, 0x000fe400078e00ffULL, 0x000000012c2c7824ULL, 0x000fe400078e0a2fULL,
0x0000000c2d4d7836ULL, 0x000fe20000000000ULL, 0xfffffff8374c7812ULL, 0x000fe200078ee234ULL,
0x000000082d347836ULL, 0x000fe20000000000ULL, 0x0000002c3600720cULL, 0x080fe20003f66070ULL,
0x000000012f367824ULL, 0x000fe200078e0236ULL, 0x0000002c2d00720cULL, 0x080fe20003f86070ULL,
0x000000012e2d7824ULL, 0x000fe200078e0235ULL, 0x0000002c3400720cULL, 0x080fe20003f46070ULL,
0x00000001362e7824ULL, 0x040fe200078e020aULL, 0x0000002c4d00720cULL, 0x000fe20003f06070ULL,
0x00000008365d7824ULL, 0x000fc400078e00ffULL, 0x000000802d2c7825ULL, 0x000fc600078e00ffULL,
0xfffffff85d4e7812ULL, 0x000fe200078ee22eULL, 0x00000001362e7824ULL, 0x000fe200078e0235ULL,
0x000000722c2c7212ULL, 0x000fe200078efcffULL, 0x000000012f377824ULL, 0x040fe400078e0234ULL,
0x000000012f4f7824ULL, 0x000fe200078e024dULL, 0x000000082c2c7c10ULL, 0x000fe2000ffbe0ffULL,
0x000000802e2e7825ULL, 0x000fc600078e00ffULL, 0x000000092d2d7c10ULL, 0x000fe2000affe4ffULL,
0x0000000137347824ULL, 0x100fe200078e0235ULL, 0x000000722e2e7212ULL, 0x000fe200078efcffULL,
0x000000014f367824ULL, 0x000fe400078e0235ULL, 0x00000001374d7824ULL, 0x040fe200078e020aULL,
0x000000082e2e7c10ULL, 0x000fe2000ffbe0ffULL, 0x00000008375c7824ULL, 0x000fe400078e00ffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x000000092f2f7c10ULL, 0x000fc4000affe4ffULL,
0xfffffff85c5c7812ULL, 0x000fe200078ee24dULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000007234347212ULL, 0x000fc600078efcffULL, 0x000000014f4d7824ULL, 0x040fe200078e020aULL,
0x0000007236367212ULL, 0x000fe200078efcffULL, 0x000000084f5e7824ULL, 0x000fe200078e00ffULL,
0x0000000834347c10ULL, 0x000fe2000ffbe0ffULL, 0x000000104e4f7824ULL, 0x100fe200078e026fULL,
0x0000000836367c10ULL, 0x000fe2000ffde0ffULL, 0x000000105c5d7824ULL, 0x100fe200078e026fULL,
0xfffffff85e5e7812ULL, 0x000fe200078ee24dULL, 0x000000104c4d7824ULL, 0x100fe200078e026fULL,
0x0000000935357c10ULL, 0x000fe4000affe4ffULL, 0x0000000937377c10ULL, 0x000fe2000b7fe4ffULL,
0x000000105e5f7824ULL, 0x000fe200078e026fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c4d7faeULL, 0x0003e8000e101c46ULL, 0x000000002e4f7faeULL, 0x0003e8000d901c46ULL,
0x00000000345d7faeULL, 0x0003e8000d101c46ULL, 0x00000000365f7faeULL, 0x0003e2000c101c46ULL,
0x0000000000c47947ULL, 0x000fea0003800000ULL, 0x00000010642d7824ULL, 0x000fe200078e00ffULL,
0x00008e0000087ab9ULL, 0x000fc80000000a00ULL, 0x0000002d0a2d7211ULL, 0x000fca00078fe8ffULL,
0x000000012d2e7824ULL, 0x040fe400078e020aULL, 0x000000082d377824ULL, 0x040fe400078e00ffULL,
0x000000012d2c7824ULL, 0x000fe400078e0235ULL, 0x000000042d2f7836ULL, 0x000fe20000000000ULL,
0xfffffff8374c7812ULL, 0x000fe200078ee22eULL, 0x000000082d4d7836ULL, 0x000fe40000000000ULL,
0x0000000c2d2d7836ULL, 0x000fc40000000000ULL, 0x000000012f367824ULL, 0x140fe400078e0235ULL,
0x000000012f377824ULL, 0x140fe400078e020aULL, 0x000000082f4e7824ULL, 0x000fe400078e00ffULL,
0x000000014d2e7824ULL, 0x100fe400078e0235ULL, 0x000000012d347824ULL, 0x000fe200078e0235ULL,
0xfffffff84e4e7812ULL, 0x000fe200078ee237ULL, 0x000000014d2f7824ULL, 0x000fc400078e020aULL,
0x000000084d5c7824ULL, 0x000fe400078e00ffULL, 0x000000012d357824ULL, 0x040fe400078e020aULL,
0x000000082d5e7824ULL, 0x000fe200078e00ffULL, 0xfffffff85c5c7812ULL, 0x000fe200078ee22fULL,
0x000000802c2c7825ULL, 0x000fc600078e00ffULL, 0xfffffff85e5e7812ULL, 0x000fe200078ee235ULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x000000722c2c7212ULL, 0x000fc600078efcffULL,
0x000000802e2e7825ULL, 0x000fe200078e00ffULL, 0x0000007236367212ULL, 0x080fe400078efcffULL,
0x000000082c2c7c10ULL, 0x000fe2000ff1e0ffULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x000000722e2e7212ULL, 0x080fe400078efcffULL, 0x0000000836367c10ULL, 0x000fe2000ff5e0ffULL,
0x000000104c4d7824ULL, 0x100fe200078e026fULL, 0x0000007234347212ULL, 0x000fe200078efcffULL,
0x000000104e4f7824ULL, 0x100fe200078e026fULL, 0x000000092d2d7c10ULL, 0x000fe200087fe4ffULL,
0x000000105c5d7824ULL, 0x100fe200078e026fULL, 0x000000082e2e7c10ULL, 0x000fe2000ff1e0ffULL,
0x000000105e5f7824ULL, 0x000fe200078e026fULL, 0x0000000834347c10ULL, 0x000fe2000ff7e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c4d7faeULL, 0x0003e2000b901c46ULL,
0x0000000937377c10ULL, 0x000fc400097fe4ffULL, 0x000000092f2f7c10ULL, 0x000fe400087fe4ffULL,
0x0000000935357c10ULL, 0x000fe20009ffe4ffULL, 0x00000000364f7faeULL, 0x0003e8000b901c46ULL,
0x000000002e5d7faeULL, 0x0003e8000b901c46ULL, 0x00000000345f7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x00000001ff2e7424ULL, 0x000fe200078e00ffULL,
0x00000000ff0079b0ULL, 0x000fe20008000a45ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000002eff8279a7ULL, 0x0002a40008500005ULL, 0x01a6282e752e79a7ULL, 0x0022e4000850003fULL,
0x00000000002c7805ULL, 0x000fce0000015200ULL, 0xffffffe062347812ULL, 0x040fe400078ec0ffULL,
0x0000001062357812ULL, 0x000fc800078ec0ffULL, 0x0000000935357210ULL, 0x000fca0007ffe034ULL,
0x00000008644d7824ULL, 0x000fc800078e0235ULL, 0x01a6282f4d0075a7ULL, 0x008ee4000800017fULL,
0x00000000005c0947ULL, 0x008fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000347805ULL, 0x000fce0000015200ULL, 0x000000342c377210ULL, 0x000fca0007f1e1ffULL,
0x0000000135357824ULL, 0x000fe200000e0e2dULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff347819ULL, 0x000fc80000011435ULL,
0x0000003734347211ULL, 0x000fca00078110ffULL, 0x000000ffff357224ULL, 0x000fca00000e0635ULL,
0x0000000234347819ULL, 0x000fc80000001235ULL, 0x000000340000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x01a6282f4d0075a7ULL, 0x000ee4000800017fULL, 0xfffffffc00a88947ULL, 0x008fea000383ffffULL,
0x00000020782c7824ULL, 0x000fe400078e00ffULL, 0x00000001ff347424ULL, 0x000fe400078e00ffULL,
0x000000ffff7f7224ULL, 0x000fe200078e007aULL, 0xffffff802c2c7812ULL, 0x000fc800078ec0ffULL,
0x00000080092c7810ULL, 0x000fc80007ffe02cULL, 0x0000002c732c7210ULL, 0x000fca0007ffe072ULL,
0x01a000002c2d7984ULL, 0x000ee80000000800ULL, 0x01a200002c2e7984ULL, 0x0009220000000800ULL,
0x0000007a2d00720bULL, 0x008fda0003f1d000ULL, 0x0000000000357806ULL, 0x000fc800000e0100ULL,
0x000000ff3500720cULL, 0x000fda0003f05270ULL, 0x0000000400948947ULL, 0x016fea0003800000ULL,
0x00000001582f7836ULL, 0x000fe20000000000ULL, 0x0000007a2d00720bULL, 0x0c0fe40003f14000ULL,
0x0000007a2d7f7209ULL, 0x000fe40007810000ULL, 0x000000782f00720cULL, 0x000fd20003f45270ULL,
0x0000000000347806ULL, 0x000fc800000e0100ULL, 0x00000080782ca824ULL, 0x000fe200078e0209ULL,
0x000000ff3400720cULL, 0x000fc80003f05270ULL, 0x0000002c732ca210ULL, 0x000fca0007ffe072ULL,
0x01a4007f2c00a388ULL, 0x0003e80000000800ULL, 0x0000000400508947ULL, 0x000fea0003800000ULL,
0x0000007a7f2c7221ULL, 0x002fe20000010100ULL, 0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL, 0x3fb8aa3b2c2c7820ULL, 0x000fe20000410000ULL,
0x00ff000034ff7812ULL, 0x040fe4000786c0ffULL, 0xff00000034ff7812ULL, 0x000fe2000788c0ffULL,
0x0000002c00367308ULL, 0x0002ac0000000800ULL, 0x0000000000488947ULL, 0x000fec0003800000ULL,
0x00000002ff2f7819ULL, 0x000fca000001160aULL, 0x00001f2f362c7589ULL, 0x006e6400000e0000ULL,
0x000000542c547220ULL, 0x042fe20000410000ULL, 0x000000552c557220ULL, 0x040fe20000410000ULL,
0x0000003c2c3c7220ULL, 0x040fe20000410000ULL, 0x0000003d2c3d7220ULL, 0x040fe20000410000ULL,
0x000000402c407220ULL, 0x040fe20000410000ULL, 0x000000412c417220ULL, 0x040fe20000410000ULL,
0x000000442c447220ULL, 0x040fe20000410000ULL, 0x000000452c457220ULL, 0x040fe20000410000ULL,
0x000000482c487220ULL, 0x040fe20000410000ULL, 0x000000492c497220ULL, 0x040fe20000410000ULL,
0x000000502c507220ULL, 0x040fe20000410000ULL, 0x000000512c517220ULL, 0x040fe20000410000ULL,
0x000000282c287220ULL, 0x040fe20000410000ULL, 0x000000292c297220ULL, 0x040fe20000410000ULL,
0x000000242c247220ULL, 0x040fe20000410000ULL, 0x000000252c257220ULL, 0x000fce0000410000ULL,
0x000000000048a947ULL, 0x000fea0003800000ULL, 0x000000080a2f7811ULL, 0x000fca00078ff0ffULL,
0x00001f2f362c7589ULL, 0x006e6400000e0000ULL, 0x000000562c567220ULL, 0x042fe20000410000ULL,
0x000000572c577220ULL, 0x040fe20000410000ULL, 0x0000003e2c3e7220ULL, 0x040fe20000410000ULL,
0x0000003f2c3f7220ULL, 0x040fe20000410000ULL, 0x000000422c427220ULL, 0x040fe20000410000ULL,
0x000000432c437220ULL, 0x040fe20000410000ULL, 0x000000462c467220ULL, 0x040fe20000410000ULL,
0x000000472c477220ULL, 0x040fe20000410000ULL, 0x0000004a2c4a7220ULL, 0x040fe20000410000ULL,
0x0000004b2c4b7220ULL, 0x040fe20000410000ULL, 0x000000522c527220ULL, 0x040fe20000410000ULL,
0x000000532c537220ULL, 0x040fe20000410000ULL, 0x0000002a2c2a7220ULL, 0x040fe20000410000ULL,
0x0000002b2c2b7220ULL, 0x040fe20000410000ULL, 0x000000262c267220ULL, 0x040fe20000410000ULL,
0x000000272c277220ULL, 0x000fce0000410000ULL, 0x000000000048b947ULL, 0x000fea0003800000ULL,
0x000000100a2f7811ULL, 0x000fca00078ff0ffULL, 0x00001f2f362c7589ULL, 0x006e6400000e0000ULL,
0x0000000c2c0c7220ULL, 0x042fe20000410000ULL, 0x0000000d2c0d7220ULL, 0x040fe20000410000ULL,
0x000000102c107220ULL, 0x040fe20000410000ULL, 0x000000112c117220ULL, 0x040fe20000410000ULL,
0x000000142c147220ULL, 0x040fe20000410000ULL, 0x000000152c157220ULL, 0x040fe20000410000ULL,
0x000000182c187220ULL, 0x040fe20000410000ULL, 0x000000192c197220ULL, 0x040fe20000410000ULL,
0x0000001c2c1c7220ULL, 0x040fe20000410000ULL, 0x0000001d2c1d7220ULL, 0x040fe20000410000ULL,
0x000000202c207220ULL, 0x040fe20000410000ULL, 0x000000212c217220ULL, 0x040fe20000410000ULL,
0x000000302c307220ULL, 0x040fe20000410000ULL, 0x000000312c317220ULL, 0x040fe20000410000ULL,
0x000000382c387220ULL, 0x040fe20000410000ULL, 0x000000392c397220ULL, 0x000fce0000410000ULL,
0x000000367d7d7220ULL, 0x004fe20000410000ULL, 0x000000000048c947ULL, 0x000fec0003800000ULL,
0x000000180a2f7811ULL, 0x000fca00078ff0ffULL, 0x00001f2f362c7589ULL, 0x002e6400000e0000ULL,
0x0000000e2c0e7220ULL, 0x042fe20000410000ULL, 0x0000000f2c0f7220ULL, 0x040fe20000410000ULL,
0x000000122c127220ULL, 0x040fe20000410000ULL, 0x000000132c137220ULL, 0x040fe20000410000ULL,
0x000000162c167220ULL, 0x040fe20000410000ULL, 0x000000172c177220ULL, 0x040fe20000410000ULL,
0x0000001a2c1a7220ULL, 0x040fe20000410000ULL, 0x0000001b2c1b7220ULL, 0x040fe20000410000ULL,
0x0000001e2c1e7220ULL, 0x040fe20000410000ULL, 0x0000001f2c1f7220ULL, 0x040fe20000410000ULL,
0x000000222c227220ULL, 0x040fe20000410000ULL, 0x000000232c237220ULL, 0x040fe20000410000ULL,
0x000000322c327220ULL, 0x040fe20000410000ULL, 0x000000332c337220ULL, 0x040fe20000410000ULL,
0x0000003a2c3a7220ULL, 0x040fe20000410000ULL, 0x0000003b2c3b7220ULL, 0x000fce0000410000ULL,
0x0000003435ff7212ULL, 0x000fe200078030ffULL, 0x00000001ff347424ULL, 0x000fd800078e00ffULL,
0x8000007f2d2d0221ULL, 0x000fe20000010000ULL, 0x00007610ff340816ULL, 0x000fc60000000034ULL,
0x3fb8aa3b2d2d0820ULL, 0x000fc80000410000ULL, 0x0000002d00040308ULL, 0x000ea40000000800ULL,
0x000000042e2e0220ULL, 0x004fce0000410000ULL, 0x0000007d2e7d7221ULL, 0x000fe20000010000ULL,
0x00000000002c7805ULL, 0x002fe40000015200ULL, 0xfffffff0622e7812ULL, 0x000fca00078ec0ffULL,
0x0000000109377824ULL, 0x000fc800078e022eULL, 0x01a6b085370075a7ULL, 0x000ea4000800017fULL,
0x00000000005c0947ULL, 0x006fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000002e7805ULL, 0x000fcc0000015200ULL, 0x0000002e2c357210ULL, 0x000fca0007f1e1ffULL,
0x000000012f2f7824ULL, 0x000fe200000e0e2dULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff2e7819ULL, 0x000fc8000001142fULL,
0x000000352e2e7211ULL, 0x000fca00078110ffULL, 0x000000ffff2f7224ULL, 0x000fca00000e062fULL,
0x000000022e2e7819ULL, 0x000fc8000000122fULL, 0x0000002e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x01a6b085370075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00009910342e7816ULL, 0x000fe200000000ffULL, 0x00000004782d7824ULL, 0x040fe400078e00ffULL,
0x00000400782f7824ULL, 0x000fe200078e00ffULL, 0x000000ff2e00720cULL, 0x000fe20003f05270ULL,
0x00001000782c7824ULL, 0x000fe200078e00ffULL, 0x000000042d2d7812ULL, 0x000fe400078ec0ffULL,
0xfffff0002f7c7812ULL, 0x000fe400078ec0ffULL, 0x0000002d0a7a7211ULL, 0x000fe200078fe0ffULL,
0x000000086e2d7824ULL, 0x000fe200078e00ffULL, 0xffffe0002c2c7812ULL, 0x000fc400078ec0ffULL,
0x00013000097c7810ULL, 0x040fe20007ffe07cULL, 0x000000016e5c7824ULL, 0x000fe200078e027aULL,
0x00017000095d7810ULL, 0x000fc60007ffe02cULL, 0x00000010742c7824ULL, 0x100fe200078e027cULL,
0xfffffff82d747812ULL, 0x000fe200078ee25cULL, 0x0000001079347824ULL, 0x000fe200078e027cULL,
0x0000000000280947ULL, 0x000fec0003800000ULL, 0x00000002ff2e7819ULL, 0x000fe4000001160aULL,
0x00000004ff00723eULL, 0x000fc600000000ffULL, 0x000000082e027836ULL, 0x000fe20000000000ULL,
0x00005410002d7816ULL, 0x000fe20000000000ULL, 0x000000102e367836ULL, 0x000fe40000000000ULL,
0x000000182e4c7836ULL, 0x000fe40000000000ULL, 0x00001f022d027589ULL, 0x0002a800000e0000ULL,
0x00001f362d057589ULL, 0x0002e800000e0000ULL, 0x00001f2e2d037589ULL, 0x00026800000e0000ULL,
0x00001f4c2d007589ULL, 0x00026400000e0000ULL, 0x000000003434783bULL, 0x002e620000000200ULL,
0x00000010744c7824ULL, 0x000fc600078e025dULL, 0x000000002c2c783bULL, 0x000ee20000000200ULL,
0x0000000000200947ULL, 0x000fea0003800000ULL, 0x0000000334347232ULL, 0x082fe40000000000ULL,
0x0000000336367232ULL, 0x000fe40000000000ULL, 0x0000000235357232ULL, 0x084fe40000000000ULL,
0x0000000237377232ULL, 0x000fe40000000000ULL, 0x000000052c2c7232ULL, 0x088fe40000000000ULL,
0x000000052e2e7232ULL, 0x000fc40000000000ULL, 0x000000002d2d7232ULL, 0x080fe40000000000ULL,
0x000000002f2f7232ULL, 0x000fce0000000000ULL, 0x000000086e5f7824ULL, 0x000fe200078e00ffULL,
0x000000004c4c783bULL, 0x000f220000004200ULL, 0x000000025c7e7836ULL, 0x000fca0000000000ULL,
0xfffffff85f7e7812ULL, 0x000fca00078ee27eULL, 0x000000107e5d7824ULL, 0x000fcc00078e025dULL,
0x000000005d5c783bULL, 0x000f620000004200ULL, 0x00000010ff8d7819ULL, 0x010fe4000001164cULL,
0x00000018ff677819ULL, 0x000fe4000001164eULL, 0x00000010ff8e7819ULL, 0x000fe4000001164dULL,
0x000000ff4c887812ULL, 0x040fe400078ec0ffULL, 0x0000ffff4c6c7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff697819ULL, 0x000fc4000001164fULL, 0x000000ff8d8d7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff867819ULL, 0x000fe4000001164cULL, 0x000000ff4d897812ULL, 0x000fe400078ec0ffULL,
0x000000ff5d8f7812ULL, 0x028fe400078ec0ffULL, 0x00000010ff817819ULL, 0x000fe4000001165eULL,
0x000000ff5e917812ULL, 0x000fc400078ec0ffULL, 0x00000018ff907819ULL, 0x000fe4000001165eULL,
0x0000ffff5e687812ULL, 0x000fe400078ec0ffULL, 0x00000018ff6d7819ULL, 0x000fe4000001165dULL,
0x00000067ff5e723eULL, 0x000fe400020006ffULL, 0x0000008fff67723eULL, 0x000fe400020006ffULL,
0x00000018ff877819ULL, 0x000fc4000001164dULL, 0x0000ffff4d8c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8b7819ULL, 0x000fe4000001164eULL, 0x0000ffff4f4c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff667819ULL, 0x100fe4000001165fULL, 0x000000ff5f927812ULL, 0x000fe400078ec0ffULL,
0x00000018ff6a7819ULL, 0x000fc4000001165fULL, 0x0000ffff5f797812ULL, 0x000fe400078ec0ffULL,
0x000000ff8e8f7812ULL, 0x000fe400078ec0ffULL, 0x000000ff4e857812ULL, 0x040fe400078ec0ffULL,
0x0000ffff4e4d7812ULL, 0x000fe400078ec0ffULL, 0x00000088ff88723eULL, 0x000fe400020006ffULL,
0x00000069ff5f723eULL, 0x000fc400020006ffULL, 0x00000008ff8e7819ULL, 0x000fe4000001166cULL,
0x0000008dff8d723eULL, 0x000fe400020006ffULL, 0x00000010ff4e7819ULL, 0x000fe4000001165cULL,
0x0000006dff69723eULL, 0x000fe400020006ffULL, 0x00000091ff6d723eULL, 0x000fe400020006ffULL,
0x000000ff8b8b7812ULL, 0x000fc400078ec0ffULL, 0x00000008ff917819ULL, 0x000fe4000001164cULL,
0x000000ff5c807812ULL, 0x000fe400078ec0ffULL, 0x00000018ff7b7819ULL, 0x000fe4000001165cULL,
0x00000086ff86723eULL, 0x000fe400020006ffULL, 0x0000008eff8e723eULL, 0x000fe400020006ffULL,
0x00005410884c7816ULL, 0x000fc4000000008dULL, 0x0000ffff5c5c7812ULL, 0x000fe400078ec0ffULL,
0x000000ff4e887812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8a7819ULL, 0x000fe4000001164fULL,
0x00000085ff85723eULL, 0x000fe400020006ffULL, 0x0000008bff8b723eULL, 0x000fe400020006ffULL,
0x000054108e4e7816ULL, 0x000fc40000000086ULL, 0x000000ff4f6b7812ULL, 0x000fe400078ec0ffULL,
0x00000089ff89723eULL, 0x000fe400020006ffULL, 0x00000080ff80723eULL, 0x000fe400020006ffULL,
0x0000008fff8f723eULL, 0x000fe400020006ffULL, 0x00000088ff88723eULL, 0x000fe400020006ffULL,
0x00000008ff867819ULL, 0x000fc4000001165cULL, 0x00000010ff4f7819ULL, 0x000fe4000001165dULL,
0x0000ffff5d847812ULL, 0x000fe400078ec0ffULL, 0x00000090ff6c723eULL, 0x000fe400020006ffULL,
0x000000ff8a907812ULL, 0x000fe400078ec0ffULL, 0x00005410855c7816ULL, 0x000fe4000000008bULL,
0x00000008ff8a7819ULL, 0x000fc4000001164dULL, 0x000000ff66857812ULL, 0x000fe400078ec0ffULL,
0x0000007bff7b723eULL, 0x000fe400020006ffULL, 0x00005410894d7816ULL, 0x000fe4000000008fULL,
0x00000086ff86723eULL, 0x000fe400020006ffULL, 0x000000ff81817812ULL, 0x000fe400078ec0ffULL,
0x0000541080667816ULL, 0x000fe20000000088ULL, 0x0000004c3454723cULL, 0x002fe20000001854ULL,
0x00000008ff8c7819ULL, 0x000fc4000001168cULL, 0x000000ff4f897812ULL, 0x000fe400078ec0ffULL,
0x00000008ff847819ULL, 0x000fe20000011684ULL, 0x0000004c2c0c723cULL, 0x000fe2000000180cULL,
0x00000008ff807819ULL, 0x000fe40000011668ULL, 0x00000008ff797819ULL, 0x000fe40000011679ULL,
0x0000006bff5d723eULL, 0x000fe400020006ffULL, 0x00000081ff81723eULL, 0x000fc400020006ffULL,
0x0000541086687816ULL, 0x000fe4000000007bULL, 0x00000087ff87723eULL, 0x000fe400020006ffULL,
0x00000092ff6b723eULL, 0x000fe400020006ffULL, 0x0000008cff8c723eULL, 0x000fe400020006ffULL,
0x00000090ff90723eULL, 0x000fe400020006ffULL, 0x0000008aff8a723eULL, 0x000fc400020006ffULL,
0x00000091ff91723eULL, 0x000fe400020006ffULL, 0x00000089ff89723eULL, 0x000fe400020006ffULL,
0x00000084ff84723eULL, 0x000fe400020006ffULL, 0x00000085ff85723eULL, 0x000fe400020006ffULL,
0x0000006aff7b723eULL, 0x000fe400020006ffULL, 0x00000080ff80723eULL, 0x000fc400020006ffULL,
0x00000079ff79723eULL, 0x000fe400020006ffULL, 0x000054106d6a7816ULL, 0x000fe40000000081ULL,
0x000054108c4f7816ULL, 0x000fe40000000087ULL, 0x000054105d5d7816ULL, 0x000fe40000000090ULL,
0x000054108a5e7816ULL, 0x000fe4000000005eULL, 0x00005410915f7816ULL, 0x000fe2000000005fULL,
0x0000004e343c723cULL, 0x000fe2000000183cULL, 0x0000541067677816ULL, 0x000fc40000000089ULL,
0x0000541084697816ULL, 0x000fe40000000069ULL, 0x000054106b6b7816ULL, 0x000fe20000000085ULL,
0x0000005c3440723cULL, 0x000fe20000001840ULL, 0x00005410806c7816ULL, 0x000fe2000000006cULL,
0x0000000278807824ULL, 0x000fe200078e00ffULL, 0x00005410796d7816ULL, 0x000fc6000000007bULL,
0x0000005e3444723cULL, 0x000fec0000001844ULL, 0x000000663448723cULL, 0x000fec0000001848ULL,
0x000000683450723cULL, 0x000fec0000001850ULL, 0x0000006a3428723cULL, 0x000fec0000001828ULL,
0x0000006c3424723cULL, 0x000fec0000001824ULL, 0x0000005c2c14723cULL, 0x000fe20000001814ULL,
0x0000000480347812ULL, 0x000fe200078ec0ffULL, 0x0000000877367824ULL, 0x000fc600078e00ffULL,
0x0000000234357812ULL, 0x000fe200078efcffULL, 0x000000086e347824ULL, 0x000fe200078e00ffULL,
0x0000004e2c10723cULL, 0x000fe20000001810ULL, 0x00000001775c7824ULL, 0x000fe200078e027aULL,
0x000000350a357211ULL, 0x000fe200078fe0ffULL, 0x00017000705d7836ULL, 0x000fc60000000000ULL,
0x0000005e2c18723cULL, 0x000fe20000001818ULL, 0x000000016e7b7824ULL, 0x100fe400078e0235ULL,
0x0000000177797824ULL, 0x040fe400078e0235ULL, 0x0000000877357824ULL, 0x000fe200078e00ffULL,
0xfffffff8347b7812ULL, 0x000fe200078ee27bULL, 0x000000662c1c723cULL, 0x000fe2000000181cULL,
0xfffffff836797812ULL, 0x000fe400078ee279ULL, 0xfffffff8357a7812ULL, 0x000fe200078ee25cULL,
0x000000107b347824ULL, 0x000fc400078e027cULL, 0x00000010797c7824ULL, 0x000fe200078e027cULL,
0x000000682c20723cULL, 0x000fe20000001820ULL, 0x000000107a4c7824ULL, 0x000fe400078e025dULL,
0x000000003434783bULL, 0x000e660000000200ULL, 0x0000006a2c30723cULL, 0x000fec0000001830ULL,
0x0000006c2c38723cULL, 0x000fe20000001838ULL, 0x000000007c2c783bULL, 0x0006a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000200947ULL, 0x000fde0003800000ULL,
0x0000000334347232ULL, 0x082fe40000000000ULL, 0x0000000336367232ULL, 0x000fe40000000000ULL,
0x0000000235357232ULL, 0x084fe40000000000ULL, 0x0000000237377232ULL, 0x000fe40000000000ULL,
0x000000052c2c7232ULL, 0x080fe40000000000ULL, 0x000000052e2e7232ULL, 0x000fc40000000000ULL,
0x000000002d2d7232ULL, 0x080fe40000000000ULL, 0x000000002f2f7232ULL, 0x000fce0000000000ULL,
0x00000008775f7824ULL, 0x000fe200078e00ffULL, 0x000000004c4c783bULL, 0x000f220000004200ULL,
0x000000025c7c7836ULL, 0x008fe20000000000ULL, 0xfffffff880807812ULL, 0x000fc800078ec0ffULL,
0xfffffff85f7c7812ULL, 0x000fe200078ee27cULL, 0x0000000109807824ULL, 0x000fc800078e0280ULL,
0x000000107c5c7824ULL, 0x000fcc00078e025dULL, 0x000000005c5c783bULL, 0x000ee20000004200ULL,
0x00000010ff907819ULL, 0x010fe4000001164cULL, 0x00000018ff677819ULL, 0x000fe4000001164eULL,
0x00000010ff917819ULL, 0x000fe4000001164dULL, 0x000000ff4c8e7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff4c6b7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff697819ULL, 0x000fc4000001164fULL,
0x000000ff90907812ULL, 0x000fe400078ec0ffULL, 0x00000018ff897819ULL, 0x000fe4000001164cULL,
0x00000010ff8c7819ULL, 0x000fe4000001164eULL, 0x000000ff5d927812ULL, 0x008fe400078ec0ffULL,
0x00000010ff867819ULL, 0x100fe4000001165eULL, 0x00000018ff937819ULL, 0x000fc4000001165eULL,
0x000000ff5e947812ULL, 0x040fe400078ec0ffULL, 0x0000ffff5e687812ULL, 0x000fe400078ec0ffULL,
0x00000018ff6d7819ULL, 0x000fe4000001165dULL, 0x00000067ff5e723eULL, 0x000fe400020006ffULL,
0x00000092ff67723eULL, 0x000fe400020006ffULL, 0x0000ffff4f4c7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff667819ULL, 0x100fe4000001165fULL, 0x00000018ff6a7819ULL, 0x000fe4000001165fULL,
0x000000ff5f957812ULL, 0x040fe400078ec0ffULL, 0x0000ffff5f817812ULL, 0x000fe400078ec0ffULL,
0x000000ff91927812ULL, 0x000fe400078ec0ffULL, 0x000000ff4e887812ULL, 0x000fc400078ec0ffULL,
0x0000ffff4e8b7812ULL, 0x000fe400078ec0ffULL, 0x0000008eff8e723eULL, 0x000fe400020006ffULL,
0x00000069ff5f723eULL, 0x000fe400020006ffULL, 0x00000008ff917819ULL, 0x000fe4000001166bULL,
0x00000090ff90723eULL, 0x000fe400020006ffULL, 0x00000010ff4e7819ULL, 0x000fc4000001165cULL,
0x0000006dff69723eULL, 0x000fe400020006ffULL, 0x00000094ff6d723eULL, 0x000fe400020006ffULL,
0x000000ff4d8f7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff8a7819ULL, 0x000fe4000001164dULL,
0x0000ffff4d8d7812ULL, 0x000fe400078ec0ffULL, 0x000000ff8c8c7812ULL, 0x000fc400078ec0ffULL,
0x00000008ff947819ULL, 0x000fe4000001164cULL, 0x00000010ff4d7819ULL, 0x000fe4000001164fULL,
0x000000ff5c857812ULL, 0x000fe400078ec0ffULL, 0x00000018ff847819ULL, 0x000fe4000001165cULL,
0x00000089ff89723eULL, 0x000fe400020006ffULL, 0x00000091ff91723eULL, 0x000fc400020006ffULL,
0x000054108e4c7816ULL, 0x000fe40000000090ULL, 0x000000ff4f6c7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff5c5c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff4e8e7812ULL, 0x000fe400078ec0ffULL,
0x00000088ff88723eULL, 0x000fe400020006ffULL, 0x00000008ff8d7819ULL, 0x000fc4000001168dULL,
0x0000008cff8c723eULL, 0x000fe400020006ffULL, 0x00000010ff4f7819ULL, 0x000fe4000001165dULL,
0x0000ffff5d877812ULL, 0x000fe400078ec0ffULL, 0x000000ff4d4d7812ULL, 0x000fe400078ec0ffULL,
0x00005410914e7816ULL, 0x000fe40000000089ULL, 0x0000008fff8f723eULL, 0x000fc400020006ffULL,
0x0000006cff5d723eULL, 0x000fe400020006ffULL, 0x00000085ff85723eULL, 0x000fe400020006ffULL,
0x00000092ff92723eULL, 0x000fe400020006ffULL, 0x0000008eff8e723eULL, 0x000fe400020006ffULL,
0x00000008ff897819ULL, 0x000fe4000001165cULL, 0x00000093ff6c723eULL, 0x000fc400020006ffULL,
0x0000008dff93723eULL, 0x000fe400020006ffULL, 0x00005410885c7816ULL, 0x000fe4000000008cULL,
0x0000004dff8d723eULL, 0x000fe400020006ffULL, 0x000000ff66887812ULL, 0x000fe400078ec0ffULL,
0x00000084ff84723eULL, 0x000fe400020006ffULL, 0x000054108f4d7816ULL, 0x000fc40000000092ULL,
0x00000089ff89723eULL, 0x000fe400020006ffULL, 0x000000ff86867812ULL, 0x000fe400078ec0ffULL,
0x0000541085667816ULL, 0x000fe2000000008eULL, 0x0000004c3454723cULL, 0x002fe20000001854ULL,
0x00000008ff8b7819ULL, 0x000fe4000001168bULL, 0x000000ff4f8f7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff877819ULL, 0x000fe20000011687ULL, 0x0000004c2c0c723cULL, 0x004fe2000000180cULL,
0x00000008ff857819ULL, 0x000fc40000011668ULL, 0x00000008ff817819ULL, 0x000fe40000011681ULL,
0x00000086ff86723eULL, 0x000fe400020006ffULL, 0x0000541089687816ULL, 0x000fe40000000084ULL,
0x0000008aff8a723eULL, 0x000fe400020006ffULL, 0x00000095ff6b723eULL, 0x000fe400020006ffULL,
0x0000008bff8b723eULL, 0x000fc400020006ffULL, 0x00000094ff94723eULL, 0x000fe400020006ffULL,
0x0000008fff8f723eULL, 0x000fe400020006ffULL, 0x00000087ff87723eULL, 0x000fe400020006ffULL,
0x00000088ff88723eULL, 0x000fe400020006ffULL, 0x0000006aff84723eULL, 0x000fe400020006ffULL,
0x00000085ff85723eULL, 0x000fc400020006ffULL, 0x00000081ff81723eULL, 0x000fe400020006ffULL,
0x000054106d6a7816ULL, 0x000fe40000000086ULL, 0x00005410934f7816ULL, 0x000fe4000000008aULL,
0x000054105d5d7816ULL, 0x000fe4000000008dULL, 0x000054108b5e7816ULL, 0x000fe4000000005eULL,
0x00005410945f7816ULL, 0x000fe2000000005fULL, 0x0000004e343c723cULL, 0x000fe2000000183cULL,
0x0000541067677816ULL, 0x000fc4000000008fULL, 0x0000541087697816ULL, 0x000fe40000000069ULL,
0x000054106b6b7816ULL, 0x000fe20000000088ULL, 0x0000005c3440723cULL, 0x000fe20000001840ULL,
0x00005410856c7816ULL, 0x000fe4000000006cULL, 0x00005410816d7816ULL, 0x000fc60000000084ULL,
0x0000005e3444723cULL, 0x000fec0000001844ULL, 0x000000663448723cULL, 0x000fec0000001848ULL,
0x000000683450723cULL, 0x000fec0000001850ULL, 0x0000006a3428723cULL, 0x000fec0000001828ULL,
0x0000006c3424723cULL, 0x000fec0000001824ULL, 0x0000004e2c10723cULL, 0x000fe20000001810ULL,
0x0000000860347824ULL, 0x000fc400078e0209ULL, 0x00000001ff377424ULL, 0x000fc600078e00ffULL,
0x0000005c2c14723cULL, 0x000fe20000001814ULL, 0x01a6c837343479a7ULL, 0x000e6a000850003fULL,
0x0000005e2c18723cULL, 0x000fe20000001818ULL, 0x01a6903780ff79a7ULL, 0x0005ea000850003fULL,
0x000000662c1c723cULL, 0x000fec000000181cULL, 0x000000682c20723cULL, 0x000fec0000001820ULL,
0x0000006a2c30723cULL, 0x000fec0000001830ULL, 0x0000006c2c38723cULL, 0x000fee0000001838ULL,
0x00000000002c7805ULL, 0x000fe20000015200ULL, 0x00000035060075a7ULL, 0x002e64000800017fULL,
0x00000000005c0947ULL, 0x006fdc0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000002e7805ULL, 0x000fcc0000015200ULL, 0x0000002e2c377210ULL, 0x000fca0007f1e1ffULL,
0x000000012f2f7824ULL, 0x000fe200000e0e2dULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff2e7819ULL, 0x000fc8000001142fULL,
0x000000372e2e7211ULL, 0x000fca00078110ffULL, 0x000000ffff2f7224ULL, 0x000fca00000e062fULL,
0x000000022e2e7819ULL, 0x000fc8000000122fULL, 0x0000002e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x00000035060075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000c0712e7836ULL, 0x000fe20000000000ULL, 0x0000920000087ab9ULL, 0x000fc60000000800ULL,
0x0000000859367c24ULL, 0x000fe2000f8e022eULL, 0x0000000000fc9947ULL, 0x000fec0003800000ULL,
0x0000002e612c7248ULL, 0x000fe20007fe0000ULL, 0x00000010642d7824ULL, 0x000fe200078e00ffULL,
0x00000003ff2f7819ULL, 0x000fe2000001160aULL, 0x00008e0000087ab9ULL, 0x000fe40000000a00ULL,
0x000000012c2c7824ULL, 0x000fe400078e0a2eULL, 0x000000012d357824ULL, 0x000fe400078e022fULL,
0x000000042f347836ULL, 0x000fe20000000000ULL, 0x0000002c2d2c7248ULL, 0x000fe20007fe0000ULL,
0x00000001352e7824ULL, 0x000fc400078e020aULL, 0x00000008354d7824ULL, 0x000fe400078e00ffULL,
0x000000012c2c7824ULL, 0x000fe400078e0a2dULL, 0x0000000c2f4c7836ULL, 0x000fe20000000000ULL,
0xfffffff84d4d7812ULL, 0x000fe200078ee22eULL, 0x000000082f2e7836ULL, 0x000fe20000000000ULL,
0x0000002c2f00720cULL, 0x080fe20003f86070ULL, 0x000000012d2f7824ULL, 0x040fe200078e0234ULL,
0x0000002c3400720cULL, 0x080fe20003f66070ULL, 0x000000012d377824ULL, 0x040fe200078e022eULL,
0x0000002c2e00720cULL, 0x080fe20003f46070ULL, 0x000000012d5f7824ULL, 0x000fe200078e024cULL,
0x0000002c4c00720cULL, 0x000fe20003f06070ULL, 0x000000012f2d7824ULL, 0x000fc400078e020aULL,
0x000000082f347824ULL, 0x000fe400078e00ffULL, 0x00000001372e7824ULL, 0x040fe400078e020aULL,
0x00000008375d7824ULL, 0x000fe200078e00ffULL, 0xfffffff8344f7812ULL, 0x000fe200078ee22dULL,
0x00000001352c7824ULL, 0x100fe400078e0236ULL, 0x000000012f347824ULL, 0x000fe200078e0236ULL,
0xfffffff85d5d7812ULL, 0x000fe200078ee22eULL, 0x000000015f2f7824ULL, 0x000fc400078e020aULL,
0x000000085f4c7824ULL, 0x000fe400078e00ffULL, 0x000000802c2c7825ULL, 0x000fc800078e00ffULL,
0x00000001372e7824ULL, 0x000fe200078e0236ULL, 0x000000722c2c7212ULL, 0x000fe200078efcffULL,
0x0000008034347825ULL, 0x000fc600078e00ffULL, 0x000000082c2c7c10ULL, 0x000fe2000ffbe0ffULL,
0x000000015f367824ULL, 0x000fe200078e0236ULL, 0xfffffff84c5f7812ULL, 0x000fe200078ee22fULL,
0x000000802e2e7825ULL, 0x000fe200078e00ffULL, 0x0000007234347212ULL, 0x080fe400078efcffULL,
0x000000092d2d7c10ULL, 0x000fe2000affe4ffULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000000834347c10ULL, 0x000fe4000ffde0ffULL, 0x000000722e2e7212ULL, 0x080fe200078efcffULL,
0x00017000704c7836ULL, 0x000fe20000000000ULL, 0x0000007236367212ULL, 0x000fc400078efcffULL,
0x0000000935357c10ULL, 0x000fe2000b7fe4ffULL, 0x000000104d4d7824ULL, 0x100fe200078e024cULL,
0x000000082e2e7c10ULL, 0x000fe2000ffbe0ffULL, 0x000000104f4f7824ULL, 0x100fe200078e024cULL,
0x0000000836367c10ULL, 0x000fe2000ffde0ffULL, 0x000000105d5d7824ULL, 0x100fe200078e024cULL,
0x000000092f2f7c10ULL, 0x000fe2000affe4ffULL, 0x000000105f5f7824ULL, 0x000fe200078e024cULL,
0x0000000937377c10ULL, 0x000fe2000b7fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c4d7faeULL, 0x0003e8000e101c46ULL, 0x00000000344f7faeULL, 0x0003e8000d901c46ULL,
0x000000002e5d7faeULL, 0x0003e8000d101c46ULL, 0x00000000365f7faeULL, 0x0003e2000c101c46ULL,
0x0000000000c87947ULL, 0x000fea0003800000ULL, 0x00000010642d7824ULL, 0x000fe200078e00ffULL,
0x00008e0000087ab9ULL, 0x000fc80000000a00ULL, 0x0000002d0a2d7211ULL, 0x000fca00078fe8ffULL,
0x000000012d2e7824ULL, 0x040fe400078e020aULL, 0x000000082d4d7824ULL, 0x040fe400078e00ffULL,
0x000000042d2f7836ULL, 0x000fe40000000000ULL, 0x000000082d377836ULL, 0x000fe20000000000ULL,
0xfffffff84d4d7812ULL, 0x000fe200078ee22eULL, 0x000000012d2c7824ULL, 0x000fe400078e0236ULL,
0x0000000c2d4f7836ULL, 0x000fc40000000000ULL, 0x000000012f2e7824ULL, 0x040fe400078e0236ULL,
0x000000012f357824ULL, 0x140fe400078e020aULL, 0x000000082f4c7824ULL, 0x000fe400078e00ffULL,
0x00000001372f7824ULL, 0x040fe400078e020aULL, 0x00000008374e7824ULL, 0x000fe400078e00ffULL,
0x000000802c2c7825ULL, 0x000fc600078e00ffULL, 0xfffffff84e5d7812ULL, 0x000fe200078ee22fULL,
0x0000000137347824ULL, 0x000fe200078e0236ULL, 0x000000722c2c7212ULL, 0x000fe200078efcffULL,
0x000000014f377824ULL, 0x040fe400078e020aULL, 0x000000084f5c7824ULL, 0x040fe200078e00ffULL,
0x000000082c2c7c10ULL, 0x000fe2000ff1e0ffULL, 0x000000014f367824ULL, 0x000fe200078e0236ULL,
0xfffffff84c4f7812ULL, 0x000fe200078ee235ULL, 0x000000802e2e7825ULL, 0x000fe200078e00ffULL,
0xfffffff85c5f7812ULL, 0x000fc400078ee237ULL, 0x000000092d2d7c10ULL, 0x000fe200087fe4ffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x000000722e2e7212ULL, 0x000fc600078efcffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000007234347212ULL, 0x080fe400078efcffULL,
0x000000082e2e7c10ULL, 0x000fe2000ff1e0ffULL, 0x00017000704c7836ULL, 0x000fe20000000000ULL,
0x0000007236367212ULL, 0x000fe400078efcffULL, 0x0000000834347c10ULL, 0x000fe2000ff5e0ffULL,
0x000000104d4d7824ULL, 0x100fe200078e024cULL, 0x0000000836367c10ULL, 0x000fe2000ff7e0ffULL,
0x000000104f4f7824ULL, 0x100fe200078e024cULL, 0x000000092f2f7c10ULL, 0x000fe200087fe4ffULL,
0x000000105d5d7824ULL, 0x100fe200078e024cULL, 0x0000000935357c10ULL, 0x000fe200097fe4ffULL,
0x000000105f5f7824ULL, 0x000fe200078e024cULL, 0x0000000937377c10ULL, 0x000fe20009ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c4d7faeULL, 0x0003e8000b901c46ULL,
0x000000002e4f7faeULL, 0x0003e8000b901c46ULL, 0x00000000345d7faeULL, 0x0003e8000b901c46ULL,
0x00000000365f7faeULL, 0x0003e4000b901c46ULL, 0x0000000804087890ULL, 0x000fe2000fffe03fULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0xfffffff062847812ULL, 0x000fe200078ec0ffULL,
0x00000001ff2c7424ULL, 0x000fc600078e00ffULL, 0x0001a6a884847810ULL, 0x000fc60007ffe009ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a48ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000082c848479a7ULL, 0x0002a4000850003fULL, 0x01a6482c752c79a7ULL, 0x0022e4000850003fULL,
0x00000000002e7805ULL, 0x000fce0000015200ULL, 0xffffffe062347812ULL, 0x040fe400078ec0ffULL,
0x0000001062357812ULL, 0x040fe400078ec0ffULL, 0x0000000862367812ULL, 0x000fe400078ec0ffULL,
0x0000000935357210ULL, 0x000fca0007ffe034ULL, 0x00000001354d7824ULL, 0x000fc800078e0236ULL,
0x01a6482d4d0075a7ULL, 0x008ee4000800017fULL, 0x00000000005c0947ULL, 0x008fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fce0000015200ULL,
0x000000342e377210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e2fULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff347819ULL, 0x000fc80000011435ULL, 0x0000003734347211ULL, 0x000fca00078110ffULL,
0x000000ffff357224ULL, 0x000fca00000e0635ULL, 0x0000000234347819ULL, 0x000fc80000001235ULL,
0x000000340000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x01a6482d4d0075a7ULL, 0x000ee4000800017fULL,
0xfffffffc00a88947ULL, 0x008fea000383ffffULL, 0x00000020782c7824ULL, 0x000fe400078e00ffULL,
0x00000001ff347424ULL, 0x000fc600078e00ffULL, 0xffffff802c2c7812ULL, 0x000fc800078ec0ffULL,
0x00000100092c7810ULL, 0x000fc80007ffe02cULL, 0x0000002c732c7210ULL, 0x000fca0007ffe072ULL,
0x01a000002c2e7984ULL, 0x000ee80000000800ULL, 0x01a200002c2d7984ULL, 0x0009220000000800ULL,
0x0000007f2e00720bULL, 0x008fda0003f1d000ULL, 0x0000000000357806ULL, 0x000fc800000e0100ULL,
0x000000ff3500720cULL, 0x000fda0003f05270ULL, 0x00000004009c8947ULL, 0x016fea0003800000ULL,
0x00000002582f7836ULL, 0x000fe20000000000ULL, 0x0000007f2e00720bULL, 0x000fc80003f14000ULL,
0x000000782f00720cULL, 0x000fe40003f45270ULL, 0x0000007f2e2f7209ULL, 0x000fce0007810000ULL,
0x0000000000347806ULL, 0x000fc800000e0100ULL, 0x00000080782ca824ULL, 0x000fe200078e0209ULL,
0x000000ff3400720cULL, 0x000fc80003f05270ULL, 0x0000002c732ca210ULL, 0x000fca0007ffe072ULL,
0x01a4002f2c00a388ULL, 0x0003e80000000800ULL, 0x0000000400508947ULL, 0x000fea0003800000ULL,
0x8000002f7f7f7221ULL, 0x000fe20000010000ULL, 0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0034ff7812ULL, 0x040fe2000784c0ffULL, 0x3fb8aa3b7f7f7820ULL, 0x000fe20000410000ULL,
0x00ff000034ff7812ULL, 0x040fe4000786c0ffULL, 0xff00000034ff7812ULL, 0x000fe2000788c0ffULL,
0x0000007f00367308ULL, 0x0004ec0000000800ULL, 0x0000000000488947ULL, 0x000fec0003800000ULL,
0x00000002ff377819ULL, 0x000fca000001160aULL, 0x00001f37362c7589ULL, 0x00ae6400000e0000ULL,
0x000000542c547220ULL, 0x042fe20000410000ULL, 0x000000552c557220ULL, 0x040fe20000410000ULL,
0x0000003c2c3c7220ULL, 0x040fe20000410000ULL, 0x0000003d2c3d7220ULL, 0x040fe20000410000ULL,
0x000000402c407220ULL, 0x040fe20000410000ULL, 0x000000412c417220ULL, 0x040fe20000410000ULL,
0x000000442c447220ULL, 0x040fe20000410000ULL, 0x000000452c457220ULL, 0x040fe20000410000ULL,
0x000000482c487220ULL, 0x040fe20000410000ULL, 0x000000492c497220ULL, 0x040fe20000410000ULL,
0x000000502c507220ULL, 0x040fe20000410000ULL, 0x000000512c517220ULL, 0x040fe20000410000ULL,
0x000000282c287220ULL, 0x040fe20000410000ULL, 0x000000292c297220ULL, 0x040fe20000410000ULL,
0x000000242c247220ULL, 0x040fe20000410000ULL, 0x000000252c257220ULL, 0x000fce0000410000ULL,
0x000000000048a947ULL, 0x000fea0003800000ULL, 0x000000080a377811ULL, 0x000fca00078ff0ffULL,
0x00001f37362c7589ULL, 0x00ae6400000e0000ULL, 0x000000562c567220ULL, 0x042fe20000410000ULL,
0x000000572c577220ULL, 0x040fe20000410000ULL, 0x0000003e2c3e7220ULL, 0x040fe20000410000ULL,
0x0000003f2c3f7220ULL, 0x040fe20000410000ULL, 0x000000422c427220ULL, 0x040fe20000410000ULL,
0x000000432c437220ULL, 0x040fe20000410000ULL, 0x000000462c467220ULL, 0x040fe20000410000ULL,
0x000000472c477220ULL, 0x040fe20000410000ULL, 0x0000004a2c4a7220ULL, 0x040fe20000410000ULL,
0x0000004b2c4b7220ULL, 0x040fe20000410000ULL, 0x000000522c527220ULL, 0x040fe20000410000ULL,
0x000000532c537220ULL, 0x040fe20000410000ULL, 0x0000002a2c2a7220ULL, 0x040fe20000410000ULL,
0x0000002b2c2b7220ULL, 0x040fe20000410000ULL, 0x000000262c267220ULL, 0x040fe20000410000ULL,
0x000000272c277220ULL, 0x000fce0000410000ULL, 0x000000000048b947ULL, 0x000fea0003800000ULL,
0x000000100a377811ULL, 0x000fca00078ff0ffULL, 0x00001f37362c7589ULL, 0x00ae6400000e0000ULL,
0x0000000c2c0c7220ULL, 0x042fe20000410000ULL, 0x0000000d2c0d7220ULL, 0x040fe20000410000ULL,
0x000000102c107220ULL, 0x040fe20000410000ULL, 0x000000112c117220ULL, 0x040fe20000410000ULL,
0x000000142c147220ULL, 0x040fe20000410000ULL, 0x000000152c157220ULL, 0x040fe20000410000ULL,
0x000000182c187220ULL, 0x040fe20000410000ULL, 0x000000192c197220ULL, 0x040fe20000410000ULL,
0x0000001c2c1c7220ULL, 0x040fe20000410000ULL, 0x0000001d2c1d7220ULL, 0x040fe20000410000ULL,
0x000000202c207220ULL, 0x040fe20000410000ULL, 0x000000212c217220ULL, 0x040fe20000410000ULL,
0x000000302c307220ULL, 0x040fe20000410000ULL, 0x000000312c317220ULL, 0x040fe20000410000ULL,
0x000000382c387220ULL, 0x040fe20000410000ULL, 0x000000392c397220ULL, 0x000fce0000410000ULL,
0x000000367d7d7220ULL, 0x008fe20000410000ULL, 0x000000000048c947ULL, 0x000fec0003800000ULL,
0x000000180a377811ULL, 0x000fca00078ff0ffULL, 0x00001f37362c7589ULL, 0x002e6400000e0000ULL,
0x0000000e2c0e7220ULL, 0x042fe20000410000ULL, 0x0000000f2c0f7220ULL, 0x040fe20000410000ULL,
0x000000122c127220ULL, 0x040fe20000410000ULL, 0x000000132c137220ULL, 0x040fe20000410000ULL,
0x000000162c167220ULL, 0x040fe20000410000ULL, 0x000000172c177220ULL, 0x040fe20000410000ULL,
0x0000001a2c1a7220ULL, 0x040fe20000410000ULL, 0x0000001b2c1b7220ULL, 0x040fe20000410000ULL,
0x0000001e2c1e7220ULL, 0x040fe20000410000ULL, 0x0000001f2c1f7220ULL, 0x040fe20000410000ULL,
0x000000222c227220ULL, 0x040fe20000410000ULL, 0x000000232c237220ULL, 0x040fe20000410000ULL,
0x000000322c327220ULL, 0x040fe20000410000ULL, 0x000000332c337220ULL, 0x040fe20000410000ULL,
0x0000003a2c3a7220ULL, 0x040fe20000410000ULL, 0x0000003b2c3b7220ULL, 0x000fce0000410000ULL,
0x0000003435ff7212ULL, 0x000fe200078030ffULL, 0x00000001ff347424ULL, 0x000fe400078e00ffULL,
0x000000ffff7f7224ULL, 0x004fd400078e002fULL, 0x8000002f2e2e0221ULL, 0x100fe20000010000ULL,
0x000000ffff7f0224ULL, 0x000fe200078e002fULL, 0x00007610ff340816ULL, 0x000fe40000000034ULL,
0x3fb8aa3b2e2e0820ULL, 0x000fc80000410000ULL, 0x0000002e00040308ULL, 0x000ea40000000800ULL,
0x000000042d2d0220ULL, 0x004fce0000410000ULL, 0x0000007d2d7d7221ULL, 0x000fe20000010000ULL,
0x00000000002c7805ULL, 0x002fe20000015200ULL, 0x00000083ff0075a7ULL, 0x000ea40008000145ULL,
0x00000000005c0947ULL, 0x006fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000002e7805ULL, 0x000fcc0000015200ULL, 0x0000002e2c357210ULL, 0x000fca0007f1e1ffULL,
0x000000012f2f7824ULL, 0x000fe200000e0e2dULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff2e7819ULL, 0x000fc8000001142fULL,
0x000000352e2e7211ULL, 0x000fca00078110ffULL, 0x000000ffff2f7224ULL, 0x000fca00000e062fULL,
0x000000022e2e7819ULL, 0x000fc8000000122fULL, 0x0000002e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x00000083ff0075a7ULL, 0x000e640008000145ULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000278757824ULL, 0x000fe200078e00ffULL, 0x00009910342e7816ULL, 0x000fe200000000ffULL,
0x00000400782f7824ULL, 0x000fe400078e00ffULL, 0x000000086e347824ULL, 0x000fe200078e00ffULL,
0x00000004752d7812ULL, 0x000fe200078ec0ffULL, 0x0000000877357824ULL, 0x000fe200078e00ffULL,
0x000000ff2e00720cULL, 0x000fe20003f05270ULL, 0x00000010744c7824ULL, 0x000fe200078e026fULL,
0x0000002d0a2c7211ULL, 0x000fe400078fe0ffULL, 0xfffff0002f807812ULL, 0x000fc600078ec0ffULL,
0x000000016e2d7824ULL, 0x000fe200078e022cULL, 0x0001400009807810ULL, 0x000fe20007ffe080ULL,
0x00000001772c7824ULL, 0x000fc600078e022cULL, 0xfffffff8342d7812ULL, 0x000fe400078ee22dULL,
0xfffffff8352f7812ULL, 0x000fc600078ee22cULL, 0x000000102d347824ULL, 0x100fe400078e0280ULL,
0x000000102f2f7824ULL, 0x000fe200078e0280ULL, 0x0000000000280947ULL, 0x000fec0003800000ULL,
0x00000002ff037819ULL, 0x000fe4000001160aULL, 0x00000004ff00723eULL, 0x000fc600000000ffULL,
0x0000001003057836ULL, 0x000fe20000000000ULL, 0x00005410002c7816ULL, 0x000fe20000000000ULL,
0x00000008032d7836ULL, 0x000fe40000000000ULL, 0x0000001803357836ULL, 0x000fe40000000000ULL,
0x00001f052c057589ULL, 0x0002a800000e0000ULL, 0x00001f2d2c027589ULL, 0x0002e800000e0000ULL,
0x00001f032c037589ULL, 0x00026800000e0000ULL, 0x00001f352c007589ULL, 0x00026400000e0000ULL,
0x000000003434783bULL, 0x002e680000000200ULL, 0x000000002f2c783bULL, 0x000ee20000000200ULL,
0x0000000000200947ULL, 0x000fea0003800000ULL, 0x0000000334347232ULL, 0x082fe40000000000ULL,
0x0000000336367232ULL, 0x000fe40000000000ULL, 0x0000000235357232ULL, 0x088fe40000000000ULL,
0x0000000237377232ULL, 0x000fe40000000000ULL, 0x000000052c2c7232ULL, 0x084fe40000000000ULL,
0x000000052e2e7232ULL, 0x000fc40000000000ULL, 0x000000002d2d7232ULL, 0x080fe40000000000ULL,
0x000000002f2f7232ULL, 0x000fce0000000000ULL, 0x000000107e5c7824ULL, 0x000fe200078e026fULL,
0x000000004c4c783bULL, 0x000f2a0000004200ULL, 0x000000005c5c783bULL, 0x000f620000004200ULL,
0x00000018ff677819ULL, 0x010fe4000001164eULL, 0x00000010ff907819ULL, 0x000fe4000001164dULL,
0x000000ff4d8c7812ULL, 0x000fc400078ec0ffULL, 0x000000ff5d917812ULL, 0x028fe400078ec0ffULL,
0x00000010ff867819ULL, 0x100fe4000001165eULL, 0x00000018ff927819ULL, 0x000fe4000001165eULL,
0x000000ff5e937812ULL, 0x040fe400078ec0ffULL, 0x0000ffff5e687812ULL, 0x000fe400078ec0ffULL,
0x00000018ff897819ULL, 0x000fc4000001164dULL, 0x0000ffff4d8e7812ULL, 0x000fe400078ec0ffULL,
0x00000067ff5e723eULL, 0x000fe400020006ffULL, 0x00000010ff4d7819ULL, 0x000fe4000001164fULL,
0x00000091ff67723eULL, 0x000fe400020006ffULL, 0x0000ffff4c6b7812ULL, 0x000fe400078ec0ffULL,
0x000000ff4f6c7812ULL, 0x000fc400078ec0ffULL, 0x000000ff90917812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8f7819ULL, 0x100fe4000001164cULL, 0x000000ff4c8d7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff887819ULL, 0x000fe4000001164cULL, 0x00000018ff697819ULL, 0x000fe4000001164fULL,
0x0000ffff4f4c7812ULL, 0x000fc400078ec0ffULL, 0x00000008ff8e7819ULL, 0x000fe4000001168eULL,
0x00000010ff8b7819ULL, 0x000fe4000001164eULL, 0x00000010ff4f7819ULL, 0x100fe4000001165dULL,
0x00000018ff6d7819ULL, 0x000fe4000001165dULL, 0x0000ffff5d837812ULL, 0x000fe400078ec0ffULL,
0x000000ff4d4d7812ULL, 0x000fc400078ec0ffULL, 0x000000ff4e877812ULL, 0x040fe400078ec0ffULL,
0x0000ffff4e8a7812ULL, 0x000fe400078ec0ffULL, 0x0000008cff8c723eULL, 0x000fe400020006ffULL,
0x0000006cff5d723eULL, 0x000fe400020006ffULL, 0x00000008ff907819ULL, 0x000fe4000001166bULL,
0x00000091ff91723eULL, 0x000fc400020006ffULL, 0x00000010ff4e7819ULL, 0x000fe4000001165cULL,
0x00000092ff6c723eULL, 0x000fe400020006ffULL, 0x0000008eff92723eULL, 0x000fe400020006ffULL,
0x000000ff8b8b7812ULL, 0x000fe400078ec0ffULL, 0x0000004dff8e723eULL, 0x000fe400020006ffULL,
0x000000ff5c827812ULL, 0x000fc400078ec0ffULL, 0x00000018ff817819ULL, 0x000fe4000001165cULL,
0x00000088ff88723eULL, 0x000fe400020006ffULL, 0x00000090ff90723eULL, 0x000fe400020006ffULL,
0x000054108c4d7816ULL, 0x000fe40000000091ULL, 0x0000ffff5c5c7812ULL, 0x000fe400078ec0ffULL,
0x000000ff8f8f7812ULL, 0x000fc400078ec0ffULL, 0x000000ff4e8c7812ULL, 0x000fe400078ec0ffULL,
0x00000087ff87723eULL, 0x000fe400020006ffULL, 0x0000008bff8b723eULL, 0x000fe400020006ffULL,
0x00000010ff667819ULL, 0x100fe4000001165fULL, 0x00000018ff6a7819ULL, 0x000fe4000001165fULL,
0x000000ff5f947812ULL, 0x000fc400078ec0ffULL, 0x0000ffff5f7e7812ULL, 0x000fe400078ec0ffULL,
0x00005410904e7816ULL, 0x000fe40000000088ULL, 0x0000008dff8d723eULL, 0x000fe400020006ffULL,
0x00000069ff5f723eULL, 0x000fe400020006ffULL, 0x00000082ff82723eULL, 0x000fe400020006ffULL,
0x0000008fff8f723eULL, 0x000fc400020006ffULL, 0x0000008cff8c723eULL, 0x000fe400020006ffULL,
0x00000008ff887819ULL, 0x000fe4000001165cULL, 0x0000006dff69723eULL, 0x000fe400020006ffULL,
0x00000093ff6d723eULL, 0x000fe400020006ffULL, 0x00005410875c7816ULL, 0x000fe4000000008bULL,
0x00000008ff937819ULL, 0x000fc4000001164cULL, 0x000000ff66877812ULL, 0x000fe400078ec0ffULL,
0x00000081ff81723eULL, 0x000fe400020006ffULL, 0x000054108d4c7816ULL, 0x000fe4000000008fULL,
0x00000088ff88723eULL, 0x000fe400020006ffULL, 0x000000ff86867812ULL, 0x000fe400078ec0ffULL,
0x0000541082667816ULL, 0x000fe2000000008cULL, 0x0000004c3454723cULL, 0x002fe20000001854ULL,
0x00000008ff8a7819ULL, 0x000fc4000001168aULL, 0x000000ff4f8d7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff837819ULL, 0x000fe20000011683ULL, 0x0000004c2c0c723cULL, 0x000fe2000000180cULL,
0x00000008ff827819ULL, 0x000fe40000011668ULL, 0x00000008ff7e7819ULL, 0x000fe4000001167eULL,
0x00000086ff86723eULL, 0x000fe400020006ffULL, 0x0000541088687816ULL, 0x000fe20000000081ULL,
0x000000107a4c7824ULL, 0x000fe200078e026fULL, 0x00000089ff89723eULL, 0x000fc400020006ffULL,
0x00000094ff6b723eULL, 0x000fe400020006ffULL, 0x0000008aff8a723eULL, 0x000fe400020006ffULL,
0x00000093ff93723eULL, 0x000fe400020006ffULL, 0x0000008dff8d723eULL, 0x000fe400020006ffULL,
0x00000083ff83723eULL, 0x000fe400020006ffULL, 0x00000087ff87723eULL, 0x000fc400020006ffULL,
0x0000006aff81723eULL, 0x000fe400020006ffULL, 0x00000082ff82723eULL, 0x000fe400020006ffULL,
0x0000007eff7e723eULL, 0x000fe400020006ffULL, 0x000054106d6a7816ULL, 0x000fe40000000086ULL,
0x00005410924f7816ULL, 0x000fe40000000089ULL, 0x000054105d5d7816ULL, 0x000fc4000000008eULL,
0x000054108a5e7816ULL, 0x000fe4000000005eULL, 0x00005410935f7816ULL, 0x000fe2000000005fULL,
0x0000004e343c723cULL, 0x000fe2000000183cULL, 0x0000541067677816ULL, 0x000fe4000000008dULL,
0x0000541083697816ULL, 0x000fe40000000069ULL, 0x000054106b6b7816ULL, 0x000fe20000000087ULL,
0x0000005c3440723cULL, 0x000fe20000001840ULL, 0x00005410826c7816ULL, 0x000fc4000000006cULL,
0x000054107e6d7816ULL, 0x000fc60000000081ULL, 0x0000005e3444723cULL, 0x000fec0000001844ULL,
0x000000663448723cULL, 0x000fec0000001848ULL, 0x000000683450723cULL, 0x000fec0000001850ULL,
0x0000006a3428723cULL, 0x000fec0000001828ULL, 0x0000006c3424723cULL, 0x000fec0000001824ULL,
0x0000004e2c10723cULL, 0x000fe20000001810ULL, 0x000000107b347824ULL, 0x000fc400078e0280ULL,
0x0000001079807824ULL, 0x000fc600078e0280ULL, 0x0000005c2c14723cULL, 0x000fe20000001814ULL,
0x000000003434783bULL, 0x000e6a0000000200ULL, 0x0000005e2c18723cULL, 0x000fec0000001818ULL,
0x000000662c1c723cULL, 0x000fec000000181cULL, 0x000000682c20723cULL, 0x000fec0000001820ULL,
0x0000006a2c30723cULL, 0x000fec0000001830ULL, 0x0000006c2c38723cULL, 0x000fe20000001838ULL,
0x00000000802c783bULL, 0x0006a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000200947ULL, 0x000fde0003800000ULL, 0x0000000334347232ULL, 0x082fe40000000000ULL,
0x0000000336367232ULL, 0x000fe40000000000ULL, 0x0000000235357232ULL, 0x080fe40000000000ULL,
0x0000000237377232ULL, 0x000fe40000000000ULL, 0x000000052c2c7232ULL, 0x084fe40000000000ULL,
0x000000052e2e7232ULL, 0x000fc40000000000ULL, 0x000000002d2d7232ULL, 0x080fe40000000000ULL,
0x000000002f2f7232ULL, 0x000fce0000000000ULL, 0x000000107c5c7824ULL, 0x000fe200078e026fULL,
0x000000004c4c783bULL, 0x000f2a0000004200ULL, 0x000000005c5c783bULL, 0x000f620000004200ULL,
0x00000010ff8d7819ULL, 0x010fe4000001164cULL, 0x00000018ff677819ULL, 0x000fe4000001164eULL,
0x00000010ff8e7819ULL, 0x000fc4000001164dULL, 0x000000ff5d8f7812ULL, 0x028fe400078ec0ffULL,
0x000000ff4c887812ULL, 0x040fe400078ec0ffULL, 0x0000ffff4c6b7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff697819ULL, 0x000fe4000001164fULL, 0x00000010ff817819ULL, 0x100fe4000001165eULL,
0x00000018ff907819ULL, 0x000fc4000001165eULL, 0x000000ff5e917812ULL, 0x040fe400078ec0ffULL,
0x0000ffff5e687812ULL, 0x000fe400078ec0ffULL, 0x000000ff8d8d7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff6d7819ULL, 0x000fe4000001165dULL, 0x00000067ff5e723eULL, 0x000fe400020006ffULL,
0x00000018ff867819ULL, 0x000fc4000001164cULL, 0x0000008fff67723eULL, 0x000fe400020006ffULL,
0x000000ff4d897812ULL, 0x040fe400078ec0ffULL, 0x00000018ff877819ULL, 0x000fe4000001164dULL,
0x0000ffff4d8c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8b7819ULL, 0x000fe4000001164eULL,
0x0000ffff4f4c7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff667819ULL, 0x100fe4000001165fULL,
0x00000018ff6a7819ULL, 0x000fe4000001165fULL, 0x000000ff5f927812ULL, 0x040fe400078ec0ffULL,
0x0000ffff5f7c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff8e8f7812ULL, 0x000fe400078ec0ffULL,
0x000000ff4e837812ULL, 0x000fc400078ec0ffULL, 0x0000ffff4e4d7812ULL, 0x000fe400078ec0ffULL,
0x00000088ff88723eULL, 0x000fe400020006ffULL, 0x00000069ff5f723eULL, 0x000fe400020006ffULL,
0x00000008ff8e7819ULL, 0x000fe4000001166bULL, 0x0000008dff8d723eULL, 0x000fe400020006ffULL,
0x00000010ff4e7819ULL, 0x000fc4000001165cULL, 0x0000006dff69723eULL, 0x000fe400020006ffULL,
0x00000091ff6d723eULL, 0x000fe400020006ffULL, 0x000000ff8b8b7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff917819ULL, 0x000fe4000001164cULL, 0x000000ff5c807812ULL, 0x000fe400078ec0ffULL,
0x00000018ff7e7819ULL, 0x000fc4000001165cULL, 0x00000086ff86723eULL, 0x000fe400020006ffULL,
0x0000008eff8e723eULL, 0x000fe400020006ffULL, 0x00005410884c7816ULL, 0x000fe4000000008dULL,
0x000000ff4f6c7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff5c5c7812ULL, 0x000fe400078ec0ffULL,
0x000000ff4e887812ULL, 0x000fc400078ec0ffULL, 0x00000010ff8a7819ULL, 0x000fe4000001164fULL,
0x00000083ff83723eULL, 0x000fe400020006ffULL, 0x0000008bff8b723eULL, 0x000fe400020006ffULL,
0x00000010ff4f7819ULL, 0x000fe4000001165dULL, 0x0000ffff5d827812ULL, 0x000fe400078ec0ffULL,
0x000054108e4e7816ULL, 0x000fc40000000086ULL, 0x00000089ff89723eULL, 0x000fe400020006ffULL,
0x0000006cff5d723eULL, 0x000fe400020006ffULL, 0x00000080ff80723eULL, 0x000fe400020006ffULL,
0x0000008fff8f723eULL, 0x000fe400020006ffULL, 0x00000088ff88723eULL, 0x000fe400020006ffULL,
0x00000008ff867819ULL, 0x000fc4000001165cULL, 0x00000090ff6c723eULL, 0x000fe400020006ffULL,
0x000000ff8a907812ULL, 0x000fe400078ec0ffULL, 0x00005410835c7816ULL, 0x000fe4000000008bULL,
0x00000008ff8a7819ULL, 0x000fe4000001164dULL, 0x000000ff66837812ULL, 0x000fe400078ec0ffULL,
0x0000007eff7e723eULL, 0x000fc400020006ffULL, 0x00005410894d7816ULL, 0x000fe4000000008fULL,
0x00000086ff86723eULL, 0x000fe400020006ffULL, 0x000000ff81817812ULL, 0x000fe400078ec0ffULL,
0x0000541080667816ULL, 0x000fe20000000088ULL, 0x0000004c3454723cULL, 0x002fe20000001854ULL,
0x00000008ff8c7819ULL, 0x000fe4000001168cULL, 0x000000ff4f897812ULL, 0x000fc400078ec0ffULL,
0x00000008ff827819ULL, 0x000fe20000011682ULL, 0x0000004c2c0c723cULL, 0x004fe2000000180cULL,
0x00000008ff807819ULL, 0x000fe40000011668ULL, 0x00000008ff7c7819ULL, 0x000fe4000001167cULL,
0x00000081ff81723eULL, 0x000fe400020006ffULL, 0x0000541086687816ULL, 0x000fe4000000007eULL,
0x00000087ff87723eULL, 0x000fc400020006ffULL, 0x00000092ff6b723eULL, 0x000fe400020006ffULL,
0x0000008cff8c723eULL, 0x000fe400020006ffULL, 0x00000090ff90723eULL, 0x000fe400020006ffULL,
0x0000008aff8a723eULL, 0x000fe400020006ffULL, 0x00000091ff91723eULL, 0x000fe400020006ffULL,
0x00000089ff89723eULL, 0x000fc400020006ffULL, 0x00000082ff82723eULL, 0x000fe400020006ffULL,
0x00000083ff83723eULL, 0x000fe400020006ffULL, 0x0000006aff7e723eULL, 0x000fe400020006ffULL,
0x00000080ff80723eULL, 0x000fe400020006ffULL, 0x0000007cff7c723eULL, 0x000fe400020006ffULL,
0x000054106d6a7816ULL, 0x000fc40000000081ULL, 0x000054108c4f7816ULL, 0x000fe40000000087ULL,
0x000054105d5d7816ULL, 0x000fe40000000090ULL, 0x000054108a5e7816ULL, 0x000fe4000000005eULL,
0x00005410915f7816ULL, 0x000fe2000000005fULL, 0x0000004e343c723cULL, 0x000fe2000000183cULL,
0x0000541067677816ULL, 0x000fe40000000089ULL, 0x0000541082697816ULL, 0x000fc40000000069ULL,
0x000054106b6b7816ULL, 0x000fe20000000083ULL, 0x0000005c3440723cULL, 0x000fe20000001840ULL,
0x00005410806c7816ULL, 0x000fe4000000006cULL, 0x000054107c6d7816ULL, 0x000fc6000000007eULL,
0x0000005e3444723cULL, 0x000fec0000001844ULL, 0x000000663448723cULL, 0x000fec0000001848ULL,
0x000000683450723cULL, 0x000fec0000001850ULL, 0x0000006a3428723cULL, 0x000fec0000001828ULL,
0x0000006c3424723cULL, 0x000fec0000001824ULL, 0x0000004e2c10723cULL, 0x000fe20000001810ULL,
0xfffffff875367812ULL, 0x000fe200078ec0ffULL, 0x0000000860347824ULL, 0x000fc400078e0209ULL,
0x00000001ff377424ULL, 0x000fe400078e00ffULL, 0x0000000109367824ULL, 0x000fe200078e0236ULL,
0x0000005c2c14723cULL, 0x000fe20000001814ULL, 0x01a6c837343479a7ULL, 0x000e6a000850003fULL,
0x0000005e2c18723cULL, 0x000fe20000001818ULL, 0x01a6983736ff79a7ULL, 0x0005ea000850003fULL,
0x000000662c1c723cULL, 0x000fec000000181cULL, 0x000000682c20723cULL, 0x000fec0000001820ULL,
0x0000006a2c30723cULL, 0x000fec0000001830ULL, 0x0000006c2c38723cULL, 0x000fee0000001838ULL,
0x00000000002c7805ULL, 0x000fe20000015200ULL, 0x00000035060075a7ULL, 0x002e64000800017fULL,
0x00000000005c0947ULL, 0x006fdc0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000002e7805ULL, 0x000fcc0000015200ULL, 0x0000002e2c377210ULL, 0x000fca0007f1e1ffULL,
0x000000012f2f7824ULL, 0x000fe200000e0e2dULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff2e7819ULL, 0x000fc8000001142fULL,
0x000000372e2e7211ULL, 0x000fca00078110ffULL, 0x000000ffff2f7224ULL, 0x000fca00000e062fULL,
0x000000022e2e7819ULL, 0x000fc8000000122fULL, 0x0000002e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x00000035060075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00000001072c7836ULL, 0x000fca0000000000ULL, 0x0000005b2c00720cULL, 0x000fda0003f06070ULL,
0x0000000400d40947ULL, 0x000fea0003800000ULL, 0x00000002072c7836ULL, 0x000fe20000000000ULL,
0x0000920000087ab9ULL, 0x000fe20000000800ULL, 0x00000100712e7836ULL, 0x000fc60000000000ULL,
0x0000005b2c00720cULL, 0x000fe20003f06070ULL, 0x0000000859377c24ULL, 0x000fd8000f8e022eULL,
0x0000000000f88947ULL, 0x000fea0003800000ULL, 0x0000002e612c7248ULL, 0x000fe20007fe0000ULL,
0x00000010642d7824ULL, 0x000fe200078e00ffULL, 0x00000003ff2f7819ULL, 0x000fe2000001160aULL,
0x00008e0000087ab9ULL, 0x000fe40000000a00ULL, 0x000000012c2c7824ULL, 0x000fe400078e0a2eULL,
0x000000012d2e7824ULL, 0x000fe400078e022fULL, 0x000000042f357836ULL, 0x000fe20000000000ULL,
0x0000002c2d2c7248ULL, 0x000fe20007fe0000ULL, 0x000000012e347824ULL, 0x000fc400078e020aULL,
0x000000082e4d7824ULL, 0x000fe400078e00ffULL, 0x000000012c2c7824ULL, 0x000fe400078e0a2dULL,
0x000000082f367836ULL, 0x000fe20000000000ULL, 0xfffffff84d4c7812ULL, 0x000fe200078ee234ULL,
0x000000012d347824ULL, 0x000fe200078e0235ULL, 0x0000002c2f00720cULL, 0x080fe20003f86070ULL,
0x0000000c2f2f7836ULL, 0x000fe20000000000ULL, 0x0000002c3500720cULL, 0x080fe20003f66070ULL,
0x000000012e2e7824ULL, 0x000fe200078e0237ULL, 0x0000002c3600720cULL, 0x080fe20003f46070ULL,
0x000000012d4d7824ULL, 0x000fe200078e022fULL, 0x0000002c2f00720cULL, 0x000fe20003f06070ULL,
0x00000001342c7824ULL, 0x000fc400078e020aULL, 0x00000008342f7824ULL, 0x040fe400078e00ffULL,
0x000000012d367824ULL, 0x000fe400078e0236ULL, 0x0000000134347824ULL, 0x000fe200078e0237ULL,
0xfffffff82f4e7812ULL, 0x000fe200078ee22cULL, 0x00000001362d7824ULL, 0x040fe400078e020aULL,
0x00000008365c7824ULL, 0x000fe400078e00ffULL, 0x000000802e2e7825ULL, 0x000fc600078e00ffULL,
0xfffffff85c5c7812ULL, 0x000fe200078ee22dULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x000000722e2e7212ULL, 0x000fc600078efcffULL, 0x00000001362c7824ULL, 0x100fe200078e0237ULL,
0x0000007234347212ULL, 0x080fe200078efcffULL, 0x000000014d367824ULL, 0x040fe200078e0237ULL,
0x000000082e2e7c10ULL, 0x000fe2000ffbe0ffULL, 0x000000802c2c7825ULL, 0x000fe200078e00ffULL,
0x0000000834347c10ULL, 0x000fe4000ffde0ffULL, 0x000000092f2f7c10ULL, 0x000fe2000affe4ffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x000000722c2c7212ULL, 0x080fe400078efcffULL,
0x0000000935357c10ULL, 0x000fe2000b7fe4ffULL, 0x000000014d4f7824ULL, 0x040fe200078e020aULL,
0x0000007236367212ULL, 0x000fe200078efcffULL, 0x000000084d5e7824ULL, 0x000fe200078e00ffULL,
0x000000082c2c7c10ULL, 0x000fe2000ffbe0ffULL, 0x000000104c4d7824ULL, 0x100fe200078e026fULL,
0x0000000836367c10ULL, 0x000fe2000ffde0ffULL, 0x000000105c5d7824ULL, 0x100fe200078e026fULL,
0xfffffff85e5e7812ULL, 0x000fe200078ee24fULL, 0x000000104e4f7824ULL, 0x100fe200078e026fULL,
0x000000092d2d7c10ULL, 0x000fe2000affe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002e4d7faeULL, 0x0003e2000e101c46ULL, 0x0000000937377c10ULL, 0x000fe2000b7fe4ffULL,
0x000000105e6f7824ULL, 0x000fc400078e026fULL, 0x00000000344f7faeULL, 0x0003e8000d901c46ULL,
0x000000002c5d7faeULL, 0x0003e8000d101c46ULL, 0x00000000366f7faeULL, 0x0003e2000c101c46ULL,
0x0000000000c47947ULL, 0x000fea0003800000ULL, 0x00000010642d7824ULL, 0x000fe200078e00ffULL,
0x00008e0000087ab9ULL, 0x000fc80000000a00ULL, 0x0000002d0a2d7211ULL, 0x000fca00078fe8ffULL,
0x000000012d2e7824ULL, 0x040fe400078e020aULL, 0x000000082d2f7824ULL, 0x040fe400078e00ffULL,
0x000000082d4d7836ULL, 0x000fe40000000000ULL, 0x0000000c2d4e7836ULL, 0x000fe20000000000ULL,
0xfffffff82f4c7812ULL, 0x000fe200078ee22eULL, 0x000000042d2f7836ULL, 0x000fe40000000000ULL,
0x000000012d2c7824ULL, 0x000fc400078e0237ULL, 0x000000012f2e7824ULL, 0x140fe400078e0237ULL,
0x000000012f357824ULL, 0x140fe400078e020aULL, 0x000000082f5c7824ULL, 0x000fe400078e00ffULL,
0x000000014d367824ULL, 0x140fe400078e0237ULL, 0x000000014e347824ULL, 0x000fe400078e0237ULL,
0x000000014d2f7824ULL, 0x000fc400078e020aULL, 0x000000084d5e7824ULL, 0x000fe400078e00ffULL,
0x000000802c2c7825ULL, 0x000fc800078e00ffULL, 0x000000014e377824ULL, 0x000fe200078e020aULL,
0x000000722c2c7212ULL, 0x080fe200078efcffULL, 0x000000084e667824ULL, 0x000fe200078e00ffULL,
0xfffffff85c4e7812ULL, 0x000fe200078ee235ULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0xfffffff85e5c7812ULL, 0x000fe400078ee22fULL, 0xfffffff8665e7812ULL, 0x000fe200078ee237ULL,
0x000000802e2e7825ULL, 0x000fe200078e00ffULL, 0x000000082c2c7c10ULL, 0x000fe4000ff1e0ffULL,
0x0000007234347212ULL, 0x080fe200078efcffULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x000000722e2e7212ULL, 0x000fc400078efcffULL, 0x000000092d2d7c10ULL, 0x000fe200087fe4ffULL,
0x000000104c4d7824ULL, 0x100fe200078e026fULL, 0x0000007236367212ULL, 0x000fe200078efcffULL,
0x000000104e4f7824ULL, 0x100fe200078e026fULL, 0x000000082e2e7c10ULL, 0x000fe2000ff1e0ffULL,
0x000000105c5d7824ULL, 0x100fe200078e026fULL, 0x0000000836367c10ULL, 0x000fe2000ff5e0ffULL,
0x000000105e6f7824ULL, 0x000fe200078e026fULL, 0x0000000834347c10ULL, 0x000fe2000ff7e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c4d7faeULL, 0x0003e2000b901c46ULL,
0x000000092f2f7c10ULL, 0x000fc400087fe4ffULL, 0x0000000937377c10ULL, 0x000fe400097fe4ffULL,
0x0000000935357c10ULL, 0x000fe20009ffe4ffULL, 0x000000002e4f7faeULL, 0x0003e8000b901c46ULL,
0x00000000365d7faeULL, 0x0003e8000b901c46ULL, 0x00000000346f7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x00000001ff357424ULL, 0x000fe200078e00ffULL,
0x00000000ff0079b0ULL, 0x000fe20008000a44ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000035ff8079a7ULL, 0x0002a40008500005ULL, 0x01a66835083479a7ULL, 0x0022e4000850003fULL,
0x00000000002c7805ULL, 0x000fce0000015200ULL, 0x01a66835080075a7ULL, 0x008ee4000800017fULL,
0x00000000005c0947ULL, 0x008fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000002e7805ULL, 0x000fce0000015200ULL, 0x0000002e2c377210ULL, 0x000fca0007f1e1ffULL,
0x000000012f2f7824ULL, 0x000fe200000e0e2dULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff2e7819ULL, 0x000fc8000001142fULL,
0x000000372e2e7211ULL, 0x000fca00078110ffULL, 0x000000ffff2f7224ULL, 0x000fca00000e062fULL,
0x000000022e2e7819ULL, 0x000fc8000000122fULL, 0x0000002e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x01a66835080075a7ULL, 0x000ee4000800017fULL, 0xfffffffc00a88947ULL, 0x008fea000383ffffULL,
0x00000080582d7824ULL, 0x000fe400078e0209ULL, 0x00000001ff347424ULL, 0x000fe400078e00ffULL,
0x000000ffff7c7224ULL, 0x000fe200078e007fULL, 0x00000180722c7810ULL, 0x000fca0007ffe02dULL,
0x00000001732c7824ULL, 0x000fca00078e022cULL, 0x01a000002c2e7984ULL, 0x000ee80000000800ULL,
0x01a200002c2d7984ULL, 0x0009220000000800ULL, 0x0000007f2e00720bULL, 0x008fda0003f1d000ULL,
0x0000000000357806ULL, 0x000fc800000e0100ULL, 0x000000ff3500720cULL, 0x000fda0003f05270ULL,
0x0000000400908947ULL, 0x016fea0003800000ULL, 0x00000003582f7836ULL, 0x000fe20000000000ULL,
0x0000007f2e00720bULL, 0x0c0fe40003f14000ULL, 0x0000007f2e7c7209ULL, 0x000fe40007810000ULL,
0x000000782f00720cULL, 0x000fd20003f45270ULL, 0x0000000000367806ULL, 0x000fc800000e0100ULL,
0x00000080782ca824ULL, 0x000fe200078e0209ULL, 0x000000ff3600720cULL, 0x000fc80003f05270ULL,
0x0000002c7373a210ULL, 0x000fca0007ffe072ULL, 0x01a4007c7300a388ULL, 0x0003e80000000800ULL,
0x0000000400508947ULL, 0x000fea0003800000ULL, 0x0000007f7c2c7221ULL, 0x000fe20000010100ULL,
0x000000ff36ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0036ff7812ULL, 0x000fe2000784c0ffULL,
0x3fb8aa3b2c2c7820ULL, 0x000fe20000410000ULL, 0x00ff000036ff7812ULL, 0x040fe4000786c0ffULL,
0xff00000036ff7812ULL, 0x000fe2000788c0ffULL, 0x0000002c004c7308ULL, 0x0004ec0000000800ULL,
0x0000000000488947ULL, 0x000fec0003800000ULL, 0x00000002ff2f7819ULL, 0x000fca000001160aULL,
0x00001f2f4c2c7589ULL, 0x00cea400000e0000ULL, 0x000000542c547220ULL, 0x044fe20000410000ULL,
0x000000552c557220ULL, 0x040fe20000410000ULL, 0x0000003c2c3c7220ULL, 0x040fe20000410000ULL,
0x0000003d2c3d7220ULL, 0x040fe20000410000ULL, 0x000000402c407220ULL, 0x040fe20000410000ULL,
0x000000412c417220ULL, 0x040fe20000410000ULL, 0x000000442c447220ULL, 0x040fe20000410000ULL,
0x000000452c457220ULL, 0x040fe20000410000ULL, 0x000000482c487220ULL, 0x040fe20000410000ULL,
0x000000492c497220ULL, 0x040fe20000410000ULL, 0x000000502c507220ULL, 0x040fe20000410000ULL,
0x000000512c517220ULL, 0x040fe20000410000ULL, 0x000000282c287220ULL, 0x040fe20000410000ULL,
0x000000292c297220ULL, 0x040fe20000410000ULL, 0x000000242c247220ULL, 0x040fe20000410000ULL,
0x000000252c257220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x000000080a2f7811ULL, 0x000fca00078ff0ffULL, 0x00001f2f4c2c7589ULL, 0x00cea400000e0000ULL,
0x000000562c567220ULL, 0x044fe20000410000ULL, 0x000000572c577220ULL, 0x040fe20000410000ULL,
0x0000003e2c3e7220ULL, 0x040fe20000410000ULL, 0x0000003f2c3f7220ULL, 0x040fe20000410000ULL,
0x000000422c427220ULL, 0x040fe20000410000ULL, 0x000000432c437220ULL, 0x040fe20000410000ULL,
0x000000462c467220ULL, 0x040fe20000410000ULL, 0x000000472c477220ULL, 0x040fe20000410000ULL,
0x0000004a2c4a7220ULL, 0x040fe20000410000ULL, 0x0000004b2c4b7220ULL, 0x040fe20000410000ULL,
0x000000522c527220ULL, 0x040fe20000410000ULL, 0x000000532c537220ULL, 0x040fe20000410000ULL,
0x0000002a2c2a7220ULL, 0x040fe20000410000ULL, 0x0000002b2c2b7220ULL, 0x040fe20000410000ULL,
0x000000262c267220ULL, 0x040fe20000410000ULL, 0x000000272c277220ULL, 0x000fce0000410000ULL,
0x000000000048b947ULL, 0x000fea0003800000ULL, 0x000000100a2f7811ULL, 0x000fca00078ff0ffULL,
0x00001f2f4c2c7589ULL, 0x00cea400000e0000ULL, 0x0000000c2c0c7220ULL, 0x044fe20000410000ULL,
0x0000000d2c0d7220ULL, 0x040fe20000410000ULL, 0x000000102c107220ULL, 0x040fe20000410000ULL,
0x000000112c117220ULL, 0x040fe20000410000ULL, 0x000000142c147220ULL, 0x040fe20000410000ULL,
0x000000152c157220ULL, 0x040fe20000410000ULL, 0x000000182c187220ULL, 0x040fe20000410000ULL,
0x000000192c197220ULL, 0x040fe20000410000ULL, 0x0000001c2c1c7220ULL, 0x040fe20000410000ULL,
0x0000001d2c1d7220ULL, 0x040fe20000410000ULL, 0x000000202c207220ULL, 0x040fe20000410000ULL,
0x000000212c217220ULL, 0x040fe20000410000ULL, 0x000000302c307220ULL, 0x040fe20000410000ULL,
0x000000312c317220ULL, 0x040fe20000410000ULL, 0x000000382c387220ULL, 0x040fe20000410000ULL,
0x000000392c397220ULL, 0x000fce0000410000ULL, 0x0000004c7d7d7220ULL, 0x008fe20000410000ULL,
0x000000000048c947ULL, 0x000fec0003800000ULL, 0x000000180a2f7811ULL, 0x000fca00078ff0ffULL,
0x00001f2f4c2c7589ULL, 0x004ea400000e0000ULL, 0x0000000e2c0e7220ULL, 0x044fe20000410000ULL,
0x0000000f2c0f7220ULL, 0x040fe20000410000ULL, 0x000000122c127220ULL, 0x040fe20000410000ULL,
0x000000132c137220ULL, 0x040fe20000410000ULL, 0x000000162c167220ULL, 0x040fe20000410000ULL,
0x000000172c177220ULL, 0x040fe20000410000ULL, 0x0000001a2c1a7220ULL, 0x040fe20000410000ULL,
0x0000001b2c1b7220ULL, 0x040fe20000410000ULL, 0x0000001e2c1e7220ULL, 0x040fe20000410000ULL,
0x0000001f2c1f7220ULL, 0x040fe20000410000ULL, 0x000000222c227220ULL, 0x040fe20000410000ULL,
0x000000232c237220ULL, 0x040fe20000410000ULL, 0x000000322c327220ULL, 0x040fe20000410000ULL,
0x000000332c337220ULL, 0x040fe20000410000ULL, 0x0000003a2c3a7220ULL, 0x040fe20000410000ULL,
0x0000003b2c3b7220ULL, 0x000fce0000410000ULL, 0x0000003635ff7212ULL, 0x000fda00078030ffULL,
0x0000002e7c2e0221ULL, 0x000fe20000010100ULL, 0x00007610ff340816ULL, 0x000fc60000000034ULL,
0x3fb8aa3b2e2e0820ULL, 0x000fc80000410000ULL, 0x0000002e00040308ULL, 0x000ee40000000800ULL,
0x000000042d2d0220ULL, 0x008fce0000410000ULL, 0x0000007d2d7d7221ULL, 0x000fce0000010000ULL,
0x00000000002c7805ULL, 0x004fce0000015200ULL, 0xfffffff0622e7812ULL, 0x000fca00078ec0ffULL,
0x0000000109377824ULL, 0x000fc800078e022eULL, 0x01a6b085370075a7ULL, 0x000ea4000800017fULL,
0x00000000005c0947ULL, 0x004fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000002e7805ULL, 0x000fce0000015200ULL, 0x0000002e2c357210ULL, 0x000fca0007f1e1ffULL,
0x000000012f2f7824ULL, 0x000fe200000e0e2dULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff2e7819ULL, 0x000fc8000001142fULL,
0x000000352e2e7211ULL, 0x000fca00078110ffULL, 0x000000ffff2f7224ULL, 0x000fca00000e062fULL,
0x000000022e2e7819ULL, 0x000fc8000000122fULL, 0x0000002e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x01a6b085370075a7ULL, 0x000ea4000800017fULL, 0xfffffffc00a88947ULL, 0x004fea000383ffffULL,
0x00000001602c7812ULL, 0x000fe200078ec0ffULL, 0x00000004782f7824ULL, 0x000fe200078e00ffULL,
0x00000004ff2d7819ULL, 0x000fe2000001160aULL, 0x0000000877377824ULL, 0x000fe200078e00ffULL,
0x00009910342e7816ULL, 0x000fe200000000ffULL, 0x000000086e347824ULL, 0x000fe200078e00ffULL,
0x000000042f2f7812ULL, 0x000fe200078ec0ffULL, 0x000000042c2c7824ULL, 0x000fe200078e022dULL,
0x000000ff2e00720cULL, 0x000fe20003f05270ULL, 0x00001000582e7824ULL, 0x000fe200078e0209ULL,
0x000000022f357812ULL, 0x000fe200078efcffULL, 0x000000016e2d7824ULL, 0x000fc400078e022cULL,
0x00000001772c7824ULL, 0x000fe200078e022cULL, 0x000000350a7e7211ULL, 0x000fe200078fe0ffULL,
0x00017000707f7836ULL, 0x000fe20000000000ULL, 0xfffffff8342d7812ULL, 0x000fe200078ee22dULL,
0x000150002e667836ULL, 0x000fe20000000000ULL, 0xfffffff8372f7812ULL, 0x000fe200078ee22cULL,
0x00000010742c7824ULL, 0x000fe400078e027fULL, 0x000000102d2d7824ULL, 0x100fe400078e0266ULL,
0x000000102f2f7824ULL, 0x000fe200078e0266ULL, 0x0000000000280947ULL, 0x000fec0003800000ULL,
0x00000002ff037819ULL, 0x000fe4000001160aULL, 0x00000004ff00723eULL, 0x000fc600000000ffULL,
0x0000001003057836ULL, 0x000fe20000000000ULL, 0x00005410002e7816ULL, 0x000fe20000000000ULL,
0x0000000803357836ULL, 0x000fe40000000000ULL, 0x0000001803377836ULL, 0x000fe40000000000ULL,
0x00001f052e057589ULL, 0x0004e800000e0000ULL, 0x00001f352e027589ULL, 0x00046800000e0000ULL,
0x00001f032e037589ULL, 0x00046800000e0000ULL, 0x00001f372e007589ULL, 0x00046400000e0000ULL,
0x000000002d5c783bULL, 0x0008e80000000200ULL, 0x000000002f34783bULL, 0x0044620000000200ULL,
0x0000000000200947ULL, 0x010fea0003800000ULL, 0x000000035c5c7232ULL, 0x08afe40000000000ULL,
0x000000035e5e7232ULL, 0x000fe40000000000ULL, 0x000000025d5d7232ULL, 0x080fe40000000000ULL,
0x000000025f5f7232ULL, 0x000fe40000000000ULL, 0x0000000534347232ULL, 0x080fe40000000000ULL,
0x0000000536367232ULL, 0x000fc40000000000ULL, 0x0000000035357232ULL, 0x080fe40000000000ULL,
0x0000000037377232ULL, 0x000fce0000000000ULL, 0x000000086e4d7824ULL, 0x040fe200078e00ffULL,
0x000000002c2c783bULL, 0x004ea20000004200ULL, 0x000000016e6e7824ULL, 0x000fe400078e027eULL,
0x000000107b7b7824ULL, 0x100fe400078e0266ULL, 0x0000001079797824ULL, 0x000fe200078e0266ULL,
0xfffffff84d6e7812ULL, 0x000fca00078ee26eULL, 0x000000106e4c7824ULL, 0x000fcc00078e027fULL,
0x000000004c4c783bULL, 0x000f220000004200ULL, 0x00000018ff6a7819ULL, 0x104fe4000001162cULL,
0x000000ff2e6d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff857819ULL, 0x000fe4000001162cULL,
0x000000ff2c807812ULL, 0x040fe400078ec0ffULL, 0x0000ffff2c897812ULL, 0x000fe400078ec0ffULL,
0x00000010ff837819ULL, 0x000fc4000001162eULL, 0x00000018ff6c7819ULL, 0x000fe4000001162eULL,
0x0000ffff2e667812ULL, 0x000fe400078ec0ffULL, 0x00000018ff6e7819ULL, 0x000fe4000001162fULL,
0x000000ff4c717812ULL, 0x010fe400078ec0ffULL, 0x00000010ff2e7819ULL, 0x000fe4000001164eULL,
0x000000ff4e757812ULL, 0x000fc400078ec0ffULL, 0x00000018ff747819ULL, 0x000fe4000001164eULL,
0x0000ffff4e2c7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff727819ULL, 0x000fe4000001164dULL,
0x0000006aff4e723eULL, 0x000fe400020006ffULL, 0x0000006dff6a723eULL, 0x000fe400020006ffULL,
0x00000018ff877819ULL, 0x000fc4000001164fULL, 0x0000006eff6d723eULL, 0x000fe400020006ffULL,
0x00000010ff867819ULL, 0x000fe4000001162dULL, 0x00000010ff847819ULL, 0x000fe4000001162fULL,
0x00000071ff6e723eULL, 0x000fe400020006ffULL, 0x00000072ff71723eULL, 0x000fe400020006ffULL,
0x00000018ff6b7819ULL, 0x000fc4000001162dULL, 0x00000075ff72723eULL, 0x000fe400020006ffULL,
0x000000ff85857812ULL, 0x000fe400078ec0ffULL, 0x000000ff2f6f7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff2f677812ULL, 0x000fe400078ec0ffULL, 0x00000087ff75723eULL, 0x000fe400020006ffULL,
0x000000ff2d827812ULL, 0x000fc400078ec0ffULL, 0x0000ffff2d8a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff4d737812ULL, 0x002fe400078ec0ffULL, 0x000000ff86877812ULL, 0x000fe400078ec0ffULL,
0x000000ff84847812ULL, 0x000fe400078ec0ffULL, 0x00000010ff2f7819ULL, 0x000fe4000001164fULL,
0x000000ff4f887812ULL, 0x000fc400078ec0ffULL, 0x0000ffff4f2d7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff667819ULL, 0x000fe40000011666ULL, 0x00000080ff80723eULL, 0x000fe400020006ffULL,
0x0000006bff4f723eULL, 0x000fe400020006ffULL, 0x00000085ff85723eULL, 0x000fe400020006ffULL,
0x00000010ff687819ULL, 0x000fc4000001164cULL, 0x0000006fff6b723eULL, 0x000fe400020006ffULL,
0x00000008ff867819ULL, 0x000fe40000011689ULL, 0x00000008ff677819ULL, 0x000fe40000011667ULL,
0x00000018ff707819ULL, 0x000fe4000001164cULL, 0x0000ffff4c697812ULL, 0x000fe400078ec0ffULL,
0x00000082ff82723eULL, 0x000fc400020006ffULL, 0x00000073ff6f723eULL, 0x000fe400020006ffULL,
0x00000087ff87723eULL, 0x000fe400020006ffULL, 0x00000084ff89723eULL, 0x000fe400020006ffULL,
0x00000010ff4c7819ULL, 0x000fe4000001164dULL, 0x00000088ff73723eULL, 0x000fe400020006ffULL,
0x00000066ff84723eULL, 0x000fc400020006ffULL, 0x00000008ff887819ULL, 0x000fe4000001168aULL,
0x0000541080667816ULL, 0x000fe40000000085ULL, 0x00000067ff8a723eULL, 0x000fe400020006ffULL,
0x000000ff68807812ULL, 0x000fe400078ec0ffULL, 0x00000086ff86723eULL, 0x000fe400020006ffULL,
0x0000541082677816ULL, 0x000fc40000000087ULL, 0x000000ff4c827812ULL, 0x000fe400078ec0ffULL,
0x000000ff83837812ULL, 0x000fe400078ec0ffULL, 0x00000008ff4c7819ULL, 0x000fe20000011669ULL,
0x00000066340c723cULL, 0x000fe2000000180cULL, 0x0000ffff4d4d7812ULL, 0x000fe400078ec0ffULL,
0x00000080ff80723eULL, 0x000fe400020006ffULL, 0x0000541086687816ULL, 0x000fe2000000004eULL,
0x000000665c54723cULL, 0x008fe20000001854ULL, 0x00000082ff4e723eULL, 0x000fc400020006ffULL,
0x0000006cff6c723eULL, 0x000fe400020006ffULL, 0x00000083ff83723eULL, 0x000fe400020006ffULL,
0x0000004cff82723eULL, 0x000fe400020006ffULL, 0x00000008ff4d7819ULL, 0x000fe4000001164dULL,
0x000000ff2e4c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff2f2f7812ULL, 0x000fc400078ec0ffULL,
0x000054106e6e7816ULL, 0x000fe40000000080ULL, 0x00000008ff807819ULL, 0x000fe4000001162cULL,
0x00000008ff857819ULL, 0x000fe4000001162dULL, 0x000054106a6a7816ULL, 0x000fe40000000083ULL,
0x00005410846c7816ULL, 0x000fe4000000006cULL, 0x00000070ff70723eULL, 0x000fc400020006ffULL,
0x00000088ff88723eULL, 0x000fe400020006ffULL, 0x0000004dff2e723eULL, 0x000fe400020006ffULL,
0x0000004cff83723eULL, 0x000fe400020006ffULL, 0x0000002fff84723eULL, 0x000fe400020006ffULL,
0x00000074ff74723eULL, 0x000fe400020006ffULL, 0x00000080ff80723eULL, 0x000fc400020006ffULL,
0x00000085ff85723eULL, 0x000fe400020006ffULL, 0x0000541088697816ULL, 0x000fe4000000004fULL,
0x000054106b6b7816ULL, 0x000fe40000000089ULL, 0x000054108a6d7816ULL, 0x000fe4000000006dULL,
0x000054106f6f7816ULL, 0x000fe2000000004eULL, 0x000000683410723cULL, 0x000fe20000001810ULL,
0x0000541082707816ULL, 0x000fe20000000070ULL, 0x000000007b4c783bULL, 0x0002620000000200ULL,
0x000054102e717816ULL, 0x000fc40000000071ULL, 0x0000541072727816ULL, 0x000fe20000000083ULL,
0x0000006a3414723cULL, 0x000fe20000001814ULL, 0x0000541073737816ULL, 0x000fe20000000084ULL,
0x00000000792c783bULL, 0x0002620000000200ULL, 0x0000541080747816ULL, 0x000fe40000000074ULL,
0x0000541085757816ULL, 0x000fe20000000075ULL, 0x0000006c3418723cULL, 0x000fec0000001818ULL,
0x0000006e341c723cULL, 0x000fec000000181cULL, 0x000000703420723cULL, 0x000fec0000001820ULL,
0x000000723430723cULL, 0x000fec0000001830ULL, 0x000000685c3c723cULL, 0x000fec000000183cULL,
0x0000006a5c40723cULL, 0x000fec0000001840ULL, 0x0000006c5c44723cULL, 0x000fec0000001844ULL,
0x0000006e5c48723cULL, 0x000fec0000001848ULL, 0x000000705c50723cULL, 0x000fec0000001850ULL,
0x000000725c28723cULL, 0x000fec0000001828ULL, 0x000000745c24723cULL, 0x000fec0000001824ULL,
0x000000743434723cULL, 0x000fe20000001838ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000200947ULL, 0x002fde0003800000ULL, 0x000000034c4c7232ULL, 0x080fe40000000000ULL,
0x000000034e4e7232ULL, 0x000fe40000000000ULL, 0x000000024d4d7232ULL, 0x080fe40000000000ULL,
0x000000024f4f7232ULL, 0x000fe40000000000ULL, 0x000000052c2c7232ULL, 0x080fe40000000000ULL,
0x000000052e2e7232ULL, 0x000fc40000000000ULL, 0x000000002d2d7232ULL, 0x080fe40000000000ULL,
0x000000002f2f7232ULL, 0x000fce0000000000ULL, 0x000000107a5c7824ULL, 0x000fe400078e027fULL,
0x00000001777e7824ULL, 0x040fe400078e027eULL, 0x0000000877777824ULL, 0x000fe400078e00ffULL,
0x000000005c5c783bULL, 0x000e620000004200ULL, 0x0000000107077836ULL, 0x000fe40000000000ULL,
0xfffffff8777e7812ULL, 0x000fca00078ee27eULL, 0x000000107e387824ULL, 0x000fcc00078e027fULL,
0x000000003838783bULL, 0x000ea20000004200ULL, 0x00000010ff667819ULL, 0x002fe4000001165cULL,
0x00000010ff687819ULL, 0x000fe4000001165dULL, 0x000000ff5c677812ULL, 0x000fe400078ec0ffULL,
0x000000ff66667812ULL, 0x000fe400078ec0ffULL, 0x000000ff5d697812ULL, 0x000fe400078ec0ffULL,
0x000000ff68687812ULL, 0x000fc400078ec0ffULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x00000066ff66723eULL, 0x000fe400020006ffULL, 0x00000069ff69723eULL, 0x000fe400020006ffULL,
0x00000068ff6a723eULL, 0x000fe400020006ffULL, 0x0000541067667816ULL, 0x000fe40000000066ULL,
0x0000541069677816ULL, 0x000fc4000000006aULL, 0x0000ffff5c6b7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff5d6c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff5e6a7812ULL, 0x040fe200078ec0ffULL,
0x000000664c54723cULL, 0x000fe20000001854ULL, 0x0000ffff5e757812ULL, 0x000fe400078ec0ffULL,
0x00000018ff687819ULL, 0x000fe4000001165dULL, 0x00000018ff5c7819ULL, 0x000fe2000001165cULL,
0x000000662c0c723cULL, 0x000fe2000000180cULL, 0x00000008ff5d7819ULL, 0x000fc4000001166bULL,
0x00000008ff697819ULL, 0x000fe4000001166cULL, 0x000000ff5f6c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff667819ULL, 0x100fe4000001165eULL, 0x00000018ff677819ULL, 0x000fe4000001165eULL,
0x00000010ff5e7819ULL, 0x000fe4000001165fULL, 0x000000ff66667812ULL, 0x000fc400078ec0ffULL,
0x000000ff5e5e7812ULL, 0x000fe400078ec0ffULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x00000068ff68723eULL, 0x000fe400020006ffULL,
0x00000069ff69723eULL, 0x000fe400020006ffULL, 0x00000018ff6b7819ULL, 0x000fc4000001165fULL,
0x0000ffff5f777812ULL, 0x000fe400078ec0ffULL, 0x0000006cff6c723eULL, 0x000fe400020006ffULL,
0x0000005eff5f723eULL, 0x000fe400020006ffULL, 0x0000006aff6a723eULL, 0x000fe400020006ffULL,
0x00000066ff66723eULL, 0x000fe400020006ffULL, 0x000054105d5c7816ULL, 0x000fc4000000005cULL,
0x00005410695d7816ULL, 0x000fe40000000068ULL, 0x00000010ff6e7819ULL, 0x104fe40000011639ULL,
0x000000ff39707812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6f7819ULL, 0x000fe20000011639ULL,
0x0000005c4c3c723cULL, 0x000fe2000000183cULL, 0x0000ffff397a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff687819ULL, 0x000fc40000011638ULL, 0x000000ff386d7812ULL, 0x040fe200078ec0ffULL,
0x0000005c2c10723cULL, 0x000fe20000001810ULL, 0x00000018ff697819ULL, 0x000fe40000011638ULL,
0x0000ffff38797812ULL, 0x000fe400078ec0ffULL, 0x000054106c397816ULL, 0x000fe4000000005fULL,
0x00000008ff5e7819ULL, 0x000fe40000011675ULL, 0x000054106a387816ULL, 0x000fc40000000066ULL,
0x00000008ff5f7819ULL, 0x000fe40000011677ULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x0000006bff6b723eULL, 0x000fe200020006ffULL, 0x000000384c40723cULL, 0x000fe20000001840ULL,
0x0000005eff5e723eULL, 0x000fe400020006ffULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x00000010ff717819ULL, 0x100fe2000001163aULL, 0x000000382c14723cULL, 0x000fe20000001814ULL,
0x00000018ff727819ULL, 0x000fc4000001163aULL, 0x000000ff3a737812ULL, 0x040fe400078ec0ffULL,
0x0000ffff3a5c7812ULL, 0x000fe400078ec0ffULL, 0x000054105e387816ULL, 0x000fe40000000067ULL,
0x000054105f397816ULL, 0x000fe4000000006bULL, 0x00000010ff5d7819ULL, 0x100fe4000001163bULL,
0x00000018ff3a7819ULL, 0x000fc4000001163bULL, 0x000000ff3b747812ULL, 0x040fe200078ec0ffULL,
0x000000384c44723cULL, 0x000fe20000001844ULL, 0x00000008ff5f7819ULL, 0x000fe4000001167aULL,
0x0000ffff3b3b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff5d5d7812ULL, 0x000fe200078ec0ffULL,
0x000000382c18723cULL, 0x000fe20000001818ULL, 0x00000069ff69723eULL, 0x000fe400020006ffULL,
0x0000006fff6f723eULL, 0x000fc400020006ffULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x00000008ff397819ULL, 0x000fe40000011679ULL, 0x000000ff68687812ULL, 0x000fe400078ec0ffULL,
0x00000039ff5e723eULL, 0x000fe400020006ffULL, 0x000000ff6e6e7812ULL, 0x000fe400078ec0ffULL,
0x000000ff71717812ULL, 0x000fc400078ec0ffULL, 0x00000008ff667819ULL, 0x000fe4000001165cULL,
0x00000008ff3b7819ULL, 0x000fe4000001163bULL, 0x0000005dff67723eULL, 0x000fe400020006ffULL,
0x00000074ff74723eULL, 0x000fe400020006ffULL, 0x000054105e5c7816ULL, 0x000fe40000000069ULL,
0x000054105f5d7816ULL, 0x000fc4000000006fULL, 0x0000006dff6d723eULL, 0x000fe400020006ffULL,
0x00000070ff70723eULL, 0x000fe400020006ffULL, 0x00000072ff72723eULL, 0x000fe200020006ffULL,
0x0000005c4c50723cULL, 0x000fe20000001850ULL, 0x00000073ff73723eULL, 0x000fe400020006ffULL,
0x00000068ff38723eULL, 0x000fe400020006ffULL, 0x0000006eff6e723eULL, 0x000fe200020006ffULL,
0x0000005c2c20723cULL, 0x000fe20000001820ULL, 0x00000071ff71723eULL, 0x000fc400020006ffULL,
0x0000003aff5f723eULL, 0x000fe400020006ffULL, 0x00000066ff66723eULL, 0x000fe400020006ffULL,
0x0000003bff5e723eULL, 0x000fe400020006ffULL, 0x00005410743b7816ULL, 0x000fe40000000067ULL,
0x000054106d387816ULL, 0x000fe40000000038ULL, 0x0000541070397816ULL, 0x000fc4000000006eULL,
0x00005410733a7816ULL, 0x000fe40000000071ULL, 0x0000541066667816ULL, 0x000fe40000000072ULL,
0x000054105e677816ULL, 0x000fe2000000005fULL, 0x000000384c48723cULL, 0x000fec0000001848ULL,
0x0000003a4c28723cULL, 0x000fec0000001828ULL, 0x000000664c24723cULL, 0x000fec0000001824ULL,
0x000000382c1c723cULL, 0x000fe2000000181cULL, 0x00000001ff4d7424ULL, 0x000fc800078e00ffULL,
0x0000004d063879a7ULL, 0x0002a2000850003fULL, 0x0000003a2c30723cULL, 0x000fec0000001830ULL,
0x000000662c2c723cULL, 0x000fe20000001834ULL, 0x0000000858067824ULL, 0x002fc800078e0209ULL,
0x01a6a04d06ff79a7ULL, 0x0003e2000850003fULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0xffffff6000909947ULL, 0x000fde000383ffffULL, 0x000000ff5b00720cULL, 0x000fda0003f05270ULL,
0x0000000400648947ULL, 0x000fea0003800000ULL, 0x018000007d007836ULL, 0x000fe20000000000ULL,
0x000000b000007945ULL, 0x000fe80003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x00000000000c0947ULL, 0x000fea0003800000ULL,
0x0000ba8000047802ULL, 0x000fce0000000f00ULL, 0x000000a400ec7944ULL, 0x006fea0003c00000ULL,
0x0000000000107947ULL, 0x000fea0003800000ULL, 0x0000007d00007308ULL, 0x000ee40000001000ULL,
0xbf80000000027423ULL, 0x00afc8000000007dULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000300007223ULL, 0x000fce0000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009600ff027b82ULL, 0x000f240000000a00ULL, 0x0000000602037981ULL, 0x010f22000c1e9900ULL,
0x0000000000057919ULL, 0x000f640000000000ULL, 0x0000001805077811ULL, 0x062fe400078ff0ffULL,
0x00000002ff357819ULL, 0x000fe40000011605ULL, 0x0000000805377811ULL, 0x040fe400078ff0ffULL,
0x0000001005397811ULL, 0x004fe200078ff0ffULL, 0x0000000003007220ULL, 0x018fca0000410000ULL,
0x00001f3500047589ULL, 0x000e6800000e0000ULL, 0x00001f3700067589ULL, 0x000ea800000e0000ULL,
0x00001f3900057589ULL, 0x000ee800000e0000ULL, 0x00001f0700077589ULL, 0x000f2200000e0000ULL,
0x0000005404547220ULL, 0x042fe20000410000ULL, 0x0000005504557220ULL, 0x040fe20000410000ULL,
0x0000003c043c7220ULL, 0x040fe20000410000ULL, 0x0000003d043d7220ULL, 0x040fe20000410000ULL,
0x0000004004407220ULL, 0x040fe20000410000ULL, 0x0000004104417220ULL, 0x040fe20000410000ULL,
0x0000004404447220ULL, 0x040fe20000410000ULL, 0x0000004504457220ULL, 0x040fe20000410000ULL,
0x0000004804487220ULL, 0x040fe20000410000ULL, 0x0000004904497220ULL, 0x040fe20000410000ULL,
0x0000005004507220ULL, 0x040fe20000410000ULL, 0x0000005104517220ULL, 0x040fe20000410000ULL,
0x0000002804287220ULL, 0x040fe20000410000ULL, 0x0000002904297220ULL, 0x040fe20000410000ULL,
0x0000002404247220ULL, 0x040fe20000410000ULL, 0x0000002504257220ULL, 0x000fe20000410000ULL,
0x0000005606567220ULL, 0x044fe20000410000ULL, 0x0000005706577220ULL, 0x040fe20000410000ULL,
0x0000003e063e7220ULL, 0x040fe20000410000ULL, 0x0000003f063f7220ULL, 0x040fe20000410000ULL,
0x0000004206427220ULL, 0x040fe20000410000ULL, 0x0000004306437220ULL, 0x040fe20000410000ULL,
0x0000004606467220ULL, 0x040fe20000410000ULL, 0x0000004706477220ULL, 0x040fe20000410000ULL,
0x0000004a064a7220ULL, 0x040fe20000410000ULL, 0x0000004b064b7220ULL, 0x040fe20000410000ULL,
0x0000005206527220ULL, 0x040fe20000410000ULL, 0x0000005306537220ULL, 0x040fe20000410000ULL,
0x0000002a062a7220ULL, 0x040fe20000410000ULL, 0x0000002b062b7220ULL, 0x040fe20000410000ULL,
0x0000002606267220ULL, 0x040fe20000410000ULL, 0x0000002706277220ULL, 0x000fe20000410000ULL,
0x0000000c050c7220ULL, 0x048fe20000410000ULL, 0x0000000d050d7220ULL, 0x040fe20000410000ULL,
0x0000001005107220ULL, 0x040fe20000410000ULL, 0x0000001105117220ULL, 0x040fe20000410000ULL,
0x0000001405147220ULL, 0x040fe20000410000ULL, 0x0000001505157220ULL, 0x040fe20000410000ULL,
0x0000001805187220ULL, 0x040fe20000410000ULL, 0x0000001905197220ULL, 0x040fe20000410000ULL,
0x0000001c051c7220ULL, 0x040fe20000410000ULL, 0x0000001d051d7220ULL, 0x040fe20000410000ULL,
0x0000002005207220ULL, 0x040fe20000410000ULL, 0x0000002105217220ULL, 0x040fe20000410000ULL,
0x0000003005307220ULL, 0x040fe20000410000ULL, 0x0000003105317220ULL, 0x040fe20000410000ULL,
0x0000002c052c7220ULL, 0x040fe20000410000ULL, 0x0000002d052d7220ULL, 0x000fe20000410000ULL,
0x0000000e070e7220ULL, 0x050fe20000410000ULL, 0x0000000f070f7220ULL, 0x040fe20000410000ULL,
0x0000001207127220ULL, 0x040fe20000410000ULL, 0x0000001307137220ULL, 0x040fe20000410000ULL,
0x0000001607167220ULL, 0x040fe20000410000ULL, 0x0000001707177220ULL, 0x040fe20000410000ULL,
0x0000001a071a7220ULL, 0x040fe20000410000ULL, 0x0000001b071b7220ULL, 0x040fe20000410000ULL,
0x0000001e071e7220ULL, 0x040fe20000410000ULL, 0x0000001f071f7220ULL, 0x040fe20000410000ULL,
0x0000002207227220ULL, 0x040fe20000410000ULL, 0x0000002307237220ULL, 0x040fe20000410000ULL,
0x0000003207327220ULL, 0x040fe20000410000ULL, 0x0000003307337220ULL, 0x040fe20000410000ULL,
0x0000002e072e7220ULL, 0x040fe20000410000ULL, 0x0000002f072f7220ULL, 0x000fce0000410000ULL,
0x0000000000037919ULL, 0x002e620000000000ULL, 0x0000200064097824ULL, 0x000fe200078e0209ULL,
0x000000484948723eULL, 0x000fe400000000ffULL, 0x000000505150723eULL, 0x000fe200000000ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000282928723eULL, 0x000fc400000000ffULL,
0x000000242524723eULL, 0x000fe400000000ffULL, 0x000000565757723eULL, 0x000fe400000000ffULL,
0x0000003e3f3e723eULL, 0x000fe400000000ffULL, 0x000000424342723eULL, 0x000fe400000000ffULL,
0x000000464746723eULL, 0x000fe400000000ffULL, 0x0000004a4b4a723eULL, 0x000fc400000000ffULL,
0x000000525325723eULL, 0x000fe400000000ffULL, 0x0000541057567816ULL, 0x000fe4000000003eULL,
0x0000002a2b2a723eULL, 0x000fe400000000ffULL, 0x000000262726723eULL, 0x000fe200000000ffULL,
0x000000015a5a7824ULL, 0x002fe200078e0203ULL, 0x0000000803057811ULL, 0x040fe400078ff0ffULL,
0x0000001003357811ULL, 0x040fe200078ff0ffULL, 0x000000105a5a7824ULL, 0x000fe200078e0209ULL,
0x0000000203007812ULL, 0x000fe200078ec0ffULL, 0x0000000805397824ULL, 0x004fe200078e00ffULL,
0x00000002ff077819ULL, 0x000fe20000011603ULL, 0x0000000835367824ULL, 0x000fe200078e00ffULL,
0x0000001803377811ULL, 0x000fc400078ff0ffULL, 0x0000000500047211ULL, 0x040fe200078ff8ffULL,
0x00000008070a7824ULL, 0x040fe200078e00ffULL, 0x0000000700027211ULL, 0x040fe400078ff8ffULL,
0x0000003500057211ULL, 0x040fe200078ff8ffULL, 0x0000000807357824ULL, 0x000fe200078e00ffULL,
0x0000003700067211ULL, 0x000fe200078ff8ffULL, 0x0000000837377824ULL, 0x000fe200078e00ffULL,
0xfffffff836367812ULL, 0x000fe200078ee205ULL, 0x0000000202007836ULL, 0x000fe20000000000ULL,
0xfffffff839347812ULL, 0x000fe200078ee204ULL, 0x0000000807057824ULL, 0x000fe200078e00ffULL,
0xfffffff837387812ULL, 0x000fe200078ee206ULL, 0x0000000402047836ULL, 0x000fe20000000000ULL,
0xfffffff835067812ULL, 0x000fe200078ee200ULL, 0x0000000602077836ULL, 0x000fe20000000000ULL,
0xfffffff805007812ULL, 0x000fe200078ee202ULL, 0x0000000803027824ULL, 0x000fe200078e00ffULL,
0xfffffff835087812ULL, 0x000fe200078ee204ULL, 0x0000100060057824ULL, 0x000fe200078e0209ULL,
0xfffffff80a0a7812ULL, 0x000fc400078ee207ULL, 0x0000000802077812ULL, 0x000fe200078ec0ffULL,
0x0000001000047824ULL, 0x100fe200078e0205ULL, 0x000000545500723eULL, 0x000fe200000000ffULL,
0x0000001034347824ULL, 0x100fe200078e0205ULL, 0x0000003c3d02723eULL, 0x000fe200000000ffULL,
0x0000001036367824ULL, 0x100fe200078e0205ULL, 0x0000763257577816ULL, 0x000fe2000000003eULL,
0x0000001038387824ULL, 0x100fe200078e0205ULL, 0x00005410003a7816ULL, 0x100fe20000000002ULL,
0x0000001006067824ULL, 0x100fe200078e0205ULL, 0x00007632003b7816ULL, 0x000fe20000000002ULL,
0x0000001008087824ULL, 0x100fe200078e0205ULL, 0x000000404100723eULL, 0x000fe200000000ffULL,
0x000000100a0a7824ULL, 0x000fe200078e0205ULL, 0x000000444502723eULL, 0x000fe200000000ffULL,
0x0000000107357824ULL, 0x000fe200078e0234ULL, 0x0000763242297816ULL, 0x000fe20000000046ULL,
0x0000000104047824ULL, 0x000fe200078e0207ULL, 0x0000000c0d0c723eULL, 0x000fe200000000ffULL,
0x0000000107367824ULL, 0x000fe200078e0236ULL, 0x000000141514723eULL, 0x000fe200000000ffULL,
0x0000000107387824ULL, 0x040fe200078e0238ULL, 0x0000003a04007388ULL, 0x000fe20000000a00ULL,
0x0000000107057824ULL, 0x040fe200078e0206ULL, 0x0000541000067816ULL, 0x040fe20000000002ULL,
0x0000000107087824ULL, 0x000fe200078e0208ULL, 0x0000001c1d1c723eULL, 0x000fe200000000ffULL,
0x0000000107347824ULL, 0x000fe200078e020aULL, 0x0000763200077816ULL, 0x000fc40000000002ULL,
0x00000018190a723eULL, 0x000fe400000000ffULL, 0x000000202120723eULL, 0x000fe200000000ffULL,
0x0000000605007388ULL, 0x0003e20000000a00ULL, 0x00007632140d7816ULL, 0x000fe4000000000aULL,
0x000000303130723eULL, 0x000fe400000000ffULL, 0x0000002c2d18723eULL, 0x000fe400000000ffULL,
0x0000000e0f0e723eULL, 0x000fc400000000ffULL, 0x000000161716723eULL, 0x000fe400000000ffULL,
0x0000001a1b1a723eULL, 0x000fe400000000ffULL, 0x0000541048067816ULL, 0x142fe40000000050ULL,
0x0000763248077816ULL, 0x000fe40000000050ULL, 0x0000001e1f1e723eULL, 0x000fe400000000ffULL,
0x00000022230f723eULL, 0x000fe200000000ffULL, 0x0000000608007388ULL, 0x0003e20000000a00ULL,
0x000000323332723eULL, 0x000fc400000000ffULL, 0x0000002e2f19723eULL, 0x000fe400000000ffULL,
0x000076321e217816ULL, 0x000fe4000000000fULL, 0x000000ff6000720cULL, 0x000fe40003f05270ULL,
0x0000541028067816ULL, 0x142fe40000000024ULL, 0x0000763228077816ULL, 0x000fe40000000024ULL,
0x0000541042287816ULL, 0x000fc40000000046ULL, 0x000054104a247816ULL, 0x140fe20000000025ULL,
0x0000000634007388ULL, 0x0003e20000000a00ULL, 0x000076324a257816ULL, 0x000fc60000000025ULL,
0x0000005635007388ULL, 0x000fe80000000a00ULL, 0x0004002805007388ULL, 0x0005e20000000a00ULL,
0x000000101106723eULL, 0x002fc600000000ffULL, 0x0004002408007388ULL, 0x000fe20000000a00ULL,
0x000054102a107816ULL, 0x140fe40000000026ULL, 0x000076322a117816ULL, 0x000fe40000000026ULL,
0x000000121307723eULL, 0x000fe400000000ffULL, 0x0000541032287816ULL, 0x144fe20000000019ULL,
0x0004001034007388ULL, 0x0003e20000000a00ULL, 0x0000763232297816ULL, 0x000fe40000000019ULL,
0x000054100c107816ULL, 0x002fc40000000006ULL, 0x000076320c117816ULL, 0x000fe40000000006ULL,
0x00005410140c7816ULL, 0x000fe4000000000aULL, 0x000054100e067816ULL, 0x140fe20000000007ULL,
0x0000001036007388ULL, 0x000fe20000000a00ULL, 0x000076320e077816ULL, 0x000fc60000000007ULL,
0x0008000c05007388ULL, 0x0003e40000000a00ULL, 0x000054101c0c7816ULL, 0x142fe40000000020ULL,
0x000076321c0d7816ULL, 0x000fe40000000020ULL, 0x000054101e207816ULL, 0x000fc6000000000fULL,
0x0008000c08007388ULL, 0x0003e40000000a00ULL, 0x00005410300c7816ULL, 0x142fe40000000018ULL,
0x00007632300d7816ULL, 0x000fca0000000018ULL, 0x0008000c34007388ULL, 0x000fe80000000a00ULL,
0x0000000638007388ULL, 0x0003e40000000a00ULL, 0x0000541016067816ULL, 0x142fe4000000001aULL,
0x0000763216077816ULL, 0x000fca000000001aULL, 0x000c000605007388ULL, 0x000fe80000000a00ULL,
0x000c002008007388ULL, 0x000fe80000000a00ULL, 0x000c002834007388ULL, 0x000fe20000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000005a0c7984ULL, 0x000e680000000c00ULL,
0x000400005a107984ULL, 0x000ea80000000c00ULL, 0x000800005a187984ULL, 0x000ee80000000c00ULL,
0x000c00005a207984ULL, 0x000f280000000c00ULL, 0x001000005a047984ULL, 0x000f680000000c00ULL,
0x001400005a147984ULL, 0x000f280000000c00ULL, 0x001800005a1c7984ULL, 0x000f280000000c00ULL,
0x001c00005a247984ULL, 0x000f620000000c00ULL, 0x200000ff0f0f7230ULL, 0x002fc40000000000ULL,
0x200000ff0e0e7230ULL, 0x000fe40000000000ULL, 0x200000ff0d0d7230ULL, 0x000fe40000000000ULL,
0x200000ff0c0c7230ULL, 0x000fe40000000000ULL, 0x200000ff13137230ULL, 0x004fe40000000000ULL,
0x200000ff12127230ULL, 0x000fe40000000000ULL, 0x200000ff11117230ULL, 0x000fc40000000000ULL,
0x200000ff10107230ULL, 0x000fe40000000000ULL, 0x200000ff1b1b7230ULL, 0x008fe40000000000ULL,
0x200000ff1a1a7230ULL, 0x000fe40000000000ULL, 0x200000ff19197230ULL, 0x000fe40000000000ULL,
0x200000ff18187230ULL, 0x000fe40000000000ULL, 0x200000ff23237230ULL, 0x010fc40000000000ULL,
0x200000ff22227230ULL, 0x000fe40000000000ULL, 0x200000ff21217230ULL, 0x000fe40000000000ULL,
0x200000ff20207230ULL, 0x000fe40000000000ULL, 0x000000070f0f7230ULL, 0x020fe40000000000ULL,
0x000000060e0e7230ULL, 0x000fe40000000000ULL, 0x000000050d0d7230ULL, 0x000fc40000000000ULL,
0x000000040c0c7230ULL, 0x000fe40000000000ULL, 0x0000001713137230ULL, 0x000fe40000000000ULL,
0x0000001612127230ULL, 0x000fe20000000000ULL, 0x0000000c5a007388ULL, 0x0003e20000000c00ULL,
0x0000001511117230ULL, 0x000fe40000000000ULL, 0x0000001410107230ULL, 0x000fe40000000000ULL,
0x0000001f1b1b7230ULL, 0x000fc40000000000ULL, 0x0000001e1a1a7230ULL, 0x000fe20000000000ULL,
0x000400105a007388ULL, 0x0003e20000000c00ULL, 0x0000001d19197230ULL, 0x000fe40000000000ULL,
0x0000001c18187230ULL, 0x000fe40000000000ULL, 0x0000002723237230ULL, 0x000fe40000000000ULL,
0x0000002622227230ULL, 0x000fe20000000000ULL, 0x000800185a007388ULL, 0x0003e20000000c00ULL,
0x0000002521217230ULL, 0x000fc40000000000ULL, 0x0000002420207230ULL, 0x000fca0000000000ULL,
0x000c00205a007388ULL, 0x0003e20000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000000479c3ULL, 0x000ea20000002700ULL,
0x00000003ff047819ULL, 0x000fe20000011603ULL, 0x0000840000057ab9ULL, 0x000fc60000000800ULL,
0x000000630400720cULL, 0x000fe20003f06070ULL, 0x00000005040472a4ULL, 0x004fd8000f8e023fULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000104007824ULL, 0x000fe200078e0203ULL,
0x00008600000a7ab9ULL, 0x000fe20000000800ULL, 0xffffffff00057882ULL, 0x000fe20000000000ULL,
0x0000880000087ab9ULL, 0x000fe20000000a00ULL, 0x0000000a05057299ULL, 0x000fe2000800063fULL,
0x0000000700007812ULL, 0x000fe400078ec0ffULL, 0x0000000703077812ULL, 0x000fe400078ec0ffULL,
0x0ffffff800007812ULL, 0x000fc600078ef803ULL, 0x0000000864077824ULL, 0x000fe400078e0207ULL,
0x0000001000027824ULL, 0x000fe400078e0209ULL, 0x0000002065007824ULL, 0x000fc600078e0204ULL,
0x00000000020c7984ULL, 0x0022a40000000c00ULL, 0x0000000500057c12ULL, 0x000fe4000f8e30ffULL,
0x0000000aff047c19ULL, 0x000fe20008011600ULL, 0x000000040b007c24ULL, 0x000fe4000f8e02ffULL,
0x0000000176057824ULL, 0x000fe400078e0205ULL, 0x0000002003027836ULL, 0x002fe40000000000ULL,
0x0000000b04057224ULL, 0x000fca00078e0205ULL, 0x0000000500057210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff067224ULL, 0x000fe200000e06ffULL, 0x0000000805047c11ULL, 0x000fc8000f8040ffULL,
0x0000000905057c11ULL, 0x000fe400080f4406ULL, 0x00000003ff067819ULL, 0x000fe20000011602ULL,
0x0000001007047825ULL, 0x000fc600078e0004ULL, 0x000000630600720cULL, 0x000fe40003f06070ULL,
0x0000000c04007986ULL, 0x0043f6000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000102047824ULL, 0x142fe200078e0206ULL, 0x0000000702117812ULL, 0x000fe200078ec0ffULL,
0x0000002065067824ULL, 0x000fc600078e0206ULL, 0x0000000704057812ULL, 0x000fe200078ec0ffULL,
0x0000000864117824ULL, 0x000fc600078e0211ULL, 0x0ffffff805047812ULL, 0x000fe200078ef802ULL,
0x0000004003027836ULL, 0x000fe20000000000ULL, 0x0000000506057c12ULL, 0x000fe4000f8e30ffULL,
0x0000000aff067c19ULL, 0x000fe20008011606ULL, 0x0000001004077824ULL, 0x000fe400078e0209ULL,
0x0000000176057824ULL, 0x000fc600078e0205ULL, 0x00000000070c7984ULL, 0x000e620000000c00ULL,
0x0000000b06057224ULL, 0x000fca00078e0205ULL, 0x0000000500057210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff067224ULL, 0x000fe200000e06ffULL, 0x0000000805047c11ULL, 0x000fc8000f8040ffULL,
0x0000000905057c11ULL, 0x000fe400080f4406ULL, 0x00000003ff067819ULL, 0x000fe20000011602ULL,
0x0000001011047825ULL, 0x000fc600078e0004ULL, 0x000000630600720cULL, 0x000fe40003f06070ULL,
0x0000000c04007986ULL, 0x0023f6000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000102047824ULL, 0x142fe200078e0206ULL, 0x0000000702117812ULL, 0x000fe200078ec0ffULL,
0x0000002065067824ULL, 0x000fc600078e0206ULL, 0x0000000704057812ULL, 0x000fe200078ec0ffULL,
0x0000000864117824ULL, 0x000fc600078e0211ULL, 0x0ffffff805047812ULL, 0x000fe200078ef802ULL,
0x0000006003027836ULL, 0x000fe20000000000ULL, 0x0000000506057c12ULL, 0x000fe4000f8e30ffULL,
0x0000000aff067c19ULL, 0x000fe20008011606ULL, 0x0000001004077824ULL, 0x000fe400078e0209ULL,
0x0000000176057824ULL, 0x000fc600078e0205ULL, 0x00000000070c7984ULL, 0x000e620000000c00ULL,
0x0000000b06057224ULL, 0x000fca00078e0205ULL, 0x0000000500057210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff067224ULL, 0x000fe200000e06ffULL, 0x0000000805047c11ULL, 0x000fc8000f8040ffULL,
0x0000000905057c11ULL, 0x000fe400080f4406ULL, 0x00000003ff067819ULL, 0x000fe20000011602ULL,
0x0000001011047825ULL, 0x000fc600078e0004ULL, 0x000000630600720cULL, 0x000fe40003f06070ULL,
0x0000000c04007986ULL, 0x0023f6000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000102047824ULL, 0x142fe200078e0206ULL, 0x0000000702117812ULL, 0x000fe200078ec0ffULL,
0x0000002065067824ULL, 0x000fc600078e0206ULL, 0x0000000704057812ULL, 0x000fe200078ec0ffULL,
0x0000000864117824ULL, 0x000fc600078e0211ULL, 0x0ffffff805047812ULL, 0x000fe200078ef802ULL,
0x0000008003027836ULL, 0x000fe20000000000ULL, 0x0000000506057c12ULL, 0x000fe4000f8e30ffULL,
0x0000000aff067c19ULL, 0x000fe20008011606ULL, 0x0000001004077824ULL, 0x000fe400078e0209ULL,
0x0000000176057824ULL, 0x000fc600078e0205ULL, 0x00000000070c7984ULL, 0x000e620000000c00ULL,
0x0000000b06057224ULL, 0x000fca00078e0205ULL, 0x0000000500057210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff067224ULL, 0x000fe200000e06ffULL, 0x0000000805047c11ULL, 0x000fc8000f8040ffULL,
0x0000000905057c11ULL, 0x000fe400080f4406ULL, 0x00000003ff067819ULL, 0x000fe20000011602ULL,
0x0000001011047825ULL, 0x000fc600078e0004ULL, 0x000000630600720cULL, 0x000fe40003f06070ULL,
0x0000000c04007986ULL, 0x0023f6000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000102047824ULL, 0x142fe200078e0206ULL, 0x0000000702117812ULL, 0x000fe200078ec0ffULL,
0x0000002065067824ULL, 0x000fc600078e0206ULL, 0x0000000704057812ULL, 0x000fe200078ec0ffULL,
0x0000000864117824ULL, 0x000fc600078e0211ULL, 0x0ffffff805047812ULL, 0x000fe200078ef802ULL,
0x000000a003027836ULL, 0x000fe20000000000ULL, 0x0000000506057c12ULL, 0x000fe4000f8e30ffULL,
0x0000000aff067c19ULL, 0x000fe20008011606ULL, 0x0000001004077824ULL, 0x000fe400078e0209ULL,
0x0000000176057824ULL, 0x000fc600078e0205ULL, 0x00000000070c7984ULL, 0x000e620000000c00ULL,
0x0000000b06057224ULL, 0x000fca00078e0205ULL, 0x0000000500057210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff067224ULL, 0x000fe200000e06ffULL, 0x0000000805047c11ULL, 0x000fc8000f8040ffULL,
0x0000000905057c11ULL, 0x000fe400080f4406ULL, 0x00000003ff067819ULL, 0x000fe20000011602ULL,
0x0000001011047825ULL, 0x000fc600078e0004ULL, 0x000000630600720cULL, 0x000fe40003f06070ULL,
0x0000000c04007986ULL, 0x0023f6000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000102047824ULL, 0x142fe200078e0206ULL, 0x0000000702117812ULL, 0x000fe200078ec0ffULL,
0x0000002065067824ULL, 0x000fc600078e0206ULL, 0x0000000704057812ULL, 0x000fe200078ec0ffULL,
0x0000000864117824ULL, 0x000fc600078e0211ULL, 0x0ffffff805047812ULL, 0x000fe400078ef802ULL,
0x0000000506057c12ULL, 0x000fe4000f8e30ffULL, 0x0000000aff067c19ULL, 0x000fe20008011606ULL,
0x0000001004077824ULL, 0x000fe400078e0209ULL, 0x0000000176057824ULL, 0x000fc600078e0205ULL,
0x00000000070c7984ULL, 0x000e620000000c00ULL, 0x0000000b06057224ULL, 0x000fca00078e0205ULL,
0x0000000500057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff067224ULL, 0x000fe200000e06ffULL,
0x0000000805047c11ULL, 0x000fc8000f8040ffULL, 0x0000000905057c11ULL, 0x000fe200080f4406ULL,
0x000000c003067836ULL, 0x000fe40000000000ULL, 0x0000001011047825ULL, 0x000fc600078e0004ULL,
0x00000003ff027819ULL, 0x000fc80000011606ULL, 0x000000630200720cULL, 0x000fe20003f06070ULL,
0x0000000c04007986ULL, 0x0023d8000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000106047824ULL, 0x102fe400078e0202ULL, 0x0000002065027824ULL, 0x000fe400078e0202ULL,
0x000000e003077836ULL, 0x000fe20000000000ULL, 0x0000000704057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805047812ULL, 0x000fe400078ef806ULL, 0x0000000502057c12ULL, 0x000fe4000f8e30ffULL,
0x0000000aff027c19ULL, 0x000fe20008011602ULL, 0x0000001004047824ULL, 0x000fe200078e0209ULL,
0x00000003ff087819ULL, 0x000fe20000011607ULL, 0x0000000176057824ULL, 0x000fc600078e0205ULL,
0x00000000040c7984ULL, 0x0002a20000000c00ULL, 0x0000000b02057224ULL, 0x000fca00078e0205ULL,
0x00000005000a7210ULL, 0x000fe40007f1e0ffULL, 0x0000000706057812ULL, 0x000fe200078ec0ffULL,
0x0000000107047824ULL, 0x002fe400078e0208ULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x000000080a027c11ULL, 0x000fe2000f8040ffULL, 0x0000000864057824ULL, 0x000fe200078e0205ULL,
0x0000000704047812ULL, 0x000fe400078ec0ffULL, 0x000000090a037c11ULL, 0x000fc400080f4403ULL,
0x000000630800720cULL, 0x000fe40003f06070ULL, 0xfffffff804047812ULL, 0x000fe200078ef807ULL,
0x0000001005027825ULL, 0x000fca00078e0002ULL, 0x0000000c02007986ULL, 0x0043ea000c101d06ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000001004047824ULL, 0x000fe200078e0209ULL,
0x0000000707077812ULL, 0x000fe200078ec0ffULL, 0x0000002065087824ULL, 0x000fc600078e0208ULL,
0x00000000040c7984ULL, 0x002e620000000c00ULL, 0x0000000864077824ULL, 0x000fe200078e0207ULL,
0x0000000508037c12ULL, 0x000fe4000f8e30ffULL, 0x0000000aff087c19ULL, 0x000fc60008011608ULL,
0x0000000176037824ULL, 0x000fc800078e0203ULL, 0x0000000b08037224ULL, 0x000fca00078e0203ULL,
0x0000000300037210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff007224ULL, 0x000fe200000e06ffULL,
0x0000000803027c11ULL, 0x000fc8000f8040ffULL, 0x0000000903037c11ULL, 0x000fc600080f4400ULL,
0x0000001007027825ULL, 0x000fca00078e0002ULL, 0x0000000c02007986ULL, 0x002fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00009600ff587b82ULL, 0x000e620000000a00ULL,
0x000001ff0200780cULL, 0x000fe20003f04070ULL, 0x0000000217177824ULL, 0x000fe200078e00ffULL,
0x0000920000047ab9ULL, 0x000fe20000000800ULL, 0x0000000658587981ULL, 0x002322000c1e9900ULL,
0x00000001ff067424ULL, 0x000fe400078e00ffULL, 0x0000004078777824ULL, 0x000fe400078e00ffULL,
0x0000000517027224ULL, 0x000fe400078e0208ULL, 0x01a60006090679a7ULL, 0x0002a4000850003fULL,
0x0000000402057c24ULL, 0x000fe2000f8e0277ULL, 0x0000000c00240947ULL, 0x000fec0003800000ULL,
0x00000003ff377819ULL, 0x000fe2000001160aULL, 0x00008e0000047ab9ULL, 0x000fe20000000a00ULL,
0x0000007761047248ULL, 0x000fc60007fe0000ULL, 0x00000004370d7836ULL, 0x000fe40000000000ULL,
0x0000000837117836ULL, 0x000fe40000000000ULL, 0x000000010d087824ULL, 0x140fe400078e020aULL,
0x000000080d217824ULL, 0x000fe400078e00ffULL, 0x0000000104047824ULL, 0x000fe400078e0a77ULL,
0x00000001050e7824ULL, 0x000fe200078e020dULL, 0xfffffff821217812ULL, 0x000fe200078ee208ULL,
0x00000001110b7824ULL, 0x000fe200078e020aULL, 0x000000040d00720cULL, 0x000fe20003fa6070ULL,
0x0000000811087824ULL, 0x000fc400078e00ffULL, 0x00000001050c7824ULL, 0x000fe400078e0237ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0xfffffff808237812ULL, 0x000fc600078ee20bULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x000000700e187812ULL, 0x000fc600078ef803ULL,
0x00000010370b7836ULL, 0x000fe20000000000ULL, 0x000000700c167812ULL, 0x000fe200078ef803ULL,
0x0000000c37137836ULL, 0x000fe20000000000ULL, 0x0000000418187c10ULL, 0x000fe2000ff3e0ffULL,
0x000000010b0c7824ULL, 0x040fe200078e020aULL, 0x0000000416167c10ULL, 0x000fe2000ff1e0ffULL,
0x000000080b277824ULL, 0x000fe200078e00ffULL, 0x000000050f197c10ULL, 0x000fe20008ffe4ffULL,
0x00000001050e7824ULL, 0x040fe200078e0213ULL, 0x000000050d177c10ULL, 0x000fe200087fe4ffULL,
0x00000018372b7836ULL, 0x000fe20000000000ULL, 0xfffffff827277812ULL, 0x000fe200078ee20cULL,
0x00000001050c7824ULL, 0x000fe200078e0211ULL, 0x000000041100720cULL, 0x080fe20003f26070ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000040b00720cULL, 0x000fc40003f06070ULL,
0x000000041300720cULL, 0x000fe20003f46070ULL, 0x0000000105147824ULL, 0x000fe200078e022bULL,
0x000000700e1c7812ULL, 0x000fe200078ef803ULL, 0x000000800c0c7825ULL, 0x000fc600078e00ffULL,
0x000000041c1c7c10ULL, 0x000fe2000ff9e0ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x000000700c1a7812ULL, 0x000fe400078ef803ULL, 0x000000050f1d7c10ULL, 0x000fe2000a7fe4ffULL,
0x0000000105107824ULL, 0x000fe200078e020bULL, 0x0000007014147812ULL, 0x000fe200078ef803ULL,
0x00000014371f7836ULL, 0x000fe20000000000ULL, 0x000000041a1a7c10ULL, 0x000fe2000ff7e0ffULL,
0x0000001c372d7836ULL, 0x000fe20000000000ULL, 0x0000000414147c10ULL, 0x000fe2000ff9e0ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000000050d1b7c10ULL, 0x000fc40009ffe4ffULL,
0x0000000515157c10ULL, 0x000fe2000a7fe4ffULL, 0x0000000105127824ULL, 0x000fe200078e021fULL,
0x0000007010107812ULL, 0x000fe200078ef803ULL, 0x0000000113087824ULL, 0x100fe200078e020aULL,
0x000000043700720cULL, 0x000fe20003f86070ULL, 0x0000000813257824ULL, 0x000fe200078e00ffULL,
0x0000000410107c10ULL, 0x000fe2000ff7e0ffULL, 0x00000001050c7824ULL, 0x000fe400078e022dULL,
0x00000001370b7824ULL, 0x000fe200078e020aULL, 0xfffffff825257812ULL, 0x000fe200078ee208ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000000511117c10ULL, 0x000fc40009ffe4ffULL,
0x000000070b0f7812ULL, 0x000fe200078ec0ffULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x0000007012127812ULL, 0x000fe400078ef803ULL, 0x0ffffff80f0f7812ULL, 0x000fe200078ef80aULL,
0x0000400078087824ULL, 0x000fe200078e0209ULL, 0x000000700c1e7812ULL, 0x000fe200078ef803ULL,
0x000000011f0b7824ULL, 0x040fe200078e020aULL, 0x0000000412127c10ULL, 0x000fe2000ff7e0ffULL,
0x000000081f0e7824ULL, 0x040fe200078e00ffULL, 0x000000041e1e7c10ULL, 0x000fe2000ffde0ffULL,
0x0000200008087836ULL, 0x000fe20000000000ULL, 0x0000000513137c10ULL, 0x000fe20009ffe4ffULL,
0x00000020372f7836ULL, 0x000fe20000000000ULL, 0xfffffff80e297812ULL, 0x000fe200078ee20bULL,
0x0000002437317836ULL, 0x000fe20000000000ULL, 0x000000041f00720cULL, 0x000fe20003f66070ULL,
0x00000001050c7824ULL, 0x000fe200078e022fULL, 0x000000050d1f7c10ULL, 0x000fe2000b7fe4ffULL,
0x000000100f0b7824ULL, 0x000fc400078e0208ULL, 0x00000001050e7824ULL, 0x000fe400078e0231ULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000160b7faeULL, 0x0007e2000e101c46ULL, 0x000000042b00720cULL, 0x000fe40003f86070ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000700c207812ULL, 0x000fc600078ef803ULL,
0x0000002837337836ULL, 0x000fe20000000000ULL, 0x0000000420207c10ULL, 0x000fe2000ffde0ffULL,
0x000000012b0c7824ULL, 0x040fe400078e020aULL, 0x000000082b2b7824ULL, 0x000fe200078e00ffULL,
0x000000700e167812ULL, 0x008fe200078ef803ULL, 0x00000010210b7824ULL, 0x000fe200078e0208ULL,
0x000000050d217c10ULL, 0x000fe2000b7fe4ffULL, 0x000000012d0e7824ULL, 0x000fe200078e020aULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee20cULL, 0x0000000105227824ULL, 0x000fe200078e0233ULL,
0x00000000180b7faeULL, 0x0007e2000e901c46ULL, 0x000000042d00720cULL, 0x040fe20003fa6070ULL,
0x000000082d2d7824ULL, 0x000fe200078e00ffULL, 0x0000000416167c10ULL, 0x000fe2000ffde0ffULL,
0x0000001023237824ULL, 0x000fc400078e0208ULL, 0x0000002c37357836ULL, 0x000fe20000000000ULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee20eULL, 0x0000001025257824ULL, 0x100fe200078e0208ULL,
0x000000001a237faeULL, 0x000be2000c901c46ULL, 0x00000080220c7825ULL, 0x000fe200078e00ffULL,
0x000000050f177c10ULL, 0x000fe4000b7fe4ffULL, 0x000000001c257faeULL, 0x000fe2000d101c46ULL,
0x0000001027277824ULL, 0x000fe200078e0208ULL, 0x000000700c0c7812ULL, 0x000fe200078ef803ULL,
0x00000001050e7824ULL, 0x000fe200078e0235ULL, 0x000000042f00720cULL, 0x0c0fe20003f26070ULL,
0x000000012f0b7824ULL, 0x008fe200078e020aULL, 0x0000000010277faeULL, 0x0007e2000c101c46ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000043100720cULL, 0x000fc40003f46070ULL,
0x000000040c0c7c10ULL, 0x000fe2000ffde0ffULL, 0x00000030371b7836ULL, 0x022fe20000000000ULL,
0x000000700e0e7812ULL, 0x000fe200078ef803ULL, 0x000000082f227824ULL, 0x000fe200078e00ffULL,
0x000000050d0d7c10ULL, 0x000fe2000b7fe4ffULL, 0x0000000131187824ULL, 0x040fe200078e020aULL,
0x000000040e0e7c10ULL, 0x000fe2000ffde0ffULL, 0x0000000831197824ULL, 0x000fe200078e00ffULL,
0xfffffff8220b7812ULL, 0x000fe200078ee20bULL, 0x0000000105107824ULL, 0x008fe200078e021bULL,
0x000000050f0f7c10ULL, 0x000fe2000b7fe4ffULL, 0x0000001029297824ULL, 0x100fe200078e0208ULL,
0xfffffff819197812ULL, 0x000fe200078ee218ULL, 0x000000102b2b7824ULL, 0x000fc400078e0208ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000000012297faeULL, 0x0003e2000d901c46ULL,
0x000000041b00720cULL, 0x080fe40003f66070ULL, 0x00000034371d7836ULL, 0x004fe20000000000ULL,
0x00000000142b7faeULL, 0x0005e2000e101c46ULL, 0x000000102d2d7824ULL, 0x100fe200078e0208ULL,
0x000000043500720cULL, 0x080fe20003f86070ULL, 0x000000100b0b7824ULL, 0x100fe400078e0208ULL,
0x0000001019197824ULL, 0x000fe200078e0208ULL, 0x000000001e2d7faeULL, 0x000fe2000e901c46ULL,
0x0000003837237836ULL, 0x000fe20000000000ULL, 0x000000043300720cULL, 0x080fe20003fa6070ULL,
0x0000000105127824ULL, 0x002fe200078e021dULL, 0x00000000200b7faeULL, 0x0003e2000c901c46ULL,
0x0000003c37257836ULL, 0x000fe20000000000ULL, 0x0000007010147812ULL, 0x004fe200078ef803ULL,
0x0000000133157824ULL, 0x040fe200078e020aULL, 0x0000000016197faeULL, 0x0005e2000d101c46ULL,
0x0000000833187824ULL, 0x000fe200078e00ffULL, 0x0000000414147c10ULL, 0x000fe2000ffde0ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x000000041d00720cULL, 0x000fc40003f46070ULL,
0x000000042300720cULL, 0x080fe20003f26070ULL, 0x0000000105107824ULL, 0x000fe200078e0223ULL,
0x000000042500720cULL, 0x000fe20003f06070ULL, 0x0000000135047824ULL, 0x100fe200078e020aULL,
0x0000007012127812ULL, 0x000fe200078ef803ULL, 0x000000011b0b7824ULL, 0x002fe200078e020aULL,
0xfffffff818177812ULL, 0x004fe200078ee215ULL, 0x0000000835197824ULL, 0x000fe200078e00ffULL,
0x0000000511157c10ULL, 0x000fe2000b7fe4ffULL, 0x000000081b167824ULL, 0x000fe200078e00ffULL,
0x0000000412127c10ULL, 0x000fe2000ffde0ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0xfffffff819197812ULL, 0x000fc400078ee204ULL, 0xfffffff8161b7812ULL, 0x000fe200078ee20bULL,
0x0000000105057824ULL, 0x000fe200078e0225ULL, 0x0000007010187812ULL, 0x000fe200078ef803ULL,
0x000000011d0b7824ULL, 0x000fe200078e020aULL, 0x0000000513137c10ULL, 0x000fe2000b7fe4ffULL,
0x0000008005047825ULL, 0x000fc800078e00ffULL, 0x000000081d1a7824ULL, 0x000fe200078e00ffULL,
0x0000007004037812ULL, 0x000fe200078ef803ULL, 0x0000000123167824ULL, 0x140fe400078e020aULL,
0x00000008231f7824ULL, 0x000fe200078e00ffULL, 0xfffffff81a1d7812ULL, 0x000fe200078ee20bULL,
0x0000000125107824ULL, 0x040fe200078e020aULL, 0x00000004180a7c10ULL, 0x000fe2000ffde0ffULL,
0x0000000825217824ULL, 0x000fe200078e00ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee216ULL,
0x0000001017177824ULL, 0x100fe200078e0208ULL, 0x00000005110b7c10ULL, 0x000fe2000b7fe4ffULL,
0x0000001019197824ULL, 0x100fe200078e0208ULL, 0xfffffff821217812ULL, 0x000fe200078ee210ULL,
0x000000101b1b7824ULL, 0x100fe200078e0208ULL, 0x0000000403047c10ULL, 0x000fe2000ffde0ffULL,
0x000000101d1d7824ULL, 0x100fe200078e0208ULL, 0x000000000c177faeULL, 0x0003e2000e901c46ULL,
0x000000101f1f7824ULL, 0x100fe200078e0208ULL, 0x0000000505057c10ULL, 0x000fe2000b7fe4ffULL,
0x0000001021217824ULL, 0x000fe200078e0208ULL, 0x000000000e197faeULL, 0x0003e8000e101c46ULL,
0x00000000141b7faeULL, 0x0003e8000d901c46ULL, 0x00000000121d7faeULL, 0x0003e8000d101c46ULL,
0x000000000a1f7faeULL, 0x0003e8000c901c46ULL, 0x0000000004217faeULL, 0x0003e2000c101c46ULL,
0x0000000800d47947ULL, 0x000fea0003800000ULL, 0x000000040a0c7811ULL, 0x040fe200078fe8ffULL,
0x00008e0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000c0a107811ULL, 0x040fe400078fe8ffULL,
0x000000100a127811ULL, 0x000fe200078fe8ffULL, 0x000000010c047824ULL, 0x100fe200078e020aULL,
0x000000080a0d7811ULL, 0x000fe200078fe8ffULL, 0x000000080c0b7824ULL, 0x000fe200078e00ffULL,
0x0000001c0a197811ULL, 0x000fe200078fe8ffULL, 0x0000000110087824ULL, 0x100fe200078e020aULL,
0x000000200a1b7811ULL, 0x000fe200078fe8ffULL, 0x0000000810117824ULL, 0x000fe200078e00ffULL,
0xfffffff80b0e7812ULL, 0x000fe200078ee204ULL, 0x00000001120b7824ULL, 0x100fe200078e020aULL,
0x000000240a1e7811ULL, 0x000fe200078fe8ffULL, 0x0000000812167824ULL, 0x000fe200078e00ffULL,
0xfffffff811117812ULL, 0x000fe200078ee208ULL, 0x000000010d047824ULL, 0x140fe200078e020aULL,
0x000000140a147811ULL, 0x040fe200078fe8ffULL, 0x000000080d0f7824ULL, 0x000fe200078e00ffULL,
0xfffffff816137812ULL, 0x000fe200078ee20bULL, 0x0000000119087824ULL, 0x140fe200078e020aULL,
0x000000180a167811ULL, 0x040fe200078fe8ffULL, 0x00000008191f7824ULL, 0x000fe200078e00ffULL,
0x0000002c0a247811ULL, 0x000fe200078fe8ffULL, 0x000000011b0b7824ULL, 0x140fe200078e020aULL,
0xfffffff80f0f7812ULL, 0x000fe200078ee204ULL, 0x000000081b1c7824ULL, 0x000fe200078e00ffULL,
0xfffffff81f1a7812ULL, 0x000fe200078ee208ULL, 0x000000011e177824ULL, 0x100fe200078e020aULL,
0x000000300a267811ULL, 0x000fe200078fe8ffULL, 0x000000081e207824ULL, 0x000fe200078e00ffULL,
0x000000280a227811ULL, 0x000fe200078fe8ffULL, 0x0000000114157824ULL, 0x100fe200078e020aULL,
0x000000340a297811ULL, 0x000fe200078fe8ffULL, 0x0000000814187824ULL, 0x000fe200078e00ffULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee20bULL, 0x0000000116047824ULL, 0x140fe200078e020aULL,
0xfffffff8201f7812ULL, 0x000fe200078ee217ULL, 0x00000008161d7824ULL, 0x000fe200078e00ffULL,
0xfffffff818157812ULL, 0x000fe200078ee215ULL, 0x0000000124087824ULL, 0x100fe200078e020aULL,
0x000000380a2b7811ULL, 0x000fe200078fe8ffULL, 0x0000000824257824ULL, 0x000fe200078e00ffULL,
0xfffffff81d187812ULL, 0x000fe200078ee204ULL, 0x00000001260b7824ULL, 0x100fe200078e020aULL,
0x0000003c0a2d7811ULL, 0x000fe200078fe8ffULL, 0x0000000826207824ULL, 0x000fe200078e00ffULL,
0xfffffff825257812ULL, 0x000fe200078ee208ULL, 0x0000000122047824ULL, 0x100fe200078e020aULL,
0x0000000a0a087211ULL, 0x000fe200078fe8ffULL, 0x0000000822237824ULL, 0x000fe200078e00ffULL,
0xfffffff820277812ULL, 0x000fe200078ee20bULL, 0x0000000129177824ULL, 0x040fe200078e020aULL,
0x00000007080b7812ULL, 0x000fe200078ec0ffULL, 0x00000008292c7824ULL, 0x000fe200078e00ffULL,
0xfffffff823237812ULL, 0x000fe200078ee204ULL, 0x00000001051d7824ULL, 0x040fe200078e0219ULL,
0x000000050a047211ULL, 0x000fe200078fe8ffULL, 0x00000001052e7824ULL, 0x040fe200078e022bULL,
0xfffffff82c2c7812ULL, 0x000fe200078ee217ULL, 0x0000000105177824ULL, 0x000fe200078e0216ULL,
0x0ffffff80b087812ULL, 0x000fe200078ef80aULL, 0x000000012b167824ULL, 0x000fc400078e020aULL,
0x000000012d0a7824ULL, 0x040fe400078e020aULL, 0x000000082d197824ULL, 0x000fe400078e00ffULL,
0x00000001050c7824ULL, 0x040fe400078e020cULL, 0x00000001050d7824ULL, 0x040fe200078e020dULL,
0xfffffff819197812ULL, 0x000fe200078ee20aULL, 0x0000000105107824ULL, 0x040fe400078e0210ULL,
0x0000000105127824ULL, 0x000fc400078e0212ULL, 0x0000000105147824ULL, 0x040fe400078e0214ULL,
0x0000000105207824ULL, 0x040fe400078e021bULL, 0x0000000105217824ULL, 0x040fe400078e021eULL,
0x0000000105227824ULL, 0x040fe400078e0222ULL, 0x0000000105247824ULL, 0x040fe400078e0224ULL,
0x0000000105287824ULL, 0x000fc400078e0226ULL, 0x00000001052a7824ULL, 0x000fe400078e0229ULL,
0x000000082b2b7824ULL, 0x000fe400078e00ffULL, 0x0000000105307824ULL, 0x000fe400078e022dULL,
0x00004000780b7824ULL, 0x000fe200078e0209ULL, 0xfffffff82b167812ULL, 0x000fe200078ee216ULL,
0x0000008004047825ULL, 0x000fc800078e00ffULL, 0x000020000b1e7836ULL, 0x000fe20000000000ULL,
0x0000007004047812ULL, 0x000fe200078ef803ULL, 0x000000800c0a7825ULL, 0x000fc600078e00ffULL,
0x0000000404047c10ULL, 0x000fe2000ff1e0ffULL, 0x000000800d0c7825ULL, 0x000fe200078e00ffULL,
0x000000700a0a7812ULL, 0x000fe400078ef803ULL, 0x0000000505057c10ULL, 0x000fe200087fe4ffULL,
0x000000100e2b7824ULL, 0x100fe200078e021eULL, 0x000000040a0a7c10ULL, 0x000fe2000ff3e0ffULL,
0x000000100f2d7824ULL, 0x100fe400078e021eULL, 0x0000001016457824ULL, 0x000fe200078e021eULL,
0x000000700c167812ULL, 0x000fe200078ef803ULL, 0x00000080100e7825ULL, 0x000fe200078e00ffULL,
0x000000050b0b7c10ULL, 0x000fc40008ffe4ffULL, 0x0000000416167c10ULL, 0x000fe2000ff1e0ffULL,
0x00000010112f7824ULL, 0x100fe400078e021eULL, 0x0000001013317824ULL, 0x100fe400078e021eULL,
0x0000001018357824ULL, 0x000fe200078e021eULL, 0x000000700e187812ULL, 0x000fe200078ef803ULL,
0x0000008012107825ULL, 0x000fc800078e00ffULL, 0x0000008014127825ULL, 0x000fc800078e00ffULL,
0x0000001015337824ULL, 0x100fe400078e021eULL, 0x0000008017147825ULL, 0x000fe200078e00ffULL,
0x000000050d177c10ULL, 0x000fe400087fe4ffULL, 0x0000000418187c10ULL, 0x000fe2000ff1e0ffULL,
0x000000101a377824ULL, 0x100fe200078e021eULL, 0x00000070101a7812ULL, 0x000fe200078ef803ULL,
0x000000101c397824ULL, 0x100fe200078e021eULL, 0x00000070121c7812ULL, 0x000fe200078ef803ULL,
0x0000001008297824ULL, 0x100fe200078e021eULL, 0x000000041a1a7c10ULL, 0x000fe2000ff3e0ffULL,
0x000000101f3b7824ULL, 0x000fc400078e021eULL, 0x00000010233d7824ULL, 0x100fe200078e021eULL,
0x00000005111b7c10ULL, 0x000fe20008ffe4ffULL, 0x00000010253f7824ULL, 0x100fe200078e021eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004297faeULL, 0x0007e2000b901c46ULL,
0x0000001027417824ULL, 0x100fe400078e021eULL, 0x000000102c437824ULL, 0x100fe200078e021eULL,
0x000000000a2b7faeULL, 0x0007e2000b901c46ULL, 0x0000001019477824ULL, 0x000fe200078e021eULL,
0x00000070141e7812ULL, 0x000fe200078ef803ULL, 0x000000801d0c7825ULL, 0x000fe200078e00ffULL,
0x000000050f197c10ULL, 0x000fe200087fe4ffULL, 0x00000000162d7faeULL, 0x0007e2000b901c46ULL,
0x000000041c1c7c10ULL, 0x000fe2000ff1e0ffULL, 0x00000080200e7825ULL, 0x000fe200078e00ffULL,
0x000000041e1e7c10ULL, 0x000fe2000ff5e0ffULL, 0x00000000182f7faeULL, 0x0007e2000b901c46ULL,
0x00000005131d7c10ULL, 0x000fe200087fe4ffULL, 0x0000008021107825ULL, 0x000fe200078e00ffULL,
0x000000700c207812ULL, 0x000fe200078ef803ULL, 0x000000001a317faeULL, 0x0007e2000b901c46ULL,
0x00000005151f7c10ULL, 0x000fe200097fe4ffULL, 0x0000008022127825ULL, 0x000fe200078e00ffULL,
0x000000700e227812ULL, 0x000fe200078ef803ULL, 0x000000001c337faeULL, 0x0007e2000b901c46ULL,
0x0000000420207c10ULL, 0x000fe2000ff1e0ffULL, 0x0000008024147825ULL, 0x000fe200078e00ffULL,
0x0000007010247812ULL, 0x000fe200078ef803ULL, 0x000000001e357faeULL, 0x0007e2000b901c46ULL,
0x0000007012267812ULL, 0x000fc400078ef803ULL, 0x0000000422227c10ULL, 0x000fe4000ff3e0ffULL,
0x000000050d217c10ULL, 0x000fe200087fe4ffULL, 0x00000080280c7825ULL, 0x000fe200078e00ffULL,
0x0000000424247c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000426267c10ULL, 0x000fe2000ff5e0ffULL,
0x0000000020377faeULL, 0x0007e2000b901c46ULL, 0x000000050f237c10ULL, 0x000fe20008ffe4ffULL,
0x000000802a0e7825ULL, 0x000fe200078e00ffULL, 0x0000007014147812ULL, 0x000fc400078ef803ULL,
0x0000000511257c10ULL, 0x000fe200087fe4ffULL, 0x000000802e107825ULL, 0x000fe200078e00ffULL,
0x0000000513277c10ULL, 0x000fe200097fe4ffULL, 0x0000000022397faeULL, 0x0007e2000b901c46ULL,
0x0000000414147c10ULL, 0x000fe2000ff1e0ffULL, 0x0000008030127825ULL, 0x000fe200078e00ffULL,
0x000000700c0c7812ULL, 0x000fe200078ef803ULL, 0x00000000243b7faeULL, 0x0007e2000b901c46ULL,
0x000000700e0e7812ULL, 0x000fe400078ef803ULL, 0x0000007010107812ULL, 0x000fe200078ef803ULL,
0x00000000263d7faeULL, 0x0007e2000b901c46ULL, 0x0000000515157c10ULL, 0x000fc400087fe4ffULL,
0x0000007012037812ULL, 0x000fe400078ef803ULL, 0x000000040c0c7c10ULL, 0x000fe2000ff1e0ffULL,
0x00000000143f7faeULL, 0x0007e2000b901c46ULL, 0x000000040e0e7c10ULL, 0x000fe4000ff3e0ffULL,
0x0000000410107c10ULL, 0x000fe4000ff5e0ffULL, 0x0000000403127c10ULL, 0x000fe4000ff7e0ffULL,
0x000000050d0d7c10ULL, 0x000fc400087fe4ffULL, 0x000000050f0f7c10ULL, 0x000fe40008ffe4ffULL,
0x0000000511117c10ULL, 0x000fe200097fe4ffULL, 0x000000000c417faeULL, 0x0007e2000b901c46ULL,
0x0000000513137c10ULL, 0x000fc60009ffe4ffULL, 0x000000000e437faeULL, 0x0007e8000b901c46ULL,
0x0000000010457faeULL, 0x0007e8000b901c46ULL, 0x0000000012477faeULL, 0x0007e4000b901c46ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000047805ULL, 0x00afce0000015200ULL,
0x01a60007090075a7ULL, 0x004e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff0c7224ULL, 0x000fce00078e00ffULL, 0x000000100c00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fce0000015200ULL,
0x0000000a04087210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0a7824ULL, 0x000fe200000e0e05ULL,
0x003d09000800780cULL, 0x000fc80003f06070ULL, 0x000000ff0a00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400800780cULL, 0x000fc80003f06070ULL,
0x000000ff0a00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff037819ULL, 0x000fc8000001140aULL, 0x0000000803037211ULL, 0x000fca00078110ffULL,
0x000000ffff087224ULL, 0x000fca00000e060aULL, 0x0000000203037819ULL, 0x000fc80000001208ULL,
0x000000030000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000010c0c7836ULL, 0x000fce0000000000ULL, 0x01a60007090075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000000037919ULL, 0x000e640000000000ULL,
0x0000002078037824ULL, 0x002fc800078e0203ULL, 0x0000000103057836ULL, 0x000fe20000000000ULL,
0x00000004ff047819ULL, 0x000fc80000011603ULL, 0x0ffffffe04067812ULL, 0x000fe400078ec0ffULL,
0x0000001f03047812ULL, 0x000fc600078ec0ffULL, 0x0000000106087824ULL, 0x000fe400078e0205ULL,
0x0000000103077824ULL, 0x000fe400078e0206ULL, 0x00000010040b7824ULL, 0x000fe200078e00ffULL,
0x0000000f08087812ULL, 0x000fe200078ec0ffULL, 0x00000010040c7824ULL, 0x040fe200078e00ffULL,
0x0000000f07077812ULL, 0x000fe200078ec0ffULL, 0x0000000806067836ULL, 0x000fe20000000000ULL,
0x000001f00b0a7812ULL, 0x000fe200078ee208ULL, 0x0000001004147824ULL, 0x000fe200078e00ffULL,
0x000001f00c087812ULL, 0x000fe200078ee207ULL, 0x0000000103037824ULL, 0x000fc400078e0206ULL,
0x000000100a0a7824ULL, 0x100fe400078e0209ULL, 0x0000001008087824ULL, 0x000fe200078e0209ULL,
0x0000000f03037812ULL, 0x000fe200078ec0ffULL, 0x0000000105057824ULL, 0x000fe200078e0206ULL,
0x000000000a0c7984ULL, 0x000e620000000c00ULL, 0x0000001004067824ULL, 0x000fc600078e00ffULL,
0x0000000008107984ULL, 0x000ea20000000c00ULL, 0x0000000f05057812ULL, 0x000fe400078ec0ffULL,
0x000001f006047812ULL, 0x000fe400078ee203ULL, 0x000001f014067812ULL, 0x000fc600078ee205ULL,
0x0000001004047824ULL, 0x100fe400078e0209ULL, 0x0000001006067824ULL, 0x000fe400078e0209ULL,
0x000000ffff167224ULL, 0x002fe400078e000cULL, 0x000000ffff177224ULL, 0x000fe400078e000eULL,
0x000000ffff147224ULL, 0x004fe400078e0010ULL, 0x000000ffff157224ULL, 0x000fc400078e0012ULL,
0x000000ffff1a7224ULL, 0x000fe400078e000dULL, 0x000000ffff1b7224ULL, 0x000fe200078e000fULL,
0x0000001408007388ULL, 0x000fe20000000c00ULL, 0x000000ffff187224ULL, 0x000fe400078e0011ULL,
0x000000ffff197224ULL, 0x000fca00078e0013ULL, 0x000000180a007388ULL, 0x0003e80000000c00ULL,
0x00000000060c7984ULL, 0x000ea80000000c00ULL, 0x0000000004107984ULL, 0x000ee20000000c00ULL,
0x00000001ff0a7424ULL, 0x002fe400078e00ffULL, 0x000000ffff1f7224ULL, 0x004fc400078e000eULL,
0x000000ffff1e7224ULL, 0x000fe400078e000cULL, 0x000000ffff0e7224ULL, 0x000fe400078e000dULL,
0x000000ffff1c7224ULL, 0x008fe400078e0010ULL, 0x000000ffff1d7224ULL, 0x000fe400078e0012ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0011ULL, 0x000000ffff0d7224ULL, 0x000fe200078e0013ULL,
0x0000001c04007388ULL, 0x0003e80000000c00ULL, 0x0000000c06007388ULL, 0x0003e20000000c00ULL,
0x01a6000a090a79a7ULL, 0x0002a4000850003fULL, 0x0000000000047805ULL, 0x002fce0000015200ULL,
0x01a6000b090075a7ULL, 0x004e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff087224ULL, 0x000fce00078e00ffULL, 0x000000100800780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fce0000015200ULL,
0x0000000604067210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09000600780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400600780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff037819ULL, 0x000fc80000011407ULL, 0x0000000603037211ULL, 0x000fca00078110ffULL,
0x000000ffff067224ULL, 0x000fca00000e0607ULL, 0x0000000203037819ULL, 0x000fc80000001206ULL,
0x000000030000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000108087836ULL, 0x000fce0000000000ULL, 0x01a6000b090075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000ff5b00720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e620000000000ULL,
0x0000840000097ab9ULL, 0x000fe20000000800ULL, 0x0000010077777836ULL, 0x000fe20000000000ULL,
0x0000001f09047890ULL, 0x000fe4000fffe03fULL, 0x8000000961597c36ULL, 0x000fe40008000000ULL,
0x3db504f358587820ULL, 0x010fe20000410000ULL, 0x0000000878757824ULL, 0x140fe200078e0209ULL,
0x000000043f047899ULL, 0x000fe20008011604ULL, 0x0000002078747824ULL, 0x000fe200078e0209ULL,
0x00000008ff597819ULL, 0x000fe20000011659ULL, 0x000000ffff727224ULL, 0x000fe200078e00ffULL,
0xffffffff09057890ULL, 0x000fe2000fffe03fULL, 0x000000ffff067224ULL, 0x000fe200078e00ffULL,
0x0000000909087890ULL, 0x000fc4000fffe03fULL, 0x0ffffffe04047892ULL, 0x000fd8000f8ec03fULL,
0x0000000272047836ULL, 0x002fe20000000000ULL, 0x0000920000097ab9ULL, 0x000fe20000000800ULL,
0x0000000106057812ULL, 0x000fc600078e0cffULL, 0x0000005b0400720cULL, 0x000fe20003f06070ULL,
0x0000010072047824ULL, 0x000fc800078e0277ULL, 0x00000009020a7c24ULL, 0x000fd0000f8e0204ULL,
0x0000000c00308947ULL, 0x000fea0003800000ULL, 0x00000003ff247819ULL, 0x002fe20000011603ULL,
0x00008e00000a7ab9ULL, 0x000fe20000000a00ULL, 0x0000000461077248ULL, 0x000fc60007fe0000ULL,
0x0000000824107836ULL, 0x000fe40000000000ULL, 0x00000004240e7836ULL, 0x000fe40000000000ULL,
0x00000001100c7824ULL, 0x140fe400078e0203ULL, 0x0000000810257824ULL, 0x000fe400078e00ffULL,
0x00000001070b7824ULL, 0x000fe400078e0a04ULL, 0x0000001003077824ULL, 0x000fe200078e00ffULL,
0xfffffff825257812ULL, 0x000fe200078ee20cULL, 0x00000001240c7824ULL, 0x000fe200078e020aULL,
0x0000000b0e00720cULL, 0x040fe20003fa6070ULL, 0x000000010e087824ULL, 0x040fe200078e0203ULL,
0x0000007007077812ULL, 0x000fe200078ec0ffULL, 0x000000080e217824ULL, 0x000fc400078e00ffULL,
0x000000010e0e7824ULL, 0x000fe400078e020aULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0xfffffff821217812ULL, 0x000fc600078ee208ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x000000070c1a7212ULL, 0x000fc600078efcffULL, 0x0000001024147836ULL, 0x000fe20000000000ULL,
0x000000070e127212ULL, 0x000fe200078efcffULL, 0x0000000c24087836ULL, 0x000fe20000000000ULL,
0x0000000a1a1a7c10ULL, 0x000fe2000ff1e0ffULL, 0x00000001140c7824ULL, 0x140fe200078e0203ULL,
0x0000000a12127c10ULL, 0x000fe2000ff3e0ffULL, 0x0000000814297824ULL, 0x000fe200078e00ffULL,
0x0000000b0d1b7c10ULL, 0x000fe200087fe4ffULL, 0x0000000108117824ULL, 0x040fe200078e0203ULL,
0x0000000b0f137c10ULL, 0x000fe20008ffe4ffULL, 0x0000000808167824ULL, 0x000fe200078e00ffULL,
0xfffffff829297812ULL, 0x000fe200078ee20cULL, 0x00000001100c7824ULL, 0x140fe200078e020aULL,
0x0000000b1000720cULL, 0x080fe20003f26070ULL, 0x00000001080e7824ULL, 0x000fe200078e020aULL,
0xfffffff816277812ULL, 0x000fe200078ee211ULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x0000000b1400720cULL, 0x000fc40003f06070ULL, 0x0000000b0800720cULL, 0x000fe20003f46070ULL,
0x0000001424267836ULL, 0x000fe20000000000ULL, 0x000000070c167212ULL, 0x000fe200078efcffULL,
0x0000000114107824ULL, 0x000fe400078e020aULL, 0x0000001824287836ULL, 0x000fe20000000000ULL,
0x0000000a16167c10ULL, 0x000fe2000ff7e0ffULL, 0x000000800e0e7825ULL, 0x000fc600078e00ffULL,
0x0000000b0d177c10ULL, 0x000fe20009ffe4ffULL, 0x0000000126147824ULL, 0x000fe200078e020aULL,
0x000000070e1c7212ULL, 0x000fe200078efcffULL, 0x0000008010107825ULL, 0x000fc600078e00ffULL,
0x0000000a1c1c7c10ULL, 0x000fe2000ff9e0ffULL, 0x0000000128187824ULL, 0x100fe200078e020aULL,
0x00000007100c7212ULL, 0x080fe200078efcffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000000b0f1d7c10ULL, 0x000fe4000a7fe4ffULL, 0x0000000a0c0c7c10ULL, 0x000fe2000ff7e0ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x00000007140e7212ULL, 0x080fe400078efcffULL,
0x0000000b110d7c10ULL, 0x000fe20009ffe4ffULL, 0x0000001c242a7836ULL, 0x000fe20000000000ULL,
0x0000000718147212ULL, 0x000fe200078efcffULL, 0x0000400078087824ULL, 0x000fe200078e0209ULL,
0x0000000a0e0e7c10ULL, 0x000fe2000ff9e0ffULL, 0x000000012a107824ULL, 0x000fe200078e020aULL,
0x0000000a14147c10ULL, 0x000fe2000ff7e0ffULL, 0x00000020242c7836ULL, 0x000fe20000000000ULL,
0x0000000b150f7c10ULL, 0x000fe2000a7fe4ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000000b19157c10ULL, 0x000fc40009ffe4ffULL, 0x0000000b2400720cULL, 0x040fe20003f86070ULL,
0x0000000124197824ULL, 0x100fe200078e0203ULL, 0x00000007101e7212ULL, 0x000fe200078efcffULL,
0x0000200005187824ULL, 0x000fe200078e0208ULL, 0x0000000b2600720cULL, 0x000fe20003f66070ULL,
0x000000012c107824ULL, 0x000fe200078e020aULL, 0x0000000719207812ULL, 0x000fe200078ec0ffULL,
0x0000200018227836ULL, 0x000fe20000000000ULL, 0x0000000a1e1e7c10ULL, 0x000fe2000ffde0ffULL,
0x0000000126187824ULL, 0x040fe200078e0203ULL, 0x0ffffff820237812ULL, 0x000fe200078ef803ULL,
0x00000008262b7824ULL, 0x000fe200078e00ffULL, 0x0000000b111f7c10ULL, 0x000fe2000b7fe4ffULL,
0x0000008010107825ULL, 0x000fc600078e00ffULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee218ULL,
0x0000001023237824ULL, 0x000fe200078e0222ULL, 0x0000000710207212ULL, 0x000fe200078efcffULL,
0x00000024242e7836ULL, 0x000fe40000000000ULL, 0x0000002824307836ULL, 0x000fe20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a237faeULL, 0x0003e2000e101c46ULL,
0x000000012e187824ULL, 0x000fe200078e020aULL, 0x0000000a20207c10ULL, 0x000fe2000ffde0ffULL,
0x0000000128267824ULL, 0x040fe200078e0203ULL, 0x0000000b2800720cULL, 0x000fe20003f86070ULL,
0x0000008018187825ULL, 0x000fc800078e00ffULL, 0x00000008282d7824ULL, 0x000fe200078e00ffULL,
0x0000000718187212ULL, 0x000fe200078efcffULL, 0x0000000130107824ULL, 0x000fe400078e020aULL,
0x00000010211b7824ULL, 0x102fe200078e0222ULL, 0x0000000b11217c10ULL, 0x000fe2000b7fe4ffULL,
0x0000001025237824ULL, 0x000fe200078e0222ULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee226ULL,
0x0000002c24287836ULL, 0x000fe20000000000ULL, 0x00000000121b7faeULL, 0x0003e2000e901c46ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000000b2a00720cULL, 0x000fc40003fa6070ULL,
0x0000000016237faeULL, 0x0005e2000c901c46ULL, 0x000000012a1a7824ULL, 0x140fe200078e0203ULL,
0x0000000a18187c10ULL, 0x000fe2000ffde0ffULL, 0x000000082a2f7824ULL, 0x000fe200078e00ffULL,
0x0000000710107212ULL, 0x000fe200078efcffULL, 0x000000082c257824ULL, 0x000fe200078e00ffULL,
0x0000000b19197c10ULL, 0x000fe2000b7fe4ffULL, 0x000000012e267824ULL, 0x000fe200078e0203ULL,
0xfffffff82f2f7812ULL, 0x000fe200078ee21aULL, 0x00000010271b7824ULL, 0x002fe200078e0222ULL,
0x0000000a10107c10ULL, 0x000fe2000ffde0ffULL, 0x0000000128127824ULL, 0x000fe200078e020aULL,
0x0000000b2c00720cULL, 0x080fe20003f26070ULL, 0x0000001029177824ULL, 0x004fe200078e0222ULL,
0x000000001c1b7faeULL, 0x0003e2000d101c46ULL, 0x0000003024167836ULL, 0x000fe20000000000ULL,
0x0000000b11117c10ULL, 0x000fe2000b7fe4ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x000000000c177faeULL, 0x0005e2000c101c46ULL, 0x0000000b2e00720cULL, 0x000fc40003f46070ULL,
0x000000102f237824ULL, 0x100fe200078e0222ULL, 0x0000000712127212ULL, 0x000fe200078efcffULL,
0x000000012c1a7824ULL, 0x000fe400078e0203ULL, 0x000000082e277824ULL, 0x000fe200078e00ffULL,
0x0000000a12127c10ULL, 0x000fe2000ffde0ffULL, 0x000000102b1b7824ULL, 0x102fe200078e0222ULL,
0xfffffff825257812ULL, 0x000fe200078ee21aULL, 0x000000102d1d7824ULL, 0x000fe200078e0222ULL,
0xfffffff827277812ULL, 0x000fe200078ee226ULL, 0x00000001160c7824ULL, 0x044fe200078e020aULL,
0x000000000e1b7faeULL, 0x0003e2000d901c46ULL, 0x0000000b13137c10ULL, 0x000fe2000b7fe4ffULL,
0x00000034241a7836ULL, 0x000fe20000000000ULL, 0x0000000b1600720cULL, 0x080fe20003f66070ULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x00000000141d7faeULL, 0x0005e2000e101c46ULL,
0x0000000b2800720cULL, 0x000fc40003f86070ULL, 0x0000001025257824ULL, 0x100fe200078e0222ULL,
0x000000001e237faeULL, 0x000fe2000e901c46ULL, 0x0000000b3000720cULL, 0x000fe20003fa6070ULL,
0x0000001027277824ULL, 0x000fe400078e0222ULL, 0x00000038241c7836ULL, 0x000fe20000000000ULL,
0x0000000020257faeULL, 0x000fe2000c901c46ULL, 0x000000011a0e7824ULL, 0x002fe200078e020aULL,
0x000000070c147212ULL, 0x004fe200078efcffULL, 0x0000000130157824ULL, 0x040fe200078e0203ULL,
0x0000000018277faeULL, 0x0003e2000d101c46ULL, 0x0000000830307824ULL, 0x000fe200078e00ffULL,
0x0000000a14147c10ULL, 0x000fe2000ffde0ffULL, 0x0000003c24247836ULL, 0x000fe20000000000ULL,
0x0000000b1a00720cULL, 0x000fe20003f46070ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0xfffffff830177812ULL, 0x000fc400078ee215ULL, 0x0000000b0d157c10ULL, 0x000fe2000b7fe4ffULL,
0x00000001160d7824ULL, 0x100fe200078e0203ULL, 0x0000000b1c00720cULL, 0x080fe20003f26070ULL,
0x0000000816167824ULL, 0x000fe200078e00ffULL, 0x0000000b2400720cULL, 0x000fe20003f06070ULL,
0x000000011c0c7824ULL, 0x000fe200078e020aULL, 0x000000070e0e7212ULL, 0x000fe200078efcffULL,
0x00000001280b7824ULL, 0x040fe200078e0203ULL, 0xfffffff8161b7812ULL, 0x000fe200078ee20dULL,
0x0000000828287824ULL, 0x000fe200078e00ffULL, 0x0000000a0e0e7c10ULL, 0x000fe2000ffde0ffULL,
0x000000800c0c7825ULL, 0x000fc600078e00ffULL, 0xfffffff828197812ULL, 0x002fe200078ee20bULL,
0x00000001240a7824ULL, 0x000fe200078e020aULL, 0x000000070c0c7212ULL, 0x000fe200078efcffULL,
0x000000011a167824ULL, 0x000fe200078e0203ULL, 0x0000000b0f0f7c10ULL, 0x000fe2000b7fe4ffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000000a0c0c7c10ULL, 0x000fc6000ffde0ffULL,
0x000000081a1d7824ULL, 0x000fe200078e00ffULL, 0x000000070a0a7212ULL, 0x000fe200078efcffULL,
0x000000011c187824ULL, 0x140fe200078e0203ULL, 0x0000000b0d0d7c10ULL, 0x000fe2000b7fe4ffULL,
0x000000081c1f7824ULL, 0x000fe200078e00ffULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee216ULL,
0x00000001241a7824ULL, 0x040fe200078e0203ULL, 0x0000000a0a0a7c10ULL, 0x000fe2000ffde0ffULL,
0x0000000824217824ULL, 0x000fe200078e00ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee218ULL,
0x0000001017077824ULL, 0x100fe200078e0222ULL, 0x0000000b0b0b7c10ULL, 0x000fe2000b7fe4ffULL,
0x0000001019177824ULL, 0x100fe200078e0222ULL, 0xfffffff821217812ULL, 0x000fe200078ee21aULL,
0x000000101b197824ULL, 0x100fe200078e0222ULL, 0x0000000010077faeULL, 0x0003e2000e901c46ULL,
0x000000101d1b7824ULL, 0x000fc400078e0222ULL, 0x000000101f1d7824ULL, 0x100fe200078e0222ULL,
0x0000000012177faeULL, 0x0003e2000e101c46ULL, 0x00000010211f7824ULL, 0x000fc600078e0222ULL,
0x0000000014197faeULL, 0x0003e8000d901c46ULL, 0x000000000e1b7faeULL, 0x0003e8000d101c46ULL,
0x000000000c1d7faeULL, 0x0003e8000c901c46ULL, 0x000000000a1f7faeULL, 0x0003e2000c101c46ULL,
0x0000000800e07947ULL, 0x000fea0003800000ULL, 0x00000004030c7811ULL, 0x042fe200078fe8ffULL,
0x00008e00000a7ab9ULL, 0x000fe20000000a00ULL, 0x00000008030e7811ULL, 0x040fe400078fe8ffULL,
0x0000001003127811ULL, 0x040fe200078fe8ffULL, 0x000000010c077824ULL, 0x140fe200078e0203ULL,
0x0000001403147811ULL, 0x040fe200078fe8ffULL, 0x000000080c107824ULL, 0x000fe200078e00ffULL,
0x0000001803167811ULL, 0x040fe200078fe8ffULL, 0x000000010e087824ULL, 0x140fe200078e0203ULL,
0x0000002003197811ULL, 0x040fe200078fe8ffULL, 0x000000080e2d7824ULL, 0x000fe200078e00ffULL,
0xfffffff8102b7812ULL, 0x000fe200078ee207ULL, 0x0000000812317824ULL, 0x000fe200078e00ffULL,
0x0000000c03107811ULL, 0x040fe200078fe8ffULL, 0x00000001140b7824ULL, 0x100fe200078e0203ULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee208ULL, 0x0000000112087824ULL, 0x100fe200078e0203ULL,
0x0000002c03227811ULL, 0x040fe200078fe8ffULL, 0x0000000110077824ULL, 0x140fe200078e0203ULL,
0x00000030032a7811ULL, 0x040fe200078fe8ffULL, 0x0000000810187824ULL, 0x000fe200078e00ffULL,
0xfffffff831317812ULL, 0x000fe200078ee208ULL, 0x00000008141a7824ULL, 0x000fe200078e00ffULL,
0x00000028031b7811ULL, 0x040fe200078fe8ffULL, 0x00000001160d7824ULL, 0x140fe200078e0203ULL,
0xfffffff8182f7812ULL, 0x000fe200078ee207ULL, 0x00000008161c7824ULL, 0x000fe200078e00ffULL,
0x0000001c03187811ULL, 0x000fe200078fe8ffULL, 0x0000000119087824ULL, 0x140fe200078e0203ULL,
0xfffffff81a337812ULL, 0x000fe200078ee20bULL, 0x0000000819397824ULL, 0x000fe200078e00ffULL,
0xfffffff81c357812ULL, 0x000fe200078ee20dULL, 0x0000000118077824ULL, 0x140fe200078e0203ULL,
0x00000024031a7811ULL, 0x040fe200078fe8ffULL, 0x00000008181c7824ULL, 0x000fe200078e00ffULL,
0xfffffff839397812ULL, 0x000fe200078ee208ULL, 0x000000012a087824ULL, 0x100fe200078e0203ULL,
0x00000034032c7811ULL, 0x040fe200078fe8ffULL, 0x000000011a0b7824ULL, 0x140fe200078e0203ULL,
0xfffffff81c377812ULL, 0x000fe200078ee207ULL, 0x000000081a1e7824ULL, 0x000fe200078e00ffULL,
0x0000003c03307811ULL, 0x040fe200078fe8ffULL, 0x0000000122077824ULL, 0x040fe200078e0203ULL,
0x00000038032e7811ULL, 0x000fe200078fe8ffULL, 0x00000008221c7824ULL, 0x000fe200078e00ffULL,
0xfffffff81e3b7812ULL, 0x000fe200078ee20bULL, 0x000000082a417824ULL, 0x000fc400078e00ffULL,
0x000000011b0d7824ULL, 0x140fe200078e0203ULL, 0xfffffff81c3f7812ULL, 0x000fe200078ee207ULL,
0x000000081b207824ULL, 0x000fe200078e00ffULL, 0xfffffff841417812ULL, 0x000fe200078ee208ULL,
0x000000012c0b7824ULL, 0x140fe400078e0203ULL, 0x000000082c1e7824ULL, 0x000fe200078e00ffULL,
0xfffffff8203d7812ULL, 0x000fe200078ee20dULL, 0x0000000130077824ULL, 0x140fe400078e0203ULL,
0x0000000830087824ULL, 0x000fe200078e00ffULL, 0xfffffff81e437812ULL, 0x000fe200078ee20bULL,
0x000000012e0d7824ULL, 0x040fe200078e0203ULL, 0x00000003030b7211ULL, 0x000fe200078fe8ffULL,
0x000000082e207824ULL, 0x000fe200078e00ffULL, 0xfffffff808477812ULL, 0x000fe200078ee207ULL,
0x000000010c0c7824ULL, 0x100fe200078e020aULL, 0x000000070b1c7812ULL, 0x000fe200078ec0ffULL,
0x000000010e0e7824ULL, 0x100fe200078e020aULL, 0xfffffff820457812ULL, 0x000fe200078ee20dULL,
0x0000000110107824ULL, 0x000fc400078e020aULL, 0x0000000112127824ULL, 0x100fe400078e020aULL,
0x0000000114147824ULL, 0x100fe400078e020aULL, 0x0000000116167824ULL, 0x100fe400078e020aULL,
0x0000000118187824ULL, 0x100fe400078e020aULL, 0x0000000119197824ULL, 0x100fe400078e020aULL,
0x000000011a1a7824ULL, 0x000fc400078e020aULL, 0x000000011b1b7824ULL, 0x100fe400078e020aULL,
0x0000000122227824ULL, 0x100fe400078e020aULL, 0x000000012a2a7824ULL, 0x100fe400078e020aULL,
0x000000012c2c7824ULL, 0x100fe400078e020aULL, 0x000000012e2e7824ULL, 0x100fe400078e020aULL,
0x0000000130307824ULL, 0x000fe200078e020aULL, 0x0000000a030a7211ULL, 0x040fe200078fe8ffULL,
0x0000001003077824ULL, 0x000fc400078e00ffULL, 0x0000400078087824ULL, 0x000fe400078e0209ULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000007007497812ULL, 0x000fe400078ec0ffULL,
0x0ffffff81c077812ULL, 0x000fe200078ef803ULL, 0x00002000050d7824ULL, 0x000fe200078e0208ULL,
0x000000490a0a7212ULL, 0x000fe200078efcffULL, 0x000000800e0e7825ULL, 0x000fc600078e00ffULL,
0x0000000a0a0a7c10ULL, 0x000fe2000ff1e0ffULL, 0x000020000d1c7836ULL, 0x000fe20000000000ULL,
0x000000490e0e7212ULL, 0x080fe200078efcffULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x0000000b0b0b7c10ULL, 0x000fe400087fe4ffULL, 0x0000000a0e0e7c10ULL, 0x000fe2000ff1e0ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000000490c0c7212ULL, 0x000fe400078efcffULL,
0x0000000b0f0f7c10ULL, 0x000fe200087fe4ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000000a0c0c7c10ULL, 0x000fc4000ff3e0ffULL, 0x0000004910107212ULL, 0x000fe200078efcffULL,
0x0000001007077824ULL, 0x100fe200078e021cULL, 0x0000000b0d0d7c10ULL, 0x000fe20008ffe4ffULL,
0x000000102b2b7824ULL, 0x100fe200078e021cULL, 0x0000000a10107c10ULL, 0x000fe2000ff1e0ffULL,
0x000000102d2d7824ULL, 0x100fe200078e021cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a077faeULL, 0x0003e2000b901c46ULL, 0x000000102f2f7824ULL, 0x100fe200078e021cULL,
0x0000000b11117c10ULL, 0x000fe200087fe4ffULL, 0x0000001031317824ULL, 0x100fe200078e021cULL,
0x000000000c2b7faeULL, 0x0003e2000b901c46ULL, 0x0000001033337824ULL, 0x000fc400078e021cULL,
0x0000001035357824ULL, 0x100fe200078e021cULL, 0x000000000e2d7faeULL, 0x0003e2000b901c46ULL,
0x0000001037377824ULL, 0x100fe400078e021cULL, 0x0000001039397824ULL, 0x100fe200078e021cULL,
0x00000000102f7faeULL, 0x0003e2000b901c46ULL, 0x000000103b3b7824ULL, 0x100fe400078e021cULL,
0x000000103d3d7824ULL, 0x100fe400078e021cULL, 0x000000103f3f7824ULL, 0x000fc400078e021cULL,
0x0000001041417824ULL, 0x100fe400078e021cULL, 0x0000001043437824ULL, 0x100fe400078e021cULL,
0x0000001045457824ULL, 0x100fe400078e021cULL, 0x0000001047477824ULL, 0x000fe200078e021cULL,
0x00000049121c7212ULL, 0x000fe200078efcffULL, 0x0000008014147825ULL, 0x000fc600078e00ffULL,
0x0000000a1c1c7c10ULL, 0x000fe2000ff3e0ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x00000049141e7212ULL, 0x080fe400078efcffULL, 0x0000000b131d7c10ULL, 0x000fe20008ffe4ffULL,
0x0000008018127825ULL, 0x000fe200078e00ffULL, 0x0000004916207212ULL, 0x000fe400078efcffULL,
0x0000000a1e1e7c10ULL, 0x000fe2000ff1e0ffULL, 0x000000001c317faeULL, 0x0003e2000b901c46ULL,
0x0000000a20207c10ULL, 0x000fc4000ff5e0ffULL, 0x0000000b151f7c10ULL, 0x000fe200087fe4ffULL,
0x0000008019147825ULL, 0x000fe200078e00ffULL, 0x0000000b17217c10ULL, 0x000fe400097fe4ffULL,
0x0000004912237212ULL, 0x080fe200078efcffULL, 0x000000801a167825ULL, 0x000fe200078e00ffULL,
0x0000004914247212ULL, 0x080fe200078efcffULL, 0x000000001e337faeULL, 0x0003e4000b901c46ULL,
0x000000801b187825ULL, 0x000fe200078e00ffULL, 0x0000004916267212ULL, 0x000fe200078efcffULL,
0x0000000020357faeULL, 0x0003e2000b901c46ULL, 0x0000000a24247c10ULL, 0x000fe2000ff3e0ffULL,
0x00000080221a7825ULL, 0x000fe200078e00ffULL, 0x0000000a23227c10ULL, 0x000fc4000ff1e0ffULL,
0x0000004918287212ULL, 0x080fe400078efcffULL, 0x0000000b13237c10ULL, 0x000fe200087fe4ffULL,
0x000000802a127825ULL, 0x000fe200078e00ffULL, 0x0000000a26267c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000a28287c10ULL, 0x000fe2000ff5e0ffULL, 0x0000000022377faeULL, 0x0003e2000b901c46ULL,
0x0000000b15257c10ULL, 0x000fe20008ffe4ffULL, 0x000000802c147825ULL, 0x000fe200078e00ffULL,
0x000000491a1a7212ULL, 0x000fc400078efcffULL, 0x0000000b17277c10ULL, 0x000fe200087fe4ffULL,
0x000000802e167825ULL, 0x000fe200078e00ffULL, 0x0000000b19297c10ULL, 0x000fe200097fe4ffULL,
0x0000000024397faeULL, 0x0003e2000b901c46ULL, 0x0000000a1a1a7c10ULL, 0x000fe2000ff1e0ffULL,
0x0000008030187825ULL, 0x000fe200078e00ffULL, 0x0000004912127212ULL, 0x080fe200078efcffULL,
0x00000000263b7faeULL, 0x0003e2000b901c46ULL, 0x0000004914147212ULL, 0x080fe400078efcffULL,
0x0000004916167212ULL, 0x000fe200078efcffULL, 0x00000000283d7faeULL, 0x0003e2000b901c46ULL,
0x0000000b1b1b7c10ULL, 0x000fc400087fe4ffULL, 0x0000004918187212ULL, 0x000fe400078efcffULL,
0x0000000a12127c10ULL, 0x000fe2000ff1e0ffULL, 0x000000001a3f7faeULL, 0x0003e2000b901c46ULL,
0x0000000a14147c10ULL, 0x000fe4000ff3e0ffULL, 0x0000000a16167c10ULL, 0x000fe4000ff5e0ffULL,
0x0000000a18187c10ULL, 0x000fe4000ff7e0ffULL, 0x0000000b13137c10ULL, 0x000fc400087fe4ffULL,
0x0000000b15157c10ULL, 0x000fe40008ffe4ffULL, 0x0000000b17177c10ULL, 0x000fe200097fe4ffULL,
0x0000000012417faeULL, 0x0003e2000b901c46ULL, 0x0000000b19197c10ULL, 0x000fc60009ffe4ffULL,
0x0000000014437faeULL, 0x0003e8000b901c46ULL, 0x0000000016457faeULL, 0x0003e8000b901c46ULL,
0x0000000018477faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00002000060a7824ULL, 0x002fe200078e0208ULL, 0x0000000803067812ULL, 0x040fe200078ec0ffULL,
0x00000020035a7836ULL, 0x000fe20000000000ULL, 0xfffffff803607812ULL, 0x000fe200078ec0ffULL,
0x000000ffff737224ULL, 0x000fe200078e00ffULL, 0x00000007060b7812ULL, 0x000fe400078ef803ULL,
0x00000000004a7805ULL, 0x000fe4000001ff00ULL, 0xfffffff85a5a7812ULL, 0x000fc400078ec0ffULL,
0x0000000000487805ULL, 0x000fe4000001ff00ULL, 0x00000004ff077819ULL, 0x000fe40000011603ULL,
0x00000000000e7805ULL, 0x000fe4000001ff00ULL, 0x0000000703087812ULL, 0x000fe400078ec0ffULL,
0x00000000000c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000127805ULL, 0x000fc4000001ff00ULL,
0x0000000000107805ULL, 0x000fe4000001ff00ULL, 0x0000000000167805ULL, 0x000fe4000001ff00ULL,
0x0000000000147805ULL, 0x000fe4000001ff00ULL, 0x00000000001a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000187805ULL, 0x000fe4000001ff00ULL, 0x00000000001e7805ULL, 0x000fc4000001ff00ULL,
0x00000000001c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fe4000001ff00ULL,
0x0000000000207805ULL, 0x000fe4000001ff00ULL, 0x0000000000267805ULL, 0x000fe4000001ff00ULL,
0x0000000000247805ULL, 0x000fe4000001ff00ULL, 0x00000000002a7805ULL, 0x000fc4000001ff00ULL,
0x0000000000287805ULL, 0x000fe4000001ff00ULL, 0x00000000002e7805ULL, 0x000fe4000001ff00ULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000327805ULL, 0x000fe4000001ff00ULL,
0x0000000000307805ULL, 0x000fe4000001ff00ULL, 0x0000000000367805ULL, 0x000fc4000001ff00ULL,
0x0000000000347805ULL, 0x000fe4000001ff00ULL, 0x00000000003a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000387805ULL, 0x000fe4000001ff00ULL, 0x00000000003e7805ULL, 0x000fe4000001ff00ULL,
0x00000000003c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000427805ULL, 0x000fc4000001ff00ULL,
0x0000000000407805ULL, 0x000fe4000001ff00ULL, 0x0000000000467805ULL, 0x000fe4000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x000020000a0a7836ULL, 0x000fe20000000000ULL,
0x0000000760607812ULL, 0x000fe200078ef803ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000075a5a7812ULL, 0x000fe400078ef803ULL, 0x000000100b067812ULL, 0x000fce00078efcffULL,
0x00000001604c7824ULL, 0x040fe400078e0273ULL, 0x00000008604d7824ULL, 0x000fe400078e00ffULL,
0x0000000273767824ULL, 0x000fe400078e0207ULL, 0x000000100b577824ULL, 0x040fe200078e00ffULL,
0xfffffff84d4d7812ULL, 0x000fe200078ee24cULL, 0x000000015a4c7824ULL, 0x000fe400078e0273ULL,
0x000000010b547824ULL, 0x000fc400078e0276ULL, 0x000000104d507824ULL, 0x000fe400078e020aULL,
0x000000085a4d7824ULL, 0x000fe200078e00ffULL, 0xfffffff057547812ULL, 0x000fe200078ee254ULL,
0x0000000173557836ULL, 0x000fe40000000000ULL, 0x000000005050783bULL, 0x000e620000000200ULL,
0xfffffff84d4d7812ULL, 0x000fe200078ee24cULL, 0x00000010065f7824ULL, 0x040fe400078e00ffULL,
0x00000001066c7824ULL, 0x000fc400078e0276ULL, 0x000000104d4d7824ULL, 0x000fe400078e020aULL,
0x000000085a5c7824ULL, 0x040fe200078e00ffULL, 0xfffffff05f6c7812ULL, 0x000fe200078ee26cULL,
0x000000015a5d7824ULL, 0x100fe400078e0255ULL, 0x000000004d4c783bULL, 0x000ea20000000200ULL,
0x0000000860567824ULL, 0x040fe400078e00ffULL, 0x0000000160637824ULL, 0x000fe200078e0255ULL,
0xfffffff85c5d7812ULL, 0x000fe200078ee25dULL, 0x0000001054547824ULL, 0x000fc400078e0209ULL,
0x0000000276767836ULL, 0x000fe20000000000ULL, 0xfffffff856637812ULL, 0x000fe200078ee263ULL,
0x000000105d5d7824ULL, 0x000fe400078e020aULL, 0x000000005454783bULL, 0x000ee20000000200ULL,
0x0000000273737836ULL, 0x000fca0000000000ULL, 0x000000087300780cULL, 0x000fe40003f05270ULL,
0x00000010ff697819ULL, 0x002fe40000011650ULL, 0x00000010ff7c7819ULL, 0x100fe40000011651ULL,
0x00000018ff6f7819ULL, 0x000fe40000011651ULL, 0x000000ff516e7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff51817812ULL, 0x000fc400078ec0ffULL, 0x00000010ff807819ULL, 0x100fe40000011653ULL,
0x00000018ff7b7819ULL, 0x000fe40000011653ULL, 0x000000ff53657812ULL, 0x040fe400078ec0ffULL,
0x0000ffff53847812ULL, 0x000fe400078ec0ffULL, 0x00000010ff827819ULL, 0x104fe4000001164cULL,
0x00000018ff537819ULL, 0x000fc4000001164cULL, 0x000000ff4c6a7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff4c517812ULL, 0x000fe400078ec0ffULL, 0x00000018ff627819ULL, 0x000fe40000011650ULL,
0x000000ff694c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff50647812ULL, 0x040fe400078ec0ffULL,
0x0000ffff507f7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff507819ULL, 0x100fe4000001164dULL,
0x00000018ff7a7819ULL, 0x000fe4000001164dULL, 0x000000ff4d797812ULL, 0x040fe400078ec0ffULL,
0x0000ffff4d5f7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5c7819ULL, 0x100fe4000001164eULL,
0x00000018ff4d7819ULL, 0x000fc4000001164eULL, 0x000000ff4e6b7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff4e5e7812ULL, 0x000fe400078ec0ffULL, 0x00000062ff7d723eULL, 0x000fe400020006ffULL,
0x0000004cff6d723eULL, 0x000fe400020006ffULL, 0x00000010ff7e7819ULL, 0x100fe40000011652ULL,
0x00000018ff717819ULL, 0x000fc40000011652ULL, 0x000000ff52707812ULL, 0x040fe400078ec0ffULL,
0x0000ffff52837812ULL, 0x000fe400078ec0ffULL, 0x00000018ff4e7819ULL, 0x000fe4000001164fULL,
0x00000008ff517819ULL, 0x000fe40000011651ULL, 0x00000064ff52723eULL, 0x000fe400020006ffULL,
0x00000008ff4c7819ULL, 0x000fc4000001167fULL, 0x000000ff7c7c7812ULL, 0x000fe400078ec0ffULL,
0x0000006aff64723eULL, 0x000fe400020006ffULL, 0x00000065ff62723eULL, 0x000fe400020006ffULL,
0x0000006bff6a723eULL, 0x000fe400020006ffULL, 0x000054106d6d7816ULL, 0x000fe4000000007dULL,
0x00000053ff65723eULL, 0x000fc400020006ffULL, 0x0000004dff69723eULL, 0x000fe400020006ffULL,
0x0000004eff6b723eULL, 0x000fe400020006ffULL, 0x00000051ff7d723eULL, 0x000fe200020006ffULL,
0x0000001063517824ULL, 0x000fe200078e020aULL, 0x0000006fff6f723eULL, 0x000fe400020006ffULL,
0x00000008ff4d7819ULL, 0x000fe40000011681ULL, 0x000000ff7e4e7812ULL, 0x000fc400078ec0ffULL,
0x0000004cff53723eULL, 0x000fe200020006ffULL, 0x000000106c4c7824ULL, 0x000fe200078e0209ULL,
0x0000007cff7f723eULL, 0x000fe400020006ffULL, 0x000000ff50507812ULL, 0x000fe400078ec0ffULL,
0x00000010ff667819ULL, 0x000fe4000001164fULL, 0x000000ff4f687812ULL, 0x040fe400078ec0ffULL,
0x0000ffff4f677812ULL, 0x000fc400078ec0ffULL, 0x0000004dff7e723eULL, 0x000fe400020006ffULL,
0x0000004eff81723eULL, 0x000fe400020006ffULL, 0x000054107f6f7816ULL, 0x000fe4000000006fULL,
0x00000008ff4d7819ULL, 0x000fe40000011683ULL, 0x000000ff804f7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff4e7819ULL, 0x000fc40000011684ULL, 0x00005410526c7816ULL, 0x000fe40000000053ULL,
0x00000050ff7f723eULL, 0x000fe400020006ffULL, 0x000000005150783bULL, 0x000fe20000000200ULL,
0x000000ff827c7812ULL, 0x000fe400078ec0ffULL, 0x0000004dff80723eULL, 0x000fe200020006ffULL,
0x0000006c5444723cULL, 0x008fe20000001844ULL, 0x0000004fff83723eULL, 0x000fe400020006ffULL,
0x0000004eff82723eULL, 0x000fc400020006ffULL, 0x000000004c4c783bULL, 0x000e620000000200ULL,
0x0000006eff6e723eULL, 0x000fe400020006ffULL, 0x0000007cff7c723eULL, 0x000fe400020006ffULL,
0x00000008ff5f7819ULL, 0x000fe4000001165fULL, 0x0000007bff7b723eULL, 0x000fe400020006ffULL,
0x000054106e6e7816ULL, 0x000fe4000000007eULL, 0x00000070ff70723eULL, 0x000fc400020006ffULL,
0x00000079ff79723eULL, 0x000fe400020006ffULL, 0x0000005fff7e723eULL, 0x000fe200020006ffULL,
0x0000006e5440723cULL, 0x000fe20000001840ULL, 0x00000008ff5e7819ULL, 0x000fe4000001165eULL,
0x000054107c657816ULL, 0x000fe40000000065ULL, 0x0000541064647816ULL, 0x000fe4000000007dULL,
0x000000ff5c5c7812ULL, 0x000fc400078ec0ffULL, 0x000000ff667d7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff7c7819ULL, 0x000fe20000011667ULL, 0x000000645434723cULL, 0x000fe20000001834ULL,
0x0000541083637816ULL, 0x000fe4000000007bULL, 0x0000541070707816ULL, 0x000fe40000000080ULL,
0x0000005eff7b723eULL, 0x000fe400020006ffULL, 0x0000541079667816ULL, 0x000fc4000000007eULL,
0x00000071ff71723eULL, 0x000fe400020006ffULL, 0x0000007aff7a723eULL, 0x000fe200020006ffULL,
0x0000006e4c20723cULL, 0x002fe20000001820ULL, 0x0000005cff80723eULL, 0x000fe400020006ffULL,
0x00000068ff79723eULL, 0x000fe200020006ffULL, 0x000000005d5c783bULL, 0x000e620000000200ULL,
0x0000007dff7d723eULL, 0x000fe200020006ffULL, 0x0000006c4c24723cULL, 0x000fe20000001824ULL,
0x0000007cff7c723eULL, 0x000fc400020006ffULL, 0x000054106a687816ULL, 0x000fe4000000007bULL,
0x0000541081717816ULL, 0x000fe20000000071ULL, 0x000000644c14723cULL, 0x000fe20000001814ULL,
0x0000541062627816ULL, 0x000fe40000000082ULL, 0x000054107f677816ULL, 0x000fe4000000007aULL,
0x0000541080697816ULL, 0x000fe20000000069ULL, 0x00000070543c723cULL, 0x000fe2000000183cULL,
0x000054107d6b7816ULL, 0x000fc4000000006bULL, 0x00005410796a7816ULL, 0x000fe4000000007cULL,
0x00000010ff857819ULL, 0x100fe20000011650ULL, 0x000000625438723cULL, 0x000fe20000001838ULL,
0x00000018ff807819ULL, 0x000fe40000011650ULL, 0x000000ff50817812ULL, 0x040fe400078ec0ffULL,
0x0000ffff50867812ULL, 0x000fe200078ec0ffULL, 0x000000665430723cULL, 0x000fe20000001830ULL,
0x00000010ff837819ULL, 0x000fc40000011651ULL, 0x00000018ff7d7819ULL, 0x000fe40000011651ULL,
0x000000ff517b7812ULL, 0x040fe200078ec0ffULL, 0x00000068542c723cULL, 0x000fe2000000182cULL,
0x0000ffff51847812ULL, 0x000fe400078ec0ffULL, 0x00000010ff7e7819ULL, 0x100fe40000011652ULL,
0x00000018ff6f7819ULL, 0x000fe20000011652ULL, 0x0000006a5428723cULL, 0x000fe20000001828ULL,
0x000000ff527c7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff52827812ULL, 0x000fe400078ec0ffULL,
0x00000010ff7f7819ULL, 0x000fe20000011653ULL, 0x000000704c1c723cULL, 0x000fe2000000181cULL,
0x000000100b557824ULL, 0x040fe200078e00ffULL, 0x00000018ff877819ULL, 0x002fe2000001165cULL,
0x000000010b547824ULL, 0x100fe200078e0276ULL, 0x000000ff5c887812ULL, 0x000fe200078ec0ffULL,
0x0000001006577824ULL, 0x040fe200078e00ffULL, 0x000000624c18723cULL, 0x000fe20000001818ULL,
0x0000000106767824ULL, 0x000fe200078e0276ULL, 0xfffffff055567812ULL, 0x000fc400078ee254ULL,
0x00000018ff717819ULL, 0x000fe40000011653ULL, 0xfffffff057547812ULL, 0x000fe200078ee276ULL,
0x0000001056507824ULL, 0x100fe200078e0209ULL, 0x000000ff53767812ULL, 0x040fe200078ec0ffULL,
0x000000664c10723cULL, 0x000fe20000001810ULL, 0x0000ffff53557812ULL, 0x000fe200078ec0ffULL,
0x0000001054547824ULL, 0x000fe200078e0209ULL, 0x00000010ff567819ULL, 0x000fe2000001165cULL,
0x000000005050783bULL, 0x000e620000000200ULL, 0x0000ffff5c577812ULL, 0x000fe200078ec0ffULL,
0x000000684c0c723cULL, 0x000fe2000000180cULL, 0x00000010ff5c7819ULL, 0x000fc4000001165dULL,
0x00000018ff897819ULL, 0x000fe4000001165dULL, 0x00000008ff667819ULL, 0x000fe20000011655ULL,
0x0000006a4c48723cULL, 0x000fe20000001848ULL, 0x000000ff56687812ULL, 0x000fe200078ec0ffULL,
0x00000000544c783bULL, 0x0004e20000000200ULL, 0x000000ff5c697812ULL, 0x000fe400078ec0ffULL,
0x0000ffff5d797812ULL, 0x000fe400078ec0ffULL, 0x00000010ff7a7819ULL, 0x000fc4000001165eULL,
0x0000ffff5e707812ULL, 0x040fe400078ec0ffULL, 0x00000010ff6d7819ULL, 0x000fe4000001165fULL,
0x0000ffff5f6e7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff8b7819ULL, 0x000fe4000001165eULL,
0x000000ff5e8c7812ULL, 0x000fe400078ec0ffULL, 0x00000076ff5e723eULL, 0x000fc400020006ffULL,
0x00000087ff63723eULL, 0x000fe400020006ffULL, 0x00000089ff65723eULL, 0x000fe400020006ffULL,
0x00000066ff66723eULL, 0x000fe400020006ffULL, 0x00000008ff677819ULL, 0x000fe40000011657ULL,
0x00000068ff68723eULL, 0x000fe400020006ffULL, 0x00000069ff69723eULL, 0x000fc400020006ffULL,
0x000000ff5d8a7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff8d7819ULL, 0x000fe4000001165fULL,
0x000000ff5f6c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff85857812ULL, 0x000fe400078ec0ffULL,
0x00000008ff867819ULL, 0x000fe40000011686ULL, 0x000000ff83837812ULL, 0x000fc400078ec0ffULL,
0x00000008ff847819ULL, 0x000fe40000011684ULL, 0x000000ff7e7e7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff827819ULL, 0x000fe40000011682ULL, 0x000000ff7f7f7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff797819ULL, 0x000fe40000011679ULL, 0x000000ff7a7a7812ULL, 0x000fc400078ec0ffULL,
0x00000008ff707819ULL, 0x000fe40000011670ULL, 0x000000ff6d6d7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff6e7819ULL, 0x000fe4000001166eULL, 0x0000006fff5d723eULL, 0x000fe400020006ffULL,
0x00000071ff5f723eULL, 0x000fe400020006ffULL, 0x00000088ff62723eULL, 0x000fc400020006ffULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x000054105e5e7816ULL, 0x000fe40000000066ULL,
0x0000541068637816ULL, 0x000fe40000000063ULL, 0x0000541069657816ULL, 0x000fe40000000065ULL,
0x00000080ff80723eULL, 0x000fe400020006ffULL, 0x00000081ff81723eULL, 0x000fc400020006ffULL,
0x0000007dff7d723eULL, 0x000fe400020006ffULL, 0x0000007bff7b723eULL, 0x000fe400020006ffULL,
0x0000007cff7c723eULL, 0x000fe400020006ffULL, 0x0000008aff64723eULL, 0x000fe400020006ffULL,
0x0000008bff76723eULL, 0x000fe400020006ffULL, 0x0000008cff71723eULL, 0x000fc400020006ffULL,
0x0000008dff6f723eULL, 0x000fe400020006ffULL, 0x00000085ff85723eULL, 0x000fe400020006ffULL,
0x00000086ff86723eULL, 0x000fe400020006ffULL, 0x00000083ff83723eULL, 0x000fe400020006ffULL,
0x00000084ff84723eULL, 0x000fe400020006ffULL, 0x0000007eff7e723eULL, 0x000fc400020006ffULL,
0x00000082ff82723eULL, 0x000fe400020006ffULL, 0x0000007fff7f723eULL, 0x000fe400020006ffULL,
0x00000079ff79723eULL, 0x000fe400020006ffULL, 0x0000007aff7a723eULL, 0x000fe400020006ffULL,
0x00000070ff66723eULL, 0x000fe400020006ffULL, 0x0000006cff68723eULL, 0x000fc400020006ffULL,
0x0000006dff69723eULL, 0x000fe400020006ffULL, 0x0000006eff6e723eULL, 0x000fe400020006ffULL,
0x0000541062627816ULL, 0x000fe40000000067ULL, 0x0000541085557816ULL, 0x000fe40000000080ULL,
0x0000541081547816ULL, 0x004fe40000000086ULL, 0x0000541083577816ULL, 0x000fe2000000007dULL,
0x000000625034723cULL, 0x002fe20000001834ULL, 0x000054107b567816ULL, 0x000fc40000000084ULL,
0x000054107e5d7816ULL, 0x000fe4000000005dULL, 0x000054107c5c7816ULL, 0x000fe20000000082ULL,
0x000000545044723cULL, 0x000fe20000001844ULL, 0x000054107f5f7816ULL, 0x000fe4000000005fULL,
0x0000541064647816ULL, 0x000fe40000000079ULL, 0x000054107a677816ULL, 0x000fe20000000076ULL,
0x000000565040723cULL, 0x000fe20000001840ULL, 0x0000541071667816ULL, 0x000fc40000000066ULL,
0x0000541069697816ULL, 0x000fe4000000006fULL, 0x0000541068687816ULL, 0x000fe2000000006eULL,
0x0000005c503c723cULL, 0x000fec000000183cULL, 0x0000005e5038723cULL, 0x000fec0000001838ULL,
0x000000645030723cULL, 0x000fec0000001830ULL, 0x00000066502c723cULL, 0x000fec000000182cULL,
0x000000685028723cULL, 0x000fec0000001828ULL, 0x000000544c24723cULL, 0x008fec0000001824ULL,
0x000000564c20723cULL, 0x000fec0000001820ULL, 0x0000005c4c1c723cULL, 0x000fec000000181cULL,
0x0000005e4c18723cULL, 0x000fec0000001818ULL, 0x000000624c14723cULL, 0x000fec0000001814ULL,
0x000000644c10723cULL, 0x000fec0000001810ULL, 0x000000664c0c723cULL, 0x000fec000000180cULL,
0x000000684c48723cULL, 0x000fe20000001848ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0xffffffec00c40947ULL, 0x000fde000383ffffULL, 0x00000001ff4c7424ULL, 0x000fe400078e00ffULL,
0x0000005844077220ULL, 0x080fe20000410000ULL, 0x00000058240b7220ULL, 0x080fe20000410000ULL,
0x0000005845457220ULL, 0x080fe20000410000ULL, 0x0000005846467220ULL, 0x080fe20000410000ULL,
0x0000005847477220ULL, 0x080fe20000410000ULL, 0x01a6884c754c79a7ULL, 0x000e62000850003fULL,
0x0000005840407220ULL, 0x080fe20000410000ULL, 0x0000005841417220ULL, 0x080fe20000410000ULL,
0x0000005842427220ULL, 0x080fe20000410000ULL, 0x0000005843437220ULL, 0x080fe20000410000ULL,
0x000000583c3c7220ULL, 0x080fe20000410000ULL, 0x000000583d3d7220ULL, 0x080fe20000410000ULL,
0x000000583e3e7220ULL, 0x080fe20000410000ULL, 0x000000583f3f7220ULL, 0x080fe20000410000ULL,
0x0000005838387220ULL, 0x080fe20000410000ULL, 0x0000005839397220ULL, 0x080fe20000410000ULL,
0x000000583a3a7220ULL, 0x080fe20000410000ULL, 0x000000583b3b7220ULL, 0x080fe20000410000ULL,
0x0000005834347220ULL, 0x080fe20000410000ULL, 0x0000005835357220ULL, 0x080fe20000410000ULL,
0x0000005836367220ULL, 0x080fe20000410000ULL, 0x0000005837377220ULL, 0x080fe20000410000ULL,
0x0000005830307220ULL, 0x080fe20000410000ULL, 0x0000005831317220ULL, 0x080fe20000410000ULL,
0x0000005832327220ULL, 0x080fe20000410000ULL, 0x0000005833337220ULL, 0x080fe20000410000ULL,
0x000000582c2c7220ULL, 0x080fe20000410000ULL, 0x000000582d2d7220ULL, 0x080fe20000410000ULL,
0x000000582e2e7220ULL, 0x080fe20000410000ULL, 0x000000582f2f7220ULL, 0x080fe20000410000ULL,
0x0000005828287220ULL, 0x080fe20000410000ULL, 0x0000005829297220ULL, 0x080fe20000410000ULL,
0x000000582a2a7220ULL, 0x080fe20000410000ULL, 0x000000582b2b7220ULL, 0x080fe20000410000ULL,
0x0000005825257220ULL, 0x080fe20000410000ULL, 0x0000005826267220ULL, 0x080fe20000410000ULL,
0x0000005827277220ULL, 0x080fe20000410000ULL, 0x0000005820207220ULL, 0x080fe20000410000ULL,
0x0000005821217220ULL, 0x080fe20000410000ULL, 0x0000005822227220ULL, 0x080fe20000410000ULL,
0x0000005823237220ULL, 0x080fe20000410000ULL, 0x000000581c1c7220ULL, 0x080fe20000410000ULL,
0x000000581d1d7220ULL, 0x080fe20000410000ULL, 0x000000581e1e7220ULL, 0x080fe20000410000ULL,
0x000000581f1f7220ULL, 0x080fe20000410000ULL, 0x0000005818187220ULL, 0x080fe20000410000ULL,
0x0000005819197220ULL, 0x080fe20000410000ULL, 0x000000581a1a7220ULL, 0x080fe20000410000ULL,
0x000000581b1b7220ULL, 0x080fe20000410000ULL, 0x0000005814147220ULL, 0x080fe20000410000ULL,
0x0000005815157220ULL, 0x080fe20000410000ULL, 0x0000005816167220ULL, 0x080fe20000410000ULL,
0x0000005817177220ULL, 0x080fe20000410000ULL, 0x0000005810107220ULL, 0x080fe20000410000ULL,
0x0000005811117220ULL, 0x080fe20000410000ULL, 0x0000005812127220ULL, 0x080fe20000410000ULL,
0x0000005813137220ULL, 0x080fe20000410000ULL, 0x000000580c067220ULL, 0x080fe20000410000ULL,
0x000000580d0a7220ULL, 0x080fe20000410000ULL, 0x000000580e247220ULL, 0x080fe20000410000ULL,
0x000000580f447220ULL, 0x080fe20000410000ULL, 0x0000005848487220ULL, 0x080fe20000410000ULL,
0x0000005849497220ULL, 0x080fe20000410000ULL, 0x000000584a4a7220ULL, 0x080fe20000410000ULL,
0x000000584b4b7220ULL, 0x000fe20000410000ULL, 0x00000000000e7805ULL, 0x000fe20000015200ULL,
0x01a6884d750075a7ULL, 0x002e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff4e7224ULL, 0x000fce00078e00ffULL, 0x000000104e00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000000c7805ULL, 0x000fcc0000015200ULL,
0x0000000c0e4f7210ULL, 0x000fca0007f1e1ffULL, 0x000000010d0d7824ULL, 0x000fe200000e0e0fULL,
0x003d09004f00780cULL, 0x000fc80003f06070ULL, 0x000000ff0d00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c404f00780cULL, 0x000fc80003f06070ULL,
0x000000ff0d00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff0c7819ULL, 0x000fc8000001140dULL, 0x0000004f0c0c7211ULL, 0x000fca00078110ffULL,
0x000000ffff0d7224ULL, 0x000fca00000e060dULL, 0x000000020c0c7819ULL, 0x000fc8000000120dULL,
0x0000000c0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000014e4e7836ULL, 0x000fce0000000000ULL, 0x01a6884d750075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00000004030c7824ULL, 0x000fe200078e00ffULL,
0x000000597200720cULL, 0x000fe20003f06070ULL, 0x00000080780d7824ULL, 0x000fc600078e0209ULL,
0xfffffff00c0c7812ULL, 0x000fca00078ec0ffULL, 0x000000010d4c7824ULL, 0x000fca00078e020cULL,
0x01a400004c0c7984ULL, 0x0002a20000000c00ULL, 0x0000001c00c48947ULL, 0x000fea0003800000ULL,
0xffffff0004047836ULL, 0x000fe20000000000ULL, 0x00008c00ff887b82ULL, 0x000ee20000000a00ULL,
0x00000002034e7824ULL, 0x000fe200078e00ffULL, 0x0000860000097ab9ULL, 0x000fe20000000800ULL,
0x00008400000a7ab9ULL, 0x000fe20000000800ULL, 0x00000004614d7248ULL, 0x000fca0007fe0000ULL,
0x000000014da67824ULL, 0x000fe200078e0a04ULL, 0x000000064e047812ULL, 0x000fe400078ec0ffULL,
0x00000000034d7211ULL, 0x000fe200078ff0ffULL, 0x000000ffff827224ULL, 0x000fe400078e0aa6ULL,
0x00000008044f7c36ULL, 0x000fe20008000000ULL, 0x00000009ff4e7c19ULL, 0x000fe2000801164dULL,
0x000000084d507836ULL, 0x000fe40000000000ULL, 0x000000104d517836ULL, 0x000fe20000000000ULL,
0x000000a64f00720cULL, 0x000fe20003f26070ULL, 0x000000184d527836ULL, 0x000fe20000000000ULL,
0x000000054f4f7e46ULL, 0x000fe2000b800082ULL, 0x0000000a044d7c36ULL, 0x000fe20008000000ULL,
0x000000054e4e7c48ULL, 0x000fc4000bfe0000ULL, 0x00000004ff4f7819ULL, 0x000fe4000001164fULL,
0x000000a64d00720cULL, 0x000fe20003f06070ULL, 0x000000044e797c24ULL, 0x000fe2000f8e02ffULL,
0x000000054d997e46ULL, 0x000fe4000b800082ULL, 0x00000009ff507c19ULL, 0x000fe40008011650ULL,
0x000000ff4f567207ULL, 0x000fe40000800000ULL, 0x000000ff99997207ULL, 0x000fc40000000000ULL,
0x0000000550507c48ULL, 0x000fe4000bfe0000ULL, 0x00000009ff4e7c19ULL, 0x000fe20008011651ULL,
0x0000000179517824ULL, 0x000fe200078e0256ULL, 0x00000009ff527c19ULL, 0x000fe20008011652ULL,
0x0000000450737c24ULL, 0x000fe2000f8e02ffULL, 0x0000007999557211ULL, 0x000fe200078fe0ffULL,
0x0000000251507825ULL, 0x108fe200078e0088ULL, 0x000000054e4e7c48ULL, 0x000fe4000bfe0000ULL,
0x0000000552867c48ULL, 0x000fe2000bfe0000ULL, 0x0000000255547825ULL, 0x000fe200078e0088ULL,
0x0000007399537211ULL, 0x000fe200078fe0ffULL, 0x0000000650517981ULL, 0x000724000c1e9500ULL,
0x000000044e767c24ULL, 0x000fc4000f8e02ffULL, 0x0000000486867c24ULL, 0x000fe2000f8e02ffULL,
0x00000006544e7981ULL, 0x000b22000c1e9500ULL, 0x0000000156637824ULL, 0x040fe200078e0273ULL,
0x0000007699677211ULL, 0x000fe200078fe0ffULL, 0x00000001565f7824ULL, 0x040fe400078e0276ULL,
0x00000001565d7824ULL, 0x000fe200078e0286ULL, 0x0000001004567812ULL, 0x000fe200078efcffULL,
0x0000000253527825ULL, 0x000fc800078e0088ULL, 0x0000000267667825ULL, 0x100fe200078e0088ULL,
0x00000006524f7981ULL, 0x000b26000c1e9500ULL, 0x0000000263627825ULL, 0x100fe200078e0088ULL,
0x0000000666507981ULL, 0x008ee6000c1e9500ULL, 0x000000025f5e7825ULL, 0x000fe200078e0088ULL,
0x0000000662547981ULL, 0x022366000c1e9500ULL, 0x0000000a56577c36ULL, 0x000fe20008000000ULL,
0x000000065e537981ULL, 0x0044e2000c1e9500ULL, 0x0000000856697c36ULL, 0x000fe20008000000ULL,
0x0000008699657211ULL, 0x000fc400078fe0ffULL, 0x000000a65700720cULL, 0x080fe40003f06070ULL,
0x0000000557987e46ULL, 0x000fe4000b800082ULL, 0x00000005695a7e46ULL, 0x000fe4000b800082ULL,
0x000000ff98987207ULL, 0x000fe20000000000ULL, 0x0000000265647825ULL, 0x000fe200078e0088ULL,
0x000000a66900720cULL, 0x000fe40003f26070ULL, 0x00000004ff5a7819ULL, 0x000fe2000001165aULL,
0x000000025d5c7825ULL, 0x000fe200078e0088ULL, 0x0000007398637211ULL, 0x002fe200078fe0ffULL,
0x0000000664527981ULL, 0x0002e2000c1e9500ULL, 0x000000ff5a607207ULL, 0x000fc60000800000ULL,
0x000000065c557981ULL, 0x0002e2000c1e9500ULL, 0x0000000263627825ULL, 0x000fc800078e0088ULL,
0x00000001795f7824ULL, 0x004fe200078e0260ULL, 0x0000007998657211ULL, 0x002fe200078fe0ffULL,
0x00000001606b7824ULL, 0x000fe200078e0273ULL, 0x00000006625c7981ULL, 0x0002a6000c1e9500ULL,
0x0000000265647825ULL, 0x000fc800078e0088ULL, 0x000000025f5e7825ULL, 0x100fe200078e0088ULL,
0x00000006645a7981ULL, 0x0002a6000c1e9500ULL, 0x000000026b6a7825ULL, 0x000fe200078e0088ULL,
0x0000002004627812ULL, 0x002fe200078efcffULL, 0x000000065e5d7981ULL, 0x0002a8000c1e9500ULL,
0x0000000862717c36ULL, 0x000fe20008000000ULL, 0x000000066a637981ULL, 0x0002a2000c1e9500ULL,
0x0000000a62647c36ULL, 0x000fe20008000000ULL, 0x00000076986f7211ULL, 0x000fe200078fe0ffULL,
0x0000000160697824ULL, 0x000fe200078e0276ULL, 0x00000086986d7211ULL, 0x000fe200078fe0ffULL,
0x0000000160677824ULL, 0x000fe200078e0286ULL, 0x0000000571707e46ULL, 0x000fe2000b800082ULL,
0x000000026f6e7825ULL, 0x000fe200078e0088ULL, 0x000000a66400720cULL, 0x000fc40003f06070ULL,
0x0000000564967e46ULL, 0x000fe2000b800082ULL, 0x000000026d6c7825ULL, 0x000fe200078e0088ULL,
0x000000a67100720cULL, 0x000fe20003f26070ULL, 0x000000066e5e7981ULL, 0x002ea2000c1e9500ULL,
0x00000004ff707819ULL, 0x000fe20000011670ULL, 0x0000000269687825ULL, 0x100fe200078e0088ULL,
0x000000ff96967207ULL, 0x000fe20000000000ULL, 0x000000066c5f7981ULL, 0x0002a4000c1e9500ULL,
0x0000000267667825ULL, 0x000fe200078e0088ULL, 0x000000ff70707207ULL, 0x000fe20000800000ULL,
0x0000000668657981ULL, 0x000ea2000c1e9500ULL, 0x00000073966b7211ULL, 0x000fc600078fe0ffULL,
0x0000000666607981ULL, 0x0002a4000c1e9500ULL, 0x00000079966d7211ULL, 0x002fe200078fe0ffULL,
0x00000001707d7824ULL, 0x000fe400078e0273ULL, 0x000000026b6a7825ULL, 0x000fc800078e0088ULL,
0x000000026d6c7825ULL, 0x100fe200078e0088ULL, 0x000000066a677981ULL, 0x000ea6000c1e9500ULL,
0x000000027d7c7825ULL, 0x000fe200078e0088ULL, 0x000000066c667981ULL, 0x0002a2000c1e9500ULL,
0x0000007696817211ULL, 0x040fe400078fe0ffULL, 0x0000000179697824ULL, 0x000fe200078e0270ULL,
0x00000086967f7211ULL, 0x000fe200078fe0ffULL, 0x00000001707b7824ULL, 0x040fe200078e0276ULL,
0x000000067c6c7981ULL, 0x002ea2000c1e9500ULL, 0x0000000170717824ULL, 0x000fe200078e0286ULL,
0x00000030046e7812ULL, 0x000fe200078efcffULL, 0x0000000269687825ULL, 0x000fc800078e0088ULL,
0x0000000281807825ULL, 0x100fe400078e0088ULL, 0x0000000668697981ULL, 0x0002a4000c1e9500ULL,
0x000000027f7e7825ULL, 0x000fc800078e0088ULL, 0x000000027b7a7825ULL, 0x100fe200078e0088ULL,
0x000000067e6a7981ULL, 0x000ea6000c1e9500ULL, 0x0000000271707825ULL, 0x000fe200078e0088ULL,
0x0000000680687981ULL, 0x002ea6000c1e9500ULL, 0x000000086e837c36ULL, 0x000fe20008000000ULL,
0x000000067a6b7981ULL, 0x0002a2000c1e9500ULL, 0x0000000a6e6f7c36ULL, 0x000fc60008000000ULL,
0x00000006706d7981ULL, 0x0002a2000c1e9500ULL, 0x0000000583847e46ULL, 0x000fe4000b800082ULL,
0x000000a68300720cULL, 0x080fe40003f26070ULL, 0x000000a66f00720cULL, 0x000fe40003f06070ULL,
0x000000056f977e46ULL, 0x000fe4000b800082ULL, 0x00000004ff847819ULL, 0x000fe40000011684ULL,
0x000000ff97977207ULL, 0x000fc40000000000ULL, 0x000000ff84877207ULL, 0x000fe40000800000ULL,
0x00000079977d7211ULL, 0x040fe400078fe0ffULL, 0x0000007697857211ULL, 0x000fe200078fe0ffULL,
0x00000001797b7824ULL, 0x002fe400078e0287ULL, 0x0000000187837824ULL, 0x000fe400078e0276ULL,
0x000000027d7c7825ULL, 0x000fc800078e0088ULL, 0x000000027b7a7825ULL, 0x100fe200078e0088ULL,
0x000000067c707981ULL, 0x000ea6000c1e9500ULL, 0x0000000285847825ULL, 0x100fe200078e0088ULL,
0x000000067a717981ULL, 0x0002a6000c1e9500ULL, 0x0000000283827825ULL, 0x000fe200078e0088ULL,
0x0000000684767981ULL, 0x0002a2000c1e9500ULL, 0x00000073977f7211ULL, 0x000fc600078fe0ffULL,
0x0000000682797981ULL, 0x000ea2000c1e9500ULL, 0x0000000187817824ULL, 0x000fe400078e0273ULL,
0x000000027f7e7825ULL, 0x000fc800078e0088ULL, 0x0000000281807825ULL, 0x000fe200078e0088ULL,
0x000000067e737981ULL, 0x000ea2000c1e9500ULL, 0x00000086977b7211ULL, 0x002fc600078fe0ffULL,
0x00000006807a7981ULL, 0x000ea2000c1e9500ULL, 0x00000001877d7824ULL, 0x000fe400078e0286ULL,
0x000000027b867825ULL, 0x000fc800078e0088ULL, 0x000000027d887825ULL, 0x000fe200078e0088ULL,
0x00000006867b7981ULL, 0x0002a8000c1e9500ULL, 0x00000006887c7981ULL, 0x0004a2000c1e9500ULL,
0xfffffff099997812ULL, 0x000fe400078ec0ffULL, 0x0000002104847812ULL, 0x040fe400078efcffULL,
0x0000002804857812ULL, 0x000fe200078efcffULL, 0x00000001a6997824ULL, 0x000fe200078e0299ULL,
0x0000002904867812ULL, 0x002fc400078efcffULL, 0xfffffff0969d7812ULL, 0x000fe200078ec0ffULL,
0x00000001ff7d7424ULL, 0x000fe200078e00ffULL, 0xfffffff0979f7812ULL, 0x000fe200078ec0ffULL,
0x0000000a84907c36ULL, 0x000fe40008000000ULL, 0x0000000a85917c36ULL, 0x000fe40008000000ULL,
0x0000000a86927c36ULL, 0x000fe40008000000ULL, 0x00000001a6977824ULL, 0x000fe400078e029dULL,
0x000000014db67824ULL, 0x000fe200078e0a99ULL, 0x00000001047e7812ULL, 0x000fe200078efcffULL,
0x0000000164ae7824ULL, 0x000fc400078e0a97ULL, 0x0000000190a07824ULL, 0x100fe400078e0a97ULL,
0x0000000191ac7824ULL, 0x100fe400078e0a97ULL, 0x0000000192a27824ULL, 0x000fe200078e0a97ULL,
0x000000b67d977219ULL, 0x000fe200000006ffULL, 0x0000000a7e8a7c36ULL, 0x000fe20008000000ULL,
0xfffffff0989b7812ULL, 0x000fc600078ec0ffULL, 0x000000018a987824ULL, 0x100fe200078e0a99ULL,
0x00000008047f7812ULL, 0x040fe400078efcffULL, 0x0000000904807812ULL, 0x000fe400078efcffULL,
0x000000987d987219ULL, 0x000fe200000006ffULL, 0x0000000a7f8b7c36ULL, 0x000fe40008000000ULL,
0x0000000a808c7c36ULL, 0x000fe40008000000ULL, 0x000000018bb47824ULL, 0x000fc400078e0a99ULL,
0x000000018c9a7824ULL, 0x000fe200078e0a99ULL, 0x0000001104817812ULL, 0x000fe400078efcffULL,
0x000000b47d997219ULL, 0x040fe400000006ffULL, 0x0000009a7d9a7219ULL, 0x000fe200000006ffULL,
0x0000000a818d7c36ULL, 0x000fe40008000000ULL, 0x00000001a69e7824ULL, 0x000fe200078e029bULL,
0x000054104e4e7816ULL, 0x010fc80000000051ULL, 0x0000004e97ff7212ULL, 0x000fc800078ac0ffULL,
0x000000a64d00720cULL, 0x000fc80002fa1470ULL, 0x000000a60400720cULL, 0x000fe40002fa1070ULL,
0x0000004e98ff7212ULL, 0x000fe4000788c0ffULL, 0xff80000007077808ULL, 0x000fe40002800000ULL,
0x000054104f4f7816ULL, 0x020fe40000000054ULL, 0x0000541050507816ULL, 0x008fe40000000053ULL,
0x0000004f97ff7212ULL, 0x000fc4000784c0ffULL, 0x0000005097ff7212ULL, 0x000fe4000782c0ffULL,
0x0000004f98ff7212ULL, 0x000fe400078ac0ffULL, 0x000000a64d00720cULL, 0x0c0fe40001741470ULL,
0x000000a64d00720cULL, 0x080fe40000f21470ULL, 0x000000a68a00720cULL, 0x0c0fe40002781470ULL,
0x000000a68a00720cULL, 0x000fc40002fa1470ULL, 0x000000a60400720cULL, 0x0c0fe40001741070ULL,
0x000000a60400720cULL, 0x080fe40000f21070ULL, 0x000000a67e00720cULL, 0x0c0fe40002781070ULL,
0x000000a67e00720cULL, 0x000fe40002fa1070ULL, 0x0000541052527816ULL, 0x000fe40000000055ULL,
0xff80000046467808ULL, 0x000fc40001000000ULL, 0xff8000000b0b7808ULL, 0x000fe40000800000ULL,
0xff80000045457808ULL, 0x000fe40002000000ULL, 0xff80000047477808ULL, 0x000fe40002800000ULL,
0x0000004e99ff7212ULL, 0x000fe4000786c0ffULL, 0x0000005297ff7212ULL, 0x000fe4000780c0ffULL,
0x0000005098ff7212ULL, 0x000fc4000784c0ffULL, 0x0000005298ff7212ULL, 0x000fe4000782c0ffULL,
0x0000004f9aff7212ULL, 0x000fe4000788c0ffULL, 0x0000005099ff7212ULL, 0x000fe200078ac0ffULL,
0x0000000157b27824ULL, 0x100fe200078e0a9eULL, 0x000000a64d00720cULL, 0x080fe20000701470ULL,
0x000000018d9c7824ULL, 0x000fe200078e0a9eULL, 0x000000a68a00720cULL, 0x0c0fe40001741470ULL,
0x000000a68a00720cULL, 0x000fc40000f21470ULL, 0x000000a68b00720cULL, 0x0c0fe40001f61470ULL,
0x000000a68b00720cULL, 0x080fe40002fa1470ULL, 0x000000a68c00720cULL, 0x080fe40002781470ULL,
0x0000001804827812ULL, 0x040fe400078efcffULL, 0x0000001904837812ULL, 0x040fe400078efcffULL,
0x000000a60400720cULL, 0x000fc40000701070ULL, 0x000000a67e00720cULL, 0x0c0fe40001741070ULL,
0x000000a67e00720cULL, 0x080fe40000f21070ULL, 0x000000a67f00720cULL, 0x0c0fe40001f61070ULL,
0x000000a67f00720cULL, 0x080fe40002fa1070ULL, 0x000000a68000720cULL, 0x000fe40002781070ULL,
0x000000b27d9b7219ULL, 0x000fc400000006ffULL, 0x0000009c7d9c7219ULL, 0x000fe400000006ffULL,
0x000054105a5a7816ULL, 0x004fe4000000005dULL, 0x000054105c5c7816ULL, 0x000fe20000000063ULL,
0x0000000a828e7c36ULL, 0x000fe20008000000ULL, 0xff80000026267808ULL, 0x000fe20000000000ULL,
0x0000000a838f7c36ULL, 0x000fe20008000000ULL, 0xff80000025257808ULL, 0x000fe40001000000ULL,
0xff80000027277808ULL, 0x000fc40000800000ULL, 0xff80000040407808ULL, 0x000fe40001800000ULL,
0xff80000020207808ULL, 0x000fe40002800000ULL, 0xff80000043437808ULL, 0x000fe40002000000ULL,
0x0000004f99ff7212ULL, 0x040fe4000780c0ffULL, 0x000000509aff7212ULL, 0x000fe4000784c0ffULL,
0x0000005299ff7212ULL, 0x000fc4000782c0ffULL, 0x000000529aff7212ULL, 0x000fe4000786c0ffULL,
0x0000005a9cff7212ULL, 0x000fe400078ac0ffULL, 0x0000005c9bff7212ULL, 0x000fe2000788c0ffULL,
0x000000018eb07824ULL, 0x100fe200078e0a9eULL, 0x000000a68b00720cULL, 0x080fe20000701470ULL,
0x000000018f9e7824ULL, 0x000fe200078e0a9eULL, 0x000000a68b00720cULL, 0x080fe40000f21470ULL,
0x000000a68c00720cULL, 0x000fc40001741470ULL, 0x000000a68c00720cULL, 0x080fe40001f61470ULL,
0x000000a65700720cULL, 0x080fe40002781470ULL, 0x000000a68d00720cULL, 0x080fe40002fa1470ULL,
0x000000a67f00720cULL, 0x0c0fe40000701070ULL, 0x000000a67f00720cULL, 0x080fe40000f21070ULL,
0x000000a68000720cULL, 0x000fc40001741070ULL, 0x000000a68000720cULL, 0x080fe40001f61070ULL,
0x000000a65600720cULL, 0x080fe40002781070ULL, 0x000000a68100720cULL, 0x000fe40002fa1070ULL,
0x000000b07d9d7219ULL, 0x040fe400000006ffULL, 0x0000009e7d9e7219ULL, 0x000fe400000006ffULL,
0x000054105e5e7816ULL, 0x000fc40000000065ULL, 0x000054105f5f7816ULL, 0x000fe40000000060ULL,
0xff80000042427808ULL, 0x000fe40000000000ULL, 0xff80000022227808ULL, 0x000fe40000800000ULL,
0xff80000021217808ULL, 0x000fe40001000000ULL, 0xff80000023237808ULL, 0x000fe40001800000ULL,
0xff8000003e3e7808ULL, 0x000fc40002000000ULL, 0xff8000003d3d7808ULL, 0x000fe40002800000ULL,
0x0000005a9bff7212ULL, 0x080fe4000780c0ffULL, 0x0000005a9dff7212ULL, 0x000fe4000782c0ffULL,
0x0000005e9bff7212ULL, 0x0c0fe4000784c0ffULL, 0x0000005f9bff7212ULL, 0x000fe4000786c0ffULL,
0x0000005e9cff7212ULL, 0x000fc4000788c0ffULL, 0x0000005c9eff7212ULL, 0x000fe400078ac0ffULL,
0x000000a65700720cULL, 0x0c0fe40000701470ULL, 0x000000a65700720cULL, 0x0c0fe40001741470ULL,
0x000000a65700720cULL, 0x080fe40001f61470ULL, 0x000000a68d00720cULL, 0x080fe40002781470ULL,
0x000000a68e00720cULL, 0x000fc40000f21470ULL, 0x000000a68f00720cULL, 0x080fe20002fa1470ULL,
0x00000001a6967824ULL, 0x000fe200078e029fULL, 0x000000a65600720cULL, 0x0c0fe40000701070ULL,
0x000000a65600720cULL, 0x0c0fe40001741070ULL, 0x000000a65600720cULL, 0x080fe40001f61070ULL,
0x000000a68100720cULL, 0x080fe40002781070ULL, 0x000000a68200720cULL, 0x000fc40000f21070ULL,
0x000000a68300720cULL, 0x000fe40002fa1070ULL, 0x000000ae7d9f7219ULL, 0x000fe400000006ffULL,
0x0000541067677816ULL, 0x000fe4000000006cULL, 0xff8000003c3c7808ULL, 0x000fe40000000000ULL,
0xff8000001c1c7808ULL, 0x000fe40001000000ULL, 0xff8000001e1e7808ULL, 0x000fc40001800000ULL,
0xff8000001d1d7808ULL, 0x000fe40002000000ULL, 0xff80000038387808ULL, 0x000fe40000800000ULL,
0xff8000003b3b7808ULL, 0x000fe40002800000ULL, 0x0000005c9cff7212ULL, 0x0c0fe4000780c0ffULL,
0x0000005f9cff7212ULL, 0x000fe4000784c0ffULL, 0x0000005c9dff7212ULL, 0x000fc4000786c0ffULL,
0x0000005e9eff7212ULL, 0x040fe4000788c0ffULL, 0x0000005f9eff7212ULL, 0x000fe4000782c0ffULL,
0x000000679fff7212ULL, 0x000fe400078ac0ffULL, 0x000000a68d00720cULL, 0x0c0fe40000701470ULL,
0x000000a68d00720cULL, 0x080fe40001741470ULL, 0x000000a68e00720cULL, 0x000fc40001f61470ULL,
0x000000a68f00720cULL, 0x0c0fe40002781470ULL, 0x000000a68f00720cULL, 0x080fe40000f21470ULL,
0x000000a66400720cULL, 0x080fe40002fa1470ULL, 0x000000a68100720cULL, 0x0c0fe40000701070ULL,
0x000000a68100720cULL, 0x080fe40001741070ULL, 0x000000a68200720cULL, 0x000fc40001f61070ULL,
0x000000a68300720cULL, 0x0c0fe40002781070ULL, 0x000000a68300720cULL, 0x080fe40000f21070ULL,
0x000000a66200720cULL, 0x000fe40002fa1070ULL, 0x000000a07da07219ULL, 0x000fe400000006ffULL,
0x0000541066667816ULL, 0x000fe40000000069ULL, 0x0000541068687816ULL, 0x000fc4000000006bULL,
0x000054106a6a7816ULL, 0x000fe4000000006dULL, 0xff8000003f3f7808ULL, 0x000fe40000000000ULL,
0xff8000001f1f7808ULL, 0x000fe40001000000ULL, 0xff8000003a3a7808ULL, 0x000fe40001800000ULL,
0xff80000019197808ULL, 0x000fe40002000000ULL, 0xff8000001b1b7808ULL, 0x000fc40000800000ULL,
0xff80000036367808ULL, 0x000fe40002800000ULL, 0x0000004e9aff7212ULL, 0x000fe400078cc0ffULL,
0x0000005e9dff7212ULL, 0x040fe4000780c0ffULL, 0x0000005f9dff7212ULL, 0x000fe4000784c0ffULL,
0x000000669fff7212ULL, 0x040fe4000786c0ffULL, 0x000000689fff7212ULL, 0x000fc4000788c0ffULL,
0x0000006a9fff7212ULL, 0x000fe4000782c0ffULL, 0x00000068a0ff7212ULL, 0x000fe400078ac0ffULL,
0x000000a68c00720cULL, 0x080fe400037c1470ULL, 0x000000a68e00720cULL, 0x0c0fe40000701470ULL,
0x000000a68e00720cULL, 0x080fe40001741470ULL, 0x000000a66400720cULL, 0x000fc40001f61470ULL,
0x000000a66400720cULL, 0x0c0fe40002781470ULL, 0x000000a66400720cULL, 0x080fe40000f21470ULL,
0x000000a69000720cULL, 0x080fe40002fa1470ULL, 0x000000a68000720cULL, 0x080fe400037c1070ULL,
0x000000a68200720cULL, 0x0c0fe40000701070ULL, 0x000000a68200720cULL, 0x000fc40001741070ULL,
0x000000a66200720cULL, 0x0c0fe40001f61070ULL, 0x000000a66200720cULL, 0x0c0fe40002781070ULL,
0x000000a66200720cULL, 0x080fe40000f21070ULL, 0x000000a68400720cULL, 0x000fe40002fa1070ULL,
0x000000ac7da17219ULL, 0x040fe400000006ffULL, 0x000000a27da27219ULL, 0x000fc400000006ffULL,
0xff80000041417808ULL, 0x000fe40003000000ULL, 0xff80000018187808ULL, 0x000fe40000000000ULL,
0xff8000001a1a7808ULL, 0x000fe40001000000ULL, 0xff80000034347808ULL, 0x000fe40001800000ULL,
0xff80000014147808ULL, 0x000fe40002000000ULL, 0xff80000016167808ULL, 0x000fc40000800000ULL,
0xff80000015157808ULL, 0x000fe40002800000ULL, 0x0000005a9eff7212ULL, 0x000fe400078cc0ffULL,
0x00000066a0ff7212ULL, 0x0c0fe4000780c0ffULL, 0x00000066a1ff7212ULL, 0x000fe4000784c0ffULL,
0x00000067a0ff7212ULL, 0x040fe4000786c0ffULL, 0x0000006aa0ff7212ULL, 0x000fc4000788c0ffULL,
0x00000067a1ff7212ULL, 0x000fe4000782c0ffULL, 0x00000068a2ff7212ULL, 0x000fe200078ac0ffULL,
0x000000016faa7824ULL, 0x000fe200078e0a96ULL, 0x000000a68f00720cULL, 0x080fe400037c1470ULL,
0x000000a69000720cULL, 0x0c0fe40000701470ULL, 0x000000a69000720cULL, 0x0c0fe40001f61470ULL,
0x000000a69000720cULL, 0x000fc40002781470ULL, 0x000000a69100720cULL, 0x0c0fe40001741470ULL,
0x000000a69100720cULL, 0x080fe40000f21470ULL, 0x000000a69200720cULL, 0x000fe40002fa1470ULL,
0x0000003104877812ULL, 0x040fe400078efcffULL, 0x0000003804887812ULL, 0x040fe400078efcffULL,
0x0000003904897812ULL, 0x000fc400078efcffULL, 0x000000a68300720cULL, 0x080fe400037c1070ULL,
0x000000a68400720cULL, 0x0c0fe40000701070ULL, 0x000000a68400720cULL, 0x0c0fe40001f61070ULL,
0x000000a68400720cULL, 0x080fe40002781070ULL, 0x000000a68500720cULL, 0x0c0fe40001741070ULL,
0x000000a68500720cULL, 0x000fc40000f21070ULL, 0x000000a68600720cULL, 0x000fe40002fa1070ULL,
0x000000aa7da37219ULL, 0x000fe400000006ffULL, 0x0000541070707816ULL, 0x000fe40000000071ULL,
0x0000541076767816ULL, 0x000fe20000000079ULL, 0x0000000a87937c36ULL, 0x000fe20008000000ULL,
0xff80000039397808ULL, 0x000fe20003000000ULL, 0x0000000a88947c36ULL, 0x000fe20008000000ULL,
0xff80000035357808ULL, 0x000fe20000000000ULL, 0x0000000a89957c36ULL, 0x000fe20008000000ULL,
0xff80000037377808ULL, 0x000fc40001800000ULL, 0xff80000017177808ULL, 0x000fe40002000000ULL,
0xff80000030307808ULL, 0x000fe40001000000ULL, 0xff80000032327808ULL, 0x000fe40000800000ULL,
0xff80000011117808ULL, 0x000fe40002800000ULL, 0x00000066a2ff7212ULL, 0x040fe400078cc0ffULL,
0x00000067a2ff7212ULL, 0x000fc4000780c0ffULL, 0x00000068a1ff7212ULL, 0x040fe4000786c0ffULL,
0x0000006aa1ff7212ULL, 0x080fe4000788c0ffULL, 0x0000006aa2ff7212ULL, 0x000fe4000784c0ffULL,
0x00000070a3ff7212ULL, 0x040fe4000782c0ffULL, 0x00000076a3ff7212ULL, 0x000fe200078ac0ffULL,
0x0000000193a47824ULL, 0x100fe200078e0a96ULL, 0x000000a69100720cULL, 0x0c0fe20001f61470ULL,
0x0000000194a87824ULL, 0x100fe200078e0a96ULL, 0x000000a69100720cULL, 0x080fe20002781470ULL,
0x0000000195967824ULL, 0x000fe200078e0a96ULL, 0x000000a69200720cULL, 0x000fc400037c1470ULL,
0x000000a69200720cULL, 0x0c0fe40000701470ULL, 0x000000a69200720cULL, 0x080fe40001741470ULL,
0x000000a66f00720cULL, 0x0c0fe40000f21470ULL, 0x000000a66f00720cULL, 0x080fe40002fa1470ULL,
0x000000a68500720cULL, 0x0c0fe40001f61070ULL, 0x000000a68500720cULL, 0x000fc40002781070ULL,
0x000000a68600720cULL, 0x0c0fe400037c1070ULL, 0x000000a68600720cULL, 0x0c0fe40000701070ULL,
0x000000a68600720cULL, 0x080fe40001741070ULL, 0x000000a66e00720cULL, 0x0c0fe40000f21070ULL,
0x000000a66e00720cULL, 0x000fe40002fa1070ULL, 0x000000a47da47219ULL, 0x000fc400000006ffULL,
0x000000a87da57219ULL, 0x040fe400000006ffULL, 0x000000967d967219ULL, 0x000fe400000006ffULL,
0x0000541073737816ULL, 0x000fe4000000007aULL, 0xff80000010107808ULL, 0x000fe40001800000ULL,
0xff80000012127808ULL, 0x000fe40002000000ULL, 0xff80000031317808ULL, 0x000fc40003000000ULL,
0xff80000033337808ULL, 0x000fe40000000000ULL, 0xff80000013137808ULL, 0x000fe40001000000ULL,
0xff8000002c2c7808ULL, 0x000fe40000800000ULL, 0xff80000006067808ULL, 0x000fe40002800000ULL,
0x00000070a4ff7212ULL, 0x080fe4000786c0ffULL, 0x00000070a5ff7212ULL, 0x000fc4000788c0ffULL,
0x0000007096ff7212ULL, 0x000fe400078cc0ffULL, 0x00000073a3ff7212ULL, 0x080fe4000780c0ffULL,
0x00000073a4ff7212ULL, 0x0c0fe4000784c0ffULL, 0x00000073a5ff7212ULL, 0x000fe4000782c0ffULL,
0x00000076a4ff7212ULL, 0x000fe400078ac0ffULL, 0x000000a66f00720cULL, 0x000fc40000701470ULL,
0x000000a69300720cULL, 0x0c0fe40001f61470ULL, 0x000000a69300720cULL, 0x0c0fe40001741470ULL,
0x000000a69300720cULL, 0x080fe40002fa1470ULL, 0x000000a69400720cULL, 0x0c0fe40002781470ULL,
0x000000a69500720cULL, 0x080fe400037c1470ULL, 0x000000a69400720cULL, 0x000fc40000f21470ULL,
0x000000a66e00720cULL, 0x080fe40000701070ULL, 0x000000a68700720cULL, 0x0c0fe40001f61070ULL,
0x000000a68700720cULL, 0x0c0fe40001741070ULL, 0x000000a68700720cULL, 0x080fe40002fa1070ULL,
0x000000a68800720cULL, 0x0c0fe40002781070ULL, 0x000000a68800720cULL, 0x000fc40000f21070ULL,
0x000000a68900720cULL, 0x000fe400037c1070ULL, 0x000054107b7b7816ULL, 0x000fe4000000007cULL,
0xff8000002e2e7808ULL, 0x000fe40000000000ULL, 0xff8000002d2d7808ULL, 0x000fe40001800000ULL,
0xff8000002f2f7808ULL, 0x000fe40001000000ULL, 0xff8000000a0a7808ULL, 0x000fc40002800000ULL,
0xff80000028287808ULL, 0x000fe40002000000ULL, 0xff8000002a2a7808ULL, 0x000fe40000800000ULL,
0xff80000029297808ULL, 0x000fe40003000000ULL, 0x0000007396ff7212ULL, 0x040fe4000780c0ffULL,
0x00000076a5ff7212ULL, 0x080fe4000786c0ffULL, 0x0000007696ff7212ULL, 0x000fc4000784c0ffULL,
0x0000007ba3ff7212ULL, 0x080fe400078ac0ffULL, 0x0000007ba4ff7212ULL, 0x080fe4000788c0ffULL,
0x0000007ba5ff7212ULL, 0x080fe4000782c0ffULL, 0x0000007b96ff7212ULL, 0x000fe400078cc0ffULL,
0x000000a66f00720cULL, 0x080fe40002fa1470ULL, 0x000000a69300720cULL, 0x000fc40002781470ULL,
0x000000a69400720cULL, 0x0c0fe40001f61470ULL, 0x000000a69400720cULL, 0x080fe40000f21470ULL,
0x000000a69500720cULL, 0x0c0fe40000701470ULL, 0x000000a69500720cULL, 0x0c0fe40001741470ULL,
0x000000a69500720cULL, 0x080fe400037c1470ULL, 0x000000a66e00720cULL, 0x000fc40002fa1070ULL,
0x000000a68700720cULL, 0x080fe40002781070ULL, 0x000000a68900720cULL, 0x0c0fe40000701070ULL,
0x000000a68800720cULL, 0x0c0fe40001f61070ULL, 0x000000a68800720cULL, 0x080fe40000f21070ULL,
0x000000a68900720cULL, 0x0c0fe40001741070ULL, 0x000000a68900720cULL, 0x000fc400037c1070ULL,
0xff8000002b2b7808ULL, 0x000fe40000000000ULL, 0xff80000048487808ULL, 0x000fe40001800000ULL,
0xff80000049497808ULL, 0x000fe40001000000ULL, 0xff80000024247808ULL, 0x000fe40002800000ULL,
0xff80000044447808ULL, 0x000fe40002000000ULL, 0xff8000004a4a7808ULL, 0x000fc40000800000ULL,
0xff8000004b4b7808ULL, 0x000fce0003000000ULL, 0x000000070c00720bULL, 0x004fe20003f1e000ULL,
0x0000000172727836ULL, 0x000fc60000000000ULL, 0x0000000c070c7208ULL, 0x000fc80004000000ULL,
0x000000450c00720bULL, 0x000fc80003f1e000ULL, 0x0000000c454d7208ULL, 0x000fc80004000000ULL,
0x000000404d00720bULL, 0x000fc80003f1e000ULL, 0x0000004d40047208ULL, 0x000fc80004000000ULL,
0x000000410400720bULL, 0x000fc80003f1e000ULL, 0x00000004414d7208ULL, 0x000fc80004000000ULL,
0x0000003c4d00720bULL, 0x000fc80003f1e000ULL, 0x0000004d3c047208ULL, 0x000fc80004000000ULL,
0x0000003d0400720bULL, 0x000fc80003f1e000ULL, 0x000000043d4d7208ULL, 0x000fc80004000000ULL,
0x000000384d00720bULL, 0x000fc80003f1e000ULL, 0x0000004d38047208ULL, 0x000fc80004000000ULL,
0x000000390400720bULL, 0x000fc80003f1e000ULL, 0x00000004394d7208ULL, 0x000fc80004000000ULL,
0x000000344d00720bULL, 0x000fc80003f1e000ULL, 0x0000004d34047208ULL, 0x000fc80004000000ULL,
0x000000350400720bULL, 0x000fc80003f1e000ULL, 0x00000004354d7208ULL, 0x000fc80004000000ULL,
0x000000304d00720bULL, 0x000fc80003f1e000ULL, 0x0000004d30047208ULL, 0x000fc80004000000ULL,
0x000000310400720bULL, 0x000fc80003f1e000ULL, 0x00000004314d7208ULL, 0x000fc80004000000ULL,
0x0000002c4d00720bULL, 0x000fc80003f1e000ULL, 0x0000004d2c047208ULL, 0x000fc80004000000ULL,
0x0000002d0400720bULL, 0x000fc80003f1e000ULL, 0x000000042d4d7208ULL, 0x000fc80004000000ULL,
0x000000284d00720bULL, 0x000fc80003f1e000ULL, 0x0000004d28047208ULL, 0x000fe40004000000ULL,
0x000000460d00720bULL, 0x000fe40003f1e000ULL, 0x000000290400720bULL, 0x000fc80003f3e000ULL,
0x00000004290c7208ULL, 0x000fe40004800000ULL, 0x0000000d46047208ULL, 0x000fc60004000000ULL,
0x0c401f000c4d7f89ULL, 0x000ea200000e0000ULL, 0x000000470400720bULL, 0x000fc80003f1e000ULL,
0x00000004470d7208ULL, 0x000fc80004000000ULL, 0x000000420d00720bULL, 0x000fc80003f1e000ULL,
0x0000000d42047208ULL, 0x000fc80004000000ULL, 0x000000430400720bULL, 0x000fc80003f1e000ULL,
0x00000004430d7208ULL, 0x000fe40004000000ULL, 0x0000004d0c00720bULL, 0x004fe40003f3e000ULL,
0x0000003e0d00720bULL, 0x000fe40003f1e000ULL, 0x0000000c4d4d7208ULL, 0x000fe40004800000ULL,
0x0000000d3e047208ULL, 0x000fc60004000000ULL, 0x0c201f004d0c7f89ULL, 0x000ea200000e0000ULL,
0x0000003f0400720bULL, 0x000fc80003f1e000ULL, 0x000000043f0d7208ULL, 0x000fc80004000000ULL,
0x0000003a0d00720bULL, 0x000fc80003f1e000ULL, 0x0000000d3a047208ULL, 0x000fc80004000000ULL,
0x0000003b0400720bULL, 0x000fc80003f1e000ULL, 0x000000043b0d7208ULL, 0x000fe40004000000ULL,
0x0000000c4d00720bULL, 0x004fe40003f3e000ULL, 0x000000360d00720bULL, 0x000fe40003f1e000ULL,
0x0000004d0c0c7208ULL, 0x000fe40004800000ULL, 0x0000000d36047208ULL, 0x000fc60004000000ULL,
0x3fb8aa3b0c547820ULL, 0x000fe20000410000ULL, 0x000000370400720bULL, 0x000fc60003f1e000ULL,
0x3fb8aa3b454e7823ULL, 0x100fe20000010854ULL, 0x00000004370d7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b38457823ULL, 0x100fe20000010854ULL, 0x3fb8aa3b414d7823ULL, 0x100fe20000010854ULL,
0x3fb8aa3b3d417823ULL, 0x100fe20000010854ULL, 0x000000320d00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b39507823ULL, 0x100fe20000010854ULL, 0x3fb8aa3b07077823ULL, 0x100fe20000010854ULL,
0x3fb8aa3b40407823ULL, 0x100fe20000010854ULL, 0x0000000d32047208ULL, 0x000fe20004000000ULL,
0x0000004e004e7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b3c3c7823ULL, 0x100fe20000010854ULL,
0x3fb8aa3b35357823ULL, 0x000fe20000010854ULL, 0x000000330400720bULL, 0x000fc80003f1e000ULL,
0x00000004330d7208ULL, 0x000fe20004000000ULL, 0x0000000700077308ULL, 0x000ea60000000800ULL,
0x0000002e0d00720bULL, 0x000fc80003f1e000ULL, 0x0000000d2e047208ULL, 0x000fe20004000000ULL,
0x0000004000407308ULL, 0x000fe60000000800ULL, 0x0000002f0400720bULL, 0x000fc80003f1e000ULL,
0x000000042f0d7208ULL, 0x000fe20004000000ULL, 0x0000004d004d7308ULL, 0x000fe60000000800ULL,
0x0000002a0d00720bULL, 0x000fc80003f1e000ULL, 0x0000000d2a047208ULL, 0x000fe20004000000ULL,
0x0000003c003c7308ULL, 0x000fe60000000800ULL, 0x0000002b0400720bULL, 0x000fc80003f1e000ULL,
0x000000042b387208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b34047823ULL, 0x100fe20000010854ULL,
0x0000000b0e00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b30347823ULL, 0x100fe20000010854ULL,
0x3fb8aa3b2c307823ULL, 0x000fe20000010854ULL, 0x0c401f00383d7f89ULL, 0x000ee200000e0000ULL,
0x0000000e0b0e7208ULL, 0x000fe20004000000ULL, 0x0000004100417308ULL, 0x000fe60000000800ULL,
0x000000250e00720bULL, 0x000fc80003f1e000ULL, 0x0000000e250d7208ULL, 0x000fe20004000000ULL,
0x0000004500457308ULL, 0x000fe60000000800ULL, 0x000000200d00720bULL, 0x000fc80003f1e000ULL,
0x0000000d200e7208ULL, 0x000fe20004000000ULL, 0x0000005000507308ULL, 0x000fe60000000800ULL,
0x000000210e00720bULL, 0x000fe40003f1e000ULL, 0x0000003d3800720bULL, 0x008fe40003f3e000ULL,
0x0000000e210d7208ULL, 0x000fe20004000000ULL, 0x0000000400047308ULL, 0x000fe20000000800ULL,
0x000000383d397208ULL, 0x000fe20004800000ULL, 0x3fb8aa3b313d7823ULL, 0x100fe20000010854ULL,
0x0000001c0d00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b2d317823ULL, 0x100fe20000010854ULL,
0x3fb8aa3b28387823ULL, 0x000fe20000010854ULL, 0x0c201f0039527f89ULL, 0x000ee200000e0000ULL,
0x0000000d1c0e7208ULL, 0x000fe20004000000ULL, 0x0000003500357308ULL, 0x000fe60000000800ULL,
0x0000001d0e00720bULL, 0x000fc80003f1e000ULL, 0x0000000e1d0d7208ULL, 0x000fe20004000000ULL,
0x0000003400347308ULL, 0x000fe60000000800ULL, 0x000000180d00720bULL, 0x000fc80003f1e000ULL,
0x0000000d180e7208ULL, 0x000fe20004000000ULL, 0x0000003d003d7308ULL, 0x000fe60000000800ULL,
0x000000190e00720bULL, 0x000fe40003f1e000ULL, 0x000000523900720bULL, 0x008fe40003f3e000ULL,
0x0000000e192d7208ULL, 0x000fe20004000000ULL, 0x0000003000307308ULL, 0x000fe20000000800ULL,
0x00000039520d7208ULL, 0x000fe20004800000ULL, 0x3fb8aa3b29397823ULL, 0x000fe20000010854ULL,
0x000000142d00720bULL, 0x000fc60003f1e000ULL, 0x3fb8aa3b0d4f7820ULL, 0x000fe20000410000ULL,
0x0000002d140e7208ULL, 0x000fe20004000000ULL, 0x0000003100317308ULL, 0x000fe40000000800ULL,
0x3fb8aa3b47477823ULL, 0x100fe2000001084fULL, 0x000000150e00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b46287823ULL, 0x100fe2000001084fULL, 0x3fb8aa3b3e467823ULL, 0x100fe2000001084fULL,
0x3fb8aa3b422c7823ULL, 0x100fe2000001084fULL, 0x0000000e15297208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b3f427823ULL, 0x100fe2000001084fULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe2000001084fULL,
0x3fb8aa3b43437823ULL, 0x100fe2000001084fULL, 0x000000102900720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b36367823ULL, 0x100fe2000001084fULL, 0x3fb8aa3b37377823ULL, 0x100fe2000001084fULL,
0x3fb8aa3b32327823ULL, 0x100fe2000001084fULL, 0x00000029100e7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b33337823ULL, 0x000fe2000001084fULL, 0x0000004700297308ULL, 0x0007e40000000800ULL,
0x000000110e00720bULL, 0x000fc80003f1e000ULL, 0x0000000e112d7208ULL, 0x000fe40004000000ULL,
0x000000260f00720bULL, 0x000fe20003f1e000ULL, 0x0000002800287308ULL, 0x000f220000000800ULL,
0x000000062d00720bULL, 0x000fe40003f3e000ULL, 0x0000000f260e7208ULL, 0x000fe40004000000ULL,
0x0000002d062d7208ULL, 0x000fe40004800000ULL, 0x000000270e00720bULL, 0x000fe20003f1e000ULL,
0x0000002c002c7308ULL, 0x000fe20000000800ULL, 0x0000000a2d00720bULL, 0x000fc40003f3e000ULL,
0x0000000e270f7208ULL, 0x000fe40004000000ULL, 0x0000002d0a477208ULL, 0x008fe40004800000ULL,
0x000000220f00720bULL, 0x000fe20003f1e000ULL, 0x00000046002d7308ULL, 0x000fe20000000800ULL,
0x000000484700720bULL, 0x000fe40003f3e000ULL, 0x0000000f220e7208ULL, 0x000fe40004000000ULL,
0x00000047483e7208ULL, 0x000fe20004800000ULL, 0x3fb8aa3b3b477823ULL, 0x100fe2000001084fULL,
0x000000230e00720bULL, 0x000fe20003f1e000ULL, 0x0000003a00467308ULL, 0x0007e20000000800ULL,
0x000000493e00720bULL, 0x000fe20003f3e000ULL, 0x3fb8aa3b2f3b7823ULL, 0x000fe2000001084fULL,
0x0000000e230f7208ULL, 0x000fc40004000000ULL, 0x0000003e493e7208ULL, 0x000fe40004800000ULL,
0x0000001e0f00720bULL, 0x000fe20003f1e000ULL, 0x0000004300437308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2e3a7823ULL, 0x008fe2000001084fULL, 0x0c401f003e3f7f89ULL, 0x000ee200000e0000ULL,
0x0000000f1e0e7208ULL, 0x000fc80004000000ULL, 0x0000001f0e00720bULL, 0x000fe20003f1e000ULL,
0x0000004200427308ULL, 0x000f660000000800ULL, 0x0000000e1f0f7208ULL, 0x000fc80004000000ULL,
0x0000001a0f00720bULL, 0x000fe20003f1e000ULL, 0x0000004700477308ULL, 0x000fe60000000800ULL,
0x0000000f1a0e7208ULL, 0x000fc80004000000ULL, 0x0000001b0e00720bULL, 0x000fe20003f1e000ULL,
0x0000003600367308ULL, 0x000fe20000000800ULL, 0x0000003f3e00720bULL, 0x008fe40003f3e000ULL,
0x0000000e1b0f7208ULL, 0x000fe40004000000ULL, 0x0000003e3f3f7208ULL, 0x000fe20004800000ULL,
0x3fb8aa3b2a3e7823ULL, 0x000fe2000001084fULL, 0x000000160f00720bULL, 0x000fe20003f1e000ULL,
0x0000003700377308ULL, 0x000fe40000000800ULL, 0x0c201f003f527f89ULL, 0x000ee200000e0000ULL,
0x0000000f160e7208ULL, 0x000fc80004000000ULL, 0x000000170e00720bULL, 0x000fe20003f1e000ULL,
0x0000003200327308ULL, 0x000fe60000000800ULL, 0x0000000e170f7208ULL, 0x000fc80004000000ULL,
0x000000120f00720bULL, 0x000fe20003f1e000ULL, 0x0000003300337308ULL, 0x000fe60000000800ULL,
0x0000000f120e7208ULL, 0x000fc80004000000ULL, 0x000000130e00720bULL, 0x000fe20003f1e000ULL,
0x0000003800387308ULL, 0x000fe20000000800ULL, 0x000000523f00720bULL, 0x008fe40003f3e000ULL,
0x0000000e130f7208ULL, 0x000fe40004000000ULL, 0x0000003f520e7208ULL, 0x000fe20004800000ULL,
0x3fb8aa3b2b3f7823ULL, 0x000fe2000001084fULL, 0x000000240f00720bULL, 0x000fe20003f1e000ULL,
0x0000003900397308ULL, 0x000fe40000000800ULL, 0x3fb8aa3b0e2b7820ULL, 0x000fe20000410000ULL,
0x0000000f240f7208ULL, 0x000fc60004000000ULL, 0x3fb8aa3b0b2e7823ULL, 0x100fe2000001082bULL,
0x000000440f00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b144f7823ULL, 0x100fe2000001082bULL,
0x3fb8aa3b25257823ULL, 0x100fe2000001082bULL, 0x3fb8aa3b20207823ULL, 0x100fe2000001082bULL,
0x0000000f440f7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b21217823ULL, 0x100fe2000001082bULL,
0x00000025002f7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b15527823ULL, 0x100fe2000001082bULL,
0x0000004a0f00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b10517823ULL, 0x100fe2000001082bULL,
0x3fb8aa3b18187823ULL, 0x100fe2000001082bULL, 0x3fb8aa3b19197823ULL, 0x100fe2000001082bULL,
0x0000000f4a2a7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe2000001082bULL,
0x0000002e002e7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe2000001082bULL,
0x0000004b2a00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b11547823ULL, 0x100fe2000001082bULL,
0x3fb8aa3b0a0a7823ULL, 0x100fe2000001082bULL, 0x3fb8aa3b48487823ULL, 0x100fe2000001082bULL,
0x0000002a4b2a7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b49497823ULL, 0x000fe2000001082bULL,
0x0000002000207308ULL, 0x000fe60000000800ULL, 0x0c401f002a0b7f89ULL, 0x000eea00000e0000ULL,
0x0000002100217308ULL, 0x000eb00000000800ULL, 0x0000001800557308ULL, 0x0005f00000000800ULL,
0x00000019005a7308ULL, 0x0009e20000000800ULL, 0x000000074e18723eULL, 0x004fe200000000ffULL,
0x3c003c00ff077424ULL, 0x000fe200078e00ffULL, 0x0000000b2a00720bULL, 0x008fc80003f1e000ULL,
0x0000002a0b0f7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b060b7823ULL, 0x000fe2000001082bULL,
0x000000282919723eULL, 0x010fe200000000ffULL, 0x3c003c00ff067424ULL, 0x000fe200078e00ffULL,
0x0000001c00537308ULL, 0x0005e20000000800ULL, 0x0c201f000f147f89ULL, 0x000eee00000e0000ULL,
0x0000001d00567308ULL, 0x000b220000000800ULL, 0x0000003c411c723eULL, 0x004fce00000000ffULL,
0x0000004f004f7308ULL, 0x000fe20000000800ULL, 0x0000002d421d723eULL, 0x022fe400000000ffULL,
0xfffffff8ff427812ULL, 0x000fca00078ee208ULL, 0x0000005200527308ULL, 0x000fe20000000800ULL,
0x000000140f00720bULL, 0x008fc80003f1e000ULL, 0x0000000f140f7208ULL, 0x000fe40004000000ULL,
0x0000000303ff7812ULL, 0x000fe2000780c0ffULL, 0x0000005100517308ULL, 0x000fe40000000800ULL,
0x3fb8aa3b0f257820ULL, 0x000fc80000410000ULL, 0x3fb8aa3b22227823ULL, 0x100fe20000010825ULL,
0x3fb8aa3b23237823ULL, 0x100fe20000010825ULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010825ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010825ULL, 0x3fb8aa3b1a147823ULL, 0x100fe20000010825ULL,
0x000000404d1a723eULL, 0x000fe200000000ffULL, 0x0000002600157308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b17407823ULL, 0x100fe20000010825ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe20000010825ULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe20000010825ULL, 0x3fb8aa3b12127823ULL, 0x100fe20000010825ULL,
0x3fb8aa3b13137823ULL, 0x000fe20000010825ULL, 0x00000018424d7836ULL, 0x000fc40000000000ULL,
0x3fb8aa3b24247823ULL, 0x100fe20000010825ULL, 0x0000002700107308ULL, 0x0002a20000000800ULL,
0x3fb8aa3b44447823ULL, 0x100fe20000010825ULL, 0x3fb8aa3b4a4a7823ULL, 0x100fe20000010825ULL,
0x3fb8aa3b4b4b7823ULL, 0x000fca0000010825ULL, 0x0000002200227308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1b277823ULL, 0x102fe20000010825ULL, 0x0000002c431b723eULL, 0x000fe200000000ffULL,
0x3fb8aa3b162c7823ULL, 0x000fe20000010825ULL, 0x000000202116723eULL, 0x000fe400000000ffULL,
0x000000535620723eULL, 0x010fe400000000ffULL, 0x0000002300237308ULL, 0x000e620000000800ULL,
0x000000061828723cULL, 0x000fe200000018ffULL, 0x000000151015723eULL, 0x004fcc00000000ffULL,
0x0000001400267308ULL, 0x0005e20000000800ULL, 0x000000222317723eULL, 0x002fce00000000ffULL,
0x0000002c003c7308ULL, 0x0003e20000000800ULL, 0x0000002e2f14723eULL, 0x004fe400000000ffULL,
0x000000555a22723eULL, 0x000fe200000000ffULL, 0x000000084d557824ULL, 0x040fe200078e00ffULL,
0x00000003ff5a7819ULL, 0x000fe20000011603ULL, 0x000000084d4d7824ULL, 0x000fe400078e00ffULL,
0x0000001e00117308ULL, 0x0005e20000000800ULL, 0x00000006142c723cULL, 0x002fe200000018ffULL,
0x0000000403107810ULL, 0x000fc80007ffe05aULL, 0x0000000710107812ULL, 0x000fe400078ec0ffULL,
0x0000001f005c7308ULL, 0x0002e20000000800ULL, 0x00000045501e723eULL, 0x004fe200000000ffULL,
0x0000000842457836ULL, 0x000fe20000000000ULL, 0xfffffff855567812ULL, 0x000fca00078ee210ULL,
0x0000002700277308ULL, 0x000ea20000000800ULL, 0x00000046471f723eULL, 0x002fe200000000ffULL,
0x0000001042477836ULL, 0x000fc80000000000ULL, 0x0000000847537824ULL, 0x040fe200078e00ffULL,
0x000000115c21723eULL, 0x008fe200000000ffULL, 0x000000061c28723cULL, 0x000fe20000001828ULL,
0x0000005400547308ULL, 0x000e620000000800ULL, 0x0000000842117824ULL, 0x000fe200078e00ffULL,
0xfffffff853507812ULL, 0x000fe200078ee210ULL, 0x0000000847477824ULL, 0x000fe200078e00ffULL,
0x000000262723723eULL, 0x004fe200000000ffULL, 0x0000000845277824ULL, 0x000fc600078e00ffULL,
0x0000004000417308ULL, 0x000ea20000000800ULL, 0xfffffff811467812ULL, 0x000fe200078ee210ULL,
0x0000000845457824ULL, 0x000fe200078e00ffULL, 0x000000363711723eULL, 0x000fe200000000ffULL,
0x00000006202c723cULL, 0x000fe2000000182cULL, 0xfffffff8274e7812ULL, 0x000fc600078ee210ULL,
0x0000001200087308ULL, 0x0007e20000000800ULL, 0x000000043510723eULL, 0x000fe400000000ffULL,
0x000000035a047812ULL, 0x000fe400078ec0ffULL, 0x000000383926723eULL, 0x000fe200000000ffULL,
0x0000100078397824ULL, 0x000fe400078e0209ULL, 0x0000001300437308ULL, 0x0009620000000800ULL,
0x000000343d12723eULL, 0x008fce00000000ffULL, 0x0000002400407308ULL, 0x0007e20000000800ULL,
0x000000323313723eULL, 0x010fce00000000ffULL, 0x0000003a003a7308ULL, 0x000fe20000000800ULL,
0x000000303124723eULL, 0x008fe400000000ffULL, 0x000000061030723cULL, 0x000fea0000001828ULL,
0x0000003b003b7308ULL, 0x000ee40000000800ULL, 0x0000004f5228723eULL, 0x000fc400000000ffULL,
0x00000051542a723eULL, 0x002fe400000000ffULL, 0x0000003c4129723eULL, 0x004fe200000000ffULL,
0x000000ffff417224ULL, 0x000fe200078e0012ULL, 0x00000008432b723eULL, 0x020fe200000000ffULL,
0x0000003e003e7308ULL, 0x000fe20000000800ULL, 0x0000000104087824ULL, 0x000fe400078e0203ULL,
0x000000ffff437224ULL, 0x000fc600078e0026ULL, 0x00000006282c723cULL, 0x000fe2000000182cULL,
0x0000003a3b25723eULL, 0x008fe200000000ffULL, 0x0000003f003f7308ULL, 0x000e620000000800ULL,
0x00000008423b7824ULL, 0x000fe200078e00ffULL, 0x0000000708087812ULL, 0x000fe200078ec0ffULL,
0x000000ffff3a7224ULL, 0x000fe400078e001cULL, 0x000000ffff427224ULL, 0x000fe200078e0024ULL,
0xfffffff83b387812ULL, 0x000fe200078ee208ULL, 0x000000ffff3b7224ULL, 0x000fe200078e001eULL,
0x0000000b000b7308ULL, 0x000fe20000000800ULL, 0xfffffff8453c7812ULL, 0x000fe200078ee208ULL,
0x000000ffff127224ULL, 0x000fc400078e0025ULL, 0x000000ffff1c7224ULL, 0x000fe400078e0014ULL,
0x000000ffff1e7224ULL, 0x000fe200078e0020ULL, 0x0000003e3f27723eULL, 0x002fe200000000ffULL,
0x0000000a000a7308ULL, 0x000e620000000800ULL, 0xfffffff8473e7812ULL, 0x000fe200078ee208ULL,
0x000000ffff147224ULL, 0x000fe200078e0015ULL, 0xfffffff84d087812ULL, 0x000fe200078ee208ULL,
0x000000ffff157224ULL, 0x000fe400078e0017ULL, 0x000000062430723cULL, 0x000fe20000001830ULL,
0x000000ffff177224ULL, 0x000fe200078e0023ULL, 0x0000004800487308ULL, 0x000fe20000000800ULL,
0x000000ffff207224ULL, 0x000fc800078e0029ULL, 0x000000ffff247224ULL, 0x000fe200078e0028ULL,
0x0000000b0a34723eULL, 0x002fe400000000ffULL, 0x0000004900497308ULL, 0x000e620000000800ULL,
0x00012000390b7836ULL, 0x000fe40000000000ULL, 0x000000ffff397224ULL, 0x000fe400078e001aULL,
0x0000001046467824ULL, 0x100fe400078e020bULL, 0x000000103c3c7824ULL, 0x000fe200078e020bULL,
0x0000004400357308ULL, 0x000ea20000000800ULL, 0x000000ffff1a7224ULL, 0x000fc400078e001dULL,
0x000000104e4e7824ULL, 0x100fe400078e020bULL, 0x000000103e3e7824ULL, 0x100fe200078e020bULL,
0x000000484936723eULL, 0x002fe400000000ffULL, 0x0000004a00377308ULL, 0x000fe20000000800ULL,
0x000000ffff1d7224ULL, 0x000fe400078e0016ULL, 0x0000001050507824ULL, 0x000fe400078e020bULL,
0x000000ffff257224ULL, 0x000fe200078e002aULL, 0x000000403535723eULL, 0x004fc400000000ffULL,
0x0000004b00047308ULL, 0x000e620000000800ULL, 0x000000ffff407224ULL, 0x000fe400078e0010ULL,
0x000000ffff107224ULL, 0x000fe400078e0011ULL, 0x000000ffff117224ULL, 0x000fe400078e0013ULL,
0x000000ffff137224ULL, 0x000fe400078e0027ULL, 0x000000ffff267224ULL, 0x000fe400078e0034ULL,
0x000000ffff277224ULL, 0x000fc400078e0036ULL, 0x0000001008087824ULL, 0x100fe200078e020bULL,
0x000000370437723eULL, 0x002fe200000000ffULL, 0x0000001038047824ULL, 0x000fe400078e020bULL,
0x000000ffff387224ULL, 0x000fe400078e0018ULL, 0x000000ffff187224ULL, 0x000fe400078e0019ULL,
0x00000006342c723cULL, 0x000fe2000000182cULL, 0x000000ffff197224ULL, 0x000fe200078e001bULL,
0x0000003804007844ULL, 0x0003e20000000200ULL, 0x000000ffff1b7224ULL, 0x000fc400078e001fULL,
0x000000ffff1f7224ULL, 0x000fe200078e0022ULL, 0x0000004046007844ULL, 0x0003e20000000200ULL,
0x000000ffff167224ULL, 0x000fe400078e0021ULL, 0x0000001056567824ULL, 0x000fe200078e020bULL,
0x000000183c007844ULL, 0x0003e20000000200ULL, 0x000000ffff217224ULL, 0x000fe400078e002bULL,
0x000000ffff227224ULL, 0x000fe200078e0035ULL, 0x000000104e007844ULL, 0x0003e20000000200ULL,
0x000000ffff237224ULL, 0x000fc400078e0037ULL, 0x000000ffff317224ULL, 0x000fe200078e0032ULL,
0x0000001c3e007844ULL, 0x0003e20000000200ULL, 0x00000001ff077424ULL, 0x000fe400078e00ffULL,
0x000000ffff067224ULL, 0x000fe200078e0005ULL, 0x0000002450007844ULL, 0x0003e40000000200ULL,
0x000000ffff327224ULL, 0x000fe400078e002cULL, 0x000000ffff337224ULL, 0x000fe200078e002eULL,
0x0000001408007844ULL, 0x0003e80000000200ULL, 0x0000002056007844ULL, 0x0003e80000000200ULL,
0x01a0000c4c008388ULL, 0x0003e80000000c00ULL, 0x01a200304c008388ULL, 0x0003e20000000c00ULL,
0x0000005b7200720cULL, 0x000fe20003f06070ULL, 0x01a6080774ff79a7ULL, 0x0003e2000850003fULL,
0x01a6100774ff79a7ULL, 0x0003e2000850003fULL, 0x01a6180774ff79a7ULL, 0x0003e2000850003fULL,
0x01a6200774ff79a7ULL, 0x0003f2000850003fULL, 0xffffff9400088947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x018000007d007836ULL, 0x000fe20000000000ULL,
0x0000013000017945ULL, 0x000fe80003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000007d00008308ULL, 0x0002a20000001000ULL,
0x0000000000388947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x007fffff7dff7812ULL, 0x040fe4000780c0ffULL,
0x800000007d027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000000000047947ULL, 0x000fec0003800000ULL,
0x0000007d00007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffffe9c02147950ULL, 0x000fea0003c3ffffULL, 0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000002000000008ULL, 0x0000000400000001ULL, 0x0000001000000004ULL, 0x0000000800000001ULL,
0x0000000100000001ULL, 0x0000000100000008ULL, 0x0000000400000003ULL, 0x0000000300000004ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000040ULL, 0x0000000000000111ULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000000000000017bULL, 0x00000000000004e3ULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000660ULL, 0x0000000000000228ULL, 0x0000001500000002ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x00000001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000888ULL, 0x00000000000000e0ULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000968ULL, 0x0000000000000054ULL, 0x0000000000000003ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000009bcULL, 0x0000000000000700ULL, 0x0000000a00000003ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x00000004000000b2ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000010c0ULL, 0x0000000000000000ULL, 0x0000000a00000003ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x00000004000000e6ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000010c0ULL, 0x0000000000000048ULL, 0x0000000400000003ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL,
0x0000000000001108ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL,
0x0000000000001180ULL, 0x0000000000016480ULL, 0x0000001500000003ULL, 0x0000000000000080ULL,
0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL,
0x0000000000017600ULL, 0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL,
0x0000000000017640ULL, 0x0000000000000400ULL, 0x0000000a00000000ULL, 0x0000000000000010ULL,
0x0000000000000000ULL, 0x00000001000000f8ULL, 0x0000000000000002ULL, 0x0000000000000000ULL,
0x0000000000017640ULL, 0x0000000000000268ULL, 0x0000000a00000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000400000006ULL, 0x0000000000017c28ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x0000000000017c28ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x0000000000001108ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001180ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000016480ULL, 0x0000000000016480ULL,
0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000017600ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000440ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x0000000000017640ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000268ULL, 0x0000000000000268ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_nqpkv_0_m_32_sm_90_cubin_len = 97656;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
