/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_nqpkv_8_m_8_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000000fc50ULL, 0x000000000000f8d0ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f5f374944327961ULL, 0x326a4c32666c6168ULL,
0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL,
0x4545346a4c6a4963ULL, 0x316a4c4536316a4cULL, 0x4c49746132454536ULL, 0x534b524545453162ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45346a4c4534366aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL,
0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL,
0x4c45346a4c497461ULL, 0x45326a4c4545316aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL,
0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL,
0x4939494432796172ULL, 0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL,
0x4c49746132454531ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x45386a4c4532336aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL,
0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4532ULL, 0x454530624c497461ULL,
0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL,
0x4944327961727241ULL, 0x6a4c6a4963655633ULL, 0x4c45386a4c454534ULL, 0x497461324545386aULL,
0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x386a4c4536316a4cULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5f5f2400676e6964ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x6e72656b24006168ULL, 0x732461686d5f6c65ULL, 0x42657479426d656dULL, 0x632e766e2e006675ULL,
0x30746e6174736e6fULL, 0x5f6c656e72656b2eULL, 0x7261705f0061686dULL, 0x756265642e006d61ULL,
0x00656d6172665f67ULL, 0x6265642e6c65722eULL, 0x656d6172665f6775ULL, 0x642e616c65722e00ULL,
0x6172665f67756265ULL, 0x722e766e2e00656dULL, 0x6f697463612e6c65ULL, 0x000000000000006eULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c0001000000adULL,
0x0000000000000034ULL, 0x0000000000000010ULL, 0x000c0001000000ebULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c00010000016bULL, 0x000000000000002cULL, 0x0000000000000004ULL, 0x000c0001000001adULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c0001000001f3ULL, 0x0000000000000024ULL,
0x0000000000000004ULL, 0x000c00010000023aULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000c000100000280ULL, 0x0000000000000030ULL, 0x0000000000000004ULL, 0x000c0001000002ceULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c00010000031cULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c00010000036aULL, 0x000000000000000cULL, 0x0000000000000004ULL,
0x000c0001000003b0ULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c0001000003feULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000443ULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000b002200000489ULL, 0x000000000000ddf0ULL, 0x0000000000000180ULL,
0x000b0022000004bcULL, 0x000000000000df70ULL, 0x0000000000000040ULL, 0x000b0022000004e7ULL,
0x000000000000dfb0ULL, 0x0000000000000050ULL, 0x000b002200000511ULL, 0x000000000000e000ULL,
0x0000000000000100ULL, 0x000a00030000057fULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000400030000059fULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000005cfULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL,
0x000000000000e100ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000ddf000000000ULL, 0x0000040400000000ULL,
0x810c000001340400ULL, 0x00363c0400288080ULL, 0x0000000000000000ULL, 0x00000054ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x9008288080840828ULL, 0x2880809408288080ULL, 0x808708288080b808ULL,
0x1028808280162880ULL, 0x0000000000000003ULL, 0x2200288080879200ULL, 0x00000034ffffffffULL,
0x0000007000000000ULL, 0x0000ddf000000000ULL, 0x0000018000000000ULL, 0x0000480400000000ULL,
0x8080288080840900ULL, 0x0900000010042880ULL, 0x2880808428808087ULL, 0x00000054ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x9008288080840828ULL, 0x2880809408288080ULL, 0x80b008288080b808ULL,
0x1028808280162880ULL, 0x0000000000000003ULL, 0x2200288080b09200ULL, 0x0000001cffffffffULL,
0x0000011000000000ULL, 0x0000df7000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x00000054ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x9008288080840828ULL, 0x2880809408288080ULL,
0x828016288080b808ULL, 0x0000000003102880ULL, 0x8080b89200000000ULL, 0x0000000000220028ULL,
0x0000002cffffffffULL, 0x0000019800000000ULL, 0x0000dfb000000000ULL, 0x0000005000000000ULL,
0x0000100400000000ULL, 0x8090288080b80900ULL, 0x0000000000002880ULL, 0x00000054ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x9408288080840828ULL, 0x288080b808288080ULL, 0x8280162880809008ULL,
0x0000000003102880ULL, 0x8080909200000000ULL, 0x0000000000220028ULL, 0x0000001cffffffffULL,
0x0000023000000000ULL, 0x0000e00000000000ULL, 0x0000010000000000ULL, 0x0000000000000000ULL,
0x0000001a00082f04ULL, 0x0008230400000062ULL, 0x0000000000000016ULL, 0x0000001600081204ULL,
0x0008110400000000ULL, 0x0000000000000016ULL, 0x0000001500082304ULL, 0x0008120400000000ULL,
0x0000000000000015ULL, 0x0000001500081104ULL, 0x0008230400000000ULL, 0x0000000000000014ULL,
0x0000001400081204ULL, 0x0008110400000000ULL, 0x0000000000000014ULL, 0x0000001300082304ULL,
0x0008120400000000ULL, 0x0000000000000013ULL, 0x0000001300081104ULL, 0x0008230400000000ULL,
0x000000000000001aULL, 0x0000001a00081204ULL, 0x0008110400000000ULL, 0x000000000000001aULL,
0x0000007b00043704ULL, 0x0000001700080a04ULL, 0x0048190300480160ULL, 0x00000000000c1704ULL,
0x0021f00000400006ULL, 0x00000000000c1704ULL, 0x0021f00000380005ULL, 0x00000000000c1704ULL,
0x0011f00000300004ULL, 0x00000000000c1704ULL, 0x0061f00000180003ULL, 0x00000000000c1704ULL,
0x0021f00000100002ULL, 0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL,
0x0011f00000000000ULL, 0x0004310400ff1b03ULL, 0x0134290400000020ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x01342804ffffffffULL, 0x000000d0000000c0ULL, 0x00001ea000000400ULL,
0x0000207000001f60ULL, 0x00002640000021e0ULL, 0x000026c000002670ULL, 0x00003e1000002710ULL,
0x00003fe000003eb0ULL, 0x0000460000004140ULL, 0x0000468000004630ULL, 0x00005af0000046d0ULL,
0x00005cb000005b80ULL, 0x0000628000005e10ULL, 0x00006300000062b0ULL, 0x000077c000006350ULL,
0x0000798000007850ULL, 0x00007f6000007ae0ULL, 0x00007fe000007f90ULL, 0x000087d000008030ULL,
0x0000c640000087e0ULL, 0x0000c6900000c680ULL, 0x0000c6f00000c6a0ULL, 0x0000c7300000c710ULL,
0x0000d3800000c740ULL, 0x0000d4200000d3d0ULL, 0x0000d4d00000d470ULL, 0x0000d5800000d530ULL,
0x0000d6100000d5d0ULL, 0x0000d6c00000d660ULL, 0x0000d7600000d710ULL, 0x0000d8000000d7b0ULL,
0x0000d8b00000d850ULL, 0x0000d9500000d900ULL, 0x0000d9e00000d9a0ULL, 0x0000da900000da30ULL,
0x0000db300000dae0ULL, 0x0000dbf00000db90ULL, 0x0000dcb00000dc50ULL, 0x0000dd700000dd10ULL,
0x044039040000ddd0ULL, 0x000000ff00000200ULL, 0x003f01000000f600ULL, 0x0000000d00000260ULL,
0x003f01200000f608ULL, 0x0000000d00000370ULL, 0x003f01200000f688ULL, 0x0000000d000003a0ULL,
0x003f01200000f6a8ULL, 0x0000000d000003d0ULL, 0x003f01200000f6c8ULL, 0x000000ff00000460ULL,
0x003f01070000f600ULL, 0x0000000d00000560ULL, 0x003f01020000f68cULL, 0x0000000d000005f0ULL,
0x003f01010000f688ULL, 0x0000000500000d60ULL, 0x003f01070000f6a8ULL, 0x0000000500000e70ULL,
0x003f01010000f6a8ULL, 0x0000001400000ed0ULL, 0x003f010100000020ULL, 0x0000000c00001020ULL,
0x003f010500000004ULL, 0x0000000c00001200ULL, 0x003f010500000004ULL, 0x0000005600001a20ULL,
0x003f01070000f6a8ULL, 0x0000005600001b10ULL, 0x003f01010000f6a8ULL, 0x0000001100001b70ULL,
0x003f01010000f608ULL, 0x0000001300001bc0ULL, 0x003f01050000f60cULL, 0x0000001300001d90ULL,
0x003f01050000f60cULL, 0x00000017000023a0ULL, 0x003f01050000f6acULL, 0x0000001700002570ULL,
0x003f01050000f6acULL, 0x0000000c00002ee0ULL, 0x003f010100000000ULL, 0x0000004800002f60ULL,
0x003f01010000f688ULL, 0x0000000c00002fd0ULL, 0x003f010500000004ULL, 0x0000000c000031a0ULL,
0x003f010500000004ULL, 0x00000054000039f0ULL, 0x003f01070000f6a8ULL, 0x0000005400003ae0ULL,
0x003f01010000f6a8ULL, 0x0000001100003b40ULL, 0x003f01010000f628ULL, 0x0000003800003b90ULL,
0x003f01050000f62cULL, 0x0000003800003d60ULL, 0x003f01050000f62cULL, 0x0000001200004330ULL,
0x003f01050000f6acULL, 0x0000001700004520ULL, 0x003f01050000f6acULL, 0x0000000c00004cd0ULL,
0x003f010100000000ULL, 0x0000004800004d40ULL, 0x003f01010000f690ULL, 0x0000000c00004d90ULL,
0x003f010500000004ULL, 0x0000000c00004f60ULL, 0x003f010500000004ULL, 0x00000055000056b0ULL,
0x003f010700000000ULL, 0x00000012000057f0ULL, 0x003f01010000f6a8ULL, 0x0000001600005850ULL,
0x003f01010000f648ULL, 0x0000001600005870ULL, 0x003f01050000f64cULL, 0x0000001600005a40ULL,
0x003f01050000f64cULL, 0x0000005400005fe0ULL, 0x003f01050000f6acULL, 0x00000054000061b0ULL,
0x003f01050000f6acULL, 0x0000000c00006990ULL, 0x003f010100000000ULL, 0x0000004800006a00ULL,
0x003f01010000f698ULL, 0x0000001400006a80ULL, 0x003f01050000f6ccULL, 0x0000001400006c50ULL,
0x003f01050000f6ccULL, 0x00000053000073a0ULL, 0x003f010700000000ULL, 0x00000054000074c0ULL,
0x003f01010000f6a8ULL, 0x0000003800007520ULL, 0x003f01010000f668ULL, 0x0000003800007540ULL,
0x003f01050000f66cULL, 0x0000003800007710ULL, 0x003f01050000f66cULL, 0x0000005800007cc0ULL,
0x003f01050000f6acULL, 0x0000005800007e90ULL, 0x003f01050000f6acULL, 0x0000000c000085a0ULL,
0x003f010100000000ULL, 0x0000004800008600ULL, 0x003f01010000f6a0ULL, 0x000000ff00009350ULL,
0x003f01010000f600ULL, 0x000000ff00009e40ULL, 0x003f01050000f604ULL, 0x000000ff0000a010ULL,
0x003f01050000f604ULL, 0x000000ff0000a240ULL, 0x003f01010000f600ULL, 0x000000ff0000a270ULL,
0x003f01050000f604ULL, 0x000000ff0000a430ULL, 0x003f01050000f604ULL, 0x000000380000ba50ULL,
0x003f010100000000ULL, 0x000000380000bb70ULL, 0x003f010500000004ULL, 0x000000380000bd40ULL,
0x003f010500000004ULL, 0x0000000d0000d1e0ULL, 0x003f010100000000ULL, 0x0000000d0000d240ULL,
0x003f010100000008ULL, 0x0000000d0000d2a0ULL, 0x003f010100000010ULL, 0x0000000d0000d310ULL,
0x003f010100000018ULL, 0x00141c0400053803ULL, 0x000092a000009030ULL, 0x0000a5400000a490ULL,
0x000004010000d350ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x00000000000002a4ULL, 0x0000001a00000002ULL,
0x000000000000020cULL, 0x0000001a00000002ULL, 0x0000000000000184ULL, 0x0000001a00000002ULL,
0x00000000000000e4ULL, 0x0000001a00000002ULL, 0x0000000000000044ULL, 0x0000001a00000002ULL,
0x000000000000027cULL, 0x0000001a00000002ULL, 0x00000000000001e4ULL, 0x0000001a00000002ULL,
0x0000000000000161ULL, 0x0000001a00000002ULL, 0x00000000000000c1ULL, 0x0000001a00000002ULL,
0x000000000000f700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x00000000000d7919ULL, 0x000e620000002100ULL,
0x0000000000157806ULL, 0x000fe200038e0000ULL, 0x00005800ff077624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000027919ULL, 0x000ea40000002300ULL,
0x0000000807077824ULL, 0x000fe400078e00ffULL, 0x0000000000037919ULL, 0x000ee80000002200ULL,
0x0000000000047919ULL, 0x000f280000000000ULL, 0x0000000000127919ULL, 0x000f280000002600ULL,
0x0000000000117919ULL, 0x000f220000002700ULL, 0x00000005ff417819ULL, 0x002fc6000001160dULL,
0x00001fff020c7589ULL, 0x0043e800000e0000ULL, 0x00001fff41417589ULL, 0x000ea200000e0000ULL,
0x0000010002007a24ULL, 0x008fe400078e0203ULL, 0x0000001500037300ULL, 0x000ee400000e0000ULL,
0x00000000000d7a24ULL, 0x000fe400078e020dULL, 0x0000000000007919ULL, 0x000ea20000000000ULL,
0x0000000812067824ULL, 0x010fc400078e00ffULL, 0x000000ff0d00720cULL, 0x040fe20003f45270ULL,
0x0000001500157309ULL, 0x000f220000000000ULL, 0x0000000f0d00780cULL, 0x000fe20003f64070ULL,
0x0000001107087224ULL, 0x000fe200078e0206ULL, 0x0000007f0d00780cULL, 0x040fe40003f84070ULL,
0x000000030d00780cULL, 0x000fe40003f24070ULL, 0x000000040300720cULL, 0x008fca0003f02070ULL,
0x3fffff80ff02a424ULL, 0x002fe400078e00ffULL, 0x000000040c097824ULL, 0x004fe400078e0241ULL,
0x7fffff80ff03a424ULL, 0x000fe400078e00ffULL, 0x0000000209097824ULL, 0x000fe200078e00ffULL,
0x00000004ff0f7819ULL, 0x000fe20000011600ULL, 0x3fffffc0ff04b424ULL, 0x000fe200078e00ffULL,
0x00f60002ff00a388ULL, 0x0003e40000000a00ULL, 0x00000008090a7817ULL, 0x000fe20007800000ULL,
0x7fffffc0ff05b424ULL, 0x000fe200078e00ffULL, 0x000000010d00780cULL, 0x000fe20003f44070ULL,
0x0000001000107824ULL, 0x000fc400078e00ffULL, 0x000000010a0e7824ULL, 0x000fe200078e0a09ULL,
0x00f608040d00b388ULL, 0x0005e20000008a00ULL, 0x0000000109097824ULL, 0x000fe400078e020fULL,
0x00000100ff037424ULL, 0x002fe200078e00ffULL, 0x0000000e0f00720cULL, 0x000fe20003f66070ULL,
0x0000000108027824ULL, 0x000fe400078e0209ULL, 0xff317217ff14c424ULL, 0x000fe400078e00ffULL,
0x0000001009137824ULL, 0x000fc400078e00ffULL, 0x00005c0002027625ULL, 0x000fe200078e0003ULL,
0x000000f010057812ULL, 0x004fe200078ec0ffULL, 0x00f400140d00c388ULL, 0x000fe40000004800ULL,
0x0000000109047824ULL, 0x000fe400078e0200ULL, 0x3fffff60ff069424ULL, 0x000fe400078e00ffULL,
0x7fffff60ff079424ULL, 0x000fe200078e00ffULL, 0xfffffff0130e7812ULL, 0x000fe200078ee204ULL,
0x3fffff80ff089424ULL, 0x000fe200078e00ffULL, 0x0000000502047210ULL, 0x000fe20007f9e0ffULL,
0x7fffff80ff099424ULL, 0x000fe200078e00ffULL, 0x00f688060d009388ULL, 0x0003e20000008a00ULL,
0x3fffffc0ff0aa424ULL, 0x000fc400078e00ffULL, 0x7fffffc0ff0ba424ULL, 0x000fe200078e00ffULL,
0x00f6a8080d009388ULL, 0x000fe20000008a00ULL, 0x000000ffff057224ULL, 0x000fe400020e0603ULL,
0x00000004ff027424ULL, 0x000fe200078e00ffULL, 0x00f6c80a0d00a388ULL, 0x000fe60000008a00ULL,
0x0000600011027625ULL, 0x000fc800078e0002ULL, 0x000000100e077824ULL, 0x002fe200078e00ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000ffff067224ULL, 0x010fe200078e0a15ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004077faeULL, 0x0003e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00f60406ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000602407981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0c00720cULL, 0x000fc40003f05270ULL,
0x000000ff40067810ULL, 0x006fc80007ffe0ffULL, 0x00000008ff0f7819ULL, 0x000fce0000011606ULL,
0x00008d8000008947ULL, 0x000fea0003800000ULL, 0x00000008410d7824ULL, 0x000fe400078e00ffULL,
0x00000003ff027424ULL, 0x000fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f68c020dff738cULL, 0x0003e20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000001ff0600780cULL, 0x000fe20003f04070ULL, 0x0000000211047824ULL, 0x000fe200078e00ffULL,
0x0000580012057a10ULL, 0x000fe20007ffe0ffULL, 0x00f688000dff7f8cULL, 0x0005e2000c80043fULL,
0x00000001ff027819ULL, 0x002fe40000011641ULL, 0x00000001410e7812ULL, 0x000fe200078ec0ffULL,
0x0000580004047a24ULL, 0x000fc400078e0205ULL, 0x0000002002037824ULL, 0x000fc800078e00ffULL,
0x0000620004057a24ULL, 0x000fe200078e0203ULL, 0x000003c000000947ULL, 0x000fea0003800000ULL,
0x0000000340067217ULL, 0x004fe20007800000ULL, 0x000000100e077824ULL, 0x000fe200078e00ffULL,
0x00000003ff087819ULL, 0x000fe20000011600ULL, 0x00000080ff177424ULL, 0x000fe200078e00ffULL,
0x0000007010197812ULL, 0x000fe200078ec0ffULL, 0x0000000106067824ULL, 0x000fe200078e0a03ULL,
0x00000004080b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000107097824ULL, 0x000fc600078e0208ULL,
0x0000000706067217ULL, 0x000fe20007800000ULL, 0x00000001090a7824ULL, 0x040fe400078e0200ULL,
0x0000000809117824ULL, 0x000fe400078e00ffULL, 0x0000000106067824ULL, 0x000fe400078e0a07ULL,
0x00000001070c7824ULL, 0x000fe200078e020bULL, 0xfffffff8110a7812ULL, 0x000fe400078ee20aULL,
0x000000060b00720cULL, 0x000fe20003f46070ULL, 0x000000080c157824ULL, 0x000fe200078e00ffULL,
0x00000008080b7810ULL, 0x000fc40007ffe0ffULL, 0x0000000c08117810ULL, 0x040fe40007ffe0ffULL,
0x000000060800720cULL, 0x080fe20003f66070ULL, 0x000000010c087824ULL, 0x000fe200078e0200ULL,
0x000000060b00720cULL, 0x080fe20003f26070ULL, 0x00000001070b7824ULL, 0x000fe200078e020bULL,
0x000000061100720cULL, 0x000fe20003f06070ULL, 0x0000000105067824ULL, 0x000fe200078e0209ULL,
0xfffffff815127812ULL, 0x000fe200078ee208ULL, 0x0000000107137824ULL, 0x000fe400078e0211ULL,
0x00005e0006067625ULL, 0x000fc800078e0017ULL, 0x00000001050c7824ULL, 0x040fe200078e020cULL,
0x0000001906107210ULL, 0x000fe20007f9e0ffULL, 0x0000000105087824ULL, 0x040fe400078e020bULL,
0x0000000105157824ULL, 0x000fe200078e0213ULL, 0x0000b00002057811ULL, 0x000fe200078e68ffULL,
0x000000010b097824ULL, 0x140fe400078e0200ULL, 0x000000080b147824ULL, 0x000fe400078e00ffULL,
0x00000001130b7824ULL, 0x000fc400078e0200ULL, 0x0000000813167824ULL, 0x000fe200078e00ffULL,
0xfffffff814147812ULL, 0x000fe200078ee209ULL, 0x000000ffff117224ULL, 0x000fe400020e0607ULL,
0x00005e000c067625ULL, 0x000fe200078e0017ULL, 0xfffffff816167812ULL, 0x000fc600078ee20bULL,
0x000000100a137824ULL, 0x000fe200078e0205ULL, 0x0000001906067210ULL, 0x000fe20007f9e0ffULL,
0x00005e0008087625ULL, 0x000fc600078e0017ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010137faeULL, 0x0003e2000d901c46ULL, 0x00005e00150a7625ULL, 0x000fe200078e0017ULL,
0x0000001908087210ULL, 0x000fc60007fbe0ffULL, 0x0000001012157824ULL, 0x000fe200078e0205ULL,
0x000000190a0a7210ULL, 0x000fe20007fde0ffULL, 0x000000ffff077224ULL, 0x000fe400020e0607ULL,
0x0000001014177824ULL, 0x000fe400078e0205ULL, 0x000000ffff097224ULL, 0x000fe200028e0609ULL,
0x0000000006157faeULL, 0x0003e2000d101c46ULL, 0x0000001016057824ULL, 0x000fe400078e0205ULL,
0x000000ffff0b7224ULL, 0x000fe200030e060bULL, 0x0000000008177faeULL, 0x0003e8000c901c46ULL,
0x000000000a057faeULL, 0x0003e2000c101c46ULL, 0x000002f000007947ULL, 0x000fea0003800000ULL,
0x000000100e077824ULL, 0x004fe200078e00ffULL, 0x0000007010157812ULL, 0x000fe200078ec0ffULL,
0x00000080ff187424ULL, 0x000fe200078e00ffULL, 0x0000b00002177811ULL, 0x000fc400078e68ffULL,
0x0000000700067211ULL, 0x000fc800078fe8ffULL, 0x0000000406087810ULL, 0x040fe20007ffe0ffULL,
0x0000000106077824ULL, 0x040fe200078e0200ULL, 0x00000008060b7810ULL, 0x040fe20007ffe0ffULL,
0x00000008060c7824ULL, 0x040fe200078e00ffULL, 0x0000000c06107810ULL, 0x000fe20007ffe0ffULL,
0x0000000105097824ULL, 0x040fe400078e0208ULL, 0x00000001080a7824ULL, 0x000fe200078e0200ULL,
0xfffffff80c0c7812ULL, 0x000fe200078ee207ULL, 0x0000000105077824ULL, 0x000fe400078e0206ULL,
0x0000000808117824ULL, 0x000fc400078e00ffULL, 0x00005e0007067625ULL, 0x000fc600078e0018ULL,
0xfffffff811127812ULL, 0x000fe200078ee20aULL, 0x0000000105087824ULL, 0x040fe400078e020bULL,
0x0000000105137824ULL, 0x000fe400078e0210ULL, 0x000000010b057824ULL, 0x140fe400078e0200ULL,
0x000000080b147824ULL, 0x000fe400078e00ffULL, 0x00000001100b7824ULL, 0x040fe400078e0200ULL,
0x0000000810167824ULL, 0x000fe200078e00ffULL, 0x0000001506107210ULL, 0x000fc40007f1e0ffULL,
0xfffffff814147812ULL, 0x000fe200078ee205ULL, 0x000000100c057824ULL, 0x000fe200078e0217ULL,
0xfffffff816167812ULL, 0x000fe200078ee20bULL, 0x000000ffff117224ULL, 0x000fe400000e0607ULL,
0x00005e0009067625ULL, 0x000fc600078e0018ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010057faeULL, 0x0003e2000b901c46ULL, 0x00005e0008087625ULL, 0x000fe200078e0018ULL,
0x0000001506067210ULL, 0x000fc60007f1e0ffULL, 0x00005e00130a7625ULL, 0x000fe200078e0018ULL,
0x0000001508087210ULL, 0x000fc60007f3e0ffULL, 0x0000001012137824ULL, 0x000fe200078e0217ULL,
0x000000150a0a7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff077224ULL, 0x000fe400000e0607ULL,
0x0000001014157824ULL, 0x000fe400078e0217ULL, 0x000000ffff097224ULL, 0x000fe200008e0609ULL,
0x0000000006137faeULL, 0x0003e2000b901c46ULL, 0x0000001016177824ULL, 0x000fe400078e0217ULL,
0x000000ffff0b7224ULL, 0x000fe200010e060bULL, 0x0000000008157faeULL, 0x0003e8000b901c46ULL,
0x000000000a177faeULL, 0x0003e4000b901c46ULL, 0x0000001002057824ULL, 0x042fe200078e00ffULL,
0x000000ff0f00720cULL, 0x000fe20003f05270ULL, 0x000000ffff067224ULL, 0x000fe200078e00ffULL,
0x0000f6a802147811ULL, 0x000fe200078e18ffULL, 0x00000000050473c2ULL, 0x000e6200000e0000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff1d7224ULL, 0x000fe200078e00ffULL, 0x0000f6a804047890ULL, 0x002fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6a800055c7f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000200014147f8cULL, 0x000ee2000c80043fULL,
0x000000ffff1c7224ULL, 0x000fe200078e00ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x000076e000008947ULL, 0x000fea0003800000ULL,
0xff317217ff5b7424ULL, 0x000fe400078e00ffULL, 0x000000ffff0a7224ULL, 0x000fc400078e00ffULL,
0x000000ffff127224ULL, 0x000fe400078e00ffULL, 0x000000ffff1b7224ULL, 0x000fc400078e00ffULL,
0x000001000a0b7824ULL, 0x000fca00078e00ffULL, 0x000000400b00720cULL, 0x000fda0003f06070ULL,
0x0000763000000947ULL, 0x006fea0003800000ULL, 0x000000ffff0b7224ULL, 0x000fc400078e0012ULL,
0x0000000000107805ULL, 0x000fca0000015200ULL, 0x0000f6c8020c7811ULL, 0x000fca00078e18ffULL,
0x000004000c147984ULL, 0x008ee40000000800ULL, 0x8000000014ff7812ULL, 0x008fe40007804815ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x0000020000007945ULL, 0x000fe20003800000ULL,
0x000000ffff387224ULL, 0x000fe200078e00ffULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000103800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x0000001610147210ULL, 0x000fca0007f1e1ffULL, 0x0000000117167824ULL, 0x000fe200000e0e11ULL,
0x003d09001400780cULL, 0x000fc80003f06070ULL, 0x000000ff1600720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401400780cULL, 0x000fc80003f06070ULL,
0x000000ff1600720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff137819ULL, 0x000fc80000011416ULL, 0x0000001413137211ULL, 0x000fca00078110ffULL,
0x000000ffff147224ULL, 0x000fca00000e0616ULL, 0x0000000213137819ULL, 0x000fc80000001214ULL,
0x000000130000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000138387810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x000004000c147984ULL, 0x000ee40000000800ULL, 0x8000000014ff7812ULL, 0x008fe40007804815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000010a107810ULL, 0x040fe20007ffe0ffULL, 0x000001000a457824ULL, 0x000fe200078e0203ULL,
0x0000000112477812ULL, 0x000fe400078e0cffULL, 0x0000000f1000720cULL, 0x000fe40003f06070ULL,
0x0000004045117810ULL, 0x000fca0007ffe0ffULL, 0x00006200043a7a24ULL, 0x000fcc00078e0211ULL,
0x000003e000008947ULL, 0x000fea0003800000ULL, 0x0000001140107217ULL, 0x000fe20007800000ULL,
0x000000100e177824ULL, 0x000fe200078e00ffULL, 0x00000003ff167819ULL, 0x000fe20000011600ULL,
0x0000001000147824ULL, 0x000fe400078e00ffULL, 0x0000000110107824ULL, 0x000fe200078e0a11ULL,
0x00000004163e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000117137824ULL, 0x040fe200078e0216ULL,
0x00000070143d7812ULL, 0x000fe200078ec0ffULL, 0x00000080ff3c7424ULL, 0x000fe200078e00ffULL,
0x0000001017107217ULL, 0x000fe20007800000ULL, 0x0000000113157824ULL, 0x040fe200078e0200ULL,
0x0000000c16427810ULL, 0x000fe20007ffe0ffULL, 0x0000000813387824ULL, 0x000fc400078e00ffULL,
0x0000000113117824ULL, 0x000fe400078e023aULL, 0x0000000110137824ULL, 0x000fe200078e0a17ULL,
0xfffffff838397812ULL, 0x000fe200078ee215ULL, 0x0000000117157824ULL, 0x000fe400078e023eULL,
0x00005e0011107625ULL, 0x000fe200078e003cULL, 0x000000133e00720cULL, 0x080fe40003f06070ULL,
0x000000131600720cULL, 0x000fe20003fa6070ULL, 0x00000001153b7824ULL, 0x040fe200078e0200ULL,
0x0000003d10147210ULL, 0x000fe20007fde0ffULL, 0x00000008153e7824ULL, 0x000fc400078e00ffULL,
0x0000000202387824ULL, 0x000fe400078e0247ULL, 0x0000000115107824ULL, 0x000fe200078e023aULL,
0xfffffff83e3b7812ULL, 0x000fe200078ee23bULL, 0x000000ffff157224ULL, 0x000fe200030e0611ULL,
0x00000008163e7810ULL, 0x000fe20007ffe0ffULL, 0x00005e0010107625ULL, 0x000fe200078e003cULL,
0x0000b00038387811ULL, 0x000fc600078e60ffULL, 0x00000001173f7824ULL, 0x000fe200078e023eULL,
0x0000003d10167210ULL, 0x000fe20007fde0ffULL, 0x0000001039397824ULL, 0x000fe400078e0238ULL,
0x000000013f107824ULL, 0x000fe400078e023aULL, 0x0000000117437824ULL, 0x000fe200078e0242ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014397faeULL, 0x0007e2000e901c46ULL,
0x000000ffff177224ULL, 0x000fe200030e0611ULL, 0x000000133e00720cULL, 0x080fe20003fa6070ULL,
0x000000103b3b7824ULL, 0x000fe200078e0238ULL, 0x000000134200720cULL, 0x000fe20003fc6070ULL,
0x00005e0010107625ULL, 0x000fc600078e003cULL, 0x00000000163b7faeULL, 0x0009e2000c101c46ULL,
0x0000000143137824ULL, 0x000fe200078e023aULL, 0x0000003d10107210ULL, 0x000fe20007f1e0ffULL,
0x000000083f3e7824ULL, 0x040fe400078e00ffULL, 0x000000013f397824ULL, 0x108fe400078e0200ULL,
0x00000001433a7824ULL, 0x000fe400078e0200ULL, 0x00005e0013147625ULL, 0x000fe200078e003cULL,
0xfffffff83e137812ULL, 0x000fc600078ee239ULL, 0x0000000843437824ULL, 0x000fe400078e00ffULL,
0x000000ffff117224ULL, 0x000fe200000e0611ULL, 0x0000003d14147210ULL, 0x000fe20007f1e0ffULL,
0x0000001013137824ULL, 0x000fe200078e0238ULL, 0xfffffff843397812ULL, 0x000fc600078ee23aULL,
0x000000ffff157224ULL, 0x000fe200000e0615ULL, 0x0000000010137faeULL, 0x0007e2000e901c46ULL,
0x0000001039177824ULL, 0x010fca00078e0238ULL, 0x0000000014177faeULL, 0x0007e2000f101c46ULL,
0x0000031000007947ULL, 0x000fea0003800000ULL, 0x000000100e117824ULL, 0x000fe400078e00ffULL,
0x0000001000137824ULL, 0x040fe400078e00ffULL, 0x00000080ff397424ULL, 0x000fe200078e00ffULL,
0x0000001100117211ULL, 0x000fe400078fe8ffULL, 0x00000070133d7812ULL, 0x000fe200078ec0ffULL,
0x0000000202137824ULL, 0x000fe200078e0247ULL, 0x0000000411157810ULL, 0x040fe20007ffe0ffULL,
0x0000000111107824ULL, 0x140fe200078e0200ULL, 0x0000000811177810ULL, 0x040fe20007ffe0ffULL,
0x00000008113b7824ULL, 0x040fe200078e00ffULL, 0x0000000c11437810ULL, 0x000fe20007ffe0ffULL,
0x0000000115147824ULL, 0x000fc400078e0200ULL, 0x00000008153f7824ULL, 0x000fe200078e00ffULL,
0xfffffff83b3b7812ULL, 0x000fe200078ee210ULL, 0x0000000111107824ULL, 0x100fe400078e023aULL,
0x0000000117167824ULL, 0x000fe200078e023aULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee214ULL,
0x0000000115147824ULL, 0x100fe400078e023aULL, 0x0000000143387824ULL, 0x000fe400078e023aULL,
0x00005e0010107625ULL, 0x000fc800078e0039ULL, 0x0000000117157824ULL, 0x140fe200078e0200ULL,
0x0000003d10107210ULL, 0x000fe20007f1e0ffULL, 0x00000008173a7824ULL, 0x000fe400078e00ffULL,
0x0000000143177824ULL, 0x040fe400078e0200ULL, 0x00000008433c7824ULL, 0x000fe200078e00ffULL,
0xfffffff83a437812ULL, 0x000fe200078ee215ULL, 0x00005e0014147625ULL, 0x080fe200078e0039ULL,
0x0000b000133a7811ULL, 0x000fe400078e60ffULL, 0xfffffff83c497812ULL, 0x000fe200078ee217ULL,
0x00005e0016167625ULL, 0x000fc800078e0039ULL, 0x00005e0038387625ULL, 0x000fe200078e0039ULL,
0x0000003d16167210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff117224ULL, 0x000fe200000e0611ULL,
0x0000003d14147210ULL, 0x080fe20007f1e0ffULL, 0x000000103b137824ULL, 0x100fe200078e023aULL,
0x0000003d38387210ULL, 0x000fe20007fde0ffULL, 0x000000103f3b7824ULL, 0x100fe400078e023aULL,
0x000000ffff157224ULL, 0x000fe200000e0615ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010137faeULL, 0x0007e2000b901c46ULL, 0x00000010433d7824ULL, 0x100fe400078e023aULL,
0x000000ffff177224ULL, 0x000fe200028e0617ULL, 0x00000000143b7faeULL, 0x0007e2000b901c46ULL,
0x00000010493f7824ULL, 0x000fc400078e023aULL, 0x000000ffff397224ULL, 0x000fe200030e0639ULL,
0x00000000163d7faeULL, 0x0007e8000b901c46ULL, 0x00000000383f7faeULL, 0x0007e4000b901c46ULL,
0xfffffff00d107812ULL, 0x048fe200078ec0ffULL, 0x0000011000007945ULL, 0x000fe20003800000ULL,
0xffffffe00d137812ULL, 0x000fe400078ec0ffULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x0000000847567824ULL, 0x000fe200078e0210ULL, 0x000000100d107812ULL, 0x000fc800078ec0ffULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000113117824ULL, 0x000fe200078e0210ULL,
0x0000f6a856557810ULL, 0x000fc60007ffe0ffULL, 0x000000080e117824ULL, 0x000fc400078e0211ULL,
0x00000000550403c2ULL, 0x000ee40000060000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff00b9b0ULL, 0x008fe20008000a04ULL,
0x000000000000081cULL, 0x000fe20001f0f070ULL, 0xffffff8000003947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6a80056567f8cULL, 0x000ee2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6080011167f8cULL, 0x0002e4000c80043fULL,
0x0000000000107805ULL, 0x002fc40000015200ULL, 0x0000001005147812ULL, 0x000fca00078ec0ffULL,
0x0000000113137824ULL, 0x000fc800078e0214ULL, 0x000000080e137824ULL, 0x000fca00078e0213ULL,
0x00f60c0013157984ULL, 0x000e640000000800ULL, 0x8000000015ff7812ULL, 0x00afe40007804817ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff387224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001410397210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e11ULL, 0x003d09003900780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403900780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000003914147211ULL, 0x000fca00078110ffULL, 0x000000ffff157224ULL, 0x000fca00000e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000138387810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f60c0013157984ULL, 0x000e640000000800ULL,
0x8000000015ff7812ULL, 0x002fe40007804817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001000107824ULL, 0x000fe200078e00ffULL, 0x00000001ff4a7819ULL, 0x000fe20000011600ULL,
0x00000020414b7824ULL, 0x000fe400078e00ffULL, 0xffffffffff467424ULL, 0x000fe200078e00ffULL,
0x0000007010387812ULL, 0x000fc400078ec0ffULL, 0xffffff804b4b7812ULL, 0x000fe400078ec0ffULL,
0x0000000c4a4a7812ULL, 0x000fc800078ec0ffULL, 0x0000004b4a107210ULL, 0x000fca0007ffe038ULL,
0x00f0000010147984ULL, 0x000e680000000800ULL, 0x00f2000010137984ULL, 0x0006a20000000800ULL,
0x0000005b1400720bULL, 0x002fe20003f1d000ULL, 0x0000b4c27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000107806ULL, 0x008fc800000e0100ULL, 0x0000ffff103a7812ULL, 0x000fe2000780c0ffULL,
0x000004a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff4d7424ULL, 0x000fe400078e00ffULL,
0x000000ffff4c7224ULL, 0x000fc400078e005bULL, 0x0000001fff497424ULL, 0x000fe400078e00ffULL,
0xffffffffff447424ULL, 0x000fca00078e00ffULL, 0x0000044000008947ULL, 0x000fea0003800000ULL,
0x00000002ff107819ULL, 0x000fe40000011641ULL, 0x0000005b1400720bULL, 0x000fe40003f14000ULL,
0x000000411000720cULL, 0x000fe20003fa5270ULL, 0x0000b4527f007947ULL, 0x000fd4000b800000ULL,
0x0000000000157806ULL, 0x000fc400000e0100ULL, 0x000000804111d824ULL, 0x000fe200078e0238ULL,
0x000000145b4c7209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x0000991015107816ULL, 0x000fe200000000ffULL, 0x000000014a11d824ULL, 0x000fc600078e0211ULL,
0x000000ff1000720cULL, 0x000fe40003f05270ULL, 0x00f4004c1100d388ULL, 0x0003f60000000800ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x8000004c5b107221ULL, 0x002fe20000010000ULL,
0x000000ff15ff7812ULL, 0x000fe2000780c0ffULL, 0x0000017000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL, 0x0000001000397308ULL, 0x0002ec0000000800ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff107819ULL, 0x002fe20000011600ULL,
0x0000b3927f007947ULL, 0x000fea000b800000ULL, 0x00001f1039107589ULL, 0x0082e400000e0000ULL,
0x0000001024247220ULL, 0x088fe20000410000ULL, 0x0000001025257220ULL, 0x080fe20000410000ULL,
0x0000001034347220ULL, 0x080fe20000410000ULL, 0x0000001035357220ULL, 0x080fe20000410000ULL,
0x0000001030307220ULL, 0x080fe20000410000ULL, 0x0000001031317220ULL, 0x080fe20000410000ULL,
0x0000001020207220ULL, 0x080fe20000410000ULL, 0x0000001021217220ULL, 0x080fe20000410000ULL,
0x000000101c1c7220ULL, 0x080fe20000410000ULL, 0x000000101d1d7220ULL, 0x080fe20000410000ULL,
0x000000102c2c7220ULL, 0x080fe20000410000ULL, 0x000000102d2d7220ULL, 0x080fe20000410000ULL,
0x0000001028287220ULL, 0x080fe20000410000ULL, 0x0000001029297220ULL, 0x080fe20000410000ULL,
0x0000001018187220ULL, 0x080fe20000410000ULL, 0x0000001019197220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0015ff7812ULL, 0x000fe2000780c0ffULL,
0x0000003906067220ULL, 0x008fd80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000800107811ULL, 0x002fe200078ff0ffULL, 0x0000b2727f007947ULL, 0x000fea000b800000ULL,
0x00001f1039107589ULL, 0x0002e400000e0000ULL, 0x0000001026267220ULL, 0x088fe20000410000ULL,
0x0000001027277220ULL, 0x080fe20000410000ULL, 0x0000001036367220ULL, 0x080fe20000410000ULL,
0x0000001037377220ULL, 0x080fe20000410000ULL, 0x0000001032327220ULL, 0x080fe20000410000ULL,
0x0000001033337220ULL, 0x080fe20000410000ULL, 0x0000001022227220ULL, 0x080fe20000410000ULL,
0x0000001023237220ULL, 0x080fe20000410000ULL, 0x000000101e1e7220ULL, 0x080fe20000410000ULL,
0x000000101f1f7220ULL, 0x080fe20000410000ULL, 0x000000102e2e7220ULL, 0x080fe20000410000ULL,
0x000000102f2f7220ULL, 0x080fe20000410000ULL, 0x000000102a2a7220ULL, 0x080fe20000410000ULL,
0x000000102b2b7220ULL, 0x080fe20000410000ULL, 0x000000101a1a7220ULL, 0x080fe20000410000ULL,
0x000000101b1b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff3aff7812ULL, 0x000fda0007806015ULL, 0x8000004c14140221ULL, 0x000fe20000010000ULL,
0x00007610ff4d0816ULL, 0x000fc6000000004dULL, 0x3fb8aa3b14140820ULL, 0x000fc80000410000ULL,
0x0000001400070308ULL, 0x000e640000000800ULL, 0x0000000713130220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000613067221ULL, 0x004fc20000010000ULL,
0x0000000000107805ULL, 0x000fcc0000015200ULL, 0x0000000812177824ULL, 0x000fca00078e0205ULL,
0x00f6ac0017147984ULL, 0x000e640000000800ULL, 0x8000000014ff7812ULL, 0x002fe4000780485dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff167224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001410147210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e11ULL, 0x003d09001400780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401400780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff137819ULL, 0x000fc80000011415ULL,
0x0000001413137211ULL, 0x000fca00078110ffULL, 0x000000ffff147224ULL, 0x000fca00000e0615ULL,
0x0000000213137819ULL, 0x000fc80000001214ULL, 0x000000130000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000116167810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6ac0017147984ULL, 0x000e640000000800ULL,
0x8000000014ff7812ULL, 0x002fe4000780485dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099104d107816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff1000720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000007ff08723eULL, 0x000fe400000000ffULL, 0x00000002ff147819ULL, 0x000fe40000011600ULL,
0x0000541008137816ULL, 0x000fe20000000008ULL, 0x0000ae627f007947ULL, 0x000fea000b800000ULL,
0x00001f1413097589ULL, 0x0002a400000e0000ULL, 0x0000000814087810ULL, 0x000fe20007ffe0ffULL,
0x0000ae927f007947ULL, 0x000fea000b800000ULL, 0x00001f0813087589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001014107810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff177224ULL, 0x000fe200078e0013ULL, 0x000026d000387802ULL, 0x000fc40000000f00ULL,
0x0000b8e000007944ULL, 0x00efea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001814107810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff177224ULL, 0x004fe200078e0013ULL,
0x0000272000387802ULL, 0x000fc40000000f00ULL, 0x0000b89000007944ULL, 0x00afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000700117812ULL, 0x000fe200078ec0ffULL,
0x0000020041107824ULL, 0x000fe200078e00ffULL, 0x00000004ff597819ULL, 0x100fe20000011600ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000008113c7812ULL, 0x000fc400078ef800ULL,
0xfffff80010427812ULL, 0x000fe200078ec0ffULL, 0x0000000402117824ULL, 0x000fe400078e0259ULL,
0x000000083c147824ULL, 0x042fe400078e00ffULL, 0x000000013c3d7824ULL, 0x000fe200078e0211ULL,
0x0000000800117812ULL, 0x000fc800078ec0ffULL, 0xfffffff814437812ULL, 0x000fca00078ee23dULL,
0x0000001043437824ULL, 0x000fc600078e0242ULL, 0x00000007115a7812ULL, 0x000fe200078ef800ULL,
0x000000040e597824ULL, 0x000fe200078e0259ULL, 0x009000004314783bULL, 0x004e620000000200ULL,
0x0000000202487824ULL, 0x000fe200078e0212ULL, 0x000000023d3d7810ULL, 0x000fe20007ffe0ffULL,
0x000000015a387824ULL, 0x040fe400078e0259ULL, 0x000000085a117824ULL, 0x000fe200078e00ffULL,
0x0000b00048487811ULL, 0x000fe200078e60ffULL, 0x000000085a3a7824ULL, 0x000fe200078e00ffULL,
0x0000000238517810ULL, 0x000fe20007ffe0ffULL, 0x000000083c3c7824ULL, 0x000fe200078e00ffULL,
0xfffffff811117812ULL, 0x000fc400078ee238ULL, 0xfffffff83a517812ULL, 0x000fe400078ee251ULL,
0xfffffff83c3d7812ULL, 0x000fe200078ee23dULL, 0x0000001011117824ULL, 0x100fe400078e0248ULL,
0x0000001051387824ULL, 0x000fe400078e0248ULL, 0x000000103d427824ULL, 0x000fe400078e0242ULL,
0x000000001110783bULL, 0x008ea80000004200ULL, 0x000000003838783bULL, 0x000ee20000004200ULL,
0x0000000914148232ULL, 0x002fc40000000000ULL, 0x0000000916168232ULL, 0x000fe40000000000ULL,
0x0000000815158232ULL, 0x080fe40000000000ULL, 0x0000000817178232ULL, 0x000fe20000000000ULL,
0x00003120114e7816ULL, 0x004fe400000000ffULL, 0x0000312010107816ULL, 0x000fe400000000ffULL,
0x0000004eff3f723eULL, 0x080fe400020006ffULL, 0x0000004eff11723eULL, 0x000fc400030006ffULL,
0x000000105a4e7812ULL, 0x000fe400078efcffULL, 0x0000312038507816ULL, 0x008fe400000000ffULL,
0x0000312039527816ULL, 0x000fe200000000ffULL, 0x0000000159537824ULL, 0x000fe200078e024eULL,
0x00000010ff3e723eULL, 0x000fe200020006ffULL, 0x000000084e3c7824ULL, 0x040fe200078e00ffULL,
0x00000050ff38723eULL, 0x000fe200020006ffULL, 0x000000084e4e7824ULL, 0x000fe200078e00ffULL,
0x00000052ff39723eULL, 0x000fc400020006ffULL, 0x00000010ff10723eULL, 0x000fe200030006ffULL,
0x0000003e1424723cULL, 0x040b620000001824ULL, 0x0000312012127816ULL, 0x000fe400000000ffULL,
0x0000312013137816ULL, 0x000fe400000000ffULL, 0xfffffff83c4f7812ULL, 0x000fe400078ee253ULL,
0x00000012ff3c723eULL, 0x000fe200030006ffULL, 0x00000038141c723cULL, 0x000be2000000181cULL,
0x00000013ff3d723eULL, 0x000fe200030006ffULL, 0x000000104f3e7824ULL, 0x020fe200078e0248ULL,
0x000031203a3a7816ULL, 0x000fc400000000ffULL, 0x000031203b3b7816ULL, 0x000fe400000000ffULL,
0x00000050ff38723eULL, 0x000fe200030006ffULL, 0x000000101434723cULL, 0x040b620000001834ULL,
0x00000052ff39723eULL, 0x000fe400030006ffULL, 0x000099104d507816ULL, 0x000fe400000000ffULL,
0x00000002534d7810ULL, 0x000fe40007ffe0ffULL, 0x00000012ff10723eULL, 0x020fe200020006ffULL,
0x0000003c1420723cULL, 0x000be20000001820ULL, 0x00000013ff11723eULL, 0x000fe200020006ffULL,
0x000000003e3c783bULL, 0x020e620000004200ULL, 0xfffffff84e4d7812ULL, 0x000fc400078ee24dULL,
0x0000003aff52723eULL, 0x000fe400030006ffULL, 0x0000003bff53723eULL, 0x000fe200030006ffULL,
0x00000038142c723cULL, 0x000be2000000182cULL, 0x000000ff5000720cULL, 0x000fcc0003f05270ULL,
0x0000003aff38723eULL, 0x020fe200020006ffULL, 0x000000101430723cULL, 0x040b620000001830ULL,
0x0000003bff39723eULL, 0x000fe200020006ffULL, 0x009000004210783bULL, 0x020eac0000000200ULL,
0x000000381428723cULL, 0x040b6e0000001828ULL, 0x000000104d387824ULL, 0x020fe200078e0248ULL,
0x000000521418723cULL, 0x000b620000001818ULL, 0x0000000241487824ULL, 0x000fc800078e00ffULL,
0x000000003838783bULL, 0x000ee20000004200ULL, 0x000031203c3c7816ULL, 0x002fe400000000ffULL,
0x000031203d3d7816ULL, 0x000fe400000000ffULL, 0x0000003cff14723eULL, 0x020fe400020006ffULL,
0x0000003dff15723eULL, 0x000fe400020006ffULL, 0x000031203e3e7816ULL, 0x000fe400000000ffULL,
0x000031203f3f7816ULL, 0x000fc400000000ffULL, 0x0000003cff3c723eULL, 0x000fe400030006ffULL,
0x0000003dff3d723eULL, 0x000fe200030006ffULL, 0x0000000910108232ULL, 0x084fe40000000000ULL,
0x0000000912128232ULL, 0x000fe40000000000ULL, 0x0000000811118232ULL, 0x080fe40000000000ULL,
0x0000000813138232ULL, 0x000fce0000000000ULL, 0x000000141024723cULL, 0x000b620000001824ULL,
0x0000312038387816ULL, 0x008fcc00000000ffULL, 0x0000003eff14723eULL, 0x0a0fe200020006ffULL,
0x0000003c1034723cULL, 0x040f620000001834ULL, 0x0000003fff15723eULL, 0x000fe400020006ffULL,
0x0000312039397816ULL, 0x000fe400000000ffULL, 0x000031203a3a7816ULL, 0x000fe400000000ffULL,
0x000031203b3b7816ULL, 0x000fe200000000ffULL, 0x000000141030723cULL, 0x000b620000001830ULL,
0x0000003eff3e723eULL, 0x000fc400030006ffULL, 0x0000003fff3f723eULL, 0x000fc800030006ffULL,
0x00000038ff14723eULL, 0x0a0fe400020006ffULL, 0x00000039ff15723eULL, 0x080fe200020006ffULL,
0x0000003e1020723cULL, 0x000f620000001820ULL, 0x00000038ff38723eULL, 0x000fe400030006ffULL,
0x00000039ff39723eULL, 0x000fca00030006ffULL, 0x00000014101c723cULL, 0x040b6e000000181cULL,
0x0000003aff14723eULL, 0x0a0fe200020006ffULL, 0x00000038102c723cULL, 0x000b62000000182cULL,
0x0000003bff15723eULL, 0x000fe400020006ffULL, 0x0000003aff3a723eULL, 0x000fc400030006ffULL,
0x0000003bff3b723eULL, 0x000fc600030006ffULL, 0x000000141028723cULL, 0x040b700000001828ULL,
0x0000003a1018723cULL, 0x000b620000001818ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x000000000c147f8cULL, 0x0202a2000c80043fULL, 0xfffffff848487812ULL, 0x000fe200078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000400a117811ULL, 0x000fe200078e40ffULL,
0x00f6880048ff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff5b7224ULL, 0x000fc400078e004cULL,
0x000000401100720cULL, 0x000fe20003f06070ULL, 0x000000ffff5d7224ULL, 0x000fe400078e0057ULL,
0x000000ffff127224ULL, 0x000fd400078e0047ULL, 0x0000566000000947ULL, 0x000fea0003800000ULL,
0x0000000000107805ULL, 0x008fc40000015200ULL, 0x000004000c127984ULL, 0x000ee40000000800ULL,
0x8000000012ff7812ULL, 0x00cfe40007804815ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff147224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x0000001210177210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e11ULL,
0x003d09001700780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401700780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff127819ULL, 0x000fc80000011413ULL, 0x0000001712127211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0613ULL, 0x0000000212127819ULL, 0x000fc80000001213ULL,
0x000000120000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000114147810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004000c127984ULL, 0x000ea40000000800ULL, 0x8000000012ff7812ULL, 0x004fe40007804815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000010a107810ULL, 0x000fe40007ffe0ffULL,
0x0000008045117810ULL, 0x000fe40007ffe0ffULL, 0x0000000f1000720cULL, 0x000fc60003f06070ULL,
0x0000620004137a24ULL, 0x000fd400078e0211ULL, 0x0000040000008947ULL, 0x000fea0003800000ULL,
0x0000001140107217ULL, 0x000fe20007800000ULL, 0x000000100e3a7824ULL, 0x000fe200078e00ffULL,
0x00000003ff397819ULL, 0x000fe20000011600ULL, 0x00000080ff3b7424ULL, 0x000fe400078e00ffULL,
0x0000000110117824ULL, 0x000fe200078e0a11ULL, 0x00000004393d7810ULL, 0x000fe20007ffe0ffULL,
0x000010000b107824ULL, 0x000fe200078e00ffULL, 0x00000008393f7810ULL, 0x000fe20007ffe0ffULL,
0x000000013a147824ULL, 0x040fe200078e0239ULL, 0x000000113a117217ULL, 0x000fc40007800000ULL,
0x0000100010157812ULL, 0x000fe200078ec0ffULL, 0x0000000114127824ULL, 0x040fe200078e0200ULL,
0x0000000c39537810ULL, 0x000fe20007ffe0ffULL, 0x0000000814177824ULL, 0x000fe400078e00ffULL,
0x0000200002157824ULL, 0x000fe400078e0215ULL, 0x0000000114107824ULL, 0x000fe200078e0213ULL,
0xfffffff817177812ULL, 0x000fe200078ee212ULL, 0x0000001000127824ULL, 0x000fe200078e00ffULL,
0x0000b00015387810ULL, 0x000fe20007ffe0ffULL, 0x000000013a147824ULL, 0x000fc400078e023dULL,
0x0000000111167824ULL, 0x000fe200078e0a3aULL, 0x0000007012127812ULL, 0x000fe200078ec0ffULL,
0x00005e0010107625ULL, 0x000fc600078e003bULL, 0x000000163900720cULL, 0x080fe20003fa6070ULL,
0x0000000114157824ULL, 0x040fe200078e0200ULL, 0x000000163d00720cULL, 0x000fe20003f06070ULL,
0x00000008143c7824ULL, 0x000fe200078e00ffULL, 0x0000001210107210ULL, 0x000fe20007fde0ffULL,
0x0000000114147824ULL, 0x000fe400078e0213ULL, 0x0000001017177824ULL, 0x000fe200078e0238ULL,
0xfffffff83c3d7812ULL, 0x000fe200078ee215ULL, 0x00005e0014147625ULL, 0x000fc800078e003bULL,
0x000000013a3c7824ULL, 0x000fe400078e023fULL, 0x000000ffff117224ULL, 0x000fe200030e0611ULL,
0x0000001214147210ULL, 0x000fe20007fde0ffULL, 0x000000013a3e7824ULL, 0x000fe400078e0253ULL,
0x000000013c3a7824ULL, 0x000fe200078e0213ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010177faeULL, 0x0005e2000e901c46ULL, 0x000000ffff157224ULL, 0x000fe200030e0615ULL,
0x000000163f00720cULL, 0x080fe20003fa6070ULL, 0x000000103d397824ULL, 0x000fe200078e0238ULL,
0x000000165300720cULL, 0x000fe20003fc6070ULL, 0x000000013e167824ULL, 0x000fc400078e0213ULL,
0x000000013c137824ULL, 0x040fe200078e0200ULL, 0x0000000014397faeULL, 0x0007e2000c101c46ULL,
0x000000083c3c7824ULL, 0x000fe400078e00ffULL, 0x00005e003a107625ULL, 0x004fc600078e003bULL,
0xfffffff83c137812ULL, 0x000fe200078ee213ULL, 0x00005e0016167625ULL, 0x000fe200078e003bULL,
0x0000001210107210ULL, 0x000fc60007f1e0ffULL, 0x000000013e3a7824ULL, 0x040fe400078e0200ULL,
0x000000083e3b7824ULL, 0x000fe400078e00ffULL, 0x000000ffff117224ULL, 0x000fe200000e0611ULL,
0x0000001216167210ULL, 0x000fe20007f1e0ffULL, 0x0000001013137824ULL, 0x000fe200078e0238ULL,
0xfffffff83b3b7812ULL, 0x000fc600078ee23aULL, 0x000000ffff177224ULL, 0x000fe200000e0617ULL,
0x0000000010137faeULL, 0x0005e2000e901c46ULL, 0x000000103b157824ULL, 0x008fca00078e0238ULL,
0x0000000016157faeULL, 0x0005e2000f101c46ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x000000100e117824ULL, 0x000fe400078e00ffULL, 0x0000001000127824ULL, 0x040fe400078e00ffULL,
0x00000080ff397424ULL, 0x000fe200078e00ffULL, 0x0000001100117211ULL, 0x000fe400078fe8ffULL,
0x0000007012127812ULL, 0x000fe400078ec0ffULL, 0x0000000411147810ULL, 0x040fe20007ffe0ffULL,
0x0000000111107824ULL, 0x140fe200078e0200ULL, 0x00000008113a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000811157824ULL, 0x040fe200078e00ffULL, 0x0000000c113c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000114167824ULL, 0x000fc400078e0200ULL, 0x00000008143b7824ULL, 0x040fe200078e00ffULL,
0xfffffff815157812ULL, 0x000fe200078ee210ULL, 0x000010000b107824ULL, 0x000fe400078e00ffULL,
0x0000000114147824ULL, 0x100fe200078e0213ULL, 0xfffffff83b3b7812ULL, 0x000fe200078ee216ULL,
0x000000013a167824ULL, 0x100fe200078e0213ULL, 0x0000100010177812ULL, 0x000fe200078ec0ffULL,
0x0000000111107824ULL, 0x100fe400078e0213ULL, 0x000000013c387824ULL, 0x000fc400078e0213ULL,
0x0000200002177824ULL, 0x000fe400078e0217ULL, 0x000000013a137824ULL, 0x040fe400078e0200ULL,
0x000000083a4e7824ULL, 0x000fe200078e00ffULL, 0x0000b000173a7810ULL, 0x000fe20007ffe0ffULL,
0x00005e0010107625ULL, 0x000fc600078e0039ULL, 0xfffffff84e3d7812ULL, 0x000fe200078ee213ULL,
0x0000001015137824ULL, 0x000fe200078e023aULL, 0x0000001210107210ULL, 0x000fe20007f1e0ffULL,
0x00005e0014147625ULL, 0x000fc800078e0039ULL, 0x00005e0016167625ULL, 0x000fc800078e0039ULL,
0x000000013c3e7824ULL, 0x000fe200078e0200ULL, 0x0000001216167210ULL, 0x000fe20007fbe0ffULL,
0x000000083c3f7824ULL, 0x000fe400078e00ffULL, 0x00005e0038387625ULL, 0x000fc600078e0039ULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee23eULL, 0x000000ffff117224ULL, 0x000fe200000e0611ULL,
0x0000001214147210ULL, 0x080fe20007f1e0ffULL, 0x000000103b3b7824ULL, 0x100fe200078e023aULL,
0x0000001238387210ULL, 0x000fe20007fde0ffULL, 0x000000103d3d7824ULL, 0x100fe200078e023aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010137faeULL, 0x0005e2000b901c46ULL,
0x000000ffff157224ULL, 0x000fe400000e0615ULL, 0x000000ffff177224ULL, 0x000fe400028e0617ULL,
0x000000103f3f7824ULL, 0x000fe200078e023aULL, 0x00000000143b7faeULL, 0x0005e2000b901c46ULL,
0x000000ffff397224ULL, 0x000fc600030e0639ULL, 0x00000000163d7faeULL, 0x0005e8000b901c46ULL,
0x00000000383f7faeULL, 0x0005e4000b901c46ULL, 0x000000080b107824ULL, 0x004fe200078e00ffULL,
0xfffffff00d117812ULL, 0x040fe200078ec0ffULL, 0x0000012000007945ULL, 0x000fe20003800000ULL,
0xffffffe00d137812ULL, 0x000fe400078ec0ffULL, 0x0000000810107812ULL, 0x000fe400078ec0ffULL,
0x000000000000781cULL, 0x000fc60003f0f070ULL, 0x0000000111547824ULL, 0x000fe200078e0210ULL,
0x000000100d107812ULL, 0x000fc800078ec0ffULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000113117824ULL, 0x000fe200078e0210ULL, 0x0000f6a854537810ULL, 0x000fc60007ffe0ffULL,
0x000000080e117824ULL, 0x000fc400078e0211ULL, 0x00000000530403c2ULL, 0x000ea40000040000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff00a9b0ULL, 0x004fe20008000a04ULL, 0x000000000000081cULL, 0x000fe2000170f070ULL,
0xffffff8000002947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a800545c7f8cULL, 0x0004e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6280011107f8cULL, 0x000e64000c80043fULL, 0x0000000000147805ULL, 0x000fc40000015200ULL,
0x0000001005167812ULL, 0x000fca00078ec0ffULL, 0x0000000113137824ULL, 0x000fc800078e0216ULL,
0x000000080e387824ULL, 0x000fca00078e0213ULL, 0x00f62c0038137984ULL, 0x000f240000000800ULL,
0x8000000013ff7812ULL, 0x012fe40007804811ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff397224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103900780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x0000001614167210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09001600780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401600780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff137819ULL, 0x000fc80000011417ULL, 0x0000001613137211ULL, 0x000fca00078110ffULL,
0x000000ffff167224ULL, 0x000fca00000e0617ULL, 0x0000000213137819ULL, 0x000fc80000001216ULL,
0x000000130000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000139397810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f62c0038137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000008012117810ULL, 0x000fca0007ffe04bULL,
0x000000014a117824ULL, 0x000fca00078e0211ULL, 0x00f0000011137984ULL, 0x000e680000000800ULL,
0x00f2000011147984ULL, 0x0004e20000000800ULL, 0x0000004c1300720bULL, 0x002fe20003f1d000ULL,
0x000097527f007947ULL, 0x000fd8000b800000ULL, 0x0000000000157806ULL, 0x004fc800000e0100ULL,
0x0000ffff15ff7812ULL, 0x000fe2000780c0ffULL, 0x000004b000007945ULL, 0x000fe20003800000ULL,
0x00000001ff167424ULL, 0x000fe400078e00ffULL, 0x000000ffff5b7224ULL, 0x000fd200078e004cULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x0000000141107811ULL, 0x000fe400078ff0ffULL,
0x0000004c1300720bULL, 0x000fe40003f14000ULL, 0x000000411000720cULL, 0x000fe20003fa5270ULL,
0x000097027f007947ULL, 0x000fd4000b800000ULL, 0x0000000000167806ULL, 0x000fc400000e0100ULL,
0x000000804111d824ULL, 0x000fe200078e0212ULL, 0x0000004c1310d209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe40003800000ULL, 0x000000014a17d824ULL, 0x000fe200078e0211ULL,
0x0000991016117816ULL, 0x000fc800000000ffULL, 0x00f400101700d388ULL, 0x0003e20000000800ULL,
0x000000ff1100720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000004c13117209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff16ff7812ULL, 0x000fc6000780c0ffULL, 0x0000004c11107221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL, 0x0000001000397308ULL, 0x000e640000000800ULL,
0x0000003906067220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff107819ULL, 0x000fe20000011600ULL, 0x000096127f007947ULL, 0x000fea000b800000ULL,
0x00001f1039107589ULL, 0x0002a400000e0000ULL, 0x0000001024247220ULL, 0x084fe20000410000ULL,
0x0000001025257220ULL, 0x080fe20000410000ULL, 0x0000001034347220ULL, 0x080fe20000410000ULL,
0x0000001035357220ULL, 0x080fe20000410000ULL, 0x0000001030307220ULL, 0x080fe20000410000ULL,
0x0000001031317220ULL, 0x080fe20000410000ULL, 0x0000001020207220ULL, 0x080fe20000410000ULL,
0x0000001021217220ULL, 0x080fe20000410000ULL, 0x000000101c1c7220ULL, 0x080fe20000410000ULL,
0x000000101d1d7220ULL, 0x080fe20000410000ULL, 0x000000102c2c7220ULL, 0x080fe20000410000ULL,
0x000000102d2d7220ULL, 0x080fe20000410000ULL, 0x0000001028287220ULL, 0x080fe20000410000ULL,
0x0000001029297220ULL, 0x080fe20000410000ULL, 0x0000001018187220ULL, 0x080fe20000410000ULL,
0x0000001019197220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0016ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000800107811ULL, 0x000fe200078ff0ffULL, 0x000095027f007947ULL, 0x000fea000b800000ULL,
0x00001f1039107589ULL, 0x00046400000e0000ULL, 0x0000001026267220ULL, 0x082fe20000410000ULL,
0x0000001027277220ULL, 0x080fe20000410000ULL, 0x0000001036367220ULL, 0x080fe20000410000ULL,
0x0000001037377220ULL, 0x080fe20000410000ULL, 0x0000001032327220ULL, 0x080fe20000410000ULL,
0x0000001033337220ULL, 0x080fe20000410000ULL, 0x0000001022227220ULL, 0x080fe20000410000ULL,
0x0000001023237220ULL, 0x080fe20000410000ULL, 0x000000101e1e7220ULL, 0x080fe20000410000ULL,
0x000000101f1f7220ULL, 0x080fe20000410000ULL, 0x000000102e2e7220ULL, 0x080fe20000410000ULL,
0x000000102f2f7220ULL, 0x080fe20000410000ULL, 0x000000102a2a7220ULL, 0x080fe20000410000ULL,
0x000000102b2b7220ULL, 0x080fe20000410000ULL, 0x000000101a1a7220ULL, 0x080fe20000410000ULL,
0x000000101b1b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff16ff7812ULL, 0x000fe20007800815ULL, 0x00000001ff167424ULL, 0x000fe200078e00ffULL,
0x0000004c135b7209ULL, 0x000fd60007810000ULL, 0x8000005b13130221ULL, 0x000fe20000010000ULL,
0x00007610ff160816ULL, 0x000fc60000000016ULL, 0x3fb8aa3b13130820ULL, 0x000fc80000410000ULL,
0x0000001300070308ULL, 0x000e640000000800ULL, 0x0000000714140220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000614067221ULL, 0x008fc20000010000ULL,
0x0000000000107805ULL, 0x000fcc0000015200ULL, 0x0000000847587824ULL, 0x000fc800078e00ffULL,
0x0000000105127824ULL, 0x000fca00078e0258ULL, 0x00f6ac0012137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe40007804857ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x0000021000007945ULL, 0x000fe20003800000ULL, 0x000000ffff147224ULL, 0x000fe200078e00ffULL,
0x000001e000000947ULL, 0x000fea0003800000ULL, 0x000001d000017945ULL, 0x000fe20003800000ULL,
0x0000000105177824ULL, 0x000fc400078e0258ULL, 0x000000101400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x0000001210157210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e11ULL,
0x003d09001500780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401500780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff127819ULL, 0x000fc80000011413ULL, 0x0000001512127211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0613ULL, 0x0000000212127819ULL, 0x000fc80000001213ULL,
0x000000120000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000114147810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00f6ac0017137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe40007804857ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991016107816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff1000720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000007ff08723eULL, 0x000fe400000000ffULL, 0x00000002ff137819ULL, 0x000fe40000011600ULL,
0x0000541008127816ULL, 0x000fe20000000008ULL, 0x000090927f007947ULL, 0x000fea000b800000ULL,
0x00001f1312097589ULL, 0x0002e400000e0000ULL, 0x0000000813107810ULL, 0x000fe20007ffe0ffULL,
0x000090c27f007947ULL, 0x000fea000b800000ULL, 0x00001f1012087589ULL, 0x0002a400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001013107810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff177224ULL, 0x000fe200078e0012ULL, 0x0000469000387802ULL, 0x000fc40000000f00ULL,
0x0000992000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001813107810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff177224ULL, 0x004fe200078e0012ULL,
0x000046e000387802ULL, 0x000fc40000000f00ULL, 0x000098d000007944ULL, 0x008fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000015a107824ULL, 0x042fe200078e0259ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000085a117824ULL, 0x000fe200078e00ffULL,
0x009800004314783bULL, 0x004e620000000200ULL, 0x00000002025c7824ULL, 0x000fc600078e0247ULL,
0xfffffff811117812ULL, 0x000fe400078ee210ULL, 0x0000b0005c5c7811ULL, 0x000fca00078e60ffULL,
0x0000001011527824ULL, 0x100fe400078e025cULL, 0x0000001051507824ULL, 0x100fe400078e025cULL,
0x000000104f4e7824ULL, 0x000fe200078e025cULL, 0x000000005210783bULL, 0x000ea80000004200ULL,
0x00000000503c783bULL, 0x000f220000004200ULL, 0x0000000914148232ULL, 0x00afc40000000000ULL,
0x0000000916168232ULL, 0x000fe40000000000ULL, 0x0000000815158232ULL, 0x080fe40000000000ULL,
0x0000000817178232ULL, 0x000fe20000000000ULL, 0x0000312010107816ULL, 0x004fe400000000ffULL,
0x0000312011117816ULL, 0x000fe400000000ffULL, 0x00000010ff38723eULL, 0x000fe400020006ffULL,
0x00000011ff39723eULL, 0x000fc400020006ffULL, 0x00000010ff10723eULL, 0x000fe400030006ffULL,
0x00000011ff11723eULL, 0x000fe400030006ffULL, 0x0000312012127816ULL, 0x000fe200000000ffULL,
0x000000381424723cULL, 0x000b620000001824ULL, 0x0000312013137816ULL, 0x000fe200000000ffULL,
0x000000004e38783bULL, 0x020e620000004200ULL, 0x00000012ff56723eULL, 0x000fe400030006ffULL,
0x00000013ff57723eULL, 0x000fc400030006ffULL, 0x000031203c4c7816ULL, 0x010fe200000000ffULL,
0x000000101434723cULL, 0x040b620000001834ULL, 0x000031203d5e7816ULL, 0x000fe400000000ffULL,
0x0000004cff3c723eULL, 0x000fe400020006ffULL, 0x0000005eff3d723eULL, 0x000fe400020006ffULL,
0x00000012ff10723eULL, 0x020fe200020006ffULL, 0x000000561420723cULL, 0x000be20000001820ULL,
0x00000013ff11723eULL, 0x000fc400020006ffULL, 0x000031203e3e7816ULL, 0x000fe400000000ffULL,
0x000031203f3f7816ULL, 0x000fe400000000ffULL, 0x0000003eff56723eULL, 0x020fe200030006ffULL,
0x000000101430723cULL, 0x040b620000001830ULL, 0x0000003fff57723eULL, 0x000fe200030006ffULL,
0x009800004210783bULL, 0x020eac0000000200ULL, 0x0000003c141c723cULL, 0x040b6e000000181cULL,
0x0000004cff3c723eULL, 0x020fe200030006ffULL, 0x000000104d4c7824ULL, 0x000fe200078e025cULL,
0x0000005eff3d723eULL, 0x000fe200030006ffULL, 0x000000561418723cULL, 0x000fe20000001818ULL,
0x0000312038387816ULL, 0x002fc400000000ffULL, 0x0000312039397816ULL, 0x000fe400000000ffULL,
0x000031203a3a7816ULL, 0x000fe400000000ffULL, 0x000031203b3b7816ULL, 0x000fe200000000ffULL,
0x0000003c142c723cULL, 0x000b6e000000182cULL, 0x0000003eff3c723eULL, 0x020fc400020006ffULL,
0x0000003fff3d723eULL, 0x000fce00020006ffULL, 0x0000003c1428723cULL, 0x000b620000001828ULL,
0x0000000910108232ULL, 0x084fe20000000000ULL, 0x000000004c3c783bULL, 0x020e620000004200ULL,
0x0000000912128232ULL, 0x000fe40000000000ULL, 0x0000000811118232ULL, 0x080fe40000000000ULL,
0x0000000813138232ULL, 0x000fe20000000000ULL, 0x00000038ff14723eULL, 0x000fe400020006ffULL,
0x00000039ff15723eULL, 0x000fce00020006ffULL, 0x000000141024723cULL, 0x000b6e0000001824ULL,
0x00000038ff14723eULL, 0x020fe400030006ffULL, 0x00000039ff15723eULL, 0x000fce00030006ffULL,
0x000000141034723cULL, 0x000b6e0000001834ULL, 0x0000003aff14723eULL, 0x020fe400020006ffULL,
0x0000003bff15723eULL, 0x000fe400020006ffULL, 0x000031203c3c7816ULL, 0x002fc400000000ffULL,
0x000031203d3d7816ULL, 0x000fe400000000ffULL, 0x000031203e3e7816ULL, 0x000fe200000000ffULL,
0x000000141030723cULL, 0x000b620000001830ULL, 0x000031203f3f7816ULL, 0x000fcc00000000ffULL,
0x0000003aff14723eULL, 0x020fe400030006ffULL, 0x0000003bff15723eULL, 0x000fce00030006ffULL,
0x000000141020723cULL, 0x000b6e0000001820ULL, 0x0000003cff14723eULL, 0x020fe400020006ffULL,
0x0000003dff15723eULL, 0x000fce00020006ffULL, 0x00000014101c723cULL, 0x000b6e000000181cULL,
0x0000003cff14723eULL, 0x020fe400030006ffULL, 0x0000003dff15723eULL, 0x000fce00030006ffULL,
0x00000014102c723cULL, 0x000b6e000000182cULL, 0x0000003eff14723eULL, 0x020fe400020006ffULL,
0x0000003fff15723eULL, 0x000fce00020006ffULL, 0x000000141028723cULL, 0x000b6e0000001828ULL,
0x0000003eff14723eULL, 0x020fe400030006ffULL, 0x0000003fff15723eULL, 0x000fce00030006ffULL,
0x000000141018723cULL, 0x000b620000001818ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x000000000c147f8cULL, 0x0202a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000800a117811ULL, 0x000fe200078e40ffULL,
0x00f6900048ff7f8cULL, 0x0007e2000c80043fULL, 0x000000010b127812ULL, 0x000fe400078ec0ffULL,
0x000000401100720cULL, 0x000fda0003f06070ULL, 0x000038a000000947ULL, 0x000fea0003800000ULL,
0x0000000000107805ULL, 0x008fc40000015200ULL, 0x000004000c127984ULL, 0x000ee40000000800ULL,
0x8000000012ff7812ULL, 0x00cfe40007804815ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff147224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x0000001210177210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e11ULL,
0x003d09001700780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401700780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff127819ULL, 0x000fc80000011413ULL, 0x0000001712127211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0613ULL, 0x0000000212127819ULL, 0x000fc80000001213ULL,
0x000000120000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000114147810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004000c127984ULL, 0x000ea40000000800ULL, 0x8000000012ff7812ULL, 0x004fe40007804815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000010a107810ULL, 0x000fe40007ffe0ffULL,
0x000000c045117810ULL, 0x000fe40007ffe0ffULL, 0x0000000f1000720cULL, 0x000fc60003f06070ULL,
0x0000620004167a24ULL, 0x000fd400078e0211ULL, 0x000003c000008947ULL, 0x000fea0003800000ULL,
0x0000001140107217ULL, 0x000fe20007800000ULL, 0x000000100e157824ULL, 0x000fe200078e00ffULL,
0x00000003ff147819ULL, 0x000fe20000011600ULL, 0x0000001000397824ULL, 0x000fe400078e00ffULL,
0x0000000110107824ULL, 0x000fe200078e0a11ULL, 0x00000004143a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000115137824ULL, 0x000fe200078e0214ULL, 0x0000007039397812ULL, 0x000fe200078ec0ffULL,
0x00000080ff387424ULL, 0x000fe200078e00ffULL, 0x0000001015107217ULL, 0x000fe20007800000ULL,
0x0000000113117824ULL, 0x040fe200078e0216ULL, 0x0000000c143c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000113127824ULL, 0x000fc400078e0200ULL, 0x0000000110177824ULL, 0x000fe400078e0a15ULL,
0x00000008133b7824ULL, 0x000fe400078e00ffULL, 0x0000000115137824ULL, 0x000fe200078e023aULL,
0x000000173a00720cULL, 0x080fe20003f06070ULL, 0x00005e0011107625ULL, 0x000fe200078e0038ULL,
0xfffffff83b3b7812ULL, 0x000fe400078ee212ULL, 0x000000171400720cULL, 0x000fe20003fa6070ULL,
0x00000001133a7824ULL, 0x040fe200078e0200ULL, 0x0000003910107210ULL, 0x000fe20007fde0ffULL,
0x00000008133d7824ULL, 0x000fc400078e00ffULL, 0x0000000113127824ULL, 0x000fe400078e0216ULL,
0x000000ffff117224ULL, 0x000fe200030e0611ULL, 0xfffffff83d3d7812ULL, 0x000fe200078ee23aULL,
0x00005e0012127625ULL, 0x000fe200078e0038ULL, 0x00000008143a7810ULL, 0x000fc60007ffe0ffULL,
0x000000103b3b7824ULL, 0x000fe200078e025cULL, 0x0000003912147210ULL, 0x000fe20007fde0ffULL,
0x00000001153f7824ULL, 0x040fe400078e023aULL, 0x0000000115577824ULL, 0x000fe200078e023cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000103b7faeULL, 0x0005e2000e901c46ULL,
0x000000013f127824ULL, 0x000fe200078e0216ULL, 0x000000173a00720cULL, 0x080fe20003fa6070ULL,
0x000000ffff157224ULL, 0x000fe200030e0613ULL, 0x000000173c00720cULL, 0x000fe20003fc6070ULL,
0x000000103d3d7824ULL, 0x000fc400078e025cULL, 0x0000000157137824ULL, 0x000fe400078e0216ULL,
0x000000013f167824ULL, 0x040fe200078e0200ULL, 0x00000000143d7faeULL, 0x0007e2000c101c46ULL,
0x000000083f177824ULL, 0x000fe400078e00ffULL, 0x00005e0012107625ULL, 0x004fc600078e0038ULL,
0xfffffff817177812ULL, 0x000fe200078ee216ULL, 0x00005e0013127625ULL, 0x000fe200078e0038ULL,
0x0000003910107210ULL, 0x000fc60007f1e0ffULL, 0x0000000157387824ULL, 0x040fe400078e0200ULL,
0x00000008573b7824ULL, 0x000fe400078e00ffULL, 0x000000ffff117224ULL, 0x000fe200000e0611ULL,
0x0000003912127210ULL, 0x000fe20007f1e0ffULL, 0x0000001017157824ULL, 0x008fe200078e025cULL,
0xfffffff83b3b7812ULL, 0x000fc600078ee238ULL, 0x000000ffff137224ULL, 0x000fe200000e0613ULL,
0x0000000010157faeULL, 0x0005e2000e901c46ULL, 0x000000103b177824ULL, 0x000fca00078e025cULL,
0x0000000012177faeULL, 0x0005e2000f101c46ULL, 0x000002f000007947ULL, 0x000fea0003800000ULL,
0x000000100e117824ULL, 0x000fe400078e00ffULL, 0x0000001000397824ULL, 0x040fe400078e00ffULL,
0x00000080ff157424ULL, 0x000fe200078e00ffULL, 0x0000001100117211ULL, 0x000fe400078fe8ffULL,
0x0000007039397812ULL, 0x000fe400078ec0ffULL, 0x0000000411137810ULL, 0x040fe20007ffe0ffULL,
0x0000000111107824ULL, 0x040fe200078e0200ULL, 0x00000008113d7810ULL, 0x040fe20007ffe0ffULL,
0x00000008113b7824ULL, 0x040fe200078e00ffULL, 0x0000000c113f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000113127824ULL, 0x000fc400078e0216ULL, 0x0000000113177824ULL, 0x000fe200078e0200ULL,
0xfffffff83b3b7812ULL, 0x000fe200078ee210ULL, 0x0000000111107824ULL, 0x000fe400078e0216ULL,
0x00000008133c7824ULL, 0x000fe400078e00ffULL, 0x00005e0010107625ULL, 0x000fc800078e0015ULL,
0x000000013d137824ULL, 0x100fe400078e0216ULL, 0x000000013f147824ULL, 0x000fe200078e0216ULL,
0x0000003910167210ULL, 0x000fe20007f1e0ffULL, 0x000000013d387824ULL, 0x040fe400078e0200ULL,
0x000000083d577824ULL, 0x000fe200078e00ffULL, 0xfffffff83c3d7812ULL, 0x000fe200078ee217ULL,
0x000000ffff177224ULL, 0x000fe400000e0611ULL, 0x00005e0012107625ULL, 0x000fc800078e0015ULL,
0x00005e0013127625ULL, 0x000fe200078e0015ULL, 0x0000003910107210ULL, 0x000fc60007f1e0ffULL,
0x000000013f3a7824ULL, 0x040fe200078e0200ULL, 0x0000003912127210ULL, 0x000fe20007fbe0ffULL,
0x000000083f5f7824ULL, 0x000fe200078e00ffULL, 0xfffffff8573f7812ULL, 0x000fe200078ee238ULL,
0x00005e0014147625ULL, 0x000fc600078e0015ULL, 0xfffffff85f577812ULL, 0x000fe200078ee23aULL,
0x000000103b3b7824ULL, 0x100fe200078e025cULL, 0x0000003914147210ULL, 0x000fe20007fde0ffULL,
0x000000103d3d7824ULL, 0x100fe400078e025cULL, 0x000000ffff117224ULL, 0x000fe200000e0611ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000163b7faeULL, 0x0005e2000b901c46ULL,
0x000000103f3f7824ULL, 0x100fe400078e025cULL, 0x000000ffff137224ULL, 0x000fe200028e0613ULL,
0x00000000103d7faeULL, 0x0005e2000b901c46ULL, 0x0000001057577824ULL, 0x000fc400078e025cULL,
0x000000ffff157224ULL, 0x000fe200030e0615ULL, 0x00000000123f7faeULL, 0x0005e8000b901c46ULL,
0x0000000014577faeULL, 0x0005e4000b901c46ULL, 0x0000000000007918ULL, 0x004fe20000000000ULL,
0xfffffff00d127812ULL, 0x040fe200078ec0ffULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0xffffffe00d117812ULL, 0x040fe400078ec0ffULL, 0x000000100d167812ULL, 0x000fe200078ec0ffULL,
0x0000000847127824ULL, 0x000fe200078e0212ULL, 0x000000080d107812ULL, 0x000fc400078ec0ffULL,
0x000000000000781cULL, 0x000fe40003f0f070ULL, 0x0000001110167210ULL, 0x000fd60007ffe016ULL,
0x00000000550403c2ULL, 0x000ea40000020000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0099b0ULL, 0x004fe20008000a04ULL,
0x000000000000081cULL, 0x000fe20000f0f070ULL, 0xffffff8000001947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6a800125e7f8cULL, 0x0004e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6480016107f8cULL, 0x0002a4000c80043fULL,
0x0000000000127805ULL, 0x004fc40000015200ULL, 0x00f64c0016157984ULL, 0x000ea40000000800ULL,
0x8000000015ff7812ULL, 0x004fe40007804811ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff387224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001412177210ULL, 0x000fca0007f1e1ffULL, 0x0000000115157824ULL, 0x000fe200000e0e13ULL,
0x003d09001700780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401700780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001714147211ULL, 0x000fca00078110ffULL,
0x000000ffff157224ULL, 0x000fca00000e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000138387810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f64c0016157984ULL, 0x000ea40000000800ULL, 0x8000000015ff7812ULL, 0x004fe40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010039117810ULL, 0x000fca0007ffe04bULL,
0x000000014a117824ULL, 0x000fca00078e0211ULL, 0x00f0000011127984ULL, 0x000ea80000000800ULL,
0x00f2000011137984ULL, 0x0002e20000000800ULL, 0x0000005b1200720bULL, 0x004fe20003f1d000ULL,
0x00007c527f007947ULL, 0x000fd8000b800000ULL, 0x0000000000147806ULL, 0x002fc800000e0100ULL,
0x0000ffff14ff7812ULL, 0x000fe2000780c0ffULL, 0x000004a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff557424ULL, 0x000fd600078e00ffULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x0000000241107811ULL, 0x000fe400078ff0ffULL, 0x0000005b1200720bULL, 0x000fe40003f14000ULL,
0x000000411000720cULL, 0x000fe20003fa5270ULL, 0x00007c127f007947ULL, 0x000fd4000b800000ULL,
0x0000000000157806ULL, 0x000fc400000e0100ULL, 0x000000804139d824ULL, 0x000fe200078e0239ULL,
0x000000125b10d209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe20003800000ULL,
0x0000991015117816ULL, 0x000fe200000000ffULL, 0x000000014a39d824ULL, 0x000fc600078e0239ULL,
0x000000ff1100720cULL, 0x000fe40003f05270ULL, 0x00f400103900d388ULL, 0x0003f60000000800ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x000000125b107209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff15ff7812ULL, 0x000fc6000780c0ffULL,
0x800000105b107221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL,
0x0000001000397308ULL, 0x000e640000000800ULL, 0x0000003906067220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff107819ULL, 0x000fe20000011600ULL,
0x00007b327f007947ULL, 0x000fea000b800000ULL, 0x00001f1039107589ULL, 0x0002a400000e0000ULL,
0x0000001024247220ULL, 0x084fe20000410000ULL, 0x0000001025257220ULL, 0x080fe20000410000ULL,
0x0000001034347220ULL, 0x080fe20000410000ULL, 0x0000001035357220ULL, 0x080fe20000410000ULL,
0x0000001030307220ULL, 0x080fe20000410000ULL, 0x0000001031317220ULL, 0x080fe20000410000ULL,
0x0000001020207220ULL, 0x080fe20000410000ULL, 0x0000001021217220ULL, 0x080fe20000410000ULL,
0x000000101c1c7220ULL, 0x080fe20000410000ULL, 0x000000101d1d7220ULL, 0x080fe20000410000ULL,
0x000000102c2c7220ULL, 0x080fe20000410000ULL, 0x000000102d2d7220ULL, 0x080fe20000410000ULL,
0x0000001028287220ULL, 0x080fe20000410000ULL, 0x0000001029297220ULL, 0x080fe20000410000ULL,
0x0000001018187220ULL, 0x080fe20000410000ULL, 0x0000001019197220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0015ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000800107811ULL, 0x000fe200078ff0ffULL,
0x00007a227f007947ULL, 0x000fea000b800000ULL, 0x00001f1039107589ULL, 0x00046400000e0000ULL,
0x0000001026267220ULL, 0x082fe20000410000ULL, 0x0000001027277220ULL, 0x080fe20000410000ULL,
0x0000001036367220ULL, 0x080fe20000410000ULL, 0x0000001037377220ULL, 0x080fe20000410000ULL,
0x0000001032327220ULL, 0x080fe20000410000ULL, 0x0000001033337220ULL, 0x080fe20000410000ULL,
0x0000001022227220ULL, 0x080fe20000410000ULL, 0x0000001023237220ULL, 0x080fe20000410000ULL,
0x000000101e1e7220ULL, 0x080fe20000410000ULL, 0x000000101f1f7220ULL, 0x080fe20000410000ULL,
0x000000102e2e7220ULL, 0x080fe20000410000ULL, 0x000000102f2f7220ULL, 0x080fe20000410000ULL,
0x000000102a2a7220ULL, 0x080fe20000410000ULL, 0x000000102b2b7220ULL, 0x080fe20000410000ULL,
0x000000101a1a7220ULL, 0x080fe20000410000ULL, 0x000000101b1b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff15ff7812ULL, 0x000fe20007800814ULL,
0x00000001ff557424ULL, 0x000fe200078e00ffULL, 0x000000125b5b7209ULL, 0x000fd60007810000ULL,
0x8000005b12120221ULL, 0x000fe20000010000ULL, 0x00007610ff550816ULL, 0x000fc60000000055ULL,
0x3fb8aa3b12120820ULL, 0x000fc80000410000ULL, 0x0000001200070308ULL, 0x000e640000000800ULL,
0x0000000713130220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000613067221ULL, 0x008fc20000010000ULL, 0x0000000000107805ULL, 0x000fcc0000015200ULL,
0x00f6ac0054127984ULL, 0x000e640000000800ULL, 0x8000000012ff7812ULL, 0x002fe4000780485dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x0000001210157210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09001500780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401500780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011413ULL,
0x0000001512127211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000212127819ULL, 0x000fc80000001213ULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000114147810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6ac0054127984ULL, 0x000e640000000800ULL,
0x8000000012ff7812ULL, 0x002fe4000780485dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991055107816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff1000720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000007ff08723eULL, 0x000fe400000000ffULL, 0x00000002ff137819ULL, 0x000fe40000011600ULL,
0x0000541008127816ULL, 0x000fe20000000008ULL, 0x000076027f007947ULL, 0x000fea000b800000ULL,
0x00001f1312097589ULL, 0x0002e400000e0000ULL, 0x0000000813107810ULL, 0x000fe20007ffe0ffULL,
0x000076327f007947ULL, 0x000fea000b800000ULL, 0x00001f1012087589ULL, 0x0002a400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001013107810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff177224ULL, 0x000fe200078e0012ULL, 0x0000631000387802ULL, 0x000fc40000000f00ULL,
0x00007ca000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001813107810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff177224ULL, 0x004fe200078e0012ULL,
0x0000636000387802ULL, 0x000fc40000000f00ULL, 0x00007c5000007944ULL, 0x008fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000010000b107824ULL, 0x002fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000015a597824ULL, 0x040fe200078e0259ULL,
0x00a000004314783bULL, 0x004e620000000200ULL, 0x000000085a5a7824ULL, 0x000fe200078e00ffULL,
0x0000100010117812ULL, 0x000fc800078ec0ffULL, 0xfffffff85a597812ULL, 0x000fe200078ee259ULL,
0x0000200002117824ULL, 0x000fca00078e0211ULL, 0x0000b00011567810ULL, 0x000fca0007ffe0ffULL,
0x0000001059107824ULL, 0x100fe400078e0256ULL, 0x0000001051387824ULL, 0x000fc800078e0256ULL,
0x000000001010783bULL, 0x000ea80000004200ULL, 0x000000003838783bULL, 0x000f220000004200ULL,
0x0000000914148232ULL, 0x08afe40000000000ULL, 0x0000000916168232ULL, 0x000fe40000000000ULL,
0x0000000815158232ULL, 0x080fe40000000000ULL, 0x0000000817178232ULL, 0x000fe20000000000ULL,
0x00003120103e7816ULL, 0x004fc400000000ffULL, 0x0000312011117816ULL, 0x000fe400000000ffULL,
0x0000003eff3c723eULL, 0x080fe400020006ffULL, 0x0000003eff10723eULL, 0x000fe200030006ffULL,
0x000000104f3e7824ULL, 0x000fe200078e0256ULL, 0x00003120384f7816ULL, 0x010fe400000000ffULL,
0x0000312039517816ULL, 0x000fe400000000ffULL, 0x00000011ff3d723eULL, 0x000fc400020006ffULL,
0x0000004fff38723eULL, 0x000fe400020006ffULL, 0x00000051ff39723eULL, 0x000fe400020006ffULL,
0x00000011ff11723eULL, 0x000fe200030006ffULL, 0x0000003c1424723cULL, 0x000b620000001824ULL,
0x0000312012127816ULL, 0x000fe400000000ffULL, 0x0000312013137816ULL, 0x000fe400000000ffULL,
0x000031203a3a7816ULL, 0x000fc400000000ffULL, 0x00000012ff3c723eULL, 0x020fe200030006ffULL,
0x00000038141c723cULL, 0x040be2000000181cULL, 0x00000013ff3d723eULL, 0x000fe400030006ffULL,
0x000031203b3b7816ULL, 0x000fe400000000ffULL, 0x0000003aff5c723eULL, 0x000fe400030006ffULL,
0x0000004fff38723eULL, 0x020fe200030006ffULL, 0x000000101434723cULL, 0x000b620000001834ULL,
0x00000051ff39723eULL, 0x000fc400030006ffULL, 0x0000003bff5d723eULL, 0x000fe400030006ffULL,
0x00009910554f7816ULL, 0x000fe400000000ffULL, 0x00000012ff10723eULL, 0x020fe200020006ffULL,
0x0000003c1420723cULL, 0x000be20000001820ULL, 0x00000013ff11723eULL, 0x000fe200020006ffULL,
0x000000003e3c783bULL, 0x020e620000004200ULL, 0x000000ff4f00720cULL, 0x000fca0003f05270ULL,
0x00000038142c723cULL, 0x040bee000000182cULL, 0x0000003aff38723eULL, 0x020fe200020006ffULL,
0x000000101430723cULL, 0x040b620000001830ULL, 0x0000003bff39723eULL, 0x000fe200020006ffULL,
0x00a000004210783bULL, 0x020eac0000000200ULL, 0x000000381428723cULL, 0x040b6e0000001828ULL,
0x000000104d387824ULL, 0x020fe200078e0256ULL, 0x0000005c1418723cULL, 0x000b6a0000001818ULL,
0x000000003838783bULL, 0x000ee20000004200ULL, 0x000031203c3c7816ULL, 0x002fc400000000ffULL,
0x000031203d3d7816ULL, 0x000fe400000000ffULL, 0x0000003cff14723eULL, 0x0a0fe400020006ffULL,
0x0000003dff15723eULL, 0x000fe400020006ffULL, 0x000031203e3e7816ULL, 0x000fe400000000ffULL,
0x000031203f3f7816ULL, 0x000fe400000000ffULL, 0x0000003cff3c723eULL, 0x000fc400030006ffULL,
0x0000003dff3d723eULL, 0x000fe200030006ffULL, 0x0000000910108232ULL, 0x084fe40000000000ULL,
0x0000000912128232ULL, 0x000fe40000000000ULL, 0x0000000811118232ULL, 0x080fe40000000000ULL,
0x0000000813138232ULL, 0x000fce0000000000ULL, 0x000000141024723cULL, 0x000b620000001824ULL,
0x0000312038387816ULL, 0x008fcc00000000ffULL, 0x0000003eff14723eULL, 0x0a0fe200020006ffULL,
0x0000003c1034723cULL, 0x040f620000001834ULL, 0x0000003fff15723eULL, 0x000fe400020006ffULL,
0x0000312039397816ULL, 0x000fe400000000ffULL, 0x000031203a3a7816ULL, 0x000fe400000000ffULL,
0x000031203b3b7816ULL, 0x000fe200000000ffULL, 0x000000141030723cULL, 0x000b620000001830ULL,
0x0000003eff3e723eULL, 0x000fc400030006ffULL, 0x0000003fff3f723eULL, 0x000fc800030006ffULL,
0x00000038ff14723eULL, 0x0a0fe400020006ffULL, 0x00000039ff15723eULL, 0x080fe200020006ffULL,
0x0000003e1020723cULL, 0x000f620000001820ULL, 0x00000038ff38723eULL, 0x000fe400030006ffULL,
0x00000039ff39723eULL, 0x000fca00030006ffULL, 0x00000014101c723cULL, 0x040b6e000000181cULL,
0x0000003aff14723eULL, 0x0a0fe200020006ffULL, 0x00000038102c723cULL, 0x000b62000000182cULL,
0x0000003bff15723eULL, 0x000fe400020006ffULL, 0x0000003aff3a723eULL, 0x000fc400030006ffULL,
0x0000003bff3b723eULL, 0x000fc600030006ffULL, 0x000000141028723cULL, 0x040b700000001828ULL,
0x0000003a1018723cULL, 0x000b620000001818ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x000000000c147f8cULL, 0x0202a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000c00a117811ULL, 0x000fe200078e40ffULL,
0x00f6980048ff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff127224ULL, 0x000fc400078e0047ULL,
0x000000401100720cULL, 0x000fe20003f06070ULL, 0x000000ffff5d7224ULL, 0x000fd800078e005fULL,
0x00001bd000000947ULL, 0x000fea0003800000ULL, 0x0000000000107805ULL, 0x008fc40000015200ULL,
0x0000000441127824ULL, 0x000fca00078e00ffULL, 0xfffffff812147812ULL, 0x004fca00078ec0ffULL,
0x00f6cc0014127984ULL, 0x000ea40000000800ULL, 0x8000000012ff7812ULL, 0x004fe40007804815ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff167224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x0000001210177210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011413ULL,
0x0000001712127211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000212127819ULL, 0x000fc80000001213ULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000116167810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6cc0014127984ULL, 0x000ea40000000800ULL,
0x8000000012ff7812ULL, 0x004fe40007804815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000020a107810ULL, 0x000fe40007ffe0ffULL, 0x0000010045457810ULL, 0x000fe40007ffe0ffULL,
0x0000000f1000720cULL, 0x000fc60003f06070ULL, 0x0000620004387a24ULL, 0x000fd400078e0245ULL,
0x000003c000008947ULL, 0x000fea0003800000ULL, 0x0000004540107217ULL, 0x000fe20007800000ULL,
0x000000100e397824ULL, 0x000fe200078e00ffULL, 0x00000003ff167819ULL, 0x000fe20000011600ULL,
0x0000001000127824ULL, 0x000fe400078e00ffULL, 0x0000000110107824ULL, 0x000fe200078e0a45ULL,
0x00000004163c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000139157824ULL, 0x040fe200078e0216ULL,
0x0000007012127812ULL, 0x000fe200078ec0ffULL, 0x00000080ff3a7424ULL, 0x000fe200078e00ffULL,
0x0000001039107217ULL, 0x000fe20007800000ULL, 0x0000000115117824ULL, 0x040fe200078e0238ULL,
0x0000000c163e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000115147824ULL, 0x000fc400078e0200ULL,
0x0000000110137824ULL, 0x000fe400078e0a39ULL, 0x0000000815177824ULL, 0x000fe400078e00ffULL,
0x0000000139157824ULL, 0x000fe200078e023cULL, 0x000000133c00720cULL, 0x080fe20003f06070ULL,
0x00005e0011107625ULL, 0x000fe200078e003aULL, 0xfffffff817177812ULL, 0x000fe400078ee214ULL,
0x000000131600720cULL, 0x000fe20003fa6070ULL, 0x00000001153b7824ULL, 0x040fe200078e0200ULL,
0x0000001210107210ULL, 0x000fe20007fde0ffULL, 0x00000008153c7824ULL, 0x000fc400078e00ffULL,
0x0000000115147824ULL, 0x000fe400078e0238ULL, 0x000000ffff117224ULL, 0x000fe200030e0611ULL,
0xfffffff83c3b7812ULL, 0x000fe200078ee23bULL, 0x00005e0014147625ULL, 0x000fe200078e003aULL,
0x00000008163c7810ULL, 0x000fc60007ffe0ffULL, 0x0000001017177824ULL, 0x000fe200078e0256ULL,
0x0000001214147210ULL, 0x000fe20007fde0ffULL, 0x00000001393d7824ULL, 0x040fe400078e023cULL,
0x00000001393f7824ULL, 0x000fe200078e023eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010177faeULL, 0x0005e2000e901c46ULL, 0x000000013d167824ULL, 0x000fe200078e0238ULL,
0x000000133c00720cULL, 0x080fe20003fa6070ULL, 0x000000ffff157224ULL, 0x000fe200030e0615ULL,
0x000000133e00720cULL, 0x000fe20003fc6070ULL, 0x000000103b397824ULL, 0x000fc400078e0256ULL,
0x000000013f137824ULL, 0x000fe400078e0238ULL, 0x000000013d387824ULL, 0x040fe200078e0200ULL,
0x0000000014397faeULL, 0x0007e2000c101c46ULL, 0x000000083d3d7824ULL, 0x000fe400078e00ffULL,
0x00005e0016107625ULL, 0x004fc800078e003aULL, 0x00005e0013167625ULL, 0x000fe200078e003aULL,
0x0000001210107210ULL, 0x080fe40007f1e0ffULL, 0xfffffff83d137812ULL, 0x000fe200078ee238ULL,
0x000000013f3a7824ULL, 0x040fe400078e0200ULL, 0x000000083f3b7824ULL, 0x000fe400078e00ffULL,
0x000000ffff117224ULL, 0x000fe200000e0611ULL, 0x0000001216167210ULL, 0x000fe20007f1e0ffULL,
0x0000001013137824ULL, 0x000fe200078e0256ULL, 0xfffffff83b3b7812ULL, 0x000fc600078ee23aULL,
0x000000ffff177224ULL, 0x000fe200000e0617ULL, 0x0000000010137faeULL, 0x0005e2000e901c46ULL,
0x000000103b157824ULL, 0x008fca00078e0256ULL, 0x0000000016157faeULL, 0x0005e2000f101c46ULL,
0x000002f000007947ULL, 0x000fea0003800000ULL, 0x000000100e117824ULL, 0x000fe400078e00ffULL,
0x0000001000127824ULL, 0x040fe400078e00ffULL, 0x00000080ff397424ULL, 0x000fe200078e00ffULL,
0x0000001100117211ULL, 0x000fe400078fe8ffULL, 0x0000007012127812ULL, 0x000fe400078ec0ffULL,
0x0000000411157810ULL, 0x040fe20007ffe0ffULL, 0x0000000111107824ULL, 0x040fe200078e0200ULL,
0x00000008113b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000811137824ULL, 0x040fe200078e00ffULL,
0x0000000c113d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000115147824ULL, 0x000fc400078e0238ULL,
0x0000000115177824ULL, 0x000fe200078e0200ULL, 0xfffffff813137812ULL, 0x000fe200078ee210ULL,
0x0000000111107824ULL, 0x000fe400078e0238ULL, 0x00000008153c7824ULL, 0x000fe400078e00ffULL,
0x00005e0010107625ULL, 0x000fc800078e0039ULL, 0x000000013b157824ULL, 0x040fe200078e0200ULL,
0x0000001210107210ULL, 0x000fe20007f1e0ffULL, 0x000000083b3e7824ULL, 0x040fe400078e00ffULL,
0x000000013b167824ULL, 0x100fe200078e0238ULL, 0xfffffff83c3b7812ULL, 0x000fe200078ee217ULL,
0x000000013d387824ULL, 0x040fe400078e0238ULL, 0x000000013d3a7824ULL, 0x040fe400078e0200ULL,
0x000000083d3f7824ULL, 0x000fe200078e00ffULL, 0xfffffff83e3d7812ULL, 0x000fe200078ee215ULL,
0x00005e0014147625ULL, 0x000fc600078e0039ULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee23aULL,
0x00005e0016167625ULL, 0x000fc800078e0039ULL, 0x00005e0038387625ULL, 0x000fe200078e0039ULL,
0x0000001216167210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff117224ULL, 0x000fe200000e0611ULL,
0x0000001214147210ULL, 0x080fe20007f1e0ffULL, 0x0000001013137824ULL, 0x100fe200078e0256ULL,
0x0000001238387210ULL, 0x000fe20007fde0ffULL, 0x000000103b3b7824ULL, 0x100fe400078e0256ULL,
0x000000ffff157224ULL, 0x000fe200000e0615ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010137faeULL, 0x0005e2000b901c46ULL, 0x000000103d3d7824ULL, 0x100fe400078e0256ULL,
0x000000ffff177224ULL, 0x000fe200028e0617ULL, 0x00000000143b7faeULL, 0x0005e2000b901c46ULL,
0x000000103f3f7824ULL, 0x000fc400078e0256ULL, 0x000000ffff397224ULL, 0x000fe200030e0639ULL,
0x00000000163d7faeULL, 0x0005e8000b901c46ULL, 0x00000000383f7faeULL, 0x0005e4000b901c46ULL,
0x0000000000007918ULL, 0x004fe20000000000ULL, 0xffffffe00d107812ULL, 0x040fe200078ec0ffULL,
0x000000d000007945ULL, 0x000fe20003800000ULL, 0x000000100d117812ULL, 0x040fe400078ec0ffULL,
0x000000080d137812ULL, 0x000fc400078ec0ffULL, 0x000000000000781cULL, 0x000fe40003f0f070ULL,
0x0000001013387210ULL, 0x000fd60007ffe011ULL, 0x00000000530403c2ULL, 0x000ea40000080000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff00c9b0ULL, 0x004fe20008000a04ULL, 0x000000000000081cULL, 0x000fe2000270f070ULL,
0xffffff8000004947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a800545c7f8cULL, 0x0004e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6680038107f8cULL, 0x0002a4000c80043fULL, 0x0000000000147805ULL, 0x000fc40000015200ULL,
0x00f66c0038137984ULL, 0x000f240000000800ULL, 0x8000000013ff7812ULL, 0x014fe40007804811ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff397224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614167210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09001600780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401600780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff137819ULL, 0x000fc80000011417ULL,
0x0000001613137211ULL, 0x000fca00078110ffULL, 0x000000ffff167224ULL, 0x000fca00000e0617ULL,
0x0000000213137819ULL, 0x000fc80000001216ULL, 0x000000130000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000139397810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f66c0038137984ULL, 0x000ea40000000800ULL,
0x8000000013ff7812ULL, 0x004fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000180124b7810ULL, 0x000fca0007ffe04bULL, 0x000000014a4b7824ULL, 0x000fca00078e024bULL,
0x00f000004b147984ULL, 0x000ea80000000800ULL, 0x00f200004b137984ULL, 0x0002e20000000800ULL,
0x0000005b1400720bULL, 0x004fe20003f1d000ULL, 0x000061727f007947ULL, 0x000fd8000b800000ULL,
0x0000000000157806ULL, 0x002fc800000e0100ULL, 0x0000ffff15ff7812ULL, 0x000fe2000780c0ffULL,
0x000004a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff167424ULL, 0x000fd600078e00ffULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x0000000341107811ULL, 0x000fe400078ff0ffULL,
0x0000005b1400720bULL, 0x000fe40003f14000ULL, 0x000000411000720cULL, 0x000fe20003fa5270ULL,
0x000061327f007947ULL, 0x000fd4000b800000ULL, 0x0000000000167806ULL, 0x000fc400000e0100ULL,
0x000000804111d824ULL, 0x000fe200078e0212ULL, 0x0000005b1410d209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe40003800000ULL, 0x000000014a17d824ULL, 0x000fe200078e0211ULL,
0x0000991016117816ULL, 0x000fc800000000ffULL, 0x00f400101700d388ULL, 0x0003e20000000800ULL,
0x000000ff1100720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000005b14107209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff16ff7812ULL, 0x000fc6000780c0ffULL, 0x0000005b10107221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL, 0x0000001000397308ULL, 0x000e640000000800ULL,
0x0000003906067220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff107819ULL, 0x000fe20000011600ULL, 0x000060427f007947ULL, 0x000fea000b800000ULL,
0x00001f1039107589ULL, 0x0002a400000e0000ULL, 0x0000001024247220ULL, 0x084fe20000410000ULL,
0x0000001025257220ULL, 0x080fe20000410000ULL, 0x0000001034347220ULL, 0x080fe20000410000ULL,
0x0000001035357220ULL, 0x080fe20000410000ULL, 0x0000001030307220ULL, 0x080fe20000410000ULL,
0x0000001031317220ULL, 0x080fe20000410000ULL, 0x0000001020207220ULL, 0x080fe20000410000ULL,
0x0000001021217220ULL, 0x080fe20000410000ULL, 0x000000101c1c7220ULL, 0x080fe20000410000ULL,
0x000000101d1d7220ULL, 0x080fe20000410000ULL, 0x000000102c2c7220ULL, 0x080fe20000410000ULL,
0x000000102d2d7220ULL, 0x080fe20000410000ULL, 0x0000001028287220ULL, 0x080fe20000410000ULL,
0x0000001029297220ULL, 0x080fe20000410000ULL, 0x0000001018187220ULL, 0x080fe20000410000ULL,
0x0000001019197220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0016ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000800107811ULL, 0x000fe200078ff0ffULL, 0x00005f327f007947ULL, 0x000fea000b800000ULL,
0x00001f1039107589ULL, 0x00046400000e0000ULL, 0x0000001026267220ULL, 0x082fe20000410000ULL,
0x0000001027277220ULL, 0x080fe20000410000ULL, 0x0000001036367220ULL, 0x080fe20000410000ULL,
0x0000001037377220ULL, 0x080fe20000410000ULL, 0x0000001032327220ULL, 0x080fe20000410000ULL,
0x0000001033337220ULL, 0x080fe20000410000ULL, 0x0000001022227220ULL, 0x080fe20000410000ULL,
0x0000001023237220ULL, 0x080fe20000410000ULL, 0x000000101e1e7220ULL, 0x080fe20000410000ULL,
0x000000101f1f7220ULL, 0x080fe20000410000ULL, 0x000000102e2e7220ULL, 0x080fe20000410000ULL,
0x000000102f2f7220ULL, 0x080fe20000410000ULL, 0x000000102a2a7220ULL, 0x080fe20000410000ULL,
0x000000102b2b7220ULL, 0x080fe20000410000ULL, 0x000000101a1a7220ULL, 0x080fe20000410000ULL,
0x000000101b1b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff16ff7812ULL, 0x000fe20007800815ULL, 0x00000001ff167424ULL, 0x000fe200078e00ffULL,
0x0000005b145b7209ULL, 0x000fd60007810000ULL, 0x8000005b14140221ULL, 0x000fe20000010000ULL,
0x00007610ff160816ULL, 0x000fc60000000016ULL, 0x3fb8aa3b14140820ULL, 0x000fc80000410000ULL,
0x0000001400070308ULL, 0x000e640000000800ULL, 0x0000000713130220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000613067221ULL, 0x008fc20000010000ULL,
0x0000000000107805ULL, 0x000fcc0000015200ULL, 0x0000000105587824ULL, 0x000fca00078e0258ULL,
0x00f6ac0058137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe4000780485fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x0000001210157210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09001500780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401500780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011413ULL,
0x0000001512127211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000212127819ULL, 0x000fc80000001213ULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000114147810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6ac0058137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe4000780485fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991016107816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff1000720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000007ff08723eULL, 0x000fe400000000ffULL, 0x00000002ff137819ULL, 0x000fe40000011600ULL,
0x0000541008127816ULL, 0x000fe20000000008ULL, 0x00005b027f007947ULL, 0x000fea000b800000ULL,
0x00001f1312097589ULL, 0x0002e400000e0000ULL, 0x0000000813107810ULL, 0x000fe20007ffe0ffULL,
0x00005b327f007947ULL, 0x000fea000b800000ULL, 0x00001f1012087589ULL, 0x0002a400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001013107810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff177224ULL, 0x000fe200078e0012ULL, 0x00007ff000387802ULL, 0x000fc40000000f00ULL,
0x00005fc000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001813107810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff177224ULL, 0x004fe200078e0012ULL,
0x0000804000387802ULL, 0x000fc40000000f00ULL, 0x00005f7000007944ULL, 0x008fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000005210783bULL, 0x002e680000004200ULL, 0x00a800004314783bULL, 0x004ea80000000200ULL,
0x00000000503c783bULL, 0x000f220000004200ULL, 0x0000312010107816ULL, 0x002fc400000000ffULL,
0x0000312011117816ULL, 0x000fe400000000ffULL, 0x00000010ff38723eULL, 0x080fe200020006ffULL,
0x0000000914148232ULL, 0x08cfe20000000000ULL, 0x00000011ff39723eULL, 0x000fe200020006ffULL,
0x0000000916168232ULL, 0x000fe20000000000ULL, 0x0000312012127816ULL, 0x000fe200000000ffULL,
0x0000000815158232ULL, 0x080fe20000000000ULL, 0x0000312013137816ULL, 0x000fe200000000ffULL,
0x0000000817178232ULL, 0x000fe20000000000ULL, 0x00000010ff10723eULL, 0x000fc400030006ffULL,
0x00000011ff11723eULL, 0x000fe400030006ffULL, 0x00000012ff44723eULL, 0x000fe400030006ffULL,
0x00000013ff45723eULL, 0x000fe200030006ffULL, 0x000000381424723cULL, 0x000b620000001824ULL,
0x000031203c3c7816ULL, 0x010fe200000000ffULL, 0x000000004e38783bULL, 0x020e620000004200ULL,
0x000031203d3d7816ULL, 0x000fe400000000ffULL, 0x000031203e3e7816ULL, 0x000fc400000000ffULL,
0x000031203f3f7816ULL, 0x000fe200000000ffULL, 0x000000101434723cULL, 0x000b660000001834ULL,
0x0000003fff43723eULL, 0x000fc800030006ffULL, 0x00000012ff10723eULL, 0x020fe200020006ffULL,
0x000000441420723cULL, 0x000be20000001820ULL, 0x00000013ff11723eULL, 0x000fcc00020006ffULL,
0x0000003cff44723eULL, 0x0a0fe200020006ffULL, 0x000000101430723cULL, 0x000b620000001830ULL,
0x0000003dff45723eULL, 0x080fe200020006ffULL, 0x00a800004210783bULL, 0x0204e20000000200ULL,
0x0000003cff3c723eULL, 0x000fe400030006ffULL, 0x0000003dff3d723eULL, 0x000fc600030006ffULL,
0x00000044141c723cULL, 0x000f62000000181cULL, 0x0000003eff42723eULL, 0x004fce00030006ffULL,
0x0000003c142c723cULL, 0x040b62000000182cULL, 0x0000312038387816ULL, 0x002fe400000000ffULL,
0x0000312039397816ULL, 0x000fe400000000ffULL, 0x000031203a3a7816ULL, 0x000fe400000000ffULL,
0x0000003eff3c723eULL, 0x020fe200020006ffULL, 0x000000421418723cULL, 0x000fe20000001818ULL,
0x0000003fff3d723eULL, 0x000fe400020006ffULL, 0x000031203b3b7816ULL, 0x000fca00000000ffULL,
0x0000003c1428723cULL, 0x000b640000001828ULL, 0x000000004c3c783bULL, 0x020e6a0000004200ULL,
0x00000038ff14723eULL, 0x080fe200020006ffULL, 0x0000000910108232ULL, 0x088fe20000000000ULL,
0x00000039ff15723eULL, 0x080fe200020006ffULL, 0x0000000912128232ULL, 0x000fe20000000000ULL,
0x00000038ff38723eULL, 0x000fe200030006ffULL, 0x0000000811118232ULL, 0x080fe20000000000ULL,
0x00000039ff39723eULL, 0x000fe200030006ffULL, 0x0000000813138232ULL, 0x000fce0000000000ULL,
0x000000141024723cULL, 0x040b6e0000001824ULL, 0x0000003aff14723eULL, 0x0a0fe200020006ffULL,
0x000000381034723cULL, 0x000f620000001834ULL, 0x0000003bff15723eULL, 0x000fe400020006ffULL,
0x0000003aff3a723eULL, 0x000fc400030006ffULL, 0x0000003bff3b723eULL, 0x000fc600030006ffULL,
0x000000141030723cULL, 0x000b620000001830ULL, 0x000031203c3c7816ULL, 0x002fe400000000ffULL,
0x000031203d3d7816ULL, 0x000fc800000000ffULL, 0x0000003cff14723eULL, 0x0a0fe200020006ffULL,
0x0000003a1020723cULL, 0x040f620000001820ULL, 0x0000003dff15723eULL, 0x080fe400020006ffULL,
0x000031203e3e7816ULL, 0x000fe400000000ffULL, 0x000031203f3f7816ULL, 0x000fe400000000ffULL,
0x0000003cff3c723eULL, 0x000fe200030006ffULL, 0x00000014101c723cULL, 0x000b62000000181cULL,
0x0000003dff3d723eULL, 0x000fcc00030006ffULL, 0x0000003eff14723eULL, 0x0a0fe200020006ffULL,
0x0000003c102c723cULL, 0x000b62000000182cULL, 0x0000003fff15723eULL, 0x080fe400020006ffULL,
0x0000003eff3e723eULL, 0x000fe400030006ffULL, 0x0000003fff3f723eULL, 0x000fc600030006ffULL,
0x000000141028723cULL, 0x040b700000001828ULL, 0x0000003e1018723cULL, 0x000b620000001818ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x000000000c147f8cULL, 0x0202a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a00048ff7f8cULL, 0x0007e2000c80043fULL, 0x000000010b127812ULL, 0x000fc600078ec0ffULL,
0x000000010a0a7810ULL, 0x008fc80007ffe0ffULL, 0x0000000f0a00720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff896000007947ULL, 0x000fea000383ffffULL,
0x000000ff0f00720cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x0180000006007810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x000086f000077802ULL, 0x000fc40000000f00ULL,
0x0000570000007944ULL, 0x00efea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000600057308ULL, 0x002e640000001000ULL, 0xbf80000005007423ULL, 0x002fc80000000006ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000005007223ULL, 0x000fc40000000005ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006700ff057624ULL, 0x000fe400078e00ffULL,
0x00006600ff047624ULL, 0x000fca00078e00ffULL, 0x0000000604057981ULL, 0x000f28000c1e9900ULL,
0x0000000000067919ULL, 0x006e680000000000ULL, 0x0000000000097919ULL, 0x000ea20000000000ULL,
0x00000002ff087819ULL, 0x002fe40000011606ULL, 0x0000000809067811ULL, 0x004fe200078ff0ffULL,
0x0000000005077220ULL, 0x018fca0000410000ULL, 0x00001f0807007589ULL, 0x000e6800000e0000ULL,
0x00001f0607067589ULL, 0x000ea200000e0000ULL, 0x0000002400247220ULL, 0x042fe20000410000ULL,
0x0000002500257220ULL, 0x040fe20000410000ULL, 0x0000003400347220ULL, 0x040fe20000410000ULL,
0x0000003500357220ULL, 0x040fe20000410000ULL, 0x0000003000307220ULL, 0x040fe20000410000ULL,
0x0000003100317220ULL, 0x040fe20000410000ULL, 0x0000002000207220ULL, 0x040fe20000410000ULL,
0x0000002100217220ULL, 0x040fe20000410000ULL, 0x0000001c001c7220ULL, 0x040fe20000410000ULL,
0x0000001d001d7220ULL, 0x040fe20000410000ULL, 0x0000002c002c7220ULL, 0x040fe20000410000ULL,
0x0000002d002d7220ULL, 0x040fe20000410000ULL, 0x0000002800287220ULL, 0x040fe20000410000ULL,
0x0000002900297220ULL, 0x040fe20000410000ULL, 0x0000001800187220ULL, 0x040fe20000410000ULL,
0x0000001900197220ULL, 0x000fe20000410000ULL, 0x0000002606267220ULL, 0x044fe20000410000ULL,
0x0000002706277220ULL, 0x040fe20000410000ULL, 0x0000003606367220ULL, 0x040fe20000410000ULL,
0x0000003706377220ULL, 0x040fe20000410000ULL, 0x0000003206327220ULL, 0x040fe20000410000ULL,
0x0000003306337220ULL, 0x040fe20000410000ULL, 0x0000002206227220ULL, 0x040fe20000410000ULL,
0x0000002306237220ULL, 0x040fe20000410000ULL, 0x0000001e061e7220ULL, 0x040fe20000410000ULL,
0x0000001f061f7220ULL, 0x040fe20000410000ULL, 0x0000002e062e7220ULL, 0x040fe20000410000ULL,
0x0000002f062f7220ULL, 0x040fe20000410000ULL, 0x0000002a062a7220ULL, 0x040fe20000410000ULL,
0x0000002b062b7220ULL, 0x040fe20000410000ULL, 0x0000001a061a7220ULL, 0x040fe20000410000ULL,
0x0000001b061b7220ULL, 0x000fc20000410000ULL, 0x0000000000007919ULL, 0x000f220000000000ULL,
0x000000282928723eULL, 0x000fc400000000ffULL, 0x000000323333723eULL, 0x000fe200000000ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000222322723eULL, 0x000fe400000000ffULL,
0x0000001e1f1e723eULL, 0x000fe400000000ffULL, 0x0000541033327816ULL, 0x000fc40000000022ULL,
0x0000763233337816ULL, 0x000fe40000000022ULL, 0x0000002e2f0f723eULL, 0x000fe400000000ffULL,
0x0000002a2b2a723eULL, 0x000fe400000000ffULL, 0x0000001a1b15723eULL, 0x00cfe400000000ffULL,
0x00000002ff077819ULL, 0x010fe40000011600ULL, 0x0000000200047812ULL, 0x000fc400078ec0ffULL,
0x0000000800097811ULL, 0x000fe200078ff0ffULL, 0x00000008070b7824ULL, 0x040fe200078e00ffULL,
0x0000000704067211ULL, 0x040fe200078ff8ffULL, 0x0000000807127824ULL, 0x000fe200078e00ffULL,
0x0000000904057211ULL, 0x002fe200078ff8ffULL, 0x00000008090c7824ULL, 0x000fe200078e00ffULL,
0x0000000206047810ULL, 0x040fe20007ffe0ffULL, 0x0000000807097824ULL, 0x000fe200078e00ffULL,
0x0000000406087810ULL, 0x000fe40007ffe0ffULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee205ULL,
0x000010000e057824ULL, 0x000fe200078e00ffULL, 0xfffffff80b0a7812ULL, 0x000fc400078ee204ULL,
0xfffffff809047812ULL, 0x000fe200078ee206ULL, 0x0000080002077824ULL, 0x000fe200078e0205ULL,
0x0000000606097810ULL, 0x000fe20007ffe0ffULL, 0x0000000800067824ULL, 0x000fe200078e00ffULL,
0xfffffff80b107812ULL, 0x000fe200078ee208ULL, 0x0000001004087824ULL, 0x000fe200078e0207ULL,
0xfffffff812127812ULL, 0x000fe200078ee209ULL, 0x000000100c147824ULL, 0x100fe200078e0207ULL,
0x0000000806097812ULL, 0x000fe200078ec0ffULL, 0x000000100a0c7824ULL, 0x100fe200078e0207ULL,
0x000000242504723eULL, 0x000fe200000000ffULL, 0x0000001010107824ULL, 0x000fe200078e0207ULL,
0x000000343506723eULL, 0x000fe200000000ffULL, 0x00000001080a7824ULL, 0x000fe200078e0209ULL,
0x0000002c2d08723eULL, 0x000fe200000000ffULL, 0x00000001090c7824ULL, 0x040fe200078e020cULL,
0x0000541004167816ULL, 0x100fe20000000006ULL, 0x0000001012127824ULL, 0x000fe200078e0207ULL,
0x0000763204177816ULL, 0x000fe20000000006ULL, 0x00000001090b7824ULL, 0x000fe200078e0214ULL,
0x000000303104723eULL, 0x000fe200000000ffULL, 0x0000000109107824ULL, 0x000fe200078e0210ULL,
0x000000202106723eULL, 0x000fe200000000ffULL, 0x000000160a007388ULL, 0x0003e20000000a00ULL,
0x0000001c1d07723eULL, 0x000fe200000000ffULL, 0x0000000109127824ULL, 0x000fe200078e0212ULL,
0x000000181914723eULL, 0x000fc400000000ffULL, 0x000076322a0d7816ULL, 0x000fe40000000015ULL,
0x0000763228097816ULL, 0x000fe40000000014ULL, 0x000000ff0200720cULL, 0x000fe40003f05270ULL,
0x0000541004167816ULL, 0x142fe40000000006ULL, 0x0000763204177816ULL, 0x000fe40000000006ULL,
0x000000262704723eULL, 0x000fc400000000ffULL, 0x000000363706723eULL, 0x000fe200000000ffULL,
0x000000160c007388ULL, 0x0003e40000000a00ULL, 0x0000541007167816ULL, 0x142fe40000000008ULL,
0x0000763207177816ULL, 0x000fe40000000008ULL, 0x0000541028087816ULL, 0x000fe40000000014ULL,
0x000076321e077816ULL, 0x000fe2000000000fULL, 0x0000001610007388ULL, 0x000fe80000000a00ULL,
0x0000000812007388ULL, 0x0003e40000000a00ULL, 0x0000541004087816ULL, 0x002fc40000000006ULL,
0x0000763204097816ULL, 0x000fe20000000006ULL, 0x0000000103047824ULL, 0x000fe200078e0200ULL,
0x000054101e067816ULL, 0x000fc6000000000fULL, 0x000000080b007388ULL, 0x000fe20000000a00ULL,
0x0000001004047824ULL, 0x000fc600078e0205ULL, 0x000400320c007388ULL, 0x0003e80000000a00ULL,
0x0004000610007388ULL, 0x000fe20000000a00ULL, 0x000054102a0c7816ULL, 0x002fca0000000015ULL,
0x0004000c12007388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000004087984ULL, 0x000e680000000c00ULL, 0x0004000004187984ULL, 0x000ea80000000c00ULL,
0x0008000004147984ULL, 0x000ee80000000c00ULL, 0x000c0000041c7984ULL, 0x000f220000000c00ULL,
0x200000ff0b0b7230ULL, 0x002fc40000000000ULL, 0x200000ff0a0a7230ULL, 0x000fe40000000000ULL,
0x200000ff09097230ULL, 0x000fe40000000000ULL, 0x200000ff08087230ULL, 0x000fe40000000000ULL,
0x200000ff1b1b7230ULL, 0x004fe40000000000ULL, 0x200000ff1a1a7230ULL, 0x000fe40000000000ULL,
0x200000ff19197230ULL, 0x000fc40000000000ULL, 0x200000ff18187230ULL, 0x000fe40000000000ULL,
0x000000170b0b7230ULL, 0x008fe40000000000ULL, 0x000000160a0a7230ULL, 0x000fe40000000000ULL,
0x0000001509097230ULL, 0x000fe40000000000ULL, 0x0000001408087230ULL, 0x000fe40000000000ULL,
0x0000001f1b1b7230ULL, 0x010fc40000000000ULL, 0x0000001e1a1a7230ULL, 0x000fe20000000000ULL,
0x0000000804007388ULL, 0x000fe20000000c00ULL, 0x0000001d19197230ULL, 0x000fe40000000000ULL,
0x0000001c18187230ULL, 0x000fca0000000000ULL, 0x0004001804007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000002000067810ULL, 0x000fe20007ffe0ffULL, 0x00000000000c7919ULL, 0x000e620000002600ULL,
0x00000003ff0d7819ULL, 0x000fe20000011600ULL, 0x00000000000579c3ULL, 0x000ea20000002700ULL,
0x00000003ff077819ULL, 0x000fe20000011606ULL, 0x0000580000047ab9ULL, 0x000fc40000000800ULL,
0x000000010d027824ULL, 0x000fe200078e0200ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x0000000106047824ULL, 0x000fc600078e0207ULL, 0x0000000702037812ULL, 0x000fe400078ec0ffULL,
0x0000000704097812ULL, 0x000fe400078ec0ffULL, 0x0ffffff803027812ULL, 0x000fe400078ef800ULL,
0x0ffffff809047812ULL, 0x000fc600078ef806ULL, 0x0000001002027824ULL, 0x100fe400078e0205ULL,
0x0000001004047824ULL, 0x000fe400078e0205ULL, 0x000000080c147824ULL, 0x042fe200078e00ffULL,
0x0000000002087984ULL, 0x0002e20000000c00ULL, 0x000000080c0c7824ULL, 0x000fe200078e00ffULL,
0x00000005040472a4ULL, 0x004fe4000f8e023fULL, 0x0000000004107984ULL, 0x0005220000000c00ULL,
0xfffffff814037812ULL, 0x000fe200078ee20dULL, 0x000000080e0d7824ULL, 0x000fe200078e00ffULL,
0xfffffff80c077812ULL, 0x000fc400078ee207ULL, 0x0000000403037c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000407057c10ULL, 0x000fe2000ff3e0ffULL, 0x000000080e077824ULL, 0x000fe200078e00ffULL,
0xfffffff80d0d7812ULL, 0x000fe200078ee206ULL, 0x000000ffff147224ULL, 0x000fe200000e06ffULL,
0x00005a0003027a11ULL, 0x002fe200078040ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x00005a0005047a11ULL, 0x004fe400078240ffULL, 0x00005b0003037a11ULL, 0x000fc400000f4414ULL,
0xfffffff807077812ULL, 0x000fe400078ee200ULL, 0x00005b0005057a11ULL, 0x000fc600008f440cULL,
0x0000001007027825ULL, 0x000fc800078e0002ULL, 0x000000100d047825ULL, 0x000fe200078e0004ULL,
0x0000000802007986ULL, 0x008fe8000c101d06ULL, 0x0000001004007986ULL, 0x010fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00006600ff3a7624ULL, 0x000fe400078e00ffULL,
0x00006700ff3b7624ULL, 0x000fca00078e00ffULL, 0x000000063a3a7981ULL, 0x000322000c1e9900ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000001ff0600780cULL, 0x000fe20003f04070ULL,
0x0000000211117824ULL, 0x000fe200078e00ffULL, 0x00f60000ff047f8cULL, 0x000ea2000c80043fULL,
0x0000004041037824ULL, 0x000fe400078e00ffULL, 0x0000580011027a24ULL, 0x000fc800078e0212ULL,
0x0000620002177a24ULL, 0x000fc800078e0203ULL, 0x000005a000000947ULL, 0x000fea0003800000ULL,
0x00000002ff1a7819ULL, 0x000fe20000011600ULL, 0x00000080ff237424ULL, 0x000fe200078e00ffULL,
0x0000003010217812ULL, 0x000fe400078ec0ffULL, 0x000000081a127810ULL, 0x040fe20007ffe0ffULL,
0x0000000117067824ULL, 0x040fe200078e021aULL, 0x000000101a1c7810ULL, 0x040fe40007ffe0ffULL,
0x000000181a1e7810ULL, 0x040fe20007ffe0ffULL, 0x0000000117087824ULL, 0x000fe200078e0212ULL,
0x000000201a167810ULL, 0x000fe20007ffe0ffULL, 0x00005e0006067625ULL, 0x000fe200078e0023ULL,
0x00000000000b7211ULL, 0x000fc400078fe8ffULL, 0x00001000411b7811ULL, 0x000fe200078e68ffULL,
0x00005e0008087625ULL, 0x000fe200078e0023ULL, 0x00000021060c7210ULL, 0x080fe40007f1e0ffULL,
0x000000030b197812ULL, 0x000fe200078ec0ffULL, 0x00000001170a7824ULL, 0x040fe200078e021cULL,
0x0000002108107210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200000e0607ULL,
0x000000281a187810ULL, 0x000fe20007ffe0ffULL, 0x0000000117087824ULL, 0x000fe200078e021eULL,
0x0ffffffc19007812ULL, 0x000fe200078ef800ULL, 0x00005e000a067625ULL, 0x000fe200078e0023ULL,
0x00000003400a7217ULL, 0x000fc60007800000ULL, 0x000000ffff117224ULL, 0x000fe200008e0609ULL,
0x0000002106067210ULL, 0x000fe20007f1e0ffULL, 0x00005e0008087625ULL, 0x000fc800078e0023ULL,
0x000000010a0e7824ULL, 0x000fe200078e0a03ULL, 0x0000002108087210ULL, 0x000fe20007f3e0ffULL,
0x00000001170a7824ULL, 0x040fe400078e0216ULL, 0x0000000412147824ULL, 0x000fe200078e00ffULL,
0x0000000e1c00720cULL, 0x080fe20003fa6070ULL, 0x00005e000a0a7625ULL, 0x000fe200078e0023ULL,
0x0000000e1e00720cULL, 0x080fe40003f86070ULL, 0x0000000e1600720cULL, 0x080fe20003f66070ULL,
0x000000ffff097224ULL, 0x000fe200008e0609ULL, 0x0000000e1200720cULL, 0x080fe20003f26070ULL,
0x000000ffff077224ULL, 0x000fe200000e0607ULL, 0x000000210a127210ULL, 0x000fe20007f5e0ffULL,
0x00000010001d7824ULL, 0x000fe200078e021bULL, 0xfffffffc140a7812ULL, 0x000fe200078ee219ULL,
0x000000041c1c7824ULL, 0x000fe200078e00ffULL, 0x0000000e1a00720cULL, 0x0c0fe20003f06070ULL,
0x000000ffff137224ULL, 0x000fe200010e060bULL, 0x000000301a007810ULL, 0x000fe20007ffe0ffULL,
0x000000100a1f7824ULL, 0x000fe200078e021bULL, 0x000000381a1a7810ULL, 0x000fe20007ffe0ffULL,
0x00000001170a7824ULL, 0x000fe200078e0218ULL, 0x0000000e1800720cULL, 0x000fc60003f46070ULL,
0x00005e000a0a7625ULL, 0x000fc800078e0023ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c1d7faeULL, 0x0007e2000c101c46ULL, 0x000000210a147210ULL, 0x000fe20007fde0ffULL,
0x00000001170a7824ULL, 0x000fe200078e0200ULL, 0x0000000e1a00720cULL, 0x080fe20003f06070ULL,
0x00000000101f7faeULL, 0x0003e2000c901c46ULL, 0x0000000e0000720cULL, 0x000fe20003f26070ULL,
0x000000ffff157224ULL, 0x000fe400030e060bULL, 0x00005e000a0a7625ULL, 0x000fc800078e0023ULL,
0x000000041e0e7824ULL, 0x000fe200078e00ffULL, 0x000000210a0a7210ULL, 0x000fe20007fde0ffULL,
0x00000001170c7824ULL, 0x008fe400078e021aULL, 0x0000000416107824ULL, 0x002fe200078e00ffULL,
0xfffffffc0e0e7812ULL, 0x100fe200078ee219ULL, 0x0000000418167824ULL, 0x000fe400078e00ffULL,
0x0000000400187824ULL, 0x000fe200078e00ffULL, 0xfffffffc1c007812ULL, 0x100fe200078ee219ULL,
0x000000041a1a7824ULL, 0x000fe200078e00ffULL, 0xfffffffc10107812ULL, 0x100fe200078ee219ULL,
0x00005e000c0c7625ULL, 0x000fe200078e0023ULL, 0xfffffffc16167812ULL, 0x000fc400078ee219ULL,
0xfffffffc18187812ULL, 0x000fe200078ee219ULL, 0x000000ffff0b7224ULL, 0x000fe200030e060bULL,
0xfffffffc1a1a7812ULL, 0x000fe200078ee219ULL, 0x0000001000117824ULL, 0x100fe200078e021bULL,
0x000000210c0c7210ULL, 0x000fe20007fde0ffULL, 0x000000100e177824ULL, 0x100fe400078e021bULL,
0x0000001010197824ULL, 0x100fe200078e021bULL, 0x0000000006117faeULL, 0x0003e2000e901c46ULL,
0x00000010161d7824ULL, 0x100fe400078e021bULL, 0x00000010181f7824ULL, 0x100fe200078e021bULL,
0x0000000008177faeULL, 0x0003e2000e101c46ULL, 0x000000101a1b7824ULL, 0x000fc400078e021bULL,
0x000000ffff0d7224ULL, 0x000fe200030e060dULL, 0x0000000012197faeULL, 0x0003e8000d901c46ULL,
0x00000000141d7faeULL, 0x0003e8000d101c46ULL, 0x000000000a1f7faeULL, 0x0003e8000c901c46ULL,
0x000000000c1b7faeULL, 0x0003e2000c101c46ULL, 0x000004e000007947ULL, 0x000fea0003800000ULL,
0x0000001700067211ULL, 0x040fe200078ff0ffULL, 0x00000080ff277424ULL, 0x000fe200078e00ffULL,
0x0000000000077211ULL, 0x000fc400078fe8ffULL, 0x0000002800127811ULL, 0x000fe400078ff0ffULL,
0x00000003070b7812ULL, 0x000fe200078ec0ffULL, 0x00005e0006067625ULL, 0x000fe200078e0027ULL,
0x0000003010297812ULL, 0x000fe400078ec0ffULL, 0x0000000800107811ULL, 0x040fe200078ff0ffULL,
0x0000000117117824ULL, 0x040fe200078e0212ULL, 0x00000010000a7811ULL, 0x000fe200078ff0ffULL,
0x0000000412227824ULL, 0x000fe200078e00ffULL, 0x0000003000147811ULL, 0x040fe200078ff0ffULL,
0x0000000117087824ULL, 0x040fe200078e0210ULL, 0x00000020000e7811ULL, 0x000fe200078ff0ffULL,
0x00000004101c7824ULL, 0x000fe200078e00ffULL, 0x0000002906127210ULL, 0x000fe20007f1e0ffULL,
0x0000000117097824ULL, 0x040fe200078e020aULL, 0x00000018000c7811ULL, 0x040fe200078ff0ffULL,
0x0000000117187824ULL, 0x040fe200078e0214ULL, 0x0000003800167811ULL, 0x000fe200078ff0ffULL,
0x0000000414247824ULL, 0x000fe200078e00ffULL, 0xfffffffc22147812ULL, 0x000fe200078ee20bULL,
0x0000000117107824ULL, 0x000fe200078e020eULL, 0x0000100041257811ULL, 0x000fe200078e68ffULL,
0x000000ffff137224ULL, 0x000fe200000e0607ULL, 0xfffffffc24157812ULL, 0x000fe200078ee20bULL,
0x000000040a1e7824ULL, 0x000fc400078e00ffULL, 0x000000040c207824ULL, 0x000fe400078e00ffULL,
0x000000040e0e7824ULL, 0x000fe400078e00ffULL, 0x00000001171a7824ULL, 0x000fe200078e0216ULL,
0xfffffffc200d7812ULL, 0x100fe200078ee20bULL, 0x0000000416267824ULL, 0x000fe200078e00ffULL,
0x0ffffffc0b167812ULL, 0x000fe200078ef800ULL, 0x00005e0008067625ULL, 0x080fe200078e0027ULL,
0xfffffffc1c007812ULL, 0x100fe400078ee20bULL, 0xfffffffc0e0e7812ULL, 0x100fe200078ee20bULL,
0x00000001170a7824ULL, 0x000fe200078e020cULL, 0xfffffffc1e0c7812ULL, 0x100fe200078ee20bULL,
0x00005e0009087625ULL, 0x000fe200078e0027ULL, 0xfffffffc26177812ULL, 0x000fc600078ee20bULL,
0x0000001014217824ULL, 0x000fe200078e0225ULL, 0x0000002906147210ULL, 0x000fe20007f1e0ffULL,
0x00005e000a0a7625ULL, 0x000fc800078e0027ULL, 0x00000010162b7824ULL, 0x100fe200078e0225ULL,
0x0000002908167210ULL, 0x000fe20007f3e0ffULL, 0x0000001015237824ULL, 0x100fe400078e0225ULL,
0x0000001000197824ULL, 0x100fe200078e0225ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000122b7faeULL, 0x0007e2000b901c46ULL, 0x000000100c1b7824ULL, 0x100fe400078e0225ULL,
0x000000100d1d7824ULL, 0x100fe400078e0225ULL, 0x000000100e1f7824ULL, 0x000fc400078e0225ULL,
0x000000ffff157224ULL, 0x000fe200000e0607ULL, 0x000000290a0a7210ULL, 0x000fe20007f1e0ffULL,
0x0000001017257824ULL, 0x000fe400078e0225ULL, 0x000000ffff177224ULL, 0x000fe200008e0609ULL,
0x0000000014197faeULL, 0x0007e2000b901c46ULL, 0x00005e0010067625ULL, 0x000fc600078e0027ULL,
0x00000000161b7faeULL, 0x0007e2000b901c46ULL, 0x00005e0011087625ULL, 0x000fc800078e0027ULL,
0x00005e00180c7625ULL, 0x000fe200078e0027ULL, 0x0000002908087210ULL, 0x000fc60007f3e0ffULL,
0x00005e001a107625ULL, 0x000fe200078e0027ULL, 0x000000290c0c7210ULL, 0x000fc60007f5e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e060bULL, 0x0000002906067210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0609ULL, 0x0000002910107210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200010e060dULL, 0x000000000a1d7faeULL, 0x0007e2000b901c46ULL,
0x000000ffff077224ULL, 0x000fe400000e0607ULL, 0x000000ffff117224ULL, 0x000fc600018e0611ULL,
0x00000000061f7faeULL, 0x0007e8000b901c46ULL, 0x0000000008217faeULL, 0x0007e8000b901c46ULL,
0x000000000c237faeULL, 0x0007e8000b901c46ULL, 0x0000000010257faeULL, 0x0007e4000b901c46ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000067805ULL, 0x00afc40000015200ULL,
0x00f60400ff097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x006fc40007804805ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x00000008060b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e07ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011409ULL,
0x0000000b00007211ULL, 0x000fca00078110ffULL, 0x000000ffff097224ULL, 0x000fca00000e0609ULL,
0x0000000200007819ULL, 0x000fc80000001209ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f60400ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000e640000000000ULL, 0x0000002041007824ULL, 0x002fca00078e0200ULL,
0x00000003ff047819ULL, 0x000fc80000011600ULL, 0x1ffffffe04057812ULL, 0x000fe400078ec0ffULL,
0x0000000f00047812ULL, 0x000fc600078ec0ffULL, 0x0000000100057824ULL, 0x000fe400078e0205ULL,
0x0000001004077824ULL, 0x040fe400078e00ffULL, 0x0000001004047824ULL, 0x000fe200078e00ffULL,
0x0000000f05007812ULL, 0x040fe400078ec0ffULL, 0x0000000105057810ULL, 0x000fe40007ffe0ffULL,
0x000000f007007812ULL, 0x000fe400078ee200ULL, 0x0000000f05057812ULL, 0x000fc600078ec0ffULL,
0x0000000000107984ULL, 0x000e62000000cc00ULL, 0x000000f004057812ULL, 0x000fca00078ee205ULL,
0x0000000005087984ULL, 0x000ea2000000cc00ULL, 0x000000ffff147224ULL, 0x002fe400078e0010ULL,
0x000000ffff107224ULL, 0x000fe400078e0011ULL, 0x000000ffff157224ULL, 0x000fe400078e0012ULL,
0x000000ffff117224ULL, 0x000fe400078e0013ULL, 0x000000ffff167224ULL, 0x004fe400078e0008ULL,
0x000000ffff177224ULL, 0x000fc400078e000aULL, 0x000000ffff127224ULL, 0x000fe400078e0009ULL,
0x000000ffff137224ULL, 0x000fe200078e000bULL, 0x0000001400007388ULL, 0x0003e8000000cc00ULL,
0x0000001005007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f60000ff087f8cULL, 0x000ea2000c80043fULL, 0x000000ffff0a7224ULL, 0x000fc600078e00ffULL,
0x0000000000047805ULL, 0x002fc80000015200ULL, 0x00f60400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x006fc40007804809ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x00000006040b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011407ULL,
0x0000000b00007211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000200007819ULL, 0x000fc80000001207ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f60400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff0f00720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000e620000000000ULL, 0x3db504f33a3a7820ULL, 0x010fe20000410000ULL,
0x0000f68841387811ULL, 0x000fe200078e18ffULL, 0x000000ffff0e7224ULL, 0x000fe200078e00ffULL,
0xffffffff0f397810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0c7224ULL, 0x000fe200078e00ffULL,
0x0000f608410d7811ULL, 0x000fc400078e28ffULL, 0x000001000e3b7824ULL, 0x000fe200078e0203ULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x0000003b4000720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x00cfea0003800000ULL, 0x000000ffff047224ULL, 0x000fe200078e000cULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fc4000001ff00ULL, 0x000000013c057810ULL, 0x000fe20007ffe0ffULL,
0x00000a8000007945ULL, 0x000fe20003800000ULL, 0x000000ffff3d7224ULL, 0x000fc400078e003cULL,
0x0000000e05067211ULL, 0x040fe200078ff8ffULL, 0x000000ffff3c7224ULL, 0x000fe200078e0005ULL,
0x000000020500780cULL, 0x040fe40003f06070ULL, 0x00000001060c7810ULL, 0x040fe20007ffe0ffULL,
0x0000010006077824ULL, 0x000fe200078e0203ULL, 0x0000000105067812ULL, 0x000fe400078ec0ffULL,
0x0000000f0c00720cULL, 0x000fe20003f26070ULL, 0x0000620002337a24ULL, 0x000fe200078e0207ULL,
0x00000001040c7812ULL, 0x000fd600078e0cffULL, 0x0000054000009947ULL, 0x000fea0003800000ULL,
0x0000000740057217ULL, 0x000fe20007800000ULL, 0x0000000406377824ULL, 0x000fe200078e00ffULL,
0x00000002ff2a7819ULL, 0x002fe20000011600ULL, 0x0000000241367824ULL, 0x000fe200078e020cULL,
0x0000000000067211ULL, 0x000fe200078fe8ffULL, 0x0000000105057824ULL, 0x000fe200078e0a07ULL,
0x000000082a307810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff3f7424ULL, 0x000fe200078e00ffULL,
0x0000000306357812ULL, 0x000fe200078ec0ffULL, 0x000000012a067824ULL, 0x100fe200078e0233ULL,
0x000000053000720cULL, 0x0c0fe20003f46070ULL, 0x0000000130287824ULL, 0x000fe200078e0233ULL,
0x000000052a00720cULL, 0x000fe20003f26070ULL, 0x0000000430307824ULL, 0x000fe200078e00ffULL,
0xfffffffc37377812ULL, 0x000fe200078ee200ULL, 0x00005e0006067625ULL, 0x000fe200078e003fULL,
0x0000100036367811ULL, 0x000fc400078e60ffULL, 0x0ffffffc352b7812ULL, 0x000fe200078ef800ULL,
0x00005e0028287625ULL, 0x000fe200078e003fULL, 0xfffffffc30317812ULL, 0x000fe400078ee235ULL,
0x000000102a307810ULL, 0x040fe20007ffe0ffULL, 0x000000102b2b7824ULL, 0x000fe200078e0236ULL,
0x000000182a327810ULL, 0x040fe20007ffe0ffULL, 0x0000001037067825ULL, 0x000fe200078e0006ULL,
0x000000202a347810ULL, 0x040fe40007ffe0ffULL, 0x000000282a3e7810ULL, 0x040fe20007ffe0ffULL,
0x0000001031317824ULL, 0x000fe200078e0236ULL, 0x000000302a427810ULL, 0x040fe20007ffe0ffULL,
0x0000001037287825ULL, 0x000fe200078e0028ULL, 0x000000382a447810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000062b7faeULL, 0x0003e2000c901c46ULL,
0x000000053000720cULL, 0x0c0fe20003f26070ULL, 0x0000000430467824ULL, 0x000fe200078e00ffULL,
0x000000053400720cULL, 0x080fe20003f66070ULL, 0x0000000028317faeULL, 0x0005e2000d101c46ULL,
0x000000053200720cULL, 0x0c0fe20003f46070ULL, 0x0000000432487824ULL, 0x000fe200078e00ffULL,
0x000000053e00720cULL, 0x080fe20003f86070ULL, 0x00000001342a7824ULL, 0x100fe200078e0233ULL,
0x000000054200720cULL, 0x080fe20003fa6070ULL, 0x00000004344a7824ULL, 0x000fe200078e00ffULL,
0x000000054400720cULL, 0x000fe20003fc6070ULL, 0x0000000130067824ULL, 0x002fe200078e0233ULL,
0xfffffffc46057812ULL, 0x000fe200078ee235ULL, 0x000000013e307824ULL, 0x000fe200078e0233ULL,
0xfffffffc48437812ULL, 0x000fe200078ee235ULL, 0x0000000132287824ULL, 0x004fe200078e0233ULL,
0xfffffffc4a457812ULL, 0x000fe200078ee235ULL, 0x0000000142327824ULL, 0x000fc400078e0233ULL,
0x0000000144347824ULL, 0x000fe400078e0233ULL, 0x000000043e3e7824ULL, 0x000fe400078e00ffULL,
0x0000000442427824ULL, 0x000fe400078e00ffULL, 0x0000000444447824ULL, 0x000fe200078e00ffULL,
0xfffffffc3e477812ULL, 0x100fe200078ee235ULL, 0x00005e0006067625ULL, 0x080fe200078e003fULL,
0xfffffffc42497812ULL, 0x100fe400078ee235ULL, 0xfffffffc444b7812ULL, 0x000fe200078ee235ULL,
0x00005e0028287625ULL, 0x000fc800078e003fULL, 0x00005e002a2a7625ULL, 0x000fc800078e003fULL,
0x00005e0030307625ULL, 0x000fc800078e003fULL, 0x00005e0032327625ULL, 0x000fc800078e003fULL,
0x00005e0034347625ULL, 0x000fc800078e003fULL, 0x0000001037067825ULL, 0x000fc800078e0006ULL,
0x0000001037287825ULL, 0x000fc800078e0028ULL, 0x00000010372a7825ULL, 0x000fc800078e002aULL,
0x0000001037307825ULL, 0x000fc800078e0030ULL, 0x0000001037327825ULL, 0x000fc800078e0032ULL,
0x0000001037347825ULL, 0x000fc800078e0034ULL, 0x0000001005057824ULL, 0x100fe400078e0236ULL,
0x0000001043377824ULL, 0x100fe400078e0236ULL, 0x00000010453f7824ULL, 0x100fe200078e0236ULL,
0x0000000006057faeULL, 0x0003e2000c901c46ULL, 0x0000001047437824ULL, 0x100fe400078e0236ULL,
0x0000001049457824ULL, 0x100fe200078e0236ULL, 0x0000000028377faeULL, 0x0003e2000d101c46ULL,
0x000000104b477824ULL, 0x000fc600078e0236ULL, 0x000000002a3f7faeULL, 0x0003e8000d901c46ULL,
0x0000000030437faeULL, 0x0003e8000e101c46ULL, 0x0000000032457faeULL, 0x0003e8000e901c46ULL,
0x0000000034477faeULL, 0x0003e2000f101c46ULL, 0x0000048000007947ULL, 0x000fea0003800000ULL,
0x0000000241287824ULL, 0x000fe200078e020cULL, 0x00000008002a7811ULL, 0x002fe200078ff0ffULL,
0x0000000406057824ULL, 0x000fe200078e00ffULL, 0x0000001000307811ULL, 0x040fe200078ff0ffULL,
0x00000080ff3f7424ULL, 0x000fe200078e00ffULL, 0x0000001800327811ULL, 0x000fe200078ff0ffULL,
0x000000042a447824ULL, 0x000fe200078e00ffULL, 0x0000002000347811ULL, 0x000fe200078ff0ffULL,
0x0000000430467824ULL, 0x000fe200078e00ffULL, 0x0000002800367811ULL, 0x000fe200078ff0ffULL,
0x0000000432487824ULL, 0x000fe200078e00ffULL, 0x00000030003e7811ULL, 0x000fe200078ff0ffULL,
0x00000004344a7824ULL, 0x000fe200078e00ffULL, 0x0000003800427811ULL, 0x000fe200078ff0ffULL,
0x00000004364c7824ULL, 0x000fe200078e00ffULL, 0x00001000284d7811ULL, 0x000fe200078e60ffULL,
0x000000012a287824ULL, 0x100fe200078e0233ULL, 0x0000000000077211ULL, 0x000fe200078fe8ffULL,
0x00000001302a7824ULL, 0x100fe200078e0233ULL, 0x0000003300067211ULL, 0x000fe200078ff0ffULL,
0x0000000132307824ULL, 0x100fe200078e0233ULL, 0x0000000307297812ULL, 0x000fe200078ec0ffULL,
0x0000000134327824ULL, 0x000fe200078e0233ULL, 0xfffffffc05057812ULL, 0x000fe200078ee200ULL,
0x000000043e4e7824ULL, 0x000fe200078e00ffULL, 0xfffffffc44447812ULL, 0x100fe200078ee229ULL,
0x0000000442507824ULL, 0x000fe200078e00ffULL, 0xfffffffc46467812ULL, 0x000fe200078ee229ULL,
0x0000000136347824ULL, 0x000fe200078e0233ULL, 0xfffffffc48487812ULL, 0x000fe200078ee229ULL,
0x000000013e367824ULL, 0x000fe200078e0233ULL, 0xfffffffc4a4a7812ULL, 0x000fe200078ee229ULL,
0x00000001423e7824ULL, 0x000fe200078e0233ULL, 0xfffffffc4c4c7812ULL, 0x100fe200078ee229ULL,
0x00005e0006067625ULL, 0x000fe200078e003fULL, 0xfffffffc4e4e7812ULL, 0x000fc400078ee229ULL,
0xfffffffc50507812ULL, 0x000fe200078ee229ULL, 0x00005e002a2a7625ULL, 0x000fe200078e003fULL,
0x0ffffffc29427812ULL, 0x000fc600078ef800ULL, 0x00005e0028287625ULL, 0x000fc800078e003fULL,
0x00005e0030307625ULL, 0x000fc800078e003fULL, 0x00005e0032327625ULL, 0x000fc800078e003fULL,
0x00005e0034347625ULL, 0x000fc800078e003fULL, 0x00005e0036367625ULL, 0x000fc800078e003fULL,
0x00005e003e3e7625ULL, 0x000fc800078e003fULL, 0x0000001005067825ULL, 0x000fc800078e0006ULL,
0x0000001005287825ULL, 0x000fc800078e0028ULL, 0x00000010052a7825ULL, 0x000fc800078e002aULL,
0x0000001005307825ULL, 0x000fc800078e0030ULL, 0x0000001005327825ULL, 0x000fc800078e0032ULL,
0x0000001005347825ULL, 0x000fc800078e0034ULL, 0x0000001005367825ULL, 0x000fc800078e0036ULL,
0x00000010053e7825ULL, 0x000fc800078e003eULL, 0x00000010424f7824ULL, 0x100fe400078e024dULL,
0x0000001044057824ULL, 0x100fe400078e024dULL, 0x0000001046437824ULL, 0x100fe200078e024dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000064f7faeULL, 0x0003e2000b901c46ULL,
0x0000001048457824ULL, 0x100fe400078e024dULL, 0x000000104a477824ULL, 0x100fe200078e024dULL,
0x0000000028057faeULL, 0x0003e2000b901c46ULL, 0x000000104c497824ULL, 0x000fc400078e024dULL,
0x000000104e4b7824ULL, 0x100fe200078e024dULL, 0x000000002a437faeULL, 0x0003e2000b901c46ULL,
0x00000010504d7824ULL, 0x000fc600078e024dULL, 0x0000000030457faeULL, 0x0003e8000b901c46ULL,
0x0000000032477faeULL, 0x0003e8000b901c46ULL, 0x0000000034497faeULL, 0x0003e8000b901c46ULL,
0x00000000364b7faeULL, 0x0003e8000b901c46ULL, 0x000000003e4d7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000002000057810ULL, 0x042fe20007ffe0ffULL, 0x0000000241427824ULL, 0x000fe200078e0204ULL,
0xfffffff8003f7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff3e7224ULL, 0x000fe200078e00ffULL,
0xfffffff805057812ULL, 0x000fc400078ec0ffULL, 0x0000000700437812ULL, 0x000fe400078ec0ffULL,
0x000000073f3f7812ULL, 0x100fe400078ef800ULL, 0x0000000705447812ULL, 0x100fe400078ef800ULL,
0x0000100042427811ULL, 0x000fe400078e60ffULL, 0x0000000843437812ULL, 0x000fe400078ef800ULL,
0x00000001ff457819ULL, 0x000fc4000001163fULL, 0x00000001ff477819ULL, 0x000fe20000011644ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000043d317824ULL, 0x100fe200078e023eULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000145047824ULL, 0x020fe200078e023eULL,
0x000000013e467810ULL, 0x000fe20007ffe0ffULL, 0x000000043f057824ULL, 0x000fe400078e00ffULL,
0x0000000231317824ULL, 0x000fe400078e00ffULL, 0x0000001043077824ULL, 0x000fe200078e00ffULL,
0xfffffffc05057812ULL, 0x000fe200078ee204ULL, 0x0000000147307824ULL, 0x000fe200078e023eULL,
0x0000003100047211ULL, 0x000fe200078fe0ffULL, 0x0000000444337824ULL, 0x000fe200078e00ffULL,
0x0000000231317810ULL, 0x000fe20007ffe0ffULL, 0x0000001005057824ULL, 0x000fe200078e0242ULL,
0x000000023e3e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000143047824ULL, 0x000fe200078e0204ULL,
0xfffffffc33337812ULL, 0x000fc400078ee230ULL, 0x000000043e00780cULL, 0x000fe40003f25270ULL,
0xfffffff007287812ULL, 0x000fe200078ee204ULL, 0x0000001033337824ULL, 0x000fe200078e0242ULL,
0x000000000504783bULL, 0x000e660000000200ULL, 0x0000001028287824ULL, 0x000fe200078e00ffULL,
0x000000003334783bULL, 0x000fea0000000200ULL, 0x000000002828783bULL, 0x000ea20000000200ULL,
0x00000004ff48723eULL, 0x002fc400020006ffULL, 0x00000004ff49723eULL, 0x000fe400030006ffULL,
0x00000005ff04723eULL, 0x080fe400020006ffULL, 0x00000005ff05723eULL, 0x000fc600030006ffULL,
0x000000482824723cULL, 0x044b6e0000001824ULL, 0x000000043f497824ULL, 0x020fe200078e00ffULL,
0x000000042820723cULL, 0x000b620000001820ULL, 0x00000034ff48723eULL, 0x000fcc00020006ffULL,
0x00000006ff04723eULL, 0x0a0fe400020006ffULL, 0x00000006ff05723eULL, 0x000fe200030006ffULL,
0x0000000145067824ULL, 0x100fe400078e0246ULL, 0x0000000147467824ULL, 0x000fc600078e0246ULL,
0xfffffffc49337812ULL, 0x000fe200078ee206ULL, 0x00000004281c723cULL, 0x040b62000000181cULL,
0x00000034ff49723eULL, 0x000fe400030006ffULL, 0x00000035ff34723eULL, 0x080fe200020006ffULL,
0x0000001033337824ULL, 0x000fe200078e0242ULL, 0x00000035ff35723eULL, 0x000fe400030006ffULL,
0x0000003100047211ULL, 0x020fe200078fe0ffULL, 0x0000001043057824ULL, 0x040fe200078e00ffULL,
0x00000007ff06723eULL, 0x080fe200020006ffULL, 0x000000482818723cULL, 0x040be20000001818ULL,
0x00000007ff07723eULL, 0x000fe200030006ffULL, 0x0000000143047824ULL, 0x000fe200078e0204ULL,
0x000000003330783bULL, 0x000e680000000200ULL, 0xfffffff005047812ULL, 0x000fe200078ee204ULL,
0x0000000444497824ULL, 0x020fe200078e00ffULL, 0x000000342814723cULL, 0x000be20000001814ULL,
0x00000037ff48723eULL, 0x000fc400020006ffULL, 0x0000001004047824ULL, 0x000fe200078e00ffULL,
0xfffffffc49497812ULL, 0x000fc600078ee246ULL, 0x00000036ff34723eULL, 0x0a0fe200020006ffULL,
0x00000006282c723cULL, 0x040b62000000182cULL, 0x00000036ff35723eULL, 0x000fe200030006ffULL,
0x000000000404783bULL, 0x020eac0000000200ULL, 0x000000342810723cULL, 0x000b6e0000001810ULL,
0x0000001049347824ULL, 0x020fe200078e0242ULL, 0x00000037ff49723eULL, 0x000fca00030006ffULL,
0x000000003434783bULL, 0x000ee40000000200ULL, 0x000000482808723cULL, 0x000b6e0000001808ULL,
0x00000030ff28723eULL, 0x0a2fe400020006ffULL, 0x00000030ff29723eULL, 0x000fc400030006ffULL,
0x00000031ff30723eULL, 0x080fe400020006ffULL, 0x00000031ff31723eULL, 0x000fc600030006ffULL,
0x000000280424723cULL, 0x044b6e0000001824ULL, 0x00000032ff28723eULL, 0x0a0fe200020006ffULL,
0x000000300420723cULL, 0x000f620000001820ULL, 0x00000032ff29723eULL, 0x000fe400030006ffULL,
0x00000033ff32723eULL, 0x000fc400020006ffULL, 0x00000033ff33723eULL, 0x000fc600030006ffULL,
0x00000028041c723cULL, 0x040b6e000000181cULL, 0x00000034ff28723eULL, 0x0a8fe200020006ffULL,
0x00000032042c723cULL, 0x000f62000000182cULL, 0x00000034ff29723eULL, 0x000fe400030006ffULL,
0x00000035ff34723eULL, 0x000fc400020006ffULL, 0x00000035ff35723eULL, 0x000fc600030006ffULL,
0x000000280418723cULL, 0x040b6e0000001818ULL, 0x00000036ff28723eULL, 0x0a0fe200020006ffULL,
0x000000340414723cULL, 0x000b620000001814ULL, 0x00000036ff29723eULL, 0x000fe400030006ffULL,
0x00000037ff36723eULL, 0x000fc400020006ffULL, 0x00000037ff37723eULL, 0x000fc600030006ffULL,
0x000000280410723cULL, 0x040b700000001810ULL, 0x000000360408723cULL, 0x000b620000001808ULL,
0xfffffa8000001947ULL, 0x000fce000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff047224ULL, 0x020fe200078e000cULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffeec000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x0000003a24247220ULL, 0x080fe20000410000ULL, 0x0000003a25257220ULL, 0x080fe20000410000ULL,
0x0000003a2d2d7220ULL, 0x080fe20000410000ULL, 0x0000003a19197220ULL, 0x080fe20000410000ULL,
0x0000003a26067220ULL, 0x080fe20000410000ULL, 0x0000003a2c287220ULL, 0x080fe20000410000ULL,
0x0000003a27077220ULL, 0x080fe20000410000ULL, 0x0000003a1c2a7220ULL, 0x080fe20000410000ULL,
0x0000003a1d267220ULL, 0x080fe20000410000ULL, 0x0000003a2e2c7220ULL, 0x080fe20000410000ULL,
0x0000003a2f327220ULL, 0x080fe20000410000ULL, 0x0000003a20277220ULL, 0x080fe20000410000ULL,
0x0000003a212b7220ULL, 0x080fe20000410000ULL, 0x0000003a22307220ULL, 0x080fe20000410000ULL,
0x0000003a23317220ULL, 0x080fe20000410000ULL, 0x0000003a1e1c7220ULL, 0x080fe20000410000ULL,
0x0000003a1f1d7220ULL, 0x080fe20000410000ULL, 0x0000003a18297220ULL, 0x080fe20000410000ULL,
0x000000ffff2f7224ULL, 0x000fe200078e0024ULL, 0x0000003a1a1a7220ULL, 0x080fe20000410000ULL,
0x000000ffff2e7224ULL, 0x000fe200078e0025ULL, 0x0000003a1b1b7220ULL, 0x080fe20000410000ULL,
0x0000003a14237220ULL, 0x080fe20000410000ULL, 0x0000003a15227220ULL, 0x080fe20000410000ULL,
0x0000003a16187220ULL, 0x080fe20000410000ULL, 0x0000003a17337220ULL, 0x080fe20000410000ULL,
0x0000003a10217220ULL, 0x080fe20000410000ULL, 0x0000003a11207220ULL, 0x080fe20000410000ULL,
0x0000003a12347220ULL, 0x080fe20000410000ULL, 0x0000003a13357220ULL, 0x080fe20000410000ULL,
0x0000003a081f7220ULL, 0x080fe20000410000ULL, 0x0000003a091e7220ULL, 0x080fe20000410000ULL,
0x0000003a0a367220ULL, 0x080fe20000410000ULL, 0x0000003a0b377220ULL, 0x000fe20000410000ULL,
0x000000ffff257224ULL, 0x000fc400078e002dULL, 0x000000ffff247224ULL, 0x000fe200078e0019ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000038047f8cULL, 0x0002a2000c80043fULL,
0x000000ffff137224ULL, 0x000fe400078e001cULL, 0x000000ffff147224ULL, 0x000fe400078e001dULL,
0x000000ffff177224ULL, 0x000fe400078e001aULL, 0x000000ffff127224ULL, 0x000fe400078e001bULL,
0x000000ffff087224ULL, 0x000fc400078e0006ULL, 0x000000ffff097224ULL, 0x000fe400078e0007ULL,
0x000000ffff0a7224ULL, 0x000fe400078e0030ULL, 0x000000ffff0b7224ULL, 0x000fe400078e0031ULL,
0x000000ffff157224ULL, 0x000fe400078e002cULL, 0x000000ffff167224ULL, 0x000fe400078e0032ULL,
0x000000ffff107224ULL, 0x000fc400078e0018ULL, 0x000000ffff117224ULL, 0x000fe400078e0033ULL,
0x000000ffff1a7224ULL, 0x000fe400078e0034ULL, 0x000000ffff1b7224ULL, 0x000fe400078e0035ULL,
0x000000ffff1c7224ULL, 0x000fe400078e0036ULL, 0x000000ffff1d7224ULL, 0x000fc400078e0037ULL,
0x0000000000067805ULL, 0x006fca0000015200ULL, 0x0000040038197984ULL, 0x000e640000000800ULL,
0x8000000019ff7812ULL, 0x002fc40007804805ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff2c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000187805ULL, 0x000fcc0000015200ULL,
0x00000018062d7210ULL, 0x000fca0007f1e1ffULL, 0x0000000119197824ULL, 0x000fe200000e0e07ULL,
0x003d09002d00780cULL, 0x000fc80003f06070ULL, 0x000000ff1900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402d00780cULL, 0x000fc80003f06070ULL,
0x000000ff1900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff187819ULL, 0x000fc80000011419ULL, 0x0000002d18187211ULL, 0x000fca00078110ffULL,
0x000000ffff197224ULL, 0x000fca00000e0619ULL, 0x0000000218187819ULL, 0x000fc80000001219ULL,
0x000000180000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012c2c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040038197984ULL, 0x000e640000000800ULL, 0x8000000019ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000400197824ULL, 0x000fe200078e00ffULL,
0x000000390e00720cULL, 0x000fc80003f05270ULL, 0xfffffff019187812ULL, 0x000fca00078ec0ffULL,
0x0000008041187824ULL, 0x000fca00078e0218ULL, 0x00f4000018047984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x00000002002c7824ULL, 0x000fe400078e00ffULL,
0x00000001403b7824ULL, 0x000fc600078e0a3bULL, 0x000000062c2c7812ULL, 0x000fc800078ec0ffULL,
0x000000012c307812ULL, 0x040fe400078efcffULL, 0x000000082c327812ULL, 0x000fe400078efcffULL,
0x0000003b3000720cULL, 0x080fe40003f26070ULL, 0x000000102c307812ULL, 0x000fe400078efcffULL,
0x0000003b3200720cULL, 0x080fe40003f06070ULL, 0x0000003b3000720cULL, 0x000fc40003fc6070ULL,
0x000000112c327812ULL, 0x040fe400078efcffULL, 0x000000182c307812ULL, 0x040fe400078efcffULL,
0x0000003b2c00720cULL, 0x080fe40003f46070ULL, 0x0000003b3200720cULL, 0x080fe40003fa6070ULL,
0x0000003b3000720cULL, 0x000fe40003f66070ULL, 0x000000092c347812ULL, 0x000fc400078efcffULL,
0x000000192c327812ULL, 0x040fe400078efcffULL, 0x000000202c307812ULL, 0x000fe400078efcffULL,
0xff80000008087808ULL, 0x000fe40005000000ULL, 0xff8000002f2f7808ULL, 0x000fe40005000000ULL,
0xff80000009097808ULL, 0x000fe40004800000ULL, 0xff8000002e2e7808ULL, 0x000fc40004800000ULL,
0x0000003b3400720cULL, 0x080fe40003f86070ULL, 0x0000003b3200720cULL, 0x080fe40003f46070ULL,
0x0000003b3000720cULL, 0x000fe40003f26070ULL, 0x000000212c327812ULL, 0x040fe400078efcffULL,
0x000000282c307812ULL, 0x000fe400078efcffULL, 0xff8000000a0a7808ULL, 0x000fc40004000000ULL,
0xff80000027277808ULL, 0x000fe40004000000ULL, 0xff8000000b0b7808ULL, 0x000fe40006000000ULL,
0xff8000002b2b7808ULL, 0x000fe40006000000ULL, 0x0000003b3200720cULL, 0x080fe40003f06070ULL,
0x0000003b3000720cULL, 0x000fe40003f86070ULL, 0x000000292c327812ULL, 0x000fc400078efcffULL,
0x000000302c307812ULL, 0x000fe400078efcffULL, 0xff80000013137808ULL, 0x000fe40007000000ULL,
0xff8000002a2a7808ULL, 0x000fe40007000000ULL, 0xff80000014147808ULL, 0x000fe40006800000ULL,
0xff80000026267808ULL, 0x000fe40006800000ULL, 0x0000003b3200720cULL, 0x000fc40003fc6070ULL,
0x0000003b3000720cULL, 0x000fe40003fa6070ULL, 0x000000312c327812ULL, 0x040fe400078efcffULL,
0x000000382c307812ULL, 0x040fe400078efcffULL, 0x000000392c2c7812ULL, 0x000fe400078efcffULL,
0xff80000015157808ULL, 0x000fe40005800000ULL, 0xff80000028287808ULL, 0x000fc40005800000ULL,
0xff80000016167808ULL, 0x000fe40005000000ULL, 0xff80000025257808ULL, 0x000fe40005000000ULL,
0xff80000017177808ULL, 0x000fe40004800000ULL, 0xff80000029297808ULL, 0x000fe40004800000ULL,
0x0000003b3200720cULL, 0x080fe40003f66070ULL, 0x0000003b3000720cULL, 0x000fc40003f46070ULL,
0x0000003b2c00720cULL, 0x000fe40003f26070ULL, 0xff80000012127808ULL, 0x000fe40004000000ULL,
0xff80000024247808ULL, 0x000fe40004000000ULL, 0xff80000010107808ULL, 0x000fe40006000000ULL,
0xff80000023237808ULL, 0x000fe40006000000ULL, 0xff80000011117808ULL, 0x000fc40007000000ULL,
0xff80000022227808ULL, 0x000fe40007000000ULL, 0xff8000001a1a7808ULL, 0x000fe40006800000ULL,
0xff80000021217808ULL, 0x000fe40006800000ULL, 0xff8000001b1b7808ULL, 0x000fe40005800000ULL,
0xff80000020207808ULL, 0x000fe40005800000ULL, 0xff8000001c1c7808ULL, 0x000fc40005000000ULL,
0xff8000001f1f7808ULL, 0x000fe40005000000ULL, 0xff8000001d1d7808ULL, 0x000fe40004800000ULL,
0xff8000001e1e7808ULL, 0x000fc40004800000ULL, 0x0000002f0400720bULL, 0x004fe20003f1e000ULL,
0x0000001fff367424ULL, 0x000fe200078e00ffULL, 0x000000080500720bULL, 0x000fe20003f3e000ULL,
0xffffffffff377424ULL, 0x000fe200078e00ffULL, 0x000000042f2d7208ULL, 0x000fe40004000000ULL,
0x0000000508047208ULL, 0x000fc40004800000ULL, 0x0000002e2d00720bULL, 0x000fe40003f1e000ULL,
0x000000090400720bULL, 0x000fe40003f3e000ULL, 0x0000002d2e2c7208ULL, 0x000fe40004000000ULL,
0x0000000409057208ULL, 0x000fe40004800000ULL, 0x000000272c00720bULL, 0x000fe40003f1e000ULL,
0x0000000a0500720bULL, 0x000fc40003f3e000ULL, 0x0000002c272c7208ULL, 0x000fe40004000000ULL,
0x000000050a047208ULL, 0x000fe40004800000ULL, 0x0000002b2c00720bULL, 0x000fe40003f1e000ULL,
0x0000000b0400720bULL, 0x000fe40003f3e000ULL, 0x0000002c2b057208ULL, 0x000fe40004000000ULL,
0x000000040b047208ULL, 0x000fc40004800000ULL, 0x0000002a0500720bULL, 0x000fe40003f1e000ULL,
0x000000130400720bULL, 0x000fe40003f3e000ULL, 0x000000052a057208ULL, 0x000fe40004000000ULL,
0x00000004132d7208ULL, 0x000fe40004800000ULL, 0x000000260500720bULL, 0x000fe40003f1e000ULL,
0x000000142d00720bULL, 0x000fc40003f3e000ULL, 0x0000000526057208ULL, 0x000fe40004000000ULL,
0x0000002d14047208ULL, 0x000fe40004800000ULL, 0x000000280500720bULL, 0x000fe40003f1e000ULL,
0x000000150400720bULL, 0x000fe40003f3e000ULL, 0x00000005282c7208ULL, 0x000fe40004000000ULL,
0x0000000415057208ULL, 0x000fc40004800000ULL, 0x000000252c00720bULL, 0x000fe40003f1e000ULL,
0x000000160500720bULL, 0x000fe40003f3e000ULL, 0x0000002c252c7208ULL, 0x000fe40004000000ULL,
0x0000000516047208ULL, 0x000fe40004800000ULL, 0x000000292c00720bULL, 0x000fe40003f1e000ULL,
0x000000170400720bULL, 0x000fc40003f3e000ULL, 0x0000002c29057208ULL, 0x000fe40004000000ULL,
0x00000004172d7208ULL, 0x000fe40004800000ULL, 0x000000240500720bULL, 0x000fe40003f1e000ULL,
0x000000122d00720bULL, 0x000fe40003f3e000ULL, 0x0000000524047208ULL, 0x000fe40004000000ULL,
0x0000002d122d7208ULL, 0x000fc40004800000ULL, 0x000000230400720bULL, 0x000fe40003f1e000ULL,
0x000000102d00720bULL, 0x000fe40003f3e000ULL, 0x0000000423057208ULL, 0x000fe40004000000ULL,
0x0000002d10047208ULL, 0x000fe40004800000ULL, 0x000000220500720bULL, 0x000fe40003f1e000ULL,
0x000000110400720bULL, 0x000fc40003f3e000ULL, 0x00000005222c7208ULL, 0x000fe40004000000ULL,
0x0000000411057208ULL, 0x000fe40004800000ULL, 0x000000212c00720bULL, 0x000fe40003f1e000ULL,
0x0000001a0500720bULL, 0x000fe40003f3e000ULL, 0x0000002c212d7208ULL, 0x000fe40004000000ULL,
0x000000051a047208ULL, 0x000fc40004800000ULL, 0x000000202d00720bULL, 0x000fe40003f1e000ULL,
0x0000001b0400720bULL, 0x000fe40003f3e000ULL, 0x0000002d202c7208ULL, 0x000fe40004000000ULL,
0x000000041b057208ULL, 0x000fe40004800000ULL, 0x0000001f2c00720bULL, 0x000fe40003f1e000ULL,
0x0000001c0500720bULL, 0x000fc40003f3e000ULL, 0x0000002c1f2d7208ULL, 0x000fe40004000000ULL,
0x000000051c047208ULL, 0x000fe40004800000ULL, 0x0000001e2d00720bULL, 0x000fe40003f1e000ULL,
0x0000001d0400720bULL, 0x000fe40003f3e000ULL, 0x0000002d1e327208ULL, 0x000fe40004000000ULL,
0x000000041d347208ULL, 0x000fe20004800000ULL, 0x000014d27f007947ULL, 0x000fec000b800000ULL,
0x0c401f0032047f89ULL, 0x0004e400000e0000ULL, 0x000000043200720bULL, 0x008fc80003f1e000ULL,
0x0000003204357208ULL, 0x000fe20004000000ULL, 0x000014e27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0034047f89ULL, 0x000ee800000e0000ULL, 0x0c401f0006057f89ULL, 0x000f2800000e0000ULL,
0x0c401f00072c7f89ULL, 0x000e6200000e0000ULL, 0x000000043400720bULL, 0x008fc40003f1e000ULL,
0x000000050600720bULL, 0x010fe40003f3e000ULL, 0x0000003404307208ULL, 0x000fe40004000000ULL,
0x0000000605317208ULL, 0x000fe20004800000ULL, 0x0c201f0035047f89ULL, 0x000ee200000e0000ULL,
0x0000002c0700720bULL, 0x002fc60003f1e000ULL, 0x0c201f0030057f89ULL, 0x000e6200000e0000ULL,
0x000000072c2c7208ULL, 0x000fc60004000000ULL, 0x0c201f0031327f89ULL, 0x004ea800000e0000ULL,
0x0c201f002c2d7f89ULL, 0x0002a200000e0000ULL, 0x000000043500720bULL, 0x008fe40003f1e000ULL,
0x000000053000720bULL, 0x002fe40003f3e000ULL, 0x0000003504047208ULL, 0x000fe40004000000ULL,
0x000000323100720bULL, 0x004fc40003f5e000ULL, 0x0000003005057208ULL, 0x000fe40004800000ULL,
0x0000003132067208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b04307820ULL, 0x000fe20000410000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000c19197812ULL, 0x000fe400078ec0ffULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010830ULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010830ULL,
0x3fb8aa3b28077823ULL, 0x100fe20000010830ULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe20000010830ULL,
0x0000002700317308ULL, 0x0007e20000000800ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe20000010830ULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe20000010830ULL, 0x3fb8aa3b25357823ULL, 0x100fe20000010830ULL,
0x3fb8aa3b24287823ULL, 0x100fe20000010830ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010830ULL,
0x3fb8aa3b29257823ULL, 0x100fe20000010830ULL, 0x3fb8aa3b22227823ULL, 0x100fe20000010830ULL,
0x0000002600337308ULL, 0x0023e20000000800ULL, 0x3fb8aa3b23277823ULL, 0x108fe20000010830ULL,
0x3fb8aa3b1e237823ULL, 0x100fe20000010830ULL, 0x3fb8aa3b051e7820ULL, 0x000fe20000410000ULL,
0x3fb8aa3b21247823ULL, 0x000fe20000010830ULL, 0x0000000300ff7812ULL, 0x000fc4000780c0ffULL,
0x3fb8aa3b08087823ULL, 0x100fe2000001081eULL, 0x3fb8aa3b09097823ULL, 0x100fe2000001081eULL,
0x3fb8aa3b0a0a7823ULL, 0x100fe2000001081eULL, 0x3fb8aa3b0b0b7823ULL, 0x000fe2000001081eULL,
0x0000000700347308ULL, 0x0007e20000000800ULL, 0x3fb8aa3b1f267823ULL, 0x002fe20000010830ULL,
0x3fb8aa3b13137823ULL, 0x100fe2000001081eULL, 0x3fb8aa3b14147823ULL, 0x100fe2000001081eULL,
0x3fb8aa3b15157823ULL, 0x100fe2000001081eULL, 0x3fb8aa3b16167823ULL, 0x100fe2000001081eULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe2000001081eULL, 0x3fb8aa3b1b1b7823ULL, 0x000fe2000001081eULL,
0x00000008001f7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b20077823ULL, 0x008fe20000010830ULL,
0x0000002d2c00720bULL, 0x004fcc0003f3e000ULL, 0x0000000900207308ULL, 0x000e700000000800ULL,
0x0000000a00217308ULL, 0x000ff00000000800ULL, 0x0000000b00307308ULL, 0x000ea20000000800ULL,
0x0000001f2009723eULL, 0x002fe200000000ffULL, 0x3c003c00ff207424ULL, 0x000fe200078e00ffULL,
0x3fb8aa3b121f7823ULL, 0x000fca000001081eULL, 0x0000002f002f7308ULL, 0x000ff00000000800ULL,
0x0000002e002e7308ULL, 0x000e620000000800ULL, 0x00000021300b723eULL, 0x004fe200000000ffULL,
0x3c003c00ff217424ULL, 0x000fe200078e00ffULL, 0x3fb8aa3b11307823ULL, 0x000fca000001081eULL,
0x0000002b00327308ULL, 0x0004e20000000800ULL, 0x0000002f2e08723eULL, 0x002fce00000000ffULL,
0x0000001400367308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b172b7823ULL, 0x104fe2000001081eULL,
0x3fb8aa3b102f7823ULL, 0x000fe2000001081eULL, 0x00000031320a723eULL, 0x008fca00000000ffULL,
0x0000001500297308ULL, 0x000ff00000000800ULL, 0x00000016003c7308ULL, 0x0003f00000000800ULL,
0x0000001300137308ULL, 0x000ea20000000800ULL, 0x000000200814723cULL, 0x002f6e00000018ffULL,
0x0000002a002a7308ULL, 0x000e700000000800ULL, 0x0000003500357308ULL, 0x000ee20000000800ULL,
0x000000133611723eULL, 0x004fc400000000ffULL, 0x000000293c13723eULL, 0x000fe200000000ffULL,
0x3fb8aa3b1c297823ULL, 0x000fe2000001081eULL, 0x0000002a3310723eULL, 0x002fc600000000ffULL,
0x0000001f002e7308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b1d2a7823ULL, 0x000fe2000001081eULL,
0x000000343512723eULL, 0x008fcc00000000ffULL, 0x0000002500257308ULL, 0x000fe20000000800ULL,
0x00000002ff357819ULL, 0x000fc80000011600ULL, 0x0000000135317810ULL, 0x040fe20007ffe0ffULL,
0x00000020101c723cULL, 0x022b620000001814ULL, 0x00000008353c7824ULL, 0x040fe200078e00ffULL,
0x0000002800287308ULL, 0x000e620000000800ULL, 0x0000000835327824ULL, 0x040fe200078e00ffULL,
0x0000000235337810ULL, 0x040fe20007ffe0ffULL, 0x0000000835347824ULL, 0x040fe200078e00ffULL,
0x00000008353e7810ULL, 0x040fe20007ffe0ffULL, 0x0000000835177824ULL, 0x060fe200078e00ffULL,
0x0000000335147810ULL, 0x040fe40007ffe0ffULL, 0x0000002700277308ULL, 0x000fe20000000800ULL,
0x0000000435157810ULL, 0x000fc40007ffe0ffULL, 0xfffffff817367812ULL, 0x000fe400078ee214ULL,
0xfffffff83c3c7812ULL, 0x000fe400078ee215ULL, 0xfffffff832327812ULL, 0x000fe200078ee231ULL,
0x0000002200227308ULL, 0x000ea20000000800ULL, 0x000000252814723eULL, 0x002fe200000000ffULL,
0x0000000835287824ULL, 0x040fe200078e00ffULL, 0x0000000535257810ULL, 0x000fe40007ffe0ffULL,
0xfffffff834347812ULL, 0x000fc400078ee233ULL, 0xfffffff828287812ULL, 0x000fe200078ee225ULL,
0x0000002b002b7308ULL, 0x000e700000000800ULL, 0x0000002f002f7308ULL, 0x000fe20000000800ULL,
0x000000272216723eULL, 0x004fe200000000ffULL, 0x0000000835227824ULL, 0x040fe200078e00ffULL,
0x0000000635277810ULL, 0x000fc80007ffe0ffULL, 0xfffffff822227812ULL, 0x000fe200078ee235ULL,
0x0000003000307308ULL, 0x000ea20000000800ULL, 0x0000002b2e15723eULL, 0x002fe200000000ffULL,
0x00000008352e7824ULL, 0x040fe200078e00ffULL, 0xffffffff352b7810ULL, 0x000fc80007ffe0ffULL,
0xfffffff82e2e7812ULL, 0x000fe200078ee227ULL, 0x0000002400247308ULL, 0x000fe20000000800ULL,
0x0000002f3017723eULL, 0x004fce00000000ffULL, 0x0000000700077308ULL, 0x000e620000000800ULL,
0x0000000835307824ULL, 0x000fe400078e00ffULL, 0x000000083e2f7824ULL, 0x000fe200078e00ffULL,
0x00000020141c723cULL, 0x000f64000000181cULL, 0xfffffff830307812ULL, 0x000fe400078ee22bULL,
0x0000002600267308ULL, 0x000fe20000000800ULL, 0xfffffff82f3e7812ULL, 0x000fce00078ee23eULL,
0x0000002300237308ULL, 0x000ea20000000800ULL, 0x000000240724723eULL, 0x002fe400000000ffULL,
0x0000900041077811ULL, 0x000fca00078e58ffULL, 0x0000001a001a7308ULL, 0x000fe20000000800ULL,
0x0000001022227824ULL, 0x100fe400078e0207ULL, 0x0000001032327824ULL, 0x100fe400078e0207ULL,
0x0000001034347824ULL, 0x100fe400078e0207ULL, 0x0000001036367824ULL, 0x100fe200078e0207ULL,
0x0000001b001b7308ULL, 0x000e620000000800ULL, 0x000000262326723eULL, 0x004fe200000000ffULL,
0x000000103c3c7824ULL, 0x000fc400078e0207ULL, 0x0000001028287824ULL, 0x100fe400078e0207ULL,
0x0000000119327824ULL, 0x040fe400078e0232ULL, 0x0000002900297308ULL, 0x000fe20000000800ULL,
0x000000102e2e7824ULL, 0x100fe400078e0207ULL, 0x0000000119347824ULL, 0x040fe400078e0234ULL,
0x0000001030307824ULL, 0x000fe400078e0207ULL, 0x0000000119367824ULL, 0x000fe200078e0236ULL,
0x0000002a002a7308ULL, 0x000ea20000000800ULL, 0x0000001a1b25723eULL, 0x002fe200000000ffULL,
0x00000001221b7824ULL, 0x000fc400078e0219ULL, 0x000000103e3e7824ULL, 0x000fe200078e0207ULL,
0x0000002c2d077208ULL, 0x000fe20004800000ULL, 0x00000001193c7824ULL, 0x040fe200078e023cULL,
0x000000081b007388ULL, 0x0003e20000000800ULL, 0x0000000119287824ULL, 0x040fe400078e0228ULL,
0x00000001192e7824ULL, 0x040fe200078e022eULL, 0x0000000a32007388ULL, 0x0003e20000000800ULL,
0x0000000119307824ULL, 0x040fe400078e0230ULL, 0x00000001193e7824ULL, 0x000fe200078e023eULL,
0x0000001034007388ULL, 0x0003e20000000800ULL, 0x000000292a27723eULL, 0x004fc600000000ffULL,
0x0000001236007388ULL, 0x0003e80000000800ULL, 0x00000020241c723cULL, 0x020f62000000181cULL,
0x000000143c007388ULL, 0x0003e80000000800ULL, 0x0000001628007388ULL, 0x0003e80000000800ULL,
0x000000242e007388ULL, 0x0003e80000000800ULL, 0x0000002630007388ULL, 0x0003e80000000800ULL,
0x000000093e007388ULL, 0x0003e80000000800ULL, 0x0004000b32007388ULL, 0x0003e60000000800ULL,
0x000000ffff1d7224ULL, 0x020fe200078e001eULL, 0x0004001134007388ULL, 0x0003e80000000800ULL,
0x0004001336007388ULL, 0x0003e80000000800ULL, 0x000400153c007388ULL, 0x0003e80000000800ULL,
0x0004001728007388ULL, 0x0003e80000000800ULL, 0x000400252e007388ULL, 0x0003e80000000800ULL,
0x0004002730007388ULL, 0x0003e80000000800ULL, 0x00f0000418008388ULL, 0x0003e80000000c00ULL,
0x00f2001c18008388ULL, 0x0003e20000000a00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000000dff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000008000dff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000010000dff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000010e0e7810ULL, 0x000fe20007ffe0ffULL, 0x000018000dff7f8cULL, 0x0003e6000c80043fULL,
0x0000000f0e00720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffd1c000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff117807ULL, 0x008fe40004000000ULL, 0x0000d39000107802ULL, 0x000fc40000000f00ULL,
0x00000c7000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff107224ULL, 0x000fe200078e0016ULL,
0xffff4b0000007947ULL, 0x000fea000383ffffULL, 0x00000001ff117807ULL, 0x000fe40004000000ULL,
0x0000d3e000107802ULL, 0x000fc40000000f00ULL, 0x00000c2000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff157224ULL, 0x000fe200078e0016ULL, 0xffff4b7000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x008fe200078e0039ULL, 0x0000d43000387802ULL, 0x000fc40000000f00ULL,
0x00000b8000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e0017ULL,
0xffff4c3000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0039ULL,
0x0000d48000387802ULL, 0x000fc40000000f00ULL, 0x00000b3000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0017ULL, 0xffff4d5000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0013ULL, 0x0000d4e000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff107224ULL, 0x000fc400078e0014ULL, 0x00000ad000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff097224ULL, 0x004fe200078e0017ULL, 0xffff515000007947ULL, 0x000fea000383ffffULL,
0x000000ffff107224ULL, 0x000fe200078e0008ULL, 0x0000d54000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff177224ULL, 0x000fc400078e0013ULL, 0x00000a7000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e0017ULL, 0xffff512000007947ULL, 0x000fea000383ffffULL,
0x00000001ff117807ULL, 0x004fe40004000000ULL, 0x0000d59000107802ULL, 0x000fc40000000f00ULL,
0x00000a7000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff157224ULL, 0x000fe200078e0016ULL,
0xffff687000007947ULL, 0x000fea000383ffffULL, 0x00000001ff117807ULL, 0x000fe40004000000ULL,
0x0000d5e000107802ULL, 0x000fc40000000f00ULL, 0x00000a2000007944ULL, 0x008fea0003c00000ULL,
0xffff68d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0039ULL,
0x0000d62000387802ULL, 0x000fc40000000f00ULL, 0x0000099000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0017ULL, 0xffff69b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0039ULL, 0x0000d67000387802ULL, 0x000fc40000000f00ULL,
0x0000094000007944ULL, 0x00afea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e0017ULL,
0xffff6ac000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0012ULL,
0x0000d6d000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff107224ULL, 0x000fc400078e0013ULL,
0x000008e000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e0017ULL,
0xffff6f2000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0012ULL,
0x0000d72000387802ULL, 0x000fc40000000f00ULL, 0x0000089000007944ULL, 0x00efea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e0017ULL, 0xffff6f0000007947ULL, 0x000fea000383ffffULL,
0x00000001ff117807ULL, 0x002fe40004000000ULL, 0x0000d77000107802ULL, 0x000fc40000000f00ULL,
0x0000089000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff147224ULL, 0x000fe200078e0016ULL,
0xffff837000007947ULL, 0x000fea000383ffffULL, 0x00000001ff117807ULL, 0x000fe40004000000ULL,
0x0000d7c000107802ULL, 0x000fc40000000f00ULL, 0x0000084000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff157224ULL, 0x000fe200078e0016ULL, 0xffff83b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0039ULL, 0x0000d81000387802ULL, 0x000fc40000000f00ULL,
0x000007a000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e0017ULL,
0xffff849000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0039ULL,
0x0000d86000387802ULL, 0x000fc40000000f00ULL, 0x0000075000007944ULL, 0x00afea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0017ULL, 0xffff85a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0012ULL, 0x0000d8c000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff107224ULL, 0x000fc400078e0013ULL, 0x000006f000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff097224ULL, 0x004fe200078e0017ULL, 0xffff89b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0012ULL, 0x0000d91000387802ULL, 0x000fc40000000f00ULL,
0x000006a000007944ULL, 0x00efea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e0017ULL,
0xffff899000007947ULL, 0x000fea000383ffffULL, 0x00000001ff117807ULL, 0x002fe40004000000ULL,
0x0000d96000107802ULL, 0x000fc40000000f00ULL, 0x000006a000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff157224ULL, 0x000fe200078e0016ULL, 0xffff9e5000007947ULL, 0x000fea000383ffffULL,
0x00000001ff117807ULL, 0x000fe40004000000ULL, 0x0000d9b000107802ULL, 0x000fc40000000f00ULL,
0x0000065000007944ULL, 0x008fea0003c00000ULL, 0xffff9ea000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0039ULL, 0x0000d9f000387802ULL, 0x000fc40000000f00ULL,
0x000005c000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e0017ULL,
0xffff9f8000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0039ULL,
0x0000da4000387802ULL, 0x000fc40000000f00ULL, 0x0000057000007944ULL, 0x00afea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0017ULL, 0xffffa09000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0012ULL, 0x0000daa000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff107224ULL, 0x000fc400078e0013ULL, 0x0000051000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff097224ULL, 0x004fe200078e0017ULL, 0xffffa4b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0012ULL, 0x0000daf000387802ULL, 0x000fc40000000f00ULL,
0x000004c000007944ULL, 0x00efea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e0017ULL,
0xffffa49000007947ULL, 0x000fea000383ffffULL, 0x00000002ff337424ULL, 0x000fe200078e00ffULL,
0x0000db4000307802ULL, 0x000fc40000000f00ULL, 0x0000043000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e002dULL, 0xffffeaf000007947ULL, 0x000fea000383ffffULL,
0x000000ffff327224ULL, 0x006fe200078e0034ULL, 0x0000dba000307802ULL, 0x000fe20000000f00ULL,
0x00000002ff337424ULL, 0x000fc400078e00ffULL, 0x000003d000007944ULL, 0x000fea0003c00000ULL,
0x0000002d3400720bULL, 0x004fe20003f1e000ULL, 0x000000ffff327224ULL, 0x002fe200078e0006ULL,
0x0000dc0000307802ULL, 0x000fe20000000f00ULL, 0x00000002ff337424ULL, 0x000fe200078e00ffULL,
0x000000342d347208ULL, 0x000fc80004000000ULL, 0x0000037000007944ULL, 0x000fea0003c00000ULL,
0x0000002d0600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff327224ULL, 0x002fe200078e0007ULL,
0x0000dc6000307802ULL, 0x000fe20000000f00ULL, 0x00000002ff337424ULL, 0x000fe200078e00ffULL,
0x000000062d067208ULL, 0x000fc80004000000ULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x0000002d0700720bULL, 0x004fe20003f1e000ULL, 0x000000ffff327224ULL, 0x002fe200078e0035ULL,
0x0000dcc000307802ULL, 0x000fe20000000f00ULL, 0x00000001ff337424ULL, 0x000fe200078e00ffULL,
0x000000072d2c7208ULL, 0x000fc80004000000ULL, 0x000002b000007944ULL, 0x000fea0003c00000ULL,
0x0000002d3500720bULL, 0x004fe20003f1e000ULL, 0x000000ffff327224ULL, 0x002fe200078e0034ULL,
0x0000dd2000307802ULL, 0x000fe20000000f00ULL, 0x00000001ff337424ULL, 0x000fe200078e00ffULL,
0x000000352d047208ULL, 0x000fc80004000000ULL, 0x0000025000007944ULL, 0x000fea0003c00000ULL,
0x0000002d3400720bULL, 0x004fe20003f1e000ULL, 0x000000ffff327224ULL, 0x002fe200078e0006ULL,
0x0000dd8000307802ULL, 0x000fe20000000f00ULL, 0x00000001ff337424ULL, 0x000fe200078e00ffULL,
0x000000342d057208ULL, 0x000fc80004000000ULL, 0x000001f000007944ULL, 0x000fea0003c00000ULL,
0x0000002d0600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff327224ULL, 0x002fe200078e002cULL,
0x0000dde000307802ULL, 0x000fe20000000f00ULL, 0x00000001ff337424ULL, 0x000fe200078e00ffULL,
0x000000062d067208ULL, 0x000fc80004000000ULL, 0x0000019000007944ULL, 0x000fea0003c00000ULL,
0xffffe9c000007947ULL, 0x000fea000383ffffULL, 0x0180000006007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000047812ULL, 0x000fc800078ec0ffULL,
0x018000000400780cULL, 0x000fda0003f05070ULL, 0x0000000600008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0400720cULL, 0x040fe40003f25070ULL,
0x008000000400780cULL, 0x000fe40003f02070ULL, 0x00000001ff057807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000005ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff06ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000006047812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000005ff7212ULL, 0x000fda000780c0ffULL, 0x0080000004000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0004ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000600007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff047224ULL, 0x000fe400078e0007ULL, 0x00000000ff057424ULL, 0x000fc800078e00ffULL,
0xffff209004007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff317424ULL, 0x000fe200078e00ffULL,
0x0000003700007348ULL, 0x000fe80003800000ULL, 0x0c000033322d7389ULL, 0x0002a200000e0036ULL,
0xffff205030007950ULL, 0x000fea0003c3ffffULL, 0x0000004400007348ULL, 0x000fe80003800000ULL,
0x0000001017177389ULL, 0x0002a200000e0049ULL, 0x00000000ff117424ULL, 0x000fc400078e00ffULL,
0x000000ffff107224ULL, 0x002fc800078e0038ULL, 0xffff200010007950ULL, 0x000fea0003c3ffffULL,
0x000000011100780cULL, 0x000fe20003f05070ULL, 0x0000004600007348ULL, 0x000fd80003800000ULL,
0x0000000000117806ULL, 0x000fc800040e0100ULL, 0x0000004611167212ULL, 0x000fe200078ec0ffULL,
0x00000000ff117424ULL, 0x000fc800078e00ffULL, 0xffff1fa010007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000200000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005deULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000740ULL, 0x0000000000000288ULL, 0x0000001a00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009c8ULL, 0x00000000000002b8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000c80ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000d40ULL, 0x0000000000000780ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000014c0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000014d0ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000007bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001560ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001564ULL, 0x00000000000001a8ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001780ULL, 0x000000000000e100ULL, 0x6200001a00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x0000000100000089ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000000f880ULL, 0x0000000000000044ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000000f8d0ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x000000000000fc50ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001560ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000e320ULL, 0x000000000000e320ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x000000000000f880ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x000000000000fc50ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_nqpkv_8_m_8_sm_89_cubin_len = 64816;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
