/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_nqpkv_8_m_8_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x00000000000067d8ULL, 0x0000000000006398ULL, 0x00380040005a0d5aULL, 0x0001001100400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x2e00000000003374ULL,
0x61626f6c672e766eULL, 0x2e0074696e692e6cULL, 0x74736e6f632e766eULL, 0x0000000034746e61ULL,
0x7865742e6c65722eULL, 0x6c656e72656b2e74ULL, 0x65722e0061686d5fULL, 0x2e747865742e616cULL,
0x6d5f6c656e72656bULL, 0x756265642e006168ULL, 0x00656d6172665f67ULL, 0x2e766e2e6c65722eULL,
0x746e6174736e6f63ULL, 0x65722e006369702eULL, 0x6f632e766e2e616cULL, 0x0034746e6174736eULL,
0x2e6c65722e000000ULL, 0x72665f6775626564ULL, 0x6c65722e00656d61ULL, 0x5f67756265642e61ULL,
0x6e2e00656d617266ULL, 0x72676c6c61632e76ULL, 0x2e766e2e00687061ULL, 0x7079746f746f7270ULL,
0x6f632e766e2e0065ULL, 0x2e30746e6174736eULL, 0x6d5f6c656e72656bULL, 0x0000000000006168ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x732e000000000000ULL, 0x0062617472747368ULL, 0x006261747274732eULL, 0x006261746d79732eULL,
0x5f6261746d79732eULL, 0x6e2e0078646e6873ULL, 0x2e006f666e692e76ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL, 0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL,
0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL, 0x6f632e766e2e0061ULL, 0x0033746e6174736eULL,
0x4d34456b00000000ULL, 0x6e2e0058414d5f33ULL, 0x6c61626f6c672e76ULL, 0x6d730074696e692eULL,
0x2e00657a69536d65ULL, 0x74736e6f632e766eULL, 0x0000000034746e61ULL, 0x79546c656e72656bULL,
0x0000000000006570ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7265746e695f5f24ULL,
0x5f245f305f6c616eULL, 0x6d735f616475635fULL, 0x725f7063725f3032ULL, 0x33665f7a74665f6eULL,
0x6170776f6c735f32ULL, 0x2e6c65722e006874ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL,
0x65742e616c65722eULL, 0x656e72656b2e7478ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL,
0x2e6c65722e00656dULL, 0x74736e6f632e766eULL, 0x006369702e746e61ULL, 0x766e2e616c65722eULL,
0x6e6174736e6f632eULL, 0x722e006369702e74ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL,
0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6c61632e766e2e00ULL, 0x2e0068706172676cULL,
0x6f746f72702e766eULL, 0x72656b0065707974ULL, 0x0061686d5f6c656eULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000d000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007fULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000e000300000089ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000100000099ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c0003000000a2ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e0001000000b3ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x0000010000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000d0022000000d3ULL, 0x0000000000005060ULL,
0x0000000000000220ULL, 0x0004000300000131ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000700030000018cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000d1012000001a8ULL,
0x0000000000000000ULL, 0x0000000000005280ULL, 0x00100003000001b3ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x0000002cffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000506000000000ULL, 0x0000500400000000ULL,
0x0400288080810c00ULL, 0x00000000000013b4ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080860828808081ULL,
0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808692ULL, 0x0000001cffffffffULL,
0x0000006800000000ULL, 0x0000506000000000ULL, 0x0000022000000000ULL, 0x0000000000000000ULL,
0x0000000c00082f04ULL, 0x000812040000002cULL, 0x0000000000000009ULL, 0x0000000900081104ULL,
0x0008120400000000ULL, 0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL,
0x000000000000000cULL, 0x0000007c00043704ULL, 0x00000000000c1704ULL, 0x0021f00000f00007ULL,
0x00000000000c1704ULL, 0x0201f00000700006ULL, 0x00000000000c1704ULL, 0x0021f00000380005ULL,
0x00000000000c1704ULL, 0x0011f00000300004ULL, 0x00000000000c1704ULL, 0x0061f00000180003ULL,
0x00000000000c1704ULL, 0x0021f00000100002ULL, 0x00000000000c1704ULL, 0x0021f00000080001ULL,
0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x00ff1b0380005003ULL, 0x000001d000103104ULL,
0x00002ab0000029b0ULL, 0x0048290400002ad0ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffff0500000aULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000001d000482804ULL,
0x00001b3000001a80ULL, 0x00002ad000001bc0ULL, 0x0000344000003420ULL, 0x0000348000003470ULL,
0x000034c0000034b0ULL, 0x0000378000003740ULL, 0x000037c0000037b0ULL, 0x00003800000037f0ULL,
0x0590390400003e50ULL, 0x000000ff00000340ULL, 0x00040100000089a0ULL, 0x000000ff00000370ULL,
0x00040100000089a8ULL, 0x000000ff00000390ULL, 0x00040100000089b0ULL, 0x000000ff000003d0ULL,
0x00040100000089b8ULL, 0x000000ff000003f0ULL, 0x00040100000089c0ULL, 0x000000ff00000410ULL,
0x00040100000089c8ULL, 0x000000ff00000430ULL, 0x00040100000089d0ULL, 0x000000ff00000450ULL,
0x00040100000089d8ULL, 0x000000ff00000470ULL, 0x00040100000089e0ULL, 0x000000ff00000490ULL,
0x00040100000089e8ULL, 0x000000ff000004b0ULL, 0x00040100000089f0ULL, 0x000000ff000004d0ULL,
0x00040100000089f8ULL, 0x000000ff000004f0ULL, 0x0004010000008a00ULL, 0x000000ff00000510ULL,
0x0004010000008a08ULL, 0x000000ff00000530ULL, 0x0004010000008a10ULL, 0x000000ff00000550ULL,
0x0004010000008a18ULL, 0x00000009000008d0ULL, 0x003f0101000089d8ULL, 0x00000009000008e0ULL,
0x003f0109000089d8ULL, 0x0000000900000b90ULL, 0x003f0101000089b8ULL, 0x0000000900000ba0ULL,
0x003f0109000089b8ULL, 0x0000000000000de0ULL, 0x003f0101000089a8ULL, 0x0000000000000df0ULL,
0x003f0109000089a8ULL, 0x0000000000001430ULL, 0x003f0101000089a0ULL, 0x0000000000001490ULL,
0x003f0101000089d8ULL, 0x00000000000014b0ULL, 0x003f0101000089e8ULL, 0x00000000000014c0ULL,
0x003f0101000089f8ULL, 0x00000000000014d0ULL, 0x003f010100008a08ULL, 0x0000000000001500ULL,
0x003f010100008a18ULL, 0x0000000000001510ULL, 0x003f010900008a18ULL, 0x0000000900001920ULL,
0x003f0109000089d0ULL, 0x0000002100001950ULL, 0x003f0101000089f0ULL, 0x00000021000019d0ULL,
0x003f0109000089f0ULL, 0x0000000000001a50ULL, 0x003f010100008a18ULL, 0x0000000000001c30ULL,
0x003f010900008a18ULL, 0x0000000000001e40ULL, 0x003f010100008a18ULL, 0x0000000000001ed0ULL,
0x003f010900008a18ULL, 0x0000000000002340ULL, 0x003f010100008a18ULL, 0x0000000000002390ULL,
0x003f010900008a18ULL, 0x00000000000028a0ULL, 0x003f010100008a18ULL, 0x00000000000028b0ULL,
0x003f010900008a18ULL, 0x0000000000002950ULL, 0x003f010100008a18ULL, 0x0000000000002960ULL,
0x003f010900008a18ULL, 0x0000000400002bd0ULL, 0x003f0101000089f8ULL, 0x0000000400002be0ULL,
0x003f0101000089d8ULL, 0x0000000000002c60ULL, 0x003f0101000089a8ULL, 0x0000000000002c80ULL,
0x003f0101000089b8ULL, 0x0000000000002c90ULL, 0x003f0101000089c8ULL, 0x0000000000002cb0ULL,
0x003f010100008a10ULL, 0x0000000000002cc0ULL, 0x003f010900008a10ULL, 0x0000000000002ce0ULL,
0x003f0101000089a0ULL, 0x0000000000002cf0ULL, 0x003f0109000089a0ULL, 0x0000000500002f40ULL,
0x003f0109000089b0ULL, 0x0000000e000032d0ULL, 0x003f0101000089b8ULL, 0x00000000000035e0ULL,
0x003f010100008a10ULL, 0x0000000000003620ULL, 0x003f010900008a10ULL, 0x0000000000003650ULL,
0x003f010100008a10ULL, 0x0000000000003660ULL, 0x003f010900008a10ULL, 0x0000000e00003910ULL,
0x003f0101000089f8ULL, 0x0000000e00003920ULL, 0x003f0109000089f8ULL, 0x0000000e00003ad0ULL,
0x003f0101000089f0ULL, 0x0000000000003af0ULL, 0x003f0101000089a8ULL, 0x0000000000003c00ULL,
0x003f0108000089a0ULL, 0x0000000000003d00ULL, 0x003f010000002100ULL, 0x0000000000003d70ULL,
0x003f010000002108ULL, 0x0000000000003e20ULL, 0x003f010100002108ULL, 0x00000003000040e0ULL,
0x0007010a00002108ULL, 0x000000ff000041f0ULL, 0x0008010700002100ULL, 0x0000000300004490ULL,
0x0007010a00002100ULL, 0x000000ff00004720ULL, 0x0008010100002108ULL, 0x0000000000004910ULL,
0x003f010800002108ULL, 0x0000000000004920ULL, 0x003f010800002100ULL, 0x0000000900004940ULL,
0x003f0109000089d8ULL, 0x00000009000049a0ULL, 0x003f0109000089b8ULL, 0x0000000000004a00ULL,
0x003f0109000089a8ULL, 0x0000000000004a60ULL, 0x003f010900008a18ULL, 0x0000000900004ac0ULL,
0x003f0109000089d0ULL, 0x0000002100004b20ULL, 0x003f0109000089f0ULL, 0x0000000000004b80ULL,
0x003f010900008a18ULL, 0x0000000000004be0ULL, 0x003f010900008a18ULL, 0x0000000000004c40ULL,
0x003f010900008a18ULL, 0x0000000000004ca0ULL, 0x003f010900008a18ULL, 0x0000000000004d00ULL,
0x003f010900008a10ULL, 0x0000000000004d60ULL, 0x003f0109000089a0ULL, 0x0000000500004dc0ULL,
0x003f0109000089b0ULL, 0x0000000000004e20ULL, 0x003f010900008a10ULL, 0x0000000000004e80ULL,
0x003f010900008a10ULL, 0x0000000e00004ee0ULL, 0x003f0109000089f8ULL, 0x0000000500004f70ULL,
0x003f010a00002108ULL, 0x0000000b00005000ULL, 0x003f010a00002100ULL, 0x00141c0400123803ULL,
0x00003c1000000130ULL, 0x000048e000003c70ULL, 0x00041e0400004930ULL, 0x00f8190300000000ULL,
0x0000000d00080a04ULL, 0x0004360400f80210ULL, 0x0000000000000008ULL, 0x00000000ffffffffULL,
0x00000000fffffffeULL, 0x00000000fffffffdULL, 0x00000000fffffffcULL, 0x0000000000000008ULL,
0x0000000700000002ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000500000002ULL,
0x0000000000000000ULL, 0x00000000000000c4ULL, 0x0000000c00000002ULL, 0x0000000000005060ULL,
0x0000000000000044ULL, 0x0000000c00000002ULL, 0x0000000000000000ULL, 0x00000000000000a0ULL,
0x0000000c00000002ULL, 0x0000000000000000ULL, 0x0000000043e00000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e240000000800ULL, 0x0000000000047919ULL, 0x000e620000002700ULL,
0x00008c00ff067b82ULL, 0x000e620000000a00ULL, 0x0000820000107ab9ULL, 0x000fe20000000a00ULL,
0x0000000404067825ULL, 0x002fcc00078e0006ULL, 0x0000001006067981ULL, 0x000ea2000c1e1900ULL,
0x00000000001279c3ULL, 0x000e620000002500ULL, 0x0000030000147ab9ULL, 0x000fe20000000800ULL,
0x00000000060472caULL, 0x004fda00000e0000ULL, 0x0000003f04047890ULL, 0x000fc8000fffe03fULL,
0x000000063f137899ULL, 0x000fe40008011604ULL, 0x0000007f0400788cULL, 0x000fe4000bf04070ULL,
0x000000141300728cULL, 0x000fe4000bf21070ULL, 0x000000011400788cULL, 0x000fe40008704070ULL,
0x0000001413067287ULL, 0x000fe40008800000ULL, 0x0000003f12157287ULL, 0x002fc40008000000ULL,
0x0000000106067887ULL, 0x000fc80008000000ULL, 0x000000061500728cULL, 0x000fcc000bf26070ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000000000a7919ULL, 0x000e620000002300ULL, 0x0000000600007d06ULL, 0x000ea20008209000ULL,
0x0000042000007945ULL, 0x000fe20003800000ULL, 0x0000000000057919ULL, 0x000e620000002200ULL,
0x0000000000037919ULL, 0x000eea0000002100ULL, 0x0000000000007308ULL, 0x004ea20000001000ULL,
0x0000000a05ff7212ULL, 0x002fc8000780fcffULL, 0x000000200300780cULL, 0x008fda0000705670ULL,
0x00006600ff088b82ULL, 0x000e620000000a00ULL, 0x00000000003f7886ULL, 0x000fe20000020000ULL,
0x0000007008028810ULL, 0x002fc80007f3e0ffULL, 0x00000000020482caULL, 0x000fe200000e0000ULL,
0x000000ffff088224ULL, 0x000fe200008e0609ULL, 0x000000030aff7212ULL, 0x000fe2000782fe05ULL,
0x0ffffffe00027836ULL, 0x004fc60000000000ULL, 0x00000000080582caULL, 0x000fc600000e0000ULL,
0x0000000200027305ULL, 0x000e68000021f000ULL, 0x00000004ff087e24ULL, 0x000fca000f8e00ffULL,
0x00000000080482caULL, 0x000fe200000e0000ULL, 0x00000005ff097e24ULL, 0x000fca000f8e00ffULL,
0x00000000090582caULL, 0x000fda00000e0000ULL, 0x00000000040099b9ULL, 0x0003e40008040000ULL,
0x0000000000b41947ULL, 0x002fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x001ffe8000087882ULL, 0x000fe20000000000ULL,
0x7ffa000000097882ULL, 0x000fe20000000000ULL, 0x001fff00000a7882ULL, 0x000fe20000000000ULL,
0x7ffc0000000b7882ULL, 0x000fe20000000000ULL, 0x001ffefe000c7882ULL, 0x000fe20000000000ULL,
0x7ffbf800000d7882ULL, 0x000fe20000000000ULL, 0x0000065405047896ULL, 0x002fe20008000004ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000000073c6ULL, 0x000e740000000000ULL,
0x0089a008043f75b2ULL, 0x000e620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0089a808043f75b2ULL, 0x0004620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x001ffe0000087882ULL, 0x004fe20000000000ULL, 0x7ff8000000097882ULL, 0x000fe20000000000ULL,
0x0089b00a043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0089b80c043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0089c00a043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0089c80c043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0089d00a043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0089d80c043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0089e00a043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0089e80c043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0089f008043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0089f808043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x008a0008043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x008a0808043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x008a100a043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x008a180a043f75b2ULL, 0x0002640008000100ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000020572caULL, 0x000fe200000e0000ULL,
0x800000063f087290ULL, 0x000fe2000fffe03fULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x000000153f077292ULL, 0x000fe2000f8e333fULL, 0x000000ff0a00720cULL, 0x000fe20003f05270ULL,
0x0000003f0600728cULL, 0x000fc6000bf65070ULL, 0x0000003f00047c82ULL, 0x000fca0008000000ULL,
0x00000005080872a4ULL, 0x000fc8000f8e023fULL, 0x00000008050872a5ULL, 0x000fe4000f8e0004ULL,
0x0000001306047290ULL, 0x000fc8000fffe007ULL, 0x00000004090872a5ULL, 0x000fce000f8e003fULL,
0x0000000900057c82ULL, 0x000fe40008000000ULL, 0x0000003f05077290ULL, 0x000fe4000fffe13fULL,
0x00000000000879c3ULL, 0x000e640000008800ULL, 0x00000007060772a4ULL, 0x000fc8000f8e0204ULL,
0x000000060700728cULL, 0x000fd6000bf26070ULL, 0x0000000706071290ULL, 0x000fe4000fffe13fULL,
0x0000000105051890ULL, 0x000fe4000fffe03fULL, 0x000000060700728cULL, 0x000fc6000bf46070ULL,
0x0000040000077882ULL, 0x000fe40000000000ULL, 0x0000065408077896ULL, 0x002fcc0008000007ULL,
0x0000000105052890ULL, 0x000fe2000fffe03fULL, 0x00000007ff007e24ULL, 0x000fe2000f8e00ffULL,
0x000000063f05b292ULL, 0x000fc6000f8e333fULL, 0x0000000403157824ULL, 0x000fe200078e0200ULL,
0x00000024003c8947ULL, 0x000ff00003800000ULL, 0x0000000000057919ULL, 0x000e620000002600ULL,
0x000000010a00780cULL, 0x000fe20003f05270ULL, 0x000024b000007945ULL, 0x000fd80003800000ULL,
0x0000000c00388947ULL, 0x000fea0003800000ULL, 0x000000400300780cULL, 0x000fda0003f06070ULL,
0x0000000400648947ULL, 0x000fea0003800000ULL, 0x000000400300780cULL, 0x000fda0003f05270ULL,
0x0000000000b08947ULL, 0x000fea0003800000ULL, 0x000000040600728cULL, 0x000fcc000bf24070ULL,
0x000000000000781cULL, 0x000fc80003f0f018ULL, 0x000000600300780cULL, 0x000fda0000705670ULL,
0x0000002400040947ULL, 0x000fea0003800000ULL, 0x0000660000087ab9ULL, 0x000fe20000000a00ULL,
0x0000000104047811ULL, 0x000fe200078e08ffULL, 0x0000007008077890ULL, 0x000fe2000ff3e03fULL,
0x000000ffff057224ULL, 0x002fe400078e00ffULL, 0x00000001ff067424ULL, 0x000fe200078e00ffULL,
0x000000093f087290ULL, 0x000fe40008ffe43fULL, 0x00000007ff0c7e24ULL, 0x000fc8000f8e00ffULL,
0x00000008ff0d7e24ULL, 0x000fce000f8e00ffULL, 0x0000001005027824ULL, 0x040fe200078e00ffULL,
0x0000000105077812ULL, 0x000fe200078ec0ffULL, 0x00000015ff087e24ULL, 0x000fc6000f8e00ffULL,
0x0000001002037812ULL, 0x000fe200078ec0ffULL, 0x00002200070a7824ULL, 0x000fc800078e0200ULL,
0x0000000100097824ULL, 0x000fc800078e0203ULL, 0x0089d806090279a7ULL, 0x000e64000850003fULL,
0x0089d803090075a7ULL, 0x002e64000800017fULL, 0x0000004000108947ULL, 0x002fea0003800000ULL,
0x00000000000c79c3ULL, 0x000e620000002600ULL, 0x0000001007077824ULL, 0x000fe200078e0200ULL,
0x000000000a0872caULL, 0x000fe200000e0000ULL, 0x0000000605027c24ULL, 0x000fe2000f8e0208ULL,
0x000000000c0e72caULL, 0x000fe200000e0000ULL, 0x0000003f000a7c82ULL, 0x000fe20008000000ULL,
0x00000000070972caULL, 0x000fe400000e0000ULL, 0x00000000020b72caULL, 0x000fe400000e0000ULL,
0x000000000d0f72caULL, 0x000fc400000e0000ULL, 0x00000000040d72caULL, 0x000fe400000e0000ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x0000420008087890ULL, 0x000fc8000fffe03fULL,
0x000089d009097890ULL, 0x000fe4000fffe03fULL, 0x000000060b0b7899ULL, 0x002fd8000800063fULL,
0x00000000003f082fULL, 0x000fe20003820000ULL, 0x000000080e0075b4ULL, 0x0003d80008018000ULL,
0x000000000000181cULL, 0x000fe40000f0e170ULL, 0x000000000000781cULL, 0x000fd60003f2e170ULL,
0xfffffffd00ec0947ULL, 0x002fea000393ffffULL, 0x0000000105057836ULL, 0x000fca0000000000ULL,
0x0000000505007c0cULL, 0x000fda000bf06070ULL, 0xfffffffc00848947ULL, 0x001fea000383ffffULL,
0x0000002000647947ULL, 0x000fea0003800000ULL, 0x000000040600728cULL, 0x000fcc000bf24070ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x0000002000580947ULL, 0x000fea0003800000ULL,
0x0000660000087ab9ULL, 0x000fe20000000a00ULL, 0x0000000204047824ULL, 0x000fe200078e00ffULL,
0x0000007008077890ULL, 0x000fe2000ff3e03fULL, 0x000000ffff057224ULL, 0x002fe400078e00ffULL,
0x00000001ff087424ULL, 0x000fe200078e00ffULL, 0x000000093f087290ULL, 0x000fe40008ffe43fULL,
0x00000007ff0c7e24ULL, 0x000fc8000f8e00ffULL, 0x00000008ff0d7e24ULL, 0x000fce000f8e00ffULL,
0x0000001005027824ULL, 0x040fe200078e00ffULL, 0x0000000105077812ULL, 0x000fe200078ec0ffULL,
0x00000015ff067e24ULL, 0x000fc6000f8e00ffULL, 0x0000001002037812ULL, 0x000fe200078ec0ffULL,
0x0000000605067c24ULL, 0x000fe4000f8e0206ULL, 0x00000010070a7824ULL, 0x000fe400078e0200ULL,
0x0000000100097824ULL, 0x000fc800078e0203ULL, 0x0089b808090279a7ULL, 0x000e64000850003fULL,
0x0089b803090075a7ULL, 0x002e64000800017fULL, 0x0000003c00788947ULL, 0x002fea0003800000ULL,
0x00000000000c79c3ULL, 0x000e620000002600ULL, 0x00000000070872caULL, 0x000fe200000e0000ULL,
0x0000003f000a7c82ULL, 0x000fe20008000000ULL, 0x00000000000772caULL, 0x000fe400000e0000ULL,
0x000000000a0972caULL, 0x000fe400000e0000ULL, 0x00000000060b72caULL, 0x000fe400000e0000ULL,
0x000000000c0e72caULL, 0x000fe400000e0000ULL, 0x000000000d0f72caULL, 0x000fc400000e0000ULL,
0x00000000040d72caULL, 0x000fe400000e0000ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x0000000708087291ULL, 0x000fe4000f8e683fULL, 0x000089b009097890ULL, 0x000fe4000fffe03fULL,
0x000000060b0b7899ULL, 0x002fd8000800063fULL, 0x00000000003f082fULL, 0x000fe20003820000ULL,
0x000000080e0075b4ULL, 0x0003d80008018000ULL, 0x000000000000181cULL, 0x000fe40000f0e170ULL,
0x000000000000781cULL, 0x000fd60003f2e170ULL, 0xfffffffd00ec0947ULL, 0x002fea000393ffffULL,
0x0000000105057836ULL, 0x000fca0000000000ULL, 0x0000000505007c0cULL, 0x000fda000bf06070ULL,
0xfffffffc00848947ULL, 0x001fea000383ffffULL, 0x0000001c00b87947ULL, 0x000fea0003800000ULL,
0x00008800ff067b82ULL, 0x000ea20000000a00ULL, 0x0000004003027836ULL, 0x000fe20000000000ULL,
0x0000840000077ab9ULL, 0x000fe40000000800ULL, 0x0000000704047c24ULL, 0x002fe4000f8e0205ULL,
0x0000007f0200780cULL, 0x000fe40003f24070ULL, 0x0000008004097824ULL, 0x000fd600078e0203ULL,
0x0000004009059836ULL, 0x040fe40000000000ULL, 0x0000001009087825ULL, 0x004fc800078e0006ULL,
0x0000001005049825ULL, 0x000fe400078e0006ULL, 0x0000001008087981ULL, 0x000f68000c1e9d00ULL,
0x0000001004049981ULL, 0x000f62000c1e9d00ULL, 0x00000001ff0d7424ULL, 0x000fc800078e00ffULL,
0x0089a80d000e79a7ULL, 0x000e64000850003fULL, 0x0089a80f000075a7ULL, 0x002e64000800017fULL,
0x0000003800fc8947ULL, 0x002fea0003800000ULL, 0x0000007f0300780cULL, 0x000fe40003f04070ULL,
0x00000000000e7805ULL, 0x000fe4000001ff00ULL, 0x0000773204119816ULL, 0x020fe200000000ffULL,
0x000000ffff0c7224ULL, 0x000fe200078e00ffULL, 0x0000773205129816ULL, 0x000fe200000000ffULL,
0x000000ffff107224ULL, 0x000fe200078e00ffULL, 0x0000773206139816ULL, 0x000fe200000000ffULL,
0x000005a000017945ULL, 0x000fe20003800000ULL, 0x0000773207149816ULL, 0x000fc400000000ffULL,
0x0000ffff040c9812ULL, 0x000fe400078ec0ffULL, 0x0000ffff050e9812ULL, 0x000fe400078ec0ffULL,
0x0000000000047805ULL, 0x000fe4000001ff00ULL, 0x0000ffff060f9812ULL, 0x000fe200078ec0ffULL,
0x000000ffff049224ULL, 0x000fe200078e0011ULL, 0x0000ffff07109812ULL, 0x000fe400078ec0ffULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x000000ffff059224ULL, 0x000fc400078e0012ULL,
0x000000ffff069224ULL, 0x000fe400078e0013ULL, 0x000000ffff079224ULL, 0x000fe200078e0014ULL,
0x0000000400340947ULL, 0x000fec0003800000ULL, 0x0000773208117816ULL, 0x040fe400000000ffULL,
0x0000ffff08087812ULL, 0x000fe400078ec0ffULL, 0x00000011ff15723eULL, 0x000fe400048032ffULL,
0x00000008ff08723eULL, 0x000fe400048032ffULL, 0x00000004ff137819ULL, 0x000fe40000011603ULL,
0x0000761008147816ULL, 0x000fc40000000014ULL, 0x00000001ff087819ULL, 0x000fe40000011603ULL,
0x0000ffff09117812ULL, 0x040fe400078ec0ffULL, 0x0000000708087812ULL, 0x000fe400078ec0ffULL,
0x0000773209167816ULL, 0x000fe400000000ffULL, 0x0000ffff0a097812ULL, 0x040fe400078ec0ffULL,
0x000077320a177816ULL, 0x000fc400000000ffULL, 0x00000013080a7212ULL, 0x000fe400078e3cffULL,
0x000000ff14147812ULL, 0x000fe400078ec0ffULL, 0x0000ffff15157812ULL, 0x000fe400078ec0ffULL,
0x000077320b187816ULL, 0x000fe400000000ffULL, 0x00000011ff11723eULL, 0x000fe400048032ffULL,
0x00000009ff19723eULL, 0x000fc400048032ffULL, 0x0000ffff0b127812ULL, 0x000fe200078ec0ffULL,
0x00000008130b7824ULL, 0x000fe200078e020aULL, 0x0000760415097816ULL, 0x000fe20000000014ULL,
0x000000ffff0a7224ULL, 0x000fe200078e0016ULL, 0x0000761011147816ULL, 0x000fe20000000014ULL,
0x000000ffff117224ULL, 0x000fe200078e0017ULL, 0x0000761019157816ULL, 0x000fe20000000015ULL,
0x000000ffff137224ULL, 0x000fe200078e0018ULL, 0x00000012ff12723eULL, 0x000fe400048032ffULL,
0x0000000aff0a723eULL, 0x000fc400048032ffULL, 0x00000011ff11723eULL, 0x000fe400048032ffULL,
0x00000013ff13723eULL, 0x000fe400048032ffULL, 0x000000ff14147812ULL, 0x000fe400078ec0ffULL,
0x000000ff15157812ULL, 0x000fe400078ec0ffULL, 0x000000ff12127812ULL, 0x000fe400078ec0ffULL,
0x0000ffff0a177812ULL, 0x000fe200078ec0ffULL, 0x000000100b0a7824ULL, 0x000fe200078e0200ULL,
0x0000ffff11167812ULL, 0x000fc400078ec0ffULL, 0x0000ffff13137812ULL, 0x000fe400078ec0ffULL,
0x0000000103037812ULL, 0x000fe400078ec0ffULL, 0x0000760417147816ULL, 0x000fe40000000014ULL,
0x0000760416157816ULL, 0x000fe20000000015ULL, 0x00000008030a7824ULL, 0x000fe200078e020aULL,
0x0000760413127816ULL, 0x000fe40000000012ULL, 0x0000541009147816ULL, 0x000fc40000000014ULL,
0x0000541015157816ULL, 0x000fca0000000012ULL, 0x008400140a007388ULL, 0x0003e20000000a00ULL,
0x00000000007c1947ULL, 0x000fea0003800000ULL, 0x00000007ff09723eULL, 0x000fe400048032ffULL,
0x00000010ff10723eULL, 0x000fe400048032ffULL, 0x00000004ff077819ULL, 0x100fe40000011602ULL,
0x0000761010027816ULL, 0x000fe40000000002ULL, 0x0000000708087212ULL, 0x000fe400078e3cffULL,
0x0000000fff0f723eULL, 0x000fc400048032ffULL, 0x000000ff02027812ULL, 0x000fe200078ec0ffULL,
0x0000000807077824ULL, 0x000fe200078e0208ULL, 0x0000ffff09097812ULL, 0x000fe400078ec0ffULL,
0x0000000eff0e723eULL, 0x000fe400048032ffULL, 0x00000006ff0a723eULL, 0x002fe400048032ffULL,
0x00000005ff08723eULL, 0x000fe400048032ffULL, 0x000076100f067816ULL, 0x000fc40000000006ULL,
0x00000004ff05723eULL, 0x000fe400048032ffULL, 0x00007604090b7816ULL, 0x000fe40000000002ULL,
0x000076100e047816ULL, 0x000fe40000000004ULL, 0x0000000cff02723eULL, 0x000fe400048032ffULL,
0x000000ff06097812ULL, 0x000fe400078ec0ffULL, 0x000000ff04067812ULL, 0x000fc400078ec0ffULL,
0x0000ffff080f7812ULL, 0x000fe400078ec0ffULL, 0x000000ff02047812ULL, 0x000fe200078ec0ffULL,
0x0000001007027824ULL, 0x000fe200078e0200ULL, 0x0000ffff05057812ULL, 0x000fe400078ec0ffULL,
0x0000ffff0a0a7812ULL, 0x000fe200078ec0ffULL, 0x0000000803027824ULL, 0x000fe200078e0202ULL,
0x000076040f067816ULL, 0x000fe40000000006ULL, 0x0000760405057816ULL, 0x000fc40000000004ULL,
0x000076040a0a7816ULL, 0x000fe40000000009ULL, 0x0000541005067816ULL, 0x000fe40000000006ULL,
0x000054100a077816ULL, 0x000fca000000000bULL, 0x0084000602007388ULL, 0x0003e40000000a00ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0089a00d00ff79a7ULL, 0x0005e2000850003fULL,
0x0000001400ec7947ULL, 0x000fea0003800000ULL, 0x00009200ff087b82ULL, 0x000ea40000000a00ULL,
0x0000001008087981ULL, 0x004562000c1e9900ULL, 0x000000070300780cULL, 0x000fe20003f04070ULL,
0x00000001ff077424ULL, 0x000fc800078e00ffULL, 0x0089d80700ff79a7ULL, 0x0005f0000850003fULL,
0xff800000ff028424ULL, 0x000fe200078e00ffULL, 0x0089e80700ff79a7ULL, 0x0005e2000850003fULL,
0x0089f80700ff79a7ULL, 0x0005e2000850003fULL, 0x008a080700ff79a7ULL, 0x0005e4000850003fULL,
0x0089600215008388ULL, 0x0005e80000000800ULL, 0x008980ff15008388ULL, 0x0005e20000000800ULL,
0x008a1807000679a7ULL, 0x000ee4000850003fULL, 0x008a1807000075a7ULL, 0x008ee4000800017fULL,
0x00000034004c8947ULL, 0x00cfea0003800000ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x00000000000079c5ULL, 0x000fe20000000000ULL, 0x000000040600728cULL, 0x000fe2000bf24070ULL,
0x00000005ff147819ULL, 0x000fca0000011603ULL, 0x000000000000781cULL, 0x000fda0003f0f018ULL,
0x00000014009c0947ULL, 0x000fea0003800000ULL, 0x0000840000087ab9ULL, 0x000fe20000000800ULL,
0x0000900000077ab9ULL, 0x000fe20000000800ULL, 0x0000000804047c24ULL, 0x002fe2000f8e0205ULL,
0x00000007080772a4ULL, 0x000fe2000f8e023fULL, 0x00000000000d7919ULL, 0x000e620000000000ULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x0000c000000a7ab9ULL, 0x000fe20000000a00ULL,
0x00000000040f72caULL, 0x000fe200000e0000ULL, 0x000007ff07087891ULL, 0x000fe2000f8e103fULL,
0x0000000f03127812ULL, 0x040fe200078ec0ffULL, 0x0000000aff287e24ULL, 0x000fe2000f8e00ffULL,
0x000000ff0300720cULL, 0x040fe20000722270ULL, 0xfffff80008087892ULL, 0x000fe2000f8ec03fULL,
0x00000004ff0c7819ULL, 0x000fe20000011603ULL, 0x0000000bff297e24ULL, 0x000fe2000f8e00ffULL,
0x000000080300780cULL, 0x000fe20000701070ULL, 0x00008600000c7ab9ULL, 0x000fe20000000a00ULL,
0x00000040140f7811ULL, 0x000fe200078e20ffULL, 0x3b12492508137820ULL, 0x020fe20000410000ULL,
0x0000000414107836ULL, 0x000fe20000000000ULL, 0x000000140f0e72a4ULL, 0x000fe2000f8e0212ULL,
0x000000ffff0e7224ULL, 0x000fe200078e00ffULL, 0x00000000001c7805ULL, 0x000fc4000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x0000000e08097291ULL, 0x000fe2000f8fd03fULL,
0x0000000000187805ULL, 0x000fe4000001ff00ULL, 0x00000000001a7805ULL, 0x000fe4000001ff00ULL,
0x00000004ff0f7819ULL, 0x000fe2000001160fULL, 0xffffffff05167890ULL, 0x000fe2000fffe03fULL,
0x00000009ff027e24ULL, 0x000fe2000f8e00ffULL, 0x0000000614097899ULL, 0x000fe4000800063fULL,
0xffffffff06177890ULL, 0x000fe2000fffe03fULL, 0x0000000802057824ULL, 0x000fe200078e0203ULL,
0x00000009070972a4ULL, 0x000fe2000f8e0208ULL, 0x0000000103027812ULL, 0x000fe200078ec0ffULL,
0x000000030f077899ULL, 0x000fe2000800063fULL, 0x00000001ff037819ULL, 0x000fe20000011612ULL,
0x000007ff09097890ULL, 0x000fe2000fffe03fULL, 0x0000000805287825ULL, 0x000fe200078e0028ULL,
0x00000100070c78a5ULL, 0x000fe2000f8e000cULL, 0x0000000303037812ULL, 0x000fe200078e780cULL,
0x0000000e09097291ULL, 0x000fc8000f8fa83fULL, 0x0000000309097899ULL, 0x000fe2000800063fULL,
0x000000080c117824ULL, 0x000fc600078e0203ULL, 0x00000100090878a5ULL, 0x000fe4000f8e000aULL,
0x000000040f0a78a5ULL, 0x000fe4000f8e000aULL, 0x0000000c08187287ULL, 0x000fe40008000000ULL,
0x0000000d090d7287ULL, 0x002fd80008000000ULL, 0x000000100e037824ULL, 0x040fe200078e00ffULL,
0x000000010e077812ULL, 0x000fe200078ec0ffULL, 0x00000040ff047424ULL, 0x000fe200078e00ffULL,
0x0000008000017945ULL, 0x000fe40003800000ULL, 0x0000001003037812ULL, 0x000fe200078ec0ffULL,
0x0000001007217824ULL, 0x000fc800078e0200ULL, 0x0000000100097824ULL, 0x000fe400078e0203ULL,
0x00000001ff037424ULL, 0x000fe400078e00ffULL, 0x0089d004090479a7ULL, 0x000e64000800003fULL,
0x0089d005090075a7ULL, 0x002e64000804017fULL, 0x000000300060a947ULL, 0x002fea0003800000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0089f003210479a7ULL, 0x000e62000850003fULL,
0x000000070d00780cULL, 0x000fe20003f44070ULL, 0x0000008000017945ULL, 0x000fe20003800000ULL,
0x000000ffff067224ULL, 0x000fe400078e00ffULL, 0x000000ffff177224ULL, 0x000fd200078e00ffULL,
0x000000200708a824ULL, 0x100fe400078e0200ULL, 0x000000040d16a824ULL, 0x040fe400078e0200ULL,
0x000000040d0ba824ULL, 0x000fe200078e0208ULL, 0x0089f005210075a7ULL, 0x002e64000806017fULL,
0x00000030004cb947ULL, 0x002fea0003800000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x008800000b06a984ULL, 0x000fe20000000800ULL, 0x000000ffff087224ULL, 0x000fe400078e00ffULL,
0x000000040d0aa824ULL, 0x000fe200078e0200ULL, 0x008960001617a984ULL, 0x000e680000000800ULL,
0x008980000a08a984ULL, 0x0004a20000000800ULL, 0x008a1803000479a7ULL, 0x0004a4000850003fULL,
0x000000061700720bULL, 0x006fda0003f7e000ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x0000000000097806ULL, 0x000fc800058e0100ULL, 0x000000ff0900720cULL, 0x000fda0003f65270ULL,
0x00000000005cb947ULL, 0x000fea0003800000ULL, 0x8000000617177221ULL, 0x000fe20000010000ULL,
0x0000005509ff7812ULL, 0x040fe4000786c0ffULL, 0x000000aa09ff7812ULL, 0x000fe2000788c0ffULL,
0x3fb8aa3b17177820ULL, 0x000fcc0000410000ULL, 0x0000001700177308ULL, 0x000e680000000800ULL,
0x00000000001cb947ULL, 0x000fea0003800000ULL, 0x000000020d0a7824ULL, 0x000fca00078e00ffULL,
0x000000060a0a7812ULL, 0x000fca00078ec0ffULL, 0x00001f0a170b7589ULL, 0x002e6400000e0000ULL,
0x0000000b1c1c7220ULL, 0x082fe20000410000ULL, 0x0000000b1e1e7220ULL, 0x080fe20000410000ULL,
0x0000000b18187220ULL, 0x080fe20000410000ULL, 0x0000000b1a1a7220ULL, 0x000fce0000410000ULL,
0x000000000020c947ULL, 0x000fea0003800000ULL, 0x000000020d0a7824ULL, 0x000fca00078e00ffULL,
0x000000060a0a7812ULL, 0x000fca00078ec0ffULL, 0x000000010a0a7836ULL, 0x000fcc0000000000ULL,
0x00001f0a170a7589ULL, 0x002e6400000e0000ULL, 0x0000000a1d1d7220ULL, 0x082fe20000410000ULL,
0x0000000a1f1f7220ULL, 0x080fe20000410000ULL, 0x0000000a19197220ULL, 0x080fe20000410000ULL,
0x0000000a1b1b7220ULL, 0x000fce0000410000ULL, 0x0000001708087220ULL, 0x002fce0000410000ULL,
0x0000006000017945ULL, 0x000fe20003800000ULL, 0x008a1805000075a7ULL, 0x000262000806017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000b95dULL, 0x000fea0003900000ULL,
0x008a18050000b5a7ULL, 0x000e24000806007fULL, 0xfffffffc00ecb947ULL, 0x001fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000031400780cULL, 0x000fe20003f65270ULL,
0x0000019000017945ULL, 0x000fd80003800000ULL, 0x00000000005c3947ULL, 0x000fea0003800000ULL,
0x000000ff0900720cULL, 0x000fe20001762670ULL, 0x000000800704a824ULL, 0x140fe400078e0200ULL,
0x00000080070aa824ULL, 0x000fe400078e0200ULL, 0x000000040d09a824ULL, 0x000fe200078e0204ULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x000000800720a824ULL, 0x000fe400078e0200ULL,
0x000000040d16a824ULL, 0x000fe200078e020aULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x000000800722a824ULL, 0x000fc400078e0200ULL, 0x000000040d17b824ULL, 0x040fe400078e0200ULL,
0x000000040d20a824ULL, 0x040fe400078e0220ULL, 0x000000040d22a824ULL, 0x000fe200078e0222ULL,
0x008960061700b388ULL, 0x000fe80000000800ULL, 0x008840000905a984ULL, 0x000e680000000800ULL,
0x008860001604a984ULL, 0x000ea80000000800ULL, 0x00888000200ba984ULL, 0x000ee80000000800ULL,
0x0088a000220aa984ULL, 0x000f220000000800ULL, 0x0000000508057221ULL, 0x002fc80000010000ULL,
0x0000000405047221ULL, 0x004fe20000010000ULL, 0x000000040d05a824ULL, 0x000fc600078e0200ULL,
0x0000000b040b7221ULL, 0x008fc80000010000ULL, 0x0000000a0b0a7221ULL, 0x010fca0000010000ULL,
0x0089800a0500a388ULL, 0x0003e40000000800ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x008a1803000479a7ULL, 0x002e62000850003fULL, 0x0000220007167824ULL, 0x000fe200078e0200ULL,
0x000000c000017945ULL, 0x000fe60003800000ULL, 0x0000420016177836ULL, 0x000fca0000000000ULL,
0x0000000d17067211ULL, 0x000fc800078fc8ffULL, 0x0000000706077812ULL, 0x000fc800078ec0ffULL,
0x0000000714067212ULL, 0x080fe400078e3cffULL, 0x0000000710087212ULL, 0x000fc600078e3cffULL,
0x000000080d067824ULL, 0x040fe200078e0206ULL, 0x008a1805000075a7ULL, 0x002e62000804017fULL,
0x000000080d087824ULL, 0x000fe400078e0208ULL, 0x0000001006097824ULL, 0x100fe400078e0217ULL,
0x0000001008067824ULL, 0x000fe200078e0217ULL, 0x0000002c0018a947ULL, 0x002fec0003800000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x000000000908783bULL, 0x000e680000004200ULL, 0x000000000604783bULL, 0x000ea20000004200ULL,
0x0000624008247816ULL, 0x002fc40000000009ULL, 0x0000735108257816ULL, 0x000fe20000000009ULL,
0x0000400016087836ULL, 0x000fe20000000000ULL, 0x0000624004207816ULL, 0x104fe20000000005ULL,
0x0000402016167836ULL, 0x000fe20000000000ULL, 0x0000735104217816ULL, 0x000fe40000000005ULL,
0x0003fff008047812ULL, 0x000fe400078ec0ffULL, 0x000062400a267816ULL, 0x000fe4000000000bULL,
0x00000004ff047819ULL, 0x000fc40000011604ULL, 0x000073510a277816ULL, 0x000fe4000000000bULL,
0x00003f00040b7812ULL, 0x000fe400078ec0ffULL, 0x000001f008ff7812ULL, 0x040fe4000784c0ffULL,
0x000000ff0b0a7812ULL, 0x000fe200078ef804ULL, 0x0000040008047824ULL, 0x000fe200078e00ffULL,
0x0000624006227816ULL, 0x140fe40000000007ULL, 0x0000735106237816ULL, 0x000fc40000000007ULL,
0x000e000004047812ULL, 0x000fe400078ec0ffULL, 0x00000000000079c5ULL, 0x000fe20000000000ULL,
0x000000000a0e72caULL, 0x000fe400000e0000ULL, 0x8000002004047812ULL, 0x000fc800078efcffULL,
0x80000020040b7807ULL, 0x000fe40001000000ULL, 0x000000160e007c0cULL, 0x000fe4000bf45270ULL,
0x000000000b0f72caULL, 0x000fda00000e0000ULL, 0x0000000c241c7df3ULL, 0x000fe2000870081cULL,
0x000000000a0e72caULL, 0x000fe200000e0000ULL, 0x000000200d0a7836ULL, 0x000fe20000000000ULL,
0x000000000b0f72caULL, 0x000fc800000e0000ULL, 0x0000000a17047211ULL, 0x000fc800078fc8ffULL,
0x0000000704097812ULL, 0x000fc800078ec0ffULL, 0x0000000914057212ULL, 0x080fe200078e3cffULL,
0x0000000c20187df3ULL, 0x000fe20008000818ULL, 0x0000000910097212ULL, 0x000fc600078e3cffULL,
0x000000080a047824ULL, 0x040fe400078e0205ULL, 0x000000080a0a7824ULL, 0x000fe200078e0209ULL,
0x0003fff016097812ULL, 0x000fc600078ec0ffULL, 0x000000100a0a7824ULL, 0x000fe200078e0217ULL,
0x00000004ff097819ULL, 0x000fe20000011609ULL, 0x00008000000079c5ULL, 0x000fe40000010000ULL,
0x0000001004207824ULL, 0x000fca00078e0217ULL, 0x000000002004783bULL, 0x000e640000004200ULL,
0x0000624004247816ULL, 0x142fe40000000005ULL, 0x0000735104257816ULL, 0x000fe40000000005ULL,
0x0000624006267816ULL, 0x140fe40000000007ULL, 0x0000735106277816ULL, 0x000fe40000000007ULL,
0x000000000a04783bULL, 0x000e640000004200ULL, 0x0000624004207816ULL, 0x002fc40000000005ULL,
0x0000735104217816ULL, 0x000fe20000000005ULL, 0x000000ffff057224ULL, 0x000fe200078e000bULL,
0x00003f0009047812ULL, 0x000fe400078ec0ffULL, 0x0000624006227816ULL, 0x140fe40000000007ULL,
0x0000735106237816ULL, 0x000fe40000000007ULL, 0x000000ff04047812ULL, 0x000fe400078ef809ULL,
0x00000000000079c5ULL, 0x000fe20000000000ULL, 0x00000000050f72caULL, 0x000fc400000e0000ULL,
0x00000000040e72caULL, 0x000fda00000e0000ULL, 0x0000000c241c7df3ULL, 0x000fe2000870081cULL,
0x00000000040e72caULL, 0x000fe400000e0000ULL, 0x00000000050f72caULL, 0x000fda00000e0000ULL,
0x0000000c20187df3ULL, 0x000fe60008000818ULL, 0x00008000000079c5ULL, 0x000fe40000010000ULL,
0x0000086000017945ULL, 0x000fe80003800000ULL, 0x0000000800102947ULL, 0x000fea0003800000ULL,
0x008a1803000479a7ULL, 0x000e62000850003fULL, 0x000000080d0b7824ULL, 0x000fe200078e00ffULL,
0x0000005000027945ULL, 0x000fe80003800000ULL, 0x000000180b0b7812ULL, 0x000fca00078ec0ffULL,
0x0000000100207824ULL, 0x000fe200078e020bULL, 0x008a1805000075a7ULL, 0x002e64000804017fULL,
0x00000028000ca947ULL, 0x002fea0003800000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0089800020047984ULL, 0x000e620000000a00ULL, 0x00000008ff167e24ULL, 0x000fe2000f8e00ffULL,
0x0000018000027945ULL, 0x000fe20003800000ULL, 0x00000009ff177e24ULL, 0x000fe2000f8e00ffULL,
0x0089600015070984ULL, 0x000fe80000000800ULL, 0x0089800015060984ULL, 0x000ea20000000800ULL,
0x0180000004097836ULL, 0x002fca0000000000ULL, 0x7f800000090a7812ULL, 0x000fe200078ec0ffULL,
0x00000018ff097e24ULL, 0x000fe2000f8e00ffULL, 0x0000000628000986ULL, 0x0043e4000c101b10ULL,
0x01ffffff0a00780cULL, 0x000fe20003f44070ULL, 0x0000000dff0a7e24ULL, 0x000fe4000f8e00ffULL,
0x000000ffff090224ULL, 0x000fe400078e0016ULL, 0x00000009ff077e24ULL, 0x002fe4000f8e00ffULL,
0x00000008ff067e24ULL, 0x000fc4000f8e00ffULL, 0x000000ffff0a0224ULL, 0x000fc800078e0007ULL,
0x0000000000142947ULL, 0x000fea0003800000ULL, 0x000000ffff077224ULL, 0x000fe200078e0004ULL,
0x0000250000067802ULL, 0x000fce0000000f00ULL, 0x0000002800d87944ULL, 0x001fea0003c00000ULL,
0x000000ffff167224ULL, 0x004fe200078e0004ULL, 0x0000000000107947ULL, 0x000fec0003800000ULL,
0x0000000400077308ULL, 0x000e640000001000ULL, 0xbf80000004067423ULL, 0x002fc80000000007ULL,
0x800000ff06067221ULL, 0x000fc80000010100ULL, 0x0000000607167223ULL, 0x000fce0000000007ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0180000005047836ULL, 0x000fe20000000000ULL,
0x000000c000027945ULL, 0x000fe80003800000ULL, 0x7f80000004047812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0400780cULL, 0x000fda0003f44070ULL, 0x0000000000102947ULL, 0x000fea0003800000ULL,
0x000000ffff077224ULL, 0x000fe200078e0005ULL, 0x000025f000067802ULL, 0x000fce0000000f00ULL,
0x00000028009c7944ULL, 0x001fea0003c00000ULL, 0x0000000000107947ULL, 0x000fea0003800000ULL,
0x0000000500047308ULL, 0x000e640000001000ULL, 0xbf80000005067423ULL, 0x002fc80000000004ULL,
0x800000ff06077221ULL, 0x000fc80000010100ULL, 0x0000000704047223ULL, 0x000fce0000000004ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000001613057220ULL, 0x040fe20000410000ULL,
0x0000000413047220ULL, 0x004fc60000410000ULL, 0x000000051c1c7220ULL, 0x080fe20000410000ULL,
0x000000041d1d7220ULL, 0x080fe20000410000ULL, 0x000000051e1e7220ULL, 0x080fe20000410000ULL,
0x000000041f1f7220ULL, 0x000fe20000410000ULL, 0x0000000518187220ULL, 0x080fe20000410000ULL,
0x000000051a1a7220ULL, 0x000fe20000410000ULL, 0x0000001c1d05723eULL, 0x000fe200000000ffULL,
0x0000000419197220ULL, 0x000fe20000410000ULL, 0x0000001e1f16723eULL, 0x000fe200000000ffULL,
0x000000041b1b7220ULL, 0x000fe20000410000ULL, 0x00000002ff047819ULL, 0x000fe2000001160dULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x000000000505723aULL, 0x000fe20000000000ULL,
0x000000181907723eULL, 0x000fc400000000ffULL, 0x0000001a1b06723eULL, 0x000fe200000000ffULL,
0x000000001616723aULL, 0x000e620000000000ULL, 0x0000000314177812ULL, 0x000fe400078e7804ULL,
0x000000030f217812ULL, 0x000fe200078e7804ULL, 0x000000000707723aULL, 0x000fe40000000000ULL,
0x0000000804177824ULL, 0x040fe400078e0217ULL, 0x000000000606723aULL, 0x000ea20000000000ULL,
0x0000000804217824ULL, 0x000fe200078e0221ULL, 0x0000010000027945ULL, 0x000fe20003800000ULL,
0x0000002017047824ULL, 0x000fc400078e0208ULL, 0x0000002021207824ULL, 0x000fe400078e0208ULL,
0x000000010b177824ULL, 0x040fe400078e0204ULL, 0x000000010b207824ULL, 0x000fe200078e0220ULL,
0x0000541005047816ULL, 0x142fe40000000016ULL, 0x0000763205057816ULL, 0x000fca0000000016ULL,
0x0000000417007388ULL, 0x0005e40000000a00ULL, 0x0000541007047816ULL, 0x144fe40000000006ULL,
0x0000763207057816ULL, 0x000fe20000000006ULL, 0x0000002011077824ULL, 0x000fc800078e0208ULL,
0x0000000420007388ULL, 0x0003e20000000a00ULL, 0x0000001002077824ULL, 0x000fe200078e0207ULL,
0x008a1803000479a7ULL, 0x002e64000850003fULL, 0x008a1805000075a7ULL, 0x002e64000804017fULL,
0x0000002000dca947ULL, 0x002fea0003800000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000000007047984ULL, 0x000e620000000c00ULL, 0x000000090c097211ULL, 0x040fe200078440ffULL,
0x0000008000027945ULL, 0x000fe60003800000ULL, 0x0000000a0c0a7211ULL, 0x000fe400010f44ffULL,
0x0000000912087211ULL, 0x000fca00078420ffULL, 0x000000ffff097224ULL, 0x000fca00010e060aULL,
0x0000000408007986ULL, 0x0023e4000c101d10ULL, 0x008a1803000479a7ULL, 0x002e64000850003fULL,
0x008a1805000075a7ULL, 0x002e64000804017fULL, 0x0000002000c8a947ULL, 0x002fea0003800000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000000000789947ULL, 0x000fea0003800000ULL,
0x00000000000d7919ULL, 0x000e620000000000ULL, 0x0000000000077886ULL, 0x000fe200038e0100ULL,
0x0000000aff047e24ULL, 0x000fe2000f8e00ffULL, 0x0000000700067d00ULL, 0x000e6200080e0000ULL,
0x0000000bff057e24ULL, 0x000fce000f8e00ffULL, 0x0000000700077d09ULL, 0x000ea20008000000ULL,
0x0000000d0600720cULL, 0x002fda0003f42070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000002992ULL, 0x0003ec0000008000ULL,
0x0000000000002992ULL, 0x002fec000000a000ULL, 0x00000000000029abULL, 0x000fc00000000000ULL,
0x00000000000025abULL, 0x000fec0000000000ULL, 0x00000007040729a8ULL, 0x004ea800081ee1d0ULL,
0x00000000ff00298fULL, 0x004fe20002000000ULL, 0x00000000000a7806ULL, 0x000fe200038e0100ULL,
0x0000000000087919ULL, 0x000e640000003900ULL, 0x00001f0607007589ULL, 0x000ea200000e0000ULL,
0x00000000000c79c3ULL, 0x000ee20000008800ULL, 0x0000000708087c12ULL, 0x002fe2000f8ec0ffULL,
0x0000040000077882ULL, 0x000fc60000000000ULL, 0x0000000800097309ULL, 0x000ea40000000000ULL,
0x0000000100007824ULL, 0x004fe200078e0209ULL, 0x000006540c077896ULL, 0x008fc80008000007ULL,
0x0000001700007c0cULL, 0x000fe4000bf45270ULL, 0x00000007ff007e24ULL, 0x000fe4000f8e00ffULL,
0x00000001ff057807ULL, 0x000fca0001000000ULL, 0x008a200500007388ULL, 0x0003e80000000000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000010e057812ULL, 0x042fe200078ec0ffULL,
0x000000010e0e7836ULL, 0x000fc80000000000ULL, 0x0000001005047824ULL, 0x000fe200078e0200ULL,
0x000000050e007c0cULL, 0x000fc6000bf46070ULL, 0x0089f80304ff79a7ULL, 0x0003e2000850003fULL,
0x0089d80304ff79a7ULL, 0x0003f2000850003fULL, 0xffffffec0024a947ULL, 0x003fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000c00b87947ULL, 0x000fea0003800000ULL,
0x00009200ff087b82ULL, 0x000e640000000a00ULL, 0x0000001008097981ULL, 0x002362000c1e9900ULL,
0x000000070300780cULL, 0x000fe20003f04070ULL, 0x00000001ff077424ULL, 0x000fc800078e00ffULL,
0x0089a80700ff79a7ULL, 0x0003f0000850003fULL, 0xff317217ff028424ULL, 0x000fe200078e00ffULL,
0x0089b80700ff79a7ULL, 0x0003e2000850003fULL, 0x0089c80700ff79a7ULL, 0x0003e6000850003fULL,
0x0089400215008388ULL, 0x0003e20000000800ULL, 0x008a1007000479a7ULL, 0x000ea4000850003fULL,
0x008a1005000075a7ULL, 0x004ea4000800017fULL, 0x0000002000088947ULL, 0x006fea0003800000ULL,
0x0089a007000479a7ULL, 0x000e64000850003fULL, 0x0089a005000075a7ULL, 0x002e64000800017fULL,
0x0000002000148947ULL, 0x002fea0003800000ULL, 0x000000040600728cULL, 0x000fe2000bf24070ULL,
0x00000005ff0a7819ULL, 0x000fca0000011603ULL, 0x000000000000781cULL, 0x000fda0003f0f018ULL,
0x0000000c00680947ULL, 0x000fea0003800000ULL, 0x00000000000b7919ULL, 0x000e620000000000ULL,
0x000000100a0c7824ULL, 0x000fe400078e00ffULL, 0x3db504f309097820ULL, 0x020fe20000410000ULL,
0x000000ffff087224ULL, 0x000fe400078e00ffULL, 0x0000000c0b0c7211ULL, 0x002fce00078ff0ffULL,
0x00000015ff037e24ULL, 0x000fe2000f8e00ffULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x0000000608047c24ULL, 0x000fce000f8e0203ULL, 0x0000001008027824ULL, 0x000fe200078e00ffULL,
0x00000000000079c5ULL, 0x000fe20000000000ULL, 0x00000000000b72caULL, 0x000fe400000e0000ULL,
0x00000001080d7812ULL, 0x000fe400078ec0ffULL, 0x0000001002037812ULL, 0x000fe200078ec0ffULL,
0x00000040ff027424ULL, 0x000fe200078e00ffULL, 0x00000000000a72caULL, 0x040fe200000e0000ULL,
0x000020000d0e7824ULL, 0x000fe400078e0200ULL, 0x0000000100057824ULL, 0x000fc600078e0203ULL,
0x000000000e0872caULL, 0x000fe200000e0000ULL, 0x0089b002050279a7ULL, 0x000e62000800003fULL,
0x0000000a0b097899ULL, 0x000fe4000800063fULL, 0x000003ff0b3f7892ULL, 0x000fe4000f82c03fULL,
0x000e0000090b7892ULL, 0x000fe4000f8ec03fULL, 0x000084000a077890ULL, 0x000fe4000fffe03fULL,
0x0000003f0b0b7287ULL, 0x000fc40008800000ULL, 0x0000000a07097899ULL, 0x000fe4000800063fULL,
0x000003ff073f7892ULL, 0x000fe4000f84c03fULL, 0x0003fff007077892ULL, 0x000fe4000f8ec03fULL,
0x000e0000090c7892ULL, 0x000fe4000f8ec03fULL, 0x0003fff008097892ULL, 0x000fe4000f8ec03fULL,
0x000000043f0d7899ULL, 0x000fc40008011607ULL, 0x400000400b077892ULL, 0x000fe2000f8efc3fULL,
0x0089b003050075a7ULL, 0x002e62000800017fULL, 0x000000043f0b7899ULL, 0x000fe40008011609ULL,
0x0000003f0c097287ULL, 0x000fe40009000000ULL, 0x00003f000d0e7892ULL, 0x000fe4000f8ec03fULL,
0x00003f000b0c7892ULL, 0x000fe4000f8ec03fULL, 0x4000004009097892ULL, 0x000fc4000f8efc3fULL,
0x000000ff0e0e7892ULL, 0x000fe4000f8ef80dULL, 0x000000ff0c0c7892ULL, 0x000fe2000f8ef80bULL,
0x0000001c007c8947ULL, 0x002ff60003800000ULL, 0x00000000000079c5ULL, 0x000fe20000000000ULL,
0x00000009000f7c82ULL, 0x000fe20008000000ULL, 0x00000007000d7c82ULL, 0x000fe20008000000ULL,
0x00000020080b7890ULL, 0x000fe2000fffe03fULL, 0x0000000104027836ULL, 0x000fe40000000000ULL,
0x000000000c1879f3ULL, 0x000fe2000c7008ffULL, 0x000084200a0c7890ULL, 0x000fe2000fffe03fULL,
0x000000100d0e7824ULL, 0x000fe200078e0200ULL, 0x0003fff00b0b7892ULL, 0x000fe2000f8ec03fULL,
0x0000001302007c0cULL, 0x000fe2000bf05270ULL, 0x0003fff00c0c7892ULL, 0x000fc4000f8ec03fULL,
0x000000043f0b7899ULL, 0x000fe4000801160bULL, 0x000000043f0d7899ULL, 0x000fe4000801160cULL,
0x00003f000b0c7892ULL, 0x000fe4000f8ec03fULL, 0x00003f000d0e7892ULL, 0x000fe4000f8ec03fULL,
0x000000ff0c0c7892ULL, 0x000fe4000f8ef80bULL, 0x000000ff0e0e7892ULL, 0x000fe2000f8ef80dULL,
0x00000009000f7c82ULL, 0x000fc40008000000ULL, 0x00000007000d7c82ULL, 0x000fe20008000000ULL,
0x00000040080b7890ULL, 0x000fe4000fffe03fULL, 0x0000006008087890ULL, 0x000fe4000fffe03fULL,
0x0003fff00b0b7892ULL, 0x000fe4000f8ec03fULL, 0x0003fff008087892ULL, 0x000fe4000f8ec03fULL,
0x000000043f0b7899ULL, 0x000fe4000801160bULL, 0x000000043f087899ULL, 0x000fe20008011608ULL,
0x000000000c1879f3ULL, 0x000fe20008700818ULL, 0x000084400a0c7890ULL, 0x000fe2000fffe03fULL,
0x00000009000f7c82ULL, 0x000fe20008000000ULL, 0x000084600a0a7890ULL, 0x000fc4000fffe03fULL,
0x0003fff00c0c7892ULL, 0x000fe4000f8ec03fULL, 0x0003fff00a0a7892ULL, 0x000fe4000f8ec03fULL,
0x000000043f0d7899ULL, 0x000fe4000801160cULL, 0x00003f000b0c7892ULL, 0x000fe4000f8ec03fULL,
0x00003f000d0e7892ULL, 0x000fe4000f8ec03fULL, 0x000000ff0c0c7892ULL, 0x000fc4000f8ef80bULL,
0x000000ff0e0e7892ULL, 0x000fe4000f8ef80dULL, 0x000000043f0b7899ULL, 0x000fe2000801160aULL,
0x00000007000d7c82ULL, 0x000fe20008000000ULL, 0x00003f00080a7892ULL, 0x000fc8000f8ec03fULL,
0x000000ff0a087892ULL, 0x000fe2000f8ef808ULL, 0x000000000c1879f3ULL, 0x000fe20008700818ULL,
0x00003f000b0c7892ULL, 0x000fc8000f8ec03fULL, 0x000000ff0c0c7892ULL, 0x000fc6000f8ef80bULL,
0x00000009000b7c82ULL, 0x000fe20008000000ULL, 0x0000000700097c82ULL, 0x000fc60008000000ULL,
0x0000000c000a7c82ULL, 0x000fe40008000000ULL, 0x00000000081879f3ULL, 0x000fe60008000818ULL,
0x00008000000079c5ULL, 0x000fe40000010000ULL, 0x0089b8070eff79a7ULL, 0x0003e2000850003fULL,
0x0000000918187220ULL, 0x080fe20000410000ULL, 0x0000000919197220ULL, 0x080fe20000410000ULL,
0x000000091a0f7220ULL, 0x080fe20000410000ULL, 0x000000091b107220ULL, 0x000fe20000410000ULL,
0x0000000000280947ULL, 0x000fec0003800000ULL, 0x0000004004037824ULL, 0x000fca00078e00ffULL,
0x0000000306027248ULL, 0x000fca0007fe0000ULL, 0x0000000102037824ULL, 0x000fe400078e0a03ULL,
0x000000080c027836ULL, 0x000fc60000000000ULL, 0x000000030c00720cULL, 0x080fe40003f06070ULL,
0x000000030200720cULL, 0x000fe40003f26070ULL, 0xff80000018187808ULL, 0x000fe40004000000ULL,
0xff80000019197808ULL, 0x000fe40004000000ULL, 0xff8000000f0f7808ULL, 0x000fe40004800000ULL,
0xff80000010107808ULL, 0x000fce0004800000ULL, 0x000000180f027209ULL, 0x000fe20007810000ULL,
0x0000000108087836ULL, 0x000fe20000000000ULL, 0x0000001910047209ULL, 0x000fe20007810000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000000030b00780cULL, 0x000fe20003f04070ULL,
0x0e001f0002037f89ULL, 0x000ea200000e0000ULL, 0x0000000508007c0cULL, 0x000fc6000bf26070ULL,
0x0e001f0004057f89ULL, 0x000ee200000e0000ULL, 0x0000000302037209ULL, 0x004fe40007810000ULL,
0x0000000504057209ULL, 0x008fc60007810000ULL, 0x0d001f0003127f89ULL, 0x000ea800000e0000ULL,
0x0d001f0005147f89ULL, 0x000ee200000e0000ULL, 0x0000001203127209ULL, 0x004fe40007810000ULL,
0x0000001405147209ULL, 0x008fc60007810000ULL, 0x0c801f0012117f89ULL, 0x000ea800000e0000ULL,
0x0c801f0014137f89ULL, 0x000ee200000e0000ULL, 0x0000001112117209ULL, 0x004fe40007810000ULL,
0x0000001314137209ULL, 0x008fe20007810000ULL, 0x0000000000340947ULL, 0x000fec0003800000ULL,
0x000000ff1100720bULL, 0x000fe20003f56000ULL, 0x0000006000017945ULL, 0x000fe20003800000ULL,
0x000000080b027824ULL, 0x000fd600078e0200ULL, 0x000000000008a947ULL, 0x000fea0003800000ULL,
0x0089401102ff738cULL, 0x0005e20001000200ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0089401102ff738cULL, 0x0005e40000800000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ff1300720bULL, 0x000fda0003f56000ULL, 0x000000000008a947ULL, 0x000fea0003800000ULL,
0x0089441302ff738cULL, 0x0007e20001000200ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0089441302ff738cULL, 0x0007e40000800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x008a1007000279a7ULL, 0x00cea2000850003fULL, 0x000000080b117824ULL, 0x000fca00078e00ffULL,
0x0000001811057812ULL, 0x000fca00078ec0ffULL, 0x0000000100157824ULL, 0x000fe200078e0205ULL,
0x008a1003000075a7ULL, 0x004ea4000804017fULL, 0x0000001400f8a947ULL, 0x004fea0003800000ULL,
0x0089400015027984ULL, 0x000ea20000000a00ULL, 0x008a1007000479a7ULL, 0x000ee4000850003fULL,
0x008a1005000075a7ULL, 0x008ee2000804017fULL, 0x3fb8aa3b02137820ULL, 0x004fe20000410000ULL,
0x3fb8aa3b03147820ULL, 0x000fc60000410000ULL, 0x3fb8aa3b18127823ULL, 0x100fe20000010813ULL,
0x3fb8aa3b0f0f7823ULL, 0x000fe20000010813ULL, 0x3fb8aa3b19137823ULL, 0x100fe20000010814ULL,
0x3fb8aa3b10107823ULL, 0x000fc60000010814ULL, 0x0000001200127308ULL, 0x000ff00000000800ULL,
0x0000000f000f7308ULL, 0x000eb00000000800ULL, 0x0000001300137308ULL, 0x000fe20000000800ULL,
0x0000000f12167221ULL, 0x004fce0000010000ULL, 0x0000001000107308ULL, 0x000ea40000000800ULL,
0x0000001013187221ULL, 0x004fe20000010000ULL, 0x0000001400d0a947ULL, 0x008fec0003800000ULL,
0x0e001f0016057f89ULL, 0x000ea200000e0000ULL, 0x000000070b00780cULL, 0x000fe20003f44070ULL,
0x000001a000007945ULL, 0x000fe20003800000ULL, 0x000000ffff197224ULL, 0x000fe200078e00ffULL,
0x0e001f0018157f89ULL, 0x000ee200000e0000ULL, 0x0000000516057221ULL, 0x004fe20000010000ULL,
0x0000001518047221ULL, 0x008fc80000010000ULL, 0x0d001f0005147f89ULL, 0x000ea800000e0000ULL,
0x0d001f0004157f89ULL, 0x000ee200000e0000ULL, 0x0000001405147221ULL, 0x004fe20000010000ULL,
0x0000001504157221ULL, 0x008fc80000010000ULL, 0x0c801f0014177f89ULL, 0x0004e800000e0000ULL,
0x0c801f0015167f89ULL, 0x00052200000e0000ULL, 0x0000000000382947ULL, 0x000fea0003800000ULL,
0x0000000000197919ULL, 0x000f620000003000ULL, 0x00000001ff057819ULL, 0x000fe2000001160bULL,
0x000000040b187824ULL, 0x040fe200078e00ffULL, 0x000000060b047812ULL, 0x000fe400078ec0ffULL,
0x7ffffffc05057812ULL, 0x000fe400078ec0ffULL, 0x00000001ff047819ULL, 0x000fe40000011604ULL,
0x0000001c18187812ULL, 0x000fe200078ec0ffULL, 0x000000010a057824ULL, 0x000fca00078e0205ULL,
0x0000000405057212ULL, 0x000fca00078e3cffULL, 0x0000000105057824ULL, 0x000fe400078e0218ULL,
0x00000001001a7824ULL, 0x020fc800078e0219ULL, 0x000022000d047824ULL, 0x000fc800078e021aULL,
0x0000001005047824ULL, 0x000fc800078e0204ULL, 0x0000400004197836ULL, 0x000fce0000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0089f8070e0479a7ULL, 0x000f64000850003fULL,
0x0089f8050e0075a7ULL, 0x020f64000804017fULL, 0x000000140068a947ULL, 0x020fea0003800000ULL,
0x00000000000779c3ULL, 0x000f620000003000ULL, 0x43e0000012127820ULL, 0x000fe20000410000ULL,
0x43e000000f0f7820ULL, 0x000fe20000410000ULL, 0x43e0000013137820ULL, 0x000fe20000410000ULL,
0x43e0000010107820ULL, 0x000fe20000410000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x0000001714177221ULL, 0x008fe20000010000ULL, 0x000000120f0f723eULL, 0x000fe2000480710fULL,
0x0000001615167221ULL, 0x010fe20000010000ULL, 0x000000131010723eULL, 0x000fc80004807110ULL,
0x000054100f0f7816ULL, 0x000fe20000000010ULL, 0x8000000719047c36ULL, 0x020fca0008000000ULL,
0x0000000f04007844ULL, 0x0007e20000004000ULL, 0x0000000000280947ULL, 0x000fea0003800000ULL,
0x000000ff0a00720cULL, 0x040fe20003f05270ULL, 0x000000800d057824ULL, 0x140fe400078e0200ULL,
0x000000200d047824ULL, 0x008fe400078e0200ULL, 0x000000200a107824ULL, 0x000fe400078e0205ULL,
0x0000000111047824ULL, 0x000fe400078e0204ULL, 0x000000080b107824ULL, 0x000fc800078e0210ULL,
0x0088000204008388ULL, 0x0007e80000000800ULL, 0x0088401710007388ULL, 0x0007e80000000800ULL,
0x0088040304008388ULL, 0x0007e80000000800ULL, 0x0088441610007388ULL, 0x0007e40000000800ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0089f0070eff79a7ULL, 0x0009e4000850003fULL,
0xfffffff000ac9947ULL, 0x01ffea000383ffffULL, 0x0089a80700ff79a7ULL, 0x0003e4000850003fULL,
0x0000000000047919ULL, 0x000ee20000002300ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x000000783f077890ULL, 0x000fe2000ff3e03fULL,
0x000000000000781cULL, 0x000fc60003f2f008ULL, 0x0000003f3f0c7290ULL, 0x000fe20008ffe43fULL,
0x00000100000e7ab9ULL, 0x000fe20000000800ULL, 0x0000000000057919ULL, 0x002ee40000002200ULL,
0x0000000307077899ULL, 0x000fe2000800120cULL, 0x0000000000077919ULL, 0x000e640000002100ULL,
0x00000000000c7ab9ULL, 0x000fe20000000800ULL, 0x0000000107077890ULL, 0x000fe2000fffe03fULL,
0x0000000e04027c24ULL, 0x008fc8000f8e0205ULL, 0x0000000c02037c24ULL, 0x002fca000f8e0207ULL,
0x0000000703007c0cULL, 0x000fda000bf06070ULL, 0x0000000803008824ULL, 0x004fc800078e0200ULL,
0x0089a000000089b1ULL, 0x0002a4000800003fULL, 0x000000000000994dULL, 0x004fea0003800000ULL,
0x00000000000c79c3ULL, 0x000ee20000008800ULL, 0x0000040000077882ULL, 0x000fe40000000000ULL,
0x000006540c077896ULL, 0x008fd20008000007ULL, 0x008a2007ff007984ULL, 0x006e640008000000ULL,
0x000000ff0000720cULL, 0x002fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000405ff7212ULL, 0x000fc8000784fcffULL,
0x000000040700780cULL, 0x000fda0005741070ULL, 0x00000000005ca947ULL, 0x000fea0003800000ULL,
0x0000000707007c11ULL, 0x000fe2000f8e20ffULL, 0x001ffffe00047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x7ffff80000057882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fd60000000000ULL, 0x00000000000812caULL, 0x002fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ee40000000000ULL, 0x00210004083f75b2ULL, 0x0042f00008000100ULL,
0xfffffffd00e81947ULL, 0x008fea000393ffffULL, 0x0000000000007918ULL, 0x004fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x001ffe0000047882ULL, 0x002fe20000000000ULL,
0x7ff8000000057882ULL, 0x000fd60000000000ULL, 0x00000000000812caULL, 0x002fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ee40000000000ULL, 0x00210804083f75b2ULL, 0x0042f00008000100ULL,
0xfffffffd00e81947ULL, 0x008fea000393ffffULL, 0x00000100ff057424ULL, 0x000fc800078e00ffULL,
0x0021080500ff79a7ULL, 0x0045e6000850003fULL, 0x00000005ff037819ULL, 0x000fe20000011603ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x00001fff03037589ULL, 0x000ee400000e0000ULL,
0x00000000030572caULL, 0x00afe200000e0000ULL, 0x0000000000007b1dULL, 0x000fd80000010000ULL,
0x000000080500788cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x00000004002c8947ULL, 0x000fea0003800000ULL, 0x00000000000479c3ULL, 0x000fe20000002600ULL,
0x0000000b05067890ULL, 0x000fe2000fffe106ULL, 0x0000840000097ab9ULL, 0x000fc60000000800ULL,
0x000000023f067899ULL, 0x000fc60008011606ULL, 0x00000000000879c3ULL, 0x000e660000002700ULL,
0x00000006ff007c0cULL, 0x000fe2000bf05270ULL, 0x00000009080a72a4ULL, 0x002fd8000f8e0204ULL,
0x0000000800688947ULL, 0x000fea0003800000ULL, 0x0000000000077919ULL, 0x000e620000000000ULL,
0x0000900000047ab9ULL, 0x000fe20000000800ULL, 0x0000030000087ab9ULL, 0x000fe20000000800ULL,
0x00000004090972a4ULL, 0x000fe4000f8e023fULL, 0x0000000608047899ULL, 0x000fe4000800063fULL,
0x000007ff090b7891ULL, 0x000fc8000f8e103fULL, 0xfffff8000b0e7892ULL, 0x000fe4000f8ec03fULL,
0xfffffff8050b7890ULL, 0x000fe4000fffe03fULL, 0x00000004090472a4ULL, 0x000fe4000f8e020eULL,
0x000000080a0572a4ULL, 0x000fe4000f8e023fULL, 0x000007ff040a7890ULL, 0x000fc6000fffe03fULL,
0x0000003f00047c82ULL, 0x000fd20008000000ULL, 0x0000000b04087291ULL, 0x000fe2000f8e103fULL,
0x000000070700780cULL, 0x042fe20003f64070ULL, 0x0000000104047890ULL, 0x000fe2000fffe03fULL,
0x000000ff0700720cULL, 0x000fe20003f25270ULL, 0x0000000408097892ULL, 0x000fe4000f8ec03fULL,
0x00000004080c7899ULL, 0x000fe4000800063fULL, 0x000000023f097899ULL, 0x000fe40008011609ULL,
0x000000300c0c7892ULL, 0x000fc4000f8ec03fULL, 0x0000001f09097899ULL, 0x000fe4000800063fULL,
0x000000060400728cULL, 0x000fe4000bf06070ULL, 0x0000000cff037e24ULL, 0x000fe2000f8e00ffULL,
0x00000008050f7290ULL, 0x000fe2000fffe03fULL, 0x00000009ff007e24ULL, 0x004fe2000f8e00ffULL,
0x00000003080d7892ULL, 0x000fe4000f8ec03fULL, 0x0000000c070c7290ULL, 0x000fe4000fffe03fULL,
0x00210800030075a7ULL, 0x000e640008000147ULL, 0x0000000c00908947ULL, 0x002ff00003800000ULL,
0x0000014000007945ULL, 0x000fe80003800000ULL, 0x0000000000483947ULL, 0x000fea0003800000ULL,
0x0000000f0e0c7291ULL, 0x000fe2000f8fd03fULL, 0x0000c00000087ab9ULL, 0x000fc60000000a00ULL,
0x000000400c0878a5ULL, 0x000fe4000f8e0008ULL, 0x000000070d0c7291ULL, 0x000fc8000f8e303fULL,
0x00000008ff027e24ULL, 0x000fe2000f8e00ffULL, 0x000000070d087291ULL, 0x000fe2000f8e203fULL,
0x00000009ff037e24ULL, 0x000fe2000f8e00ffULL, 0x0000000c07057c11ULL, 0x040fe2000f8e18ffULL,
0x0000000807027825ULL, 0x000fca00078e0002ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0200000002057faeULL, 0x0003e2000b921a50ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000210008087890ULL, 0x000fd2000fffe03fULL, 0x000000ffffff79a7ULL, 0x000fe20008200408ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a88ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000d000007945ULL, 0x000fe80003800000ULL,
0x00000000002c1947ULL, 0x000fea0003800000ULL, 0x0000000f0a0c7291ULL, 0x000fe2000f8fa83fULL,
0x00000800ff007424ULL, 0x000fe200078e00ffULL, 0x000000070d147291ULL, 0x000fe2000f8e203fULL,
0x0000c00000087ab9ULL, 0x000fe20000000a00ULL, 0x000000070d127291ULL, 0x000fe4000f8e583fULL,
0x000008000c0878a5ULL, 0x000fe4000f8e0008ULL, 0x0000210014137890ULL, 0x000fe2000fffe03fULL,
0x00000080000c7882ULL, 0x000fd00000000000ULL, 0x00000012080073baULL, 0x0003e2000800020cULL,
0x00210000ffff79a7ULL, 0x0003e40008000014ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0xfffffffc00288947ULL, 0x021fea000383ffffULL, 0x00000004005c7947ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x004e620000000000ULL, 0x00000006ff007c0cULL, 0x000fda000bf05270ULL,
0x0000000000f08947ULL, 0x000fea0003800000ULL, 0x000000ffff057224ULL, 0x000fe200078e00ffULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0xff317217ff047424ULL, 0x000fe200078e00ffULL,
0x0000000000087805ULL, 0x020fe2000001ff00ULL, 0x0000003f00047c82ULL, 0x000fcc0008000000ULL,
0x0000000404087892ULL, 0x000fe4000f8ec03fULL, 0x0000000404097899ULL, 0x000fe4000800063fULL,
0x000000023f087899ULL, 0x000fe40008011608ULL, 0x0000003009097892ULL, 0x000fe4000f8ec03fULL,
0x0000001f080b7899ULL, 0x000fe4000800063fULL, 0x00000003040c7892ULL, 0x000fc4000f8ec03fULL,
0x00000009ff037e24ULL, 0x000fe2000f8e00ffULL, 0x0000000907097290ULL, 0x000fe2000fffe03fULL,
0x0000000bff027e24ULL, 0x000fe2000f8e00ffULL, 0x000000070c0a7291ULL, 0x000fe4000f8e583fULL,
0x000000070c087291ULL, 0x000fe4000f8e303fULL, 0x00210002030075a7ULL, 0x000ea20008000147ULL,
0x0000000a050a7291ULL, 0x000fe4000f8e403fULL, 0x0000000805087291ULL, 0x000fc8000f8e183fULL,
0x0000000a000a7c11ULL, 0x002fe2000f8e18ffULL, 0x0000000800bc8947ULL, 0x004fee0003800000ULL,
0x00200008ff027984ULL, 0x000e620008000a00ULL, 0x0000000104047890ULL, 0x000fc6000fffe03fULL,
0x000000000a0a7984ULL, 0x000ea20000000a00ULL, 0x000000060400728cULL, 0x000fe2000bf06070ULL,
0x000000040300720bULL, 0x002fe20003f14000ULL, 0x2000000aff0c7230ULL, 0x004fe40000004100ULL,
0x3000000aff0d7230ULL, 0x000fe40000004100ULL, 0x2000000bff0e7230ULL, 0x000fe40000004100ULL,
0x3000000bff0f7230ULL, 0x000fcc0000004100ULL, 0x0000000000280947ULL, 0x000fea0003800000ULL,
0x0000000304037221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b03037820ULL, 0x000fcc0000410000ULL,
0x0000000300037308ULL, 0x000e640000000800ULL, 0x0000000302027220ULL, 0x002fc80000410000ULL,
0x000000020c097223ULL, 0x080fe20000010009ULL, 0x000000020d087223ULL, 0x080fe20000010008ULL,
0x000000020e077223ULL, 0x080fe20000010007ULL, 0x000000020f067223ULL, 0x000fe20000010006ULL,
0x0000000502057221ULL, 0x000fe20000010000ULL, 0x0000000000347947ULL, 0x000fec0003800000ULL,
0x8000000304047221ULL, 0x000fe20000010000ULL, 0x0000000d020d7220ULL, 0x040fe20000410000ULL,
0x0000000f020f7220ULL, 0x000fe40000410000ULL, 0x3fb8aa3b040a7820ULL, 0x000fe20000410000ULL,
0x0000000c02047220ULL, 0x040fe20000410000ULL, 0x0000000e020c7220ULL, 0x000fe40000410000ULL,
0x0000000a000b7308ULL, 0x000e640000000800ULL, 0x000000090b097223ULL, 0x042fe20000010004ULL,
0x000000050b057223ULL, 0x040fe20000010002ULL, 0x000000080b087223ULL, 0x040fe2000001000dULL,
0x000000070b077223ULL, 0x040fe2000001000cULL, 0x000000060b067223ULL, 0x000fe2000001000fULL,
0x000000ffff047224ULL, 0x000fce00078e0003ULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x000000070c087291ULL, 0x000fe2000f8e203fULL, 0x00000001ff027424ULL, 0x000fd000078e00ffULL,
0x00210802ffff79a7ULL, 0x0003e60008500008ULL, 0xfffffffc00288947ULL, 0x003fea000383ffffULL,
0x00000000000c7947ULL, 0x000fea0003800000ULL, 0x000000ffff057224ULL, 0x000fe200078e00ffULL,
0x0000000000067805ULL, 0x000fe4000001ff00ULL, 0x0000000000087805ULL, 0x020fce000001ff00ULL,
0x00000000000479c3ULL, 0x000fe20000002600ULL, 0x0000840000087ab9ULL, 0x000fe20000000800ULL,
0x0000000500057308ULL, 0x000eac0000001000ULL, 0x00000000000679c3ULL, 0x000ee20000002700ULL,
0x0000000905097220ULL, 0x044fe20000410000ULL, 0x0000000805087220ULL, 0x040fe20000410000ULL,
0x0000000705077220ULL, 0x040fe20000410000ULL, 0x0000000605067220ULL, 0x000fe20000410000ULL,
0x0000000400057824ULL, 0x002fc400078e00ffULL, 0x000000090808723eULL, 0x000fe400000000ffULL,
0x000000070609723eULL, 0x000fe200000000ffULL, 0x00000008060472a4ULL, 0x008fc6000f8e0204ULL,
0x0000860000087ab9ULL, 0x000fe20000000a00ULL, 0x0000000504057291ULL, 0x000fc8000f80183fULL,
0x0000003f3f067290ULL, 0x000fe400087fe43fULL, 0x0000000805047291ULL, 0x000fc8000f80403fULL,
0x0000000905057291ULL, 0x000fe400080f4406ULL, 0x00000004ff027e24ULL, 0x000fc8000f8e00ffULL,
0x00000005ff037e24ULL, 0x000fe4000f8e00ffULL, 0x0000000205027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x0003e4000c101b10ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000000000a94dULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x004e240000002100ULL,
0x0000000700007c11ULL, 0x001fc8000f8e20ffULL, 0x00210800000079b1ULL, 0x000e24000800003fULL,
0x00210000000079b1ULL, 0x001fe2000800003fULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0089d803090075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x0089d803090085a7ULL, 0x000e24000800007fULL,
0xfffffffc00ec8947ULL, 0x001fea000383ffffULL, 0xffffffbc00d87947ULL, 0x001fea000383ffffULL,
0x0089b803090075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x0089b803090085a7ULL, 0x000e24000800007fULL,
0xfffffffc00ec8947ULL, 0x001fea000383ffffULL, 0xffffffc000707947ULL, 0x001fea000383ffffULL,
0x0089a80f000075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x0089a80f000085a7ULL, 0x000e24000800007fULL,
0xfffffffc00ec8947ULL, 0x001fea000383ffffULL, 0xffffffc000ec7947ULL, 0x021fea000383ffffULL,
0x008a1807000075a7ULL, 0x0004a2000800017fULL, 0x0000a0000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x008a1807000085a7ULL, 0x000e24000800007fULL,
0xfffffffc00ec8947ULL, 0x001fea000383ffffULL, 0xffffffc8009c7947ULL, 0x023fea000383ffffULL,
0x0089d005090075a7ULL, 0x000262000804017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000a95dULL, 0x000fea0003900000ULL, 0x0089d0050900a5a7ULL, 0x000e24000804007fULL,
0xfffffffc00eca947ULL, 0x001fea000383ffffULL, 0xffffffcc00887947ULL, 0x001fea000383ffffULL,
0x0089f005210075a7ULL, 0x000262000806017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000b95dULL, 0x000fea0003900000ULL, 0x0089f0052100b5a7ULL, 0x000e24000806007fULL,
0xfffffffc00ecb947ULL, 0x001fea000383ffffULL, 0xffffffcc009c7947ULL, 0x001fea000383ffffULL,
0x008a1805000075a7ULL, 0x000262000804017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000a95dULL, 0x000fea0003900000ULL, 0x008a18050000a5a7ULL, 0x000e24000804007fULL,
0xfffffffc00eca947ULL, 0x001fea000383ffffULL, 0xffffffd000d07947ULL, 0x001fea000383ffffULL,
0x008a1805000075a7ULL, 0x000262000804017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000a95dULL, 0x000fea0003900000ULL, 0x008a18050000a5a7ULL, 0x000e24000804007fULL,
0xfffffffc00eca947ULL, 0x001fea000383ffffULL, 0xffffffd400dc7947ULL, 0x001fea000383ffffULL,
0x008a1805000075a7ULL, 0x000262000804017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000a95dULL, 0x000fea0003900000ULL, 0x008a18050000a5a7ULL, 0x000e24000804007fULL,
0xfffffffc00eca947ULL, 0x001fea000383ffffULL, 0xffffffdc000c7947ULL, 0x001fea000383ffffULL,
0x008a1805000075a7ULL, 0x000262000804017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000a95dULL, 0x000fea0003900000ULL, 0x008a18050000a5a7ULL, 0x000e24000804007fULL,
0xfffffffc00eca947ULL, 0x001fea000383ffffULL, 0xffffffdc00207947ULL, 0x001fea000383ffffULL,
0x008a1005000075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x008a1005000085a7ULL, 0x000e24000800007fULL,
0xfffffffc00ec8947ULL, 0x001fea000383ffffULL, 0xffffffdc00e07947ULL, 0x021fea000383ffffULL,
0x0089a005000075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x0089a005000085a7ULL, 0x000e24000800007fULL,
0xfffffffc00ec8947ULL, 0x001fea000383ffffULL, 0xffffffdc00d47947ULL, 0x021fea000383ffffULL,
0x0089b003050075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x0089b003050085a7ULL, 0x000e24000800007fULL,
0xfffffffc00ec8947ULL, 0x001fea000383ffffULL, 0xffffffe0006c7947ULL, 0x001fea000383ffffULL,
0x008a1003000075a7ULL, 0x0004a2000804017fULL, 0x0000a0000000791aULL, 0x000fc80000000000ULL,
0x009896800000a95dULL, 0x000fea0003900000ULL, 0x008a10030000a5a7ULL, 0x000e24000804007fULL,
0xfffffffc00eca947ULL, 0x001fea000383ffffULL, 0xffffffe400f07947ULL, 0x003fea000383ffffULL,
0x008a1005000075a7ULL, 0x0004a2000804017fULL, 0x0000a0000000791aULL, 0x000fc80000000000ULL,
0x009896800000a95dULL, 0x000fea0003900000ULL, 0x008a10050000a5a7ULL, 0x000e24000804007fULL,
0xfffffffc00eca947ULL, 0x001fea000383ffffULL, 0xffffffe800187947ULL, 0x003fea000383ffffULL,
0x0089f8050e0075a7ULL, 0x000b62000804017fULL, 0x0000d0000000791aULL, 0x000fc80000000000ULL,
0x009896800000a95dULL, 0x000fea0003900000ULL, 0x0089f8050e00a5a7ULL, 0x000e24000804007fULL,
0xfffffffc00eca947ULL, 0x001fea000383ffffULL, 0xffffffe800807947ULL, 0x01ffea000383ffffULL,
0x00000009ff027e24ULL, 0x000fe4000f8e00ffULL, 0x00000009ff037e24ULL, 0x000fce000f8e00ffULL,
0x0000000cff057e24ULL, 0x000fc8000f8e00ffULL, 0x00210803050075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x00210803050085a7ULL, 0x000e24000800007fULL, 0xfffffffc00e88947ULL, 0x001fea000383ffffULL,
0xfffffff0004c7947ULL, 0x021fea000383ffffULL, 0x0000000bff027e24ULL, 0x000fe4000f8e00ffULL,
0x0000000bff037e24ULL, 0x000fce000f8e00ffULL, 0x00000009ff0b7e24ULL, 0x000fc8000f8e00ffULL,
0x002100030b0075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x002100030b0085a7ULL, 0x000e24000800007fULL,
0xfffffffc00e88947ULL, 0x001fea000383ffffULL, 0xfffffff400207947ULL, 0x001fea000383ffffULL,
0x0180000007047836ULL, 0x000fe20000000000ULL, 0x0000013000037945ULL, 0x000fe80003800000ULL,
0x7f80000004177812ULL, 0x000fc800078ec0ffULL, 0x018000001700780cULL, 0x000fda0003f45070ULL,
0x000000070004a308ULL, 0x0000620000001000ULL, 0x000000000038a947ULL, 0x000fea0003800000ULL,
0x000000ff1700720cULL, 0x040fe40003f65070ULL, 0x008000001700780cULL, 0x000fe40003f42070ULL,
0x00000001ff177807ULL, 0x000fe40001800000ULL, 0x00000001ff047807ULL, 0x002fc80005000000ULL,
0x0000000417ff7212ULL, 0x000fda000784fcffULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x007fffff07ff7812ULL, 0x040fe4000784c0ffULL, 0x8000000007077812ULL, 0x001fe400078ec0ffULL,
0x00000001ff047807ULL, 0x000fc80001000000ULL, 0x0000000417ff7212ULL, 0x000fda000784c0ffULL,
0x0080000007042812ULL, 0x000fe200078efcffULL, 0x000000ffff04a224ULL, 0x000fe200078e0007ULL,
0x0000000000047947ULL, 0x000fec0003800000ULL, 0x0000000700047308ULL, 0x0002a40000001000ULL,
0x0000000000037941ULL, 0x000fea0003800000ULL, 0x00000000ff077424ULL, 0x003fc800078e00ffULL,
0xffffffac068c7950ULL, 0x000fea0003c3ffffULL, 0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100008a80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000015bULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000001c5ULL, 0x00000000000001ccULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000398ULL, 0x0000000000000150ULL,
0x0000000c00000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000cbULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000004e8ULL, 0x00000000000000d8ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000005c0ULL, 0x0000000000000048ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000608ULL, 0x000000000000070cULL,
0x0000000d00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000126ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000d14ULL, 0x0000000000000020ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000008ULL, 0x00000004000000b5ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000d38ULL, 0x0000000000000000ULL,
0x0000000d00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000edULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000d38ULL, 0x0000000000000030ULL,
0x0000000c00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000400000114ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000d68ULL, 0x0000000000000048ULL,
0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000006dULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000db0ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008fULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000db8ULL, 0x0000000000000010ULL,
0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000000ULL, 0x0000000100000032ULL,
0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000000e00ULL, 0x0000000000005280ULL,
0x0000000c00000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007fULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000006080ULL, 0x0000000000000008ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL,
0x0000000000000043ULL, 0x0000000000000000ULL, 0x0000000000006090ULL, 0x0000000000000400ULL,
0x0000000d00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000100000142ULL,
0x0000000000000042ULL, 0x0000000000000000ULL, 0x0000000000006090ULL, 0x0000000000000308ULL,
0x0000000d00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL,
0x00000000000067d8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x00000000000067d8ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000000db0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000018ULL, 0x0000000000000018ULL, 0x0000000000000008ULL,
0x0000000500000001ULL, 0x0000000000000e00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000005280ULL, 0x0000000000005280ULL, 0x0000000000000008ULL, 0x0000000600000001ULL,
0x0000000000006080ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000010ULL,
0x0000000000000410ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000006090ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000308ULL, 0x0000000000000308ULL,
0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_nqpkv_8_m_8_sm_90_cubin_len = 26920;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
