/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_pagedKV_128_nqpkv_0_m_16_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000014ad0ULL, 0x0000000000014750ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45316a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6c61685f5f374944ULL, 0x6a4c45326a4c3266ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL,
0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x6a49636556334944ULL, 0x316a4c4545346a4cULL, 0x454536316a4c4536ULL,
0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x34366a4c4545346aULL,
0x61324545346a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL, 0x614d6e4974736e49ULL,
0x6a4c45326a4c4974ULL, 0x4c45316a4c454532ULL, 0x497461324545316aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL, 0x316a4c45326a4c45ULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL,
0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL,
0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL,
0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL, 0x61324545316a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL,
0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL,
0x45326a4c45326a4cULL, 0x316a4c45326a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL,
0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL,
0x4963655633494432ULL, 0x6a4c4545346a4c6aULL, 0x4545386a4c453631ULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x6e695f5f2400676eULL,
0x305f6c616e726574ULL, 0x616475635f5f245fULL, 0x63725f30326d735fULL, 0x7a74665f6e725f70ULL,
0x6f6c735f3233665fULL, 0x5f24006874617077ULL, 0x616e7265746e695fULL, 0x635f5f245f315f6cULL,
0x30376d735f616475ULL, 0x6e79736c6668735fULL, 0x705f796c66625f63ULL, 0x65746e695f5f2400ULL,
0x245f325f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL, 0x7864695f636e7973ULL,
0x6e695f5f2400705fULL, 0x335f6c616e726574ULL, 0x616475635f5f245fULL, 0x6f765f30376d735fULL,
0x625f636e79736574ULL, 0x722e00746f6c6c61ULL, 0x747865742e616c65ULL, 0x5f6c656e72656b2eULL,
0x6c65722e0061686dULL, 0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x6c656e72656b2400ULL,
0x656d732461686d5fULL, 0x667542657479426dULL, 0x6e6f632e766e2e00ULL, 0x6b2e30746e617473ULL,
0x686d5f6c656e7265ULL, 0x6d617261705f0061ULL, 0x5f67756265642e00ULL, 0x722e00656d617266ULL,
0x67756265642e6c65ULL, 0x2e00656d6172665fULL, 0x6265642e616c6572ULL, 0x656d6172665f6775ULL,
0x6c65722e766e2e00ULL, 0x006e6f697463612eULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000100000096ULL,
0x0000000000000014ULL, 0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00090001000000b1ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0001000000baULL, 0x0000000000000038ULL, 0x0000000000000010ULL, 0x000c0001000000f8ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000131ULL, 0x0000000000000030ULL,
0x0000000000000004ULL, 0x000c000100000178ULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000c0001000001baULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c000100000200ULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000c000100000247ULL, 0x0000000000000034ULL,
0x0000000000000004ULL, 0x000c00010000028dULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c0001000002dbULL, 0x0000000000000020ULL, 0x0000000000000004ULL, 0x000c000100000329ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c000100000377ULL, 0x000000000000002cULL,
0x0000000000000004ULL, 0x000c0001000003c5ULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000c00010000040bULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000459ULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b00220000049fULL, 0x0000000000012ad0ULL,
0x0000000000000180ULL, 0x000b0022000004d2ULL, 0x0000000000012c50ULL, 0x0000000000000040ULL,
0x000b0022000004fdULL, 0x0000000000012c90ULL, 0x0000000000000050ULL, 0x000b002200000527ULL,
0x0000000000012ce0ULL, 0x0000000000000120ULL, 0x000a000300000595ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00040003000005b5ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00070003000005e5ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL,
0x0000000000000000ULL, 0x0000000000012e00ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00012ad000000000ULL,
0x0000040400000000ULL, 0x810c000000180400ULL, 0x004a900408288080ULL, 0x0000000000000000ULL,
0x00000094ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8908288080820828ULL, 0x2880808b08288080ULL,
0x808d082880808c08ULL, 0x082880808e082880ULL, 0x8080910828808090ULL, 0x9308288080920828ULL,
0x2880809508288080ULL, 0x80a0082880809d08ULL, 0x08288080a1082880ULL, 0x8080ad08288080a6ULL,
0x8016288080840828ULL, 0x0000000310288082ULL, 0x8084920000000000ULL, 0x0000000022002880ULL,
0x00000034ffffffffULL, 0x0000007000000000ULL, 0x00012ad000000000ULL, 0x0000018000000000ULL,
0x0000480400000000ULL, 0x8080288080820900ULL, 0x0900000010042880ULL, 0x2880808228808084ULL,
0x00000094ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8408288080820828ULL, 0x2880808908288080ULL,
0x808d082880808b08ULL, 0x082880808e082880ULL, 0x808090082880808fULL, 0x9308288080910828ULL,
0x2880809508288080ULL, 0x80a0082880809d08ULL, 0x08288080a1082880ULL, 0x8080ad08288080a6ULL,
0x80162880808c0828ULL, 0x0000000310288082ULL, 0x808c920000000000ULL, 0x0000000022002880ULL,
0x0000001cffffffffULL, 0x0000015000000000ULL, 0x00012c5000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x0000009cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8408288080820828ULL,
0x2880808908288080ULL, 0x808c082880808b08ULL, 0x082880808d082880ULL, 0x80808f082880808eULL,
0x9108288080900828ULL, 0x2880809208288080ULL, 0x809d082880809508ULL, 0x08288080a0082880ULL,
0x8080a608288080a1ULL, 0x9308288080ad0828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL,
0x0028808093920000ULL, 0x0000000000000022ULL, 0x0000002cffffffffULL, 0x0000021800000000ULL,
0x00012c9000000000ULL, 0x0000005000000000ULL, 0x00000c0400000000ULL, 0x808e288080930900ULL,
0x0000000000002880ULL, 0x0000009cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8408288080820828ULL,
0x2880808908288080ULL, 0x808c082880808b08ULL, 0x082880808d082880ULL, 0x80808f082880808eULL,
0x9108288080900828ULL, 0x2880809308288080ULL, 0x809d082880809508ULL, 0x08288080a0082880ULL,
0x8080a608288080a1ULL, 0x9208288080ad0828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL,
0x0028808092920000ULL, 0x0000000000000022ULL, 0x0000001cffffffffULL, 0x000002f800000000ULL,
0x00012ce000000000ULL, 0x0000012000000000ULL, 0x0000000000000000ULL, 0x0000001b00082f04ULL,
0x0008230400000080ULL, 0x0000000000000017ULL, 0x0000001700081204ULL, 0x0008110400000000ULL,
0x0000000000000017ULL, 0x0000001600082304ULL, 0x0008120400000000ULL, 0x0000000000000016ULL,
0x0000001600081104ULL, 0x0008230400000000ULL, 0x0000000000000015ULL, 0x0000001500081204ULL,
0x0008110400000000ULL, 0x0000000000000015ULL, 0x0000001400082304ULL, 0x0008120400000000ULL,
0x0000000000000014ULL, 0x0000001400081104ULL, 0x0008230400000000ULL, 0x000000000000001bULL,
0x0000001b00081204ULL, 0x0008110400000008ULL, 0x000000080000001bULL, 0x0000007b00043704ULL,
0x0000001800080a04ULL, 0x0060190300600160ULL, 0x00000000000c1704ULL, 0x0021f00000580009ULL,
0x00000000000c1704ULL, 0x0021f00000500008ULL, 0x00000000000c1704ULL, 0x0011f00000480007ULL,
0x00000000000c1704ULL, 0x0081f00000280006ULL, 0x00000000000c1704ULL, 0x0021f00000200005ULL,
0x00000000000c1704ULL, 0x0021f00000180004ULL, 0x00000000000c1704ULL, 0x0021f00000100003ULL,
0x00000000000c1704ULL, 0x0011f00000080002ULL, 0x00000000000c1704ULL, 0x0011f00000040001ULL,
0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x0004310400801b03ULL, 0x0134290400000920ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x01342804ffffffffULL, 0x00000490000002d0ULL,
0x000025a0000005a0ULL, 0x0000278000002650ULL, 0x00002d60000028e0ULL, 0x00002de000002d90ULL,
0x00004d3000002e30ULL, 0x00004f0000004dd0ULL, 0x000054f000005060ULL, 0x0000557000005520ULL,
0x000072f0000055c0ULL, 0x000074c000007390ULL, 0x00007ab000007620ULL, 0x00007b3000007ae0ULL,
0x0000991000007b80ULL, 0x00009ae0000099b0ULL, 0x0000a11000009c40ULL, 0x0000a1900000a140ULL,
0x0000b4600000a1e0ULL, 0x000113d00000b470ULL, 0x0001142000011410ULL, 0x0001144000011430ULL,
0x000114c0000114a0ULL, 0x00012110000114e0ULL, 0x000121a000012150ULL, 0x00012230000121e0ULL,
0x000122d000012280ULL, 0x0001236000012310ULL, 0x000123f0000123a0ULL, 0x0001249000012440ULL,
0x00012520000124d0ULL, 0x000125b000012560ULL, 0x0001265000012600ULL, 0x000126e000012690ULL,
0x0001277000012720ULL, 0x00012810000127c0ULL, 0x000128d000012870ULL, 0x0001299000012930ULL,
0x00012a50000129f0ULL, 0x0440390400012ab0ULL, 0x000000ff00000390ULL, 0x003f01000000f600ULL,
0x0000000d00000400ULL, 0x003f01200000f608ULL, 0x0000000d00000500ULL, 0x003f01200000f688ULL,
0x0000000d00000530ULL, 0x003f01200000f6a8ULL, 0x0000000d00000560ULL, 0x003f01200000f6c8ULL,
0x000000ff00000940ULL, 0x003f01070000f600ULL, 0x0000000200000b30ULL, 0x003f010200000004ULL,
0x0000000200000bf0ULL, 0x003f010100000000ULL, 0x0000007a000013b0ULL, 0x003f01070000f6a8ULL,
0x0000007a000014c0ULL, 0x003f01010000f6a8ULL, 0x0000000600001520ULL, 0x003f01010000f6c8ULL,
0x0000000b00001680ULL, 0x003f01050000f6ccULL, 0x0000000b00001870ULL, 0x003f01050000f6ccULL,
0x000000ff000021c0ULL, 0x000501070000f6b0ULL, 0x000000ff00002240ULL, 0x000501010000f6b0ULL,
0x0000000b000022a0ULL, 0x003f01010000f608ULL, 0x0000000b000022c0ULL, 0x003f01050000f60cULL,
0x0000000b00002490ULL, 0x003f01050000f60cULL, 0x0000003300002ac0ULL, 0x003f01050000f6acULL,
0x0000003300002c90ULL, 0x003f01050000f6acULL, 0x0000000c00003f30ULL, 0x003f010100000000ULL,
0x0000003300003f90ULL, 0x003f01010000f688ULL, 0x0000000600003fb0ULL, 0x003f010500000004ULL,
0x0000000600004180ULL, 0x003f010500000004ULL, 0x0000000c00004980ULL, 0x003f01070000f6a8ULL,
0x0000000c00004a10ULL, 0x003f01010000f6a8ULL, 0x0000000b00004a70ULL, 0x003f01010000f628ULL,
0x0000000b00004a90ULL, 0x003f01050000f62cULL, 0x0000000b00004c60ULL, 0x003f01050000f62cULL,
0x0000003200005250ULL, 0x003f01050000f6b4ULL, 0x0000003200005420ULL, 0x003f01050000f6b4ULL,
0x0000000e000064b0ULL, 0x003f010100000000ULL, 0x0000000d00006510ULL, 0x003f01010000f690ULL,
0x0000000600006530ULL, 0x003f010500000004ULL, 0x0000000600006700ULL, 0x003f010500000004ULL,
0x0000007a00006ed0ULL, 0x003f01070000f6b0ULL, 0x0000001200006fd0ULL, 0x003f01010000f6b0ULL,
0x0000000b00007030ULL, 0x003f01010000f648ULL, 0x0000000b00007050ULL, 0x003f01050000f64cULL,
0x0000000b00007220ULL, 0x003f01050000f64cULL, 0x0000003600007810ULL, 0x003f01050000f6acULL,
0x00000036000079e0ULL, 0x003f01050000f6acULL, 0x0000001000008ac0ULL, 0x003f010100000000ULL,
0x0000000e00008b20ULL, 0x003f010100000000ULL, 0x0000000600008b40ULL, 0x003f010500000004ULL,
0x0000000600008d10ULL, 0x003f010500000004ULL, 0x000000ff00009520ULL, 0x0004010700000000ULL,
0x0000007a00009600ULL, 0x003f01010000f6a8ULL, 0x0000000600009660ULL, 0x003f01010000f668ULL,
0x0000000600009690ULL, 0x003f01050000f66cULL, 0x0000000600009860ULL, 0x003f01050000f66cULL,
0x0000007a00009e10ULL, 0x003f01050000f6b4ULL, 0x0000007a0000a030ULL, 0x003f01050000f6b4ULL,
0x000000060000b230ULL, 0x003f010100000000ULL, 0x0000000b0000b2b0ULL, 0x003f010100000000ULL,
0x000000ff0000c3f0ULL, 0x003f01010000f600ULL, 0x000000ff0000d000ULL, 0x003f01050000f604ULL,
0x000000ff0000d1d0ULL, 0x003f01050000f604ULL, 0x000000ff0000d400ULL, 0x003f01010000f600ULL,
0x000000ff0000d430ULL, 0x003f01050000f604ULL, 0x000000ff0000d5f0ULL, 0x003f01050000f604ULL,
0x000000760000f8f0ULL, 0x003f010100000000ULL, 0x000000760000f9c0ULL, 0x003f010500000004ULL,
0x000000760000fb90ULL, 0x003f010500000004ULL, 0x0000007900011f70ULL, 0x003f010100000000ULL,
0x0000007900011fd0ULL, 0x003f010100000008ULL, 0x0000007900012030ULL, 0x003f010100000010ULL,
0x00000079000120a0ULL, 0x003f010100000018ULL, 0x00201c0400053803ULL, 0x0000bd000000bcd0ULL,
0x0000c0700000bf10ULL, 0x0000c3000000c200ULL, 0x000120e00000d650ULL, 0x000c050400000401ULL,
0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x00000000000003b4ULL, 0x0000001b00000002ULL, 0x00000000000002d4ULL,
0x0000001b00000002ULL, 0x0000000000000204ULL, 0x0000001b00000002ULL, 0x0000000000000124ULL,
0x0000001b00000002ULL, 0x0000000000000044ULL, 0x0000001b00000002ULL, 0x000000000000038aULL,
0x0000001b00000002ULL, 0x00000000000002aaULL, 0x0000001b00000002ULL, 0x00000000000001ddULL,
0x0000001b00000002ULL, 0x00000000000000fdULL, 0x0000001b00000002ULL, 0x000000000000f700ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000590000007b06ULL, 0x000e620000209000ULL,
0x00005900ff727624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f45070ULL,
0x0000000000087919ULL, 0x000ea20000002600ULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0xfffffff801017810ULL, 0x000fe20007ffe0ffULL, 0x00005a0000057ab9ULL, 0x000fe20000000800ULL,
0x00000000000b7919ULL, 0x000ee20000002300ULL, 0x0000000504047299ULL, 0x000fe4000800063fULL,
0x0000460000087ab9ULL, 0x000fe20000000a00ULL, 0x0000000000097919ULL, 0x000f220000002100ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL,
0x0000000200037305ULL, 0x0002a4000021f000ULL, 0x000000ffff027224ULL, 0x002fe400078e00ffULL,
0x000000ffff057224ULL, 0x004fc800078e0a03ULL, 0x0000590005057a24ULL, 0x000fc800078e02ffULL,
0x0000000503037227ULL, 0x000fcc00078e0002ULL, 0x0000040003057a27ULL, 0x000fc800078e00ffULL,
0x000000ffff037224ULL, 0x000fc800078e0a05ULL, 0x0000040003007624ULL, 0x000fca00078e0272ULL,
0x0000590000007a0cULL, 0x000fda0003f06070ULL, 0x8000590000000a10ULL, 0x000fe40007ffe0ffULL,
0x0000000105050810ULL, 0x000fe40007ffe0ffULL, 0x0000590000007a0cULL, 0x000fda0003f26070ULL,
0x0000000105051810ULL, 0x000fe40007ffe0ffULL, 0x00005900ff05aa12ULL, 0x000fc800078e33ffULL,
0x0000000500007306ULL, 0x000e620000209000ULL, 0x000000ff0500720cULL, 0x000fce0003fa5070ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL,
0x0000000200037305ULL, 0x0002a4000021f000ULL, 0x000000ffff027224ULL, 0x002fe400078e00ffULL,
0x0000000305047224ULL, 0x004fc800078e02ffULL, 0x000000ffff077224ULL, 0x000fe400078e0a04ULL,
0x0000000000047919ULL, 0x000ee40000002200ULL, 0x0000000703037227ULL, 0x000fcc00078e0002ULL,
0x00000008037b7227ULL, 0x000fc800078e00ffULL, 0x000000ffff007224ULL, 0x000fc800078e0a7bULL,
0x0000000005007224ULL, 0x000fca00078e0208ULL, 0x000000050000720cULL, 0x000fe20003f66070ULL,
0x000001000b027a24ULL, 0x008fe400078e0204ULL, 0x0000000000047919ULL, 0x000e640000002700ULL,
0x00000000020d7a24ULL, 0x010fe400078e0209ULL, 0x00001fff0b0b7589ULL, 0x000fe600000e0000ULL,
0x000000ff0d00720cULL, 0x000fc60003f45270ULL, 0x0000000100003824ULL, 0x000fe200078e0a05ULL,
0x000000017b7b3810ULL, 0x000fe40007ffe0ffULL, 0x0000007f0d00780cULL, 0x040fe40003f04070ULL,
0x000000050000720cULL, 0x000fe40003f86070ULL, 0x0000000f0d00780cULL, 0x040fe40003f24070ULL,
0x000000030d00780cULL, 0x000fe20003f64070ULL, 0x3fffff80ff02a424ULL, 0x000fc400078e00ffULL,
0x7fffff80ff03a424ULL, 0x000fc800078e00ffULL, 0xff317217ff0a8424ULL, 0x000fe400078e00ffULL,
0x000000017b7b4810ULL, 0x000fe20007ffe0ffULL, 0x00f60002ff00a388ULL, 0x000fe20000000a00ULL,
0x00000005ff7bd212ULL, 0x000fe200078e33ffULL, 0x3fffffc0ff069424ULL, 0x000fe200078e00ffULL,
0x000000010d00780cULL, 0x000fe20003f84070ULL, 0x00f4000a0d008388ULL, 0x0005e20000004800ULL,
0x7fffffc0ff079424ULL, 0x000fe400078e00ffULL, 0x000000ffff007224ULL, 0x000fc600078e0a7bULL,
0x00f608060d009388ULL, 0x0007e20000008a00ULL, 0x00000000050c7224ULL, 0x000fe200078e0208ULL,
0x00000005ff007819ULL, 0x000fe20000011609ULL, 0x3fffff60ff08b424ULL, 0x000fe200078e00ffULL,
0x00005a007b0a7a19ULL, 0x004fe200000006ffULL, 0x000000100c717824ULL, 0x000fe200078e00ffULL,
0x0000000c01007387ULL, 0x0005e20000100800ULL, 0x7fffff60ff09b424ULL, 0x000fe400078e00ffULL,
0x3fffff80ff02b424ULL, 0x000fe200078e00ffULL, 0x00001fff00007589ULL, 0x000f2200000e0000ULL,
0x0000000471057c10ULL, 0x040fe2000fffe1ffULL, 0x7fffff80ff03b424ULL, 0x000fe200078e00ffULL,
0x0000000471007c0cULL, 0x000fe2000bf03070ULL, 0x3fffffc0ff06c424ULL, 0x008fe200078e00ffULL,
0x0000001005057817ULL, 0x000fe20003800000ULL, 0x7fffffc0ff07c424ULL, 0x000fe200078e00ffULL,
0x00f688080d00b388ULL, 0x000fe20000008a00ULL, 0x00005a00720c7a19ULL, 0x004fc400000006ffULL,
0x000000ff057d7207ULL, 0x000fe20000000000ULL, 0x00f6a8020d00b388ULL, 0x0009e20000008a00ULL,
0x0000580004057a24ULL, 0x002fe400078e02ffULL, 0x000000107d00780cULL, 0x000fe20003f05270ULL,
0x00f6c8060d00c388ULL, 0x000fe20000008a00ULL, 0x0000000c05057224ULL, 0x000fe400078e020aULL,
0x000000040b027824ULL, 0x010fc800078e0200ULL, 0x0000000202027824ULL, 0x000fe200078e00ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000001d000008947ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0xffffffff00047882ULL, 0x000fe20000000000ULL,
0x000000027d077217ULL, 0x000fe20007800000ULL, 0x00005a0000057ab9ULL, 0x000fc40000000800ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x00000004ff097819ULL, 0x002fca0000011603ULL,
0x0000000102087824ULL, 0x000fe400078e0209ULL, 0x0000000107027824ULL, 0x000fe400078e0a02ULL,
0x0000000171067824ULL, 0x000fc600078e0208ULL, 0x000000020900720cULL, 0x000fe20003f06070ULL,
0x0000000108027824ULL, 0x000fe200078e0203ULL, 0x00000004060a7c12ULL, 0x000fe2000f8e30ffULL,
0x0000001008097824ULL, 0x000fe200078e00ffULL, 0x00005a00ff067a19ULL, 0x000fc60000011606ULL,
0x0000000105057824ULL, 0x000fe200078e020aULL, 0xfffffff009027812ULL, 0x000fc600078ee202ULL,
0x0000000c06067224ULL, 0x000fe400078e0205ULL, 0x0000001003057824ULL, 0x000fe400078e00ffULL,
0x0000010006067825ULL, 0x000fc600078e00ffULL, 0x000000f0050d7812ULL, 0x000fe200078ec0ffULL,
0x0000001002097824ULL, 0x000fc600078e00ffULL, 0x0000000d060d7212ULL, 0x000fc800078efcffULL,
0x00005e000d067a10ULL, 0x000fc80007f3e0ffULL, 0x00005f0007077a10ULL, 0x000fca0000ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006097faeULL, 0x0003e2000c101c48ULL,
0x0000018000007947ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e620000000000ULL,
0xffffffff00047882ULL, 0x000fe40000000000ULL, 0x00005a0000057ab9ULL, 0x000fe40000000800ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x0000000203027211ULL, 0x002fca00078fe0ffULL,
0x0000000171067824ULL, 0x000fca00078e0202ULL, 0x0000000406087c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff067a19ULL, 0x000fc60000011606ULL, 0x0000000105057824ULL, 0x000fe400078e0208ULL,
0x0000000102087824ULL, 0x000fe400078e0203ULL, 0x0000000c06067224ULL, 0x000fe400078e0205ULL,
0x0000001003057824ULL, 0x000fe400078e00ffULL, 0x0000010006067825ULL, 0x000fc600078e00ffULL,
0x000000f005097812ULL, 0x000fc800078ec0ffULL, 0x0000000906067212ULL, 0x000fe200078efcffULL,
0x0000001002097824ULL, 0x000fc600078e00ffULL, 0x00005e0006067a10ULL, 0x000fe40007f1e0ffULL,
0xfffffff009087812ULL, 0x000fe400078ee208ULL, 0x00005f0007077a10ULL, 0x000fc600007fe4ffULL,
0x0000001008097824ULL, 0x000fca00078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006097faeULL, 0x0003e4000b901c48ULL, 0x0000000000077919ULL, 0x002e620000000000ULL,
0x0000000000027806ULL, 0x000fe200038e0000ULL, 0x00000004ff097424ULL, 0x000fe400078e00ffULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000200067300ULL, 0x000e7000000e0000ULL,
0x0000000200087309ULL, 0x000ea20000000000ULL, 0x000000070600720cULL, 0x002fe20003f02070ULL,
0x0000660004067625ULL, 0x000fc800078e0009ULL, 0x000000ffff087224ULL, 0x004fd000078e0a08ULL,
0x00f60408ffff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000008066b7981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0b00720cULL, 0x000fe40003f05270ULL, 0x0000007f6b6d7810ULL, 0x044fe40007ffe0ffULL,
0x000000ff6b0c7810ULL, 0x000fc40007ffe0ffULL, 0x00000007ff6d7819ULL, 0x000fe4000001166dULL,
0x00000008ff6c7819ULL, 0x000fca000001160cULL, 0x0000b89000008947ULL, 0x000fea0003800000ULL,
0x00000003ff6a7819ULL, 0x000fe20000011600ULL, 0x00000003ff0b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff677424ULL, 0x000fe200078e00ffULL, 0x01ffffff6a6a7812ULL, 0x000fc800078ec0ffULL,
0x0000006d6a00720cULL, 0x000fda0003f06070ULL, 0x0000000204028824ULL, 0x000fe400078e00ffULL,
0x00006800ff078624ULL, 0x000fc800078e00ffULL, 0x0000680002078624ULL, 0x000fe200078e0207ULL,
0x0000f68800027811ULL, 0x000fc600078e18ffULL, 0x000000016a078824ULL, 0x000fe200078e0207ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000040b02ff738cULL, 0x0005e20000000000ULL,
0x0000640007068625ULL, 0x000fe200078e0009ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000806678981ULL, 0x000ee2000c1e1900ULL, 0x000001ff0c00780cULL, 0x000fe20003f04070ULL,
0x000000807b737824ULL, 0x000fe200078e00ffULL, 0x00000001ff087819ULL, 0x002fe20000011600ULL,
0x00000080ff0b7424ULL, 0x004fe200078e00ffULL, 0x0000000002ff7f8cULL, 0x0003e2000c80043fULL,
0x00000001007c7812ULL, 0x000fe400078ec0ffULL, 0x00000020080d7824ULL, 0x000fc400078e00ffULL,
0x0000590067097a24ULL, 0x008fc800078e02ffULL, 0x00000080090a7824ULL, 0x000fe200078e00ffULL,
0x0000006073097812ULL, 0x000fc600078ef80dULL, 0x000062000a067625ULL, 0x000fe200078e000bULL,
0x000003e000000947ULL, 0x000fea0003800000ULL, 0x0000000d6b027217ULL, 0x002fe20007800000ULL,
0x000000107c0b7824ULL, 0x000fe200078e00ffULL, 0x00000003ff0a7819ULL, 0x000fc60000011603ULL,
0x0000000102027824ULL, 0x000fe200078e0a0dULL, 0x000000040a0e7810ULL, 0x040fe20007ffe0ffULL,
0x000000010b0c7824ULL, 0x000fe200078e020aULL, 0x0000000c0a0f7810ULL, 0x000fe40007ffe0ffULL,
0x0000000b02027217ULL, 0x000fe20007800000ULL, 0x000000010c0d7824ULL, 0x040fe400078e0203ULL,
0x000000080c127824ULL, 0x000fe400078e00ffULL, 0x0000000102027824ULL, 0x000fc400078e0a0bULL,
0x000000010b147824ULL, 0x000fe200078e020fULL, 0xfffffff812127812ULL, 0x000fe400078ee20dULL,
0x000000080a0d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000814137824ULL, 0x000fe200078e00ffULL,
0x000000020a00720cULL, 0x080fe20003f66070ULL, 0x00000001090a7824ULL, 0x000fe200078e020cULL,
0x000000020e00720cULL, 0x080fe20003f46070ULL, 0x000000010b0e7824ULL, 0x000fe200078e020eULL,
0x000000020d00720cULL, 0x080fe20003f26070ULL, 0x000000010b107824ULL, 0x000fe200078e020dULL,
0x000000020f00720cULL, 0x000fe20003f06070ULL, 0x000000800a0a7825ULL, 0x000fc800078e00ffULL,
0x0000000109027824ULL, 0x040fe200078e020eULL, 0x000000700a117812ULL, 0x000fe200078ef805ULL,
0x000000010e0c7824ULL, 0x140fe400078e0203ULL, 0x000000080e0f7824ULL, 0x000fe400078e00ffULL,
0x00000001090d7824ULL, 0x040fe400078e0210ULL, 0x00000001090e7824ULL, 0x000fe400078e0214ULL,
0x0000000110097824ULL, 0x000fc400078e0203ULL, 0x0000000810167824ULL, 0x000fe200078e00ffULL,
0x0000001106107210ULL, 0x000fe20007f9e0ffULL, 0x00000001140a7824ULL, 0x000fe200078e0203ULL,
0xfffffff80f147812ULL, 0x000fe200078ee20cULL, 0x000000800d0c7825ULL, 0x000fe200078e00ffULL,
0xfffffff816167812ULL, 0x000fe400078ee209ULL, 0xfffffff813187812ULL, 0x000fe200078ee20aULL,
0x0000000107117824ULL, 0x000fe200020e060bULL, 0x000000700c197812ULL, 0x000fe200078ef805ULL,
0x00000080020a7825ULL, 0x000fe200078e00ffULL, 0x0000b00008097811ULL, 0x000fc400078e68ffULL,
0x00000019060c7210ULL, 0x000fe20007fbe0ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x000000700a1b7812ULL, 0x000fc600078ef805ULL, 0x0000001012137824ULL, 0x000fe200078e0209ULL,
0x000000700e177812ULL, 0x000fe200078ef805ULL, 0x0000001014157824ULL, 0x100fe200078e0209ULL,
0x0000001b060a7210ULL, 0x000fe20007f9e0ffULL, 0x0000001016057824ULL, 0x000fe200078e0209ULL,
0x0000001706067210ULL, 0x000fe20007fde0ffULL, 0x00000001070d7824ULL, 0x040fe200028e060dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010137faeULL, 0x0003e2000d901c48ULL,
0x00000001070b7824ULL, 0x000fe400020e060bULL, 0x0000001018097824ULL, 0x000fc400078e0209ULL,
0x0000000107077824ULL, 0x000fe200030e060fULL, 0x000000000a157faeULL, 0x0003e8000d101c48ULL,
0x000000000c057faeULL, 0x0003e8000c901c48ULL, 0x0000000006097faeULL, 0x0003e2000c101c48ULL,
0x0000031000007947ULL, 0x000fea0003800000ULL, 0x000000107c027824ULL, 0x002fe200078e00ffULL,
0x0000b00008167811ULL, 0x000fc800078e68ffULL, 0x0000000203027211ULL, 0x000fc800078fe8ffULL,
0x00000004020c7810ULL, 0x040fe20007ffe0ffULL, 0x00000001020b7824ULL, 0x040fe200078e0203ULL,
0x0000000c02107810ULL, 0x040fe20007ffe0ffULL, 0x0000000802127824ULL, 0x040fe200078e00ffULL,
0x00000008020e7810ULL, 0x000fe20007ffe0ffULL, 0x00000001090a7824ULL, 0x040fe400078e0202ULL,
0x0000000109027824ULL, 0x000fe200078e020cULL, 0xfffffff812127812ULL, 0x000fe200078ee20bULL,
0x000000800a0a7825ULL, 0x000fc800078e00ffULL, 0x000000010c0d7824ULL, 0x000fe200078e0203ULL,
0x000000700a117812ULL, 0x000fe200078ef805ULL, 0x000000080c147824ULL, 0x000fe400078e00ffULL,
0x00000001090f7824ULL, 0x040fe400078e0210ULL, 0x00000001100a7824ULL, 0x000fe200078e0203ULL,
0xfffffff814137812ULL, 0x000fe200078ee20dULL, 0x0000000810157824ULL, 0x000fe200078e00ffULL,
0x0000001106107210ULL, 0x000fe20007f1e0ffULL, 0x00000001090c7824ULL, 0x000fc400078e020eULL,
0x000000010e097824ULL, 0x040fe200078e0203ULL, 0xfffffff815157812ULL, 0x000fe200078ee20aULL,
0x000000080e0e7824ULL, 0x000fe400078e00ffULL, 0x0000000107117824ULL, 0x000fe400000e060bULL,
0x00000080020a7825ULL, 0x000fe200078e00ffULL, 0xfffffff80e147812ULL, 0x000fc600078ee209ULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x000000700a1b7812ULL, 0x000fc600078ef805ULL,
0x000000800f0e7825ULL, 0x000fe200078e00ffULL, 0x000000700c197812ULL, 0x100fe400078ef805ULL,
0x0000001b060a7210ULL, 0x000fe20007f1e0ffULL, 0x0000001012097824ULL, 0x100fe200078e0216ULL,
0x000000700e177812ULL, 0x000fe200078ef805ULL, 0x0000001013137824ULL, 0x100fe200078e0216ULL,
0x00000019060c7210ULL, 0x040fe20007f3e0ffULL, 0x00000001070b7824ULL, 0x040fe200000e060bULL,
0x0000001706067210ULL, 0x000fe20007f5e0ffULL, 0x0000001014057824ULL, 0x000fe200078e0216ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010097faeULL, 0x0003e2000b901c48ULL,
0x00000001070d7824ULL, 0x000fc400008e060dULL, 0x0000001015157824ULL, 0x000fe200078e0216ULL,
0x000000000a137faeULL, 0x0003e2000b901c48ULL, 0x0000000107077824ULL, 0x000fc600010e060fULL,
0x000000000c057faeULL, 0x0003e8000b901c48ULL, 0x0000000006157faeULL, 0x0003e4000b901c48ULL,
0x00000010087a7824ULL, 0x000fe200078e00ffULL, 0x000000ff6c00720cULL, 0x000fe20003f05270ULL,
0x0000000808067824ULL, 0x002fe200078e00ffULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x000000007a0473c2ULL, 0x000e6200000e0000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x000000ffff257224ULL, 0x000fe200078e00ffULL,
0x0000f6a804047890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a8007a0c7f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6c80006067f8cULL, 0x000ee2000c80043fULL, 0x000000ffff247224ULL, 0x000fe200078e00ffULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00009d2000008947ULL, 0x000fea0003800000ULL, 0x0000000204747824ULL, 0x000fe200078e00ffULL,
0x00000002ff797819ULL, 0x000fe20000011600ULL, 0x00006800ff057624ULL, 0x000fc400078e00ffULL,
0x000000ffff097224ULL, 0x008fe400078e0007ULL, 0x0000680074747624ULL, 0x000fe400078e0205ULL,
0xff317217ff107424ULL, 0x000fe400078e00ffULL, 0x000000ffff077224ULL, 0x000fe400078e00ffULL,
0x000000ffff177224ULL, 0x000fc400078e00ffULL, 0x00000000000e7805ULL, 0x01afca0000015200ULL,
0x0000000400067824ULL, 0x000fca00078e00ffULL, 0xfffffff8060b7812ULL, 0x000fca00078ec0ffULL,
0x00f6cc000b067984ULL, 0x000ee40000000800ULL, 0x8000000006ff7812ULL, 0x008fe40007804809ULL,
0x0000f6c80b067810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000ff00000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff307224ULL, 0x000fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000103000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x000000120e117210ULL, 0x000fca0007f1e1ffULL,
0x0000000113127824ULL, 0x000fe200000e0e0fULL, 0x003d09001100780cULL, 0x000fc80003f06070ULL,
0x000000ff1200720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401100780cULL, 0x000fc80003f06070ULL, 0x000000ff1200720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0c7819ULL, 0x004fc80000011412ULL,
0x000000110c0c7211ULL, 0x000fca00078110ffULL, 0x000000ffff117224ULL, 0x000fca00000e0612ULL,
0x000000020c0c7819ULL, 0x000fc80000001211ULL, 0x0000000c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000130307810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00f6cc000b0c7984ULL, 0x004ea40000000800ULL,
0x800000000cff7812ULL, 0x004fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001000097824ULL, 0x000fe200078e00ffULL,
0x00000001070b7810ULL, 0x000fe20007ffe0ffULL, 0x0000590067677a24ULL, 0x000fe400078e02ffULL,
0x00000080ff0f7424ULL, 0x000fe200078e00ffULL, 0xffffffe0090c7812ULL, 0x004fe200078ec0ffULL,
0x00000080670e7824ULL, 0x000fe200078e00ffULL, 0x0000006c0b00720cULL, 0x000fc60003f26070ULL,
0x00000100070c7824ULL, 0x000fe400078e020cULL, 0x000062000e0e7625ULL, 0x000fc600078e000fULL,
0x000000400c127810ULL, 0x000fc80007ffe0ffULL, 0x00000060120c7812ULL, 0x000fca00078ec0ffULL,
0x0000000173397824ULL, 0x000fe200078e020cULL, 0x0000040000009947ULL, 0x000fea0003800000ULL,
0x00000010090c7812ULL, 0x000fe200078ec0ffULL, 0x0000001003137824ULL, 0x000fe200078e00ffULL,
0x000000126b097217ULL, 0x000fe40007800000ULL, 0x00000003ff117819ULL, 0x000fe40000011603ULL,
0x0000007013417812ULL, 0x000fe200078ec0ffULL, 0x0000000109097824ULL, 0x000fe200078e0a12ULL,
0x0000000411307810ULL, 0x040fe20007ffe0ffULL, 0x0000000111127824ULL, 0x040fe200078e020cULL,
0x0000000c11317810ULL, 0x000fc40007ffe0ffULL, 0x0000000c09097217ULL, 0x000fe20007800000ULL,
0x00000001120b7824ULL, 0x040fe400078e0203ULL, 0x0000000812327824ULL, 0x000fe400078e00ffULL,
0x0000000109097824ULL, 0x000fe400078e0a0cULL, 0x0000000139127824ULL, 0x000fe200078e0212ULL,
0xfffffff8320b7812ULL, 0x000fe400078ee20bULL, 0x000000093000720cULL, 0x0c0fe20003f66070ULL,
0x0000000130307824ULL, 0x000fe200078e020cULL, 0x0000000811327810ULL, 0x040fe20007ffe0ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x000000091100720cULL, 0x000fc40003f86070ULL,
0x000000093200720cULL, 0x080fe20003f46070ULL, 0x0000000130117824ULL, 0x040fe200078e0203ULL,
0x000000093100720cULL, 0x000fe20003f06070ULL, 0x0000000830387824ULL, 0x000fe200078e00ffULL,
0x00000041123d7212ULL, 0x000fe200078efcffULL, 0x0000000139307824ULL, 0x000fe400078e0230ULL,
0x0000000132327824ULL, 0x100fe200078e020cULL, 0xfffffff838117812ULL, 0x000fe200078ee211ULL,
0x00000001310c7824ULL, 0x000fe200078e020cULL, 0x0000003d0e127210ULL, 0x000fe20007fbe0ffULL,
0x0000008030307825ULL, 0x000fc800078e00ffULL, 0x0000000139337824ULL, 0x040fe400078e0232ULL,
0x0000000132097824ULL, 0x140fe400078e0203ULL, 0x00000008323a7824ULL, 0x000fe400078e00ffULL,
0x000000010c327824ULL, 0x040fe400078e0203ULL, 0x000000080c3b7824ULL, 0x000fe200078e00ffULL,
0xfffffff83a097812ULL, 0x000fe200078ee209ULL, 0x0000000139387824ULL, 0x000fe200078e020cULL,
0x0000004130397212ULL, 0x000fe200078efcffULL, 0x000000010f137824ULL, 0x000fe200028e0613ULL,
0xfffffff83b3b7812ULL, 0x000fe200078ee232ULL, 0x0000008033327825ULL, 0x000fe200078e00ffULL,
0x000000390e307210ULL, 0x000fc40007fde0ffULL, 0x0000c000080c7811ULL, 0x000fe200078e68ffULL,
0x0000008038387825ULL, 0x000fe200078e00ffULL, 0x00000041323f7212ULL, 0x000fc600078efcffULL,
0x000000010f317824ULL, 0x000fe200030e0631ULL, 0x00000041383d7212ULL, 0x000fe200078efcffULL,
0x000000100b0b7824ULL, 0x100fe200078e020cULL, 0x0000003f0e327210ULL, 0x040fe20007fbe0ffULL,
0x0000001011117824ULL, 0x100fe200078e020cULL, 0x0000003d0e0e7210ULL, 0x000fe20007fde0ffULL,
0x0000001009097824ULL, 0x100fe200078e020cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000120b7faeULL, 0x0005e2000e101c48ULL, 0x000000010f337824ULL, 0x000fe400028e0633ULL,
0x000000103b3b7824ULL, 0x000fe200078e020cULL, 0x0000000030117faeULL, 0x0005e2000d901c48ULL,
0x000000010f0f7824ULL, 0x000fc600030e0639ULL, 0x0000000032097faeULL, 0x0005e8000d101c48ULL,
0x000000000e3b7faeULL, 0x0005e2000c101c48ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x00000010090c7812ULL, 0x000fe200078ec0ffULL, 0x00000010030b7824ULL, 0x040fe200078e00ffULL,
0x0000c000083c7811ULL, 0x000fe400078e68ffULL, 0x0000000c030c7211ULL, 0x000fe400078fe8ffULL,
0x000000700b417812ULL, 0x000fc400078ec0ffULL, 0x000000080c327810ULL, 0x040fe20007ffe0ffULL,
0x000000010c097824ULL, 0x040fe200078e0203ULL, 0x0000000c0c387810ULL, 0x040fe20007ffe0ffULL,
0x000000080c307824ULL, 0x000fe400078e00ffULL, 0x0000000139127824ULL, 0x040fe400078e020cULL,
0x0000000139337824ULL, 0x000fe200078e0232ULL, 0xfffffff830097812ULL, 0x000fe200078ee209ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x000000040c307810ULL, 0x000fc60007ffe0ffULL,
0x00000001320c7824ULL, 0x100fe200078e0203ULL, 0x00000041123b7212ULL, 0x000fe200078efcffULL,
0x0000000139317824ULL, 0x040fe400078e0230ULL, 0x00000001300b7824ULL, 0x000fe200078e0203ULL,
0x0000003b0e127210ULL, 0x000fe20007f1e0ffULL, 0x0000000830307824ULL, 0x000fe400078e00ffULL,
0x0000000139397824ULL, 0x000fe400078e0238ULL, 0x00000008323d7824ULL, 0x000fe200078e00ffULL,
0xfffffff8300b7812ULL, 0x000fe200078ee20bULL, 0x0000008031307825ULL, 0x000fc600078e00ffULL,
0xfffffff83d0c7812ULL, 0x000fe200078ee20cULL, 0x0000000138117824ULL, 0x000fe200078e0203ULL,
0x00000041303f7212ULL, 0x000fe200078efcffULL, 0x00000008383a7824ULL, 0x000fe400078e00ffULL,
0x0000008033327825ULL, 0x000fc600078e00ffULL, 0xfffffff83a3a7812ULL, 0x000fe200078ee211ULL,
0x0000008039387825ULL, 0x000fe200078e00ffULL, 0x00000041323d7212ULL, 0x000fc600078efcffULL,
0x000000010f137824ULL, 0x000fe200000e0613ULL, 0x00000041383b7212ULL, 0x000fe200078efcffULL,
0x0000001009097824ULL, 0x100fe200078e023cULL, 0x0000003f0e307210ULL, 0x040fe20007f1e0ffULL,
0x000000100b0b7824ULL, 0x100fe200078e023cULL, 0x0000003d0e327210ULL, 0x000fe20007f5e0ffULL,
0x000000100c117824ULL, 0x000fe200078e023cULL, 0x0000003b0e0e7210ULL, 0x000fe20007f7e0ffULL,
0x000000010f317824ULL, 0x040fe200000e0631ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012097faeULL, 0x0005e2000b901c48ULL, 0x000000010f337824ULL, 0x000fc400010e0633ULL,
0x000000103a3b7824ULL, 0x000fe200078e023cULL, 0x00000000300b7faeULL, 0x0005e2000b901c48ULL,
0x000000010f0f7824ULL, 0x000fc600018e0639ULL, 0x0000000032117faeULL, 0x0005e8000b901c48ULL,
0x000000000e3b7faeULL, 0x0005e4000b901c48ULL, 0x00000008000c7824ULL, 0x000fe200078e00ffULL,
0x000000016a0e7810ULL, 0x004fe20007ffe0ffULL, 0xffffffffff327424ULL, 0x000fe400078e00ffULL,
0x000000000c0573c2ULL, 0x000ea200000e0000ULL, 0x0000006d0e00720cULL, 0x000fe40003f06070ULL,
0x000000080c097812ULL, 0x000fc400078ec0ffULL, 0xffffffe00c0b7812ULL, 0x040fe400078ec0ffULL,
0x000000100c127812ULL, 0x000fce00078ec0ffULL, 0x00000001740e8824ULL, 0x000fe400078e020eULL,
0x00000004ff0f8424ULL, 0x000fe200078e00ffULL, 0xfffffff005057892ULL, 0x004fc6000f8ec03fULL,
0x000064000e0e8625ULL, 0x000fe200078e000fULL, 0x0000f6b005067890ULL, 0x000fe2000fffe03fULL,
0x0000000b090b7210ULL, 0x000fc60007ffe012ULL, 0x000000080e328981ULL, 0x000528000c1e1900ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a06ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6b000ff307f8cULL, 0x000ee2000c800405ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f608000b387f8cULL, 0x0002a4000c80043fULL, 0x00000000000e7805ULL, 0x004fc40000015200ULL,
0x00f60c000b097984ULL, 0x000ea40000000800ULL, 0x8000000009ff7812ULL, 0x004fc40007804839ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff117224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101100780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x000000120e127210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e0fULL, 0x003d09001200780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401200780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff097819ULL, 0x000fc80000011413ULL,
0x0000001209097211ULL, 0x000fca00078110ffULL, 0x000000ffff127224ULL, 0x000fca00000e0613ULL,
0x0000000209097819ULL, 0x000fc80000001212ULL, 0x000000090000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000111117810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f60c000b097984ULL, 0x000ea40000000800ULL,
0x8000000009ff7812ULL, 0x004fe40007804839ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001003607824ULL, 0x000fe200078e00ffULL, 0x00000001ff687819ULL, 0x000fe20000011603ULL,
0x0000002000097824ULL, 0x000fe400078e00ffULL, 0xffffffffff707424ULL, 0x000fe200078e00ffULL,
0x0000007060607812ULL, 0x000fc400078ec0ffULL, 0xffffff8009097812ULL, 0x000fe400078ec0ffULL,
0x0000000c68687812ULL, 0x000fc800078ec0ffULL, 0x0000000968097210ULL, 0x000fca0007ffe060ULL,
0x00f0000009117984ULL, 0x000ea80000000800ULL, 0x00f2000009337984ULL, 0x0002e20000000800ULL,
0x000000101100720bULL, 0x004fe20003f1d000ULL, 0x0000fb527f007947ULL, 0x000fd8000b800000ULL,
0x00000000000e7806ULL, 0x002fc800000e0100ULL, 0x0000ffff0e387812ULL, 0x000fe2000780c0ffULL,
0x000004c000007945ULL, 0x000fe20003800000ULL, 0x00000001ff127424ULL, 0x000fe400078e00ffULL,
0x000000ffff097224ULL, 0x000fc400078e0010ULL, 0x0000001fff757424ULL, 0x000fe400078e00ffULL,
0xffffffffff717424ULL, 0x000fca00078e00ffULL, 0x0000046000008947ULL, 0x000fea0003800000ULL,
0x000000007900720cULL, 0x000fe40003f05270ULL, 0x000000101100720bULL, 0x000fe20003f54000ULL,
0x0000fae27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000097806ULL, 0x000fc400010e0100ULL,
0x00000080000f8824ULL, 0x000fe200078e0260ULL, 0x00000010110e8209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe20003800000ULL, 0x0000991009127816ULL, 0x000fe200000000ffULL,
0x00000001680f8824ULL, 0x000fca00078e020fULL, 0x00f4000e0f008388ULL, 0x0003e20000000800ULL,
0x000000ff1200720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x00000010110f7209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff09ff7812ULL, 0x000fc6000780c0ffULL, 0x000000100f0e7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b0e0e7820ULL, 0x000fc80000410000ULL, 0x0000000e00397308ULL, 0x000e640000000800ULL,
0x000000390a0a7220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff0e7819ULL, 0x000fe20000011603ULL, 0x0000fa027f007947ULL, 0x000fea000b800000ULL,
0x00001f0e39127589ULL, 0x0002a400000e0000ULL, 0x0000001234347220ULL, 0x084fe20000410000ULL,
0x0000001235357220ULL, 0x080fe20000410000ULL, 0x0000001218187220ULL, 0x080fe20000410000ULL,
0x0000001219197220ULL, 0x080fe20000410000ULL, 0x000000121c1c7220ULL, 0x080fe20000410000ULL,
0x000000121d1d7220ULL, 0x080fe20000410000ULL, 0x0000001220207220ULL, 0x080fe20000410000ULL,
0x0000001221217220ULL, 0x080fe20000410000ULL, 0x0000001224247220ULL, 0x080fe20000410000ULL,
0x0000001225257220ULL, 0x080fe20000410000ULL, 0x0000001228287220ULL, 0x080fe20000410000ULL,
0x0000001229297220ULL, 0x080fe20000410000ULL, 0x000000122c2c7220ULL, 0x080fe20000410000ULL,
0x000000122d2d7220ULL, 0x080fe20000410000ULL, 0x0000001214147220ULL, 0x080fe20000410000ULL,
0x0000001215157220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0009ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008030e7811ULL, 0x002fe200078ff0ffULL, 0x0000f8e27f007947ULL, 0x000fea000b800000ULL,
0x00001f0e39127589ULL, 0x0002a400000e0000ULL, 0x0000001236367220ULL, 0x084fe20000410000ULL,
0x0000001237377220ULL, 0x080fe20000410000ULL, 0x000000121a1a7220ULL, 0x080fe20000410000ULL,
0x000000121b1b7220ULL, 0x080fe20000410000ULL, 0x000000121e1e7220ULL, 0x080fe20000410000ULL,
0x000000121f1f7220ULL, 0x080fe20000410000ULL, 0x0000001222227220ULL, 0x080fe20000410000ULL,
0x0000001223237220ULL, 0x080fe20000410000ULL, 0x0000001226267220ULL, 0x080fe20000410000ULL,
0x0000001227277220ULL, 0x080fe20000410000ULL, 0x000000122a2a7220ULL, 0x080fe20000410000ULL,
0x000000122b2b7220ULL, 0x080fe20000410000ULL, 0x000000122e2e7220ULL, 0x080fe20000410000ULL,
0x000000122f2f7220ULL, 0x080fe20000410000ULL, 0x0000001216167220ULL, 0x080fe20000410000ULL,
0x0000001217177220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff38ff7812ULL, 0x000fe20007806009ULL, 0x00000001ff127424ULL, 0x000fe200078e00ffULL,
0x0000001011097209ULL, 0x000fd60007810000ULL, 0x8000000911110221ULL, 0x000fe20000010000ULL,
0x00007610ff120816ULL, 0x000fc60000000012ULL, 0x3fb8aa3b11110820ULL, 0x000fc80000410000ULL,
0x0000001100050308ULL, 0x000e640000000800ULL, 0x0000000533330220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000a330a7221ULL, 0x008fc20000010000ULL,
0x00000000000e7805ULL, 0x000fcc0000015200ULL, 0xfffffff00c337812ULL, 0x000fca00078ec0ffULL,
0x00f6ac00330c7984ULL, 0x000e640000000800ULL, 0x800000000cff7812ULL, 0x002fe4000780480dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff387224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000107805ULL, 0x000fcc0000015200ULL, 0x000000100e137210ULL, 0x000fca0007f1e1ffULL,
0x0000000111117824ULL, 0x000fe200000e0e0fULL, 0x003d09001300780cULL, 0x000fc80003f06070ULL,
0x000000ff1100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401300780cULL, 0x000fc80003f06070ULL, 0x000000ff1100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0c7819ULL, 0x000fc80000011411ULL,
0x000000130c0c7211ULL, 0x000fca00078110ffULL, 0x000000ffff117224ULL, 0x000fca00000e0611ULL,
0x000000020c0c7819ULL, 0x000fc80000001211ULL, 0x0000000c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000138387810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6ac00330c7984ULL, 0x000e640000000800ULL,
0x800000000cff7812ULL, 0x002fe4000780480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009910120c7816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0c00720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000005ff02723eULL, 0x000fe400000000ffULL, 0x00000002ff0c7819ULL, 0x000fe40000011603ULL,
0x00005410020d7816ULL, 0x000fe20000000002ULL, 0x0000f4a27f007947ULL, 0x000fea000b800000ULL,
0x00001f0c0d047589ULL, 0x0002a400000e0000ULL, 0x000000080c0e7810ULL, 0x000fe20007ffe0ffULL,
0x0000f4d27f007947ULL, 0x000fea000b800000ULL, 0x00001f0e0d027589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000100c0e7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff0f7224ULL, 0x000fe200078e000dULL, 0x00002df000137802ULL, 0x000fc40000000f00ULL,
0x0000fea000007944ULL, 0x016fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000180c0e7810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff0f7224ULL, 0x000fe200078e000dULL,
0x00002e4000137802ULL, 0x000fc40000000f00ULL, 0x0000fe5000007944ULL, 0x016fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000200337824ULL, 0x040fe200078e00ffULL,
0x00000007030d7812ULL, 0x00afe200078ec0ffULL, 0x0000020000487824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe40003800000ULL, 0x00000004330c7812ULL, 0x000fc400078ec0ffULL,
0x000000080d407812ULL, 0x000fe400078ef803ULL, 0x0000000c03617211ULL, 0x000fe400078fe0ffULL,
0xfffff80048487812ULL, 0x000fe200078ec0ffULL, 0x00000008400c7824ULL, 0x040fe400078e00ffULL,
0x0000000140617824ULL, 0x000fca00078e0261ULL, 0xfffffff80c477812ULL, 0x000fe400078ee261ULL,
0x00000008030c7812ULL, 0x000fc600078ec0ffULL, 0x0000001047477824ULL, 0x000fc400078e0248ULL,
0x00000004000e7824ULL, 0x000fe200078e00ffULL, 0x00000004ff417819ULL, 0x000fe20000011603ULL,
0x00000008404a7824ULL, 0x000fe200078e00ffULL, 0x0000000d0c3c7212ULL, 0x000fe400078efcffULL,
0x000000040e0e7812ULL, 0x000fe400078ec0ffULL, 0x0000b00008667811ULL, 0x000fe200078e68ffULL,
0x000000083c467824ULL, 0x000fe200078e00ffULL, 0x000000100c4c7812ULL, 0x000fe200078efe0dULL,
0x00000001410f7824ULL, 0x000fe200078e020eULL, 0xfffffff833337812ULL, 0x000fe200078ec0ffULL,
0x0000000408417824ULL, 0x000fc400078e0241ULL, 0x000000013c3d7824ULL, 0x000fe400078e020fULL,
0x000000084c447824ULL, 0x000fe200078e00ffULL, 0x0000000241437810ULL, 0x000fe20007ffe040ULL,
0x000000010f4b7824ULL, 0x000fe200078e024cULL, 0xfffffff846467812ULL, 0x000fe200078ee23dULL,
0x00900000470c783bULL, 0x000e620000000200ULL, 0x000000083c3c7824ULL, 0x000fe200078e00ffULL,
0x000000023d457810ULL, 0x000fe20007ffe0ffULL, 0x000000084c4e7824ULL, 0x000fe200078e00ffULL,
0xfffffff844447812ULL, 0x000fe200078ee24bULL, 0x0000001046107824ULL, 0x000fe200078e0266ULL,
0xfffffff83c457812ULL, 0x000fc400078ee245ULL, 0xfffffff84a497812ULL, 0x000fe200078ee243ULL,
0x0000001044387824ULL, 0x100fe200078e0266ULL, 0x000000024b4b7810ULL, 0x000fe20007ffe0ffULL,
0x000000001010783bULL, 0x004ea20000004200ULL, 0x00000010453c7824ULL, 0x000fe400078e0266ULL,
0x0000001049487824ULL, 0x000fe200078e0248ULL, 0x000000003838783bULL, 0x000ee20000004200ULL,
0xfffffff84e497812ULL, 0x000fc600078ee24bULL, 0x000000003c3c783bULL, 0x000ee20000004200ULL,
0x000000040c0c8232ULL, 0x082fe40000000000ULL, 0x000000040e0e8232ULL, 0x000fe40000000000ULL,
0x000000020d0d8232ULL, 0x080fe40000000000ULL, 0x000000020f0f8232ULL, 0x000fe20000000000ULL,
0x00000018ff407819ULL, 0x004fe40000011612ULL, 0x0000ffff12417812ULL, 0x000fc400078ec0ffULL,
0x00000040ff43723eULL, 0x000fe400020006ffULL, 0x0000ffff13407812ULL, 0x000fe400078ec0ffULL,
0x00000018ff427819ULL, 0x000fe40000011613ULL, 0x00000008ff417819ULL, 0x000fe40000011641ULL,
0x00000008ff407819ULL, 0x000fe40000011640ULL, 0x00000042ff4a723eULL, 0x000fc400020006ffULL,
0x00000041ff42723eULL, 0x000fe400020006ffULL, 0x00000040ff41723eULL, 0x000fe400020006ffULL,
0x0000541042427816ULL, 0x000fe40000000043ULL, 0x0000541041437816ULL, 0x000fe4000000004aULL,
0x00000010ff517819ULL, 0x000fe40000011610ULL, 0x00000018ff4c7819ULL, 0x008fc40000011638ULL,
0x00000010ff507819ULL, 0x000fe20000011611ULL, 0x000000420c20723cULL, 0x000be20000001820ULL,
0x000000ff104d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff4a7819ULL, 0x000fe40000011612ULL,
0x000000ff12657812ULL, 0x000fe400078ec0ffULL, 0x000000ff51517812ULL, 0x000fe400078ec0ffULL,
0x0000004cff40723eULL, 0x000fc400020006ffULL, 0x000000ff11537812ULL, 0x040fe400078ec0ffULL,
0x000000ff50127812ULL, 0x000fe400078ec0ffULL, 0x00000018ff4c7819ULL, 0x000fe40000011610ULL,
0x0000ffff10107812ULL, 0x000fe400078ec0ffULL, 0x00000018ff527819ULL, 0x000fe40000011611ULL,
0x0000ffff11437812ULL, 0x020fc400078ec0ffULL, 0x0000004dff11723eULL, 0x000fe400020006ffULL,
0x00000051ff51723eULL, 0x000fe400020006ffULL, 0x00000053ff53723eULL, 0x000fe400020006ffULL,
0x00000012ff12723eULL, 0x000fe400020006ffULL, 0x00000008ff507819ULL, 0x000fe40000011610ULL,
0x0000541011107816ULL, 0x000fc40000000051ULL, 0x0000541053117816ULL, 0x000fe40000000012ULL,
0x0000004cff4c723eULL, 0x000fe400020006ffULL, 0x00000050ff50723eULL, 0x000fe400020006ffULL,
0x00000010ff4b7819ULL, 0x000fe40000011613ULL, 0x000000ff13647812ULL, 0x000fe400078ec0ffULL,
0x00000008ff437819ULL, 0x000fe20000011643ULL, 0x000000100c10723cULL, 0x000b620000001834ULL,
0x00000010ff5f7819ULL, 0x000fc4000001163dULL, 0x000000ff3d627812ULL, 0x040fe400078ec0ffULL,
0x00000018ff5e7819ULL, 0x000fe4000001163dULL, 0x0000ffff3d587812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4f7819ULL, 0x100fe4000001163fULL, 0x000000ff3f597812ULL, 0x000fe400078ec0ffULL,
0x00000018ff567819ULL, 0x000fc4000001163fULL, 0x0000ffff3f427812ULL, 0x000fe400078ec0ffULL,
0x0000541050347816ULL, 0x020fe4000000004cULL, 0x00000018ff3d7819ULL, 0x100fe40000011639ULL,
0x000000ff393f7812ULL, 0x040fe400078ec0ffULL, 0x00000010ff4c7819ULL, 0x000fe40000011639ULL,
0x0000ffff39517812ULL, 0x000fc400078ec0ffULL, 0x00000052ff4d723eULL, 0x000fe400020006ffULL,
0x000000ff4a677812ULL, 0x000fe400078ec0ffULL, 0x00000043ff35723eULL, 0x000fe400020006ffULL,
0x000000ff4b397812ULL, 0x000fe400078ec0ffULL, 0x00000065ff65723eULL, 0x000fe400020006ffULL,
0x00000064ff64723eULL, 0x000fc400020006ffULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x0000541035357816ULL, 0x000fe4000000004dULL, 0x00000039ff39723eULL, 0x000fe400020006ffULL,
0x00000010ff4e7819ULL, 0x100fe4000001163eULL, 0x000000ff3e637812ULL, 0x000fe200078ec0ffULL,
0x000000340c18723cULL, 0x000b620000001818ULL, 0x00000018ff557819ULL, 0x000fc4000001163eULL,
0x0000ffff3e417812ULL, 0x000fe400078ec0ffULL, 0x000000ff383e7812ULL, 0x040fe400078ec0ffULL,
0x00000010ff527819ULL, 0x000fe20000011638ULL, 0x0000001049347824ULL, 0x020fe200078e0266ULL,
0x0000ffff384d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5d7819ULL, 0x000fe4000001163cULL,
0x0000541065387816ULL, 0x000fe20000000067ULL, 0x000000003434783bULL, 0x000e620000004200ULL,
0x0000541064397816ULL, 0x000fc40000000039ULL, 0x000000ff3c5b7812ULL, 0x000fe400078ec0ffULL,
0x000000ff5d5d7812ULL, 0x000fe400078ec0ffULL, 0x000000ff5f5f7812ULL, 0x000fe200078ec0ffULL,
0x000000380c1c723cULL, 0x000be2000000181cULL, 0x0000005bff5b723eULL, 0x000fe400020006ffULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x00000018ff5c7819ULL, 0x000fc4000001163cULL,
0x0000005dff38723eULL, 0x020fe400020006ffULL, 0x0000005fff39723eULL, 0x000fe400020006ffULL,
0x000054105b387816ULL, 0x000fe40000000038ULL, 0x0000541062397816ULL, 0x000fe40000000039ULL,
0x0000ffff3c577812ULL, 0x000fe400078ec0ffULL, 0x000000ff3a3c7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff507819ULL, 0x100fe2000001163aULL, 0x000000380c24723cULL, 0x000b620000001824ULL,
0x00000018ff537819ULL, 0x000fe4000001163aULL, 0x0000ffff3a437812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4a7819ULL, 0x100fe4000001163bULL, 0x000000ff3b5a7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff547819ULL, 0x000fc4000001163bULL, 0x0000ffff3b4b7812ULL, 0x000fe400078ec0ffULL,
0x009000004838783bULL, 0x020ea20000000200ULL, 0x00000008ff577819ULL, 0x000fe40000011657ULL,
0x00000008ff587819ULL, 0x000fe40000011658ULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x0000005eff5e723eULL, 0x000fe400020006ffULL, 0x00000057ff57723eULL, 0x000fc400020006ffULL,
0x00000058ff58723eULL, 0x000fe400020006ffULL, 0x000000ff4e5b7812ULL, 0x000fe400078ec0ffULL,
0x000000ff4f5d7812ULL, 0x000fe400078ec0ffULL, 0x00005410574e7816ULL, 0x000fe4000000005cULL,
0x00005410584f7816ULL, 0x000fe4000000005eULL, 0x0000005aff57723eULL, 0x000fc400020006ffULL,
0x00000056ff65723eULL, 0x000fe400020006ffULL, 0x000000ff345f7812ULL, 0x042fe200078ec0ffULL,
0x0000004e0c28723cULL, 0x000b620000001828ULL, 0x00000018ff5a7819ULL, 0x000fe40000011634ULL,
0x0000ffff34567812ULL, 0x000fe400078ec0ffULL, 0x00000008ff427819ULL, 0x000fe40000011642ULL,
0x0000005bff4e723eULL, 0x020fc400020006ffULL, 0x00000010ff5b7819ULL, 0x000fe40000011634ULL,
0x00000008ff347819ULL, 0x000fe40000011641ULL, 0x000000ff52527812ULL, 0x000fe200078ec0ffULL,
0x0000000438388232ULL, 0x084fe20000000000ULL, 0x000000ff4c4c7812ULL, 0x000fe200078ec0ffULL,
0x000000043a3a8232ULL, 0x000fe20000000000ULL, 0x0000005dff4f723eULL, 0x000fe200020006ffULL,
0x0000000239398232ULL, 0x080fe20000000000ULL, 0x00000063ff63723eULL, 0x000fe200020006ffULL,
0x000000023b3b8232ULL, 0x000fe20000000000ULL, 0x00000059ff59723eULL, 0x000fc400020006ffULL,
0x00000010ff5c7819ULL, 0x100fe40000011635ULL, 0x000000ff35627812ULL, 0x040fe400078ec0ffULL,
0x00000018ff5d7819ULL, 0x000fe40000011635ULL, 0x0000ffff35587812ULL, 0x000fe400078ec0ffULL,
0x00000055ff64723eULL, 0x000fe400020006ffULL, 0x00000034ff34723eULL, 0x000fc400020006ffULL,
0x00000042ff35723eULL, 0x000fe400020006ffULL, 0x0000003eff3e723eULL, 0x000fe400020006ffULL,
0x0000003fff3f723eULL, 0x000fe400020006ffULL, 0x00000052ff42723eULL, 0x000fe400020006ffULL,
0x0000004cff4c723eULL, 0x000fe400020006ffULL, 0x00005410634e7816ULL, 0x000fc4000000004eULL,
0x00005410594f7816ULL, 0x000fe4000000004fULL, 0x0000541034347816ULL, 0x000fe40000000064ULL,
0x0000541035357816ULL, 0x000fe40000000065ULL, 0x000054103e3e7816ULL, 0x000fe20000000042ULL,
0x0000004e0c2c723cULL, 0x000f62000000182cULL, 0x000054103f3f7816ULL, 0x000fe4000000004cULL,
0x00000008ff4d7819ULL, 0x000fc4000001164dULL, 0x00000008ff517819ULL, 0x000fe40000011651ULL,
0x0000003dff3d723eULL, 0x000fe200020006ffULL, 0x000000340c0c723cULL, 0x000f620000001814ULL,
0x0000004dff4d723eULL, 0x000fe400020006ffULL, 0x00000008ff437819ULL, 0x000fe40000011643ULL,
0x00000008ff4b7819ULL, 0x000fe4000001164bULL, 0x00000053ff53723eULL, 0x000fe200020006ffULL,
0x0000003e3814723cULL, 0x000b620000001810ULL, 0x00000054ff54723eULL, 0x000fc400020006ffULL,
0x000000ff5b5b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff5c5c7812ULL, 0x000fe400078ec0ffULL,
0x00000051ff11723eULL, 0x020fe400020006ffULL, 0x000054104d107816ULL, 0x000fe40000000040ULL,
0x0000541011117816ULL, 0x000fe4000000003dULL, 0x0000005fff5f723eULL, 0x000fc400020006ffULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x00000010ff4f7819ULL, 0x100fe20000011636ULL,
0x000000103818723cULL, 0x000b620000001818ULL, 0x000000ff365e7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff4e7819ULL, 0x000fe40000011636ULL, 0x00000010ff557819ULL, 0x000fe40000011637ULL,
0x00000043ff10723eULL, 0x020fc400020006ffULL, 0x0000004bff11723eULL, 0x000fe400020006ffULL,
0x0000541010107816ULL, 0x000fe40000000053ULL, 0x0000541011117816ULL, 0x000fe40000000054ULL,
0x000000ff37597812ULL, 0x040fe400078ec0ffULL, 0x00000018ff417819ULL, 0x000fe40000011637ULL,
0x0000ffff36367812ULL, 0x000fe200078ec0ffULL, 0x000000103820723cULL, 0x000b620000001820ULL,
0x0000ffff37377812ULL, 0x000fc400078ec0ffULL, 0x000000ff50507812ULL, 0x000fe400078ec0ffULL,
0x000000ff4a4a7812ULL, 0x000fe400078ec0ffULL, 0x0000005bff10723eULL, 0x020fe400020006ffULL,
0x0000005cff11723eULL, 0x000fe400020006ffULL, 0x000054105f107816ULL, 0x000fe40000000010ULL,
0x0000541062117816ULL, 0x000fc40000000011ULL, 0x00000008ff567819ULL, 0x000fe40000011656ULL,
0x00000008ff587819ULL, 0x000fe40000011658ULL, 0x000000ff4f4f7812ULL, 0x000fe200078ec0ffULL,
0x000000103824723cULL, 0x000b620000001824ULL, 0x000000ff55557812ULL, 0x000fe400078ec0ffULL,
0x00000008ff367819ULL, 0x000fe40000011636ULL, 0x00000008ff377819ULL, 0x000fc40000011637ULL,
0x0000003cff3c723eULL, 0x000fe400020006ffULL, 0x00000050ff50723eULL, 0x000fe400020006ffULL,
0x0000004aff3d723eULL, 0x000fe400020006ffULL, 0x0000005aff5a723eULL, 0x000fe400020006ffULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x0000005eff5e723eULL, 0x000fc400020006ffULL,
0x00000059ff59723eULL, 0x000fe400020006ffULL, 0x00000056ff10723eULL, 0x020fe400020006ffULL,
0x00000058ff11723eULL, 0x000fe400020006ffULL, 0x0000004fff4f723eULL, 0x000fe400020006ffULL,
0x00000055ff55723eULL, 0x000fe400020006ffULL, 0x0000004eff4e723eULL, 0x000fc400020006ffULL,
0x00000041ff41723eULL, 0x000fe400020006ffULL, 0x00000036ff36723eULL, 0x000fe400020006ffULL,
0x00000037ff37723eULL, 0x000fe400020006ffULL, 0x000054103c3c7816ULL, 0x000fe40000000050ULL,
0x00005410573d7816ULL, 0x000fe4000000003dULL, 0x0000541010107816ULL, 0x000fc4000000005aULL,
0x0000541011117816ULL, 0x000fe4000000005dULL, 0x000054105e5e7816ULL, 0x000fe2000000004fULL,
0x0000003c381c723cULL, 0x000f62000000181cULL, 0x00005410595f7816ULL, 0x000fe40000000055ULL,
0x0000541036367816ULL, 0x000fe4000000004eULL, 0x0000541037377816ULL, 0x000fc60000000041ULL,
0x000000103828723cULL, 0x040f700000001828ULL, 0x0000005e382c723cULL, 0x040f70000000182cULL,
0x000000363838723cULL, 0x000b6e000000180cULL, 0x0000f6c8080c7811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x000000000c0c7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6880033ff7f8cULL, 0x0005e4000c80043fULL,
0x00000000000e7805ULL, 0x000fc40000015200ULL, 0x0000040006117984ULL, 0x000ee40000000800ULL,
0x8000000011ff7812ULL, 0x00afc4000780480dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff127224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000107805ULL, 0x000fcc0000015200ULL,
0x000000100e137210ULL, 0x000fca0007f1e1ffULL, 0x0000000111117824ULL, 0x000fe200000e0e0fULL,
0x003d09001300780cULL, 0x000fc80003f06070ULL, 0x000000ff1100720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401300780cULL, 0x000fc80003f06070ULL,
0x000000ff1100720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff107819ULL, 0x000fc80000011411ULL, 0x0000001310107211ULL, 0x000fca00078110ffULL,
0x000000ffff117224ULL, 0x000fca00000e0611ULL, 0x0000000210107819ULL, 0x000fc80000001211ULL,
0x000000100000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000112127810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040006117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fe4000780480dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000010000e7824ULL, 0x000fe400078e00ffULL,
0x0000590032327a24ULL, 0x010fe400078e02ffULL, 0x00000080ff357424ULL, 0x000fe200078e00ffULL,
0xffffffe00e0c7812ULL, 0x000fe200078ec0ffULL, 0x0000008032327824ULL, 0x000fc800078e00ffULL,
0x00000100070c7824ULL, 0x000fe400078e020cULL, 0x0000620032347625ULL, 0x000fc600078e0035ULL,
0x000000800c0d7810ULL, 0x000fc80007ffe0ffULL, 0x000000600d0c7812ULL, 0x000fca00078ec0ffULL,
0x0000000173137824ULL, 0x000fe200078e020cULL, 0x000003d000009947ULL, 0x000fea0003800000ULL,
0x0000000d6b0c7217ULL, 0x000fe40007800000ULL, 0x000000100e0f7812ULL, 0x000fe400078ec0ffULL,
0x00000003ff0e7819ULL, 0x000fe20000011603ULL, 0x000000010c0c7824ULL, 0x000fc600078e0a0dULL,
0x000000040e117810ULL, 0x040fe20007ffe0ffULL, 0x000000010e107824ULL, 0x040fe200078e020fULL,
0x0000000c0f0c7217ULL, 0x000fe40007800000ULL, 0x000000080e327810ULL, 0x000fe20007ffe0ffULL,
0x00000001100d7824ULL, 0x040fe400078e0203ULL, 0x0000000810127824ULL, 0x000fe400078e00ffULL,
0x000000010c0c7824ULL, 0x000fc600078e0a0fULL, 0xfffffff8123d7812ULL, 0x000fe200078ee20dULL,
0x0000000111127824ULL, 0x040fe200078e020fULL, 0x0000000c1100720cULL, 0x080fe20003f66070ULL,
0x00000001100d7824ULL, 0x100fe200078e0213ULL, 0x0000000c0e117810ULL, 0x000fe20007ffe0ffULL,
0x0000000112107824ULL, 0x000fe200078e0213ULL, 0x0000000c0e00720cULL, 0x080fe20003f86070ULL,
0x00000001120e7824ULL, 0x000fe200078e0203ULL, 0x0000000c3200720cULL, 0x0c0fe20003f46070ULL,
0x0000000132327824ULL, 0x000fe200078e020fULL, 0x0000000c1100720cULL, 0x000fe20003f06070ULL,
0x000000800d0c7825ULL, 0x000fc800078e00ffULL, 0x00000008123f7824ULL, 0x000fe400078e00ffULL,
0x0000000111367824ULL, 0x000fe200078e020fULL, 0x000000600c0f7212ULL, 0x000fe200078efcffULL,
0x0000000132127824ULL, 0x040fe200078e0213ULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee20eULL,
0x0000000132337824ULL, 0x004fe200078e0203ULL, 0x0000000f340c7210ULL, 0x000fe20007fbe0ffULL,
0x0000000832327824ULL, 0x000fe400078e00ffULL, 0x0000008010107825ULL, 0x000fc600078e00ffULL,
0xfffffff832417812ULL, 0x000fe200078ee233ULL, 0x00000001360e7824ULL, 0x000fe200078e0213ULL,
0x0000006010337212ULL, 0x000fe200078efcffULL, 0x0000008012127825ULL, 0x000fc800078e00ffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x0000006012377212ULL, 0x000fc600078efcffULL,
0x00000001350d7824ULL, 0x040fe200028e060dULL, 0x0000003334107210ULL, 0x000fe20007fbe0ffULL,
0x0000000136327824ULL, 0x000fe200078e0203ULL, 0x000000600e337212ULL, 0x000fe200078efcffULL,
0x0000000836437824ULL, 0x000fe400078e00ffULL, 0x0000000135117824ULL, 0x000fe200028e0611ULL,
0x0000003734127210ULL, 0x040fe20007fbe0ffULL, 0x000000103f377824ULL, 0x100fe200078e0266ULL,
0x00000033340e7210ULL, 0x000fe20007fde0ffULL, 0x000000103d337824ULL, 0x000fe200078e0266ULL,
0xfffffff843437812ULL, 0x000fe200078ee232ULL, 0x0000000135137824ULL, 0x000fc400028e0613ULL,
0x00000010413d7824ULL, 0x100fe200078e0266ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c337faeULL, 0x0003e2000e101c48ULL, 0x00000001350f7824ULL, 0x000fe400030e060fULL,
0x00000010433f7824ULL, 0x000fe200078e0266ULL, 0x0000000010377faeULL, 0x0003e8000d901c48ULL,
0x00000000123d7faeULL, 0x0003e8000d101c48ULL, 0x000000000e3f7faeULL, 0x0003e2000c101c48ULL,
0x0000030000007947ULL, 0x000fea0003800000ULL, 0x000000100e0e7812ULL, 0x000fc800078ec0ffULL,
0x0000000e030c7211ULL, 0x000fc800078fe8ffULL, 0x000000040c107810ULL, 0x040fe20007ffe0ffULL,
0x000000010c0d7824ULL, 0x140fe200078e0203ULL, 0x000000080c127810ULL, 0x040fe20007ffe0ffULL,
0x000000080c327824ULL, 0x000fe400078e00ffULL, 0x00000001100e7824ULL, 0x040fe400078e0203ULL,
0x0000000810417824ULL, 0x000fe200078e00ffULL, 0xfffffff8323f7812ULL, 0x000fe200078ee20dULL,
0x00000001120f7824ULL, 0x000fe200078e0203ULL, 0x0000000c0c327810ULL, 0x000fe20007ffe0ffULL,
0x0000000812367824ULL, 0x000fe200078e00ffULL, 0xfffffff841417812ULL, 0x000fe200078ee20eULL,
0x000000010c0e7824ULL, 0x000fc400078e0213ULL, 0x0000000110107824ULL, 0x000fe200078e0213ULL,
0xfffffff836437812ULL, 0x000fe200078ee20fULL, 0x000000800e0e7825ULL, 0x000fc800078e00ffULL,
0x0000000112127824ULL, 0x100fe200078e0213ULL, 0x000000600e337212ULL, 0x004fe200078efcffULL,
0x00000001320c7824ULL, 0x000fe400078e0213ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x00000033340e7210ULL, 0x000fc60007f1e0ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x00000060103d7212ULL, 0x000fc600078efcffULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x0000006012377212ULL, 0x080fe400078efcffULL, 0x0000003d34107210ULL, 0x000fe20007f5e0ffULL,
0x0000000132367824ULL, 0x000fe200078e0203ULL, 0x000000600c337212ULL, 0x000fe200078efcffULL,
0x00000008324b7824ULL, 0x000fe400078e00ffULL, 0x00000001350f7824ULL, 0x040fe200000e060fULL,
0x0000003734127210ULL, 0x040fe20007f1e0ffULL, 0x0000000135117824ULL, 0x000fe200010e0611ULL,
0xfffffff84b4b7812ULL, 0x000fe200078ee236ULL, 0x0000001041377824ULL, 0x100fe200078e0266ULL,
0x00000033340c7210ULL, 0x000fe20007f7e0ffULL, 0x000000103f337824ULL, 0x000fc400078e0266ULL,
0x0000000135137824ULL, 0x000fe400000e0613ULL, 0x00000010433d7824ULL, 0x100fe200078e0266ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e337faeULL, 0x0003e2000b901c48ULL,
0x00000001350d7824ULL, 0x000fe400018e060dULL, 0x000000104b3f7824ULL, 0x000fe200078e0266ULL,
0x0000000010377faeULL, 0x0003e8000b901c48ULL, 0x00000000123d7faeULL, 0x0003e8000b901c48ULL,
0x000000000c3f7faeULL, 0x0003e4000b901c48ULL, 0x00000008000c7824ULL, 0x002fca00078e00ffULL,
0xfffffff00c0c7812ULL, 0x000fc800078ec0ffULL, 0x000000000c0573c2ULL, 0x000e6200000e0000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000f6a805057890ULL, 0x002fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a05ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6a8000c107f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f628000b0c7f8cULL, 0x0022e4000c80043fULL,
0x00000000000e7805ULL, 0x000fc40000015200ULL, 0x00f62c000b137984ULL, 0x000f240000000800ULL,
0x8000000013ff7812ULL, 0x018fe4000780480dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff327224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x000000120e337210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e0fULL,
0x003d09003300780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403300780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff127819ULL, 0x000fc80000011413ULL, 0x0000003312127211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0613ULL, 0x0000000212127819ULL, 0x000fc80000001213ULL,
0x000000120000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000132327810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f62c000b137984ULL, 0x000ee40000000800ULL, 0x8000000013ff7812ULL, 0x008fe4000780480dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000020000c7824ULL, 0x000fca00078e00ffULL,
0xffffff800c0d7812ULL, 0x000fc800078ec0ffULL, 0x00000080600d7810ULL, 0x000fca0007ffe00dULL,
0x00000001680d7824ULL, 0x000fca00078e020dULL, 0x00f000000d327984ULL, 0x000ee80000000800ULL,
0x00f200000d337984ULL, 0x0002a20000000800ULL, 0x000000093200720bULL, 0x008fe20003f1d000ULL,
0x0000d5827f007947ULL, 0x000fd8000b800000ULL, 0x00000000000e7806ULL, 0x002fc800000e0100ULL,
0x0000ffff0e377812ULL, 0x000fe2000780c0ffULL, 0x000004b000007945ULL, 0x000fe20003800000ULL,
0x00000001ff0d7424ULL, 0x000fe400078e00ffULL, 0x000000ffff0c7224ULL, 0x000fd200078e0009ULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x00000001790d7810ULL, 0x000fe40007ffe0ffULL,
0x000000093200720bULL, 0x000fe40003f54000ULL, 0x000000000d00720cULL, 0x000fe20003f05270ULL,
0x0000d5227f007947ULL, 0x000fd4000b800000ULL, 0x00000000000c7806ULL, 0x000fc400010e0100ULL,
0x00000080000f8824ULL, 0x000fe200078e0260ULL, 0x00000009320d8209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe20003800000ULL, 0x000099100c0e7816ULL, 0x000fe200000000ffULL,
0x0000000168128824ULL, 0x000fca00078e020fULL, 0x00f4000d12008388ULL, 0x0003e20000000800ULL,
0x000000ff0e00720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x00000009320e7209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff0cff7812ULL, 0x000fc6000780c0ffULL, 0x000000090e0d7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b0d0d7820ULL, 0x000fcc0000410000ULL, 0x0000000d000d7308ULL, 0x000e640000000800ULL,
0x0000000d0a0a7220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff0e7819ULL, 0x000fe20000011603ULL, 0x0000d4427f007947ULL, 0x000fea000b800000ULL,
0x00001f0e0d127589ULL, 0x0002e400000e0000ULL, 0x0000001214147220ULL, 0x08cfe20000410000ULL,
0x0000001215157220ULL, 0x080fe20000410000ULL, 0x0000001218187220ULL, 0x080fe20000410000ULL,
0x0000001219197220ULL, 0x080fe20000410000ULL, 0x000000121c1c7220ULL, 0x080fe20000410000ULL,
0x000000121d1d7220ULL, 0x080fe20000410000ULL, 0x0000001220207220ULL, 0x080fe20000410000ULL,
0x0000001221217220ULL, 0x080fe20000410000ULL, 0x0000001224247220ULL, 0x080fe20000410000ULL,
0x0000001225257220ULL, 0x080fe20000410000ULL, 0x0000001228287220ULL, 0x080fe20000410000ULL,
0x0000001229297220ULL, 0x080fe20000410000ULL, 0x000000122c2c7220ULL, 0x080fe20000410000ULL,
0x000000122d2d7220ULL, 0x080fe20000410000ULL, 0x0000001238387220ULL, 0x080fe20000410000ULL,
0x0000001239397220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff000cff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008030e7811ULL, 0x002fe200078ff0ffULL, 0x0000d3227f007947ULL, 0x000fea000b800000ULL,
0x00001f0e0d127589ULL, 0x0002e400000e0000ULL, 0x0000001216167220ULL, 0x08cfe20000410000ULL,
0x0000001217177220ULL, 0x080fe20000410000ULL, 0x000000121a1a7220ULL, 0x080fe20000410000ULL,
0x000000121b1b7220ULL, 0x080fe20000410000ULL, 0x000000121e1e7220ULL, 0x080fe20000410000ULL,
0x000000121f1f7220ULL, 0x080fe20000410000ULL, 0x0000001222227220ULL, 0x080fe20000410000ULL,
0x0000001223237220ULL, 0x080fe20000410000ULL, 0x0000001226267220ULL, 0x080fe20000410000ULL,
0x0000001227277220ULL, 0x080fe20000410000ULL, 0x000000122a2a7220ULL, 0x080fe20000410000ULL,
0x000000122b2b7220ULL, 0x080fe20000410000ULL, 0x000000122e2e7220ULL, 0x080fe20000410000ULL,
0x000000122f2f7220ULL, 0x080fe20000410000ULL, 0x000000123a3a7220ULL, 0x080fe20000410000ULL,
0x000000123b3b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff37ff7812ULL, 0x000fe2000780600cULL, 0x00000001ff0d7424ULL, 0x000fe200078e00ffULL,
0x00000009320c7209ULL, 0x000fd60007810000ULL, 0x8000000c32320221ULL, 0x000fe20000010000ULL,
0x00007610ff0d0816ULL, 0x000fc6000000000dULL, 0x3fb8aa3b32320820ULL, 0x000fc80000410000ULL,
0x0000003200050308ULL, 0x000e640000000800ULL, 0x0000000533330220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000a330a7221ULL, 0x004fc20000010000ULL,
0x00000000000e7805ULL, 0x000fcc0000015200ULL, 0x0000000800097824ULL, 0x000fca00078e00ffULL,
0xfffffff009327812ULL, 0x000fca00078ec0ffULL, 0x00f6b40032097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe40007804831ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff337224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103300780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x000000120e127210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e0fULL,
0x003d09001200780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401200780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff097819ULL, 0x000fc80000011413ULL, 0x0000001209097211ULL, 0x000fca00078110ffULL,
0x000000ffff127224ULL, 0x000fca00000e0613ULL, 0x0000000209097819ULL, 0x000fc80000001212ULL,
0x000000090000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000133337810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f6b40032097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fe40007804831ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099100d097816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff0900720cULL, 0x000fda0003f05270ULL,
0x0000012000000947ULL, 0x000fea0003800000ULL, 0x00000005ff02723eULL, 0x000fe400000000ffULL,
0x00000002ff307819ULL, 0x000fe40000011603ULL, 0x0000541002097816ULL, 0x000fe20000000002ULL,
0x0000ced27f007947ULL, 0x000fea000b800000ULL, 0x00001f3009047589ULL, 0x0002a400000e0000ULL,
0x00000008300e7810ULL, 0x000fe20007ffe0ffULL, 0x0000cf027f007947ULL, 0x000fea000b800000ULL,
0x00001f0e09027589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000010300e7810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff0f7224ULL, 0x000fe200078e0009ULL,
0x0000558000137802ULL, 0x000fc40000000f00ULL, 0x0000d71000007944ULL, 0x006fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000018300e7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff0f7224ULL, 0x000fe200078e0009ULL, 0x000055d000137802ULL, 0x000fc40000000f00ULL,
0x0000d6c000007944ULL, 0x006fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe40003800000ULL, 0x0000100066097810ULL, 0x00afe20007ffe0ffULL,
0x00980000473c783bULL, 0x000e680000000200ULL, 0x0000001046307824ULL, 0x000fc400078e0209ULL,
0x0000001045407824ULL, 0x000fc800078e0209ULL, 0x000000003030783bULL, 0x000ee80000004200ULL,
0x000000004040783bULL, 0x000f220000004200ULL, 0x000000043c3c8232ULL, 0x086fe40000000000ULL,
0x000000043e3e8232ULL, 0x000fe40000000000ULL, 0x000000023d3d8232ULL, 0x080fe40000000000ULL,
0x000000023f3f8232ULL, 0x000fe20000000000ULL, 0x00000010ff4f7819ULL, 0x008fc40000011630ULL,
0x00000018ff567819ULL, 0x000fe40000011630ULL, 0x000000ff30587812ULL, 0x040fe400078ec0ffULL,
0x0000ffff30527812ULL, 0x000fe200078ec0ffULL, 0x0000001044307824ULL, 0x000fe200078e0209ULL,
0x00000010ff137819ULL, 0x100fe40000011631ULL, 0x00000018ff597819ULL, 0x000fe40000011631ULL,
0x000000ff315b7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff31537812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4a7819ULL, 0x100fe40000011632ULL, 0x000000ff32367812ULL, 0x040fe400078ec0ffULL,
0x00000018ff657819ULL, 0x000fe40000011632ULL, 0x0000ffff32127812ULL, 0x000fe400078ec0ffULL,
0x00000010ff517819ULL, 0x000fc40000011633ULL, 0x000000ff330f7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff647819ULL, 0x000fe40000011633ULL, 0x0000ffff33577812ULL, 0x000fe400078ec0ffULL,
0x000000003030783bULL, 0x000e620000004200ULL, 0x00000010ff5a7819ULL, 0x110fe40000011640ULL,
0x000000ff40627812ULL, 0x000fe400078ec0ffULL, 0x00000018ff507819ULL, 0x000fc40000011640ULL,
0x0000ffff40547812ULL, 0x000fe400078ec0ffULL, 0x00000010ff637819ULL, 0x100fe40000011641ULL,
0x000000ff415e7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff407819ULL, 0x000fe40000011641ULL,
0x0000ffff41557812ULL, 0x000fe400078ec0ffULL, 0x00000010ff377819ULL, 0x000fc40000011642ULL,
0x000000ff42417812ULL, 0x040fe400078ec0ffULL, 0x00000018ff4c7819ULL, 0x000fe40000011642ULL,
0x0000ffff420d7812ULL, 0x000fe400078ec0ffULL, 0x00000059ff42723eULL, 0x000fe400020006ffULL,
0x000000ff4f597812ULL, 0x000fe400078ec0ffULL, 0x000000ff13137812ULL, 0x000fc400078ec0ffULL,
0x00000010ff4b7819ULL, 0x100fe40000011643ULL, 0x000000ff434e7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff4d7819ULL, 0x000fe40000011643ULL, 0x0000ffff430e7812ULL, 0x000fe400078ec0ffULL,
0x00000040ff4f723eULL, 0x000fe400020006ffULL, 0x00000056ff43723eULL, 0x000fc400020006ffULL,
0x00000059ff40723eULL, 0x000fe400020006ffULL, 0x00000058ff58723eULL, 0x000fe400020006ffULL,
0x0000005bff56723eULL, 0x000fe400020006ffULL, 0x00000013ff59723eULL, 0x000fe400020006ffULL,
0x00000041ff13723eULL, 0x000fe400020006ffULL, 0x0000541058407816ULL, 0x000fc40000000040ULL,
0x0000541056417816ULL, 0x000fe40000000059ULL, 0x00000008ff527819ULL, 0x000fe40000011652ULL,
0x00000008ff537819ULL, 0x000fe40000011653ULL, 0x000000ff51517812ULL, 0x000fe200078ec0ffULL,
0x000000403c14723cULL, 0x000b620000001814ULL, 0x00000010ff567819ULL, 0x002fe40000011630ULL,
0x000000ff30697812ULL, 0x000fc400078ec0ffULL, 0x00000018ff677819ULL, 0x000fe40000011630ULL,
0x00000052ff40723eULL, 0x020fe400020006ffULL, 0x00000053ff41723eULL, 0x000fe400020006ffULL,
0x0000541040407816ULL, 0x000fe40000000043ULL, 0x0000541041417816ULL, 0x000fe20000000042ULL,
0x0000001049427824ULL, 0x000fe200078e0209ULL, 0x00000010ff527819ULL, 0x000fc40000011631ULL,
0x000000ff31587812ULL, 0x040fe400078ec0ffULL, 0x00000018ff5c7819ULL, 0x000fe20000011631ULL,
0x000000403c18723cULL, 0x000be20000001818ULL, 0x0000ffff31537812ULL, 0x000fe400078ec0ffULL,
0x00000008ff317819ULL, 0x000fe40000011657ULL, 0x00000065ff65723eULL, 0x000fe400020006ffULL,
0x00000051ff41723eULL, 0x020fc400020006ffULL, 0x0000ffff30517812ULL, 0x000fe400078ec0ffULL,
0x00000008ff307819ULL, 0x000fe40000011612ULL, 0x00000064ff64723eULL, 0x000fe400020006ffULL,
0x00000030ff30723eULL, 0x000fe400020006ffULL, 0x00000031ff31723eULL, 0x000fe400020006ffULL,
0x0000541030307816ULL, 0x000fc40000000065ULL, 0x0000541031317816ULL, 0x000fe40000000064ULL,
0x000000ff5a5a7812ULL, 0x000fe400078ec0ffULL, 0x000000ff63637812ULL, 0x000fe400078ec0ffULL,
0x00000062ff62723eULL, 0x000fe200020006ffULL, 0x000000303c20723cULL, 0x000be20000001820ULL,
0x0000005eff5e723eULL, 0x000fe400020006ffULL, 0x00000063ff63723eULL, 0x000fc400020006ffULL,
0x000000ff4a4a7812ULL, 0x000fe400078ec0ffULL, 0x0000005aff31723eULL, 0x020fe400020006ffULL,
0x00000036ff36723eULL, 0x000fe400020006ffULL, 0x0000541062307816ULL, 0x000fe40000000031ULL,
0x000054105e317816ULL, 0x000fe40000000063ULL, 0x0000000fff0f723eULL, 0x000fc400020006ffULL,
0x0000004aff40723eULL, 0x000fe400020006ffULL, 0x000054100f417816ULL, 0x000fe20000000041ULL,
0x000000303c24723cULL, 0x040f620000001824ULL, 0x0000541036407816ULL, 0x000fe40000000040ULL,
0x00000010ff367819ULL, 0x100fe40000011632ULL, 0x000000ff325d7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff597819ULL, 0x000fe20000011632ULL, 0x000000403c1c723cULL, 0x000b62000000181cULL,
0x0000ffff320f7812ULL, 0x000fe200078ec0ffULL, 0x000000004240783bULL, 0x020fe20000004200ULL,
0x00000010ff4a7819ULL, 0x000fc40000011633ULL, 0x000000ff335f7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff5b7819ULL, 0x000fe40000011633ULL, 0x0000ffff33127812ULL, 0x000fe400078ec0ffULL,
0x009800004830783bULL, 0x000e620000000200ULL, 0x00000008ff547819ULL, 0x000fe40000011654ULL,
0x00000008ff557819ULL, 0x000fe40000011655ULL, 0x00000050ff50723eULL, 0x000fc400020006ffULL,
0x00000054ff54723eULL, 0x000fe400020006ffULL, 0x00000055ff55723eULL, 0x000fe400020006ffULL,
0x000000ff37377812ULL, 0x000fe400078ec0ffULL, 0x000000ff4b4b7812ULL, 0x000fe400078ec0ffULL,
0x0000541054547816ULL, 0x000fe40000000050ULL, 0x0000541055557816ULL, 0x000fc4000000004fULL,
0x00000008ff0d7819ULL, 0x000fe4000001160dULL, 0x00000008ff0e7819ULL, 0x000fe4000001160eULL,
0x0000004eff4e723eULL, 0x000fe200020006ffULL, 0x000000543c28723cULL, 0x000b620000001828ULL,
0x0000004cff4c723eULL, 0x000fe400020006ffULL, 0x0000004dff4d723eULL, 0x000fe400020006ffULL,
0x00000037ff37723eULL, 0x000fc400020006ffULL, 0x0000004bff4b723eULL, 0x000fe400020006ffULL,
0x0000000dff64723eULL, 0x000fe400020006ffULL, 0x0000000eff65723eULL, 0x000fe400020006ffULL,
0x0000541013547816ULL, 0x020fe40000000037ULL, 0x000054104e557816ULL, 0x000fe2000000004bULL,
0x0000000430308232ULL, 0x082fe20000000000ULL, 0x00005410644c7816ULL, 0x000fe2000000004cULL,
0x0000000432328232ULL, 0x000fe20000000000ULL, 0x00005410654d7816ULL, 0x000fe2000000004dULL,
0x0000000231318232ULL, 0x080fe20000000000ULL, 0x000000ff56567812ULL, 0x000fe200078ec0ffULL,
0x000000543c2c723cULL, 0x000f62000000182cULL, 0x000000ff52527812ULL, 0x000fe200078ec0ffULL,
0x0000000233338232ULL, 0x000fe20000000000ULL, 0x00000069ff57723eULL, 0x000fc400020006ffULL,
0x00000058ff58723eULL, 0x000fe400020006ffULL, 0x00000056ff56723eULL, 0x000fe200020006ffULL,
0x0000004c3c38723cULL, 0x000b620000001838ULL, 0x00000008ff127819ULL, 0x000fe40000011612ULL,
0x00000010ff4f7819ULL, 0x000fe40000011640ULL, 0x00000010ff507819ULL, 0x000fe40000011641ULL,
0x00000052ff3d723eULL, 0x020fc400020006ffULL, 0x00005410573c7816ULL, 0x000fe40000000056ULL,
0x00005410583d7816ULL, 0x000fe4000000003dULL, 0x0000005bff0e723eULL, 0x000fe400020006ffULL,
0x00000008ff0f7819ULL, 0x000fe4000001160fULL, 0x000000ff40637812ULL, 0x000fe200078ec0ffULL,
0x0000003c3014723cULL, 0x000b620000001814ULL, 0x000000ff41627812ULL, 0x000fc400078ec0ffULL,
0x000000ff4f4f7812ULL, 0x000fe400078ec0ffULL, 0x000000ff50507812ULL, 0x000fe400078ec0ffULL,
0x00000012ff3d723eULL, 0x020fe400020006ffULL, 0x0000000fff3c723eULL, 0x000fe400020006ffULL,
0x000054103d3d7816ULL, 0x000fe4000000000eULL, 0x00000063ff0d723eULL, 0x000fc400020006ffULL,
0x00000062ff3e723eULL, 0x000fe400020006ffULL, 0x0000004fff0e723eULL, 0x000fe400020006ffULL,
0x00000050ff0f723eULL, 0x000fe400020006ffULL, 0x00000018ff5e7819ULL, 0x000fe40000011640ULL,
0x0000ffff40487812ULL, 0x000fe400078ec0ffULL, 0x00000018ff557819ULL, 0x000fc40000011641ULL,
0x0000ffff414b7812ULL, 0x000fe400078ec0ffULL, 0x000054100d0e7816ULL, 0x000fe2000000000eULL,
0x00000002000d7824ULL, 0x000fe200078e00ffULL, 0x000054103e0f7816ULL, 0x000fe4000000000fULL,
0x00000010ff407819ULL, 0x100fe40000011642ULL, 0x000000ff42547812ULL, 0x000fe400078ec0ffULL,
0x00000018ff377819ULL, 0x000fe20000011642ULL, 0x0000000e3024723cULL, 0x000b620000001824ULL,
0x00000010ff417819ULL, 0x000fc40000011643ULL, 0x000000ff434e7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff137819ULL, 0x000fe40000011643ULL, 0x0000ffff42427812ULL, 0x000fe400078ec0ffULL,
0x0000ffff43437812ULL, 0x000fe400078ec0ffULL, 0x00000008ff4b7819ULL, 0x000fe4000001164bULL,
0x00000008ff517819ULL, 0x000fc40000011651ULL, 0x00000008ff537819ULL, 0x000fe40000011653ULL,
0x000000ff36367812ULL, 0x000fe400078ec0ffULL, 0x000000ff4a4a7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff487819ULL, 0x000fe40000011648ULL, 0x000000ff40407812ULL, 0x000fe400078ec0ffULL,
0x000000ff41417812ULL, 0x000fc400078ec0ffULL, 0x00000008ff427819ULL, 0x000fe40000011642ULL,
0x00000008ff437819ULL, 0x000fe40000011643ULL, 0x00000055ff55723eULL, 0x000fe400020006ffULL,
0x0000004bff0f723eULL, 0x020fe400020006ffULL, 0x00000067ff5a723eULL, 0x000fe400020006ffULL,
0x0000005cff5c723eULL, 0x000fc400020006ffULL, 0x0000005dff5d723eULL, 0x000fe400020006ffULL,
0x0000005fff5f723eULL, 0x000fe400020006ffULL, 0x00000059ff59723eULL, 0x000fe400020006ffULL,
0x00000051ff51723eULL, 0x000fe400020006ffULL, 0x00000053ff5b723eULL, 0x000fe400020006ffULL,
0x0000005eff3f723eULL, 0x000fc400020006ffULL, 0x00000036ff36723eULL, 0x000fe400020006ffULL,
0x0000004aff4a723eULL, 0x000fe400020006ffULL, 0x00000054ff54723eULL, 0x000fe400020006ffULL,
0x0000004eff4e723eULL, 0x000fe400020006ffULL, 0x00000048ff0e723eULL, 0x000fe400020006ffULL,
0x00000040ff40723eULL, 0x000fc400020006ffULL, 0x00000041ff41723eULL, 0x000fe400020006ffULL,
0x00000037ff37723eULL, 0x000fe400020006ffULL, 0x00000013ff13723eULL, 0x000fe400020006ffULL,
0x00000042ff42723eULL, 0x000fe400020006ffULL, 0x00000043ff43723eULL, 0x000fe400020006ffULL,
0x000054100f0f7816ULL, 0x000fc40000000055ULL, 0x00005410515a7816ULL, 0x000fe4000000005aULL,
0x000054105b5b7816ULL, 0x000fe4000000005cULL, 0x000054105d5e7816ULL, 0x000fe40000000036ULL,
0x000054105f5f7816ULL, 0x000fe4000000004aULL, 0x000054103c3c7816ULL, 0x000fe20000000059ULL,
0x0000005a3018723cULL, 0x000f620000001818ULL, 0x000054100e0e7816ULL, 0x000fc4000000003fULL,
0x0000541054547816ULL, 0x000fe40000000040ULL, 0x000054104e557816ULL, 0x000fe40000000041ULL,
0x0000541042427816ULL, 0x000fe20000000037ULL, 0x0000005e301c723cULL, 0x000f62000000181cULL,
0x0000541043437816ULL, 0x000fe40000000013ULL, 0xfffffff80d0d7812ULL, 0x000fca00078ec0ffULL,
0x0000003c3020723cULL, 0x040f700000001820ULL, 0x0000000e3028723cULL, 0x040b6e0000001828ULL,
0x0000f6c8080e7811ULL, 0x020fe200078e18ffULL, 0x00000054302c723cULL, 0x040b70000000182cULL,
0x000000423030723cULL, 0x000b620000001838ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x000000000e0e7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f690000dff7f8cULL, 0x0005e4000c80043fULL,
0x0000000000127805ULL, 0x000fc40000015200ULL, 0x00000400060d7984ULL, 0x004ea40000000800ULL,
0x800000000dff7812ULL, 0x006fc4000780480fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff387224ULL, 0x020fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fcc0000015200ULL,
0x0000003612367210ULL, 0x000fca0007f1e1ffULL, 0x0000000137377824ULL, 0x000fe200000e0e13ULL,
0x003d09003600780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403600780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0d7819ULL, 0x000fc80000011437ULL, 0x000000360d0d7211ULL, 0x000fca00078110ffULL,
0x000000ffff367224ULL, 0x000fca00000e0637ULL, 0x000000020d0d7819ULL, 0x000fc80000001236ULL,
0x0000000d0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000138387810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000400060d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fe4000780480fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000020080d7824ULL, 0x000fc800078e00ffULL,
0x00000100070d7824ULL, 0x000fca00078e020dULL, 0x000000c00d0f7810ULL, 0x000fc80007ffe0ffULL,
0x000000600f127812ULL, 0x000fca00078ec0ffULL, 0x0000000173127824ULL, 0x000fe200078e0212ULL,
0x000003e000009947ULL, 0x000fea0003800000ULL, 0x0000000f6b0e7217ULL, 0x000fe20007800000ULL,
0x0000001000137824ULL, 0x000fc800078e00ffULL, 0x000000010e0e7824ULL, 0x000fe200078e0a0fULL,
0x0000001013137812ULL, 0x000fe400078ec0ffULL, 0x00000003ff0f7819ULL, 0x000fe40000011603ULL,
0x0000000e130e7217ULL, 0x000fe40007800000ULL, 0x000000040f377810ULL, 0x040fe20007ffe0ffULL,
0x000000010f367824ULL, 0x140fe200078e0213ULL, 0x000000080f397810ULL, 0x040fe20007ffe0ffULL,
0x000000010e0e7824ULL, 0x100fe200078e0a13ULL, 0x0000000c0f3a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000137387824ULL, 0x000fc400078e0213ULL, 0x00000008363c7824ULL, 0x040fe200078e00ffULL,
0x0000000e0f00720cULL, 0x080fe20003f86070ULL, 0x00000001360f7824ULL, 0x040fe200078e0212ULL,
0x0000000e3700720cULL, 0x080fe20003f66070ULL, 0x0000000136377824ULL, 0x100fe200078e0203ULL,
0x0000000e3900720cULL, 0x080fe20003f46070ULL, 0x0000000138367824ULL, 0x000fe200078e0203ULL,
0x0000000e3a00720cULL, 0x000fe20003f06070ULL, 0x00000008383b7824ULL, 0x000fe400078e00ffULL,
0x000000800f0e7825ULL, 0x000fc800078e00ffULL, 0x0000000139397824ULL, 0x100fe400078e0213ULL,
0x000000013a3f7824ULL, 0x000fe200078e0213ULL, 0xfffffff83c3a7812ULL, 0x000fe200078ee237ULL,
0x0000000138387824ULL, 0x000fe200078e0212ULL, 0xfffffff83b3c7812ULL, 0x000fe200078ee236ULL,
0x0000000139367824ULL, 0x040fe200078e0212ULL, 0x000000600e137212ULL, 0x000fe200078efcffULL,
0x0000000139377824ULL, 0x040fe400078e0203ULL, 0x00000008393e7824ULL, 0x000fe200078e00ffULL,
0x00000013340e7210ULL, 0x000fe20007fbe0ffULL, 0x0000008038387825ULL, 0x000fc600078e00ffULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee237ULL, 0x000000013f127824ULL, 0x000fe200078e0212ULL,
0x00000060383b7212ULL, 0x000fe200078efcffULL, 0x0000008036367825ULL, 0x000fc800078e00ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x00000060363d7212ULL, 0x000fc600078efcffULL,
0x00000001350f7824ULL, 0x000fe200028e060fULL, 0x0000003b34387210ULL, 0x000fe20007fbe0ffULL,
0x000000013f407824ULL, 0x040fe200078e0203ULL, 0x00000060123b7212ULL, 0x000fe200078efcffULL,
0x000000083f3f7824ULL, 0x000fe400078e00ffULL, 0x0000000135397824ULL, 0x000fe200028e0639ULL,
0x0000003d34367210ULL, 0x000fe20007fbe0ffULL, 0x000000103e3d7824ULL, 0x100fe200078e0209ULL,
0x0000003b34127210ULL, 0x000fe20007fde0ffULL, 0x000000103a3b7824ULL, 0x000fe200078e0209ULL,
0xfffffff83f407812ULL, 0x000fe200078ee240ULL, 0x0000000135377824ULL, 0x000fc400028e0637ULL,
0x0000000135137824ULL, 0x000fe200030e0613ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e3b7faeULL, 0x0003e2000e101c48ULL, 0x000000103c357824ULL, 0x100fe400078e0209ULL,
0x00000010403f7824ULL, 0x000fc600078e0209ULL, 0x0000000038357faeULL, 0x0003e8000d901c48ULL,
0x00000000363d7faeULL, 0x0003e8000d101c48ULL, 0x00000000123f7faeULL, 0x0003e2000c101c48ULL,
0x0000031000007947ULL, 0x000fea0003800000ULL, 0x00000010000e7824ULL, 0x000fca00078e00ffULL,
0x000000100e0e7812ULL, 0x000fc800078ec0ffULL, 0x0000000e030e7211ULL, 0x000fc800078fe8ffULL,
0x000000040e387810ULL, 0x040fe20007ffe0ffULL, 0x000000010e0f7824ULL, 0x140fe200078e0203ULL,
0x000000080e377810ULL, 0x040fe20007ffe0ffULL, 0x000000080e3a7824ULL, 0x000fe400078e00ffULL,
0x0000000138137824ULL, 0x040fe400078e0203ULL, 0x00000008383c7824ULL, 0x000fe200078e00ffULL,
0xfffffff83a3a7812ULL, 0x000fe200078ee20fULL, 0x000000010e367824ULL, 0x040fe200078e0212ULL,
0x0000000c0e0f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000137397824ULL, 0x040fe200078e0203ULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee213ULL, 0x00000008373e7824ULL, 0x000fc400078e00ffULL,
0x0000000137137824ULL, 0x000fe400078e0212ULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0xfffffff83e3e7812ULL, 0x000fc600078ee239ULL, 0x0000000138387824ULL, 0x100fe200078e0212ULL,
0x00000060363b7212ULL, 0x000fe200078efcffULL, 0x000000010f0e7824ULL, 0x040fe400078e0212ULL,
0x000000010f3d7824ULL, 0x040fe200078e0203ULL, 0x0000003b34367210ULL, 0x000fe20007f1e0ffULL,
0x000000080f407824ULL, 0x000fe400078e00ffULL, 0x0000008038387825ULL, 0x000fc600078e00ffULL,
0xfffffff840407812ULL, 0x000fe200078ee23dULL, 0x0000008013127825ULL, 0x000fe200078e00ffULL,
0x00000060383f7212ULL, 0x000fc600078efcffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x00000060123d7212ULL, 0x080fe400078efcffULL, 0x0000003f34387210ULL, 0x000fe20007f5e0ffULL,
0x0000000135377824ULL, 0x040fe200000e0637ULL, 0x000000600e3b7212ULL, 0x000fe200078efcffULL,
0x00000010403f7824ULL, 0x000fe200078e0209ULL, 0x0000003d34127210ULL, 0x040fe20007f1e0ffULL,
0x0000000135397824ULL, 0x000fe200010e0639ULL, 0x0000003b340e7210ULL, 0x000fe20007f7e0ffULL,
0x000000103a3b7824ULL, 0x000fc400078e0209ULL, 0x0000000135137824ULL, 0x040fe400000e0613ULL,
0x00000001350f7824ULL, 0x000fe200018e060fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000363b7faeULL, 0x0003e2000b901c48ULL, 0x000000103c357824ULL, 0x100fe400078e0209ULL,
0x000000103e3d7824ULL, 0x000fc600078e0209ULL, 0x0000000038357faeULL, 0x0003e8000b901c48ULL,
0x00000000123d7faeULL, 0x0003e8000b901c48ULL, 0x000000000e3f7faeULL, 0x0003e4000b901c48ULL,
0x000000007a0573c2ULL, 0x000ea200000e0000ULL, 0x000000026a6a7810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff677424ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x002fe40000000000ULL,
0x0000006d6a00720cULL, 0x000fda0003f06070ULL, 0x000000016a0e8824ULL, 0x000fe400078e0274ULL,
0x00000004ff0f8424ULL, 0x000fe200078e00ffULL, 0x0000f6b005057890ULL, 0x004fc6000fffe03fULL,
0x000064000e0e8625ULL, 0x000fca00078e000fULL, 0x000000080e678981ULL, 0x000322000c1e1900ULL,
0x0000000800127824ULL, 0x000fc600078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe40008000a05ULL,
0xfffffff012127812ULL, 0x000fe200078ec0ffULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6b00012347f8cULL, 0x0004e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f648000b0e7f8cULL, 0x0022a4000c80043fULL,
0x0000000000127805ULL, 0x004fc40000015200ULL, 0x00f64c000b377984ULL, 0x000ea40000000800ULL,
0x8000000037ff7812ULL, 0x004fe4000780480fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff387224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fcc0000015200ULL,
0x0000003612397210ULL, 0x000fca0007f1e1ffULL, 0x0000000137377824ULL, 0x000fe200000e0e13ULL,
0x003d09003900780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403900780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff367819ULL, 0x000fc80000011437ULL, 0x0000003936367211ULL, 0x000fca00078110ffULL,
0x000000ffff377224ULL, 0x000fca00000e0637ULL, 0x0000000236367819ULL, 0x000fc80000001237ULL,
0x000000360000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000138387810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f64c000b377984ULL, 0x000ea40000000800ULL, 0x8000000037ff7812ULL, 0x004fe4000780480fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000020000b7824ULL, 0x002fca00078e00ffULL,
0xffffff800b0b7812ULL, 0x000fc800078ec0ffULL, 0x00000100600b7810ULL, 0x000fca0007ffe00bULL,
0x00000001680b7824ULL, 0x000fca00078e020bULL, 0x00f000000b377984ULL, 0x000e680000000800ULL,
0x00f200000b367984ULL, 0x0004e20000000800ULL, 0x0000000c3700720bULL, 0x002fe20003f1d000ULL,
0x0000b1827f007947ULL, 0x000fd8000b800000ULL, 0x00000000000e7806ULL, 0x004fc800000e0100ULL,
0x0000ffff0e3a7812ULL, 0x000fe2000780c0ffULL, 0x000004b000007945ULL, 0x000fe20003800000ULL,
0x00000001ff387424ULL, 0x000fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x000fd200078e000cULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x00000002790b7810ULL, 0x000fe40007ffe0ffULL,
0x0000000c3700720bULL, 0x000fe40003f54000ULL, 0x000000000b00720cULL, 0x000fe20003f05270ULL,
0x0000b1227f007947ULL, 0x000fd4000b800000ULL, 0x00000000000b7806ULL, 0x000fc400010e0100ULL,
0x00000080000f8824ULL, 0x000fe200078e0260ULL, 0x0000000c370e8209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe40003800000ULL, 0x0000000168138824ULL, 0x000fe200078e020fULL,
0x000099100b0f7816ULL, 0x000fc800000000ffULL, 0x00f4000e13008388ULL, 0x0003e20000000800ULL,
0x000000ff0f00720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000000c370f7209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff0bff7812ULL, 0x000fc6000780c0ffULL, 0x0000000c0f0e7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b0e0e7820ULL, 0x000fc80000410000ULL, 0x0000000e00397308ULL, 0x000e640000000800ULL,
0x000000390a0a7220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff0e7819ULL, 0x000fe20000011603ULL, 0x0000b0427f007947ULL, 0x000fea000b800000ULL,
0x00001f0e39127589ULL, 0x0002a400000e0000ULL, 0x0000001214147220ULL, 0x084fe20000410000ULL,
0x0000001215157220ULL, 0x080fe20000410000ULL, 0x0000001218187220ULL, 0x080fe20000410000ULL,
0x0000001219197220ULL, 0x080fe20000410000ULL, 0x000000121c1c7220ULL, 0x080fe20000410000ULL,
0x000000121d1d7220ULL, 0x080fe20000410000ULL, 0x0000001220207220ULL, 0x080fe20000410000ULL,
0x0000001221217220ULL, 0x080fe20000410000ULL, 0x0000001224247220ULL, 0x080fe20000410000ULL,
0x0000001225257220ULL, 0x080fe20000410000ULL, 0x0000001228287220ULL, 0x080fe20000410000ULL,
0x0000001229297220ULL, 0x080fe20000410000ULL, 0x000000122c2c7220ULL, 0x080fe20000410000ULL,
0x000000122d2d7220ULL, 0x080fe20000410000ULL, 0x0000001230307220ULL, 0x080fe20000410000ULL,
0x0000001231317220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff000bff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008030e7811ULL, 0x002fe200078ff0ffULL, 0x0000af227f007947ULL, 0x000fea000b800000ULL,
0x00001f0e39127589ULL, 0x0002a400000e0000ULL, 0x0000001216167220ULL, 0x084fe20000410000ULL,
0x0000001217177220ULL, 0x080fe20000410000ULL, 0x000000121a1a7220ULL, 0x080fe20000410000ULL,
0x000000121b1b7220ULL, 0x080fe20000410000ULL, 0x000000121e1e7220ULL, 0x080fe20000410000ULL,
0x000000121f1f7220ULL, 0x080fe20000410000ULL, 0x0000001222227220ULL, 0x080fe20000410000ULL,
0x0000001223237220ULL, 0x080fe20000410000ULL, 0x0000001226267220ULL, 0x080fe20000410000ULL,
0x0000001227277220ULL, 0x080fe20000410000ULL, 0x000000122a2a7220ULL, 0x080fe20000410000ULL,
0x000000122b2b7220ULL, 0x080fe20000410000ULL, 0x000000122e2e7220ULL, 0x080fe20000410000ULL,
0x000000122f2f7220ULL, 0x080fe20000410000ULL, 0x0000001232327220ULL, 0x080fe20000410000ULL,
0x0000001233337220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff3aff7812ULL, 0x000fe2000780600bULL, 0x00000001ff387424ULL, 0x000fe200078e00ffULL,
0x0000000c370b7209ULL, 0x000fd60007810000ULL, 0x8000000b37370221ULL, 0x000fe20000010000ULL,
0x00007610ff380816ULL, 0x000fc60000000038ULL, 0x3fb8aa3b37370820ULL, 0x000fc80000410000ULL,
0x0000003700050308ULL, 0x000e640000000800ULL, 0x0000000536360220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000a360a7221ULL, 0x008fc20000010000ULL,
0x00000000000e7805ULL, 0x000fcc0000015200ULL, 0x00000008000c7824ULL, 0x000fca00078e00ffULL,
0xfffffff00c367812ULL, 0x000fca00078ec0ffULL, 0x00f6ac0036137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff397224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103900780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x000000120e377210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e0fULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0c7819ULL, 0x000fc80000011413ULL, 0x000000370c0c7211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0613ULL, 0x000000020c0c7819ULL, 0x000fc80000001213ULL,
0x0000000c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000139397810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f6ac0036137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009910380c7816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff0c00720cULL, 0x000fda0003f05270ULL,
0x0000012000000947ULL, 0x000fea0003800000ULL, 0x00000005ff02723eULL, 0x000fe400000000ffULL,
0x00000002ff117819ULL, 0x000fe40000011603ULL, 0x00005410020c7816ULL, 0x000fe20000000002ULL,
0x0000aad27f007947ULL, 0x000fea000b800000ULL, 0x00001f110c047589ULL, 0x0002a400000e0000ULL,
0x00000008110e7810ULL, 0x000fe20007ffe0ffULL, 0x0000ab027f007947ULL, 0x000fea000b800000ULL,
0x00001f0e0c027589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000010110e7810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff0f7224ULL, 0x000fe200078e000cULL,
0x00007b4000137802ULL, 0x000fc40000000f00ULL, 0x0000b15000007944ULL, 0x016fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000018110e7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff0f7224ULL, 0x000fe200078e000cULL, 0x00007b9000137802ULL, 0x000fc40000000f00ULL,
0x0000b10000007944ULL, 0x016fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001046107824ULL, 0x100fe200078e0266ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000001045387824ULL, 0x100fe200078e0266ULL, 0x0000000703407812ULL, 0x000fe200078ec0ffULL,
0x00000010443c7824ULL, 0x000fe200078e0266ULL, 0x00000002610c7810ULL, 0x00afe20007ffe0ffULL,
0x000000001010783bULL, 0x004e620000004200ULL, 0x0000000840407812ULL, 0x000fc600078ef803ULL,
0x000000003838783bULL, 0x000ea80000004200ULL, 0x000000003c3c783bULL, 0x000ee20000004200ULL,
0x00000010ff0e7819ULL, 0x102fe40000011610ULL, 0x000000ff100f7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff6e7819ULL, 0x000fe40000011610ULL, 0x0000ffff10457812ULL, 0x000fc400078ec0ffULL,
0x00000010ff367819ULL, 0x100fe40000011611ULL, 0x000000ff11377812ULL, 0x040fe400078ec0ffULL,
0x00000018ff697819ULL, 0x000fe40000011611ULL, 0x0000ffff114f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff447819ULL, 0x000fe40000011612ULL, 0x000000ff12637812ULL, 0x000fc400078ec0ffULL,
0x00000018ff5a7819ULL, 0x000fe40000011612ULL, 0x0000ffff125d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff647819ULL, 0x100fe40000011613ULL, 0x000000ff13627812ULL, 0x040fe400078ec0ffULL,
0x00000018ff587819ULL, 0x000fe40000011613ULL, 0x0000ffff135f7812ULL, 0x000fc400078ec0ffULL,
0x00a000004710783bULL, 0x000e620000000200ULL, 0x00000010ff537819ULL, 0x104fe40000011639ULL,
0x000000ff39567812ULL, 0x040fe400078ec0ffULL, 0x00000018ff597819ULL, 0x000fe40000011639ULL,
0x0000ffff39557812ULL, 0x000fe200078ec0ffULL, 0x0000000840397824ULL, 0x000fe200078e00ffULL,
0x00000010ff437819ULL, 0x108fe4000001163cULL, 0x00000018ff727819ULL, 0x000fc4000001163cULL,
0xfffffff8390c7812ULL, 0x000fe400078ee20cULL, 0x00000037ff39723eULL, 0x000fe400020006ffULL,
0x000000ff3c527812ULL, 0x040fe400078ec0ffULL, 0x0000ffff3c377812ULL, 0x000fe400078ec0ffULL,
0x00000010ff407819ULL, 0x100fe4000001163dULL, 0x00000018ff6f7819ULL, 0x000fc4000001163dULL,
0x000000ff3d3c7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff3d417812ULL, 0x000fe400078ec0ffULL,
0x000000ff363d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff4e7819ULL, 0x000fe40000011638ULL,
0x0000003dff3d723eULL, 0x000fe400020006ffULL, 0x000000ff38577812ULL, 0x000fc400078ec0ffULL,
0x0000541039397816ULL, 0x000fe4000000003dULL, 0x00000008ff3d7819ULL, 0x000fe20000011645ULL,
0x0000000410108232ULL, 0x082fe20000000000ULL, 0x00000018ff5b7819ULL, 0x000fe20000011638ULL,
0x0000000412128232ULL, 0x000fe20000000000ULL, 0x0000ffff38477812ULL, 0x000fe200078ec0ffULL,
0x0000000211118232ULL, 0x080fe20000000000ULL, 0x00000008ff4f7819ULL, 0x000fe2000001164fULL,
0x0000000213138232ULL, 0x000fe20000000000ULL, 0x00000010ff507819ULL, 0x000fc4000001163aULL,
0x000000ff3a4d7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff427819ULL, 0x000fe4000001163aULL,
0x0000ffff3a487812ULL, 0x000fe400078ec0ffULL, 0x000000ff0e387812ULL, 0x000fe400078ec0ffULL,
0x0000000fff3a723eULL, 0x000fe400020006ffULL, 0x00000010ff0e7819ULL, 0x000fc4000001163eULL,
0x000000ff3e657812ULL, 0x040fe400078ec0ffULL, 0x00000018ff547819ULL, 0x000fe4000001163eULL,
0x0000ffff3e5e7812ULL, 0x000fe400078ec0ffULL, 0x0000006eff6e723eULL, 0x000fe400020006ffULL,
0x00000010ff0f7819ULL, 0x000fe4000001163fULL, 0x000000ff3f3e7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff467819ULL, 0x000fe4000001163fULL, 0x0000ffff3f5c7812ULL, 0x000fe400078ec0ffULL,
0x0000003dff3d723eULL, 0x000fe400020006ffULL, 0x00000069ff69723eULL, 0x000fe400020006ffULL,
0x0000004fff3f723eULL, 0x000fe400020006ffULL, 0x0000003cff4f723eULL, 0x000fc400020006ffULL,
0x000054103d3c7816ULL, 0x000fe4000000006eULL, 0x000054103f3d7816ULL, 0x000fe40000000069ULL,
0x000000ff44447812ULL, 0x000fe400078ec0ffULL, 0x000000ff64647812ULL, 0x000fe400078ec0ffULL,
0x00000063ff63723eULL, 0x000fe200020006ffULL, 0x0000003c1018723cULL, 0x000b620000001818ULL,
0x00000062ff62723eULL, 0x000fc400020006ffULL, 0x00000008ff5d7819ULL, 0x000fe4000001165dULL,
0x00000008ff5f7819ULL, 0x000fe4000001165fULL, 0x00000044ff3c723eULL, 0x020fe400020006ffULL,
0x00000064ff3d723eULL, 0x000fe400020006ffULL, 0x00005410633c7816ULL, 0x000fe4000000003cULL,
0x00005410623d7816ULL, 0x000fc4000000003dULL, 0x0000005aff5a723eULL, 0x000fe400020006ffULL,
0x00000058ff58723eULL, 0x000fe400020006ffULL, 0x000000ff4e3f7812ULL, 0x000fe200078ec0ffULL,
0x0000003c101c723cULL, 0x000b62000000181cULL, 0x0000003eff4e723eULL, 0x000fe400020006ffULL,
0x0000003fff3e723eULL, 0x000fe200020006ffULL, 0x00000200003f7824ULL, 0x000fe200078e00ffULL,
0x000000ff53537812ULL, 0x000fc400078ec0ffULL, 0x0000005dff3c723eULL, 0x020fe400020006ffULL,
0x0000005fff3d723eULL, 0x000fe400020006ffULL, 0x000054103c3c7816ULL, 0x000fe4000000005aULL,
0x000054103d3d7816ULL, 0x000fe40000000058ULL, 0x00000038ff38723eULL, 0x000fe400020006ffULL,
0x00000057ff57723eULL, 0x000fc400020006ffULL, 0x00000056ff56723eULL, 0x000fe200020006ffULL,
0x0000003c1020723cULL, 0x040be20000001820ULL, 0xfffff8003f3f7812ULL, 0x000fe400078ec0ffULL,
0x000054103a387816ULL, 0x000fe40000000038ULL, 0x00000010ff517819ULL, 0x100fe4000001163bULL,
0x00000053ff3d723eULL, 0x020fe400020006ffULL, 0x000000ff3b4b7812ULL, 0x000fe200078ec0ffULL,
0x000000381014723cULL, 0x000b620000001814ULL, 0x00000018ff4a7819ULL, 0x000fc4000001163bULL,
0x0000ffff3b4c7812ULL, 0x000fe200078ec0ffULL, 0x00000010493b7824ULL, 0x000fe200078e0266ULL,
0x00005410573c7816ULL, 0x000fe4000000003eULL, 0x00005410563d7816ULL, 0x000fe4000000003dULL,
0x00000065ff44723eULL, 0x000fe200020006ffULL, 0x000000003b38783bULL, 0x020fe20000004200ULL,
0x00000008ff657819ULL, 0x000fe20000011647ULL, 0x000000100c477824ULL, 0x000fe200078e023fULL,
0x00000008ff647819ULL, 0x000fe20000011655ULL, 0x0000003c103c723cULL, 0x000b620000001824ULL,
0x0000005bff5b723eULL, 0x000fc400020006ffULL, 0x00a000004724783bULL, 0x020e620000000200ULL,
0x00000059ff59723eULL, 0x000fe400020006ffULL, 0x00000065ff65723eULL, 0x000fe400020006ffULL,
0x00000064ff64723eULL, 0x000fe400020006ffULL, 0x000000ff50697812ULL, 0x000fe400078ec0ffULL,
0x000000ff516e7812ULL, 0x000fe400078ec0ffULL, 0x0000541065507816ULL, 0x000fc4000000005bULL,
0x0000541064517816ULL, 0x000fe40000000059ULL, 0x0000004dff4d723eULL, 0x000fe400020006ffULL,
0x00000069ff69723eULL, 0x000fe400020006ffULL, 0x0000004bff4b723eULL, 0x000fe200020006ffULL,
0x000000501028723cULL, 0x000b620000001828ULL, 0x0000006eff6e723eULL, 0x000fe400020006ffULL,
0x00000008ff487819ULL, 0x000fc40000011648ULL, 0x00000042ff42723eULL, 0x000fe400020006ffULL,
0x00000008ff507819ULL, 0x020fe4000001164cULL, 0x000054104d4c7816ULL, 0x000fe40000000069ULL,
0x000054104b4d7816ULL, 0x000fe4000000006eULL, 0x000000ff434b7812ULL, 0x000fe400078ec0ffULL,
0x0000004aff4a723eULL, 0x000fc400020006ffULL, 0x00000048ff48723eULL, 0x000fe200020006ffULL,
0x0000004c102c723cULL, 0x000f62000000182cULL, 0x00000050ff43723eULL, 0x000fe200020006ffULL,
0x0000000424248232ULL, 0x082fe20000000000ULL, 0x00000008ff377819ULL, 0x000fe20000011637ULL,
0x0000000426268232ULL, 0x000fe20000000000ULL, 0x00000008ff417819ULL, 0x000fe20000011641ULL,
0x0000000225258232ULL, 0x080fe20000000000ULL, 0x000000ff0e0e7812ULL, 0x000fe200078ec0ffULL,
0x0000000227278232ULL, 0x000fe20000000000ULL, 0x000000ff0f0f7812ULL, 0x000fc400078ec0ffULL,
0x0000541048427816ULL, 0x000fe40000000042ULL, 0x0000541043437816ULL, 0x000fe4000000004aULL,
0x00000072ff36723eULL, 0x000fe400020006ffULL, 0x00000037ff37723eULL, 0x000fe400020006ffULL,
0x0000006fff45723eULL, 0x000fe200020006ffULL, 0x000000421010723cULL, 0x000b620000001830ULL,
0x00000041ff41723eULL, 0x000fc400020006ffULL, 0x0000000eff0e723eULL, 0x000fe400020006ffULL,
0x0000000fff0f723eULL, 0x000fe400020006ffULL, 0x000000ff40407812ULL, 0x000fe400078ec0ffULL,
0x00000008ff5e7819ULL, 0x000fe4000001165eULL, 0x00000008ff5c7819ULL, 0x000fe4000001165cULL,
0x0000541037367816ULL, 0x000fc40000000036ULL, 0x0000541041377816ULL, 0x000fe40000000045ULL,
0x0000541044447816ULL, 0x000fe4000000000eULL, 0x000054104e457816ULL, 0x000fe4000000000fULL,
0x00000052ff52723eULL, 0x000fe200020006ffULL, 0x000000362418723cULL, 0x000f620000001818ULL,
0x00000054ff54723eULL, 0x000fe400020006ffULL, 0x00000046ff46723eULL, 0x000fc400020006ffULL,
0x0000004bff4b723eULL, 0x000fe400020006ffULL, 0x00000040ff31723eULL, 0x020fe200020006ffULL,
0x00000044241c723cULL, 0x000f62000000181cULL, 0x0000005eff0e723eULL, 0x000fe400020006ffULL,
0x0000005cff0f723eULL, 0x000fe400020006ffULL, 0x00000010ff577819ULL, 0x000fe40000011638ULL,
0x000000ff38637812ULL, 0x000fc400078ec0ffULL, 0x00000018ff5f7819ULL, 0x000fe40000011638ULL,
0x0000ffff38537812ULL, 0x000fe400078ec0ffULL, 0x00000010ff587819ULL, 0x100fe40000011639ULL,
0x000000ff39627812ULL, 0x040fe400078ec0ffULL, 0x00000018ff5d7819ULL, 0x000fe40000011639ULL,
0x0000ffff39557812ULL, 0x000fc400078ec0ffULL, 0x00000010ff397819ULL, 0x100fe4000001163aULL,
0x000000ff3a5a7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff477819ULL, 0x000fe4000001163aULL,
0x00000010ff497819ULL, 0x100fe4000001163bULL, 0x000000ff3b567812ULL, 0x000fe400078ec0ffULL,
0x00000018ff387819ULL, 0x000fc4000001163bULL, 0x0000541052307816ULL, 0x000fe4000000004bULL,
0x000054104f317816ULL, 0x000fe40000000031ULL, 0x000054100e0e7816ULL, 0x000fe40000000054ULL,
0x000054100f0f7816ULL, 0x000fe40000000046ULL, 0x0000ffff3a3a7812ULL, 0x000fe200078ec0ffULL,
0x000000302414723cULL, 0x000f620000001814ULL, 0x0000ffff3b3b7812ULL, 0x000fc400078ec0ffULL,
0x000000ff57577812ULL, 0x000fe400078ec0ffULL, 0x000000ff58587812ULL, 0x000fe400078ec0ffULL,
0x00000008ff537819ULL, 0x000fe20000011653ULL, 0x0000000e2420723cULL, 0x000b620000001820ULL,
0x00000008ff557819ULL, 0x000fe40000011655ULL, 0x000000ff39397812ULL, 0x000fe400078ec0ffULL,
0x000000ff49497812ULL, 0x000fc400078ec0ffULL, 0x00000008ff3a7819ULL, 0x000fe4000001163aULL,
0x00000008ff3b7819ULL, 0x000fe4000001163bULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x0000005dff5d723eULL, 0x000fc400020006ffULL, 0x0000005aff5a723eULL, 0x000fe400020006ffULL,
0x00000057ff0e723eULL, 0x020fe400020006ffULL, 0x00000058ff31723eULL, 0x000fe400020006ffULL,
0x00000056ff5b723eULL, 0x000fe400020006ffULL, 0x00000053ff5c723eULL, 0x000fe400020006ffULL,
0x00000055ff55723eULL, 0x000fc400020006ffULL, 0x00000039ff39723eULL, 0x000fe400020006ffULL,
0x00000049ff49723eULL, 0x000fe400020006ffULL, 0x00000047ff47723eULL, 0x000fe400020006ffULL,
0x00000038ff38723eULL, 0x000fe400020006ffULL, 0x0000003aff3a723eULL, 0x000fe400020006ffULL,
0x0000003bff3b723eULL, 0x000fc400020006ffULL, 0x00005410630e7816ULL, 0x000fe4000000000eULL,
0x00005410620f7816ULL, 0x000fe40000000031ULL, 0x000054105c5c7816ULL, 0x000fe4000000005fULL,
0x00005410555d7816ULL, 0x000fe4000000005dULL, 0x000054105a5a7816ULL, 0x000fe20000000039ULL,
0x0000000e243c723cULL, 0x000b62000000183cULL, 0x000054105b5b7816ULL, 0x000fc40000000049ULL,
0x000054103a3a7816ULL, 0x000fe40000000047ULL, 0x000054103b3b7816ULL, 0x000fe40000000038ULL,
0x0000f698790e7811ULL, 0x020fe200078e18ffULL, 0x0000005c2428723cULL, 0x040f700000001828ULL,
0x0000005a242c723cULL, 0x040f70000000182cULL, 0x0000003a2424723cULL, 0x000b6e0000001810ULL,
0x0000f6c808107811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x0000000010107f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000000eff7f8cULL, 0x0005e4000c80043fULL, 0x00000000000e7805ULL, 0x004fc40000015200ULL,
0x0000040006137984ULL, 0x000ea40000000800ULL, 0x8000000013ff7812ULL, 0x006fc40007804811ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff307224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x000000120e317210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e0fULL, 0x003d09003100780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403100780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011413ULL,
0x0000003112127211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000212127819ULL, 0x000fc80000001213ULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000130307810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040006137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001070f7810ULL, 0x000fc80007ffe0ffULL, 0x0000006c0f00720cULL, 0x000fda0003f06070ULL,
0x0000079000000947ULL, 0x000fea0003800000ULL, 0x00000002070f7810ULL, 0x000fe20007ffe0ffULL,
0x0000590067067a24ULL, 0x010fe200078e02ffULL, 0x000001000d0d7810ULL, 0x000fe40007ffe0ffULL,
0x0000006c0f00720cULL, 0x000fe20003f06070ULL, 0x00000080060e7824ULL, 0x000fe200078e00ffULL,
0x000000600d067812ULL, 0x000fe200078ec0ffULL, 0x00000080ff0f7424ULL, 0x000fc800078e00ffULL,
0x0000000173327824ULL, 0x000fe400078e0206ULL, 0x000062000e0e7625ULL, 0x000fc800078e000fULL,
0x000003e000008947ULL, 0x000fea0003800000ULL, 0x0000000d6b067217ULL, 0x000fe20007800000ULL,
0x0000001000107824ULL, 0x000fc800078e00ffULL, 0x0000000106067824ULL, 0x000fe200078e0a0dULL,
0x00000010100d7812ULL, 0x000fe400078ec0ffULL, 0x00000003ff107819ULL, 0x000fe40000011603ULL,
0x000000060d067217ULL, 0x000fe40007800000ULL, 0x0000000810127810ULL, 0x040fe40007ffe0ffULL,
0x0000000410117810ULL, 0x000fe20007ffe0ffULL, 0x0000000106067824ULL, 0x100fe200078e0a0dULL,
0x0000000c10137810ULL, 0x000fe20007ffe0ffULL, 0x0000000112337824ULL, 0x000fc600078e020dULL,
0x000000061000720cULL, 0x0c0fe20003f86070ULL, 0x0000000110107824ULL, 0x100fe200078e020dULL,
0x000000061100720cULL, 0x0c0fe20003f66070ULL, 0x0000000111117824ULL, 0x000fe200078e020dULL,
0x000000061200720cULL, 0x080fe20003f46070ULL, 0x0000000110127824ULL, 0x040fe200078e0232ULL,
0x000000061300720cULL, 0x000fe20003f06070ULL, 0x0000000110067824ULL, 0x140fe400078e0203ULL,
0x0000000810397824ULL, 0x000fe400078e00ffULL, 0x0000000133107824ULL, 0x000fc400078e0203ULL,
0x0000000833417824ULL, 0x000fe200078e00ffULL, 0xfffffff839397812ULL, 0x000fe200078ee206ULL,
0x0000000113367824ULL, 0x000fe400078e020dULL, 0x0000000111307824ULL, 0x000fe200078e0232ULL,
0xfffffff841417812ULL, 0x000fe200078ee210ULL, 0x0000008012127825ULL, 0x000fc800078e00ffULL,
0x00000001110d7824ULL, 0x040fe400078e0203ULL, 0x0000000811387824ULL, 0x000fe400078e00ffULL,
0x0000008030307825ULL, 0x000fc600078e00ffULL, 0xfffffff8383b7812ULL, 0x000fe200078ee20dULL,
0x0000000133107824ULL, 0x100fe200078e0232ULL, 0x0000006012337212ULL, 0x080fe200078efcffULL,
0x0000000136327824ULL, 0x000fe200078e0232ULL, 0x00000060300d7212ULL, 0x080fe200078efcffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000000330e127210ULL, 0x040fe40007fbe0ffULL,
0x0000000d0e307210ULL, 0x000fe20007fde0ffULL, 0x0000008032327825ULL, 0x000fe200078e00ffULL,
0x0000006010377212ULL, 0x000fc600078efcffULL, 0x0000000136067824ULL, 0x000fe200078e0203ULL,
0x00000060320d7212ULL, 0x000fe200078efcffULL, 0x0000000836437824ULL, 0x000fe400078e00ffULL,
0x000000010f137824ULL, 0x040fe200028e0613ULL, 0x000000370e107210ULL, 0x040fe20007fbe0ffULL,
0x000000010f317824ULL, 0x000fe200030e0631ULL, 0xfffffff843437812ULL, 0x000fe200078ee206ULL,
0x0000001039397824ULL, 0x100fe200078e0266ULL, 0x0000000d0e0e7210ULL, 0x000fe20007fde0ffULL,
0x000000103b3b7824ULL, 0x000fc400078e0266ULL, 0x0000001041417824ULL, 0x100fe200078e0266ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012397faeULL, 0x0003e2000e101c48ULL,
0x000000010f117824ULL, 0x000fe400028e0611ULL, 0x0000001043437824ULL, 0x000fe200078e0266ULL,
0x00000000303b7faeULL, 0x0003e2000d901c48ULL, 0x000000010f0f7824ULL, 0x000fc600030e0633ULL,
0x0000000010417faeULL, 0x0003e8000d101c48ULL, 0x000000000e437faeULL, 0x0003e2000c101c48ULL,
0x0000031000007947ULL, 0x000fea0003800000ULL, 0x0000001000067824ULL, 0x000fca00078e00ffULL,
0x0000001006067812ULL, 0x000fc800078ec0ffULL, 0x0000000603067211ULL, 0x000fc800078fe8ffULL,
0x0000000406137810ULL, 0x040fe20007ffe0ffULL, 0x00000001060d7824ULL, 0x140fe200078e0203ULL,
0x0000000806317810ULL, 0x040fe20007ffe0ffULL, 0x0000000806127824ULL, 0x040fe200078e00ffULL,
0x0000000c06337810ULL, 0x040fe20007ffe0ffULL, 0x0000000106107824ULL, 0x000fe400078e0232ULL,
0x0000000113067824ULL, 0x000fe200078e0203ULL, 0xfffffff812377812ULL, 0x000fe200078ee20dULL,
0x0000008010107825ULL, 0x000fc800078e00ffULL, 0x0000000113127824ULL, 0x140fe200078e0232ULL,
0x00000060100d7212ULL, 0x000fe200078efcffULL, 0x0000000813397824ULL, 0x000fe400078e00ffULL,
0x0000000131307824ULL, 0x040fe200078e0232ULL, 0x0000000d0e107210ULL, 0x000fe20007f1e0ffULL,
0x0000000131137824ULL, 0x100fe200078e0203ULL, 0xfffffff8390d7812ULL, 0x000fe200078ee206ULL,
0x0000000831367824ULL, 0x000fe400078e00ffULL, 0x0000000133317824ULL, 0x000fc400078e0203ULL,
0x0000000833387824ULL, 0x040fe200078e00ffULL, 0xfffffff836437812ULL, 0x000fe200078ee213ULL,
0x0000000133327824ULL, 0x000fe400078e0232ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0xfffffff838457812ULL, 0x000fc600078ee231ULL, 0x0000008030307825ULL, 0x000fe200078e00ffULL,
0x0000006012397212ULL, 0x000fc600078efcffULL, 0x0000008032327825ULL, 0x000fc800078e00ffULL,
0x00000010373b7824ULL, 0x100fe200078e0266ULL, 0x0000006030377212ULL, 0x080fe200078efcffULL,
0x000000100d417824ULL, 0x100fe200078e0266ULL, 0x00000060320d7212ULL, 0x000fe200078efcffULL,
0x000000010f117824ULL, 0x000fe200000e0611ULL, 0x000000390e127210ULL, 0x040fe20007f1e0ffULL,
0x0000001043437824ULL, 0x100fe200078e0266ULL, 0x000000370e307210ULL, 0x040fe20007f5e0ffULL,
0x0000001045457824ULL, 0x000fe200078e0266ULL, 0x0000000d0e0e7210ULL, 0x000fe20007f7e0ffULL,
0x000000010f137824ULL, 0x040fe200000e0613ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000103b7faeULL, 0x0003e2000b901c48ULL, 0x000000010f317824ULL, 0x000fc400010e0631ULL,
0x000000010f0f7824ULL, 0x000fe200018e0633ULL, 0x0000000012417faeULL, 0x0003e8000b901c48ULL,
0x0000000030437faeULL, 0x0003e8000b901c48ULL, 0x000000000e457faeULL, 0x0003e4000b901c48ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000001008067824ULL, 0x000fc400078e00ffULL,
0x00000008000d7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe40008000a04ULL,
0x0000001006067812ULL, 0x000fe400078ee2ffULL, 0x000000080d0d7812ULL, 0x000fc600078ec0ffULL,
0x0000002079067824ULL, 0x000fc800078e0206ULL, 0x000000010d067824ULL, 0x000fe200078e0206ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a8007a107f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f66800060e7f8cULL, 0x000662000c80043fULL, 0x000000ffff0d7224ULL, 0x004fc600078e0011ULL,
0x0000000000107805ULL, 0x000fc80000015200ULL, 0x00f66c0006137984ULL, 0x000ea40000000800ULL,
0x8000000013ff7812ULL, 0x006fe4000780480fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff307224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x0000001210317210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e11ULL,
0x003d09003100780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403100780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff127819ULL, 0x000fc80000011413ULL, 0x0000003112127211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0613ULL, 0x0000000212127819ULL, 0x000fc80000001213ULL,
0x000000120000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000130307810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f66c0006137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe4000780480fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000180790f7811ULL, 0x000fc800078e38ffULL,
0x0000000f680f7210ULL, 0x000fca0007ffe060ULL, 0x00f000000f067984ULL, 0x008e680000000800ULL,
0x00f200000f117984ULL, 0x0004e20000000800ULL, 0x0000000b0600720bULL, 0x002fe20003f1d000ULL,
0x00008d227f007947ULL, 0x000fd8000b800000ULL, 0x00000000000e7806ULL, 0x004fc800000e0100ULL,
0x0000ffff0e317812ULL, 0x000fe2000780c0ffULL, 0x000004b000007945ULL, 0x000fe20003800000ULL,
0x00000001ff307424ULL, 0x000fe400078e00ffULL, 0x000000ffff107224ULL, 0x000fd200078e000bULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x00000003790f7810ULL, 0x000fe40007ffe0ffULL,
0x0000000b0600720bULL, 0x000fe40003f54000ULL, 0x000000000f00720cULL, 0x000fe20003f05270ULL,
0x00008cc27f007947ULL, 0x000fd4000b800000ULL, 0x0000000000107806ULL, 0x000fc400010e0100ULL,
0x00000080000f8824ULL, 0x000fe200078e0260ULL, 0x0000000b060e8209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe40003800000ULL, 0x0000000168138824ULL, 0x000fe200078e020fULL,
0x00009910100f7816ULL, 0x000fc800000000ffULL, 0x00f4000e13008388ULL, 0x0003e20000000800ULL,
0x000000ff0f00720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000000b060e7209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff10ff7812ULL, 0x000fc6000780c0ffULL, 0x0000000b0e0e7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b0e0e7820ULL, 0x000fc80000410000ULL, 0x0000000e00337308ULL, 0x000e640000000800ULL,
0x000000330a0a7220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff0e7819ULL, 0x000fe20000011603ULL, 0x00008be27f007947ULL, 0x000fea000b800000ULL,
0x00001f0e33127589ULL, 0x0002a400000e0000ULL, 0x0000001214147220ULL, 0x084fe20000410000ULL,
0x0000001215157220ULL, 0x080fe20000410000ULL, 0x0000001218187220ULL, 0x080fe20000410000ULL,
0x0000001219197220ULL, 0x080fe20000410000ULL, 0x000000121c1c7220ULL, 0x080fe20000410000ULL,
0x000000121d1d7220ULL, 0x080fe20000410000ULL, 0x0000001220207220ULL, 0x080fe20000410000ULL,
0x0000001221217220ULL, 0x080fe20000410000ULL, 0x000000123c3c7220ULL, 0x080fe20000410000ULL,
0x000000123d3d7220ULL, 0x080fe20000410000ULL, 0x0000001228287220ULL, 0x080fe20000410000ULL,
0x0000001229297220ULL, 0x080fe20000410000ULL, 0x000000122c2c7220ULL, 0x080fe20000410000ULL,
0x000000122d2d7220ULL, 0x080fe20000410000ULL, 0x0000001224247220ULL, 0x080fe20000410000ULL,
0x0000001225257220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0010ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008030e7811ULL, 0x002fe200078ff0ffULL, 0x00008ac27f007947ULL, 0x000fea000b800000ULL,
0x00001f0e33127589ULL, 0x0002a400000e0000ULL, 0x0000001216167220ULL, 0x084fe20000410000ULL,
0x0000001217177220ULL, 0x080fe20000410000ULL, 0x000000121a1a7220ULL, 0x080fe20000410000ULL,
0x000000121b1b7220ULL, 0x080fe20000410000ULL, 0x000000121e1e7220ULL, 0x080fe20000410000ULL,
0x000000121f1f7220ULL, 0x080fe20000410000ULL, 0x0000001222227220ULL, 0x080fe20000410000ULL,
0x0000001223237220ULL, 0x080fe20000410000ULL, 0x000000123e3e7220ULL, 0x080fe20000410000ULL,
0x000000123f3f7220ULL, 0x080fe20000410000ULL, 0x000000122a2a7220ULL, 0x080fe20000410000ULL,
0x000000122b2b7220ULL, 0x080fe20000410000ULL, 0x000000122e2e7220ULL, 0x080fe20000410000ULL,
0x000000122f2f7220ULL, 0x080fe20000410000ULL, 0x0000001226267220ULL, 0x080fe20000410000ULL,
0x0000001227277220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff31ff7812ULL, 0x000fe20007806010ULL, 0x00000001ff307424ULL, 0x000fe200078e00ffULL,
0x0000000b06107209ULL, 0x000fd60007810000ULL, 0x8000001006060221ULL, 0x000fe20000010000ULL,
0x00007610ff300816ULL, 0x000fc60000000030ULL, 0x3fb8aa3b06060820ULL, 0x000fc80000410000ULL,
0x0000000600050308ULL, 0x000e640000000800ULL, 0x0000000511110220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000a110a7221ULL, 0x008fc20000010000ULL,
0x00000000000e7805ULL, 0x000fcc0000015200ULL, 0x00f6b4007a0b7984ULL, 0x000e620000000800ULL,
0x0000000400067824ULL, 0x000fca00078e00ffULL, 0x0000000406117812ULL, 0x000fe200078ec0ffULL,
0x000000ffff067224ULL, 0x000fc600078e00ffULL, 0x0000000211117810ULL, 0x000fe40007ffe0ffULL,
0x800000000bff7812ULL, 0x002fe20007804835ULL, 0x000000047c0b7824ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001f000007945ULL, 0x000fe20003800000ULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000100600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x000000120e317210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e0fULL, 0x003d09003100780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403100780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011413ULL,
0x0000003112127211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000212127819ULL, 0x000fc80000001213ULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000106067810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00f6b4007a137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe40007804835ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991030067816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff0600720cULL, 0x000fda0003f05270ULL,
0x0000012000000947ULL, 0x000fea0003800000ULL, 0x00000005ff02723eULL, 0x000fe400000000ffULL,
0x00000002ff317819ULL, 0x000fe40000011603ULL, 0x0000541002067816ULL, 0x000fe20000000002ULL,
0x000086327f007947ULL, 0x000fea000b800000ULL, 0x00001f3106047589ULL, 0x0002a400000e0000ULL,
0x00000008310e7810ULL, 0x000fe20007ffe0ffULL, 0x000086627f007947ULL, 0x000fea000b800000ULL,
0x00001f0e06027589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000010310e7810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff0f7224ULL, 0x000fe200078e0006ULL,
0x0000a1a000137802ULL, 0x000fc40000000f00ULL, 0x00008af000007944ULL, 0x016fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000018310e7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff0f7224ULL, 0x000fe200078e0006ULL, 0x0000a1f000137802ULL, 0x000fc40000000f00ULL,
0x00008aa000007944ULL, 0x016fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000703347812ULL, 0x000fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000003795b7810ULL, 0x000fc40007ffe0ffULL, 0x0000000834067812ULL, 0x00afe400078ef803ULL,
0x0000000803137812ULL, 0x000fe200078ec0ffULL, 0x000008005b5b7824ULL, 0x000fe400078e00ffULL,
0x0000000806067824ULL, 0x000fca00078e00ffULL, 0xfffffff806067812ULL, 0x000fca00078ee261ULL,
0x00000010060f7824ULL, 0x000fc400078e025bULL, 0x0000000b03127211ULL, 0x004fe200078fe0ffULL,
0x000000100c5b7824ULL, 0x000fe200078e025bULL, 0x00000034130e7212ULL, 0x000fe400078efcffULL,
0x0000001103117211ULL, 0x000fe400078fe0ffULL, 0x0000001013137812ULL, 0x000fe200078efe34ULL,
0x000000010e067824ULL, 0x040fe400078e0212ULL, 0x000000080e0b7824ULL, 0x000fca00078e00ffULL,
0xfffffff80b067812ULL, 0x000fe200078ee206ULL, 0x000000010e0b7824ULL, 0x040fe400078e0211ULL,
0x000000080e0e7824ULL, 0x000fe400078e00ffULL, 0x0000001006067824ULL, 0x000fc600078e0209ULL,
0xfffffff80e0e7812ULL, 0x000fe200078ee20bULL, 0x00000001130b7824ULL, 0x040fe200078e0212ULL,
0x000000000630783bULL, 0x0002a20000004200ULL, 0x0000000813127824ULL, 0x000fe400078e00ffULL,
0x000000100e0e7824ULL, 0x000fc600078e0209ULL, 0xfffffff812127812ULL, 0x000fe200078ee20bULL,
0x0000000113067824ULL, 0x042fe200078e0211ULL, 0x000000000e48783bULL, 0x0002e20000004200ULL,
0x0000000813137824ULL, 0x000fe400078e00ffULL, 0x0000001012127824ULL, 0x000fc600078e0209ULL,
0xfffffff813067812ULL, 0x000fe400078ee206ULL, 0x000000001234783bULL, 0x000ee60000004200ULL,
0x0000001006387824ULL, 0x000fcc00078e0209ULL, 0x000000003838783bULL, 0x000fe20000004200ULL,
0x00000010ff0b7819ULL, 0x104fe40000011630ULL, 0x000000ff300c7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff777819ULL, 0x000fe40000011630ULL, 0x0000ffff30067812ULL, 0x000fe400078ec0ffULL,
0x00000010ff097819ULL, 0x000fe40000011631ULL, 0x000000ff31117812ULL, 0x000fc400078ec0ffULL,
0x00000018ff767819ULL, 0x000fe40000011631ULL, 0x0000ffff310e7812ULL, 0x002fe400078ec0ffULL,
0x00000010ff6e7819ULL, 0x100fe40000011632ULL, 0x000000ff32727812ULL, 0x040fe400078ec0ffULL,
0x00000018ff657819ULL, 0x000fe40000011632ULL, 0x0000ffff32557812ULL, 0x000fc400078ec0ffULL,
0x00000010ff707819ULL, 0x100fe40000011633ULL, 0x000000ff33717812ULL, 0x040fe400078ec0ffULL,
0x00000018ff647819ULL, 0x000fe40000011633ULL, 0x0000ffff33687812ULL, 0x000fe400078ec0ffULL,
0x009000000f30783bULL, 0x000e620000000200ULL, 0x000000ff0b0b7812ULL, 0x000fe400078ec0ffULL,
0x000000ff09097812ULL, 0x000fc400078ec0ffULL, 0x00000010ff5c7819ULL, 0x108fe40000011648ULL,
0x000000ff48607812ULL, 0x040fe400078ec0ffULL, 0x00000018ff5a7819ULL, 0x000fe40000011648ULL,
0x0000ffff48587812ULL, 0x000fe400078ec0ffULL, 0x00000010ff487819ULL, 0x000fe40000011634ULL,
0x000000ff34467812ULL, 0x000fc400078ec0ffULL, 0x00000018ff6f7819ULL, 0x000fe40000011634ULL,
0x0000ffff34427812ULL, 0x000fe400078ec0ffULL, 0x00000010ff437819ULL, 0x100fe40000011635ULL,
0x000000ff35757812ULL, 0x040fe400078ec0ffULL, 0x00000018ff637819ULL, 0x000fe40000011635ULL,
0x0000ffff35457812ULL, 0x000fc400078ec0ffULL, 0x0000000cff34723eULL, 0x000fe400020006ffULL,
0x00000011ff35723eULL, 0x000fe400020006ffULL, 0x0000000bff0b723eULL, 0x000fe400020006ffULL,
0x00000009ff09723eULL, 0x000fe400020006ffULL, 0x0000541034347816ULL, 0x000fe4000000000bULL,
0x0000541035357816ULL, 0x000fe20000000009ULL, 0x0000000430308232ULL, 0x082fe20000000000ULL,
0x00000010ff5e7819ULL, 0x100fe20000011649ULL, 0x0000000432328232ULL, 0x000fe20000000000ULL,
0x000000ff495f7812ULL, 0x040fe200078ec0ffULL, 0x0000000231318232ULL, 0x080fe20000000000ULL,
0x00000018ff577819ULL, 0x000fe20000011649ULL, 0x0000000233338232ULL, 0x000fe20000000000ULL,
0x0000ffff49597812ULL, 0x000fc400078ec0ffULL, 0x00000010ff407819ULL, 0x100fe40000011636ULL,
0x000000ff365d7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff4f7819ULL, 0x000fe40000011636ULL,
0x0000ffff360f7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff417819ULL, 0x000fe40000011637ULL,
0x000000ff37567812ULL, 0x000fc400078ec0ffULL, 0x00000018ff497819ULL, 0x000fe40000011637ULL,
0x0000ffff37127812ULL, 0x000fe400078ec0ffULL, 0x000000343034723cULL, 0x000b620000001814ULL,
0x00000008ff787819ULL, 0x000fe40000011606ULL, 0x00000077ff77723eULL, 0x000fe400020006ffULL,
0x00000076ff76723eULL, 0x000fe400020006ffULL, 0x00000008ff157819ULL, 0x020fc4000001160eULL,
0x00000078ff78723eULL, 0x000fe400020006ffULL, 0x00000015ff15723eULL, 0x000fe400020006ffULL,
0x0000541078147816ULL, 0x000fe40000000077ULL, 0x0000541015157816ULL, 0x000fe40000000076ULL,
0x00000010ff117819ULL, 0x000fe40000011638ULL, 0x000000ff38527812ULL, 0x000fc400078ec0ffULL,
0x00000018ff477819ULL, 0x000fe20000011638ULL, 0x000000143018723cULL, 0x000be20000001818ULL,
0x0000ffff380b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff6e6e7812ULL, 0x000fe400078ec0ffULL,
0x000000ff70707812ULL, 0x000fe400078ec0ffULL, 0x00000010ff617819ULL, 0x000fe4000001163aULL,
0x000000ff3a387812ULL, 0x000fc400078ec0ffULL, 0x00000018ff067819ULL, 0x000fe4000001163aULL,
0x0000ffff3a667812ULL, 0x000fe400078ec0ffULL, 0x00000008ff3a7819ULL, 0x000fe40000011655ULL,
0x00000008ff687819ULL, 0x000fe40000011668ULL, 0x00000072ff72723eULL, 0x000fe400020006ffULL,
0x00000071ff71723eULL, 0x000fc400020006ffULL, 0x0000006eff14723eULL, 0x020fe400020006ffULL,
0x00000070ff15723eULL, 0x000fe400020006ffULL, 0x00000010ff097819ULL, 0x100fe4000001163bULL,
0x000000ff3b0e7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff697819ULL, 0x000fe4000001163bULL,
0x0000ffff3b627812ULL, 0x000fc400078ec0ffULL, 0x00000065ff65723eULL, 0x000fe400020006ffULL,
0x00000064ff64723eULL, 0x000fe400020006ffULL, 0x0000003aff3a723eULL, 0x000fe400020006ffULL,
0x00000068ff3b723eULL, 0x000fe400020006ffULL, 0x0000541072147816ULL, 0x000fe40000000014ULL,
0x0000541071157816ULL, 0x000fc40000000015ULL, 0x000054103a3a7816ULL, 0x000fe40000000065ULL,
0x000054103b3b7816ULL, 0x000fe40000000064ULL, 0x000000ff5c5c7812ULL, 0x000fe200078ec0ffULL,
0x00000014301c723cULL, 0x000be2000000181cULL, 0x000000ff5e5e7812ULL, 0x000fe200078ec0ffULL,
0x009000005b14783bULL, 0x020e620000000200ULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x0000005fff5f723eULL, 0x000fc400020006ffULL, 0x00000008ff587819ULL, 0x000fe20000011658ULL,
0x0000003a3020723cULL, 0x000be20000001820ULL, 0x00000008ff597819ULL, 0x000fe40000011659ULL,
0x0000005aff5a723eULL, 0x000fe400020006ffULL, 0x00000057ff57723eULL, 0x000fe400020006ffULL,
0x0000005cff3a723eULL, 0x020fe400020006ffULL, 0x0000005eff3b723eULL, 0x000fc400020006ffULL,
0x00005410603a7816ULL, 0x000fe4000000003aULL, 0x000054105f3b7816ULL, 0x000fe4000000003bULL,
0x00000010ff537819ULL, 0x100fe4000001164aULL, 0x000000ff4a507812ULL, 0x000fe400078ec0ffULL,
0x00000018ff4c7819ULL, 0x000fe2000001164aULL, 0x0000003a303c723cULL, 0x000be2000000183cULL,
0x00000010ff547819ULL, 0x000fc4000001164bULL, 0x000000ff4b517812ULL, 0x040fe400078ec0ffULL,
0x00000018ff4d7819ULL, 0x000fe4000001164bULL, 0x00000058ff3a723eULL, 0x020fe400020006ffULL,
0x00000059ff3b723eULL, 0x000fe400020006ffULL, 0x0000ffff4a4a7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff4b4b7812ULL, 0x000fe200078ec0ffULL, 0x0000000414148232ULL, 0x082fe20000000000ULL,
0x000054103a3a7816ULL, 0x000fe2000000005aULL, 0x0000000416168232ULL, 0x000fe20000000000ULL,
0x000054103b3b7816ULL, 0x000fe20000000057ULL, 0x0000000215158232ULL, 0x080fe20000000000ULL,
0x000000ff53537812ULL, 0x000fe200078ec0ffULL, 0x0000000217178232ULL, 0x000fe20000000000ULL,
0x000000ff54547812ULL, 0x000fc400078ec0ffULL, 0x00000008ff4a7819ULL, 0x000fe2000001164aULL,
0x0000003a3028723cULL, 0x000f620000001828ULL, 0x00000008ff4b7819ULL, 0x000fe4000001164bULL,
0x00000050ff50723eULL, 0x000fe400020006ffULL, 0x00000051ff51723eULL, 0x000fe400020006ffULL,
0x00000053ff53723eULL, 0x000fe400020006ffULL, 0x00000054ff54723eULL, 0x000fc400020006ffULL,
0x0000004cff4c723eULL, 0x000fe400020006ffULL, 0x0000004dff4d723eULL, 0x000fe400020006ffULL,
0x0000004aff4a723eULL, 0x000fe400020006ffULL, 0x0000004bff4b723eULL, 0x000fe400020006ffULL,
0x0000541050507816ULL, 0x000fe40000000053ULL, 0x0000541051517816ULL, 0x000fc40000000054ULL,
0x000000ff48487812ULL, 0x000fe400078ec0ffULL, 0x000054104a4c7816ULL, 0x000fe4000000004cULL,
0x000054104b4d7816ULL, 0x000fe2000000004dULL, 0x00000050302c723cULL, 0x000f62000000182cULL,
0x00000008ff0f7819ULL, 0x000fe4000001160fULL, 0x0000ffff390c7812ULL, 0x000fe400078ec0ffULL,
0x00000046ff46723eULL, 0x000fc400020006ffULL, 0x00000048ff48723eULL, 0x000fe200020006ffULL,
0x0000004c3030723cULL, 0x000b620000001824ULL, 0x000000ff43437812ULL, 0x000fe400078ec0ffULL,
0x0000004fff4f723eULL, 0x000fe400020006ffULL, 0x0000000fff0f723eULL, 0x000fe400020006ffULL,
0x00000018ff447819ULL, 0x000fe40000011639ULL, 0x00000008ff0b7819ULL, 0x000fc4000001160bULL,
0x00000008ff0c7819ULL, 0x000fe4000001160cULL, 0x00000010ff137819ULL, 0x000fe40000011639ULL,
0x000000ff394e7812ULL, 0x000fe400078ec0ffULL, 0x00000075ff39723eULL, 0x000fe400020006ffULL,
0x00000043ff25723eULL, 0x020fe400020006ffULL, 0x0000541046247816ULL, 0x000fc40000000048ULL,
0x000054100f487816ULL, 0x000fe4000000004fULL, 0x00000047ff47723eULL, 0x000fe400020006ffULL,
0x00000044ff44723eULL, 0x000fe400020006ffULL, 0x0000000bff0b723eULL, 0x000fe400020006ffULL,
0x0000000cff0f723eULL, 0x000fe400020006ffULL, 0x0000541039257816ULL, 0x000fc40000000025ULL,
0x0000000eff39723eULL, 0x000fe400020006ffULL, 0x000054100b0e7816ULL, 0x000fe40000000047ULL,
0x000054100f0f7816ULL, 0x000fe20000000044ULL, 0x000000241434723cULL, 0x000b620000001834ULL,
0x000000ff40407812ULL, 0x000fe400078ec0ffULL, 0x000000ff41417812ULL, 0x000fe400078ec0ffULL,
0x00000008ff427819ULL, 0x000fc40000011642ULL, 0x00000008ff457819ULL, 0x000fe20000011645ULL,
0x0000000e1428723cULL, 0x000b620000001828ULL, 0x00000008ff127819ULL, 0x000fe40000011612ULL,
0x000000ff11117812ULL, 0x000fe400078ec0ffULL, 0x000000ff13137812ULL, 0x000fe400078ec0ffULL,
0x000000ff61617812ULL, 0x000fe400078ec0ffULL, 0x000000ff09097812ULL, 0x000fc400078ec0ffULL,
0x00000008ff667819ULL, 0x000fe40000011666ULL, 0x00000008ff627819ULL, 0x000fe40000011662ULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x00000056ff56723eULL, 0x000fe400020006ffULL,
0x00000040ff24723eULL, 0x020fe400020006ffULL, 0x00000041ff25723eULL, 0x000fc400020006ffULL,
0x0000006fff55723eULL, 0x000fe400020006ffULL, 0x00000063ff5b723eULL, 0x000fe400020006ffULL,
0x00000049ff49723eULL, 0x000fe400020006ffULL, 0x00000052ff52723eULL, 0x000fe400020006ffULL,
0x0000004eff4e723eULL, 0x000fe400020006ffULL, 0x00000042ff5a723eULL, 0x000fc400020006ffULL,
0x00000045ff45723eULL, 0x000fe400020006ffULL, 0x00000012ff12723eULL, 0x000fe400020006ffULL,
0x00000038ff38723eULL, 0x000fe400020006ffULL, 0x00000011ff11723eULL, 0x000fe400020006ffULL,
0x00000013ff27723eULL, 0x000fe400020006ffULL, 0x00000061ff61723eULL, 0x000fc400020006ffULL,
0x00000009ff09723eULL, 0x000fe400020006ffULL, 0x00000006ff0c723eULL, 0x000fe400020006ffULL,
0x00000069ff69723eULL, 0x000fe400020006ffULL, 0x00000066ff66723eULL, 0x000fe400020006ffULL,
0x00000062ff0f723eULL, 0x000fe400020006ffULL, 0x000054105d247816ULL, 0x000fc40000000024ULL,
0x0000541056257816ULL, 0x000fe40000000025ULL, 0x000054105a5a7816ULL, 0x000fe40000000055ULL,
0x00005410455b7816ULL, 0x000fe4000000005bULL, 0x0000541012497816ULL, 0x000fe20000000049ULL,
0x00000024141c723cULL, 0x000b62000000181cULL, 0x0000541052527816ULL, 0x000fe40000000011ULL,
0x000054104e537816ULL, 0x000fc40000000027ULL, 0x0000541038387816ULL, 0x000fe40000000061ULL,
0x0000541039397816ULL, 0x000fe20000000009ULL, 0x0000005a1418723cULL, 0x000b620000001818ULL,
0x00005410660e7816ULL, 0x000fe4000000000cULL, 0x000054100f0f7816ULL, 0x000fe40000000069ULL,
0x0000000408067810ULL, 0x000fc60007ffe0ffULL, 0x000000481420723cULL, 0x000b620000001820ULL,
0x0000f6a806067811ULL, 0x000fce00078e18ffULL, 0x000000521424723cULL, 0x040b70000000183cULL,
0x00000038142c723cULL, 0x040b70000000182cULL, 0x0000000e1414723cULL, 0x000b620000001830ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fda0000008000ULL, 0x00000000060e7f8cULL, 0x0202a2000c80043fULL,
0x0000000107077810ULL, 0x000fc40007ffe0ffULL, 0x0000f6a0790b7811ULL, 0x000fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000000bff7f8cULL, 0x0007e2000c80043fULL,
0x000000ffff097224ULL, 0x004fe200078e000fULL, 0x0000001000001944ULL, 0x000fe20003c00000ULL,
0xffff636000007947ULL, 0x000fea000383ffffULL, 0x000000ff6c00720cULL, 0x000fda0003f05270ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x018000000a007810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x0000b38000047802ULL, 0x000fc40000000f00ULL, 0x0000775000007944ULL, 0x01efea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000a00037308ULL, 0x000e640000001000ULL,
0xbf80000003007423ULL, 0x002fc8000000000aULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fc40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006d00ff037624ULL, 0x000fe400078e00ffULL, 0x00006c00ff027624ULL, 0x000fca00078e00ffULL,
0x0000000802037981ULL, 0x008ee8000c1e9900ULL, 0x0000000000047919ULL, 0x000e680000000000ULL,
0x0000000000077919ULL, 0x000ea20000000000ULL, 0x00000002ff067819ULL, 0x002fe40000011604ULL,
0x0000000807047811ULL, 0x004fe200078ff0ffULL, 0x0000000003057220ULL, 0x008fca0000410000ULL,
0x00001f0605007589ULL, 0x000e6800000e0000ULL, 0x00001f0405047589ULL, 0x000ea200000e0000ULL,
0x0000003400347220ULL, 0x042fe20000410000ULL, 0x0000003500357220ULL, 0x040fe20000410000ULL,
0x0000001800187220ULL, 0x040fe20000410000ULL, 0x0000001900197220ULL, 0x040fe20000410000ULL,
0x0000001c001c7220ULL, 0x040fe20000410000ULL, 0x0000001d001d7220ULL, 0x040fe20000410000ULL,
0x0000002000207220ULL, 0x040fe20000410000ULL, 0x0000002100217220ULL, 0x040fe20000410000ULL,
0x0000002400247220ULL, 0x040fe20000410000ULL, 0x0000002500257220ULL, 0x040fe20000410000ULL,
0x0000002800287220ULL, 0x040fe20000410000ULL, 0x0000002900297220ULL, 0x040fe20000410000ULL,
0x0000002c002c7220ULL, 0x040fe20000410000ULL, 0x0000002d002d7220ULL, 0x040fe20000410000ULL,
0x0000001400147220ULL, 0x040fe20000410000ULL, 0x0000001500157220ULL, 0x000fe20000410000ULL,
0x0000003604367220ULL, 0x044fe20000410000ULL, 0x0000003704377220ULL, 0x040fe20000410000ULL,
0x0000001a041a7220ULL, 0x040fe20000410000ULL, 0x0000001b041b7220ULL, 0x040fe20000410000ULL,
0x0000001e041e7220ULL, 0x040fe20000410000ULL, 0x0000001f041f7220ULL, 0x040fe20000410000ULL,
0x0000002204227220ULL, 0x040fe20000410000ULL, 0x0000002304237220ULL, 0x040fe20000410000ULL,
0x0000002604267220ULL, 0x040fe20000410000ULL, 0x0000002704277220ULL, 0x040fe20000410000ULL,
0x0000002a042a7220ULL, 0x040fe20000410000ULL, 0x0000002b042b7220ULL, 0x040fe20000410000ULL,
0x0000002e042e7220ULL, 0x040fe20000410000ULL, 0x0000002f042f7220ULL, 0x040fe20000410000ULL,
0x0000001604167220ULL, 0x040fe20000410000ULL, 0x0000001704177220ULL, 0x000fc20000410000ULL,
0x0000000000007919ULL, 0x000e620000000000ULL, 0x000000282928723eULL, 0x000fe200000000ffULL,
0x00000020080d7824ULL, 0x004fe200078e00ffULL, 0x0000002c2d2c723eULL, 0x000fe200000000ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000141514723eULL, 0x000fc400000000ffULL,
0x0000001e1f1e723eULL, 0x000fe400000000ffULL, 0x00000022230f723eULL, 0x000fe400000000ffULL,
0x000000262726723eULL, 0x000fe400000000ffULL, 0x000076321e117816ULL, 0x000fe4000000000fULL,
0x0000002e2f2e723eULL, 0x000fe400000000ffULL, 0x000000161717723eULL, 0x000fc400000000ffULL,
0x00000002ff057819ULL, 0x002fe40000011600ULL, 0x0000000200027812ULL, 0x040fe400078ec0ffULL,
0x0000000800077811ULL, 0x008fe200078ff0ffULL, 0x0000000805097824ULL, 0x040fe200078e00ffULL,
0x0000000502047211ULL, 0x040fe200078ff8ffULL, 0x00000008050e7824ULL, 0x000fe200078e00ffULL,
0x0000000702037211ULL, 0x000fe200078ff8ffULL, 0x0000000807107824ULL, 0x000fe200078e00ffULL,
0x0000000204027810ULL, 0x040fe20007ffe0ffULL, 0x0000000805077824ULL, 0x000fe200078e00ffULL,
0x0000000404067810ULL, 0x000fc40007ffe0ffULL, 0xfffffff810107812ULL, 0x000fe200078ee203ULL,
0x000010007c037824ULL, 0x000fe200078e00ffULL, 0xfffffff8090a7812ULL, 0x000fe400078ee202ULL,
0xfffffff807027812ULL, 0x000fe200078ee204ULL, 0x0000080008057824ULL, 0x000fe200078e0203ULL,
0x0000000604077810ULL, 0x000fe20007ffe0ffULL, 0x0000000800047824ULL, 0x000fe200078e00ffULL,
0xfffffff8090c7812ULL, 0x000fe200078ee206ULL, 0x0000001002067824ULL, 0x000fe200078e0205ULL,
0xfffffff80e0e7812ULL, 0x000fe200078ee207ULL, 0x0000001010107824ULL, 0x100fe200078e0205ULL,
0x0000000804077812ULL, 0x000fe200078ec0ffULL, 0x000000100a0a7824ULL, 0x100fe200078e0205ULL,
0x000000343502723eULL, 0x000fe200000000ffULL, 0x000000100c0c7824ULL, 0x000fe200078e0205ULL,
0x000000181904723eULL, 0x000fe200000000ffULL, 0x0000000106067824ULL, 0x000fe200078e0207ULL,
0x000000ff0800720cULL, 0x000fe20003f05270ULL, 0x000000100e0e7824ULL, 0x000fe200078e0205ULL,
0x0000541002127816ULL, 0x040fe20000000004ULL, 0x0000000107107824ULL, 0x040fe200078e0210ULL,
0x0000763202137816ULL, 0x000fe20000000004ULL, 0x00000001070a7824ULL, 0x000fe200078e020aULL,
0x0000001c1d02723eULL, 0x000fe200000000ffULL, 0x00000001070c7824ULL, 0x000fe200078e020cULL,
0x000000202104723eULL, 0x000fe200000000ffULL, 0x0000001206007388ULL, 0x0003e20000000a00ULL,
0x00000001070e7824ULL, 0x000fe200078e020eULL, 0x000000242505723eULL, 0x000fc400000000ffULL,
0x0000763202077816ULL, 0x100fe40000000004ULL, 0x000054102e1c7816ULL, 0x140fe40000000017ULL,
0x000076322e1d7816ULL, 0x000fe40000000017ULL, 0x0000541002067816ULL, 0x002fe40000000004ULL,
0x000000363702723eULL, 0x000fe400000000ffULL, 0x0000001a1b04723eULL, 0x000fe200000000ffULL,
0x000000060a007388ULL, 0x0003e20000000a00ULL, 0x0000002a2b13723eULL, 0x000fc800000000ffULL,
0x00007632260b7816ULL, 0x000fe40000000013ULL, 0x0000541005067816ULL, 0x142fe40000000028ULL,
0x0000763205077816ULL, 0x000fca0000000028ULL, 0x000000060c007388ULL, 0x0003e40000000a00ULL,
0x000054102c067816ULL, 0x142fe40000000014ULL, 0x000076322c077816ULL, 0x000fca0000000014ULL,
0x000000060e007388ULL, 0x0003e40000000a00ULL, 0x0000541002067816ULL, 0x142fe40000000004ULL,
0x0000763202077816ULL, 0x000fe20000000004ULL, 0x000000010d027824ULL, 0x000fc800078e0200ULL,
0x0000000610007388ULL, 0x0003e20000000a00ULL, 0x0000001002027824ULL, 0x000fe200078e0203ULL,
0x000054101e107816ULL, 0x002fca000000000fULL, 0x000400100a007388ULL, 0x0003e40000000a00ULL,
0x00005410260a7816ULL, 0x002fca0000000013ULL, 0x0004000a0c007388ULL, 0x000fe80000000a00ULL,
0x0004001c0e007388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000002047984ULL, 0x000e680000000c00ULL, 0x0004000002147984ULL, 0x000ea80000000c00ULL,
0x0008000002107984ULL, 0x000ee80000000c00ULL, 0x000c000002187984ULL, 0x000ee20000000c00ULL,
0x200000ff07077230ULL, 0x002fc40000000000ULL, 0x200000ff06067230ULL, 0x000fe40000000000ULL,
0x200000ff05057230ULL, 0x000fe40000000000ULL, 0x200000ff04047230ULL, 0x000fe40000000000ULL,
0x200000ff17177230ULL, 0x004fe40000000000ULL, 0x200000ff16167230ULL, 0x000fe40000000000ULL,
0x200000ff15157230ULL, 0x000fc40000000000ULL, 0x200000ff14147230ULL, 0x000fe40000000000ULL,
0x0000001307077230ULL, 0x008fe40000000000ULL, 0x0000001206067230ULL, 0x000fe40000000000ULL,
0x0000001105057230ULL, 0x000fe40000000000ULL, 0x0000001004047230ULL, 0x000fe40000000000ULL,
0x0000001b17177230ULL, 0x000fc40000000000ULL, 0x0000001a16167230ULL, 0x000fe20000000000ULL,
0x0000000402007388ULL, 0x000fe20000000c00ULL, 0x0000001915157230ULL, 0x000fe40000000000ULL,
0x0000001814147230ULL, 0x000fca0000000000ULL, 0x0004001402007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff067819ULL, 0x000fc80000011600ULL, 0x0000007d0600720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000011f7983ULL, 0x000ea20000100800ULL,
0x00000000000479c3ULL, 0x000e620000002700ULL, 0x0000000106027824ULL, 0x000fe200078e0200ULL,
0xffffffff00057882ULL, 0x000fe20000000000ULL, 0x00005900ff1e7624ULL, 0x000fe200078e00ffULL,
0x00005a0000067ab9ULL, 0x000fe20000000800ULL, 0x00005a007b7b7a19ULL, 0x000fe200000006ffULL,
0x0000000605057299ULL, 0x000fe2000800063fULL, 0x0000000702057812ULL, 0x000fe400078ec0ffULL,
0x0000580000067ab9ULL, 0x000fe20000000800ULL, 0x00005a001e1e7a19ULL, 0x000fc400000006ffULL,
0x0ffffff805027812ULL, 0x000fe400078ef800ULL, 0x0000000700077812ULL, 0x000fc600078ec0ffULL,
0x0000001002047824ULL, 0x000fe400078e0203ULL, 0x000000087c077824ULL, 0x000fc600078e0207ULL,
0x0000000004087984ULL, 0x0006a20000000c00ULL, 0x00000006040472a4ULL, 0x002fe2000f8e023fULL,
0x000000101f027824ULL, 0x004fca00078e0206ULL, 0x0000000502067c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff057a19ULL, 0x000fe20000011602ULL, 0x000000041e027c24ULL, 0x000fe4000f8e02ffULL,
0x000000017b067824ULL, 0x000fc800078e0206ULL, 0x0000001e05057224ULL, 0x000fe200078e0206ULL,
0x0000002000067810ULL, 0x000fc80007ffe0ffULL, 0x0000000502057210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x00005c0005047a11ULL, 0x008fc800078040ffULL,
0x00005d0005057a11ULL, 0x000fe400000f440cULL, 0x00000003ff0c7819ULL, 0x000fc60000011606ULL,
0x0000001007047825ULL, 0x000fe200078e0004ULL, 0x0000007d0c00720cULL, 0x000fc80003f06070ULL,
0x0000000804007986ULL, 0x0003f2000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000106047824ULL, 0x142fe200078e020cULL, 0x00000007060d7812ULL, 0x000fe200078ec0ffULL,
0x000000101f0c7824ULL, 0x000fc600078e020cULL, 0x0000000704057812ULL, 0x000fe200078ec0ffULL,
0x000000087c0d7824ULL, 0x000fc600078e020dULL, 0x0ffffff805047812ULL, 0x000fca00078ef806ULL,
0x0000001004077824ULL, 0x000fe200078e0203ULL, 0x000000050c047c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff0c7a19ULL, 0x000fe4000001160cULL, 0x0000000007087984ULL, 0x000e620000000c00ULL,
0x000000017b057824ULL, 0x000fc800078e0204ULL, 0x0000001e0c057224ULL, 0x000fe200078e0205ULL,
0x00000040000c7810ULL, 0x000fc80007ffe0ffULL, 0x0000000502057210ULL, 0x000fe40007f1e0ffULL,
0x00000003ff067819ULL, 0x000fc6000001160cULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x000fc800078040ffULL, 0x00005d0005057a11ULL, 0x000fe400000f440eULL,
0x0000007d0600720cULL, 0x000fc60003f06070ULL, 0x000000100d047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0023ea000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010c047824ULL, 0x102fe200078e0206ULL, 0x0000006000007810ULL, 0x000fe20007ffe0ffULL,
0x000000101f067824ULL, 0x000fe200078e0206ULL, 0x000000070c0d7812ULL, 0x000fe400078ec0ffULL,
0x0000000704057812ULL, 0x000fc600078ec0ffULL, 0x000000087c0d7824ULL, 0x000fe200078e020dULL,
0x0ffffff805047812ULL, 0x000fca00078ef80cULL, 0x0000001004077824ULL, 0x000fe200078e0203ULL,
0x0000000506047c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff067a19ULL, 0x000fe40000011606ULL,
0x0000000007087984ULL, 0x0002a20000000c00ULL, 0x000000017b057824ULL, 0x000fc800078e0204ULL,
0x0000001e06057224ULL, 0x000fe200078e0205ULL, 0x00000003ff067819ULL, 0x000fc80000011600ULL,
0x0000000502057210ULL, 0x000fe20007f1e0ffULL, 0x0000000100077824ULL, 0x002fc800078e0206ULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x00005c0005047a11ULL, 0x000fe400078040ffULL,
0x0000000707077812ULL, 0x000fe400078ec0ffULL, 0x00005d0005057a11ULL, 0x000fe400000f440eULL,
0x0000007d0600720cULL, 0x000fe40003f06070ULL, 0xfffffff8070c7812ULL, 0x000fe200078ef800ULL,
0x000000100d047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ea000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000100c0c7824ULL, 0x000fe200078e0203ULL,
0x0000000700057812ULL, 0x002fe200078ec0ffULL, 0x000000101f067824ULL, 0x000fc800078e0206ULL,
0x000000000c0c7984ULL, 0x000e620000000c00ULL, 0x0000000506037c12ULL, 0x000fe2000f8e30ffULL,
0x000000087c057824ULL, 0x000fe200078e0205ULL, 0x00005a00ff067a19ULL, 0x000fc60000011606ULL,
0x000000017b037824ULL, 0x000fc800078e0203ULL, 0x0000001e06037224ULL, 0x000fca00078e0203ULL,
0x0000000302037210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff047224ULL, 0x000fe200000e06ffULL,
0x00005c0003027a11ULL, 0x000fc800078040ffULL, 0x00005d0003037a11ULL, 0x000fca00000f4404ULL,
0x0000001005027825ULL, 0x000fca00078e0002ULL, 0x0000000c02007986ULL, 0x002fe2000c101d08ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff027819ULL, 0x000fe20000011600ULL,
0xffffffffff667424ULL, 0x000fc600078e00ffULL, 0x0000006d0200720cULL, 0x000fda0003f06070ULL,
0x0000000204078824ULL, 0x000fc800078e00ffULL, 0x0000680007088a24ULL, 0x002fc800078e0202ULL,
0x0000640008088625ULL, 0x000fe200078e0009ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000808668981ULL, 0x000ea2000c1e1900ULL, 0x00006c00ff0a7624ULL, 0x000fe400078e00ffULL,
0x00006d00ff0b7624ULL, 0x000fe200078e00ffULL, 0x00f60000ff067f8cULL, 0x000e68000c80043fULL,
0x000000080a6a7981ULL, 0x000722000c1e9900ULL, 0x000001ff0c00780cULL, 0x000fe20003f04070ULL,
0x0000008072727824ULL, 0x000fc400078e00ffULL, 0x000000807b6e7824ULL, 0x000fe400078e00ffULL,
0x0000004000787824ULL, 0x000fe400078e00ffULL, 0x00000080ff0d7424ULL, 0x000fc600078e00ffULL,
0x000000406e187812ULL, 0x000fe200078ef878ULL, 0x00000072660c7224ULL, 0x004fc800078e02ffULL,
0x000062000c087625ULL, 0x000fe200078e000dULL, 0x0000060000000947ULL, 0x000fea0003800000ULL,
0x00000002ff1f7819ULL, 0x00afe40000011603ULL, 0x00001000001c7811ULL, 0x000fe400078e68ffULL,
0x000000081f167810ULL, 0x040fe20007ffe0ffULL, 0x00000001180a7824ULL, 0x040fe200078e021fULL,
0x000000101f207810ULL, 0x040fe40007ffe0ffULL, 0x000000181f227810ULL, 0x040fe20007ffe0ffULL,
0x00000001180c7824ULL, 0x000fe200078e0216ULL, 0x000000201f1b7810ULL, 0x040fe20007ffe0ffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x000000281f1d7810ULL, 0x000fc40007ffe0ffULL,
0x000000301f1e7810ULL, 0x000fe20007ffe0ffULL, 0x00000001180e7824ULL, 0x000fe200078e0220ULL,
0x000000300a137812ULL, 0x000fe200078ef805ULL, 0x000000800c0c7825ULL, 0x000fc600078e00ffULL,
0x0000001308127210ULL, 0x000fe20007f1e0ffULL, 0x0000000118107824ULL, 0x000fe200078e0222ULL,
0x000000300c157812ULL, 0x000fe200078ef805ULL, 0x000000800e0e7825ULL, 0x000fc600078e00ffULL,
0x0000001508147210ULL, 0x000fe20007f3e0ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000000300e177812ULL, 0x000fc600078ef805ULL, 0x0000000109137824ULL, 0x040fe200000e060bULL,
0x00000030100b7812ULL, 0x000fe200078ef805ULL, 0x00000001180e7824ULL, 0x000fe200078e021bULL,
0x00000017080a7210ULL, 0x040fe20007f1e0ffULL, 0x0000000109157824ULL, 0x000fe200008e060dULL,
0x0000000b080c7210ULL, 0x000fe20007f3e0ffULL, 0x0000000416197824ULL, 0x000fe200078e00ffULL,
0x0000000303107211ULL, 0x000fe200078fe8ffULL, 0x00000001090b7824ULL, 0x000fe200000e060fULL,
0x000000786b177217ULL, 0x000fe20007800000ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x00000003101a7812ULL, 0x000fc600078ec0ffULL, 0x00000001090d7824ULL, 0x000fe200008e0611ULL,
0x000000300e117812ULL, 0x000fe200078ef805ULL, 0x0000000117177824ULL, 0x000fe200078e0a78ULL,
0x0ffffffc1a037812ULL, 0x000fe200078ef803ULL, 0x0000000118107824ULL, 0x000fe200078e021dULL,
0x00000011080e7210ULL, 0x000fe40007f5e0ffULL, 0xfffffffc19117812ULL, 0x000fe200078ee21aULL,
0x0000001003037824ULL, 0x100fe200078e021cULL, 0x000000171f00720cULL, 0x080fe20003f06070ULL,
0x00000001090f7824ULL, 0x000fe200010e060fULL, 0x000000171600720cULL, 0x080fe20003f26070ULL,
0x0000001011197824ULL, 0x000fe200078e021cULL, 0x000000381f1f7810ULL, 0x000fe20007ffe0ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000000172000720cULL, 0x000fc40003fa6070ULL,
0x000000172200720cULL, 0x080fe40003f86070ULL, 0x0000003010217812ULL, 0x000fe200078ef805ULL,
0x0000000118107824ULL, 0x000fe200078e021eULL, 0x000000171b00720cULL, 0x000fe20003f66070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012037faeULL, 0x0003e2000c101c48ULL,
0x0000002108167210ULL, 0x000fe20007fde0ffULL, 0x000000041e217824ULL, 0x040fe200078e00ffULL,
0x000000171d00720cULL, 0x0c0fe20003f46070ULL, 0x0000000014197faeULL, 0x0005e2000c901c48ULL,
0x000000171e00720cULL, 0x080fe20003f26070ULL, 0x000000041d1d7824ULL, 0x000fe200078e00ffULL,
0x000000171f00720cULL, 0x000fe20003f06070ULL, 0x0000000109177824ULL, 0x000fc400030e0611ULL,
0x0000008010107825ULL, 0x000fc800078e00ffULL, 0x0000000118127824ULL, 0x002fe400078e021fULL,
0x000000041b197824ULL, 0x004fe200078e00ffULL, 0x00000030101b7812ULL, 0x100fe200078ef805ULL,
0x0000000420037824ULL, 0x000fe400078e00ffULL, 0x0000000422157824ULL, 0x000fe200078e00ffULL,
0x0000001b08107210ULL, 0x000fe20007fde0ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0xfffffffc03037812ULL, 0x100fe400078ee21aULL, 0xfffffffc15157812ULL, 0x100fe200078ee21aULL,
0x000000041f1f7824ULL, 0x000fe200078e00ffULL, 0x0000003012057812ULL, 0x000fe200078ef805ULL,
0x0000000109117824ULL, 0x000fe200030e0611ULL, 0xfffffffc19197812ULL, 0x000fe200078ee21aULL,
0x0000001003037824ULL, 0x000fe200078e021cULL, 0xfffffffc1d1b7812ULL, 0x000fe200078ee21aULL,
0x0000001015157824ULL, 0x000fe200078e021cULL, 0xfffffffc211d7812ULL, 0x000fe200078ee21aULL,
0x0000001019197824ULL, 0x000fe200078e021cULL, 0xfffffffc1f1f7812ULL, 0x000fe200078ee21aULL,
0x000000101b1b7824ULL, 0x100fe200078e021cULL, 0x0000000508087210ULL, 0x000fe20007fde0ffULL,
0x000000101d1d7824ULL, 0x100fe200078e021cULL, 0x000000000a037faeULL, 0x0003e2000e901c48ULL,
0x000000101f1f7824ULL, 0x000fc400078e021cULL, 0x0000000109097824ULL, 0x000fe200030e0613ULL,
0x000000000c157faeULL, 0x0003e8000e101c48ULL, 0x000000000e197faeULL, 0x0003e8000d901c48ULL,
0x00000000161b7faeULL, 0x0003e8000d101c48ULL, 0x00000000101d7faeULL, 0x0003e8000c901c48ULL,
0x00000000081f7faeULL, 0x0003e2000c101c48ULL, 0x0000054000007947ULL, 0x000fea0003800000ULL,
0x00000018030d7811ULL, 0x04afe400078ff0ffULL, 0x00000020030f7811ULL, 0x000fc400078ff0ffULL,
0x00000010030b7811ULL, 0x040fe200078ff0ffULL, 0x0000000118107824ULL, 0x040fe200078e020dULL,
0x00000018030a7211ULL, 0x000fe200078ff0ffULL, 0x000000040d0d7824ULL, 0x000fe200078e00ffULL,
0x00000003030c7211ULL, 0x040fe200078fe8ffULL, 0x00000001181a7824ULL, 0x040fe200078e020fULL,
0x0000000803177811ULL, 0x040fe200078ff0ffULL, 0x00000001180e7824ULL, 0x000fe200078e020bULL,
0x0000002803117811ULL, 0x000fe200078ff0ffULL, 0x000000040b197824ULL, 0x000fe200078e00ffULL,
0x0000003003137811ULL, 0x000fe200078ff0ffULL, 0x000000040f0f7824ULL, 0x000fe200078e00ffULL,
0x0000003803157811ULL, 0x000fe200078ff0ffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x000000030c147812ULL, 0x000fc400078ec0ffULL, 0x0000100000227811ULL, 0x000fe200078e68ffULL,
0x00000001180c7824ULL, 0x000fe200078e0217ULL, 0xfffffffc19127812ULL, 0x100fe200078ee214ULL,
0x0000000417177824ULL, 0x000fe200078e00ffULL, 0x0ffffffc141b7812ULL, 0x000fe200078ef803ULL,
0x00000001181c7824ULL, 0x000fe200078e0211ULL, 0x000000300a197812ULL, 0x000fe200078ef805ULL,
0x0000000411117824ULL, 0x000fe200078e00ffULL, 0xfffffffc17037812ULL, 0x100fe200078ee214ULL,
0x00000001181e7824ULL, 0x040fe400078e0213ULL, 0x00000004131d7824ULL, 0x000fe200078e00ffULL,
0xfffffffc0d137812ULL, 0x100fe200078ee214ULL, 0x0000000118207824ULL, 0x000fe200078e0215ULL,
0xfffffffc11167812ULL, 0x100fe200078ee214ULL, 0x00000004151f7824ULL, 0x000fe200078e00ffULL,
0xfffffffc0f157812ULL, 0x100fe200078ee214ULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0xfffffffc1d177812ULL, 0x000fc400078ee214ULL, 0xfffffffc1f187812ULL, 0x000fe200078ee214ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x0000001908147210ULL, 0x000fc60007f1e0ffULL,
0x00000010131d7824ULL, 0x000fe200078e0222ULL, 0x000000300c137812ULL, 0x100fe200078ef805ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000000300e197812ULL, 0x000fc600078ef805ULL,
0x0000001016217824ULL, 0x100fe200078e0222ULL, 0x0000001308167210ULL, 0x000fe20007f3e0ffULL,
0x0000001018257824ULL, 0x100fe200078e0222ULL, 0x0000001908187210ULL, 0x000fe20007f5e0ffULL,
0x00000010151f7824ULL, 0x100fe200078e0222ULL, 0x0000003010137812ULL, 0x000fe200078ef805ULL,
0x0000001017237824ULL, 0x000fe400078e0222ULL, 0x0000000109157824ULL, 0x040fe200000e060bULL,
0x0000001308107210ULL, 0x000fe20007f1e0ffULL, 0x0000000109177824ULL, 0x000fc400008e060dULL,
0x000000801a0a7825ULL, 0x000fc800078e00ffULL, 0x000000101b2d7824ULL, 0x100fe200078e0222ULL,
0x000000300a2b7812ULL, 0x000fe200078ef805ULL, 0x0000000109197824ULL, 0x000fe400010e060fULL,
0x000000801c0c7825ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000142d7faeULL, 0x0003e6000b901c48ULL, 0x00000010121b7824ULL, 0x000fe200078e0222ULL,
0x000000300c297812ULL, 0x000fe200078ef805ULL, 0x000000801e0e7825ULL, 0x000fc600078e00ffULL,
0x00000029080c7210ULL, 0x000fe20007f3e0ffULL, 0x0000008020127825ULL, 0x000fe200078e00ffULL,
0x000000300e277812ULL, 0x000fc600078ef805ULL, 0x0000000109117824ULL, 0x000fe200000e0611ULL,
0x0000003012057812ULL, 0x000fe200078ef805ULL, 0x0000001003037824ULL, 0x000fe200078e0222ULL,
0x0000002b080a7210ULL, 0x040fe20007f1e0ffULL, 0x00000001090d7824ULL, 0x040fe200008e060dULL,
0x00000027080e7210ULL, 0x040fe40007f5e0ffULL, 0x0000000508087210ULL, 0x000fe20007f7e0ffULL,
0x00000001090b7824ULL, 0x040fe200000e060bULL, 0x0000000016037faeULL, 0x0003e2000b901c48ULL,
0x00000001090f7824ULL, 0x000fc400010e060fULL, 0x0000000109097824ULL, 0x000fe200018e0613ULL,
0x00000000181b7faeULL, 0x0003e8000b901c48ULL, 0x00000000101d7faeULL, 0x0003e8000b901c48ULL,
0x000000000a1f7faeULL, 0x0003e8000b901c48ULL, 0x000000000c217faeULL, 0x0003e8000b901c48ULL,
0x000000000e237faeULL, 0x0003e8000b901c48ULL, 0x0000000008257faeULL, 0x0003e4000b901c48ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000087805ULL, 0x002fc40000015200ULL,
0x00f60400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fc40007804807ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff057224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a080a7210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e09ULL, 0x003d09000a00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400a00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc8000001140bULL,
0x0000000a03037211ULL, 0x000fca00078110ffULL, 0x000000ffff0a7224ULL, 0x000fca00000e060bULL,
0x0000000203037819ULL, 0x000fc8000000120aULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000105057810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f60400ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e640000000000ULL, 0x0000002000037824ULL, 0x002fca00078e0203ULL,
0x00000003ff057819ULL, 0x000fc80000011603ULL, 0x1ffffffe05067812ULL, 0x000fe400078ec0ffULL,
0x0000000f03057812ULL, 0x000fc600078ec0ffULL, 0x0000000103067824ULL, 0x000fe400078e0206ULL,
0x0000001005087824ULL, 0x040fe400078e00ffULL, 0x0000001005057824ULL, 0x000fe200078e00ffULL,
0x0000000f06037812ULL, 0x040fe400078ec0ffULL, 0x0000000106067810ULL, 0x000fe40007ffe0ffULL,
0x000000f008037812ULL, 0x000fe400078ee203ULL, 0x0000000f06067812ULL, 0x000fc600078ec0ffULL,
0x00000000030c7984ULL, 0x000e62000000cc00ULL, 0x000000f005067812ULL, 0x000fca00078ee206ULL,
0x0000000006087984ULL, 0x000ea2000000cc00ULL, 0x000000ffff107224ULL, 0x002fe400078e000cULL,
0x000000ffff0c7224ULL, 0x000fe400078e000dULL, 0x000000ffff117224ULL, 0x000fe400078e000eULL,
0x000000ffff0d7224ULL, 0x000fe400078e000fULL, 0x000000ffff127224ULL, 0x004fe400078e0008ULL,
0x000000ffff137224ULL, 0x000fc400078e000aULL, 0x000000ffff0e7224ULL, 0x000fe400078e0009ULL,
0x000000ffff0f7224ULL, 0x000fe200078e000bULL, 0x0000001003007388ULL, 0x0003e8000000cc00ULL,
0x0000000c06007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f60000ff0a7f8cULL, 0x000ea2000c80043fULL, 0x000000ffff057224ULL, 0x000fc600078e00ffULL,
0x0000000000067805ULL, 0x002fc80000015200ULL, 0x00f60400ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x006fc4000780480bULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x0000000806087210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e07ULL, 0x003d09000800780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400800780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011409ULL,
0x0000000803037211ULL, 0x000fca00078110ffULL, 0x000000ffff087224ULL, 0x000fca00000e0609ULL,
0x0000000203037819ULL, 0x000fc80000001208ULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000105057810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f60400ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe4000780480bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff6c00720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0x00005800ff6f7624ULL, 0x000fe200078e00ffULL,
0x800058006b747a10ULL, 0x000fe20007ffe0ffULL, 0x0000680004737a24ULL, 0x000fe200078e02ffULL,
0x3db504f36a6a7820ULL, 0x010fe20000410000ULL, 0x0000f68800767811ULL, 0x000fe200078e18ffULL,
0x000000ffff677224ULL, 0x000fe200078e00ffULL, 0x0000001f6f057810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff047224ULL, 0x000fe200078e00ffULL, 0xffffffff6f757810ULL, 0x000fe40007ffe0ffULL,
0x00000004ff057819ULL, 0x000fc40000011605ULL, 0x0000f60800797811ULL, 0x000fe400078e28ffULL,
0x000000096f6f7810ULL, 0x000fe40007ffe0ffULL, 0x00000008ff747819ULL, 0x000fe40000011674ULL,
0x0ffffffe05707812ULL, 0x000fc400078ec0ffULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e0004ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x000000ffff057224ULL, 0x000fe200078e00ffULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x01cfc4000001ff00ULL,
0x000000010500780cULL, 0x000fe20003f25270ULL, 0x00000072660a7224ULL, 0x010fe200078e02ffULL,
0x0000000167077810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff097224ULL, 0x000fe200078e0005ULL,
0x0000000105067810ULL, 0x000fe20007ffe0ffULL, 0x00000bc000007945ULL, 0x000fe20003800000ULL,
0x000000010b047812ULL, 0x000fc400078e0cffULL, 0x000000020600780cULL, 0x040fe20003f06070ULL,
0x000000ffff057224ULL, 0x000fe200078e0006ULL, 0x000000ff06087207ULL, 0x000fc60000800000ULL,
0x000000ffff071224ULL, 0x000fc800078e0267ULL, 0x00000100073a7824ULL, 0x040fe200078e0278ULL,
0x00000001070d7810ULL, 0x020fe20007ffe0ffULL, 0x00000080ff077424ULL, 0x000fc600078e00ffULL,
0x0000006c0d00720cULL, 0x000fe20003f46070ULL, 0x000062000a067625ULL, 0x000fe200078e0007ULL,
0x000000403a0d7812ULL, 0x000fca00078ec0ffULL, 0x000000016e0a7824ULL, 0x000fcc00078e020dULL,
0x000005d00000a947ULL, 0x000fea0003800000ULL, 0x00000010030c7824ULL, 0x002fe200078e00ffULL,
0x00000002ff437819ULL, 0x000fe20000011603ULL, 0x00000002003b7824ULL, 0x000fe200078e0204ULL,
0x0000003a6b127217ULL, 0x000fe40007800000ULL, 0x000000300c0d7812ULL, 0x000fe200078ec0ffULL,
0x00000001430f7824ULL, 0x040fe200078e020aULL, 0x00000008433d7810ULL, 0x040fe20007ffe0ffULL,
0x00000001123a7824ULL, 0x000fe200078e0a3aULL, 0x00000010433f7810ULL, 0x040fe20007ffe0ffULL,
0x00000040080c7824ULL, 0x000fe200078e020dULL, 0x0000001843457810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff0d7224ULL, 0x000fe200078e00ffULL, 0x0000002043477810ULL, 0x000fe20007ffe0ffULL,
0x000000013d117824ULL, 0x000fe200078e020aULL, 0x000010003b3b7811ULL, 0x000fe200078e60ffULL,
0x000000800f0e7825ULL, 0x000fe200078e000cULL, 0x0000002843497810ULL, 0x000fc40007ffe0ffULL,
0x00000030434b7810ULL, 0x000fe20007ffe0ffULL, 0x000000013f1b7824ULL, 0x100fe200078e020aULL,
0x0000000e06187210ULL, 0x000fe20007f3e0ffULL, 0x0000000145397824ULL, 0x040fe200078e020aULL,
0x0000003a4500720cULL, 0x000fe20003fa6070ULL, 0x0000008011107825ULL, 0x000fc800078e000cULL,
0x000000801b1a7825ULL, 0x100fe200078e000cULL, 0x0000001006127210ULL, 0x040fe40007f5e0ffULL,
0x0000000303107211ULL, 0x000fe200078fe8ffULL, 0x0000008039387825ULL, 0x000fe200078e000cULL,
0x0000001a061a7210ULL, 0x000fe40007f7e0ffULL, 0x00000003103c7812ULL, 0x000fe200078ec0ffULL,
0x0000000107197824ULL, 0x040fe200008e060fULL, 0x00000038060e7210ULL, 0x000fe20007f3e0ffULL,
0x0000000107137824ULL, 0x000fe200010e0611ULL, 0x0000003a3d00720cULL, 0x080fe20003f46070ULL,
0x00000001071b7824ULL, 0x000fe200018e061bULL, 0x0000003a3f00720cULL, 0x080fe20003f66070ULL,
0x00000001070f7824ULL, 0x000fe200008e0639ULL, 0x0000003a4300720cULL, 0x000fe20003f26070ULL,
0x000000043d3d7824ULL, 0x000fe200078e00ffULL, 0x0ffffffc3c387812ULL, 0x000fe200078ef803ULL,
0x000000043f3f7824ULL, 0x000fe200078e00ffULL, 0x0000003843437810ULL, 0x000fe20007ffe0ffULL,
0x0000000147117824ULL, 0x000fe200078e020aULL, 0xfffffffc3d3e7812ULL, 0x100fe200078ee23cULL,
0x00000010383d7824ULL, 0x000fe200078e023bULL, 0xfffffffc3f387812ULL, 0x000fe200078ee23cULL,
0x0000000149397824ULL, 0x000fc400078e020aULL, 0x0000008011107825ULL, 0x000fe400078e000cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000183d7faeULL, 0x0003e2000c901c48ULL,
0x0000003a4300720cULL, 0x000fe20003f26070ULL, 0x000000103e3f7824ULL, 0x100fe200078e023bULL,
0x0000001006107210ULL, 0x000fe20007f9e0ffULL, 0x0000001038417824ULL, 0x000fe400078e023bULL,
0x0000008039387825ULL, 0x000fe200078e000cULL, 0x00000000123f7faeULL, 0x0005e2000d101c48ULL,
0x0000003a4b00720cULL, 0x000fc40003f46070ULL, 0x0000000107117824ULL, 0x000fe200020e0611ULL,
0x000000001a417faeULL, 0x0007e2000d901c48ULL, 0x000000014b197824ULL, 0x102fe200078e020aULL,
0x0000003a4700720cULL, 0x080fe20003f86070ULL, 0x00000001433d7824ULL, 0x000fe200078e020aULL,
0x0000003a4900720cULL, 0x000fe20003f66070ULL, 0x0000008019187825ULL, 0x000fe200078e000cULL,
0x0000003806127210ULL, 0x004fc60007fde0ffULL, 0x0000000445457824ULL, 0x000fe400078e00ffULL,
0x0000000447477824ULL, 0x000fe400078e00ffULL, 0x0000000107137824ULL, 0x000fe200030e0639ULL,
0x0000001806187210ULL, 0x000fe20007fde0ffULL, 0x0000000449497824ULL, 0x000fe200078e00ffULL,
0xfffffffc450a7812ULL, 0x100fe200078ee23cULL, 0x000000044b4b7824ULL, 0x000fe200078e00ffULL,
0xfffffffc471a7812ULL, 0x008fe200078ee23cULL, 0x000000803d0c7825ULL, 0x000fe200078e000cULL,
0xfffffffc49387812ULL, 0x000fc400078ee23cULL, 0xfffffffc4b3a7812ULL, 0x100fe200078ee23cULL,
0x0000000443437824ULL, 0x000fe400078e00ffULL, 0x0000000107197824ULL, 0x000fe200030e0619ULL,
0x0000000c06067210ULL, 0x000fe20007fde0ffULL, 0x000000100a1b7824ULL, 0x100fe200078e023bULL,
0xfffffffc433c7812ULL, 0x000fe200078ee23cULL, 0x000000101a397824ULL, 0x100fe400078e023bULL,
0x00000010383d7824ULL, 0x100fe200078e023bULL, 0x000000000e1b7faeULL, 0x0003e2000e901c48ULL,
0x000000103a3f7824ULL, 0x000fc400078e023bULL, 0x000000103c3b7824ULL, 0x000fe200078e023bULL,
0x0000000010397faeULL, 0x0003e2000e101c48ULL, 0x0000000107077824ULL, 0x000fc600030e060dULL,
0x00000000123d7faeULL, 0x0003e8000d901c48ULL, 0x00000000183f7faeULL, 0x0003e8000d101c48ULL,
0x00000000063b7faeULL, 0x0003e2000c901c48ULL, 0x0000051000007947ULL, 0x000fea0003800000ULL,
0x00000002000f7824ULL, 0x000fe200078e0204ULL, 0x0000000803137811ULL, 0x042fe200078ff0ffULL,
0x00000010030c7824ULL, 0x040fe200078e00ffULL, 0x0000001003197811ULL, 0x000fc400078ff0ffULL,
0x00000018031b7811ULL, 0x000fe200078ff0ffULL, 0x0000000113117824ULL, 0x100fe200078e020aULL,
0x0000002003397811ULL, 0x000fe200078ff0ffULL, 0x00000004193f7824ULL, 0x000fe200078e00ffULL,
0x00000028033b7811ULL, 0x000fe200078ff0ffULL, 0x000000041b417824ULL, 0x000fe200078e00ffULL,
0x000010000f4b7811ULL, 0x000fe200078e60ffULL, 0x00000004130f7824ULL, 0x000fe200078e00ffULL,
0x00000030033d7811ULL, 0x000fe200078ff0ffULL, 0x0000000119137824ULL, 0x100fe200078e020aULL,
0x0000003803497811ULL, 0x000fe200078ff0ffULL, 0x000000011b197824ULL, 0x100fe200078e020aULL,
0x00000003030e7211ULL, 0x000fe200078fe8ffULL, 0x00000001391b7824ULL, 0x140fe200078e020aULL,
0x000000300c0d7812ULL, 0x000fe200078ec0ffULL, 0x0000000439437824ULL, 0x000fe200078e00ffULL,
0x000000030e0e7812ULL, 0x000fe200078ec0ffULL, 0x000000013b397824ULL, 0x000fc400078e020aULL,
0x000000043b457824ULL, 0x000fe200078e00ffULL, 0xfffffffc0f107812ULL, 0x000fe200078ee20eULL,
0x000000013d3b7824ULL, 0x000fe200078e020aULL, 0xfffffffc3f127812ULL, 0x100fe200078ee20eULL,
0x000000043d3d7824ULL, 0x000fe200078e00ffULL, 0xfffffffc41187812ULL, 0x100fe200078ee20eULL,
0x0000000449477824ULL, 0x000fe200078e00ffULL, 0xfffffffc431a7812ULL, 0x100fe200078ee20eULL,
0x00000040080c7824ULL, 0x000fe200078e020dULL, 0xfffffffc45387812ULL, 0x100fe200078ee20eULL,
0x000000ffff0d7224ULL, 0x000fe200078e00ffULL, 0xfffffffc3d3a7812ULL, 0x100fe200078ee20eULL,
0x00000010103d7824ULL, 0x100fe200078e024bULL, 0xfffffffc473c7812ULL, 0x000fe200078ee20eULL,
0x00000010123f7824ULL, 0x000fe200078e024bULL, 0x0ffffffc0e0e7812ULL, 0x000fe200078ef803ULL,
0x0000008011107825ULL, 0x000fe200078e000cULL, 0x0000000a030f7211ULL, 0x000fc600078ff0ffULL,
0x000000100e4d7824ULL, 0x000fe200078e024bULL, 0x0000001006107210ULL, 0x000fe20007f5e0ffULL,
0x000000800f0e7825ULL, 0x000fc800078e000cULL, 0x0000001018417824ULL, 0x000fe200078e024bULL,
0x0000000e060e7210ULL, 0x000fe20007f3e0ffULL, 0x0000008013127825ULL, 0x000fc800078e000cULL,
0x0000008019187825ULL, 0x000fe200078e000cULL, 0x0000001206127210ULL, 0x000fc60007f7e0ffULL,
0x0000000149497824ULL, 0x000fe200078e020aULL, 0x0000001806187210ULL, 0x000fe20007f9e0ffULL,
0x000000101a437824ULL, 0x100fe400078e024bULL, 0x0000001038457824ULL, 0x000fe400078e024bULL,
0x000000801b1a7825ULL, 0x000fc800078e000cULL, 0x000000103a477824ULL, 0x000fe400078e024bULL,
0x0000008039387825ULL, 0x000fc800078e000cULL, 0x000000803b3a7825ULL, 0x000fc800078e000cULL,
0x00000080490c7825ULL, 0x000fc800078e000cULL, 0x00000001070f7824ULL, 0x040fe200008e060fULL,
0x0000001a061a7210ULL, 0x040fe20007f3e0ffULL, 0x0000000107117824ULL, 0x040fe200010e0611ULL,
0x0000003806387210ULL, 0x040fe20007f5e0ffULL, 0x0000000107137824ULL, 0x040fe200018e0613ULL,
0x0000003a063a7210ULL, 0x040fe20007f7e0ffULL, 0x0000000107197824ULL, 0x040fe200020e0619ULL,
0x0000000c06067210ULL, 0x000fe20007f9e0ffULL, 0x00000001071b7824ULL, 0x040fe200008e061bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e4d7faeULL, 0x0003e2000b901c48ULL,
0x0000000107397824ULL, 0x000fc400010e0639ULL, 0x00000001073b7824ULL, 0x040fe200018e063bULL,
0x00000000103d7faeULL, 0x0003e2000b901c48ULL, 0x000000103c4b7824ULL, 0x000fe400078e024bULL,
0x0000000107077824ULL, 0x000fe200020e060dULL, 0x00000000123f7faeULL, 0x0003e8000b901c48ULL,
0x0000000018417faeULL, 0x0003e8000b901c48ULL, 0x000000001a437faeULL, 0x0003e8000b901c48ULL,
0x0000000038457faeULL, 0x0003e8000b901c48ULL, 0x000000003a477faeULL, 0x0003e8000b901c48ULL,
0x00000000064b7faeULL, 0x0003e4000b901c48ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000010800780cULL, 0x000fe20003f25270ULL, 0x000000a000007945ULL, 0x000fd80003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x0000000202027810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff667424ULL, 0x000fc600078e00ffULL, 0x0000006d0200720cULL, 0x000fda0003f26070ULL,
0x0000004000001947ULL, 0x000fea0003800000ULL, 0x0000000273067824ULL, 0x002fe400078e0202ULL,
0x00000004ff077424ULL, 0x000fc800078e00ffULL, 0x0000640006067625ULL, 0x000fca00078e0007ULL,
0x0000000806667981ULL, 0x000324000c1e1900ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000002003067810ULL, 0x042fe20007ffe0ffULL,
0x0000000200077824ULL, 0x000fe200078e020bULL, 0xfffffff8030a7812ULL, 0x040fe200078ec0ffULL,
0x000000ffff087224ULL, 0x000fe200078e00ffULL, 0xfffffff806067812ULL, 0x000fe400078ec0ffULL,
0x00000007030c7812ULL, 0x000fe400078ec0ffULL, 0x000000070a0a7812ULL, 0x100fe400078ef803ULL,
0x00000007060b7812ULL, 0x000fc400078ef803ULL, 0x0000100007067811ULL, 0x000fe400078e60ffULL,
0x000000080c077812ULL, 0x000fe400078ef803ULL, 0x00000001ff697819ULL, 0x000fe4000001160aULL,
0x00000001ff687819ULL, 0x000fe2000001160bULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000001690c7824ULL, 0x020fe200078e0208ULL, 0x0000000108117810ULL, 0x000fe20007ffe0ffULL,
0x000000040a0d7824ULL, 0x040fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000040a187824ULL, 0x000fc400078e00ffULL, 0x0000000169137824ULL, 0x000fe200078e0211ULL,
0xfffffffc0d0d7812ULL, 0x000fe200078ee20cULL, 0x00000001680c7824ULL, 0x100fe400078e0208ULL,
0x0000000409107824ULL, 0x000fe200078e0208ULL, 0xfffffffc18137812ULL, 0x000fe200078ee213ULL,
0x000000100d447824ULL, 0x100fe200078e0206ULL, 0x0000000208087810ULL, 0x000fe20007ffe0ffULL,
0x000000040b0d7824ULL, 0x000fe400078e00ffULL, 0x0000000210107824ULL, 0x000fe200078e00ffULL,
0x000000040800780cULL, 0x000fe20003f25270ULL, 0x0000001013137824ULL, 0x000fe200078e0206ULL,
0xfffffffc0d0d7812ULL, 0x000fe200078ee20cULL, 0x000000004444783bULL, 0x000e620000000200ULL,
0x0000001003127211ULL, 0x000fe200078fe0ffULL, 0x00000010071b7824ULL, 0x000fe200078e00ffULL,
0x0000000210107810ULL, 0x000fe20007ffe0ffULL, 0x000000100d0d7824ULL, 0x000fe200078e0206ULL,
0x000000001338783bULL, 0x000fe20000000200ULL, 0x0000000107127824ULL, 0x000fe200078e0212ULL,
0x0000001003107211ULL, 0x000fe200078fe0ffULL, 0x0000000168197824ULL, 0x000fc400078e0211ULL,
0x000000000d0c783bULL, 0x000ea20000000200ULL, 0xfffffff01b127812ULL, 0x000fe200078ee212ULL,
0x0000000107647824ULL, 0x000fe400078e0210ULL, 0x000000040b1a7824ULL, 0x000fe400078e00ffULL,
0x0000001012127824ULL, 0x000fe200078e00ffULL, 0xfffffff01b647812ULL, 0x000fe400078ee264ULL,
0xfffffffc1a197812ULL, 0x000fc600078ee219ULL, 0x000000001210783bULL, 0x000ee40000000200ULL,
0x0000001019197824ULL, 0x000fe200078e0206ULL, 0x00000018ff187819ULL, 0x002fe40000011645ULL,
0x00000010ff437819ULL, 0x100fe40000011644ULL, 0x00000018ff5b7819ULL, 0x000fe40000011644ULL,
0x000000ff44577812ULL, 0x040fe400078ec0ffULL, 0x0000ffff44447812ULL, 0x000fc400078ec0ffULL,
0x00000010ff4a7819ULL, 0x000fe40000011645ULL, 0x000000ff45407812ULL, 0x040fe400078ec0ffULL,
0x0000ffff454d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff547819ULL, 0x104fe4000001160eULL,
0x00000018ff587819ULL, 0x000fe4000001160eULL, 0x000000ff0e5e7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff0e507812ULL, 0x000fe400078ec0ffULL, 0x00000010ff417819ULL, 0x100fe40000011638ULL,
0x00000018ff567819ULL, 0x000fe40000011638ULL, 0x000000ff38497812ULL, 0x040fe400078ec0ffULL,
0x0000ffff38427812ULL, 0x000fe400078ec0ffULL, 0x00000018ff45723eULL, 0x000fc400020006ffULL,
0x00000010ff0e7819ULL, 0x100fe2000001163aULL, 0x000000001918783bULL, 0x000e620000000200ULL,
0x00000018ff4f7819ULL, 0x000fe4000001163aULL, 0x000000ff3a4e7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff3a387812ULL, 0x000fe400078ec0ffULL, 0x000000ff435f7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff3a7819ULL, 0x000fc40000011644ULL, 0x00000010ff487819ULL, 0x100fe4000001160cULL,
0x00000018ff537819ULL, 0x000fe4000001160cULL, 0x000000ff0c527812ULL, 0x040fe400078ec0ffULL,
0x0000ffff0c627812ULL, 0x000fe400078ec0ffULL, 0x00000010ff637819ULL, 0x100fe4000001160dULL,
0x00000018ff5d7819ULL, 0x000fc4000001160dULL, 0x000000ff0d5c7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff0d607812ULL, 0x000fe400078ec0ffULL, 0x00000010ff517819ULL, 0x100fe4000001160fULL,
0x00000018ff597819ULL, 0x000fe4000001160fULL, 0x000000ff0f5a7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff0f557812ULL, 0x000fc400078ec0ffULL, 0x00000010ff0c7819ULL, 0x100fe40000011639ULL,
0x00000018ff4b7819ULL, 0x000fe40000011639ULL, 0x000000ff394c7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff390d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff0f7819ULL, 0x100fe4000001163bULL,
0x00000018ff447819ULL, 0x000fc4000001163bULL, 0x000000ff3b437812ULL, 0x040fe400078ec0ffULL,
0x0000ffff3b397812ULL, 0x000fe400078ec0ffULL, 0x0000005bff5b723eULL, 0x000fe400020006ffULL,
0x00000057ff57723eULL, 0x000fe400020006ffULL, 0x0000005fff3b723eULL, 0x000fe400020006ffULL,
0x0000003aff3a723eULL, 0x000fc400020006ffULL, 0x000054103b3b7816ULL, 0x000fe4000000005bULL,
0x00005410573a7816ULL, 0x000fe4000000003aULL, 0x000000ff4a4a7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff4d7819ULL, 0x000fe4000001164dULL, 0x00000040ff40723eULL, 0x000fe200020006ffULL,
0x0000003a1034723cULL, 0x008b620000001834ULL, 0x00000010ff3e7819ULL, 0x000fc40000011646ULL,
0x0000ffff463f7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff3d7819ULL, 0x000fe40000011646ULL,
0x0000004aff3b723eULL, 0x020fe400020006ffULL, 0x0000004dff3a723eULL, 0x000fe400020006ffULL,
0x000054103b3b7816ULL, 0x000fe40000000045ULL, 0x00005410403a7816ULL, 0x000fc4000000003aULL,
0x000000ff463c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff3e3e7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff3f7819ULL, 0x000fe2000001163fULL, 0x0000003a1030723cULL, 0x000b620000001830ULL,
0x0000003dff3d723eULL, 0x000fe400020006ffULL, 0x0000003cff3c723eULL, 0x000fe400020006ffULL,
0x00000010ff467819ULL, 0x000fc40000011647ULL, 0x0000003eff3b723eULL, 0x020fe400020006ffULL,
0x0000003fff3a723eULL, 0x000fe400020006ffULL, 0x000054103b3b7816ULL, 0x000fe4000000003dULL,
0x000054103c3a7816ULL, 0x000fe4000000003aULL, 0x00000018ff657819ULL, 0x000fe40000011647ULL,
0x000000ff47617812ULL, 0x000fc400078ec0ffULL, 0x0000ffff47477812ULL, 0x000fe200078ec0ffULL,
0x0000003a102c723cULL, 0x000b62000000182cULL, 0x00000018ff5f7819ULL, 0x102fe40000011618ULL,
0x000000ff185b7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff183c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff3a7819ULL, 0x020fe40000011618ULL, 0x00000010ff3b7819ULL, 0x000fc40000011619ULL,
0x00000018ff577819ULL, 0x000fe40000011619ULL, 0x000000ff194d7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff193d7812ULL, 0x000fe400078ec0ffULL, 0x000000ff46197812ULL, 0x000fe400078ec0ffULL,
0x00000008ff187819ULL, 0x000fe40000011647ULL, 0x00000065ff65723eULL, 0x000fc400020006ffULL,
0x00000061ff61723eULL, 0x000fe400020006ffULL, 0x00000019ff19723eULL, 0x000fe400020006ffULL,
0x00000018ff18723eULL, 0x000fe400020006ffULL, 0x000000ff48777812ULL, 0x000fe400078ec0ffULL,
0x00000008ff627819ULL, 0x000fe40000011662ULL, 0x0000541019197816ULL, 0x000fc40000000065ULL,
0x0000541061187816ULL, 0x000fe40000000018ULL, 0x00000010ff3e7819ULL, 0x100fe4000001161aULL,
0x00000018ff407819ULL, 0x000fe4000001161aULL, 0x000000ff1a3f7812ULL, 0x040fe200078ec0ffULL,
0x000000181028723cULL, 0x000b620000001828ULL, 0x0000ffff1a457812ULL, 0x000fe200078ec0ffULL,
0x00000010641a7824ULL, 0x000fe200078e00ffULL, 0x00000053ff53723eULL, 0x000fc400020006ffULL,
0x00000052ff52723eULL, 0x000fe400020006ffULL, 0x00000077ff77723eULL, 0x000fe400020006ffULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x0000541077537816ULL, 0x000fe40000000053ULL,
0x0000541052527816ULL, 0x000fe40000000062ULL, 0x00000010ff467819ULL, 0x000fc4000001161bULL,
0x00000018ff477819ULL, 0x000fe4000001161bULL, 0x000000ff1b487812ULL, 0x040fe200078ec0ffULL,
0x000000521024723cULL, 0x000b620000001824ULL, 0x0000ffff1b4a7812ULL, 0x000fe400078ec0ffULL,
0x000000001a18783bULL, 0x020e620000000200ULL, 0x000000ff63637812ULL, 0x000fe400078ec0ffULL,
0x00000008ff607819ULL, 0x000fe40000011660ULL, 0x000000ff54527812ULL, 0x000fc400078ec0ffULL,
0x00000008ff547819ULL, 0x000fe40000011650ULL, 0x00000008ff507819ULL, 0x000fe40000011655ULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x00000063ff61723eULL, 0x000fe400020006ffULL, 0x00000060ff60723eULL, 0x000fc400020006ffULL,
0x00000052ff55723eULL, 0x000fe400020006ffULL, 0x000000ff51537812ULL, 0x000fe400078ec0ffULL,
0x00000050ff52723eULL, 0x000fe400020006ffULL, 0x0000541061517816ULL, 0x000fe4000000005dULL,
0x000054105c507816ULL, 0x000fe40000000060ULL, 0x00000058ff58723eULL, 0x000fc400020006ffULL,
0x0000005eff5e723eULL, 0x000fe400020006ffULL, 0x00000059ff59723eULL, 0x000fe200020006ffULL,
0x000000501020723cULL, 0x000b620000001820ULL, 0x0000005aff5a723eULL, 0x000fe400020006ffULL,
0x00000054ff54723eULL, 0x000fe400020006ffULL, 0x00000053ff53723eULL, 0x000fe400020006ffULL,
0x00000049ff51723eULL, 0x020fc400020006ffULL, 0x0000004bff50723eULL, 0x000fe400020006ffULL,
0x0000004fff49723eULL, 0x000fe400020006ffULL, 0x0000004eff4b723eULL, 0x000fe400020006ffULL,
0x00005410554f7816ULL, 0x000fe40000000058ULL, 0x000054105e4e7816ULL, 0x000fe40000000054ULL,
0x0000541053597816ULL, 0x000fc40000000059ULL, 0x000054105a587816ULL, 0x000fe40000000052ULL,
0x000000ff41417812ULL, 0x000fe200078ec0ffULL, 0x0000004e101c723cULL, 0x040f62000000181cULL,
0x00000008ff427819ULL, 0x000fe40000011642ULL, 0x00000056ff56723eULL, 0x000fe400020006ffULL,
0x00000041ff41723eULL, 0x000fe400020006ffULL, 0x00000042ff42723eULL, 0x000fe200020006ffULL,
0x000000581014723cULL, 0x000b620000001814ULL, 0x0000004cff4c723eULL, 0x000fc400020006ffULL,
0x000000ff0e0e7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff387819ULL, 0x000fe40000011638ULL,
0x000000ff0c117812ULL, 0x020fe400078ec0ffULL, 0x00000008ff107819ULL, 0x000fe4000001160dULL,
0x00005410410d7816ULL, 0x000fe40000000056ULL, 0x00005410510c7816ULL, 0x000fc40000000042ULL,
0x000000ff0f0f7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff397819ULL, 0x000fe40000011639ULL,
0x00000044ff44723eULL, 0x000fe200020006ffULL, 0x0000000c1834723cULL, 0x002b620000001834ULL,
0x00000043ff43723eULL, 0x000fe400020006ffULL, 0x000000ff3a3a7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff3c7819ULL, 0x000fc4000001163cULL, 0x00000011ff0d723eULL, 0x020fe400020006ffULL,
0x00000010ff0c723eULL, 0x000fe400020006ffULL, 0x000054100d0d7816ULL, 0x000fe40000000050ULL,
0x000054104c0c7816ULL, 0x000fe4000000000cULL, 0x000000ff3b3b7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff3d7819ULL, 0x000fc4000001163dULL, 0x000000ff3e3e7812ULL, 0x000fe200078ec0ffULL,
0x0000000c1830723cULL, 0x000b620000001830ULL, 0x00000008ff457819ULL, 0x000fe40000011645ULL,
0x000000ff46467812ULL, 0x000fe400078ec0ffULL, 0x00000008ff4a7819ULL, 0x000fe4000001164aULL,
0x0000000eff0d723eULL, 0x020fe400020006ffULL, 0x00000038ff0c723eULL, 0x000fc400020006ffULL,
0x000054100d0d7816ULL, 0x000fe40000000049ULL, 0x000054104b0c7816ULL, 0x000fe4000000000cULL,
0x0000005fff5f723eULL, 0x000fe400020006ffULL, 0x0000005bff5b723eULL, 0x000fe400020006ffULL,
0x00000057ff57723eULL, 0x000fe200020006ffULL, 0x0000000c182c723cULL, 0x000b62000000182cULL,
0x0000004dff4d723eULL, 0x000fc400020006ffULL, 0x00000040ff40723eULL, 0x000fe400020006ffULL,
0x0000003aff3a723eULL, 0x000fe400020006ffULL, 0x0000000fff0d723eULL, 0x020fe400020006ffULL,
0x00000039ff0c723eULL, 0x000fe400020006ffULL, 0x000054100d0d7816ULL, 0x000fe40000000044ULL,
0x00005410430c7816ULL, 0x000fc4000000000cULL, 0x0000003cff3c723eULL, 0x000fe400020006ffULL,
0x0000003fff3f723eULL, 0x000fe400020006ffULL, 0x0000003bff3b723eULL, 0x000fe200020006ffULL,
0x0000000c1828723cULL, 0x000b620000001828ULL, 0x0000003dff3d723eULL, 0x000fe400020006ffULL,
0x00000047ff47723eULL, 0x000fe400020006ffULL, 0x00000045ff45723eULL, 0x000fc400020006ffULL,
0x0000003eff0d723eULL, 0x020fe400020006ffULL, 0x00000048ff48723eULL, 0x000fe400020006ffULL,
0x00000046ff49723eULL, 0x000fe400020006ffULL, 0x0000004aff4a723eULL, 0x000fe400020006ffULL,
0x000054103a5f7816ULL, 0x000fe4000000005fULL, 0x000054105b5e7816ULL, 0x000fc4000000003cULL,
0x000054103b577816ULL, 0x000fe40000000057ULL, 0x000054104d567816ULL, 0x000fe4000000003dULL,
0x000054100d0d7816ULL, 0x000fe20000000040ULL, 0x0000005e1824723cULL, 0x000b620000001824ULL,
0x000054103f0c7816ULL, 0x000fe40000000045ULL, 0x0000541049497816ULL, 0x000fe40000000047ULL,
0x0000541048487816ULL, 0x000fc6000000004aULL, 0x000000561820723cULL, 0x040b700000001820ULL,
0x0000000c181c723cULL, 0x040b70000000181cULL, 0x000000481814723cULL, 0x000b620000001814ULL,
0xfffff09000001947ULL, 0x000fce000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e0004ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffe29000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x0000006a30307220ULL, 0x080fe20000410000ULL, 0x0000006a2c2c7220ULL, 0x080fe20000410000ULL,
0x0000006a2d2d7220ULL, 0x080fe20000410000ULL, 0x0000006a28287220ULL, 0x080fe20000410000ULL,
0x0000006a35357220ULL, 0x080fe20000410000ULL, 0x0000006a31317220ULL, 0x080fe20000410000ULL,
0x0000006a24057220ULL, 0x0a0fe20000410000ULL, 0x0000006a25067220ULL, 0x080fe20000410000ULL,
0x0000006a21217220ULL, 0x080fe20000410000ULL, 0x0000006a1c1c7220ULL, 0x080fe20000410000ULL,
0x0000006a32077220ULL, 0x080fe20000410000ULL, 0x0000006a2b0d7220ULL, 0x080fe20000410000ULL,
0x0000006a260e7220ULL, 0x080fe20000410000ULL, 0x0000006a27127220ULL, 0x080fe20000410000ULL,
0x0000006a2e0a7220ULL, 0x080fe20000410000ULL, 0x0000006a29327220ULL, 0x080fe20000410000ULL,
0x0000006a2a0c7220ULL, 0x080fe20000410000ULL, 0x0000006a220f7220ULL, 0x080fe20000410000ULL,
0x0000006a23107220ULL, 0x080fe20000410000ULL, 0x000000ffff257224ULL, 0x000fe200078e0030ULL,
0x0000006a34137220ULL, 0x080fe20000410000ULL, 0x000000ffff2b7224ULL, 0x000fe200078e002cULL,
0x0000006a36367220ULL, 0x080fe20000410000ULL, 0x000000ffff267224ULL, 0x000fe200078e002dULL,
0x0000006a37377220ULL, 0x080fe20000410000ULL, 0x000000ffff277224ULL, 0x000fe200078e0028ULL,
0x0000006a33337220ULL, 0x080fe20000410000ULL, 0x0000006a2f0b7220ULL, 0x080fe20000410000ULL,
0x0000006a20297220ULL, 0x080fe20000410000ULL, 0x0000006a1d2a7220ULL, 0x080fe20000410000ULL,
0x0000006a1e187220ULL, 0x080fe20000410000ULL, 0x0000006a1f197220ULL, 0x080fe20000410000ULL,
0x0000006a14227220ULL, 0x080fe20000410000ULL, 0x0000006a15237220ULL, 0x080fe20000410000ULL,
0x0000006a161a7220ULL, 0x080fe20000410000ULL, 0x0000006a171b7220ULL, 0x000fe20000410000ULL,
0x000000ffff247224ULL, 0x000fc400078e0035ULL, 0x000000ffff2e7224ULL, 0x000fe400078e0031ULL,
0x000000ffff307224ULL, 0x000fe400078e0005ULL, 0x000000ffff287224ULL, 0x000fe400078e0006ULL,
0x000000ffff2d7224ULL, 0x000fe400078e0021ULL, 0x000000ffff2c7224ULL, 0x000fe200078e001cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000076087f8cULL, 0x0002a2000c80043fULL,
0x000000ffff1e7224ULL, 0x000fc400078e0036ULL, 0x000000ffff167224ULL, 0x000fe400078e0037ULL,
0x000000ffff177224ULL, 0x000fe400078e0007ULL, 0x000000ffff2f7224ULL, 0x000fe400078e0033ULL,
0x000000ffff1f7224ULL, 0x000fe400078e000aULL, 0x000000ffff1d7224ULL, 0x000fe400078e000bULL,
0x000000ffff207224ULL, 0x000fc400078e000cULL, 0x000000ffff317224ULL, 0x000fe400078e000dULL,
0x000000ffff217224ULL, 0x000fe400078e000eULL, 0x000000ffff147224ULL, 0x000fe400078e000fULL,
0x000000ffff157224ULL, 0x000fc400078e0010ULL, 0x0000000000067805ULL, 0x002fca0000015200ULL,
0x0000040076057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x006fe40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a060a7210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e07ULL, 0x003d09000a00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400a00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff057819ULL, 0x000fc8000001140bULL,
0x0000000a05057211ULL, 0x000fca00078110ffULL, 0x000000ffff0a7224ULL, 0x000fca00000e060bULL,
0x0000000205057819ULL, 0x000fc8000000120aULL, 0x000000050000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040076057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004031c7824ULL, 0x000fe200078e00ffULL, 0x000000746700720cULL, 0x000fc80003f06070ULL,
0xfffffff01c057812ULL, 0x000fca00078ec0ffULL, 0x0000008000057824ULL, 0x000fca00078e0205ULL,
0x00f4000005087984ULL, 0x0002a20000000c00ULL, 0x0000136000008947ULL, 0x000fea0003800000ULL,
0x0000010067067824ULL, 0x000fe400078e0278ULL, 0x0000000203347824ULL, 0x000fe400078e00ffULL,
0x00000002ff497424ULL, 0x000fe200078e00ffULL, 0x000000066b337217ULL, 0x000fe40007800000ULL,
0x0000000634347812ULL, 0x000fc600078ec0ffULL, 0x0000000133337824ULL, 0x000fe200078e0a06ULL,
0x0000007103067211ULL, 0x000fe200078ff0ffULL, 0x000000016f0e7824ULL, 0x000fe200078e0234ULL,
0x0000580034367a10ULL, 0x000fe40007ffe0ffULL, 0x00005a00ff0c7a19ULL, 0x000fe20000011606ULL,
0x000000010e107824ULL, 0x140fe200078e0a33ULL, 0x000000330e00720cULL, 0x000fe20003f26070ULL,
0x00000001360e7824ULL, 0x000fe200078e0a33ULL, 0x0000000c75077217ULL, 0x040fe40003800000ULL,
0x0000001075107217ULL, 0x000fc40003800000ULL, 0x000000333600720cULL, 0x000fe20003f06070ULL,
0x0000000770507224ULL, 0x000fe200078e02ffULL, 0x0000000e750e7217ULL, 0x000fe40003800000ULL,
0x00000004ff107819ULL, 0x000fe40000011610ULL, 0x000000ff0e417207ULL, 0x000fe40000000000ULL,
0x000000ff100f7207ULL, 0x000fe40000800000ULL, 0x00000050410c7211ULL, 0x000fc400078fe0ffULL,
0x0000000806107810ULL, 0x000fe20007ffe0ffULL, 0x00000001500e7824ULL, 0x000fe200078e020fULL,
0x00000010343c7812ULL, 0x000fe200078efcffULL, 0x000060000c067625ULL, 0x080fe200078e0049ULL,
0x00005a00ff107a19ULL, 0x000fe40000011610ULL, 0x000058003c387a10ULL, 0x000fe20007ffe0ffULL,
0x000060000e0c7625ULL, 0x000fe200078e0049ULL, 0x0000001075117217ULL, 0x000fe20003800000ULL,
0x0000000806477981ULL, 0x0046a4000c1e9500ULL, 0x000000016f3a7824ULL, 0x000fc400078e023cULL,
0x000000080c4e7981ULL, 0x0002a2000c1e9500ULL, 0x0000001170527224ULL, 0x000fe400078e02ffULL,
0x000000333a00720cULL, 0x080fe40003f26070ULL, 0x000000333800720cULL, 0x040fe20003f06070ULL,
0x0000000138067824ULL, 0x108fe200078e0a33ULL, 0x00000052410e7211ULL, 0x000fe200078fe0ffULL,
0x000000010f107824ULL, 0x000fe400078e0252ULL, 0x000000013a0c7824ULL, 0x002fe200078e0a33ULL,
0x00000020343a7812ULL, 0x000fe200078efcffULL, 0x000060000e0e7625ULL, 0x000fe200078e0049ULL,
0x0000000675067217ULL, 0x000fc40003800000ULL, 0x000058003a407a10ULL, 0x000fe20007ffe0ffULL,
0x0000600010107625ULL, 0x000fe200078e0049ULL, 0x000000ff06357207ULL, 0x000fe20000000000ULL,
0x000000080e437981ULL, 0x0002e2000c1e9500ULL, 0x0000000c750c7217ULL, 0x000fe20003800000ULL,
0x0000000140447824ULL, 0x040fe200078e0a33ULL, 0x0000005035067211ULL, 0x000fe200078fe0ffULL,
0x000000016f467824ULL, 0x000fe200078e023aULL, 0x00000004ff0c7819ULL, 0x000fe2000001160cULL,
0x00000008104c7981ULL, 0x0002e2000c1e9500ULL, 0x000000334000720cULL, 0x000fe20003f06070ULL,
0x0000600006067625ULL, 0x000fe200078e0049ULL, 0x00000044753b7217ULL, 0x000fc40003800000ULL,
0x000000ff0c0f7207ULL, 0x002fe20000800000ULL, 0x0000000146487824ULL, 0x000fe200078e0a33ULL,
0x000000ff3b3b7207ULL, 0x000fe20000000000ULL, 0x0000000806377981ULL, 0x0002e2000c1e9500ULL,
0x0000003034447812ULL, 0x000fe200078efcffULL, 0x00000001500c7824ULL, 0x000fe200078e020fULL,
0x00000052350e7211ULL, 0x000fe200078fe0ffULL, 0x000000010f107824ULL, 0x000fe200078e0252ULL,
0x0000004875487217ULL, 0x000fe20003800000ULL, 0x000000016f547824ULL, 0x000fe200078e0244ULL,
0x000000334600720cULL, 0x000fe20003f26070ULL, 0x000060000c0c7625ULL, 0x000fe200078e0049ULL,
0x000000503b067211ULL, 0x002fc600078fe0ffULL, 0x000060000e0e7625ULL, 0x080fe200078e0049ULL,
0x00000004ff487819ULL, 0x000fe20000011648ULL, 0x000000080c3e7981ULL, 0x0002e4000c1e9500ULL,
0x0000600010107625ULL, 0x080fe200078e0049ULL, 0x0000580044467a10ULL, 0x000fe20007ffe0ffULL,
0x000000080e397981ULL, 0x0002e4000c1e9500ULL, 0x0000600006067625ULL, 0x000fe200078e0049ULL,
0x000000ff483f7207ULL, 0x000fe20000800000ULL, 0x0000000810427981ULL, 0x0002e4000c1e9500ULL,
0x0000000154567824ULL, 0x000fc400078e0a33ULL, 0x00000008063d7981ULL, 0x0002e4000c1e9500ULL,
0x00000001500c7824ULL, 0x002fe200078e023fULL, 0x000000523b0e7211ULL, 0x000fe400078fe0ffULL,
0x0000005675567217ULL, 0x000fe20003800000ULL, 0x000000013f107824ULL, 0x000fe400078e0252ULL,
0x0000000146067824ULL, 0x040fe200078e0a33ULL, 0x000000334600720cULL, 0x000fe20003f06070ULL,
0x000060000c0c7625ULL, 0x000fe200078e0049ULL, 0x000000335400720cULL, 0x000fc40003f26070ULL,
0x0000000675067217ULL, 0x000fe20003800000ULL, 0x000060000e0e7625ULL, 0x080fe200078e0049ULL,
0x00000004ff567819ULL, 0x000fe20000011656ULL, 0x000000080c487981ULL, 0x0002e4000c1e9500ULL,
0x0000600010107625ULL, 0x000fe200078e0049ULL, 0x000000ff06457207ULL, 0x000fe20000000000ULL,
0x000000080e3f7981ULL, 0x0002e2000c1e9500ULL, 0x000000ff564b7207ULL, 0x000fc60000800000ULL,
0x00000008104a7981ULL, 0x0002e2000c1e9500ULL, 0x0000005045067211ULL, 0x000fe200078fe0ffULL,
0x00000001500c7824ULL, 0x002fc800078e024bULL, 0x0000600006067625ULL, 0x000fc800078e0049ULL,
0x000060000c0c7625ULL, 0x000fe400078e0049ULL, 0x0000000806067981ULL, 0x0002e2000c1e9500ULL,
0x00000052450e7211ULL, 0x000fc600078fe0ffULL, 0x000000080c0d7981ULL, 0x0002e2000c1e9500ULL,
0x000000014b107824ULL, 0x000fe400078e0252ULL, 0x000060000e0e7625ULL, 0x000fc800078e0049ULL,
0x0000600010107625ULL, 0x000fe400078e0049ULL, 0x000000080e0e7981ULL, 0x0002e8000c1e9500ULL,
0x0000000810117981ULL, 0x0004e2000c1e9500ULL, 0xfffffff041507812ULL, 0x000fe200078ec0ffULL,
0x00000001ff417424ULL, 0x000fc800078e00ffULL, 0x0000000133077824ULL, 0x002fe200078e0250ULL,
0x0000000834507812ULL, 0x000fc600078efcffULL, 0x0000000136587824ULL, 0x100fe200078e0a07ULL,
0x0000000934547812ULL, 0x000fe400078efcffULL, 0x0000580050527a10ULL, 0x000fe40007ffe0ffULL,
0x0000005841587219ULL, 0x000fe400000006ffULL, 0x00005800540c7a10ULL, 0x000fe20007ffe0ffULL,
0x00000001525a7824ULL, 0x000fc800078e0a07ULL, 0x000000010c5c7824ULL, 0x000fe200078e0a07ULL,
0x0000005a415a7219ULL, 0x000fe400000006ffULL, 0xfffffff035497812ULL, 0x000fe400078ec0ffULL,
0x0000005c415c7219ULL, 0x000fe400000006ffULL, 0x00000018347c7812ULL, 0x040fe200078efcffULL,
0x0000000133497824ULL, 0x000fe200078e0249ULL, 0x00000019347a7812ULL, 0x000fc600078efcffULL,
0x0000000138517824ULL, 0x000fe200078e0a49ULL, 0x000058007a0f7a10ULL, 0x000fe40007ffe0ffULL,
0xfffffff03b4b7812ULL, 0x000fc600078ec0ffULL, 0x000000010f577824ULL, 0x000fe400078e0a49ULL,
0x00000001334b7824ULL, 0x000fe200078e024bULL, 0x0000002134607812ULL, 0x000fc600078efcffULL,
0x0000000140597824ULL, 0x000fe200078e0a4bULL, 0x00000028345e7812ULL, 0x000fe400078efcffULL,
0xfffffff045457812ULL, 0x000fe400078ec0ffULL, 0x0000005741577219ULL, 0x000fe400000006ffULL,
0x0000580060687a10ULL, 0x000fe20007ffe0ffULL, 0x00000001334d7824ULL, 0x000fe200078e0245ULL,
0x000058005e647a10ULL, 0x000fc60007ffe0ffULL, 0x00000001685b7824ULL, 0x100fe400078e0a4bULL,
0x00000001645d7824ULL, 0x000fe400078e0a4bULL, 0x00000001464f7824ULL, 0x000fca00078e0a4dULL,
0x0000004f414f7219ULL, 0x000fe400000006ffULL, 0x0000541047477816ULL, 0x004fe4000000004eULL,
0x00000001344e7812ULL, 0x000fe400078efcffULL, 0x0000004758ff7212ULL, 0x000fe4000780c0ffULL,
0x000058004e567a10ULL, 0x000fe40007ffe0ffULL, 0x000000333600720cULL, 0x000fc60000701470ULL,
0x0000000156107824ULL, 0x000fe200078e0a07ULL, 0x000000333400720cULL, 0x040fe40000701070ULL,
0x0000001134077812ULL, 0x000fe400078efcffULL, 0x0000001041107219ULL, 0x000fe400000006ffULL,
0x000000475aff7212ULL, 0x080fe4000784c0ffULL, 0x0000004710ff7212ULL, 0x000fe4000786c0ffULL,
0x0000541043437816ULL, 0x008fc4000000004cULL, 0x000000475cff7212ULL, 0x000fe4000782c0ffULL,
0xff80000013137808ULL, 0x000fe40000000000ULL, 0x0000004358ff7212ULL, 0x080fe4000788c0ffULL,
0x0000004310ff7212ULL, 0x080fe400078ac0ffULL, 0x000000435aff7212ULL, 0x080fe400078cc0ffULL,
0x000000435cff7212ULL, 0x000fc4000780c0ffULL, 0x0000580007477a10ULL, 0x000fe40007ffe0ffULL,
0x000058007c437a10ULL, 0x000fe40007ffe0ffULL, 0x000000333600720cULL, 0x080fe20002781470ULL,
0x0000000147537824ULL, 0x100fe200078e0a49ULL, 0x000000335200720cULL, 0x080fe200037c1470ULL,
0x0000000143557824ULL, 0x000fe200078e0a49ULL, 0x000000330c00720cULL, 0x000fe40000701470ULL,
0x0000005141497219ULL, 0x000fc400000006ffULL, 0x0000005341517219ULL, 0x040fe400000006ffULL,
0x000000333400720cULL, 0x080fe40002781070ULL, 0x000000335000720cULL, 0x080fe400037c1070ULL,
0x000000335400720cULL, 0x000fe40000701070ULL, 0x0000005541537219ULL, 0x000fe400000006ffULL,
0x00005410373e7816ULL, 0x000fc4000000003eULL, 0x0000541039427816ULL, 0x000fe40000000042ULL,
0x000000330c00720cULL, 0x000fe40000f21470ULL, 0xff8000001e1e7808ULL, 0x000fe40002000000ULL,
0xff80000017177808ULL, 0x000fe40003000000ULL, 0xff8000002f2f7808ULL, 0x000fe40000000000ULL,
0x0000003e49ff7212ULL, 0x000fc4000788c0ffULL, 0x0000004249ff7212ULL, 0x080fe400078cc0ffULL,
0x0000004253ff7212ULL, 0x000fe4000780c0ffULL, 0x000000335400720cULL, 0x080fe40000f21070ULL,
0x000000335600720cULL, 0x0c0fe40001f61470ULL, 0x000000335600720cULL, 0x080fe40002fa1470ULL,
0x000000335200720cULL, 0x000fc40001741470ULL, 0x000000333800720cULL, 0x0c0fe40002781470ULL,
0x000000333800720cULL, 0x080fe400037c1470ULL, 0x000000334300720cULL, 0x080fe40000701470ULL,
0xff8000002e2e7808ULL, 0x000fe40000800000ULL, 0x00000029345c7812ULL, 0x000fe400078efcffULL,
0x000000334e00720cULL, 0x000fc40001f61070ULL, 0x000000334e00720cULL, 0x080fe40002fa1070ULL,
0x000000335000720cULL, 0x080fe40001741070ULL, 0x000000333c00720cULL, 0x0c0fe40002721070ULL,
0x000000333c00720cULL, 0x080fe400037c1070ULL, 0x000000337c00720cULL, 0x000fe40000701070ULL,
0x0000005941557219ULL, 0x000fc400000006ffULL, 0x000054103d487816ULL, 0x000fe40000000048ULL,
0x000054103f4a7816ULL, 0x000fe4000000004aULL, 0x000058005c627a10ULL, 0x000fe40007ffe0ffULL,
0xff80000024247808ULL, 0x000fe40001800000ULL, 0xff80000016167808ULL, 0x000fe40002800000ULL,
0xff80000025257808ULL, 0x000fc40001000000ULL, 0xff8000002b2b7808ULL, 0x000fe40000800000ULL,
0xff8000001f1f7808ULL, 0x000fe40003000000ULL, 0xff80000020207808ULL, 0x000fe40000000000ULL,
0x0000003e51ff7212ULL, 0x080fe4000786c0ffULL, 0x0000003e53ff7212ULL, 0x080fe400078ac0ffULL,
0x0000003e57ff7212ULL, 0x000fc4000784c0ffULL, 0x0000004251ff7212ULL, 0x080fe4000788c0ffULL,
0x0000004257ff7212ULL, 0x000fe4000782c0ffULL, 0x0000004855ff7212ULL, 0x040fe400078cc0ffULL,
0x0000004a55ff7212ULL, 0x000fe2000780c0ffULL, 0x00000001625f7824ULL, 0x000fe200078e0a4bULL,
0x000000334700720cULL, 0x0c0fe40001f61470ULL, 0x000000334700720cULL, 0x000fc40002781470ULL,
0x000000334300720cULL, 0x080fe40002fa1470ULL, 0x000000330f00720cULL, 0x0c0fe40001741470ULL,
0x000000330f00720cULL, 0x080fe40000f21470ULL, 0x000000334000720cULL, 0x0c0fe400037c1470ULL,
0x000000334000720cULL, 0x000fe40000701470ULL, 0x0000003134587812ULL, 0x000fc400078efcffULL,
0x00000038344c7812ULL, 0x040fe400078efcffULL, 0x0000003934107812ULL, 0x000fe400078efcffULL,
0x0000005b41597219ULL, 0x000fe400000006ffULL, 0x000000330700720cULL, 0x0c0fe40001f61070ULL,
0x000000330700720cULL, 0x080fe40002781070ULL, 0x000000337c00720cULL, 0x000fc40002fa1070ULL,
0x000000337a00720cULL, 0x0c0fe40001741070ULL, 0x000000337a00720cULL, 0x080fe40000f21070ULL,
0x000000333a00720cULL, 0x0c0fe400037c1070ULL, 0x000000333a00720cULL, 0x000fe40000701070ULL,
0x0000005d415b7219ULL, 0x040fe400000006ffULL, 0x0000005f415f7219ULL, 0x000fc400000006ffULL,
0x0000541006067816ULL, 0x000fe4000000000dULL, 0x00005800585a7a10ULL, 0x000fe40007ffe0ffULL,
0x000058004c357a10ULL, 0x000fe40007ffe0ffULL, 0x00005800103b7a10ULL, 0x000fe40007ffe0ffULL,
0xff80000026267808ULL, 0x000fe40001800000ULL, 0xff8000001d1d7808ULL, 0x000fc40002000000ULL,
0xff80000027277808ULL, 0x000fe40002800000ULL, 0xff80000032327808ULL, 0x000fe40001000000ULL,
0xff80000031317808ULL, 0x000fe40000800000ULL, 0xff80000030307808ULL, 0x000fe40003000000ULL,
0xff80000021217808ULL, 0x000fe40000000000ULL, 0x0000004859ff7212ULL, 0x000fc4000786c0ffULL,
0x000000485bff7212ULL, 0x080fe4000788c0ffULL, 0x000000485fff7212ULL, 0x000fe400078ac0ffULL,
0x0000004a59ff7212ULL, 0x080fe4000784c0ffULL, 0x0000004a5bff7212ULL, 0x080fe4000782c0ffULL,
0x0000004a5fff7212ULL, 0x000fe400078cc0ffULL, 0x000000064fff7212ULL, 0x000fe2000780c0ffULL,
0x000000015a4b7824ULL, 0x100fe200078e0a4dULL, 0x000000336800720cULL, 0x0c0fe20001f61470ULL,
0x0000000135457824ULL, 0x100fe200078e0a4dULL, 0x000000336800720cULL, 0x080fe20001741470ULL,
0x000000013b4d7824ULL, 0x000fe200078e0a4dULL, 0x000000336400720cULL, 0x000fc40002781470ULL,
0x000000336400720cULL, 0x080fe40000f21470ULL, 0x000000336200720cULL, 0x0c0fe40002fa1470ULL,
0x000000336200720cULL, 0x080fe400037c1470ULL, 0x000000334600720cULL, 0x080fe40000701470ULL,
0x000000336000720cULL, 0x0c0fe40001f61070ULL, 0x000000336000720cULL, 0x000fc40001741070ULL,
0x000000335e00720cULL, 0x0c0fe40002781070ULL, 0x000000335e00720cULL, 0x080fe40000f21070ULL,
0x000000335c00720cULL, 0x0c0fe40002fa1070ULL, 0x000000335c00720cULL, 0x080fe400037c1070ULL,
0x000000334400720cULL, 0x000fe40000701070ULL, 0x0000004b414b7219ULL, 0x000fc400000006ffULL,
0x0000004541457219ULL, 0x040fe400000006ffULL, 0x0000004d414d7219ULL, 0x000fe400000006ffULL,
0x000054100e0e7816ULL, 0x000fe40000000011ULL, 0xff80000028287808ULL, 0x000fe40001800000ULL,
0xff80000012127808ULL, 0x000fe40001000000ULL, 0xff80000029297808ULL, 0x000fc40002000000ULL,
0xff80000014147808ULL, 0x000fe40000800000ULL, 0xff8000002d2d7808ULL, 0x000fe40002800000ULL,
0xff80000015157808ULL, 0x000fe40003000000ULL, 0xff8000002c2c7808ULL, 0x000fe40000000000ULL,
0x000000064bff7212ULL, 0x080fe4000786c0ffULL, 0x0000000645ff7212ULL, 0x000fc4000784c0ffULL,
0x000000064dff7212ULL, 0x000fe4000788c0ffULL, 0x0000000e4fff7212ULL, 0x080fe4000782c0ffULL,
0x0000000e4bff7212ULL, 0x080fe400078ac0ffULL, 0x0000000e45ff7212ULL, 0x080fe400078cc0ffULL,
0x0000000e4dff7212ULL, 0x000fe4000780c0ffULL, 0x000000334600720cULL, 0x000fc40000f21470ULL,
0x000000335a00720cULL, 0x0c0fe40001f61470ULL, 0x000000335a00720cULL, 0x080fe40002fa1470ULL,
0x000000333500720cULL, 0x0c0fe40001741470ULL, 0x000000333500720cULL, 0x080fe400037c1470ULL,
0x000000333b00720cULL, 0x0c0fe40002781470ULL, 0x000000333b00720cULL, 0x000fc40000701470ULL,
0x000000334400720cULL, 0x080fe40000f21070ULL, 0x000000335800720cULL, 0x0c0fe40001f61070ULL,
0x000000335800720cULL, 0x080fe40002fa1070ULL, 0x000000334c00720cULL, 0x0c0fe40001741070ULL,
0x000000334c00720cULL, 0x080fe400037c1070ULL, 0x000000331000720cULL, 0x000fc40002781070ULL,
0x000000331000720cULL, 0x000fe40000701070ULL, 0xff8000002a2a7808ULL, 0x000fe40001800000ULL,
0xff80000022227808ULL, 0x000fe40001000000ULL, 0xff80000023237808ULL, 0x000fe40002000000ULL,
0xff80000018187808ULL, 0x000fe40000800000ULL, 0xff80000019197808ULL, 0x000fc40002800000ULL,
0xff8000001a1a7808ULL, 0x000fe40003000000ULL, 0xff8000001b1b7808ULL, 0x000fc40000000000ULL,
0x000000130800720bULL, 0x004fe20003f1e000ULL, 0x0000001fff117424ULL, 0x000fe200078e00ffULL,
0x0000001e0900720bULL, 0x000fe20003f3e000ULL, 0xffffffffff367424ULL, 0x000fe200078e00ffULL,
0x0000000813077208ULL, 0x000fe40004000000ULL, 0x000000091e097208ULL, 0x000fe40004800000ULL,
0x000000240700720bULL, 0x000fc40003f1e000ULL, 0x000000160900720bULL, 0x000fe40003f3e000ULL,
0x0000000724067208ULL, 0x000fe40004000000ULL, 0x0000000916087208ULL, 0x000fe40004800000ULL,
0x000000250600720bULL, 0x000fe40003f1e000ULL, 0x000000170800720bULL, 0x000fe40003f3e000ULL,
0x0000000625077208ULL, 0x000fc40004000000ULL, 0x0000000817087208ULL, 0x000fe40004800000ULL,
0x0000002e0700720bULL, 0x000fe40003f1e000ULL, 0x0000002f0800720bULL, 0x000fe40003f3e000ULL,
0x000000072e067208ULL, 0x000fe40004000000ULL, 0x000000082f087208ULL, 0x000fe40004800000ULL,
0x0000002b0600720bULL, 0x000fc40003f1e000ULL, 0x0000001f0800720bULL, 0x000fe40003f3e000ULL,
0x000000062b077208ULL, 0x000fe40004000000ULL, 0x000000081f087208ULL, 0x000fe40004800000ULL,
0x000000260700720bULL, 0x000fe40003f1e000ULL, 0x0000001d0800720bULL, 0x000fe40003f3e000ULL,
0x0000000726067208ULL, 0x000fc40004000000ULL, 0x000000081d077208ULL, 0x000fe40004800000ULL,
0x000000270600720bULL, 0x000fe40003f1e000ULL, 0x000000200700720bULL, 0x000fe40003f3e000ULL,
0x0000000627097208ULL, 0x000fe40004000000ULL, 0x0000000720067208ULL, 0x000fe40004800000ULL,
0x000000320900720bULL, 0x000fc40003f1e000ULL, 0x000000310600720bULL, 0x000fe40003f3e000ULL,
0x0000000932097208ULL, 0x000fe40004000000ULL, 0x0000000631067208ULL, 0x000fe40004800000ULL,
0x000000300900720bULL, 0x000fe40003f1e000ULL, 0x000000210600720bULL, 0x000fe40003f3e000ULL,
0x0000000930097208ULL, 0x000fc40004000000ULL, 0x0000000621077208ULL, 0x000fe40004800000ULL,
0x000000280900720bULL, 0x000fe40003f1e000ULL, 0x000000120700720bULL, 0x000fe40003f3e000ULL,
0x0000000928067208ULL, 0x000fe40004000000ULL, 0x0000000712077208ULL, 0x000fe40004800000ULL,
0x000000290600720bULL, 0x000fc40003f1e000ULL, 0x000000140700720bULL, 0x000fe40003f3e000ULL,
0x0000000629067208ULL, 0x000fe40004000000ULL, 0x0000000714087208ULL, 0x000fe40004800000ULL,
0x0000002d0600720bULL, 0x000fe40003f1e000ULL, 0x000000150800720bULL, 0x000fe40003f3e000ULL,
0x000000062d077208ULL, 0x000fc40004000000ULL, 0x0000000815097208ULL, 0x000fe40004800000ULL,
0x0000002c0700720bULL, 0x000fe40003f1e000ULL, 0x000000180900720bULL, 0x000fe40003f3e000ULL,
0x000000072c077208ULL, 0x000fe40004000000ULL, 0x0000000918067208ULL, 0x000fe40004800000ULL,
0x0000002a0700720bULL, 0x000fc40003f1e000ULL, 0x000000190600720bULL, 0x000fe40003f3e000ULL,
0x000000072a077208ULL, 0x000fe40004000000ULL, 0x0000000619097208ULL, 0x000fe40004800000ULL,
0x000000220700720bULL, 0x000fe40003f1e000ULL, 0x0000001a0900720bULL, 0x000fe40003f3e000ULL,
0x0000000722067208ULL, 0x000fc40004000000ULL, 0x000000091a087208ULL, 0x000fe40004800000ULL,
0x000000230600720bULL, 0x000fe40003f1e000ULL, 0x0000001b0800720bULL, 0x000fe40003f3e000ULL,
0x00000006230e7208ULL, 0x000fe40004000000ULL, 0x000000081b107208ULL, 0x000fe20004800000ULL,
0x000014227f007947ULL, 0x000fec000b800000ULL, 0x0c401f000e067f89ULL, 0x0004e400000e0000ULL,
0x000000060e00720bULL, 0x008fc80003f1e000ULL, 0x0000000e06347208ULL, 0x000fe20004000000ULL,
0x000014327f007947ULL, 0x000fea000b800000ULL, 0x0c401f0010067f89ULL, 0x000ee800000e0000ULL,
0x0c401f000a077f89ULL, 0x000e6800000e0000ULL, 0x0c401f000b087f89ULL, 0x000ea800000e0000ULL,
0x0c201f0034097f89ULL, 0x000ea200000e0000ULL, 0x000000061000720bULL, 0x008fc40003f1e000ULL,
0x000000070a00720bULL, 0x002fe40003f3e000ULL, 0x00000010060c7208ULL, 0x000fe40004000000ULL,
0x0000000a070d7208ULL, 0x000fe40004800000ULL, 0x000000080b00720bULL, 0x004fe20003f1e000ULL,
0x0c201f000c0f7f89ULL, 0x000e6600000e0000ULL, 0x0000000b08067208ULL, 0x000fe20004000000ULL,
0x0c201f000d0e7f89ULL, 0x000ea200000e0000ULL, 0x000000093400720bULL, 0x000fc60003f1e000ULL,
0x0c201f0006077f89ULL, 0x0006e200000e0000ULL, 0x0000003409087208ULL, 0x000fe40004000000ULL,
0x0000000f0c00720bULL, 0x002fe40003f3e000ULL, 0x0000000e0d00720bULL, 0x004fe40003f5e000ULL,
0x0000000c0f097208ULL, 0x000fe40004800000ULL, 0x0000000d0e0a7208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b080d7820ULL, 0x008fe20000410000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000c1c1c7812ULL, 0x000fc400078ec0ffULL, 0x3fb8aa3b24247823ULL, 0x100fe2000001080dULL,
0x3fb8aa3b25257823ULL, 0x100fe2000001080dULL, 0x3fb8aa3b260b7823ULL, 0x100fe2000001080dULL,
0x3fb8aa3b27107823ULL, 0x100fe2000001080dULL, 0x00000024000f7308ULL, 0x0023e20000000800ULL,
0x3fb8aa3b13137823ULL, 0x100fe2000001080dULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe2000001080dULL,
0x3fb8aa3b28267823ULL, 0x100fe2000001080dULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe2000001080dULL,
0x3fb8aa3b32327823ULL, 0x100fe2000001080dULL, 0x3fb8aa3b29277823ULL, 0x100fe2000001080dULL,
0x3fb8aa3b2d287823ULL, 0x100fe2000001080dULL, 0x00000025000e7308ULL, 0x0007e20000000800ULL,
0x3fb8aa3b2a247823ULL, 0x102fe2000001080dULL, 0x3fb8aa3b092a7820ULL, 0x000fe20000410000ULL,
0x3fb8aa3b22227823ULL, 0x100fe2000001080dULL, 0x3fb8aa3b23237823ULL, 0x100fe2000001080dULL,
0x0000000303ff7812ULL, 0x000fe2000780c0ffULL, 0x3fb8aa3b16167823ULL, 0x100fe2000001082aULL,
0x3fb8aa3b17177823ULL, 0x100fe2000001082aULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe2000001082aULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe2000001082aULL, 0x0000000b00347308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b30257823ULL, 0x108fe2000001080dULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe2000001082aULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe2000001082aULL, 0x3fb8aa3b20207823ULL, 0x100fe2000001082aULL,
0x3fb8aa3b31317823ULL, 0x100fe2000001082aULL, 0x3fb8aa3b142d7823ULL, 0x100fe2000001082aULL,
0x3fb8aa3b21217823ULL, 0x000fe2000001082aULL, 0x00000013000c7308ULL, 0x000ee20000000800ULL,
0x3fb8aa3b2c0b7823ULL, 0x002fe2000001080dULL, 0x000000070600720bULL, 0x004fcc0003f3e000ULL,
0x0000001000337308ULL, 0x000ff00000000800ULL, 0x0000002e00117308ULL, 0x000e620000000800ULL,
0x0000000c0f0c723eULL, 0x008fce00000000ffULL, 0x0000001e000d7308ULL, 0x0005f00000000800ULL,
0x0000001600167308ULL, 0x000ee20000000800ULL, 0x0000000e110e723eULL, 0x002fe200000000ffULL,
0x3c003c00ff1e7424ULL, 0x004fcc00078e00ffULL, 0x0000001700177308ULL, 0x000ff00000000800ULL,
0x0000002f00107308ULL, 0x0002a20000000800ULL, 0x0000000d160d723eULL, 0x008fce00000000ffULL,
0x0000001f00297308ULL, 0x0007e20000000800ULL, 0x3fb8aa3b152f7823ULL, 0x002fe2000001082aULL,
0x00000017100f723eULL, 0x004fe200000000ffULL, 0x3c003c00ff1f7424ULL, 0x008fca00078e00ffULL,
0x0000001d002c7308ULL, 0x0002b00000000800ULL, 0x0000002b002b7308ULL, 0x000ee20000000800ULL,
0x3fb8aa3b121d7823ULL, 0x102fe4000001082aULL, 0x0000001e0c10723cULL, 0x000f6a00000018ffULL,
0x0000003200327308ULL, 0x000e620000000800ULL, 0x000000292c15723eULL, 0x004fe200000000ffULL,
0x3fb8aa3b1a297823ULL, 0x000fcc000001082aULL, 0x0000002000207308ULL, 0x000fe20000000800ULL,
0x0000002b3414723eULL, 0x008fe200000000ffULL, 0x3fb8aa3b1b2b7823ULL, 0x000fcc000001082aULL,
0x0000003100317308ULL, 0x000ea20000000800ULL, 0x000000333216723eULL, 0x002fe400000000ffULL,
0x00000002ff327819ULL, 0x000fc80000011603ULL, 0x00000001322c7810ULL, 0x040fe20007ffe0ffULL,
0x0000001d002e7308ULL, 0x0003e20000000800ULL, 0x0000000832337824ULL, 0x040fe400078e00ffULL,
0x0000000832347824ULL, 0x040fe400078e00ffULL, 0x0000000832377824ULL, 0x000fe200078e00ffULL,
0x000000203117723eULL, 0x004fe200000000ffULL, 0x3fb8aa3b181d7823ULL, 0x102fe2000001082aULL,
0x3fb8aa3b19207823ULL, 0x000fe2000001082aULL, 0x0000002500257308ULL, 0x000fe20000000800ULL,
0x0000000232317810ULL, 0x000fc60007ffe0ffULL, 0x0000001e1418723cULL, 0x020b620000001810ULL,
0xfffffff834317812ULL, 0x000fc600078ee231ULL, 0x0000002600267308ULL, 0x000fe60000000800ULL,
0x0000000832137824ULL, 0x060fe200078e00ffULL, 0x0000000332107810ULL, 0x040fe20007ffe0ffULL,
0x0000000832127824ULL, 0x040fe200078e00ffULL, 0x0000000432117810ULL, 0x000fe40007ffe0ffULL,
0x0000002700277308ULL, 0x000fe40000000800ULL, 0xfffffff812357812ULL, 0x000fcc00078ee211ULL,
0x0000002800287308ULL, 0x000e700000000800ULL, 0x0000002100217308ULL, 0x000eb00000000800ULL,
0x0000002d002d7308ULL, 0x000fe20000000800ULL, 0x000000272812723eULL, 0x002fe200000000ffULL,
0x0000000832277824ULL, 0x040fe200078e00ffULL, 0xffffffff32287810ULL, 0x000fc80007ffe0ffULL,
0xfffffff837377812ULL, 0x000fe200078ee228ULL, 0x0000002f00307308ULL, 0x0002e20000000800ULL,
0x000000212e11723eULL, 0x004fe200000000ffULL, 0x00000008322e7824ULL, 0x040fe200078e00ffULL,
0x0000000632217810ULL, 0x000fca0007ffe0ffULL, 0x0000002200227308ULL, 0x000fe20000000800ULL,
0xfffffff8332f7812ULL, 0x002fe400078ee22cULL, 0xfffffff813337812ULL, 0x000fe400078ee210ULL,
0x000000252610723eULL, 0x000fe200000000ffULL, 0x0000000832257824ULL, 0x040fe200078e00ffULL,
0x00000008322c7810ULL, 0x000fe20007ffe0ffULL, 0x0000002300237308ULL, 0x000e620000000800ULL,
0x0000002d3013723eULL, 0x008fe400000000ffULL, 0xfffffff82e2d7812ULL, 0x000fe200078ee221ULL,
0x000000082c397824ULL, 0x000fe200078e00ffULL, 0xfffffff825257812ULL, 0x000fc600078ee232ULL,
0x0000001e1018723cULL, 0x000f620000001818ULL, 0x0000000b000b7308ULL, 0x000fe20000000800ULL,
0x000000222322723eULL, 0x002fce00000000ffULL, 0x0000002400247308ULL, 0x000e700000000800ULL,
0x0000001d001d7308ULL, 0x000ff00000000800ULL, 0x00000020002a7308ULL, 0x0004f00000000800ULL,
0x0000002900297308ULL, 0x000fe20000000800ULL, 0x0000000532207810ULL, 0x004fc80007ffe0ffULL,
0xfffffff827277812ULL, 0x000fe400078ee220ULL, 0x0000000b2420723eULL, 0x002fe200000000ffULL,
0x0000002b00267308ULL, 0x0002a20000000800ULL, 0x0000001d2a21723eULL, 0x008fe400000000ffULL,
0x0000900000247811ULL, 0x000fe400078e58ffULL, 0x00000006070b7208ULL, 0x000fc60004800000ULL,
0x0000001025257824ULL, 0x000fe200078e0224ULL, 0xfffffff8392b7812ULL, 0x002fe200078ee22cULL,
0x000000102f2f7824ULL, 0x100fe400078e0224ULL, 0x0000001031317824ULL, 0x100fe400078e0224ULL,
0x0000001033337824ULL, 0x100fe200078e0224ULL, 0x000000292623723eULL, 0x004fe200000000ffULL,
0x0000001035357824ULL, 0x000fe400078e0224ULL, 0x0000000125257824ULL, 0x000fc400078e021cULL,
0x0000001027277824ULL, 0x100fe400078e0224ULL, 0x0000001e2018723cULL, 0x020f620000001818ULL,
0x000000011c2f7824ULL, 0x040fe200078e022fULL, 0x0000000c25007388ULL, 0x0003e20000000800ULL,
0x000000102d2d7824ULL, 0x100fe400078e0224ULL, 0x000000011c317824ULL, 0x040fe200078e0231ULL,
0x0000000e2f007388ULL, 0x0003e20000000800ULL, 0x0000001037377824ULL, 0x100fe400078e0224ULL,
0x000000011c337824ULL, 0x000fe200078e0233ULL, 0x0000001431007388ULL, 0x0003e20000000800ULL,
0x000000102b2b7824ULL, 0x000fc400078e0224ULL, 0x000000011c357824ULL, 0x040fe200078e0235ULL,
0x0000001633007388ULL, 0x0003e20000000800ULL, 0x000000011c277824ULL, 0x040fe400078e0227ULL,
0x000000011c2d7824ULL, 0x040fe200078e022dULL, 0x0000001035007388ULL, 0x0003e20000000800ULL,
0x000000011c377824ULL, 0x040fe400078e0237ULL, 0x000000011c1c7824ULL, 0x000fe200078e022bULL,
0x0000001227007388ULL, 0x0003e40000000800ULL, 0x000000ffff197224ULL, 0x020fc400078e001aULL,
0x000000202d007388ULL, 0x0003e80000000800ULL, 0x0000002237007388ULL, 0x0003e80000000800ULL,
0x0000000d1c007388ULL, 0x0003e80000000800ULL, 0x0004000f2f007388ULL, 0x0003e80000000800ULL,
0x0004001531007388ULL, 0x0003e80000000800ULL, 0x0004001733007388ULL, 0x0003e80000000800ULL,
0x0004001135007388ULL, 0x0003e80000000800ULL, 0x0004001327007388ULL, 0x0003e80000000800ULL,
0x000400212d007388ULL, 0x0003e80000000800ULL, 0x0004002337007388ULL, 0x0003e80000000800ULL,
0x00f0000805008388ULL, 0x0003e80000000c00ULL, 0x00f2001805008388ULL, 0x0003e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000079ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000080079ff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000100079ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000167677810ULL, 0x000fe20007ffe0ffULL,
0x0000180079ff7f8cULL, 0x0003e6000c80043fULL, 0x0000006c6700720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffb67000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff0e7807ULL, 0x002fe40004000000ULL,
0x0001212000127802ULL, 0x000fc40000000f00ULL, 0x00000bc000007944ULL, 0x018fea0003c00000ULL,
0xffff048000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0e7807ULL, 0x000fe40005000000ULL,
0x0001216000127802ULL, 0x000fc40000000f00ULL, 0x00000b8000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff097224ULL, 0x000fe200078e000eULL, 0xffff04e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0f7224ULL, 0x000fe200078e0039ULL, 0x000121b000137802ULL, 0x000fc40000000f00ULL,
0x00000ae000007944ULL, 0x018fea0003c00000ULL, 0xffff05d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0f7224ULL, 0x000fe200078e0039ULL, 0x000121f000137802ULL, 0x000fc40000000f00ULL,
0x00000aa000007944ULL, 0x018fea0003c00000ULL, 0xffff06f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0f7224ULL, 0x000fe200078e000dULL, 0x0001224000137802ULL, 0x000fe20000000f00ULL,
0x000000ffff0e7224ULL, 0x000fc400078e000cULL, 0x00000a5000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0012ULL, 0xffff0b1000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0f7224ULL, 0x000fe200078e000dULL, 0x0001229000137802ULL, 0x000fc40000000f00ULL,
0x00000a0000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff027224ULL, 0x004fe200078e0012ULL,
0xffff0af000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0e7807ULL, 0x002fe40004000000ULL,
0x000122e000127802ULL, 0x000fc40000000f00ULL, 0x00000a0000007944ULL, 0x004fea0003c00000ULL,
0xffff2a5000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0e7807ULL, 0x000fe40005000000ULL,
0x0001232000127802ULL, 0x000fc40000000f00ULL, 0x000009c000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e000eULL, 0xffff2aa000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0f7224ULL, 0x000fe200078e000dULL, 0x0001237000137802ULL, 0x000fc40000000f00ULL,
0x0000092000007944ULL, 0x004fea0003c00000ULL, 0xffff2b9000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0f7224ULL, 0x000fe200078e000dULL, 0x000123b000137802ULL, 0x000fc40000000f00ULL,
0x000008e000007944ULL, 0x004fea0003c00000ULL, 0xffff2cb000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0f7224ULL, 0x000fe200078e0009ULL, 0x0001240000137802ULL, 0x000fe20000000f00ULL,
0x000000ffff0e7224ULL, 0x000fc400078e0030ULL, 0x0000089000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0012ULL, 0xffff30e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0f7224ULL, 0x000fe200078e0009ULL, 0x0001245000137802ULL, 0x000fc40000000f00ULL,
0x0000084000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff027224ULL, 0x004fe200078e0012ULL,
0xffff30c000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0e7807ULL, 0x004fe40004000000ULL,
0x000124a000127802ULL, 0x000fc40000000f00ULL, 0x0000084000007944ULL, 0x018fea0003c00000ULL,
0xffff4e5000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0e7807ULL, 0x000fe40005000000ULL,
0x000124e000127802ULL, 0x000fc40000000f00ULL, 0x0000080000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e000eULL, 0xffff4ea000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0f7224ULL, 0x000fe200078e0039ULL, 0x0001253000137802ULL, 0x000fc40000000f00ULL,
0x0000076000007944ULL, 0x018fea0003c00000ULL, 0xffff4f9000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0f7224ULL, 0x000fe200078e0039ULL, 0x0001257000137802ULL, 0x000fc40000000f00ULL,
0x0000072000007944ULL, 0x018fea0003c00000ULL, 0xffff50b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0f7224ULL, 0x000fe200078e000cULL, 0x000125c000137802ULL, 0x000fe20000000f00ULL,
0x000000ffff0e7224ULL, 0x000fc400078e0011ULL, 0x000006d000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0012ULL, 0xffff54e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0f7224ULL, 0x000fe200078e000cULL, 0x0001261000137802ULL, 0x000fc40000000f00ULL,
0x0000068000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff027224ULL, 0x004fe200078e0012ULL,
0xffff54c000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0e7807ULL, 0x004fe40004000000ULL,
0x0001266000127802ULL, 0x000fc40000000f00ULL, 0x0000068000007944ULL, 0x018fea0003c00000ULL,
0xffff72b000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0e7807ULL, 0x000fe40005000000ULL,
0x000126a000127802ULL, 0x000fc40000000f00ULL, 0x0000064000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff107224ULL, 0x000fe200078e000eULL, 0xffff730000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0f7224ULL, 0x000fe200078e0033ULL, 0x000126f000137802ULL, 0x000fc40000000f00ULL,
0x000005a000007944ULL, 0x018fea0003c00000ULL, 0xffff73f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0f7224ULL, 0x000fe200078e0033ULL, 0x0001273000137802ULL, 0x000fc40000000f00ULL,
0x0000056000007944ULL, 0x018fea0003c00000ULL, 0xffff751000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0f7224ULL, 0x000fe200078e0006ULL, 0x0001278000137802ULL, 0x000fe20000000f00ULL,
0x000000ffff0e7224ULL, 0x000fc400078e0031ULL, 0x0000051000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0012ULL, 0xffff798000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0f7224ULL, 0x000fe200078e0006ULL, 0x000127d000137802ULL, 0x000fc40000000f00ULL,
0x000004c000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff027224ULL, 0x004fe200078e0012ULL,
0xffff796000007947ULL, 0x000fea000383ffffULL, 0x00000002ff0f7424ULL, 0x000fe200078e00ffULL,
0x00012820000c7802ULL, 0x000fc40000000f00ULL, 0x0000043000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e0007ULL, 0xffffeba000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x006fe200078e0010ULL, 0x00012880000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff0f7424ULL, 0x000fc400078e00ffULL, 0x000003d000007944ULL, 0x010fea0003c00000ULL,
0x000000071000720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e000aULL,
0x000128e0000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000001007107208ULL, 0x000fc80004000000ULL, 0x0000037000007944ULL, 0x000fea0003c00000ULL,
0x000000070a00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e000bULL,
0x00012940000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000000a070a7208ULL, 0x000fc80004000000ULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x000000070b00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e0034ULL,
0x000129a0000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000000b07067208ULL, 0x000fc80004000000ULL, 0x000002b000007944ULL, 0x000fea0003c00000ULL,
0x000000073400720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e0010ULL,
0x00012a00000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000003407087208ULL, 0x000fc80004000000ULL, 0x0000025000007944ULL, 0x000fea0003c00000ULL,
0x000000071000720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e000aULL,
0x00012a60000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000001007097208ULL, 0x000fc80004000000ULL, 0x000001f000007944ULL, 0x000fea0003c00000ULL,
0x000000070a00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e0006ULL,
0x00012ac0000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000000a070a7208ULL, 0x000fc80004000000ULL, 0x0000019000007944ULL, 0x000fea0003c00000ULL,
0xffffea7000007947ULL, 0x000fea000383ffffULL, 0x018000000a007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000000a00008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff0aff7812ULL, 0x040fe4000780c0ffULL,
0x800000000a027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000a00007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffed3b002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000003600007348ULL, 0x000fe80003800000ULL, 0x0c00000f0e077389ULL, 0x0002a200000e0011ULL,
0xfffed3700c007950ULL, 0x000fea0003c3ffffULL, 0x0000007100007348ULL, 0x000fe80003800000ULL,
0x0000000e0f127389ULL, 0x0002a400000e0075ULL, 0x000000ffff0e7224ULL, 0x002fc400078e0013ULL,
0x00000000ff0f7424ULL, 0x000fc800078e00ffULL, 0xfffed3200e007950ULL, 0x000fea0003c3ffffULL,
0x000000010e00780cULL, 0x000fe20003f45070ULL, 0x00000000ff137424ULL, 0x000fe200078e00ffULL,
0x0000007000007348ULL, 0x000ff60003800000ULL, 0x00000000000e7806ULL, 0x000fc800050e0100ULL,
0x000000700e0e7212ULL, 0x000fe200078ec0ffULL, 0xfffed2c012007950ULL, 0x000fec0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000004ULL, 0x0000000100000001ULL, 0x0000001000000008ULL, 0x0000000400000001ULL,
0x0000000800000008ULL, 0x0000000800000001ULL, 0x0000000200000001ULL, 0x0000000400000003ULL,
0x0000000300000004ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005f4ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000750ULL, 0x00000000000002a0ULL, 0x0000001b00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009f0ULL, 0x00000000000003c8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000db8ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e78ULL, 0x00000000000007bcULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001638ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001648ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000016d8ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000016dcULL, 0x00000000000001c0ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001900ULL, 0x0000000000012e00ULL, 0x8000001b00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000014700ULL, 0x0000000000000048ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000014750ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000014ad0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x00000000000016d8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000013028ULL, 0x0000000000013028ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000014700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000014ad0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_pagedKV_128_nqpkv_0_m_16_sm_89_cubin_len = 84912;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
