/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_pagedKV_128_nqpkv_0_m_16_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x00000000000141c0ULL, 0x0000000000013e40ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x65722e0000000000ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x72655073776f7200ULL, 0x6e2e006b636f6c42ULL,
0x6174736e6f632e76ULL, 0x000000000033746eULL, 0x657a69536d656d73ULL, 0x7563344e5a5a5f00ULL,
0x5f33647473336164ULL, 0x7465645f5f38345fULL, 0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL,
0x75635f726564726fULL, 0x5f37456969456164ULL, 0x5f006d726f66785fULL, 0x727241374b4e5a5aULL,
0x6a4c664944327961ULL, 0x324545326a4c4532ULL, 0x454530624c497461ULL, 0x31456a6a664b5245ULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL,
0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL, 0x497461324545386aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3053ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x5f5f374944327961ULL, 0x326a4c32666c6168ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL,
0x456a6a5f30534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL,
0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL, 0x497461324545386aULL,
0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x316a4c4536316a4cULL,
0x4c49746132454536ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x45386a4c4534366aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL,
0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL, 0x454530624c497461ULL,
0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL,
0x4944327961727241ULL, 0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL, 0x45326a4c4545316aULL,
0x7461324545316a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL,
0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x4939494432796172ULL, 0x74614d6e4974736eULL,
0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL, 0x534b524545453062ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x736e493949443279ULL, 0x4c4974614d6e4974ULL, 0x4545326a4c45326aULL, 0x45316a4c45346a4cULL,
0x30624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL,
0x324545386a4c4532ULL, 0x454531624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL,
0x4c45326a4c497461ULL, 0x45326a4c4545326aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL,
0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL,
0x5633494432796172ULL, 0x45346a4c6a496365ULL, 0x6a4c4536316a4c45ULL, 0x4c49746132454538ULL,
0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x000000676e696469ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x6e695f5f24000000ULL, 0x305f6c616e726574ULL,
0x616475635f5f245fULL, 0x63725f30326d735fULL, 0x7a74665f6e725f70ULL, 0x6f6c735f3233665fULL,
0x722e006874617077ULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL, 0x616c65722e006168ULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x6c656e72656b2400ULL, 0x656d732461686d5fULL,
0x667542657479426dULL, 0x5f67756265642e00ULL, 0x722e00656d617266ULL, 0x67756265642e6c65ULL,
0x2e00656d6172665fULL, 0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6e6f632e766e2e00ULL,
0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL, 0x0000000000000061ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a00030000004bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b000100000096ULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x00090003000000a3ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b5ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b0001000000beULL, 0x0000000000000038ULL, 0x0000000000000010ULL,
0x000b0001000000fcULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000b000100000135ULL,
0x0000000000000030ULL, 0x0000000000000004ULL, 0x000b00010000017cULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000b0001000001beULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000b000100000204ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000b00010000024bULL,
0x0000000000000034ULL, 0x0000000000000004ULL, 0x000b000100000291ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000b0001000002dfULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000b00010000032dULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b00010000037bULL,
0x000000000000002cULL, 0x0000000000000004ULL, 0x000b0001000003c9ULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000b00010000040fULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000b00010000045dULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x0000010000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a0022000004b8ULL, 0x0000000000012790ULL,
0x0000000000000270ULL, 0x000400030000052eULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a101200000040ULL, 0x0000000000000000ULL, 0x0000000000012a00ULL, 0x000d00030000055eULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000024ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0001279000000000ULL,
0x0000140400000000ULL, 0x0008288080810c00ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL,
0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808492ULL, 0x0000002cffffffffULL,
0x0000006000000000ULL, 0x0001279000000000ULL, 0x0000027000000000ULL, 0x0000580400000000ULL,
0x8082288080840900ULL, 0x0000000000002880ULL, 0x0000001700082f04ULL, 0x0008230400000080ULL,
0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000008ULL, 0x0000000800000015ULL,
0x0000001700082304ULL, 0x0008120400000000ULL, 0x0000000800000017ULL, 0x0000001700081104ULL,
0x0004370400000008ULL, 0x000c17040000007bULL, 0x0058000900000000ULL, 0x000c17040021f000ULL,
0x0050000800000000ULL, 0x000c17040021f000ULL, 0x0048000700000000ULL, 0x000c17040011f000ULL,
0x0028000600000000ULL, 0x000c17040081f000ULL, 0x0020000500000000ULL, 0x000c17040021f000ULL,
0x0018000400000000ULL, 0x000c17040021f000ULL, 0x0010000300000000ULL, 0x000c17040021f000ULL,
0x0008000200000000ULL, 0x000c17040011f000ULL, 0x0004000100000000ULL, 0x000c17040011f000ULL,
0x0000000000000000ULL, 0x00801b030011f000ULL, 0xffffffff00942904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x000003c000942804ULL, 0x0000098000000400ULL, 0x000028c000002830ULL,
0x00002ad000002990ULL, 0x0000302000003010ULL, 0x00004c3000004bc0ULL, 0x00004e7000004d30ULL,
0x0000528000005270ULL, 0x00006e1000006d70ULL, 0x0000702000006ee0ULL, 0x0000743000007420ULL,
0x00008fe000008f70ULL, 0x00009220000090e0ULL, 0x0000976000009750ULL, 0x0000a8600000a850ULL,
0x00011c8000011bd0ULL, 0x00011f5000011eb0ULL, 0x0001224000011ff0ULL, 0x000124c0000123f0ULL,
0x0000048004303904ULL, 0x00017600000000ffULL, 0x0000056000040100ULL, 0x0001760800000008ULL,
0x00000670003f0100ULL, 0x0001768800000008ULL, 0x000007a0003f0100ULL, 0x000176a800000004ULL,
0x000008b0003f0100ULL, 0x000176c800000002ULL, 0x00000e10003f0100ULL, 0x00017600000000ffULL,
0x00000f9000070107ULL, 0x0001768800000004ULL, 0x00001880003f0101ULL, 0x00000000000000ffULL,
0x000018b000040107ULL, 0x00000000000000ffULL, 0x0000193000040101ULL, 0x0000002000000006ULL,
0x00001a80003f0101ULL, 0x000176c800000009ULL, 0x00001c1000070109ULL, 0x000176c80000000fULL,
0x000024e0003f0109ULL, 0x000176b000000006ULL, 0x000025b000070107ULL, 0x000176b000000046ULL,
0x000025c0003f0101ULL, 0x0001760800000009ULL, 0x000025e0003f0101ULL, 0x0001760800000009ULL,
0x00002750003f0109ULL, 0x0001760800000009ULL, 0x00002c90003f0109ULL, 0x000176a800000002ULL,
0x00002e1000070109ULL, 0x000176a800000010ULL, 0x00003fa0003f0109ULL, 0x000176c80000003cULL,
0x00003fb0003f0101ULL, 0x0001768800000013ULL, 0x00003fd000070101ULL, 0x000000000000000aULL,
0x00004140003f0109ULL, 0x000000000000000aULL, 0x00004930003f0109ULL, 0x000176a800000014ULL,
0x0000498000070107ULL, 0x000176a800000015ULL, 0x00004990003f0101ULL, 0x0001762800000009ULL,
0x000049b0003f0101ULL, 0x0001762800000009ULL, 0x00004b20003f0109ULL, 0x0001762800000009ULL,
0x00005040003f0109ULL, 0x000176b00000001bULL, 0x000051c000070109ULL, 0x000176b00000003fULL,
0x00006100003f0109ULL, 0x000176c80000003cULL, 0x00006120003f0101ULL, 0x0001769000000042ULL,
0x0000615000070101ULL, 0x000000000000000aULL, 0x000062c0003f0109ULL, 0x000000000000000aULL,
0x00006a50003f0109ULL, 0x00000008000000ffULL, 0x00006b2000040107ULL, 0x0000000800000013ULL,
0x00006b30003f0101ULL, 0x0001764800000009ULL, 0x00006b50003f0101ULL, 0x0001764800000009ULL,
0x00006cc0003f0109ULL, 0x0001764800000009ULL, 0x000071f0003f0109ULL, 0x000176a800000011ULL,
0x0000737000070109ULL, 0x000176a800000013ULL, 0x000082f0003f0109ULL, 0x000176c800000011ULL,
0x00008330003f0101ULL, 0x0001769800000015ULL, 0x00008380003f0101ULL, 0x000000000000000aULL,
0x000084f0003f0109ULL, 0x000000000000000aULL, 0x00008ce0003f0109ULL, 0x00000000000000ffULL,
0x00008d3000040107ULL, 0x000176a800000010ULL, 0x00008d40003f0101ULL, 0x000176680000000cULL,
0x00008d70003f0101ULL, 0x000176680000000cULL, 0x00008ee0003f0109ULL, 0x000176680000000cULL,
0x000093e0003f0109ULL, 0x000176b00000001dULL, 0x000095b0003f0109ULL, 0x000176b00000001dULL,
0x0000a470003f0109ULL, 0x000176a800000010ULL, 0x0000a6b0003f0101ULL, 0x000176a00000000fULL,
0x0000b790003f0101ULL, 0x00017600000000ffULL, 0x0000d0c000070101ULL, 0x00017600000000ffULL,
0x0000d23000070109ULL, 0x00017600000000ffULL, 0x0000d41000070109ULL, 0x00017600000000ffULL,
0x0000d43000070101ULL, 0x00017600000000ffULL, 0x0000d5a000070109ULL, 0x00017600000000ffULL,
0x0001020000070109ULL, 0x0001768800000004ULL, 0x000103d0003f0101ULL, 0x0001768800000004ULL,
0x00010540003f0109ULL, 0x0001768800000004ULL, 0x00012730003f0109ULL, 0x000176080000006fULL,
0x00012740003f0101ULL, 0x000176100000006fULL, 0x00012750003f0101ULL, 0x000176180000006fULL,
0x00012760003f0101ULL, 0x000176200000006fULL, 0x00053803003f0101ULL, 0x0000b0b000201c04ULL,
0x0000b2d00000b110ULL, 0x0000b5c00000b430ULL, 0x0000d5d00000b6c0ULL, 0x000c050400012780ULL,
0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0060190300000000ULL, 0x0000001800080a04ULL,
0x0000000000600210ULL, 0x00000000000000bcULL, 0x0000001700000002ULL, 0x0000000000012790ULL,
0x0000000000000044ULL, 0x0000001700000002ULL, 0x0000000000000000ULL, 0x0000000000000098ULL,
0x0000001700000002ULL, 0x0000000000000000ULL, 0x0000000000017700ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e700000000800ULL, 0x00008400ff067b82ULL, 0x000ea20000000a00ULL,
0x00000000000b7919ULL, 0x000ee20000002200ULL, 0x0000049000007945ULL, 0x000fe20003800000ULL,
0xfffffff801017836ULL, 0x002fe20000000000ULL, 0x0000000000097919ULL, 0x000e680000002100ULL,
0x00000400ff047b82ULL, 0x000f220000000800ULL, 0x0000000000527919ULL, 0x000f620000002600ULL,
0x0000010000047ab9ULL, 0x000fcc0000000800ULL, 0x00008600ff0f7b82ULL, 0x000e620000000800ULL,
0x0000000700007306ULL, 0x004ea20000209000ULL, 0x000000ff0700720cULL, 0x000fce0003f45070ULL,
0x0000000000007308ULL, 0x004ea40000001000ULL, 0x0ffffffe00027836ULL, 0x004fcc0000000000ULL,
0x0000000200037305ULL, 0x000464000021f000ULL, 0x000000ffff027224ULL, 0x004fe400078e00ffULL,
0x000000ffff087224ULL, 0x002fc800078e0a03ULL, 0x0000000708057224ULL, 0x000fe400078e02ffULL,
0x0000000000087919ULL, 0x000ee40000002300ULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x0000000403057227ULL, 0x010fc800078e00ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a05ULL,
0x0000000307007224ULL, 0x000fca00078e0204ULL, 0x000000070000720cULL, 0x000fda0003f06070ULL,
0x0000000100000824ULL, 0x000fe400078e0a07ULL, 0x0000000105050836ULL, 0x000fc60000000000ULL,
0x000000070000720cULL, 0x000fda0003f26070ULL, 0x0000000105051836ULL, 0x000fe20000000000ULL,
0x00000007ff05a212ULL, 0x000fc800078e33ffULL, 0x0000000500007306ULL, 0x000e620000209000ULL,
0x000000ff0500720cULL, 0x000fce0003f45070ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027836ULL, 0x002fe40000000000ULL, 0x0000000408007c24ULL, 0x008fe2000f8e020bULL,
0x0000000000047ab9ULL, 0x000fc60000000800ULL, 0x0000000200037305ULL, 0x0002a4000021f000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x0000000305047224ULL, 0x004fc800078e02ffULL,
0x000000ffff0d7224ULL, 0x000fc800078e0a04ULL, 0x0000000d03037227ULL, 0x000fc800078e0002ULL,
0x0000000400027c24ULL, 0x000fe4000f8e0209ULL, 0x00000052034e7227ULL, 0x020fc600078e00ffULL,
0x0000007f0200780cULL, 0x040fe20003f64070ULL, 0x000000ffff037224ULL, 0x000fe200078e0a4eULL,
0x000000030200780cULL, 0x000fc60003f84070ULL, 0x0000000305007224ULL, 0x000fe400078e0252ULL,
0x0000000000037919ULL, 0x000e660000002700ULL, 0x000000050000720cULL, 0x000fc60003f06070ULL,
0x00000000000bb919ULL, 0x000eb40000008800ULL, 0x0000000100000824ULL, 0x000fc400078e0a05ULL,
0x000000014e4e0836ULL, 0x000fe20000000000ULL, 0x000000ff0200720cULL, 0x000fe40003f05270ULL,
0x000000050000720cULL, 0x000fe40003f26070ULL, 0x000004000000b802ULL, 0x000fd60000000f00ULL,
0x000000014e4e1836ULL, 0x000fe20000000000ULL, 0x00000005ff4ea212ULL, 0x000fe400078e33ffULL,
0x0000000f0200780cULL, 0x040fe40003f24070ULL, 0x000006540b0bb816ULL, 0x004fe20000000000ULL,
0x000000ffff047224ULL, 0x000fe200078e0a4eULL, 0x00000005ff007819ULL, 0x000fe40000011609ULL,
0x00001fff08097589ULL, 0x0004e200000e0000ULL, 0x0000000405527224ULL, 0x000fe200078e0252ULL,
0x000000010200780cULL, 0x040fe20003f44070ULL, 0xff317217ff05b424ULL, 0x000fe200078e00ffULL,
0x00001fff00007589ULL, 0x000e6200000e0000ULL, 0x000000040204b824ULL, 0x000fe200078e020bULL,
0x0000000000240947ULL, 0x002ff20003800000ULL, 0x00000000000579c3ULL, 0x000f220000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x001fff0000067882ULL, 0x000fe20000000000ULL,
0x7ffc000000077882ULL, 0x000fe20000000000ULL, 0x0000065405047896ULL, 0x010fe20008000004ULL,
0x0000000000007918ULL, 0x004fe20000000000ULL, 0x00000000000073c6ULL, 0x000eb40000000000ULL,
0x01760006043f75b2ULL, 0x0004a40008000100ULL, 0x0000000000007918ULL, 0x00cfe20000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000381947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000f220000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x010fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000402087c11ULL, 0x004fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000080612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ea40000000000ULL, 0x01760804063f75b2ULL, 0x0004b00008000100ULL,
0xfffffffd00e81947ULL, 0x00cfea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000384947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000f220000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x010fc60008000004ULL,
0x7ffb000000057882ULL, 0x000fc60000000000ULL, 0x0000000402087c11ULL, 0x004fe2000f8e18ffULL,
0x001ffec000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000080612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000ea40000000000ULL,
0x01768804063f75b2ULL, 0x0004b00008000100ULL, 0xfffffffd00e81947ULL, 0x00cfea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x017400050400b388ULL, 0x0005e20000000800ULL,
0x0000011000007945ULL, 0x000fe20003800000ULL, 0x00000010527c7824ULL, 0x000fc600078e00ffULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000f220000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x010fc60008000004ULL, 0x7ffc000000057882ULL, 0x000fc60000000000ULL,
0x0000000402047c11ULL, 0x004fe2000f8e18ffULL, 0x001fff0000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000040612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ea40000000000ULL, 0x0176a804063f75b2ULL, 0x0004b00008000100ULL,
0xfffffffd00e81947ULL, 0x00cfea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000382947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000f220000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x010fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x0000000402027c11ULL, 0x000fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x004fca0000000000ULL,
0x00000000020612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000ea40000000000ULL,
0x0176c804063f75b2ULL, 0x0004b00008000100ULL, 0xfffffffd00e81947ULL, 0x00cfea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ffff507224ULL, 0x000fe200078e0a7cULL,
0x0000000f06057219ULL, 0x084fe200000006ffULL, 0x0000000603067224ULL, 0x002fe200078e02ffULL,
0x0000000f07517219ULL, 0x080fe200000006ffULL, 0x0000000409047824ULL, 0x008fe200078e0200ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000007c0500720cULL, 0x000fe20003f06070ULL,
0x0000820000087ab9ULL, 0x000fe20000000a00ULL, 0x0000001005507446ULL, 0x000fe20003800050ULL,
0x0000000204057824ULL, 0x000fe200078e00ffULL, 0x0000000f4e027219ULL, 0x000fc400000006ffULL,
0x000000ff50507207ULL, 0x000fc60000000000ULL, 0x0000005106027224ULL, 0x000fe200078e0202ULL,
0x000000105000780cULL, 0x000fda0003f05270ULL, 0x0000000000848947ULL, 0x000fea0003800000ULL,
0x00000000000e7919ULL, 0x000e620000000000ULL, 0xffffffffff047424ULL, 0x000fe200078e00ffULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000000117919ULL, 0x000ea60000008800ULL,
0x0000000f040d7219ULL, 0x000fe400000006ffULL, 0x00000004ff087819ULL, 0x002fca000001160eULL,
0x00000001050b7824ULL, 0x000fc800078e0208ULL, 0x000000017c047824ULL, 0x000fca00078e020bULL,
0x0000000d040d7212ULL, 0x000fe400078e30ffULL, 0x0000000fff067219ULL, 0x000fe40000011604ULL,
0x0000000550047248ULL, 0x000fe20007fe0000ULL, 0x00000001020d7824ULL, 0x000fe200078e020dULL,
0x0000040000027802ULL, 0x000fc60000000f00ULL, 0x00000051060d7224ULL, 0x000fe200078e020dULL,
0x0000065411117816ULL, 0x004fe20000000002ULL, 0x000000100e027824ULL, 0x000fe400078e00ffULL,
0x0000000104067824ULL, 0x000fe200078e0a05ULL, 0x00000000110772caULL, 0x000fe200000e0000ULL,
0x000001000d047825ULL, 0x000fe200078e00ffULL, 0x000000f0020d7812ULL, 0x000fe400078ec0ffULL,
0x000000060800720cULL, 0x000fe20003f06070ULL, 0x000000010b067824ULL, 0x040fe200078e020eULL,
0x0000000d040d7212ULL, 0x000fe200078efcffULL, 0x000000100b0b7824ULL, 0x000fc600078e00ffULL,
0x000000040d047c10ULL, 0x000fe4000ff3e0ffULL, 0xfffffff00b067812ULL, 0x000fe400078ee206ULL,
0x0000000505057c10ULL, 0x000fe40008ffe4ffULL, 0x00000007060b7c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040b7faeULL, 0x0003e2000c101c48ULL,
0x0000000000707947ULL, 0x000fea0003800000ULL, 0x00000000000e7919ULL, 0x000e620000000000ULL,
0xffffffffff047424ULL, 0x000fe200078e00ffULL, 0x00008a0000047ab9ULL, 0x000fe20000000a00ULL,
0x00000000000d7919ULL, 0x000ea20000008800ULL, 0x000000050e0b7211ULL, 0x002fe400078fe0ffULL,
0x0000000f04057219ULL, 0x000fc600000006ffULL, 0x000000017c047824ULL, 0x000fe400078e020bULL,
0x000000010b067824ULL, 0x040fe400078e020eULL, 0x000000100b0b7824ULL, 0x000fe200078e00ffULL,
0x0000000504057212ULL, 0x000fe400078e30ffULL, 0x0000000fff047219ULL, 0x000fe40000011604ULL,
0xfffffff00b067812ULL, 0x000fe200078ee206ULL, 0x0000000102057824ULL, 0x000fe200078e0205ULL,
0x0000040000027802ULL, 0x000fc60000000f00ULL, 0x0000005104047224ULL, 0x000fe200078e0205ULL,
0x000006540d0d7816ULL, 0x004fe20000000002ULL, 0x000000100e027824ULL, 0x000fe400078e00ffULL,
0x0000010004047825ULL, 0x000fe200078e00ffULL, 0x000000000d0772caULL, 0x000fe400000e0000ULL,
0x000000f0020d7812ULL, 0x000fc800078ec0ffULL, 0x0000000d04047212ULL, 0x000fc800078efcffULL,
0x0000000404047c10ULL, 0x000fc6000ff1e0ffULL, 0x00000007060b7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000505057c10ULL, 0x000fca00087fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040b7faeULL, 0x0003e6000b901c48ULL, 0x0001760007047890ULL, 0x000fe2000fffe03fULL,
0x00009200ff047b82ULL, 0x002e620000000a00ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x000000ffffff79a7ULL, 0x000fe20008200404ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a84ULL,
0x0000000403047825ULL, 0x002fe200078e0004ULL, 0x0000000000007918ULL, 0x000fc80000000000ULL,
0x00000008047a7981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0900720cULL, 0x000fe20003f05270ULL,
0x0000007f7a7d7836ULL, 0x004fe40000000000ULL, 0x000000ff7a067836ULL, 0x000fc60000000000ULL,
0x00000007ff7d7819ULL, 0x000fe4000001167dULL, 0x00000008ff7b7819ULL, 0x000fca0000011606ULL,
0x000000a800008947ULL, 0x000fea0003800000ULL, 0x00000003ff0d7819ULL, 0x000fe20000011600ULL,
0xffffffffff127424ULL, 0x000fe400078e00ffULL, 0x00000004ff0b7424ULL, 0x000fe200078e00ffULL,
0x01ffffff0d0d7812ULL, 0x000fc800078ec0ffULL, 0x0000007d0d00720cULL, 0x000fda0003f06070ULL,
0x00009400ff058b82ULL, 0x000e620000000800ULL, 0x0000000203048824ULL, 0x000fce00078e00ffULL,
0x00009000ff088b82ULL, 0x000ea20000000a00ULL, 0x0000000504048224ULL, 0x002fc800078e0205ULL,
0x000000010d058824ULL, 0x000fe200078e0204ULL, 0x0000000700047c11ULL, 0x000fc6000f8e18ffULL,
0x0000000405088825ULL, 0x004fe200078e0008ULL, 0x0176880b04ff79a7ULL, 0x0003e8000850003fULL,
0x0000000808128981ULL, 0x000ea2000c1e1900ULL, 0x000001ff0600780cULL, 0x000fe20003f04070ULL,
0x000000804e487824ULL, 0x000fe200078e00ffULL, 0x00000001ff4c7819ULL, 0x000fe40000011600ULL,
0x00000001004f7812ULL, 0x000fc600078ec0ffULL, 0x000000204c537824ULL, 0x000fe200078e00ffULL,
0x00008e00ff047b82ULL, 0x002e680000000a00ULL, 0x00000060480a7812ULL, 0x000fe200078ef853ULL,
0x0000000712077224ULL, 0x004fc800078e02ffULL, 0x0000008007077824ULL, 0x000fc800078e00ffULL,
0x0000008007047825ULL, 0x002fe200078e0004ULL, 0x0000000000fc0947ULL, 0x000fec0003800000ULL,
0x000000537a067248ULL, 0x000fe20007fe0000ULL, 0x000000104f077824ULL, 0x000fe200078e00ffULL,
0x00000003ff087819ULL, 0x000fc6000001160eULL, 0x0000000106067824ULL, 0x000fe400078e0a53ULL,
0x0000000107097824ULL, 0x000fe400078e0208ULL, 0x00000004080f7836ULL, 0x000fe20000000000ULL,
0x0000000706067248ULL, 0x000fe20007fe0000ULL, 0x00000001090b7824ULL, 0x040fe400078e020eULL,
0x00000008090c7824ULL, 0x000fe400078e00ffULL, 0x0000000106067824ULL, 0x000fc400078e0a07ULL,
0x0000000c08107836ULL, 0x000fe20000000000ULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee20bULL,
0x00000008080b7836ULL, 0x000fe20000000000ULL, 0x000000060f00720cULL, 0x080fe20003f46070ULL,
0x00000001070f7824ULL, 0x000fe200078e020fULL, 0x000000060800720cULL, 0x080fe20003f66070ULL,
0x000000010a097824ULL, 0x000fe200078e0209ULL, 0x000000060b00720cULL, 0x080fe20003f26070ULL,
0x000000010f087824ULL, 0x040fe200078e020eULL, 0x000000061000720cULL, 0x000fe20003f06070ULL,
0x000000080f137824ULL, 0x000fc400078e00ffULL, 0x00000001070b7824ULL, 0x040fe400078e020bULL,
0x0000000107117824ULL, 0x000fe200078e0210ULL, 0xfffffff813147812ULL, 0x000fe200078ee208ULL,
0x0000008009067825ULL, 0x000fc800078e00ffULL, 0x000000010a087824ULL, 0x040fe200078e020fULL,
0x00000070060f7812ULL, 0x000fe200078ef802ULL, 0x000000010a097824ULL, 0x000fe200078e020bULL,
0x000000074c067c11ULL, 0x000fe2000f8e68ffULL, 0x000000010a137824ULL, 0x000fe200078e0211ULL,
0x0000000f04107210ULL, 0x000fe20007f9e0ffULL, 0x000000010b0a7824ULL, 0x140fe400078e020eULL,
0x000000080b157824ULL, 0x000fe400078e00ffULL, 0x00000001110b7824ULL, 0x000fc400078e020eULL,
0x0000000811187824ULL, 0x000fe200078e00ffULL, 0xfffffff815167812ULL, 0x000fe200078ee20aULL,
0x0000000105117824ULL, 0x000fe400020e0607ULL, 0x00013000060f7836ULL, 0x000fe20000000000ULL,
0xfffffff818187812ULL, 0x000fe200078ee20bULL, 0x0000008008067825ULL, 0x000fc800078e00ffULL,
0x0000008009087825ULL, 0x000fe200078e00ffULL, 0x00000070061d7812ULL, 0x000fc600078ef802ULL,
0x00000080130a7825ULL, 0x000fe200078e00ffULL, 0x00000070081b7812ULL, 0x000fe400078ef802ULL,
0x0000001d04067210ULL, 0x000fe20007f9e0ffULL, 0x000000100c137824ULL, 0x100fe200078e020fULL,
0x000000700a197812ULL, 0x000fe200078ef802ULL, 0x0000001014157824ULL, 0x000fe200078e020fULL,
0x0000001b04087210ULL, 0x000fe20007fbe0ffULL, 0x0000000105077824ULL, 0x040fe200020e0607ULL,
0x0000001904047210ULL, 0x000fe20007fde0ffULL, 0x0000001016177824ULL, 0x000fe200078e020fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010137faeULL, 0x0003e2000d901c48ULL,
0x0000000105097824ULL, 0x000fc400028e0609ULL, 0x00000010180f7824ULL, 0x000fe200078e020fULL,
0x0000000006157faeULL, 0x0003e2000d101c48ULL, 0x0000000105057824ULL, 0x000fc600030e060bULL,
0x0000000008177faeULL, 0x0003e8000c901c48ULL, 0x00000000040f7faeULL, 0x0003e2000c101c48ULL,
0x0000000000c87947ULL, 0x000fea0003800000ULL, 0x000000104f077824ULL, 0x000fca00078e00ffULL,
0x000000070e077211ULL, 0x000fca00078fe8ffULL, 0x0000000407097836ULL, 0x000fe40000000000ULL,
0x0000000107087824ULL, 0x140fe400078e020eULL, 0x00000008070f7824ULL, 0x000fe400078e00ffULL,
0x00000001090b7824ULL, 0x040fe400078e020eULL, 0x0000000809107824ULL, 0x000fe200078e00ffULL,
0xfffffff80f0c7812ULL, 0x000fe200078ee208ULL, 0x000000010a067824ULL, 0x000fc400078e0207ULL,
0x0000000c070f7836ULL, 0x000fe20000000000ULL, 0xfffffff810137812ULL, 0x000fe200078ee20bULL,
0x00000008070b7836ULL, 0x000fe40000000000ULL, 0x0000008006067825ULL, 0x000fc800078e00ffULL,
0x000000010a157824ULL, 0x040fe200078e020fULL, 0x0000007006117812ULL, 0x000fe200078ef802ULL,
0x000000010f067824ULL, 0x140fe400078e020eULL, 0x000000010a097824ULL, 0x040fe200078e0209ULL,
0x0000001104107210ULL, 0x000fe20007f1e0ffULL, 0x000000010a087824ULL, 0x000fe400078e020bULL,
0x000000080f0f7824ULL, 0x000fe400078e00ffULL, 0x000000010b0a7824ULL, 0x000fc400078e020eULL,
0x000000080b177824ULL, 0x000fe200078e00ffULL, 0x000000074c0b7c11ULL, 0x000fe2000f8e68ffULL,
0x0000000105117824ULL, 0x000fe200000e0607ULL, 0xfffffff80f167812ULL, 0x000fe200078ee206ULL,
0x0000008009067825ULL, 0x000fe200078e00ffULL, 0xfffffff817147812ULL, 0x000fc600078ee20aULL,
0x000130000b1d7836ULL, 0x000fe20000000000ULL, 0x00000070061b7812ULL, 0x000fe200078ef802ULL,
0x0000008008087825ULL, 0x000fc600078e00ffULL, 0x0000001b04067210ULL, 0x000fe20007f1e0ffULL,
0x00000080150a7825ULL, 0x000fe200078e00ffULL, 0x0000007008197812ULL, 0x000fc600078ef802ULL,
0x000000100c0f7824ULL, 0x100fe200078e021dULL, 0x000000700a177812ULL, 0x000fe200078ef802ULL,
0x0000001013137824ULL, 0x000fe200078e021dULL, 0x0000001904087210ULL, 0x000fe20007f3e0ffULL,
0x0000000105077824ULL, 0x040fe200000e0607ULL, 0x0000001704047210ULL, 0x000fe20007f5e0ffULL,
0x0000001014157824ULL, 0x000fe200078e021dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000100f7faeULL, 0x0003e2000b901c48ULL, 0x0000000105097824ULL, 0x040fe400008e0609ULL,
0x0000001016177824ULL, 0x000fe200078e021dULL, 0x0000000006137faeULL, 0x0003e2000b901c48ULL,
0x0000000105057824ULL, 0x000fc600010e060bULL, 0x0000000008157faeULL, 0x0003e8000b901c48ULL,
0x0000000004177faeULL, 0x0003e4000b901c48ULL, 0x00000007ff057e24ULL, 0x002fe2000f8e00ffULL,
0x000000004c0472caULL, 0x000fe200000e0000ULL, 0x00000001ff077424ULL, 0x000fe200078e00ffULL,
0x000000ff7b00720cULL, 0x000fe20003f05270ULL, 0x000176a805057836ULL, 0x000fe20000000000ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff167224ULL, 0x000fe200078e00ffULL,
0x00000000001c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fe4000001ff00ULL,
0x00000000050572caULL, 0x000fc400000e0000ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fe4000001ff00ULL, 0x0000000000247805ULL, 0x000fe4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff297224ULL, 0x000fe400078e00ffULL,
0x000000084c067824ULL, 0x000fe400078e0205ULL, 0x0000000504047291ULL, 0x000fe2000f8e203fULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000007ff0479a7ULL, 0x0002a20008500004ULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x00000000002e7805ULL, 0x000fe4000001ff00ULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000327805ULL, 0x000fe4000001ff00ULL,
0x0000000000307805ULL, 0x000fc4000001ff00ULL, 0x0000000000367805ULL, 0x000fe4000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00002007060679a7ULL, 0x002e62000850003fULL,
0x00000000003a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000008c00648947ULL, 0x000fec0003800000ULL, 0x00009400ff0b7b82ULL, 0x000ee20000000800ULL,
0x00000002ff4b7819ULL, 0x000fe20000011600ULL, 0x0000000800047824ULL, 0x004fe200078e00ffULL,
0x000000014c027812ULL, 0x000fe200078ec0ffULL, 0x00000002034a7824ULL, 0x000fe200078e00ffULL,
0x000000074b097c11ULL, 0x000fe2000f8e28ffULL, 0x000000ffff1f7224ULL, 0x000fe200078e00ffULL,
0x0000000804047812ULL, 0x000fc600078ec0ffULL, 0x0000001002097824ULL, 0x000fe400078e0209ULL,
0x000000ffff027224ULL, 0x002fe400078e0007ULL, 0x00000001040c7824ULL, 0x000fe400078e0209ULL,
0xff317217ff077424ULL, 0x000fe400078e00ffULL, 0x0000000b4a4a7224ULL, 0x008fe400078e020bULL,
0x000000ffff0b7224ULL, 0x000fce00078e00ffULL, 0x0000000000107805ULL, 0x014fe20000015200ULL,
0x0000000400067824ULL, 0x000fca00078e00ffULL, 0xfffffff806097812ULL, 0x000fc800078ec0ffULL,
0x0176c802090075a7ULL, 0x000e620008000147ULL, 0x00000007090f7c36ULL, 0x000fc80008000000ULL,
0x000176c80f0a7836ULL, 0x000fe20000000000ULL, 0x00000000005c0947ULL, 0x002fec0003800000ULL,
0x000000ffff137224ULL, 0x000fce00078e00ffULL, 0x000000101300780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001410097210ULL, 0x000fca0007f1e1ffULL, 0x0000000115147824ULL, 0x000fe200000e0e11ULL,
0x003d09000900780cULL, 0x000fc80003f06070ULL, 0x000000ff1400720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400900780cULL, 0x000fc80003f06070ULL,
0x000000ff1400720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011414ULL, 0x0000000906067211ULL, 0x000fca00078110ffULL,
0x000000ffff097224ULL, 0x000fca00000e0614ULL, 0x0000000206067819ULL, 0x000fc80000001209ULL,
0x000000060000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000113137836ULL, 0x000fce0000000000ULL, 0x0176c8020f0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00008e00ff107b82ULL, 0x000e620000000a00ULL,
0x0000001000027824ULL, 0x000fe200078e00ffULL, 0x0000850000057ab9ULL, 0x000fe20000000800ULL,
0x000000010b147836ULL, 0x000fe40000000000ULL, 0x0000000512127c24ULL, 0x000fe2000f8e02ffULL,
0xffffffe002067812ULL, 0x000fe400078ec0ffULL, 0x0000007b1400720cULL, 0x000fe20003f26070ULL,
0x00000080120f7824ULL, 0x000fe400078e00ffULL, 0x000001000b067824ULL, 0x000fc800078e0206ULL,
0x0000004006137836ULL, 0x000fca0000000000ULL, 0x0000006013097812ULL, 0x000fe200078ec0ffULL,
0x000000800f107825ULL, 0x002fc800078e0010ULL, 0x00000001481a7824ULL, 0x000fe200078e0209ULL,
0x0000000400049947ULL, 0x000fec0003800000ULL, 0x0000001002097812ULL, 0x000fe200078ec0ffULL,
0x000000100e147824ULL, 0x000fe200078e00ffULL, 0x000000137a027248ULL, 0x000fe40007fe0000ULL,
0x00000003ff127819ULL, 0x100fe4000001160eULL, 0x00000070143d7812ULL, 0x000fe200078ec0ffULL,
0x0000000102027824ULL, 0x000fe400078e0a13ULL, 0x00000001120f7824ULL, 0x000fe400078e0209ULL,
0x0000000812157836ULL, 0x000fe20000000000ULL, 0x0000000902027248ULL, 0x000fe20007fe0000ULL,
0x000000010f067824ULL, 0x000fc400078e020eULL, 0x000000080f137824ULL, 0x000fe400078e00ffULL,
0x0000000102027824ULL, 0x000fc600078e0a09ULL, 0xfffffff813067812ULL, 0x000fe200078ee206ULL,
0x0000000412137836ULL, 0x000fe20000000000ULL, 0x000000021200720cULL, 0x080fe20003f86070ULL,
0x0000000c12127836ULL, 0x000fe20000000000ULL, 0x000000021500720cULL, 0x0c0fe20003f46070ULL,
0x0000000115157824ULL, 0x100fe200078e0209ULL, 0x000000021300720cULL, 0x0c0fe20003f66070ULL,
0x0000000113137824ULL, 0x100fe200078e0209ULL, 0x000000021200720cULL, 0x040fe20003f06070ULL,
0x0000000112177824ULL, 0x000fe400078e0209ULL, 0x000000011a127824ULL, 0x000fc400078e020fULL,
0x000000011a187824ULL, 0x000fe400078e0213ULL, 0x0000000113027824ULL, 0x040fe400078e020eULL,
0x00000008131b7824ULL, 0x000fe400078e00ffULL, 0x0000008012127825ULL, 0x000fc600078e00ffULL,
0xfffffff81b027812ULL, 0x000fe200078ee202ULL, 0x000000011a147824ULL, 0x000fe400078e0215ULL,
0x0000000115097824ULL, 0x040fe400078e020eULL, 0x00000008153c7824ULL, 0x000fe200078e00ffULL,
0x0000003d12157212ULL, 0x000fe200078efcffULL, 0x0000008018187825ULL, 0x000fc600078e00ffULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee209ULL, 0x000000011a1a7824ULL, 0x000fe200078e0217ULL,
0x0000001510127210ULL, 0x000fe20007fbe0ffULL, 0x00000001170f7824ULL, 0x040fe200078e020eULL,
0x0000003d18097212ULL, 0x000fe200078efcffULL, 0x00000008173e7824ULL, 0x000fe400078e00ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000000910187210ULL, 0x000fe40007fde0ffULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee20fULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x000000074c0f7c11ULL, 0x000fc4000f8e68ffULL, 0x0000003d143f7212ULL, 0x080fe200078efcffULL,
0x0000000111137824ULL, 0x040fe200028e0613ULL, 0x0000003d1a3d7212ULL, 0x000fe200078efcffULL,
0x000140000f097836ULL, 0x000fe20000000000ULL, 0x0000003f10147210ULL, 0x000fe20007fbe0ffULL,
0x0000000111197824ULL, 0x040fe200030e0619ULL, 0x0000003d10107210ULL, 0x000fe20007fde0ffULL,
0x00000010060f7824ULL, 0x100fe400078e0209ULL, 0x0000001002177824ULL, 0x100fe400078e0209ULL,
0x000000103c3d7824ULL, 0x000fe200078e0209ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000120f7faeULL, 0x0003e2000e101c48ULL, 0x0000000111157824ULL, 0x000fc400028e0615ULL,
0x000000103e097824ULL, 0x000fe200078e0209ULL, 0x0000000018177faeULL, 0x0003e2000d901c48ULL,
0x0000000111117824ULL, 0x000fc600030e061bULL, 0x00000000143d7faeULL, 0x0003e8000d101c48ULL,
0x0000000010097faeULL, 0x0003e2000c101c48ULL, 0x0000000000d07947ULL, 0x000fea0003800000ULL,
0x0000001002097812ULL, 0x000fe200078ec0ffULL, 0x000000100e137824ULL, 0x000fc600078e00ffULL,
0x000000090e097211ULL, 0x000fe400078fe8ffULL, 0x00000070133d7812ULL, 0x000fc600078ec0ffULL,
0x00000004090f7836ULL, 0x000fe40000000000ULL, 0x0000000109027824ULL, 0x140fe400078e020eULL,
0x0000000809157824ULL, 0x000fe400078e00ffULL, 0x000000010f067824ULL, 0x040fe400078e020eULL,
0x000000080f177824ULL, 0x000fe200078e00ffULL, 0xfffffff815027812ULL, 0x000fe200078ee202ULL,
0x000000011a127824ULL, 0x000fc400078e0209ULL, 0x0000000809157836ULL, 0x000fe20000000000ULL,
0xfffffff817067812ULL, 0x000fe200078ee206ULL, 0x0000008012127825ULL, 0x000fc800078e00ffULL,
0x0000000c09177836ULL, 0x000fe20000000000ULL, 0x0000003d12197212ULL, 0x000fe200078efcffULL,
0x000000011a187824ULL, 0x000fe400078e0215ULL, 0x0000000115097824ULL, 0x040fe200078e020eULL,
0x0000001910127210ULL, 0x000fe20007f1e0ffULL, 0x00000008153c7824ULL, 0x000fe200078e00ffULL,
0x000000074c157c11ULL, 0x000fe2000f8e68ffULL, 0x000000011a147824ULL, 0x040fe400078e020fULL,
0x000000011a1a7824ULL, 0x000fc400078e0217ULL, 0x0001400015437836ULL, 0x000fe40000000000ULL,
0x0000008014147825ULL, 0x000fc800078e00ffULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x0000003d14417212ULL, 0x000fc600078efcffULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000003d183f7212ULL, 0x000fc600078efcffULL, 0x00000001170f7824ULL, 0x040fe200078e020eULL,
0x0000003d1a3d7212ULL, 0x000fe200078efcffULL, 0x00000008173e7824ULL, 0x000fe200078e00ffULL,
0xfffffff83c177812ULL, 0x000fe200078ee209ULL, 0x0000000111137824ULL, 0x000fe200000e0613ULL,
0x0000004110147210ULL, 0x000fe20007f1e0ffULL, 0x0000001002097824ULL, 0x100fe200078e0243ULL,
0x0000003f10187210ULL, 0x000fe20007f5e0ffULL, 0x0000001017177824ULL, 0x100fe200078e0243ULL,
0xfffffff83e3c7812ULL, 0x000fe200078ee20fULL, 0x00000010060f7824ULL, 0x000fe200078e0243ULL,
0x0000003d10107210ULL, 0x000fe20007f7e0ffULL, 0x0000000111157824ULL, 0x040fe200000e0615ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012097faeULL, 0x0003e2000b901c48ULL,
0x0000000111197824ULL, 0x000fc400010e0619ULL, 0x000000103c3d7824ULL, 0x000fe200078e0243ULL,
0x00000000140f7faeULL, 0x0003e2000b901c48ULL, 0x0000000111117824ULL, 0x000fc600018e061bULL,
0x0000000018177faeULL, 0x0003e8000b901c48ULL, 0x00000000103d7faeULL, 0x0003e4000b901c48ULL,
0x000000010d097836ULL, 0x002fe40000000000ULL, 0xffffffffff127424ULL, 0x000fc600078e00ffULL,
0x0000007d0900720cULL, 0x000fe20003f06070ULL, 0x0000000800177824ULL, 0x000fca00078e00ffULL,
0xfffffff017067812ULL, 0x000fca00078ec0ffULL, 0x0000000706467c36ULL, 0x000fe40008000000ULL,
0x00009000ff108b82ULL, 0x000e620000000a00ULL, 0x000000014a098824ULL, 0x000fe200078e0209ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000460572caULL, 0x000fda00000e0000ULL,
0x000176b005057890ULL, 0x000fe2000fffe03fULL, 0x0000000409108825ULL, 0x002fd000078e0010ULL,
0x00000000ff0079b0ULL, 0x000fe80008000a45ULL, 0x0000000810128981ULL, 0x000322000c1e1900ULL,
0xffffffe017027812ULL, 0x040fe200078ec0ffULL, 0x00000001ff187424ULL, 0x000fe200078e00ffULL,
0x0000001017097812ULL, 0x000fc800078ec0ffULL, 0x0000000709097c10ULL, 0x000fe4000fffe002ULL,
0x0000000817027812ULL, 0x000fca00078ec0ffULL, 0x0000000109097824ULL, 0x000fe200078e0202ULL,
0x0000000000007918ULL, 0x002fcc0000000000ULL, 0x0176b018464679a7ULL, 0x0002a4000850003fULL,
0x01760818091879a7ULL, 0x0022e4000850003fULL, 0x0000000000107805ULL, 0x000fce0000015200ULL,
0x01760819090075a7ULL, 0x008ee4000800017fULL, 0x00000000005c0947ULL, 0x008fea0003800000ULL,
0x000000ffff067224ULL, 0x000fce00078e00ffULL, 0x000000100600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x00000014100f7210ULL, 0x000fca0007f1e1ffULL, 0x0000000115147824ULL, 0x000fe200000e0e11ULL,
0x003d09000f00780cULL, 0x000fc80003f06070ULL, 0x000000ff1400720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400f00780cULL, 0x000fc80003f06070ULL,
0x000000ff1400720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff027819ULL, 0x000fc80000011414ULL, 0x0000000f02027211ULL, 0x000fca00078110ffULL,
0x000000ffff0f7224ULL, 0x000fca00000e0614ULL, 0x0000000202027819ULL, 0x000fc8000000120fULL,
0x000000020000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000106067836ULL, 0x000fce0000000000ULL, 0x01760819090075a7ULL, 0x000ee4000800017fULL,
0xfffffffc00a88947ULL, 0x008fea000383ffffULL, 0x000000100e497824ULL, 0x000fe200078e00ffULL,
0x00000001ff4d7819ULL, 0x000fe2000001160eULL, 0x0000002000027824ULL, 0x000fe400078e00ffULL,
0x000000ffff117224ULL, 0x000fe200078e0007ULL, 0x0000007049497812ULL, 0x000fe400078ec0ffULL,
0xffffff8002027812ULL, 0x000fe400078ec0ffULL, 0x0000000c4d4d7812ULL, 0x000fe400078ec0ffULL,
0x0000000749027c10ULL, 0x000fca000fffe002ULL, 0x0000000102027824ULL, 0x000fca00078e024dULL,
0x0170000002067984ULL, 0x000ee80000000800ULL, 0x0172000002137984ULL, 0x000b620000000800ULL,
0x000000070600720bULL, 0x008fda0003f1d000ULL, 0x00000000000f7806ULL, 0x000fc800000e0100ULL,
0x0000ffff0f147812ULL, 0x000fe2000780c0ffULL, 0x00000001ff0f7424ULL, 0x000fd800078e00ffULL,
0x0000000000fc8947ULL, 0x026fea0003800000ULL, 0x000000004b00720cULL, 0x000fe40003f45270ULL,
0x000000070600720bULL, 0x000fd60003f14000ULL, 0x000000070010ac11ULL, 0x000fe4000f8e38ffULL,
0x000000070602a209ULL, 0x000fe40007810000ULL, 0x000000104d0fa210ULL, 0x000fe40007ffe049ULL,
0x0000000000117806ULL, 0x000fc600000e0100ULL, 0x017400020f00a388ULL, 0x0003e20000000800ULL,
0x0000991011107816ULL, 0x000fc800000000ffULL, 0x000000ff1000720cULL, 0x000fda0003f05270ULL,
0x0000000000b48947ULL, 0x002fea0003800000ULL, 0x0000000706027209ULL, 0x000fe40007810000ULL,
0x000000ff11ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0011ff7812ULL, 0x000fe2000784c0ffULL,
0x0000000702027221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b02027820ULL, 0x000fc80000410000ULL,
0x00000002000f7308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff027819ULL, 0x002fcc000001160eULL, 0x00001f020f027589ULL, 0x004e6400000e0000ULL,
0x0000000238387220ULL, 0x082fe20000410000ULL, 0x0000000239397220ULL, 0x080fe20000410000ULL,
0x0000000234347220ULL, 0x080fe20000410000ULL, 0x0000000235357220ULL, 0x080fe20000410000ULL,
0x0000000230307220ULL, 0x080fe20000410000ULL, 0x0000000231317220ULL, 0x080fe20000410000ULL,
0x000000022c2c7220ULL, 0x080fe20000410000ULL, 0x000000022d2d7220ULL, 0x080fe20000410000ULL,
0x0000000228287220ULL, 0x080fe20000410000ULL, 0x0000000229297220ULL, 0x080fe20000410000ULL,
0x0000000224247220ULL, 0x080fe20000410000ULL, 0x0000000225257220ULL, 0x080fe20000410000ULL,
0x0000000220207220ULL, 0x080fe20000410000ULL, 0x0000000221217220ULL, 0x080fe20000410000ULL,
0x000000021c1c7220ULL, 0x080fe20000410000ULL, 0x000000021d1d7220ULL, 0x000fce0000410000ULL,
0x0000000f16167220ULL, 0x004fe20000410000ULL, 0x000000000048a947ULL, 0x000fec0003800000ULL,
0x000000080e027811ULL, 0x002fcc00078ff0ffULL, 0x00001f020f027589ULL, 0x000e6400000e0000ULL,
0x000000023a3a7220ULL, 0x082fe20000410000ULL, 0x000000023b3b7220ULL, 0x080fe20000410000ULL,
0x0000000236367220ULL, 0x080fe20000410000ULL, 0x0000000237377220ULL, 0x080fe20000410000ULL,
0x0000000232327220ULL, 0x080fe20000410000ULL, 0x0000000233337220ULL, 0x080fe20000410000ULL,
0x000000022e2e7220ULL, 0x080fe20000410000ULL, 0x000000022f2f7220ULL, 0x080fe20000410000ULL,
0x000000022a2a7220ULL, 0x080fe20000410000ULL, 0x000000022b2b7220ULL, 0x080fe20000410000ULL,
0x0000000226267220ULL, 0x080fe20000410000ULL, 0x0000000227277220ULL, 0x080fe20000410000ULL,
0x0000000222227220ULL, 0x080fe20000410000ULL, 0x0000000223237220ULL, 0x080fe20000410000ULL,
0x000000021e1e7220ULL, 0x080fe20000410000ULL, 0x000000021f1f7220ULL, 0x000fce0000410000ULL,
0x0000ffff14ff7812ULL, 0x000fe20007806011ULL, 0x00000001ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000000706117209ULL, 0x000fd60007810000ULL, 0x8000001106060221ULL, 0x000fe20000010000ULL,
0x00007610ff0f0816ULL, 0x000fc6000000000fULL, 0x3fb8aa3b06060820ULL, 0x000fc80000410000ULL,
0x0000000600080308ULL, 0x000ea40000000800ULL, 0x0000000813130220ULL, 0x004fce0000410000ULL,
0x0000001613167221ULL, 0x000fce0000010000ULL, 0x0000000000067805ULL, 0x000fce0000015200ULL,
0xfffffff017027812ULL, 0x002fc800078ec0ffULL, 0x0176a805020075a7ULL, 0x000e620008000147ULL,
0x0000000702107c36ULL, 0x000fe20008000000ULL, 0x00000000005c0947ULL, 0x002fec0003800000ULL,
0x000000ffff177224ULL, 0x000fce00078e00ffULL, 0x000000101700780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x0000001406137210ULL, 0x000fca0007f1e1ffULL, 0x0000000115147824ULL, 0x000fe200000e0e07ULL,
0x003d09001300780cULL, 0x000fc80003f06070ULL, 0x000000ff1400720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401300780cULL, 0x000fc80003f06070ULL,
0x000000ff1400720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff027819ULL, 0x000fc80000011414ULL, 0x0000001302027211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0614ULL, 0x0000000202027819ULL, 0x000fc80000001213ULL,
0x000000020000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000117177836ULL, 0x000fce0000000000ULL, 0x0176a805100075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000099100f057816ULL, 0x000fe200000000ffULL,
0x0000000200137824ULL, 0x000fe200078e00ffULL, 0x000000070e0f7812ULL, 0x000fe200078ec0ffULL,
0x0000000400157824ULL, 0x040fe200078e00ffULL, 0x000000ff0500720cULL, 0x000fe20003f05270ULL,
0x0000020000027824ULL, 0x000fe200078e00ffULL, 0x0000000413057812ULL, 0x000fe400078ec0ffULL,
0x000000080f177812ULL, 0x000fe400078ef80eULL, 0x000000050e067211ULL, 0x000fc400078fe0ffULL,
0x000000080e107812ULL, 0x000fe200078ec0ffULL, 0x0000000817457824ULL, 0x040fe200078e00ffULL,
0x00000004ff547819ULL, 0x000fe2000001160eULL, 0x0000000117067824ULL, 0x000fe200078e0206ULL,
0x0000000415157812ULL, 0x000fe400078ec0ffULL, 0xfffff80002027812ULL, 0x000fe400078ec0ffULL,
0x0000000f10407212ULL, 0x000fe200078efcffULL, 0x0000000154157824ULL, 0x000fe200078e0215ULL,
0x000000074c077c11ULL, 0x000fe2000f8e68ffULL, 0x0000000702447c36ULL, 0x000fe20008000000ULL,
0xfffffff845457812ULL, 0x000fe200078ee206ULL, 0x0000000840027824ULL, 0x000fc400078e00ffULL,
0x0000000140417824ULL, 0x000fe400078e0215ULL, 0x0001300007147836ULL, 0x000fe40000000000ULL,
0x0000001045457824ULL, 0x000fe200078e0244ULL, 0xfffffff802057812ULL, 0x000fe200078ee241ULL,
0x0000000000180947ULL, 0x000fec0003800000ULL, 0x00000002ff197819ULL, 0x000fe4000001160eULL,
0x00000008ff02723eULL, 0x000fc600000000ffULL, 0x0000000819037836ULL, 0x000fe20000000000ULL,
0x0000541002027816ULL, 0x000fca0000000002ULL, 0x00001f1902047589ULL, 0x0002a800000e0000ULL,
0x00001f0302037589ULL, 0x0002e400000e0000ULL, 0x011000004518783bULL, 0x0022e20000000200ULL,
0x00000010053c7824ULL, 0x000fe200078e0214ULL, 0x0000000000100947ULL, 0x000fec0003800000ULL,
0x0000000418187232ULL, 0x08cfe40000000000ULL, 0x000000041a1a7232ULL, 0x000fe40000000000ULL,
0x0000000319197232ULL, 0x080fe40000000000ULL, 0x000000031b1b7232ULL, 0x000fce0000000000ULL,
0x0000000840437824ULL, 0x000fe200078e00ffULL, 0x000000003c3c783bULL, 0x000f620000004200ULL,
0x0000000241027836ULL, 0x000fe20000000000ULL, 0x0000001010107812ULL, 0x000fe200078efe0fULL,
0x000000044c547824ULL, 0x000fc600078e0254ULL, 0xfffffff843027812ULL, 0x000fe200078ee202ULL,
0x0000000115157824ULL, 0x000fe200078e0210ULL, 0x0000000254547810ULL, 0x000fe20007ffe017ULL,
0x0000000817177824ULL, 0x000fe400078e00ffULL, 0x0000001002407824ULL, 0x000fc600078e0214ULL,
0xfffffff8170f7812ULL, 0x000fc600078ee254ULL, 0x000000004040783bULL, 0x000f640000004200ULL,
0x000000100f447824ULL, 0x000fe200078e0244ULL, 0x00000010ff6a7819ULL, 0x022fe4000001163cULL,
0x00000010ff6b7819ULL, 0x000fe4000001163dULL, 0x00000010ff647819ULL, 0x100fe4000001163fULL,
0x000000ff3f5c7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff697819ULL, 0x000fc4000001163fULL,
0x0000ffff3f547812ULL, 0x000fe400078ec0ffULL, 0x000000ff3d677812ULL, 0x000fe400078ec0ffULL,
0x00000018ff617819ULL, 0x000fe4000001163dULL, 0x000000ff3c667812ULL, 0x000fe400078ec0ffULL,
0x000000ff423f7812ULL, 0x008fe400078ec0ffULL, 0x00000018ff627819ULL, 0x000fc4000001163cULL,
0x0000ffff3c687812ULL, 0x000fe400078ec0ffULL, 0x0000ffff3d3d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5f7819ULL, 0x100fe4000001163eULL, 0x000000ff3e5e7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff177819ULL, 0x000fe4000001163eULL, 0x0000ffff3e587812ULL, 0x000fc400078ec0ffULL,
0x00000010ff657819ULL, 0x100fe40000011640ULL, 0x000000ff405a7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff577819ULL, 0x000fe40000011640ULL, 0x0000ffff403c7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff3e7819ULL, 0x000fe40000011642ULL, 0x000000ff6a6a7812ULL, 0x000fc400078ec0ffULL,
0x000000ff6b6b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5b7819ULL, 0x000fe40000011642ULL,
0x0000ffff42557812ULL, 0x000fe400078ec0ffULL, 0x00000018ff407819ULL, 0x000fe40000011643ULL,
0x000000ff646c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff637819ULL, 0x000fc40000011641ULL,
0x0000003fff42723eULL, 0x000fe400020006ffULL, 0x00000017ff3f723eULL, 0x000fe400020006ffULL,
0x00000008ff3d7819ULL, 0x000fe4000001163dULL, 0x00000066ff66723eULL, 0x000fe400020006ffULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x0000003eff17723eULL, 0x000fc400020006ffULL,
0x0000006aff6a723eULL, 0x000fe400020006ffULL, 0x0000006bff6b723eULL, 0x000fe400020006ffULL,
0x000000ff656d7812ULL, 0x000fe400078ec0ffULL, 0x00000040ff3e723eULL, 0x000fe400020006ffULL,
0x0000006cff65723eULL, 0x000fe400020006ffULL, 0x00000069ff40723eULL, 0x000fc400020006ffULL,
0x000000ff636c7812ULL, 0x000fe400078ec0ffULL, 0x0000003dff69723eULL, 0x000fe400020006ffULL,
0x00000008ff637819ULL, 0x000fe4000001163cULL, 0x00000008ff687819ULL, 0x000fe40000011668ULL,
0x00005410663c7816ULL, 0x000fe4000000006aULL, 0x00005410673d7816ULL, 0x000fc4000000006bULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x00000061ff61723eULL, 0x000fe400020006ffULL,
0x00000068ff68723eULL, 0x000fe200020006ffULL, 0x0000003c1838723cULL, 0x000fe20000001838ULL,
0x000000ff5f5f7812ULL, 0x000fe400078ec0ffULL, 0x0000005eff5e723eULL, 0x000fe400020006ffULL,
0x0000005cff5c723eULL, 0x000fc400020006ffULL, 0x00005410683c7816ULL, 0x000fe40000000062ULL,
0x00005410693d7816ULL, 0x000fe40000000061ULL, 0x0000005fff64723eULL, 0x000fe400020006ffULL,
0x000000ff41597812ULL, 0x040fe400078ec0ffULL, 0x0000ffff41607812ULL, 0x000fe200078ec0ffULL,
0x0000003c1834723cULL, 0x000fe20000001834ULL, 0x0000005aff5a723eULL, 0x000fc400020006ffULL,
0x00000059ff59723eULL, 0x000fe400020006ffULL, 0x0000006dff5f723eULL, 0x000fe400020006ffULL,
0x000054105e3c7816ULL, 0x000fe40000000064ULL, 0x000054105c3d7816ULL, 0x000fe40000000065ULL,
0x0000006cff66723eULL, 0x000fe400020006ffULL, 0x00000018ff567819ULL, 0x000fc40000011641ULL,
0x00000008ff607819ULL, 0x000fe20000011660ULL, 0x0000003c1830723cULL, 0x000fe20000001830ULL,
0x00000010ff5d7819ULL, 0x000fe40000011643ULL, 0x00000057ff57723eULL, 0x000fe400020006ffULL,
0x00000056ff56723eULL, 0x000fe400020006ffULL, 0x000054105a3c7816ULL, 0x000fe4000000005fULL,
0x00005410593d7816ULL, 0x000fc40000000066ULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x00000060ff60723eULL, 0x000fe400020006ffULL, 0x000000ff43417812ULL, 0x000fe200078ec0ffULL,
0x0000003c1828723cULL, 0x000fe20000001828ULL, 0x000000ff5b5b7812ULL, 0x000fe400078ec0ffULL,
0x000000ff5d5d7812ULL, 0x000fe400078ec0ffULL, 0x00000041ff41723eULL, 0x000fc400020006ffULL,
0x00005410633c7816ULL, 0x000fe40000000057ULL, 0x00005410603d7816ULL, 0x000fe40000000056ULL,
0x0000005bff5b723eULL, 0x000fe400020006ffULL, 0x0000005dff5d723eULL, 0x000fe400020006ffULL,
0x00000008ff587819ULL, 0x000fe20000011658ULL, 0x0000003c1824723cULL, 0x000fe20000001824ULL,
0x00000008ff547819ULL, 0x000fc40000011654ULL, 0x0000ffff43437812ULL, 0x000fe400078ec0ffULL,
0x00000058ff58723eULL, 0x000fe400020006ffULL, 0x00005410423c7816ULL, 0x000fe2000000005bULL,
0x0000000810427824ULL, 0x000fe200078e00ffULL, 0x00005410413d7816ULL, 0x000fe4000000005dULL,
0x00000054ff54723eULL, 0x000fe400020006ffULL, 0x00000008ff557819ULL, 0x000fc40000011655ULL,
0x00000008ff437819ULL, 0x000fe20000011643ULL, 0x0000003c1820723cULL, 0x000fe20000001820ULL,
0x00000055ff55723eULL, 0x000fe400020006ffULL, 0x00000043ff43723eULL, 0x000fe400020006ffULL,
0xfffffff8420f7812ULL, 0x000fe400078ee215ULL, 0x00005410583c7816ULL, 0x000fe4000000003fULL,
0x00005410543d7816ULL, 0x000fce0000000040ULL, 0x0000003c182c723cULL, 0x000fee000000182cULL,
0x00005410553c7816ULL, 0x000fe40000000017ULL, 0x00005410433d7816ULL, 0x000fce000000003eULL,
0x0000003c181c723cULL, 0x000fe2000000181cULL, 0x011000004418783bULL, 0x0002ec0000000200ULL,
0x000000100f3c7824ULL, 0x000fe200078e0214ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000100947ULL, 0x000fde0003800000ULL, 0x0000000418187232ULL, 0x08cfe40000000000ULL,
0x000000041a1a7232ULL, 0x000fe40000000000ULL, 0x0000000319197232ULL, 0x080fe40000000000ULL,
0x000000031b1b7232ULL, 0x000fce0000000000ULL, 0x0000000810177824ULL, 0x000fe200078e00ffULL,
0x000000003c3c783bULL, 0x000f620000004200ULL, 0x0000000215107836ULL, 0x000fe20000000000ULL,
0xfffffff813137812ULL, 0x000fc800078ec0ffULL, 0xfffffff817107812ULL, 0x000fca00078ee210ULL,
0x0000001010407824ULL, 0x000fcc00078e0214ULL, 0x000000004040783bULL, 0x000f640000004200ULL,
0x00000010ff687819ULL, 0x122fe4000001163dULL, 0x000000ff3d657812ULL, 0x040fe400078ec0ffULL,
0x00000018ff607819ULL, 0x000fe4000001163dULL, 0x0000ffff3d627812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5e7819ULL, 0x000fc4000001163eULL, 0x000000ff3e5d7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff587819ULL, 0x000fe4000001163eULL, 0x0000ffff3e637812ULL, 0x000fe400078ec0ffULL,
0x00000010ff677819ULL, 0x000fe4000001163cULL, 0x00000018ff157819ULL, 0x008fe40000011640ULL,
0x000000ff3c667812ULL, 0x000fc400078ec0ffULL, 0x00000018ff5f7819ULL, 0x000fe4000001163cULL,
0x0000ffff3c177812ULL, 0x000fe400078ec0ffULL, 0x00000010ff647819ULL, 0x100fe4000001163fULL,
0x000000ff3f5c7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff577819ULL, 0x000fe4000001163fULL,
0x0000ffff3f3d7812ULL, 0x000fc400078ec0ffULL, 0x000000ff413e7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff6a7819ULL, 0x000fe40000011642ULL, 0x00000010ff3c7819ULL, 0x000fe40000011640ULL,
0x000000ff40567812ULL, 0x040fe400078ec0ffULL, 0x0000ffff40597812ULL, 0x000fe400078ec0ffULL,
0x000000ff423f7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff617819ULL, 0x100fe40000011641ULL,
0x00000018ff407819ULL, 0x000fe40000011641ULL, 0x0000ffff415a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff436b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff547819ULL, 0x100fe40000011643ULL,
0x00000018ff697819ULL, 0x000fc40000011643ULL, 0x0000ffff43557812ULL, 0x000fe400078ec0ffULL,
0x00000015ff41723eULL, 0x000fe400020006ffULL, 0x0000003eff43723eULL, 0x000fe400020006ffULL,
0x0000006aff15723eULL, 0x000fe400020006ffULL, 0x000000ff67677812ULL, 0x000fe400078ec0ffULL,
0x0000003fff3e723eULL, 0x000fc400020006ffULL, 0x00000008ff6a7819ULL, 0x000fe40000011617ULL,
0x0000006bff3f723eULL, 0x000fe400020006ffULL, 0x000000ff686b7812ULL, 0x000fe400078ec0ffULL,
0x00000067ff68723eULL, 0x000fe400020006ffULL, 0x0000006aff67723eULL, 0x000fe400020006ffULL,
0x00000008ff627819ULL, 0x000fc40000011662ULL, 0x000000ff5e5e7812ULL, 0x000fe400078ec0ffULL,
0x000000ff646a7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff647819ULL, 0x000fe40000011663ULL,
0x00000069ff17723eULL, 0x000fe400020006ffULL, 0x00000066ff66723eULL, 0x000fe400020006ffULL,
0x00000065ff65723eULL, 0x000fc400020006ffULL, 0x0000006bff6b723eULL, 0x000fe400020006ffULL,
0x00000062ff69723eULL, 0x000fe400020006ffULL, 0x0000005eff62723eULL, 0x000fe400020006ffULL,
0x0000006aff63723eULL, 0x000fe400020006ffULL, 0x00000064ff5e723eULL, 0x000fe400020006ffULL,
0x00000008ff647819ULL, 0x000fc4000001163dULL, 0x000000ff3c6a7812ULL, 0x000fe400078ec0ffULL,
0x00005410663c7816ULL, 0x000fe40000000068ULL, 0x00005410653d7816ULL, 0x000fe4000000006bULL,
0x0000005fff5f723eULL, 0x000fe400020006ffULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x0000005dff5d723eULL, 0x000fe200020006ffULL, 0x0000003c1838723cULL, 0x000fe20000001838ULL,
0x0000005cff5c723eULL, 0x000fc400020006ffULL, 0x00000058ff58723eULL, 0x000fe400020006ffULL,
0x00000057ff57723eULL, 0x000fe400020006ffULL, 0x00005410673c7816ULL, 0x000fe4000000005fULL,
0x00005410693d7816ULL, 0x000fe40000000060ULL, 0x00000064ff65723eULL, 0x000fe400020006ffULL,
0x000000ff616c7812ULL, 0x000fc400078ec0ffULL, 0x00000056ff56723eULL, 0x000fe200020006ffULL,
0x0000003c1834723cULL, 0x000fe20000001834ULL, 0x0000006aff61723eULL, 0x000fe400020006ffULL,
0x0000006cff64723eULL, 0x000fe400020006ffULL, 0x00000008ff597819ULL, 0x000fe40000011659ULL,
0x000054105d3c7816ULL, 0x000fe40000000062ULL, 0x000054105c3d7816ULL, 0x000fc40000000063ULL,
0x00000008ff5a7819ULL, 0x000fe4000001165aULL, 0x00000040ff40723eULL, 0x000fe400020006ffULL,
0x00000059ff59723eULL, 0x000fe200020006ffULL, 0x0000003c1830723cULL, 0x000fe20000001830ULL,
0x0000005aff5a723eULL, 0x000fe400020006ffULL, 0x00000010ff5b7819ULL, 0x000fe40000011642ULL,
0x0000ffff42427812ULL, 0x000fc400078ec0ffULL, 0x000054105e3c7816ULL, 0x000fe40000000058ULL,
0x00005410653d7816ULL, 0x000fe40000000057ULL, 0x000000ff5b5b7812ULL, 0x000fe400078ec0ffULL,
0x000000ff54547812ULL, 0x000fe400078ec0ffULL, 0x00000008ff427819ULL, 0x000fe20000011642ULL,
0x0000003c182c723cULL, 0x000fe2000000182cULL, 0x00000008ff557819ULL, 0x000fc40000011655ULL,
0x0000005bff5b723eULL, 0x000fe400020006ffULL, 0x00000054ff54723eULL, 0x000fe400020006ffULL,
0x00005410563c7816ULL, 0x000fe40000000061ULL, 0x00005410433d7816ULL, 0x000fe40000000064ULL,
0x00000042ff42723eULL, 0x000fe400020006ffULL, 0x00000055ff43723eULL, 0x000fc400020006ffULL,
0x000054103e3e7816ULL, 0x000fe2000000005bULL, 0x0000003c1828723cULL, 0x000fe20000001828ULL,
0x000054103f3f7816ULL, 0x000fe40000000054ULL, 0x0000541042427816ULL, 0x000fe40000000015ULL,
0x0000541043437816ULL, 0x000fe40000000017ULL, 0x00005410593c7816ULL, 0x000fe20000000041ULL,
0x0000003e1820723cULL, 0x000fe20000001820ULL, 0x000054105a3d7816ULL, 0x000fe20000000040ULL,
0x00000001ff407424ULL, 0x000fc800078e00ffULL, 0x00000042181c723cULL, 0x000fec000000181cULL,
0x0000003c1824723cULL, 0x000fee0000001824ULL, 0x000000074c3c7c11ULL, 0x000fcc000f8e18ffULL,
0x0176c8403c3c79a7ULL, 0x0002e2000850003fULL, 0x0176884013ff79a7ULL, 0x0003f40008500007ULL,
0x0000000000187805ULL, 0x000fce0000015200ULL, 0x0000003d0a0075a7ULL, 0x008ee4000800017fULL,
0x00000000005c0947ULL, 0x008fea0003800000ULL, 0x000000ffff157224ULL, 0x000fce00078e00ffULL,
0x000000101500780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000001a7805ULL, 0x000fce0000015200ULL, 0x0000001a181a7210ULL, 0x000fca0007f1e1ffULL,
0x000000011b1b7824ULL, 0x000fe200000e0e19ULL, 0x003d09001a00780cULL, 0x000fc80003f06070ULL,
0x000000ff1b00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401a00780cULL, 0x000fc80003f06070ULL, 0x000000ff1b00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff137819ULL, 0x002fc8000001141bULL,
0x0000001a13137211ULL, 0x000fca00078110ffULL, 0x000000ffff1a7224ULL, 0x000fca00000e061bULL,
0x0000000213137819ULL, 0x000fc8000000121aULL, 0x000000130000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000115157836ULL, 0x000fce0000000000ULL,
0x0000003d0a0075a7ULL, 0x000ee4000800017fULL, 0xfffffffc00a88947ULL, 0x008fea000383ffffULL,
0x00008e00ff187b82ULL, 0x000ee20000000a00ULL, 0x00000010001b7824ULL, 0x000fe200078e00ffULL,
0x0000850000057ab9ULL, 0x000fe40000000800ULL, 0x0000000512127c24ULL, 0x010fe4000f8e02ffULL,
0xffffffe01b1a7812ULL, 0x000fe400078ec0ffULL, 0x0000008012137824ULL, 0x002fc600078e00ffULL,
0x000001000b177824ULL, 0x000fc800078e021aULL, 0x0000008017177836ULL, 0x000fca0000000000ULL,
0x0000006017157812ULL, 0x000fe200078ec0ffULL, 0x0000008013127825ULL, 0x008fc800078e0018ULL,
0x00000001481a7824ULL, 0x000fe200078e0215ULL, 0x0000000000f49947ULL, 0x000fec0003800000ULL,
0x000000177a157248ULL, 0x000fe40007fe0000ULL, 0x000000101b3c7812ULL, 0x000fe400078ec0ffULL,
0x00000003ff187819ULL, 0x000fe2000001160eULL, 0x0000000115157824ULL, 0x000fc800078e0a17ULL,
0x0000000118177824ULL, 0x040fe200078e023cULL, 0x000000153c157248ULL, 0x000fe20007fe0000ULL,
0x00000004181b7836ULL, 0x000fe40000000000ULL, 0x0000000117197824ULL, 0x040fe400078e020eULL,
0x00000008173e7824ULL, 0x000fe400078e00ffULL, 0x0000000115157824ULL, 0x100fe400078e0a3cULL,
0x0000000c183f7836ULL, 0x000fe20000000000ULL, 0xfffffff83e557812ULL, 0x000fe200078ee219ULL,
0x0000000818197836ULL, 0x000fe20000000000ULL, 0x000000151b00720cULL, 0x0c0fe20003f66070ULL,
0x000000011b1b7824ULL, 0x100fe200078e023cULL, 0x000000151800720cULL, 0x080fe20003f86070ULL,
0x00000001193d7824ULL, 0x040fe200078e023cULL, 0x000000151900720cULL, 0x080fe20003f46070ULL,
0x0000000117187824ULL, 0x000fe200078e021aULL, 0x000000153f00720cULL, 0x000fe20003f06070ULL,
0x000000013d197824ULL, 0x000fc400078e020eULL, 0x000000083d407824ULL, 0x000fe400078e00ffULL,
0x000000013f417824ULL, 0x000fe400078e023cULL, 0x000000011b177824ULL, 0x040fe200078e020eULL,
0xfffffff840597812ULL, 0x000fe200078ee219ULL, 0x000000081b3c7824ULL, 0x040fe400078e00ffULL,
0x000000011b3e7824ULL, 0x000fe400078e021aULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0xfffffff83c577812ULL, 0x000fc600078ee217ULL, 0x000000803e3e7825ULL, 0x000fe200078e00ffULL,
0x0000004918177212ULL, 0x000fc600078efcffULL, 0x000000013d3c7824ULL, 0x100fe200078e021aULL,
0x000000493e157212ULL, 0x000fe200078efcffULL, 0x00000001411a7824ULL, 0x000fe200078e021aULL,
0x0000001712187210ULL, 0x000fe20007fbe0ffULL, 0x000000803c3c7825ULL, 0x000fe200078e00ffULL,
0x00000015123e7210ULL, 0x000fc60007fde0ffULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x000000493c437212ULL, 0x000fc600078efcffULL, 0x0000000141407824ULL, 0x040fe400078e020eULL,
0x00000008415b7824ULL, 0x000fe200078e00ffULL, 0x000000491a417212ULL, 0x000fe200078efcffULL,
0x0000000113197824ULL, 0x040fe200028e0619ULL, 0x00000043123c7210ULL, 0x000fe20007fbe0ffULL,
0x00000001133f7824ULL, 0x000fe200030e063fULL, 0xfffffff85b5b7812ULL, 0x000fe200078ee240ULL,
0x0000001055157824ULL, 0x100fe200078e0214ULL, 0x00000041121a7210ULL, 0x000fe20007fde0ffULL,
0x0000001057177824ULL, 0x000fc400078e0214ULL, 0x0000001059417824ULL, 0x100fe200078e0214ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018157faeULL, 0x0003e2000e101c48ULL,
0x00000001133d7824ULL, 0x000fe400028e063dULL, 0x000000105b437824ULL, 0x000fe200078e0214ULL,
0x000000003e177faeULL, 0x0003e2000d901c48ULL, 0x00000001131b7824ULL, 0x000fc600030e061bULL,
0x000000003c417faeULL, 0x0003e8000d101c48ULL, 0x000000001a437faeULL, 0x0003e2000c101c48ULL,
0x0000000000c07947ULL, 0x000fea0003800000ULL, 0x000000101b1b7812ULL, 0x000fc800078ec0ffULL,
0x0000001b0e1b7211ULL, 0x000fca00078fe8ffULL, 0x000000011b157824ULL, 0x040fe400078e020eULL,
0x000000081b3c7824ULL, 0x040fe400078e00ffULL, 0x000000041b3d7836ULL, 0x000fe40000000000ULL,
0x000000011b187824ULL, 0x000fe200078e021aULL, 0xfffffff83c177812ULL, 0x000fe200078ee215ULL,
0x000000081b3f7836ULL, 0x000fe40000000000ULL, 0x0000000c1b417836ULL, 0x000fc40000000000ULL,
0x000000013d3c7824ULL, 0x040fe400078e021aULL, 0x000000013d1b7824ULL, 0x040fe400078e020eULL,
0x000000083d407824ULL, 0x000fe400078e00ffULL, 0x0000008018187825ULL, 0x000fc800078e00ffULL,
0x000000013f3e7824ULL, 0x040fe200078e021aULL, 0x0000004918157212ULL, 0x000fe200078efcffULL,
0x000000013f3d7824ULL, 0x140fe400078e020eULL, 0x000000083f427824ULL, 0x000fe200078e00ffULL,
0x0000001512187210ULL, 0x000fe20007f1e0ffULL, 0x00000001413f7824ULL, 0x040fe400078e020eULL,
0x0000000841547824ULL, 0x040fe200078e00ffULL, 0xfffffff842597812ULL, 0x000fe200078ee23dULL,
0x00000001411a7824ULL, 0x000fe200078e021aULL, 0xfffffff840417812ULL, 0x000fe200078ee21bULL,
0x000000803c3c7825ULL, 0x000fe200078e00ffULL, 0xfffffff8545b7812ULL, 0x000fc600078ee23fULL,
0x000000803e3e7825ULL, 0x000fe200078e00ffULL, 0x000000493c577212ULL, 0x000fc600078efcffULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0x000000493e557212ULL, 0x000fc600078efcffULL,
0x0000000113197824ULL, 0x000fe200000e0619ULL, 0x000000491a437212ULL, 0x000fe200078efcffULL,
0x0000001017157824ULL, 0x100fe200078e0214ULL, 0x00000057123c7210ULL, 0x000fe20007f1e0ffULL,
0x0000001041177824ULL, 0x100fe200078e0214ULL, 0x00000055123e7210ULL, 0x000fe20007f5e0ffULL,
0x0000001059417824ULL, 0x000fe200078e0214ULL, 0x00000043121a7210ULL, 0x000fe20007f7e0ffULL,
0x00000001133d7824ULL, 0x040fe200000e063dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018157faeULL, 0x0003e2000b901c48ULL, 0x00000001133f7824ULL, 0x000fc400010e063fULL,
0x000000105b437824ULL, 0x000fe200078e0214ULL, 0x000000003c177faeULL, 0x0003e2000b901c48ULL,
0x00000001131b7824ULL, 0x000fc600018e061bULL, 0x000000003e417faeULL, 0x0003e8000b901c48ULL,
0x000000001a437faeULL, 0x0003e4000b901c48ULL, 0x0000000800147824ULL, 0x000fe400078e00ffULL,
0x00000001ff1a7424ULL, 0x002fc600078e00ffULL, 0xfffffff014147812ULL, 0x000fca00078ec0ffULL,
0x0000000714157c36ULL, 0x000fe20008000000ULL, 0x0000000000007918ULL, 0x000fc80000000000ULL,
0x00000000150572caULL, 0x000fda00000e0000ULL, 0x000176a805057890ULL, 0x000fd2000fffe03fULL,
0x00000000ff0079b0ULL, 0x000fe20008000a45ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0176a81a151479a7ULL, 0x0002e4000850003fULL, 0x0176281a091a79a7ULL, 0x0022a4000850003fULL,
0x0000000000187805ULL, 0x000fce0000015200ULL, 0x0176281b090075a7ULL, 0x004ea4000800017fULL,
0x00000000005c0947ULL, 0x004fea0003800000ULL, 0x000000ffff3e7224ULL, 0x000fce00078e00ffULL,
0x000000103e00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000003c7805ULL, 0x000fce0000015200ULL, 0x0000003c183c7210ULL, 0x000fca0007f1e1ffULL,
0x000000013d3d7824ULL, 0x000fe200000e0e19ULL, 0x003d09003c00780cULL, 0x000fc80003f06070ULL,
0x000000ff3d00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403c00780cULL, 0x000fc80003f06070ULL, 0x000000ff3d00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff177819ULL, 0x000fc8000001143dULL,
0x0000003c17177211ULL, 0x000fca00078110ffULL, 0x000000ffff3c7224ULL, 0x000fca00000e063dULL,
0x0000000217177819ULL, 0x000fc8000000123cULL, 0x000000170000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013e3e7836ULL, 0x000fce0000000000ULL,
0x0176281b090075a7ULL, 0x000ea4000800017fULL, 0xfffffffc00a88947ULL, 0x004fea000383ffffULL,
0x0000002000177824ULL, 0x000fe400078e00ffULL, 0x00000007ff187e24ULL, 0x000fc6000f8e00ffULL,
0xffffff8017177812ULL, 0x000fc800078ec0ffULL, 0x0000008018187810ULL, 0x000fc80007ffe017ULL,
0x000000184d187210ULL, 0x000fca0007ffe049ULL, 0x01700000181a7984ULL, 0x000ea80000000800ULL,
0x0172000018197984ULL, 0x0009220000000800ULL, 0x000000111a00720bULL, 0x004fda0003f1d000ULL,
0x0000000000177806ULL, 0x000fc800000e0100ULL, 0x0000ffff171b7812ULL, 0x000fe2000780c0ffULL,
0x00000001ff177424ULL, 0x000fd800078e00ffULL, 0x0000000400008947ULL, 0x01afea0003800000ULL,
0x000000014b177836ULL, 0x000fe20000000000ULL, 0x000000111a00720bULL, 0x000fc80003f14000ULL,
0x000000001700720cULL, 0x000fd20003f45270ULL, 0x00000000003c7806ULL, 0x000fc800000e0100ULL,
0x000000070018ac11ULL, 0x000fe4000f8e38ffULL, 0x000000111a17a209ULL, 0x000fe40007810000ULL,
0x000000184d3ea210ULL, 0x000fe40007ffe049ULL, 0x000099103c187816ULL, 0x000fc600000000ffULL,
0x017400173e00a388ULL, 0x0003e20000000800ULL, 0x000000ff1800720cULL, 0x000fda0003f05270ULL,
0x0000000000b48947ULL, 0x002fea0003800000ULL, 0x000000111a187209ULL, 0x000fe40007810000ULL,
0x000000ff3cff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff003cff7812ULL, 0x000fe2000784c0ffULL,
0x0000001118177221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b17177820ULL, 0x000fc80000410000ULL,
0x00000017003d7308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff187819ULL, 0x000fca000001160eULL, 0x00001f183d177589ULL, 0x006e6400000e0000ULL,
0x0000003817387220ULL, 0x042fe20000410000ULL, 0x0000003917397220ULL, 0x040fe20000410000ULL,
0x0000003417347220ULL, 0x040fe20000410000ULL, 0x0000003517357220ULL, 0x040fe20000410000ULL,
0x0000003017307220ULL, 0x040fe20000410000ULL, 0x0000003117317220ULL, 0x040fe20000410000ULL,
0x0000002c172c7220ULL, 0x040fe20000410000ULL, 0x0000002d172d7220ULL, 0x040fe20000410000ULL,
0x0000002817287220ULL, 0x040fe20000410000ULL, 0x0000002917297220ULL, 0x040fe20000410000ULL,
0x0000002417247220ULL, 0x040fe20000410000ULL, 0x0000002517257220ULL, 0x040fe20000410000ULL,
0x0000002017207220ULL, 0x040fe20000410000ULL, 0x0000002117217220ULL, 0x040fe20000410000ULL,
0x0000001c171c7220ULL, 0x040fe20000410000ULL, 0x0000001d171d7220ULL, 0x000fce0000410000ULL,
0x0000003d16167220ULL, 0x004fe20000410000ULL, 0x000000000048a947ULL, 0x000fec0003800000ULL,
0x000000080e187811ULL, 0x000fca00078ff0ffULL, 0x00001f183d177589ULL, 0x002e6400000e0000ULL,
0x0000003a173a7220ULL, 0x042fe20000410000ULL, 0x0000003b173b7220ULL, 0x040fe20000410000ULL,
0x0000003617367220ULL, 0x040fe20000410000ULL, 0x0000003717377220ULL, 0x040fe20000410000ULL,
0x0000003217327220ULL, 0x040fe20000410000ULL, 0x0000003317337220ULL, 0x040fe20000410000ULL,
0x0000002e172e7220ULL, 0x040fe20000410000ULL, 0x0000002f172f7220ULL, 0x040fe20000410000ULL,
0x0000002a172a7220ULL, 0x040fe20000410000ULL, 0x0000002b172b7220ULL, 0x040fe20000410000ULL,
0x0000002617267220ULL, 0x040fe20000410000ULL, 0x0000002717277220ULL, 0x040fe20000410000ULL,
0x0000002217227220ULL, 0x040fe20000410000ULL, 0x0000002317237220ULL, 0x040fe20000410000ULL,
0x0000001e171e7220ULL, 0x040fe20000410000ULL, 0x0000001f171f7220ULL, 0x000fce0000410000ULL,
0x0000ffff1bff7812ULL, 0x000fe2000780603cULL, 0x00000001ff177424ULL, 0x002fe200078e00ffULL,
0x000000111a117209ULL, 0x000fd60007810000ULL, 0x800000111a1a0221ULL, 0x000fe20000010000ULL,
0x00007610ff170816ULL, 0x000fc60000000017ULL, 0x3fb8aa3b1a1a0820ULL, 0x000fc80000410000ULL,
0x0000001a00080308ULL, 0x000e640000000800ULL, 0x0000000819190220ULL, 0x002fce0000410000ULL,
0x0000001619167221ULL, 0x000fe20000010000ULL, 0x0000000000187805ULL, 0x000fe20000015200ULL,
0x00000008001a7824ULL, 0x000fca00078e00ffULL, 0xfffffff01a1b7812ULL, 0x000fc800078ec0ffULL,
0x0176b0471b0075a7ULL, 0x000e620008000147ULL, 0x000000071b3f7c36ULL, 0x000fe20008000000ULL,
0x00000000005c0947ULL, 0x002fec0003800000ULL, 0x000000ffff3c7224ULL, 0x000fce00078e00ffULL,
0x000000103c00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000001a7805ULL, 0x000fcc0000015200ULL, 0x0000001a183d7210ULL, 0x000fca0007f1e1ffULL,
0x000000011b1b7824ULL, 0x000fe200000e0e19ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff1b00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff1b00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff1a7819ULL, 0x000fc8000001141bULL,
0x0000003d1a1a7211ULL, 0x000fca00078110ffULL, 0x000000ffff1b7224ULL, 0x000fca00000e061bULL,
0x000000021a1a7819ULL, 0x000fc8000000121bULL, 0x0000001a0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013c3c7836ULL, 0x000fce0000000000ULL,
0x0176b0473f0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000991017177816ULL, 0x000fc800000000ffULL, 0x000000ff1700720cULL, 0x000fe20003f05270ULL,
0x0001400007177836ULL, 0x000fc80000000000ULL, 0x00000010053c7824ULL, 0x000fd000078e0217ULL,
0x0000000000180947ULL, 0x000fea0003800000ULL, 0x00000002ff197819ULL, 0x000fe4000001160eULL,
0x00000008ff03723eULL, 0x000fc600000000ffULL, 0x00000008191b7836ULL, 0x000fe20000000000ULL,
0x0000541003187816ULL, 0x000fca0000000003ULL, 0x00001f1918047589ULL, 0x0002a800000e0000ULL,
0x00001f1b18037589ULL, 0x0002e400000e0000ULL, 0x011800004518783bULL, 0x0022e20000000200ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x0000000418187232ULL, 0x08cfe40000000000ULL,
0x000000041a1a7232ULL, 0x000fe40000000000ULL, 0x0000000319197232ULL, 0x080fe40000000000ULL,
0x000000031b1b7232ULL, 0x000fce0000000000ULL, 0x000000003c3c783bULL, 0x000f220000004200ULL,
0x0000001002407824ULL, 0x000fcc00078e0217ULL, 0x000000004040783bULL, 0x000f620000004200ULL,
0x00000010ff687819ULL, 0x010fe4000001163cULL, 0x00000010ff697819ULL, 0x100fe4000001163dULL,
0x0000ffff3d627812ULL, 0x040fe400078ec0ffULL, 0x000000ff3d657812ULL, 0x000fe400078ec0ffULL,
0x00000018ff617819ULL, 0x000fe4000001163dULL, 0x0000ffff3e637812ULL, 0x000fc400078ec0ffULL,
0x00000010ff3d7819ULL, 0x000fe4000001163eULL, 0x000000ff3c667812ULL, 0x000fe400078ec0ffULL,
0x000000ff68687812ULL, 0x000fe400078ec0ffULL, 0x000000ff69697812ULL, 0x000fe400078ec0ffULL,
0x00000008ff627819ULL, 0x000fe40000011662ULL, 0x00000018ff607819ULL, 0x000fc4000001163cULL,
0x0000ffff3c677812ULL, 0x000fe400078ec0ffULL, 0x00000008ff6b7819ULL, 0x000fe40000011663ULL,
0x0000ffff3f3c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff3d3d7812ULL, 0x000fe400078ec0ffULL,
0x00000066ff66723eULL, 0x000fe400020006ffULL, 0x00000065ff65723eULL, 0x000fc400020006ffULL,
0x00000068ff68723eULL, 0x000fe400020006ffULL, 0x00000069ff69723eULL, 0x000fe400020006ffULL,
0x00000062ff6a723eULL, 0x000fe400020006ffULL, 0x0000006bff62723eULL, 0x000fe400020006ffULL,
0x0000003dff63723eULL, 0x000fe400020006ffULL, 0x00000008ff6b7819ULL, 0x000fc4000001163cULL,
0x00000008ff677819ULL, 0x000fe40000011667ULL, 0x00005410663c7816ULL, 0x000fe40000000068ULL,
0x00005410653d7816ULL, 0x000fe40000000069ULL, 0x00000010ff647819ULL, 0x000fe4000001163fULL,
0x00000060ff60723eULL, 0x000fe400020006ffULL, 0x00000061ff61723eULL, 0x000fe200020006ffULL,
0x0000003c1838723cULL, 0x008fe20000001838ULL, 0x00000067ff67723eULL, 0x000fc400020006ffULL,
0x000000ff3e5d7812ULL, 0x000fe400078ec0ffULL, 0x000000ff3f5c7812ULL, 0x000fe400078ec0ffULL,
0x000000ff64647812ULL, 0x000fe400078ec0ffULL, 0x00005410673c7816ULL, 0x000fe40000000060ULL,
0x000054106a3d7816ULL, 0x000fe40000000061ULL, 0x0000005dff5d723eULL, 0x000fc400020006ffULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x00000064ff64723eULL, 0x000fe200020006ffULL,
0x0000003c1834723cULL, 0x000fe20000001834ULL, 0x00000018ff5a7819ULL, 0x000fe4000001163eULL,
0x00000018ff597819ULL, 0x000fe4000001163fULL, 0x00000010ff5e7819ULL, 0x022fe40000011640ULL,
0x000054105d3c7816ULL, 0x000fc40000000063ULL, 0x000054105c3d7816ULL, 0x000fe40000000064ULL,
0x000000ff40567812ULL, 0x040fe400078ec0ffULL, 0x00000018ff467819ULL, 0x000fe40000011640ULL,
0x0000ffff405b7812ULL, 0x000fe200078ec0ffULL, 0x0000003c1830723cULL, 0x000fe20000001830ULL,
0x00000010ff5f7819ULL, 0x000fe40000011641ULL, 0x000000ff41547812ULL, 0x000fc400078ec0ffULL,
0x00000018ff477819ULL, 0x000fe40000011641ULL, 0x0000ffff41587812ULL, 0x000fe400078ec0ffULL,
0x00000010ff577819ULL, 0x100fe40000011642ULL, 0x000000ff42407812ULL, 0x000fe400078ec0ffULL,
0x00000018ff3e7819ULL, 0x000fe40000011642ULL, 0x00000010ff557819ULL, 0x000fc40000011643ULL,
0x000000ff43417812ULL, 0x000fe400078ec0ffULL, 0x00000018ff3f7819ULL, 0x000fe40000011643ULL,
0x0000005aff5a723eULL, 0x000fe400020006ffULL, 0x00000059ff59723eULL, 0x000fe400020006ffULL,
0x0000006bff6b723eULL, 0x000fe400020006ffULL, 0x0000ffff42427812ULL, 0x000fc400078ec0ffULL,
0x0000ffff43437812ULL, 0x000fe400078ec0ffULL, 0x000000ff5e5e7812ULL, 0x000fe400078ec0ffULL,
0x000000ff5f5f7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff5b7819ULL, 0x000fe4000001165bULL,
0x00000008ff587819ULL, 0x000fe40000011658ULL, 0x000000ff57577812ULL, 0x000fc400078ec0ffULL,
0x00005410623c7816ULL, 0x000fe4000000005aULL, 0x000054106b3d7816ULL, 0x000fe40000000059ULL,
0x000000ff55557812ULL, 0x000fe400078ec0ffULL, 0x00000008ff427819ULL, 0x000fe40000011642ULL,
0x00000008ff437819ULL, 0x000fe20000011643ULL, 0x0000003c182c723cULL, 0x000fe2000000182cULL,
0x00000056ff56723eULL, 0x000fc400020006ffULL, 0x00000054ff54723eULL, 0x000fe400020006ffULL,
0x00000046ff46723eULL, 0x000fe400020006ffULL, 0x00000047ff47723eULL, 0x000fe400020006ffULL,
0x00000040ff40723eULL, 0x000fe400020006ffULL, 0x00000041ff41723eULL, 0x000fe400020006ffULL,
0x0000005eff5e723eULL, 0x000fc400020006ffULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x0000005bff5b723eULL, 0x000fe400020006ffULL, 0x00000058ff58723eULL, 0x000fe400020006ffULL,
0x00000057ff57723eULL, 0x000fe400020006ffULL, 0x00000055ff55723eULL, 0x000fe400020006ffULL,
0x0000003eff3e723eULL, 0x000fc400020006ffULL, 0x0000003fff3f723eULL, 0x000fe400020006ffULL,
0x00000042ff42723eULL, 0x000fe400020006ffULL, 0x00000043ff43723eULL, 0x000fe400020006ffULL,
0x00005410563c7816ULL, 0x000fe4000000005eULL, 0x00005410543d7816ULL, 0x000fe4000000005fULL,
0x000054105b467816ULL, 0x000fc40000000046ULL, 0x0000541058477816ULL, 0x000fe40000000047ULL,
0x0000541040407816ULL, 0x000fe20000000057ULL, 0x0000003c1828723cULL, 0x000fe20000001828ULL,
0x0000541041417816ULL, 0x000fe40000000055ULL, 0x0000541042427816ULL, 0x000fe4000000003eULL,
0x0000541043437816ULL, 0x000fe2000000003fULL, 0x000000461824723cULL, 0x000fe20000001824ULL,
0x000000100f3c7824ULL, 0x000fca00078e0217ULL, 0x000000401820723cULL, 0x000fec0000001820ULL,
0x000000421818723cULL, 0x000fe2000000181cULL, 0x01180000441c783bULL, 0x0002e20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000100947ULL, 0x000fde0003800000ULL,
0x000000041c1c7232ULL, 0x08cfe40000000000ULL, 0x000000041e1e7232ULL, 0x000fe40000000000ULL,
0x000000031d1d7232ULL, 0x080fe40000000000ULL, 0x000000031f1f7232ULL, 0x000fce0000000000ULL,
0x0000001010407824ULL, 0x000fe200078e0217ULL, 0x000000003c3c783bULL, 0x000f2a0000004200ULL,
0x000000004040783bULL, 0x000f620000004200ULL, 0x00000010ff5c7819ULL, 0x110fe4000001163eULL,
0x000000ff3e5b7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff577819ULL, 0x000fc4000001163eULL,
0x0000ffff3e5d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff617819ULL, 0x100fe4000001163fULL,
0x000000ff3f5a7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff567819ULL, 0x000fe4000001163fULL,
0x0000ffff3f627812ULL, 0x000fe400078ec0ffULL, 0x00000010ff687819ULL, 0x000fc4000001163cULL,
0x00000010ff677819ULL, 0x000fe4000001163dULL, 0x00000018ff3e7819ULL, 0x022fe40000011640ULL,
0x00000018ff3f7819ULL, 0x000fe40000011641ULL, 0x000000ff3c647812ULL, 0x040fe400078ec0ffULL,
0x00000018ff5f7819ULL, 0x000fe4000001163cULL, 0x0000ffff3c667812ULL, 0x000fc400078ec0ffULL,
0x000000ff3d637812ULL, 0x040fe400078ec0ffULL, 0x00000018ff607819ULL, 0x000fe4000001163dULL,
0x0000ffff3d657812ULL, 0x000fe400078ec0ffULL, 0x00000018ff697819ULL, 0x000fe40000011642ULL,
0x00000018ff6a7819ULL, 0x000fe40000011643ULL, 0x00000010ff3c7819ULL, 0x000fc40000011640ULL,
0x000000ff40547812ULL, 0x040fe400078ec0ffULL, 0x0000ffff405e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff3d7819ULL, 0x000fe40000011641ULL, 0x000000ff41467812ULL, 0x040fe400078ec0ffULL,
0x0000ffff41587812ULL, 0x000fe400078ec0ffULL, 0x00000010ff597819ULL, 0x000fc40000011642ULL,
0x000000ff42407812ULL, 0x040fe400078ec0ffULL, 0x0000ffff42447812ULL, 0x000fe400078ec0ffULL,
0x00000010ff557819ULL, 0x000fe40000011643ULL, 0x000000ff43417812ULL, 0x040fe400078ec0ffULL,
0x0000ffff43477812ULL, 0x000fe400078ec0ffULL, 0x0000003eff42723eULL, 0x000fc400020006ffULL,
0x0000003fff43723eULL, 0x000fe400020006ffULL, 0x000000ff68687812ULL, 0x000fe400078ec0ffULL,
0x000000ff67677812ULL, 0x000fe400078ec0ffULL, 0x00000069ff3e723eULL, 0x000fe400020006ffULL,
0x0000006aff3f723eULL, 0x000fe400020006ffULL, 0x000000ff5c5c7812ULL, 0x000fc400078ec0ffULL,
0x000000ff61697812ULL, 0x000fe400078ec0ffULL, 0x00000008ff6a7819ULL, 0x000fe40000011662ULL,
0x00000064ff64723eULL, 0x000fe400020006ffULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x00000068ff68723eULL, 0x000fe400020006ffULL, 0x00000067ff67723eULL, 0x000fc400020006ffULL,
0x0000005cff61723eULL, 0x000fe400020006ffULL, 0x00000069ff62723eULL, 0x000fe400020006ffULL,
0x0000006aff5c723eULL, 0x000fe400020006ffULL, 0x000000ff3c697812ULL, 0x000fe400078ec0ffULL,
0x000000ff3d6a7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff667819ULL, 0x000fc40000011666ULL,
0x00000008ff657819ULL, 0x000fe40000011665ULL, 0x00005410643c7816ULL, 0x000fe40000000068ULL,
0x00005410633d7816ULL, 0x000fe40000000067ULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x00000060ff60723eULL, 0x000fe400020006ffULL, 0x00000066ff66723eULL, 0x000fe200020006ffULL,
0x0000003c1c38723cULL, 0x008fe20000001838ULL, 0x00000065ff65723eULL, 0x000fc400020006ffULL,
0x0000005bff5b723eULL, 0x000fe400020006ffULL, 0x0000005aff5a723eULL, 0x000fe400020006ffULL,
0x00005410663c7816ULL, 0x000fe4000000005fULL, 0x00005410653d7816ULL, 0x000fe40000000060ULL,
0x00000008ff5d7819ULL, 0x000fe4000001165dULL, 0x00000057ff57723eULL, 0x000fc400020006ffULL,
0x00000056ff56723eULL, 0x000fe200020006ffULL, 0x0000003c1c34723cULL, 0x000fe20000001834ULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x00000054ff54723eULL, 0x000fe400020006ffULL,
0x00000046ff46723eULL, 0x000fe400020006ffULL, 0x000054105b3c7816ULL, 0x000fe40000000061ULL,
0x000054105a3d7816ULL, 0x000fc40000000062ULL, 0x00000069ff63723eULL, 0x000fe400020006ffULL,
0x0000006aff64723eULL, 0x000fe400020006ffULL, 0x00000008ff5e7819ULL, 0x000fe2000001165eULL,
0x0000003c1c30723cULL, 0x000fe20000001830ULL, 0x00000008ff587819ULL, 0x000fe40000011658ULL,
0x0000005eff5e723eULL, 0x000fe400020006ffULL, 0x00000058ff58723eULL, 0x000fc400020006ffULL,
0x000054105d3c7816ULL, 0x000fe40000000057ULL, 0x000054105c3d7816ULL, 0x000fe40000000056ULL,
0x000000ff59597812ULL, 0x000fe400078ec0ffULL, 0x000000ff55557812ULL, 0x000fe400078ec0ffULL,
0x00000008ff447819ULL, 0x000fe20000011644ULL, 0x0000003c1c2c723cULL, 0x000fe2000000182cULL,
0x00000008ff477819ULL, 0x000fc40000011647ULL, 0x000054105e427816ULL, 0x000fe40000000042ULL,
0x0000541058437816ULL, 0x000fe40000000043ULL, 0x00005410543c7816ULL, 0x000fe40000000063ULL,
0x00005410463d7816ULL, 0x000fe40000000064ULL, 0x00000040ff40723eULL, 0x000fe200020006ffULL,
0x000000421c24723cULL, 0x000fe20000001824ULL, 0x00000041ff41723eULL, 0x000fc400020006ffULL,
0x00000059ff59723eULL, 0x000fe400020006ffULL, 0x00000055ff55723eULL, 0x000fe200020006ffULL,
0x0000003c1c28723cULL, 0x000fe20000001828ULL, 0x00000044ff44723eULL, 0x000fe200020006ffULL,
0x00000001ff437424ULL, 0x000fe200078e00ffULL, 0x00000047ff47723eULL, 0x000fe400020006ffULL,
0x0000541040407816ULL, 0x000fe40000000059ULL, 0x00000002003d7824ULL, 0x000fe200078e00ffULL,
0x000000074c3c7c11ULL, 0x000fc4000f8e18ffULL, 0x0000541041417816ULL, 0x000fe40000000055ULL,
0x00005410443e7816ULL, 0x000fe4000000003eULL, 0x00005410473f7816ULL, 0x000fe4000000003fULL,
0xfffffff83d427812ULL, 0x000fe200078ec0ffULL, 0x000000401c20723cULL, 0x000fe20000001820ULL,
0x0176c8433c3c79a7ULL, 0x0002ea000850003fULL, 0x0000003e1c18723cULL, 0x000fe20000001818ULL,
0x0176904342ff79a7ULL, 0x0003de0008500007ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x00000000001c7805ULL, 0x000fce0000015200ULL, 0x0000003d0a0075a7ULL, 0x008ee4000800017fULL,
0x00000000005c0947ULL, 0x008fea0003800000ULL, 0x000000ffff3e7224ULL, 0x000fce00078e00ffULL,
0x000000103e00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000001e7805ULL, 0x000fce0000015200ULL, 0x0000001e1c3f7210ULL, 0x000fca0007f1e1ffULL,
0x000000011f1f7824ULL, 0x000fe200000e0e1dULL, 0x003d09003f00780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403f00780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff1e7819ULL, 0x000fc8000001141fULL,
0x0000003f1e1e7211ULL, 0x000fca00078110ffULL, 0x000000ffff1f7224ULL, 0x000fca00000e061fULL,
0x000000021e1e7819ULL, 0x000fc8000000121fULL, 0x0000001e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013e3e7836ULL, 0x000fce0000000000ULL,
0x0000003d0a0075a7ULL, 0x000ee4000800017fULL, 0xfffffffc00a88947ULL, 0x008fea000383ffffULL,
0x000001000b1c7824ULL, 0x000fc800078e0253ULL, 0x000000c01c1e7836ULL, 0x000fca0000000000ULL,
0x000000601e1d7812ULL, 0x000fca00078ec0ffULL, 0x00000001483d7824ULL, 0x000fe200078e021dULL,
0x0000000000f89947ULL, 0x000fec0003800000ULL, 0x0000001e7a1d7248ULL, 0x000fe20007fe0000ULL,
0x00000010001f7824ULL, 0x000fc800078e00ffULL, 0x000000011d1d7824ULL, 0x000fe200078e0a1eULL,
0x000000101f3c7812ULL, 0x000fe400078ec0ffULL, 0x00000003ff1e7819ULL, 0x000fe4000001160eULL,
0x0000001d3c1d7248ULL, 0x000fc60007fe0000ULL, 0x000000041e3e7836ULL, 0x000fe40000000000ULL,
0x000000011d1d7824ULL, 0x100fe400078e0a3cULL, 0x000000011e1f7824ULL, 0x100fe400078e023cULL,
0x000000013e407824ULL, 0x000fe200078e023cULL, 0x0000001d1e00720cULL, 0x080fe20003f86070ULL,
0x000000081e3f7836ULL, 0x000fe20000000000ULL, 0x0000001d3e00720cULL, 0x000fe20003f66070ULL,
0x0000000c1e417836ULL, 0x000fc40000000000ULL, 0x000000011f1e7824ULL, 0x100fe200078e023dULL,
0x0000001d3f00720cULL, 0x080fe20003f46070ULL, 0x000000011f3e7824ULL, 0x100fe200078e020eULL,
0x0000001d4100720cULL, 0x000fe20003f06070ULL, 0x000000081f437824ULL, 0x002fe400078e00ffULL,
0x00000001401f7824ULL, 0x040fe400078e020eULL, 0x0000000840447824ULL, 0x040fe200078e00ffULL,
0xfffffff843427812ULL, 0x000fe200078ee23eULL, 0x0000000140407824ULL, 0x000fc400078e023dULL,
0x000000013f3f7824ULL, 0x000fe200078e023cULL, 0xfffffff844447812ULL, 0x000fe200078ee21fULL,
0x000000801e1e7825ULL, 0x000fc800078e00ffULL, 0x0000000141477824ULL, 0x000fe200078e023cULL,
0x000000491e1d7212ULL, 0x000fe200078efcffULL, 0x0000008040407825ULL, 0x000fc600078e00ffULL,
0x0000001d121e7210ULL, 0x000fe20007fbe0ffULL, 0x000000013f3c7824ULL, 0x100fe200078e023dULL,
0x00000049401d7212ULL, 0x000fe200078efcffULL, 0x00000001473e7824ULL, 0x000fe400078e023dULL,
0x000000013f437824ULL, 0x040fe400078e020eULL, 0x000000083f467824ULL, 0x000fe400078e00ffULL,
0x000000803c3c7825ULL, 0x000fc600078e00ffULL, 0xfffffff846467812ULL, 0x000fe200078ee243ULL,
0x000000803e3e7825ULL, 0x000fe200078e00ffULL, 0x000000493c437212ULL, 0x000fc600078efcffULL,
0x00000001131f7824ULL, 0x000fe200028e061fULL, 0x0000001d12407210ULL, 0x000fe20007fbe0ffULL,
0x0000000147547824ULL, 0x040fe200078e020eULL, 0x000000493e1d7212ULL, 0x000fe200078efcffULL,
0x0000000847477824ULL, 0x000fe400078e00ffULL, 0x0000000113417824ULL, 0x040fe200028e0641ULL,
0x00000043123c7210ULL, 0x000fe20007fbe0ffULL, 0x0000001046437824ULL, 0x100fe200078e0217ULL,
0x0000001d12127210ULL, 0x000fe20007fde0ffULL, 0x00000010421d7824ULL, 0x000fe200078e0217ULL,
0xfffffff847547812ULL, 0x000fe200078ee254ULL, 0x00000001133d7824ULL, 0x000fc400028e063dULL,
0x0000000113137824ULL, 0x000fe200030e063fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e1d7faeULL, 0x0003e2000e101c48ULL, 0x00000010443f7824ULL, 0x100fe400078e0217ULL,
0x0000001054477824ULL, 0x000fc600078e0217ULL, 0x00000000403f7faeULL, 0x0003e8000d901c48ULL,
0x000000003c437faeULL, 0x0003e8000d101c48ULL, 0x0000000012477faeULL, 0x0003e2000c101c48ULL,
0x0000000000c47947ULL, 0x000fea0003800000ULL, 0x00000010001d7824ULL, 0x000fca00078e00ffULL,
0x000000101d1d7812ULL, 0x000fc800078ec0ffULL, 0x0000001d0e1d7211ULL, 0x000fca00078fe8ffULL,
0x000000041d3c7836ULL, 0x000fe40000000000ULL, 0x000000011d1e7824ULL, 0x140fe400078e020eULL,
0x000000081d417824ULL, 0x000fe400078e00ffULL, 0x000000013c1f7824ULL, 0x040fe400078e020eULL,
0x000000083c447824ULL, 0x000fe200078e00ffULL, 0xfffffff841427812ULL, 0x002fe200078ee21eULL,
0x000000081d3e7836ULL, 0x000fc40000000000ULL, 0x000000011d1e7824ULL, 0x000fe200078e023dULL,
0xfffffff844447812ULL, 0x000fe200078ee21fULL, 0x0000000c1d1d7836ULL, 0x000fe40000000000ULL,
0x000000013e3f7824ULL, 0x040fe400078e020eULL, 0x000000083e467824ULL, 0x000fe400078e00ffULL,
0x000000801e1e7825ULL, 0x000fc600078e00ffULL, 0xfffffff846467812ULL, 0x000fe200078ee23fULL,
0x000000013c3c7824ULL, 0x100fe400078e023dULL, 0x000000013e3e7824ULL, 0x100fe400078e023dULL,
0x000000011d407824ULL, 0x040fe400078e023dULL, 0x000000011d437824ULL, 0x040fe400078e020eULL,
0x000000081d547824ULL, 0x000fe200078e00ffULL, 0x000000491e1d7212ULL, 0x000fe200078efcffULL,
0x000000803c3c7825ULL, 0x000fc600078e00ffULL, 0x0000001d121e7210ULL, 0x000fe20007f1e0ffULL,
0x000000803e3e7825ULL, 0x000fe200078e00ffULL, 0xfffffff854547812ULL, 0x000fe400078ee243ULL,
0x000000493c477212ULL, 0x080fe200078efcffULL, 0x0000008040407825ULL, 0x000fe200078e00ffULL,
0x000000493e437212ULL, 0x080fe400078efcffULL, 0x00000047123c7210ULL, 0x000fe20007f5e0ffULL,
0x00000001131f7824ULL, 0x040fe200000e061fULL, 0x00000049401d7212ULL, 0x000fe200078efcffULL,
0x0000001054477824ULL, 0x000fe200078e0217ULL, 0x00000043123e7210ULL, 0x000fe20007f1e0ffULL,
0x00000001133d7824ULL, 0x000fe200010e063dULL, 0x0000001d12127210ULL, 0x000fe20007f7e0ffULL,
0x00000010421d7824ULL, 0x000fc400078e0217ULL, 0x00000001133f7824ULL, 0x040fe400000e063fULL,
0x0000000113137824ULL, 0x000fe200018e0641ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e1d7faeULL, 0x0003e2000b901c48ULL, 0x0000001044417824ULL, 0x100fe400078e0217ULL,
0x0000001046437824ULL, 0x000fc600078e0217ULL, 0x000000003c417faeULL, 0x0003e8000b901c48ULL,
0x000000003e437faeULL, 0x0003e8000b901c48ULL, 0x0000000012477faeULL, 0x0003e4000b901c48ULL,
0x000000020d0d7836ULL, 0x000fe20000000000ULL, 0x0000000804057890ULL, 0x000fe2000fffe03fULL,
0xffffffffff127424ULL, 0x002fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000007d0d00720cULL, 0x000fca0003f06070ULL, 0x00000000ff0079b0ULL, 0x000ff00008000a45ULL,
0x00009000ff1e8b82ULL, 0x000e620000000a00ULL, 0x000000010d138824ULL, 0x000fe400078e024aULL,
0x00000007ff3c7e24ULL, 0x000fc4000f8e00ffULL, 0x00000004131e8825ULL, 0x002fca00078e001eULL,
0x000000081e128981ULL, 0x000322000c1e1900ULL, 0x0000000800137824ULL, 0x000fe400078e00ffULL,
0x00000001ff3e7424ULL, 0x000fc600078e00ffULL, 0xfffffff013137812ULL, 0x000fc800078ec0ffULL,
0x000176a813137810ULL, 0x000fe20007ffe03cULL, 0x0000000000007918ULL, 0x002fcc0000000000ULL,
0x0000083e131e79a7ULL, 0x0002e4000850003fULL, 0x0176483e093e79a7ULL, 0x0022a4000850003fULL,
0x00000000003c7805ULL, 0x000fce0000015200ULL, 0x0176483f090075a7ULL, 0x004ea4000800017fULL,
0x00000000005c0947ULL, 0x004fea0003800000ULL, 0x000000ffff1d7224ULL, 0x000fce00078e00ffULL,
0x000000101d00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000407805ULL, 0x000fce0000015200ULL, 0x000000403c407210ULL, 0x000fca0007f1e1ffULL,
0x0000000141417824ULL, 0x000fe200000e0e3dULL, 0x003d09004000780cULL, 0x000fc80003f06070ULL,
0x000000ff4100720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c404000780cULL, 0x000fc80003f06070ULL, 0x000000ff4100720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff137819ULL, 0x000fc80000011441ULL,
0x0000004013137211ULL, 0x000fca00078110ffULL, 0x000000ffff407224ULL, 0x000fca00000e0641ULL,
0x0000000213137819ULL, 0x000fc80000001240ULL, 0x000000130000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011d1d7836ULL, 0x000fce0000000000ULL,
0x0176483f090075a7ULL, 0x000ea4000800017fULL, 0xfffffffc00a88947ULL, 0x004fea000383ffffULL,
0x0000002000097824ULL, 0x002fe400078e00ffULL, 0x00000007ff3c7e24ULL, 0x000fe4000f8e00ffULL,
0x00000001ff1d7424ULL, 0x000fe200078e00ffULL, 0xffffff8009097812ULL, 0x000fc800078ec0ffULL,
0x000001003c3c7810ULL, 0x000fc80007ffe009ULL, 0x0000003c4d3c7210ULL, 0x000fca0007ffe049ULL,
0x017000003c3e7984ULL, 0x000e680000000800ULL, 0x017200003c137984ULL, 0x0004a20000000800ULL,
0x000000113e00720bULL, 0x002fda0003f1d000ULL, 0x0000000000097806ULL, 0x000fc800000e0100ULL,
0x0000ffff093d7812ULL, 0x000fe2000780c0ffULL, 0x000000ffff097224ULL, 0x000fd800078e0011ULL,
0x0000000400008947ULL, 0x00cfea0003800000ULL, 0x000000024b097836ULL, 0x000fe20000000000ULL,
0x000000113e00720bULL, 0x000fc80003f14000ULL, 0x000000000900720cULL, 0x000fda0003f45270ULL,
0x00000007003cac11ULL, 0x000fe4000f8e38ffULL, 0x000000113e09a209ULL, 0x000fe40007810000ULL,
0x0000003c4d40a210ULL, 0x000fe40007ffe049ULL, 0x00000000003c7806ULL, 0x000fc600000e0100ULL,
0x017400094000a388ULL, 0x0003e20000000800ULL, 0x000099103c1d7816ULL, 0x000fc800000000ffULL,
0x000000ff1d00720cULL, 0x000fda0003f05270ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x000000113e407209ULL, 0x000fe40007810000ULL, 0x000000ff3cff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff003cff7812ULL, 0x000fe2000784c0ffULL, 0x0000001140097221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b09097820ULL, 0x000fc80000410000ULL, 0x00000009001d7308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff407819ULL, 0x000fca000001160eULL,
0x00001f401d097589ULL, 0x006e6400000e0000ULL, 0x0000003809387220ULL, 0x042fe20000410000ULL,
0x0000003909397220ULL, 0x040fe20000410000ULL, 0x0000003409347220ULL, 0x040fe20000410000ULL,
0x0000003509357220ULL, 0x040fe20000410000ULL, 0x0000003009307220ULL, 0x040fe20000410000ULL,
0x0000003109317220ULL, 0x040fe20000410000ULL, 0x0000002c092c7220ULL, 0x040fe20000410000ULL,
0x0000002d092d7220ULL, 0x040fe20000410000ULL, 0x0000002809287220ULL, 0x040fe20000410000ULL,
0x0000002909297220ULL, 0x040fe20000410000ULL, 0x0000002409247220ULL, 0x040fe20000410000ULL,
0x0000002509257220ULL, 0x040fe20000410000ULL, 0x0000002009207220ULL, 0x040fe20000410000ULL,
0x0000002109217220ULL, 0x040fe20000410000ULL, 0x0000001809187220ULL, 0x040fe20000410000ULL,
0x0000001909197220ULL, 0x000fce0000410000ULL, 0x0000001d16167220ULL, 0x004fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x000000080e407811ULL, 0x000fca00078ff0ffULL,
0x00001f401d097589ULL, 0x002e6400000e0000ULL, 0x0000003a093a7220ULL, 0x042fe20000410000ULL,
0x0000003b093b7220ULL, 0x040fe20000410000ULL, 0x0000003609367220ULL, 0x040fe20000410000ULL,
0x0000003709377220ULL, 0x040fe20000410000ULL, 0x0000003209327220ULL, 0x040fe20000410000ULL,
0x0000003309337220ULL, 0x040fe20000410000ULL, 0x0000002e092e7220ULL, 0x040fe20000410000ULL,
0x0000002f092f7220ULL, 0x040fe20000410000ULL, 0x0000002a092a7220ULL, 0x040fe20000410000ULL,
0x0000002b092b7220ULL, 0x040fe20000410000ULL, 0x0000002609267220ULL, 0x040fe20000410000ULL,
0x0000002709277220ULL, 0x040fe20000410000ULL, 0x0000002209227220ULL, 0x040fe20000410000ULL,
0x0000002309237220ULL, 0x040fe20000410000ULL, 0x0000001a091a7220ULL, 0x040fe20000410000ULL,
0x0000001b091b7220ULL, 0x000fce0000410000ULL, 0x0000ffff3dff7812ULL, 0x000fe2000780603cULL,
0x00000001ff1d7424ULL, 0x000fe200078e00ffULL, 0x000000113e097209ULL, 0x002fd60007810000ULL,
0x800000093e3e0221ULL, 0x000fe20000010000ULL, 0x00007610ff1d0816ULL, 0x000fc6000000001dULL,
0x3fb8aa3b3e3e0820ULL, 0x000fc80000410000ULL, 0x0000003e00080308ULL, 0x000e640000000800ULL,
0x0000000813130220ULL, 0x002fce0000410000ULL, 0x0000001613167221ULL, 0x000fce0000010000ULL,
0x00000000003c7805ULL, 0x000fce0000015200ULL, 0x0000000800117824ULL, 0x000fca00078e00ffULL,
0xfffffff011117812ULL, 0x000fc800078ec0ffULL, 0x0176a815110075a7ULL, 0x000e620008000147ULL,
0x0000000711137c36ULL, 0x000fe20008000000ULL, 0x00000000005c0947ULL, 0x002fec0003800000ULL,
0x000000ffff407224ULL, 0x000fce00078e00ffULL, 0x000000104000780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000003e7805ULL, 0x000fce0000015200ULL,
0x0000003e3c3e7210ULL, 0x000fca0007f1e1ffULL, 0x000000013f3f7824ULL, 0x000fe200000e0e3dULL,
0x003d09003e00780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403e00780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff117819ULL, 0x000fc8000001143fULL, 0x0000003e11117211ULL, 0x000fca00078110ffULL,
0x000000ffff3e7224ULL, 0x000fca00000e063fULL, 0x0000000211117819ULL, 0x000fc8000000123eULL,
0x000000110000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000140407836ULL, 0x000fce0000000000ULL, 0x0176a815130075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000099101d117816ULL, 0x000fe200000000ffULL,
0x0001300007077836ULL, 0x000fc60000000000ULL, 0x000000ff1100720cULL, 0x000fe20003f05270ULL,
0x00000010053c7824ULL, 0x000fd800078e0207ULL, 0x0000000000180947ULL, 0x000fea0003800000ULL,
0x00000002ff047819ULL, 0x000fe4000001160eULL, 0x00000008ff03723eULL, 0x000fc600000000ffULL,
0x0000000804147836ULL, 0x000fe20000000000ULL, 0x0000541003057816ULL, 0x000fca0000000003ULL,
0x00001f0405047589ULL, 0x0002a800000e0000ULL, 0x00001f1405037589ULL, 0x0002e400000e0000ULL,
0x012000004544783bULL, 0x000e620000000200ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x0000000444447232ULL, 0x086fe40000000000ULL, 0x0000000446467232ULL, 0x000fe40000000000ULL,
0x0000000345457232ULL, 0x088fe40000000000ULL, 0x0000000347477232ULL, 0x000fce0000000000ULL,
0x000000003c3c783bULL, 0x000f620000004200ULL, 0x0000001002407824ULL, 0x000fe200078e0207ULL,
0x000000070e057812ULL, 0x002fe200078ec0ffULL, 0x0000000206027836ULL, 0x000fc60000000000ULL,
0x0000000805057812ULL, 0x000fe200078ef80eULL, 0x000000004040783bULL, 0x000e680000004200ULL,
0x0000000805057824ULL, 0x000fca00078e00ffULL, 0xfffffff805027812ULL, 0x000fe400078ee202ULL,
0x0000ffff3c627812ULL, 0x028fe400078ec0ffULL, 0x00000010ff657819ULL, 0x000fe4000001163cULL,
0x00000010ff647819ULL, 0x000fe4000001163dULL, 0x0000ffff3d637812ULL, 0x000fe400078ec0ffULL,
0x00000008ff627819ULL, 0x000fc40000011662ULL, 0x00000010ff157819ULL, 0x000fe4000001163eULL,
0x00000010ff5e7819ULL, 0x000fe4000001163fULL, 0x0000ffff3f5f7812ULL, 0x000fe400078ec0ffULL,
0x000000ff3c617812ULL, 0x000fe400078ec0ffULL, 0x000000ff3d607812ULL, 0x000fe400078ec0ffULL,
0x000000ff65657812ULL, 0x000fc400078ec0ffULL, 0x000000ff64647812ULL, 0x000fe400078ec0ffULL,
0x00000008ff667819ULL, 0x000fe40000011663ULL, 0x00000062ff63723eULL, 0x000fe400020006ffULL,
0x000000ff15627812ULL, 0x000fe400078ec0ffULL, 0x000000ff5e5e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff147819ULL, 0x002fc40000011640ULL, 0x00000008ff157819ULL, 0x000fe4000001165fULL,
0x00000061ff61723eULL, 0x000fe400020006ffULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x00000065ff65723eULL, 0x000fe400020006ffULL, 0x00000064ff64723eULL, 0x000fe400020006ffULL,
0x0000005eff5f723eULL, 0x000fc400020006ffULL, 0x00000015ff5e723eULL, 0x000fe400020006ffULL,
0x000000ff14677812ULL, 0x000fe400078ec0ffULL, 0x00000018ff5b7819ULL, 0x000fe4000001163cULL,
0x00000018ff5c7819ULL, 0x000fe4000001163dULL, 0x0000541061147816ULL, 0x000fe40000000065ULL,
0x0000541060157816ULL, 0x000fc40000000064ULL, 0x0000005bff5b723eULL, 0x000fe400020006ffULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x00000066ff66723eULL, 0x000fe200020006ffULL,
0x000000144438723cULL, 0x000fe20000001838ULL, 0x000000ff3e5a7812ULL, 0x040fe400078ec0ffULL,
0x000000ff3f577812ULL, 0x000fe400078ec0ffULL, 0x0000ffff3e5d7812ULL, 0x000fc400078ec0ffULL,
0x0000541063147816ULL, 0x000fe4000000005bULL, 0x0000541066157816ULL, 0x000fe4000000005cULL,
0x0000005aff5a723eULL, 0x000fe400020006ffULL, 0x00000057ff57723eULL, 0x000fe400020006ffULL,
0x00000062ff62723eULL, 0x000fe200020006ffULL, 0x000000144434723cULL, 0x000fe20000001834ULL,
0x00000018ff557819ULL, 0x000fc4000001163eULL, 0x00000018ff547819ULL, 0x000fe4000001163fULL,
0x00000008ff5d7819ULL, 0x000fe4000001165dULL, 0x000054105a147816ULL, 0x000fe40000000062ULL,
0x0000541057157816ULL, 0x000fe4000000005fULL, 0x00000010ff597819ULL, 0x000fe40000011641ULL,
0x00000055ff55723eULL, 0x000fc400020006ffULL, 0x00000054ff54723eULL, 0x000fe200020006ffULL,
0x000000144430723cULL, 0x000fe20000001830ULL, 0x0000005dff5d723eULL, 0x000fe400020006ffULL,
0x000000ff403f7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff40587812ULL, 0x000fe400078ec0ffULL,
0x000000ff413e7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff41567812ULL, 0x000fc400078ec0ffULL,
0x000000ff59597812ULL, 0x000fe400078ec0ffULL, 0x000054105d147816ULL, 0x000fe40000000055ULL,
0x000054105e157816ULL, 0x000fe20000000054ULL, 0x0000020000547824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe40000011640ULL, 0x00000018ff3d7819ULL, 0x000fe40000011641ULL,
0x0000003fff3f723eULL, 0x000fe200020006ffULL, 0x00000014442c723cULL, 0x000fe2000000182cULL,
0x0000003eff3e723eULL, 0x000fc400020006ffULL, 0x00000067ff60723eULL, 0x000fe400020006ffULL,
0x00000008ff587819ULL, 0x000fe40000011658ULL, 0x00000059ff59723eULL, 0x000fe400020006ffULL,
0x00000008ff567819ULL, 0x000fe40000011656ULL, 0x00000010ff407819ULL, 0x000fe40000011642ULL,
0x000000ff42137812ULL, 0x000fc400078ec0ffULL, 0x00000018ff057819ULL, 0x000fe40000011642ULL,
0x00000010ff417819ULL, 0x100fe40000011643ULL, 0x000000ff431d7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff117819ULL, 0x000fe40000011643ULL, 0x0000ffff42427812ULL, 0x000fe400078ec0ffULL,
0x0000ffff43437812ULL, 0x000fc400078ec0ffULL, 0x0000003cff3c723eULL, 0x000fe400020006ffULL,
0x0000003dff3d723eULL, 0x000fe400020006ffULL, 0x00000058ff58723eULL, 0x000fe400020006ffULL,
0x00000056ff56723eULL, 0x000fe400020006ffULL, 0x000054103f147816ULL, 0x000fe40000000060ULL,
0x000054103e157816ULL, 0x000fc40000000059ULL, 0x000000ff40407812ULL, 0x000fe400078ec0ffULL,
0x000000ff41417812ULL, 0x000fe400078ec0ffULL, 0xfffff80054547812ULL, 0x000fe200078ec0ffULL,
0x000000144428723cULL, 0x000fe20000001828ULL, 0x00000008ff427819ULL, 0x000fe40000011642ULL,
0x00000008ff437819ULL, 0x000fe40000011643ULL, 0x00005410583c7816ULL, 0x000fc4000000003cULL,
0x00005410563d7816ULL, 0x000fe2000000003dULL, 0x0000000754157c36ULL, 0x000fe20008000000ULL,
0x00000013ff13723eULL, 0x000fe400020006ffULL, 0x0000001dff1d723eULL, 0x000fe400020006ffULL,
0x00000005ff05723eULL, 0x000fe200020006ffULL, 0x0000003c4424723cULL, 0x000fe20000001824ULL,
0x00000011ff11723eULL, 0x000fe400020006ffULL, 0x00000040ff40723eULL, 0x000fc400020006ffULL,
0x00000041ff41723eULL, 0x000fe400020006ffULL, 0x00000042ff42723eULL, 0x000fe200020006ffULL,
0x00000010023c7824ULL, 0x000fe200078e0215ULL, 0x00000043ff43723eULL, 0x000fe400020006ffULL,
0x0000541013407816ULL, 0x000fe40000000040ULL, 0x000054101d417816ULL, 0x000fe20000000041ULL,
0x012000003c3c783bULL, 0x000e620000000200ULL, 0x0000541042427816ULL, 0x000fc40000000005ULL,
0x0000541043437816ULL, 0x000fc60000000011ULL, 0x000000404420723cULL, 0x000fec0000001820ULL,
0x000000424418723cULL, 0x000fe20000001818ULL, 0x000000100f407824ULL, 0x000fe200078e0207ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000100947ULL, 0x000fde0003800000ULL,
0x000000043c3c7232ULL, 0x086fe40000000000ULL, 0x000000043e3e7232ULL, 0x000fe40000000000ULL,
0x000000033d3d7232ULL, 0x080fe40000000000ULL, 0x000000033f3f7232ULL, 0x000fce0000000000ULL,
0x0000001010447824ULL, 0x000fe200078e0207ULL, 0x000000004040783bULL, 0x000eea0000004200ULL,
0x000000004444783bULL, 0x000f620000004200ULL, 0x00000018ff057819ULL, 0x008fe40000011642ULL,
0x00000010ff617819ULL, 0x000fe40000011640ULL, 0x00000010ff627819ULL, 0x000fc40000011641ULL,
0x00000018ff637819ULL, 0x024fe40000011646ULL, 0x00000010ff5f7819ULL, 0x000fe40000011642ULL,
0x000000ff42577812ULL, 0x040fe400078ec0ffULL, 0x0000ffff425b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff117819ULL, 0x000fe40000011644ULL, 0x000000ff44427812ULL, 0x000fc400078ec0ffULL,
0x00000018ff157819ULL, 0x000fe40000011644ULL, 0x0000ffff44547812ULL, 0x000fe400078ec0ffULL,
0x00000005ff44723eULL, 0x000fe400020006ffULL, 0x00000063ff05723eULL, 0x000fe400020006ffULL,
0x000000ff405c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff415d7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff137819ULL, 0x000fe40000011643ULL, 0x000000ff61617812ULL, 0x000fe400078ec0ffULL,
0x000000ff62637812ULL, 0x000fe400078ec0ffULL, 0x0000ffff400f7812ULL, 0x000fe400078ec0ffULL,
0x000000ff46147812ULL, 0x000fe400078ec0ffULL, 0x000000ff47657812ULL, 0x000fc400078ec0ffULL,
0x00000018ff647819ULL, 0x000fe40000011647ULL, 0x00000010ff5e7819ULL, 0x000fe40000011643ULL,
0x000000ff43567812ULL, 0x040fe400078ec0ffULL, 0x0000ffff43107812ULL, 0x000fe400078ec0ffULL,
0x0000ffff41607812ULL, 0x000fe400078ec0ffULL, 0x0000005cff5c723eULL, 0x000fc400020006ffULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x00000013ff43723eULL, 0x000fe400020006ffULL,
0x00000061ff61723eULL, 0x000fe400020006ffULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x00000014ff13723eULL, 0x000fe400020006ffULL, 0x00000008ff627819ULL, 0x000fc4000001160fULL,
0x00000065ff14723eULL, 0x000fe400020006ffULL, 0x00000064ff0f723eULL, 0x000fe400020006ffULL,
0x00000008ff647819ULL, 0x000fe40000011610ULL, 0x000000ff11657812ULL, 0x000fe400078ec0ffULL,
0x00000018ff587819ULL, 0x000fe40000011640ULL, 0x00000018ff597819ULL, 0x000fc40000011641ULL,
0x00000008ff607819ULL, 0x000fe40000011660ULL, 0x000054105c107816ULL, 0x000fe40000000061ULL,
0x000054105d117816ULL, 0x000fe40000000063ULL, 0x00000058ff58723eULL, 0x000fe400020006ffULL,
0x00000059ff59723eULL, 0x000fe400020006ffULL, 0x00000062ff62723eULL, 0x000fe200020006ffULL,
0x000000103c38723cULL, 0x002fe20000001838ULL, 0x00000060ff60723eULL, 0x000fc400020006ffULL,
0x000000ff5f5f7812ULL, 0x000fe400078ec0ffULL, 0x000000ff5e5e7812ULL, 0x000fe400078ec0ffULL,
0x0000541062107816ULL, 0x000fe40000000058ULL, 0x0000541060117816ULL, 0x000fe40000000059ULL,
0x00000057ff57723eULL, 0x000fe400020006ffULL, 0x00000056ff56723eULL, 0x000fc400020006ffULL,
0x0000005fff5f723eULL, 0x000fe200020006ffULL, 0x000000103c34723cULL, 0x000fe20000001834ULL,
0x0000005eff5e723eULL, 0x000fe400020006ffULL, 0x00000008ff5b7819ULL, 0x000fe4000001165bULL,
0x00000064ff64723eULL, 0x000fe400020006ffULL, 0x0000541057107816ULL, 0x000fe4000000005fULL,
0x0000541056117816ULL, 0x000fc4000000005eULL, 0x0000005bff5b723eULL, 0x000fe400020006ffULL,
0x00000010ff5a7819ULL, 0x100fe40000011645ULL, 0x000000ff45417812ULL, 0x000fe200078ec0ffULL,
0x000000103c30723cULL, 0x000fe20000001830ULL, 0x000000ff5a5a7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff1d7819ULL, 0x000fe40000011645ULL, 0x00000010ff557819ULL, 0x000fc40000011646ULL,
0x000054105b107816ULL, 0x000fe40000000044ULL, 0x0000541064117816ULL, 0x000fe40000000043ULL,
0x00000010ff407819ULL, 0x000fe40000011647ULL, 0x0000ffff45457812ULL, 0x000fe400078ec0ffULL,
0x0000ffff46467812ULL, 0x000fe200078ec0ffULL, 0x000000103c2c723cULL, 0x000fe2000000182cULL,
0x0000ffff47477812ULL, 0x000fc400078ec0ffULL, 0x00000042ff42723eULL, 0x000fe400020006ffULL,
0x00000041ff41723eULL, 0x000fe400020006ffULL, 0x00000065ff5c723eULL, 0x000fe400020006ffULL,
0x0000005aff5a723eULL, 0x000fe400020006ffULL, 0x000000ff40107812ULL, 0x000fe400078ec0ffULL,
0x00000008ff547819ULL, 0x000fc40000011654ULL, 0x00000008ff457819ULL, 0x000fe40000011645ULL,
0x000000ff55587812ULL, 0x000fe400078ec0ffULL, 0x00000008ff467819ULL, 0x000fe40000011646ULL,
0x00000008ff477819ULL, 0x000fe40000011647ULL, 0x0000541042407816ULL, 0x000fe4000000005cULL,
0x0000541041417816ULL, 0x000fc4000000005aULL, 0x00000015ff15723eULL, 0x000fe400020006ffULL,
0x0000001dff1d723eULL, 0x000fe400020006ffULL, 0x00000054ff54723eULL, 0x000fe200020006ffULL,
0x000000403c28723cULL, 0x000fe20000001828ULL, 0x00000045ff55723eULL, 0x000fe400020006ffULL,
0x00000058ff58723eULL, 0x000fe400020006ffULL, 0x00000010ff10723eULL, 0x000fc400020006ffULL,
0x00000046ff46723eULL, 0x000fe200020006ffULL, 0x00000001ff407424ULL, 0x000fe200078e00ffULL,
0x00000047ff47723eULL, 0x000fe400020006ffULL, 0x000000074c117c11ULL, 0x000fe4000f8e18ffULL,
0x0000541054547816ULL, 0x000fe40000000015ULL, 0x0000541055557816ULL, 0x000fe4000000001dULL,
0x0000541013587816ULL, 0x000fc40000000058ULL, 0x0000541014597816ULL, 0x000fe40000000010ULL,
0x0000541046467816ULL, 0x000fe20000000005ULL, 0x0176c840111079a7ULL, 0x0002a2000850003fULL,
0x0000541047477816ULL, 0x000fe2000000000fULL, 0x000000543c24723cULL, 0x000fe20000001824ULL,
0x000000074b157c11ULL, 0x000fc8000f8e18ffULL, 0x0176984015ff79a7ULL, 0x0003e2000850003fULL,
0x000000583c20723cULL, 0x000fec0000001820ULL, 0x000000463c18723cULL, 0x000fde0000001818ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x0000000000147805ULL, 0x002fce0000015200ULL,
0x000000110a0075a7ULL, 0x004e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff0f7224ULL, 0x000fce00078e00ffULL, 0x000000100f00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000003c7805ULL, 0x000fce0000015200ULL,
0x0000003c143c7210ULL, 0x000fca0007f1e1ffULL, 0x000000013d3d7824ULL, 0x000fe200000e0e15ULL,
0x003d09003c00780cULL, 0x000fc80003f06070ULL, 0x000000ff3d00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403c00780cULL, 0x000fc80003f06070ULL,
0x000000ff3d00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff057819ULL, 0x000fc8000001143dULL, 0x0000003c05057211ULL, 0x000fca00078110ffULL,
0x000000ffff3c7224ULL, 0x000fca00000e063dULL, 0x0000000205057819ULL, 0x000fc8000000123cULL,
0x000000050000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000010f0f7836ULL, 0x000fce0000000000ULL, 0x000000110a0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000010b0a7836ULL, 0x000fca0000000000ULL,
0x0000007b0a00720cULL, 0x000fda0003f06070ULL, 0x0000000400e80947ULL, 0x000fea0003800000ULL,
0x00008e00ff107b82ULL, 0x000e620000000a00ULL, 0x000000020b0a7836ULL, 0x000fe20000000000ULL,
0x0000850000057ab9ULL, 0x000fe20000000800ULL, 0x000001001c1c7836ULL, 0x000fe40000000000ULL,
0x00000005120f7c24ULL, 0x010fe2000f8e02ffULL, 0x0000007b0a00720cULL, 0x000fe40003f06070ULL,
0x000000601c057812ULL, 0x000fe200078ec0ffULL, 0x000000800f0f7824ULL, 0x000fc800078e00ffULL,
0x00000001480a7824ULL, 0x000fe400078e0205ULL, 0x000000800f107825ULL, 0x002fc800078e0010ULL,
0x0000000000f88947ULL, 0x000fea0003800000ULL, 0x0000001c7a057248ULL, 0x000fe20007fe0000ULL,
0x00000010000f7824ULL, 0x000fc800078e00ffULL, 0x0000000105057824ULL, 0x000fe200078e0a1cULL,
0x000000100f147812ULL, 0x000fe400078ec0ffULL, 0x00000003ff0f7819ULL, 0x000fe4000001160eULL,
0x0000000514057248ULL, 0x000fc60007fe0000ULL, 0x000000080f157836ULL, 0x000fe40000000000ULL,
0x0000000105057824ULL, 0x100fe400078e0a14ULL, 0x000000040f137836ULL, 0x000fe40000000000ULL,
0x0000000c0f1c7836ULL, 0x000fe20000000000ULL, 0x000000051500720cULL, 0x0c0fe20003f46070ULL,
0x0000000115157824ULL, 0x100fe200078e0214ULL, 0x000000050f00720cULL, 0x0c0fe20003f86070ULL,
0x000000010f0f7824ULL, 0x100fe200078e0214ULL, 0x000000051300720cULL, 0x0c0fe20003f66070ULL,
0x0000000113137824ULL, 0x100fe200078e0214ULL, 0x000000051c00720cULL, 0x040fe20003f06070ULL,
0x000000011c3f7824ULL, 0x000fc400078e0214ULL, 0x0000000115147824ULL, 0x040fe400078e020eULL,
0x00000008151d7824ULL, 0x000fe400078e00ffULL, 0x000000010f1c7824ULL, 0x100fe400078e020aULL,
0x00000001133c7824ULL, 0x000fe200078e020aULL, 0xfffffff81d447812ULL, 0x000fe200078ee214ULL,
0x000000010f057824ULL, 0x040fe400078e020eULL, 0x000000080f407824ULL, 0x000fc400078e00ffULL,
0x00000001130f7824ULL, 0x040fe400078e020eULL, 0x0000000813427824ULL, 0x000fe200078e00ffULL,
0xfffffff840407812ULL, 0x000fe200078ee205ULL, 0x000000801c1c7825ULL, 0x000fc600078e00ffULL,
0xfffffff842427812ULL, 0x000fe200078ee20fULL, 0x000000803c3c7825ULL, 0x000fe200078e00ffULL,
0x000000491c0f7212ULL, 0x000fc600078efcffULL, 0x0000000115147824ULL, 0x100fe200078e020aULL,
0x000000493c057212ULL, 0x000fe200078efcffULL, 0x000000013f3e7824ULL, 0x040fe200078e020aULL,
0x0000000f101c7210ULL, 0x000fe20007fbe0ffULL, 0x000000013f0a7824ULL, 0x040fe200078e020eULL,
0x00000005103c7210ULL, 0x000fe20007fde0ffULL, 0x000000083f137824ULL, 0x000fe400078e00ffULL,
0x0000008014147825ULL, 0x000fc600078e00ffULL, 0xfffffff8130a7812ULL, 0x000fe200078ee20aULL,
0x000000803e3e7825ULL, 0x000fe200078e00ffULL, 0x00000049140f7212ULL, 0x000fc600078efcffULL,
0x00000001111d7824ULL, 0x040fe200028e061dULL, 0x000000493e057212ULL, 0x000fe200078efcffULL,
0x00000001113d7824ULL, 0x040fe200030e063dULL, 0x0000000f10147210ULL, 0x000fe20007fbe0ffULL,
0x0000001040137824ULL, 0x100fe200078e0207ULL, 0x0000000510107210ULL, 0x000fe20007fde0ffULL,
0x0000001042417824ULL, 0x100fe400078e0207ULL, 0x0000001044057824ULL, 0x000fe200078e0207ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c137faeULL, 0x0003e2000e101c48ULL,
0x0000000111157824ULL, 0x000fc400028e0615ULL, 0x000000100a077824ULL, 0x000fe200078e0207ULL,
0x000000003c417faeULL, 0x0003e2000d901c48ULL, 0x0000000111117824ULL, 0x000fc600030e063fULL,
0x0000000014057faeULL, 0x0003e8000d101c48ULL, 0x0000000010077faeULL, 0x0003e2000c101c48ULL,
0x0000000000c47947ULL, 0x000fea0003800000ULL, 0x0000001000057824ULL, 0x000fca00078e00ffULL,
0x0000001005057812ULL, 0x000fc800078ec0ffULL, 0x000000050e057211ULL, 0x000fca00078fe8ffULL,
0x00000001050f7824ULL, 0x040fe400078e020eULL, 0x0000000805407824ULL, 0x040fe400078e00ffULL,
0x0000000405137836ULL, 0x000fe40000000000ULL, 0x00000008051d7836ULL, 0x000fe20000000000ULL,
0xfffffff840407812ULL, 0x000fe200078ee20fULL, 0x0000000105147824ULL, 0x000fe400078e020aULL,
0x0000000c053d7836ULL, 0x000fc40000000000ULL, 0x00000001131c7824ULL, 0x040fe400078e020aULL,
0x00000001130f7824ULL, 0x040fe400078e020eULL, 0x0000000813427824ULL, 0x000fe400078e00ffULL,
0x000000011d3e7824ULL, 0x040fe400078e020aULL, 0x000000011d137824ULL, 0x040fe400078e020eULL,
0x000000081d447824ULL, 0x000fc400078e00ffULL, 0x0000008014147825ULL, 0x000fc800078e00ffULL,
0x000000013d1d7824ULL, 0x040fe200078e020eULL, 0x0000004914057212ULL, 0x000fe200078efcffULL,
0x000000083d467824ULL, 0x040fe400078e00ffULL, 0x000000013d3c7824ULL, 0x000fe200078e020aULL,
0xfffffff8420a7812ULL, 0x000fe200078ee20fULL, 0x000000803e3e7825ULL, 0x000fe200078e00ffULL,
0xfffffff844427812ULL, 0x000fe400078ee213ULL, 0xfffffff846447812ULL, 0x000fe200078ee21dULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x0000000510147210ULL, 0x000fc40007f1e0ffULL,
0x000000493e0f7212ULL, 0x080fe200078efcffULL, 0x000000803c3c7825ULL, 0x000fe200078e00ffULL,
0x000000491c137212ULL, 0x080fe400078efcffULL, 0x0000000f103e7210ULL, 0x000fe20007f5e0ffULL,
0x0000000111157824ULL, 0x040fe200000e0615ULL, 0x000000493c057212ULL, 0x000fe200078efcffULL,
0x0000001040417824ULL, 0x100fe200078e0207ULL, 0x00000013101c7210ULL, 0x000fe20007f1e0ffULL,
0x000000100a437824ULL, 0x100fe200078e0207ULL, 0x0000000510107210ULL, 0x000fe20007f7e0ffULL,
0x0000001042457824ULL, 0x000fe200078e0207ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014417faeULL, 0x0003e2000b901c48ULL, 0x00000001111d7824ULL, 0x000fc400000e061dULL,
0x00000001113f7824ULL, 0x040fe400010e063fULL, 0x0000001044077824ULL, 0x000fe200078e0207ULL,
0x000000001c437faeULL, 0x0003e2000b901c48ULL, 0x0000000111117824ULL, 0x000fc600018e063dULL,
0x000000003e457faeULL, 0x0003e8000b901c48ULL, 0x0000000010077faeULL, 0x0003e4000b901c48ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x000000074c107c11ULL, 0x000fe2000f8e20ffULL,
0x00000001ff1d7424ULL, 0x000fe200078e00ffULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x0176a81d101079a7ULL, 0x0002a4000850003fULL,
0x0176681d0c1c79a7ULL, 0x0022e4000850003fULL, 0x000000ffff057224ULL, 0x006fce00078e0011ULL,
0x0000000000107805ULL, 0x000fce0000015200ULL, 0x0176681d0c0075a7ULL, 0x008e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff0f7224ULL, 0x000fce00078e00ffULL,
0x000000100f00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x00000014100a7210ULL, 0x000fca0007f1e1ffULL,
0x0000000115147824ULL, 0x000fe200000e0e11ULL, 0x003d09000a00780cULL, 0x000fc80003f06070ULL,
0x000000ff1400720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400a00780cULL, 0x000fc80003f06070ULL, 0x000000ff1400720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff077819ULL, 0x000fc80000011414ULL,
0x0000000a07077211ULL, 0x000fca00078110ffULL, 0x000000ffff0a7224ULL, 0x000fca00000e0614ULL,
0x0000000207077819ULL, 0x000fc8000000120aULL, 0x000000070000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000010f0f7836ULL, 0x000fce0000000000ULL,
0x0176681d0c0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000074b0a7c11ULL, 0x000fe2000f8e38ffULL, 0x00000001ff137424ULL, 0x000fc600078e00ffULL,
0x00000180490a7810ULL, 0x000fca0007ffe00aULL, 0x000000014d0a7824ULL, 0x000fca00078e020aULL,
0x017000000a107984ULL, 0x000e680000000800ULL, 0x017200000a0f7984ULL, 0x0004a20000000800ULL,
0x000000091000720bULL, 0x002fda0003f1d000ULL, 0x0000000000077806ULL, 0x000fc800000e0100ULL,
0x0000ffff07117812ULL, 0x000fe2000780c0ffULL, 0x000000ffff077224ULL, 0x000fd800078e0009ULL,
0x0000000400008947ULL, 0x004fea0003800000ULL, 0x000000034b077836ULL, 0x000fe20000000000ULL,
0x000000091000720bULL, 0x000fc80003f14000ULL, 0x000000000700720cULL, 0x000fd20003f45270ULL,
0x0000000000147806ULL, 0x000fc800000e0100ULL, 0x00000007000aac11ULL, 0x000fe4000f8e38ffULL,
0x000000091007a209ULL, 0x000fe40007810000ULL, 0x0000000a4d1ca210ULL, 0x000fe40007ffe049ULL,
0x00009910140a7816ULL, 0x000fc600000000ffULL, 0x017400071c00a388ULL, 0x0003e20000000800ULL,
0x000000ff0a00720cULL, 0x000fda0003f05270ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x00000009100a7209ULL, 0x000fe40007810000ULL, 0x000000ff14ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0014ff7812ULL, 0x000fe2000784c0ffULL, 0x000000090a077221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b07077820ULL, 0x000fc80000410000ULL, 0x0000000700137308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff0a7819ULL, 0x000fca000001160eULL,
0x00001f0a13077589ULL, 0x006e6400000e0000ULL, 0x0000003807387220ULL, 0x042fe20000410000ULL,
0x0000003907397220ULL, 0x040fe20000410000ULL, 0x0000003407347220ULL, 0x040fe20000410000ULL,
0x0000003507357220ULL, 0x040fe20000410000ULL, 0x0000003007307220ULL, 0x040fe20000410000ULL,
0x0000003107317220ULL, 0x040fe20000410000ULL, 0x0000002c072c7220ULL, 0x040fe20000410000ULL,
0x0000002d072d7220ULL, 0x040fe20000410000ULL, 0x0000002807287220ULL, 0x040fe20000410000ULL,
0x0000002907297220ULL, 0x040fe20000410000ULL, 0x0000002407247220ULL, 0x040fe20000410000ULL,
0x0000002507257220ULL, 0x040fe20000410000ULL, 0x0000002007207220ULL, 0x040fe20000410000ULL,
0x0000002107217220ULL, 0x040fe20000410000ULL, 0x0000001807187220ULL, 0x040fe20000410000ULL,
0x0000001907197220ULL, 0x000fce0000410000ULL, 0x0000001316167220ULL, 0x004fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x000000080e0a7811ULL, 0x000fca00078ff0ffULL,
0x00001f0a13077589ULL, 0x002e6400000e0000ULL, 0x0000003a073a7220ULL, 0x042fe20000410000ULL,
0x0000003b073b7220ULL, 0x040fe20000410000ULL, 0x0000003607367220ULL, 0x040fe20000410000ULL,
0x0000003707377220ULL, 0x040fe20000410000ULL, 0x0000003207327220ULL, 0x040fe20000410000ULL,
0x0000003307337220ULL, 0x040fe20000410000ULL, 0x0000002e072e7220ULL, 0x040fe20000410000ULL,
0x0000002f072f7220ULL, 0x040fe20000410000ULL, 0x0000002a072a7220ULL, 0x040fe20000410000ULL,
0x0000002b072b7220ULL, 0x040fe20000410000ULL, 0x0000002607267220ULL, 0x040fe20000410000ULL,
0x0000002707277220ULL, 0x040fe20000410000ULL, 0x0000002207227220ULL, 0x040fe20000410000ULL,
0x0000002307237220ULL, 0x040fe20000410000ULL, 0x0000001a071a7220ULL, 0x040fe20000410000ULL,
0x0000001b071b7220ULL, 0x000fce0000410000ULL, 0x0000ffff11ff7812ULL, 0x000fe20007806014ULL,
0x00000001ff137424ULL, 0x000fe200078e00ffULL, 0x0000000910077209ULL, 0x002fd60007810000ULL,
0x8000000710100221ULL, 0x000fe20000010000ULL, 0x00007610ff130816ULL, 0x000fc60000000013ULL,
0x3fb8aa3b10100820ULL, 0x000fc80000410000ULL, 0x0000001000080308ULL, 0x000e640000000800ULL,
0x000000080f0f0220ULL, 0x002fce0000410000ULL, 0x000000160f167221ULL, 0x000fe20000010000ULL,
0x000000074c1d7c11ULL, 0x000fce000f8e20ffULL, 0x0000000000107805ULL, 0x000fce0000015200ULL,
0x0176b01f1d0075a7ULL, 0x000e62000800017fULL, 0x0000000400097824ULL, 0x000fca00078e00ffULL,
0x00000004090a7812ULL, 0x000fe200078ec0ffULL, 0x000000044f097824ULL, 0x000fc800078e00ffULL,
0x000000020a0a7836ULL, 0x000fe40000000000ULL, 0x000000ffff0f7224ULL, 0x000fe400078e0009ULL,
0x000000ffff157224ULL, 0x000fe200078e000aULL, 0x0000000000640947ULL, 0x002fec0003800000ULL,
0x000000ffff1c7224ULL, 0x000fce00078e00ffULL, 0x000000101c00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x0000001410147210ULL, 0x000fca0007f1e1ffULL, 0x0000000115157824ULL, 0x000fe200000e0e11ULL,
0x003d09001400780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401400780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff0f7819ULL, 0x000fc80000011415ULL, 0x000000140f0f7211ULL, 0x000fca00078110ffULL,
0x000000ffff147224ULL, 0x000fca00000e0615ULL, 0x000000020f0f7819ULL, 0x000fc80000001214ULL,
0x0000000f0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011c1c7836ULL, 0x000fce0000000000ULL, 0x0176b01f1d0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000ffff0f7224ULL, 0x000fe400078e0009ULL,
0x000000ffff157224ULL, 0x000fce00078e000aULL, 0x000000070e097812ULL, 0x040fe400078ec0ffULL,
0x000000080e0a7812ULL, 0x040fe400078ec0ffULL, 0x0000991013117816ULL, 0x000fe200000000ffULL,
0x000000034b137836ULL, 0x000fe20000000000ULL, 0x0000000809107812ULL, 0x000fe400078ef80eULL,
0x0000000f0e0f7211ULL, 0x000fe400078fe0ffULL, 0x000000090a407212ULL, 0x000fe200078efcffULL,
0x00000008101d7824ULL, 0x000fe200078e00ffULL, 0x000000ff1100720cULL, 0x000fc40003f05270ULL,
0x0000000713117c11ULL, 0x000fe2000f8e58ffULL, 0x0000000140107824ULL, 0x040fe200078e020fULL,
0xfffffff81d3c7812ULL, 0x000fe200078ee206ULL, 0x00000008401f7824ULL, 0x000fe200078e00ffULL,
0x000000150e067211ULL, 0x000fc600078fe0ffULL, 0x000000103c3c7824ULL, 0x000fe200078e0211ULL,
0xfffffff81f107812ULL, 0x000fca00078ee210ULL, 0x0000001010107824ULL, 0x000fe200078e0217ULL,
0x0000000000180947ULL, 0x000fec0003800000ULL, 0x00000002ff047819ULL, 0x000fe4000001160eULL,
0x00000008ff03723eULL, 0x000fc600000000ffULL, 0x0000000804147836ULL, 0x000fe20000000000ULL,
0x0000541003137816ULL, 0x000fca0000000003ULL, 0x00001f0413047589ULL, 0x0002a800000e0000ULL,
0x00001f1413037589ULL, 0x0002e400000e0000ULL, 0x011000003c3c783bULL, 0x000e620000000200ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x000000043c3c7232ULL, 0x086fe40000000000ULL,
0x000000043e3e7232ULL, 0x000fe40000000000ULL, 0x000000033d3d7232ULL, 0x088fe40000000000ULL,
0x000000033f3f7232ULL, 0x000fce0000000000ULL, 0x0000000140137824ULL, 0x042fe200078e0206ULL,
0x00000000101c783bULL, 0x000e620000004200ULL, 0x0000000840147824ULL, 0x000fe400078e00ffULL,
0x0000001002447824ULL, 0x000fc600078e0211ULL, 0xfffffff814147812ULL, 0x000fca00078ee213ULL,
0x0000001014147824ULL, 0x000fca00078e0217ULL, 0x000000001440783bULL, 0x000f620000004200ULL,
0x00000010ff5c7819ULL, 0x102fe4000001161eULL, 0x000000ff1e557812ULL, 0x040fe400078ec0ffULL,
0x00000018ff497819ULL, 0x000fe4000001161eULL, 0x0000ffff1e587812ULL, 0x000fe400078ec0ffULL,
0x00000010ff027819ULL, 0x000fe4000001161cULL, 0x00000010ff5f7819ULL, 0x000fc4000001161dULL,
0x000000ff1d5a7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff577819ULL, 0x000fe4000001161dULL,
0x00000018ff147819ULL, 0x028fe40000011640ULL, 0x00000018ff157819ULL, 0x000fe40000011641ULL,
0x000000ff425e7812ULL, 0x000fe400078ec0ffULL, 0x000000ff43607812ULL, 0x000fc400078ec0ffULL,
0x0000ffff1d5d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5b7819ULL, 0x100fe4000001161fULL,
0x000000ff1f547812ULL, 0x040fe400078ec0ffULL, 0x00000018ff1e7819ULL, 0x000fe4000001161fULL,
0x0000ffff1f117812ULL, 0x000fe400078ec0ffULL, 0x00000010ff107819ULL, 0x000fc40000011640ULL,
0x000000ff40477812ULL, 0x040fe400078ec0ffULL, 0x0000ffff401d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4d7819ULL, 0x000fe40000011641ULL, 0x000000ff41467812ULL, 0x040fe400078ec0ffULL,
0x0000ffff411f7812ULL, 0x000fe400078ec0ffULL, 0x00000014ff40723eULL, 0x000fc400020006ffULL,
0x00000015ff41723eULL, 0x000fe400020006ffULL, 0x0000005eff14723eULL, 0x000fe400020006ffULL,
0x00000060ff15723eULL, 0x000fe400020006ffULL, 0x000000ff1c597812ULL, 0x000fe400078ec0ffULL,
0x000000ff025e7812ULL, 0x000fe400078ec0ffULL, 0x000000ff5f607812ULL, 0x000fc400078ec0ffULL,
0x0000ffff1c627812ULL, 0x000fe400078ec0ffULL, 0x00000018ff617819ULL, 0x000fe40000011642ULL,
0x00000059ff59723eULL, 0x000fe400020006ffULL, 0x0000005aff5a723eULL, 0x000fe400020006ffULL,
0x0000005eff5e723eULL, 0x000fe400020006ffULL, 0x00000060ff60723eULL, 0x000fc400020006ffULL,
0x00000008ff5f7819ULL, 0x000fe40000011662ULL, 0x00000061ff02723eULL, 0x000fe400020006ffULL,
0x00000008ff617819ULL, 0x000fe40000011611ULL, 0x000000ff10627812ULL, 0x000fe400078ec0ffULL,
0x00000018ff567819ULL, 0x000fe4000001161cULL, 0x00000008ff5d7819ULL, 0x000fc4000001165dULL,
0x0000541059107816ULL, 0x000fe4000000005eULL, 0x000054105a117816ULL, 0x000fe40000000060ULL,
0x00000056ff56723eULL, 0x000fe400020006ffULL, 0x00000057ff57723eULL, 0x000fe400020006ffULL,
0x0000005fff5f723eULL, 0x000fe200020006ffULL, 0x000000103c38723cULL, 0x000fe20000001838ULL,
0x0000005dff5d723eULL, 0x000fc400020006ffULL, 0x000000ff5c5c7812ULL, 0x000fe400078ec0ffULL,
0x000000ff5b5b7812ULL, 0x000fe400078ec0ffULL, 0x000054105f107816ULL, 0x000fe40000000056ULL,
0x000054105d117816ULL, 0x000fe40000000057ULL, 0x00000055ff55723eULL, 0x000fe400020006ffULL,
0x00000054ff54723eULL, 0x000fc400020006ffULL, 0x0000005cff5c723eULL, 0x000fe200020006ffULL,
0x000000103c34723cULL, 0x000fe20000001834ULL, 0x0000005bff5b723eULL, 0x000fe400020006ffULL,
0x00000008ff587819ULL, 0x000fe40000011658ULL, 0x00000010ff1c7819ULL, 0x000fe40000011642ULL,
0x0000541055107816ULL, 0x000fe4000000005cULL, 0x0000541054117816ULL, 0x000fc4000000005bULL,
0x00000010ff457819ULL, 0x100fe40000011643ULL, 0x00000018ff137819ULL, 0x000fe40000011643ULL,
0x0000ffff42427812ULL, 0x000fe200078ec0ffULL, 0x000000103c30723cULL, 0x000fe20000001830ULL,
0x0000ffff43437812ULL, 0x000fe400078ec0ffULL, 0x00000049ff49723eULL, 0x000fe400020006ffULL,
0x0000001eff1e723eULL, 0x000fc400020006ffULL, 0x00000058ff58723eULL, 0x000fe400020006ffULL,
0x00000061ff61723eULL, 0x000fe400020006ffULL, 0x000000ff4d4d7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff1d7819ULL, 0x000fe4000001161dULL, 0x00000008ff1f7819ULL, 0x000fe4000001161fULL,
0x000000ff1c1c7812ULL, 0x000fc400078ec0ffULL, 0x0000541058107816ULL, 0x000fe40000000049ULL,
0x0000541061117816ULL, 0x000fe4000000001eULL, 0x000000ff45457812ULL, 0x000fe400078ec0ffULL,
0x00000008ff427819ULL, 0x000fe40000011642ULL, 0x00000008ff437819ULL, 0x000fe20000011643ULL,
0x000000103c2c723cULL, 0x000fe2000000182cULL, 0x0000004dff56723eULL, 0x000fc400020006ffULL,
0x00000047ff47723eULL, 0x000fe400020006ffULL, 0x00000046ff46723eULL, 0x000fe400020006ffULL,
0x00000062ff59723eULL, 0x000fe400020006ffULL, 0x0000001dff4d723eULL, 0x000fe400020006ffULL,
0x0000001fff54723eULL, 0x000fe400020006ffULL, 0x0000001cff49723eULL, 0x000fc400020006ffULL,
0x00000045ff45723eULL, 0x000fe200020006ffULL, 0x01100000441c783bULL, 0x0002e20000000200ULL,
0x00000013ff13723eULL, 0x000fe400020006ffULL, 0x00000042ff42723eULL, 0x000fe400020006ffULL,
0x00000043ff43723eULL, 0x000fe400020006ffULL, 0x0000541047107816ULL, 0x000fe40000000059ULL,
0x0000541046117816ULL, 0x000fc40000000056ULL, 0x000054104d407816ULL, 0x000fe40000000040ULL,
0x0000541054417816ULL, 0x000fe40000000041ULL, 0x0000541014147816ULL, 0x000fe20000000049ULL,
0x000000103c28723cULL, 0x000fe20000001828ULL, 0x0000541015157816ULL, 0x000fe40000000045ULL,
0x0000541042427816ULL, 0x000fe40000000002ULL, 0x0000541043437816ULL, 0x000fe20000000013ULL,
0x000000403c24723cULL, 0x000fec0000001824ULL, 0x000000143c20723cULL, 0x000fec0000001820ULL,
0x000000423c18723cULL, 0x000fe20000001818ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000100947ULL, 0x002fde0003800000ULL, 0x000000041c1c7232ULL, 0x08cfe40000000000ULL,
0x000000041e1e7232ULL, 0x000fe40000000000ULL, 0x000000031d1d7232ULL, 0x080fe40000000000ULL,
0x000000031f1f7232ULL, 0x000fce0000000000ULL, 0x000000100a097812ULL, 0x000fe200078efe09ULL,
0x000000010b0b7836ULL, 0x000fc80000000000ULL, 0x00000001090f7824ULL, 0x040fe400078e020fULL,
0x0000000809027824ULL, 0x040fe400078e00ffULL, 0x0000000109067824ULL, 0x040fe400078e0206ULL,
0x0000000809097824ULL, 0x000fe200078e00ffULL, 0xfffffff802027812ULL, 0x000fc800078ee20fULL,
0xfffffff809067812ULL, 0x000fe200078ee206ULL, 0x0000001002027824ULL, 0x000fc800078e0217ULL,
0x0000001006067824ULL, 0x000fe200078e0217ULL, 0x00000000023c783bULL, 0x000e680000004200ULL,
0x000000000640783bULL, 0x000f620000004200ULL, 0x000000ff3f027812ULL, 0x002fe400078ec0ffULL,
0x00000010ff547819ULL, 0x000fe4000001163dULL, 0x000000ff3d497812ULL, 0x000fc400078ec0ffULL,
0x00000018ff457819ULL, 0x000fe4000001163dULL, 0x0000ffff3d5a7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff067819ULL, 0x028fe40000011642ULL, 0x00000010ff0a7819ULL, 0x000fe4000001163cULL,
0x00000010ff577819ULL, 0x000fe4000001163eULL, 0x000000ff3e447812ULL, 0x000fc400078ec0ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001163eULL, 0x0000ffff3e5b7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff557819ULL, 0x000fe40000011643ULL, 0x00000010ff587819ULL, 0x100fe4000001163fULL,
0x00000018ff3e7819ULL, 0x000fe4000001163fULL, 0x0000ffff3f5c7812ULL, 0x000fc400078ec0ffULL,
0x00000002ff3f723eULL, 0x000fe400020006ffULL, 0x00000006ff02723eULL, 0x000fe400020006ffULL,
0x000000ff3c117812ULL, 0x040fe400078ec0ffULL, 0x0000ffff3c597812ULL, 0x000fe400078ec0ffULL,
0x000000ff0a4d7812ULL, 0x000fe400078ec0ffULL, 0x00000055ff06723eULL, 0x000fc400020006ffULL,
0x000000ff54557812ULL, 0x000fe400078ec0ffULL, 0x00000010ff107819ULL, 0x000fe40000011641ULL,
0x000000ff43567812ULL, 0x000fe400078ec0ffULL, 0x00000011ff11723eULL, 0x000fe400020006ffULL,
0x0000004dff4d723eULL, 0x000fe400020006ffULL, 0x00000008ff547819ULL, 0x000fc40000011659ULL,
0x00000049ff49723eULL, 0x000fe400020006ffULL, 0x00000055ff55723eULL, 0x000fe400020006ffULL,
0x000000ff58597812ULL, 0x000fe400078ec0ffULL, 0x00000008ff587819ULL, 0x000fe4000001165bULL,
0x000000ff105b7812ULL, 0x000fe400078ec0ffULL, 0x00000056ff0a723eULL, 0x000fc400020006ffULL,
0x0000541011107816ULL, 0x000fe4000000004dULL, 0x00000018ff467819ULL, 0x000fe4000001163cULL,
0x00000008ff567819ULL, 0x000fe4000001165aULL, 0x0000541049117816ULL, 0x000fe40000000055ULL,
0x00000010ff477819ULL, 0x000fe40000011640ULL, 0x00000046ff46723eULL, 0x000fc400020006ffULL,
0x00000045ff45723eULL, 0x000fe200020006ffULL, 0x000000101c38723cULL, 0x000fe20000001838ULL,
0x00000054ff54723eULL, 0x000fe400020006ffULL, 0x00000056ff56723eULL, 0x000fe400020006ffULL,
0x00000010ff147819ULL, 0x000fe40000011643ULL, 0x000000ff40157812ULL, 0x000fe400078ec0ffULL,
0x000000ff47477812ULL, 0x000fc400078ec0ffULL, 0x000000ff41177812ULL, 0x000fe400078ec0ffULL,
0x0000003dff3d723eULL, 0x000fe400020006ffULL, 0x00000058ff58723eULL, 0x000fe400020006ffULL,
0x0000541054107816ULL, 0x000fe40000000046ULL, 0x0000541056117816ULL, 0x000fe40000000045ULL,
0x000000ff14147812ULL, 0x000fc400078ec0ffULL, 0x00000015ff15723eULL, 0x000fe400020006ffULL,
0x00000047ff47723eULL, 0x000fe200020006ffULL, 0x000000101c34723cULL, 0x000fe20000001834ULL,
0x00000017ff17723eULL, 0x000fe400020006ffULL, 0x0000005bff5b723eULL, 0x000fe400020006ffULL,
0x0000541058587816ULL, 0x000fe4000000003dULL, 0x00000014ff3d723eULL, 0x000fe200020006ffULL,
0x000000044c107836ULL, 0x000fe20000000000ULL, 0x0000541015147816ULL, 0x000fc40000000047ULL,
0x0000541017157816ULL, 0x000fe4000000005bULL, 0x0000000710107c11ULL, 0x000fe4000f8e18ffULL,
0x00000018ff0f7819ULL, 0x000fe40000011640ULL, 0x00000018ff137819ULL, 0x000fe20000011641ULL,
0x000000141c28723cULL, 0x000fe20000001828ULL, 0x0000ffff40407812ULL, 0x000fe400078ec0ffULL,
0x0000ffff41417812ULL, 0x000fc400078ec0ffULL, 0x00000010ff3c7819ULL, 0x000fe40000011642ULL,
0x00000001ff147424ULL, 0x000fe200078e00ffULL, 0x000000ff42097812ULL, 0x040fe400078ec0ffULL,
0x0000ffff42427812ULL, 0x000fe200078ec0ffULL, 0x0176a814101079a7ULL, 0x000e62000850003fULL,
0x0000ffff43437812ULL, 0x000fe400078ec0ffULL, 0x000000ff57577812ULL, 0x000fe400078ec0ffULL,
0x00000008ff5a7819ULL, 0x000fc4000001165cULL, 0x00000008ff407819ULL, 0x000fe40000011640ULL,
0x00000008ff417819ULL, 0x000fe40000011641ULL, 0x000000ff3c3c7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff427819ULL, 0x000fe40000011642ULL, 0x00000008ff437819ULL, 0x000fe40000011643ULL,
0x00000059ff59723eULL, 0x000fc400020006ffULL, 0x00000044ff44723eULL, 0x000fe400020006ffULL,
0x0000003eff3e723eULL, 0x000fe400020006ffULL, 0x0000000fff0f723eULL, 0x000fe400020006ffULL,
0x00000013ff13723eULL, 0x000fe400020006ffULL, 0x00000009ff09723eULL, 0x000fe400020006ffULL,
0x00000057ff57723eULL, 0x000fc400020006ffULL, 0x0000005aff5a723eULL, 0x000fe400020006ffULL,
0x00000040ff40723eULL, 0x000fe400020006ffULL, 0x00000041ff41723eULL, 0x000fe400020006ffULL,
0x0000003cff3c723eULL, 0x000fe400020006ffULL, 0x00000042ff42723eULL, 0x000fe400020006ffULL,
0x00000043ff43723eULL, 0x000fc400020006ffULL, 0x000054103f457816ULL, 0x000fe40000000059ULL,
0x0000541044447816ULL, 0x000fe40000000057ULL, 0x000054105a597816ULL, 0x000fe4000000003eULL,
0x0000541040407816ULL, 0x000fe4000000000fULL, 0x0000541041417816ULL, 0x000fe20000000013ULL,
0x000000441c30723cULL, 0x000fe20000001830ULL, 0x00005410093c7816ULL, 0x000fc4000000003cULL,
0x000054100a3d7816ULL, 0x000fe4000000003dULL, 0x0000541042427816ULL, 0x000fe20000000002ULL,
0x000000581c2c723cULL, 0x000fe2000000182cULL, 0x0000541043437816ULL, 0x000fe20000000006ULL,
0x000000ffff027224ULL, 0x002fe200078e0011ULL, 0x000000074b0f7c11ULL, 0x000fc6000f8e18ffULL,
0x000000401c24723cULL, 0x000fe20000001824ULL, 0x0176a0140fff79a7ULL, 0x0003ea000850003fULL,
0x0000003c1c20723cULL, 0x000fec0000001820ULL, 0x000000421c1c723cULL, 0x000fe20000001818ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0xffffff7000d49947ULL, 0x002fde000383ffffULL,
0x000000ff7b00720cULL, 0x000fda0003f05270ULL, 0x0000000000d48947ULL, 0x000fea0003800000ULL,
0x0180000016007836ULL, 0x000fe20000000000ULL, 0x000000b000007945ULL, 0x000fe80003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x00000000000c0947ULL, 0x000fea0003800000ULL, 0x0000a79000047802ULL, 0x004fce0000000f00ULL,
0x0000008000007944ULL, 0x012fea0003c00000ULL, 0x0000000000107947ULL, 0x000fea0003800000ULL,
0x0000001600037308ULL, 0x000ee40000001000ULL, 0xbf80000003007423ULL, 0x008fc80000000016ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003007223ULL, 0x000fce0000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009800ff027b82ULL, 0x000f640000000a00ULL,
0x0000000802037981ULL, 0x028ee2000c1e9900ULL, 0x0000000000057919ULL, 0x004ea40000000000ULL,
0x00000002ff077819ULL, 0x006fe40000011605ULL, 0x0000000805057811ULL, 0x000fe200078ff0ffULL,
0x0000000003007220ULL, 0x008fca0000410000ULL, 0x00001f0700047589ULL, 0x000e6800000e0000ULL,
0x00001f0500057589ULL, 0x000ea200000e0000ULL, 0x0000003804387220ULL, 0x042fe20000410000ULL,
0x0000003904397220ULL, 0x040fe20000410000ULL, 0x0000003404347220ULL, 0x040fe20000410000ULL,
0x0000003504357220ULL, 0x040fe20000410000ULL, 0x0000003004307220ULL, 0x040fe20000410000ULL,
0x0000003104317220ULL, 0x040fe20000410000ULL, 0x0000002c042c7220ULL, 0x040fe20000410000ULL,
0x0000002d042d7220ULL, 0x040fe20000410000ULL, 0x0000002804287220ULL, 0x040fe20000410000ULL,
0x0000002904297220ULL, 0x040fe20000410000ULL, 0x0000002404247220ULL, 0x040fe20000410000ULL,
0x0000002504257220ULL, 0x040fe20000410000ULL, 0x0000002004207220ULL, 0x040fe20000410000ULL,
0x0000002104217220ULL, 0x040fe20000410000ULL, 0x0000001c041c7220ULL, 0x040fe20000410000ULL,
0x0000001d041d7220ULL, 0x000fe20000410000ULL, 0x0000003a053a7220ULL, 0x044fe20000410000ULL,
0x0000003b053b7220ULL, 0x040fe20000410000ULL, 0x0000003605367220ULL, 0x040fe20000410000ULL,
0x0000003705377220ULL, 0x040fe20000410000ULL, 0x0000003205327220ULL, 0x040fe20000410000ULL,
0x0000003305337220ULL, 0x040fe20000410000ULL, 0x0000002e052e7220ULL, 0x040fe20000410000ULL,
0x0000002f052f7220ULL, 0x040fe20000410000ULL, 0x0000002a052a7220ULL, 0x040fe20000410000ULL,
0x0000002b052b7220ULL, 0x040fe20000410000ULL, 0x0000002605267220ULL, 0x040fe20000410000ULL,
0x0000002705277220ULL, 0x040fe20000410000ULL, 0x0000002205227220ULL, 0x040fe20000410000ULL,
0x0000002305237220ULL, 0x040fe20000410000ULL, 0x0000001e051e7220ULL, 0x040fe20000410000ULL,
0x0000001f051f7220ULL, 0x000fce0000410000ULL, 0x0000000000007919ULL, 0x000ee20000000000ULL,
0x000000242524723eULL, 0x000fe400000000ffULL, 0x000000202120723eULL, 0x000fe200000000ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000323332723eULL, 0x000fc400000000ffULL,
0x0000002e2f19723eULL, 0x000fe400000000ffULL, 0x0000002a2b2a723eULL, 0x000fe400000000ffULL,
0x0000541032187816ULL, 0x140fe40000000019ULL, 0x0000763232197816ULL, 0x000fe40000000019ULL,
0x000000262715723eULL, 0x000fe400000000ffULL, 0x000000222322723eULL, 0x000fc400000000ffULL,
0x000000ff4c00720cULL, 0x000fe40003f05270ULL, 0x00000002ff057819ULL, 0x00cfe40000011600ULL,
0x0000000200027812ULL, 0x040fe400078ec0ffULL, 0x0000000800077811ULL, 0x002fe200078ff0ffULL,
0x0000000805097824ULL, 0x040fe200078e00ffULL, 0x0000000502047211ULL, 0x040fe200078ff8ffULL,
0x00000008050c7824ULL, 0x000fe200078e00ffULL, 0x0000000702037211ULL, 0x000fe200078ff8ffULL,
0x00000008070e7824ULL, 0x000fc400078e00ffULL, 0x0000000204027836ULL, 0x000fe40000000000ULL,
0x0000000805077824ULL, 0x000fe200078e00ffULL, 0xfffffff80e0e7812ULL, 0x000fe200078ee203ULL,
0x0000000404067836ULL, 0x000fe20000000000ULL, 0x000000074f037c11ULL, 0x000fe4000f8e60ffULL,
0xfffffff809087812ULL, 0x000fe400078ee202ULL, 0xfffffff807027812ULL, 0x000fe200078ee204ULL,
0x0000000604077836ULL, 0x000fe20000000000ULL, 0xfffffff8090a7812ULL, 0x000fe200078ee206ULL,
0x0000000800047824ULL, 0x000fe200078e00ffULL, 0x000076322a097816ULL, 0x000fe20000000015ULL,
0x000008004c057824ULL, 0x000fe200078e0203ULL, 0xfffffff80c0c7812ULL, 0x000fc400078ee207ULL,
0x0000000804077812ULL, 0x000fe200078ec0ffULL, 0x0000001002067824ULL, 0x100fe200078e0205ULL,
0x000000383902723eULL, 0x000fe200000000ffULL, 0x000000100e0e7824ULL, 0x000fe200078e0205ULL,
0x000000343504723eULL, 0x000fe200000000ffULL, 0x0000000106067824ULL, 0x000fe400078e0207ULL,
0x0000001008087824ULL, 0x100fe200078e0205ULL, 0x0000541002107816ULL, 0x100fe20000000004ULL,
0x000000100a0a7824ULL, 0x100fe200078e0205ULL, 0x0000763202117816ULL, 0x000fe20000000004ULL,
0x000000100c0c7824ULL, 0x000fe200078e0205ULL, 0x000000303102723eULL, 0x000fe200000000ffULL,
0x00000001070e7824ULL, 0x000fe200078e020eULL, 0x0000002c2d04723eULL, 0x000fe200000000ffULL,
0x0000001006007388ULL, 0x0003e20000000a00ULL, 0x0000000107087824ULL, 0x000fe200078e0208ULL,
0x000000282905723eULL, 0x000fe200000000ffULL, 0x00000001070a7824ULL, 0x000fc400078e020aULL,
0x00000001070c7824ULL, 0x000fe200078e020cULL, 0x0000763202077816ULL, 0x140fe40000000004ULL,
0x0000541002067816ULL, 0x002fe40000000004ULL, 0x0000001c1d10723eULL, 0x000fe400000000ffULL,
0x0000003a3b02723eULL, 0x000fe200000000ffULL, 0x0000000608007388ULL, 0x0003e20000000a00ULL,
0x000000363704723eULL, 0x000fe400000000ffULL, 0x0000001e1f11723eULL, 0x000fc800000000ffULL,
0x00007632220f7816ULL, 0x000fe40000000011ULL, 0x0000541005067816ULL, 0x142fe40000000024ULL,
0x0000763205077816ULL, 0x000fca0000000024ULL, 0x000000060a007388ULL, 0x0003e40000000a00ULL,
0x0000541020067816ULL, 0x142fe40000000010ULL, 0x0000763220077816ULL, 0x000fca0000000010ULL,
0x000000060c007388ULL, 0x0003e40000000a00ULL, 0x0000541002067816ULL, 0x142fe40000000004ULL,
0x0000763202077816ULL, 0x000fe20000000004ULL, 0x0000000153027824ULL, 0x000fc800078e0200ULL,
0x000000060e007388ULL, 0x0003e20000000a00ULL, 0x0000001002027824ULL, 0x000fc600078e0203ULL,
0x0004001808007388ULL, 0x0005e20000000a00ULL, 0x00005410220e7816ULL, 0x002fe40000000011ULL,
0x000054102a087816ULL, 0x004fca0000000015ULL, 0x000400080a007388ULL, 0x000fe80000000a00ULL,
0x0004000e0c007388ULL, 0x000fe20000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000002047984ULL, 0x000e680000000c00ULL, 0x0004000002147984ULL, 0x000ea80000000c00ULL,
0x0008000002107984ULL, 0x010ee80000000c00ULL, 0x000c000002187984ULL, 0x000f220000000c00ULL,
0x200000ff07077230ULL, 0x002fc40000000000ULL, 0x200000ff06067230ULL, 0x000fe40000000000ULL,
0x200000ff05057230ULL, 0x000fe40000000000ULL, 0x200000ff04047230ULL, 0x000fe40000000000ULL,
0x200000ff17177230ULL, 0x004fe40000000000ULL, 0x200000ff16167230ULL, 0x000fe40000000000ULL,
0x200000ff15157230ULL, 0x000fc40000000000ULL, 0x200000ff14147230ULL, 0x000fe40000000000ULL,
0x0000001307077230ULL, 0x008fe40000000000ULL, 0x0000001206067230ULL, 0x000fe40000000000ULL,
0x0000001105057230ULL, 0x000fe40000000000ULL, 0x0000001004047230ULL, 0x000fe40000000000ULL,
0x0000001b17177230ULL, 0x010fc40000000000ULL, 0x0000001a16167230ULL, 0x000fe20000000000ULL,
0x0000000402007388ULL, 0x0003e20000000c00ULL, 0x0000001915157230ULL, 0x000fe40000000000ULL,
0x0000001814147230ULL, 0x000fca0000000000ULL, 0x0004001402007388ULL, 0x0003e20000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000000000479c3ULL, 0x000ea20000002700ULL, 0x00000003ff077819ULL, 0x002fe20000011600ULL,
0x0000840000057ab9ULL, 0x000fc60000000800ULL, 0x000000500700720cULL, 0x000fe20003f06070ULL,
0x00000005040472a4ULL, 0x004fd8000f8e023fULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00008600ff107b82ULL, 0x000e620000000800ULL, 0x0000000107027824ULL, 0x000fe200078e0200ULL,
0x0000880000067ab9ULL, 0x000fe20000000a00ULL, 0x00000007000e7812ULL, 0x000fc600078ec0ffULL,
0x0000000702057812ULL, 0x000fc800078ec0ffULL, 0x0ffffff805027812ULL, 0x000fe200078ef800ULL,
0xffffffffff057424ULL, 0x000fc800078e00ffULL, 0x0000001002047824ULL, 0x000fe400078e0203ULL,
0x0000001052027824ULL, 0x000fe400078e0207ULL, 0x000000084f077824ULL, 0x000fe200078e020eULL,
0x0000000004087984ULL, 0x0004e20000000c00ULL, 0x0000001005127219ULL, 0x082fe400000006ffULL,
0x000000104e4e7219ULL, 0x000fe400000006ffULL, 0x0000001202057212ULL, 0x000fc400078e30ffULL,
0x00000010ff067219ULL, 0x000fe20000011602ULL, 0x0000000451027c24ULL, 0x000fe4000f8e02ffULL,
0x000000014e057824ULL, 0x000fc800078e0205ULL, 0x0000005106057224ULL, 0x000fe400078e0205ULL,
0x0000002000067836ULL, 0x000fc60000000000ULL, 0x0000000502057210ULL, 0x000fe40007f1e0ffULL,
0x00000003ff0d7819ULL, 0x000fc60000011606ULL, 0x000000ffff0c7224ULL, 0x000fe200000e06ffULL,
0x0000000605047c11ULL, 0x004fc8000f8040ffULL, 0x0000000705057c11ULL, 0x000fe400080f440cULL,
0x000000500d00720cULL, 0x000fe20003f06070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0083ee000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000106047824ULL, 0x102fe400078e020dULL, 0x00000010520d7824ULL, 0x000fe400078e020dULL,
0x00000040000c7836ULL, 0x000fe20000000000ULL, 0x0000000704057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805047812ULL, 0x000fe400078ef806ULL, 0x000000120d057212ULL, 0x000fe400078e30ffULL,
0x0000000706067812ULL, 0x000fe200078ec0ffULL, 0x0000001004077824ULL, 0x000fe200078e0203ULL,
0x00000010ff047219ULL, 0x000fe2000001160dULL, 0x000000014e057824ULL, 0x000fe200078e0205ULL,
0x00000003ff0d7819ULL, 0x000fe4000001160cULL, 0x0000000007087984ULL, 0x0002a20000000c00ULL,
0x0000005104057224ULL, 0x000fca00078e0205ULL, 0x0000000502057210ULL, 0x000fe20007f1e0ffULL,
0x000000084f077824ULL, 0x002fc800078e0206ULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x0000000605047c11ULL, 0x000fc8000f8040ffULL, 0x0000000705057c11ULL, 0x000fe400080f440eULL,
0x000000500d00720cULL, 0x000fe20003f06070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0043ee000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010c047824ULL, 0x102fe400078e020dULL, 0x00000010520d7824ULL, 0x000fe400078e020dULL,
0x0000006000007836ULL, 0x000fe20000000000ULL, 0x0000000704057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805047812ULL, 0x000fe400078ef80cULL, 0x000000120d057212ULL, 0x000fe400078e30ffULL,
0x000000070c0c7812ULL, 0x000fe200078ec0ffULL, 0x0000001004067824ULL, 0x000fe200078e0203ULL,
0x00000010ff047219ULL, 0x000fe2000001160dULL, 0x000000014e057824ULL, 0x000fe200078e0205ULL,
0x00000003ff0d7819ULL, 0x000fe20000011600ULL, 0x000000084f077824ULL, 0x000fe200078e020cULL,
0x0000000006087984ULL, 0x0002a20000000c00ULL, 0x0000005104057224ULL, 0x000fca00078e0205ULL,
0x0000000502057210ULL, 0x000fe20007f1e0ffULL, 0x0000000100067824ULL, 0x002fc800078e020dULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x0000000605047c11ULL, 0x000fc8000f8040ffULL,
0x0000000705057c11ULL, 0x000fe400080f440eULL, 0x000000500d00720cULL, 0x000fe20003f06070ULL,
0x0000001007047825ULL, 0x000fe200078e0004ULL, 0x0000000706077812ULL, 0x000fc800078ec0ffULL,
0xfffffff807067812ULL, 0x000fe200078ef800ULL, 0x0000000804007986ULL, 0x0043ec000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000001006067824ULL, 0x000fe200078e0203ULL,
0x0000000700007812ULL, 0x000fe200078ec0ffULL, 0x00000010520d7824ULL, 0x000fc800078e020dULL,
0x0000000006047984ULL, 0x002e620000000c00ULL, 0x000000120d037212ULL, 0x000fe200078e30ffULL,
0x000000084f4f7824ULL, 0x000fe200078e0200ULL, 0x00000010ff087219ULL, 0x000fc6000001160dULL,
0x000000014e037824ULL, 0x000fc800078e0203ULL, 0x0000005108037224ULL, 0x000fca00078e0203ULL,
0x0000000302037210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x0000000603027c11ULL, 0x000fc8000f8040ffULL, 0x0000000703037c11ULL, 0x000fc600080f4408ULL,
0x000000104f027825ULL, 0x000fca00078e0002ULL, 0x0000000402007986ULL, 0x002fe2000c101d08ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff6a7819ULL, 0x000fe20000011600ULL,
0x00009800ff107b82ULL, 0x000e620000000a00ULL, 0xffffffffff097424ULL, 0x000fe400078e00ffULL,
0x0000007d6a00720cULL, 0x000fca0003f06070ULL, 0x00008e00ff0a7b82ULL, 0x000eb00000000a00ULL,
0x00009400ff048b82ULL, 0x000ee20000000800ULL, 0x0000000203058824ULL, 0x000fce00078e00ffULL,
0x00009000ff0c8b82ULL, 0x000f620000000a00ULL, 0x0000000810087981ULL, 0x002322000c1e9900ULL,
0x0000000405058224ULL, 0x008fe400078e026aULL, 0x00000001ff047424ULL, 0x000fe400078e00ffULL,
0x00000004050c8825ULL, 0x020fc800078e000cULL, 0x01760004ff0479a7ULL, 0x000e620008500007ULL,
0x000000080c098981ULL, 0x000ee2000c1e1900ULL, 0x0000008007077824ULL, 0x000fe400078e00ffULL,
0x000000804e0f7824ULL, 0x000fc600078e00ffULL, 0x0000040701007387ULL, 0x0007e80000100800ULL,
0x0000000f01007387ULL, 0x0003e20000100800ULL, 0x000001ff0600780cULL, 0x000fe20003f04070ULL,
0x0000000907077224ULL, 0x008fe400078e02ffULL, 0x0000004000097824ULL, 0x000fe400078e00ffULL,
0x0000008007067825ULL, 0x004fc600078e000aULL, 0x000000400f0b7812ULL, 0x000fca00078ef809ULL,
0x0000000c00200947ULL, 0x002fea0003800000ULL, 0x00000003ff217819ULL, 0x000fe4000001160eULL,
0x000000097a0a7248ULL, 0x000fc60007fe0000ULL, 0x0000000421117836ULL, 0x000fe40000000000ULL,
0x000000010b0c7824ULL, 0x000fe400078e0221ULL, 0x00000001110d7824ULL, 0x040fe400078e020eULL,
0x0000000811207824ULL, 0x000fe400078e00ffULL, 0x000000010a0a7824ULL, 0x000fe400078e0a09ULL,
0x000000010b107824ULL, 0x000fe200078e0211ULL, 0xfffffff820207812ULL, 0x000fe200078ee20dULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x0000000a1100720cULL, 0x000fc60003fa6070ULL,
0x0000001021137836ULL, 0x000fe20000000000ULL, 0x000000700c1d7812ULL, 0x000fe200078ef802ULL,
0x0000008010107825ULL, 0x000fc600078e00ffULL, 0x0000001d061c7210ULL, 0x000fe20007f1e0ffULL,
0x00000001130c7824ULL, 0x140fe200078e020eULL, 0x0000007010157812ULL, 0x000fe200078ef802ULL,
0x00000008131b7824ULL, 0x000fe400078e00ffULL, 0x0000000821177836ULL, 0x000fe20000000000ULL,
0x0000001506147210ULL, 0x000fe20007f3e0ffULL, 0x0000000c21197836ULL, 0x000fe20000000000ULL,
0xfffffff81b287812ULL, 0x000fe200078ee20cULL, 0x000000010b0c7824ULL, 0x040fe400078e0217ULL,
0x000000010b107824ULL, 0x000fe200078e0219ULL, 0x0000000a1900720cULL, 0x000fe20003f46070ULL,
0x00000001170f7824ULL, 0x000fc400078e020eULL, 0x0000000817247824ULL, 0x000fe400078e00ffULL,
0x00000001071d7824ULL, 0x000fe200000e060dULL, 0x0000000a1300720cULL, 0x000fe20003f06070ULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0xfffffff824247812ULL, 0x000fc600078ee20fULL,
0x0000000107157824ULL, 0x000fe200008e0611ULL, 0x000000700c1b7812ULL, 0x000fe200078ef802ULL,
0x000000010b137824ULL, 0x000fe200078e0213ULL, 0x0000000a1700720cULL, 0x000fe20003f26070ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000001b061a7210ULL, 0x000fc60007f7e0ffULL,
0x0000001421237836ULL, 0x000fe40000000000ULL, 0x00000001190f7824ULL, 0x040fe400078e020eULL,
0x0000000819267824ULL, 0x000fe200078e00ffULL, 0x0000007010197812ULL, 0x000fe200078ef802ULL,
0x0000008013127825ULL, 0x000fc600078e00ffULL, 0xfffffff826267812ULL, 0x000fe200078ee20fULL,
0x000000010b167824ULL, 0x000fe200078e0223ULL, 0x00000070120f7812ULL, 0x000fe200078ef802ULL,
0x0000001821277836ULL, 0x000fe20000000000ULL, 0x0000001906187210ULL, 0x000fe20007f9e0ffULL,
0x0000008016167825ULL, 0x000fc800078e00ffULL, 0x000000010b1e7824ULL, 0x000fe400078e0227ULL,
0x00000001071b7824ULL, 0x040fe200018e060dULL, 0x0000000f06127210ULL, 0x000fe20007f7e0ffULL,
0x0000000107197824ULL, 0x000fe200020e0611ULL, 0x0000007016117812ULL, 0x000fe200078ef802ULL,
0x000000801e1e7825ULL, 0x000fe200078e00ffULL, 0x00000007000f7c11ULL, 0x000fc6000f8e70ffULL,
0x0000001c212b7836ULL, 0x000fe20000000000ULL, 0x000000701e0d7812ULL, 0x000fe200078ef802ULL,
0x0000000107137824ULL, 0x000fe200018e0613ULL, 0x0000001106107210ULL, 0x000fe20007f7e0ffULL,
0x000000010b167824ULL, 0x000fe200078e022bULL, 0x0000000d060c7210ULL, 0x000fe20007f9e0ffULL,
0x00000001211e7824ULL, 0x000fe400078e020eULL, 0x0000000107117824ULL, 0x000fe200018e0617ULL,
0x0000000a2300720cULL, 0x000fe20003f66070ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x000000071e257812ULL, 0x000fc600078ec0ffULL, 0x00000001070d7824ULL, 0x000fe200020e061fULL,
0x00000070161f7812ULL, 0x000fe200078ef802ULL, 0x00000020212d7836ULL, 0x000fe20000000000ULL,
0x0000000a2100720cULL, 0x000fe20003f86070ULL, 0x00000001231e7824ULL, 0x040fe200078e020eULL,
0x0000001f06167210ULL, 0x000fe20007fde0ffULL, 0x0000000823237824ULL, 0x000fe200078e00ffULL,
0x0ffffff825227812ULL, 0x000fe200078ef80eULL, 0x000000010b1f7824ULL, 0x000fe400078e022dULL,
0x000010000f0f7836ULL, 0x000fe20000000000ULL, 0xfffffff8232a7812ULL, 0x000fe200078ee21eULL,
0x000000801f1e7825ULL, 0x000fc800078e00ffULL, 0x00000024212f7836ULL, 0x000fe20000000000ULL,
0x000000701e237812ULL, 0x000fe200078ef802ULL, 0x0000001022257824ULL, 0x000fe400078e020fULL,
0x0000002821317836ULL, 0x000fe40000000000ULL, 0x000000010b227824ULL, 0x000fe200078e022fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c257faeULL, 0x0003e2000e101c48ULL,
0x0000000107177824ULL, 0x000fe200030e0617ULL, 0x0000000a2700720cULL, 0x040fe20003f86070ULL,
0x0000000127297824ULL, 0x040fe200078e020eULL, 0x00000023061e7210ULL, 0x000fe20007fde0ffULL,
0x00000008272c7824ULL, 0x000fc400078e00ffULL, 0x000000010b277824ULL, 0x000fe400078e0231ULL,
0x0000008022227825ULL, 0x000fe200078e00ffULL, 0xfffffff82c2c7812ULL, 0x000fc600078ee229ULL,
0x00000080271c7825ULL, 0x002fe200078e00ffULL, 0x0000007022277812ULL, 0x000fc600078ef802ULL,
0x00000001071f7824ULL, 0x040fe200030e061fULL, 0x0000002706227210ULL, 0x000fe20007fde0ffULL,
0x0000001020257824ULL, 0x000fe200078e020fULL, 0x000000701c277812ULL, 0x000fe200078ef802ULL,
0x0000002c21337836ULL, 0x000fe40000000000ULL, 0x0000000107237824ULL, 0x000fe200030e0623ULL,
0x00000027061c7210ULL, 0x000fe20007fde0ffULL, 0x0000001024277824ULL, 0x000fe200078e020fULL,
0x0000000014257faeULL, 0x0003e2000e901c48ULL, 0x000000012d247824ULL, 0x100fe200078e020eULL,
0x0000000a2b00720cULL, 0x0c0fe20003fa6070ULL, 0x000000012b207824ULL, 0x000fe200078e020eULL,
0x000000001a277faeULL, 0x0005e2000c901c48ULL, 0x0000000a2d00720cULL, 0x040fe20003f26070ULL,
0x000000082d2d7824ULL, 0x000fc400078e00ffULL, 0x000000082b2b7824ULL, 0x000fe400078e00ffULL,
0x00000001071d7824ULL, 0x000fe200030e061dULL, 0xfffffff82d247812ULL, 0x000fe200078ee224ULL,
0x0000001026257824ULL, 0x002fe200078e020fULL, 0xfffffff82b207812ULL, 0x000fe200078ee220ULL,
0x000000010b147824ULL, 0x000fe400078e0233ULL, 0x00000010281b7824ULL, 0x104fe200078e020fULL,
0x0000000018257faeULL, 0x0003e2000d101c48ULL, 0x00000030212d7836ULL, 0x000fe20000000000ULL,
0x0000000a2f00720cULL, 0x040fe20003f46070ULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x00000000121b7faeULL, 0x0005e6000c101c48ULL, 0x0000001020277824ULL, 0x000fe200078e020fULL,
0x0000007014297812ULL, 0x000fe200078ef802ULL, 0x000000012f267824ULL, 0x000fc400078e020eULL,
0x000000082f2f7824ULL, 0x000fe200078e00ffULL, 0x0000002906147210ULL, 0x000fe20007fde0ffULL,
0x000000102a197824ULL, 0x102fe400078e020fULL, 0x000000102c257824ULL, 0x000fe200078e020fULL,
0xfffffff82f267812ULL, 0x000fe200078ee226ULL, 0x000000010b127824ULL, 0x004fe200078e022dULL,
0x0000000010197faeULL, 0x0003e2000d901c48ULL, 0x00000034211b7836ULL, 0x000fe20000000000ULL,
0x0000000a2d00720cULL, 0x080fe20003f66070ULL, 0x0000000107157824ULL, 0x000fe200030e0615ULL,
0x000000000c257faeULL, 0x0005e2000e101c48ULL, 0x0000000131137824ULL, 0x000fe200078e020eULL,
0x0000000a3300720cULL, 0x080fe20003f86070ULL, 0x0000001024297824ULL, 0x100fe200078e020fULL,
0x0000000016277faeULL, 0x0007e2000e901c48ULL, 0x00000010262b7824ULL, 0x000fe200078e020fULL,
0x0000000a3100720cULL, 0x000fe20003fa6070ULL, 0x000000010b107824ULL, 0x002fe200078e021bULL,
0x000000001e297faeULL, 0x0003e2000c901c48ULL, 0x0000003821197836ULL, 0x000fc40000000000ULL,
0x00000080120c7825ULL, 0x004fe200078e00ffULL, 0x00000000222b7faeULL, 0x0005e2000d101c48ULL,
0x0000000a1b00720cULL, 0x080fe40003f46070ULL, 0x0000000831167824ULL, 0x008fe200078e00ffULL,
0x000000700c117812ULL, 0x000fe200078ef802ULL, 0x0000003c21217836ULL, 0x000fe20000000000ULL,
0x0000000a1900720cULL, 0x000fe20003f26070ULL, 0x000000012d0c7824ULL, 0x000fe200078e020eULL,
0x0000001106127210ULL, 0x000fe20007fde0ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0xfffffff816167812ULL, 0x000fc400078ee213ULL, 0x0000000a2100720cULL, 0x000fe20003f06070ULL,
0x0000000107137824ULL, 0x000fe200030e060dULL, 0x00000070100d7812ULL, 0x000fe200078ef802ULL,
0x000000082d2d7824ULL, 0x000fe400078e00ffULL, 0x00000001330a7824ULL, 0x000fe200078e020eULL,
0x0000000d06107210ULL, 0x000fe20007fde0ffULL, 0x000000010b0d7824ULL, 0x000fe200078e0219ULL,
0xfffffff82d1a7812ULL, 0x000fe200078ee20cULL, 0x0000000833337824ULL, 0x000fe400078e00ffULL,
0x000000800d0c7825ULL, 0x000fc600078e00ffULL, 0xfffffff833187812ULL, 0x000fe200078ee20aULL,
0x000000010b0b7824ULL, 0x000fe200078e0221ULL, 0x000000700c1f7812ULL, 0x002fe200078ef802ULL,
0x0000000107117824ULL, 0x000fe400030e0611ULL, 0x000000800b0a7825ULL, 0x000fe200078e00ffULL,
0x0000001f060c7210ULL, 0x000fc60007fde0ffULL, 0x000000011b177824ULL, 0x140fe200078e020eULL,
0x000000700a1f7812ULL, 0x000fe200078ef802ULL, 0x000000081b1e7824ULL, 0x000fe400078e00ffULL,
0x00000001191b7824ULL, 0x140fe400078e020eULL, 0x0000000819207824ULL, 0x000fe400078e00ffULL,
0x0000000121197824ULL, 0x040fe200078e020eULL, 0xfffffff81e0e7812ULL, 0x000fe200078ee217ULL,
0x0000000821227824ULL, 0x004fe200078e00ffULL, 0xfffffff8201e7812ULL, 0x000fe200078ee21bULL,
0x00000001070d7824ULL, 0x000fe200030e060dULL, 0x0000001f06067210ULL, 0x000fe20007fde0ffULL,
0x0000001016177824ULL, 0x100fe200078e020fULL, 0xfffffff822207812ULL, 0x000fe200078ee219ULL,
0x0000001018197824ULL, 0x000fc400078e020fULL, 0x000000101a1b7824ULL, 0x100fe200078e020fULL,
0x000000001c177faeULL, 0x0003e2000e901c48ULL, 0x000000100e1f7824ULL, 0x100fe400078e020fULL,
0x000000101e217824ULL, 0x100fe200078e020fULL, 0x0000000014197faeULL, 0x0003e2000e101c48ULL,
0x00000010200f7824ULL, 0x000fe400078e020fULL, 0x0000000107077824ULL, 0x000fe200030e060bULL,
0x00000000121b7faeULL, 0x0003e8000d901c48ULL, 0x00000000101f7faeULL, 0x0003e8000d101c48ULL,
0x000000000c217faeULL, 0x0003e8000c901c48ULL, 0x00000000060f7faeULL, 0x0003e2000c101c48ULL,
0x0000000800d07947ULL, 0x000fea0003800000ULL, 0x0000000c0e117811ULL, 0x040fe400078fe8ffULL,
0x000000080e107811ULL, 0x040fe400078fe8ffULL, 0x0000001c0e177811ULL, 0x040fe200078fe8ffULL,
0x00000001110d7824ULL, 0x140fe200078e020eULL, 0x000000040e0f7811ULL, 0x040fe200078fe8ffULL,
0x0000000811147824ULL, 0x000fe200078e00ffULL, 0x000000100e127811ULL, 0x000fe200078fe8ffULL,
0x00000001100c7824ULL, 0x100fe200078e020eULL, 0x000000180e157811ULL, 0x000fe200078fe8ffULL,
0x00000008101d7824ULL, 0x000fe200078e00ffULL, 0xfffffff814217812ULL, 0x000fe200078ee20dULL,
0x00000001170d7824ULL, 0x140fe200078e020eULL, 0x000000140e147811ULL, 0x040fe200078fe8ffULL,
0x00000008171a7824ULL, 0x000fe200078e00ffULL, 0x000000200e187811ULL, 0x000fe200078fe8ffULL,
0x000000010f0a7824ULL, 0x140fe200078e020eULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee20cULL,
0x000000080f1b7824ULL, 0x000fe200078e00ffULL, 0xfffffff81a2b7812ULL, 0x000fe200078ee20dULL,
0x0000000112137824ULL, 0x100fe200078e020eULL, 0x000000280e1a7811ULL, 0x000fe200078fe8ffULL,
0x0000000812167824ULL, 0x000fe200078e00ffULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee20aULL,
0x00000001150c7824ULL, 0x140fe200078e020eULL, 0x000000240e197811ULL, 0x000fe200078fe8ffULL,
0x0000000815297824ULL, 0x000fe200078e00ffULL, 0xfffffff816137812ULL, 0x000fe200078ee213ULL,
0x00000001140a7824ULL, 0x100fe200078e020eULL, 0x000000300e207811ULL, 0x000fe200078fe8ffULL,
0x0000000814277824ULL, 0x000fe200078e00ffULL, 0xfffffff829297812ULL, 0x000fe200078ee20cULL,
0x0000000118167824ULL, 0x100fe200078e020eULL, 0x0000002c0e1c7811ULL, 0x000fe200078fe8ffULL,
0x00000008182d7824ULL, 0x000fe200078e00ffULL, 0xfffffff827277812ULL, 0x000fe200078ee20aULL,
0x000000011a0c7824ULL, 0x000fc400078e020eULL, 0x000000081a237824ULL, 0x000fe200078e00ffULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee216ULL, 0x00000001190a7824ULL, 0x140fe400078e020eULL,
0x00000008191f7824ULL, 0x000fe200078e00ffULL, 0xfffffff823267812ULL, 0x000fe200078ee20cULL,
0x0000000120167824ULL, 0x100fe200078e020eULL, 0x0000000e0e0c7211ULL, 0x000fe200078fe8ffULL,
0x0000000820257824ULL, 0x000fe200078e00ffULL, 0xfffffff81f227812ULL, 0x000fe200078ee20aULL,
0x000000011c0d7824ULL, 0x000fe200078e020eULL, 0x000000340e1f7811ULL, 0x000fe200078fe8ffULL,
0x000000081c287824ULL, 0x000fe200078e00ffULL, 0xfffffff8252a7812ULL, 0x000fe200078ee216ULL,
0x000000010b347824ULL, 0x040fe200078e021cULL, 0x000000380e237811ULL, 0x040fe200078fe8ffULL,
0x000000010b167824ULL, 0x040fe200078e0215ULL, 0xfffffff828287812ULL, 0x000fe200078ee20dULL,
0x000000010b247824ULL, 0x040fe200078e0218ULL, 0x0000003c0e257811ULL, 0x040fe200078fe8ffULL,
0x000000010b307824ULL, 0x040fe200078e0219ULL, 0x0000000b0e0a7211ULL, 0x000fe200078fe8ffULL,
0x000000010b327824ULL, 0x040fe200078e021aULL, 0x000000070c0d7812ULL, 0x000fe200078ec0ffULL,
0x000000010b0c7824ULL, 0x000fc400078e020fULL, 0x000000010b0f7824ULL, 0x040fe200078e0210ULL,
0x0ffffff80d197812ULL, 0x000fe200078ef80eULL, 0x000000010b1c7824ULL, 0x000fe200078e021fULL,
0x00000007000d7c11ULL, 0x000fe2000f8e70ffULL, 0x000000011f107824ULL, 0x000fe400078e020eULL,
0x000000010b117824ULL, 0x040fe400078e0211ULL, 0x000000010b127824ULL, 0x040fe400078e0212ULL,
0x000000010b147824ULL, 0x000fc400078e0214ULL, 0x000000010b1e7824ULL, 0x040fe400078e0217ULL,
0x000000010b207824ULL, 0x000fe400078e0220ULL, 0x000000081f1f7824ULL, 0x000fe400078e00ffULL,
0x000000010b1a7824ULL, 0x000fe400078e0223ULL, 0x0000000123157824ULL, 0x000fe200078e020eULL,
0xfffffff81f107812ULL, 0x000fe200078ee210ULL, 0x000000010b187824ULL, 0x000fc400078e0225ULL,
0x00000008232c7824ULL, 0x000fe400078e00ffULL, 0x00000001250e7824ULL, 0x040fe400078e020eULL,
0x0000000825177824ULL, 0x000fe200078e00ffULL, 0xfffffff82c157812ULL, 0x000fe200078ee215ULL,
0x000000800a0a7825ULL, 0x000fc600078e00ffULL, 0xfffffff817177812ULL, 0x000fe200078ee20eULL,
0x000010000d367836ULL, 0x000fe20000000000ULL, 0x000000700a1f7812ULL, 0x000fe200078ef802ULL,
0x000000800f0e7825ULL, 0x000fc600078e00ffULL, 0x0000001f060a7210ULL, 0x000fe20007f1e0ffULL,
0x00000010152e7824ULL, 0x100fe200078e0236ULL, 0x000000700e157812ULL, 0x000fe200078ef802ULL,
0x00000010102c7824ULL, 0x000fe400078e0236ULL, 0x0000008011107825ULL, 0x000fc800078e00ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x00000070101f7812ULL, 0x000fc600078ef802ULL,
0x00000001070b7824ULL, 0x000fe200000e060bULL, 0x00000015060e7210ULL, 0x000fe20007f1e0ffULL,
0x00000010172f7824ULL, 0x100fe400078e0236ULL, 0x0000001013237824ULL, 0x000fe200078e0236ULL,
0x000000700c137812ULL, 0x000fe200078ef802ULL, 0x0000008016167825ULL, 0x000fc600078e00ffULL,
0x00000013060c7210ULL, 0x000fe20007f3e0ffULL, 0x00000001070f7824ULL, 0x000fe200000e060fULL,
0x0000001f06107210ULL, 0x000fe20007f1e0ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x00000070161f7812ULL, 0x000fc600078ef802ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000007014257812ULL, 0x000fe400078ef802ULL, 0x0000001f06167210ULL, 0x000fe20007f5e0ffULL,
0x000000801e1e7825ULL, 0x000fe200078e00ffULL, 0x0000007012317812ULL, 0x000fc600078ef802ULL,
0x0000000107117824ULL, 0x040fe200000e0611ULL, 0x0000002506147210ULL, 0x000fe20007f1e0ffULL,
0x00000001070d7824ULL, 0x000fe200008e060dULL, 0x0000003106127210ULL, 0x000fe20007f3e0ffULL,
0x0000008030307825ULL, 0x000fe200078e00ffULL, 0x000000701e397812ULL, 0x000fc600078ef802ULL,
0x0000008032327825ULL, 0x000fe200078e00ffULL, 0x00000070303b7812ULL, 0x000fc600078ef802ULL,
0x0000000107157824ULL, 0x000fe200000e0615ULL, 0x00000039061e7210ULL, 0x000fe20007f1e0ffULL,
0x0000008024247825ULL, 0x000fe200078e00ffULL, 0x00000070323d7812ULL, 0x000fc600078ef802ULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000007024377812ULL, 0x000fc600078ef802ULL,
0x00000001071f7824ULL, 0x040fe200000e061fULL, 0x0000003b063a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000107177824ULL, 0x040fe200010e0617ULL, 0x0000003d063c7210ULL, 0x000fe20007f5e0ffULL,
0x0000000107137824ULL, 0x040fe200008e0613ULL, 0x0000003706247210ULL, 0x000fe20007f3e0ffULL,
0x00000001073b7824ULL, 0x040fe200000e0631ULL, 0x0000007034377812ULL, 0x000fe200078ef802ULL,
0x00000001073d7824ULL, 0x000fe400010e0633ULL, 0x0000008020307825ULL, 0x000fe200078e00ffULL,
0x0000003706347210ULL, 0x000fc60007f1e0ffULL, 0x0000001019197824ULL, 0x100fe200078e0236ULL,
0x0000007030457812ULL, 0x000fe200078ef802ULL, 0x000000101b1b7824ULL, 0x100fe400078e0236ULL,
0x000000101d1d7824ULL, 0x100fe200078e0236ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a197faeULL, 0x0003e2000b901c48ULL, 0x0000001021217824ULL, 0x100fe400078e0236ULL,
0x0000001027277824ULL, 0x100fe200078e0236ULL, 0x000000000c1b7faeULL, 0x0003e2000b901c48ULL,
0x0000001029297824ULL, 0x000fc400078e0236ULL, 0x000000102b2b7824ULL, 0x100fe200078e0236ULL,
0x000000000e1d7faeULL, 0x0003e2000b901c48ULL, 0x000000102d2d7824ULL, 0x100fe400078e0236ULL,
0x0000001022227824ULL, 0x100fe200078e0236ULL, 0x0000000010217faeULL, 0x0003e2000b901c48ULL,
0x0000001026267824ULL, 0x100fe400078e0236ULL, 0x0000001028287824ULL, 0x100fe200078e0236ULL,
0x0000000012237faeULL, 0x0003e2000b901c48ULL, 0x000000102a2a7824ULL, 0x000fc400078e0236ULL,
0x000000801c327825ULL, 0x000fe200078e00ffULL, 0x0000000014277faeULL, 0x0003e6000b901c48ULL,
0x000000801a367825ULL, 0x000fe200078e00ffULL, 0x0000007032437812ULL, 0x000fe200078ef802ULL,
0x0000000016297faeULL, 0x0003e4000b901c48ULL, 0x0000008018387825ULL, 0x000fe200078e00ffULL,
0x0000007036417812ULL, 0x000fe200078ef802ULL, 0x000000001e2b7faeULL, 0x0003e4000b901c48ULL,
0x0000000107357824ULL, 0x040fe200000e0635ULL, 0x00000070383f7812ULL, 0x000fe200078ef802ULL,
0x0000000107257824ULL, 0x000fe200008e0625ULL, 0x0000004506307210ULL, 0x000fc40007f1e0ffULL,
0x0000004306327210ULL, 0x000fe40007f3e0ffULL, 0x0000004106367210ULL, 0x000fe20007f5e0ffULL,
0x0000000107317824ULL, 0x040fe200000e0631ULL, 0x0000003f06067210ULL, 0x000fe20007f7e0ffULL,
0x0000000107337824ULL, 0x040fe200008e0633ULL, 0x00000000242d7faeULL, 0x0003e2000b901c48ULL,
0x0000000107377824ULL, 0x040fe400010e0637ULL, 0x0000000107077824ULL, 0x000fe200018e0639ULL,
0x000000003a227faeULL, 0x0003e8000b901c48ULL, 0x000000003c267faeULL, 0x0003e8000b901c48ULL,
0x0000000034287faeULL, 0x0003e8000b901c48ULL, 0x00000000302a7faeULL, 0x0003e8000b901c48ULL,
0x00000000322c7faeULL, 0x0003e8000b901c48ULL, 0x00000000362e7faeULL, 0x0003e8000b901c48ULL,
0x00000000062f7faeULL, 0x0003e4000b901c48ULL, 0x000000026a6a7836ULL, 0x000fe20000000000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffffff707424ULL, 0x000fc600078e00ffULL,
0x0000007d6a00720cULL, 0x000fda0003f06070ULL, 0x00009400ff028b82ULL, 0x000ea20000000800ULL,
0x00000002030b8824ULL, 0x002fce00078e00ffULL, 0x00009000ff068b82ULL, 0x000e620000000a00ULL,
0x000000020b0b8224ULL, 0x004fc800078e026aULL, 0x000000040b068825ULL, 0x002fca00078e0006ULL,
0x0000000806708981ULL, 0x000324000c1e1900ULL, 0x0000000000067805ULL, 0x002fce0000015200ULL,
0x01760005ff0075a7ULL, 0x000e640008000147ULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff0c7224ULL, 0x000fce00078e00ffULL, 0x000000100c00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fce0000015200ULL,
0x0000000a060d7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e07ULL,
0x003d09000d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff027819ULL, 0x000fc8000001140bULL, 0x0000000d02027211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060bULL, 0x0000000202027819ULL, 0x000fc8000000120bULL,
0x000000020000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000010c0c7836ULL, 0x000fce0000000000ULL, 0x01760005ff0075a7ULL, 0x000e640008000147ULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000000057919ULL, 0x000e620000000000ULL,
0x00000001ff0a7424ULL, 0x000fe400078e00ffULL, 0x0000002000027824ULL, 0x002fca00078e0205ULL,
0x00000003ff047819ULL, 0x000fc80000011602ULL, 0x1ffffffe04057812ULL, 0x000fe400078ec0ffULL,
0x0000000f02047812ULL, 0x000fc600078ec0ffULL, 0x0000000102057824ULL, 0x000fe400078e0205ULL,
0x0000001004067824ULL, 0x040fe400078e00ffULL, 0x0000000105027836ULL, 0x000fe20000000000ULL,
0x0000000f05057812ULL, 0x000fe200078ec0ffULL, 0x0000001004077824ULL, 0x000fc600078e00ffULL,
0x0000000f02027812ULL, 0x000fe400078ec0ffULL, 0x000000f006057812ULL, 0x000fe400078ee205ULL,
0x000000f007027812ULL, 0x000fe400078ee202ULL, 0x0000000705057c11ULL, 0x000fe4000f8e20ffULL,
0x0000000702027c11ULL, 0x000fc6000f8e20ffULL, 0x0000000005107984ULL, 0x000e680000000c00ULL,
0x00000000020c7984ULL, 0x000ea20000000c00ULL, 0x000000ffff147224ULL, 0x002fe400078e0010ULL,
0x000000ffff107224ULL, 0x000fe400078e0011ULL, 0x000000ffff157224ULL, 0x000fe400078e0012ULL,
0x000000ffff117224ULL, 0x000fc400078e0013ULL, 0x000000ffff167224ULL, 0x004fe400078e000cULL,
0x000000ffff177224ULL, 0x000fe400078e000eULL, 0x000000ffff127224ULL, 0x000fe400078e000dULL,
0x000000ffff137224ULL, 0x000fe200078e000fULL, 0x0000001405007388ULL, 0x0003e80000000c00ULL,
0x0000001002007388ULL, 0x0003e20000000c00ULL, 0x0176000aff0a79a7ULL, 0x000ea40008500007ULL,
0x0000000000047805ULL, 0x002fce0000015200ULL, 0x0176000bff0075a7ULL, 0x004e640008000147ULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff0c7224ULL, 0x000fce00078e00ffULL,
0x000000100c00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fce0000015200ULL, 0x00000006040d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff027819ULL, 0x000fc80000011407ULL,
0x0000000d02027211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000202027819ULL, 0x000fc80000001207ULL, 0x000000020000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000010c0c7836ULL, 0x000fce0000000000ULL,
0x0176000bff0075a7ULL, 0x000e640008000147ULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000ff7b00720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x00009400ff047b82ULL, 0x000e620000000800ULL, 0x0000000000027919ULL, 0x000ea20000000000ULL,
0x00008400000a7ab9ULL, 0x000fe20000000800ULL, 0x00000007006f7c11ULL, 0x000fe2000f8e28ffULL,
0x0000001f0a047890ULL, 0x000fe4000fffe03fULL, 0x8000000a7a067c36ULL, 0x000fe20008000000ULL,
0xffffffff0a057890ULL, 0x000fe2000fffe03fULL, 0x000000ffff647224ULL, 0x000fe200078e00ffULL,
0x000000043f047899ULL, 0x000fe20008011604ULL, 0x000000ffff057224ULL, 0x000fe200078e00ffULL,
0x00000008ff067819ULL, 0x000fe20000011606ULL, 0x000000090a067890ULL, 0x000fc4000fffe03fULL,
0x0ffffffe04047892ULL, 0x000fe2000f8ec03fULL, 0x0000000403037224ULL, 0x002fe400078e02ffULL,
0x3db504f308037820ULL, 0x010fe20000410000ULL, 0x0000010009047836ULL, 0x000fe20000000000ULL,
0x0000000700047c11ULL, 0x000fce000f8e18ffULL, 0x0000040001097983ULL, 0x004ee20000100800ULL,
0x00008e00ff067b82ULL, 0x000e620000000a00ULL, 0x00000040000b7824ULL, 0x000fe400078e00ffULL,
0x00000000010a7983ULL, 0x010f220000100800ULL, 0x0000000264087836ULL, 0x000fe40000000000ULL,
0x000001000b0b7836ULL, 0x000fc60000000000ULL, 0x0000007b0800720cULL, 0x000fe20003f06070ULL,
0x0000010064697824ULL, 0x000fe200078e020bULL, 0x00000001056e7812ULL, 0x000fe200078e0cffULL,
0x00000070090b7224ULL, 0x008fc600078e02ffULL, 0x0000004069097812ULL, 0x000fe200078ec0ffULL,
0x000000800b067825ULL, 0x002fc800078e0006ULL, 0x000000010a097824ULL, 0x010fe400078e0209ULL,
0x0000000c002c8947ULL, 0x000fea0003800000ULL, 0x00000003ff1d7819ULL, 0x004fe40000011602ULL,
0x000000697a0e7248ULL, 0x000fc60007fe0000ULL, 0x000000041d0b7836ULL, 0x000fe40000000000ULL,
0x000000081d137836ULL, 0x000fe40000000000ULL, 0x000000010b087824ULL, 0x040fe400078e0202ULL,
0x000000080b297824ULL, 0x040fe400078e00ffULL, 0x000000010b0c7824ULL, 0x000fe400078e0209ULL,
0x000000010e0e7824ULL, 0x000fe200078e0a69ULL, 0xfffffff829297812ULL, 0x000fe200078ee208ULL,
0x0000001002087824ULL, 0x000fc400078e00ffULL, 0x0000000113257824ULL, 0x000fe200078e0202ULL,
0x0000000e0b00720cULL, 0x000fe20003fa6070ULL, 0x0000000813107824ULL, 0x000fe200078e00ffULL,
0x0000007008087812ULL, 0x000fe200078ec0ffULL, 0x000000011d0a7824ULL, 0x000fe400078e0209ULL,
0x0000000c1d157836ULL, 0x000fe20000000000ULL, 0xfffffff810257812ULL, 0x000fe200078ee225ULL,
0x000000800c0c7825ULL, 0x000fc600078e00ffULL, 0x0000000e1500720cULL, 0x000fe20003f46070ULL,
0x000000101d177836ULL, 0x000fe20000000000ULL, 0x000000080c0f7212ULL, 0x000fe200078efcffULL,
0x000000800a0a7825ULL, 0x000fc600078e00ffULL, 0x0000000f060c7210ULL, 0x000fe20007f3e0ffULL,
0x0000000115107824ULL, 0x140fe200078e0202ULL, 0x000000080a117212ULL, 0x000fe200078efcffULL,
0x00000008152b7824ULL, 0x000fe400078e00ffULL, 0x0000000117237824ULL, 0x040fe200078e0202ULL,
0x00000011060a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000817127824ULL, 0x000fe200078e00ffULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee210ULL, 0x0000000113107824ULL, 0x000fe400078e0209ULL,
0x00000001070d7824ULL, 0x000fe200008e060dULL, 0xfffffff812237812ULL, 0x000fe200078ee223ULL,
0x0000000115127824ULL, 0x000fe200078e0209ULL, 0x0000000e1300720cULL, 0x000fe20003f26070ULL,
0x000000141d277836ULL, 0x000fc40000000000ULL, 0x0000008010107825ULL, 0x000fc800078e00ffULL,
0x0000000117147824ULL, 0x000fe400078e0209ULL, 0x0000008012127825ULL, 0x000fc800078e00ffULL,
0x00000001070b7824ULL, 0x000fe200000e060bULL, 0x0000000e1700720cULL, 0x000fe20003f06070ULL,
0x00000001271a7824ULL, 0x000fe200078e0209ULL, 0x0000000810177212ULL, 0x080fe200078efcffULL,
0x000000181d2f7836ULL, 0x000fe20000000000ULL, 0x00000008120f7212ULL, 0x080fe200078efcffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000001706167210ULL, 0x000fe40007f7e0ffULL,
0x0000000f06187210ULL, 0x000fe20007f9e0ffULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000000814197212ULL, 0x000fc600078efcffULL, 0x000000012f1e7824ULL, 0x000fe200078e0209ULL,
0x000000081a0f7212ULL, 0x000fe200078efcffULL, 0x0000000107177824ULL, 0x000fe200018e0611ULL,
0x0000001906147210ULL, 0x000fe20007f7e0ffULL, 0x000000801e1e7825ULL, 0x000fc800078e00ffULL,
0x0000001c1d317836ULL, 0x000fe20000000000ULL, 0x000000081e117212ULL, 0x000fe200078efcffULL,
0x0000000107197824ULL, 0x000fe200020e0613ULL, 0x0000000f06127210ULL, 0x000fe20007f9e0ffULL,
0x00000001311a7824ULL, 0x000fe200078e0209ULL, 0x00000007000f7c11ULL, 0x000fe2000f8e70ffULL,
0x0000000107157824ULL, 0x040fe200018e0615ULL, 0x0000001106107210ULL, 0x000fe20007f7e0ffULL,
0x0000000107137824ULL, 0x000fe200020e061bULL, 0x0000000e1d00720cULL, 0x040fe20003f86070ULL,
0x000000011d1e7824ULL, 0x000fc400078e0202ULL, 0x000000801a1a7825ULL, 0x000fc600078e00ffULL,
0x000000071e217812ULL, 0x000fe200078ec0ffULL, 0x000000201d337836ULL, 0x000fe40000000000ULL,
0x0000000107117824ULL, 0x000fe200018e061fULL, 0x000000081a1f7212ULL, 0x000fe200078efcffULL,
0x000020006e1c7824ULL, 0x000fe200078e020fULL, 0x0ffffff821217812ULL, 0x000fe200078ef802ULL,
0x00000001331e7824ULL, 0x000fe200078e0209ULL, 0x0000001f061a7210ULL, 0x000fe20007fde0ffULL,
0x000010001c1c7836ULL, 0x000fe20000000000ULL, 0x0000000e2700720cULL, 0x040fe20003f66070ULL,
0x0000000127207824ULL, 0x000fc400078e0202ULL, 0x00000008272d7824ULL, 0x000fe400078e00ffULL,
0x000000801e1e7825ULL, 0x000fc600078e00ffULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee220ULL,
0x000000241d357836ULL, 0x000fe40000000000ULL, 0x0000001021277824ULL, 0x000fe200078e021cULL,
0x000000081e217212ULL, 0x000fe200078efcffULL, 0x0000000135207824ULL, 0x000fe400078e0209ULL,
0x00000001071b7824ULL, 0x000fe200030e061bULL, 0x00000021061e7210ULL, 0x000fe20007fde0ffULL,
0x000000281d377836ULL, 0x000fe20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a277faeULL, 0x0003e2000e101c48ULL, 0x0000008020207825ULL, 0x000fe200078e00ffULL,
0x0000000e2f00720cULL, 0x000fc60003f86070ULL, 0x0000000137227824ULL, 0x000fe400078e0209ULL,
0x0000002c1d397836ULL, 0x000fe40000000000ULL, 0x00000001071f7824ULL, 0x000fe400030e061fULL,
0x0000001025257824ULL, 0x100fe400078e021cULL, 0x0000001029277824ULL, 0x002fe200078e021cULL,
0x0000000820297212ULL, 0x000fe200078efcffULL, 0x00000080220a7825ULL, 0x000fc600078e00ffULL,
0x000000000c277faeULL, 0x0003e2000e901c48ULL, 0x0000000e3100720cULL, 0x040fe20003fa6070ULL,
0x0000000131227824ULL, 0x140fe200078e0202ULL, 0x0000002906207210ULL, 0x000fe20007fde0ffULL,
0x0000000831317824ULL, 0x000fe200078e00ffULL, 0x000000080a297212ULL, 0x000fe200078efcffULL,
0x000000012f247824ULL, 0x140fe200078e0202ULL, 0x0000000016257faeULL, 0x0005e2000c901c48ULL,
0x000000082f2f7824ULL, 0x000fe200078e00ffULL, 0xfffffff831317812ULL, 0x000fe200078ee222ULL,
0x0000000107217824ULL, 0x000fe200030e0621ULL, 0x00000029060a7210ULL, 0x000fe20007fde0ffULL,
0x00000001390c7824ULL, 0x002fe200078e0209ULL, 0x0000000e3300720cULL, 0x040fe20003f26070ULL,
0x0000000133227824ULL, 0x000fe200078e0202ULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee224ULL,
0x000000800c0c7825ULL, 0x000fc800078e00ffULL, 0x000000102b277824ULL, 0x000fe200078e021cULL,
0x000000080c297212ULL, 0x000fe200078efcffULL, 0x0000000833337824ULL, 0x000fe400078e00ffULL,
0x0000000135247824ULL, 0x040fe200078e0202ULL, 0x0000000018277faeULL, 0x0003e2000d101c48ULL,
0x00000008352b7824ULL, 0x040fe200078e00ffULL, 0x0000000e3500720cULL, 0x000fe20003f46070ULL,
0x00000001070b7824ULL, 0x000fe200030e060bULL, 0x00000029060c7210ULL, 0x000fe20007fde0ffULL,
0x0000001023237824ULL, 0x100fe200078e021cULL, 0xfffffff833297812ULL, 0x000fe200078ee222ULL,
0x000000102d177824ULL, 0x104fe200078e021cULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee224ULL,
0x00000001070d7824ULL, 0x000fe200030e060dULL, 0x0000000014237faeULL, 0x0005e2000c101c48ULL,
0x0000001031257824ULL, 0x000fc400078e021cULL, 0x0000001029277824ULL, 0x102fe200078e021cULL,
0x0000000012177faeULL, 0x0003e2000d901c48ULL, 0x000000102b297824ULL, 0x100fe400078e021cULL,
0x000000301d2b7836ULL, 0x000fe40000000000ULL, 0x000000102f197824ULL, 0x000fe400078e021cULL,
0x000000012b147824ULL, 0x144fe200078e0209ULL, 0x0000000e2b00720cULL, 0x080fe40003f66070ULL,
0x0000000010197faeULL, 0x0005e2000e101c48ULL, 0x000000341d157836ULL, 0x000fe20000000000ULL,
0x0000000e3900720cULL, 0x080fe20003f86070ULL, 0x000000381d237836ULL, 0x000fe20000000000ULL,
0x000000001a257faeULL, 0x000fe2000e901c48ULL, 0x0000000115127824ULL, 0x002fe200078e0209ULL,
0x0000000e3700720cULL, 0x080fe20003fa6070ULL, 0x0000003c1d1d7836ULL, 0x000fe20000000000ULL,
0x000000001e277faeULL, 0x0003e2000c901c48ULL, 0x0000000e2300720cULL, 0x040fe20003f26070ULL,
0x0000000123187824ULL, 0x000fc400078e0202ULL, 0x0000008014107825ULL, 0x004fe200078e00ffULL,
0x0000000020297faeULL, 0x0005e2000d101c48ULL, 0x0000000e1500720cULL, 0x000fe40003f46070ULL,
0x0000000137147824ULL, 0x040fe200078e0202ULL, 0x0000000810137212ULL, 0x000fe200078efcffULL,
0x0000000837197824ULL, 0x000fe200078e00ffULL, 0x0000000e1d00720cULL, 0x000fe20003f06070ULL,
0x000000082b1f7824ULL, 0x002fe200078e00ffULL, 0x0000001306107210ULL, 0x000fe20007fde0ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0xfffffff819197812ULL, 0x000fc600078ee214ULL,
0x0000000107117824ULL, 0x000fe200030e0611ULL, 0x0000000812177212ULL, 0x000fe200078efcffULL,
0x000000012b147824ULL, 0x100fe400078e0202ULL, 0x0000000123127824ULL, 0x000fe200078e0209ULL,
0x0000001706167210ULL, 0x000fe20007fde0ffULL, 0x00000001390e7824ULL, 0x040fe200078e0202ULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee214ULL, 0x00000008391b7824ULL, 0x000fe400078e00ffULL,
0x0000000107177824ULL, 0x000fc400030e0613ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0xfffffff81b1b7812ULL, 0x000fc600078ee20eULL, 0x000000011d147824ULL, 0x000fe200078e0209ULL,
0x0000000812097212ULL, 0x000fe200078efcffULL, 0x00000001150e7824ULL, 0x040fe400078e0202ULL,
0x0000000815217824ULL, 0x004fe200078e00ffULL, 0x0000000906127210ULL, 0x000fe20007fde0ffULL,
0x0000008014147825ULL, 0x000fc600078e00ffULL, 0xfffffff821217812ULL, 0x000fe200078ee20eULL,
0x0000000823237824ULL, 0x000fe400078e00ffULL, 0x000000011d1a7824ULL, 0x040fe400078e0202ULL,
0x000000081d257824ULL, 0x000fe200078e00ffULL, 0x00000008141d7212ULL, 0x000fe200078efcffULL,
0x0000000107137824ULL, 0x000fe200030e0613ULL, 0xfffffff823237812ULL, 0x000fe200078ee218ULL,
0x0000001019097824ULL, 0x100fe200078e021cULL, 0xfffffff825257812ULL, 0x000fe200078ee21aULL,
0x000000101b197824ULL, 0x100fe200078e021cULL, 0x0000001d06067210ULL, 0x000fe20007fde0ffULL,
0x000000101f1b7824ULL, 0x100fe200078e021cULL, 0x000000000a097faeULL, 0x0003e2000e901c48ULL,
0x00000010211d7824ULL, 0x000fc400078e021cULL, 0x00000010231f7824ULL, 0x100fe200078e021cULL,
0x000000000c197faeULL, 0x0003e2000e101c48ULL, 0x0000001025217824ULL, 0x000fe400078e021cULL,
0x0000000107077824ULL, 0x000fe200030e0615ULL, 0x00000000101b7faeULL, 0x0003e8000d901c48ULL,
0x00000000161d7faeULL, 0x0003e8000d101c48ULL, 0x00000000121f7faeULL, 0x0003e8000c901c48ULL,
0x0000000006217faeULL, 0x0003e2000c101c48ULL, 0x0000000800dc7947ULL, 0x000fea0003800000ULL,
0x00000008020d7811ULL, 0x044fe200078fe8ffULL, 0x00000010023f7824ULL, 0x040fe200078e00ffULL,
0x00000004020c7811ULL, 0x040fe400078fe8ffULL, 0x0000001402147811ULL, 0x040fe200078fe8ffULL,
0x000000010d0a7824ULL, 0x140fe200078e0202ULL, 0x0000001002127811ULL, 0x040fe200078fe8ffULL,
0x000000080d397824ULL, 0x000fe200078e00ffULL, 0x0000001802167811ULL, 0x000fe200078fe8ffULL,
0x000000010c087824ULL, 0x100fe200078e0202ULL, 0x0000000c02107811ULL, 0x000fe200078fe8ffULL,
0x000000080c3b7824ULL, 0x000fe200078e00ffULL, 0x00000024021c7811ULL, 0x000fe200078fe8ffULL,
0x00000001140b7824ULL, 0x140fe200078e0202ULL, 0xfffffff839397812ULL, 0x000fe200078ee20aULL,
0x0000000814187824ULL, 0x000fe200078e00ffULL, 0xfffffff83b3b7812ULL, 0x000fe200078ee208ULL,
0x00000001120a7824ULL, 0x100fe200078e0202ULL, 0x00000020021a7811ULL, 0x000fe200078fe8ffULL,
0x0000000812357824ULL, 0x000fe200078e00ffULL, 0x00000028021e7811ULL, 0x000fe200078fe8ffULL,
0x00000001160e7824ULL, 0x140fe200078e0202ULL, 0xfffffff818337812ULL, 0x000fe200078ee20bULL,
0x0000000816317824ULL, 0x000fe200078e00ffULL, 0x0000001c02187811ULL, 0x000fe200078fe8ffULL,
0x0000000110087824ULL, 0x140fe200078e0202ULL, 0xfffffff835357812ULL, 0x000fe200078ee20aULL,
0x0000000810377824ULL, 0x000fe200078e00ffULL, 0xfffffff831317812ULL, 0x000fe200078ee20eULL,
0x000000011c0b7824ULL, 0x100fe200078e0202ULL, 0x0000003002227811ULL, 0x000fe200078fe8ffULL,
0x000000081c207824ULL, 0x000fe200078e00ffULL, 0xfffffff837377812ULL, 0x000fe200078ee208ULL,
0x000000011a0a7824ULL, 0x100fe200078e0202ULL, 0x00000038022a7811ULL, 0x000fe200078fe8ffULL,
0x000000081a2d7824ULL, 0x000fe200078e00ffULL, 0xfffffff8202b7812ULL, 0x000fe200078ee20bULL,
0x000000011e0e7824ULL, 0x100fe200078e0202ULL, 0x0000002c02207811ULL, 0x000fe200078fe8ffULL,
0x000000081e297824ULL, 0x000fe200078e00ffULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee20aULL,
0x0000000118087824ULL, 0x100fe200078e0202ULL, 0x00000034022c7811ULL, 0x000fe200078fe8ffULL,
0x00000008182f7824ULL, 0x000fe200078e00ffULL, 0xfffffff829297812ULL, 0x000fe200078ee20eULL,
0x00000001220a7824ULL, 0x100fe200078e0202ULL, 0x00000007000f7c11ULL, 0x000fe2000f8e70ffULL,
0x0000000822137824ULL, 0x000fe200078e00ffULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee208ULL,
0x000000012a0e7824ULL, 0x140fe200078e0202ULL, 0x000000703f3f7812ULL, 0x000fe200078ec0ffULL,
0x000000082a157824ULL, 0x000fe200078e00ffULL, 0xfffffff813137812ULL, 0x000fe200078ee20aULL,
0x0000000120087824ULL, 0x100fe200078e0202ULL, 0x00000002020a7211ULL, 0x000fe200078fe8ffULL,
0x0000000820277824ULL, 0x000fe200078e00ffULL, 0xfffffff815157812ULL, 0x000fe200078ee20eULL,
0x000000012c0b7824ULL, 0x100fe200078e0202ULL, 0x0000003c020e7811ULL, 0x000fe200078fe8ffULL,
0x000000082c247824ULL, 0x000fe200078e00ffULL, 0xfffffff827277812ULL, 0x000fe200078ee208ULL,
0x0000000110107824ULL, 0x100fe200078e0209ULL, 0x0000000902087211ULL, 0x000fe200078fe8ffULL,
0x000000010e287824ULL, 0x140fe200078e0209ULL, 0xfffffff824257812ULL, 0x000fe200078ee20bULL,
0x000000010e117824ULL, 0x000fe200078e0202ULL, 0x000000070a0b7812ULL, 0x000fe200078ec0ffULL,
0x000000010c0a7824ULL, 0x000fc400078e0209ULL, 0x000000010d0c7824ULL, 0x100fe200078e0209ULL,
0x0ffffff80b3d7812ULL, 0x000fe200078ef802ULL, 0x0000000112127824ULL, 0x100fe400078e0209ULL,
0x0000000114147824ULL, 0x100fe400078e0209ULL, 0x0000000116167824ULL, 0x100fe400078e0209ULL,
0x0000000118187824ULL, 0x100fe400078e0209ULL, 0x000000011a1a7824ULL, 0x000fc400078e0209ULL,
0x000000011c1c7824ULL, 0x100fe400078e0209ULL, 0x000000011e1e7824ULL, 0x100fe400078e0209ULL,
0x0000000120207824ULL, 0x100fe400078e0209ULL, 0x0000000122227824ULL, 0x100fe400078e0209ULL,
0x000000012c2c7824ULL, 0x100fe400078e0209ULL, 0x000000012a2a7824ULL, 0x000fc400078e0209ULL,
0x000000080e0e7824ULL, 0x000fe400078e00ffULL, 0x0000008008087825ULL, 0x000fc600078e00ffULL,
0xfffffff80e177812ULL, 0x000fe200078ee211ULL, 0x000020006e0d7824ULL, 0x000fe200078e020fULL,
0x0000003f08117212ULL, 0x000fe200078efcffULL, 0x000000800a0a7825ULL, 0x000fc600078e00ffULL,
0x0000001106087210ULL, 0x000fe20007f1e0ffULL, 0x000010000d0e7836ULL, 0x000fe20000000000ULL,
0x0000003f0a117212ULL, 0x000fe200078efcffULL, 0x000000800c0c7825ULL, 0x000fc600078e00ffULL,
0x00000011060a7210ULL, 0x000fe20007f3e0ffULL, 0x0000001015247824ULL, 0x000fe200078e020eULL,
0x0000003f0c157212ULL, 0x000fe200078efcffULL, 0x0000008010107825ULL, 0x000fc800078e00ffULL,
0x0000000107097824ULL, 0x000fe200000e0609ULL, 0x00000015060c7210ULL, 0x000fe20007f1e0ffULL,
0x000000103d3d7824ULL, 0x100fe200078e020eULL, 0x0000003f10197212ULL, 0x000fe200078efcffULL,
0x000000103b3b7824ULL, 0x100fe400078e020eULL, 0x0000001039397824ULL, 0x100fe200078e020eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000083d7faeULL, 0x0003e2000b901c48ULL,
0x0000001037377824ULL, 0x100fe400078e020eULL, 0x0000001035357824ULL, 0x000fc400078e020eULL,
0x0000001033337824ULL, 0x100fe400078e020eULL, 0x0000001031317824ULL, 0x100fe400078e020eULL,
0x000000102f2f7824ULL, 0x100fe400078e020eULL, 0x000000102d2d7824ULL, 0x100fe400078e020eULL,
0x000000102b2b7824ULL, 0x100fe400078e020eULL, 0x0000001029297824ULL, 0x000fc400078e020eULL,
0x0000001027277824ULL, 0x100fe400078e020eULL, 0x0000001013267824ULL, 0x100fe400078e020eULL,
0x0000001025257824ULL, 0x100fe400078e020eULL, 0x00000010170e7824ULL, 0x000fe400078e020eULL,
0x0000008016167825ULL, 0x000fc800078e00ffULL, 0x00000001070d7824ULL, 0x000fe200000e060dULL,
0x0000001906107210ULL, 0x000fe20007f1e0ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000003f16197212ULL, 0x000fc600078efcffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000003f141b7212ULL, 0x080fe400078efcffULL, 0x0000001906167210ULL, 0x000fe20007f5e0ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x0000003f121d7212ULL, 0x000fc600078efcffULL,
0x0000000107117824ULL, 0x040fe200000e0611ULL, 0x0000001b06147210ULL, 0x000fe20007f1e0ffULL,
0x00000001070b7824ULL, 0x040fe200008e060bULL, 0x0000001d06127210ULL, 0x000fe20007f3e0ffULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x0000003f18237212ULL, 0x080fe400078efcffULL,
0x000000000a3b7faeULL, 0x0003e2000b901c48ULL, 0x0000000107157824ULL, 0x000fe200000e0615ULL,
0x0000002306187210ULL, 0x000fe20007f1e0ffULL, 0x000000801e1e7825ULL, 0x000fe200078e00ffULL,
0x0000003f1c417212ULL, 0x080fe200078efcffULL, 0x000000000c397faeULL, 0x0003e4000b901c48ULL,
0x0000008020207825ULL, 0x000fe200078e00ffULL, 0x0000003f1e237212ULL, 0x000fe200078efcffULL,
0x0000000010377faeULL, 0x0003e4000b901c48ULL, 0x000000801a1a7825ULL, 0x000fc800078e00ffULL,
0x0000000107197824ULL, 0x040fe200000e0619ULL, 0x00000041061c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000107177824ULL, 0x040fe200010e0617ULL, 0x0000003f20417212ULL, 0x080fe200078efcffULL,
0x0000000107137824ULL, 0x040fe200008e0613ULL, 0x0000003f1a437212ULL, 0x080fe200078efcffULL,
0x00000001071d7824ULL, 0x040fe200000e061dULL, 0x00000023061e7210ULL, 0x000fe20007f5e0ffULL,
0x0000008022227825ULL, 0x000fe200078e00ffULL, 0x0000004106207210ULL, 0x000fe20007f1e0ffULL,
0x0000000012357faeULL, 0x0003e2000b901c48ULL, 0x00000043061a7210ULL, 0x000fe20007f3e0ffULL,
0x000000802c407825ULL, 0x000fe200078e00ffULL, 0x0000003f224b7212ULL, 0x080fe200078efcffULL,
0x0000000014337faeULL, 0x0003e4000b901c48ULL, 0x000000802a427825ULL, 0x000fe200078e00ffULL,
0x0000003f40497212ULL, 0x080fe200078efcffULL, 0x0000000016317faeULL, 0x0003e4000b901c48ULL,
0x0000008028447825ULL, 0x000fe200078e00ffULL, 0x0000003f42477212ULL, 0x080fe200078efcffULL,
0x00000000182f7faeULL, 0x0003e4000b901c48ULL, 0x0000000107217824ULL, 0x040fe200000e0621ULL,
0x0000003f443f7212ULL, 0x000fe200078efcffULL, 0x00000001071b7824ULL, 0x040fe200008e061bULL,
0x0000004b06227210ULL, 0x000fe20007f1e0ffULL, 0x00000001071f7824ULL, 0x000fe200010e061fULL,
0x00000049063e7210ULL, 0x000fc40007f3e0ffULL, 0x0000004706407210ULL, 0x000fe20007f5e0ffULL,
0x0000000107237824ULL, 0x040fe200000e0623ULL, 0x0000003f06067210ULL, 0x000fe20007f7e0ffULL,
0x00000001073f7824ULL, 0x040fe200008e0641ULL, 0x000000001a2d7faeULL, 0x0003e2000b901c48ULL,
0x0000000107417824ULL, 0x040fe400010e0643ULL, 0x0000000107077824ULL, 0x000fe200018e0645ULL,
0x000000001c2b7faeULL, 0x0003e8000b901c48ULL, 0x000000001e297faeULL, 0x0003e8000b901c48ULL,
0x0000000020277faeULL, 0x0003e8000b901c48ULL, 0x0000000022267faeULL, 0x0003e8000b901c48ULL,
0x000000003e257faeULL, 0x0003e8000b901c48ULL, 0x0000000040247faeULL, 0x0003e8000b901c48ULL,
0x00000000060e7faeULL, 0x0003e4000b901c48ULL, 0x000000026a6a7836ULL, 0x000fe20000000000ULL,
0x0000000000067919ULL, 0x002e620000002700ULL, 0x00009400ff077b82ULL, 0x000e620000000800ULL,
0xffffffffff707424ULL, 0x000fe400078e00ffULL, 0x0000007d6a00720cULL, 0x000fe20003f06070ULL,
0x00000000000079afULL, 0x000e180000000000ULL, 0x00009000ff088b82ULL, 0x000ea20000000a00ULL,
0x00000020020b7836ULL, 0x000fe40000000000ULL, 0x0000000706067224ULL, 0x002fe200078e02ffULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000206078824ULL, 0x000fe200078e026aULL,
0x0000000702067812ULL, 0x000fe400078ec0ffULL, 0x00000000001e7805ULL, 0x000fc4000001ff00ULL,
0x00000000001c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000407088825ULL, 0x004fe200078e0008ULL, 0xfffffff80b0b7812ULL, 0x000fe400078ec0ffULL,
0x0000000000207805ULL, 0x000fe4000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000200005077824ULL, 0x000fe200078e020fULL, 0xfffffff802057812ULL, 0x000fe200078ec0ffULL,
0x0000000808708981ULL, 0x000322000c1e1900ULL, 0x0000000000247805ULL, 0x000fc4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fc4000001ff00ULL,
0x0000000000367805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fe4000001ff00ULL,
0x0000000705087812ULL, 0x002fe200078ef802ULL, 0x0000100007077836ULL, 0x000fe20000000000ULL,
0x0000000806097812ULL, 0x000fe200078ef802ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000070b057812ULL, 0x000fce00078ef802ULL, 0x00000001080b7824ULL, 0x040fe200078e020aULL,
0x00000004ff0f7819ULL, 0x000fe20000011602ULL, 0x00000008080c7824ULL, 0x040fe400078e00ffULL,
0x00000008080d7824ULL, 0x000fe400078e00ffULL, 0x00000010093a7824ULL, 0x000fe200078e00ffULL,
0xfffffff80c0c7812ULL, 0x000fe200078ee20bULL, 0x00000001050b7824ULL, 0x040fe400078e020aULL,
0x00000008053c7824ULL, 0x000fc400078e00ffULL, 0x000000100c187824ULL, 0x000fe400078e0207ULL,
0x00000008050c7824ULL, 0x000fe400078e00ffULL, 0x0000001009397824ULL, 0x000fe400078e00ffULL,
0x000000001818783bULL, 0x000e620000000200ULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee20bULL,
0x000000010a0b7836ULL, 0x000fc80000000000ULL, 0x000000100c107824ULL, 0x000fe400078e0207ULL,
0x00000001080c7824ULL, 0x100fe400078e020bULL, 0x00000001050b7824ULL, 0x000fe400078e020bULL,
0x000000001010783bULL, 0x000ea20000000200ULL, 0xfffffff80d0e7812ULL, 0x000fe200078ee20cULL,
0x000000020a0c7824ULL, 0x000fe400078e020fULL, 0x000000020a0a7836ULL, 0x000fc40000000000ULL,
0x000000100e0e7824ULL, 0x000fe200078e0207ULL, 0x0000000209717810ULL, 0x140fe20007ffe00cULL,
0x0000000109387824ULL, 0x000fe200078e020cULL, 0x000000080a00780cULL, 0x000fe40003f05270ULL,
0xfffffff03a717812ULL, 0x000fe200078ee271ULL, 0x000000000e0c783bULL, 0x000ee20000000200ULL,
0xfffffff83c3a7812ULL, 0x000fe400078ee20bULL, 0xfffffff039387812ULL, 0x000fe400078ee238ULL,
0x00000010ff467819ULL, 0x002fc40000011618ULL, 0x00000018ff787819ULL, 0x000fe40000011618ULL,
0x000000ff18767812ULL, 0x040fe400078ec0ffULL, 0x0000ffff184c7812ULL, 0x000fe200078ec0ffULL,
0x000000103a187824ULL, 0x000fe200078e0207ULL, 0x00000010ff3f7819ULL, 0x100fe40000011619ULL,
0x00000018ff747819ULL, 0x000fe40000011619ULL, 0x000000ff19727812ULL, 0x000fc400078ec0ffULL,
0x0000ffff19407812ULL, 0x000fe400078ec0ffULL, 0x00000010ff417819ULL, 0x100fe4000001161aULL,
0x00000018ff4f7819ULL, 0x000fe4000001161aULL, 0x000000ff1a4e7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff1a4d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff397819ULL, 0x000fc4000001161bULL,
0x00000018ff677819ULL, 0x000fe4000001161bULL, 0x000000ff1b527812ULL, 0x040fe400078ec0ffULL,
0x0000ffff1b3d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff3a7819ULL, 0x104fe20000011611ULL,
0x000000001818783bULL, 0x000e620000000200ULL, 0x00000018ff5a7819ULL, 0x000fe40000011611ULL,
0x000000ff11597812ULL, 0x000fc400078ec0ffULL, 0x0000ffff113b7812ULL, 0x000fe400078ec0ffULL,
0x000000ff13117812ULL, 0x000fe400078ec0ffULL, 0x000000ff46797812ULL, 0x000fe400078ec0ffULL,
0x00000010ff3e7819ULL, 0x100fe40000011610ULL, 0x00000018ff627819ULL, 0x000fe40000011610ULL,
0x000000ff105f7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff507819ULL, 0x100fe40000011612ULL,
0x00000018ff557819ULL, 0x000fe40000011612ULL, 0x000000ff12547812ULL, 0x040fe400078ec0ffULL,
0x0000ffff12517812ULL, 0x000fe400078ec0ffULL, 0x00000011ff46723eULL, 0x000fe400020006ffULL,
0x0000ffff10107812ULL, 0x000fc400078ec0ffULL, 0x00000018ff127819ULL, 0x100fe40000011613ULL,
0x0000000738117c11ULL, 0x000fe4000f8e20ffULL, 0x00000008ff777819ULL, 0x000fe4000001164cULL,
0x00000010ff577819ULL, 0x000fe40000011613ULL, 0x0000ffff13587812ULL, 0x000fe400078ec0ffULL,
0x00000012ff4c723eULL, 0x000fc400020006ffULL, 0x00000008ff607819ULL, 0x000fe40000011610ULL,
0x000000001110783bULL, 0x000ea20000000200ULL, 0x000000ff416d7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff6c7819ULL, 0x000fe4000001164dULL, 0x00000010ff537819ULL, 0x108fe4000001160cULL,
0x00000018ff497819ULL, 0x000fe4000001160cULL, 0x000000ff0c3c7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff0c617812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5c7819ULL, 0x100fe4000001160dULL,
0x00000018ff427819ULL, 0x000fe4000001160dULL, 0x000000ff0d487812ULL, 0x040fe400078ec0ffULL,
0x0000ffff0d5b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff567819ULL, 0x000fc4000001160eULL,
0x00000018ff447819ULL, 0x000fe4000001160eULL, 0x000000ff0e457812ULL, 0x040fe400078ec0ffULL,
0x0000ffff0e477812ULL, 0x000fe400078ec0ffULL, 0x00000010ff4a7819ULL, 0x100fe4000001160fULL,
0x00000018ff4b7819ULL, 0x000fe4000001160fULL, 0x000000ff0f437812ULL, 0x000fc400078ec0ffULL,
0x0000ffff0f0b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff3f757812ULL, 0x000fe400078ec0ffULL,
0x00000008ff737819ULL, 0x000fe40000011640ULL, 0x000000ff3e637812ULL, 0x000fe400078ec0ffULL,
0x0000004fff4f723eULL, 0x000fe400020006ffULL, 0x0000004eff4e723eULL, 0x000fc400020006ffULL,
0x0000006dff6d723eULL, 0x000fe400020006ffULL, 0x0000006cff6c723eULL, 0x000fe400020006ffULL,
0x00000010ff0c7819ULL, 0x102fe40000011618ULL, 0x00000018ff407819ULL, 0x000fe40000011618ULL,
0x000000ff18417812ULL, 0x040fe400078ec0ffULL, 0x0000ffff180d7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff0e7819ULL, 0x100fe40000011619ULL, 0x00000018ff3e7819ULL, 0x000fe40000011619ULL,
0x000000ff193f7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff190f7812ULL, 0x000fe400078ec0ffULL,
0x000000ff50507812ULL, 0x000fe400078ec0ffULL, 0x00000008ff517819ULL, 0x000fc40000011651ULL,
0x000000ff57187812ULL, 0x000fe400078ec0ffULL, 0x00000008ff197819ULL, 0x000fe40000011658ULL,
0x00000078ff78723eULL, 0x000fe400020006ffULL, 0x00000076ff76723eULL, 0x000fe400020006ffULL,
0x00000079ff79723eULL, 0x000fe400020006ffULL, 0x00000077ff77723eULL, 0x000fc400020006ffULL,
0x00000050ff58723eULL, 0x000fe400020006ffULL, 0x00000051ff57723eULL, 0x000fe400020006ffULL,
0x000054106d4f7816ULL, 0x000fe4000000004fULL, 0x000054104e4e7816ULL, 0x000fe4000000006cULL,
0x00000018ff50723eULL, 0x000fe400020006ffULL, 0x00000019ff51723eULL, 0x000fc400020006ffULL,
0x000000ff39687812ULL, 0x000fe200078ec0ffULL, 0x0000004e102c723cULL, 0x004fe2000000182cULL,
0x00000008ff667819ULL, 0x000fe4000001163dULL, 0x0000541079197816ULL, 0x000fe40000000078ULL,
0x0000541076187816ULL, 0x000fe40000000077ULL, 0x000000ff1a6b7812ULL, 0x000fe400078ec0ffULL,
0x00000074ff74723eULL, 0x000fc400020006ffULL, 0x00000072ff72723eULL, 0x000fe200020006ffULL,
0x000000181034723cULL, 0x000fe20000001834ULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x00000052ff52723eULL, 0x000fe400020006ffULL, 0x00000075ff75723eULL, 0x000fe400020006ffULL,
0x00000073ff73723eULL, 0x000fe400020006ffULL, 0x00000068ff68723eULL, 0x000fc400020006ffULL,
0x00000066ff66723eULL, 0x000fe400020006ffULL, 0x0000006bff4e723eULL, 0x000fe400020006ffULL,
0x000000ff536b7812ULL, 0x000fe400078ec0ffULL, 0x0000541075197816ULL, 0x000fe40000000074ULL,
0x0000541072187816ULL, 0x000fe40000000073ULL, 0x0000541068537816ULL, 0x000fc40000000067ULL,
0x0000541052527816ULL, 0x000fe40000000066ULL, 0x00000010ff387819ULL, 0x100fe2000001161aULL,
0x000000181030723cULL, 0x000fe20000001830ULL, 0x00000018ff4d7819ULL, 0x000fe4000001161aULL,
0x0000ffff1a397812ULL, 0x000fe400078ec0ffULL, 0x00000007711a7c11ULL, 0x000fe2000f8e20ffULL,
0x000000521028723cULL, 0x000fe20000001828ULL, 0x00000062ff62723eULL, 0x000fc400020006ffULL,
0x0000005fff5f723eULL, 0x000fe400020006ffULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x00000060ff60723eULL, 0x000fe400020006ffULL, 0x000000ff3a5e7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff5d7819ULL, 0x000fe4000001163bULL, 0x00000010ff3b7819ULL, 0x000fc4000001161bULL,
0x00000018ff657819ULL, 0x000fe4000001161bULL, 0x000000ff1b3a7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff1b3d7812ULL, 0x000fe400078ec0ffULL, 0x000000001a18783bULL, 0x000e620000000200ULL,
0x0000541063537816ULL, 0x000fe40000000062ULL, 0x000054105f527816ULL, 0x000fe40000000060ULL,
0x0000005aff5a723eULL, 0x000fc400020006ffULL, 0x00000059ff59723eULL, 0x000fe400020006ffULL,
0x0000005eff5e723eULL, 0x000fe200020006ffULL, 0x000000521024723cULL, 0x000fe20000001824ULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x00000055ff55723eULL, 0x000fe400020006ffULL,
0x00000054ff54723eULL, 0x000fe400020006ffULL, 0x000054105e537816ULL, 0x000fc4000000005aULL,
0x0000541059527816ULL, 0x000fe4000000005dULL, 0x00000008ff617819ULL, 0x000fe40000011661ULL,
0x0000541046467816ULL, 0x000fe40000000051ULL, 0x00000065ff4f723eULL, 0x000fe200020006ffULL,
0x000000521020723cULL, 0x000fe20000001820ULL, 0x00000049ff49723eULL, 0x000fe400020006ffULL,
0x0000003cff3c723eULL, 0x000fc400020006ffULL, 0x0000006bff65723eULL, 0x000fe400020006ffULL,
0x0000541058537816ULL, 0x000fe40000000055ULL, 0x0000541054527816ULL, 0x000fe40000000057ULL,
0x00000061ff5f723eULL, 0x000fe400020006ffULL, 0x000000ff56567812ULL, 0x000fe400078ec0ffULL,
0x000000ff0c0c7812ULL, 0x000fe200078ec0ffULL, 0x00000052101c723cULL, 0x000fe2000000181cULL,
0x00000008ff0d7819ULL, 0x000fc4000001160dULL, 0x00000044ff44723eULL, 0x000fe400020006ffULL,
0x00000045ff45723eULL, 0x000fe400020006ffULL, 0x00000008ff537819ULL, 0x000fe40000011647ULL,
0x0000541050477816ULL, 0x000fe4000000004cULL, 0x00000056ff52723eULL, 0x000fe400020006ffULL,
0x00000053ff53723eULL, 0x000fc400020006ffULL, 0x000000ff4a4a7812ULL, 0x000fe200078ec0ffULL,
0x000000461014723cULL, 0x000fe20000001814ULL, 0x000000ff5c5c7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff5b7819ULL, 0x000fe4000001165bULL, 0x00000008ff0b7819ULL, 0x000fe4000001160bULL,
0x0000541065117816ULL, 0x000fe40000000049ULL, 0x000054103c107816ULL, 0x000fc4000000005fULL,
0x000000ff0e0e7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff0f7819ULL, 0x000fe4000001160fULL,
0x000000ff38387812ULL, 0x000fe200078ec0ffULL, 0x000000101834723cULL, 0x002fe20000001834ULL,
0x00000008ff397819ULL, 0x000fe40000011639ULL, 0x000000ff3b3b7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff3d7819ULL, 0x000fc4000001163dULL, 0x0000000cff11723eULL, 0x000fe400020006ffULL,
0x0000000dff10723eULL, 0x000fe400020006ffULL, 0x00005410520d7816ULL, 0x000fe40000000044ULL,
0x00005410450c7816ULL, 0x000fe40000000053ULL, 0x0000004bff4b723eULL, 0x000fe400020006ffULL,
0x0000004aff4a723eULL, 0x000fc400020006ffULL, 0x00000042ff42723eULL, 0x000fe200020006ffULL,
0x0000000c182c723cULL, 0x000fe2000000182cULL, 0x00000048ff48723eULL, 0x000fe400020006ffULL,
0x00000043ff43723eULL, 0x000fe400020006ffULL, 0x00000040ff40723eULL, 0x000fe400020006ffULL,
0x00000041ff41723eULL, 0x000fe400020006ffULL, 0x0000003eff3e723eULL, 0x000fc400020006ffULL,
0x0000003fff3f723eULL, 0x000fe400020006ffULL, 0x0000004dff4d723eULL, 0x000fe400020006ffULL,
0x0000005cff5a723eULL, 0x000fe400020006ffULL, 0x0000005bff59723eULL, 0x000fe400020006ffULL,
0x0000000bff0b723eULL, 0x000fe400020006ffULL, 0x0000000eff0d723eULL, 0x000fc400020006ffULL,
0x0000000fff0f723eULL, 0x000fe400020006ffULL, 0x00000038ff38723eULL, 0x000fe400020006ffULL,
0x00000039ff39723eULL, 0x000fe400020006ffULL, 0x0000003aff3a723eULL, 0x000fe400020006ffULL,
0x0000003bff3b723eULL, 0x000fe400020006ffULL, 0x0000003dff3d723eULL, 0x000fc400020006ffULL,
0x000054104a4b7816ULL, 0x000fe4000000004bULL, 0x000054105a497816ULL, 0x000fe40000000042ULL,
0x0000541048487816ULL, 0x000fe40000000059ULL, 0x00005410434a7816ULL, 0x000fe4000000000bULL,
0x0000541011117816ULL, 0x000fe40000000040ULL, 0x0000541041107816ULL, 0x000fe20000000010ULL,
0x000000481830723cULL, 0x000fe20000001830ULL, 0x000054100d0d7816ULL, 0x000fc4000000003eULL,
0x000054103f0c7816ULL, 0x000fe4000000000fULL, 0x00005410384d7816ULL, 0x000fe2000000004dULL,
0x0000004a1828723cULL, 0x000fe20000001828ULL, 0x000054104e4c7816ULL, 0x000fe40000000039ULL,
0x000054103b3b7816ULL, 0x000fe4000000004fULL, 0x000054103a3a7816ULL, 0x000fe2000000003dULL,
0x000000101824723cULL, 0x000fec0000001824ULL, 0x0000000c1820723cULL, 0x000fec0000001820ULL,
0x0000004c181c723cULL, 0x000fec000000181cULL, 0x0000003a1814723cULL, 0x000fe20000001814ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0xfffffff0002c0947ULL, 0x000fde000383ffffULL,
0x00000001ff097424ULL, 0x000fe400078e00ffULL, 0x0000000334057220ULL, 0x080fe20000410000ULL,
0x0000000335357220ULL, 0x080fe20000410000ULL, 0x0000000336367220ULL, 0x080fe20000410000ULL,
0x0000000337377220ULL, 0x080fe20000410000ULL, 0x0000000330307220ULL, 0x080fe20000410000ULL,
0x01768809040879a7ULL, 0x000262000850003fULL, 0x0000000331317220ULL, 0x080fe20000410000ULL,
0x0000000332327220ULL, 0x080fe20000410000ULL, 0x0000000333337220ULL, 0x080fe20000410000ULL,
0x000000032c2c7220ULL, 0x080fe20000410000ULL, 0x000000032d2d7220ULL, 0x080fe20000410000ULL,
0x000000032e2e7220ULL, 0x080fe20000410000ULL, 0x000000032f2f7220ULL, 0x080fe20000410000ULL,
0x0000000328287220ULL, 0x080fe20000410000ULL, 0x0000000329297220ULL, 0x080fe20000410000ULL,
0x000000032a2a7220ULL, 0x080fe20000410000ULL, 0x000000032b2b7220ULL, 0x080fe20000410000ULL,
0x0000000324247220ULL, 0x080fe20000410000ULL, 0x0000000325257220ULL, 0x080fe20000410000ULL,
0x0000000326267220ULL, 0x080fe20000410000ULL, 0x0000000327277220ULL, 0x080fe20000410000ULL,
0x0000000320207220ULL, 0x080fe20000410000ULL, 0x0000000321217220ULL, 0x080fe20000410000ULL,
0x0000000322227220ULL, 0x080fe20000410000ULL, 0x0000000323237220ULL, 0x080fe20000410000ULL,
0x000000031c1c7220ULL, 0x080fe20000410000ULL, 0x000000031d1d7220ULL, 0x080fe20000410000ULL,
0x000000031e1e7220ULL, 0x080fe20000410000ULL, 0x000000031f1f7220ULL, 0x080fe20000410000ULL,
0x00000003141a7220ULL, 0x080fe20000410000ULL, 0x00000003151b7220ULL, 0x080fe20000410000ULL,
0x0000000316187220ULL, 0x080fe20000410000ULL, 0x0000000317197220ULL, 0x002fce0000410000ULL,
0x00000000000a7805ULL, 0x000fce0000015200ULL, 0x01768809040075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff0e7224ULL, 0x000fce00078e00ffULL,
0x000000100e00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000000c7805ULL, 0x000fce0000015200ULL, 0x0000000c0a0c7210ULL, 0x000fca0007f1e1ffULL,
0x000000010d0d7824ULL, 0x000fe200000e0e0bULL, 0x003d09000c00780cULL, 0x000fc80003f06070ULL,
0x000000ff0d00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400c00780cULL, 0x000fc80003f06070ULL, 0x000000ff0d00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff077819ULL, 0x000fc8000001140dULL,
0x0000000c07077211ULL, 0x000fca00078110ffULL, 0x000000ffff0c7224ULL, 0x000fca00000e060dULL,
0x0000000207077819ULL, 0x000fc8000000120cULL, 0x000000070000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000010e0e7836ULL, 0x000fce0000000000ULL,
0x01768809040075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000402077824ULL, 0x000fe200078e00ffULL, 0x0000000700087c11ULL, 0x000fe2000f8e38ffULL,
0x00008400000a7ab9ULL, 0x000fe40000000800ULL, 0x8000000a7a0c7c36ULL, 0x000fe20008000000ULL,
0xfffffff007077812ULL, 0x000fc800078ec0ffULL, 0x00000008ff0c7819ULL, 0x000fe2000001160cULL,
0x0000000108077824ULL, 0x000fc600078e0207ULL, 0x0000000c6400720cULL, 0x000fe40003f06070ULL,
0x0174000007087984ULL, 0x0002b60000000c00ULL, 0x0000001000c48947ULL, 0x002fea0003800000ULL,
0xffffff0069697836ULL, 0x000fe20000000000ULL, 0x00008c00ff0c7b82ULL, 0x000e620000000a00ULL,
0x0000000202177824ULL, 0x040fe200078e00ffULL, 0x0000007c020e7211ULL, 0x000fe200078ff0ffULL,
0x00008600000a7ab9ULL, 0x000fe20000000800ULL, 0x000000697a167248ULL, 0x000fe20007fe0000ULL,
0x00008400000b7ab9ULL, 0x000fe20000000800ULL, 0x0000000617177812ULL, 0x000fe400078ec0ffULL,
0x0000000aff0f7c19ULL, 0x000fe2000801160eULL, 0x0000000116167824ULL, 0x000fc400078e0a69ULL,
0x0000000617117c36ULL, 0x000fe20008000000ULL, 0x000000050f0f7c48ULL, 0x000fe2000bfe0000ULL,
0x000000ffff467224ULL, 0x000fe400078e0a16ULL, 0x0000000b17397c36ULL, 0x000fe20008000000ULL,
0x000000161100720cULL, 0x080fe20003f26070ULL, 0x000000080e0e7836ULL, 0x000fe20000000000ULL,
0x0000000511117e46ULL, 0x000fe2000b800046ULL, 0x000000040f517c24ULL, 0x000fe2000f8e02ffULL,
0x000000163900720cULL, 0x000fe40003f06070ULL, 0x0000000539427e46ULL, 0x000fc4000b800046ULL,
0x00000004ff117819ULL, 0x000fe40000011611ULL, 0x000000ff42427207ULL, 0x000fe40000000000ULL,
0x0000000aff0e7c19ULL, 0x000fe4000801160eULL, 0x000000ff11107207ULL, 0x000fe40000800000ULL,
0x0000005142157211ULL, 0x000fe400078fe0ffULL, 0x000000050e0e7c48ULL, 0x000fe2000bfe0000ULL,
0x0000000151137824ULL, 0x000fe200078e0210ULL, 0x00000010173d7812ULL, 0x000fe200078efcffULL,
0x0000000215147825ULL, 0x002fc800078e000cULL, 0x000000040e537c24ULL, 0x000fe2000f8e02ffULL,
0x0000000814487981ULL, 0x0002e2000c1e9500ULL, 0x0000000b3d3b7c36ULL, 0x000fe40008000000ULL,
0x0000000213127825ULL, 0x000fe200078e000cULL, 0x0000002017417812ULL, 0x000fc600078efcffULL,
0x00000001100f7824ULL, 0x000fe200078e0253ULL, 0x000000163b00720cULL, 0x080fe20003f06070ULL,
0x00000008124f7981ULL, 0x000ae2000c1e9500ULL, 0x000000063d157c36ULL, 0x002fe20008000000ULL,
0x000000053b347e46ULL, 0x000fe2000b800046ULL, 0x000000020f0e7825ULL, 0x100fe200078e000cULL,
0x0000005342117211ULL, 0x000fe400078fe0ffULL, 0x000000ff34347207ULL, 0x000fe20000000000ULL,
0x0000000b41437c36ULL, 0x000fe20008000000ULL, 0x000000080e4d7981ULL, 0x0002e2000c1e9500ULL,
0x0000000515127e46ULL, 0x024fe2000b800046ULL, 0x0000000211107825ULL, 0x000fe200078e000cULL,
0x000000161500720cULL, 0x000fc40003f26070ULL, 0x00000004ff127819ULL, 0x000fe20000011612ULL,
0x0000000641477c36ULL, 0x000fe20008000000ULL, 0x000000164300720cULL, 0x000fe20003f06070ULL,
0x0000000810447981ULL, 0x000562000c1e9500ULL, 0x00000051340f7211ULL, 0x002fe400078fe0ffULL,
0x00000005433c7e46ULL, 0x000fe4000b800046ULL, 0x000000ff12127207ULL, 0x000fe20000800000ULL,
0x000000020f0e7825ULL, 0x000fe200078e000cULL, 0x000000ff3c3c7207ULL, 0x000fc40000000000ULL,
0x0000005334137211ULL, 0x000fe200078fe0ffULL, 0x0000000151117824ULL, 0x004fe200078e0212ULL,
0x00000005473e7e46ULL, 0x000fe2000b800046ULL, 0x000000080e387981ULL, 0x0002a2000c1e9500ULL,
0x0000000112157824ULL, 0x000fe200078e0253ULL, 0x000000164700720cULL, 0x000fe40003f26070ULL,
0x0000003017477812ULL, 0x000fe200078efcffULL, 0x0000000211107825ULL, 0x000fe200078e000cULL,
0x00000004ff3e7819ULL, 0x000fe4000001163eULL, 0x000000513c0f7211ULL, 0x002fe200078fe0ffULL,
0x0000000213127825ULL, 0x100fe200078e000cULL, 0x000000ff3e407207ULL, 0x000fe20000800000ULL,
0x00000008103f7981ULL, 0x000ea4000c1e9500ULL, 0x0000000215147825ULL, 0x000fc400078e000cULL,
0x00000008123a7981ULL, 0x0002a4000c1e9500ULL, 0x000000020f0e7825ULL, 0x000fe400078e000cULL,
0x0000000814457981ULL, 0x0002a4000c1e9500ULL, 0x0000000647557c36ULL, 0x000fe40008000000ULL,
0x000000080e3e7981ULL, 0x0002a2000c1e9500ULL, 0x0000000b47497c36ULL, 0x000fe20008000000ULL,
0x000000533c137211ULL, 0x002fe200078fe0ffULL, 0x0000000151117824ULL, 0x000fc400078e0240ULL,
0x0000000140157824ULL, 0x000fe200078e0253ULL, 0x00000005550e7e46ULL, 0x000fc6000b800046ULL,
0x0000000215147825ULL, 0x100fe200078e000cULL, 0x000000164900720cULL, 0x080fe40003f06070ULL,
0x0000000549467e46ULL, 0x000fe2000b800046ULL, 0x0000000211107825ULL, 0x000fe200078e000cULL,
0x000000165500720cULL, 0x000fe20003f26070ULL, 0x0000000814157981ULL, 0x000ea2000c1e9500ULL,
0x00000004ff0e7819ULL, 0x000fe2000001160eULL, 0x0000000213127825ULL, 0x000fe200078e000cULL,
0x000000ff46467207ULL, 0x000fe20000000000ULL, 0x00000008104b7981ULL, 0x0002a2000c1e9500ULL,
0x000000ff0e4a7207ULL, 0x000fc60000800000ULL, 0x0000000812407981ULL, 0x0002a2000c1e9500ULL,
0x00000051460f7211ULL, 0x000fe200078fe0ffULL, 0x0000000151117824ULL, 0x002fc800078e024aULL,
0x000000020f0e7825ULL, 0x000fc800078e000cULL, 0x0000000211107825ULL, 0x000fe200078e000cULL,
0x0000005346137211ULL, 0x000fe200078fe0ffULL, 0x000000080e0e7981ULL, 0x0002a8000c1e9500ULL,
0x0000000810117981ULL, 0x000ea2000c1e9500ULL, 0x000000014a517824ULL, 0x000fe400078e0253ULL,
0x0000000213127825ULL, 0x000fc800078e000cULL, 0x00000002510c7825ULL, 0x000fe400078e000cULL,
0x0000000812127981ULL, 0x0002a8000c1e9500ULL, 0x000000080c0d7981ULL, 0x0002a2000c1e9500ULL,
0xfffffff042517812ULL, 0x000fe200078ec0ffULL, 0x00000001ff147424ULL, 0x000fc800078e00ffULL,
0x0000000116427824ULL, 0x000fc800078e0251ULL, 0x0000000139577824ULL, 0x000fe200078e0a42ULL,
0x0000000817557812ULL, 0x040fe400078efcffULL, 0x0000000917537812ULL, 0x040fe400078efcffULL,
0x0000005714577219ULL, 0x000fe400000006ffULL, 0x00000001170f7812ULL, 0x002fe200078efcffULL,
0x0000000b53137c36ULL, 0x000fc80008000000ULL, 0x0000000b0f517c36ULL, 0x000fe40008000000ULL,
0x00000001135d7824ULL, 0x100fe400078e0a42ULL, 0x0000000151597824ULL, 0x000fe200078e0a42ULL,
0x00000018176d7812ULL, 0x000fe400078efcffULL, 0xfffffff034797812ULL, 0x000fe400078ec0ffULL,
0x0000005d145d7219ULL, 0x040fe400000006ffULL, 0x0000005914597219ULL, 0x000fc400000006ffULL,
0xfffffff03c3c7812ULL, 0x000fe200078ec0ffULL, 0x0000000b6d757c36ULL, 0x000fe20008000000ULL,
0x0000001117717812ULL, 0x040fe200078efcffULL, 0x00000001160c7824ULL, 0x000fe200078e0279ULL,
0x00000019176b7812ULL, 0x000fc600078efcffULL, 0x0000000b71777c36ULL, 0x000fe40008000000ULL,
0x0000000b6b737c36ULL, 0x000fe40008000000ULL, 0x000000013b107824ULL, 0x100fe400078e0a0cULL,
0x0000000177347824ULL, 0x000fe200078e0a0cULL, 0xfffffff046467812ULL, 0x000fca00078ec0ffULL,
0x00000001164c7824ULL, 0x000fe200078e0246ULL, 0x0000002117617812ULL, 0x040fe400078efcffULL,
0x00000028175f7812ULL, 0x000fc600078efcffULL, 0x0000000b61677c36ULL, 0x000fe40008000000ULL,
0x0000000b5f657c36ULL, 0x000fe40008000000ULL, 0x00000001494e7824ULL, 0x000fca00078e0a4cULL,
0x0000004e144e7219ULL, 0x000fe400000006ffULL, 0x0000541048487816ULL, 0x008fe2000000004fULL,
0x0000000b554f7c36ULL, 0x000fc60008000000ULL, 0x0000004857ff7212ULL, 0x000fe2000780c0ffULL,
0x000000014f5b7824ULL, 0x000fc600078e0a42ULL, 0x000000163900720cULL, 0x080fe40000701470ULL,
0x0000005b145b7219ULL, 0x000fe400000006ffULL, 0x000000161700720cULL, 0x000fe400007a1070ULL,
0x0000541044447816ULL, 0x020fe4000000004dULL, 0xff80000005057808ULL, 0x000fe40002800000ULL,
0x0000004457ff7212ULL, 0x000fc4000784c0ffULL, 0x000000445bff7212ULL, 0x080fe400078cc0ffULL,
0x000000445dff7212ULL, 0x080fe400078ac0ffULL, 0x0000004459ff7212ULL, 0x000fe2000780c0ffULL,
0x0000000116447824ULL, 0x000fe200078e023cULL, 0x000000163900720cULL, 0x080fe20001741470ULL,
0x00000001753c7824ULL, 0x100fe200078e0a0cULL, 0x000000164f00720cULL, 0x080fe400037c1470ULL,
0x000000161300720cULL, 0x080fe20002fa1470ULL, 0x0000000173427824ULL, 0x000fe200078e0a0cULL,
0x000000161700720cULL, 0x000fc40001741070ULL, 0x000000165500720cULL, 0x080fe400037c1070ULL,
0x000000165300720cULL, 0x000fe40002fa1070ULL, 0x00000010140c7219ULL, 0x040fe400000006ffULL,
0x0000003c143c7219ULL, 0x000fe400000006ffULL, 0x00005410383f7816ULL, 0x004fe4000000003fULL,
0xff80000036367808ULL, 0x000fc40001000000ULL, 0x000054103a457816ULL, 0x000fe40000000045ULL,
0xff80000032327808ULL, 0x000fe40003000000ULL, 0xff80000033337808ULL, 0x000fe40002800000ULL,
0x0000004859ff7212ULL, 0x080fe4000782c0ffULL, 0x000000485bff7212ULL, 0x080fe4000786c0ffULL,
0x000000485dff7212ULL, 0x000fc4000788c0ffULL, 0x0000003f0cff7212ULL, 0x040fe4000784c0ffULL,
0x000000450cff7212ULL, 0x080fe400078cc0ffULL, 0x000000453cff7212ULL, 0x000fe200078ac0ffULL,
0x0000000143467824ULL, 0x000fe200078e0a44ULL, 0x000000165100720cULL, 0x0c0fe40000f21470ULL,
0x000000165100720cULL, 0x080fe40000701470ULL, 0x000000164f00720cULL, 0x000fc40001f61470ULL,
0x000000161300720cULL, 0x080fe40002781470ULL, 0x000000163b00720cULL, 0x0c0fe40001741470ULL,
0x000000163b00720cULL, 0x080fe400037c1470ULL, 0x000000167500720cULL, 0x080fe40002fa1470ULL,
0x00000029175d7812ULL, 0x000fe400078efcffULL, 0x000000160f00720cULL, 0x000fc40000f21070ULL,
0x000000160f00720cULL, 0x080fe40000701070ULL, 0x000000165500720cULL, 0x080fe40001f61070ULL,
0x000000165300720cULL, 0x080fe40002781070ULL, 0x000000163d00720cULL, 0x0c0fe40001741070ULL,
0x000000163d00720cULL, 0x080fe400037c1070ULL, 0x000000166d00720cULL, 0x000fc40002fa1070ULL,
0x0000003414107219ULL, 0x040fe400000006ffULL, 0x0000004214427219ULL, 0x040fe400000006ffULL,
0x0000004614467219ULL, 0x000fe400000006ffULL, 0x000054103e3e7816ULL, 0x000fe4000000004bULL,
0x0000541040157816ULL, 0x000fe20000000015ULL, 0x0000000b5d637c36ULL, 0x000fe20008000000ULL,
0xff80000035357808ULL, 0x000fc40000800000ULL, 0xff80000037377808ULL, 0x000fe40000000000ULL,
0xff80000030307808ULL, 0x000fe40001800000ULL, 0xff80000031317808ULL, 0x000fe40002000000ULL,
0xff8000002c2c7808ULL, 0x000fe40001000000ULL, 0xff8000002e2e7808ULL, 0x000fe40003000000ULL,
0xff8000002a2a7808ULL, 0x000fc40002800000ULL, 0x0000003f10ff7212ULL, 0x080fe4000782c0ffULL,
0x0000003f3cff7212ULL, 0x080fe4000780c0ffULL, 0x0000003f42ff7212ULL, 0x000fe4000786c0ffULL,
0x0000004510ff7212ULL, 0x080fe4000788c0ffULL, 0x0000004542ff7212ULL, 0x000fe4000784c0ffULL,
0x0000003e46ff7212ULL, 0x000fc400078cc0ffULL, 0x0000001546ff7212ULL, 0x000fe200078ac0ffULL,
0x0000000167487824ULL, 0x100fe200078e0a44ULL, 0x000000167700720cULL, 0x080fe20000f21470ULL,
0x00000001654a7824ULL, 0x100fe200078e0a44ULL, 0x000000167700720cULL, 0x080fe20002781470ULL,
0x0000000163447824ULL, 0x000fe200078e0a44ULL, 0x000000167500720cULL, 0x080fe40000701470ULL,
0x000000167300720cULL, 0x0c0fe40001f61470ULL, 0x000000167300720cULL, 0x000fc40001741470ULL,
0x000000164300720cULL, 0x0c0fe400037c1470ULL, 0x000000164300720cULL, 0x080fe40002fa1470ULL,
0x0000003117597812ULL, 0x040fe400078efcffULL, 0x0000003817577812ULL, 0x040fe400078efcffULL,
0x00000039174d7812ULL, 0x000fe400078efcffULL, 0x000000167100720cULL, 0x000fc40000f21070ULL,
0x000000167100720cULL, 0x080fe40002781070ULL, 0x000000166d00720cULL, 0x080fe40000701070ULL,
0x000000166b00720cULL, 0x0c0fe40001f61070ULL, 0x000000166b00720cULL, 0x080fe40001741070ULL,
0x000000164100720cULL, 0x0c0fe400037c1070ULL, 0x000000164100720cULL, 0x000fc40002fa1070ULL,
0x0000004814487219ULL, 0x040fe400000006ffULL, 0x0000004a144a7219ULL, 0x040fe400000006ffULL,
0x0000004414447219ULL, 0x000fe400000006ffULL, 0x000054100e0e7816ULL, 0x000fe20000000011ULL,
0x0000000b595b7c36ULL, 0x000fe20008000000ULL, 0xff8000002d2d7808ULL, 0x000fe20000800000ULL,
0x0000000b57697c36ULL, 0x000fe20008000000ULL, 0xff8000002f2f7808ULL, 0x000fe20002000000ULL,
0x0000000b4d797c36ULL, 0x000fe20008000000ULL, 0xff80000028287808ULL, 0x000fc40000000000ULL,
0xff80000029297808ULL, 0x000fe40001800000ULL, 0xff8000002b2b7808ULL, 0x000fe40001000000ULL,
0xff80000024247808ULL, 0x000fe40003000000ULL, 0xff80000026267808ULL, 0x000fe40002800000ULL,
0x0000003e48ff7212ULL, 0x080fe4000782c0ffULL, 0x0000003e4aff7212ULL, 0x000fc4000788c0ffULL,
0x0000003e44ff7212ULL, 0x000fe4000780c0ffULL, 0x0000001548ff7212ULL, 0x080fe4000786c0ffULL,
0x000000154aff7212ULL, 0x080fe4000784c0ffULL, 0x0000001544ff7212ULL, 0x000fe400078cc0ffULL,
0x0000000e4eff7212ULL, 0x000fe200078ac0ffULL, 0x000000015b507824ULL, 0x100fe200078e0a4cULL,
0x000000166700720cULL, 0x080fe20000f21470ULL, 0x0000000169527824ULL, 0x100fe200078e0a4cULL,
0x000000166700720cULL, 0x080fe20001f61470ULL, 0x00000001794c7824ULL, 0x000fe200078e0a4cULL,
0x000000166500720cULL, 0x000fc40002781470ULL, 0x000000166500720cULL, 0x080fe40001741470ULL,
0x000000166300720cULL, 0x0c0fe40000701470ULL, 0x000000166300720cULL, 0x080fe400037c1470ULL,
0x000000164900720cULL, 0x080fe40002fa1470ULL, 0x000000166100720cULL, 0x0c0fe40000f21070ULL,
0x000000166100720cULL, 0x000fc40001f61070ULL, 0x000000165f00720cULL, 0x0c0fe40002781070ULL,
0x000000165f00720cULL, 0x080fe40001741070ULL, 0x000000165d00720cULL, 0x0c0fe40000701070ULL,
0x000000165d00720cULL, 0x080fe400037c1070ULL, 0x000000164700720cULL, 0x000fe40002fa1070ULL,
0x0000005014507219ULL, 0x000fc400000006ffULL, 0x0000005214527219ULL, 0x040fe400000006ffULL,
0x0000004c144c7219ULL, 0x000fe400000006ffULL, 0x00005410120d7816ULL, 0x000fe4000000000dULL,
0xff80000025257808ULL, 0x000fe40000800000ULL, 0xff80000027277808ULL, 0x000fe40001800000ULL,
0xff80000020207808ULL, 0x000fc40002000000ULL, 0xff80000022227808ULL, 0x000fe40001000000ULL,
0xff80000021217808ULL, 0x000fe40000000000ULL, 0xff80000023237808ULL, 0x000fe40003000000ULL,
0xff8000001c1c7808ULL, 0x000fe40002800000ULL, 0x0000000e50ff7212ULL, 0x080fe4000782c0ffULL,
0x0000000e52ff7212ULL, 0x000fc4000786c0ffULL, 0x0000000e4cff7212ULL, 0x000fe4000788c0ffULL,
0x0000000d4eff7212ULL, 0x080fe4000784c0ffULL, 0x0000000d50ff7212ULL, 0x080fe4000780c0ffULL,
0x0000000d52ff7212ULL, 0x080fe400078cc0ffULL, 0x0000000d4cff7212ULL, 0x000fe400078ac0ffULL,
0x000000164900720cULL, 0x000fc40001741470ULL, 0x000000165b00720cULL, 0x0c0fe40000f21470ULL,
0x000000165b00720cULL, 0x080fe40000701470ULL, 0x000000166900720cULL, 0x0c0fe40001f61470ULL,
0x000000166900720cULL, 0x080fe400037c1470ULL, 0x000000167900720cULL, 0x0c0fe40002781470ULL,
0x000000167900720cULL, 0x000fc40002fa1470ULL, 0x000000164700720cULL, 0x080fe40001741070ULL,
0x000000165900720cULL, 0x0c0fe40000f21070ULL, 0x000000165900720cULL, 0x080fe40000701070ULL,
0x000000165700720cULL, 0x0c0fe40001f61070ULL, 0x000000165700720cULL, 0x080fe400037c1070ULL,
0x000000164d00720cULL, 0x000fc40002781070ULL, 0x000000164d00720cULL, 0x000fe40002fa1070ULL,
0xff8000001d1d7808ULL, 0x000fe40000800000ULL, 0xff8000001a1a7808ULL, 0x000fe40001800000ULL,
0xff8000001b1b7808ULL, 0x000fe40002000000ULL, 0xff8000001e1e7808ULL, 0x000fe40001000000ULL,
0xff8000001f1f7808ULL, 0x000fc40000000000ULL, 0xff80000018187808ULL, 0x000fe40003000000ULL,
0xff80000019197808ULL, 0x000fce0002800000ULL, 0x000000050800720bULL, 0x004fe20003f1e000ULL,
0x0000000164647836ULL, 0x000fe20000000000ULL, 0xfffffff8ff067812ULL, 0x000fe400078ee206ULL,
0x0000000805087208ULL, 0x000fc80004000000ULL, 0x000000350800720bULL, 0x000fc80003f1e000ULL,
0x00000008350d7208ULL, 0x000fc80004000000ULL, 0x000000300d00720bULL, 0x000fc80003f1e000ULL,
0x0000000d30087208ULL, 0x000fc80004000000ULL, 0x000000310800720bULL, 0x000fc80003f1e000ULL,
0x00000008310d7208ULL, 0x000fc80004000000ULL, 0x0000002c0d00720bULL, 0x000fc80003f1e000ULL,
0x0000000d2c087208ULL, 0x000fc80004000000ULL, 0x0000002d0800720bULL, 0x000fc80003f1e000ULL,
0x000000082d0d7208ULL, 0x000fc80004000000ULL, 0x000000280d00720bULL, 0x000fc80003f1e000ULL,
0x0000000d28087208ULL, 0x000fc80004000000ULL, 0x000000290800720bULL, 0x000fc80003f1e000ULL,
0x00000008290d7208ULL, 0x000fc80004000000ULL, 0x000000240d00720bULL, 0x000fc80003f1e000ULL,
0x0000000d24087208ULL, 0x000fc80004000000ULL, 0x000000250800720bULL, 0x000fc80003f1e000ULL,
0x00000008250d7208ULL, 0x000fc80004000000ULL, 0x000000200d00720bULL, 0x000fc80003f1e000ULL,
0x0000000d20087208ULL, 0x000fe40004000000ULL, 0x000000360900720bULL, 0x000fe40003f1e000ULL,
0x000000210800720bULL, 0x000fc80003f3e000ULL, 0x00000008210d7208ULL, 0x000fe40004800000ULL,
0x0000000936087208ULL, 0x000fe40004000000ULL, 0x0000001c0d00720bULL, 0x000fe40003f3e000ULL,
0x000000370800720bULL, 0x000fe40003f1e000ULL, 0x0000000d1c0c7208ULL, 0x000fe40004800000ULL,
0x0000000837097208ULL, 0x000fc40004000000ULL, 0x0000001d0c00720bULL, 0x000fe40003f3e000ULL,
0x000000320900720bULL, 0x000fe40003f1e000ULL, 0x0000000c1d0d7208ULL, 0x000fe40004800000ULL,
0x0000000932087208ULL, 0x000fe40004000000ULL, 0x0000001a0d00720bULL, 0x000fe40003f3e000ULL,
0x000000330800720bULL, 0x000fc40003f1e000ULL, 0x0000000d1a0c7208ULL, 0x000fe40004800000ULL,
0x0000000833097208ULL, 0x000fe40004000000ULL, 0x0000001b0c00720bULL, 0x000fe40003f3e000ULL,
0x0000002e0900720bULL, 0x000fe40003f1e000ULL, 0x0000000c1b0c7208ULL, 0x000fe40004800000ULL,
0x000000092e087208ULL, 0x000fc60004000000ULL, 0x0c401f000c0d7f89ULL, 0x000e6200000e0000ULL,
0x0000002f0800720bULL, 0x000fc80003f1e000ULL, 0x000000082f097208ULL, 0x000fc80004000000ULL,
0x0000002a0900720bULL, 0x000fc80003f1e000ULL, 0x000000092a087208ULL, 0x000fc80004000000ULL,
0x0000002b0800720bULL, 0x000fc80003f1e000ULL, 0x000000082b097208ULL, 0x000fe40004000000ULL,
0x0000000d0c00720bULL, 0x002fe40003f3e000ULL, 0x000000260900720bULL, 0x000fe40003f1e000ULL,
0x0000000c0d0d7208ULL, 0x000fe40004800000ULL, 0x0000000926087208ULL, 0x000fc60004000000ULL,
0x0c201f000d0c7f89ULL, 0x000e6200000e0000ULL, 0x000000270800720bULL, 0x000fc80003f1e000ULL,
0x0000000827097208ULL, 0x000fc80004000000ULL, 0x000000220900720bULL, 0x000fc80003f1e000ULL,
0x0000000922087208ULL, 0x000fc80004000000ULL, 0x000000230800720bULL, 0x000fc80003f1e000ULL,
0x0000000823097208ULL, 0x000fe40004000000ULL, 0x0000000c0d00720bULL, 0x002fe40003f3e000ULL,
0x0000001e0900720bULL, 0x000fe40003f1e000ULL, 0x0000000d0c087208ULL, 0x000fe40004800000ULL,
0x000000091e0c7208ULL, 0x000fc60004000000ULL, 0x3fb8aa3b080e7820ULL, 0x000fe20000410000ULL,
0x0000001f0c00720bULL, 0x000fc60003f1e000ULL, 0x3fb8aa3b05097823ULL, 0x100fe2000001080eULL,
0x0000000c1f057208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b30307823ULL, 0x100fe2000001080eULL,
0x3fb8aa3b31317823ULL, 0x100fe2000001080eULL, 0x00000009000d7308ULL, 0x000fe20000000800ULL,
0x000000180500720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b35357823ULL, 0x100fe2000001080eULL,
0x3fb8aa3b28287823ULL, 0x100fe2000001080eULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe2000001080eULL,
0x00000005180c7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe2000001080eULL,
0x3fb8aa3b29297823ULL, 0x100fe2000001080eULL, 0x0000003500107308ULL, 0x000fe20000000800ULL,
0x000000190c00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b24247823ULL, 0x100fe2000001080eULL,
0x3fb8aa3b25257823ULL, 0x100fe2000001080eULL, 0x3fb8aa3b20207823ULL, 0x100fe2000001080eULL,
0x0000000c190c7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b21217823ULL, 0x100fe2000001080eULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe2000001080eULL, 0x0000003000307308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe2000001080eULL, 0x0c401f000c057f89ULL, 0x000e6200000e0000ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe2000001080eULL, 0x3fb8aa3b1b0e7823ULL, 0x000fc8000001080eULL,
0x0000003100317308ULL, 0x000eb00000000800ULL, 0x0000002800167308ULL, 0x000ff00000000800ULL,
0x0000002000287308ULL, 0x0007e20000000800ULL, 0x000000050c00720bULL, 0x002fc80003f1e000ULL,
0x0000000c05057208ULL, 0x000fc60004000000ULL, 0x0000002100357308ULL, 0x0003e20000000800ULL,
0x3c003c00ff207424ULL, 0x008fe200078e00ffULL, 0x0c201f00050c7f89ULL, 0x000eec00000e0000ULL,
0x0000000e001b7308ULL, 0x0005e20000000800ULL, 0x3c003c00ff217424ULL, 0x002fce00078e00ffULL,
0x0000002c00147308ULL, 0x000fe20000000800ULL, 0x00000030310e723eULL, 0x004fce00000000ffULL,
0x0000001c002c7308ULL, 0x000fe20000000800ULL, 0x0000000c0500720bULL, 0x008fc80003f1e000ULL,
0x000000050c097208ULL, 0x000fc60004000000ULL, 0x0000001a00347308ULL, 0x000fe20000000800ULL,
0x0000000d100c723eULL, 0x000fe200000000ffULL, 0x0c401f000a057f89ULL, 0x000e6200000e0000ULL,
0x3fb8aa3b09387820ULL, 0x000fc80000410000ULL, 0x3fb8aa3b36367823ULL, 0x100fe20000010838ULL,
0x3fb8aa3b37377823ULL, 0x100fe20000010838ULL, 0x3fb8aa3b32327823ULL, 0x100fe20000010838ULL,
0x3fb8aa3b33337823ULL, 0x100fe20000010838ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe20000010838ULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe20000010838ULL, 0x0000003600367308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe20000010838ULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe20000010838ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010838ULL, 0x3fb8aa3b27277823ULL, 0x100fe20000010838ULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010838ULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010838ULL,
0x3fb8aa3b18187823ULL, 0x000fe20000010838ULL, 0x0000003700377308ULL, 0x000ea20000000800ULL,
0x000000050a00720bULL, 0x002fce0003f1e000ULL, 0x00000032000f7308ULL, 0x000fe20000000800ULL,
0x0000000a050a7208ULL, 0x000fe40004000000ULL, 0x00000003ff057819ULL, 0x000fe40000011602ULL,
0x00000036370d723eULL, 0x004fc600000000ffULL, 0x0000003300127308ULL, 0x000e620000000800ULL,
0x0000000305057812ULL, 0x000fce00078ec0ffULL, 0x0000002d002d7308ULL, 0x000ea20000000800ULL,
0x0000000f120f723eULL, 0x002fce00000000ffULL, 0x0000002900297308ULL, 0x000e620000000800ULL,
0x000000200c10723cULL, 0x000fe200000018ffULL, 0x000000142d14723eULL, 0x004fcc00000000ffULL,
0x0000002e00157308ULL, 0x000fe20000000800ULL, 0x000000162916723eULL, 0x002fce00000000ffULL,
0x0000002f001a7308ULL, 0x000e620000000800ULL, 0x3fb8aa3b1e297823ULL, 0x000fce0000010838ULL,
0x0000002a00177308ULL, 0x0005e20000000800ULL, 0x000000151a15723eULL, 0x002fce00000000ffULL,
0x0000002b001c7308ULL, 0x000e620000000800ULL, 0x3fb8aa3b1f2a7823ULL, 0x104fe20000010838ULL,
0x0c401f000b1a7f89ULL, 0x000ea200000e0000ULL, 0x3fb8aa3b19387823ULL, 0x000fca0000010838ULL,
0x0000001d00397308ULL, 0x0007e20000000800ULL, 0x000000171c17723eULL, 0x002fce00000000ffULL,
0x0000002400247308ULL, 0x000fe20000000800ULL, 0x00000020141c723cULL, 0x008fee0000001810ULL,
0x0000002500257308ULL, 0x000e620000000800ULL, 0x0000001a0b00720bULL, 0x004fe40003f3e000ULL,
0x000000283512723eULL, 0x000fc400000000ffULL, 0x0000000b1a0b7208ULL, 0x000fc60004800000ULL,
0x0000002600267308ULL, 0x000fe20000000800ULL, 0x000000341b1a723eULL, 0x000fe400000000ffULL,
0x000000242510723eULL, 0x002fca00000000ffULL, 0x0000002700277308ULL, 0x000e620000000800ULL,
0x0000000700247c11ULL, 0x000fce000f8e58ffULL, 0x0000002200227308ULL, 0x000fe20000000800ULL,
0x000000262711723eULL, 0x002fce00000000ffULL, 0x0000002300237308ULL, 0x000e620000000800ULL,
0x0000000806267836ULL, 0x000fc80000000000ULL, 0x0000000105277824ULL, 0x000fe400078e0226ULL,
0x0000000826287824ULL, 0x000fe200078e00ffULL, 0x0000002900297308ULL, 0x000fe80000000800ULL,
0xfffffff828277812ULL, 0x000fe200078ee227ULL, 0x0001100024287836ULL, 0x000fe20000000000ULL,
0x000000222313723eULL, 0x002fe400000000ffULL, 0x0000002a002a7308ULL, 0x000e620000000800ULL,
0x0000000105227824ULL, 0x000fc400078e0206ULL, 0x0c201f000a057f89ULL, 0x000ea200000e0000ULL,
0x0000000806237824ULL, 0x000fe200078e00ffULL, 0x00000020101c723cULL, 0x000fe2000000181cULL,
0x0000000422257836ULL, 0x000fe40000000000ULL, 0x00000018002b7308ULL, 0x0007e20000000800ULL,
0xfffffff823237812ULL, 0x000fe200078ee222ULL, 0x0000000c22227836ULL, 0x000fe40000000000ULL,
0x000000ffff247224ULL, 0x000fe400078e0010ULL, 0x000000ffff107224ULL, 0x000fe200078e0011ULL,
0x000000292a19723eULL, 0x002fe200000000ffULL, 0x0000003800387308ULL, 0x000e620000000800ULL,
0x0000002c3918723eULL, 0x008fe200000000ffULL, 0x00000008062a7824ULL, 0x000fc400078e00ffULL,
0x0c201f000b067f89ULL, 0x000ee200000e0000ULL, 0x0000001027297824ULL, 0x000fe400078e0228ULL,
0xfffffff82a257812ULL, 0x000fe200078ee225ULL, 0x000000ffff277224ULL, 0x000fe400078e001aULL,
0x000000ffff117224ULL, 0x000fe200078e0013ULL, 0x000000050a00720bULL, 0x004fe40003f1e000ULL,
0x0000002b381b723eULL, 0x002fe200000000ffULL, 0x00000008262b7824ULL, 0x000fe200078e00ffULL,
0x0000000a050a7208ULL, 0x000fe20004000000ULL, 0x000000ffff267224ULL, 0x000fe200078e0018ULL,
0x0000000302ff7812ULL, 0x000fe2000780c0ffULL, 0x000000ffff137224ULL, 0x000fe200078e001bULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee222ULL, 0x00000020181c723cULL, 0x000fe2000000181cULL,
0x000000ffff227224ULL, 0x000fc400078e0014ULL, 0x000000ffff057224ULL, 0x000fe400078e006eULL,
0x000000102b2b7824ULL, 0x000fe200078e0228ULL, 0x000000060b00720bULL, 0x008fe20003f3e000ULL,
0x000000ffff207224ULL, 0x000fe400078e000cULL, 0x000000ffff217224ULL, 0x000fe200078e000eULL,
0x0000000b060b7208ULL, 0x000fe20004800000ULL, 0x000000ffff0c7224ULL, 0x000fe400078e000dULL,
0x000000ffff0d7224ULL, 0x000fc400078e000fULL, 0x000000ffff0e7224ULL, 0x000fe400078e0015ULL,
0x000000ffff0f7224ULL, 0x000fe400078e0017ULL, 0x00000001ff067424ULL, 0x000fe400078e00ffULL,
0x00000010231d7824ULL, 0x000fe400078e0228ULL, 0x000000ffff237224ULL, 0x000fe400078e0016ULL,
0x00000010251f7824ULL, 0x000fc400078e0228ULL, 0x000000ffff257224ULL, 0x000fe200078e0012ULL,
0x000000201d007844ULL, 0x0003e20000000200ULL, 0x000000ffff127224ULL, 0x000fc600078e0019ULL,
0x000000241f007844ULL, 0x0005e80000000200ULL, 0x0000000c29007844ULL, 0x0005e80000000200ULL,
0x000000102b007844ULL, 0x0005e20000000200ULL, 0x000000ffff1d7224ULL, 0x002fc600078e001eULL,
0x0170000807008388ULL, 0x0005e80000000c00ULL, 0x0172001c07008388ULL, 0x0005e20000000a00ULL,
0x0000007b6400720cULL, 0x000fe20003f06070ULL, 0x017608066fff79a7ULL, 0x0005e2000850003fULL,
0x017610066fff79a7ULL, 0x0005e2000850003fULL, 0x017618066fff79a7ULL, 0x0005e2000850003fULL,
0x017620066fff79a7ULL, 0x0005f2000850003fULL, 0xffffffac00dc8947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0180000016007836ULL, 0x000fe20000000000ULL,
0x0000013000017945ULL, 0x000fe80003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000001600008308ULL, 0x0002a20000001000ULL,
0x0000000000388947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x007fffff16ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000016027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000000000047947ULL, 0x000fec0003800000ULL,
0x0000001600007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffffed402bc7950ULL, 0x000fea0003c3ffffULL, 0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000004ULL, 0x0000000100000001ULL, 0x0000001000000008ULL, 0x0000000400000001ULL,
0x0000000800000008ULL, 0x0000000800000001ULL, 0x0000000100000001ULL, 0x0000000400000003ULL,
0x0000000300000004ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x0000000000000111ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000017bULL,
0x0000000000000577ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000006f8ULL,
0x0000000000000258ULL, 0x0000001700000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000950ULL,
0x00000000000000e0ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000a30ULL,
0x0000000000000054ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000a84ULL,
0x0000000000000660ULL, 0x0000000a00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000004000000b2ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000010e8ULL,
0x0000000000000000ULL, 0x0000000a00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000004000000e6ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000010e8ULL,
0x0000000000000048ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001130ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001180ULL,
0x0000000000012a00ULL, 0x0000001700000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000013b80ULL,
0x0000000000000048ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000013bd0ULL,
0x0000000000000400ULL, 0x0000000a00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x00000001000000f8ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000013bd0ULL,
0x0000000000000270ULL, 0x0000000a00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000400000006ULL, 0x00000000000141c0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x00000000000141c0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000001130ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001180ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000012a00ULL, 0x0000000000012a00ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000013b80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000450ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x0000000000013bd0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000270ULL,
0x0000000000000270ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_pagedKV_128_nqpkv_0_m_16_sm_90_cubin_len = 82704;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
