/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_pagedKV_128_nqpkv_0_m_32_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000018f40ULL, 0x0000000000018bc0ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6c61685f5f374944ULL, 0x6a4c45346a4c3266ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL,
0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL, 0x454536316a4c4532ULL,
0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x34366a4c4545346aULL,
0x61324545346a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL, 0x614d6e4974736e49ULL,
0x6a4c45326a4c4974ULL, 0x4c45326a4c454532ULL, 0x497461324545316aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL, 0x316a4c45326a4c45ULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL,
0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL,
0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL,
0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL, 0x61324545316a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x2400676e6964696cULL, 0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL,
0x6e725f7063725f30ULL, 0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x746e695f5f240068ULL,
0x5f315f6c616e7265ULL, 0x5f616475635f5f24ULL, 0x6668735f30376d73ULL, 0x66625f636e79736cULL,
0x5f5f2400705f796cULL, 0x6c616e7265746e69ULL, 0x75635f5f245f325fULL, 0x5f30376d735f6164ULL,
0x636e79736c666873ULL, 0x2400705f7864695fULL, 0x6e7265746e695f5fULL, 0x5f5f245f335f6c61ULL,
0x376d735f61647563ULL, 0x797365746f765f30ULL, 0x6f6c6c61625f636eULL, 0x2e616c65722e0074ULL,
0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x7865742e6c65722eULL, 0x6c656e72656b2e74ULL,
0x656b240061686d5fULL, 0x61686d5f6c656e72ULL, 0x7479426d656d7324ULL, 0x766e2e0066754265ULL,
0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL, 0x705f0061686d5f6cULL, 0x65642e006d617261ULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x00000000006e6f69ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b1ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL, 0x0000000000000030ULL,
0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000c000100000131ULL, 0x0000000000000020ULL, 0x0000000000000004ULL, 0x000c000100000178ULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000001baULL, 0x000000000000002cULL,
0x0000000000000004ULL, 0x000c000100000200ULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000c000100000247ULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c00010000028dULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000002dbULL, 0x0000000000000028ULL,
0x0000000000000004ULL, 0x000c000100000329ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c000100000377ULL, 0x000000000000001cULL, 0x0000000000000004ULL, 0x000c0001000003c5ULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b00220000040bULL, 0x0000000000016fa0ULL,
0x0000000000000180ULL, 0x000b00220000043eULL, 0x0000000000017120ULL, 0x0000000000000040ULL,
0x000b002200000469ULL, 0x0000000000017160ULL, 0x0000000000000050ULL, 0x000b002200000493ULL,
0x00000000000171b0ULL, 0x0000000000000150ULL, 0x000a000300000501ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0004000300000521ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0007000300000551ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL,
0x0000000000000000ULL, 0x0000000000017300ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00016fa000000000ULL,
0x0000040400000000ULL, 0x810c000001640400ULL, 0x005a780400288080ULL, 0x0000000000000000ULL,
0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x0022002880808492ULL, 0x0000002cffffffffULL, 0x0000007000000000ULL, 0x00016fa000000000ULL,
0x0000018000000000ULL, 0x0000580400000000ULL, 0x8082288080840900ULL, 0x0000000000002880ULL,
0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8708288080830828ULL, 0x2880808c08288080ULL,
0x808e082880808d08ULL, 0x082880808f082880ULL, 0x8080a308288080a2ULL, 0xa808288080a50828ULL,
0x288080aa08288080ULL, 0x80f108288080c508ULL, 0x08288080f2082880ULL, 0x8082801628808088ULL,
0x0000000000031028ULL, 0x2880808892000000ULL, 0x0000000000002200ULL, 0x0000001cffffffffULL,
0x000000f000000000ULL, 0x0001712000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8808288080830828ULL, 0x2880808c08288080ULL,
0x808e082880808d08ULL, 0x082880808f082880ULL, 0x8080a308288080a2ULL, 0xa908288080a50828ULL,
0x288080aa08288080ULL, 0x80f108288080c508ULL, 0x08288080f2082880ULL, 0x80828016288080a8ULL,
0x0000000000031028ULL, 0x288080a892000000ULL, 0x0000000000002200ULL, 0x0000002cffffffffULL,
0x000001b000000000ULL, 0x0001716000000000ULL, 0x0000005000000000ULL, 0x0000100400000000ULL,
0x80aa288080a80900ULL, 0x0000000000002880ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL,
0x8808288080830828ULL, 0x2880808c08288080ULL, 0x808e082880808d08ULL, 0x082880808f082880ULL,
0x8080a308288080a2ULL, 0xa808288080a50828ULL, 0x288080aa08288080ULL, 0x80f108288080c508ULL,
0x08288080f2082880ULL, 0x80828016288080a9ULL, 0x0000000000031028ULL, 0x288080a992000000ULL,
0x0000000000002200ULL, 0x0000002cffffffffULL, 0x0000028000000000ULL, 0x000171b000000000ULL,
0x0000015000000000ULL, 0x0000080400000000ULL, 0x80aa288080a90900ULL, 0x0000000000002880ULL,
0x0000001900082f04ULL, 0x00082304000000deULL, 0x0000000000000015ULL, 0x0000001500081204ULL,
0x0008110400000000ULL, 0x0000000000000015ULL, 0x0000001400082304ULL, 0x0008120400000000ULL,
0x0000000000000014ULL, 0x0000001400081104ULL, 0x0008230400000000ULL, 0x0000000000000013ULL,
0x0000001300081204ULL, 0x0008110400000000ULL, 0x0000000000000013ULL, 0x0000001200082304ULL,
0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008230400000000ULL,
0x0000000000000019ULL, 0x0000001900081204ULL, 0x0008110400000000ULL, 0x0000000000000019ULL,
0x0000007b00043704ULL, 0x0000001600080a04ULL, 0x0060190300600160ULL, 0x00000000000c1704ULL,
0x0021f00000580009ULL, 0x00000000000c1704ULL, 0x0021f00000500008ULL, 0x00000000000c1704ULL,
0x0011f00000480007ULL, 0x00000000000c1704ULL, 0x0081f00000280006ULL, 0x00000000000c1704ULL,
0x0021f00000200005ULL, 0x00000000000c1704ULL, 0x0021f00000180004ULL, 0x00000000000c1704ULL,
0x0021f00000100003ULL, 0x00000000000c1704ULL, 0x0011f00000080002ULL, 0x00000000000c1704ULL,
0x0011f00000040001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x0004310400ff1b03ULL,
0x019c290400000b00ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x019c2804ffffffffULL, 0x000002d000000100ULL, 0x000028a000000580ULL, 0x00002a6000002950ULL,
0x00002d4000002bd0ULL, 0x0000332000002ea0ULL, 0x0000337000003360ULL, 0x00005570000033a0ULL,
0x0000572000005600ULL, 0x00005a0000005890ULL, 0x00005fe000005b60ULL, 0x0000603000006020ULL,
0x0000800000006060ULL, 0x000081c0000080a0ULL, 0x000084a000008330ULL, 0x00008a6000008600ULL,
0x00008ab000008aa0ULL, 0x0000aa5000008ae0ULL, 0x0000ac000000aaf0ULL, 0x0000aee00000ad70ULL,
0x0000b4c00000b040ULL, 0x0000b5100000b500ULL, 0x0000c9b00000b540ULL, 0x0000c9d00000c9c0ULL,
0x00014cc00000c9e0ULL, 0x00014d1000014d00ULL, 0x00014d7000014d20ULL, 0x00014db000014d90ULL,
0x0001612000014dc0ULL, 0x000161c000016170ULL, 0x0001624000016200ULL, 0x000162d000016280ULL,
0x0001637000016320ULL, 0x00016410000163c0ULL, 0x000164b000016460ULL, 0x00016530000164f0ULL,
0x000165c000016570ULL, 0x0001666000016610ULL, 0x00016700000166b0ULL, 0x000167a000016750ULL,
0x00016820000167e0ULL, 0x000168b000016860ULL, 0x0001695000016900ULL, 0x000169f0000169a0ULL,
0x00016a9000016a40ULL, 0x00016b1000016ad0ULL, 0x00016ba000016b50ULL, 0x00016c4000016bf0ULL,
0x00016ce000016c90ULL, 0x00016da000016d40ULL, 0x00016e6000016e00ULL, 0x00016f2000016ec0ULL,
0x0440390400016f80ULL, 0x000000ff000003c0ULL, 0x003f010000012600ULL, 0x0000000d00000400ULL,
0x003f012000012608ULL, 0x0000000d000004f0ULL, 0x003f012000012688ULL, 0x0000000d00000510ULL,
0x003f0120000126a8ULL, 0x0000000d00000540ULL, 0x003f0120000126c8ULL, 0x000000ff00000b20ULL,
0x003f010700012600ULL, 0x0000000600000d10ULL, 0x003f010200000004ULL, 0x0000000600000dd0ULL,
0x003f010100000000ULL, 0x000000ff00001710ULL, 0x0004010700000000ULL, 0x000000ff00001790ULL,
0x0004010100000000ULL, 0x00000006000017f0ULL, 0x003f010100000020ULL, 0x00000008000019a0ULL,
0x003f0105000126ccULL, 0x0000000800001b70ULL, 0x003f0105000126ccULL, 0x0000000a00002490ULL,
0x003f0107000126b0ULL, 0x0000000a00002540ULL, 0x003f0101000126b0ULL, 0x00000022000025a0ULL,
0x003f010100012608ULL, 0x00000022000025c0ULL, 0x003f01050001260cULL, 0x0000002200002790ULL,
0x003f01050001260cULL, 0x0000000a00003050ULL, 0x003f0105000126acULL, 0x0000000a00003240ULL,
0x003f0105000126acULL, 0x0000006c00004750ULL, 0x003f010100000000ULL, 0x00000025000047b0ULL,
0x003f010100012688ULL, 0x00000014000047d0ULL, 0x003f010500000004ULL, 0x00000014000049a0ULL,
0x003f010500000004ULL, 0x0000001000005170ULL, 0x003f010700000000ULL, 0x0000001000005250ULL,
0x003f010100000000ULL, 0x00000022000052b0ULL, 0x003f010100012628ULL, 0x00000022000052d0ULL,
0x003f01050001262cULL, 0x00000022000054a0ULL, 0x003f01050001262cULL, 0x0000007000005d50ULL,
0x003f0105000126b4ULL, 0x0000007000005f20ULL, 0x003f0105000126b4ULL, 0x0000002a000071e0ULL,
0x003f010100000000ULL, 0x0000002600007240ULL, 0x003f010100012690ULL, 0x0000001400007260ULL,
0x003f010500000004ULL, 0x0000001400007430ULL, 0x003f010500000004ULL, 0x000000ff00007bf0ULL,
0x0004010700000008ULL, 0x0000002a00007ce0ULL, 0x003f0101000126b0ULL, 0x0000002200007d40ULL,
0x003f010100012648ULL, 0x0000002200007d60ULL, 0x003f01050001264cULL, 0x0000002200007f30ULL,
0x003f01050001264cULL, 0x00000010000087d0ULL, 0x003f010500000004ULL, 0x00000010000089a0ULL,
0x003f010500000004ULL, 0x0000001400009c20ULL, 0x003f010100000000ULL, 0x0000000000009c80ULL,
0x003f010100012698ULL, 0x0000001400009ca0ULL, 0x003f010500000004ULL, 0x0000001400009e70ULL,
0x003f010500000004ULL, 0x000000ff0000a6b0ULL, 0x0004010700000000ULL, 0x000000100000a740ULL,
0x003f010100000000ULL, 0x000000060000a7a0ULL, 0x003f010100012668ULL, 0x000000060000a7d0ULL,
0x003f01050001266cULL, 0x000000060000a9a0ULL, 0x003f01050001266cULL, 0x000000080000b220ULL,
0x003f0105000126b4ULL, 0x000000080000b3f0ULL, 0x003f0105000126b4ULL, 0x000000140000c760ULL,
0x003f010100000000ULL, 0x000000060000c7e0ULL, 0x003f010100000000ULL, 0x000000ff0000e550ULL,
0x003f010100012600ULL, 0x000000ff0000f160ULL, 0x003f010500012604ULL, 0x000000ff0000f330ULL,
0x003f010500012604ULL, 0x000000ff0000f6b0ULL, 0x003f010100012600ULL, 0x000000ff0000f6e0ULL,
0x003f010500012604ULL, 0x000000ff0000f8a0ULL, 0x003f010500012604ULL, 0x00000063000121a0ULL,
0x003f010100000000ULL, 0x00000063000122b0ULL, 0x003f010500000004ULL, 0x0000006300012480ULL,
0x003f010500000004ULL, 0x0000006200015f80ULL, 0x003f010100000000ULL, 0x0000006200015fe0ULL,
0x003f010100000008ULL, 0x0000006200016040ULL, 0x003f010100000010ULL, 0x00000062000160b0ULL,
0x003f010100000018ULL, 0x00301c0400053803ULL, 0x0000d9100000d8e0ULL, 0x0000dc500000daf0ULL,
0x0000df100000ddb0ULL, 0x0000e1d00000e070ULL, 0x0000e4600000e360ULL, 0x000160f00000f900ULL,
0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x000000000000032cULL, 0x0000001900000002ULL,
0x000000000000025cULL, 0x0000001900000002ULL, 0x000000000000019cULL, 0x0000001900000002ULL,
0x00000000000000ccULL, 0x0000001900000002ULL, 0x0000000000000044ULL, 0x0000001900000002ULL,
0x0000000000000303ULL, 0x0000001900000002ULL, 0x0000000000000233ULL, 0x0000001900000002ULL,
0x0000000000000173ULL, 0x0000001900000002ULL, 0x00000000000000a8ULL, 0x0000001900000002ULL,
0x0000000000012700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000590000007b06ULL, 0x000e620000209000ULL,
0x00005900ff0e7624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f45070ULL,
0x0000000000767919ULL, 0x000ea20000002600ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x00005a0000057ab9ULL, 0x000fe20000000800ULL, 0x00000000000b7919ULL, 0x000ee20000002300ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x00005a000e827a19ULL, 0x000fe200000006ffULL,
0x0000460000087ab9ULL, 0x000fe20000000a00ULL, 0x0000000000097919ULL, 0x000f220000002100ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00027810ULL, 0x002fc40007ffe0ffULL,
0x00000005ff207819ULL, 0x010fc80000011609ULL, 0x0000000200037305ULL, 0x000324000021f000ULL,
0x00001fff20207589ULL, 0x000fe200000e0000ULL, 0x000000ffff027224ULL, 0x002fe400078e00ffULL,
0x000000ffff057224ULL, 0x010fc800078e0a03ULL, 0x0000590005057a24ULL, 0x000fc800078e02ffULL,
0x0000000503037227ULL, 0x000fcc00078e0002ULL, 0x0000040003077a27ULL, 0x000fc800078e00ffULL,
0x000000ffff037224ULL, 0x000fc800078e0a07ULL, 0x0000040003007624ULL, 0x000fca00078e020eULL,
0x0000590000007a0cULL, 0x000fda0003f06070ULL, 0x8000590000000a10ULL, 0x000fe40007ffe0ffULL,
0x0000000107070810ULL, 0x000fe40007ffe0ffULL, 0x0000590000007a0cULL, 0x000fda0003f26070ULL,
0x0000000107071810ULL, 0x000fe40007ffe0ffULL, 0x00005900ff07aa12ULL, 0x000fc800078e33ffULL,
0x0000000700007306ULL, 0x000e620000209000ULL, 0x000000ff0700720cULL, 0x000fce0003f85070ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL,
0x0000000200037305ULL, 0x000324000021f000ULL, 0x000000ffff027224ULL, 0x002fe400078e00ffULL,
0x0000000307047224ULL, 0x010fc800078e02ffULL, 0x000000ffff057224ULL, 0x000fe400078e0a04ULL,
0x0000000000047919ULL, 0x000ee40000002200ULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x0000007603197227ULL, 0x004fc800078e00ffULL, 0x000000ffff007224ULL, 0x000fc800078e0a19ULL,
0x0000000007007224ULL, 0x000fca00078e0276ULL, 0x000000070000720cULL, 0x000fe20003f46070ULL,
0x000001000b027a24ULL, 0x008fe400078e0204ULL, 0x00001fff0b0b7589ULL, 0x000e6400000e0000ULL,
0x00000000020d7a24ULL, 0x000fca00078e0209ULL, 0x000000ff0d00720cULL, 0x000fc60003fa5270ULL,
0x0000000100002824ULL, 0x000fe200078e0a07ULL, 0x0000000119192810ULL, 0x000fe40007ffe0ffULL,
0x0000000f0d00780cULL, 0x040fe40003f24070ULL, 0x000000070000720cULL, 0x000fe40003f66070ULL,
0x0000007f0d00780cULL, 0x040fe40003f04070ULL, 0x000000030d00780cULL, 0x000fe20003f44070ULL,
0x3fffff80ff02d424ULL, 0x000fc400078e00ffULL, 0x7fffff80ff03d424ULL, 0x000fc800078e00ffULL,
0x3fffffc0ff049424ULL, 0x000fe400078e00ffULL, 0x0000000119193810ULL, 0x000fe20007ffe0ffULL,
0x7fffffc0ff059424ULL, 0x000fe200078e00ffULL, 0x00000007ff19c212ULL, 0x000fe200078e33ffULL,
0x01260002ff00d388ULL, 0x0005e20000000a00ULL, 0xff317217ff0a8424ULL, 0x000fe200078e00ffULL,
0x000000010d00780cULL, 0x000fe20003f64070ULL, 0x3fffff80ff06a424ULL, 0x000fe200078e00ffULL,
0x012608040d009388ULL, 0x0007e20000008a00ULL, 0x000000ffff007224ULL, 0x000fe200078e0a19ULL,
0x00005a0019757a19ULL, 0x000fc400000006ffULL, 0x0124000a0d008388ULL, 0x000fe20000004800ULL,
0x0000000007767224ULL, 0x000fe400078e0276ULL, 0x3fffff60ff02a424ULL, 0x004fe400078e00ffULL,
0x0000002076007824ULL, 0x000fe400078e00ffULL, 0x7fffff60ff03a424ULL, 0x000fe200078e00ffULL,
0x0000000000047919ULL, 0x008ea20000002700ULL, 0x7fffff80ff07a424ULL, 0x000fe200078e00ffULL,
0x0000000400057c10ULL, 0x040fe2000fffe1ffULL, 0x3fffffc0ff08b424ULL, 0x000fe200078e00ffULL,
0x0000000400007c0cULL, 0x000fe2000bf03070ULL, 0x7fffffc0ff09b424ULL, 0x000fe200078e00ffULL,
0x0000002005057817ULL, 0x000fe20003800000ULL, 0x012688020d00a388ULL, 0x0005e60000008a00ULL,
0x000000ff05747207ULL, 0x000fe20000000000ULL, 0x0126a8060d00a388ULL, 0x000fe20000008a00ULL,
0x000000040b057824ULL, 0x002fc400078e0220ULL, 0x000000207400780cULL, 0x000fe20003f05270ULL,
0x0126c8080d00b388ULL, 0x000fe20000008a00ULL, 0x0000000405057824ULL, 0x000fe400078e00ffULL,
0x0000580004027a24ULL, 0x004fc800078e02ffULL, 0x0000008202027224ULL, 0x000fe200078e0275ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000002e000008947ULL, 0x000fea0003800000ULL,
0x00000000001f7919ULL, 0x000e620000000000ULL, 0xffffffff00047882ULL, 0x000fe20000000000ULL,
0x0000000574067217ULL, 0x000fe20007800000ULL, 0x00005a0000057ab9ULL, 0x000fc40000000800ULL,
0x0000000504047299ULL, 0x000fe4000800063fULL, 0x0000000106067824ULL, 0x000fe200078e0a05ULL,
0x00000004ff037819ULL, 0x002fc8000001161fULL, 0x00000002030a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000105087824ULL, 0x000fe200078e0203ULL, 0x000000060300720cULL, 0x080fe40003f06070ULL,
0x000000060a00720cULL, 0x000fe20003f26070ULL, 0x00000001050c7824ULL, 0x000fe400078e020aULL,
0x0000000100077824ULL, 0x040fe400078e0208ULL, 0x00000001000d7824ULL, 0x000fe400078e020cULL,
0x000000101f057824ULL, 0x000fe200078e00ffULL, 0x0000000407097c12ULL, 0x000fe2000f8e30ffULL,
0x00000001080a7824ULL, 0x000fe200078e021fULL, 0x000000040d0f7c12ULL, 0x000fc4000f8e30ffULL,
0x00005a00ff077a19ULL, 0x000fe20000011607ULL, 0x0000000102097824ULL, 0x040fe200078e0209ULL,
0x00005a00ff0d7a19ULL, 0x000fe2000001160dULL, 0x00000001020f7824ULL, 0x000fe400078e020fULL,
0x0000008207027224ULL, 0x080fe200078e0209ULL, 0x000000f005097812ULL, 0x000fe200078ec0ffULL,
0x000000820d077224ULL, 0x000fe400078e020fULL, 0x0000010002027825ULL, 0x000fc800078e00ffULL,
0x0000010007067825ULL, 0x000fe200078e00ffULL, 0x0000000902027212ULL, 0x000fc600078efcffULL,
0x00000010080d7824ULL, 0x000fe200078e00ffULL, 0x0000000906067212ULL, 0x000fe200078efcffULL,
0x000000010c087824ULL, 0x000fe200078e021fULL, 0x00005e0002027a10ULL, 0x000fe20007f5e0ffULL,
0x000000100c097824ULL, 0x000fe200078e00ffULL, 0xfffffff00d0a7812ULL, 0x000fe400078ee20aULL,
0x00005e0006067a10ULL, 0x000fe40007f7e0ffULL, 0xfffffff009087812ULL, 0x000fe200078ee208ULL,
0x000000100a097824ULL, 0x000fe200078e00ffULL, 0x00005f0003037a10ULL, 0x000fc400017fe4ffULL,
0x00005f0007077a10ULL, 0x000fe20001ffe4ffULL, 0x00000010080d7824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002097faeULL, 0x0003e8000c101c48ULL,
0x00000000060d7faeULL, 0x0003e2000c901c48ULL, 0x0000027000007947ULL, 0x000fea0003800000ULL,
0x00000000001f7919ULL, 0x000e620000000000ULL, 0xffffffff00047882ULL, 0x000fe40000000000ULL,
0x00005a0000057ab9ULL, 0x000fc40000000800ULL, 0x0000000504047299ULL, 0x000fe2000800063fULL,
0x000000051f087211ULL, 0x002fc800078fe0ffULL, 0x00000002080a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000100037824ULL, 0x000fe400078e0208ULL, 0x0000000108097824ULL, 0x000fe400078e021fULL,
0x0000000100067824ULL, 0x000fe200078e020aULL, 0x0000000403057c12ULL, 0x000fe2000f8e30ffULL,
0x00000010080c7824ULL, 0x000fe200078e00ffULL, 0x00005a00ff037a19ULL, 0x000fe20000011603ULL,
0x000000010a087824ULL, 0x000fe200078e021fULL, 0x0000000406077c12ULL, 0x000fe2000f8e30ffULL,
0x0000000102057824ULL, 0x000fe200078e0205ULL, 0xfffffff00c097812ULL, 0x000fc600078ee209ULL,
0x0000000102027824ULL, 0x000fe200078e0207ULL, 0x00005a00ff077a19ULL, 0x000fe20000011606ULL,
0x0000008203037224ULL, 0x080fe400078e0205ULL, 0x000000101f057824ULL, 0x000fe400078e00ffULL,
0x0000008207077224ULL, 0x000fe400078e0202ULL, 0x0000010003027825ULL, 0x000fe200078e00ffULL,
0x000000f0050d7812ULL, 0x000fc600078ec0ffULL, 0x0000010007067825ULL, 0x000fe200078e00ffULL,
0x0000000d02027212ULL, 0x000fc600078efcffULL, 0x0000001009097824ULL, 0x000fe200078e00ffULL,
0x0000000d06067212ULL, 0x000fe200078efcffULL, 0x000000100a0d7824ULL, 0x000fe200078e00ffULL,
0x00005e0002027a10ULL, 0x000fe40007f1e0ffULL, 0x00005e0006067a10ULL, 0x000fe40007f3e0ffULL,
0xfffffff00d087812ULL, 0x000fe400078ee208ULL, 0x00005f0003037a10ULL, 0x000fe400007fe4ffULL,
0x00005f0007077a10ULL, 0x000fe20000ffe4ffULL, 0x00000010080d7824ULL, 0x000fc400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002097faeULL, 0x0003e8000b901c48ULL,
0x00000000060d7faeULL, 0x0003e4000b901c48ULL, 0x0000000000037919ULL, 0x002e620000000000ULL,
0x0000000000067806ULL, 0x000fe200038e0000ULL, 0x00000004ff097424ULL, 0x000fe400078e00ffULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000600027300ULL, 0x000e7000000e0000ULL,
0x0000000600077309ULL, 0x000ea20000000000ULL, 0x000000030200720cULL, 0x002fe20003f02070ULL,
0x0000660004027625ULL, 0x000fc800078e0009ULL, 0x000000ffff077224ULL, 0x004fd000078e0a07ULL,
0x01260407ffff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01260000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000008021e7981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0b00720cULL, 0x000fe40003f05270ULL, 0x0000007f1e1d7810ULL, 0x044fe40007ffe0ffULL,
0x000000ff1e0a7810ULL, 0x000fc40007ffe0ffULL, 0x00000007ff1d7819ULL, 0x000fe4000001161dULL,
0x00000008ff1c7819ULL, 0x000fca000001160aULL, 0x0000d81000008947ULL, 0x000fea0003800000ULL,
0x00000003ff1b7819ULL, 0x000fe20000011620ULL, 0x00000003ff077424ULL, 0x002fe200078e00ffULL,
0x0001268820067811ULL, 0x000fe200078e18ffULL, 0xffffffffff277424ULL, 0x000fe200078e00ffULL,
0x01ffffff1b1b7812ULL, 0x000fc800078ec0ffULL, 0x0000001d1b00720cULL, 0x000fda0003f06070ULL,
0x0000000204008824ULL, 0x000fe400078e00ffULL, 0x00006800ff038624ULL, 0x000fc800078e00ffULL,
0x0000680000008624ULL, 0x000fc800078e0203ULL, 0x000000011b008824ULL, 0x000fe200078e0200ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000040706ff738cULL, 0x0003e20000000000ULL,
0x0000640000028625ULL, 0x000fe200078e0009ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000802278981ULL, 0x000ea2000c1e1900ULL, 0x000001ff0a00780cULL, 0x000fe20003f04070ULL,
0x0000008019197824ULL, 0x000fe200078e00ffULL, 0x00000001ff1a7819ULL, 0x000fe20000011620ULL,
0x00000080ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000000006ff7f8cULL, 0x0007e6000c80043fULL,
0x000000201a777824ULL, 0x000fca00078e00ffULL, 0x0000006019077812ULL, 0x002fe200078ef877ULL,
0x0000590027007a24ULL, 0x004fc800078e02ffULL, 0x00000080000c7824ULL, 0x000fe200078e00ffULL,
0x0000000120007812ULL, 0x000fc600078ec0ffULL, 0x000062000c0c7625ULL, 0x000fe200078e000dULL,
0x000003e000000947ULL, 0x000fea0003800000ULL, 0x0000001000037824ULL, 0x008fe200078e00ffULL,
0x000000771e007217ULL, 0x000fe40007800000ULL, 0x00000003ff027819ULL, 0x000fc6000001161fULL,
0x0000000100007824ULL, 0x000fe200078e0a77ULL, 0x0000000402097810ULL, 0x000fe20007ffe0ffULL,
0x0000000103067824ULL, 0x000fc600078e0202ULL, 0x0000000300007217ULL, 0x000fe20007800000ULL,
0x0000000106087824ULL, 0x040fe400078e021fULL, 0x00000008060b7824ULL, 0x000fe400078e00ffULL,
0x0000000100007824ULL, 0x000fc600078e0a03ULL, 0xfffffff80b0e7812ULL, 0x000fe400078ee208ULL,
0x0000000802087810ULL, 0x040fe40007ffe0ffULL, 0x0000000c020b7810ULL, 0x040fe40007ffe0ffULL,
0x000000000200720cULL, 0x080fe20003f66070ULL, 0x0000000107027824ULL, 0x000fe200078e0206ULL,
0x000000000b00720cULL, 0x080fe20003f06070ULL, 0x0000000103067824ULL, 0x000fe200078e0209ULL,
0x000000000900720cULL, 0x080fe20003f46070ULL, 0x00000001030a7824ULL, 0x040fe200078e0208ULL,
0x000000000800720cULL, 0x000fe20003f26070ULL, 0x0000000103107824ULL, 0x000fc400078e020bULL,
0x0000008002027825ULL, 0x000fc800078e00ffULL, 0x0000000107007824ULL, 0x040fe200078e0206ULL,
0x00000070020b7812ULL, 0x000fe200078ef805ULL, 0x0000000106087824ULL, 0x140fe400078e021fULL,
0x00000008060f7824ULL, 0x000fe400078e00ffULL, 0x0000000107067824ULL, 0x040fe400078e020aULL,
0x0000000107097824ULL, 0x000fe400078e0210ULL, 0x000000010a077824ULL, 0x000fc400078e021fULL,
0x000000080a127824ULL, 0x000fe200078e00ffULL, 0x0000000b0c0a7210ULL, 0x000fe20007f9e0ffULL,
0x0000000110027824ULL, 0x040fe400078e021fULL, 0x0000000810117824ULL, 0x000fe200078e00ffULL,
0xfffffff812127812ULL, 0x000fe200078ee207ULL, 0x000000010d0b7824ULL, 0x000fe200020e0603ULL,
0xfffffff80f107812ULL, 0x000fe200078ee208ULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0xfffffff811147812ULL, 0x000fe400078ee202ULL, 0x0000e0001a0f7811ULL, 0x000fe200078e68ffULL,
0x0000008000027825ULL, 0x000fe200078e00ffULL, 0x0000007006177812ULL, 0x000fc600078ef805ULL,
0x0000008009087825ULL, 0x000fe200078e00ffULL, 0x0000007002217812ULL, 0x000fe400078ef805ULL,
0x000000170c067210ULL, 0x000fe20007fbe0ffULL, 0x000000100e117824ULL, 0x000fe200078e020fULL,
0x0000007008157812ULL, 0x000fe200078ef805ULL, 0x0000001010137824ULL, 0x100fe200078e020fULL,
0x000000210c027210ULL, 0x000fe20007f9e0ffULL, 0x0000001012057824ULL, 0x000fe200078e020fULL,
0x000000150c087210ULL, 0x000fe20007fde0ffULL, 0x000000010d077824ULL, 0x040fe200028e0607ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a117faeULL, 0x0003e2000d901c48ULL,
0x000000010d037824ULL, 0x000fc400020e0603ULL, 0x00000010140f7824ULL, 0x000fe400078e020fULL,
0x000000010d097824ULL, 0x000fe200030e0609ULL, 0x0000000002137faeULL, 0x0003e8000d101c48ULL,
0x0000000006057faeULL, 0x0003e8000c901c48ULL, 0x00000000080f7faeULL, 0x0003e2000c101c48ULL,
0x0000031000007947ULL, 0x000fea0003800000ULL, 0x0000001000007824ULL, 0x008fe200078e00ffULL,
0x0000e0001a237811ULL, 0x000fc800078e68ffULL, 0x000000001f007211ULL, 0x000fc800078fe8ffULL,
0x0000000400067810ULL, 0x040fe20007ffe0ffULL, 0x0000000100037824ULL, 0x040fe200078e021fULL,
0x00000008000a7810ULL, 0x040fe20007ffe0ffULL, 0x00000008000e7824ULL, 0x040fe200078e00ffULL,
0x0000000c00107810ULL, 0x000fe20007ffe0ffULL, 0x0000000107027824ULL, 0x040fe400078e0200ULL,
0x0000000107007824ULL, 0x000fe200078e0206ULL, 0xfffffff80e0e7812ULL, 0x000fe200078ee203ULL,
0x0000008002027825ULL, 0x000fc800078e00ffULL, 0x0000000106087824ULL, 0x000fe200078e021fULL,
0x00000070020b7812ULL, 0x000fe200078ef805ULL, 0x00000008060f7824ULL, 0x000fe400078e00ffULL,
0x0000000107067824ULL, 0x040fe400078e020aULL, 0x0000000107097824ULL, 0x000fe400078e0210ULL,
0x000000010a077824ULL, 0x140fe400078e021fULL, 0x000000080a127824ULL, 0x000fe200078e00ffULL,
0x0000000b0c0a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000110027824ULL, 0x000fc400078e021fULL,
0x0000000810137824ULL, 0x000fe200078e00ffULL, 0xfffffff812127812ULL, 0x000fe200078ee207ULL,
0x000000010d0b7824ULL, 0x000fe200000e0603ULL, 0xfffffff80f107812ULL, 0x000fe200078ee208ULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0xfffffff813137812ULL, 0x000fc600078ee202ULL,
0x0000008000027825ULL, 0x000fe200078e00ffULL, 0x0000007006177812ULL, 0x000fc600078ef805ULL,
0x0000008009087825ULL, 0x000fe200078e00ffULL, 0x0000007002217812ULL, 0x000fe400078ef805ULL,
0x000000170c067210ULL, 0x000fe20007f3e0ffULL, 0x000000100e0f7824ULL, 0x000fe200078e0223ULL,
0x0000007008157812ULL, 0x000fe200078ef805ULL, 0x0000001010117824ULL, 0x100fe200078e0223ULL,
0x000000210c027210ULL, 0x000fe20007f1e0ffULL, 0x0000001012057824ULL, 0x000fe200078e0223ULL,
0x000000150c087210ULL, 0x000fe20007f5e0ffULL, 0x000000010d077824ULL, 0x040fe200008e0607ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a0f7faeULL, 0x0003e2000b901c48ULL,
0x000000010d037824ULL, 0x000fc400000e0603ULL, 0x0000001013137824ULL, 0x000fe400078e0223ULL,
0x000000010d097824ULL, 0x000fe200010e0609ULL, 0x0000000002117faeULL, 0x0003e8000b901c48ULL,
0x0000000006057faeULL, 0x0003e8000b901c48ULL, 0x0000000008137faeULL, 0x0003e4000b901c48ULL,
0x000000001a0473c2ULL, 0x000ea200000e0000ULL, 0x000000ff1c00720cULL, 0x000fe20003f05270ULL,
0x000000ffff217224ULL, 0x000fe200078e00ffULL, 0x000126a81a067811ULL, 0x002fe200078e18ffULL,
0x00000000006a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000687805ULL, 0x000fe2000001ff00ULL,
0x0000000000667805ULL, 0x000fe2000001ff00ULL, 0x0000000000647805ULL, 0x000fe2000001ff00ULL,
0x0000000000627805ULL, 0x000fe2000001ff00ULL, 0x0000000000607805ULL, 0x000fe2000001ff00ULL,
0x00000000005e7805ULL, 0x000fe2000001ff00ULL, 0x00000000005c7805ULL, 0x000fe2000001ff00ULL,
0x00000000005a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000587805ULL, 0x000fe2000001ff00ULL,
0x0000000000567805ULL, 0x000fe2000001ff00ULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x0000000000527805ULL, 0x000fe2000001ff00ULL, 0x0000000000507805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x000126a804047891ULL, 0x004fe2000f8e203fULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff3d7224ULL, 0x000fca00078e00ffULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000ff027f8cULL, 0x000e62000c800404ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000200006067f8cULL, 0x000ea2000c80043fULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000af8000008947ULL, 0x000fea0003800000ULL,
0x000000101a157824ULL, 0x000fe200078e00ffULL, 0x00000002ff177819ULL, 0x000fe20000011620ULL,
0x0000000204187824ULL, 0x000fc400078e00ffULL, 0x00006800ff057624ULL, 0x000fe200078e00ffULL,
0x0000001015157812ULL, 0x000fe200078ee2ffULL, 0x000000ffff007224ULL, 0x002fe400078e0003ULL,
0x000000ffff037224ULL, 0x004fe400078e0007ULL, 0x0000680018187624ULL, 0x000fe400078e0205ULL,
0xff317217ff027424ULL, 0x000fe400078e00ffULL, 0x000000ffff167224ULL, 0x000fc400078e00ffULL,
0x000000ffff6b7224ULL, 0x000fc400078e00ffULL, 0x000000ffff0a7224ULL, 0x01afca00078e00ffULL,
0x0000000000047805ULL, 0x000fc40000015200ULL, 0x0000000420067824ULL, 0x000fca00078e00ffULL,
0xfffffff806087812ULL, 0x000fc800078ec0ffULL, 0x000126c808147810ULL, 0x000fe20007ffe0ffULL,
0x0126cc0008067984ULL, 0x000e640000000800ULL, 0x8000000006ff7812ULL, 0x002fe40007804803ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001f000007945ULL, 0x000fe20003800000ULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604097210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000000906067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0126cc0008067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fe40007804803ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001020037824ULL, 0x000fe200078e00ffULL,
0x0000000116077810ULL, 0x000fe20007ffe0ffULL, 0x0000590027277a24ULL, 0x000fc600078e02ffULL,
0xffffffe003057812ULL, 0x000fe200078ec0ffULL, 0x0000008027047824ULL, 0x000fe200078e00ffULL,
0x0000001c0700720cULL, 0x000fc60003f46070ULL, 0x0000010016057824ULL, 0x000fca00078e0205ULL,
0x0000004005077810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff057424ULL, 0x000fc600078e00ffULL,
0x0000006007067812ULL, 0x000fe200078ec0ffULL, 0x0000620004047625ULL, 0x000fc800078e0005ULL,
0x0000000119237824ULL, 0x000fe200078e0206ULL, 0x000004000000a947ULL, 0x000fea0003800000ULL,
0x0000001003087812ULL, 0x000fe200078ec0ffULL, 0x000000101f0a7824ULL, 0x000fe200078e00ffULL,
0x000000071e037217ULL, 0x000fe40007800000ULL, 0x00000003ff097819ULL, 0x000fe4000001161fULL,
0x000000700a257812ULL, 0x000fe200078ec0ffULL, 0x0000000103037824ULL, 0x000fe200078e0a07ULL,
0x0000000409127810ULL, 0x040fe20007ffe0ffULL, 0x0000000109067824ULL, 0x040fe200078e0208ULL,
0x00000008090a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000803037217ULL, 0x000fe20007800000ULL,
0x0000000106077824ULL, 0x040fe200078e021fULL, 0x0000000c09137810ULL, 0x000fe20007ffe0ffULL,
0x0000000806107824ULL, 0x000fe400078e00ffULL, 0x0000000123067824ULL, 0x000fe400078e0206ULL,
0x0000000103037824ULL, 0x000fe200078e0a08ULL, 0xfffffff810107812ULL, 0x000fe200078ee207ULL,
0x0000008006067825ULL, 0x000fc600078e00ffULL, 0x000000031200720cULL, 0x0c0fe20003f86070ULL,
0x0000000112127824ULL, 0x100fe200078e0208ULL, 0x000000030900720cULL, 0x000fe20003fa6070ULL,
0x0000000113267824ULL, 0x000fe200078e0208ULL, 0x00000025060b7212ULL, 0x000fe200078efcffULL,
0x0000000123097824ULL, 0x000fe200078e0212ULL, 0x000000030a00720cULL, 0x040fe20003f66070ULL,
0x000000010a067824ULL, 0x000fe200078e0208ULL, 0x0000000b040a7210ULL, 0x000fe20007fde0ffULL,
0x0000008009087825ULL, 0x000fe200078e00ffULL, 0x000000031300720cULL, 0x000fc60003f06070ULL,
0x00000001050b7824ULL, 0x000fe200030e0607ULL, 0x0000002508137212ULL, 0x000fe200078efcffULL,
0x0000000123077824ULL, 0x000fe400078e0206ULL, 0x0000000112037824ULL, 0x140fe400078e021fULL,
0x0000000812227824ULL, 0x000fe200078e00ffULL, 0x0000001304127210ULL, 0x000fe20007fde0ffULL,
0x0000000106087824ULL, 0x040fe400078e021fULL, 0x0000000806277824ULL, 0x000fe200078e00ffULL,
0xfffffff822227812ULL, 0x000fe200078ee203ULL, 0x0000008007067825ULL, 0x000fc600078e00ffULL,
0xfffffff827247812ULL, 0x000fe200078ee208ULL, 0x0000000123237824ULL, 0x000fe200078e0226ULL,
0x0000002506037212ULL, 0x000fe200078efcffULL, 0x0000000105137824ULL, 0x000fe400030e0609ULL,
0x0000008023087825ULL, 0x000fe200078e00ffULL, 0x0000000304067210ULL, 0x000fe40007fde0ffULL,
0x0000f0001a037811ULL, 0x000fe200078e68ffULL, 0x0000000126237824ULL, 0x000fe200078e021fULL,
0x0000002508257212ULL, 0x000fe200078efcffULL, 0x0000000826267824ULL, 0x000fc400078e00ffULL,
0x0000000105077824ULL, 0x040fe200030e0607ULL, 0x0000002504047210ULL, 0x000fe20007fde0ffULL,
0x0000001022257824ULL, 0x000fe200078e0203ULL, 0xfffffff826087812ULL, 0x000fe200078ee223ULL,
0x0000001010237824ULL, 0x100fe400078e0203ULL, 0x0000001024277824ULL, 0x100fe400078e0203ULL,
0x0000001008037824ULL, 0x000fe200078e0203ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a237faeULL, 0x0003e2000e901c48ULL, 0x0000000105057824ULL, 0x000fc600030e0609ULL,
0x0000000012257faeULL, 0x0003e8000e101c48ULL, 0x0000000006277faeULL, 0x0003e8000d901c48ULL,
0x0000000004037faeULL, 0x0003e2000c101c48ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x0000001003067812ULL, 0x000fe200078ec0ffULL, 0x000000101f077824ULL, 0x000fe200078e00ffULL,
0x0000f0001a6d7811ULL, 0x000fc400078e68ffULL, 0x000000061f067211ULL, 0x000fe400078fe8ffULL,
0x0000007007277812ULL, 0x000fe400078ec0ffULL, 0x0000000806107810ULL, 0x040fe20007ffe0ffULL,
0x0000000106037824ULL, 0x040fe200078e021fULL, 0x0000000c06127810ULL, 0x040fe20007ffe0ffULL,
0x0000000806087824ULL, 0x000fe400078e00ffULL, 0x0000000123077824ULL, 0x000fe400078e0206ULL,
0x0000000812297824ULL, 0x000fe200078e00ffULL, 0xfffffff808037812ULL, 0x000fe200078ee203ULL,
0x00000001100b7824ULL, 0x000fe200078e021fULL, 0x0000000406087810ULL, 0x000fe20007ffe0ffULL,
0x0000008007067825ULL, 0x000fc800078e00ffULL, 0x0000000123097824ULL, 0x040fe200078e0208ULL,
0x0000002706137212ULL, 0x000fe200078efcffULL, 0x00000001080a7824ULL, 0x140fe400078e021fULL,
0x0000000808257824ULL, 0x000fe400078e00ffULL, 0x0000000123087824ULL, 0x040fe400078e0210ULL,
0x0000000123237824ULL, 0x000fe400078e0212ULL, 0x0000000112067824ULL, 0x000fe200078e021fULL,
0x0000001304127210ULL, 0x000fe20007f1e0ffULL, 0x0000000810227824ULL, 0x000fe200078e00ffULL,
0xfffffff825107812ULL, 0x000fe200078ee20aULL, 0x0000001003037824ULL, 0x000fe200078e026dULL,
0xfffffff829247812ULL, 0x000fe200078ee206ULL, 0x0000000105137824ULL, 0x000fe200000e0607ULL,
0xfffffff822227812ULL, 0x000fe200078ee20bULL, 0x0000008009067825ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012037faeULL, 0x0003e2000b901c48ULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x00000027062b7212ULL, 0x000fc600078efcffULL,
0x00000080230a7825ULL, 0x000fe200078e00ffULL, 0x0000002708297212ULL, 0x000fe400078efcffULL,
0x0000002b04067210ULL, 0x000fe20007f1e0ffULL, 0x0000001010237824ULL, 0x100fe200078e026dULL,
0x000000270a277212ULL, 0x000fe200078efcffULL, 0x0000001022257824ULL, 0x000fe200078e026dULL,
0x0000002904087210ULL, 0x040fe20007f7e0ffULL, 0x0000000105077824ULL, 0x000fe200000e0607ULL,
0x0000002704047210ULL, 0x000fe20007f9e0ffULL, 0x0000001024277824ULL, 0x000fc400078e026dULL,
0x0000000105097824ULL, 0x040fe200018e0609ULL, 0x0000000006237faeULL, 0x0003e2000b901c48ULL,
0x0000000105057824ULL, 0x000fc600020e060bULL, 0x0000000008257faeULL, 0x0003e8000b901c48ULL,
0x0000000004277faeULL, 0x0003e4000b901c48ULL, 0x0000000820037824ULL, 0x002fe200078e00ffULL,
0x000000011b047810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff247424ULL, 0x000fc600078e00ffULL,
0xfffffff0030a7812ULL, 0x040fe400078ec0ffULL, 0x0000001d0400720cULL, 0x000fe40003f06070ULL,
0x000000000a0573c2ULL, 0x000e6200000e0000ULL, 0xffffffe003227812ULL, 0x040fe400078ec0ffULL,
0x0000001003077812ULL, 0x040fe400078ec0ffULL, 0x0000000803037812ULL, 0x000fcc00078ec0ffULL,
0x0000000118048824ULL, 0x000fe400078e0204ULL, 0x00000004ff058424ULL, 0x000fe200078e00ffULL,
0x0000002203227210ULL, 0x000fe40007ffe007ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000640004048625ULL, 0x000fca00078e0005ULL, 0x0000000804248981ULL, 0x000522000c1e1900ULL,
0x000126b005057890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x004fec0000008000ULL,
0x0126b0000a267f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126080022087f8cULL, 0x000664000c80043fULL, 0x0000000000047805ULL, 0x000fc40000015200ULL,
0x01260c0022037984ULL, 0x000ee40000000800ULL, 0x8000000003ff7812ULL, 0x00afe40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604067210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000600780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400600780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011407ULL,
0x0000000603037211ULL, 0x000fca00078110ffULL, 0x000000ffff067224ULL, 0x000fca00000e0607ULL,
0x0000000203037819ULL, 0x000fc80000001206ULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010b0b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01260c0022037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000101f137824ULL, 0x000fe200078e00ffULL, 0x00000001ff127819ULL, 0x000fe2000001161fULL,
0x0000002020037824ULL, 0x000fe400078e00ffULL, 0xffffffffff807424ULL, 0x000fe200078e00ffULL,
0x0000007013137812ULL, 0x000fc400078ec0ffULL, 0xffffff8003037812ULL, 0x000fe400078ec0ffULL,
0x0000000c12127812ULL, 0x000fc800078ec0ffULL, 0x0000000312037210ULL, 0x000fca0007ffe013ULL,
0x0120000003057984ULL, 0x000e680000000800ULL, 0x0122000003047984ULL, 0x0006a20000000800ULL,
0x000000020500720bULL, 0x002fe20003f1d000ULL, 0x000138627f007947ULL, 0x000fd8000b800000ULL,
0x0000000000037806ULL, 0x008fc800000e0100ULL, 0x000000ff0300720cULL, 0x000fe20003f05270ULL,
0x0000076000007945ULL, 0x000fe20003800000ULL, 0x00000001ff067424ULL, 0x000fe400078e00ffULL,
0x000000ffff237224ULL, 0x000fc400078e0002ULL, 0x0000001fff847424ULL, 0x000fe400078e00ffULL,
0xffffffffff817424ULL, 0x000fca00078e00ffULL, 0x0000070000008947ULL, 0x000fea0003800000ULL,
0x000000201700720cULL, 0x000fe40003f05270ULL, 0x000000020500720bULL, 0x000fe20003f74000ULL,
0x000138027f007947ULL, 0x000fd8000b800000ULL, 0x0000000000087806ULL, 0x000fc400018e0100ULL,
0x0000008020078824ULL, 0x000fe200078e0213ULL, 0x0000000205237209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x0000000112108824ULL, 0x000fca00078e0207ULL,
0x0124002310008388ULL, 0x0003e20000000800ULL, 0x000000ff0800720cULL, 0x000fda0003f05270ULL,
0x000005e000008947ULL, 0x000fea0003800000ULL, 0x0000000223027221ULL, 0x002fe20000010100ULL,
0x000000ff08ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b02027820ULL, 0x000fcc0000410000ULL, 0x0000000200027308ULL, 0x000e640000000800ULL,
0x0000000221217220ULL, 0x002fe40000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff297819ULL, 0x000fe2000001161fULL, 0x000137427f007947ULL, 0x000fea000b800000ULL,
0x00001f2902297589ULL, 0x0002e400000e0000ULL, 0x000000292c2c7220ULL, 0x08cfe20000410000ULL,
0x000000292d2d7220ULL, 0x080fe20000410000ULL, 0x0000002930307220ULL, 0x080fe20000410000ULL,
0x0000002931317220ULL, 0x080fe20000410000ULL, 0x0000002934347220ULL, 0x080fe20000410000ULL,
0x0000002935357220ULL, 0x080fe20000410000ULL, 0x0000002938387220ULL, 0x080fe20000410000ULL,
0x0000002939397220ULL, 0x080fe20000410000ULL, 0x000000293c3c7220ULL, 0x080fe20000410000ULL,
0x000000293d3d7220ULL, 0x080fe20000410000ULL, 0x0000002940407220ULL, 0x080fe20000410000ULL,
0x0000002941417220ULL, 0x080fe20000410000ULL, 0x0000002944447220ULL, 0x080fe20000410000ULL,
0x0000002945457220ULL, 0x080fe20000410000ULL, 0x0000002948487220ULL, 0x080fe20000410000ULL,
0x0000002949497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0008ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000081f297811ULL, 0x000fe200078ff0ffULL,
0x000136127f007947ULL, 0x000fea000b800000ULL, 0x00001f2902297589ULL, 0x00066400000e0000ULL,
0x000000292e2e7220ULL, 0x086fe20000410000ULL, 0x000000292f2f7220ULL, 0x080fe20000410000ULL,
0x0000002932327220ULL, 0x080fe20000410000ULL, 0x0000002933337220ULL, 0x080fe20000410000ULL,
0x0000002936367220ULL, 0x080fe20000410000ULL, 0x0000002937377220ULL, 0x080fe20000410000ULL,
0x000000293a3a7220ULL, 0x080fe20000410000ULL, 0x000000293b3b7220ULL, 0x080fe20000410000ULL,
0x000000293e3e7220ULL, 0x080fe20000410000ULL, 0x000000293f3f7220ULL, 0x080fe20000410000ULL,
0x0000002942427220ULL, 0x080fe20000410000ULL, 0x0000002943437220ULL, 0x080fe20000410000ULL,
0x0000002946467220ULL, 0x080fe20000410000ULL, 0x0000002947477220ULL, 0x080fe20000410000ULL,
0x000000294a4a7220ULL, 0x080fe20000410000ULL, 0x000000294b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000008ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000101f297811ULL, 0x000fe200078ff0ffULL, 0x000134e27f007947ULL, 0x000fea000b800000ULL,
0x00001f2902297589ULL, 0x0002e400000e0000ULL, 0x000000294c4c7220ULL, 0x08cfe20000410000ULL,
0x000000294d4d7220ULL, 0x080fe20000410000ULL, 0x0000002950507220ULL, 0x080fe20000410000ULL,
0x0000002951517220ULL, 0x080fe20000410000ULL, 0x0000002954547220ULL, 0x080fe20000410000ULL,
0x0000002955557220ULL, 0x080fe20000410000ULL, 0x0000002958587220ULL, 0x080fe20000410000ULL,
0x0000002959597220ULL, 0x080fe20000410000ULL, 0x000000295c5c7220ULL, 0x080fe20000410000ULL,
0x000000295d5d7220ULL, 0x080fe20000410000ULL, 0x0000002960607220ULL, 0x080fe20000410000ULL,
0x0000002961617220ULL, 0x080fe20000410000ULL, 0x0000002964647220ULL, 0x080fe20000410000ULL,
0x0000002965657220ULL, 0x080fe20000410000ULL, 0x0000002968687220ULL, 0x080fe20000410000ULL,
0x0000002969697220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000008ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000181f297811ULL, 0x000fe200078ff0ffULL, 0x000133c27f007947ULL, 0x000fea000b800000ULL,
0x00001f2902297589ULL, 0x0002e400000e0000ULL, 0x000000294e4e7220ULL, 0x08cfe20000410000ULL,
0x000000294f4f7220ULL, 0x080fe20000410000ULL, 0x0000002952527220ULL, 0x080fe20000410000ULL,
0x0000002953537220ULL, 0x080fe20000410000ULL, 0x0000002956567220ULL, 0x080fe20000410000ULL,
0x0000002957577220ULL, 0x080fe20000410000ULL, 0x000000295a5a7220ULL, 0x080fe20000410000ULL,
0x000000295b5b7220ULL, 0x080fe20000410000ULL, 0x000000295e5e7220ULL, 0x080fe20000410000ULL,
0x000000295f5f7220ULL, 0x080fe20000410000ULL, 0x0000002962627220ULL, 0x080fe20000410000ULL,
0x0000002963637220ULL, 0x080fe20000410000ULL, 0x0000002966667220ULL, 0x080fe20000410000ULL,
0x0000002967677220ULL, 0x080fe20000410000ULL, 0x000000296a6a7220ULL, 0x080fe20000410000ULL,
0x000000296b6b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000000803ff7212ULL, 0x000fda00078030ffULL, 0x8000002305050221ULL, 0x000fe20000010000ULL,
0x00007610ff060816ULL, 0x000fc60000000006ULL, 0x3fb8aa3b05050820ULL, 0x000fc80000410000ULL,
0x0000000500110308ULL, 0x000e640000000800ULL, 0x0000001104040220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002104217221ULL, 0x004fc20000010000ULL,
0x0000000000027805ULL, 0x008fcc0000015200ULL, 0x0126ac000a057984ULL, 0x000e620000000800ULL,
0x000126a80a107810ULL, 0x000fe40007ffe0ffULL, 0x8000000005ff7812ULL, 0x002fe20007804800ULL,
0x0000000000007918ULL, 0x000fd40000000000ULL, 0x0000020000007945ULL, 0x000fe20003800000ULL,
0x000000ffff087224ULL, 0x000fe200078e00ffULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000100800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fcc0000015200ULL,
0x0000000402077210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e03ULL,
0x003d09000700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc80000011405ULL, 0x0000000704047211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000204047819ULL, 0x000fc80000001205ULL,
0x000000040000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000108087810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0126ac000a057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804800ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991006007816ULL, 0x000fe200000000ffULL, 0x0000010000007945ULL, 0x000fe60003800000ULL,
0x000000ff0000720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000011ff00723eULL, 0x000fe400000000ffULL, 0x00000002ff037819ULL, 0x000fe4000001161fULL,
0x0000541000007816ULL, 0x000fe20000000000ULL, 0x00012f827f007947ULL, 0x000fea000b800000ULL,
0x00001f03000f7589ULL, 0x0002a400000e0000ULL, 0x0000000803297810ULL, 0x000fe20007ffe0ffULL,
0x00012fb27f007947ULL, 0x000fea000b800000ULL, 0x00000010030d7810ULL, 0x000fe20007ffe0ffULL,
0x00001f29000e7589ULL, 0x00066a00000e0000ULL, 0x00001f0d000d7589ULL, 0x0006a400000e0000ULL,
0x0000001803297810ULL, 0x008fe20007ffe0ffULL, 0x000130027f007947ULL, 0x000fea000b800000ULL,
0x00001f29000c7589ULL, 0x0006a400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000220257824ULL, 0x040fe200078e00ffULL, 0x000000081f027812ULL, 0x000fe200078ec0ffULL,
0x0000000420047824ULL, 0x040fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000040020037824ULL, 0x002fe200078e00ffULL, 0x0000000425007812ULL, 0x008fe200078ec0ffULL,
0x0000022000007945ULL, 0x000fe20003800000ULL, 0x00000007020b7812ULL, 0x000fc400078ef81fULL,
0x000000001f027211ULL, 0x000fe400078fe0ffULL, 0x000000100b097812ULL, 0x040fe200078efcffULL,
0x000000080b057824ULL, 0x040fe200078e00ffULL, 0x0000000404047812ULL, 0x000fe200078ec0ffULL,
0x000000010b0a7824ULL, 0x000fe200078e0202ULL, 0xfffff00003037812ULL, 0x000fe200078ec0ffULL,
0x0000000102087824ULL, 0x000fe200078e0209ULL, 0x000000041f047211ULL, 0x000fe200078fe0ffULL,
0x0000000809077824ULL, 0x000fe200078e00ffULL, 0xfffffff8050a7812ULL, 0x000fe200078ee20aULL,
0x0000100020057824ULL, 0x000fe200078e00ffULL, 0x0000a000037d7810ULL, 0x000fe20007ffe0ffULL,
0x000000080b297824ULL, 0x000fe200078e00ffULL, 0xfffffff807087812ULL, 0x000fe200078ee208ULL,
0x000000010b027824ULL, 0x000fe200078e0204ULL, 0xffffe00005057812ULL, 0x000fe200078ec0ffULL,
0x000000100a6c7824ULL, 0x000fc400078e027dULL, 0x0000001008287824ULL, 0x000fe200078e027dULL,
0x0000e00005057810ULL, 0x000fe40007ffe0ffULL, 0xfffffff829077812ULL, 0x000fe200078ee202ULL,
0x000000006c6c783bULL, 0x000e680000000200ULL, 0x000000002828783bULL, 0x000ee20000000200ULL,
0x0000001007707824ULL, 0x000fe200078e0205ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000f6c6c7232ULL, 0x086fe40000000000ULL, 0x0000000f6e6e7232ULL, 0x000fc40000000000ULL,
0x0000000e6d6d7232ULL, 0x080fe40000000000ULL, 0x0000000e6f6f7232ULL, 0x000fe40000000000ULL,
0x0000000d28287232ULL, 0x088fe40000000000ULL, 0x0000000d2a2a7232ULL, 0x000fe40000000000ULL,
0x0000000c29297232ULL, 0x080fe40000000000ULL, 0x0000000c2b2b7232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000080b037824ULL, 0x000fe200078e00ffULL,
0x0000000202067810ULL, 0x000fe20007ffe0ffULL, 0x000000007070783bULL, 0x000ee20000004200ULL,
0x0000000200007812ULL, 0x000fe200078efcffULL, 0x000008e000007945ULL, 0x000fe20003800000ULL,
0xfffffff803067812ULL, 0x000fc400078ee206ULL, 0x000000001f007211ULL, 0x000fc600078fe0ffULL,
0x0000001006787824ULL, 0x000fcc00078e0205ULL, 0x000000007878783bULL, 0x000ea20000004200ULL,
0x00000010ff027819ULL, 0x108fe40000011670ULL, 0x000000ff70057812ULL, 0x040fe400078ec0ffULL,
0x00000018ff037819ULL, 0x000fe40000011670ULL, 0x0000ffff70937812ULL, 0x000fe400078ec0ffULL,
0x00000018ff707819ULL, 0x000fe40000011671ULL, 0x00000010ff7f7819ULL, 0x000fc40000011672ULL,
0x000000ff72857812ULL, 0x040fe400078ec0ffULL, 0x00000018ff837819ULL, 0x000fe40000011672ULL,
0x0000ffff72957812ULL, 0x000fe400078ec0ffULL, 0x00000018ff727819ULL, 0x100fe40000011673ULL,
0x0000ffff71947812ULL, 0x000fe400078ec0ffULL, 0x00000010ff867819ULL, 0x000fc40000011673ULL,
0x000000ff73877812ULL, 0x040fe400078ec0ffULL, 0x0000ffff73967812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8d7819ULL, 0x104fe4000001167aULL, 0x000000ff7a8f7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff8e7819ULL, 0x000fe4000001167aULL, 0x0000ffff7a997812ULL, 0x000fc400078ec0ffULL,
0x00000070ff73723eULL, 0x000fe400020006ffULL, 0x000000ff02027812ULL, 0x000fe400078ec0ffULL,
0x00000072ff7a723eULL, 0x000fe400020006ffULL, 0x00000008ff707819ULL, 0x000fe40000011693ULL,
0x00000008ff727819ULL, 0x000fe40000011694ULL, 0x00000010ff7c7819ULL, 0x000fc40000011671ULL,
0x000000ff717e7812ULL, 0x000fe400078ec0ffULL, 0x00000005ff05723eULL, 0x000fe400020006ffULL,
0x00000002ff02723eULL, 0x000fe400020006ffULL, 0x00000003ff71723eULL, 0x000fe400020006ffULL,
0x00000070ff70723eULL, 0x000fe400020006ffULL, 0x00000072ff72723eULL, 0x000fc400020006ffULL,
0x00000010ff887819ULL, 0x100fe40000011678ULL, 0x000000ff788a7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff897819ULL, 0x000fe40000011678ULL, 0x0000ffff78977812ULL, 0x000fe400078ec0ffULL,
0x000000ff86867812ULL, 0x000fe400078ec0ffULL, 0x00000018ff787819ULL, 0x000fc40000011679ULL,
0x0000541005027816ULL, 0x000fe40000000002ULL, 0x0000541070707816ULL, 0x000fe40000000071ULL,
0x00000008ff057819ULL, 0x000fe40000011695ULL, 0x0000541072717816ULL, 0x000fe40000000073ULL,
0x00000086ff73723eULL, 0x000fe400020006ffULL, 0x00000078ff86723eULL, 0x000fc400020006ffULL,
0x000000ff7c7c7812ULL, 0x000fe200078ec0ffULL, 0x000000706c30723cULL, 0x082f620000001830ULL,
0x00000005ff78723eULL, 0x000fe400020006ffULL, 0x00000008ff057819ULL, 0x000fe40000011697ULL,
0x0000ffff79987812ULL, 0x000fe400078ec0ffULL, 0x0000007eff7e723eULL, 0x000fe200020006ffULL,
0x000000702850723cULL, 0x000f620000001850ULL, 0x0000007cff03723eULL, 0x000fc400020006ffULL,
0x00000089ff89723eULL, 0x000fe400020006ffULL, 0x000000ff7f7f7812ULL, 0x000fe400078ec0ffULL,
0x00000005ff05723eULL, 0x000fe400020006ffULL, 0x00000010ff8b7819ULL, 0x000fe40000011679ULL,
0x000000ff798c7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff7c7819ULL, 0x000fc40000011698ULL,
0x00000008ff797819ULL, 0x000fe40000011696ULL, 0x000000ff8d8d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff907819ULL, 0x000fe4000001167bULL, 0x0000ffff7b9a7812ULL, 0x000fe400078ec0ffULL,
0x000054107e037816ULL, 0x000fe40000000003ULL, 0x0000007fff72723eULL, 0x000fc400020006ffULL,
0x00005410057e7816ULL, 0x000fe40000000089ULL, 0x0000007cff7f723eULL, 0x000fe200020006ffULL,
0x000000026c2c723cULL, 0x080f62000000182cULL, 0x00000008ff057819ULL, 0x000fe40000011699ULL,
0x00000087ff87723eULL, 0x000fe400020006ffULL, 0x00000079ff79723eULL, 0x000fe400020006ffULL,
0x0000008fff8f723eULL, 0x000fe200020006ffULL, 0x00000002284c723cULL, 0x000b62000000184cULL,
0x0000008dff8d723eULL, 0x000fc400020006ffULL, 0x000000ff7b927812ULL, 0x000fe400078ec0ffULL,
0x00000018ff917819ULL, 0x000fe4000001167bULL, 0x00000083ff83723eULL, 0x000fe200020006ffULL,
0x000000080b027824ULL, 0x020fe200078e00ffULL, 0x000000ff88887812ULL, 0x000fe200078ec0ffULL,
0x0000000809037824ULL, 0x000fe200078e00ffULL, 0x000000ff8b8b7812ULL, 0x000fe400078ec0ffULL,
0x000000ff90907812ULL, 0x000fc400078ec0ffULL, 0x00000008ff7c7819ULL, 0x000fe4000001169aULL,
0x0000008eff8e723eULL, 0x000fe400020006ffULL, 0x000054107f7f7816ULL, 0x000fe40000000086ULL,
0x00000005ff05723eULL, 0x000fe400020006ffULL, 0x0000541087737816ULL, 0x000fe40000000073ULL,
0x0000541079797816ULL, 0x000fe2000000007aULL, 0x0000007e6c40723cULL, 0x000f620000001840ULL,
0x000054108f867816ULL, 0x000fc4000000008dULL, 0x00000085ff85723eULL, 0x000fe400020006ffULL,
0x0000008aff8a723eULL, 0x000fe400020006ffULL, 0x0000008cff7b723eULL, 0x000fe200020006ffULL,
0x0000007e2860723cULL, 0x000f620000001860ULL, 0x0000541078787816ULL, 0x000fe40000000083ULL,
0x00000088ff7a723eULL, 0x000fe400020006ffULL, 0x0000008bff8b723eULL, 0x000fc400020006ffULL,
0x00000092ff87723eULL, 0x000fe200020006ffULL, 0x000000786c38723cULL, 0x080f620000001838ULL,
0x00000090ff90723eULL, 0x000fe400020006ffULL, 0x00000091ff91723eULL, 0x000fe400020006ffULL,
0x0000007cff8f723eULL, 0x000fe400020006ffULL, 0x00005410058e7816ULL, 0x000fe2000000008eULL,
0x000000010b057824ULL, 0x000fe200078e0200ULL, 0x0000541085727816ULL, 0x000fe20000000072ULL,
0x0000000109007824ULL, 0x000fe200078e0200ULL, 0x000054108a7a7816ULL, 0x000fe2000000007aULL,
0x000000782858723cULL, 0x000b620000001858ULL, 0x000054107b7b7816ULL, 0x000fc4000000008bULL,
0x0000541087877816ULL, 0x000fe40000000090ULL, 0x000054108f8f7816ULL, 0x000fe40000000091ULL,
0x0000000109787824ULL, 0x020fe200078e0204ULL, 0xfffffff802057812ULL, 0x000fe200078ee205ULL,
0x000000726c34723cULL, 0x000f620000001834ULL, 0xfffffff803047812ULL, 0x000fe400078ee200ULL,
0x0000e0001a037811ULL, 0x000fca00078e68ffULL, 0x0000007a6c3c723cULL, 0x040f70000000183cULL,
0x000000866c44723cULL, 0x040f700000001844ULL, 0x0000008e6c48723cULL, 0x000b6e0000001848ULL,
0x00000008096d7824ULL, 0x020fe200078e00ffULL, 0x000000722854723cULL, 0x000f620000001854ULL,
0x00000010056c7824ULL, 0x000fc400078e027dULL, 0x00000010047d7824ULL, 0x000fe200078e027dULL,
0xfffffff86d027812ULL, 0x000fc600078ee278ULL, 0x000000006c6c783bULL, 0x000e620000000200ULL,
0x0000007a285c723cULL, 0x000f62000000185cULL, 0x0000001002707824ULL, 0x000fce00078e0203ULL,
0x000000862864723cULL, 0x040f700000001864ULL, 0x0000008e2868723cULL, 0x000b640000001868ULL,
0x000000007d28783bULL, 0x0204e20000000200ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x0000008000000947ULL, 0x000fde0003800000ULL, 0x0000000f6c6c7232ULL, 0x082fe40000000000ULL,
0x0000000f6e6e7232ULL, 0x000fc40000000000ULL, 0x0000000e6d6d7232ULL, 0x080fe40000000000ULL,
0x0000000e6f6f7232ULL, 0x000fe40000000000ULL, 0x0000000d28287232ULL, 0x088fe40000000000ULL,
0x0000000d2a2a7232ULL, 0x000fe40000000000ULL, 0x0000000c29297232ULL, 0x080fe40000000000ULL,
0x0000000c2b2b7232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000809797824ULL, 0x000fe200078e00ffULL, 0x0000000278007810ULL, 0x000fe20007ffe0ffULL,
0x000000007070783bULL, 0x000ea20000004200ULL, 0xfffffff825257812ULL, 0x000fc400078ec0ffULL,
0xfffffff879007812ULL, 0x000fca00078ee200ULL, 0x0000001000787824ULL, 0x000fcc00078e0203ULL,
0x000000007878783bULL, 0x000ee20000004200ULL, 0x00000010ff7c7819ULL, 0x004fe40000011670ULL,
0x00000010ff867819ULL, 0x100fe40000011672ULL, 0x000000ff72887812ULL, 0x040fe400078ec0ffULL,
0x00000018ff877819ULL, 0x000fe40000011672ULL, 0x0000ffff72987812ULL, 0x000fe400078ec0ffULL,
0x000000ff71857812ULL, 0x000fc400078ec0ffULL, 0x00000010ff897819ULL, 0x100fe40000011673ULL,
0x000000ff738a7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff727819ULL, 0x000fe40000011673ULL,
0x0000ffff73997812ULL, 0x000fe400078ec0ffULL, 0x000000ff707e7812ULL, 0x000fe400078ec0ffULL,
0x000000ff78737812ULL, 0x008fc400078ec0ffULL, 0x000000ff7c7c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff7f7819ULL, 0x100fe40000011671ULL, 0x0000ffff71977812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8b7819ULL, 0x000fe40000011678ULL, 0x00000018ff837819ULL, 0x000fe40000011671ULL,
0x00000018ff7d7819ULL, 0x000fc40000011670ULL, 0x0000ffff70967812ULL, 0x000fe400078ec0ffULL,
0x00000085ff71723eULL, 0x000fe400020006ffULL, 0x00000010ff937819ULL, 0x100fe4000001167bULL,
0x000000ff7b957812ULL, 0x040fe400078ec0ffULL, 0x00000018ff947819ULL, 0x000fe4000001167bULL,
0x0000ffff7b9d7812ULL, 0x000fc400078ec0ffULL, 0x0000007eff70723eULL, 0x000fe400020006ffULL,
0x00000073ff85723eULL, 0x000fe400020006ffULL, 0x0000007cff7c723eULL, 0x000fe400020006ffULL,
0x000000ff7f7f7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff737819ULL, 0x000fe40000011697ULL,
0x00000008ff7b7819ULL, 0x000fc40000011699ULL, 0x000000ff8b8b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff907819ULL, 0x100fe4000001167aULL, 0x000000ff7a927812ULL, 0x040fe400078ec0ffULL,
0x00000018ff917819ULL, 0x000fe4000001167aULL, 0x0000ffff7a9c7812ULL, 0x000fe400078ec0ffULL,
0x00000072ff7e723eULL, 0x000fc400020006ffULL, 0x0000541070707816ULL, 0x000fe4000000007cULL,
0x00000083ff83723eULL, 0x000fe400020006ffULL, 0x0000007fff7f723eULL, 0x000fe400020006ffULL,
0x00000008ff727819ULL, 0x000fe40000011696ULL, 0x00000073ff73723eULL, 0x000fe400020006ffULL,
0x00000008ff7a7819ULL, 0x000fc40000011698ULL, 0x0000007bff7b723eULL, 0x000fe400020006ffULL,
0x0000008bff7c723eULL, 0x000fe400020006ffULL, 0x0000ffff789a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8d7819ULL, 0x000fe40000011679ULL, 0x0000ffff799b7812ULL, 0x000fe400078ec0ffULL,
0x0000007dff7d723eULL, 0x000fc400020006ffULL, 0x00000087ff87723eULL, 0x000fe400020006ffULL,
0x0000541071717816ULL, 0x000fe4000000007fULL, 0x00000072ff72723eULL, 0x000fe400020006ffULL,
0x000000ff86867812ULL, 0x000fe400078ec0ffULL, 0x0000541073737816ULL, 0x000fe20000000083ULL,
0x00000070284c723cULL, 0x000f62000000184cULL, 0x0000007aff7a723eULL, 0x000fc400020006ffULL,
0x000054107b7b7816ULL, 0x000fe4000000007eULL, 0x00005410857c7816ULL, 0x000fe4000000007cULL,
0x00000018ff8c7819ULL, 0x000fe20000011678ULL, 0x000000706c2c723cULL, 0x002f62000000182cULL,
0x000000ff798f7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff8e7819ULL, 0x000fe40000011679ULL,
0x000000ff89897812ULL, 0x000fc400078ec0ffULL, 0x000000ff8d8d7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff7e7819ULL, 0x000fe4000001169aULL, 0x00000008ff7f7819ULL, 0x000fe4000001169bULL,
0x000000ff90907812ULL, 0x000fe400078ec0ffULL, 0x000000ff93937812ULL, 0x000fe400078ec0ffULL,
0x00000008ff837819ULL, 0x000fc4000001169cULL, 0x00000008ff857819ULL, 0x000fe4000001169dULL,
0x00000088ff78723eULL, 0x000fe400020006ffULL, 0x0000541072727816ULL, 0x000fe4000000007dULL,
0x00000086ff86723eULL, 0x000fe400020006ffULL, 0x000054107a7a7816ULL, 0x000fe40000000087ULL,
0x0000008aff79723eULL, 0x000fe200020006ffULL, 0x000000722850723cULL, 0x000f620000001850ULL,
0x0000008fff8f723eULL, 0x000fc400020006ffULL, 0x0000008cff8c723eULL, 0x000fe400020006ffULL,
0x00000089ff89723eULL, 0x000fe400020006ffULL, 0x0000008eff8e723eULL, 0x000fe200020006ffULL,
0x0000007a2858723cULL, 0x000f620000001858ULL, 0x00000092ff92723eULL, 0x000fe400020006ffULL,
0x0000008dff7d723eULL, 0x000fe400020006ffULL, 0x00000095ff95723eULL, 0x000fc400020006ffULL,
0x0000007eff7e723eULL, 0x000fe200020006ffULL, 0x000000726c30723cULL, 0x040f620000001830ULL,
0x0000007fff7f723eULL, 0x000fe400020006ffULL, 0x00000091ff91723eULL, 0x000fe400020006ffULL,
0x00000090ff90723eULL, 0x000fe400020006ffULL, 0x00000093ff93723eULL, 0x000fe200020006ffULL,
0x0000007a6c38723cULL, 0x000f620000001838ULL, 0x00000094ff94723eULL, 0x000fc400020006ffULL,
0x00000083ff83723eULL, 0x000fe400020006ffULL, 0x00000085ff87723eULL, 0x000fe400020006ffULL,
0x0000541078787816ULL, 0x000fe40000000086ULL, 0x0000541079797816ULL, 0x000fe40000000089ULL,
0x000054108f7d7816ULL, 0x000fe4000000007dULL, 0x000054107e7e7816ULL, 0x000fc4000000008cULL,
0x000054107f7f7816ULL, 0x000fe2000000008eULL, 0x000000782854723cULL, 0x040f620000001854ULL,
0x0000541092927816ULL, 0x000fe40000000090ULL, 0x0000541095937816ULL, 0x000fe40000000093ULL,
0x0000541083867816ULL, 0x000fe40000000091ULL, 0x0000541087877816ULL, 0x000fe20000000094ULL,
0x0000007c285c723cULL, 0x040f70000000185cULL, 0x0000007e2860723cULL, 0x040f700000001860ULL,
0x000000922864723cULL, 0x040f700000001864ULL, 0x000000862868723cULL, 0x000f700000001868ULL,
0x000000786c34723cULL, 0x040f700000001834ULL, 0x0000007c6c3c723cULL, 0x040f70000000183cULL,
0x0000007e6c40723cULL, 0x040f700000001840ULL, 0x000000926c44723cULL, 0x040f700000001844ULL,
0x000000866c48723cULL, 0x000b6e0000001848ULL, 0x000126c81a6c7811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x000000006c6c7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0126880025ff7f8cULL, 0x0005e4000c80043fULL,
0x0000000000287805ULL, 0x000fc40000015200ULL, 0x0000040014257984ULL, 0x004ea40000000800ULL,
0x8000000025ff7812ULL, 0x006fc4000780486dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff6e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000106e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a282a7210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2b7824ULL, 0x000fe200000e0e29ULL,
0x003d09002a00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402a00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc8000001142bULL, 0x0000002a25257211ULL, 0x000fca00078110ffULL,
0x000000ffff2a7224ULL, 0x000fca00000e062bULL, 0x0000000225257819ULL, 0x000fc8000000122aULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000016e6e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040014257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe4000780486dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001020287824ULL, 0x000fe400078e00ffULL,
0x0000590024247a24ULL, 0x010fe400078e02ffULL, 0x00000080ff6f7424ULL, 0x000fe200078e00ffULL,
0xffffffe028257812ULL, 0x000fe200078ec0ffULL, 0x00000080246e7824ULL, 0x000fc800078e00ffULL,
0x0000010016257824ULL, 0x000fe400078e0225ULL, 0x000062006e6e7625ULL, 0x000fc600078e006fULL,
0x0000008025257810ULL, 0x000fc80007ffe0ffULL, 0x0000006025247812ULL, 0x000fca00078ec0ffULL,
0x0000000119717824ULL, 0x000fe200078e0224ULL, 0x000003d00000a947ULL, 0x000fea0003800000ULL,
0x000000251e247217ULL, 0x000fe40007800000ULL, 0x00000010286d7812ULL, 0x000fe400078ec0ffULL,
0x00000003ff297819ULL, 0x000fe2000001161fULL, 0x0000000124247824ULL, 0x000fc600078e0a25ULL,
0x00000004296c7810ULL, 0x040fe20007ffe0ffULL, 0x0000000129287824ULL, 0x100fe200078e026dULL,
0x000000246d247217ULL, 0x000fe40007800000ULL, 0x0000000829737810ULL, 0x040fe20007ffe0ffULL,
0x000000016c787824ULL, 0x000fe200078e026dULL, 0x0000000c29797810ULL, 0x000fe20007ffe0ffULL,
0x0000000128257824ULL, 0x000fe400078e0271ULL, 0x0000000124707824ULL, 0x000fe400078e0a6dULL,
0x00000001282a7824ULL, 0x000fc400078e021fULL, 0x00000008282b7824ULL, 0x000fe200078e00ffULL,
0x000000702900720cULL, 0x080fe20003f06070ULL, 0x0000000178287824ULL, 0x000fe200078e0271ULL,
0x000000706c00720cULL, 0x080fe20003f86070ULL, 0x0000008025247825ULL, 0x000fe200078e00ffULL,
0xfffffff82b727812ULL, 0x000fe400078ee22aULL, 0x000000707300720cULL, 0x040fe20003f66070ULL,
0x00000001737a7824ULL, 0x000fe200078e026dULL, 0x00000013242b7212ULL, 0x000fe200078efcffULL,
0x0000008028287825ULL, 0x000fc600078e00ffULL, 0x0000002b6e6c7210ULL, 0x000fe20007fbe0ffULL,
0x000000017a2a7824ULL, 0x000fe400078e0271ULL, 0x00000001797c7824ULL, 0x000fe200078e026dULL,
0x00000013286d7212ULL, 0x000fe200078efcffULL, 0x000000802a2a7825ULL, 0x000fc600078e00ffULL,
0x0000006d6e287210ULL, 0x000fe20007fde0ffULL, 0x000000016f6d7824ULL, 0x000fe200028e0625ULL,
0x000000132a257212ULL, 0x000fe200078efcffULL, 0x000000017c247824ULL, 0x000fe200078e0271ULL,
0x000000707900720cULL, 0x000fe20003fa6070ULL, 0x000000016f297824ULL, 0x000fe200030e0629ULL,
0x000000256e2a7210ULL, 0x000fe20007fde0ffULL, 0x0000000178717824ULL, 0x040fe400078e021fULL,
0x0000000878787824ULL, 0x000fe400078e00ffULL, 0x0000008024247825ULL, 0x000fc600078e00ffULL,
0xfffffff878707812ULL, 0x000fe200078ee271ULL, 0x000000017a737824ULL, 0x100fe200078e021fULL,
0x0000001324717212ULL, 0x000fe200078efcffULL, 0x000000087a787824ULL, 0x000fe400078e00ffULL,
0x000000017c797824ULL, 0x040fe400078e021fULL, 0x000000087c7c7824ULL, 0x000fe200078e00ffULL,
0xfffffff878787812ULL, 0x000fe200078ee273ULL, 0x000000016f2b7824ULL, 0x000fe200030e062bULL,
0x000000716e247210ULL, 0x000fe20007fde0ffULL, 0x0000001072717824ULL, 0x000fe200078e0203ULL,
0xfffffff87c727812ULL, 0x000fe200078ee279ULL, 0x0000001070737824ULL, 0x000fc400078e0203ULL,
0x0000001078797824ULL, 0x000fe200078e0203ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006c717faeULL, 0x0003e2000c101c48ULL, 0x000000016f257824ULL, 0x000fe400030e0625ULL,
0x00000010727b7824ULL, 0x000fe200078e0203ULL, 0x0000000028737faeULL, 0x0003e8000e101c48ULL,
0x000000002a797faeULL, 0x0003e8000d901c48ULL, 0x00000000247b7faeULL, 0x0003e2000e901c48ULL,
0x0000030000007947ULL, 0x000fea0003800000ULL, 0x0000001028287812ULL, 0x000fc800078ec0ffULL,
0x000000281f287211ULL, 0x000fc800078fe8ffULL, 0x00000004282a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000128247824ULL, 0x140fe200078e021fULL, 0x00000008286c7810ULL, 0x040fe20007ffe0ffULL,
0x00000008282b7824ULL, 0x040fe200078e00ffULL, 0x0000000c287a7810ULL, 0x000fe20007ffe0ffULL,
0x000000012a257824ULL, 0x040fe400078e021fULL, 0x000000082a727824ULL, 0x000fe200078e00ffULL,
0xfffffff82b707812ULL, 0x000fe200078ee224ULL, 0x0000000128247824ULL, 0x000fe400078e0271ULL,
0x000000016c297824ULL, 0x000fe200078e021fULL, 0xfffffff872727812ULL, 0x000fe200078ee225ULL,
0x000000086c787824ULL, 0x000fc400078e00ffULL, 0x0000008024247825ULL, 0x000fc600078e00ffULL,
0xfffffff878787812ULL, 0x000fe200078ee229ULL, 0x000000012a287824ULL, 0x100fe400078e0271ULL,
0x000000016c2a7824ULL, 0x100fe400078e0271ULL, 0x000000017a6c7824ULL, 0x000fe200078e0271ULL,
0x0000001324717212ULL, 0x000fe200078efcffULL, 0x000000017a737824ULL, 0x040fe400078e021fULL,
0x000000087a7a7824ULL, 0x000fe200078e00ffULL, 0x000000716e247210ULL, 0x000fe20007f1e0ffULL,
0x0000008028287825ULL, 0x000fc600078e00ffULL, 0xfffffff87a7a7812ULL, 0x000fe200078ee273ULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x0000001328797212ULL, 0x000fc600078efcffULL,
0x000000806c6c7825ULL, 0x000fe200078e00ffULL, 0x000000132a737212ULL, 0x000fe400078efcffULL,
0x000000796e287210ULL, 0x000fe20007f7e0ffULL, 0x000000016f257824ULL, 0x040fe200000e0625ULL,
0x000000136c717212ULL, 0x000fe200078efcffULL, 0x0000001078797824ULL, 0x000fe200078e0203ULL,
0x000000736e2a7210ULL, 0x040fe20007f1e0ffULL, 0x000000016f297824ULL, 0x000fe200018e0629ULL,
0x000000716e6c7210ULL, 0x000fe20007f9e0ffULL, 0x0000001070717824ULL, 0x000fc400078e0203ULL,
0x0000001072737824ULL, 0x000fe400078e0203ULL, 0x000000016f2b7824ULL, 0x040fe200000e062bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024717faeULL, 0x0003e2000b901c48ULL,
0x000000016f6d7824ULL, 0x000fe400020e066dULL, 0x000000107a7b7824ULL, 0x000fe200078e0203ULL,
0x0000000028737faeULL, 0x0003e8000b901c48ULL, 0x000000002a797faeULL, 0x0003e8000b901c48ULL,
0x000000006c7b7faeULL, 0x0003e4000b901c48ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fda0003f0f070ULL,
0x00000000100503c2ULL, 0x000e640000020000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0099b0ULL, 0x002fe20008000a05ULL,
0x000000000000081cULL, 0x000fe20000f0f070ULL, 0xffffff8000001947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000106c7f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01262800222a7f8cULL, 0x000664000c80043fULL,
0x0000000000247805ULL, 0x000fc40000015200ULL, 0x01262c0022297984ULL, 0x000f240000000800ULL,
0x8000000029ff7812ULL, 0x012fc4000780482bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff707224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000107000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000287805ULL, 0x000fcc0000015200ULL,
0x0000002824717210ULL, 0x000fca0007f1e1ffULL, 0x0000000129297824ULL, 0x000fe200000e0e25ULL,
0x003d09007100780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c407100780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff287819ULL, 0x000fc80000011429ULL, 0x0000007128287211ULL, 0x000fca00078110ffULL,
0x000000ffff297224ULL, 0x000fca00000e0629ULL, 0x0000000228287819ULL, 0x000fc80000001229ULL,
0x000000280000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000170707810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01262c0022297984ULL, 0x000e640000000800ULL, 0x8000000029ff7812ULL, 0x002fe4000780482bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002020247824ULL, 0x000fca00078e00ffULL,
0xffffff8024247812ULL, 0x000fc800078ec0ffULL, 0x0000008013257810ULL, 0x000fca0007ffe024ULL,
0x0000000112257824ULL, 0x000fca00078e0225ULL, 0x0120000025247984ULL, 0x000e680000000800ULL,
0x0122000025707984ULL, 0x0006a20000000800ULL, 0x000000232400720bULL, 0x002fe20003f1d000ULL,
0x00010e827f007947ULL, 0x000fd8000b800000ULL, 0x0000000000257806ULL, 0x008fc800000e0100ULL,
0x000000ff2500720cULL, 0x000fe20003f05270ULL, 0x0000077000007945ULL, 0x000fe20003800000ULL,
0x00000001ff2a7424ULL, 0x000fd600078e00ffULL, 0x0000074000008947ULL, 0x000fea0003800000ULL,
0x0000000117297810ULL, 0x000fe40007ffe0ffULL, 0x000000232400720bULL, 0x000fe40003f74000ULL,
0x000000202900720cULL, 0x000fe20003f05270ULL, 0x00010e427f007947ULL, 0x000fd4000b800000ULL,
0x0000000000727806ULL, 0x000fc400018e0100ULL, 0x0000008020298824ULL, 0x000fe200078e0213ULL,
0x0000002324288209ULL, 0x000fe20007810000ULL, 0x0000064000017945ULL, 0x000fe40003800000ULL,
0x0000000112298824ULL, 0x000fca00078e0229ULL, 0x0124002829008388ULL, 0x0003e20000000800ULL,
0x000000ff7200720cULL, 0x000fda0003f05270ULL, 0x000005f000008947ULL, 0x000fea0003800000ULL,
0x0000002324287209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff72ff7812ULL, 0x000fc6000780c0ffULL, 0x0000002328287221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b28287820ULL, 0x000fc80000410000ULL, 0x0000002800787308ULL, 0x000e640000000800ULL,
0x0000007821217220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff297819ULL, 0x000fe2000001161fULL, 0x00010d727f007947ULL, 0x000fea000b800000ULL,
0x00001f2978297589ULL, 0x0002e400000e0000ULL, 0x000000292c2c7220ULL, 0x08cfe20000410000ULL,
0x000000292d2d7220ULL, 0x080fe20000410000ULL, 0x0000002930307220ULL, 0x080fe20000410000ULL,
0x0000002931317220ULL, 0x080fe20000410000ULL, 0x0000002934347220ULL, 0x080fe20000410000ULL,
0x0000002935357220ULL, 0x080fe20000410000ULL, 0x0000002938387220ULL, 0x080fe20000410000ULL,
0x0000002939397220ULL, 0x080fe20000410000ULL, 0x000000293c3c7220ULL, 0x080fe20000410000ULL,
0x000000293d3d7220ULL, 0x080fe20000410000ULL, 0x0000002940407220ULL, 0x080fe20000410000ULL,
0x0000002941417220ULL, 0x080fe20000410000ULL, 0x0000002944447220ULL, 0x080fe20000410000ULL,
0x0000002945457220ULL, 0x080fe20000410000ULL, 0x0000002948487220ULL, 0x080fe20000410000ULL,
0x0000002949497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0072ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000081f297811ULL, 0x000fe200078ff0ffULL,
0x00010c427f007947ULL, 0x000fea000b800000ULL, 0x00001f2978297589ULL, 0x00066400000e0000ULL,
0x000000292e2e7220ULL, 0x086fe20000410000ULL, 0x000000292f2f7220ULL, 0x080fe20000410000ULL,
0x0000002932327220ULL, 0x080fe20000410000ULL, 0x0000002933337220ULL, 0x080fe20000410000ULL,
0x0000002936367220ULL, 0x080fe20000410000ULL, 0x0000002937377220ULL, 0x080fe20000410000ULL,
0x000000293a3a7220ULL, 0x080fe20000410000ULL, 0x000000293b3b7220ULL, 0x080fe20000410000ULL,
0x000000293e3e7220ULL, 0x080fe20000410000ULL, 0x000000293f3f7220ULL, 0x080fe20000410000ULL,
0x0000002942427220ULL, 0x080fe20000410000ULL, 0x0000002943437220ULL, 0x080fe20000410000ULL,
0x0000002946467220ULL, 0x080fe20000410000ULL, 0x0000002947477220ULL, 0x080fe20000410000ULL,
0x000000294a4a7220ULL, 0x080fe20000410000ULL, 0x000000294b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000072ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000101f297811ULL, 0x000fe200078ff0ffULL, 0x00010b127f007947ULL, 0x000fea000b800000ULL,
0x00001f2978297589ULL, 0x0002e400000e0000ULL, 0x000000294c4c7220ULL, 0x08cfe20000410000ULL,
0x000000294d4d7220ULL, 0x080fe20000410000ULL, 0x0000002950507220ULL, 0x080fe20000410000ULL,
0x0000002951517220ULL, 0x080fe20000410000ULL, 0x0000002954547220ULL, 0x080fe20000410000ULL,
0x0000002955557220ULL, 0x080fe20000410000ULL, 0x0000002958587220ULL, 0x080fe20000410000ULL,
0x0000002959597220ULL, 0x080fe20000410000ULL, 0x000000295c5c7220ULL, 0x080fe20000410000ULL,
0x000000295d5d7220ULL, 0x080fe20000410000ULL, 0x0000002960607220ULL, 0x080fe20000410000ULL,
0x0000002961617220ULL, 0x080fe20000410000ULL, 0x0000002964647220ULL, 0x080fe20000410000ULL,
0x0000002965657220ULL, 0x080fe20000410000ULL, 0x0000002968687220ULL, 0x080fe20000410000ULL,
0x0000002969697220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000072ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000181f297811ULL, 0x000fe200078ff0ffULL, 0x000109f27f007947ULL, 0x000fea000b800000ULL,
0x00001f2978297589ULL, 0x0002e400000e0000ULL, 0x000000294e4e7220ULL, 0x08cfe20000410000ULL,
0x000000294f4f7220ULL, 0x080fe20000410000ULL, 0x0000002952527220ULL, 0x080fe20000410000ULL,
0x0000002953537220ULL, 0x080fe20000410000ULL, 0x0000002956567220ULL, 0x080fe20000410000ULL,
0x0000002957577220ULL, 0x080fe20000410000ULL, 0x000000295a5a7220ULL, 0x080fe20000410000ULL,
0x000000295b5b7220ULL, 0x080fe20000410000ULL, 0x000000295e5e7220ULL, 0x080fe20000410000ULL,
0x000000295f5f7220ULL, 0x080fe20000410000ULL, 0x0000002962627220ULL, 0x080fe20000410000ULL,
0x0000002963637220ULL, 0x080fe20000410000ULL, 0x0000002966667220ULL, 0x080fe20000410000ULL,
0x0000002967677220ULL, 0x080fe20000410000ULL, 0x000000296a6a7220ULL, 0x080fe20000410000ULL,
0x000000296b6b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000007225ff7212ULL, 0x000fe200078030ffULL, 0x00000001ff2a7424ULL, 0x000fe200078e00ffULL,
0x0000002324237209ULL, 0x000fd60007810000ULL, 0x8000002324240221ULL, 0x000fe20000010000ULL,
0x00007610ff2a0816ULL, 0x000fc6000000002aULL, 0x3fb8aa3b24240820ULL, 0x000fc80000410000ULL,
0x0000002400110308ULL, 0x000e640000000800ULL, 0x0000001170700220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002170217221ULL, 0x004fc20000010000ULL,
0x0000000000247805ULL, 0x000fcc0000015200ULL, 0x0000000820287824ULL, 0x000fca00078e00ffULL,
0xfffffff028707812ULL, 0x000fca00078ec0ffULL, 0x0126b40070297984ULL, 0x000e640000000800ULL,
0x8000000029ff7812ULL, 0x002fe40007804827ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff717224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000107100780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000287805ULL, 0x000fcc0000015200ULL,
0x00000028242b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000129297824ULL, 0x000fe200000e0e25ULL,
0x003d09002b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff287819ULL, 0x000fc80000011429ULL, 0x0000002b28287211ULL, 0x000fca00078110ffULL,
0x000000ffff297224ULL, 0x000fca00000e0629ULL, 0x0000000228287819ULL, 0x000fc80000001229ULL,
0x000000280000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000171717810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0126b40070297984ULL, 0x000e640000000800ULL, 0x8000000029ff7812ULL, 0x002fe40007804827ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099102a247816ULL, 0x000fc800000000ffULL,
0x000000ff2400720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000011ff0c723eULL, 0x000fe400000000ffULL, 0x00000002ff257819ULL, 0x000fe4000001161fULL,
0x000054100c0c7816ULL, 0x000fe2000000000cULL, 0x000105b27f007947ULL, 0x000fea000b800000ULL,
0x00001f250c0f7589ULL, 0x0002a400000e0000ULL, 0x0000000825297810ULL, 0x000fe20007ffe0ffULL,
0x000105e27f007947ULL, 0x000fea000b800000ULL, 0x00000010250d7810ULL, 0x000fe20007ffe0ffULL,
0x00001f290c0e7589ULL, 0x0002ea00000e0000ULL, 0x00001f0d0c0d7589ULL, 0x0002a400000e0000ULL,
0x0000001825297810ULL, 0x002fe20007ffe0ffULL, 0x000106327f007947ULL, 0x000fea000b800000ULL,
0x00001f290c0c7589ULL, 0x0002e400000e0000ULL, 0x0000040020247824ULL, 0x040fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000100020257824ULL, 0x000fe200078e00ffULL,
0x0000013000007945ULL, 0x000fe40003800000ULL, 0xfffff00024247812ULL, 0x000fc400078ec0ffULL,
0xffffe00025257812ULL, 0x000fe400078ec0ffULL, 0x0000b000247d7810ULL, 0x000fe40007ffe0ffULL,
0x0000f00025787810ULL, 0x008fc60007ffe0ffULL, 0x000000100a247824ULL, 0x100fe400078e027dULL,
0x0000001008287824ULL, 0x000fe400078e027dULL, 0x0000001007707824ULL, 0x000fe400078e0278ULL,
0x000000002424783bULL, 0x000ee80000000200ULL, 0x000000002828783bULL, 0x002e620000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000f24247232ULL, 0x08cfe40000000000ULL,
0x0000000f26267232ULL, 0x000fc40000000000ULL, 0x0000000e25257232ULL, 0x080fe40000000000ULL,
0x0000000e27277232ULL, 0x000fe40000000000ULL, 0x0000000d28287232ULL, 0x082fe40000000000ULL,
0x0000000d2a2a7232ULL, 0x000fe40000000000ULL, 0x0000000c29297232ULL, 0x080fe40000000000ULL,
0x0000000c2b2b7232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000007070783bULL, 0x000f220000004200ULL, 0x0000001006787824ULL, 0x000fe200078e0278ULL,
0x0000082000007945ULL, 0x000fea0003800000ULL, 0x000000007878783bULL, 0x000ee20000004200ULL,
0x00000010ff7c7819ULL, 0x010fc40000011670ULL, 0x000000ff707f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff877819ULL, 0x100fe40000011672ULL, 0x000000ff72897812ULL, 0x040fe400078ec0ffULL,
0x00000018ff887819ULL, 0x000fe40000011672ULL, 0x0000ffff72997812ULL, 0x000fe400078ec0ffULL,
0x00000018ff727819ULL, 0x000fc40000011673ULL, 0x0000ffff70977812ULL, 0x000fe400078ec0ffULL,
0x00000018ff7e7819ULL, 0x000fe40000011670ULL, 0x00000010ff837819ULL, 0x000fe40000011671ULL,
0x000000ff7c7c7812ULL, 0x000fe400078ec0ffULL, 0x0000007fff70723eULL, 0x000fe400020006ffULL,
0x00000072ff7f723eULL, 0x000fc400020006ffULL, 0x00000008ff727819ULL, 0x000fe40000011697ULL,
0x000000ff71867812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8c7819ULL, 0x008fe40000011678ULL,
0x000000ff83837812ULL, 0x000fe400078ec0ffULL, 0x0000007cff7c723eULL, 0x000fe400020006ffULL,
0x0000ffff789b7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff857819ULL, 0x000fe40000011671ULL,
0x0000ffff71987812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8a7819ULL, 0x000fe40000011673ULL,
0x000000ff738b7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff739a7812ULL, 0x000fe400078ec0ffULL,
0x0000007eff7e723eULL, 0x000fc400020006ffULL, 0x00000072ff72723eULL, 0x000fe400020006ffULL,
0x000000ff78737812ULL, 0x000fe400078ec0ffULL, 0x00000086ff71723eULL, 0x000fe400020006ffULL,
0x00000083ff83723eULL, 0x000fe400020006ffULL, 0x0000541070707816ULL, 0x000fe4000000007cULL,
0x000000ff87877812ULL, 0x000fc400078ec0ffULL, 0x000000ff8c8c7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff8d7819ULL, 0x000fe40000011678ULL, 0x0000ffff799c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff917819ULL, 0x000fe4000001167aULL, 0x00000008ff7c7819ULL, 0x000fe4000001169bULL,
0x000000ff7a937812ULL, 0x000fc400078ec0ffULL, 0x00000018ff927819ULL, 0x000fe4000001167aULL,
0x0000ffff7a9d7812ULL, 0x000fe400078ec0ffULL, 0x0000541072727816ULL, 0x000fe4000000007eULL,
0x00000010ff947819ULL, 0x100fe4000001167bULL, 0x000000ff7b967812ULL, 0x000fe400078ec0ffULL,
0x00000018ff957819ULL, 0x000fc4000001167bULL, 0x0000ffff7b9e7812ULL, 0x000fe400078ec0ffULL,
0x00000089ff78723eULL, 0x000fe400020006ffULL, 0x00000073ff86723eULL, 0x000fe400020006ffULL,
0x0000541071717816ULL, 0x000fe40000000083ULL, 0x00000087ff87723eULL, 0x000fe400020006ffULL,
0x00000008ff7a7819ULL, 0x000fc40000011699ULL, 0x0000008cff7e723eULL, 0x000fe200020006ffULL,
0x00000070242c723cULL, 0x080f62000000182cULL, 0x0000008dff8d723eULL, 0x000fe400020006ffULL,
0x00000008ff7b7819ULL, 0x000fe4000001169aULL, 0x00000008ff837819ULL, 0x000fe4000001169cULL,
0x0000007cff7c723eULL, 0x000fe200020006ffULL, 0x00000070284c723cULL, 0x002b62000000184cULL,
0x000000ff91917812ULL, 0x000fc400078ec0ffULL, 0x00000010ff8e7819ULL, 0x000fe40000011679ULL,
0x00000088ff88723eULL, 0x000fe400020006ffULL, 0x0000541078787816ULL, 0x000fe20000000087ULL,
0x0000001005707824ULL, 0x120fe200078e027dULL, 0x0000007aff7a723eULL, 0x000fe200020006ffULL,
0x00000010047d7824ULL, 0x000fe200078e027dULL, 0x00005410867e7816ULL, 0x000fe4000000007eULL,
0x0000007bff7b723eULL, 0x000fc400020006ffULL, 0x00000093ff93723eULL, 0x000fe400020006ffULL,
0x00000083ff87723eULL, 0x000fe400020006ffULL, 0x000054107c867816ULL, 0x000fe4000000008dULL,
0x00000091ff91723eULL, 0x000fe400020006ffULL, 0x000000ff79907812ULL, 0x000fe400078ec0ffULL,
0x00000018ff8f7819ULL, 0x000fc40000011679ULL, 0x00000008ff737819ULL, 0x000fe40000011698ULL,
0x000000ff8a8a7812ULL, 0x000fe400078ec0ffULL, 0x000000ff8e8e7812ULL, 0x000fe400078ec0ffULL,
0x000000ff94947812ULL, 0x000fe400078ec0ffULL, 0x00000008ff7c7819ULL, 0x000fe4000001169dULL,
0x00000008ff837819ULL, 0x000fc4000001169eULL, 0x000054107a7a7816ULL, 0x000fe40000000088ULL,
0x000054107b7b7816ULL, 0x000fe4000000007fULL, 0x0000541093887816ULL, 0x000fe40000000091ULL,
0x00000085ff85723eULL, 0x000fe400020006ffULL, 0x0000008bff79723eULL, 0x000fe200020006ffULL,
0x0000007a2438723cULL, 0x000f620000001838ULL, 0x00000090ff90723eULL, 0x000fc400020006ffULL,
0x00000073ff73723eULL, 0x000fe400020006ffULL, 0x0000008aff8a723eULL, 0x000fe400020006ffULL,
0x0000008fff8f723eULL, 0x000fe200020006ffULL, 0x0000007a2858723cULL, 0x000f620000001858ULL,
0x0000008eff7f723eULL, 0x000fe400020006ffULL, 0x00000096ff89723eULL, 0x000fe400020006ffULL,
0x00000092ff92723eULL, 0x000fc400020006ffULL, 0x00000094ff94723eULL, 0x000fe400020006ffULL,
0x00000095ff95723eULL, 0x000fe400020006ffULL, 0x0000007cff7c723eULL, 0x000fe400020006ffULL,
0x00000083ff93723eULL, 0x000fe400020006ffULL, 0x0000541073737816ULL, 0x000fe40000000085ULL,
0x0000541079797816ULL, 0x000fc4000000008aULL, 0x00005410907f7816ULL, 0x000fe4000000007fULL,
0x0000541087877816ULL, 0x000fe2000000008fULL, 0x000000722430723cULL, 0x000f620000001830ULL,
0x0000541089897816ULL, 0x000fe40000000094ULL, 0x000054107c927816ULL, 0x000fe40000000092ULL,
0x0000541093937816ULL, 0x000fc60000000095ULL, 0x000000782434723cULL, 0x040f700000001834ULL,
0x0000007e243c723cULL, 0x040f70000000183cULL, 0x000000862440723cULL, 0x040f700000001840ULL,
0x000000882444723cULL, 0x040f700000001844ULL, 0x000000922448723cULL, 0x000b6e0000001848ULL,
0x0000100003247810ULL, 0x020fe20007ffe0ffULL, 0x000000722850723cULL, 0x000b640000001850ULL,
0x000000007070783bULL, 0x020e640000000200ULL, 0x0000001002257824ULL, 0x000fc800078e0224ULL,
0x000000782854723cULL, 0x040f700000001854ULL, 0x0000007e285c723cULL, 0x040f70000000185cULL,
0x000000862860723cULL, 0x040f700000001860ULL, 0x000000882864723cULL, 0x040f700000001864ULL,
0x000000922868723cULL, 0x000b640000001868ULL, 0x000000007d28783bULL, 0x0206a20000000200ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x0000008000000947ULL, 0x000fde0003800000ULL,
0x0000000f70707232ULL, 0x086fe40000000000ULL, 0x0000000f72727232ULL, 0x000fc40000000000ULL,
0x0000000e71717232ULL, 0x080fe40000000000ULL, 0x0000000e73737232ULL, 0x000fe40000000000ULL,
0x0000000d28287232ULL, 0x080fe40000000000ULL, 0x0000000d2a2a7232ULL, 0x000fe40000000000ULL,
0x0000000c29297232ULL, 0x080fe40000000000ULL, 0x0000000c2b2b7232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x002fea0003800000ULL, 0x000000002578783bULL, 0x000e620000004200ULL,
0x00000010007c7824ULL, 0x000fcc00078e0224ULL, 0x000000007c7c783bULL, 0x008ee20000004200ULL,
0x00000010ff267819ULL, 0x102fe40000011678ULL, 0x000000ff78837812ULL, 0x040fe400078ec0ffULL,
0x00000018ff277819ULL, 0x000fe40000011678ULL, 0x0000ffff78977812ULL, 0x000fe400078ec0ffULL,
0x00000010ff787819ULL, 0x000fe40000011679ULL, 0x00000010ff877819ULL, 0x000fc4000001167aULL,
0x000000ff7a897812ULL, 0x040fe400078ec0ffULL, 0x00000018ff887819ULL, 0x000fe4000001167aULL,
0x0000ffff7a997812ULL, 0x000fe400078ec0ffULL, 0x000000ff78787812ULL, 0x000fe400078ec0ffULL,
0x00000018ff7a7819ULL, 0x000fe4000001167bULL, 0x000000ff79867812ULL, 0x000fc400078ec0ffULL,
0x00000018ff857819ULL, 0x000fe40000011679ULL, 0x0000ffff79987812ULL, 0x000fe400078ec0ffULL,
0x000000ff26267812ULL, 0x000fe400078ec0ffULL, 0x00000027ff79723eULL, 0x000fe400020006ffULL,
0x00000010ff917819ULL, 0x008fe4000001167eULL, 0x000000ff7e937812ULL, 0x000fc400078ec0ffULL,
0x00000018ff927819ULL, 0x000fe4000001167eULL, 0x0000ffff7e9d7812ULL, 0x000fe400078ec0ffULL,
0x00000078ff27723eULL, 0x000fe400020006ffULL, 0x0000007aff7e723eULL, 0x000fe400020006ffULL,
0x00000008ff787819ULL, 0x000fe40000011697ULL, 0x00000083ff83723eULL, 0x000fc400020006ffULL,
0x00000026ff26723eULL, 0x000fe400020006ffULL, 0x00000008ff7a7819ULL, 0x000fe40000011698ULL,
0x0000ffff7c9b7812ULL, 0x040fe400078ec0ffULL, 0x000000ff7b8b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8c7819ULL, 0x000fe4000001167cULL, 0x000000ff7c8e7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff8d7819ULL, 0x000fe4000001167cULL, 0x00000018ff7c7819ULL, 0x000fe4000001167dULL,
0x00000078ff78723eULL, 0x000fe400020006ffULL, 0x00000085ff85723eULL, 0x000fe400020006ffULL,
0x0000541083267816ULL, 0x000fe40000000026ULL, 0x0000007aff7a723eULL, 0x000fc400020006ffULL,
0x00000010ff8a7819ULL, 0x000fe4000001167bULL, 0x0000ffff7b9a7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff7d9c7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff837819ULL, 0x000fe4000001169bULL,
0x0000008bff7b723eULL, 0x000fe400020006ffULL, 0x0000541078787816ULL, 0x000fc40000000079ULL,
0x0000007cff8b723eULL, 0x000fe400020006ffULL, 0x00000010ff8f7819ULL, 0x000fe4000001167dULL,
0x000000ff7d907812ULL, 0x000fe400078ec0ffULL, 0x00000086ff86723eULL, 0x000fe400020006ffULL,
0x000000ff87877812ULL, 0x000fe400078ec0ffULL, 0x000054107a797816ULL, 0x000fc40000000085ULL,
0x00000008ff7c7819ULL, 0x000fe40000011699ULL, 0x0000008dff8d723eULL, 0x000fe400020006ffULL,
0x00000008ff7d7819ULL, 0x000fe2000001169aULL, 0x000000787030723cULL, 0x000f620000001830ULL,
0x00000008ff857819ULL, 0x000fe4000001169cULL, 0x00000083ff83723eULL, 0x000fe400020006ffULL,
0x000000ff91917812ULL, 0x000fc400078ec0ffULL, 0x00000010ff947819ULL, 0x000fe2000001167fULL,
0x000000782850723cULL, 0x004f620000001850ULL, 0x0000ffff7f9e7812ULL, 0x000fe400078ec0ffULL,
0x00000088ff88723eULL, 0x000fe400020006ffULL, 0x0000541086277816ULL, 0x000fe40000000027ULL,
0x00000087ff7a723eULL, 0x000fe400020006ffULL, 0x0000007cff7c723eULL, 0x000fc400020006ffULL,
0x00000089ff89723eULL, 0x000fe200020006ffULL, 0x00000026702c723cULL, 0x080f62000000182cULL,
0x0000007dff7d723eULL, 0x000fe400020006ffULL, 0x00000093ff93723eULL, 0x000fe400020006ffULL,
0x00000085ff87723eULL, 0x000fe400020006ffULL, 0x0000541083867816ULL, 0x000fe2000000008dULL,
0x00000026284c723cULL, 0x000b62000000184cULL, 0x00000091ff91723eULL, 0x000fc400020006ffULL,
0x000000ff7f967812ULL, 0x000fe400078ec0ffULL, 0x00000018ff957819ULL, 0x000fe4000001167fULL,
0x000000ff8a8a7812ULL, 0x000fe200078ec0ffULL, 0x0000000220267824ULL, 0x020fe200078e00ffULL,
0x000000ff8c8c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff8f8f7812ULL, 0x000fe400078ec0ffULL,
0x000000ff94947812ULL, 0x000fc400078ec0ffULL, 0x00000008ff837819ULL, 0x000fe4000001169dULL,
0x00000008ff857819ULL, 0x000fe4000001169eULL, 0x000054107c7c7816ULL, 0x000fe40000000088ULL,
0x00005410897a7816ULL, 0x000fe4000000007aULL, 0x000054107d7d7816ULL, 0x000fe4000000007eULL,
0x0000541093887816ULL, 0x000fc40000000091ULL, 0x0000008eff8e723eULL, 0x000fe400020006ffULL,
0x00000090ff7f723eULL, 0x000fe200020006ffULL, 0x0000007c7038723cULL, 0x080f620000001838ULL,
0x0000008aff8a723eULL, 0x000fe400020006ffULL, 0x0000008cff7e723eULL, 0x000fe400020006ffULL,
0x0000008fff8f723eULL, 0x000fe400020006ffULL, 0x00000096ff89723eULL, 0x000fe200020006ffULL,
0x0000007c2858723cULL, 0x000f620000001858ULL, 0x00000092ff92723eULL, 0x000fc400020006ffULL,
0x00000094ff94723eULL, 0x000fe400020006ffULL, 0x00000095ff95723eULL, 0x000fe400020006ffULL,
0x00000083ff83723eULL, 0x000fe400020006ffULL, 0x00000085ff93723eULL, 0x000fe400020006ffULL,
0x000054107b7b7816ULL, 0x000fe4000000008aULL, 0x000054108e7e7816ULL, 0x000fc4000000007eULL,
0x000054107f7f7816ULL, 0x000fe4000000008fULL, 0x0000541087877816ULL, 0x000fe2000000008bULL,
0x0000007a7034723cULL, 0x040f620000001834ULL, 0x0000541089897816ULL, 0x000fe40000000094ULL,
0x0000541083927816ULL, 0x000fe40000000092ULL, 0x0000541093937816ULL, 0x000fe40000000095ULL,
0xfffffff826267812ULL, 0x000fe200078ec0ffULL, 0x0000007e703c723cULL, 0x040f70000000183cULL,
0x000000867040723cULL, 0x040f700000001840ULL, 0x000000887044723cULL, 0x040f700000001844ULL,
0x000000927048723cULL, 0x000f700000001848ULL, 0x0000007a2854723cULL, 0x040f700000001854ULL,
0x0000007e285c723cULL, 0x040f70000000185cULL, 0x000000862860723cULL, 0x040f700000001860ULL,
0x000000882864723cULL, 0x040f700000001864ULL, 0x000000922868723cULL, 0x000b6e0000001868ULL,
0x000126c81a2a7811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x000000002a2a7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126900026ff7f8cULL, 0x0005e4000c80043fULL, 0x0000000000267805ULL, 0x004fc40000015200ULL,
0x0000040014297984ULL, 0x000ea40000000800ULL, 0x8000000029ff7812ULL, 0x006fc4000780482bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff707224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000107000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x0000002826717210ULL, 0x000fca0007f1e1ffULL,
0x0000000129297824ULL, 0x000fe200000e0e27ULL, 0x003d09007100780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c407100780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff287819ULL, 0x000fc80000011429ULL,
0x0000007128287211ULL, 0x000fca00078110ffULL, 0x000000ffff297224ULL, 0x000fca00000e0629ULL,
0x0000000228287819ULL, 0x000fc80000001229ULL, 0x000000280000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000170707810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040014297984ULL, 0x000e640000000800ULL,
0x8000000029ff7812ULL, 0x002fe4000780482bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010016267824ULL, 0x000fca00078e0277ULL, 0x000000c026297810ULL, 0x000fc80007ffe0ffULL,
0x0000006029287812ULL, 0x000fca00078ec0ffULL, 0x0000000119787824ULL, 0x000fe200078e0228ULL,
0x000003e00000a947ULL, 0x000fea0003800000ULL, 0x0000001020287824ULL, 0x000fe200078e00ffULL,
0x000000291e277217ULL, 0x000fe40007800000ULL, 0x00000003ff707819ULL, 0x000fe4000001161fULL,
0x00000010287a7812ULL, 0x000fe200078ec0ffULL, 0x0000000127277824ULL, 0x000fe200078e0a29ULL,
0x00000004702b7810ULL, 0x040fe40007ffe0ffULL, 0x0000000870727810ULL, 0x040fe20007ffe0ffULL,
0x0000000170797824ULL, 0x100fe200078e027aULL, 0x000000277a277217ULL, 0x000fe20007800000ULL,
0x000000012b7b7824ULL, 0x000fe200078e027aULL, 0x0000000c707d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000179287824ULL, 0x000fc400078e0278ULL, 0x0000000127277824ULL, 0x000fe400078e0a7aULL,
0x0000008028287825ULL, 0x000fc600078e00ffULL, 0x000000272b00720cULL, 0x000fe20003f66070ULL,
0x000000017b2a7824ULL, 0x000fe200078e0278ULL, 0x0000001328717212ULL, 0x000fe200078efcffULL,
0x00000001727c7824ULL, 0x000fe200078e027aULL, 0x000000277000720cULL, 0x000fe20003f86070ULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x000000716e707210ULL, 0x000fe40007fbe0ffULL,
0x000000277200720cULL, 0x000fe20003f06070ULL, 0x000000017c287824ULL, 0x000fe200078e0278ULL,
0x000000132a737212ULL, 0x000fe200078efcffULL, 0x000000017d7e7824ULL, 0x000fc400078e027aULL,
0x000000016f717824ULL, 0x000fe200028e0629ULL, 0x000000736e727210ULL, 0x000fe20007fde0ffULL,
0x0000008028287825ULL, 0x000fe200078e00ffULL, 0x000000277d00720cULL, 0x000fc60003fa6070ULL,
0x000000017e2a7824ULL, 0x000fe200078e0278ULL, 0x0000001328277212ULL, 0x000fe200078efcffULL,
0x000000016f737824ULL, 0x000fe400030e062bULL, 0x0000000179787824ULL, 0x140fe200078e021fULL,
0x000000276e287210ULL, 0x000fe20007fde0ffULL, 0x0000000879797824ULL, 0x000fe400078e00ffULL,
0x000000017b7a7824ULL, 0x000fe400078e021fULL, 0x000000802a2a7825ULL, 0x000fe200078e00ffULL,
0xfffffff879797812ULL, 0x000fc600078ee278ULL, 0x000000087b7b7824ULL, 0x000fe200078e00ffULL,
0x000000132a277212ULL, 0x000fe200078efcffULL, 0x000000017c787824ULL, 0x140fe400078e021fULL,
0x000000087c7d7824ULL, 0x000fe200078e00ffULL, 0xfffffff87b7b7812ULL, 0x000fe200078ee27aULL,
0x000000017e7a7824ULL, 0x040fe400078e021fULL, 0x000000087e7f7824ULL, 0x000fe200078e00ffULL,
0xfffffff87d7d7812ULL, 0x000fe200078ee278ULL, 0x000000016f297824ULL, 0x000fe200030e0629ULL,
0x000000276e2a7210ULL, 0x000fe20007fde0ffULL, 0x0000001079277824ULL, 0x000fe200078e0224ULL,
0xfffffff87f7f7812ULL, 0x000fe200078ee27aULL, 0x000000107d797824ULL, 0x000fc400078e0224ULL,
0x000000016f2b7824ULL, 0x000fe200030e062bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000070277faeULL, 0x0003e2000e101c48ULL, 0x000000107b6f7824ULL, 0x100fe400078e0224ULL,
0x000000107f7b7824ULL, 0x000fc600078e0224ULL, 0x00000000726f7faeULL, 0x0003e8000d901c48ULL,
0x0000000028797faeULL, 0x0003e8000c101c48ULL, 0x000000002a7b7faeULL, 0x0003e2000e901c48ULL,
0x0000031000007947ULL, 0x000fea0003800000ULL, 0x0000001020277824ULL, 0x000fca00078e00ffULL,
0x0000001027287812ULL, 0x000fc800078ec0ffULL, 0x000000281f277211ULL, 0x000fc800078fe8ffULL,
0x00000004272a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000127287824ULL, 0x140fe200078e021fULL,
0x0000000827707810ULL, 0x040fe20007ffe0ffULL, 0x00000008277d7824ULL, 0x000fe400078e00ffULL,
0x000000012a297824ULL, 0x140fe400078e021fULL, 0x000000082a727824ULL, 0x000fe200078e00ffULL,
0xfffffff87d7d7812ULL, 0x000fe200078ee228ULL, 0x0000000127287824ULL, 0x040fe200078e0278ULL,
0x0000000c27277810ULL, 0x000fe20007ffe0ffULL, 0x00000001702b7824ULL, 0x000fe200078e021fULL,
0xfffffff8727f7812ULL, 0x000fe200078ee229ULL, 0x00000008707a7824ULL, 0x000fc400078e00ffULL,
0x0000008028287825ULL, 0x000fc600078e00ffULL, 0xfffffff87a837812ULL, 0x000fe200078ee22bULL,
0x000000012a2a7824ULL, 0x100fe400078e0278ULL, 0x0000000170707824ULL, 0x100fe400078e0278ULL,
0x0000000127727824ULL, 0x040fe400078e0278ULL, 0x0000000127787824ULL, 0x040fe400078e021fULL,
0x0000000827857824ULL, 0x000fe200078e00ffULL, 0x0000001328277212ULL, 0x000fe200078efcffULL,
0x000000802a2a7825ULL, 0x000fc600078e00ffULL, 0x000000276e287210ULL, 0x000fe20007f1e0ffULL,
0x0000008070707825ULL, 0x000fe200078e00ffULL, 0x000000132a7b7212ULL, 0x080fe400078efcffULL,
0xfffffff885857812ULL, 0x000fe200078ee278ULL, 0x0000008072727825ULL, 0x000fe200078e00ffULL,
0x0000001370797212ULL, 0x000fe400078efcffULL, 0x0000007b6e2a7210ULL, 0x000fe20007f7e0ffULL,
0x000000016f297824ULL, 0x000fe200000e0629ULL, 0x0000001372277212ULL, 0x000fe200078efcffULL,
0x00000010857b7824ULL, 0x100fe200078e0224ULL, 0x000000796e707210ULL, 0x040fe20007f1e0ffULL,
0x000000016f2b7824ULL, 0x000fe200018e062bULL, 0x000000276e6e7210ULL, 0x000fe20007f9e0ffULL,
0x000000107d277824ULL, 0x000fc400078e0224ULL, 0x000000016f717824ULL, 0x040fe400000e0671ULL,
0x000000016f6f7824ULL, 0x000fe200020e0673ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028277faeULL, 0x0003e2000b901c48ULL, 0x000000107f737824ULL, 0x100fe400078e0224ULL,
0x0000001083797824ULL, 0x000fc600078e0224ULL, 0x000000002a737faeULL, 0x0003e8000b901c48ULL,
0x0000000070797faeULL, 0x0003e8000b901c48ULL, 0x000000006e7b7faeULL, 0x0003e4000b901c48ULL,
0x000000021b1b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000804057890ULL, 0x000fe2000fffe03fULL,
0xffffffffff277424ULL, 0x002fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000001d1b00720cULL, 0x000fcc0003f06070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fee0008000a05ULL,
0x000000011b288824ULL, 0x000fe400078e0218ULL, 0x00000004ff298424ULL, 0x000fc800078e00ffULL,
0x0000640028288625ULL, 0x000fca00078e0029ULL, 0x0000000828278981ULL, 0x000322000c1e1900ULL,
0x00000008202a7824ULL, 0x000fca00078e00ffULL, 0xfffffff02a2a7812ULL, 0x000fe200078ec0ffULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126b0002a6e7f8cULL, 0x0004e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126480022707f8cULL, 0x0002a4000c80043fULL, 0x0000000000287805ULL, 0x002fc40000015200ULL,
0x01264c00222b7984ULL, 0x000e640000000800ULL, 0x800000002bff7812ULL, 0x006fe40007804871ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff727224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000107200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002a7805ULL, 0x000fcc0000015200ULL, 0x0000002a28737210ULL, 0x000fca0007f1e1ffULL,
0x000000012b2b7824ULL, 0x000fe200000e0e29ULL, 0x003d09007300780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c407300780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff2a7819ULL, 0x000fc8000001142bULL,
0x000000732a2a7211ULL, 0x000fca00078110ffULL, 0x000000ffff2b7224ULL, 0x000fca00000e062bULL,
0x000000022a2a7819ULL, 0x000fc8000000122bULL, 0x0000002a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000172727810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01264c00222b7984ULL, 0x000e640000000800ULL,
0x800000002bff7812ULL, 0x002fe40007804871ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002020227824ULL, 0x000fca00078e00ffULL, 0xffffff8022227812ULL, 0x000fc800078ec0ffULL,
0x0000010013297810ULL, 0x000fca0007ffe022ULL, 0x0000000112297824ULL, 0x000fca00078e0229ULL,
0x0120000029707984ULL, 0x000e680000000800ULL, 0x0122000029727984ULL, 0x0004e20000000800ULL,
0x000000237000720bULL, 0x002fe20003f1d000ULL, 0x0000e6e27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000717806ULL, 0x004fc800000e0100ULL, 0x000000ff7100720cULL, 0x000fe20003f05270ULL,
0x0000078000007945ULL, 0x000fe20003800000ULL, 0x00000001ff737424ULL, 0x000fe400078e00ffULL,
0x000000ffff227224ULL, 0x000fd200078e0023ULL, 0x0000074000008947ULL, 0x000fea0003800000ULL,
0x0000000217297810ULL, 0x000fe40007ffe0ffULL, 0x000000237000720bULL, 0x000fe40003f74000ULL,
0x000000202900720cULL, 0x000fe20003f05270ULL, 0x0000e6927f007947ULL, 0x000fd4000b800000ULL,
0x0000000000227806ULL, 0x000fc400018e0100ULL, 0x0000008020298824ULL, 0x000fe200078e0213ULL,
0x0000002370288209ULL, 0x000fe20007810000ULL, 0x0000064000017945ULL, 0x000fe40003800000ULL,
0x0000000112298824ULL, 0x000fca00078e0229ULL, 0x0124002829008388ULL, 0x0003e20000000800ULL,
0x000000ff2200720cULL, 0x000fda0003f05270ULL, 0x000005f000008947ULL, 0x000fea0003800000ULL,
0x0000002370287209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff22ff7812ULL, 0x000fc6000780c0ffULL, 0x0000002328287221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b28287820ULL, 0x000fc80000410000ULL, 0x0000002800787308ULL, 0x000e640000000800ULL,
0x0000007821217220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff297819ULL, 0x000fe2000001161fULL, 0x0000e5c27f007947ULL, 0x000fea000b800000ULL,
0x00001f2978297589ULL, 0x0002a400000e0000ULL, 0x000000292c2c7220ULL, 0x084fe20000410000ULL,
0x000000292d2d7220ULL, 0x080fe20000410000ULL, 0x0000002930307220ULL, 0x080fe20000410000ULL,
0x0000002931317220ULL, 0x080fe20000410000ULL, 0x0000002934347220ULL, 0x080fe20000410000ULL,
0x0000002935357220ULL, 0x080fe20000410000ULL, 0x0000002938387220ULL, 0x080fe20000410000ULL,
0x0000002939397220ULL, 0x080fe20000410000ULL, 0x000000293c3c7220ULL, 0x080fe20000410000ULL,
0x000000293d3d7220ULL, 0x080fe20000410000ULL, 0x0000002940407220ULL, 0x080fe20000410000ULL,
0x0000002941417220ULL, 0x080fe20000410000ULL, 0x0000002944447220ULL, 0x080fe20000410000ULL,
0x0000002945457220ULL, 0x080fe20000410000ULL, 0x0000002948487220ULL, 0x080fe20000410000ULL,
0x0000002949497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0022ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000081f297811ULL, 0x000fe200078ff0ffULL,
0x0000e4927f007947ULL, 0x000fea000b800000ULL, 0x00001f2978297589ULL, 0x00046400000e0000ULL,
0x000000292e2e7220ULL, 0x086fe20000410000ULL, 0x000000292f2f7220ULL, 0x080fe20000410000ULL,
0x0000002932327220ULL, 0x080fe20000410000ULL, 0x0000002933337220ULL, 0x080fe20000410000ULL,
0x0000002936367220ULL, 0x080fe20000410000ULL, 0x0000002937377220ULL, 0x080fe20000410000ULL,
0x000000293a3a7220ULL, 0x080fe20000410000ULL, 0x000000293b3b7220ULL, 0x080fe20000410000ULL,
0x000000293e3e7220ULL, 0x080fe20000410000ULL, 0x000000293f3f7220ULL, 0x080fe20000410000ULL,
0x0000002942427220ULL, 0x080fe20000410000ULL, 0x0000002943437220ULL, 0x080fe20000410000ULL,
0x0000002946467220ULL, 0x080fe20000410000ULL, 0x0000002947477220ULL, 0x080fe20000410000ULL,
0x000000294a4a7220ULL, 0x080fe20000410000ULL, 0x000000294b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000022ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000101f297811ULL, 0x000fe200078ff0ffULL, 0x0000e3627f007947ULL, 0x000fea000b800000ULL,
0x00001f2978297589ULL, 0x00046400000e0000ULL, 0x000000294c4c7220ULL, 0x086fe20000410000ULL,
0x000000294d4d7220ULL, 0x080fe20000410000ULL, 0x0000002950507220ULL, 0x080fe20000410000ULL,
0x0000002951517220ULL, 0x080fe20000410000ULL, 0x0000002954547220ULL, 0x080fe20000410000ULL,
0x0000002955557220ULL, 0x080fe20000410000ULL, 0x0000002958587220ULL, 0x080fe20000410000ULL,
0x0000002959597220ULL, 0x080fe20000410000ULL, 0x000000295c5c7220ULL, 0x080fe20000410000ULL,
0x000000295d5d7220ULL, 0x080fe20000410000ULL, 0x0000002960607220ULL, 0x080fe20000410000ULL,
0x0000002961617220ULL, 0x080fe20000410000ULL, 0x0000002964647220ULL, 0x080fe20000410000ULL,
0x0000002965657220ULL, 0x080fe20000410000ULL, 0x0000002968687220ULL, 0x080fe20000410000ULL,
0x0000002969697220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000022ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000181f297811ULL, 0x000fe200078ff0ffULL, 0x0000e2427f007947ULL, 0x000fea000b800000ULL,
0x00001f2978297589ULL, 0x00046400000e0000ULL, 0x000000294e4e7220ULL, 0x086fe20000410000ULL,
0x000000294f4f7220ULL, 0x080fe20000410000ULL, 0x0000002952527220ULL, 0x080fe20000410000ULL,
0x0000002953537220ULL, 0x080fe20000410000ULL, 0x0000002956567220ULL, 0x080fe20000410000ULL,
0x0000002957577220ULL, 0x080fe20000410000ULL, 0x000000295a5a7220ULL, 0x080fe20000410000ULL,
0x000000295b5b7220ULL, 0x080fe20000410000ULL, 0x000000295e5e7220ULL, 0x080fe20000410000ULL,
0x000000295f5f7220ULL, 0x080fe20000410000ULL, 0x0000002962627220ULL, 0x080fe20000410000ULL,
0x0000002963637220ULL, 0x080fe20000410000ULL, 0x0000002966667220ULL, 0x080fe20000410000ULL,
0x0000002967677220ULL, 0x080fe20000410000ULL, 0x000000296a6a7220ULL, 0x080fe20000410000ULL,
0x000000296b6b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000002271ff7212ULL, 0x000fe200078030ffULL, 0x00000001ff737424ULL, 0x000fe200078e00ffULL,
0x0000002370227209ULL, 0x000fd60007810000ULL, 0x8000002270700221ULL, 0x000fe20000010000ULL,
0x00007610ff730816ULL, 0x000fc60000000073ULL, 0x3fb8aa3b70700820ULL, 0x000fc80000410000ULL,
0x0000007000110308ULL, 0x000e640000000800ULL, 0x0000001172720220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002172217221ULL, 0x008fc20000010000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x0000040010237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe4000780486dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff707224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000107000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a282a7210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2b7824ULL, 0x000fe200000e0e29ULL,
0x003d09002a00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402a00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff237819ULL, 0x000fc8000001142bULL, 0x0000002a23237211ULL, 0x000fca00078110ffULL,
0x000000ffff2a7224ULL, 0x000fca00000e062bULL, 0x0000000223237819ULL, 0x000fc8000000122aULL,
0x000000230000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000170707810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040010237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe4000780486dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991073237816ULL, 0x000fc800000000ffULL,
0x000000ff2300720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000011ff0c723eULL, 0x000fe400000000ffULL, 0x00000002ff237819ULL, 0x000fe4000001161fULL,
0x000054100c0c7816ULL, 0x000fe2000000000cULL, 0x0000de227f007947ULL, 0x000fea000b800000ULL,
0x00001f230c0f7589ULL, 0x0002a400000e0000ULL, 0x0000000823297810ULL, 0x000fe20007ffe0ffULL,
0x0000de527f007947ULL, 0x000fea000b800000ULL, 0x00000010230d7810ULL, 0x000fe20007ffe0ffULL,
0x00001f290c0e7589ULL, 0x00066a00000e0000ULL, 0x00001f0d0c0d7589ULL, 0x0006a400000e0000ULL,
0x0000001823297810ULL, 0x008fe20007ffe0ffULL, 0x0000dea27f007947ULL, 0x000fea000b800000ULL,
0x00001f290c0c7589ULL, 0x0022e400000e0000ULL, 0x0000040020237824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000011000007945ULL, 0x000fe20003800000ULL,
0x0000001007787824ULL, 0x000fc400078e0203ULL, 0xfffff00023237812ULL, 0x000fc800078ec0ffULL,
0x0000c00023237810ULL, 0x000fca0007ffe0ffULL, 0x000000100a0a7824ULL, 0x100fe400078e0223ULL,
0x0000001008087824ULL, 0x000fc600078e0223ULL, 0x000000000a70783bULL, 0x0002e80000000200ULL,
0x000000000828783bULL, 0x0022a20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000f70707232ULL, 0x08cfe40000000000ULL, 0x0000000f72727232ULL, 0x000fe40000000000ULL,
0x0000000e71717232ULL, 0x080fe40000000000ULL, 0x0000000e73737232ULL, 0x000fc40000000000ULL,
0x0000000d28287232ULL, 0x080fe40000000000ULL, 0x0000000d2a2a7232ULL, 0x000fe40000000000ULL,
0x0000000c29297232ULL, 0x080fe40000000000ULL, 0x0000000c2b2b7232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000007878783bULL, 0x000e620000004200ULL,
0x00000010067c7824ULL, 0x000fe200078e0203ULL, 0x0000081000007945ULL, 0x000fea0003800000ULL,
0x000000007c7c783bULL, 0x000ee20000004200ULL, 0x00000010ff067819ULL, 0x002fc40000011678ULL,
0x000000ff780a7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff087819ULL, 0x000fe40000011678ULL,
0x0000ffff78957812ULL, 0x000fe400078ec0ffULL, 0x000000ff06067812ULL, 0x000fe400078ec0ffULL,
0x0000000aff6c723eULL, 0x000fe400020006ffULL, 0x00000018ff787819ULL, 0x000fc4000001167aULL,
0x00000008ff0a723eULL, 0x000fe400020006ffULL, 0x00000008ff087819ULL, 0x000fe40000011695ULL,
0x00000010ff8a7819ULL, 0x108fe4000001167cULL, 0x000000ff7c8c7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff8b7819ULL, 0x000fe4000001167cULL, 0x0000ffff7c997812ULL, 0x000fc400078ec0ffULL,
0x00000006ff06723eULL, 0x000fe400020006ffULL, 0x0000ffff7a977812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8d7819ULL, 0x100fe4000001167dULL, 0x000000ff7d8e7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff7c7819ULL, 0x000fe4000001167dULL, 0x0000ffff7d9a7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff7b987812ULL, 0x000fe400078ec0ffULL, 0x00000078ff7d723eULL, 0x000fe400020006ffULL,
0x00000008ff78723eULL, 0x000fe400020006ffULL, 0x000054106c6c7816ULL, 0x000fe40000000006ULL,
0x00000008ff067819ULL, 0x000fe40000011697ULL, 0x00000010ff867819ULL, 0x000fc4000001167aULL,
0x00000010ff877819ULL, 0x100fe4000001167bULL, 0x00000018ff887819ULL, 0x000fe4000001167bULL,
0x00000008ff087819ULL, 0x000fe40000011698ULL, 0x0000541078787816ULL, 0x000fe4000000000aULL,
0x0000007cff0a723eULL, 0x000fe400020006ffULL, 0x00000010ff6d7819ULL, 0x000fc40000011679ULL,
0x000000ff79857812ULL, 0x040fe400078ec0ffULL, 0x00000018ff837819ULL, 0x000fe40000011679ULL,
0x0000ffff79967812ULL, 0x000fe400078ec0ffULL, 0x00000006ff7c723eULL, 0x000fe400020006ffULL,
0x000000ff7a797812ULL, 0x000fe400078ec0ffULL, 0x000000ff7b897812ULL, 0x000fc400078ec0ffULL,
0x00000088ff88723eULL, 0x000fe400020006ffULL, 0x000000ff86867812ULL, 0x000fe400078ec0ffULL,
0x000000ff87877812ULL, 0x000fe400078ec0ffULL, 0x00000008ff08723eULL, 0x000fe400020006ffULL,
0x00000010ff8f7819ULL, 0x000fe4000001167eULL, 0x00000008ff067819ULL, 0x000fc40000011699ULL,
0x000054107c7c7816ULL, 0x000fe4000000007dULL, 0x00000079ff7a723eULL, 0x000fe400020006ffULL,
0x00000089ff7b723eULL, 0x000fe400020006ffULL, 0x00000086ff86723eULL, 0x000fe400020006ffULL,
0x00000087ff87723eULL, 0x000fe400020006ffULL, 0x00005410087d7816ULL, 0x000fc40000000088ULL,
0x000000ff7e917812ULL, 0x040fe400078ec0ffULL, 0x0000008bff8b723eULL, 0x000fe400020006ffULL,
0x00000008ff087819ULL, 0x000fe2000001169aULL, 0x0000007c7038723cULL, 0x000f620000001838ULL,
0x00000006ff06723eULL, 0x000fe400020006ffULL, 0x000000ff8f8f7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff7e9b7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff927819ULL, 0x000fe2000001167fULL,
0x0000007c2858723cULL, 0x004f620000001858ULL, 0x0000ffff7f9c7812ULL, 0x000fe400078ec0ffULL,
0x000054107a7a7816ULL, 0x000fe40000000086ULL, 0x000054107b7b7816ULL, 0x000fe40000000087ULL,
0x00000091ff91723eULL, 0x000fe400020006ffULL, 0x00000008ff87723eULL, 0x000fc400020006ffULL,
0x0000541006867816ULL, 0x000fe2000000008bULL, 0x0000007a7034723cULL, 0x080f620000001834ULL,
0x0000008fff8f723eULL, 0x000fe400020006ffULL, 0x00000018ff907819ULL, 0x000fe4000001167eULL,
0x00000018ff937819ULL, 0x000fe4000001167fULL, 0x000000ff7f947812ULL, 0x000fe200078ec0ffULL,
0x0000007a2854723cULL, 0x000f620000001854ULL, 0x000000ff6d6d7812ULL, 0x000fc400078ec0ffULL,
0x00000008ff797819ULL, 0x000fe40000011696ULL, 0x000000ff8a8a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff8d8d7812ULL, 0x000fe400078ec0ffULL, 0x000000ff92927812ULL, 0x000fe400078ec0ffULL,
0x00000008ff067819ULL, 0x000fe4000001169bULL, 0x00000008ff087819ULL, 0x000fc4000001169cULL,
0x0000541091887816ULL, 0x000fe4000000008fULL, 0x00000085ff85723eULL, 0x000fe400020006ffULL,
0x00000083ff83723eULL, 0x000fe400020006ffULL, 0x0000008cff7e723eULL, 0x000fe400020006ffULL,
0x0000006dff6d723eULL, 0x000fe400020006ffULL, 0x0000008eff7f723eULL, 0x000fc400020006ffULL,
0x00000079ff79723eULL, 0x000fe400020006ffULL, 0x00000090ff90723eULL, 0x000fe400020006ffULL,
0x0000008aff8a723eULL, 0x000fe400020006ffULL, 0x0000008dff8d723eULL, 0x000fe400020006ffULL,
0x00000094ff89723eULL, 0x000fe400020006ffULL, 0x00000092ff92723eULL, 0x000fc400020006ffULL,
0x00000093ff93723eULL, 0x000fe400020006ffULL, 0x00000006ff06723eULL, 0x000fe400020006ffULL,
0x00000008ff91723eULL, 0x000fe400020006ffULL, 0x00005410856d7816ULL, 0x000fe4000000006dULL,
0x0000541079797816ULL, 0x000fe40000000083ULL, 0x000054107e7e7816ULL, 0x000fc4000000008aULL,
0x000054107f7f7816ULL, 0x000fe2000000008dULL, 0x0000006c702c723cULL, 0x040f62000000182cULL,
0x0000541087877816ULL, 0x000fe4000000000aULL, 0x0000541089897816ULL, 0x000fe40000000092ULL,
0x0000541006907816ULL, 0x000fe40000000090ULL, 0x0000541091917816ULL, 0x000fe20000000093ULL,
0x000000787030723cULL, 0x040f700000001830ULL, 0x0000007e703c723cULL, 0x040f70000000183cULL,
0x000000867040723cULL, 0x040f700000001840ULL, 0x000000887044723cULL, 0x040f700000001844ULL,
0x000000907048723cULL, 0x000b6e0000001848ULL, 0x0000001005707824ULL, 0x120fe200078e0223ULL,
0x0000006c284c723cULL, 0x000f62000000184cULL, 0x0000001004237824ULL, 0x000fc800078e0223ULL,
0x000000007070783bULL, 0x000e660000000200ULL, 0x000000782850723cULL, 0x040b6e0000001850ULL,
0x0000001002787824ULL, 0x020fe200078e0203ULL, 0x0000007e285c723cULL, 0x040f70000000185cULL,
0x000000862860723cULL, 0x040f700000001860ULL, 0x000000882864723cULL, 0x040f700000001864ULL,
0x000000902828723cULL, 0x000b640000001868ULL, 0x000000002368783bULL, 0x0204e20000000200ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x0000008000000947ULL, 0x000fde0003800000ULL,
0x0000000f70707232ULL, 0x082fe40000000000ULL, 0x0000000f72727232ULL, 0x000fc40000000000ULL,
0x0000000e71717232ULL, 0x080fe40000000000ULL, 0x0000000e73737232ULL, 0x000fe40000000000ULL,
0x0000000d68687232ULL, 0x088fe40000000000ULL, 0x0000000d6a6a7232ULL, 0x000fe40000000000ULL,
0x0000000c69697232ULL, 0x080fe40000000000ULL, 0x0000000c6b6b7232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000007878783bULL, 0x000ea20000004200ULL,
0x00000010007c7824ULL, 0x000fcc00078e0203ULL, 0x000000007c7c783bULL, 0x000ee20000004200ULL,
0x00000010ff007819ULL, 0x104fe40000011678ULL, 0x000000ff78067812ULL, 0x040fe400078ec0ffULL,
0x00000018ff027819ULL, 0x000fe40000011678ULL, 0x0000ffff78937812ULL, 0x000fe400078ec0ffULL,
0x000000ff00007812ULL, 0x000fe400078ec0ffULL, 0x00000006ff6c723eULL, 0x000fc400020006ffULL,
0x00000018ff787819ULL, 0x000fe4000001167aULL, 0x00000002ff06723eULL, 0x000fe400020006ffULL,
0x00000008ff027819ULL, 0x000fe40000011693ULL, 0x00000010ff887819ULL, 0x108fe4000001167cULL,
0x000000ff7c8a7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff897819ULL, 0x000fc4000001167cULL,
0x0000ffff7c977812ULL, 0x000fe400078ec0ffULL, 0x00000000ff00723eULL, 0x000fe400020006ffULL,
0x0000ffff7a957812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8b7819ULL, 0x100fe4000001167dULL,
0x000000ff7d8c7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff7c7819ULL, 0x000fc4000001167dULL,
0x0000ffff7d987812ULL, 0x000fe400078ec0ffULL, 0x0000ffff7b967812ULL, 0x000fe400078ec0ffULL,
0x00000078ff7d723eULL, 0x000fe400020006ffULL, 0x00000002ff78723eULL, 0x000fe400020006ffULL,
0x000054106c6c7816ULL, 0x000fe40000000000ULL, 0x00000008ff007819ULL, 0x000fc40000011695ULL,
0x00000018ff867819ULL, 0x000fe4000001167bULL, 0x00000008ff027819ULL, 0x000fe40000011696ULL,
0x0000541078787816ULL, 0x000fe40000000006ULL, 0x0000007cff06723eULL, 0x000fe400020006ffULL,
0x00000000ff7c723eULL, 0x000fe400020006ffULL, 0x00000086ff86723eULL, 0x000fc400020006ffULL,
0x00000002ff02723eULL, 0x000fe400020006ffULL, 0x00000010ff8d7819ULL, 0x000fe4000001167eULL,
0x00000008ff007819ULL, 0x000fe40000011697ULL, 0x000000ff79237812ULL, 0x000fe400078ec0ffULL,
0x000054107c7c7816ULL, 0x000fe4000000007dULL, 0x00000018ff0a7819ULL, 0x000fc40000011679ULL,
0x000000ff7b877812ULL, 0x000fe400078ec0ffULL, 0x000000ff88887812ULL, 0x000fe400078ec0ffULL,
0x00005410027d7816ULL, 0x000fe40000000086ULL, 0x00000010ff087819ULL, 0x000fe40000011679ULL,
0x0000ffff79947812ULL, 0x000fe400078ec0ffULL, 0x00000010ff837819ULL, 0x000fe2000001167aULL,
0x0000007c6858723cULL, 0x000b620000001858ULL, 0x00000010ff857819ULL, 0x000fc4000001167bULL,
0x000000ff7e8f7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff907819ULL, 0x000fe4000001167fULL,
0x00000089ff89723eULL, 0x000fe200020006ffULL, 0x0000007c7038723cULL, 0x002b620000001838ULL,
0x00000008ff027819ULL, 0x000fe40000011698ULL, 0x00000000ff00723eULL, 0x000fe400020006ffULL,
0x000000ff8d8d7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff7e997812ULL, 0x000fe400078ec0ffULL,
0x0000ffff7f9a7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff8e7819ULL, 0x000fe4000001167eULL,
0x00000023ff6d723eULL, 0x000fe400020006ffULL, 0x000000ff7a797812ULL, 0x000fe400078ec0ffULL,
0x0000000aff23723eULL, 0x000fc400020006ffULL, 0x00000087ff7b723eULL, 0x000fe400020006ffULL,
0x0000008aff7e723eULL, 0x000fe400020006ffULL, 0x00000088ff88723eULL, 0x000fe400020006ffULL,
0x000000ff7f927812ULL, 0x000fe400078ec0ffULL, 0x000000ff08087812ULL, 0x000fe400078ec0ffULL,
0x00000008ff0a7819ULL, 0x000fc40000011694ULL, 0x000000ff83837812ULL, 0x000fe400078ec0ffULL,
0x000000ff85857812ULL, 0x000fe400078ec0ffULL, 0x000000ff8b8b7812ULL, 0x000fe400078ec0ffULL,
0x0000008fff8f723eULL, 0x000fe400020006ffULL, 0x00000002ff87723eULL, 0x000fe400020006ffULL,
0x000000ff90907812ULL, 0x000fc400078ec0ffULL, 0x0000541000867816ULL, 0x000fe40000000089ULL,
0x0000008dff8d723eULL, 0x000fe400020006ffULL, 0x00000018ff917819ULL, 0x000fe4000001167fULL,
0x00000008ff007819ULL, 0x000fe40000011699ULL, 0x00000008ff027819ULL, 0x000fe4000001169aULL,
0x00000079ff7a723eULL, 0x000fc400020006ffULL, 0x000054107e7e7816ULL, 0x000fe40000000088ULL,
0x00000008ff08723eULL, 0x000fe400020006ffULL, 0x0000008cff7f723eULL, 0x000fe400020006ffULL,
0x0000000aff79723eULL, 0x000fe400020006ffULL, 0x00000083ff83723eULL, 0x000fe400020006ffULL,
0x00000085ff85723eULL, 0x000fc400020006ffULL, 0x0000008bff8b723eULL, 0x000fe400020006ffULL,
0x00000092ff92723eULL, 0x000fe400020006ffULL, 0x00000090ff89723eULL, 0x000fe400020006ffULL,
0x000054108f887816ULL, 0x000fe4000000008dULL, 0x0000008eff8e723eULL, 0x000fe400020006ffULL,
0x00000091ff91723eULL, 0x000fc400020006ffULL, 0x00000000ff00723eULL, 0x000fe400020006ffULL,
0x00000002ff8f723eULL, 0x000fe400020006ffULL, 0x000054106d6d7816ULL, 0x000fe40000000008ULL,
0x0000541079797816ULL, 0x000fe40000000023ULL, 0x000054107a7a7816ULL, 0x000fe40000000083ULL,
0x000054107b7b7816ULL, 0x000fe20000000085ULL, 0x0000006c684c723cULL, 0x000b62000000184cULL,
0x000054107f7f7816ULL, 0x000fc4000000008bULL, 0x0000541087877816ULL, 0x000fe40000000006ULL,
0x0000541092897816ULL, 0x000fe40000000089ULL, 0x00005410008e7816ULL, 0x000fe2000000008eULL,
0x000000786850723cULL, 0x000b620000001850ULL, 0x000054108f8f7816ULL, 0x000fe20000000091ULL,
0x0000000220007824ULL, 0x000fca00078e00ffULL, 0xfffffff800007812ULL, 0x000fe200078ec0ffULL,
0x0000007a6854723cULL, 0x040b700000001854ULL, 0x0000007e685c723cULL, 0x040b70000000185cULL,
0x000000866860723cULL, 0x040b700000001860ULL, 0x000000886864723cULL, 0x000b700000001864ULL,
0x0000006c702c723cULL, 0x040b70000000182cULL, 0x000000787030723cULL, 0x040b700000001830ULL,
0x0000007a7034723cULL, 0x040b700000001834ULL, 0x0000007e703c723cULL, 0x040b70000000183cULL,
0x000000867040723cULL, 0x040b700000001840ULL, 0x000000887044723cULL, 0x040b700000001844ULL,
0x0000008e7048723cULL, 0x080b700000001848ULL, 0x0000008e6868723cULL, 0x000b620000001828ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x00000000146c7f8cULL, 0x0202a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126980000ff7f8cULL, 0x0007e4000c80043fULL, 0x0000000000287805ULL, 0x000fc40000015200ULL,
0x0000040014237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x006fc4000780486dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff027224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002a7805ULL, 0x000fcc0000015200ULL, 0x0000002a28237210ULL, 0x000fca0007f1e1ffULL,
0x000000012b2a7824ULL, 0x000fe200000e0e29ULL, 0x003d09002300780cULL, 0x000fc80003f06070ULL,
0x000000ff2a00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402300780cULL, 0x000fc80003f06070ULL, 0x000000ff2a00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x008fc8000001142aULL,
0x0000002300007211ULL, 0x000fca00078110ffULL, 0x000000ffff237224ULL, 0x000fca00000e062aULL,
0x0000000200007819ULL, 0x000fc80000001223ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000102027810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040014237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe4000780486dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000116237810ULL, 0x000fc80007ffe0ffULL, 0x0000001c2300720cULL, 0x000fda0003f06070ULL,
0x0000079000000947ULL, 0x000fea0003800000ULL, 0x0000000216237810ULL, 0x000fe20007ffe0ffULL,
0x0000590027007a24ULL, 0x018fe200078e02ffULL, 0x00000100262b7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff297424ULL, 0x000fe200078e00ffULL, 0x0000001c2300720cULL, 0x000fe20003f06070ULL,
0x0000008000287824ULL, 0x000fe200078e00ffULL, 0x000000602b007812ULL, 0x000fc600078ec0ffULL,
0x0000620028287625ULL, 0x000fc800078e0029ULL, 0x0000000119027824ULL, 0x000fc800078e0200ULL,
0x000003e000008947ULL, 0x000fea0003800000ULL, 0x0000002b1e007217ULL, 0x000fe20007800000ULL,
0x0000001020067824ULL, 0x000fc800078e00ffULL, 0x0000000100007824ULL, 0x000fe200078e0a2bULL,
0x0000001006237812ULL, 0x000fe400078ec0ffULL, 0x00000003ff067819ULL, 0x000fe4000001161fULL,
0x0000000023007217ULL, 0x000fe40007800000ULL, 0x00000004060a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000106087824ULL, 0x140fe200078e0223ULL, 0x0000000806267810ULL, 0x000fe20007ffe0ffULL,
0x0000000100007824ULL, 0x000fc400078e0a23ULL, 0x00000001082a7824ULL, 0x000fc600078e0202ULL,
0x000000000a00720cULL, 0x0c0fe20003f86070ULL, 0x000000010a0a7824ULL, 0x100fe200078e0223ULL,
0x000000002600720cULL, 0x080fe20003f66070ULL, 0x000000802a2a7825ULL, 0x000fe200078e00ffULL,
0x000000000600720cULL, 0x0c0fe40003fa6070ULL, 0x0000000c06067810ULL, 0x000fe20007ffe0ffULL,
0x000000010a6c7824ULL, 0x000fe200078e0202ULL, 0x000000132a717212ULL, 0x000fe200078efcffULL,
0x0000000126267824ULL, 0x000fe200078e0223ULL, 0x000000000600720cULL, 0x000fe20003f06070ULL,
0x000000806c6c7825ULL, 0x000fe200078e00ffULL, 0x0000007128707210ULL, 0x000fc60007fde0ffULL,
0x00000001262a7824ULL, 0x000fe200078e0202ULL, 0x000000136c737212ULL, 0x000fe200078efcffULL,
0x0000000106787824ULL, 0x000fe400078e0223ULL, 0x0000000108007824ULL, 0x040fe400078e021fULL,
0x0000000808237824ULL, 0x000fe400078e00ffULL, 0x0000000129717824ULL, 0x000fe200030e062bULL,
0x0000007328727210ULL, 0x000fe20007fde0ffULL, 0x000000802a2a7825ULL, 0x000fe200078e00ffULL,
0xfffffff823007812ULL, 0x000fc600078ee200ULL, 0x00000001786c7824ULL, 0x000fe200078e0202ULL,
0x000000132a237212ULL, 0x000fe200078efcffULL, 0x000000010a067824ULL, 0x040fe400078e021fULL,
0x000000080a797824ULL, 0x000fe400078e00ffULL, 0x0000000129737824ULL, 0x000fe200030e066dULL,
0x00000023282a7210ULL, 0x000fe20007fde0ffULL, 0x000000806c6c7825ULL, 0x000fe200078e00ffULL,
0xfffffff879067812ULL, 0x000fc600078ee206ULL, 0x0000000126027824ULL, 0x100fe200078e021fULL,
0x000000136c237212ULL, 0x000fe200078efcffULL, 0x0000000826797824ULL, 0x000fe400078e00ffULL,
0x00000001780a7824ULL, 0x040fe400078e021fULL, 0x00000008787b7824ULL, 0x000fe200078e00ffULL,
0xfffffff879087812ULL, 0x000fe200078ee202ULL, 0x00000001292b7824ULL, 0x000fe200030e062bULL,
0x0000002328027210ULL, 0x000fe20007fde0ffULL, 0x0000001000797824ULL, 0x100fe200078e0203ULL,
0xfffffff87b0a7812ULL, 0x000fe200078ee20aULL, 0x0000001006237824ULL, 0x000fc400078e0203ULL,
0x00000010087b7824ULL, 0x100fe200078e0203ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000070797faeULL, 0x0003e2000e901c48ULL, 0x000000100a7d7824ULL, 0x000fe400078e0203ULL,
0x0000000129037824ULL, 0x000fe200030e066dULL, 0x0000000072237faeULL, 0x0003e8000e101c48ULL,
0x000000002a7b7faeULL, 0x0003e8000d901c48ULL, 0x00000000027d7faeULL, 0x0003e2000c101c48ULL,
0x0000031000007947ULL, 0x000fea0003800000ULL, 0x0000001020007824ULL, 0x000fca00078e00ffULL,
0x0000001000007812ULL, 0x000fc800078ec0ffULL, 0x000000001f007211ULL, 0x000fc800078fe8ffULL,
0x0000000400087810ULL, 0x040fe20007ffe0ffULL, 0x00000001002a7824ULL, 0x040fe200078e0202ULL,
0x0000000c00267810ULL, 0x040fe20007ffe0ffULL, 0x0000000100067824ULL, 0x040fe400078e021fULL,
0x0000000800237824ULL, 0x000fe400078e00ffULL, 0x000000802a2a7825ULL, 0x000fc600078e00ffULL,
0xfffffff823067812ULL, 0x000fe200078ee206ULL, 0x00000001080a7824ULL, 0x100fe200078e021fULL,
0x000000132a737212ULL, 0x000fe200078efcffULL, 0x00000008086d7824ULL, 0x000fe200078e00ffULL,
0x0000000800237810ULL, 0x000fe20007ffe0ffULL, 0x0000000108007824ULL, 0x100fe200078e0202ULL,
0x0000007328727210ULL, 0x000fe20007f1e0ffULL, 0x0000000126707824ULL, 0x040fe200078e0202ULL,
0xfffffff86d0a7812ULL, 0x000fe200078ee20aULL, 0x00000001236c7824ULL, 0x000fe400078e0202ULL,
0x0000000126087824ULL, 0x000fc400078e021fULL, 0x0000000826717824ULL, 0x000fe400078e00ffULL,
0x0000000123027824ULL, 0x040fe400078e021fULL, 0x0000000823237824ULL, 0x000fe200078e00ffULL,
0xfffffff871087812ULL, 0x000fe200078ee208ULL, 0x0000000129737824ULL, 0x000fe400000e062bULL,
0x00000080002a7825ULL, 0x000fe200078e00ffULL, 0xfffffff823027812ULL, 0x000fc600078ee202ULL,
0x000000806c6c7825ULL, 0x000fe200078e00ffULL, 0x000000132a7b7212ULL, 0x000fc600078efcffULL,
0x0000008070707825ULL, 0x000fe200078e00ffULL, 0x000000136c797212ULL, 0x000fc600078efcffULL,
0x0000001002837824ULL, 0x100fe200078e0203ULL, 0x0000001370237212ULL, 0x000fe200078efcffULL,
0x00000010067d7824ULL, 0x100fe200078e0203ULL, 0x0000007b28027210ULL, 0x000fe20007f1e0ffULL,
0x000000100a7f7824ULL, 0x100fe200078e0203ULL, 0x00000079282a7210ULL, 0x040fe40007f7e0ffULL,
0x0000002328287210ULL, 0x000fe20007f9e0ffULL, 0x0000001008237824ULL, 0x000fe200078e0203ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000727d7faeULL, 0x0003e2000b901c48ULL,
0x0000000129037824ULL, 0x000fc400000e062bULL, 0x00000001292b7824ULL, 0x040fe400018e066dULL,
0x0000000129297824ULL, 0x000fe200020e0671ULL, 0x00000000027f7faeULL, 0x0003e8000b901c48ULL,
0x000000002a837faeULL, 0x0003e8000b901c48ULL, 0x0000000028237faeULL, 0x0003e4000b901c48ULL,
0x0000000820027824ULL, 0x002fe400078e00ffULL, 0x0000002017007824ULL, 0x008fc600078e0215ULL,
0x0000000802037812ULL, 0x000fe400078ec0ffULL, 0x0000000000007918ULL, 0x000fe60000000000ULL,
0x0000000103067824ULL, 0x000fe200078e0200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe60000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000010027f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01266800062a7f8cULL, 0x000662000c80043fULL, 0x000000ffff007224ULL, 0x004fc600078e0003ULL,
0x0000000000027805ULL, 0x000fc80000015200ULL, 0x01266c0006237984ULL, 0x000ea40000000800ULL,
0x8000000023ff7812ULL, 0x006fc4000780482bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000287805ULL, 0x000fcc0000015200ULL,
0x0000002802237210ULL, 0x000fca0007f1e1ffULL, 0x0000000129287824ULL, 0x000fe200000e0e03ULL,
0x003d09002300780cULL, 0x000fc80003f06070ULL, 0x000000ff2800720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402300780cULL, 0x000fc80003f06070ULL,
0x000000ff2800720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc80000011428ULL, 0x0000002308087211ULL, 0x000fca00078110ffULL,
0x000000ffff237224ULL, 0x000fca00000e0628ULL, 0x0000000208087819ULL, 0x000fc80000001223ULL,
0x000000080000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01266c0006237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe4000780482bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000018017027811ULL, 0x000fc800078e38ffULL,
0x0000000212027210ULL, 0x000fca0007ffe013ULL, 0x0120000002037984ULL, 0x000e680000000800ULL,
0x0122000002067984ULL, 0x0084e20000000800ULL, 0x000000220300720bULL, 0x002fe20003f1d000ULL,
0x0000bf827f007947ULL, 0x000fd8000b800000ULL, 0x0000000000087806ULL, 0x004fc800000e0100ULL,
0x000000ff0800720cULL, 0x000fe20003f05270ULL, 0x0000076000007945ULL, 0x000fe20003800000ULL,
0x00000001ff0a7424ULL, 0x000fe400078e00ffULL, 0x000000ffff027224ULL, 0x000fd200078e0022ULL,
0x0000072000008947ULL, 0x000fea0003800000ULL, 0x0000000317237810ULL, 0x000fe40007ffe0ffULL,
0x000000220300720bULL, 0x000fe40003f74000ULL, 0x000000202300720cULL, 0x000fe20003f05270ULL,
0x0000bf327f007947ULL, 0x000fd4000b800000ULL, 0x0000000000237806ULL, 0x000fc400018e0100ULL,
0x0000008020138824ULL, 0x000fe200078e0213ULL, 0x0000002203027209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x0000000112138824ULL, 0x000fca00078e0213ULL,
0x0124000213008388ULL, 0x0003e20000000800ULL, 0x000000ff2300720cULL, 0x000fda0003f05270ULL,
0x000005e000008947ULL, 0x000fea0003800000ULL, 0x00000022020a7221ULL, 0x002fe20000010100ULL,
0x000000ff23ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b0a0a7820ULL, 0x000fcc0000410000ULL, 0x0000000a000a7308ULL, 0x000e640000000800ULL,
0x0000000a21217220ULL, 0x002fe40000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff297819ULL, 0x000fe2000001161fULL, 0x0000be727f007947ULL, 0x000fea000b800000ULL,
0x00001f290a297589ULL, 0x0002a400000e0000ULL, 0x000000292c2c7220ULL, 0x084fe20000410000ULL,
0x000000292d2d7220ULL, 0x080fe20000410000ULL, 0x0000002930307220ULL, 0x080fe20000410000ULL,
0x0000002931317220ULL, 0x080fe20000410000ULL, 0x0000002934347220ULL, 0x080fe20000410000ULL,
0x0000002935357220ULL, 0x080fe20000410000ULL, 0x0000002938387220ULL, 0x080fe20000410000ULL,
0x0000002939397220ULL, 0x080fe20000410000ULL, 0x000000293c3c7220ULL, 0x080fe20000410000ULL,
0x000000293d3d7220ULL, 0x080fe20000410000ULL, 0x0000002940407220ULL, 0x080fe20000410000ULL,
0x0000002941417220ULL, 0x080fe20000410000ULL, 0x0000002944447220ULL, 0x080fe20000410000ULL,
0x0000002945457220ULL, 0x080fe20000410000ULL, 0x0000002948487220ULL, 0x080fe20000410000ULL,
0x0000002949497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0023ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000081f297811ULL, 0x000fe200078ff0ffULL,
0x0000bd427f007947ULL, 0x000fea000b800000ULL, 0x00001f290a297589ULL, 0x00046400000e0000ULL,
0x000000292e2e7220ULL, 0x086fe20000410000ULL, 0x000000292f2f7220ULL, 0x080fe20000410000ULL,
0x0000002932327220ULL, 0x080fe20000410000ULL, 0x0000002933337220ULL, 0x080fe20000410000ULL,
0x0000002936367220ULL, 0x080fe20000410000ULL, 0x0000002937377220ULL, 0x080fe20000410000ULL,
0x000000293a3a7220ULL, 0x080fe20000410000ULL, 0x000000293b3b7220ULL, 0x080fe20000410000ULL,
0x000000293e3e7220ULL, 0x080fe20000410000ULL, 0x000000293f3f7220ULL, 0x080fe20000410000ULL,
0x0000002942427220ULL, 0x080fe20000410000ULL, 0x0000002943437220ULL, 0x080fe20000410000ULL,
0x0000002946467220ULL, 0x080fe20000410000ULL, 0x0000002947477220ULL, 0x080fe20000410000ULL,
0x000000294a4a7220ULL, 0x080fe20000410000ULL, 0x000000294b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000023ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000101f297811ULL, 0x000fe200078ff0ffULL, 0x0000bc127f007947ULL, 0x000fea000b800000ULL,
0x00001f290a297589ULL, 0x00046400000e0000ULL, 0x000000294c4c7220ULL, 0x086fe20000410000ULL,
0x000000294d4d7220ULL, 0x080fe20000410000ULL, 0x0000002950507220ULL, 0x080fe20000410000ULL,
0x0000002951517220ULL, 0x080fe20000410000ULL, 0x0000002954547220ULL, 0x080fe20000410000ULL,
0x0000002955557220ULL, 0x080fe20000410000ULL, 0x0000002958587220ULL, 0x080fe20000410000ULL,
0x0000002959597220ULL, 0x080fe20000410000ULL, 0x000000295c5c7220ULL, 0x080fe20000410000ULL,
0x000000295d5d7220ULL, 0x080fe20000410000ULL, 0x0000002960607220ULL, 0x080fe20000410000ULL,
0x0000002961617220ULL, 0x080fe20000410000ULL, 0x0000002964647220ULL, 0x080fe20000410000ULL,
0x0000002965657220ULL, 0x080fe20000410000ULL, 0x0000002968687220ULL, 0x080fe20000410000ULL,
0x0000002969697220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000023ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000181f297811ULL, 0x000fe200078ff0ffULL, 0x0000baf27f007947ULL, 0x000fea000b800000ULL,
0x00001f290a297589ULL, 0x00046400000e0000ULL, 0x000000294e4e7220ULL, 0x086fe20000410000ULL,
0x000000294f4f7220ULL, 0x080fe20000410000ULL, 0x0000002952527220ULL, 0x080fe20000410000ULL,
0x0000002953537220ULL, 0x080fe20000410000ULL, 0x0000002956567220ULL, 0x080fe20000410000ULL,
0x0000002957577220ULL, 0x080fe20000410000ULL, 0x000000295a5a7220ULL, 0x080fe20000410000ULL,
0x000000295b5b7220ULL, 0x080fe20000410000ULL, 0x000000295e5e7220ULL, 0x080fe20000410000ULL,
0x000000295f5f7220ULL, 0x080fe20000410000ULL, 0x0000002962627220ULL, 0x080fe20000410000ULL,
0x0000002963637220ULL, 0x080fe20000410000ULL, 0x0000002966667220ULL, 0x080fe20000410000ULL,
0x0000002967677220ULL, 0x080fe20000410000ULL, 0x000000296a6a7220ULL, 0x080fe20000410000ULL,
0x000000296b6b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000002308ff7212ULL, 0x000fe200078030ffULL, 0x00000001ff0a7424ULL, 0x000fd800078e00ffULL,
0x0000000302030221ULL, 0x000fe20000010100ULL, 0x00007610ff0a0816ULL, 0x000fc6000000000aULL,
0x3fb8aa3b03030820ULL, 0x000fc80000410000ULL, 0x0000000300110308ULL, 0x000e640000000800ULL,
0x0000001106060220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002106217221ULL, 0x008fc20000010000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x0000000820037824ULL, 0x000fca00078e00ffULL, 0xfffffff003087812ULL, 0x000fca00078ec0ffULL,
0x0126b40008037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe4000780486fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff107224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000227805ULL, 0x000fcc0000015200ULL, 0x0000002212067210ULL, 0x000fca0007f1e1ffULL,
0x0000000123227824ULL, 0x000fe200000e0e13ULL, 0x003d09000600780cULL, 0x000fc80003f06070ULL,
0x000000ff2200720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400600780cULL, 0x000fc80003f06070ULL, 0x000000ff2200720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011422ULL,
0x0000000603037211ULL, 0x000fca00078110ffULL, 0x000000ffff067224ULL, 0x000fca00000e0622ULL,
0x0000000203037819ULL, 0x000fc80000001206ULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000110107810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0126b40008037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe4000780486fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099100a037816ULL, 0x000fe200000000ffULL, 0x0000010000007945ULL, 0x000fe60003800000ULL,
0x000000ff0300720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000011ff03723eULL, 0x000fe400000000ffULL, 0x00000002ff067819ULL, 0x000fe4000001161fULL,
0x0000541003037816ULL, 0x000fe20000000003ULL, 0x0000b6b27f007947ULL, 0x000fea000b800000ULL,
0x00001f06030f7589ULL, 0x0002a400000e0000ULL, 0x0000000806297810ULL, 0x000fe20007ffe0ffULL,
0x0000b6e27f007947ULL, 0x000fea000b800000ULL, 0x0000001006087810ULL, 0x000fe20007ffe0ffULL,
0x00001f29030e7589ULL, 0x00066800000e0000ULL, 0x00001f08030d7589ULL, 0x0006a400000e0000ULL,
0x0000001806297810ULL, 0x008fe20007ffe0ffULL, 0x0000b7327f007947ULL, 0x000fea000b800000ULL,
0x00001f29030c7589ULL, 0x0006a400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000011a037812ULL, 0x00afe200078ec0ffULL, 0x000000080b107824ULL, 0x000fe200078e00ffULL,
0x00000004ff067819ULL, 0x000fe2000001161fULL, 0x0000000809137824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000004200a7824ULL, 0x000fe200078e00ffULL,
0x0000018000007945ULL, 0x000fe20003800000ULL, 0x0000000403067824ULL, 0x000fc400078e0206ULL,
0x0000001007707824ULL, 0x000fe200078e0224ULL, 0x000000040a0a7812ULL, 0x000fe200078ec0ffULL,
0x000000010b037824ULL, 0x100fe400078e0206ULL, 0x0000000109087824ULL, 0x000fe200078e0206ULL,
0x000000020a0a7812ULL, 0x000fe400078efcffULL, 0xfffffff810067812ULL, 0x000fe400078ee203ULL,
0x0000d00017037811ULL, 0x000fe400078e60ffULL, 0xfffffff813087812ULL, 0x000fc600078ee208ULL,
0x0000001006067824ULL, 0x100fe400078e0203ULL, 0x0000001008287824ULL, 0x000fe200078e0203ULL,
0x0000000a1f087211ULL, 0x000fe400078fe0ffULL, 0x00000000066c783bULL, 0x0002e80000000200ULL,
0x000000002828783bULL, 0x000ea20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000f6c6c7232ULL, 0x08cfe40000000000ULL, 0x0000000f6e6e7232ULL, 0x000fc40000000000ULL,
0x0000000e6d6d7232ULL, 0x080fe40000000000ULL, 0x0000000e6f6f7232ULL, 0x000fe40000000000ULL,
0x0000000d28287232ULL, 0x080fe40000000000ULL, 0x0000000d2a2a7232ULL, 0x000fe40000000000ULL,
0x0000000c29297232ULL, 0x080fe40000000000ULL, 0x0000000c2b2b7232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000007070783bULL, 0x000e640000004200ULL,
0x000000080b067824ULL, 0x042fe200078e00ffULL, 0x0000083000007945ULL, 0x000fe20003800000ULL,
0x000000010b0b7824ULL, 0x000fc400078e0208ULL, 0x0000001004047824ULL, 0x000fc600078e0203ULL,
0xfffffff8060b7812ULL, 0x000fca00078ee20bULL, 0x000000100b0b7824ULL, 0x000fca00078e0224ULL,
0x000000000b78783bULL, 0x0002e20000004200ULL, 0x00000010ff067819ULL, 0x100fe40000011670ULL,
0x000000ff700a7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff077819ULL, 0x000fe40000011670ULL,
0x0000ffff70877812ULL, 0x000fe400078ec0ffULL, 0x000000ff73707812ULL, 0x000fe400078ec0ffULL,
0x00000010ff127819ULL, 0x000fc40000011671ULL, 0x00000018ff0b7819ULL, 0x102fe40000011672ULL,
0x000000ff06067812ULL, 0x000fe400078ec0ffULL, 0x000000ff71107812ULL, 0x040fe400078ec0ffULL,
0x00000018ff137819ULL, 0x000fe40000011671ULL, 0x0000ffff71887812ULL, 0x000fe400078ec0ffULL,
0x00000010ff237819ULL, 0x000fc40000011672ULL, 0x000000ff72267812ULL, 0x040fe400078ec0ffULL,
0x0000ffff72897812ULL, 0x000fe400078ec0ffULL, 0x00000010ff717819ULL, 0x100fe40000011673ULL,
0x00000018ff727819ULL, 0x000fe40000011673ULL, 0x0000ffff738a7812ULL, 0x000fe400078ec0ffULL,
0x00000070ff73723eULL, 0x000fc400020006ffULL, 0x0000000aff0a723eULL, 0x000fe400020006ffULL,
0x0000000bff70723eULL, 0x000fe400020006ffULL, 0x000000ff12127812ULL, 0x000fe400078ec0ffULL,
0x00000006ff06723eULL, 0x000fe400020006ffULL, 0x00000008ff0b7819ULL, 0x000fe40000011687ULL,
0x00000010ff22723eULL, 0x000fc400020006ffULL, 0x00000007ff10723eULL, 0x000fe400020006ffULL,
0x00000012ff07723eULL, 0x000fe400020006ffULL, 0x000054100a067816ULL, 0x000fe40000000006ULL,
0x00000008ff127819ULL, 0x000fe40000011688ULL, 0x0000000bff0a723eULL, 0x000fe400020006ffULL,
0x00000013ff13723eULL, 0x000fc400020006ffULL, 0x00000012ff0b723eULL, 0x000fe400020006ffULL,
0x000054100a0a7816ULL, 0x000fe40000000010ULL, 0x000000ff23237812ULL, 0x000fe400078ec0ffULL,
0x00000008ff107819ULL, 0x000fe40000011689ULL, 0x0000ffff788b7812ULL, 0x008fe400078ec0ffULL,
0x0000541022077816ULL, 0x000fc40000000007ULL, 0x000054100b0b7816ULL, 0x000fe40000000013ULL,
0x00000010ff7c7819ULL, 0x100fe40000011678ULL, 0x000000ff787e7812ULL, 0x000fe200078ec0ffULL,
0x000000066c2c723cULL, 0x000f62000000182cULL, 0x00000018ff7d7819ULL, 0x000fe40000011678ULL,
0x00000026ff26723eULL, 0x000fe400020006ffULL, 0x000000ff71717812ULL, 0x000fc400078ec0ffULL,
0x00000023ff13723eULL, 0x000fe200020006ffULL, 0x0000000a6c30723cULL, 0x080f620000001830ULL,
0x00000010ff22723eULL, 0x000fe400020006ffULL, 0x00000010ff787819ULL, 0x000fe40000011679ULL,
0x0000ffff798c7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff107819ULL, 0x000fe2000001168bULL,
0x0000000a2850723cULL, 0x004b620000001850ULL, 0x00000010ff817819ULL, 0x000fc4000001167aULL,
0x000000ff7a847812ULL, 0x040fe400078ec0ffULL, 0x00000018ff837819ULL, 0x000fe4000001167aULL,
0x0000ffff7a8d7812ULL, 0x000fe200078ec0ffULL, 0x00000010050a7824ULL, 0x020fe200078e0203ULL,
0x00000071ff71723eULL, 0x000fe200020006ffULL, 0x00000006284c723cULL, 0x000b62000000184cULL,
0x0000541026127816ULL, 0x000fe20000000013ULL, 0x000000000404783bULL, 0x020e620000000200ULL,
0x000000ff79807812ULL, 0x000fc400078ec0ffULL, 0x00000010ff7a7819ULL, 0x100fe4000001167bULL,
0x000000ff7b867812ULL, 0x000fe400078ec0ffULL, 0x00000018ff857819ULL, 0x000fe4000001167bULL,
0x0000007dff7d723eULL, 0x000fe400020006ffULL, 0x000000ff78787812ULL, 0x000fe400078ec0ffULL,
0x00000008ff267819ULL, 0x000fc4000001168cULL, 0x00000010ff10723eULL, 0x000fe400020006ffULL,
0x0000ffff7b7b7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff7f7819ULL, 0x000fe40000011679ULL,
0x0000541073137816ULL, 0x000fe40000000071ULL, 0x0000541022227816ULL, 0x000fe40000000070ULL,
0x00000080ff80723eULL, 0x000fc400020006ffULL, 0x00000008ff237819ULL, 0x000fe2000001168aULL,
0x000000122854723cULL, 0x080f620000001854ULL, 0x00000078ff78723eULL, 0x000fe400020006ffULL,
0x00000026ff71723eULL, 0x000fe400020006ffULL, 0x0000541010707816ULL, 0x000fe4000000007dULL,
0x000000ff7c7c7812ULL, 0x000fe200078ec0ffULL, 0x000000126c34723cULL, 0x000f620000001834ULL,
0x000000ff81817812ULL, 0x000fc400078ec0ffULL, 0x000000ff7a7a7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff107819ULL, 0x000fe4000001168dULL, 0x00000008ff267819ULL, 0x000fe4000001167bULL,
0x0000007fff79723eULL, 0x000fe400020006ffULL, 0x00000072ff72723eULL, 0x000fe400020006ffULL,
0x00000023ff23723eULL, 0x000fc400020006ffULL, 0x00005410807f7816ULL, 0x000fe40000000078ULL,
0x0000007eff7e723eULL, 0x000fe400020006ffULL, 0x00000084ff84723eULL, 0x000fe400020006ffULL,
0x0000007cff7c723eULL, 0x000fe400020006ffULL, 0x00000086ff86723eULL, 0x000fe400020006ffULL,
0x00000083ff83723eULL, 0x000fc400020006ffULL, 0x00000081ff81723eULL, 0x000fe400020006ffULL,
0x0000007aff7a723eULL, 0x000fe400020006ffULL, 0x00000085ff78723eULL, 0x000fe400020006ffULL,
0x00000010ff10723eULL, 0x000fe400020006ffULL, 0x00000026ff73723eULL, 0x000fe400020006ffULL,
0x0000541023237816ULL, 0x000fc40000000072ULL, 0x000054107e7e7816ULL, 0x000fe4000000007cULL,
0x0000541071717816ULL, 0x000fe40000000079ULL, 0x0000541084847816ULL, 0x000fe20000000081ULL,
0x000000222858723cULL, 0x000f620000001858ULL, 0x0000541086857816ULL, 0x000fe4000000007aULL,
0x0000541010727816ULL, 0x000fe40000000083ULL, 0x0000541073737816ULL, 0x000fc60000000078ULL,
0x0000007e285c723cULL, 0x040f70000000185cULL, 0x000000702860723cULL, 0x040f700000001860ULL,
0x000000842864723cULL, 0x040f700000001864ULL, 0x000000722868723cULL, 0x000b640000001868ULL,
0x000000000a28783bULL, 0x0204ec0000000200ULL, 0x000000226c38723cULL, 0x040b700000001838ULL,
0x0000007e6c3c723cULL, 0x040b70000000183cULL, 0x000000706c40723cULL, 0x040b700000001840ULL,
0x000000846c44723cULL, 0x040b700000001844ULL, 0x000000726c48723cULL, 0x000b620000001848ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000008000000947ULL, 0x000fde0003800000ULL,
0x0000000f28287232ULL, 0x08efe40000000000ULL, 0x0000000f2a2a7232ULL, 0x000fc40000000000ULL,
0x0000000e29297232ULL, 0x080fe40000000000ULL, 0x0000000e2b2b7232ULL, 0x000fe40000000000ULL,
0x0000000d04047232ULL, 0x080fe40000000000ULL, 0x0000000d06067232ULL, 0x000fe40000000000ULL,
0x0000000c05057232ULL, 0x080fe40000000000ULL, 0x0000000c07077232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x006fea0003800000ULL, 0x0000000809037824ULL, 0x040fe200078e00ffULL,
0x00000000256c783bULL, 0x020e620000004200ULL, 0x0000000109087824ULL, 0x000fca00078e0208ULL,
0xfffffff803037812ULL, 0x000fca00078ee208ULL, 0x0000001003037824ULL, 0x000fca00078e0224ULL,
0x000000000308783bULL, 0x0004e20000004200ULL, 0x000000ff6d247812ULL, 0x002fe400078ec0ffULL,
0x00000018ff037819ULL, 0x004fe4000001166eULL, 0x0000ffff6c7f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff107819ULL, 0x000fe4000001166cULL, 0x0000ffff6e817812ULL, 0x000fe400078ec0ffULL,
0x000000ff6c137812ULL, 0x000fc400078ec0ffULL, 0x000000ff10107812ULL, 0x000fe400078ec0ffULL,
0x00000018ff127819ULL, 0x000fe4000001166cULL, 0x00000010ff727819ULL, 0x108fe40000011609ULL,
0x000000ff09787812ULL, 0x040fe400078ec0ffULL, 0x00000018ff737819ULL, 0x000fe40000011609ULL,
0x0000ffff09857812ULL, 0x000fc400078ec0ffULL, 0x00000024ff09723eULL, 0x000fe400020006ffULL,
0x00000003ff24723eULL, 0x000fe400020006ffULL, 0x00000008ff037819ULL, 0x000fe4000001167fULL,
0x00000010ff797819ULL, 0x100fe4000001160aULL, 0x00000018ff7a7819ULL, 0x000fe4000001160aULL,
0x000000ff0a7b7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff0a867812ULL, 0x000fe400078ec0ffULL,
0x00000003ff0a723eULL, 0x000fe400020006ffULL, 0x00000010ff227819ULL, 0x100fe4000001166dULL,
0x00000018ff237819ULL, 0x000fe4000001166dULL, 0x0000ffff6d807812ULL, 0x000fe400078ec0ffULL,
0x00000010ff257819ULL, 0x000fc4000001166eULL, 0x000000ff6e267812ULL, 0x000fe400078ec0ffULL,
0x00000008ff037819ULL, 0x000fe40000011681ULL, 0x00000010ff6c7819ULL, 0x100fe4000001166fULL,
0x000000ff6f6e7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6d7819ULL, 0x000fe4000001166fULL,
0x0000ffff6f837812ULL, 0x000fc400078ec0ffULL, 0x00000010ff6f7819ULL, 0x100fe40000011608ULL,
0x000000ff08717812ULL, 0x040fe400078ec0ffULL, 0x00000018ff707819ULL, 0x000fe40000011608ULL,
0x0000ffff08847812ULL, 0x000fe400078ec0ffULL, 0x00000013ff08723eULL, 0x000fe400020006ffULL,
0x00000010ff10723eULL, 0x000fc400020006ffULL, 0x00000003ff03723eULL, 0x000fe400020006ffULL,
0x000000ff22227812ULL, 0x000fe400078ec0ffULL, 0x0000541008087816ULL, 0x000fe40000000010ULL,
0x000000ff25257812ULL, 0x000fe400078ec0ffULL, 0x00000008ff107819ULL, 0x000fe40000011683ULL,
0x000000ff6f6f7812ULL, 0x000fc400078ec0ffULL, 0x0000541003247816ULL, 0x000fe40000000024ULL,
0x00000008ff037819ULL, 0x000fe40000011684ULL, 0x00000022ff22723eULL, 0x000fe400020006ffULL,
0x00000025ff13723eULL, 0x000fe400020006ffULL, 0x00000010ff7c7819ULL, 0x100fe4000001160bULL,
0x00000018ff7d7819ULL, 0x000fc4000001160bULL, 0x000000ff0b7e7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff0b877812ULL, 0x000fe400078ec0ffULL, 0x00000071ff71723eULL, 0x000fe400020006ffULL,
0x000000ff6c6c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff25723eULL, 0x000fe400020006ffULL,
0x0000006fff6f723eULL, 0x000fc400020006ffULL, 0x00000008ff0b7819ULL, 0x000fe40000011680ULL,
0x00000070ff70723eULL, 0x000fe400020006ffULL, 0x00000008ff107819ULL, 0x000fe40000011685ULL,
0x00000003ff03723eULL, 0x000fe400020006ffULL, 0x000000ff79797812ULL, 0x000fe400078ec0ffULL,
0x00000012ff12723eULL, 0x000fc400020006ffULL, 0x00000026ff26723eULL, 0x000fe400020006ffULL,
0x0000541009097816ULL, 0x000fe40000000022ULL, 0x0000006eff6e723eULL, 0x000fe400020006ffULL,
0x0000006cff6c723eULL, 0x000fe400020006ffULL, 0x0000541071227816ULL, 0x000fe2000000006fULL,
0x00000008282c723cULL, 0x000b62000000182cULL, 0x00000023ff23723eULL, 0x000fc400020006ffULL,
0x0000006dff6d723eULL, 0x000fe400020006ffULL, 0x0000000bff0b723eULL, 0x000fe400020006ffULL,
0x0000007bff7b723eULL, 0x000fe200020006ffULL, 0x00000008044c723cULL, 0x000b62000000184cULL,
0x00000010ff71723eULL, 0x000fe400020006ffULL, 0x0000541003707816ULL, 0x000fe40000000070ULL,
0x00000079ff79723eULL, 0x000fc400020006ffULL, 0x000054100a0a7816ULL, 0x000fe40000000012ULL,
0x000000ff72727812ULL, 0x000fe400078ec0ffULL, 0x000000ff7c7c7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff037819ULL, 0x000fe40000011686ULL, 0x00000008ff107819ULL, 0x000fe40000011687ULL,
0x0000541026127816ULL, 0x000fc40000000013ULL, 0x000054106e137816ULL, 0x000fe4000000006cULL,
0x000054100b0b7816ULL, 0x000fe40000000023ULL, 0x0000541025257816ULL, 0x000fe4000000006dULL,
0x000054107b6c7816ULL, 0x000fe20000000079ULL, 0x000000122834723cULL, 0x000b620000001834ULL,
0x00000078ff78723eULL, 0x000fe400020006ffULL, 0x00000073ff73723eULL, 0x000fc400020006ffULL,
0x0000007aff7a723eULL, 0x000fe400020006ffULL, 0x00000072ff23723eULL, 0x000fe200020006ffULL,
0x0000000a2830723cULL, 0x040b620000001830ULL, 0x0000007eff6d723eULL, 0x000fe400020006ffULL,
0x0000007cff7c723eULL, 0x000fe400020006ffULL, 0x0000007dff7d723eULL, 0x000fe400020006ffULL,
0x00000003ff03723eULL, 0x000fe200020006ffULL, 0x000000242838723cULL, 0x000b620000001838ULL,
0x00000010ff7b723eULL, 0x000fc400020006ffULL, 0x0000541078237816ULL, 0x000fe40000000023ULL,
0x0000541071717816ULL, 0x000fe40000000073ULL, 0x000054106d6d7816ULL, 0x000fe2000000007cULL,
0x0000000a0450723cULL, 0x000b620000001850ULL, 0x00005410037a7816ULL, 0x000fe4000000007aULL,
0x000054107b7b7816ULL, 0x000fca000000007dULL, 0x00000022283c723cULL, 0x040b70000000183cULL,
0x000000702840723cULL, 0x040b700000001840ULL, 0x0000006c2844723cULL, 0x040b700000001844ULL,
0x0000007a2848723cULL, 0x000b700000001848ULL, 0x000000120454723cULL, 0x040b700000001854ULL,
0x000000240458723cULL, 0x040b700000001858ULL, 0x00000022045c723cULL, 0x040b70000000185cULL,
0x000000700460723cULL, 0x040b700000001860ULL, 0x0000006c0464723cULL, 0x040b700000001864ULL,
0x0000007a0468723cULL, 0x000b620000001868ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fda0000008000ULL,
0x0000000014047f8cULL, 0x0202a2000c80043fULL, 0x0000000116167810ULL, 0x000fc40007ffe0ffULL,
0x000126a017067811ULL, 0x000fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000006ff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff037224ULL, 0x004fe200078e0005ULL,
0x0000001000002944ULL, 0x000fe20003c00000ULL, 0xffff513000007947ULL, 0x000fea000383ffffULL,
0x000000ff1c00720cULL, 0x000fda0003f05270ULL, 0x000005b000008947ULL, 0x000fea0003800000ULL,
0x0180000021007810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0000c8b000047802ULL, 0x000fc40000000f00ULL,
0x0000a6f000007944ULL, 0x01efea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000002100007308ULL, 0x000ee40000001000ULL, 0xbf80000000027423ULL, 0x00afc80000000021ULL,
0x800000ff02037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006d00ff037624ULL, 0x000fe400078e00ffULL,
0x00006c00ff027624ULL, 0x000fca00078e00ffULL, 0x0000000802037981ULL, 0x008ee8000c1e9900ULL,
0x0000000000087919ULL, 0x000e680000000000ULL, 0x0000000000047919ULL, 0x000ea20000000000ULL,
0x0000001808057811ULL, 0x042fe400078ff0ffULL, 0x0000000808097811ULL, 0x000fc400078ff0ffULL,
0x00000002ff077819ULL, 0x004fe40000011604ULL, 0x00000010080b7811ULL, 0x000fe200078ff0ffULL,
0x0000000003067220ULL, 0x008fca0000410000ULL, 0x00001f0706007589ULL, 0x000e6800000e0000ULL,
0x00001f0506057589ULL, 0x000ea800000e0000ULL, 0x00001f0906047589ULL, 0x000ee800000e0000ULL,
0x00001f0b06027589ULL, 0x000ea200000e0000ULL, 0x0000002c002c7220ULL, 0x042fe20000410000ULL,
0x0000002d002d7220ULL, 0x040fe20000410000ULL, 0x0000003000307220ULL, 0x040fe20000410000ULL,
0x0000003100317220ULL, 0x040fe20000410000ULL, 0x0000003400347220ULL, 0x040fe20000410000ULL,
0x0000003500357220ULL, 0x040fe20000410000ULL, 0x0000003800387220ULL, 0x040fe20000410000ULL,
0x0000003900397220ULL, 0x040fe20000410000ULL, 0x0000003c003c7220ULL, 0x040fe20000410000ULL,
0x0000003d003d7220ULL, 0x040fe20000410000ULL, 0x0000004000407220ULL, 0x040fe20000410000ULL,
0x0000004100417220ULL, 0x040fe20000410000ULL, 0x0000004400447220ULL, 0x040fe20000410000ULL,
0x0000004500457220ULL, 0x040fe20000410000ULL, 0x0000004800487220ULL, 0x040fe20000410000ULL,
0x0000004900497220ULL, 0x000fe20000410000ULL, 0x0000004e054e7220ULL, 0x044fe20000410000ULL,
0x0000004f054f7220ULL, 0x040fe20000410000ULL, 0x0000005205527220ULL, 0x040fe20000410000ULL,
0x0000005305537220ULL, 0x040fe20000410000ULL, 0x0000005605567220ULL, 0x040fe20000410000ULL,
0x0000005705577220ULL, 0x040fe20000410000ULL, 0x0000005a055a7220ULL, 0x040fe20000410000ULL,
0x0000005b055b7220ULL, 0x040fe20000410000ULL, 0x0000005e055e7220ULL, 0x040fe20000410000ULL,
0x0000005f055f7220ULL, 0x040fe20000410000ULL, 0x0000006205627220ULL, 0x040fe20000410000ULL,
0x0000006305637220ULL, 0x040fe20000410000ULL, 0x0000006605667220ULL, 0x040fe20000410000ULL,
0x0000006705677220ULL, 0x040fe20000410000ULL, 0x0000006a056a7220ULL, 0x040fe20000410000ULL,
0x0000006b056b7220ULL, 0x000fe20000410000ULL, 0x000000042e2e7220ULL, 0x088fe20000410000ULL,
0x000000042f2f7220ULL, 0x080fe20000410000ULL, 0x0000000432327220ULL, 0x080fe20000410000ULL,
0x0000000433337220ULL, 0x080fe20000410000ULL, 0x0000000436367220ULL, 0x080fe20000410000ULL,
0x0000000437377220ULL, 0x080fe20000410000ULL, 0x000000043a3a7220ULL, 0x080fe20000410000ULL,
0x000000043b3b7220ULL, 0x080fe20000410000ULL, 0x000000043e3e7220ULL, 0x080fe20000410000ULL,
0x000000043f3f7220ULL, 0x080fe20000410000ULL, 0x0000000442427220ULL, 0x080fe20000410000ULL,
0x0000000443437220ULL, 0x080fe20000410000ULL, 0x0000000446467220ULL, 0x080fe20000410000ULL,
0x0000000447477220ULL, 0x080fe20000410000ULL, 0x000000044a4a7220ULL, 0x080fe20000410000ULL,
0x000000044b4b7220ULL, 0x000fe20000410000ULL, 0x000000024c4c7220ULL, 0x080fe20000410000ULL,
0x000000024d4d7220ULL, 0x080fe20000410000ULL, 0x0000000250507220ULL, 0x080fe20000410000ULL,
0x0000000251517220ULL, 0x080fe20000410000ULL, 0x0000000254547220ULL, 0x080fe20000410000ULL,
0x0000000255557220ULL, 0x080fe20000410000ULL, 0x0000000258587220ULL, 0x080fe20000410000ULL,
0x0000000259597220ULL, 0x080fe20000410000ULL, 0x000000025c5c7220ULL, 0x080fe20000410000ULL,
0x000000025d5d7220ULL, 0x080fe20000410000ULL, 0x0000000260607220ULL, 0x080fe20000410000ULL,
0x0000000261617220ULL, 0x080fe20000410000ULL, 0x0000000264647220ULL, 0x080fe20000410000ULL,
0x0000000265657220ULL, 0x080fe20000410000ULL, 0x0000000268687220ULL, 0x080fe20000410000ULL,
0x0000000269697220ULL, 0x000fc20000410000ULL, 0x0000000000007919ULL, 0x000ee20000000000ULL,
0x0000002e2f2e723eULL, 0x000fc400000000ffULL, 0x000000323317723eULL, 0x000fe200000000ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000363736723eULL, 0x000fe400000000ffULL,
0x0000003a3b1b723eULL, 0x000fe400000000ffULL, 0x0000003e3f3e723eULL, 0x000fc400000000ffULL,
0x00000042431f723eULL, 0x000fe400000000ffULL, 0x000000464746723eULL, 0x000fe400000000ffULL,
0x0000004a4b23723eULL, 0x000fe400000000ffULL, 0x000054102e167816ULL, 0x000fe40000000017ULL,
0x0000000800057811ULL, 0x048fe400078ff0ffULL, 0x0000000200027812ULL, 0x002fc400078ec0ffULL,
0x0000001800097811ULL, 0x000fe200078ff0ffULL, 0x00000008050a7824ULL, 0x000fe200078e00ffULL,
0x0000000502037211ULL, 0x000fe400078ff8ffULL, 0x0000001000057811ULL, 0x000fe200078ff0ffULL,
0x0000000809147824ULL, 0x000fe200078e00ffULL, 0xfffffff80a0a7812ULL, 0x000fe400078ee203ULL,
0x00000002ff077819ULL, 0x004fe20000011600ULL, 0x0000000805127824ULL, 0x000fe200078e00ffULL,
0x0000000502037211ULL, 0x000fc400078ff8ffULL, 0x0000000902057211ULL, 0x040fe200078ff8ffULL,
0x0000000807097824ULL, 0x040fe200078e00ffULL, 0x0000000702047211ULL, 0x000fe200078ff8ffULL,
0x00000008070e7824ULL, 0x040fe200078e00ffULL, 0xfffffff812127812ULL, 0x000fe200078ee203ULL,
0x0000200020037824ULL, 0x000fe200078e00ffULL, 0xfffffff814147812ULL, 0x000fe200078ee205ULL,
0x0000000807057824ULL, 0x000fe200078e00ffULL, 0x0000000204027810ULL, 0x000fe40007ffe0ffULL,
0x0000200003037812ULL, 0x000fc400078ee2ffULL, 0xfffffff809087812ULL, 0x000fe400078ee202ULL,
0xfffffff805027812ULL, 0x000fe200078ee204ULL, 0x000010001a057824ULL, 0x000fe200078e0203ULL,
0x0000000404067810ULL, 0x040fe40007ffe0ffULL, 0x0000000604077810ULL, 0x000fe20007ffe0ffULL,
0x0000000800047824ULL, 0x000fe200078e00ffULL, 0xfffffff8090c7812ULL, 0x000fe200078ee206ULL,
0x0000001002067824ULL, 0x000fe200078e0205ULL, 0xfffffff80e0e7812ULL, 0x000fe200078ee207ULL,
0x000000100a107824ULL, 0x100fe200078e0205ULL, 0x0000000804077812ULL, 0x000fe200078ec0ffULL,
0x00000010080a7824ULL, 0x100fe200078e0205ULL, 0x0000002c2d02723eULL, 0x000fe200000000ffULL,
0x0000001012127824ULL, 0x000fe200078e0205ULL, 0x000000303104723eULL, 0x000fe200000000ffULL,
0x0000000106087824ULL, 0x000fe200078e0207ULL, 0x000000404106723eULL, 0x000fe200000000ffULL,
0x0000001014147824ULL, 0x100fe200078e0205ULL, 0x0000541002187816ULL, 0x100fe20000000004ULL,
0x000000100c0c7824ULL, 0x100fe200078e0205ULL, 0x0000763202197816ULL, 0x000fe20000000004ULL,
0x000000100e0e7824ULL, 0x000fe200078e0205ULL, 0x000000343502723eULL, 0x000fe200000000ffULL,
0x0000000107107824ULL, 0x000fe200078e0210ULL, 0x000000383904723eULL, 0x000fe200000000ffULL,
0x0000001808007388ULL, 0x0003e20000000a00ULL, 0x0000003c3d05723eULL, 0x000fe200000000ffULL,
0x0000000107127824ULL, 0x000fe200078e0212ULL, 0x0000004c4d4c723eULL, 0x000fe200000000ffULL,
0x0000000107147824ULL, 0x000fe200078e0214ULL, 0x000000505126723eULL, 0x000fe200000000ffULL,
0x00000001070a7824ULL, 0x040fe200078e020aULL, 0x000076322e177816ULL, 0x000fe20000000017ULL,
0x00000001070c7824ULL, 0x000fe200078e020cULL, 0x000000545554723eULL, 0x000fe200000000ffULL,
0x00000001070e7824ULL, 0x000fe200078e020eULL, 0x000000444507723eULL, 0x000fc400000000ffULL,
0x000000484908723eULL, 0x002fe400000000ffULL, 0x0000541002187816ULL, 0x140fe40000000004ULL,
0x0000763202197816ULL, 0x000fe40000000004ULL, 0x0000541005047816ULL, 0x140fe40000000006ULL,
0x0000763205057816ULL, 0x000fe20000000006ULL, 0x000000180a007388ULL, 0x000fe20000000a00ULL,
0x0000541007067816ULL, 0x000fc40000000008ULL, 0x0000763207077816ULL, 0x000fe20000000008ULL,
0x000000040c007388ULL, 0x0003e20000000a00ULL, 0x00000058592a723eULL, 0x000fe400000000ffULL,
0x000054103e1e7816ULL, 0x140fe2000000001fULL, 0x000000060e007388ULL, 0x0005e20000000a00ULL,
0x000076323e1f7816ULL, 0x000fe4000000001fULL, 0x0000541046227816ULL, 0x140fe20000000023ULL,
0x0000001610007388ULL, 0x0007e20000000a00ULL, 0x0000763246237816ULL, 0x000fc40000000023ULL,
0x0000541054087816ULL, 0x000fe4000000002aULL, 0x0000541036047816ULL, 0x142fe4000000001bULL,
0x0000763236057816ULL, 0x000fe4000000001bULL, 0x000054104c067816ULL, 0x144fe40000000026ULL,
0x000076324c077816ULL, 0x000fe20000000026ULL, 0x000400040a007388ULL, 0x0003e20000000a00ULL,
0x0000763254097816ULL, 0x000fc4000000002aULL, 0x0000005c5d5c723eULL, 0x000fe200000000ffULL,
0x0004001e0c007388ULL, 0x000fe20000000a00ULL, 0x000000606160723eULL, 0x000fe400000000ffULL,
0x000000646564723eULL, 0x000fe200000000ffULL, 0x000400220e007388ULL, 0x000fe20000000a00ULL,
0x000000686932723eULL, 0x000fe400000000ffULL, 0x0000004e4f02723eULL, 0x000fe200000000ffULL,
0x0000000612007388ULL, 0x0005e20000000a00ULL, 0x0000541064107816ULL, 0x008fc40000000032ULL,
0x0000763264117816ULL, 0x000fe20000000032ULL, 0x000800080a007388ULL, 0x0007e20000000a00ULL,
0x000000525304723eULL, 0x002fe400000000ffULL, 0x000000565705723eULL, 0x000fe400000000ffULL,
0x000000ff1a00720cULL, 0x000fe40003f05270ULL, 0x0000005a5b06723eULL, 0x004fe400000000ffULL,
0x000000666707723eULL, 0x000fc400000000ffULL, 0x000054105c087816ULL, 0x148fe40000000060ULL,
0x000076325c097816ULL, 0x000fca0000000060ULL, 0x000800080c007388ULL, 0x0003e80000000a00ULL,
0x000800100e007388ULL, 0x0005e20000000a00ULL, 0x0000006a6b08723eULL, 0x002fe400000000ffULL,
0x0000541002107816ULL, 0x144fe40000000004ULL, 0x0000763202117816ULL, 0x000fe40000000004ULL,
0x0000005e5f02723eULL, 0x000fc400000000ffULL, 0x000000626304723eULL, 0x000fe200000000ffULL,
0x0000001014007388ULL, 0x0003e20000000a00ULL, 0x0000541007227816ULL, 0x000fe40000000008ULL,
0x0000541002187816ULL, 0x140fe40000000004ULL, 0x0000763202197816ULL, 0x000fe20000000004ULL,
0x0000000177027824ULL, 0x000fe200078e0200ULL, 0x0000763207237816ULL, 0x000fc60000000008ULL,
0x0000001002027824ULL, 0x000fe200078e0203ULL, 0x0000541005107816ULL, 0x142fe40000000006ULL,
0x0000763205117816ULL, 0x000fca0000000006ULL, 0x000c00100a007388ULL, 0x000fe80000000a00ULL,
0x000c00180c007388ULL, 0x000fe80000000a00ULL, 0x000c00220e007388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000002047984ULL, 0x000e680000000c00ULL,
0x0004000002107984ULL, 0x000ea80000000c00ULL, 0x00080000021c7984ULL, 0x000ee80000000c00ULL,
0x000c000002287984ULL, 0x000ee80000000c00ULL, 0x0010000002087984ULL, 0x000ee80000000c00ULL,
0x0014000002147984ULL, 0x000ee80000000c00ULL, 0x0018000002247984ULL, 0x010ee80000000c00ULL,
0x001c0000022c7984ULL, 0x000ee20000000c00ULL, 0x200000ff07077230ULL, 0x002fc40000000000ULL,
0x200000ff06067230ULL, 0x000fe40000000000ULL, 0x200000ff05057230ULL, 0x000fe40000000000ULL,
0x200000ff04047230ULL, 0x000fe40000000000ULL, 0x200000ff13137230ULL, 0x004fe40000000000ULL,
0x200000ff12127230ULL, 0x000fe40000000000ULL, 0x200000ff11117230ULL, 0x000fc40000000000ULL,
0x200000ff10107230ULL, 0x000fe40000000000ULL, 0x200000ff1f1f7230ULL, 0x008fe40000000000ULL,
0x200000ff1e1e7230ULL, 0x000fe40000000000ULL, 0x200000ff1d1d7230ULL, 0x000fe40000000000ULL,
0x200000ff1c1c7230ULL, 0x000fe40000000000ULL, 0x200000ff2b2b7230ULL, 0x000fc40000000000ULL,
0x200000ff2a2a7230ULL, 0x000fe40000000000ULL, 0x200000ff29297230ULL, 0x000fe40000000000ULL,
0x200000ff28287230ULL, 0x000fe40000000000ULL, 0x0000000b07077230ULL, 0x000fe40000000000ULL,
0x0000000a06067230ULL, 0x000fe40000000000ULL, 0x0000000905057230ULL, 0x000fc40000000000ULL,
0x0000000804047230ULL, 0x000fe40000000000ULL, 0x0000001713137230ULL, 0x000fe40000000000ULL,
0x0000001612127230ULL, 0x000fe20000000000ULL, 0x0000000402007388ULL, 0x000fe20000000c00ULL,
0x0000001511117230ULL, 0x000fe40000000000ULL, 0x0000001410107230ULL, 0x000fe40000000000ULL,
0x000000271f1f7230ULL, 0x000fc40000000000ULL, 0x000000261e1e7230ULL, 0x000fe20000000000ULL,
0x0004001002007388ULL, 0x000fe20000000c00ULL, 0x000000251d1d7230ULL, 0x000fe40000000000ULL,
0x000000241c1c7230ULL, 0x000fe40000000000ULL, 0x0000002f2b2b7230ULL, 0x000fe40000000000ULL,
0x0000002e2a2a7230ULL, 0x000fe20000000000ULL, 0x0008001c02007388ULL, 0x000fe20000000c00ULL,
0x0000002d29297230ULL, 0x000fc40000000000ULL, 0x0000002c28287230ULL, 0x000fca0000000000ULL,
0x000c002802007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000003ff077819ULL, 0x000fc80000011600ULL,
0x000000740700720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000107027824ULL, 0x100fe200078e0200ULL, 0x00000000000479c3ULL, 0x000e620000002700ULL,
0xffffffff00057882ULL, 0x000fe20000000000ULL, 0x0000000120117812ULL, 0x000fe200078ec0ffULL,
0x00005a0000067ab9ULL, 0x000fe20000000800ULL, 0x0000000702057812ULL, 0x000fe200078ec0ffULL,
0x0000000605057299ULL, 0x000fe2000800063fULL, 0x00000007000e7812ULL, 0x000fe400078ec0ffULL,
0x0ffffff805027812ULL, 0x000fe200078ef800ULL, 0x0000580000067ab9ULL, 0x000fc80000000800ULL,
0x0000001002047824ULL, 0x000fe400078e0203ULL, 0x0000002076027824ULL, 0x000fe400078e0207ULL,
0x0000000811077824ULL, 0x000fe200078e020eULL, 0x0000000004087984ULL, 0x0004e40000000c00ULL,
0x0000000502067c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff057a19ULL, 0x000fe20000011602ULL,
0x00000006040472a4ULL, 0x002fc4000f8e023fULL, 0x0000000175067824ULL, 0x000fc800078e0206ULL,
0x0000008205057224ULL, 0x000fe200078e0206ULL, 0x0000002000067810ULL, 0x000fe20007ffe0ffULL,
0x0000000482027c24ULL, 0x000fc6000f8e02ffULL, 0x00000003ff0d7819ULL, 0x000fe40000011606ULL,
0x0000000502057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x004fc800078040ffULL, 0x00005d0005057a11ULL, 0x000fe400000f440cULL,
0x000000740d00720cULL, 0x000fc60003f06070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0083ea000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000106047824ULL, 0x102fe200078e020dULL, 0x00000040000c7810ULL, 0x000fe20007ffe0ffULL,
0x00000020760d7824ULL, 0x000fc600078e020dULL, 0x0000000704057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805047812ULL, 0x000fe400078ef806ULL, 0x0000000706067812ULL, 0x000fc600078ec0ffULL,
0x0000001004077824ULL, 0x000fe200078e0203ULL, 0x000000050d047c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff0d7a19ULL, 0x000fe4000001160dULL, 0x0000000007087984ULL, 0x0002a20000000c00ULL,
0x0000000175047824ULL, 0x000fc800078e0204ULL, 0x000000820d0d7224ULL, 0x000fe400078e0204ULL,
0x0000000811077824ULL, 0x002fc600078e0206ULL, 0x0000000d020d7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x00005c000d047a11ULL, 0x000fc800078040ffULL,
0x00005d000d057a11ULL, 0x000fe400000f440eULL, 0x00000003ff0d7819ULL, 0x000fc6000001160cULL,
0x0000001007047825ULL, 0x000fe200078e0004ULL, 0x000000740d00720cULL, 0x000fc80003f06070ULL,
0x0000000804007986ULL, 0x0043f2000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010c047824ULL, 0x102fe400078e020dULL, 0x00000020760d7824ULL, 0x000fc600078e020dULL,
0x0000000704057812ULL, 0x000fc800078ec0ffULL, 0x0ffffff805047812ULL, 0x000fe400078ef80cULL,
0x000000070c0c7812ULL, 0x000fc600078ec0ffULL, 0x0000001004067824ULL, 0x000fe200078e0203ULL,
0x000000050d047c12ULL, 0x000fe2000f8e30ffULL, 0x0000000811077824ULL, 0x000fe200078e020cULL,
0x00005a00ff0d7a19ULL, 0x000fe4000001160dULL, 0x0000000006087984ULL, 0x000e620000000c00ULL,
0x0000000175047824ULL, 0x000fc800078e0204ULL, 0x000000820d0d7224ULL, 0x000fca00078e0204ULL,
0x0000000d02057210ULL, 0x000fe40007f1e0ffULL, 0x00000060000d7810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x00005c0005047a11ULL, 0x040fe400078040ffULL,
0x00000003ff0f7819ULL, 0x000fe4000001160dULL, 0x00005d0005057a11ULL, 0x000fe400000f440eULL,
0x000000740f00720cULL, 0x000fc60003f06070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0023ea000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010d047824ULL, 0x102fe200078e020fULL, 0x0000008000077810ULL, 0x000fe20007ffe0ffULL,
0x00000020760f7824ULL, 0x000fc600078e020fULL, 0x0000000704047812ULL, 0x000fc800078ec0ffULL,
0x0ffffff804047812ULL, 0x000fe400078ef80dULL, 0x000000070d0d7812ULL, 0x000fc600078ec0ffULL,
0x0000001004067824ULL, 0x000fe200078e0203ULL, 0x000000050f047c12ULL, 0x000fe2000f8e30ffULL,
0x00000008110d7824ULL, 0x000fe200078e020dULL, 0x00005a00ff0f7a19ULL, 0x000fe4000001160fULL,
0x0000000006087984ULL, 0x000e620000000c00ULL, 0x0000000175047824ULL, 0x000fc800078e0204ULL,
0x000000820f0f7224ULL, 0x000fca00078e0204ULL, 0x0000000f020f7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x00005c000f047a11ULL, 0x000fc800078040ffULL,
0x00005d000f057a11ULL, 0x000fe400000f440cULL, 0x00000003ff0f7819ULL, 0x000fc60000011607ULL,
0x000000100d047825ULL, 0x000fe200078e0004ULL, 0x000000740f00720cULL, 0x000fc80003f06070ULL,
0x0000000804007986ULL, 0x0023f2000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000107047824ULL, 0x102fe200078e020fULL, 0x000000a0000c7810ULL, 0x000fe20007ffe0ffULL,
0x00000020760f7824ULL, 0x000fc600078e020fULL, 0x0000000704047812ULL, 0x000fe400078ec0ffULL,
0x00000003ff0d7819ULL, 0x000fe4000001160cULL, 0x0ffffff804047812ULL, 0x000fe400078ef807ULL,
0x0000000707077812ULL, 0x000fc600078ec0ffULL, 0x0000001004067824ULL, 0x000fe200078e0203ULL,
0x000000050f047c12ULL, 0x000fe2000f8e30ffULL, 0x0000000811077824ULL, 0x000fe200078e0207ULL,
0x00005a00ff0f7a19ULL, 0x000fe4000001160fULL, 0x0000000006087984ULL, 0x000e620000000c00ULL,
0x0000000175047824ULL, 0x000fc800078e0204ULL, 0x000000820f0f7224ULL, 0x000fca00078e0204ULL,
0x0000000f020f7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005c000f047a11ULL, 0x000fc800078040ffULL, 0x00005d000f057a11ULL, 0x000fe400000f440eULL,
0x000000740d00720cULL, 0x000fc60003f06070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0023ea000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010c047824ULL, 0x102fe400078e020dULL, 0x00000020760d7824ULL, 0x000fc600078e020dULL,
0x0000000704057812ULL, 0x000fc800078ec0ffULL, 0x0ffffff805047812ULL, 0x000fe400078ef80cULL,
0x000000070c0c7812ULL, 0x000fc600078ec0ffULL, 0x0000001004067824ULL, 0x000fe200078e0203ULL,
0x000000050d047c12ULL, 0x000fe2000f8e30ffULL, 0x0000000811077824ULL, 0x000fe200078e020cULL,
0x00005a00ff0d7a19ULL, 0x000fe4000001160dULL, 0x0000000006087984ULL, 0x000e620000000c00ULL,
0x0000000175047824ULL, 0x000fc800078e0204ULL, 0x000000820d0d7224ULL, 0x000fca00078e0204ULL,
0x0000000d02057210ULL, 0x000fe40007f1e0ffULL, 0x000000c0000d7810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x00005c0005047a11ULL, 0x040fe400078040ffULL,
0x00000003ff0f7819ULL, 0x000fe4000001160dULL, 0x00005d0005057a11ULL, 0x000fe400000f440eULL,
0x000000740f00720cULL, 0x000fc60003f06070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0023ea000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010d047824ULL, 0x102fe200078e020fULL, 0x000000e000007810ULL, 0x000fe20007ffe0ffULL,
0x00000020760f7824ULL, 0x000fc600078e020fULL, 0x0000000704047812ULL, 0x000fe400078ec0ffULL,
0x00000003ff077819ULL, 0x000fe40000011600ULL, 0x0ffffff804047812ULL, 0x000fe400078ef80dULL,
0x000000070d0d7812ULL, 0x000fc600078ec0ffULL, 0x0000001004067824ULL, 0x000fe200078e0203ULL,
0x000000050f047c12ULL, 0x000fe2000f8e30ffULL, 0x00000008110d7824ULL, 0x000fe200078e020dULL,
0x00005a00ff0f7a19ULL, 0x000fe4000001160fULL, 0x0000000006087984ULL, 0x0002a20000000c00ULL,
0x0000000175047824ULL, 0x000fc800078e0204ULL, 0x000000820f0f7224ULL, 0x000fe400078e0204ULL,
0x0000000100067824ULL, 0x002fc600078e0207ULL, 0x0000000f020f7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x00005c000f047a11ULL, 0x000fc800078040ffULL,
0x00005d000f057a11ULL, 0x000fe400000f440cULL, 0x000000740700720cULL, 0x000fc60003f06070ULL,
0x000000100d047825ULL, 0x000fe200078e0004ULL, 0x00000007060d7812ULL, 0x000fc800078ec0ffULL,
0xfffffff80d067812ULL, 0x000fe200078ef800ULL, 0x0000000804007986ULL, 0x0043e8000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000001006067824ULL, 0x000fe200078e0203ULL,
0x0000000700007812ULL, 0x000fe200078ec0ffULL, 0x0000002076077824ULL, 0x000fc600078e0207ULL,
0x0000000006087984ULL, 0x002e620000000c00ULL, 0x0000000811057824ULL, 0x000fe200078e0200ULL,
0x0000000507047c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff077a19ULL, 0x000fc60000011607ULL,
0x0000000175047824ULL, 0x000fc800078e0204ULL, 0x0000008207077224ULL, 0x000fca00078e0204ULL,
0x0000000702077210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff047224ULL, 0x000fe200000e06ffULL,
0x00005c0007027a11ULL, 0x000fc800078040ffULL, 0x00005d0007037a11ULL, 0x000fca00000f4404ULL,
0x0000001005027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x002fe2000c101d08ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff5c7819ULL, 0x000fe20000011620ULL,
0xffffffffff227424ULL, 0x000fc600078e00ffULL, 0x0000001d5c00720cULL, 0x000fda0003f06070ULL,
0x0000000204038824ULL, 0x000fc800078e00ffULL, 0x0000680003088a24ULL, 0x000fc800078e025cULL,
0x0000640008088625ULL, 0x000fe200078e0009ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000808228981ULL, 0x000ea2000c1e1900ULL, 0x00006c00ff647624ULL, 0x000fe400078e00ffULL,
0x00006d00ff657624ULL, 0x000fe200078e00ffULL, 0x01260000ff067f8cULL, 0x002e68000c80043fULL,
0x0000000864647981ULL, 0x000722000c1e9900ULL, 0x000001ff0a00780cULL, 0x000fe20003f04070ULL,
0x000000800e217824ULL, 0x000fc400078e00ffULL, 0x0000008019027824ULL, 0x000fe400078e00ffULL,
0x0000004020037824ULL, 0x000fe400078e00ffULL, 0x00000080ff0b7424ULL, 0x000fc600078e00ffULL,
0x0000004002187812ULL, 0x000fe200078ef803ULL, 0x00000021220a7224ULL, 0x004fc800078e02ffULL,
0x000062000a087625ULL, 0x000fe200078e000bULL, 0x0000060000000947ULL, 0x000fea0003800000ULL,
0x00000002ff267819ULL, 0x00afe4000001161fULL, 0x0000001f1f147211ULL, 0x000fe400078fe8ffULL,
0x0000000826167810ULL, 0x000fe20007ffe0ffULL, 0x00000001180a7824ULL, 0x000fe200078e0226ULL,
0x0000001826297810ULL, 0x040fe40007ffe0ffULL, 0x0000001026287810ULL, 0x000fe20007ffe0ffULL,
0x00000001180c7824ULL, 0x000fe200078e0216ULL, 0x00000020261b7810ULL, 0x000fe20007ffe0ffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000002826237810ULL, 0x000fc40007ffe0ffULL,
0x00000003141a7812ULL, 0x000fe200078ec0ffULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x000000300a117812ULL, 0x000fe400078ef805ULL, 0x000000031e0a7217ULL, 0x000fe20007800000ULL,
0x0000000118107824ULL, 0x000fe200078e0229ULL, 0x000000300c137812ULL, 0x000fe200078ef805ULL,
0x00000001180e7824ULL, 0x000fe200078e0228ULL, 0x0000001108127210ULL, 0x000fe20007f1e0ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x00000013080c7210ULL, 0x000fc40007f3e0ffULL,
0x0000200020247811ULL, 0x000fe200078e68ffULL, 0x0000000109137824ULL, 0x040fe200000e060bULL,
0x00000030100b7812ULL, 0x000fe200078ef805ULL, 0x00000001090d7824ULL, 0x000fe200008e060dULL,
0x0ffffffc1a1f7812ULL, 0x000fe200078ef81fULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000000b08107210ULL, 0x000fe40007f3e0ffULL, 0x0000003026257810ULL, 0x000fe20007ffe0ffULL,
0x00000001180b7824ULL, 0x000fe200078e021bULL, 0x000000300e157812ULL, 0x000fe200078ef805ULL,
0x000000010a177824ULL, 0x000fc400078e0a03ULL, 0x000000800b0a7825ULL, 0x000fe200078e00ffULL,
0x00000015080e7210ULL, 0x000fe40007f1e0ffULL, 0x000000172800720cULL, 0x080fe20003fa6070ULL,
0x0000000416197824ULL, 0x000fe200078e00ffULL, 0x000000300a157812ULL, 0x000fe200078ef805ULL,
0x00000001180a7824ULL, 0x000fe200078e0223ULL, 0x000000172900720cULL, 0x000fe20003f86070ULL,
0x00000001090f7824ULL, 0x040fe200000e060fULL, 0x0000001508147210ULL, 0x000fe20007f5e0ffULL,
0x0000000109117824ULL, 0x000fe200008e0611ULL, 0x000000172600720cULL, 0x080fe20003f06070ULL,
0x000000101f1f7824ULL, 0x000fe200078e0224ULL, 0x000000171600720cULL, 0x000fe20003f26070ULL,
0x0000000109157824ULL, 0x000fe200010e060bULL, 0xfffffffc19197812ULL, 0x000fe200078ee21aULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000003826267810ULL, 0x000fc40007ffe0ffULL,
0x000000171b00720cULL, 0x080fe20003f66070ULL, 0x0000001019197824ULL, 0x000fe200078e0224ULL,
0x000000300a277812ULL, 0x000fe200078ef805ULL, 0x00000001180a7824ULL, 0x000fe200078e0225ULL,
0x000000172300720cULL, 0x000fe20003f46070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000121f7faeULL, 0x0003e2000c101c48ULL, 0x0000002708167210ULL, 0x000fe20007fde0ffULL,
0x000000041b1b7824ULL, 0x000fe200078e00ffULL, 0x000000172600720cULL, 0x080fe20003f06070ULL,
0x000000000c197faeULL, 0x0005e2000c901c48ULL, 0x000000172500720cULL, 0x000fe20003f26070ULL,
0x0000000109177824ULL, 0x000fe200030e060bULL, 0xfffffffc1b1b7812ULL, 0x000fe200078ee21aULL,
0x000000800a0a7825ULL, 0x000fc800078e00ffULL, 0x0000000428137824ULL, 0x002fe200078e00ffULL,
0x000000300a1f7812ULL, 0x100fe200078ef805ULL, 0x0000000423237824ULL, 0x000fe400078e00ffULL,
0x00000001180c7824ULL, 0x004fe200078e0226ULL, 0x0000001f080a7210ULL, 0x000fe20007fde0ffULL,
0x0000000429197824ULL, 0x000fe200078e00ffULL, 0xfffffffc13137812ULL, 0x100fe200078ee21aULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0xfffffffc231f7812ULL, 0x100fe400078ee21aULL,
0xfffffffc19197812ULL, 0x000fe200078ee21aULL, 0x0000000425257824ULL, 0x000fe200078e00ffULL,
0x000000300c057812ULL, 0x000fe200078ef805ULL, 0x0000000426277824ULL, 0x000fc400078e00ffULL,
0x00000001090b7824ULL, 0x000fe200030e060bULL, 0xfffffffc25237812ULL, 0x000fe200078ee21aULL,
0x0000001013137824ULL, 0x000fe200078e0224ULL, 0xfffffffc27257812ULL, 0x000fe200078ee21aULL,
0x0000001019197824ULL, 0x100fe200078e0224ULL, 0x0000000508087210ULL, 0x000fe20007fde0ffULL,
0x000000101b1b7824ULL, 0x100fe200078e0224ULL, 0x000000000e137faeULL, 0x0003e2000e901c48ULL,
0x000000101f1f7824ULL, 0x100fe400078e0224ULL, 0x0000001023237824ULL, 0x100fe200078e0224ULL,
0x0000000010197faeULL, 0x0003e2000e101c48ULL, 0x0000001025257824ULL, 0x000fc400078e0224ULL,
0x0000000109097824ULL, 0x000fe200030e060dULL, 0x00000000141b7faeULL, 0x0003e8000d901c48ULL,
0x00000000161f7faeULL, 0x0003e8000d101c48ULL, 0x000000000a237faeULL, 0x0003e8000c901c48ULL,
0x0000000008257faeULL, 0x0003e2000c101c48ULL, 0x0000054000007947ULL, 0x000fea0003800000ULL,
0x0000001f1f0c7211ULL, 0x04afe400078fe8ffULL, 0x000000081f137811ULL, 0x000fc400078ff0ffULL,
0x000000101f157811ULL, 0x040fe400078ff0ffULL, 0x000000181f177811ULL, 0x040fe400078ff0ffULL,
0x000000281f0d7811ULL, 0x040fe200078ff0ffULL, 0x00000001180e7824ULL, 0x000fe200078e0215ULL,
0x000000301f0f7811ULL, 0x000fe200078ff0ffULL, 0x0000000415157824ULL, 0x000fe200078e00ffULL,
0x000000030c147812ULL, 0x000fe200078ec0ffULL, 0x00000001180c7824ULL, 0x040fe200078e0213ULL,
0x000000201f0b7811ULL, 0x000fe200078ff0ffULL, 0x0000000413137824ULL, 0x000fe200078e00ffULL,
0x000000181f0a7211ULL, 0x040fe200078ff0ffULL, 0x0000000118107824ULL, 0x040fe200078e0217ULL,
0x000000381f117811ULL, 0x000fe200078ff0ffULL, 0x0000000417177824ULL, 0x000fe200078e00ffULL,
0xfffffffc13127812ULL, 0x100fe200078ee214ULL, 0x0000000118247824ULL, 0x040fe200078e020dULL,
0xfffffffc15137812ULL, 0x100fe200078ee214ULL, 0x000000040d0d7824ULL, 0x000fe200078e00ffULL,
0xfffffffc17157812ULL, 0x100fe200078ee214ULL, 0x0000000118267824ULL, 0x000fe200078e020fULL,
0x0ffffffc141f7812ULL, 0x000fe200078ef81fULL, 0x000000040f0f7824ULL, 0x000fe200078e00ffULL,
0xfffffffc0d177812ULL, 0x000fe200078ee214ULL, 0x00000001181a7824ULL, 0x000fe200078e020bULL,
0x00002000202a7811ULL, 0x000fe200078e68ffULL, 0x000000040b197824ULL, 0x000fc400078e00ffULL,
0x0000000118287824ULL, 0x000fe200078e0211ULL, 0xfffffffc0f187812ULL, 0x100fe200078ee214ULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0xfffffffc19167812ULL, 0x000fc600078ee214ULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x000000300a1b7812ULL, 0x000fc600078ef805ULL,
0x0000000411117824ULL, 0x000fe400078e00ffULL, 0x000000800e0e7825ULL, 0x000fc600078e00ffULL,
0xfffffffc11197812ULL, 0x000fe200078ee214ULL, 0x000000101f337824ULL, 0x100fe200078e022aULL,
0x0000001b08147210ULL, 0x000fe20007f1e0ffULL, 0x0000001017277824ULL, 0x100fe200078e022aULL,
0x000000300c177812ULL, 0x100fe200078ef805ULL, 0x00000010131f7824ULL, 0x000fe200078e022aULL,
0x000000300e137812ULL, 0x000fe200078ef805ULL, 0x0000008010107825ULL, 0x000fc800078e00ffULL,
0x0000001016257824ULL, 0x100fe200078e022aULL, 0x0000001708167210ULL, 0x000fe20007f3e0ffULL,
0x0000001018297824ULL, 0x100fe200078e022aULL, 0x0000001308187210ULL, 0x000fe20007f5e0ffULL,
0x0000001015237824ULL, 0x100fe200078e022aULL, 0x0000003010137812ULL, 0x000fe200078ef805ULL,
0x0000000109157824ULL, 0x000fe400000e060bULL, 0x00000010192b7824ULL, 0x000fe200078e022aULL,
0x0000001308107210ULL, 0x000fe20007f1e0ffULL, 0x0000000109177824ULL, 0x000fe200008e060dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014337faeULL, 0x0003e2000b901c48ULL,
0x000000801a0a7825ULL, 0x000fc800078e00ffULL, 0x0000000109197824ULL, 0x000fe200010e060fULL,
0x000000300a317812ULL, 0x000fe200078ef805ULL, 0x00000080240c7825ULL, 0x000fc800078e00ffULL,
0x00000010121b7824ULL, 0x000fe200078e022aULL, 0x000000300c2f7812ULL, 0x000fe200078ef805ULL,
0x00000080260e7825ULL, 0x000fc600078e00ffULL, 0x0000002f080c7210ULL, 0x000fe20007f3e0ffULL,
0x0000008028127825ULL, 0x000fe200078e00ffULL, 0x000000300e2d7812ULL, 0x000fe200078ef805ULL,
0x00000000161b7faeULL, 0x0003e4000b901c48ULL, 0x0000000109117824ULL, 0x040fe200000e0611ULL,
0x0000003012057812ULL, 0x000fe200078ef805ULL, 0x00000001090d7824ULL, 0x000fe200008e060dULL,
0x00000031080a7210ULL, 0x040fe20007f1e0ffULL, 0x00000000181f7faeULL, 0x0003e2000b901c48ULL,
0x0000002d080e7210ULL, 0x000fc40007f5e0ffULL, 0x0000000508087210ULL, 0x000fe20007f7e0ffULL,
0x00000001090b7824ULL, 0x040fe200000e060bULL, 0x0000000010237faeULL, 0x0003e2000b901c48ULL,
0x00000001090f7824ULL, 0x040fe400010e060fULL, 0x0000000109097824ULL, 0x000fe200018e0613ULL,
0x000000000a257faeULL, 0x0003e8000b901c48ULL, 0x000000000c277faeULL, 0x0003e8000b901c48ULL,
0x000000000e297faeULL, 0x0003e8000b901c48ULL, 0x00000000082b7faeULL, 0x0003e4000b901c48ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000087805ULL, 0x002fc40000015200ULL,
0x01260400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fc40007804807ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a080a7210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e09ULL, 0x003d09000a00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400a00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff057819ULL, 0x000fc8000001140bULL,
0x0000000a05057211ULL, 0x000fca00078110ffULL, 0x000000ffff0a7224ULL, 0x000fca00000e060bULL,
0x0000000205057819ULL, 0x000fc8000000120aULL, 0x000000050000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01260400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000e640000000000ULL, 0x0000002020057824ULL, 0x002fca00078e0205ULL,
0x00000004ff067819ULL, 0x000fe40000011605ULL, 0x0000000105077810ULL, 0x040fe40007ffe0ffULL,
0x0ffffffe06087812ULL, 0x000fe400078ec0ffULL, 0x0000001f05067812ULL, 0x000fc600078ec0ffULL,
0x00000001080a7824ULL, 0x040fe400078e0207ULL, 0x0000000105097824ULL, 0x000fe200078e0208ULL,
0x0000000808087810ULL, 0x000fe20007ffe0ffULL, 0x00000010060b7824ULL, 0x000fe200078e00ffULL,
0x0000000f0a0a7812ULL, 0x000fe200078ec0ffULL, 0x00000010060c7824ULL, 0x000fe200078e00ffULL,
0x0000000f09097812ULL, 0x000fe200078ec0ffULL, 0x0000000107077824ULL, 0x000fe200078e0208ULL,
0x000001f00b0a7812ULL, 0x000fe200078ee20aULL, 0x0000000105057824ULL, 0x000fe200078e0208ULL,
0x000001f00c097812ULL, 0x000fe200078ee209ULL, 0x0000001006087824ULL, 0x040fe200078e00ffULL,
0x0000000f07077812ULL, 0x000fe200078ec0ffULL, 0x000000000a0c7984ULL, 0x000e62000000cc00ULL,
0x0000001006067824ULL, 0x000fe200078e00ffULL, 0x0000000f05057812ULL, 0x000fc400078ec0ffULL,
0x0000000009107984ULL, 0x000ea4000000cc00ULL, 0x000001f006077812ULL, 0x000fe400078ee207ULL,
0x000001f008057812ULL, 0x000fe200078ee205ULL, 0x000000ffff167224ULL, 0x002fe400078e000cULL,
0x000000ffff177224ULL, 0x000fe400078e000eULL, 0x000000ffff147224ULL, 0x004fe400078e0010ULL,
0x000000ffff157224ULL, 0x000fc400078e0012ULL, 0x000000ffff1a7224ULL, 0x000fe400078e000dULL,
0x000000ffff1b7224ULL, 0x000fe200078e000fULL, 0x0000001409007388ULL, 0x000fe2000000cc00ULL,
0x000000ffff187224ULL, 0x000fe400078e0011ULL, 0x000000ffff197224ULL, 0x000fca00078e0013ULL,
0x000000180a007388ULL, 0x000fe8000000cc00ULL, 0x00000000070c7984ULL, 0x000e68000000cc00ULL,
0x0000000005107984ULL, 0x000ea2000000cc00ULL, 0x000000ffff277224ULL, 0x002fe400078e000eULL,
0x000000ffff267224ULL, 0x000fc400078e000cULL, 0x000000ffff0e7224ULL, 0x000fe400078e000dULL,
0x000000ffff247224ULL, 0x004fe400078e0010ULL, 0x000000ffff257224ULL, 0x000fe400078e0012ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0011ULL, 0x000000ffff0d7224ULL, 0x000fe200078e0013ULL,
0x0000002405007388ULL, 0x0003e8000000cc00ULL, 0x0000000c07007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01260000ff0a7f8cULL, 0x000ea2000c80043fULL,
0x000000ffff0c7224ULL, 0x002fc600078e00ffULL, 0x0000000000067805ULL, 0x000fc80000015200ULL,
0x01260400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x006fc4000780480bULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fcc0000015200ULL,
0x0000000806087210ULL, 0x000fca0007f1e1ffULL, 0x0000000109097824ULL, 0x000fe200000e0e07ULL,
0x003d09000800780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400800780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff057819ULL, 0x000fc80000011409ULL, 0x0000000805057211ULL, 0x000fca00078110ffULL,
0x000000ffff087224ULL, 0x000fca00000e0609ULL, 0x0000000205057819ULL, 0x000fc80000001208ULL,
0x000000050000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01260400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe4000780480bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff1c00720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x00000000001f7919ULL, 0x000e620000000000ULL,
0x00005800ff5e7624ULL, 0x000fe200078e00ffULL, 0x800058001e5d7a10ULL, 0x000fe20007ffe0ffULL,
0x0000680004657a24ULL, 0x000fe200078e02ffULL, 0x3db504f364647820ULL, 0x010fe20000410000ULL,
0x0001268820637811ULL, 0x000fe200078e18ffULL, 0x0000000000607805ULL, 0x000fe2000001ff00ULL,
0x0000001f5e047810ULL, 0x040fe40007ffe0ffULL, 0xffffffff5e5f7810ULL, 0x000fe40007ffe0ffULL,
0x00000004ff047819ULL, 0x000fc40000011604ULL, 0x0001260820627811ULL, 0x000fe400078e28ffULL,
0x000000095e5e7810ULL, 0x000fe40007ffe0ffULL, 0x00000008ff5d7819ULL, 0x000fe4000001165dULL,
0x0ffffffe04237812ULL, 0x000fc400078ec0ffULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x000000ffff677224ULL, 0x000fe200078e0061ULL, 0x00000000002e7805ULL, 0x008fe2000001ff00ULL,
0x000000ffff667224ULL, 0x000fe200078e00ffULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x014fc4000001ff00ULL,
0x000000016600780cULL, 0x000fe20003f25270ULL, 0x0000002122507224ULL, 0x030fe200078e02ffULL,
0x0000000160307810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff517424ULL, 0x000fe200078e00ffULL,
0x0000000166317810ULL, 0x000fe20007ffe0ffULL, 0x00000bc000007945ULL, 0x000fe20003800000ULL,
0x000000ffff687224ULL, 0x000fe200078e0066ULL, 0x0000000167617812ULL, 0x000fc400078e0cffULL,
0x000000023100780cULL, 0x040fe20003f06070ULL, 0x000000ffff667224ULL, 0x000fe200078e0031ULL,
0x000000ff31327207ULL, 0x000fe40000800000ULL, 0x000000ffff301224ULL, 0x000fc800078e0260ULL,
0x0000010030587824ULL, 0x040fe200078e0203ULL, 0x0000000130337810ULL, 0x000fe20007ffe0ffULL,
0x0000620050307625ULL, 0x000fc600078e0051ULL, 0x0000001c3300720cULL, 0x000fe40003f46070ULL,
0x0000004058337812ULL, 0x000fca00078ec0ffULL, 0x00000001026c7824ULL, 0x000fcc00078e0233ULL,
0x000005d00000a947ULL, 0x000fea0003800000ULL, 0x000000101f337824ULL, 0x002fe200078e00ffULL,
0x00000002ff6e7819ULL, 0x000fe2000001161fULL, 0x0000000220697824ULL, 0x000fc600078e0261ULL,
0x0000003033517812ULL, 0x000fe200078ec0ffULL, 0x000000016e537824ULL, 0x140fe200078e026cULL,
0x000000086e6a7810ULL, 0x040fe40007ffe0ffULL, 0x000000186e737810ULL, 0x000fe20007ffe0ffULL,
0x0000004032507824ULL, 0x000fe200078e0251ULL, 0x000000206e747810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff517224ULL, 0x000fe200078e00ffULL, 0x000000581e337217ULL, 0x000fe20007800000ULL,
0x000000016a557824ULL, 0x000fe200078e026cULL, 0x000000106e6b7810ULL, 0x000fe20007ffe0ffULL,
0x0000008053527825ULL, 0x000fe200078e0050ULL, 0x0000200069697811ULL, 0x000fc400078e60ffULL,
0x000000306e757810ULL, 0x000fe20007ffe0ffULL, 0x0000008055547825ULL, 0x000fe200078e0050ULL,
0x00000052305a7210ULL, 0x040fe40007f3e0ffULL, 0x0000001f1f527211ULL, 0x000fe200078fe8ffULL,
0x0000000173597824ULL, 0x100fe200078e026cULL, 0x0000005430547210ULL, 0x000fe20007f5e0ffULL,
0x00000001315b7824ULL, 0x000fe200008e0653ULL, 0x0000000352707812ULL, 0x000fe200078ec0ffULL,
0x0000000174537824ULL, 0x000fe400078e026cULL, 0x0000000133337824ULL, 0x000fe200078e0a58ULL,
0x0ffffffc70727812ULL, 0x000fe200078ef81fULL, 0x0000008059587825ULL, 0x000fc600078e0050ULL,
0x000000337300720cULL, 0x000fe20003fa6070ULL, 0x0000008053527825ULL, 0x000fe200078e0050ULL,
0x0000005830587210ULL, 0x000fc60007f3e0ffULL, 0x000000046a6d7824ULL, 0x000fe400078e00ffULL,
0x000000016c577824ULL, 0x000fe400078e026bULL, 0x0000000131557824ULL, 0x000fe200010e0655ULL,
0x000000336a00720cULL, 0x000fe20003f46070ULL, 0x000000046b6f7824ULL, 0x000fe200078e00ffULL,
0x00000052306a7210ULL, 0x000fe20007f9e0ffULL, 0x0000008057567825ULL, 0x000fe200078e0050ULL,
0xfffffffc6d527812ULL, 0x000fc600078ee270ULL, 0x00000010726d7824ULL, 0x000fe200078e0269ULL,
0xfffffffc6f727812ULL, 0x000fe200078ee270ULL, 0x0000000131597824ULL, 0x040fe200008e0659ULL,
0x0000005630567210ULL, 0x000fe20007f7e0ffULL, 0x00000010526f7824ULL, 0x100fe200078e0269ULL,
0x000000336e00720cULL, 0x080fe20003f26070ULL, 0x0000001072717824ULL, 0x000fe200078e0269ULL,
0x000000286e727810ULL, 0x040fe20007ffe0ffULL, 0x0000000131577824ULL, 0x000fe200018e0657ULL,
0x000000336b00720cULL, 0x080fe20003f66070ULL, 0x00000001316b7824ULL, 0x000fe200020e0653ULL,
0x000000386e6e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000172537824ULL, 0x000fe200078e026cULL,
0x000000337400720cULL, 0x000fe20003f86070ULL, 0x0000000473737824ULL, 0x000fc400078e00ffULL,
0x0000008053527825ULL, 0x000fe400078e0050ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000005a6d7faeULL, 0x0003e2000c901c48ULL, 0x000000336e00720cULL, 0x080fe40003f26070ULL,
0x0000005230527210ULL, 0x000fe20007fde0ffULL, 0x00000000546f7faeULL, 0x0005e2000d101c48ULL,
0x000000337500720cULL, 0x000fc60003f46070ULL, 0x0000000056717faeULL, 0x0007e2000d901c48ULL,
0x000000337200720cULL, 0x000fe20003f66070ULL, 0x0000000474337824ULL, 0x000fe400078e00ffULL,
0x00000001755b7824ULL, 0x102fe400078e026cULL, 0x000000016e6d7824ULL, 0x000fe200078e026cULL,
0xfffffffc335a7812ULL, 0x000fe200078ee270ULL, 0x000000805b547825ULL, 0x004fc800078e0050ULL,
0x0000000131537824ULL, 0x000fe200030e0653ULL, 0x0000005430547210ULL, 0x000fe20007fde0ffULL,
0x0000000472577824ULL, 0x008fe200078e00ffULL, 0xfffffffc73567812ULL, 0x000fe200078ee270ULL,
0x0000000475757824ULL, 0x000fe400078e00ffULL, 0x000000806d507825ULL, 0x000fe200078e0050ULL,
0xfffffffc576c7812ULL, 0x000fc600078ee270ULL, 0x000000046e5b7824ULL, 0x000fe200078e00ffULL,
0xfffffffc756e7812ULL, 0x100fe200078ee270ULL, 0x0000000131557824ULL, 0x000fe200030e0655ULL,
0x0000005030307210ULL, 0x000fe20007fde0ffULL, 0x0000001056337824ULL, 0x100fe200078e0269ULL,
0xfffffffc5b707812ULL, 0x000fe200078ee270ULL, 0x000000105a577824ULL, 0x100fe400078e0269ULL,
0x000000106c5b7824ULL, 0x100fe200078e0269ULL, 0x0000000058337faeULL, 0x0003e2000e901c48ULL,
0x000000106e6d7824ULL, 0x000fc400078e0269ULL, 0x0000001070697824ULL, 0x000fe200078e0269ULL,
0x000000006a577faeULL, 0x0003e2000e101c48ULL, 0x0000000131317824ULL, 0x000fc600030e0651ULL,
0x00000000525b7faeULL, 0x0003e8000d901c48ULL, 0x00000000546d7faeULL, 0x0003e8000d101c48ULL,
0x0000000030697faeULL, 0x0003e2000c901c48ULL, 0x0000051000007947ULL, 0x000fea0003800000ULL,
0x0000000220517824ULL, 0x000fe200078e0261ULL, 0x000000081f557811ULL, 0x042fe200078ff0ffULL,
0x000000101f337824ULL, 0x040fe200078e00ffULL, 0x000000101f577811ULL, 0x000fc400078ff0ffULL,
0x000000181f597811ULL, 0x000fe200078ff0ffULL, 0x0000000155537824ULL, 0x100fe200078e026cULL,
0x000000201f5b7811ULL, 0x000fe200078ff0ffULL, 0x00000004576f7824ULL, 0x000fe200078e00ffULL,
0x000000281f697811ULL, 0x000fe200078ff0ffULL, 0x0000000459717824ULL, 0x000fe200078e00ffULL,
0x000000301f6d7811ULL, 0x000fe200078ff0ffULL, 0x000000045b737824ULL, 0x000fe200078e00ffULL,
0x0000200051797811ULL, 0x000fe200078e60ffULL, 0x0000000455517824ULL, 0x000fe200078e00ffULL,
0x000000381f777811ULL, 0x000fe200078ff0ffULL, 0x0000000157557824ULL, 0x100fe200078e026cULL,
0x0000001f1f507211ULL, 0x000fe200078fe8ffULL, 0x0000000159577824ULL, 0x100fe200078e026cULL,
0x0000003033337812ULL, 0x000fe200078ec0ffULL, 0x000000015b597824ULL, 0x100fe200078e026cULL,
0x0000000350507812ULL, 0x000fe200078ec0ffULL, 0x00000001695b7824ULL, 0x000fc400078e026cULL,
0x000000016d6b7824ULL, 0x000fe200078e026cULL, 0xfffffffc51527812ULL, 0x100fe200078ee250ULL,
0x0000000469697824ULL, 0x000fe200078e00ffULL, 0xfffffffc6f547812ULL, 0x100fe200078ee250ULL,
0x000000046d6d7824ULL, 0x000fe200078e00ffULL, 0xfffffffc71567812ULL, 0x100fe200078ee250ULL,
0x0000000477757824ULL, 0x000fe200078e00ffULL, 0xfffffffc73587812ULL, 0x000fe200078ee250ULL,
0x0000000177777824ULL, 0x000fe200078e026cULL, 0xfffffffc695a7812ULL, 0x100fe200078ee250ULL,
0x0000001054697824ULL, 0x100fe200078e0279ULL, 0xfffffffc6d6a7812ULL, 0x100fe200078ee250ULL,
0x000000ffff6d7224ULL, 0x000fe200078e00ffULL, 0xfffffffc756e7812ULL, 0x000fe200078ee250ULL,
0x00000010566f7824ULL, 0x000fe200078e0279ULL, 0x0ffffffc50507812ULL, 0x000fe200078ef81fULL,
0x0000001058717824ULL, 0x000fe200078e0279ULL, 0x0000006c1f517211ULL, 0x000fe200078ff0ffULL,
0x00000040326c7824ULL, 0x000fc400078e0233ULL, 0x00000010507b7824ULL, 0x100fe400078e0279ULL,
0x0000001052337824ULL, 0x000fe400078e0279ULL, 0x0000008051507825ULL, 0x000fc800078e006cULL,
0x0000008053527825ULL, 0x000fe200078e006cULL, 0x0000005030507210ULL, 0x000fc60007f3e0ffULL,
0x0000008055547825ULL, 0x000fe200078e006cULL, 0x0000005230527210ULL, 0x000fc60007f5e0ffULL,
0x0000008057567825ULL, 0x000fe200078e006cULL, 0x0000005430547210ULL, 0x000fc60007f7e0ffULL,
0x000000105a737824ULL, 0x000fe200078e0279ULL, 0x0000005630567210ULL, 0x000fe20007f9e0ffULL,
0x0000008059587825ULL, 0x000fc800078e006cULL, 0x000000106a757824ULL, 0x000fe400078e0279ULL,
0x000000805b5a7825ULL, 0x000fc800078e006cULL, 0x000000806b6a7825ULL, 0x000fc800078e006cULL,
0x00000080776c7825ULL, 0x000fc800078e006cULL, 0x0000000131517824ULL, 0x040fe200008e0651ULL,
0x0000005830587210ULL, 0x040fe20007f3e0ffULL, 0x0000000131537824ULL, 0x040fe200010e0653ULL,
0x0000005a305a7210ULL, 0x040fe20007f5e0ffULL, 0x0000000131557824ULL, 0x040fe200018e0655ULL,
0x0000006a306a7210ULL, 0x040fe20007f7e0ffULL, 0x0000000131577824ULL, 0x040fe200020e0657ULL,
0x0000006c30307210ULL, 0x000fe20007f9e0ffULL, 0x0000000131597824ULL, 0x040fe200008e0659ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000507b7faeULL, 0x0003e2000b901c48ULL,
0x00000001315b7824ULL, 0x000fc400010e065bULL, 0x00000001316b7824ULL, 0x040fe200018e066bULL,
0x0000000052337faeULL, 0x0003e2000b901c48ULL, 0x000000106e797824ULL, 0x000fe400078e0279ULL,
0x0000000131317824ULL, 0x000fe200020e066dULL, 0x0000000054697faeULL, 0x0003e8000b901c48ULL,
0x00000000566f7faeULL, 0x0003e8000b901c48ULL, 0x0000000058717faeULL, 0x0003e8000b901c48ULL,
0x000000005a737faeULL, 0x0003e8000b901c48ULL, 0x000000006a757faeULL, 0x0003e8000b901c48ULL,
0x0000000030797faeULL, 0x0003e4000b901c48ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000013200780cULL, 0x000fe20003f25270ULL, 0x000000a000007945ULL, 0x000fd80003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x000000025c5c7810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff227424ULL, 0x000fc600078e00ffULL, 0x0000001d5c00720cULL, 0x000fda0003f26070ULL,
0x0000004000001947ULL, 0x000fea0003800000ULL, 0x0000000265307824ULL, 0x002fe400078e025cULL,
0x00000004ff317424ULL, 0x000fc800078e00ffULL, 0x0000640030307625ULL, 0x000fca00078e0031ULL,
0x0000000830227981ULL, 0x000324000c1e1900ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000008686c7824ULL, 0x000fe400078e00ffULL,
0x000000ffff717224ULL, 0x002fe400078e00ffULL, 0x00000010ff6b7424ULL, 0x000fe200078e00ffULL,
0x000000126c6a7810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff697224ULL, 0x000fe200078e00ffULL,
0x000000026c6c7810ULL, 0x000fe20007ffe0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xfffffff81f307812ULL, 0x040fe200078ec0ffULL, 0x00000002206d7824ULL, 0x000fe200078e0267ULL,
0x000000081f507812ULL, 0x020fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000730737812ULL, 0x000fe200078ef81fULL, 0x0000000868337824ULL, 0x000fe200078e026bULL,
0x000020006d6d7811ULL, 0x000fc400078e60ffULL, 0x00000001ff747819ULL, 0x000fe20000011673ULL,
0x0000000473317824ULL, 0x040fe200078e00ffULL, 0x00000007507a7812ULL, 0x000fe200078ef81fULL,
0x0000000473737824ULL, 0x000fe200078e00ffULL, 0x000000201f587810ULL, 0x000fe20007ffe0ffULL,
0x0000000174307824ULL, 0x000fe200078e0269ULL, 0x000000107a707812ULL, 0x040fe200078efcffULL,
0x000000107a7d7824ULL, 0x000fe200078e00ffULL, 0xfffffff858587812ULL, 0x000fe400078ec0ffULL,
0xfffffffc31327812ULL, 0x000fc400078ee230ULL, 0x000000071f317812ULL, 0x040fe400078ec0ffULL,
0x000000501f307211ULL, 0x000fe200078fe0ffULL, 0x0000001032327824ULL, 0x000fe200078e026dULL,
0x00000007586f7812ULL, 0x000fe400078ef81fULL, 0x00000001697f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000131727824ULL, 0x000fe200078e0230ULL, 0x000000003254783bULL, 0x000e620000000200ULL,
0x0000000868317824ULL, 0x000fe200078e0271ULL, 0x00000001ff6e7819ULL, 0x000fe2000001166fULL,
0x000000107a307824ULL, 0x000fe200078e00ffULL, 0x0000006a727e7210ULL, 0x040fe20007ffe071ULL,
0x0000000172317824ULL, 0x000fc400078e0231ULL, 0x0000000172337824ULL, 0x000fe400078e0233ULL,
0x000000046f597824ULL, 0x000fe200078e00ffULL, 0xfffffff030317812ULL, 0x000fe200078ee231ULL,
0x0000001070307824ULL, 0x000fe400078e00ffULL, 0x000000016e587824ULL, 0x000fe200078e0269ULL,
0x0000000269697810ULL, 0x000fe20007ffe0ffULL, 0x0000001031507824ULL, 0x000fe200078e00ffULL,
0xfffffff030337812ULL, 0x000fe200078ee233ULL, 0x0000000174747824ULL, 0x100fe200078e027fULL,
0xfffffffc59587812ULL, 0x000fe200078ee258ULL, 0x000000016e6e7824ULL, 0x000fc400078e027fULL,
0x0000001033337824ULL, 0x000fe200078e00ffULL, 0x000000005050783bULL, 0x000ea20000000200ULL,
0x0000001058587824ULL, 0x000fe200078e026dULL, 0xfffffffc73807812ULL, 0x000fe200078ee274ULL,
0x000000046f6f7824ULL, 0x000fe400078e00ffULL, 0x000000003330783bULL, 0x000ee60000000200ULL,
0xfffffffc6f6e7812ULL, 0x000fe400078ee26eULL, 0x00000018ff5a7819ULL, 0x002fc40000011654ULL,
0x00000010ff597819ULL, 0x000fe40000011654ULL, 0x0000ffff54757812ULL, 0x040fe400078ec0ffULL,
0x0000005aff5b723eULL, 0x000fe400020006ffULL, 0x000000ff595a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff54547812ULL, 0x000fe400078ec0ffULL, 0x00000008ff597819ULL, 0x000fc40000011675ULL,
0x00000054ff54723eULL, 0x000fe400020006ffULL, 0x00000059ff59723eULL, 0x000fe400020006ffULL,
0x0000005aff77723eULL, 0x000fe400020006ffULL, 0x00000018ff757819ULL, 0x000fe40000011655ULL,
0x0000541054767816ULL, 0x000fe40000000059ULL, 0x00000010ff547819ULL, 0x000fc40000011655ULL,
0x0000ffff55797812ULL, 0x000fe400078ec0ffULL, 0x0000541077777816ULL, 0x000fe4000000005bULL,
0x00000075ff78723eULL, 0x000fe200020006ffULL, 0x000000005858783bULL, 0x000e620000000200ULL,
0x000000ff54757812ULL, 0x000fe400078ec0ffULL, 0x000000ff55557812ULL, 0x000fe200078ec0ffULL,
0x000000765034723cULL, 0x004f620000001834ULL, 0x00000008ff547819ULL, 0x000fc40000011679ULL,
0x00000055ff55723eULL, 0x000fe400020006ffULL, 0x00000054ff54723eULL, 0x000fe400020006ffULL,
0x0000ffff577b7812ULL, 0x000fe200078ec0ffULL, 0x000000763010723cULL, 0x008bee0000001810ULL,
0x00000075ff77723eULL, 0x020fc400020006ffULL, 0x0000541055767816ULL, 0x000fe40000000054ULL,
0x0000541077777816ULL, 0x000fe40000000078ULL, 0x00000010ff547819ULL, 0x100fe40000011656ULL,
0x0000ffff56787812ULL, 0x000fe400078ec0ffULL, 0x00000018ff757819ULL, 0x000fe20000011656ULL,
0x000000765004723cULL, 0x000f620000001804ULL, 0x000000ff54557812ULL, 0x000fc400078ec0ffULL,
0x000000ff56567812ULL, 0x000fe400078ec0ffULL, 0x00000008ff547819ULL, 0x000fe40000011678ULL,
0x00000075ff75723eULL, 0x000fe200020006ffULL, 0x000000763014723cULL, 0x000f620000001814ULL,
0x00000056ff56723eULL, 0x000fe400020006ffULL, 0x00000055ff55723eULL, 0x000fe400020006ffULL,
0x00000054ff54723eULL, 0x000fc400020006ffULL, 0x0000541055557816ULL, 0x000fe40000000075ULL,
0x0000541056547816ULL, 0x000fe40000000054ULL, 0x0000006c72567210ULL, 0x000fe40007ffe071ULL,
0x00000010ff717819ULL, 0x002fe40000011658ULL, 0xfffffff07d7d7812ULL, 0x000fe200078ee256ULL,
0x000000545038723cULL, 0x000fe20000001838ULL, 0x000000ff57567812ULL, 0x000fc400078ec0ffULL,
0x00000018ff727819ULL, 0x000fe40000011658ULL, 0x000000ff58737812ULL, 0x040fe400078ec0ffULL,
0x0000ffff58817812ULL, 0x000fe200078ec0ffULL, 0x00000054303c723cULL, 0x000be2000000183cULL,
0x00000056ff56723eULL, 0x000fe400020006ffULL, 0x00000010ff587819ULL, 0x100fe40000011659ULL,
0x00000018ff747819ULL, 0x000fc40000011659ULL, 0x00000010ff547819ULL, 0x120fe40000011657ULL,
0x00000018ff557819ULL, 0x000fe40000011657ULL, 0x000000ff54577812ULL, 0x000fe400078ec0ffULL,
0x00000008ff547819ULL, 0x000fe4000001167bULL, 0x00000055ff55723eULL, 0x000fe400020006ffULL,
0x00000057ff57723eULL, 0x000fc400020006ffULL, 0x00000054ff54723eULL, 0x000fe400020006ffULL,
0x0000541057577816ULL, 0x000fe40000000055ULL, 0x0000541056567816ULL, 0x000fe40000000054ULL,
0x00000008ff547819ULL, 0x000fe40000011681ULL, 0x000000ff58587812ULL, 0x000fe400078ec0ffULL,
0x00000010ff767819ULL, 0x100fe2000001165aULL, 0x000000565008723cULL, 0x000f620000001808ULL,
0x00000018ff777819ULL, 0x000fc4000001165aULL, 0x000000ff5a787812ULL, 0x040fe400078ec0ffULL,
0x0000ffff5a837812ULL, 0x000fe400078ec0ffULL, 0x000000ff59757812ULL, 0x040fe200078ec0ffULL,
0x00000056304c723cULL, 0x000b62000000184cULL, 0x0000ffff59827812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5a7819ULL, 0x100fe4000001165bULL, 0x00000018ff797819ULL, 0x000fc4000001165bULL,
0x000000ff5b7a7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff5b847812ULL, 0x000fe200078ec0ffULL,
0x00000010805b7824ULL, 0x000fe200078e026dULL, 0x00000073ff73723eULL, 0x000fe400020006ffULL,
0x00000074ff59723eULL, 0x000fe400020006ffULL, 0x00000054ff54723eULL, 0x000fe400020006ffULL,
0x00000058ff58723eULL, 0x000fc400020006ffULL, 0x000000ff71717812ULL, 0x000fe400078ec0ffULL,
0x00000008ff567819ULL, 0x020fe40000011682ULL, 0x0000541073747816ULL, 0x000fe40000000054ULL,
0x00000075ff55723eULL, 0x000fe400020006ffULL, 0x000000ff5a577812ULL, 0x000fe400078ec0ffULL,
0x0000541058737816ULL, 0x000fc40000000059ULL, 0x00000072ff72723eULL, 0x000fe200020006ffULL,
0x000000005b58783bULL, 0x000e620000000200ULL, 0x00000071ff75723eULL, 0x000fe400020006ffULL,
0x00000056ff56723eULL, 0x000fe400020006ffULL, 0x0000541075757816ULL, 0x000fe40000000072ULL,
0x0000541055727816ULL, 0x000fe40000000056ULL, 0x000000ff76767812ULL, 0x000fc400078ec0ffULL,
0x00000008ff547819ULL, 0x000fe20000011683ULL, 0x000000745040723cULL, 0x040f620000001840ULL,
0x00000008ff557819ULL, 0x000fe40000011684ULL, 0x00000079ff7c723eULL, 0x000fe400020006ffULL,
0x00000077ff77723eULL, 0x000fe400020006ffULL, 0x00000078ff78723eULL, 0x000fe200020006ffULL,
0x000000725044723cULL, 0x000fe20000001844ULL, 0x00000076ff79723eULL, 0x000fc400020006ffULL,
0x00000054ff54723eULL, 0x000fe400020006ffULL, 0x0000007aff7a723eULL, 0x000fe400020006ffULL,
0x00000057ff7b723eULL, 0x000fe200020006ffULL, 0x0000001070577824ULL, 0x000fe200078e00ffULL,
0x00000055ff55723eULL, 0x000fe200020006ffULL, 0x000000743018723cULL, 0x000f620000001818ULL,
0x0000541079797816ULL, 0x000fe40000000077ULL, 0x0000541078787816ULL, 0x000fe20000000054ULL,
0x000000107d547824ULL, 0x000fe200078e00ffULL, 0x000054107b7b7816ULL, 0x000fc4000000007cULL,
0x000054107a7a7816ULL, 0x000fe20000000055ULL, 0x000000723024723cULL, 0x000be20000001824ULL,
0xfffffff0577e7812ULL, 0x000fe400078ee27eULL, 0x000000005454783bULL, 0x000ea20000000200ULL,
0x00000018ff707819ULL, 0x102fe40000011658ULL, 0x00000010ff6f7819ULL, 0x000fe40000011658ULL,
0x00000078500c723cULL, 0x000f62000000180cULL, 0x0000ffff58717812ULL, 0x000fc400078ec0ffULL,
0x00000070ff72723eULL, 0x020fe400020006ffULL, 0x000000ff6f707812ULL, 0x000fe400078ec0ffULL,
0x000000ff58587812ULL, 0x000fe200078ec0ffULL, 0x0000007a5048723cULL, 0x000b620000001848ULL,
0x00000008ff6f7819ULL, 0x000fe40000011671ULL, 0x00000058ff58723eULL, 0x000fe400020006ffULL,
0x0000006fff6f723eULL, 0x000fc400020006ffULL, 0x000000107e507824ULL, 0x020fe200078e00ffULL,
0x000000783028723cULL, 0x040f620000001828ULL, 0x00000070ff71723eULL, 0x000fe400020006ffULL,
0x0000541058707816ULL, 0x000fe4000000006fULL, 0x000000005050783bULL, 0x000e620000000200ULL,
0x0000ffff59587812ULL, 0x000fe400078ec0ffULL, 0x0000007a302c723cULL, 0x000b62000000182cULL,
0x0000541071717816ULL, 0x000fc40000000072ULL, 0x00000008ff587819ULL, 0x000fc80000011658ULL,
0x000000106e307824ULL, 0x020fe200078e026dULL, 0x00000010ff6d7819ULL, 0x100fe40000011659ULL,
0x00000018ff6e7819ULL, 0x000fe20000011659ULL, 0x000000705434723cULL, 0x004f620000001834ULL,
0x000000ff6d6d7812ULL, 0x000fe200078ec0ffULL, 0x000000003030783bULL, 0x000ea20000000200ULL,
0x000000ff59597812ULL, 0x000fe400078ec0ffULL, 0x0000006eff6e723eULL, 0x000fe400020006ffULL,
0x0000006dff6f723eULL, 0x000fc400020006ffULL, 0x00000059ff59723eULL, 0x000fe400020006ffULL,
0x00000058ff58723eULL, 0x000fe400020006ffULL, 0x000054106f6f7816ULL, 0x000fe4000000006eULL,
0x00005410596e7816ULL, 0x000fe40000000058ULL, 0x00000010ff587819ULL, 0x100fe4000001165bULL,
0x00000018ff6d7819ULL, 0x000fc4000001165bULL, 0x000000ff58597812ULL, 0x000fe200078ec0ffULL,
0x0000006e5404723cULL, 0x000f700000001804ULL, 0x000000705010723cULL, 0x042b6e0000001810ULL,
0x0000ffff5b717812ULL, 0x060fe200078ec0ffULL, 0x0000006e5014723cULL, 0x000b620000001814ULL,
0x000000ff5b5b7812ULL, 0x000fc400078ec0ffULL, 0x00000008ff587819ULL, 0x000fe40000011671ULL,
0x0000006dff70723eULL, 0x000fe400020006ffULL, 0x0000005bff5b723eULL, 0x000fe400020006ffULL,
0x00000059ff6f723eULL, 0x020fe400020006ffULL, 0x00000058ff6d723eULL, 0x000fe400020006ffULL,
0x00000010ff587819ULL, 0x000fc4000001165aULL, 0x0000ffff5a717812ULL, 0x000fe400078ec0ffULL,
0x000054106f6f7816ULL, 0x000fe40000000070ULL, 0x000054105b6e7816ULL, 0x000fe4000000006dULL,
0x00000018ff597819ULL, 0x000fe4000001165aULL, 0x000000ff585b7812ULL, 0x000fe400078ec0ffULL,
0x000000ff5a5a7812ULL, 0x000fe200078ec0ffULL, 0x0000006e5408723cULL, 0x000f620000001808ULL,
0x00000008ff587819ULL, 0x000fc40000011671ULL, 0x0000005aff5a723eULL, 0x000fe400020006ffULL,
0x00000058ff58723eULL, 0x000fe400020006ffULL, 0x00000010ff6d7819ULL, 0x004fe20000011630ULL,
0x0000006e504c723cULL, 0x000b62000000184cULL, 0x0000ffff30747812ULL, 0x000fe400078ec0ffULL,
0x00000010ff707819ULL, 0x000fe40000011631ULL, 0x000000ff31717812ULL, 0x000fc400078ec0ffULL,
0x00000018ff6e7819ULL, 0x020fe40000011630ULL, 0x000000ff306f7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff307819ULL, 0x000fe40000011631ULL, 0x0000ffff31787812ULL, 0x000fe400078ec0ffULL,
0x000054105a5a7816ULL, 0x000fe40000000058ULL, 0x00000018ff317819ULL, 0x000fc40000011632ULL,
0x00000030ff58723eULL, 0x000fe400020006ffULL, 0x000000ff6d6d7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff307819ULL, 0x000fe40000011674ULL, 0x00000031ff74723eULL, 0x000fe400020006ffULL,
0x0000006eff6e723eULL, 0x000fe400020006ffULL, 0x0000006fff6f723eULL, 0x000fc400020006ffULL,
0x0000006dff31723eULL, 0x000fe400020006ffULL, 0x00000030ff30723eULL, 0x000fe400020006ffULL,
0x00000059ff59723eULL, 0x000fe400020006ffULL, 0x0000005bff5b723eULL, 0x000fe400020006ffULL,
0x0000ffff32797812ULL, 0x000fe400078ec0ffULL, 0x000000ff70707812ULL, 0x000fc400078ec0ffULL,
0x0000541031317816ULL, 0x000fe4000000006eULL, 0x000054106f307816ULL, 0x000fe40000000030ULL,
0x00000010ff757819ULL, 0x100fe40000011633ULL, 0x00000018ff767819ULL, 0x000fe40000011633ULL,
0x000000ff33777812ULL, 0x040fe200078ec0ffULL, 0x000000305440723cULL, 0x000f620000001840ULL,
0x0000ffff337a7812ULL, 0x000fc400078ec0ffULL, 0x000054105b5b7816ULL, 0x000fe40000000059ULL,
0x000000ff32737812ULL, 0x000fe400078ec0ffULL, 0x00000070ff33723eULL, 0x000fe200020006ffULL,
0x000000305018723cULL, 0x000b620000001818ULL, 0x00000008ff597819ULL, 0x000fe40000011679ULL,
0x00000010ff727819ULL, 0x000fe40000011632ULL, 0x00000073ff73723eULL, 0x000fc400020006ffULL,
0x0000541033337816ULL, 0x000fe20000000058ULL, 0x0000005a5438723cULL, 0x080f620000001838ULL,
0x00000059ff59723eULL, 0x000fe400020006ffULL, 0x000000046b307810ULL, 0x020fe40007ffe0ffULL,
0x00000008ff327819ULL, 0x000fe40000011678ULL, 0x000000ff72727812ULL, 0x000fe200078ec0ffULL,
0x0000005a503c723cULL, 0x000b62000000183cULL, 0x000000ff75757812ULL, 0x000fc400078ec0ffULL,
0x00000008ff587819ULL, 0x000fe4000001167aULL, 0x000000183000780cULL, 0x000fe40003f25270ULL,
0x00005410735a7816ULL, 0x020fe40000000059ULL, 0x00000071ff71723eULL, 0x000fe400020006ffULL,
0x00000032ff32723eULL, 0x000fe400020006ffULL, 0x00000076ff76723eULL, 0x000fc400020006ffULL,
0x00000072ff5b723eULL, 0x000fe400020006ffULL, 0x00000077ff77723eULL, 0x000fe400020006ffULL,
0x00000075ff59723eULL, 0x000fe400020006ffULL, 0x00000058ff58723eULL, 0x000fe400020006ffULL,
0x0000541071327816ULL, 0x000fe40000000032ULL, 0x000054105b5b7816ULL, 0x000fc40000000074ULL,
0x0000541059597816ULL, 0x000fe40000000076ULL, 0x0000541077587816ULL, 0x000fe20000000058ULL,
0x000000325444723cULL, 0x000b620000001844ULL, 0xfffffff46b717810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff6b7224ULL, 0x000fcc00078e0030ULL, 0x0000005a540c723cULL, 0x040b70000000180cULL,
0x000000585448723cULL, 0x000b700000001848ULL, 0x000000325024723cULL, 0x040b700000001824ULL,
0x0000005a5028723cULL, 0x040b700000001828ULL, 0x00000058502c723cULL, 0x000b62000000182cULL,
0x0000001000009944ULL, 0x000fe20003c00000ULL, 0xffffede000007947ULL, 0x000fcc000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff677224ULL, 0x000fe200078e0061ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffe04000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x0000006448487220ULL, 0x0a0fe20000410000ULL,
0x0000006449497220ULL, 0x080fe20000410000ULL, 0x0000006436367220ULL, 0x080fe20000410000ULL,
0x0000006437377220ULL, 0x080fe20000410000ULL, 0x0000006404557220ULL, 0x080fe20000410000ULL,
0x0000006405547220ULL, 0x080fe20000410000ULL, 0x000000643a3a7220ULL, 0x080fe20000410000ULL,
0x000000643b3b7220ULL, 0x080fe20000410000ULL, 0x0000006408517220ULL, 0x080fe20000410000ULL,
0x0000006409587220ULL, 0x080fe20000410000ULL, 0x000000640b307220ULL, 0x080fe20000410000ULL,
0x0000006442427220ULL, 0x080fe20000410000ULL, 0x0000006444447220ULL, 0x080fe20000410000ULL,
0x0000006445457220ULL, 0x080fe20000410000ULL, 0x0000006434577220ULL, 0x080fe20000410000ULL,
0x0000006406067220ULL, 0x080fe20000410000ULL, 0x0000006407077220ULL, 0x080fe20000410000ULL,
0x000000640a0a7220ULL, 0x080fe20000410000ULL, 0x0000006443437220ULL, 0x080fe20000410000ULL,
0x000000640c0c7220ULL, 0x080fe20000410000ULL, 0x000000640d0d7220ULL, 0x080fe20000410000ULL,
0x000000644a047220ULL, 0x080fe20000410000ULL, 0x000000644b057220ULL, 0x080fe20000410000ULL,
0x0000006414147220ULL, 0x080fe20000410000ULL, 0x0000006415157220ULL, 0x080fe20000410000ULL,
0x000000644c087220ULL, 0x080fe20000410000ULL, 0x000000644d097220ULL, 0x080fe20000410000ULL,
0x000000642c0b7220ULL, 0x080fe20000410000ULL, 0x0000006435567220ULL, 0x080fe20000410000ULL,
0x0000006438537220ULL, 0x080fe20000410000ULL, 0x0000006439527220ULL, 0x080fe20000410000ULL,
0x0000006411347220ULL, 0x080fe20000410000ULL, 0x0000006440597220ULL, 0x080fe20000410000ULL,
0x000000640e327220ULL, 0x080fe20000410000ULL, 0x000000640f337220ULL, 0x080fe20000410000ULL,
0x0000006410357220ULL, 0x080fe20000410000ULL, 0x000000643c387220ULL, 0x080fe20000410000ULL,
0x000000643d397220ULL, 0x080fe20000410000ULL, 0x000000644e117220ULL, 0x080fe20000410000ULL,
0x000000644f5a7220ULL, 0x080fe20000410000ULL, 0x000000642a677220ULL, 0x080fe20000410000ULL,
0x000000642f6a7220ULL, 0x080fe20000410000ULL, 0x000000ffff4b7224ULL, 0x000fe200078e0048ULL,
0x0000006441507220ULL, 0x080fe20000410000ULL, 0x000000ffff4a7224ULL, 0x000fe200078e0049ULL,
0x0000006446317220ULL, 0x080fe20000410000ULL, 0x0000006447407220ULL, 0x080fe20000410000ULL,
0x000000643e0f7220ULL, 0x080fe20000410000ULL, 0x000000643f107220ULL, 0x080fe20000410000ULL,
0x00000064183c7220ULL, 0x080fe20000410000ULL, 0x00000064193d7220ULL, 0x080fe20000410000ULL,
0x000000642b687220ULL, 0x080fe20000410000ULL, 0x000000642d0e7220ULL, 0x080fe20000410000ULL,
0x000000642e697220ULL, 0x080fe20000410000ULL, 0x000000ffff4f7224ULL, 0x000fe200078e0044ULL,
0x0000006412127220ULL, 0x080fe20000410000ULL, 0x000000ffff4e7224ULL, 0x000fe200078e0045ULL,
0x0000006413137220ULL, 0x080fe20000410000ULL, 0x000000ffff2a7224ULL, 0x000fe200078e0036ULL,
0x0000006416167220ULL, 0x080fe20000410000ULL, 0x000000ffff497224ULL, 0x000fe200078e0037ULL,
0x0000006417177220ULL, 0x080fe20000410000ULL, 0x000000ffff2c7224ULL, 0x000fe200078e003aULL,
0x000000641a197220ULL, 0x080fe20000410000ULL, 0x000000ffff487224ULL, 0x000fe200078e003bULL,
0x000000641b187220ULL, 0x080fe20000410000ULL, 0x000000ffff2f7224ULL, 0x000fe200078e0042ULL,
0x00000064243e7220ULL, 0x080fe20000410000ULL, 0x00000064253f7220ULL, 0x080fe20000410000ULL,
0x00000064265b7220ULL, 0x080fe20000410000ULL, 0x0000006427667220ULL, 0x080fe20000410000ULL,
0x0000006428467220ULL, 0x080fe20000410000ULL, 0x0000006429417220ULL, 0x000fe20000410000ULL,
0x000000ffff4d7224ULL, 0x000fc400078e000cULL, 0x000000ffff4c7224ULL, 0x000fe400078e000dULL,
0x000000ffff2b7224ULL, 0x000fe400078e0006ULL, 0x000000ffff2d7224ULL, 0x000fe400078e0007ULL,
0x000000ffff2e7224ULL, 0x000fe400078e000aULL, 0x000000ffff477224ULL, 0x000fe400078e0043ULL,
0x000000ffff457224ULL, 0x000fc400078e0004ULL, 0x000000ffff447224ULL, 0x000fe400078e0005ULL,
0x000000ffff367224ULL, 0x000fe400078e0014ULL, 0x000000ffff377224ULL, 0x000fe400078e0015ULL,
0x000000ffff3a7224ULL, 0x000fe400078e0008ULL, 0x000000ffff3b7224ULL, 0x000fe400078e0009ULL,
0x000000ffff427224ULL, 0x000fe200078e000bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000063087f8cULL, 0x0002a2000c80043fULL, 0x000000ffff267224ULL, 0x000fc400078e0012ULL,
0x000000ffff277224ULL, 0x000fe400078e0013ULL, 0x000000ffff1b7224ULL, 0x000fe400078e0016ULL,
0x000000ffff247224ULL, 0x000fe400078e0017ULL, 0x000000ffff437224ULL, 0x000fe400078e000eULL,
0x000000ffff297224ULL, 0x000fe400078e000fULL, 0x000000ffff287224ULL, 0x000fc400078e0010ULL,
0x000000ffff257224ULL, 0x000fe400078e0011ULL, 0x000000ffff1a7224ULL, 0x000fe400078e005aULL,
0x000000ffff127224ULL, 0x000fe400078e005bULL, 0x000000ffff137224ULL, 0x000fe400078e0066ULL,
0x000000ffff147224ULL, 0x000fe400078e0067ULL, 0x000000ffff157224ULL, 0x000fc400078e0068ULL,
0x000000ffff167224ULL, 0x000fe400078e0069ULL, 0x000000ffff177224ULL, 0x000fc400078e006aULL,
0x0000000000047805ULL, 0x006fca0000015200ULL, 0x0000040063077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x00000006040b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09000b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011407ULL, 0x0000000b06067211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000206067819ULL, 0x000fc80000001207ULL,
0x000000060000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040063077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000041f117824ULL, 0x000fe200078e00ffULL,
0x0000005d6000720cULL, 0x000fc80003f06070ULL, 0xfffffff011057812ULL, 0x000fca00078ec0ffULL,
0x0000008020107824ULL, 0x000fca00078e0205ULL, 0x0124000010047984ULL, 0x0002a20000000c00ULL,
0x00001f6000008947ULL, 0x000fea0003800000ULL, 0x0000010060097824ULL, 0x000fe200078e0203ULL,
0x000000001f087211ULL, 0x040fe200078ff0ffULL, 0x000000021f5b7824ULL, 0x000fe400078e00ffULL,
0x00000002ff7c7424ULL, 0x000fe200078e00ffULL, 0x000000091e5a7217ULL, 0x000fe40007800000ULL,
0x000000065b5b7812ULL, 0x000fe400078ec0ffULL, 0x00000008080b7810ULL, 0x000fe20007ffe0ffULL,
0x000000015a5a7824ULL, 0x000fe200078e0a09ULL, 0x000058005b677a10ULL, 0x000fe20007ffe0ffULL,
0x000000015e097824ULL, 0x000fe200078e025bULL, 0x00005a00ff0a7a19ULL, 0x000fc40000011608ULL,
0x00000010080d7810ULL, 0x040fe20007ffe0ffULL, 0x00000001090c7824ULL, 0x100fe200078e0a5aULL,
0x00000018080f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000167087824ULL, 0x000fe200078e0a5aULL,
0x00005a00ff0e7a19ULL, 0x000fe4000001160bULL, 0x0000000c5f0c7217ULL, 0x040fe40003800000ULL,
0x0000000a5f0a7217ULL, 0x040fe40003800000ULL, 0x0000000e5f0e7217ULL, 0x000fc40003800000ULL,
0x0000005a0900720cULL, 0x000fe20003f26070ULL, 0x0000000a238b7224ULL, 0x000fe200078e02ffULL,
0x0000005a6700720cULL, 0x000fe20003f06070ULL, 0x0000000e238d7224ULL, 0x000fe200078e02ffULL,
0x000000085f087217ULL, 0x000fe40003800000ULL, 0x00000004ff0c7819ULL, 0x000fe4000001160cULL,
0x000000ff087a7207ULL, 0x000fe40000000000ULL, 0x000000ff0c0e7207ULL, 0x000fc40000800000ULL,
0x00005a00ff087a19ULL, 0x000fe4000001160dULL, 0x00005a00ff0a7a19ULL, 0x000fe2000001160fULL,
0x000000018b0b7824ULL, 0x000fe200078e020eULL, 0x0000008b7a097211ULL, 0x000fe400078fe0ffULL,
0x000000085f667217ULL, 0x040fe40003800000ULL, 0x0000000a5f687217ULL, 0x000fe20003800000ULL,
0x0000600009087625ULL, 0x000fe200078e007cULL, 0x000000105b777812ULL, 0x000fc400078efcffULL,
0x0000008d7a0d7211ULL, 0x000fe200078fe0ffULL, 0x000060000b0a7625ULL, 0x000fc800078e007cULL,
0x00000066238f7224ULL, 0x040fe200078e02ffULL, 0x000000080a697981ULL, 0x0046a2000c1e9500ULL,
0x0000006823917224ULL, 0x000fe400078e02ffULL, 0x000000010e0f7824ULL, 0x000fe200078e028dULL,
0x0000000808667981ULL, 0x0002a2000c1e9500ULL, 0x0000008f7a6b7211ULL, 0x000fe200078fe0ffULL,
0x000000010e6f7824ULL, 0x000fe400078e028fULL, 0x000060000d0c7625ULL, 0x000fc800078e007cULL,
0x000000015e0b7824ULL, 0x008fe200078e0277ULL, 0x0000580077757a10ULL, 0x000fe20007ffe0ffULL,
0x000000010e717824ULL, 0x000fe200078e0291ULL, 0x000000080c687981ULL, 0x0006a2000c1e9500ULL,
0x000000010b727824ULL, 0x000fe400078e0a5aULL, 0x000060006b6a7625ULL, 0x000fc800078e007cULL,
0x000060000f0e7625ULL, 0x000fe200078e007cULL, 0x000000725f727217ULL, 0x000fe20003800000ULL,
0x000000086a6e7981ULL, 0x0006a4000c1e9500ULL, 0x000060006f087625ULL, 0x002fe200078e007cULL,
0x0000005a0b00720cULL, 0x000fc60003f26070ULL, 0x00006000710c7625ULL, 0x008fe200078e007cULL,
0x0000000808737981ULL, 0x0002e2000c1e9500ULL, 0x00000004ff727819ULL, 0x000fe40000011672ULL,
0x00000001750a7824ULL, 0x040fe200078e0a5aULL, 0x000000080e717981ULL, 0x0002e2000c1e9500ULL,
0x000000917a6d7211ULL, 0x000fe400078fe0ffULL, 0x0000005a7500720cULL, 0x000fe20003f06070ULL,
0x000000080c707981ULL, 0x0002e2000c1e9500ULL, 0x0000000a5f0a7217ULL, 0x000fe20003800000ULL,
0x000060006d6c7625ULL, 0x000fe200078e007cULL, 0x000000ff720e7207ULL, 0x002fc80000800000ULL,
0x000000086c6f7981ULL, 0x0002e2000c1e9500ULL, 0x000000ff0a827207ULL, 0x000fe20000000000ULL,
0x000000018b0b7824ULL, 0x000fc600078e020eULL, 0x0000008b82097211ULL, 0x000fe200078fe0ffULL,
0x000000010e0f7824ULL, 0x000fe200078e028dULL, 0x0000008d820d7211ULL, 0x000fe200078fe0ffULL,
0x000060000b0a7625ULL, 0x000fe200078e007cULL, 0x000000205b7f7812ULL, 0x000fc600078efcffULL,
0x0000600009087625ULL, 0x080fe200078e007cULL, 0x000000080a797981ULL, 0x0002e6000c1e9500ULL,
0x000000010e7b7824ULL, 0x040fe200078e028fULL, 0x0000000808727981ULL, 0x0002e2000c1e9500ULL,
0x000000010e7d7824ULL, 0x000fe400078e0291ULL, 0x000060000d0c7625ULL, 0x000fe200078e007cULL,
0x000058007f817a10ULL, 0x000fc60007ffe0ffULL, 0x000060000f0e7625ULL, 0x080fe200078e007cULL,
0x000000080c747981ULL, 0x0002e6000c1e9500ULL, 0x000000015e0b7824ULL, 0x002fe400078e027fULL,
0x000060007b087625ULL, 0x000fe400078e007cULL, 0x000000080e7b7981ULL, 0x0002e4000c1e9500ULL,
0x000000010b7e7824ULL, 0x100fe200078e0a5aULL, 0x0000008f826b7211ULL, 0x040fe200078fe0ffULL,
0x00000001810a7824ULL, 0x000fe200078e0a5aULL, 0x00000091826d7211ULL, 0x000fc400078fe0ffULL,
0x0000007e5f7e7217ULL, 0x000fe20003800000ULL, 0x000060006b6a7625ULL, 0x000fe200078e007cULL,
0x0000005a8100720cULL, 0x000fe40003f06070ULL, 0x0000000a5f0a7217ULL, 0x000fe20003800000ULL,
0x000060006d6c7625ULL, 0x000fe200078e007cULL, 0x0000005a0b00720cULL, 0x000fe20003f26070ULL,
0x000000086a767981ULL, 0x0002e2000c1e9500ULL, 0x00000004ff7e7819ULL, 0x000fe2000001167eULL,
0x000060007d0c7625ULL, 0x000fe200078e007cULL, 0x000000ff0a887207ULL, 0x000fe20000000000ULL,
0x00000008087d7981ULL, 0x0002e8000c1e9500ULL, 0x000000086c787981ULL, 0x0002e8000c1e9500ULL,
0x000000080c837981ULL, 0x0002e4000c1e9500ULL, 0x000000ff7e087207ULL, 0x002fc40000800000ULL,
0x0000008b880b7211ULL, 0x000fc600078fe0ffULL, 0x0000000108097824ULL, 0x000fe200078e028dULL,
0x0000008d880d7211ULL, 0x000fe200078fe0ffULL, 0x000000018b6d7824ULL, 0x000fe400078e0208ULL,
0x0000000108877824ULL, 0x040fe400078e028fULL, 0x0000000108897824ULL, 0x000fe400078e0291ULL,
0x000060000d0c7625ULL, 0x000fc800078e007cULL, 0x0000600009087625ULL, 0x080fe200078e007cULL,
0x000000080c807981ULL, 0x0002e6000c1e9500ULL, 0x000060000b0a7625ULL, 0x080fe200078e007cULL,
0x0000000808d17981ULL, 0x0002e2000c1e9500ULL, 0x0000008f886b7211ULL, 0x040fe400078fe0ffULL,
0x000060006d6c7625ULL, 0x000fe200078e007cULL, 0x000000080a7e7981ULL, 0x0002e2000c1e9500ULL,
0x00000091880f7211ULL, 0x000fc400078fe0ffULL, 0x000060006b6a7625ULL, 0x080fe200078e007cULL,
0x000000086c857981ULL, 0x0002e6000c1e9500ULL, 0x00006000870a7625ULL, 0x082fe200078e007cULL,
0x000000305b877812ULL, 0x000fe200078efcffULL, 0x000000086a847981ULL, 0x0002e4000c1e9500ULL,
0x000060000f0e7625ULL, 0x080fe400078e007cULL, 0x000000080ad57981ULL, 0x0002e4000c1e9500ULL,
0x00006000890c7625ULL, 0x000fe200078e007cULL, 0x0000580087897a10ULL, 0x000fe20007ffe0ffULL,
0x000000080e867981ULL, 0x0002e4000c1e9500ULL, 0x000000015e6d7824ULL, 0x000fc400078e0287ULL,
0x000000080cd97981ULL, 0x0002e4000c1e9500ULL, 0x000000016d8a7824ULL, 0x100fe400078e0a5aULL,
0x00000001896c7824ULL, 0x000fc600078e0a5aULL, 0x0000008a5f8a7217ULL, 0x000fe40003800000ULL,
0x0000005a6d00720cULL, 0x080fe40003f26070ULL, 0x0000005a8900720cULL, 0x000fe40003f06070ULL,
0x0000006c5f6c7217ULL, 0x000fe40003800000ULL, 0x00000004ff087819ULL, 0x000fe4000001168aULL,
0x000000ff6c8a7207ULL, 0x000fc40000000000ULL, 0x000000ff088c7207ULL, 0x000fe40000800000ULL,
0x0000008b8a6b7211ULL, 0x042fe400078fe0ffULL, 0x0000008f8a0b7211ULL, 0x000fe200078fe0ffULL,
0x000000018b6d7824ULL, 0x000fe400078e028cULL, 0x000000018c0f7824ULL, 0x000fe400078e028fULL,
0x000060006b6a7625ULL, 0x000fc800078e007cULL, 0x000060006d6c7625ULL, 0x080fe200078e007cULL,
0x000000086abb7981ULL, 0x0002e6000c1e9500ULL, 0x000060000b0a7625ULL, 0x080fe200078e007cULL,
0x000000086c8e7981ULL, 0x0002e6000c1e9500ULL, 0x000060000f0e7625ULL, 0x000fe200078e007cULL,
0x000000080ad77981ULL, 0x0002e2000c1e9500ULL, 0x0000008d8a097211ULL, 0x000fc600078fe0ffULL,
0x000000080e927981ULL, 0x0002e2000c1e9500ULL, 0x000000018c0d7824ULL, 0x000fe400078e028dULL,
0x0000600009087625ULL, 0x000fc800078e007cULL, 0x000060000d0c7625ULL, 0x080fe200078e007cULL,
0x0000000808d37981ULL, 0x0002e4000c1e9500ULL, 0x000000918a6b7211ULL, 0x002fe400078fe0ffULL,
0x000000080c907981ULL, 0x0002e2000c1e9500ULL, 0x000000018c6d7824ULL, 0x000fe400078e0291ULL,
0x000060006b6a7625ULL, 0x000fc800078e007cULL, 0x000060006d6c7625ULL, 0x000fe200078e007cULL,
0x000000086adb7981ULL, 0x0002e8000c1e9500ULL, 0x000000086c947981ULL, 0x0002e2000c1e9500ULL,
0xfffffff07a097812ULL, 0x000fe200078ec0ffULL, 0x00000001ffcf7424ULL, 0x000fc800078e00ffULL,
0x000000015a087824ULL, 0x000fc800078e0209ULL, 0x0000000167097824ULL, 0x000fe200078e0a08ULL,
0x000000015b8b7812ULL, 0x000fc800078efcffULL, 0x00000009cf097219ULL, 0x000fe400000006ffULL,
0x000058008b0b7a10ULL, 0x000fe40007ffe0ffULL, 0xfffffff0820d7812ULL, 0x002fc600078ec0ffULL,
0x000000010b0a7824ULL, 0x100fe200078e0a08ULL, 0x000000085b8d7812ULL, 0x040fe200078efcffULL,
0x000000015a0e7824ULL, 0x000fe200078e020dULL, 0x000000095b8f7812ULL, 0x000fe400078efcffULL,
0x0000000acf0d7219ULL, 0x000fe400000006ffULL, 0x000058008d0f7a10ULL, 0x000fe40007ffe0ffULL,
0x000058008f6d7a10ULL, 0x000fe40007ffe0ffULL, 0xfffffff0886b7812ULL, 0x000fe200078ec0ffULL,
0x000000010f0c7824ULL, 0x100fe200078e0a08ULL, 0xfffffff08a917812ULL, 0x000fe200078ec0ffULL,
0x000000016d087824ULL, 0x000fe200078e0a08ULL, 0x000000115b957812ULL, 0x000fe200078efcffULL,
0x000000015a6a7824ULL, 0x040fe200078e026bULL, 0x0000000ccf6b7219ULL, 0x040fe200000006ffULL,
0x000000015a827824ULL, 0x000fe200078e0291ULL, 0x00000008cf917219ULL, 0x000fc400000006ffULL,
0x0000580095977a10ULL, 0x000fe40007ffe0ffULL, 0x0000541066667816ULL, 0x004fc80000000069ULL,
0x0000006609ff7212ULL, 0x000fc800078ac0ffULL, 0x0000005a6700720cULL, 0x000fc80002fa1470ULL,
0x0000005a5b00720cULL, 0x000fe40002fa1070ULL, 0x000000660dff7212ULL, 0x000fe4000782c0ffULL,
0xff80000057577808ULL, 0x000fe40002800000ULL, 0x0000005a0b00720cULL, 0x000fe40000f21470ULL,
0x000054106e6e7816ULL, 0x008fe40000000073ULL, 0x0000541068687816ULL, 0x000fc40000000071ULL,
0x0000006e09ff7212ULL, 0x040fe4000788c0ffULL, 0x0000006809ff7212ULL, 0x080fe4000784c0ffULL,
0x000000680dff7212ULL, 0x000fe400078ac0ffULL, 0x0000005a6700720cULL, 0x0c0fe40001741470ULL,
0x0000005a6700720cULL, 0x080fe40002781470ULL, 0x0000005a0b00720cULL, 0x000fc40002fa1470ULL,
0x0000005a5b00720cULL, 0x0c0fe40001741070ULL, 0x0000005a5b00720cULL, 0x080fe40002781070ULL,
0x0000005a8b00720cULL, 0x0c0fe40000f21070ULL, 0x0000005a8b00720cULL, 0x000fe40002fa1070ULL,
0x000054106f707816ULL, 0x000fe40000000070ULL, 0xff8000002a2a7808ULL, 0x000fc40001000000ULL,
0xff80000035357808ULL, 0x000fe40002000000ULL, 0xff80000056567808ULL, 0x000fe40000800000ULL,
0xff80000049497808ULL, 0x000fe40002800000ULL, 0x000000666bff7212ULL, 0x000fe4000786c0ffULL,
0x0000007009ff7212ULL, 0x000fe4000780c0ffULL, 0x0000006e0dff7212ULL, 0x000fc4000784c0ffULL,
0x000000700dff7212ULL, 0x000fe4000788c0ffULL, 0x0000006891ff7212ULL, 0x000fe4000782c0ffULL,
0x0000006e6bff7212ULL, 0x000fe200078ac0ffULL, 0x0000000175087824ULL, 0x100fe200078e0a0eULL,
0x0000005a6700720cULL, 0x080fe20000701470ULL, 0x00000001970a7824ULL, 0x000fe200078e0a0eULL,
0x0000005a0b00720cULL, 0x0c0fe40001741470ULL, 0x0000005a0b00720cULL, 0x000fc40002781470ULL,
0x0000005a0f00720cULL, 0x0c0fe40001f61470ULL, 0x0000005a0f00720cULL, 0x080fe40002fa1470ULL,
0x0000005a6d00720cULL, 0x080fe40000f21470ULL, 0x000000185b9b7812ULL, 0x040fe400078efcffULL,
0x000000195ba17812ULL, 0x040fe400078efcffULL, 0x0000005a5b00720cULL, 0x000fc40000701070ULL,
0x0000005a8b00720cULL, 0x0c0fe40001741070ULL, 0x0000005a8b00720cULL, 0x080fe40002781070ULL,
0x0000005a8d00720cULL, 0x0c0fe40001f61070ULL, 0x0000005a8d00720cULL, 0x080fe40002fa1070ULL,
0x0000005a8f00720cULL, 0x000fe40000f21070ULL, 0x00000008cf937219ULL, 0x000fc400000006ffULL,
0x0000000acf997219ULL, 0x000fe400000006ffULL, 0x0000541072727816ULL, 0x000fe40000000079ULL,
0x0000541074747816ULL, 0x000fe4000000007bULL, 0x000058009b9d7a10ULL, 0x000fe40007ffe0ffULL,
0x00005800a1a37a10ULL, 0x000fe40007ffe0ffULL, 0xff80000026267808ULL, 0x000fc40000000000ULL,
0xff80000034347808ULL, 0x000fe40001000000ULL, 0xff80000027277808ULL, 0x000fe40002000000ULL,
0xff80000055557808ULL, 0x000fe40001800000ULL, 0xff80000036367808ULL, 0x000fe40002800000ULL,
0xff8000002d2d7808ULL, 0x000fe40000800000ULL, 0x000000686bff7212ULL, 0x000fc4000780c0ffULL,
0x0000006e91ff7212ULL, 0x000fe4000784c0ffULL, 0x000000706bff7212ULL, 0x080fe4000788c0ffULL,
0x0000007091ff7212ULL, 0x000fe4000786c0ffULL, 0x0000007299ff7212ULL, 0x000fe400078ac0ffULL,
0x0000007493ff7212ULL, 0x000fe2000782c0ffULL, 0x000000019d0c7824ULL, 0x100fe200078e0a0eULL,
0x0000005a0f00720cULL, 0x080fe20000701470ULL, 0x00000001a30e7824ULL, 0x000fe200078e0a0eULL,
0x0000005a0f00720cULL, 0x000fc40002781470ULL, 0x0000005a6d00720cULL, 0x0c0fe40001741470ULL,
0x0000005a6d00720cULL, 0x080fe40001f61470ULL, 0x0000005a7500720cULL, 0x080fe40000f21470ULL,
0x0000005a9700720cULL, 0x080fe40002fa1470ULL, 0x0000005a8d00720cULL, 0x0c0fe40000701070ULL,
0x0000005a8d00720cULL, 0x000fc40002781070ULL, 0x0000005a8f00720cULL, 0x0c0fe40001741070ULL,
0x0000005a8f00720cULL, 0x080fe40001f61070ULL, 0x0000005a7700720cULL, 0x080fe40000f21070ULL,
0x0000005a9500720cULL, 0x000fe40002fa1070ULL, 0x0000000ccf9f7219ULL, 0x040fe400000006ffULL,
0x0000000ecfa57219ULL, 0x000fc400000006ffULL, 0x0000541076767816ULL, 0x000fe4000000007dULL,
0x0000541078787816ULL, 0x000fe40000000083ULL, 0xff8000002b2b7808ULL, 0x000fe40000000000ULL,
0xff8000001b1b7808ULL, 0x000fe40002000000ULL, 0xff80000037377808ULL, 0x000fe40001000000ULL,
0xff80000024247808ULL, 0x000fc40001800000ULL, 0xff8000002c2c7808ULL, 0x000fe40000800000ULL,
0xff80000052527808ULL, 0x000fe40002800000ULL, 0x0000007293ff7212ULL, 0x080fe4000780c0ffULL,
0x000000729fff7212ULL, 0x000fe4000788c0ffULL, 0x0000007693ff7212ULL, 0x040fe4000784c0ffULL,
0x0000007893ff7212ULL, 0x000fc4000786c0ffULL, 0x0000007699ff7212ULL, 0x000fe4000782c0ffULL,
0x00000074a5ff7212ULL, 0x000fe200078ac0ffULL, 0x00000001816c7824ULL, 0x000fe200078e0a6aULL,
0x0000005a7500720cULL, 0x0c0fe40000701470ULL, 0x0000005a7500720cULL, 0x0c0fe40001741470ULL,
0x0000005a7500720cULL, 0x080fe40001f61470ULL, 0x0000005a9700720cULL, 0x000fc40000f21470ULL,
0x0000005a9d00720cULL, 0x080fe40002781470ULL, 0x0000005aa300720cULL, 0x080fe40002fa1470ULL,
0x000000215ba97812ULL, 0x000fe400078efcffULL, 0x0000005a7700720cULL, 0x0c0fe40000701070ULL,
0x0000005a7700720cULL, 0x0c0fe40001741070ULL, 0x0000005a7700720cULL, 0x000fc40001f61070ULL,
0x0000005a9500720cULL, 0x080fe40000f21070ULL, 0x0000005a9b00720cULL, 0x080fe40002781070ULL,
0x0000005aa100720cULL, 0x000fe40002fa1070ULL, 0x0000006ccfa77219ULL, 0x000fe400000006ffULL,
0x0000541080807816ULL, 0x000fe400000000d1ULL, 0x00005800a9ab7a10ULL, 0x000fc40007ffe0ffULL,
0xff80000053537808ULL, 0x000fe40000000000ULL, 0xff80000038387808ULL, 0x000fe40001000000ULL,
0xff80000029297808ULL, 0x000fe40001800000ULL, 0xff80000039397808ULL, 0x000fe40000800000ULL,
0xff80000051517808ULL, 0x000fe40002000000ULL, 0xff80000030307808ULL, 0x000fc40002800000ULL,
0x0000007499ff7212ULL, 0x040fe4000780c0ffULL, 0x0000007899ff7212ULL, 0x000fe4000784c0ffULL,
0x000000749fff7212ULL, 0x000fe4000786c0ffULL, 0x00000076a5ff7212ULL, 0x040fe4000782c0ffULL,
0x00000078a5ff7212ULL, 0x000fe4000788c0ffULL, 0x00000080a7ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001ab7a7824ULL, 0x000fe200078e0a6aULL, 0x0000005a9700720cULL, 0x000fc40000701470ULL,
0x0000005a9700720cULL, 0x080fe40001741470ULL, 0x0000005a9d00720cULL, 0x080fe40001f61470ULL,
0x0000005aa300720cULL, 0x0c0fe40000f21470ULL, 0x0000005aa300720cULL, 0x080fe40002781470ULL,
0x0000005a8100720cULL, 0x000fe40002fa1470ULL, 0x000000285baf7812ULL, 0x000fc400078efcffULL,
0x000000295bb57812ULL, 0x000fe400078efcffULL, 0x0000005a9500720cULL, 0x0c0fe40000701070ULL,
0x0000005a9500720cULL, 0x080fe40001741070ULL, 0x0000005a9b00720cULL, 0x080fe40001f61070ULL,
0x0000005aa100720cULL, 0x0c0fe40000f21070ULL, 0x0000005aa100720cULL, 0x000fc40002781070ULL,
0x0000005a7f00720cULL, 0x000fe40002fa1070ULL, 0x0000007acfad7219ULL, 0x000fe400000006ffULL,
0x000054107e7e7816ULL, 0x000fe40000000085ULL, 0x0000541084847816ULL, 0x000fe400000000d5ULL,
0x0000541086867816ULL, 0x000fe400000000d9ULL, 0x00005800afb17a10ULL, 0x000fc40007ffe0ffULL,
0x00005800b5b77a10ULL, 0x000fe40007ffe0ffULL, 0xff80000048487808ULL, 0x000fe40000000000ULL,
0xff80000028287808ULL, 0x000fe40001000000ULL, 0xff8000002e2e7808ULL, 0x000fe40001800000ULL,
0xff8000003b3b7808ULL, 0x000fe40000800000ULL, 0xff8000001a1a7808ULL, 0x000fc40002000000ULL,
0xff8000002f2f7808ULL, 0x000fe40002800000ULL, 0x0000006691ff7212ULL, 0x000fe400078cc0ffULL,
0x000000769fff7212ULL, 0x040fe4000780c0ffULL, 0x000000789fff7212ULL, 0x000fe4000784c0ffULL,
0x0000007ea7ff7212ULL, 0x040fe4000786c0ffULL, 0x00000084a7ff7212ULL, 0x000fc4000782c0ffULL,
0x00000086a7ff7212ULL, 0x000fe4000788c0ffULL, 0x00000084adff7212ULL, 0x000fe200078ac0ffULL,
0x00000001b17c7824ULL, 0x100fe200078e0a6aULL, 0x0000005a6d00720cULL, 0x080fe200037c1470ULL,
0x00000001b76a7824ULL, 0x000fe200078e0a6aULL, 0x0000005a9d00720cULL, 0x0c0fe40000701470ULL,
0x0000005a9d00720cULL, 0x080fe40001741470ULL, 0x0000005a8100720cULL, 0x000fc40001f61470ULL,
0x0000005a8100720cULL, 0x0c0fe40000f21470ULL, 0x0000005a8100720cULL, 0x080fe40002781470ULL,
0x0000005aab00720cULL, 0x080fe40002fa1470ULL, 0x0000005a8f00720cULL, 0x080fe400037c1070ULL,
0x0000005a9b00720cULL, 0x0c0fe40000701070ULL, 0x0000005a9b00720cULL, 0x000fc40001741070ULL,
0x0000005a7f00720cULL, 0x0c0fe40001f61070ULL, 0x0000005a7f00720cULL, 0x0c0fe40000f21070ULL,
0x0000005a7f00720cULL, 0x080fe40002781070ULL, 0x0000005aa900720cULL, 0x000fe40002fa1070ULL,
0x0000007ccfb37219ULL, 0x040fe400000006ffULL, 0x0000006acfb97219ULL, 0x000fc400000006ffULL,
0xff80000054547808ULL, 0x000fe40003000000ULL, 0xff8000003a3a7808ULL, 0x000fe40000000000ULL,
0xff80000025257808ULL, 0x000fe40001000000ULL, 0xff80000059597808ULL, 0x000fe40001800000ULL,
0xff8000003c3c7808ULL, 0x000fe40000800000ULL, 0xff80000019197808ULL, 0x000fc40002000000ULL,
0xff8000003d3d7808ULL, 0x000fe40002800000ULL, 0x00000072a5ff7212ULL, 0x000fe400078cc0ffULL,
0x0000007eadff7212ULL, 0x080fe4000780c0ffULL, 0x0000007eb3ff7212ULL, 0x000fe4000784c0ffULL,
0x00000080adff7212ULL, 0x040fe4000786c0ffULL, 0x00000086adff7212ULL, 0x000fc4000782c0ffULL,
0x00000080b3ff7212ULL, 0x000fe4000788c0ffULL, 0x00000084b9ff7212ULL, 0x000fe200078ac0ffULL,
0x0000000189887824ULL, 0x000fe200078e0a82ULL, 0x0000005aa300720cULL, 0x080fe400037c1470ULL,
0x0000005aab00720cULL, 0x0c0fe40000701470ULL, 0x0000005aab00720cULL, 0x0c0fe40001f61470ULL,
0x0000005aab00720cULL, 0x000fc40000f21470ULL, 0x0000005ab100720cULL, 0x0c0fe40001741470ULL,
0x0000005ab100720cULL, 0x080fe40002781470ULL, 0x0000005ab700720cULL, 0x000fe40002fa1470ULL,
0x000000315bbf7812ULL, 0x040fe400078efcffULL, 0x000000385bc57812ULL, 0x040fe400078efcffULL,
0x000000395bcb7812ULL, 0x000fc400078efcffULL, 0x0000005aa100720cULL, 0x080fe400037c1070ULL,
0x0000005aa900720cULL, 0x0c0fe40000701070ULL, 0x0000005aa900720cULL, 0x0c0fe40001f61070ULL,
0x0000005aa900720cULL, 0x080fe40000f21070ULL, 0x0000005aaf00720cULL, 0x0c0fe40001741070ULL,
0x0000005aaf00720cULL, 0x000fc40002781070ULL, 0x0000005ab500720cULL, 0x000fe40002fa1070ULL,
0x00000088cfbd7219ULL, 0x000fe400000006ffULL, 0x00005410bb8e7816ULL, 0x000fe4000000008eULL,
0x00005410d7927816ULL, 0x000fe40000000092ULL, 0x00005800bfc17a10ULL, 0x000fe40007ffe0ffULL,
0x00005800c5c77a10ULL, 0x000fc40007ffe0ffULL, 0x00005800cbcd7a10ULL, 0x000fe40007ffe0ffULL,
0xff80000058587808ULL, 0x000fe40003000000ULL, 0xff80000050507808ULL, 0x000fe40000000000ULL,
0xff80000047477808ULL, 0x000fe40001800000ULL, 0xff80000018187808ULL, 0x000fe40000800000ULL,
0xff8000004f4f7808ULL, 0x000fc40001000000ULL, 0xff80000031317808ULL, 0x000fe40002000000ULL,
0xff8000003f3f7808ULL, 0x000fe40002800000ULL, 0x0000007eb9ff7212ULL, 0x040fe400078cc0ffULL,
0x00000080b9ff7212ULL, 0x000fe4000780c0ffULL, 0x00000084b3ff7212ULL, 0x040fe4000786c0ffULL,
0x00000086b3ff7212ULL, 0x000fc4000782c0ffULL, 0x00000086b9ff7212ULL, 0x000fe4000784c0ffULL,
0x0000008ebdff7212ULL, 0x040fe4000788c0ffULL, 0x00000092bdff7212ULL, 0x000fe200078ac0ffULL,
0x00000001c18a7824ULL, 0x100fe200078e0a82ULL, 0x0000005ab100720cULL, 0x080fe20001f61470ULL,
0x00000001c78c7824ULL, 0x100fe200078e0a82ULL, 0x0000005ab100720cULL, 0x080fe20000f21470ULL,
0x00000001cd827824ULL, 0x000fe200078e0a82ULL, 0x0000005ab700720cULL, 0x000fc400037c1470ULL,
0x0000005ab700720cULL, 0x0c0fe40000701470ULL, 0x0000005ab700720cULL, 0x080fe40001741470ULL,
0x0000005a8900720cULL, 0x0c0fe40002781470ULL, 0x0000005a8900720cULL, 0x000fe40002fa1470ULL,
0x0000008acfc37219ULL, 0x040fe400000006ffULL, 0x0000008ccfc97219ULL, 0x000fc400000006ffULL,
0x0000005aaf00720cULL, 0x0c0fe40001f61070ULL, 0x0000005aaf00720cULL, 0x080fe40000f21070ULL,
0x0000005ab500720cULL, 0x0c0fe400037c1070ULL, 0x0000005ab500720cULL, 0x0c0fe40000701070ULL,
0x0000005ab500720cULL, 0x080fe40001741070ULL, 0x0000005a8700720cULL, 0x000fc40002781070ULL,
0x0000005a8700720cULL, 0x000fe40002fa1070ULL, 0x00000082cfcf7219ULL, 0x000fe400000006ffULL,
0x00005410d3907816ULL, 0x000fe40000000090ULL, 0xff8000003e3e7808ULL, 0x000fe40001800000ULL,
0xff80000012127808ULL, 0x000fe40000800000ULL, 0xff8000004e4e7808ULL, 0x000fc40003000000ULL,
0xff80000040407808ULL, 0x000fe40000000000ULL, 0xff80000013137808ULL, 0x000fe40001000000ULL,
0xff8000004d4d7808ULL, 0x000fe40002000000ULL, 0xff80000046467808ULL, 0x000fe40002800000ULL,
0x0000008ec3ff7212ULL, 0x080fe4000786c0ffULL, 0x0000008ec9ff7212ULL, 0x000fc4000782c0ffULL,
0x0000008ecfff7212ULL, 0x000fe400078cc0ffULL, 0x00000090bdff7212ULL, 0x080fe4000780c0ffULL,
0x00000090c3ff7212ULL, 0x080fe4000784c0ffULL, 0x00000090c9ff7212ULL, 0x000fe4000788c0ffULL,
0x00000092c3ff7212ULL, 0x000fe400078ac0ffULL, 0x0000005a8900720cULL, 0x000fc40000701470ULL,
0x0000005ac100720cULL, 0x0c0fe40001f61470ULL, 0x0000005ac100720cULL, 0x0c0fe40001741470ULL,
0x0000005ac100720cULL, 0x080fe40002fa1470ULL, 0x0000005ac700720cULL, 0x080fe40000f21470ULL,
0x0000005acd00720cULL, 0x080fe400037c1470ULL, 0x0000005ac700720cULL, 0x000fc40002781470ULL,
0x0000005a8700720cULL, 0x080fe40000701070ULL, 0x0000005abf00720cULL, 0x0c0fe40001f61070ULL,
0x0000005abf00720cULL, 0x0c0fe40001741070ULL, 0x0000005abf00720cULL, 0x080fe40002fa1070ULL,
0x0000005ac500720cULL, 0x080fe40000f21070ULL, 0x0000005acb00720cULL, 0x000fc400037c1070ULL,
0x0000005ac500720cULL, 0x000fe40002781070ULL, 0x00005410db947816ULL, 0x000fe40000000094ULL,
0xff80000032327808ULL, 0x000fe40000000000ULL, 0xff8000004c4c7808ULL, 0x000fe40001800000ULL,
0xff80000033337808ULL, 0x000fe40001000000ULL, 0xff80000041417808ULL, 0x000fc40002800000ULL,
0xff8000004b4b7808ULL, 0x000fe40000800000ULL, 0xff8000004a4a7808ULL, 0x000fe40003000000ULL,
0xff80000045457808ULL, 0x000fe40002000000ULL, 0x00000090cfff7212ULL, 0x000fe4000780c0ffULL,
0x00000092c9ff7212ULL, 0x080fe4000786c0ffULL, 0x00000092cfff7212ULL, 0x000fc4000784c0ffULL,
0x00000094bdff7212ULL, 0x080fe400078ac0ffULL, 0x00000094c3ff7212ULL, 0x080fe4000782c0ffULL,
0x00000094c9ff7212ULL, 0x080fe400078cc0ffULL, 0x00000094cfff7212ULL, 0x000fe4000788c0ffULL,
0x0000005a8900720cULL, 0x080fe40002fa1470ULL, 0x0000005ac100720cULL, 0x000fc40000f21470ULL,
0x0000005ac700720cULL, 0x0c0fe40001f61470ULL, 0x0000005ac700720cULL, 0x080fe400037c1470ULL,
0x0000005acd00720cULL, 0x0c0fe40000701470ULL, 0x0000005acd00720cULL, 0x0c0fe40001741470ULL,
0x0000005acd00720cULL, 0x080fe40002781470ULL, 0x0000005a8700720cULL, 0x000fc40002fa1070ULL,
0x0000005abf00720cULL, 0x080fe40000f21070ULL, 0x0000005acb00720cULL, 0x080fe40000701070ULL,
0x0000005ac500720cULL, 0x0c0fe40001f61070ULL, 0x0000005ac500720cULL, 0x080fe400037c1070ULL,
0x0000005acb00720cULL, 0x0c0fe40001741070ULL, 0x0000005acb00720cULL, 0x000fc40002781070ULL,
0xff80000044447808ULL, 0x000fe40000000000ULL, 0xff80000042427808ULL, 0x000fe40001800000ULL,
0xff80000043437808ULL, 0x000fe40001000000ULL, 0xff80000014147808ULL, 0x000fe40002800000ULL,
0xff80000015157808ULL, 0x000fe40000800000ULL, 0xff80000016167808ULL, 0x000fc40003000000ULL,
0xff80000017177808ULL, 0x000fc40002000000ULL, 0x000000570400720bULL, 0x004fe20003f1e000ULL,
0x0000001fff5a7424ULL, 0x000fe200078e00ffULL, 0x0000002a0500720bULL, 0x000fe20003f3e000ULL,
0xffffffffff5b7424ULL, 0x000fe200078e00ffULL, 0x000000350600720bULL, 0x000fe40003f5e000ULL,
0x000000260700720bULL, 0x000fe40003f7e000ULL, 0x0000000457097208ULL, 0x000fe40004000000ULL,
0x000000052a047208ULL, 0x000fc40004800000ULL, 0x0000000635057208ULL, 0x000fe40005000000ULL,
0x0000000726067208ULL, 0x000fe40005800000ULL, 0x000000560900720bULL, 0x000fe40003f1e000ULL,
0x000000490400720bULL, 0x000fe40003f3e000ULL, 0x000000340500720bULL, 0x000fe40003f5e000ULL,
0x000000270600720bULL, 0x000fc40003f7e000ULL, 0x0000000956087208ULL, 0x000fe40004000000ULL,
0x0000000449047208ULL, 0x000fe40004800000ULL, 0x0000000534057208ULL, 0x000fe40005000000ULL,
0x0000000627067208ULL, 0x000fe40005800000ULL, 0x000000550800720bULL, 0x000fe40003f1e000ULL,
0x0000002b0400720bULL, 0x000fc40003f3e000ULL, 0x000000360500720bULL, 0x000fe40003f5e000ULL,
0x0000001b0600720bULL, 0x000fe40003f7e000ULL, 0x0000000855077208ULL, 0x000fe40004000000ULL,
0x000000042b047208ULL, 0x000fe40004800000ULL, 0x0000000536087208ULL, 0x000fe40005000000ULL,
0x000000061b057208ULL, 0x000fc40005800000ULL, 0x000000540700720bULL, 0x000fe40003f1e000ULL,
0x0000002d0400720bULL, 0x000fe40003f3e000ULL, 0x000000370800720bULL, 0x000fe40003f5e000ULL,
0x000000240500720bULL, 0x000fe40003f7e000ULL, 0x0000000754067208ULL, 0x000fe40004000000ULL,
0x000000042d077208ULL, 0x000fc40004800000ULL, 0x0000000837097208ULL, 0x000fe40005000000ULL,
0x0000000524047208ULL, 0x000fe40005800000ULL, 0x000000530600720bULL, 0x000fe40003f1e000ULL,
0x0000002c0700720bULL, 0x000fe40003f3e000ULL, 0x000000380900720bULL, 0x000fe40003f5e000ULL,
0x000000290400720bULL, 0x000fc40003f7e000ULL, 0x0000000653057208ULL, 0x000fe40004000000ULL,
0x000000072c077208ULL, 0x000fe40004800000ULL, 0x0000000938067208ULL, 0x000fe40005000000ULL,
0x0000000429097208ULL, 0x000fe40005800000ULL, 0x000000520500720bULL, 0x000fe40003f1e000ULL,
0x000000480700720bULL, 0x000fc40003f3e000ULL, 0x000000390600720bULL, 0x000fe40003f5e000ULL,
0x000000280900720bULL, 0x000fe40003f7e000ULL, 0x0000000552047208ULL, 0x000fe40004000000ULL,
0x0000000748077208ULL, 0x000fe40004800000ULL, 0x0000000639057208ULL, 0x000fe40005000000ULL,
0x0000000928067208ULL, 0x000fc40005800000ULL, 0x000000510400720bULL, 0x000fe40003f1e000ULL,
0x0000002e0700720bULL, 0x000fe40003f3e000ULL, 0x0000003a0500720bULL, 0x000fe40003f5e000ULL,
0x000000250600720bULL, 0x000fe40003f7e000ULL, 0x0000000451097208ULL, 0x000fe40004000000ULL,
0x000000072e077208ULL, 0x000fc40004800000ULL, 0x000000053a047208ULL, 0x000fe40005000000ULL,
0x0000000625057208ULL, 0x000fe40005800000ULL, 0x000000580900720bULL, 0x000fe40003f1e000ULL,
0x000000300700720bULL, 0x000fe40003f3e000ULL, 0x0000003b0400720bULL, 0x000fe40003f5e000ULL,
0x0000001a0500720bULL, 0x000fc40003f7e000ULL, 0x0000000958067208ULL, 0x000fe40004000000ULL,
0x0000000730087208ULL, 0x000fe40004800000ULL, 0x000000043b077208ULL, 0x000fe40005000000ULL,
0x000000051a047208ULL, 0x000fe40005800000ULL, 0x000000590600720bULL, 0x000fe40003f1e000ULL,
0x0000002f0800720bULL, 0x000fc40003f3e000ULL, 0x0000003c0700720bULL, 0x000fe40003f5e000ULL,
0x000000190400720bULL, 0x000fe40003f7e000ULL, 0x0000000659057208ULL, 0x000fe40004000000ULL,
0x000000082f087208ULL, 0x000fe40004800000ULL, 0x000000073c067208ULL, 0x000fe40005000000ULL,
0x0000000419077208ULL, 0x000fc40005800000ULL, 0x000000500500720bULL, 0x000fe40003f1e000ULL,
0x000000470800720bULL, 0x000fe40003f3e000ULL, 0x0000003d0600720bULL, 0x000fe40003f5e000ULL,
0x000000180700720bULL, 0x000fe40003f7e000ULL, 0x0000000550047208ULL, 0x000fe40004000000ULL,
0x0000000847087208ULL, 0x000fc40004800000ULL, 0x000000063d057208ULL, 0x000fe40005000000ULL,
0x0000000718077208ULL, 0x000fe40005800000ULL, 0x0000004f0400720bULL, 0x000fe40003f1e000ULL,
0x000000310800720bULL, 0x000fe40003f3e000ULL, 0x0000003e0500720bULL, 0x000fe40003f5e000ULL,
0x000000120700720bULL, 0x000fc40003f7e000ULL, 0x000000044f097208ULL, 0x000fe40004000000ULL,
0x00000008310b7208ULL, 0x000fe40004800000ULL, 0x000000053e047208ULL, 0x000fe40005000000ULL,
0x0000000712067208ULL, 0x000fe40005800000ULL, 0x0000004e0900720bULL, 0x000fe40003f1e000ULL,
0x000000400b00720bULL, 0x000fc40003f3e000ULL, 0x0000003f0400720bULL, 0x000fe40003f5e000ULL,
0x000000130600720bULL, 0x000fe40003f7e000ULL, 0x000000094e087208ULL, 0x000fe40004000000ULL,
0x0000000b400b7208ULL, 0x000fe40004800000ULL, 0x000000043f057208ULL, 0x000fe40005000000ULL,
0x0000000613077208ULL, 0x000fc40005800000ULL, 0x0000004d0800720bULL, 0x000fe40003f1e000ULL,
0x000000320b00720bULL, 0x000fe40003f3e000ULL, 0x000000460500720bULL, 0x000fe40003f5e000ULL,
0x000000140700720bULL, 0x000fe40003f7e000ULL, 0x000000084d097208ULL, 0x000fe40004000000ULL,
0x0000000b32047208ULL, 0x000fc40004800000ULL, 0x0000000546067208ULL, 0x000fe40005000000ULL,
0x0000000714087208ULL, 0x000fe40005800000ULL, 0x000000330400720bULL, 0x000fe40003f3e000ULL,
0x0000004c0900720bULL, 0x000fe40003f1e000ULL, 0x000000410600720bULL, 0x000fe40003f5e000ULL,
0x000000150800720bULL, 0x000fc40003f7e000ULL, 0x0000000433047208ULL, 0x000fe40004800000ULL,
0x000000094c0a7208ULL, 0x000fe40004000000ULL, 0x0000000641057208ULL, 0x000fe40005000000ULL,
0x0000000815077208ULL, 0x000fe40005800000ULL, 0x000000450400720bULL, 0x000fe40003f3e000ULL,
0x0000004b0a00720bULL, 0x000fc40003f1e000ULL, 0x000000420500720bULL, 0x000fe40003f5e000ULL,
0x000000160700720bULL, 0x000fe40003f7e000ULL, 0x00000004450b7208ULL, 0x000fe40004800000ULL,
0x0000000a4b097208ULL, 0x000fe40004000000ULL, 0x0000000542047208ULL, 0x000fe40005000000ULL,
0x0000000716067208ULL, 0x000fc40005800000ULL, 0x0000004a0900720bULL, 0x000fe40003f1e000ULL,
0x000000440b00720bULL, 0x000fe40003f3e000ULL, 0x000000430400720bULL, 0x000fe40003f5e000ULL,
0x000000170600720bULL, 0x000fe40003f7e000ULL, 0x000000094a077208ULL, 0x000fe40004000000ULL,
0x0000000b440a7208ULL, 0x000fc40004800000ULL, 0x00000004430e7208ULL, 0x000fe40005000000ULL,
0x00000006170d7208ULL, 0x000fe20005800000ULL, 0x000020027f007947ULL, 0x000fea000b800000ULL,
0x0c401f0007047f89ULL, 0x0004e400000e0000ULL, 0x000000040700720bULL, 0x008fc80003f1e000ULL,
0x00000007040f7208ULL, 0x000fe20004000000ULL, 0x000020127f007947ULL, 0x000fea000b800000ULL,
0x0c401f000a047f89ULL, 0x000ee800000e0000ULL, 0x0c401f000e057f89ULL, 0x000e6800000e0000ULL,
0x0c401f000d067f89ULL, 0x000ea200000e0000ULL, 0x000000040a00720bULL, 0x008fc40003f1e000ULL,
0x000000050e00720bULL, 0x002fe40003f3e000ULL, 0x0000000a04077208ULL, 0x004fe40004000000ULL,
0x0000000e05087208ULL, 0x000fe20004800000ULL, 0x0c201f000f047f89ULL, 0x000e6200000e0000ULL,
0x000000060d00720bULL, 0x000fc60003f1e000ULL, 0x0c201f00070c7f89ULL, 0x000ea200000e0000ULL,
0x0000000d060a7208ULL, 0x000fc60004000000ULL, 0x0c201f0008097f89ULL, 0x000ee800000e0000ULL,
0x0c201f000a0b7f89ULL, 0x0002e400000e0000ULL, 0x000000040f00720bULL, 0x002fe40003f1e000ULL,
0x0000000c0700720bULL, 0x004fe40003f3e000ULL, 0x0000000f04047208ULL, 0x000fc40004000000ULL,
0x000000090800720bULL, 0x008fe40003f5e000ULL, 0x000000070c057208ULL, 0x000fe40004800000ULL,
0x0000000809067208ULL, 0x000fc60005000000ULL, 0x3fb8aa3b04077820ULL, 0x002fe20000410000ULL,
0x0000000b0a00720bULL, 0x004fe20003f1e000ULL, 0x3fb8aa3b060d7820ULL, 0x000fe20000410000ULL,
0x00000002ff697819ULL, 0x000fe2000001161fULL, 0x3fb8aa3b510c7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b57577823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b56567823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b55557823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b54547823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b53537823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b52527823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b58587823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b59517823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b50507823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b4f4f7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b4e4e7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b4d4d7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b4c4c7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b4b4b7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b4a4a7823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b05077820ULL, 0x000fe20000410000ULL,
0x0000005700087308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b35357823ULL, 0x100fe2000001080dULL,
0x3fb8aa3b34347823ULL, 0x000fe2000001080dULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b49497823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b48487823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b30307823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b47477823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b31317823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b40407823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b32327823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b33337823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b45457823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b44077823ULL, 0x000fe20000010807ULL, 0x0000000c00577308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b36367823ULL, 0x100fe2000001080dULL, 0x3fb8aa3b37377823ULL, 0x100fe2000001080dULL,
0x3fb8aa3b38387823ULL, 0x100fe2000001080dULL, 0x3fb8aa3b39397823ULL, 0x100fe2000001080dULL,
0x3fb8aa3b3a3a7823ULL, 0x100fe2000001080dULL, 0x3fb8aa3b3b3b7823ULL, 0x100fe2000001080dULL,
0x3fb8aa3b3c3c7823ULL, 0x100fe2000001080dULL, 0x0000000700447308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b3d3d7823ULL, 0x100fe2000001080dULL, 0x3fb8aa3b3e3e7823ULL, 0x100fe2000001080dULL,
0x3fb8aa3b3f3f7823ULL, 0x100fe2000001080dULL, 0x3fb8aa3b46467823ULL, 0x100fe2000001080dULL,
0x3fb8aa3b41417823ULL, 0x100fe2000001080dULL, 0x3fb8aa3b42427823ULL, 0x100fe2000001080dULL,
0x3fb8aa3b430d7823ULL, 0x000fe2000001080dULL, 0x0000002d000c7308ULL, 0x0005e20000000800ULL,
0x0000000a0b077208ULL, 0x002fe20004000000ULL, 0x00000008696a7824ULL, 0x040fe200078e00ffULL,
0x00000002690b7810ULL, 0x040fe20007ffe0ffULL, 0x00000008696c7824ULL, 0x040fe200078e00ffULL,
0x00000001690a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000869707824ULL, 0x000fe200078e00ffULL,
0xfffffff86a6a7812ULL, 0x000fe200078ee20bULL, 0x0000002b002b7308ULL, 0x000e620000000800ULL,
0x3fb8aa3b072d7820ULL, 0x004fe20000410000ULL, 0x0000000869727824ULL, 0x040fe200078e00ffULL,
0x00000005690b7810ULL, 0x000fe20007ffe0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe2000001082dULL, 0x3fb8aa3b26267823ULL, 0x100fe2000001082dULL,
0x3fb8aa3b27277823ULL, 0x100fe2000001082dULL, 0x3fb8aa3b24247823ULL, 0x000fe2000001082dULL,
0x0000005600097308ULL, 0x000ea20000000800ULL, 0xfffffff870707812ULL, 0x000fe200078ee20bULL,
0x3fb8aa3b25257823ULL, 0x100fe2000001082dULL, 0x3fb8aa3b29297823ULL, 0x100fe2000001082dULL,
0x3fb8aa3b28287823ULL, 0x100fe2000001082dULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe2000001082dULL,
0x3fb8aa3b19197823ULL, 0x100fe2000001082dULL, 0x0000002b0c0b723eULL, 0x002fe200000000ffULL,
0x0000004800597308ULL, 0x000fe20000000800ULL, 0xffffffff690c7810ULL, 0x000fe20007ffe0ffULL,
0x3fb8aa3b12127823ULL, 0x000fe2000001082dULL, 0x0000000c11117812ULL, 0x000fc400078ec0ffULL,
0x000000031fff7812ULL, 0x000fc6000780c0ffULL, 0x0000000d00437308ULL, 0x0003e20000000800ULL,
0x000000080908723eULL, 0x004fce00000000ffULL, 0x0000005500557308ULL, 0x000fe20000000800ULL,
0x00000003690d7810ULL, 0x002fc80007ffe0ffULL, 0xfffffff86c6c7812ULL, 0x000fe400078ee20dULL,
0x00000006690d7810ULL, 0x040fe20007ffe0ffULL, 0x0000005400547308ULL, 0x000fe60000000800ULL,
0xfffffff872727812ULL, 0x000fe200078ee20dULL, 0x00000008690d7824ULL, 0x000fc800078e00ffULL,
0x0000002a002a7308ULL, 0x000fe20000000800ULL, 0xfffffff80d747812ULL, 0x000fce00078ee20cULL,
0x0000004900497308ULL, 0x000e700000000800ULL, 0x00000030005b7308ULL, 0x000ff00000000800ULL,
0x0000004700567308ULL, 0x000fe20000000800ULL, 0x0000002a4909723eULL, 0x002fce00000000ffULL,
0x0000003200487308ULL, 0x000ff00000000800ULL, 0x00000035000e7308ULL, 0x0003f00000000800ULL,
0x00000034000f7308ULL, 0x0004e20000000800ULL, 0x0000000869357824ULL, 0x002fca00078e00ffULL,
0xfffffff835687812ULL, 0x000fe200078ee20aULL, 0x3c003c00ff357424ULL, 0x000fe200078e00ffULL,
0x0000003600367308ULL, 0x000fe20000000800ULL, 0x00000004690a7810ULL, 0x000fe20007ffe0ffULL,
0x3c003c00ff347424ULL, 0x004fcc00078e00ffULL, 0x0000003700377308ULL, 0x000e620000000800ULL,
0x0000000e0f0c723eULL, 0x008fce00000000ffULL, 0x0000002600307308ULL, 0x000ff00000000800ULL,
0x0000002700477308ULL, 0x0004e20000000800ULL, 0x00000036370e723eULL, 0x002fce00000000ffULL,
0x0000001b001b7308ULL, 0x000fe20000000800ULL, 0x0000000869277824ULL, 0x004fca00078e00ffULL,
0xfffffff8276e7812ULL, 0x000fe400078ee20aULL, 0x0000002400327308ULL, 0x000e620000000800ULL,
0x00000055540a723eULL, 0x000fe200000000ffULL, 0x3fb8aa3b16547823ULL, 0x100fe2000001082dULL,
0x00000030470d723eULL, 0x008fe200000000ffULL, 0x3fb8aa3b13307823ULL, 0x100fe2000001082dULL,
0x3fb8aa3b15477823ULL, 0x100fe2000001082dULL, 0x3fb8aa3b17557823ULL, 0x000fe4000001082dULL,
0x0000002500667308ULL, 0x0005e20000000800ULL, 0x0000001b320f723eULL, 0x002fce00000000ffULL,
0x00000029005a7308ULL, 0x000fe20000000800ULL, 0x000000340824723cULL, 0x004f6200000018ffULL,
0x3fb8aa3b14327823ULL, 0x000fcc000001082dULL, 0x0000002800677308ULL, 0x0003f00000000800ULL,
0x0000005300537308ULL, 0x000fe20000000800ULL, 0x000000340c28723cULL, 0x002f6e00000018ffULL,
0x0000005200527308ULL, 0x000e700000000800ULL, 0x0000005800587308ULL, 0x000eb00000000800ULL,
0x0000002c002c7308ULL, 0x000ee20000000800ULL, 0x000000535214723eULL, 0x002fe200000000ffULL,
0x0000000869527824ULL, 0x000fca00078e00ffULL, 0xfffffff852527812ULL, 0x000fe200078ee269ULL,
0x0000002e002e7308ULL, 0x000e620000000800ULL, 0x000000575816723eULL, 0x004fe400000000ffULL,
0x0000000869587810ULL, 0x000fca0007ffe0ffULL, 0x0000003800387308ULL, 0x000fe20000000800ULL,
0x0000002c5915723eULL, 0x008fce00000000ffULL, 0x0000003900397308ULL, 0x000ea20000000800ULL,
0x0000002e5b17723eULL, 0x002fce00000000ffULL, 0x0000003a003a7308ULL, 0x000fe20000000800ULL,
0x000000341424723cULL, 0x020f6e0000001824ULL, 0x0000003b003b7308ULL, 0x000ff00000000800ULL,
0x0000001a00497308ULL, 0x0002f00000000800ULL, 0x0000001900367308ULL, 0x0007e20000000800ULL,
0x3fb8aa3b181a7823ULL, 0x002fe2000001082dULL, 0x000000383918723eULL, 0x004fe200000000ffULL,
0x00000008582d7824ULL, 0x000fca00078e00ffULL, 0x0000001a00137308ULL, 0x0002a20000000800ULL,
0x0000005a6719723eULL, 0x008fe400000000ffULL, 0x00000066491b723eULL, 0x000fe400000000ffULL,
0x00000010695a7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff82d587812ULL, 0x000fe200078ee258ULL,
0x0000002f002f7308ULL, 0x000ee20000000800ULL, 0x0000003a3b1a723eULL, 0x002fe200000000ffULL,
0x000000085a397824ULL, 0x000fe200078e00ffULL, 0x0000001869697810ULL, 0x000fc80007ffe0ffULL,
0xfffffff8395a7812ULL, 0x000fe200078ee25aULL, 0x0000005100517308ULL, 0x000fe20000000800ULL,
0x000000341828723cULL, 0x000f620000001828ULL, 0x000000361339723eULL, 0x004fe200000000ffULL,
0x0000000869667824ULL, 0x000fca00078e00ffULL, 0x0000005000507308ULL, 0x000e620000000800ULL,
0x0000002f562d723eULL, 0x008fe400000000ffULL, 0xfffffff866667812ULL, 0x000fca00078ee269ULL,
0x0000004f004f7308ULL, 0x000ff00000000800ULL, 0x0000004e004e7308ULL, 0x000ea20000000800ULL,
0x00000051502c723eULL, 0x002fce00000000ffULL, 0x0000003100317308ULL, 0x000ff00000000800ULL,
0x0000004000407308ULL, 0x000e620000000800ULL, 0x0000004f4e2e723eULL, 0x004fce00000000ffULL,
0x0000003c003c7308ULL, 0x000ff00000000800ULL, 0x0000003d003d7308ULL, 0x000ea20000000800ULL,
0x00000031402f723eULL, 0x002fce00000000ffULL, 0x0000003e003e7308ULL, 0x000fe20000000800ULL,
0x000000342c24723cULL, 0x020f6e0000001824ULL, 0x0000003f003f7308ULL, 0x000e620000000800ULL,
0x0000003c3d38723eULL, 0x004fe400000000ffULL, 0x0000a000203d7811ULL, 0x000fca00078e60ffULL,
0x0000001200127308ULL, 0x000fe20000000800ULL, 0x0000001052527824ULL, 0x100fe400078e023dULL,
0x0000001068687824ULL, 0x100fe400078e023dULL, 0x000000106a6a7824ULL, 0x100fe400078e023dULL,
0x000000106c6c7824ULL, 0x100fe200078e023dULL, 0x00000030003b7308ULL, 0x000ea20000000800ULL,
0x0000003e3f3a723eULL, 0x002fe200000000ffULL, 0x000000106e6e7824ULL, 0x000fc400078e023dULL,
0x0000001070707824ULL, 0x100fe400078e023dULL, 0x0000001072727824ULL, 0x000fe400078e023dULL,
0x0000004d004d7308ULL, 0x000fe20000000800ULL, 0x0000000152137824ULL, 0x000fe400078e0211ULL,
0x0000001074747824ULL, 0x100fe400078e023dULL, 0x0000001058587824ULL, 0x100fe200078e023dULL,
0x0000000813007388ULL, 0x0003e20000000800ULL, 0x000000105a5a7824ULL, 0x100fe200078e023dULL,
0x0000004c004c7308ULL, 0x000ee20000000800ULL, 0x000000123b3b723eULL, 0x004fe200000000ffULL,
0x0000001066667824ULL, 0x000fc400078e023dULL, 0x0000000111687824ULL, 0x040fe400078e0268ULL,
0x00000001116a7824ULL, 0x040fe400078e026aULL, 0x0000003300337308ULL, 0x000ea20000000800ULL,
0x000000343828723cULL, 0x000fe20000001828ULL, 0x00000001116c7824ULL, 0x040fe200078e026cULL,
0x0000000a68007388ULL, 0x0003e20000000800ULL, 0x00000001116e7824ULL, 0x040fe400078e026eULL,
0x0000000111707824ULL, 0x040fe200078e0270ULL, 0x000000146a007388ULL, 0x0003e20000000800ULL,
0x0000004b004b7308ULL, 0x000fe20000000800ULL, 0x0000004d4c30723eULL, 0x008fe200000000ffULL,
0x0000000111727824ULL, 0x040fe200078e0272ULL, 0x000000166c007388ULL, 0x0007e20000000800ULL,
0x0000000111747824ULL, 0x000fc400078e0274ULL, 0x0000000111587824ULL, 0x000fe200078e0258ULL,
0x0000002c6e007388ULL, 0x0007e20000000800ULL, 0x0000004a004a7308ULL, 0x000fe20000000800ULL,
0x000000483331723eULL, 0x004fe200000000ffULL, 0x0000000111137824ULL, 0x042fe200078e025aULL,
0x0000002e70007388ULL, 0x0007e20000000800ULL, 0x0000000111667824ULL, 0x000fc600078e0266ULL,
0x0000003072007388ULL, 0x0007e20000000800ULL, 0x0000004500457308ULL, 0x000e700000000800ULL,
0x0000004600467308ULL, 0x000ff00000000800ULL, 0x0000004100417308ULL, 0x000ea20000000800ULL,
0x000000454433723eULL, 0x002fce00000000ffULL, 0x0000004200427308ULL, 0x000e700000000800ULL,
0x0000003200377308ULL, 0x0003e20000000800ULL, 0x00000046413c723eULL, 0x004fce00000000ffULL,
0x00000047004c7308ULL, 0x000ea20000000800ULL, 0x0000004b4a32723eULL, 0x002fe400000000ffULL,
0x00000042433e723eULL, 0x000fc600000000ffULL, 0x0000003274007388ULL, 0x0007e40000000800ULL,
0x00000054003f7308ULL, 0x000fe20000000800ULL, 0x000000343024723cULL, 0x020f620000001824ULL,
0x0000000958007388ULL, 0x0007e80000000800ULL, 0x0004000b68007388ULL, 0x0007e40000000800ULL,
0x0000005500127308ULL, 0x000e620000000800ULL, 0x000000374c3d723eULL, 0x004fe200000000ffULL,
0x000400156a007388ULL, 0x0007e80000000800ULL, 0x000400176c007388ULL, 0x0007e80000000800ULL,
0x0004002d6e007388ULL, 0x0007e80000000800ULL, 0x0004002f70007388ULL, 0x0007e20000000800ULL,
0x0000003f123f723eULL, 0x002fc400000000ffULL, 0x000000ffff257224ULL, 0x020fe200078e0026ULL,
0x0004003172007388ULL, 0x0007e80000000800ULL, 0x0004003374007388ULL, 0x0007e20000000800ULL,
0x000000343c28723cULL, 0x000f660000001828ULL, 0x0000000c13007388ULL, 0x0007e80000000800ULL,
0x0008000e68007388ULL, 0x0007e80000000800ULL, 0x000800186a007388ULL, 0x0007e80000000800ULL,
0x0008001a6c007388ULL, 0x0007e80000000800ULL, 0x000800386e007388ULL, 0x0007e80000000800ULL,
0x0008003a70007388ULL, 0x0007e20000000800ULL, 0x000000ffff267224ULL, 0x020fc400078e0028ULL,
0x000000ffff277224ULL, 0x000fe200078e002aULL, 0x0008003c72007388ULL, 0x0007e80000000800ULL,
0x0008003e74007388ULL, 0x0007e80000000800ULL, 0x0000000d66007388ULL, 0x0007e80000000800ULL,
0x000c000f68007388ULL, 0x0007e80000000800ULL, 0x000c00196a007388ULL, 0x0007e80000000800ULL,
0x000c001b6c007388ULL, 0x0007e80000000800ULL, 0x000c00396e007388ULL, 0x0007e80000000800ULL,
0x000c003b70007388ULL, 0x0007e80000000800ULL, 0x000c003d72007388ULL, 0x0007e80000000800ULL,
0x000c003f74007388ULL, 0x0007e80000000800ULL, 0x0120000410008388ULL, 0x0007e80000000c00ULL,
0x0122002410008388ULL, 0x0007e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000062ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000080062ff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000100062ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000160607810ULL, 0x000fe20007ffe0ffULL, 0x0000180062ff7f8cULL, 0x0003e6000c80043fULL,
0x0000001c6000720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffff990000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff287807ULL, 0x008fe40004000000ULL, 0x0001613000297802ULL, 0x000fc40000000f00ULL,
0x0000108000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff037224ULL, 0x000fe200078e0028ULL,
0xfffec76000007947ULL, 0x000fea000383ffffULL, 0x00000001ff287807ULL, 0x000fe40005800000ULL,
0x0001618000297802ULL, 0x000fc40000000f00ULL, 0x0000103000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff087224ULL, 0x000fe200078e0028ULL, 0xfffec7c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0002ULL, 0x000161d000287802ULL, 0x000fc40000000f00ULL,
0x00000f9000007944ULL, 0x014fea0003c00000ULL, 0xfffec89000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0002ULL, 0x0001621000287802ULL, 0x000fc40000000f00ULL,
0x00000f5000007944ULL, 0x016fea0003c00000ULL, 0xfffec9c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0002ULL, 0x0001625000287802ULL, 0x000fc40000000f00ULL,
0x00000f1000007944ULL, 0x01efea0003c00000ULL, 0xfffecaf000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0002ULL, 0x0001629000287802ULL, 0x000fc40000000f00ULL,
0x00000ed000007944ULL, 0x01efea0003c00000ULL, 0xfffecc1000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0000ULL, 0x000162e000287802ULL, 0x000fe20000000f00ULL,
0x000000ffff297224ULL, 0x000fc400078e0003ULL, 0x00000e8000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e0029ULL, 0xfffed03000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0000ULL, 0x0001633000287802ULL, 0x000fc40000000f00ULL,
0x00000e3000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e0029ULL,
0x0000001003297810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0000ULL,
0x0001638000287802ULL, 0x000fc40000000f00ULL, 0x00000de000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0d7224ULL, 0x004fe200078e0029ULL, 0xfffecfe000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0000ULL, 0x000163d000287802ULL, 0x000fc40000000f00ULL,
0x00000d9000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e0029ULL,
0xfffecfc000007947ULL, 0x000fea000383ffffULL, 0x00000001ff287807ULL, 0x008fe40004000000ULL,
0x0001642000297802ULL, 0x000fc40000000f00ULL, 0x00000d9000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff257224ULL, 0x000fe200078e0028ULL, 0xfffef14000007947ULL, 0x000fea000383ffffULL,
0x00000001ff287807ULL, 0x000fe40005800000ULL, 0x0001647000297802ULL, 0x000fc40000000f00ULL,
0x00000d4000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff727224ULL, 0x000fe200078e0028ULL,
0xfffef18000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0078ULL,
0x000164c000287802ULL, 0x000fc40000000f00ULL, 0x00000ca000007944ULL, 0x004fea0003c00000ULL,
0xfffef26000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0078ULL,
0x0001650000287802ULL, 0x000fc40000000f00ULL, 0x00000c6000007944ULL, 0x006fea0003c00000ULL,
0xfffef39000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0078ULL,
0x0001654000287802ULL, 0x000fc40000000f00ULL, 0x00000c2000007944ULL, 0x00efea0003c00000ULL,
0xfffef4c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0078ULL,
0x0001658000287802ULL, 0x000fc40000000f00ULL, 0x00000be000007944ULL, 0x00efea0003c00000ULL,
0xfffef5e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000cULL,
0x000165d000287802ULL, 0x000fe20000000f00ULL, 0x000000ffff297224ULL, 0x000fc400078e0025ULL,
0x00000b9000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e0029ULL,
0xfffefa0000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000cULL,
0x0001662000287802ULL, 0x000fc40000000f00ULL, 0x00000b4000007944ULL, 0x00efea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e0029ULL, 0x0000001025297810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000cULL, 0x0001667000287802ULL, 0x000fc40000000f00ULL,
0x00000af000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0d7224ULL, 0x004fe200078e0029ULL,
0xfffef9b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000cULL,
0x000166c000287802ULL, 0x000fc40000000f00ULL, 0x00000aa000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e0029ULL, 0xfffef99000007947ULL, 0x000fea000383ffffULL,
0x00000001ff287807ULL, 0x004fe40004000000ULL, 0x0001671000297802ULL, 0x000fc40000000f00ULL,
0x00000aa000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff717224ULL, 0x000fe200078e0028ULL,
0xffff18e000007947ULL, 0x000fea000383ffffULL, 0x00000001ff287807ULL, 0x000fe40005800000ULL,
0x0001676000297802ULL, 0x000fc40000000f00ULL, 0x00000a5000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff227224ULL, 0x000fe200078e0028ULL, 0xffff193000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0078ULL, 0x000167b000287802ULL, 0x000fc40000000f00ULL,
0x000009b000007944ULL, 0x018fea0003c00000ULL, 0xffff1a1000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0078ULL, 0x000167f000287802ULL, 0x000fc40000000f00ULL,
0x0000097000007944ULL, 0x01afea0003c00000ULL, 0xffff1b4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0078ULL, 0x0001683000287802ULL, 0x000fc40000000f00ULL,
0x0000093000007944ULL, 0x01afea0003c00000ULL, 0xffff1c7000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0078ULL, 0x0001687000287802ULL, 0x000fc40000000f00ULL,
0x000008f000007944ULL, 0x01afea0003c00000ULL, 0xffff1d9000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000cULL, 0x000168c000287802ULL, 0x000fe20000000f00ULL,
0x000000ffff297224ULL, 0x000fc400078e0023ULL, 0x000008a000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e0029ULL, 0xffff219000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000cULL, 0x0001691000287802ULL, 0x000fc40000000f00ULL,
0x0000085000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e0029ULL,
0x0000001023297810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000cULL,
0x0001696000287802ULL, 0x000fc40000000f00ULL, 0x0000080000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0d7224ULL, 0x004fe200078e0029ULL, 0xffff214000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000cULL, 0x000169b000287802ULL, 0x000fc40000000f00ULL,
0x000007b000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e0029ULL,
0xffff212000007947ULL, 0x000fea000383ffffULL, 0x00000001ff287807ULL, 0x004fe40004000000ULL,
0x00016a0000297802ULL, 0x000fc40000000f00ULL, 0x000007b000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff087224ULL, 0x000fe200078e0028ULL, 0xffff404000007947ULL, 0x000fea000383ffffULL,
0x00000001ff287807ULL, 0x000fe40005800000ULL, 0x00016a5000297802ULL, 0x000fc40000000f00ULL,
0x0000076000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff237224ULL, 0x000fe200078e0028ULL,
0xffff409000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000aULL,
0x00016aa000287802ULL, 0x000fc40000000f00ULL, 0x000006c000007944ULL, 0x018fea0003c00000ULL,
0xffff416000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000aULL,
0x00016ae000287802ULL, 0x000fc40000000f00ULL, 0x0000068000007944ULL, 0x01afea0003c00000ULL,
0xffff429000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000aULL,
0x00016b2000287802ULL, 0x000fc40000000f00ULL, 0x0000064000007944ULL, 0x01afea0003c00000ULL,
0xffff43c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000aULL,
0x00016b6000287802ULL, 0x000fc40000000f00ULL, 0x0000060000007944ULL, 0x01afea0003c00000ULL,
0xffff44e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0003ULL,
0x00016bb000287802ULL, 0x000fe20000000f00ULL, 0x000000ffff297224ULL, 0x000fc400078e0006ULL,
0x000005b000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e0029ULL,
0xffff490000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0003ULL,
0x00016c0000287802ULL, 0x000fc40000000f00ULL, 0x0000056000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e0029ULL, 0x0000001006297810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0003ULL, 0x00016c5000287802ULL, 0x000fc40000000f00ULL,
0x0000051000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0d7224ULL, 0x004fe200078e0029ULL,
0xffff48b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0003ULL,
0x00016ca000287802ULL, 0x000fc40000000f00ULL, 0x000004c000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e0029ULL, 0xffff489000007947ULL, 0x000fea000383ffffULL,
0x00000002ff0c7424ULL, 0x000fe200078e00ffULL, 0x00016cf000087802ULL, 0x000fc40000000f00ULL,
0x0000043000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e000bULL,
0xffffdfc000007947ULL, 0x000fea000383ffffULL, 0x000000ffff077224ULL, 0x006fe200078e000aULL,
0x00016d5000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff0c7424ULL, 0x000fc400078e00ffULL,
0x000003d000007944ULL, 0x010fea0003c00000ULL, 0x0000000b0a00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e000eULL, 0x00016db000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff0c7424ULL, 0x000fe200078e00ffULL, 0x0000000a0b067208ULL, 0x000fc80004000000ULL,
0x0000037000007944ULL, 0x000fea0003c00000ULL, 0x0000000b0e00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e000dULL, 0x00016e1000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff0c7424ULL, 0x000fe200078e00ffULL, 0x0000000e0b0e7208ULL, 0x000fc80004000000ULL,
0x0000031000007944ULL, 0x000fea0003c00000ULL, 0x0000000b0d00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e000fULL, 0x00016e7000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff0c7424ULL, 0x000fe200078e00ffULL, 0x0000000d0b0a7208ULL, 0x000fc80004000000ULL,
0x000002b000007944ULL, 0x000fea0003c00000ULL, 0x0000000b0f00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0006ULL, 0x00016ed000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff0c7424ULL, 0x000fe200078e00ffULL, 0x0000000f0b047208ULL, 0x000fc80004000000ULL,
0x0000025000007944ULL, 0x000fea0003c00000ULL, 0x0000000b0600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e000eULL, 0x00016f3000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff0c7424ULL, 0x000fe200078e00ffULL, 0x000000060b057208ULL, 0x000fc80004000000ULL,
0x000001f000007944ULL, 0x000fea0003c00000ULL, 0x0000000b0e00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e000aULL, 0x00016f9000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff0c7424ULL, 0x000fe200078e00ffULL, 0x0000000e0b067208ULL, 0x000fc80004000000ULL,
0x0000019000007944ULL, 0x000fea0003c00000ULL, 0xffffde9000007947ULL, 0x000fea000383ffffULL,
0x0180000021007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000027812ULL, 0x000fc800078ec0ffULL, 0x018000000200780cULL, 0x000fda0003f05070ULL,
0x0000002100008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x040fe40003f25070ULL, 0x008000000200780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff21ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000021027812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000002100007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e0004ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffe8ee002007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff097424ULL, 0x000fe200078e00ffULL, 0x0000005b00007348ULL, 0x000fe80003800000ULL,
0x0c00000c070b7389ULL, 0x0002a200000e005aULL, 0xfffe8ea008007950ULL, 0x000fea0003c3ffffULL,
0x0000008100007348ULL, 0x000fe80003800000ULL, 0x000000292a297389ULL, 0x0002a200000e0084ULL,
0x00000000ff2b7424ULL, 0x000fc400078e00ffULL, 0x000000ffff2a7224ULL, 0x002fc800078e0028ULL,
0xfffe8e502a007950ULL, 0x000fea0003c3ffffULL, 0x000000012800780cULL, 0x000fe20003f65070ULL,
0x000000ffff2a7224ULL, 0x000fe200078e0029ULL, 0x0000008000007348ULL, 0x000fe80003800000ULL,
0x00000000ff2b7424ULL, 0x000fce00078e00ffULL, 0x0000000000287806ULL, 0x000fc800058e0100ULL,
0x0000008028287212ULL, 0x000fe200078ec0ffULL, 0xfffe8de02a007950ULL, 0x000fec0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000002000000008ULL, 0x0000000400000001ULL, 0x0000001000000004ULL, 0x0000000800000001ULL,
0x0000000200000001ULL, 0x0000000100000008ULL, 0x0000000400000003ULL, 0x0000000300000004ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x0000000000000560ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000006c0ULL,
0x0000000000000270ULL, 0x0000001900000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000930ULL,
0x0000000000000350ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c80ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000d40ULL,
0x000000000000089cULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000015e0ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000015f0ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001680ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001684ULL,
0x00000000000001c0ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001880ULL,
0x0000000000017300ULL, 0xde00001900000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000018b80ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000018bc0ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x0000000000018f40ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000017500ULL,
0x0000000000017500ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000018b80ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000018f40ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_pagedKV_128_nqpkv_0_m_32_sm_89_cubin_len = 102432;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
