/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_pagedKV_128_nqpkv_0_m_32_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000017f30ULL, 0x0000000000017bb0ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x65722e0000000000ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x72655073776f7200ULL, 0x6e2e006b636f6c42ULL,
0x6174736e6f632e76ULL, 0x000000000033746eULL, 0x657a69536d656d73ULL, 0x7563344e5a5a5f00ULL,
0x5f33647473336164ULL, 0x7465645f5f38345fULL, 0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL,
0x75635f726564726fULL, 0x5f37456969456164ULL, 0x5f006d726f66785fULL, 0x727241374b4e5a5aULL,
0x6a4c664944327961ULL, 0x324545326a4c4532ULL, 0x454530624c497461ULL, 0x31456a6a664b5245ULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL,
0x6a4c45326a4c6649ULL, 0x4c45326a4c454532ULL, 0x497461324545386aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3053ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x5f5f374944327961ULL, 0x346a4c32666c6168ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL,
0x456a6a5f30534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL,
0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL, 0x497461324545386aULL,
0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x316a4c4532336a4cULL,
0x4c49746132454536ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x45386a4c4534366aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL,
0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4532ULL, 0x454530624c497461ULL,
0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL,
0x4944327961727241ULL, 0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL, 0x45326a4c4545316aULL,
0x7461324545316a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL,
0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x4939494432796172ULL, 0x74614d6e4974736eULL,
0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL, 0x534b524545453062ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x736e493949443279ULL, 0x4c4974614d6e4974ULL, 0x4545326a4c45326aULL, 0x45316a4c45346a4cULL,
0x30624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL,
0x324545386a4c4532ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x0000000000000067ULL, 0x0000000000000000ULL, 0x2400000000000000ULL,
0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL, 0x6e725f7063725f30ULL,
0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x742e6c65722e0068ULL, 0x6e72656b2e747865ULL,
0x2e0061686d5f6c65ULL, 0x7865742e616c6572ULL, 0x6c656e72656b2e74ULL, 0x656b240061686d5fULL,
0x61686d5f6c656e72ULL, 0x7479426d656d7324ULL, 0x65642e0066754265ULL, 0x6d6172665f677562ULL,
0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL, 0x665f67756265642eULL,
0x766e2e00656d6172ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL, 0x00000061686d5f6cULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b000100000096ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b5ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b0001000000beULL, 0x0000000000000030ULL,
0x0000000000000010ULL, 0x000b0001000000fcULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000b000100000135ULL, 0x0000000000000020ULL, 0x0000000000000004ULL, 0x000b00010000017cULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000b0001000001beULL, 0x000000000000002cULL,
0x0000000000000004ULL, 0x000b000100000204ULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000b00010000024bULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000b000100000291ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b0001000002dfULL, 0x0000000000000028ULL,
0x0000000000000004ULL, 0x000b00010000032dULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000b00010000037bULL, 0x000000000000001cULL, 0x0000000000000004ULL, 0x000b0001000003c9ULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000a002200000424ULL, 0x0000000000016510ULL, 0x0000000000000270ULL,
0x000400030000049aULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a101200000040ULL,
0x0000000000000000ULL, 0x0000000000016780ULL, 0x000d0003000004caULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000024ffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0001651000000000ULL, 0x0001080400000000ULL,
0x0000288080810c00ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880808492ULL, 0x0000002cffffffffULL, 0x0000006000000000ULL,
0x0001651000000000ULL, 0x0000027000000000ULL, 0x0000580400000000ULL, 0x8082288080840900ULL,
0x0000000000002880ULL, 0x0000001500082f04ULL, 0x00082304000000b9ULL, 0x0000000000000013ULL,
0x0000001300081204ULL, 0x0008110400000000ULL, 0x0000000000000013ULL, 0x0000001500082304ULL,
0x0008120400000000ULL, 0x0000000000000015ULL, 0x0000001500081104ULL, 0x0004370400000000ULL,
0x000c17040000007bULL, 0x0058000900000000ULL, 0x000c17040021f000ULL, 0x0050000800000000ULL,
0x000c17040021f000ULL, 0x0048000700000000ULL, 0x000c17040011f000ULL, 0x0028000600000000ULL,
0x000c17040081f000ULL, 0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL,
0x000c17040021f000ULL, 0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL,
0x000c17040011f000ULL, 0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL,
0x00ff1b030011f000ULL, 0xffffffff00dc2904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x000001c000dc2804ULL, 0x0000096000000260ULL, 0x00002b8000002b10ULL,
0x00002d9000002c60ULL, 0x0000300000002ec0ULL, 0x000035a000003590ULL, 0x000035c0000035b0ULL,
0x0000539000005330ULL, 0x000055d0000054a0ULL, 0x0000584000005700ULL, 0x00005ce000005cd0ULL,
0x00005d0000005cf0ULL, 0x00007a10000079b0ULL, 0x00007c5000007b20ULL, 0x00007ec000007d80ULL,
0x00008300000082f0ULL, 0x0000832000008310ULL, 0x0000a02000009fb0ULL, 0x0000a2400000a110ULL,
0x0000a4b00000a370ULL, 0x0000a9d00000a9c0ULL, 0x0000a9f00000a9e0ULL, 0x0000bc700000bc60ULL,
0x0000bc900000bc80ULL, 0x00014de000014d30ULL, 0x000151d0000150c0ULL, 0x000156b0000155b0ULL,
0x00015a0000015960ULL, 0x0000047004303904ULL, 0x0001a600000000ffULL, 0x0000055000040100ULL,
0x0001a60800000000ULL, 0x00000660003f0100ULL, 0x0001a68800000000ULL, 0x00000790003f0100ULL,
0x0001a6a800000005ULL, 0x000008a0003f0100ULL, 0x0001a6c800000004ULL, 0x00000fe0003f0100ULL,
0x0001a60000000009ULL, 0x00001160003f0107ULL, 0x0001a68800000000ULL, 0x00001b00003f0101ULL,
0x00000000000000ffULL, 0x00001b8000040107ULL, 0x00000000000000ffULL, 0x00001c0000040101ULL,
0x0000002000000003ULL, 0x00001d60003f0101ULL, 0x0001a6c800000038ULL, 0x00001ee0003f0109ULL,
0x0001a6c800000038ULL, 0x000027c0003f0109ULL, 0x0001a6b00000003aULL, 0x00002880003f0107ULL,
0x0001a6b00000003aULL, 0x00002890003f0101ULL, 0x0001a60800000080ULL, 0x000028b0003f0101ULL,
0x0001a60800000080ULL, 0x00002a20003f0109ULL, 0x0001a60800000080ULL, 0x00003190003f0109ULL,
0x0001a6a80000003aULL, 0x00003320003f0109ULL, 0x0001a6a80000003aULL, 0x00004700003f0109ULL,
0x0001a6c800000034ULL, 0x00004720003f0101ULL, 0x0001a6880000007cULL, 0x00004790003f0101ULL,
0x0000000000000006ULL, 0x00004900003f0109ULL, 0x0000000000000006ULL, 0x000050b0003f0109ULL,
0x00000000000000ffULL, 0x000050f000050107ULL, 0x00000000000000ffULL, 0x0000510000050101ULL,
0x0001a62800000080ULL, 0x00005120003f0101ULL, 0x0001a62800000080ULL, 0x00005290003f0109ULL,
0x0001a62800000080ULL, 0x00005a20003f0109ULL, 0x0001a6b000000037ULL, 0x00005b90003f0109ULL,
0x0001a6b000000037ULL, 0x00006d30003f0109ULL, 0x0001a6c800000034ULL, 0x00006d60003f0101ULL,
0x0001a69000000036ULL, 0x00006db0003f0101ULL, 0x0000000000000006ULL, 0x00006f20003f0109ULL,
0x0000000000000006ULL, 0x000076b0003f0109ULL, 0x00000008000000ffULL, 0x0000777000040107ULL,
0x0000000800000086ULL, 0x00007780003f0101ULL, 0x0001a64800000080ULL, 0x000077a0003f0101ULL,
0x0001a64800000080ULL, 0x00007910003f0109ULL, 0x0001a64800000080ULL, 0x00008070003f0109ULL,
0x00000000000000ffULL, 0x000081e000050109ULL, 0x00000000000000ffULL, 0x0000933000050109ULL,
0x0000000000000006ULL, 0x00009360003f0101ULL, 0x0001a69800000036ULL, 0x000093c0003f0101ULL,
0x0000000000000006ULL, 0x00009530003f0109ULL, 0x0000000000000006ULL, 0x00009d20003f0109ULL,
0x00000000000000ffULL, 0x00009d6000040107ULL, 0x00000000000000ffULL, 0x00009d7000050101ULL,
0x0001a66800000008ULL, 0x00009da0003f0101ULL, 0x0001a66800000008ULL, 0x00009f10003f0109ULL,
0x0001a66800000008ULL, 0x0000a680003f0109ULL, 0x0001a6b000000037ULL, 0x0000a7f0003f0109ULL,
0x0001a6b000000037ULL, 0x0000ba00003f0109ULL, 0x0000000000000006ULL, 0x0000ba70003f0101ULL,
0x0001a6a000000006ULL, 0x0000d7f0003f0101ULL, 0x0001a60000000009ULL, 0x0000f100003f0101ULL,
0x0001a60000000009ULL, 0x0000f270003f0109ULL, 0x0001a60000000009ULL, 0x0000f5c0003f0109ULL,
0x0001a60000000009ULL, 0x0000f5e0003f0101ULL, 0x0001a60000000009ULL, 0x0000f750003f0109ULL,
0x0001a60000000009ULL, 0x00012610003f0109ULL, 0x0001a68800000008ULL, 0x000129e0003f0101ULL,
0x0001a68800000008ULL, 0x00012b50003f0109ULL, 0x0001a68800000008ULL, 0x000164a0003f0109ULL,
0x0001a60800000077ULL, 0x000164b0003f0101ULL, 0x0001a61000000077ULL, 0x000164c0003f0101ULL,
0x0001a61800000077ULL, 0x000164d0003f0101ULL, 0x0001a62000000077ULL, 0x00053803003f0101ULL,
0x0000cba000301c04ULL, 0x0000cdb00000cc00ULL, 0x0000d0700000cf10ULL, 0x0000d3300000d1d0ULL,
0x0000d6200000d490ULL, 0x0000f7800000d720ULL, 0x000c050400016500ULL, 0x0000000100000100ULL,
0x00041e0400000001ULL, 0x0060190300000000ULL, 0x0000001600080a04ULL, 0x0000000000600210ULL,
0x00000000000000bcULL, 0x0000001500000002ULL, 0x0000000000016510ULL, 0x0000000000000044ULL,
0x0000001500000002ULL, 0x0000000000000000ULL, 0x0000000000000098ULL, 0x0000001500000002ULL,
0x0000000000000000ULL, 0x000000000001a700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e700000000800ULL, 0x00008400ff027b82ULL, 0x000ea20000000a00ULL,
0x00000000000f7919ULL, 0x000ee20000002300ULL, 0x0000048000007945ULL, 0x000fe20003800000ULL,
0x00000000000a7919ULL, 0x000eea0000002200ULL, 0x00000400ff067b82ULL, 0x000f220000000800ULL,
0x0000010000047ab9ULL, 0x000fe20000000800ULL, 0x0000000000797919ULL, 0x000f6c0000002700ULL,
0x00008600ff157b82ULL, 0x000f620000000800ULL, 0x0000000300007306ULL, 0x004ea20000209000ULL,
0x000000ff0300720cULL, 0x000fce0003f45070ULL, 0x0000000000007308ULL, 0x004ea40000001000ULL,
0x0ffffffe00047836ULL, 0x004fcc0000000000ULL, 0x0000000400057305ULL, 0x0004e4000021f000ULL,
0x000000ffff047224ULL, 0x004fe400078e00ffULL, 0x000000ffff087224ULL, 0x00afc800078e0a05ULL,
0x0000000308077224ULL, 0x000fe400078e02ffULL, 0x0000000000087919ULL, 0x000e640000002600ULL,
0x0000000705057227ULL, 0x000fe400078e0004ULL, 0x0000000000077919ULL, 0x000ea80000002100ULL,
0x0000000605777227ULL, 0x010fc800078e00ffULL, 0x000000ffff057224ULL, 0x000fc800078e0a77ULL,
0x0000000503007224ULL, 0x000fca00078e0206ULL, 0x000000030000720cULL, 0x000fda0003f06070ULL,
0x0000000100000824ULL, 0x000fe400078e0a03ULL, 0x0000000177770836ULL, 0x000fe20000000000ULL,
0x00000005ff787819ULL, 0x004fe40000011607ULL, 0x000000030000720cULL, 0x000fc80003f26070ULL,
0x00001fff78787589ULL, 0x000f7200000e0000ULL, 0x0000000177771836ULL, 0x000fe20000000000ULL,
0x00000003ff77a212ULL, 0x000fc800078e33ffULL, 0x0000007700007306ULL, 0x000ea20000209000ULL,
0x000000ff7700720cULL, 0x000fce0003f45070ULL, 0x0000000000007308ULL, 0x004ea40000001000ULL,
0x0ffffffe00047836ULL, 0x004fe40000000000ULL, 0x000000040f007c24ULL, 0x000fe2000f8e020aULL,
0x0000000000047ab9ULL, 0x000fc60000000800ULL, 0x0000000400057305ULL, 0x0004e2000021f000ULL,
0x00001fff0f0f7589ULL, 0x000f6200000e0000ULL, 0x000000ffff047224ULL, 0x004fe400078e00ffULL,
0x0000000577067224ULL, 0x008fc800078e02ffULL, 0x000000ffff097224ULL, 0x000fc800078e0a06ULL,
0x0000000905057227ULL, 0x000fc800078e0004ULL, 0x0000000400047c24ULL, 0x000fe4000f8e0207ULL,
0x0000000805597227ULL, 0x002fc600078e00ffULL, 0x0000007f0400780cULL, 0x040fe20003f64070ULL,
0x000000ffff057224ULL, 0x000fe200078e0a59ULL, 0x000000030400780cULL, 0x000fc60003f84070ULL,
0x0000000577007224ULL, 0x000fca00078e0208ULL, 0x000000770000720cULL, 0x000fc60003f06070ULL,
0x000000000006b919ULL, 0x000e620000008800ULL, 0x000004000005b802ULL, 0x000fd20000000f00ULL,
0x0000000100000824ULL, 0x000fe400078e0a77ULL, 0x0000000159590836ULL, 0x000fe20000000000ULL,
0x000000ff0400720cULL, 0x000fe40003f05270ULL, 0x000000770000720cULL, 0x000fda0003f26070ULL,
0x0000000159591836ULL, 0x000fe20000000000ULL, 0x00000077ff59a212ULL, 0x000fe400078e33ffULL,
0x0000000f0400780cULL, 0x000fe40003f24070ULL, 0x000006540605b816ULL, 0x002fe20000000005ULL,
0x000000ffff007224ULL, 0x000fe200078e0a59ULL, 0x000000010400780cULL, 0x000fe20003f44070ULL,
0xff317217ff06b424ULL, 0x000fe400078e00ffULL, 0x0000000077777224ULL, 0x000fc400078e0208ULL,
0x000000040405b824ULL, 0x000fe200078e0205ULL, 0x0000000000240947ULL, 0x020fee0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000067882ULL, 0x000fe20000000000ULL, 0x7ffc000000077882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000e740000000000ULL, 0x01a60006043f75b2ULL, 0x0002640008000100ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000381947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x0000000404007c11ULL, 0x000fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000000612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x01a60804063f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffb000000057882ULL, 0x000fc60000000000ULL,
0x0000000404007c11ULL, 0x000fe2000f8e18ffULL, 0x001ffec000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000000612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01a68804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x01a400060500b388ULL, 0x0003e20000000800ULL, 0x0000011000007945ULL, 0x000fe20003800000ULL,
0x0000002077007824ULL, 0x000fc600078e00ffULL, 0x0000000000384947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000ea20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x004fc60008000004ULL,
0x7ffc000000057882ULL, 0x000fc60000000000ULL, 0x0000000404057c11ULL, 0x002fe2000f8e18ffULL,
0x001fff0000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000050612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x01a6a804063f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000382947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000404047c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x002fca0000000000ULL, 0x00000000040612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01a6c804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ffff047224ULL, 0x000fe200078e0a00ULL, 0x0000001502057219ULL, 0x082fe200000006ffULL,
0x0000000279027224ULL, 0x000fe200078e02ffULL, 0x00000015030b7219ULL, 0x080fe200000006ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000500720cULL, 0x000fe20003f06070ULL,
0x0000820000067ab9ULL, 0x000fe20000000a00ULL, 0x0000002005757446ULL, 0x000fe20003800004ULL,
0x000000040f047824ULL, 0x000fe200078e0278ULL, 0x0000001559767219ULL, 0x000fc400000006ffULL,
0x000000ff75757207ULL, 0x000fe20000000000ULL, 0x0000000404047824ULL, 0x000fe400078e00ffULL,
0x0000000b02027224ULL, 0x000fe200078e0276ULL, 0x000000207500780cULL, 0x000fda0003f05270ULL,
0x0000000000c48947ULL, 0x000fea0003800000ULL, 0x00000000000a7919ULL, 0x000e620000000000ULL,
0xffffffffff087424ULL, 0x000fe200078e00ffULL, 0x0000000475057248ULL, 0x000fe20007fe0000ULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000000107919ULL, 0x000ea20000008800ULL,
0x0000040000097802ULL, 0x000fe40000000f00ULL, 0x0000001508077219ULL, 0x000fe200000006ffULL,
0x0000000105057824ULL, 0x000fe200078e0a04ULL, 0x00000004ff067819ULL, 0x002fc8000001160aULL,
0x000000050600720cULL, 0x080fe20003f06070ULL, 0x00000002060c7836ULL, 0x000fe20000000000ULL,
0x0000065410097816ULL, 0x004fe20000000009ULL, 0x0000000104117824ULL, 0x040fe400078e0206ULL,
0x0000000104137824ULL, 0x000fe200078e020cULL, 0x000000050c00720cULL, 0x000fe20003f26070ULL,
0x0000000100087824ULL, 0x040fe400078e0211ULL, 0x00000001000e7824ULL, 0x000fe400078e0213ULL,
0x000000100a047824ULL, 0x000fe200078e00ffULL, 0x00000007080d7212ULL, 0x000fc400078e30ffULL,
0x000000070e077212ULL, 0x000fe400078e30ffULL, 0x00000015ff087219ULL, 0x080fe20000011608ULL,
0x00000001020d7824ULL, 0x040fe200078e020dULL, 0x00000015ff0e7219ULL, 0x000fe2000001160eULL,
0x0000000102077824ULL, 0x000fe200078e0207ULL, 0x000000f004057812ULL, 0x000fe200078ec0ffULL,
0x0000000b08067224ULL, 0x080fe400078e020dULL, 0x0000000b0e0c7224ULL, 0x000fe400078e0207ULL,
0x0000010006067825ULL, 0x000fc800078e00ffULL, 0x000001000c0c7825ULL, 0x000fe200078e00ffULL,
0x0000000506067212ULL, 0x000fc600078efcffULL, 0x0000000111027824ULL, 0x140fe200078e020aULL,
0x000000050c057212ULL, 0x000fe200078efcffULL, 0x0000001011117824ULL, 0x000fe200078e00ffULL,
0x0000000406067c10ULL, 0x000fe2000ff5e0ffULL, 0x0000000113087824ULL, 0x040fe200078e020aULL,
0x00000004050c7c10ULL, 0x000fe2000ff7e0ffULL, 0x0000001013137824ULL, 0x000fe200078e00ffULL,
0xfffffff011027812ULL, 0x000fe400078ee202ULL, 0x0000000507077c10ULL, 0x000fe400097fe4ffULL,
0xfffffff013087812ULL, 0x000fe200078ee208ULL, 0x0000001002057824ULL, 0x000fe200078e0209ULL,
0x000000050d0d7c10ULL, 0x000fc60009ffe4ffULL, 0x0000001008117824ULL, 0x000fe200078e0209ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006057faeULL, 0x0003e8000c101c46ULL,
0x000000000c117faeULL, 0x0003e2000c901c46ULL, 0x0000000000a87947ULL, 0x000fea0003800000ULL,
0x00000000000a7919ULL, 0x000e620000000000ULL, 0x0000040000087802ULL, 0x000fe20000000f00ULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x00000000000d7919ULL, 0x000ea20000008800ULL,
0x000000040a057211ULL, 0x002fe200078fe0ffULL, 0xffffffffff047424ULL, 0x000fc800078e00ffULL,
0x0000000205117836ULL, 0x000fe20000000000ULL, 0x0000001504097219ULL, 0x000fe200000006ffULL,
0x0000000100047824ULL, 0x040fe400078e0205ULL, 0x0000000100067824ULL, 0x000fc600078e0211ULL,
0x0000000904077212ULL, 0x080fe400078e30ffULL, 0x0000000906097212ULL, 0x000fe400078e30ffULL,
0x00000015ff047219ULL, 0x080fe20000011604ULL, 0x0000000102077824ULL, 0x040fe200078e0207ULL,
0x00000015ff067219ULL, 0x000fe20000011606ULL, 0x0000000102027824ULL, 0x000fe200078e0209ULL,
0x000006540d097816ULL, 0x004fe20000000008ULL, 0x0000000b04077224ULL, 0x000fe400078e0207ULL,
0x000000100a047824ULL, 0x000fc400078e00ffULL, 0x0000000b06027224ULL, 0x000fe400078e0202ULL,
0x0000010007067825ULL, 0x000fe200078e00ffULL, 0x000000f004137812ULL, 0x000fc600078ec0ffULL,
0x00000100020c7825ULL, 0x000fe200078e00ffULL, 0x0000001306067212ULL, 0x000fc600078efcffULL,
0x0000000105027824ULL, 0x140fe200078e020aULL, 0x000000130c0c7212ULL, 0x000fe200078efcffULL,
0x0000001005157824ULL, 0x000fe200078e00ffULL, 0x0000000406067c10ULL, 0x000fe2000ff1e0ffULL,
0x0000000111057824ULL, 0x040fe200078e020aULL, 0x000000040c0c7c10ULL, 0x000fe2000ff3e0ffULL,
0x0000001011087824ULL, 0x000fe200078e00ffULL, 0xfffffff015027812ULL, 0x000fe400078ee202ULL,
0x0000000507077c10ULL, 0x000fe400087fe4ffULL, 0xfffffff008087812ULL, 0x000fe200078ee205ULL,
0x0000001002057824ULL, 0x000fe200078e0209ULL, 0x000000050d0d7c10ULL, 0x000fc60008ffe4ffULL,
0x0000001008117824ULL, 0x000fe200078e0209ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006057faeULL, 0x0003e8000b901c46ULL, 0x000000000c117faeULL, 0x0003e4000b901c46ULL,
0x00000000090472caULL, 0x000fe200000e0000ULL, 0x00009200ff067b82ULL, 0x002e620000000a00ULL,
0x0000000000007918ULL, 0x000fd60000000000ULL, 0x0001a60004047890ULL, 0x000fd2000fffe03fULL,
0x000000ffffff79a7ULL, 0x000fe20008200404ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a84ULL,
0x0000000479067825ULL, 0x002fe200078e0006ULL, 0x0000000000007918ULL, 0x000fc80000000000ULL,
0x0000000606747981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0f00720cULL, 0x000fe20003f05270ULL,
0x0000007f74637836ULL, 0x004fe40000000000ULL, 0x000000ff74057836ULL, 0x000fc60000000000ULL,
0x00000007ff637819ULL, 0x000fe40000011663ULL, 0x00000008ff617819ULL, 0x000fca0000011605ULL,
0x000000c400a08947ULL, 0x000fea0003800000ULL, 0x00000003ff607819ULL, 0x000fe20000011678ULL,
0xffffffffff827424ULL, 0x000fe400078e00ffULL, 0x00000004ff0f7424ULL, 0x000fe200078e00ffULL,
0x01ffffff60607812ULL, 0x000fc800078ec0ffULL, 0x000000636000720cULL, 0x000fda0003f06070ULL,
0x00009400ff0d8b82ULL, 0x000e620000000800ULL, 0x0000000279008824ULL, 0x000fce00078e00ffULL,
0x00009000ff068b82ULL, 0x000ea20000000a00ULL, 0x0000000d000d8224ULL, 0x002fe400078e020dULL,
0x0000000878007824ULL, 0x000fe400078e0209ULL, 0x00000001600d8824ULL, 0x000fe400078e020dULL,
0x01a6880f00ff79a7ULL, 0x0003e4000850003fULL, 0x000000040d068825ULL, 0x004fca00078e0006ULL,
0x0000000606828981ULL, 0x000ea2000c1e1900ULL, 0x000001ff0500780cULL, 0x000fe20003f04070ULL,
0x0000008059597824ULL, 0x000fe200078e00ffULL, 0x00000001ff627819ULL, 0x000fe40000011678ULL,
0x0000000178057812ULL, 0x000fc600078ec0ffULL, 0x00000020625b7824ULL, 0x000fe200078e00ffULL,
0x00008e00ff0c7b82ULL, 0x000ee80000000a00ULL, 0x0000006059007812ULL, 0x002fe200078ef85bULL,
0x0000000382037224ULL, 0x004fc800078e02ffULL, 0x0000008003037824ULL, 0x000fc800078e00ffULL,
0x0000008003027825ULL, 0x008fe200078e000cULL, 0x0000000000fc0947ULL, 0x000fec0003800000ULL,
0x0000005b74067248ULL, 0x000fe20007fe0000ULL, 0x0000001005057824ULL, 0x000fe200078e00ffULL,
0x00000003ff077819ULL, 0x000fc6000001160aULL, 0x0000000106067824ULL, 0x000fe400078e0a5bULL,
0x00000001050d7824ULL, 0x000fe400078e0207ULL, 0x00000004070c7836ULL, 0x000fe20000000000ULL,
0x0000000506067248ULL, 0x000fe20007fe0000ULL, 0x000000010d087824ULL, 0x040fe400078e020aULL,
0x000000080d0f7824ULL, 0x000fe400078e00ffULL, 0x0000000106067824ULL, 0x000fc400078e0a05ULL,
0x00000008070e7836ULL, 0x000fe20000000000ULL, 0xfffffff80f087812ULL, 0x000fe200078ee208ULL,
0x0000000c07107836ULL, 0x000fe20000000000ULL, 0x000000060700720cULL, 0x080fe20003f66070ULL,
0x00000001050f7824ULL, 0x000fe200078e020cULL, 0x000000060c00720cULL, 0x080fe20003f46070ULL,
0x0000000100077824ULL, 0x000fe200078e020dULL, 0x000000060e00720cULL, 0x080fe20003f26070ULL,
0x000000010f0c7824ULL, 0x040fe200078e020aULL, 0x000000061000720cULL, 0x000fe20003f06070ULL,
0x000000080f137824ULL, 0x000fc400078e00ffULL, 0x0000008007067825ULL, 0x000fc600078e00ffULL,
0xfffffff813127812ULL, 0x000fe200078ee20cULL, 0x0000000105117824ULL, 0x040fe200078e0210ULL,
0x0000007006137812ULL, 0x000fe200078ef804ULL, 0x00000001050d7824ULL, 0x000fe400078e020eULL,
0x00000001000e7824ULL, 0x040fe200078e0211ULL, 0x0000001302107210ULL, 0x000fe20007f9e0ffULL,
0x0000000111067824ULL, 0x040fe400078e020aULL, 0x0000000811117824ULL, 0x000fe400078e00ffULL,
0x00000001000f7824ULL, 0x000fc400078e020fULL, 0x00000001000c7824ULL, 0x000fe200078e020dULL,
0xfffffff811167812ULL, 0x000fe200078ee206ULL, 0x0000000103117824ULL, 0x000fe400020e0607ULL,
0x000000010d057824ULL, 0x040fe400078e020aULL, 0x000000080d147824ULL, 0x000fe400078e00ffULL,
0x000000800f067825ULL, 0x000fc600078e00ffULL, 0xfffffff814147812ULL, 0x000fe200078ee205ULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x00000070061d7812ULL, 0x000fc600078ef804ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000700c1b7812ULL, 0x000fc600078ef804ULL,
0x0000200062007824ULL, 0x000fe200078e0209ULL, 0x000000700e197812ULL, 0x000fe400078ef804ULL,
0x0000001d02047210ULL, 0x000fe20007f9e0ffULL, 0x0001600000057836ULL, 0x000fe20000000000ULL,
0x0000001b02067210ULL, 0x000fe40007fbe0ffULL, 0x0000001902027210ULL, 0x000fe20007fde0ffULL,
0x0000001008137824ULL, 0x100fe400078e0205ULL, 0x0000001012157824ULL, 0x000fc400078e0205ULL,
0x0000001014177824ULL, 0x100fe200078e0205ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010137faeULL, 0x0003e2000d901c46ULL, 0x0000001016197824ULL, 0x000fe400078e0205ULL,
0x0000000103057824ULL, 0x040fe400020e0607ULL, 0x0000000103077824ULL, 0x040fe400028e060dULL,
0x0000000103037824ULL, 0x000fe200030e060fULL, 0x0000000004157faeULL, 0x0003e8000d101c46ULL,
0x0000000006177faeULL, 0x0003e8000c901c46ULL, 0x0000000002197faeULL, 0x0003e2000c101c46ULL,
0x0000000000c87947ULL, 0x000fea0003800000ULL, 0x0000001005057824ULL, 0x000fca00078e00ffULL,
0x000000050a057211ULL, 0x000fca00078fe8ffULL, 0x00000004050d7836ULL, 0x000fe40000000000ULL,
0x0000000105077824ULL, 0x140fe400078e020aULL, 0x0000000805087824ULL, 0x000fe400078e00ffULL,
0x0000000100067824ULL, 0x000fe400078e0205ULL, 0x000000010d0c7824ULL, 0x040fe200078e020aULL,
0xfffffff808087812ULL, 0x000fe200078ee207ULL, 0x000000080d0f7824ULL, 0x000fc400078e00ffULL,
0x0000008006067825ULL, 0x000fc600078e00ffULL, 0xfffffff80f127812ULL, 0x000fe200078ee20cULL,
0x00000008050f7836ULL, 0x000fe20000000000ULL, 0x0000007006117812ULL, 0x000fe200078ef804ULL,
0x0000000c05057836ULL, 0x000fe40000000000ULL, 0x00000001000d7824ULL, 0x040fe200078e020dULL,
0x0000001102107210ULL, 0x000fe20007f1e0ffULL, 0x00000001000e7824ULL, 0x000fe400078e0205ULL,
0x0000000105067824ULL, 0x040fe400078e020aULL, 0x0000000805057824ULL, 0x000fc400078e00ffULL,
0x00000001000c7824ULL, 0x000fe400078e020fULL, 0x000000010f007824ULL, 0x040fe200078e020aULL,
0xfffffff805057812ULL, 0x000fe200078ee206ULL, 0x000000080f137824ULL, 0x000fe400078e00ffULL,
0x00002000620f7824ULL, 0x000fe400078e0209ULL, 0x0000000103117824ULL, 0x000fe200000e0607ULL,
0xfffffff813007812ULL, 0x000fe200078ee200ULL, 0x000000800d067825ULL, 0x000fc800078e00ffULL,
0x000160000f1f7836ULL, 0x000fe20000000000ULL, 0x00000070061d7812ULL, 0x000fe200078ef804ULL,
0x000000800c0c7825ULL, 0x000fc800078e00ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x000000700c1b7812ULL, 0x000fc600078ef804ULL, 0x0000001008137824ULL, 0x100fe200078e021fULL,
0x000000700e197812ULL, 0x000fe200078ef804ULL, 0x0000001012157824ULL, 0x100fe200078e021fULL,
0x0000001d02047210ULL, 0x000fe20007f1e0ffULL, 0x0000001000177824ULL, 0x100fe200078e021fULL,
0x0000001b02067210ULL, 0x000fe20007f3e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010137faeULL, 0x0003e2000b901c46ULL, 0x0000001902027210ULL, 0x000fe20007f5e0ffULL,
0x0000001005197824ULL, 0x000fe400078e021fULL, 0x0000000103057824ULL, 0x000fc400000e0607ULL,
0x0000000103077824ULL, 0x040fe400008e060dULL, 0x0000000103037824ULL, 0x000fe200010e060fULL,
0x0000000004157faeULL, 0x0003e8000b901c46ULL, 0x0000000006177faeULL, 0x0003e8000b901c46ULL,
0x0000000002197faeULL, 0x0003e4000b901c46ULL, 0x0001a6a809037836ULL, 0x002fe20000000000ULL,
0x00000000620472caULL, 0x000fe200000e0000ULL, 0x00000001ff027424ULL, 0x000fe200078e00ffULL,
0x000000ff6100720cULL, 0x000fe20003f05270ULL, 0x000000ffff837224ULL, 0x000fe200078e00ffULL,
0x00000000030572caULL, 0x000fe400000e0000ULL, 0x00000000002e7805ULL, 0x000fe4000001ff00ULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000327805ULL, 0x000fc4000001ff00ULL,
0x0000000000307805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fe4000001ff00ULL,
0x0000000000207805ULL, 0x000fe4000001ff00ULL, 0x00000000001e7805ULL, 0x000fe4000001ff00ULL,
0x00000000001c7805ULL, 0x000fe4000001ff00ULL, 0x00000000001a7805ULL, 0x000fc4000001ff00ULL,
0x0000000000187805ULL, 0x000fe4000001ff00ULL, 0x0000000000167805ULL, 0x000fe4000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000504047291ULL, 0x000fe2000f8e203fULL,
0x0000000000127805ULL, 0x000fe4000001ff00ULL, 0x0000000000107805ULL, 0x000fe4000001ff00ULL,
0x00000000000e7805ULL, 0x000fc4000001ff00ULL, 0x00000000000c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fe4000001ff00ULL, 0x0000000000247805ULL, 0x000fe4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000000527805ULL, 0x000fc4000001ff00ULL,
0x0000000000507805ULL, 0x000fe4000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a44ULL, 0x000000ffff497224ULL, 0x000fe400078e00ffULL,
0x0000000862037824ULL, 0x000fe200078e0203ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000002ff7a79a7ULL, 0x0002a20008500004ULL, 0x000000ffff487224ULL, 0x000fe200078e00ffULL,
0x0000000000467805ULL, 0x000fc4000001ff00ULL, 0x0000000000447805ULL, 0x000fe4000001ff00ULL,
0x0000000000427805ULL, 0x000fe4000001ff00ULL, 0x0000000000407805ULL, 0x000fe4000001ff00ULL,
0x00000000003e7805ULL, 0x000fe4000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x00002002030279a7ULL, 0x002e62000850003fULL, 0x0000000000567805ULL, 0x000fc4000001ff00ULL,
0x0000000000547805ULL, 0x000fe2000001ff00ULL, 0x0000009c00a08947ULL, 0x000fec0003800000ULL,
0x00009400ff047b82ULL, 0x000ee20000000800ULL, 0x00000002ff5a7819ULL, 0x000fe20000011678ULL,
0x0000000878027824ULL, 0x002fe200078e00ffULL, 0x0000000162007812ULL, 0x000fe200078ec0ffULL,
0x0000000279077824ULL, 0x000fe400078e00ffULL, 0x000000205a057824ULL, 0x000fe200078e0209ULL,
0x0000000802027812ULL, 0x000fe200078ec0ffULL, 0x000000ffff397224ULL, 0x000fe400078e0003ULL,
0x0000001000057824ULL, 0x000fc400078e0205ULL, 0xff317217ff7e7424ULL, 0x000fe400078e00ffULL,
0x0000000102087824ULL, 0x000fe400078e0205ULL, 0x000000ffff587224ULL, 0x000fe400078e00ffULL,
0x000000ffff2f7224ULL, 0x000fe400078e00ffULL, 0x0000000407077224ULL, 0x008fce00078e0204ULL,
0x0000000000347805ULL, 0x010fce0000015200ULL, 0x0000000478067824ULL, 0x000fca00078e00ffULL,
0xfffffff806067812ULL, 0x000fca00078ec0ffULL, 0x0000000109387824ULL, 0x000fc800078e0206ULL,
0x01a6c839380075a7ULL, 0x000e62000800017fULL, 0x0001a6c838067836ULL, 0x000fe20000000000ULL,
0x00000000005c0947ULL, 0x002fec0003800000ULL, 0x000000ffff3a7224ULL, 0x000fce00078e00ffULL,
0x000000103a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fce0000015200ULL, 0x00000036343b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003b36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013a3a7836ULL, 0x000fce0000000000ULL,
0x01a6c839380075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00008e00ff347b82ULL, 0x000e620000000a00ULL, 0x0000001078367824ULL, 0x000fe200078e00ffULL,
0x0000850000057ab9ULL, 0x000fe20000000800ULL, 0x0000000158387836ULL, 0x000fe40000000000ULL,
0x0000000582827c24ULL, 0x000fe2000f8e02ffULL, 0xffffffe036377812ULL, 0x000fe400078ec0ffULL,
0x000000613800720cULL, 0x000fc60003f26070ULL, 0x0000010058377824ULL, 0x000fc800078e0237ULL,
0x0000004037397836ULL, 0x000fe40000000000ULL, 0x0000008082377824ULL, 0x000fc600078e00ffULL,
0x0000006039387812ULL, 0x000fe200078ec0ffULL, 0x0000008037347825ULL, 0x002fc800078e0034ULL,
0x00000001594c7824ULL, 0x000fe200078e0238ULL, 0x0000000400049947ULL, 0x000fec0003800000ULL,
0x0000001036377812ULL, 0x000fe200078ec0ffULL, 0x000000100a5c7824ULL, 0x000fe200078e00ffULL,
0x0000003974367248ULL, 0x000fe40007fe0000ULL, 0x00000003ff3a7819ULL, 0x100fe4000001160aULL,
0x000000705c657812ULL, 0x000fe200078ec0ffULL, 0x0000000136367824ULL, 0x000fe400078e0a39ULL,
0x000000013a397824ULL, 0x000fe400078e0237ULL, 0x000000083a4d7836ULL, 0x000fe20000000000ULL,
0x0000003736367248ULL, 0x000fe20007fe0000ULL, 0x0000000139387824ULL, 0x000fc400078e020aULL,
0x00000008393b7824ULL, 0x000fe400078e00ffULL, 0x0000000136367824ULL, 0x000fc600078e0a37ULL,
0xfffffff83b4e7812ULL, 0x000fe200078ee238ULL, 0x000000043a3b7836ULL, 0x000fe20000000000ULL,
0x000000363a00720cULL, 0x080fe20003f86070ULL, 0x0000000c3a3a7836ULL, 0x000fe20000000000ULL,
0x000000364d00720cULL, 0x0c0fe20003f46070ULL, 0x000000014d4d7824ULL, 0x100fe200078e0237ULL,
0x000000363b00720cULL, 0x0c0fe20003f66070ULL, 0x000000013b3b7824ULL, 0x100fe200078e0237ULL,
0x000000363a00720cULL, 0x040fe20003f06070ULL, 0x000000013a4f7824ULL, 0x000fe400078e0237ULL,
0x000000014c387824ULL, 0x000fc400078e023bULL, 0x000000013b3a7824ULL, 0x140fe400078e020aULL,
0x000000083b5f7824ULL, 0x000fe400078e00ffULL, 0x000000014c367824ULL, 0x040fe400078e0239ULL,
0x000000014c3b7824ULL, 0x040fe200078e024dULL, 0xfffffff85f5c7812ULL, 0x000fe200078ee23aULL,
0x000000014c5d7824ULL, 0x000fe400078e024fULL, 0x000000014d4c7824ULL, 0x000fc400078e020aULL,
0x000000084d677824ULL, 0x000fe400078e00ffULL, 0x000000014f4d7824ULL, 0x040fe400078e020aULL,
0x000000084f647824ULL, 0x000fe200078e00ffULL, 0xfffffff8675e7812ULL, 0x000fe200078ee24cULL,
0x0000008038387825ULL, 0x000fc600078e00ffULL, 0xfffffff864647812ULL, 0x000fe200078ee24dULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x00000065384d7212ULL, 0x000fc600078efcffULL,
0x000000803b3a7825ULL, 0x000fe200078e00ffULL, 0x00000065364f7212ULL, 0x080fe400078efcffULL,
0x0000004d34387210ULL, 0x000fe20007fde0ffULL, 0x000000805d4c7825ULL, 0x000fe200078e00ffULL,
0x0000004f34367210ULL, 0x000fe40007fbe0ffULL, 0x000000653a677212ULL, 0x080fe200078efcffULL,
0x00002000625f7824ULL, 0x000fe200078e0209ULL, 0x000000654c657212ULL, 0x000fe200078efcffULL,
0x0000000135377824ULL, 0x000fe200028e0637ULL, 0x00000067343a7210ULL, 0x000fe20007fbe0ffULL,
0x000170005f4f7836ULL, 0x000fc40000000000ULL, 0x0000000135397824ULL, 0x040fe200030e0639ULL,
0x0000006534347210ULL, 0x000fe20007fde0ffULL, 0x000000104e5d7824ULL, 0x100fe400078e024fULL,
0x000000105c5f7824ULL, 0x100fe400078e024fULL, 0x000000105e657824ULL, 0x000fe200078e024fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000365d7faeULL, 0x0003e2000e101c46ULL,
0x00000001353b7824ULL, 0x040fe400028e063bULL, 0x00000010644f7824ULL, 0x000fe200078e024fULL,
0x00000000385f7faeULL, 0x0003e2000d901c46ULL, 0x0000000135357824ULL, 0x000fc600030e064dULL,
0x000000003a657faeULL, 0x0003e8000d101c46ULL, 0x00000000344f7faeULL, 0x0003e2000c101c46ULL,
0x0000000000d07947ULL, 0x000fea0003800000ULL, 0x0000001036377812ULL, 0x000fe200078ec0ffULL,
0x000000100a3a7824ULL, 0x000fc600078e00ffULL, 0x000000370a377211ULL, 0x000fe400078fe8ffULL,
0x000000703a657812ULL, 0x000fc600078ec0ffULL, 0x0000000437397836ULL, 0x000fe40000000000ULL,
0x0000000137367824ULL, 0x140fe400078e020aULL, 0x00000008373b7824ULL, 0x000fe400078e00ffULL,
0x0000000139387824ULL, 0x040fe400078e020aULL, 0x00000008394d7824ULL, 0x000fe200078e00ffULL,
0xfffffff83b4e7812ULL, 0x000fe200078ee236ULL, 0x000000014c367824ULL, 0x000fc400078e0237ULL,
0x00000008373b7836ULL, 0x000fe20000000000ULL, 0xfffffff84d5c7812ULL, 0x000fe200078ee238ULL,
0x0000000c374d7836ULL, 0x000fe40000000000ULL, 0x0000008036367825ULL, 0x000fc800078e00ffULL,
0x000000014c3a7824ULL, 0x000fe200078e023bULL, 0x00000065364f7212ULL, 0x000fe200078efcffULL,
0x000000013b387824ULL, 0x140fe400078e020aULL, 0x000000083b5d7824ULL, 0x000fe200078e00ffULL,
0x0000004f34367210ULL, 0x000fe20007f1e0ffULL, 0x000000014c397824ULL, 0x000fe400078e0239ULL,
0x000000014d3b7824ULL, 0x040fe200078e020aULL, 0xfffffff85d5e7812ULL, 0x000fe200078ee238ULL,
0x000000084d647824ULL, 0x000fc400078e00ffULL, 0x000000014c4c7824ULL, 0x000fe400078e024dULL,
0x00002000624d7824ULL, 0x000fe200078e0209ULL, 0xfffffff864647812ULL, 0x000fe200078ee23bULL,
0x0000008039387825ULL, 0x000fc800078e00ffULL, 0x000170004d6b7836ULL, 0x000fe20000000000ULL,
0x0000006538697212ULL, 0x000fe200078efcffULL, 0x000000803a3a7825ULL, 0x000fc800078e00ffULL,
0x000000804c4c7825ULL, 0x000fe200078e00ffULL, 0x000000653a677212ULL, 0x000fc600078efcffULL,
0x0000000135377824ULL, 0x040fe200000e0637ULL, 0x000000654c657212ULL, 0x000fe200078efcffULL,
0x000000104e4f7824ULL, 0x100fe200078e026bULL, 0x0000006934387210ULL, 0x000fe20007f1e0ffULL,
0x000000105c5d7824ULL, 0x100fe200078e026bULL, 0x00000067343a7210ULL, 0x000fe20007f5e0ffULL,
0x000000105e5f7824ULL, 0x000fe200078e026bULL, 0x0000006534347210ULL, 0x000fe20007f7e0ffULL,
0x0000000135397824ULL, 0x040fe200000e0639ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000364f7faeULL, 0x0003e2000b901c46ULL, 0x00000001353b7824ULL, 0x000fc400010e063bULL,
0x0000001064657824ULL, 0x000fe200078e026bULL, 0x00000000385d7faeULL, 0x0003e2000b901c46ULL,
0x0000000135357824ULL, 0x000fc600018e064dULL, 0x000000003a5f7faeULL, 0x0003e8000b901c46ULL,
0x0000000034657faeULL, 0x0003e4000b901c46ULL, 0x0000000160367836ULL, 0x002fe40000000000ULL,
0xffffffffff7a7424ULL, 0x004fc600078e00ffULL, 0x000000633600720cULL, 0x000fe20003f06070ULL,
0x0000000878387824ULL, 0x000fd800078e00ffULL, 0x0000000107378824ULL, 0x000fe200078e0236ULL,
0xfffffff038367812ULL, 0x000fe200078ec0ffULL, 0x00009000ff348b82ULL, 0x000e680000000a00ULL,
0x00000001093a7824ULL, 0x000fca00078e0236ULL, 0x000000003a0572caULL, 0x000fe200000e0000ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0001a6b005057890ULL, 0x000fe2000fffe03fULL,
0x0000000437348825ULL, 0x002fca00078e0034ULL, 0x00000006347a8981ULL, 0x000322000c1e1900ULL,
0xffffffe038367812ULL, 0x040fe200078ec0ffULL, 0x00000001ff397424ULL, 0x000fe200078e00ffULL,
0x0000001038377812ULL, 0x040fe200078ec0ffULL, 0x00000000ff0079b0ULL, 0x000fe60008000a45ULL,
0x0000000937367210ULL, 0x000fe40007ffe036ULL, 0x0000000838377812ULL, 0x000fca00078ec0ffULL,
0x0000000136807824ULL, 0x000fe200078e0237ULL, 0x0000000000007918ULL, 0x002fcc0000000000ULL,
0x01a6b0393a8679a7ULL, 0x0002a4000850003fULL, 0x01a60839803879a7ULL, 0x0022e4000850003fULL,
0x0000000000347805ULL, 0x000fce0000015200ULL, 0x01a60839800075a7ULL, 0x008ee4000800017fULL,
0x00000000005c0947ULL, 0x008fea0003800000ULL, 0x000000ffff4c7224ULL, 0x000fce00078e00ffULL,
0x000000104c00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fce0000015200ULL, 0x00000036343b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003b36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000014c4c7836ULL, 0x000fce0000000000ULL,
0x01a60839800075a7ULL, 0x000ee4000800017fULL, 0xfffffffc00a88947ULL, 0x008fea000383ffffULL,
0x000000100a6e7824ULL, 0x000fe200078e00ffULL, 0x00000001ff6f7819ULL, 0x000fe2000001160aULL,
0x0000002078347824ULL, 0x000fe400078e00ffULL, 0x00000001ff387424ULL, 0x000fe200078e00ffULL,
0x000000706e6e7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff857224ULL, 0x000fe200078e007eULL,
0xffffff8034347812ULL, 0x000fe400078ec0ffULL, 0x0000000c6f6f7812ULL, 0x000fe400078ec0ffULL,
0x000000096e347210ULL, 0x000fca0007ffe034ULL, 0x0000000134347824ULL, 0x000fca00078e026fULL,
0x01a0000034357984ULL, 0x000ee80000000800ULL, 0x01a2000034367984ULL, 0x000b620000000800ULL,
0x0000007e3500720bULL, 0x008fda0003f1d000ULL, 0x0000000000377806ULL, 0x000fc800000e0100ULL,
0x000000ff3700720cULL, 0x000fda0003f05270ULL, 0x00000004008c8947ULL, 0x026fea0003800000ULL,
0x000000785a00720cULL, 0x000fe40003f45270ULL, 0x0000007e3500720bULL, 0x0c0fe40003f14000ULL,
0x0000007e35857209ULL, 0x000fd20007810000ULL, 0x000000807834a824ULL, 0x000fe400078e0209ULL,
0x00000000004c7806ULL, 0x000fc600000e0100ULL, 0x000000346f34a210ULL, 0x000fe40007ffe06eULL,
0x000000ff4c00720cULL, 0x000fc60003f05270ULL, 0x01a400853400a388ULL, 0x0003f40000000800ULL,
0x0000000400508947ULL, 0x002fea0003800000ULL, 0x0000007e85347221ULL, 0x000fe20000010100ULL,
0x000000ff4cff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff004cff7812ULL, 0x000fe2000784c0ffULL,
0x3fb8aa3b34347820ULL, 0x000fe20000410000ULL, 0x00ff00004cff7812ULL, 0x040fe4000786c0ffULL,
0xff0000004cff7812ULL, 0x000fe2000788c0ffULL, 0x0000003400397308ULL, 0x0002ac0000000800ULL,
0x0000000000488947ULL, 0x000fec0003800000ULL, 0x00000002ff347819ULL, 0x002fcc000001160aULL,
0x00001f3439347589ULL, 0x004e6400000e0000ULL, 0x0000003454547220ULL, 0x082fe20000410000ULL,
0x0000003455557220ULL, 0x080fe20000410000ULL, 0x000000343c3c7220ULL, 0x080fe20000410000ULL,
0x000000343d3d7220ULL, 0x080fe20000410000ULL, 0x0000003440407220ULL, 0x080fe20000410000ULL,
0x0000003441417220ULL, 0x080fe20000410000ULL, 0x0000003444447220ULL, 0x080fe20000410000ULL,
0x0000003445457220ULL, 0x080fe20000410000ULL, 0x0000003448487220ULL, 0x080fe20000410000ULL,
0x0000003449497220ULL, 0x080fe20000410000ULL, 0x0000003450507220ULL, 0x080fe20000410000ULL,
0x0000003451517220ULL, 0x080fe20000410000ULL, 0x0000003428287220ULL, 0x080fe20000410000ULL,
0x0000003429297220ULL, 0x080fe20000410000ULL, 0x0000003424247220ULL, 0x080fe20000410000ULL,
0x0000003425257220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x000000080a347811ULL, 0x002fcc00078ff0ffULL, 0x00001f3439347589ULL, 0x004e6400000e0000ULL,
0x0000003456567220ULL, 0x082fe20000410000ULL, 0x0000003457577220ULL, 0x080fe20000410000ULL,
0x000000343e3e7220ULL, 0x080fe20000410000ULL, 0x000000343f3f7220ULL, 0x080fe20000410000ULL,
0x0000003442427220ULL, 0x080fe20000410000ULL, 0x0000003443437220ULL, 0x080fe20000410000ULL,
0x0000003446467220ULL, 0x080fe20000410000ULL, 0x0000003447477220ULL, 0x080fe20000410000ULL,
0x000000344a4a7220ULL, 0x080fe20000410000ULL, 0x000000344b4b7220ULL, 0x080fe20000410000ULL,
0x0000003452527220ULL, 0x080fe20000410000ULL, 0x0000003453537220ULL, 0x080fe20000410000ULL,
0x000000342a2a7220ULL, 0x080fe20000410000ULL, 0x000000342b2b7220ULL, 0x080fe20000410000ULL,
0x0000003426267220ULL, 0x080fe20000410000ULL, 0x0000003427277220ULL, 0x000fce0000410000ULL,
0x000000000048b947ULL, 0x000fea0003800000ULL, 0x000000100a347811ULL, 0x002fcc00078ff0ffULL,
0x00001f3439347589ULL, 0x004e6400000e0000ULL, 0x000000340c0c7220ULL, 0x082fe20000410000ULL,
0x000000340d0d7220ULL, 0x080fe20000410000ULL, 0x0000003410107220ULL, 0x080fe20000410000ULL,
0x0000003411117220ULL, 0x080fe20000410000ULL, 0x0000003414147220ULL, 0x080fe20000410000ULL,
0x0000003415157220ULL, 0x080fe20000410000ULL, 0x0000003418187220ULL, 0x080fe20000410000ULL,
0x0000003419197220ULL, 0x080fe20000410000ULL, 0x000000341c1c7220ULL, 0x080fe20000410000ULL,
0x000000341d1d7220ULL, 0x080fe20000410000ULL, 0x0000003420207220ULL, 0x080fe20000410000ULL,
0x0000003421217220ULL, 0x080fe20000410000ULL, 0x0000003430307220ULL, 0x080fe20000410000ULL,
0x0000003431317220ULL, 0x080fe20000410000ULL, 0x000000342c2c7220ULL, 0x080fe20000410000ULL,
0x000000342d2d7220ULL, 0x000fce0000410000ULL, 0x0000003983837220ULL, 0x004fe20000410000ULL,
0x000000000048c947ULL, 0x000fec0003800000ULL, 0x000000180a347811ULL, 0x002fcc00078ff0ffULL,
0x00001f3439347589ULL, 0x000e6400000e0000ULL, 0x000000340e0e7220ULL, 0x082fe20000410000ULL,
0x000000340f0f7220ULL, 0x080fe20000410000ULL, 0x0000003412127220ULL, 0x080fe20000410000ULL,
0x0000003413137220ULL, 0x080fe20000410000ULL, 0x0000003416167220ULL, 0x080fe20000410000ULL,
0x0000003417177220ULL, 0x080fe20000410000ULL, 0x000000341a1a7220ULL, 0x080fe20000410000ULL,
0x000000341b1b7220ULL, 0x080fe20000410000ULL, 0x000000341e1e7220ULL, 0x080fe20000410000ULL,
0x000000341f1f7220ULL, 0x080fe20000410000ULL, 0x0000003422227220ULL, 0x080fe20000410000ULL,
0x0000003423237220ULL, 0x080fe20000410000ULL, 0x0000003432327220ULL, 0x080fe20000410000ULL,
0x0000003433337220ULL, 0x080fe20000410000ULL, 0x000000342e2e7220ULL, 0x080fe20000410000ULL,
0x000000342f2f7220ULL, 0x000fce0000410000ULL, 0x0000004c37ff7212ULL, 0x000fda00078030ffULL,
0x8000008535350221ULL, 0x000fe20000010000ULL, 0x00007610ff380816ULL, 0x000fc60000000038ULL,
0x3fb8aa3b35350820ULL, 0x000fc80000410000ULL, 0x0000003500040308ULL, 0x000ea40000000800ULL,
0x0000000436360220ULL, 0x004fce0000410000ULL, 0x0000008336837221ULL, 0x000fce0000010000ULL,
0x0000000000347805ULL, 0x002fce0000015200ULL, 0x01a6a87b3a0075a7ULL, 0x000e62000800017fULL,
0x0001a6a83a397836ULL, 0x000fca0000000000ULL, 0x00000000390572caULL, 0x000fe200000e0000ULL,
0x0000000000600947ULL, 0x002fdc0003800000ULL, 0x000000ffff4c7224ULL, 0x000fce00078e00ffULL,
0x000000104c00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fce0000015200ULL, 0x00000036343b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003b36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000014c4c7836ULL, 0x000fce0000000000ULL,
0x01a6a87b3a0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00000000390572caULL, 0x000fde00000e0000ULL, 0x00000002787c7824ULL, 0x000fe200078e00ffULL,
0x000000080a357812ULL, 0x000fe200078ec0ffULL, 0x0000000478717824ULL, 0x000fe200078e00ffULL,
0x0000991038387816ULL, 0x000fe200000000ffULL, 0x0000100078377824ULL, 0x000fe200078e00ffULL,
0x000000047c7d7812ULL, 0x000fe400078ec0ffULL, 0x00000007356c7812ULL, 0x000fe200078ef80aULL,
0x000000ffff357224ULL, 0x000fe200078e0038ULL, 0x0000007d0a347211ULL, 0x000fe400078fe0ffULL,
0x000000106c797812ULL, 0x040fe200078efcffULL, 0x000000086c367824ULL, 0x040fe200078e00ffULL,
0x000000ff3500720cULL, 0x000fe20003f05270ULL, 0x000000016c7f7824ULL, 0x000fe200078e0234ULL,
0x0000000471717812ULL, 0x000fe200078ec0ffULL, 0x0000040078357824ULL, 0x000fe200078e00ffULL,
0xffffe00037387812ULL, 0x000fe200078ec0ffULL, 0x00000001347e7824ULL, 0x000fe200078e0279ULL,
0xfffffff8367f7812ULL, 0x000fe200078ee27fULL, 0x000000086c6d7824ULL, 0x000fe200078e00ffULL,
0xfffff00035367812ULL, 0x000fe200078ec0ffULL, 0x0000000879357824ULL, 0x000fe200078e00ffULL,
0x000000710a717211ULL, 0x000fc400078fe0ffULL, 0x0001200009737810ULL, 0x040fe40007ffe036ULL,
0xfffffff8357e7812ULL, 0x000fe200078ee27eULL, 0x000000016c5c7824ULL, 0x000fe200078e0271ULL,
0x00016000095e7810ULL, 0x000fe20007ffe038ULL, 0x000000107f367824ULL, 0x100fe400078e0273ULL,
0x000000107e387824ULL, 0x000fe200078e0273ULL, 0xfffffff86d6d7812ULL, 0x000fe200078ee25cULL,
0x0000000000280947ULL, 0x000fec0003800000ULL, 0x00000002ff037819ULL, 0x000fe4000001160aULL,
0x00000004ff00723eULL, 0x000fc600000000ffULL, 0x0000001003057836ULL, 0x000fe20000000000ULL,
0x0000541000347816ULL, 0x000fe20000000000ULL, 0x0000000803357836ULL, 0x000fe40000000000ULL,
0x0000001803377836ULL, 0x000fe40000000000ULL, 0x00001f0534057589ULL, 0x0002a800000e0000ULL,
0x00001f3534027589ULL, 0x0002e800000e0000ULL, 0x00001f0334037589ULL, 0x00026800000e0000ULL,
0x00001f3734007589ULL, 0x00026400000e0000ULL, 0x000000003634783bULL, 0x002e620000000200ULL,
0x000000106d4c7824ULL, 0x000fc600078e025eULL, 0x000000003838783bULL, 0x000ee20000000200ULL,
0x0000000000200947ULL, 0x000fea0003800000ULL, 0x0000000334347232ULL, 0x082fe40000000000ULL,
0x0000000336367232ULL, 0x000fe40000000000ULL, 0x0000000235357232ULL, 0x088fe40000000000ULL,
0x0000000237377232ULL, 0x000fe40000000000ULL, 0x0000000538387232ULL, 0x084fe40000000000ULL,
0x000000053a3a7232ULL, 0x000fc40000000000ULL, 0x0000000039397232ULL, 0x080fe40000000000ULL,
0x000000003b3b7232ULL, 0x000fce0000000000ULL, 0x000000086c647824ULL, 0x000fe200078e00ffULL,
0x000000004c4c783bULL, 0x000f620000004200ULL, 0x000000025c7b7836ULL, 0x000fe20000000000ULL,
0x000000027d7d7812ULL, 0x000fc800078efcffULL, 0xfffffff8647b7812ULL, 0x000fe400078ee27bULL,
0x0000007d0a7d7211ULL, 0x000fc600078fe0ffULL, 0x000000107b5e7824ULL, 0x000fcc00078e025eULL,
0x000000005e5c783bULL, 0x000f640000004200ULL, 0x00000010ff907819ULL, 0x028fe4000001164cULL,
0x00000018ff657819ULL, 0x000fe4000001164eULL, 0x00000010ff917819ULL, 0x000fe4000001164dULL,
0x000000ff4c8e7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff4c6a7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff677819ULL, 0x000fe4000001164fULL, 0x000000ff90907812ULL, 0x000fe400078ec0ffULL,
0x00000018ff897819ULL, 0x000fe4000001164cULL, 0x00000010ff8c7819ULL, 0x000fe4000001164eULL,
0x000000ff5d927812ULL, 0x004fe400078ec0ffULL, 0x00000010ff827819ULL, 0x000fc4000001165eULL,
0x000000ff5e947812ULL, 0x040fe400078ec0ffULL, 0x00000018ff937819ULL, 0x000fe4000001165eULL,
0x0000ffff5e667812ULL, 0x000fe400078ec0ffULL, 0x00000018ff6b7819ULL, 0x000fe4000001165dULL,
0x00000065ff5e723eULL, 0x000fe400020006ffULL, 0x00000092ff65723eULL, 0x000fc400020006ffULL,
0x0000ffff4f4c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff647819ULL, 0x100fe4000001165fULL,
0x000000ff5f957812ULL, 0x040fe400078ec0ffULL, 0x00000018ff687819ULL, 0x000fe4000001165fULL,
0x0000ffff5f707812ULL, 0x000fe400078ec0ffULL, 0x000000ff91927812ULL, 0x000fc400078ec0ffULL,
0x000000ff4e887812ULL, 0x040fe400078ec0ffULL, 0x0000ffff4e8b7812ULL, 0x000fe400078ec0ffULL,
0x0000008eff8e723eULL, 0x000fe400020006ffULL, 0x00000067ff5f723eULL, 0x000fe400020006ffULL,
0x00000008ff917819ULL, 0x000fe4000001166aULL, 0x00000090ff90723eULL, 0x000fc400020006ffULL,
0x00000010ff4e7819ULL, 0x000fe4000001165cULL, 0x0000006bff67723eULL, 0x000fe400020006ffULL,
0x00000094ff6b723eULL, 0x000fe400020006ffULL, 0x000000ff4d8f7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff8a7819ULL, 0x000fe4000001164dULL, 0x0000ffff4d8d7812ULL, 0x000fc400078ec0ffULL,
0x000000ff8c8c7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff947819ULL, 0x000fe4000001164cULL,
0x00000010ff4d7819ULL, 0x000fe4000001164fULL, 0x000000ff5c817812ULL, 0x000fe400078ec0ffULL,
0x00000018ff727819ULL, 0x000fe4000001165cULL, 0x00000089ff89723eULL, 0x000fc400020006ffULL,
0x00000091ff91723eULL, 0x000fe400020006ffULL, 0x000054108e4c7816ULL, 0x000fe40000000090ULL,
0x0000ffff5c5c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff4e8e7812ULL, 0x000fe400078ec0ffULL,
0x00000088ff88723eULL, 0x000fe400020006ffULL, 0x00000008ff8d7819ULL, 0x000fc4000001168dULL,
0x0000008cff8c723eULL, 0x000fe400020006ffULL, 0x000000ff4d4d7812ULL, 0x000fe400078ec0ffULL,
0x00005410914e7816ULL, 0x000fe40000000089ULL, 0x000000ff4f697812ULL, 0x000fe400078ec0ffULL,
0x0000008fff8f723eULL, 0x000fe400020006ffULL, 0x00000081ff81723eULL, 0x000fc400020006ffULL,
0x00000092ff92723eULL, 0x000fe400020006ffULL, 0x0000008eff8e723eULL, 0x000fe400020006ffULL,
0x00000008ff897819ULL, 0x000fe4000001165cULL, 0x00000010ff4f7819ULL, 0x000fe4000001165dULL,
0x0000ffff5d847812ULL, 0x000fe400078ec0ffULL, 0x00000093ff6a723eULL, 0x000fc400020006ffULL,
0x0000008dff93723eULL, 0x000fe400020006ffULL, 0x00005410885c7816ULL, 0x000fe4000000008cULL,
0x0000004dff8d723eULL, 0x000fe400020006ffULL, 0x000000ff64887812ULL, 0x000fe400078ec0ffULL,
0x00000072ff72723eULL, 0x000fe400020006ffULL, 0x000054108f4d7816ULL, 0x000fc40000000092ULL,
0x00000089ff89723eULL, 0x000fe400020006ffULL, 0x000000ff82827812ULL, 0x000fe400078ec0ffULL,
0x0000541081647816ULL, 0x000fe2000000008eULL, 0x0000004c3454723cULL, 0x002fe20000001854ULL,
0x00000008ff8b7819ULL, 0x000fe4000001168bULL, 0x000000ff4f8f7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff847819ULL, 0x000fe20000011684ULL, 0x0000004c380c723cULL, 0x000fe2000000180cULL,
0x00000008ff817819ULL, 0x000fc40000011666ULL, 0x00000008ff707819ULL, 0x000fe40000011670ULL,
0x00000069ff5d723eULL, 0x000fe400020006ffULL, 0x00000082ff82723eULL, 0x000fe400020006ffULL,
0x0000541089667816ULL, 0x000fe40000000072ULL, 0x0000008aff8a723eULL, 0x000fe400020006ffULL,
0x00000095ff69723eULL, 0x000fc400020006ffULL, 0x0000008bff8b723eULL, 0x000fe400020006ffULL,
0x00000094ff94723eULL, 0x000fe400020006ffULL, 0x0000008fff8f723eULL, 0x000fe400020006ffULL,
0x00000084ff84723eULL, 0x000fe400020006ffULL, 0x00000088ff88723eULL, 0x000fe400020006ffULL,
0x00000068ff72723eULL, 0x000fc400020006ffULL, 0x00000081ff81723eULL, 0x000fe400020006ffULL,
0x00000070ff70723eULL, 0x000fe400020006ffULL, 0x000054106b687816ULL, 0x000fe40000000082ULL,
0x00005410934f7816ULL, 0x000fe4000000008aULL, 0x000054105d5d7816ULL, 0x000fe4000000008dULL,
0x000054108b5e7816ULL, 0x000fc4000000005eULL, 0x00005410945f7816ULL, 0x000fe2000000005fULL,
0x0000004e343c723cULL, 0x000fe2000000183cULL, 0x0000541065657816ULL, 0x000fe4000000008fULL,
0x0000541084677816ULL, 0x000fe40000000067ULL, 0x0000541069697816ULL, 0x000fe20000000088ULL,
0x0000005c3440723cULL, 0x000fe20000001840ULL, 0x00005410816a7816ULL, 0x000fe4000000006aULL,
0x00005410706b7816ULL, 0x000fe20000000072ULL, 0x000000016c707824ULL, 0x000fc400078e027dULL,
0x0000005e3444723cULL, 0x000fe20000001844ULL, 0x00000001797d7824ULL, 0x000fe400078e027dULL,
0x0000200062727824ULL, 0x000fc600078e0209ULL, 0x000000643448723cULL, 0x000fe20000001848ULL,
0x0001600072847836ULL, 0x000fca0000000000ULL, 0x000000663450723cULL, 0x000fec0000001850ULL,
0x000000683428723cULL, 0x000fec0000001828ULL, 0x0000006a3424723cULL, 0x000fec0000001824ULL,
0x0000005c3814723cULL, 0x000fe20000001814ULL, 0x000000086c357824ULL, 0x000fc400078e00ffULL,
0x0000000879347824ULL, 0x000fc600078e00ffULL, 0xfffffff835707812ULL, 0x000fe200078ee270ULL,
0x00000001795c7824ULL, 0x040fe200078e0271ULL, 0xfffffff834717812ULL, 0x000fe200078ee27dULL,
0x0000000879357824ULL, 0x000fe200078e00ffULL, 0x0000004e3810723cULL, 0x000fe20000001810ULL,
0x0000001070347824ULL, 0x100fe400078e0273ULL, 0x0000001071737824ULL, 0x000fe200078e0273ULL,
0xfffffff8357d7812ULL, 0x000fe400078ee25cULL, 0x0000005e3818723cULL, 0x000fe20000001818ULL,
0x000000003434783bULL, 0x000e640000000200ULL, 0x000000107d4c7824ULL, 0x000fc600078e0284ULL,
0x00000064381c723cULL, 0x000fec000000181cULL, 0x000000663820723cULL, 0x000fec0000001820ULL,
0x000000683830723cULL, 0x000fec0000001830ULL, 0x0000006a3838723cULL, 0x000fe2000000182cULL,
0x00000000732c783bULL, 0x0004e20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000200947ULL, 0x000fde0003800000ULL, 0x0000000334347232ULL, 0x082fe40000000000ULL,
0x0000000336367232ULL, 0x000fe40000000000ULL, 0x0000000235357232ULL, 0x080fe40000000000ULL,
0x0000000237377232ULL, 0x000fe40000000000ULL, 0x000000052c2c7232ULL, 0x088fe40000000000ULL,
0x000000052e2e7232ULL, 0x000fc40000000000ULL, 0x000000002d2d7232ULL, 0x080fe40000000000ULL,
0x000000002f2f7232ULL, 0x000fce0000000000ULL, 0x00000008795e7824ULL, 0x000fe200078e00ffULL,
0x000000004c4c783bULL, 0x000f620000004200ULL, 0x000000025c737836ULL, 0x004fe20000000000ULL,
0xfffffff87c7c7812ULL, 0x000fc800078ec0ffULL, 0xfffffff85e737812ULL, 0x000fe200078ee273ULL,
0x00000001097c7824ULL, 0x000fc800078e027cULL, 0x00000010735c7824ULL, 0x000fcc00078e0284ULL,
0x000000005c5c783bULL, 0x000ea20000004200ULL, 0x00000018ff677819ULL, 0x020fe4000001164fULL,
0x00000010ff947819ULL, 0x100fe4000001164dULL, 0x000000ff4d927812ULL, 0x000fe400078ec0ffULL,
0x00000018ff8e7819ULL, 0x000fe4000001164dULL, 0x00000018ff657819ULL, 0x000fe4000001164eULL,
0x00000010ff937819ULL, 0x000fc4000001164cULL, 0x0000ffff4d4d7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff4c6a7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8c7819ULL, 0x000fe4000001164eULL,
0x00000018ff6b7819ULL, 0x004fe4000001165dULL, 0x000000ff5e977812ULL, 0x000fe400078ec0ffULL,
0x00000010ff647819ULL, 0x000fc4000001165fULL, 0x000000ff5f987812ULL, 0x040fe400078ec0ffULL,
0x00000018ff687819ULL, 0x000fe4000001165fULL, 0x0000ffff5f817812ULL, 0x000fe400078ec0ffULL,
0x00000067ff5f723eULL, 0x000fe400020006ffULL, 0x0000006bff67723eULL, 0x000fe400020006ffULL,
0x000000ff5d967812ULL, 0x000fc400078ec0ffULL, 0x00000097ff6b723eULL, 0x000fe400020006ffULL,
0x000000ff94977812ULL, 0x000fe400078ec0ffULL, 0x00000010ff897819ULL, 0x100fe4000001165eULL,
0x00000018ff957819ULL, 0x000fe4000001165eULL, 0x0000ffff5e667812ULL, 0x000fe400078ec0ffULL,
0x00000065ff5e723eULL, 0x000fc400020006ffULL, 0x00000096ff65723eULL, 0x000fe400020006ffULL,
0x000000ff93937812ULL, 0x000fe400078ec0ffULL, 0x00000008ff4d7819ULL, 0x000fe4000001164dULL,
0x00000018ff8d7819ULL, 0x000fe4000001164cULL, 0x000000ff4e8b7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff4e907812ULL, 0x000fc400078ec0ffULL, 0x000000ff4f697812ULL, 0x000fe400078ec0ffULL,
0x00000092ff92723eULL, 0x000fe400020006ffULL, 0x00000008ff967819ULL, 0x000fe4000001166aULL,
0x00000097ff97723eULL, 0x000fe400020006ffULL, 0x000000ff4c917812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4e7819ULL, 0x000fc4000001165cULL, 0x00000010ff8f7819ULL, 0x000fe4000001164fULL,
0x0000ffff4f4c7812ULL, 0x000fe400078ec0ffULL, 0x00000095ff6a723eULL, 0x000fe400020006ffULL,
0x00000010ff4f7819ULL, 0x000fe4000001165dULL, 0x0000ffff5d8a7812ULL, 0x000fe400078ec0ffULL,
0x00000093ff94723eULL, 0x000fc400020006ffULL, 0x000000ff8c8c7812ULL, 0x000fe400078ec0ffULL,
0x0000004dff95723eULL, 0x000fe400020006ffULL, 0x000000ff5c887812ULL, 0x000fe400078ec0ffULL,
0x00000018ff827819ULL, 0x000fe4000001165cULL, 0x0000008dff8d723eULL, 0x000fe400020006ffULL,
0x00000069ff5d723eULL, 0x000fc400020006ffULL, 0x00000096ff93723eULL, 0x000fe400020006ffULL,
0x00005410924d7816ULL, 0x000fe40000000097ULL, 0x0000ffff5c5c7812ULL, 0x000fe400078ec0ffULL,
0x00000098ff69723eULL, 0x000fe400020006ffULL, 0x000000ff4e927812ULL, 0x000fe400078ec0ffULL,
0x000000ff8f987812ULL, 0x000fc400078ec0ffULL, 0x0000008bff8b723eULL, 0x000fe400020006ffULL,
0x00000008ff967819ULL, 0x000fe40000011690ULL, 0x0000008cff8f723eULL, 0x000fe400020006ffULL,
0x00005410934e7816ULL, 0x000fe4000000008dULL, 0x00000091ff91723eULL, 0x000fe400020006ffULL,
0x00000088ff88723eULL, 0x000fc400020006ffULL, 0x00000092ff92723eULL, 0x000fe400020006ffULL,
0x00000008ff8d7819ULL, 0x000fe4000001165cULL, 0x00000096ff8c723eULL, 0x000fe400020006ffULL,
0x000054108b5c7816ULL, 0x000fe4000000008fULL, 0x00000008ff967819ULL, 0x000fe4000001164cULL,
0x000000ff648b7812ULL, 0x000fc400078ec0ffULL, 0x00000082ff82723eULL, 0x000fe400020006ffULL,
0x00005410914c7816ULL, 0x000fe40000000094ULL, 0x0000008dff8d723eULL, 0x000fe400020006ffULL,
0x000000ff89897812ULL, 0x000fe400078ec0ffULL, 0x0000541088647816ULL, 0x000fe20000000092ULL,
0x0000004c3454723cULL, 0x002fe20000001854ULL, 0x000000ff4f947812ULL, 0x000fc400078ec0ffULL,
0x00000008ff8a7819ULL, 0x000fe4000001168aULL, 0x00000008ff887819ULL, 0x000fe20000011666ULL,
0x0000004c2c0c723cULL, 0x008fe2000000180cULL, 0x00000008ff817819ULL, 0x000fe40000011681ULL,
0x00000089ff89723eULL, 0x000fe400020006ffULL, 0x000054108d667816ULL, 0x000fe40000000082ULL,
0x0000008eff8e723eULL, 0x000fc400020006ffULL, 0x00000098ff90723eULL, 0x000fe400020006ffULL,
0x00000096ff91723eULL, 0x000fe400020006ffULL, 0x00000094ff94723eULL, 0x000fe400020006ffULL,
0x0000008aff8a723eULL, 0x000fe400020006ffULL, 0x0000008bff8b723eULL, 0x000fe400020006ffULL,
0x00000068ff82723eULL, 0x000fc400020006ffULL, 0x00000088ff88723eULL, 0x000fe400020006ffULL,
0x00000081ff81723eULL, 0x000fe400020006ffULL, 0x000054106b687816ULL, 0x000fe40000000089ULL,
0x00005410954f7816ULL, 0x000fe4000000008eULL, 0x000054105d5d7816ULL, 0x000fe40000000090ULL,
0x000054108c5e7816ULL, 0x000fc4000000005eULL, 0x00005410915f7816ULL, 0x000fe2000000005fULL,
0x0000004e343c723cULL, 0x000fe2000000183cULL, 0x0000541065657816ULL, 0x000fe40000000094ULL,
0x000054108a677816ULL, 0x000fe40000000067ULL, 0x0000541069697816ULL, 0x000fe2000000008bULL,
0x0000005c3440723cULL, 0x000fe20000001840ULL, 0x00005410886a7816ULL, 0x000fe4000000006aULL,
0x00005410816b7816ULL, 0x000fc60000000082ULL, 0x0000005e3444723cULL, 0x000fec0000001844ULL,
0x000000643448723cULL, 0x000fec0000001848ULL, 0x000000663450723cULL, 0x000fec0000001850ULL,
0x000000683428723cULL, 0x000fec0000001828ULL, 0x0000006a3424723cULL, 0x000fec0000001824ULL,
0x0000004e2c10723cULL, 0x000fe20000001810ULL, 0x0000000862347824ULL, 0x000fc400078e0209ULL,
0x00000001ff377424ULL, 0x000fc600078e00ffULL, 0x0000005c2c14723cULL, 0x000fe20000001814ULL,
0x01a6c837343479a7ULL, 0x00026a000850003fULL, 0x0000005e2c18723cULL, 0x000fe20000001818ULL,
0x01a688377cff79a7ULL, 0x0003ea000850003fULL, 0x000000642c1c723cULL, 0x000fec000000181cULL,
0x000000662c20723cULL, 0x000fec0000001820ULL, 0x000000682c30723cULL, 0x000fec0000001830ULL,
0x0000006a2c38723cULL, 0x002fde0000001838ULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x00000000002c7805ULL, 0x000fce0000015200ULL, 0x00000035060075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000002e7805ULL, 0x000fce0000015200ULL, 0x0000002e2c377210ULL, 0x000fca0007f1e1ffULL,
0x000000012f2f7824ULL, 0x000fe200000e0e2dULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff2e7819ULL, 0x000fc8000001142fULL,
0x000000372e2e7211ULL, 0x000fca00078110ffULL, 0x000000ffff2f7224ULL, 0x000fca00000e062fULL,
0x000000022e2e7819ULL, 0x000fc8000000122fULL, 0x0000002e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x00000035060075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00008e00ff8a7b82ULL, 0x000e620000000a00ULL, 0x0000001078347824ULL, 0x000fe200078e00ffULL,
0x0000850000087ab9ULL, 0x000fe40000000800ULL, 0x000000087a7a7c24ULL, 0x010fe4000f8e02ffULL,
0xffffffe0342d7812ULL, 0x000fca00078ec0ffULL, 0x00000100582d7824ULL, 0x000fc800078e022dULL,
0x000000802d2f7836ULL, 0x000fe40000000000ULL, 0x000000807a2d7824ULL, 0x000fc600078e00ffULL,
0x000000602f2c7812ULL, 0x000fe200078ec0ffULL, 0x000000802d8a7825ULL, 0x002fc800078e008aULL,
0x00000001592e7824ULL, 0x000fe200078e022cULL, 0x0000000000f49947ULL, 0x000fec0003800000ULL,
0x0000002f742c7248ULL, 0x000fe40007fe0000ULL, 0x0000001034357812ULL, 0x000fe400078ec0ffULL,
0x00000003ff2d7819ULL, 0x000fe2000001160aULL, 0x000000012c2c7824ULL, 0x000fc800078e0a2fULL,
0x000000012d2f7824ULL, 0x100fe200078e0235ULL, 0x0000002c352c7248ULL, 0x000fe20007fe0000ULL,
0x000000042d367836ULL, 0x000fe40000000000ULL, 0x000000012f347824ULL, 0x040fe400078e020aULL,
0x000000082f5d7824ULL, 0x000fe400078e00ffULL, 0x000000012c2c7824ULL, 0x100fe400078e0a35ULL,
0x0000000136377824ULL, 0x040fe200078e0235ULL, 0xfffffff85d5d7812ULL, 0x000fe200078ee234ULL,
0x000000082d347836ULL, 0x000fe20000000000ULL, 0x0000002c3600720cULL, 0x080fe20003f66070ULL,
0x0000000c2d367836ULL, 0x000fe20000000000ULL, 0x0000002c2d00720cULL, 0x080fe20003f86070ULL,
0x000000012f2d7824ULL, 0x000fe200078e022eULL, 0x0000002c3400720cULL, 0x080fe20003f46070ULL,
0x00000001372f7824ULL, 0x040fe200078e020aULL, 0x0000002c3600720cULL, 0x000fe20003f06070ULL,
0x00000008374c7824ULL, 0x000fc400078e00ffULL, 0x000000802d2c7825ULL, 0x000fc600078e00ffULL,
0xfffffff84c5f7812ULL, 0x000fe200078ee22fULL, 0x00000001344d7824ULL, 0x100fe200078e0235ULL,
0x0000006e2c2f7212ULL, 0x000fe200078efcffULL, 0x0000000137347824ULL, 0x000fe400078e022eULL,
0x0000000136677824ULL, 0x000fe200078e0235ULL, 0x0000002f8a2c7210ULL, 0x000fe20007fbe0ffULL,
0x000000014d377824ULL, 0x040fe400078e020aULL, 0x000000084d4c7824ULL, 0x000fe400078e00ffULL,
0x0000008034347825ULL, 0x000fc600078e00ffULL, 0xfffffff84c657812ULL, 0x000fe200078ee237ULL,
0x000000014d367824ULL, 0x100fe200078e022eULL, 0x0000006e344d7212ULL, 0x000fe200078efcffULL,
0x00000001672e7824ULL, 0x000fe400078e022eULL, 0x0000008036367825ULL, 0x000fc800078e00ffULL,
0x000000802e2e7825ULL, 0x000fe200078e00ffULL, 0x0000006e364f7212ULL, 0x000fc600078efcffULL,
0x000000018b2d7824ULL, 0x000fe200028e062dULL, 0x0000004d8a347210ULL, 0x000fe20007fbe0ffULL,
0x00000001674c7824ULL, 0x040fe200078e020aULL, 0x0000006e2e4d7212ULL, 0x000fe200078efcffULL,
0x0000000867677824ULL, 0x000fe400078e00ffULL, 0x000000018b357824ULL, 0x000fe200028e0635ULL,
0x0000004f8a367210ULL, 0x000fe20007fbe0ffULL, 0x000000105f4f7824ULL, 0x100fe200078e0284ULL,
0x0000004d8a2e7210ULL, 0x000fe20007fde0ffULL, 0x000000105d4d7824ULL, 0x000fe200078e0284ULL,
0xfffffff867677812ULL, 0x000fe200078ee24cULL, 0x000000018b377824ULL, 0x000fc400028e0637ULL,
0x00000010655d7824ULL, 0x100fe200078e0284ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c4d7faeULL, 0x0003e2000e101c46ULL, 0x000000018b2f7824ULL, 0x000fe400030e062fULL,
0x00000010675f7824ULL, 0x000fe200078e0284ULL, 0x00000000344f7faeULL, 0x0003e8000d901c46ULL,
0x00000000365d7faeULL, 0x0003e8000d101c46ULL, 0x000000002e5f7faeULL, 0x0003e2000c101c46ULL,
0x0000000000c07947ULL, 0x000fea0003800000ULL, 0x00000010342d7812ULL, 0x000fc800078ec0ffULL,
0x0000002d0a2d7211ULL, 0x000fca00078fe8ffULL, 0x000000012d2c7824ULL, 0x140fe400078e020aULL,
0x000000082d5f7824ULL, 0x000fe400078e00ffULL, 0x000000042d2f7836ULL, 0x000fe40000000000ULL,
0x000000082d357836ULL, 0x000fe20000000000ULL, 0xfffffff85f5f7812ULL, 0x000fe200078ee22cULL,
0x000000012f347824ULL, 0x040fe400078e020aULL, 0x000000082f657824ULL, 0x000fc400078e00ffULL,
0x0000000135367824ULL, 0x040fe400078e020aULL, 0x0000000835677824ULL, 0x000fe200078e00ffULL,
0xfffffff865657812ULL, 0x000fe200078ee234ULL, 0x000000012d2c7824ULL, 0x000fe400078e022eULL,
0x0000000c2d377836ULL, 0x000fe20000000000ULL, 0xfffffff867677812ULL, 0x000fe200078ee236ULL,
0x000000802c2c7825ULL, 0x000fc800078e00ffULL, 0x000000012f347824ULL, 0x100fe200078e022eULL,
0x0000006e2c4d7212ULL, 0x000fe200078efcffULL, 0x0000000135367824ULL, 0x100fe400078e022eULL,
0x00000001372e7824ULL, 0x040fe200078e022eULL, 0x0000004d8a2c7210ULL, 0x000fe20007f1e0ffULL,
0x00000001374c7824ULL, 0x040fe400078e020aULL, 0x0000000837697824ULL, 0x000fe400078e00ffULL,
0x0000008034347825ULL, 0x000fc600078e00ffULL, 0xfffffff869697812ULL, 0x000fe200078ee24cULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000006e345d7212ULL, 0x000fc600078efcffULL,
0x000000802e2e7825ULL, 0x000fe200078e00ffULL, 0x0000006e364f7212ULL, 0x080fe400078efcffULL,
0x0000005d8a347210ULL, 0x000fe20007f5e0ffULL, 0x000000018b2d7824ULL, 0x000fe200000e062dULL,
0x0000006e2e4d7212ULL, 0x000fe200078efcffULL, 0x00000010675d7824ULL, 0x100fe200078e0284ULL,
0x0000004f8a367210ULL, 0x000fe20007f1e0ffULL, 0x000000018b357824ULL, 0x000fe200010e0635ULL,
0x0000004d8a2e7210ULL, 0x000fe20007f7e0ffULL, 0x000000105f4d7824ULL, 0x000fc400078e0284ULL,
0x00000010654f7824ULL, 0x100fe400078e0284ULL, 0x000000018b377824ULL, 0x040fe200000e0637ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c4d7faeULL, 0x0003e2000b901c46ULL,
0x000000018b2f7824ULL, 0x000fe400018e062fULL, 0x00000010695f7824ULL, 0x000fe200078e0284ULL,
0x00000000344f7faeULL, 0x0003e8000b901c46ULL, 0x00000000365d7faeULL, 0x0003e8000b901c46ULL,
0x000000002e5f7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000001ff2d7424ULL, 0x000fe200078e00ffULL, 0x00000000ff0079b0ULL, 0x000fe20008000a45ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000002dff8879a7ULL, 0x0002a40008500005ULL,
0x01a6282d802c79a7ULL, 0x0022e4000850003fULL, 0x00000000002e7805ULL, 0x000fce0000015200ULL,
0x01a6282d800075a7ULL, 0x008ee4000800017fULL, 0x00000000005c0947ULL, 0x008fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fce0000015200ULL,
0x000000342e377210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e2fULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff347819ULL, 0x000fc80000011435ULL, 0x0000003734347211ULL, 0x000fca00078110ffULL,
0x000000ffff357224ULL, 0x000fca00000e0635ULL, 0x0000000234347819ULL, 0x000fc80000001235ULL,
0x000000340000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x01a6282d800075a7ULL, 0x000ee4000800017fULL,
0xfffffffc00a88947ULL, 0x008fea000383ffffULL, 0x00000020782c7824ULL, 0x000fe400078e00ffULL,
0x00000001ff347424ULL, 0x000fc600078e00ffULL, 0xffffff802c2c7812ULL, 0x000fc800078ec0ffULL,
0x00000080092c7810ULL, 0x000fc80007ffe02cULL, 0x0000002c6f2c7210ULL, 0x000fca0007ffe06eULL,
0x01a000002c2e7984ULL, 0x000ee80000000800ULL, 0x01a200002c2d7984ULL, 0x0009220000000800ULL,
0x000000852e00720bULL, 0x008fda0003f1d000ULL, 0x0000000000357806ULL, 0x000fc800000e0100ULL,
0x000000ff3500720cULL, 0x000fda0003f05270ULL, 0x00000004009c8947ULL, 0x016fea0003800000ULL,
0x000000015a2f7836ULL, 0x000fe20000000000ULL, 0x000000852e00720bULL, 0x000fc80003f14000ULL,
0x000000782f00720cULL, 0x000fd20003f45270ULL, 0x0000000000347806ULL, 0x000fc800000e0100ULL,
0x00000080782fa824ULL, 0x000fe200078e0209ULL, 0x000000852e2ca209ULL, 0x000fe40007810000ULL,
0x000000ff3400720cULL, 0x000fe40003f05270ULL, 0x0000002f6f2fa210ULL, 0x000fca0007ffe06eULL,
0x01a4002c2f00a388ULL, 0x0003ec0000000800ULL, 0x0000000400548947ULL, 0x000fea0003800000ULL,
0x000000852e2c7209ULL, 0x002fe40007810000ULL, 0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL, 0x000000852c2c7221ULL, 0x000fe20000010100ULL,
0x00ff000034ff7812ULL, 0x040fe4000786c0ffULL, 0xff00000034ff7812ULL, 0x000fe2000788c0ffULL,
0x3fb8aa3b2c2c7820ULL, 0x000fc80000410000ULL, 0x0000002c00367308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fec0003800000ULL, 0x00000002ff2f7819ULL, 0x000fca000001160aULL,
0x00001f2f362c7589ULL, 0x006e6400000e0000ULL, 0x000000542c547220ULL, 0x042fe20000410000ULL,
0x000000552c557220ULL, 0x040fe20000410000ULL, 0x0000003c2c3c7220ULL, 0x040fe20000410000ULL,
0x0000003d2c3d7220ULL, 0x040fe20000410000ULL, 0x000000402c407220ULL, 0x040fe20000410000ULL,
0x000000412c417220ULL, 0x040fe20000410000ULL, 0x000000442c447220ULL, 0x040fe20000410000ULL,
0x000000452c457220ULL, 0x040fe20000410000ULL, 0x000000482c487220ULL, 0x040fe20000410000ULL,
0x000000492c497220ULL, 0x040fe20000410000ULL, 0x000000502c507220ULL, 0x040fe20000410000ULL,
0x000000512c517220ULL, 0x040fe20000410000ULL, 0x000000282c287220ULL, 0x040fe20000410000ULL,
0x000000292c297220ULL, 0x040fe20000410000ULL, 0x000000242c247220ULL, 0x040fe20000410000ULL,
0x000000252c257220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x000000080a2f7811ULL, 0x000fca00078ff0ffULL, 0x00001f2f362c7589ULL, 0x006e6400000e0000ULL,
0x000000562c567220ULL, 0x042fe20000410000ULL, 0x000000572c577220ULL, 0x040fe20000410000ULL,
0x0000003e2c3e7220ULL, 0x040fe20000410000ULL, 0x0000003f2c3f7220ULL, 0x040fe20000410000ULL,
0x000000422c427220ULL, 0x040fe20000410000ULL, 0x000000432c437220ULL, 0x040fe20000410000ULL,
0x000000462c467220ULL, 0x040fe20000410000ULL, 0x000000472c477220ULL, 0x040fe20000410000ULL,
0x0000004a2c4a7220ULL, 0x040fe20000410000ULL, 0x0000004b2c4b7220ULL, 0x040fe20000410000ULL,
0x000000522c527220ULL, 0x040fe20000410000ULL, 0x000000532c537220ULL, 0x040fe20000410000ULL,
0x0000002a2c2a7220ULL, 0x040fe20000410000ULL, 0x0000002b2c2b7220ULL, 0x040fe20000410000ULL,
0x000000262c267220ULL, 0x040fe20000410000ULL, 0x000000272c277220ULL, 0x000fce0000410000ULL,
0x000000000048b947ULL, 0x000fea0003800000ULL, 0x000000100a2f7811ULL, 0x000fca00078ff0ffULL,
0x00001f2f362c7589ULL, 0x006e6400000e0000ULL, 0x0000000c2c0c7220ULL, 0x042fe20000410000ULL,
0x0000000d2c0d7220ULL, 0x040fe20000410000ULL, 0x000000102c107220ULL, 0x040fe20000410000ULL,
0x000000112c117220ULL, 0x040fe20000410000ULL, 0x000000142c147220ULL, 0x040fe20000410000ULL,
0x000000152c157220ULL, 0x040fe20000410000ULL, 0x000000182c187220ULL, 0x040fe20000410000ULL,
0x000000192c197220ULL, 0x040fe20000410000ULL, 0x0000001c2c1c7220ULL, 0x040fe20000410000ULL,
0x0000001d2c1d7220ULL, 0x040fe20000410000ULL, 0x000000202c207220ULL, 0x040fe20000410000ULL,
0x000000212c217220ULL, 0x040fe20000410000ULL, 0x000000302c307220ULL, 0x040fe20000410000ULL,
0x000000312c317220ULL, 0x040fe20000410000ULL, 0x000000382c387220ULL, 0x040fe20000410000ULL,
0x000000392c397220ULL, 0x000fce0000410000ULL, 0x0000003683837220ULL, 0x004fe20000410000ULL,
0x000000000048c947ULL, 0x000fec0003800000ULL, 0x000000180a2f7811ULL, 0x000fca00078ff0ffULL,
0x00001f2f362c7589ULL, 0x002e6400000e0000ULL, 0x0000000e2c0e7220ULL, 0x042fe20000410000ULL,
0x0000000f2c0f7220ULL, 0x040fe20000410000ULL, 0x000000122c127220ULL, 0x040fe20000410000ULL,
0x000000132c137220ULL, 0x040fe20000410000ULL, 0x000000162c167220ULL, 0x040fe20000410000ULL,
0x000000172c177220ULL, 0x040fe20000410000ULL, 0x0000001a2c1a7220ULL, 0x040fe20000410000ULL,
0x0000001b2c1b7220ULL, 0x040fe20000410000ULL, 0x0000001e2c1e7220ULL, 0x040fe20000410000ULL,
0x0000001f2c1f7220ULL, 0x040fe20000410000ULL, 0x000000222c227220ULL, 0x040fe20000410000ULL,
0x000000232c237220ULL, 0x040fe20000410000ULL, 0x000000322c327220ULL, 0x040fe20000410000ULL,
0x000000332c337220ULL, 0x040fe20000410000ULL, 0x0000003a2c3a7220ULL, 0x040fe20000410000ULL,
0x0000003b2c3b7220ULL, 0x000fce0000410000ULL, 0x0000003435ff7212ULL, 0x000fe200078030ffULL,
0x00000001ff347424ULL, 0x000fe200078e00ffULL, 0x000000852e857209ULL, 0x000fd60007810000ULL,
0x800000852e2e0221ULL, 0x000fe20000010000ULL, 0x00007610ff340816ULL, 0x000fc60000000034ULL,
0x3fb8aa3b2e2e0820ULL, 0x000fc80000410000ULL, 0x0000002e00040308ULL, 0x000ea40000000800ULL,
0x000000042d2d0220ULL, 0x004fce0000410000ULL, 0x000000832d837221ULL, 0x000fe20000010000ULL,
0x00000000002c7805ULL, 0x002fe20000015200ULL, 0x00000008782e7824ULL, 0x000fca00078e00ffULL,
0xfffffff02e2e7812ULL, 0x000fca00078ec0ffULL, 0x0000000109377824ULL, 0x000fc800078e022eULL,
0x01a6b087370075a7ULL, 0x000ea4000800017fULL, 0x00000000005c0947ULL, 0x006fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000002e7805ULL, 0x000fcc0000015200ULL,
0x0000002e2c357210ULL, 0x000fca0007f1e1ffULL, 0x000000012f2f7824ULL, 0x000fe200000e0e2dULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff2e7819ULL, 0x000fc8000001142fULL, 0x000000352e2e7211ULL, 0x000fca00078110ffULL,
0x000000ffff2f7224ULL, 0x000fca00000e062fULL, 0x000000022e2e7819ULL, 0x000fc8000000122fULL,
0x0000002e0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x01a6b087370075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00009910342c7816ULL, 0x000fe200000000ffULL,
0x00000400782d7824ULL, 0x040fe400078e00ffULL, 0x00001000782e7824ULL, 0x000fe200078e00ffULL,
0x000000ff2c00720cULL, 0x000fe40003f05270ULL, 0xfffff0002d7c7812ULL, 0x000fe400078ec0ffULL,
0xffffe0002e2e7812ULL, 0x000fe400078ec0ffULL, 0x00013000097c7810ULL, 0x000fc40007ffe07cULL,
0x00017000095c7810ULL, 0x000fc60007ffe02eULL, 0x000000107f347824ULL, 0x100fe400078e027cULL,
0x000000107e2c7824ULL, 0x000fe400078e027cULL, 0x000000106d4c7824ULL, 0x000fe200078e025cULL,
0x0000000000280947ULL, 0x000fec0003800000ULL, 0x00000002ff2e7819ULL, 0x000fe4000001160aULL,
0x00000004ff00723eULL, 0x000fc600000000ffULL, 0x000000082e027836ULL, 0x000fe20000000000ULL,
0x00005410002d7816ULL, 0x000fe20000000000ULL, 0x000000102e367836ULL, 0x000fe40000000000ULL,
0x000000182e4e7836ULL, 0x000fe40000000000ULL, 0x00001f022d027589ULL, 0x0002a800000e0000ULL,
0x00001f362d057589ULL, 0x0002e800000e0000ULL, 0x00001f2e2d037589ULL, 0x00026800000e0000ULL,
0x00001f4e2d007589ULL, 0x00026400000e0000ULL, 0x000000003434783bULL, 0x002e680000000200ULL,
0x000000002c2c783bULL, 0x000ee20000000200ULL, 0x0000000000200947ULL, 0x000fea0003800000ULL,
0x0000000334347232ULL, 0x082fe40000000000ULL, 0x0000000336367232ULL, 0x000fe40000000000ULL,
0x0000000235357232ULL, 0x084fe40000000000ULL, 0x0000000237377232ULL, 0x000fe40000000000ULL,
0x000000052c2c7232ULL, 0x088fe40000000000ULL, 0x000000052e2e7232ULL, 0x000fc40000000000ULL,
0x000000002d2d7232ULL, 0x080fe40000000000ULL, 0x000000002f2f7232ULL, 0x000fce0000000000ULL,
0x000000107b5c7824ULL, 0x000fe200078e025cULL, 0x000000004c4c783bULL, 0x000f2a0000004200ULL,
0x000000005c5c783bULL, 0x000f620000004200ULL, 0x00000018ff677819ULL, 0x010fe4000001164fULL,
0x00000010ff957819ULL, 0x000fe4000001164dULL, 0x000000ff4d937812ULL, 0x000fc400078ec0ffULL,
0x00000018ff6b7819ULL, 0x028fe4000001165dULL, 0x000000ff5e987812ULL, 0x000fe400078ec0ffULL,
0x00000010ff647819ULL, 0x100fe4000001165fULL, 0x000000ff5f997812ULL, 0x040fe400078ec0ffULL,
0x00000018ff687819ULL, 0x000fe4000001165fULL, 0x0000ffff5f7a7812ULL, 0x000fc400078ec0ffULL,
0x00000067ff5f723eULL, 0x000fe400020006ffULL, 0x00000018ff8e7819ULL, 0x000fe4000001164dULL,
0x00000018ff657819ULL, 0x000fe4000001164eULL, 0x0000006bff67723eULL, 0x000fe400020006ffULL,
0x00000010ff947819ULL, 0x000fe4000001164cULL, 0x0000ffff4d4d7812ULL, 0x000fc400078ec0ffULL,
0x000000ff5d977812ULL, 0x000fe400078ec0ffULL, 0x00000098ff6b723eULL, 0x000fe400020006ffULL,
0x0000ffff4c6a7812ULL, 0x000fe400078ec0ffULL, 0x000000ff95987812ULL, 0x000fe400078ec0ffULL,
0x00000010ff877819ULL, 0x100fe4000001165eULL, 0x00000018ff967819ULL, 0x000fc4000001165eULL,
0x0000ffff5e667812ULL, 0x000fe400078ec0ffULL, 0x00000065ff5e723eULL, 0x000fe400020006ffULL,
0x00000097ff65723eULL, 0x000fe400020006ffULL, 0x000000ff94947812ULL, 0x000fe400078ec0ffULL,
0x00000008ff4d7819ULL, 0x000fe4000001164dULL, 0x00000018ff8f7819ULL, 0x000fc4000001164cULL,
0x00000010ff8d7819ULL, 0x000fe4000001164eULL, 0x000000ff4e8c7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff4e917812ULL, 0x000fe400078ec0ffULL, 0x00000093ff93723eULL, 0x000fe400020006ffULL,
0x00000008ff977819ULL, 0x000fe4000001166aULL, 0x00000098ff98723eULL, 0x000fc400020006ffULL,
0x00000010ff4e7819ULL, 0x000fe4000001165cULL, 0x00000096ff6a723eULL, 0x000fe400020006ffULL,
0x00000094ff95723eULL, 0x000fe400020006ffULL, 0x0000004dff96723eULL, 0x000fe400020006ffULL,
0x0000008fff8f723eULL, 0x000fe400020006ffULL, 0x00000097ff94723eULL, 0x000fc400020006ffULL,
0x000000ff8d8d7812ULL, 0x000fe400078ec0ffULL, 0x00005410934d7816ULL, 0x000fe40000000098ULL,
0x000000ff5c827812ULL, 0x000fe400078ec0ffULL, 0x00000018ff817819ULL, 0x000fe4000001165cULL,
0x000000ff4e937812ULL, 0x000fe400078ec0ffULL, 0x000000ff4c927812ULL, 0x000fc400078ec0ffULL,
0x0000ffff5c5c7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff977819ULL, 0x000fe40000011691ULL,
0x0000008cff8c723eULL, 0x000fe400020006ffULL, 0x0000008dff91723eULL, 0x000fe400020006ffULL,
0x00005410944e7816ULL, 0x000fe4000000008fULL, 0x0000ffff4f4c7812ULL, 0x000fc400078ec0ffULL,
0x00000093ff8f723eULL, 0x000fe400020006ffULL, 0x00000010ff907819ULL, 0x000fe4000001164fULL,
0x000000ff4f697812ULL, 0x000fe400078ec0ffULL, 0x00000092ff92723eULL, 0x000fe400020006ffULL,
0x00000082ff82723eULL, 0x000fe400020006ffULL, 0x00000008ff937819ULL, 0x000fc4000001165cULL,
0x00000010ff4f7819ULL, 0x000fe4000001165dULL, 0x0000ffff5d867812ULL, 0x000fe400078ec0ffULL,
0x00000097ff8d723eULL, 0x000fe400020006ffULL, 0x000054108c5c7816ULL, 0x000fe40000000091ULL,
0x00000008ff977819ULL, 0x000fe4000001164cULL, 0x000000ff648c7812ULL, 0x000fc400078ec0ffULL,
0x0000008eff8e723eULL, 0x000fe400020006ffULL, 0x00000081ff81723eULL, 0x000fe400020006ffULL,
0x00005410924c7816ULL, 0x000fe40000000095ULL, 0x00000093ff93723eULL, 0x000fe400020006ffULL,
0x000000ff87877812ULL, 0x000fe400078ec0ffULL, 0x0000541082647816ULL, 0x000fe2000000008fULL,
0x0000004c3454723cULL, 0x002fe20000001854ULL, 0x000000ff90907812ULL, 0x000fc400078ec0ffULL,
0x000000ff4f957812ULL, 0x000fe400078ec0ffULL, 0x00000008ff867819ULL, 0x000fe20000011686ULL,
0x0000004c2c0c723cULL, 0x000fe2000000180cULL, 0x00000008ff827819ULL, 0x000fe40000011666ULL,
0x00000008ff7a7819ULL, 0x000fe4000001167aULL, 0x00000069ff5d723eULL, 0x000fe400020006ffULL,
0x00005410964f7816ULL, 0x000fe2000000008eULL, 0x00000010714c7824ULL, 0x000fe200078e027cULL,
0x00000087ff87723eULL, 0x000fc400020006ffULL, 0x0000541093667816ULL, 0x000fe40000000081ULL,
0x00000099ff69723eULL, 0x000fe200020006ffULL, 0x0000004e343c723cULL, 0x000fe2000000183cULL,
0x00000090ff90723eULL, 0x000fe400020006ffULL, 0x00000097ff92723eULL, 0x000fe400020006ffULL,
0x00000095ff8e723eULL, 0x000fe200020006ffULL, 0x0000004e2c10723cULL, 0x000fe20000001810ULL,
0x00000086ff86723eULL, 0x000fc400020006ffULL, 0x0000008cff8c723eULL, 0x000fe400020006ffULL,
0x00000068ff81723eULL, 0x000fe400020006ffULL, 0x00000082ff82723eULL, 0x000fe400020006ffULL,
0x0000007aff7a723eULL, 0x000fe400020006ffULL, 0x000054106b687816ULL, 0x000fe40000000087ULL,
0x000054105d5d7816ULL, 0x000fc40000000090ULL, 0x000054108d5e7816ULL, 0x000fe4000000005eULL,
0x00005410925f7816ULL, 0x000fe4000000005fULL, 0x0000541065657816ULL, 0x000fe2000000008eULL,
0x0000005c3440723cULL, 0x000fe20000001840ULL, 0x0000541086677816ULL, 0x000fe40000000067ULL,
0x0000541069697816ULL, 0x000fe4000000008cULL, 0x00005410826a7816ULL, 0x000fe2000000006aULL,
0x0000005e3444723cULL, 0x000fe20000001844ULL, 0x000054107a6b7816ULL, 0x000fe20000000081ULL,
0x00017000727a7836ULL, 0x000fc80000000000ULL, 0x000000643448723cULL, 0x000fec0000001848ULL,
0x000000663450723cULL, 0x000fec0000001850ULL, 0x000000683428723cULL, 0x000fec0000001828ULL,
0x0000006a3424723cULL, 0x000fec0000001824ULL, 0x0000005c2c14723cULL, 0x000fe20000001814ULL,
0x0000001070347824ULL, 0x000fc400078e027cULL, 0x000000107d7c7824ULL, 0x000fc600078e027aULL,
0x0000005e2c18723cULL, 0x000fe20000001818ULL, 0x000000003434783bULL, 0x000e6a0000000200ULL,
0x000000642c1c723cULL, 0x000fec000000181cULL, 0x000000662c20723cULL, 0x000fec0000001820ULL,
0x000000682c30723cULL, 0x000fec0000001830ULL, 0x0000006a2c38723cULL, 0x000fe20000001838ULL,
0x000000004c2c783bULL, 0x0006a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000200947ULL, 0x000fde0003800000ULL, 0x0000000334347232ULL, 0x082fe40000000000ULL,
0x0000000336367232ULL, 0x000fe40000000000ULL, 0x0000000235357232ULL, 0x084fe40000000000ULL,
0x0000000237377232ULL, 0x000fe40000000000ULL, 0x000000052c2c7232ULL, 0x080fe40000000000ULL,
0x000000052e2e7232ULL, 0x000fc40000000000ULL, 0x000000002d2d7232ULL, 0x080fe40000000000ULL,
0x000000002f2f7232ULL, 0x000fce0000000000ULL, 0x00000010735c7824ULL, 0x000fe200078e027aULL,
0x000000007c4c783bULL, 0x008eea0000004200ULL, 0x000000005c5c783bULL, 0x000f220000004200ULL,
0x00000018ff657819ULL, 0x008fe4000001164eULL, 0x00000010ff957819ULL, 0x000fe4000001164cULL,
0x00000018ff677819ULL, 0x000fc4000001164fULL, 0x000000ff5d987812ULL, 0x010fe400078ec0ffULL,
0x0000ffff4c6a7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff6b7819ULL, 0x000fe4000001165dULL,
0x00000010ff8c7819ULL, 0x100fe4000001165eULL, 0x000000ff5e997812ULL, 0x000fe400078ec0ffULL,
0x00000018ff977819ULL, 0x000fc4000001165eULL, 0x0000ffff5e667812ULL, 0x000fe400078ec0ffULL,
0x00000010ff967819ULL, 0x000fe4000001164dULL, 0x00000010ff647819ULL, 0x100fe4000001165fULL,
0x000000ff5f9a7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff687819ULL, 0x000fe4000001165fULL,
0x0000ffff5f817812ULL, 0x000fc400078ec0ffULL, 0x00000065ff5e723eULL, 0x000fe400020006ffULL,
0x00000067ff5f723eULL, 0x000fe400020006ffULL, 0x00000098ff65723eULL, 0x000fe400020006ffULL,
0x000000ff95957812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8e7819ULL, 0x000fe4000001164eULL,
0x0000006bff67723eULL, 0x000fc400020006ffULL, 0x00000008ff987819ULL, 0x000fe4000001166aULL,
0x0000ffff4e927812ULL, 0x000fe400078ec0ffULL, 0x00000099ff6b723eULL, 0x000fe400020006ffULL,
0x000000ff4d937812ULL, 0x000fe400078ec0ffULL, 0x00000018ff8f7819ULL, 0x000fe4000001164dULL,
0x000000ff96997812ULL, 0x000fc400078ec0ffULL, 0x000000ff4c947812ULL, 0x000fe400078ec0ffULL,
0x0000ffff4d4d7812ULL, 0x000fe400078ec0ffULL, 0x00000095ff96723eULL, 0x000fe400020006ffULL,
0x00000098ff95723eULL, 0x000fe400020006ffULL, 0x000000ff8e8e7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff907819ULL, 0x000fc4000001164cULL, 0x00000008ff987819ULL, 0x000fe40000011692ULL,
0x0000ffff4f4c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff4e8d7812ULL, 0x000fe400078ec0ffULL,
0x00000094ff94723eULL, 0x000fe400020006ffULL, 0x00000008ff4d7819ULL, 0x000fe4000001164dULL,
0x00000010ff4e7819ULL, 0x000fc4000001165cULL, 0x0000008eff92723eULL, 0x000fe400020006ffULL,
0x00000010ff917819ULL, 0x000fe4000001164fULL, 0x000000ff4f697812ULL, 0x000fe400078ec0ffULL,
0x00000098ff8e723eULL, 0x000fe400020006ffULL, 0x00000010ff4f7819ULL, 0x000fe4000001165dULL,
0x00000097ff6a723eULL, 0x000fc400020006ffULL, 0x00000008ff987819ULL, 0x000fe4000001164cULL,
0x0000008fff8f723eULL, 0x000fe400020006ffULL, 0x0000004dff97723eULL, 0x000fe400020006ffULL,
0x00005410944c7816ULL, 0x000fe40000000096ULL, 0x000000ff5c867812ULL, 0x000fe400078ec0ffULL,
0x00000018ff827819ULL, 0x000fc4000001165cULL, 0x000000ff4e947812ULL, 0x000fe400078ec0ffULL,
0x0000ffff5c5c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff4f967812ULL, 0x000fe400078ec0ffULL,
0x0000008dff8d723eULL, 0x000fe400020006ffULL, 0x00005410974f7816ULL, 0x000fe4000000008fULL,
0x00000094ff8f723eULL, 0x000fc400020006ffULL, 0x00000086ff86723eULL, 0x000fe400020006ffULL,
0x00000008ff947819ULL, 0x000fe4000001165cULL, 0x0000ffff5d877812ULL, 0x000fe400078ec0ffULL,
0x000054108d5c7816ULL, 0x000fe40000000092ULL, 0x000000ff648d7812ULL, 0x000fe400078ec0ffULL,
0x00000093ff93723eULL, 0x000fc400020006ffULL, 0x00000090ff90723eULL, 0x000fe400020006ffULL,
0x00000082ff82723eULL, 0x000fe400020006ffULL, 0x00000099ff99723eULL, 0x000fe400020006ffULL,
0x00000094ff94723eULL, 0x000fe400020006ffULL, 0x000000ff8c8c7812ULL, 0x000fe400078ec0ffULL,
0x0000541086647816ULL, 0x000fc4000000008fULL, 0x000000ff91917812ULL, 0x000fe400078ec0ffULL,
0x00000008ff877819ULL, 0x000fe40000011687ULL, 0x00000008ff867819ULL, 0x000fe40000011666ULL,
0x00000008ff817819ULL, 0x000fe40000011681ULL, 0x00000069ff5d723eULL, 0x000fe400020006ffULL,
0x00005410934d7816ULL, 0x000fc40000000099ULL, 0x00005410954e7816ULL, 0x000fe40000000090ULL,
0x0000008cff8c723eULL, 0x000fe400020006ffULL, 0x0000541094667816ULL, 0x000fe20000000082ULL,
0x0000004c3454723cULL, 0x002fe20000001854ULL, 0x0000009aff69723eULL, 0x000fe400020006ffULL,
0x00000091ff91723eULL, 0x000fe400020006ffULL, 0x00000098ff93723eULL, 0x000fe200020006ffULL,
0x0000004e343c723cULL, 0x000fe2000000183cULL, 0x00000096ff90723eULL, 0x000fc400020006ffULL,
0x00000087ff87723eULL, 0x000fe400020006ffULL, 0x0000008dff8d723eULL, 0x000fe200020006ffULL,
0x0000004c2c0c723cULL, 0x004fe2000000180cULL, 0x00000068ff82723eULL, 0x000fe400020006ffULL,
0x00000086ff86723eULL, 0x000fe400020006ffULL, 0x00000081ff81723eULL, 0x000fe200020006ffULL,
0x0000004e2c10723cULL, 0x000fe20000001810ULL, 0x000054106b687816ULL, 0x000fc4000000008cULL,
0x000054105d5d7816ULL, 0x000fe40000000091ULL, 0x000054108e5e7816ULL, 0x000fe4000000005eULL,
0x00005410935f7816ULL, 0x000fe4000000005fULL, 0x0000541065657816ULL, 0x000fe20000000090ULL,
0x0000005c3440723cULL, 0x000fe20000001840ULL, 0x0000541087677816ULL, 0x000fe40000000067ULL,
0x0000541069697816ULL, 0x000fc4000000008dULL, 0x00005410866a7816ULL, 0x000fe2000000006aULL,
0x0000005e3444723cULL, 0x000fe20000001844ULL, 0x00005410816b7816ULL, 0x000fca0000000082ULL,
0x000000643448723cULL, 0x000fec0000001848ULL, 0x000000663450723cULL, 0x000fec0000001850ULL,
0x000000683428723cULL, 0x000fec0000001828ULL, 0x0000006a3424723cULL, 0x000fec0000001824ULL,
0x0000005c2c14723cULL, 0x000fe20000001814ULL, 0x0000000278347824ULL, 0x000fc400078e00ffULL,
0x00000001ff377424ULL, 0x000fc600078e00ffULL, 0xfffffff834367812ULL, 0x000fe200078ec0ffULL,
0x0000000862347824ULL, 0x000fe200078e0209ULL, 0x0000005e2c18723cULL, 0x000fe60000001818ULL,
0x0000000109367824ULL, 0x000fe400078e0236ULL, 0x01a6c837343479a7ULL, 0x0002a2000850003fULL,
0x000000642c1c723cULL, 0x000fec000000181cULL, 0x000000662c20723cULL, 0x000fe20000001820ULL,
0x01a6903736ff79a7ULL, 0x0003ea000850003fULL, 0x000000682c30723cULL, 0x000fec0000001830ULL,
0x0000006a2c38723cULL, 0x002fde0000001838ULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x00000000002c7805ULL, 0x000fe20000015200ULL, 0x00000035060075a7ULL, 0x004e64000800017fULL,
0x00000000005c0947ULL, 0x006fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000002e7805ULL, 0x000fcc0000015200ULL, 0x0000002e2c377210ULL, 0x000fca0007f1e1ffULL,
0x000000012f2f7824ULL, 0x000fe200000e0e2dULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff2e7819ULL, 0x000fc8000001142fULL,
0x000000372e2e7211ULL, 0x000fca00078110ffULL, 0x000000ffff2f7224ULL, 0x000fca00000e062fULL,
0x000000022e2e7819ULL, 0x000fc8000000122fULL, 0x0000002e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x00000035060075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000010058817824ULL, 0x000fc800078e025bULL, 0x000000c0812d7836ULL, 0x000fca0000000000ULL,
0x000000602d2c7812ULL, 0x000fca00078ec0ffULL, 0x00000001594c7824ULL, 0x000fe200078e022cULL,
0x0000000000f89947ULL, 0x000fec0003800000ULL, 0x0000002d742c7248ULL, 0x000fe20007fe0000ULL,
0x00000010782e7824ULL, 0x000fc800078e00ffULL, 0x000000012c2c7824ULL, 0x000fe200078e0a2dULL,
0x000000102e2f7812ULL, 0x000fe400078ec0ffULL, 0x00000003ff2d7819ULL, 0x000fe4000001160aULL,
0x0000002c2f2c7248ULL, 0x000fc60007fe0000ULL, 0x000000012d357824ULL, 0x140fe400078e022fULL,
0x000000012c2c7824ULL, 0x100fe400078e0a2fULL, 0x000000042d2e7836ULL, 0x000fe40000000000ULL,
0x000000082d347836ULL, 0x000fe20000000000ULL, 0x0000002c2d00720cULL, 0x080fe20003f86070ULL,
0x0000000c2d367836ULL, 0x000fe20000000000ULL, 0x0000002c2e00720cULL, 0x080fe20003f66070ULL,
0x00000001352d7824ULL, 0x000fe200078e024cULL, 0x0000002c3400720cULL, 0x080fe20003f46070ULL,
0x000000012e377824ULL, 0x000fe200078e022fULL, 0x0000002c3600720cULL, 0x000fe20003f06070ULL,
0x000000802d2c7825ULL, 0x000fc800078e00ffULL, 0x00000001344d7824ULL, 0x100fe400078e022fULL,
0x0000000136677824ULL, 0x000fe200078e022fULL, 0x0000006e2c2f7212ULL, 0x000fe200078efcffULL,
0x00000001352e7824ULL, 0x140fe400078e020aULL, 0x00000008355d7824ULL, 0x000fe200078e00ffULL,
0x0000002f8a2c7210ULL, 0x000fe20007fbe0ffULL, 0x0000000137347824ULL, 0x040fe400078e020aULL,
0x00000008375f7824ULL, 0x040fe200078e00ffULL, 0xfffffff85d5d7812ULL, 0x000fe200078ee22eULL,
0x0000000137367824ULL, 0x000fc400078e024cULL, 0x000000014d357824ULL, 0x040fe200078e020aULL,
0xfffffff85f5f7812ULL, 0x000fe200078ee234ULL, 0x000000084d4e7824ULL, 0x000fe400078e00ffULL,
0x0000008036367825ULL, 0x000fc600078e00ffULL, 0xfffffff84e657812ULL, 0x000fe200078ee235ULL,
0x000000014d2e7824ULL, 0x100fe200078e024cULL, 0x0000006e364d7212ULL, 0x000fe200078efcffULL,
0x0000000167347824ULL, 0x000fe400078e024cULL, 0x000000802e2e7825ULL, 0x000fc800078e00ffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000006e2e4f7212ULL, 0x000fc600078efcffULL,
0x000000018b2d7824ULL, 0x000fe200028e062dULL, 0x0000004d8a367210ULL, 0x000fe20007fbe0ffULL,
0x00000001674c7824ULL, 0x040fe200078e020aULL, 0x0000006e344d7212ULL, 0x000fe200078efcffULL,
0x0000000867677824ULL, 0x000fe400078e00ffULL, 0x000000018b377824ULL, 0x000fe200028e0637ULL,
0x0000004f8a2e7210ULL, 0x000fe20007fbe0ffULL, 0x000000105d5d7824ULL, 0x100fe200078e027aULL,
0x0000004d8a347210ULL, 0x000fe20007fde0ffULL, 0x000000105f5f7824ULL, 0x100fe200078e027aULL,
0xfffffff8674d7812ULL, 0x000fe200078ee24cULL, 0x000000018b2f7824ULL, 0x000fe200028e062fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c5d7faeULL, 0x0003e2000e101c46ULL,
0x0000001065657824ULL, 0x000fc400078e027aULL, 0x000000018b357824ULL, 0x000fe200030e0635ULL,
0x00000000365f7faeULL, 0x0003e2000d901c46ULL, 0x000000104d4d7824ULL, 0x000fc600078e027aULL,
0x000000002e657faeULL, 0x0003e8000d101c46ULL, 0x00000000344d7faeULL, 0x0003e2000c101c46ULL,
0x0000000000c47947ULL, 0x000fea0003800000ULL, 0x00000010782c7824ULL, 0x000fca00078e00ffULL,
0x000000102c2d7812ULL, 0x000fc800078ec0ffULL, 0x0000002d0a2d7211ULL, 0x000fca00078fe8ffULL,
0x000000082d357836ULL, 0x000fe40000000000ULL, 0x000000042d2f7836ULL, 0x000fe40000000000ULL,
0x000000012d2c7824ULL, 0x140fe400078e020aULL, 0x000000082d5f7824ULL, 0x000fe400078e00ffULL,
0x0000000135367824ULL, 0x040fe400078e020aULL, 0x0000000835677824ULL, 0x000fe200078e00ffULL,
0xfffffff85f5f7812ULL, 0x000fe200078ee22cULL, 0x000000012d347824ULL, 0x000fc400078e024cULL,
0x000000012f2e7824ULL, 0x040fe200078e020aULL, 0xfffffff867677812ULL, 0x000fe200078ee236ULL,
0x000000082f657824ULL, 0x000fe400078e00ffULL, 0x0000000c2d2d7836ULL, 0x000fe40000000000ULL,
0x00000001352c7824ULL, 0x000fe200078e024cULL, 0xfffffff865657812ULL, 0x000fe200078ee22eULL,
0x0000008034347825ULL, 0x000fc800078e00ffULL, 0x000000012f367824ULL, 0x100fe200078e024cULL,
0x0000006e344d7212ULL, 0x000fe200078efcffULL, 0x000000012d2e7824ULL, 0x040fe400078e024cULL,
0x000000012d4c7824ULL, 0x040fe200078e020aULL, 0x0000004d8a347210ULL, 0x000fe20007f1e0ffULL,
0x000000082d697824ULL, 0x000fe400078e00ffULL, 0x0000008036367825ULL, 0x000fc600078e00ffULL,
0xfffffff869697812ULL, 0x000fe200078ee24cULL, 0x000000802c2c7825ULL, 0x000fe200078e00ffULL,
0x0000006e365d7212ULL, 0x000fc600078efcffULL, 0x000000802e2e7825ULL, 0x000fe200078e00ffULL,
0x0000006e2c4f7212ULL, 0x080fe400078efcffULL, 0x0000005d8a367210ULL, 0x000fe20007f5e0ffULL,
0x000000018b357824ULL, 0x000fe200000e0635ULL, 0x0000006e2e4d7212ULL, 0x000fe200078efcffULL,
0x000000105f5f7824ULL, 0x100fe200078e027aULL, 0x0000004f8a2c7210ULL, 0x000fe20007f1e0ffULL,
0x000000018b377824ULL, 0x000fe200010e0637ULL, 0x0000004d8a2e7210ULL, 0x000fe20007f7e0ffULL,
0x0000001065657824ULL, 0x000fe200078e027aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000345f7faeULL, 0x0003e2000b901c46ULL, 0x000000018b2d7824ULL, 0x000fc400000e062dULL,
0x0000001067677824ULL, 0x100fe200078e027aULL, 0x0000000036657faeULL, 0x0003e2000b901c46ULL,
0x000000018b2f7824ULL, 0x000fe400018e062fULL, 0x0000001069697824ULL, 0x000fe200078e027aULL,
0x000000002c677faeULL, 0x0003e8000b901c46ULL, 0x000000002e697faeULL, 0x0003e4000b901c46ULL,
0x0000000260607836ULL, 0x000fe20000000000ULL, 0x0000000804087890ULL, 0x000fe2000fffe03fULL,
0xffffffffff827424ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x002fe40000000000ULL,
0x000000636000720cULL, 0x000fca0003f06070ULL, 0x00000000ff0079b0ULL, 0x000ff00008000a48ULL,
0x00009000ff2c8b82ULL, 0x000e620000000a00ULL, 0x00000001602f8824ULL, 0x000fe400078e0207ULL,
0x00000008782e7824ULL, 0x000fc400078e00ffULL, 0x000000042f2c8825ULL, 0x002fca00078e002cULL,
0x000000062c828981ULL, 0x000322000c1e1900ULL, 0xfffffff02e2e7812ULL, 0x000fe200078ec0ffULL,
0x00000001ff2f7424ULL, 0x000fc600078e00ffULL, 0x0001a6a82e867810ULL, 0x000fe20007ffe009ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000082f868679a7ULL, 0x0004e2000850003fULL,
0x01a6482f802c79a7ULL, 0x002464000850003fULL, 0x00000000002e7805ULL, 0x004fce0000015200ULL,
0x01a6482d800075a7ULL, 0x002e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fce0000015200ULL,
0x000000342e377210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e2fULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff347819ULL, 0x000fc80000011435ULL, 0x0000003734347211ULL, 0x000fca00078110ffULL,
0x000000ffff357224ULL, 0x000fca00000e0635ULL, 0x0000000234347819ULL, 0x000fc80000001235ULL,
0x000000340000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x01a6482d800075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00000020782c7824ULL, 0x000fe400078e00ffULL,
0x00000001ff347424ULL, 0x000fc600078e00ffULL, 0xffffff802c2c7812ULL, 0x000fc800078ec0ffULL,
0x00000100092c7810ULL, 0x000fc80007ffe02cULL, 0x0000002c6f2c7210ULL, 0x000fca0007ffe06eULL,
0x01a000002c2e7984ULL, 0x000e680000000800ULL, 0x01a200002c2d7984ULL, 0x0004a20000000800ULL,
0x000000852e00720bULL, 0x002fda0003f1d000ULL, 0x0000000000357806ULL, 0x000fc800000e0100ULL,
0x000000ff3500720cULL, 0x000fda0003f05270ULL, 0x00000004009c8947ULL, 0x00cfea0003800000ULL,
0x000000025a2f7836ULL, 0x000fe20000000000ULL, 0x000000852e00720bULL, 0x000fc80003f14000ULL,
0x000000782f00720cULL, 0x000fd20003f45270ULL, 0x0000000000347806ULL, 0x000fc800000e0100ULL,
0x00000080782fa824ULL, 0x000fe200078e0209ULL, 0x000000852e2ca209ULL, 0x000fe40007810000ULL,
0x000000ff3400720cULL, 0x000fe40003f05270ULL, 0x0000002f6f2fa210ULL, 0x000fca0007ffe06eULL,
0x01a4002c2f00a388ULL, 0x0003ec0000000800ULL, 0x0000000400548947ULL, 0x000fea0003800000ULL,
0x000000852e2c7209ULL, 0x002fe40007810000ULL, 0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL, 0x000000852c2c7221ULL, 0x000fe20000010100ULL,
0x00ff000034ff7812ULL, 0x040fe4000786c0ffULL, 0xff00000034ff7812ULL, 0x000fe2000788c0ffULL,
0x3fb8aa3b2c2c7820ULL, 0x000fc80000410000ULL, 0x0000002c00367308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fec0003800000ULL, 0x00000002ff2f7819ULL, 0x000fca000001160aULL,
0x00001f2f362c7589ULL, 0x006e6400000e0000ULL, 0x000000542c547220ULL, 0x042fe20000410000ULL,
0x000000552c557220ULL, 0x040fe20000410000ULL, 0x0000003c2c3c7220ULL, 0x040fe20000410000ULL,
0x0000003d2c3d7220ULL, 0x040fe20000410000ULL, 0x000000402c407220ULL, 0x040fe20000410000ULL,
0x000000412c417220ULL, 0x040fe20000410000ULL, 0x000000442c447220ULL, 0x040fe20000410000ULL,
0x000000452c457220ULL, 0x040fe20000410000ULL, 0x000000482c487220ULL, 0x040fe20000410000ULL,
0x000000492c497220ULL, 0x040fe20000410000ULL, 0x000000502c507220ULL, 0x040fe20000410000ULL,
0x000000512c517220ULL, 0x040fe20000410000ULL, 0x000000282c287220ULL, 0x040fe20000410000ULL,
0x000000292c297220ULL, 0x040fe20000410000ULL, 0x000000242c247220ULL, 0x040fe20000410000ULL,
0x000000252c257220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x000000080a2f7811ULL, 0x000fca00078ff0ffULL, 0x00001f2f362c7589ULL, 0x006e6400000e0000ULL,
0x000000562c567220ULL, 0x042fe20000410000ULL, 0x000000572c577220ULL, 0x040fe20000410000ULL,
0x0000003e2c3e7220ULL, 0x040fe20000410000ULL, 0x0000003f2c3f7220ULL, 0x040fe20000410000ULL,
0x000000422c427220ULL, 0x040fe20000410000ULL, 0x000000432c437220ULL, 0x040fe20000410000ULL,
0x000000462c467220ULL, 0x040fe20000410000ULL, 0x000000472c477220ULL, 0x040fe20000410000ULL,
0x0000004a2c4a7220ULL, 0x040fe20000410000ULL, 0x0000004b2c4b7220ULL, 0x040fe20000410000ULL,
0x000000522c527220ULL, 0x040fe20000410000ULL, 0x000000532c537220ULL, 0x040fe20000410000ULL,
0x0000002a2c2a7220ULL, 0x040fe20000410000ULL, 0x0000002b2c2b7220ULL, 0x040fe20000410000ULL,
0x000000262c267220ULL, 0x040fe20000410000ULL, 0x000000272c277220ULL, 0x000fce0000410000ULL,
0x000000000048b947ULL, 0x000fea0003800000ULL, 0x000000100a2f7811ULL, 0x000fca00078ff0ffULL,
0x00001f2f362c7589ULL, 0x006e6400000e0000ULL, 0x0000000c2c0c7220ULL, 0x042fe20000410000ULL,
0x0000000d2c0d7220ULL, 0x040fe20000410000ULL, 0x000000102c107220ULL, 0x040fe20000410000ULL,
0x000000112c117220ULL, 0x040fe20000410000ULL, 0x000000142c147220ULL, 0x040fe20000410000ULL,
0x000000152c157220ULL, 0x040fe20000410000ULL, 0x000000182c187220ULL, 0x040fe20000410000ULL,
0x000000192c197220ULL, 0x040fe20000410000ULL, 0x0000001c2c1c7220ULL, 0x040fe20000410000ULL,
0x0000001d2c1d7220ULL, 0x040fe20000410000ULL, 0x000000202c207220ULL, 0x040fe20000410000ULL,
0x000000212c217220ULL, 0x040fe20000410000ULL, 0x000000302c307220ULL, 0x040fe20000410000ULL,
0x000000312c317220ULL, 0x040fe20000410000ULL, 0x000000382c387220ULL, 0x040fe20000410000ULL,
0x000000392c397220ULL, 0x000fce0000410000ULL, 0x0000003683837220ULL, 0x004fe20000410000ULL,
0x000000000048c947ULL, 0x000fec0003800000ULL, 0x000000180a2f7811ULL, 0x000fca00078ff0ffULL,
0x00001f2f362c7589ULL, 0x002e6400000e0000ULL, 0x0000000e2c0e7220ULL, 0x042fe20000410000ULL,
0x0000000f2c0f7220ULL, 0x040fe20000410000ULL, 0x000000122c127220ULL, 0x040fe20000410000ULL,
0x000000132c137220ULL, 0x040fe20000410000ULL, 0x000000162c167220ULL, 0x040fe20000410000ULL,
0x000000172c177220ULL, 0x040fe20000410000ULL, 0x0000001a2c1a7220ULL, 0x040fe20000410000ULL,
0x0000001b2c1b7220ULL, 0x040fe20000410000ULL, 0x0000001e2c1e7220ULL, 0x040fe20000410000ULL,
0x0000001f2c1f7220ULL, 0x040fe20000410000ULL, 0x000000222c227220ULL, 0x040fe20000410000ULL,
0x000000232c237220ULL, 0x040fe20000410000ULL, 0x000000322c327220ULL, 0x040fe20000410000ULL,
0x000000332c337220ULL, 0x040fe20000410000ULL, 0x0000003a2c3a7220ULL, 0x040fe20000410000ULL,
0x0000003b2c3b7220ULL, 0x000fce0000410000ULL, 0x0000003435ff7212ULL, 0x000fe200078030ffULL,
0x00000001ff347424ULL, 0x000fe200078e00ffULL, 0x000000852e857209ULL, 0x000fd60007810000ULL,
0x800000852e2e0221ULL, 0x000fe20000010000ULL, 0x00007610ff340816ULL, 0x000fc60000000034ULL,
0x3fb8aa3b2e2e0820ULL, 0x000fc80000410000ULL, 0x0000002e00040308ULL, 0x000ea40000000800ULL,
0x000000042d2d0220ULL, 0x004fce0000410000ULL, 0x000000832d837221ULL, 0x000fce0000010000ULL,
0x00000000002c7805ULL, 0x002fce0000015200ULL, 0x00000089ff0075a7ULL, 0x000e640008000145ULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000002e7805ULL, 0x000fce0000015200ULL, 0x0000002e2c357210ULL, 0x000fca0007f1e1ffULL,
0x000000012f2f7824ULL, 0x000fe200000e0e2dULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff2e7819ULL, 0x000fc8000001142fULL,
0x000000352e2e7211ULL, 0x000fca00078110ffULL, 0x000000ffff2f7224ULL, 0x000fca00000e062fULL,
0x000000022e2e7819ULL, 0x000fc8000000122fULL, 0x0000002e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x00000089ff0075a7ULL, 0x000e640008000145ULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00009910342c7816ULL, 0x000fe200000000ffULL, 0x00000400782d7824ULL, 0x000fe400078e00ffULL,
0x000000106d4c7824ULL, 0x000fe200078e0284ULL, 0x000000ff2c00720cULL, 0x000fe40003f05270ULL,
0xfffff0002d807812ULL, 0x000fc800078ec0ffULL, 0x0001400009807810ULL, 0x000fca0007ffe080ULL,
0x000000107f347824ULL, 0x100fe400078e0280ULL, 0x000000107e2c7824ULL, 0x000fe200078e0280ULL,
0x0000000000280947ULL, 0x000fec0003800000ULL, 0x00000002ff2e7819ULL, 0x000fe4000001160aULL,
0x00000004ff00723eULL, 0x000fc600000000ffULL, 0x000000082e027836ULL, 0x000fe20000000000ULL,
0x00005410002d7816ULL, 0x000fe20000000000ULL, 0x000000102e367836ULL, 0x000fe40000000000ULL,
0x000000182e4e7836ULL, 0x000fe40000000000ULL, 0x00001f022d027589ULL, 0x0002a800000e0000ULL,
0x00001f362d057589ULL, 0x0002e800000e0000ULL, 0x00001f2e2d037589ULL, 0x00026800000e0000ULL,
0x00001f4e2d007589ULL, 0x00026400000e0000ULL, 0x000000003434783bULL, 0x002e680000000200ULL,
0x000000002c2c783bULL, 0x000ee20000000200ULL, 0x0000000000200947ULL, 0x000fea0003800000ULL,
0x0000000334347232ULL, 0x082fe40000000000ULL, 0x0000000336367232ULL, 0x000fe40000000000ULL,
0x0000000235357232ULL, 0x084fe40000000000ULL, 0x0000000237377232ULL, 0x000fe40000000000ULL,
0x000000052c2c7232ULL, 0x088fe40000000000ULL, 0x000000052e2e7232ULL, 0x000fc40000000000ULL,
0x000000002d2d7232ULL, 0x080fe40000000000ULL, 0x000000002f2f7232ULL, 0x000fce0000000000ULL,
0x000000107b5c7824ULL, 0x000fe200078e0284ULL, 0x000000004c4c783bULL, 0x000f620000004200ULL,
0x0001600072727836ULL, 0x000fc80000000000ULL, 0x000000005c5c783bULL, 0x000f640000004200ULL,
0x00000018ff677819ULL, 0x028fe4000001164fULL, 0x00000010ff917819ULL, 0x000fe4000001164cULL,
0x00000018ff657819ULL, 0x000fe4000001164eULL, 0x00000018ff6b7819ULL, 0x004fe4000001165dULL,
0x0000ffff4d8c7812ULL, 0x000fc400078ec0ffULL, 0x000000ff5d947812ULL, 0x000fe400078ec0ffULL,
0x000000ff5e957812ULL, 0x000fe400078ec0ffULL, 0x00000010ff927819ULL, 0x000fe4000001164dULL,
0x0000ffff4e8d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff647819ULL, 0x000fe4000001165fULL,
0x000000ff5f967812ULL, 0x000fc400078ec0ffULL, 0x00000018ff687819ULL, 0x000fe4000001165fULL,
0x0000ffff5f7b7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff4c6a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff887819ULL, 0x100fe4000001165eULL, 0x00000018ff937819ULL, 0x000fe4000001165eULL,
0x0000ffff5e667812ULL, 0x000fc400078ec0ffULL, 0x00000067ff5f723eULL, 0x000fe400020006ffULL,
0x000000ff4c907812ULL, 0x000fe400078ec0ffULL, 0x00000065ff5e723eULL, 0x000fe400020006ffULL,
0x0000006bff67723eULL, 0x000fe400020006ffULL, 0x000000ff91917812ULL, 0x000fe400078ec0ffULL,
0x00000094ff65723eULL, 0x000fc400020006ffULL, 0x00000095ff6b723eULL, 0x000fe400020006ffULL,
0x00000008ff8c7819ULL, 0x000fe4000001168cULL, 0x00000018ff8a7819ULL, 0x000fe4000001164cULL,
0x000000ff4d8f7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff8b7819ULL, 0x000fe4000001164dULL,
0x000000ff92947812ULL, 0x000fc400078ec0ffULL, 0x00000008ff957819ULL, 0x000fe4000001168dULL,
0x00000010ff4d7819ULL, 0x000fe4000001164eULL, 0x0000ffff4f4c7812ULL, 0x040fe400078ec0ffULL,
0x00000008ff927819ULL, 0x000fe4000001166aULL, 0x000000ff4e897812ULL, 0x000fe400078ec0ffULL,
0x000000ff4f697812ULL, 0x000fc400078ec0ffULL, 0x00000090ff90723eULL, 0x000fe400020006ffULL,
0x00000093ff6a723eULL, 0x000fe400020006ffULL, 0x00000091ff91723eULL, 0x000fe400020006ffULL,
0x00000010ff4e7819ULL, 0x000fe4000001165cULL, 0x0000008cff93723eULL, 0x000fe400020006ffULL,
0x00000010ff8e7819ULL, 0x000fc4000001164fULL, 0x00000095ff8c723eULL, 0x000fe400020006ffULL,
0x00000010ff4f7819ULL, 0x000fe4000001165dULL, 0x0000ffff5d847812ULL, 0x000fe400078ec0ffULL,
0x000000ff4d4d7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff957819ULL, 0x000fe4000001164cULL,
0x000000ff5c7f7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff7e7819ULL, 0x000fe4000001165cULL,
0x0000008aff8a723eULL, 0x000fe400020006ffULL, 0x00000069ff5d723eULL, 0x000fe400020006ffULL,
0x00000092ff92723eULL, 0x000fe400020006ffULL, 0x00005410904c7816ULL, 0x000fe40000000091ULL,
0x0000ffff5c5c7812ULL, 0x000fc400078ec0ffULL, 0x00000096ff69723eULL, 0x000fe400020006ffULL,
0x000000ff4e907812ULL, 0x000fe400078ec0ffULL, 0x000000ff8e967812ULL, 0x000fe400078ec0ffULL,
0x00000089ff89723eULL, 0x000fe400020006ffULL, 0x0000004dff8e723eULL, 0x000fe400020006ffULL,
0x00005410924e7816ULL, 0x000fc4000000008aULL, 0x0000007fff7f723eULL, 0x000fe400020006ffULL,
0x00000090ff90723eULL, 0x000fe400020006ffULL, 0x00000008ff8a7819ULL, 0x000fe4000001165cULL,
0x00005410895c7816ULL, 0x000fe4000000008eULL, 0x000000ff64897812ULL, 0x000fe400078ec0ffULL,
0x0000008fff8f723eULL, 0x000fc400020006ffULL, 0x0000007eff7e723eULL, 0x000fe400020006ffULL,
0x00000094ff94723eULL, 0x000fe400020006ffULL, 0x0000008aff8a723eULL, 0x000fe400020006ffULL,
0x000000ff88887812ULL, 0x000fe400078ec0ffULL, 0x000054107f647816ULL, 0x000fe40000000090ULL,
0x000000ff4f917812ULL, 0x000fc400078ec0ffULL, 0x00000008ff847819ULL, 0x000fe40000011684ULL,
0x00000008ff7f7819ULL, 0x000fe40000011666ULL, 0x00000008ff7b7819ULL, 0x000fe4000001167bULL,
0x000054108f4d7816ULL, 0x000fe40000000094ULL, 0x00000088ff88723eULL, 0x000fe400020006ffULL,
0x000054108a667816ULL, 0x000fc4000000007eULL, 0x0000008bff8b723eULL, 0x000fe200020006ffULL,
0x0000004c3454723cULL, 0x002fe20000001854ULL, 0x00000096ff8d723eULL, 0x000fe400020006ffULL,
0x00000095ff8f723eULL, 0x000fe400020006ffULL, 0x00000091ff91723eULL, 0x000fe200020006ffULL,
0x0000004c2c0c723cULL, 0x000fe2000000180cULL, 0x00000084ff84723eULL, 0x000fe400020006ffULL,
0x00000089ff89723eULL, 0x000fc400020006ffULL, 0x00000068ff7e723eULL, 0x000fe400020006ffULL,
0x0000007fff7f723eULL, 0x000fe200020006ffULL, 0x000000107d4c7824ULL, 0x000fe200078e0272ULL,
0x0000007bff7b723eULL, 0x000fe400020006ffULL, 0x000054106b687816ULL, 0x000fe40000000088ULL,
0x00005410934f7816ULL, 0x000fe4000000008bULL, 0x000054105d5d7816ULL, 0x000fc4000000008dULL,
0x000054108c5e7816ULL, 0x000fe4000000005eULL, 0x000054108f5f7816ULL, 0x000fe2000000005fULL,
0x0000004e343c723cULL, 0x000fe2000000183cULL, 0x0000541065657816ULL, 0x000fe40000000091ULL,
0x0000541084677816ULL, 0x000fe40000000067ULL, 0x0000541069697816ULL, 0x000fe20000000089ULL,
0x0000005c3440723cULL, 0x000fe20000001840ULL, 0x000054107f6a7816ULL, 0x000fc4000000006aULL,
0x000054107b6b7816ULL, 0x000fc6000000007eULL, 0x0000005e3444723cULL, 0x000fec0000001844ULL,
0x000000643448723cULL, 0x000fec0000001848ULL, 0x000000663450723cULL, 0x000fec0000001850ULL,
0x000000683428723cULL, 0x000fec0000001828ULL, 0x0000006a3424723cULL, 0x000fec0000001824ULL,
0x0000004e2c10723cULL, 0x000fe20000001810ULL, 0x0000001070347824ULL, 0x000fc400078e0280ULL,
0x0000001071807824ULL, 0x000fc600078e0280ULL, 0x0000005c2c14723cULL, 0x000fe20000001814ULL,
0x000000003434783bULL, 0x000e6a0000000200ULL, 0x0000005e2c18723cULL, 0x000fec0000001818ULL,
0x000000642c1c723cULL, 0x000fec000000181cULL, 0x000000662c20723cULL, 0x000fec0000001820ULL,
0x000000682c30723cULL, 0x000fec0000001830ULL, 0x0000006a2c38723cULL, 0x000fe20000001838ULL,
0x00000000802c783bULL, 0x0004e20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000200947ULL, 0x000fde0003800000ULL, 0x0000000334347232ULL, 0x082fe40000000000ULL,
0x0000000336367232ULL, 0x000fe40000000000ULL, 0x0000000235357232ULL, 0x080fe40000000000ULL,
0x0000000237377232ULL, 0x000fe40000000000ULL, 0x000000052c2c7232ULL, 0x088fe40000000000ULL,
0x000000052e2e7232ULL, 0x000fc40000000000ULL, 0x000000002d2d7232ULL, 0x080fe40000000000ULL,
0x000000002f2f7232ULL, 0x000fce0000000000ULL, 0x00000010735c7824ULL, 0x000fe200078e0272ULL,
0x000000004c4c783bULL, 0x000f6a0000004200ULL, 0x000000005c5c783bULL, 0x000f640000004200ULL,
0x00000018ff657819ULL, 0x024fe4000001164eULL, 0x00000010ff8f7819ULL, 0x000fc4000001164dULL,
0x0000ffff4c697812ULL, 0x000fe400078ec0ffULL, 0x000000ff5d907812ULL, 0x008fe400078ec0ffULL,
0x00000010ff7f7819ULL, 0x100fe4000001165eULL, 0x00000018ff917819ULL, 0x000fe4000001165eULL,
0x000000ff5e927812ULL, 0x040fe400078ec0ffULL, 0x0000ffff5e667812ULL, 0x000fc400078ec0ffULL,
0x00000065ff5e723eULL, 0x000fe400020006ffULL, 0x00000090ff65723eULL, 0x000fe400020006ffULL,
0x000000ff4d897812ULL, 0x000fe400078ec0ffULL, 0x000000ff4f6a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff8f907812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8e7819ULL, 0x000fc4000001164cULL,
0x000000ff4c8a7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff847819ULL, 0x000fe4000001164cULL,
0x00000018ff887819ULL, 0x000fe4000001164dULL, 0x0000ffff4d8d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8b7819ULL, 0x100fe4000001164fULL, 0x00000018ff677819ULL, 0x000fc4000001164fULL,
0x0000ffff4f4c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8c7819ULL, 0x000fe4000001164eULL,
0x0000ffff4e4d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff4f7819ULL, 0x100fe4000001165dULL,
0x00000018ff6b7819ULL, 0x000fe4000001165dULL, 0x0000ffff5d7e7812ULL, 0x000fc400078ec0ffULL,
0x000000ff4e807812ULL, 0x000fe400078ec0ffULL, 0x00000089ff89723eULL, 0x000fe400020006ffULL,
0x0000006aff5d723eULL, 0x000fe400020006ffULL, 0x00000008ff8f7819ULL, 0x000fe40000011669ULL,
0x00000090ff90723eULL, 0x000fe400020006ffULL, 0x00000010ff4e7819ULL, 0x000fc4000001165cULL,
0x00000091ff6a723eULL, 0x000fe400020006ffULL, 0x000000ff8b917812ULL, 0x000fe400078ec0ffULL,
0x000000ff8c8c7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff8b7819ULL, 0x000fe4000001164dULL,
0x000000ff5c7d7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff7b7819ULL, 0x000fc4000001165cULL,
0x00000084ff84723eULL, 0x000fe400020006ffULL, 0x0000008fff8f723eULL, 0x000fe400020006ffULL,
0x00005410894d7816ULL, 0x000fe40000000090ULL, 0x0000ffff5c5c7812ULL, 0x000fe400078ec0ffULL,
0x000000ff8e8e7812ULL, 0x000fe400078ec0ffULL, 0x000000ff4e897812ULL, 0x000fc400078ec0ffULL,
0x00000080ff80723eULL, 0x000fe400020006ffULL, 0x0000008cff8c723eULL, 0x000fe400020006ffULL,
0x00000010ff647819ULL, 0x100fe4000001165fULL, 0x00000018ff687819ULL, 0x000fe4000001165fULL,
0x000000ff5f937812ULL, 0x040fe400078ec0ffULL, 0x0000ffff5f737812ULL, 0x000fc400078ec0ffULL,
0x000054108f4e7816ULL, 0x000fe40000000084ULL, 0x0000008aff8a723eULL, 0x000fe400020006ffULL,
0x00000067ff5f723eULL, 0x000fe400020006ffULL, 0x0000007dff7d723eULL, 0x000fe400020006ffULL,
0x0000008eff8e723eULL, 0x000fe400020006ffULL, 0x00000089ff89723eULL, 0x000fc400020006ffULL,
0x00000008ff847819ULL, 0x000fe4000001165cULL, 0x0000006bff67723eULL, 0x000fe400020006ffULL,
0x00000092ff6b723eULL, 0x000fe400020006ffULL, 0x00005410805c7816ULL, 0x000fe4000000008cULL,
0x00000008ff927819ULL, 0x000fe4000001164cULL, 0x000000ff64807812ULL, 0x000fc400078ec0ffULL,
0x0000007bff7b723eULL, 0x000fe400020006ffULL, 0x000054108a4c7816ULL, 0x000fe4000000008eULL,
0x00000084ff84723eULL, 0x000fe400020006ffULL, 0x000000ff7f7f7812ULL, 0x000fe400078ec0ffULL,
0x000054107d647816ULL, 0x000fe20000000089ULL, 0x0000004c3454723cULL, 0x002fe20000001854ULL,
0x00000008ff8d7819ULL, 0x000fc4000001168dULL, 0x000000ff4f8a7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff7e7819ULL, 0x000fe2000001167eULL, 0x0000004c2c0c723cULL, 0x000fe2000000180cULL,
0x00000008ff7d7819ULL, 0x000fe40000011666ULL, 0x00000008ff737819ULL, 0x000fe40000011673ULL,
0x0000007fff7f723eULL, 0x000fe400020006ffULL, 0x0000541084667816ULL, 0x000fc4000000007bULL,
0x00000088ff88723eULL, 0x000fe400020006ffULL, 0x00000093ff69723eULL, 0x000fe400020006ffULL,
0x0000008dff8d723eULL, 0x000fe400020006ffULL, 0x00000091ff91723eULL, 0x000fe400020006ffULL,
0x0000008bff8b723eULL, 0x000fe400020006ffULL, 0x00000092ff92723eULL, 0x000fc400020006ffULL,
0x0000008aff8a723eULL, 0x000fe400020006ffULL, 0x0000007eff7e723eULL, 0x000fe400020006ffULL,
0x00000080ff80723eULL, 0x000fe400020006ffULL, 0x00000068ff7b723eULL, 0x000fe400020006ffULL,
0x0000007dff7d723eULL, 0x000fe400020006ffULL, 0x00000073ff73723eULL, 0x000fc400020006ffULL,
0x000054106b687816ULL, 0x000fe4000000007fULL, 0x000054108d4f7816ULL, 0x000fe40000000088ULL,
0x000054105d5d7816ULL, 0x000fe40000000091ULL, 0x000054108b5e7816ULL, 0x000fe4000000005eULL,
0x00005410925f7816ULL, 0x000fe2000000005fULL, 0x0000004e343c723cULL, 0x000fe2000000183cULL,
0x0000541065657816ULL, 0x000fc4000000008aULL, 0x000054107e677816ULL, 0x000fe40000000067ULL,
0x0000541069697816ULL, 0x000fe20000000080ULL, 0x0000005c3440723cULL, 0x000fe20000001840ULL,
0x000054107d6a7816ULL, 0x000fe4000000006aULL, 0x00005410736b7816ULL, 0x000fc6000000007bULL,
0x0000005e3444723cULL, 0x000fec0000001844ULL, 0x000000643448723cULL, 0x000fec0000001848ULL,
0x000000663450723cULL, 0x000fec0000001850ULL, 0x000000683428723cULL, 0x000fec0000001828ULL,
0x0000006a3424723cULL, 0x000fec0000001824ULL, 0x0000004e2c10723cULL, 0x000fe20000001810ULL,
0x0000000278347824ULL, 0x000fc400078e00ffULL, 0x00000001ff377424ULL, 0x000fc600078e00ffULL,
0xfffffff834347812ULL, 0x000fe200078ec0ffULL, 0x0000005c2c14723cULL, 0x000fe80000001814ULL,
0x0000000109367824ULL, 0x000fe400078e0234ULL, 0x00000037063479a7ULL, 0x000262000850003fULL,
0x0000005e2c18723cULL, 0x000fec0000001818ULL, 0x000000642c1c723cULL, 0x000fe2000000181cULL,
0x01a6983736ff79a7ULL, 0x0003ea000850003fULL, 0x000000662c20723cULL, 0x000fec0000001820ULL,
0x000000682c30723cULL, 0x000fec0000001830ULL, 0x0000006a2c38723cULL, 0x002fde0000001838ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x00000000002c7805ULL, 0x000fce0000015200ULL,
0x00000035060075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000002e7805ULL, 0x000fce0000015200ULL,
0x0000002e2c377210ULL, 0x000fca0007f1e1ffULL, 0x000000012f2f7824ULL, 0x000fe200000e0e2dULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff2e7819ULL, 0x000fc8000001142fULL, 0x000000372e2e7211ULL, 0x000fca00078110ffULL,
0x000000ffff2f7224ULL, 0x000fca00000e062fULL, 0x000000022e2e7819ULL, 0x000fc8000000122fULL,
0x0000002e0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x00000035060075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00000001582c7836ULL, 0x000fca0000000000ULL,
0x000000612c00720cULL, 0x000fda0003f06070ULL, 0x0000000400e80947ULL, 0x000fea0003800000ULL,
0x00008e00ff2c7b82ULL, 0x000e620000000a00ULL, 0x00000002582e7836ULL, 0x000fe20000000000ULL,
0x0000850000087ab9ULL, 0x000fe20000000800ULL, 0x0000010081817836ULL, 0x000fe40000000000ULL,
0x00000008822f7c24ULL, 0x010fe2000f8e02ffULL, 0x000000612e00720cULL, 0x000fe40003f06070ULL,
0x00000060812e7812ULL, 0x000fe200078ec0ffULL, 0x000000802f2f7824ULL, 0x000fc800078e00ffULL,
0x00000001594c7824ULL, 0x000fe400078e022eULL, 0x000000802f2c7825ULL, 0x002fc800078e002cULL,
0x0000000000f88947ULL, 0x000fea0003800000ULL, 0x00000081742e7248ULL, 0x000fe20007fe0000ULL,
0x00000010782f7824ULL, 0x000fe200078e00ffULL, 0x00000003ff347819ULL, 0x000fc6000001160aULL,
0x000000012e2e7824ULL, 0x000fe200078e0a81ULL, 0x000000102f2f7812ULL, 0x000fe200078ec0ffULL,
0x00000008344d7836ULL, 0x000fe40000000000ULL, 0x0000000434367836ULL, 0x000fe20000000000ULL,
0x0000002e2f2e7248ULL, 0x000fe20007fe0000ULL, 0x0000000c344e7836ULL, 0x000fe40000000000ULL,
0x0000000134357824ULL, 0x100fe400078e022fULL, 0x000000012e2e7824ULL, 0x000fc400078e0a2fULL,
0x0000000136377824ULL, 0x100fe400078e022fULL, 0x00000008355f7824ULL, 0x000fe200078e00ffULL,
0x0000002e4d00720cULL, 0x0c0fe20003f46070ULL, 0x000000014d4d7824ULL, 0x000fe200078e022fULL,
0x0000002e3400720cULL, 0x080fe20003f86070ULL, 0x0000000135347824ULL, 0x100fe200078e024cULL,
0x0000002e3600720cULL, 0x080fe20003f66070ULL, 0x0000000137367824ULL, 0x000fe200078e024cULL,
0x0000002e4e00720cULL, 0x000fe20003f06070ULL, 0x00000001352e7824ULL, 0x000fc400078e020aULL,
0x000000014d357824ULL, 0x140fe400078e020aULL, 0x000000084d5c7824ULL, 0x000fe200078e00ffULL,
0xfffffff85f5f7812ULL, 0x000fe200078ee22eULL, 0x000000014e5d7824ULL, 0x000fe400078e022fULL,
0x00000001372f7824ULL, 0x040fe200078e020aULL, 0xfffffff85c677812ULL, 0x000fe200078ee235ULL,
0x00000008374e7824ULL, 0x000fe400078e00ffULL, 0x0000008036367825ULL, 0x000fc600078e00ffULL,
0xfffffff84e657812ULL, 0x000fe200078ee22fULL, 0x0000008034347825ULL, 0x000fc800078e00ffULL,
0x000000014d2e7824ULL, 0x100fe200078e024cULL, 0x0000006e364d7212ULL, 0x080fe200078efcffULL,
0x000000015d4c7824ULL, 0x000fe200078e024cULL, 0x0000006e344f7212ULL, 0x000fe200078efcffULL,
0x000000802e2e7825ULL, 0x000fe200078e00ffULL, 0x0000004d2c367210ULL, 0x000fe40007fde0ffULL,
0x0000004f2c347210ULL, 0x000fe20007fbe0ffULL, 0x000000804c4c7825ULL, 0x000fc800078e00ffULL,
0x000000015d4e7824ULL, 0x040fe200078e020aULL, 0x0000006e4c4f7212ULL, 0x080fe200078efcffULL,
0x000000085d697824ULL, 0x000fe200078e00ffULL, 0x0000006e2e5d7212ULL, 0x000fe200078efcffULL,
0x000000012d357824ULL, 0x040fe400028e0635ULL, 0x000000012d377824ULL, 0x000fe200030e0637ULL,
0x0000005d2c2e7210ULL, 0x000fe20007fbe0ffULL, 0x000000105f5f7824ULL, 0x100fe200078e0272ULL,
0xfffffff869697812ULL, 0x000fe200078ee24eULL, 0x0000001065657824ULL, 0x100fe200078e0272ULL,
0x0000004f2c2c7210ULL, 0x000fe20007fde0ffULL, 0x0000001067677824ULL, 0x000fe200078e0272ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000345f7faeULL, 0x0003e2000e101c46ULL,
0x000000012d2f7824ULL, 0x000fc400028e062fULL, 0x0000001069697824ULL, 0x000fe200078e0272ULL,
0x0000000036657faeULL, 0x0003e2000d901c46ULL, 0x000000012d2d7824ULL, 0x000fc600030e064dULL,
0x000000002e677faeULL, 0x0003e8000d101c46ULL, 0x000000002c697faeULL, 0x0003e2000c101c46ULL,
0x0000000000c47947ULL, 0x000fea0003800000ULL, 0x00000010782e7824ULL, 0x000fca00078e00ffULL,
0x000000102e2f7812ULL, 0x000fc800078ec0ffULL, 0x0000002f0a2f7211ULL, 0x000fca00078fe8ffULL,
0x000000012f2e7824ULL, 0x040fe400078e024cULL, 0x000000012f347824ULL, 0x040fe400078e020aULL,
0x000000082f4f7824ULL, 0x000fe400078e00ffULL, 0x000000042f357836ULL, 0x000fe40000000000ULL,
0x000000082f4d7836ULL, 0x000fe20000000000ULL, 0xfffffff84f4f7812ULL, 0x000fe200078ee234ULL,
0x0000000c2f5d7836ULL, 0x000fc40000000000ULL, 0x000000802e2e7825ULL, 0x000fc800078e00ffULL,
0x0000000135347824ULL, 0x040fe400078e024cULL, 0x0000000135377824ULL, 0x040fe400078e020aULL,
0x00000008355c7824ULL, 0x000fe200078e00ffULL, 0x0000006e2e357212ULL, 0x000fe200078efcffULL,
0x000000014d367824ULL, 0x040fe400078e024cULL, 0x000000014d4e7824ULL, 0x040fe200078e020aULL,
0x000000352c2e7210ULL, 0x000fe20007f1e0ffULL, 0x000000084d697824ULL, 0x000fc400078e00ffULL,
0x000000015d4d7824ULL, 0x040fe400078e020aULL, 0x000000085d5e7824ULL, 0x040fe200078e00ffULL,
0xfffffff869697812ULL, 0x000fe200078ee24eULL, 0x000000015d4c7824ULL, 0x000fe200078e024cULL,
0xfffffff85c5d7812ULL, 0x000fe200078ee237ULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0xfffffff85e6b7812ULL, 0x000fc600078ee24dULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000006e345f7212ULL, 0x000fc600078efcffULL, 0x000000804c4c7825ULL, 0x000fc800078e00ffULL,
0x000000105d677824ULL, 0x100fe200078e0272ULL, 0x0000006e365d7212ULL, 0x080fe200078efcffULL,
0x000000104f657824ULL, 0x100fe200078e0272ULL, 0x0000006e4c4f7212ULL, 0x000fe200078efcffULL,
0x000000012d2f7824ULL, 0x000fe200000e062fULL, 0x0000005f2c347210ULL, 0x000fe20007f1e0ffULL,
0x0000001069697824ULL, 0x100fe200078e0272ULL, 0x0000005d2c367210ULL, 0x000fe20007f5e0ffULL,
0x000000106b6b7824ULL, 0x000fe200078e0272ULL, 0x0000004f2c2c7210ULL, 0x000fe20007f7e0ffULL,
0x000000012d357824ULL, 0x040fe200000e0635ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002e657faeULL, 0x0003e2000b901c46ULL, 0x000000012d377824ULL, 0x000fc400010e0637ULL,
0x000000012d2d7824ULL, 0x000fe200018e064dULL, 0x0000000034677faeULL, 0x0003e8000b901c46ULL,
0x0000000036697faeULL, 0x0003e8000b901c46ULL, 0x000000002c6b7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x00000001ff357424ULL, 0x000fe200078e00ffULL,
0x00000000ff0079b0ULL, 0x000fe20008000a44ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000035ff2c79a7ULL, 0x0002a40008500005ULL, 0x01a66835083479a7ULL, 0x0022e4000850003fULL,
0x000000ffff7b7224ULL, 0x006fce00078e002dULL, 0x00000000002c7805ULL, 0x000fce0000015200ULL,
0x01a66835080075a7ULL, 0x008e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000002e7805ULL, 0x000fce0000015200ULL,
0x0000002e2c377210ULL, 0x000fca0007f1e1ffULL, 0x000000012f2f7824ULL, 0x000fe200000e0e2dULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff2e7819ULL, 0x000fc8000001142fULL, 0x000000372e2e7211ULL, 0x000fca00078110ffULL,
0x000000ffff2f7224ULL, 0x000fca00000e062fULL, 0x000000022e2e7819ULL, 0x000fc8000000122fULL,
0x0000002e0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x01a66835080075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000805a2d7824ULL, 0x000fe400078e0209ULL,
0x00000001ff347424ULL, 0x000fe400078e00ffULL, 0x000000ffff7e7224ULL, 0x000fe200078e0085ULL,
0x000001806e2c7810ULL, 0x000fca0007ffe02dULL, 0x000000016f2c7824ULL, 0x000fca00078e022cULL,
0x01a000002c2e7984ULL, 0x000e680000000800ULL, 0x01a200002c2d7984ULL, 0x0004a20000000800ULL,
0x000000852e00720bULL, 0x002fda0003f1d000ULL, 0x0000000000357806ULL, 0x000fc800000e0100ULL,
0x000000ff3500720cULL, 0x000fda0003f05270ULL, 0x0000000400948947ULL, 0x004fea0003800000ULL,
0x000000035a2f7836ULL, 0x000fe20000000000ULL, 0x000000852e00720bULL, 0x0c0fe40003f14000ULL,
0x000000852e7e7209ULL, 0x000fe40007810000ULL, 0x000000782f00720cULL, 0x000fd20003f45270ULL,
0x0000000000347806ULL, 0x000fc800000e0100ULL, 0x00000080782ca824ULL, 0x000fe200078e0209ULL,
0x000000ff3400720cULL, 0x000fc80003f05270ULL, 0x0000002c6f6fa210ULL, 0x000fca0007ffe06eULL,
0x01a4007e6f00a388ULL, 0x0003e80000000800ULL, 0x0000000400508947ULL, 0x000fea0003800000ULL,
0x000000857e2c7221ULL, 0x000fe20000010100ULL, 0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL, 0x3fb8aa3b2c2c7820ULL, 0x000fe20000410000ULL,
0x00ff000034ff7812ULL, 0x040fe4000786c0ffULL, 0xff00000034ff7812ULL, 0x000fe2000788c0ffULL,
0x0000002c00367308ULL, 0x0004ec0000000800ULL, 0x0000000000488947ULL, 0x000fec0003800000ULL,
0x00000002ff2f7819ULL, 0x000fca000001160aULL, 0x00001f2f362c7589ULL, 0x00cea400000e0000ULL,
0x000000542c547220ULL, 0x044fe20000410000ULL, 0x000000552c557220ULL, 0x040fe20000410000ULL,
0x0000003c2c3c7220ULL, 0x040fe20000410000ULL, 0x0000003d2c3d7220ULL, 0x040fe20000410000ULL,
0x000000402c407220ULL, 0x040fe20000410000ULL, 0x000000412c417220ULL, 0x040fe20000410000ULL,
0x000000442c447220ULL, 0x040fe20000410000ULL, 0x000000452c457220ULL, 0x040fe20000410000ULL,
0x000000482c487220ULL, 0x040fe20000410000ULL, 0x000000492c497220ULL, 0x040fe20000410000ULL,
0x000000502c507220ULL, 0x040fe20000410000ULL, 0x000000512c517220ULL, 0x040fe20000410000ULL,
0x000000282c287220ULL, 0x040fe20000410000ULL, 0x000000292c297220ULL, 0x040fe20000410000ULL,
0x000000242c247220ULL, 0x040fe20000410000ULL, 0x000000252c257220ULL, 0x000fce0000410000ULL,
0x000000000048a947ULL, 0x000fea0003800000ULL, 0x000000080a2f7811ULL, 0x000fca00078ff0ffULL,
0x00001f2f362c7589ULL, 0x00cea400000e0000ULL, 0x000000562c567220ULL, 0x044fe20000410000ULL,
0x000000572c577220ULL, 0x040fe20000410000ULL, 0x0000003e2c3e7220ULL, 0x040fe20000410000ULL,
0x0000003f2c3f7220ULL, 0x040fe20000410000ULL, 0x000000422c427220ULL, 0x040fe20000410000ULL,
0x000000432c437220ULL, 0x040fe20000410000ULL, 0x000000462c467220ULL, 0x040fe20000410000ULL,
0x000000472c477220ULL, 0x040fe20000410000ULL, 0x0000004a2c4a7220ULL, 0x040fe20000410000ULL,
0x0000004b2c4b7220ULL, 0x040fe20000410000ULL, 0x000000522c527220ULL, 0x040fe20000410000ULL,
0x000000532c537220ULL, 0x040fe20000410000ULL, 0x0000002a2c2a7220ULL, 0x040fe20000410000ULL,
0x0000002b2c2b7220ULL, 0x040fe20000410000ULL, 0x000000262c267220ULL, 0x040fe20000410000ULL,
0x000000272c277220ULL, 0x000fce0000410000ULL, 0x000000000048b947ULL, 0x000fea0003800000ULL,
0x000000100a2f7811ULL, 0x000fca00078ff0ffULL, 0x00001f2f362c7589ULL, 0x00cea400000e0000ULL,
0x0000000c2c0c7220ULL, 0x044fe20000410000ULL, 0x0000000d2c0d7220ULL, 0x040fe20000410000ULL,
0x000000102c107220ULL, 0x040fe20000410000ULL, 0x000000112c117220ULL, 0x040fe20000410000ULL,
0x000000142c147220ULL, 0x040fe20000410000ULL, 0x000000152c157220ULL, 0x040fe20000410000ULL,
0x000000182c187220ULL, 0x040fe20000410000ULL, 0x000000192c197220ULL, 0x040fe20000410000ULL,
0x0000001c2c1c7220ULL, 0x040fe20000410000ULL, 0x0000001d2c1d7220ULL, 0x040fe20000410000ULL,
0x000000202c207220ULL, 0x040fe20000410000ULL, 0x000000212c217220ULL, 0x040fe20000410000ULL,
0x000000302c307220ULL, 0x040fe20000410000ULL, 0x000000312c317220ULL, 0x040fe20000410000ULL,
0x000000382c387220ULL, 0x040fe20000410000ULL, 0x000000392c397220ULL, 0x000fce0000410000ULL,
0x0000003683837220ULL, 0x008fe20000410000ULL, 0x000000000048c947ULL, 0x000fec0003800000ULL,
0x000000180a2f7811ULL, 0x000fca00078ff0ffULL, 0x00001f2f362c7589ULL, 0x004ea400000e0000ULL,
0x0000000e2c0e7220ULL, 0x044fe20000410000ULL, 0x0000000f2c0f7220ULL, 0x040fe20000410000ULL,
0x000000122c127220ULL, 0x040fe20000410000ULL, 0x000000132c137220ULL, 0x040fe20000410000ULL,
0x000000162c167220ULL, 0x040fe20000410000ULL, 0x000000172c177220ULL, 0x040fe20000410000ULL,
0x0000001a2c1a7220ULL, 0x040fe20000410000ULL, 0x0000001b2c1b7220ULL, 0x040fe20000410000ULL,
0x0000001e2c1e7220ULL, 0x040fe20000410000ULL, 0x0000001f2c1f7220ULL, 0x040fe20000410000ULL,
0x000000222c227220ULL, 0x040fe20000410000ULL, 0x000000232c237220ULL, 0x040fe20000410000ULL,
0x000000322c327220ULL, 0x040fe20000410000ULL, 0x000000332c337220ULL, 0x040fe20000410000ULL,
0x0000003a2c3a7220ULL, 0x040fe20000410000ULL, 0x0000003b2c3b7220ULL, 0x000fce0000410000ULL,
0x0000003435ff7212ULL, 0x000fe200078030ffULL, 0x00000001ff347424ULL, 0x000fd800078e00ffULL,
0x0000002e7e2e0221ULL, 0x000fe20000010100ULL, 0x00007610ff340816ULL, 0x000fc60000000034ULL,
0x3fb8aa3b2e2e0820ULL, 0x000fc80000410000ULL, 0x0000002e00040308ULL, 0x000ee40000000800ULL,
0x000000042d2d0220ULL, 0x008fce0000410000ULL, 0x000000832d837221ULL, 0x000fce0000010000ULL,
0x00000000002c7805ULL, 0x004fce0000015200ULL, 0x00000008782e7824ULL, 0x000fca00078e00ffULL,
0xfffffff02e2e7812ULL, 0x000fca00078ec0ffULL, 0x0000000109377824ULL, 0x000fc800078e022eULL,
0x01a6b087370075a7ULL, 0x000ea4000800017fULL, 0x00000000005c0947ULL, 0x004fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000002e7805ULL, 0x000fce0000015200ULL,
0x0000002e2c357210ULL, 0x000fca0007f1e1ffULL, 0x000000012f2f7824ULL, 0x000fe200000e0e2dULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff2e7819ULL, 0x000fc8000001142fULL, 0x000000352e2e7211ULL, 0x000fca00078110ffULL,
0x000000ffff2f7224ULL, 0x000fca00000e062fULL, 0x000000022e2e7819ULL, 0x000fc8000000122fULL,
0x0000002e0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x01a6b087370075a7ULL, 0x000ea4000800017fULL,
0xfffffffc00a88947ULL, 0x004fea000383ffffULL, 0x00000001622c7812ULL, 0x000fe200078ec0ffULL,
0x000000086c367824ULL, 0x000fe200078e00ffULL, 0x00000004ff2f7819ULL, 0x000fe2000001160aULL,
0x000010005a2e7824ULL, 0x000fe200078e0209ULL, 0x00009910342d7816ULL, 0x000fe200000000ffULL,
0x0000000478347824ULL, 0x000fe400078e00ffULL, 0x000000042c2c7824ULL, 0x000fe200078e022fULL,
0x000000ff2d00720cULL, 0x000fe20003f05270ULL, 0x00000008792f7824ULL, 0x000fe200078e00ffULL,
0x0000000434347812ULL, 0x000fe200078ec0ffULL, 0x000000016c2d7824ULL, 0x000fc400078e022cULL,
0x00000001792c7824ULL, 0x000fe200078e022cULL, 0x00000002347d7812ULL, 0x000fe200078efcffULL,
0x000150002e647836ULL, 0x000fe20000000000ULL, 0xfffffff8362d7812ULL, 0x000fe400078ee22dULL,
0xfffffff82f2f7812ULL, 0x000fe200078ee22cULL, 0x000000106d2c7824ULL, 0x000fe200078e027aULL,
0x0000007d0a7d7211ULL, 0x000fe200078fe0ffULL, 0x000000102d2d7824ULL, 0x100fe400078e0264ULL,
0x000000102f2f7824ULL, 0x000fe200078e0264ULL, 0x0000000000280947ULL, 0x000fec0003800000ULL,
0x00000002ff037819ULL, 0x000fe4000001160aULL, 0x00000004ff00723eULL, 0x000fc600000000ffULL,
0x0000001003057836ULL, 0x000fe20000000000ULL, 0x00005410002e7816ULL, 0x000fe20000000000ULL,
0x0000000803357836ULL, 0x000fe40000000000ULL, 0x0000001803377836ULL, 0x000fe40000000000ULL,
0x00001f052e057589ULL, 0x0004e800000e0000ULL, 0x00001f352e027589ULL, 0x00046800000e0000ULL,
0x00001f032e037589ULL, 0x00046800000e0000ULL, 0x00001f372e007589ULL, 0x00046400000e0000ULL,
0x000000002d5c783bULL, 0x000ae80000000200ULL, 0x000000002f34783bULL, 0x0044620000000200ULL,
0x0000000000200947ULL, 0x020fea0003800000ULL, 0x000000035c5c7232ULL, 0x08afe40000000000ULL,
0x000000035e5e7232ULL, 0x000fe40000000000ULL, 0x000000025d5d7232ULL, 0x080fe40000000000ULL,
0x000000025f5f7232ULL, 0x000fe40000000000ULL, 0x0000000534347232ULL, 0x080fe40000000000ULL,
0x0000000536367232ULL, 0x000fc40000000000ULL, 0x0000000035357232ULL, 0x080fe40000000000ULL,
0x0000000037377232ULL, 0x000fce0000000000ULL, 0x000000086c4d7824ULL, 0x040fe200078e00ffULL,
0x000000002c2c783bULL, 0x004ea20000004200ULL, 0x000000016c6c7824ULL, 0x000fe400078e027dULL,
0x00000010706e7824ULL, 0x100fe400078e0264ULL, 0x0000001071717824ULL, 0x000fe200078e0264ULL,
0xfffffff84d4d7812ULL, 0x000fca00078ee26cULL, 0x000000104d4d7824ULL, 0x000fcc00078e027aULL,
0x000000004d4c783bULL, 0x000f620000004200ULL, 0x00000018ff697819ULL, 0x004fe4000001162cULL,
0x000000ff2f6c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff887819ULL, 0x100fe4000001162dULL,
0x000000ff2d847812ULL, 0x040fe400078ec0ffULL, 0x00000018ff807819ULL, 0x000fe4000001162dULL,
0x0000ffff2d8c7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff857819ULL, 0x100fe4000001162eULL,
0x000000ff2e6b7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff6a7819ULL, 0x000fe4000001162eULL,
0x00000010ff667819ULL, 0x128fe4000001164cULL, 0x000000ff4c6d7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff6f7819ULL, 0x002fc4000001164cULL, 0x0000ffff4c677812ULL, 0x000fe400078ec0ffULL,
0x000000ff4d727812ULL, 0x000fe400078ec0ffULL, 0x00000010ff4c7819ULL, 0x100fe4000001164fULL,
0x000000ff4f8a7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff897819ULL, 0x000fe4000001164fULL,
0x0000ffff4f2d7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff737819ULL, 0x000fe4000001164eULL,
0x00000069ff4f723eULL, 0x000fe400020006ffULL, 0x0000ffff2e647812ULL, 0x000fe400078ec0ffULL,
0x0000006cff69723eULL, 0x000fe400020006ffULL, 0x00000010ff877819ULL, 0x000fe4000001162cULL,
0x00000018ff2e7819ULL, 0x000fc4000001162fULL, 0x0000006dff6c723eULL, 0x000fe400020006ffULL,
0x000000ff2c817812ULL, 0x040fe400078ec0ffULL, 0x0000ffff2c8b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff867819ULL, 0x000fe4000001162fULL, 0x0000ffff2f657812ULL, 0x000fe400078ec0ffULL,
0x00000072ff6d723eULL, 0x000fc400020006ffULL, 0x00000018ff707819ULL, 0x000fe4000001164dULL,
0x00000010ff2f7819ULL, 0x000fe4000001164eULL, 0x000000ff4e7f7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff4e2c7812ULL, 0x000fe400078ec0ffULL, 0x00000073ff72723eULL, 0x000fe400020006ffULL,
0x0000006bff4e723eULL, 0x000fc400020006ffULL, 0x00000089ff73723eULL, 0x000fe400020006ffULL,
0x0000002eff6b723eULL, 0x000fe400020006ffULL, 0x000000ff87877812ULL, 0x000fe400078ec0ffULL,
0x000000ff88897812ULL, 0x000fe400078ec0ffULL, 0x0000006fff2e723eULL, 0x000fe400020006ffULL,
0x00000070ff6f723eULL, 0x000fc400020006ffULL, 0x000000ff85857812ULL, 0x000fe400078ec0ffULL,
0x0000007fff70723eULL, 0x000fe400020006ffULL, 0x00000008ff657819ULL, 0x000fe40000011665ULL,
0x00000081ff81723eULL, 0x000fe400020006ffULL, 0x00000084ff84723eULL, 0x000fe400020006ffULL,
0x0000008aff7f723eULL, 0x000fc400020006ffULL, 0x00000087ff87723eULL, 0x000fe400020006ffULL,
0x00000089ff89723eULL, 0x000fe400020006ffULL, 0x00000010ff687819ULL, 0x000fe4000001164dULL,
0x00000008ff887819ULL, 0x000fe4000001168bULL, 0x00000008ff8a7819ULL, 0x000fe4000001168cULL,
0x000000ff868c7812ULL, 0x000fc400078ec0ffULL, 0x00000085ff8b723eULL, 0x000fe400020006ffULL,
0x00000008ff867819ULL, 0x000fe40000011664ULL, 0x00000065ff85723eULL, 0x000fe400020006ffULL,
0x0000541081647816ULL, 0x000fe40000000087ULL, 0x0000541084657816ULL, 0x000fe40000000089ULL,
0x00000080ff80723eULL, 0x000fc400020006ffULL, 0x0000008aff8a723eULL, 0x000fe400020006ffULL,
0x000000ff66817812ULL, 0x000fe200078ec0ffULL, 0x00000064340c723cULL, 0x000fe2000000180cULL,
0x000000ff68847812ULL, 0x000fe400078ec0ffULL, 0x0000ffff4d4d7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff687819ULL, 0x000fe20000011667ULL, 0x000000645c54723cULL, 0x000fe20000001854ULL,
0x000054108a677816ULL, 0x000fc40000000080ULL, 0x00000081ff81723eULL, 0x000fe400020006ffULL,
0x00000084ff84723eULL, 0x000fe400020006ffULL, 0x00000068ff80723eULL, 0x000fe400020006ffULL,
0x00000008ff4d7819ULL, 0x000fe4000001164dULL, 0x000054104e687816ULL, 0x000fe4000000008bULL,
0x0000006aff6a723eULL, 0x000fc400020006ffULL, 0x00000086ff86723eULL, 0x000fe400020006ffULL,
0x000000ff2f4e7812ULL, 0x000fe400078ec0ffULL, 0x000000ff4c4c7812ULL, 0x000fe400078ec0ffULL,
0x00000088ff88723eULL, 0x000fe400020006ffULL, 0x000054106c6c7816ULL, 0x000fe40000000081ULL,
0x000054106d6d7816ULL, 0x000fc40000000084ULL, 0x0000004dff2f723eULL, 0x000fe400020006ffULL,
0x00000008ff817819ULL, 0x000fe4000001162cULL, 0x00000008ff847819ULL, 0x000fe2000001162dULL,
0x0000006c341c723cULL, 0x000fe2000000181cULL, 0x00005410866a7816ULL, 0x000fe4000000006aULL,
0x00005410856b7816ULL, 0x000fe4000000006bULL, 0x0000008cff8c723eULL, 0x000fe200020006ffULL,
0x0000006c5c48723cULL, 0x000fe20000001848ULL, 0x0000541088667816ULL, 0x000fc4000000004fULL,
0x0000004eff85723eULL, 0x000fe400020006ffULL, 0x0000004cff86723eULL, 0x000fe200020006ffULL,
0x0000006a3418723cULL, 0x000fe20000001818ULL, 0x000000006e4c783bULL, 0x0002a20000000200ULL,
0x00000081ff81723eULL, 0x000fe400020006ffULL, 0x00000084ff84723eULL, 0x000fe400020006ffULL,
0x000054102f6f7816ULL, 0x000fe2000000006fULL, 0x000000663410723cULL, 0x000fe20000001810ULL,
0x0000541069697816ULL, 0x000fc4000000008cULL, 0x00005410806e7816ULL, 0x002fe4000000002eULL,
0x00000000712c783bULL, 0x0002a20000000200ULL, 0x0000541070707816ULL, 0x000fe20000000085ULL,
0x000000665c3c723cULL, 0x000fe2000000183cULL, 0x0000541081727816ULL, 0x000fe40000000072ULL,
0x0000541084737816ULL, 0x000fe40000000073ULL, 0x000054107f717816ULL, 0x002fe20000000086ULL,
0x000000683414723cULL, 0x000fec0000001814ULL, 0x0000006e3420723cULL, 0x000fec0000001820ULL,
0x000000703430723cULL, 0x000fec0000001830ULL, 0x000000685c40723cULL, 0x000fec0000001840ULL,
0x0000006a5c44723cULL, 0x000fec0000001844ULL, 0x0000006e5c50723cULL, 0x000fec0000001850ULL,
0x000000705c28723cULL, 0x000fec0000001828ULL, 0x000000725c24723cULL, 0x000fec0000001824ULL,
0x000000723434723cULL, 0x000fe20000001838ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000200947ULL, 0x004fde0003800000ULL, 0x000000034c4c7232ULL, 0x080fe40000000000ULL,
0x000000034e4e7232ULL, 0x000fe40000000000ULL, 0x000000024d4d7232ULL, 0x080fe40000000000ULL,
0x000000024f4f7232ULL, 0x000fe40000000000ULL, 0x000000052c2c7232ULL, 0x080fe40000000000ULL,
0x000000052e2e7232ULL, 0x000fc40000000000ULL, 0x000000002d2d7232ULL, 0x080fe40000000000ULL,
0x000000002f2f7232ULL, 0x000fce0000000000ULL, 0x000000007c5c783bULL, 0x000e620000004200ULL,
0x00000001797d7824ULL, 0x040fe400078e027dULL, 0x0000000879387824ULL, 0x000fe400078e00ffULL,
0x0000000158587836ULL, 0x000fc60000000000ULL, 0xfffffff8387d7812ULL, 0x000fca00078ee27dULL,
0x000000107d387824ULL, 0x000fe200078e027aULL, 0x00000010ff397819ULL, 0x002fe4000001165cULL,
0x00000010ff3b7819ULL, 0x000fe4000001165dULL, 0x000000ff5d647812ULL, 0x000fe400078ec0ffULL,
0x000000ff5c3a7812ULL, 0x000fe400078ec0ffULL, 0x000000ff39397812ULL, 0x000fe400078ec0ffULL,
0x000000ff3b3b7812ULL, 0x000fc400078ec0ffULL, 0x00000064ff65723eULL, 0x000fe400020006ffULL,
0x0000003aff3a723eULL, 0x000fe400020006ffULL, 0x00000039ff39723eULL, 0x000fe400020006ffULL,
0x0000003bff3b723eULL, 0x000fe400020006ffULL, 0x0000ffff5c647812ULL, 0x000fe400078ec0ffULL,
0x0000ffff5d687812ULL, 0x000fc400078ec0ffULL, 0x00000018ff677819ULL, 0x000fe4000001165dULL,
0x00000008ff5d7819ULL, 0x000fe40000011664ULL, 0x000054103a647816ULL, 0x000fe40000000039ULL,
0x0000541065657816ULL, 0x000fe4000000003bULL, 0x000000003838783bULL, 0x000e620000004200ULL,
0x00000018ff5c7819ULL, 0x000fe4000001165cULL, 0x00000008ff687819ULL, 0x000fc40000011668ULL,
0x0000005cff66723eULL, 0x000fe200020006ffULL, 0x000000644c54723cULL, 0x000fe20000001854ULL,
0x0000005dff5c723eULL, 0x000fe400020006ffULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x00000068ff5d723eULL, 0x000fe200020006ffULL, 0x000000642c0c723cULL, 0x000fe2000000180cULL,
0x000054105c5c7816ULL, 0x000fe40000000066ULL, 0x000054105d5d7816ULL, 0x000fc40000000067ULL,
0x000000ff5e687812ULL, 0x040fe400078ec0ffULL, 0x00000010ff647819ULL, 0x100fe4000001165eULL,
0x00000018ff657819ULL, 0x000fe2000001165eULL, 0x0000005c4c3c723cULL, 0x000fe2000000183cULL,
0x0000ffff5e6b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5e7819ULL, 0x100fe4000001165fULL,
0x000000ff5f697812ULL, 0x000fe200078ec0ffULL, 0x0000005c2c10723cULL, 0x000fe20000001810ULL,
0x00000018ff6a7819ULL, 0x000fc4000001165fULL, 0x0000ffff5f5f7812ULL, 0x000fe400078ec0ffULL,
0x000000ff64647812ULL, 0x000fe400078ec0ffULL, 0x00000008ff5c7819ULL, 0x000fe4000001166bULL,
0x00000008ff5d7819ULL, 0x000fe4000001165fULL, 0x000000ff5e5e7812ULL, 0x000fe400078ec0ffULL,
0x00000065ff65723eULL, 0x000fc400020006ffULL, 0x0000006aff6a723eULL, 0x000fe400020006ffULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x0000005dff5d723eULL, 0x000fe400020006ffULL,
0x00000068ff68723eULL, 0x000fe400020006ffULL, 0x00000069ff69723eULL, 0x000fe400020006ffULL,
0x00000064ff64723eULL, 0x000fc400020006ffULL, 0x0000005eff5e723eULL, 0x000fe400020006ffULL,
0x000054105c5c7816ULL, 0x000fe40000000065ULL, 0x000054105d5d7816ULL, 0x000fe4000000006aULL,
0x0000541068687816ULL, 0x000fe40000000064ULL, 0x0000541069697816ULL, 0x000fe4000000005eULL,
0x00000010ff5f7819ULL, 0x002fe20000011639ULL, 0x0000005c4c44723cULL, 0x000fe20000001844ULL,
0x000000ff39657812ULL, 0x000fc400078ec0ffULL, 0x00000018ff647819ULL, 0x000fe40000011639ULL,
0x0000ffff396d7812ULL, 0x000fe200078ec0ffULL, 0x0000005c2c18723cULL, 0x000fe20000001818ULL,
0x00000018ff397819ULL, 0x100fe4000001163aULL, 0x0000ffff386c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff667819ULL, 0x000fe2000001163aULL, 0x000000684c40723cULL, 0x000fe20000001840ULL,
0x00000010ff5c7819ULL, 0x000fc40000011638ULL, 0x000000ff3a677812ULL, 0x040fe400078ec0ffULL,
0x0000ffff3a6e7812ULL, 0x000fe200078ec0ffULL, 0x000000682c14723cULL, 0x000fe20000001814ULL,
0x00000018ff6a7819ULL, 0x100fe4000001163bULL, 0x000000ff3b3a7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff3b6f7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff697819ULL, 0x000fc4000001163bULL,
0x00000039ff68723eULL, 0x000fe400020006ffULL, 0x00000018ff5d7819ULL, 0x000fe40000011638ULL,
0x00000008ff397819ULL, 0x000fe4000001166cULL, 0x00000008ff3b7819ULL, 0x000fe4000001166dULL,
0x000000ff385e7812ULL, 0x000fe400078ec0ffULL, 0x000000ff5c5c7812ULL, 0x000fc400078ec0ffULL,
0x000000ff5f5f7812ULL, 0x000fe400078ec0ffULL, 0x0000003aff6b723eULL, 0x000fe400020006ffULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x00000064ff64723eULL, 0x000fe400020006ffULL,
0x00000039ff3a723eULL, 0x000fe400020006ffULL, 0x0000003bff3b723eULL, 0x000fc400020006ffULL,
0x0000005eff38723eULL, 0x000fe400020006ffULL, 0x00000065ff65723eULL, 0x000fe400020006ffULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x000054103a3a7816ULL, 0x000fe4000000005dULL, 0x000054103b3b7816ULL, 0x000fc40000000064ULL,
0x000000ff66667812ULL, 0x000fe400078ec0ffULL, 0x000000ff69697812ULL, 0x000fe400078ec0ffULL,
0x0000541038387816ULL, 0x000fe2000000005cULL, 0x0000003a4c50723cULL, 0x000fe20000001850ULL,
0x0000541065397816ULL, 0x000fe4000000005fULL, 0x00000008ff5c7819ULL, 0x000fe4000001166eULL,
0x00000008ff5f7819ULL, 0x000fe2000001166fULL, 0x0000003a2c20723cULL, 0x000fe20000001820ULL,
0x00000067ff67723eULL, 0x000fc400020006ffULL, 0x00000066ff66723eULL, 0x000fe400020006ffULL,
0x00000069ff69723eULL, 0x000fe200020006ffULL, 0x000000384c48723cULL, 0x000fe20000001848ULL,
0x0000006aff6a723eULL, 0x000fe200020006ffULL, 0x00000001ff3b7424ULL, 0x000fe200078e00ffULL,
0x0000005cff5e723eULL, 0x000fe400020006ffULL, 0x0000005fff5f723eULL, 0x000fe200020006ffULL,
0x000000382c1c723cULL, 0x000fe2000000181cULL, 0x00005410675c7816ULL, 0x000fe20000000066ULL,
0x0000003b063879a7ULL, 0x0002e2000850003fULL, 0x000054106b5d7816ULL, 0x000fc40000000069ULL,
0x000054105e5e7816ULL, 0x000fe40000000068ULL, 0x000054105f5f7816ULL, 0x000fc6000000006aULL,
0x0000005c2c30723cULL, 0x000fe20000001830ULL, 0x000000085a067824ULL, 0x002fca00078e0209ULL,
0x0000005c4c28723cULL, 0x000fe20000001828ULL, 0x01a6a03b06ff79a7ULL, 0x0007ea000850003fULL,
0x0000005e4c24723cULL, 0x000fec0000001824ULL, 0x0000005e2c2c723cULL, 0x000fe20000001834ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0xffffff6000989947ULL, 0x00cfde000383ffffULL,
0x000000ff6100720cULL, 0x000fe20003f05270ULL, 0x000000ffff397224ULL, 0x000fe400078e0041ULL,
0x000000ffff377224ULL, 0x000fe400078e0040ULL, 0x000000ffff357224ULL, 0x000fd000078e003cULL,
0x0000000400648947ULL, 0x000fea0003800000ULL, 0x0180000083007836ULL, 0x000fe20000000000ULL,
0x000000b000007945ULL, 0x000fe80003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x00000000000c0947ULL, 0x000fea0003800000ULL,
0x0000bb8000047802ULL, 0x000fce0000000f00ULL, 0x000000a800647944ULL, 0x016fea0003c00000ULL,
0x0000000000107947ULL, 0x000fea0003800000ULL, 0x0000008300007308ULL, 0x000ee40000001000ULL,
0xbf80000000027423ULL, 0x00afc80000000083ULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000300007223ULL, 0x000fce0000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009800ff027b82ULL, 0x000f640000000a00ULL, 0x0000000602037981ULL, 0x02aee2000c1e9900ULL,
0x0000000000067919ULL, 0x000e640000000000ULL, 0x0000000806057811ULL, 0x042fe400078ff0ffULL,
0x0000001806077811ULL, 0x040fe400078ff0ffULL, 0x00000002ff3b7819ULL, 0x000fe40000011606ULL,
0x0000001006417811ULL, 0x000fe200078ff0ffULL, 0x0000000003007220ULL, 0x00cfca0000410000ULL,
0x00001f3b00047589ULL, 0x000e6800000e0000ULL, 0x00001f0500057589ULL, 0x000ea800000e0000ULL,
0x00001f4100067589ULL, 0x000ee800000e0000ULL, 0x00001f0700077589ULL, 0x000f6200000e0000ULL,
0x0000005404547220ULL, 0x042fe20000410000ULL, 0x0000005504557220ULL, 0x040fe20000410000ULL,
0x0000003504357220ULL, 0x040fe20000410000ULL, 0x0000003d043d7220ULL, 0x040fe20000410000ULL,
0x0000003704377220ULL, 0x040fe20000410000ULL, 0x0000003904397220ULL, 0x040fe20000410000ULL,
0x0000004404447220ULL, 0x040fe20000410000ULL, 0x0000004504457220ULL, 0x040fe20000410000ULL,
0x0000004804487220ULL, 0x040fe20000410000ULL, 0x0000004904497220ULL, 0x040fe20000410000ULL,
0x0000005004507220ULL, 0x040fe20000410000ULL, 0x0000005104517220ULL, 0x040fe20000410000ULL,
0x0000002804287220ULL, 0x040fe20000410000ULL, 0x0000002904297220ULL, 0x040fe20000410000ULL,
0x0000002404247220ULL, 0x040fe20000410000ULL, 0x0000002504257220ULL, 0x000fe20000410000ULL,
0x0000005605567220ULL, 0x044fe20000410000ULL, 0x0000005705577220ULL, 0x040fe20000410000ULL,
0x0000003e053e7220ULL, 0x040fe20000410000ULL, 0x0000003f053f7220ULL, 0x040fe20000410000ULL,
0x0000004205427220ULL, 0x040fe20000410000ULL, 0x0000004305437220ULL, 0x040fe20000410000ULL,
0x0000004605467220ULL, 0x040fe20000410000ULL, 0x0000004705477220ULL, 0x040fe20000410000ULL,
0x0000004a054a7220ULL, 0x040fe20000410000ULL, 0x0000004b054b7220ULL, 0x040fe20000410000ULL,
0x0000005205527220ULL, 0x040fe20000410000ULL, 0x0000005305537220ULL, 0x040fe20000410000ULL,
0x0000002a052a7220ULL, 0x040fe20000410000ULL, 0x0000002b052b7220ULL, 0x040fe20000410000ULL,
0x0000002605267220ULL, 0x040fe20000410000ULL, 0x0000002705277220ULL, 0x000fe20000410000ULL,
0x0000000c060c7220ULL, 0x048fe20000410000ULL, 0x0000000d060d7220ULL, 0x040fe20000410000ULL,
0x0000001006107220ULL, 0x040fe20000410000ULL, 0x0000001106117220ULL, 0x040fe20000410000ULL,
0x0000001406147220ULL, 0x040fe20000410000ULL, 0x0000001506157220ULL, 0x040fe20000410000ULL,
0x0000001806187220ULL, 0x040fe20000410000ULL, 0x0000001906197220ULL, 0x040fe20000410000ULL,
0x0000001c061c7220ULL, 0x040fe20000410000ULL, 0x0000001d061d7220ULL, 0x040fe20000410000ULL,
0x0000002006207220ULL, 0x040fe20000410000ULL, 0x0000002106217220ULL, 0x040fe20000410000ULL,
0x0000003006307220ULL, 0x040fe20000410000ULL, 0x0000003106317220ULL, 0x040fe20000410000ULL,
0x0000002c062c7220ULL, 0x040fe20000410000ULL, 0x0000002d062d7220ULL, 0x000fe20000410000ULL,
0x0000000e070e7220ULL, 0x060fe20000410000ULL, 0x0000000f070f7220ULL, 0x040fe20000410000ULL,
0x0000001207127220ULL, 0x040fe20000410000ULL, 0x0000001307137220ULL, 0x040fe20000410000ULL,
0x0000001607167220ULL, 0x040fe20000410000ULL, 0x0000001707177220ULL, 0x040fe20000410000ULL,
0x0000001a071a7220ULL, 0x040fe20000410000ULL, 0x0000001b071b7220ULL, 0x040fe20000410000ULL,
0x0000001e071e7220ULL, 0x040fe20000410000ULL, 0x0000001f071f7220ULL, 0x040fe20000410000ULL,
0x0000002207227220ULL, 0x040fe20000410000ULL, 0x0000002307237220ULL, 0x040fe20000410000ULL,
0x0000003207327220ULL, 0x040fe20000410000ULL, 0x0000003307337220ULL, 0x040fe20000410000ULL,
0x0000002e072e7220ULL, 0x040fe20000410000ULL, 0x0000002f072f7220ULL, 0x000fce0000410000ULL,
0x0000000000007919ULL, 0x000ee20000000000ULL, 0x0000000178787812ULL, 0x000fe400078ec0ffULL,
0x000000484948723eULL, 0x000fe200000000ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000200078097824ULL, 0x000fe200078e0209ULL, 0x000000505150723eULL, 0x000fc400000000ffULL,
0x000000282928723eULL, 0x000fe400000000ffULL, 0x000000242524723eULL, 0x000fe400000000ffULL,
0x000000565756723eULL, 0x000fe400000000ffULL, 0x0000003e3f3e723eULL, 0x000fe400000000ffULL,
0x000000424342723eULL, 0x000fe400000000ffULL, 0x000000464746723eULL, 0x000fc400000000ffULL,
0x0000004a4b4a723eULL, 0x000fe400000000ffULL, 0x000000525325723eULL, 0x000fe400000000ffULL,
0x0000002a2b2a723eULL, 0x000fe400000000ffULL, 0x000000262726723eULL, 0x000fe400000000ffULL,
0x0000000800057811ULL, 0x048fe400078ff0ffULL, 0x0000000200027812ULL, 0x002fc400078ec0ffULL,
0x00000002ff077819ULL, 0x000fe20000011600ULL, 0x00000008050a7824ULL, 0x000fe200078e00ffULL,
0x0000000502037211ULL, 0x000fe400078ff8ffULL, 0x0000001000057811ULL, 0x040fe200078ff0ffULL,
0x0000000807087824ULL, 0x040fe200078e00ffULL, 0xfffffff80a0a7812ULL, 0x000fe200078ee203ULL,
0x0000000807347824ULL, 0x000fe200078e00ffULL, 0x00000018003b7811ULL, 0x000fe200078ff0ffULL,
0x0000000805417824ULL, 0x000fe200078e00ffULL, 0x0000000702037211ULL, 0x000fc400078ff8ffULL,
0x0000000502047211ULL, 0x040fe200078ff8ffULL, 0x000000083b3c7824ULL, 0x000fe200078e00ffULL,
0x0000003b02057211ULL, 0x000fe200078ff8ffULL, 0x00000008073b7824ULL, 0x000fe200078e00ffULL,
0xfffffff841367812ULL, 0x000fe200078ee204ULL, 0x0000000203027836ULL, 0x000fe20000000000ULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee205ULL, 0x0000000403057836ULL, 0x000fe20000000000ULL,
0x0000000c0d0c723eULL, 0x000fe200000000ffULL, 0x0000000800047824ULL, 0x000fe200078e00ffULL,
0xfffffff83b067812ULL, 0x000fe200078ee202ULL, 0x0000000807027824ULL, 0x000fe200078e00ffULL,
0xfffffff808087812ULL, 0x000fe200078ee205ULL, 0x0000000603077836ULL, 0x000fe20000000000ULL,
0x0000000804057812ULL, 0x000fc400078ec0ffULL, 0xfffffff802027812ULL, 0x000fe200078ee203ULL,
0x0000100062037824ULL, 0x000fe200078e0209ULL, 0xfffffff834347812ULL, 0x000fe400078ee207ULL,
0x000000141514723eULL, 0x000fe200000000ffULL, 0x000000100a387824ULL, 0x100fe200078e0203ULL,
0x0000001c1d1c723eULL, 0x000fe200000000ffULL, 0x00000010363a7824ULL, 0x100fe200078e0203ULL,
0x000000202120723eULL, 0x000fe200000000ffULL, 0x0000001002047824ULL, 0x100fe200078e0203ULL,
0x000000545502723eULL, 0x000fe200000000ffULL, 0x000000103c3c7824ULL, 0x100fe200078e0203ULL,
0x000000303130723eULL, 0x000fe200000000ffULL, 0x0000001006067824ULL, 0x100fe200078e0203ULL,
0x0000000e0f0e723eULL, 0x000fe200000000ffULL, 0x00000010080a7824ULL, 0x100fe200078e0203ULL,
0x000000121307723eULL, 0x000fe200000000ffULL, 0x0000001034367824ULL, 0x000fe200078e0203ULL,
0x000000353d03723eULL, 0x000fe200000000ffULL, 0x0000000104047824ULL, 0x000fe200078e0205ULL,
0x000000161716723eULL, 0x000fe200000000ffULL, 0x0000000105387824ULL, 0x040fe200078e0238ULL,
0x0000541002407816ULL, 0x140fe20000000003ULL, 0x00000001053a7824ULL, 0x040fe200078e023aULL,
0x0000763202417816ULL, 0x000fe20000000003ULL, 0x00000001053c7824ULL, 0x000fe200078e023cULL,
0x000000373902723eULL, 0x000fe200000000ffULL, 0x0000000105087824ULL, 0x000fe200078e0206ULL,
0x000000444503723eULL, 0x000fe200000000ffULL, 0x0000004004007388ULL, 0x0003e20000000a00ULL,
0x0000000105347824ULL, 0x000fe200078e020aULL, 0x000000101106723eULL, 0x000fe200000000ffULL,
0x0000000105367824ULL, 0x000fe200078e0236ULL, 0x0000763202057816ULL, 0x000fc40000000003ULL,
0x00000018190a723eULL, 0x000fe400000000ffULL, 0x0000002c2d18723eULL, 0x000fe400000000ffULL,
0x0000001a1b1a723eULL, 0x000fe400000000ffULL, 0x0000541002047816ULL, 0x002fe40000000003ULL,
0x0000541048027816ULL, 0x140fe40000000050ULL, 0x0000763248037816ULL, 0x000fe20000000050ULL,
0x0000000408007388ULL, 0x000fe20000000a00ULL, 0x0000001e1f1e723eULL, 0x000fc400000000ffULL,
0x00000022230f723eULL, 0x000fe200000000ffULL, 0x0000000234007388ULL, 0x0003e20000000a00ULL,
0x000000323332723eULL, 0x000fe400000000ffULL, 0x0000002e2f19723eULL, 0x000fe400000000ffULL,
0x00007632160d7816ULL, 0x000fe4000000001aULL, 0x000076321e217816ULL, 0x000fe4000000000fULL,
0x0000763232297816ULL, 0x000fc40000000019ULL, 0x000000ff6200720cULL, 0x000fe40003f05270ULL,
0x0000541028027816ULL, 0x142fe40000000024ULL, 0x0000763228037816ULL, 0x000fe40000000024ULL,
0x000054104a247816ULL, 0x140fe40000000025ULL, 0x000076324a257816ULL, 0x000fe20000000025ULL,
0x0000000236007388ULL, 0x0003e20000000a00ULL, 0x0000541032287816ULL, 0x000fc40000000019ULL,
0x0000541056027816ULL, 0x142fe4000000003eULL, 0x0000763256037816ULL, 0x000fca000000003eULL,
0x0000000238007388ULL, 0x0003e40000000a00ULL, 0x0000541042027816ULL, 0x142fe40000000046ULL,
0x0000763242037816ULL, 0x000fca0000000046ULL, 0x0004000208007388ULL, 0x0003e80000000a00ULL,
0x0004002434007388ULL, 0x000fe20000000a00ULL, 0x000054102a027816ULL, 0x142fe40000000026ULL,
0x000076322a037816ULL, 0x000fca0000000026ULL, 0x0004000236007388ULL, 0x0003e40000000a00ULL,
0x000054100c027816ULL, 0x142fe40000000006ULL, 0x000076320c037816ULL, 0x000fe40000000006ULL,
0x000054100e067816ULL, 0x140fe40000000007ULL, 0x000076320e077816ULL, 0x000fe20000000007ULL,
0x000000023a007388ULL, 0x0003e20000000a00ULL, 0x00005410160c7816ULL, 0x000fc4000000001aULL,
0x0000541014027816ULL, 0x142fe4000000000aULL, 0x0000763214037816ULL, 0x000fca000000000aULL,
0x0008000208007388ULL, 0x0003e40000000a00ULL, 0x000054101c027816ULL, 0x142fe40000000020ULL,
0x000076321c037816ULL, 0x000fe40000000020ULL, 0x000054101e207816ULL, 0x000fc6000000000fULL,
0x0008000234007388ULL, 0x0003e40000000a00ULL, 0x0000541030027816ULL, 0x142fe40000000018ULL,
0x0000763230037816ULL, 0x000fca0000000018ULL, 0x0008000236007388ULL, 0x0003e80000000a00ULL,
0x000000063c007388ULL, 0x000fe80000000a00ULL, 0x000c000c08007388ULL, 0x000fe20000000a00ULL,
0x000000015b027824ULL, 0x002fc600078e0200ULL, 0x000c002034007388ULL, 0x000fe20000000a00ULL,
0x0000001002027824ULL, 0x000fc600078e0209ULL, 0x000c002836007388ULL, 0x000fe20000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000002047984ULL, 0x000e680000000c00ULL,
0x0004000002107984ULL, 0x000ee80000000c00ULL, 0x0008000002187984ULL, 0x000f680000000c00ULL,
0x000c000002207984ULL, 0x000f680000000c00ULL, 0x00100000020c7984ULL, 0x000f680000000c00ULL,
0x0014000002147984ULL, 0x000f680000000c00ULL, 0x00180000021c7984ULL, 0x000f680000000c00ULL,
0x001c000002247984ULL, 0x000f620000000c00ULL, 0x200000ff07077230ULL, 0x002fc40000000000ULL,
0x200000ff06067230ULL, 0x000fe40000000000ULL, 0x200000ff05057230ULL, 0x000fe40000000000ULL,
0x200000ff04047230ULL, 0x000fe40000000000ULL, 0x200000ff13137230ULL, 0x008fe40000000000ULL,
0x200000ff12127230ULL, 0x000fe40000000000ULL, 0x200000ff11117230ULL, 0x000fc40000000000ULL,
0x200000ff10107230ULL, 0x000fe40000000000ULL, 0x200000ff1b1b7230ULL, 0x024fe40000000000ULL,
0x200000ff1a1a7230ULL, 0x000fe40000000000ULL, 0x200000ff19197230ULL, 0x000fe40000000000ULL,
0x200000ff18187230ULL, 0x000fe40000000000ULL, 0x200000ff23237230ULL, 0x000fc40000000000ULL,
0x200000ff22227230ULL, 0x000fe40000000000ULL, 0x200000ff21217230ULL, 0x000fe40000000000ULL,
0x200000ff20207230ULL, 0x000fe40000000000ULL, 0x0000000f07077230ULL, 0x000fe40000000000ULL,
0x0000000e06067230ULL, 0x000fe40000000000ULL, 0x0000000d05057230ULL, 0x000fc40000000000ULL,
0x0000000c04047230ULL, 0x000fe40000000000ULL, 0x0000001713137230ULL, 0x000fe40000000000ULL,
0x0000001612127230ULL, 0x000fe20000000000ULL, 0x0000000402007388ULL, 0x0003e20000000c00ULL,
0x0000001511117230ULL, 0x000fe40000000000ULL, 0x0000001410107230ULL, 0x000fe40000000000ULL,
0x0000001f1b1b7230ULL, 0x000fc40000000000ULL, 0x0000001e1a1a7230ULL, 0x000fe20000000000ULL,
0x0004001002007388ULL, 0x0003e20000000c00ULL, 0x0000001d19197230ULL, 0x000fe40000000000ULL,
0x0000001c18187230ULL, 0x000fe40000000000ULL, 0x0000002723237230ULL, 0x000fe40000000000ULL,
0x0000002622227230ULL, 0x000fe20000000000ULL, 0x0008001802007388ULL, 0x0003e20000000c00ULL,
0x0000002521217230ULL, 0x000fc40000000000ULL, 0x0000002420207230ULL, 0x000fca0000000000ULL,
0x000c002002007388ULL, 0x0003e20000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000000479c3ULL, 0x000ea20000002700ULL,
0x00000003ff047819ULL, 0x002fe20000011600ULL, 0x0000840000057ab9ULL, 0x000fc60000000800ULL,
0x000000750400720cULL, 0x000fe20003f06070ULL, 0x00000005040472a4ULL, 0x004fd8000f8e023fULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000104027824ULL, 0x000fe200078e0200ULL,
0x00008600000a7ab9ULL, 0x000fe20000000800ULL, 0xffffffff00057882ULL, 0x000fe20000000000ULL,
0x0000880000087ab9ULL, 0x000fe20000000a00ULL, 0x0000000a05057299ULL, 0x000fe2000800063fULL,
0x0000000702037812ULL, 0x000fe200078ec0ffULL, 0x0000002000067836ULL, 0x000fc60000000000ULL,
0x0ffffff803027812ULL, 0x000fca00078ef800ULL, 0x0000001002037824ULL, 0x000fe400078e0209ULL,
0x0000002077027824ULL, 0x000fc600078e0204ULL, 0x00000000030c7984ULL, 0x0002a40000000c00ULL,
0x0000000502057c12ULL, 0x000fe4000f8e30ffULL, 0x0000000aff047c19ULL, 0x000fe20008011602ULL,
0x000000040b027c24ULL, 0x000fe4000f8e02ffULL, 0x0000000176057824ULL, 0x000fe200078e0205ULL,
0x0000000700037812ULL, 0x002fc600078ec0ffULL, 0x0000000b04057224ULL, 0x000fe400078e0205ULL,
0x0000000878037824ULL, 0x000fc600078e0203ULL, 0x0000000502057210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff087224ULL, 0x000fe200000e06ffULL, 0x0000000805047c11ULL, 0x000fc8000f8040ffULL,
0x0000000905057c11ULL, 0x000fe400080f4408ULL, 0x00000003ff087819ULL, 0x000fe20000011606ULL,
0x0000001003047825ULL, 0x000fc600078e0004ULL, 0x000000750800720cULL, 0x000fe40003f06070ULL,
0x0000000c04007986ULL, 0x0043f6000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000106037824ULL, 0x140fe200078e0208ULL, 0x0000000706077812ULL, 0x000fe200078ec0ffULL,
0x0000002077087824ULL, 0x000fc600078e0208ULL, 0x0000000703037812ULL, 0x000fe200078ec0ffULL,
0x0000000878077824ULL, 0x000fe200078e0207ULL, 0x0000000508057c12ULL, 0x002fe4000f8e30ffULL,
0x0ffffff803047812ULL, 0x000fe400078ef806ULL, 0x0000000aff087c19ULL, 0x000fe20008011608ULL,
0x0000000176057824ULL, 0x000fe400078e0205ULL, 0x0000001004037824ULL, 0x000fe400078e0209ULL,
0x0000000b08057224ULL, 0x000fc600078e0205ULL, 0x00000000030c7984ULL, 0x0002a40000000c00ULL,
0x0000000502057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x0000000805047c11ULL, 0x000fe2000f8040ffULL, 0x0000004000037836ULL, 0x002fc60000000000ULL,
0x0000000905057c11ULL, 0x000fe400080f4408ULL, 0x00000003ff067819ULL, 0x000fe20000011603ULL,
0x0000001007047825ULL, 0x000fc600078e0004ULL, 0x000000750600720cULL, 0x000fe40003f06070ULL,
0x0000000c04007986ULL, 0x0043f6000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000103047824ULL, 0x102fe400078e0206ULL, 0x0000002077067824ULL, 0x000fc600078e0206ULL,
0x0000000704047812ULL, 0x000fe400078ec0ffULL, 0x0000000506057c12ULL, 0x000fe4000f8e30ffULL,
0x0ffffff804047812ULL, 0x000fe400078ef803ULL, 0x0000000aff067c19ULL, 0x000fe20008011606ULL,
0x0000000176057824ULL, 0x000fe200078e0205ULL, 0x0000000703037812ULL, 0x000fe200078ec0ffULL,
0x0000001004077824ULL, 0x000fe400078e0209ULL, 0x0000000b06057224ULL, 0x000fc400078e0205ULL,
0x0000000878037824ULL, 0x000fe200078e0203ULL, 0x00000000070c7984ULL, 0x000e640000000c00ULL,
0x0000000502057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff067224ULL, 0x000fe200000e06ffULL,
0x0000000805047c11ULL, 0x000fc8000f8040ffULL, 0x0000000905057c11ULL, 0x000fe200080f4406ULL,
0x0000006000067836ULL, 0x000fe40000000000ULL, 0x0000001003047825ULL, 0x000fc600078e0004ULL,
0x00000003ff087819ULL, 0x000fc80000011606ULL, 0x000000750800720cULL, 0x000fe20003f06070ULL,
0x0000000c04007986ULL, 0x0023d8000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000106037824ULL, 0x140fe200078e0208ULL, 0x0000000706077812ULL, 0x000fe200078ec0ffULL,
0x0000002077087824ULL, 0x000fc600078e0208ULL, 0x0000000703037812ULL, 0x000fe200078ec0ffULL,
0x0000000878077824ULL, 0x000fe200078e0207ULL, 0x0000000508057c12ULL, 0x002fe4000f8e30ffULL,
0x0ffffff803047812ULL, 0x000fe400078ef806ULL, 0x0000000aff087c19ULL, 0x000fe20008011608ULL,
0x0000000176057824ULL, 0x000fe400078e0205ULL, 0x0000001004037824ULL, 0x000fe400078e0209ULL,
0x0000000b08057224ULL, 0x000fc600078e0205ULL, 0x00000000030c7984ULL, 0x0002a40000000c00ULL,
0x0000000502057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x0000000805047c11ULL, 0x000fe2000f8040ffULL, 0x0000008000037836ULL, 0x002fc60000000000ULL,
0x0000000905057c11ULL, 0x000fe400080f4408ULL, 0x00000003ff067819ULL, 0x000fe20000011603ULL,
0x0000001007047825ULL, 0x000fc600078e0004ULL, 0x000000750600720cULL, 0x000fe40003f06070ULL,
0x0000000c04007986ULL, 0x0043f6000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000103047824ULL, 0x102fe400078e0206ULL, 0x0000002077067824ULL, 0x000fc600078e0206ULL,
0x0000000704047812ULL, 0x000fe400078ec0ffULL, 0x0000000506057c12ULL, 0x000fe4000f8e30ffULL,
0x0ffffff804047812ULL, 0x000fe400078ef803ULL, 0x0000000aff067c19ULL, 0x000fe20008011606ULL,
0x0000000176057824ULL, 0x000fe200078e0205ULL, 0x0000000703037812ULL, 0x000fe200078ec0ffULL,
0x0000001004077824ULL, 0x000fe400078e0209ULL, 0x0000000b06057224ULL, 0x000fc400078e0205ULL,
0x0000000878037824ULL, 0x000fe200078e0203ULL, 0x00000000070c7984ULL, 0x000e640000000c00ULL,
0x0000000502057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff067224ULL, 0x000fe200000e06ffULL,
0x0000000805047c11ULL, 0x000fc8000f8040ffULL, 0x0000000905057c11ULL, 0x000fe200080f4406ULL,
0x000000a000067836ULL, 0x000fe40000000000ULL, 0x0000001003047825ULL, 0x000fc600078e0004ULL,
0x00000003ff087819ULL, 0x000fc80000011606ULL, 0x000000750800720cULL, 0x000fe20003f06070ULL,
0x0000000c04007986ULL, 0x0023d8000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000106037824ULL, 0x140fe200078e0208ULL, 0x0000000706077812ULL, 0x000fe200078ec0ffULL,
0x0000002077087824ULL, 0x000fc600078e0208ULL, 0x0000000703037812ULL, 0x000fe200078ec0ffULL,
0x0000000878077824ULL, 0x000fe200078e0207ULL, 0x0000000508057c12ULL, 0x002fe4000f8e30ffULL,
0x0ffffff803047812ULL, 0x000fe400078ef806ULL, 0x0000000aff087c19ULL, 0x000fe20008011608ULL,
0x0000000176057824ULL, 0x000fe400078e0205ULL, 0x0000001004037824ULL, 0x000fe400078e0209ULL,
0x0000000b08057224ULL, 0x000fc600078e0205ULL, 0x00000000030c7984ULL, 0x0002a40000000c00ULL,
0x0000000502057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x0000000805047c11ULL, 0x000fe2000f8040ffULL, 0x000000c000037836ULL, 0x002fc60000000000ULL,
0x0000000905057c11ULL, 0x000fe400080f4408ULL, 0x00000003ff067819ULL, 0x000fe20000011603ULL,
0x0000001007047825ULL, 0x000fc600078e0004ULL, 0x000000750600720cULL, 0x000fe40003f06070ULL,
0x0000000c04007986ULL, 0x0043f6000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000103047824ULL, 0x102fe400078e0206ULL, 0x0000002077067824ULL, 0x000fe400078e0206ULL,
0x000000e000007836ULL, 0x000fe20000000000ULL, 0x0000000704047812ULL, 0x000fe400078ec0ffULL,
0x0000000506057c12ULL, 0x000fe4000f8e30ffULL, 0x0ffffff804047812ULL, 0x000fe400078ef803ULL,
0x0000000aff067c19ULL, 0x000fe20008011606ULL, 0x0000000176057824ULL, 0x000fe200078e0205ULL,
0x0000000703037812ULL, 0x000fe200078ec0ffULL, 0x0000001004077824ULL, 0x000fc400078e0209ULL,
0x0000000b06057224ULL, 0x000fe200078e0205ULL, 0x00000003ff067819ULL, 0x000fe20000011600ULL,
0x0000000878037824ULL, 0x000fe200078e0203ULL, 0x00000000070c7984ULL, 0x0002a40000000c00ULL,
0x0000000502057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x0000000805047c11ULL, 0x000fe2000f8040ffULL, 0x0000000100077824ULL, 0x002fc600078e0206ULL,
0x0000000905057c11ULL, 0x000fe400080f4408ULL, 0x000000750600720cULL, 0x000fe40003f06070ULL,
0x0000000707077812ULL, 0x000fe200078ec0ffULL, 0x0000001003047825ULL, 0x000fc600078e0004ULL,
0xfffffff807087812ULL, 0x000fe400078ef800ULL, 0x0000000c04007986ULL, 0x0043ea000c101d06ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000001008087824ULL, 0x000fe200078e0209ULL,
0x0000000700057812ULL, 0x002fe200078ec0ffULL, 0x0000002077067824ULL, 0x000fc600078e0206ULL,
0x00000000080c7984ULL, 0x000e620000000c00ULL, 0x0000000878057824ULL, 0x000fe200078e0205ULL,
0x0000000506037c12ULL, 0x000fe4000f8e30ffULL, 0x0000000aff067c19ULL, 0x000fc60008011606ULL,
0x0000000176037824ULL, 0x000fc800078e0203ULL, 0x0000000b06037224ULL, 0x000fca00078e0203ULL,
0x0000000302037210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff047224ULL, 0x000fe200000e06ffULL,
0x0000000803027c11ULL, 0x000fc8000f8040ffULL, 0x0000000903037c11ULL, 0x000fc600080f4404ULL,
0x0000001005027825ULL, 0x000fca00078e0002ULL, 0x0000000c02007986ULL, 0x002fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff7a7819ULL, 0x000fe20000011678ULL,
0x00009800ff5e7b82ULL, 0x000e620000000a00ULL, 0x00000001ff067424ULL, 0x000fe400078e00ffULL,
0x000000637a00720cULL, 0x000fe20003f06070ULL, 0xffffffffff0b7424ULL, 0x000fc800078e00ffULL,
0x00008e00ff0c7b82ULL, 0x000eb00000000a00ULL, 0x00009400ff028b82ULL, 0x000ee20000000800ULL,
0x0000000279078824ULL, 0x000fce00078e00ffULL, 0x00009000ff0e8b82ULL, 0x000f620000000a00ULL,
0x000000065e5e7981ULL, 0x002322000c1e9900ULL, 0x0000000207078224ULL, 0x008fc800078e027aULL,
0x00000004070e8825ULL, 0x020fe400078e000eULL, 0x01a60006090679a7ULL, 0x000266000850003fULL,
0x000000060e0b8981ULL, 0x000ee2000c1e1900ULL, 0x000001ff0500780cULL, 0x000fe20003f04070ULL,
0x0000008003027824ULL, 0x000fe400078e00ffULL, 0x0000008059037824ULL, 0x000fe400078e00ffULL,
0x00000040787b7824ULL, 0x000fca00078e00ffULL, 0x0000004003057812ULL, 0x000fe200078ef87bULL,
0x0000000b020b7224ULL, 0x008fc800078e02ffULL, 0x000000800b0c7825ULL, 0x004fe200078e000cULL,
0x0000000c00200947ULL, 0x002fec0003800000ULL, 0x00000003ff377819ULL, 0x000fe4000001160aULL,
0x0000007b74087248ULL, 0x000fc60007fe0000ULL, 0x0000000837177836ULL, 0x000fe40000000000ULL,
0x00000001050e7824ULL, 0x000fe400078e0237ULL, 0x00000001170f7824ULL, 0x040fe400078e020aULL,
0x0000000817147824ULL, 0x000fe400078e00ffULL, 0x0000000437117836ULL, 0x000fe40000000000ULL,
0x0000001037137836ULL, 0x000fe20000000000ULL, 0xfffffff814257812ULL, 0x000fe200078ee20fULL,
0x000000800e0e7825ULL, 0x000fc800078e00ffULL, 0x00000001110b7824ULL, 0x140fe200078e020aULL,
0x000000700e1b7812ULL, 0x000fe200078ef804ULL, 0x0000000811127824ULL, 0x000fe400078e00ffULL,
0x0000000108087824ULL, 0x000fe200078e0a7bULL, 0x0000001b0c1a7210ULL, 0x000fe20007f1e0ffULL,
0x00000001130e7824ULL, 0x040fe200078e020aULL, 0xfffffff812237812ULL, 0x000fe200078ee20bULL,
0x0000000813297824ULL, 0x000fe200078e00ffULL, 0x000000081100720cULL, 0x000fe20003fa6070ULL,
0x0000000c37197836ULL, 0x000fc40000000000ULL, 0x0000000105107824ULL, 0x000fe200078e0211ULL,
0xfffffff829297812ULL, 0x000fe200078ee20eULL, 0x00000001190b7824ULL, 0x040fe200078e020aULL,
0x000000081900720cULL, 0x040fe20003f46070ULL, 0x0000000819127824ULL, 0x000fe400078e00ffULL,
0x0000008010107825ULL, 0x000fc600078e00ffULL, 0xfffffff812277812ULL, 0x000fe200078ee20bULL,
0x00000001050e7824ULL, 0x000fe200078e0217ULL, 0x0000007010157812ULL, 0x000fe200078ef804ULL,
0x000000010d1b7824ULL, 0x000fe200000e060fULL, 0x000000081300720cULL, 0x000fe20003f06070ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000150c107210ULL, 0x000fc60007f3e0ffULL,
0x0000000105127824ULL, 0x040fe200078e0219ULL, 0x000000700e1d7812ULL, 0x000fe200078ef804ULL,
0x0000000105147824ULL, 0x000fe400078e0213ULL, 0x0000001437217836ULL, 0x000fe20000000000ULL,
0x0000001d0c1c7210ULL, 0x000fe20007f7e0ffULL, 0x00000018372d7836ULL, 0x000fe40000000000ULL,
0x0000008012127825ULL, 0x000fc800078e00ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x00000070121f7812ULL, 0x000fc600078ef804ULL, 0x0000000105167824ULL, 0x040fe200078e0221ULL,
0x00000070140b7812ULL, 0x000fe200078ef804ULL, 0x0000000105187824ULL, 0x000fe200078e022dULL,
0x0000001f0c1e7210ULL, 0x000fe20007f9e0ffULL, 0x000000010d117824ULL, 0x000fe200008e0611ULL,
0x000000081700720cULL, 0x000fe20003f26070ULL, 0x0000008016167825ULL, 0x000fc800078e00ffULL,
0x0000008018187825ULL, 0x000fc800078e00ffULL, 0x000000010d1d7824ULL, 0x040fe200018e060fULL,
0x0000000b0c127210ULL, 0x000fe20007f7e0ffULL, 0x0000001c372f7836ULL, 0x000fe20000000000ULL,
0x00000070160f7812ULL, 0x000fe200078ef804ULL, 0x000000010d1f7824ULL, 0x000fe200020e0613ULL,
0x00000070180b7812ULL, 0x000fe200078ef804ULL, 0x00000001050e7824ULL, 0x000fe400078e022fULL,
0x000000010d137824ULL, 0x000fe200018e0615ULL, 0x0000000f0c147210ULL, 0x000fe20007f7e0ffULL,
0x0000000137187824ULL, 0x000fe200078e020aULL, 0x0000000b0c167210ULL, 0x000fe20007f9e0ffULL,
0x000000800e0e7825ULL, 0x000fc600078e00ffULL, 0x00000007182b7812ULL, 0x000fe200078ec0ffULL,
0x00004000780b7824ULL, 0x000fe400078e0209ULL, 0x000000010d157824ULL, 0x000fe200018e0617ULL,
0x000000082100720cULL, 0x080fe20003f66070ULL, 0x000000010d177824ULL, 0x000fe200020e0619ULL,
0x000000700e197812ULL, 0x000fe200078ef804ULL, 0x000020000b247836ULL, 0x000fe20000000000ULL,
0x000000083700720cULL, 0x000fe20003f86070ULL, 0x0000002037317836ULL, 0x000fe20000000000ULL,
0x000000190c207210ULL, 0x000fe20007fde0ffULL, 0x00000001210b7824ULL, 0x000fc400078e020aULL,
0x0000000821187824ULL, 0x000fe200078e00ffULL, 0x0ffffff82b217812ULL, 0x000fe200078ef80aULL,
0x00000001050e7824ULL, 0x000fe400078e0231ULL, 0x0000002437337836ULL, 0x000fe20000000000ULL,
0xfffffff8182b7812ULL, 0x000fe200078ee20bULL, 0x00000010210b7824ULL, 0x000fe400078e0224ULL,
0x000000010d217824ULL, 0x000fe400030e060fULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a0b7faeULL, 0x0003e2000e101c46ULL,
0x000000082d00720cULL, 0x000fc40003f86070ULL, 0x0000000105187824ULL, 0x000fe200078e0233ULL,
0x000000700e197812ULL, 0x000fe200078ef804ULL, 0x0000002837357836ULL, 0x000fe40000000000ULL,
0x000000012d0e7824ULL, 0x040fe200078e020aULL, 0x000000190c227210ULL, 0x000fe20007fde0ffULL,
0x000000082d2d7824ULL, 0x000fe400078e00ffULL, 0x0000008018187825ULL, 0x000fc600078e00ffULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee20eULL, 0x0000000105267824ULL, 0x000fe200078e0235ULL,
0x00000070181b7812ULL, 0x002fe200078ef804ULL, 0x00000010230b7824ULL, 0x000fe400078e0224ULL,
0x000000010d237824ULL, 0x000fe200030e060fULL, 0x0000001b0c187210ULL, 0x000fe20007fde0ffULL,
0x00000080260e7825ULL, 0x000fe200078e00ffULL, 0x00000000100b7faeULL, 0x0003e2000e901c46ULL,
0x000000082f00720cULL, 0x040fe40003fa6070ULL, 0x000000012f1a7824ULL, 0x040fe200078e020aULL,
0x000000700e1b7812ULL, 0x000fe200078ef804ULL, 0x000000082f397824ULL, 0x000fc400078e00ffULL,
0x0000001025257824ULL, 0x100fe400078e0224ULL, 0x0000002c372f7836ULL, 0x000fe40000000000ULL,
0x0000001027277824ULL, 0x000fe200078e0224ULL, 0x000000001c257faeULL, 0x000fe2000c901c46ULL,
0x00000001310b7824ULL, 0x042fe200078e020aULL, 0x000000083100720cULL, 0x0c0fe20003f26070ULL,
0x0000000831267824ULL, 0x000fe200078e00ffULL, 0x000000001e277faeULL, 0x0003e2000d101c46ULL,
0x0000000105107824ULL, 0x000fe200078e022fULL, 0x000000083300720cULL, 0x000fe20003f46070ULL,
0x0000001029297824ULL, 0x000fe200078e0224ULL, 0xfffffff8260b7812ULL, 0x000fe200078ee20bULL,
0x000000010d197824ULL, 0x000fe200030e0619ULL, 0x0000001b0c0e7210ULL, 0x000fe20007fde0ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0xfffffff8391b7812ULL, 0x000fe200078ee21aULL,
0x0000000012297faeULL, 0x0005e4000c101c46ULL, 0x00000001331a7824ULL, 0x000fe200078e020aULL,
0x0000007010317812ULL, 0x000fe200078ef804ULL, 0x00000030371f7836ULL, 0x002fc40000000000ULL,
0x000000102b2b7824ULL, 0x100fe400078e0224ULL, 0x0000000833337824ULL, 0x000fe400078e00ffULL,
0x000000102d2d7824ULL, 0x100fe200078e0224ULL, 0x00000000142b7faeULL, 0x0003e2000d901c46ULL,
0x0000000105127824ULL, 0x004fe200078e021fULL, 0xfffffff8331d7812ULL, 0x000fe200078ee21aULL,
0x000000101b1b7824ULL, 0x100fe200078e0224ULL, 0x00000000162d7faeULL, 0x0005e2000e101c46ULL,
0x000000100b0b7824ULL, 0x000fe200078e0224ULL, 0x000000082f00720cULL, 0x080fe20003f86070ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x00000000201b7faeULL, 0x000fe2000e901c46ULL,
0x000000083500720cULL, 0x000fc40003fa6070ULL, 0x000000010d0f7824ULL, 0x000fe200030e060fULL,
0x000000310c107210ULL, 0x000fe20007fde0ffULL, 0x0000003437257836ULL, 0x000fe20000000000ULL,
0x00000000220b7faeULL, 0x0007e2000c901c46ULL, 0x000000101d1d7824ULL, 0x000fe200078e0224ULL,
0x000000081f00720cULL, 0x080fe20003f66070ULL, 0x0000000105147824ULL, 0x002fe400078e0225ULL,
0x000000010d117824ULL, 0x000fe200030e0611ULL, 0x00000000181d7faeULL, 0x0003e2000d101c46ULL,
0x0000000135177824ULL, 0x004fe200078e020aULL, 0x000000082500720cULL, 0x000fe20003f46070ULL,
0x00000008351a7824ULL, 0x000fc400078e00ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x00000070120b7812ULL, 0x008fc600078ef804ULL, 0x0000003837277836ULL, 0x000fe20000000000ULL,
0x0000000b0c167210ULL, 0x000fe20007fde0ffULL, 0x0000003c37297836ULL, 0x000fe20000000000ULL,
0xfffffff81a197812ULL, 0x002fe200078ee217ULL, 0x000000011f0b7824ULL, 0x100fe200078e020aULL,
0x000000082700720cULL, 0x080fe20003f26070ULL, 0x000000010d177824ULL, 0x000fe200030e0613ULL,
0x0000007014137812ULL, 0x000fe200078ef804ULL, 0x000000081f187824ULL, 0x000fe200078e00ffULL,
0x000000082900720cULL, 0x000fe20003f06070ULL, 0x0000000105127824ULL, 0x000fe200078e0227ULL,
0x000000130c147210ULL, 0x000fe20007fde0ffULL, 0x000000012f087824ULL, 0x040fe200078e020aULL,
0xfffffff8181d7812ULL, 0x000fe200078ee20bULL, 0x000000082f1b7824ULL, 0x000fc400078e00ffULL,
0x0000008012127825ULL, 0x000fc600078e00ffULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee208ULL,
0x00000001050b7824ULL, 0x000fe200078e0229ULL, 0x0000007012057812ULL, 0x000fe200078ef804ULL,
0x0000000125087824ULL, 0x100fe400078e020aULL, 0x0000000127187824ULL, 0x100fe400078e020aULL,
0x00000001291a7824ULL, 0x000fe400078e020aULL, 0x000000800b0a7825ULL, 0x000fc800078e00ffULL,
0x000000010d157824ULL, 0x000fe200030e0615ULL, 0x000000050c127210ULL, 0x000fe20007fde0ffULL,
0x0000000825257824ULL, 0x000fe200078e00ffULL, 0x000000700a1f7812ULL, 0x000fe200078ef804ULL,
0x0000000827217824ULL, 0x000fe400078e00ffULL, 0x0000000829237824ULL, 0x000fe200078e00ffULL,
0xfffffff825057812ULL, 0x000fe200078ee208ULL, 0x000000010d137824ULL, 0x000fe200030e0613ULL,
0xfffffff821217812ULL, 0x000fe200078ee218ULL, 0x0000001019197824ULL, 0x100fe200078e0224ULL,
0xfffffff823237812ULL, 0x000fe200078ee21aULL, 0x000000101b1b7824ULL, 0x100fe200078e0224ULL,
0x0000001f0c047210ULL, 0x000fe20007fde0ffULL, 0x000000101d1d7824ULL, 0x100fe200078e0224ULL,
0x000000000e197faeULL, 0x0003e2000e901c46ULL, 0x00000010051f7824ULL, 0x000fc400078e0224ULL,
0x0000001021217824ULL, 0x100fe200078e0224ULL, 0x00000000101b7faeULL, 0x0003e2000e101c46ULL,
0x0000001023237824ULL, 0x000fe400078e0224ULL, 0x000000010d057824ULL, 0x000fe200030e060bULL,
0x00000000161d7faeULL, 0x0003e8000d901c46ULL, 0x00000000141f7faeULL, 0x0003e8000d101c46ULL,
0x0000000012217faeULL, 0x0003e8000c901c46ULL, 0x0000000004237faeULL, 0x0003e2000c101c46ULL,
0x0000000800d07947ULL, 0x000fea0003800000ULL, 0x000000100a157811ULL, 0x040fe400078fe8ffULL,
0x000000040a0e7811ULL, 0x040fe400078fe8ffULL, 0x000000080a107811ULL, 0x040fe200078fe8ffULL,
0x0000000115167824ULL, 0x140fe200078e020aULL, 0x0000000c0a117811ULL, 0x040fe200078fe8ffULL,
0x0000000815177824ULL, 0x000fe200078e00ffULL, 0x000000200a1d7811ULL, 0x000fe200078fe8ffULL,
0x000000010e087824ULL, 0x100fe200078e020aULL, 0x0000001c0a1b7811ULL, 0x000fe200078fe8ffULL,
0x000000080e137824ULL, 0x000fe200078e00ffULL, 0xfffffff817167812ULL, 0x000fe200078ee216ULL,
0x00000001100b7824ULL, 0x100fe200078e020aULL, 0x000000140a177811ULL, 0x000fe200078fe8ffULL,
0x0000000810147824ULL, 0x000fe200078e00ffULL, 0xfffffff813127812ULL, 0x000fe200078ee208ULL,
0x00000001110f7824ULL, 0x140fe200078e020aULL, 0x000000180a197811ULL, 0x040fe200078fe8ffULL,
0x0000000811187824ULL, 0x000fe200078e00ffULL, 0xfffffff814137812ULL, 0x000fe200078ee20bULL,
0x0000000117087824ULL, 0x140fe200078e020aULL, 0x0000002c0a237811ULL, 0x040fe200078fe8ffULL,
0x00000008171f7824ULL, 0x000fe200078e00ffULL, 0xfffffff818147812ULL, 0x000fe200078ee20fULL,
0x000000011d1e7824ULL, 0x140fe200078e020aULL, 0x000000300a297811ULL, 0x040fe200078fe8ffULL,
0x000000081d217824ULL, 0x000fe200078e00ffULL, 0xfffffff81f187812ULL, 0x000fe200078ee208ULL,
0x000000011b0f7824ULL, 0x140fe200078e020aULL, 0x000000240a1f7811ULL, 0x040fe200078fe8ffULL,
0x000000081b1c7824ULL, 0x000fe200078e00ffULL, 0xfffffff8211e7812ULL, 0x000fe200078ee21eULL,
0x00000001190b7824ULL, 0x100fe200078e020aULL, 0x000000280a217811ULL, 0x040fe200078fe8ffULL,
0x000000011f087824ULL, 0x140fe200078e020aULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee20fULL,
0x000000081f257824ULL, 0x000fe200078e00ffULL, 0x000000340a2b7811ULL, 0x040fe200078fe8ffULL,
0x00000008191a7824ULL, 0x000fe200078e00ffULL, 0x000000380a2d7811ULL, 0x040fe200078fe8ffULL,
0x00000001230f7824ULL, 0x140fe200078e020aULL, 0xfffffff825207812ULL, 0x000fe200078ee208ULL,
0x0000000823287824ULL, 0x000fe200078e00ffULL, 0x0000000a0a087211ULL, 0x040fe200078fe8ffULL,
0x0000000821227824ULL, 0x040fe200078e00ffULL, 0xfffffff81a1a7812ULL, 0x000fe200078ee20bULL,
0x00000001210b7824ULL, 0x100fe200078e020aULL, 0xfffffff828287812ULL, 0x000fe200078ee20fULL,
0x0000000129247824ULL, 0x140fe200078e020aULL, 0x0000003c0a2f7811ULL, 0x000fe200078fe8ffULL,
0x0000000829277824ULL, 0x000fe200078e00ffULL, 0x00000007080f7812ULL, 0x000fe200078ec0ffULL,
0x0000000105087824ULL, 0x000fe200078e0211ULL, 0xfffffff822227812ULL, 0x000fe200078ee20bULL,
0x000000012b117824ULL, 0x040fe200078e020aULL, 0xfffffff8272a7812ULL, 0x000fe200078ee224ULL,
0x000000082b347824ULL, 0x000fe200078e00ffULL, 0x000000050a0b7211ULL, 0x000fe200078fe8ffULL,
0x00000001050e7824ULL, 0x000fc400078e020eULL, 0x0000000105107824ULL, 0x040fe400078e0210ULL,
0x0000000105157824ULL, 0x040fe400078e0215ULL, 0x0000000105177824ULL, 0x040fe400078e0217ULL,
0x0000000105197824ULL, 0x040fe400078e0219ULL, 0x00000001051b7824ULL, 0x040fe400078e021bULL,
0x0000000105247824ULL, 0x040fe200078e021dULL, 0xfffffff8341d7812ULL, 0x000fe200078ee211ULL,
0x0000000105257824ULL, 0x000fc400078e021fULL, 0x0000000105267824ULL, 0x040fe400078e0221ULL,
0x0000000105277824ULL, 0x040fe400078e0223ULL, 0x00000001052c7824ULL, 0x040fe400078e0229ULL,
0x00000001052e7824ULL, 0x040fe400078e022bULL, 0x0000000105307824ULL, 0x040fe400078e022dULL,
0x0000000105327824ULL, 0x000fe200078e022fULL, 0x0ffffff80f057812ULL, 0x000fe200078ef80aULL,
0x000000012f0f7824ULL, 0x000fc400078e020aULL, 0x000000082f387824ULL, 0x000fe400078e00ffULL,
0x0000400078117824ULL, 0x000fe400078e0209ULL, 0x000000012d1f7824ULL, 0x000fe200078e020aULL,
0xfffffff838217812ULL, 0x000fe200078ee20fULL, 0x000000800b0a7825ULL, 0x000fc800078e00ffULL,
0x00002000114b7836ULL, 0x000fe20000000000ULL, 0x000000700a237812ULL, 0x000fe200078ef804ULL,
0x000000800e0e7825ULL, 0x000fc600078e00ffULL, 0x000000230c0a7210ULL, 0x000fe20007f1e0ffULL,
0x000000082d367824ULL, 0x000fe400078e00ffULL, 0x00000010052d7824ULL, 0x100fe200078e024bULL,
0x000000700e057812ULL, 0x000fe200078ef804ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0xfffffff8361f7812ULL, 0x000fe400078ee21fULL, 0x000000050c0e7210ULL, 0x000fe20007f3e0ffULL,
0x00000010122f7824ULL, 0x100fe200078e024bULL, 0x0000007010057812ULL, 0x000fe200078ef804ULL,
0x0000001013317824ULL, 0x000fc400078e024bULL, 0x0000008008127825ULL, 0x000fc800078e00ffULL,
0x000000010d0b7824ULL, 0x000fe200000e060bULL, 0x000000050c107210ULL, 0x000fe20007f1e0ffULL,
0x000000101d477824ULL, 0x100fe200078e024bULL, 0x00000070121d7812ULL, 0x000fe200078ef804ULL,
0x0000001016357824ULL, 0x100fe200078e024bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a2d7faeULL, 0x0003e2000b901c46ULL, 0x0000001014337824ULL, 0x000fe400078e024bULL,
0x0000008017167825ULL, 0x000fc800078e00ffULL, 0x0000008015147825ULL, 0x000fc800078e00ffULL,
0x0000001018377824ULL, 0x100fe400078e024bULL, 0x000000101c3b7824ULL, 0x000fe400078e024bULL,
0x000000010d117824ULL, 0x000fe200000e0611ULL, 0x0000001d0c1c7210ULL, 0x000fe20007f1e0ffULL,
0x000000101a397824ULL, 0x100fe400078e024bULL, 0x000000101e3d7824ULL, 0x100fe400078e024bULL,
0x00000010203f7824ULL, 0x000fc400078e024bULL, 0x0000001022417824ULL, 0x100fe400078e024bULL,
0x0000001028437824ULL, 0x100fe400078e024bULL, 0x000000102a457824ULL, 0x100fe400078e024bULL,
0x000000101f497824ULL, 0x000fe200078e024bULL, 0x00000070141f7812ULL, 0x000fe200078ef804ULL,
0x0000008019187825ULL, 0x000fc800078e00ffULL, 0x00000010214b7824ULL, 0x000fe200078e024bULL,
0x0000007016217812ULL, 0x000fe200078ef804ULL, 0x000000010d1d7824ULL, 0x040fe200000e0613ULL,
0x0000007018237812ULL, 0x000fe200078ef804ULL, 0x000000010d0f7824ULL, 0x000fe200008e060fULL,
0x000000210c207210ULL, 0x000fe20007f1e0ffULL, 0x000000801b127825ULL, 0x000fe200078e00ffULL,
0x0000001f0c1e7210ULL, 0x000fe40007f3e0ffULL, 0x000000230c227210ULL, 0x000fe20007f5e0ffULL,
0x000000010d217824ULL, 0x040fe200000e0617ULL, 0x000000000e2f7faeULL, 0x0003e2000b901c46ULL,
0x000000010d1f7824ULL, 0x000fc400008e0615ULL, 0x0000008025167825ULL, 0x000fe200078e00ffULL,
0x0000007012257812ULL, 0x000fe200078ef804ULL, 0x0000000010317faeULL, 0x0003e4000b901c46ULL,
0x0000008024147825ULL, 0x000fe200078e00ffULL, 0x000000250c247210ULL, 0x000fe20007f1e0ffULL,
0x000000001c337faeULL, 0x0003e2000b901c46ULL, 0x0000007016297812ULL, 0x000fe200078ef804ULL,
0x000000010d237824ULL, 0x000fe400010e0619ULL, 0x0000008026187825ULL, 0x000fe200078e00ffULL,
0x000000001e357faeULL, 0x0003e6000b901c46ULL, 0x00000080271a7825ULL, 0x000fe200078e00ffULL,
0x0000007014277812ULL, 0x000fe200078ef804ULL, 0x0000000020377faeULL, 0x0003e2000b901c46ULL,
0x00000070182b7812ULL, 0x000fe200078ef804ULL, 0x000000010d257824ULL, 0x040fe200000e0613ULL,
0x000000270c267210ULL, 0x000fe20007f3e0ffULL, 0x000000802c127825ULL, 0x000fe200078e00ffULL,
0x000000290c287210ULL, 0x000fe20007f1e0ffULL, 0x0000000022397faeULL, 0x0003e2000b901c46ULL,
0x0000002b0c2a7210ULL, 0x000fe20007f5e0ffULL, 0x000000010d277824ULL, 0x040fe200008e0615ULL,
0x000000701a057812ULL, 0x000fe200078ef804ULL, 0x000000010d297824ULL, 0x040fe200000e0617ULL,
0x0000007012517812ULL, 0x000fe200078ef804ULL, 0x000000802e147825ULL, 0x000fe200078e00ffULL,
0x000000050c1a7210ULL, 0x000fe20007f1e0ffULL, 0x00000000243b7faeULL, 0x0003e4000b901c46ULL,
0x000000010d2b7824ULL, 0x040fe200010e0619ULL, 0x00000070144f7812ULL, 0x000fe200078ef804ULL,
0x0000008030167825ULL, 0x000fe200078e00ffULL, 0x00000000263d7faeULL, 0x0003e4000b901c46ULL,
0x0000004f0c127210ULL, 0x000fe20007f3e0ffULL, 0x0000008032187825ULL, 0x000fe200078e00ffULL,
0x00000070164d7812ULL, 0x000fe200078ef804ULL, 0x00000000283f7faeULL, 0x0003e4000b901c46ULL,
0x000000010d1b7824ULL, 0x000fe200000e061bULL, 0x0000007018057812ULL, 0x000fe200078ef804ULL,
0x000000002a417faeULL, 0x0003e2000b901c46ULL, 0x000000510c047210ULL, 0x000fc40007f1e0ffULL,
0x0000004d0c147210ULL, 0x000fe20007f5e0ffULL, 0x000000001a437faeULL, 0x0003e2000b901c46ULL,
0x000000050c0c7210ULL, 0x000fe20007f7e0ffULL, 0x000000010d057824ULL, 0x040fe400000e0613ULL,
0x000000010d137824ULL, 0x040fe400008e0615ULL, 0x000000010d157824ULL, 0x040fe200010e0617ULL,
0x0000000004457faeULL, 0x0003e2000b901c46ULL, 0x000000010d0d7824ULL, 0x000fc600018e0619ULL,
0x0000000012477faeULL, 0x0003e8000b901c46ULL, 0x0000000014497faeULL, 0x0003e8000b901c46ULL,
0x000000000c4b7faeULL, 0x0003e4000b901c46ULL, 0x000000027a7a7836ULL, 0x000fe20000000000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffffff7d7424ULL, 0x000fc600078e00ffULL,
0x000000637a00720cULL, 0x000fda0003f06070ULL, 0x00009400ff088b82ULL, 0x000ea20000000800ULL,
0x00000002790b8824ULL, 0x002fce00078e00ffULL, 0x00009000ff048b82ULL, 0x000e620000000a00ULL,
0x000000080b0b8224ULL, 0x004fc800078e027aULL, 0x000000040b048825ULL, 0x002fca00078e0004ULL,
0x00000006047d8981ULL, 0x000324000c1e1900ULL, 0x0000000000047805ULL, 0x002fce0000015200ULL,
0x01a60007090075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff0c7224ULL, 0x000fce00078e00ffULL, 0x000000100c00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fce0000015200ULL,
0x0000000a040d7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e05ULL,
0x003d09000d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc8000001140bULL, 0x0000000d08087211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060bULL, 0x0000000208087819ULL, 0x000fc8000000120bULL,
0x000000080000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000010c0c7836ULL, 0x000fce0000000000ULL, 0x01a60007090075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000000057919ULL, 0x000e640000000000ULL,
0x0000002078047824ULL, 0x002fc800078e0205ULL, 0x0000000104067836ULL, 0x000fe20000000000ULL,
0x00000004ff057819ULL, 0x000fc80000011604ULL, 0x0ffffffe05077812ULL, 0x000fe400078ec0ffULL,
0x0000001f04057812ULL, 0x000fc600078ec0ffULL, 0x00000001070a7824ULL, 0x000fe400078e0206ULL,
0x0000000104087824ULL, 0x000fe400078e0207ULL, 0x00000010050d7824ULL, 0x040fe200078e00ffULL,
0x0000000f0a0a7812ULL, 0x000fe200078ec0ffULL, 0x00000010050b7824ULL, 0x000fe200078e00ffULL,
0x0000000f08087812ULL, 0x000fe200078ec0ffULL, 0x0000000807077836ULL, 0x000fe20000000000ULL,
0x000001f00d0a7812ULL, 0x000fe400078ee20aULL, 0x000001f00b087812ULL, 0x000fe200078ee208ULL,
0x0000000106067824ULL, 0x000fc400078e0207ULL, 0x000000100a0a7824ULL, 0x100fe400078e0209ULL,
0x0000001008087824ULL, 0x000fe200078e0209ULL, 0x0000000f06067812ULL, 0x000fe200078ec0ffULL,
0x0000000104047824ULL, 0x000fe200078e0207ULL, 0x000000000a0c7984ULL, 0x000e620000000c00ULL,
0x0000001005077824ULL, 0x040fe400078e00ffULL, 0x0000001005057824ULL, 0x000fe200078e00ffULL,
0x0000000008107984ULL, 0x000ea20000000c00ULL, 0x0000000f04047812ULL, 0x000fc600078ec0ffULL,
0x000001f005067812ULL, 0x000fe400078ee206ULL, 0x000001f007047812ULL, 0x000fc600078ee204ULL,
0x0000001006067824ULL, 0x100fe400078e0209ULL, 0x0000001004047824ULL, 0x000fe400078e0209ULL,
0x000000ffff167224ULL, 0x002fe400078e000cULL, 0x000000ffff177224ULL, 0x000fe400078e000eULL,
0x000000ffff147224ULL, 0x004fe400078e0010ULL, 0x000000ffff157224ULL, 0x000fc400078e0012ULL,
0x000000ffff1a7224ULL, 0x000fe400078e000dULL, 0x000000ffff1b7224ULL, 0x000fe200078e000fULL,
0x0000001408007388ULL, 0x000fe20000000c00ULL, 0x000000ffff187224ULL, 0x000fe400078e0011ULL,
0x000000ffff197224ULL, 0x000fca00078e0013ULL, 0x000000180a007388ULL, 0x0003e80000000c00ULL,
0x00000000060c7984ULL, 0x000ea80000000c00ULL, 0x0000000004107984ULL, 0x000ee20000000c00ULL,
0x00000001ff0a7424ULL, 0x002fe400078e00ffULL, 0x000000ffff1f7224ULL, 0x004fc400078e000eULL,
0x000000ffff1e7224ULL, 0x000fe400078e000cULL, 0x000000ffff0e7224ULL, 0x000fe400078e000dULL,
0x000000ffff1c7224ULL, 0x008fe400078e0010ULL, 0x000000ffff1d7224ULL, 0x000fe400078e0012ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0011ULL, 0x000000ffff0d7224ULL, 0x000fe200078e0013ULL,
0x0000001c04007388ULL, 0x0003e80000000c00ULL, 0x0000000c06007388ULL, 0x0003e20000000c00ULL,
0x01a6000a090a79a7ULL, 0x0002a4000850003fULL, 0x0000000000047805ULL, 0x002fce0000015200ULL,
0x01a6000b090075a7ULL, 0x004e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff087224ULL, 0x000fce00078e00ffULL, 0x000000100800780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fce0000015200ULL,
0x00000006040d7210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09000d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011407ULL, 0x0000000d06067211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000206067819ULL, 0x000fc80000001207ULL,
0x000000060000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000108087836ULL, 0x000fce0000000000ULL, 0x01a6000b090075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000ff6100720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x00009400ff047b82ULL, 0x000e620000000800ULL,
0x00000000000b7919ULL, 0x000ea20000000000ULL, 0x0000840000097ab9ULL, 0x000fe20000000800ULL,
0x000001007b7b7836ULL, 0x000fe20000000000ULL, 0x0000001f09047890ULL, 0x000fe4000fffe03fULL,
0x80000009745f7c36ULL, 0x000fe40008000000ULL, 0x3db504f35e5e7820ULL, 0x010fe20000410000ULL,
0x0000000878087824ULL, 0x140fe200078e0209ULL, 0x000000043f047899ULL, 0x000fe20008011604ULL,
0x0000002078777824ULL, 0x000fe200078e0209ULL, 0x00000008ff5f7819ULL, 0x000fe2000001165fULL,
0x000000ffff767224ULL, 0x000fe200078e00ffULL, 0xffffffff09057890ULL, 0x000fe2000fffe03fULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x0000000909087890ULL, 0x000fc4000fffe03fULL,
0x0ffffffe04047892ULL, 0x000fe2000f8ec03fULL, 0x0000000479797224ULL, 0x002fd600078e02ffULL,
0x00008e00ff047b82ULL, 0x000e620000000a00ULL, 0x0000000276067836ULL, 0x000fe20000000000ULL,
0x000000010a5c7812ULL, 0x000fe200078e0cffULL, 0x00000100765d7824ULL, 0x000fe400078e027bULL,
0x0000007d027d7224ULL, 0x010fe200078e02ffULL, 0x000000610600720cULL, 0x000fe40003f06070ULL,
0x000000405d067812ULL, 0x000fca00078ec0ffULL, 0x0000000103067824ULL, 0x000fe400078e0206ULL,
0x000000807d047825ULL, 0x002fc800078e0004ULL, 0x0000000c002c8947ULL, 0x000fea0003800000ULL,
0x00000003ff267819ULL, 0x004fe2000001160bULL, 0x000000100b1a7824ULL, 0x000fe200078e00ffULL,
0x0000005d740c7248ULL, 0x000fc60007fe0000ULL, 0x00000004260e7836ULL, 0x000fe20000000000ULL,
0x000000701a1a7812ULL, 0x000fe200078ec0ffULL, 0x000000010c1b7824ULL, 0x000fe400078e0a5dULL,
0x000000010e077824ULL, 0x040fe400078e020bULL, 0x000000080e127824ULL, 0x040fe200078e00ffULL,
0x0000001b0e00720cULL, 0x000fe20003fa6070ULL, 0x0000000826107836ULL, 0x000fe40000000000ULL,
0x00000001260c7824ULL, 0x100fe200078e0206ULL, 0xfffffff812277812ULL, 0x000fe200078ee207ULL,
0x000000010e0e7824ULL, 0x000fc400078e0206ULL, 0x0000000110077824ULL, 0x040fe400078e020bULL,
0x0000000810127824ULL, 0x000fe400078e00ffULL, 0x000000800c0c7825ULL, 0x000fc600078e00ffULL,
0xfffffff812297812ULL, 0x000fe200078ee207ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000001a0c217212ULL, 0x000fc600078efcffULL, 0x0000001026147836ULL, 0x000fe20000000000ULL,
0x0000001a0e077212ULL, 0x000fe200078efcffULL, 0x0000000c26127836ULL, 0x000fe20000000000ULL,
0x0000002104207210ULL, 0x000fe20007f1e0ffULL, 0x00000001140e7824ULL, 0x040fe200078e020bULL,
0x00000007040c7210ULL, 0x000fe20007f3e0ffULL, 0x00000008142d7824ULL, 0x000fe200078e00ffULL,
0x0000001b1200720cULL, 0x080fe20003f46070ULL, 0x0000000105217824ULL, 0x000fe200000e060dULL,
0x0000001b1400720cULL, 0x000fe20003f06070ULL, 0x0000000112117824ULL, 0x000fe200078e020bULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee20eULL, 0x00000001100e7824ULL, 0x000fc400078e0206ULL,
0x0000000812167824ULL, 0x000fe400078e00ffULL, 0x00000001050d7824ULL, 0x000fe200008e060fULL,
0x0000001b1000720cULL, 0x000fe20003f26070ULL, 0x0000000112107824ULL, 0x000fe200078e0206ULL,
0xfffffff8162b7812ULL, 0x000fe200078ee211ULL, 0x000000800e0e7825ULL, 0x000fc800078e00ffULL,
0x0000001426227836ULL, 0x000fe20000000000ULL, 0x0000001a0e157212ULL, 0x000fe200078efcffULL,
0x0000000114127824ULL, 0x000fe400078e0206ULL, 0x0000001826287836ULL, 0x000fe20000000000ULL,
0x0000001504147210ULL, 0x000fe20007f7e0ffULL, 0x0000008010107825ULL, 0x000fc800078e00ffULL,
0x0000000122167824ULL, 0x000fe200078e0206ULL, 0x0000001a10197212ULL, 0x000fe200078efcffULL,
0x0000008012127825ULL, 0x000fc600078e00ffULL, 0x0000001904187210ULL, 0x000fe20007f9e0ffULL,
0x00000001281c7824ULL, 0x000fe200078e0206ULL, 0x0000001a12077212ULL, 0x000fe200078efcffULL,
0x0000008016167825ULL, 0x000fc800078e00ffULL, 0x000000801c1c7825ULL, 0x000fc800078e00ffULL,
0x0000000105157824ULL, 0x040fe200018e060fULL, 0x0000001a160f7212ULL, 0x080fe200078efcffULL,
0x0000000105197824ULL, 0x040fe200020e0611ULL, 0x00000007040e7210ULL, 0x000fe20007f7e0ffULL,
0x0000001c262c7836ULL, 0x000fe20000000000ULL, 0x0000001a1c077212ULL, 0x000fe200078efcffULL,
0x00000020262e7836ULL, 0x000fe20000000000ULL, 0x0000000f04107210ULL, 0x000fe20007f9e0ffULL,
0x00000001050f7824ULL, 0x000fe200018e0613ULL, 0x0000000704127210ULL, 0x000fe20007f7e0ffULL,
0x000000012c167824ULL, 0x000fc400078e0206ULL, 0x0000000105117824ULL, 0x040fe200020e0617ULL,
0x0000001b2600720cULL, 0x080fe20003f86070ULL, 0x0000000105137824ULL, 0x000fe200018e061dULL,
0x0000001b2200720cULL, 0x000fe20003f66070ULL, 0x00000001261d7824ULL, 0x000fe400078e020bULL,
0x0000400078077824ULL, 0x000fe400078e0209ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x000000071d1e7812ULL, 0x000fc600078ec0ffULL, 0x000020005c1c7824ULL, 0x000fe200078e0207ULL,
0x0000001a161d7212ULL, 0x000fe200078efcffULL, 0x000000012e167824ULL, 0x000fe200078e0206ULL,
0x0ffffff81e257812ULL, 0x000fe200078ef80bULL, 0x000020001c247836ULL, 0x000fe20000000000ULL,
0x0000001d041c7210ULL, 0x000fe20007fde0ffULL, 0x0000002426307836ULL, 0x000fe40000000000ULL,
0x00000001221f7824ULL, 0x000fe400078e020bULL, 0x00000001051d7824ULL, 0x000fc400030e0617ULL,
0x0000008016167825ULL, 0x000fc800078e00ffULL, 0x0000000822227824ULL, 0x000fe200078e00ffULL,
0x0000001a16237212ULL, 0x000fe200078efcffULL, 0x00000001301e7824ULL, 0x000fe400078e0206ULL,
0x0000002826327836ULL, 0x000fe20000000000ULL, 0xfffffff8222f7812ULL, 0x000fe200078ee21fULL,
0x0000001025257824ULL, 0x000fe200078e0224ULL, 0x0000002304227210ULL, 0x000fe20007fde0ffULL,
0x000000801e1e7825ULL, 0x000fc600078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020257faeULL, 0x0003e2000e101c46ULL, 0x0000000132167824ULL, 0x000fe200078e0206ULL,
0x0000001b2800720cULL, 0x000fe20003f86070ULL, 0x0000000105237824ULL, 0x000fe400030e0617ULL,
0x0000008016167825ULL, 0x000fc800078e00ffULL, 0x00000001282a7824ULL, 0x140fe400078e020bULL,
0x0000000828317824ULL, 0x000fe200078e00ffULL, 0x0000001a1e257212ULL, 0x082fe200078efcffULL,
0x0000001027217824ULL, 0x100fe400078e0224ULL, 0x000000012c207824ULL, 0x040fe200078e020bULL,
0x00000025041e7210ULL, 0x000fe20007fde0ffULL, 0x000000082c337824ULL, 0x000fe200078e00ffULL,
0x0000001a16257212ULL, 0x000fe200078efcffULL, 0x000000000c217faeULL, 0x0003e2000e901c46ULL,
0xfffffff831317812ULL, 0x000fe200078ee22aULL, 0x00000001051f7824ULL, 0x000fe200030e061fULL,
0x0000002504167210ULL, 0x000fe20007fde0ffULL, 0x0000001029257824ULL, 0x100fe200078e0224ULL,
0xfffffff833337812ULL, 0x000fe200078ee220ULL, 0x0000002c262a7836ULL, 0x000fe20000000000ULL,
0x0000001b2c00720cULL, 0x080fe20003fa6070ULL, 0x000000012e207824ULL, 0x040fe200078e020bULL,
0x0000000014257faeULL, 0x0005e2000c901c46ULL, 0x000000082e297824ULL, 0x040fe200078e00ffULL,
0x0000001b2e00720cULL, 0x000fe20003f26070ULL, 0x000000102b217824ULL, 0x002fc400078e0224ULL,
0x000000012a0c7824ULL, 0x000fe400078e0206ULL, 0x0000000130287824ULL, 0x000fe200078e020bULL,
0x0000000018217faeULL, 0x0003e2000d101c46ULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x0000001b3000720cULL, 0x000fc60003f46070ULL, 0x000000102d157824ULL, 0x104fe200078e0224ULL,
0x0000001a0c277212ULL, 0x000fe200078efcffULL, 0x00000008302b7824ULL, 0x000fe400078e00ffULL,
0x0000000105177824ULL, 0x000fe200030e0617ULL, 0x000000000e157faeULL, 0x0005e2000c101c46ULL,
0x00000027040c7210ULL, 0x000fe20007fde0ffULL, 0x0000003026187836ULL, 0x002fe20000000000ULL,
0xfffffff829277812ULL, 0x000fe200078ee220ULL, 0x000000102f197824ULL, 0x100fe200078e0224ULL,
0xfffffff82b297812ULL, 0x000fe200078ee228ULL, 0x0000001031217824ULL, 0x000fc400078e0224ULL,
0x0000003426207836ULL, 0x000fe20000000000ULL, 0x0000000010197faeULL, 0x0003e2000d901c46ULL,
0x0000001033257824ULL, 0x000fe200078e0224ULL, 0x0000001b1800720cULL, 0x0c0fe20003f66070ULL,
0x00000001180e7824ULL, 0x004fe200078e0206ULL, 0x0000000012217faeULL, 0x0005e2000e101c46ULL,
0x00000001050d7824ULL, 0x000fe200030e060dULL, 0x0000001b2a00720cULL, 0x080fe20003f86070ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000001c257faeULL, 0x0007e2000e901c46ULL,
0x0000001b3200720cULL, 0x000fc40003fa6070ULL, 0x0000001027277824ULL, 0x000fe400078e0224ULL,
0x0000000120107824ULL, 0x002fe400078e0206ULL, 0x0000001029297824ULL, 0x000fe200078e0224ULL,
0x0000001a0e137212ULL, 0x004fe200078efcffULL, 0x0000003826287836ULL, 0x000fe20000000000ULL,
0x0000000022277faeULL, 0x0003e2000c901c46ULL, 0x0000003c26267836ULL, 0x000fe20000000000ULL,
0x0000001304127210ULL, 0x000fe20007fde0ffULL, 0x0000000132147824ULL, 0x040fe200078e020bULL,
0x000000001e297faeULL, 0x0005e2000d101c46ULL, 0x0000000832157824ULL, 0x000fe200078e00ffULL,
0x0000001b2000720cULL, 0x080fe20003f46070ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000001b2800720cULL, 0x000fc40003f26070ULL, 0x0000001b2600720cULL, 0x000fe20003f06070ULL,
0x0000000105137824ULL, 0x000fe200030e060fULL, 0xfffffff8151b7812ULL, 0x000fe200078ee214ULL,
0x000000012a0f7824ULL, 0x100fe200078e020bULL, 0x0000001a10157212ULL, 0x000fe200078efcffULL,
0x000000082a2a7824ULL, 0x000fe400078e00ffULL, 0x0000000118107824ULL, 0x040fe200078e020bULL,
0x0000001504147210ULL, 0x000fe20007fde0ffULL, 0x0000000818217824ULL, 0x000fe200078e00ffULL,
0xfffffff82a1d7812ULL, 0x008fe200078ee20fULL, 0x00000001280e7824ULL, 0x000fc400078e0206ULL,
0x0000000105157824ULL, 0x000fe200030e0611ULL, 0xfffffff821217812ULL, 0x000fe200078ee210ULL,
0x000000800e0e7825ULL, 0x000fc800078e00ffULL, 0x0000000126107824ULL, 0x000fe200078e0206ULL,
0x0000001a0e197212ULL, 0x000fe200078efcffULL, 0x0000000120187824ULL, 0x000fe400078e020bULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x00000019040e7210ULL, 0x000fc60007fde0ffULL,
0x0000000820237824ULL, 0x002fe200078e00ffULL, 0x0000001a101f7212ULL, 0x004fe200078efcffULL,
0x0000000128067824ULL, 0x140fe400078e020bULL, 0x0000000828257824ULL, 0x000fe200078e00ffULL,
0xfffffff823237812ULL, 0x000fe200078ee218ULL, 0x00000001261c7824ULL, 0x040fe400078e020bULL,
0x0000000826277824ULL, 0x000fe200078e00ffULL, 0xfffffff825257812ULL, 0x000fe200078ee206ULL,
0x00000001050f7824ULL, 0x000fe200030e060fULL, 0x0000001f04047210ULL, 0x000fe20007fde0ffULL,
0x000000101b197824ULL, 0x100fe200078e0224ULL, 0xfffffff827277812ULL, 0x000fe200078ee21cULL,
0x000000101d1b7824ULL, 0x000fc400078e0224ULL, 0x00000010211d7824ULL, 0x100fe200078e0224ULL,
0x0000000016197faeULL, 0x0003e2000e901c46ULL, 0x00000010231f7824ULL, 0x100fe400078e0224ULL,
0x0000001025217824ULL, 0x100fe200078e0224ULL, 0x000000000c1b7faeULL, 0x0003e2000e101c46ULL,
0x0000001027237824ULL, 0x000fe400078e0224ULL, 0x0000000105057824ULL, 0x000fe200030e0611ULL,
0x00000000121d7faeULL, 0x0003e8000d901c46ULL, 0x00000000141f7faeULL, 0x0003e8000d101c46ULL,
0x000000000e217faeULL, 0x0003e8000c901c46ULL, 0x0000000004237faeULL, 0x0003e2000c101c46ULL,
0x0000000800dc7947ULL, 0x000fea0003800000ULL, 0x000000080b107811ULL, 0x044fe400078fe8ffULL,
0x000000040b0e7811ULL, 0x040fe400078fe8ffULL, 0x000000100b147811ULL, 0x040fe200078fe8ffULL,
0x00000001100c7824ULL, 0x140fe200078e020bULL, 0x000000180b187811ULL, 0x040fe200078fe8ffULL,
0x00000008100d7824ULL, 0x000fe200078e00ffULL, 0x000000140b167811ULL, 0x040fe200078fe8ffULL,
0x000000010e077824ULL, 0x140fe200078e020bULL, 0x0000000c0b127811ULL, 0x040fe200078fe8ffULL,
0x000000080e247824ULL, 0x000fe200078e00ffULL, 0xfffffff80d267812ULL, 0x000fe200078ee20cULL,
0x00000001140c7824ULL, 0x140fe200078e020bULL, 0x000000200b1c7811ULL, 0x040fe200078fe8ffULL,
0x0000000814117824ULL, 0x000fe200078e00ffULL, 0xfffffff824247812ULL, 0x000fe200078ee207ULL,
0x00000001180f7824ULL, 0x140fe200078e020bULL, 0x000000280b1e7811ULL, 0x040fe200078fe8ffULL,
0x0000000818347824ULL, 0x000fe200078e00ffULL, 0x000000240b1d7811ULL, 0x040fe200078fe8ffULL,
0x00000001160d7824ULL, 0x140fe200078e020bULL, 0x0000001c0b1a7811ULL, 0x040fe200078fe8ffULL,
0x0000000816327824ULL, 0x000fe200078e00ffULL, 0xfffffff8112a7812ULL, 0x000fe200078ee20cULL,
0x0000000112077824ULL, 0x140fe200078e020bULL, 0xfffffff834347812ULL, 0x000fe200078ee20fULL,
0x0000000812287824ULL, 0x000fe200078e00ffULL, 0xfffffff832327812ULL, 0x000fe200078ee20dULL,
0x000000011c0c7824ULL, 0x140fe200078e020bULL, 0x000000300b2c7811ULL, 0x040fe200078fe8ffULL,
0x000000081c117824ULL, 0x000fe200078e00ffULL, 0xfffffff828287812ULL, 0x000fe200078ee207ULL,
0x000000011e0f7824ULL, 0x140fe200078e020bULL, 0x000000380b307811ULL, 0x040fe200078fe8ffULL,
0x000000081e3c7824ULL, 0x000fe200078e00ffULL, 0x000000340b2e7811ULL, 0x000fe200078fe8ffULL,
0x000000011d0d7824ULL, 0x100fe200078e020bULL, 0x0000002c0b207811ULL, 0x000fe200078fe8ffULL,
0x000000081d3a7824ULL, 0x000fe200078e00ffULL, 0xfffffff811387812ULL, 0x000fe200078ee20cULL,
0x000000011a077824ULL, 0x140fe200078e020bULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee20fULL,
0x000000081a367824ULL, 0x000fe200078e00ffULL, 0xfffffff83a3a7812ULL, 0x000fe200078ee20dULL,
0x000000012c0c7824ULL, 0x000fc400078e020bULL, 0x000000082c117824ULL, 0x000fe200078e00ffULL,
0xfffffff836367812ULL, 0x000fe200078ee207ULL, 0x00000001300f7824ULL, 0x140fe400078e020bULL,
0x0000000830447824ULL, 0x000fe200078e00ffULL, 0xfffffff811407812ULL, 0x000fe200078ee20cULL,
0x000000012e0d7824ULL, 0x140fe200078e020bULL, 0x0000003c0b117811ULL, 0x040fe200078fe8ffULL,
0x000000082e427824ULL, 0x000fe200078e00ffULL, 0xfffffff844447812ULL, 0x000fe200078ee20fULL,
0x0000000120077824ULL, 0x140fe200078e020bULL, 0x000000060b0c7211ULL, 0x040fe200078fe8ffULL,
0x00000008203e7824ULL, 0x000fe200078e00ffULL, 0xfffffff842427812ULL, 0x000fe200078ee20dULL,
0x000000100b0f7824ULL, 0x040fe200078e00ffULL, 0x0000000b0b0d7211ULL, 0x000fe200078fe8ffULL,
0x0000000111137824ULL, 0x000fe200078e020bULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee207ULL,
0x0000400078077824ULL, 0x000fe200078e0209ULL, 0x000000070d227812ULL, 0x000fe200078ec0ffULL,
0x0000000811467824ULL, 0x000fe200078e00ffULL, 0x000000700f4d7812ULL, 0x000fe200078ec0ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x0ffffff822227812ULL, 0x000fc400078ef80bULL,
0xfffffff846467812ULL, 0x000fe200078ee213ULL, 0x000020005c0f7824ULL, 0x000fe200078e0207ULL,
0x0000004d0c137212ULL, 0x000fe200078efcffULL, 0x000000010e0e7824ULL, 0x100fe400078e0206ULL,
0x000020000f4b7836ULL, 0x000fe20000000000ULL, 0x00000013040c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000110107824ULL, 0x000fe400078e0206ULL, 0x000000800e0e7825ULL, 0x000fc800078e00ffULL,
0x0000000112127824ULL, 0x100fe200078e0206ULL, 0x0000004d0e137212ULL, 0x000fe200078efcffULL,
0x0000000114147824ULL, 0x100fe400078e0206ULL, 0x0000000116167824ULL, 0x100fe200078e0206ULL,
0x00000013040e7210ULL, 0x000fe20007f3e0ffULL, 0x0000000118187824ULL, 0x100fe400078e0206ULL,
0x000000011a1a7824ULL, 0x100fe400078e0206ULL, 0x000000011c1c7824ULL, 0x000fc400078e0206ULL,
0x000000011d1d7824ULL, 0x100fe400078e0206ULL, 0x000000011e1e7824ULL, 0x100fe400078e0206ULL,
0x0000000120207824ULL, 0x100fe400078e0206ULL, 0x000000012c2c7824ULL, 0x100fe400078e0206ULL,
0x000000012e2e7824ULL, 0x100fe400078e0206ULL, 0x0000000130307824ULL, 0x000fc400078e0206ULL,
0x0000000111067824ULL, 0x000fe400078e0206ULL, 0x0000008010107825ULL, 0x000fc800078e00ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000004d10177212ULL, 0x000fc600078efcffULL,
0x00000001050d7824ULL, 0x000fe200000e060dULL, 0x0000001704107210ULL, 0x000fe20007f1e0ffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000004d121b7212ULL, 0x000fc600078efcffULL,
0x0000008018187825ULL, 0x000fc800078e00ffULL, 0x0000000105117824ULL, 0x040fe200000e0611ULL,
0x0000001b04127210ULL, 0x000fe20007f1e0ffULL, 0x00000010222d7824ULL, 0x000fe200078e024bULL,
0x0000004d161b7212ULL, 0x080fe200078efcffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000004d18237212ULL, 0x000fe400078efcffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c2d7faeULL, 0x0003e2000b901c46ULL, 0x0000000105137824ULL, 0x000fe200000e0613ULL,
0x0000001b04167210ULL, 0x000fe20007f1e0ffULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000002304227210ULL, 0x000fc40007f5e0ffULL, 0x0000004d141f7212ULL, 0x080fe200078efcffULL,
0x00000001050f7824ULL, 0x040fe200008e060fULL, 0x0000004d1a257212ULL, 0x000fe200078efcffULL,
0x0000000105237824ULL, 0x000fe200010e0619ULL, 0x0000001f04147210ULL, 0x000fe20007f3e0ffULL,
0x000000801c187825ULL, 0x000fc800078e00ffULL, 0x000000801d1c7825ULL, 0x000fe200078e00ffULL,
0x0000004d18277212ULL, 0x000fc600078efcffULL, 0x00000010242f7824ULL, 0x000fe200078e024bULL,
0x0000004d1c297212ULL, 0x080fe200078efcffULL, 0x0000000105177824ULL, 0x000fe200000e0617ULL,
0x0000002504247210ULL, 0x000fe20007f1e0ffULL, 0x000000801e1e7825ULL, 0x000fe200078e00ffULL,
0x000000000e2f7faeULL, 0x0003e6000b901c46ULL, 0x0000008020207825ULL, 0x000fe200078e00ffULL,
0x0000004d1e2b7212ULL, 0x000fc600078efcffULL, 0x0000001026317824ULL, 0x100fe400078e024bULL,
0x0000001028337824ULL, 0x000fe400078e024bULL, 0x0000000105157824ULL, 0x040fe200008e0615ULL,
0x0000002704267210ULL, 0x000fe20007f3e0ffULL, 0x0000000105257824ULL, 0x040fe200000e061bULL,
0x0000002904287210ULL, 0x000fe20007f1e0ffULL, 0x000000102a357824ULL, 0x000fe200078e024bULL,
0x0000004d201b7212ULL, 0x080fe200078efcffULL, 0x0000000105277824ULL, 0x040fe200008e0619ULL,
0x0000002b042a7210ULL, 0x000fe20007f5e0ffULL, 0x0000000105297824ULL, 0x040fe200000e061dULL,
0x0000001b04207210ULL, 0x000fe20007f1e0ffULL, 0x000000802c187825ULL, 0x000fe200078e00ffULL,
0x0000000010317faeULL, 0x0003e6000b901c46ULL, 0x000000802e1a7825ULL, 0x000fe200078e00ffULL,
0x0000004d18537212ULL, 0x080fe200078efcffULL, 0x0000000012337faeULL, 0x0003e4000b901c46ULL,
0x00000001052b7824ULL, 0x000fe200010e061fULL, 0x0000004d1a517212ULL, 0x080fe200078efcffULL,
0x00000080301c7825ULL, 0x000fe200078e00ffULL, 0x0000000014357faeULL, 0x0003e4000b901c46ULL,
0x00000051041a7210ULL, 0x000fe20007f3e0ffULL, 0x00000080061e7825ULL, 0x000fe200078e00ffULL,
0x0000004d1c4f7212ULL, 0x000fc600078efcffULL, 0x0000001032377824ULL, 0x100fe200078e024bULL,
0x0000004d1e4d7212ULL, 0x000fe200078efcffULL, 0x0000001034397824ULL, 0x000fe200078e024bULL,
0x0000004f041c7210ULL, 0x000fe20007f5e0ffULL, 0x0000000105217824ULL, 0x000fe200000e0621ULL,
0x0000005304187210ULL, 0x000fe20007f1e0ffULL, 0x00000010363b7824ULL, 0x100fe200078e024bULL,
0x0000004d04047210ULL, 0x000fe20007f7e0ffULL, 0x00000010383d7824ULL, 0x100fe200078e024bULL,
0x0000000016377faeULL, 0x0003e2000b901c46ULL, 0x000000103a3f7824ULL, 0x000fc400078e024bULL,
0x000000103c417824ULL, 0x100fe200078e024bULL, 0x0000000022397faeULL, 0x0003e2000b901c46ULL,
0x000000103e437824ULL, 0x100fe400078e024bULL, 0x0000001040457824ULL, 0x000fe200078e024bULL,
0x00000000243b7faeULL, 0x0003e2000b901c46ULL, 0x0000000105197824ULL, 0x040fe400000e0619ULL,
0x0000001042477824ULL, 0x000fe200078e024bULL, 0x00000000263d7faeULL, 0x0003e2000b901c46ULL,
0x00000001051b7824ULL, 0x000fc400008e061bULL, 0x0000001044497824ULL, 0x000fe200078e024bULL,
0x00000000283f7faeULL, 0x0003e2000b901c46ULL, 0x00000001051d7824ULL, 0x040fe400010e061dULL,
0x00000010464b7824ULL, 0x000fe200078e024bULL, 0x000000002a417faeULL, 0x0003e2000b901c46ULL,
0x0000000105057824ULL, 0x000fc600018e061fULL, 0x0000000020437faeULL, 0x0003e8000b901c46ULL,
0x0000000018457faeULL, 0x0003e8000b901c46ULL, 0x000000001a477faeULL, 0x0003e8000b901c46ULL,
0x000000001c497faeULL, 0x0003e8000b901c46ULL, 0x00000000044b7faeULL, 0x0003e4000b901c46ULL,
0x000000027a7a7836ULL, 0x000fe20000000000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffffff7d7424ULL, 0x000fc600078e00ffULL, 0x000000637a00720cULL, 0x000fda0003f06070ULL,
0x00009000ff048b82ULL, 0x002e620000000a00ULL, 0x00000002790d8824ULL, 0x000fe200078e027aULL,
0x000000080b527812ULL, 0x040fe200078ec0ffULL, 0x000000200b607836ULL, 0x000fe20000000000ULL,
0xfffffff80b627812ULL, 0x000fe200078ec0ffULL, 0x000020000a537824ULL, 0x000fe200078e0207ULL,
0x0000000752527812ULL, 0x000fe200078ef80bULL, 0x000000ffff757224ULL, 0x000fe200078e00ffULL,
0xfffffff860607812ULL, 0x000fe400078ec0ffULL, 0x0000000000467805ULL, 0x000fc4000001ff00ULL,
0x00000004ff507819ULL, 0x000fe4000001160bULL, 0x0000000000447805ULL, 0x000fe4000001ff00ULL,
0x000000070b517812ULL, 0x000fe400078ec0ffULL, 0x0000000000067805ULL, 0x000fe4000001ff00ULL,
0x00000000000e7805ULL, 0x000fe4000001ff00ULL, 0x0000000000127805ULL, 0x000fc4000001ff00ULL,
0x0000000000107805ULL, 0x000fe4000001ff00ULL, 0x0000000000167805ULL, 0x000fe4000001ff00ULL,
0x0000000000147805ULL, 0x000fe4000001ff00ULL, 0x00000000001a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000187805ULL, 0x000fe4000001ff00ULL, 0x00000000001e7805ULL, 0x000fc4000001ff00ULL,
0x00000000001c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x000000040d048825ULL, 0x002fe200078e0004ULL, 0x00000000000c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000207805ULL, 0x000fe4000001ff00ULL, 0x0000000000267805ULL, 0x000fe4000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000006047d8981ULL, 0x000322000c1e1900ULL,
0x00000000002a7805ULL, 0x000fc4000001ff00ULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x0000000000367805ULL, 0x000fc4000001ff00ULL, 0x0000000000347805ULL, 0x000fe4000001ff00ULL,
0x00000000003a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000047805ULL, 0x002fe4000001ff00ULL,
0x0000000000387805ULL, 0x000fe4000001ff00ULL, 0x00000000003e7805ULL, 0x000fe4000001ff00ULL,
0x00000000003c7805ULL, 0x000fc4000001ff00ULL, 0x0000000000427805ULL, 0x000fe4000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x0000200053537836ULL, 0x000fe20000000000ULL,
0x0000000762627812ULL, 0x000fe200078ef80bULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000760607812ULL, 0x000fe400078ef80bULL, 0x00000010520a7812ULL, 0x000fce00078efcffULL,
0x0000000162487824ULL, 0x040fe400078e0275ULL, 0x0000000862497824ULL, 0x000fe400078e00ffULL,
0x0000000175557836ULL, 0x000fe40000000000ULL, 0x00000002757f7824ULL, 0x000fe200078e0250ULL,
0xfffffff849487812ULL, 0x000fe200078ee248ULL, 0x0000000860497824ULL, 0x000fe400078e00ffULL,
0x00000008625b7824ULL, 0x000fc400078e00ffULL, 0x00000010484c7824ULL, 0x000fe400078e0253ULL,
0x0000000160487824ULL, 0x000fe400078e0275ULL, 0x0000000162707824ULL, 0x000fe400078e0255ULL,
0x000000004c4c783bULL, 0x000e620000000200ULL, 0xfffffff849487812ULL, 0x000fe200078ee248ULL,
0x000000100a597824ULL, 0x040fe200078e00ffULL, 0xfffffff85b707812ULL, 0x000fe200078ee270ULL,
0x000000010a807824ULL, 0x000fc400078e027fULL, 0x0000001048487824ULL, 0x000fe400078e0253ULL,
0x0000001052577824ULL, 0x040fe200078e00ffULL, 0xfffffff059807812ULL, 0x000fe200078ee280ULL,
0x0000000152547824ULL, 0x000fe400078e027fULL, 0x000000004848783bULL, 0x000ea20000000200ULL,
0x0000000860657824ULL, 0x040fe400078e00ffULL, 0xfffffff057547812ULL, 0x000fe200078ee254ULL,
0x0000000160587824ULL, 0x000fc400078e0255ULL, 0x000000027f7f7836ULL, 0x000fe40000000000ULL,
0x0000001054547824ULL, 0x000fe200078e0209ULL, 0xfffffff865587812ULL, 0x000fe200078ee258ULL,
0x0000000275757836ULL, 0x000fc80000000000ULL, 0x000000005454783bULL, 0x000ee20000000200ULL,
0x0000001058587824ULL, 0x000fe200078e0253ULL, 0x000000087500780cULL, 0x000fe40003f05270ULL,
0x00000010ff6b7819ULL, 0x102fe4000001164cULL, 0x000000ff4d647812ULL, 0x000fe400078ec0ffULL,
0x00000018ff6f7819ULL, 0x000fe4000001164cULL, 0x000000ff4c6e7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff4c867812ULL, 0x000fe400078ec0ffULL, 0x000000ff4f667812ULL, 0x000fe400078ec0ffULL,
0x00000010ff847819ULL, 0x100fe4000001164eULL, 0x00000018ff737819ULL, 0x000fe4000001164eULL,
0x000000ff4e727812ULL, 0x040fe400078ec0ffULL, 0x0000ffff4e887812ULL, 0x000fc400078ec0ffULL,
0x000000ff486c7812ULL, 0x004fe400078ec0ffULL, 0x00000010ff4c7819ULL, 0x100fe40000011649ULL,
0x00000018ff7e7819ULL, 0x000fe40000011649ULL, 0x000000ff497c7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff495b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff837819ULL, 0x000fc4000001164dULL,
0x00000018ff717819ULL, 0x000fe4000001164dULL, 0x0000ffff4d877812ULL, 0x000fe400078ec0ffULL,
0x00000010ff827819ULL, 0x100fe40000011648ULL, 0x00000018ff677819ULL, 0x000fe40000011648ULL,
0x0000ffff484e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff597819ULL, 0x000fc4000001164aULL,
0x00000018ff497819ULL, 0x000fe4000001164aULL, 0x000000ff4a6d7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff4a5a7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff4a7819ULL, 0x000fe4000001164bULL,
0x00000064ff4d723eULL, 0x000fe400020006ffULL, 0x000000ff6b487812ULL, 0x000fc400078ec0ffULL,
0x00000066ff64723eULL, 0x000fe400020006ffULL, 0x0000006cff66723eULL, 0x000fe400020006ffULL,
0x0000006dff6c723eULL, 0x000fe400020006ffULL, 0x00000049ff6b723eULL, 0x000fe400020006ffULL,
0x0000004aff6d723eULL, 0x000fe400020006ffULL, 0x00000048ff85723eULL, 0x000fc400020006ffULL,
0x000000ff83837812ULL, 0x000fe400078ec0ffULL, 0x00000008ff487819ULL, 0x000fe40000011686ULL,
0x00000008ff497819ULL, 0x000fe40000011687ULL, 0x000000ff844a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff817819ULL, 0x000fe4000001164fULL, 0x00000083ff87723eULL, 0x000fc400020006ffULL,
0x00000048ff84723eULL, 0x000fe200020006ffULL, 0x0000001080487824ULL, 0x000fe200078e0209ULL,
0x00000049ff86723eULL, 0x000fe400020006ffULL, 0x0000004aff83723eULL, 0x000fe400020006ffULL,
0x00000008ff497819ULL, 0x000fe40000011688ULL, 0x000000ff814a7812ULL, 0x000fe400078ec0ffULL,
0x0000006fff6f723eULL, 0x000fc400020006ffULL, 0x000000ff82807812ULL, 0x000fe400078ec0ffULL,
0x00000008ff4e7819ULL, 0x000fe4000001164eULL, 0x00000010ff687819ULL, 0x000fe4000001164bULL,
0x000000ff4b6a7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff4b697812ULL, 0x000fe400078ec0ffULL,
0x00000049ff88723eULL, 0x000fc400020006ffULL, 0x0000004aff82723eULL, 0x000fe400020006ffULL,
0x000000004848783bULL, 0x000e620000000200ULL, 0x00005410856f7816ULL, 0x000fe4000000006fULL,
0x00000018ff657819ULL, 0x000fe4000001164fULL, 0x0000004eff85723eULL, 0x000fe200020006ffULL,
0x00000010704e7824ULL, 0x000fe200078e0253ULL, 0x0000ffff4f4f7812ULL, 0x000fe400078ec0ffULL,
0x0000006eff6e723eULL, 0x000fc400020006ffULL, 0x00000008ff817819ULL, 0x000fe4000001164fULL,
0x000054106e6e7816ULL, 0x000fe40000000084ULL, 0x000000ff4c847812ULL, 0x000fe400078ec0ffULL,
0x000054104d707816ULL, 0x000fe40000000086ULL, 0x000000004e4c783bULL, 0x000ea20000000200ULL,
0x00000073ff73723eULL, 0x000fe200020006ffULL, 0x0000006e5440723cULL, 0x008fe20000001840ULL,
0x00000067ff67723eULL, 0x000fc400020006ffULL, 0x00000080ff80723eULL, 0x000fe400020006ffULL,
0x00000008ff5b7819ULL, 0x000fe4000001165bULL, 0x00000081ff81723eULL, 0x000fe400020006ffULL,
0x0000541083737816ULL, 0x000fe40000000073ULL, 0x00000065ff65723eULL, 0x000fe400020006ffULL,
0x0000007cff7c723eULL, 0x000fc400020006ffULL, 0x0000005bff83723eULL, 0x000fe400020006ffULL,
0x00000008ff5a7819ULL, 0x000fe4000001165aULL, 0x0000541080677816ULL, 0x000fe20000000067ULL,
0x0000006e4820723cULL, 0x002fe20000001820ULL, 0x0000541066667816ULL, 0x000fe40000000085ULL,
0x000000ff59597812ULL, 0x000fe400078ec0ffULL, 0x000000ff68857812ULL, 0x000fc400078ec0ffULL,
0x00000008ff807819ULL, 0x000fe20000011669ULL, 0x000000665430723cULL, 0x000fe20000001830ULL,
0x0000541064647816ULL, 0x000fe20000000081ULL, 0x000000100a6e7824ULL, 0x000fe200078e00ffULL,
0x0000541082657816ULL, 0x000fe40000000065ULL, 0x0000005aff81723eULL, 0x000fe200020006ffULL,
0x000000664810723cULL, 0x000fe20000001810ULL, 0x000054107c687816ULL, 0x000fe40000000083ULL,
0x00000071ff71723eULL, 0x000fc400020006ffULL, 0x00000072ff72723eULL, 0x000fe200020006ffULL,
0x000000645434723cULL, 0x000fe20000001834ULL, 0x0000007eff7e723eULL, 0x000fe400020006ffULL,
0x00000084ff84723eULL, 0x000fe400020006ffULL, 0x00000059ff82723eULL, 0x000fe200020006ffULL,
0x000000644814723cULL, 0x000fe20000001814ULL, 0x0000006aff7c723eULL, 0x000fe200020006ffULL,
0x000000005858783bULL, 0x000e620000000200ULL, 0x00000085ff85723eULL, 0x000fc400020006ffULL,
0x00000080ff80723eULL, 0x000fe400020006ffULL, 0x000054106c6a7816ULL, 0x000fe40000000081ULL,
0x0000541087717816ULL, 0x000fe40000000071ULL, 0x0000541072727816ULL, 0x000fe40000000088ULL,
0x0000541084697816ULL, 0x000fe4000000007eULL, 0x00005410826b7816ULL, 0x000fe2000000006bULL,
0x00000070543c723cULL, 0x000fe2000000183cULL, 0x00005410856d7816ULL, 0x000fc4000000006dULL,
0x000054107c6c7816ULL, 0x000fe40000000080ULL, 0x00000010ff887819ULL, 0x104fe2000001164cULL,
0x000000725438723cULL, 0x000fe20000001838ULL, 0x00000018ff847819ULL, 0x000fe4000001164cULL,
0x000000ff4c837812ULL, 0x040fe400078ec0ffULL, 0x0000ffff4c897812ULL, 0x000fe200078ec0ffULL,
0x00000068542c723cULL, 0x000fe2000000182cULL, 0x00000010ff8a7819ULL, 0x000fc4000001164dULL,
0x00000018ff827819ULL, 0x000fe4000001164dULL, 0x000000ff4d807812ULL, 0x040fe200078ec0ffULL,
0x0000006a5428723cULL, 0x000fe20000001828ULL, 0x0000ffff4d8b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff857819ULL, 0x100fe4000001164eULL, 0x00000018ff817819ULL, 0x000fe2000001164eULL,
0x0000006c5424723cULL, 0x000fe20000001824ULL, 0x000000ff4e8d7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff4e867812ULL, 0x000fe400078ec0ffULL, 0x00000010ff877819ULL, 0x100fe2000001164fULL,
0x00000070481c723cULL, 0x000fe2000000181cULL, 0x0000001052557824ULL, 0x040fe200078e00ffULL,
0x00000018ff8e7819ULL, 0x000fe2000001164fULL, 0x0000000152547824ULL, 0x100fe200078e027fULL,
0x000000ff4f8f7812ULL, 0x000fe200078ec0ffULL, 0x000000010a7f7824ULL, 0x000fe200078e027fULL,
0x000000724818723cULL, 0x000fe20000001818ULL, 0x0000ffff58577812ULL, 0x002fc400078ec0ffULL,
0xfffffff055567812ULL, 0x000fe400078ee254ULL, 0xfffffff06e547812ULL, 0x000fe200078ee27fULL,
0x00000068480c723cULL, 0x000fe2000000180cULL, 0x0000ffff4f557812ULL, 0x000fe200078ec0ffULL,
0x00000010564c7824ULL, 0x100fe200078e0209ULL, 0x00000010ff567819ULL, 0x100fe20000011658ULL,
0x0000001054547824ULL, 0x000fe200078e0209ULL, 0x00000018ff907819ULL, 0x000fe20000011658ULL,
0x0000006a4804723cULL, 0x000fe20000001804ULL, 0x00000008ff687819ULL, 0x000fe2000001168bULL,
0x000000004c4c783bULL, 0x000e620000000200ULL, 0x000000ff58917812ULL, 0x000fc400078ec0ffULL,
0x00000080ff80723eULL, 0x000fe200020006ffULL, 0x0000006c4844723cULL, 0x000fe20000001844ULL,
0x00000068ff68723eULL, 0x000fe200020006ffULL, 0x000000005448783bULL, 0x000ea20000000200ULL,
0x00000010ff587819ULL, 0x000fe40000011659ULL, 0x000000ff8a697812ULL, 0x000fe400078ec0ffULL,
0x00000008ff6a7819ULL, 0x000fe40000011655ULL, 0x00000008ff6b7819ULL, 0x000fc40000011657ULL,
0x0000ffff597e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff7f7819ULL, 0x000fe4000001165aULL,
0x0000ffff5a727812ULL, 0x000fe400078ec0ffULL, 0x00000010ff707819ULL, 0x000fe4000001165bULL,
0x0000ffff5b717812ULL, 0x000fe400078ec0ffULL, 0x000000ff566c7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff8c7819ULL, 0x000fe4000001165aULL, 0x000000ff5a737812ULL, 0x000fe400078ec0ffULL,
0x0000541080567816ULL, 0x000fe40000000068ULL, 0x00000018ff927819ULL, 0x000fe40000011659ULL,
0x000000ff597c7812ULL, 0x000fe400078ec0ffULL, 0x00000082ff82723eULL, 0x000fc400020006ffULL,
0x0000008fff5a723eULL, 0x000fe400020006ffULL, 0x00000091ff64723eULL, 0x000fe400020006ffULL,
0x00000069ff69723eULL, 0x000fe400020006ffULL, 0x0000006aff6a723eULL, 0x000fe400020006ffULL,
0x0000006bff6b723eULL, 0x000fe400020006ffULL, 0x000000ff58687812ULL, 0x000fc400078ec0ffULL,
0x00000018ff6e7819ULL, 0x000fe4000001165bULL, 0x000000ff5b6f7812ULL, 0x000fe400078ec0ffULL,
0x000000ff88887812ULL, 0x000fe400078ec0ffULL, 0x00000008ff897819ULL, 0x000fe40000011689ULL,
0x000000ff85857812ULL, 0x000fe400078ec0ffULL, 0x00000008ff867819ULL, 0x000fc40000011686ULL,
0x000000ff87877812ULL, 0x000fe400078ec0ffULL, 0x00000008ff7e7819ULL, 0x000fe4000001167eULL,
0x000000ff7f7f7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff727819ULL, 0x000fe40000011672ULL,
0x000000ff70707812ULL, 0x000fe400078ec0ffULL, 0x00000008ff717819ULL, 0x000fc40000011671ULL,
0x00000081ff59723eULL, 0x000fe400020006ffULL, 0x00000092ff67723eULL, 0x000fe400020006ffULL,
0x0000007cff66723eULL, 0x000fe400020006ffULL, 0x0000541069577816ULL, 0x000fe40000000082ULL,
0x00000068ff68723eULL, 0x000fe400020006ffULL, 0x000054105a5a7816ULL, 0x000fc4000000006aULL,
0x0000541064647816ULL, 0x000fe2000000006bULL, 0x000000564c3c723cULL, 0x002fe2000000183cULL,
0x00000084ff84723eULL, 0x000fe400020006ffULL, 0x00000083ff83723eULL, 0x000fe400020006ffULL,
0x0000008dff81723eULL, 0x000fe200020006ffULL, 0x00000056481c723cULL, 0x004fe2000000181cULL,
0x0000008eff5b723eULL, 0x000fe400020006ffULL, 0x00000090ff65723eULL, 0x000fc400020006ffULL,
0x0000008cff7c723eULL, 0x000fe400020006ffULL, 0x00000073ff73723eULL, 0x000fe400020006ffULL,
0x0000006eff6e723eULL, 0x000fe400020006ffULL, 0x00000088ff88723eULL, 0x000fe400020006ffULL,
0x00000089ff89723eULL, 0x000fe400020006ffULL, 0x00000085ff85723eULL, 0x000fc400020006ffULL,
0x00000086ff86723eULL, 0x000fe400020006ffULL, 0x00000087ff87723eULL, 0x000fe400020006ffULL,
0x0000006cff6c723eULL, 0x000fe400020006ffULL, 0x0000007eff7e723eULL, 0x000fe400020006ffULL,
0x0000007fff69723eULL, 0x000fe400020006ffULL, 0x00000072ff72723eULL, 0x000fc400020006ffULL,
0x0000006fff6a723eULL, 0x000fe400020006ffULL, 0x00000070ff6b723eULL, 0x000fe400020006ffULL,
0x00000071ff71723eULL, 0x000fe400020006ffULL, 0x0000541068677816ULL, 0x000fe40000000067ULL,
0x0000541088557816ULL, 0x000fe40000000084ULL, 0x0000541083547816ULL, 0x000fc40000000089ULL,
0x0000541085597816ULL, 0x000fe40000000059ULL, 0x0000541081587816ULL, 0x000fe40000000086ULL,
0x00005410875b7816ULL, 0x000fe2000000005bULL, 0x000000544c40723cULL, 0x000fe20000001840ULL,
0x000054106c657816ULL, 0x000fe40000000065ULL, 0x0000541066667816ULL, 0x000fe4000000007eULL,
0x0000541069697816ULL, 0x000fe2000000007cULL, 0x000000584c38723cULL, 0x000fe20000001838ULL,
0x0000541073687816ULL, 0x000fc40000000072ULL, 0x000054106b6b7816ULL, 0x000fe4000000006eULL,
0x000054106a6a7816ULL, 0x000fe20000000071ULL, 0x0000005a4c34723cULL, 0x000fec0000001834ULL,
0x000000644c30723cULL, 0x000fec0000001830ULL, 0x000000664c2c723cULL, 0x000fec000000182cULL,
0x000000684c28723cULL, 0x000fec0000001828ULL, 0x0000006a4c24723cULL, 0x000fec0000001824ULL,
0x000000544820723cULL, 0x000fec0000001820ULL, 0x000000584818723cULL, 0x000fec0000001818ULL,
0x0000005a4814723cULL, 0x000fec0000001814ULL, 0x000000644810723cULL, 0x000fec0000001810ULL,
0x00000066480c723cULL, 0x000fec000000180cULL, 0x000000684804723cULL, 0x000fec0000001804ULL,
0x0000006a4844723cULL, 0x000fe20000001844ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0xffffffec00c40947ULL, 0x000fde000383ffffULL, 0x00000001ff4d7424ULL, 0x000fe400078e00ffULL,
0x0000005e40497220ULL, 0x080fe20000410000ULL, 0x0000005e204b7220ULL, 0x080fe20000410000ULL,
0x0000005e41417220ULL, 0x080fe20000410000ULL, 0x0000005e42427220ULL, 0x080fe20000410000ULL,
0x0000005e43437220ULL, 0x080fe20000410000ULL, 0x01a6884d084c79a7ULL, 0x000262000850003fULL,
0x0000005e3c3c7220ULL, 0x080fe20000410000ULL, 0x0000005e3d3d7220ULL, 0x080fe20000410000ULL,
0x0000005e3e3e7220ULL, 0x080fe20000410000ULL, 0x0000005e3f3f7220ULL, 0x080fe20000410000ULL,
0x0000005e38387220ULL, 0x080fe20000410000ULL, 0x0000005e39397220ULL, 0x080fe20000410000ULL,
0x0000005e3a3a7220ULL, 0x080fe20000410000ULL, 0x0000005e3b3b7220ULL, 0x080fe20000410000ULL,
0x0000005e34347220ULL, 0x080fe20000410000ULL, 0x0000005e35357220ULL, 0x080fe20000410000ULL,
0x0000005e36367220ULL, 0x080fe20000410000ULL, 0x0000005e37377220ULL, 0x080fe20000410000ULL,
0x0000005e30307220ULL, 0x080fe20000410000ULL, 0x0000005e31317220ULL, 0x080fe20000410000ULL,
0x0000005e32327220ULL, 0x080fe20000410000ULL, 0x0000005e33337220ULL, 0x080fe20000410000ULL,
0x0000005e2c2c7220ULL, 0x080fe20000410000ULL, 0x0000005e2d2d7220ULL, 0x080fe20000410000ULL,
0x0000005e2e2e7220ULL, 0x080fe20000410000ULL, 0x0000005e2f2f7220ULL, 0x080fe20000410000ULL,
0x0000005e28287220ULL, 0x080fe20000410000ULL, 0x0000005e29297220ULL, 0x080fe20000410000ULL,
0x0000005e2a2a7220ULL, 0x080fe20000410000ULL, 0x0000005e2b2b7220ULL, 0x080fe20000410000ULL,
0x0000005e24247220ULL, 0x080fe20000410000ULL, 0x0000005e25257220ULL, 0x080fe20000410000ULL,
0x0000005e26267220ULL, 0x080fe20000410000ULL, 0x0000005e27277220ULL, 0x080fe20000410000ULL,
0x0000005e21217220ULL, 0x080fe20000410000ULL, 0x0000005e22227220ULL, 0x080fe20000410000ULL,
0x0000005e23237220ULL, 0x080fe20000410000ULL, 0x0000005e1c1c7220ULL, 0x080fe20000410000ULL,
0x0000005e1d1d7220ULL, 0x080fe20000410000ULL, 0x0000005e1e1e7220ULL, 0x080fe20000410000ULL,
0x0000005e1f1f7220ULL, 0x080fe20000410000ULL, 0x0000005e18187220ULL, 0x080fe20000410000ULL,
0x0000005e19197220ULL, 0x080fe20000410000ULL, 0x0000005e1a1a7220ULL, 0x080fe20000410000ULL,
0x0000005e1b1b7220ULL, 0x080fe20000410000ULL, 0x0000005e14147220ULL, 0x080fe20000410000ULL,
0x0000005e15157220ULL, 0x080fe20000410000ULL, 0x0000005e16167220ULL, 0x080fe20000410000ULL,
0x0000005e17177220ULL, 0x080fe20000410000ULL, 0x0000005e10107220ULL, 0x080fe20000410000ULL,
0x0000005e11117220ULL, 0x080fe20000410000ULL, 0x0000005e12127220ULL, 0x080fe20000410000ULL,
0x0000005e13137220ULL, 0x080fe20000410000ULL, 0x0000005e0c0c7220ULL, 0x080fe20000410000ULL,
0x0000005e0d0d7220ULL, 0x080fe20000410000ULL, 0x0000005e0e0e7220ULL, 0x080fe20000410000ULL,
0x0000005e0f0f7220ULL, 0x080fe20000410000ULL, 0x0000005e040a7220ULL, 0x080fe20000410000ULL,
0x0000005e05207220ULL, 0x080fe20000410000ULL, 0x0000005e06407220ULL, 0x080fe20000410000ULL,
0x0000005e07487220ULL, 0x080fe20000410000ULL, 0x0000005e44447220ULL, 0x080fe20000410000ULL,
0x0000005e45457220ULL, 0x080fe20000410000ULL, 0x0000005e46467220ULL, 0x080fe20000410000ULL,
0x0000005e47477220ULL, 0x002fce0000410000ULL, 0x0000000000067805ULL, 0x000fce0000015200ULL,
0x01a6884d080075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff4a7224ULL, 0x000fce00078e00ffULL, 0x000000104a00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fce0000015200ULL,
0x00000004064f7210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e07ULL,
0x003d09004f00780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c404f00780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc80000011405ULL, 0x0000004f04047211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000204047819ULL, 0x000fc80000001205ULL,
0x000000040000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000014a4a7836ULL, 0x000fce0000000000ULL, 0x01a6884d080075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000040b047824ULL, 0x000fe200078e00ffULL,
0x0000005f7600720cULL, 0x000fe20003f06070ULL, 0x0000008078057824ULL, 0x000fc600078e0209ULL,
0xfffffff004047812ULL, 0x000fca00078ec0ffULL, 0x00000001054a7824ULL, 0x000fca00078e0204ULL,
0x01a400004a047984ULL, 0x0002a20000000c00ULL, 0x0000001c00c48947ULL, 0x000fea0003800000ULL,
0xffffff005d5d7836ULL, 0x000fe20000000000ULL, 0x0000860000097ab9ULL, 0x000fe20000000800ULL,
0x000000020baa7824ULL, 0x000fe200078e00ffULL, 0x00008c00ff567b82ULL, 0x000ee20000000a00ULL,
0x00008400000a7ab9ULL, 0x000fe20000000800ULL, 0x0000005d744c7248ULL, 0x000fe40007fe0000ULL,
0x00000006aaaa7812ULL, 0x000fc600078ec0ffULL, 0x000000014cab7824ULL, 0x000fe200078e0a5dULL,
0x000000000b4c7211ULL, 0x000fe200078ff0ffULL, 0x0000000aaaa97c36ULL, 0x000fe40008000000ULL,
0x000000ffff607224ULL, 0x000fe200078e0aabULL, 0x00000009ff4d7c19ULL, 0x000fe2000801164cULL,
0x000000084c4e7836ULL, 0x000fe20000000000ULL, 0x000000aba900720cULL, 0x000fe20003f06070ULL,
0x000000104c4f7836ULL, 0x000fe20000000000ULL, 0x000000054d4d7c48ULL, 0x000fe2000bfe0000ULL,
0x000000184c507836ULL, 0x000fe20000000000ULL, 0x00000009ff4e7c19ULL, 0x000fe2000801164eULL,
0x00000008aa4c7c36ULL, 0x000fe20008000000ULL, 0x00000005a99a7e46ULL, 0x000fe2000b800060ULL,
0x000000044d697c24ULL, 0x000fe2000f8e02ffULL, 0x000000054e4e7c48ULL, 0x000fc4000bfe0000ULL,
0x000000ab4c00720cULL, 0x000fe40003f26070ULL, 0x000000054c4c7e46ULL, 0x000fe2000b800060ULL,
0x000000044e6d7c24ULL, 0x000fe2000f8e02ffULL, 0x000000ff9a9a7207ULL, 0x000fe40000000000ULL,
0x00000004ff4c7819ULL, 0x000fe4000001164cULL, 0x00000009ff4f7c19ULL, 0x000fe4000801164fULL,
0x000000ff4c4e7207ULL, 0x000fc40000800000ULL, 0x000000699a4d7211ULL, 0x040fe400078fe0ffULL,
0x000000054f4f7c48ULL, 0x000fe2000bfe0000ULL, 0x00000001695b7824ULL, 0x000fe200078e024eULL,
0x00000009ff507c19ULL, 0x000fe20008011650ULL, 0x000000024d4c7825ULL, 0x108fe200078e0056ULL,
0x0000006d9a957211ULL, 0x000fe400078fe0ffULL, 0x0000000550507c48ULL, 0x000fe2000bfe0000ULL,
0x000000025b5a7825ULL, 0x000fe200078e0056ULL, 0x000000064ca77981ULL, 0x0044e6000c1e9500ULL,
0x000000044f6b7c24ULL, 0x000fe2000f8e02ffULL, 0x000000065aa87981ULL, 0x000ee2000c1e9500ULL,
0x00000004508b7c24ULL, 0x000fc4000f8e02ffULL, 0x000000014e537824ULL, 0x000fe200078e026bULL,
0x0000006b9a597211ULL, 0x000fe200078fe0ffULL, 0x000000014e4f7824ULL, 0x000fe200078e026dULL,
0x00000010aa857812ULL, 0x000fe200078efcffULL, 0x0000000295947825ULL, 0x000fc800078e0056ULL,
0x000000014e5d7824ULL, 0x000fe400078e028bULL, 0x00000002534c7825ULL, 0x104fe200078e0056ULL,
0x0000000694947981ULL, 0x000566000c1e9500ULL, 0x0000000259587825ULL, 0x100fe400078e0056ULL,
0x000000064c4c7981ULL, 0x000f64000c1e9500ULL, 0x000000024f4e7825ULL, 0x000fc400078e0056ULL,
0x0000000658957981ULL, 0x004f64000c1e9500ULL, 0x0000000885507c36ULL, 0x000fe40008000000ULL,
0x000000064e977981ULL, 0x000562000c1e9500ULL, 0x0000008b9a557211ULL, 0x000fe200078fe0ffULL,
0x0000000a85867c36ULL, 0x000fe20008000000ULL, 0x00000005505a7e46ULL, 0x002fe2000b800060ULL,
0x000000025d527825ULL, 0x000fe200078e0056ULL, 0x000000ab5000720cULL, 0x080fe40003f26070ULL,
0x00000004ff5a7819ULL, 0x000fe2000001165aULL, 0x0000000255547825ULL, 0x000fe200078e0056ULL,
0x000000ab8600720cULL, 0x000fe20003f06070ULL, 0x0000000652527981ULL, 0x000f62000c1e9500ULL,
0x0000000586987e46ULL, 0x000fc4000b800060ULL, 0x000000ff5a5a7207ULL, 0x000fe20000800000ULL,
0x0000000654937981ULL, 0x000362000c1e9500ULL, 0x000000ff98987207ULL, 0x000fc60000000000ULL,
0x00000001698f7824ULL, 0x000fe200078e025aULL, 0x0000006d984f7211ULL, 0x004fe200078fe0ffULL,
0x000000015a8d7824ULL, 0x000fe200078e026dULL, 0x0000006998557211ULL, 0x002fe200078fe0ffULL,
0x000000028f8e7825ULL, 0x000fe200078e0056ULL, 0x00000020aa6f7812ULL, 0x000fc600078efcffULL,
0x000000028d8c7825ULL, 0x100fe400078e0056ULL, 0x000000068e8e7981ULL, 0x000ea4000c1e9500ULL,
0x0000000255547825ULL, 0x100fe400078e0056ULL, 0x000000068c8c7981ULL, 0x000ea4000c1e9500ULL,
0x000000024f4e7825ULL, 0x000fe400078e0056ULL, 0x0000000654897981ULL, 0x0002a4000c1e9500ULL,
0x000000086f5d7c36ULL, 0x000fc40008000000ULL, 0x000000064e877981ULL, 0x0002a2000c1e9500ULL,
0x0000000a6f707c36ULL, 0x000fe20008000000ULL, 0x0000006b985b7211ULL, 0x000fe200078fe0ffULL,
0x000000015a4d7824ULL, 0x000fe200078e026bULL, 0x0000008b98597211ULL, 0x000fe200078fe0ffULL,
0x000000015a537824ULL, 0x000fe200078e028bULL, 0x000000055d627e46ULL, 0x000fe2000b800060ULL,
0x000000025b5a7825ULL, 0x100fe200078e0056ULL, 0x000000ab7000720cULL, 0x080fe40003f06070ULL,
0x0000000570507e46ULL, 0x000fe2000b800060ULL, 0x0000000259587825ULL, 0x000fe200078e0056ULL,
0x000000ab5d00720cULL, 0x000fe20003f26070ULL, 0x000000065a8a7981ULL, 0x0002a2000c1e9500ULL,
0x00000004ff627819ULL, 0x000fe20000011662ULL, 0x000000024d547825ULL, 0x102fe200078e0056ULL,
0x000000ff50507207ULL, 0x000fe20000000000ULL, 0x0000000658887981ULL, 0x000ea4000c1e9500ULL,
0x00000002534e7825ULL, 0x000fe200078e0056ULL, 0x000000ff62627207ULL, 0x000fe20000800000ULL,
0x00000006544d7981ULL, 0x000ea2000c1e9500ULL, 0x0000006d50737211ULL, 0x000fc600078fe0ffULL,
0x000000064e537981ULL, 0x0002a2000c1e9500ULL, 0x00000001625b7824ULL, 0x000fe400078e026dULL,
0x0000000273727825ULL, 0x000fc800078e0056ULL, 0x000000025b5a7825ULL, 0x000fe400078e0056ULL,
0x0000000672727981ULL, 0x000ea2000c1e9500ULL, 0x00000069504f7211ULL, 0x042fe200078fe0ffULL,
0x0000000169597824ULL, 0x000fe400078e0262ULL, 0x000000065a757981ULL, 0x000ea4000c1e9500ULL,
0x000000024f4e7825ULL, 0x000fe200078e0056ULL, 0x0000006b50677211ULL, 0x000fc600078fe0ffULL,
0x0000000259587825ULL, 0x000fe200078e0056ULL, 0x0000008b50657211ULL, 0x000fe200078fe0ffULL,
0x000000064e7c7981ULL, 0x0002a4000c1e9500ULL, 0x0000000162557824ULL, 0x040fe400078e026bULL,
0x00000001625d7824ULL, 0x000fe200078e028bULL, 0x00000006587f7981ULL, 0x0002a2000c1e9500ULL,
0x0000000267667825ULL, 0x000fc800078e0056ULL, 0x00000002554e7825ULL, 0x102fe200078e0056ULL,
0x0000000666737981ULL, 0x0002a6000c1e9500ULL, 0x000000025d547825ULL, 0x100fe200078e0056ULL,
0x00000030aa587812ULL, 0x000fe200078efcffULL, 0x000000064e4e7981ULL, 0x0002a4000c1e9500ULL,
0x0000000265647825ULL, 0x000fe400078e0056ULL, 0x0000000654547981ULL, 0x000ea4000c1e9500ULL,
0x0000000858597c36ULL, 0x000fc40008000000ULL, 0x0000000664717981ULL, 0x0002a2000c1e9500ULL,
0x0000000a585d7c36ULL, 0x000fe40008000000ULL, 0x0000000559627e46ULL, 0x000fe4000b800060ULL,
0x000000ab5900720cULL, 0x080fe40003f26070ULL, 0x000000ab5d00720cULL, 0x000fe40003f06070ULL,
0x000000055d967e46ULL, 0x000fe4000b800060ULL, 0x00000004ff627819ULL, 0x000fc40000011662ULL,
0x000000ff96967207ULL, 0x000fe40000000000ULL, 0x000000ff62607207ULL, 0x000fe40000800000ULL,
0x0000006996677211ULL, 0x042fe400078fe0ffULL, 0x0000006b96817211ULL, 0x000fe200078fe0ffULL,
0x00000001695b7824ULL, 0x000fe400078e0260ULL, 0x00000001606b7824ULL, 0x000fe400078e026bULL,
0x0000000267667825ULL, 0x000fc800078e0056ULL, 0x000000025b5a7825ULL, 0x100fe400078e0056ULL,
0x0000000666667981ULL, 0x000ea4000c1e9500ULL, 0x0000000281807825ULL, 0x100fe400078e0056ULL,
0x000000065a697981ULL, 0x0002a4000c1e9500ULL, 0x000000026b6a7825ULL, 0x000fe400078e0056ULL,
0x0000000680627981ULL, 0x000ea2000c1e9500ULL, 0x0000006d96837211ULL, 0x000fc600078fe0ffULL,
0x000000066a4f7981ULL, 0x000ea2000c1e9500ULL, 0x00000001606d7824ULL, 0x000fe400078e026dULL,
0x0000000283827825ULL, 0x000fc800078e0056ULL, 0x000000026d6c7825ULL, 0x000fe200078e0056ULL,
0x0000000682647981ULL, 0x0002a4000c1e9500ULL, 0x0000008b965b7211ULL, 0x002fe400078fe0ffULL,
0x000000066c677981ULL, 0x0002a2000c1e9500ULL, 0x00000001608b7824ULL, 0x000fe400078e028bULL,
0x000000025b5a7825ULL, 0x000fc800078e0056ULL, 0x000000028b567825ULL, 0x000fe200078e0056ULL,
0x000000065a607981ULL, 0x000ea8000c1e9500ULL, 0x0000000656657981ULL, 0x0002a2000c1e9500ULL,
0xfffffff09a9a7812ULL, 0x000fe200078ec0ffULL, 0x00000001ff997424ULL, 0x000fc800078e00ffULL,
0x00000001ab9a7824ULL, 0x000fc800078e029aULL, 0x00000001a9a67824ULL, 0x000fe200078e0a9aULL,
0x00000001aa917812ULL, 0x000fe400078efcffULL, 0xfffffff050507812ULL, 0x000fe400078ec0ffULL,
0x000000a699a67219ULL, 0x000fe400000006ffULL, 0xfffffff096967812ULL, 0x000fe200078ec0ffULL,
0x0000000a91927c36ULL, 0x000fe40008000000ULL, 0x00000001ab9b7824ULL, 0x000fc400078e0250ULL,
0x00000001ab507824ULL, 0x000fe400078e0296ULL, 0x0000000192967824ULL, 0x000fe200078e0a9aULL,
0x00000008aa8d7812ULL, 0x040fe400078efcffULL, 0x00000009aa8b7812ULL, 0x000fe400078efcffULL,
0x0000009699967219ULL, 0x000fe400000006ffULL, 0xfffffff098987812ULL, 0x000fe200078ec0ffULL,
0x0000000a8d907c36ULL, 0x000fc40008000000ULL, 0x0000000a8b8f7c36ULL, 0x000fe40008000000ULL,
0x00000001ab9d7824ULL, 0x000fe400078e0298ULL, 0x0000000190987824ULL, 0x100fe400078e0a9aULL,
0x000000018f9a7824ULL, 0x000fe200078e0a9aULL, 0x00000011aa837812ULL, 0x040fe400078efcffULL,
0x0000009899987219ULL, 0x040fe400000006ffULL, 0x0000009a999a7219ULL, 0x000fe200000006ffULL,
0x0000000a83847c36ULL, 0x000fe20008000000ULL, 0x00000021aa6d7812ULL, 0x002fc400078efcffULL,
0x00000028aa6a7812ULL, 0x040fe400078efcffULL, 0x00000029aa687812ULL, 0x000fe200078efcffULL,
0x0000000a6d6e7c36ULL, 0x000fe40008000000ULL, 0x0000000a6a6c7c36ULL, 0x000fe40008000000ULL,
0x0000000a686b7c36ULL, 0x000fe40008000000ULL, 0x0000000186b67824ULL, 0x000fe200078e0a9dULL,
0x00005410a7a77816ULL, 0x008fc800000000a8ULL, 0x000000a7a6ff7212ULL, 0x000fc800078ac0ffULL,
0x000000aba900720cULL, 0x000fc80002fa1470ULL, 0x000000abaa00720cULL, 0x000fe40002fa1070ULL,
0x000000a796ff7212ULL, 0x000fe4000788c0ffULL, 0xff80000049497808ULL, 0x000fe40002800000ULL,
0x0000541095957816ULL, 0x020fe4000000004cULL, 0x0000541094977816ULL, 0x000fe40000000097ULL,
0x00000095a6ff7212ULL, 0x000fc4000782c0ffULL, 0x00000097a6ff7212ULL, 0x080fe4000784c0ffULL,
0x0000009796ff7212ULL, 0x000fe400078ac0ffULL, 0x000000aba900720cULL, 0x0c0fe40001741470ULL,
0x000000aba900720cULL, 0x080fe40000f21470ULL, 0x000000ab9200720cULL, 0x0c0fe40002781470ULL,
0x000000ab9200720cULL, 0x000fc40002fa1470ULL, 0x000000abaa00720cULL, 0x0c0fe40001741070ULL,
0x000000abaa00720cULL, 0x080fe40000f21070ULL, 0x000000ab9100720cULL, 0x0c0fe40002781070ULL,
0x000000ab9100720cULL, 0x000fe40002fa1070ULL, 0x0000541093937816ULL, 0x000fe40000000052ULL,
0xff80000042427808ULL, 0x000fc40001000000ULL, 0xff8000004b4b7808ULL, 0x000fe40000800000ULL,
0xff80000041417808ULL, 0x000fe40002000000ULL, 0xff80000043437808ULL, 0x000fe40002800000ULL,
0x000000a798ff7212ULL, 0x000fe4000786c0ffULL, 0x00000093a6ff7212ULL, 0x000fe4000780c0ffULL,
0x0000009596ff7212ULL, 0x000fc4000784c0ffULL, 0x0000009396ff7212ULL, 0x000fe4000782c0ffULL,
0x000000979aff7212ULL, 0x000fe4000788c0ffULL, 0x0000009598ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001849c7824ULL, 0x000fe200078e0a9dULL, 0x000000aba900720cULL, 0x080fe40000701470ULL,
0x000000ab9200720cULL, 0x0c0fe40001741470ULL, 0x000000ab9200720cULL, 0x000fc40000f21470ULL,
0x000000ab9000720cULL, 0x0c0fe40001f61470ULL, 0x000000ab9000720cULL, 0x080fe40002fa1470ULL,
0x000000ab8f00720cULL, 0x080fe20002781470ULL, 0x0000000170b27824ULL, 0x100fe200078e0a9bULL,
0x00000018aa807812ULL, 0x000fe200078efcffULL, 0x000000016ea07824ULL, 0x100fe200078e0a9bULL,
0x00000019aa7e7812ULL, 0x000fe200078efcffULL, 0x000000016cb07824ULL, 0x100fe200078e0a9bULL,
0x000000abaa00720cULL, 0x080fe20000701070ULL, 0x000000016ba27824ULL, 0x000fe200078e0a9bULL,
0x000000ab9100720cULL, 0x000fc40001741070ULL, 0x000000ab9100720cULL, 0x080fe40000f21070ULL,
0x000000ab8d00720cULL, 0x0c0fe40001f61070ULL, 0x000000ab8d00720cULL, 0x080fe40002fa1070ULL,
0x000000ab8b00720cULL, 0x000fe40002781070ULL, 0x000000b6999b7219ULL, 0x040fe400000006ffULL,
0x0000009c999c7219ULL, 0x000fc400000006ffULL, 0x0000541089897816ULL, 0x004fe4000000008eULL,
0x0000541087877816ULL, 0x000fe2000000008cULL, 0x0000000a80827c36ULL, 0x000fe20008000000ULL,
0xff80000022227808ULL, 0x000fe20000000000ULL, 0x0000000a7e817c36ULL, 0x000fe20008000000ULL,
0xff80000021217808ULL, 0x000fe40001000000ULL, 0xff80000023237808ULL, 0x000fe40000800000ULL,
0xff8000003c3c7808ULL, 0x000fc40001800000ULL, 0xff8000001c1c7808ULL, 0x000fe40002800000ULL,
0xff8000003f3f7808ULL, 0x000fe40002000000ULL, 0x0000009798ff7212ULL, 0x000fe4000780c0ffULL,
0x000000959aff7212ULL, 0x000fe4000784c0ffULL, 0x0000009398ff7212ULL, 0x080fe4000782c0ffULL,
0x000000939aff7212ULL, 0x000fc4000786c0ffULL, 0x000000899cff7212ULL, 0x000fe400078ac0ffULL,
0x000000879bff7212ULL, 0x000fe2000788c0ffULL, 0x0000000182b47824ULL, 0x100fe200078e0a9dULL,
0x000000ab9000720cULL, 0x0c0fe20000701470ULL, 0x00000001819e7824ULL, 0x000fe200078e0a9dULL,
0x000000ab9000720cULL, 0x080fe40000f21470ULL, 0x000000ab8f00720cULL, 0x0c0fe40001741470ULL,
0x000000ab8f00720cULL, 0x000fc40001f61470ULL, 0x000000ab8600720cULL, 0x080fe40002781470ULL,
0x000000ab8400720cULL, 0x080fe40002fa1470ULL, 0x000000ab8d00720cULL, 0x0c0fe40000701070ULL,
0x000000ab8d00720cULL, 0x080fe40000f21070ULL, 0x000000ab8b00720cULL, 0x0c0fe40001741070ULL,
0x000000ab8b00720cULL, 0x000fc40001f61070ULL, 0x000000ab8500720cULL, 0x080fe40002781070ULL,
0x000000ab8300720cULL, 0x000fe40002fa1070ULL, 0x000000b4999d7219ULL, 0x040fe400000006ffULL,
0x0000009e999e7219ULL, 0x000fe400000006ffULL, 0x000054108a4d7816ULL, 0x000fe4000000004dULL,
0x0000541088537816ULL, 0x000fc40000000053ULL, 0xff8000003e3e7808ULL, 0x000fe40000000000ULL,
0xff8000001e1e7808ULL, 0x000fe40000800000ULL, 0xff8000001d1d7808ULL, 0x000fe40001000000ULL,
0xff8000001f1f7808ULL, 0x000fe40001800000ULL, 0xff8000003a3a7808ULL, 0x000fe40002000000ULL,
0xff80000039397808ULL, 0x000fc40002800000ULL, 0x000000899bff7212ULL, 0x080fe4000780c0ffULL,
0x000000899dff7212ULL, 0x000fe4000782c0ffULL, 0x0000004d9bff7212ULL, 0x040fe4000784c0ffULL,
0x000000539bff7212ULL, 0x000fe4000786c0ffULL, 0x0000004d9cff7212ULL, 0x000fe4000788c0ffULL,
0x000000879eff7212ULL, 0x000fc400078ac0ffULL, 0x000000ab8600720cULL, 0x0c0fe40000701470ULL,
0x000000ab8600720cULL, 0x0c0fe40001741470ULL, 0x000000ab8600720cULL, 0x080fe40001f61470ULL,
0x000000ab8400720cULL, 0x080fe40002781470ULL, 0x000000ab8200720cULL, 0x080fe40000f21470ULL,
0x000000ab8100720cULL, 0x000fc40002fa1470ULL, 0x000000ab8500720cULL, 0x0c0fe40000701070ULL,
0x000000ab8500720cULL, 0x0c0fe40001741070ULL, 0x000000ab8500720cULL, 0x080fe40001f61070ULL,
0x000000ab8300720cULL, 0x080fe40002781070ULL, 0x000000ab8000720cULL, 0x080fe40000f21070ULL,
0x000000ab7e00720cULL, 0x000fc40002fa1070ULL, 0x000000b2999f7219ULL, 0x000fe400000006ffULL,
0x0000541072727816ULL, 0x000fe40000000075ULL, 0xff80000038387808ULL, 0x000fe40000000000ULL,
0xff80000018187808ULL, 0x000fe40001000000ULL, 0xff8000001a1a7808ULL, 0x000fe40001800000ULL,
0xff80000019197808ULL, 0x000fc40002000000ULL, 0xff80000034347808ULL, 0x000fe40000800000ULL,
0xff80000037377808ULL, 0x000fe40002800000ULL, 0x000000879cff7212ULL, 0x040fe4000780c0ffULL,
0x000000539cff7212ULL, 0x000fe4000784c0ffULL, 0x000000879dff7212ULL, 0x000fe4000786c0ffULL,
0x0000004d9eff7212ULL, 0x000fc4000788c0ffULL, 0x000000539eff7212ULL, 0x000fe4000782c0ffULL,
0x000000729fff7212ULL, 0x000fe400078ac0ffULL, 0x000000ab8400720cULL, 0x0c0fe40000701470ULL,
0x000000ab8400720cULL, 0x080fe40001741470ULL, 0x000000ab8200720cULL, 0x080fe40001f61470ULL,
0x000000ab8100720cULL, 0x000fc40002781470ULL, 0x000000ab8100720cULL, 0x080fe40000f21470ULL,
0x000000ab7000720cULL, 0x080fe40002fa1470ULL, 0x000000ab8300720cULL, 0x0c0fe40000701070ULL,
0x000000ab8300720cULL, 0x080fe40001741070ULL, 0x000000ab8000720cULL, 0x080fe40001f61070ULL,
0x000000ab7e00720cULL, 0x000fc40002781070ULL, 0x000000ab7e00720cULL, 0x080fe40000f21070ULL,
0x000000ab6f00720cULL, 0x000fe40002fa1070ULL, 0x000000a099a07219ULL, 0x000fe400000006ffULL,
0x000054107c7c7816ULL, 0x000fe4000000007fULL, 0x00005410734e7816ULL, 0x000fe4000000004eULL,
0x0000541071547816ULL, 0x000fc40000000054ULL, 0xff8000003b3b7808ULL, 0x000fe40000000000ULL,
0xff8000001b1b7808ULL, 0x000fe40001000000ULL, 0xff80000036367808ULL, 0x000fe40001800000ULL,
0xff80000015157808ULL, 0x000fe40002000000ULL, 0xff80000017177808ULL, 0x000fe40000800000ULL,
0xff80000032327808ULL, 0x000fc40002800000ULL, 0x000000a79aff7212ULL, 0x000fe400078cc0ffULL,
0x0000004d9dff7212ULL, 0x040fe4000780c0ffULL, 0x000000539dff7212ULL, 0x000fe4000784c0ffULL,
0x0000007c9fff7212ULL, 0x040fe4000786c0ffULL, 0x0000004e9fff7212ULL, 0x040fe4000788c0ffULL,
0x000000549fff7212ULL, 0x000fc4000782c0ffULL, 0x0000004ea0ff7212ULL, 0x000fe400078ac0ffULL,
0x000000ab8f00720cULL, 0x080fe400037c1470ULL, 0x000000ab8200720cULL, 0x0c0fe40000701470ULL,
0x000000ab8200720cULL, 0x080fe40001741470ULL, 0x000000ab7000720cULL, 0x0c0fe40001f61470ULL,
0x000000ab7000720cULL, 0x000fc40002781470ULL, 0x000000ab7000720cULL, 0x080fe40000f21470ULL,
0x000000ab6e00720cULL, 0x080fe40002fa1470ULL, 0x000000ab8b00720cULL, 0x080fe400037c1070ULL,
0x000000ab8000720cULL, 0x0c0fe40000701070ULL, 0x000000ab8000720cULL, 0x080fe40001741070ULL,
0x000000ab6f00720cULL, 0x000fc40001f61070ULL, 0x000000ab6f00720cULL, 0x0c0fe40002781070ULL,
0x000000ab6f00720cULL, 0x080fe40000f21070ULL, 0x000000ab6d00720cULL, 0x000fe40002fa1070ULL,
0x000000b099a17219ULL, 0x040fe400000006ffULL, 0x000000a299a27219ULL, 0x000fe400000006ffULL,
0xff8000003d3d7808ULL, 0x000fc40003000000ULL, 0xff80000014147808ULL, 0x000fe40000000000ULL,
0xff80000016167808ULL, 0x000fe40001000000ULL, 0xff80000030307808ULL, 0x000fe40001800000ULL,
0xff80000010107808ULL, 0x000fe40002000000ULL, 0xff80000012127808ULL, 0x000fe40000800000ULL,
0xff80000011117808ULL, 0x000fc40002800000ULL, 0x000000899eff7212ULL, 0x000fe400078cc0ffULL,
0x0000007ca0ff7212ULL, 0x0c0fe4000780c0ffULL, 0x0000007ca1ff7212ULL, 0x040fe4000784c0ffULL,
0x00000072a0ff7212ULL, 0x040fe4000786c0ffULL, 0x00000054a0ff7212ULL, 0x000fe4000788c0ffULL,
0x00000072a1ff7212ULL, 0x000fc4000782c0ffULL, 0x0000004ea2ff7212ULL, 0x000fe200078ac0ffULL,
0x000000015dae7824ULL, 0x000fe200078e0a50ULL, 0x000000ab8100720cULL, 0x080fe400037c1470ULL,
0x000000ab6e00720cULL, 0x0c0fe40000701470ULL, 0x000000ab6e00720cULL, 0x0c0fe40001f61470ULL,
0x000000ab6e00720cULL, 0x080fe40002781470ULL, 0x000000ab6c00720cULL, 0x000fc40001741470ULL,
0x000000ab6c00720cULL, 0x080fe40000f21470ULL, 0x000000ab6b00720cULL, 0x080fe40002fa1470ULL,
0x00000031aa577812ULL, 0x040fe400078efcffULL, 0x00000038aa567812ULL, 0x040fe400078efcffULL,
0x00000039aa557812ULL, 0x000fe400078efcffULL, 0x000000ab7e00720cULL, 0x000fc400037c1070ULL,
0x000000ab6d00720cULL, 0x0c0fe40000701070ULL, 0x000000ab6d00720cULL, 0x0c0fe40001f61070ULL,
0x000000ab6d00720cULL, 0x080fe40002781070ULL, 0x000000ab6a00720cULL, 0x0c0fe40001741070ULL,
0x000000ab6a00720cULL, 0x080fe40000f21070ULL, 0x000000ab6800720cULL, 0x000fc40002fa1070ULL,
0x000000ae99a37219ULL, 0x000fe400000006ffULL, 0x0000541066667816ULL, 0x000fe40000000069ULL,
0x00005410624f7816ULL, 0x000fe2000000004fULL, 0x0000000a575b7c36ULL, 0x000fe20008000000ULL,
0xff80000035357808ULL, 0x000fe20003000000ULL, 0x0000000a565a7c36ULL, 0x000fe20008000000ULL,
0xff80000031317808ULL, 0x000fe20000000000ULL, 0x0000000a55597c36ULL, 0x000fe20008000000ULL,
0xff80000033337808ULL, 0x000fc40001800000ULL, 0xff80000013137808ULL, 0x000fe40002000000ULL,
0xff8000002c2c7808ULL, 0x000fe40001000000ULL, 0xff8000002e2e7808ULL, 0x000fe40000800000ULL,
0xff8000000d0d7808ULL, 0x000fe40002800000ULL, 0x0000007ca2ff7212ULL, 0x040fe400078cc0ffULL,
0x00000072a2ff7212ULL, 0x000fc4000780c0ffULL, 0x0000004ea1ff7212ULL, 0x040fe4000786c0ffULL,
0x00000054a1ff7212ULL, 0x080fe4000788c0ffULL, 0x00000054a2ff7212ULL, 0x000fe4000784c0ffULL,
0x00000066a3ff7212ULL, 0x040fe4000782c0ffULL, 0x0000004fa3ff7212ULL, 0x000fe200078ac0ffULL,
0x000000015ba47824ULL, 0x100fe200078e0a50ULL, 0x000000ab6c00720cULL, 0x080fe20001f61470ULL,
0x000000015aac7824ULL, 0x100fe200078e0a50ULL, 0x000000ab6c00720cULL, 0x080fe20002781470ULL,
0x0000000159507824ULL, 0x000fe200078e0a50ULL, 0x000000ab6b00720cULL, 0x000fc400037c1470ULL,
0x000000ab6b00720cULL, 0x0c0fe40000701470ULL, 0x000000ab6b00720cULL, 0x080fe40001741470ULL,
0x000000ab5d00720cULL, 0x0c0fe40000f21470ULL, 0x000000ab5d00720cULL, 0x080fe40002fa1470ULL,
0x000000ab6a00720cULL, 0x0c0fe40001f61070ULL, 0x000000ab6a00720cULL, 0x000fc40002781070ULL,
0x000000ab6800720cULL, 0x0c0fe400037c1070ULL, 0x000000ab6800720cULL, 0x0c0fe40000701070ULL,
0x000000ab6800720cULL, 0x080fe40001741070ULL, 0x000000ab5800720cULL, 0x0c0fe40000f21070ULL,
0x000000ab5800720cULL, 0x000fe40002fa1070ULL, 0x000000a499a47219ULL, 0x000fc400000006ffULL,
0x000000ac99a57219ULL, 0x040fe400000006ffULL, 0x0000005099507219ULL, 0x000fe400000006ffULL,
0x0000541064647816ULL, 0x000fe40000000067ULL, 0xff8000000c0c7808ULL, 0x000fe40001800000ULL,
0xff8000000e0e7808ULL, 0x000fe40002000000ULL, 0xff8000002d2d7808ULL, 0x000fc40003000000ULL,
0xff8000002f2f7808ULL, 0x000fe40000000000ULL, 0xff8000000f0f7808ULL, 0x000fe40001000000ULL,
0xff80000028287808ULL, 0x000fe40000800000ULL, 0xff8000000a0a7808ULL, 0x000fe40002800000ULL,
0x00000066a4ff7212ULL, 0x080fe4000786c0ffULL, 0x00000066a5ff7212ULL, 0x000fc4000788c0ffULL,
0x0000006650ff7212ULL, 0x000fe400078cc0ffULL, 0x00000064a3ff7212ULL, 0x080fe4000780c0ffULL,
0x00000064a4ff7212ULL, 0x0c0fe4000784c0ffULL, 0x00000064a5ff7212ULL, 0x000fe4000782c0ffULL,
0x0000004fa4ff7212ULL, 0x000fe400078ac0ffULL, 0x000000ab5d00720cULL, 0x000fc40000701470ULL,
0x000000ab5b00720cULL, 0x0c0fe40001f61470ULL, 0x000000ab5b00720cULL, 0x0c0fe40001741470ULL,
0x000000ab5b00720cULL, 0x080fe40002fa1470ULL, 0x000000ab5a00720cULL, 0x0c0fe40002781470ULL,
0x000000ab5900720cULL, 0x080fe400037c1470ULL, 0x000000ab5a00720cULL, 0x000fc40000f21470ULL,
0x000000ab5800720cULL, 0x080fe40000701070ULL, 0x000000ab5700720cULL, 0x0c0fe40001f61070ULL,
0x000000ab5700720cULL, 0x0c0fe40001741070ULL, 0x000000ab5700720cULL, 0x080fe40002fa1070ULL,
0x000000ab5600720cULL, 0x0c0fe40002781070ULL, 0x000000ab5600720cULL, 0x000fc40000f21070ULL,
0x000000ab5500720cULL, 0x000fe400037c1070ULL, 0x0000541060607816ULL, 0x000fe40000000065ULL,
0xff8000002a2a7808ULL, 0x000fe40000000000ULL, 0xff80000029297808ULL, 0x000fe40001800000ULL,
0xff8000002b2b7808ULL, 0x000fe40001000000ULL, 0xff80000020207808ULL, 0x000fc40002800000ULL,
0xff80000024247808ULL, 0x000fe40002000000ULL, 0xff80000026267808ULL, 0x000fe40000800000ULL,
0xff80000025257808ULL, 0x000fe40003000000ULL, 0x0000006450ff7212ULL, 0x040fe4000780c0ffULL,
0x0000004fa5ff7212ULL, 0x080fe4000786c0ffULL, 0x0000004f50ff7212ULL, 0x000fc4000784c0ffULL,
0x00000060a3ff7212ULL, 0x080fe400078ac0ffULL, 0x00000060a4ff7212ULL, 0x080fe4000788c0ffULL,
0x00000060a5ff7212ULL, 0x080fe4000782c0ffULL, 0x0000006050ff7212ULL, 0x000fe400078cc0ffULL,
0x000000ab5d00720cULL, 0x080fe40002fa1470ULL, 0x000000ab5b00720cULL, 0x000fc40002781470ULL,
0x000000ab5a00720cULL, 0x0c0fe40001f61470ULL, 0x000000ab5a00720cULL, 0x080fe40000f21470ULL,
0x000000ab5900720cULL, 0x0c0fe40000701470ULL, 0x000000ab5900720cULL, 0x0c0fe40001741470ULL,
0x000000ab5900720cULL, 0x080fe400037c1470ULL, 0x000000ab5800720cULL, 0x000fc40002fa1070ULL,
0x000000ab5700720cULL, 0x080fe40002781070ULL, 0x000000ab5500720cULL, 0x0c0fe40000701070ULL,
0x000000ab5600720cULL, 0x0c0fe40001f61070ULL, 0x000000ab5600720cULL, 0x080fe40000f21070ULL,
0x000000ab5500720cULL, 0x0c0fe40001741070ULL, 0x000000ab5500720cULL, 0x000fc400037c1070ULL,
0xff80000027277808ULL, 0x000fe40000000000ULL, 0xff80000044447808ULL, 0x000fe40001800000ULL,
0xff80000045457808ULL, 0x000fe40001000000ULL, 0xff80000040407808ULL, 0x000fe40002800000ULL,
0xff80000048487808ULL, 0x000fe40002000000ULL, 0xff80000046467808ULL, 0x000fc40000800000ULL,
0xff80000047477808ULL, 0x000fce0003000000ULL, 0x000000490400720bULL, 0x004fe20003f1e000ULL,
0x0000000176767836ULL, 0x000fe20000000000ULL, 0xfffffff8ff517812ULL, 0x000fe400078ee251ULL,
0x0000000449047208ULL, 0x000fc80004000000ULL, 0x000000410400720bULL, 0x000fc80003f1e000ULL,
0x00000004414d7208ULL, 0x000fc80004000000ULL, 0x0000003c4d00720bULL, 0x000fc80003f1e000ULL,
0x0000004d3c047208ULL, 0x000fc80004000000ULL, 0x0000003d0400720bULL, 0x000fc80003f1e000ULL,
0x000000043d4d7208ULL, 0x000fc80004000000ULL, 0x000000384d00720bULL, 0x000fc80003f1e000ULL,
0x0000004d38047208ULL, 0x000fc80004000000ULL, 0x000000390400720bULL, 0x000fc80003f1e000ULL,
0x00000004394d7208ULL, 0x000fc80004000000ULL, 0x000000344d00720bULL, 0x000fc80003f1e000ULL,
0x0000004d34047208ULL, 0x000fc80004000000ULL, 0x000000350400720bULL, 0x000fc80003f1e000ULL,
0x00000004354d7208ULL, 0x000fc80004000000ULL, 0x000000304d00720bULL, 0x000fc80003f1e000ULL,
0x0000004d30047208ULL, 0x000fc80004000000ULL, 0x000000310400720bULL, 0x000fc80003f1e000ULL,
0x00000004314d7208ULL, 0x000fc80004000000ULL, 0x0000002c4d00720bULL, 0x000fc80003f1e000ULL,
0x0000004d2c047208ULL, 0x000fc80004000000ULL, 0x0000002d0400720bULL, 0x000fc80003f1e000ULL,
0x000000042d4d7208ULL, 0x000fc80004000000ULL, 0x000000284d00720bULL, 0x000fc80003f1e000ULL,
0x0000004d28047208ULL, 0x000fc80004000000ULL, 0x000000290400720bULL, 0x000fc80003f1e000ULL,
0x00000004294d7208ULL, 0x000fc80004000000ULL, 0x000000244d00720bULL, 0x000fc80003f1e000ULL,
0x0000004d24047208ULL, 0x000fe40004000000ULL, 0x000000420500720bULL, 0x000fe40003f1e000ULL,
0x000000250400720bULL, 0x000fc80003f3e000ULL, 0x00000004254c7208ULL, 0x000fe40004800000ULL,
0x0000000542047208ULL, 0x000fc60004000000ULL, 0x0c401f004c4d7f89ULL, 0x000ea200000e0000ULL,
0x000000430400720bULL, 0x000fc80003f1e000ULL, 0x0000000443057208ULL, 0x000fc80004000000ULL,
0x0000003e0500720bULL, 0x000fc80003f1e000ULL, 0x000000053e047208ULL, 0x000fc80004000000ULL,
0x0000003f0400720bULL, 0x000fc80003f1e000ULL, 0x000000043f057208ULL, 0x000fe40004000000ULL,
0x0000004d4c00720bULL, 0x004fe40003f3e000ULL, 0x0000003a0500720bULL, 0x000fe40003f1e000ULL,
0x0000004c4d4d7208ULL, 0x000fe40004800000ULL, 0x000000053a047208ULL, 0x000fc60004000000ULL,
0x0c201f004d4c7f89ULL, 0x000ea200000e0000ULL, 0x0000003b0400720bULL, 0x000fc80003f1e000ULL,
0x000000043b057208ULL, 0x000fc80004000000ULL, 0x000000360500720bULL, 0x000fc80003f1e000ULL,
0x0000000536047208ULL, 0x000fc80004000000ULL, 0x000000370400720bULL, 0x000fc80003f1e000ULL,
0x0000000437057208ULL, 0x000fe40004000000ULL, 0x0000004c4d00720bULL, 0x004fe40003f3e000ULL,
0x000000320500720bULL, 0x000fe40003f1e000ULL, 0x0000004d4c047208ULL, 0x000fe40004800000ULL,
0x00000005324c7208ULL, 0x000fc60004000000ULL, 0x3fb8aa3b04527820ULL, 0x000fe20000410000ULL,
0x000000334c00720bULL, 0x000fc60003f1e000ULL, 0x3fb8aa3b384f7823ULL, 0x100fe20000010852ULL,
0x0000004c33057208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b414c7823ULL, 0x100fe20000010852ULL,
0x3fb8aa3b3c417823ULL, 0x100fe20000010852ULL, 0x3fb8aa3b344d7823ULL, 0x100fe20000010852ULL,
0x0000002e0500720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b2c347823ULL, 0x100fe20000010852ULL,
0x3fb8aa3b282c7823ULL, 0x100fe20000010852ULL, 0x3fb8aa3b35507823ULL, 0x100fe20000010852ULL,
0x000000052e4e7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b24357823ULL, 0x100fe20000010852ULL,
0x3fb8aa3b49497823ULL, 0x100fe20000010852ULL, 0x0000004c004c7308ULL, 0x000fe20000000800ULL,
0x0000002f4e00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b30307823ULL, 0x100fe20000010852ULL,
0x3fb8aa3b31317823ULL, 0x000fc40000010852ULL, 0x0000004e2f057208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b3d4e7823ULL, 0x100fe20000010852ULL, 0x3fb8aa3b393d7823ULL, 0x000fe20000010852ULL,
0x0000004900497308ULL, 0x000ea20000000800ULL, 0x0000002a0500720bULL, 0x000fc80003f1e000ULL,
0x000000052a3c7208ULL, 0x000fc60004000000ULL, 0x0000004100417308ULL, 0x000fe20000000800ULL,
0x0000002b3c00720bULL, 0x000fc80003f1e000ULL, 0x0000003c2b057208ULL, 0x000fc60004000000ULL,
0x0000004f003c7308ULL, 0x0007e20000000800ULL, 0x000000260500720bULL, 0x000fc80003f1e000ULL,
0x0000000526387208ULL, 0x000fc60004000000ULL, 0x0000004e004e7308ULL, 0x000fe20000000800ULL,
0x000000273800720bULL, 0x000fc80003f1e000ULL, 0x0000003827387208ULL, 0x000fe40004000000ULL,
0x0000004b0600720bULL, 0x000fe20003f1e000ULL, 0x0000003d003d7308ULL, 0x000fe40000000800ULL,
0x0c401f0038397f89ULL, 0x000f6200000e0000ULL, 0x000000064b067208ULL, 0x000fc80004000000ULL,
0x000000210600720bULL, 0x000fe20003f1e000ULL, 0x0000004d004d7308ULL, 0x000fe60000000800ULL,
0x0000000621057208ULL, 0x000fc80004000000ULL, 0x0000001c0500720bULL, 0x000fe20003f1e000ULL,
0x0000005000507308ULL, 0x000fe60000000800ULL, 0x000000051c067208ULL, 0x000fc80004000000ULL,
0x0000001d0600720bULL, 0x000fe20003f1e000ULL, 0x0000003000307308ULL, 0x000fe20000000800ULL,
0x000000393800720bULL, 0x022fe40003f3e000ULL, 0x000000061d057208ULL, 0x000fe40004000000ULL,
0x0000003839387208ULL, 0x000fe20004800000ULL, 0x3fb8aa3b2d397823ULL, 0x100fe20000010852ULL,
0x000000180500720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b292d7823ULL, 0x000fe20000010852ULL,
0x0000003100317308ULL, 0x000fe20000000800ULL, 0x0c201f00384f7f89ULL, 0x008e6200000e0000ULL,
0x0000000518067208ULL, 0x000fc80004000000ULL, 0x000000190600720bULL, 0x000fe40003f1e000ULL,
0x0000003400347308ULL, 0x000fe40000000800ULL, 0x0000000619057208ULL, 0x000fc80004000000ULL,
0x000000140500720bULL, 0x000fe40003f1e000ULL, 0x0000003900397308ULL, 0x000fe40000000800ULL,
0x0000000514067208ULL, 0x000fc80004000000ULL, 0x000000150600720bULL, 0x000fe40003f1e000ULL,
0x0000003500357308ULL, 0x000fe20000000800ULL, 0x0000004f3800720bULL, 0x002fe40003f3e000ULL,
0x0000000615297208ULL, 0x000fe40004000000ULL, 0x000000384f057208ULL, 0x000fe20004800000ULL,
0x3fb8aa3b25387823ULL, 0x000fe20000010852ULL, 0x000000102900720bULL, 0x000fe20003f1e000ULL,
0x0000002c002c7308ULL, 0x000fe40000000800ULL, 0x3fb8aa3b054f7820ULL, 0x000fe20000410000ULL,
0x0000002910067208ULL, 0x000fc60004000000ULL, 0x3fb8aa3b3e287823ULL, 0x100fe2000001084fULL,
0x000000110600720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b3f3e7823ULL, 0x100fe2000001084fULL,
0x3fb8aa3b42247823ULL, 0x100fe2000001084fULL, 0x3fb8aa3b43437823ULL, 0x100fe2000001084fULL,
0x0000000611257208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b36427823ULL, 0x100fe2000001084fULL,
0x3fb8aa3b3a3a7823ULL, 0x100fe2000001084fULL, 0x3fb8aa3b3b3b7823ULL, 0x100fe2000001084fULL,
0x0000000c2500720bULL, 0x000fe20003f1e000ULL, 0x0000002400247308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b32327823ULL, 0x100fe2000001084fULL, 0x3fb8aa3b33337823ULL, 0x100fe2000001084fULL,
0x000000250c067208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe2000001084fULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe2000001084fULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe2000001084fULL,
0x0000000d0600720bULL, 0x000fe20003f1e000ULL, 0x0000004300257308ULL, 0x000e620000000800ULL,
0x3fb8aa3b2b2b7823ULL, 0x000fc4000001084fULL, 0x000000060d297208ULL, 0x000fe40004000000ULL,
0x000000220700720bULL, 0x000fe40003f1e000ULL, 0x0000000a2900720bULL, 0x000fe20003f3e000ULL,
0x0000002800287308ULL, 0x000fe20000000800ULL, 0x0000000722067208ULL, 0x000fe40004000000ULL,
0x000000290a3f7208ULL, 0x000fe40004800000ULL, 0x000000230600720bULL, 0x000fc40003f1e000ULL,
0x000000203f00720bULL, 0x000fe20003f3e000ULL, 0x0000003e00297308ULL, 0x0007e20000000800ULL,
0x0000000623077208ULL, 0x000fe40004000000ULL, 0x0000003f203f7208ULL, 0x000fe40004800000ULL,
0x0000001e0700720bULL, 0x000fe40003f1e000ULL, 0x000000443f00720bULL, 0x000fe20003f3e000ULL,
0x0000003a003a7308ULL, 0x000fe20000000800ULL, 0x000000071e067208ULL, 0x000fc40004000000ULL,
0x0000003f443e7208ULL, 0x008fe20004800000ULL, 0x3fb8aa3b373f7823ULL, 0x100fe2000001084fULL,
0x0000001f0600720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b27377823ULL, 0x000fe2000001084fULL,
0x000000453e00720bULL, 0x000fe20003f3e000ULL, 0x0000003b003b7308ULL, 0x000ee20000000800ULL,
0x000000061f077208ULL, 0x000fe40004000000ULL, 0x0000003e45367208ULL, 0x000fe40004800000ULL,
0x0000001a0700720bULL, 0x000fc60003f1e000ULL, 0x0c401f0036437f89ULL, 0x000f6200000e0000ULL,
0x000000071a067208ULL, 0x000fe20004000000ULL, 0x00000042003e7308ULL, 0x0003e60000000800ULL,
0x0000001b0600720bULL, 0x000fc80003f1e000ULL, 0x000000061b077208ULL, 0x000fe20004000000ULL,
0x0000003f003f7308ULL, 0x000fe60000000800ULL, 0x000000160700720bULL, 0x000fc80003f1e000ULL,
0x0000000716067208ULL, 0x000fe20004000000ULL, 0x0000003200327308ULL, 0x000fe60000000800ULL,
0x000000170600720bULL, 0x000fe40003f1e000ULL, 0x000000433600720bULL, 0x020fe40003f3e000ULL,
0x0000000617077208ULL, 0x000fe20004000000ULL, 0x0000003300337308ULL, 0x000fe20000000800ULL,
0x0000003643437208ULL, 0x000fe20004800000ULL, 0x3fb8aa3b26367823ULL, 0x000fe2000001084fULL,
0x000000120700720bULL, 0x000fc60003f1e000ULL, 0x0c201f0043427f89ULL, 0x002e6200000e0000ULL,
0x0000000712067208ULL, 0x000fe20004000000ULL, 0x0000002e002e7308ULL, 0x000fe60000000800ULL,
0x000000130600720bULL, 0x000fc80003f1e000ULL, 0x0000000613077208ULL, 0x000fe20004000000ULL,
0x0000002f002f7308ULL, 0x000fe60000000800ULL, 0x0000000e0700720bULL, 0x000fc80003f1e000ULL,
0x000000070e067208ULL, 0x000fe20004000000ULL, 0x0000003800387308ULL, 0x000fe60000000800ULL,
0x0000000f0600720bULL, 0x000fe40003f1e000ULL, 0x000000424300720bULL, 0x002fe40003f3e000ULL,
0x000000060f077208ULL, 0x000fe20004000000ULL, 0x0000003600367308ULL, 0x000fe20000000800ULL,
0x0000004342067208ULL, 0x000fc40004800000ULL, 0x000000400700720bULL, 0x000fc60003f1e000ULL,
0x3fb8aa3b06277820ULL, 0x000fe20000410000ULL, 0x0000000740077208ULL, 0x000fe20004000000ULL,
0x0000003700377308ULL, 0x000fe40000000800ULL, 0x3fb8aa3b10427823ULL, 0x100fe20000010827ULL,
0x000000480700720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b4b4b7823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe20000010827ULL,
0x0000000748077208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b14147823ULL, 0x100fe20000010827ULL, 0x0000004b00547308ULL, 0x0003e20000000800ULL,
0x000000460700720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b0c4f7823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b15157823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b18187823ULL, 0x100fe20000010827ULL,
0x0000000746267208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b19197823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b0d527823ULL, 0x100fe20000010827ULL, 0x0000002100557308ULL, 0x000fe20000000800ULL,
0x000000472600720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b114b7823ULL, 0x102fe20000010827ULL,
0x3fb8aa3b0a0a7823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b20437823ULL, 0x100fe20000010827ULL,
0x0000002647267208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b44447823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b45457823ULL, 0x000fe20000010827ULL, 0x0000001c001c7308ULL, 0x000fe40000000800ULL,
0x0c401f0026077f89ULL, 0x000e6c00000e0000ULL, 0x0000001d001d7308ULL, 0x000f700000000800ULL,
0x0000001400587308ULL, 0x0005f00000000800ULL, 0x0000001500597308ULL, 0x0007e20000000800ULL,
0x000000494c14723eULL, 0x004fe200000000ffULL, 0x00000018514c7836ULL, 0x000fe20000000000ULL,
0x000000072600720bULL, 0x002fc80003f1e000ULL, 0x0000002607077208ULL, 0x000fe20004000000ULL,
0x0000001900577308ULL, 0x0003e20000000800ULL, 0x000000242515723eULL, 0x008fc600000000ffULL,
0x0c201f0007107f89ULL, 0x000ea800000e0000ULL, 0x0000001800567308ULL, 0x0006a20000000800ULL,
0x0000003a3b19723eULL, 0x002fce00000000ffULL, 0x0000004200427308ULL, 0x000fe20000000800ULL,
0x0000003c3d18723eULL, 0x008fce00000000ffULL, 0x0000004b004b7308ULL, 0x000fe20000000800ULL,
0x000000100700720bULL, 0x004fc80003f1e000ULL, 0x0000000710077208ULL, 0x000fc60004000000ULL,
0x0000004f004f7308ULL, 0x000fe20000000800ULL, 0x000000030bff7812ULL, 0x000fe2000780c0ffULL,
0x3fb8aa3b07537820ULL, 0x000fc80000410000ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe20000010853ULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe20000010853ULL, 0x3fb8aa3b22227823ULL, 0x100fe20000010853ULL,
0x3fb8aa3b23237823ULL, 0x100fe20000010853ULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe20000010853ULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe20000010853ULL, 0x0000002200117308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b16107823ULL, 0x100fe20000010853ULL, 0x3fb8aa3b17497823ULL, 0x000fe20000010853ULL,
0x000000282917723eULL, 0x000fe200000000ffULL, 0x3c003c00ff287424ULL, 0x000fe200078e00ffULL,
0x000000414e16723eULL, 0x000fe200000000ffULL, 0x3c003c00ff297424ULL, 0x000fc400078e00ffULL,
0x3fb8aa3b12257823ULL, 0x100fe20000010853ULL, 0x00000023000c7308ULL, 0x0002a20000000800ULL,
0x3fb8aa3b133b7823ULL, 0x100fe20000010853ULL, 0x0000001c1d12723eULL, 0x020fe200000000ffULL,
0x3fb8aa3b0e0e7823ULL, 0x100fe20000010853ULL, 0x00000056571c723eULL, 0x000fe200000000ffULL,
0x3fb8aa3b0f0f7823ULL, 0x000fe20000010853ULL, 0x00000003ff4e7819ULL, 0x000fe2000001160bULL,
0x3fb8aa3b40407823ULL, 0x100fe20000010853ULL, 0x0000001e001e7308ULL, 0x000fe20000000800ULL,
0x000000281420723cULL, 0x002fe200000018ffULL, 0x3fb8aa3b46467823ULL, 0x100fe20000010853ULL,
0x3fb8aa3b47477823ULL, 0x100fe20000010853ULL, 0x3fb8aa3b48487823ULL, 0x000fe20000010853ULL,
0x000000110c11723eULL, 0x004fc600000000ffULL, 0x0000001f001f7308ULL, 0x000e620000000800ULL,
0x000000040b0c7810ULL, 0x000fc80007ffe04eULL, 0x000000070c0c7812ULL, 0x000fc600078ec0ffULL,
0x0000001a000d7308ULL, 0x0005e20000000800ULL, 0x0000001e1f13723eULL, 0x002fce00000000ffULL,
0x0000001b00267308ULL, 0x0002e20000000800ULL, 0x0000004d501a723eULL, 0x004fe400000000ffULL,
0x00000058591e723eULL, 0x000fca00000000ffULL, 0x0000001000277308ULL, 0x0005e20000000800ULL,
0x0000003e3f1b723eULL, 0x002fe200000000ffULL, 0x00000008513e7836ULL, 0x000fe40000000000ULL,
0x00000008513f7824ULL, 0x000fe400078e00ffULL, 0x000000083e417824ULL, 0x000fe200078e00ffULL,
0x0000000d261d723eULL, 0x008fe200000000ffULL, 0x0000004900247308ULL, 0x0002e20000000800ULL,
0x000000545510723eULL, 0x004fe200000000ffULL, 0x000000281820723cULL, 0x000fe20000001820ULL,
0x000000084c557824ULL, 0x000fe200078e00ffULL, 0xfffffff83f3f7812ULL, 0x000fc400078ee20cULL,
0xfffffff841417812ULL, 0x000fe400078ee20cULL, 0x00000025003a7308ULL, 0x0005e20000000800ULL,
0x0000001051497836ULL, 0x002fe20000000000ULL, 0xfffffff855557812ULL, 0x000fe400078ee20cULL,
0x00000032330d723eULL, 0x000fe200000000ffULL, 0x00000008494d7824ULL, 0x040fe200078e00ffULL,
0x00000027241f723eULL, 0x008fe400000000ffULL, 0x0000005200527308ULL, 0x000e620000000800ULL,
0x000000281024723cULL, 0x004fe200000018ffULL, 0xfffffff84d4d7812ULL, 0x000fe200078ee20cULL,
0x0000000849497824ULL, 0x000fe200078e00ffULL, 0x00000030310c723eULL, 0x000fc400000000ffULL,
0x000000424b30723eULL, 0x000fe200000000ffULL, 0x000000084c4b7824ULL, 0x000fe200078e00ffULL,
0x0000003b003b7308ULL, 0x000ea20000000800ULL, 0x0000004f5232723eULL, 0x002fce00000000ffULL,
0x0000000e003c7308ULL, 0x0003e20000000800ULL, 0x0000003a3b31723eULL, 0x004fce00000000ffULL,
0x0000000f003d7308ULL, 0x0004e20000000800ULL, 0x000000281c24723cULL, 0x000fe20000001824ULL,
0x00000034390e723eULL, 0x002fe200000000ffULL, 0x000000ffff3a7224ULL, 0x000fe400078e0018ULL,
0x000000ffff3b7224ULL, 0x000fe400078e001aULL, 0x000000ffff187224ULL, 0x000fe200078e0010ULL,
0x0000002d002d7308ULL, 0x000e620000000800ULL, 0x0000002e2f0f723eULL, 0x004fe200000000ffULL,
0x000000ffff1a7224ULL, 0x000fe200078e001cULL, 0x00000035382e723eULL, 0x000fe200000000ffULL,
0x0000100078387824ULL, 0x000fe200078e0209ULL, 0x00000036372f723eULL, 0x000fe200000000ffULL,
0x000000ffff107224ULL, 0x000fe200078e0011ULL, 0x0000003c3d33723eULL, 0x008fe200000000ffULL,
0x000000280c20723cULL, 0x000fe20000001820ULL, 0x0000002a002a7308ULL, 0x000fe20000000800ULL,
0x000000083e3d7824ULL, 0x000fc400078e00ffULL, 0x000000ffff117224ULL, 0x000fe400078e0013ULL,
0x000000ffff137224ULL, 0x000fe200078e001fULL, 0x0000002c2d2c723eULL, 0x002fe200000000ffULL,
0x000000ffff1c7224ULL, 0x000fe200078e0031ULL, 0x0000002b002b7308ULL, 0x000e620000000800ULL,
0x000000283034723cULL, 0x000fee0000001824ULL, 0x0000000a000a7308ULL, 0x000fe20000000800ULL,
0x0000002a2b2d723eULL, 0x002fce00000000ffULL, 0x0000004300437308ULL, 0x000e620000000800ULL,
0x000000034e2a7812ULL, 0x000fe200078ec0ffULL, 0x00000008512b7824ULL, 0x000fe200078e00ffULL,
0x000000282c20723cULL, 0x000fe60000001820ULL, 0x000000012a2a7824ULL, 0x000fe400078e020bULL,
0x0000004400447308ULL, 0x000fe60000000800ULL, 0x000000072a2a7812ULL, 0x000fc400078ec0ffULL,
0x0000000a4324723eULL, 0x002fc600000000ffULL, 0x0000004500457308ULL, 0x000e620000000800ULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee22aULL, 0x00012000380a7836ULL, 0x000fe20000000000ULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee22aULL, 0x000000ffff387224ULL, 0x000fe200078e0014ULL,
0xfffffff849497812ULL, 0x000fe200078ee22aULL, 0x000000ffff147224ULL, 0x000fe200078e0015ULL,
0xfffffff84b4b7812ULL, 0x000fe200078ee22aULL, 0x0000004000407308ULL, 0x000fe20000000800ULL,
0x000000103f3f7824ULL, 0x100fe400078e020aULL, 0x000000102b217824ULL, 0x000fc400078e020aULL,
0x000000ffff2a7224ULL, 0x000fe200078e002cULL, 0x000000444526723eULL, 0x002fe400000000ffULL,
0x0000004800397308ULL, 0x000e620000000800ULL, 0x000000ffff2b7224ULL, 0x000fe400078e002eULL,
0x000000ffff157224ULL, 0x000fe400078e0017ULL, 0x000000103d3d7824ULL, 0x100fe400078e020aULL,
0x000000ffff177224ULL, 0x000fe200078e001bULL, 0x0000004600467308ULL, 0x000fe20000000800ULL,
0x0000001041417824ULL, 0x000fc400078e020aULL, 0x0000001049497824ULL, 0x000fe400078e020aULL,
0x000000ffff1b7224ULL, 0x000fe200078e001eULL, 0x000000403925723eULL, 0x002fe400000000ffULL,
0x0000004700477308ULL, 0x000e620000000800ULL, 0x000000ffff397224ULL, 0x000fe400078e0016ULL,
0x000000ffff167224ULL, 0x000fe400078e0019ULL, 0x000000ffff197224ULL, 0x000fe200078e0012ULL,
0x0000003821007844ULL, 0x0005e20000000200ULL, 0x000000104d4d7824ULL, 0x000fc400078e020aULL,
0x000000ffff2c7224ULL, 0x000fe400078e0030ULL, 0x000000ffff2e7224ULL, 0x000fe400078e0024ULL,
0x000000104b4b7824ULL, 0x100fe200078e020aULL, 0x000000464727723eULL, 0x002fe200000000ffULL,
0x000000ffff127224ULL, 0x000fe400078e001dULL, 0x0000001055557824ULL, 0x000fe400078e020aULL,
0x000000ffff1d7224ULL, 0x000fc400078e0033ULL, 0x000000282434723cULL, 0x000fec0000001834ULL,
0x000000ffff1e7224ULL, 0x000fe400078e0025ULL, 0x000000ffff1f7224ULL, 0x000fe400078e0027ULL,
0x000000ffff217224ULL, 0x004fc400078e0022ULL, 0x000000ffff287224ULL, 0x000fe400078e000cULL,
0x000000ffff297224ULL, 0x000fe400078e000eULL, 0x000000ffff0c7224ULL, 0x000fe400078e000dULL,
0x000000ffff0d7224ULL, 0x000fe200078e000fULL, 0x000000283f007844ULL, 0x0003e20000000200ULL,
0x000000ffff0e7224ULL, 0x000fe400078e002dULL, 0x000000ffff0f7224ULL, 0x000fe200078e002fULL,
0x000000143d007844ULL, 0x0003e20000000200ULL, 0x000000ffff2d7224ULL, 0x000fc400078e0032ULL,
0x000000ffff2f7224ULL, 0x000fe200078e0026ULL, 0x0000000c41007844ULL, 0x0003e20000000200ULL,
0x00000001ff0a7424ULL, 0x000fe400078e00ffULL, 0x000000ffff227224ULL, 0x000fe200078e0034ULL,
0x0000001849007844ULL, 0x0003e20000000200ULL, 0x000000ffff237224ULL, 0x000fc600078e0036ULL,
0x0000002c4d007844ULL, 0x0003e80000000200ULL, 0x000000104b007844ULL, 0x0003e80000000200ULL,
0x0000001c55007844ULL, 0x0003e80000000200ULL, 0x01a000044a008388ULL, 0x0003e80000000c00ULL,
0x01a200204a008388ULL, 0x0003e20000000c00ULL, 0x000000617600720cULL, 0x000fe20003f06070ULL,
0x01a6080a77ff79a7ULL, 0x000fe2000850003fULL, 0x01a6100a77ff79a7ULL, 0x000fe2000850003fULL,
0x01a6180a77ff79a7ULL, 0x000fe2000850003fULL, 0x01a6200a77ff79a7ULL, 0x0005e4000850003fULL,
0x000000ffff0a7224ULL, 0x004fce00078e005cULL, 0xffffff9000e88947ULL, 0x002fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0180000083007836ULL, 0x000fe20000000000ULL,
0x0000013000017945ULL, 0x000fe80003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000008300008308ULL, 0x0002a20000001000ULL,
0x0000000000388947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x007fffff83ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000083027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000000000047947ULL, 0x000fec0003800000ULL,
0x0000008300007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffffe98025c7950ULL, 0x000fea0003c3ffffULL, 0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000002000000008ULL, 0x0000000400000001ULL, 0x0000001000000004ULL, 0x0000000800000001ULL,
0x0000000100000001ULL, 0x0000000100000008ULL, 0x0000000400000003ULL, 0x0000000300000004ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000111ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000017bULL, 0x00000000000004e3ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000660ULL, 0x0000000000000228ULL, 0x0000001500000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000888ULL, 0x00000000000000e0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000968ULL, 0x0000000000000054ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009bcULL, 0x0000000000000700ULL, 0x0000000a00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000004000000b2ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000010c0ULL, 0x0000000000000000ULL, 0x0000000a00000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000e6ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000010c0ULL, 0x0000000000000048ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001108ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001180ULL, 0x0000000000016780ULL, 0x0000001500000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000017900ULL, 0x0000000000000040ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000017940ULL, 0x0000000000000400ULL, 0x0000000a00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000001000000f8ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000017940ULL, 0x0000000000000270ULL, 0x0000000a00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL, 0x0000000000017f30ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000017f30ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x0000000000001108ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001180ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000016780ULL,
0x0000000000016780ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000017900ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000440ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000017940ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000270ULL, 0x0000000000000270ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_pagedKV_128_nqpkv_0_m_32_sm_90_cubin_len = 98432;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
