/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_pagedKV_128_nqpkv_8_m_8_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000010d50ULL, 0x00000000000109d0ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f5f374944327961ULL, 0x326a4c32666c6168ULL,
0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL,
0x4545346a4c6a4963ULL, 0x316a4c4536316a4cULL, 0x4c49746132454536ULL, 0x534b524545453162ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45346a4c4534366aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL,
0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL,
0x4c45346a4c497461ULL, 0x45326a4c4545316aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL,
0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL,
0x4939494432796172ULL, 0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL,
0x4c49746132454531ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x45386a4c4532336aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL,
0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4532ULL, 0x454530624c497461ULL,
0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL,
0x4944327961727241ULL, 0x6a4c6a4963655633ULL, 0x4c45386a4c454534ULL, 0x497461324545386aULL,
0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x386a4c4536316a4cULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5f5f2400676e6964ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x6e72656b24006168ULL, 0x732461686d5f6c65ULL, 0x42657479426d656dULL, 0x632e766e2e006675ULL,
0x30746e6174736e6fULL, 0x5f6c656e72656b2eULL, 0x7261705f0061686dULL, 0x756265642e006d61ULL,
0x00656d6172665f67ULL, 0x6265642e6c65722eULL, 0x656d6172665f6775ULL, 0x642e616c65722e00ULL,
0x6172665f67756265ULL, 0x722e766e2e00656dULL, 0x6f697463612e6c65ULL, 0x000000000000006eULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c0001000000adULL,
0x0000000000000034ULL, 0x0000000000000010ULL, 0x000c0001000000ebULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c00010000016bULL, 0x000000000000002cULL, 0x0000000000000004ULL, 0x000c0001000001adULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c0001000001f3ULL, 0x0000000000000024ULL,
0x0000000000000004ULL, 0x000c00010000023aULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000c000100000280ULL, 0x0000000000000030ULL, 0x0000000000000004ULL, 0x000c0001000002ceULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c00010000031cULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c00010000036aULL, 0x000000000000000cULL, 0x0000000000000004ULL,
0x000c0001000003b0ULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c0001000003feULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000443ULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000b002200000489ULL, 0x000000000000ee20ULL, 0x0000000000000180ULL,
0x000b0022000004bcULL, 0x000000000000efa0ULL, 0x0000000000000040ULL, 0x000b0022000004e7ULL,
0x000000000000efe0ULL, 0x0000000000000050ULL, 0x000b002200000511ULL, 0x000000000000f030ULL,
0x0000000000000150ULL, 0x000a00030000057fULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000400030000059fULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000005cfULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL,
0x000000000000f180ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000ee2000000000ULL, 0x0000040400000000ULL,
0x810c000001340400ULL, 0x003a480400288080ULL, 0x0000000000000000ULL, 0x00000074ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080820828808081ULL, 0x8708288080840828ULL, 0x2880808808288080ULL, 0x8094082880809008ULL,
0x0828808095082880ULL, 0x8080970828808096ULL, 0xb808288080990828ULL, 0x2880808608288080ULL,
0x0003102880828016ULL, 0x9200000000000000ULL, 0x0000220028808086ULL, 0x00000034ffffffffULL,
0x0000007000000000ULL, 0x0000ee2000000000ULL, 0x0000018000000000ULL, 0x0000480400000000ULL,
0x8080288080820900ULL, 0x0900000010042880ULL, 0x2880808228808086ULL, 0x00000074ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080820828808081ULL, 0x8708288080840828ULL, 0x2880808808288080ULL, 0x8094082880809008ULL,
0x0828808095082880ULL, 0x8080990828808096ULL, 0xb808288080b20828ULL, 0x288080b008288080ULL,
0x0003102880828016ULL, 0x9200000000000000ULL, 0x00002200288080b0ULL, 0x0000001cffffffffULL,
0x0000013000000000ULL, 0x0000efa000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x00000074ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8708288080840828ULL, 0x2880808808288080ULL,
0x8094082880809008ULL, 0x0828808095082880ULL, 0x8080970828808096ULL, 0xb808288080990828ULL,
0x2880828016288080ULL, 0x0000000000000310ULL, 0x00288080b8920000ULL, 0x0000000000000022ULL,
0x0000002cffffffffULL, 0x000001d800000000ULL, 0x0000efe000000000ULL, 0x0000005000000000ULL,
0x0000100400000000ULL, 0x8090288080b80900ULL, 0x0000000000002880ULL, 0x00000074ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080820828808081ULL, 0x8708288080840828ULL, 0x2880808808288080ULL, 0x8094082880809008ULL,
0x0828808095082880ULL, 0x8080990828808096ULL, 0x9708288080b80828ULL, 0x2880828016288080ULL,
0x0000000000000310ULL, 0x0028808097920000ULL, 0x0000000000000022ULL, 0x0000002cffffffffULL,
0x0000029000000000ULL, 0x0000f03000000000ULL, 0x0000015000000000ULL, 0x0000180400000000ULL,
0x8090288080970900ULL, 0x0000000000002880ULL, 0x0000001a00082f04ULL, 0x0008230400000064ULL,
0x0000000000000016ULL, 0x0000001600081204ULL, 0x0008110400000000ULL, 0x0000000000000016ULL,
0x0000001500082304ULL, 0x0008120400000000ULL, 0x0000000000000015ULL, 0x0000001500081104ULL,
0x0008230400000000ULL, 0x0000000000000014ULL, 0x0000001400081204ULL, 0x0008110400000000ULL,
0x0000000000000014ULL, 0x0000001300082304ULL, 0x0008120400000000ULL, 0x0000000000000013ULL,
0x0000001300081104ULL, 0x0008230400000000ULL, 0x000000000000001aULL, 0x0000001a00081204ULL,
0x0008110400000000ULL, 0x000000000000001aULL, 0x0000007b00043704ULL, 0x0000001700080a04ULL,
0x0050190300500160ULL, 0x00000000000c1704ULL, 0x0021f00000480006ULL, 0x00000000000c1704ULL,
0x0021f00000400005ULL, 0x00000000000c1704ULL, 0x0011f00000380004ULL, 0x00000000000c1704ULL,
0x0081f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL, 0x00000000000c1704ULL,
0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x0004310400ff1b03ULL,
0x0134290400000020ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x01342804ffffffffULL,
0x000000d0000000c0ULL, 0x0000230000000400ULL, 0x000024d0000023c0ULL, 0x00002ab000002640ULL,
0x00002b3000002ae0ULL, 0x0000442000002b80ULL, 0x000045f0000044c0ULL, 0x00004bc000004750ULL,
0x00004c4000004bf0ULL, 0x0000628000004c90ULL, 0x0000645000006320ULL, 0x00006a20000065b0ULL,
0x00006aa000006a50ULL, 0x000080e000006af0ULL, 0x000082a000008180ULL, 0x0000886000008400ULL,
0x000088e000008890ULL, 0x000090f000008930ULL, 0x0000d66000009100ULL, 0x0000d6b00000d6a0ULL,
0x0000d7100000d6c0ULL, 0x0000d7500000d730ULL, 0x0000e3a00000d760ULL, 0x0000e4400000e3f0ULL,
0x0000e4f00000e490ULL, 0x0000e5a00000e550ULL, 0x0000e6400000e5f0ULL, 0x0000e6f00000e690ULL,
0x0000e7900000e740ULL, 0x0000e8300000e7e0ULL, 0x0000e8e00000e880ULL, 0x0000e9800000e930ULL,
0x0000ea100000e9d0ULL, 0x0000eac00000ea60ULL, 0x0000eb600000eb10ULL, 0x0000ec200000ebc0ULL,
0x0000ece00000ec80ULL, 0x0000eda00000ed40ULL, 0x044039040000ee00ULL, 0x000000ff00000220ULL,
0x003f01000000f600ULL, 0x0000001100000270ULL, 0x003f01200000f608ULL, 0x0000001100000370ULL,
0x003f01200000f688ULL, 0x00000011000003a0ULL, 0x003f01200000f6a8ULL, 0x00000011000003d0ULL,
0x003f01200000f6c8ULL, 0x000000ff00000460ULL, 0x003f01070000f600ULL, 0x0000000900000600ULL,
0x003f010200000004ULL, 0x00000009000006b0ULL, 0x003f010100000000ULL, 0x000000ff00001000ULL,
0x0004010700000000ULL, 0x000000ff00001080ULL, 0x0004010100000000ULL, 0x00000014000010e0ULL,
0x003f010100000020ULL, 0x0000001300001290ULL, 0x003f01050000f6ccULL, 0x0000001300001470ULL,
0x003f01050000f6ccULL, 0x0000004600001e30ULL, 0x003f01070000f6a8ULL, 0x0000004600001fa0ULL,
0x003f01010000f6a8ULL, 0x0000004c00002000ULL, 0x003f01010000f608ULL, 0x0000004c00002020ULL,
0x003f01050000f60cULL, 0x0000004c000021f0ULL, 0x003f01050000f60cULL, 0x0000001600002810ULL,
0x003f01050000f6acULL, 0x00000016000029e0ULL, 0x003f01050000f6acULL, 0x0000001400003390ULL,
0x003f01010000f6c8ULL, 0x0000004900003410ULL, 0x003f01010000f688ULL, 0x0000004d00003490ULL,
0x003f010500000004ULL, 0x0000004d00003660ULL, 0x003f010500000004ULL, 0x0000005800004050ULL,
0x003f01070000f6a8ULL, 0x0000005800004120ULL, 0x003f01010000f6a8ULL, 0x0000004c00004180ULL,
0x003f01010000f628ULL, 0x0000004c000041a0ULL, 0x003f01050000f62cULL, 0x0000004c00004370ULL,
0x003f01050000f62cULL, 0x0000004600004920ULL, 0x003f01050000f6acULL, 0x0000004600004af0ULL,
0x003f01050000f6acULL, 0x0000001000005290ULL, 0x003f010100000000ULL, 0x0000004900005300ULL,
0x003f01010000f690ULL, 0x0000004d00005370ULL, 0x003f010500000004ULL, 0x0000004d00005540ULL,
0x003f010500000004ULL, 0x0000005900005e20ULL, 0x003f010700000000ULL, 0x0000004600005f80ULL,
0x003f01010000f6a8ULL, 0x0000004c00005fe0ULL, 0x003f01010000f648ULL, 0x0000004c00006000ULL,
0x003f01050000f64cULL, 0x0000004c000061d0ULL, 0x003f01050000f64cULL, 0x0000005800006780ULL,
0x003f01050000f6acULL, 0x0000005800006950ULL, 0x003f01050000f6acULL, 0x0000001400007140ULL,
0x003f010100000000ULL, 0x00000049000071b0ULL, 0x003f01010000f698ULL, 0x0000004d00007230ULL,
0x003f010500000004ULL, 0x0000004d00007400ULL, 0x003f010500000004ULL, 0x0000005500007d00ULL,
0x003f010700000000ULL, 0x0000005800007de0ULL, 0x003f01010000f6a8ULL, 0x0000004c00007e40ULL,
0x003f01010000f668ULL, 0x0000004c00007e60ULL, 0x003f01050000f66cULL, 0x0000004c00008030ULL,
0x003f01050000f66cULL, 0x00000046000085c0ULL, 0x003f01050000f6acULL, 0x0000004600008790ULL,
0x003f01050000f6acULL, 0x0000001400008eb0ULL, 0x003f010100000000ULL, 0x0000004900008f10ULL,
0x003f01010000f6a0ULL, 0x000000ff00009ce0ULL, 0x003f01010000f600ULL, 0x000000ff0000aaf0ULL,
0x003f01050000f604ULL, 0x000000ff0000acc0ULL, 0x003f01050000f604ULL, 0x000000ff0000aef0ULL,
0x003f01010000f600ULL, 0x000000ff0000af20ULL, 0x003f01050000f604ULL, 0x000000ff0000b0e0ULL,
0x003f01050000f604ULL, 0x0000003b0000ca90ULL, 0x003f010100000000ULL, 0x0000003b0000cb90ULL,
0x003f010500000004ULL, 0x0000003b0000cd60ULL, 0x003f010500000004ULL, 0x0000003d0000e200ULL,
0x003f010100000000ULL, 0x0000003d0000e260ULL, 0x003f010100000008ULL, 0x0000003d0000e2c0ULL,
0x003f010100000010ULL, 0x0000003d0000e330ULL, 0x003f010100000018ULL, 0x00141c0400053803ULL,
0x00009bf000009970ULL, 0x0000b2000000b140ULL, 0x000004010000e370ULL, 0x00000100000c0504ULL,
0x0000000100000001ULL, 0x0000000000041e04ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x0000000000000324ULL, 0x0000001a00000002ULL, 0x000000000000026cULL, 0x0000001a00000002ULL,
0x00000000000001c4ULL, 0x0000001a00000002ULL, 0x0000000000000104ULL, 0x0000001a00000002ULL,
0x0000000000000044ULL, 0x0000001a00000002ULL, 0x00000000000002faULL, 0x0000001a00000002ULL,
0x0000000000000242ULL, 0x0000001a00000002ULL, 0x000000000000019fULL, 0x0000001a00000002ULL,
0x00000000000000dfULL, 0x0000001a00000002ULL, 0x000000000000f700ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000117919ULL, 0x000e620000002100ULL,
0x0000000000147806ULL, 0x000fe200038e0000ULL, 0x00005800ff387624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000027919ULL, 0x000ea40000002300ULL,
0x0000000838057824ULL, 0x000fe400078e00ffULL, 0x0000000000037919ULL, 0x000ee80000002200ULL,
0x0000000000047919ULL, 0x000f280000000000ULL, 0x0000000000127919ULL, 0x000f280000002600ULL,
0x0000000000397919ULL, 0x000f220000002700ULL, 0x00000005ff407819ULL, 0x002fc60000011611ULL,
0x00001fff020f7589ULL, 0x0043e800000e0000ULL, 0x00001fff40407589ULL, 0x000ea200000e0000ULL,
0x0000010002007a24ULL, 0x008fe400078e0203ULL, 0x0000001400037300ULL, 0x000f2400000e0000ULL,
0x0000000000117a24ULL, 0x000fe400078e0211ULL, 0x0000000000007919ULL, 0x000ee60000000000ULL,
0x000000ff1100720cULL, 0x040fe20003f45270ULL, 0x0000001400147309ULL, 0x000ee20000000000ULL,
0x0000000f1100780cULL, 0x000fc40003f64070ULL, 0x0000007f1100780cULL, 0x040fe40003f84070ULL,
0x000000031100780cULL, 0x000fe40003f24070ULL, 0x000000040300720cULL, 0x010fe20003f02070ULL,
0x0000000812047824ULL, 0x000fc800078e00ffULL, 0x3fffff80ff02a424ULL, 0x002fe400078e00ffULL,
0x000000040f087824ULL, 0x004fe400078e0240ULL, 0x0000003905047224ULL, 0x000fe400078e0204ULL,
0x0000000208057824ULL, 0x000fe200078e00ffULL, 0x00000004ff107819ULL, 0x008fe20000011600ULL,
0x7fffff80ff03a424ULL, 0x000fc600078e00ffULL, 0x00000008050a7817ULL, 0x040fe20007800000ULL,
0x3fffffc0ff06b424ULL, 0x000fe400078e00ffULL, 0x00000001050b7824ULL, 0x000fe200078e0210ULL,
0x00f60002ff00a388ULL, 0x0003e20000000a00ULL, 0x7fffffc0ff07b424ULL, 0x000fe200078e00ffULL,
0x000000011100780cULL, 0x000fe20003f44070ULL, 0x000000010a0e7824ULL, 0x000fe400078e0a05ULL,
0x0000001000057824ULL, 0x000fe200078e00ffULL, 0x00f608061100b388ULL, 0x0005e20000008a00ULL,
0xff317217ff0cc424ULL, 0x000fe200078e00ffULL, 0x0000000e1000720cULL, 0x000fe20003f66070ULL,
0x000000100b137824ULL, 0x000fc400078e00ffULL, 0x00000100ff037424ULL, 0x002fe200078e00ffULL,
0x00f4000c1100c388ULL, 0x0003e20000004800ULL, 0x0000000104027824ULL, 0x000fe400078e020bULL,
0x000000010b047824ULL, 0x000fe400078e0200ULL, 0x00005c0002027625ULL, 0x000fe200078e0003ULL,
0x000000f005077812ULL, 0x004fe400078ec0ffULL, 0xfffffff013047812ULL, 0x000fe200078ee204ULL,
0x3fffff60ff089424ULL, 0x000fe200078e00ffULL, 0x0000000702067210ULL, 0x000fe20007f9e0ffULL,
0x7fffff60ff099424ULL, 0x000fc400078e00ffULL, 0x3fffff80ff0a9424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff0b9424ULL, 0x000fe200078e00ffULL, 0x00f6880811009388ULL, 0x0005e20000008a00ULL,
0x3fffffc0ff0ca424ULL, 0x002fe400078e00ffULL, 0x7fffffc0ff0da424ULL, 0x000fe200078e00ffULL,
0x00f6a80a11009388ULL, 0x000fe20000008a00ULL, 0x000000ffff077224ULL, 0x000fe400020e0603ULL,
0x00000004ff107424ULL, 0x000fe200078e00ffULL, 0x00f6c80c1100a388ULL, 0x000fe60000008a00ULL,
0x0000620039027625ULL, 0x000fc800078e0010ULL, 0x0000001004097824ULL, 0x004fe200078e00ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000ffff087224ULL, 0x000fe200078e0a14ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006097faeULL, 0x0003e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00f60408ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000602417981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0f00720cULL, 0x000fc40003f05270ULL,
0x0000007f410f7810ULL, 0x044fe40007ffe0ffULL, 0x000000ff41047810ULL, 0x000fe40007ffe0ffULL,
0x00000007ff0f7819ULL, 0x000fe4000001160fULL, 0x00000008ff0e7819ULL, 0x000fca0000011604ULL,
0x000096b000008947ULL, 0x000fea0003800000ULL, 0x00000003ff567819ULL, 0x000fe20000011640ULL,
0x00000003ff087424ULL, 0x002fe200078e00ffULL, 0x0000f68840097811ULL, 0x000fe400078e18ffULL,
0x01ffffff56567812ULL, 0x000fc800078ec0ffULL, 0x0000000f5600720cULL, 0x000fda0003f06070ULL,
0x0000000239028824ULL, 0x000fe400078e00ffULL, 0x00006400ff038624ULL, 0x000fc800078e00ffULL,
0x0000640002038624ULL, 0x000fe400078e0203ULL, 0xffffffffff027424ULL, 0x000fe400078e00ffULL,
0x0000000156038824ULL, 0x000fe200078e0203ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000040809ff738cULL, 0x0003e20000000000ULL, 0x0000600003068625ULL, 0x000fe200078e0010ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000606028981ULL, 0x000ea2000c1e1900ULL,
0x000001ff0400780cULL, 0x000fe20003f04070ULL, 0x0000008012037824ULL, 0x000fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fe20000011640ULL, 0x0000000009ff7f8cULL, 0x0007e2000c80043fULL,
0x0000000140087812ULL, 0x002fc600078ec0ffULL, 0x000000200d047824ULL, 0x000fca00078e00ffULL,
0x00000060030a7812ULL, 0x000fe200078ef804ULL, 0x00005800020b7a24ULL, 0x004fc800078e02ffULL,
0x000000800b177824ULL, 0x000fe200078e00ffULL, 0x0000047000000947ULL, 0x000fea0003800000ULL,
0x0000000441077217ULL, 0x008fe20007800000ULL, 0x0000001008087824ULL, 0x000fe200078e00ffULL,
0x00000003ff067819ULL, 0x000fe40000011600ULL, 0x00000070051b7812ULL, 0x000fe200078ec0ffULL,
0x0000000107077824ULL, 0x000fe200078e0a04ULL, 0x00000004060c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000108097824ULL, 0x000fe200078e0206ULL, 0x0000000c06127810ULL, 0x000fe40007ffe0ffULL,
0x0000000807077217ULL, 0x000fe20007800000ULL, 0x00000001090b7824ULL, 0x000fc400078e0200ULL,
0x0000000809107824ULL, 0x000fe400078e00ffULL, 0x000000010a097824ULL, 0x000fe400078e0209ULL,
0x0000000107077824ULL, 0x000fe200078e0a08ULL, 0xfffffff8100b7812ULL, 0x000fe200078ee20bULL,
0x0000000108117824ULL, 0x000fe200078e020cULL, 0x0000000806107810ULL, 0x000fe20007ffe0ffULL,
0x0000000108137824ULL, 0x000fe200078e0212ULL, 0x0000000917167210ULL, 0x000fe20007f1e0ffULL,
0x0000000811197824ULL, 0x040fe200078e00ffULL, 0x000000070600720cULL, 0x080fe20003f66070ULL,
0x0000000111067824ULL, 0x000fe200078e0200ULL, 0x000000071000720cULL, 0x080fe20003f26070ULL,
0x0000000108097824ULL, 0x000fe200078e0210ULL, 0x00005e0016107a11ULL, 0x000fe200078838ffULL,
0x000000ffff157224ULL, 0x000fe200000e06ffULL, 0x000000070c00720cULL, 0x080fe20003f46070ULL,
0x000000010a117824ULL, 0x000fe200078e0211ULL, 0x000000071200720cULL, 0x000fe20003f06070ULL,
0x0000000109087824ULL, 0x000fe200078e0200ULL, 0xfffffff819077812ULL, 0x000fe200078ee206ULL,
0x000000010a067824ULL, 0x000fe200078e0209ULL, 0x00005f0016167a11ULL, 0x000fe200020f3c15ULL,
0x000000010a0a7824ULL, 0x000fe200078e0213ULL, 0x0000001117147210ULL, 0x000fe20007f9e0ffULL,
0x0000000809097824ULL, 0x000fe200078e00ffULL, 0x00000006170c7210ULL, 0x000fe20007fbe0ffULL,
0x0000000113067824ULL, 0x000fe200078e0200ULL, 0x0000000a170a7210ULL, 0x000fe20007fde0ffULL,
0x0000000813117824ULL, 0x000fe200078e00ffULL, 0xfffffff809097812ULL, 0x000fe200078ee208ULL,
0x000000ffff137224ULL, 0x000fe200020e06ffULL, 0x00005e0014127a11ULL, 0x000fe200078838ffULL,
0x000000ffff197224ULL, 0x000fe200028e06ffULL, 0x0000b0000d087811ULL, 0x000fc400078e68ffULL,
0xfffffff811117812ULL, 0x000fe400078ee206ULL, 0x00005f0014147a11ULL, 0x000fe200020f3c13ULL,
0x000000100b057824ULL, 0x100fe200078e0208ULL, 0x000000101b067210ULL, 0x000fe20007f9e0ffULL,
0x0000001007137824ULL, 0x100fe200078e0208ULL, 0x00005e000c0b7a11ULL, 0x000fe200078a38ffULL,
0x0000001009157824ULL, 0x000fe400078e0208ULL, 0x000000ffff097224ULL, 0x000fe200030e06ffULL,
0x00005e000a107a11ULL, 0x000fe200078c38ffULL, 0x000000ffff077224ULL, 0x000fc400020e0616ULL,
0x0000001011177824ULL, 0x000fe200078e0208ULL, 0x0000001b12087210ULL, 0x080fe40007f9e0ffULL,
0x00005f000c117a11ULL, 0x000fe200028f3c19ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006057faeULL, 0x0003e2000d901c46ULL, 0x00005f000a0c7a11ULL, 0x000fe200030f3c09ULL,
0x000000ffff097224ULL, 0x000fe200020e0614ULL, 0x0000001b0b0a7210ULL, 0x080fe40007fbe0ffULL,
0x0000001b10107210ULL, 0x000fe40007f9e0ffULL, 0x0000000008137faeULL, 0x0003e2000d101c46ULL,
0x000000ffff0b7224ULL, 0x000fc400028e0611ULL, 0x000000ffff117224ULL, 0x000fc600020e060cULL,
0x000000000a157faeULL, 0x0003e8000c901c46ULL, 0x0000000010177faeULL, 0x0003e2000c101c46ULL,
0x000003a000007947ULL, 0x000fea0003800000ULL, 0x0000001008077824ULL, 0x008fe200078e00ffULL,
0x0000b0000d197811ULL, 0x000fc800078e68ffULL, 0x0000000700077211ULL, 0x000fc800078fe8ffULL,
0x0000000407097810ULL, 0x040fe20007ffe0ffULL, 0x0000000107067824ULL, 0x140fe400078e0200ULL,
0x00000008070b7824ULL, 0x000fe400078e00ffULL, 0x0000000109087824ULL, 0x040fe400078e0200ULL,
0x0000000809117824ULL, 0x000fe200078e00ffULL, 0xfffffff80b067812ULL, 0x000fe200078ee206ULL,
0x000000010a097824ULL, 0x000fe200078e0209ULL, 0x00000008070b7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff811087812ULL, 0x000fe200078ee208ULL, 0x0000001006137824ULL, 0x000fe200078e0219ULL,
0x0000000c07117810ULL, 0x000fe20007ffe0ffULL, 0x000000010a077824ULL, 0x040fe200078e0207ULL,
0x0000000917107210ULL, 0x000fe20007f5e0ffULL, 0x000000010a0c7824ULL, 0x040fe400078e020bULL,
0x000000080b147824ULL, 0x000fe200078e00ffULL, 0x0000000717127210ULL, 0x000fe20007f3e0ffULL,
0x000000010b077824ULL, 0x000fe200078e0200ULL, 0x0000000c170c7210ULL, 0x000fe20007f7e0ffULL,
0x000000010a0a7824ULL, 0x000fc400078e0211ULL, 0x0000000111097824ULL, 0x040fe200078e0200ULL,
0xfffffff814077812ULL, 0x000fe200078ee207ULL, 0x0000000811167824ULL, 0x000fe200078e00ffULL,
0x0000000a170a7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200008e06ffULL,
0x00005e0012117a11ULL, 0x000fe200078238ffULL, 0x0000001008157824ULL, 0x000fe200078e0219ULL,
0xfffffff816097812ULL, 0x000fe200078ee209ULL, 0x0000001007177824ULL, 0x000fe200078e0219ULL,
0x00005f0012127a11ULL, 0x000fe200008f3c0bULL, 0x000000ffff0b7224ULL, 0x000fe200010e06ffULL,
0x00005e0010087a11ULL, 0x040fe200078238ffULL, 0x0000001009197824ULL, 0x000fe200078e0219ULL,
0x0000007005147812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x000fe200018e06ffULL,
0x00005f0010097a11ULL, 0x000fe200008f3c0bULL, 0x000000ffff057224ULL, 0x000fe200000e06ffULL,
0x00005e000c0b7a11ULL, 0x000fc400078438ffULL, 0x0000001114067210ULL, 0x000fe40007f3e0ffULL,
0x00005e000a107a11ULL, 0x000fe400078638ffULL, 0x00005f000c0c7a11ULL, 0x000fe200010f3c07ULL,
0x000000ffff077224ULL, 0x000fe200008e0612ULL, 0x0000000814087210ULL, 0x000fe40007f1e0ffULL,
0x00005f000a057a11ULL, 0x000fe400018f3c05ULL, 0x0000000b140a7210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200000e0609ULL, 0x0000001014107210ULL, 0x000fe20007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006137faeULL, 0x0003e4000b901c46ULL,
0x000000ffff0b7224ULL, 0x000fc400008e060cULL, 0x000000ffff117224ULL, 0x000fe200010e0605ULL,
0x0000000008157faeULL, 0x0003e8000b901c46ULL, 0x000000000a177faeULL, 0x0003e8000b901c46ULL,
0x0000000010197faeULL, 0x0003e4000b901c46ULL, 0x000000000d0473c2ULL, 0x000ea200000e0000ULL,
0x000000ff0e00720cULL, 0x000fe20003f05270ULL, 0x000000ffff057224ULL, 0x002fe200078e00ffULL,
0x0000f6a80d147811ULL, 0x000fe200078e18ffULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff1d7224ULL, 0x000fe200078e00ffULL, 0x0000f6a804047891ULL, 0x004fd2000f8e203fULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000ff5c7f8cULL, 0x000e62000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000200014147f8cULL, 0x000ea2000c80043fULL, 0x000000ffff1c7224ULL, 0x000fe200078e00ffULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00007df000008947ULL, 0x000fea0003800000ULL, 0x0000000239097824ULL, 0x000fe400078e00ffULL,
0x00006400ff067624ULL, 0x000fc400078e00ffULL, 0xff317217ff5c7424ULL, 0x002fe400078e00ffULL,
0x0000640009097624ULL, 0x000fe400078e0206ULL, 0x000000ffff0b7224ULL, 0x000fe400078e00ffULL,
0x000000ffff127224ULL, 0x000fe400078e00ffULL, 0x000000ffff1b7224ULL, 0x000fc400078e00ffULL,
0x000001000b0a7824ULL, 0x000fca00078e00ffULL, 0x000000410a00720cULL, 0x000fda0003f06070ULL,
0x00007d1000000947ULL, 0x010fea0003800000ULL, 0x000000ffff0a7224ULL, 0x000fe400078e0056ULL,
0x000000ffff0c7224ULL, 0x000fc400078e0012ULL, 0x0000000000107805ULL, 0x000fca0000015200ULL,
0x0000000440137824ULL, 0x000fca00078e00ffULL, 0xfffffff813137812ULL, 0x000fc800078ec0ffULL,
0x0000f6c8134d7810ULL, 0x000fe20007ffe0ffULL, 0x00f6cc0013147984ULL, 0x004e640000000800ULL,
0x8000000014ff7812ULL, 0x002fe40007804815ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff387224ULL, 0x000fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000103800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001610397210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e11ULL, 0x003d09003900780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403900780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011417ULL,
0x0000003914147211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000214147819ULL, 0x000fc80000001217ULL, 0x000000140000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000138387810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00f6cc0013147984ULL, 0x000e640000000800ULL,
0x8000000014ff7812ULL, 0x002fe40007804815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001040107824ULL, 0x000fe200078e00ffULL,
0x000000010b117810ULL, 0x000fe20007ffe0ffULL, 0x0000580002027a24ULL, 0x000fe200078e02ffULL,
0x0000000112487812ULL, 0x000fe400078e0cffULL, 0x0000000e1100720cULL, 0x000fe20003f06070ULL,
0x0000008002437824ULL, 0x000fe200078e00ffULL, 0xffffffe010147812ULL, 0x000fca00078ec0ffULL,
0x000001000b147824ULL, 0x000fca00078e0214ULL, 0x0000004014147810ULL, 0x000fc80007ffe0ffULL,
0x00000060033c7812ULL, 0x000fe200078ef814ULL, 0x0000049000008947ULL, 0x000fea0003800000ULL,
0x0000001010137812ULL, 0x000fe200078ec0ffULL, 0x0000001000107824ULL, 0x000fe200078e00ffULL,
0x00000003ff3d7819ULL, 0x000fe20000011600ULL, 0x000000020d177824ULL, 0x000fc600078e0248ULL,
0x000000043d3e7810ULL, 0x040fe20007ffe0ffULL, 0x000000013d117824ULL, 0x000fe200078e0213ULL,
0x00000070103f7812ULL, 0x000fe400078ec0ffULL, 0x0000b00017177811ULL, 0x000fe200078e60ffULL,
0x000000013c027824ULL, 0x000fe200078e0211ULL, 0x0000000c3d427810ULL, 0x000fc80007ffe0ffULL,
0x0000000243387210ULL, 0x000fe40007f1e0ffULL, 0x0000001441027217ULL, 0x000fc60007800000ULL,
0x000000ffff157224ULL, 0x000fe200000e06ffULL, 0x00005e0038167a11ULL, 0x000fe200078038ffULL,
0x0000000102027824ULL, 0x000fe400078e0a14ULL, 0x0000000111147824ULL, 0x040fe200078e0200ULL,
0x00005f0038387a11ULL, 0x000fe200000f3c15ULL, 0x000000013e157824ULL, 0x000fe200078e0213ULL,
0x0000001302027217ULL, 0x000fe20007800000ULL, 0x0000000811117824ULL, 0x000fe400078e00ffULL,
0x000000013c107824ULL, 0x000fc400078e0215ULL, 0x0000000102027824ULL, 0x000fe200078e0a13ULL,
0xfffffff811147812ULL, 0x000fe200078ee214ULL, 0x0000000815457824ULL, 0x000fe200078e00ffULL,
0x00000010433a7210ULL, 0x000fe40007fde0ffULL, 0x0000003f16107210ULL, 0x000fe20007fbe0ffULL,
0x0000001014397824ULL, 0x000fe200078e0217ULL, 0x000000023d00720cULL, 0x080fe20003f06070ULL,
0x000000ffff3b7224ULL, 0x000fe400030e06ffULL, 0x000000ffff117224ULL, 0x000fe200028e0638ULL,
0x000000023e00720cULL, 0x000fe20003fa6070ULL, 0x0000000115167824ULL, 0x000fe200078e0200ULL,
0x00005e003a387a11ULL, 0x000fc400078c38ffULL, 0x000000083d3e7810ULL, 0x000fe20007ffe0ffULL,
0x00000001423d7824ULL, 0x000fe200078e0213ULL, 0x00005f003a3a7a11ULL, 0x000fe400030f3c3bULL,
0xfffffff845167812ULL, 0x000fe200078ee216ULL, 0x000000013e3b7824ULL, 0x000fe200078e0213ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010397faeULL, 0x0003e2000c101c46ULL,
0x0000003f38147210ULL, 0x000fe40007f1e0ffULL, 0x000000013c157824ULL, 0x000fe400078e023bULL,
0x0000001016137824ULL, 0x000fc600078e0217ULL, 0x0000001543387210ULL, 0x040fe20007fde0ffULL,
0x000000ffff157224ULL, 0x000fe200000e063aULL, 0x000000023e00720cULL, 0x000fe20003f06070ULL,
0x000000013c107824ULL, 0x002fe400078e023dULL, 0x000000ffff397224ULL, 0x000fe200030e06ffULL,
0x0000000014137faeULL, 0x0003e2000e901c46ULL, 0x00005e0038117a11ULL, 0x040fe400078a38ffULL,
0x0000001043167210ULL, 0x000fe40007fde0ffULL, 0x00005f0038387a11ULL, 0x000fc400028f3c39ULL,
0x000000024200720cULL, 0x000fe20003fa6070ULL, 0x000000ffff397224ULL, 0x000fe200030e06ffULL,
0x0000003f11107210ULL, 0x000fe20007fde0ffULL, 0x000000013b027824ULL, 0x040fe400078e0200ULL,
0x000000083b3b7824ULL, 0x000fe400078e00ffULL, 0x000000ffff117224ULL, 0x000fe200030e0638ULL,
0x00005e0016147a11ULL, 0x042fe200078c38ffULL, 0x000000013d137824ULL, 0x000fe200078e0200ULL,
0xfffffff83b027812ULL, 0x000fe200078ee202ULL, 0x000000083d387824ULL, 0x000fe200078e00ffULL,
0x00005f0016157a11ULL, 0x000fc400030f3c39ULL, 0x0000003f14147210ULL, 0x000fe40007fde0ffULL,
0xfffffff838167812ULL, 0x000fe200078ee213ULL, 0x0000001002137824ULL, 0x000fe400078e0217ULL,
0x000000ffff157224ULL, 0x000fe400030e0615ULL, 0x0000001016177824ULL, 0x000fe200078e0217ULL,
0x0000000010137faeULL, 0x0003e8000c101c46ULL, 0x0000000014177faeULL, 0x0003e2000e901c46ULL,
0x000003c000007947ULL, 0x000fea0003800000ULL, 0x0000001010117812ULL, 0x000fc800078ec0ffULL,
0x0000001100117211ULL, 0x000fc800078fe8ffULL, 0x0000000411157810ULL, 0x040fe20007ffe0ffULL,
0x000000013c027824ULL, 0x040fe400078e0211ULL, 0x0000000111107824ULL, 0x100fe400078e0200ULL,
0x0000000115147824ULL, 0x000fe200078e0200ULL, 0x00000002433f7210ULL, 0x000fe20007f1e0ffULL,
0x0000000815177824ULL, 0x000fe400078e00ffULL, 0x0000000811137824ULL, 0x000fe400078e00ffULL,
0x000000013c157824ULL, 0x000fe200078e0215ULL, 0xfffffff817027812ULL, 0x000fe200078ee214ULL,
0x000000ffff167224ULL, 0x000fe200000e06ffULL, 0x0000000811177810ULL, 0x000fc40007ffe0ffULL,
0xfffffff813137812ULL, 0x000fe400078ee210ULL, 0x0000000c11117810ULL, 0x000fe20007ffe0ffULL,
0x000000013c107824ULL, 0x040fe200078e0217ULL, 0x00005e003f3e7a11ULL, 0x000fe400078038ffULL,
0x0000001543157210ULL, 0x040fe20007fde0ffULL, 0x000000013c147824ULL, 0x000fe200078e0211ULL,
0x00000010433c7210ULL, 0x000fe20007fbe0ffULL, 0x0000000117107824ULL, 0x000fe200078e0200ULL,
0x00005f003f3f7a11ULL, 0x000fe200000f3c16ULL, 0x0000000817177824ULL, 0x000fe200078e00ffULL,
0x00000014433a7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff167224ULL, 0x000fe200030e06ffULL,
0x00005e00153b7a11ULL, 0x000fe200078c38ffULL, 0x0000000111147824ULL, 0x000fe200078e0200ULL,
0xfffffff817177812ULL, 0x000fe200078ee210ULL, 0x0000001000107824ULL, 0x000fe200078e00ffULL,
0x00005f00153d7a11ULL, 0x000fe200030f3c16ULL, 0x000000ffff157224ULL, 0x000fe200028e06ffULL,
0x00005e003c167a11ULL, 0x000fe200078a38ffULL, 0x0000000811397824ULL, 0x000fe200078e00ffULL,
0x0000007010437812ULL, 0x000fe200078ec0ffULL, 0x000000ffff117224ULL, 0x000fe200000e06ffULL,
0x00005f003c3c7a11ULL, 0x000fe200028f3c15ULL, 0x000000020d157824ULL, 0x000fe200078e0248ULL,
0xfffffff839397812ULL, 0x000fc400078ee214ULL, 0x00005e003a387a11ULL, 0x000fe400078c38ffULL,
0x000000433e107210ULL, 0x080fe40007f1e0ffULL, 0x000000433b147210ULL, 0x080fe40007fbe0ffULL,
0x00005f003a3a7a11ULL, 0x000fe200030f3c11ULL, 0x000000ffff117224ULL, 0x000fe200000e063fULL,
0x0000b000153e7811ULL, 0x000fe200078e60ffULL, 0x000000ffff157224ULL, 0x000fe200028e063dULL,
0x0000004316167210ULL, 0x000fc40007f1e0ffULL, 0x0000004338387210ULL, 0x000fe20007fbe0ffULL,
0x0000001013137824ULL, 0x100fe400078e023eULL, 0x00000010023b7824ULL, 0x100fe400078e023eULL,
0x00000010173d7824ULL, 0x100fe200078e023eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010137faeULL, 0x0003e2000b901c46ULL, 0x00000010393f7824ULL, 0x000fe400078e023eULL,
0x000000ffff177224ULL, 0x000fe200000e063cULL, 0x00000000143b7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff397224ULL, 0x000fc600028e063aULL, 0x00000000163d7faeULL, 0x0003e8000b901c46ULL,
0x00000000383f7faeULL, 0x0003e4000b901c46ULL, 0x0000000840137824ULL, 0x002fe200078e00ffULL,
0x0000000156027810ULL, 0x000fc80007ffe0ffULL, 0xfffffff013157812ULL, 0x000fe400078ec0ffULL,
0x0000000f0200720cULL, 0x000fe20003f06070ULL, 0xffffffffff027424ULL, 0x000fe400078e00ffULL,
0x0000000848467824ULL, 0x000fca00078e0215ULL, 0x0000000000007918ULL, 0x000fea0000000000ULL,
0x0000000109108810ULL, 0x000fe20007ffe056ULL, 0x00000004ff118424ULL, 0x000fe200078e00ffULL,
0xffffffe0134c7812ULL, 0x040fe400078ec0ffULL, 0x0000001013157812ULL, 0x040fe200078ec0ffULL,
0x0000600010108625ULL, 0x000fe200078e0011ULL, 0x0000000813137812ULL, 0x000fe200078ec0ffULL,
0x000000d000007945ULL, 0x000fe20003800000ULL, 0x0000f6a846597810ULL, 0x000fc40007ffe0ffULL,
0x0000000610028981ULL, 0x000322000c1e1900ULL, 0x000000000000781cULL, 0x000fe40003f0f070ULL,
0x0000004c134c7210ULL, 0x000fd60007ffe015ULL, 0x00000000590403c2ULL, 0x000ea40000060000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff00b9b0ULL, 0x004fe20008000a04ULL, 0x000000000000081cULL, 0x000fe20001f0f070ULL,
0xffffff8000003947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a80046607f8cULL, 0x0004e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f608004c167f8cULL, 0x0002a4000c80043fULL, 0x0000000000107805ULL, 0x002fc40000015200ULL,
0x00f60c004c137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x006fc40007804817ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff387224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001410147210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e11ULL, 0x003d09001400780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401400780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff137819ULL, 0x000fc80000011415ULL,
0x0000001413137211ULL, 0x000fca00078110ffULL, 0x000000ffff147224ULL, 0x000fca00000e0615ULL,
0x0000000213137819ULL, 0x000fc80000001214ULL, 0x000000130000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000138387810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f60c004c137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe40007804817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001000107824ULL, 0x000fe200078e00ffULL, 0x00000001ff4a7819ULL, 0x000fe20000011600ULL,
0x00000020404b7824ULL, 0x000fe400078e00ffULL, 0xffffffffff457424ULL, 0x000fe200078e00ffULL,
0x0000007010397812ULL, 0x000fc400078ec0ffULL, 0xffffff804b4b7812ULL, 0x000fe400078ec0ffULL,
0x0000000c4a4a7812ULL, 0x000fc800078ec0ffULL, 0x0000004b4a107210ULL, 0x000fca0007ffe039ULL,
0x00f0000010137984ULL, 0x000e680000000800ULL, 0x00f2000010147984ULL, 0x0004e20000000800ULL,
0x0000005c1300720bULL, 0x002fe20003f1d000ULL, 0x0000c0827f007947ULL, 0x000fd8000b800000ULL,
0x0000000000107806ULL, 0x004fc800000e0100ULL, 0x0000ffff103a7812ULL, 0x000fe2000780c0ffULL,
0x000004a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff4f7424ULL, 0x000fe400078e00ffULL,
0x000000ffff577224ULL, 0x000fc400078e005cULL, 0x0000001fff477424ULL, 0x000fe400078e00ffULL,
0xffffffffff447424ULL, 0x000fca00078e00ffULL, 0x0000044000008947ULL, 0x000fea0003800000ULL,
0x00000002ff117819ULL, 0x000fe40000011640ULL, 0x0000005c1300720bULL, 0x000fe40003f14000ULL,
0x000000401100720cULL, 0x000fe20003fa5270ULL, 0x0000c0127f007947ULL, 0x000fd4000b800000ULL,
0x0000000000157806ULL, 0x000fc400000e0100ULL, 0x000000804011d824ULL, 0x000fe200078e0239ULL,
0x000000135c577209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe40003800000ULL,
0x000000014a10d824ULL, 0x000fe200078e0211ULL, 0x0000991015117816ULL, 0x000fc800000000ffULL,
0x00f400571000d388ULL, 0x0003e20000000800ULL, 0x000000ff1100720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x800000575c107221ULL, 0x002fe20000010000ULL,
0x000000ff15ff7812ULL, 0x000fe2000780c0ffULL, 0x0000017000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL, 0x0000001000397308ULL, 0x0002ac0000000800ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff107819ULL, 0x002fe20000011600ULL,
0x0000bf527f007947ULL, 0x000fea000b800000ULL, 0x00001f1039107589ULL, 0x0042a400000e0000ULL,
0x0000001024247220ULL, 0x084fe20000410000ULL, 0x0000001025257220ULL, 0x080fe20000410000ULL,
0x0000001034347220ULL, 0x080fe20000410000ULL, 0x0000001035357220ULL, 0x080fe20000410000ULL,
0x0000001030307220ULL, 0x080fe20000410000ULL, 0x0000001031317220ULL, 0x080fe20000410000ULL,
0x0000001020207220ULL, 0x080fe20000410000ULL, 0x0000001021217220ULL, 0x080fe20000410000ULL,
0x000000101c1c7220ULL, 0x080fe20000410000ULL, 0x000000101d1d7220ULL, 0x080fe20000410000ULL,
0x000000102c2c7220ULL, 0x080fe20000410000ULL, 0x000000102d2d7220ULL, 0x080fe20000410000ULL,
0x0000001028287220ULL, 0x080fe20000410000ULL, 0x0000001029297220ULL, 0x080fe20000410000ULL,
0x0000001018187220ULL, 0x080fe20000410000ULL, 0x0000001019197220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0015ff7812ULL, 0x000fe2000780c0ffULL,
0x0000003905057220ULL, 0x004fd80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000800107811ULL, 0x002fe200078ff0ffULL, 0x0000be327f007947ULL, 0x000fea000b800000ULL,
0x00001f1039107589ULL, 0x0002a400000e0000ULL, 0x0000001026267220ULL, 0x084fe20000410000ULL,
0x0000001027277220ULL, 0x080fe20000410000ULL, 0x0000001036367220ULL, 0x080fe20000410000ULL,
0x0000001037377220ULL, 0x080fe20000410000ULL, 0x0000001032327220ULL, 0x080fe20000410000ULL,
0x0000001033337220ULL, 0x080fe20000410000ULL, 0x0000001022227220ULL, 0x080fe20000410000ULL,
0x0000001023237220ULL, 0x080fe20000410000ULL, 0x000000101e1e7220ULL, 0x080fe20000410000ULL,
0x000000101f1f7220ULL, 0x080fe20000410000ULL, 0x000000102e2e7220ULL, 0x080fe20000410000ULL,
0x000000102f2f7220ULL, 0x080fe20000410000ULL, 0x000000102a2a7220ULL, 0x080fe20000410000ULL,
0x000000102b2b7220ULL, 0x080fe20000410000ULL, 0x000000101a1a7220ULL, 0x080fe20000410000ULL,
0x000000101b1b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff3aff7812ULL, 0x000fda0007806015ULL, 0x8000005713130221ULL, 0x000fe20000010000ULL,
0x00007610ff4f0816ULL, 0x000fc6000000004fULL, 0x3fb8aa3b13130820ULL, 0x000fc80000410000ULL,
0x0000001300060308ULL, 0x000e640000000800ULL, 0x0000000614140220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000514057221ULL, 0x008fc20000010000ULL,
0x0000000000107805ULL, 0x000fcc0000015200ULL, 0x000000020d137824ULL, 0x000fc800078e0212ULL,
0x0000000813167824ULL, 0x000fca00078e00ffULL, 0x00f6ac0016147984ULL, 0x000e640000000800ULL,
0x8000000014ff7812ULL, 0x002fe4000780485dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff177224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101700780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001410147210ULL, 0x000fca0007f1e1ffULL, 0x0000000115157824ULL, 0x000fe200000e0e11ULL,
0x003d09001400780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401400780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff137819ULL, 0x000fc80000011415ULL, 0x0000001413137211ULL, 0x000fca00078110ffULL,
0x000000ffff147224ULL, 0x000fca00000e0615ULL, 0x0000000213137819ULL, 0x000fc80000001214ULL,
0x000000130000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000117177810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f6ac0016147984ULL, 0x000e640000000800ULL, 0x8000000014ff7812ULL, 0x002fe4000780485dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099104f107816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff1000720cULL, 0x000fda0003f05270ULL,
0x0000012000000947ULL, 0x000fea0003800000ULL, 0x00000006ff07723eULL, 0x000fe400000000ffULL,
0x00000002ff147819ULL, 0x000fe40000011600ULL, 0x0000541007137816ULL, 0x000fe20000000007ULL,
0x0000ba127f007947ULL, 0x000fea000b800000ULL, 0x00001f1413077589ULL, 0x0002a400000e0000ULL,
0x0000000814087810ULL, 0x000fe20007ffe0ffULL, 0x0000ba427f007947ULL, 0x000fea000b800000ULL,
0x00001f0813087589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001014107810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff177224ULL, 0x000fe200078e0013ULL,
0x00002b4000387802ULL, 0x000fc40000000f00ULL, 0x0000c4a000007944ULL, 0x01efea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001814107810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff177224ULL, 0x004fe200078e0013ULL, 0x00002b9000387802ULL, 0x000fc40000000f00ULL,
0x0000c45000007944ULL, 0x01afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000700117812ULL, 0x000fe200078ec0ffULL, 0x0000000240497824ULL, 0x040fe200078e00ffULL,
0x00000004ff507819ULL, 0x100fe20000011600ULL, 0x0000020040107824ULL, 0x000fe200078e00ffULL,
0x00000008113e7812ULL, 0x000fe200078ef800ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000449117812ULL, 0x000fc400078ec0ffULL, 0xfffff80010427812ULL, 0x000fe200078ec0ffULL,
0x000000083e147824ULL, 0x042fe200078e00ffULL, 0x000000113e117210ULL, 0x000fe40007ffe050ULL,
0x00000008005b7812ULL, 0x000fe400078ec0ffULL, 0xfffffff814117812ULL, 0x000fca00078ee211ULL,
0x0000001011437824ULL, 0x000fc400078e0242ULL, 0x00000004405a7824ULL, 0x000fe200078e00ffULL,
0x000000075b5b7812ULL, 0x000fe200078ef800ULL, 0x000000020d4e7824ULL, 0x000fe200078e0212ULL,
0x009000004314783bULL, 0x004e640000000200ULL, 0x000000045a5a7812ULL, 0x000fe200078ec0ffULL,
0x000000085b117824ULL, 0x040fe200078e00ffULL, 0x0000b0004e4e7811ULL, 0x000fe200078e60ffULL,
0x000000085b3a7824ULL, 0x040fe200078e00ffULL, 0x000000105b557812ULL, 0x000fe200078efcffULL,
0x00000001505a7824ULL, 0x000fc800078e025aULL, 0x000000015b387824ULL, 0x000fe400078e025aULL,
0x0000000855517824ULL, 0x000fc600078e00ffULL, 0xfffffff811117812ULL, 0x000fe400078ee238ULL,
0x0000000238537810ULL, 0x000fc60007ffe0ffULL, 0x0000001011117824ULL, 0x000fe200078e024eULL,
0xfffffff83a537812ULL, 0x000fca00078ee253ULL, 0x000000001110783bULL, 0x008ea20000004200ULL,
0x0000001053387824ULL, 0x000fcc00078e024eULL, 0x000000003838783bULL, 0x000ee20000004200ULL,
0x0000000714148232ULL, 0x082fe40000000000ULL, 0x0000000716168232ULL, 0x000fe40000000000ULL,
0x0000000815158232ULL, 0x080fe40000000000ULL, 0x0000000817178232ULL, 0x000fe20000000000ULL,
0x0000312010107816ULL, 0x004fe400000000ffULL, 0x00003120113f7816ULL, 0x000fc400000000ffULL,
0x00000010ff3c723eULL, 0x000fe400020006ffULL, 0x0000003fff3d723eULL, 0x000fe400020006ffULL,
0x0000312038527816ULL, 0x008fe400000000ffULL, 0x0000312039547816ULL, 0x000fe400000000ffULL,
0x00000052ff38723eULL, 0x000fe200020006ffULL, 0x0000003c1424723cULL, 0x000be20000001824ULL,
0x00000054ff39723eULL, 0x000fc400020006ffULL, 0x0000312012127816ULL, 0x000fe400000000ffULL,
0x0000312013137816ULL, 0x000fe400000000ffULL, 0x000000040d3d7824ULL, 0x020fe200078e0250ULL,
0x00000010ff10723eULL, 0x000fe200030006ffULL, 0x000000015a507824ULL, 0x000fe200078e0255ULL,
0x0000003fff11723eULL, 0x000fe200030006ffULL, 0x00000038141c723cULL, 0x000be2000000181cULL,
0x000000023d3d7810ULL, 0x000fe20007ffe03eULL, 0x000000083e3e7824ULL, 0x000fe200078e00ffULL,
0xfffffff851517812ULL, 0x000fc400078ee250ULL, 0x00000012ff3c723eULL, 0x000fe400030006ffULL,
0xfffffff83e3d7812ULL, 0x000fe200078ee23dULL, 0x00000010513e7824ULL, 0x000fe200078e024eULL,
0x00000052ff38723eULL, 0x020fe200030006ffULL, 0x000000101434723cULL, 0x000b620000001834ULL,
0x00000054ff39723eULL, 0x000fe200030006ffULL, 0x000000103d427824ULL, 0x000fe200078e0242ULL,
0x00000013ff3d723eULL, 0x000fe200030006ffULL, 0x0000000855547824ULL, 0x000fe200078e00ffULL,
0x000031203a3a7816ULL, 0x000fc400000000ffULL, 0x00000012ff10723eULL, 0x020fe200020006ffULL,
0x00000038142c723cULL, 0x040be2000000182cULL, 0x00000013ff11723eULL, 0x000fe400020006ffULL,
0x000031203b3b7816ULL, 0x000fe400000000ffULL, 0x000099104f527816ULL, 0x000fe400000000ffULL,
0x00000002504f7810ULL, 0x000fe20007ffe0ffULL, 0x0000003c1420723cULL, 0x000be40000001820ULL,
0x0000003aff38723eULL, 0x020fe200020006ffULL, 0x000000003e3c783bULL, 0x000e620000004200ULL,
0x0000003bff39723eULL, 0x000fc400020006ffULL, 0xfffffff8544f7812ULL, 0x000fe400078ee24fULL,
0x0000003aff54723eULL, 0x000fe200030006ffULL, 0x000000101430723cULL, 0x000b620000001830ULL,
0x0000003bff55723eULL, 0x000fe200030006ffULL, 0x009000004210783bULL, 0x020ea20000000200ULL,
0x000000ff5200720cULL, 0x000fca0003f05270ULL, 0x000000381428723cULL, 0x040b6e0000001828ULL,
0x000000104f387824ULL, 0x020fe200078e024eULL, 0x000000541418723cULL, 0x000b6a0000001818ULL,
0x000000003838783bULL, 0x000ee40000004200ULL, 0x000031203c147816ULL, 0x022fc400000000ffULL,
0x000031203d157816ULL, 0x000fe400000000ffULL, 0x00000014ff16723eULL, 0x080fe400020006ffULL,
0x00000015ff17723eULL, 0x080fe200020006ffULL, 0x0000000710108232ULL, 0x084fe20000000000ULL,
0x00000014ff14723eULL, 0x000fe200030006ffULL, 0x0000000712128232ULL, 0x000fe20000000000ULL,
0x00000015ff15723eULL, 0x000fe200030006ffULL, 0x0000000811118232ULL, 0x080fe20000000000ULL,
0x000031203e3e7816ULL, 0x000fe200000000ffULL, 0x0000000813138232ULL, 0x000fe20000000000ULL,
0x000031203f3f7816ULL, 0x000fcc00000000ffULL, 0x000000141034723cULL, 0x000b620000001834ULL,
0x0000312038387816ULL, 0x008fcc00000000ffULL, 0x0000003eff14723eULL, 0x0a0fe200020006ffULL,
0x000000161024723cULL, 0x040f620000001824ULL, 0x0000003fff15723eULL, 0x000fe400020006ffULL,
0x0000312039397816ULL, 0x000fe400000000ffULL, 0x000031203a3a7816ULL, 0x000fe400000000ffULL,
0x000031203b3b7816ULL, 0x000fe200000000ffULL, 0x000000141030723cULL, 0x000b620000001830ULL,
0x0000003eff3e723eULL, 0x000fc400030006ffULL, 0x0000003fff3f723eULL, 0x000fc800030006ffULL,
0x00000038ff14723eULL, 0x0a0fe400020006ffULL, 0x00000039ff15723eULL, 0x080fe200020006ffULL,
0x0000003e1020723cULL, 0x000f620000001820ULL, 0x00000038ff38723eULL, 0x000fe400030006ffULL,
0x00000039ff39723eULL, 0x000fca00030006ffULL, 0x00000014101c723cULL, 0x040b6e000000181cULL,
0x0000003aff14723eULL, 0x0a0fe200020006ffULL, 0x00000038102c723cULL, 0x000f62000000182cULL,
0x0000003bff15723eULL, 0x000fe400020006ffULL, 0x0000003aff3a723eULL, 0x000fc400030006ffULL,
0x0000003bff3b723eULL, 0x000fc600030006ffULL, 0x000000141028723cULL, 0x040b6e0000001828ULL,
0x000000080d147824ULL, 0x020fe200078e00ffULL, 0x0000003a1018723cULL, 0x000b620000001818ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x00f6c80014147f8cULL, 0x000e62000c80043fULL,
0xfffffff849497812ULL, 0x000fe200078ec0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000400b107811ULL, 0x020fe200078e40ffULL, 0x00f6880049ff7f8cULL, 0x0005e2000c80043fULL,
0x0000000156567810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff5c7224ULL, 0x000fe200078e0057ULL,
0x000000411000720cULL, 0x000fe20003f06070ULL, 0x000000ffff5d7224ULL, 0x000fc400078e0061ULL,
0x000000ffff127224ULL, 0x000fd400078e0048ULL, 0x00005ac000000947ULL, 0x000fea0003800000ULL,
0x0000000000107805ULL, 0x004fc40000015200ULL, 0x000004004d127984ULL, 0x000ea40000000800ULL,
0x8000000012ff7812ULL, 0x006fe40007804815ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff147224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x0000001210177210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e11ULL,
0x003d09001700780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401700780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff127819ULL, 0x000fc80000011413ULL, 0x0000001712127211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0613ULL, 0x0000000212127819ULL, 0x000fc80000001213ULL,
0x000000120000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000114147810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004004d127984ULL, 0x000e640000000800ULL, 0x8000000012ff7812ULL, 0x002fe40007804815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001040107824ULL, 0x000fe200078e00ffULL,
0x000000010b117810ULL, 0x000fe20007ffe0ffULL, 0x00005800025f7a24ULL, 0x010fc600078e02ffULL,
0x0000000e1100720cULL, 0x000fe20003f06070ULL, 0x000000805f5f7824ULL, 0x000fe200078e00ffULL,
0xffffffe010127812ULL, 0x000fca00078ec0ffULL, 0x000001000b127824ULL, 0x000fca00078e0212ULL,
0x0000008012127810ULL, 0x000fc80007ffe0ffULL, 0x0000006003147812ULL, 0x000fe200078ef812ULL,
0x000004b000008947ULL, 0x000fea0003800000ULL, 0x0000001010397812ULL, 0x000fe200078ec0ffULL,
0x0000001000387824ULL, 0x000fe200078e00ffULL, 0x00000003ff3d7819ULL, 0x000fe40000011600ULL,
0x0000001241107217ULL, 0x000fe40007800000ULL, 0x000000043d3a7810ULL, 0x040fe20007ffe0ffULL,
0x000000013d117824ULL, 0x140fe200078e0239ULL, 0x000000083d3e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000110107824ULL, 0x000fe200078e0a12ULL, 0x0000007038387812ULL, 0x000fe200078ec0ffULL,
0x0000000111137824ULL, 0x000fe200078e0200ULL, 0x0000000c3d4e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000811167824ULL, 0x000fe200078e00ffULL, 0x0000001039107217ULL, 0x000fe20007800000ULL,
0x000000013a3b7824ULL, 0x000fc400078e0239ULL, 0x0000000111127824ULL, 0x100fe200078e0214ULL,
0xfffffff8163f7812ULL, 0x000fe200078ee213ULL, 0x0000000110167824ULL, 0x100fe400078e0a39ULL,
0x000000013b107824ULL, 0x000fe200078e0214ULL, 0x000000125f127210ULL, 0x000fe20007f1e0ffULL,
0x000000013e557824ULL, 0x000fe200078e0239ULL, 0x000000163a00720cULL, 0x000fe20003fa6070ULL,
0x000000083b507824ULL, 0x000fe200078e00ffULL, 0x000000105f157210ULL, 0x000fe20007fde0ffULL,
0x000010000c107824ULL, 0x000fc400078e00ffULL, 0x000000ffff177224ULL, 0x000fe200000e06ffULL,
0x00005e0012137a11ULL, 0x040fe200078038ffULL, 0x000000ffff3a7224ULL, 0x000fe200030e06ffULL,
0x00005e0015117a11ULL, 0x000fe200078c38ffULL, 0x00000001553c7824ULL, 0x000fe200078e0214ULL,
0x00005f0012177a11ULL, 0x000fe400000f3c17ULL, 0x00005f0015157a11ULL, 0x000fe400030f3c3aULL,
0x00001000103a7812ULL, 0x000fe400078ec0ffULL, 0x0000003813127210ULL, 0x000fc40007f1e0ffULL,
0x0000003811107210ULL, 0x000fe20007fde0ffULL, 0x000020000d3a7824ULL, 0x000fe400078e023aULL,
0x000000ffff137224ULL, 0x000fe200000e0617ULL, 0x000000163d00720cULL, 0x000fe20003f06070ULL,
0x000000ffff117224ULL, 0x000fe200030e0615ULL, 0x0000003c5f3c7210ULL, 0x000fe20007fde0ffULL,
0x000000013b177824ULL, 0x000fe200078e0200ULL, 0x0000b0003a3a7810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff3b7224ULL, 0x000fe200030e06ffULL, 0xfffffff8503d7812ULL, 0x000fe200078ee217ULL,
0x000000103f177824ULL, 0x100fe200078e023aULL, 0x00005e003c157a11ULL, 0x000fe200078c38ffULL,
0x000000014e3f7824ULL, 0x000fe400078e0239ULL, 0x000000103d397824ULL, 0x000fe200078e023aULL,
0x00005f003c3b7a11ULL, 0x000fe200030f3c3bULL, 0x000000013f3c7824ULL, 0x000fe200078e0214ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012177faeULL, 0x0003e2000c101c46ULL,
0x0000003815147210ULL, 0x000fc60007f1e0ffULL, 0x0000003c5f3c7210ULL, 0x000fe20007fde0ffULL,
0x0000000010397faeULL, 0x0005e2000e901c46ULL, 0x000000ffff157224ULL, 0x000fe200000e063bULL,
0x000000163e00720cULL, 0x080fe40003fa6070ULL, 0x000000164e00720cULL, 0x000fe20003f06070ULL,
0x0000000155167824ULL, 0x140fe400078e0200ULL, 0x0000000855557824ULL, 0x000fe400078e00ffULL,
0x000000ffff3b7224ULL, 0x000fe200030e06ffULL, 0x00005e003c137a11ULL, 0x042fe200078c38ffULL,
0x000000013f127824ULL, 0x000fe200078e0200ULL, 0xfffffff855177812ULL, 0x000fe200078ee216ULL,
0x000000083f3f7824ULL, 0x000fe200078e00ffULL, 0x00005f003c117a11ULL, 0x004fc400030f3c3bULL,
0x0000003813107210ULL, 0x000fe20007fde0ffULL, 0x0000001017137824ULL, 0x000fe200078e023aULL,
0xfffffff83f397812ULL, 0x000fc600078ee212ULL, 0x000000ffff117224ULL, 0x000fe200030e0611ULL,
0x0000000014137faeULL, 0x0003e2000e901c46ULL, 0x0000001039177824ULL, 0x000fca00078e023aULL,
0x0000000010177faeULL, 0x0003e2000c101c46ULL, 0x000003e000007947ULL, 0x000fea0003800000ULL,
0x0000001010117812ULL, 0x000fe200078ec0ffULL, 0x0000001000387824ULL, 0x000fc600078e00ffULL,
0x0000001100117211ULL, 0x000fe400078fe8ffULL, 0x0000007038387812ULL, 0x000fe400078ec0ffULL,
0x0000000411137810ULL, 0x040fe20007ffe0ffULL, 0x0000000111107824ULL, 0x140fe200078e0200ULL,
0x0000000811157810ULL, 0x040fe20007ffe0ffULL, 0x0000000811397824ULL, 0x000fe400078e00ffULL,
0x0000000113127824ULL, 0x040fe400078e0200ULL, 0x00000008133f7824ULL, 0x000fe200078e00ffULL,
0xfffffff839397812ULL, 0x000fe200078ee210ULL, 0x0000000111107824ULL, 0x040fe200078e0214ULL,
0x0000000c11117810ULL, 0x000fe20007ffe0ffULL, 0x0000000115167824ULL, 0x000fe200078e0200ULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee212ULL, 0x0000000815557824ULL, 0x000fe200078e00ffULL,
0x000000105f3e7210ULL, 0x000fe20007f1e0ffULL, 0x0000000113107824ULL, 0x000fc400078e0214ULL,
0x0000000115127824ULL, 0x000fe200078e0214ULL, 0xfffffff855557812ULL, 0x000fe200078ee216ULL,
0x0000000111167824ULL, 0x000fe200078e0200ULL, 0x000000105f107210ULL, 0x000fe20007fbe0ffULL,
0x00000008115d7824ULL, 0x040fe400078e00ffULL, 0x000000ffff137224ULL, 0x000fe200000e06ffULL,
0x00005e003e3b7a11ULL, 0x000fe200078038ffULL, 0x0000000111147824ULL, 0x000fe200078e0214ULL,
0xfffffff85d5d7812ULL, 0x000fe200078ee216ULL, 0x000010000c157824ULL, 0x000fe200078e00ffULL,
0x00005f003e3e7a11ULL, 0x000fe200000f3c13ULL, 0x000000ffff117224ULL, 0x000fe200028e06ffULL,
0x00005e00103d7a11ULL, 0x000fc400078a38ffULL, 0x0000100015167812ULL, 0x000fe400078ec0ffULL,
0x000000125f127210ULL, 0x000fe40007f1e0ffULL, 0x00005f0010107a11ULL, 0x000fe200028f3c11ULL,
0x000020000d167824ULL, 0x000fe200078e0216ULL, 0x000000145f147210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff177224ULL, 0x000fe200000e06ffULL, 0x00005e0012157a11ULL, 0x000fe400078038ffULL,
0x0000b000164e7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff137224ULL, 0x000fe200028e06ffULL,
0x00005e0014117a11ULL, 0x000fc400078a38ffULL, 0x00005f00123c7a11ULL, 0x000fe200000f3c17ULL,
0x0000001039397824ULL, 0x100fe200078e024eULL, 0x000000383b167210ULL, 0x080fe20007f1e0ffULL,
0x000000103f3b7824ULL, 0x100fe200078e024eULL, 0x00005f00143a7a11ULL, 0x000fe200028f3c13ULL,
0x000000105d3f7824ULL, 0x000fe200078e024eULL, 0x000000383d147210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff177224ULL, 0x000fe200000e063eULL, 0x0000003815127210ULL, 0x080fe20007f1e0ffULL,
0x00000010553d7824ULL, 0x000fe400078e024eULL, 0x000000ffff157224ULL, 0x000fe200028e0610ULL,
0x0000003811107210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff137224ULL, 0x000fe200000e063cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016397faeULL, 0x0003e6000b901c46ULL,
0x000000ffff117224ULL, 0x000fe200028e063aULL, 0x00000000143b7faeULL, 0x0003e8000b901c46ULL,
0x00000000123d7faeULL, 0x0003e8000b901c46ULL, 0x00000000103f7faeULL, 0x0003e4000b901c46ULL,
0x0000000840117824ULL, 0x002fe200078e00ffULL, 0x0000010000007945ULL, 0x000fe20003800000ULL,
0x000000080c107824ULL, 0x000fe200078e00ffULL, 0x000000000000781cULL, 0x000fc40003f0f070ULL,
0xfffffff011117812ULL, 0x000fe400078ec0ffULL, 0x0000000810107812ULL, 0x000fca00078ec0ffULL,
0x0000000111587824ULL, 0x000fca00078e0210ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000f6a858557810ULL, 0x000fc80007ffe0ffULL, 0x00000000550403c2ULL, 0x000e640000040000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff00a9b0ULL, 0x002fe20008000a04ULL, 0x000000000000081cULL, 0x000fe2000170f070ULL,
0xffffff8000002947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a800585c7f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f628004c107f8cULL, 0x000664000c80043fULL, 0x0000000000127805ULL, 0x000fc40000015200ULL,
0x00f62c004c157984ULL, 0x000f240000000800ULL, 0x8000000015ff7812ULL, 0x012fe40007804811ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff167224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001412177210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e13ULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001714147211ULL, 0x000fca00078110ffULL, 0x000000ffff157224ULL, 0x000fca00000e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000116167810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f62c004c157984ULL, 0x000e640000000800ULL,
0x8000000015ff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000008038117810ULL, 0x000fca0007ffe04bULL, 0x000000014a117824ULL, 0x000fca00078e0211ULL,
0x00f0000011127984ULL, 0x000e680000000800ULL, 0x00f2000011137984ULL, 0x0006a20000000800ULL,
0x000000571200720bULL, 0x002fe20003f1d000ULL, 0x0000a1627f007947ULL, 0x000fd8000b800000ULL,
0x0000000000147806ULL, 0x008fc800000e0100ULL, 0x0000ffff14ff7812ULL, 0x000fe2000780c0ffULL,
0x000004b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff157424ULL, 0x000fe400078e00ffULL,
0x000000ffff5c7224ULL, 0x004fd200078e0057ULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x0000000140117811ULL, 0x000fe400078ff0ffULL, 0x000000571200720bULL, 0x000fe40003f14000ULL,
0x000000401100720cULL, 0x000fe20003fa5270ULL, 0x0000a1127f007947ULL, 0x000fd4000b800000ULL,
0x0000000000157806ULL, 0x000fc400000e0100ULL, 0x000000804011d824ULL, 0x000fe200078e0238ULL,
0x000000571210d209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe40003800000ULL,
0x000000014a17d824ULL, 0x000fe200078e0211ULL, 0x0000991015117816ULL, 0x000fc800000000ffULL,
0x00f400101700d388ULL, 0x0003e20000000800ULL, 0x000000ff1100720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000005712107209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff15ff7812ULL, 0x000fc6000780c0ffULL,
0x0000005710107221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL,
0x0000001000167308ULL, 0x000e640000000800ULL, 0x0000001605057220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff107819ULL, 0x000fe20000011600ULL,
0x0000a0327f007947ULL, 0x000fea000b800000ULL, 0x00001f1016107589ULL, 0x0002a400000e0000ULL,
0x0000001024247220ULL, 0x084fe20000410000ULL, 0x0000001025257220ULL, 0x080fe20000410000ULL,
0x0000001034347220ULL, 0x080fe20000410000ULL, 0x0000001035357220ULL, 0x080fe20000410000ULL,
0x0000001030307220ULL, 0x080fe20000410000ULL, 0x0000001031317220ULL, 0x080fe20000410000ULL,
0x0000001020207220ULL, 0x080fe20000410000ULL, 0x0000001021217220ULL, 0x080fe20000410000ULL,
0x000000101c1c7220ULL, 0x080fe20000410000ULL, 0x000000101d1d7220ULL, 0x080fe20000410000ULL,
0x000000102c2c7220ULL, 0x080fe20000410000ULL, 0x000000102d2d7220ULL, 0x080fe20000410000ULL,
0x0000001028287220ULL, 0x080fe20000410000ULL, 0x0000001029297220ULL, 0x080fe20000410000ULL,
0x0000001018187220ULL, 0x080fe20000410000ULL, 0x0000001019197220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0015ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000800107811ULL, 0x000fe200078ff0ffULL,
0x00009f227f007947ULL, 0x000fea000b800000ULL, 0x00001f1016107589ULL, 0x0004e400000e0000ULL,
0x0000001026267220ULL, 0x088fe20000410000ULL, 0x0000001027277220ULL, 0x080fe20000410000ULL,
0x0000001036367220ULL, 0x080fe20000410000ULL, 0x0000001037377220ULL, 0x080fe20000410000ULL,
0x0000001032327220ULL, 0x080fe20000410000ULL, 0x0000001033337220ULL, 0x080fe20000410000ULL,
0x0000001022227220ULL, 0x080fe20000410000ULL, 0x0000001023237220ULL, 0x080fe20000410000ULL,
0x000000101e1e7220ULL, 0x080fe20000410000ULL, 0x000000101f1f7220ULL, 0x080fe20000410000ULL,
0x000000102e2e7220ULL, 0x080fe20000410000ULL, 0x000000102f2f7220ULL, 0x080fe20000410000ULL,
0x000000102a2a7220ULL, 0x080fe20000410000ULL, 0x000000102b2b7220ULL, 0x080fe20000410000ULL,
0x000000101a1a7220ULL, 0x080fe20000410000ULL, 0x000000101b1b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff15ff7812ULL, 0x000fe20007800814ULL,
0x00000001ff157424ULL, 0x000fe200078e00ffULL, 0x00000057125c7209ULL, 0x000fd60007810000ULL,
0x8000005c12120221ULL, 0x000fe20000010000ULL, 0x00007610ff150816ULL, 0x000fc60000000015ULL,
0x3fb8aa3b12120820ULL, 0x000fc80000410000ULL, 0x0000001200060308ULL, 0x000e640000000800ULL,
0x0000000613130220ULL, 0x002fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000513057221ULL, 0x000fc20000010000ULL, 0x0000000000107805ULL, 0x000fcc0000015200ULL,
0x00f6ac0046137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe40007804861ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x0000001210177210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011413ULL,
0x0000001712127211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000212127819ULL, 0x000fc80000001213ULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000114147810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6ac0046137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe40007804861ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991015107816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff1000720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000006ff07723eULL, 0x000fe400000000ffULL, 0x00000002ff137819ULL, 0x000fe40000011600ULL,
0x0000541007127816ULL, 0x000fe20000000007ULL, 0x00009b027f007947ULL, 0x000fea000b800000ULL,
0x00001f1312077589ULL, 0x0002e400000e0000ULL, 0x0000000813107810ULL, 0x000fe20007ffe0ffULL,
0x00009b327f007947ULL, 0x000fea000b800000ULL, 0x00001f1012087589ULL, 0x0002a400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001013107810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff177224ULL, 0x000fe200078e0012ULL, 0x00004c5000387802ULL, 0x000fc40000000f00ULL,
0x0000a39000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001813107810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff177224ULL, 0x004fe200078e0012ULL,
0x00004ca000387802ULL, 0x000fc40000000f00ULL, 0x0000a34000007944ULL, 0x008fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000015b107824ULL, 0x042fe200078e025aULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000085b117824ULL, 0x000fe200078e00ffULL,
0x009800004314783bULL, 0x004e620000000200ULL, 0x000000020d5e7824ULL, 0x000fc600078e0248ULL,
0xfffffff811117812ULL, 0x000fe400078ee210ULL, 0x0000b0005e5e7811ULL, 0x000fca00078e60ffULL,
0x0000001011547824ULL, 0x100fe400078e025eULL, 0x0000001053527824ULL, 0x100fe400078e025eULL,
0x0000001051507824ULL, 0x000fe200078e025eULL, 0x000000005410783bULL, 0x000ea80000004200ULL,
0x00000000523c783bULL, 0x000f220000004200ULL, 0x0000000714148232ULL, 0x00afc40000000000ULL,
0x0000000716168232ULL, 0x000fe40000000000ULL, 0x0000000815158232ULL, 0x080fe40000000000ULL,
0x0000000817178232ULL, 0x000fe20000000000ULL, 0x0000312010107816ULL, 0x004fe400000000ffULL,
0x0000312011117816ULL, 0x000fe400000000ffULL, 0x00000010ff38723eULL, 0x000fe400020006ffULL,
0x00000011ff39723eULL, 0x000fc400020006ffULL, 0x00000010ff10723eULL, 0x000fe400030006ffULL,
0x00000011ff11723eULL, 0x000fe400030006ffULL, 0x0000312012127816ULL, 0x000fe200000000ffULL,
0x000000381424723cULL, 0x000b620000001824ULL, 0x0000312013137816ULL, 0x000fe200000000ffULL,
0x000000005038783bULL, 0x020e620000004200ULL, 0x00000012ff56723eULL, 0x000fe400030006ffULL,
0x00000013ff57723eULL, 0x000fc400030006ffULL, 0x000031203c4e7816ULL, 0x010fe200000000ffULL,
0x000000101434723cULL, 0x040b620000001834ULL, 0x000031203d607816ULL, 0x000fe400000000ffULL,
0x0000004eff3c723eULL, 0x000fe400020006ffULL, 0x00000060ff3d723eULL, 0x000fe400020006ffULL,
0x00000012ff10723eULL, 0x020fe200020006ffULL, 0x000000561420723cULL, 0x000be20000001820ULL,
0x00000013ff11723eULL, 0x000fc400020006ffULL, 0x000031203e3e7816ULL, 0x000fe400000000ffULL,
0x000031203f3f7816ULL, 0x000fe400000000ffULL, 0x0000003eff56723eULL, 0x020fe200030006ffULL,
0x000000101430723cULL, 0x040b620000001830ULL, 0x0000003fff57723eULL, 0x000fe200030006ffULL,
0x009800004210783bULL, 0x020eac0000000200ULL, 0x0000003c141c723cULL, 0x040b6e000000181cULL,
0x0000004eff3c723eULL, 0x020fe200030006ffULL, 0x000000104f4e7824ULL, 0x000fe200078e025eULL,
0x00000060ff3d723eULL, 0x000fe200030006ffULL, 0x000000561418723cULL, 0x000fe20000001818ULL,
0x0000312038387816ULL, 0x002fc400000000ffULL, 0x0000312039397816ULL, 0x000fe400000000ffULL,
0x000031203a3a7816ULL, 0x000fe400000000ffULL, 0x000031203b3b7816ULL, 0x000fe200000000ffULL,
0x0000003c142c723cULL, 0x000b6e000000182cULL, 0x0000003eff3c723eULL, 0x020fc400020006ffULL,
0x0000003fff3d723eULL, 0x000fce00020006ffULL, 0x0000003c1428723cULL, 0x000b620000001828ULL,
0x0000000710108232ULL, 0x084fe20000000000ULL, 0x000000004e3c783bULL, 0x020e620000004200ULL,
0x0000000712128232ULL, 0x000fe40000000000ULL, 0x0000000811118232ULL, 0x080fe40000000000ULL,
0x0000000813138232ULL, 0x000fe20000000000ULL, 0x00000038ff14723eULL, 0x000fe400020006ffULL,
0x00000039ff15723eULL, 0x000fce00020006ffULL, 0x000000141024723cULL, 0x000b6e0000001824ULL,
0x00000038ff14723eULL, 0x020fe400030006ffULL, 0x00000039ff15723eULL, 0x000fce00030006ffULL,
0x000000141034723cULL, 0x000b6e0000001834ULL, 0x0000003aff14723eULL, 0x020fe400020006ffULL,
0x0000003bff15723eULL, 0x000fe400020006ffULL, 0x000031203c3c7816ULL, 0x002fc400000000ffULL,
0x000031203d3d7816ULL, 0x000fe400000000ffULL, 0x000031203e3e7816ULL, 0x000fe200000000ffULL,
0x000000141030723cULL, 0x000b620000001830ULL, 0x000031203f3f7816ULL, 0x000fcc00000000ffULL,
0x0000003aff14723eULL, 0x020fe400030006ffULL, 0x0000003bff15723eULL, 0x000fce00030006ffULL,
0x000000141020723cULL, 0x000b6e0000001820ULL, 0x0000003cff14723eULL, 0x020fe400020006ffULL,
0x0000003dff15723eULL, 0x000fce00020006ffULL, 0x00000014101c723cULL, 0x000b6e000000181cULL,
0x0000003cff14723eULL, 0x020fe400030006ffULL, 0x0000003dff15723eULL, 0x000fce00030006ffULL,
0x00000014102c723cULL, 0x000b6e000000182cULL, 0x0000003eff14723eULL, 0x020fe400020006ffULL,
0x0000003fff15723eULL, 0x000fce00020006ffULL, 0x000000141028723cULL, 0x000b6e0000001828ULL,
0x0000003eff14723eULL, 0x020fe400030006ffULL, 0x0000003fff15723eULL, 0x000fce00030006ffULL,
0x000000141018723cULL, 0x000b6e0000001818ULL, 0x0000f6c80d107811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x0000000010107f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000800b107811ULL, 0x002fe200078e40ffULL,
0x00f6900049ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ffff157224ULL, 0x000fe200078e0011ULL,
0x000000010a567810ULL, 0x000fc40007ffe0ffULL, 0x000000411000720cULL, 0x000fe40003f06070ULL,
0x000000010c127812ULL, 0x000fd600078ec0ffULL, 0x00003be000000947ULL, 0x000fea0003800000ULL,
0x0000000000107805ULL, 0x002fc40000015200ULL, 0x000004004d027984ULL, 0x000e640000000800ULL,
0x8000000002ff7812ULL, 0x002fe40007804815ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff147224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x0000001210177210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e11ULL,
0x003d09001700780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401700780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff027819ULL, 0x000fc80000011413ULL, 0x0000001702027211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0613ULL, 0x0000000202027819ULL, 0x000fc80000001213ULL,
0x000000020000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000114147810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004004d027984ULL, 0x000e640000000800ULL, 0x8000000002ff7812ULL, 0x002fe40007804815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001040107824ULL, 0x000fe200078e00ffULL,
0x000000010b117810ULL, 0x000fc80007ffe0ffULL, 0x0000000e1100720cULL, 0x000fe40003f06070ULL,
0xffffffe010027812ULL, 0x000fca00078ec0ffULL, 0x000001000b027824ULL, 0x000fca00078e0202ULL,
0x000000c002147810ULL, 0x000fc80007ffe0ffULL, 0x0000006003027812ULL, 0x000fe200078ef814ULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x0000001010397812ULL, 0x000fe200078ec0ffULL,
0x0000001000387824ULL, 0x000fe200078e00ffULL, 0x00000003ff167819ULL, 0x000fe40000011600ULL,
0x0000001441107217ULL, 0x000fe40007800000ULL, 0x00000004163a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000116157824ULL, 0x100fe200078e0239ULL, 0x0000007038387812ULL, 0x000fe200078ec0ffULL,
0x0000000110107824ULL, 0x000fe200078e0a14ULL, 0x00000008163c7810ULL, 0x040fe20007ffe0ffULL,
0x0000000115127824ULL, 0x000fe200078e0202ULL, 0x0000000c163e7810ULL, 0x000fe20007ffe0ffULL,
0x000000013a3b7824ULL, 0x100fe200078e0239ULL, 0x0000001039107217ULL, 0x000fe20007800000ULL,
0x000000013c3d7824ULL, 0x000fe200078e0239ULL, 0x000000125f127210ULL, 0x000fc60007f1e0ffULL,
0x0000000110147824ULL, 0x100fe400078e0a39ULL, 0x000000ffff137224ULL, 0x000fe200000e06ffULL,
0x00005e0012117a11ULL, 0x000fe200078038ffULL, 0x000000013b107824ULL, 0x000fe400078e0202ULL,
0x000000013e397824ULL, 0x000fe200078e0239ULL, 0x00005f0012137a11ULL, 0x000fe200000f3c13ULL,
0x0000000115127824ULL, 0x040fe200078e0200ULL, 0x000000141600720cULL, 0x000fe20003f06070ULL,
0x0000000815157824ULL, 0x000fe200078e00ffULL, 0x000000105f177210ULL, 0x000fe20007fde0ffULL,
0x000000013d167824ULL, 0x100fe200078e0202ULL, 0x0000003811107210ULL, 0x000fe20007fbe0ffULL,
0x0000000139027824ULL, 0x000fe200078e0202ULL, 0xfffffff815157812ULL, 0x000fe200078ee212ULL,
0x000000ffff127224ULL, 0x000fc400030e06ffULL, 0x000000ffff117224ULL, 0x000fe200028e0613ULL,
0x000000143a00720cULL, 0x000fe20003fa6070ULL, 0x0000001015157824ULL, 0x000fe200078e025eULL,
0x00005e0017137a11ULL, 0x000fe200078c38ffULL, 0x000000013b3a7824ULL, 0x040fe400078e0200ULL,
0x000000083b3b7824ULL, 0x000fe200078e00ffULL, 0x00005f0017177a11ULL, 0x000fe200030f3c12ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010157faeULL, 0x0003e2000c101c46ULL,
0x0000003813127210ULL, 0x000fe40007f1e0ffULL, 0xfffffff83b3b7812ULL, 0x000fc400078ee23aULL,
0x000000165f167210ULL, 0x000fe20007fde0ffULL, 0x000000ffff137224ULL, 0x000fe200000e0617ULL,
0x000000143c00720cULL, 0x000fc60003f06070ULL, 0x000000ffff177224ULL, 0x000fe200030e06ffULL,
0x000000025f027210ULL, 0x000fe20007fde0ffULL, 0x000000103b157824ULL, 0x002fca00078e025eULL,
0x0000000012157faeULL, 0x0003e2000e901c46ULL, 0x00005e0016117a11ULL, 0x000fc800078a38ffULL,
0x00005f0016167a11ULL, 0x000fe200028f3c17ULL, 0x000000ffff177224ULL, 0x000fe200030e06ffULL,
0x0000003811107210ULL, 0x000fe40007fde0ffULL, 0x000000143e00720cULL, 0x000fe20003fa6070ULL,
0x000000013d147824ULL, 0x040fe400078e0200ULL, 0x000000ffff117224ULL, 0x000fe200030e0616ULL,
0x00005e0002137a11ULL, 0x042fe200078c38ffULL, 0x000000083d3d7824ULL, 0x000fe400078e00ffULL,
0x0000000139167824ULL, 0x040fe200078e0200ULL, 0x00005f0002027a11ULL, 0x000fe200030f3c17ULL,
0x0000000839397824ULL, 0x000fe200078e00ffULL, 0xfffffff83d157812ULL, 0x000fc400078ee214ULL,
0x0000003813127210ULL, 0x000fe40007fde0ffULL, 0xfffffff839177812ULL, 0x000fe200078ee216ULL,
0x0000001015157824ULL, 0x000fe400078e025eULL, 0x000000ffff137224ULL, 0x000fe400030e0602ULL,
0x0000001017177824ULL, 0x000fe200078e025eULL, 0x0000000010157faeULL, 0x0003e8000c101c46ULL,
0x0000000012177faeULL, 0x0003e2000e901c46ULL, 0x000003a000007947ULL, 0x000fea0003800000ULL,
0x0000001010117812ULL, 0x000fe200078ec0ffULL, 0x0000001000387824ULL, 0x000fc600078e00ffULL,
0x0000001100137211ULL, 0x000fe400078fe8ffULL, 0x0000007038387812ULL, 0x000fe400078ec0ffULL,
0x0000000413157810ULL, 0x040fe20007ffe0ffULL, 0x0000000113107824ULL, 0x040fe200078e0202ULL,
0x0000000813177810ULL, 0x040fe20007ffe0ffULL, 0x0000000113117824ULL, 0x140fe400078e0200ULL,
0x0000000813147824ULL, 0x000fe200078e00ffULL, 0x000000105f3c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000115127824ULL, 0x000fc400078e0200ULL, 0x00000008153f7824ULL, 0x040fe200078e00ffULL,
0xfffffff814397812ULL, 0x000fe200078ee211ULL, 0x000000ffff117224ULL, 0x000fe200000e06ffULL,
0x00005e003c3b7a11ULL, 0x040fe200078038ffULL, 0x0000000115107824ULL, 0x000fe200078e0202ULL,
0x0000000c13157810ULL, 0x000fe20007ffe0ffULL, 0x0000000117137824ULL, 0x000fe200078e0200ULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee212ULL, 0x0000000117127824ULL, 0x100fe200078e0202ULL,
0x00005f003c3c7a11ULL, 0x000fe200000f3c11ULL, 0x0000000115027824ULL, 0x000fe200078e0202ULL,
0x000000105f107210ULL, 0x000fe20007f1e0ffULL, 0x0000000817147824ULL, 0x000fe200078e00ffULL,
0x000000125f127210ULL, 0x000fe20007fbe0ffULL, 0x0000001039397824ULL, 0x000fe200078e025eULL,
0x000000025f027210ULL, 0x000fe20007fde0ffULL, 0x000000ffff117224ULL, 0x000fe200000e06ffULL,
0x00005e00103d7a11ULL, 0x000fe200078038ffULL, 0x000000ffff177224ULL, 0x000fe200028e06ffULL,
0xfffffff814577812ULL, 0x000fe200078ee213ULL, 0x00000008155f7824ULL, 0x040fe200078e00ffULL,
0x00005f0010147a11ULL, 0x000fe200000f3c11ULL, 0x0000000115107824ULL, 0x000fe200078e0200ULL,
0x00005e0012137a11ULL, 0x000fe200078038ffULL, 0x000000ffff117224ULL, 0x000fe200030e06ffULL,
0x00005e0002157a11ULL, 0x000fc400078a38ffULL, 0x00005f00123a7a11ULL, 0x000fe400000f3c17ULL,
0xfffffff85f5f7812ULL, 0x000fe400078ee210ULL, 0x00005f0002027a11ULL, 0x000fe400028f3c11ULL,
0x000000383b167210ULL, 0x080fe20007f1e0ffULL, 0x000000103f3b7824ULL, 0x100fe200078e025eULL,
0x000000383d107210ULL, 0x080fe20007fbe0ffULL, 0x00000010573d7824ULL, 0x000fe400078e025eULL,
0x000000ffff177224ULL, 0x000fe200000e063cULL, 0x0000003813127210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff117224ULL, 0x000fe200028e0614ULL, 0x0000003815147210ULL, 0x000fe20007fbe0ffULL,
0x000000105f3f7824ULL, 0x000fe200078e025eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016397faeULL, 0x0003e2000b901c46ULL, 0x000000ffff137224ULL, 0x000fc400000e063aULL,
0x000000ffff157224ULL, 0x000fe200028e0602ULL, 0x00000000103b7faeULL, 0x0003e8000b901c46ULL,
0x00000000123d7faeULL, 0x0003e8000b901c46ULL, 0x00000000143f7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x000000020a027810ULL, 0x000fc40007ffe0ffULL,
0x000000000000781cULL, 0x000fe40003f0f070ULL, 0x0000000f0200720cULL, 0x000fe20003fa6070ULL,
0xffffffffff027424ULL, 0x000fd800078e00ffULL, 0x0000004000005947ULL, 0x000fea0003800000ULL,
0x0000000209107810ULL, 0x000fe20007ffe00aULL, 0x00000004ff117424ULL, 0x000fc800078e00ffULL,
0x0000600010107625ULL, 0x000fca00078e0011ULL, 0x0000000610027981ULL, 0x000324000c1e1900ULL,
0x0000009000007945ULL, 0x000fe40003800000ULL, 0x00000000590403c2ULL, 0x000ea40000020000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0099b0ULL, 0x004fe20008000a04ULL, 0x000000000000081cULL, 0x000fe20000f0f070ULL,
0xffffff8000001947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a80046607f8cULL, 0x0004e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f648004c107f8cULL, 0x0022a4000c80043fULL, 0x0000000000127805ULL, 0x000fc40000015200ULL,
0x00f64c004c157984ULL, 0x000e640000000800ULL, 0x8000000015ff7812ULL, 0x006fe40007804811ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff167224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001412177210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e13ULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001714147211ULL, 0x000fca00078110ffULL, 0x000000ffff157224ULL, 0x000fca00000e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000116167810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f64c004c157984ULL, 0x000e640000000800ULL,
0x8000000015ff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010038117810ULL, 0x000fca0007ffe04bULL, 0x000000014a117824ULL, 0x000fca00078e0211ULL,
0x00f0000011137984ULL, 0x000e680000000800ULL, 0x00f2000011127984ULL, 0x0004e20000000800ULL,
0x0000005c1300720bULL, 0x002fe20003f1d000ULL, 0x000084f27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000147806ULL, 0x004fc800000e0100ULL, 0x0000ffff14ff7812ULL, 0x000fe2000780c0ffULL,
0x000004b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff567424ULL, 0x000fe400078e00ffULL,
0x000000ffff577224ULL, 0x000fd200078e005cULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x0000000240117811ULL, 0x000fe400078ff0ffULL, 0x0000005c1300720bULL, 0x000fe40003f14000ULL,
0x000000401100720cULL, 0x000fe20003fa5270ULL, 0x000084a27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000157806ULL, 0x000fc400000e0100ULL, 0x000000804011d824ULL, 0x000fe200078e0238ULL,
0x000000135c10d209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe40003800000ULL,
0x000000014a17d824ULL, 0x000fe200078e0211ULL, 0x0000991015117816ULL, 0x000fc800000000ffULL,
0x00f400101700d388ULL, 0x0003e20000000800ULL, 0x000000ff1100720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x000000135c117209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff15ff7812ULL, 0x000fc6000780c0ffULL,
0x800000115c107221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL,
0x0000001000167308ULL, 0x000e640000000800ULL, 0x0000001605057220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff107819ULL, 0x000fe20000011600ULL,
0x000083c27f007947ULL, 0x000fea000b800000ULL, 0x00001f1016107589ULL, 0x0002a400000e0000ULL,
0x0000001024247220ULL, 0x084fe20000410000ULL, 0x0000001025257220ULL, 0x080fe20000410000ULL,
0x0000001034347220ULL, 0x080fe20000410000ULL, 0x0000001035357220ULL, 0x080fe20000410000ULL,
0x0000001030307220ULL, 0x080fe20000410000ULL, 0x0000001031317220ULL, 0x080fe20000410000ULL,
0x0000001020207220ULL, 0x080fe20000410000ULL, 0x0000001021217220ULL, 0x080fe20000410000ULL,
0x000000101c1c7220ULL, 0x080fe20000410000ULL, 0x000000101d1d7220ULL, 0x080fe20000410000ULL,
0x000000102c2c7220ULL, 0x080fe20000410000ULL, 0x000000102d2d7220ULL, 0x080fe20000410000ULL,
0x0000001028287220ULL, 0x080fe20000410000ULL, 0x0000001029297220ULL, 0x080fe20000410000ULL,
0x0000001018187220ULL, 0x080fe20000410000ULL, 0x0000001019197220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0015ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000800107811ULL, 0x000fe200078ff0ffULL,
0x000082b27f007947ULL, 0x000fea000b800000ULL, 0x00001f1016107589ULL, 0x00046400000e0000ULL,
0x0000001026267220ULL, 0x082fe20000410000ULL, 0x0000001027277220ULL, 0x080fe20000410000ULL,
0x0000001036367220ULL, 0x080fe20000410000ULL, 0x0000001037377220ULL, 0x080fe20000410000ULL,
0x0000001032327220ULL, 0x080fe20000410000ULL, 0x0000001033337220ULL, 0x080fe20000410000ULL,
0x0000001022227220ULL, 0x080fe20000410000ULL, 0x0000001023237220ULL, 0x080fe20000410000ULL,
0x000000101e1e7220ULL, 0x080fe20000410000ULL, 0x000000101f1f7220ULL, 0x080fe20000410000ULL,
0x000000102e2e7220ULL, 0x080fe20000410000ULL, 0x000000102f2f7220ULL, 0x080fe20000410000ULL,
0x000000102a2a7220ULL, 0x080fe20000410000ULL, 0x000000102b2b7220ULL, 0x080fe20000410000ULL,
0x000000101a1a7220ULL, 0x080fe20000410000ULL, 0x000000101b1b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff15ff7812ULL, 0x000fe20007800814ULL,
0x00000001ff567424ULL, 0x000fe200078e00ffULL, 0x000000135c577209ULL, 0x000fd60007810000ULL,
0x8000005713130221ULL, 0x000fe20000010000ULL, 0x00007610ff560816ULL, 0x000fc60000000056ULL,
0x3fb8aa3b13130820ULL, 0x000fc80000410000ULL, 0x0000001300060308ULL, 0x000e640000000800ULL,
0x0000000612120220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000512057221ULL, 0x008fc20000010000ULL, 0x0000000000107805ULL, 0x000fcc0000015200ULL,
0x00f6ac0058127984ULL, 0x000e640000000800ULL, 0x8000000012ff7812ULL, 0x002fe4000780485dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x0000001210157210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09001500780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401500780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011413ULL,
0x0000001512127211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000212127819ULL, 0x000fc80000001213ULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000114147810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6ac0058127984ULL, 0x000e640000000800ULL,
0x8000000012ff7812ULL, 0x002fe4000780485dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991056107816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff1000720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000006ff07723eULL, 0x000fe400000000ffULL, 0x00000002ff137819ULL, 0x000fe40000011600ULL,
0x0000541007127816ULL, 0x000fe20000000007ULL, 0x00007e927f007947ULL, 0x000fea000b800000ULL,
0x00001f1312077589ULL, 0x0002e400000e0000ULL, 0x0000000813107810ULL, 0x000fe20007ffe0ffULL,
0x00007ec27f007947ULL, 0x000fea000b800000ULL, 0x00001f1012087589ULL, 0x0002a400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001013107810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff177224ULL, 0x000fe200078e0012ULL, 0x00006ab000387802ULL, 0x000fc40000000f00ULL,
0x0000853000007944ULL, 0x01cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001813107810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff177224ULL, 0x004fe200078e0012ULL,
0x00006b0000387802ULL, 0x000fc40000000f00ULL, 0x000084e000007944ULL, 0x018fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000010000c107824ULL, 0x002fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000015b5a7824ULL, 0x040fe200078e025aULL,
0x00a000004314783bULL, 0x004e620000000200ULL, 0x000000085b117824ULL, 0x000fe200078e00ffULL,
0x0000100010107812ULL, 0x000fc800078ec0ffULL, 0xfffffff811117812ULL, 0x000fe200078ee25aULL,
0x000020000d107824ULL, 0x000fca00078e0210ULL, 0x0000b000105e7810ULL, 0x000fca0007ffe0ffULL,
0x0000001011107824ULL, 0x100fe400078e025eULL, 0x0000001053387824ULL, 0x000fc800078e025eULL,
0x000000001010783bULL, 0x000ea80000004200ULL, 0x000000003838783bULL, 0x000ee40000004200ULL,
0x0000000714148232ULL, 0x08afe40000000000ULL, 0x0000000716168232ULL, 0x000fe40000000000ULL,
0x0000000815158232ULL, 0x000fc40000000000ULL, 0x0000000817178232ULL, 0x000fe20000000000ULL,
0x00003120103e7816ULL, 0x004fe400000000ffULL, 0x0000312011117816ULL, 0x000fe400000000ffULL,
0x0000003eff3c723eULL, 0x080fe400020006ffULL, 0x0000003eff10723eULL, 0x000fe200030006ffULL,
0x00000010513e7824ULL, 0x000fe200078e025eULL, 0x0000312038517816ULL, 0x000fe400000000ffULL,
0x0000312039537816ULL, 0x000fc400000000ffULL, 0x00000011ff3d723eULL, 0x000fe400020006ffULL,
0x00000051ff38723eULL, 0x000fe400020006ffULL, 0x00000053ff39723eULL, 0x000fe400020006ffULL,
0x0000312012127816ULL, 0x000fe200000000ffULL, 0x0000003c1424723cULL, 0x000be20000001824ULL,
0x0000312013137816ULL, 0x000fe400000000ffULL, 0x00000011ff11723eULL, 0x000fc400030006ffULL,
0x000031203a3a7816ULL, 0x000fe400000000ffULL, 0x00000012ff3c723eULL, 0x020fe200030006ffULL,
0x00000038141c723cULL, 0x040be2000000181cULL, 0x00000013ff3d723eULL, 0x000fe400030006ffULL,
0x000031203b3b7816ULL, 0x000fe400000000ffULL, 0x0000003aff5a723eULL, 0x000fe400030006ffULL,
0x00000051ff38723eULL, 0x020fe200030006ffULL, 0x000000101434723cULL, 0x000b620000001834ULL,
0x00000053ff39723eULL, 0x000fc400030006ffULL, 0x0000003bff5b723eULL, 0x000fe400030006ffULL,
0x0000991056517816ULL, 0x000fe400000000ffULL, 0x00000012ff10723eULL, 0x020fe200020006ffULL,
0x0000003c1420723cULL, 0x000be20000001820ULL, 0x00000013ff11723eULL, 0x000fe200020006ffULL,
0x000000003e3c783bULL, 0x020e620000004200ULL, 0x000000ff5100720cULL, 0x000fca0003f05270ULL,
0x00000038142c723cULL, 0x040bee000000182cULL, 0x0000003aff38723eULL, 0x020fe200020006ffULL,
0x000000101430723cULL, 0x040b620000001830ULL, 0x0000003bff39723eULL, 0x000fe200020006ffULL,
0x00a000004210783bULL, 0x020eac0000000200ULL, 0x000000381428723cULL, 0x040b6e0000001828ULL,
0x000000104f387824ULL, 0x020fe200078e025eULL, 0x0000005a1418723cULL, 0x000b6a0000001818ULL,
0x000000003838783bULL, 0x000ee40000004200ULL, 0x000031203c147816ULL, 0x022fc400000000ffULL,
0x000031203d157816ULL, 0x000fe400000000ffULL, 0x00000014ff16723eULL, 0x080fe400020006ffULL,
0x00000015ff17723eULL, 0x080fe400020006ffULL, 0x00000014ff14723eULL, 0x000fe400030006ffULL,
0x00000015ff15723eULL, 0x000fe400030006ffULL, 0x000031203e3e7816ULL, 0x000fc400000000ffULL,
0x000031203f3f7816ULL, 0x000fe200000000ffULL, 0x0000000710108232ULL, 0x084fe40000000000ULL,
0x0000000712128232ULL, 0x000fe40000000000ULL, 0x0000000811118232ULL, 0x080fe40000000000ULL,
0x0000000813138232ULL, 0x000fce0000000000ULL, 0x000000141034723cULL, 0x000b620000001834ULL,
0x0000312038387816ULL, 0x008fcc00000000ffULL, 0x0000003eff14723eULL, 0x0a0fe200020006ffULL,
0x000000161024723cULL, 0x040f620000001824ULL, 0x0000003fff15723eULL, 0x000fe400020006ffULL,
0x0000312039397816ULL, 0x000fe400000000ffULL, 0x000031203a3a7816ULL, 0x000fe400000000ffULL,
0x000031203b3b7816ULL, 0x000fe200000000ffULL, 0x000000141030723cULL, 0x000b620000001830ULL,
0x0000003eff3e723eULL, 0x000fc400030006ffULL, 0x0000003fff3f723eULL, 0x000fc800030006ffULL,
0x00000038ff14723eULL, 0x0a0fe400020006ffULL, 0x00000039ff15723eULL, 0x080fe200020006ffULL,
0x0000003e1020723cULL, 0x000f620000001820ULL, 0x00000038ff38723eULL, 0x000fe400030006ffULL,
0x00000039ff39723eULL, 0x000fca00030006ffULL, 0x00000014101c723cULL, 0x040b6e000000181cULL,
0x0000003aff14723eULL, 0x0a0fe200020006ffULL, 0x00000038102c723cULL, 0x000f62000000182cULL,
0x0000003bff15723eULL, 0x000fe400020006ffULL, 0x0000003aff3a723eULL, 0x000fc400030006ffULL,
0x0000003bff3b723eULL, 0x000fc600030006ffULL, 0x000000141028723cULL, 0x040b6e0000001828ULL,
0x0000f6c80d147811ULL, 0x020fe200078e18ffULL, 0x0000003a1018723cULL, 0x000b620000001818ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000000014147f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000c00b107811ULL, 0x020fe200078e40ffULL, 0x00f6980049ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff127224ULL, 0x000fe200078e0048ULL, 0x000000020a567810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff5c7224ULL, 0x000fe200078e0057ULL, 0x000000411000720cULL, 0x000fe20003f06070ULL,
0x000000ffff5d7224ULL, 0x000fd800078e0061ULL, 0x00001d2000000947ULL, 0x000fea0003800000ULL,
0x0000000000107805ULL, 0x004fc40000015200ULL, 0x000004004d127984ULL, 0x000ea40000000800ULL,
0x8000000012ff7812ULL, 0x006fe40007804815ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff147224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x0000001210177210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e11ULL,
0x003d09001700780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401700780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff127819ULL, 0x000fc80000011413ULL, 0x0000001712127211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0613ULL, 0x0000000212127819ULL, 0x000fc80000001213ULL,
0x000000120000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000114147810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004004d127984ULL, 0x000e640000000800ULL, 0x8000000012ff7812ULL, 0x002fe40007804815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000020b117810ULL, 0x040fe20007ffe0ffULL,
0x000001000b107824ULL, 0x000fe400078e0204ULL, 0x0000580002137a24ULL, 0x010fe200078e02ffULL,
0x0000000e1100720cULL, 0x000fe40003f06070ULL, 0x0000010010147810ULL, 0x000fe20007ffe0ffULL,
0x0000008013137824ULL, 0x000fc600078e00ffULL, 0x0000006003167812ULL, 0x000fce00078ef814ULL,
0x0000048000008947ULL, 0x000fea0003800000ULL, 0x0000001040107824ULL, 0x000fe200078e00ffULL,
0x00000003ff387819ULL, 0x000fe20000011600ULL, 0x0000001000177824ULL, 0x000fc600078e00ffULL,
0x00000010103d7812ULL, 0x000fe400078ec0ffULL, 0x0000001441107217ULL, 0x000fe40007800000ULL,
0x00000004383c7810ULL, 0x040fe20007ffe0ffULL, 0x0000000138397824ULL, 0x100fe400078e023dULL,
0x0000000110107824ULL, 0x000fe400078e0a14ULL, 0x0000000139127824ULL, 0x000fe400078e0216ULL,
0x000000013c3f7824ULL, 0x000fe200078e023dULL, 0x000000103d107217ULL, 0x000fe20007800000ULL,
0x00000008393e7824ULL, 0x000fe200078e00ffULL, 0x0000001213127210ULL, 0x000fe20007f1e0ffULL,
0x000000083f487824ULL, 0x000fc800078e00ffULL, 0x000000ffff157224ULL, 0x000fe200000e06ffULL,
0x00005e0012117a11ULL, 0x000fc800078038ffULL, 0x00005f0012147a11ULL, 0x000fe200000f3c15ULL,
0x0000000139157824ULL, 0x000fe200078e0200ULL, 0x0000007017127812ULL, 0x000fe200078ec0ffULL,
0x0000000110177824ULL, 0x000fe400078e0a3dULL, 0x000000013f107824ULL, 0x000fe200078e0216ULL,
0xfffffff83e397812ULL, 0x000fe400078ee215ULL, 0x000000173800720cULL, 0x000fe40003f06070ULL,
0x00000010133a7210ULL, 0x000fe20007fde0ffULL, 0x0000001039397824ULL, 0x000fe200078e025eULL,
0x0000001211107210ULL, 0x000fc40007fbe0ffULL, 0x0000000c383e7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff3b7224ULL, 0x000fe200030e06ffULL, 0x00005e003a157a11ULL, 0x000fe200078c38ffULL,
0x000000ffff117224ULL, 0x000fe200028e0614ULL, 0x000000173c00720cULL, 0x000fe40003fa6070ULL,
0x00000008383c7810ULL, 0x000fe40007ffe0ffULL, 0x00005f003a3a7a11ULL, 0x000fe200030f3c3bULL,
0x000000013f3b7824ULL, 0x000fe200078e0200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010397faeULL, 0x0003e2000c101c46ULL, 0x000000013c4d7824ULL, 0x100fe200078e023dULL,
0x0000001215147210ULL, 0x000fe20007f1e0ffULL, 0x000000013e3d7824ULL, 0x000fe200078e023dULL,
0xfffffff8483b7812ULL, 0x000fe200078ee23bULL, 0x000000014d387824ULL, 0x000fc400078e0216ULL,
0x000000013d167824ULL, 0x000fe400078e0216ULL, 0x000000ffff157224ULL, 0x000fe200000e063aULL,
0x0000003813387210ULL, 0x000fe20007fde0ffULL, 0x000000084d3a7824ULL, 0x000fe200078e00ffULL,
0x000000173c00720cULL, 0x000fe20003f06070ULL, 0x000000103b397824ULL, 0x002fe400078e025eULL,
0x000000ffff3b7224ULL, 0x000fe200030e06ffULL, 0x0000001613167210ULL, 0x000fe40007fde0ffULL,
0x0000000014397faeULL, 0x0003e2000e901c46ULL, 0x00005e0038117a11ULL, 0x000fc400078a38ffULL,
0x000000ffff137224ULL, 0x000fe400030e06ffULL, 0x00005f0038387a11ULL, 0x000fe400028f3c3bULL,
0x0000001211107210ULL, 0x000fe40007fde0ffULL, 0x000000173e00720cULL, 0x000fe20003fa6070ULL,
0x000000014d177824ULL, 0x000fe400078e0200ULL, 0x000000ffff117224ULL, 0x000fe200030e0638ULL,
0x00005e0016157a11ULL, 0x002fe200078c38ffULL, 0x000000013d387824ULL, 0x040fe200078e0200ULL,
0xfffffff83a177812ULL, 0x000fe200078ee217ULL, 0x000000083d397824ULL, 0x000fe200078e00ffULL,
0x00005f0016167a11ULL, 0x000fc400030f3c13ULL, 0x0000001215147210ULL, 0x000fe20007fde0ffULL,
0x0000001017137824ULL, 0x000fe200078e025eULL, 0xfffffff839397812ULL, 0x000fc600078ee238ULL,
0x000000ffff157224ULL, 0x000fe200030e0616ULL, 0x0000000010137faeULL, 0x0003e2000c101c46ULL,
0x0000001039177824ULL, 0x000fca00078e025eULL, 0x0000000014177faeULL, 0x0003e2000e901c46ULL,
0x000003b000007947ULL, 0x000fea0003800000ULL, 0x0000001040107824ULL, 0x000fca00078e00ffULL,
0x0000001010117812ULL, 0x000fc800078ec0ffULL, 0x0000001100157211ULL, 0x000fc800078fe8ffULL,
0x0000000415177810ULL, 0x040fe20007ffe0ffULL, 0x0000000115107824ULL, 0x040fe200078e0216ULL,
0x0000000815397810ULL, 0x040fe20007ffe0ffULL, 0x0000000115117824ULL, 0x140fe400078e0200ULL,
0x0000000815147824ULL, 0x000fe200078e00ffULL, 0x00000010133e7210ULL, 0x000fe20007f1e0ffULL,
0x0000000117127824ULL, 0x040fe400078e0200ULL, 0x00000008173f7824ULL, 0x040fe200078e00ffULL,
0xfffffff8143d7812ULL, 0x000fe200078ee211ULL, 0x000000ffff117224ULL, 0x000fe200000e06ffULL,
0x00005e003e3b7a11ULL, 0x040fe200078038ffULL, 0x0000000117107824ULL, 0x000fe200078e0216ULL,
0x0000000c15177810ULL, 0x000fe20007ffe0ffULL, 0x0000000139147824ULL, 0x040fe200078e0200ULL,
0x00005f003e3e7a11ULL, 0x000fe200000f3c11ULL, 0x00000008394d7824ULL, 0x000fe200078e00ffULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee212ULL, 0x0000000139127824ULL, 0x100fe200078e0216ULL,
0x0000001013107210ULL, 0x000fe20007f1e0ffULL, 0x0000000117167824ULL, 0x000fe200078e0216ULL,
0xfffffff84d4d7812ULL, 0x000fe200078ee214ULL, 0x00000008174f7824ULL, 0x000fe200078e00ffULL,
0x00000012133c7210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff117224ULL, 0x000fe200000e06ffULL,
0x00005e0010157a11ULL, 0x000fe200078038ffULL, 0x0000001000127824ULL, 0x000fe200078e00ffULL,
0x0000001613167210ULL, 0x000fe20007fde0ffULL, 0x000000ffff137224ULL, 0x000fe200028e06ffULL,
0x00005f0010387a11ULL, 0x000fe200000f3c11ULL, 0x0000000117107824ULL, 0x000fe200078e0200ULL,
0x00005e003c177a11ULL, 0x000fe200078038ffULL, 0x000000ffff117224ULL, 0x000fe200030e06ffULL,
0x00005e0016397a11ULL, 0x000fc400078a38ffULL, 0x0000007012127812ULL, 0x000fe400078ec0ffULL,
0xfffffff84f4f7812ULL, 0x000fe400078ee210ULL, 0x00005f003c3c7a11ULL, 0x000fe200000f3c13ULL,
0x000000103d137824ULL, 0x100fe200078e025eULL, 0x00005f00163a7a11ULL, 0x000fe200028f3c11ULL,
0x000000104d3d7824ULL, 0x100fe200078e025eULL, 0x000000123b107210ULL, 0x080fe20007f1e0ffULL,
0x000000103f3b7824ULL, 0x100fe200078e025eULL, 0x0000001215147210ULL, 0x000fe20007fbe0ffULL,
0x000000104f3f7824ULL, 0x000fc400078e025eULL, 0x000000ffff117224ULL, 0x000fe200000e063eULL,
0x0000001217167210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff157224ULL, 0x000fe200028e0638ULL,
0x0000001239387210ULL, 0x000fe40007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010137faeULL, 0x0003e2000b901c46ULL, 0x000000ffff177224ULL, 0x000fe400000e063cULL,
0x000000ffff397224ULL, 0x000fe200028e063aULL, 0x00000000143b7faeULL, 0x0003e8000b901c46ULL,
0x00000000163d7faeULL, 0x0003e8000b901c46ULL, 0x00000000383f7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fda0003f0f070ULL, 0x00000000550403c2ULL, 0x000e640000080000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff00c9b0ULL, 0x002fe20008000a04ULL, 0x000000000000081cULL, 0x000fe2000270f070ULL,
0xffffff8000004947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a800585c7f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f668004c107f8cULL, 0x000664000c80043fULL, 0x0000000000147805ULL, 0x000fc40000015200ULL,
0x00f66c004c137984ULL, 0x000f240000000800ULL, 0x8000000013ff7812ULL, 0x012fc40007804811ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff387224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614167210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09001600780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401600780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff137819ULL, 0x000fc80000011417ULL,
0x0000001613137211ULL, 0x000fca00078110ffULL, 0x000000ffff167224ULL, 0x000fca00000e0617ULL,
0x0000000213137819ULL, 0x000fc80000001216ULL, 0x000000130000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000138387810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f66c004c137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000180124b7810ULL, 0x000fca0007ffe04bULL, 0x000000014a4b7824ULL, 0x000fca00078e024bULL,
0x00f000004b147984ULL, 0x000e680000000800ULL, 0x00f200004b137984ULL, 0x0006a20000000800ULL,
0x000000571400720bULL, 0x002fe20003f1d000ULL, 0x000068827f007947ULL, 0x000fd8000b800000ULL,
0x0000000000157806ULL, 0x008fc800000e0100ULL, 0x0000ffff15ff7812ULL, 0x000fe2000780c0ffULL,
0x0000049000007945ULL, 0x000fe20003800000ULL, 0x00000001ff167424ULL, 0x000fe400078e00ffULL,
0x000000ffff5c7224ULL, 0x004fd200078e0057ULL, 0x0000045000008947ULL, 0x000fea0003800000ULL,
0x0000000340117811ULL, 0x000fe400078ff0ffULL, 0x000000571400720bULL, 0x000fe40003f14000ULL,
0x000000401100720cULL, 0x000fe20003fa5270ULL, 0x000068327f007947ULL, 0x000fd4000b800000ULL,
0x0000000000167806ULL, 0x000fc400000e0100ULL, 0x000000804011d824ULL, 0x000fe200078e0212ULL,
0x00000057145c7209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x0000991016107816ULL, 0x000fe200000000ffULL, 0x000000014a11d824ULL, 0x000fc600078e0211ULL,
0x000000ff1000720cULL, 0x000fe40003f05270ULL, 0x00f4005c1100d388ULL, 0x0003f60000000800ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x000000575c107221ULL, 0x002fe20000010100ULL,
0x000000ff16ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL, 0x0000001000127308ULL, 0x000e640000000800ULL,
0x0000001205057220ULL, 0x002fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff107819ULL, 0x000fe20000011600ULL, 0x000067527f007947ULL, 0x000fea000b800000ULL,
0x00001f1012107589ULL, 0x0002a400000e0000ULL, 0x0000001024247220ULL, 0x084fe20000410000ULL,
0x0000001025257220ULL, 0x080fe20000410000ULL, 0x0000001034347220ULL, 0x080fe20000410000ULL,
0x0000001035357220ULL, 0x080fe20000410000ULL, 0x0000001030307220ULL, 0x080fe20000410000ULL,
0x0000001031317220ULL, 0x080fe20000410000ULL, 0x0000001020207220ULL, 0x080fe20000410000ULL,
0x0000001021217220ULL, 0x080fe20000410000ULL, 0x000000101c1c7220ULL, 0x080fe20000410000ULL,
0x000000101d1d7220ULL, 0x080fe20000410000ULL, 0x000000102c2c7220ULL, 0x080fe20000410000ULL,
0x000000102d2d7220ULL, 0x080fe20000410000ULL, 0x0000001028287220ULL, 0x080fe20000410000ULL,
0x0000001029297220ULL, 0x080fe20000410000ULL, 0x0000001018187220ULL, 0x080fe20000410000ULL,
0x0000001019197220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0016ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000800107811ULL, 0x000fe200078ff0ffULL, 0x000066427f007947ULL, 0x000fea000b800000ULL,
0x00001f1012107589ULL, 0x0004e400000e0000ULL, 0x0000001026267220ULL, 0x088fe20000410000ULL,
0x0000001027277220ULL, 0x080fe20000410000ULL, 0x0000001036367220ULL, 0x080fe20000410000ULL,
0x0000001037377220ULL, 0x080fe20000410000ULL, 0x0000001032327220ULL, 0x080fe20000410000ULL,
0x0000001033337220ULL, 0x080fe20000410000ULL, 0x0000001022227220ULL, 0x080fe20000410000ULL,
0x0000001023237220ULL, 0x080fe20000410000ULL, 0x000000101e1e7220ULL, 0x080fe20000410000ULL,
0x000000101f1f7220ULL, 0x080fe20000410000ULL, 0x000000102e2e7220ULL, 0x080fe20000410000ULL,
0x000000102f2f7220ULL, 0x080fe20000410000ULL, 0x000000102a2a7220ULL, 0x080fe20000410000ULL,
0x000000102b2b7220ULL, 0x080fe20000410000ULL, 0x000000101a1a7220ULL, 0x080fe20000410000ULL,
0x000000101b1b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff16ff7812ULL, 0x000fe20007800815ULL, 0x00000001ff167424ULL, 0x000fd800078e00ffULL,
0x000000145c140221ULL, 0x000fe20000010100ULL, 0x00007610ff160816ULL, 0x000fc60000000016ULL,
0x3fb8aa3b14140820ULL, 0x000fc80000410000ULL, 0x0000001400060308ULL, 0x000e640000000800ULL,
0x0000000613130220ULL, 0x002fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000513057221ULL, 0x000fc20000010000ULL, 0x0000000000107805ULL, 0x000fcc0000015200ULL,
0x00f6ac0046137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe40007804861ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x004fcc0000015200ULL, 0x0000001210157210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09001500780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401500780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011413ULL,
0x0000001512127211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000212127819ULL, 0x000fc80000001213ULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000114147810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6ac0046137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe40007804861ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991016107816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff1000720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000006ff07723eULL, 0x000fe400000000ffULL, 0x00000002ff137819ULL, 0x000fe40000011600ULL,
0x0000541007127816ULL, 0x004fe20000000007ULL, 0x000062327f007947ULL, 0x000fea000b800000ULL,
0x00001f1312077589ULL, 0x0002a400000e0000ULL, 0x0000000813107810ULL, 0x000fe20007ffe0ffULL,
0x000062627f007947ULL, 0x000fea000b800000ULL, 0x00001f1012087589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001013107810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff177224ULL, 0x000fe200078e0012ULL, 0x000088f000387802ULL, 0x000fc40000000f00ULL,
0x000066f000007944ULL, 0x006fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001813107810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff177224ULL, 0x004fe200078e0012ULL,
0x0000894000387802ULL, 0x000fc40000000f00ULL, 0x000066a000007944ULL, 0x002fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000005410783bULL, 0x00ee680000004200ULL, 0x00a800004314783bULL, 0x000ea80000000200ULL,
0x00000000523c783bULL, 0x000ee20000004200ULL, 0x0000312010107816ULL, 0x002fc400000000ffULL,
0x0000312011117816ULL, 0x000fe400000000ffULL, 0x00000010ff38723eULL, 0x080fe200020006ffULL,
0x0000000714148232ULL, 0x084fe20000000000ULL, 0x00000011ff39723eULL, 0x000fe200020006ffULL,
0x0000000716168232ULL, 0x000fe20000000000ULL, 0x0000312012127816ULL, 0x000fe200000000ffULL,
0x0000000815158232ULL, 0x080fe20000000000ULL, 0x0000312013137816ULL, 0x000fe200000000ffULL,
0x0000000817178232ULL, 0x000fe20000000000ULL, 0x00000010ff10723eULL, 0x000fc400030006ffULL,
0x00000011ff11723eULL, 0x000fe400030006ffULL, 0x00000012ff44723eULL, 0x000fe400030006ffULL,
0x00000013ff45723eULL, 0x000fe200030006ffULL, 0x000000381424723cULL, 0x000b620000001824ULL,
0x000031203c3c7816ULL, 0x008fe200000000ffULL, 0x000000005038783bULL, 0x020e620000004200ULL,
0x000031203d3d7816ULL, 0x000fe400000000ffULL, 0x000031203e3e7816ULL, 0x000fc400000000ffULL,
0x000031203f3f7816ULL, 0x000fe200000000ffULL, 0x000000101434723cULL, 0x000b660000001834ULL,
0x0000003fff43723eULL, 0x000fc800030006ffULL, 0x00000012ff10723eULL, 0x020fe200020006ffULL,
0x000000441420723cULL, 0x000be20000001820ULL, 0x00000013ff11723eULL, 0x000fcc00020006ffULL,
0x0000003cff44723eULL, 0x0a0fe200020006ffULL, 0x000000101430723cULL, 0x000b620000001830ULL,
0x0000003dff45723eULL, 0x080fe200020006ffULL, 0x00a800004210783bULL, 0x0204e20000000200ULL,
0x0000003cff3c723eULL, 0x000fe400030006ffULL, 0x0000003dff3d723eULL, 0x000fc600030006ffULL,
0x00000044141c723cULL, 0x000f62000000181cULL, 0x0000003eff42723eULL, 0x004fce00030006ffULL,
0x0000003c142c723cULL, 0x040b62000000182cULL, 0x0000312038387816ULL, 0x002fe400000000ffULL,
0x0000312039397816ULL, 0x000fe400000000ffULL, 0x000031203a3a7816ULL, 0x000fe400000000ffULL,
0x0000003eff3c723eULL, 0x020fe200020006ffULL, 0x000000421418723cULL, 0x000fe20000001818ULL,
0x0000003fff3d723eULL, 0x000fe400020006ffULL, 0x000031203b3b7816ULL, 0x000fca00000000ffULL,
0x0000003c1428723cULL, 0x000b640000001828ULL, 0x000000004e3c783bULL, 0x020e6a0000004200ULL,
0x00000038ff14723eULL, 0x080fe200020006ffULL, 0x0000000710108232ULL, 0x088fe20000000000ULL,
0x00000039ff15723eULL, 0x080fe200020006ffULL, 0x0000000712128232ULL, 0x000fe20000000000ULL,
0x00000038ff38723eULL, 0x000fe200030006ffULL, 0x0000000811118232ULL, 0x080fe20000000000ULL,
0x00000039ff39723eULL, 0x000fe200030006ffULL, 0x0000000813138232ULL, 0x000fce0000000000ULL,
0x000000141024723cULL, 0x040b6e0000001824ULL, 0x0000003aff14723eULL, 0x0a0fe200020006ffULL,
0x000000381034723cULL, 0x000f620000001834ULL, 0x0000003bff15723eULL, 0x000fe400020006ffULL,
0x0000003aff3a723eULL, 0x000fc400030006ffULL, 0x0000003bff3b723eULL, 0x000fc600030006ffULL,
0x000000141030723cULL, 0x000b620000001830ULL, 0x000031203c3c7816ULL, 0x002fe400000000ffULL,
0x000031203d3d7816ULL, 0x000fc800000000ffULL, 0x0000003cff14723eULL, 0x0a0fe200020006ffULL,
0x0000003a1020723cULL, 0x040f620000001820ULL, 0x0000003dff15723eULL, 0x080fe400020006ffULL,
0x000031203e3e7816ULL, 0x000fe400000000ffULL, 0x000031203f3f7816ULL, 0x000fe400000000ffULL,
0x0000003cff3c723eULL, 0x000fe200030006ffULL, 0x00000014101c723cULL, 0x000b62000000181cULL,
0x0000003dff3d723eULL, 0x000fcc00030006ffULL, 0x0000003eff14723eULL, 0x0a0fe200020006ffULL,
0x0000003c102c723cULL, 0x000f62000000182cULL, 0x0000003fff15723eULL, 0x080fe400020006ffULL,
0x0000003eff3e723eULL, 0x000fe400030006ffULL, 0x0000003fff3f723eULL, 0x000fc600030006ffULL,
0x000000141028723cULL, 0x040b6e0000001828ULL, 0x0000f6c80d147811ULL, 0x020fe200078e18ffULL,
0x0000003e1018723cULL, 0x000b620000001818ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0000000014147f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6a00049ff7f8cULL, 0x0005e2000c80043fULL,
0x000000020a567810ULL, 0x000fc40007ffe0ffULL, 0x000000010c127812ULL, 0x020fc400078ec0ffULL,
0x000000010b0b7810ULL, 0x006fc80007ffe0ffULL, 0x0000000e0b00720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff828000007947ULL, 0x000fea000383ffffULL,
0x000000ff0e00720cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x0180000005007810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0000901000067802ULL, 0x000fc40000000f00ULL,
0x00005e1000007944ULL, 0x016fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000500007308ULL, 0x000ee40000001000ULL, 0xbf80000000027423ULL, 0x018fc80000000005ULL,
0x800000ff02037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006900ff037624ULL, 0x000fe400078e00ffULL,
0x00006800ff027624ULL, 0x000fca00078e00ffULL, 0x0000000602037981ULL, 0x000f28000c1e9900ULL,
0x0000000000057919ULL, 0x006e680000000000ULL, 0x0000000000087919ULL, 0x000ea20000000000ULL,
0x00000002ff077819ULL, 0x002fe40000011605ULL, 0x0000000808057811ULL, 0x004fe200078ff0ffULL,
0x0000000003067220ULL, 0x018fca0000410000ULL, 0x00001f0706007589ULL, 0x000e6800000e0000ULL,
0x00001f0506057589ULL, 0x000ea200000e0000ULL, 0x0000002400247220ULL, 0x042fe20000410000ULL,
0x0000002500257220ULL, 0x040fe20000410000ULL, 0x0000003400347220ULL, 0x040fe20000410000ULL,
0x0000003500357220ULL, 0x040fe20000410000ULL, 0x0000003000307220ULL, 0x040fe20000410000ULL,
0x0000003100317220ULL, 0x040fe20000410000ULL, 0x0000002000207220ULL, 0x040fe20000410000ULL,
0x0000002100217220ULL, 0x040fe20000410000ULL, 0x0000001c001c7220ULL, 0x040fe20000410000ULL,
0x0000001d001d7220ULL, 0x040fe20000410000ULL, 0x0000002c002c7220ULL, 0x040fe20000410000ULL,
0x0000002d002d7220ULL, 0x040fe20000410000ULL, 0x0000002800287220ULL, 0x040fe20000410000ULL,
0x0000002900297220ULL, 0x040fe20000410000ULL, 0x0000001800187220ULL, 0x040fe20000410000ULL,
0x0000001900197220ULL, 0x000fe20000410000ULL, 0x0000002605267220ULL, 0x044fe20000410000ULL,
0x0000002705277220ULL, 0x040fe20000410000ULL, 0x0000003605367220ULL, 0x040fe20000410000ULL,
0x0000003705377220ULL, 0x040fe20000410000ULL, 0x0000003205327220ULL, 0x040fe20000410000ULL,
0x0000003305337220ULL, 0x040fe20000410000ULL, 0x0000002205227220ULL, 0x040fe20000410000ULL,
0x0000002305237220ULL, 0x040fe20000410000ULL, 0x0000001e051e7220ULL, 0x040fe20000410000ULL,
0x0000001f051f7220ULL, 0x040fe20000410000ULL, 0x0000002e052e7220ULL, 0x040fe20000410000ULL,
0x0000002f052f7220ULL, 0x040fe20000410000ULL, 0x0000002a052a7220ULL, 0x040fe20000410000ULL,
0x0000002b052b7220ULL, 0x040fe20000410000ULL, 0x0000001a051a7220ULL, 0x040fe20000410000ULL,
0x0000001b051b7220ULL, 0x000fc20000410000ULL, 0x0000000000037919ULL, 0x000ee20000000000ULL,
0x0000100040067824ULL, 0x000fe200078e00ffULL, 0x0000002c2d2d723eULL, 0x000fc400000000ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000282928723eULL, 0x000fe400000000ffULL,
0x000000181914723eULL, 0x004fe400000000ffULL, 0x000000323332723eULL, 0x000fc400000000ffULL,
0x000000222319723eULL, 0x000fe400000000ffULL, 0x0000001e1f1e723eULL, 0x000fe400000000ffULL,
0x0000002a2b2a723eULL, 0x000fe400000000ffULL, 0x0000001a1b15723eULL, 0x000fe400000000ffULL,
0x00000002ff077819ULL, 0x008fe40000011603ULL, 0x0000000203007812ULL, 0x000fc400078ec0ffULL,
0x0000000803097811ULL, 0x000fe200078ff0ffULL, 0x00000008070a7824ULL, 0x040fe200078e00ffULL,
0x0000000700027211ULL, 0x050fe200078ff8ffULL, 0x00000008070f7824ULL, 0x000fe200078e00ffULL,
0x0000000900057211ULL, 0x000fe200078ff8ffULL, 0x0000000809087824ULL, 0x000fe200078e00ffULL,
0x0000000202007810ULL, 0x000fe20007ffe0ffULL, 0x0000000807097824ULL, 0x040fe200078e00ffULL,
0x0000541032187816ULL, 0x000fe40000000019ULL, 0xfffffff808117812ULL, 0x000fe200078ee205ULL,
0x0000000807057824ULL, 0x000fe200078e00ffULL, 0xfffffff809097812ULL, 0x000fc400078ee200ULL,
0x0000100006007812ULL, 0x000fe200078ee2ffULL, 0x0000000803067824ULL, 0x000fe200078e00ffULL,
0x0000000402077810ULL, 0x040fe40007ffe0ffULL, 0x0000000602087810ULL, 0x000fe40007ffe0ffULL,
0xfffffff805057812ULL, 0x000fe200078ee202ULL, 0x000008000d027824ULL, 0x000fe200078e0200ULL,
0xfffffff80a0b7812ULL, 0x000fe400078ee207ULL, 0xfffffff80f0f7812ULL, 0x000fe200078ee208ULL,
0x0000001011107824ULL, 0x100fe200078e0202ULL, 0x0000000806077812ULL, 0x000fe200078ec0ffULL,
0x0000001005067824ULL, 0x100fe200078e0202ULL, 0x000000343505723eULL, 0x000fe200000000ffULL,
0x00000010090a7824ULL, 0x100fe200078e0202ULL, 0x0000763232197816ULL, 0x000fe20000000019ULL,
0x000000100b0c7824ULL, 0x100fe200078e0202ULL, 0x000000ff0d00720cULL, 0x000fe20003f05270ULL,
0x000000100f0e7824ULL, 0x000fe200078e0202ULL, 0x000000242502723eULL, 0x000fe200000000ffULL,
0x0000000106087824ULL, 0x000fe200078e0207ULL, 0x0000001c1d06723eULL, 0x000fe200000000ffULL,
0x00000001070a7824ULL, 0x040fe200078e020aULL, 0x0000541002127816ULL, 0x140fe20000000005ULL,
0x0000000107107824ULL, 0x040fe200078e0210ULL, 0x0000763202137816ULL, 0x000fe20000000005ULL,
0x00000001070c7824ULL, 0x000fe200078e020cULL, 0x000000303102723eULL, 0x000fe200000000ffULL,
0x00000001070e7824ULL, 0x000fe200078e020eULL, 0x000000202105723eULL, 0x000fe200000000ffULL,
0x0000001208007388ULL, 0x0005e20000000a00ULL, 0x00005410062c7816ULL, 0x000fc4000000002dULL,
0x0000763202097816ULL, 0x000fe40000000005ULL, 0x00007632062d7816ULL, 0x000fe4000000002dULL,
0x0000541028067816ULL, 0x140fe40000000014ULL, 0x0000763228077816ULL, 0x000fe40000000014ULL,
0x0000002e2f0f723eULL, 0x000fe400000000ffULL, 0x0000541002087816ULL, 0x004fc40000000005ULL,
0x000000262702723eULL, 0x000fe400000000ffULL, 0x000000363705723eULL, 0x000fe200000000ffULL,
0x000000080a007388ULL, 0x000fe20000000a00ULL, 0x000054102a1c7816ULL, 0x140fe40000000015ULL,
0x000076322a1d7816ULL, 0x000fe20000000015ULL, 0x0000002c0c007388ULL, 0x000fe80000000a00ULL,
0x000000060e007388ULL, 0x0005e40000000a00ULL, 0x0000541002067816ULL, 0x004fc40000000005ULL,
0x0000763202077816ULL, 0x000fe20000000005ULL, 0x0000000104057824ULL, 0x000fc800078e0203ULL,
0x0000000610007388ULL, 0x0005e20000000a00ULL, 0x0000001005057824ULL, 0x000fc600078e0200ULL,
0x000400180a007388ULL, 0x000fe20000000a00ULL, 0x000054101e067816ULL, 0x144fe4000000000fULL,
0x000076321e077816ULL, 0x000fca000000000fULL, 0x000400060c007388ULL, 0x000fe80000000a00ULL,
0x0004001c0e007388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000005107984ULL, 0x000ea80000000c00ULL, 0x0004000005147984ULL, 0x000ee80000000c00ULL,
0x0008000005087984ULL, 0x000e680000000c00ULL, 0x000c000005187984ULL, 0x000e620000000c00ULL,
0x200000ff13137230ULL, 0x004fc40000000000ULL, 0x200000ff12127230ULL, 0x000fe40000000000ULL,
0x200000ff11117230ULL, 0x000fe40000000000ULL, 0x200000ff10107230ULL, 0x000fe40000000000ULL,
0x200000ff17177230ULL, 0x008fe40000000000ULL, 0x200000ff16167230ULL, 0x000fe40000000000ULL,
0x200000ff15157230ULL, 0x000fc40000000000ULL, 0x200000ff14147230ULL, 0x000fe40000000000ULL,
0x0000000b13137230ULL, 0x002fe40000000000ULL, 0x0000000a12127230ULL, 0x000fe40000000000ULL,
0x0000000911117230ULL, 0x000fe40000000000ULL, 0x0000000810107230ULL, 0x000fe40000000000ULL,
0x0000001b17177230ULL, 0x000fc40000000000ULL, 0x0000001a16167230ULL, 0x000fe20000000000ULL,
0x0000001005007388ULL, 0x000fe20000000c00ULL, 0x0000001915157230ULL, 0x000fe40000000000ULL,
0x0000001814147230ULL, 0x000fca0000000000ULL, 0x0004001405007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000020030c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000000067919ULL, 0x000e620000002600ULL,
0x00000003ff0e7819ULL, 0x100fe20000011603ULL, 0x00000000000579c3ULL, 0x000ea20000002700ULL,
0x00000003ff077819ULL, 0x000fe2000001160cULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x0000000140407812ULL, 0x000fe200078ec0ffULL, 0x000000010e027824ULL, 0x000fe200078e0203ULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x000000010c047824ULL, 0x000fc400078e0207ULL,
0x00000008400f7824ULL, 0x000fe200078e00ffULL, 0x0000000702027812ULL, 0x000fe400078ec0ffULL,
0x0000000704097812ULL, 0x000fe400078ec0ffULL, 0x0ffffff802057812ULL, 0x000fe400078ef803ULL,
0x0ffffff809097812ULL, 0x000fc600078ef80cULL, 0x0000001005057824ULL, 0x100fe400078e0200ULL,
0x0000001009027824ULL, 0x000fe400078e0200ULL, 0x00000008060d7824ULL, 0x042fe200078e00ffULL,
0x0000000005087984ULL, 0x000e620000000c00ULL, 0x0000000806067824ULL, 0x000fe200078e00ffULL,
0x00000005040472a4ULL, 0x004fe4000f8e023fULL, 0x0000000002107984ULL, 0x0004e20000000c00ULL,
0xfffffff80d007812ULL, 0x000fe200078ee20eULL, 0x00000008400e7824ULL, 0x000fe200078e00ffULL,
0xfffffff806077812ULL, 0x000fc400078ee207ULL, 0x00000004000d7c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000407077c10ULL, 0x000fe4000ff3e0ffULL, 0xfffffff80e037812ULL, 0x000fe200078ee203ULL,
0x000000ffff027224ULL, 0x004fe200000e06ffULL, 0x00005a000d047a11ULL, 0x000fe200078040ffULL,
0x000000ffff007224ULL, 0x000fe200008e06ffULL, 0x00005a0007067a11ULL, 0x000fe400078240ffULL,
0x00005b000d057a11ULL, 0x000fc400000f4402ULL, 0x00005b0007077a11ULL, 0x000fe400008f4400ULL,
0xfffffff80f0d7812ULL, 0x000fe200078ee20cULL, 0x0000001003027825ULL, 0x000fc800078e0004ULL,
0x000000100d047825ULL, 0x000fe200078e0006ULL, 0x0000000802007986ULL, 0x002fe8000c101d06ULL,
0x0000001004007986ULL, 0x008fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff027819ULL, 0x000fc80000011640ULL, 0x0000000f0200720cULL, 0x000fda0003f06070ULL,
0x0000000239038824ULL, 0x000fc800078e00ffULL, 0x0000640003088a24ULL, 0x002fe400078e0202ULL,
0xffffffffff037424ULL, 0x000fe400078e00ffULL, 0x0000600008088625ULL, 0x000fe200078e0010ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00006800ff3a7624ULL, 0x000fe200078e00ffULL,
0x0000000608038981ULL, 0x000ea2000c1e1900ULL, 0x00006900ff3b7624ULL, 0x000fc600078e00ffULL,
0x00f60000ff067f8cULL, 0x000e68000c80043fULL, 0x000000063a3a7981ULL, 0x000722000c1e9900ULL,
0x000001ff0400780cULL, 0x000fe20003f04070ULL, 0x00000080120c7824ULL, 0x000fe400078e00ffULL,
0x00000040400d7824ULL, 0x000fe400078e00ffULL, 0x0000008038387824ULL, 0x000fc600078e00ffULL,
0x000000400c117812ULL, 0x000fe200078ef80dULL, 0x0000003803217224ULL, 0x004fc800078e02ffULL,
0x0000071000000947ULL, 0x000fea0003800000ULL, 0x00000002ff1a7819ULL, 0x00afe40000011600ULL,
0x00000030051f7812ULL, 0x000fe400078ec0ffULL, 0x000000081a177810ULL, 0x040fe20007ffe0ffULL,
0x0000000111047824ULL, 0x040fe200078e021aULL, 0x000000181a1e7810ULL, 0x040fe40007ffe0ffULL,
0x000000101a1b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000111087824ULL, 0x000fe200078e0217ULL,
0x0000000421197210ULL, 0x000fc40007f1e0ffULL, 0x0000100040157811ULL, 0x000fe200078e68ffULL,
0x0000000111047824ULL, 0x000fe200078e021bULL, 0x0000000821167210ULL, 0x000fe20007f3e0ffULL,
0x0000000111087824ULL, 0x000fe400078e021eULL, 0x000000ffff0a7224ULL, 0x000fe200000e06ffULL,
0x00005e0019187a11ULL, 0x000fe200078038ffULL, 0x000000ffff097224ULL, 0x000fe200008e06ffULL,
0x00000008211d7210ULL, 0x000fe40007f7e0ffULL, 0x0000000000087211ULL, 0x000fc400078fe8ffULL,
0x00005e0016127a11ULL, 0x000fe400078238ffULL, 0x0000000421147210ULL, 0x000fe40007f5e0ffULL,
0x0000000d41047217ULL, 0x000fe40007800000ULL, 0x00005f0019197a11ULL, 0x000fe200000f3c0aULL,
0x000000ffff0a7224ULL, 0x000fe200018e06ffULL, 0x0000000308137812ULL, 0x000fe200078ec0ffULL,
0x0000000104107824ULL, 0x000fe200078e0a0dULL, 0x00005f0016167a11ULL, 0x000fe200008f3c09ULL,
0x0000000417087824ULL, 0x000fe200078e00ffULL, 0x00005e001d1c7a11ULL, 0x000fe200078238ffULL,
0x000000ffff097224ULL, 0x000fe200010e06ffULL, 0x0ffffffc13007812ULL, 0x000fc400078ef800ULL,
0x000000181f047210ULL, 0x000fe40007f7e0ffULL, 0x00005f001d1d7a11ULL, 0x000fe200008f3c0aULL,
0x000000041b0a7824ULL, 0x000fe200078e00ffULL, 0x000000101700720cULL, 0x000fe20003f26070ULL,
0x0000001000177824ULL, 0x000fe200078e0215ULL, 0x00005e00140b7a11ULL, 0x000fe200078038ffULL,
0x000000ffff057224ULL, 0x000fe200018e0619ULL, 0xfffffffc08007812ULL, 0x000fe400078ee213ULL,
0x0000001f12087210ULL, 0x000fc40007f7e0ffULL, 0xfffffffc0a127812ULL, 0x000fe200078ee213ULL,
0x0000001000197824ULL, 0x000fe200078e0215ULL, 0x00005f0014147a11ULL, 0x000fe200000f3c09ULL,
0x000000ffff097224ULL, 0x000fe200018e0616ULL, 0x000000101a00720cULL, 0x080fe40003f06070ULL,
0x000000101b00720cULL, 0x000fe20003f46070ULL, 0x00000010121b7824ULL, 0x000fe200078e0215ULL,
0x000000201a127810ULL, 0x000fe40007ffe0ffULL, 0x0000001f0b0a7210ULL, 0x000fc40007f9e0ffULL,
0x000000301a167810ULL, 0x040fe20007ffe0ffULL, 0x0000000111007824ULL, 0x000fe200078e0212ULL,
0x000000381a187810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0b7224ULL, 0x000fe200020e0614ULL,
0x000000101e00720cULL, 0x0c0fe20003f86070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004177faeULL, 0x0003e2000c101c46ULL, 0x000000041e1e7824ULL, 0x000fe200078e00ffULL,
0x000000281a147810ULL, 0x000fe40007ffe0ffULL, 0x0000000008197faeULL, 0x0005e2000c901c46ULL,
0x000000101200720cULL, 0x000fc40003f66070ULL, 0x000000101600720cULL, 0x080fe20003f26070ULL,
0x000000000a1b7faeULL, 0x0007e2000d101c46ULL, 0x000000101400720cULL, 0x000fe40003f46070ULL,
0x0000000021057210ULL, 0x002fe40007f1e0ffULL, 0x0000001f1c047210ULL, 0x000fe40007fbe0ffULL,
0x00005e00051a7a11ULL, 0x000fe200078c38ffULL, 0x000000ffff087224ULL, 0x004fe200000e06ffULL,
0xfffffffc1e007812ULL, 0x000fc400078ee213ULL, 0x000000101800720cULL, 0x000fe20003f06070ULL,
0x00000004160a7824ULL, 0x008fe200078e00ffULL, 0x00005f00051b7a11ULL, 0x000fe200030f3c08ULL,
0x000000ffff057224ULL, 0x000fe400028e061dULL, 0x0000001000097824ULL, 0x000fe200078e0215ULL,
0xfffffffc0a0a7812ULL, 0x100fe200078ee213ULL, 0x0000000111007824ULL, 0x040fe400078e0214ULL,
0x0000000111087824ULL, 0x040fe200078e0216ULL, 0x0000000004097faeULL, 0x0003e2000e101c46ULL,
0x0000000111117824ULL, 0x000fe200078e0218ULL, 0x0000000021107210ULL, 0x040fe20007fbe0ffULL,
0x0000000412007824ULL, 0x000fe200078e00ffULL, 0x00000008210b7210ULL, 0x040fe20007f9e0ffULL,
0x0000000414087824ULL, 0x000fe200078e00ffULL, 0x0000001121117210ULL, 0x000fe20007fde0ffULL,
0x0000000418187824ULL, 0x000fe200078e00ffULL, 0xfffffffc00007812ULL, 0x000fe200078ee213ULL,
0x000000100a197824ULL, 0x000fe200078e0215ULL, 0xfffffffc08087812ULL, 0x100fe200078ee213ULL,
0x000000ffff127224ULL, 0x000fe200020e06ffULL, 0xfffffffc18047812ULL, 0x002fe200078ee213ULL,
0x000000ffff057224ULL, 0x000fe200028e06ffULL, 0x00005e0010097a11ULL, 0x000fe200078a38ffULL,
0x0000001000137824ULL, 0x100fe200078e0215ULL, 0x00005e000b0a7a11ULL, 0x000fe200078838ffULL,
0x0000001008177824ULL, 0x000fe200078e0215ULL, 0x00005f0010147a11ULL, 0x000fe200028f3c05ULL,
0x0000001004157824ULL, 0x000fe200078e0215ULL, 0x0000001f1a047210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff007224ULL, 0x000fe200030e06ffULL, 0x00005e0011107a11ULL, 0x000fc400078c38ffULL,
0x00005f000b0b7a11ULL, 0x000fe200020f3c12ULL, 0x000000ffff057224ULL, 0x000fe200028e061bULL,
0x0000001f09087210ULL, 0x080fe40007fbe0ffULL, 0x0000001f0a0a7210ULL, 0x080fe40007f9e0ffULL,
0x00005f0011007a11ULL, 0x000fe200030f3c00ULL, 0x000000ffff097224ULL, 0x000fe200028e0614ULL,
0x0000001f10107210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff0b7224ULL, 0x000fe200020e060bULL,
0x0000000004137faeULL, 0x0003e6000d901c46ULL, 0x000000ffff117224ULL, 0x000fe200028e0600ULL,
0x0000000008177faeULL, 0x0003e8000d101c46ULL, 0x000000000a197faeULL, 0x0003e8000c901c46ULL,
0x0000000010157faeULL, 0x0003e2000c101c46ULL, 0x0000065000007947ULL, 0x000fea0003800000ULL,
0x0000001100047211ULL, 0x04afe400078ff0ffULL, 0x00000008001e7811ULL, 0x000fc400078ff0ffULL,
0x0000000421047210ULL, 0x000fe40007f1e0ffULL, 0x00000018000a7811ULL, 0x040fe400078ff0ffULL,
0x0000003000167811ULL, 0x000fe200078ff0ffULL, 0x000000ffff097224ULL, 0x000fe200000e06ffULL,
0x00005e0004267a11ULL, 0x000fe200078038ffULL, 0x00000001110b7824ULL, 0x040fe200078e020aULL,
0x0000001000087811ULL, 0x000fe200078ff0ffULL, 0x0000000111157824ULL, 0x040fe200078e0216ULL,
0x00005f0004287a11ULL, 0x000fe200000f3c09ULL, 0x0000000111047824ULL, 0x040fe200078e021eULL,
0x0000002000107811ULL, 0x040fe200078ff0ffULL, 0x0000000111097824ULL, 0x040fe200078e0208ULL,
0x0000000000177211ULL, 0x000fe200078fe8ffULL, 0x0000000416167824ULL, 0x000fe200078e00ffULL,
0x0000002800147811ULL, 0x000fe200078ff0ffULL, 0x0000000111127824ULL, 0x000fe200078e0210ULL,
0x0000000421247210ULL, 0x000fe20007fde0ffULL, 0x0000000410107824ULL, 0x000fe200078e00ffULL,
0x0000003800187811ULL, 0x000fe200078ff0ffULL, 0x0000000408047824ULL, 0x000fe200078e00ffULL,
0x0000000317197812ULL, 0x000fe200078ec0ffULL, 0x0000000111137824ULL, 0x000fe200078e0214ULL,
0x0000000b211c7210ULL, 0x040fe20007f1e0ffULL, 0x000000040a087824ULL, 0x000fe200078e00ffULL,
0x0000000921207210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff177224ULL, 0x000fe200030e06ffULL,
0x0000100040277811ULL, 0x000fe200078e68ffULL, 0x0000000111117824ULL, 0x000fe200078e0218ULL,
0x00005e0024227a11ULL, 0x000fe200078c38ffULL, 0x00000004140a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc160b7812ULL, 0x100fe200078ee219ULL, 0x000000041e1e7824ULL, 0x000fe200078e00ffULL,
0x00000012211a7210ULL, 0x000fe20007f3e0ffULL, 0x0000000418187824ULL, 0x000fe200078e00ffULL,
0xfffffffc10097812ULL, 0x000fe200078ee219ULL, 0x000000100b257824ULL, 0x000fe200078e0227ULL,
0x0ffffffc19127812ULL, 0x000fc400078ef800ULL, 0x00005f0024247a11ULL, 0x000fe200030f3c17ULL,
0x000000ffff177224ULL, 0x000fe200000e06ffULL, 0x0000001321137210ULL, 0x040fe20007f5e0ffULL,
0x00000010122b7824ULL, 0x100fe200078e0227ULL, 0x0000001521157210ULL, 0x040fe40007f7e0ffULL,
0x0000001121117210ULL, 0x000fe20007f9e0ffULL, 0x0000001009217824ULL, 0x000fe200078e0227ULL,
0xfffffffc04047812ULL, 0x100fe200078ee219ULL, 0x000000ffff097224ULL, 0x000fe200008e06ffULL,
0xfffffffc08087812ULL, 0x000fc400078ee219ULL, 0xfffffffc0a0a7812ULL, 0x000fe200078ee219ULL,
0x00000010041d7824ULL, 0x100fe200078e0227ULL, 0x00005e001c0b7a11ULL, 0x000fe200078038ffULL,
0x00000010081f7824ULL, 0x100fe200078e0227ULL, 0x0000003005297812ULL, 0x000fe200078ec0ffULL,
0x000000100a237824ULL, 0x000fe200078e0227ULL, 0xfffffffc1e007812ULL, 0x100fe200078ee219ULL,
0x000000ffff0a7224ULL, 0x000fe200010e06ffULL, 0x00005e001a127a11ULL, 0x000fe200078238ffULL,
0x000000ffff087224ULL, 0x000fe200018e06ffULL, 0xfffffffc18107812ULL, 0x000fe200078ee219ULL,
0x000000ffff197224ULL, 0x000fe200028e06ffULL, 0x00005f001c1c7a11ULL, 0x000fe200000f3c17ULL,
0x00000010001b7824ULL, 0x100fe200078e0227ULL, 0x0000002629047210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff007224ULL, 0x000fe200020e06ffULL, 0x00005e00201e7a11ULL, 0x000fe200078a38ffULL,
0x0000001010277824ULL, 0x000fe200078e0227ULL, 0x00005f001a1a7a11ULL, 0x000fe200008f3c09ULL,
0x000000ffff057224ULL, 0x000fe200000e0628ULL, 0x00005e0015167a11ULL, 0x000fc400078438ffULL,
0x00005e0013147a11ULL, 0x000fe400078238ffULL, 0x00005e0011187a11ULL, 0x000fe200078638ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000042b7faeULL, 0x0003e2000b901c46ULL,
0x00005f0020207a11ULL, 0x000fe400028f3c19ULL, 0x00005f0015177a11ULL, 0x000fe400010f3c08ULL,
0x00005f0013197a11ULL, 0x000fe400008f3c0aULL, 0x0000002229087210ULL, 0x000fc40007f1e0ffULL,
0x0000001e290a7210ULL, 0x000fe40007f3e0ffULL, 0x00005f0011007a11ULL, 0x000fe200018f3c00ULL,
0x000000ffff097224ULL, 0x000fe200000e0624ULL, 0x0000000b29107210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200008e0620ULL, 0x0000001229127210ULL, 0x040fe40007f7e0ffULL,
0x0000001429147210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff117224ULL, 0x000fe200010e061cULL,
0x0000001629167210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff137224ULL, 0x000fe200018e061aULL,
0x0000001829187210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff157224ULL, 0x000fe200020e0619ULL,
0x00000000081b7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff177224ULL, 0x000fc400028e0617ULL,
0x000000ffff197224ULL, 0x000fe200000e0600ULL, 0x000000000a1d7faeULL, 0x0003e8000b901c46ULL,
0x00000000101f7faeULL, 0x0003e8000b901c46ULL, 0x0000000012217faeULL, 0x0003e8000b901c46ULL,
0x0000000014237faeULL, 0x0003e8000b901c46ULL, 0x0000000016257faeULL, 0x0003e8000b901c46ULL,
0x0000000018277faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000047805ULL, 0x002fc40000015200ULL, 0x00f60400ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fc40007804807ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fcc0000015200ULL,
0x00000008040b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000109097824ULL, 0x000fe200000e0e05ULL,
0x003d09000b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011409ULL, 0x0000000b00007211ULL, 0x000fca00078110ffULL,
0x000000ffff097224ULL, 0x000fca00000e0609ULL, 0x0000000200007819ULL, 0x000fc80000001209ULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f60400ff097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fe40007804807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000e640000000000ULL,
0x0000002040007824ULL, 0x002fca00078e0205ULL, 0x00000003ff047819ULL, 0x000fc80000011600ULL,
0x1ffffffe04057812ULL, 0x000fe400078ec0ffULL, 0x0000000f00047812ULL, 0x000fc600078ec0ffULL,
0x0000000100057824ULL, 0x000fe400078e0205ULL, 0x0000001004077824ULL, 0x040fe400078e00ffULL,
0x0000001004047824ULL, 0x000fe200078e00ffULL, 0x0000000f05007812ULL, 0x040fe400078ec0ffULL,
0x0000000105057810ULL, 0x000fe40007ffe0ffULL, 0x000000f007007812ULL, 0x000fe400078ee200ULL,
0x0000000f05057812ULL, 0x000fc600078ec0ffULL, 0x0000000000107984ULL, 0x000e62000000cc00ULL,
0x000000f004057812ULL, 0x000fca00078ee205ULL, 0x0000000005087984ULL, 0x000ea2000000cc00ULL,
0x000000ffff147224ULL, 0x002fe400078e0010ULL, 0x000000ffff107224ULL, 0x000fe400078e0011ULL,
0x000000ffff157224ULL, 0x000fe400078e0012ULL, 0x000000ffff117224ULL, 0x000fe400078e0013ULL,
0x000000ffff167224ULL, 0x004fe400078e0008ULL, 0x000000ffff177224ULL, 0x000fc400078e000aULL,
0x000000ffff127224ULL, 0x000fe400078e0009ULL, 0x000000ffff137224ULL, 0x000fe200078e000bULL,
0x0000001400007388ULL, 0x0003e8000000cc00ULL, 0x0000001005007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f60000ff087f8cULL, 0x000ea2000c80043fULL,
0x000000ffff0a7224ULL, 0x000fc600078e00ffULL, 0x0000000000047805ULL, 0x002fc80000015200ULL,
0x00f60400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x006fc40007804809ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x00000006040b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09000b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011407ULL, 0x0000000b00007211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000200007819ULL, 0x000fc80000001207ULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f60400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff0e00720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x000e620000000000ULL,
0x0000640039397a24ULL, 0x000fe200078e02ffULL, 0x3db504f33a3a7820ULL, 0x010fe20000410000ULL,
0x0000f688403b7811ULL, 0x000fe200078e18ffULL, 0x000000ffff3f7224ULL, 0x000fe200078e00ffULL,
0xffffffff0e3c7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff437224ULL, 0x000fe200078e00ffULL,
0x0000f608403d7811ULL, 0x000fc400078e28ffULL, 0x000001003f3e7824ULL, 0x000fe200078e020dULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x0000003e4100720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x01cfea0003800000ULL, 0x000000ffff257224ULL, 0x000fe200078e0043ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x000000ffff427224ULL, 0x000fe200078e00ffULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fc4000001ff00ULL, 0x0000000142267810ULL, 0x000fe20007ffe0ffULL,
0x00000d8000007945ULL, 0x000fe20003800000ULL, 0x000000ffff447224ULL, 0x000fe200078e0042ULL,
0x0000000125437812ULL, 0x000fc400078e0cffULL, 0x0000003f26247211ULL, 0x040fe200078ff8ffULL,
0x000000ffff427224ULL, 0x000fe200078e0026ULL, 0x000000022600780cULL, 0x000fe40003f06070ULL,
0x0000000124277810ULL, 0x040fe20007ffe0ffULL, 0x0000010024327824ULL, 0x000fe200078e020dULL,
0x0000000126487812ULL, 0x000fe200078ec0ffULL, 0x0000003803247224ULL, 0x010fe200078e02ffULL,
0x0000000e2700720cULL, 0x000fe40003f26070ULL, 0x0000004032277812ULL, 0x000fca00078ec0ffULL,
0x000000010c497824ULL, 0x000fcc00078e0227ULL, 0x000006b000009947ULL, 0x000fea0003800000ULL,
0x00000002ff347819ULL, 0x002fc80000011600ULL, 0x00000008344a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000134277824ULL, 0x140fe200078e0249ULL, 0x0000001034507810ULL, 0x040fe40007ffe0ffULL,
0x0000001834527810ULL, 0x000fe20007ffe0ffULL, 0x000000014a297824ULL, 0x100fe200078e0249ULL,
0x0000002724307210ULL, 0x000fe20007f3e0ffULL, 0x00000001502b7824ULL, 0x000fe200078e0249ULL,
0x0000003241277217ULL, 0x000fe40007800000ULL, 0x0000002924297210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff317224ULL, 0x000fe200008e06ffULL, 0x0000002b242b7210ULL, 0x000fe20007f7e0ffULL,
0x0000000127457824ULL, 0x000fe200078e0a32ULL, 0x0000002034547810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2a7224ULL, 0x000fe200010e06ffULL, 0x00005e0029367a11ULL, 0x000fe200078438ffULL,
0x000000ffff287224ULL, 0x000fe200018e06ffULL, 0x00005e002b267a11ULL, 0x000fc400078638ffULL,
0x00005f0029377a11ULL, 0x000fe200010f3c2aULL, 0x0000000152297824ULL, 0x100fe200078e0249ULL,
0x00005e0030467a11ULL, 0x000fe400078238ffULL, 0x00005f002b277a11ULL, 0x000fe200018f3c28ULL,
0x00000001542b7824ULL, 0x000fe200078e0249ULL, 0x00005f0030477a11ULL, 0x000fe400008f3c31ULL,
0x0000002834567810ULL, 0x040fe40007ffe0ffULL, 0x0000003034587810ULL, 0x000fc40007ffe0ffULL,
0x00000038345a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000156317824ULL, 0x100fe200078e0249ULL,
0x0000002924307210ULL, 0x000fe20007f3e0ffULL, 0x0000000158337824ULL, 0x100fe200078e0249ULL,
0x0000002b24287210ULL, 0x000fe20007fbe0ffULL, 0x000000015a297824ULL, 0x000fe200078e0249ULL,
0x0000000000327211ULL, 0x000fe200078fe8ffULL, 0x000000ffff2b7224ULL, 0x000fe200008e06ffULL,
0x00005e00302a7a11ULL, 0x000fe200078238ffULL, 0x0000000448497824ULL, 0x000fe200078e00ffULL,
0x0000003124357210ULL, 0x000fc40007fde0ffULL, 0x0000003324317210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff337224ULL, 0x000fe200028e06ffULL, 0x0000002924297210ULL, 0x000fe20007f7e0ffULL,
0x0000000240247824ULL, 0x000fe200078e0243ULL, 0x00005f00302b7a11ULL, 0x000fe200008f3c2bULL,
0x000000ffff4c7224ULL, 0x000fe200020e06ffULL, 0x000000454a00720cULL, 0x0c0fe20003f26070ULL,
0x000000044a4a7824ULL, 0x000fe200078e00ffULL, 0x00000003324f7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff4e7224ULL, 0x000fe200030e06ffULL, 0x000000453400720cULL, 0x000fc40003f46070ULL,
0x0000100024247811ULL, 0x000fe400078e60ffULL, 0x0ffffffc4f4b7812ULL, 0x100fe400078ef800ULL,
0xfffffffc49497812ULL, 0x000fe400078ee200ULL, 0xfffffffc4a4d7812ULL, 0x000fe200078ee24fULL,
0x000000104b4b7824ULL, 0x000fe200078e0224ULL, 0x00005e0028327a11ULL, 0x000fe200078a38ffULL,
0x0000001049467825ULL, 0x000fe200078e0046ULL, 0x000000455a00720cULL, 0x000fc40003fc6070ULL,
0x00005f0028337a11ULL, 0x000fe200028f3c33ULL, 0x000000104d4d7824ULL, 0x000fe200078e0224ULL,
0x00005e0029287a11ULL, 0x000fe200078838ffULL, 0x0000001049367825ULL, 0x000fe200078e0036ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000464b7faeULL, 0x0003e2000d101c46ULL,
0x00005e0035347a11ULL, 0x000fe400078a38ffULL, 0x000000ffff4a7224ULL, 0x000fe200018e06ffULL,
0x00005e0031307a11ULL, 0x040fe200078638ffULL, 0x00000000364d7faeULL, 0x0005e2000c901c46ULL,
0x000000455000720cULL, 0x0c0fe20003f26070ULL, 0x0000000450507824ULL, 0x000fe200078e00ffULL,
0x00005f0031317a11ULL, 0x000fe200018f3c4cULL, 0x000000045a5a7824ULL, 0x000fe200078e00ffULL,
0x000000455200720cULL, 0x0c0fe20003f46070ULL, 0x0000000452527824ULL, 0x000fe200078e00ffULL,
0x00005f0029297a11ULL, 0x000fe200020f3c4aULL, 0x0000001049267825ULL, 0x000fe200078e0026ULL,
0x000000455400720cULL, 0x000fc40003f66070ULL, 0x00005f0035357a11ULL, 0x000fe200028f3c4eULL,
0x0000000454547824ULL, 0x000fe200078e00ffULL, 0x000000455600720cULL, 0x0c0fe20003f86070ULL,
0x0000000456567824ULL, 0x000fe200078e00ffULL, 0x000000455800720cULL, 0x040fe20003fa6070ULL,
0x0000000458587824ULL, 0x000fe200078e00ffULL, 0xfffffffc50377812ULL, 0x004fe200078ee24fULL,
0x00000010492a7825ULL, 0x000fe200078e002aULL, 0xfffffffc52457812ULL, 0x100fe400078ee24fULL,
0xfffffffc54477812ULL, 0x102fe200078ee24fULL, 0x0000001037377824ULL, 0x100fe200078e0224ULL,
0xfffffffc564b7812ULL, 0x100fe200078ee24fULL, 0x0000001045457824ULL, 0x100fe200078e0224ULL,
0xfffffffc584d7812ULL, 0x100fe200078ee24fULL, 0x0000001047477824ULL, 0x000fe200078e0224ULL,
0xfffffffc5a4f7812ULL, 0x000fe200078ee24fULL, 0x0000001049327825ULL, 0x000fe200078e0032ULL,
0x0000000026377faeULL, 0x0003e6000c901c46ULL, 0x000000104b4b7824ULL, 0x000fe200078e0224ULL,
0x000000002a457faeULL, 0x0003e2000d101c46ULL, 0x0000001049347825ULL, 0x000fc600078e0034ULL,
0x0000000032477faeULL, 0x0003e2000d901c46ULL, 0x000000104d4d7824ULL, 0x000fe400078e0224ULL,
0x0000001049307825ULL, 0x000fe200078e0030ULL, 0x00000000344b7faeULL, 0x0003e6000e101c46ULL,
0x000000104f4f7824ULL, 0x000fe200078e0224ULL, 0x00000000304d7faeULL, 0x0003e2000e901c46ULL,
0x0000001049287825ULL, 0x000fca00078e0028ULL, 0x00000000284f7faeULL, 0x0003e2000f101c46ULL,
0x000005f000007947ULL, 0x000fea0003800000ULL, 0x0000004900277211ULL, 0x042fe400078ff0ffULL,
0x0000000800327811ULL, 0x000fe400078ff0ffULL, 0x00000027242b7210ULL, 0x000fe40007f3e0ffULL,
0x00000038004e7811ULL, 0x000fe200078ff0ffULL, 0x0000000132297824ULL, 0x100fe200078e0249ULL,
0x0000001800367811ULL, 0x000fe200078ff0ffULL, 0x000000ffff307224ULL, 0x000fe200008e06ffULL,
0x00005e002b287a11ULL, 0x040fe200078238ffULL, 0x0000000432327824ULL, 0x000fe200078e00ffULL,
0x0000002924277210ULL, 0x000fe20007f5e0ffULL, 0x000000014e457824ULL, 0x100fe200078e0249ULL,
0x00005f002b297a11ULL, 0x000fe200008f3c30ULL, 0x0000000136317824ULL, 0x100fe200078e0249ULL,
0x00000000002b7211ULL, 0x040fe200078fe8ffULL, 0x000000ffff2a7224ULL, 0x000fe200010e06ffULL,
0x0000001000307811ULL, 0x000fe200078ff0ffULL, 0x000000044e4e7824ULL, 0x000fe200078e00ffULL,
0x00005e0027267a11ULL, 0x000fe200078438ffULL, 0x0000000436367824ULL, 0x000fe200078e00ffULL,
0x000000032b477812ULL, 0x000fe200078ec0ffULL, 0x00000001302b7824ULL, 0x000fe200078e0249ULL,
0x0000002000467811ULL, 0x000fe200078ff0ffULL, 0x0000000430307824ULL, 0x000fe200078e00ffULL,
0x00000028004a7811ULL, 0x000fc400078ff0ffULL, 0x00000030004c7811ULL, 0x000fe200078ff0ffULL,
0x0000000146337824ULL, 0x000fe200078e0249ULL, 0x00005f0027277a11ULL, 0x000fe200010f3c2aULL,
0x00000002402a7824ULL, 0x000fe200078e0243ULL, 0x0000002b242b7210ULL, 0x000fe20007f7e0ffULL,
0x0000000446467824ULL, 0x000fe200078e00ffULL, 0xfffffffc304b7812ULL, 0x000fe200078ee247ULL,
0x000000014a357824ULL, 0x100fe200078e0249ULL, 0x000010002a347811ULL, 0x000fe200078e60ffULL,
0x000000014c377824ULL, 0x000fe200078e0249ULL, 0xfffffffc32497812ULL, 0x100fe200078ee247ULL,
0x000000044a4a7824ULL, 0x000fe200078e00ffULL, 0xfffffffc4e557812ULL, 0x100fe200078ee247ULL,
0x000000044c4c7824ULL, 0x000fe200078e00ffULL, 0xfffffffc364d7812ULL, 0x000fe200078ee247ULL,
0x000000ffff327224ULL, 0x000fe200018e06ffULL, 0x00000033244e7210ULL, 0x000fc40007f3e0ffULL,
0xfffffffc464f7812ULL, 0x100fe400078ee247ULL, 0x00000031242a7210ULL, 0x040fe40007f5e0ffULL,
0x0000003524357210ULL, 0x040fe40007f7e0ffULL, 0x0000003724337210ULL, 0x000fe20007f9e0ffULL,
0x0000000448377824ULL, 0x000fe200078e00ffULL, 0xfffffffc4a517812ULL, 0x100fe400078ee247ULL,
0x00005e002b307a11ULL, 0x000fe200078c38ffULL, 0x000000ffff4a7224ULL, 0x000fe200020e06ffULL,
0x0000004524247210ULL, 0x000fe20007fbe0ffULL, 0x0000001049457824ULL, 0x100fe200078e0234ULL,
0xfffffffc4c537812ULL, 0x000fe200078ee247ULL, 0x000000104b497824ULL, 0x000fe200078e0234ULL,
0x0ffffffc47477812ULL, 0x000fe200078ef800ULL, 0x000000104d4b7824ULL, 0x000fe200078e0234ULL,
0x00005f002b317a11ULL, 0x000fe200030f3c32ULL, 0x000000104f4d7824ULL, 0x000fc400078e0234ULL,
0x000000ffff2b7224ULL, 0x000fe200010e06ffULL, 0x00005e002a467a11ULL, 0x040fe200078438ffULL,
0x00000010514f7824ULL, 0x100fe400078e0234ULL, 0x0000001053517824ULL, 0x100fe400078e0234ULL,
0x0000001055537824ULL, 0x000fe200078e0234ULL, 0xfffffffc37557812ULL, 0x000fe200078ee200ULL,
0x0000001047577824ULL, 0x000fe200078e0234ULL, 0x00005f002a477a11ULL, 0x000fe200010f3c2bULL,
0x000000ffff377224ULL, 0x000fe200008e06ffULL, 0x00005e004e367a11ULL, 0x000fe200078238ffULL,
0x000000ffff4c7224ULL, 0x000fe200018e06ffULL, 0x00005e0035347a11ULL, 0x000fe200078438ffULL,
0x000000ffff2b7224ULL, 0x000fe200028e06ffULL, 0x00005e0033327a11ULL, 0x000fe200078638ffULL,
0x0000001055287825ULL, 0x000fe200078e0028ULL, 0x00005e00242a7a11ULL, 0x000fc400078838ffULL,
0x00005f004e377a11ULL, 0x000fe200008f3c37ULL, 0x0000001055267825ULL, 0x000fe200078e0026ULL,
0x00005f0035357a11ULL, 0x000fe200010f3c4cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028577faeULL, 0x0003e2000b901c46ULL, 0x00005f0033337a11ULL, 0x000fe200018f3c4aULL,
0x0000001055307825ULL, 0x040fe200078e0030ULL, 0x00005f00242b7a11ULL, 0x000fe200020f3c2bULL,
0x0000000026457faeULL, 0x0003e4000b901c46ULL, 0x0000001055467825ULL, 0x040fe400078e0046ULL,
0x0000000030497faeULL, 0x0003e4000b901c46ULL, 0x0000001055367825ULL, 0x000fc400078e0036ULL,
0x00000000464b7faeULL, 0x0003e4000b901c46ULL, 0x0000001055347825ULL, 0x040fe400078e0034ULL,
0x00000000364d7faeULL, 0x0003e4000b901c46ULL, 0x0000001055327825ULL, 0x040fe400078e0032ULL,
0x00000000344f7faeULL, 0x0003e4000b901c46ULL, 0x00000010552a7825ULL, 0x000fc400078e002aULL,
0x0000000032517faeULL, 0x0003e8000b901c46ULL, 0x000000002a537faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff4800720cULL, 0x000fe20003f25270ULL,
0x000000a000007945ULL, 0x000fd80003800000ULL, 0x0000008000009947ULL, 0x000fea0003800000ULL,
0x0000000202027810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff037424ULL, 0x000fc600078e00ffULL,
0x0000000f0200720cULL, 0x000fda0003f26070ULL, 0x0000004000001947ULL, 0x000fea0003800000ULL,
0x0000000239267824ULL, 0x002fe400078e0202ULL, 0x00000004ff277424ULL, 0x000fc800078e00ffULL,
0x0000600026267625ULL, 0x000fca00078e0027ULL, 0x0000000626037981ULL, 0x000324000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000002000497810ULL, 0x002fe20007ffe0ffULL, 0x0000000240477824ULL, 0x000fe200078e0225ULL,
0xfffffff800257812ULL, 0x040fe200078ec0ffULL, 0x000000ffff457224ULL, 0x000fe200078e00ffULL,
0xfffffff849497812ULL, 0x000fe400078ec0ffULL, 0x0000000700277812ULL, 0x000fe400078ec0ffULL,
0x0000000725467812ULL, 0x100fe400078ef800ULL, 0x0000000749497812ULL, 0x000fc400078ef800ULL,
0x0000100047477811ULL, 0x000fe400078e60ffULL, 0x0000000827487812ULL, 0x000fe400078ef800ULL,
0x00000001ff4a7819ULL, 0x000fe40000011646ULL, 0x00000001ff4c7819ULL, 0x000fe20000011649ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000000444357824ULL, 0x100fe200078e0245ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000014a247824ULL, 0x020fe200078e0245ULL,
0x00000001454b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000446257824ULL, 0x000fc400078e00ffULL,
0x0000000235357824ULL, 0x000fe400078e00ffULL, 0x0000001048267824ULL, 0x000fe200078e00ffULL,
0xfffffffc25247812ULL, 0x000fe200078ee224ULL, 0x000000014c307824ULL, 0x000fe200078e0245ULL,
0x0000003500257211ULL, 0x000fe200078fe0ffULL, 0x0000000449317824ULL, 0x000fe200078e00ffULL,
0x0000000235357810ULL, 0x000fe20007ffe0ffULL, 0x0000001024287824ULL, 0x000fe200078e0247ULL,
0x0000000245457810ULL, 0x000fe20007ffe0ffULL, 0x0000000148257824ULL, 0x000fe200078e0225ULL,
0xfffffffc31307812ULL, 0x000fc400078ee230ULL, 0x0000003500357211ULL, 0x000fe200078fe0ffULL,
0x000000002828783bULL, 0x000e620000000200ULL, 0xfffffff026257812ULL, 0x000fe200078ee225ULL,
0x0000001030307824ULL, 0x000fe200078e0247ULL, 0x000000044500780cULL, 0x000fe20003f25270ULL,
0x0000000148357824ULL, 0x000fe400078e0235ULL, 0x0000001025257824ULL, 0x000fe400078e00ffULL,
0x000000003030783bULL, 0x000fe80000000200ULL, 0x000000002524783bULL, 0x000ea20000000200ULL,
0x00000028ff36723eULL, 0x002fc400020006ffULL, 0x00000028ff37723eULL, 0x000fe400030006ffULL,
0x00000029ff4e723eULL, 0x080fe400020006ffULL, 0x00000029ff4f723eULL, 0x000fe400030006ffULL,
0x0000002aff28723eULL, 0x080fe400020006ffULL, 0x0000002aff29723eULL, 0x000fe200030006ffULL,
0x000000014a2a7824ULL, 0x100fe200078e024bULL, 0x000000362420723cULL, 0x004b620000001820ULL,
0x000000014c4b7824ULL, 0x000fcc00078e024bULL, 0x0000000446377824ULL, 0x020fe200078e00ffULL,
0x000000282418723cULL, 0x040be80000001818ULL, 0xfffffffc37347812ULL, 0x000fe400078ee22aULL,
0x0000002bff2a723eULL, 0x080fe200020006ffULL, 0x0000001048287824ULL, 0x020fe200078e00ffULL,
0x0000004e241c723cULL, 0x000b62000000181cULL, 0x0000001034347824ULL, 0x000fe200078e0247ULL,
0x0000002bff2b723eULL, 0x000fc400030006ffULL, 0xfffffff028287812ULL, 0x000fc600078ee235ULL,
0x00000030ff4e723eULL, 0x0a0fe200020006ffULL, 0x000000003434783bULL, 0x000e620000000200ULL,
0x00000030ff4f723eULL, 0x000fe200030006ffULL, 0x0000001028287824ULL, 0x000fe200078e00ffULL,
0x00000031ff30723eULL, 0x080fe200020006ffULL, 0x0000002a242c723cULL, 0x000b62000000182cULL,
0x00000031ff31723eULL, 0x000fc600030006ffULL, 0x000000002828783bULL, 0x020ea80000000200ULL,
0x0000004e2414723cULL, 0x040b6e0000001814ULL, 0x00000004494e7824ULL, 0x020fe200078e00ffULL,
0x000000302410723cULL, 0x000b620000001810ULL, 0x00000033ff4f723eULL, 0x000fcc00030006ffULL,
0x00000032ff30723eULL, 0x0a0fe400020006ffULL, 0x00000032ff31723eULL, 0x000fe400030006ffULL,
0xfffffffc4e327812ULL, 0x000fe400078ee24bULL, 0x00000033ff4e723eULL, 0x000fc600020006ffULL,
0x0000001032327824ULL, 0x000fe200078e0247ULL, 0x000000302408723cULL, 0x040b6a0000001808ULL,
0x000000003230783bULL, 0x020ee60000000200ULL, 0x0000004e2404723cULL, 0x000b6e0000001804ULL,
0x00000034ff24723eULL, 0x022fc400020006ffULL, 0x00000034ff25723eULL, 0x000fe400030006ffULL,
0x00000035ff34723eULL, 0x080fe400020006ffULL, 0x00000035ff35723eULL, 0x000fc600030006ffULL,
0x000000242820723cULL, 0x044b6e0000001820ULL, 0x00000036ff24723eULL, 0x0a0fe200020006ffULL,
0x00000034281c723cULL, 0x000f62000000181cULL, 0x00000036ff25723eULL, 0x000fe400030006ffULL,
0x00000037ff36723eULL, 0x000fc400020006ffULL, 0x00000037ff37723eULL, 0x000fc600030006ffULL,
0x000000242818723cULL, 0x040b6e0000001818ULL, 0x00000030ff24723eULL, 0x0a8fe200020006ffULL,
0x00000036282c723cULL, 0x000f62000000182cULL, 0x00000030ff25723eULL, 0x000fe400030006ffULL,
0x00000031ff30723eULL, 0x000fc400020006ffULL, 0x00000031ff31723eULL, 0x000fc600030006ffULL,
0x000000242814723cULL, 0x040b6e0000001814ULL, 0x00000032ff24723eULL, 0x0a0fe200020006ffULL,
0x000000302810723cULL, 0x000b620000001810ULL, 0x00000032ff25723eULL, 0x000fe400030006ffULL,
0x00000033ff32723eULL, 0x000fc400020006ffULL, 0x00000033ff33723eULL, 0x000fc600030006ffULL,
0x000000242808723cULL, 0x040b700000001808ULL, 0x000000322804723cULL, 0x000b620000001804ULL,
0xfffffa8000001947ULL, 0x000fce000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff257224ULL, 0x020fe200078e0043ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffeb0000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x0000003a20257220ULL, 0x080fe20000410000ULL, 0x0000003a21267220ULL, 0x080fe20000410000ULL,
0x0000003a22207220ULL, 0x080fe20000410000ULL, 0x0000003a23217220ULL, 0x080fe20000410000ULL,
0x0000003a2c2b7220ULL, 0x080fe20000410000ULL, 0x0000003a1c277220ULL, 0x080fe20000410000ULL,
0x0000003a1d287220ULL, 0x080fe20000410000ULL, 0x0000003a1e307220ULL, 0x080fe20000410000ULL,
0x0000003a1f317220ULL, 0x080fe20000410000ULL, 0x0000003a18297220ULL, 0x080fe20000410000ULL,
0x0000003a192a7220ULL, 0x080fe20000410000ULL, 0x0000003a2d2c7220ULL, 0x080fe20000410000ULL,
0x0000003a10237220ULL, 0x080fe20000410000ULL, 0x0000003a11227220ULL, 0x080fe20000410000ULL,
0x0000003a1a1a7220ULL, 0x080fe20000410000ULL, 0x0000003a1b1b7220ULL, 0x080fe20000410000ULL,
0x0000003a2e2e7220ULL, 0x080fe20000410000ULL, 0x0000003a2f2f7220ULL, 0x080fe20000410000ULL,
0x0000003a142d7220ULL, 0x080fe20000410000ULL, 0x0000003a15247220ULL, 0x080fe20000410000ULL,
0x0000003a16187220ULL, 0x080fe20000410000ULL, 0x0000003a17197220ULL, 0x080fe20000410000ULL,
0x0000003a12107220ULL, 0x080fe20000410000ULL, 0x0000003a13117220ULL, 0x080fe20000410000ULL,
0x0000003a081f7220ULL, 0x080fe20000410000ULL, 0x0000003a091e7220ULL, 0x080fe20000410000ULL,
0x0000003a0a327220ULL, 0x080fe20000410000ULL, 0x0000003a0b337220ULL, 0x080fe20000410000ULL,
0x0000003a041d7220ULL, 0x080fe20000410000ULL, 0x0000003a051c7220ULL, 0x080fe20000410000ULL,
0x0000003a06067220ULL, 0x080fe20000410000ULL, 0x0000003a07077220ULL, 0x000fe20000410000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000003b047f8cULL, 0x0002a2000c80043fULL,
0x000000ffff137224ULL, 0x000fc400078e001aULL, 0x000000ffff147224ULL, 0x000fe400078e001bULL,
0x000000ffff177224ULL, 0x000fe400078e0018ULL, 0x000000ffff127224ULL, 0x000fe400078e0019ULL,
0x000000ffff087224ULL, 0x000fe400078e0020ULL, 0x000000ffff097224ULL, 0x000fe400078e0021ULL,
0x000000ffff0a7224ULL, 0x000fc400078e0030ULL, 0x000000ffff0b7224ULL, 0x000fe400078e0031ULL,
0x000000ffff157224ULL, 0x000fe400078e002eULL, 0x000000ffff167224ULL, 0x000fe400078e002fULL,
0x000000ffff187224ULL, 0x000fe400078e0032ULL, 0x000000ffff197224ULL, 0x000fe400078e0033ULL,
0x000000ffff1a7224ULL, 0x000fc400078e0006ULL, 0x000000ffff1b7224ULL, 0x000fc400078e0007ULL,
0x0000000000067805ULL, 0x006fca0000015200ULL, 0x000004003b217984ULL, 0x000e640000000800ULL,
0x8000000021ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff2e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000207805ULL, 0x000fcc0000015200ULL,
0x00000020062f7210ULL, 0x000fca0007f1e1ffULL, 0x0000000121217824ULL, 0x000fe200000e0e07ULL,
0x003d09002f00780cULL, 0x000fc80003f06070ULL, 0x000000ff2100720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402f00780cULL, 0x000fc80003f06070ULL,
0x000000ff2100720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff207819ULL, 0x000fc80000011421ULL, 0x0000002f20207211ULL, 0x000fca00078110ffULL,
0x000000ffff217224ULL, 0x000fca00000e0621ULL, 0x0000000220207819ULL, 0x000fc80000001221ULL,
0x000000200000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012e2e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004003b217984ULL, 0x000e640000000800ULL, 0x8000000021ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000400217824ULL, 0x000fe200078e00ffULL,
0x0000003c3f00720cULL, 0x000fc80003f05270ULL, 0xfffffff021057812ULL, 0x000fca00078ec0ffULL,
0x0000008040207824ULL, 0x000fca00078e0205ULL, 0x00f4000020047984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x00000002002e7824ULL, 0x000fe400078e00ffULL,
0x00000001413e7824ULL, 0x000fc600078e0a3eULL, 0x000000062e2f7812ULL, 0x000fc800078ec0ffULL,
0x000000012f317812ULL, 0x040fe400078efcffULL, 0x000000082f337812ULL, 0x000fe400078efcffULL,
0x0000003e3100720cULL, 0x080fe40003f26070ULL, 0x000000102f317812ULL, 0x000fe400078efcffULL,
0x0000003e3300720cULL, 0x080fe40003f06070ULL, 0x0000003e3100720cULL, 0x000fc40003fc6070ULL,
0x000000112f337812ULL, 0x040fe400078efcffULL, 0x000000182f317812ULL, 0x040fe400078efcffULL,
0x0000003e2f00720cULL, 0x080fe40003f46070ULL, 0x0000003e3300720cULL, 0x080fe40003fa6070ULL,
0x0000003e3100720cULL, 0x000fe40003f66070ULL, 0x000000092f357812ULL, 0x000fc400078efcffULL,
0x000000192f337812ULL, 0x040fe400078efcffULL, 0x000000202f317812ULL, 0x000fe400078efcffULL,
0xff80000008087808ULL, 0x000fe40005000000ULL, 0xff80000025257808ULL, 0x000fe40005000000ULL,
0xff80000009097808ULL, 0x000fe40004800000ULL, 0xff80000026267808ULL, 0x000fc40004800000ULL,
0x0000003e3500720cULL, 0x080fe40003f86070ULL, 0x0000003e3300720cULL, 0x080fe40003f46070ULL,
0x0000003e3100720cULL, 0x000fe40003f26070ULL, 0x000000212f337812ULL, 0x040fe400078efcffULL,
0x000000282f317812ULL, 0x000fe400078efcffULL, 0xff8000000a0a7808ULL, 0x000fc40004000000ULL,
0xff80000027277808ULL, 0x000fe40004000000ULL, 0xff8000000b0b7808ULL, 0x000fe40006000000ULL,
0xff80000028287808ULL, 0x000fe40006000000ULL, 0x0000003e3300720cULL, 0x080fe40003f06070ULL,
0x0000003e3100720cULL, 0x000fe40003f86070ULL, 0x000000292f337812ULL, 0x000fc400078efcffULL,
0x000000302f317812ULL, 0x000fe400078efcffULL, 0xff80000013137808ULL, 0x000fe40007000000ULL,
0xff80000029297808ULL, 0x000fe40007000000ULL, 0xff80000014147808ULL, 0x000fe40006800000ULL,
0xff8000002a2a7808ULL, 0x000fe40006800000ULL, 0x0000003e3300720cULL, 0x000fc40003fc6070ULL,
0x0000003e3100720cULL, 0x000fe40003fa6070ULL, 0x000000312f337812ULL, 0x040fe400078efcffULL,
0x000000382f317812ULL, 0x040fe400078efcffULL, 0x000000392f2f7812ULL, 0x000fe400078efcffULL,
0xff80000015157808ULL, 0x000fe40005800000ULL, 0xff8000002b2b7808ULL, 0x000fc40005800000ULL,
0xff80000016167808ULL, 0x000fe40005000000ULL, 0xff8000002c2c7808ULL, 0x000fe40005000000ULL,
0xff80000017177808ULL, 0x000fe40004800000ULL, 0xff8000002d2d7808ULL, 0x000fe40004800000ULL,
0x0000003e3300720cULL, 0x080fe40003f66070ULL, 0x0000003e3100720cULL, 0x000fc40003f46070ULL,
0x0000003e2f00720cULL, 0x000fe40003f26070ULL, 0xff80000012127808ULL, 0x000fe40004000000ULL,
0xff80000024247808ULL, 0x000fe40004000000ULL, 0xff80000010107808ULL, 0x000fe40006000000ULL,
0xff80000023237808ULL, 0x000fe40006000000ULL, 0xff80000011117808ULL, 0x000fc40007000000ULL,
0xff80000022227808ULL, 0x000fe40007000000ULL, 0xff80000018187808ULL, 0x000fe40006800000ULL,
0xff8000001f1f7808ULL, 0x000fe40006800000ULL, 0xff80000019197808ULL, 0x000fe40005800000ULL,
0xff8000001e1e7808ULL, 0x000fe40005800000ULL, 0xff8000001a1a7808ULL, 0x000fc40005000000ULL,
0xff8000001d1d7808ULL, 0x000fe40005000000ULL, 0xff8000001b1b7808ULL, 0x000fe40004800000ULL,
0xff8000001c1c7808ULL, 0x000fc40004800000ULL, 0x000000250400720bULL, 0x004fe20003f1e000ULL,
0x0000001fff367424ULL, 0x000fe200078e00ffULL, 0x000000080500720bULL, 0x000fe20003f3e000ULL,
0xffffffffff377424ULL, 0x000fe200078e00ffULL, 0x00000004252f7208ULL, 0x000fe40004000000ULL,
0x0000000508047208ULL, 0x000fc40004800000ULL, 0x000000262f00720bULL, 0x000fe40003f1e000ULL,
0x000000090400720bULL, 0x000fe40003f3e000ULL, 0x0000002f262e7208ULL, 0x000fe40004000000ULL,
0x0000000409057208ULL, 0x000fe40004800000ULL, 0x000000272e00720bULL, 0x000fe40003f1e000ULL,
0x0000000a0500720bULL, 0x000fc40003f3e000ULL, 0x0000002e272f7208ULL, 0x000fe40004000000ULL,
0x000000050a047208ULL, 0x000fe40004800000ULL, 0x000000282f00720bULL, 0x000fe40003f1e000ULL,
0x0000000b0400720bULL, 0x000fe40003f3e000ULL, 0x0000002f282e7208ULL, 0x000fe40004000000ULL,
0x000000040b047208ULL, 0x000fc40004800000ULL, 0x000000292e00720bULL, 0x000fe40003f1e000ULL,
0x000000130400720bULL, 0x000fe40003f3e000ULL, 0x0000002e29057208ULL, 0x000fe40004000000ULL,
0x00000004132f7208ULL, 0x000fe40004800000ULL, 0x0000002a0500720bULL, 0x000fe40003f1e000ULL,
0x000000142f00720bULL, 0x000fc40003f3e000ULL, 0x000000052a047208ULL, 0x000fe40004000000ULL,
0x0000002f142e7208ULL, 0x000fe40004800000ULL, 0x0000002b0400720bULL, 0x000fe40003f1e000ULL,
0x000000152e00720bULL, 0x000fe40003f3e000ULL, 0x000000042b057208ULL, 0x000fe40004000000ULL,
0x0000002e152f7208ULL, 0x000fc40004800000ULL, 0x0000002c0500720bULL, 0x000fe40003f1e000ULL,
0x000000162f00720bULL, 0x000fe40003f3e000ULL, 0x000000052c047208ULL, 0x000fe40004000000ULL,
0x0000002f162e7208ULL, 0x000fe40004800000ULL, 0x0000002d0400720bULL, 0x000fe40003f1e000ULL,
0x000000172e00720bULL, 0x000fc40003f3e000ULL, 0x000000042d057208ULL, 0x000fe40004000000ULL,
0x0000002e172f7208ULL, 0x000fe40004800000ULL, 0x000000240500720bULL, 0x000fe40003f1e000ULL,
0x000000122f00720bULL, 0x000fe40003f3e000ULL, 0x0000000524047208ULL, 0x000fe40004000000ULL,
0x0000002f122f7208ULL, 0x000fc40004800000ULL, 0x000000230400720bULL, 0x000fe40003f1e000ULL,
0x000000102f00720bULL, 0x000fe40003f3e000ULL, 0x0000000423057208ULL, 0x000fe40004000000ULL,
0x0000002f10047208ULL, 0x000fe40004800000ULL, 0x000000220500720bULL, 0x000fe40003f1e000ULL,
0x000000110400720bULL, 0x000fc40003f3e000ULL, 0x00000005222e7208ULL, 0x000fe40004000000ULL,
0x0000000411057208ULL, 0x000fe40004800000ULL, 0x0000001f2e00720bULL, 0x000fe40003f1e000ULL,
0x000000180500720bULL, 0x000fe40003f3e000ULL, 0x0000002e1f2f7208ULL, 0x000fe40004000000ULL,
0x0000000518047208ULL, 0x000fc40004800000ULL, 0x0000001e2f00720bULL, 0x000fe40003f1e000ULL,
0x000000190400720bULL, 0x000fe40003f3e000ULL, 0x0000002f1e2e7208ULL, 0x000fe40004000000ULL,
0x0000000419057208ULL, 0x000fe40004800000ULL, 0x0000001d2e00720bULL, 0x000fe40003f1e000ULL,
0x0000001a0500720bULL, 0x000fc40003f3e000ULL, 0x0000002e1d2f7208ULL, 0x000fe40004000000ULL,
0x000000051a047208ULL, 0x000fe40004800000ULL, 0x0000001c2f00720bULL, 0x000fe40003f1e000ULL,
0x0000001b0400720bULL, 0x000fe40003f3e000ULL, 0x0000002f1c327208ULL, 0x000fe40004000000ULL,
0x000000041b347208ULL, 0x000fe20004800000ULL, 0x000014e27f007947ULL, 0x000fec000b800000ULL,
0x0c401f0032047f89ULL, 0x0004e400000e0000ULL, 0x000000043200720bULL, 0x008fc80003f1e000ULL,
0x0000003204357208ULL, 0x000fe20004000000ULL, 0x000014f27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0034047f89ULL, 0x000ee800000e0000ULL, 0x0c401f0006057f89ULL, 0x000e6800000e0000ULL,
0x0c401f00072e7f89ULL, 0x000ea200000e0000ULL, 0x000000043400720bULL, 0x008fc40003f1e000ULL,
0x000000050600720bULL, 0x002fe40003f3e000ULL, 0x0000003404307208ULL, 0x000fe40004000000ULL,
0x0000000605317208ULL, 0x000fe20004800000ULL, 0x0c201f0035047f89ULL, 0x000e6200000e0000ULL,
0x0000002e0700720bULL, 0x004fc60003f1e000ULL, 0x0c201f0030057f89ULL, 0x000ea200000e0000ULL,
0x000000072e2e7208ULL, 0x000fc60004000000ULL, 0x0c201f0031327f89ULL, 0x000ee800000e0000ULL,
0x0c201f002e2f7f89ULL, 0x0002e400000e0000ULL, 0x000000043500720bULL, 0x002fe40003f1e000ULL,
0x000000053000720bULL, 0x004fe40003f3e000ULL, 0x0000003504047208ULL, 0x000fc40004000000ULL,
0x000000323100720bULL, 0x008fe40003f5e000ULL, 0x0000003005057208ULL, 0x000fe40004800000ULL,
0x0000003132067208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b04307820ULL, 0x000fe20000410000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000300ff7812ULL, 0x000fe4000780c0ffULL,
0x3fb8aa3b28287823ULL, 0x100fe20000010830ULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010830ULL,
0x3fb8aa3b25257823ULL, 0x100fe20000010830ULL, 0x3fb8aa3b27277823ULL, 0x100fe20000010830ULL,
0x0000002800347308ULL, 0x0007e20000000800ULL, 0x3fb8aa3b29297823ULL, 0x100fe20000010830ULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe20000010830ULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe20000010830ULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe20000010830ULL, 0x3fb8aa3b1f077823ULL, 0x100fe20000010830ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010830ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe20000010830ULL,
0x0000002600327308ULL, 0x0023e20000000800ULL, 0x3fb8aa3b1c287823ULL, 0x008fe20000010830ULL,
0x3fb8aa3b051c7820ULL, 0x000fe20000410000ULL, 0x0000002f2e00720bULL, 0x004fc60003f3e000ULL,
0x3fb8aa3b08087823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b09097823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b0a0a7823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b0b0b7823ULL, 0x000fe2000001081cULL,
0x0000002500317308ULL, 0x0004e20000000800ULL, 0x3fb8aa3b24267823ULL, 0x102fe20000010830ULL,
0x3fb8aa3b23247823ULL, 0x000fe20000010830ULL, 0x3fb8aa3b13137823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b14147823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b15157823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b16167823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b17357823ULL, 0x000fe2000001081cULL,
0x0000002700337308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b2d257823ULL, 0x004fce0000010830ULL,
0x00000008001f7308ULL, 0x0007e20000000800ULL, 0x3fb8aa3b22277823ULL, 0x002fce0000010830ULL,
0x0000000900227308ULL, 0x000e620000000800ULL, 0x000000313208723eULL, 0x008fe200000000ffULL,
0x3fb8aa3b11327823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b10317823ULL, 0x000fca000001081cULL,
0x0000000a00237308ULL, 0x0005f00000000800ULL, 0x0000000b00307308ULL, 0x000ee20000000800ULL,
0x0000001f2209723eULL, 0x002fe200000000ffULL, 0x3c003c00ff227424ULL, 0x000fe200078e00ffULL,
0x00000033340a723eULL, 0x004fe200000000ffULL, 0x3fb8aa3b121f7823ULL, 0x000fe2000001081cULL,
0x00000002ff347819ULL, 0x000fc60000011600ULL, 0x0000001400367308ULL, 0x000fe20000000800ULL,
0x0000000234337810ULL, 0x040fe20007ffe0ffULL, 0x0000000834377824ULL, 0x000fe200078e00ffULL,
0x00000023300b723eULL, 0x008fe200000000ffULL, 0x3c003c00ff237424ULL, 0x000fc800078e00ffULL,
0x00000015002d7308ULL, 0x000ff00000000800ULL, 0x00000016003e7308ULL, 0x0003f00000000800ULL,
0x0000001300137308ULL, 0x000ea20000000800ULL, 0x000000220814723cULL, 0x002f6e00000018ffULL,
0x0000002900297308ULL, 0x000ff00000000800ULL, 0x0000002a002a7308ULL, 0x000e620000000800ULL,
0x000000133611723eULL, 0x004fe200000000ffULL, 0x0000000834367824ULL, 0x000fe200078e00ffULL,
0x0000002d3e13723eULL, 0x000fe200000000ffULL, 0x00000008342d7824ULL, 0x000fc600078e00ffULL,
0xfffffff836337812ULL, 0x000fe200078ee233ULL, 0x0000002b002b7308ULL, 0x000ff00000000800ULL,
0x0000002c002c7308ULL, 0x000ea20000000800ULL, 0x000000292a10723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b19297823ULL, 0x000fcc000001081cULL, 0x0000001f00307308ULL, 0x0003e20000000800ULL,
0x0000002b2c12723eULL, 0x004fe200000000ffULL, 0x3fb8aa3b181f7823ULL, 0x102fe2000001081cULL,
0x3fb8aa3b1a2b7823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b1b1c7823ULL, 0x000fc8000001081cULL,
0x0000002500257308ULL, 0x000fe20000000800ULL, 0x00000001342c7810ULL, 0x040fe20007ffe0ffULL,
0x000000221018723cULL, 0x020b660000001814ULL, 0xfffffff82d2d7812ULL, 0x000fe400078ee22cULL,
0xffffffff342c7810ULL, 0x040fe20007ffe0ffULL, 0x0000002600267308ULL, 0x000e620000000800ULL,
0x0000000834167824ULL, 0x060fe200078e00ffULL, 0x0000000334147810ULL, 0x000fc40007ffe0ffULL,
0x0000000434157810ULL, 0x000fe40007ffe0ffULL, 0xfffffff837377812ULL, 0x000fe400078ee214ULL,
0x0000002400247308ULL, 0x000fe20000000800ULL, 0xfffffff816457812ULL, 0x000fce00078ee215ULL,
0x0000002700277308ULL, 0x000ea20000000800ULL, 0x000000252614723eULL, 0x002fe200000000ffULL,
0x0000000834257824ULL, 0x040fe200078e00ffULL, 0x0000000534267810ULL, 0x000fc80007ffe0ffULL,
0xfffffff825257812ULL, 0x000fe200078ee234ULL, 0x0000003500357308ULL, 0x000e700000000800ULL,
0x0000003100317308ULL, 0x000fe20000000800ULL, 0x000000242716723eULL, 0x004fe200000000ffULL,
0x0000000834277824ULL, 0x000fca00078e00ffULL, 0xfffffff827277812ULL, 0x000fe200078ee226ULL,
0x0000003200327308ULL, 0x000ea20000000800ULL, 0x000000353015723eULL, 0x002fe200000000ffULL,
0x0000000834307824ULL, 0x040fe200078e00ffULL, 0x0000000834357810ULL, 0x000fe40007ffe0ffULL,
0x0000900040267811ULL, 0x000fc600078e58ffULL, 0x0000000700077308ULL, 0x000fe40000000800ULL,
0x0000001025257824ULL, 0x100fe400078e0226ULL, 0x000000102d2d7824ULL, 0x100fe400078e0226ULL,
0x0000001033337824ULL, 0x000fe200078e0226ULL, 0x000000313217723eULL, 0x004fe200000000ffULL,
0x0000001e001e7308ULL, 0x000e620000000800ULL, 0x0000000834317824ULL, 0x000fe400078e00ffULL,
0x0000000835327824ULL, 0x000fc400078e00ffULL, 0x0000001037377824ULL, 0x000fe200078e0226ULL,
0x000000221418723cULL, 0x000f620000001818ULL, 0xfffffff831317812ULL, 0x000fe200078ee22cULL,
0x0000001d001d7308ULL, 0x000fe20000000800ULL, 0xfffffff832357812ULL, 0x000fe200078ee235ULL,
0x0000001045457824ULL, 0x100fe400078e0226ULL, 0x0000001027277824ULL, 0x100fe400078e0226ULL,
0x0000001031317824ULL, 0x100fe400078e0226ULL, 0x0000002800287308ULL, 0x000ea20000000800ULL,
0x0000001035357824ULL, 0x000fce00078e0226ULL, 0x0000001f001f7308ULL, 0x000ff00000000800ULL,
0x00000029002a7308ULL, 0x0006700000000800ULL, 0x0000002b002b7308ULL, 0x000fe20000000800ULL,
0x0000000634297810ULL, 0x008fc80007ffe0ffULL, 0xfffffff830297812ULL, 0x000fc600078ee229ULL,
0x0000001c00247308ULL, 0x0002e40000000800ULL, 0x0000001029297824ULL, 0x000fe200078e0226ULL,
0x000000071e1c723eULL, 0x002fe400000000ffULL, 0x0000001d281e723eULL, 0x004fe400000000ffULL,
0x0000001f2a1d723eULL, 0x000fe400000000ffULL, 0x0000002e2f077208ULL, 0x000fe40004800000ULL,
0x0000002b241f723eULL, 0x008fc400000000ffULL, 0x0000000c21247812ULL, 0x000fca00078ec0ffULL,
0x000000221c18723cULL, 0x020f620000001818ULL, 0x0000000125257824ULL, 0x000fe400078e0224ULL,
0x00000001242d7824ULL, 0x040fe400078e022dULL, 0x0000000124337824ULL, 0x040fe200078e0233ULL,
0x0000000825007388ULL, 0x0003e20000000800ULL, 0x0000000124377824ULL, 0x040fe400078e0237ULL,
0x0000000124457824ULL, 0x040fe200078e0245ULL, 0x0000000a2d007388ULL, 0x0003e20000000800ULL,
0x0000000124277824ULL, 0x000fc400078e0227ULL, 0x0000000124297824ULL, 0x040fe200078e0229ULL,
0x0000001033007388ULL, 0x0003e20000000800ULL, 0x0000000124317824ULL, 0x040fe400078e0231ULL,
0x0000000124247824ULL, 0x000fe200078e0235ULL, 0x0000001237007388ULL, 0x0003e80000000800ULL,
0x0000001445007388ULL, 0x0003e40000000800ULL, 0x000000ffff197224ULL, 0x020fc400078e001aULL,
0x0000001627007388ULL, 0x0003e80000000800ULL, 0x0000001c29007388ULL, 0x0003e80000000800ULL,
0x0000001e31007388ULL, 0x0003e80000000800ULL, 0x0000000924007388ULL, 0x0003e80000000800ULL,
0x0004000b2d007388ULL, 0x0003e80000000800ULL, 0x0004001133007388ULL, 0x0003e80000000800ULL,
0x0004001337007388ULL, 0x0003e80000000800ULL, 0x0004001545007388ULL, 0x0003e80000000800ULL,
0x0004001727007388ULL, 0x0003e80000000800ULL, 0x0004001d29007388ULL, 0x0003e80000000800ULL,
0x0004001f31007388ULL, 0x0003e80000000800ULL, 0x00f0000420008388ULL, 0x0003e80000000c00ULL,
0x00f2001820008388ULL, 0x0003e20000000a00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000003dff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000008003dff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000010003dff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000013f3f7810ULL, 0x000fe20007ffe0ffULL, 0x000018003dff7f8cULL, 0x0003e6000c80043fULL,
0x0000000e3f00720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffce6000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff107807ULL, 0x004fe40004000000ULL, 0x0000e3b000177802ULL, 0x000fc40000000f00ULL,
0x00000c8000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff107224ULL, 0x000fe200078e0016ULL,
0xffff3f4000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x000fe40004000000ULL,
0x0000e40000177802ULL, 0x000fc40000000f00ULL, 0x00000c3000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff157224ULL, 0x000fe200078e0016ULL, 0xffff3fb000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x004fe200078e0039ULL, 0x0000e45000387802ULL, 0x000fc40000000f00ULL,
0x00000b9000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e0017ULL,
0xffff407000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0039ULL,
0x0000e4a000387802ULL, 0x000fc40000000f00ULL, 0x00000b4000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0017ULL, 0xffff419000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0013ULL, 0x0000e50000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff107224ULL, 0x000fc400078e0014ULL, 0x00000ae000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e0017ULL, 0xffff45a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff107224ULL, 0x000fe200078e0008ULL, 0x0000e56000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff177224ULL, 0x000fc400078e0013ULL, 0x00000a8000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e0017ULL, 0xffff457000007947ULL, 0x000fea000383ffffULL,
0x00000001ff107807ULL, 0x008fe40004000000ULL, 0x0000e5b000177802ULL, 0x000fc40000000f00ULL,
0x00000a8000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff147224ULL, 0x000fe200078e0016ULL,
0xffff5e6000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x000fe40004000000ULL,
0x0000e60000177802ULL, 0x000fc40000000f00ULL, 0x00000a3000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff157224ULL, 0x000fe200078e0016ULL, 0xffff5eb000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0016ULL, 0x0000e65000387802ULL, 0x000fc40000000f00ULL,
0x0000099000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e0017ULL,
0xffff5f9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0016ULL,
0x0000e6a000387802ULL, 0x000fc40000000f00ULL, 0x0000094000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0017ULL, 0xffff60a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0012ULL, 0x0000e70000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff107224ULL, 0x000fc400078e0013ULL, 0x000008e000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e0017ULL, 0xffff64b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0012ULL, 0x0000e75000387802ULL, 0x000fc40000000f00ULL,
0x0000089000007944ULL, 0x00efea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e0017ULL,
0xffff649000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x004fe40004000000ULL,
0x0000e7a000177802ULL, 0x000fc40000000f00ULL, 0x0000089000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff147224ULL, 0x000fe200078e0016ULL, 0xffff7ad000007947ULL, 0x000fea000383ffffULL,
0x00000001ff107807ULL, 0x000fe40004000000ULL, 0x0000e7f000177802ULL, 0x000fc40000000f00ULL,
0x0000084000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff157224ULL, 0x000fe200078e0016ULL,
0xffff7b2000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0016ULL,
0x0000e84000387802ULL, 0x000fc40000000f00ULL, 0x000007a000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0017ULL, 0xffff7c0000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0016ULL, 0x0000e89000387802ULL, 0x000fc40000000f00ULL,
0x0000075000007944ULL, 0x01afea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e0017ULL,
0xffff7d1000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0012ULL,
0x0000e8f000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff107224ULL, 0x000fc400078e0013ULL,
0x000006f000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e0017ULL,
0xffff812000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0012ULL,
0x0000e94000387802ULL, 0x000fc40000000f00ULL, 0x000006a000007944ULL, 0x01efea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e0017ULL, 0xffff810000007947ULL, 0x000fea000383ffffULL,
0x00000001ff107807ULL, 0x008fe40004000000ULL, 0x0000e99000177802ULL, 0x000fc40000000f00ULL,
0x000006a000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff157224ULL, 0x000fe200078e0016ULL,
0xffff974000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x000fe40004000000ULL,
0x0000e9e000177802ULL, 0x000fc40000000f00ULL, 0x0000065000007944ULL, 0x000fea0003c00000ULL,
0xffff97a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0012ULL,
0x0000ea2000387802ULL, 0x000fc40000000f00ULL, 0x000005c000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0017ULL, 0xffff987000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0012ULL, 0x0000ea7000387802ULL, 0x000fc40000000f00ULL,
0x0000057000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e0017ULL,
0xffff998000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0012ULL,
0x0000ead000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff107224ULL, 0x000fc400078e0013ULL,
0x0000051000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e0017ULL,
0xffff9d8000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0012ULL,
0x0000eb2000387802ULL, 0x000fc40000000f00ULL, 0x000004c000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e0017ULL, 0xffff9d6000007947ULL, 0x000fea000383ffffULL,
0x00000002ff337424ULL, 0x000fe200078e00ffULL, 0x0000eb7000307802ULL, 0x000fc40000000f00ULL,
0x0000043000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e002fULL,
0xffffeae000007947ULL, 0x000fea000383ffffULL, 0x000000ffff327224ULL, 0x006fe200078e0034ULL,
0x0000ebd000307802ULL, 0x000fe20000000f00ULL, 0x00000002ff337424ULL, 0x000fc400078e00ffULL,
0x000003d000007944ULL, 0x010fea0003c00000ULL, 0x0000002f3400720bULL, 0x004fe20003f1e000ULL,
0x000000ffff327224ULL, 0x002fe200078e0006ULL, 0x0000ec3000307802ULL, 0x000fe20000000f00ULL,
0x00000002ff337424ULL, 0x000fe200078e00ffULL, 0x000000342f347208ULL, 0x000fc80004000000ULL,
0x0000037000007944ULL, 0x000fea0003c00000ULL, 0x0000002f0600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff327224ULL, 0x002fe200078e0007ULL, 0x0000ec9000307802ULL, 0x000fe20000000f00ULL,
0x00000002ff337424ULL, 0x000fe200078e00ffULL, 0x000000062f067208ULL, 0x000fc80004000000ULL,
0x0000031000007944ULL, 0x000fea0003c00000ULL, 0x0000002f0700720bULL, 0x004fe20003f1e000ULL,
0x000000ffff327224ULL, 0x002fe200078e0035ULL, 0x0000ecf000307802ULL, 0x000fe20000000f00ULL,
0x00000001ff337424ULL, 0x000fe200078e00ffULL, 0x000000072f2e7208ULL, 0x000fc80004000000ULL,
0x000002b000007944ULL, 0x000fea0003c00000ULL, 0x0000002f3500720bULL, 0x004fe20003f1e000ULL,
0x000000ffff327224ULL, 0x002fe200078e0034ULL, 0x0000ed5000307802ULL, 0x000fe20000000f00ULL,
0x00000001ff337424ULL, 0x000fe200078e00ffULL, 0x000000352f047208ULL, 0x000fc80004000000ULL,
0x0000025000007944ULL, 0x000fea0003c00000ULL, 0x0000002f3400720bULL, 0x004fe20003f1e000ULL,
0x000000ffff327224ULL, 0x002fe200078e0006ULL, 0x0000edb000307802ULL, 0x000fe20000000f00ULL,
0x00000001ff337424ULL, 0x000fe200078e00ffULL, 0x000000342f057208ULL, 0x000fc80004000000ULL,
0x000001f000007944ULL, 0x000fea0003c00000ULL, 0x0000002f0600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff327224ULL, 0x002fe200078e002eULL, 0x0000ee1000307802ULL, 0x000fe20000000f00ULL,
0x00000001ff337424ULL, 0x000fe200078e00ffULL, 0x000000062f067208ULL, 0x000fc80004000000ULL,
0x0000019000007944ULL, 0x000fea0003c00000ULL, 0xffffe9b000007947ULL, 0x000fea000383ffffULL,
0x0180000005007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000027812ULL, 0x000fc800078ec0ffULL, 0x018000000200780cULL, 0x000fda0003f05070ULL,
0x0000000500008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x040fe40003f25070ULL, 0x008000000200780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff05ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000005027812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000500007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e0006ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xffff106002007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff317424ULL, 0x000fe200078e00ffULL, 0x0000003700007348ULL, 0x000fe80003800000ULL,
0x0c000033322f7389ULL, 0x0002a200000e0036ULL, 0xffff102030007950ULL, 0x000fea0003c3ffffULL,
0x0000004400007348ULL, 0x000fe80003800000ULL, 0x0000001017177389ULL, 0x0002a200000e0047ULL,
0x00000000ff117424ULL, 0x000fc400078e00ffULL, 0x000000ffff107224ULL, 0x002fc800078e0038ULL,
0xffff0fd010007950ULL, 0x000fea0003c3ffffULL, 0x000000011000780cULL, 0x000fe20003f05070ULL,
0x0000004500007348ULL, 0x000fe80003800000ULL, 0x00000000ff117424ULL, 0x000fd000078e00ffULL,
0x0000000000107806ULL, 0x000fc800040e0100ULL, 0x0000004510167212ULL, 0x000fe200078ec0ffULL,
0x000000ffff107224ULL, 0x000fc800078e0017ULL, 0xffff0f6010007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000200000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005deULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000740ULL, 0x0000000000000288ULL, 0x0000001a00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009c8ULL, 0x0000000000000348ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000d10ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000dd0ULL, 0x0000000000000780ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001550ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001560ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000007bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000015f0ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000015f4ULL, 0x00000000000001b0ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001800ULL, 0x000000000000f180ULL, 0x6400001a00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x0000000100000089ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000010980ULL, 0x0000000000000044ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x00000000000109d0ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000010d50ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x00000000000015f0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000f390ULL, 0x000000000000f390ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000010980ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000010d50ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_pagedKV_128_nqpkv_8_m_8_sm_89_cubin_len = 69168;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
