/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_pagedKV_64_nqpkv_0_m_16_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000014a50ULL, 0x00000000000146d0ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45316a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6c61685f5f374944ULL, 0x6a4c45326a4c3266ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL,
0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x6a49636556334944ULL, 0x316a4c4545346a4cULL, 0x454536316a4c4536ULL,
0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x34366a4c4545346aULL,
0x61324545346a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL, 0x614d6e4974736e49ULL,
0x6a4c45326a4c4974ULL, 0x4c45316a4c454532ULL, 0x497461324545316aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL, 0x316a4c45326a4c45ULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL,
0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL,
0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL,
0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL, 0x61324545316a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL,
0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL,
0x45326a4c45326a4cULL, 0x316a4c45326a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL,
0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL,
0x4963655633494432ULL, 0x6a4c4545346a4c6aULL, 0x4545386a4c453631ULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x6e695f5f2400676eULL,
0x305f6c616e726574ULL, 0x616475635f5f245fULL, 0x63725f30326d735fULL, 0x7a74665f6e725f70ULL,
0x6f6c735f3233665fULL, 0x5f24006874617077ULL, 0x616e7265746e695fULL, 0x635f5f245f315f6cULL,
0x30376d735f616475ULL, 0x6e79736c6668735fULL, 0x705f796c66625f63ULL, 0x65746e695f5f2400ULL,
0x245f325f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL, 0x7864695f636e7973ULL,
0x6e695f5f2400705fULL, 0x335f6c616e726574ULL, 0x616475635f5f245fULL, 0x6f765f30376d735fULL,
0x625f636e79736574ULL, 0x722e00746f6c6c61ULL, 0x747865742e616c65ULL, 0x5f6c656e72656b2eULL,
0x6c65722e0061686dULL, 0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x6c656e72656b2400ULL,
0x656d732461686d5fULL, 0x667542657479426dULL, 0x6e6f632e766e2e00ULL, 0x6b2e30746e617473ULL,
0x686d5f6c656e7265ULL, 0x6d617261705f0061ULL, 0x5f67756265642e00ULL, 0x722e00656d617266ULL,
0x67756265642e6c65ULL, 0x2e00656d6172665fULL, 0x6265642e616c6572ULL, 0x656d6172665f6775ULL,
0x6c65722e766e2e00ULL, 0x006e6f697463612eULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000100000096ULL,
0x0000000000000014ULL, 0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00090001000000b1ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0001000000baULL, 0x0000000000000038ULL, 0x0000000000000010ULL, 0x000c0001000000f8ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000131ULL, 0x0000000000000030ULL,
0x0000000000000004ULL, 0x000c000100000178ULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000c0001000001baULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c000100000200ULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000c000100000247ULL, 0x0000000000000034ULL,
0x0000000000000004ULL, 0x000c00010000028dULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c0001000002dbULL, 0x0000000000000020ULL, 0x0000000000000004ULL, 0x000c000100000329ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c000100000377ULL, 0x000000000000002cULL,
0x0000000000000004ULL, 0x000c0001000003c5ULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000c00010000040bULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000459ULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b00220000049fULL, 0x0000000000012ae0ULL,
0x0000000000000190ULL, 0x000b0022000004d2ULL, 0x0000000000012c70ULL, 0x0000000000000040ULL,
0x000b0022000004fdULL, 0x0000000000012cb0ULL, 0x0000000000000070ULL, 0x000b002200000527ULL,
0x0000000000012d20ULL, 0x0000000000000160ULL, 0x000a000300000595ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00040003000005b5ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00070003000005e5ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL,
0x0000000000000000ULL, 0x0000000000012e80ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00012ae000000000ULL,
0x0000040400000000ULL, 0x810c000001640400ULL, 0x0049480400288080ULL, 0x0000000000000000ULL,
0x00000054ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x9308288080920828ULL, 0x288080a108288080ULL,
0x8280162880808508ULL, 0x0000000003102880ULL, 0x8080859200000000ULL, 0x0000000000220028ULL,
0x00000034ffffffffULL, 0x0000007000000000ULL, 0x00012ae000000000ULL, 0x0000019000000000ULL,
0x0000580400000000ULL, 0x8084288080820900ULL, 0x0900000004042880ULL, 0x2880808228808085ULL,
0x00000054ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x9208288080850828ULL, 0x2880809308288080ULL,
0x808c08288080a108ULL, 0x1028808280162880ULL, 0x0000000000000003ULL, 0x22002880808c9200ULL,
0x0000001cffffffffULL, 0x0000011000000000ULL, 0x00012c7000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x00000054ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL, 0x9208288080850828ULL,
0x288080a108288080ULL, 0x8280162880809308ULL, 0x0000000003102880ULL, 0x8080939200000000ULL,
0x0000000000220028ULL, 0x0000002cffffffffULL, 0x0000019800000000ULL, 0x00012cb000000000ULL,
0x0000007000000000ULL, 0x0000140400000000ULL, 0x8092288080930900ULL, 0x0000000000002880ULL,
0x00000054ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x9308288080850828ULL, 0x288080a108288080ULL,
0x8280162880809208ULL, 0x0000000003102880ULL, 0x8080929200000000ULL, 0x0000000000220028ULL,
0x0000001cffffffffULL, 0x0000023000000000ULL, 0x00012d2000000000ULL, 0x0000016000000000ULL,
0x0000000000000000ULL, 0x0000001b00082f04ULL, 0x0008230400000080ULL, 0x0000000000000017ULL,
0x0000001700081204ULL, 0x0008110400000000ULL, 0x0000000000000017ULL, 0x0000001600082304ULL,
0x0008120400000000ULL, 0x0000000000000016ULL, 0x0000001600081104ULL, 0x0008230400000000ULL,
0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL, 0x0000000000000015ULL,
0x0000001400082304ULL, 0x0008120400000000ULL, 0x0000000000000014ULL, 0x0000001400081104ULL,
0x0008230400000000ULL, 0x000000000000001bULL, 0x0000001b00081204ULL, 0x0008110400000000ULL,
0x000000000000001bULL, 0x0000007b00043704ULL, 0x0000001800080a04ULL, 0x0060190300600160ULL,
0x00000000000c1704ULL, 0x0021f00000580009ULL, 0x00000000000c1704ULL, 0x0021f00000500008ULL,
0x00000000000c1704ULL, 0x0011f00000480007ULL, 0x00000000000c1704ULL, 0x0081f00000280006ULL,
0x00000000000c1704ULL, 0x0021f00000200005ULL, 0x00000000000c1704ULL, 0x0021f00000180004ULL,
0x00000000000c1704ULL, 0x0021f00000100003ULL, 0x00000000000c1704ULL, 0x0011f00000080002ULL,
0x00000000000c1704ULL, 0x0011f00000040001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL,
0x0004310400801b03ULL, 0x0134290400000900ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x01342804ffffffffULL, 0x0000048000000450ULL, 0x0000263000000580ULL, 0x000027d0000026b0ULL,
0x00002dc000002930ULL, 0x00002e4000002df0ULL, 0x00004e1000002e90ULL, 0x00004fd000004ea0ULL,
0x000055c000005130ULL, 0x00005640000055f0ULL, 0x000073e000005690ULL, 0x000075b000007480ULL,
0x00007ba000007710ULL, 0x00007c2000007bd0ULL, 0x00009a1000007c70ULL, 0x00009be000009ab0ULL,
0x0000a1d000009d40ULL, 0x0000a2500000a200ULL, 0x0000b4b00000a2a0ULL, 0x000113e00000b4c0ULL,
0x0001143000011420ULL, 0x0001145000011440ULL, 0x000114d0000114b0ULL, 0x00012120000114f0ULL,
0x000121b000012160ULL, 0x00012240000121f0ULL, 0x000122e000012290ULL, 0x0001237000012320ULL,
0x00012400000123b0ULL, 0x000124a000012450ULL, 0x00012530000124e0ULL, 0x000125c000012570ULL,
0x0001266000012610ULL, 0x000126f0000126a0ULL, 0x0001278000012730ULL, 0x00012820000127d0ULL,
0x000128e000012880ULL, 0x000129a000012940ULL, 0x00012a6000012a00ULL, 0x0440390400012ac0ULL,
0x000000ff000003e0ULL, 0x003f01000000f600ULL, 0x0000000b000004b0ULL, 0x003f01200000f608ULL,
0x0000000b000004d0ULL, 0x003f01200000f688ULL, 0x0000000b000004f0ULL, 0x003f01200000f6a8ULL,
0x0000000b00000540ULL, 0x003f01200000f6c8ULL, 0x000000ff00000920ULL, 0x003f01070000f600ULL,
0x0000000500000b10ULL, 0x003f010200000004ULL, 0x0000000500000bd0ULL, 0x003f010100000000ULL,
0x00000003000013e0ULL, 0x003f01070000f6a8ULL, 0x0000000300001530ULL, 0x003f01010000f6a8ULL,
0x0000000600001590ULL, 0x003f01010000f6c8ULL, 0x0000000c00001730ULL, 0x003f01050000f6ccULL,
0x0000000c00001910ULL, 0x003f01050000f6ccULL, 0x0000001000002230ULL, 0x003f01070000f6b0ULL,
0x00000010000022e0ULL, 0x003f01010000f6b0ULL, 0x0000000800002340ULL, 0x003f01010000f608ULL,
0x0000000800002360ULL, 0x003f01050000f60cULL, 0x0000000800002530ULL, 0x003f01050000f60cULL,
0x0000003400002b20ULL, 0x003f01050000f6acULL, 0x0000003400002cf0ULL, 0x003f01050000f6acULL,
0x0000000c00003fa0ULL, 0x003f010100000000ULL, 0x0000006900004000ULL, 0x003f01010000f688ULL,
0x0000000400004020ULL, 0x003f010500000004ULL, 0x00000004000041f0ULL, 0x003f010500000004ULL,
0x0000000e00004a20ULL, 0x003f01070000f6a8ULL, 0x0000000e00004af0ULL, 0x003f01010000f6a8ULL,
0x0000000800004b50ULL, 0x003f01010000f628ULL, 0x0000000800004b70ULL, 0x003f01050000f62cULL,
0x0000000800004d40ULL, 0x003f01050000f62cULL, 0x0000003400005320ULL, 0x003f01050000f6b4ULL,
0x00000034000054f0ULL, 0x003f01050000f6b4ULL, 0x0000000c00006570ULL, 0x003f010100000000ULL,
0x00000034000065d0ULL, 0x003f01010000f690ULL, 0x00000004000065f0ULL, 0x003f010500000004ULL,
0x00000004000067c0ULL, 0x003f010500000004ULL, 0x0000001000006ff0ULL, 0x003f01070000f6b0ULL,
0x00000010000070c0ULL, 0x003f01010000f6b0ULL, 0x0000000800007120ULL, 0x003f01010000f648ULL,
0x0000000800007140ULL, 0x003f01050000f64cULL, 0x0000000800007310ULL, 0x003f01050000f64cULL,
0x0000003400007900ULL, 0x003f01050000f6acULL, 0x0000003400007ad0ULL, 0x003f01050000f6acULL,
0x0000000e00008b40ULL, 0x003f010100000000ULL, 0x0000000900008ba0ULL, 0x003f01010000f698ULL,
0x0000000400008bc0ULL, 0x003f010500000004ULL, 0x0000000400008d90ULL, 0x003f010500000004ULL,
0x0000000900009680ULL, 0x003f01070000f6a8ULL, 0x0000000900009710ULL, 0x003f01010000f6a8ULL,
0x0000000300009770ULL, 0x003f01010000f668ULL, 0x0000000300009790ULL, 0x003f01050000f66cULL,
0x0000000300009960ULL, 0x003f01050000f66cULL, 0x0000003000009f30ULL, 0x003f01050000f6b4ULL,
0x000000300000a100ULL, 0x003f01050000f6b4ULL, 0x000000040000b280ULL, 0x003f010100000000ULL,
0x0000000c0000b300ULL, 0x003f010100000000ULL, 0x000000ff0000c440ULL, 0x003f01010000f600ULL,
0x000000ff0000d040ULL, 0x003f01050000f604ULL, 0x000000ff0000d210ULL, 0x003f01050000f604ULL,
0x000000ff0000d440ULL, 0x003f01010000f600ULL, 0x000000ff0000d470ULL, 0x003f01050000f604ULL,
0x000000ff0000d630ULL, 0x003f01050000f604ULL, 0x000000760000f8e0ULL, 0x003f010100000000ULL,
0x000000760000f9d0ULL, 0x003f010500000004ULL, 0x000000760000fba0ULL, 0x003f010500000004ULL,
0x0000007900011f80ULL, 0x003f010100000000ULL, 0x0000007900011fe0ULL, 0x003f010100000008ULL,
0x0000007900012040ULL, 0x003f010100000010ULL, 0x00000079000120b0ULL, 0x003f010100000018ULL,
0x00201c0400053803ULL, 0x0000bd600000bd30ULL, 0x0000c0d00000bf70ULL, 0x0000c3600000c260ULL,
0x000120f00000d690ULL, 0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL,
0x0000000000000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x00000000000002a4ULL,
0x0000001b00000002ULL, 0x000000000000020cULL, 0x0000001b00000002ULL, 0x0000000000000184ULL,
0x0000001b00000002ULL, 0x00000000000000e4ULL, 0x0000001b00000002ULL, 0x0000000000000044ULL,
0x0000001b00000002ULL, 0x000000000000027cULL, 0x0000001b00000002ULL, 0x00000000000001e4ULL,
0x0000001b00000002ULL, 0x0000000000000161ULL, 0x0000001b00000002ULL, 0x00000000000000bcULL,
0x0000001b00000002ULL, 0x000000000000f700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000590000007b06ULL, 0x000e620000209000ULL,
0x00005900ff727624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f45070ULL,
0x00000000007c7919ULL, 0x000ea20000002600ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x00005a0000057ab9ULL, 0x000fe20000000800ULL, 0x00000000000a7919ULL, 0x000ee20000002300ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x00005a00720c7a19ULL, 0x000fe200000006ffULL,
0x0000460000087ab9ULL, 0x000fe20000000a00ULL, 0x0000000000097919ULL, 0x000f280000002100ULL,
0x0000000000737919ULL, 0x000ea20000002700ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL, 0x0000000200037305ULL, 0x0002a4000021f000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x000000ffff057224ULL, 0x004fc800078e0a03ULL,
0x0000590005057a24ULL, 0x000fc800078e02ffULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x0000040003077a27ULL, 0x000fc800078e00ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a07ULL,
0x0000040003007624ULL, 0x000fca00078e0272ULL, 0x0000590000007a0cULL, 0x000fda0003f06070ULL,
0x8000590000000a10ULL, 0x000fe40007ffe0ffULL, 0x0000000107070810ULL, 0x000fe40007ffe0ffULL,
0x0000590000007a0cULL, 0x000fda0003f26070ULL, 0x0000000107071810ULL, 0x000fe40007ffe0ffULL,
0x00005900ff07aa12ULL, 0x000fc800078e33ffULL, 0x0000000700007306ULL, 0x000e620000209000ULL,
0x000000ff0700720cULL, 0x000fce0003fa5070ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL, 0x0000000200037305ULL, 0x0002a4000021f000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x0000000307047224ULL, 0x004fc800078e02ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a04ULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x0000007c037a7227ULL, 0x000fe400078e00ffULL, 0x0000000000037919ULL, 0x000ee40000002200ULL,
0x000000ffff007224ULL, 0x000fc800078e0a7aULL, 0x0000000007007224ULL, 0x000fca00078e027cULL,
0x000000070000720cULL, 0x000fda0003f66070ULL, 0x0000000100003824ULL, 0x000fe200078e0a07ULL,
0x000000017a7a3810ULL, 0x000fe20007ffe0ffULL, 0x000001000a027a24ULL, 0x008fc600078e0203ULL,
0x000000070000720cULL, 0x000fe20003f86070ULL, 0x00000000020b7a24ULL, 0x010fca00078e0209ULL,
0x000000ff0b00720cULL, 0x040fe40003f45270ULL, 0x0000007f0b00780cULL, 0x040fe40003f04070ULL,
0x0000000f0b00780cULL, 0x040fe40003f24070ULL, 0x000000030b00780cULL, 0x000fe40003f64070ULL,
0x000000017a7a4810ULL, 0x000fe40007ffe0ffULL, 0x00000007ff7ad212ULL, 0x000fc400078e33ffULL,
0x000000010b00780cULL, 0x000fe20003f84070ULL, 0x3fffff80ff02a424ULL, 0x000fe200078e00ffULL,
0x00005a007a0d7a19ULL, 0x000fe200000006ffULL, 0x000000ffff007224ULL, 0x000fe400078e0a7aULL,
0x7fffff80ff03a424ULL, 0x000fe400078e00ffULL, 0x00000000077c7224ULL, 0x000fe200078e027cULL,
0x00000005ff007819ULL, 0x000fe20000011609ULL, 0xff317217ff088424ULL, 0x000fe200078e00ffULL,
0x00f60002ff00a388ULL, 0x0003e20000000a00ULL, 0x000000107c717824ULL, 0x000fc400078e00ffULL,
0x3fffffc0ff049424ULL, 0x000fe200078e00ffULL, 0x00f400080b008388ULL, 0x0005e20000004800ULL,
0x7fffffc0ff059424ULL, 0x000fe200078e00ffULL, 0x0000000471007c0cULL, 0x040fe2000bf03070ULL,
0x3fffff60ff06b424ULL, 0x000fe200078e00ffULL, 0x00001fff0a097589ULL, 0x000fe200000e0000ULL,
0x7fffff60ff07b424ULL, 0x000fe400078e00ffULL, 0x3fffff80ff02b424ULL, 0x002fe200078e00ffULL,
0x00001fff00007589ULL, 0x000e6200000e0000ULL, 0x7fffff80ff03b424ULL, 0x000fe200078e00ffULL,
0x0000000471087c10ULL, 0x004fc4000fffe1ffULL, 0x00f608040b009388ULL, 0x0005e40000008a00ULL,
0x0000001008087817ULL, 0x000fe40003800000ULL, 0x00f688060b00b388ULL, 0x0007e40000008a00ULL,
0x000000ff087b7207ULL, 0x000fe40000000000ULL, 0x00f6a8020b00b388ULL, 0x0003e40000008a00ULL,
0x000000107b00780cULL, 0x000fe20003f05270ULL, 0x3fffffc0ff04c424ULL, 0x004fc400078e00ffULL,
0x7fffffc0ff05c424ULL, 0x000fe400078e00ffULL, 0x0000580073067a24ULL, 0x008fc600078e02ffULL,
0x00f6c8040b00c388ULL, 0x000fe20000008a00ULL, 0x0000000409027824ULL, 0x002fe400078e0200ULL,
0x0000000c06067224ULL, 0x000fe400078e020dULL, 0x0000000202027824ULL, 0x000fe200078e00ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000001d000008947ULL, 0x000fea0003800000ULL,
0x0000000000497919ULL, 0x000e620000000000ULL, 0xffffffff00047882ULL, 0x000fc40000000000ULL,
0x00005a0000057ab9ULL, 0x000fe40000000800ULL, 0x0000000504047299ULL, 0x000fe2000800063fULL,
0x00000004ff077819ULL, 0x002fca0000011649ULL, 0x0000000102087824ULL, 0x000fc800078e0207ULL,
0x0000000171037824ULL, 0x000fca00078e0208ULL, 0x0000000403057c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff037a19ULL, 0x000fc60000011603ULL, 0x0000000106067824ULL, 0x000fe200078e0205ULL,
0x000000027b057217ULL, 0x000fc60007800000ULL, 0x0000000c03047224ULL, 0x000fe400078e0206ULL,
0x0000001049037824ULL, 0x000fe400078e00ffULL, 0x0000000105027824ULL, 0x000fe400078e0a02ULL,
0x0000010004047825ULL, 0x000fe200078e00ffULL, 0x000000f0030b7812ULL, 0x000fe400078ec0ffULL,
0x000000020700720cULL, 0x000fe20003f06070ULL, 0x0000000108027824ULL, 0x000fe200078e0249ULL,
0x0000000b040b7212ULL, 0x000fe200078efcffULL, 0x0000001008077824ULL, 0x000fc600078e00ffULL,
0x00005e000b047a10ULL, 0x000fe40007f3e0ffULL, 0xfffffff007027812ULL, 0x000fe400078ee202ULL,
0x00005f0005057a10ULL, 0x000fc60000ffe4ffULL, 0x0000001002077824ULL, 0x000fca00078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004077faeULL, 0x0003e2000c101c48ULL,
0x0000018000007947ULL, 0x000fea0003800000ULL, 0x0000000000497919ULL, 0x000e620000000000ULL,
0xffffffff00047882ULL, 0x000fe40000000000ULL, 0x00005a0000057ab9ULL, 0x000fe40000000800ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x0000000249027211ULL, 0x002fca00078fe0ffULL,
0x0000000171037824ULL, 0x000fca00078e0202ULL, 0x0000000403057c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff037a19ULL, 0x000fc60000011603ULL, 0x0000000106067824ULL, 0x000fc800078e0205ULL,
0x0000000c03047224ULL, 0x000fe400078e0206ULL, 0x0000001049037824ULL, 0x000fe400078e00ffULL,
0x0000010004047825ULL, 0x000fc600078e00ffULL, 0x000000f003077812ULL, 0x000fe200078ec0ffULL,
0x0000000102067824ULL, 0x000fc600078e0249ULL, 0x0000000704047212ULL, 0x000fe200078efcffULL,
0x0000001002077824ULL, 0x000fc600078e00ffULL, 0x00005e0004047a10ULL, 0x000fe40007f1e0ffULL,
0xfffffff007067812ULL, 0x000fe400078ee206ULL, 0x00005f0005057a10ULL, 0x000fc600007fe4ffULL,
0x0000001006077824ULL, 0x000fca00078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004077faeULL, 0x0003e4000b901c48ULL, 0x0000000000057919ULL, 0x002e620000000000ULL,
0x0000000000027806ULL, 0x000fe200038e0000ULL, 0x00000004ff087424ULL, 0x000fe400078e00ffULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000200047300ULL, 0x000e7000000e0000ULL,
0x0000000200067309ULL, 0x000ea20000000000ULL, 0x000000050400720cULL, 0x002fe20003f02070ULL,
0x0000660073047625ULL, 0x000fc800078e0008ULL, 0x000000ffff067224ULL, 0x004fd000078e0a06ULL,
0x00f60406ffff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000008046c7981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0900720cULL, 0x000fe40003f05270ULL, 0x0000003f6c6d7810ULL, 0x044fe40007ffe0ffULL,
0x000000ff6c0c7810ULL, 0x000fc40007ffe0ffULL, 0x00000006ff6d7819ULL, 0x000fe4000001166dULL,
0x00000008ff6e7819ULL, 0x000fca000001160cULL, 0x0000b91000008947ULL, 0x000fea0003800000ULL,
0x00000002ff767819ULL, 0x000fe20000011600ULL, 0x00000003ff0a7424ULL, 0x000fe200078e00ffULL,
0x0000f68800057811ULL, 0x000fe400078e18ffULL, 0x03ffffff76027812ULL, 0x000fc800078ec0ffULL,
0x0000006d0200720cULL, 0x000fda0003f06070ULL, 0x0000000273048824ULL, 0x000fe400078e00ffULL,
0x00006800ff078624ULL, 0x000fc800078e00ffULL, 0x0000680004078624ULL, 0x000fe400078e0207ULL,
0xffffffffff047424ULL, 0x000fe400078e00ffULL, 0x0000000102078824ULL, 0x000fe200078e0207ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000040a05ff738cULL, 0x0005e20000000000ULL,
0x0000640007068625ULL, 0x002fe200078e0008ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000806048981ULL, 0x000ee2000c1e1900ULL, 0x000001ff0c00780cULL, 0x000fe20003f04070ULL,
0x000000407a6f7824ULL, 0x000fe200078e00ffULL, 0x00000001ff627819ULL, 0x000fe20000011600ULL,
0x00000080ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000000005ff7f8cULL, 0x0003e6000c80043fULL,
0x00000020627d7824ULL, 0x000fca00078e00ffULL, 0x000000206f097812ULL, 0x000fe200078ef87dULL,
0x0000590004047a24ULL, 0x008fc800078e02ffULL, 0x00000040040a7824ULL, 0x004fe200078e00ffULL,
0x0000000100047812ULL, 0x000fc600078ec0ffULL, 0x000062000a067625ULL, 0x000fe200078e000bULL,
0x000003e000000947ULL, 0x000fea0003800000ULL, 0x0000007d6c0a7217ULL, 0x002fe20007800000ULL,
0x0000001004057824ULL, 0x000fe200078e00ffULL, 0x00000003ff0b7819ULL, 0x000fc60000011649ULL,
0x000000010a0a7824ULL, 0x000fe200078e0a7dULL, 0x000000040b0e7810ULL, 0x000fe20007ffe0ffULL,
0x00000001050c7824ULL, 0x000fe200078e020bULL, 0x0000000c0b0f7810ULL, 0x000fe40007ffe0ffULL,
0x000000050a0a7217ULL, 0x000fe20007800000ULL, 0x000000010c0d7824ULL, 0x040fe400078e0249ULL,
0x000000080c127824ULL, 0x000fe400078e00ffULL, 0x000000010a0a7824ULL, 0x000fc400078e0a05ULL,
0x0000000105147824ULL, 0x000fe200078e020fULL, 0xfffffff812127812ULL, 0x000fe400078ee20dULL,
0x000000080b0d7810ULL, 0x040fe40007ffe0ffULL, 0x0000000a0b00720cULL, 0x080fe20003f66070ULL,
0x00000001090b7824ULL, 0x000fe200078e020cULL, 0x0000000a0e00720cULL, 0x080fe20003f46070ULL,
0x00000001050e7824ULL, 0x000fe200078e020eULL, 0x0000000a0d00720cULL, 0x080fe20003f26070ULL,
0x0000000105107824ULL, 0x000fe200078e020dULL, 0x0000000a0f00720cULL, 0x000fe20003f06070ULL,
0x000000800b0a7825ULL, 0x000fc800078e00ffULL, 0x00000001090c7824ULL, 0x040fe200078e020eULL,
0x000000700a117812ULL, 0x000fe200078ef803ULL, 0x000000010e057824ULL, 0x140fe400078e0249ULL,
0x000000080e167824ULL, 0x000fe400078e00ffULL, 0x00000001090d7824ULL, 0x040fe400078e0210ULL,
0x00000001090e7824ULL, 0x000fe400078e0214ULL, 0x0000000110097824ULL, 0x000fc400078e0249ULL,
0x0000000810187824ULL, 0x000fe200078e00ffULL, 0x0000001106107210ULL, 0x000fe20007f9e0ffULL,
0x00000001140a7824ULL, 0x040fe400078e0249ULL, 0x00000008140f7824ULL, 0x000fe200078e00ffULL,
0xfffffff816147812ULL, 0x000fe200078ee205ULL, 0x0000000107117824ULL, 0x000fe200020e060bULL,
0xfffffff818167812ULL, 0x000fe400078ee209ULL, 0xfffffff80f187812ULL, 0x000fe200078ee20aULL,
0x000000800c0a7825ULL, 0x000fe200078e00ffULL, 0x0000b00062057811ULL, 0x000fc600078e68ffULL,
0x000000800d0c7825ULL, 0x000fe200078e00ffULL, 0x000000700a197812ULL, 0x000fc600078ef803ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000700c177812ULL, 0x000fe400078ef803ULL,
0x00000019060a7210ULL, 0x000fe20007f9e0ffULL, 0x0000001012097824ULL, 0x000fe200078e0205ULL,
0x000000700e157812ULL, 0x000fe200078ef803ULL, 0x0000001014137824ULL, 0x000fe200078e0205ULL,
0x00000017060c7210ULL, 0x040fe20007fbe0ffULL, 0x00000001070b7824ULL, 0x040fe200020e060bULL,
0x0000001506067210ULL, 0x000fe20007fde0ffULL, 0x0000001016037824ULL, 0x000fe200078e0205ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010097faeULL, 0x0003e2000d901c48ULL,
0x00000001070d7824ULL, 0x000fc400028e060dULL, 0x0000001018057824ULL, 0x000fe200078e0205ULL,
0x000000000a137faeULL, 0x0003e2000d101c48ULL, 0x0000000107077824ULL, 0x000fc600030e060fULL,
0x000000000c037faeULL, 0x0003e8000c901c48ULL, 0x0000000006057faeULL, 0x0003e2000c101c48ULL,
0x0000031000007947ULL, 0x000fea0003800000ULL, 0x00000010040a7824ULL, 0x002fe200078e00ffULL,
0x0000b00062167811ULL, 0x000fc800078e68ffULL, 0x0000000a490a7211ULL, 0x000fc800078fe8ffULL,
0x000000040a0c7810ULL, 0x040fe20007ffe0ffULL, 0x00000001090b7824ULL, 0x000fe200078e020aULL,
0x000000080a107810ULL, 0x040fe20007ffe0ffULL, 0x000000010a057824ULL, 0x040fe200078e0249ULL,
0x0000000c0a127810ULL, 0x040fe20007ffe0ffULL, 0x000000080a0e7824ULL, 0x000fe400078e00ffULL,
0x000000800b0a7825ULL, 0x000fc600078e00ffULL, 0xfffffff80e057812ULL, 0x000fe200078ee205ULL,
0x00000001090d7824ULL, 0x040fe200078e020cULL, 0x000000700a117812ULL, 0x000fe200078ef803ULL,
0x000000010c0e7824ULL, 0x140fe400078e0249ULL, 0x000000080c157824ULL, 0x000fe400078e00ffULL,
0x00000001090c7824ULL, 0x000fe400078e0210ULL, 0x00000001100f7824ULL, 0x140fe400078e0249ULL,
0x0000000810147824ULL, 0x000fe200078e00ffULL, 0x0000001106107210ULL, 0x000fe20007f1e0ffULL,
0x00000001120a7824ULL, 0x000fc400078e0249ULL, 0x0000000812177824ULL, 0x000fe400078e00ffULL,
0x0000000109137824ULL, 0x000fe200078e0212ULL, 0xfffffff814127812ULL, 0x000fe200078ee20fULL,
0x0000000107117824ULL, 0x000fe200000e060bULL, 0xfffffff817147812ULL, 0x000fe200078ee20aULL,
0x000000800d0a7825ULL, 0x000fe200078e00ffULL, 0xfffffff815097812ULL, 0x000fc600078ee20eULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x000000700a177812ULL, 0x000fc600078ef803ULL,
0x00000080130e7825ULL, 0x000fe200078e00ffULL, 0x000000700c157812ULL, 0x100fe400078ef803ULL,
0x00000017060a7210ULL, 0x000fe20007f1e0ffULL, 0x0000001005057824ULL, 0x100fe200078e0216ULL,
0x000000700e137812ULL, 0x000fe200078ef803ULL, 0x0000001009097824ULL, 0x100fe200078e0216ULL,
0x00000015060c7210ULL, 0x040fe20007f3e0ffULL, 0x00000001070b7824ULL, 0x040fe200000e060bULL,
0x0000001306067210ULL, 0x000fe20007f5e0ffULL, 0x0000001012037824ULL, 0x000fe200078e0216ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010057faeULL, 0x0003e2000b901c48ULL,
0x00000001070d7824ULL, 0x000fc400008e060dULL, 0x0000001014137824ULL, 0x000fe200078e0216ULL,
0x000000000a097faeULL, 0x0003e2000b901c48ULL, 0x0000000107077824ULL, 0x000fc600010e060fULL,
0x000000000c037faeULL, 0x0003e8000b901c48ULL, 0x0000000006137faeULL, 0x0003e4000b901c48ULL,
0x0000000102027810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff0b7424ULL, 0x002fc600078e00ffULL,
0x0000006d0200720cULL, 0x000fda0003f06070ULL, 0x0000000273038824ULL, 0x000fe400078e00ffULL,
0x00006800ff068624ULL, 0x000fc800078e00ffULL, 0x0000680003038624ULL, 0x000fc800078e0206ULL,
0x0000000103098824ULL, 0x000fe400078e0202ULL, 0x0000001062037824ULL, 0x000fe400078e00ffULL,
0x0000640009088625ULL, 0x000fe400078e0008ULL, 0x00000000030473c2ULL, 0x000e6200000e0000ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000008080b8981ULL, 0x000522000c1e1900ULL,
0x000000ff6e00720cULL, 0x000fe20003f05270ULL, 0x0000000862067824ULL, 0x000fe200078e00ffULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x000000ffff317224ULL, 0x000fe200078e00ffULL, 0x0000f6a804047890ULL, 0x002fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x004fec0000008000ULL, 0x00f6a800030c7f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6c80006067f8cULL, 0x000ee2000c80043fULL,
0x000000ffff307224ULL, 0x000fe200078e00ffULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00009d0000008947ULL, 0x000fea0003800000ULL,
0x0000001003037812ULL, 0x002fe200078ec0ffULL, 0x0000000273707824ULL, 0x000fc400078e00ffULL,
0x00006800ff057624ULL, 0x000fe400078e00ffULL, 0x0000002076037824ULL, 0x000fe400078e0203ULL,
0x000000ffff087224ULL, 0x008fe400078e0007ULL, 0x0000680070707624ULL, 0x000fe400078e0205ULL,
0x0000000804037824ULL, 0x000fe400078e0203ULL, 0xff317217ff097424ULL, 0x000fc400078e00ffULL,
0x000000ffff487224ULL, 0x000fe400078e00ffULL, 0x000000ffff277224ULL, 0x000fc400078e00ffULL,
0x000000ffff757224ULL, 0x00afca00078e0002ULL, 0x00000000000e7805ULL, 0x000fc40000015200ULL,
0x0000000400047824ULL, 0x000fca00078e00ffULL, 0xfffffff8040c7812ULL, 0x004fc800078ec0ffULL,
0x0000f6c80c047810ULL, 0x000fe20007ffe0ffULL, 0x00f6cc000c117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fe40007804808ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff127224ULL, 0x000fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000101200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000107805ULL, 0x000fcc0000015200ULL, 0x000000100e137210ULL, 0x000fca0007f1e1ffULL,
0x0000000111117824ULL, 0x000fe200000e0e0fULL, 0x003d09001300780cULL, 0x000fc80003f06070ULL,
0x000000ff1100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401300780cULL, 0x000fc80003f06070ULL, 0x000000ff1100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff107819ULL, 0x000fc80000011411ULL,
0x0000001310107211ULL, 0x000fca00078110ffULL, 0x000000ffff117224ULL, 0x000fca00000e0611ULL,
0x0000000210107819ULL, 0x000fc80000001211ULL, 0x000000100000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000112127810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00f6cc000c117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fe40007804808ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001000087824ULL, 0x000fe200078e00ffULL,
0x0000000148117810ULL, 0x000fe20007ffe0ffULL, 0x000059000b0b7a24ULL, 0x010fe400078e02ffULL,
0x00000080ff0e7424ULL, 0x000fe200078e00ffULL, 0xffffffe0080f7812ULL, 0x000fe200078ec0ffULL,
0x000000400b0b7824ULL, 0x000fe200078e00ffULL, 0x0000006e1100720cULL, 0x000fc60003f26070ULL,
0x00000100480f7824ULL, 0x000fca00078e020fULL, 0x000000400f117810ULL, 0x000fe20007ffe0ffULL,
0x000062000b0e7625ULL, 0x000fc600078e000eULL, 0x00000020110c7812ULL, 0x000fca00078ec0ffULL,
0x000000016f377824ULL, 0x000fe200078e020cULL, 0x0000040000009947ULL, 0x000fea0003800000ULL,
0x00000010080b7812ULL, 0x000fe400078ec0ffULL, 0x000000116c087217ULL, 0x000fe40007800000ULL,
0x00000003ff137819ULL, 0x000fc60000011649ULL, 0x0000000108087824ULL, 0x000fe200078e0a11ULL,
0x0000000413127810ULL, 0x040fe20007ffe0ffULL, 0x00000001130c7824ULL, 0x040fe200078e020bULL,
0x0000000813347810ULL, 0x000fe40007ffe0ffULL, 0x0000000b08087217ULL, 0x000fe20007800000ULL,
0x000000010c107824ULL, 0x040fe400078e0249ULL, 0x000000080c117824ULL, 0x000fe400078e00ffULL,
0x0000000108087824ULL, 0x000fc600078e0a0bULL, 0xfffffff811387812ULL, 0x000fe200078ee210ULL,
0x0000001049117824ULL, 0x000fe200078e00ffULL, 0x000000081200720cULL, 0x0c0fe20003f66070ULL,
0x0000000112127824ULL, 0x000fe200078e020bULL, 0x000000081300720cULL, 0x0c0fe40003f86070ULL,
0x0000000c13137810ULL, 0x000fe20007ffe0ffULL, 0x0000000112107824ULL, 0x000fe200078e0249ULL,
0x000000083400720cULL, 0x080fe20003f46070ULL, 0x0000000812357824ULL, 0x000fe200078e00ffULL,
0x000000081300720cULL, 0x000fe20003f06070ULL, 0x0000000134347824ULL, 0x100fe200078e020bULL,
0x00000070113d7812ULL, 0x000fe200078ec0ffULL, 0x0000000113367824ULL, 0x000fe200078e020bULL,
0xfffffff835087812ULL, 0x000fe200078ee210ULL, 0x0000000137107824ULL, 0x000fc400078e020cULL,
0x0000000137127824ULL, 0x040fe400078e0212ULL, 0x0000000137357824ULL, 0x000fe400078e0234ULL,
0x00000001340b7824ULL, 0x040fe400078e0249ULL, 0x00000008340c7824ULL, 0x000fe400078e00ffULL,
0x0000008010107825ULL, 0x000fc600078e00ffULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee20bULL,
0x0000000136347824ULL, 0x000fe200078e0249ULL, 0x0000003d10397212ULL, 0x000fe200078efcffULL,
0x00000008363b7824ULL, 0x000fe400078e00ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x000000390e107210ULL, 0x000fe40007fbe0ffULL, 0xfffffff83b3a7812ULL, 0x000fe200078ee234ULL,
0x0000000137377824ULL, 0x000fe200078e0236ULL, 0x0000003d120b7212ULL, 0x000fe200078efcffULL,
0x0000008035347825ULL, 0x000fc600078e00ffULL, 0x0000000b0e127210ULL, 0x000fe20007fde0ffULL,
0x0000008037367825ULL, 0x000fe200078e00ffULL, 0x0000003d343f7212ULL, 0x080fe400078efcffULL,
0x0000c000620b7811ULL, 0x000fe200078e68ffULL, 0x000000010f117824ULL, 0x040fe200028e0611ULL,
0x0000003d363d7212ULL, 0x000fe200078efcffULL, 0x000000010f137824ULL, 0x000fe200030e0613ULL,
0x0000003f0e347210ULL, 0x000fe20007fbe0ffULL, 0x0000001038397824ULL, 0x100fe200078e020bULL,
0x0000003d0e0e7210ULL, 0x000fe20007fde0ffULL, 0x00000010083b7824ULL, 0x000fc400078e020bULL,
0x000000100c3d7824ULL, 0x000fe200078e020bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010397faeULL, 0x0003e2000e101c48ULL, 0x000000010f357824ULL, 0x040fe400028e0635ULL,
0x000000103a0b7824ULL, 0x000fe200078e020bULL, 0x00000000123b7faeULL, 0x0003e2000d901c48ULL,
0x000000010f0f7824ULL, 0x000fc600030e0637ULL, 0x00000000343d7faeULL, 0x0003e8000d101c48ULL,
0x000000000e0b7faeULL, 0x0003e2000c101c48ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x0000001008087812ULL, 0x000fe200078ec0ffULL, 0x00000010490c7824ULL, 0x040fe200078e00ffULL,
0x0000c00062437811ULL, 0x000fe400078e68ffULL, 0x0000000849087211ULL, 0x000fe400078fe8ffULL,
0x000000700c3d7812ULL, 0x000fc400078ec0ffULL, 0x0000000c08367810ULL, 0x040fe20007ffe0ffULL,
0x00000001080b7824ULL, 0x140fe200078e0249ULL, 0x00000004080c7810ULL, 0x040fe20007ffe0ffULL,
0x0000000808127824ULL, 0x040fe200078e00ffULL, 0x0000000808347810ULL, 0x000fe20007ffe0ffULL,
0x0000000137107824ULL, 0x000fe400078e0208ULL, 0x0000000136137824ULL, 0x000fe200078e0249ULL,
0xfffffff8120b7812ULL, 0x000fe200078ee20bULL, 0x0000008010107825ULL, 0x000fc800078e00ffULL,
0x0000000836387824ULL, 0x000fe200078e00ffULL, 0x0000003d10397212ULL, 0x000fe200078efcffULL,
0x0000000137127824ULL, 0x040fe400078e020cULL, 0x0000000137357824ULL, 0x040fe200078e0234ULL,
0xfffffff838387812ULL, 0x000fe200078ee213ULL, 0x0000000137377824ULL, 0x000fe200078e0236ULL,
0x000000390e107210ULL, 0x000fe20007f1e0ffULL, 0x000000010c087824ULL, 0x040fe400078e0249ULL,
0x000000080c3b7824ULL, 0x000fc400078e00ffULL, 0x00000001340c7824ULL, 0x040fe400078e0249ULL,
0x00000008343f7824ULL, 0x000fe200078e00ffULL, 0xfffffff83b087812ULL, 0x000fe200078ee208ULL,
0x0000008012127825ULL, 0x000fc600078e00ffULL, 0xfffffff83f0c7812ULL, 0x000fe200078ee20cULL,
0x0000008035347825ULL, 0x000fe200078e00ffULL, 0x0000003d12417212ULL, 0x000fc600078efcffULL,
0x0000008037367825ULL, 0x000fe200078e00ffULL, 0x0000003d343f7212ULL, 0x000fc600078efcffULL,
0x000000010f117824ULL, 0x000fe200000e0611ULL, 0x0000003d363d7212ULL, 0x000fe200078efcffULL,
0x000000100b0b7824ULL, 0x100fe200078e0243ULL, 0x000000410e127210ULL, 0x000fe20007f1e0ffULL,
0x0000001008397824ULL, 0x100fe200078e0243ULL, 0x0000003f0e347210ULL, 0x000fe20007f5e0ffULL,
0x000000100c3b7824ULL, 0x000fe200078e0243ULL, 0x0000003d0e0e7210ULL, 0x000fe20007f7e0ffULL,
0x000000010f137824ULL, 0x040fe200000e0613ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000100b7faeULL, 0x0003e2000b901c48ULL, 0x000000010f357824ULL, 0x000fc400010e0635ULL,
0x00000010383d7824ULL, 0x000fe200078e0243ULL, 0x0000000012397faeULL, 0x0003e2000b901c48ULL,
0x000000010f0f7824ULL, 0x000fc600018e0637ULL, 0x00000000343b7faeULL, 0x0003e8000b901c48ULL,
0x000000000e3d7faeULL, 0x0003e4000b901c48ULL, 0x0000000800087824ULL, 0x000fe200078e00ffULL,
0x00000001020e7810ULL, 0x002fe20007ffe0ffULL, 0xffffffffff0b7424ULL, 0x000fc600078e00ffULL,
0xfffffff008107812ULL, 0x000fe400078ec0ffULL, 0x0000006d0e00720cULL, 0x000fe40003f06070ULL,
0x00000000100473c2ULL, 0x000e6200000e0000ULL, 0xffffffe0080c7812ULL, 0x040fe400078ec0ffULL,
0x0000001008117812ULL, 0x040fe400078ec0ffULL, 0x0000000808087812ULL, 0x000fcc00078ec0ffULL,
0x00000001700e8824ULL, 0x000fe400078e020eULL, 0x00000004ff0f8424ULL, 0x000fe200078e00ffULL,
0x0000000c08087210ULL, 0x000fe40007ffe011ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000064000e0e8625ULL, 0x000fca00078e000fULL, 0x000000080e0b8981ULL, 0x000522000c1e1900ULL,
0x0000f6b004047890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x004fec0000008000ULL,
0x00f6b00010107f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6080008347f8cULL, 0x0004e4000c80043fULL, 0x00000000000e7805ULL, 0x000fc40000015200ULL,
0x00f60c0008137984ULL, 0x000ea40000000800ULL, 0x8000000013ff7812ULL, 0x00cfe40007804835ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff367224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x000000120e377210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e0fULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0c7819ULL, 0x000fc80000011413ULL,
0x000000370c0c7211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x000000020c0c7819ULL, 0x000fc80000001213ULL, 0x0000000c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000136367810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f60c0008137984ULL, 0x000ea40000000800ULL,
0x8000000013ff7812ULL, 0x004fe40007804835ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001049517824ULL, 0x000fe200078e00ffULL, 0x00000001ff797819ULL, 0x000fe20000011649ULL,
0x00000020000c7824ULL, 0x000fc600078e00ffULL, 0x0000007051517812ULL, 0x000fe400078ec0ffULL,
0xffffff800c0c7812ULL, 0x000fe400078ec0ffULL, 0x0000000c79797812ULL, 0x000fc800078ec0ffULL,
0x0000000c790c7210ULL, 0x000fca0007ffe051ULL, 0x00f000000c0e7984ULL, 0x000ea80000000800ULL,
0x00f200000c0f7984ULL, 0x0006620000000800ULL, 0x000000090e00720bULL, 0x004fe20003f1d000ULL,
0x0000fad27f007947ULL, 0x000fd8000b800000ULL, 0x00000000000c7806ULL, 0x008fc800000e0100ULL,
0x0000ffff0c357812ULL, 0x000fe2000780c0ffULL, 0x0000048000007945ULL, 0x000fe20003800000ULL,
0x00000001ff0c7424ULL, 0x000fd600078e00ffULL, 0x0000045000008947ULL, 0x000fea0003800000ULL,
0x000000007600720cULL, 0x000fe40003f05270ULL, 0x000000090e00720bULL, 0x000fe20003f54000ULL,
0x0000fa927f007947ULL, 0x000fd8000b800000ULL, 0x0000000000347806ULL, 0x000fc400010e0100ULL,
0x00000080000c8824ULL, 0x000fe200078e0251ULL, 0x000000090e137209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x0000991034127816ULL, 0x000fe200000000ffULL,
0x00000001790c8824ULL, 0x000fca00078e020cULL, 0x00f400130c008388ULL, 0x0005e20000000800ULL,
0x000000ff1200720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x80000013090c7221ULL, 0x004fe20000010000ULL, 0x000000ff34ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL,
0x0000000c00377308ULL, 0x000ea40000000800ULL, 0x000000370a0a7220ULL, 0x004fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0c7819ULL, 0x000fe20000011649ULL,
0x0000f9c27f007947ULL, 0x000fea000b800000ULL, 0x00001f0c370c7589ULL, 0x0004e400000e0000ULL,
0x0000000c20207220ULL, 0x08cfe20000410000ULL, 0x0000000c21217220ULL, 0x080fe20000410000ULL,
0x0000000c1c1c7220ULL, 0x080fe20000410000ULL, 0x0000000c1d1d7220ULL, 0x080fe20000410000ULL,
0x0000000c18187220ULL, 0x080fe20000410000ULL, 0x0000000c19197220ULL, 0x080fe20000410000ULL,
0x0000000c14147220ULL, 0x080fe20000410000ULL, 0x0000000c15157220ULL, 0x080fe20000410000ULL,
0x0000000c30307220ULL, 0x080fe20000410000ULL, 0x0000000c31317220ULL, 0x080fe20000410000ULL,
0x0000000c2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000c2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000c28287220ULL, 0x080fe20000410000ULL, 0x0000000c29297220ULL, 0x080fe20000410000ULL,
0x0000000c24247220ULL, 0x080fe20000410000ULL, 0x0000000c25257220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0034ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008490c7811ULL, 0x000fe200078ff0ffULL,
0x0000f8a27f007947ULL, 0x000fea000b800000ULL, 0x00001f0c370c7589ULL, 0x0004e400000e0000ULL,
0x0000000c22227220ULL, 0x08cfe20000410000ULL, 0x0000000c23237220ULL, 0x080fe20000410000ULL,
0x0000000c1e1e7220ULL, 0x080fe20000410000ULL, 0x0000000c1f1f7220ULL, 0x080fe20000410000ULL,
0x0000000c1a1a7220ULL, 0x080fe20000410000ULL, 0x0000000c1b1b7220ULL, 0x080fe20000410000ULL,
0x0000000c16167220ULL, 0x080fe20000410000ULL, 0x0000000c17177220ULL, 0x080fe20000410000ULL,
0x0000000c32327220ULL, 0x080fe20000410000ULL, 0x0000000c33337220ULL, 0x080fe20000410000ULL,
0x0000000c2e2e7220ULL, 0x080fe20000410000ULL, 0x0000000c2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000c2a2a7220ULL, 0x080fe20000410000ULL, 0x0000000c2b2b7220ULL, 0x080fe20000410000ULL,
0x0000000c26267220ULL, 0x080fe20000410000ULL, 0x0000000c27277220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff35ff7812ULL, 0x000fe20007806034ULL,
0x00000001ff0c7424ULL, 0x000fe200078e00ffULL, 0x000000090e097209ULL, 0x000fd60007810000ULL,
0x800000090e0e0221ULL, 0x000fe20000010000ULL, 0x00007610ff0c0816ULL, 0x000fc6000000000cULL,
0x3fb8aa3b0e0e0820ULL, 0x000fc80000410000ULL, 0x0000000e00050308ULL, 0x000ea40000000800ULL,
0x000000050f0f0220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000a0f0a7221ULL, 0x002fc40000010000ULL, 0x00000000000e7805ULL, 0x000fca0000015200ULL,
0x0000000800127824ULL, 0x000fca00078e00ffULL, 0xfffffff012347812ULL, 0x000fca00078ec0ffULL,
0x00f6ac0034127984ULL, 0x000e640000000800ULL, 0x8000000012ff7812ULL, 0x002fe4000780480dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff367224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x000000120e357210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e0fULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011413ULL,
0x0000003512127211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000212127819ULL, 0x000fc80000001213ULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000136367810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6ac0034127984ULL, 0x000e640000000800ULL,
0x8000000012ff7812ULL, 0x002fe4000780480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099100c0c7816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0c00720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000005ff06723eULL, 0x000fe400000000ffULL, 0x00000002ff0e7819ULL, 0x000fe40000011649ULL,
0x00005410060d7816ULL, 0x000fe20000000006ULL, 0x0000f4527f007947ULL, 0x000fea000b800000ULL,
0x00001f0e0d067589ULL, 0x0002a400000e0000ULL, 0x000000080e0c7810ULL, 0x000fe20007ffe0ffULL,
0x0000f4827f007947ULL, 0x000fea000b800000ULL, 0x00001f0c0d077589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000100e0c7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff127224ULL, 0x000fe200078e000dULL, 0x00002e5000137802ULL, 0x000fc40000000f00ULL,
0x0000fe6000007944ULL, 0x016fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000180e0c7810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff127224ULL, 0x000fe200078e000dULL,
0x00002ea000137802ULL, 0x000fc40000000f00ULL, 0x0000fe1000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000200697824ULL, 0x000fe200078e00ffULL,
0x00000007490d7812ULL, 0x00afe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe60003800000ULL,
0x00000004690c7812ULL, 0x004fc400078ec0ffULL, 0x000000080d0e7812ULL, 0x000fe400078ef849ULL,
0x0000000c49737211ULL, 0x040fe200078fe0ffULL, 0x00000200000c7824ULL, 0x000fe400078e00ffULL,
0x000000080e747824ULL, 0x040fe400078e00ffULL, 0x000000010e737824ULL, 0x000fe200078e0273ULL,
0xfffff8000c0f7812ULL, 0x000fe400078ec0ffULL, 0x00000008490c7812ULL, 0x000fc400078ec0ffULL,
0xfffffff874747812ULL, 0x000fca00078ee273ULL, 0x0000001074747824ULL, 0x000fc800078e00ffULL,
0x00000001744d7824ULL, 0x000fc400078e020fULL, 0x0000000400137824ULL, 0x000fe200078e00ffULL,
0x00000004ff3d7819ULL, 0x000fe20000011649ULL, 0x000000080e507824ULL, 0x000fe200078e00ffULL,
0x0000000d0c127212ULL, 0x000fe400078efcffULL, 0x0000000413137812ULL, 0x000fe400078ec0ffULL,
0x0000b00062717811ULL, 0x000fe200078e68ffULL, 0x0000000812357824ULL, 0x000fe200078e00ffULL,
0x000000100c447812ULL, 0x000fe200078efe0dULL, 0x000000013d137824ULL, 0x000fe200078e0213ULL,
0xfffffff869697812ULL, 0x000fe200078ec0ffULL, 0x00000004620d7824ULL, 0x000fc400078e023dULL,
0x00000001123c7824ULL, 0x040fe400078e0213ULL, 0x0000000812127824ULL, 0x000fe400078e00ffULL,
0x00000008444a7824ULL, 0x000fe200078e00ffULL, 0xfffffff8354c7812ULL, 0x000fe200078ee23cULL,
0x0000000113457824ULL, 0x000fe200078e0244ULL, 0x000000023c4b7810ULL, 0x000fe20007ffe0ffULL,
0x009000004d34783bULL, 0x000e620000000200ULL, 0x000000020d137810ULL, 0x000fe20007ffe00eULL,
0x000000104c387824ULL, 0x000fe200078e0271ULL, 0xfffffff8124b7812ULL, 0x000fc400078ee24bULL,
0xfffffff84a4a7812ULL, 0x000fe400078ee245ULL, 0xfffffff850507812ULL, 0x000fe200078ee213ULL,
0x000000003838783bULL, 0x000ea20000004200ULL, 0x000000104b3c7824ULL, 0x100fe200078e0271ULL,
0x00000002454e7810ULL, 0x000fe20007ffe0ffULL, 0x000000104a407824ULL, 0x000fe400078e0271ULL,
0x0000000844137824ULL, 0x000fe400078e00ffULL, 0x000000003c3c783bULL, 0x000ee20000004200ULL,
0x0000001050507824ULL, 0x000fc400078e020fULL, 0xfffffff8134e7812ULL, 0x000fe200078ee24eULL,
0x000000004040783bULL, 0x000ee20000004200ULL, 0x0000000634348232ULL, 0x082fe40000000000ULL,
0x0000000636368232ULL, 0x000fe40000000000ULL, 0x0000000735358232ULL, 0x080fe40000000000ULL,
0x0000000737378232ULL, 0x000fe20000000000ULL, 0x0000ffff3a0d7812ULL, 0x004fe400078ec0ffULL,
0x00000018ff0c7819ULL, 0x000fc4000001163aULL, 0x00000008ff0d7819ULL, 0x000fe4000001160dULL,
0x0000000cff0e723eULL, 0x000fe400020006ffULL, 0x0000000dff0c723eULL, 0x000fe400020006ffULL,
0x0000ffff3b0d7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff127819ULL, 0x000fe4000001163bULL,
0x00000008ff0d7819ULL, 0x000fc4000001160dULL, 0x00000012ff12723eULL, 0x000fe400020006ffULL,
0x0000000dff0d723eULL, 0x000fe400020006ffULL, 0x00000010ff467819ULL, 0x000fe40000011638ULL,
0x000054100d0d7816ULL, 0x000fe40000000012ULL, 0x00000010ff127819ULL, 0x000fe40000011639ULL,
0x000054100c0c7816ULL, 0x000fc4000000000eULL, 0x000000ff38537812ULL, 0x000fe400078ec0ffULL,
0x000000ff46467812ULL, 0x000fe400078ec0ffULL, 0x000000ff39477812ULL, 0x000fe200078ec0ffULL,
0x0000000c340c723cULL, 0x000be20000001814ULL, 0x000000ff12127812ULL, 0x000fe400078ec0ffULL,
0x00000018ff567819ULL, 0x000fe40000011638ULL, 0x0000ffff38387812ULL, 0x000fc400078ec0ffULL,
0x00000018ff557819ULL, 0x000fe40000011639ULL, 0x0000ffff39447812ULL, 0x000fe400078ec0ffULL,
0x00000010ff137819ULL, 0x000fe4000001163aULL, 0x000000ff3a787812ULL, 0x000fe400078ec0ffULL,
0x00000053ff39723eULL, 0x000fe400020006ffULL, 0x00000046ff46723eULL, 0x000fc400020006ffULL,
0x00000047ff47723eULL, 0x000fe400020006ffULL, 0x00000012ff3a723eULL, 0x000fe400020006ffULL,
0x00000010ff147819ULL, 0x128fe4000001163eULL, 0x000000ff3e727812ULL, 0x040fe400078ec0ffULL,
0x00000018ff647819ULL, 0x000fe4000001163eULL, 0x0000ffff3e5f7812ULL, 0x000fc400078ec0ffULL,
0x00000008ff3e7819ULL, 0x000fe40000011638ULL, 0x0000541039387816ULL, 0x000fe40000000046ULL,
0x0000541047397816ULL, 0x000fe4000000003aULL, 0x00000010ff457819ULL, 0x000fe4000001163bULL,
0x000000ff3b777812ULL, 0x000fe400078ec0ffULL, 0x000000ff423b7812ULL, 0x000fc400078ec0ffULL,
0x00000008ff447819ULL, 0x000fe40000011644ULL, 0x0000003bff12723eULL, 0x000fe400020006ffULL,
0x000000383438723cULL, 0x000be20000001820ULL, 0x00000010ff667819ULL, 0x100fe4000001163cULL,
0x000000ff3c687812ULL, 0x000fe400078ec0ffULL, 0x00000018ff657819ULL, 0x000fe4000001163cULL,
0x000000ff13217812ULL, 0x020fc400078ec0ffULL, 0x000000ff45207812ULL, 0x000fe400078ec0ffULL,
0x0000ffff3c157812ULL, 0x000fe400078ec0ffULL, 0x00000010ff677819ULL, 0x100fe4000001163dULL,
0x000000ff3d6b7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6a7819ULL, 0x000fe4000001163dULL,
0x0000ffff3d167812ULL, 0x000fc400078ec0ffULL, 0x00000056ff3c723eULL, 0x000fe400020006ffULL,
0x00000055ff3d723eULL, 0x000fe400020006ffULL, 0x00000078ff78723eULL, 0x000fe400020006ffULL,
0x00000077ff77723eULL, 0x000fe400020006ffULL, 0x0000003eff3e723eULL, 0x000fe400020006ffULL,
0x00000044ff44723eULL, 0x000fc400020006ffULL, 0x00000021ff21723eULL, 0x000fe400020006ffULL,
0x00000020ff20723eULL, 0x000fe400020006ffULL, 0x00000018ff4f7819ULL, 0x000fe40000011640ULL,
0x000000ff40547812ULL, 0x000fe400078ec0ffULL, 0x00000018ff527819ULL, 0x000fe40000011641ULL,
0x000000ff41537812ULL, 0x000fc400078ec0ffULL, 0x00000010ff5c7819ULL, 0x000fe40000011640ULL,
0x0000ffff40597812ULL, 0x000fe400078ec0ffULL, 0x00000010ff587819ULL, 0x000fe40000011641ULL,
0x0000ffff415b7812ULL, 0x000fe400078ec0ffULL, 0x000054103e3c7816ULL, 0x000fe4000000003cULL,
0x00005410443d7816ULL, 0x000fe2000000003dULL, 0x000000104e447824ULL, 0x000fe200078e0271ULL,
0x0000541078407816ULL, 0x000fc40000000021ULL, 0x0000541077417816ULL, 0x000fe40000000020ULL,
0x000000ff3f177812ULL, 0x040fe200078ec0ffULL, 0x000000004444783bULL, 0x000fe20000004200ULL,
0x00000010ff637819ULL, 0x100fe4000001163fULL, 0x00000018ff607819ULL, 0x000fe4000001163fULL,
0x0000ffff3f617812ULL, 0x000fe400078ec0ffULL, 0x000000ff43227812ULL, 0x000fe200078ec0ffULL,
0x0000003c343c723cULL, 0x000be2000000181cULL, 0x00000010ff5a7819ULL, 0x000fc40000011642ULL,
0x00000018ff5d7819ULL, 0x000fe40000011642ULL, 0x0000ffff42557812ULL, 0x000fe400078ec0ffULL,
0x00000010ff567819ULL, 0x100fe40000011643ULL, 0x00000018ff5e7819ULL, 0x000fe40000011643ULL,
0x0000ffff43577812ULL, 0x000fe400078ec0ffULL, 0x000000403440723cULL, 0x000b640000001818ULL,
0x000000ff141e7812ULL, 0x020fc400078ec0ffULL, 0x00000065ff1c723eULL, 0x000fe400020006ffULL,
0x0000006aff1d723eULL, 0x000fe400020006ffULL, 0x00000008ff187819ULL, 0x000fe40000011615ULL,
0x00000017ff19723eULL, 0x000fe400020006ffULL, 0x00000008ff1a7819ULL, 0x000fe40000011616ULL,
0x009000005014783bULL, 0x000e620000000200ULL, 0x000000ff66667812ULL, 0x000fc400078ec0ffULL,
0x000000ff67677812ULL, 0x000fe400078ec0ffULL, 0x00000018ff18723eULL, 0x000fe400020006ffULL,
0x0000001aff1b723eULL, 0x000fe400020006ffULL, 0x00000068ff68723eULL, 0x000fe400020006ffULL,
0x0000006bff6b723eULL, 0x000fe400020006ffULL, 0x00000066ff20723eULL, 0x000fc400020006ffULL,
0x00000067ff21723eULL, 0x000fe400020006ffULL, 0x000000ff63637812ULL, 0x000fe400078ec0ffULL,
0x00005410181c7816ULL, 0x000fe4000000001cULL, 0x000054101b1d7816ULL, 0x000fe4000000001dULL,
0x00000072ff65723eULL, 0x000fe400020006ffULL, 0x0000541068207816ULL, 0x000fc40000000020ULL,
0x000054106b217816ULL, 0x000fe40000000021ULL, 0x0000001eff1a723eULL, 0x000fe400020006ffULL,
0x00000063ff63723eULL, 0x000fe200020006ffULL, 0x0000001c341c723cULL, 0x000be2000000182cULL,
0x0000541065187816ULL, 0x000fe4000000001aULL, 0x0000541019197816ULL, 0x000fe40000000063ULL,
0x00000022ff13723eULL, 0x000fc400020006ffULL, 0x00000008ff2e7819ULL, 0x020fe2000001165fULL,
0x000000203420723cULL, 0x040b620000001830ULL, 0x00000008ff2d7819ULL, 0x000fe20000011661ULL,
0x0000000614148232ULL, 0x082fe20000000000ULL, 0x00000060ff2c723eULL, 0x000fe200020006ffULL,
0x0000000616168232ULL, 0x000fe20000000000ULL, 0x0000002eff2e723eULL, 0x000fe200020006ffULL,
0x0000000715158232ULL, 0x080fe20000000000ULL, 0x00000064ff30723eULL, 0x020fe200020006ffULL,
0x000000183418723cULL, 0x000b620000001828ULL, 0x0000002dff2d723eULL, 0x000fe200020006ffULL,
0x0000000717178232ULL, 0x000fe20000000000ULL, 0x000000ff5a5a7812ULL, 0x000fc400078ec0ffULL,
0x000000ff56567812ULL, 0x000fe400078ec0ffULL, 0x000054102e287816ULL, 0x020fe40000000030ULL,
0x000054102d297816ULL, 0x000fe4000000002cULL, 0x0000005aff5a723eULL, 0x000fe400020006ffULL,
0x00000008ff557819ULL, 0x000fe40000011655ULL, 0x00000008ff577819ULL, 0x000fe20000011657ULL,
0x000000283434723cULL, 0x000b620000001824ULL, 0x00000056ff56723eULL, 0x000fc400020006ffULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x0000005eff5e723eULL, 0x000fe400020006ffULL,
0x00000055ff28723eULL, 0x020fe400020006ffULL, 0x00000057ff29723eULL, 0x000fe400020006ffULL,
0x0000541012127816ULL, 0x000fe4000000005aULL, 0x0000541013137816ULL, 0x000fc40000000056ULL,
0x00000010ff2b7819ULL, 0x000fe40000011644ULL, 0x00000010ff647819ULL, 0x000fe40000011645ULL,
0x0000541028287816ULL, 0x000fe2000000005dULL, 0x000000121424723cULL, 0x000b620000001840ULL,
0x0000541029297816ULL, 0x000fe4000000005eULL, 0x00000018ff2a7819ULL, 0x000fe40000011644ULL,
0x000000ff44677812ULL, 0x000fc400078ec0ffULL, 0x000000ff45687812ULL, 0x000fe400078ec0ffULL,
0x000000ff2b127812ULL, 0x020fe400078ec0ffULL, 0x000000ff64647812ULL, 0x000fe400078ec0ffULL,
0x0000002aff13723eULL, 0x000fe400020006ffULL, 0x000000281428723cULL, 0x000b62000000180cULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x00000068ff68723eULL, 0x000fc400020006ffULL,
0x0000ffff44607812ULL, 0x000fe400078ec0ffULL, 0x00000012ff0c723eULL, 0x020fe400020006ffULL,
0x00000064ff0d723eULL, 0x000fe400020006ffULL, 0x0000ffff45617812ULL, 0x000fe400078ec0ffULL,
0x00005410670c7816ULL, 0x000fe4000000000cULL, 0x00005410680d7816ULL, 0x000fc4000000000dULL,
0x00000018ff657819ULL, 0x000fe40000011645ULL, 0x00000008ff607819ULL, 0x000fe40000011660ULL,
0x00000008ff617819ULL, 0x000fe20000011661ULL, 0x0000000c1420723cULL, 0x000b620000001820ULL,
0x00000065ff65723eULL, 0x000fe400020006ffULL, 0x000000ff5c2f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5f7819ULL, 0x000fc40000011646ULL, 0x00000060ff0c723eULL, 0x020fe400020006ffULL,
0x00000061ff0d723eULL, 0x000fe400020006ffULL, 0x000000ff46667812ULL, 0x000fe400078ec0ffULL,
0x00000018ff457819ULL, 0x000fe40000011646ULL, 0x00000010ff5c7819ULL, 0x000fe40000011647ULL,
0x000000ff47637812ULL, 0x000fc400078ec0ffULL, 0x00000018ff447819ULL, 0x000fe40000011647ULL,
0x0000ffff46467812ULL, 0x000fe400078ec0ffULL, 0x0000ffff47477812ULL, 0x000fe400078ec0ffULL,
0x000054100c0c7816ULL, 0x000fe40000000013ULL, 0x000054100d0d7816ULL, 0x000fe40000000065ULL,
0x000000ff58587812ULL, 0x000fc400078ec0ffULL, 0x00000008ff597819ULL, 0x000fe40000011659ULL,
0x00000008ff5b7819ULL, 0x000fe2000001165bULL, 0x0000000c141c723cULL, 0x000b62000000181cULL,
0x000000ff5f5f7812ULL, 0x000fe400078ec0ffULL, 0x000000ff5c5c7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff467819ULL, 0x000fe40000011646ULL, 0x00000008ff477819ULL, 0x000fc40000011647ULL,
0x0000004fff4f723eULL, 0x000fe400020006ffULL, 0x00000054ff54723eULL, 0x000fe400020006ffULL,
0x00000052ff52723eULL, 0x000fe400020006ffULL, 0x00000053ff53723eULL, 0x000fe400020006ffULL,
0x0000002fff2f723eULL, 0x000fe400020006ffULL, 0x00000058ff31723eULL, 0x000fc400020006ffULL,
0x00000059ff2c723eULL, 0x000fe400020006ffULL, 0x0000005bff2d723eULL, 0x000fe400020006ffULL,
0x00000066ff66723eULL, 0x000fe400020006ffULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x0000005fff5f723eULL, 0x000fe400020006ffULL, 0x0000005cff5c723eULL, 0x000fc400020006ffULL,
0x00000045ff45723eULL, 0x000fe400020006ffULL, 0x00000044ff44723eULL, 0x000fe400020006ffULL,
0x00000046ff0c723eULL, 0x020fe400020006ffULL, 0x00000047ff0d723eULL, 0x000fe400020006ffULL,
0x0000541054307816ULL, 0x000fe4000000002fULL, 0x0000541053317816ULL, 0x000fc40000000031ULL,
0x000054102c2c7816ULL, 0x000fe4000000004fULL, 0x000054102d2d7816ULL, 0x000fe40000000052ULL,
0x0000541066667816ULL, 0x000fe2000000005fULL, 0x000000301430723cULL, 0x000f620000001838ULL,
0x0000541063677816ULL, 0x000fe4000000005cULL, 0x000054100c0c7816ULL, 0x000fe40000000045ULL,
0x000054100d0d7816ULL, 0x000fc60000000044ULL, 0x0000002c142c723cULL, 0x040f70000000183cULL,
0x000000661418723cULL, 0x040f700000001818ULL, 0x0000000c1414723cULL, 0x000b6e0000001834ULL,
0x0000f6c8620c7811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x000000000c0c7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6880069ff7f8cULL, 0x0005e4000c80043fULL, 0x00000000000e7805ULL, 0x000fc40000015200ULL,
0x0000040004137984ULL, 0x000ee40000000800ULL, 0x8000000013ff7812ULL, 0x00afc4000780480dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff347224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x000000120e357210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e0fULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011413ULL,
0x0000003512127211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000212127819ULL, 0x000fc80000001213ULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000134347810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040004137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe4000780480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001000127824ULL, 0x000fe400078e00ffULL, 0x000059000b0b7a24ULL, 0x010fe400078e02ffULL,
0x00000080ff0c7424ULL, 0x000fe200078e00ffULL, 0xffffffe0120d7812ULL, 0x000fe200078ec0ffULL,
0x000000400b0b7824ULL, 0x000fc800078e00ffULL, 0x00000100480d7824ULL, 0x000fca00078e020dULL,
0x000000800d0f7810ULL, 0x000fe20007ffe0ffULL, 0x000062000b0c7625ULL, 0x000fc600078e000cULL,
0x000000200f0e7812ULL, 0x000fca00078ec0ffULL, 0x000000016f0b7824ULL, 0x000fe200078e020eULL,
0x000003d000009947ULL, 0x000fea0003800000ULL, 0x0000000f6c0e7217ULL, 0x000fe40007800000ULL,
0x0000001012137812ULL, 0x000fe400078ec0ffULL, 0x00000003ff127819ULL, 0x000fe20000011649ULL,
0x000000010e0e7824ULL, 0x000fc600078e0a0fULL, 0x0000000412357810ULL, 0x040fe20007ffe0ffULL,
0x0000000112347824ULL, 0x040fe200078e0213ULL, 0x0000000e130e7217ULL, 0x000fe40007800000ULL,
0x0000000812377810ULL, 0x000fe20007ffe0ffULL, 0x00000001340f7824ULL, 0x000fe400078e0249ULL,
0x000000010e0e7824ULL, 0x100fe400078e0a13ULL, 0x0000000834387824ULL, 0x000fe400078e00ffULL,
0x0000000135367824ULL, 0x140fe200078e0213ULL, 0x0000000e3500720cULL, 0x080fe20003f66070ULL,
0x00000001373c7824ULL, 0x040fe200078e0213ULL, 0xfffffff838387812ULL, 0x000fe200078ee20fULL,
0x00000001340f7824ULL, 0x000fe200078e020bULL, 0x0000000c12357810ULL, 0x000fe20007ffe0ffULL,
0x0000000836397824ULL, 0x000fe200078e00ffULL, 0x0000000e1200720cULL, 0x080fe20003f86070ULL,
0x0000000136127824ULL, 0x040fe200078e0249ULL, 0x0000000e3700720cULL, 0x080fe20003f46070ULL,
0x0000000136367824ULL, 0x000fe200078e020bULL, 0x0000000e3500720cULL, 0x000fe20003f06070ULL,
0x000000800f0e7825ULL, 0x000fe200078e00ffULL, 0xfffffff8393a7812ULL, 0x000fc600078ee212ULL,
0x00000001353e7824ULL, 0x000fe200078e0213ULL, 0x000000510e137212ULL, 0x000fe200078efcffULL,
0x000000013c347824ULL, 0x040fe400078e020bULL, 0x000000013c357824ULL, 0x000fe200078e0249ULL,
0x000000130c0e7210ULL, 0x000fe20007fbe0ffULL, 0x000000083c3c7824ULL, 0x000fe400078e00ffULL,
0x0000008036367825ULL, 0x000fc600078e00ffULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee235ULL,
0x000000013e127824ULL, 0x000fe200078e020bULL, 0x00000051360b7212ULL, 0x000fe200078efcffULL,
0x0000008034347825ULL, 0x000fc800078e00ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000005134397212ULL, 0x000fc600078efcffULL, 0x000000010d0f7824ULL, 0x040fe200028e060fULL,
0x0000000b0c367210ULL, 0x000fe20007fbe0ffULL, 0x000000013e3b7824ULL, 0x000fe200078e0249ULL,
0x00000051120b7212ULL, 0x000fe200078efcffULL, 0x000000083e127824ULL, 0x000fe400078e00ffULL,
0x000000010d377824ULL, 0x040fe200028e0637ULL, 0x000000390c347210ULL, 0x000fe20007fbe0ffULL,
0x000000103c397824ULL, 0x100fe200078e0271ULL, 0x0000000b0c0c7210ULL, 0x000fe20007fde0ffULL,
0x00000010380b7824ULL, 0x000fe200078e0271ULL, 0xfffffff812127812ULL, 0x000fe200078ee23bULL,
0x000000010d357824ULL, 0x000fc400028e0635ULL, 0x000000010d0d7824ULL, 0x000fe200030e0613ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e0b7faeULL, 0x0003e2000e101c48ULL,
0x000000103a137824ULL, 0x100fe400078e0271ULL, 0x00000010123b7824ULL, 0x000fc600078e0271ULL,
0x0000000036137faeULL, 0x0003e8000d901c48ULL, 0x0000000034397faeULL, 0x0003e8000d101c48ULL,
0x000000000c3b7faeULL, 0x0003e2000c101c48ULL, 0x0000030000007947ULL, 0x000fea0003800000ULL,
0x0000001012127812ULL, 0x000fc800078ec0ffULL, 0x0000001249127211ULL, 0x000fc800078fe8ffULL,
0x00000008123c7810ULL, 0x040fe20007ffe0ffULL, 0x00000001120e7824ULL, 0x040fe200078e0249ULL,
0x0000000412367810ULL, 0x040fe20007ffe0ffULL, 0x0000000812357824ULL, 0x040fe200078e00ffULL,
0x0000000c12407810ULL, 0x040fe20007ffe0ffULL, 0x0000000112347824ULL, 0x000fe400078e020bULL,
0x000000013c137824ULL, 0x040fe200078e0249ULL, 0xfffffff835387812ULL, 0x000fe200078ee20eULL,
0x000000083c3e7824ULL, 0x000fe400078e00ffULL, 0x0000008034347825ULL, 0x000fc600078e00ffULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee213ULL, 0x00000001360f7824ULL, 0x040fe400078e0249ULL,
0x00000008363a7824ULL, 0x040fe400078e00ffULL, 0x0000000136367824ULL, 0x100fe400078e020bULL,
0x000000013c127824ULL, 0x000fe200078e020bULL, 0xfffffff83a3a7812ULL, 0x000fe200078ee20fULL,
0x00000001400e7824ULL, 0x000fe200078e020bULL, 0x00000051340b7212ULL, 0x000fe200078efcffULL,
0x0000000140397824ULL, 0x000fc400078e0249ULL, 0x00000008403c7824ULL, 0x000fe200078e00ffULL,
0x0000000b0c347210ULL, 0x000fe20007f1e0ffULL, 0x0000008036367825ULL, 0x000fc600078e00ffULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee239ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x00000051363b7212ULL, 0x000fc600078efcffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000005112397212ULL, 0x000fe400078efcffULL, 0x0000003b0c367210ULL, 0x000fe20007f5e0ffULL,
0x000000010d357824ULL, 0x040fe200000e0635ULL, 0x000000510e0b7212ULL, 0x000fe200078efcffULL,
0x000000103c3b7824ULL, 0x000fe200078e0271ULL, 0x000000390c127210ULL, 0x040fe20007f1e0ffULL,
0x000000010d377824ULL, 0x000fe200010e0637ULL, 0x0000000b0c0c7210ULL, 0x000fe20007f7e0ffULL,
0x00000010380b7824ULL, 0x000fc400078e0271ULL, 0x000000010d137824ULL, 0x040fe400000e0613ULL,
0x000000010d0d7824ULL, 0x000fe200018e060fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000340b7faeULL, 0x0003e2000b901c48ULL, 0x000000103a0f7824ULL, 0x100fe400078e0271ULL,
0x000000103e397824ULL, 0x000fc600078e0271ULL, 0x00000000360f7faeULL, 0x0003e8000b901c48ULL,
0x0000000012397faeULL, 0x0003e8000b901c48ULL, 0x000000000c3b7faeULL, 0x0003e4000b901c48ULL,
0x00000008000e7824ULL, 0x002fe200078e00ffULL, 0x00000002020c7810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff0b7424ULL, 0x000fc600078e00ffULL, 0xfffffff00e0e7812ULL, 0x000fe400078ec0ffULL,
0x0000006d0c00720cULL, 0x000fe40003f06070ULL, 0x000000000e0473c2ULL, 0x000e6200000e0000ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x00000001700c8824ULL, 0x000fc400078e020cULL,
0x00000004ff0d8424ULL, 0x000fc800078e00ffULL, 0x000064000c0c8625ULL, 0x000fca00078e000dULL,
0x000000080c0b8981ULL, 0x000722000c1e1900ULL, 0x0000f6a804047890ULL, 0x002fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x008fec0000008000ULL, 0x00f6a8000e0e7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f62800080c7f8cULL, 0x0006a4000c80043fULL,
0x0000000000127805ULL, 0x000fc40000015200ULL, 0x00f62c0008357984ULL, 0x000ee40000000800ULL,
0x8000000035ff7812ULL, 0x00cfe4000780480dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff367224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fcc0000015200ULL,
0x0000003412377210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e13ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff347819ULL, 0x000fc80000011435ULL, 0x0000003734347211ULL, 0x000fca00078110ffULL,
0x000000ffff357224ULL, 0x000fca00000e0635ULL, 0x0000000234347819ULL, 0x000fc80000001235ULL,
0x000000340000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000136367810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f62c0008357984ULL, 0x000ea40000000800ULL, 0x8000000035ff7812ULL, 0x004fe4000780480dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000020000c7824ULL, 0x000fca00078e00ffULL,
0xffffff800c0c7812ULL, 0x000fc800078ec0ffULL, 0x00000080510c7810ULL, 0x000fca0007ffe00cULL,
0x00000001790c7824ULL, 0x000fca00078e020cULL, 0x00f000000c347984ULL, 0x000ea80000000800ULL,
0x00f200000c0d7984ULL, 0x0006620000000800ULL, 0x000000093400720bULL, 0x004fe20003f1d000ULL,
0x0000d4b27f007947ULL, 0x000fd8000b800000ULL, 0x00000000000c7806ULL, 0x008fc800000e0100ULL,
0x0000ffff0c367812ULL, 0x000fe2000780c0ffULL, 0x000004a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff357424ULL, 0x000fd600078e00ffULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x0000000176137810ULL, 0x000fe40007ffe0ffULL, 0x000000093400720bULL, 0x000fe40003f54000ULL,
0x000000001300720cULL, 0x000fe20003f05270ULL, 0x0000d4627f007947ULL, 0x000fd4000b800000ULL,
0x0000000000357806ULL, 0x000fc400010e0100ULL, 0x0000008000128824ULL, 0x000fe200078e0251ULL,
0x00000009340c8209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe40003800000ULL,
0x0000000179138824ULL, 0x000fe200078e0212ULL, 0x0000991035127816ULL, 0x000fc800000000ffULL,
0x00f4000c13008388ULL, 0x0005e20000000800ULL, 0x000000ff1200720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x00000009340c7209ULL, 0x004fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff35ff7812ULL, 0x000fc6000780c0ffULL,
0x000000090c0c7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL,
0x0000000c00377308ULL, 0x000ea40000000800ULL, 0x000000370a0a7220ULL, 0x004fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0c7819ULL, 0x000fe20000011649ULL,
0x0000d3827f007947ULL, 0x000fea000b800000ULL, 0x00001f0c370c7589ULL, 0x0004e400000e0000ULL,
0x0000000c30307220ULL, 0x08cfe20000410000ULL, 0x0000000c31317220ULL, 0x080fe20000410000ULL,
0x0000000c2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000c2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000c24247220ULL, 0x080fe20000410000ULL, 0x0000000c25257220ULL, 0x080fe20000410000ULL,
0x0000000c28287220ULL, 0x080fe20000410000ULL, 0x0000000c29297220ULL, 0x080fe20000410000ULL,
0x0000000c20207220ULL, 0x080fe20000410000ULL, 0x0000000c21217220ULL, 0x080fe20000410000ULL,
0x0000000c1c1c7220ULL, 0x080fe20000410000ULL, 0x0000000c1d1d7220ULL, 0x080fe20000410000ULL,
0x0000000c18187220ULL, 0x080fe20000410000ULL, 0x0000000c19197220ULL, 0x080fe20000410000ULL,
0x0000000c14147220ULL, 0x080fe20000410000ULL, 0x0000000c15157220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0035ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008490c7811ULL, 0x000fe200078ff0ffULL,
0x0000d2627f007947ULL, 0x000fea000b800000ULL, 0x00001f0c370c7589ULL, 0x0004e400000e0000ULL,
0x0000000c32327220ULL, 0x08cfe20000410000ULL, 0x0000000c33337220ULL, 0x080fe20000410000ULL,
0x0000000c2e2e7220ULL, 0x080fe20000410000ULL, 0x0000000c2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000c26267220ULL, 0x080fe20000410000ULL, 0x0000000c27277220ULL, 0x080fe20000410000ULL,
0x0000000c2a2a7220ULL, 0x080fe20000410000ULL, 0x0000000c2b2b7220ULL, 0x080fe20000410000ULL,
0x0000000c22227220ULL, 0x080fe20000410000ULL, 0x0000000c23237220ULL, 0x080fe20000410000ULL,
0x0000000c1e1e7220ULL, 0x080fe20000410000ULL, 0x0000000c1f1f7220ULL, 0x080fe20000410000ULL,
0x0000000c1a1a7220ULL, 0x080fe20000410000ULL, 0x0000000c1b1b7220ULL, 0x080fe20000410000ULL,
0x0000000c16167220ULL, 0x080fe20000410000ULL, 0x0000000c17177220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff36ff7812ULL, 0x000fe20007806035ULL,
0x00000001ff357424ULL, 0x000fe200078e00ffULL, 0x0000000934097209ULL, 0x000fd60007810000ULL,
0x8000000934340221ULL, 0x000fe20000010000ULL, 0x00007610ff350816ULL, 0x000fc60000000035ULL,
0x3fb8aa3b34340820ULL, 0x000fc80000410000ULL, 0x0000003400050308ULL, 0x000ea40000000800ULL,
0x000000050d0d0220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000a0d0a7221ULL, 0x002fc40000010000ULL, 0x00000000000c7805ULL, 0x000fca0000015200ULL,
0x0000000800127824ULL, 0x000fca00078e00ffULL, 0xfffffff012347812ULL, 0x000fca00078ec0ffULL,
0x00f6b40034137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff367224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x000000120c377210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e0dULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011413ULL,
0x0000003712127211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000212127819ULL, 0x000fc80000001213ULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000136367810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6b40034137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009910350c7816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0c00720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000005ff06723eULL, 0x000fe400000000ffULL, 0x00000002ff107819ULL, 0x000fe40000011649ULL,
0x00005410060d7816ULL, 0x000fe20000000006ULL, 0x0000ce127f007947ULL, 0x000fea000b800000ULL,
0x00001f100d067589ULL, 0x0002a400000e0000ULL, 0x00000008100c7810ULL, 0x000fe20007ffe0ffULL,
0x0000ce427f007947ULL, 0x000fea000b800000ULL, 0x00001f0c0d077589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000010100c7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff127224ULL, 0x000fe200078e000dULL, 0x0000565000137802ULL, 0x000fc40000000f00ULL,
0x0000d66000007944ULL, 0x016fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000018100c7810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff127224ULL, 0x000fe200078e000dULL,
0x000056a000137802ULL, 0x000fc40000000f00ULL, 0x0000d61000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x00001000714f7810ULL, 0x000fe20007ffe0ffULL, 0x009800004d10783bULL, 0x002e680000000200ULL,
0x000000104c6b7824ULL, 0x000fc400078e024fULL, 0x000000104b3c7824ULL, 0x100fe400078e024fULL,
0x000000104a637824ULL, 0x000fe200078e024fULL, 0x000000006b34783bULL, 0x000ee80000004200ULL,
0x000000003c3c783bULL, 0x000ea80000004200ULL, 0x000000006338783bULL, 0x000ea40000004200ULL,
0x0000000610108232ULL, 0x006fc40000000000ULL, 0x0000000612128232ULL, 0x000fe40000000000ULL,
0x0000000711118232ULL, 0x080fe40000000000ULL, 0x0000000713138232ULL, 0x000fe20000000000ULL,
0x00000010ff0d7819ULL, 0x008fe40000011634ULL, 0x000000ff34407812ULL, 0x000fe400078ec0ffULL,
0x00000010ff0c7819ULL, 0x000fe40000011635ULL, 0x00000010ff667819ULL, 0x000fc4000001163cULL,
0x000000ff3c597812ULL, 0x040fe400078ec0ffULL, 0x00000018ff577819ULL, 0x000fe4000001163cULL,
0x0000ffff3c677812ULL, 0x000fe400078ec0ffULL, 0x00000010ff527819ULL, 0x100fe40000011637ULL,
0x000000ff37557812ULL, 0x000fe400078ec0ffULL, 0x00000018ff697819ULL, 0x000fc40000011637ULL,
0x0000ffff375a7812ULL, 0x000fe400078ec0ffULL, 0x000000ff3d3c7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff567819ULL, 0x000fe40000011634ULL, 0x0000ffff34447812ULL, 0x000fe400078ec0ffULL,
0x00000018ff377819ULL, 0x000fe4000001163dULL, 0x000000ff35417812ULL, 0x000fc400078ec0ffULL,
0x00000010ff457819ULL, 0x100fe40000011636ULL, 0x000000ff36587812ULL, 0x040fe400078ec0ffULL,
0x00000018ff6a7819ULL, 0x000fe40000011636ULL, 0x0000ffff36547812ULL, 0x000fe400078ec0ffULL,
0x00000040ff34723eULL, 0x000fe400020006ffULL, 0x000000ff0d0d7812ULL, 0x000fc400078ec0ffULL,
0x000000ff0c0c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5e7819ULL, 0x100fe4000001163eULL,
0x000000ff3e437812ULL, 0x040fe400078ec0ffULL, 0x00000018ff367819ULL, 0x000fe4000001163eULL,
0x0000ffff3e407812ULL, 0x000fe400078ec0ffULL, 0x00000010ff687819ULL, 0x000fc4000001163dULL,
0x0000ffff3d647812ULL, 0x000fe400078ec0ffULL, 0x0000003cff3e723eULL, 0x000fe400020006ffULL,
0x00000018ff477819ULL, 0x000fe40000011635ULL, 0x0000ffff35467812ULL, 0x000fe400078ec0ffULL,
0x00000057ff3c723eULL, 0x000fe400020006ffULL, 0x00000037ff3d723eULL, 0x000fc400020006ffULL,
0x00000041ff35723eULL, 0x000fe400020006ffULL, 0x0000000dff37723eULL, 0x000fe400020006ffULL,
0x0000000cff57723eULL, 0x000fe400020006ffULL, 0x0000541034347816ULL, 0x000fe40000000037ULL,
0x0000541035357816ULL, 0x000fe40000000057ULL, 0x00000008ff447819ULL, 0x000fc40000011644ULL,
0x00000008ff467819ULL, 0x000fe40000011646ULL, 0x00000036ff0d723eULL, 0x000fe400020006ffULL,
0x000000341034723cULL, 0x000b620000001830ULL, 0x00000056ff56723eULL, 0x000fe400020006ffULL,
0x00000047ff47723eULL, 0x000fe400020006ffULL, 0x00000058ff58723eULL, 0x000fe400020006ffULL,
0x00000044ff30723eULL, 0x020fe200020006ffULL, 0x000000104e447824ULL, 0x000fe200078e024fULL,
0x00000046ff31723eULL, 0x000fc400020006ffULL, 0x000000ff45337812ULL, 0x000fe400078ec0ffULL,
0x000000ff52327812ULL, 0x000fe400078ec0ffULL, 0x0000541030307816ULL, 0x000fe40000000056ULL,
0x0000541031317816ULL, 0x000fe40000000047ULL, 0x00000055ff55723eULL, 0x000fe200020006ffULL,
0x000000004444783bULL, 0x000fe20000004200ULL, 0x00000033ff33723eULL, 0x000fc400020006ffULL,
0x00000032ff32723eULL, 0x000fe200020006ffULL, 0x00000030102c723cULL, 0x000b62000000182cULL,
0x0000006aff6a723eULL, 0x000fe400020006ffULL, 0x00000069ff69723eULL, 0x000fe400020006ffULL,
0x000000ff66667812ULL, 0x000fe400078ec0ffULL, 0x0000541058307816ULL, 0x020fe40000000033ULL,
0x0000541055317816ULL, 0x000fc40000000032ULL, 0x00000008ff327819ULL, 0x000fe4000001165aULL,
0x000000ff3b337812ULL, 0x000fe400078ec0ffULL, 0x000000ff68687812ULL, 0x000fe200078ec0ffULL,
0x000000301024723cULL, 0x000b620000001824ULL, 0x00000010ff417819ULL, 0x100fe4000001163fULL,
0x000000ff3f427812ULL, 0x000fe400078ec0ffULL, 0x00000018ff537819ULL, 0x000fc4000001163fULL,
0x00000018ff307819ULL, 0x020fe4000001163aULL, 0x00000008ff317819ULL, 0x000fe40000011654ULL,
0x00000030ff54723eULL, 0x000fe400020006ffULL, 0x00000031ff30723eULL, 0x000fe400020006ffULL,
0x00000032ff31723eULL, 0x000fe400020006ffULL, 0x0000541030307816ULL, 0x000fc4000000006aULL,
0x0000541031317816ULL, 0x000fe40000000069ULL, 0x0000ffff3f5b7812ULL, 0x000fe400078ec0ffULL,
0x00000059ff3f723eULL, 0x000fe400020006ffULL, 0x00000018ff597819ULL, 0x000fe20000011638ULL,
0x000000301028723cULL, 0x000b620000001828ULL, 0x000000ff38577812ULL, 0x000fe400078ec0ffULL,
0x00000018ff527819ULL, 0x000fc40000011639ULL, 0x000000ff39567812ULL, 0x040fe400078ec0ffULL,
0x00000010ff657819ULL, 0x000fe40000011638ULL, 0x0000ffff385f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff607819ULL, 0x000fe40000011639ULL, 0x0000ffff39617812ULL, 0x000fe400078ec0ffULL,
0x00000033ff5a723eULL, 0x000fc400020006ffULL, 0x00000066ff38723eULL, 0x000fe200020006ffULL,
0x009800005030783bULL, 0x020e620000000200ULL, 0x00000068ff39723eULL, 0x000fe400020006ffULL,
0x00000008ff677819ULL, 0x000fe40000011667ULL, 0x00000008ff647819ULL, 0x000fe40000011664ULL,
0x000054103f387816ULL, 0x000fe40000000038ULL, 0x000054103e397816ULL, 0x000fc40000000039ULL,
0x00000067ff66723eULL, 0x000fe400020006ffULL, 0x00000064ff64723eULL, 0x000fe400020006ffULL,
0x00000059ff0c723eULL, 0x000fe400020006ffULL, 0x00000010ff5c7819ULL, 0x000fe4000001163aULL,
0x000000ff3a597812ULL, 0x040fe400078ec0ffULL, 0x0000ffff3a557812ULL, 0x000fc400078ec0ffULL,
0x00000010ff5d7819ULL, 0x100fe4000001163bULL, 0x00000018ff727819ULL, 0x000fe4000001163bULL,
0x0000ffff3b587812ULL, 0x000fe400078ec0ffULL, 0x000000381038723cULL, 0x000b620000001820ULL,
0x00005410663c7816ULL, 0x000fe4000000003cULL, 0x00005410643d7816ULL, 0x000fe4000000003dULL,
0x000000ff41417812ULL, 0x000fc400078ec0ffULL, 0x000000ff5e217812ULL, 0x020fe400078ec0ffULL,
0x00000043ff43723eULL, 0x000fe200020006ffULL, 0x0000003c103c723cULL, 0x000b62000000181cULL,
0x00000042ff42723eULL, 0x000fe200020006ffULL, 0x0000000630308232ULL, 0x082fe20000000000ULL,
0x00000021ff21723eULL, 0x000fe200020006ffULL, 0x0000000632328232ULL, 0x000fe20000000000ULL,
0x00000041ff41723eULL, 0x000fe200020006ffULL, 0x0000000731318232ULL, 0x080fe20000000000ULL,
0x00000008ff1f7819ULL, 0x020fe20000011640ULL, 0x0000000733338232ULL, 0x000fe20000000000ULL,
0x00000008ff1e7819ULL, 0x000fc4000001165bULL, 0x0000541043407816ULL, 0x000fe40000000021ULL,
0x0000541042417816ULL, 0x000fe40000000041ULL, 0x00000053ff53723eULL, 0x000fe400020006ffULL,
0x0000001fff1f723eULL, 0x000fe400020006ffULL, 0x0000001eff1e723eULL, 0x000fe200020006ffULL,
0x000000401040723cULL, 0x000b620000001818ULL, 0x000000ff651d7812ULL, 0x000fc400078ec0ffULL,
0x000000ff60607812ULL, 0x000fe400078ec0ffULL, 0x00000008ff5f7819ULL, 0x000fe4000001165fULL,
0x000054101f187816ULL, 0x020fe4000000000dULL, 0x000054101e197816ULL, 0x000fe40000000053ULL,
0x00000008ff617819ULL, 0x000fe40000011661ULL, 0x00000057ff57723eULL, 0x000fc400020006ffULL,
0x00000056ff56723eULL, 0x000fe200020006ffULL, 0x000000181010723cULL, 0x000b620000001814ULL,
0x0000001dff1d723eULL, 0x000fe400020006ffULL, 0x00000052ff52723eULL, 0x000fe400020006ffULL,
0x0000005fff5f723eULL, 0x000fe400020006ffULL, 0x00000060ff15723eULL, 0x020fe400020006ffULL,
0x00000061ff0d723eULL, 0x000fc400020006ffULL, 0x0000541057147816ULL, 0x000fe4000000001dULL,
0x0000541056157816ULL, 0x000fe40000000015ULL, 0x000054105f0c7816ULL, 0x000fe4000000000cULL,
0x000054100d0d7816ULL, 0x000fe40000000052ULL, 0x00000018ff1a7819ULL, 0x000fe20000011644ULL,
0x000000143014723cULL, 0x000b620000001834ULL, 0x000000ff451b7812ULL, 0x000fc400078ec0ffULL,
0x000000ff5c5c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff5d5d7812ULL, 0x000fe400078ec0ffULL,
0x0000001bff53723eULL, 0x000fe400020006ffULL, 0x0000001aff34723eULL, 0x020fe400020006ffULL,
0x00000018ff1c7819ULL, 0x000fe20000011645ULL, 0x0000000c3018723cULL, 0x000b62000000182cULL,
0x00000059ff59723eULL, 0x000fc400020006ffULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x000000ff44227812ULL, 0x000fe400078ec0ffULL, 0x0000005dff2d723eULL, 0x020fe400020006ffULL,
0x0000001cff0c723eULL, 0x000fe400020006ffULL, 0x00005410591c7816ULL, 0x000fe4000000005cULL,
0x000054105a1d7816ULL, 0x000fc4000000002dULL, 0x00000008ff557819ULL, 0x000fe40000011655ULL,
0x00000008ff587819ULL, 0x000fe40000011658ULL, 0x00000022ff5e723eULL, 0x000fe200020006ffULL,
0x0000001c301c723cULL, 0x000b620000001824ULL, 0x00000010ff227819ULL, 0x000fe40000011645ULL,
0x000000ff46237812ULL, 0x000fe400078ec0ffULL, 0x00000072ff20723eULL, 0x000fc400020006ffULL,
0x00000055ff55723eULL, 0x000fe400020006ffULL, 0x00000058ff58723eULL, 0x000fe400020006ffULL,
0x00000023ff2c723eULL, 0x000fe400020006ffULL, 0x000000ff22247812ULL, 0x020fe400078ec0ffULL,
0x0000ffff45667812ULL, 0x000fe400078ec0ffULL, 0x0000541055227816ULL, 0x000fc40000000054ULL,
0x0000541058237816ULL, 0x000fe40000000020ULL, 0x00000010ff217819ULL, 0x000fe40000011644ULL,
0x0000ffff44657812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5b7819ULL, 0x100fe40000011646ULL,
0x00000018ff457819ULL, 0x000fe40000011646ULL, 0x00000010ff647819ULL, 0x000fc40000011647ULL,
0x000000ff47677812ULL, 0x040fe400078ec0ffULL, 0x00000018ff447819ULL, 0x000fe40000011647ULL,
0x00000008ff667819ULL, 0x000fe40000011666ULL, 0x0000ffff46467812ULL, 0x000fe400078ec0ffULL,
0x0000ffff47477812ULL, 0x000fe400078ec0ffULL, 0x000000ff210d7812ULL, 0x000fc400078ec0ffULL,
0x000000223020723cULL, 0x000b620000001828ULL, 0x00000008ff657819ULL, 0x000fe40000011665ULL,
0x000000ff5b5b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff64647812ULL, 0x000fe400078ec0ffULL,
0x00000066ff29723eULL, 0x020fe400020006ffULL, 0x00000008ff467819ULL, 0x000fe40000011646ULL,
0x00000008ff477819ULL, 0x000fc40000011647ULL, 0x0000000dff2f723eULL, 0x000fe400020006ffULL,
0x00000024ff25723eULL, 0x000fe400020006ffULL, 0x00000067ff2d723eULL, 0x000fe400020006ffULL,
0x00000065ff28723eULL, 0x000fe400020006ffULL, 0x0000541029297816ULL, 0x000fe4000000000cULL,
0x0000005bff5b723eULL, 0x000fc400020006ffULL, 0x00000064ff64723eULL, 0x000fe400020006ffULL,
0x00000045ff45723eULL, 0x000fe400020006ffULL, 0x00000044ff44723eULL, 0x000fe400020006ffULL,
0x00000046ff0c723eULL, 0x000fe400020006ffULL, 0x00000047ff0d723eULL, 0x000fe400020006ffULL,
0x000054105e247816ULL, 0x000fc4000000002fULL, 0x0000541053257816ULL, 0x000fe40000000025ULL,
0x0000541028287816ULL, 0x000fe20000000034ULL, 0x0000000200347824ULL, 0x000fe200078e00ffULL,
0x000054102c2c7816ULL, 0x000fe4000000005bULL, 0x000054102d2d7816ULL, 0x000fe20000000064ULL,
0x000000243024723cULL, 0x000f620000001838ULL, 0x000054100c0c7816ULL, 0x000fe40000000045ULL,
0x000054100d0d7816ULL, 0x000fc40000000044ULL, 0xfffffff834347812ULL, 0x000fc600078ec0ffULL,
0x000000283028723cULL, 0x040f70000000183cULL, 0x0000002c302c723cULL, 0x040f700000001840ULL,
0x0000000c3030723cULL, 0x000b6e0000001810ULL, 0x0000f6c8620c7811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x000000000c0c7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6900034ff7f8cULL, 0x0005e4000c80043fULL,
0x0000000000107805ULL, 0x000fc40000015200ULL, 0x0000040004137984ULL, 0x000ee40000000800ULL,
0x8000000013ff7812ULL, 0x00afc4000780480dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff347224ULL, 0x004fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x0000001210357210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e11ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff127819ULL, 0x000fc80000011413ULL, 0x0000003512127211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0613ULL, 0x0000000212127819ULL, 0x000fc80000001213ULL,
0x000000120000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000134347810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040004137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe4000780480dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001000107824ULL, 0x000fe400078e00ffULL,
0x000059000b0b7a24ULL, 0x010fe400078e02ffULL, 0x00000080ff127424ULL, 0x000fe200078e00ffULL,
0xffffffe0100d7812ULL, 0x000fe200078ec0ffULL, 0x000000400b0b7824ULL, 0x000fc800078e00ffULL,
0x00000100480d7824ULL, 0x000fe400078e020dULL, 0x000062000b127625ULL, 0x000fc600078e0012ULL,
0x000000c00d0d7810ULL, 0x000fc80007ffe0ffULL, 0x000000200d0c7812ULL, 0x000fca00078ec0ffULL,
0x000000016f0b7824ULL, 0x000fe200078e020cULL, 0x000003d000009947ULL, 0x000fea0003800000ULL,
0x0000000d6c0c7217ULL, 0x000fe40007800000ULL, 0x0000001010117812ULL, 0x000fe400078ec0ffULL,
0x00000003ff107819ULL, 0x000fe20000011649ULL, 0x000000010c0c7824ULL, 0x000fc600078e0a0dULL,
0x0000000410357810ULL, 0x040fe20007ffe0ffULL, 0x0000000110347824ULL, 0x040fe200078e0211ULL,
0x0000000c110c7217ULL, 0x000fe40007800000ULL, 0x0000000810377810ULL, 0x000fe20007ffe0ffULL,
0x00000001340d7824ULL, 0x000fe400078e0249ULL, 0x000000010c0c7824ULL, 0x100fe400078e0a11ULL,
0x0000000834387824ULL, 0x000fe400078e00ffULL, 0x0000000135367824ULL, 0x040fe200078e0211ULL,
0x0000000c3500720cULL, 0x000fc40003f66070ULL, 0xfffffff838387812ULL, 0x000fe200078ee20dULL,
0x00000001340d7824ULL, 0x000fe200078e020bULL, 0x0000000c10357810ULL, 0x000fe20007ffe0ffULL,
0x0000000836397824ULL, 0x000fe200078e00ffULL, 0x0000000c1000720cULL, 0x080fe20003f86070ULL,
0x0000000136107824ULL, 0x040fe200078e0249ULL, 0x0000000c3700720cULL, 0x080fe20003f46070ULL,
0x0000000136367824ULL, 0x000fe200078e020bULL, 0x0000000c3500720cULL, 0x000fe20003f06070ULL,
0x000000800d0c7825ULL, 0x000fe200078e00ffULL, 0xfffffff8393a7812ULL, 0x000fc600078ee210ULL,
0x0000000137347824ULL, 0x100fe400078e0211ULL, 0x00000001353e7824ULL, 0x000fe200078e0211ULL,
0x000000510c117212ULL, 0x000fe200078efcffULL, 0x0000008036367825ULL, 0x000fc600078e00ffULL,
0x00000011120c7210ULL, 0x000fe20007fbe0ffULL, 0x0000000134357824ULL, 0x040fe400078e0249ULL,
0x00000008343c7824ULL, 0x040fe400078e00ffULL, 0x0000000134107824ULL, 0x100fe400078e020bULL,
0x000000013e347824ULL, 0x000fe200078e020bULL, 0x00000051360b7212ULL, 0x000fe200078efcffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0xfffffff83c3c7812ULL, 0x000fc600078ee235ULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000005110397212ULL, 0x000fc600078efcffULL,
0x00000001130d7824ULL, 0x040fe200028e060dULL, 0x0000000b12367210ULL, 0x000fe20007fbe0ffULL,
0x000000013e3b7824ULL, 0x000fe200078e0249ULL, 0x00000051340b7212ULL, 0x000fe200078efcffULL,
0x000000083e347824ULL, 0x000fe400078e00ffULL, 0x0000000113377824ULL, 0x040fe200028e0637ULL,
0x0000003912107210ULL, 0x000fe20007fbe0ffULL, 0x000000103c397824ULL, 0x100fe200078e024fULL,
0x0000000b12127210ULL, 0x000fe20007fde0ffULL, 0x00000010380b7824ULL, 0x000fe200078e024fULL,
0xfffffff834347812ULL, 0x000fe200078ee23bULL, 0x0000000113117824ULL, 0x000fc400028e0611ULL,
0x0000000113137824ULL, 0x000fe200030e0635ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c0b7faeULL, 0x0003e2000e101c48ULL, 0x000000103a357824ULL, 0x100fe400078e024fULL,
0x00000010343b7824ULL, 0x000fc600078e024fULL, 0x0000000036357faeULL, 0x0003e8000d901c48ULL,
0x0000000010397faeULL, 0x0003e8000d101c48ULL, 0x00000000123b7faeULL, 0x0003e2000c101c48ULL,
0x0000030000007947ULL, 0x000fea0003800000ULL, 0x0000001010107812ULL, 0x000fc800078ec0ffULL,
0x0000001049107211ULL, 0x000fc800078fe8ffULL, 0x0000000410367810ULL, 0x040fe20007ffe0ffULL,
0x00000001100c7824ULL, 0x140fe200078e0249ULL, 0x0000000810347810ULL, 0x040fe20007ffe0ffULL,
0x0000000810357824ULL, 0x040fe200078e00ffULL, 0x0000000c103e7810ULL, 0x000fe20007ffe0ffULL,
0x00000001360d7824ULL, 0x040fe400078e0249ULL, 0x00000008363a7824ULL, 0x000fe200078e00ffULL,
0xfffffff835387812ULL, 0x000fe200078ee20cULL, 0x00000001100c7824ULL, 0x000fe400078e020bULL,
0x0000000134117824ULL, 0x000fe200078e0249ULL, 0xfffffff83a3a7812ULL, 0x000fe200078ee20dULL,
0x00000008343c7824ULL, 0x000fc400078e00ffULL, 0x000000800c0c7825ULL, 0x000fc600078e00ffULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee211ULL, 0x0000000136367824ULL, 0x100fe400078e020bULL,
0x0000000134107824ULL, 0x100fe400078e020bULL, 0x000000013e347824ULL, 0x000fe200078e020bULL,
0x000000510c0b7212ULL, 0x000fe200078efcffULL, 0x000000013e397824ULL, 0x040fe400078e0249ULL,
0x000000083e3e7824ULL, 0x000fe200078e00ffULL, 0x0000000b120c7210ULL, 0x000fe20007f1e0ffULL,
0x0000008036367825ULL, 0x000fc600078e00ffULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee239ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x00000051363b7212ULL, 0x000fc600078efcffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000005110397212ULL, 0x000fe400078efcffULL,
0x0000003b12367210ULL, 0x000fe20007f5e0ffULL, 0x00000001130d7824ULL, 0x040fe200000e060dULL,
0x00000051340b7212ULL, 0x000fe200078efcffULL, 0x000000103e3b7824ULL, 0x000fe200078e024fULL,
0x0000003912107210ULL, 0x040fe20007f1e0ffULL, 0x0000000113377824ULL, 0x000fe200010e0637ULL,
0x0000000b12127210ULL, 0x000fe20007f7e0ffULL, 0x00000010380b7824ULL, 0x000fc400078e024fULL,
0x0000000113117824ULL, 0x040fe400000e0611ULL, 0x0000000113137824ULL, 0x000fe200018e0635ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c0b7faeULL, 0x0003e2000b901c48ULL,
0x000000103a357824ULL, 0x100fe400078e024fULL, 0x000000103c397824ULL, 0x000fc600078e024fULL,
0x0000000036357faeULL, 0x0003e8000b901c48ULL, 0x0000000010397faeULL, 0x0003e8000b901c48ULL,
0x00000000123b7faeULL, 0x0003e4000b901c48ULL, 0x0000000800107824ULL, 0x002fe200078e00ffULL,
0x00000003020c7810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff0b7424ULL, 0x000fc600078e00ffULL,
0xfffffff010107812ULL, 0x000fe400078ec0ffULL, 0x0000006d0c00720cULL, 0x000fe40003f06070ULL,
0x00000000100473c2ULL, 0x000e6200000e0000ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x00000001700c8824ULL, 0x000fc400078e020cULL, 0x00000004ff0d8424ULL, 0x000fc800078e00ffULL,
0x000064000c0c8625ULL, 0x000fca00078e000dULL, 0x000000080c0b8981ULL, 0x000522000c1e1900ULL,
0x0000f6b004047890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x004fec0000008000ULL,
0x00f6b00010107f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f64800080c7f8cULL, 0x0004e4000c80043fULL, 0x0000000000127805ULL, 0x000fc40000015200ULL,
0x00f64c0008357984ULL, 0x000ea40000000800ULL, 0x8000000035ff7812ULL, 0x00cfe4000780480dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff367224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000347805ULL, 0x000fcc0000015200ULL, 0x0000003412377210ULL, 0x000fca0007f1e1ffULL,
0x0000000135357824ULL, 0x000fe200000e0e13ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff347819ULL, 0x000fc80000011435ULL,
0x0000003734347211ULL, 0x000fca00078110ffULL, 0x000000ffff357224ULL, 0x000fca00000e0635ULL,
0x0000000234347819ULL, 0x000fc80000001235ULL, 0x000000340000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000136367810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f64c0008357984ULL, 0x000ea40000000800ULL,
0x8000000035ff7812ULL, 0x004fe4000780480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002000087824ULL, 0x000fca00078e00ffULL, 0xffffff8008087812ULL, 0x000fc800078ec0ffULL,
0x0000010051087810ULL, 0x000fca0007ffe008ULL, 0x0000000179087824ULL, 0x000fca00078e0208ULL,
0x00f0000008347984ULL, 0x000ea80000000800ULL, 0x00f20000080d7984ULL, 0x0006620000000800ULL,
0x000000093400720bULL, 0x004fe20003f1d000ULL, 0x0000b0a27f007947ULL, 0x000fd8000b800000ULL,
0x00000000000c7806ULL, 0x008fc800000e0100ULL, 0x0000ffff0c377812ULL, 0x000fe2000780c0ffULL,
0x000004b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff357424ULL, 0x000fe400078e00ffULL,
0x000000ffff087224ULL, 0x000fd200078e0009ULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x0000000276137810ULL, 0x000fe40007ffe0ffULL, 0x000000093400720bULL, 0x000fe40003f54000ULL,
0x000000001300720cULL, 0x000fe20003f05270ULL, 0x0000b0427f007947ULL, 0x000fd4000b800000ULL,
0x0000000000087806ULL, 0x000fc400010e0100ULL, 0x0000008000128824ULL, 0x000fe200078e0251ULL,
0x00000009340c8209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe40003800000ULL,
0x0000000179138824ULL, 0x000fe200078e0212ULL, 0x0000991008127816ULL, 0x000fc800000000ffULL,
0x00f4000c13008388ULL, 0x0005e20000000800ULL, 0x000000ff1200720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x00000009340c7209ULL, 0x004fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff08ff7812ULL, 0x000fc6000780c0ffULL,
0x000000090c0c7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL,
0x0000000c00357308ULL, 0x000ea40000000800ULL, 0x000000350a0a7220ULL, 0x004fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0c7819ULL, 0x000fe20000011649ULL,
0x0000af627f007947ULL, 0x000fea000b800000ULL, 0x00001f0c350c7589ULL, 0x0004e400000e0000ULL,
0x0000000c14147220ULL, 0x08cfe20000410000ULL, 0x0000000c15157220ULL, 0x080fe20000410000ULL,
0x0000000c18187220ULL, 0x080fe20000410000ULL, 0x0000000c19197220ULL, 0x080fe20000410000ULL,
0x0000000c1c1c7220ULL, 0x080fe20000410000ULL, 0x0000000c1d1d7220ULL, 0x080fe20000410000ULL,
0x0000000c20207220ULL, 0x080fe20000410000ULL, 0x0000000c21217220ULL, 0x080fe20000410000ULL,
0x0000000c24247220ULL, 0x080fe20000410000ULL, 0x0000000c25257220ULL, 0x080fe20000410000ULL,
0x0000000c28287220ULL, 0x080fe20000410000ULL, 0x0000000c29297220ULL, 0x080fe20000410000ULL,
0x0000000c2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000c2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000c30307220ULL, 0x080fe20000410000ULL, 0x0000000c31317220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0008ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008490c7811ULL, 0x000fe200078ff0ffULL,
0x0000ae427f007947ULL, 0x000fea000b800000ULL, 0x00001f0c350c7589ULL, 0x0004e400000e0000ULL,
0x0000000c16167220ULL, 0x08cfe20000410000ULL, 0x0000000c17177220ULL, 0x080fe20000410000ULL,
0x0000000c1a1a7220ULL, 0x080fe20000410000ULL, 0x0000000c1b1b7220ULL, 0x080fe20000410000ULL,
0x0000000c1e1e7220ULL, 0x080fe20000410000ULL, 0x0000000c1f1f7220ULL, 0x080fe20000410000ULL,
0x0000000c22227220ULL, 0x080fe20000410000ULL, 0x0000000c23237220ULL, 0x080fe20000410000ULL,
0x0000000c26267220ULL, 0x080fe20000410000ULL, 0x0000000c27277220ULL, 0x080fe20000410000ULL,
0x0000000c2a2a7220ULL, 0x080fe20000410000ULL, 0x0000000c2b2b7220ULL, 0x080fe20000410000ULL,
0x0000000c2e2e7220ULL, 0x080fe20000410000ULL, 0x0000000c2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000c32327220ULL, 0x080fe20000410000ULL, 0x0000000c33337220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff37ff7812ULL, 0x000fe20007806008ULL,
0x00000001ff357424ULL, 0x000fe200078e00ffULL, 0x0000000934087209ULL, 0x000fd60007810000ULL,
0x8000000834340221ULL, 0x000fe20000010000ULL, 0x00007610ff350816ULL, 0x000fc60000000035ULL,
0x3fb8aa3b34340820ULL, 0x000fc80000410000ULL, 0x0000003400050308ULL, 0x000ea40000000800ULL,
0x000000050d0d0220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000a0d0a7221ULL, 0x002fc40000010000ULL, 0x00000000000c7805ULL, 0x000fca0000015200ULL,
0x0000000800097824ULL, 0x000fca00078e00ffULL, 0xfffffff009347812ULL, 0x000fca00078ec0ffULL,
0x00f6ac0034097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fe4000780480fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff367224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x000000120c127210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e0dULL, 0x003d09001200780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401200780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff097819ULL, 0x000fc80000011413ULL,
0x0000001209097211ULL, 0x000fca00078110ffULL, 0x000000ffff127224ULL, 0x000fca00000e0613ULL,
0x0000000209097819ULL, 0x000fc80000001212ULL, 0x000000090000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000136367810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6ac0034097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe4000780480fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991035097816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0900720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000005ff06723eULL, 0x000fe400000000ffULL, 0x00000002ff0e7819ULL, 0x000fe40000011649ULL,
0x0000541006097816ULL, 0x000fe20000000006ULL, 0x0000a9f27f007947ULL, 0x000fea000b800000ULL,
0x00001f0e09067589ULL, 0x0002a400000e0000ULL, 0x000000080e0c7810ULL, 0x000fe20007ffe0ffULL,
0x0000aa227f007947ULL, 0x000fea000b800000ULL, 0x00001f0c09077589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000100e0c7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff127224ULL, 0x000fe200078e0009ULL, 0x00007c3000137802ULL, 0x000fc40000000f00ULL,
0x0000b08000007944ULL, 0x016fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000180e0c7810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff127224ULL, 0x000fe200078e0009ULL,
0x00007c8000137802ULL, 0x000fc40000000f00ULL, 0x0000b03000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000104c347824ULL, 0x100fe200078e0271ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000104b387824ULL, 0x100fe200078e0271ULL,
0x00a000004d0c783bULL, 0x00ee620000000200ULL, 0x000000104a3c7824ULL, 0x000fc600078e0271ULL,
0x000000003434783bULL, 0x000ea80000004200ULL, 0x000000003838783bULL, 0x000ee20000004200ULL,
0x000000060c0c8232ULL, 0x082fe40000000000ULL, 0x000000060e0e8232ULL, 0x000fe20000000000ULL,
0x00000010ff427819ULL, 0x104fe20000011634ULL, 0x000000070d0d8232ULL, 0x080fe20000000000ULL,
0x000000ff34437812ULL, 0x000fe200078ec0ffULL, 0x000000070f0f8232ULL, 0x000fe20000000000ULL,
0x00000018ff097819ULL, 0x000fc40000011634ULL, 0x0000ffff343e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff417819ULL, 0x100fe40000011635ULL, 0x000000ff35477812ULL, 0x040fe400078ec0ffULL,
0x00000018ff467819ULL, 0x000fe40000011635ULL, 0x0000ffff353f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff127819ULL, 0x000fc40000011636ULL, 0x000000ff36647812ULL, 0x040fe400078ec0ffULL,
0x00000018ff5c7819ULL, 0x000fe40000011636ULL, 0x0000ffff365f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4a7819ULL, 0x100fe40000011637ULL, 0x000000ff37617812ULL, 0x000fe400078ec0ffULL,
0x00000018ff5b7819ULL, 0x000fc40000011637ULL, 0x0000ffff37607812ULL, 0x000fe400078ec0ffULL,
0x000000003c34783bULL, 0x0002a20000004200ULL, 0x000000ff42427812ULL, 0x000fe400078ec0ffULL,
0x000000ff41417812ULL, 0x000fe400078ec0ffULL, 0x00000010ff567819ULL, 0x108fe40000011638ULL,
0x000000ff38597812ULL, 0x000fe400078ec0ffULL, 0x00000018ff4c7819ULL, 0x000fc40000011638ULL,
0x0000ffff38557812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5a7819ULL, 0x100fe40000011639ULL,
0x000000ff39587812ULL, 0x040fe400078ec0ffULL, 0x00000018ff4d7819ULL, 0x000fe40000011639ULL,
0x0000ffff39577812ULL, 0x000fe400078ec0ffULL, 0x00000043ff38723eULL, 0x000fc400020006ffULL,
0x00000047ff39723eULL, 0x000fe400020006ffULL, 0x00000042ff42723eULL, 0x000fe400020006ffULL,
0x00000041ff41723eULL, 0x000fe400020006ffULL, 0x00000010ff137819ULL, 0x100fe4000001163aULL,
0x000000ff3a447812ULL, 0x000fe400078ec0ffULL, 0x00000018ff4b7819ULL, 0x000fc4000001163aULL,
0x0000ffff3a3c7812ULL, 0x002fe400078ec0ffULL, 0x00000010ff3d7819ULL, 0x100fe4000001163bULL,
0x000000ff3b457812ULL, 0x040fe400078ec0ffULL, 0x00000018ff657819ULL, 0x000fe4000001163bULL,
0x0000ffff3b407812ULL, 0x000fe200078ec0ffULL, 0x000000104e3b7824ULL, 0x000fe200078e0271ULL,
0x00000009ff3a723eULL, 0x000fc400020006ffULL, 0x00000046ff09723eULL, 0x000fe400020006ffULL,
0x0000541038387816ULL, 0x000fe40000000042ULL, 0x0000541039397816ULL, 0x000fe40000000041ULL,
0x00000010ff467819ULL, 0x104fe40000011634ULL, 0x000000ff344e7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff5d7819ULL, 0x000fe20000011634ULL, 0x000000380c14723cULL, 0x000f620000001814ULL,
0x0000ffff34417812ULL, 0x000fc400078ec0ffULL, 0x00000010ff427819ULL, 0x100fe40000011635ULL,
0x000000ff35667812ULL, 0x040fe400078ec0ffULL, 0x00000018ff5e7819ULL, 0x000fe40000011635ULL,
0x0000ffff35437812ULL, 0x000fe400078ec0ffULL, 0x000000ff12347812ULL, 0x000fe400078ec0ffULL,
0x000000ff4a357812ULL, 0x000fc400078ec0ffULL, 0x00000064ff64723eULL, 0x000fe400020006ffULL,
0x00000061ff61723eULL, 0x000fe400020006ffULL, 0x00000034ff34723eULL, 0x000fe400020006ffULL,
0x00000035ff35723eULL, 0x000fe400020006ffULL, 0x0000541064347816ULL, 0x000fe40000000034ULL,
0x0000541061357816ULL, 0x000fc40000000035ULL, 0x00000008ff5f7819ULL, 0x000fe4000001165fULL,
0x00000008ff607819ULL, 0x000fe40000011660ULL, 0x0000005cff5c723eULL, 0x000fe200020006ffULL,
0x000000340c1c723cULL, 0x000be2000000181cULL, 0x0000005bff5b723eULL, 0x000fe400020006ffULL,
0x000000ff56567812ULL, 0x000fe400078ec0ffULL, 0x000000ff5a5a7812ULL, 0x000fc400078ec0ffULL,
0x0000005fff34723eULL, 0x020fe400020006ffULL, 0x00000060ff35723eULL, 0x000fe400020006ffULL,
0x0000541034347816ULL, 0x000fe4000000005cULL, 0x0000541035357816ULL, 0x000fe4000000005bULL,
0x00000059ff59723eULL, 0x000fe400020006ffULL, 0x00000058ff58723eULL, 0x000fc400020006ffULL,
0x00000008ff3f7819ULL, 0x000fe2000001163fULL, 0x000000340c20723cULL, 0x000be20000001820ULL,
0x00000008ff3e7819ULL, 0x000fe4000001163eULL, 0x0000003fff39723eULL, 0x000fe400020006ffULL,
0x0000003eff38723eULL, 0x000fe400020006ffULL, 0x00000056ff34723eULL, 0x020fe400020006ffULL,
0x0000005aff35723eULL, 0x000fc400020006ffULL, 0x0000541059347816ULL, 0x000fe40000000034ULL,
0x0000541058357816ULL, 0x000fe40000000035ULL, 0x0000541039397816ULL, 0x000fe40000000009ULL,
0x00000010ff3e7819ULL, 0x100fe40000011636ULL, 0x000000ff36527812ULL, 0x000fe400078ec0ffULL,
0x00000018ff537819ULL, 0x000fc40000011636ULL, 0x0000ffff36097812ULL, 0x000fe400078ec0ffULL,
0x00000010ff3f7819ULL, 0x100fe40000011637ULL, 0x000000ff37547812ULL, 0x040fe400078ec0ffULL,
0x00000018ff477819ULL, 0x000fe40000011637ULL, 0x0000ffff37127812ULL, 0x000fe400078ec0ffULL,
0x000000340c34723cULL, 0x000be20000001824ULL, 0x0000541038387816ULL, 0x000fe2000000003aULL,
0x00a000005024783bULL, 0x020e620000000200ULL, 0x00000008ff557819ULL, 0x000fc40000011655ULL,
0x00000008ff577819ULL, 0x000fe40000011657ULL, 0x000000ff13137812ULL, 0x000fe200078ec0ffULL,
0x000000380c18723cULL, 0x000b620000001818ULL, 0x000000ff3d3d7812ULL, 0x000fe200078ec0ffULL,
0x000000003b38783bULL, 0x020ea20000004200ULL, 0x00000008ff3c7819ULL, 0x000fe4000001163cULL,
0x00000008ff407819ULL, 0x000fe40000011640ULL, 0x0000004cff4c723eULL, 0x000fc400020006ffULL,
0x0000004dff4d723eULL, 0x000fe400020006ffULL, 0x00000044ff44723eULL, 0x000fe400020006ffULL,
0x00000045ff45723eULL, 0x000fe400020006ffULL, 0x0000004bff4a723eULL, 0x000fe400020006ffULL,
0x00000055ff55723eULL, 0x000fe400020006ffULL, 0x00000057ff57723eULL, 0x000fc400020006ffULL,
0x00000013ff13723eULL, 0x000fe400020006ffULL, 0x0000003dff3d723eULL, 0x000fe400020006ffULL,
0x00000065ff4b723eULL, 0x000fe400020006ffULL, 0x0000003cff3c723eULL, 0x000fe400020006ffULL,
0x00000040ff40723eULL, 0x000fe400020006ffULL, 0x00005410554c7816ULL, 0x000fc4000000004cULL,
0x00005410574d7816ULL, 0x000fe2000000004dULL, 0x0000000624248232ULL, 0x082fe20000000000ULL,
0x0000541044447816ULL, 0x000fe20000000013ULL, 0x0000000626268232ULL, 0x000fe20000000000ULL,
0x0000541045457816ULL, 0x000fe2000000003dULL, 0x0000000725258232ULL, 0x080fe20000000000ULL,
0x000054103c4a7816ULL, 0x000fe2000000004aULL, 0x0000004c0c28723cULL, 0x000f620000001828ULL,
0x00005410404b7816ULL, 0x000fe2000000004bULL, 0x0000000727278232ULL, 0x000fe20000000000ULL,
0x000000ff46467812ULL, 0x000fc400078ec0ffULL, 0x000000ff42427812ULL, 0x000fe400078ec0ffULL,
0x0000004eff4e723eULL, 0x000fe200020006ffULL, 0x000000440c2c723cULL, 0x040f62000000182cULL,
0x00000066ff56723eULL, 0x000fe400020006ffULL, 0x00000046ff46723eULL, 0x000fe400020006ffULL,
0x00000008ff417819ULL, 0x000fe40000011641ULL, 0x00000008ff437819ULL, 0x000fe20000011643ULL,
0x0000004a0c0c723cULL, 0x000b620000001830ULL, 0x0000005dff59723eULL, 0x000fc400020006ffULL,
0x0000005eff5a723eULL, 0x000fe400020006ffULL, 0x00000010ff587819ULL, 0x004fe40000011638ULL,
0x00000042ff31723eULL, 0x020fe400020006ffULL, 0x000054104e307816ULL, 0x000fe40000000046ULL,
0x0000541056317816ULL, 0x000fe40000000031ULL, 0x000000ff38607812ULL, 0x000fc400078ec0ffULL,
0x00000018ff5e7819ULL, 0x000fe40000011638ULL, 0x0000ffff38507812ULL, 0x000fe200078ec0ffULL,
0x000000302414723cULL, 0x000b620000001814ULL, 0x00000010ff5b7819ULL, 0x100fe40000011639ULL,
0x000000ff395f7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff5d7819ULL, 0x000fe40000011639ULL,
0x00000041ff30723eULL, 0x020fc400020006ffULL, 0x00000043ff31723eULL, 0x000fe400020006ffULL,
0x0000ffff39557812ULL, 0x000fe400078ec0ffULL, 0x00000010ff4c7819ULL, 0x100fe4000001163aULL,
0x000000ff3a5c7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff397819ULL, 0x000fe4000001163aULL,
0x00000010ff4d7819ULL, 0x000fc4000001163bULL, 0x000000ff3b577812ULL, 0x000fe400078ec0ffULL,
0x00000018ff387819ULL, 0x000fe4000001163bULL, 0x0000541030307816ULL, 0x000fe40000000059ULL,
0x0000541031317816ULL, 0x000fe4000000005aULL, 0x0000ffff3a3a7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff3b3b7812ULL, 0x000fc400078ec0ffULL, 0x00000008ff557819ULL, 0x000fe20000011655ULL,
0x000000302418723cULL, 0x000b620000001818ULL, 0x000000ff3e3e7812ULL, 0x000fe400078ec0ffULL,
0x000000ff3f3f7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff097819ULL, 0x000fe40000011609ULL,
0x00000008ff127819ULL, 0x000fe40000011612ULL, 0x000000ff58587812ULL, 0x000fc400078ec0ffULL,
0x000000ff5b5b7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff507819ULL, 0x000fe40000011650ULL,
0x000000ff4c4c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff4d4d7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff3a7819ULL, 0x000fe4000001163aULL, 0x00000008ff3b7819ULL, 0x000fc4000001163bULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x00000055ff33723eULL, 0x000fe400020006ffULL,
0x00000052ff52723eULL, 0x000fe400020006ffULL, 0x00000054ff54723eULL, 0x000fe400020006ffULL,
0x00000053ff53723eULL, 0x000fe400020006ffULL, 0x00000047ff47723eULL, 0x000fc400020006ffULL,
0x00000060ff13723eULL, 0x000fe400020006ffULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x0000005eff32723eULL, 0x000fe400020006ffULL, 0x0000003eff30723eULL, 0x020fe400020006ffULL,
0x0000003fff31723eULL, 0x000fe400020006ffULL, 0x00000009ff46723eULL, 0x000fe200020006ffULL,
0x0000000200097824ULL, 0x000fe200078e00ffULL, 0x00000012ff12723eULL, 0x000fc400020006ffULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x00000058ff58723eULL, 0x000fe400020006ffULL,
0x0000005bff5b723eULL, 0x000fe400020006ffULL, 0x00000057ff57723eULL, 0x000fe400020006ffULL,
0x00000050ff50723eULL, 0x000fe400020006ffULL, 0x0000004cff4c723eULL, 0x000fc400020006ffULL,
0x0000004dff4d723eULL, 0x000fe400020006ffULL, 0x00000039ff39723eULL, 0x000fe400020006ffULL,
0x00000038ff38723eULL, 0x000fe400020006ffULL, 0x0000003aff3a723eULL, 0x000fe400020006ffULL,
0x0000003bff3b723eULL, 0x000fe400020006ffULL, 0x0000541033337816ULL, 0x000fc4000000005dULL,
0x0000541052307816ULL, 0x000fe40000000030ULL, 0x0000541054317816ULL, 0x000fe40000000031ULL,
0x0000541046467816ULL, 0x000fe40000000053ULL, 0x0000541012477816ULL, 0x000fe40000000047ULL,
0x00005410135e7816ULL, 0x000fe20000000058ULL, 0x00000030241c723cULL, 0x000f62000000181cULL,
0x000054105f5f7816ULL, 0x000fc4000000005bULL, 0x0000541050327816ULL, 0x000fe40000000032ULL,
0x000054105c5c7816ULL, 0x000fe4000000004cULL, 0x00005410575d7816ULL, 0x000fe2000000004dULL,
0x000000462420723cULL, 0x000f620000001820ULL, 0x000054103a3a7816ULL, 0x000fe40000000039ULL,
0x000054103b3b7816ULL, 0x000fe40000000038ULL, 0xfffffff809097812ULL, 0x000fc600078ec0ffULL,
0x0000005e2434723cULL, 0x040f700000001834ULL, 0x000000322428723cULL, 0x040f700000001828ULL,
0x0000005c242c723cULL, 0x040f70000000182cULL, 0x0000003a2424723cULL, 0x000b6e000000180cULL,
0x0000f6c8620e7811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x000000000e0e7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6980009ff7f8cULL, 0x0005e4000c80043fULL, 0x00000000000c7805ULL, 0x000fc40000015200ULL,
0x0000040004097984ULL, 0x004ea40000000800ULL, 0x8000000009ff7812ULL, 0x006fc4000780480fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff307224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x000000120c127210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e0dULL, 0x003d09001200780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401200780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff097819ULL, 0x000fc80000011413ULL,
0x0000001209097211ULL, 0x000fca00078110ffULL, 0x000000ffff127224ULL, 0x000fca00000e0613ULL,
0x0000000209097819ULL, 0x000fc80000001212ULL, 0x000000090000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000130307810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040004097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe4000780480fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001480f7810ULL, 0x000fe40007ffe0ffULL, 0x0000000302027810ULL, 0x000fe40007ffe0ffULL,
0x0000006e0f00720cULL, 0x000fda0003f06070ULL, 0x0000083000000947ULL, 0x000fea0003800000ULL,
0x0000000248097810ULL, 0x000fe20007ffe0ffULL, 0x000001000f0f7824ULL, 0x000fe400078e027dULL,
0x000059000b0b7a24ULL, 0x010fe200078e02ffULL, 0x0000006e0900720cULL, 0x000fe20003f06070ULL,
0x00000080ff0c7424ULL, 0x000fe200078e00ffULL, 0x000000200f027812ULL, 0x000fe200078ec0ffULL,
0x000000400b0b7824ULL, 0x000fc800078e00ffULL, 0x000000016f327824ULL, 0x000fe400078e0202ULL,
0x000062000b0c7625ULL, 0x000fc800078e000cULL, 0x000003e000008947ULL, 0x000fea0003800000ULL,
0x0000000f6c027217ULL, 0x000fe20007800000ULL, 0x0000001000097824ULL, 0x000fe200078e00ffULL,
0x00000003ff0b7819ULL, 0x000fc60000011649ULL, 0x0000000102027824ULL, 0x000fe200078e0a0fULL,
0x0000001009097812ULL, 0x000fe400078ec0ffULL, 0x000000040b0e7810ULL, 0x000fe40007ffe0ffULL,
0x0000000209027217ULL, 0x000fe40007800000ULL, 0x000000080b0f7810ULL, 0x040fe20007ffe0ffULL,
0x000000010e307824ULL, 0x100fe200078e0209ULL, 0x0000000c0b137810ULL, 0x000fe20007ffe0ffULL,
0x0000000102027824ULL, 0x000fc400078e0a09ULL, 0x000000010f127824ULL, 0x100fe400078e0209ULL,
0x0000000113337824ULL, 0x100fe200078e0209ULL, 0x000000020b00720cULL, 0x0c0fe20003f86070ULL,
0x000000010b0b7824ULL, 0x000fe200078e0209ULL, 0x000000020e00720cULL, 0x080fe20003f66070ULL,
0x0000000130097824ULL, 0x100fe200078e0249ULL, 0x000000020f00720cULL, 0x080fe20003f46070ULL,
0x000000080b0f7824ULL, 0x000fe200078e00ffULL, 0x000000021300720cULL, 0x000fe20003f06070ULL,
0x000000010b027824ULL, 0x000fc400078e0249ULL, 0x000000010b0e7824ULL, 0x000fe400078e0232ULL,
0x0000000830387824ULL, 0x040fe200078e00ffULL, 0xfffffff80f027812ULL, 0x000fe200078ee202ULL,
0x0000000130307824ULL, 0x000fe400078e0232ULL, 0x00000001120b7824ULL, 0x000fe200078e0249ULL,
0xfffffff838387812ULL, 0x000fe200078ee209ULL, 0x00000008123a7824ULL, 0x000fe400078e00ffULL,
0x000000800e0e7825ULL, 0x000fc600078e00ffULL, 0xfffffff83a3a7812ULL, 0x000fe200078ee20bULL,
0x0000008030307825ULL, 0x000fe200078e00ffULL, 0x000000510e0b7212ULL, 0x000fc600078efcffULL,
0x0000000112127824ULL, 0x100fe200078e0232ULL, 0x0000005130097212ULL, 0x000fe200078efcffULL,
0x0000000133327824ULL, 0x040fe200078e0232ULL, 0x0000000b0c0e7210ULL, 0x040fe20007fbe0ffULL,
0x0000000133397824ULL, 0x040fe200078e0249ULL, 0x000000090c307210ULL, 0x000fe20007fde0ffULL,
0x00000008333c7824ULL, 0x000fe400078e00ffULL, 0x0000008012127825ULL, 0x000fc600078e00ffULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee239ULL, 0x0000008032327825ULL, 0x000fe200078e00ffULL,
0x00000051120b7212ULL, 0x000fc600078efcffULL, 0x000000010d0f7824ULL, 0x040fe200028e060fULL,
0x0000005132097212ULL, 0x000fe200078efcffULL, 0x000000010d317824ULL, 0x040fe200030e0631ULL,
0x0000000b0c127210ULL, 0x000fe20007fbe0ffULL, 0x0000001002397824ULL, 0x100fe200078e0271ULL,
0x000000090c0c7210ULL, 0x000fe20007fde0ffULL, 0x00000010383b7824ULL, 0x100fe400078e0271ULL,
0x000000103a097824ULL, 0x000fe200078e0271ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e397faeULL, 0x0003e2000e101c48ULL, 0x000000010d137824ULL, 0x000fc400028e0613ULL,
0x000000103c717824ULL, 0x000fe200078e0271ULL, 0x00000000303b7faeULL, 0x0003e2000d901c48ULL,
0x000000010d0d7824ULL, 0x000fc600030e0633ULL, 0x0000000012097faeULL, 0x0003e8000d101c48ULL,
0x000000000c717faeULL, 0x0003e2000c101c48ULL, 0x0000031000007947ULL, 0x000fea0003800000ULL,
0x0000001000027824ULL, 0x000fca00078e00ffULL, 0x0000001002027812ULL, 0x000fc800078ec0ffULL,
0x0000000249027211ULL, 0x000fc800078fe8ffULL, 0x00000004020b7810ULL, 0x040fe20007ffe0ffULL,
0x00000001020e7824ULL, 0x140fe200078e0232ULL, 0x0000000802137810ULL, 0x040fe20007ffe0ffULL,
0x0000000102097824ULL, 0x140fe200078e0249ULL, 0x0000000c02317810ULL, 0x040fe20007ffe0ffULL,
0x0000000802387824ULL, 0x000fe400078e00ffULL, 0x000000010b127824ULL, 0x040fe400078e0232ULL,
0x000000010b027824ULL, 0x040fe200078e0249ULL, 0xfffffff838387812ULL, 0x000fe200078ee209ULL,
0x000000080b337824ULL, 0x000fc400078e00ffULL, 0x0000000113307824ULL, 0x040fe400078e0232ULL,
0x00000001130b7824ULL, 0x000fe200078e0249ULL, 0xfffffff833027812ULL, 0x000fe200078ee202ULL,
0x00000008133a7824ULL, 0x000fe400078e00ffULL, 0x000000800e0e7825ULL, 0x000fc600078e00ffULL,
0xfffffff83a3a7812ULL, 0x000fe200078ee20bULL, 0x0000000131137824ULL, 0x040fe200078e0249ULL,
0x000000510e097212ULL, 0x000fe200078efcffULL, 0x00000008313c7824ULL, 0x040fe400078e00ffULL,
0x0000000131327824ULL, 0x000fe200078e0232ULL, 0x000000090c0e7210ULL, 0x000fe20007f1e0ffULL,
0x0000008030307825ULL, 0x000fe200078e00ffULL, 0xfffffff83c3c7812ULL, 0x000fc600078ee213ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x00000051300b7212ULL, 0x000fc600078efcffULL,
0x0000008032327825ULL, 0x000fe200078e00ffULL, 0x0000005112397212ULL, 0x000fe400078efcffULL,
0x0000000b0c307210ULL, 0x000fe20007f5e0ffULL, 0x000000010d0f7824ULL, 0x040fe200000e060fULL,
0x0000005132097212ULL, 0x000fe200078efcffULL, 0x00000010383b7824ULL, 0x100fe200078e0271ULL,
0x000000390c127210ULL, 0x000fe20007f1e0ffULL, 0x00000010023d7824ULL, 0x100fe200078e0271ULL,
0x000000090c0c7210ULL, 0x000fe20007f7e0ffULL, 0x000000103a3f7824ULL, 0x000fe200078e0271ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e3b7faeULL, 0x0003e2000b901c48ULL,
0x000000010d137824ULL, 0x000fc400000e0613ULL, 0x000000010d317824ULL, 0x040fe400010e0631ULL,
0x000000103c717824ULL, 0x000fe200078e0271ULL, 0x00000000123d7faeULL, 0x0003e2000b901c48ULL,
0x000000010d0d7824ULL, 0x000fc600018e0633ULL, 0x00000000303f7faeULL, 0x0003e8000b901c48ULL,
0x000000000c717faeULL, 0x0003e4000b901c48ULL, 0x0000000475027810ULL, 0x000fe20007ffe0ffULL,
0x0000008000007945ULL, 0x000fe20003800000ULL, 0xffffffffff0b7424ULL, 0x000fe400078e00ffULL,
0x0000006d0200720cULL, 0x000fda0003f06070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x00000001700c7824ULL, 0x002fe400078e0202ULL, 0x00000004ff0d7424ULL, 0x000fc800078e00ffULL,
0x000064000c0c7625ULL, 0x000fca00078e000dULL, 0x000000080c0b7981ULL, 0x000324000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000800097824ULL, 0x002fca00078e00ffULL,
0xfffffff009097812ULL, 0x000fc800078ec0ffULL, 0x00000000090473c2ULL, 0x000e6200000e0000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000f6a804047890ULL, 0x002fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6a800090c7f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f66800030e7f8cULL, 0x000664000c80043fULL,
0x0000000000127805ULL, 0x000fc40000015200ULL, 0x00f66c0003097984ULL, 0x002e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe4000780480fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff327224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000307805ULL, 0x000fcc0000015200ULL,
0x00000030120c7210ULL, 0x004fca0007f1e1ffULL, 0x0000000131307824ULL, 0x000fe200000e0e13ULL,
0x003d09000c00780cULL, 0x000fc80003f06070ULL, 0x000000ff3000720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400c00780cULL, 0x000fc80003f06070ULL,
0x000000ff3000720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff097819ULL, 0x000fc80000011430ULL, 0x0000000c09097211ULL, 0x000fca00078110ffULL,
0x000000ffff0c7224ULL, 0x000fca00000e0630ULL, 0x0000000209097819ULL, 0x000fc8000000120cULL,
0x000000090000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000132327810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f66c0003097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fe4000780480fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000180760c7811ULL, 0x004fc800078e38ffULL,
0x0000000c790c7210ULL, 0x000fca0007ffe051ULL, 0x00f000000c0f7984ULL, 0x000e680000000800ULL,
0x00f200000c0e7984ULL, 0x0004e20000000800ULL, 0x000000080f00720bULL, 0x002fe20003f1d000ULL,
0x00008c327f007947ULL, 0x000fd8000b800000ULL, 0x00000000000c7806ULL, 0x004fc800000e0100ULL,
0x0000ffff0c307812ULL, 0x000fe2000780c0ffULL, 0x000004b000007945ULL, 0x000fe20003800000ULL,
0x00000001ff0c7424ULL, 0x000fe400078e00ffULL, 0x000000ffff097224ULL, 0x000fd200078e0008ULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x0000000376097810ULL, 0x000fe40007ffe0ffULL,
0x000000080f00720bULL, 0x000fe40003f54000ULL, 0x000000000900720cULL, 0x000fe20003f05270ULL,
0x00008bd27f007947ULL, 0x000fd4000b800000ULL, 0x0000000000097806ULL, 0x000fc400010e0100ULL,
0x0000008000128824ULL, 0x000fe200078e0251ULL, 0x000000080f0c8209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe40003800000ULL, 0x0000000179798824ULL, 0x000fe200078e0212ULL,
0x0000991009127816ULL, 0x000fc800000000ffULL, 0x00f4000c79008388ULL, 0x0003e20000000800ULL,
0x000000ff1200720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x000000080f137209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff09ff7812ULL, 0x000fc6000780c0ffULL, 0x00000008130c7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL, 0x0000000c00317308ULL, 0x000e640000000800ULL,
0x000000310a0a7220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff0c7819ULL, 0x000fe20000011649ULL, 0x00008af27f007947ULL, 0x000fea000b800000ULL,
0x00001f0c310c7589ULL, 0x0002a400000e0000ULL, 0x0000000c14147220ULL, 0x084fe20000410000ULL,
0x0000000c15157220ULL, 0x080fe20000410000ULL, 0x0000000c18187220ULL, 0x080fe20000410000ULL,
0x0000000c19197220ULL, 0x080fe20000410000ULL, 0x0000000c1c1c7220ULL, 0x080fe20000410000ULL,
0x0000000c1d1d7220ULL, 0x080fe20000410000ULL, 0x0000000c20207220ULL, 0x080fe20000410000ULL,
0x0000000c21217220ULL, 0x080fe20000410000ULL, 0x0000000c34347220ULL, 0x080fe20000410000ULL,
0x0000000c35357220ULL, 0x080fe20000410000ULL, 0x0000000c28287220ULL, 0x080fe20000410000ULL,
0x0000000c29297220ULL, 0x080fe20000410000ULL, 0x0000000c2c2c7220ULL, 0x080fe20000410000ULL,
0x0000000c2d2d7220ULL, 0x080fe20000410000ULL, 0x0000000c24247220ULL, 0x080fe20000410000ULL,
0x0000000c25257220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0009ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008490c7811ULL, 0x000fe200078ff0ffULL, 0x000089d27f007947ULL, 0x000fea000b800000ULL,
0x00001f0c310c7589ULL, 0x00046400000e0000ULL, 0x0000000c16167220ULL, 0x086fe20000410000ULL,
0x0000000c17177220ULL, 0x080fe20000410000ULL, 0x0000000c1a1a7220ULL, 0x080fe20000410000ULL,
0x0000000c1b1b7220ULL, 0x080fe20000410000ULL, 0x0000000c1e1e7220ULL, 0x080fe20000410000ULL,
0x0000000c1f1f7220ULL, 0x080fe20000410000ULL, 0x0000000c22227220ULL, 0x080fe20000410000ULL,
0x0000000c23237220ULL, 0x080fe20000410000ULL, 0x0000000c36367220ULL, 0x080fe20000410000ULL,
0x0000000c37377220ULL, 0x080fe20000410000ULL, 0x0000000c2a2a7220ULL, 0x080fe20000410000ULL,
0x0000000c2b2b7220ULL, 0x080fe20000410000ULL, 0x0000000c2e2e7220ULL, 0x080fe20000410000ULL,
0x0000000c2f2f7220ULL, 0x080fe20000410000ULL, 0x0000000c26267220ULL, 0x080fe20000410000ULL,
0x0000000c27277220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff30ff7812ULL, 0x000fe20007806009ULL, 0x00000001ff0c7424ULL, 0x000fe200078e00ffULL,
0x000000080f097209ULL, 0x000fd60007810000ULL, 0x800000090f0f0221ULL, 0x000fe20000010000ULL,
0x00007610ff0c0816ULL, 0x000fc6000000000cULL, 0x3fb8aa3b0f0f0820ULL, 0x000fc80000410000ULL,
0x0000000f00050308ULL, 0x000e640000000800ULL, 0x000000050e0e0220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000a0e0a7221ULL, 0x008fc40000010000ULL,
0x00000000000e7805ULL, 0x000fca0000015200ULL, 0x0000000800087824ULL, 0x000fca00078e00ffULL,
0xfffffff008307812ULL, 0x000fca00078ec0ffULL, 0x00f6b40030137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff327224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x000000120e317210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e0fULL,
0x003d09003100780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403100780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc80000011413ULL, 0x0000003108087211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0613ULL, 0x0000000208087819ULL, 0x000fc80000001213ULL,
0x000000080000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000132327810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f6b40030137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099100c087816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff0800720cULL, 0x000fda0003f05270ULL,
0x0000012000000947ULL, 0x000fea0003800000ULL, 0x00000005ff06723eULL, 0x000fe400000000ffULL,
0x00000002ff0f7819ULL, 0x000fe40000011649ULL, 0x0000541006087816ULL, 0x000fe20000000006ULL,
0x000085827f007947ULL, 0x000fea000b800000ULL, 0x00001f0f08067589ULL, 0x0002a400000e0000ULL,
0x000000080f0c7810ULL, 0x000fe20007ffe0ffULL, 0x000085b27f007947ULL, 0x000fea000b800000ULL,
0x00001f0c08077589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000100f0c7810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff127224ULL, 0x000fe200078e0008ULL,
0x0000a26000137802ULL, 0x000fc40000000f00ULL, 0x00008a5000007944ULL, 0x016fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000180f0c7810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff127224ULL, 0x000fe200078e0008ULL, 0x0000a2b000137802ULL, 0x000fc40000000f00ULL,
0x00008a0000007944ULL, 0x012fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000080076307824ULL, 0x040fe200078e0274ULL,
0x0000000376547810ULL, 0x000fc40007ffe0ffULL, 0x000000006b68783bULL, 0x000ee20000004200ULL,
0x00000004000e7824ULL, 0x000fe200078e00ffULL, 0x0000000749087812ULL, 0x00afc400078ec0ffULL,
0x000000006310783bULL, 0x000fe20000004200ULL, 0x00000008490c7812ULL, 0x004fe400078ec0ffULL,
0x000000040e0f7812ULL, 0x000fe200078ec0ffULL, 0x00a800003030783bULL, 0x000e620000000200ULL,
0x0000000808387812ULL, 0x100fe400078ef849ULL, 0x000000020f087812ULL, 0x000fe400078efcffULL,
0x000000070c397812ULL, 0x000fe200078ef849ULL, 0x0000000838387824ULL, 0x000fe200078e00ffULL,
0x0000000849087211ULL, 0x000fc400078fe0ffULL, 0x00000010393b7812ULL, 0x040fe200078efcffULL,
0x0000000839457824ULL, 0x000fe200078e00ffULL, 0x0000000273737810ULL, 0x000fe20007ffe0ffULL,
0x00000001390c7824ULL, 0x100fe400078e0208ULL, 0x000000013b087824ULL, 0x040fe200078e0208ULL,
0xfffffff838737812ULL, 0x000fe200078ee273ULL, 0x000000083b3b7824ULL, 0x000fe200078e00ffULL,
0xfffffff8454e7812ULL, 0x000fc800078ee20cULL, 0xfffffff83b527812ULL, 0x000fe200078ee208ULL,
0x000000104e3b7824ULL, 0x000fc800078e024fULL, 0x00000010524f7824ULL, 0x000fe200078e024fULL,
0x00000010ff3d7819ULL, 0x100fe40000011668ULL, 0x00000010ff3c7819ULL, 0x000fe40000011669ULL,
0x000000ff68437812ULL, 0x000fe400078ec0ffULL, 0x00000018ff3e7819ULL, 0x000fe40000011668ULL,
0x000000ff3d3d7812ULL, 0x000fe200078ec0ffULL, 0x0000000630308232ULL, 0x082fe20000000000ULL,
0x000000ff69507812ULL, 0x000fe200078ec0ffULL, 0x0000000632328232ULL, 0x000fe20000000000ULL,
0x000000ff3c3c7812ULL, 0x000fe200078ec0ffULL, 0x0000000731318232ULL, 0x080fe20000000000ULL,
0x00000010ff387819ULL, 0x000fe20000011610ULL, 0x0000000733338232ULL, 0x000fe20000000000ULL,
0x000000ff10587812ULL, 0x000fc400078ec0ffULL, 0x00000018ff407819ULL, 0x000fe40000011610ULL,
0x0000ffff104a7812ULL, 0x000fe200078ec0ffULL, 0x0000008054107824ULL, 0x000fe200078e0273ULL,
0x00000043ff52723eULL, 0x000fe400020006ffULL, 0x0000003eff53723eULL, 0x000fe400020006ffULL,
0x0000003dff3d723eULL, 0x000fe400020006ffULL, 0x00000050ff54723eULL, 0x000fc400020006ffULL,
0x0000003cff3e723eULL, 0x000fe400020006ffULL, 0x00005410523c7816ULL, 0x000fe4000000003dULL,
0x00005410543d7816ULL, 0x000fe4000000003eULL, 0x00000018ff3f7819ULL, 0x000fe40000011669ULL,
0x0000ffff68687812ULL, 0x000fe400078ec0ffULL, 0x0000ffff69697812ULL, 0x000fc400078ec0ffULL,
0x00000010ff0e7819ULL, 0x000fe4000001166aULL, 0x00000010ff0f7819ULL, 0x000fe4000001166bULL,
0x0000900010107811ULL, 0x000fe400078e20ffULL, 0x0000003fff55723eULL, 0x000fe400020006ffULL,
0x0000003c303c723cULL, 0x000be20000001814ULL, 0x000000ff6a567812ULL, 0x000fe400078ec0ffULL,
0x000000ff6b577812ULL, 0x000fc400078ec0ffULL, 0x00000008ff687819ULL, 0x000fe40000011668ULL,
0x00000008ff697819ULL, 0x000fe40000011669ULL, 0x000000ff0e147812ULL, 0x020fe400078ec0ffULL,
0x000000ff0f157812ULL, 0x000fe400078ec0ffULL, 0x00000010ff4b7819ULL, 0x000fe40000011611ULL,
0x000000ff11517812ULL, 0x000fc400078ec0ffULL, 0x00000018ff397819ULL, 0x000fe40000011611ULL,
0x0000ffff114c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff457819ULL, 0x100fe40000011612ULL,
0x000000ff123a7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff467819ULL, 0x000fe40000011612ULL,
0x0000ffff12087812ULL, 0x000fc400078ec0ffULL, 0x00000010ff477819ULL, 0x100fe40000011613ULL,
0x000000ff134d7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff0c7819ULL, 0x000fe40000011613ULL,
0x0000ffff13447812ULL, 0x000fe400078ec0ffULL, 0x000000001010783bULL, 0x000e620000000200ULL,
0x00000056ff50723eULL, 0x000fe400020006ffULL, 0x00000057ff43723eULL, 0x000fc400020006ffULL,
0x00000068ff68723eULL, 0x000fe400020006ffULL, 0x00000069ff69723eULL, 0x000fe400020006ffULL,
0x00000014ff14723eULL, 0x000fe400020006ffULL, 0x00000015ff15723eULL, 0x000fe400020006ffULL,
0x00005410680e7816ULL, 0x000fe40000000053ULL, 0x00005410690f7816ULL, 0x000fc40000000055ULL,
0x0000541050147816ULL, 0x000fe40000000014ULL, 0x0000541043157816ULL, 0x000fe40000000015ULL,
0x000000ff38387812ULL, 0x000fe200078ec0ffULL, 0x0000000e3018723cULL, 0x000b620000001818ULL,
0x000000ff4b4b7812ULL, 0x000fe400078ec0ffULL, 0x00000038ff50723eULL, 0x000fe400020006ffULL,
0x00000051ff51723eULL, 0x000fc400020006ffULL, 0x0000003aff0f723eULL, 0x020fe200020006ffULL,
0x000000143014723cULL, 0x000b62000000181cULL, 0x0000004bff4b723eULL, 0x000fe400020006ffULL,
0x00000008ff4a7819ULL, 0x000fe4000001164aULL, 0x00000008ff4c7819ULL, 0x000fe4000001164cULL,
0x00000039ff1c723eULL, 0x020fe400020006ffULL, 0x000000003b38783bULL, 0x000ea20000004200ULL,
0x0000541051517816ULL, 0x000fe2000000004bULL, 0x0000000610108232ULL, 0x082fe20000000000ULL,
0x00000040ff0e723eULL, 0x000fe200020006ffULL, 0x0000000612128232ULL, 0x000fe20000000000ULL,
0x0000004aff4a723eULL, 0x000fe200020006ffULL, 0x0000000711118232ULL, 0x080fe20000000000ULL,
0x0000004cff4b723eULL, 0x000fe200020006ffULL, 0x0000000713138232ULL, 0x000fe20000000000ULL,
0x00000018ff427819ULL, 0x000fc4000001166aULL, 0x00000018ff417819ULL, 0x000fe4000001166bULL,
0x0000ffff6a6a7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff6b6b7812ULL, 0x000fe400078ec0ffULL,
0x000054104a4a7816ULL, 0x000fe4000000000eULL, 0x000054104b4b7816ULL, 0x000fe4000000001cULL,
0x00000008ff6a7819ULL, 0x000fc4000001166aULL, 0x00000008ff6b7819ULL, 0x000fe4000001166bULL,
0x000000ff45457812ULL, 0x000fe200078ec0ffULL, 0x0000004a101c723cULL, 0x000be20000001818ULL,
0x000000ff47477812ULL, 0x000fe400078ec0ffULL, 0x00000042ff42723eULL, 0x000fe400020006ffULL,
0x00000041ff41723eULL, 0x000fe400020006ffULL, 0x0000006aff40723eULL, 0x000fc400020006ffULL,
0x0000006bff6b723eULL, 0x000fe400020006ffULL, 0x0000004dff4d723eULL, 0x000fe400020006ffULL,
0x00000045ff45723eULL, 0x000fe400020006ffULL, 0x00000047ff19723eULL, 0x020fe400020006ffULL,
0x00000058ff4e723eULL, 0x000fe400020006ffULL, 0x0000541040407816ULL, 0x000fc40000000042ULL,
0x000054106b417816ULL, 0x000fe40000000041ULL, 0x00000008ff087819ULL, 0x000fe40000011608ULL,
0x000054100f187816ULL, 0x000fe40000000045ULL, 0x000054104d197816ULL, 0x000fe20000000019ULL,
0x000000403040723cULL, 0x000f620000001820ULL, 0x000054104e507816ULL, 0x000fe40000000050ULL,
0x000000ff384b7812ULL, 0x004fc400078ec0ffULL, 0x00000010ff4c7819ULL, 0x100fe40000011639ULL,
0x000000ff394e7812ULL, 0x040fe200078ec0ffULL, 0x000000181018723cULL, 0x040fe20000001814ULL,
0x00000018ff4d7819ULL, 0x000fe40000011639ULL, 0x0000ffff395a7812ULL, 0x000fe400078ec0ffULL,
0x00000046ff46723eULL, 0x000fe400020006ffULL, 0x00000008ff08723eULL, 0x000fe200020006ffULL,
0x000000501020723cULL, 0x000be2000000183cULL, 0x00000018ff397819ULL, 0x000fe2000001163aULL,
0x000000004f3c783bULL, 0x0202a20000004200ULL, 0x00000010ff457819ULL, 0x000fc40000011638ULL,
0x00000018ff4a7819ULL, 0x000fe40000011638ULL, 0x0000ffff38597812ULL, 0x000fe400078ec0ffULL,
0x0000004bff38723eULL, 0x000fe400020006ffULL, 0x00000008ff447819ULL, 0x000fe40000011644ULL,
0x0000541008147816ULL, 0x000fe40000000046ULL, 0x00000039ff4b723eULL, 0x000fc400020006ffULL,
0x00000010ff517819ULL, 0x100fe4000001163bULL, 0x000000ff3b557812ULL, 0x040fe400078ec0ffULL,
0x00000018ff537819ULL, 0x000fe4000001163bULL, 0x0000ffff3b467812ULL, 0x000fe400078ec0ffULL,
0x000000ff45397812ULL, 0x000fe400078ec0ffULL, 0x000000ff4c3b7812ULL, 0x000fc400078ec0ffULL,
0x00000044ff15723eULL, 0x000fe400020006ffULL, 0x00000010ff507819ULL, 0x000fe4000001163aULL,
0x000000ff3a4f7812ULL, 0x042fe400078ec0ffULL, 0x0000ffff3a447812ULL, 0x000fe400078ec0ffULL,
0x00000039ff39723eULL, 0x000fe400020006ffULL, 0x0000004eff3a723eULL, 0x000fc400020006ffULL,
0x0000003bff3b723eULL, 0x000fe400020006ffULL, 0x0000541038387816ULL, 0x000fe40000000039ULL,
0x000054103a397816ULL, 0x000fe4000000003bULL, 0x0000004dff54723eULL, 0x000fe400020006ffULL,
0x0000004fff4d723eULL, 0x000fe400020006ffULL, 0x00000053ff4c723eULL, 0x000fe200020006ffULL,
0x000000383038723cULL, 0x000b620000001834ULL, 0x00000008ff4f7819ULL, 0x000fc40000011659ULL,
0x00000008ff537819ULL, 0x000fe4000001165aULL, 0x0000004aff52723eULL, 0x000fe400020006ffULL,
0x0000004fff34723eULL, 0x020fe400020006ffULL, 0x00000053ff35723eULL, 0x000fe400020006ffULL,
0x0000541034347816ULL, 0x000fe40000000052ULL, 0x0000541035357816ULL, 0x000fc40000000054ULL,
0x000000ff50507812ULL, 0x000fe400078ec0ffULL, 0x000000ff51517812ULL, 0x000fe400078ec0ffULL,
0x00000055ff4e723eULL, 0x000fe200020006ffULL, 0x000000343034723cULL, 0x000b620000001828ULL,
0x0000000cff0c723eULL, 0x000fe400020006ffULL, 0x00000008ff447819ULL, 0x000fe40000011644ULL,
0x0000541015157816ULL, 0x000fc4000000000cULL, 0x00000050ff28723eULL, 0x020fe400020006ffULL,
0x00000051ff29723eULL, 0x000fe400020006ffULL, 0x000054104d287816ULL, 0x000fe20000000028ULL,
0x000000141014723cULL, 0x000be20000001840ULL, 0x000054104e297816ULL, 0x000fe40000000029ULL,
0x00000008ff467819ULL, 0x000fe40000011646ULL, 0x000000ff3c577812ULL, 0x004fc400078ec0ffULL,
0x00000010ff417819ULL, 0x020fe2000001163cULL, 0x000000283028723cULL, 0x000b62000000182cULL,
0x00000010ff427819ULL, 0x000fe4000001163dULL, 0x000000ff3d587812ULL, 0x000fe400078ec0ffULL,
0x000000ff41417812ULL, 0x000fe400078ec0ffULL, 0x00000044ff2c723eULL, 0x020fe400020006ffULL,
0x00000046ff2d723eULL, 0x000fc400020006ffULL, 0x000054102c2c7816ULL, 0x000fe4000000004bULL,
0x000054102d2d7816ULL, 0x000fe4000000004cULL, 0x000000ff42427812ULL, 0x000fe400078ec0ffULL,
0x00000057ff45723eULL, 0x000fe400020006ffULL, 0x00000058ff4a723eULL, 0x000fe200020006ffULL,
0x0000002c3024723cULL, 0x000b620000001824ULL, 0x00000041ff41723eULL, 0x000fc400020006ffULL,
0x00000018ff567819ULL, 0x000fe4000001163cULL, 0x00000018ff477819ULL, 0x000fe4000001163dULL,
0x00000042ff31723eULL, 0x020fe400020006ffULL, 0x00000010ff0c7819ULL, 0x100fe4000001163eULL,
0x000000ff3e437812ULL, 0x000fe400078ec0ffULL, 0x00000018ff0e7819ULL, 0x000fc4000001163eULL,
0x00000010ff0f7819ULL, 0x100fe4000001163fULL, 0x000000ff3f407812ULL, 0x000fe400078ec0ffULL,
0x00000018ff087819ULL, 0x000fe4000001163fULL, 0x0000ffff3c3c7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff3d3d7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff3e3e7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff3f3f7812ULL, 0x000fe400078ec0ffULL, 0x0000541045307816ULL, 0x000fe40000000041ULL,
0x000054104a317816ULL, 0x000fe40000000031ULL, 0x00000008ff3c7819ULL, 0x000fe4000001163cULL,
0x00000008ff3d7819ULL, 0x000fe4000001163dULL, 0x000000ff0c0c7812ULL, 0x000fe200078ec0ffULL,
0x000000301030723cULL, 0x000b620000001838ULL, 0x000000ff0f0f7812ULL, 0x000fc400078ec0ffULL,
0x00000008ff3e7819ULL, 0x000fe4000001163eULL, 0x00000008ff3f7819ULL, 0x000fe4000001163fULL,
0x00000056ff4f723eULL, 0x000fe400020006ffULL, 0x00000047ff47723eULL, 0x000fe400020006ffULL,
0x00000043ff43723eULL, 0x000fe400020006ffULL, 0x00000040ff40723eULL, 0x000fc400020006ffULL,
0x0000003cff3c723eULL, 0x000fe400020006ffULL, 0x0000003dff3d723eULL, 0x000fe400020006ffULL,
0x0000000eff38723eULL, 0x020fe400020006ffULL, 0x0000000cff0c723eULL, 0x000fe400020006ffULL,
0x0000000fff0f723eULL, 0x000fe400020006ffULL, 0x00000008ff08723eULL, 0x000fc400020006ffULL,
0x0000003eff3e723eULL, 0x000fe400020006ffULL, 0x0000003fff3f723eULL, 0x000fe400020006ffULL,
0x000054103c3c7816ULL, 0x000fe4000000004fULL, 0x000054103d3d7816ULL, 0x000fe40000000047ULL,
0x00005410430e7816ULL, 0x000fe4000000000cULL, 0x00005410400f7816ULL, 0x000fc4000000000fULL,
0x000054103e3e7816ULL, 0x000fe20000000038ULL, 0x0000003c102c723cULL, 0x000b620000001834ULL,
0x000054103f3f7816ULL, 0x000fce0000000008ULL, 0x0000000e1028723cULL, 0x040b700000001828ULL,
0x0000003e1024723cULL, 0x000b620000001824ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fda0000008000ULL,
0x00000000040e7f8cULL, 0x0202a2000c80043fULL, 0x0000000148487810ULL, 0x000fc40007ffe0ffULL,
0x0000f6a0760c7811ULL, 0x000fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000000cff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff087224ULL, 0x004fe200078e000fULL,
0x0000001000001944ULL, 0x000fe20003c00000ULL, 0xffff63a000007947ULL, 0x000fea000383ffffULL,
0x000000ff6e00720cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x018000000a027810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000002027812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0200780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0000b3d000057802ULL, 0x000fc40000000f00ULL,
0x0000771000007944ULL, 0x01efea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000a00037308ULL, 0x002e640000001000ULL, 0xbf80000003027423ULL, 0x002fc8000000000aULL,
0x800000ff02027221ULL, 0x000fc80000010100ULL, 0x0000000203047223ULL, 0x000fc40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006d00ff037624ULL, 0x000fe400078e00ffULL,
0x00006c00ff027624ULL, 0x000fca00078e00ffULL, 0x0000000802037981ULL, 0x008ee8000c1e9900ULL,
0x0000000000057919ULL, 0x000e680000000000ULL, 0x0000000000087919ULL, 0x000ea20000000000ULL,
0x00000002ff077819ULL, 0x002fe40000011605ULL, 0x0000000808057811ULL, 0x004fe200078ff0ffULL,
0x0000000403067220ULL, 0x008fca0000410000ULL, 0x00001f0706047589ULL, 0x000e6800000e0000ULL,
0x00001f0506057589ULL, 0x000ea200000e0000ULL, 0x0000002004207220ULL, 0x042fe20000410000ULL,
0x0000002104217220ULL, 0x040fe20000410000ULL, 0x0000001c041c7220ULL, 0x040fe20000410000ULL,
0x0000001d041d7220ULL, 0x040fe20000410000ULL, 0x0000001804187220ULL, 0x040fe20000410000ULL,
0x0000001904197220ULL, 0x040fe20000410000ULL, 0x0000001404147220ULL, 0x040fe20000410000ULL,
0x0000001504157220ULL, 0x040fe20000410000ULL, 0x0000003004307220ULL, 0x040fe20000410000ULL,
0x0000003104317220ULL, 0x040fe20000410000ULL, 0x0000002c042c7220ULL, 0x040fe20000410000ULL,
0x0000002d042d7220ULL, 0x040fe20000410000ULL, 0x0000002804287220ULL, 0x040fe20000410000ULL,
0x0000002904297220ULL, 0x040fe20000410000ULL, 0x0000002404247220ULL, 0x040fe20000410000ULL,
0x0000002504257220ULL, 0x000fe20000410000ULL, 0x0000002205227220ULL, 0x044fe20000410000ULL,
0x0000002305237220ULL, 0x040fe20000410000ULL, 0x0000001e051e7220ULL, 0x040fe20000410000ULL,
0x0000001f051f7220ULL, 0x040fe20000410000ULL, 0x0000001a051a7220ULL, 0x040fe20000410000ULL,
0x0000001b051b7220ULL, 0x040fe20000410000ULL, 0x0000001605167220ULL, 0x040fe20000410000ULL,
0x0000001705177220ULL, 0x040fe20000410000ULL, 0x0000003205327220ULL, 0x040fe20000410000ULL,
0x0000003305337220ULL, 0x040fe20000410000ULL, 0x0000002e052e7220ULL, 0x040fe20000410000ULL,
0x0000002f052f7220ULL, 0x040fe20000410000ULL, 0x0000002a052a7220ULL, 0x040fe20000410000ULL,
0x0000002b052b7220ULL, 0x040fe20000410000ULL, 0x0000002605267220ULL, 0x040fe20000410000ULL,
0x0000002705277220ULL, 0x000fc20000410000ULL, 0x0000000000027919ULL, 0x000e620000000000ULL,
0x0000100000077824ULL, 0x008fe200078e00ffULL, 0x0000002c2d2c723eULL, 0x000fc400000000ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000282928723eULL, 0x000fe400000000ffULL,
0x0000001a1b1a723eULL, 0x000fe400000000ffULL, 0x000000323332723eULL, 0x000fc400000000ffULL,
0x0000002a2b2a723eULL, 0x000fe400000000ffULL, 0x000000ff6200720cULL, 0x000fe40003f05270ULL,
0x00000002ff067819ULL, 0x002fe40000011602ULL, 0x0000000202037812ULL, 0x040fe400078ec0ffULL,
0x0000000802087811ULL, 0x000fe200078ff0ffULL, 0x00000008060d7824ULL, 0x004fe200078e00ffULL,
0x0000000603047211ULL, 0x000fc400078ff8ffULL, 0x0000000803057211ULL, 0x000fe200078ff8ffULL,
0x00000008080a7824ULL, 0x000fe200078e00ffULL, 0x0000000204037810ULL, 0x000fe20007ffe0ffULL,
0x0000000806087824ULL, 0x000fc600078e00ffULL, 0xfffffff80a0f7812ULL, 0x000fe200078ee205ULL,
0x0000000806057824ULL, 0x000fe200078e00ffULL, 0xfffffff808097812ULL, 0x000fe200078ee203ULL,
0x00000008060a7824ULL, 0x000fe200078e00ffULL, 0x0000100007037812ULL, 0x000fe200078ee2ffULL,
0x0000000802067824ULL, 0x000fe200078e00ffULL, 0x0000000404077810ULL, 0x040fe40007ffe0ffULL,
0x0000000604087810ULL, 0x000fe40007ffe0ffULL, 0xfffffff805057812ULL, 0x000fe200078ee204ULL,
0x0000080062047824ULL, 0x000fe200078e0203ULL, 0xfffffff80a0b7812ULL, 0x010fc400078ee207ULL,
0xfffffff80d0d7812ULL, 0x000fe200078ee208ULL, 0x000000100f107824ULL, 0x100fe200078e0204ULL,
0x0000000806077812ULL, 0x000fe200078ec0ffULL, 0x0000001005067824ULL, 0x100fe200078e0204ULL,
0x0000001c1d05723eULL, 0x000fe200000000ffULL, 0x00000010090a7824ULL, 0x100fe400078e0204ULL,
0x000000100b0c7824ULL, 0x100fe400078e0204ULL, 0x000000100d0e7824ULL, 0x000fe200078e0204ULL,
0x000000202104723eULL, 0x000fe200000000ffULL, 0x0000000106087824ULL, 0x000fe200078e0207ULL,
0x000000303106723eULL, 0x000fe200000000ffULL, 0x00000001070a7824ULL, 0x040fe200078e020aULL,
0x0000541004127816ULL, 0x140fe20000000005ULL, 0x0000000107107824ULL, 0x040fe200078e0210ULL,
0x0000763204137816ULL, 0x000fe20000000005ULL, 0x00000001070c7824ULL, 0x000fe200078e020cULL,
0x000000181904723eULL, 0x000fe200000000ffULL, 0x00000001070e7824ULL, 0x000fe200078e020eULL,
0x000000141505723eULL, 0x000fe200000000ffULL, 0x0000001208007388ULL, 0x0003e20000000a00ULL,
0x000000242514723eULL, 0x000fc400000000ffULL, 0x0000763204097816ULL, 0x100fe40000000005ULL,
0x0000763228077816ULL, 0x000fe40000000014ULL, 0x00000016170d723eULL, 0x000fe400000000ffULL,
0x0000002e2f19723eULL, 0x000fe400000000ffULL, 0x000000262715723eULL, 0x000fe400000000ffULL,
0x0000541004087816ULL, 0x002fc40000000005ULL, 0x000000222304723eULL, 0x000fe400000000ffULL,
0x0000001e1f05723eULL, 0x000fe200000000ffULL, 0x000000080a007388ULL, 0x0003e20000000a00ULL,
0x000054102a1c7816ULL, 0x140fe40000000015ULL, 0x000076322a1d7816ULL, 0x000fe40000000015ULL,
0x0000541006087816ULL, 0x142fe4000000002cULL, 0x0000763206097816ULL, 0x000fc4000000002cULL,
0x0000541028067816ULL, 0x000fc60000000014ULL, 0x000000080c007388ULL, 0x000fe80000000a00ULL,
0x000000060e007388ULL, 0x0003e40000000a00ULL, 0x0000541004067816ULL, 0x142fe40000000005ULL,
0x0000763204077816ULL, 0x000fe20000000005ULL, 0x000000017d047824ULL, 0x000fc800078e0202ULL,
0x0000000610007388ULL, 0x0003e20000000a00ULL, 0x0000001004047824ULL, 0x000fe200078e0203ULL,
0x000054101a067816ULL, 0x142fe4000000000dULL, 0x000076321a077816ULL, 0x000fca000000000dULL,
0x000400060a007388ULL, 0x0003e40000000a00ULL, 0x0000541032067816ULL, 0x142fe40000000019ULL,
0x0000763232077816ULL, 0x000fca0000000019ULL, 0x000400060c007388ULL, 0x000fe80000000a00ULL,
0x0004001c0e007388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000004107984ULL, 0x000e680000000c00ULL, 0x0004000004147984ULL, 0x000ea80000000c00ULL,
0x0008000004087984ULL, 0x000ee80000000c00ULL, 0x000c000004187984ULL, 0x000ee20000000c00ULL,
0x200000ff13137230ULL, 0x002fc40000000000ULL, 0x200000ff12127230ULL, 0x000fe40000000000ULL,
0x200000ff11117230ULL, 0x000fe40000000000ULL, 0x200000ff10107230ULL, 0x000fe40000000000ULL,
0x200000ff17177230ULL, 0x004fe40000000000ULL, 0x200000ff16167230ULL, 0x000fe40000000000ULL,
0x200000ff15157230ULL, 0x000fc40000000000ULL, 0x200000ff14147230ULL, 0x000fe40000000000ULL,
0x0000000b13137230ULL, 0x008fe40000000000ULL, 0x0000000a12127230ULL, 0x000fe40000000000ULL,
0x0000000911117230ULL, 0x000fe40000000000ULL, 0x0000000810107230ULL, 0x000fe40000000000ULL,
0x0000001b17177230ULL, 0x000fc40000000000ULL, 0x0000001a16167230ULL, 0x000fe20000000000ULL,
0x0000001004007388ULL, 0x000fe20000000c00ULL, 0x0000001915157230ULL, 0x000fe40000000000ULL,
0x0000001814147230ULL, 0x000fca0000000000ULL, 0x0004001404007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff077819ULL, 0x000fc80000011602ULL, 0x0000007b0700720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000107047824ULL, 0x100fe200078e0202ULL,
0x00000000000479c3ULL, 0x000e620000002700ULL, 0xffffffff00057882ULL, 0x000fe20000000000ULL,
0x00005900ff347624ULL, 0x000fe200078e00ffULL, 0x00005a0000067ab9ULL, 0x000fe20000000800ULL,
0x0000000704057812ULL, 0x000fe200078ec0ffULL, 0x0000000605057299ULL, 0x000fe2000800063fULL,
0x00005a007a117a19ULL, 0x000fe400000006ffULL, 0x0ffffff805047812ULL, 0x000fe200078ef802ULL,
0x0000580000067ab9ULL, 0x000fe20000000800ULL, 0x00005a0034347a19ULL, 0x000fc400000006ffULL,
0x00000001000f7812ULL, 0x000fe200078ec0ffULL, 0x0000001004057824ULL, 0x000fe200078e0203ULL,
0x0000002002007810ULL, 0x000fe20007ffe0ffULL, 0x000000107c047824ULL, 0x000fe200078e0207ULL,
0x00000007020e7812ULL, 0x000fe400078ec0ffULL, 0x0000000005087984ULL, 0x0004e20000000c00ULL,
0x00000003ff0d7819ULL, 0x000fe40000011600ULL, 0x0000000504067c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff047a19ULL, 0x000fe20000011604ULL, 0x00000006040472a4ULL, 0x002fc4000f8e023fULL,
0x0000000111077824ULL, 0x000fc800078e0206ULL, 0x0000000434067c24ULL, 0x000fe4000f8e02ffULL,
0x0000003404077224ULL, 0x000fca00078e0207ULL, 0x0000000706077210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x00005c0007047a11ULL, 0x000fc800078040ffULL,
0x00005d0007057a11ULL, 0x004fe200000f440cULL, 0x000000080f077824ULL, 0x000fe200078e020eULL,
0x0000007b0d00720cULL, 0x000fc60003f06070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0083ea000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000100047824ULL, 0x102fe200078e020dULL, 0x00000040020c7810ULL, 0x000fe20007ffe0ffULL,
0x000000107c0d7824ULL, 0x000fc600078e020dULL, 0x0000000704057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805047812ULL, 0x000fe400078ef800ULL, 0x0000000700007812ULL, 0x000fc600078ec0ffULL,
0x0000001004077824ULL, 0x000fe200078e0203ULL, 0x000000050d047c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff0d7a19ULL, 0x000fe4000001160dULL, 0x0000000007087984ULL, 0x0002a20000000c00ULL,
0x0000000111047824ULL, 0x000fc800078e0204ULL, 0x000000340d0d7224ULL, 0x000fe400078e0204ULL,
0x000000080f077824ULL, 0x002fc600078e0200ULL, 0x0000000d060d7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x00005c000d047a11ULL, 0x000fc800078040ffULL,
0x00005d000d057a11ULL, 0x000fe400000f440eULL, 0x00000003ff0d7819ULL, 0x000fc6000001160cULL,
0x0000001007047825ULL, 0x000fe200078e0004ULL, 0x0000007b0d00720cULL, 0x000fc80003f06070ULL,
0x0000000804007986ULL, 0x0043f2000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010c007824ULL, 0x100fe400078e020dULL, 0x000000107c0d7824ULL, 0x000fc600078e020dULL,
0x0000000700057812ULL, 0x002fe400078ec0ffULL, 0x000000050d047c12ULL, 0x000fe4000f8e30ffULL,
0x0ffffff805007812ULL, 0x000fe400078ef80cULL, 0x00005a00ff0d7a19ULL, 0x000fe2000001160dULL,
0x0000000111047824ULL, 0x000fe200078e0204ULL, 0x000000070c0c7812ULL, 0x000fe200078ec0ffULL,
0x0000001000007824ULL, 0x000fe400078e0203ULL, 0x000000340d0d7224ULL, 0x000fc400078e0204ULL,
0x000000080f077824ULL, 0x000fe200078e020cULL, 0x0000000000087984ULL, 0x0002a40000000c00ULL,
0x0000000d06057210ULL, 0x000fe40007f1e0ffULL, 0x00000060020d7810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff027224ULL, 0x000fe200000e06ffULL, 0x00005c0005047a11ULL, 0x040fe400078040ffULL,
0x00000003ff007819ULL, 0x002fe4000001160dULL, 0x00005d0005057a11ULL, 0x000fe400000f4402ULL,
0x0000007b0000720cULL, 0x000fe20003f06070ULL, 0x000000010d027824ULL, 0x000fe400078e0200ULL,
0x0000001007047825ULL, 0x000fc600078e0004ULL, 0x0000000702027812ULL, 0x000fc800078ec0ffULL,
0xfffffff802027812ULL, 0x000fe200078ef80dULL, 0x0000000804007986ULL, 0x0043e4000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000001002047824ULL, 0x002fe200078e0203ULL,
0x000000070d0d7812ULL, 0x000fe200078ec0ffULL, 0x000000107c007824ULL, 0x000fc600078e0200ULL,
0x0000000004087984ULL, 0x000e620000000c00ULL, 0x000000080f0d7824ULL, 0x000fe200078e020dULL,
0x0000000500027c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff007a19ULL, 0x000fc60000011600ULL,
0x0000000111037824ULL, 0x000fc800078e0202ULL, 0x0000003400037224ULL, 0x000fca00078e0203ULL,
0x0000000306037210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff007224ULL, 0x000fe200000e06ffULL,
0x00005c0003027a11ULL, 0x000fc800078040ffULL, 0x00005d0003037a11ULL, 0x000fca00000f4400ULL,
0x000000100d027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x002fe2000c101d08ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0000006d0000720cULL, 0x000fe20003f06070ULL,
0xffffffffff677424ULL, 0x000fd800078e00ffULL, 0x0000000273098824ULL, 0x000fc800078e00ffULL,
0x0000680009098a24ULL, 0x000fc800078e0200ULL, 0x0000640009088625ULL, 0x000fe200078e0008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000808678981ULL, 0x000ea2000c1e1900ULL,
0x00006c00ff0a7624ULL, 0x000fe400078e00ffULL, 0x00006d00ff0b7624ULL, 0x000fe200078e00ffULL,
0x00f60000ff047f8cULL, 0x000ee8000c80043fULL, 0x000000080a6b7981ULL, 0x000322000c1e9900ULL,
0x000001ff0c00780cULL, 0x000fe20003f04070ULL, 0x0000004072727824ULL, 0x000fc400078e00ffULL,
0x00000080ff077424ULL, 0x000fe400078e00ffULL, 0x0000004000787824ULL, 0x000fe400078e00ffULL,
0x000000407a027824ULL, 0x000fe400078e00ffULL, 0x0000007267067224ULL, 0x006fc800078e02ffULL,
0x0000620006067625ULL, 0x000fe200078e0007ULL, 0x0000060000000947ULL, 0x000fea0003800000ULL,
0x00000002ff1d7819ULL, 0x008fe40000011649ULL, 0x00000049490e7211ULL, 0x000fe400078fe8ffULL,
0x000000081d177810ULL, 0x000fe20007ffe0ffULL, 0x000000407a7a7824ULL, 0x000fe200078e021dULL,
0x000000030e167812ULL, 0x000fe400078ec0ffULL, 0x0000100000187811ULL, 0x000fe200078e68ffULL,
0x000000807a087825ULL, 0x040fe200078e00ffULL, 0x000000087a0a7810ULL, 0x000fc40007ffe0ffULL,
0x000000107a0c7810ULL, 0x000fe40007ffe0ffULL, 0x0000003008117812ULL, 0x100fe200078ef803ULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x000000287a0e7810ULL, 0x000fe40007ffe0ffULL,
0x0000001106107210ULL, 0x000fe20007f1e0ffULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x000000300a137812ULL, 0x000fe400078ef803ULL, 0x000000187a0a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000107117824ULL, 0x000fe200000e0609ULL, 0x0000001306127210ULL, 0x000fc40007f3e0ffULL,
0x000000300c0f7812ULL, 0x000fe400078ef803ULL, 0x000000207a0c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000107137824ULL, 0x040fe200008e060bULL, 0x0000000f06087210ULL, 0x000fe40007f5e0ffULL,
0x000000786c0b7217ULL, 0x000fe40007800000ULL, 0x0ffffffc16497812ULL, 0x000fe200078ef849ULL,
0x0000000107097824ULL, 0x000fe200010e060dULL, 0x000000101d217810ULL, 0x000fe20007ffe0ffULL,
0x000000010b147824ULL, 0x000fe200078e0a78ULL, 0x000000281d197810ULL, 0x040fe20007ffe0ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x000000301d1b7810ULL, 0x000fc40007ffe0ffULL,
0x000000141700720cULL, 0x080fe20003f26070ULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x000000300c0f7812ULL, 0x100fe400078ef803ULL, 0x000000141d00720cULL, 0x000fe20003f06070ULL,
0x0000000417177824ULL, 0x000fe200078e00ffULL, 0x0000000f060c7210ULL, 0x000fe20007f7e0ffULL,
0x0000001049497824ULL, 0x000fe200078e0218ULL, 0x000000300a157812ULL, 0x000fe400078ef803ULL,
0xfffffffc170f7812ULL, 0x000fe200078ee216ULL, 0x00000001070d7824ULL, 0x000fe200018e060dULL,
0x00000015060a7210ULL, 0x000fc40007f5e0ffULL, 0x000000201d177810ULL, 0x000fe20007ffe0ffULL,
0x000000100f157824ULL, 0x000fe200078e0218ULL, 0x000000181d237810ULL, 0x000fe20007ffe0ffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010497faeULL, 0x0003e2000c101c48ULL, 0x000000142100720cULL, 0x000fe40003fa6070ULL,
0x00000001070b7824ULL, 0x000fe200010e060bULL, 0x000000300e1f7812ULL, 0x000fe200078ef803ULL,
0x0000000012157faeULL, 0x0005e2000c901c48ULL, 0x000000307a0e7810ULL, 0x000fc40007ffe0ffULL,
0x000000141900720cULL, 0x080fe40003f46070ULL, 0x000000141b00720cULL, 0x080fe20003f26070ULL,
0x0000000417117824ULL, 0x002fe200078e00ffULL, 0x000000387a107810ULL, 0x000fe40007ffe0ffULL,
0x000000381d1d7810ULL, 0x000fe40007ffe0ffULL, 0x0000001f06127210ULL, 0x004fe20007fde0ffULL,
0x0000000421157824ULL, 0x000fe200078e00ffULL, 0x000000142300720cULL, 0x080fe20003f86070ULL,
0x00000004191f7824ULL, 0x000fe200078e00ffULL, 0xfffffffc11197812ULL, 0x100fe200078ee216ULL,
0x0000000107137824ULL, 0x000fe200030e060fULL, 0x000000141700720cULL, 0x000fe20003f66070ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0xfffffffc15157812ULL, 0x000fc400078ee216ULL,
0x000000141d00720cULL, 0x000fe20003f06070ULL, 0x000000041b217824ULL, 0x000fe200078e00ffULL,
0x000000300e1b7812ULL, 0x100fe200078ef803ULL, 0x0000000423237824ULL, 0x000fe400078e00ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000001b060e7210ULL, 0x000fe40007fde0ffULL,
0xfffffffc23177812ULL, 0x100fe200078ee216ULL, 0x000000041d257824ULL, 0x000fe200078e00ffULL,
0x0000003010037812ULL, 0x000fe200078ef803ULL, 0x00000001070f7824ULL, 0x000fe200030e060fULL,
0xfffffffc1f1b7812ULL, 0x000fe200078ee216ULL, 0x0000001015157824ULL, 0x000fe200078e0218ULL,
0xfffffffc211d7812ULL, 0x000fe200078ee216ULL, 0x0000001017177824ULL, 0x000fe200078e0218ULL,
0xfffffffc251f7812ULL, 0x000fe200078ee216ULL, 0x0000001019197824ULL, 0x100fe200078e0218ULL,
0x0000000306067210ULL, 0x000fe20007fde0ffULL, 0x000000101b1b7824ULL, 0x100fe200078e0218ULL,
0x0000000008157faeULL, 0x0003e2000e901c48ULL, 0x000000101d1d7824ULL, 0x000fc400078e0218ULL,
0x000000101f1f7824ULL, 0x000fe200078e0218ULL, 0x000000000a177faeULL, 0x0003e2000e101c48ULL,
0x0000000107077824ULL, 0x000fc600030e0611ULL, 0x000000000c197faeULL, 0x0003e8000d901c48ULL,
0x00000000121b7faeULL, 0x0003e8000d101c48ULL, 0x000000000e1d7faeULL, 0x0003e8000c901c48ULL,
0x00000000061f7faeULL, 0x0003e2000c101c48ULL, 0x0000054000007947ULL, 0x000fea0003800000ULL,
0x0000000249087211ULL, 0x048fe400078ff0ffULL, 0x0000004949097211ULL, 0x000fc400078fe8ffULL,
0x0000000849177811ULL, 0x040fe400078ff0ffULL, 0x00000010490b7811ULL, 0x040fe400078ff0ffULL,
0x00000018490d7811ULL, 0x000fe200078ff0ffULL, 0x00000004170f7824ULL, 0x000fe200078e00ffULL,
0x0000002049117811ULL, 0x000fe200078ff0ffULL, 0x000000040b137824ULL, 0x000fe200078e00ffULL,
0x0000002849217811ULL, 0x000fe200078ff0ffULL, 0x000000040d157824ULL, 0x000fe200078e00ffULL,
0x0000003049257811ULL, 0x000fe200078ff0ffULL, 0x00000001020c7824ULL, 0x000fe200078e020bULL,
0x0000000309167812ULL, 0x000fe200078ec0ffULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x0000003849297811ULL, 0x000fc400078ff0ffULL, 0xfffffffc0f0e7812ULL, 0x100fe200078ee216ULL,
0x0000000411197824ULL, 0x000fe200078e00ffULL, 0xfffffffc130f7812ULL, 0x100fe200078ee216ULL,
0x00000004211b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc15107812ULL, 0x100fe200078ee216ULL,
0x00000004251d7824ULL, 0x000fe200078e00ffULL, 0x0ffffffc16497812ULL, 0x000fe200078ef849ULL,
0x00000001020a7824ULL, 0x000fe200078e0217ULL, 0x0000003008177812ULL, 0x000fe200078ef803ULL,
0x00000004291f7824ULL, 0x000fe200078e00ffULL, 0xfffffffc19137812ULL, 0x100fe200078ee216ULL,
0x0000000102087824ULL, 0x000fe200078e020dULL, 0xfffffffc1b147812ULL, 0x100fe200078ee216ULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0xfffffffc1d157812ULL, 0x000fc400078ee216ULL,
0x00001000002b7811ULL, 0x000fe200078e68ffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0xfffffffc1f167812ULL, 0x000fe400078ee216ULL, 0x0000001706127210ULL, 0x000fe20007f1e0ffULL,
0x0000001049497824ULL, 0x000fe200078e022bULL, 0x000000300c177812ULL, 0x000fe200078ef803ULL,
0x000000100e197824ULL, 0x100fe400078e022bULL, 0x000000100f1b7824ULL, 0x000fe200078e022bULL,
0x000000300a0f7812ULL, 0x000fe200078ef803ULL, 0x00000010101d7824ULL, 0x000fc400078e022bULL,
0x00000010131f7824ULL, 0x100fe400078e022bULL, 0x0000001014237824ULL, 0x100fe200078e022bULL,
0x0000000f06147210ULL, 0x000fe20007f3e0ffULL, 0x0000001015277824ULL, 0x100fe400078e022bULL,
0x00000010162b7824ULL, 0x000fe200078e022bULL, 0x0000001706167210ULL, 0x000fe20007f5e0ffULL,
0x0000000107137824ULL, 0x000fe400000e0609ULL, 0x0000008008087825ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012497faeULL, 0x0003e2000b901c48ULL,
0x0000000107177824ULL, 0x040fe200010e060dULL, 0x00000030080d7812ULL, 0x000fe200078ef803ULL,
0x00000001020a7824ULL, 0x040fe400078e0211ULL, 0x00000001020c7824ULL, 0x000fe200078e0221ULL,
0x0000000d06087210ULL, 0x000fe20007f1e0ffULL, 0x00000001020e7824ULL, 0x040fe400078e0225ULL,
0x0000000107157824ULL, 0x000fe400008e060bULL, 0x0000000102107824ULL, 0x000fc400078e0229ULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000000014197faeULL, 0x0003e6000b901c48ULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x000000300a297812ULL, 0x100fe200078ef803ULL,
0x00000000161b7faeULL, 0x0003e4000b901c48ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x000000300c257812ULL, 0x000fc600078ef803ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000000300e217812ULL, 0x000fe400078ef803ULL, 0x00000025060c7210ULL, 0x000fe20007f3e0ffULL,
0x0000000107097824ULL, 0x040fe200000e0609ULL, 0x0000003010037812ULL, 0x000fe400078ef803ULL,
0x00000029060a7210ULL, 0x040fe20007f1e0ffULL, 0x00000001070d7824ULL, 0x040fe200008e060dULL,
0x00000021060e7210ULL, 0x040fe20007f5e0ffULL, 0x00000000081d7faeULL, 0x0003e2000b901c48ULL,
0x0000000306067210ULL, 0x000fe20007f7e0ffULL, 0x00000001070b7824ULL, 0x000fc400000e060bULL,
0x00000001070f7824ULL, 0x040fe400010e060fULL, 0x0000000107077824ULL, 0x000fe200018e0611ULL,
0x000000000a1f7faeULL, 0x0003e8000b901c48ULL, 0x000000000c237faeULL, 0x0003e8000b901c48ULL,
0x000000000e277faeULL, 0x0003e8000b901c48ULL, 0x00000000062b7faeULL, 0x0003e4000b901c48ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000067805ULL, 0x002fc40000015200ULL,
0x00f60400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fc40007804805ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x0000000806087210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e07ULL, 0x003d09000800780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400800780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011409ULL,
0x0000000803037211ULL, 0x000fca00078110ffULL, 0x000000ffff087224ULL, 0x000fca00000e0609ULL,
0x0000000203037819ULL, 0x000fc80000001208ULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f60400ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e640000000000ULL, 0x0000002000037824ULL, 0x002fca00078e0203ULL,
0x00000003ff047819ULL, 0x000fc80000011603ULL, 0x1ffffffe04067812ULL, 0x000fe400078ec0ffULL,
0x0000000f03047812ULL, 0x000fc600078ec0ffULL, 0x0000000103067824ULL, 0x000fe400078e0206ULL,
0x0000001004087824ULL, 0x040fe400078e00ffULL, 0x0000001004057824ULL, 0x000fe200078e00ffULL,
0x0000000f06037812ULL, 0x040fe400078ec0ffULL, 0x0000000106067810ULL, 0x000fe40007ffe0ffULL,
0x000000f008037812ULL, 0x000fe400078ee203ULL, 0x0000000f06067812ULL, 0x000fc600078ec0ffULL,
0x00000000030c7984ULL, 0x000e62000000cc00ULL, 0x000000f005067812ULL, 0x000fca00078ee206ULL,
0x0000000006087984ULL, 0x000ea2000000cc00ULL, 0x000000ffff107224ULL, 0x002fe400078e000cULL,
0x000000ffff0c7224ULL, 0x000fe400078e000dULL, 0x000000ffff117224ULL, 0x000fe400078e000eULL,
0x000000ffff0d7224ULL, 0x000fe400078e000fULL, 0x000000ffff127224ULL, 0x004fe400078e0008ULL,
0x000000ffff137224ULL, 0x000fc400078e000aULL, 0x000000ffff0e7224ULL, 0x000fe400078e0009ULL,
0x000000ffff0f7224ULL, 0x000fe200078e000bULL, 0x0000001003007388ULL, 0x0003e8000000cc00ULL,
0x0000000c06007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f60000ff087f8cULL, 0x000ea2000c80043fULL, 0x000000ffff0a7224ULL, 0x000fc600078e00ffULL,
0x0000000000047805ULL, 0x000fc80000015200ULL, 0x00f60400ff037984ULL, 0x002e640000000800ULL,
0x8000000003ff7812ULL, 0x006fc40007804809ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604067210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000600780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400600780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011407ULL,
0x0000000603037211ULL, 0x000fca00078110ffULL, 0x000000ffff067224ULL, 0x000fca00000e0607ULL,
0x0000000203037819ULL, 0x000fc80000001206ULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f60400ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff6e00720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0x00005800ff6f7624ULL, 0x000fe200078e00ffULL,
0x800058006c747a10ULL, 0x000fe20007ffe0ffULL, 0x0000680073737a24ULL, 0x000fe200078e02ffULL,
0x3db504f36b6b7820ULL, 0x010fe20000410000ULL, 0x0000f68800767811ULL, 0x000fe200078e18ffULL,
0x000000ffff687224ULL, 0x000fe200078e00ffULL, 0x0000001f6f067810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff047224ULL, 0x000fe200078e00ffULL, 0xffffffff6f757810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff057224ULL, 0x000fe200078e0000ULL, 0x00000004ff067819ULL, 0x000fc40000011606ULL,
0x0000f60800797811ULL, 0x000fe400078e28ffULL, 0x000000096f6f7810ULL, 0x000fe40007ffe0ffULL,
0x00000008ff747819ULL, 0x000fe40000011674ULL, 0x0ffffffe06707812ULL, 0x000fc400078ec0ffULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x000000ffff0b7224ULL, 0x000fe200078e0004ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x000000ffff667224ULL, 0x000fe200078e00ffULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x01cfc4000001ff00ULL, 0x000000016600780cULL, 0x000fe20003f25270ULL,
0x00000080ff0a7424ULL, 0x000fe200078e00ffULL, 0x00000001680d7810ULL, 0x020fe20007ffe0ffULL,
0x00000bc000007945ULL, 0x000fe20003800000ULL, 0x0000000166067810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff097224ULL, 0x000fe200078e0066ULL, 0x000000010b047812ULL, 0x000fc400078e0cffULL,
0x000000020600780cULL, 0x040fe20003f06070ULL, 0x000000ffff667224ULL, 0x000fe200078e0006ULL,
0x000000ff06087207ULL, 0x000fc60000800000ULL, 0x000000ffff0d1224ULL, 0x000fca00078e0268ULL,
0x000000010d077810ULL, 0x000fc80007ffe0ffULL, 0x0000006e0700720cULL, 0x000fe20003f46070ULL,
0x0000007267077224ULL, 0x010fc800078e02ffULL, 0x0000620007067625ULL, 0x000fd000078e000aULL,
0x000005e00000a947ULL, 0x000fea0003800000ULL, 0x00000010030a7824ULL, 0x002fe200078e00ffULL,
0x00000002ff3f7819ULL, 0x000fe20000011603ULL, 0x000001000d137824ULL, 0x000fe400078e0278ULL,
0x000000ffff0d7224ULL, 0x000fe200078e00ffULL, 0x000000300a0f7812ULL, 0x000fe200078ec0ffULL,
0x0000000200387824ULL, 0x000fe200078e0204ULL, 0x000000103f3d7810ULL, 0x040fe40007ffe0ffULL,
0x000000083f397810ULL, 0x040fe20007ffe0ffULL, 0x00000040080c7824ULL, 0x000fe200078e020fULL,
0x000000136c0a7217ULL, 0x000fe20007800000ULL, 0x00000001020f7824ULL, 0x040fe200078e023fULL,
0x000000183f457810ULL, 0x000fe20007ffe0ffULL, 0x00000001021b7824ULL, 0x000fe200078e023dULL,
0x0000100038387811ULL, 0x000fe200078e60ffULL, 0x000000800f0e7825ULL, 0x000fe200078e000cULL,
0x000000203f477810ULL, 0x000fc40007ffe0ffULL, 0x000000283f497810ULL, 0x000fe20007ffe0ffULL,
0x0000000102117824ULL, 0x000fe200078e0239ULL, 0x0000000e06127210ULL, 0x000fe20007f3e0ffULL,
0x000000010a0a7824ULL, 0x000fe200078e0a13ULL, 0x00000003030e7211ULL, 0x000fe200078fe8ffULL,
0x000000801b1a7825ULL, 0x000fe200078e000cULL, 0x000000303f4b7810ULL, 0x000fe40007ffe0ffULL,
0x000000030e3a7812ULL, 0x000fe200078ec0ffULL, 0x0000000107137824ULL, 0x000fe200008e060fULL,
0x0000001a061a7210ULL, 0x000fe20007f3e0ffULL, 0x00000001020f7824ULL, 0x000fe200078e0245ULL,
0x000000383f4d7810ULL, 0x000fe20007ffe0ffULL, 0x0000008011107825ULL, 0x000fe200078e000cULL,
0x0000000a4500720cULL, 0x000fc60003fa6070ULL, 0x000000800f0e7825ULL, 0x000fe200078e000cULL,
0x0000001006187210ULL, 0x000fc60007f5e0ffULL, 0x00000001071b7824ULL, 0x040fe200008e061bULL,
0x0000000e060e7210ULL, 0x000fe20007f7e0ffULL, 0x0000000107197824ULL, 0x000fe200010e0611ULL,
0x0000000a3f00720cULL, 0x080fe20003f26070ULL, 0x00000004393b7824ULL, 0x040fe200078e00ffULL,
0x0000000a3900720cULL, 0x080fe20003f46070ULL, 0x00000001070f7824ULL, 0x000fe200018e060fULL,
0x0ffffffc3a397812ULL, 0x000fe200078ef803ULL, 0x0000000102117824ULL, 0x000fe200078e0247ULL,
0x0000000a3d00720cULL, 0x040fe20003f66070ULL, 0x000000043d3d7824ULL, 0x000fe200078e00ffULL,
0xfffffffc3b3b7812ULL, 0x000fe200078ee23aULL, 0x0000001039397824ULL, 0x000fc400078e0238ULL,
0x00000001023f7824ULL, 0x000fe200078e0249ULL, 0xfffffffc3d3d7812ULL, 0x000fe200078ee23aULL,
0x0000008011107825ULL, 0x000fe200078e000cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012397faeULL, 0x0003e2000c901c48ULL, 0x0000000a4d00720cULL, 0x000fe40003f26070ULL,
0x000000103b3b7824ULL, 0x100fe200078e0238ULL, 0x0000001006107210ULL, 0x000fe20007f9e0ffULL,
0x000000103d3d7824ULL, 0x000fe400078e0238ULL, 0x0000000102417824ULL, 0x040fe200078e024bULL,
0x00000000183b7faeULL, 0x0005e2000d101c48ULL, 0x0000000102437824ULL, 0x000fe200078e024dULL,
0x0000000a4b00720cULL, 0x080fe20003f46070ULL, 0x0000000107117824ULL, 0x000fe200020e0611ULL,
0x000000001a3d7faeULL, 0x0007e2000d901c48ULL, 0x000000803f127825ULL, 0x002fe200078e000cULL,
0x0000000a4700720cULL, 0x000fc40003f86070ULL, 0x0000000a4900720cULL, 0x000fe20003f66070ULL,
0x0000000447397824ULL, 0x000fe200078e00ffULL, 0x0000001206127210ULL, 0x040fe20007fde0ffULL,
0x000000044d3f7824ULL, 0x000fe400078e00ffULL, 0x0000008041187825ULL, 0x004fe200078e000cULL,
0xfffffffc39397812ULL, 0x100fe400078ee23aULL, 0xfffffffc3f3f7812ULL, 0x100fe200078ee23aULL,
0x00000004451b7824ULL, 0x008fe400078e00ffULL, 0x0000000107137824ULL, 0x000fe200030e0613ULL,
0x0000001806187210ULL, 0x000fe20007fde0ffULL, 0x00000004493b7824ULL, 0x000fe200078e00ffULL,
0xfffffffc1b1b7812ULL, 0x000fe200078ee23aULL, 0x000000044b3d7824ULL, 0x000fc400078e00ffULL,
0x00000080430c7825ULL, 0x000fe200078e000cULL, 0xfffffffc3b3b7812ULL, 0x100fe400078ee23aULL,
0xfffffffc3d3d7812ULL, 0x000fe200078ee23aULL, 0x0000000107197824ULL, 0x000fe200030e0619ULL,
0x0000000c06067210ULL, 0x000fe20007fde0ffULL, 0x000000101b1b7824ULL, 0x100fe400078e0238ULL,
0x0000001039397824ULL, 0x100fe400078e0238ULL, 0x000000103b3b7824ULL, 0x100fe200078e0238ULL,
0x000000000e1b7faeULL, 0x0003e2000e901c48ULL, 0x000000103d3d7824ULL, 0x000fc400078e0238ULL,
0x000000103f3f7824ULL, 0x000fe200078e0238ULL, 0x0000000010397faeULL, 0x0003e2000e101c48ULL,
0x0000000107077824ULL, 0x000fc600030e060dULL, 0x00000000123b7faeULL, 0x0003e8000d901c48ULL,
0x00000000183d7faeULL, 0x0003e8000d101c48ULL, 0x00000000063f7faeULL, 0x0003e2000c901c48ULL,
0x0000051000007947ULL, 0x000fea0003800000ULL, 0x00000008030d7811ULL, 0x042fe200078ff0ffULL,
0x00000002000c7824ULL, 0x000fe200078e0204ULL, 0x0000001003137811ULL, 0x000fc400078ff0ffULL,
0x00000018031b7811ULL, 0x000fe200078ff0ffULL, 0x000000040d3f7824ULL, 0x000fe200078e00ffULL,
0x00000020034d7811ULL, 0x000fe200078ff0ffULL, 0x0000000413417824ULL, 0x000fe200078e00ffULL,
0x00000028034f7811ULL, 0x000fe200078ff0ffULL, 0x000000041b437824ULL, 0x000fe200078e00ffULL,
0x0000003003517811ULL, 0x000fe200078ff0ffULL, 0x000000044d457824ULL, 0x000fe200078e00ffULL,
0x0000003803537811ULL, 0x000fe200078ff0ffULL, 0x000000044f477824ULL, 0x000fe200078e00ffULL,
0x00000003030a7211ULL, 0x000fe200078fe8ffULL, 0x0000000451497824ULL, 0x000fe200078e00ffULL,
0x0000000203117211ULL, 0x000fe200078ff0ffULL, 0x00000004534b7824ULL, 0x000fe200078e00ffULL,
0x000000030a0a7812ULL, 0x000fe200078ec0ffULL, 0x0000000102197824ULL, 0x000fe200078e020dULL,
0x000010000c0c7811ULL, 0x000fe200078e60ffULL, 0x0000000102397824ULL, 0x040fe200078e0213ULL,
0xfffffffc3f3f7812ULL, 0x100fe200078ee20aULL, 0x00000001023b7824ULL, 0x040fe200078e021bULL,
0xfffffffc41417812ULL, 0x100fe200078ee20aULL, 0x00000001021b7824ULL, 0x040fe200078e024dULL,
0xfffffffc43437812ULL, 0x100fe200078ee20aULL, 0x0000000102137824ULL, 0x040fe200078e024fULL,
0xfffffffc45457812ULL, 0x100fe200078ee20aULL, 0x00000001020d7824ULL, 0x040fe200078e0251ULL,
0xfffffffc47477812ULL, 0x000fe200078ee20aULL, 0x0000000102537824ULL, 0x000fe200078e0253ULL,
0x0ffffffc0a3d7812ULL, 0x000fe200078ef803ULL, 0x000000103f3f7824ULL, 0x000fe200078e020cULL,
0xfffffffc49497812ULL, 0x000fe200078ee20aULL, 0x0000001041417824ULL, 0x000fe200078e020cULL,
0xfffffffc4b4b7812ULL, 0x000fe200078ee20aULL, 0x00000010030a7824ULL, 0x000fc400078e00ffULL,
0x000000103d3d7824ULL, 0x100fe400078e020cULL, 0x0000001043437824ULL, 0x100fe200078e020cULL,
0x000000300a0f7812ULL, 0x000fe200078ec0ffULL, 0x0000001045457824ULL, 0x100fe400078e020cULL,
0x0000001047477824ULL, 0x000fe400078e020cULL, 0x00000040080e7824ULL, 0x000fe400078e020fULL,
0x000000ffff0f7224ULL, 0x000fc400078e00ffULL, 0x0000001049497824ULL, 0x000fe400078e020cULL,
0x0000008011107825ULL, 0x000fc800078e000eULL, 0x0000008019187825ULL, 0x000fe200078e000eULL,
0x0000001006107210ULL, 0x000fc60007f3e0ffULL, 0x0000008039387825ULL, 0x000fe200078e000eULL,
0x0000001806187210ULL, 0x000fc60007f5e0ffULL, 0x000000803b3a7825ULL, 0x000fe200078e000eULL,
0x0000003806387210ULL, 0x000fc60007f7e0ffULL, 0x000000801b1a7825ULL, 0x000fe200078e000eULL,
0x0000003a063a7210ULL, 0x000fc60007f9e0ffULL, 0x000000104b4b7824ULL, 0x000fe400078e020cULL,
0x0000008013127825ULL, 0x000fc800078e000eULL, 0x000000800d0c7825ULL, 0x000fc800078e000eULL,
0x00000080530e7825ULL, 0x000fc800078e000eULL, 0x0000000107117824ULL, 0x040fe200008e0611ULL,
0x0000001a061a7210ULL, 0x040fe20007f3e0ffULL, 0x0000000107197824ULL, 0x040fe200010e0619ULL,
0x0000001206127210ULL, 0x040fe20007f5e0ffULL, 0x0000000107397824ULL, 0x040fe200018e0639ULL,
0x0000000c060c7210ULL, 0x040fe20007f7e0ffULL, 0x00000001073b7824ULL, 0x040fe200020e063bULL,
0x0000000e06067210ULL, 0x000fe20007f9e0ffULL, 0x00000001071b7824ULL, 0x040fe200008e061bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000103d7faeULL, 0x0003e2000b901c48ULL,
0x0000000107137824ULL, 0x000fc400010e0613ULL, 0x00000001070d7824ULL, 0x040fe200018e060dULL,
0x00000000183f7faeULL, 0x0003e2000b901c48ULL, 0x0000000107077824ULL, 0x000fc600020e060fULL,
0x0000000038417faeULL, 0x0003e8000b901c48ULL, 0x000000003a437faeULL, 0x0003e8000b901c48ULL,
0x000000001a457faeULL, 0x0003e8000b901c48ULL, 0x0000000012477faeULL, 0x0003e8000b901c48ULL,
0x000000000c497faeULL, 0x0003e8000b901c48ULL, 0x00000000064b7faeULL, 0x0003e4000b901c48ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000010800780cULL, 0x000fe20003f25270ULL,
0x000000a000007945ULL, 0x000fd80003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x0000000405057810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff677424ULL, 0x000fc600078e00ffULL,
0x0000006d0500720cULL, 0x000fda0003f26070ULL, 0x0000004000001947ULL, 0x000fea0003800000ULL,
0x0000000273067824ULL, 0x002fe400078e0205ULL, 0x00000004ff077424ULL, 0x000fc800078e00ffULL,
0x0000640006067625ULL, 0x000fca00078e0007ULL, 0x0000000806677981ULL, 0x000324000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000002003067810ULL, 0x042fe20007ffe0ffULL, 0x0000000200077824ULL, 0x000fe200078e020bULL,
0xfffffff8030a7812ULL, 0x040fe200078ec0ffULL, 0x000000ffff087224ULL, 0x000fe200078e00ffULL,
0xfffffff806067812ULL, 0x000fe400078ec0ffULL, 0x00000007030c7812ULL, 0x000fe400078ec0ffULL,
0x000000070a0a7812ULL, 0x100fe400078ef803ULL, 0x00000007060b7812ULL, 0x000fc400078ef803ULL,
0x0000100007067811ULL, 0x000fe400078e60ffULL, 0x000000080c077812ULL, 0x000fe400078ef803ULL,
0x00000001ff6a7819ULL, 0x000fe4000001160aULL, 0x00000001ff697819ULL, 0x000fe2000001160bULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000016a0c7824ULL, 0x020fe200078e0208ULL,
0x0000000108117810ULL, 0x000fe20007ffe0ffULL, 0x000000040a0d7824ULL, 0x040fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000040a187824ULL, 0x000fc400078e00ffULL,
0x000000016a137824ULL, 0x000fe200078e0211ULL, 0xfffffffc0d0d7812ULL, 0x000fe200078ee20cULL,
0x00000001690c7824ULL, 0x100fe400078e0208ULL, 0x0000000409107824ULL, 0x000fe200078e0208ULL,
0xfffffffc18137812ULL, 0x000fe200078ee213ULL, 0x000000100d447824ULL, 0x100fe200078e0206ULL,
0x0000000208087810ULL, 0x000fe20007ffe0ffULL, 0x000000040b0d7824ULL, 0x000fe400078e00ffULL,
0x0000000210107824ULL, 0x000fe200078e00ffULL, 0x000000040800780cULL, 0x000fe20003f25270ULL,
0x0000001013137824ULL, 0x000fe200078e0206ULL, 0xfffffffc0d0d7812ULL, 0x000fe200078ee20cULL,
0x000000004444783bULL, 0x000e620000000200ULL, 0x0000001003127211ULL, 0x000fe200078fe0ffULL,
0x00000010071b7824ULL, 0x000fe200078e00ffULL, 0x0000000210107810ULL, 0x000fe20007ffe0ffULL,
0x000000100d0d7824ULL, 0x000fe200078e0206ULL, 0x000000001338783bULL, 0x000fe20000000200ULL,
0x0000000107127824ULL, 0x000fe200078e0212ULL, 0x0000001003107211ULL, 0x000fe200078fe0ffULL,
0x0000000169197824ULL, 0x000fc400078e0211ULL, 0x000000000d0c783bULL, 0x000ea20000000200ULL,
0xfffffff01b127812ULL, 0x000fe200078ee212ULL, 0x0000000107647824ULL, 0x000fe400078e0210ULL,
0x000000040b1a7824ULL, 0x000fe400078e00ffULL, 0x0000001012127824ULL, 0x000fe200078e00ffULL,
0xfffffff01b647812ULL, 0x000fe400078ee264ULL, 0xfffffffc1a197812ULL, 0x000fc600078ee219ULL,
0x000000001210783bULL, 0x000ee40000000200ULL, 0x0000001019197824ULL, 0x000fe200078e0206ULL,
0x00000018ff187819ULL, 0x002fe40000011645ULL, 0x00000010ff437819ULL, 0x100fe40000011644ULL,
0x00000018ff5b7819ULL, 0x000fe40000011644ULL, 0x000000ff44577812ULL, 0x040fe400078ec0ffULL,
0x0000ffff44447812ULL, 0x000fc400078ec0ffULL, 0x00000010ff4a7819ULL, 0x000fe40000011645ULL,
0x000000ff45407812ULL, 0x040fe400078ec0ffULL, 0x0000ffff454d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff547819ULL, 0x104fe4000001160eULL, 0x00000018ff587819ULL, 0x000fe4000001160eULL,
0x000000ff0e5e7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff0e507812ULL, 0x000fe400078ec0ffULL,
0x00000010ff417819ULL, 0x100fe40000011638ULL, 0x00000018ff567819ULL, 0x000fe40000011638ULL,
0x000000ff38497812ULL, 0x040fe400078ec0ffULL, 0x0000ffff38427812ULL, 0x000fe400078ec0ffULL,
0x00000018ff45723eULL, 0x000fc400020006ffULL, 0x00000010ff0e7819ULL, 0x100fe2000001163aULL,
0x000000001918783bULL, 0x000e620000000200ULL, 0x00000018ff4f7819ULL, 0x000fe4000001163aULL,
0x000000ff3a4e7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff3a387812ULL, 0x000fe400078ec0ffULL,
0x000000ff435f7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff3a7819ULL, 0x000fc40000011644ULL,
0x00000010ff487819ULL, 0x100fe4000001160cULL, 0x00000018ff537819ULL, 0x000fe4000001160cULL,
0x000000ff0c527812ULL, 0x040fe400078ec0ffULL, 0x0000ffff0c627812ULL, 0x000fe400078ec0ffULL,
0x00000010ff637819ULL, 0x100fe4000001160dULL, 0x00000018ff5d7819ULL, 0x000fc4000001160dULL,
0x000000ff0d5c7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff0d607812ULL, 0x000fe400078ec0ffULL,
0x00000010ff517819ULL, 0x100fe4000001160fULL, 0x00000018ff597819ULL, 0x000fe4000001160fULL,
0x000000ff0f5a7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff0f557812ULL, 0x000fc400078ec0ffULL,
0x00000010ff0c7819ULL, 0x100fe40000011639ULL, 0x00000018ff4b7819ULL, 0x000fe40000011639ULL,
0x000000ff394c7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff390d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff0f7819ULL, 0x100fe4000001163bULL, 0x00000018ff447819ULL, 0x000fc4000001163bULL,
0x000000ff3b437812ULL, 0x040fe400078ec0ffULL, 0x0000ffff3b397812ULL, 0x000fe400078ec0ffULL,
0x0000005bff5b723eULL, 0x000fe400020006ffULL, 0x00000057ff57723eULL, 0x000fe400020006ffULL,
0x0000005fff3b723eULL, 0x000fe400020006ffULL, 0x0000003aff3a723eULL, 0x000fc400020006ffULL,
0x000054103b3b7816ULL, 0x000fe4000000005bULL, 0x00005410573a7816ULL, 0x000fe4000000003aULL,
0x000000ff4a4a7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff4d7819ULL, 0x000fe4000001164dULL,
0x00000040ff40723eULL, 0x000fe200020006ffULL, 0x0000003a1034723cULL, 0x008b620000001834ULL,
0x00000010ff3e7819ULL, 0x000fc40000011646ULL, 0x0000ffff463f7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff3d7819ULL, 0x000fe40000011646ULL, 0x0000004aff3b723eULL, 0x020fe400020006ffULL,
0x0000004dff3a723eULL, 0x000fe400020006ffULL, 0x000054103b3b7816ULL, 0x000fe40000000045ULL,
0x00005410403a7816ULL, 0x000fc4000000003aULL, 0x000000ff463c7812ULL, 0x000fe400078ec0ffULL,
0x000000ff3e3e7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff3f7819ULL, 0x000fe2000001163fULL,
0x0000003a1030723cULL, 0x000b620000001830ULL, 0x0000003dff3d723eULL, 0x000fe400020006ffULL,
0x0000003cff3c723eULL, 0x000fe400020006ffULL, 0x00000010ff467819ULL, 0x000fc40000011647ULL,
0x0000003eff3b723eULL, 0x020fe400020006ffULL, 0x0000003fff3a723eULL, 0x000fe400020006ffULL,
0x000054103b3b7816ULL, 0x000fe4000000003dULL, 0x000054103c3a7816ULL, 0x000fe4000000003aULL,
0x00000018ff657819ULL, 0x000fe40000011647ULL, 0x000000ff47617812ULL, 0x000fc400078ec0ffULL,
0x0000ffff47477812ULL, 0x000fe200078ec0ffULL, 0x0000003a102c723cULL, 0x000b62000000182cULL,
0x00000018ff5f7819ULL, 0x102fe40000011618ULL, 0x000000ff185b7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff183c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff3a7819ULL, 0x020fe40000011618ULL,
0x00000010ff3b7819ULL, 0x000fc40000011619ULL, 0x00000018ff577819ULL, 0x000fe40000011619ULL,
0x000000ff194d7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff193d7812ULL, 0x000fe400078ec0ffULL,
0x000000ff46197812ULL, 0x000fe400078ec0ffULL, 0x00000008ff187819ULL, 0x000fe40000011647ULL,
0x00000065ff65723eULL, 0x000fc400020006ffULL, 0x00000061ff61723eULL, 0x000fe400020006ffULL,
0x00000019ff19723eULL, 0x000fe400020006ffULL, 0x00000018ff18723eULL, 0x000fe400020006ffULL,
0x000000ff48777812ULL, 0x000fe400078ec0ffULL, 0x00000008ff627819ULL, 0x000fe40000011662ULL,
0x0000541019197816ULL, 0x000fc40000000065ULL, 0x0000541061187816ULL, 0x000fe40000000018ULL,
0x00000010ff3e7819ULL, 0x100fe4000001161aULL, 0x00000018ff407819ULL, 0x000fe4000001161aULL,
0x000000ff1a3f7812ULL, 0x040fe200078ec0ffULL, 0x000000181028723cULL, 0x000b620000001828ULL,
0x0000ffff1a457812ULL, 0x000fe200078ec0ffULL, 0x00000010641a7824ULL, 0x000fe200078e00ffULL,
0x00000053ff53723eULL, 0x000fc400020006ffULL, 0x00000052ff52723eULL, 0x000fe400020006ffULL,
0x00000077ff77723eULL, 0x000fe400020006ffULL, 0x00000062ff62723eULL, 0x000fe400020006ffULL,
0x0000541077537816ULL, 0x000fe40000000053ULL, 0x0000541052527816ULL, 0x000fe40000000062ULL,
0x00000010ff467819ULL, 0x000fc4000001161bULL, 0x00000018ff477819ULL, 0x000fe4000001161bULL,
0x000000ff1b487812ULL, 0x040fe200078ec0ffULL, 0x000000521024723cULL, 0x000b620000001824ULL,
0x0000ffff1b4a7812ULL, 0x000fe400078ec0ffULL, 0x000000001a18783bULL, 0x020e620000000200ULL,
0x000000ff63637812ULL, 0x000fe400078ec0ffULL, 0x00000008ff607819ULL, 0x000fe40000011660ULL,
0x000000ff54527812ULL, 0x000fc400078ec0ffULL, 0x00000008ff547819ULL, 0x000fe40000011650ULL,
0x00000008ff507819ULL, 0x000fe40000011655ULL, 0x0000005dff5d723eULL, 0x000fe400020006ffULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x00000063ff61723eULL, 0x000fe400020006ffULL,
0x00000060ff60723eULL, 0x000fc400020006ffULL, 0x00000052ff55723eULL, 0x000fe400020006ffULL,
0x000000ff51537812ULL, 0x000fe400078ec0ffULL, 0x00000050ff52723eULL, 0x000fe400020006ffULL,
0x0000541061517816ULL, 0x000fe4000000005dULL, 0x000054105c507816ULL, 0x000fe40000000060ULL,
0x00000058ff58723eULL, 0x000fc400020006ffULL, 0x0000005eff5e723eULL, 0x000fe400020006ffULL,
0x00000059ff59723eULL, 0x000fe200020006ffULL, 0x000000501020723cULL, 0x000b620000001820ULL,
0x0000005aff5a723eULL, 0x000fe400020006ffULL, 0x00000054ff54723eULL, 0x000fe400020006ffULL,
0x00000053ff53723eULL, 0x000fe400020006ffULL, 0x00000049ff51723eULL, 0x020fc400020006ffULL,
0x0000004bff50723eULL, 0x000fe400020006ffULL, 0x0000004fff49723eULL, 0x000fe400020006ffULL,
0x0000004eff4b723eULL, 0x000fe400020006ffULL, 0x00005410554f7816ULL, 0x000fe40000000058ULL,
0x000054105e4e7816ULL, 0x000fe40000000054ULL, 0x0000541053597816ULL, 0x000fc40000000059ULL,
0x000054105a587816ULL, 0x000fe40000000052ULL, 0x000000ff41417812ULL, 0x000fe200078ec0ffULL,
0x0000004e101c723cULL, 0x040f62000000181cULL, 0x00000008ff427819ULL, 0x000fe40000011642ULL,
0x00000056ff56723eULL, 0x000fe400020006ffULL, 0x00000041ff41723eULL, 0x000fe400020006ffULL,
0x00000042ff42723eULL, 0x000fe200020006ffULL, 0x000000581014723cULL, 0x000b620000001814ULL,
0x0000004cff4c723eULL, 0x000fc400020006ffULL, 0x000000ff0e0e7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff387819ULL, 0x000fe40000011638ULL, 0x000000ff0c117812ULL, 0x020fe400078ec0ffULL,
0x00000008ff107819ULL, 0x000fe4000001160dULL, 0x00005410410d7816ULL, 0x000fe40000000056ULL,
0x00005410510c7816ULL, 0x000fc40000000042ULL, 0x000000ff0f0f7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff397819ULL, 0x000fe40000011639ULL, 0x00000044ff44723eULL, 0x000fe200020006ffULL,
0x0000000c1834723cULL, 0x002b620000001834ULL, 0x00000043ff43723eULL, 0x000fe400020006ffULL,
0x000000ff3a3a7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff3c7819ULL, 0x000fc4000001163cULL,
0x00000011ff0d723eULL, 0x020fe400020006ffULL, 0x00000010ff0c723eULL, 0x000fe400020006ffULL,
0x000054100d0d7816ULL, 0x000fe40000000050ULL, 0x000054104c0c7816ULL, 0x000fe4000000000cULL,
0x000000ff3b3b7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff3d7819ULL, 0x000fc4000001163dULL,
0x000000ff3e3e7812ULL, 0x000fe200078ec0ffULL, 0x0000000c1830723cULL, 0x000b620000001830ULL,
0x00000008ff457819ULL, 0x000fe40000011645ULL, 0x000000ff46467812ULL, 0x000fe400078ec0ffULL,
0x00000008ff4a7819ULL, 0x000fe4000001164aULL, 0x0000000eff0d723eULL, 0x020fe400020006ffULL,
0x00000038ff0c723eULL, 0x000fc400020006ffULL, 0x000054100d0d7816ULL, 0x000fe40000000049ULL,
0x000054104b0c7816ULL, 0x000fe4000000000cULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x0000005bff5b723eULL, 0x000fe400020006ffULL, 0x00000057ff57723eULL, 0x000fe200020006ffULL,
0x0000000c182c723cULL, 0x000b62000000182cULL, 0x0000004dff4d723eULL, 0x000fc400020006ffULL,
0x00000040ff40723eULL, 0x000fe400020006ffULL, 0x0000003aff3a723eULL, 0x000fe400020006ffULL,
0x0000000fff0d723eULL, 0x020fe400020006ffULL, 0x00000039ff0c723eULL, 0x000fe400020006ffULL,
0x000054100d0d7816ULL, 0x000fe40000000044ULL, 0x00005410430c7816ULL, 0x000fc4000000000cULL,
0x0000003cff3c723eULL, 0x000fe400020006ffULL, 0x0000003fff3f723eULL, 0x000fe400020006ffULL,
0x0000003bff3b723eULL, 0x000fe200020006ffULL, 0x0000000c1828723cULL, 0x000b620000001828ULL,
0x0000003dff3d723eULL, 0x000fe400020006ffULL, 0x00000047ff47723eULL, 0x000fe400020006ffULL,
0x00000045ff45723eULL, 0x000fc400020006ffULL, 0x0000003eff0d723eULL, 0x020fe400020006ffULL,
0x00000048ff48723eULL, 0x000fe400020006ffULL, 0x00000046ff49723eULL, 0x000fe400020006ffULL,
0x0000004aff4a723eULL, 0x000fe400020006ffULL, 0x000054103a5f7816ULL, 0x000fe4000000005fULL,
0x000054105b5e7816ULL, 0x000fc4000000003cULL, 0x000054103b577816ULL, 0x000fe40000000057ULL,
0x000054104d567816ULL, 0x000fe4000000003dULL, 0x000054100d0d7816ULL, 0x000fe20000000040ULL,
0x0000005e1824723cULL, 0x000b620000001824ULL, 0x000054103f0c7816ULL, 0x000fe40000000045ULL,
0x0000541049497816ULL, 0x000fe40000000047ULL, 0x0000541048487816ULL, 0x000fc6000000004aULL,
0x000000561820723cULL, 0x040b700000001820ULL, 0x0000000c181c723cULL, 0x040b70000000181cULL,
0x000000481814723cULL, 0x000b620000001814ULL, 0xfffff09000001947ULL, 0x000fce000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff0b7224ULL, 0x000fe200078e0004ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffe2b000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x0000006b31317220ULL, 0x080fe20000410000ULL,
0x0000006b2d2d7220ULL, 0x080fe20000410000ULL, 0x0000006b35357220ULL, 0x080fe20000410000ULL,
0x0000006b30307220ULL, 0x080fe20000410000ULL, 0x0000006b24247220ULL, 0x0a0fe20000410000ULL,
0x0000006b1c1c7220ULL, 0x080fe20000410000ULL, 0x0000006b33067220ULL, 0x080fe20000410000ULL,
0x0000006b2f0a7220ULL, 0x080fe20000410000ULL, 0x0000006b29337220ULL, 0x080fe20000410000ULL,
0x0000006b27127220ULL, 0x080fe20000410000ULL, 0x0000006b2e077220ULL, 0x080fe20000410000ULL,
0x0000006b2a0b7220ULL, 0x080fe20000410000ULL, 0x0000006b2b0c7220ULL, 0x080fe20000410000ULL,
0x0000006b25297220ULL, 0x080fe20000410000ULL, 0x0000006b260d7220ULL, 0x080fe20000410000ULL,
0x0000006b230f7220ULL, 0x080fe20000410000ULL, 0x000000ffff2f7224ULL, 0x000fe200078e0031ULL,
0x0000006b34137220ULL, 0x080fe20000410000ULL, 0x000000ffff277224ULL, 0x000fe200078e002dULL,
0x0000006b36367220ULL, 0x080fe20000410000ULL, 0x0000006b37377220ULL, 0x080fe20000410000ULL,
0x0000006b32327220ULL, 0x080fe20000410000ULL, 0x0000006b2c2c7220ULL, 0x080fe20000410000ULL,
0x0000006b28287220ULL, 0x080fe20000410000ULL, 0x0000006b202a7220ULL, 0x080fe20000410000ULL,
0x0000006b212e7220ULL, 0x080fe20000410000ULL, 0x0000006b220e7220ULL, 0x080fe20000410000ULL,
0x0000006b1d2b7220ULL, 0x080fe20000410000ULL, 0x0000006b1e197220ULL, 0x080fe20000410000ULL,
0x0000006b1f1a7220ULL, 0x080fe20000410000ULL, 0x0000006b14237220ULL, 0x080fe20000410000ULL,
0x0000006b15157220ULL, 0x080fe20000410000ULL, 0x0000006b161b7220ULL, 0x080fe20000410000ULL,
0x0000006b17107220ULL, 0x000fe20000410000ULL, 0x000000ffff257224ULL, 0x000fc400078e0035ULL,
0x000000ffff267224ULL, 0x000fe400078e0030ULL, 0x000000ffff317224ULL, 0x000fe400078e0024ULL,
0x000000ffff2d7224ULL, 0x000fe200078e001cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000076087f8cULL, 0x0002a2000c80043fULL, 0x000000ffff247224ULL, 0x000fe400078e0015ULL,
0x000000ffff177224ULL, 0x000fe400078e0032ULL, 0x000000ffff1e7224ULL, 0x000fc400078e0036ULL,
0x000000ffff167224ULL, 0x000fe400078e0037ULL, 0x000000ffff307224ULL, 0x000fe400078e0006ULL,
0x000000ffff207224ULL, 0x000fe400078e0007ULL, 0x000000ffff1f7224ULL, 0x000fe400078e000aULL,
0x000000ffff217224ULL, 0x000fe400078e000bULL, 0x000000ffff327224ULL, 0x000fc400078e000cULL,
0x000000ffff227224ULL, 0x000fe400078e000dULL, 0x000000ffff147224ULL, 0x000fe400078e000eULL,
0x000000ffff157224ULL, 0x000fe400078e000fULL, 0x000000ffff1c7224ULL, 0x000fc400078e0010ULL,
0x0000000000067805ULL, 0x006fca0000015200ULL, 0x00000400760b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a060d7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e07ULL,
0x003d09000d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0a7819ULL, 0x000fc8000001140bULL, 0x0000000d0a0a7211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060bULL, 0x000000020a0a7819ULL, 0x000fc8000000120bULL,
0x0000000a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000400760b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004031d7824ULL, 0x000fe200078e00ffULL,
0x000000746800720cULL, 0x000fc80003f06070ULL, 0xfffffff01d077812ULL, 0x000fca00078ec0ffULL,
0x0000008000187824ULL, 0x000fca00078e0207ULL, 0x00f4000018087984ULL, 0x0002a20000000c00ULL,
0x0000136000008947ULL, 0x000fea0003800000ULL, 0x0000010068077824ULL, 0x000fe200078e0278ULL,
0x0000007103067211ULL, 0x040fe200078ff0ffULL, 0x0000000203357824ULL, 0x000fe400078e00ffULL,
0x00000002ff4a7424ULL, 0x000fe200078e00ffULL, 0x000000076c347217ULL, 0x000fe40007800000ULL,
0x0000000635357812ULL, 0x000fe400078ec0ffULL, 0x00005a00ff0c7a19ULL, 0x000fe20000011606ULL,
0x0000000134347824ULL, 0x000fe200078e0a07ULL, 0x0000580035377a10ULL, 0x000fe20007ffe0ffULL,
0x000000016f077824ULL, 0x000fe200078e0235ULL, 0x0000000c75517217ULL, 0x000fc40003800000ULL,
0x000000343700720cULL, 0x080fe20003f06070ULL, 0x0000000107107824ULL, 0x140fe200078e0a34ULL,
0x000000340700720cULL, 0x000fe20003f26070ULL, 0x00000001370e7824ULL, 0x000fe400078e0a34ULL,
0x0000005170517224ULL, 0x000fe200078e02ffULL, 0x0000001075107217ULL, 0x040fe40003800000ULL,
0x0000000e750e7217ULL, 0x000fe40003800000ULL, 0x00000004ff107819ULL, 0x000fc40000011610ULL,
0x000000ff0e427207ULL, 0x000fe40000000000ULL, 0x000000ff10107207ULL, 0x000fe40000800000ULL,
0x0000005142077211ULL, 0x000fe400078fe0ffULL, 0x00000008060e7810ULL, 0x000fe20007ffe0ffULL,
0x00000001510d7824ULL, 0x000fe200078e0210ULL, 0x00000010353d7812ULL, 0x000fe200078efcffULL,
0x0000600007067625ULL, 0x000fe200078e004aULL, 0x00005a00ff0e7a19ULL, 0x000fc6000001160eULL,
0x000060000d0c7625ULL, 0x000fe200078e004aULL, 0x000058003d397a10ULL, 0x000fe20007ffe0ffULL,
0x0000000806487981ULL, 0x0046a2000c1e9500ULL, 0x0000000e75537217ULL, 0x000fc60003800000ULL,
0x000000080c4f7981ULL, 0x0002a2000c1e9500ULL, 0x00000020353b7812ULL, 0x000fe200078efcffULL,
0x0000005370537224ULL, 0x000fe400078e02ffULL, 0x0000000139067824ULL, 0x108fe400078e0a34ULL,
0x000000016f077824ULL, 0x000fe200078e023dULL, 0x000000343900720cULL, 0x000fe20003f06070ULL,
0x0000000110117824ULL, 0x000fe200078e0253ULL, 0x0000000675067217ULL, 0x000fe20003800000ULL,
0x00000001070c7824ULL, 0x002fe200078e0a34ULL, 0x000058003b417a10ULL, 0x000fe20007ffe0ffULL,
0x0000600011107625ULL, 0x000fe200078e004aULL, 0x00000053420f7211ULL, 0x000fc400078fe0ffULL,
0x000000ff06367207ULL, 0x000fe20000000000ULL, 0x00000001413c7824ULL, 0x000fe200078e0a34ULL,
0x0000000c750c7217ULL, 0x000fe20003800000ULL, 0x000060000f0e7625ULL, 0x000fe200078e004aULL,
0x000000340700720cULL, 0x080fe20003f26070ULL, 0x00000008104d7981ULL, 0x0002e2000c1e9500ULL,
0x0000005136077211ULL, 0x000fe200078fe0ffULL, 0x000000016f457824ULL, 0x000fe200078e023bULL,
0x00000004ff0c7819ULL, 0x000fe2000001160cULL, 0x000000080e447981ULL, 0x0002e2000c1e9500ULL,
0x000000344100720cULL, 0x000fc40003f06070ULL, 0x0000003c753c7217ULL, 0x000fe20003800000ULL,
0x0000600007067625ULL, 0x000fc600078e004aULL, 0x000000ff3c3c7207ULL, 0x000fe20000000000ULL,
0x00000001453e7824ULL, 0x040fe200078e0a34ULL, 0x0000000806387981ULL, 0x0002e4000c1e9500ULL,
0x000000ff0c0e7207ULL, 0x002fe40000800000ULL, 0x000000344500720cULL, 0x000fe40003f26070ULL,
0x0000003035457812ULL, 0x000fe200078efcffULL, 0x00000001510d7824ULL, 0x000fe200078e020eULL,
0x00000053360f7211ULL, 0x000fe200078fe0ffULL, 0x000000010e117824ULL, 0x000fe200078e0253ULL,
0x0000003e753e7217ULL, 0x000fc40003800000ULL, 0x000000513c077211ULL, 0x000fe200078fe0ffULL,
0x000000016f557824ULL, 0x000fe200078e0245ULL, 0x00000004ff3e7819ULL, 0x000fe2000001163eULL,
0x000060000d0c7625ULL, 0x000fe200078e004aULL, 0x0000580045477a10ULL, 0x000fc60007ffe0ffULL,
0x000060000f0e7625ULL, 0x000fc800078e004aULL, 0x0000600011107625ULL, 0x080fe200078e004aULL,
0x000000ff3e407207ULL, 0x000fe20000800000ULL, 0x000000080c3f7981ULL, 0x0002e4000c1e9500ULL,
0x0000600007067625ULL, 0x000fe400078e004aULL, 0x000000080e3a7981ULL, 0x0002e4000c1e9500ULL,
0x0000000155467824ULL, 0x000fe400078e0a34ULL, 0x0000000810437981ULL, 0x0002e8000c1e9500ULL,
0x00000008063e7981ULL, 0x0002e2000c1e9500ULL, 0x0000004675467217ULL, 0x000fe20003800000ULL,
0x00000001510d7824ULL, 0x002fe200078e0240ULL, 0x000000533c0f7211ULL, 0x000fe200078fe0ffULL,
0x0000000140117824ULL, 0x000fc400078e0253ULL, 0x0000000147067824ULL, 0x040fe200078e0a34ULL,
0x000000344700720cULL, 0x000fe20003f06070ULL, 0x000060000d0c7625ULL, 0x000fe200078e004aULL,
0x000000345500720cULL, 0x000fe40003f26070ULL, 0x0000000675067217ULL, 0x000fe20003800000ULL,
0x000060000f0e7625ULL, 0x080fe200078e004aULL, 0x00000004ff077819ULL, 0x000fe20000011646ULL,
0x000000080c497981ULL, 0x0002e4000c1e9500ULL, 0x0000600011107625ULL, 0x000fe200078e004aULL,
0x000000ff06467207ULL, 0x000fe20000000000ULL, 0x000000080e407981ULL, 0x0002e2000c1e9500ULL,
0x000000ff074c7207ULL, 0x000fc60000800000ULL, 0x00000008104b7981ULL, 0x0002e2000c1e9500ULL,
0x0000005146077211ULL, 0x000fe200078fe0ffULL, 0x00000001510d7824ULL, 0x002fc800078e024cULL,
0x0000600007067625ULL, 0x000fc800078e004aULL, 0x000060000d0c7625ULL, 0x000fe400078e004aULL,
0x0000000806067981ULL, 0x0002e2000c1e9500ULL, 0x00000053460f7211ULL, 0x000fc600078fe0ffULL,
0x000000080c0d7981ULL, 0x0002e2000c1e9500ULL, 0x000000014c117824ULL, 0x000fe400078e0253ULL,
0x000060000f0e7625ULL, 0x000fc800078e004aULL, 0x0000600011107625ULL, 0x000fe400078e004aULL,
0x000000080e0e7981ULL, 0x0002e8000c1e9500ULL, 0x0000000810117981ULL, 0x0002e2000c1e9500ULL,
0xfffffff042517812ULL, 0x000fe200078ec0ffULL, 0x00000001ff427424ULL, 0x000fe200078e00ffULL,
0x0000000135077812ULL, 0x002fc600078efcffULL, 0x00000001344a7824ULL, 0x000fe200078e0251ULL,
0x0000000935537812ULL, 0x000fc600078efcffULL, 0x0000000137577824ULL, 0x100fe200078e0a4aULL,
0x0000580007557a10ULL, 0x000fe40007ffe0ffULL, 0x00005800530f7a10ULL, 0x000fe40007ffe0ffULL,
0x0000005742577219ULL, 0x000fe200000006ffULL, 0x0000000155597824ULL, 0x100fe400078e0a4aULL,
0x000000010f5d7824ULL, 0x000fc600078e0a4aULL, 0x0000005942597219ULL, 0x040fe400000006ffULL,
0x0000005d425d7219ULL, 0x000fe400000006ffULL, 0x00000011357d7812ULL, 0x040fe400078efcffULL,
0x00000018357b7812ULL, 0x040fe400078efcffULL, 0x0000001935777812ULL, 0x000fe400078efcffULL,
0x000058007b107a10ULL, 0x000fc40007ffe0ffULL, 0x00005800770c7a10ULL, 0x000fe40007ffe0ffULL,
0x0000002135617812ULL, 0x040fe400078efcffULL, 0x00000028355f7812ULL, 0x000fe400078efcffULL,
0xfffffff046467812ULL, 0x000fe400078ec0ffULL, 0x0000580061697a10ULL, 0x000fe40007ffe0ffULL,
0x000058005f657a10ULL, 0x000fe20007ffe0ffULL, 0x00000001344c7824ULL, 0x000fc800078e0246ULL,
0x00000001474e7824ULL, 0x000fca00078e0a4cULL, 0x0000004e424e7219ULL, 0x000fe400000006ffULL,
0x0000541048487816ULL, 0x004fe4000000004fULL, 0x00000008354f7812ULL, 0x000fc800078efcffULL,
0x000058004f517a10ULL, 0x000fe40007ffe0ffULL, 0x0000004857ff7212ULL, 0x000fc6000780c0ffULL,
0x00000001515b7824ULL, 0x000fe200078e0a4aULL, 0x000000343700720cULL, 0x000fc80000701470ULL,
0x0000005b425b7219ULL, 0x000fe400000006ffULL, 0x0000004859ff7212ULL, 0x080fe4000786c0ffULL,
0x000000485bff7212ULL, 0x080fe4000784c0ffULL, 0x000000485dff7212ULL, 0x000fe4000782c0ffULL,
0x000000343500720cULL, 0x000fe40000701070ULL, 0x0000541044447816ULL, 0x008fc4000000004dULL,
0xfffffff036487812ULL, 0x000fe400078ec0ffULL, 0xff80000013137808ULL, 0x000fe40000000000ULL,
0x0000004457ff7212ULL, 0x080fe2000788c0ffULL, 0x0000000134487824ULL, 0x000fe200078e0248ULL,
0x0000004459ff7212ULL, 0x080fe400078ac0ffULL, 0x000000445bff7212ULL, 0x080fe400078cc0ffULL,
0x000000445dff7212ULL, 0x000fc4000780c0ffULL, 0x000058007d447a10ULL, 0x000fe20007ffe0ffULL,
0x0000000139507824ULL, 0x100fe200078e0a48ULL, 0x000000343700720cULL, 0x080fe20002781470ULL,
0x0000000110547824ULL, 0x100fe200078e0a48ULL, 0x000000345100720cULL, 0x080fe200037c1470ULL,
0x0000000144527824ULL, 0x100fe200078e0a48ULL, 0x000000340f00720cULL, 0x000fe20000701470ULL,
0x000000010c567824ULL, 0x000fe200078e0a48ULL, 0x0000005042487219ULL, 0x000fe400000006ffULL,
0xfffffff03c4a7812ULL, 0x000fc400078ec0ffULL, 0x0000005242507219ULL, 0x040fe400000006ffULL,
0x000000343500720cULL, 0x080fe40002781070ULL, 0x000000344f00720cULL, 0x080fe400037c1070ULL,
0x000000345300720cULL, 0x000fe40000701070ULL, 0x0000005442527219ULL, 0x000fe400000006ffULL,
0x00005410383f7816ULL, 0x000fe2000000003fULL, 0x00000001344a7824ULL, 0x000fe200078e024aULL,
0x000000340f00720cULL, 0x000fc40000f21470ULL, 0x000054103a437816ULL, 0x000fe40000000043ULL,
0xff8000001e1e7808ULL, 0x000fe40002000000ULL, 0xff80000017177808ULL, 0x000fe40003000000ULL,
0xff80000030307808ULL, 0x000fe40000000000ULL, 0x0000003f48ff7212ULL, 0x040fe4000788c0ffULL,
0x0000004348ff7212ULL, 0x000fc400078cc0ffULL, 0x0000004352ff7212ULL, 0x000fe2000780c0ffULL,
0x0000000141587824ULL, 0x000fe200078e0a4aULL, 0x000000345300720cULL, 0x080fe40000f21070ULL,
0x000000345500720cULL, 0x0c0fe40001f61470ULL, 0x000000345500720cULL, 0x080fe40002fa1470ULL,
0x000000345100720cULL, 0x080fe40001741470ULL, 0x000000343900720cULL, 0x000fc40002781470ULL,
0x000000343900720cULL, 0x080fe400037c1470ULL, 0x000000341000720cULL, 0x080fe40000701470ULL,
0xff8000002f2f7808ULL, 0x000fe40000800000ULL, 0x00000029355d7812ULL, 0x000fe400078efcffULL,
0x000000340700720cULL, 0x0c0fe40001f61070ULL, 0x000000340700720cULL, 0x000fc40002fa1070ULL,
0x000000344f00720cULL, 0x080fe40001741070ULL, 0x000000343d00720cULL, 0x0c0fe40002721070ULL,
0x000000343d00720cULL, 0x080fe400037c1070ULL, 0x000000347b00720cULL, 0x000fe40000701070ULL,
0x0000005642567219ULL, 0x040fe400000006ffULL, 0x0000005842547219ULL, 0x000fc400000006ffULL,
0x000054103e497816ULL, 0x000fe40000000049ULL, 0x00005410404b7816ULL, 0x000fe4000000004bULL,
0x000058005d637a10ULL, 0x000fe40007ffe0ffULL, 0xff80000025257808ULL, 0x000fe40001800000ULL,
0xff80000016167808ULL, 0x000fe40002800000ULL, 0xff80000026267808ULL, 0x000fc40001000000ULL,
0xff8000002c2c7808ULL, 0x000fe40000800000ULL, 0xff80000020207808ULL, 0x000fe40003000000ULL,
0xff80000021217808ULL, 0x000fe40000000000ULL, 0x0000003f50ff7212ULL, 0x080fe4000786c0ffULL,
0x0000003f52ff7212ULL, 0x080fe400078ac0ffULL, 0x0000003f56ff7212ULL, 0x000fc4000784c0ffULL,
0x0000004350ff7212ULL, 0x080fe4000788c0ffULL, 0x0000004356ff7212ULL, 0x000fe4000782c0ffULL,
0x0000004954ff7212ULL, 0x040fe400078cc0ffULL, 0x0000004b54ff7212ULL, 0x000fe2000780c0ffULL,
0x00000001695a7824ULL, 0x100fe200078e0a4aULL, 0x000000344400720cULL, 0x0c0fe20001f61470ULL,
0x00000001655c7824ULL, 0x100fe200078e0a4aULL, 0x000000344400720cULL, 0x080fe20002781470ULL,
0x00000001635e7824ULL, 0x000fe200078e0a4aULL, 0x000000341000720cULL, 0x000fc40002fa1470ULL,
0x000000340c00720cULL, 0x0c0fe40001741470ULL, 0x000000340c00720cULL, 0x080fe40000f21470ULL,
0x000000344100720cULL, 0x0c0fe400037c1470ULL, 0x000000344100720cULL, 0x000fe40000701470ULL,
0x0000003135597812ULL, 0x040fe400078efcffULL, 0x0000003835577812ULL, 0x000fc400078efcffULL,
0x00000039354d7812ULL, 0x000fe400078efcffULL, 0x0000005a42587219ULL, 0x000fe400000006ffULL,
0x000000347d00720cULL, 0x0c0fe40001f61070ULL, 0x000000347d00720cULL, 0x080fe40002781070ULL,
0x000000347b00720cULL, 0x080fe40002fa1070ULL, 0x000000347700720cULL, 0x000fc40001741070ULL,
0x000000347700720cULL, 0x080fe40000f21070ULL, 0x000000343b00720cULL, 0x0c0fe400037c1070ULL,
0x000000343b00720cULL, 0x000fe40000701070ULL, 0x0000005c425a7219ULL, 0x040fe400000006ffULL,
0x0000005e425e7219ULL, 0x000fe400000006ffULL, 0x00005410060d7816ULL, 0x000fc4000000000dULL,
0x00005800595b7a10ULL, 0x000fe40007ffe0ffULL, 0x0000580057367a10ULL, 0x000fe40007ffe0ffULL,
0x000058004d3c7a10ULL, 0x000fe40007ffe0ffULL, 0xff80000027277808ULL, 0x000fe40001800000ULL,
0xff8000001f1f7808ULL, 0x000fe40002000000ULL, 0xff80000028287808ULL, 0x000fc40002800000ULL,
0xff80000033337808ULL, 0x000fe40001000000ULL, 0xff80000032327808ULL, 0x000fe40000800000ULL,
0xff80000031317808ULL, 0x000fe40003000000ULL, 0xff80000022227808ULL, 0x000fe40000000000ULL,
0x0000004958ff7212ULL, 0x080fe4000786c0ffULL, 0x000000495aff7212ULL, 0x000fc4000788c0ffULL,
0x000000495eff7212ULL, 0x000fe400078ac0ffULL, 0x0000004b58ff7212ULL, 0x080fe4000784c0ffULL,
0x0000004b5aff7212ULL, 0x080fe4000782c0ffULL, 0x0000004b5eff7212ULL, 0x000fe400078cc0ffULL,
0x0000000d4eff7212ULL, 0x000fe2000780c0ffULL, 0x000000015b4a7824ULL, 0x100fe200078e0a4cULL,
0x000000346900720cULL, 0x0c0fe20001f61470ULL, 0x0000000136467824ULL, 0x100fe200078e0a4cULL,
0x000000346900720cULL, 0x080fe20001741470ULL, 0x000000013c4c7824ULL, 0x000fe200078e0a4cULL,
0x000000346500720cULL, 0x000fc40002781470ULL, 0x000000346500720cULL, 0x080fe40000f21470ULL,
0x000000346300720cULL, 0x0c0fe40002fa1470ULL, 0x000000346300720cULL, 0x080fe400037c1470ULL,
0x000000344700720cULL, 0x080fe40000701470ULL, 0x000000346100720cULL, 0x0c0fe40001f61070ULL,
0x000000346100720cULL, 0x000fc40001741070ULL, 0x000000345f00720cULL, 0x0c0fe40002781070ULL,
0x000000345f00720cULL, 0x080fe40000f21070ULL, 0x000000345d00720cULL, 0x0c0fe40002fa1070ULL,
0x000000345d00720cULL, 0x080fe400037c1070ULL, 0x000000344500720cULL, 0x000fe40000701070ULL,
0x0000004a424a7219ULL, 0x000fc400000006ffULL, 0x0000004642467219ULL, 0x040fe400000006ffULL,
0x0000004c424c7219ULL, 0x000fe400000006ffULL, 0x000054100e117816ULL, 0x000fe40000000011ULL,
0xff80000029297808ULL, 0x000fe40001800000ULL, 0xff80000012127808ULL, 0x000fe40001000000ULL,
0xff8000002a2a7808ULL, 0x000fc40002000000ULL, 0xff80000014147808ULL, 0x000fe40000800000ULL,
0xff8000002e2e7808ULL, 0x000fe40002800000ULL, 0xff80000015157808ULL, 0x000fe40003000000ULL,
0xff8000002d2d7808ULL, 0x000fe40000000000ULL, 0x0000000d4aff7212ULL, 0x080fe4000786c0ffULL,
0x0000000d46ff7212ULL, 0x000fc4000784c0ffULL, 0x0000000d4cff7212ULL, 0x000fe4000788c0ffULL,
0x000000114eff7212ULL, 0x080fe4000782c0ffULL, 0x000000114aff7212ULL, 0x080fe400078ac0ffULL,
0x0000001146ff7212ULL, 0x080fe400078cc0ffULL, 0x000000114cff7212ULL, 0x000fe4000780c0ffULL,
0x000000344700720cULL, 0x000fc40000f21470ULL, 0x000000345b00720cULL, 0x0c0fe40001f61470ULL,
0x000000345b00720cULL, 0x080fe40002fa1470ULL, 0x000000343600720cULL, 0x0c0fe40001741470ULL,
0x000000343600720cULL, 0x080fe400037c1470ULL, 0x000000343c00720cULL, 0x0c0fe40002781470ULL,
0x000000343c00720cULL, 0x000fc40000701470ULL, 0x000000344500720cULL, 0x080fe40000f21070ULL,
0x000000345900720cULL, 0x0c0fe40001f61070ULL, 0x000000345900720cULL, 0x080fe40002fa1070ULL,
0x000000345700720cULL, 0x0c0fe40001741070ULL, 0x000000345700720cULL, 0x080fe400037c1070ULL,
0x000000344d00720cULL, 0x000fc40002781070ULL, 0x000000344d00720cULL, 0x000fe40000701070ULL,
0xff8000002b2b7808ULL, 0x000fe40001800000ULL, 0xff80000023237808ULL, 0x000fe40001000000ULL,
0xff80000024247808ULL, 0x000fe40002000000ULL, 0xff80000019197808ULL, 0x000fe40000800000ULL,
0xff8000001a1a7808ULL, 0x000fc40002800000ULL, 0xff8000001b1b7808ULL, 0x000fe40003000000ULL,
0xff8000001c1c7808ULL, 0x000fc40000000000ULL, 0x000000130800720bULL, 0x004fe20003f1e000ULL,
0x0000001fff117424ULL, 0x000fe200078e00ffULL, 0x0000001e0900720bULL, 0x000fe20003f3e000ULL,
0xffffffffff367424ULL, 0x000fe200078e00ffULL, 0x0000000813087208ULL, 0x000fe40004000000ULL,
0x000000091e097208ULL, 0x000fe40004800000ULL, 0x000000250800720bULL, 0x000fc40003f1e000ULL,
0x000000160900720bULL, 0x000fe40003f3e000ULL, 0x0000000825077208ULL, 0x000fe40004000000ULL,
0x0000000916067208ULL, 0x000fe40004800000ULL, 0x000000260700720bULL, 0x000fe40003f1e000ULL,
0x000000170600720bULL, 0x000fe40003f3e000ULL, 0x0000000726087208ULL, 0x000fc40004000000ULL,
0x0000000617077208ULL, 0x000fe40004800000ULL, 0x0000002f0800720bULL, 0x000fe40003f1e000ULL,
0x000000300700720bULL, 0x000fe40003f3e000ULL, 0x000000082f097208ULL, 0x000fe40004000000ULL,
0x0000000730077208ULL, 0x000fe40004800000ULL, 0x0000002c0900720bULL, 0x000fc40003f1e000ULL,
0x000000200700720bULL, 0x000fe40003f3e000ULL, 0x000000092c067208ULL, 0x000fe40004000000ULL,
0x0000000720087208ULL, 0x000fe40004800000ULL, 0x000000270600720bULL, 0x000fe40003f1e000ULL,
0x0000001f0800720bULL, 0x000fe40003f3e000ULL, 0x0000000627077208ULL, 0x000fc40004000000ULL,
0x000000081f087208ULL, 0x000fe40004800000ULL, 0x000000280700720bULL, 0x000fe40003f1e000ULL,
0x000000210800720bULL, 0x000fe40003f3e000ULL, 0x0000000728067208ULL, 0x000fe40004000000ULL,
0x0000000821077208ULL, 0x000fe40004800000ULL, 0x000000330600720bULL, 0x000fc40003f1e000ULL,
0x000000320700720bULL, 0x000fe40003f3e000ULL, 0x0000000633067208ULL, 0x000fe40004000000ULL,
0x0000000732077208ULL, 0x000fe40004800000ULL, 0x000000310600720bULL, 0x000fe40003f1e000ULL,
0x000000220700720bULL, 0x000fe40003f3e000ULL, 0x0000000631067208ULL, 0x000fc40004000000ULL,
0x0000000722077208ULL, 0x000fe40004800000ULL, 0x000000290600720bULL, 0x000fe40003f1e000ULL,
0x000000120700720bULL, 0x000fe40003f3e000ULL, 0x0000000629097208ULL, 0x000fe40004000000ULL,
0x0000000712077208ULL, 0x000fe40004800000ULL, 0x0000002a0900720bULL, 0x000fc40003f1e000ULL,
0x000000140700720bULL, 0x000fe40003f3e000ULL, 0x000000092a097208ULL, 0x000fe40004000000ULL,
0x0000000714067208ULL, 0x000fe40004800000ULL, 0x0000002e0900720bULL, 0x000fe40003f1e000ULL,
0x000000150600720bULL, 0x000fe40003f3e000ULL, 0x000000092e087208ULL, 0x000fc40004000000ULL,
0x0000000615067208ULL, 0x000fe40004800000ULL, 0x0000002d0800720bULL, 0x000fe40003f1e000ULL,
0x000000190600720bULL, 0x000fe40003f3e000ULL, 0x000000082d087208ULL, 0x000fe40004000000ULL,
0x0000000619077208ULL, 0x000fe40004800000ULL, 0x0000002b0800720bULL, 0x000fc40003f1e000ULL,
0x0000001a0700720bULL, 0x000fe40003f3e000ULL, 0x000000082b087208ULL, 0x000fe40004000000ULL,
0x000000071a067208ULL, 0x000fe40004800000ULL, 0x000000230800720bULL, 0x000fe40003f1e000ULL,
0x0000001b0600720bULL, 0x000fe40003f3e000ULL, 0x0000000823077208ULL, 0x000fc40004000000ULL,
0x000000061b097208ULL, 0x000fe40004800000ULL, 0x000000240700720bULL, 0x000fe40003f1e000ULL,
0x0000001c0900720bULL, 0x000fe40003f3e000ULL, 0x00000007240e7208ULL, 0x000fe40004000000ULL,
0x000000091c107208ULL, 0x000fe20004800000ULL, 0x000014227f007947ULL, 0x000fec000b800000ULL,
0x0c401f000e067f89ULL, 0x0004e400000e0000ULL, 0x000000060e00720bULL, 0x008fc80003f1e000ULL,
0x0000000e06347208ULL, 0x000fe20004000000ULL, 0x000014327f007947ULL, 0x000fea000b800000ULL,
0x0c401f0010067f89ULL, 0x000ee800000e0000ULL, 0x0c401f000a077f89ULL, 0x000e6800000e0000ULL,
0x0c401f000b087f89ULL, 0x000ea800000e0000ULL, 0x0c201f0034097f89ULL, 0x000ea200000e0000ULL,
0x000000061000720bULL, 0x008fc40003f1e000ULL, 0x000000070a00720bULL, 0x002fe40003f3e000ULL,
0x00000010060c7208ULL, 0x000fe40004000000ULL, 0x0000000a070d7208ULL, 0x000fe40004800000ULL,
0x000000080b00720bULL, 0x004fe20003f1e000ULL, 0x0c201f000c0f7f89ULL, 0x000e6600000e0000ULL,
0x0000000b08067208ULL, 0x000fe20004000000ULL, 0x0c201f000d0e7f89ULL, 0x000ea200000e0000ULL,
0x000000093400720bULL, 0x000fc60003f1e000ULL, 0x0c201f0006077f89ULL, 0x0006e200000e0000ULL,
0x0000003409087208ULL, 0x000fe40004000000ULL, 0x0000000f0c00720bULL, 0x002fe40003f3e000ULL,
0x0000000e0d00720bULL, 0x004fe40003f5e000ULL, 0x0000000c0f097208ULL, 0x000fe40004800000ULL,
0x0000000d0e0a7208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b080c7820ULL, 0x008fe20000410000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000c1d1d7812ULL, 0x000fc400078ec0ffULL,
0x3fb8aa3b25257823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b13137823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b280f7823ULL, 0x102fe2000001080cULL, 0x3fb8aa3b26267823ULL, 0x100fe2000001080cULL,
0x00000025000e7308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b270b7823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b29287823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b2a297823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b33337823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b31277823ULL, 0x100fe2000001080cULL,
0x0000001300137308ULL, 0x000ee20000000800ULL, 0x3fb8aa3b23257823ULL, 0x102fe2000001080cULL,
0x3fb8aa3b09237820ULL, 0x000fe20000410000ULL, 0x3fb8aa3b242a7823ULL, 0x000fe2000001080cULL,
0x0000000303ff7812ULL, 0x000fc4000780c0ffULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe20000010823ULL,
0x3fb8aa3b17177823ULL, 0x100fe20000010823ULL, 0x3fb8aa3b30307823ULL, 0x100fe20000010823ULL,
0x3fb8aa3b16167823ULL, 0x100fe20000010823ULL, 0x00000026000d7308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe20000010823ULL, 0x3fb8aa3b20207823ULL, 0x100fe20000010823ULL,
0x3fb8aa3b21217823ULL, 0x100fe20000010823ULL, 0x3fb8aa3b32327823ULL, 0x100fe20000010823ULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010823ULL, 0x3fb8aa3b19197823ULL, 0x100fe20000010823ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe20000010823ULL, 0x0000002f00107308ULL, 0x0004e20000000800ULL,
0x3fb8aa3b2b267823ULL, 0x002fe2000001080cULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe20000010823ULL,
0x3fb8aa3b1c1c7823ULL, 0x000fe20000010823ULL, 0x000000070600720bULL, 0x004fc80003f3e000ULL,
0x0000000f00367308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b152f7823ULL, 0x000fce0000010823ULL,
0x0000001e001e7308ULL, 0x000ff00000000800ULL, 0x00000016000f7308ULL, 0x000e700000000800ULL,
0x0000001700177308ULL, 0x000ff00000000800ULL, 0x0000003000307308ULL, 0x000eb00000000800ULL,
0x0000002c00347308ULL, 0x0003f00000000800ULL, 0x0000000b00357308ULL, 0x0004e20000000800ULL,
0x3fb8aa3b2e2c7823ULL, 0x002fe2000001080cULL, 0x3fb8aa3b142e7823ULL, 0x000fcc0000010823ULL,
0x0000001f002b7308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b2d0b7823ULL, 0x004fe2000001080cULL,
0x000000130e0c723eULL, 0x008fe200000000ffULL, 0x3fb8aa3b122d7823ULL, 0x000fe20000010823ULL,
0x0000000d100e723eULL, 0x000fe400000000ffULL, 0x0000001e0f0d723eULL, 0x000fe200000000ffULL,
0x3c003c00ff1e7424ULL, 0x000fe200078e00ffULL, 0x00000017300f723eULL, 0x000fe200000000ffULL,
0x3c003c00ff1f7424ULL, 0x002fe200078e00ffULL, 0x0000003300337308ULL, 0x000e620000000800ULL,
0x000000343514723eULL, 0x000fca00000000ffULL, 0x0000001e0c10723cULL, 0x000f6400000018ffULL,
0x0000002000207308ULL, 0x000eb00000000800ULL, 0x0000002100217308ULL, 0x000fe20000000800ULL,
0x000000363316723eULL, 0x002fc400000000ffULL, 0x00000002ff337819ULL, 0x000fc80000011603ULL,
0x0000000233317810ULL, 0x000fe20007ffe0ffULL, 0x0000003200327308ULL, 0x000e620000000800ULL,
0x000000202b15723eULL, 0x004fe200000000ffULL, 0x0000000833367824ULL, 0x040fe200078e00ffULL,
0x00000001332b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000833307824ULL, 0x040fe200078e00ffULL,
0x00000008333a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000833387824ULL, 0x040fe400078e00ffULL,
0x0000002200247308ULL, 0x0005e20000000800ULL, 0xfffffff830307812ULL, 0x000fe200078ee22bULL,
0x00000008332b7824ULL, 0x000fe200078e00ffULL, 0x000000213217723eULL, 0x002fca00000000ffULL,
0x0000002700277308ULL, 0x000fe20000000800ULL, 0x0000000833327824ULL, 0x040fe200078e00ffULL,
0x0000001e1420723cULL, 0x024b680000001810ULL, 0xfffffff832327812ULL, 0x000fe400078ee231ULL,
0x0000002800287308ULL, 0x000e620000000800ULL, 0x0000000833137824ULL, 0x060fe200078e00ffULL,
0x0000000333107810ULL, 0x000fcc0007ffe0ffULL, 0x0000002900297308ULL, 0x000fe20000000800ULL,
0x0000000433117810ULL, 0x000fe40007ffe0ffULL, 0xfffffff813347812ULL, 0x000fe400078ee210ULL,
0xfffffff836367812ULL, 0x000fc600078ee211ULL, 0x0000002c002c7308ULL, 0x000ea20000000800ULL,
0x000000272810723eULL, 0x002fe200000000ffULL, 0x0000000833287824ULL, 0x040fe200078e00ffULL,
0x0000000633277810ULL, 0x000fc80007ffe0ffULL, 0xfffffff828287812ULL, 0x000fe200078ee233ULL,
0x0000002d002d7308ULL, 0x000e700000000800ULL, 0x0000002e002e7308ULL, 0x000fe20000000800ULL,
0x000000292c12723eULL, 0x004fc400000000ffULL, 0xffffffff33297810ULL, 0x000fc80007ffe0ffULL,
0xfffffff838387812ULL, 0x000fe200078ee229ULL, 0x0000002f002f7308ULL, 0x000ea20000000800ULL,
0x000000242d11723eULL, 0x002fe200000000ffULL, 0x000000083a2d7824ULL, 0x000fe200078e00ffULL,
0x0000000533247810ULL, 0x000fc80007ffe0ffULL, 0xfffffff82b2c7812ULL, 0x000fe200078ee224ULL,
0x0000000b000b7308ULL, 0x000fe20000000800ULL, 0xfffffff82d3a7812ULL, 0x000fe400078ee23aULL,
0x0000002e2f13723eULL, 0x004fca00000000ffULL, 0x0000002600267308ULL, 0x000e620000000800ULL,
0x00000008332e7824ULL, 0x000fe200078e00ffULL, 0x0000001e1020723cULL, 0x000f680000001820ULL,
0xfffffff82e2e7812ULL, 0x000fe400078ee227ULL, 0x0000002500257308ULL, 0x000ff00000000800ULL,
0x0000002a002a7308ULL, 0x000ea20000000800ULL, 0x0000000b2624723eULL, 0x002fc400000000ffULL,
0x00009000000b7811ULL, 0x000fca00078e58ffULL, 0x0000001900197308ULL, 0x000fe20000000800ULL,
0x0000001028287824ULL, 0x100fe400078e020bULL, 0x0000001030307824ULL, 0x100fe400078e020bULL,
0x0000001032327824ULL, 0x100fe400078e020bULL, 0x0000001034347824ULL, 0x100fe200078e020bULL,
0x0000001a001a7308ULL, 0x000e620000000800ULL, 0x000000252a26723eULL, 0x004fe200000000ffULL,
0x0000001036367824ULL, 0x000fc400078e020bULL, 0x000000102c2c7824ULL, 0x100fe400078e020bULL,
0x000000011d307824ULL, 0x040fe400078e0230ULL, 0x0000001b001b7308ULL, 0x000fe20000000800ULL,
0x000000102e2e7824ULL, 0x100fe400078e020bULL, 0x000000011d327824ULL, 0x040fe400078e0232ULL,
0x0000001038387824ULL, 0x000fe400078e020bULL, 0x000000011d347824ULL, 0x000fe200078e0234ULL,
0x0000001c001c7308ULL, 0x000ea20000000800ULL, 0x000000191a25723eULL, 0x002fe200000000ffULL,
0x0000000128197824ULL, 0x000fc400078e021dULL, 0x000000103a3a7824ULL, 0x000fe200078e020bULL,
0x00000006070b7208ULL, 0x000fe20004800000ULL, 0x000000011d367824ULL, 0x040fe200078e0236ULL,
0x0000000c19007388ULL, 0x0003e20000000800ULL, 0x000000011d2c7824ULL, 0x040fe400078e022cULL,
0x000000011d2e7824ULL, 0x040fe200078e022eULL, 0x0000000e30007388ULL, 0x0003e20000000800ULL,
0x000000011d387824ULL, 0x040fe400078e0238ULL, 0x000000011d3a7824ULL, 0x000fe200078e023aULL,
0x0000001432007388ULL, 0x0003e20000000800ULL, 0x0000001b1c27723eULL, 0x004fc600000000ffULL,
0x0000001634007388ULL, 0x0003e80000000800ULL, 0x0000001e2420723cULL, 0x020f620000001820ULL,
0x0000001036007388ULL, 0x0003e80000000800ULL, 0x000000122c007388ULL, 0x0003e80000000800ULL,
0x000000242e007388ULL, 0x0003e80000000800ULL, 0x0000002638007388ULL, 0x0003e80000000800ULL,
0x0000000d3a007388ULL, 0x0003e80000000800ULL, 0x0004000f30007388ULL, 0x0003e60000000800ULL,
0x000000ffff217224ULL, 0x020fe200078e0022ULL, 0x0004001532007388ULL, 0x0003e80000000800ULL,
0x0004001734007388ULL, 0x0003e80000000800ULL, 0x0004001136007388ULL, 0x0003e80000000800ULL,
0x000400132c007388ULL, 0x0003e80000000800ULL, 0x000400252e007388ULL, 0x0003e80000000800ULL,
0x0004002738007388ULL, 0x0003e80000000800ULL, 0x00f0000818008388ULL, 0x0003e80000000c00ULL,
0x00f2002018008388ULL, 0x0003e20000000a00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000079ff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000080079ff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000100079ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000168687810ULL, 0x000fe20007ffe0ffULL, 0x0000180079ff7f8cULL, 0x0003e6000c80043fULL,
0x0000006e6800720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffb6b000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff0c7807ULL, 0x008fe40004000000ULL, 0x0001213000127802ULL, 0x000fc40000000f00ULL,
0x00000bf000007944ULL, 0x012fea0003c00000ULL, 0xffff050000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0c7807ULL, 0x000fe40005000000ULL, 0x0001217000127802ULL, 0x000fc40000000f00ULL,
0x00000bb000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff347224ULL, 0x000fe200078e000cULL,
0xffff053000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x000fe200078e0037ULL,
0x000121c000137802ULL, 0x000fc40000000f00ULL, 0x00000af000007944ULL, 0x012fea0003c00000ULL,
0xffff061000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x000fe200078e0037ULL,
0x0001220000137802ULL, 0x000fc40000000f00ULL, 0x00000ab000007944ULL, 0x012fea0003c00000ULL,
0xffff073000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x000fe200078e000dULL,
0x0001225000137802ULL, 0x000fe20000000f00ULL, 0x000000ffff0c7224ULL, 0x000fc400078e000eULL,
0x00000a6000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e000cULL,
0xffff0b6000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x000fe200078e000dULL,
0x000122a000137802ULL, 0x000fc40000000f00ULL, 0x00000a1000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e000cULL, 0xffff0b4000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0c7807ULL, 0x008fe40004000000ULL, 0x000122f000127802ULL, 0x000fc40000000f00ULL,
0x00000a3000007944ULL, 0x012fea0003c00000ULL, 0xffff2b2000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0c7807ULL, 0x000fe40005000000ULL, 0x0001233000127802ULL, 0x000fc40000000f00ULL,
0x000009f000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff357224ULL, 0x000fe200078e000cULL,
0xffff2b6000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x000fe200078e0037ULL,
0x0001238000137802ULL, 0x000fc40000000f00ULL, 0x0000093000007944ULL, 0x012fea0003c00000ULL,
0xffff2c5000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x000fe200078e0037ULL,
0x000123c000137802ULL, 0x000fc40000000f00ULL, 0x000008f000007944ULL, 0x012fea0003c00000ULL,
0xffff2d7000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x000fe200078e000dULL,
0x0001241000137802ULL, 0x000fe20000000f00ULL, 0x000000ffff0c7224ULL, 0x000fc400078e0010ULL,
0x000008a000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e000cULL,
0xffff31a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x000fe200078e000dULL,
0x0001246000137802ULL, 0x000fc40000000f00ULL, 0x0000085000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e000cULL, 0xffff318000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0c7807ULL, 0x008fe40004000000ULL, 0x000124b000127802ULL, 0x000fc40000000f00ULL,
0x0000087000007944ULL, 0x012fea0003c00000ULL, 0xffff4f3000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0c7807ULL, 0x000fe40005000000ULL, 0x000124f000127802ULL, 0x000fc40000000f00ULL,
0x0000083000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff087224ULL, 0x000fe200078e000cULL,
0xffff4f8000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x000fe200078e0035ULL,
0x0001254000137802ULL, 0x000fc40000000f00ULL, 0x0000077000007944ULL, 0x012fea0003c00000ULL,
0xffff507000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x000fe200078e0035ULL,
0x0001258000137802ULL, 0x000fc40000000f00ULL, 0x0000073000007944ULL, 0x012fea0003c00000ULL,
0xffff519000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x000fe200078e0009ULL,
0x000125d000137802ULL, 0x000fe20000000f00ULL, 0x000000ffff0c7224ULL, 0x000fc400078e000eULL,
0x000006e000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e000cULL,
0xffff55c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x000fe200078e0009ULL,
0x0001262000137802ULL, 0x000fc40000000f00ULL, 0x0000069000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e000cULL, 0xffff55a000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0c7807ULL, 0x004fe40004000000ULL, 0x0001267000127802ULL, 0x000fc40000000f00ULL,
0x000006b000007944ULL, 0x018fea0003c00000ULL, 0xffff73a000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0c7807ULL, 0x000fe40005000000ULL, 0x000126b000127802ULL, 0x000fc40000000f00ULL,
0x0000067000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff097224ULL, 0x000fe200078e000cULL,
0xffff73f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x000fe200078e0031ULL,
0x0001270000137802ULL, 0x000fc40000000f00ULL, 0x000005b000007944ULL, 0x018fea0003c00000ULL,
0xffff74e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x000fe200078e0031ULL,
0x0001274000137802ULL, 0x000fc40000000f00ULL, 0x0000057000007944ULL, 0x01afea0003c00000ULL,
0xffff760000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x000fe200078e0008ULL,
0x0001279000137802ULL, 0x000fe20000000f00ULL, 0x000000ffff0c7224ULL, 0x000fc400078e000fULL,
0x0000052000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e000cULL,
0xffff7a3000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x000fe200078e0008ULL,
0x000127e000137802ULL, 0x000fc40000000f00ULL, 0x000004d000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e000cULL, 0xffff7a1000007947ULL, 0x000fea000383ffffULL,
0x00000002ff0f7424ULL, 0x000fe200078e00ffULL, 0x00012830000c7802ULL, 0x000fc40000000f00ULL,
0x0000044000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e0007ULL,
0xffffeba000007947ULL, 0x000fea000383ffffULL, 0x000000ffff0e7224ULL, 0x006fe200078e0010ULL,
0x00012890000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff0f7424ULL, 0x000fc400078e00ffULL,
0x000003e000007944ULL, 0x010fea0003c00000ULL, 0x000000071000720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0e7224ULL, 0x002fe200078e000aULL, 0x000128f0000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000001007107208ULL, 0x000fc80004000000ULL,
0x0000038000007944ULL, 0x000fea0003c00000ULL, 0x000000070a00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0e7224ULL, 0x002fe200078e000bULL, 0x00012950000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000000a070a7208ULL, 0x000fc80004000000ULL,
0x0000032000007944ULL, 0x000fea0003c00000ULL, 0x000000070b00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0e7224ULL, 0x002fe200078e0034ULL, 0x000129b0000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000000b07067208ULL, 0x000fc80004000000ULL,
0x000002c000007944ULL, 0x000fea0003c00000ULL, 0x000000073400720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0e7224ULL, 0x002fe200078e0010ULL, 0x00012a10000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000003407087208ULL, 0x000fc80004000000ULL,
0x0000026000007944ULL, 0x000fea0003c00000ULL, 0x000000071000720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0e7224ULL, 0x002fe200078e000aULL, 0x00012a70000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000001007097208ULL, 0x000fc80004000000ULL,
0x0000020000007944ULL, 0x000fea0003c00000ULL, 0x000000070a00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0e7224ULL, 0x002fe200078e0006ULL, 0x00012ad0000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000000a070a7208ULL, 0x000fc80004000000ULL,
0x000001a000007944ULL, 0x000fea0003c00000ULL, 0xffffea7000007947ULL, 0x000fea000383ffffULL,
0x018000000a027810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000002037812ULL, 0x000fc800078ec0ffULL, 0x018000000300780cULL, 0x000fda0003f05070ULL,
0x0000000a00028308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0300720cULL, 0x040fe40003f25070ULL, 0x008000000300780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff027807ULL, 0x004fc80004000000ULL,
0x0000000203ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff0aff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff027807ULL, 0x000fc80000000000ULL,
0x0000000203ff7212ULL, 0x000fe4000780c0ffULL, 0x800000000a037812ULL, 0x000fd600078ec0ffULL,
0x0080000003020812ULL, 0x000fe200078efcffULL, 0x000000ffff028224ULL, 0x000fe200078e0003ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000a00027308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff047224ULL, 0x00cfe400078e0002ULL,
0x000000ffff027224ULL, 0x000fe400078e0005ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffed39002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000003600007348ULL, 0x000fe80003800000ULL, 0x0c00000f0e077389ULL, 0x0002a200000e0011ULL,
0xfffed3500c007950ULL, 0x000fea0003c3ffffULL, 0xffffffffff397424ULL, 0x000fe400078e00ffULL,
0x0000001fff387424ULL, 0x000fe400078e00ffULL, 0x0000003900007348ULL, 0x000fe80003800000ULL,
0x0000000c120c7389ULL, 0x0002a400000e0038ULL, 0x000000ffff127224ULL, 0x002fc400078e0013ULL,
0x00000000ff137424ULL, 0x000fc800078e00ffULL, 0xfffed2e012007950ULL, 0x000fea0003c3ffffULL,
0x000000010c00780cULL, 0x000fe20003f45070ULL, 0xffffffffff137424ULL, 0x000fc800078e00ffULL,
0x0000001300007348ULL, 0x000ff00003800000ULL, 0x00000000000c7806ULL, 0x000fc800050e0100ULL,
0x000000130c0c7212ULL, 0x000fe200078ec0ffULL, 0x00000000ff137424ULL, 0x000fc800078e00ffULL,
0xfffed27012007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000004ULL, 0x0000000100000001ULL, 0x0000001000000008ULL, 0x0000000400000001ULL,
0x0000000800000008ULL, 0x0000000800000001ULL, 0x0000000200000001ULL, 0x0000000400000003ULL,
0x0000000300000004ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005f4ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000750ULL, 0x00000000000002a0ULL, 0x0000001b00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009f0ULL, 0x00000000000002b8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000ca8ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000d68ULL, 0x00000000000007bcULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001528ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001538ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000015c8ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000015ccULL, 0x00000000000001c0ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001800ULL, 0x0000000000012e80ULL, 0x8000001b00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000014680ULL, 0x0000000000000048ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x00000000000146d0ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000014a50ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x00000000000015c8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000130b8ULL, 0x00000000000130b8ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000014680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000014a50ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_pagedKV_64_nqpkv_0_m_16_sm_89_cubin_len = 84784;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
