/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_pagedKV_64_nqpkv_0_m_16_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x00000000000142c0ULL, 0x0000000000013f40ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x65722e0000000000ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x72655073776f7200ULL, 0x6e2e006b636f6c42ULL,
0x6174736e6f632e76ULL, 0x000000000033746eULL, 0x657a69536d656d73ULL, 0x7563344e5a5a5f00ULL,
0x5f33647473336164ULL, 0x7465645f5f38345fULL, 0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL,
0x75635f726564726fULL, 0x5f37456969456164ULL, 0x5f006d726f66785fULL, 0x727241374b4e5a5aULL,
0x6a4c664944327961ULL, 0x324545326a4c4532ULL, 0x454530624c497461ULL, 0x31456a6a664b5245ULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL,
0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL, 0x497461324545386aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3053ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x5f5f374944327961ULL, 0x326a4c32666c6168ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL,
0x456a6a5f30534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL,
0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL, 0x497461324545386aULL,
0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x316a4c4536316a4cULL,
0x4c49746132454536ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x45386a4c4534366aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL,
0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL, 0x454530624c497461ULL,
0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL,
0x4944327961727241ULL, 0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL, 0x45326a4c4545316aULL,
0x7461324545316a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL,
0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x4939494432796172ULL, 0x74614d6e4974736eULL,
0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL, 0x534b524545453062ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x736e493949443279ULL, 0x4c4974614d6e4974ULL, 0x4545326a4c45326aULL, 0x45316a4c45346a4cULL,
0x30624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL,
0x324545386a4c4532ULL, 0x454531624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL,
0x4c45326a4c497461ULL, 0x45326a4c4545326aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL,
0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL,
0x5633494432796172ULL, 0x45346a4c6a496365ULL, 0x6a4c4536316a4c45ULL, 0x4c49746132454538ULL,
0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x000000676e696469ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x6e695f5f24000000ULL, 0x305f6c616e726574ULL,
0x616475635f5f245fULL, 0x63725f30326d735fULL, 0x7a74665f6e725f70ULL, 0x6f6c735f3233665fULL,
0x722e006874617077ULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL, 0x616c65722e006168ULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x6c656e72656b2400ULL, 0x656d732461686d5fULL,
0x667542657479426dULL, 0x5f67756265642e00ULL, 0x722e00656d617266ULL, 0x67756265642e6c65ULL,
0x2e00656d6172665fULL, 0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6e6f632e766e2e00ULL,
0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL, 0x0000000000000061ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a00030000004bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b000100000096ULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x00090003000000a3ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b5ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b0001000000beULL, 0x0000000000000038ULL, 0x0000000000000010ULL,
0x000b0001000000fcULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000b000100000135ULL,
0x0000000000000030ULL, 0x0000000000000004ULL, 0x000b00010000017cULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000b0001000001beULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000b000100000204ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000b00010000024bULL,
0x0000000000000034ULL, 0x0000000000000004ULL, 0x000b000100000291ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000b0001000002dfULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000b00010000032dULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b00010000037bULL,
0x000000000000002cULL, 0x0000000000000004ULL, 0x000b0001000003c9ULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000b00010000040fULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000b00010000045dULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x0000010000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a0022000004b8ULL, 0x00000000000128c0ULL,
0x0000000000000240ULL, 0x000400030000052eULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a101200000040ULL, 0x0000000000000000ULL, 0x0000000000012b00ULL, 0x000d00030000055eULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000024ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000128c000000000ULL,
0x0000140400000000ULL, 0x0008288080810c00ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080860828808081ULL,
0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808692ULL, 0x0000002cffffffffULL,
0x0000006000000000ULL, 0x000128c000000000ULL, 0x0000024000000000ULL, 0x0000580400000000ULL,
0x8084288080860900ULL, 0x0000000000002880ULL, 0x0000001700082f04ULL, 0x0008230400000080ULL,
0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000008ULL, 0x0000000800000015ULL,
0x0000001700082304ULL, 0x0008120400000000ULL, 0x0000000800000017ULL, 0x0000001700081104ULL,
0x0004370400000008ULL, 0x000c17040000007bULL, 0x0058000900000000ULL, 0x000c17040021f000ULL,
0x0050000800000000ULL, 0x000c17040021f000ULL, 0x0048000700000000ULL, 0x000c17040011f000ULL,
0x0028000600000000ULL, 0x000c17040081f000ULL, 0x0020000500000000ULL, 0x000c17040021f000ULL,
0x0018000400000000ULL, 0x000c17040021f000ULL, 0x0010000300000000ULL, 0x000c17040021f000ULL,
0x0008000200000000ULL, 0x000c17040011f000ULL, 0x0004000100000000ULL, 0x000c17040011f000ULL,
0x0000000000000000ULL, 0x00801b030011f000ULL, 0xffffffff00942904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x000003c000942804ULL, 0x000009a000000400ULL, 0x00002960000028e0ULL,
0x00002b7000002a30ULL, 0x000030e0000030d0ULL, 0x00004d7000004d10ULL, 0x00004fb000004e70ULL,
0x000053c0000053b0ULL, 0x00006f7000006f00ULL, 0x000071b000007070ULL, 0x000075c0000075b0ULL,
0x000091d000009160ULL, 0x00009410000092d0ULL, 0x0000988000009870ULL, 0x0000a9900000a980ULL,
0x00011da000011cf0ULL, 0x0001206000011fd0ULL, 0x00012450000122d0ULL, 0x000125c000012590ULL,
0x0000048004303904ULL, 0x00017600000000ffULL, 0x0000056000040100ULL, 0x0001760800000008ULL,
0x00000670003f0100ULL, 0x0001768800000008ULL, 0x000007b0003f0100ULL, 0x000176a800000006ULL,
0x000008c0003f0100ULL, 0x000176c800000004ULL, 0x00000e10003f0100ULL, 0x0001760000000002ULL,
0x00000fa0003f0107ULL, 0x0001768800000006ULL, 0x00001850003f0101ULL, 0x0000000000000008ULL,
0x0000196000040107ULL, 0x0000000000000008ULL, 0x00001a0000040101ULL, 0x0000002000000009ULL,
0x00001b40003f0101ULL, 0x000176c80000000eULL, 0x00001cc0003f0109ULL, 0x000176c80000000eULL,
0x00002600003f0109ULL, 0x000176b000000014ULL, 0x00002660003f0107ULL, 0x000176b000000014ULL,
0x00002670003f0101ULL, 0x000176080000000dULL, 0x00002690003f0101ULL, 0x000176080000000dULL,
0x00002800003f0109ULL, 0x000176080000000dULL, 0x00002d60003f0109ULL, 0x000176a800000039ULL,
0x00002ed0003f0109ULL, 0x000176a800000039ULL, 0x00004070003f0109ULL, 0x000176c800000018ULL,
0x00004080003f0101ULL, 0x0001768800000045ULL, 0x000040b0003f0101ULL, 0x0000000000000009ULL,
0x00004220003f0109ULL, 0x0000000000000009ULL, 0x00004a90003f0109ULL, 0x000176a800000017ULL,
0x00004ad0003f0107ULL, 0x000176a800000017ULL, 0x00004ae0003f0101ULL, 0x000176280000000dULL,
0x00004b00003f0101ULL, 0x000176280000000dULL, 0x00004c70003f0109ULL, 0x000176280000000dULL,
0x00005190003f0109ULL, 0x000176b000000041ULL, 0x00005300003f0109ULL, 0x000176b000000041ULL,
0x00006260003f0109ULL, 0x000176c800000042ULL, 0x00006270003f0101ULL, 0x0001769000000047ULL,
0x000062a0003f0101ULL, 0x0000000000000009ULL, 0x00006410003f0109ULL, 0x0000000000000009ULL,
0x00006c80003f0109ULL, 0x000176b00000001bULL, 0x00006cc0003f0107ULL, 0x000176b00000001bULL,
0x00006cd0003f0101ULL, 0x000176480000000dULL, 0x00006cf0003f0101ULL, 0x000176480000000dULL,
0x00006e60003f0109ULL, 0x000176480000000dULL, 0x00007390003f0109ULL, 0x000176a800000041ULL,
0x00007500003f0109ULL, 0x000176a800000041ULL, 0x00008440003f0109ULL, 0x000176c80000003cULL,
0x00008460003f0101ULL, 0x000176980000003dULL, 0x000084a0003f0101ULL, 0x0000000000000009ULL,
0x00008610003f0109ULL, 0x0000000000000009ULL, 0x00008ee0003f0109ULL, 0x000176a800000007ULL,
0x00008f20003f0107ULL, 0x000176a800000007ULL, 0x00008f30003f0101ULL, 0x000176680000000bULL,
0x00008f60003f0101ULL, 0x000176680000000bULL, 0x000090d0003f0109ULL, 0x000176680000000bULL,
0x000095f0003f0109ULL, 0x000176b000000039ULL, 0x00009760003f0109ULL, 0x000176b000000039ULL,
0x0000a6b0003f0109ULL, 0x0000000000000009ULL, 0x0000a740003f0101ULL, 0x000176a000000009ULL,
0x0000b8c0003f0101ULL, 0x0001760000000002ULL, 0x0000d1e0003f0101ULL, 0x0001760000000002ULL,
0x0000d350003f0109ULL, 0x0001760000000002ULL, 0x0000d530003f0109ULL, 0x0001760000000002ULL,
0x0000d550003f0101ULL, 0x0001760000000002ULL, 0x0000d6c0003f0109ULL, 0x0001760000000002ULL,
0x00010300003f0109ULL, 0x0001768800000006ULL, 0x000104d0003f0101ULL, 0x0001768800000006ULL,
0x00010640003f0109ULL, 0x0001768800000006ULL, 0x00012850003f0109ULL, 0x0001760800000070ULL,
0x00012860003f0101ULL, 0x0001761000000070ULL, 0x00012870003f0101ULL, 0x0001761800000070ULL,
0x00012880003f0101ULL, 0x0001762000000070ULL, 0x00053803003f0101ULL, 0x0000b20000201c04ULL,
0x0000b4200000b260ULL, 0x0000b7100000b580ULL, 0x0000d6f00000b810ULL, 0x000c0504000128b0ULL,
0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0060190300000000ULL, 0x0000001800080a04ULL,
0x0000000000600210ULL, 0x00000000000000bcULL, 0x0000001700000002ULL, 0x00000000000128c0ULL,
0x0000000000000044ULL, 0x0000001700000002ULL, 0x0000000000000000ULL, 0x0000000000000098ULL,
0x0000001700000002ULL, 0x0000000000000000ULL, 0x0000000000017700ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e700000000800ULL, 0x00008400ff027b82ULL, 0x000ea20000000a00ULL,
0x00000000000b7919ULL, 0x000ee20000002200ULL, 0x0000049000007945ULL, 0x000fe20003800000ULL,
0xfffffff801017836ULL, 0x002fe20000000000ULL, 0x0000000000097919ULL, 0x000e680000002100ULL,
0x00000400ff067b82ULL, 0x000f220000000800ULL, 0x0000000000567919ULL, 0x000f620000002600ULL,
0x0000010000047ab9ULL, 0x000fcc0000000800ULL, 0x00008600ff0f7b82ULL, 0x000e620000000800ULL,
0x0000000300007306ULL, 0x004ea20000209000ULL, 0x000000ff0300720cULL, 0x000fce0003f45070ULL,
0x0000000000007308ULL, 0x004ea40000001000ULL, 0x0ffffffe00047836ULL, 0x004fcc0000000000ULL,
0x0000000400057305ULL, 0x000464000021f000ULL, 0x000000ffff047224ULL, 0x004fe400078e00ffULL,
0x000000ffff087224ULL, 0x002fc800078e0a05ULL, 0x0000000308077224ULL, 0x000fe400078e02ffULL,
0x0000000000087919ULL, 0x000ee40000002300ULL, 0x0000000705057227ULL, 0x000fcc00078e0004ULL,
0x0000000605077227ULL, 0x010fc800078e00ffULL, 0x000000ffff057224ULL, 0x000fc800078e0a07ULL,
0x0000000503007224ULL, 0x000fca00078e0206ULL, 0x000000030000720cULL, 0x000fda0003f06070ULL,
0x0000000100000824ULL, 0x000fe400078e0a03ULL, 0x0000000107070836ULL, 0x000fc60000000000ULL,
0x000000030000720cULL, 0x000fda0003f26070ULL, 0x0000000107071836ULL, 0x000fe20000000000ULL,
0x00000003ff07a212ULL, 0x000fc800078e33ffULL, 0x0000000700007306ULL, 0x000e620000209000ULL,
0x000000ff0700720cULL, 0x000fce0003f45070ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00047836ULL, 0x002fe40000000000ULL, 0x0000000408007c24ULL, 0x008fe2000f8e020bULL,
0x0000000000047ab9ULL, 0x000fc60000000800ULL, 0x0000000400057305ULL, 0x0002a4000021f000ULL,
0x000000ffff047224ULL, 0x002fe400078e00ffULL, 0x0000000507067224ULL, 0x004fc800078e02ffULL,
0x000000ffff0d7224ULL, 0x000fc800078e0a06ULL, 0x0000000d05057227ULL, 0x000fc800078e0004ULL,
0x0000000400047c24ULL, 0x000fe4000f8e0209ULL, 0x0000005605527227ULL, 0x020fc600078e00ffULL,
0x0000007f0400780cULL, 0x040fe20003f64070ULL, 0x000000ffff057224ULL, 0x000fe200078e0a52ULL,
0x000000030400780cULL, 0x000fc60003f84070ULL, 0x0000000507007224ULL, 0x000fe400078e0256ULL,
0x0000000000057919ULL, 0x000e660000002700ULL, 0x000000070000720cULL, 0x000fc60003f06070ULL,
0x00000000000bb919ULL, 0x000eb40000008800ULL, 0x0000000100000824ULL, 0x000fc400078e0a07ULL,
0x0000000152520836ULL, 0x000fe20000000000ULL, 0x000000ff0400720cULL, 0x000fe40003f05270ULL,
0x000000070000720cULL, 0x000fe40003f26070ULL, 0x000004000000b802ULL, 0x000fd60000000f00ULL,
0x0000000152521836ULL, 0x000fe20000000000ULL, 0x00000007ff52a212ULL, 0x000fe400078e33ffULL,
0x0000000f0400780cULL, 0x040fe40003f24070ULL, 0x000006540b0bb816ULL, 0x004fe20000000000ULL,
0x000000ffff067224ULL, 0x000fe200078e0a52ULL, 0x00000005ff007819ULL, 0x000fe40000011609ULL,
0x00001fff08097589ULL, 0x0004e200000e0000ULL, 0x0000000607567224ULL, 0x000fe200078e0256ULL,
0x000000010400780cULL, 0x040fe20003f44070ULL, 0xff317217ff07b424ULL, 0x000fe200078e00ffULL,
0x00001fff00007589ULL, 0x000e6200000e0000ULL, 0x000000040406b824ULL, 0x000fe200078e020bULL,
0x0000000000240947ULL, 0x002ff20003800000ULL, 0x00000000000579c3ULL, 0x000f220000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x001fff0000067882ULL, 0x000fe20000000000ULL,
0x7ffc000000077882ULL, 0x000fe20000000000ULL, 0x0000065405047896ULL, 0x010fe20008000004ULL,
0x0000000000007918ULL, 0x004fe20000000000ULL, 0x00000000000073c6ULL, 0x000eb40000000000ULL,
0x01760006043f75b2ULL, 0x0004a40008000100ULL, 0x0000000000007918ULL, 0x00cfe20000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000381947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000f220000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x010fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000404087c11ULL, 0x004fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000080612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ea40000000000ULL, 0x01760804063f75b2ULL, 0x0004b00008000100ULL,
0xfffffffd00e81947ULL, 0x00cfea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000384947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000f220000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x010fc60008000004ULL,
0x7ffb000000057882ULL, 0x000fc60000000000ULL, 0x0000000404087c11ULL, 0x004fe2000f8e18ffULL,
0x001ffec000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000080612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000ea40000000000ULL,
0x01768804063f75b2ULL, 0x0004b00008000100ULL, 0xfffffffd00e81947ULL, 0x00cfea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001056087824ULL, 0x004fe200078e00ffULL,
0x017400070600b388ULL, 0x0005e20000000800ULL, 0x0000011000007945ULL, 0x000fe60003800000ULL,
0x0000000801007387ULL, 0x0005e20000100800ULL, 0x0000000000384947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000f220000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x010fc60008000004ULL,
0x7ffc000000057882ULL, 0x000fc60000000000ULL, 0x0000000404067c11ULL, 0x004fe2000f8e18ffULL,
0x001fff0000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000060612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000ea40000000000ULL,
0x0176a804063f75b2ULL, 0x0004b00008000100ULL, 0xfffffffd00e81947ULL, 0x00cfea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000382947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000f220000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x010fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000404047c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x004fca0000000000ULL, 0x00000000040612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ea40000000000ULL, 0x0176c804063f75b2ULL, 0x0004b00008000100ULL,
0xfffffffd00e81947ULL, 0x00cfea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000010c7983ULL, 0x000f220000100800ULL, 0x0000000f02047219ULL, 0x080fe200000006ffULL,
0x0000000205027224ULL, 0x002fe200078e02ffULL, 0x0000000f03557219ULL, 0x000fe200000006ffULL,
0x0000000409067824ULL, 0x00cfe200078e0200ULL, 0x0000820000067ab9ULL, 0x000fe20000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000ffff077224ULL, 0x010fe200078e0a0cULL,
0x0000000c0400720cULL, 0x000fc80003f06070ULL, 0x0000001004547446ULL, 0x000fe20003800007ULL,
0x0000000206077824ULL, 0x000fe200078e00ffULL, 0x0000000f52047219ULL, 0x000fe400000006ffULL,
0x000000ff54547207ULL, 0x000fc60000000000ULL, 0x0000005502027224ULL, 0x000fe200078e0204ULL,
0x000000105400780cULL, 0x000fda0003f05270ULL, 0x0000000000808947ULL, 0x000fea0003800000ULL,
0x0000000000047919ULL, 0x000e620000000000ULL, 0xffffffffff067424ULL, 0x000fe200078e00ffULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000000117919ULL, 0x000ea60000008800ULL,
0x0000000f060d7219ULL, 0x000fe400000006ffULL, 0x00000004ff087819ULL, 0x002fe20000011604ULL,
0x00000010040a7824ULL, 0x000fc800078e00ffULL, 0x00000001070b7824ULL, 0x000fc800078e0208ULL,
0x000000010c067824ULL, 0x000fca00078e020bULL, 0x0000000d060d7212ULL, 0x000fe400078e30ffULL,
0x0000000fff067219ULL, 0x000fc60000011606ULL, 0x00000001020d7824ULL, 0x000fe200078e020dULL,
0x0000000754027248ULL, 0x000fc60007fe0000ULL, 0x0000005506067224ULL, 0x000fe200078e020dULL,
0x000000f00a0d7812ULL, 0x000fe200078ec0ffULL, 0x0000000102027824ULL, 0x000fe400078e0a07ULL,
0x0000010006067825ULL, 0x000fc600078e00ffULL, 0x000000020800720cULL, 0x000fe20003f06070ULL,
0x000000010b087824ULL, 0x040fe200078e0204ULL, 0x0000040000027802ULL, 0x000fe20000000f00ULL,
0x000000100b0b7824ULL, 0x000fe200078e00ffULL, 0x0000000d060d7212ULL, 0x000fe400078efcffULL,
0x0000065411027816ULL, 0x004fe40000000002ULL, 0xfffffff00b0b7812ULL, 0x000fe400078ee208ULL,
0x000000040d067c10ULL, 0x000fc6000ff3e0ffULL, 0x000000100b0b7824ULL, 0x000fe200078e0202ULL,
0x0000000507077c10ULL, 0x000fca0008ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000060b7faeULL, 0x0003e2000c101c46ULL, 0x00000000006c7947ULL, 0x000fea0003800000ULL,
0x0000000000047919ULL, 0x000e620000000000ULL, 0xffffffffff067424ULL, 0x000fe200078e00ffULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000000117919ULL, 0x000ea20000008800ULL,
0x00000007040b7211ULL, 0x042fe200078fe0ffULL, 0x00000010040a7824ULL, 0x000fe200078e00ffULL,
0x0000000f06077219ULL, 0x000fc600000006ffULL, 0x000000010c067824ULL, 0x000fe200078e020bULL,
0x000000f00a0d7812ULL, 0x000fe200078ec0ffULL, 0x000000010b087824ULL, 0x040fe400078e0204ULL,
0x000000100b0b7824ULL, 0x000fe200078e00ffULL, 0x0000000706077212ULL, 0x000fe400078e30ffULL,
0x0000000fff067219ULL, 0x000fe40000011606ULL, 0xfffffff00b0b7812ULL, 0x000fe200078ee208ULL,
0x0000000102077824ULL, 0x000fe200078e0207ULL, 0x0000040000027802ULL, 0x000fc60000000f00ULL,
0x0000005506067224ULL, 0x000fe200078e0207ULL, 0x0000065411027816ULL, 0x004fc60000000002ULL,
0x0000010006067825ULL, 0x000fc800078e00ffULL, 0x000000100b0b7824ULL, 0x000fe200078e0202ULL,
0x0000000d06067212ULL, 0x000fc800078efcffULL, 0x0000000406067c10ULL, 0x000fc8000ff1e0ffULL,
0x0000000507077c10ULL, 0x000fca00087fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000060b7faeULL, 0x0003e8000b901c46ULL, 0x00000000020472caULL, 0x000fe200000e0000ULL,
0x00009200ff067b82ULL, 0x002e620000000a00ULL, 0x0000000000007918ULL, 0x000fd60000000000ULL,
0x0001760004047890ULL, 0x000fd2000fffe03fULL, 0x000000ffffff79a7ULL, 0x000fe20008200404ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a84ULL, 0x0000000405067825ULL, 0x002fe200078e0006ULL,
0x0000000000007918ULL, 0x000fc80000000000ULL, 0x00000006067b7981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0900720cULL, 0x000fe20003f05270ULL, 0x0000003f7b7c7836ULL, 0x004fe40000000000ULL,
0x000000ff7b107836ULL, 0x000fc60000000000ULL, 0x00000006ff7c7819ULL, 0x000fe4000001167cULL,
0x00000008ff7d7819ULL, 0x000fca0000011610ULL, 0x000000a800508947ULL, 0x000fea0003800000ULL,
0x00000002ff507819ULL, 0x000fe20000011600ULL, 0xffffffffff087424ULL, 0x000fe400078e00ffULL,
0x00000004ff0b7424ULL, 0x000fe200078e00ffULL, 0x03ffffff50097812ULL, 0x000fc800078ec0ffULL,
0x0000007c0900720cULL, 0x000fda0003f06070ULL, 0x00009400ff078b82ULL, 0x000e620000000800ULL,
0x0000000205068824ULL, 0x000fce00078e00ffULL, 0x00009000ff0c8b82ULL, 0x000ea20000000a00ULL,
0x0000000706068224ULL, 0x002fc800078e0207ULL, 0x0000000109078824ULL, 0x000fe400078e0206ULL,
0x0000000800067824ULL, 0x000fe400078e0202ULL, 0x00000004070c8825ULL, 0x004fe400078e000cULL,
0x0176880b06ff79a7ULL, 0x0003e6000850003fULL, 0x000000060c088981ULL, 0x000ea2000c1e1900ULL,
0x000001ff1000780cULL, 0x000fe20003f04070ULL, 0x00000040524a7824ULL, 0x000fe200078e00ffULL,
0x00000001ff537819ULL, 0x000fc40000011600ULL, 0x00000001000b7812ULL, 0x002fc600078ec0ffULL,
0x0000002053577824ULL, 0x000fe200078e00ffULL, 0x00008e00ff067b82ULL, 0x000e620000000a00ULL,
0x0000000308087224ULL, 0x004fc800078e02ffULL, 0x0000004008037824ULL, 0x000fc800078e00ffULL,
0x0000008003067825ULL, 0x002fe200078e0006ULL, 0x000000204a037812ULL, 0x000fe200078ef857ULL,
0x0000000000fc0947ULL, 0x000fec0003800000ULL, 0x000000577b087248ULL, 0x000fe20007fe0000ULL,
0x000000100b0d7824ULL, 0x000fe200078e00ffULL, 0x00000003ff0c7819ULL, 0x000fc60000011604ULL,
0x0000000108087824ULL, 0x000fe400078e0a57ULL, 0x000000010d0e7824ULL, 0x000fe400078e020cULL,
0x000000040c107836ULL, 0x000fe20000000000ULL, 0x0000000d08087248ULL, 0x000fe20007fe0000ULL,
0x000000010e0f7824ULL, 0x040fe400078e0204ULL, 0x000000080e147824ULL, 0x000fe400078e00ffULL,
0x0000000108087824ULL, 0x000fc400078e0a0dULL, 0x0000000c0c117836ULL, 0x000fe20000000000ULL,
0xfffffff814147812ULL, 0x000fe200078ee20fULL, 0x000000080c0f7836ULL, 0x000fe20000000000ULL,
0x000000081000720cULL, 0x080fe20003f46070ULL, 0x000000010d107824ULL, 0x000fe200078e0210ULL,
0x000000080c00720cULL, 0x080fe20003f66070ULL, 0x00000001030c7824ULL, 0x000fe200078e020eULL,
0x000000080f00720cULL, 0x080fe20003f26070ULL, 0x00000001100e7824ULL, 0x040fe200078e0204ULL,
0x000000081100720cULL, 0x000fe20003f06070ULL, 0x0000000810137824ULL, 0x000fc400078e00ffULL,
0x000000010d0f7824ULL, 0x040fe400078e020fULL, 0x000000010d127824ULL, 0x000fe200078e0211ULL,
0xfffffff813087812ULL, 0x000fe200078ee20eULL, 0x000000800c0c7825ULL, 0x000fc800078e00ffULL,
0x00000001030e7824ULL, 0x000fe200078e020fULL, 0x000000700c137812ULL, 0x000fe200078ef80aULL,
0x000000010f117824ULL, 0x040fe400078e0204ULL, 0x000000080f167824ULL, 0x000fe400078e00ffULL,
0x0000000103157824ULL, 0x040fe400078e0212ULL, 0x00000001120c7824ULL, 0x040fe200078e0204ULL,
0xfffffff816167812ULL, 0x000fe200078ee211ULL, 0x00000008120f7824ULL, 0x000fe200078e00ffULL,
0x0000001306127210ULL, 0x000fe20007f9e0ffULL, 0x0000000103107824ULL, 0x000fc400078e0210ULL,
0x0000200053037824ULL, 0x000fe200078e0202ULL, 0xfffffff80f187812ULL, 0x000fe200078ee20cULL,
0x0000000107137824ULL, 0x000fe400020e060dULL, 0x00000080100c7825ULL, 0x000fc800078e00ffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000700c1f7812ULL, 0x000fc600078ef80aULL,
0x0000008015107825ULL, 0x000fe200078e00ffULL, 0x000000700e1d7812ULL, 0x000fe400078ef80aULL,
0x0000001f060c7210ULL, 0x000fe20007f9e0ffULL, 0x0001300003037836ULL, 0x000fe20000000000ULL,
0x00000070101b7812ULL, 0x000fe400078ef80aULL, 0x0000001d060e7210ULL, 0x000fe20007fbe0ffULL,
0x0000001014157824ULL, 0x100fe200078e0203ULL, 0x0000001b06067210ULL, 0x000fe20007fde0ffULL,
0x0000001008177824ULL, 0x000fc400078e0203ULL, 0x00000001070d7824ULL, 0x040fe200020e060dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012157faeULL, 0x0003e2000d901c46ULL,
0x0000001016197824ULL, 0x000fe400078e0203ULL, 0x00000001070f7824ULL, 0x040fe200028e060fULL,
0x000000000c177faeULL, 0x0003e2000d101c46ULL, 0x0000001018037824ULL, 0x000fe400078e0203ULL,
0x0000000107077824ULL, 0x000fe200030e0611ULL, 0x000000000e197faeULL, 0x0003e8000c901c46ULL,
0x0000000006037faeULL, 0x0003e2000c101c46ULL, 0x0000000000c87947ULL, 0x000fea0003800000ULL,
0x000000100b0d7824ULL, 0x000fca00078e00ffULL, 0x0000000d04087211ULL, 0x000fca00078fe8ffULL,
0x00000001080d7824ULL, 0x040fe400078e0204ULL, 0x0000000808147824ULL, 0x000fe400078e00ffULL,
0x00000004080e7836ULL, 0x000fe40000000000ULL, 0x00000001030c7824ULL, 0x000fe200078e0208ULL,
0xfffffff814147812ULL, 0x000fe200078ee20dULL, 0x000000010e0f7824ULL, 0x040fe400078e0204ULL,
0x000000080e107824ULL, 0x000fc400078e00ffULL, 0x000000800c0c7825ULL, 0x000fc600078e00ffULL,
0xfffffff810157812ULL, 0x000fe200078ee20fULL, 0x00000008080f7836ULL, 0x000fe20000000000ULL,
0x000000700c137812ULL, 0x000fe200078ef80aULL, 0x0000000c08107836ULL, 0x000fe40000000000ULL,
0x00000001030e7824ULL, 0x040fe200078e020eULL, 0x0000001306127210ULL, 0x000fe20007f1e0ffULL,
0x0000000103087824ULL, 0x040fe400078e020fULL, 0x0000000103117824ULL, 0x000fe400078e0210ULL,
0x00000001100c7824ULL, 0x000fc400078e0204ULL, 0x0000000810177824ULL, 0x000fe400078e00ffULL,
0x000000010f037824ULL, 0x040fe400078e0204ULL, 0x000000080f167824ULL, 0x000fe200078e00ffULL,
0xfffffff817187812ULL, 0x000fe200078ee20cULL, 0x00002000530f7824ULL, 0x000fe400078e0202ULL,
0x0000000107137824ULL, 0x000fe200000e060dULL, 0xfffffff816167812ULL, 0x000fe200078ee203ULL,
0x000130000f1f7836ULL, 0x000fc40000000000ULL, 0x000000800e0c7825ULL, 0x000fc800078e00ffULL,
0x00000080080e7825ULL, 0x000fe200078e00ffULL, 0x000000700c1d7812ULL, 0x000fc600078ef80aULL,
0x0000008011107825ULL, 0x000fe200078e00ffULL, 0x000000700e1b7812ULL, 0x000fe400078ef80aULL,
0x0000001d060c7210ULL, 0x000fe20007f1e0ffULL, 0x0000001014037824ULL, 0x100fe200078e021fULL,
0x0000007010197812ULL, 0x000fe200078ef80aULL, 0x0000001015157824ULL, 0x000fe200078e021fULL,
0x0000001b060e7210ULL, 0x000fe20007f3e0ffULL, 0x00000001070d7824ULL, 0x040fe200000e060dULL,
0x0000001906067210ULL, 0x000fe20007f5e0ffULL, 0x0000001016177824ULL, 0x000fe200078e021fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012037faeULL, 0x0003e2000b901c46ULL,
0x00000001070f7824ULL, 0x000fc400008e060fULL, 0x0000001018197824ULL, 0x000fe200078e021fULL,
0x000000000c157faeULL, 0x0003e2000b901c46ULL, 0x0000000107077824ULL, 0x000fc600010e0611ULL,
0x000000000e177faeULL, 0x0003e8000b901c46ULL, 0x0000000006197faeULL, 0x0003e4000b901c46ULL,
0x00000001090c7836ULL, 0x002fe40000000000ULL, 0xffffffffff117424ULL, 0x000fc600078e00ffULL,
0x0000007c0c00720cULL, 0x000fda0003f06070ULL, 0x00009400ff088b82ULL, 0x000e620000000800ULL,
0x0000000205038824ULL, 0x000fe200078e00ffULL, 0x00000000530472caULL, 0x000fcc00000e0000ULL,
0x00009000ff068b82ULL, 0x000ea20000000a00ULL, 0x0000000803038224ULL, 0x002fe400078e0208ULL,
0x000176a802087836ULL, 0x000fc80000000000ULL, 0x0000000404047899ULL, 0x000fe2000800063fULL,
0x0000000103038824ULL, 0x000fe200078e020cULL, 0x00000000080572caULL, 0x000fc600000e0000ULL,
0x0000000403068825ULL, 0x004fe200078e0006ULL, 0x0000000000007918ULL, 0x000fc80000000000ULL,
0x0000000606118981ULL, 0x000322000c1e1900ULL, 0x000000ff7d00720cULL, 0x000fe20003f05270ULL,
0x00000001ff037424ULL, 0x000fe200078e00ffULL, 0x0000000000367805ULL, 0x000fe4000001ff00ULL,
0x0000000504057290ULL, 0x000fe2000fffe03fULL, 0x000000ffff0f7224ULL, 0x000fe200078e00ffULL,
0x0000000000347805ULL, 0x000fe4000001ff00ULL, 0x0000000000327805ULL, 0x000fe4000001ff00ULL,
0x0000000000307805ULL, 0x000fc4000001ff00ULL, 0x00000000002e7805ULL, 0x000fe4000001ff00ULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff297224ULL, 0x000fe200078e00ffULL, 0x00000000ff0079b0ULL, 0x000fe20008000a45ULL,
0x0000000853097824ULL, 0x000fe200078e0208ULL, 0x0000000000007918ULL, 0x002fcc0000000000ULL,
0x00000003080679a7ULL, 0x0002a20008500004ULL, 0x000000ffff287224ULL, 0x000fe200078e00ffULL,
0x0000000000267805ULL, 0x000fe4000001ff00ULL, 0x0000000000247805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x00000000001e7805ULL, 0x000fc4000001ff00ULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x00000000001a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00002003090879a7ULL, 0x0022e2000850003fULL, 0x0000008c00848947ULL, 0x000fea0003800000ULL,
0x00009400ff0a7b82ULL, 0x000f620000000800ULL, 0x00000004ff067e24ULL, 0x004fe4000f8e00ffULL,
0x0000002050037824ULL, 0x002fe400078e0202ULL, 0x00000002054b7824ULL, 0x000fe200078e00ffULL,
0x0000001006067812ULL, 0x000fe200078ec0ffULL, 0x000000ffff0d7224ULL, 0x008fe400078e0009ULL,
0x000000ffff377224ULL, 0x000fe400078e00ffULL, 0x0000000103087824ULL, 0x000fc400078e0206ULL,
0x000000ffff067224ULL, 0x000fe400078e0007ULL, 0x000000080b0b7824ULL, 0x000fe400078e0208ULL,
0xff317217ff077424ULL, 0x000fe400078e00ffULL, 0x0000000a4b4b7224ULL, 0x020fe400078e020aULL,
0x000000ffff0a7224ULL, 0x000fce00078e00ffULL, 0x000000ffff4f7224ULL, 0x000fce00078e000cULL,
0x0000000000127805ULL, 0x000fce0000015200ULL, 0x0000000400097824ULL, 0x000fca00078e00ffULL,
0xfffffff809097812ULL, 0x000fca00078ec0ffULL, 0x00000001020e7824ULL, 0x000fc800078e0209ULL,
0x0176c80d0e0075a7ULL, 0x000e62000800017fULL, 0x000176c80e097836ULL, 0x000fe20000000000ULL,
0x00000000005c0947ULL, 0x002fec0003800000ULL, 0x000000ffff167224ULL, 0x000fce00078e00ffULL,
0x000000101600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x0000001412177210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e13ULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff107819ULL, 0x000fc80000011415ULL,
0x0000001710107211ULL, 0x000fca00078110ffULL, 0x000000ffff157224ULL, 0x000fca00000e0615ULL,
0x0000000210107819ULL, 0x000fc80000001215ULL, 0x000000100000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000116167836ULL, 0x000fce0000000000ULL,
0x0176c80d0e0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00008e00ff127b82ULL, 0x000e620000000a00ULL, 0x00000010000d7824ULL, 0x000fe200078e00ffULL,
0x0000850000047ab9ULL, 0x000fe20000000800ULL, 0x000000010a0e7836ULL, 0x000fe40000000000ULL,
0x0000000411117c24ULL, 0x010fe2000f8e02ffULL, 0xffffffe00d157812ULL, 0x000fe400078ec0ffULL,
0x0000007d0e00720cULL, 0x000fe20003f26070ULL, 0x0000004011117824ULL, 0x000fe400078e00ffULL,
0x000001000a157824ULL, 0x000fc800078e0215ULL, 0x0000004015147836ULL, 0x000fca0000000000ULL,
0x0000002014157812ULL, 0x000fe200078ec0ffULL, 0x0000008011107825ULL, 0x002fc800078e0012ULL,
0x000000014a387824ULL, 0x000fe200078e0215ULL, 0x0000000400049947ULL, 0x000fec0003800000ULL,
0x000000100d0e7812ULL, 0x000fe400078ec0ffULL, 0x000000147b0d7248ULL, 0x000fe40007fe0000ULL,
0x00000003ff157819ULL, 0x000fc60000011604ULL, 0x000000010d0d7824ULL, 0x000fe400078e0a14ULL,
0x0000000115137824ULL, 0x000fe400078e020eULL, 0x0000000c15167836ULL, 0x000fe20000000000ULL,
0x0000000e0d0d7248ULL, 0x000fe20007fe0000ULL, 0x0000000113127824ULL, 0x040fe400078e0204ULL,
0x0000000813177824ULL, 0x000fe400078e00ffULL, 0x000000010d0d7824ULL, 0x000fc400078e0a0eULL,
0x0000001004147824ULL, 0x000fe200078e00ffULL, 0xfffffff8173a7812ULL, 0x000fe200078ee212ULL,
0x0000000815177836ULL, 0x000fe20000000000ULL, 0x0000000d1500720cULL, 0x080fe20003f86070ULL,
0x0000000415127836ULL, 0x000fe20000000000ULL, 0x0000000d1600720cULL, 0x080fe20003f06070ULL,
0x0000000138137824ULL, 0x000fe200078e0213ULL, 0x0000000d1700720cULL, 0x0c0fe20003f46070ULL,
0x0000000112157824ULL, 0x140fe200078e020eULL, 0x0000000d1200720cULL, 0x000fe20003f66070ULL,
0x0000000117177824ULL, 0x100fe200078e020eULL, 0x00000070143f7812ULL, 0x000fe200078ec0ffULL,
0x0000000116397824ULL, 0x000fc400078e020eULL, 0x0000000138167824ULL, 0x000fe400078e0215ULL,
0x00000001150d7824ULL, 0x140fe400078e0204ULL, 0x00000008150e7824ULL, 0x000fe400078e00ffULL,
0x0000000117157824ULL, 0x040fe400078e0204ULL, 0x00000008173c7824ULL, 0x000fe200078e00ffULL,
0xfffffff80e0e7812ULL, 0x000fe200078ee20dULL, 0x0000008013127825ULL, 0x000fc600078e00ffULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee215ULL, 0x0000000138147824ULL, 0x000fe200078e0217ULL,
0x0000003f12157212ULL, 0x000fe200078efcffULL, 0x0000008016167825ULL, 0x000fc600078e00ffULL,
0x0000001510127210ULL, 0x000fe20007fbe0ffULL, 0x0000000138387824ULL, 0x000fe200078e0239ULL,
0x0000003f160d7212ULL, 0x000fe200078efcffULL, 0x00000001393b7824ULL, 0x040fe400078e0204ULL,
0x00000008393e7824ULL, 0x000fe200078e00ffULL, 0x0000000d10167210ULL, 0x000fe20007fde0ffULL,
0x0000008014147825ULL, 0x000fc600078e00ffULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee23bULL,
0x0000008038387825ULL, 0x000fe200078e00ffULL, 0x0000003f14417212ULL, 0x000fc600078efcffULL,
0x00002000533b7824ULL, 0x000fe200078e0202ULL, 0x0000003f383f7212ULL, 0x000fe200078efcffULL,
0x0000000111137824ULL, 0x040fe200028e0613ULL, 0x0000004110147210ULL, 0x000fe20007fbe0ffULL,
0x000140003b0d7836ULL, 0x000fe40000000000ULL, 0x0000000111177824ULL, 0x000fe200030e0617ULL,
0x0000003f10107210ULL, 0x000fe20007fde0ffULL, 0x000000103a3b7824ULL, 0x100fe400078e020dULL,
0x000000100e3d7824ULL, 0x000fc400078e020dULL, 0x000000103c3f7824ULL, 0x000fe200078e020dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000123b7faeULL, 0x0003e2000e101c46ULL,
0x0000000111157824ULL, 0x040fe400028e0615ULL, 0x000000103e0d7824ULL, 0x000fe200078e020dULL,
0x00000000163d7faeULL, 0x0003e2000d901c46ULL, 0x0000000111117824ULL, 0x000fc600030e0639ULL,
0x00000000143f7faeULL, 0x0003e8000d101c46ULL, 0x00000000100d7faeULL, 0x0003e2000c101c46ULL,
0x0000000000d07947ULL, 0x000fea0003800000ULL, 0x000000100d0d7812ULL, 0x000fe200078ec0ffULL,
0x0000001004147824ULL, 0x000fc600078e00ffULL, 0x0000000d040d7211ULL, 0x000fe400078fe8ffULL,
0x00000070143f7812ULL, 0x000fc600078ec0ffULL, 0x000000010d0e7824ULL, 0x140fe400078e0204ULL,
0x000000080d177824ULL, 0x000fe400078e00ffULL, 0x000000040d157836ULL, 0x000fe40000000000ULL,
0x0000000c0d397836ULL, 0x000fe20000000000ULL, 0xfffffff8170e7812ULL, 0x000fe200078ee20eULL,
0x0000000115137824ULL, 0x040fe400078e0204ULL, 0x00000008153a7824ULL, 0x000fc400078e00ffULL,
0x000000080d177836ULL, 0x000fe40000000000ULL, 0x0000000138127824ULL, 0x040fe200078e020dULL,
0xfffffff83a3a7812ULL, 0x000fe200078ee213ULL, 0x0000000138157824ULL, 0x040fe400078e0215ULL,
0x0000000138167824ULL, 0x040fe400078e0217ULL, 0x0000000138387824ULL, 0x000fe400078e0239ULL,
0x0000000139147824ULL, 0x000fc400078e0204ULL, 0x0000008012127825ULL, 0x000fc800078e00ffULL,
0x0000000839397824ULL, 0x000fe200078e00ffULL, 0x0000003f123b7212ULL, 0x000fe200078efcffULL,
0x00000001170d7824ULL, 0x040fe400078e0204ULL, 0x00000008173c7824ULL, 0x000fe200078e00ffULL,
0xfffffff8393e7812ULL, 0x000fe200078ee214ULL, 0x0000200053177824ULL, 0x000fe200078e0202ULL,
0x0000003b10127210ULL, 0x000fe20007f1e0ffULL, 0x0000008015147825ULL, 0x000fe200078e00ffULL,
0xfffffff83c3c7812ULL, 0x000fc600078ee20dULL, 0x0001400017457836ULL, 0x000fe20000000000ULL,
0x0000003f14437212ULL, 0x000fe200078efcffULL, 0x0000008016167825ULL, 0x000fc800078e00ffULL,
0x0000008038387825ULL, 0x000fe200078e00ffULL, 0x0000003f16417212ULL, 0x000fc600078efcffULL,
0x0000000111137824ULL, 0x040fe200000e0613ULL, 0x0000003f383f7212ULL, 0x000fe200078efcffULL,
0x000000100e0d7824ULL, 0x100fe200078e0245ULL, 0x0000004310147210ULL, 0x000fe20007f1e0ffULL,
0x000000103a3b7824ULL, 0x100fe200078e0245ULL, 0x0000004110167210ULL, 0x000fe20007f5e0ffULL,
0x000000103c3d7824ULL, 0x000fe200078e0245ULL, 0x0000003f10107210ULL, 0x000fe20007f7e0ffULL,
0x0000000111157824ULL, 0x040fe200000e0615ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000120d7faeULL, 0x0003e2000b901c46ULL, 0x0000000111177824ULL, 0x000fc400010e0617ULL,
0x000000103e3f7824ULL, 0x000fe200078e0245ULL, 0x00000000143b7faeULL, 0x0003e2000b901c46ULL,
0x0000000111117824ULL, 0x000fc600018e0639ULL, 0x00000000163d7faeULL, 0x0003e8000b901c46ULL,
0x00000000103f7faeULL, 0x0003e4000b901c46ULL, 0x000000010c0d7836ULL, 0x002fe40000000000ULL,
0xffffffffff167424ULL, 0x000fc600078e00ffULL, 0x0000007c0d00720cULL, 0x000fda0003f06070ULL,
0x00009000ff108b82ULL, 0x000e620000000a00ULL, 0x000000014b0d8824ULL, 0x000fc800078e020dULL,
0x000000040d108825ULL, 0x002fc800078e0010ULL, 0x00000008000d7824ULL, 0x000fe200078e00ffULL,
0x0000000610168981ULL, 0x000322000c1e1900ULL, 0x00000001ff387424ULL, 0x000fc600078e00ffULL,
0xfffffff00d137812ULL, 0x040fe400078ec0ffULL, 0x000000100d0e7812ULL, 0x000fc600078ec0ffULL,
0x0000000102147824ULL, 0x000fe200078e0213ULL, 0xffffffe00d137812ULL, 0x040fe400078ec0ffULL,
0x000000080d0d7812ULL, 0x000fe400078ec0ffULL, 0x00000000140472caULL, 0x000fe200000e0000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x000000020e0e7210ULL, 0x000fca0007ffe013ULL,
0x000000010e0d7824ULL, 0x000fcc00078e020dULL, 0x000176b004047890ULL, 0x000fd2000fffe03fULL,
0x00000000ff0079b0ULL, 0x000fe20008000a44ULL, 0x0000000000007918ULL, 0x002fe40000000000ULL,
0x0176b038141479a7ULL, 0x0002a4000850003fULL, 0x017608380d3879a7ULL, 0x0022e4000850003fULL,
0x0000000000107805ULL, 0x000fce0000015200ULL, 0x017608390d0075a7ULL, 0x008ee4000800017fULL,
0x00000000005c0947ULL, 0x008fea0003800000ULL, 0x000000ffff3a7224ULL, 0x000fce00078e00ffULL,
0x000000103a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fce0000015200ULL, 0x0000001210177210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff0e7819ULL, 0x000fc80000011413ULL,
0x000000170e0e7211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x000000020e0e7819ULL, 0x000fc80000001213ULL, 0x0000000e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013a3a7836ULL, 0x000fce0000000000ULL,
0x017608390d0075a7ULL, 0x000ee4000800017fULL, 0xfffffffc00a88947ULL, 0x008fea000383ffffULL,
0x00000010044d7824ULL, 0x000fe200078e00ffULL, 0x00000001ff517819ULL, 0x000fe20000011604ULL,
0x00000020000e7824ULL, 0x000fe400078e00ffULL, 0x00000001ff177424ULL, 0x000fe200078e00ffULL,
0x000000704d4d7812ULL, 0x000fe400078ec0ffULL, 0xffffff800e0e7812ULL, 0x000fe400078ec0ffULL,
0x0000000c51517812ULL, 0x000fe400078ec0ffULL, 0x000000024d0e7210ULL, 0x000fca0007ffe00eULL,
0x000000010e107824ULL, 0x000fca00078e0251ULL, 0x0170000010127984ULL, 0x000ee80000000800ULL,
0x0172000010117984ULL, 0x000b620000000800ULL, 0x000000071200720bULL, 0x008fda0003f1d000ULL,
0x00000000000e7806ULL, 0x000fc800000e0100ULL, 0x0000ffff0e137812ULL, 0x000fe2000780c0ffULL,
0x000000ffff0e7224ULL, 0x000fd800078e0007ULL, 0x0000000000fc8947ULL, 0x026fea0003800000ULL,
0x000000005000720cULL, 0x000fe40003f45270ULL, 0x000000071200720bULL, 0x0c0fe40003f14000ULL,
0x0000000712397209ULL, 0x000fd20007810000ULL, 0x00000080000ea824ULL, 0x000fe400078e0202ULL,
0x0000000000387806ULL, 0x000fc600000e0100ULL, 0x0000000e510ea210ULL, 0x000fe40007ffe04dULL,
0x0000991038107816ULL, 0x000fc600000000ffULL, 0x017400390e00a388ULL, 0x0003e20000000800ULL,
0x000000ff1000720cULL, 0x000fda0003f05270ULL, 0x0000000000b08947ULL, 0x002fea0003800000ULL,
0x8000003907077221ULL, 0x000fe20000010000ULL, 0x000000ff38ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0038ff7812ULL, 0x000fe2000784c0ffULL, 0x3fb8aa3b07077820ULL, 0x000fc80000410000ULL,
0x00000007000e7308ULL, 0x0002ac0000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff077819ULL, 0x002fcc0000011604ULL, 0x00001f070e077589ULL, 0x004e6400000e0000ULL,
0x0000000718187220ULL, 0x082fe20000410000ULL, 0x0000000719197220ULL, 0x080fe20000410000ULL,
0x000000071c1c7220ULL, 0x080fe20000410000ULL, 0x000000071d1d7220ULL, 0x080fe20000410000ULL,
0x0000000720207220ULL, 0x080fe20000410000ULL, 0x0000000721217220ULL, 0x080fe20000410000ULL,
0x0000000724247220ULL, 0x080fe20000410000ULL, 0x0000000725257220ULL, 0x080fe20000410000ULL,
0x0000000728287220ULL, 0x080fe20000410000ULL, 0x0000000729297220ULL, 0x080fe20000410000ULL,
0x000000072c2c7220ULL, 0x080fe20000410000ULL, 0x000000072d2d7220ULL, 0x080fe20000410000ULL,
0x0000000730307220ULL, 0x080fe20000410000ULL, 0x0000000731317220ULL, 0x080fe20000410000ULL,
0x0000000734347220ULL, 0x080fe20000410000ULL, 0x0000000735357220ULL, 0x000fce0000410000ULL,
0x0000000e0f0f7220ULL, 0x004fe20000410000ULL, 0x000000000048a947ULL, 0x000fec0003800000ULL,
0x0000000804077811ULL, 0x002fcc00078ff0ffULL, 0x00001f070e077589ULL, 0x000e6400000e0000ULL,
0x000000071a1a7220ULL, 0x082fe20000410000ULL, 0x000000071b1b7220ULL, 0x080fe20000410000ULL,
0x000000071e1e7220ULL, 0x080fe20000410000ULL, 0x000000071f1f7220ULL, 0x080fe20000410000ULL,
0x0000000722227220ULL, 0x080fe20000410000ULL, 0x0000000723237220ULL, 0x080fe20000410000ULL,
0x0000000726267220ULL, 0x080fe20000410000ULL, 0x0000000727277220ULL, 0x080fe20000410000ULL,
0x000000072a2a7220ULL, 0x080fe20000410000ULL, 0x000000072b2b7220ULL, 0x080fe20000410000ULL,
0x000000072e2e7220ULL, 0x080fe20000410000ULL, 0x000000072f2f7220ULL, 0x080fe20000410000ULL,
0x0000000732327220ULL, 0x080fe20000410000ULL, 0x0000000733337220ULL, 0x080fe20000410000ULL,
0x0000000736367220ULL, 0x080fe20000410000ULL, 0x0000000737377220ULL, 0x000fce0000410000ULL,
0x0000ffff13ff7812ULL, 0x000fe20007806038ULL, 0x00000001ff177424ULL, 0x000fe400078e00ffULL,
0x000000ffff0e7224ULL, 0x000fd400078e0039ULL, 0x8000003912120221ULL, 0x100fe20000010000ULL,
0x000000ffff0e0224ULL, 0x000fe200078e0039ULL, 0x00007610ff170816ULL, 0x000fe40000000017ULL,
0x3fb8aa3b12120820ULL, 0x000fc80000410000ULL, 0x0000001200080308ULL, 0x000ea40000000800ULL,
0x0000000811110220ULL, 0x004fce0000410000ULL, 0x0000000f110f7221ULL, 0x000fce0000010000ULL,
0x0000000000107805ULL, 0x000fce0000015200ULL, 0x0000000800077824ULL, 0x002fca00078e00ffULL,
0xfffffff007077812ULL, 0x000fca00078ec0ffULL, 0x0000000102397824ULL, 0x000fc800078e0207ULL,
0x0176a806390075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff387224ULL, 0x000fce00078e00ffULL, 0x000000103800780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fce0000015200ULL,
0x0000001210127210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e11ULL,
0x003d09001200780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401200780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff077819ULL, 0x000fc80000011413ULL, 0x0000001207077211ULL, 0x000fca00078110ffULL,
0x000000ffff127224ULL, 0x000fca00000e0613ULL, 0x0000000207077819ULL, 0x000fc80000001212ULL,
0x000000070000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000138387836ULL, 0x000fce0000000000ULL, 0x0176a806390075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000200457824ULL, 0x040fe200078e00ffULL,
0x0000991017077816ULL, 0x000fe200000000ffULL, 0x0000000400467824ULL, 0x000fe200078e00ffULL,
0x00000007043e7812ULL, 0x000fe200078ec0ffULL, 0x0000020000067824ULL, 0x000fe200078e00ffULL,
0x0000000445117812ULL, 0x000fe400078ec0ffULL, 0x000000ff0700720cULL, 0x000fe20003f05270ULL,
0x0000200053077824ULL, 0x000fe200078e0202ULL, 0x000000083e477812ULL, 0x000fe400078ef804ULL,
0x00000011044c7211ULL, 0x040fe200078fe0ffULL, 0x0001300007177836ULL, 0x000fe20000000000ULL,
0x00000008043d7812ULL, 0x000fe200078ec0ffULL, 0x0000000847117824ULL, 0x040fe200078e00ffULL,
0x00000004ff487819ULL, 0x000fe20000011604ULL, 0x00000001474c7824ULL, 0x000fe200078e024cULL,
0x0000000446467812ULL, 0x000fc400078ec0ffULL, 0x0000003e3d417212ULL, 0x000fe400078efcffULL,
0xfffff800063f7812ULL, 0x000fe200078ec0ffULL, 0x0000000148467824ULL, 0x000fe200078e0246ULL,
0xfffffff8114e7812ULL, 0x000fe200078ee24cULL, 0x0000000841137824ULL, 0x040fe400078e00ffULL,
0x0000000141407824ULL, 0x000fe400078e0246ULL, 0x00000001023f7824ULL, 0x000fc600078e023fULL,
0xfffffff813067812ULL, 0x000fe200078ee240ULL, 0x000000104e3c7824ULL, 0x000fe200078e023fULL,
0x0000000000180947ULL, 0x000fec0003800000ULL, 0x00000002ff057819ULL, 0x000fe40000011604ULL,
0x00000008ff03723eULL, 0x000fc600000000ffULL, 0x0000000805117836ULL, 0x000fe20000000000ULL,
0x0000541003107816ULL, 0x000fca0000000003ULL, 0x00001f0510057589ULL, 0x0002a800000e0000ULL,
0x00001f1110037589ULL, 0x0002e400000e0000ULL, 0x011000003c10783bULL, 0x0022e20000000200ULL,
0x0000001006387824ULL, 0x000fe200078e0217ULL, 0x0000000000100947ULL, 0x000fec0003800000ULL,
0x0000000510107232ULL, 0x08cfe40000000000ULL, 0x0000000512127232ULL, 0x000fe40000000000ULL,
0x0000000311117232ULL, 0x080fe40000000000ULL, 0x0000000313137232ULL, 0x000fce0000000000ULL,
0x0000000841417824ULL, 0x000fe200078e00ffULL, 0x000000003838783bULL, 0x000f620000004200ULL,
0x0000000240447836ULL, 0x000fe20000000000ULL, 0x000000103d3d7812ULL, 0x000fe200078efe3eULL,
0x0000000453487824ULL, 0x000fc600078e0248ULL, 0xfffffff841447812ULL, 0x000fe200078ee244ULL,
0x0000000146467824ULL, 0x000fe200078e023dULL, 0x0000000248487810ULL, 0x000fe20007ffe047ULL,
0x0000000847477824ULL, 0x000fe400078e00ffULL, 0x0000001044407824ULL, 0x000fc600078e0217ULL,
0xfffffff8473e7812ULL, 0x000fc600078ee248ULL, 0x000000004040783bULL, 0x000f640000004200ULL,
0x000000103e3f7824ULL, 0x000fe200078e023fULL, 0x00000018ff6e7819ULL, 0x022fe4000001163aULL,
0x00000010ff697819ULL, 0x000fe40000011638ULL, 0x00000010ff6a7819ULL, 0x000fe40000011639ULL,
0x0000ffff386b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff39687812ULL, 0x000fc400078ec0ffULL,
0x00000018ff637819ULL, 0x000fe40000011639ULL, 0x0000ffff39617812ULL, 0x000fe400078ec0ffULL,
0x00000010ff657819ULL, 0x000fe4000001163aULL, 0x000000ff69697812ULL, 0x000fe400078ec0ffULL,
0x00000010ff397819ULL, 0x008fe40000011641ULL, 0x000000ff415b7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff587819ULL, 0x000fe40000011641ULL, 0x0000ffff41627812ULL, 0x000fe400078ec0ffULL,
0x0000006eff41723eULL, 0x000fe400020006ffULL, 0x000000ff6a6e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff667819ULL, 0x000fe4000001163bULL, 0x00000008ff6a7819ULL, 0x000fc4000001166bULL,
0x000000ff386c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff677819ULL, 0x000fe40000011640ULL,
0x00000069ff6b723eULL, 0x000fe400020006ffULL, 0x000000ff65657812ULL, 0x000fe400078ec0ffULL,
0x00000018ff647819ULL, 0x000fe40000011638ULL, 0x00000018ff6d7819ULL, 0x000fc4000001163bULL,
0x0000006aff69723eULL, 0x000fe400020006ffULL, 0x000000ff66667812ULL, 0x000fe400078ec0ffULL,
0x0000ffff40387812ULL, 0x000fe400078ec0ffULL, 0x00000008ff6a7819ULL, 0x000fe40000011661ULL,
0x0000006cff6c723eULL, 0x000fe400020006ffULL, 0x00000068ff68723eULL, 0x000fc400020006ffULL,
0x0000006eff6e723eULL, 0x000fe400020006ffULL, 0x000000ff67617812ULL, 0x000fe400078ec0ffULL,
0x000000ff405c7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff597819ULL, 0x000fe40000011640ULL,
0x00000065ff67723eULL, 0x000fe400020006ffULL, 0x0000006dff40723eULL, 0x000fc400020006ffULL,
0x00000066ff65723eULL, 0x000fe400020006ffULL, 0x000000ff396d7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff667819ULL, 0x000fe40000011638ULL, 0x000054106c387816ULL, 0x000fe4000000006bULL,
0x0000541068397816ULL, 0x000fe4000000006eULL, 0x00000064ff64723eULL, 0x000fc400020006ffULL,
0x00000063ff63723eULL, 0x000fe400020006ffULL, 0x0000006aff6a723eULL, 0x000fe200020006ffULL,
0x000000381018723cULL, 0x000fe20000001818ULL, 0x000000ff3a607812ULL, 0x000fe400078ec0ffULL,
0x000000ff3b5f7812ULL, 0x000fe400078ec0ffULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x0000541069387816ULL, 0x000fc40000000064ULL, 0x000054106a397816ULL, 0x000fe40000000063ULL,
0x0000005fff5f723eULL, 0x000fe400020006ffULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x0000005bff5b723eULL, 0x000fe200020006ffULL, 0x00000038101c723cULL, 0x000fe2000000181cULL,
0x00000061ff61723eULL, 0x000fe400020006ffULL, 0x0000006dff68723eULL, 0x000fc400020006ffULL,
0x00000008ff627819ULL, 0x000fe40000011662ULL, 0x0000541060387816ULL, 0x000fe40000000067ULL,
0x000054105f397816ULL, 0x000fe40000000065ULL, 0x00000010ff5d7819ULL, 0x000fe40000011642ULL,
0x00000010ff5e7819ULL, 0x000fe40000011643ULL, 0x00000059ff59723eULL, 0x000fe200020006ffULL,
0x000000381020723cULL, 0x000fe20000001820ULL, 0x00000058ff58723eULL, 0x000fc400020006ffULL,
0x00000066ff66723eULL, 0x000fe400020006ffULL, 0x00000062ff62723eULL, 0x000fe400020006ffULL,
0x000054105c387816ULL, 0x000fe40000000061ULL, 0x000054105b397816ULL, 0x000fe40000000068ULL,
0x0000ffff3a5a7812ULL, 0x000fe400078ec0ffULL, 0x000000ff42477812ULL, 0x000fc400078ec0ffULL,
0x00000018ff3a7819ULL, 0x000fe20000011642ULL, 0x000000381028723cULL, 0x000fe20000001828ULL,
0x0000ffff42497812ULL, 0x000fe400078ec0ffULL, 0x000000ff43427812ULL, 0x000fe400078ec0ffULL,
0x000000ff5d5d7812ULL, 0x000fe400078ec0ffULL, 0x000000ff5e5e7812ULL, 0x000fe400078ec0ffULL,
0x0000541066387816ULL, 0x000fc40000000059ULL, 0x0000541062397816ULL, 0x000fe40000000058ULL,
0x0000ffff3b487812ULL, 0x000fe400078ec0ffULL, 0x00000018ff3b7819ULL, 0x000fe40000011643ULL,
0x0000ffff43437812ULL, 0x000fe200078ec0ffULL, 0x00000038102c723cULL, 0x000fe2000000182cULL,
0x00000047ff47723eULL, 0x000fe400020006ffULL, 0x00000042ff42723eULL, 0x000fc400020006ffULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x0000005eff5e723eULL, 0x000fe400020006ffULL,
0x00000008ff5a7819ULL, 0x000fe4000001165aULL, 0x00000008ff497819ULL, 0x000fe40000011649ULL,
0x00000008ff487819ULL, 0x000fe40000011648ULL, 0x00000008ff437819ULL, 0x000fc40000011643ULL,
0x0000541047387816ULL, 0x000fe2000000005dULL, 0x000000083d477824ULL, 0x000fe200078e00ffULL,
0x0000541042397816ULL, 0x000fe4000000005eULL, 0x0000003aff3a723eULL, 0x000fe400020006ffULL,
0x0000003bff3b723eULL, 0x000fe400020006ffULL, 0x0000005aff5a723eULL, 0x000fe200020006ffULL,
0x000000381030723cULL, 0x000fe20000001830ULL, 0x00000049ff49723eULL, 0x000fc400020006ffULL,
0x00000048ff48723eULL, 0x000fe400020006ffULL, 0x00000043ff43723eULL, 0x000fe400020006ffULL,
0x000054105a387816ULL, 0x000fe40000000041ULL, 0x0000541048397816ULL, 0x000fe40000000040ULL,
0x00005410493a7816ULL, 0x000fe4000000003aULL, 0x00005410433b7816ULL, 0x000fc4000000003bULL,
0xfffffff8473e7812ULL, 0x000fe200078ee246ULL, 0x000000381024723cULL, 0x000fec0000001824ULL,
0x0000003a1034723cULL, 0x000fe20000001834ULL, 0x000000103e387824ULL, 0x000fe200078e0217ULL,
0x011000003f10783bULL, 0x0002e20000000200ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000000000100947ULL, 0x000fde0003800000ULL, 0x0000000510107232ULL, 0x08cfe40000000000ULL,
0x0000000512127232ULL, 0x000fe40000000000ULL, 0x0000000311117232ULL, 0x080fe40000000000ULL,
0x0000000313137232ULL, 0x000fce0000000000ULL, 0x000000083d407824ULL, 0x000fe200078e00ffULL,
0x000000003838783bULL, 0x000f620000004200ULL, 0x00000002463d7836ULL, 0x000fe20000000000ULL,
0xfffffff845457812ULL, 0x000fc800078ec0ffULL, 0xfffffff8403d7812ULL, 0x000fe200078ee23dULL,
0x0000000102457824ULL, 0x000fc800078e0245ULL, 0x000000103d407824ULL, 0x000fcc00078e0217ULL,
0x000000004040783bULL, 0x000f640000004200ULL, 0x00000010ff6b7819ULL, 0x022fe40000011638ULL,
0x00000010ff6a7819ULL, 0x100fe40000011639ULL, 0x000000ff39667812ULL, 0x040fe400078ec0ffULL,
0x00000018ff647819ULL, 0x000fe40000011639ULL, 0x0000ffff39687812ULL, 0x000fc400078ec0ffULL,
0x000000ff38677812ULL, 0x040fe400078ec0ffULL, 0x00000018ff657819ULL, 0x000fe40000011638ULL,
0x0000ffff38697812ULL, 0x000fe400078ec0ffULL, 0x000000ff6b6b7812ULL, 0x000fe400078ec0ffULL,
0x000000ff436d7812ULL, 0x008fe400078ec0ffULL, 0x00000010ff397819ULL, 0x000fc40000011641ULL,
0x000000ff41497812ULL, 0x040fe400078ec0ffULL, 0x00000018ff467819ULL, 0x000fe40000011641ULL,
0x0000ffff415e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5a7819ULL, 0x100fe40000011643ULL,
0x00000018ff417819ULL, 0x000fe40000011643ULL, 0x0000ffff43597812ULL, 0x000fc400078ec0ffULL,
0x000000ff426c7812ULL, 0x000fe400078ec0ffULL, 0x0000006dff43723eULL, 0x000fe400020006ffULL,
0x000000ff6a6d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff387819ULL, 0x100fe40000011640ULL,
0x000000ff40587812ULL, 0x000fe400078ec0ffULL, 0x00000018ff477819ULL, 0x000fc40000011640ULL,
0x0000ffff40637812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5f7819ULL, 0x100fe40000011642ULL,
0x00000018ff407819ULL, 0x000fe40000011642ULL, 0x0000ffff42487812ULL, 0x000fe400078ec0ffULL,
0x0000006cff42723eULL, 0x000fe400020006ffULL, 0x00000067ff67723eULL, 0x000fc400020006ffULL,
0x00000066ff66723eULL, 0x000fe400020006ffULL, 0x0000006bff6c723eULL, 0x000fe400020006ffULL,
0x0000006dff6d723eULL, 0x000fe400020006ffULL, 0x000000ff386e7812ULL, 0x000fe400078ec0ffULL,
0x000000ff396f7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff6a7819ULL, 0x000fc40000011669ULL,
0x00000008ff687819ULL, 0x000fe40000011668ULL, 0x0000541067387816ULL, 0x000fe4000000006cULL,
0x0000541066397816ULL, 0x000fe4000000006dULL, 0x00000010ff5d7819ULL, 0x100fe4000001163aULL,
0x000000ff3a617812ULL, 0x000fe400078ec0ffULL, 0x00000018ff5c7819ULL, 0x000fc4000001163aULL,
0x00000010ff627819ULL, 0x100fe4000001163bULL, 0x000000ff3b607812ULL, 0x040fe400078ec0ffULL,
0x00000018ff5b7819ULL, 0x000fe4000001163bULL, 0x0000ffff3a3a7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff3b3b7812ULL, 0x000fe400078ec0ffULL, 0x00000065ff65723eULL, 0x000fc400020006ffULL,
0x00000064ff64723eULL, 0x000fe400020006ffULL, 0x0000006aff6a723eULL, 0x000fe400020006ffULL,
0x00000068ff6b723eULL, 0x000fe400020006ffULL, 0x000000ff5d697812ULL, 0x000fe400078ec0ffULL,
0x000000ff62687812ULL, 0x000fe400078ec0ffULL, 0x00000008ff627819ULL, 0x000fc4000001163aULL,
0x00000008ff5d7819ULL, 0x000fe4000001163bULL, 0x000000381038723cULL, 0x000fe20000001818ULL,
0x00000061ff61723eULL, 0x000fe400020006ffULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x00000069ff69723eULL, 0x000fe400020006ffULL, 0x000054106a187816ULL, 0x000fe40000000065ULL,
0x000054106b197816ULL, 0x000fc40000000064ULL, 0x00000068ff68723eULL, 0x000fe400020006ffULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x0000005bff5b723eULL, 0x000fe200020006ffULL,
0x00000018101c723cULL, 0x000fe2000000181cULL, 0x00000062ff62723eULL, 0x000fe400020006ffULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x00000058ff58723eULL, 0x000fc400020006ffULL,
0x0000541061187816ULL, 0x000fe40000000069ULL, 0x0000541060197816ULL, 0x000fe40000000068ULL,
0x00000049ff49723eULL, 0x000fe400020006ffULL, 0x0000006eff1b723eULL, 0x000fe400020006ffULL,
0x0000006fff1a723eULL, 0x000fe200020006ffULL, 0x000000181020723cULL, 0x000fe20000001820ULL,
0x00000008ff637819ULL, 0x000fc40000011663ULL, 0x00000008ff5e7819ULL, 0x000fe4000001165eULL,
0x000000ff5f647812ULL, 0x000fe400078ec0ffULL, 0x0000541062187816ULL, 0x000fe4000000005cULL,
0x000054105d197816ULL, 0x000fe4000000005bULL, 0x00000047ff47723eULL, 0x000fe400020006ffULL,
0x00000046ff46723eULL, 0x000fc400020006ffULL, 0x00000063ff63723eULL, 0x000fe200020006ffULL,
0x000000181024723cULL, 0x000fe20000001824ULL, 0x0000005eff5f723eULL, 0x000fe400020006ffULL,
0x000000ff5a5a7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff487819ULL, 0x000fe40000011648ULL,
0x0000541058187816ULL, 0x000fe4000000001bULL, 0x0000541049197816ULL, 0x000fe2000000001aULL,
0x00000001ff1a7424ULL, 0x000fe200078e00ffULL, 0x00000008ff597819ULL, 0x000fc40000011659ULL,
0x00000040ff40723eULL, 0x000fe400020006ffULL, 0x00000041ff41723eULL, 0x000fe200020006ffULL,
0x000000181028723cULL, 0x000fe20000001828ULL, 0x00000064ff5e723eULL, 0x000fe400020006ffULL,
0x0000005aff5a723eULL, 0x000fe400020006ffULL, 0x00000048ff48723eULL, 0x000fe400020006ffULL,
0x0000541063187816ULL, 0x000fc40000000047ULL, 0x000054105f197816ULL, 0x000fe40000000046ULL,
0x00000059ff49723eULL, 0x000fe400020006ffULL, 0x0000541042427816ULL, 0x000fe4000000005eULL,
0x0000541043437816ULL, 0x000fe2000000005aULL, 0x00000018102c723cULL, 0x000fe2000000182cULL,
0x0000541048487816ULL, 0x000fe40000000040ULL, 0x0000541049497816ULL, 0x000fc60000000041ULL,
0x000000421030723cULL, 0x000fe20000001830ULL, 0x0000000853187824ULL, 0x000fca00078e0202ULL,
0x000000481034723cULL, 0x000fe20000001834ULL, 0x0176c81a181879a7ULL, 0x0002e2000850003fULL,
0x0176881a45ff79a7ULL, 0x0003de000850003fULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000107805ULL, 0x000fce0000015200ULL, 0x00000019090075a7ULL, 0x008ee4000800017fULL,
0x00000000005c0947ULL, 0x008fea0003800000ULL, 0x000000ffff1a7224ULL, 0x002fce00078e00ffULL,
0x000000101a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fce0000015200ULL, 0x00000012101b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09001b00780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401b00780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011413ULL,
0x0000001b12127211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000212127819ULL, 0x000fc80000001213ULL, 0x000000120000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011a1a7836ULL, 0x000fce0000000000ULL,
0x00000019090075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00008e00ff107b82ULL, 0x000ee20000000a00ULL, 0x0000001000127824ULL, 0x000fe200078e00ffULL,
0x0000850000047ab9ULL, 0x000fe40000000800ULL, 0x0000000416167c24ULL, 0x010fe4000f8e02ffULL,
0xffffffe012137812ULL, 0x000fe400078ec0ffULL, 0x0000004016197824ULL, 0x000fc600078e00ffULL,
0x000001000a137824ULL, 0x000fc800078e0213ULL, 0x0000008013187836ULL, 0x000fca0000000000ULL,
0x0000002018137812ULL, 0x000fe200078ec0ffULL, 0x0000008019107825ULL, 0x008fc800078e0010ULL,
0x000000014a167824ULL, 0x000fe200078e0213ULL, 0x0000000000f49947ULL, 0x000fec0003800000ULL,
0x0000001012137812ULL, 0x000fe400078ec0ffULL, 0x000000187b127248ULL, 0x000fe40007fe0000ULL,
0x00000003ff197819ULL, 0x000fc60000011604ULL, 0x0000000112127824ULL, 0x000fe400078e0a18ULL,
0x00000001191b7824ULL, 0x100fe400078e0213ULL, 0x00000004191a7836ULL, 0x002fe20000000000ULL,
0x0000001213127248ULL, 0x000fe20007fe0000ULL, 0x000000011b187824ULL, 0x040fe400078e0204ULL,
0x000000081b417824ULL, 0x000fe400078e00ffULL, 0x0000000112127824ULL, 0x000fc400078e0a13ULL,
0x0000000819407836ULL, 0x000fe20000000000ULL, 0xfffffff841427812ULL, 0x000fe200078ee218ULL,
0x0000000c19417836ULL, 0x000fe20000000000ULL, 0x000000121900720cULL, 0x080fe20003f86070ULL,
0x000000011a197824ULL, 0x100fe200078e0213ULL, 0x000000124000720cULL, 0x080fe20003f46070ULL,
0x000000011b187824ULL, 0x100fe200078e0216ULL, 0x000000121a00720cULL, 0x080fe20003f66070ULL,
0x00000001401b7824ULL, 0x000fe200078e0213ULL, 0x000000124100720cULL, 0x000fe20003f06070ULL,
0x0000000119407824ULL, 0x000fc400078e0216ULL, 0x0000000141457824ULL, 0x000fe400078e0213ULL,
0x0000000119137824ULL, 0x140fe400078e0204ULL, 0x0000000819467824ULL, 0x000fe400078e00ffULL,
0x000000011b1a7824ULL, 0x040fe400078e0204ULL, 0x000000081b437824ULL, 0x000fe200078e00ffULL,
0xfffffff846467812ULL, 0x000fe200078ee213ULL, 0x0000008040407825ULL, 0x000fc600078e00ffULL,
0xfffffff843487812ULL, 0x000fe200078ee21aULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x0000004d40137212ULL, 0x000fc600078efcffULL, 0x000000011b1a7824ULL, 0x100fe200078e0216ULL,
0x0000004d18437212ULL, 0x000fe200078efcffULL, 0x0000000145127824ULL, 0x000fe200078e0216ULL,
0x0000001310407210ULL, 0x000fe20007fde0ffULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000004310187210ULL, 0x000fc60007fbe0ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000004d1a497212ULL, 0x000fc600078efcffULL, 0x0000000145167824ULL, 0x040fe200078e0204ULL,
0x0000004d12477212ULL, 0x000fe200078efcffULL, 0x0000000845457824ULL, 0x000fe400078e00ffULL,
0x0000000111197824ULL, 0x040fe400028e0619ULL, 0x0000000111417824ULL, 0x000fe200030e0641ULL,
0xfffffff845587812ULL, 0x000fe200078ee216ULL, 0x0000001042437824ULL, 0x100fe200078e0217ULL,
0x0000004910167210ULL, 0x000fe20007fbe0ffULL, 0x0000001046457824ULL, 0x100fe200078e0217ULL,
0x0000004710107210ULL, 0x000fe20007fde0ffULL, 0x0000001048477824ULL, 0x100fe200078e0217ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018437faeULL, 0x0003e2000e101c46ULL,
0x0000001058497824ULL, 0x000fc400078e0217ULL, 0x0000000111177824ULL, 0x040fe200028e061bULL,
0x0000000040457faeULL, 0x0003e2000d901c46ULL, 0x0000000111117824ULL, 0x000fc600030e0613ULL,
0x0000000016477faeULL, 0x0003e8000d101c46ULL, 0x0000000010497faeULL, 0x0003e2000c101c46ULL,
0x0000000000c07947ULL, 0x000fea0003800000ULL, 0x0000001012137812ULL, 0x000fc800078ec0ffULL,
0x0000001304137211ULL, 0x000fca00078fe8ffULL, 0x0000000113187824ULL, 0x040fe400078e0204ULL,
0x00000008131b7824ULL, 0x040fe400078e00ffULL, 0x0000000113127824ULL, 0x000fe400078e0216ULL,
0x0000000413197836ULL, 0x000fe20000000000ULL, 0xfffffff81b427812ULL, 0x000fe200078ee218ULL,
0x0000000813417836ULL, 0x000fe40000000000ULL, 0x0000000c13457836ULL, 0x002fc40000000000ULL,
0x0000008012127825ULL, 0x000fc800078e00ffULL, 0x00000001191b7824ULL, 0x040fe400078e0204ULL,
0x0000000819467824ULL, 0x000fe400078e00ffULL, 0x00000001411a7824ULL, 0x040fe400078e0216ULL,
0x0000000141437824ULL, 0x140fe400078e0204ULL, 0x0000000841487824ULL, 0x000fe400078e00ffULL,
0x0000000145417824ULL, 0x000fc400078e0204ULL, 0x0000000845587824ULL, 0x000fe400078e00ffULL,
0x0000000119407824ULL, 0x100fe200078e0216ULL, 0x0000004d12197212ULL, 0x000fe200078efcffULL,
0x0000000145187824ULL, 0x000fe200078e0216ULL, 0xfffffff846167812ULL, 0x000fe200078ee21bULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0xfffffff848467812ULL, 0x000fe400078ee243ULL,
0xfffffff858487812ULL, 0x000fe200078ee241ULL, 0x0000008040407825ULL, 0x000fe200078e00ffULL,
0x0000001910127210ULL, 0x000fc40007f1e0ffULL, 0x0000004d1a597212ULL, 0x080fe200078efcffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x0000004d405b7212ULL, 0x080fe400078efcffULL,
0x00000059101a7210ULL, 0x000fe20007f5e0ffULL, 0x0000000111137824ULL, 0x000fe200000e0613ULL,
0x0000004d18497212ULL, 0x000fe200078efcffULL, 0x0000001016457824ULL, 0x100fe200078e0217ULL,
0x0000005b10167210ULL, 0x000fe20007f1e0ffULL, 0x0000001042437824ULL, 0x100fe200078e0217ULL,
0x0000004910107210ULL, 0x000fe20007f7e0ffULL, 0x0000001046477824ULL, 0x000fc400078e0217ULL,
0x0000001048497824ULL, 0x000fe200078e0217ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012437faeULL, 0x0003e2000b901c46ULL, 0x0000000111177824ULL, 0x040fe400000e0641ULL,
0x00000001111b7824ULL, 0x040fe400010e061bULL, 0x0000000111117824ULL, 0x000fe200018e0619ULL,
0x0000000016457faeULL, 0x0003e8000b901c46ULL, 0x000000001a477faeULL, 0x0003e8000b901c46ULL,
0x0000000010497faeULL, 0x0003e4000b901c46ULL, 0x000000020c177836ULL, 0x002fe40000000000ULL,
0xffffffffff117424ULL, 0x000fc600078e00ffULL, 0x0000007c1700720cULL, 0x000fda0003f06070ULL,
0x00009000ff128b82ULL, 0x000e620000000a00ULL, 0x000000014b178824ULL, 0x000fe400078e0217ULL,
0x0000000800107824ULL, 0x000fe400078e00ffULL, 0x0000000417128825ULL, 0x002fc600078e0012ULL,
0xfffffff010177812ULL, 0x000fe400078ec0ffULL, 0x0000000612118981ULL, 0x000326000c1e1900ULL,
0x0000000102177824ULL, 0x000fe400078e0217ULL, 0x00000001ff167424ULL, 0x000fc600078e00ffULL,
0x00000000170472caULL, 0x000fe200000e0000ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000176a804047890ULL, 0x000fd2000fffe03fULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x0000000000007918ULL, 0x002fe40000000000ULL, 0x0176a816171279a7ULL, 0x0002e4000850003fULL,
0x017628160d1679a7ULL, 0x0022a4000850003fULL, 0x0000000000187805ULL, 0x000fce0000015200ULL,
0x017628170d0075a7ULL, 0x004ea4000800017fULL, 0x00000000005c0947ULL, 0x004fea0003800000ULL,
0x000000ffff407224ULL, 0x000fce00078e00ffULL, 0x000000104000780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000001a7805ULL, 0x000fce0000015200ULL,
0x0000001a18417210ULL, 0x000fca0007f1e1ffULL, 0x000000011b1b7824ULL, 0x000fe200000e0e19ULL,
0x003d09004100780cULL, 0x000fc80003f06070ULL, 0x000000ff1b00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c404100780cULL, 0x000fc80003f06070ULL,
0x000000ff1b00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff107819ULL, 0x000fc8000001141bULL, 0x0000004110107211ULL, 0x000fca00078110ffULL,
0x000000ffff1b7224ULL, 0x000fca00000e061bULL, 0x0000000210107819ULL, 0x000fc8000000121bULL,
0x000000100000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000140407836ULL, 0x000fce0000000000ULL, 0x017628170d0075a7ULL, 0x000ea4000800017fULL,
0xfffffffc00a88947ULL, 0x004fea000383ffffULL, 0x0000002000107824ULL, 0x000fe400078e00ffULL,
0x00000001ff1a7424ULL, 0x000fc600078e00ffULL, 0xffffff8010177812ULL, 0x000fc800078ec0ffULL,
0x0000008002107810ULL, 0x000fc80007ffe017ULL, 0x0000001051107210ULL, 0x000fca0007ffe04dULL,
0x0170000010177984ULL, 0x000ea80000000800ULL, 0x0172000010187984ULL, 0x000b620000000800ULL,
0x0000000e1700720bULL, 0x004fda0003f1d000ULL, 0x0000000000167806ULL, 0x000fc800000e0100ULL,
0x0000ffff161b7812ULL, 0x000fda000780c0ffULL, 0x0000000400008947ULL, 0x02afea0003800000ULL,
0x0000000150197836ULL, 0x000fe20000000000ULL, 0x0000000e1700720bULL, 0x000fc80003f14000ULL,
0x000000001900720cULL, 0x000fd20003f45270ULL, 0x00000000001a7806ULL, 0x000fc800000e0100ULL,
0x000000800016a824ULL, 0x000fe200078e0202ULL, 0x0000000e1710a209ULL, 0x000fc80007810000ULL,
0x000000165119a210ULL, 0x000fe40007ffe04dULL, 0x000099101a167816ULL, 0x000fc600000000ffULL,
0x017400101900a388ULL, 0x0003e20000000800ULL, 0x000000ff1600720cULL, 0x000fda0003f05270ULL,
0x0000000000b48947ULL, 0x002fea0003800000ULL, 0x0000000e17197209ULL, 0x000fe40007810000ULL,
0x000000ff1aff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff001aff7812ULL, 0x000fe2000784c0ffULL,
0x0000000e19107221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL,
0x0000001000167308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff197819ULL, 0x000fca0000011604ULL, 0x00001f1916107589ULL, 0x006e6400000e0000ULL,
0x0000003810387220ULL, 0x042fe20000410000ULL, 0x0000003910397220ULL, 0x040fe20000410000ULL,
0x0000001c101c7220ULL, 0x040fe20000410000ULL, 0x0000001d101d7220ULL, 0x040fe20000410000ULL,
0x0000002010207220ULL, 0x040fe20000410000ULL, 0x0000002110217220ULL, 0x040fe20000410000ULL,
0x0000002410247220ULL, 0x040fe20000410000ULL, 0x0000002510257220ULL, 0x040fe20000410000ULL,
0x0000002810287220ULL, 0x040fe20000410000ULL, 0x0000002910297220ULL, 0x040fe20000410000ULL,
0x0000002c102c7220ULL, 0x040fe20000410000ULL, 0x0000002d102d7220ULL, 0x040fe20000410000ULL,
0x0000003010307220ULL, 0x040fe20000410000ULL, 0x0000003110317220ULL, 0x040fe20000410000ULL,
0x0000003410347220ULL, 0x040fe20000410000ULL, 0x0000003510357220ULL, 0x000fce0000410000ULL,
0x000000160f0f7220ULL, 0x004fe20000410000ULL, 0x000000000048a947ULL, 0x000fec0003800000ULL,
0x0000000804197811ULL, 0x000fca00078ff0ffULL, 0x00001f1916107589ULL, 0x002e6400000e0000ULL,
0x0000003a103a7220ULL, 0x042fe20000410000ULL, 0x0000003b103b7220ULL, 0x040fe20000410000ULL,
0x0000001e101e7220ULL, 0x040fe20000410000ULL, 0x0000001f101f7220ULL, 0x040fe20000410000ULL,
0x0000002210227220ULL, 0x040fe20000410000ULL, 0x0000002310237220ULL, 0x040fe20000410000ULL,
0x0000002610267220ULL, 0x040fe20000410000ULL, 0x0000002710277220ULL, 0x040fe20000410000ULL,
0x0000002a102a7220ULL, 0x040fe20000410000ULL, 0x0000002b102b7220ULL, 0x040fe20000410000ULL,
0x0000002e102e7220ULL, 0x040fe20000410000ULL, 0x0000002f102f7220ULL, 0x040fe20000410000ULL,
0x0000003210327220ULL, 0x040fe20000410000ULL, 0x0000003310337220ULL, 0x040fe20000410000ULL,
0x0000003610367220ULL, 0x040fe20000410000ULL, 0x0000003710377220ULL, 0x000fce0000410000ULL,
0x0000ffff1bff7812ULL, 0x000fe2000780601aULL, 0x00000001ff1a7424ULL, 0x000fe200078e00ffULL,
0x0000000e170e7209ULL, 0x000fd60007810000ULL, 0x8000000e17170221ULL, 0x000fe20000010000ULL,
0x00007610ff1a0816ULL, 0x000fc6000000001aULL, 0x3fb8aa3b17170820ULL, 0x000fc80000410000ULL,
0x0000001700080308ULL, 0x000ea40000000800ULL, 0x0000000818180220ULL, 0x004fce0000410000ULL,
0x0000000f180f7221ULL, 0x000fce0000010000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000000800107824ULL, 0x002fca00078e00ffULL, 0xfffffff010197812ULL, 0x000fca00078ec0ffULL,
0x0000000102417824ULL, 0x000fc800078e0219ULL, 0x0176b015410075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff407224ULL, 0x000fce00078e00ffULL,
0x000000104000780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000187805ULL, 0x000fce0000015200ULL, 0x00000018161b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000119197824ULL, 0x000fe200000e0e17ULL, 0x003d09001b00780cULL, 0x000fc80003f06070ULL,
0x000000ff1900720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401b00780cULL, 0x000fc80003f06070ULL, 0x000000ff1900720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff107819ULL, 0x000fc80000011419ULL,
0x0000001b10107211ULL, 0x000fca00078110ffULL, 0x000000ffff197224ULL, 0x000fca00000e0619ULL,
0x0000000210107819ULL, 0x000fc80000001219ULL, 0x000000100000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000140407836ULL, 0x000fce0000000000ULL,
0x0176b015410075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000099101a107816ULL, 0x000fc800000000ffULL, 0x000000ff1000720cULL, 0x000fe20003f05270ULL,
0x0001400007107836ULL, 0x000fc80000000000ULL, 0x0000001006497824ULL, 0x000fd000078e0210ULL,
0x0000000000180947ULL, 0x000fea0003800000ULL, 0x00000002ff057819ULL, 0x000fe40000011604ULL,
0x00000008ff03723eULL, 0x000fc600000000ffULL, 0x0000000805157836ULL, 0x000fe20000000000ULL,
0x0000541003147816ULL, 0x000fca0000000003ULL, 0x00001f0514057589ULL, 0x0002a800000e0000ULL,
0x00001f1514037589ULL, 0x0002e400000e0000ULL, 0x011800003c18783bULL, 0x0002e20000000200ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x0000000518187232ULL, 0x08cfe40000000000ULL,
0x000000051a1a7232ULL, 0x000fe40000000000ULL, 0x0000000319197232ULL, 0x080fe40000000000ULL,
0x000000031b1b7232ULL, 0x000fce0000000000ULL, 0x0000001044407824ULL, 0x000fe200078e0210ULL,
0x000000004914783bULL, 0x002e6a0000004200ULL, 0x000000004040783bULL, 0x000f620000004200ULL,
0x00000010ff6a7819ULL, 0x002fe40000011614ULL, 0x00000010ff6b7819ULL, 0x000fe40000011615ULL,
0x000000ff15687812ULL, 0x000fc400078ec0ffULL, 0x00000018ff657819ULL, 0x000fe40000011615ULL,
0x0000ffff15157812ULL, 0x000fe400078ec0ffULL, 0x000000ff426c7812ULL, 0x028fe400078ec0ffULL,
0x000000ff436d7812ULL, 0x000fe400078ec0ffULL, 0x000000ff14677812ULL, 0x000fe400078ec0ffULL,
0x000000ff6a6a7812ULL, 0x000fc400078ec0ffULL, 0x000000ff6b6b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff637819ULL, 0x100fe40000011640ULL, 0x000000ff405a7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff487819ULL, 0x000fe40000011640ULL, 0x0000ffff405f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff647819ULL, 0x000fc40000011641ULL, 0x000000ff41597812ULL, 0x040fe400078ec0ffULL,
0x00000018ff467819ULL, 0x000fe40000011641ULL, 0x0000ffff415b7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff667819ULL, 0x000fe40000011614ULL, 0x0000ffff14697812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5c7819ULL, 0x000fc40000011642ULL, 0x00000018ff407819ULL, 0x000fe40000011642ULL,
0x0000ffff42457812ULL, 0x000fe400078ec0ffULL, 0x00000010ff587819ULL, 0x100fe40000011643ULL,
0x00000018ff417819ULL, 0x000fe40000011643ULL, 0x0000ffff43477812ULL, 0x000fe400078ec0ffULL,
0x00000010ff147819ULL, 0x000fc40000011616ULL, 0x0000006cff42723eULL, 0x000fe400020006ffULL,
0x0000006dff43723eULL, 0x000fe400020006ffULL, 0x00000008ff157819ULL, 0x000fe40000011615ULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x00000068ff68723eULL, 0x000fe400020006ffULL,
0x0000006aff6c723eULL, 0x000fc400020006ffULL, 0x0000006bff6d723eULL, 0x000fe400020006ffULL,
0x000000ff146a7812ULL, 0x000fe400078ec0ffULL, 0x00000015ff6e723eULL, 0x000fe400020006ffULL,
0x000000ff16617812ULL, 0x040fe400078ec0ffULL, 0x00000018ff5e7819ULL, 0x000fe40000011616ULL,
0x0000ffff16627812ULL, 0x000fc400078ec0ffULL, 0x00000008ff697819ULL, 0x000fe40000011669ULL,
0x0000541067147816ULL, 0x000fe4000000006cULL, 0x0000541068157816ULL, 0x000fe4000000006dULL,
0x00000010ff167819ULL, 0x100fe40000011617ULL, 0x000000ff17607812ULL, 0x000fe400078ec0ffULL,
0x00000018ff5d7819ULL, 0x000fc40000011617ULL, 0x0000ffff17177812ULL, 0x000fe400078ec0ffULL,
0x00000066ff66723eULL, 0x000fe400020006ffULL, 0x00000065ff65723eULL, 0x000fe400020006ffULL,
0x00000069ff69723eULL, 0x000fe400020006ffULL, 0x000000ff166b7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff6f7819ULL, 0x000fc40000011617ULL, 0x000000141814723cULL, 0x000fe20000001838ULL,
0x00000061ff61723eULL, 0x000fe400020006ffULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x0000006aff6a723eULL, 0x000fe400020006ffULL, 0x0000541069387816ULL, 0x000fe40000000066ULL,
0x000054106e397816ULL, 0x000fe40000000065ULL, 0x0000006bff6b723eULL, 0x000fc400020006ffULL,
0x00000008ff627819ULL, 0x000fe40000011662ULL, 0x0000005eff5e723eULL, 0x000fe200020006ffULL,
0x00000038181c723cULL, 0x000fe2000000181cULL, 0x0000005dff5d723eULL, 0x000fe400020006ffULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x0000006fff3a723eULL, 0x000fe400020006ffULL,
0x0000541061387816ULL, 0x000fc4000000006aULL, 0x0000541060397816ULL, 0x000fe4000000006bULL,
0x000000ff63637812ULL, 0x000fe400078ec0ffULL, 0x000000ff64647812ULL, 0x000fe400078ec0ffULL,
0x0000005aff5a723eULL, 0x000fe200020006ffULL, 0x000000381820723cULL, 0x000fe20000001820ULL,
0x00000059ff59723eULL, 0x000fe400020006ffULL, 0x00000063ff63723eULL, 0x000fc400020006ffULL,
0x00000064ff64723eULL, 0x000fe400020006ffULL, 0x0000541062387816ULL, 0x000fe4000000005eULL,
0x000054103a397816ULL, 0x000fe4000000005dULL, 0x00000008ff5f7819ULL, 0x000fe4000001165fULL,
0x00000008ff5b7819ULL, 0x000fe4000001165bULL, 0x00000048ff48723eULL, 0x000fe200020006ffULL,
0x000000381824723cULL, 0x000fe20000001824ULL, 0x00000046ff46723eULL, 0x000fc400020006ffULL,
0x0000005fff5f723eULL, 0x000fe400020006ffULL, 0x0000005bff5b723eULL, 0x000fe400020006ffULL,
0x000054105a387816ULL, 0x000fe40000000063ULL, 0x0000541059397816ULL, 0x000fe40000000064ULL,
0x000000ff5c5c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff58587812ULL, 0x000fc400078ec0ffULL,
0x00000008ff457819ULL, 0x000fe20000011645ULL, 0x000000381828723cULL, 0x000fe20000001828ULL,
0x00000008ff477819ULL, 0x000fe40000011647ULL, 0x00000040ff40723eULL, 0x000fe400020006ffULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x000054105f387816ULL, 0x000fe20000000048ULL,
0x000000103e487824ULL, 0x000fe200078e0210ULL, 0x000054105b397816ULL, 0x000fc40000000046ULL,
0x00000058ff58723eULL, 0x000fe400020006ffULL, 0x00000045ff45723eULL, 0x000fe400020006ffULL,
0x0000541042427816ULL, 0x000fe2000000005cULL, 0x00000038182c723cULL, 0x000fe2000000182cULL,
0x0000541043437816ULL, 0x000fe40000000058ULL, 0x0000541045407816ULL, 0x000fc80000000040ULL,
0x00000041ff38723eULL, 0x000fe200020006ffULL, 0x000000421830723cULL, 0x000fe20000001830ULL,
0x00000047ff41723eULL, 0x000fc800020006ffULL, 0x0000541041417816ULL, 0x000fce0000000038ULL,
0x000000401834723cULL, 0x000fe20000001834ULL, 0x011800003f18783bULL, 0x0002e20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000100947ULL, 0x000fde0003800000ULL,
0x0000000518187232ULL, 0x08cfe40000000000ULL, 0x000000051a1a7232ULL, 0x000fe40000000000ULL,
0x0000000319197232ULL, 0x080fe40000000000ULL, 0x000000031b1b7232ULL, 0x000fce0000000000ULL,
0x000000103d407824ULL, 0x000fe200078e0210ULL, 0x000000004838783bULL, 0x000f6a0000004200ULL,
0x000000004040783bULL, 0x000f640000004200ULL, 0x00000010ff6c7819ULL, 0x022fe40000011638ULL,
0x000000ff38697812ULL, 0x000fc400078ec0ffULL, 0x00000018ff647819ULL, 0x000fe40000011638ULL,
0x0000ffff386a7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff387819ULL, 0x108fe40000011640ULL,
0x000000ff40477812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6d7819ULL, 0x000fe40000011640ULL,
0x0000ffff40597812ULL, 0x000fc400078ec0ffULL, 0x00000018ff407819ULL, 0x000fe40000011641ULL,
0x00000010ff6b7819ULL, 0x100fe40000011639ULL, 0x000000ff39687812ULL, 0x040fe400078ec0ffULL,
0x00000018ff637819ULL, 0x000fe40000011639ULL, 0x0000ffff39677812ULL, 0x000fe400078ec0ffULL,
0x000000ff436e7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff5b7819ULL, 0x100fe4000001163aULL,
0x000000ff3a627812ULL, 0x040fe400078ec0ffULL, 0x00000018ff5c7819ULL, 0x000fe4000001163aULL,
0x0000ffff3a617812ULL, 0x000fe400078ec0ffULL, 0x00000010ff397819ULL, 0x000fe40000011641ULL,
0x000000ff41467812ULL, 0x000fc400078ec0ffULL, 0x0000ffff415d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5e7819ULL, 0x100fe40000011642ULL, 0x000000ff42417812ULL, 0x040fe400078ec0ffULL,
0x00000018ff3a7819ULL, 0x000fe40000011642ULL, 0x0000ffff42457812ULL, 0x000fe400078ec0ffULL,
0x00000040ff42723eULL, 0x000fc400020006ffULL, 0x0000006eff40723eULL, 0x000fe400020006ffULL,
0x000000ff6c6c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff6b6e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff657819ULL, 0x100fe4000001163bULL, 0x000000ff3b607812ULL, 0x000fe400078ec0ffULL,
0x00000018ff5a7819ULL, 0x000fc4000001163bULL, 0x0000ffff3b667812ULL, 0x000fe400078ec0ffULL,
0x00000008ff677819ULL, 0x000fe40000011667ULL, 0x00000010ff5f7819ULL, 0x100fe40000011643ULL,
0x00000018ff3b7819ULL, 0x000fe40000011643ULL, 0x0000ffff43587812ULL, 0x000fe400078ec0ffULL,
0x0000006dff43723eULL, 0x000fc400020006ffULL, 0x00000069ff69723eULL, 0x000fe400020006ffULL,
0x00000068ff68723eULL, 0x000fe400020006ffULL, 0x00000008ff6b7819ULL, 0x000fe4000001166aULL,
0x0000006cff6d723eULL, 0x000fe400020006ffULL, 0x0000006eff6e723eULL, 0x000fe400020006ffULL,
0x00000067ff6c723eULL, 0x000fc400020006ffULL, 0x000000ff5b6a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff65677812ULL, 0x000fe400078ec0ffULL, 0x00000008ff5b7819ULL, 0x000fe40000011666ULL,
0x000000ff38667812ULL, 0x000fe400078ec0ffULL, 0x000000ff39657812ULL, 0x000fe400078ec0ffULL,
0x0000541069387816ULL, 0x000fc4000000006dULL, 0x0000541068397816ULL, 0x000fe4000000006eULL,
0x00000064ff64723eULL, 0x000fe400020006ffULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x0000006bff6b723eULL, 0x000fe200020006ffULL, 0x000000381814723cULL, 0x000fe20000001814ULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x00000060ff60723eULL, 0x000fc400020006ffULL,
0x0000006aff6a723eULL, 0x000fe400020006ffULL, 0x000054106b387816ULL, 0x000fe40000000064ULL,
0x000054106c397816ULL, 0x000fe40000000063ULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x00000008ff617819ULL, 0x000fe40000011661ULL, 0x0000005cff5c723eULL, 0x000fe200020006ffULL,
0x00000038181c723cULL, 0x000fe2000000181cULL, 0x0000005aff5a723eULL, 0x000fc400020006ffULL,
0x00000061ff61723eULL, 0x000fe400020006ffULL, 0x0000005bff5b723eULL, 0x000fe400020006ffULL,
0x0000541062387816ULL, 0x000fe4000000006aULL, 0x0000541060397816ULL, 0x000fe40000000067ULL,
0x00000047ff47723eULL, 0x000fe400020006ffULL, 0x00000046ff46723eULL, 0x000fc400020006ffULL,
0x00000066ff66723eULL, 0x000fe200020006ffULL, 0x000000381820723cULL, 0x000fe20000001820ULL,
0x00000065ff65723eULL, 0x000fe400020006ffULL, 0x00000008ff597819ULL, 0x000fe40000011659ULL,
0x00000008ff5d7819ULL, 0x000fe4000001165dULL, 0x0000541061387816ULL, 0x000fe4000000005cULL,
0x000054105b397816ULL, 0x000fe2000000005aULL, 0x00000002005a7824ULL, 0x000fe200078e00ffULL,
0x000000ff5f637812ULL, 0x000fc400078ec0ffULL, 0x00000059ff59723eULL, 0x000fe400020006ffULL,
0x0000005dff5f723eULL, 0x000fe200020006ffULL, 0x000000381824723cULL, 0x000fe20000001824ULL,
0x000000ff5e5e7812ULL, 0x000fe400078ec0ffULL, 0x00000041ff41723eULL, 0x000fe400020006ffULL,
0x0000005eff5e723eULL, 0x000fe400020006ffULL, 0x0000541047387816ULL, 0x000fc40000000066ULL,
0x0000541046397816ULL, 0x000fe40000000065ULL, 0x00000063ff5d723eULL, 0x000fe400020006ffULL,
0x00000008ff457819ULL, 0x000fe40000011645ULL, 0x00000008ff587819ULL, 0x000fe20000011658ULL,
0x000000381828723cULL, 0x000fe20000001828ULL, 0x0000003aff3a723eULL, 0x000fe400020006ffULL,
0x0000003bff3b723eULL, 0x000fc400020006ffULL, 0x00000045ff45723eULL, 0x000fe400020006ffULL,
0x0000541059387816ULL, 0x000fe20000000043ULL, 0x00000001ff437424ULL, 0x000fe200078e00ffULL,
0x000054105f397816ULL, 0x000fe20000000042ULL, 0x0000000853427824ULL, 0x000fe200078e0202ULL,
0x00000058ff58723eULL, 0x000fe400020006ffULL, 0xfffffff85a477812ULL, 0x000fe400078ec0ffULL,
0x00005410453a7816ULL, 0x000fe2000000003aULL, 0x00000038182c723cULL, 0x000fe2000000182cULL,
0x00005410583b7816ULL, 0x000fe2000000003bULL, 0x0000000102477824ULL, 0x000fca00078e0247ULL,
0x0000541041387816ULL, 0x000fe2000000005eULL, 0x0000003a1834723cULL, 0x000fe20000001834ULL,
0x0000541040397816ULL, 0x000fce000000005dULL, 0x000000381830723cULL, 0x000fe20000001830ULL,
0x0176c843423879a7ULL, 0x0002e2000850003fULL, 0x0176904347ff79a7ULL, 0x0003de000850003fULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000187805ULL, 0x000fce0000015200ULL,
0x00000039090075a7ULL, 0x008ee4000800017fULL, 0x00000000005c0947ULL, 0x008fea0003800000ULL,
0x000000ffff3a7224ULL, 0x000fce00078e00ffULL, 0x000000103a00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000001a7805ULL, 0x000fce0000015200ULL,
0x0000001a183b7210ULL, 0x000fca0007f1e1ffULL, 0x000000011b1b7824ULL, 0x000fe200000e0e19ULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff1b00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff1b00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff1a7819ULL, 0x000fc8000001141bULL, 0x0000003b1a1a7211ULL, 0x000fca00078110ffULL,
0x000000ffff1b7224ULL, 0x000fca00000e061bULL, 0x000000021a1a7819ULL, 0x000fc8000000121bULL,
0x0000001a0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013a3a7836ULL, 0x000fce0000000000ULL, 0x00000039090075a7ULL, 0x000ee4000800017fULL,
0xfffffffc00a88947ULL, 0x008fea000383ffffULL, 0x00008e00ff187b82ULL, 0x000ee20000000a00ULL,
0x00000010001a7824ULL, 0x000fe200078e00ffULL, 0x0000850000047ab9ULL, 0x000fe40000000800ULL,
0x0000000411117c24ULL, 0x010fe4000f8e02ffULL, 0xffffffe01a1b7812ULL, 0x000fca00078ec0ffULL,
0x000001000a1b7824ULL, 0x000fc800078e021bULL, 0x000000c01b387836ULL, 0x000fe40000000000ULL,
0x00000040111b7824ULL, 0x000fc600078e00ffULL, 0x0000002038117812ULL, 0x000fe200078ec0ffULL,
0x000000801b187825ULL, 0x008fc800078e0018ULL, 0x000000014a117824ULL, 0x000fe200078e0211ULL,
0x0000000000f49947ULL, 0x000fec0003800000ULL, 0x000000101a397812ULL, 0x000fe400078ec0ffULL,
0x000000387b1a7248ULL, 0x000fe40007fe0000ULL, 0x00000003ff1b7819ULL, 0x000fc60000011604ULL,
0x000000011a1a7824ULL, 0x000fe400078e0a38ULL, 0x000000011b387824ULL, 0x100fe400078e0239ULL,
0x000000041b3b7836ULL, 0x000fe20000000000ULL, 0x0000001a391a7248ULL, 0x000fe20007fe0000ULL,
0x00000001383a7824ULL, 0x040fe400078e0204ULL, 0x0000000838457824ULL, 0x000fe400078e00ffULL,
0x000000011a1a7824ULL, 0x000fc400078e0a39ULL, 0x0000000c1b407836ULL, 0x000fe20000000000ULL,
0xfffffff845457812ULL, 0x000fe200078ee23aULL, 0x000000081b3a7836ULL, 0x000fe20000000000ULL,
0x0000001a1b00720cULL, 0x080fe20003f86070ULL, 0x00000001381b7824ULL, 0x000fe200078e0211ULL,
0x0000001a3b00720cULL, 0x0c0fe20003f66070ULL, 0x000000013b3b7824ULL, 0x100fe200078e0239ULL,
0x0000001a3a00720cULL, 0x080fe20003f46070ULL, 0x0000000140427824ULL, 0x042fe200078e0239ULL,
0x0000001a4000720cULL, 0x000fe20003f06070ULL, 0x000000801b1a7825ULL, 0x000fc800078e00ffULL,
0x000000013b387824ULL, 0x140fe400078e0204ULL, 0x000000083b477824ULL, 0x040fe400078e00ffULL,
0x000000013b407824ULL, 0x000fe400078e0211ULL, 0x000000013a3a7824ULL, 0x000fe200078e0239ULL,
0x0000004d1a397212ULL, 0x000fe200078efcffULL, 0x0000008040407825ULL, 0x000fe200078e00ffULL,
0xfffffff847477812ULL, 0x000fe400078ee238ULL, 0x00000039181a7210ULL, 0x000fe20007fbe0ffULL,
0x000000013a3b7824ULL, 0x000fc400078e0204ULL, 0x000000083a467824ULL, 0x040fe400078e00ffULL,
0x000000013a387824ULL, 0x100fe400078e0211ULL, 0x00000001423a7824ULL, 0x000fe200078e0211ULL,
0x0000004d40117212ULL, 0x000fe200078efcffULL, 0x0000008038387825ULL, 0x000fe200078e00ffULL,
0xfffffff846597812ULL, 0x000fc600078ee23bULL, 0x000000803a3a7825ULL, 0x000fe200078e00ffULL,
0x0000004d38437212ULL, 0x000fc600078efcffULL, 0x00000001191b7824ULL, 0x040fe200028e061bULL,
0x0000001118407210ULL, 0x000fe20007fbe0ffULL, 0x0000000142467824ULL, 0x000fe200078e0204ULL,
0x0000004d3a117212ULL, 0x000fe200078efcffULL, 0x00000008425b7824ULL, 0x000fe400078e00ffULL,
0x0000000119417824ULL, 0x000fe200028e0641ULL, 0x0000004318387210ULL, 0x000fe20007fbe0ffULL,
0x0000001045457824ULL, 0x100fe200078e0210ULL, 0x0000001118187210ULL, 0x000fe20007fde0ffULL,
0x0000001047477824ULL, 0x100fe200078e0210ULL, 0xfffffff85b117812ULL, 0x000fe200078ee246ULL,
0x0000000119397824ULL, 0x000fe200028e0639ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a457faeULL, 0x0003e2000e101c46ULL, 0x0000001059597824ULL, 0x000fc400078e0210ULL,
0x0000000119197824ULL, 0x000fe200030e063bULL, 0x0000000040477faeULL, 0x0003e2000d901c46ULL,
0x0000001011117824ULL, 0x000fc600078e0210ULL, 0x0000000038597faeULL, 0x0003e8000d101c46ULL,
0x0000000018117faeULL, 0x0003e2000c101c46ULL, 0x0000000000c07947ULL, 0x000fea0003800000ULL,
0x000000101a1b7812ULL, 0x000fc800078ec0ffULL, 0x0000001b041b7211ULL, 0x000fca00078fe8ffULL,
0x000000081b397836ULL, 0x000fe40000000000ULL, 0x000000041b407836ULL, 0x000fe40000000000ULL,
0x00000001393b7824ULL, 0x140fe400078e0204ULL, 0x0000000839427824ULL, 0x002fe400078e00ffULL,
0x000000011b1a7824ULL, 0x040fe400078e0204ULL, 0x000000081b477824ULL, 0x040fe200078e00ffULL,
0xfffffff8425b7812ULL, 0x000fe200078ee23bULL, 0x000000011b3a7824ULL, 0x000fc400078e0211ULL,
0x0000000140387824ULL, 0x040fe200078e0204ULL, 0xfffffff847477812ULL, 0x000fe200078ee21aULL,
0x0000000840597824ULL, 0x000fe400078e00ffULL, 0x0000000c1b1b7836ULL, 0x000fe40000000000ULL,
0x000000803a3a7825ULL, 0x000fe200078e00ffULL, 0xfffffff859597812ULL, 0x000fc600078ee238ULL,
0x0000000140407824ULL, 0x100fe400078e0211ULL, 0x00000001391a7824ULL, 0x100fe400078e0211ULL,
0x000000011b387824ULL, 0x040fe200078e0211ULL, 0x0000004d3a117212ULL, 0x000fe200078efcffULL,
0x000000011b427824ULL, 0x040fe400078e0204ULL, 0x000000081b5d7824ULL, 0x000fe200078e00ffULL,
0x00000011183a7210ULL, 0x000fe20007f1e0ffULL, 0x0000008040407825ULL, 0x000fc600078e00ffULL,
0xfffffff85d5d7812ULL, 0x000fe200078ee242ULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000004d40457212ULL, 0x000fc600078efcffULL, 0x0000008038387825ULL, 0x000fe200078e00ffULL,
0x0000004d1a437212ULL, 0x080fe400078efcffULL, 0x0000004518407210ULL, 0x000fe20007f5e0ffULL,
0x00000001193b7824ULL, 0x000fe200000e063bULL, 0x0000004d38117212ULL, 0x000fe200078efcffULL,
0x0000001047477824ULL, 0x100fe200078e0210ULL, 0x00000043181a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000119417824ULL, 0x000fe200010e0641ULL, 0x0000001118187210ULL, 0x000fe20007f7e0ffULL,
0x0000001059597824ULL, 0x000fe200078e0210ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a477faeULL, 0x0003e2000b901c46ULL, 0x00000001191b7824ULL, 0x000fc400000e061bULL,
0x000000105b5b7824ULL, 0x100fe200078e0210ULL, 0x0000000040597faeULL, 0x0003e2000b901c46ULL,
0x0000000119197824ULL, 0x000fe400018e0639ULL, 0x000000105d5d7824ULL, 0x000fe200078e0210ULL,
0x000000001a5b7faeULL, 0x0003e8000b901c46ULL, 0x00000000185d7faeULL, 0x0003e4000b901c46ULL,
0x000000030c1b7836ULL, 0x002fe40000000000ULL, 0xffffffffff117424ULL, 0x000fc600078e00ffULL,
0x0000007c1b00720cULL, 0x000fda0003f06070ULL, 0x00009000ff188b82ULL, 0x000e620000000a00ULL,
0x000000014b1b8824ULL, 0x000fe400078e021bULL, 0x00000008001a7824ULL, 0x000fe400078e00ffULL,
0x000000041b188825ULL, 0x002fc600078e0018ULL, 0xfffffff01a1b7812ULL, 0x000fe400078ec0ffULL,
0x0000000618118981ULL, 0x000326000c1e1900ULL, 0x00000001021b7824ULL, 0x000fe400078e021bULL,
0x00000001ff1a7424ULL, 0x000fc600078e00ffULL, 0x000000001b0472caULL, 0x000fe200000e0000ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000176b004047890ULL, 0x000fd2000fffe03fULL,
0x00000000ff0079b0ULL, 0x000fe20008000a44ULL, 0x0000000000007918ULL, 0x002fe40000000000ULL,
0x0176b01a1b1879a7ULL, 0x0002e4000850003fULL, 0x0176481a0d1a79a7ULL, 0x0022a4000850003fULL,
0x0000000000387805ULL, 0x000fce0000015200ULL, 0x0176481b0d0075a7ULL, 0x004ea4000800017fULL,
0x00000000005c0947ULL, 0x004fea0003800000ULL, 0x000000ffff407224ULL, 0x000fce00078e00ffULL,
0x000000104000780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fce0000015200ULL, 0x0000003a38417210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09004100780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c404100780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x000000413a3a7211ULL, 0x000fca00078110ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000140407836ULL, 0x000fce0000000000ULL,
0x0176481b0d0075a7ULL, 0x000ea4000800017fULL, 0xfffffffc00a88947ULL, 0x004fea000383ffffULL,
0x00000020000d7824ULL, 0x002fe400078e00ffULL, 0x00000001ff3a7424ULL, 0x000fc600078e00ffULL,
0xffffff800d0d7812ULL, 0x000fc800078ec0ffULL, 0x00000100021a7810ULL, 0x000fc80007ffe00dULL,
0x0000001a511a7210ULL, 0x000fca0007ffe04dULL, 0x017000001a1b7984ULL, 0x000e680000000800ULL,
0x017200001a387984ULL, 0x0004a20000000800ULL, 0x0000000e1b00720bULL, 0x002fda0003f1d000ULL,
0x00000000000d7806ULL, 0x000fc800000e0100ULL, 0x0000ffff0d397812ULL, 0x000fe2000780c0ffULL,
0x000000ffff0d7224ULL, 0x000fd800078e000eULL, 0x0000000400008947ULL, 0x00cfea0003800000ULL,
0x00000002500d7836ULL, 0x000fe20000000000ULL, 0x0000000e1b00720bULL, 0x000fc80003f14000ULL,
0x000000000d00720cULL, 0x000fd20003f45270ULL, 0x00000000003a7806ULL, 0x000fc800000e0100ULL,
0x00000080001aa824ULL, 0x000fe200078e0202ULL, 0x0000000e1b0da209ULL, 0x000fc80007810000ULL,
0x0000001a5140a210ULL, 0x000fe40007ffe04dULL, 0x000099103a1a7816ULL, 0x000fc600000000ffULL,
0x0174000d4000a388ULL, 0x0003e20000000800ULL, 0x000000ff1a00720cULL, 0x000fda0003f05270ULL,
0x0000000000b48947ULL, 0x002fea0003800000ULL, 0x0000000e1b0d7209ULL, 0x000fe40007810000ULL,
0x000000ff3aff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff003aff7812ULL, 0x000fe2000784c0ffULL,
0x0000000e0d0d7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b0d0d7820ULL, 0x000fc80000410000ULL,
0x0000000d001a7308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff0d7819ULL, 0x002fcc0000011604ULL, 0x00001f0d1a0d7589ULL, 0x004e6400000e0000ULL,
0x000000140d147220ULL, 0x042fe20000410000ULL, 0x000000150d157220ULL, 0x040fe20000410000ULL,
0x0000001c0d1c7220ULL, 0x040fe20000410000ULL, 0x0000001d0d1d7220ULL, 0x040fe20000410000ULL,
0x000000200d207220ULL, 0x040fe20000410000ULL, 0x000000210d217220ULL, 0x040fe20000410000ULL,
0x000000240d247220ULL, 0x040fe20000410000ULL, 0x000000250d257220ULL, 0x040fe20000410000ULL,
0x000000280d287220ULL, 0x040fe20000410000ULL, 0x000000290d297220ULL, 0x040fe20000410000ULL,
0x0000002c0d2c7220ULL, 0x040fe20000410000ULL, 0x0000002d0d2d7220ULL, 0x040fe20000410000ULL,
0x000000300d307220ULL, 0x040fe20000410000ULL, 0x000000310d317220ULL, 0x040fe20000410000ULL,
0x000000340d347220ULL, 0x040fe20000410000ULL, 0x000000350d357220ULL, 0x000fce0000410000ULL,
0x0000001a0f0f7220ULL, 0x004fe20000410000ULL, 0x000000000048a947ULL, 0x000fec0003800000ULL,
0x00000008040d7811ULL, 0x002fcc00078ff0ffULL, 0x00001f0d1a0d7589ULL, 0x000e6400000e0000ULL,
0x000000160d167220ULL, 0x042fe20000410000ULL, 0x000000170d177220ULL, 0x040fe20000410000ULL,
0x0000001e0d1e7220ULL, 0x040fe20000410000ULL, 0x0000001f0d1f7220ULL, 0x040fe20000410000ULL,
0x000000220d227220ULL, 0x040fe20000410000ULL, 0x000000230d237220ULL, 0x040fe20000410000ULL,
0x000000260d267220ULL, 0x040fe20000410000ULL, 0x000000270d277220ULL, 0x040fe20000410000ULL,
0x0000002a0d2a7220ULL, 0x040fe20000410000ULL, 0x0000002b0d2b7220ULL, 0x040fe20000410000ULL,
0x0000002e0d2e7220ULL, 0x040fe20000410000ULL, 0x0000002f0d2f7220ULL, 0x040fe20000410000ULL,
0x000000320d327220ULL, 0x040fe20000410000ULL, 0x000000330d337220ULL, 0x040fe20000410000ULL,
0x000000360d367220ULL, 0x040fe20000410000ULL, 0x000000370d377220ULL, 0x000fce0000410000ULL,
0x0000ffff39ff7812ULL, 0x000fe2000780603aULL, 0x00000001ff3a7424ULL, 0x000fe200078e00ffULL,
0x0000000e1b0d7209ULL, 0x002fd60007810000ULL, 0x8000000d1b1b0221ULL, 0x000fe20000010000ULL,
0x00007610ff3a0816ULL, 0x000fc6000000003aULL, 0x3fb8aa3b1b1b0820ULL, 0x000fc80000410000ULL,
0x0000001b00080308ULL, 0x000e640000000800ULL, 0x0000000838380220ULL, 0x002fce0000410000ULL,
0x0000000f380f7221ULL, 0x000fce0000010000ULL, 0x00000000001a7805ULL, 0x000fce0000015200ULL,
0x00000008000e7824ULL, 0x000fca00078e00ffULL, 0xfffffff00e397812ULL, 0x000fca00078ec0ffULL,
0x0000000102417824ULL, 0x000fc800078e0239ULL, 0x0176a813410075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff407224ULL, 0x000fce00078e00ffULL,
0x000000104000780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fce0000015200ULL, 0x000000381a3b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000139397824ULL, 0x000fe200000e0e1bULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff0e7819ULL, 0x000fc80000011439ULL,
0x0000003b0e0e7211ULL, 0x000fca00078110ffULL, 0x000000ffff397224ULL, 0x000fca00000e0639ULL,
0x000000020e0e7819ULL, 0x000fc80000001239ULL, 0x0000000e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000140407836ULL, 0x000fce0000000000ULL,
0x0176a813410075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000099103a0e7816ULL, 0x000fe200000000ffULL, 0x0001300007077836ULL, 0x000fc60000000000ULL,
0x000000ff0e00720cULL, 0x000fe20003f05270ULL, 0x0000001006407824ULL, 0x000fd800078e0207ULL,
0x0000000000180947ULL, 0x000fea0003800000ULL, 0x00000002ff057819ULL, 0x000fe40000011604ULL,
0x00000008ff03723eULL, 0x000fc600000000ffULL, 0x0000000805137836ULL, 0x000fe20000000000ULL,
0x0000541003067816ULL, 0x000fca0000000003ULL, 0x00001f0506057589ULL, 0x0002a800000e0000ULL,
0x00001f1306037589ULL, 0x0002e400000e0000ULL, 0x012000003c38783bULL, 0x0002e20000000200ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x0000000538387232ULL, 0x08cfe40000000000ULL,
0x000000053a3a7232ULL, 0x000fe40000000000ULL, 0x0000000339397232ULL, 0x080fe40000000000ULL,
0x000000033b3b7232ULL, 0x000fce0000000000ULL, 0x0000001044447824ULL, 0x000fe200078e0207ULL,
0x000000004040783bULL, 0x000f6a0000004200ULL, 0x000000004444783bULL, 0x000f640000004200ULL,
0x00000010ff667819ULL, 0x022fe40000011640ULL, 0x00000010ff677819ULL, 0x000fc40000011641ULL,
0x0000ffff41617812ULL, 0x040fe400078ec0ffULL, 0x0000ffff42627812ULL, 0x000fe400078ec0ffULL,
0x0000ffff40067812ULL, 0x040fe400078ec0ffULL, 0x00000010ff137819ULL, 0x000fe40000011642ULL,
0x000000ff40657812ULL, 0x000fe400078ec0ffULL, 0x000000ff41647812ULL, 0x000fc400078ec0ffULL,
0x00000018ff687819ULL, 0x008fe40000011646ULL, 0x000000ff66667812ULL, 0x000fe400078ec0ffULL,
0x000000ff67697812ULL, 0x000fe400078ec0ffULL, 0x00000008ff617819ULL, 0x000fe40000011661ULL,
0x00000010ff637819ULL, 0x000fe40000011643ULL, 0x00000008ff6a7819ULL, 0x000fc40000011662ULL,
0x0000ffff43127812ULL, 0x000fe400078ec0ffULL, 0x00000008ff677819ULL, 0x000fe40000011606ULL,
0x000000ff13137812ULL, 0x000fe400078ec0ffULL, 0x00000065ff65723eULL, 0x000fe400020006ffULL,
0x00000064ff64723eULL, 0x000fe400020006ffULL, 0x00000068ff06723eULL, 0x000fc400020006ffULL,
0x00000066ff66723eULL, 0x000fe400020006ffULL, 0x00000069ff69723eULL, 0x000fe400020006ffULL,
0x00000061ff68723eULL, 0x000fe400020006ffULL, 0x000000ff636b7812ULL, 0x000fe400078ec0ffULL,
0x0000006aff61723eULL, 0x000fe400020006ffULL, 0x00000013ff63723eULL, 0x000fc400020006ffULL,
0x00000008ff6a7819ULL, 0x000fe40000011612ULL, 0x00000018ff5f7819ULL, 0x000fe40000011640ULL,
0x00000018ff607819ULL, 0x000fe40000011641ULL, 0x0000541065127816ULL, 0x000fe40000000066ULL,
0x0000541064137816ULL, 0x000fe40000000069ULL, 0x0000005fff5f723eULL, 0x000fc400020006ffULL,
0x00000060ff60723eULL, 0x000fe400020006ffULL, 0x00000067ff67723eULL, 0x000fe200020006ffULL,
0x000000123814723cULL, 0x000fe20000001814ULL, 0x000000ff425c7812ULL, 0x000fe400078ec0ffULL,
0x000000ff435b7812ULL, 0x000fe400078ec0ffULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x0000541067127816ULL, 0x000fc4000000005fULL, 0x0000541068137816ULL, 0x000fe40000000060ULL,
0x0000005bff5b723eULL, 0x000fe400020006ffULL, 0x0000006bff62723eULL, 0x000fe400020006ffULL,
0x00000018ff597819ULL, 0x000fe20000011642ULL, 0x00000012381c723cULL, 0x000fe2000000181cULL,
0x00000018ff587819ULL, 0x000fe40000011643ULL, 0x00000010ff5d7819ULL, 0x000fc40000011644ULL,
0x00000010ff5e7819ULL, 0x000fe40000011645ULL, 0x000054105c127816ULL, 0x000fe40000000063ULL,
0x000054105b137816ULL, 0x000fe40000000062ULL, 0x00000059ff59723eULL, 0x000fe400020006ffULL,
0x00000058ff58723eULL, 0x000fe400020006ffULL, 0x0000006aff6a723eULL, 0x000fe200020006ffULL,
0x000000123820723cULL, 0x000fe20000001820ULL, 0x000000ff44437812ULL, 0x000fc400078ec0ffULL,
0x000000ff45427812ULL, 0x000fe400078ec0ffULL, 0x000000ff5d5d7812ULL, 0x000fe400078ec0ffULL,
0x000000ff5e5e7812ULL, 0x000fe400078ec0ffULL, 0x0000541061127816ULL, 0x000fe40000000059ULL,
0x000054106a137816ULL, 0x000fe40000000058ULL, 0x00000018ff3c7819ULL, 0x000fc40000011644ULL,
0x0000ffff445a7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff407819ULL, 0x000fe20000011645ULL,
0x000000123824723cULL, 0x000fe20000001824ULL, 0x0000ffff45457812ULL, 0x000fe400078ec0ffULL,
0x00000010ff447819ULL, 0x000fe40000011646ULL, 0x000000ff461a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff417819ULL, 0x000fc40000011647ULL, 0x000000ff471b7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff0e7819ULL, 0x000fe40000011647ULL, 0x00000043ff43723eULL, 0x000fe400020006ffULL,
0x00000042ff42723eULL, 0x000fe400020006ffULL, 0x0000005dff5d723eULL, 0x000fe400020006ffULL,
0x0000005eff5e723eULL, 0x000fc400020006ffULL, 0x0000ffff46467812ULL, 0x000fe400078ec0ffULL,
0x0000ffff47477812ULL, 0x000fe400078ec0ffULL, 0x00000008ff5a7819ULL, 0x000fe4000001165aULL,
0x00000008ff457819ULL, 0x000fe40000011645ULL, 0x000000ff44447812ULL, 0x000fe400078ec0ffULL,
0x000000ff41417812ULL, 0x000fc400078ec0ffULL, 0x0000541043127816ULL, 0x000fe4000000005dULL,
0x0000541042137816ULL, 0x000fe4000000005eULL, 0x00000008ff467819ULL, 0x000fe40000011646ULL,
0x00000008ff477819ULL, 0x000fe40000011647ULL, 0x0000003cff3c723eULL, 0x000fe200020006ffULL,
0x000000123828723cULL, 0x000fe20000001828ULL, 0x00000040ff40723eULL, 0x000fc400020006ffULL,
0x0000001aff1a723eULL, 0x000fe400020006ffULL, 0x0000001bff1b723eULL, 0x000fe400020006ffULL,
0x0000005aff5a723eULL, 0x000fe400020006ffULL, 0x00000045ff45723eULL, 0x000fe400020006ffULL,
0x00000044ff44723eULL, 0x000fe400020006ffULL, 0x00000041ff41723eULL, 0x000fc400020006ffULL,
0x0000000eff0e723eULL, 0x000fe400020006ffULL, 0x00000046ff46723eULL, 0x000fe400020006ffULL,
0x00000047ff47723eULL, 0x000fe400020006ffULL, 0x000054105a127816ULL, 0x000fe4000000003cULL,
0x0000541045137816ULL, 0x000fe20000000040ULL, 0x000000103e407824ULL, 0x000fe200078e0207ULL,
0x000054101a1a7816ULL, 0x000fc40000000044ULL, 0x000054101b1b7816ULL, 0x000fe40000000041ULL,
0x0000541046467816ULL, 0x000fe20000000006ULL, 0x00000012382c723cULL, 0x000fe2000000182cULL,
0x0000541047477816ULL, 0x000fca000000000eULL, 0x0000001a3830723cULL, 0x000fec0000001830ULL,
0x000000463838723cULL, 0x000fe20000001834ULL, 0x012000003f34783bULL, 0x0002e20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000100947ULL, 0x000fde0003800000ULL,
0x0000000534347232ULL, 0x08cfe40000000000ULL, 0x0000000536367232ULL, 0x000fe40000000000ULL,
0x0000000335357232ULL, 0x080fe40000000000ULL, 0x0000000337377232ULL, 0x000fce0000000000ULL,
0x000000103d3d7824ULL, 0x000fe200078e0207ULL, 0x000000004040783bULL, 0x000f6a0000004200ULL,
0x000000003d3c783bULL, 0x002e620000004200ULL, 0x00000010ff657819ULL, 0x020fe40000011640ULL,
0x00000010ff647819ULL, 0x000fe40000011641ULL, 0x00000018ff067819ULL, 0x000fc40000011642ULL,
0x000000ff3d1b7812ULL, 0x002fe400078ec0ffULL, 0x00000010ff5b7819ULL, 0x000fe40000011642ULL,
0x000000ff3e677812ULL, 0x000fe400078ec0ffULL, 0x00000018ff667819ULL, 0x000fe4000001163eULL,
0x000000ff41607812ULL, 0x000fe400078ec0ffULL, 0x00000018ff5a7819ULL, 0x000fc40000011641ULL,
0x0000ffff41637812ULL, 0x000fe400078ec0ffULL, 0x000000ff42587812ULL, 0x040fe400078ec0ffULL,
0x0000ffff425e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5d7819ULL, 0x000fe40000011643ULL,
0x0000ffff435f7812ULL, 0x040fe400078ec0ffULL, 0x000000ff43477812ULL, 0x000fc400078ec0ffULL,
0x00000018ff427819ULL, 0x000fe40000011643ULL, 0x00000010ff467819ULL, 0x100fe4000001163fULL,
0x000000ff3f697812ULL, 0x040fe400078ec0ffULL, 0x00000018ff687819ULL, 0x000fe4000001163fULL,
0x0000ffff3f417812ULL, 0x000fe400078ec0ffULL, 0x000000ff40617812ULL, 0x000fc400078ec0ffULL,
0x00000006ff43723eULL, 0x000fe400020006ffULL, 0x0000001bff3f723eULL, 0x000fe400020006ffULL,
0x000000ff65657812ULL, 0x000fe400078ec0ffULL, 0x000000ff64647812ULL, 0x000fe400078ec0ffULL,
0x00000067ff1b723eULL, 0x000fe400020006ffULL, 0x00000066ff06723eULL, 0x000fc400020006ffULL,
0x000000ff5b5b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff5d667812ULL, 0x000fe400078ec0ffULL,
0x00000008ff677819ULL, 0x000fe4000001165fULL, 0x00000010ff127819ULL, 0x000fe4000001163cULL,
0x00000010ff137819ULL, 0x000fe4000001163dULL, 0x0000ffff40627812ULL, 0x000fc400078ec0ffULL,
0x00000061ff61723eULL, 0x000fe400020006ffULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x00000065ff65723eULL, 0x000fe400020006ffULL, 0x00000064ff64723eULL, 0x000fe400020006ffULL,
0x00000008ff5d7819ULL, 0x000fe4000001165eULL, 0x0000005bff5e723eULL, 0x000fc400020006ffULL,
0x00000066ff5f723eULL, 0x000fe400020006ffULL, 0x00000067ff5b723eULL, 0x000fe400020006ffULL,
0x000000ff12667812ULL, 0x000fe400078ec0ffULL, 0x000000ff13677812ULL, 0x000fe400078ec0ffULL,
0x00000018ff597819ULL, 0x000fe40000011640ULL, 0x00000008ff627819ULL, 0x000fc40000011662ULL,
0x00000008ff637819ULL, 0x000fe40000011663ULL, 0x0000541061127816ULL, 0x000fe40000000065ULL,
0x0000541060137816ULL, 0x000fe40000000064ULL, 0x00000059ff59723eULL, 0x000fe400020006ffULL,
0x0000005aff5a723eULL, 0x000fe400020006ffULL, 0x00000062ff62723eULL, 0x000fe200020006ffULL,
0x000000123414723cULL, 0x008fe20000001814ULL, 0x00000063ff63723eULL, 0x000fc400020006ffULL,
0x00000058ff58723eULL, 0x000fe400020006ffULL, 0x00000047ff47723eULL, 0x000fe400020006ffULL,
0x0000541062127816ULL, 0x000fe40000000059ULL, 0x0000541063137816ULL, 0x000fe4000000005aULL,
0x00000042ff42723eULL, 0x000fe400020006ffULL, 0x0000005dff5d723eULL, 0x000fc400020006ffULL,
0x000000ff3c407812ULL, 0x000fe200078ec0ffULL, 0x00000012341c723cULL, 0x000fe2000000181cULL,
0x00000010ff457819ULL, 0x000fe4000001163eULL, 0x0000ffff3d447812ULL, 0x000fe400078ec0ffULL,
0x0000ffff3e3e7812ULL, 0x000fe400078ec0ffULL, 0x0000541058127816ULL, 0x000fe4000000005eULL,
0x0000541047137816ULL, 0x000fc4000000005fULL, 0x00000040ff40723eULL, 0x000fe400020006ffULL,
0x00000066ff60723eULL, 0x000fe400020006ffULL, 0x00000067ff61723eULL, 0x000fe200020006ffULL,
0x000000123420723cULL, 0x000fe20000001820ULL, 0x00000018ff1a7819ULL, 0x000fe4000001163dULL,
0x00000008ff447819ULL, 0x000fe40000011644ULL, 0x0000ffff3c5c7812ULL, 0x000fc400078ec0ffULL,
0x000054105d127816ULL, 0x000fe40000000043ULL, 0x000054105b137816ULL, 0x000fe40000000042ULL,
0x000054103f3f7816ULL, 0x000fe40000000061ULL, 0x000000ff45457812ULL, 0x000fe400078ec0ffULL,
0x000000ff46467812ULL, 0x000fe200078ec0ffULL, 0x000000123424723cULL, 0x000fe20000001824ULL,
0x0000001aff3d723eULL, 0x000fc400020006ffULL, 0x00000044ff44723eULL, 0x000fe400020006ffULL,
0x00000018ff0e7819ULL, 0x000fe4000001163cULL, 0x0000000200137824ULL, 0x000fe200078e00ffULL,
0x00000008ff127819ULL, 0x000fe4000001163eULL, 0x00005410403e7816ULL, 0x000fe20000000060ULL,
0x00000001ff407424ULL, 0x000fe200078e00ffULL, 0xfffffff813137812ULL, 0x000fe400078ec0ffULL,
0x00000008ff5c7819ULL, 0x000fc4000001165cULL, 0x00000069ff1a723eULL, 0x000fe200020006ffULL,
0x0000003e3428723cULL, 0x000fe20000001828ULL, 0x00000045ff45723eULL, 0x000fe400020006ffULL,
0x00000046ff46723eULL, 0x000fe400020006ffULL, 0x00000008ff417819ULL, 0x000fe40000011641ULL,
0x00005410445d7816ULL, 0x000fe2000000003dULL, 0x00000001023d7824ULL, 0x000fe200078e0213ULL,
0x0000000eff3c723eULL, 0x000fc400020006ffULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x00000012ff3e723eULL, 0x000fe400020006ffULL, 0x00000068ff0e723eULL, 0x000fe400020006ffULL,
0x00000041ff3f723eULL, 0x000fe400020006ffULL, 0x000054101b127816ULL, 0x000fe40000000045ULL,
0x000054101a137816ULL, 0x000fc40000000046ULL, 0x000054105c5c7816ULL, 0x000fe2000000003cULL,
0x00000008533c7824ULL, 0x000fe200078e0202ULL, 0x000054103e3e7816ULL, 0x000fe40000000006ULL,
0x000054103f3f7816ULL, 0x000fe2000000000eULL, 0x000000123430723cULL, 0x000fe20000001830ULL,
0x0176c8403c1279a7ULL, 0x0002ea000850003fULL, 0x0000005c342c723cULL, 0x000fe2000000182cULL,
0x017698403dff79a7ULL, 0x0003ea000850003fULL, 0x0000003e3434723cULL, 0x000fde0000001838ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x00000000001a7805ULL, 0x000fce0000015200ULL,
0x00000013090075a7ULL, 0x008ee4000800017fULL, 0x00000000005c0947ULL, 0x008fea0003800000ULL,
0x000000ffff0e7224ULL, 0x000fce00078e00ffULL, 0x000000100e00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fce0000015200ULL,
0x000000381a3b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000139397824ULL, 0x000fe200000e0e1bULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011439ULL, 0x0000003b06067211ULL, 0x000fca00078110ffULL,
0x000000ffff397224ULL, 0x000fca00000e0639ULL, 0x0000000206067819ULL, 0x000fc80000001239ULL,
0x000000060000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000010e0e7836ULL, 0x000fce0000000000ULL, 0x00000013090075a7ULL, 0x000ee4000800017fULL,
0xfffffffc00a88947ULL, 0x008fea000383ffffULL, 0x000000010a0e7836ULL, 0x000fe40000000000ULL,
0x000000030c0c7836ULL, 0x000fc60000000000ULL, 0x0000007d0e00720cULL, 0x000fda0003f06070ULL,
0x0000000800080947ULL, 0x000fea0003800000ULL, 0x00008e00ff127b82ULL, 0x000ee20000000a00ULL,
0x000000020a0c7836ULL, 0x000fe20000000000ULL, 0x0000850000047ab9ULL, 0x000fe20000000800ULL,
0x000001000e0e7824ULL, 0x000fe400078e0257ULL, 0x0000000411067c24ULL, 0x010fe2000f8e02ffULL,
0x0000007d0c00720cULL, 0x000fe40003f06070ULL, 0x000000200e117812ULL, 0x000fe200078ec0ffULL,
0x00000040061b7824ULL, 0x000fc800078e00ffULL, 0x000000014a117824ULL, 0x000fe400078e0211ULL,
0x000000801b127825ULL, 0x008fc800078e0012ULL, 0x0000000000f88947ULL, 0x000fea0003800000ULL,
0x0000000e7b067248ULL, 0x000fe20007fe0000ULL, 0x00000010000c7824ULL, 0x000fc800078e00ffULL,
0x0000000106067824ULL, 0x000fe200078e0a0eULL, 0x000000100c1b7812ULL, 0x000fe400078ec0ffULL,
0x00000003ff0c7819ULL, 0x000fe40000011604ULL, 0x000000061b067248ULL, 0x000fc60007fe0000ULL,
0x000000040c0e7836ULL, 0x000fe40000000000ULL, 0x0000000106067824ULL, 0x100fe400078e0a1bULL,
0x000000080c1a7836ULL, 0x000fe40000000000ULL, 0x0000000c0c387836ULL, 0x000fe20000000000ULL,
0x000000060c00720cULL, 0x0c0fe20003f86070ULL, 0x000000010c0c7824ULL, 0x100fe200078e021bULL,
0x000000060e00720cULL, 0x0c0fe20003f66070ULL, 0x000000010e0e7824ULL, 0x000fe200078e021bULL,
0x000000061a00720cULL, 0x080fe20003f46070ULL, 0x000000080c397824ULL, 0x000fe200078e00ffULL,
0x000000063800720cULL, 0x000fe20003f06070ULL, 0x000000010c067824ULL, 0x000fc400078e0204ULL,
0x00000001383e7824ULL, 0x100fe400078e021bULL, 0x000000011a1a7824ULL, 0x000fe200078e021bULL,
0xfffffff839067812ULL, 0x000fe200078ee206ULL, 0x000000010c387824ULL, 0x000fe400078e0211ULL,
0x000000010e0c7824ULL, 0x140fe400078e0204ULL, 0x000000080e3b7824ULL, 0x000fe400078e00ffULL,
0x000000011a1b7824ULL, 0x000fc400078e0204ULL, 0x000000081a3c7824ULL, 0x002fe200078e00ffULL,
0xfffffff83b0c7812ULL, 0x000fe200078ee20cULL, 0x000000010e3a7824ULL, 0x000fe400078e0211ULL,
0x0000008038387825ULL, 0x000fe200078e00ffULL, 0xfffffff83c0e7812ULL, 0x000fc600078ee21bULL,
0x000000803a3a7825ULL, 0x000fe200078e00ffULL, 0x0000004d383d7212ULL, 0x000fc600078efcffULL,
0x000000011a1a7824ULL, 0x100fe200078e0211ULL, 0x0000003d12387210ULL, 0x000fe20007fbe0ffULL,
0x000000013e3c7824ULL, 0x000fe200078e0211ULL, 0x0000004d3a117212ULL, 0x000fe200078efcffULL,
0x000000013e3f7824ULL, 0x040fe400078e0204ULL, 0x000000083e3e7824ULL, 0x000fe200078e00ffULL,
0x00000011123a7210ULL, 0x000fe20007fde0ffULL, 0x000000801a1a7825ULL, 0x000fc600078e00ffULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee23fULL, 0x000000803c3c7825ULL, 0x000fe200078e00ffULL,
0x0000004d1a3f7212ULL, 0x000fc600078efcffULL, 0x0000000113397824ULL, 0x040fe200028e0639ULL,
0x0000004d3c117212ULL, 0x000fe200078efcffULL, 0x0000001006417824ULL, 0x000fe200078e0207ULL,
0x0000003f12067210ULL, 0x000fe20007fbe0ffULL, 0x00000001133b7824ULL, 0x040fe200030e063bULL,
0x0000001112127210ULL, 0x000fe20007fde0ffULL, 0x000000100c437824ULL, 0x100fe200078e0207ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000038417faeULL, 0x0003e2000e101c46ULL,
0x000000100e117824ULL, 0x100fe400078e0207ULL, 0x000000103e3f7824ULL, 0x000fe200078e0207ULL,
0x000000003a437faeULL, 0x0003e2000d901c46ULL, 0x0000000113077824ULL, 0x000fc400028e061bULL,
0x0000000113137824ULL, 0x000fc600030e063dULL, 0x0000000006117faeULL, 0x0003e8000d101c46ULL,
0x00000000123f7faeULL, 0x0003e2000c101c46ULL, 0x0000000000c47947ULL, 0x000fea0003800000ULL,
0x0000001000067824ULL, 0x000fca00078e00ffULL, 0x00000010061b7812ULL, 0x000fc800078ec0ffULL,
0x0000001b041b7211ULL, 0x000fca00078fe8ffULL, 0x000000011b067824ULL, 0x040fe400078e0204ULL,
0x000000081b397824ULL, 0x040fe400078e00ffULL, 0x000000041b0c7836ULL, 0x000fe40000000000ULL,
0x000000011b1a7824ULL, 0x000fe200078e0211ULL, 0xfffffff839067812ULL, 0x000fe200078ee206ULL,
0x000000081b397836ULL, 0x000fe40000000000ULL, 0x0000000c1b3b7836ULL, 0x000fc40000000000ULL,
0x000000010c387824ULL, 0x140fe400078e0211ULL, 0x000000010c0e7824ULL, 0x140fe400078e0204ULL,
0x000000080c3d7824ULL, 0x002fe400078e00ffULL, 0x00000001393a7824ULL, 0x040fe400078e0211ULL,
0x00000001390c7824ULL, 0x040fe200078e0204ULL, 0xfffffff83d0e7812ULL, 0x000fe200078ee20eULL,
0x00000008393f7824ULL, 0x000fc400078e00ffULL, 0x000000801a1a7825ULL, 0x000fc600078e00ffULL,
0xfffffff83f0c7812ULL, 0x000fe200078ee20cULL, 0x000000013b397824ULL, 0x040fe400078e0204ULL,
0x000000083b3e7824ULL, 0x040fe400078e00ffULL, 0x000000013b3c7824ULL, 0x000fe200078e0211ULL,
0x0000004d1a117212ULL, 0x080fe200078efcffULL, 0x000000803a3a7825ULL, 0x000fe200078e00ffULL,
0xfffffff83e3e7812ULL, 0x000fe400078ee239ULL, 0x00000011121a7210ULL, 0x000fe20007f1e0ffULL,
0x0000008038387825ULL, 0x000fe200078e00ffULL, 0x0000004d3a3f7212ULL, 0x000fc600078efcffULL,
0x000000803c3c7825ULL, 0x000fe200078e00ffULL, 0x0000004d38417212ULL, 0x080fe400078efcffULL,
0x0000003f12387210ULL, 0x000fe20007f5e0ffULL, 0x00000001131b7824ULL, 0x000fe200000e061bULL,
0x0000004d3c117212ULL, 0x000fe200078efcffULL, 0x0000001006437824ULL, 0x100fe200078e0207ULL,
0x0000004112067210ULL, 0x000fe20007f1e0ffULL, 0x000000100e457824ULL, 0x100fe200078e0207ULL,
0x0000001112127210ULL, 0x000fe20007f7e0ffULL, 0x000000100c477824ULL, 0x100fe200078e0207ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a437faeULL, 0x0003e2000b901c46ULL,
0x000000103e117824ULL, 0x000fc400078e0207ULL, 0x0000000113077824ULL, 0x040fe400000e0639ULL,
0x0000000113397824ULL, 0x040fe400010e063bULL, 0x0000000113137824ULL, 0x000fe200018e063dULL,
0x0000000006457faeULL, 0x0003e8000b901c46ULL, 0x0000000038477faeULL, 0x0003e8000b901c46ULL,
0x0000000012117faeULL, 0x0003e4000b901c46ULL, 0x000000044f0c7836ULL, 0x000fe40000000000ULL,
0xffffffffff117424ULL, 0x002fc600078e00ffULL, 0x0000007c0c00720cULL, 0x000fda0003f06070ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x00009000ff067b82ULL, 0x000e620000000a00ULL,
0x000000014b117824ULL, 0x000fc800078e020cULL, 0x0000000411067825ULL, 0x002fca00078e0006ULL,
0x0000000606117981ULL, 0x000324000c1e1900ULL, 0x0000000800067824ULL, 0x002fe400078e00ffULL,
0x00000001ff387424ULL, 0x000fc600078e00ffULL, 0xfffffff006077812ULL, 0x000fca00078ec0ffULL,
0x0000000102077824ULL, 0x000fca00078e0207ULL, 0x00000000070472caULL, 0x000fe200000e0000ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000176a804047890ULL, 0x000fd2000fffe03fULL,
0x00000000ff0079b0ULL, 0x000fe20008000a44ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0176a838070679a7ULL, 0x0002e4000850003fULL, 0x017668380b3879a7ULL, 0x0022a4000850003fULL,
0x000000ffff067224ULL, 0x00afce00078e0007ULL, 0x0000000000127805ULL, 0x000fce0000015200ULL,
0x017668390b0075a7ULL, 0x004e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff3a7224ULL, 0x000fce00078e00ffULL, 0x000000103a00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000001a7805ULL, 0x000fce0000015200ULL,
0x0000001a120e7210ULL, 0x000fca0007f1e1ffULL, 0x000000011b1a7824ULL, 0x000fe200000e0e13ULL,
0x003d09000e00780cULL, 0x000fc80003f06070ULL, 0x000000ff1a00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400e00780cULL, 0x000fc80003f06070ULL,
0x000000ff1a00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff077819ULL, 0x000fc8000001141aULL, 0x0000000e07077211ULL, 0x000fca00078110ffULL,
0x000000ffff0e7224ULL, 0x000fca00000e061aULL, 0x0000000207077819ULL, 0x000fc8000000120eULL,
0x000000070000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013a3a7836ULL, 0x000fce0000000000ULL, 0x017668390b0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00000080500e7824ULL, 0x000fe400078e0202ULL,
0x00000001ff387424ULL, 0x000fc600078e00ffULL, 0x000001804d0e7810ULL, 0x000fca0007ffe00eULL,
0x00000001510e7824ULL, 0x000fca00078e020eULL, 0x017000000e127984ULL, 0x000e680000000800ULL,
0x017200000e137984ULL, 0x0004a20000000800ULL, 0x0000000d1200720bULL, 0x002fda0003f1d000ULL,
0x0000000000077806ULL, 0x000fc800000e0100ULL, 0x0000ffff071a7812ULL, 0x000fe2000780c0ffULL,
0x000000ffff077224ULL, 0x000fd800078e000dULL, 0x0000000400008947ULL, 0x004fea0003800000ULL,
0x0000000350077836ULL, 0x000fe20000000000ULL, 0x0000000d1200720bULL, 0x000fc80003f14000ULL,
0x000000000700720cULL, 0x000fd20003f45270ULL, 0x00000000001b7806ULL, 0x000fc800000e0100ULL,
0x00000080000ea824ULL, 0x000fe200078e0202ULL, 0x0000000d1207a209ULL, 0x000fc80007810000ULL,
0x0000000e5138a210ULL, 0x000fe40007ffe04dULL, 0x000099101b0e7816ULL, 0x000fc600000000ffULL,
0x017400073800a388ULL, 0x0003e20000000800ULL, 0x000000ff0e00720cULL, 0x000fda0003f05270ULL,
0x0000000000b48947ULL, 0x002fea0003800000ULL, 0x0000000d120e7209ULL, 0x000fe40007810000ULL,
0x000000ff1bff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff001bff7812ULL, 0x000fe2000784c0ffULL,
0x0000000d0e077221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b07077820ULL, 0x000fc80000410000ULL,
0x00000007000e7308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff077819ULL, 0x002fcc0000011604ULL, 0x00001f070e077589ULL, 0x004e6400000e0000ULL,
0x0000001407147220ULL, 0x042fe20000410000ULL, 0x0000001507157220ULL, 0x040fe20000410000ULL,
0x0000001c071c7220ULL, 0x040fe20000410000ULL, 0x0000001d071d7220ULL, 0x040fe20000410000ULL,
0x0000002007207220ULL, 0x040fe20000410000ULL, 0x0000002107217220ULL, 0x040fe20000410000ULL,
0x0000002407247220ULL, 0x040fe20000410000ULL, 0x0000002507257220ULL, 0x040fe20000410000ULL,
0x0000002807287220ULL, 0x040fe20000410000ULL, 0x0000002907297220ULL, 0x040fe20000410000ULL,
0x0000002c072c7220ULL, 0x040fe20000410000ULL, 0x0000002d072d7220ULL, 0x040fe20000410000ULL,
0x0000003007307220ULL, 0x040fe20000410000ULL, 0x0000003107317220ULL, 0x040fe20000410000ULL,
0x0000003407347220ULL, 0x040fe20000410000ULL, 0x0000003507357220ULL, 0x000fce0000410000ULL,
0x0000000e0f0f7220ULL, 0x004fe20000410000ULL, 0x000000000048a947ULL, 0x000fec0003800000ULL,
0x0000000804077811ULL, 0x002fcc00078ff0ffULL, 0x00001f070e077589ULL, 0x000e6400000e0000ULL,
0x0000001607167220ULL, 0x042fe20000410000ULL, 0x0000001707177220ULL, 0x040fe20000410000ULL,
0x0000001e071e7220ULL, 0x040fe20000410000ULL, 0x0000001f071f7220ULL, 0x040fe20000410000ULL,
0x0000002207227220ULL, 0x040fe20000410000ULL, 0x0000002307237220ULL, 0x040fe20000410000ULL,
0x0000002607267220ULL, 0x040fe20000410000ULL, 0x0000002707277220ULL, 0x040fe20000410000ULL,
0x0000002a072a7220ULL, 0x040fe20000410000ULL, 0x0000002b072b7220ULL, 0x040fe20000410000ULL,
0x0000002e072e7220ULL, 0x040fe20000410000ULL, 0x0000002f072f7220ULL, 0x040fe20000410000ULL,
0x0000003207327220ULL, 0x040fe20000410000ULL, 0x0000003307337220ULL, 0x040fe20000410000ULL,
0x0000003607367220ULL, 0x040fe20000410000ULL, 0x0000003707377220ULL, 0x000fce0000410000ULL,
0x0000ffff1aff7812ULL, 0x000fe2000780601bULL, 0x00000001ff387424ULL, 0x000fe200078e00ffULL,
0x0000000d12077209ULL, 0x002fd60007810000ULL, 0x8000000712120221ULL, 0x000fe20000010000ULL,
0x00007610ff380816ULL, 0x000fc60000000038ULL, 0x3fb8aa3b12120820ULL, 0x000fc80000410000ULL,
0x0000001200080308ULL, 0x000e640000000800ULL, 0x0000000813130220ULL, 0x002fce0000410000ULL,
0x0000000f130f7221ULL, 0x000fce0000010000ULL, 0x0000000000127805ULL, 0x000fce0000015200ULL,
0x00000008000d7824ULL, 0x000fca00078e00ffULL, 0xfffffff00d0d7812ULL, 0x000fca00078ec0ffULL,
0x0000000102397824ULL, 0x000fc800078e020dULL, 0x0176b019390075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff3a7224ULL, 0x000fce00078e00ffULL,
0x000000103a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000001a7805ULL, 0x000fce0000015200ULL, 0x0000001a120e7210ULL, 0x000fca0007f1e1ffULL,
0x000000011b1a7824ULL, 0x000fe200000e0e13ULL, 0x003d09000e00780cULL, 0x000fc80003f06070ULL,
0x000000ff1a00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400e00780cULL, 0x000fc80003f06070ULL, 0x000000ff1a00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff0d7819ULL, 0x000fc8000001141aULL,
0x0000000e0d0d7211ULL, 0x000fca00078110ffULL, 0x000000ffff0e7224ULL, 0x000fca00000e061aULL,
0x000000020d0d7819ULL, 0x000fc8000000120eULL, 0x0000000d0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013a3a7836ULL, 0x000fce0000000000ULL,
0x0176b019390075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00009910380d7816ULL, 0x000fe200000000ffULL, 0x00000004000e7824ULL, 0x000fe200078e00ffULL,
0x0000000804197812ULL, 0x000fe400078ec0ffULL, 0x000000ff0d00720cULL, 0x000fe20003f05270ULL,
0x00000800500d7824ULL, 0x000fe200078e0202ULL, 0x000000040e0e7812ULL, 0x000fc600078ec0ffULL,
0x000000104e187824ULL, 0x000fe200078e020dULL, 0x000000020e137812ULL, 0x000fe400078efcffULL,
0x00000007190d7812ULL, 0x000fe400078ef804ULL, 0x00000013040e7211ULL, 0x000fc600078fe0ffULL,
0x0000000000180947ULL, 0x000fea0003800000ULL, 0x00000002ff057819ULL, 0x000fe40000011604ULL,
0x00000008ff03723eULL, 0x000fc600000000ffULL, 0x0000000805137836ULL, 0x000fe20000000000ULL,
0x0000541003127816ULL, 0x000fca0000000003ULL, 0x00001f0512057589ULL, 0x0002a800000e0000ULL,
0x00001f1312037589ULL, 0x0002e400000e0000ULL, 0x012800001818783bULL, 0x000e620000000200ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x0000000518187232ULL, 0x086fe40000000000ULL,
0x000000051a1a7232ULL, 0x000fe40000000000ULL, 0x0000000319197232ULL, 0x088fe40000000000ULL,
0x000000031b1b7232ULL, 0x000fce0000000000ULL, 0x000000080d137824ULL, 0x042fe200078e00ffULL,
0x000000004938783bULL, 0x000e620000004200ULL, 0x000000010d127824ULL, 0x000fe200078e020eULL,
0x0000000704417812ULL, 0x000fe200078ec0ffULL, 0x000000024c4c7836ULL, 0x000fc60000000000ULL,
0xfffffff813137812ULL, 0x000fe400078ee212ULL, 0x0000000841417812ULL, 0x000fc600078ef804ULL,
0x0000001013137824ULL, 0x000fe400078e0210ULL, 0x0000000841437824ULL, 0x000fe400078e00ffULL,
0x0000000350417836ULL, 0x000fe20000000000ULL, 0x00000000133c783bULL, 0x000f640000004200ULL,
0xfffffff843447812ULL, 0x000fe200078ee24cULL, 0x0000080041417824ULL, 0x000fc800078e0202ULL,
0x0000001044447824ULL, 0x000fe200078e0241ULL, 0x00000010ff5e7819ULL, 0x002fe40000011638ULL,
0x00000010ff5f7819ULL, 0x100fe40000011639ULL, 0x000000ff395a7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff517819ULL, 0x000fe40000011639ULL, 0x0000ffff395d7812ULL, 0x000fe400078ec0ffULL,
0x000000ff38597812ULL, 0x000fc400078ec0ffULL, 0x00000018ff4f7819ULL, 0x000fe40000011638ULL,
0x0000ffff38627812ULL, 0x000fe400078ec0ffULL, 0x000000ff3e607812ULL, 0x028fe400078ec0ffULL,
0x00000010ff127819ULL, 0x100fe4000001163cULL, 0x000000ff3c477812ULL, 0x000fe400078ec0ffULL,
0x00000018ff427819ULL, 0x000fc4000001163cULL, 0x0000ffff3c397812ULL, 0x000fe400078ec0ffULL,
0x00000010ff387819ULL, 0x100fe4000001163eULL, 0x00000018ff3c7819ULL, 0x000fe4000001163eULL,
0x0000ffff3e407812ULL, 0x000fe400078ec0ffULL, 0x00000060ff3e723eULL, 0x000fe400020006ffULL,
0x000000ff5e5e7812ULL, 0x000fc400078ec0ffULL, 0x000000ff5f607812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5c7819ULL, 0x100fe4000001163aULL, 0x000000ff3a4e7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff497819ULL, 0x000fe4000001163aULL, 0x0000ffff3a587812ULL, 0x000fe400078ec0ffULL,
0x000000ff3f617812ULL, 0x000fc400078ec0ffULL, 0x00000010ff5b7819ULL, 0x100fe4000001163bULL,
0x000000ff3b4d7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff3a7819ULL, 0x000fe4000001163bULL,
0x0000ffff3b137812ULL, 0x000fe400078ec0ffULL, 0x00000010ff4c7819ULL, 0x000fe4000001163dULL,
0x000000ff3d467812ULL, 0x000fc400078ec0ffULL, 0x00000018ff437819ULL, 0x000fe4000001163dULL,
0x0000ffff3d3b7812ULL, 0x000fe400078ec0ffULL, 0x00000059ff59723eULL, 0x000fe400020006ffULL,
0x0000005aff5a723eULL, 0x000fe400020006ffULL, 0x0000005eff5e723eULL, 0x000fe400020006ffULL,
0x00000060ff60723eULL, 0x000fc400020006ffULL, 0x00000010ff457819ULL, 0x100fe4000001163fULL,
0x00000018ff3d7819ULL, 0x000fe4000001163fULL, 0x0000ffff3f417812ULL, 0x000fe400078ec0ffULL,
0x00000061ff3f723eULL, 0x000fe400020006ffULL, 0x00000008ff5f7819ULL, 0x000fe40000011662ULL,
0x00000008ff617819ULL, 0x000fc40000011613ULL, 0x000000ff12627812ULL, 0x000fe400078ec0ffULL,
0x00000008ff5d7819ULL, 0x000fe4000001165dULL, 0x0000541059127816ULL, 0x000fe4000000005eULL,
0x000054105a137816ULL, 0x000fe40000000060ULL, 0x0000004fff4f723eULL, 0x000fe400020006ffULL,
0x00000051ff51723eULL, 0x000fc400020006ffULL, 0x0000005fff5f723eULL, 0x000fe200020006ffULL,
0x000000121814723cULL, 0x000fe20000001814ULL, 0x0000005dff5d723eULL, 0x000fe400020006ffULL,
0x000000ff5c5c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff5b5b7812ULL, 0x000fe400078ec0ffULL,
0x000054105f127816ULL, 0x000fe4000000004fULL, 0x000054105d137816ULL, 0x000fc40000000051ULL,
0x0000004eff4e723eULL, 0x000fe400020006ffULL, 0x0000004dff4d723eULL, 0x000fe400020006ffULL,
0x0000005cff5c723eULL, 0x000fe200020006ffULL, 0x00000012181c723cULL, 0x000fe2000000181cULL,
0x0000005bff5b723eULL, 0x000fe400020006ffULL, 0x00000008ff587819ULL, 0x000fe40000011658ULL,
0x00000049ff49723eULL, 0x000fc400020006ffULL, 0x000054104e127816ULL, 0x000fe4000000005cULL,
0x000054104d137816ULL, 0x000fe4000000005bULL, 0x0000003aff3a723eULL, 0x000fe400020006ffULL,
0x00000058ff58723eULL, 0x000fe400020006ffULL, 0x00000061ff61723eULL, 0x000fe200020006ffULL,
0x000000121820723cULL, 0x000fe20000001820ULL, 0x000000ff4c4c7812ULL, 0x000fc400078ec0ffULL,
0x00000008ff397819ULL, 0x000fe40000011639ULL, 0x00000008ff3b7819ULL, 0x000fe4000001163bULL,
0x000000ff38387812ULL, 0x000fe400078ec0ffULL, 0x0000541058127816ULL, 0x000fe40000000049ULL,
0x0000541061137816ULL, 0x000fe4000000003aULL, 0x000000ff45457812ULL, 0x000fc400078ec0ffULL,
0x00000008ff407819ULL, 0x000fe40000011640ULL, 0x00000008ff417819ULL, 0x000fe20000011641ULL,
0x000000121824723cULL, 0x000fe20000001824ULL, 0x0000004cff4f723eULL, 0x000fe400020006ffULL,
0x00000047ff47723eULL, 0x000fe400020006ffULL, 0x00000046ff46723eULL, 0x000fe400020006ffULL,
0x00000042ff42723eULL, 0x000fc400020006ffULL, 0x00000043ff43723eULL, 0x000fe400020006ffULL,
0x0000003cff3c723eULL, 0x000fe400020006ffULL, 0x00000062ff59723eULL, 0x000fe400020006ffULL,
0x00000039ff4c723eULL, 0x000fe400020006ffULL, 0x0000003bff4d723eULL, 0x000fe400020006ffULL,
0x00000038ff49723eULL, 0x000fc400020006ffULL, 0x00000045ff45723eULL, 0x000fe200020006ffULL,
0x011000004438783bULL, 0x0002e20000000200ULL, 0x0000003dff3d723eULL, 0x000fe400020006ffULL,
0x00000040ff40723eULL, 0x000fe400020006ffULL, 0x00000041ff41723eULL, 0x000fe400020006ffULL,
0x0000541047127816ULL, 0x000fe40000000059ULL, 0x0000541046137816ULL, 0x000fc4000000004fULL,
0x000054104c4c7816ULL, 0x000fe40000000042ULL, 0x000054104d4d7816ULL, 0x000fe40000000043ULL,
0x000054103e3e7816ULL, 0x000fe20000000049ULL, 0x000000121828723cULL, 0x000fe20000001828ULL,
0x000054103f3f7816ULL, 0x000fe40000000045ULL, 0x0000541040407816ULL, 0x000fe4000000003cULL,
0x0000541041417816ULL, 0x000fe2000000003dULL, 0x0000004c182c723cULL, 0x000fec000000182cULL,
0x0000003e1830723cULL, 0x000fec0000001830ULL, 0x000000401834723cULL, 0x000fe20000001834ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000100947ULL, 0x002fde0003800000ULL,
0x0000000538387232ULL, 0x08cfe40000000000ULL, 0x000000053a3a7232ULL, 0x000fe40000000000ULL,
0x0000000339397232ULL, 0x080fe40000000000ULL, 0x000000033b3b7232ULL, 0x000fce0000000000ULL,
0x000000004818783bULL, 0x000e620000004200ULL, 0x000000100d0d7812ULL, 0x000fe200078efcffULL,
0x000000010a0a7836ULL, 0x000fc80000000000ULL, 0x000000010d0e7824ULL, 0x040fe400078e020eULL,
0x000000080d0d7824ULL, 0x000fca00078e00ffULL, 0xfffffff80d0d7812ULL, 0x000fca00078ee20eULL,
0x000000100d0d7824ULL, 0x000fca00078e0210ULL, 0x000000000d3c783bULL, 0x000b620000004200ULL,
0x00000010ff0e7819ULL, 0x002fe40000011618ULL, 0x00000010ff137819ULL, 0x000fe40000011619ULL,
0x000000ff18127812ULL, 0x000fe400078ec0ffULL, 0x000000ff19407812ULL, 0x000fe400078ec0ffULL,
0x000000ff0e0e7812ULL, 0x000fe400078ec0ffULL, 0x000000ff13137812ULL, 0x000fc400078ec0ffULL,
0x00000018ff107819ULL, 0x000fe40000011618ULL, 0x0000ffff18497812ULL, 0x000fe400078ec0ffULL,
0x00000018ff187819ULL, 0x000fe40000011619ULL, 0x0000ffff19487812ULL, 0x000fe400078ec0ffULL,
0x00000012ff12723eULL, 0x000fe400020006ffULL, 0x00000040ff40723eULL, 0x000fc400020006ffULL,
0x0000000eff0e723eULL, 0x000fe400020006ffULL, 0x00000013ff13723eULL, 0x000fe400020006ffULL,
0x00000010ff197819ULL, 0x100fe4000001161aULL, 0x00000018ff417819ULL, 0x000fe4000001161aULL,
0x00000018ff42723eULL, 0x000fe400020006ffULL, 0x000000ff1a437812ULL, 0x000fc400078ec0ffULL,
0x0000ffff1a4c7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff0d7819ULL, 0x028fe40000011649ULL,
0x00000008ff187819ULL, 0x000fe40000011648ULL, 0x0000541012127816ULL, 0x000fe4000000000eULL,
0x0000541040137816ULL, 0x000fe40000000013ULL, 0x00000010ff1a7819ULL, 0x000fc4000001161bULL,
0x000000ff1b447812ULL, 0x000fe400078ec0ffULL, 0x000000ff19197812ULL, 0x000fe400078ec0ffULL,
0x00000041ff46723eULL, 0x000fe400020006ffULL, 0x00000010ff10723eULL, 0x000fe400020006ffULL,
0x0000000dff0d723eULL, 0x000fe400020006ffULL, 0x00000018ff41723eULL, 0x000fc400020006ffULL,
0x0000ffff1b4d7812ULL, 0x000fe400078ec0ffULL, 0x00000044ff47723eULL, 0x000fe400020006ffULL,
0x000000ff1a487812ULL, 0x000fe400078ec0ffULL, 0x00000018ff457819ULL, 0x000fe4000001161bULL,
0x00000019ff44723eULL, 0x000fe400020006ffULL, 0x000000123818723cULL, 0x000fe20000001814ULL,
0x00000043ff43723eULL, 0x000fc400020006ffULL, 0x00000048ff48723eULL, 0x000fe400020006ffULL,
0x00000008ff0e7819ULL, 0x000fe4000001164cULL, 0x000054100d127816ULL, 0x000fe40000000010ULL,
0x0000541041137816ULL, 0x000fe40000000042ULL, 0x00000008ff147819ULL, 0x000fe4000001164dULL,
0x00000045ff0d723eULL, 0x000fc400020006ffULL, 0x00000014ff14723eULL, 0x000fe200020006ffULL,
0x00000012381c723cULL, 0x000fe2000000181cULL, 0x0000541043447816ULL, 0x000fe40000000044ULL,
0x0000541047457816ULL, 0x000fe40000000048ULL, 0x0000000eff0e723eULL, 0x000fe400020006ffULL,
0x00000010ff127819ULL, 0x004fe4000001163dULL, 0x0000541014477816ULL, 0x000fe2000000000dULL,
0x000000443820723cULL, 0x000fe20000001820ULL, 0x000054100e467816ULL, 0x000fc40000000046ULL,
0x00000010ff0d7819ULL, 0x100fe4000001163cULL, 0x00000018ff137819ULL, 0x000fe4000001163dULL,
0x000000ff12127812ULL, 0x000fe200078ec0ffULL, 0x000000463824723cULL, 0x000fe20000001824ULL,
0x0000ffff3d447812ULL, 0x000fe400078ec0ffULL, 0x000000ff3c107812ULL, 0x000fe400078ec0ffULL,
0x00000018ff0e7819ULL, 0x000fc4000001163cULL, 0x0000ffff3c437812ULL, 0x000fe400078ec0ffULL,
0x000000ff3d147812ULL, 0x000fe400078ec0ffULL, 0x000000ff0d0d7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff3c7819ULL, 0x100fe4000001163eULL, 0x00000013ff17723eULL, 0x000fe400020006ffULL,
0x00000010ff167819ULL, 0x000fc4000001163eULL, 0x00000012ff13723eULL, 0x000fe400020006ffULL,
0x000000ff3e3d7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff3e457812ULL, 0x000fe400078ec0ffULL,
0x00000008ff127819ULL, 0x000fe40000011644ULL, 0x00000010ff3e7819ULL, 0x000fe4000001163fULL,
0x000000ff3f417812ULL, 0x000fc400078ec0ffULL, 0x00000018ff407819ULL, 0x000fe4000001163fULL,
0x0000ffff3f467812ULL, 0x000fe400078ec0ffULL, 0x00000010ff10723eULL, 0x000fe400020006ffULL,
0x00000014ff15723eULL, 0x000fe400020006ffULL, 0x0000000dff0d723eULL, 0x000fe400020006ffULL,
0x0000003cff3f723eULL, 0x000fc400020006ffULL, 0x000000ff163c7812ULL, 0x000fe400078ec0ffULL,
0x00000012ff16723eULL, 0x000fe400020006ffULL, 0x0000541010127816ULL, 0x000fe2000000000dULL,
0x00000001ff107424ULL, 0x000fe200078e00ffULL, 0x0000541015137816ULL, 0x000fe40000000013ULL,
0x000000ff3e3e7812ULL, 0x000fe400078ec0ffULL, 0x00000040ff42723eULL, 0x000fc400020006ffULL,
0x0000003eff40723eULL, 0x000fe200020006ffULL, 0x000000123828723cULL, 0x000fe20000001828ULL,
0x0000000eff14723eULL, 0x000fe200020006ffULL, 0x00000010091279a7ULL, 0x0002a2000850003fULL,
0x00000008ff3e7819ULL, 0x000fe40000011645ULL, 0x00000008ff0e7819ULL, 0x000fe40000011643ULL,
0x00000008ff0d7819ULL, 0x000fe40000011646ULL, 0x0000003dff3d723eULL, 0x000fc400020006ffULL,
0x0000003cff3c723eULL, 0x000fe200020006ffULL, 0x0000000850097824ULL, 0x002fe200078e0202ULL,
0x0000003eff3e723eULL, 0x000fe400020006ffULL, 0x00000041ff41723eULL, 0x000fe200020006ffULL,
0x0176a01009ff79a7ULL, 0x0003e2000850003fULL, 0x0000000eff0e723eULL, 0x000fe400020006ffULL,
0x0000000dff0d723eULL, 0x000fe400020006ffULL, 0x000054103d3c7816ULL, 0x000fc4000000003cULL,
0x000054103e3e7816ULL, 0x000fe4000000003fULL, 0x000054100e147816ULL, 0x000fe40000000014ULL,
0x0000541016157816ULL, 0x000fe40000000017ULL, 0x00005410413d7816ULL, 0x000fe40000000040ULL,
0x000054100d3f7816ULL, 0x000fe20000000042ULL, 0x000000ffff0d7224ULL, 0x004fe400078e0013ULL,
0x00000014382c723cULL, 0x000fec000000182cULL, 0x0000003c3830723cULL, 0x000fec0000001830ULL,
0x0000003e3834723cULL, 0x000fe20000001834ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0xffffff7000b09947ULL, 0x002fde000383ffffULL, 0x000000ff7d00720cULL, 0x000fda0003f05270ULL,
0x0000000000d48947ULL, 0x000fea0003800000ULL, 0x018000000f037836ULL, 0x002fe20000000000ULL,
0x000000b000007945ULL, 0x000fe80003800000ULL, 0x7f80000003037812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0300780cULL, 0x000fda0003f04070ULL, 0x00000000000c0947ULL, 0x000fea0003800000ULL,
0x0000a8c000067802ULL, 0x004fce0000000f00ULL, 0x0000008000007944ULL, 0x018fea0003c00000ULL,
0x0000000000107947ULL, 0x000fea0003800000ULL, 0x0000000f00047308ULL, 0x000e640000001000ULL,
0xbf80000004037423ULL, 0x002fc8000000000fULL, 0x800000ff03037221ULL, 0x000fc80000010100ULL,
0x0000000304037223ULL, 0x000fce0000000004ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009800ff047b82ULL, 0x000f640000000a00ULL, 0x0000000604047981ULL, 0x02aee2000c1e9900ULL,
0x0000000000077919ULL, 0x004e640000000000ULL, 0x00000002ff067819ULL, 0x002fe40000011607ULL,
0x0000000807087811ULL, 0x000fe200078ff0ffULL, 0x0000000304037220ULL, 0x008fca0000410000ULL,
0x00001f0603067589ULL, 0x000e6800000e0000ULL, 0x00001f0803077589ULL, 0x000ea200000e0000ULL,
0x0000001806187220ULL, 0x042fe20000410000ULL, 0x0000001906197220ULL, 0x040fe20000410000ULL,
0x0000001c061c7220ULL, 0x040fe20000410000ULL, 0x0000001d061d7220ULL, 0x040fe20000410000ULL,
0x0000002006207220ULL, 0x040fe20000410000ULL, 0x0000002106217220ULL, 0x040fe20000410000ULL,
0x0000002406247220ULL, 0x040fe20000410000ULL, 0x0000002506257220ULL, 0x040fe20000410000ULL,
0x0000002806287220ULL, 0x040fe20000410000ULL, 0x0000002906297220ULL, 0x040fe20000410000ULL,
0x0000002c062c7220ULL, 0x040fe20000410000ULL, 0x0000002d062d7220ULL, 0x040fe20000410000ULL,
0x0000003006307220ULL, 0x040fe20000410000ULL, 0x0000003106317220ULL, 0x040fe20000410000ULL,
0x0000003406347220ULL, 0x040fe20000410000ULL, 0x0000003506357220ULL, 0x000fe20000410000ULL,
0x0000001a071a7220ULL, 0x044fe20000410000ULL, 0x0000001b071b7220ULL, 0x040fe20000410000ULL,
0x0000001e071e7220ULL, 0x040fe20000410000ULL, 0x0000001f071f7220ULL, 0x040fe20000410000ULL,
0x0000002207227220ULL, 0x040fe20000410000ULL, 0x0000002307237220ULL, 0x040fe20000410000ULL,
0x0000002607267220ULL, 0x040fe20000410000ULL, 0x0000002707277220ULL, 0x040fe20000410000ULL,
0x0000002a072a7220ULL, 0x040fe20000410000ULL, 0x0000002b072b7220ULL, 0x040fe20000410000ULL,
0x0000002e072e7220ULL, 0x040fe20000410000ULL, 0x0000002f072f7220ULL, 0x040fe20000410000ULL,
0x0000003207327220ULL, 0x040fe20000410000ULL, 0x0000003307337220ULL, 0x040fe20000410000ULL,
0x0000003607367220ULL, 0x040fe20000410000ULL, 0x0000003707377220ULL, 0x000fce0000410000ULL,
0x0000000000047919ULL, 0x000f620000000000ULL, 0x0000002c2d2c723eULL, 0x000fe400000000ffULL,
0x000000303130723eULL, 0x000fe200000000ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000222322723eULL, 0x000fc400000000ffULL, 0x000000262711723eULL, 0x010fe400000000ffULL,
0x0000002a2b2a723eULL, 0x000fe400000000ffULL, 0x0000002e2f15723eULL, 0x000fe400000000ffULL,
0x000000323332723eULL, 0x000fe400000000ffULL, 0x000000ff5300720cULL, 0x000fe40003f05270ULL,
0x00000002ff0c7819ULL, 0x122fe20000011604ULL, 0x0000000157577824ULL, 0x000fe200078e0204ULL,
0x0000000204037812ULL, 0x000fc400078ec0ffULL, 0x0000000804067811ULL, 0x004fe200078ff0ffULL,
0x000000080c097824ULL, 0x048fe200078e00ffULL, 0x0000000c03057211ULL, 0x040fe200078ff8ffULL,
0x000000080c0e7824ULL, 0x000fe200078e00ffULL, 0x0000000603077211ULL, 0x000fe200078ff8ffULL,
0x00000008060a7824ULL, 0x000fe200078e00ffULL, 0x0000000100037812ULL, 0x000fe200078ec0ffULL,
0x0000000205067836ULL, 0x000fe40000000000ULL, 0x000000080c007824ULL, 0x040fe200078e00ffULL,
0xfffffff80a0a7812ULL, 0x000fe200078ee207ULL, 0x0000000405077836ULL, 0x000fe20000000000ULL,
0xfffffff809087812ULL, 0x000fe200078ee206ULL, 0x000000080c107824ULL, 0x000fe200078e00ffULL,
0xfffffff800007812ULL, 0x000fe200078ee205ULL, 0x0000000605097836ULL, 0x000fe20000000000ULL,
0xfffffff80e0c7812ULL, 0x000fe200078ee207ULL, 0x0000100003027824ULL, 0x000fc400078e0202ULL,
0x0000000804067824ULL, 0x000fe200078e00ffULL, 0xfffffff8100e7812ULL, 0x000fe200078ee209ULL,
0x0000080053057824ULL, 0x100fe400078e0202ULL, 0x0000001057577824ULL, 0x000fe200078e0202ULL,
0x0000000806077812ULL, 0x000fe200078ec0ffULL, 0x000000100a107824ULL, 0x100fe400078e0205ULL,
0x0000001000067824ULL, 0x100fe200078e0205ULL, 0x000000181900723eULL, 0x000fe200000000ffULL,
0x00000010080a7824ULL, 0x100fe200078e0205ULL, 0x000000343518723eULL, 0x000fe200000000ffULL,
0x000000100c0c7824ULL, 0x100fe200078e0205ULL, 0x000000363719723eULL, 0x000fe200000000ffULL,
0x000000100e0e7824ULL, 0x000fe200078e0205ULL, 0x0000001c1d05723eULL, 0x000fe200000000ffULL,
0x0000000106087824ULL, 0x000fe200078e0207ULL, 0x000000282906723eULL, 0x000fe200000000ffULL,
0x00000001070a7824ULL, 0x040fe200078e020aULL, 0x0000541000127816ULL, 0x140fe20000000005ULL,
0x0000000107107824ULL, 0x040fe200078e0210ULL, 0x0000763200137816ULL, 0x000fe20000000005ULL,
0x00000001070c7824ULL, 0x000fe200078e020cULL, 0x000000202100723eULL, 0x000fe200000000ffULL,
0x00000001070e7824ULL, 0x000fe200078e020eULL, 0x000000242505723eULL, 0x000fe200000000ffULL,
0x0000001208007388ULL, 0x0003e20000000a00ULL, 0x0000763230077816ULL, 0x000fc40000000018ULL,
0x0000763200097816ULL, 0x000fe40000000005ULL, 0x00005410321c7816ULL, 0x140fe40000000019ULL,
0x00007632321d7816ULL, 0x000fe40000000019ULL, 0x0000541000087816ULL, 0x002fe40000000005ULL,
0x0000001a1b00723eULL, 0x000fe400000000ffULL, 0x0000001e1f05723eULL, 0x000fe200000000ffULL,
0x000000080a007388ULL, 0x0003e40000000a00ULL, 0x0000541006087816ULL, 0x002fc4000000002cULL,
0x0000763206097816ULL, 0x000fe4000000002cULL, 0x0000541030067816ULL, 0x000fc60000000018ULL,
0x000000080c007388ULL, 0x000fe80000000a00ULL, 0x000000060e007388ULL, 0x0003e40000000a00ULL,
0x0000541000067816ULL, 0x142fe40000000005ULL, 0x0000763200077816ULL, 0x000fca0000000005ULL,
0x0000000610007388ULL, 0x0003e40000000a00ULL, 0x0000541022067816ULL, 0x142fe40000000011ULL,
0x0000763222077816ULL, 0x000fca0000000011ULL, 0x000400060a007388ULL, 0x0003e40000000a00ULL,
0x000054102a067816ULL, 0x142fe40000000015ULL, 0x000076322a077816ULL, 0x000fca0000000015ULL,
0x000400060c007388ULL, 0x000fe80000000a00ULL, 0x0004001c0e007388ULL, 0x000fe20000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000057107984ULL, 0x000e680000000c00ULL,
0x0004000057147984ULL, 0x000ea80000000c00ULL, 0x0008000057087984ULL, 0x000ee80000000c00ULL,
0x000c000057187984ULL, 0x000f220000000c00ULL, 0x200000ff13137230ULL, 0x002fc40000000000ULL,
0x200000ff12127230ULL, 0x000fe40000000000ULL, 0x200000ff11117230ULL, 0x000fe40000000000ULL,
0x200000ff10107230ULL, 0x000fe40000000000ULL, 0x200000ff17177230ULL, 0x004fe40000000000ULL,
0x200000ff16167230ULL, 0x000fe40000000000ULL, 0x200000ff15157230ULL, 0x000fc40000000000ULL,
0x200000ff14147230ULL, 0x000fe40000000000ULL, 0x0000000b13137230ULL, 0x008fe40000000000ULL,
0x0000000a12127230ULL, 0x000fe40000000000ULL, 0x0000000911117230ULL, 0x000fe40000000000ULL,
0x0000000810107230ULL, 0x000fe40000000000ULL, 0x0000001b17177230ULL, 0x010fc40000000000ULL,
0x0000001a16167230ULL, 0x000fe20000000000ULL, 0x0000001057007388ULL, 0x0003e20000000c00ULL,
0x0000001915157230ULL, 0x000fe40000000000ULL, 0x0000001814147230ULL, 0x000fca0000000000ULL,
0x0004001457007388ULL, 0x0003e20000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000000479c3ULL, 0x000ea20000002700ULL,
0x00000003ff097819ULL, 0x000fe20000011604ULL, 0x0000840000057ab9ULL, 0x000fc60000000800ULL,
0x000000540900720cULL, 0x000fe20003f06070ULL, 0x00000005040472a4ULL, 0x004fd8000f8e023fULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00008600ff127b82ULL, 0x002e620000000800ULL,
0x0000000109007824ULL, 0x000fe200078e0204ULL, 0x0000880000087ab9ULL, 0x000fe20000000a00ULL,
0xffffffffff077424ULL, 0x000fe200078e00ffULL, 0x0000000704107812ULL, 0x000fe200078ec0ffULL,
0x00000020040c7836ULL, 0x000fe20000000000ULL, 0x0000000700057812ULL, 0x000fe200078ec0ffULL,
0x0000001056007824ULL, 0x000fc600078e0209ULL, 0x0ffffff805057812ULL, 0x000fe400078ef804ULL,
0x00000003ff0d7819ULL, 0x000fc6000001160cULL, 0x0000001005057824ULL, 0x000fca00078e0202ULL,
0x0000000005087984ULL, 0x0004e20000000c00ULL, 0x0000001207147219ULL, 0x082fe400000006ffULL,
0x0000001252527219ULL, 0x000fe400000006ffULL, 0x0000001400077212ULL, 0x000fe200078e30ffULL,
0x0000000803057824ULL, 0x004fe200078e0210ULL, 0x00000012ff067219ULL, 0x000fe20000011600ULL,
0x0000000455007c24ULL, 0x000fe4000f8e02ffULL, 0x0000000152077824ULL, 0x000fc800078e0207ULL,
0x0000005506077224ULL, 0x000fca00078e0207ULL, 0x0000000700077210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x0000000807067c11ULL, 0x000fc8000f8040ffULL,
0x0000000907077c11ULL, 0x000fe400080f440eULL, 0x000000540d00720cULL, 0x000fe20003f06070ULL,
0x0000001005067825ULL, 0x000fca00078e0006ULL, 0x0000000806007986ULL, 0x0083ee000c101d06ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010c057824ULL, 0x100fe400078e020dULL,
0x00000010560d7824ULL, 0x000fc600078e020dULL, 0x0000000705057812ULL, 0x000fe400078ec0ffULL,
0x000000140d077212ULL, 0x002fe400078e30ffULL, 0x0ffffff805057812ULL, 0x000fe400078ef80cULL,
0x00000012ff067219ULL, 0x000fe2000001160dULL, 0x0000000152077824ULL, 0x000fe200078e0207ULL,
0x000000070c0c7812ULL, 0x000fe200078ec0ffULL, 0x0000001005057824ULL, 0x000fe400078e0202ULL,
0x0000005506077224ULL, 0x000fc400078e0207ULL, 0x00000040040d7836ULL, 0x000fe20000000000ULL,
0x0000000005087984ULL, 0x0002a40000000c00ULL, 0x0000000700077210ULL, 0x000fe40007f1e0ffULL,
0x00000003ff0f7819ULL, 0x000fc6000001160dULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x0000000807067c11ULL, 0x000fe2000f8040ffULL, 0x0000000803057824ULL, 0x002fc600078e020cULL,
0x0000000907077c11ULL, 0x000fe400080f440eULL, 0x000000540f00720cULL, 0x000fe20003f06070ULL,
0x0000001005067825ULL, 0x000fca00078e0006ULL, 0x0000000806007986ULL, 0x0043ee000c101d06ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010d057824ULL, 0x100fe400078e020fULL,
0x00000010560f7824ULL, 0x000fe400078e020fULL, 0x00000060040e7836ULL, 0x000fe20000000000ULL,
0x0000000705067812ULL, 0x002fe400078ec0ffULL, 0x00000012ff0c7219ULL, 0x000fe4000001160fULL,
0x0ffffff806057812ULL, 0x000fca00078ef80dULL, 0x0000001005067824ULL, 0x000fe200078e0202ULL,
0x000000140f057212ULL, 0x000fc800078e30ffULL, 0x0000000006087984ULL, 0x0002a20000000c00ULL,
0x0000000152057824ULL, 0x000fc800078e0205ULL, 0x000000550c057224ULL, 0x000fe200078e0205ULL,
0x000000070d0c7812ULL, 0x000fe400078ec0ffULL, 0x00000003ff0d7819ULL, 0x000fe4000001160eULL,
0x0000000500057210ULL, 0x000fe20007f1e0ffULL, 0x0000000803077824ULL, 0x000fe400078e020cULL,
0x000000010e067824ULL, 0x002fe400078e020dULL, 0x000000ffff107224ULL, 0x000fe200000e06ffULL,
0x0000000805047c11ULL, 0x000fc8000f8040ffULL, 0x0000000905057c11ULL, 0x000fe400080f4410ULL,
0x000000540d00720cULL, 0x000fe20003f06070ULL, 0x0000001007047825ULL, 0x000fe200078e0004ULL,
0x0000000706077812ULL, 0x000fc800078ec0ffULL, 0xfffffff807077812ULL, 0x000fe200078ef80eULL,
0x0000000804007986ULL, 0x0043ec000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000001007077824ULL, 0x000fe200078e0202ULL, 0x000000070e0e7812ULL, 0x000fe200078ec0ffULL,
0x00000010560d7824ULL, 0x000fc600078e020dULL, 0x0000000007087984ULL, 0x002e620000000c00ULL,
0x0000000803037824ULL, 0x000fe200078e020eULL, 0x000000140d047212ULL, 0x000fe400078e30ffULL,
0x00000012ff027219ULL, 0x000fc6000001160dULL, 0x0000000152047824ULL, 0x000fc800078e0204ULL,
0x0000005502557224ULL, 0x000fca00078e0204ULL, 0x0000005500557210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff007224ULL, 0x000fe200000e06ffULL, 0x0000000855047c11ULL, 0x000fc8000f8040ffULL,
0x0000000955057c11ULL, 0x000fc600080f4400ULL, 0x0000001003027825ULL, 0x000fca00078e0004ULL,
0x0000000802007986ULL, 0x002fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0000007c0000720cULL, 0x000fe20003f06070ULL, 0x00009800ff0e7b82ULL, 0x000e620000000a00ULL,
0xffffffffff117424ULL, 0x000fe400078e00ffULL, 0x00000001ff097424ULL, 0x000fd200078e00ffULL,
0x00009400ff068b82ULL, 0x000ea20000000800ULL, 0x0000000205078824ULL, 0x000fce00078e00ffULL,
0x00009000ff0c8b82ULL, 0x000ee20000000a00ULL, 0x000000060e0b7981ULL, 0x002f22000c1e9900ULL,
0x0000000607078224ULL, 0x004fc800078e0200ULL, 0x00000004070c8825ULL, 0x008fe400078e000cULL,
0x01760009020679a7ULL, 0x0002a6000850003fULL, 0x000000060c118981ULL, 0x000762000c1e1900ULL,
0x00008e00ff087b82ULL, 0x002e620000000a00ULL, 0x000001ff1000780cULL, 0x000fe20003f04070ULL,
0x0000004003037824ULL, 0x000fe400078e00ffULL, 0x00000040000c7824ULL, 0x008fc600078e00ffULL,
0x0000040301007387ULL, 0x0007e20000100800ULL, 0x0000001103117224ULL, 0x020fe400078e02ffULL,
0x0000004052037824ULL, 0x008fe400078e00ffULL, 0x0000008011087825ULL, 0x002fe400078e0008ULL,
0x0000000c00200947ULL, 0x004fea0003800000ULL, 0x00000003ff1f7819ULL, 0x000fe40000011604ULL,
0x0000000c7b1c7248ULL, 0x000fc60007fe0000ULL, 0x000000041f0d7836ULL, 0x000fe40000000000ULL,
0x000000011c1c7824ULL, 0x000fe400078e0a0cULL, 0x000000010d0c7824ULL, 0x140fe400078e0204ULL,
0x000000080d0f7824ULL, 0x040fe200078e00ffULL, 0x0000001c0d00720cULL, 0x080fe20003f86070ULL,
0x000000081f0d7836ULL, 0x000fe40000000000ULL, 0x0000004052527824ULL, 0x000fe200078e021fULL,
0xfffffff80f1e7812ULL, 0x000fe200078ee20cULL, 0x000000010d127824ULL, 0x040fe200078e0204ULL,
0x0000001c0d00720cULL, 0x040fe20003f06070ULL, 0x000000080d157824ULL, 0x000fc400078e00ffULL,
0x0000000c1f0f7836ULL, 0x000fe40000000000ULL, 0x00000080520c7825ULL, 0x000fe200078e00ffULL,
0xfffffff815267812ULL, 0x000fe400078ee212ULL, 0x0000001c0f00720cULL, 0x040fe20003f26070ULL,
0x0000000852107836ULL, 0x000fe20000000000ULL, 0x000000700c217812ULL, 0x000fe200078ef80aULL,
0x00000004520e7836ULL, 0x000fe40000000000ULL, 0x000000010f137824ULL, 0x040fe200078e0204ULL,
0x0000002108207210ULL, 0x000fe20007f5e0ffULL, 0x000000080f287824ULL, 0x000fc400078e00ffULL,
0x0000008010107825ULL, 0x000fc600078e00ffULL, 0xfffffff828287812ULL, 0x000fe200078ee213ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x0000007010137812ULL, 0x000fc600078ef80aULL,
0x0000000c52127836ULL, 0x000fe20000000000ULL, 0x000000700e1b7812ULL, 0x000fe200078ef80aULL,
0x0000000109217824ULL, 0x000fe200010e060dULL, 0x00000013080c7210ULL, 0x000fe20007f7e0ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000001b081a7210ULL, 0x000fc60007f5e0ffULL,
0x00000010520e7836ULL, 0x000fe20000000000ULL, 0x0000007012197812ULL, 0x000fe200078ef80aULL,
0x00000001091b7824ULL, 0x000fe400010e060fULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000001908187210ULL, 0x000fc60007f5e0ffULL, 0x0000001852147836ULL, 0x000fe20000000000ULL,
0x000000700e1d7812ULL, 0x000fe200078ef80aULL, 0x0000001c52167836ULL, 0x000fe40000000000ULL,
0x0000008014147825ULL, 0x000fc800078e00ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000007014237812ULL, 0x000fc600078ef80aULL, 0x0000000109197824ULL, 0x040fe200010e0613ULL,
0x0000001d08127210ULL, 0x000fe20007f5e0ffULL, 0x00000001090d7824ULL, 0x040fe200018e0611ULL,
0x00000070161d7812ULL, 0x000fe200078ef80aULL, 0x0000001452107836ULL, 0x000fe20000000000ULL,
0x00000023080e7210ULL, 0x000fe20007f7e0ffULL, 0x0000000109137824ULL, 0x000fe200010e060fULL,
0x0000001d08147210ULL, 0x000fe20007fbe0ffULL, 0x0000008010107825ULL, 0x000fc800078e00ffULL,
0x00000001090f7824ULL, 0x040fe200018e0615ULL, 0x0000007010257812ULL, 0x000fe200078ef80aULL,
0x0000000109157824ULL, 0x000fe200028e0617ULL, 0x0000001c1f00720cULL, 0x040fe20003fa6070ULL,
0x000000011f177824ULL, 0x000fe200078e0204ULL, 0x0000002508107210ULL, 0x000fe20007f5e0ffULL,
0x0000002052167836ULL, 0x000fe40000000000ULL, 0x000000101f237836ULL, 0x000fe20000000000ULL,
0x0000000717297812ULL, 0x000fe200078ec0ffULL, 0x0000008016167825ULL, 0x000fc600078e00ffULL,
0x0ffffff829247812ULL, 0x000fe200078ef804ULL, 0x00004000001d7824ULL, 0x000fe200078e0202ULL,
0x0000007016277812ULL, 0x000fe200078ef80aULL, 0x000000141f257836ULL, 0x000fe40000000000ULL,
0x0000000123227824ULL, 0x140fe200078e0204ULL, 0x0000002708167210ULL, 0x000fe20007fde0ffULL,
0x00000008232b7824ULL, 0x000fe200078e00ffULL, 0x0000001c2500720cULL, 0x080fe20003f66070ULL,
0x0000000109117824ULL, 0x000fe200010e0611ULL, 0x0000001c2300720cULL, 0x000fe20003f46070ULL,
0x000010001d1d7836ULL, 0x000fe20000000000ULL, 0xfffffff82b2a7812ULL, 0x000fe200078ee222ULL,
0x0000000125237824ULL, 0x000fc400078e0204ULL, 0x00000008252c7824ULL, 0x000fe400078e00ffULL,
0x0000002452227836ULL, 0x000fe40000000000ULL, 0x0000001024277824ULL, 0x100fe200078e021dULL,
0xfffffff82c2c7812ULL, 0x000fe200078ee223ULL, 0x000000101e297824ULL, 0x000fe400078e021dULL,
0x0000008022227825ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020277faeULL, 0x0003e6000e901c46ULL, 0x0000001c1f2d7836ULL, 0x000fe20000000000ULL,
0x000000001a297faeULL, 0x0005e2000e101c46ULL, 0x0000002852247836ULL, 0x000fe20000000000ULL,
0x00000070222f7812ULL, 0x000fe200078ef80aULL, 0x0000000109177824ULL, 0x000fe200030e0617ULL,
0x0000001c2d00720cULL, 0x000fe20003f86070ULL, 0x0000008024247825ULL, 0x000fe200078e00ffULL,
0x0000002f08227210ULL, 0x000fc60007fde0ffULL, 0x000000012d207824ULL, 0x042fe200078e0204ULL,
0x0000007024217812ULL, 0x000fe200078ef80aULL, 0x000000082d2d7824ULL, 0x000fe400078e00ffULL,
0x0000000109237824ULL, 0x000fe200030e0623ULL, 0x00000021081a7210ULL, 0x004fe20007fde0ffULL,
0x0000001026277824ULL, 0x000fe200078e021dULL, 0xfffffff82d247812ULL, 0x000fe200078ee220ULL,
0x0000002c52207836ULL, 0x000fe40000000000ULL, 0x000000201f297836ULL, 0x000fe20000000000ULL,
0x000000000c277faeULL, 0x0003e2000c101c46ULL, 0x0000008020207825ULL, 0x000fc600078e00ffULL,
0x0000001c2900720cULL, 0x0c0fe20003f06070ULL, 0x000000181f2b7836ULL, 0x000fe40000000000ULL,
0x0000000129267824ULL, 0x140fe400078e0204ULL, 0x00000008292d7824ULL, 0x000fe200078e00ffULL,
0x0000007020297812ULL, 0x000fe200078ef80aULL, 0x00000001091b7824ULL, 0x000fe200030e0625ULL,
0x0000001c2b00720cULL, 0x040fe20003fa6070ULL, 0x000000012b1e7824ULL, 0x040fe200078e0204ULL,
0x00000029080c7210ULL, 0x002fe20007fde0ffULL, 0x0000001028257824ULL, 0x000fe200078e021dULL,
0xfffffff82d267812ULL, 0x000fe200078ee226ULL, 0x000000082b2b7824ULL, 0x000fc400078e00ffULL,
0x00000001090d7824ULL, 0x000fe200030e0621ULL, 0x0000000018257faeULL, 0x0003e2000c901c46ULL,
0x000000102c217824ULL, 0x100fe200078e021dULL, 0xfffffff82b1e7812ULL, 0x000fe200078ee21eULL,
0x000000241f2b7836ULL, 0x000fe40000000000ULL, 0x0000001024277824ULL, 0x000fe400078e021dULL,
0x000000012b207824ULL, 0x040fe200078e0204ULL, 0x0000001c2b00720cULL, 0x040fe20003f26070ULL,
0x000000082b2b7824ULL, 0x000fc400078e00ffULL, 0x0000001026297824ULL, 0x100fe400078e021dULL,
0x000000102a197824ULL, 0x102fe200078e021dULL, 0xfffffff82b207812ULL, 0x000fe200078ee220ULL,
0x000000101e257824ULL, 0x100fe400078e021dULL, 0x000000281f2d7836ULL, 0x000fe20000000000ULL,
0x0000000012197faeULL, 0x0003e2000d101c46ULL, 0x00000010202b7824ULL, 0x000fe400078e021dULL,
0x000000301f2f7836ULL, 0x000fe20000000000ULL, 0x0000000010217faeULL, 0x0005e8000d901c46ULL,
0x000000000e257faeULL, 0x0007e2000e901c46ULL, 0x0000001c2d00720cULL, 0x000fc40003fa6070ULL,
0x0000001c2f00720cULL, 0x080fe20003f66070ULL, 0x0000000014277faeULL, 0x000fe2000e101c46ULL,
0x0000002c1f197836ULL, 0x002fe40000000000ULL, 0x000000012d137824ULL, 0x000fe200078e0204ULL,
0x0000000016297faeULL, 0x0003e2000c101c46ULL, 0x0000003052107836ULL, 0x004fe20000000000ULL,
0x0000001c1900720cULL, 0x000fe20003f86070ULL, 0x000000341f217836ULL, 0x000fe20000000000ULL,
0x00000000222b7faeULL, 0x0005e2000c901c46ULL, 0x00000080100e7825ULL, 0x008fc600078e00ffULL,
0x0000001c2100720cULL, 0x080fe20003f46070ULL, 0x0000003452107836ULL, 0x000fe20000000000ULL,
0x000000700e117812ULL, 0x000fe200078ef80aULL, 0x000000381f257836ULL, 0x000fe40000000000ULL,
0x000000082d167824ULL, 0x002fe200078e00ffULL, 0x0000001108127210ULL, 0x000fe20007fde0ffULL,
0x0000003c1f1f7836ULL, 0x000fe20000000000ULL, 0x0000001c2500720cULL, 0x000fe20003f26070ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0xfffffff816167812ULL, 0x000fc400078ee213ULL,
0x0000001c1f00720cULL, 0x000fe20003f06070ULL, 0x0000000109137824ULL, 0x000fe200030e060fULL,
0x0000007010157812ULL, 0x000fe200078ef80aULL, 0x00000001190e7824ULL, 0x140fe400078e0204ULL,
0x0000000819197824ULL, 0x000fe200078e00ffULL, 0x0000001508147210ULL, 0x000fe20007fde0ffULL,
0x000000012f0f7824ULL, 0x040fe400078e0204ULL, 0x000000082f1c7824ULL, 0x000fe200078e00ffULL,
0xfffffff819187812ULL, 0x000fe200078ee20eULL, 0x0000003852107836ULL, 0x000fc40000000000ULL,
0x0000000121177824ULL, 0x000fe200078e0204ULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee20fULL,
0x00000080100e7825ULL, 0x000fc800078e00ffULL, 0x0000003c52107836ULL, 0x000fe40000000000ULL,
0x00000008211e7824ULL, 0x000fe200078e00ffULL, 0x000000700e217812ULL, 0x000fe200078ef80aULL,
0x0000000109157824ULL, 0x000fe400030e0611ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x00000021080e7210ULL, 0x000fc60007fde0ffULL, 0x0000000125197824ULL, 0x140fe200078e0204ULL,
0x0000007010217812ULL, 0x000fe200078ef80aULL, 0x0000000825227824ULL, 0x004fe400078e00ffULL,
0x000000011f207824ULL, 0x040fe200078e0204ULL, 0xfffffff81e047812ULL, 0x000fe200078ee217ULL,
0x000000081f1f7824ULL, 0x000fe200078e00ffULL, 0xfffffff8221e7812ULL, 0x000fe200078ee219ULL,
0x00000001090f7824ULL, 0x000fe200030e060fULL, 0x0000002108087210ULL, 0x000fe20007fde0ffULL,
0x0000001016177824ULL, 0x100fe200078e021dULL, 0xfffffff81f207812ULL, 0x000fe200078ee220ULL,
0x0000001018197824ULL, 0x000fc400078e021dULL, 0x000000101c1f7824ULL, 0x100fe200078e021dULL,
0x000000001a177faeULL, 0x0003e2000e901c46ULL, 0x0000001004217824ULL, 0x100fe400078e021dULL,
0x000000101e237824ULL, 0x100fe200078e021dULL, 0x000000000c197faeULL, 0x0003e2000e101c46ULL,
0x00000010201d7824ULL, 0x000fe400078e021dULL, 0x0000000109097824ULL, 0x000fe200030e0611ULL,
0x00000000121f7faeULL, 0x0003e8000d901c46ULL, 0x0000000014217faeULL, 0x0003e8000d101c46ULL,
0x000000000e237faeULL, 0x0003e8000c901c46ULL, 0x00000000081d7faeULL, 0x0003e2000c101c46ULL,
0x0000000800d07947ULL, 0x000fea0003800000ULL, 0x00000004040e7811ULL, 0x000fe200078fe8ffULL,
0x00004000002e7824ULL, 0x000fe200078e0202ULL, 0x0000001404157811ULL, 0x040fe400078fe8ffULL,
0x0000001004137811ULL, 0x000fe200078fe8ffULL, 0x000000010e0c7824ULL, 0x100fe200078e0204ULL,
0x0000000c04117811ULL, 0x000fe200078fe8ffULL, 0x000000080e1d7824ULL, 0x000fe200078e00ffULL,
0x0000000804107811ULL, 0x040fe200078fe8ffULL, 0x0000000115127824ULL, 0x140fe200078e0204ULL,
0x0000002004187811ULL, 0x040fe200078fe8ffULL, 0x0000000815177824ULL, 0x000fe200078e00ffULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee20cULL, 0x00000001130f7824ULL, 0x140fe200078e0204ULL,
0x0000002c042a7811ULL, 0x040fe200078fe8ffULL, 0x0000000813167824ULL, 0x000fe200078e00ffULL,
0xfffffff817127812ULL, 0x000fe200078ee212ULL, 0x00000001110d7824ULL, 0x140fe200078e0204ULL,
0x0000001c04177811ULL, 0x000fe200078fe8ffULL, 0x0000000811147824ULL, 0x000fe200078e00ffULL,
0xfffffff816237812ULL, 0x000fe200078ee20fULL, 0x00000001100c7824ULL, 0x100fe200078e0204ULL,
0x0000001804167811ULL, 0x000fe200078fe8ffULL, 0x00000008101f7824ULL, 0x000fe200078e00ffULL,
0xfffffff814217812ULL, 0x000fe200078ee20dULL, 0x00000001170d7824ULL, 0x140fe200078e0204ULL,
0x00000028042b7811ULL, 0x000fe200078fe8ffULL, 0x0000000817147824ULL, 0x000fe200078e00ffULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee20cULL, 0x00000001160c7824ULL, 0x100fe200078e0204ULL,
0x0000002404197811ULL, 0x000fe200078fe8ffULL, 0x0000000816277824ULL, 0x000fe200078e00ffULL,
0xfffffff814147812ULL, 0x000fe200078ee20dULL, 0x00000001180f7824ULL, 0x100fe200078e0204ULL,
0x00000030041e7811ULL, 0x000fe200078fe8ffULL, 0x00000008181a7824ULL, 0x000fe200078e00ffULL,
0xfffffff827277812ULL, 0x000fe200078ee20cULL, 0x000000012a0d7824ULL, 0x100fe200078e0204ULL,
0x00000034041c7811ULL, 0x000fe200078fe8ffULL, 0x000000082a287824ULL, 0x000fe200078e00ffULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee20fULL, 0x000000012b0c7824ULL, 0x140fe200078e0204ULL,
0x0000003804267811ULL, 0x040fe200078fe8ffULL, 0x000000082b257824ULL, 0x000fe200078e00ffULL,
0xfffffff828287812ULL, 0x000fe200078ee20dULL, 0x00000001191b7824ULL, 0x140fe200078e0204ULL,
0x00000004040d7211ULL, 0x000fe200078fe8ffULL, 0x0000000819207824ULL, 0x000fe200078e00ffULL,
0xfffffff825227812ULL, 0x000fe200078ee20cULL, 0x000000011e0f7824ULL, 0x100fe200078e0204ULL,
0x00000003040c7211ULL, 0x000fe200078fe8ffULL, 0x000000081e247824ULL, 0x000fe200078e00ffULL,
0xfffffff820207812ULL, 0x000fe200078ee21bULL, 0x000000011c1b7824ULL, 0x000fc400078e0204ULL,
0x000000081c2c7824ULL, 0x000fe200078e00ffULL, 0xfffffff824297812ULL, 0x000fe200078ee20fULL,
0x0000000126257824ULL, 0x100fe200078e0204ULL, 0x0000003c04247811ULL, 0x000fe200078fe8ffULL,
0x0000000826307824ULL, 0x000fe200078e00ffULL, 0x000000070d0f7812ULL, 0x000fe200078ec0ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0xfffffff82c2c7812ULL, 0x000fe400078ee21bULL,
0x0ffffff80f1b7812ULL, 0x000fe200078ef804ULL, 0x0000000124047824ULL, 0x040fe200078e0204ULL,
0xfffffff8302d7812ULL, 0x000fe200078ee225ULL, 0x00000008240f7824ULL, 0x000fe200078e00ffULL,
0x000000700c257812ULL, 0x000fe200078ef80aULL, 0x00000001030e7824ULL, 0x000fc400078e020eULL,
0x000010002e2e7836ULL, 0x000fe20000000000ULL, 0xfffffff80f307812ULL, 0x000fe200078ee204ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x00000025080c7210ULL, 0x000fc60007f1e0ffULL,
0x0000001012257824ULL, 0x000fe200078e022eULL, 0x000000700e2f7812ULL, 0x000fe200078ef80aULL,
0x0000000103107824ULL, 0x040fe400078e0210ULL, 0x0000000103127824ULL, 0x040fe200078e0211ULL,
0x0000002f080e7210ULL, 0x000fe20007f3e0ffULL, 0x0000001014047824ULL, 0x000fe400078e022eULL,
0x0000000103147824ULL, 0x000fe400078e0213ULL, 0x0000008010107825ULL, 0x000fc800078e00ffULL,
0x000000101b1b7824ULL, 0x100fe200078e022eULL, 0x0000007010377812ULL, 0x000fe200078ef80aULL,
0x000000101d1d7824ULL, 0x100fe400078e022eULL, 0x000000101f1f7824ULL, 0x100fe400078e022eULL,
0x0000001021217824ULL, 0x100fe400078e022eULL, 0x0000001023237824ULL, 0x100fe400078e022eULL,
0x0000001027277824ULL, 0x000fc400078e022eULL, 0x000000101a1a7824ULL, 0x100fe400078e022eULL,
0x0000001020207824ULL, 0x100fe400078e022eULL, 0x0000001022227824ULL, 0x100fe400078e022eULL,
0x0000001028287824ULL, 0x100fe400078e022eULL, 0x0000001029297824ULL, 0x100fe400078e022eULL,
0x000000102c2c7824ULL, 0x000fc400078e022eULL, 0x000000102d2d7824ULL, 0x100fe400078e022eULL,
0x0000001030307824ULL, 0x000fe400078e022eULL, 0x0000008012127825ULL, 0x000fc800078e00ffULL,
0x00000001032e7824ULL, 0x000fe200078e0215ULL, 0x0000007012317812ULL, 0x000fe200078ef80aULL,
0x00000001090d7824ULL, 0x000fe200000e060dULL, 0x0000003708107210ULL, 0x000fe20007f1e0ffULL,
0x000000802e2e7825ULL, 0x000fc600078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c1b7faeULL, 0x0003e2000b901c46ULL, 0x0000000103327824ULL, 0x000fe400078e0216ULL,
0x00000001090f7824ULL, 0x040fe200008e060fULL, 0x0000003108127210ULL, 0x000fe20007f3e0ffULL,
0x0000008032327825ULL, 0x000fe200078e00ffULL, 0x000000702e317812ULL, 0x000fe400078ef80aULL,
0x000000000e1d7faeULL, 0x0003e2000b901c46ULL, 0x0000000109117824ULL, 0x000fe200000e0611ULL,
0x0000003108167210ULL, 0x000fe20007f1e0ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000007032317812ULL, 0x000fc400078ef80aULL, 0x00000000101f7faeULL, 0x0003e2000b901c46ULL,
0x00000001032e7824ULL, 0x000fe200078e0217ULL, 0x0000007014357812ULL, 0x000fe200078ef80aULL,
0x0000000109177824ULL, 0x000fe400000e062fULL, 0x0000000103327824ULL, 0x000fe200078e0218ULL,
0x0000003108187210ULL, 0x000fe20007f1e0ffULL, 0x000000802e2e7825ULL, 0x000fe200078e00ffULL,
0x0000003508147210ULL, 0x000fc60007f5e0ffULL, 0x0000000103347824ULL, 0x040fe200078e0219ULL,
0x000000702e317812ULL, 0x000fe200078ef80aULL, 0x0000000103367824ULL, 0x000fe400078e022bULL,
0x0000000109197824ULL, 0x000fe400000e0633ULL, 0x0000008032327825ULL, 0x000fc800078e00ffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x00000070322b7812ULL, 0x000fc600078ef80aULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000007034397812ULL, 0x000fc600078ef80aULL,
0x0000000103387824ULL, 0x000fe200078e022aULL, 0x00000031082a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000109137824ULL, 0x040fe200008e0613ULL, 0x0000007036317812ULL, 0x000fe200078ef80aULL,
0x0000000109157824ULL, 0x040fe200010e0615ULL, 0x0000002b082e7210ULL, 0x000fe20007f3e0ffULL,
0x00000001092b7824ULL, 0x000fe200000e062fULL, 0x0000003908327210ULL, 0x000fe20007f1e0ffULL,
0x0000008038387825ULL, 0x000fe200078e00ffULL, 0x0000003108347210ULL, 0x000fe20007f5e0ffULL,
0x0000000012217faeULL, 0x0003e4000b901c46ULL, 0x0000000103367824ULL, 0x000fe200078e021eULL,
0x0000007038317812ULL, 0x000fe200078ef80aULL, 0x00000001092f7824ULL, 0x000fe200008e0633ULL,
0x0000000014237faeULL, 0x0003e2000b901c46ULL, 0x00000001033a7824ULL, 0x000fc400078e021cULL,
0x0000000109337824ULL, 0x000fe200000e0635ULL, 0x0000003108387210ULL, 0x000fe20007f1e0ffULL,
0x00000001033c7824ULL, 0x000fe200078e0226ULL, 0x0000000016257faeULL, 0x0003e2000b901c46ULL,
0x0000000109357824ULL, 0x000fe400010e0637ULL, 0x00000001033e7824ULL, 0x000fe200078e0224ULL,
0x0000000018277faeULL, 0x0003e2000b901c46ULL, 0x0000008036367825ULL, 0x000fc600078e00ffULL,
0x000000002a047faeULL, 0x0003e2000b901c46ULL, 0x000000803a3a7825ULL, 0x000fe200078e00ffULL,
0x0000007036457812ULL, 0x000fe400078ef80aULL, 0x000000002e1a7faeULL, 0x0003e2000b901c46ULL,
0x000000803c3c7825ULL, 0x000fe200078e00ffULL, 0x000000703a437812ULL, 0x000fe400078ef80aULL,
0x0000000032207faeULL, 0x0003e2000b901c46ULL, 0x000000803e3e7825ULL, 0x000fe200078e00ffULL,
0x000000703c417812ULL, 0x000fc400078ef80aULL, 0x00000043083a7210ULL, 0x000fe20007f3e0ffULL,
0x0000000109397824ULL, 0x040fe200000e0639ULL, 0x000000703e317812ULL, 0x000fe200078ef80aULL,
0x0000000034227faeULL, 0x0003e2000b901c46ULL, 0x0000004508367210ULL, 0x000fe20007f1e0ffULL,
0x00000001093b7824ULL, 0x040fe200008e063bULL, 0x00000041083c7210ULL, 0x000fe20007f5e0ffULL,
0x0000000038287faeULL, 0x0003e2000b901c46ULL, 0x0000003108087210ULL, 0x000fe20007f7e0ffULL,
0x0000000109377824ULL, 0x040fe400000e0637ULL, 0x00000001093d7824ULL, 0x000fc400010e063dULL,
0x0000000109097824ULL, 0x000fe200018e063fULL, 0x0000000036297faeULL, 0x0003e8000b901c46ULL,
0x000000003a2c7faeULL, 0x0003e8000b901c46ULL, 0x000000003c2d7faeULL, 0x0003e8000b901c46ULL,
0x0000000008307faeULL, 0x0003e4000b901c46ULL, 0x00000004006e7836ULL, 0x000fe20000000000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffffff7a7424ULL, 0x000fc600078e00ffULL,
0x0000007c6e00720cULL, 0x000fda0003f06070ULL, 0x00009400ff048b82ULL, 0x002e620000000800ULL,
0x00000002050d8824ULL, 0x000fce00078e00ffULL, 0x00009000ff088b82ULL, 0x000ea20000000a00ULL,
0x000000040d0d8224ULL, 0x002fc800078e026eULL, 0x000000040d088825ULL, 0x004fca00078e0008ULL,
0x00000006087a8981ULL, 0x000324000c1e1900ULL, 0x0000000000087805ULL, 0x002fce0000015200ULL,
0x01760007020075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff0a7224ULL, 0x000fce00078e00ffULL, 0x000000100a00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000000c7805ULL, 0x000fce0000015200ULL,
0x0000000c080f7210ULL, 0x000fca0007f1e1ffULL, 0x000000010d0d7824ULL, 0x000fe200000e0e09ULL,
0x003d09000f00780cULL, 0x000fc80003f06070ULL, 0x000000ff0d00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400f00780cULL, 0x000fc80003f06070ULL,
0x000000ff0d00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc8000001140dULL, 0x0000000f04047211ULL, 0x000fca00078110ffULL,
0x000000ffff0d7224ULL, 0x000fca00000e060dULL, 0x0000000204047819ULL, 0x000fc8000000120dULL,
0x000000040000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000010a0a7836ULL, 0x000fce0000000000ULL, 0x01760007020075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000000077919ULL, 0x000e640000000000ULL,
0x0000002000047824ULL, 0x002fca00078e0207ULL, 0x00000003ff067819ULL, 0x000fc80000011604ULL,
0x1ffffffe06077812ULL, 0x000fe400078ec0ffULL, 0x0000000f04067812ULL, 0x000fc600078ec0ffULL,
0x0000000104077824ULL, 0x000fe400078e0207ULL, 0x0000001006087824ULL, 0x040fe400078e00ffULL,
0x0000000107047836ULL, 0x000fe20000000000ULL, 0x0000000f07077812ULL, 0x000fe200078ec0ffULL,
0x0000001006097824ULL, 0x000fc600078e00ffULL, 0x0000000f04047812ULL, 0x000fe400078ec0ffULL,
0x000000f008077812ULL, 0x000fe400078ee207ULL, 0x000000f009097812ULL, 0x000fc600078ee204ULL,
0x0000001007077824ULL, 0x100fe400078e0202ULL, 0x0000001009097824ULL, 0x000fc600078e0202ULL,
0x0000000007107984ULL, 0x000e680000000c00ULL, 0x00000000090c7984ULL, 0x000ea20000000c00ULL,
0x000000ffff147224ULL, 0x002fe400078e0010ULL, 0x000000ffff157224ULL, 0x000fe400078e0012ULL,
0x000000ffff107224ULL, 0x000fe400078e0011ULL, 0x000000ffff117224ULL, 0x000fc400078e0013ULL,
0x000000ffff167224ULL, 0x004fe400078e000cULL, 0x000000ffff177224ULL, 0x000fe400078e000eULL,
0x000000ffff127224ULL, 0x000fe400078e000dULL, 0x000000ffff137224ULL, 0x000fe200078e000fULL,
0x0000001407007388ULL, 0x0003e20000000c00ULL, 0x00000001ff0d7424ULL, 0x000fc600078e00ffULL,
0x0000001009007388ULL, 0x0003e60000000c00ULL, 0x0176000d020c79a7ULL, 0x0002a4000850003fULL,
0x0000000000067805ULL, 0x002fce0000015200ULL, 0x0176000d020075a7ULL, 0x004e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff0a7224ULL, 0x000fce00078e00ffULL,
0x000000100a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fce0000015200ULL, 0x00000008060f7210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e07ULL, 0x003d09000f00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400f00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc80000011409ULL,
0x0000000f04047211ULL, 0x000fca00078110ffULL, 0x000000ffff097224ULL, 0x000fca00000e0609ULL,
0x0000000204047819ULL, 0x000fc80000001209ULL, 0x000000040000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000010a0a7836ULL, 0x000fce0000000000ULL,
0x0176000d020075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000ff7d00720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x00009400ff067b82ULL, 0x000e620000000800ULL, 0x0000000000047919ULL, 0x000ea20000000000ULL,
0x0000004000087824ULL, 0x040fe200078e00ffULL, 0x0000840000097ab9ULL, 0x000fe20000000800ULL,
0x0000002000707824ULL, 0x000fe200078e0202ULL, 0x0000001f09047890ULL, 0x000fe2000fffe03fULL,
0x0000010008077836ULL, 0x000fe20000000000ULL, 0xffffffff09057890ULL, 0x000fe4000fffe03fULL,
0x800000097b087c36ULL, 0x000fe20008000000ULL, 0x000000043f047899ULL, 0x000fe20008011604ULL,
0x000000ffff697224ULL, 0x000fe200078e00ffULL, 0x0000000909087890ULL, 0x000fe2000fffe03fULL,
0x000000ffff077224ULL, 0x000fe200078e00ffULL, 0x00000008ff087819ULL, 0x000fe20000011608ULL,
0x0ffffffe04047892ULL, 0x000fe2000f8ec03fULL, 0x0000000605057224ULL, 0x002fc400078e02ffULL,
0x3db504f30b057820ULL, 0x010fe20000410000ULL, 0x0000000800067824ULL, 0x000fd000078e0202ULL,
0x00000400010b7983ULL, 0x000ee20000100800ULL, 0x00008e00ff087b82ULL, 0x000e620000000a00ULL,
0x00000002690a7836ULL, 0x000fe20000000000ULL, 0x00000001076f7812ULL, 0x000fc800078e0cffULL,
0x0000007d0a00720cULL, 0x000fe20003f06070ULL, 0x0000007a0b0b7224ULL, 0x018fc800078e02ffULL,
0x000000800b087825ULL, 0x002fd000078e0008ULL, 0x0000000c00388947ULL, 0x000fea0003800000ULL,
0x00000040000c7824ULL, 0x040fe200078e00ffULL, 0x00000003ff0d7819ULL, 0x004fe20000011604ULL,
0x0000400000187824ULL, 0x000fe400078e0202ULL, 0x000001000c0c7836ULL, 0x000fe40000000000ULL,
0x000000040d0f7836ULL, 0x000fe40000000000ULL, 0x00000100690c7824ULL, 0x000fe400078e020cULL,
0x0000000c0d177836ULL, 0x000fc40000000000ULL, 0x000000080d157836ULL, 0x000fe20000000000ULL,
0x0000000c7b0b7248ULL, 0x000fe20007fe0000ULL, 0x000000010f0a7824ULL, 0x140fe400078e0204ULL,
0x000000080f117824ULL, 0x000fe400078e00ffULL, 0x00000001170e7824ULL, 0x040fe400078e0204ULL,
0x0000000817137824ULL, 0x000fe200078e00ffULL, 0xfffffff811207812ULL, 0x000fe200078ee20aULL,
0x000000010b0c7824ULL, 0x000fc400078e0a0cULL, 0x00000001150b7824ULL, 0x140fe200078e0204ULL,
0xfffffff813247812ULL, 0x000fe200078ee20eULL, 0x0000000815227824ULL, 0x000fe200078e00ffULL,
0x0000000c0f00720cULL, 0x080fe20003f46070ULL, 0x000000100d197836ULL, 0x000fe20000000000ULL,
0x0000000c1700720cULL, 0x080fe20003fa6070ULL, 0x00000010040a7824ULL, 0x000fe200078e00ffULL,
0xfffffff822227812ULL, 0x000fe200078ee20bULL, 0x00000001030e7824ULL, 0x000fe200078e020dULL,
0x0000000c1500720cULL, 0x080fe20003f66070ULL, 0x0000000103107824ULL, 0x000fe200078e020fULL,
0x000000700a0a7812ULL, 0x000fe200078ec0ffULL, 0x000000140d1f7836ULL, 0x000fe20000000000ULL,
0x0000000c1900720cULL, 0x040fe20003f86070ULL, 0x00000001190b7824ULL, 0x000fc400078e0204ULL,
0x0000000819267824ULL, 0x000fe400078e00ffULL, 0x000000800e0e7825ULL, 0x000fc600078e00ffULL,
0xfffffff826267812ULL, 0x000fe200078ee20bULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000000a0e137212ULL, 0x000fc600078efcffULL, 0x000000011f147824ULL, 0x140fe200078e0204ULL,
0x0000000a100b7212ULL, 0x000fe200078efcffULL, 0x000000081f1b7824ULL, 0x000fe200078e00ffULL,
0x0000001308127210ULL, 0x000fe20007f1e0ffULL, 0x000000180d217836ULL, 0x000fe20000000000ULL,
0x0000000b080e7210ULL, 0x000fe20007f3e0ffULL, 0x0000000103107824ULL, 0x040fe200078e0215ULL,
0xfffffff81b287812ULL, 0x000fe200078ee214ULL, 0x0000000103147824ULL, 0x000fe400078e0217ULL,
0x00000001211e7824ULL, 0x000fc400078e0204ULL, 0x00000008211d7824ULL, 0x000fe400078e00ffULL,
0x000000010d177824ULL, 0x000fe400078e0204ULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0xfffffff81d1e7812ULL, 0x000fe400078ee21eULL, 0x00000007171d7812ULL, 0x000fe200078ec0ffULL,
0x0000000103167824ULL, 0x000fe200078e0219ULL, 0x0000000a14197212ULL, 0x000fe200078efcffULL,
0x0000000109137824ULL, 0x000fc400000e060fULL, 0x00000001090f7824ULL, 0x000fe200008e0611ULL,
0x0000001908147210ULL, 0x000fe20007fde0ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000000c0d00720cULL, 0x000fc60003f26070ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000000a101b7212ULL, 0x000fc600078efcffULL, 0x000020006f0b7824ULL, 0x000fe200078e0218ULL,
0x0000000a16197212ULL, 0x000fe200078efcffULL, 0x0000000109157824ULL, 0x000fe200030e0615ULL,
0x0ffffff81d167812ULL, 0x000fe200078ef804ULL, 0x000010000b0b7836ULL, 0x000fe20000000000ULL,
0x0000001b081a7210ULL, 0x000fe20007f1e0ffULL, 0x000000200d257836ULL, 0x000fe20000000000ULL,
0x0000001908107210ULL, 0x000fe20007fde0ffULL, 0x0000001016197824ULL, 0x000fe400078e020bULL,
0x0000000103167824ULL, 0x000fc400078e021fULL, 0x00000001091b7824ULL, 0x040fe200000e0611ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012197faeULL, 0x0003e2000c901c46ULL,
0x0000000109117824ULL, 0x000fe200030e0617ULL, 0x0000000c2100720cULL, 0x080fe20003f26070ULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000000c1f00720cULL, 0x000fc60003f06070ULL,
0x00000001031c7824ULL, 0x000fe200078e0221ULL, 0x0000000a161d7212ULL, 0x000fe200078efcffULL,
0x0000000125167824ULL, 0x040fe400078e0204ULL, 0x0000000825217824ULL, 0x000fe200078e00ffULL,
0x0000001d08127210ULL, 0x002fe20007fde0ffULL, 0x0000001c0d237836ULL, 0x000fe40000000000ULL,
0x0000001020197824ULL, 0x000fe200078e020bULL, 0xfffffff8212c7812ULL, 0x000fe200078ee216ULL,
0x0000000109137824ULL, 0x000fc400030e0617ULL, 0x000000801c167825ULL, 0x000fe200078e00ffULL,
0x000000000e197faeULL, 0x0003e2000d101c46ULL, 0x0000000c2300720cULL, 0x000fe40003f46070ULL,
0x00000001031c7824ULL, 0x000fe200078e0223ULL, 0x0000000a161d7212ULL, 0x000fe200078efcffULL,
0x00000001231f7824ULL, 0x040fe400078e0204ULL, 0x00000008232a7824ULL, 0x000fe200078e00ffULL,
0x0000001d08167210ULL, 0x000fe20007fde0ffULL, 0x000000801c1c7825ULL, 0x000fc600078e00ffULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee21fULL, 0x0000000103207824ULL, 0x000fe200078e0225ULL,
0x0000000a1c217212ULL, 0x000fe200078efcffULL, 0x00000010221f7824ULL, 0x000fe400078e020bULL,
0x00000080200e7825ULL, 0x002fc600078e00ffULL, 0x000000001a1f7faeULL, 0x0003e2000d901c46ULL,
0x0000000109177824ULL, 0x000fe200030e0617ULL, 0x0000000c2500720cULL, 0x080fe20003f66070ULL,
0x000000240d237836ULL, 0x000fe40000000000ULL, 0x0000001024197824ULL, 0x000fe400078e020bULL,
0x0000000123207824ULL, 0x040fe400078e0204ULL, 0x0000000823257824ULL, 0x040fe200078e00ffULL,
0x0000000014197faeULL, 0x0005e2000e901c46ULL, 0x0000000c2300720cULL, 0x000fe20003fa6070ULL,
0x000000380d277836ULL, 0x000fe20000000000ULL, 0x00000021081a7210ULL, 0x002fe20007fde0ffULL,
0x0000003c0d297836ULL, 0x000fe20000000000ULL, 0x0000000a0e1f7212ULL, 0x000fe200078efcffULL,
0x00000001030e7824ULL, 0x000fe200078e0223ULL, 0xfffffff825207812ULL, 0x000fe200078ee220ULL,
0x00000001091b7824ULL, 0x000fe200030e061dULL, 0x0000001f081c7210ULL, 0x000fe20007fde0ffULL,
0x00000010261f7824ULL, 0x000fc400078e020bULL, 0x000000800e147825ULL, 0x004fc600078e00ffULL,
0x00000000101f7faeULL, 0x0003e2000e101c46ULL, 0x000000280d197836ULL, 0x000fe40000000000ULL,
0x00000001091d7824ULL, 0x000fe200030e060fULL, 0x0000000a140f7212ULL, 0x000fe200078efcffULL,
0x0000000119217824ULL, 0x040fe200078e0204ULL, 0x0000000c1900720cULL, 0x040fe20003f86070ULL,
0x0000000819227824ULL, 0x000fe200078e00ffULL, 0x0000000f08147210ULL, 0x000fe20007fde0ffULL,
0x00000001030e7824ULL, 0x000fe400078e0219ULL, 0x000000300d257836ULL, 0x000fe20000000000ULL,
0xfffffff822227812ULL, 0x000fe200078ee221ULL, 0x000000800e0e7825ULL, 0x000fc800078e00ffULL,
0x0000002c0d217836ULL, 0x000fe20000000000ULL, 0x0000000a0e117212ULL, 0x002fe200078efcffULL,
0x0000001028197824ULL, 0x000fe400078e020bULL, 0x0000000103107824ULL, 0x000fe400078e0221ULL,
0x0000000109157824ULL, 0x000fe200030e0615ULL, 0x00000011080e7210ULL, 0x000fe20007fde0ffULL,
0x00000001031f7824ULL, 0x000fe200078e0225ULL, 0x0000000012197faeULL, 0x0003e2000c101c46ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000000c2100720cULL, 0x000fc60003f06070ULL,
0x00000001090f7824ULL, 0x000fe400030e060fULL, 0x0000000121237824ULL, 0x040fe400078e0204ULL,
0x0000000821247824ULL, 0x000fe400078e00ffULL, 0x0000000825217824ULL, 0x000fe400078e00ffULL,
0x000000101e197824ULL, 0x002fe200078e020bULL, 0xfffffff824247812ULL, 0x000fe200078ee223ULL,
0x000000801f127825ULL, 0x000fe200078e00ffULL, 0x0000000a101f7212ULL, 0x000fc400078efcffULL,
0x0000000016197faeULL, 0x0003e2000c901c46ULL, 0x00000001251e7824ULL, 0x040fe200078e0204ULL,
0x0000001f08107210ULL, 0x000fe40007fde0ffULL, 0x0000000c2500720cULL, 0x000fe20003f26070ULL,
0x000000340d257836ULL, 0x000fe20000000000ULL, 0x0000000a121f7212ULL, 0x000fe200078efcffULL,
0x0000000109117824ULL, 0x000fe200030e0611ULL, 0xfffffff8211e7812ULL, 0x000fe200078ee21eULL,
0x0000001020217824ULL, 0x100fe200078e020bULL, 0x0000001f08127210ULL, 0x000fe20007fde0ffULL,
0x000000102a1f7824ULL, 0x000fc400078e020bULL, 0x0000000103167824ULL, 0x002fe400078e0225ULL,
0x000000102c197824ULL, 0x000fe200078e020bULL, 0x000000001a1f7faeULL, 0x0003e2000d101c46ULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000000c2900720cULL, 0x000fe40003f46070ULL,
0x000000001c197faeULL, 0x0005e2000d901c46ULL, 0x00000001030d7824ULL, 0x000fe200078e0227ULL,
0x0000000a16237212ULL, 0x000fe200078efcffULL, 0x0000000109137824ULL, 0x000fe200030e0613ULL,
0x0000000014217faeULL, 0x0007e2000e901c46ULL, 0x0000000c2500720cULL, 0x080fe20003fa6070ULL,
0x0000000829207824ULL, 0x000fe200078e00ffULL, 0x0000000c2700720cULL, 0x000fe20003f66070ULL,
0x000000800d0c7825ULL, 0x000fe200078e00ffULL, 0x0000002308167210ULL, 0x000fc60007fde0ffULL,
0x00000001251a7824ULL, 0x002fe200078e0204ULL, 0x0000000a0c197212ULL, 0x004fe200078efcffULL,
0x0000000109177824ULL, 0x000fe400030e0617ULL, 0x0000000103147824ULL, 0x008fe200078e0229ULL,
0x00000019080c7210ULL, 0x000fe20007fde0ffULL, 0x0000000825257824ULL, 0x000fe400078e00ffULL,
0x0000008014147825ULL, 0x000fc600078e00ffULL, 0xfffffff8251a7812ULL, 0x000fe200078ee21aULL,
0x00000001271b7824ULL, 0x140fe200078e0204ULL, 0x0000000a141f7212ULL, 0x000fe200078efcffULL,
0x00000008271c7824ULL, 0x000fe400078e00ffULL, 0x00000001291d7824ULL, 0x000fe400078e0204ULL,
0x00000001090d7824ULL, 0x000fe200030e060dULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee21bULL,
0x0000001022197824ULL, 0x100fe200078e020bULL, 0xfffffff820207812ULL, 0x000fe200078ee21dULL,
0x00000010241b7824ULL, 0x100fe200078e020bULL, 0x0000001f08087210ULL, 0x000fe20007fde0ffULL,
0x000000101e1d7824ULL, 0x100fe200078e020bULL, 0x000000000e197faeULL, 0x0003e2000e101c46ULL,
0x000000101a1f7824ULL, 0x000fc400078e020bULL, 0x000000101c217824ULL, 0x100fe200078e020bULL,
0x00000000101b7faeULL, 0x0003e2000c101c46ULL, 0x00000010200b7824ULL, 0x000fe400078e020bULL,
0x0000000109097824ULL, 0x000fe200030e0615ULL, 0x00000000121d7faeULL, 0x0003e8000c901c46ULL,
0x00000000161f7faeULL, 0x0003e8000e901c46ULL, 0x000000000c217faeULL, 0x0003e8000d901c46ULL,
0x00000000080b7faeULL, 0x0003e2000d101c46ULL, 0x0000000800dc7947ULL, 0x000fea0003800000ULL,
0x00000004040c7811ULL, 0x044fe200078fe8ffULL, 0x0000001004197824ULL, 0x040fe200078e00ffULL,
0x0000000804107811ULL, 0x000fe200078fe8ffULL, 0x0000400000187824ULL, 0x000fe200078e0202ULL,
0x0000000c04117811ULL, 0x000fe200078fe8ffULL, 0x000000010c0a7824ULL, 0x100fe200078e0204ULL,
0x0000001004127811ULL, 0x000fe200078fe8ffULL, 0x000000080c257824ULL, 0x000fe200078e00ffULL,
0x0000001404137811ULL, 0x000fe200078fe8ffULL, 0x00000001100b7824ULL, 0x100fe200078e0204ULL,
0x0000001804157811ULL, 0x000fe200078fe8ffULL, 0x00000008100e7824ULL, 0x000fe200078e00ffULL,
0xfffffff825257812ULL, 0x000fe200078ee20aULL, 0x00000001110a7824ULL, 0x140fe200078e0204ULL,
0x0000001c041e7811ULL, 0x000fe200078fe8ffULL, 0x0000000811297824ULL, 0x000fe200078e00ffULL,
0xfffffff80e277812ULL, 0x000fe200078ee20bULL, 0x00000001120b7824ULL, 0x100fe200078e0204ULL,
0x00000020041b7811ULL, 0x000fe200078fe8ffULL, 0x0000000812147824ULL, 0x000fe200078e00ffULL,
0xfffffff829297812ULL, 0x000fe200078ee20aULL, 0x00000001130d7824ULL, 0x140fe200078e0204ULL,
0x00000024041a7811ULL, 0x040fe200078fe8ffULL, 0x0000000813167824ULL, 0x000fe200078e00ffULL,
0xfffffff814377812ULL, 0x000fe200078ee20bULL, 0x00000001150e7824ULL, 0x140fe200078e0204ULL,
0x00000028041d7811ULL, 0x040fe200078fe8ffULL, 0x0000000815337824ULL, 0x000fe200078e00ffULL,
0x0000002c041c7811ULL, 0x000fe200078fe8ffULL, 0x000000011e0a7824ULL, 0x100fe200078e0204ULL,
0x0000003004327811ULL, 0x000fe200078fe8ffULL, 0x000000081e317824ULL, 0x000fe200078e00ffULL,
0xfffffff816357812ULL, 0x000fe200078ee20dULL, 0x000000011b0b7824ULL, 0x140fe200078e0204ULL,
0xfffffff833337812ULL, 0x000fe200078ee20eULL, 0x000000081b147824ULL, 0x000fe200078e00ffULL,
0xfffffff831317812ULL, 0x000fe200078ee20aULL, 0x000000011a0d7824ULL, 0x100fe200078e0204ULL,
0x00000034042e7811ULL, 0x000fe200078fe8ffULL, 0x000000081a167824ULL, 0x000fe200078e00ffULL,
0xfffffff8142f7812ULL, 0x000fe200078ee20bULL, 0x000000011d0e7824ULL, 0x140fe200078e0204ULL,
0x00000038042c7811ULL, 0x000fe200078fe8ffULL, 0x000000081d2b7824ULL, 0x000fe200078e00ffULL,
0xfffffff8162d7812ULL, 0x000fe200078ee20dULL, 0x000000011c0a7824ULL, 0x140fe200078e0204ULL,
0x0000007019197812ULL, 0x000fe200078ec0ffULL, 0x000000081c177824ULL, 0x000fe200078e00ffULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee20eULL, 0x00000001320b7824ULL, 0x100fe200078e0204ULL,
0x0000003c04307811ULL, 0x000fe200078fe8ffULL, 0x0000000832147824ULL, 0x000fe200078e00ffULL,
0xfffffff817177812ULL, 0x000fe200078ee20aULL, 0x000000012e0d7824ULL, 0x100fe200078e0204ULL,
0x00000003040a7211ULL, 0x000fe200078fe8ffULL, 0x000000082e167824ULL, 0x000fe200078e00ffULL,
0xfffffff8141f7812ULL, 0x000fe200078ee20bULL, 0x000000012c0e7824ULL, 0x100fe200078e0204ULL,
0x00000004040b7211ULL, 0x000fe200078fe8ffULL, 0x000000082c397824ULL, 0x000fe200078e00ffULL,
0xfffffff816217812ULL, 0x000fe200078ee20dULL, 0x0000000130147824ULL, 0x000fe200078e0204ULL,
0x000000070b0d7812ULL, 0x000fe200078ec0ffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0xfffffff839397812ULL, 0x000fc400078ee20eULL, 0x0ffffff80d237812ULL, 0x000fe200078ef804ULL,
0x00000001030e7824ULL, 0x000fe200078e020cULL, 0x000000190a0f7212ULL, 0x000fe200078efcffULL,
0x000020006f0c7824ULL, 0x000fe400078e0218ULL, 0x00000008303b7824ULL, 0x000fe200078e00ffULL,
0x0000000f080a7210ULL, 0x000fe20007f1e0ffULL, 0x000010000c2a7836ULL, 0x000fe40000000000ULL,
0x000000800e0c7825ULL, 0x000fe200078e00ffULL, 0xfffffff83b3b7812ULL, 0x000fc600078ee214ULL,
0x00000001030e7824ULL, 0x040fe200078e0210ULL, 0x000000190c0f7212ULL, 0x000fe200078efcffULL,
0x0000000103147824ULL, 0x000fe400078e0213ULL, 0x000000101f267824ULL, 0x000fe200078e022aULL,
0x0000000f080c7210ULL, 0x000fe20007f3e0ffULL, 0x000000800e0e7825ULL, 0x000fc800078e00ffULL,
0x0000000103167824ULL, 0x000fe200078e0215ULL, 0x000000190e1f7212ULL, 0x000fe200078efcffULL,
0x0000008014147825ULL, 0x000fc800078e00ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0609ULL,
0x0000001f080e7210ULL, 0x000fe20007f1e0ffULL, 0x0000001017287824ULL, 0x000fe200078e022aULL,
0x00000019141f7212ULL, 0x000fe200078efcffULL, 0x0000000103127824ULL, 0x000fe400078e0212ULL,
0x0000008016167825ULL, 0x000fc800078e00ffULL, 0x000000010f0f7824ULL, 0x000fe200000e0609ULL,
0x0000001f08147210ULL, 0x000fe20007f1e0ffULL, 0x0000000103117824ULL, 0x000fe200078e0211ULL,
0x00000019161f7212ULL, 0x000fe200078efcffULL, 0x0000008012127825ULL, 0x000fc800078e00ffULL,
0x0000001039227824ULL, 0x000fe200078e022aULL, 0x0000001912397212ULL, 0x000fe200078efcffULL,
0x0000008011107825ULL, 0x000fc600078e00ffULL, 0x0000003908127210ULL, 0x000fe20007f5e0ffULL,
0x00000001031e7824ULL, 0x000fe400078e021eULL, 0x0000000115157824ULL, 0x000fe200000e0609ULL,
0x0000001f08167210ULL, 0x000fe20007f1e0ffULL, 0x0000000103387824ULL, 0x040fe400078e021bULL,
0x00000001031f7824ULL, 0x000fe400078e021aULL, 0x0000001021247824ULL, 0x000fe200078e022aULL,
0x0000001910217212ULL, 0x000fe200078efcffULL, 0x000000801e1a7825ULL, 0x000fc800078e00ffULL,
0x0000008038387825ULL, 0x000fc800078e00ffULL, 0x000000010d0d7824ULL, 0x000fe200008e0609ULL,
0x0000002108107210ULL, 0x000fe20007f3e0ffULL, 0x0000000103207824ULL, 0x000fe200078e021dULL,
0x000000191a1d7212ULL, 0x000fe200078efcffULL, 0x0000001023237824ULL, 0x100fe400078e022aULL,
0x0000001025257824ULL, 0x100fe400078e022aULL, 0x0000001027277824ULL, 0x100fe200078e022aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a237faeULL, 0x0003e2000b901c46ULL,
0x0000001029297824ULL, 0x000fc400078e022aULL, 0x0000001037377824ULL, 0x100fe200078e022aULL,
0x000000000c257faeULL, 0x0003e2000b901c46ULL, 0x0000001035357824ULL, 0x100fe400078e022aULL,
0x0000001033337824ULL, 0x100fe200078e022aULL, 0x000000000e277faeULL, 0x0003e2000b901c46ULL,
0x0000001031317824ULL, 0x100fe400078e022aULL, 0x000000102f2f7824ULL, 0x100fe400078e022aULL,
0x000000102d2d7824ULL, 0x000fc400078e022aULL, 0x000000102b2b7824ULL, 0x100fe400078e022aULL,
0x000000103b2a7824ULL, 0x000fe200078e022aULL, 0x00000019383b7212ULL, 0x000fe200078efcffULL,
0x000000801f1e7825ULL, 0x000fc800078e00ffULL, 0x0000000117177824ULL, 0x100fe200000e0609ULL,
0x0000001d081a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000111117824ULL, 0x100fe200008e0609ULL,
0x000000191e1d7212ULL, 0x080fe200078efcffULL, 0x0000000103347824ULL, 0x000fe200078e021cULL,
0x0000003b081c7210ULL, 0x000fe20007f3e0ffULL, 0x0000008020207825ULL, 0x000fe200078e00ffULL,
0x0000000010297faeULL, 0x0003e6000b901c46ULL, 0x000000011b1b7824ULL, 0x100fe200000e0609ULL,
0x0000001d081e7210ULL, 0x000fe20007f1e0ffULL, 0x00000001391d7824ULL, 0x000fe200008e0609ULL,
0x00000019203d7212ULL, 0x000fe200078efcffULL, 0x0000008034387825ULL, 0x000fc800078e00ffULL,
0x0000000113137824ULL, 0x000fe200010e0609ULL, 0x0000003d08207210ULL, 0x000fe20007f5e0ffULL,
0x00000001033a7824ULL, 0x040fe200078e0232ULL, 0x00000019383d7212ULL, 0x000fe200078efcffULL,
0x0000000103407824ULL, 0x040fe200078e022eULL, 0x0000000012377faeULL, 0x0003e2000b901c46ULL,
0x00000001033e7824ULL, 0x040fe400078e022cULL, 0x00000001033c7824ULL, 0x000fe200078e0230ULL,
0x0000000014357faeULL, 0x0003e2000b901c46ULL, 0x000000803a3a7825ULL, 0x000fc600078e00ffULL,
0x0000000016337faeULL, 0x0003e2000b901c46ULL, 0x000000011f1f7824ULL, 0x100fe200000e0609ULL,
0x0000003d08387210ULL, 0x000fe20007f1e0ffULL, 0x0000008040407825ULL, 0x000fe200078e00ffULL,
0x000000193a437212ULL, 0x080fe200078efcffULL, 0x000000001a317faeULL, 0x0003e4000b901c46ULL,
0x000000803e3e7825ULL, 0x000fe200078e00ffULL, 0x0000001940457212ULL, 0x080fe200078efcffULL,
0x000000001c2f7faeULL, 0x0003e4000b901c46ULL, 0x000000803c3c7825ULL, 0x000fe200078e00ffULL,
0x000000193e477212ULL, 0x080fe200078efcffULL, 0x000000001e2d7faeULL, 0x0003e2000b901c46ULL,
0x0000004508407210ULL, 0x000fe20007f3e0ffULL, 0x0000000139397824ULL, 0x100fe200000e0609ULL,
0x000000193c197212ULL, 0x000fe200078efcffULL, 0x0000000121217824ULL, 0x100fe200010e0609ULL,
0x00000043083a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000141417824ULL, 0x000fe200008e0609ULL,
0x00000047083e7210ULL, 0x000fc40007f5e0ffULL, 0x0000001908087210ULL, 0x000fe20007f7e0ffULL,
0x000000013b3b7824ULL, 0x100fe200000e0609ULL, 0x00000000202b7faeULL, 0x0003e2000b901c46ULL,
0x000000013f3f7824ULL, 0x100fe400010e0609ULL, 0x000000013d097824ULL, 0x000fe200018e0609ULL,
0x0000000038287faeULL, 0x0003e8000b901c46ULL, 0x000000003a267faeULL, 0x0003e8000b901c46ULL,
0x0000000040247faeULL, 0x0003e8000b901c46ULL, 0x000000003e227faeULL, 0x0003e8000b901c46ULL,
0x00000000082a7faeULL, 0x0003e4000b901c46ULL, 0x000000046e6e7836ULL, 0x000fe20000000000ULL,
0x0000000000087919ULL, 0x002e620000002700ULL, 0x00009400ff097b82ULL, 0x000e620000000800ULL,
0xffffffffff7a7424ULL, 0x000fe400078e00ffULL, 0x0000007c6e00720cULL, 0x000fe20003f06070ULL,
0x00000000000079afULL, 0x000e180000000000ULL, 0x00009000ff0a8b82ULL, 0x000ea20000000a00ULL,
0x00000020040c7836ULL, 0x000fe20000000000ULL, 0x0000000704647812ULL, 0x000fe200078ec0ffULL,
0x0000000908087224ULL, 0x002fe200078e02ffULL, 0x0000000000167805ULL, 0x000fe4000001ff00ULL,
0x0000000000147805ULL, 0x000fe4000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000000208098824ULL, 0x000fe200078e026eULL, 0x00000000001c7805ULL, 0x000fc4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x00000004090a8825ULL, 0x004fe200078e000aULL,
0x0000000000247805ULL, 0x000fe4000001ff00ULL, 0x00000000002a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000200007087824ULL, 0x000fe200078e0218ULL,
0x000000060a7a8981ULL, 0x000322000c1e1900ULL, 0xfffffff804077812ULL, 0x000fe200078ec0ffULL,
0x000000ffff097224ULL, 0x000fe200078e00ffULL, 0x00000000002e7805ULL, 0x000fc4000001ff00ULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x00000007075e7812ULL, 0x000fe400078ef804ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x0000000000367805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fc4000001ff00ULL,
0xfffffff80c0b7812ULL, 0x002fe200078ec0ffULL, 0x0000100008087836ULL, 0x000fe20000000000ULL,
0x0000000864687812ULL, 0x000fe200078ef804ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000070b077812ULL, 0x000fce00078ef804ULL, 0x000000015e0a7824ULL, 0x140fe200078e0209ULL,
0x00000004ff0e7819ULL, 0x000fe20000011604ULL, 0x000000085e0b7824ULL, 0x040fe400078e00ffULL,
0x000000085e0c7824ULL, 0x000fe400078e00ffULL, 0x0000000807197824ULL, 0x040fe200078e00ffULL,
0xfffffff80b0b7812ULL, 0x000fe200078ee20aULL, 0x00000001070a7824ULL, 0x000fe400078e0209ULL,
0x0000001068187824ULL, 0x000fc400078e00ffULL, 0x000000100b107824ULL, 0x000fe400078e0208ULL,
0x00000008070b7824ULL, 0x000fe400078e00ffULL, 0x00000010681a7824ULL, 0x000fe400078e00ffULL,
0x000000001010783bULL, 0x000e620000000200ULL, 0xfffffff80b0b7812ULL, 0x000fe200078ee20aULL,
0x00000001090a7836ULL, 0x000fc80000000000ULL, 0x000000100b547824ULL, 0x000fe400078e0208ULL,
0x000000015e0b7824ULL, 0x100fe400078e020aULL, 0x00000001070a7824ULL, 0x000fe400078e020aULL,
0x000000005454783bULL, 0x000ea20000000200ULL, 0xfffffff80c0d7812ULL, 0x000fe200078ee20bULL,
0x00000002090b7824ULL, 0x000fe200078e020eULL, 0xfffffff819197812ULL, 0x000fe200078ee20aULL,
0x0000000209097836ULL, 0x000fc40000000000ULL, 0x000000100d0d7824ULL, 0x100fe200078e0208ULL,
0x0000000268717810ULL, 0x140fe20007ffe00bULL, 0x00000001683d7824ULL, 0x000fe200078e020bULL,
0x000000080900780cULL, 0x000fe20003f05270ULL, 0x0000001019197824ULL, 0x000fe200078e0208ULL,
0xfffffff01a717812ULL, 0x000fe200078ee271ULL, 0x000000000d0c783bULL, 0x000ee20000000200ULL,
0xfffffff0183d7812ULL, 0x000fc600078ee23dULL, 0x000000001918783bULL, 0x000f640000000200ULL,
0x000000103d3d7824ULL, 0x000fe200078e0202ULL, 0x00000010ff3c7819ULL, 0x102fe40000011610ULL,
0x00000018ff787819ULL, 0x000fe40000011610ULL, 0x000000ff10767812ULL, 0x040fe400078ec0ffULL,
0x0000ffff103f7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff3e7819ULL, 0x000fc40000011611ULL,
0x00000018ff747819ULL, 0x000fe40000011611ULL, 0x000000ff11727812ULL, 0x040fe400078ec0ffULL,
0x0000ffff11407812ULL, 0x000fe400078ec0ffULL, 0x00000010ff107819ULL, 0x100fe40000011612ULL,
0x00000018ff4d7819ULL, 0x000fe40000011612ULL, 0x000000ff124c7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff117819ULL, 0x100fe40000011613ULL, 0x00000018ff667819ULL, 0x000fe40000011613ULL,
0x000000ff13527812ULL, 0x040fe400078ec0ffULL, 0x0000ffff12127812ULL, 0x000fe400078ec0ffULL,
0x0000ffff13137812ULL, 0x000fe400078ec0ffULL, 0x000000ff106d7812ULL, 0x000fc400078ec0ffULL,
0x00000008ff6c7819ULL, 0x000fe40000011612ULL, 0x000000ff11677812ULL, 0x000fe400078ec0ffULL,
0x00000008ff657819ULL, 0x000fe40000011613ULL, 0x000000003d10783bULL, 0x0002620000000200ULL,
0x00000010ff0b7819ULL, 0x104fe40000011654ULL, 0x00000018ff627819ULL, 0x000fe40000011654ULL,
0x000000ff545f7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff54387812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4f7819ULL, 0x100fe40000011656ULL, 0x00000018ff547819ULL, 0x000fe40000011656ULL,
0x000000ff56517812ULL, 0x040fe400078ec0ffULL, 0x0000ffff56507812ULL, 0x000fe400078ec0ffULL,
0x00000010ff567819ULL, 0x000fc40000011657ULL, 0x00000018ff4b7819ULL, 0x000fe40000011657ULL,
0x000000ff57477812ULL, 0x040fe400078ec0ffULL, 0x0000ffff57577812ULL, 0x000fe400078ec0ffULL,
0x00000010ff397819ULL, 0x100fe40000011655ULL, 0x00000018ff5c7819ULL, 0x000fe40000011655ULL,
0x000000ff55587812ULL, 0x000fc400078ec0ffULL, 0x0000ffff553a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff3c797812ULL, 0x000fe400078ec0ffULL, 0x00000008ff777819ULL, 0x000fe4000001163fULL,
0x00000010ff537819ULL, 0x108fe4000001160cULL, 0x00000018ff467819ULL, 0x000fe4000001160cULL,
0x000000ff0c3b7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff0c617812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5a7819ULL, 0x100fe4000001160dULL, 0x00000018ff417819ULL, 0x000fe4000001160dULL,
0x000000ff0d457812ULL, 0x040fe400078ec0ffULL, 0x0000ffff0d5b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff557819ULL, 0x000fc4000001160eULL, 0x00000018ff437819ULL, 0x000fe4000001160eULL,
0x000000ff0e447812ULL, 0x040fe400078ec0ffULL, 0x0000ffff0e487812ULL, 0x000fe400078ec0ffULL,
0x000000ff3e757812ULL, 0x000fe400078ec0ffULL, 0x00000008ff737819ULL, 0x000fe40000011640ULL,
0x000000ff0b637812ULL, 0x000fc400078ec0ffULL, 0x00000010ff0b7819ULL, 0x120fe40000011618ULL,
0x00000018ff3f7819ULL, 0x000fe40000011618ULL, 0x000000ff18407812ULL, 0x040fe400078ec0ffULL,
0x0000ffff180c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff0d7819ULL, 0x100fe40000011619ULL,
0x00000018ff3d7819ULL, 0x002fc40000011619ULL, 0x000000ff193e7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff190e7812ULL, 0x000fe400078ec0ffULL, 0x000000ff4f4f7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff507819ULL, 0x000fe40000011650ULL, 0x000000ff56187812ULL, 0x000fe400078ec0ffULL,
0x00000008ff197819ULL, 0x000fc40000011657ULL, 0x00000078ff78723eULL, 0x000fe400020006ffULL,
0x00000076ff76723eULL, 0x000fe400020006ffULL, 0x00000079ff79723eULL, 0x000fe400020006ffULL,
0x00000077ff77723eULL, 0x000fe400020006ffULL, 0x0000004fff57723eULL, 0x000fe400020006ffULL,
0x00000050ff56723eULL, 0x000fc400020006ffULL, 0x00000018ff4f723eULL, 0x000fe400020006ffULL,
0x00000019ff50723eULL, 0x000fe400020006ffULL, 0x0000541079197816ULL, 0x000fe40000000078ULL,
0x0000541076187816ULL, 0x000fe40000000077ULL, 0x0000004dff4d723eULL, 0x000fe400020006ffULL,
0x0000004cff4c723eULL, 0x000fc400020006ffULL, 0x0000006dff6d723eULL, 0x000fe200020006ffULL,
0x000000181034723cULL, 0x000fe20000001834ULL, 0x0000006cff6c723eULL, 0x000fe400020006ffULL,
0x00000074ff74723eULL, 0x000fe400020006ffULL, 0x00000072ff72723eULL, 0x000fe400020006ffULL,
0x00000075ff75723eULL, 0x000fe400020006ffULL, 0x00000073ff73723eULL, 0x000fc400020006ffULL,
0x000054106d4d7816ULL, 0x000fe4000000004dULL, 0x000054104c4c7816ULL, 0x000fe4000000006cULL,
0x00000010ff497819ULL, 0x100fe4000001160fULL, 0x00000018ff4a7819ULL, 0x000fe4000001160fULL,
0x000000ff0f427812ULL, 0x040fe200078ec0ffULL, 0x0000004c102c723cULL, 0x000fe2000000182cULL,
0x0000ffff0f0a7812ULL, 0x000fc400078ec0ffULL, 0x00000008ff607819ULL, 0x000fe40000011638ULL,
0x0000541075197816ULL, 0x000fe40000000074ULL, 0x0000541072187816ULL, 0x000fe40000000073ULL,
0x00000010ff0f7819ULL, 0x100fe4000001161aULL, 0x00000018ff6b7819ULL, 0x000fe4000001161aULL,
0x000000ff1a6a7812ULL, 0x040fe200078ec0ffULL, 0x000000181030723cULL, 0x000fe20000001830ULL,
0x0000ffff1a387812ULL, 0x000fe200078ec0ffULL, 0x00000010711a7824ULL, 0x000fe200078e0202ULL,
0x00000066ff66723eULL, 0x000fc400020006ffULL, 0x00000052ff52723eULL, 0x000fe400020006ffULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x00000065ff65723eULL, 0x000fe400020006ffULL,
0x000000ff395d7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff597819ULL, 0x000fe4000001163aULL,
0x0000006aff4d723eULL, 0x000fc400020006ffULL, 0x00000010ff3a7819ULL, 0x100fe4000001161bULL,
0x00000018ff4e7819ULL, 0x000fe4000001161bULL, 0x000000ff1b397812ULL, 0x040fe400078ec0ffULL,
0x0000ffff1b3c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff536a7812ULL, 0x000fe200078ec0ffULL,
0x000000001a18783bULL, 0x000e620000000200ULL, 0x0000541067537816ULL, 0x000fc40000000066ULL,
0x0000541052527816ULL, 0x000fe40000000065ULL, 0x00000062ff62723eULL, 0x000fe400020006ffULL,
0x0000005fff5f723eULL, 0x000fe400020006ffULL, 0x00000063ff63723eULL, 0x000fe200020006ffULL,
0x000000521028723cULL, 0x000fe20000001828ULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x0000005cff5c723eULL, 0x000fc400020006ffULL, 0x00000058ff58723eULL, 0x000fe400020006ffULL,
0x0000541063537816ULL, 0x000fe40000000062ULL, 0x000054105f527816ULL, 0x000fe40000000060ULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x00000059ff59723eULL, 0x000fe400020006ffULL,
0x00000051ff51723eULL, 0x000fe200020006ffULL, 0x000000521024723cULL, 0x000fe20000001824ULL,
0x00000054ff54723eULL, 0x000fc400020006ffULL, 0x0000004bff4b723eULL, 0x000fe400020006ffULL,
0x00000047ff47723eULL, 0x000fe400020006ffULL, 0x000054105d537816ULL, 0x000fe4000000005cULL,
0x0000541058527816ULL, 0x000fe40000000059ULL, 0x00000008ff617819ULL, 0x000fe40000011661ULL,
0x0000541047507816ULL, 0x000fc40000000050ULL, 0x00000046ff46723eULL, 0x000fe200020006ffULL,
0x000000521020723cULL, 0x000fe20000001820ULL, 0x0000003bff3b723eULL, 0x000fe400020006ffULL,
0x0000006aff65723eULL, 0x000fe400020006ffULL, 0x00000061ff5f723eULL, 0x000fe400020006ffULL,
0x0000541051527816ULL, 0x000fe40000000056ULL, 0x0000541057537816ULL, 0x000fc40000000054ULL,
0x000054104f517816ULL, 0x000fe4000000004bULL, 0x000000ff5a5a7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff5b7819ULL, 0x000fe2000001165bULL, 0x00000052101c723cULL, 0x000fe2000000181cULL,
0x00000008ff0a7819ULL, 0x000fe4000001160aULL, 0x00000041ff41723eULL, 0x000fe400020006ffULL,
0x00000045ff45723eULL, 0x000fe200020006ffULL, 0x000000501014723cULL, 0x000fe20000001814ULL,
0x0000005aff59723eULL, 0x000fc400020006ffULL, 0x0000005bff58723eULL, 0x000fe400020006ffULL,
0x000000ff55557812ULL, 0x000fe400078ec0ffULL, 0x0000541065117816ULL, 0x000fe40000000046ULL,
0x000054103b107816ULL, 0x000fe4000000005fULL, 0x00000008ff487819ULL, 0x000fe40000011648ULL,
0x000000ff49497812ULL, 0x000fc400078ec0ffULL, 0x00000008ff0c7819ULL, 0x000fe2000001160cULL,
0x000000101834723cULL, 0x002fe20000001834ULL, 0x000000ff0d0d7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff0e7819ULL, 0x000fe4000001160eULL, 0x000000ff0f0f7812ULL, 0x000fe400078ec0ffULL,
0x0000000aff10723eULL, 0x000fe400020006ffULL, 0x000000ff0b117812ULL, 0x000fc400078ec0ffULL,
0x00005410590b7816ULL, 0x000fe40000000041ULL, 0x00005410450a7816ULL, 0x000fe40000000058ULL,
0x00000008ff387819ULL, 0x000fe40000011638ULL, 0x000000ff3a3a7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff3c7819ULL, 0x000fe2000001163cULL, 0x0000000a1830723cULL, 0x000fe20000001830ULL,
0x00000043ff43723eULL, 0x000fc400020006ffULL, 0x0000003fff3f723eULL, 0x000fe400020006ffULL,
0x00000055ff52723eULL, 0x000fe400020006ffULL, 0x00000011ff41723eULL, 0x000fe400020006ffULL,
0x00000044ff44723eULL, 0x000fe400020006ffULL, 0x0000004aff4a723eULL, 0x000fe400020006ffULL,
0x00000042ff42723eULL, 0x000fc400020006ffULL, 0x00000040ff40723eULL, 0x000fe400020006ffULL,
0x0000003dff3d723eULL, 0x000fe400020006ffULL, 0x0000003eff3e723eULL, 0x000fe400020006ffULL,
0x0000006bff4c723eULL, 0x000fe400020006ffULL, 0x0000004eff4e723eULL, 0x000fe400020006ffULL,
0x00000048ff48723eULL, 0x000fc400020006ffULL, 0x00000049ff49723eULL, 0x000fe400020006ffULL,
0x0000000cff0c723eULL, 0x000fe400020006ffULL, 0x0000000dff0d723eULL, 0x000fe400020006ffULL,
0x0000000eff0e723eULL, 0x000fe400020006ffULL, 0x0000000fff0f723eULL, 0x000fe400020006ffULL,
0x00000038ff38723eULL, 0x000fc400020006ffULL, 0x00000039ff0a723eULL, 0x000fe400020006ffULL,
0x0000003aff0b723eULL, 0x000fe400020006ffULL, 0x0000003cff3c723eULL, 0x000fe400020006ffULL,
0x0000541052457816ULL, 0x000fe40000000043ULL, 0x0000541041417816ULL, 0x000fe4000000003fULL,
0x0000541044447816ULL, 0x000fc40000000048ULL, 0x0000541049437816ULL, 0x000fe4000000004aULL,
0x0000541042427816ULL, 0x000fe40000000010ULL, 0x0000541040407816ULL, 0x000fe2000000000cULL,
0x00000044182c723cULL, 0x000fe2000000182cULL, 0x000054100d3f7816ULL, 0x000fe4000000003dULL,
0x000054103e3e7816ULL, 0x000fe4000000000eULL, 0x000054100f397816ULL, 0x000fe2000000004cULL,
0x000000421828723cULL, 0x000fe20000001828ULL, 0x000054104d387816ULL, 0x000fc40000000038ULL,
0x000054100b0b7816ULL, 0x000fe4000000004eULL, 0x000054100a0a7816ULL, 0x000fe2000000003cULL,
0x000000401824723cULL, 0x000fec0000001824ULL, 0x0000003e1820723cULL, 0x000fec0000001820ULL,
0x00000038181c723cULL, 0x000fec000000181cULL, 0x0000000a1814723cULL, 0x000fe20000001814ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0xfffffff0002c0947ULL, 0x000fde000383ffffULL,
0x00000001ff097424ULL, 0x000fe400078e00ffULL, 0x0000000534077220ULL, 0x080fe20000410000ULL,
0x0000000535357220ULL, 0x080fe20000410000ULL, 0x0000000536367220ULL, 0x080fe20000410000ULL,
0x0000000537377220ULL, 0x080fe20000410000ULL, 0x0000000530307220ULL, 0x080fe20000410000ULL,
0x01768809060879a7ULL, 0x000262000850003fULL, 0x0000000531317220ULL, 0x080fe20000410000ULL,
0x0000000532327220ULL, 0x080fe20000410000ULL, 0x0000000533337220ULL, 0x080fe20000410000ULL,
0x000000052c2c7220ULL, 0x080fe20000410000ULL, 0x000000052d2d7220ULL, 0x080fe20000410000ULL,
0x000000052e2e7220ULL, 0x080fe20000410000ULL, 0x000000052f2f7220ULL, 0x080fe20000410000ULL,
0x0000000528287220ULL, 0x080fe20000410000ULL, 0x0000000529297220ULL, 0x080fe20000410000ULL,
0x000000052a2a7220ULL, 0x080fe20000410000ULL, 0x000000052b2b7220ULL, 0x080fe20000410000ULL,
0x0000000524247220ULL, 0x080fe20000410000ULL, 0x0000000525257220ULL, 0x080fe20000410000ULL,
0x0000000526267220ULL, 0x080fe20000410000ULL, 0x0000000527277220ULL, 0x080fe20000410000ULL,
0x0000000520207220ULL, 0x080fe20000410000ULL, 0x0000000521217220ULL, 0x080fe20000410000ULL,
0x0000000522227220ULL, 0x080fe20000410000ULL, 0x0000000523237220ULL, 0x080fe20000410000ULL,
0x000000051c1c7220ULL, 0x080fe20000410000ULL, 0x000000051d1d7220ULL, 0x080fe20000410000ULL,
0x000000051e1e7220ULL, 0x080fe20000410000ULL, 0x000000051f1f7220ULL, 0x080fe20000410000ULL,
0x00000005141b7220ULL, 0x080fe20000410000ULL, 0x0000000515347220ULL, 0x080fe20000410000ULL,
0x0000000516187220ULL, 0x080fe20000410000ULL, 0x0000000517197220ULL, 0x002fce0000410000ULL,
0x00000000000a7805ULL, 0x000fce0000015200ULL, 0x01768809060075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff0e7224ULL, 0x000fce00078e00ffULL,
0x000000100e00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000000c7805ULL, 0x000fce0000015200ULL, 0x0000000c0a0f7210ULL, 0x000fca0007f1e1ffULL,
0x000000010d0d7824ULL, 0x000fe200000e0e0bULL, 0x003d09000f00780cULL, 0x000fc80003f06070ULL,
0x000000ff0d00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400f00780cULL, 0x000fc80003f06070ULL, 0x000000ff0d00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff0c7819ULL, 0x000fc8000001140dULL,
0x0000000f0c0c7211ULL, 0x000fca00078110ffULL, 0x000000ffff0d7224ULL, 0x000fca00000e060dULL,
0x000000020c0c7819ULL, 0x000fc8000000120dULL, 0x0000000c0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000010e0e7836ULL, 0x000fce0000000000ULL,
0x01768809060075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000404087824ULL, 0x000fe200078e00ffULL, 0x0000840000097ab9ULL, 0x000fe20000000800ULL,
0x0000008000097824ULL, 0x000fe400078e0202ULL, 0x800000097b0c7c36ULL, 0x000fe20008000000ULL,
0xfffffff008087812ULL, 0x000fc800078ec0ffULL, 0x00000008ff0c7819ULL, 0x000fe2000001160cULL,
0x00000001091a7824ULL, 0x000fc600078e0208ULL, 0x0000000c6900720cULL, 0x000fe40003f06070ULL,
0x017400001a087984ULL, 0x0002b60000000c00ULL, 0x0000001000cc8947ULL, 0x002fea0003800000ULL,
0x00000000010f7983ULL, 0x000ee20000100800ULL, 0x00000040000c7824ULL, 0x000fe200078e00ffULL,
0x0000860000097ab9ULL, 0x000fe20000000800ULL, 0x0000000204177824ULL, 0x000fe200078e00ffULL,
0x00008400000a7ab9ULL, 0x000fe20000000800ULL, 0x0000010069167824ULL, 0x000fca00078e020cULL,
0x000000167b0d7248ULL, 0x000fe40007fe0000ULL, 0x0000000617177812ULL, 0x000fc600078ec0ffULL,
0x000000010d167824ULL, 0x000fe400078e0a16ULL, 0x00008c00ff0c7b82ULL, 0x000e620000000a00ULL,
0x0000000817117c36ULL, 0x000fe40008000000ULL, 0x000000ffff487224ULL, 0x000fe400078e0a16ULL,
0x0000000a17397c36ULL, 0x000fe20008000000ULL, 0x000000161100720cULL, 0x000fe40003f26070ULL,
0x0000000511117e46ULL, 0x000fc4000b800048ULL, 0x000000163900720cULL, 0x000fe40003f06070ULL,
0x0000000539467e46ULL, 0x000fe4000b800048ULL, 0x00000004ff117819ULL, 0x000fe40000011611ULL,
0x000000ff46467207ULL, 0x000fe40000000000ULL, 0x000000ff11147207ULL, 0x000fe40000800000ULL,
0x00000010173d7812ULL, 0x000fca00078efcffULL, 0x0000000a3d3b7c36ULL, 0x000fe20008000000ULL,
0x0000002017417812ULL, 0x000fc800078efcffULL, 0x000000163b00720cULL, 0x000fe40003f06070ULL,
0x000000053b387e46ULL, 0x000fe2000b800048ULL, 0x0000000a41437c36ULL, 0x000fc60008000000ULL,
0x000000ff38387207ULL, 0x000fe20000000000ULL, 0x0000000841477c36ULL, 0x000fe20008000000ULL,
0x000000164300720cULL, 0x000fe40003f06070ULL, 0x00000005433e7e46ULL, 0x000fe4000b800048ULL,
0x0000000547407e46ULL, 0x000fe4000b800048ULL, 0x000000ff3e3e7207ULL, 0x000fe40000000000ULL,
0x00000004ff407819ULL, 0x000fc40000011640ULL, 0x0000000f040e7211ULL, 0x008fc800078ff0ffULL,
0x00000009ff0f7c19ULL, 0x000fe2000801160eULL, 0x000000080e0e7836ULL, 0x000fc60000000000ULL,
0x000000050f0f7c48ULL, 0x000fe4000bfe0000ULL, 0x00000009ff0e7c19ULL, 0x000fc6000801160eULL,
0x000000040f517c24ULL, 0x000fe2000f8e02ffULL, 0x000000050e0e7c48ULL, 0x000fc6000bfe0000ULL,
0x0000000151137824ULL, 0x000fe200078e0214ULL, 0x0000005146117211ULL, 0x000fe200078fe0ffULL,
0x000000040e537c24ULL, 0x000fe4000f8e02ffULL, 0x0000000213127825ULL, 0x002fc800078e000cULL,
0x0000000211107825ULL, 0x000fe200078e000cULL, 0x00000006124f7981ULL, 0x000ee6000c1e9500ULL,
0x00000001140f7824ULL, 0x000fe200078e0253ULL, 0x00000006104a7981ULL, 0x0002e2000c1e9500ULL,
0x0000005346157211ULL, 0x000fe400078fe0ffULL, 0x000000020f0e7825ULL, 0x000fca00078e000cULL,
0x000000060e4d7981ULL, 0x000ae2000c1e9500ULL, 0x000000083d117c36ULL, 0x006fca0008000000ULL,
0x0000000511107e46ULL, 0x000fe2000b800048ULL, 0x0000000215147825ULL, 0x000fe200078e000cULL,
0x000000161100720cULL, 0x000fe40003f26070ULL, 0x00000051380f7211ULL, 0x020fe400078fe0ffULL,
0x00000004ff107819ULL, 0x000fe20000011610ULL, 0x0000000614447981ULL, 0x0002a4000c1e9500ULL,
0x000000020f0e7825ULL, 0x000fe200078e000cULL, 0x000000ff10127207ULL, 0x000fc40000800000ULL,
0x0000005338137211ULL, 0x000fe400078fe0ffULL, 0x000000060e3a7981ULL, 0x000aa2000c1e9500ULL,
0x0000000151117824ULL, 0x000fe200078e0212ULL, 0x000000164700720cULL, 0x000fe20003f26070ULL,
0x0000000112157824ULL, 0x002fe200078e0253ULL, 0x0000003017477812ULL, 0x000fe200078efcffULL,
0x0000000211107825ULL, 0x000fe200078e000cULL, 0x000000513e0f7211ULL, 0x020fc600078fe0ffULL,
0x0000000213127825ULL, 0x100fe200078e000cULL, 0x000000ff40427207ULL, 0x000fe20000800000ULL,
0x00000006103f7981ULL, 0x000f64000c1e9500ULL, 0x0000000215147825ULL, 0x100fe400078e000cULL,
0x00000006123c7981ULL, 0x000364000c1e9500ULL, 0x000000020f0e7825ULL, 0x000fe400078e000cULL,
0x0000000614457981ULL, 0x000364000c1e9500ULL, 0x0000000847557c36ULL, 0x000fc40008000000ULL,
0x000000060e407981ULL, 0x000362000c1e9500ULL, 0x0000000a47497c36ULL, 0x000fe20008000000ULL,
0x000000533e137211ULL, 0x002fe200078fe0ffULL, 0x0000000151117824ULL, 0x000fe400078e0242ULL,
0x0000000142157824ULL, 0x000fe200078e0253ULL, 0x00000005550e7e46ULL, 0x000fc6000b800048ULL,
0x0000000215147825ULL, 0x100fe200078e000cULL, 0x000000164900720cULL, 0x080fe40003f06070ULL,
0x0000000549487e46ULL, 0x000fe2000b800048ULL, 0x0000000211107825ULL, 0x000fe200078e000cULL,
0x000000165500720cULL, 0x000fe20003f26070ULL, 0x0000000614157981ULL, 0x000f62000c1e9500ULL,
0x00000004ff0e7819ULL, 0x000fe2000001160eULL, 0x0000000213127825ULL, 0x000fe200078e000cULL,
0x000000ff48487207ULL, 0x000fe20000000000ULL, 0x00000006104b7981ULL, 0x000362000c1e9500ULL,
0x000000ff0e4c7207ULL, 0x000fc60000800000ULL, 0x0000000612427981ULL, 0x000362000c1e9500ULL,
0x00000051480f7211ULL, 0x000fe200078fe0ffULL, 0x0000000151117824ULL, 0x002fc800078e024cULL,
0x000000020f0e7825ULL, 0x000fc800078e000cULL, 0x0000000211107825ULL, 0x000fe200078e000cULL,
0x0000005348137211ULL, 0x000fe200078fe0ffULL, 0x000000060e0e7981ULL, 0x000368000c1e9500ULL,
0x0000000610117981ULL, 0x000f62000c1e9500ULL, 0x000000014c517824ULL, 0x000fe400078e0253ULL,
0x0000000213127825ULL, 0x000fc800078e000cULL, 0x00000002510c7825ULL, 0x000fe400078e000cULL,
0x0000000612127981ULL, 0x000368000c1e9500ULL, 0x000000060c0d7981ULL, 0x000362000c1e9500ULL,
0xfffffff046517812ULL, 0x000fe200078ec0ffULL, 0x00000001ff147424ULL, 0x000fc800078e00ffULL,
0x0000000116467824ULL, 0x000fc800078e0251ULL, 0x0000000139577824ULL, 0x100fe200078e0a46ULL,
0x0000000917537812ULL, 0x040fe400078efcffULL, 0x00000001170f7812ULL, 0x002fe400078efcffULL,
0x0000005714577219ULL, 0x000fe200000006ffULL, 0x0000000a53137c36ULL, 0x000fe40008000000ULL,
0x0000000a0f557c36ULL, 0x000fe40008000000ULL, 0x00000001135d7824ULL, 0x000fc400078e0a46ULL,
0x0000000155597824ULL, 0x000fe200078e0a46ULL, 0x0000001817717812ULL, 0x000fe400078efcffULL,
0xfffffff038387812ULL, 0x000fe400078ec0ffULL, 0x0000005d145d7219ULL, 0x040fe400000006ffULL,
0x0000005914597219ULL, 0x000fe400000006ffULL, 0xfffffff03e3e7812ULL, 0x000fe400078ec0ffULL,
0xfffffff048487812ULL, 0x000fe200078ec0ffULL, 0x0000000a71777c36ULL, 0x000fc40008000000ULL,
0x0000000116387824ULL, 0x040fe400078e0238ULL, 0x0000000116107824ULL, 0x000fe400078e023eULL,
0x000000013b3e7824ULL, 0x000fe200078e0a38ULL, 0x0000001117737812ULL, 0x040fe400078efcffULL,
0x00000019176d7812ULL, 0x000fe400078efcffULL, 0x0000003e143e7219ULL, 0x000fe200000006ffULL,
0x0000000a73797c36ULL, 0x000fc40008000000ULL, 0x0000000a6d757c36ULL, 0x000fc80008000000ULL,
0x00000001754c7824ULL, 0x000fe200078e0a38ULL, 0x0000002117617812ULL, 0x040fe400078efcffULL,
0x00000028175f7812ULL, 0x000fe400078efcffULL, 0x0000004c144c7219ULL, 0x000fe200000006ffULL,
0x0000000a61677c36ULL, 0x000fe40008000000ULL, 0x0000000a5f657c36ULL, 0x000fe40008000000ULL,
0x00000001674e7824ULL, 0x000fc400078e0a10ULL, 0x0000000165507824ULL, 0x000fc600078e0a10ULL,
0x0000004e144e7219ULL, 0x040fe400000006ffULL, 0x0000005014507219ULL, 0x000fe400000006ffULL,
0x000054104a4a7816ULL, 0x008fe4000000004fULL, 0x00000008174f7812ULL, 0x000fe400078efcffULL,
0x0000004a57ff7212ULL, 0x000fc6000780c0ffULL, 0x0000000a4f517c36ULL, 0x000fe20008000000ULL,
0x000000163900720cULL, 0x000fc60000701470ULL, 0x00000001515b7824ULL, 0x000fe200078e0a46ULL,
0x000000161700720cULL, 0x000fc800007a1070ULL, 0x0000005b145b7219ULL, 0x000fe400000006ffULL,
0xff80000007077808ULL, 0x000fe40002800000ULL, 0x0000541044447816ULL, 0x004fc8000000004dULL,
0x0000004457ff7212ULL, 0x080fe4000784c0ffULL, 0x000000445bff7212ULL, 0x080fe400078cc0ffULL,
0x000000445dff7212ULL, 0x080fe400078ac0ffULL, 0x0000004459ff7212ULL, 0x000fe2000780c0ffULL,
0x0000000116447824ULL, 0x000fe200078e0248ULL, 0x000000163900720cULL, 0x080fe20001741470ULL,
0x0000000177487824ULL, 0x000fe200078e0a38ULL, 0x000000165100720cULL, 0x000fc400037c1470ULL,
0x000000161300720cULL, 0x080fe40002fa1470ULL, 0x000000161700720cULL, 0x080fe40001741070ULL,
0x000000164f00720cULL, 0x080fe400037c1070ULL, 0x000000165300720cULL, 0x000fe40002fa1070ULL,
0x0000004814487219ULL, 0x000fe400000006ffULL, 0x000054103a3f7816ULL, 0x020fc4000000003fULL,
0x000054103c457816ULL, 0x000fe40000000045ULL, 0xff80000036367808ULL, 0x000fe40001000000ULL,
0xff80000032327808ULL, 0x000fe40003000000ULL, 0xff80000033337808ULL, 0x000fe40002800000ULL,
0x0000004a59ff7212ULL, 0x080fe4000782c0ffULL, 0x0000004a5bff7212ULL, 0x000fc4000786c0ffULL,
0x0000004a5dff7212ULL, 0x000fe4000788c0ffULL, 0x0000003f3eff7212ULL, 0x040fe4000784c0ffULL,
0x000000453eff7212ULL, 0x080fe400078cc0ffULL, 0x0000004548ff7212ULL, 0x000fe200078ac0ffULL,
0x0000000179467824ULL, 0x000fe200078e0a38ULL, 0x000000165500720cULL, 0x080fe20000f21470ULL,
0x00000001434a7824ULL, 0x000fe200078e0a10ULL, 0x000000165500720cULL, 0x000fc40000701470ULL,
0x000000165100720cULL, 0x080fe40001f61470ULL, 0x000000161300720cULL, 0x080fe40002781470ULL,
0x000000163b00720cULL, 0x0c0fe40001741470ULL, 0x000000163b00720cULL, 0x080fe400037c1470ULL,
0x000000167700720cULL, 0x000fe40002fa1470ULL, 0x00000029175d7812ULL, 0x000fc400078efcffULL,
0x000000160f00720cULL, 0x0c0fe40000f21070ULL, 0x000000160f00720cULL, 0x080fe40000701070ULL,
0x000000164f00720cULL, 0x080fe40001f61070ULL, 0x000000165300720cULL, 0x080fe40002781070ULL,
0x000000163d00720cULL, 0x0c0fe40001741070ULL, 0x000000163d00720cULL, 0x000fc400037c1070ULL,
0x000000167100720cULL, 0x000fe40002fa1070ULL, 0x0000004614467219ULL, 0x040fe400000006ffULL,
0x0000004a144a7219ULL, 0x000fe400000006ffULL, 0x00005410404b7816ULL, 0x000fe4000000004bULL,
0x0000541042157816ULL, 0x000fe20000000015ULL, 0x0000000a5d637c36ULL, 0x000fe20008000000ULL,
0xff80000035357808ULL, 0x000fc40000800000ULL, 0xff80000037377808ULL, 0x000fe40000000000ULL,
0xff80000030307808ULL, 0x000fe40001800000ULL, 0xff80000031317808ULL, 0x000fe40002000000ULL,
0xff8000002c2c7808ULL, 0x000fe40001000000ULL, 0xff8000002e2e7808ULL, 0x000fe40003000000ULL,
0xff8000002a2a7808ULL, 0x000fc40002800000ULL, 0x0000003f46ff7212ULL, 0x080fe4000782c0ffULL,
0x0000003f48ff7212ULL, 0x080fe4000780c0ffULL, 0x0000003f4cff7212ULL, 0x000fe4000786c0ffULL,
0x0000004546ff7212ULL, 0x080fe4000788c0ffULL, 0x000000454cff7212ULL, 0x000fe4000784c0ffULL,
0x0000004b4aff7212ULL, 0x000fc400078cc0ffULL, 0x000000154aff7212ULL, 0x000fe200078ac0ffULL,
0x0000000163527824ULL, 0x000fe200078e0a10ULL, 0x000000167900720cULL, 0x080fe20000f21470ULL,
0x0000000149547824ULL, 0x000fe200078e0a44ULL, 0x000000167900720cULL, 0x080fe40002781470ULL,
0x000000167700720cULL, 0x080fe40000701470ULL, 0x000000167500720cULL, 0x0c0fe40001f61470ULL,
0x000000167500720cULL, 0x000fc40001741470ULL, 0x000000164300720cULL, 0x0c0fe400037c1470ULL,
0x000000164300720cULL, 0x080fe40002fa1470ULL, 0x0000003117597812ULL, 0x040fe400078efcffULL,
0x0000003817577812ULL, 0x040fe400078efcffULL, 0x00000039174d7812ULL, 0x000fe400078efcffULL,
0x000000167300720cULL, 0x000fc40000f21070ULL, 0x000000167300720cULL, 0x080fe40002781070ULL,
0x000000167100720cULL, 0x080fe40000701070ULL, 0x000000166d00720cULL, 0x0c0fe40001f61070ULL,
0x000000166d00720cULL, 0x080fe40001741070ULL, 0x000000164100720cULL, 0x0c0fe400037c1070ULL,
0x000000164100720cULL, 0x000fc40002fa1070ULL, 0x0000005214527219ULL, 0x040fe400000006ffULL,
0x0000005414547219ULL, 0x000fe400000006ffULL, 0x000054100e0e7816ULL, 0x000fe20000000011ULL,
0x0000000a595b7c36ULL, 0x000fe20008000000ULL, 0xff8000002d2d7808ULL, 0x000fe20000800000ULL,
0x0000000a576b7c36ULL, 0x000fe20008000000ULL, 0xff8000002f2f7808ULL, 0x000fe20002000000ULL,
0x0000000a4d0c7c36ULL, 0x000fe20008000000ULL, 0xff80000028287808ULL, 0x000fc40000000000ULL,
0xff80000029297808ULL, 0x000fe40001800000ULL, 0xff8000002b2b7808ULL, 0x000fe40001000000ULL,
0xff80000024247808ULL, 0x000fe40003000000ULL, 0xff80000026267808ULL, 0x000fe40002800000ULL,
0x0000004b4eff7212ULL, 0x080fe4000782c0ffULL, 0x0000004b50ff7212ULL, 0x000fc4000788c0ffULL,
0x0000004b52ff7212ULL, 0x000fe4000780c0ffULL, 0x000000154eff7212ULL, 0x080fe4000786c0ffULL,
0x0000001550ff7212ULL, 0x080fe4000784c0ffULL, 0x0000001552ff7212ULL, 0x000fe400078cc0ffULL,
0x0000000e54ff7212ULL, 0x000fe200078ac0ffULL, 0x000000015b387824ULL, 0x100fe200078e0a44ULL,
0x000000166700720cULL, 0x080fe20000f21470ULL, 0x000000016b107824ULL, 0x100fe200078e0a44ULL,
0x000000166700720cULL, 0x080fe20001f61470ULL, 0x000000010c447824ULL, 0x000fe200078e0a44ULL,
0x000000166500720cULL, 0x000fc40002781470ULL, 0x000000166500720cULL, 0x080fe40001741470ULL,
0x000000166300720cULL, 0x0c0fe40000701470ULL, 0x000000166300720cULL, 0x080fe400037c1470ULL,
0x000000164900720cULL, 0x080fe40002fa1470ULL, 0x000000166100720cULL, 0x0c0fe40000f21070ULL,
0x000000166100720cULL, 0x000fc40001f61070ULL, 0x000000165f00720cULL, 0x0c0fe40002781070ULL,
0x000000165f00720cULL, 0x080fe40001741070ULL, 0x000000165d00720cULL, 0x0c0fe40000701070ULL,
0x000000165d00720cULL, 0x080fe400037c1070ULL, 0x000000164700720cULL, 0x000fe40002fa1070ULL,
0x0000003814387219ULL, 0x000fc400000006ffULL, 0x0000001014107219ULL, 0x040fe400000006ffULL,
0x0000004414447219ULL, 0x000fe400000006ffULL, 0x00005410120d7816ULL, 0x000fe4000000000dULL,
0xff80000025257808ULL, 0x000fe40000800000ULL, 0xff80000027277808ULL, 0x000fe40001800000ULL,
0xff80000020207808ULL, 0x000fc40002000000ULL, 0xff80000022227808ULL, 0x000fe40001000000ULL,
0xff80000021217808ULL, 0x000fe40000000000ULL, 0xff80000023237808ULL, 0x000fe40003000000ULL,
0xff8000001c1c7808ULL, 0x000fe40002800000ULL, 0x0000000e38ff7212ULL, 0x080fe4000782c0ffULL,
0x0000000e10ff7212ULL, 0x000fc4000786c0ffULL, 0x0000000e44ff7212ULL, 0x000fe4000788c0ffULL,
0x0000000d54ff7212ULL, 0x080fe4000784c0ffULL, 0x0000000d38ff7212ULL, 0x080fe4000780c0ffULL,
0x0000000d10ff7212ULL, 0x080fe400078cc0ffULL, 0x0000000d44ff7212ULL, 0x000fe400078ac0ffULL,
0x000000164900720cULL, 0x000fc40001741470ULL, 0x000000165b00720cULL, 0x0c0fe40000f21470ULL,
0x000000165b00720cULL, 0x080fe40000701470ULL, 0x000000166b00720cULL, 0x0c0fe40001f61470ULL,
0x000000166b00720cULL, 0x080fe400037c1470ULL, 0x000000160c00720cULL, 0x0c0fe40002781470ULL,
0x000000160c00720cULL, 0x000fc40002fa1470ULL, 0x000000164700720cULL, 0x080fe40001741070ULL,
0x000000165900720cULL, 0x0c0fe40000f21070ULL, 0x000000165900720cULL, 0x080fe40000701070ULL,
0x000000165700720cULL, 0x0c0fe40001f61070ULL, 0x000000165700720cULL, 0x080fe400037c1070ULL,
0x000000164d00720cULL, 0x000fc40002781070ULL, 0x000000164d00720cULL, 0x000fe40002fa1070ULL,
0xff8000001d1d7808ULL, 0x000fe40000800000ULL, 0xff8000001b1b7808ULL, 0x000fe40001800000ULL,
0xff80000034347808ULL, 0x000fe40002000000ULL, 0xff8000001e1e7808ULL, 0x000fe40001000000ULL,
0xff8000001f1f7808ULL, 0x000fc40000000000ULL, 0xff80000018187808ULL, 0x000fe40003000000ULL,
0xff80000019197808ULL, 0x000fce0002800000ULL, 0x000000070800720bULL, 0x004fe20003f1e000ULL,
0x0000000169697836ULL, 0x000fe20000000000ULL, 0xfffffff8ff647812ULL, 0x000fe400078ee264ULL,
0x0000000807087208ULL, 0x000fc80004000000ULL, 0x000000350800720bULL, 0x000fc80003f1e000ULL,
0x00000008350d7208ULL, 0x000fc80004000000ULL, 0x000000300d00720bULL, 0x000fc80003f1e000ULL,
0x0000000d30087208ULL, 0x000fc80004000000ULL, 0x000000310800720bULL, 0x000fc80003f1e000ULL,
0x00000008310d7208ULL, 0x000fc80004000000ULL, 0x0000002c0d00720bULL, 0x000fc80003f1e000ULL,
0x0000000d2c087208ULL, 0x000fc80004000000ULL, 0x0000002d0800720bULL, 0x000fc80003f1e000ULL,
0x000000082d0d7208ULL, 0x000fc80004000000ULL, 0x000000280d00720bULL, 0x000fc80003f1e000ULL,
0x0000000d28087208ULL, 0x000fc80004000000ULL, 0x000000290800720bULL, 0x000fc80003f1e000ULL,
0x00000008290d7208ULL, 0x000fc80004000000ULL, 0x000000240d00720bULL, 0x000fc80003f1e000ULL,
0x0000000d24087208ULL, 0x000fc80004000000ULL, 0x000000250800720bULL, 0x000fc80003f1e000ULL,
0x00000008250d7208ULL, 0x000fc80004000000ULL, 0x000000200d00720bULL, 0x000fc80003f1e000ULL,
0x0000000d20087208ULL, 0x000fe40004000000ULL, 0x000000360900720bULL, 0x000fe40003f1e000ULL,
0x000000210800720bULL, 0x000fc80003f3e000ULL, 0x00000008210d7208ULL, 0x000fe40004800000ULL,
0x0000000936087208ULL, 0x000fe40004000000ULL, 0x0000001c0d00720bULL, 0x000fe40003f3e000ULL,
0x000000370800720bULL, 0x000fe40003f1e000ULL, 0x0000000d1c0c7208ULL, 0x000fe40004800000ULL,
0x0000000837097208ULL, 0x000fc40004000000ULL, 0x0000001d0c00720bULL, 0x000fe40003f3e000ULL,
0x000000320900720bULL, 0x000fe40003f1e000ULL, 0x0000000c1d0c7208ULL, 0x000fe40004800000ULL,
0x0000000932087208ULL, 0x000fe40004000000ULL, 0x0000001b0c00720bULL, 0x000fe40003f3e000ULL,
0x000000330800720bULL, 0x000fc40003f1e000ULL, 0x0000000c1b0d7208ULL, 0x000fe40004800000ULL,
0x0000000833097208ULL, 0x000fe40004000000ULL, 0x000000340d00720bULL, 0x000fe40003f3e000ULL,
0x0000002e0900720bULL, 0x000fe40003f1e000ULL, 0x0000000d340d7208ULL, 0x000fe40004800000ULL,
0x000000092e087208ULL, 0x000fc60004000000ULL, 0x0c401f000d0c7f89ULL, 0x000e6200000e0000ULL,
0x0000002f0800720bULL, 0x000fc80003f1e000ULL, 0x000000082f097208ULL, 0x000fc80004000000ULL,
0x0000002a0900720bULL, 0x000fc80003f1e000ULL, 0x000000092a087208ULL, 0x000fc80004000000ULL,
0x0000002b0800720bULL, 0x000fc80003f1e000ULL, 0x000000082b097208ULL, 0x000fe40004000000ULL,
0x0000000c0d00720bULL, 0x002fe40003f3e000ULL, 0x000000260900720bULL, 0x000fe40003f1e000ULL,
0x0000000d0c0e7208ULL, 0x000fe40004800000ULL, 0x0000000926087208ULL, 0x000fc60004000000ULL,
0x0c201f000e0d7f89ULL, 0x000e6200000e0000ULL, 0x000000270800720bULL, 0x000fc80003f1e000ULL,
0x0000000827097208ULL, 0x000fc80004000000ULL, 0x000000220900720bULL, 0x000fc80003f1e000ULL,
0x0000000922087208ULL, 0x000fc80004000000ULL, 0x000000230800720bULL, 0x000fc80003f1e000ULL,
0x0000000823097208ULL, 0x000fe40004000000ULL, 0x0000000d0e00720bULL, 0x002fe40003f3e000ULL,
0x0000001e0900720bULL, 0x000fe40003f1e000ULL, 0x0000000e0d087208ULL, 0x000fe40004800000ULL,
0x000000091e0c7208ULL, 0x000fc60004000000ULL, 0x3fb8aa3b080e7820ULL, 0x000fe20000410000ULL,
0x0000001f0c00720bULL, 0x000fc60003f1e000ULL, 0x3fb8aa3b07097823ULL, 0x100fe2000001080eULL,
0x0000000c1f077208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b200f7823ULL, 0x100fe2000001080eULL,
0x3fb8aa3b1c207823ULL, 0x100fe2000001080eULL, 0x00000009000d7308ULL, 0x0003e20000000800ULL,
0x000000180700720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b28287823ULL, 0x100fe2000001080eULL,
0x3fb8aa3b30307823ULL, 0x100fe2000001080eULL, 0x3fb8aa3b31317823ULL, 0x100fe2000001080eULL,
0x00000007180c7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b35357823ULL, 0x100fe2000001080eULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe2000001080eULL, 0x0000002800167308ULL, 0x000fe20000000800ULL,
0x000000190c00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe2000001080eULL,
0x3fb8aa3b29297823ULL, 0x100fe2000001080eULL, 0x3fb8aa3b24247823ULL, 0x100fe2000001080eULL,
0x0000000c190c7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b25257823ULL, 0x100fe2000001080eULL,
0x3fb8aa3b21217823ULL, 0x100fe2000001080eULL, 0x0000003500107308ULL, 0x000ee20000000800ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe2000001080eULL, 0x0c401f000c077f89ULL, 0x000f6200000e0000ULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe2000001080eULL, 0x3fb8aa3b340e7823ULL, 0x000fc8000001080eULL,
0x0000000f00287308ULL, 0x000ff00000000800ULL, 0x0000003000307308ULL, 0x000ff00000000800ULL,
0x0000003100317308ULL, 0x000ee20000000800ULL, 0x000000070c00720bULL, 0x020fc80003f1e000ULL,
0x0000000c07097208ULL, 0x002fc60004000000ULL, 0x0000002c00147308ULL, 0x000fe40000000800ULL,
0x0c201f00090c7f89ULL, 0x000e6c00000e0000ULL, 0x0000002400077308ULL, 0x000bf00000000800ULL,
0x00000025002c7308ULL, 0x0007e20000000800ULL, 0x3c003c00ff247424ULL, 0x020fce00078e00ffULL,
0x0000000e00397308ULL, 0x000be20000000800ULL, 0x3c003c00ff257424ULL, 0x008fe200078e00ffULL,
0x0000000c0900720bULL, 0x002fc80003f1e000ULL, 0x000000090c097208ULL, 0x000fe40004000000ULL,
0x0000002d002d7308ULL, 0x000e620000000800ULL, 0x0000000d100c723eULL, 0x000fe400000000ffULL,
0x00000030310e723eULL, 0x020fe200000000ffULL, 0x3fb8aa3b091c7820ULL, 0x000fc80000410000ULL,
0x3fb8aa3b36367823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b37377823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b32327823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b33337823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe2000001081cULL,
0x0000003600367308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe2000001081cULL, 0x000000142d14723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b23237823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b26267823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b27277823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b18187823ULL, 0x100fe2000001081cULL,
0x0000003700377308ULL, 0x000e620000000800ULL, 0x3fb8aa3b19197823ULL, 0x000fce000001081cULL,
0x00000032000f7308ULL, 0x000fe20000000800ULL, 0x00000036370d723eULL, 0x002fce00000000ffULL,
0x0000003300127308ULL, 0x000e700000000800ULL, 0x0000002900297308ULL, 0x000ee20000000800ULL,
0x0000000f120f723eULL, 0x002fce00000000ffULL, 0x0000002e00157308ULL, 0x0003e20000000800ULL,
0x000000240c10723cULL, 0x000fe200000018ffULL, 0x000000162916723eULL, 0x008fcc00000000ffULL,
0x0000002f00347308ULL, 0x000ee20000000800ULL, 0x3fb8aa3b222e7823ULL, 0x002fe2000001081cULL,
0x0000000864297824ULL, 0x000fe200078e00ffULL, 0x0c401f000b227f89ULL, 0x000e6a00000e0000ULL,
0x0000002a00177308ULL, 0x000fe20000000800ULL, 0x000000153415723eULL, 0x008fce00000000ffULL,
0x0000002b00307308ULL, 0x000ef00000000800ULL, 0x0000001d00357308ULL, 0x000fe20000000800ULL,
0x000000220b00720bULL, 0x002fe40003f3e000ULL, 0x000000173017723eULL, 0x008fca00000000ffULL,
0x0000002100217308ULL, 0x000e620000000800ULL, 0x0000000b220b7208ULL, 0x000fe20004800000ULL,
0x000000241410723cULL, 0x000fec0000001810ULL, 0x00000026001d7308ULL, 0x0007f00000000800ULL,
0x00000027002a7308ULL, 0x000b620000000800ULL, 0x3fb8aa3b1e267823ULL, 0x008fe2000001081cULL,
0x00000028211e723eULL, 0x002fcc00000000ffULL, 0x0000002e002e7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1f277823ULL, 0x020fe2000001081cULL, 0x000000072c1c723eULL, 0x000fe400000000ffULL,
0x00000003ff077819ULL, 0x000fe40000011604ULL, 0x0000001d2a1d723eULL, 0x000fe400000000ffULL,
0x0000002300237308ULL, 0x000e620000000800ULL, 0x0000000307077812ULL, 0x000fce00078ec0ffULL,
0x0000001b00387308ULL, 0x0007620000000800ULL, 0x0000002e231f723eULL, 0x002fce00000000ffULL,
0x0000002600267308ULL, 0x000fe20000000800ULL, 0x0c401f000a1b7f89ULL, 0x008e6200000e0000ULL,
0x000000241c10723cULL, 0x000fe20000001810ULL, 0x000000383922723eULL, 0x020fca00000000ffULL,
0x0000002700277308ULL, 0x000ee20000000800ULL, 0x000000ffff2b7224ULL, 0x000fce00078e0022ULL,
0x0000001800187308ULL, 0x000fe20000000800ULL, 0x000000262721723eULL, 0x008fce00000000ffULL,
0x0000001900197308ULL, 0x000ee20000000800ULL, 0x0000001b0a00720bULL, 0x002fe20003f1e000ULL,
0x0000000864267836ULL, 0x000fc60000000000ULL, 0x0000000a1b0a7208ULL, 0x000fe20004000000ULL,
0x0000000107277824ULL, 0x000fe400078e0226ULL, 0x0000002000207308ULL, 0x000e620000000800ULL,
0x0000000826287824ULL, 0x000fe400078e00ffULL, 0x00000800001b7824ULL, 0x000fe400078e0202ULL,
0x00000008262d7824ULL, 0x000fe200078e00ffULL, 0xfffffff828277812ULL, 0x000fe200078ee227ULL,
0x000110001b2c7836ULL, 0x000fe20000000000ULL, 0x000000181923723eULL, 0x008fe200000000ffULL,
0x0000000864197824ULL, 0x000fe200078e00ffULL, 0x0c201f000b187f89ULL, 0x000ee200000e0000ULL,
0x0000000107647824ULL, 0x000fc400078e0264ULL, 0x000000ffff287224ULL, 0x000fe200078e001cULL,
0x0c201f000a077f89ULL, 0x000f6200000e0000ULL, 0x000000203520723eULL, 0x002fe200000000ffULL,
0x0000000464267836ULL, 0x000fe20000000000ULL, 0xfffffff819197812ULL, 0x000fe200078ee264ULL,
0x0000000c64647836ULL, 0x000fe40000000000ULL, 0x000000ffff2a7224ULL, 0x000fe200078e0020ULL,
0xfffffff8291b7812ULL, 0x000fe200078ee226ULL, 0x000000242010723cULL, 0x000fe20000001810ULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee264ULL, 0x0000001019197824ULL, 0x000fc400078e022cULL,
0x000000ffff267224ULL, 0x000fe400078e0014ULL, 0x000000101b1b7824ULL, 0x000fe400078e022cULL,
0x000000ffff247224ULL, 0x000fe400078e000cULL, 0x000000ffff257224ULL, 0x000fe200078e000eULL,
0x000000180b00720bULL, 0x008fe20003f3e000ULL, 0x000000ffff0c7224ULL, 0x000fe400078e000dULL,
0x000000ffff297224ULL, 0x000fe200078e001eULL, 0x000000070a00720bULL, 0x020fe20003f1e000ULL,
0x000000ffff0d7224ULL, 0x000fe200078e000fULL, 0x0000000b180b7208ULL, 0x000fe20004800000ULL,
0x000000ffff0e7224ULL, 0x000fe200078e0015ULL, 0x0000000a070a7208ULL, 0x000fe20004000000ULL,
0x0000001027117824ULL, 0x000fe200078e022cULL, 0x0000000304ff7812ULL, 0x000fe2000780c0ffULL,
0x000000ffff277224ULL, 0x000fc400078e0016ULL, 0x000000ffff0f7224ULL, 0x000fe400078e0017ULL,
0x000000102d2d7824ULL, 0x000fe200078e022cULL, 0x0000002419007844ULL, 0x0003e20000000200ULL,
0x000000ffff147224ULL, 0x000fe400078e001dULL, 0x000000ffff157224ULL, 0x000fe200078e001fULL,
0x000000281b007844ULL, 0x0007e20000000200ULL, 0x000000ffff167224ULL, 0x000fe400078e0021ULL,
0x000000ffff177224ULL, 0x000fe200078e0023ULL, 0x0000000c11007844ULL, 0x0007e20000000200ULL,
0x000000ffff187224ULL, 0x000fc400078e0010ULL, 0x00000001ff077424ULL, 0x000fe200078e00ffULL,
0x000000142d007844ULL, 0x0007e20000000200ULL, 0x000000ffff197224ULL, 0x002fc600078e0012ULL,
0x017000081a008388ULL, 0x0007e80000000c00ULL, 0x017200181a008388ULL, 0x0007e20000000a00ULL,
0x0000007d6900720cULL, 0x000fe20003f06070ULL, 0x0176080770ff79a7ULL, 0x000fe2000850003fULL,
0x0176100770ff79a7ULL, 0x000fe2000850003fULL, 0x0176180770ff79a7ULL, 0x000fe2000850003fULL,
0x0176200770ff79a7ULL, 0x0003e4000850003fULL, 0x000000ffff077224ULL, 0x002fce00078e006fULL,
0xffffffac00dc8947ULL, 0x00cfea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x018000000f037836ULL, 0x000fe20000000000ULL, 0x0000013000017945ULL, 0x000fe80003800000ULL,
0x7f80000003047812ULL, 0x000fc800078ec0ffULL, 0x018000000400780cULL, 0x000fda0003f05070ULL,
0x0000000f00038308ULL, 0x0002a20000001000ULL, 0x0000000000388947ULL, 0x000fea0003800000ULL,
0x000000ff0400720cULL, 0x040fe40003f25070ULL, 0x008000000400780cULL, 0x000fe40003f02070ULL,
0x00000001ff047807ULL, 0x000fe40000800000ULL, 0x00000001ff037807ULL, 0x004fc80004000000ULL,
0x0000000304ff7212ULL, 0x000fda000780fcffULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x007fffff0fff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff037807ULL, 0x000fc80000000000ULL,
0x0000000304ff7212ULL, 0x000fe4000780c0ffULL, 0x800000000f047812ULL, 0x000fd600078ec0ffULL,
0x0080000004030812ULL, 0x000fe200078efcffULL, 0x000000ffff038224ULL, 0x000fe200078e0004ULL,
0x0000000000047947ULL, 0x000fec0003800000ULL, 0x0000000f00037308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff047224ULL, 0x000fe400078e0006ULL,
0x00000000ff057424ULL, 0x000fc800078e00ffULL, 0xfffffed404707950ULL, 0x000fea0003c3ffffULL,
0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000004ULL, 0x0000000100000001ULL, 0x0000001000000008ULL, 0x0000000400000001ULL,
0x0000000800000008ULL, 0x0000000800000001ULL, 0x0000000100000001ULL, 0x0000000400000003ULL,
0x0000000300000004ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x0000000000000111ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000017bULL,
0x0000000000000577ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000006f8ULL,
0x0000000000000258ULL, 0x0000001700000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000950ULL,
0x00000000000000e0ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000a30ULL,
0x0000000000000054ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000a84ULL,
0x0000000000000660ULL, 0x0000000a00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000004000000b2ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000010e8ULL,
0x0000000000000000ULL, 0x0000000a00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000004000000e6ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000010e8ULL,
0x0000000000000048ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001130ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001180ULL,
0x0000000000012b00ULL, 0x0000001700000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000013c80ULL,
0x0000000000000048ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000013cd0ULL,
0x0000000000000400ULL, 0x0000000a00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x00000001000000f8ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000013cd0ULL,
0x0000000000000270ULL, 0x0000000a00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000400000006ULL, 0x00000000000142c0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x00000000000142c0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000001130ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001180ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000012b00ULL, 0x0000000000012b00ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000013c80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000450ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x0000000000013cd0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000270ULL,
0x0000000000000270ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_pagedKV_64_nqpkv_0_m_16_sm_90_cubin_len = 82960;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
